-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_273
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_273`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_273` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_273`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,500,'',0,'6.1','1','273','CASH','','2022-05-18 11:44:42',5,0.00,0.00,'','479','2022-05-18 11:44:42','479',0,0),(2,7000,'',0,'20','1','273','SALES','','2022-05-18 11:45:00',5,0.00,0.00,'','479','2022-05-18 11:45:00','479',0,0),(3,4000,'',0,'22','1','273','PURCHASES','','2022-05-18 11:45:18',5,0.00,0.00,'','479','2022-05-18 11:45:18','479',0,0),(4,8000,'',0,'24','1','273','PURCHASES','','2022-05-18 11:45:36',5,0.00,0.00,'','479','2022-05-18 11:45:36','479',0,0),(5,8001,'',0,'24','1','273','SALARIES & WAGES','','2022-05-18 11:46:06',5,0.00,0.00,'','479','2022-05-18 11:46:06','479',0,0),(6,2500,'',0,'2','1','273','FID POS COLLECTION-5620141491','','2022-05-25 18:20:21',5,0.00,0.00,'','479','2022-05-25 18:20:21','479',0,0),(7,2501,'',0,'2','1','273','ZNB E-BILL COLLECTION :1014717','','2022-05-25 18:21:16',5,0.00,0.00,'2022-05-27','479','2022-05-27 12:37:48','479',0,0),(8,2502,'',0,'2','1','273','ZNB-:POS 1015965368','','2022-06-21 19:42:09',5,0.00,0.00,'','479','2022-06-21 19:42:09','479',0,0),(9,2503,'',0,'2','1','273','UBA COLLECTION ACCT:-102081114','','2022-07-07 15:27:52',5,0.00,0.00,'','792','2022-07-07 15:27:52','792',0,0),(10,2504,'',0,'2','1','273','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:47:33',5,0.00,0.00,'','792','2023-02-20 14:47:33','792',0,0),(11,2505,'',0,'2','1','273','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:50:52',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:09:13','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','273','MC JOMAS GAS','MC JOMAS ','08102445689','aaranolpg@gmail.com','benin','edo','uselu park','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-21 12:02:58',5,'880','2022-05-21 12:02:58','880'),(2,'','1','273','LOWO GAS','08126733624','08126733624','lowogas@gmail.com','BENIN','EDO','UWERU JUNCTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-22 11:17:57',5,'880','2022-05-22 11:17:57','880'),(3,'','1','273','ABEL GAS','08166678170','08166678170','askforable@gmail.com','BENIN','EDO','NO 12 BESON OGEDA QUATERS','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-23 15:14:26',5,'880','2022-05-23 15:14:26','880'),(4,'','1','273','EHISBO GAS','08065950706','08065950706','saintsylver@gmail.com','benin','edo','no 3 enabulele street offtipper road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-24 09:06:48',5,'880','2022-05-24 09:06:48','880'),(5,'','1','273','CHARLY GAS','08055082127','08055082127','charlygas@gmail.com','BENIN','EDO','NO 21 ARROW I OSAYOGE STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-24 09:11:07',5,'880','2022-05-24 09:11:07','880'),(6,'','1','273','DIAMOND CROWN GAS','08134631017','08134631017','oviahon3333@gmail.com','BENIN','EDO','NO 1 ENEHIZENA STREET OLUKU QUATERS','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-24 09:32:57',5,'880','2022-05-24 09:32:57','880'),(7,'','1','273','IYKMOOR NATURAL  GAS LIMITED','08020741518','08020741518','ikeascalezenwa@gmail.com','BENIN','EDO','NO 179&45 UGBOWO LAGOS ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-24 13:31:01',5,'880','2022-05-24 13:31:01','880'),(8,'','1','273','MIKE VENTURES GAS','08036301244','08036301244','mikeventure@gmail.com','BENIN','EDO','OKHORO BY FRIENDSHIP JUNCTION ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-24 17:25:41',5,'880','2022-05-24 17:25:41','880'),(9,'','1','273','OANIS GAS','08035115163','08035115163','oanisgas@gmail.com','BENIN','EDO','OWELU OBALOSER STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-24 17:29:32',5,'880','2022-05-24 17:29:32','880'),(10,'','1','273','KINGS GAS','08051591457','08051591457','kingsgas@gmail.com','BENIN','EDO','BARRACK ROAD OPPORSITE USELU MARKET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-25 07:41:26',5,'880','2022-05-25 07:41:26','880'),(11,'','1','273','TOP GAS','07059092505','07059092505','topgas@gmail.com','BENIN','EDO','55 ADUWAWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-25 09:24:23',5,'880','2022-05-25 09:24:23','880'),(12,'','1','273','IMAFEDON GAS','09030654007','09030654007','imafedongas@gmail.com','BENIN','EDO','ADUWAWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-25 09:33:04',5,'880','2022-05-25 09:33:04','880'),(13,'','1','273','RAINCO GAS','07030689045','07030689045','collynse@yahoo.com','BENIN','EDO','country home road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-25 10:14:17',5,'880','2022-05-25 10:14:17','880'),(14,'','1','273','AIPEN GAS','08108889063','08108889063','osareakhoa@yahoo.com','BENIN','EDO','NO 7 ORONSAYE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-25 10:23:18',5,'880','2022-05-25 10:23:18','880'),(15,'','1','273','CHINEDU GAS','07035763960','07035763960','chinedugas@gmail.com','BENIN','EDO','NO 113 WASOTA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-25 10:31:37',5,'880','2022-05-25 10:31:37','880'),(16,'','1','273','ANDY GAS','08096370736','08096370736','andygas@gmail.com','BENIN','EDO','RAMAT ARMY BARRACK','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-25 11:00:33',5,'880','2022-05-25 11:00:33','880'),(17,'','1','273','VICTOR GAS','08052145452','08052145452','victorgas@gmail.com','BENIN','EDO','NO 40 SECOND WEST OPP TEXTTILE MILL ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-25 12:13:25',5,'880','2022-05-25 12:13:25','880'),(18,'','1','273','PAUL GAS','08034574845','08034574845','paulgas@gmail.com','BENIN','EDO','yan santy road oselu park','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 07:55:00',5,'880','2022-05-26 07:55:00','880'),(19,'','1','273','AGBAM GAS','08109901316','08109901316','agbamgas@gmail.com','BENIN','EDO','NO 56 LOCKING ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 07:58:19',5,'880','2022-05-26 07:58:19','880'),(20,'','1','273','JOE GAS','07035129599','07035129599','loegas@mail.com','BENIN','EDO','NO 19 EWOTUWU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 11:14:17',5,'880','2022-05-26 11:14:17','880'),(21,'','1','273','MONDAY GAS','07030601698','07030601698','mondaygas@gmail.com','BENIN','EDO','benin edo state','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 11:21:11',5,'880','2022-05-26 11:21:11','880'),(22,'','1','273','EQUALIBIRUM GAS','08069268837','08069268837','askforable@gmail.com','BENIN','EDO','NO 12 EDAYEKE AVENUE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 11:39:24',5,'880','2022-05-26 11:39:24','880'),(23,'','1','273','THE LORD GAS','08053358915','08053358915','thelordgas@gmail.com','BENIN','EDO','OPPOSITE OKHRO POLICE STATION','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 14:39:00',5,'880','2022-05-26 14:39:00','880'),(24,'','1','273','IRENWA GAS','07034659900','07034659900','irenwagas@gmail.com','BENIN','EDO','NO 19 IYOBA LOSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 17:33:58',5,'880','2022-05-26 17:33:58','880'),(25,'','1','273','PATIRIC GAS','08052145452','08052145452','patricgas@gmail.com','BENIN','EDO','NO 40 SECONDWEST','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 08:47:52',5,'880','2022-05-27 08:47:52','880'),(26,'','1','273','I.K GAS','08062520231','08062520231','akgas@gmail.com','BENIN','EDO','OGISO QUATERS OPP MM WAY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 08:59:24',5,'880','2022-05-27 09:08:37','880'),(27,'','1','273','BRIGHT GAS','08038258677','08038258677','brightgas@gmail.com','BENIN','EDO','NO 51 NEWLAGOS ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 10:23:21',5,'880','2022-05-27 10:23:21','880'),(28,'','1','273','FELIS GAS','08032478117','08032478117','felisgas@gmail.com','BENIN','EDO','LAGOS ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 10:44:29',5,'880','2022-05-27 10:44:29','880'),(29,'','1','273','JOSHUA GAS','08066677806','08066677806','joshuagas @gmail.com','BENIN','EDO','OKORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 11:25:28',5,'880','2022-05-27 11:25:28','880'),(30,'','1','273','AMOCO GAS','07035763960','07035763960','amocogas@gmail.com','BENINE','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 12:00:25',5,'880','2022-05-27 12:00:25','880'),(31,'','1','273','MUDYS GAS','08033721015','08033721015','mudysga@gmail.com','BENIN','EDO','NO13 EDO HOUSE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 12:32:14',5,'880','2022-05-27 12:32:14','880'),(32,'','1','273','BERLYN GAS','08063002007','08063002007','berlingas@gmail.com','BENIN','EDO','NO 2 ASAZUWA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 12:42:14',5,'880','2022-05-27 12:42:14','880'),(33,'','1','273','HOP GAS','08056014419','08056014419','hopgas@gmail.com','BENIN','EDO','benin','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 14:57:49',5,'880','2022-05-27 14:57:49','880'),(34,'','1','273','JOHN GAS','08102445689','08102445689','johngas@gmail.com','BENIN','EDO','NEW BENIN MARKET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-28 10:21:11',5,'880','2022-05-28 10:21:11','880'),(35,'','1','273','AD GAS','08035060203','08035060203','adgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-28 11:23:45',5,'880','2022-05-28 11:23:45','880'),(36,'','1','273','DAVID GAS','08124827619','08124827619','davidgas@gmail.com','BENIN','EDO','NO 7 OSAGE STREET ADUWAWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-28 11:35:36',5,'880','2022-05-28 11:35:36','880'),(37,'','1','273','OMA GAS','08066242661','08066242661','omagas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-28 13:25:03',5,'880','2022-05-28 13:25:03','880'),(38,'','1','273','N.G GAS','08169066011','08169066011','nggas@gmail.com','BENIN','EDO','NEW LAGOS ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-29 13:54:47',5,'880','2022-05-29 13:54:47','880'),(39,'','1','273','MERCY GAS','07030601698','07030601698','mercygas@gmail.com','BENIN','EDO','LAGOS ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-29 15:32:00',5,'880','2022-05-29 15:32:00','880'),(40,'','1','273','UGO GAS','08056421479','08056421479','ugogas@gmail.com','BENIN','EDO','NO 18 OPP EKEWA ROAD UGBUYOKO QUATERS','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-29 16:01:54',5,'880','2022-05-29 16:01:54','880'),(41,'','1','273','ANONTED GAS','08034406301','08034406301','anontedgas@gmail.com','BENIN','EDO','NO 1 U SAMARITA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 07:32:33',5,'880','2022-05-30 07:32:33','880'),(42,'','1','273','EBUKA GAS','07061050016','07061050016','ebukagas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 12:08:36',5,'880','2022-05-30 12:08:36','880'),(43,'','1','273','POWER GAS','08059491027','08059491027','powergas@gmail.com','BENIN','EDO','NO 43B ALONG ORORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 15:16:50',5,'880','2022-05-30 15:16:50','880'),(44,'','1','273','J. J GAS','08085639015','08085639015','jjgas@gmail.com','BENIN','EDO','NO 48 UROGENE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 15:34:19',5,'880','2022-05-30 15:34:19','880'),(45,'','1','273','TENIS GAS','07039255986','07039255986','tenisgas@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 18:25:00',5,'880','2022-05-30 18:25:00','880'),(46,'','1','273','SYIVESTER GAS','09035169029','09035169029','syivestergas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-02 16:48:39',5,'880','2022-06-02 16:48:39','880'),(47,'','1','273','BIESSING TEEZ GAS','08144700090','08144700090','blessingteez@gmail.com','BENIN','EDO','benin','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-03 12:34:10',5,'880','2022-06-03 12:34:10','880'),(48,'','1','273','CEPHASON GAS ','07057446662','07057446662','cephasongas@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-07 09:29:21',5,'880','2022-06-07 09:29:21','880'),(49,'','1','273','OPERATIONAL LOSE','0000','07031002826','aaranolpg@gmail.com','BENIN','EDO','BENIN LPG PLANT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-07 19:59:14',5,'880','2022-06-07 19:59:14','880'),(50,'','1','273','GIFTED GAS','08130224949','08130224949','giftedgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-08 13:51:19',5,'880','2022-06-08 13:51:19','880'),(51,'','1','273','JOHNSON GAS','07030601698','07030601698','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-09 09:57:46',5,'880','2022-06-09 09:57:46','880'),(52,'','1','273','IFAYIN GAS','07067216892','07067216892','ifayingas@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-09 11:23:04',5,'880','2022-06-09 11:23:04','880'),(53,'','1','273','ANDREW EBOSE  GAS','07030601698','07030601698','andrewebosegas@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-10 11:31:16',5,'880','2022-06-10 11:31:16','880'),(54,'','1','273','OSAXYZ GAS','08163140896','08163140896','osaxyzgas@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-11 09:50:21',5,'880','2022-06-11 09:50:21','880'),(55,'','1','273','PRIMETIME ENTERPRISES GAS','07033363906','07033363906','primetimegas@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-14 11:07:55',5,'880','2022-06-14 11:07:55','880'),(56,'','1','273','OLOYE GAS','08076126394','08076126394','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-15 09:54:51',5,'880','2022-06-15 09:54:51','880'),(57,'','1','273','OBED GAS','08025112191','08025112191','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-15 10:46:17',5,'880','2022-06-15 10:46:17','880'),(58,'','1','273','MC GAS','08158083180','08158083180','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-15 16:17:38',5,'880','2022-06-15 16:17:38','880'),(59,'','1','273','ZODAN GAS','09051125877','09051125877','zodangas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-19 14:47:27',5,'880','2022-06-19 14:47:27','880'),(60,'','1','273','CHIKATEX GAS','08061235236','08061235236','chikatexgas@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-21 12:09:11',5,'880','2022-06-21 12:09:11','880'),(61,'','1','273','DOMINION GAS','07032293978','07032293978','dominiongas@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-21 12:38:08',5,'880','2022-06-21 12:38:08','880'),(62,'','1','273','ASSURANCE GAS','07042707558','07042707558','assurancegas@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-23 17:40:56',5,'880','2022-06-23 17:40:56','880'),(63,'','1','273','YEKINI GAS','08052145452','08052145452','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-25 15:45:06',5,'880','2022-06-25 15:45:06','880'),(64,'','1','273',' A.G GAS','07030736065','07030736065','aggas@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-26 14:59:43',5,'880','2022-06-26 14:59:43','880'),(65,'','1','273','FRIDAY GAS','08142252675','08142252675','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-28 08:40:45',5,'880','2022-06-28 08:40:45','880'),(66,'','1','273','IDIA GAS','09022951132','09022951132','idagas@gmail.com','BENIN','EDO','15 USELU LAGOS ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-29 07:55:52',5,'880','2022-06-29 07:55:52','880'),(67,'','1','273','AGBONS GAS','07068529308','07068529308','agbonsgas@gmail.com','BENIN','EDO','OMIOGE SOBJAT STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-04 07:12:03',5,'880','2022-07-04 07:12:03','880'),(68,'','1','273','P U GAS','08107104309','08107104309','pugas@gmail.com','BENIN','EDO','OGPA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-06 07:57:33',5,'880','2022-07-06 07:57:33','880'),(69,'','1','273','BISHOP GAS','09157241865','09157241865','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-06 17:42:51',5,'880','2022-07-06 17:42:51','880'),(70,'','1','273','UYI GAS','08072128868','08072128868','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-07 08:13:34',5,'880','2022-07-07 08:13:34','880'),(71,'','1','273','NEDU GAS','08159494515','08159494515','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-11 10:46:03',5,'880','2022-07-11 10:46:03','880'),(72,'','1','273','SAMSON GAS','08139730283','08139730283','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-12 15:13:57',5,'880','2022-07-12 15:13:57','880'),(73,'','1','273','T J GAS','0806522994','0806522994','askforable@gmail.com','BENIN','EDO','BENIN CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-13 15:13:28',5,'880','2022-07-13 15:13:28','880'),(74,'','1','273','HERLELUYER GAS','08066077808','07031815156','herlleluya@gmail.com','BENIN','EDO','NO 3 TECHNICAL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-21 16:12:06',5,'880','2022-07-21 16:12:06','880'),(75,'','1','273','OBANOR GAS','08035804382','08035804382','obanorgas@gmail.com','BENIN','EDO','NO 5 OBANOR STREET UWELU QUATERS','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-22 07:37:26',5,'880','2022-07-22 07:37:26','880'),(76,'','1','273','OSAS GAS','08053095857','08053095857','osasgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-22 12:00:37',5,'880','2022-07-22 12:00:37','880'),(77,'','1','273','DICKSON  GAS','09155463792','09155463792','dicksongas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-22 13:20:28',5,'880','2022-07-22 13:20:28','880'),(78,'','1','273','KIZO GAS','08155599818','08155599818','kizogas@gmail.com','BENIN','EDO','NO 38B SECOND WEST OPP SILOCO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 08:29:54',5,'880','2022-07-23 08:29:54','880'),(79,'','1','273','FRANCO GAS','07031947465','07031947465','francogas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 08:35:28',5,'880','2022-07-23 08:39:27','880'),(80,'','1','273','COSSETGAS','08062312866','08062312866','cossetgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 09:45:50',5,'880','2022-07-23 09:45:50','880'),(81,'','1','273','TENNY GAS','08071182080','08071182080','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 09:52:41',5,'880','2022-07-23 09:52:41','880'),(82,'','1','273','JOHN GAS (2)','09163479682','09163479682','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 09:57:51',5,'880','2022-07-23 09:57:51','880'),(83,'','1','273','OSAS GAS (2)','08034374937','08034344937','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 10:15:45',5,'880','2022-07-23 10:15:45','880'),(84,'','1','273','KENNETH GAS','07046775470','07046775470','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 10:42:30',5,'880','2022-07-23 10:42:30','880'),(85,'','1','273','EHIS GAS','08109901316','08109901316','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 11:08:42',5,'880','2022-07-23 11:08:42','880'),(86,'','1','273','OWEN GAS','08056731224','08056731224','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 12:13:59',5,'880','2022-07-23 12:13:59','880'),(87,'','1','273','STEM GAS','08024870754','08024870754','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-25 08:46:07',5,'880','2022-07-25 08:46:07','880'),(88,'','1','273','OMOBOGIE GAS','08149626185','08149626185','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-25 08:57:56',5,'880','2022-07-25 08:57:56','880'),(89,'','1','273','NERO GAS','08103495838','08103495838','aaranolpg@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-25 11:51:54',5,'880','2022-07-25 11:51:54','880'),(90,'','1','273','JOHN TROUBLE GAS','09050225662','09050225662','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-26 11:34:16',5,'880','2022-07-26 11:34:16','880'),(91,'','1','273','M . CLEL','08115251157','08115251157','tenisgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-27 08:11:41',5,'880','2022-07-27 08:11:41','880'),(92,'','1','273','LUCKY GAS','08051000884','08051000884','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-27 10:40:15',5,'880','2022-07-27 10:40:15','880'),(93,'','1','273','FRANK GAS','08068940050','08068940050','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-27 10:44:01',5,'880','2022-07-27 10:44:01','880'),(94,'','1','273','GABRIEL GAS','09083685131','09083685131','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-27 13:13:41',5,'880','2022-07-27 13:13:41','880'),(95,'','1','273','P H GAS','09035290647','09035290647','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-28 08:37:37',5,'880','2022-07-28 08:37:37','880'),(96,'','1','273','GODSPOWER GAS','09044928315','09044928315','aaranolpg@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-28 08:39:44',5,'880','2022-07-28 08:39:44','880'),(97,'','1','273','EVANS GAS','08075230129','08075230129','evansgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-28 08:56:47',5,'880','2022-07-28 08:56:47','880'),(98,'','1','273','SPAAJIC GAS','08053680708','08053680708','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-28 10:00:03',5,'880','2022-07-28 10:00:03','880'),(99,'','1','273','SAINT AJAX OIL AND GAS ','08063363228','08063363228','akgas@gmail.com','BENIN','EDO','BENIN\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-28 12:54:07',5,'880','2022-07-28 12:54:07','880'),(100,'','1','273','NELSON GAS','07033093510','07033093510','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-29 17:03:15',5,'880','2022-07-29 17:03:15','880'),(101,'','1','273','MONO LIGHT GAS ','09159826661','09159826661','tenisgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-30 16:25:04',5,'880','2022-07-30 16:25:04','880'),(102,'','1','273','CITY BOY','07030601698','07030601698','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-01 08:39:42',5,'880','2022-08-01 08:39:42','880'),(103,'','1','273','DANDY GAS','07046568180','07046568180','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-01 12:37:57',5,'880','2022-08-01 12:37:57','880'),(104,'','1','273','FAVOUR GAS','08128282264','08128282264','tenisgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-02 07:34:44',5,'880','2022-08-02 07:34:44','880'),(105,'','1','273','AV VINCENT GAS','07030601698','07030601698','felisgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-02 07:58:36',5,'880','2022-08-02 07:58:36','880'),(106,'','1','273','ESTHER GAS','08068554788','08068554788','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-02 11:19:40',5,'880','2022-08-02 11:19:40','880'),(107,'','1','273','MIRACLE GAS','07061168281','07061168281','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-02 16:09:51',5,'880','2022-08-02 16:09:51','880'),(108,'','1','273','ELIS GAS','07034590571','07034590571','tenisgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-03 08:09:37',5,'880','2022-08-03 08:09:37','880'),(109,'','1','273','OSAKPOLOR GAS','07055155858','07055155858','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-03 14:18:43',5,'880','2022-08-03 14:18:43','880'),(110,'','1','273','GB GAS','07067607098','07067607098','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-03 15:07:12',5,'880','2022-08-03 15:07:12','880'),(111,'','1','273','HOPE GAS','09034076651','09034076651','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-06 10:28:21',5,'880','2022-08-06 10:28:21','880'),(112,'','1','273','LADY V GAS','08086955761','0808695561','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-08 08:18:18',5,'880','2022-08-08 08:18:18','880'),(113,'','1','273','CLIFFORD GAS','08078673957','08078673957','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-08 11:44:37',5,'880','2022-08-08 11:44:37','880'),(114,'','1','273','N.D GAS ','08067425832','08067425832','aaranolpg@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-09 07:12:50',5,'880','2022-08-09 07:12:50','880'),(115,'','1','273','IMADE GAS','08157807033','08157807033','askforable@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-10 09:00:57',5,'880','2022-08-10 09:00:57','880'),(116,'','1','273','ETIN GAS','08141968306','08141968306','tenisgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-10 09:16:13',5,'880','2022-08-10 09:16:13','880'),(117,'','1','273','OGIDIGIDI GAS','07065664042','07065664042','tenisgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-12 08:08:28',5,'880','2022-08-12 08:08:28','880'),(118,'','1','273','SAMPEE HAS','07060590044','07070590044','sampee@gmail.com','Benin','Edo','Benin','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-27 10:03:25',5,'880','2022-08-27 10:03:25','880'),(119,'','1','273','KELVIN GAS ','07060590044','08081673927','kevin @gmail.com','Benin','Edo','Benin ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-05 17:15:40',5,'880','2022-09-05 17:15:40','880'),(120,'','1','273','PPRH GAS','08054756737','08054756737','pprh@gmail.com','BENIN','EDO','benin','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-12 17:12:19',5,'880','2022-09-12 17:12:19','880'),(121,'','1','273','OZZY GAS','08035700967','08035700967','ozzygas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-18 17:38:12',5,'880','2022-09-18 17:38:12','880'),(122,'','1','273','COLLINS GAS','07063775362','07063775362','collins@gmail.com','BENIN','EDO','benin','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-25 14:01:53',5,'880','2022-10-25 14:01:53','880'),(123,'','1','273','I.J.C GAS','08160382602','08160382602','ijcgas@gmail.com','BENIN','EDO','benin','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-26 10:11:52',5,'880','2022-10-26 10:11:52','880'),(124,'','1','273','FREVIAL GAS','08065252308','08065252308','frevail@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-15 06:35:55',5,'880','2022-11-15 06:35:55','880'),(125,'','1','273','OMEGA REST GAS','08035721138','08080405364','omegarest@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-15 08:20:30',5,'880','2022-11-15 08:20:30','880'),(126,'','1','273','HAPPINESS GAS ','08164302812','08164302812','happiness@gmail.com','BENIN','EDO','benin','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-16 13:34:33',5,'880','2022-11-16 13:34:33','880'),(127,'','1','273','EMY GAS','09064814111','09064814111','emygas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-19 08:37:49',5,'880','2022-11-19 08:37:49','880'),(128,'','1','273','EVER LASTING GAS','07036964547','07036964547','everlasting@gmail.com','BENIN','EDO','EKOSODIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-21 16:36:29',5,'880','2022-11-21 16:36:29','880'),(129,'','1','273','PETER GAS','08028407394','08028407394','peter@gmail.com','BENIN','EDO','NO 30 BANDI ROAD ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-24 07:19:34',5,'880','2022-11-24 07:19:34','880'),(130,'','1','273','O2 GAS','09165442721','09165442721','02gas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-24 09:26:10',5,'880','2022-11-24 09:26:10','880'),(131,'','1','273','FAITH GAS','08154170047','08154170047','faithgas@gmail.com','BENIN','EDO','DOWN OKHORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-24 09:47:13',5,'880','2022-11-24 09:47:13','880'),(132,'','1','273','OSARUMWENSE GAS','08143220402','08143220402','osarumwense@gmail.com','BENIN','EDO','NO 11 OTABO STREET BACK OF UWELU MAKRET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-28 09:55:41',5,'880','2022-11-28 09:55:41','880'),(133,'','1','273','SOLOJEY GAS','07088730036','07088730036','solojey@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-29 09:08:01',5,'880','2022-11-29 09:08:01','880'),(134,'','1','273','SUNNY GAS','09161853770','09161853770','sunnygas@gmail.com','BENIN','EDO','NO1  OROBO STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-30 12:41:40',5,'880','2022-11-30 12:41:40','880'),(135,'','1','273','ADEESTER GAS','07032092314','07032092314','adesster@gmail.com','BENIN','EDO','NO 2 CAMPBRITE JUNCTION ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-06 17:22:55',5,'880','2022-12-06 17:22:55','880'),(136,'','1','273','EDES GAS ','08051775251','08105716164','edesgas@gamail.com','BENIN','EDO','second semetry','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-10 17:08:12',5,'880','2022-12-10 17:08:12','880'),(137,'','1','273','ESEMUELE ISALAH','08058955517','08058955517','omegarest@gmail.com','BENIN','EDO','23 ADUWAWA ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-01-09 16:39:41',0,'880','2023-01-09 16:39:41','880'),(138,'','1','273','JULUST GAS','08067544641','08067544641','julustgas@gmail.com','Benin','Edo','No 7b aghahedo off textile mill road','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-10 17:22:39',5,'880','2023-01-10 17:22:39','880'),(139,'','1','273','O.G GAS','08030821652','08030821652','nasirumusa6535@gmail.com','BENIN','EDO','159 SENSIVE ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-13 08:47:01',5,'880','2023-01-13 08:47:01','880'),(140,'','1','273','JOLLY GAS','07030023491','07030023491','nasirumusa6535@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-16 07:55:52',5,'880','2023-01-16 07:55:52','880'),(141,'','1','273','WUMI GAS','08066294267','08066294267','nasirumusa6535@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-16 17:32:57',5,'880','2023-01-16 17:32:57','880'),(142,'','1','273','ISAIAH GAS','08058955517','08058955517','isaiahgas@gmail.com','BENIN','EDO','OSAGHA STREET USELU NO 8','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-17 10:04:16',5,'880','2023-01-17 10:04:16','880'),(143,'','1','273','JAPHETH JAN','07030353206','07030353206','isaiahgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-19 14:10:29',5,'880','2023-01-19 14:10:29','880'),(144,'','1','273','DIVINE GRACE','08119026051','08119026051','isaiahgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-19 17:26:49',5,'880','2023-01-19 17:26:49','880'),(145,'','1','273','GT GAS','08148179831','08148179831','isaiahgas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-19 17:34:17',5,'880','2023-01-19 17:34:17','880'),(146,'','1','273','kadis gas','08093474023','08093474023','nasirumusa6535@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-23 10:36:36',5,'880','2023-01-23 10:36:36','880'),(147,'','1','273','TAG GAS','07060429767','07060429767','tag@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-16 11:22:05',5,'880','2023-02-16 11:22:05','880'),(148,'','1','273','SHAGARI GAS','07038323408','07038323408','shagari@gmail.com','BENIN','EDO','benin','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-12 16:25:20',5,'880','2023-03-12 16:25:20','880'),(149,'','1','273','JONATHAN GAS ','08133481839','08133481839','jonathangas@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-14 08:17:35',5,'880','2023-03-14 08:17:35','880'),(150,'','1','273','FRANK IJBINS GAS','09067498803','08110400440','pprh@gmail.com','BENIN','EDO','BENIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-20 07:18:43',5,'880','2023-03-20 07:18:43','880');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
INSERT INTO `customers_status` VALUES (1,'1','273','137',0,'HE STOP COMING','2023-01-14 11:28:35');
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','273',1,'1',16538.06,1.00,'2022-07-20','new','2022-07-20 21:43:23','483','483',2022,'483','2022-07-20 21:43:23',5),('1','273',2,'1',24855.00,16528.00,'2022-07-20','new','2022-07-20 21:46:07','483','483',2022,'483','2022-07-20 21:46:07',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','273','1',1,'5','LPG NOZZLE 1',5345.76,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','273','1',2,'5','LPG NOZZLE 2',138623.66,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','273','1',3,'5','LPG NOZZLE 3',274957.11,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','273','1',4,'5','LPG NOZZLE 4',185605.41,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','273','1',5,'5','LPG NOZZLE 5',121782.74,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','273','1',6,'5','LPG NOZZLE 6',102488.43,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=323 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','273',1,'DAILY SHIFT','2022-05-19','2022-05-19 12:21:01','2022-05-20 12:21:01','880',0.00,0.00,'880','2022-05-19 18:27:50','880','2022-05-19 18:28:10',10,0),('1','273',2,'DAILY SHIFT','2022-05-20','2022-05-20 06:28:55','2022-05-21 06:28:55','880',0.00,0.00,'880','2022-05-20 20:07:51','880','2022-05-20 20:08:50',10,0),('1','273',3,'DAILY SHIFT','2022-05-21','2022-05-21 06:51:47','2022-05-22 06:51:47','880',0.00,0.00,'880','2022-05-21 19:04:19','880','2022-05-21 19:04:36',10,0),('1','273',4,'DAILY SHIFT','2022-05-22','2022-05-22 06:45:17','2022-05-23 06:45:17','880',0.00,0.00,'880','2022-05-22 18:53:51','880','2022-05-22 18:54:10',10,0),('1','273',5,'DAILY SHIFT','2022-05-23','2022-05-23 07:36:58','2022-05-24 07:36:58','880',0.00,0.00,'880','2022-05-23 19:22:24','880','2022-05-23 19:22:47',10,0),('1','273',6,'DAILY SHIFT','2022-05-24','2022-05-24 06:44:25','2022-05-25 06:44:25','880',0.00,0.00,'880','2022-05-24 20:19:44','880','2022-05-24 20:20:09',10,0),('1','273',7,'DAILY SHIFT','2022-05-25','2022-05-25 06:48:24','2022-05-26 06:48:24','880',0.00,0.00,'880','2022-05-25 19:34:05','880','2022-05-25 19:34:29',10,0),('1','273',8,'DAILY SHIFT','2022-05-26','2022-05-26 06:30:22','2022-05-27 06:30:22','880',0.00,0.00,'880','2022-05-26 19:28:20','880','2022-05-26 19:28:47',10,0),('1','273',9,'DAILY SHIFT','2022-05-27','2022-05-27 06:41:09','2022-05-28 06:41:09','880',0.00,0.00,'880','2022-05-27 18:57:06','880','2022-05-27 18:57:26',10,0),('1','273',10,'DAILY SHIFT','2022-05-28','2022-05-28 06:44:56','2022-05-29 06:44:56','880',0.00,0.00,'880','2022-05-28 19:47:03','880','2022-05-28 19:47:21',10,0),('1','273',11,'DAILY SHIFT','2022-05-29','2022-05-29 06:52:33','2022-05-30 06:52:33','880',0.00,0.00,'880','2022-05-29 18:53:14','880','2022-05-29 18:53:33',10,0),('1','273',12,'DAILY SHIFT','2022-05-30','2022-05-30 06:45:12','2022-05-31 06:45:12','880',0.00,0.00,'880','2022-05-30 20:40:09','880','2022-05-30 20:52:32',10,0),('1','273',13,'DAILY SHIFT','2022-05-30','2022-05-30 20:52:55','2022-05-31 20:52:55','880',0.00,0.00,'880','2022-05-30 20:55:35','880','2022-05-30 20:56:41',10,0),('1','273',14,'DAILY SHIFT','2022-05-30','2022-05-31 06:51:08','2022-06-01 06:51:08','880',0.00,0.00,'880','2022-05-31 07:17:48','880','2022-05-31 07:18:06',10,0),('1','273',15,'DAILY SHIFT','2022-05-31','2022-05-31 07:18:29','2022-06-01 07:18:29','880',0.00,0.00,'880','2022-05-31 17:01:36','880','2022-05-31 17:01:52',10,0),('1','273',16,'DAILY SHIFT','2022-06-02','2022-06-02 09:22:12','2022-06-03 09:22:12','880',0.00,0.00,'880','2022-06-02 18:48:43','880','2022-06-02 18:49:00',10,0),('1','273',17,'DAILY SHIFT','2022-06-03','2022-06-03 06:49:37','2022-06-04 06:49:37','880',0.00,0.00,'880','2022-06-03 18:50:53','880','2022-06-03 18:51:14',10,0),('1','273',18,'DAILY SHIFT','2022-06-04','2022-06-04 07:02:41','2022-06-05 07:02:41','880',0.00,0.00,'880','2022-06-04 18:21:15','880','2022-06-04 18:21:32',10,0),('1','273',19,'DAILY SHIFT','2022-06-05','2022-06-05 07:08:00','2022-06-06 07:08:00','880',0.00,0.00,'880','2022-06-05 18:21:46','880','2022-06-05 18:22:02',10,0),('1','273',20,'DAILY SHIFT','2022-06-06','2022-06-06 06:54:17','2022-06-07 06:54:17','880',0.00,0.00,'880','2022-06-06 19:21:04','880','2022-06-06 19:21:21',10,0),('1','273',21,'DAILY SHIFT','2022-06-07','2022-06-07 06:53:03','2022-06-08 06:53:03','880',0.00,0.00,'880','2022-06-07 18:51:49','880','2022-06-07 18:52:12',10,0),('1','273',22,'DAILY SHIFT','2022-06-07','2022-06-07 19:43:28','2022-06-08 19:43:28','880',0.00,0.00,'880','2022-06-07 21:25:19','880','2022-06-07 21:25:37',10,0),('1','273',23,'DAILY SHIFT','2022-06-08','2022-06-08 07:01:33','2022-06-09 07:01:33','880',0.00,0.00,'880','2022-06-08 18:55:33','880','2022-06-08 18:55:52',10,0),('1','273',24,'DAILY SHIFT','2022-06-09','2022-06-09 06:51:26','2022-06-10 06:51:26','880',0.00,0.00,'880','2022-06-09 18:35:56','880','2022-06-09 18:36:13',10,0),('1','273',25,'DAILY SHIFT','2022-06-10','2022-06-10 06:46:22','2022-06-11 06:46:22','880',0.00,0.00,'880','2022-06-10 18:33:49','880','2022-06-10 18:34:20',10,0),('1','273',26,'DAILY SHIFT','2022-06-11','2022-06-11 07:15:56','2022-06-12 07:15:56','880',0.00,0.00,'880','2022-06-11 18:26:35','880','2022-06-11 18:26:58',10,0),('1','273',27,'DAILY SHIFT','2022-06-12','2022-06-12 07:11:45','2022-06-13 07:11:45','880',0.00,0.00,'880','2022-06-12 18:29:08','880','2022-06-12 18:29:41',10,0),('1','273',28,'DAILY SHIFT','2022-06-13','2022-06-13 06:59:21','2022-06-14 06:59:21','880',0.00,0.00,'880','2022-06-13 18:47:38','880','2022-06-13 18:47:56',10,0),('1','273',29,'DAILY SHIFT','2022-06-14','2022-06-14 07:02:37','2022-06-15 07:02:37','880',0.00,0.00,'880','2022-06-14 19:08:01','880','2022-06-14 19:08:15',10,0),('1','273',30,'DAILY SHIFT','2022-06-15','2022-06-15 07:06:18','2022-06-16 07:06:18','880',0.00,0.00,'880','2022-06-15 18:57:19','880','2022-06-15 18:57:37',10,0),('1','273',31,'DAILY SHIFT','2022-06-16','2022-06-16 06:48:39','2022-06-17 06:48:39','880',0.00,0.00,'880','2022-06-16 18:52:30','880','2022-06-16 18:52:46',10,0),('1','273',32,'DAILY SHIFT','2022-06-17','2022-06-17 07:02:31','2022-06-18 07:02:31','880',0.00,0.00,'880','2022-06-17 18:59:37','880','2022-06-17 18:59:56',10,0),('1','273',33,'DAILY SHIFT','2022-06-18','2022-06-18 06:58:26','2022-06-19 06:58:26','880',0.00,0.00,'880','2022-06-18 14:28:31','880','2022-06-18 14:28:47',10,0),('1','273',34,'DAILY SHIFT','2022-06-18','2022-06-18 14:29:08','2022-06-19 14:29:08','880',0.00,0.00,'880','2022-06-18 15:00:30','880','2022-06-18 15:00:46',10,0),('1','273',35,'DAILY SHIFT','2022-06-18','2022-06-18 15:01:06','2022-06-19 15:01:06','880',0.00,0.00,'880','2022-06-18 15:06:32','880','2022-06-18 15:06:53',10,0),('1','273',36,'DAILY SHIFT','2022-06-19','2022-06-19 07:15:29','2022-06-20 07:15:29','880',0.00,0.00,'880','2022-06-19 18:56:29','880','2022-06-19 18:57:31',10,0),('1','273',37,'DAILY SHIFT','2022-06-20','2022-06-20 07:42:04','2022-06-21 07:42:04','880',0.00,0.00,'880','2022-06-20 18:48:06','880','2022-06-20 18:48:36',10,0),('1','273',38,'DAILY SHIFT','2022-06-21','2022-06-21 06:48:58','2022-06-22 06:48:58','880',0.00,0.00,'880','2022-06-21 18:42:19','880','2022-06-21 18:42:37',10,0),('1','273',39,'DAILY SHIFT','2022-06-22','2022-06-22 06:51:58','2022-06-23 06:51:58','880',0.00,0.00,'880','2022-06-22 18:46:52','880','2022-06-22 18:47:20',10,0),('1','273',40,'DAILY SHIFT','2022-06-23','2022-06-23 06:47:04','2022-06-24 06:47:04','880',0.00,0.00,'880','2022-06-23 18:52:26','880','2022-06-23 18:52:44',10,0),('1','273',41,'DAILY SHIFT','2022-06-24','2022-06-24 07:00:35','2022-06-25 07:00:35','880',0.00,0.00,'880','2022-06-24 18:50:51','880','2022-06-24 18:51:15',10,0),('1','273',42,'DAILY SHIFT','2022-06-25','2022-06-25 07:08:47','2022-06-26 07:08:47','880',0.00,0.00,'880','2022-06-25 18:42:30','880','2022-06-25 18:42:47',10,0),('1','273',43,'DAILY SHIFT','2022-06-26','2022-06-26 07:12:54','2022-06-27 07:12:54','880',0.00,0.00,'880','2022-06-26 18:50:46','880','2022-06-26 18:51:08',10,0),('1','273',44,'DAILY SHIFT','2022-06-27','2022-06-27 06:51:16','2022-06-28 06:51:16','880',0.00,0.00,'880','2022-06-27 19:01:29','880','2022-06-27 19:01:47',10,0),('1','273',45,'DAILY SHIFT','2022-06-28','2022-06-28 07:07:44','2022-06-29 07:07:44','880',0.00,0.00,'880','2022-06-28 18:48:28','880','2022-06-28 18:49:50',10,0),('1','273',46,'DAILY SHIFT','2022-06-29','2022-06-29 06:59:06','2022-06-30 06:59:06','880',0.00,0.00,'880','2022-06-29 19:02:51','880','2022-06-29 19:03:10',10,0),('1','273',47,'DAILY SHIFT','2022-06-30','2022-06-30 06:53:55','2022-07-01 06:53:55','880',0.00,0.00,'880','2022-06-30 18:44:40','880','2022-06-30 18:44:58',10,0),('1','273',48,'DAILY SHIFT','2022-07-01','2022-07-01 06:58:40','2022-07-02 06:58:40','880',0.00,0.00,'880','2022-07-01 15:42:56','880','2022-07-01 15:43:13',10,0),('1','273',49,'DAILY SHIFT','2022-07-02','2022-07-02 06:50:28','2022-07-03 06:50:28','880',0.00,0.00,'880','2022-07-02 19:04:02','880','2022-07-02 19:04:18',10,0),('1','273',50,'DAILY SHIFT','2022-07-03','2022-07-03 07:53:07','2022-07-04 07:53:07','880',0.00,0.00,'880','2022-07-03 18:37:44','880','2022-07-03 18:38:01',10,0),('1','273',51,'DAILY SHIFT','2022-07-04','2022-07-04 06:55:22','2022-07-05 06:55:22','880',0.00,0.00,'880','2022-07-04 17:41:36','880','2022-07-04 17:41:56',10,0),('1','273',52,'DAILY SHIFT','2022-07-05','2022-07-05 06:37:22','2022-07-06 06:37:22','880',0.00,0.00,'880','2022-07-05 18:40:58','880','2022-07-05 18:41:20',10,0),('1','273',53,'DAILY SHIFT','2022-07-06','2022-07-06 06:45:59','2022-07-07 06:45:59','880',0.00,0.00,'880','2022-07-06 19:13:37','880','2022-07-06 19:13:54',10,0),('1','273',54,'DAILY SHIFT','2022-07-07','2022-07-07 06:51:37','2022-07-08 06:51:37','880',0.00,0.00,'880','2022-07-07 18:43:37','880','2022-07-07 18:43:54',10,0),('1','273',55,'DAILY SHIFT','2022-07-08','2022-07-08 07:36:00','2022-07-09 07:36:00','880',0.00,0.00,'880','2022-07-08 18:45:37','880','2022-07-08 18:45:57',10,0),('1','273',56,'DAILY SHIFT','2022-07-09','2022-07-09 07:03:20','2022-07-10 07:03:20','880',0.00,0.00,'880','2022-07-09 18:51:03','880','2022-07-09 18:51:20',10,0),('1','273',57,'DAILY SHIFT','2022-07-10','2022-07-10 06:51:23','2022-07-11 06:51:23','880',0.00,0.00,'880','2022-07-10 18:57:59','880','2022-07-10 18:58:18',10,0),('1','273',58,'DAILY SHIFT','2022-07-11','2022-07-11 07:05:07','2022-07-12 07:05:07','880',0.00,0.00,'880','2022-07-11 18:40:52','880','2022-07-11 18:41:08',10,0),('1','273',59,'DAILY SHIFT','2022-07-12','2022-07-12 06:59:14','2022-07-13 06:59:14','880',0.00,0.00,'880','2022-07-12 18:31:27','880','2022-07-12 18:31:47',10,0),('1','273',60,'DAILY SHIFT','2022-07-13','2022-07-13 06:55:31','2022-07-14 06:55:31','880',0.00,0.00,'880','2022-07-13 18:47:28','880','2022-07-13 18:47:55',10,0),('1','273',61,'DAILY SHIFT','2022-07-14','2022-07-14 06:41:48','2022-07-15 06:41:48','880',0.00,0.00,'880','2022-07-14 17:18:56','880','2022-07-14 17:19:16',10,0),('1','273',62,'DAILY SHIFT','2022-07-15','2022-07-15 07:09:59','2022-07-16 07:09:59','880',0.00,0.00,'880','2022-07-15 19:13:00','880','2022-07-15 19:13:15',10,0),('1','273',63,'DAILY SHIFT','2022-07-16','2022-07-16 06:46:35','2022-07-17 06:46:35','880',0.00,0.00,'880','2022-07-16 18:39:41','880','2022-07-16 18:39:59',10,0),('1','273',64,'DAILY SHIFT','2022-07-17','2022-07-17 06:58:36','2022-07-18 06:58:36','880',0.00,0.00,'880','2022-07-17 18:36:51','880','2022-07-17 18:37:06',10,0),('1','273',65,'DAILY SHIFT','2022-07-18','2022-07-18 06:56:28','2022-07-19 06:56:28','880',0.00,0.00,'880','2022-07-18 18:32:17','880','2022-07-18 18:32:39',10,0),('1','273',66,'DAILY SHIFT','2022-07-19','2022-07-19 06:26:00','2022-07-20 06:26:00','880',0.00,0.00,'880','2022-07-19 18:46:37','880','2022-07-19 18:46:52',10,0),('1','273',67,'DAILY SHIFT','2022-07-20','2022-07-20 06:46:21','2022-07-21 06:46:21','880',0.00,0.00,'880','2022-07-20 18:35:51','880','2022-07-20 18:36:08',10,0),('1','273',68,'daily shift','2022-07-20','2022-07-20 21:47:53','2022-07-21 21:47:53','483',0.00,0.00,'483','2022-07-20 21:49:14','483','2022-07-20 21:49:35',10,0),('1','273',69,'DAILY SHIFT','2022-07-21','2022-07-21 06:26:33','2022-07-22 06:26:33','880',0.00,0.00,'880','2022-07-21 19:22:33','880','2022-07-21 19:22:49',10,0),('1','273',70,'DAILY SHIFT','2022-07-22','2022-07-22 05:58:39','2022-07-23 05:58:39','880',0.00,0.00,'880','2022-07-22 18:36:41','880','2022-07-22 18:37:14',10,0),('1','273',71,'DAILY SHIFT','2022-07-23','2022-07-23 06:59:45','2022-07-24 06:59:45','880',0.00,0.00,'880','2022-07-23 18:39:23','880','2022-07-23 18:39:38',10,0),('1','273',72,'DAILY SHIFT','2022-07-24','2022-07-24 06:08:19','2022-07-25 06:08:19','880',0.00,0.00,'880','2022-07-24 18:35:01','880','2022-07-24 18:35:19',10,0),('1','273',73,'DAILY SHIFT','2022-07-25','2022-07-25 06:35:46','2022-07-26 06:35:46','880',0.00,0.00,'880','2022-07-25 16:15:45','880','2022-07-25 16:16:01',10,0),('1','273',74,'AFTERNOON','2022-07-25','2022-07-25 16:16:51','2022-07-26 16:16:51','880',0.00,0.00,'880','2022-07-25 16:24:35','880','2022-07-25 16:24:52',10,0),('1','273',75,'DAILY SHIFT','2022-07-26','2022-07-26 10:38:14','2022-07-27 10:38:14','880',0.00,0.00,'880','2022-07-26 18:22:36','880','2022-07-26 18:22:56',10,0),('1','273',76,'DAILY SHIFT','2022-07-27','2022-07-27 06:31:41','2022-07-28 06:31:41','880',0.00,0.00,'880','2022-07-27 18:37:34','880','2022-07-27 18:37:50',10,0),('1','273',77,'DAILY SHIFT','2022-07-28','2022-07-28 06:02:19','2022-07-29 06:02:19','880',0.00,0.00,'880','2022-07-28 18:37:44','880','2022-07-28 18:37:59',10,0),('1','273',78,'DAILY SHIFT','2022-07-29','2022-07-29 06:06:08','2022-07-30 06:06:08','880',0.00,0.00,'880','2022-07-29 18:51:18','880','2022-07-29 18:51:35',10,0),('1','273',79,'DAILY SHIFT','2022-07-30','2022-07-30 06:18:20','2022-07-31 06:18:20','880',0.00,0.00,'880','2022-07-30 18:19:51','880','2022-07-30 18:20:11',10,0),('1','273',80,'DAILY SHIFT','2022-07-31','2022-07-31 06:25:00','2022-08-01 06:25:00','880',0.00,0.00,'880','2022-07-31 13:53:59','880','2022-07-31 13:54:16',10,0),('1','273',81,'AFTERNOON','2022-07-31','2022-07-31 13:55:20','2022-08-01 13:55:20','880',0.00,0.00,'880','2022-07-31 14:04:13','880','2022-07-31 14:04:30',10,0),('1','273',82,'AFTERNOON SHIFT','2022-07-31','2022-07-31 18:03:19','2022-08-01 18:03:19','880',0.00,0.00,'880','2022-07-31 18:47:49','880','2022-07-31 18:48:08',10,0),('1','273',83,'DAILY SHIFT','2022-08-01','2022-08-01 06:54:42','2022-08-02 06:54:42','880',0.00,0.00,'880','2022-08-01 18:59:32','880','2022-08-01 18:59:49',10,0),('1','273',84,'DAILY SHIFT','2022-08-02','2022-08-02 06:37:02','2022-08-03 06:37:02','880',0.00,0.00,'880','2022-08-02 19:48:25','880','2022-08-02 19:48:41',10,0),('1','273',85,'DAILY SHIFT','2022-08-03','2022-08-03 06:44:48','2022-08-04 06:44:48','880',0.00,0.00,'880','2022-08-03 19:45:12','880','2022-08-03 19:45:27',10,0),('1','273',86,'DAILY SHIFT','2022-08-04','2022-08-04 06:52:38','2022-08-05 06:52:38','880',0.00,0.00,'880','2022-08-04 10:07:05','880','2022-08-04 10:07:21',10,0),('1','273',87,'MORNING SHIFT','2022-08-04','2022-08-04 10:19:07','2022-08-05 10:19:07','880',0.00,0.00,'880','2022-08-05 10:37:48','880','2022-08-05 10:38:06',10,0),('1','273',88,'DAILY SHIFT','2022-08-05','2022-08-05 10:39:48','2022-08-06 10:39:48','880',0.00,0.00,'880','2022-08-05 19:30:58','880','2022-08-05 19:31:13',10,0),('1','273',89,'DAILY SHIFT','2022-08-06','2022-08-06 06:45:18','2022-08-07 06:45:18','880',0.00,0.00,'880','2022-08-06 19:31:44','880','2022-08-06 19:32:03',10,0),('1','273',90,'DAILY SHIFT','2022-08-07','2022-08-07 06:55:44','2022-08-08 06:55:44','880',0.00,0.00,'880','2022-08-07 18:25:06','880','2022-08-07 18:25:45',10,0),('1','273',91,'DAILY SHIFT','2022-08-08','2022-08-08 06:46:53','2022-08-09 06:46:53','880',0.00,0.00,'880','2022-08-08 19:27:32','880','2022-08-08 19:27:50',10,0),('1','273',92,'DAILY SHIFT','2022-08-09','2022-08-09 07:07:34','2022-08-10 07:07:34','880',0.00,0.00,'880','2022-08-09 10:40:27','880','2022-08-09 10:41:01',10,0),('1','273',93,'MORNING SHIFT','2022-08-09','2022-08-09 10:58:15','2022-08-10 10:58:15','880',0.00,0.00,'880','2022-08-09 11:02:02','880','2022-08-09 11:02:17',10,0),('1','273',94,'DAILY SHIFT','2022-08-10','2022-08-10 06:49:47','2022-08-11 06:49:47','880',0.00,0.00,'880','2022-08-10 18:54:21','880','2022-08-10 18:54:38',10,0),('1','273',95,'DAILY SHIFT','2022-08-11','2022-08-11 06:48:17','2022-08-12 06:48:17','880',0.00,0.00,'880','2022-08-11 19:04:41','880','2022-08-11 19:04:58',10,0),('1','273',96,'DAILY SHIFT ','2022-08-12','2022-08-12 07:03:35','2022-08-13 07:03:35','880',0.00,0.00,'880','2022-08-12 20:29:15','880','2022-08-12 20:29:31',10,0),('1','273',97,'DAILY SHIFT','2022-08-13','2022-08-13 08:47:47','2022-08-14 08:47:47','880',0.00,0.00,'880','2022-08-13 08:56:29','880','2022-08-13 08:56:51',10,0),('1','273',98,'MORNING SHIFT','2022-08-13','2022-08-13 08:57:15','2022-08-14 08:57:15','880',0.00,0.00,'880','2022-08-13 09:11:15','880','2022-08-13 09:11:33',10,0),('1','273',99,'DAILY SHIFT ','2022-08-14','2022-08-14 06:55:17','2022-08-15 06:55:17','880',0.00,0.00,'880','2022-08-14 18:31:15','880','2022-08-14 18:31:31',10,0),('1','273',100,'DAILY SHIFT ','2022-08-15','2022-08-15 06:49:38','2022-08-16 06:49:38','880',0.00,0.00,'880','2022-08-15 18:39:15','880','2022-08-15 18:39:31',10,0),('1','273',101,'DAILY SHIFT ','2022-08-16','2022-08-16 06:44:12','2022-08-17 06:44:12','880',0.00,0.00,'880','2022-08-16 19:00:48','880','2022-08-16 19:01:04',10,0),('1','273',102,'DAILY SHIFT ','2022-08-17','2022-08-17 06:49:38','2022-08-18 06:49:38','880',0.00,0.00,'880','2022-08-17 18:17:01','880','2022-08-17 18:17:18',10,0),('1','273',103,'AFTERNOON','2022-08-17','2022-08-17 18:26:28','2022-08-18 18:26:28','880',0.00,0.00,'880','2022-08-17 18:31:27','880','2022-08-17 18:31:43',10,0),('1','273',104,'DAILY SHIFT ','2022-08-19','2022-08-19 06:52:13','2022-08-20 06:52:13','880',0.00,0.00,'880','2022-08-19 19:01:09','880','2022-08-19 19:01:41',10,0),('1','273',105,'DAILY SHIFT ','2022-08-20','2022-08-20 06:50:43','2022-08-21 06:50:43','880',0.00,0.00,'880','2022-08-20 20:39:14','880','2022-08-20 20:39:29',10,0),('1','273',106,'DAILY SHIFT ','2022-08-21','2022-08-21 07:03:01','2022-08-22 07:03:01','880',0.00,0.00,'880','2022-08-21 18:43:43','880','2022-08-21 18:44:00',10,0),('1','273',107,'DAILY SHIFT ','2022-08-22','2022-08-22 06:45:15','2022-08-23 06:45:15','880',0.00,0.00,'880','2022-08-22 18:38:21','880','2022-08-22 18:38:45',10,0),('1','273',108,'DAILY SHIFT ','2022-08-23','2022-08-23 06:49:06','2022-08-24 06:49:06','880',0.00,0.00,'880','2022-08-23 08:26:38','880','2022-08-23 08:26:53',10,0),('1','273',109,'DAILY SHIFT','2022-08-25','2022-08-25 06:44:05','2022-08-26 06:44:05','880',0.00,0.00,'880','2022-08-25 06:44:42','880','2022-08-25 06:45:04',10,0),('1','273',110,'DAILY SHIFT','2022-08-25','2022-08-25 06:45:45','2022-08-26 06:45:45','880',0.00,0.00,'880','2022-08-25 18:33:42','880','2022-08-25 18:33:59',10,0),('1','273',111,'DAILY SHIFT ','2022-08-26','2022-08-26 06:50:47','2022-08-27 06:50:47','880',0.00,0.00,'880','2022-08-26 18:20:29','880','2022-08-26 18:21:02',10,0),('1','273',112,'DAILY SHIFT ','2022-08-27','2022-08-27 06:48:33','2022-08-28 06:48:33','880',0.00,0.00,'880','2022-08-27 18:29:41','880','2022-08-27 18:29:58',10,0),('1','273',113,'DAILY SHIFT ','2022-08-28','2022-08-28 06:49:29','2022-08-29 06:49:29','880',0.00,0.00,'880','2022-08-28 18:26:07','880','2022-08-28 18:27:32',10,0),('1','273',114,'DAILY SHIFT ','2022-08-29','2022-08-29 07:09:48','2022-08-30 07:09:48','880',0.00,0.00,'880','2022-08-29 19:01:20','880','2022-08-29 19:01:37',10,0),('1','273',115,'DAILY SHIFT ','2022-08-30','2022-08-30 06:50:34','2022-08-31 06:50:34','880',0.00,0.00,'880','2022-08-30 18:23:19','880','2022-08-30 18:23:38',10,0),('1','273',116,'DAILY SHIFT ','2022-08-31','2022-08-31 06:57:04','2022-09-01 06:57:04','880',0.00,0.00,'880','2022-08-31 18:23:24','880','2022-08-31 18:23:40',10,0),('1','273',117,'DAILY SHIFT ','2022-09-01','2022-09-01 06:56:08','2022-09-02 06:56:08','880',0.00,0.00,'880','2022-09-01 19:17:03','880','2022-09-01 19:18:49',10,0),('1','273',118,'DAILY SHIFT ','2022-09-02','2022-09-02 12:40:34','2022-09-03 12:40:34','880',0.00,0.00,'880','2022-09-02 18:11:39','880','2022-09-02 18:12:02',10,0),('1','273',119,'DAILY SHIFT ','2022-09-03','2022-09-03 06:56:24','2022-09-04 06:56:24','880',0.00,0.00,'880','2022-09-03 12:47:48','880','2022-09-03 12:48:05',10,0),('1','273',120,'OPERATIONAL LOSE','2022-09-03','2022-09-03 12:49:36','2022-09-04 12:49:36','880',0.00,0.00,'880','2022-09-03 12:54:14','880','2022-09-03 12:56:44',10,0),('1','273',121,'DAILY SHIFT','2022-09-04','2022-09-04 07:48:17','2022-09-05 07:48:17','880',0.00,0.00,'880','2022-09-04 18:29:48','880','2022-09-04 18:30:08',10,0),('1','273',122,'DAILY SHIFT ','2022-09-05','2022-09-05 07:00:34','2022-09-06 07:00:34','880',0.00,0.00,'880','2022-09-05 18:43:12','880','2022-09-05 18:43:26',10,0),('1','273',123,'DAILY SHIFT ','2022-09-06','2022-09-06 06:53:08','2022-09-07 06:53:08','880',0.00,0.00,'880','2022-09-06 18:42:28','880','2022-09-06 18:42:47',10,0),('1','273',124,'DAILY SHIFT ','2022-09-07','2022-09-07 06:43:26','2022-09-08 06:43:26','880',0.00,0.00,'880','2022-09-07 18:29:54','880','2022-09-07 18:30:55',10,0),('1','273',125,'DAILY SHIFT','2022-09-08','2022-09-08 06:52:01','2022-09-09 06:52:01','880',0.00,0.00,'880','2022-09-08 19:01:52','880','2022-09-08 19:02:12',10,0),('1','273',126,'DAILY SHIFT','2022-09-09','2022-09-09 06:48:04','2022-09-10 06:48:04','880',0.00,0.00,'880','2022-09-09 18:33:12','880','2022-09-09 18:33:30',10,0),('1','273',127,'DAILY SHIFT','2022-09-10','2022-09-10 06:43:41','2022-09-11 06:43:41','880',0.00,0.00,'880','2022-09-10 13:13:32','880','2022-09-10 13:18:32',10,0),('1','273',128,'OPERATIONAL LOSE','2022-09-10','2022-09-10 17:00:11','2022-09-11 17:00:11','880',0.00,0.00,'880','2022-09-10 17:09:01','880','2022-09-10 17:09:18',10,0),('1','273',129,'DAILY SHIFT','2022-09-11','2022-09-11 06:56:28','2022-09-12 06:56:28','880',0.00,0.00,'880','2022-09-11 18:25:14','880','2022-09-11 18:25:30',10,0),('1','273',130,'DAILY SHIFT','2022-09-12','2022-09-12 06:31:05','2022-09-13 06:31:05','880',0.00,0.00,'880','2022-09-12 18:34:02','880','2022-09-12 18:34:16',10,0),('1','273',131,'DAILY SHIFT 84','2022-09-13','2022-09-13 06:46:12','2022-09-14 06:46:12','880',0.00,0.00,'880','2022-09-13 18:26:52','880','2022-09-13 18:27:18',10,0),('1','273',132,'DAILY SHIFT','2022-09-14','2022-09-14 06:41:24','2022-09-15 06:41:24','880',0.00,0.00,'880','2022-09-14 18:36:44','880','2022-09-14 18:37:42',10,0),('1','273',133,'DAILY SHIFT','2022-09-15','2022-09-15 06:49:38','2022-09-16 06:49:38','880',0.00,0.00,'880','2022-09-15 18:46:05','880','2022-09-15 18:46:20',10,0),('1','273',134,'DAILY SHIFT','2022-09-16','2022-09-16 06:46:16','2022-09-17 06:46:16','880',0.00,0.00,'880','2022-09-16 18:31:20','880','2022-09-16 18:31:35',10,0),('1','273',135,'DAILY SHIFT','2022-09-17','2022-09-17 06:46:53','2022-09-18 06:46:53','880',0.00,0.00,'880','2022-09-17 18:30:13','880','2022-09-17 18:30:30',10,0),('1','273',136,'DAILY SHIFT','2022-09-18','2022-09-18 06:40:11','2022-09-19 06:40:11','880',0.00,0.00,'880','2022-09-18 18:31:49','880','2022-09-18 18:32:03',10,0),('1','273',137,'DAILY SHIFT','2022-09-19','2022-09-19 06:39:56','2022-09-20 06:39:56','880',0.00,0.00,'880','2022-09-19 16:19:32','880','2022-09-19 16:19:50',10,0),('1','273',138,'OPERATIONAL LOSE','2022-09-19','2022-09-19 17:36:28','2022-09-20 17:36:28','880',0.00,0.00,'880','2022-09-19 17:44:21','880','2022-09-19 17:44:40',10,0),('1','273',139,'DAILY SHIFT','2022-09-20','2022-09-20 06:29:19','2022-09-21 06:29:19','880',0.00,0.00,'880','2022-09-20 18:22:41','880','2022-09-20 18:23:13',10,0),('1','273',140,'DAILY SHIFT','2022-09-21','2022-09-21 06:43:17','2022-09-22 06:43:17','880',0.00,0.00,'880','2022-09-21 18:25:06','880','2022-09-21 18:25:22',10,0),('1','273',141,'DAILY SHIFT','2022-09-22','2022-09-22 06:35:38','2022-09-23 06:35:38','880',0.00,0.00,'880','2022-09-22 18:40:58','880','2022-09-22 18:41:21',10,0),('1','273',142,'DAILY SHIFT','2022-09-23','2022-09-23 06:31:05','2022-09-24 06:31:05','880',0.00,0.00,'880','2022-09-23 18:24:35','880','2022-09-23 18:25:07',10,0),('1','273',143,'DAILY SHIFT','2022-09-24','2022-09-24 06:25:06','2022-09-25 06:25:06','880',0.00,0.00,'880','2022-09-24 18:23:29','880','2022-09-24 18:23:43',10,0),('1','273',144,'DAILY SHIFT','2022-09-25','2022-09-25 06:57:06','2022-09-26 06:57:06','880',0.00,0.00,'880','2022-09-25 17:50:00','880','2022-09-25 17:50:15',10,0),('1','273',145,'DAILY SHIFT','2022-09-26','2022-09-26 06:45:11','2022-09-27 06:45:11','880',0.00,0.00,'880','2022-09-26 18:24:29','880','2022-09-26 18:24:51',10,0),('1','273',146,'DAILY SHIFT','2022-09-27','2022-09-27 06:47:01','2022-09-28 06:47:01','880',0.00,0.00,'880','2022-09-27 18:45:27','880','2022-09-27 18:45:45',10,0),('1','273',147,'OPERATIONAL LOSE','2022-09-28','2022-09-28 07:00:42','2022-09-29 07:00:42','880',0.00,0.00,'880','2022-09-28 07:15:08','880','2022-09-28 07:15:31',10,0),('1','273',148,'DAILY SHIFT','2022-09-29','2022-09-29 06:35:32','2022-09-30 06:35:32','880',0.00,0.00,'880','2022-09-29 18:49:48','880','2022-09-29 18:50:05',10,0),('1','273',149,'DAILY SHIFT','2022-09-30','2022-09-30 06:40:02','2022-10-01 06:40:02','880',0.00,0.00,'880','2022-09-30 18:37:16','880','2022-09-30 18:37:52',10,0),('1','273',150,'DAILY SHIFT','2022-10-01','2022-10-01 06:38:13','2022-10-02 06:38:13','880',0.00,0.00,'880','2022-10-01 18:46:50','880','2022-10-01 18:47:05',10,0),('1','273',151,'DAILY SHIFT','2022-10-02','2022-10-02 06:36:58','2022-10-03 06:36:58','880',0.00,0.00,'880','2022-10-02 18:21:28','880','2022-10-02 18:21:42',10,0),('1','273',152,'DAILY SHIFT ','2022-10-03','2022-10-03 06:42:16','2022-10-04 06:42:16','880',0.00,0.00,'880','2022-10-03 18:39:30','880','2022-10-03 18:39:48',10,0),('1','273',153,'DAILY SHIFT','2022-10-04','2022-10-04 06:42:26','2022-10-05 06:42:26','880',0.00,0.00,'880','2022-10-04 18:24:19','880','2022-10-04 18:24:55',10,0),('1','273',154,'DAILY SHIFT','2022-10-05','2022-10-05 06:55:41','2022-10-06 06:55:41','880',0.00,0.00,'880','2022-10-05 19:13:14','880','2022-10-05 19:13:39',10,0),('1','273',155,'DAILY SHIFT','2022-10-06','2022-10-06 06:28:29','2022-10-07 06:28:29','880',0.00,0.00,'880','2022-10-06 18:21:17','880','2022-10-06 18:21:45',10,0),('1','273',156,'DAILY SHIFT','2022-10-07','2022-10-07 06:49:43','2022-10-08 06:49:43','880',0.00,0.00,'880','2022-10-07 18:27:22','880','2022-10-07 18:27:39',10,0),('1','273',157,'DAILY SHIFT','2022-10-08','2022-10-08 06:50:57','2022-10-09 06:50:57','880',0.00,0.00,'880','2022-10-08 14:39:45','880','2022-10-08 14:40:04',10,0),('1','273',158,'OPERATIONAL LOSE','2022-10-08','2022-10-08 14:53:33','2022-10-09 14:53:33','880',0.00,0.00,'880','2022-10-08 15:06:59','880','2022-10-08 15:07:14',10,0),('1','273',159,'DAILY SHIFT','2022-10-09','2022-10-09 11:03:29','2022-10-10 11:03:29','880',0.00,0.00,'880','2022-10-09 18:22:25','880','2022-10-09 18:22:43',10,0),('1','273',160,'DAILY SHIFT','2022-10-10','2022-10-10 06:43:44','2022-10-11 06:43:44','880',0.00,0.00,'880','2022-10-10 18:19:59','880','2022-10-10 18:20:18',10,0),('1','273',161,'DAILY SHIFT','2022-10-11','2022-10-11 06:31:01','2022-10-12 06:31:01','880',0.00,0.00,'880','2022-10-11 18:27:00','880','2022-10-11 18:27:40',10,0),('1','273',162,'DAILY SHIFT','2022-10-12','2022-10-12 06:58:00','2022-10-13 06:58:00','880',0.00,0.00,'880','2022-10-12 18:23:03','880','2022-10-12 18:23:25',10,0),('1','273',163,'DAILY SHIFT','2022-10-13','2022-10-13 06:42:54','2022-10-14 06:42:54','880',0.00,0.00,'880','2022-10-13 18:20:15','880','2022-10-13 18:20:39',10,0),('1','273',164,'DAILY SHIFT','2022-10-22','2022-10-22 08:00:02','2022-10-23 08:00:02','880',0.00,0.00,'880','2022-10-22 18:36:51','880','2022-10-22 18:37:30',10,0),('1','273',165,'DAILY SHIFT','2022-10-23','2022-10-23 06:49:27','2022-10-24 06:49:27','880',0.00,0.00,'880','2022-10-23 18:19:37','880','2022-10-23 18:19:55',10,0),('1','273',166,'DAILY SHIFT','2022-10-24','2022-10-24 06:55:28','2022-10-25 06:55:28','880',0.00,0.00,'880','2022-10-24 18:59:23','880','2022-10-24 18:59:44',10,0),('1','273',167,'DAILY SHIFT','2022-10-25','2022-10-25 06:58:39','2022-10-26 06:58:39','880',0.00,0.00,'880','2022-10-25 18:22:42','880','2022-10-25 18:23:32',10,0),('1','273',168,'DAILY SHIFT','2022-10-26','2022-10-26 06:31:01','2022-10-27 06:31:01','880',0.00,0.00,'880','2022-10-26 18:29:10','880','2022-10-26 18:29:27',10,0),('1','273',169,'DAILY SHIFT','2022-10-27','2022-10-27 06:35:13','2022-10-28 06:35:13','880',0.00,0.00,'880','2022-10-27 19:05:48','880','2022-10-27 19:08:12',10,0),('1','273',170,'DAILY SHIFT','2022-10-28','2022-10-28 06:58:26','2022-10-29 06:58:26','880',0.00,0.00,'880','2022-10-28 18:24:15','880','2022-10-28 18:25:02',10,0),('1','273',171,'DAILY SHIFT','2022-10-29','2022-10-29 07:39:33','2022-10-30 07:39:33','880',0.00,0.00,'880','2022-10-29 10:10:37','880','2022-10-29 10:10:55',10,0),('1','273',172,'OPERATIONAL LOSE','2022-10-29','2022-10-29 10:18:49','2022-10-30 10:18:49','880',0.00,0.00,'880','2022-10-29 10:23:40','880','2022-10-29 10:23:56',10,0),('1','273',173,'DAILY SHIFT','2022-10-29','2022-10-29 12:56:37','2022-10-30 12:56:37','880',0.00,0.00,'880','2022-10-29 18:15:55','880','2022-10-29 18:16:30',10,0),('1','273',174,'DAILY SHIFT','2022-10-30','2022-10-30 06:51:17','2022-10-31 06:51:17','880',0.00,0.00,'880','2022-10-30 18:19:19','880','2022-10-30 18:19:39',10,0),('1','273',175,'DAILY SHIFT','2022-10-31','2022-10-31 06:58:00','2022-11-01 06:58:00','880',0.00,0.00,'880','2022-10-31 18:24:13','880','2022-10-31 18:24:35',10,0),('1','273',176,'DAILY SHIFT','2022-11-01','2022-11-01 06:23:12','2022-11-02 06:23:12','880',0.00,0.00,'880','2022-11-01 18:36:53','880','2022-11-01 18:37:11',10,0),('1','273',177,'DAILY SHIFT','2022-11-02','2022-11-02 06:52:45','2022-11-03 06:52:45','880',0.00,0.00,'880','2022-11-02 18:27:28','880','2022-11-02 18:27:50',10,0),('1','273',178,'DAILY SHIFT','2022-11-03','2022-11-03 06:40:35','2022-11-04 06:40:35','880',0.00,0.00,'880','2022-11-03 18:32:22','880','2022-11-03 18:32:43',10,0),('1','273',179,'DAILY SHIFT','2022-11-04','2022-11-04 06:46:03','2022-11-05 06:46:03','880',0.00,0.00,'880','2022-11-04 18:14:07','880','2022-11-04 18:14:39',10,0),('1','273',180,'DAILY SHIFT','2022-11-05','2022-11-05 08:02:34','2022-11-06 08:02:34','880',0.00,0.00,'880','2022-11-05 18:20:34','880','2022-11-05 18:20:52',10,0),('1','273',181,'DAILY SHIFT','2022-11-06','2022-11-06 07:48:01','2022-11-07 07:48:01','880',0.00,0.00,'880','2022-11-06 18:17:55','880','2022-11-06 18:18:41',10,0),('1','273',182,'DAILY SHIFT','2022-11-07','2022-11-07 06:41:29','2022-11-08 06:41:29','880',0.00,0.00,'880','2022-11-07 18:31:51','880','2022-11-07 18:32:35',10,0),('1','273',183,'DAILY SHIFT','2022-11-08','2022-11-08 07:10:19','2022-11-09 07:10:19','880',0.00,0.00,'880','2022-11-08 18:35:16','880','2022-11-08 18:35:33',10,0),('1','273',184,'DAILY SHIFT','2022-11-09','2022-11-09 06:45:49','2022-11-10 06:45:49','880',0.00,0.00,'880','2022-11-09 18:28:03','880','2022-11-09 18:28:20',10,0),('1','273',185,'DAILY SHIFT','2022-11-10','2022-11-10 06:51:09','2022-11-11 06:51:09','880',0.00,0.00,'880','2022-11-10 10:37:09','880','2022-11-10 10:37:28',10,0),('1','273',186,'OPERATIONAL LOSE','2022-11-10','2022-11-10 10:39:40','2022-11-11 10:39:40','880',0.00,0.00,'880','2022-11-10 10:44:52','880','2022-11-10 10:45:08',10,0),('1','273',187,'DAILY SHIFT','2022-11-12','2022-11-12 07:12:39','2022-11-13 07:12:39','880',0.00,0.00,'880','2022-11-12 19:03:56','880','2022-11-12 19:04:19',10,0),('1','273',188,'DAILY SHIFT','2022-11-13','2022-11-13 06:43:34','2022-11-14 06:43:34','880',0.00,0.00,'880','2022-11-13 18:24:17','880','2022-11-13 18:24:44',10,0),('1','273',189,'DAILY SHIFT','2022-11-14','2022-11-14 06:46:50','2022-11-15 06:46:50','880',0.00,0.00,'880','2022-11-14 18:23:37','880','2022-11-14 18:23:58',10,0),('1','273',190,'DAILY SHIFT','2022-11-15','2022-11-15 06:30:33','2022-11-16 06:30:33','880',0.00,0.00,'880','2022-11-15 18:29:08','880','2022-11-15 18:29:26',10,0),('1','273',191,'DAILY SHIFT','2022-11-16','2022-11-16 06:34:59','2022-11-17 06:34:59','880',0.00,0.00,'880','2022-11-16 18:37:16','880','2022-11-16 18:37:37',10,0),('1','273',192,'DAILY SHIFT','2022-11-17','2022-11-17 06:19:27','2022-11-18 06:19:27','880',0.00,0.00,'880','2022-11-17 10:55:40','880','2022-11-17 10:55:59',10,0),('1','273',193,'OPERATIONAL LOSE','2022-11-17','2022-11-17 10:59:56','2022-11-18 10:59:56','880',0.00,0.00,'880','2022-11-17 11:09:18','880','2022-11-17 11:09:38',10,0),('1','273',194,'DAILY SHIFT','2022-11-19','2022-11-19 06:57:33','2022-11-20 06:57:33','880',0.00,0.00,'880','2022-11-19 18:41:18','880','2022-11-19 18:41:39',10,0),('1','273',195,'DAILY SHIFT','2022-11-20','2022-11-20 06:43:17','2022-11-21 06:43:17','880',0.00,0.00,'880','2022-11-20 18:26:26','880','2022-11-20 18:26:47',10,0),('1','273',196,'DAILY SHIFT','2022-11-21','2022-11-21 06:33:28','2022-11-22 06:33:28','880',0.00,0.00,'880','2022-11-21 18:31:35','880','2022-11-21 18:31:53',10,0),('1','273',197,'DAILY SHIFT','2022-11-22','2022-11-22 06:59:33','2022-11-23 06:59:33','880',0.00,0.00,'880','2022-11-22 18:12:22','880','2022-11-22 18:12:48',10,0),('1','273',198,'DAILY SHIFT','2022-11-23','2022-11-23 06:32:27','2022-11-24 06:32:27','880',0.00,0.00,'880','2022-11-23 18:23:03','880','2022-11-23 18:23:24',10,0),('1','273',199,'DAILY SHIFT','2022-11-24','2022-11-24 06:41:51','2022-11-25 06:41:51','880',0.00,0.00,'880','2022-11-24 18:26:48','880','2022-11-24 18:27:08',10,0),('1','273',200,'DAILY SHIFT','2022-11-25','2022-11-25 06:45:19','2022-11-26 06:45:19','880',0.00,0.00,'880','2022-11-25 11:12:23','880','2022-11-25 11:12:41',10,0),('1','273',201,'OPERATIONAL LOSE','2022-11-25','2022-11-25 11:24:26','2022-11-26 11:24:26','880',0.00,0.00,'880','2022-11-25 11:29:07','880','2022-11-25 11:29:30',10,0),('1','273',202,'DAILY SHIFT','2022-11-26','2022-11-26 11:20:48','2022-11-27 11:20:48','880',0.00,0.00,'880','2022-11-26 18:31:23','880','2022-11-26 18:31:42',10,0),('1','273',203,'DAILY SHIFT','2022-11-27','2022-11-27 06:53:52','2022-11-28 06:53:52','880',0.00,0.00,'880','2022-11-27 18:27:18','880','2022-11-27 18:27:45',10,0),('1','273',204,'DAILY SHIFT','2022-11-28','2022-11-28 06:35:23','2022-11-29 06:35:23','880',0.00,0.00,'880','2022-11-28 18:37:31','880','2022-11-28 18:37:48',10,0),('1','273',205,'DAILY SHIFT','2022-11-29','2022-11-29 06:48:44','2022-11-30 06:48:44','880',0.00,0.00,'880','2022-11-29 18:20:30','880','2022-11-29 18:20:56',10,0),('1','273',206,'DAILY SHIFT','2022-11-30','2022-11-30 06:41:33','2022-12-01 06:41:33','880',0.00,0.00,'880','2022-11-30 18:40:17','880','2022-11-30 18:40:49',10,0),('1','273',207,'DAILY SHIFT','2022-12-01','2022-12-01 12:51:34','2022-12-02 12:51:34','880',0.00,0.00,'880','2022-12-01 18:37:41','880','2022-12-01 18:38:09',10,0),('1','273',208,'DAILY SHIFT','2022-12-02','2022-12-02 06:52:41','2022-12-03 06:52:41','880',0.00,0.00,'880','2022-12-02 18:28:12','880','2022-12-02 18:28:42',10,0),('1','273',209,'DAILY SHIFT','2022-12-03','2022-12-03 06:44:55','2022-12-04 06:44:55','880',0.00,0.00,'880','2022-12-03 18:21:38','880','2022-12-03 18:21:57',10,0),('1','273',210,'DAILY SHIFT','2022-12-04','2022-12-04 06:48:53','2022-12-05 06:48:53','880',0.00,0.00,'880','2022-12-04 18:25:06','880','2022-12-04 18:26:11',10,0),('1','273',211,'DAILY SHIFT','2022-12-05','2022-12-05 06:38:43','2022-12-06 06:38:43','880',0.00,0.00,'880','2022-12-05 09:21:49','880','2022-12-05 09:22:07',10,0),('1','273',212,'OPERATIONAL LOSE','2022-12-05','2022-12-05 09:30:34','2022-12-06 09:30:34','880',0.00,0.00,'880','2022-12-05 09:37:56','880','2022-12-05 09:38:17',10,0),('1','273',213,'DAILY SHIFT','2022-12-06','2022-12-06 15:32:00','2022-12-07 15:32:00','880',0.00,0.00,'880','2022-12-06 18:33:30','880','2022-12-06 18:33:53',10,0),('1','273',214,'DAILY SHIFT','2022-12-07','2022-12-07 06:54:09','2022-12-08 06:54:09','880',0.00,0.00,'880','2022-12-07 18:23:56','880','2022-12-07 18:24:17',10,0),('1','273',215,'DAILY SHIFT','2022-12-08','2022-12-08 06:51:18','2022-12-09 06:51:18','880',0.00,0.00,'880','2022-12-08 18:33:57','880','2022-12-08 18:34:16',10,0),('1','273',216,'DAILY SHIFT','2022-12-09','2022-12-09 06:57:20','2022-12-10 06:57:20','880',0.00,0.00,'880','2022-12-09 18:20:27','880','2022-12-09 18:20:50',10,0),('1','273',217,'DAILY SHIFT','2022-12-10','2022-12-10 06:49:29','2022-12-11 06:49:29','880',0.00,0.00,'880','2022-12-10 18:25:56','880','2022-12-10 18:26:22',10,0),('1','273',218,'DAILY SHIFT','2022-12-11','2022-12-11 06:53:21','2022-12-12 06:53:21','880',0.00,0.00,'880','2022-12-11 18:24:07','880','2022-12-11 18:24:49',10,0),('1','273',219,'DAILY SHIFT','2022-12-12','2022-12-12 07:00:36','2022-12-13 07:00:36','880',0.00,0.00,'880','2022-12-12 18:30:48','880','2022-12-12 18:32:01',10,0),('1','273',220,'DAILY SHIFT','2022-12-13','2022-12-13 06:45:18','2022-12-14 06:45:18','880',0.00,0.00,'880','2022-12-13 16:42:09','880','2022-12-13 16:42:30',10,0),('1','273',221,'OPERATIONAL LOSE','2022-12-13','2022-12-13 17:19:42','2022-12-14 17:19:42','880',0.00,0.00,'880','2022-12-13 17:23:02','880','2022-12-13 17:23:19',10,0),('1','273',222,'DAILY SHIFT','2022-12-16','2022-12-16 06:49:55','2022-12-17 06:49:55','880',0.00,0.00,'880','2022-12-16 18:36:11','880','2022-12-16 18:36:29',10,0),('1','273',223,'DAILY SHIFT','2022-12-17','2022-12-17 06:58:55','2022-12-18 06:58:55','880',0.00,0.00,'880','2022-12-17 18:17:09','880','2022-12-17 18:17:39',10,0),('1','273',224,'DAILY SHIFT','2022-12-18','2022-12-18 06:57:27','2022-12-19 06:57:27','880',0.00,0.00,'880','2022-12-18 18:20:41','880','2022-12-18 18:21:15',10,0),('1','273',225,'DAILY SHIFT','2022-12-19','2022-12-19 06:58:10','2022-12-20 06:58:10','880',0.00,0.00,'880','2022-12-19 19:00:40','880','2022-12-19 19:03:55',10,0),('1','273',226,'DAILY SHIFT ','2022-12-20','2022-12-20 06:48:53','2022-12-21 06:48:53','880',0.00,0.00,'880','2022-12-20 18:58:01','880','2022-12-20 18:58:28',10,0),('1','273',227,'DAILY SHIFT ','2022-12-21','2022-12-21 06:52:43','2022-12-22 06:52:43','880',0.00,0.00,'880','2022-12-21 19:07:14','880','2022-12-21 19:08:15',10,0),('1','273',228,'DAILY SHIFT ','2022-12-22','2022-12-22 07:04:37','2022-12-23 07:04:37','880',0.00,0.00,'880','2022-12-22 18:58:33','880','2022-12-22 18:58:49',10,0),('1','273',229,'DAILY SHIFT ','2022-12-23','2022-12-23 06:39:49','2022-12-24 06:39:49','880',0.00,0.00,'880','2022-12-23 12:22:57','880','2022-12-23 12:23:21',10,0),('1','273',230,'OPERATIONAL LOSE','2022-12-23','2022-12-23 12:29:01','2022-12-24 12:29:01','880',0.00,0.00,'880','2022-12-23 12:33:23','880','2022-12-23 12:33:41',10,0),('1','273',231,'DAILY SHIFT ','2022-12-24','2022-12-24 07:02:36','2022-12-25 07:02:36','880',0.00,0.00,'880','2022-12-24 20:36:04','880','2022-12-24 20:36:59',10,0),('1','273',232,'DAILY SHIFT ','2022-12-25','2022-12-25 07:02:13','2022-12-26 07:02:13','880',0.00,0.00,'880','2022-12-25 18:45:02','880','2022-12-25 18:45:23',10,0),('1','273',233,'DAILY SHIFT ','2022-12-26','2022-12-26 07:01:52','2022-12-27 07:01:52','880',0.00,0.00,'880','2022-12-26 19:04:43','880','2022-12-26 19:05:59',10,0),('1','273',234,'DAILY SHIFT ','2022-12-27','2022-12-27 07:01:29','2022-12-28 07:01:29','880',0.00,0.00,'880','2022-12-27 18:38:05','880','2022-12-27 18:38:26',10,0),('1','273',235,'DAILY SHIFT ','2022-12-28','2022-12-28 07:00:15','2022-12-29 07:00:15','880',0.00,0.00,'880','2022-12-28 18:56:05','880','2022-12-28 18:56:29',10,0),('1','273',236,'DAILY SHIFT ','2022-12-29','2022-12-29 07:04:52','2022-12-30 07:04:52','880',0.00,0.00,'880','2022-12-29 18:28:50','880','2022-12-29 18:29:07',10,0),('1','273',237,'DAILY SHIFT ','2022-12-30','2022-12-30 06:53:25','2022-12-31 06:53:25','880',0.00,0.00,'880','2022-12-30 13:00:40','880','2022-12-30 13:01:10',10,0),('1','273',238,'OPERATIONAL LOSE','2022-12-30','2022-12-30 13:02:00','2022-12-31 13:02:00','880',0.00,0.00,'880','2022-12-30 13:06:18','880','2022-12-30 13:06:38',10,0),('1','273',239,'DAILY SHIFT','2022-12-30','2022-12-30 14:52:53','2022-12-31 14:52:53','880',0.00,0.00,'880','2022-12-30 19:16:18','880','2022-12-30 19:16:55',10,0),('1','273',240,'DAILY SHIFT ','2022-12-31','2022-12-31 06:53:03','2023-01-01 06:53:03','880',0.00,0.00,'880','2022-12-31 19:48:04','880','2022-12-31 19:48:28',10,0),('1','273',241,'DAILY SHIFT ','2023-01-01','2023-01-01 06:58:58','2023-01-02 06:58:58','880',0.00,0.00,'880','2023-01-01 18:26:46','880','2023-01-01 18:27:09',10,0),('1','273',242,'DAILY SHIFT ','2023-01-02','2023-01-02 07:09:06','2023-01-03 07:09:06','880',0.00,0.00,'880','2023-01-02 18:27:43','880','2023-01-02 18:28:05',10,0),('1','273',243,'DAILY SHIFT ','2023-01-03','2023-01-03 07:09:46','2023-01-04 07:09:46','880',0.00,0.00,'880','2023-01-03 19:17:50','880','2023-01-03 19:18:25',10,0),('1','273',244,'DAILY SHIFT ','2023-01-04','2023-01-04 06:56:17','2023-01-05 06:56:17','880',0.00,0.00,'880','2023-01-04 17:37:38','880','2023-01-04 17:37:56',10,0),('1','273',245,'OPERATIONAL LOSE','2023-01-04','2023-01-04 17:58:46','2023-01-05 17:58:46','880',0.00,0.00,'880','2023-01-04 18:02:53','880','2023-01-04 18:03:25',10,0),('1','273',246,'DAILY SHIFT ','2023-01-06','2023-01-06 06:54:01','2023-01-07 06:54:01','880',0.00,0.00,'880','2023-01-06 18:49:58','880','2023-01-06 18:50:26',10,0),('1','273',247,'DAILY SHIFT ','2023-01-07','2023-01-07 07:18:34','2023-01-08 07:18:34','880',0.00,0.00,'880','2023-01-07 18:48:15','880','2023-01-07 18:48:35',10,0),('1','273',248,'DAILY SHIFT ','2023-01-08','2023-01-08 07:16:46','2023-01-09 07:16:46','880',0.00,0.00,'880','2023-01-08 18:42:04','880','2023-01-08 18:42:21',10,0),('1','273',249,'DAILY SHIFT ','2023-01-09','2023-01-09 06:50:02','2023-01-10 06:50:02','880',0.00,0.00,'880','2023-01-09 18:48:23','880','2023-01-09 18:48:45',10,0),('1','273',250,'DAILY SHIFT ','2023-01-10','2023-01-10 06:57:18','2023-01-11 06:57:18','880',0.00,0.00,'880','2023-01-10 18:47:11','880','2023-01-10 18:48:12',10,0),('1','273',251,'DAILY SHIFT','2023-01-11','2023-01-11 06:59:44','2023-01-12 06:59:44','880',0.00,0.00,'880','2023-01-11 18:18:29','880','2023-01-11 18:18:58',10,0),('1','273',252,'DAILY SHIFT','2023-01-12','2023-01-12 07:08:07','2023-01-13 07:08:07','880',0.00,0.00,'880','2023-01-12 18:19:41','880','2023-01-12 18:20:07',10,0),('1','273',253,'DAILY SHIFT','2023-01-13','2023-01-13 06:54:28','2023-01-14 06:54:28','880',0.00,0.00,'880','2023-01-13 18:29:56','880','2023-01-13 18:30:38',10,0),('1','273',254,'DAILY SHIFT','2023-01-14','2023-01-14 06:59:34','2023-01-15 06:59:34','880',0.00,0.00,'880','2023-01-14 10:32:17','880','2023-01-14 10:32:35',10,0),('1','273',255,'OPERATIONAL LOSE','2023-01-14','2023-01-14 10:50:35','2023-01-15 10:50:35','880',0.00,0.00,'880','2023-01-14 10:57:53','880','2023-01-14 10:58:30',10,0),('1','273',256,'DAILY SHIFT','2023-01-15','2023-01-15 07:13:48','2023-01-16 07:13:48','880',0.00,0.00,'880','2023-01-15 18:11:25','880','2023-01-15 18:11:52',10,0),('1','273',257,'DAILY SHIFT','2023-01-16','2023-01-16 06:52:41','2023-01-17 06:52:41','880',0.00,0.00,'880','2023-01-16 18:39:21','880','2023-01-16 18:39:47',10,0),('1','273',258,'DAILY SHIFT','2023-01-17','2023-01-17 06:54:02','2023-01-18 06:54:02','880',0.00,0.00,'880','2023-01-17 18:39:13','880','2023-01-17 18:39:41',10,0),('1','273',259,'DAILY SHIFT','2023-01-18','2023-01-18 07:02:46','2023-01-19 07:02:46','880',0.00,0.00,'880','2023-01-18 18:32:23','880','2023-01-18 18:32:45',10,0),('1','273',260,'DAILY SHIFT','2023-01-19','2023-01-19 07:07:17','2023-01-20 07:07:17','880',0.00,0.00,'880','2023-01-19 18:43:17','880','2023-01-19 18:43:46',10,0),('1','273',261,'DAILY SHIFT','2023-01-20','2023-01-20 06:52:15','2023-01-21 06:52:15','880',0.00,0.00,'880','2023-01-20 18:35:33','880','2023-01-20 18:37:31',10,0),('1','273',262,'DAILY SHIFT','2023-01-21','2023-01-21 06:51:49','2023-01-22 06:51:49','880',0.00,0.00,'880','2023-01-21 18:21:11','880','2023-01-21 18:23:40',10,0),('1','273',263,'DAILY SHIFT','2023-01-22','2023-01-22 06:46:59','2023-01-23 06:46:59','880',0.00,0.00,'880','2023-01-22 17:20:07','880','2023-01-22 17:20:27',10,0),('1','273',264,'OPERATIONAL LOSE','2023-01-22','2023-01-22 17:33:32','2023-01-23 17:33:32','880',0.00,0.00,'880','2023-01-22 17:36:47','880','2023-01-22 17:37:05',10,0),('1','273',265,'DAILY SHIFT','2023-01-23','2023-01-23 07:07:13','2023-01-24 07:07:13','880',0.00,0.00,'880','2023-01-23 18:47:01','880','2023-01-23 18:47:30',10,0),('1','273',266,'DAILY SHIFT','2023-01-24','2023-01-24 06:47:27','2023-01-25 06:47:27','880',0.00,0.00,'880','2023-01-24 18:48:41','880','2023-01-24 18:49:28',10,0),('1','273',267,'DAILY SHIFT','2023-01-25','2023-01-25 06:52:18','2023-01-26 06:52:18','880',0.00,0.00,'880','2023-01-25 18:29:08','880','2023-01-25 18:32:14',10,0),('1','273',268,'DAILY SHIFT','2023-01-26','2023-01-26 11:16:43','2023-01-27 11:16:43','880',0.00,0.00,'880','2023-01-26 18:41:08','880','2023-01-26 18:41:25',10,0),('1','273',269,'DAILY SHIFT','2023-01-27','2023-01-27 06:50:57','2023-01-28 06:50:57','880',0.00,0.00,'880','2023-01-27 19:08:27','880','2023-01-27 19:09:05',10,0),('1','273',270,'DAILY SHIFT','2023-01-28','2023-01-28 06:44:40','2023-01-29 06:44:40','880',0.00,0.00,'880','2023-01-28 18:55:15','880','2023-01-28 18:55:47',10,0),('1','273',271,'DAILY SHIFT','2023-01-29','2023-01-29 07:09:03','2023-01-30 07:09:03','880',0.00,0.00,'880','2023-01-29 18:24:45','880','2023-01-29 18:25:04',10,0),('1','273',272,'DAILY SHIFT','2023-01-30','2023-01-30 07:03:13','2023-01-31 07:03:13','880',0.00,0.00,'880','2023-01-30 18:08:03','880','2023-01-30 18:08:21',10,0),('1','273',273,'OPERATIONAL LOSE','2023-01-30','2023-01-30 18:18:16','2023-01-31 18:18:16','880',0.00,0.00,'880','2023-01-30 18:27:15','880','2023-01-30 18:27:37',10,0),('1','273',274,'DAILY SHIFT','2023-01-31','2023-01-31 07:00:36','2023-02-01 07:00:36','880',0.00,0.00,'880','2023-01-31 19:01:39','880','2023-01-31 19:02:04',10,0),('1','273',275,'DAILY SHIFT','2023-02-01','2023-02-01 06:56:56','2023-02-02 06:56:56','880',0.00,0.00,'880','2023-02-01 18:47:13','880','2023-02-01 18:48:04',10,0),('1','273',276,'DAILY SHIFT','2023-02-02','2023-02-02 06:56:39','2023-02-03 06:56:39','880',0.00,0.00,'880','2023-02-02 18:39:41','880','2023-02-02 18:40:09',10,0),('1','273',277,'DAILY SHIFT','2023-02-03','2023-02-03 06:46:58','2023-02-04 06:46:58','880',0.00,0.00,'880','2023-02-03 18:46:54','880','2023-02-03 18:47:30',10,0),('1','273',278,'DAILY SHIFT','2023-02-04','2023-02-04 06:56:04','2023-02-05 06:56:04','880',0.00,0.00,'880','2023-02-04 18:50:19','880','2023-02-04 18:50:35',10,0),('1','273',279,'DAILY SHIFT','2023-02-05','2023-02-05 06:59:51','2023-02-06 06:59:51','880',0.00,0.00,'880','2023-02-05 18:31:28','880','2023-02-05 18:31:46',10,0),('1','273',280,'DAILY SHIFT','2023-02-06','2023-02-06 06:51:00','2023-02-07 06:51:00','880',0.00,0.00,'880','2023-02-06 12:18:39','880','2023-02-06 12:18:58',10,0),('1','273',281,'OPERATIONAL LOSE','2023-02-06','2023-02-06 12:25:48','2023-02-07 12:25:48','880',0.00,0.00,'880','2023-02-06 12:30:45','880','2023-02-06 12:31:02',10,0),('1','273',282,'DAILY SHIFT','2023-02-07','2023-02-07 07:06:36','2023-02-08 07:06:36','880',0.00,0.00,'880','2023-02-07 19:04:11','880','2023-02-07 19:04:29',10,0),('1','273',283,'DAILY SHIFT','2023-02-08','2023-02-08 06:54:20','2023-02-09 06:54:20','880',0.00,0.00,'880','2023-02-08 18:28:00','880','2023-02-08 18:28:19',10,0),('1','273',284,'DAILY SHIFT','2023-02-09','2023-02-09 07:05:32','2023-02-10 07:05:32','880',0.00,0.00,'880','2023-02-09 18:27:49','880','2023-02-09 18:28:16',10,0),('1','273',285,'DAILY SHIFT','2023-02-10','2023-02-10 06:56:26','2023-02-11 06:56:26','880',0.00,0.00,'880','2023-02-10 18:53:55','880','2023-02-10 18:54:21',10,0),('1','273',286,'DAILY SHIFT','2023-02-11','2023-02-11 07:07:52','2023-02-12 07:07:52','880',0.00,0.00,'880','2023-02-11 18:25:08','880','2023-02-11 18:25:30',10,0),('1','273',287,'DAILY SHIFT','2023-02-12','2023-02-12 06:54:19','2023-02-13 06:54:19','880',0.00,0.00,'880','2023-02-12 18:16:04','880','2023-02-12 18:16:26',10,0),('1','273',288,'DAILY SHIFT','2023-02-13','2023-02-13 06:52:40','2023-02-14 06:52:40','880',0.00,0.00,'880','2023-02-13 18:49:05','880','2023-02-13 18:50:20',10,0),('1','273',289,'DAILY SHIFT','2023-02-14','2023-02-14 06:50:54','2023-02-15 06:50:54','880',0.00,0.00,'880','2023-02-14 15:19:06','880','2023-02-14 15:19:23',10,0),('1','273',290,'OPERATIONAL LOSE','2023-02-14','2023-02-14 15:25:35','2023-02-15 15:25:35','880',0.00,0.00,'880','2023-02-14 15:29:34','880','2023-02-14 15:29:51',10,0),('1','273',291,'DAILY SHIFT','2023-02-16','2023-02-16 06:55:54','2023-02-17 06:55:54','880',0.00,0.00,'880','2023-02-16 19:12:26','880','2023-02-16 19:12:45',10,0),('1','273',292,'DAILY SHIFT','2023-02-17','2023-02-17 06:57:14','2023-02-18 06:57:14','880',0.00,0.00,'880','2023-02-17 18:42:41','880','2023-02-17 18:43:15',10,0),('1','273',293,'DAILY SHIFT','2023-02-18','2023-02-18 06:54:55','2023-02-19 06:54:55','880',0.00,0.00,'880','2023-02-18 18:17:07','880','2023-02-18 18:17:29',10,0),('1','273',294,'DAILY SHIFT','2023-02-19','2023-02-19 07:09:56','2023-02-20 07:09:56','880',0.00,0.00,'880','2023-02-19 18:38:17','880','2023-02-19 18:39:00',10,0),('1','273',295,'DAILY SHIFT','2023-02-20','2023-02-20 07:11:06','2023-02-21 07:11:06','880',0.00,0.00,'880','2023-02-20 18:38:07','880','2023-02-20 18:38:30',10,0),('1','273',296,'DAILY SHIFT','2023-02-21','2023-02-21 06:59:50','2023-02-22 06:59:50','880',0.00,0.00,'880','2023-02-21 18:53:57','880','2023-02-21 18:54:18',10,0),('1','273',297,'DAILY SHIFT','2023-02-22','2023-02-22 06:59:27','2023-02-23 06:59:27','880',0.00,0.00,'880','2023-02-22 18:43:35','880','2023-02-22 18:43:57',10,0),('1','273',298,'DAILY SHIFT','2023-02-23','2023-02-23 06:41:12','2023-02-24 06:41:12','880',0.00,0.00,'880','2023-02-23 08:42:27','880','2023-02-23 08:43:48',10,0),('1','273',299,'OPERATIONAL LOSE','2023-02-23','2023-02-23 12:01:53','2023-02-24 12:01:53','880',0.00,0.00,'880','2023-02-23 12:06:52','880','2023-02-23 12:07:14',10,0),('1','273',300,'DAILY SHIFT','2023-02-27','2023-02-27 06:42:59','2023-02-28 06:42:59','880',0.00,0.00,'880','2023-02-27 18:38:12','880','2023-02-27 18:38:30',10,0),('1','273',301,'DAILY SHIFT','2023-02-28','2023-02-28 06:46:55','2023-03-01 06:46:55','880',0.00,0.00,'880','2023-02-28 19:03:01','880','2023-02-28 19:03:24',10,0),('1','273',302,'DAILY SHIFT','2023-03-01','2023-03-01 06:52:34','2023-03-02 06:52:34','880',0.00,0.00,'880','2023-03-01 17:51:06','880','2023-03-01 17:51:24',10,0),('1','273',303,'DAILY SHIFT','2023-03-02','2023-03-02 06:46:35','2023-03-03 06:46:35','880',0.00,0.00,'880','2023-03-02 18:31:12','880','2023-03-02 18:31:29',10,0),('1','273',304,'DAILY SHIFT','2023-03-03','2023-03-03 07:01:51','2023-03-04 07:01:51','880',0.00,0.00,'880','2023-03-03 18:09:18','880','2023-03-03 18:09:39',10,0),('1','273',305,'DAILY SHIFT','2023-03-04','2023-03-04 06:53:33','2023-03-05 06:53:33','880',0.00,0.00,'880','2023-03-04 18:23:58','880','2023-03-04 18:24:20',10,0),('1','273',306,'DAILY SHIFT','2023-03-05','2023-03-05 06:52:18','2023-03-06 06:52:18','880',0.00,0.00,'880','2023-03-05 17:59:33','880','2023-03-05 17:59:50',10,0),('1','273',307,'OPERATIONAL LOSE','2023-03-05','2023-03-05 21:12:12','2023-03-06 21:12:12','880',0.00,0.00,'880','2023-03-05 21:17:33','880','2023-03-05 21:18:09',10,0),('1','273',308,'DAILY SHIFT','2023-03-06','2023-03-06 06:55:11','2023-03-07 06:55:11','880',0.00,0.00,'880','2023-03-06 18:30:33','880','2023-03-06 18:30:52',10,0),('1','273',309,'DAILY SHIFT','2023-03-07','2023-03-07 06:50:15','2023-03-08 06:50:15','880',0.00,0.00,'880','2023-03-07 18:37:56','880','2023-03-07 18:39:02',10,0),('1','273',310,'DAILY SHIFT','2023-03-08','2023-03-08 06:53:16','2023-03-09 06:53:16','880',0.00,0.00,'880','2023-03-08 19:02:10','880','2023-03-08 19:02:26',10,0),('1','273',311,'DAILY SHIFT','2023-03-09','2023-03-09 06:52:36','2023-03-10 06:52:36','880',0.00,0.00,'880','2023-03-09 18:33:30','880','2023-03-09 18:34:01',10,0),('1','273',312,'DAILY SHIFT','2023-03-10','2023-03-10 06:53:50','2023-03-11 06:53:50','880',0.00,0.00,'880','2023-03-10 18:36:21','880','2023-03-10 18:36:39',10,0),('1','273',313,'DAILY SHIFT','2023-03-11','2023-03-11 06:56:20','2023-03-12 06:56:20','880',0.00,0.00,'880','2023-03-11 18:20:48','880','2023-03-11 18:21:07',10,0),('1','273',314,'DAILY SHIFT','2023-03-12','2023-03-12 06:56:55','2023-03-13 06:56:55','880',0.00,0.00,'880','2023-03-12 18:04:58','880','2023-03-12 18:05:19',10,0),('1','273',315,'DAILY SHIFT','2023-03-13','2023-03-13 06:50:23','2023-03-14 06:50:23','880',0.00,0.00,'880','2023-03-13 19:01:15','880','2023-03-13 19:01:37',10,0),('1','273',316,'DAILY SHIFT','2023-03-14','2023-03-14 06:54:14','2023-03-15 06:54:14','880',0.00,0.00,'880','2023-03-14 19:18:07','880','2023-03-14 19:18:23',10,0),('1','273',317,'OPERATIONAL LOSE','2023-03-15','2023-03-15 08:25:57','2023-03-16 08:25:57','880',0.00,0.00,'880','2023-03-15 09:08:02','880','2023-03-15 09:08:28',10,0),('1','273',318,'DAILY SHIFT','2023-03-15','2023-03-15 09:08:52','2023-03-16 09:08:52','880',0.00,0.00,'880','2023-03-16 06:44:21','880','2023-03-16 06:44:41',10,0),('1','273',319,'DAILY SHIFT','2023-03-16','2023-03-16 06:45:09','2023-03-17 06:45:09','880',0.00,0.00,'880','2023-03-17 06:48:27','880','2023-03-17 06:48:44',10,0),('1','273',320,'DAILY SHIFT','2023-03-17','2023-03-17 06:49:43','2023-03-18 06:49:43','880',0.00,0.00,'880','2023-03-17 19:42:30','880','2023-03-17 19:42:48',10,0),('1','273',321,'DAILY SHIFT','2023-03-19','2023-03-19 07:03:49','2023-03-20 07:03:49','880',0.00,0.00,'880','2023-03-19 18:12:19','880','2023-03-19 18:12:46',10,0),('1','273',322,'DAILY SHIFT','2023-03-20','2023-03-20 06:50:03','2023-03-21 06:50:03','880',0.00,0.00,'880','2023-03-20 17:30:58','880','2023-03-20 17:31:25',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1595 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','273','1','1',1,'1','1',0.00,18.60,0.00,0.00,18.60,12350.40,0.00,0.00,0.00),('1','273','1','1',2,'2','1',0.00,19.81,0.00,0.00,19.81,13153.84,0.00,0.00,0.00),('1','273','1','1',3,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','1',4,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','2',5,'1','1',18.60,23.09,0.00,0.00,4.49,2981.36,0.00,0.00,0.00),('1','273','1','2',6,'2','1',19.81,143.07,0.00,0.00,123.26,81844.64,0.00,0.00,0.00),('1','273','1','2',7,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','2',8,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','3',9,'1','1',23.09,166.31,0.00,0.00,143.22,92096.80,0.00,0.00,0.00),('1','273','1','3',10,'2','1',143.07,229.12,0.00,0.00,86.05,57137.20,0.00,0.00,0.00),('1','273','1','3',11,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','3',12,'4','1',0.00,50.00,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','273','1','4',13,'1','1',166.31,382.24,0.00,0.00,215.93,143377.52,0.00,0.00,0.00),('1','273','1','4',14,'2','1',229.12,399.10,0.00,0.00,169.98,112866.72,0.00,0.00,0.00),('1','273','1','4',15,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','4',16,'4','1',50.00,95.15,0.00,0.00,45.15,27993.00,0.00,0.00,0.00),('1','273','1','5',17,'1','1',382.24,457.96,0.00,0.00,75.72,50278.08,0.00,0.00,0.00),('1','273','1','5',18,'2','1',399.10,466.61,0.00,0.00,67.51,44826.64,0.00,0.00,0.00),('1','273','1','5',19,'3','1',0.00,50.00,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','273','1','5',20,'4','1',95.15,195.15,0.00,0.00,100.00,62000.00,0.00,0.00,0.00),('1','273','1','6',21,'1','1',457.96,616.80,0.00,0.00,158.84,105469.76,0.00,0.00,0.00),('1','273','1','6',22,'2','1',466.61,670.64,0.00,0.00,204.03,135475.92,0.00,0.00,0.00),('1','273','1','6',23,'3','1',50.00,740.00,0.00,0.00,690.00,427800.00,0.00,0.00,0.00),('1','273','1','6',24,'4','1',195.15,815.15,0.00,0.00,620.00,384400.00,0.00,0.00,0.00),('1','273','1','7',25,'1','1',616.80,788.07,0.00,0.00,171.27,113723.28,0.00,0.00,0.00),('1','273','1','7',26,'2','1',670.64,868.25,0.00,0.00,197.61,131213.04,0.00,0.00,0.00),('1','273','1','7',27,'3','1',740.00,1950.00,0.00,0.00,1210.00,750200.00,0.00,0.00,0.00),('1','273','1','7',28,'4','1',815.15,2413.15,0.00,0.00,1598.00,990760.00,0.00,0.00,0.00),('1','273','1','8',29,'1','1',788.07,893.79,0.00,0.00,105.72,70198.08,0.00,0.00,0.00),('1','273','1','8',30,'2','1',868.25,1015.90,0.00,0.00,147.65,98039.60,0.00,0.00,0.00),('1','273','1','8',31,'3','1',1950.00,2628.00,0.00,0.00,678.00,420360.00,0.00,0.00,0.00),('1','273','1','8',32,'4','1',2413.15,3100.56,0.00,0.00,687.41,426194.20,0.00,0.00,0.00),('1','273','1','9',33,'1','1',893.79,1081.75,0.00,0.00,187.96,124805.44,0.00,0.00,0.00),('1','273','1','9',34,'2','1',1015.90,1173.33,0.00,0.00,157.43,104533.52,0.00,0.00,0.00),('1','273','1','9',35,'3','1',2628.00,4948.84,0.00,0.00,2320.84,1438920.80,0.00,0.00,0.00),('1','273','1','9',36,'4','1',3100.56,5518.56,0.00,0.00,2418.00,1499160.00,0.00,0.00,0.00),('1','273','1','10',37,'1','1',1081.75,1372.52,0.00,0.00,290.77,193071.28,0.00,0.00,0.00),('1','273','1','10',38,'2','1',1173.33,1372.46,0.00,0.00,199.13,132222.32,0.00,0.00,0.00),('1','273','1','10',39,'3','1',4948.84,6389.42,0.00,0.00,1440.58,893159.60,0.00,0.00,0.00),('1','273','1','10',40,'4','1',5518.56,7605.59,0.00,0.00,2087.03,1293958.60,0.00,0.00,0.00),('1','273','1','11',41,'1','1',1372.52,1581.53,0.00,0.00,209.01,138782.64,0.00,0.00,0.00),('1','273','1','11',42,'2','1',1372.46,1589.73,0.00,0.00,217.27,144267.28,0.00,0.00,0.00),('1','273','1','11',43,'3','1',6389.42,7394.50,0.00,0.00,1005.08,623149.60,0.00,0.00,0.00),('1','273','1','11',44,'4','1',7605.59,9106.11,0.00,0.00,1500.52,930322.40,0.00,0.00,0.00),('1','273','1','12',45,'1','1',1581.53,1808.97,0.00,0.00,227.44,151020.16,0.00,0.00,0.00),('1','273','1','12',46,'2','1',1589.73,1775.59,0.00,0.00,185.86,123411.04,0.00,0.00,0.00),('1','273','1','12',47,'3','1',7394.50,9472.50,0.00,0.00,2078.00,1288360.00,0.00,0.00,0.00),('1','273','1','12',48,'4','1',9106.11,11039.20,0.00,0.00,1933.09,1198515.80,0.00,0.00,0.00),('1','273','1','13',49,'1','1',1808.97,1808.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','13',50,'2','1',1775.59,1775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','13',51,'3','1',9472.50,9472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','13',52,'4','1',11039.20,11039.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','14',53,'1','1',1808.97,1808.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','14',54,'2','1',1775.59,1775.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','14',55,'3','1',9472.50,9472.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','14',56,'4','1',11039.20,11039.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','15',57,'1','1',1808.97,1830.05,0.00,0.00,21.08,13997.12,0.00,0.00,0.00),('1','273','1','15',58,'2','1',1775.59,1792.30,0.00,0.00,16.71,11095.44,0.00,0.00,0.00),('1','273','1','15',59,'3','1',9472.50,9560.55,0.00,0.00,88.05,54591.00,0.00,0.00,0.00),('1','273','1','15',60,'4','1',11039.20,11142.80,0.00,0.00,103.60,64232.00,0.00,0.00,0.00),('1','273','1','16',61,'1','1',1830.05,2035.08,0.00,0.00,205.03,151722.20,0.00,0.00,0.00),('1','273','1','16',62,'2','1',1792.30,1936.06,0.00,0.00,143.76,106382.40,0.00,0.00,0.00),('1','273','1','16',63,'3','1',9560.55,11135.55,0.00,0.00,1575.00,1096200.00,0.00,0.00,0.00),('1','273','1','16',64,'4','1',11142.80,12413.08,0.00,0.00,1270.28,884114.88,0.00,0.00,0.00),('1','273','1','17',65,'1','1',2035.08,2189.94,0.00,0.00,154.86,114596.40,0.00,0.00,0.00),('1','273','1','17',66,'2','1',1936.06,2131.55,0.00,0.00,195.49,144662.60,0.00,0.00,0.00),('1','273','1','17',67,'3','1',11135.55,11628.35,0.00,0.00,492.80,342988.80,0.00,0.00,0.00),('1','273','1','17',68,'4','1',12413.08,12696.08,0.00,0.00,283.00,196968.00,0.00,0.00,0.00),('1','273','1','18',69,'1','1',2189.94,2400.42,0.00,0.00,210.48,157020.60,0.00,0.00,0.00),('1','273','1','18',70,'2','1',2131.55,2369.16,0.00,0.00,237.61,175831.40,0.00,0.00,0.00),('1','273','1','18',71,'3','1',11628.35,11835.35,0.00,0.00,207.00,144072.00,0.00,0.00,0.00),('1','273','1','18',72,'4','1',12696.08,13160.08,0.00,0.00,464.00,322944.00,0.00,0.00,0.00),('1','273','1','19',73,'1','1',2400.42,2565.38,0.00,0.00,164.96,122070.40,0.00,0.00,0.00),('1','273','1','19',74,'2','1',2369.16,2570.84,0.00,0.00,201.68,149243.20,0.00,0.00,0.00),('1','273','1','19',75,'3','1',11835.35,12155.96,0.00,0.00,320.61,223144.56,0.00,0.00,0.00),('1','273','1','19',76,'4','1',13160.08,13190.25,0.00,0.00,30.17,20998.32,0.00,0.00,0.00),('1','273','1','20',77,'1','1',2565.38,2786.73,0.00,0.00,221.35,163799.00,0.00,0.00,0.00),('1','273','1','20',78,'2','1',2570.84,2794.31,0.00,0.00,223.47,165367.80,0.00,0.00,0.00),('1','273','1','20',79,'3','1',12155.96,12662.69,0.00,0.00,506.73,352684.08,0.00,0.00,0.00),('1','273','1','20',80,'4','1',13190.25,13531.11,0.00,0.00,340.86,237238.56,0.00,0.00,0.00),('1','273','1','21',81,'1','1',2786.73,2934.53,0.00,0.00,147.80,109372.00,0.00,0.00,0.00),('1','273','1','21',82,'2','1',2794.31,2947.80,0.00,0.00,153.49,113582.60,0.00,0.00,0.00),('1','273','1','21',83,'3','1',12662.69,13177.69,0.00,0.00,515.00,358440.00,0.00,0.00,0.00),('1','273','1','21',84,'4','1',13531.11,13943.61,0.00,0.00,412.50,287100.00,0.00,0.00,0.00),('1','273','1','22',85,'1','1',2934.53,2934.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','22',86,'2','1',2947.80,2947.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','22',87,'3','1',13177.69,13177.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','22',88,'4','1',13943.61,13943.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','23',89,'1','1',2934.53,3107.53,0.00,0.00,173.00,128020.00,0.00,0.00,0.00),('1','273','1','23',90,'2','1',2947.80,3123.88,0.00,0.00,176.08,130299.20,0.00,0.00,0.00),('1','273','1','23',91,'3','1',13177.69,14054.21,0.00,0.00,876.52,610057.92,0.00,0.00,0.00),('1','273','1','23',92,'4','1',13943.61,14773.54,0.00,0.00,829.93,577631.28,0.00,0.00,0.00),('1','273','1','24',93,'1','1',3107.53,3305.88,0.00,0.00,198.35,146779.00,0.00,0.00,0.00),('1','273','1','24',94,'2','1',3123.88,3258.23,0.00,0.00,134.35,99419.00,0.00,0.00,0.00),('1','273','1','24',95,'3','1',14054.21,15172.21,0.00,0.00,1118.00,778128.00,0.00,0.00,0.00),('1','273','1','24',96,'4','1',14773.54,15551.54,0.00,0.00,778.00,541488.00,0.00,0.00,0.00),('1','273','1','25',97,'1','1',3305.88,3554.84,0.00,0.00,248.96,184230.40,0.00,0.00,0.00),('1','273','1','25',98,'2','1',3258.23,3564.11,0.00,0.00,305.88,226287.90,0.00,0.00,0.00),('1','273','1','25',99,'3','1',15172.21,16004.21,0.00,0.00,832.00,579072.00,0.00,0.00,0.00),('1','273','1','25',100,'4','1',15551.54,16019.54,0.00,0.00,468.00,325728.00,0.00,0.00,0.00),('1','273','1','26',101,'1','1',3554.84,3770.79,0.00,0.00,215.95,159803.00,0.00,0.00,0.00),('1','273','1','26',102,'2','1',3564.11,3745.68,0.00,0.00,181.57,134361.80,0.00,0.00,0.00),('1','273','1','26',103,'3','1',16004.21,16719.21,0.00,0.00,715.00,497640.00,0.00,0.00,0.00),('1','273','1','26',104,'4','1',16019.54,16788.54,0.00,0.00,769.00,535224.00,0.00,0.00,0.00),('1','273','1','27',105,'1','1',3770.79,3976.02,0.00,0.00,205.23,151870.20,0.00,0.00,0.00),('1','273','1','27',106,'2','1',3745.68,3992.06,0.00,0.00,246.38,182321.20,0.00,0.00,0.00),('1','273','1','27',107,'3','1',16719.21,16952.21,0.00,0.00,233.00,162168.00,0.00,0.00,0.00),('1','273','1','27',108,'4','1',16788.54,17015.54,0.00,0.00,227.00,157992.00,0.00,0.00,0.00),('1','273','1','28',109,'1','1',3976.02,4235.34,0.00,0.00,259.32,191896.80,0.00,0.00,0.00),('1','273','1','28',110,'2','1',3992.06,4149.36,0.00,0.00,157.30,116402.00,0.00,0.00,0.00),('1','273','1','28',111,'3','1',16952.21,17296.21,0.00,0.00,344.00,239424.00,0.00,0.00,0.00),('1','273','1','28',112,'4','1',17015.54,17538.54,0.00,0.00,523.00,364008.00,0.00,0.00,0.00),('1','273','1','29',113,'1','1',4235.34,4385.59,0.00,0.00,150.25,111185.00,0.00,0.00,0.00),('1','273','1','29',114,'2','1',4149.36,4313.05,0.00,0.00,163.69,121130.60,0.00,0.00,0.00),('1','273','1','29',115,'3','1',17296.21,17732.04,0.00,0.00,435.83,303337.68,0.00,0.00,0.00),('1','273','1','29',116,'4','1',17538.54,17887.04,0.00,0.00,348.50,242556.00,0.00,0.00,0.00),('1','273','1','30',117,'1','1',4385.59,4613.38,0.00,0.00,227.79,168564.60,0.00,0.00,0.00),('1','273','1','30',118,'2','1',4313.05,4493.85,0.00,0.00,180.80,133792.00,0.00,0.00,0.00),('1','273','1','30',119,'3','1',17732.04,18507.04,0.00,0.00,775.00,539400.00,0.00,0.00,0.00),('1','273','1','30',120,'4','1',17887.04,18583.04,0.00,0.00,696.00,484416.00,0.00,0.00,0.00),('1','273','1','31',121,'1','1',4613.38,4774.62,0.00,0.00,161.24,119317.60,0.00,0.00,0.00),('1','273','1','31',122,'2','1',4493.85,4587.02,0.00,0.00,93.17,68945.80,0.00,0.00,0.00),('1','273','1','31',123,'3','1',18507.04,19015.04,0.00,0.00,508.00,353568.00,0.00,0.00,0.00),('1','273','1','31',124,'4','1',18583.04,18700.95,0.00,0.00,117.91,82065.36,0.00,0.00,0.00),('1','273','1','32',125,'1','1',4774.62,4833.56,0.00,0.00,58.94,43615.60,0.00,0.00,0.00),('1','273','1','32',126,'2','1',4587.02,4777.91,0.00,0.00,190.89,141258.60,0.00,0.00,0.00),('1','273','1','32',127,'3','1',19015.04,19433.04,0.00,0.00,418.00,290928.00,0.00,0.00,0.00),('1','273','1','32',128,'4','1',18700.95,19045.95,0.00,0.00,345.00,240120.00,0.00,0.00,0.00),('1','273','1','33',129,'1','1',4833.56,4833.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','33',130,'2','1',4777.91,5053.22,0.00,0.00,275.31,203729.40,0.00,0.00,0.00),('1','273','1','33',131,'3','1',19433.04,19771.04,0.00,0.00,338.00,235248.00,0.00,0.00,0.00),('1','273','1','33',132,'4','1',19045.95,19597.95,0.00,0.00,552.00,384192.00,0.00,0.00,0.00),('1','273','1','34',133,'1','1',4833.56,4833.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','34',134,'2','1',5053.22,5053.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','34',135,'3','1',19771.04,19771.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','34',136,'4','1',19597.95,19597.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','35',137,'1','1',4833.56,4833.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','35',138,'2','1',5053.22,5053.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','35',139,'3','1',19771.04,19771.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','35',140,'4','1',19597.95,19597.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','36',141,'1','1',4833.56,4833.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','36',142,'2','1',5053.22,5528.27,0.00,0.00,475.05,351537.00,0.00,0.00,0.00),('1','273','1','36',143,'3','1',19771.04,20363.04,0.00,0.00,592.00,409130.00,0.00,0.00,0.00),('1','273','1','36',144,'4','1',19597.95,19958.95,0.00,0.00,361.00,249390.00,0.00,0.00,0.00),('1','273','1','37',145,'1','1',4833.56,4833.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','37',146,'2','1',5528.27,5882.76,0.00,0.00,354.49,262322.60,0.00,0.00,0.00),('1','273','1','37',147,'3','1',20363.04,22122.04,0.00,0.00,1759.00,1213710.00,0.00,0.00,0.00),('1','273','1','37',148,'4','1',19958.95,21512.45,0.00,0.00,1553.50,1071915.00,0.00,0.00,0.00),('1','273','1','38',149,'1','1',4833.56,4833.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','38',150,'2','1',5882.76,6134.06,0.00,0.00,251.30,185962.00,0.00,0.00,0.00),('1','273','1','38',151,'3','1',22122.04,23185.69,0.00,0.00,1063.65,734121.00,0.00,0.00,0.00),('1','273','1','38',152,'4','1',21512.45,22637.45,0.00,0.00,1125.00,776250.00,0.00,0.00,0.00),('1','273','1','39',153,'1','1',4833.56,4833.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','39',154,'2','1',6134.06,6575.97,0.00,0.00,441.91,327013.40,0.00,0.00,0.00),('1','273','1','39',155,'3','1',23185.69,23997.67,0.00,0.00,811.98,560266.20,0.00,0.00,0.00),('1','273','1','39',156,'4','1',22637.45,23632.45,0.00,0.00,995.00,686550.00,0.00,0.00,0.00),('1','273','1','40',157,'1','1',4833.56,4833.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','40',158,'2','1',6575.97,6883.23,0.00,0.00,307.26,226632.40,0.00,0.00,0.00),('1','273','1','40',159,'3','1',23997.67,24702.74,0.00,0.00,705.07,486498.30,0.00,0.00,0.00),('1','273','1','40',160,'4','1',23632.45,24242.45,0.00,0.00,610.00,420900.00,0.00,0.00,0.00),('1','273','1','41',161,'1','1',4833.56,4833.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','41',162,'2','1',6883.23,7123.05,0.00,0.00,239.82,177466.80,0.00,0.00,0.00),('1','273','1','41',163,'3','1',24702.74,26011.14,0.00,0.00,1308.40,902796.00,0.00,0.00,0.00),('1','273','1','41',164,'4','1',24242.45,25652.56,0.00,0.00,1410.11,972975.90,0.00,0.00,0.00),('1','273','1','42',165,'1','1',4833.56,4833.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','42',166,'2','1',7123.05,7623.65,0.00,0.00,500.60,370444.00,0.00,0.00,0.00),('1','273','1','42',167,'3','1',26011.14,26942.72,0.00,0.00,931.58,642790.20,0.00,0.00,0.00),('1','273','1','42',168,'4','1',25652.56,26481.56,0.00,0.00,829.00,572010.00,0.00,0.00,0.00),('1','273','1','43',169,'1','1',4833.56,4838.56,0.00,0.00,5.00,3700.00,0.00,0.00,0.00),('1','273','1','43',170,'2','1',7623.65,8052.72,0.00,0.00,429.07,317511.80,0.00,0.00,0.00),('1','273','1','43',171,'3','1',26942.72,27542.45,0.00,0.00,599.73,413813.70,0.00,0.00,0.00),('1','273','1','43',172,'4','1',26481.56,27159.56,0.00,0.00,678.00,467820.00,0.00,0.00,0.00),('1','273','1','44',173,'1','1',4838.56,4838.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','44',174,'2','1',8052.72,8585.38,0.00,0.00,532.66,394168.40,0.00,0.00,0.00),('1','273','1','44',175,'3','1',27542.45,28366.46,0.00,0.00,824.01,568566.90,0.00,0.00,0.00),('1','273','1','44',176,'4','1',27159.56,28068.06,0.00,0.00,908.50,626865.00,0.00,0.00,0.00),('1','273','1','45',177,'1','1',4838.56,4838.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','45',178,'2','1',8585.38,8816.43,0.00,0.00,231.05,170977.00,0.00,0.00,0.00),('1','273','1','45',179,'3','1',28366.46,29004.96,0.00,0.00,638.50,440565.00,0.00,0.00,0.00),('1','273','1','45',180,'4','1',28068.06,28561.06,0.00,0.00,493.00,340170.00,0.00,0.00,0.00),('1','273','1','46',181,'1','1',4838.56,4838.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','46',182,'2','1',8816.43,9265.91,0.00,0.00,449.48,332615.20,0.00,0.00,0.00),('1','273','1','46',183,'3','1',29004.96,29354.99,0.00,0.00,350.03,241520.70,0.00,0.00,0.00),('1','273','1','46',184,'4','1',28561.06,28834.06,0.00,0.00,273.00,188370.00,0.00,0.00,0.00),('1','273','1','47',185,'1','1',4838.56,4838.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','47',186,'2','1',9265.91,9673.36,0.00,0.00,407.45,301513.00,0.00,0.00,0.00),('1','273','1','47',187,'3','1',29354.99,29752.27,0.00,0.00,397.28,274123.20,0.00,0.00,0.00),('1','273','1','47',188,'4','1',28834.06,29166.06,0.00,0.00,332.00,229080.00,0.00,0.00,0.00),('1','273','1','48',189,'1','1',4838.56,4838.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','48',190,'2','1',9673.36,9820.66,0.00,0.00,147.30,109002.00,0.00,0.00,0.00),('1','273','1','48',191,'3','1',29752.27,30327.77,0.00,0.00,575.50,391340.00,0.00,0.00,0.00),('1','273','1','48',192,'4','1',29166.06,29475.91,0.00,0.00,309.85,210698.00,0.00,0.00,0.00),('1','273','1','49',193,'1','1',4838.56,4838.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','49',194,'2','1',9820.66,10424.79,0.00,0.00,604.13,447056.20,0.00,0.00,0.00),('1','273','1','49',195,'3','1',30327.77,31641.77,0.00,0.00,1314.00,893520.00,0.00,0.00,0.00),('1','273','1','49',196,'4','1',29475.91,30856.91,0.00,0.00,1381.00,939080.00,0.00,0.00,0.00),('1','273','1','50',197,'1','1',4838.56,4838.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','50',198,'2','1',10424.79,10926.61,0.00,0.00,501.82,371346.80,0.00,0.00,0.00),('1','273','1','50',199,'3','1',31641.77,32143.88,0.00,0.00,502.11,341434.80,0.00,0.00,0.00),('1','273','1','50',200,'4','1',30856.91,31310.91,0.00,0.00,454.00,308720.00,0.00,0.00,0.00),('1','273','1','51',201,'1','1',4838.56,4838.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','51',202,'2','1',10926.61,11251.51,0.00,0.00,324.90,240426.00,0.00,0.00,0.00),('1','273','1','51',203,'3','1',32143.88,33387.88,0.00,0.00,1244.00,845920.00,0.00,0.00,0.00),('1','273','1','51',204,'4','1',31310.91,32626.41,0.00,0.00,1315.50,894540.00,0.00,0.00,0.00),('1','273','1','52',205,'1','1',4838.56,4838.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','52',206,'2','1',11251.51,11633.77,0.00,0.00,382.26,282872.40,0.00,0.00,0.00),('1','273','1','52',207,'3','1',33387.88,33946.88,0.00,0.00,559.00,380120.00,0.00,0.00,0.00),('1','273','1','52',208,'4','1',32626.41,32894.91,0.00,0.00,268.50,182580.00,0.00,0.00,0.00),('1','273','1','53',209,'1','1',4838.56,4839.64,0.00,0.00,1.08,799.20,0.00,0.00,0.00),('1','273','1','53',210,'2','1',11633.77,12007.64,0.00,0.00,373.87,276663.80,0.00,0.00,0.00),('1','273','1','53',211,'3','1',33946.88,35101.76,0.00,0.00,1154.88,785318.40,0.00,0.00,0.00),('1','273','1','53',212,'4','1',32894.91,34133.41,0.00,0.00,1238.50,842180.00,0.00,0.00,0.00),('1','273','1','54',213,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','54',214,'2','1',12007.64,12388.31,0.00,0.00,380.67,281695.80,0.00,0.00,0.00),('1','273','1','54',215,'3','1',35101.76,36394.47,0.00,0.00,1292.71,450642.80,0.00,0.00,0.00),('1','273','1','54',216,'4','1',34133.41,34865.41,0.00,0.00,732.00,497760.00,0.00,0.00,0.00),('1','273','1','55',217,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','55',218,'2','1',12388.31,12637.03,0.00,0.00,248.72,184052.80,0.00,0.00,0.00),('1','273','1','55',219,'3','1',36394.47,36716.47,0.00,0.00,322.00,218960.00,0.00,0.00,0.00),('1','273','1','55',220,'4','1',34865.41,35294.11,0.00,0.00,428.70,291516.00,0.00,0.00,0.00),('1','273','1','56',221,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','56',222,'2','1',12637.03,13000.39,0.00,0.00,363.36,268886.40,0.00,0.00,0.00),('1','273','1','56',223,'3','1',36716.47,37043.47,0.00,0.00,327.00,222360.00,0.00,0.00,0.00),('1','273','1','56',224,'4','1',35294.11,35745.11,0.00,0.00,451.00,306680.00,0.00,0.00,0.00),('1','273','1','57',225,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','57',226,'2','1',13000.39,13350.16,0.00,0.00,349.77,258089.80,0.00,0.00,0.00),('1','273','1','57',227,'3','1',37043.47,37155.23,0.00,0.00,111.76,75996.80,0.00,0.00,0.00),('1','273','1','57',228,'4','1',35745.11,35819.11,0.00,0.00,74.00,50320.00,0.00,0.00,0.00),('1','273','1','58',229,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','58',230,'2','1',13350.16,13857.48,0.00,0.00,507.32,375416.80,0.00,0.00,0.00),('1','273','1','58',231,'3','1',37155.23,38274.73,0.00,0.00,1119.50,761260.00,0.00,0.00,0.00),('1','273','1','58',232,'4','1',35819.11,36834.61,0.00,0.00,1015.50,690540.00,0.00,0.00,0.00),('1','273','1','59',233,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','59',234,'2','1',13857.48,14257.95,0.00,0.00,400.47,296347.80,0.00,0.00,0.00),('1','273','1','59',235,'3','1',38274.73,38849.73,0.00,0.00,575.00,391000.00,0.00,0.00,0.00),('1','273','1','59',236,'4','1',36834.61,37443.61,0.00,0.00,609.00,414120.00,0.00,0.00,0.00),('1','273','1','60',237,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','60',238,'2','1',14257.95,14690.65,0.00,0.00,432.70,320198.00,0.00,0.00,0.00),('1','273','1','60',239,'3','1',38849.73,40021.84,0.00,0.00,1172.11,797034.80,0.00,0.00,0.00),('1','273','1','60',240,'4','1',37443.61,38805.61,0.00,0.00,1362.00,926160.00,0.00,0.00,0.00),('1','273','1','61',241,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','61',242,'2','1',14690.65,14911.11,0.00,0.00,220.46,163140.40,0.00,0.00,0.00),('1','273','1','61',243,'3','1',40021.84,40615.84,0.00,0.00,594.00,403920.00,0.00,0.00,0.00),('1','273','1','61',244,'4','1',38805.61,39423.91,0.00,0.00,618.30,420444.00,0.00,0.00,0.00),('1','273','1','62',245,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','62',246,'2','1',14911.11,15207.20,0.00,0.00,296.09,219106.60,0.00,0.00,0.00),('1','273','1','62',247,'3','1',40615.84,41213.91,0.00,0.00,598.07,406687.60,0.00,0.00,0.00),('1','273','1','62',248,'4','1',39423.91,39834.91,0.00,0.00,411.00,279480.00,0.00,0.00,0.00),('1','273','1','63',249,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','63',250,'2','1',15207.20,15823.02,0.00,0.00,615.82,455719.50,0.00,0.00,0.00),('1','273','1','63',251,'3','1',41213.91,41814.91,0.00,0.00,601.00,408680.00,0.00,0.00,0.00),('1','273','1','63',252,'4','1',39834.91,40622.91,0.00,0.00,788.00,535840.00,0.00,0.00,0.00),('1','273','1','64',253,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','64',254,'2','1',15823.02,16405.11,0.00,0.00,582.09,430746.60,0.00,0.00,0.00),('1','273','1','64',255,'3','1',41814.91,42067.02,0.00,0.00,252.11,171434.80,0.00,0.00,0.00),('1','273','1','64',256,'4','1',40622.91,40766.91,0.00,0.00,144.00,97920.00,0.00,0.00,0.00),('1','273','1','65',257,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','65',258,'2','1',16405.11,16898.96,0.00,0.00,493.85,365449.00,0.00,0.00,0.00),('1','273','1','65',259,'3','1',42067.02,42565.02,0.00,0.00,498.00,338640.00,0.00,0.00,0.00),('1','273','1','65',260,'4','1',40766.91,41257.41,0.00,0.00,490.50,333540.00,0.00,0.00,0.00),('1','273','1','66',261,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','66',262,'2','1',16898.96,17288.58,0.00,0.00,389.62,288318.80,0.00,0.00,0.00),('1','273','1','66',263,'3','1',42565.02,43038.02,0.00,0.00,473.00,321640.00,0.00,0.00,0.00),('1','273','1','66',264,'4','1',41257.41,42003.91,0.00,0.00,746.50,507620.00,0.00,0.00,0.00),('1','273','1','67',265,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','67',266,'2','1',17288.58,17729.97,0.00,0.00,441.39,326628.60,0.00,0.00,0.00),('1','273','1','67',267,'3','1',43038.02,43335.02,0.00,0.00,297.00,201960.00,0.00,0.00,0.00),('1','273','1','67',268,'4','1',42003.91,42353.91,0.00,0.00,350.00,238000.00,0.00,0.00,0.00),('1','273','1','68',269,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','68',270,'2','1',17729.97,17729.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','68',271,'3','1',43335.02,43335.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','68',272,'4','1',42353.91,42353.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','69',273,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','69',274,'2','1',17729.97,18267.87,0.00,0.00,537.90,387970.00,0.00,0.00,0.00),('1','273','1','69',275,'3','1',43335.02,44237.02,0.00,0.00,902.00,604340.00,0.00,0.00,0.00),('1','273','1','69',276,'4','1',42353.91,42766.56,0.00,0.00,412.65,276475.50,0.00,0.00,0.00),('1','273','1','70',277,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','70',278,'2','1',18267.87,18682.95,0.00,0.00,415.08,298857.60,0.00,0.00,0.00),('1','273','1','70',279,'3','1',44237.02,45861.02,0.00,0.00,1624.00,1088080.00,0.00,0.00,0.00),('1','273','1','70',280,'4','1',42766.56,44197.86,0.00,0.00,1431.30,958971.00,0.00,0.00,0.00),('1','273','1','71',281,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','71',282,'2','1',18682.95,19063.13,0.00,0.00,380.18,273655.10,0.00,0.00,0.00),('1','273','1','71',283,'3','1',45861.02,47663.02,0.00,0.00,1802.00,1207340.00,0.00,0.00,0.00),('1','273','1','71',284,'4','1',44197.86,46429.86,0.00,0.00,2232.00,1495440.00,0.00,0.00,0.00),('1','273','1','72',285,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','72',286,'2','1',19063.13,19434.21,0.00,0.00,371.08,267177.60,0.00,0.00,0.00),('1','273','1','72',287,'3','1',47663.02,48791.79,0.00,0.00,1128.77,756275.90,0.00,0.00,0.00),('1','273','1','72',288,'4','1',46429.86,47309.86,0.00,0.00,880.00,589600.00,0.00,0.00,0.00),('1','273','1','73',289,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','73',290,'2','1',19434.21,19728.42,0.00,0.00,294.21,211831.20,0.00,0.00,0.00),('1','273','1','73',291,'3','1',48791.79,50764.29,0.00,0.00,1972.50,1321575.00,0.00,0.00,0.00),('1','273','1','73',292,'4','1',47309.86,49245.86,0.00,0.00,1936.00,1297120.00,0.00,0.00,0.00),('1','273','1','74',293,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','74',294,'2','1',19728.42,19728.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','74',295,'3','1',50764.29,50764.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','74',296,'4','1',49245.86,49245.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','75',297,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','75',298,'2','1',19728.42,20097.90,0.00,0.00,369.48,263069.76,0.00,0.00,0.00),('1','273','1','75',299,'3','1',50764.29,52076.97,0.00,0.00,1312.68,874244.88,0.00,0.00,0.00),('1','273','1','75',300,'4','1',49245.86,50676.86,0.00,0.00,1431.00,953046.00,0.00,0.00,0.00),('1','273','1','76',301,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','76',302,'2','1',20097.90,20482.39,0.00,0.00,384.49,273756.88,0.00,0.00,0.00),('1','273','1','76',303,'3','1',52076.97,54098.50,0.00,0.00,2021.53,1346338.98,0.00,0.00,0.00),('1','273','1','76',304,'4','1',50676.86,52717.36,0.00,0.00,2040.50,1358973.00,0.00,0.00,0.00),('1','273','1','77',305,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','77',306,'2','1',20482.39,20931.50,0.00,0.00,449.11,319766.32,0.00,0.00,0.00),('1','273','1','77',307,'3','1',54098.50,56841.31,0.00,0.00,2742.81,1826711.46,0.00,0.00,0.00),('1','273','1','77',308,'4','1',52717.36,55405.36,0.00,0.00,2688.00,1790208.00,0.00,0.00,0.00),('1','273','1','78',309,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','78',310,'2','1',20931.50,21422.10,0.00,0.00,490.60,349307.20,0.00,0.00,0.00),('1','273','1','78',311,'3','1',56841.31,59431.31,0.00,0.00,2590.00,1724940.00,0.00,0.00,0.00),('1','273','1','78',312,'4','1',55405.36,58064.77,0.00,0.00,2659.41,1771167.06,0.00,0.00,0.00),('1','273','1','79',313,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','79',314,'2','1',21422.10,21913.13,0.00,0.00,491.03,349613.36,0.00,0.00,0.00),('1','273','1','79',315,'3','1',59431.31,61399.31,0.00,0.00,1968.00,1310688.00,0.00,0.00,0.00),('1','273','1','79',316,'4','1',58064.77,60303.77,0.00,0.00,2239.00,1491174.00,0.00,0.00,0.00),('1','273','1','80',317,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','80',318,'2','1',21913.13,22130.41,0.00,0.00,217.28,154703.36,0.00,0.00,0.00),('1','273','1','80',319,'3','1',61399.31,61745.38,0.00,0.00,346.07,230482.62,0.00,0.00,0.00),('1','273','1','80',320,'4','1',60303.77,60547.77,0.00,0.00,244.00,162504.00,0.00,0.00,0.00),('1','273','1','81',321,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','81',322,'2','1',22130.41,22130.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','81',323,'3','1',61745.38,61745.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','81',324,'4','1',60547.77,60547.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','82',325,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','82',326,'2','1',22130.41,22295.88,0.00,0.00,165.47,117814.64,0.00,0.00,0.00),('1','273','1','82',327,'3','1',61745.38,62549.38,0.00,0.00,804.00,535464.00,0.00,0.00,0.00),('1','273','1','82',328,'4','1',60547.77,60907.77,0.00,0.00,360.00,239760.00,0.00,0.00,0.00),('1','273','1','83',329,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','83',330,'2','1',22295.88,22617.11,0.00,0.00,321.23,228715.76,0.00,0.00,0.00),('1','273','1','83',331,'3','1',62549.38,65491.17,0.00,0.00,2941.79,1959232.14,0.00,0.00,0.00),('1','273','1','83',332,'4','1',60907.77,63473.77,0.00,0.00,2566.00,1708956.00,0.00,0.00,0.00),('1','273','1','84',333,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','84',334,'2','1',22617.11,23111.83,0.00,0.00,494.72,352240.64,0.00,0.00,0.00),('1','273','1','84',335,'3','1',65491.17,69622.74,0.00,0.00,4131.57,2751625.62,0.00,0.00,0.00),('1','273','1','84',336,'4','1',63473.77,67168.29,0.00,0.00,3694.52,2460550.32,0.00,0.00,0.00),('1','273','1','85',337,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','85',338,'2','1',23111.83,23764.92,0.00,0.00,653.09,465000.08,0.00,0.00,0.00),('1','273','1','85',339,'3','1',69622.74,73374.55,0.00,0.00,3751.81,2498705.46,0.00,0.00,0.00),('1','273','1','85',340,'4','1',67168.29,71027.29,0.00,0.00,3859.00,2570094.00,0.00,0.00,0.00),('1','273','1','86',341,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','86',342,'2','1',23764.92,23843.16,0.00,0.00,78.24,55706.88,0.00,0.00,0.00),('1','273','1','86',343,'3','1',73374.55,73665.84,0.00,0.00,291.29,193999.14,0.00,0.00,0.00),('1','273','1','86',344,'4','1',71027.29,71272.29,0.00,0.00,245.00,163170.00,0.00,0.00,0.00),('1','273','1','87',345,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','87',346,'2','1',23843.16,23843.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','87',347,'3','1',73665.84,73665.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','87',348,'4','1',71272.29,71272.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','88',349,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','88',350,'2','1',23843.16,24334.54,0.00,0.00,491.38,349862.56,0.00,0.00,0.00),('1','273','1','88',351,'3','1',73665.84,76575.49,0.00,0.00,2909.65,1937826.90,0.00,0.00,0.00),('1','273','1','88',352,'4','1',71272.29,74539.79,0.00,0.00,3267.50,2176155.00,0.00,0.00,0.00),('1','273','1','89',353,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','89',354,'2','1',24334.54,25033.31,0.00,0.00,698.77,497524.24,0.00,0.00,0.00),('1','273','1','89',355,'3','1',76575.49,79305.13,0.00,0.00,2729.64,1817940.24,0.00,0.00,0.00),('1','273','1','89',356,'4','1',74539.79,77454.79,0.00,0.00,2915.00,1941390.00,0.00,0.00,0.00),('1','273','1','90',357,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','90',358,'2','1',25033.31,25647.92,0.00,0.00,614.61,437602.32,0.00,0.00,0.00),('1','273','1','90',359,'3','1',79305.13,80468.98,0.00,0.00,1163.85,775124.10,0.00,0.00,0.00),('1','273','1','90',360,'4','1',77454.79,77900.53,0.00,0.00,445.74,296862.84,0.00,0.00,0.00),('1','273','1','91',361,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','91',362,'2','1',25647.92,26022.70,0.00,0.00,374.78,266843.36,0.00,0.00,0.00),('1','273','1','91',363,'3','1',80468.98,84396.78,0.00,0.00,3927.80,2615914.80,0.00,0.00,0.00),('1','273','1','91',364,'4','1',77900.53,81476.53,0.00,0.00,3576.00,2381616.00,0.00,0.00,0.00),('1','273','1','92',365,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','92',366,'2','1',26022.70,26107.67,0.00,0.00,84.97,60498.64,0.00,0.00,0.00),('1','273','1','92',367,'3','1',84396.78,85223.78,0.00,0.00,827.00,550782.00,0.00,0.00,0.00),('1','273','1','92',368,'4','1',81476.53,82070.13,0.00,0.00,593.60,395337.60,0.00,0.00,0.00),('1','273','1','93',369,'1','1',4839.64,4839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','93',370,'2','1',26107.67,26107.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','93',371,'3','1',85223.78,85223.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','93',372,'4','1',82070.13,82070.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','94',373,'1','1',4839.64,4840.69,0.00,0.00,1.05,747.60,0.00,0.00,0.00),('1','273','1','94',374,'2','1',26107.67,26645.28,0.00,0.00,537.61,382816.32,0.00,0.00,0.00),('1','273','1','94',375,'3','1',85223.78,89911.88,0.00,0.00,4688.10,3141027.00,0.00,0.00,0.00),('1','273','1','94',376,'4','1',82070.13,86602.63,0.00,0.00,4532.50,3036775.00,0.00,0.00,0.00),('1','273','1','95',377,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','95',378,'2','1',26645.28,27182.04,0.00,0.00,536.76,382173.12,0.00,0.00,0.00),('1','273','1','95',379,'3','1',89911.88,93313.23,0.00,0.00,3401.35,2278904.50,0.00,0.00,0.00),('1','273','1','95',380,'4','1',86602.63,89228.63,0.00,0.00,2626.00,1759420.00,0.00,0.00,0.00),('1','273','1','96',381,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','96',382,'2','1',27182.04,27848.80,0.00,0.00,666.76,474733.12,0.00,0.00,0.00),('1','273','1','96',383,'3','1',93313.23,97045.58,0.00,0.00,3732.35,2500674.50,0.00,0.00,0.00),('1','273','1','96',384,'4','1',89228.63,92621.78,0.00,0.00,3393.15,2273410.50,0.00,0.00,0.00),('1','273','1','97',385,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','97',386,'2','1',27848.80,27848.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','97',387,'3','1',97045.58,97187.68,0.00,0.00,142.10,95207.00,0.00,0.00,0.00),('1','273','1','97',388,'4','1',92621.78,92621.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','98',389,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','98',390,'2','1',27848.80,27848.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','98',391,'3','1',97187.68,97187.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','98',392,'4','1',92621.78,92621.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','99',393,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','99',394,'2','1',27848.80,28470.52,0.00,0.00,621.72,442664.64,0.00,0.00,0.00),('1','273','1','99',395,'3','1',97187.68,100183.49,0.00,0.00,2995.81,2022171.75,0.00,0.00,0.00),('1','273','1','99',396,'4','1',92621.78,95109.86,0.00,0.00,2488.08,1679454.00,0.00,0.00,0.00),('1','273','1','100',397,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','100',398,'2','1',28470.52,28988.86,0.00,0.00,518.34,369058.08,0.00,0.00,0.00),('1','273','1','100',399,'3','1',100183.49,103007.99,0.00,0.00,2824.50,1906537.50,0.00,0.00,0.00),('1','273','1','100',400,'4','1',95109.86,97474.16,0.00,0.00,2364.30,1595902.50,0.00,0.00,0.00),('1','273','1','101',401,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','101',402,'2','1',28988.86,29537.98,0.00,0.00,549.12,390973.44,0.00,0.00,0.00),('1','273','1','101',403,'3','1',103007.99,105800.89,0.00,0.00,2792.90,1885207.50,0.00,0.00,0.00),('1','273','1','101',404,'4','1',97474.16,100525.33,0.00,0.00,3051.17,2059539.75,0.00,0.00,0.00),('1','273','1','102',405,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','102',406,'2','1',29537.98,29963.75,0.00,0.00,425.77,303148.24,0.00,0.00,0.00),('1','273','1','102',407,'3','1',105800.89,109021.61,0.00,0.00,3220.72,2173986.00,0.00,0.00,0.00),('1','273','1','102',408,'4','1',100525.33,103549.83,0.00,0.00,3024.50,2041537.50,0.00,0.00,0.00),('1','273','1','103',409,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','103',410,'2','1',29963.75,29963.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','103',411,'3','1',109021.61,109021.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','103',412,'4','1',103549.83,103549.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','104',413,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','104',414,'2','1',29963.75,30768.48,0.00,0.00,804.73,572967.76,0.00,0.00,0.00),('1','273','1','104',415,'3','1',109021.61,113864.32,0.00,0.00,4842.71,3268829.25,0.00,0.00,0.00),('1','273','1','104',416,'4','1',103549.83,107804.33,0.00,0.00,4254.50,2871787.50,0.00,0.00,0.00),('1','273','1','105',417,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','105',418,'2','1',30768.48,31557.85,0.00,0.00,789.37,562031.44,0.00,0.00,0.00),('1','273','1','105',419,'3','1',113864.32,117149.55,0.00,0.00,3285.23,2217530.25,0.00,0.00,0.00),('1','273','1','105',420,'4','1',107804.33,110374.28,0.00,0.00,2569.95,1734716.25,0.00,0.00,0.00),('1','273','1','106',421,'1','1',4840.69,4840.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','106',422,'2','1',31557.85,32180.83,0.00,0.00,622.98,443561.76,0.00,0.00,0.00),('1','273','1','106',423,'3','1',117149.55,118510.05,0.00,0.00,1360.50,918337.50,0.00,0.00,0.00),('1','273','1','106',424,'4','1',110374.28,111147.28,0.00,0.00,773.00,521775.00,0.00,0.00,0.00),('1','273','1','107',425,'1','1',4840.69,4850.69,0.00,0.00,10.00,7120.00,0.00,0.00,0.00),('1','273','1','107',426,'2','1',32180.83,32727.06,0.00,0.00,546.23,388915.76,0.00,0.00,0.00),('1','273','1','107',427,'3','1',118510.05,120893.12,0.00,0.00,2383.07,1608572.25,0.00,0.00,0.00),('1','273','1','107',428,'4','1',111147.28,113138.28,0.00,0.00,1991.00,1343925.00,0.00,0.00,0.00),('1','273','1','108',429,'1','1',4850.69,4850.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','108',430,'2','1',32727.06,32772.23,0.00,0.00,45.17,32161.04,0.00,0.00,0.00),('1','273','1','108',431,'3','1',120893.12,121382.12,0.00,0.00,489.00,330075.00,0.00,0.00,0.00),('1','273','1','108',432,'4','1',113138.28,113438.28,0.00,0.00,300.00,202500.00,0.00,0.00,0.00),('1','273','1','109',433,'1','1',4850.69,4850.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','109',434,'2','1',32772.23,32772.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','109',435,'3','1',121382.12,121382.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','109',436,'4','1',113438.28,113438.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','110',437,'1','1',4850.69,4873.69,0.00,0.00,23.00,16376.00,0.00,0.00,0.00),('1','273','1','110',438,'2','1',32772.23,33556.09,0.00,0.00,783.86,558053.56,0.00,0.00,0.00),('1','273','1','110',439,'3','1',121382.12,122978.52,0.00,0.00,1596.40,1077570.00,0.00,0.00,0.00),('1','273','1','110',440,'4','1',113438.28,114659.78,0.00,0.00,1221.50,824512.50,0.00,0.00,0.00),('1','273','1','111',441,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','111',442,'2','1',33556.09,33946.24,0.00,0.00,390.15,277786.80,0.00,0.00,0.00),('1','273','1','111',443,'3','1',122978.52,124861.52,0.00,0.00,1883.00,1271025.00,0.00,0.00,0.00),('1','273','1','111',444,'4','1',114659.78,115941.78,0.00,0.00,1282.00,865350.00,0.00,0.00,0.00),('1','273','1','112',445,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','112',446,'2','1',33946.24,34786.00,0.00,0.00,839.76,597909.12,0.00,0.00,0.00),('1','273','1','112',447,'3','1',124861.52,126089.96,0.00,0.00,1228.44,829197.00,0.00,0.00,0.00),('1','273','1','112',448,'4','1',115941.78,116651.78,0.00,0.00,710.00,479250.00,0.00,0.00,0.00),('1','273','1','113',449,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','113',450,'2','1',34786.00,35020.07,0.00,0.00,234.07,166657.84,0.00,0.00,0.00),('1','273','1','113',451,'3','1',126089.96,126905.96,0.00,0.00,816.00,550800.00,0.00,0.00,0.00),('1','273','1','113',452,'4','1',116651.78,117035.78,0.00,0.00,384.00,259200.00,0.00,0.00,0.00),('1','273','1','114',453,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','114',454,'2','1',35020.07,35555.53,0.00,0.00,535.46,381247.52,0.00,0.00,0.00),('1','273','1','114',455,'3','1',126905.96,128875.74,0.00,0.00,1969.78,1329601.50,0.00,0.00,0.00),('1','273','1','114',456,'4','1',117035.78,118135.78,0.00,0.00,1100.00,742500.00,0.00,0.00,0.00),('1','273','1','115',457,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','115',458,'2','1',35555.53,35946.15,0.00,0.00,390.62,278121.44,0.00,0.00,0.00),('1','273','1','115',459,'3','1',128875.74,130234.03,0.00,0.00,1358.29,916845.75,0.00,0.00,0.00),('1','273','1','115',460,'4','1',118135.78,119036.78,0.00,0.00,901.00,608175.00,0.00,0.00,0.00),('1','273','1','116',461,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','116',462,'2','1',35946.15,36233.36,0.00,0.00,287.21,204493.52,0.00,0.00,0.00),('1','273','1','116',463,'3','1',130234.03,131378.03,0.00,0.00,1144.00,766480.00,0.00,0.00,0.00),('1','273','1','116',464,'4','1',119036.78,119479.78,0.00,0.00,443.00,296810.00,0.00,0.00,0.00),('1','273','1','117',465,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','117',466,'2','1',36233.36,36644.25,0.00,0.00,410.89,292553.68,0.00,0.00,0.00),('1','273','1','117',467,'3','1',131378.03,133021.87,0.00,0.00,1643.84,1101372.80,0.00,0.00,0.00),('1','273','1','117',468,'4','1',119479.78,120637.08,0.00,0.00,1157.30,775391.00,0.00,0.00,0.00),('1','273','1','118',469,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','118',470,'2','1',36644.25,36883.57,0.00,0.00,239.32,170395.84,0.00,0.00,0.00),('1','273','1','118',471,'3','1',133021.87,133377.87,0.00,0.00,356.00,238520.00,0.00,0.00,0.00),('1','273','1','118',472,'4','1',120637.08,121035.08,0.00,0.00,398.00,266660.00,0.00,0.00,0.00),('1','273','1','119',473,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','119',474,'2','1',36883.57,36929.56,0.00,0.00,45.99,32744.88,0.00,0.00,0.00),('1','273','1','119',475,'3','1',133377.87,134067.93,0.00,0.00,690.06,462340.20,0.00,0.00,0.00),('1','273','1','119',476,'4','1',121035.08,121185.08,0.00,0.00,150.00,100500.00,0.00,0.00,0.00),('1','273','1','120',477,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','120',478,'2','1',36929.56,36929.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','120',479,'3','1',134067.93,134067.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','120',480,'4','1',121185.08,121185.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','121',481,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','121',482,'2','1',36929.56,37575.62,0.00,0.00,646.06,459994.72,0.00,0.00,0.00),('1','273','1','121',483,'3','1',134067.93,135740.87,0.00,0.00,1672.94,1120869.80,0.00,0.00,0.00),('1','273','1','121',484,'4','1',121185.08,122561.08,0.00,0.00,1376.00,921920.00,0.00,0.00,0.00),('1','273','1','122',485,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','122',486,'2','1',37575.62,38247.41,0.00,0.00,671.79,478314.48,0.00,0.00,0.00),('1','273','1','122',487,'3','1',135740.87,138263.37,0.00,0.00,2522.50,1690075.00,0.00,0.00,0.00),('1','273','1','122',488,'4','1',122561.08,123979.08,0.00,0.00,1418.00,950060.00,0.00,0.00,0.00),('1','273','1','123',489,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','123',490,'2','1',38247.41,38841.54,0.00,0.00,594.13,423020.56,0.00,0.00,0.00),('1','273','1','123',491,'3','1',138263.37,140155.54,0.00,0.00,1892.17,1267980.70,0.00,0.00,0.00),('1','273','1','123',492,'4','1',123979.08,125413.08,0.00,0.00,1434.00,960780.00,0.00,0.00,0.00),('1','273','1','124',493,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','124',494,'2','1',38841.54,39349.87,0.00,0.00,508.33,361930.96,0.00,0.00,0.00),('1','273','1','124',495,'3','1',140155.54,142212.54,0.00,0.00,2057.00,1378190.00,0.00,0.00,0.00),('1','273','1','124',496,'4','1',125413.08,126701.08,0.00,0.00,1288.00,862960.00,0.00,0.00,0.00),('1','273','1','125',497,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','125',498,'2','1',39349.87,40062.22,0.00,0.00,712.35,507193.20,0.00,0.00,0.00),('1','273','1','125',499,'3','1',142212.54,143742.09,0.00,0.00,1529.55,1024798.50,0.00,0.00,0.00),('1','273','1','125',500,'4','1',126701.08,127936.58,0.00,0.00,1235.50,827785.00,0.00,0.00,0.00),('1','273','1','126',501,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','126',502,'2','1',40062.22,40479.32,0.00,0.00,417.10,296975.20,0.00,0.00,0.00),('1','273','1','126',503,'3','1',143742.09,145445.82,0.00,0.00,1703.73,1141499.10,0.00,0.00,0.00),('1','273','1','126',504,'4','1',127936.58,128817.58,0.00,0.00,881.00,590270.00,0.00,0.00,0.00),('1','273','1','127',505,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','127',506,'2','1',40479.32,40799.08,0.00,0.00,319.76,227669.12,0.00,0.00,0.00),('1','273','1','127',507,'3','1',145445.82,146509.81,0.00,0.00,1063.99,712873.30,0.00,0.00,0.00),('1','273','1','127',508,'4','1',128817.58,129511.68,0.00,0.00,694.10,465047.00,0.00,0.00,0.00),('1','273','1','128',509,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','128',510,'2','1',40799.08,40799.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','128',511,'3','1',146509.81,146509.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','128',512,'4','1',129511.68,129511.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','129',513,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','129',514,'2','1',40799.08,41340.15,0.00,0.00,541.07,385241.84,0.00,0.00,0.00),('1','273','1','129',515,'3','1',146509.81,147640.81,0.00,0.00,1131.00,757770.00,0.00,0.00,0.00),('1','273','1','129',516,'4','1',129511.68,130026.18,0.00,0.00,514.50,344715.00,0.00,0.00,0.00),('1','273','1','130',517,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','130',518,'2','1',41340.15,41808.38,0.00,0.00,468.23,333379.76,0.00,0.00,0.00),('1','273','1','130',519,'3','1',147640.81,149682.52,0.00,0.00,2041.71,1368122.52,0.00,0.00,0.00),('1','273','1','130',520,'4','1',130026.18,131143.68,0.00,0.00,1117.50,748725.00,0.00,0.00,0.00),('1','273','1','131',521,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','131',522,'2','1',41808.38,42341.28,0.00,0.00,532.90,379424.80,0.00,0.00,0.00),('1','273','1','131',523,'3','1',149682.52,150816.52,0.00,0.00,1134.00,759780.00,0.00,0.00,0.00),('1','273','1','131',524,'4','1',131143.68,131767.68,0.00,0.00,624.00,418080.00,0.00,0.00,0.00),('1','273','1','132',525,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','132',526,'2','1',42341.28,42976.83,0.00,0.00,635.55,452511.60,0.00,0.00,0.00),('1','273','1','132',527,'3','1',150816.52,152048.52,0.00,0.00,1232.00,825440.00,0.00,0.00,0.00),('1','273','1','132',528,'4','1',131767.68,132643.69,0.00,0.00,876.01,586926.70,0.00,0.00,0.00),('1','273','1','133',529,'1','1',4873.69,4873.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','133',530,'2','1',42976.83,43393.95,0.00,0.00,417.12,296989.44,0.00,0.00,0.00),('1','273','1','133',531,'3','1',152048.52,153370.02,0.00,0.00,1321.50,885405.00,0.00,0.00,0.00),('1','273','1','133',532,'4','1',132643.69,133627.69,0.00,0.00,984.00,659280.00,0.00,0.00,0.00),('1','273','1','134',533,'1','1',4873.69,4878.69,0.00,0.00,5.00,3560.00,0.00,0.00,0.00),('1','273','1','134',534,'2','1',43393.95,43892.29,0.00,0.00,498.34,354818.08,0.00,0.00,0.00),('1','273','1','134',535,'3','1',153370.02,154753.52,0.00,0.00,1383.50,926945.00,0.00,0.00,0.00),('1','273','1','134',536,'4','1',133627.69,134633.69,0.00,0.00,1006.00,674020.00,0.00,0.00,0.00),('1','273','1','135',537,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','135',538,'2','1',43892.29,44400.21,0.00,0.00,507.92,361639.04,0.00,0.00,0.00),('1','273','1','135',539,'3','1',154753.52,156588.52,0.00,0.00,1835.00,1229450.00,0.00,0.00,0.00),('1','273','1','135',540,'4','1',134633.69,135742.39,0.00,0.00,1108.70,742829.00,0.00,0.00,0.00),('1','273','1','136',541,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','136',542,'2','1',44400.21,44960.82,0.00,0.00,560.61,399154.32,0.00,0.00,0.00),('1','273','1','136',543,'3','1',156588.52,157240.12,0.00,0.00,651.60,436572.00,0.00,0.00,0.00),('1','273','1','136',544,'4','1',135742.39,135942.39,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','273','1','137',545,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','137',546,'2','1',44960.82,45273.02,0.00,0.00,312.20,222286.40,0.00,0.00,0.00),('1','273','1','137',547,'3','1',157240.12,158957.62,0.00,0.00,1717.50,1151250.00,0.00,0.00,0.00),('1','273','1','137',548,'4','1',135942.39,137508.54,0.00,0.00,1566.15,1049320.50,0.00,0.00,0.00),('1','273','1','138',549,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','138',550,'2','1',45273.02,45273.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','138',551,'3','1',158957.62,158957.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','138',552,'4','1',137508.54,137508.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','139',553,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','139',554,'2','1',45273.02,45968.82,0.00,0.00,695.80,495409.60,0.00,0.00,0.00),('1','273','1','139',555,'3','1',158957.62,160706.59,0.00,0.00,1748.97,1171809.90,0.00,0.00,0.00),('1','273','1','139',556,'4','1',137508.54,138933.93,0.00,0.00,1425.39,955011.30,0.00,0.00,0.00),('1','273','1','140',557,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','140',558,'2','1',45968.82,46450.67,0.00,0.00,481.85,343077.20,0.00,0.00,0.00),('1','273','1','140',559,'3','1',160706.59,161454.59,0.00,0.00,748.00,501160.00,0.00,0.00,0.00),('1','273','1','140',560,'4','1',138933.93,139129.93,0.00,0.00,196.00,131320.00,0.00,0.00,0.00),('1','273','1','141',561,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','141',562,'2','1',46450.67,46885.07,0.00,0.00,434.40,309292.80,0.00,0.00,0.00),('1','273','1','141',563,'3','1',161454.59,162618.63,0.00,0.00,1164.04,779906.80,0.00,0.00,0.00),('1','273','1','141',564,'4','1',139129.93,140298.93,0.00,0.00,1169.00,783230.00,0.00,0.00,0.00),('1','273','1','142',565,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','142',566,'2','1',46885.07,47260.06,0.00,0.00,374.99,266992.88,0.00,0.00,0.00),('1','273','1','142',567,'3','1',162618.63,163348.63,0.00,0.00,730.00,486790.00,0.00,0.00,0.00),('1','273','1','142',568,'4','1',140298.93,140548.93,0.00,0.00,250.00,167150.00,0.00,0.00,0.00),('1','273','1','143',569,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','143',570,'2','1',47260.06,47772.04,0.00,0.00,511.98,364529.76,0.00,0.00,0.00),('1','273','1','143',571,'3','1',163348.63,164598.63,0.00,0.00,1250.00,828750.00,0.00,0.00,0.00),('1','273','1','143',572,'4','1',140548.93,141581.93,0.00,0.00,1033.00,684879.00,0.00,0.00,0.00),('1','273','1','144',573,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','144',574,'2','1',47772.04,48344.55,0.00,0.00,572.51,407627.12,0.00,0.00,0.00),('1','273','1','144',575,'3','1',164598.63,166501.63,0.00,0.00,1903.00,1261689.00,0.00,0.00,0.00),('1','273','1','144',576,'4','1',141581.93,143492.93,0.00,0.00,1911.00,1266993.00,0.00,0.00,0.00),('1','273','1','145',577,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','145',578,'2','1',48344.55,49016.67,0.00,0.00,672.12,478549.44,0.00,0.00,0.00),('1','273','1','145',579,'3','1',166501.63,167742.25,0.00,0.00,1240.62,822531.06,0.00,0.00,0.00),('1','273','1','145',580,'4','1',143492.93,144283.93,0.00,0.00,791.00,524433.00,0.00,0.00,0.00),('1','273','1','146',581,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','146',582,'2','1',49016.67,49494.98,0.00,0.00,478.31,340556.72,0.00,0.00,0.00),('1','273','1','146',583,'3','1',167742.25,170682.75,0.00,0.00,2940.50,1949551.50,0.00,0.00,0.00),('1','273','1','146',584,'4','1',144283.93,146267.43,0.00,0.00,1983.50,1315060.50,0.00,0.00,0.00),('1','273','1','147',585,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','147',586,'2','1',49494.98,49494.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','147',587,'3','1',170682.75,170682.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','147',588,'4','1',146267.43,146267.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','148',589,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','148',590,'2','1',49494.98,50211.94,0.00,0.00,716.96,510475.52,0.00,0.00,0.00),('1','273','1','148',591,'3','1',170682.75,172734.75,0.00,0.00,2052.00,1360476.00,0.00,0.00,0.00),('1','273','1','148',592,'4','1',146267.43,147632.93,0.00,0.00,1365.50,905326.50,0.00,0.00,0.00),('1','273','1','149',593,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','149',594,'2','1',50211.94,50633.09,0.00,0.00,421.15,299858.80,0.00,0.00,0.00),('1','273','1','149',595,'3','1',172734.75,173482.52,0.00,0.00,747.77,495771.51,0.00,0.00,0.00),('1','273','1','149',596,'4','1',147632.93,148350.93,0.00,0.00,718.00,476034.00,0.00,0.00,0.00),('1','273','1','150',597,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','150',598,'2','1',50633.09,51462.13,0.00,0.00,829.04,590276.48,0.00,0.00,0.00),('1','273','1','150',599,'3','1',173482.52,174974.03,0.00,0.00,1491.51,988871.13,0.00,0.00,0.00),('1','273','1','150',600,'4','1',148350.93,149735.50,0.00,0.00,1384.57,917969.91,0.00,0.00,0.00),('1','273','1','151',601,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','151',602,'2','1',51462.13,52162.13,0.00,0.00,700.00,498400.00,0.00,0.00,0.00),('1','273','1','151',603,'3','1',174974.03,175564.53,0.00,0.00,590.50,391501.50,0.00,0.00,0.00),('1','273','1','151',604,'4','1',149735.50,150503.50,0.00,0.00,768.00,509184.00,0.00,0.00,0.00),('1','273','1','152',605,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','152',606,'2','1',52162.13,52757.55,0.00,0.00,595.42,423977.04,0.00,0.00,0.00),('1','273','1','152',607,'3','1',175564.53,177073.03,0.00,0.00,1508.50,1000135.50,0.00,0.00,0.00),('1','273','1','152',608,'4','1',150503.50,151610.50,0.00,0.00,1107.00,733941.00,0.00,0.00,0.00),('1','273','1','153',609,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','153',610,'2','1',52757.55,53194.34,0.00,0.00,436.79,310994.48,0.00,0.00,0.00),('1','273','1','153',611,'3','1',177073.03,177660.03,0.00,0.00,587.00,389181.00,0.00,0.00,0.00),('1','273','1','153',612,'4','1',151610.50,151955.50,0.00,0.00,345.00,228735.00,0.00,0.00,0.00),('1','273','1','154',613,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','154',614,'2','1',53194.34,53726.75,0.00,0.00,532.41,379075.92,0.00,0.00,0.00),('1','273','1','154',615,'3','1',177660.03,179022.74,0.00,0.00,1362.71,903476.73,0.00,0.00,0.00),('1','273','1','154',616,'4','1',151955.50,152778.50,0.00,0.00,823.00,545649.00,0.00,0.00,0.00),('1','273','1','155',617,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','155',618,'2','1',53726.75,54092.16,0.00,0.00,365.41,260171.92,0.00,0.00,0.00),('1','273','1','155',619,'3','1',179022.74,179510.24,0.00,0.00,487.50,323212.50,0.00,0.00,0.00),('1','273','1','155',620,'4','1',152778.50,152937.50,0.00,0.00,159.00,105417.00,0.00,0.00,0.00),('1','273','1','156',621,'1','1',4878.69,4878.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','156',622,'2','1',54092.16,54837.33,0.00,0.00,745.17,530561.04,0.00,0.00,0.00),('1','273','1','156',623,'3','1',179510.24,180505.24,0.00,0.00,995.00,659685.00,0.00,0.00,0.00),('1','273','1','156',624,'4','1',152937.50,153658.50,0.00,0.00,721.00,478023.00,0.00,0.00,0.00),('1','273','1','157',625,'1','1',4878.69,4881.19,0.00,0.00,2.50,1780.00,0.00,0.00,0.00),('1','273','1','157',626,'2','1',54837.33,55199.34,0.00,0.00,362.01,257751.12,0.00,0.00,0.00),('1','273','1','157',627,'3','1',180505.24,181327.24,0.00,0.00,822.00,545182.00,0.00,0.00,0.00),('1','273','1','157',628,'4','1',153658.50,154537.50,0.00,0.00,879.00,582777.00,0.00,0.00,0.00),('1','273','1','158',629,'1','1',4881.19,4881.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','158',630,'2','1',55199.34,55199.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','158',631,'3','1',181327.24,181327.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','158',632,'4','1',154537.50,154537.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','159',633,'1','1',4881.19,4881.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','159',634,'2','1',55199.34,55601.43,0.00,0.00,402.09,286288.08,0.00,0.00,0.00),('1','273','1','159',635,'3','1',181327.24,181725.24,0.00,0.00,398.00,262680.00,0.00,0.00,0.00),('1','273','1','159',636,'4','1',154537.50,155013.50,0.00,0.00,476.00,314160.00,0.00,0.00,0.00),('1','273','1','160',637,'1','1',4881.19,4881.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','160',638,'2','1',55601.43,56277.96,0.00,0.00,676.53,481689.36,0.00,0.00,0.00),('1','273','1','160',639,'3','1',181725.24,182593.24,0.00,0.00,868.00,572880.00,0.00,0.00,0.00),('1','273','1','160',640,'4','1',155013.50,155600.50,0.00,0.00,587.00,387420.00,0.00,0.00,0.00),('1','273','1','161',641,'1','1',4881.19,4881.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','161',642,'2','1',56277.96,56795.78,0.00,0.00,517.82,368687.84,0.00,0.00,0.00),('1','273','1','161',643,'3','1',182593.24,184212.74,0.00,0.00,1619.50,1068870.00,0.00,0.00,0.00),('1','273','1','161',644,'4','1',155600.50,156995.50,0.00,0.00,1395.00,920700.00,0.00,0.00,0.00),('1','273','1','162',645,'1','1',4881.19,4881.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','162',646,'2','1',56795.78,57308.40,0.00,0.00,512.62,364985.44,0.00,0.00,0.00),('1','273','1','162',647,'3','1',184212.74,184959.25,0.00,0.00,746.51,492696.60,0.00,0.00,0.00),('1','273','1','162',648,'4','1',156995.50,157247.50,0.00,0.00,252.00,166320.00,0.00,0.00,0.00),('1','273','1','163',649,'1','1',4881.19,4881.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','163',650,'2','1',57308.40,57477.70,0.00,0.00,169.30,120541.60,0.00,0.00,0.00),('1','273','1','163',651,'3','1',184959.25,185555.35,0.00,0.00,596.10,393426.00,0.00,0.00,0.00),('1','273','1','163',652,'4','1',157247.50,158060.50,0.00,0.00,813.00,536580.00,0.00,0.00,0.00),('1','273','1','164',653,'1','1',4881.19,4892.43,0.00,0.00,11.24,8002.88,0.00,0.00,0.00),('1','273','1','164',654,'2','1',57477.70,58364.22,0.00,0.00,886.52,631202.24,0.00,0.00,0.00),('1','273','1','164',655,'3','1',185555.35,186253.44,0.00,0.00,698.09,460739.40,0.00,0.00,0.00),('1','273','1','164',656,'4','1',158060.50,158546.50,0.00,0.00,486.00,320760.00,0.00,0.00,0.00),('1','273','1','165',657,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','165',658,'2','1',58364.22,58933.95,0.00,0.00,569.73,405647.76,0.00,0.00,0.00),('1','273','1','165',659,'3','1',186253.44,186744.44,0.00,0.00,491.00,324060.00,0.00,0.00,0.00),('1','273','1','165',660,'4','1',158546.50,158811.89,0.00,0.00,265.39,175157.40,0.00,0.00,0.00),('1','273','1','166',661,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','166',662,'2','1',58933.95,59518.19,0.00,0.00,584.24,415978.88,0.00,0.00,0.00),('1','273','1','166',663,'3','1',186744.44,187914.34,0.00,0.00,1169.90,772134.00,0.00,0.00,0.00),('1','273','1','166',664,'4','1',158811.89,159348.89,0.00,0.00,537.00,354420.00,0.00,0.00,0.00),('1','273','1','167',665,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','167',666,'2','1',59518.19,60026.33,0.00,0.00,508.14,361795.68,0.00,0.00,0.00),('1','273','1','167',667,'3','1',187914.34,188829.53,0.00,0.00,915.19,604025.40,0.00,0.00,0.00),('1','273','1','167',668,'4','1',159348.89,159647.89,0.00,0.00,299.00,197340.00,0.00,0.00,0.00),('1','273','1','168',669,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','168',670,'2','1',60026.33,60568.69,0.00,0.00,542.36,386160.32,0.00,0.00,0.00),('1','273','1','168',671,'3','1',188829.53,189734.18,0.00,0.00,904.65,597069.00,0.00,0.00,0.00),('1','273','1','168',672,'4','1',159647.89,160488.39,0.00,0.00,840.50,554730.00,0.00,0.00,0.00),('1','273','1','169',673,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','169',674,'2','1',60568.69,61114.68,0.00,0.00,545.99,388744.88,0.00,0.00,0.00),('1','273','1','169',675,'3','1',189734.18,190386.90,0.00,0.00,652.72,430795.20,0.00,0.00,0.00),('1','273','1','169',676,'4','1',160488.39,160963.39,0.00,0.00,475.00,313500.00,0.00,0.00,0.00),('1','273','1','170',677,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','170',678,'2','1',61114.68,61650.04,0.00,0.00,535.36,381176.32,0.00,0.00,0.00),('1','273','1','170',679,'3','1',190386.90,190386.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','170',680,'4','1',160963.39,160963.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','170',681,'5','1',0.00,313.00,0.00,0.00,313.00,206580.00,0.00,0.00,0.00),('1','273','1','170',682,'6','1',0.00,466.66,0.00,0.00,466.66,307995.60,0.00,0.00,0.00),('1','273','1','171',683,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','171',684,'2','1',61650.04,61808.85,0.00,0.00,158.81,113072.72,0.00,0.00,0.00),('1','273','1','171',685,'3','1',190386.90,190694.00,0.00,0.00,307.10,202686.00,0.00,0.00,0.00),('1','273','1','171',686,'4','1',160963.39,160963.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','171',687,'5','1',313.00,623.16,0.00,0.00,310.16,204705.60,0.00,0.00,0.00),('1','273','1','171',688,'6','1',466.66,716.66,0.00,0.00,250.00,165000.00,0.00,0.00,0.00),('1','273','1','172',689,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','172',690,'2','1',61808.85,61808.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','172',691,'3','1',190694.00,190694.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','172',692,'4','1',160963.39,160963.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','172',693,'5','1',623.16,623.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','172',694,'6','1',716.66,716.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','173',695,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','173',696,'2','1',61808.85,62234.97,0.00,0.00,426.12,306795.20,0.00,0.00,0.00),('1','273','1','173',697,'3','1',190694.00,190724.00,0.00,0.00,30.00,20100.00,0.00,0.00,0.00),('1','273','1','173',698,'4','1',160963.39,160963.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','173',699,'5','1',623.16,823.16,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','273','1','173',700,'6','1',716.66,916.66,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','273','1','174',701,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','174',702,'2','1',62234.97,62727.29,0.00,0.00,492.32,354470.40,0.00,0.00,0.00),('1','273','1','174',703,'3','1',190724.00,190944.00,0.00,0.00,220.00,147400.00,0.00,0.00,0.00),('1','273','1','174',704,'4','1',160963.39,160963.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','174',705,'5','1',823.16,1108.66,0.00,0.00,285.50,191285.00,0.00,0.00,0.00),('1','273','1','174',706,'6','1',916.66,970.66,0.00,0.00,54.00,36180.00,0.00,0.00,0.00),('1','273','1','175',707,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','175',708,'2','1',62727.29,63280.18,0.00,0.00,552.89,398080.80,0.00,0.00,0.00),('1','273','1','175',709,'3','1',190944.00,191196.50,0.00,0.00,252.50,169175.00,0.00,0.00,0.00),('1','273','1','175',710,'4','1',160963.39,160963.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','175',711,'5','1',1108.66,1644.66,0.00,0.00,536.00,359120.00,0.00,0.00,0.00),('1','273','1','175',712,'6','1',970.66,1448.66,0.00,0.00,478.00,320260.00,0.00,0.00,0.00),('1','273','1','176',713,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','176',714,'2','1',63280.18,63909.95,0.00,0.00,629.77,453434.40,0.00,0.00,0.00),('1','273','1','176',715,'3','1',191196.50,191339.50,0.00,0.00,143.00,95810.00,0.00,0.00,0.00),('1','273','1','176',716,'4','1',160963.39,160963.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','176',717,'5','1',1644.66,1886.66,0.00,0.00,242.00,162140.00,0.00,0.00,0.00),('1','273','1','176',718,'6','1',1448.66,1693.66,0.00,0.00,245.00,164150.00,0.00,0.00,0.00),('1','273','1','177',719,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','177',720,'2','1',63909.95,64471.22,0.00,0.00,561.27,404114.40,0.00,0.00,0.00),('1','273','1','177',721,'3','1',191339.50,192033.50,0.00,0.00,694.00,464980.00,0.00,0.00,0.00),('1','273','1','177',722,'4','1',160963.39,160963.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','177',723,'5','1',1886.66,2532.66,0.00,0.00,646.00,432820.00,0.00,0.00,0.00),('1','273','1','177',724,'6','1',1693.66,2272.66,0.00,0.00,579.00,387930.00,0.00,0.00,0.00),('1','273','1','178',725,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','178',726,'2','1',64471.22,64994.11,0.00,0.00,522.89,376480.80,0.00,0.00,0.00),('1','273','1','178',727,'3','1',192033.50,192230.23,0.00,0.00,196.73,131809.10,0.00,0.00,0.00),('1','273','1','178',728,'4','1',160963.39,160993.39,0.00,0.00,30.00,20100.00,0.00,0.00,0.00),('1','273','1','178',729,'5','1',2532.66,2852.66,0.00,0.00,320.00,214400.00,0.00,0.00,0.00),('1','273','1','178',730,'6','1',2272.66,2512.66,0.00,0.00,240.00,160800.00,0.00,0.00,0.00),('1','273','1','179',731,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','179',732,'2','1',64994.11,65541.71,0.00,0.00,547.60,394272.00,0.00,0.00,0.00),('1','273','1','179',733,'3','1',192230.23,192959.23,0.00,0.00,729.00,488430.00,0.00,0.00,0.00),('1','273','1','179',734,'4','1',160993.39,161193.39,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','273','1','179',735,'5','1',2852.66,3552.66,0.00,0.00,700.00,469000.00,0.00,0.00,0.00),('1','273','1','179',736,'6','1',2512.66,2786.66,0.00,0.00,274.00,183580.00,0.00,0.00,0.00),('1','273','1','180',737,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','180',738,'2','1',65541.71,66287.46,0.00,0.00,745.75,536940.00,0.00,0.00,0.00),('1','273','1','180',739,'3','1',192959.23,193222.72,0.00,0.00,263.49,176538.30,0.00,0.00,0.00),('1','273','1','180',740,'4','1',161193.39,161193.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','180',741,'5','1',3552.66,3806.66,0.00,0.00,254.00,170180.00,0.00,0.00,0.00),('1','273','1','180',742,'6','1',2786.66,2960.66,0.00,0.00,174.00,116580.00,0.00,0.00,0.00),('1','273','1','181',743,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','181',744,'2','1',66287.46,66698.22,0.00,0.00,410.76,295747.20,0.00,0.00,0.00),('1','273','1','181',745,'3','1',193222.72,193891.22,0.00,0.00,668.50,447895.00,0.00,0.00,0.00),('1','273','1','181',746,'4','1',161193.39,161493.39,0.00,0.00,300.00,201000.00,0.00,0.00,0.00),('1','273','1','181',747,'5','1',3806.66,4547.66,0.00,0.00,741.00,496470.00,0.00,0.00,0.00),('1','273','1','181',748,'6','1',2960.66,3570.66,0.00,0.00,610.00,408700.00,0.00,0.00,0.00),('1','273','1','182',749,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','182',750,'2','1',66698.22,67306.39,0.00,0.00,608.17,437882.40,0.00,0.00,0.00),('1','273','1','182',751,'3','1',193891.22,193956.22,0.00,0.00,65.00,43550.00,0.00,0.00,0.00),('1','273','1','182',752,'4','1',161493.39,161493.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','182',753,'5','1',4547.66,4656.66,0.00,0.00,109.00,73030.00,0.00,0.00,0.00),('1','273','1','182',754,'6','1',3570.66,3683.66,0.00,0.00,113.00,75710.00,0.00,0.00,0.00),('1','273','1','183',755,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','183',756,'2','1',67306.39,67788.32,0.00,0.00,481.93,346989.60,0.00,0.00,0.00),('1','273','1','183',757,'3','1',193956.22,194026.22,0.00,0.00,70.00,46750.00,0.00,0.00,0.00),('1','273','1','183',758,'4','1',161493.39,161493.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','183',759,'5','1',4656.66,4902.82,0.00,0.00,246.16,162465.60,0.00,0.00,0.00),('1','273','1','183',760,'6','1',3683.66,3757.66,0.00,0.00,74.00,48840.00,0.00,0.00,0.00),('1','273','1','184',761,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','184',762,'2','1',67788.32,68136.21,0.00,0.00,347.89,250480.80,0.00,0.00,0.00),('1','273','1','184',763,'3','1',194026.22,195407.05,0.00,0.00,1380.83,911347.80,0.00,0.00,0.00),('1','273','1','184',764,'4','1',161493.39,162293.39,0.00,0.00,800.00,528000.00,0.00,0.00,0.00),('1','273','1','184',765,'5','1',4902.82,6536.82,0.00,0.00,1634.00,1078440.00,0.00,0.00,0.00),('1','273','1','184',766,'6','1',3757.66,5320.66,0.00,0.00,1563.00,1031580.00,0.00,0.00,0.00),('1','273','1','185',767,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','185',768,'2','1',68136.21,68332.97,0.00,0.00,196.76,141667.20,0.00,0.00,0.00),('1','273','1','185',769,'3','1',195407.05,195931.32,0.00,0.00,524.27,346018.20,0.00,0.00,0.00),('1','273','1','185',770,'4','1',162293.39,162293.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','185',771,'5','1',6536.82,6986.82,0.00,0.00,450.00,297000.00,0.00,0.00,0.00),('1','273','1','185',772,'6','1',5320.66,5757.30,0.00,0.00,436.64,288182.40,0.00,0.00,0.00),('1','273','1','186',773,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','186',774,'2','1',68332.97,68332.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','186',775,'3','1',195931.32,195931.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','186',776,'4','1',162293.39,162293.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','186',777,'5','1',6986.82,6986.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','186',778,'6','1',5757.30,5757.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','187',779,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','187',780,'2','1',68332.97,68966.34,0.00,0.00,633.37,456026.40,0.00,0.00,0.00),('1','273','1','187',781,'3','1',195931.32,196816.82,0.00,0.00,885.50,584430.00,0.00,0.00,0.00),('1','273','1','187',782,'4','1',162293.39,162295.91,0.00,0.00,2.52,1663.20,0.00,0.00,0.00),('1','273','1','187',783,'5','1',6986.82,8716.82,0.00,0.00,1730.00,1141800.00,0.00,0.00,0.00),('1','273','1','187',784,'6','1',5757.30,7789.30,0.00,0.00,2032.00,1341120.00,0.00,0.00,0.00),('1','273','1','188',785,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','188',786,'2','1',68966.34,69619.46,0.00,0.00,653.12,470246.40,0.00,0.00,0.00),('1','273','1','188',787,'3','1',196816.82,197270.82,0.00,0.00,454.00,299640.00,0.00,0.00,0.00),('1','273','1','188',788,'4','1',162295.91,162342.82,0.00,0.00,46.91,30960.60,0.00,0.00,0.00),('1','273','1','188',789,'5','1',8716.82,9443.82,0.00,0.00,727.00,479820.00,0.00,0.00,0.00),('1','273','1','188',790,'6','1',7789.30,8634.30,0.00,0.00,845.00,557700.00,0.00,0.00,0.00),('1','273','1','189',791,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','189',792,'2','1',69619.46,70080.09,0.00,0.00,460.63,331653.60,0.00,0.00,0.00),('1','273','1','189',793,'3','1',197270.82,198835.32,0.00,0.00,1564.50,1032570.00,0.00,0.00,0.00),('1','273','1','189',794,'4','1',162342.82,163388.88,0.00,0.00,1046.06,690399.60,0.00,0.00,0.00),('1','273','1','189',795,'5','1',9443.82,11117.80,0.00,0.00,1673.98,1104826.80,0.00,0.00,0.00),('1','273','1','189',796,'6','1',8634.30,10427.60,0.00,0.00,1793.30,1183578.00,0.00,0.00,0.00),('1','273','1','190',797,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','190',798,'2','1',70080.09,70463.16,0.00,0.00,383.07,275810.40,0.00,0.00,0.00),('1','273','1','190',799,'3','1',198835.32,200163.32,0.00,0.00,1328.00,876480.00,0.00,0.00,0.00),('1','273','1','190',800,'4','1',163388.88,163398.06,0.00,0.00,9.18,6058.80,0.00,0.00,0.00),('1','273','1','190',801,'5','1',11117.80,12073.80,0.00,0.00,956.00,630960.00,0.00,0.00,0.00),('1','273','1','190',802,'6','1',10427.60,11512.24,0.00,0.00,1084.64,715862.40,0.00,0.00,0.00),('1','273','1','191',803,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','191',804,'2','1',70463.16,70969.48,0.00,0.00,506.32,364550.40,0.00,0.00,0.00),('1','273','1','191',805,'3','1',200163.32,201516.23,0.00,0.00,1352.91,892920.60,0.00,0.00,0.00),('1','273','1','191',806,'4','1',163398.06,163498.06,0.00,0.00,100.00,66000.00,0.00,0.00,0.00),('1','273','1','191',807,'5','1',12073.80,13267.80,0.00,0.00,1194.00,788040.00,0.00,0.00,0.00),('1','273','1','191',808,'6','1',11512.24,12892.24,0.00,0.00,1380.00,910800.00,0.00,0.00,0.00),('1','273','1','192',809,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','192',810,'2','1',70969.48,71075.54,0.00,0.00,106.06,76363.20,0.00,0.00,0.00),('1','273','1','192',811,'3','1',201516.23,202166.07,0.00,0.00,649.84,428894.40,0.00,0.00,0.00),('1','273','1','192',812,'4','1',163498.06,163733.06,0.00,0.00,235.00,155100.00,0.00,0.00,0.00),('1','273','1','192',813,'5','1',13267.80,13867.80,0.00,0.00,600.00,396000.00,0.00,0.00,0.00),('1','273','1','192',814,'6','1',12892.24,13355.24,0.00,0.00,463.00,305580.00,0.00,0.00,0.00),('1','273','1','193',815,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','193',816,'2','1',71075.54,71075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','193',817,'3','1',202166.07,202166.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','193',818,'4','1',163733.06,163733.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','193',819,'5','1',13867.80,13867.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','193',820,'6','1',13355.24,13355.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','194',821,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','194',822,'2','1',71075.54,71595.29,0.00,0.00,519.75,374220.00,0.00,0.00,0.00),('1','273','1','194',823,'3','1',202166.07,203705.44,0.00,0.00,1539.37,1015984.20,0.00,0.00,0.00),('1','273','1','194',824,'4','1',163733.06,164553.44,0.00,0.00,820.38,541450.80,0.00,0.00,0.00),('1','273','1','194',825,'5','1',13867.80,15844.80,0.00,0.00,1977.00,1304820.00,0.00,0.00,0.00),('1','273','1','194',826,'6','1',13355.24,15024.24,0.00,0.00,1669.00,1101540.00,0.00,0.00,0.00),('1','273','1','195',827,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','195',828,'2','1',71595.29,72048.80,0.00,0.00,453.51,326527.20,0.00,0.00,0.00),('1','273','1','195',829,'3','1',203705.44,204083.44,0.00,0.00,378.00,249480.00,0.00,0.00,0.00),('1','273','1','195',830,'4','1',164553.44,164730.94,0.00,0.00,177.50,117150.00,0.00,0.00,0.00),('1','273','1','195',831,'5','1',15844.80,16334.80,0.00,0.00,490.00,323400.00,0.00,0.00,0.00),('1','273','1','195',832,'6','1',15024.24,15570.78,0.00,0.00,546.54,360716.40,0.00,0.00,0.00),('1','273','1','196',833,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','196',834,'2','1',72048.80,72609.12,0.00,0.00,560.32,403430.40,0.00,0.00,0.00),('1','273','1','196',835,'3','1',204083.44,204395.94,0.00,0.00,312.50,206250.00,0.00,0.00,0.00),('1','273','1','196',836,'4','1',164730.94,165831.44,0.00,0.00,1100.50,726330.00,0.00,0.00,0.00),('1','273','1','196',837,'5','1',16334.80,17735.57,0.00,0.00,1400.77,924508.20,0.00,0.00,0.00),('1','273','1','196',838,'6','1',15570.78,16760.78,0.00,0.00,1190.00,785400.00,0.00,0.00,0.00),('1','273','1','197',839,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','197',840,'2','1',72609.12,73176.48,0.00,0.00,567.36,408499.20,0.00,0.00,0.00),('1','273','1','197',841,'3','1',204395.94,204395.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','197',842,'4','1',165831.44,166771.44,0.00,0.00,940.00,620400.00,0.00,0.00,0.00),('1','273','1','197',843,'5','1',17735.57,19089.57,0.00,0.00,1354.00,893640.00,0.00,0.00,0.00),('1','273','1','197',844,'6','1',16760.78,17581.78,0.00,0.00,821.00,541860.00,0.00,0.00,0.00),('1','273','1','198',845,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','198',846,'2','1',73176.48,73698.50,0.00,0.00,522.02,375854.40,0.00,0.00,0.00),('1','273','1','198',847,'3','1',204395.94,204395.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','198',848,'4','1',166771.44,167476.04,0.00,0.00,704.60,465036.00,0.00,0.00,0.00),('1','273','1','198',849,'5','1',19089.57,20132.76,0.00,0.00,1043.19,688505.40,0.00,0.00,0.00),('1','273','1','198',850,'6','1',17581.78,18368.78,0.00,0.00,787.00,519420.00,0.00,0.00,0.00),('1','273','1','199',851,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','199',852,'2','1',73698.50,74262.27,0.00,0.00,563.77,405914.40,0.00,0.00,0.00),('1','273','1','199',853,'3','1',204395.94,204395.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','199',854,'4','1',167476.04,168681.34,0.00,0.00,1205.30,795498.00,0.00,0.00,0.00),('1','273','1','199',855,'5','1',20132.76,21135.72,0.00,0.00,1002.96,661953.60,0.00,0.00,0.00),('1','273','1','199',856,'6','1',18368.78,19187.56,0.00,0.00,818.78,540394.80,0.00,0.00,0.00),('1','273','1','200',857,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','200',858,'2','1',74262.27,74482.66,0.00,0.00,220.39,158680.80,0.00,0.00,0.00),('1','273','1','200',859,'3','1',204395.94,204395.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','200',860,'4','1',168681.34,169268.34,0.00,0.00,587.00,387420.00,0.00,0.00,0.00),('1','273','1','200',861,'5','1',21135.72,21415.72,0.00,0.00,280.00,184800.00,0.00,0.00,0.00),('1','273','1','200',862,'6','1',19187.56,19485.56,0.00,0.00,298.00,196680.00,0.00,0.00,0.00),('1','273','1','201',863,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','201',864,'2','1',74482.66,74482.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','201',865,'3','1',204395.94,204395.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','201',866,'4','1',169268.34,169268.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','201',867,'5','1',21415.72,21415.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','201',868,'6','1',19485.56,19485.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','202',869,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','202',870,'2','1',74482.66,74906.88,0.00,0.00,424.22,305438.40,0.00,0.00,0.00),('1','273','1','202',871,'3','1',204395.94,204395.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','202',872,'4','1',169268.34,169680.40,0.00,0.00,412.06,271959.60,0.00,0.00,0.00),('1','273','1','202',873,'5','1',21415.72,21766.72,0.00,0.00,351.00,231660.00,0.00,0.00,0.00),('1','273','1','202',874,'6','1',19485.56,20022.06,0.00,0.00,536.50,354090.00,0.00,0.00,0.00),('1','273','1','203',875,'1','1',4892.43,4892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','203',876,'2','1',74906.88,75451.00,0.00,0.00,544.12,391766.40,0.00,0.00,0.00),('1','273','1','203',877,'3','1',204395.94,204505.94,0.00,0.00,110.00,72600.00,0.00,0.00,0.00),('1','273','1','203',878,'4','1',169680.40,170518.60,0.00,0.00,838.20,553212.00,0.00,0.00,0.00),('1','273','1','203',879,'5','1',21766.72,22553.22,0.00,0.00,786.50,519090.00,0.00,0.00,0.00),('1','273','1','203',880,'6','1',20022.06,20638.06,0.00,0.00,616.00,406560.00,0.00,0.00,0.00),('1','273','1','204',881,'1','1',4892.43,4893.82,0.00,0.00,1.39,1000.80,0.00,0.00,0.00),('1','273','1','204',882,'2','1',75451.00,75996.66,0.00,0.00,545.66,392875.20,0.00,0.00,0.00),('1','273','1','204',883,'3','1',204505.94,204505.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','204',884,'4','1',170518.60,171476.10,0.00,0.00,957.50,631950.00,0.00,0.00,0.00),('1','273','1','204',885,'5','1',22553.22,23791.22,0.00,0.00,1238.00,817080.00,0.00,0.00,0.00),('1','273','1','204',886,'6','1',20638.06,21905.06,0.00,0.00,1267.00,836220.00,0.00,0.00,0.00),('1','273','1','205',887,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','205',888,'2','1',75996.66,76528.47,0.00,0.00,531.81,382903.20,0.00,0.00,0.00),('1','273','1','205',889,'3','1',204505.94,204505.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','205',890,'4','1',171476.10,172218.03,0.00,0.00,741.93,489673.80,0.00,0.00,0.00),('1','273','1','205',891,'5','1',23791.22,24401.22,0.00,0.00,610.00,402600.00,0.00,0.00,0.00),('1','273','1','205',892,'6','1',21905.06,22780.56,0.00,0.00,875.50,577830.00,0.00,0.00,0.00),('1','273','1','206',893,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','206',894,'2','1',76528.47,77118.96,0.00,0.00,590.49,425220.90,0.00,0.00,0.00),('1','273','1','206',895,'3','1',204505.94,204505.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','206',896,'4','1',172218.03,172674.03,0.00,0.00,456.00,300960.00,0.00,0.00,0.00),('1','273','1','206',897,'5','1',24401.22,25477.12,0.00,0.00,1075.90,710094.00,0.00,0.00,0.00),('1','273','1','206',898,'6','1',22780.56,23654.56,0.00,0.00,874.00,576840.00,0.00,0.00,0.00),('1','273','1','207',899,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','207',900,'2','1',77118.96,77489.94,0.00,0.00,370.98,267105.60,0.00,0.00,0.00),('1','273','1','207',901,'3','1',204505.94,204505.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','207',902,'4','1',172674.03,172924.03,0.00,0.00,250.00,165000.00,0.00,0.00,0.00),('1','273','1','207',903,'5','1',25477.12,25850.12,0.00,0.00,373.00,246180.00,0.00,0.00,0.00),('1','273','1','207',904,'6','1',23654.56,24042.75,0.00,0.00,388.19,256205.40,0.00,0.00,0.00),('1','273','1','208',905,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','208',906,'2','1',77489.94,77970.80,0.00,0.00,480.86,346219.20,0.00,0.00,0.00),('1','273','1','208',907,'3','1',204505.94,204506.94,0.00,0.00,1.00,720.00,0.00,0.00,0.00),('1','273','1','208',908,'4','1',172924.03,173354.03,0.00,0.00,430.00,283800.00,0.00,0.00,0.00),('1','273','1','208',909,'5','1',25850.12,26525.74,0.00,0.00,675.62,445909.20,0.00,0.00,0.00),('1','273','1','208',910,'6','1',24042.75,24950.17,0.00,0.00,907.42,598897.20,0.00,0.00,0.00),('1','273','1','209',911,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','209',912,'2','1',77970.80,78546.49,0.00,0.00,575.69,414496.80,0.00,0.00,0.00),('1','273','1','209',913,'3','1',204506.94,204506.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','209',914,'4','1',173354.03,174082.03,0.00,0.00,728.00,480480.00,0.00,0.00,0.00),('1','273','1','209',915,'5','1',26525.74,27023.74,0.00,0.00,498.00,328680.00,0.00,0.00,0.00),('1','273','1','209',916,'6','1',24950.17,25453.17,0.00,0.00,503.00,331980.00,0.00,0.00,0.00),('1','273','1','210',917,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','210',918,'2','1',78546.49,79065.22,0.00,0.00,518.73,373485.60,0.00,0.00,0.00),('1','273','1','210',919,'3','1',204506.94,204506.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','210',920,'4','1',174082.03,174923.76,0.00,0.00,841.73,555541.80,0.00,0.00,0.00),('1','273','1','210',921,'5','1',27023.74,27446.64,0.00,0.00,422.90,279114.00,0.00,0.00,0.00),('1','273','1','210',922,'6','1',25453.17,26411.55,0.00,0.00,958.38,632530.80,0.00,0.00,0.00),('1','273','1','211',923,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','211',924,'2','1',79065.22,79072.30,0.00,0.00,7.08,5097.60,0.00,0.00,0.00),('1','273','1','211',925,'3','1',204506.94,204506.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','211',926,'4','1',174923.76,175073.76,0.00,0.00,150.00,99000.00,0.00,0.00,0.00),('1','273','1','211',927,'5','1',27446.64,27896.93,0.00,0.00,450.29,297191.40,0.00,0.00,0.00),('1','273','1','211',928,'6','1',26411.55,26616.55,0.00,0.00,205.00,135300.00,0.00,0.00,0.00),('1','273','1','212',929,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','212',930,'2','1',79072.30,79072.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','212',931,'3','1',204506.94,204506.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','212',932,'4','1',175073.76,175073.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','212',933,'5','1',27896.93,27896.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','212',934,'6','1',26616.55,26616.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','213',935,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','213',936,'2','1',79072.30,79352.81,0.00,0.00,280.51,201967.20,0.00,0.00,0.00),('1','273','1','213',937,'3','1',204506.94,204506.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','213',938,'4','1',175073.76,175303.76,0.00,0.00,230.00,151800.00,0.00,0.00,0.00),('1','273','1','213',939,'5','1',27896.93,28356.93,0.00,0.00,460.00,303600.00,0.00,0.00,0.00),('1','273','1','213',940,'6','1',26616.55,26993.25,0.00,0.00,376.70,248622.00,0.00,0.00,0.00),('1','273','1','214',941,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','214',942,'2','1',79352.81,80041.65,0.00,0.00,688.84,495964.80,0.00,0.00,0.00),('1','273','1','214',943,'3','1',204506.94,205202.94,0.00,0.00,696.00,459360.00,0.00,0.00,0.00),('1','273','1','214',944,'4','1',175303.76,176175.76,0.00,0.00,872.00,575520.00,0.00,0.00,0.00),('1','273','1','214',945,'5','1',28356.93,29276.93,0.00,0.00,920.00,607200.00,0.00,0.00,0.00),('1','273','1','214',946,'6','1',26993.25,27712.25,0.00,0.00,719.00,474540.00,0.00,0.00,0.00),('1','273','1','215',947,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','215',948,'2','1',80041.65,80569.14,0.00,0.00,527.49,379792.80,0.00,0.00,0.00),('1','273','1','215',949,'3','1',205202.94,206233.94,0.00,0.00,1031.00,680460.00,0.00,0.00,0.00),('1','273','1','215',950,'4','1',176175.76,176829.76,0.00,0.00,654.00,431640.00,0.00,0.00,0.00),('1','273','1','215',951,'5','1',29276.93,30266.93,0.00,0.00,990.00,653400.00,0.00,0.00,0.00),('1','273','1','215',952,'6','1',27712.25,28573.14,0.00,0.00,860.89,568187.40,0.00,0.00,0.00),('1','273','1','216',953,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','216',954,'2','1',80569.14,81024.52,0.00,0.00,455.38,327873.60,0.00,0.00,0.00),('1','273','1','216',955,'3','1',206233.94,206504.94,0.00,0.00,271.00,178860.00,0.00,0.00,0.00),('1','273','1','216',956,'4','1',176829.76,177137.26,0.00,0.00,307.50,202950.00,0.00,0.00,0.00),('1','273','1','216',957,'5','1',30266.93,30728.53,0.00,0.00,461.60,304656.00,0.00,0.00,0.00),('1','273','1','216',958,'6','1',28573.14,29121.64,0.00,0.00,548.50,362010.00,0.00,0.00,0.00),('1','273','1','217',959,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','217',960,'2','1',81024.52,81776.12,0.00,0.00,751.60,541152.00,0.00,0.00,0.00),('1','273','1','217',961,'3','1',206504.94,207354.94,0.00,0.00,850.00,561000.00,0.00,0.00,0.00),('1','273','1','217',962,'4','1',177137.26,178053.06,0.00,0.00,915.80,604428.00,0.00,0.00,0.00),('1','273','1','217',963,'5','1',30728.53,31690.03,0.00,0.00,961.50,634590.00,0.00,0.00,0.00),('1','273','1','217',964,'6','1',29121.64,29743.64,0.00,0.00,622.00,410520.00,0.00,0.00,0.00),('1','273','1','218',965,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','218',966,'2','1',81776.12,82455.55,0.00,0.00,679.43,489189.60,0.00,0.00,0.00),('1','273','1','218',967,'3','1',207354.94,208235.94,0.00,0.00,881.00,581460.00,0.00,0.00,0.00),('1','273','1','218',968,'4','1',178053.06,179016.06,0.00,0.00,963.00,635580.00,0.00,0.00,0.00),('1','273','1','218',969,'5','1',31690.03,32718.82,0.00,0.00,1028.79,679001.40,0.00,0.00,0.00),('1','273','1','218',970,'6','1',29743.64,30542.14,0.00,0.00,798.50,527010.00,0.00,0.00,0.00),('1','273','1','219',971,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','219',972,'2','1',82455.55,83077.42,0.00,0.00,621.87,447746.40,0.00,0.00,0.00),('1','273','1','219',973,'3','1',208235.94,208844.36,0.00,0.00,608.42,401557.20,0.00,0.00,0.00),('1','273','1','219',974,'4','1',179016.06,179226.06,0.00,0.00,210.00,138600.00,0.00,0.00,0.00),('1','273','1','219',975,'5','1',32718.82,33009.82,0.00,0.00,291.00,192060.00,0.00,0.00,0.00),('1','273','1','219',976,'6','1',30542.14,30781.14,0.00,0.00,239.00,157740.00,0.00,0.00,0.00),('1','273','1','220',977,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','220',978,'2','1',83077.42,83437.69,0.00,0.00,360.27,259394.40,0.00,0.00,0.00),('1','273','1','220',979,'3','1',208844.36,209764.36,0.00,0.00,920.00,607200.00,0.00,0.00,0.00),('1','273','1','220',980,'4','1',179226.06,179824.93,0.00,0.00,598.87,395254.20,0.00,0.00,0.00),('1','273','1','220',981,'5','1',33009.82,33535.82,0.00,0.00,526.00,347160.00,0.00,0.00,0.00),('1','273','1','220',982,'6','1',30781.14,31339.14,0.00,0.00,558.00,368280.00,0.00,0.00,0.00),('1','273','1','221',983,'1','1',4893.82,4893.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','221',984,'2','1',83437.69,83437.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','221',985,'3','1',209764.36,209764.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','221',986,'4','1',179824.93,179824.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','221',987,'5','1',33535.82,33535.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','221',988,'6','1',31339.14,31339.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','222',989,'1','1',4893.82,4906.32,0.00,0.00,12.50,9000.00,0.00,0.00,0.00),('1','273','1','222',990,'2','1',83437.69,84016.88,0.00,0.00,579.19,417016.80,0.00,0.00,0.00),('1','273','1','222',991,'3','1',209764.36,210428.86,0.00,0.00,664.50,438570.00,0.00,0.00,0.00),('1','273','1','222',992,'4','1',179824.93,180422.93,0.00,0.00,598.00,394680.00,0.00,0.00,0.00),('1','273','1','222',993,'5','1',33535.82,34413.74,0.00,0.00,877.92,579427.20,0.00,0.00,0.00),('1','273','1','222',994,'6','1',31339.14,32253.18,0.00,0.00,914.04,603266.40,0.00,0.00,0.00),('1','273','1','223',995,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','223',996,'2','1',84016.88,84641.69,0.00,0.00,624.81,449863.20,0.00,0.00,0.00),('1','273','1','223',997,'3','1',210428.86,210975.32,0.00,0.00,546.46,360663.60,0.00,0.00,0.00),('1','273','1','223',998,'4','1',180422.93,180726.44,0.00,0.00,303.51,200316.60,0.00,0.00,0.00),('1','273','1','223',999,'5','1',34413.74,35083.22,0.00,0.00,669.48,441856.80,0.00,0.00,0.00),('1','273','1','223',1000,'6','1',32253.18,32893.18,0.00,0.00,640.00,422400.00,0.00,0.00,0.00),('1','273','1','224',1001,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','224',1002,'2','1',84641.69,85229.82,0.00,0.00,588.13,423541.50,0.00,0.00,0.00),('1','273','1','224',1003,'3','1',210975.32,211859.32,0.00,0.00,884.00,583440.00,0.00,0.00,0.00),('1','273','1','224',1004,'4','1',180726.44,180726.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','224',1005,'5','1',35083.22,35840.72,0.00,0.00,757.50,499950.00,0.00,0.00,0.00),('1','273','1','224',1006,'6','1',32893.18,33499.68,0.00,0.00,606.50,400290.00,0.00,0.00,0.00),('1','273','1','225',1007,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','225',1008,'2','1',85229.82,86001.57,0.00,0.00,771.75,555660.00,0.00,0.00,0.00),('1','273','1','225',1009,'3','1',211859.32,212401.32,0.00,0.00,542.00,357720.00,0.00,0.00,0.00),('1','273','1','225',1010,'4','1',180726.44,180726.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','225',1011,'5','1',35840.72,36931.34,0.00,0.00,1090.62,719809.20,0.00,0.00,0.00),('1','273','1','225',1012,'6','1',33499.68,34177.68,0.00,0.00,678.00,447480.00,0.00,0.00,0.00),('1','273','1','226',1013,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','226',1014,'2','1',86001.57,86708.49,0.00,0.00,706.92,508982.40,0.00,0.00,0.00),('1','273','1','226',1015,'3','1',212401.32,213110.82,0.00,0.00,709.50,468270.00,0.00,0.00,0.00),('1','273','1','226',1016,'4','1',180726.44,181009.74,0.00,0.00,283.30,186978.00,0.00,0.00,0.00),('1','273','1','226',1017,'5','1',36931.34,38673.55,0.00,0.00,1742.21,1149858.60,0.00,0.00,0.00),('1','273','1','226',1018,'6','1',34177.68,35200.68,0.00,0.00,1023.00,675180.00,0.00,0.00,0.00),('1','273','1','227',1019,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','227',1020,'2','1',86708.49,87635.35,0.00,0.00,926.86,667339.20,0.00,0.00,0.00),('1','273','1','227',1021,'3','1',213110.82,213974.82,0.00,0.00,864.00,570240.00,0.00,0.00,0.00),('1','273','1','227',1022,'4','1',181009.74,181282.74,0.00,0.00,273.00,180180.00,0.00,0.00,0.00),('1','273','1','227',1023,'5','1',38673.55,39563.52,0.00,0.00,889.97,587380.20,0.00,0.00,0.00),('1','273','1','227',1024,'6','1',35200.68,35696.18,0.00,0.00,495.50,327030.00,0.00,0.00,0.00),('1','273','1','228',1025,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','228',1026,'2','1',87635.35,88294.04,0.00,0.00,658.69,474256.80,0.00,0.00,0.00),('1','273','1','228',1027,'3','1',213974.82,214829.82,0.00,0.00,855.00,564300.00,0.00,0.00,0.00),('1','273','1','228',1028,'4','1',181282.74,181306.00,0.00,0.00,23.26,15351.60,0.00,0.00,0.00),('1','273','1','228',1029,'5','1',39563.52,40338.27,0.00,0.00,774.75,511335.00,0.00,0.00,0.00),('1','273','1','228',1030,'6','1',35696.18,36444.68,0.00,0.00,748.50,494010.00,0.00,0.00,0.00),('1','273','1','229',1031,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','229',1032,'2','1',88294.04,88329.71,0.00,0.00,35.67,25682.40,0.00,0.00,0.00),('1','273','1','229',1033,'3','1',214829.82,214879.82,0.00,0.00,50.00,33000.00,0.00,0.00,0.00),('1','273','1','229',1034,'4','1',181306.00,181365.64,0.00,0.00,59.64,39362.40,0.00,0.00,0.00),('1','273','1','229',1035,'5','1',40338.27,41032.27,0.00,0.00,694.00,458040.00,0.00,0.00,0.00),('1','273','1','229',1036,'6','1',36444.68,36699.68,0.00,0.00,255.00,168300.00,0.00,0.00,0.00),('1','273','1','230',1037,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','230',1038,'2','1',88329.71,88329.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','230',1039,'3','1',214879.82,214879.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','230',1040,'4','1',181365.64,181365.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','230',1041,'5','1',41032.27,41032.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','230',1042,'6','1',36699.68,36699.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','231',1043,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','231',1044,'2','1',88329.71,90305.81,0.00,0.00,1976.10,1422792.00,0.00,0.00,0.00),('1','273','1','231',1045,'3','1',214879.82,215757.82,0.00,0.00,878.00,579480.00,0.00,0.00,0.00),('1','273','1','231',1046,'4','1',181365.64,181870.14,0.00,0.00,504.50,332970.00,0.00,0.00,0.00),('1','273','1','231',1047,'5','1',41032.27,43435.18,0.00,0.00,2402.91,1585920.60,0.00,0.00,0.00),('1','273','1','231',1048,'6','1',36699.68,38214.22,0.00,0.00,1514.54,999596.40,0.00,0.00,0.00),('1','273','1','232',1049,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','232',1050,'2','1',90305.81,91260.71,0.00,0.00,954.90,688435.48,0.00,0.00,0.00),('1','273','1','232',1051,'3','1',215757.82,215757.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','232',1052,'4','1',181870.14,181870.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','232',1053,'5','1',43435.18,44636.70,0.00,0.00,1201.52,793003.20,0.00,0.00,0.00),('1','273','1','232',1054,'6','1',38214.22,39432.22,0.00,0.00,1218.00,803880.00,0.00,0.00,0.00),('1','273','1','233',1055,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','233',1056,'2','1',91260.71,91917.01,0.00,0.00,656.30,472536.00,0.00,0.00,0.00),('1','273','1','233',1057,'3','1',215757.82,216435.82,0.00,0.00,678.00,447480.00,0.00,0.00,0.00),('1','273','1','233',1058,'4','1',181870.14,181870.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','233',1059,'5','1',44636.70,46490.70,0.00,0.00,1854.00,1223640.00,0.00,0.00,0.00),('1','273','1','233',1060,'6','1',39432.22,40118.72,0.00,0.00,686.50,453090.00,0.00,0.00,0.00),('1','273','1','234',1061,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','234',1062,'2','1',91917.01,92427.26,0.00,0.00,510.25,367380.00,0.00,0.00,0.00),('1','273','1','234',1063,'3','1',216435.82,217177.46,0.00,0.00,741.64,489482.40,0.00,0.00,0.00),('1','273','1','234',1064,'4','1',181870.14,181870.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','234',1065,'5','1',46490.70,47292.70,0.00,0.00,802.00,529320.00,0.00,0.00,0.00),('1','273','1','234',1066,'6','1',40118.72,40443.72,0.00,0.00,325.00,214500.00,0.00,0.00,0.00),('1','273','1','235',1067,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','235',1068,'2','1',92427.26,92882.13,0.00,0.00,454.87,327506.40,0.00,0.00,0.00),('1','273','1','235',1069,'3','1',217177.46,217730.46,0.00,0.00,553.00,364980.00,0.00,0.00,0.00),('1','273','1','235',1070,'4','1',181870.14,181870.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','235',1071,'5','1',47292.70,47929.70,0.00,0.00,637.00,420420.00,0.00,0.00,0.00),('1','273','1','235',1072,'6','1',40443.72,41013.30,0.00,0.00,569.58,375922.80,0.00,0.00,0.00),('1','273','1','236',1073,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','236',1074,'2','1',92882.13,93385.14,0.00,0.00,503.01,362167.20,0.00,0.00,0.00),('1','273','1','236',1075,'3','1',217730.46,218269.27,0.00,0.00,538.81,355614.60,0.00,0.00,0.00),('1','273','1','236',1076,'4','1',181870.14,181871.14,0.00,0.00,1.00,660.00,0.00,0.00,0.00),('1','273','1','236',1077,'5','1',47929.70,48789.70,0.00,0.00,860.00,567600.00,0.00,0.00,0.00),('1','273','1','236',1078,'6','1',41013.30,41633.30,0.00,0.00,620.00,409200.00,0.00,0.00,0.00),('1','273','1','237',1079,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','237',1080,'2','1',93385.14,93557.13,0.00,0.00,171.99,123832.80,0.00,0.00,0.00),('1','273','1','237',1081,'3','1',218269.27,219225.27,0.00,0.00,956.00,630960.00,0.00,0.00,0.00),('1','273','1','237',1082,'4','1',181871.14,182021.14,0.00,0.00,150.00,99000.00,0.00,0.00,0.00),('1','273','1','237',1083,'5','1',48789.70,49649.91,0.00,0.00,860.21,567738.60,0.00,0.00,0.00),('1','273','1','237',1084,'6','1',41633.30,42540.14,0.00,0.00,906.84,598514.40,0.00,0.00,0.00),('1','273','1','238',1085,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','238',1086,'2','1',93557.13,93557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','238',1087,'3','1',219225.27,219225.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','238',1088,'4','1',182021.14,182021.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','238',1089,'5','1',49649.91,49649.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','238',1090,'6','1',42540.14,42540.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','239',1091,'1','1',4906.32,4906.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','239',1092,'2','1',93557.13,93747.03,0.00,0.00,189.90,136728.00,0.00,0.00,0.00),('1','273','1','239',1093,'3','1',219225.27,220192.27,0.00,0.00,967.00,638220.00,0.00,0.00,0.00),('1','273','1','239',1094,'4','1',182021.14,182123.14,0.00,0.00,102.00,67320.00,0.00,0.00,0.00),('1','273','1','239',1095,'5','1',49649.91,50560.75,0.00,0.00,910.84,601154.40,0.00,0.00,0.00),('1','273','1','239',1096,'6','1',42540.14,43383.14,0.00,0.00,843.00,556380.00,0.00,0.00,0.00),('1','273','1','240',1097,'1','1',4906.32,4907.71,0.00,0.00,1.39,1000.80,0.00,0.00,0.00),('1','273','1','240',1098,'2','1',93747.03,94688.16,0.00,0.00,941.13,677613.60,0.00,0.00,0.00),('1','273','1','240',1099,'3','1',220192.27,221002.05,0.00,0.00,809.78,534454.80,0.00,0.00,0.00),('1','273','1','240',1100,'4','1',182123.14,182123.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','240',1101,'5','1',50560.75,52465.75,0.00,0.00,1905.00,1257300.00,0.00,0.00,0.00),('1','273','1','240',1102,'6','1',43383.14,44053.64,0.00,0.00,670.50,442530.00,0.00,0.00,0.00),('1','273','1','241',1103,'1','1',4907.71,4907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','241',1104,'2','1',94688.16,95534.53,0.00,0.00,846.37,609696.40,0.00,0.00,0.00),('1','273','1','241',1105,'3','1',221002.05,221295.05,0.00,0.00,293.00,194442.00,0.00,0.00,0.00),('1','273','1','241',1106,'4','1',182123.14,182178.14,0.00,0.00,55.00,36300.00,0.00,0.00,0.00),('1','273','1','241',1107,'5','1',52465.75,53104.65,0.00,0.00,638.90,421674.00,0.00,0.00,0.00),('1','273','1','241',1108,'6','1',44053.64,44253.64,0.00,0.00,200.00,132000.00,0.00,0.00,0.00),('1','273','1','242',1109,'1','1',4907.71,4907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','242',1110,'2','1',95534.53,96281.10,0.00,0.00,746.57,537530.40,0.00,0.00,0.00),('1','273','1','242',1111,'3','1',221295.05,222254.92,0.00,0.00,959.87,633514.20,0.00,0.00,0.00),('1','273','1','242',1112,'4','1',182178.14,182327.14,0.00,0.00,149.00,98340.00,0.00,0.00,0.00),('1','273','1','242',1113,'5','1',53104.65,54314.25,0.00,0.00,1209.60,798336.00,0.00,0.00,0.00),('1','273','1','242',1114,'6','1',44253.64,45320.64,0.00,0.00,1067.00,704220.00,0.00,0.00,0.00),('1','273','1','243',1115,'1','1',4907.71,4907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','243',1116,'2','1',96281.10,96918.43,0.00,0.00,637.33,458877.60,0.00,0.00,0.00),('1','273','1','243',1117,'3','1',222254.92,224364.22,0.00,0.00,2109.30,1392138.00,0.00,0.00,0.00),('1','273','1','243',1118,'4','1',182327.14,182327.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','243',1119,'5','1',54314.25,56475.80,0.00,0.00,2161.55,1426623.00,0.00,0.00,0.00),('1','273','1','243',1120,'6','1',45320.64,47152.37,0.00,0.00,1831.73,1208941.80,0.00,0.00,0.00),('1','273','1','244',1121,'1','1',4907.71,4907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','244',1122,'2','1',96918.43,97424.47,0.00,0.00,506.04,364348.80,0.00,0.00,0.00),('1','273','1','244',1123,'3','1',224364.22,225700.35,0.00,0.00,1336.13,881845.80,0.00,0.00,0.00),('1','273','1','244',1124,'4','1',182327.14,182327.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','244',1125,'5','1',56475.80,57675.30,0.00,0.00,1199.50,791670.00,0.00,0.00,0.00),('1','273','1','244',1126,'6','1',47152.37,48302.37,0.00,0.00,1150.00,759000.00,0.00,0.00,0.00),('1','273','1','245',1127,'1','1',4907.71,4907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','245',1128,'2','1',97424.47,97424.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','245',1129,'3','1',225700.35,225700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','245',1130,'4','1',182327.14,182327.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','245',1131,'5','1',57675.30,57675.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','245',1132,'6','1',48302.37,48302.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','246',1133,'1','1',4907.71,4907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','246',1134,'2','1',97424.47,98086.91,0.00,0.00,662.44,476956.80,0.00,0.00,0.00),('1','273','1','246',1135,'3','1',225700.35,226253.25,0.00,0.00,552.90,364914.00,0.00,0.00,0.00),('1','273','1','246',1136,'4','1',182327.14,182371.74,0.00,0.00,44.60,29436.00,0.00,0.00,0.00),('1','273','1','246',1137,'5','1',57675.30,58434.30,0.00,0.00,759.00,500940.00,0.00,0.00,0.00),('1','273','1','246',1138,'6','1',48302.37,49429.37,0.00,0.00,1127.00,743820.00,0.00,0.00,0.00),('1','273','1','247',1139,'1','1',4907.71,4907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','247',1140,'2','1',98086.91,98524.41,0.00,0.00,437.50,315030.00,0.00,0.00,0.00),('1','273','1','247',1141,'3','1',226253.25,226962.25,0.00,0.00,709.00,467940.00,0.00,0.00,0.00),('1','273','1','247',1142,'4','1',182371.74,182371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','247',1143,'5','1',58434.30,59606.80,0.00,0.00,1172.50,773850.00,0.00,0.00,0.00),('1','273','1','247',1144,'6','1',49429.37,49935.37,0.00,0.00,506.00,333960.00,0.00,0.00,0.00),('1','273','1','248',1145,'1','1',4907.71,4907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','248',1146,'2','1',98524.41,99118.58,0.00,0.00,594.17,427802.40,0.00,0.00,0.00),('1','273','1','248',1147,'3','1',226962.25,227215.94,0.00,0.00,253.69,167435.40,0.00,0.00,0.00),('1','273','1','248',1148,'4','1',182371.74,182371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','248',1149,'5','1',59606.80,59867.80,0.00,0.00,261.00,172260.00,0.00,0.00,0.00),('1','273','1','248',1150,'6','1',49935.37,50293.77,0.00,0.00,358.40,236544.00,0.00,0.00,0.00),('1','273','1','249',1151,'1','1',4907.71,4907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','249',1152,'2','1',99118.58,99630.30,0.00,0.00,511.72,368438.40,0.00,0.00,0.00),('1','273','1','249',1153,'3','1',227215.94,228008.71,0.00,0.00,792.77,523228.20,0.00,0.00,0.00),('1','273','1','249',1154,'4','1',182371.74,182371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','249',1155,'5','1',59867.80,60567.30,0.00,0.00,699.50,461670.00,0.00,0.00,0.00),('1','273','1','249',1156,'6','1',50293.77,51580.77,0.00,0.00,1287.00,849420.00,0.00,0.00,0.00),('1','273','1','250',1157,'1','1',4907.71,4907.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','250',1158,'2','1',99630.30,100159.61,0.00,0.00,529.31,381103.20,0.00,0.00,0.00),('1','273','1','250',1159,'3','1',228008.71,229136.67,0.00,0.00,1127.96,744453.60,0.00,0.00,0.00),('1','273','1','250',1160,'4','1',182371.74,182371.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','250',1161,'5','1',60567.30,62533.30,0.00,0.00,1966.00,1297560.00,0.00,0.00,0.00),('1','273','1','250',1162,'6','1',51580.77,52398.77,0.00,0.00,818.00,539880.00,0.00,0.00,0.00),('1','273','1','251',1163,'1','1',4907.71,4924.98,0.00,0.00,17.27,12434.40,0.00,0.00,0.00),('1','273','1','251',1164,'2','1',100159.61,100665.54,0.00,0.00,505.93,364269.60,0.00,0.00,0.00),('1','273','1','251',1165,'3','1',229136.67,229671.67,0.00,0.00,535.00,353100.00,0.00,0.00,0.00),('1','273','1','251',1166,'4','1',182371.74,182631.50,0.00,0.00,259.76,171441.60,0.00,0.00,0.00),('1','273','1','251',1167,'5','1',62533.30,63341.98,0.00,0.00,808.68,533728.80,0.00,0.00,0.00),('1','273','1','251',1168,'6','1',52398.77,52664.56,0.00,0.00,265.79,175421.40,0.00,0.00,0.00),('1','273','1','252',1169,'1','1',4924.98,4940.26,0.00,0.00,15.28,11001.60,0.00,0.00,0.00),('1','273','1','252',1170,'2','1',100665.54,101253.52,0.00,0.00,587.98,423345.60,0.00,0.00,0.00),('1','273','1','252',1171,'3','1',229671.67,230544.12,0.00,0.00,872.45,575817.00,0.00,0.00,0.00),('1','273','1','252',1172,'4','1',182631.50,183490.50,0.00,0.00,859.00,566940.00,0.00,0.00,0.00),('1','273','1','252',1173,'5','1',63341.98,63747.42,0.00,0.00,405.44,267590.40,0.00,0.00,0.00),('1','273','1','252',1174,'6','1',52664.56,53100.56,0.00,0.00,436.00,287760.00,0.00,0.00,0.00),('1','273','1','253',1175,'1','1',4940.26,4945.40,0.00,0.00,5.14,3700.80,0.00,0.00,0.00),('1','273','1','253',1176,'2','1',101253.52,102056.19,0.00,0.00,802.67,573182.40,0.00,0.00,0.00),('1','273','1','253',1177,'3','1',230544.12,230844.12,0.00,0.00,300.00,198000.00,0.00,0.00,0.00),('1','273','1','253',1178,'4','1',183490.50,183490.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','253',1179,'5','1',63747.42,64122.42,0.00,0.00,375.00,247500.00,0.00,0.00,0.00),('1','273','1','253',1180,'6','1',53100.56,53415.56,0.00,0.00,315.00,207900.00,0.00,0.00,0.00),('1','273','1','254',1181,'1','1',4945.40,4946.79,0.00,0.00,1.39,1000.80,0.00,0.00,0.00),('1','273','1','254',1182,'2','1',102056.19,102353.12,0.00,0.00,296.93,204489.60,0.00,0.00,0.00),('1','273','1','254',1183,'3','1',230844.12,231611.65,0.00,0.00,767.53,506569.80,0.00,0.00,0.00),('1','273','1','254',1184,'4','1',183490.50,183670.50,0.00,0.00,180.00,118800.00,0.00,0.00,0.00),('1','273','1','254',1185,'5','1',64122.42,64790.40,0.00,0.00,667.98,440866.80,0.00,0.00,0.00),('1','273','1','254',1186,'6','1',53415.56,53735.56,0.00,0.00,320.00,211200.00,0.00,0.00,0.00),('1','273','1','255',1187,'1','1',4946.79,4946.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','255',1188,'2','1',102353.12,102353.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','255',1189,'3','1',231611.65,231611.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','255',1190,'4','1',183670.50,183670.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','255',1191,'5','1',64790.40,64790.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','255',1192,'6','1',53735.56,53735.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','256',1193,'1','1',4946.79,4954.79,0.00,0.00,8.00,5760.00,0.00,0.00,0.00),('1','273','1','256',1194,'2','1',102353.12,103081.09,0.00,0.00,727.97,520598.40,0.00,0.00,0.00),('1','273','1','256',1195,'3','1',231611.65,231890.65,0.00,0.00,279.00,184140.00,0.00,0.00,0.00),('1','273','1','256',1196,'4','1',183670.50,183670.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','256',1197,'5','1',64790.40,65407.40,0.00,0.00,617.00,407220.00,0.00,0.00,0.00),('1','273','1','256',1198,'6','1',53735.56,54099.56,0.00,0.00,364.00,240240.00,0.00,0.00,0.00),('1','273','1','257',1199,'1','1',4954.79,4969.73,0.00,0.00,14.94,10756.80,0.00,0.00,0.00),('1','273','1','257',1200,'2','1',103081.09,103999.66,0.00,0.00,918.57,640670.40,0.00,0.00,0.00),('1','273','1','257',1201,'3','1',231890.65,232871.17,0.00,0.00,980.52,647143.20,0.00,0.00,0.00),('1','273','1','257',1202,'4','1',183670.50,183670.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','257',1203,'5','1',65407.40,66415.40,0.00,0.00,1008.00,665280.00,0.00,0.00,0.00),('1','273','1','257',1204,'6','1',54099.56,54698.56,0.00,0.00,599.00,395340.00,0.00,0.00,0.00),('1','273','1','258',1205,'1','1',4969.73,4983.16,0.00,0.00,13.43,9669.60,0.00,0.00,0.00),('1','273','1','258',1206,'2','1',103999.66,104467.55,0.00,0.00,467.89,336880.80,0.00,0.00,0.00),('1','273','1','258',1207,'3','1',232871.17,233731.17,0.00,0.00,860.00,567600.00,0.00,0.00,0.00),('1','273','1','258',1208,'4','1',183670.50,183670.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','258',1209,'5','1',66415.40,67716.40,0.00,0.00,1301.00,858660.00,0.00,0.00,0.00),('1','273','1','258',1210,'6','1',54698.56,55344.56,0.00,0.00,646.00,426360.00,0.00,0.00,0.00),('1','273','1','259',1211,'1','1',4983.16,4988.24,0.00,0.00,5.08,3657.60,0.00,0.00,0.00),('1','273','1','259',1212,'2','1',104467.55,105264.78,0.00,0.00,797.23,574005.60,0.00,0.00,0.00),('1','273','1','259',1213,'3','1',233731.17,234720.17,0.00,0.00,989.00,652740.00,0.00,0.00,0.00),('1','273','1','259',1214,'4','1',183670.50,183730.50,0.00,0.00,60.00,39600.00,0.00,0.00,0.00),('1','273','1','259',1215,'5','1',67716.40,68743.40,0.00,0.00,1027.00,677820.00,0.00,0.00,0.00),('1','273','1','259',1216,'6','1',55344.56,56284.56,0.00,0.00,940.00,620400.00,0.00,0.00,0.00),('1','273','1','260',1217,'1','1',4988.24,4988.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','260',1218,'2','1',105264.78,105732.92,0.00,0.00,468.14,337060.80,0.00,0.00,0.00),('1','273','1','260',1219,'3','1',234720.17,235663.15,0.00,0.00,942.98,622491.60,0.00,0.00,0.00),('1','273','1','260',1220,'4','1',183730.50,183884.50,0.00,0.00,154.00,101640.00,0.00,0.00,0.00),('1','273','1','260',1221,'5','1',68743.40,69743.90,0.00,0.00,1000.50,660330.00,0.00,0.00,0.00),('1','273','1','260',1222,'6','1',56284.56,56979.56,0.00,0.00,695.00,458700.00,0.00,0.00,0.00),('1','273','1','261',1223,'1','1',4988.24,4989.63,0.00,0.00,1.39,1000.80,0.00,0.00,0.00),('1','273','1','261',1224,'2','1',105732.92,106261.78,0.00,0.00,528.86,380779.20,0.00,0.00,0.00),('1','273','1','261',1225,'3','1',235663.15,236960.98,0.00,0.00,1297.83,844359.50,0.00,0.00,0.00),('1','273','1','261',1226,'4','1',183884.50,184532.50,0.00,0.00,648.00,421200.00,0.00,0.00,0.00),('1','273','1','261',1227,'5','1',69743.90,69951.40,0.00,0.00,207.50,134875.00,0.00,0.00,0.00),('1','273','1','261',1228,'6','1',56979.56,57671.56,0.00,0.00,692.00,449800.00,0.00,0.00,0.00),('1','273','1','262',1229,'1','1',4989.63,4989.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','262',1230,'2','1',106261.78,106936.27,0.00,0.00,674.49,485632.80,0.00,0.00,0.00),('1','273','1','262',1231,'3','1',236960.98,237791.98,0.00,0.00,831.00,540150.00,0.00,0.00,0.00),('1','273','1','262',1232,'4','1',184532.50,184532.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','262',1233,'5','1',69951.40,71140.40,0.00,0.00,1189.00,772850.00,0.00,0.00,0.00),('1','273','1','262',1234,'6','1',57671.56,59002.56,0.00,0.00,1331.00,865150.00,0.00,0.00,0.00),('1','273','1','263',1235,'1','1',4989.63,4989.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','263',1236,'2','1',106936.27,107471.31,0.00,0.00,535.04,385228.80,0.00,0.00,0.00),('1','273','1','263',1237,'3','1',237791.98,238117.06,0.00,0.00,325.08,211447.60,0.00,0.00,0.00),('1','273','1','263',1238,'4','1',184532.50,184532.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','263',1239,'5','1',71140.40,71453.40,0.00,0.00,313.00,203450.00,0.00,0.00,0.00),('1','273','1','263',1240,'6','1',59002.56,59245.56,0.00,0.00,243.00,157950.00,0.00,0.00,0.00),('1','273','1','264',1241,'1','1',4989.63,4989.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','264',1242,'2','1',107471.31,107471.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','264',1243,'3','1',238117.06,238117.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','264',1244,'4','1',184532.50,184532.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','264',1245,'5','1',71453.40,71453.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','264',1246,'6','1',59245.56,59245.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','265',1247,'1','1',4989.63,4993.66,0.00,0.00,4.03,2901.60,0.00,0.00,0.00),('1','273','1','265',1248,'2','1',107471.31,107938.54,0.00,0.00,467.23,336405.60,0.00,0.00,0.00),('1','273','1','265',1249,'3','1',238117.06,238628.72,0.00,0.00,511.66,333001.80,0.00,0.00,0.00),('1','273','1','265',1250,'4','1',184532.50,184632.50,0.00,0.00,100.00,65000.00,0.00,0.00,0.00),('1','273','1','265',1251,'5','1',71453.40,72334.90,0.00,0.00,881.50,572975.00,0.00,0.00,0.00),('1','273','1','265',1252,'6','1',59245.56,59968.06,0.00,0.00,722.50,469625.00,0.00,0.00,0.00),('1','273','1','266',1253,'1','1',4993.66,4996.66,0.00,0.00,3.00,2160.00,0.00,0.00,0.00),('1','273','1','266',1254,'2','1',107938.54,108453.84,0.00,0.00,515.30,371016.00,0.00,0.00,0.00),('1','273','1','266',1255,'3','1',238628.72,239523.14,0.00,0.00,894.42,581373.00,0.00,0.00,0.00),('1','273','1','266',1256,'4','1',184632.50,184632.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','266',1257,'5','1',72334.90,73591.90,0.00,0.00,1257.00,817050.00,0.00,0.00,0.00),('1','273','1','266',1258,'6','1',59968.06,60842.56,0.00,0.00,874.50,568425.00,0.00,0.00,0.00),('1','273','1','267',1259,'1','1',4996.66,4996.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','267',1260,'2','1',108453.84,109047.28,0.00,0.00,593.44,427276.80,0.00,0.00,0.00),('1','273','1','267',1261,'3','1',239523.14,240007.68,0.00,0.00,484.54,314951.00,0.00,0.00,0.00),('1','273','1','267',1262,'4','1',184632.50,184633.50,0.00,0.00,1.00,650.00,0.00,0.00,0.00),('1','273','1','267',1263,'5','1',73591.90,74146.40,0.00,0.00,554.50,360425.00,0.00,0.00,0.00),('1','273','1','267',1264,'6','1',60842.56,61858.56,0.00,0.00,1016.00,660400.00,0.00,0.00,0.00),('1','273','1','268',1265,'1','1',4996.66,5008.83,0.00,0.00,12.17,8762.40,0.00,0.00,0.00),('1','273','1','268',1266,'2','1',109047.28,109316.83,0.00,0.00,269.55,194076.00,0.00,0.00,0.00),('1','273','1','268',1267,'3','1',240007.68,240797.50,0.00,0.00,789.82,513597.20,0.00,0.00,0.00),('1','273','1','268',1268,'4','1',184633.50,184633.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','268',1269,'5','1',74146.40,75240.40,0.00,0.00,1094.00,711100.00,0.00,0.00,0.00),('1','273','1','268',1270,'6','1',61858.56,62382.56,0.00,0.00,524.00,340600.00,0.00,0.00,0.00),('1','273','1','269',1271,'1','1',5008.83,5014.94,0.00,0.00,6.11,4399.20,0.00,0.00,0.00),('1','273','1','269',1272,'2','1',109316.83,110307.15,0.00,0.00,990.32,672010.40,0.00,0.00,0.00),('1','273','1','269',1273,'3','1',240797.50,241422.49,0.00,0.00,624.99,406733.50,0.00,0.00,0.00),('1','273','1','269',1274,'4','1',184633.50,184633.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','269',1275,'5','1',75240.40,76253.40,0.00,0.00,1013.00,658450.00,0.00,0.00,0.00),('1','273','1','269',1276,'6','1',62382.56,63551.56,0.00,0.00,1169.00,759850.00,0.00,0.00,0.00),('1','273','1','270',1277,'1','1',5014.94,5032.44,0.00,0.00,17.50,12600.00,0.00,0.00,0.00),('1','273','1','270',1278,'2','1',110307.15,111048.62,0.00,0.00,741.47,533858.40,0.00,0.00,0.00),('1','273','1','270',1279,'3','1',241422.49,242377.77,0.00,0.00,955.28,621126.60,0.00,0.00,0.00),('1','273','1','270',1280,'4','1',184633.50,184701.58,0.00,0.00,68.08,44397.60,0.00,0.00,0.00),('1','273','1','270',1281,'5','1',76253.40,77355.90,0.00,0.00,1102.50,716625.00,0.00,0.00,0.00),('1','273','1','270',1282,'6','1',63551.56,64501.56,0.00,0.00,950.00,617500.00,0.00,0.00,0.00),('1','273','1','271',1283,'1','1',5032.44,5035.22,0.00,0.00,2.78,2001.60,0.00,0.00,0.00),('1','273','1','271',1284,'2','1',111048.62,111609.98,0.00,0.00,561.36,404179.20,0.00,0.00,0.00),('1','273','1','271',1285,'3','1',242377.77,242760.31,0.00,0.00,382.54,248651.00,0.00,0.00,0.00),('1','273','1','271',1286,'4','1',184701.58,184701.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','271',1287,'5','1',77355.90,77415.90,0.00,0.00,60.00,39000.00,0.00,0.00,0.00),('1','273','1','271',1288,'6','1',64501.56,64735.56,0.00,0.00,234.00,152100.00,0.00,0.00,0.00),('1','273','1','272',1289,'1','1',5035.22,5035.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','272',1290,'2','1',111609.98,111942.58,0.00,0.00,332.60,240631.00,0.00,0.00,0.00),('1','273','1','272',1291,'3','1',242760.31,244209.31,0.00,0.00,1449.00,941850.00,0.00,0.00,0.00),('1','273','1','272',1292,'4','1',184701.58,184756.58,0.00,0.00,55.00,35750.00,0.00,0.00,0.00),('1','273','1','272',1293,'5','1',77415.90,78745.40,0.00,0.00,1329.50,864175.00,0.00,0.00,0.00),('1','273','1','272',1294,'6','1',64735.56,65452.56,0.00,0.00,717.00,466050.00,0.00,0.00,0.00),('1','273','1','273',1295,'1','1',5035.22,5035.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','273',1296,'2','1',111942.58,111942.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','273',1297,'3','1',244209.31,244209.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','273',1298,'4','1',184756.58,184756.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','273',1299,'5','1',78745.40,78745.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','273',1300,'6','1',65452.56,65452.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','274',1301,'1','1',5035.22,5045.22,0.00,0.00,10.00,7200.00,0.00,0.00,0.00),('1','273','1','274',1302,'2','1',111942.58,112422.49,0.00,0.00,479.91,345535.20,0.00,0.00,0.00),('1','273','1','274',1303,'3','1',244209.31,245175.31,0.00,0.00,966.00,628320.00,0.00,0.00,0.00),('1','273','1','274',1304,'4','1',184756.58,184756.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','274',1305,'5','1',78745.40,79718.40,0.00,0.00,973.00,632450.00,0.00,0.00,0.00),('1','273','1','274',1306,'6','1',65452.56,67079.56,0.00,0.00,1627.00,1057550.00,0.00,0.00,0.00),('1','273','1','275',1307,'1','1',5045.22,5047.03,0.00,0.00,1.81,1303.20,0.00,0.00,0.00),('1','273','1','275',1308,'2','1',112422.49,113225.99,0.00,0.00,803.50,578520.00,0.00,0.00,0.00),('1','273','1','275',1309,'3','1',245175.31,246651.01,0.00,0.00,1475.70,959205.00,0.00,0.00,0.00),('1','273','1','275',1310,'4','1',184756.58,184756.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','275',1311,'5','1',79718.40,80994.63,0.00,0.00,1276.23,829549.50,0.00,0.00,0.00),('1','273','1','275',1312,'6','1',67079.56,67578.56,0.00,0.00,499.00,324350.00,0.00,0.00,0.00),('1','273','1','276',1313,'1','1',5047.03,5056.03,0.00,0.00,9.00,6480.00,0.00,0.00,0.00),('1','273','1','276',1314,'2','1',113225.99,113717.82,0.00,0.00,491.83,354117.60,0.00,0.00,0.00),('1','273','1','276',1315,'3','1',246651.01,247928.51,0.00,0.00,1277.50,830375.00,0.00,0.00,0.00),('1','273','1','276',1316,'4','1',184756.58,184756.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','276',1317,'5','1',80994.63,82358.29,0.00,0.00,1363.66,886379.00,0.00,0.00,0.00),('1','273','1','276',1318,'6','1',67578.56,68446.56,0.00,0.00,868.00,564200.00,0.00,0.00,0.00),('1','273','1','277',1319,'1','1',5056.03,5056.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','277',1320,'2','1',113717.82,114261.22,0.00,0.00,543.40,391248.00,0.00,0.00,0.00),('1','273','1','277',1321,'3','1',247928.51,248937.51,0.00,0.00,1009.00,655850.00,0.00,0.00,0.00),('1','273','1','277',1322,'4','1',184756.58,184756.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','277',1323,'5','1',82358.29,83417.29,0.00,0.00,1059.00,688350.00,0.00,0.00,0.00),('1','273','1','277',1324,'6','1',68446.56,69111.06,0.00,0.00,664.50,431925.00,0.00,0.00,0.00),('1','273','1','278',1325,'1','1',5056.03,5057.03,0.00,0.00,1.00,720.00,0.00,0.00,0.00),('1','273','1','278',1326,'2','1',114261.22,114906.10,0.00,0.00,644.88,457313.60,0.00,0.00,0.00),('1','273','1','278',1327,'3','1',248937.51,249832.19,0.00,0.00,894.68,581999.10,0.00,0.00,0.00),('1','273','1','278',1328,'4','1',184756.58,184811.58,0.00,0.00,55.00,35750.00,0.00,0.00,0.00),('1','273','1','278',1329,'5','1',83417.29,85236.29,0.00,0.00,1819.00,1182350.00,0.00,0.00,0.00),('1','273','1','278',1330,'6','1',69111.06,70893.32,0.00,0.00,1782.26,1158469.00,0.00,0.00,0.00),('1','273','1','279',1331,'1','1',5057.03,5057.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','279',1332,'2','1',114906.10,115728.10,0.00,0.00,822.00,591840.00,0.00,0.00,0.00),('1','273','1','279',1333,'3','1',249832.19,249977.19,0.00,0.00,145.00,94250.00,0.00,0.00,0.00),('1','273','1','279',1334,'4','1',184811.58,184811.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','279',1335,'5','1',85236.29,85732.62,0.00,0.00,496.33,322614.50,0.00,0.00,0.00),('1','273','1','279',1336,'6','1',70893.32,71249.32,0.00,0.00,356.00,231400.00,0.00,0.00,0.00),('1','273','1','280',1337,'1','1',5057.03,5057.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','280',1338,'2','1',115728.10,115924.28,0.00,0.00,196.18,141249.60,0.00,0.00,0.00),('1','273','1','280',1339,'3','1',249977.19,250310.19,0.00,0.00,333.00,216450.00,0.00,0.00,0.00),('1','273','1','280',1340,'4','1',184811.58,184811.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','280',1341,'5','1',85732.62,86387.00,0.00,0.00,654.38,425347.00,0.00,0.00,0.00),('1','273','1','280',1342,'6','1',71249.32,72517.76,0.00,0.00,1268.44,824486.00,0.00,0.00,0.00),('1','273','1','281',1343,'1','1',5057.03,5057.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','281',1344,'2','1',115924.28,115924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','281',1345,'3','1',250310.19,250310.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','281',1346,'4','1',184811.58,184811.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','281',1347,'5','1',86387.00,86387.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','281',1348,'6','1',72517.76,72517.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','282',1349,'1','1',5057.03,5057.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','282',1350,'2','1',115924.28,116643.84,0.00,0.00,719.56,518083.20,0.00,0.00,0.00),('1','273','1','282',1351,'3','1',250310.19,251078.57,0.00,0.00,768.38,499447.00,0.00,0.00,0.00),('1','273','1','282',1352,'4','1',184811.58,185003.58,0.00,0.00,192.00,124800.00,0.00,0.00,0.00),('1','273','1','282',1353,'5','1',86387.00,86972.60,0.00,0.00,585.60,380640.00,0.00,0.00,0.00),('1','273','1','282',1354,'6','1',72517.76,73380.91,0.00,0.00,863.15,561047.50,0.00,0.00,0.00),('1','273','1','283',1355,'1','1',5057.03,5057.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','283',1356,'2','1',116643.84,117296.31,0.00,0.00,652.47,469778.40,0.00,0.00,0.00),('1','273','1','283',1357,'3','1',251078.57,251860.57,0.00,0.00,782.00,509140.00,0.00,0.00,0.00),('1','273','1','283',1358,'4','1',185003.58,185003.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','283',1359,'5','1',86972.60,88973.99,0.00,0.00,2001.39,1300903.50,0.00,0.00,0.00),('1','273','1','283',1360,'6','1',73380.91,74228.91,0.00,0.00,848.00,551200.00,0.00,0.00,0.00),('1','273','1','284',1361,'1','1',5057.03,5057.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','284',1362,'2','1',117296.31,117888.19,0.00,0.00,591.88,426153.60,0.00,0.00,0.00),('1','273','1','284',1363,'3','1',251860.57,252243.57,0.00,0.00,383.00,248950.00,0.00,0.00,0.00),('1','273','1','284',1364,'4','1',185003.58,185003.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','284',1365,'5','1',88973.99,90342.15,0.00,0.00,1368.16,889304.00,0.00,0.00,0.00),('1','273','1','284',1366,'6','1',74228.91,74816.41,0.00,0.00,587.50,381875.00,0.00,0.00,0.00),('1','273','1','285',1367,'1','1',5057.03,5057.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','285',1368,'2','1',117888.19,118352.87,0.00,0.00,464.68,334569.60,0.00,0.00,0.00),('1','273','1','285',1369,'3','1',252243.57,253203.11,0.00,0.00,959.54,624648.80,0.00,0.00,0.00),('1','273','1','285',1370,'4','1',185003.58,185101.41,0.00,0.00,97.83,63589.50,0.00,0.00,0.00),('1','273','1','285',1371,'5','1',90342.15,90905.15,0.00,0.00,563.00,365950.00,0.00,0.00,0.00),('1','273','1','285',1372,'6','1',74816.41,75798.91,0.00,0.00,982.50,638625.00,0.00,0.00,0.00),('1','273','1','286',1373,'1','1',5057.03,5059.81,0.00,0.00,2.78,2001.60,0.00,0.00,0.00),('1','273','1','286',1374,'2','1',118352.87,118871.56,0.00,0.00,518.69,373456.80,0.00,0.00,0.00),('1','273','1','286',1375,'3','1',253203.11,253876.11,0.00,0.00,673.00,437450.00,0.00,0.00,0.00),('1','273','1','286',1376,'4','1',185101.41,185116.41,0.00,0.00,15.00,9750.00,0.00,0.00,0.00),('1','273','1','286',1377,'5','1',90905.15,91804.15,0.00,0.00,899.00,584350.00,0.00,0.00,0.00),('1','273','1','286',1378,'6','1',75798.91,76681.41,0.00,0.00,882.50,573625.00,0.00,0.00,0.00),('1','273','1','287',1379,'1','1',5059.81,5072.31,0.00,0.00,12.50,9000.00,0.00,0.00,0.00),('1','273','1','287',1380,'2','1',118871.56,119588.41,0.00,0.00,716.85,516132.00,0.00,0.00,0.00),('1','273','1','287',1381,'3','1',253876.11,254032.11,0.00,0.00,156.00,101400.00,0.00,0.00,0.00),('1','273','1','287',1382,'4','1',185116.41,185116.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','287',1383,'5','1',91804.15,92276.15,0.00,0.00,472.00,306800.00,0.00,0.00,0.00),('1','273','1','287',1384,'6','1',76681.41,77004.41,0.00,0.00,323.00,209950.00,0.00,0.00,0.00),('1','273','1','288',1385,'1','1',5072.31,5077.31,0.00,0.00,5.00,3600.00,0.00,0.00,0.00),('1','273','1','288',1386,'2','1',119588.41,120138.48,0.00,0.00,550.07,392550.40,0.00,0.00,0.00),('1','273','1','288',1387,'3','1',254032.11,254818.61,0.00,0.00,786.50,512100.00,0.00,0.00,0.00),('1','273','1','288',1388,'4','1',185116.41,185116.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','288',1389,'5','1',92276.15,93576.18,0.00,0.00,1300.03,845019.50,0.00,0.00,0.00),('1','273','1','288',1390,'6','1',77004.41,78059.41,0.00,0.00,1055.00,685750.00,0.00,0.00,0.00),('1','273','1','289',1391,'1','1',5077.31,5077.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','289',1392,'2','1',120138.48,120321.87,0.00,0.00,183.39,132040.80,0.00,0.00,0.00),('1','273','1','289',1393,'3','1',254818.61,255727.11,0.00,0.00,908.50,590875.00,0.00,0.00,0.00),('1','273','1','289',1394,'4','1',185116.41,185116.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','289',1395,'5','1',93576.18,94559.64,0.00,0.00,983.46,639249.00,0.00,0.00,0.00),('1','273','1','289',1396,'6','1',78059.41,78900.41,0.00,0.00,841.00,546650.00,0.00,0.00,0.00),('1','273','1','290',1397,'1','1',5077.31,5077.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','290',1398,'2','1',120321.87,120321.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','290',1399,'3','1',255727.11,255727.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','290',1400,'4','1',185116.41,185116.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','290',1401,'5','1',94559.64,94559.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','290',1402,'6','1',78900.41,78900.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','291',1403,'1','1',5077.31,5079.31,0.00,0.00,2.00,1440.00,0.00,0.00,0.00),('1','273','1','291',1404,'2','1',120321.87,121135.87,0.00,0.00,814.00,586080.00,0.00,0.00,0.00),('1','273','1','291',1405,'3','1',255727.11,256841.90,0.00,0.00,1114.79,725340.80,0.00,0.00,0.00),('1','273','1','291',1406,'4','1',185116.41,185116.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','291',1407,'5','1',94559.64,96405.21,0.00,0.00,1845.57,1199620.50,0.00,0.00,0.00),('1','273','1','291',1408,'6','1',78900.41,80106.07,0.00,0.00,1205.66,783679.00,0.00,0.00,0.00),('1','273','1','292',1409,'1','1',5079.31,5081.31,0.00,0.00,2.00,1440.00,0.00,0.00,0.00),('1','273','1','292',1410,'2','1',121135.87,121762.45,0.00,0.00,626.58,451137.60,0.00,0.00,0.00),('1','273','1','292',1411,'3','1',256841.90,257232.95,0.00,0.00,391.05,254377.10,0.00,0.00,0.00),('1','273','1','292',1412,'4','1',185116.41,185116.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','292',1413,'5','1',96405.21,97563.67,0.00,0.00,1158.46,752999.00,0.00,0.00,0.00),('1','273','1','292',1414,'6','1',80106.07,81026.99,0.00,0.00,920.92,598598.00,0.00,0.00,0.00),('1','273','1','293',1415,'1','1',5081.31,5082.70,0.00,0.00,1.39,1000.80,0.00,0.00,0.00),('1','273','1','293',1416,'2','1',121762.45,122419.61,0.00,0.00,657.16,473155.20,0.00,0.00,0.00),('1','273','1','293',1417,'3','1',257232.95,257618.95,0.00,0.00,386.00,250900.00,0.00,0.00,0.00),('1','273','1','293',1418,'4','1',185116.41,185116.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','293',1419,'5','1',97563.67,98288.67,0.00,0.00,725.00,471250.00,0.00,0.00,0.00),('1','273','1','293',1420,'6','1',81026.99,82378.99,0.00,0.00,1352.00,878800.00,0.00,0.00,0.00),('1','273','1','294',1421,'1','1',5082.70,5088.26,0.00,0.00,5.56,4003.20,0.00,0.00,0.00),('1','273','1','294',1422,'2','1',122419.61,123150.95,0.00,0.00,731.34,526564.80,0.00,0.00,0.00),('1','273','1','294',1423,'3','1',257618.95,257868.95,0.00,0.00,250.00,162500.00,0.00,0.00,0.00),('1','273','1','294',1424,'4','1',185116.41,185166.41,0.00,0.00,50.00,32500.00,0.00,0.00,0.00),('1','273','1','294',1425,'5','1',98288.67,98841.04,0.00,0.00,552.37,359040.50,0.00,0.00,0.00),('1','273','1','294',1426,'6','1',82378.99,83040.99,0.00,0.00,662.00,430300.00,0.00,0.00,0.00),('1','273','1','295',1427,'1','1',5088.26,5090.65,0.00,0.00,2.39,1650.80,0.00,0.00,0.00),('1','273','1','295',1428,'2','1',123150.95,123784.12,0.00,0.00,633.17,455882.40,0.00,0.00,0.00),('1','273','1','295',1429,'3','1',257868.95,259253.88,0.00,0.00,1384.93,901849.50,0.00,0.00,0.00),('1','273','1','295',1430,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','295',1431,'5','1',98841.04,100081.04,0.00,0.00,1240.00,806000.00,0.00,0.00,0.00),('1','273','1','295',1432,'6','1',83040.99,84250.99,0.00,0.00,1210.00,786500.00,0.00,0.00,0.00),('1','273','1','296',1433,'1','1',5090.65,5101.65,0.00,0.00,11.00,7920.00,0.00,0.00,0.00),('1','273','1','296',1434,'2','1',123784.12,124405.64,0.00,0.00,621.52,447494.40,0.00,0.00,0.00),('1','273','1','296',1435,'3','1',259253.88,259678.88,0.00,0.00,425.00,276250.00,0.00,0.00,0.00),('1','273','1','296',1436,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','296',1437,'5','1',100081.04,100674.54,0.00,0.00,593.50,385775.00,0.00,0.00,0.00),('1','273','1','296',1438,'6','1',84250.99,84888.99,0.00,0.00,638.00,414700.00,0.00,0.00,0.00),('1','273','1','297',1439,'1','1',5101.65,5111.65,0.00,0.00,10.00,7200.00,0.00,0.00,0.00),('1','273','1','297',1440,'2','1',124405.64,125098.26,0.00,0.00,692.62,498686.40,0.00,0.00,0.00),('1','273','1','297',1441,'3','1',259678.88,260149.64,0.00,0.00,470.76,305994.00,0.00,0.00,0.00),('1','273','1','297',1442,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','297',1443,'5','1',100674.54,101810.04,0.00,0.00,1135.50,738075.00,0.00,0.00,0.00),('1','273','1','297',1444,'6','1',84888.99,86002.49,0.00,0.00,1113.50,723775.00,0.00,0.00,0.00),('1','273','1','298',1445,'1','1',5111.65,5111.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','298',1446,'2','1',125098.26,125124.19,0.00,0.00,25.93,18669.60,0.00,0.00,0.00),('1','273','1','298',1447,'3','1',260149.64,260366.14,0.00,0.00,216.50,140725.00,0.00,0.00,0.00),('1','273','1','298',1448,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','298',1449,'5','1',101810.04,102325.81,0.00,0.00,515.77,335250.50,0.00,0.00,0.00),('1','273','1','298',1450,'6','1',86002.49,86098.19,0.00,0.00,95.70,62205.00,0.00,0.00,0.00),('1','273','1','299',1451,'1','1',5111.65,5111.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','299',1452,'2','1',125124.19,125124.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','299',1453,'3','1',260366.14,260366.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','299',1454,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','299',1455,'5','1',102325.81,102325.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','299',1456,'6','1',86098.19,86098.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','300',1457,'1','1',5111.65,5122.69,0.00,0.00,11.04,7948.80,0.00,0.00,0.00),('1','273','1','300',1458,'2','1',125124.19,125946.70,0.00,0.00,822.51,592207.20,0.00,0.00,0.00),('1','273','1','300',1459,'3','1',260366.14,261564.87,0.00,0.00,1198.73,779174.50,0.00,0.00,0.00),('1','273','1','300',1460,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','300',1461,'5','1',102325.81,104155.17,0.00,0.00,1829.36,1189084.00,0.00,0.00,0.00),('1','273','1','300',1462,'6','1',86098.19,88852.19,0.00,0.00,2754.00,1790100.00,0.00,0.00,0.00),('1','273','1','301',1463,'1','1',5122.69,5130.69,0.00,0.00,8.00,5760.00,0.00,0.00,0.00),('1','273','1','301',1464,'2','1',125946.70,126645.27,0.00,0.00,698.57,502970.40,0.00,0.00,0.00),('1','273','1','301',1465,'3','1',261564.87,262569.87,0.00,0.00,1005.00,653250.00,0.00,0.00,0.00),('1','273','1','301',1466,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','301',1467,'5','1',104155.17,106254.17,0.00,0.00,2099.00,1364350.00,0.00,0.00,0.00),('1','273','1','301',1468,'6','1',88852.19,89954.19,0.00,0.00,1102.00,716300.00,0.00,0.00,0.00),('1','273','1','302',1469,'1','1',5130.69,5132.69,0.00,0.00,2.00,1440.00,0.00,0.00,0.00),('1','273','1','302',1470,'2','1',126645.27,127068.52,0.00,0.00,423.25,304740.00,0.00,0.00,0.00),('1','273','1','302',1471,'3','1',262569.87,262697.87,0.00,0.00,128.00,83200.00,0.00,0.00,0.00),('1','273','1','302',1472,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','302',1473,'5','1',106254.17,106463.17,0.00,0.00,209.00,135850.00,0.00,0.00,0.00),('1','273','1','302',1474,'6','1',89954.19,90476.19,0.00,0.00,522.00,339300.00,0.00,0.00,0.00),('1','273','1','303',1475,'1','1',5132.69,5142.69,0.00,0.00,10.00,7200.00,0.00,0.00,0.00),('1','273','1','303',1476,'2','1',127068.52,127624.74,0.00,0.00,556.22,400478.40,0.00,0.00,0.00),('1','273','1','303',1477,'3','1',262697.87,263215.40,0.00,0.00,517.53,336394.50,0.00,0.00,0.00),('1','273','1','303',1478,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','303',1479,'5','1',106463.17,107612.67,0.00,0.00,1149.50,747175.00,0.00,0.00,0.00),('1','273','1','303',1480,'6','1',90476.19,91142.19,0.00,0.00,666.00,432900.00,0.00,0.00,0.00),('1','273','1','304',1481,'1','1',5142.69,5142.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','304',1482,'2','1',127624.74,128121.04,0.00,0.00,496.30,357336.00,0.00,0.00,0.00),('1','273','1','304',1483,'3','1',263215.40,263903.40,0.00,0.00,688.00,447200.00,0.00,0.00,0.00),('1','273','1','304',1484,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','304',1485,'5','1',107612.67,109168.67,0.00,0.00,1556.00,1011400.00,0.00,0.00,0.00),('1','273','1','304',1486,'6','1',91142.19,92054.69,0.00,0.00,912.50,593125.00,0.00,0.00,0.00),('1','273','1','305',1487,'1','1',5142.69,5146.97,0.00,0.00,4.28,3081.60,0.00,0.00,0.00),('1','273','1','305',1488,'2','1',128121.04,128767.46,0.00,0.00,646.42,465422.40,0.00,0.00,0.00),('1','273','1','305',1489,'3','1',263903.40,264405.70,0.00,0.00,502.30,326495.00,0.00,0.00,0.00),('1','273','1','305',1490,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','305',1491,'5','1',109168.67,109992.67,0.00,0.00,824.00,535600.00,0.00,0.00,0.00),('1','273','1','305',1492,'6','1',92054.69,92800.69,0.00,0.00,746.00,484900.00,0.00,0.00,0.00),('1','273','1','306',1493,'1','1',5146.97,5147.97,0.00,0.00,1.00,720.00,0.00,0.00,0.00),('1','273','1','306',1494,'2','1',128767.46,129474.14,0.00,0.00,706.68,508809.60,0.00,0.00,0.00),('1','273','1','306',1495,'3','1',264405.70,264567.39,0.00,0.00,161.69,105098.50,0.00,0.00,0.00),('1','273','1','306',1496,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','306',1497,'5','1',109992.67,110785.02,0.00,0.00,792.35,515027.50,0.00,0.00,0.00),('1','273','1','306',1498,'6','1',92800.69,93818.45,0.00,0.00,1017.76,661544.00,0.00,0.00,0.00),('1','273','1','307',1499,'1','1',5147.97,5147.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','307',1500,'2','1',129474.14,129474.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','307',1501,'3','1',264567.39,264567.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','307',1502,'4','1',185166.41,185166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','307',1503,'5','1',110785.02,110785.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','307',1504,'6','1',93818.45,93818.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','308',1505,'1','1',5147.97,5147.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','308',1506,'2','1',129474.14,129922.21,0.00,0.00,448.07,322610.40,0.00,0.00,0.00),('1','273','1','308',1507,'3','1',264567.39,265144.00,0.00,0.00,576.61,374936.50,0.00,0.00,0.00),('1','273','1','308',1508,'4','1',185166.41,185186.41,0.00,0.00,20.00,13000.00,0.00,0.00,0.00),('1','273','1','308',1509,'5','1',110785.02,111732.52,0.00,0.00,947.50,615875.00,0.00,0.00,0.00),('1','273','1','308',1510,'6','1',93818.45,95334.45,0.00,0.00,1516.00,985400.00,0.00,0.00,0.00),('1','273','1','309',1511,'1','1',5147.97,5147.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','309',1512,'2','1',129922.21,130513.21,0.00,0.00,591.00,425520.00,0.00,0.00,0.00),('1','273','1','309',1513,'3','1',265144.00,265604.00,0.00,0.00,460.00,300750.00,0.00,0.00,0.00),('1','273','1','309',1514,'4','1',185186.41,185186.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','309',1515,'5','1',111732.52,112489.26,0.00,0.00,756.74,491881.00,0.00,0.00,0.00),('1','273','1','309',1516,'6','1',95334.45,95519.60,0.00,0.00,185.15,120347.50,0.00,0.00,0.00),('1','273','1','310',1517,'1','1',5147.97,5147.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','310',1518,'2','1',130513.21,131080.05,0.00,0.00,566.84,396788.00,0.00,0.00,0.00),('1','273','1','310',1519,'3','1',265604.00,266320.20,0.00,0.00,716.20,459118.00,0.00,0.00,0.00),('1','273','1','310',1520,'4','1',185186.41,185265.41,0.00,0.00,79.00,50860.00,0.00,0.00,0.00),('1','273','1','310',1521,'5','1',112489.26,112755.26,0.00,0.00,266.00,170240.00,0.00,0.00,0.00),('1','273','1','310',1522,'6','1',95519.60,96333.60,0.00,0.00,814.00,520960.00,0.00,0.00,0.00),('1','273','1','311',1523,'1','1',5147.97,5150.83,0.00,0.00,2.86,2002.00,0.00,0.00,0.00),('1','273','1','311',1524,'2','1',131080.05,131617.35,0.00,0.00,537.30,376360.00,0.00,0.00,0.00),('1','273','1','311',1525,'3','1',266320.20,266907.20,0.00,0.00,587.00,375680.00,0.00,0.00,0.00),('1','273','1','311',1526,'4','1',185265.41,185265.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','311',1527,'5','1',112755.26,113591.76,0.00,0.00,836.50,535360.00,0.00,0.00,0.00),('1','273','1','311',1528,'6','1',96333.60,96648.60,0.00,0.00,315.00,201600.00,0.00,0.00,0.00),('1','273','1','312',1529,'1','1',5150.83,5150.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','312',1530,'2','1',131617.35,132227.69,0.00,0.00,610.34,427238.00,0.00,0.00,0.00),('1','273','1','312',1531,'3','1',266907.20,267510.20,0.00,0.00,603.00,385920.00,0.00,0.00,0.00),('1','273','1','312',1532,'4','1',185265.41,185265.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','312',1533,'5','1',113591.76,114791.54,0.00,0.00,1199.78,767859.20,0.00,0.00,0.00),('1','273','1','312',1534,'6','1',96648.60,97778.60,0.00,0.00,1130.00,723200.00,0.00,0.00,0.00),('1','273','1','313',1535,'1','1',5150.83,5171.19,0.00,0.00,20.36,14252.00,0.00,0.00,0.00),('1','273','1','313',1536,'2','1',132227.69,133119.39,0.00,0.00,891.70,624190.00,0.00,0.00,0.00),('1','273','1','313',1537,'3','1',267510.20,267932.20,0.00,0.00,422.00,270320.00,0.00,0.00,0.00),('1','273','1','313',1538,'4','1',185265.41,185265.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','313',1539,'5','1',114791.54,115488.54,0.00,0.00,697.00,446080.00,0.00,0.00,0.00),('1','273','1','313',1540,'6','1',97778.60,98347.60,0.00,0.00,569.00,364160.00,0.00,0.00,0.00),('1','273','1','314',1541,'1','1',5171.19,5171.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','314',1542,'2','1',133119.39,133585.08,0.00,0.00,465.69,326005.20,0.00,0.00,0.00),('1','273','1','314',1543,'3','1',267932.20,268267.20,0.00,0.00,335.00,214400.00,0.00,0.00,0.00),('1','273','1','314',1544,'4','1',185265.41,185265.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','314',1545,'5','1',115488.54,116074.54,0.00,0.00,586.00,375040.00,0.00,0.00,0.00),('1','273','1','314',1546,'6','1',98347.60,98927.60,0.00,0.00,580.00,371200.00,0.00,0.00,0.00),('1','273','1','315',1547,'1','1',5171.19,5177.19,0.00,0.00,6.00,4200.00,0.00,0.00,0.00),('1','273','1','315',1548,'2','1',133585.08,134394.06,0.00,0.00,808.98,566286.00,0.00,0.00,0.00),('1','273','1','315',1549,'3','1',268267.20,268899.20,0.00,0.00,632.00,404480.00,0.00,0.00,0.00),('1','273','1','315',1550,'4','1',185265.41,185375.41,0.00,0.00,110.00,70400.00,0.00,0.00,0.00),('1','273','1','315',1551,'5','1',116074.54,117268.13,0.00,0.00,1193.59,763897.60,0.00,0.00,0.00),('1','273','1','315',1552,'6','1',98927.60,99092.60,0.00,0.00,165.00,105600.00,0.00,0.00,0.00),('1','273','1','316',1553,'1','1',5177.19,5206.55,0.00,0.00,29.36,20552.00,0.00,0.00,0.00),('1','273','1','316',1554,'2','1',134394.06,135331.41,0.00,0.00,937.35,656145.00,0.00,0.00,0.00),('1','273','1','316',1555,'3','1',268899.20,269922.54,0.00,0.00,1023.34,654937.60,0.00,0.00,0.00),('1','273','1','316',1556,'4','1',185375.41,185375.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','316',1557,'5','1',117268.13,118069.13,0.00,0.00,801.00,512640.00,0.00,0.00,0.00),('1','273','1','316',1558,'6','1',99092.60,99192.60,0.00,0.00,100.00,64000.00,0.00,0.00,0.00),('1','273','1','317',1559,'1','1',5206.55,5206.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','317',1560,'2','1',135331.41,135331.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','317',1561,'3','1',269922.54,269922.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','317',1562,'4','1',185375.41,185375.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','317',1563,'5','1',118069.13,118069.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','317',1564,'6','1',99192.60,99192.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','318',1565,'1','1',5206.55,5226.12,0.00,0.00,19.57,13699.00,0.00,0.00,0.00),('1','273','1','318',1566,'2','1',135331.41,135876.29,0.00,0.00,544.88,381416.00,0.00,0.00,0.00),('1','273','1','318',1567,'3','1',269922.54,270488.61,0.00,0.00,566.07,362349.00,0.00,0.00,0.00),('1','273','1','318',1568,'4','1',185375.41,185525.41,0.00,0.00,150.00,96000.00,0.00,0.00,0.00),('1','273','1','318',1569,'5','1',118069.13,119061.13,0.00,0.00,992.00,634880.00,0.00,0.00,0.00),('1','273','1','318',1570,'6','1',99192.60,99577.60,0.00,0.00,385.00,246400.00,0.00,0.00,0.00),('1','273','1','319',1571,'1','1',5226.12,5226.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','319',1572,'2','1',135876.29,136485.57,0.00,0.00,609.28,426496.00,0.00,0.00,0.00),('1','273','1','319',1573,'3','1',270488.61,270929.61,0.00,0.00,441.00,282240.00,0.00,0.00,0.00),('1','273','1','319',1574,'4','1',185525.41,185525.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','319',1575,'5','1',119061.13,119375.24,0.00,0.00,314.11,201030.40,0.00,0.00,0.00),('1','273','1','319',1576,'6','1',99577.60,100428.60,0.00,0.00,851.00,544640.00,0.00,0.00,0.00),('1','273','1','320',1577,'1','1',5226.12,5241.62,0.00,0.00,15.50,10850.00,0.00,0.00,0.00),('1','273','1','320',1578,'2','1',136485.57,137407.98,0.00,0.00,922.41,645687.00,0.00,0.00,0.00),('1','273','1','320',1579,'3','1',270929.61,273028.11,0.00,0.00,2098.50,1343400.00,0.00,0.00,0.00),('1','273','1','320',1580,'4','1',185525.41,185525.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','320',1581,'5','1',119375.24,119894.74,0.00,0.00,519.50,332480.00,0.00,0.00,0.00),('1','273','1','320',1582,'6','1',100428.60,101274.57,0.00,0.00,845.97,541420.80,0.00,0.00,0.00),('1','273','1','321',1583,'1','1',5241.62,5294.76,0.00,0.00,53.14,37198.00,0.00,0.00,0.00),('1','273','1','321',1584,'2','1',137407.98,138294.52,0.00,0.00,886.54,620578.00,0.00,0.00,0.00),('1','273','1','321',1585,'3','1',273028.11,273747.11,0.00,0.00,719.00,460280.00,0.00,0.00,0.00),('1','273','1','321',1586,'4','1',185525.41,185605.41,0.00,0.00,80.00,51200.00,0.00,0.00,0.00),('1','273','1','321',1587,'5','1',119894.74,120647.74,0.00,0.00,753.00,481920.00,0.00,0.00,0.00),('1','273','1','321',1588,'6','1',101274.57,102007.43,0.00,0.00,732.86,469030.40,0.00,0.00,0.00),('1','273','1','322',1589,'1','1',5294.76,5345.76,0.00,0.00,51.00,32700.00,0.00,0.00,0.00),('1','273','1','322',1590,'2','1',138294.52,138623.66,0.00,0.00,329.14,226858.00,0.00,0.00,0.00),('1','273','1','322',1591,'3','1',273747.11,274957.11,0.00,0.00,1210.00,774400.00,0.00,0.00,0.00),('1','273','1','322',1592,'4','1',185605.41,185605.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','273','1','322',1593,'5','1',120647.74,121782.74,0.00,0.00,1135.00,726400.00,0.00,0.00,0.00),('1','273','1','322',1594,'6','1',102007.43,102488.43,0.00,0.00,481.00,307840.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=323 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','273','1','1',607.00,664.00,0.00,38.41,23314.87,25504.24,2189.37,1),('1','273','2','1',607.00,0.00,0.00,127.75,77544.25,84826.00,7281.75,2),('1','273','3','1',607.00,0.00,0.00,279.27,169516.89,180234.00,10717.11,3),('1','273','4','1',607.00,0.00,0.00,431.06,261653.42,284237.24,22583.82,4),('1','273','5','1',607.00,0.00,0.00,293.23,177990.61,188104.72,10114.11,5),('1','273','6','1',607.00,0.00,0.00,1672.87,1015432.09,1053145.68,37713.59,6),('1','273','7','1',607.00,0.00,0.00,3176.88,1928366.16,1985896.32,57530.16,7),('1','273','8','1',607.00,0.00,0.00,1618.78,982599.46,1014791.88,32192.42,8),('1','273','9','1',607.00,0.00,0.00,5084.23,3086127.61,3167419.76,81292.15,9),('1','273','10','1',607.00,0.00,0.00,4017.51,2438628.57,2512411.80,73783.23,10),('1','273','11','1',607.00,0.00,0.00,2931.88,1779651.16,1836521.92,56870.76,11),('1','273','12','1',607.00,0.00,0.00,4424.39,2685604.73,2761307.00,75702.27,12),('1','273','13','1',607.00,0.00,0.00,0.00,0.00,0.00,0.00,13),('1','273','14','1',607.00,0.00,0.00,0.00,0.00,0.00,0.00,14),('1','273','15','1',607.00,0.00,0.00,229.44,139270.08,143915.56,4645.48,15),('1','273','16','1',654.00,0.00,0.00,3194.07,2088921.78,2238419.48,149497.70,16),('1','273','17','1',654.00,0.00,0.00,1126.15,736502.10,799215.80,62713.70,17),('1','273','18','1',654.00,0.00,0.00,1119.09,731884.86,799868.00,67983.14,18),('1','273','19','1',654.00,0.00,0.00,717.42,469192.68,515456.48,46263.80,19),('1','273','20','1',654.00,0.00,0.00,1292.41,845236.14,919089.44,73853.30,20),('1','273','21','1',654.00,0.00,0.00,1228.79,803628.66,868494.60,64865.94,21),('1','273','22','1',654.00,0.00,0.00,0.00,0.00,0.00,0.00,22),('1','273','23','1',654.00,0.00,0.00,2055.53,1344316.62,1446008.40,101691.78,23),('1','273','24','1',654.00,0.00,0.00,2228.70,1457569.80,1565814.00,108244.20,24),('1','273','25','1',654.00,0.00,0.00,1854.84,1213065.36,1315318.30,102252.94,25),('1','273','26','1',654.00,0.00,0.00,1881.52,1230514.08,1327028.80,96514.72,26),('1','273','27','1',654.00,0.00,0.00,911.61,596192.94,654351.40,58158.46,27),('1','273','28','1',654.00,0.00,0.00,1283.62,839487.48,911730.80,72243.32,28),('1','273','29','1',654.00,0.00,0.00,1098.27,718268.58,778209.28,59940.70,29),('1','273','30','1',654.00,0.00,0.00,1879.59,1229251.86,1326172.60,96920.74,30),('1','273','31','1',654.00,0.00,0.00,880.32,575729.28,623896.76,48167.48,31),('1','273','32','1',654.00,0.00,0.00,1012.83,662390.82,715922.20,53531.38,32),('1','273','33','1',654.00,0.00,0.00,1165.31,762112.74,823169.40,61056.66,33),('1','273','34','1',654.00,0.00,0.00,0.00,0.00,0.00,0.00,34),('1','273','35','1',654.00,0.00,0.00,0.00,0.00,0.00,0.00,35),('1','273','36','1',654.00,0.00,0.00,1428.05,933944.70,1010057.00,76112.30,36),('1','273','37','1',654.00,0.00,0.00,3666.99,2398211.46,2547947.60,149736.14,37),('1','273','38','1',654.00,0.00,0.00,2439.95,1595727.30,1696333.00,100605.70,38),('1','273','39','1',654.00,0.00,0.00,2248.89,1470774.06,1573829.60,103055.54,39),('1','273','40','1',654.00,0.00,0.00,1622.33,1061003.82,1134030.70,73026.88,40),('1','273','41','1',654.00,0.00,0.00,2958.33,1934747.82,2053238.70,118490.88,41),('1','273','42','1',654.00,0.00,0.00,2261.18,1478811.72,1585244.20,106432.48,42),('1','273','43','1',654.00,0.00,0.00,1711.80,1119517.20,1202845.50,83328.30,43),('1','273','44','1',654.00,0.00,0.00,2265.17,1481421.18,1589600.30,108179.12,44),('1','273','45','1',654.00,0.00,0.00,1362.55,891107.70,951712.00,60604.30,45),('1','273','46','1',654.00,0.00,0.00,1072.51,701421.54,762505.90,61084.36,46),('1','273','47','1',654.00,0.00,0.00,1136.73,743421.42,804716.20,61294.78,47),('1','273','48','1',654.00,0.00,0.00,1032.65,675353.10,711040.00,35686.90,48),('1','273','49','1',655.00,0.00,0.00,3299.13,2160930.15,2279656.20,118726.05,49),('1','273','50','1',655.00,0.00,0.00,1457.93,954944.15,1021501.60,66557.45,50),('1','273','51','1',655.00,0.00,0.00,2884.40,1889282.00,1980886.00,91604.00,51),('1','273','52','1',655.00,0.00,0.00,1209.76,792392.80,845572.40,53179.60,52),('1','273','53','1',655.00,0.00,0.00,2768.33,1813256.15,1904961.40,91705.25,53),('1','273','54','1',655.00,0.00,0.00,2405.38,1575523.90,1230098.60,-345425.30,54),('1','273','55','1',655.00,0.00,0.00,999.42,654620.10,694528.80,39908.70,55),('1','273','56','1',655.00,0.00,0.00,1141.36,747590.80,797926.40,50335.60,56),('1','273','57','1',655.00,0.00,0.00,535.53,350772.15,384406.60,33634.45,57),('1','273','58','1',655.00,0.00,0.00,2642.32,1730719.60,1827216.80,96497.20,58),('1','273','59','1',655.00,0.00,0.00,1584.47,1037827.85,1101467.80,63639.95,59),('1','273','60','1',655.00,0.00,0.00,2966.81,1943260.55,2043392.80,100132.25,60),('1','273','61','1',655.00,0.00,0.00,1432.76,938457.80,987504.40,49046.60,61),('1','273','62','1',655.00,0.00,0.00,1305.16,854879.80,905274.20,50394.40,62),('1','273','63','1',655.00,0.00,0.00,2004.82,1313157.10,1400239.50,87082.40,63),('1','273','64','1',655.00,0.00,0.00,978.20,640721.00,700101.40,59380.40,64),('1','273','65','1',655.00,0.00,0.00,1482.35,970939.25,1037629.00,66689.75,65),('1','273','66','1',655.00,0.00,0.00,1609.12,1053973.60,1117578.80,63605.20,66),('1','273','67','1',655.00,0.00,0.00,1088.39,712895.45,766588.60,53693.15,67),('1','273','68','1',655.00,740.00,0.00,0.00,0.00,0.00,0.00,68),('1','273','69','1',655.00,0.00,0.00,1852.55,1213420.25,1268785.50,55365.25,69),('1','273','70','1',655.00,0.00,0.00,3470.38,2273098.90,2345908.60,72809.70,70),('1','273','71','1',655.00,0.00,0.00,4414.18,2891287.90,2976435.10,85147.20,71),('1','273','72','1',655.00,0.00,0.00,2379.85,1558801.75,1613053.50,54251.75,72),('1','273','73','1',655.00,0.00,0.00,4202.71,2752775.05,2830526.20,77751.15,73),('1','273','74','1',655.00,0.00,0.00,0.00,0.00,0.00,0.00,74),('1','273','75','1',655.00,0.00,0.00,3113.16,2007988.20,2090360.64,82372.44,75),('1','273','76','1',645.00,0.00,0.00,4446.52,2868005.40,2979068.86,111063.46,76),('1','273','77','1',645.00,0.00,0.00,5879.92,3792548.40,3936685.78,144137.38,77),('1','273','78','1',645.00,0.00,0.00,5740.01,3702306.45,3845414.26,143107.81,78),('1','273','79','1',645.00,0.00,0.00,4698.03,3030229.35,3151475.36,121246.01,79),('1','273','80','1',645.00,0.00,0.00,807.35,520740.75,547689.98,26949.23,80),('1','273','81','1',645.00,0.00,0.00,0.00,0.00,0.00,0.00,81),('1','273','82','1',645.00,0.00,0.00,1329.47,857508.15,893038.64,35530.49,82),('1','273','83','1',645.00,0.00,0.00,5829.02,3759717.90,3896903.90,137186.00,83),('1','273','84','1',645.00,0.00,0.00,8320.81,5366922.45,5564416.58,197494.13,84),('1','273','85','1',645.00,0.00,0.00,8263.90,5330215.50,5533799.54,203584.04,85),('1','273','86','1',645.00,0.00,0.00,614.53,396371.85,412876.02,16504.17,86),('1','273','87','1',645.00,0.00,0.00,0.00,0.00,0.00,0.00,87),('1','273','88','1',645.00,0.00,0.00,6668.53,4301201.85,4463844.46,162642.61,88),('1','273','89','1',645.00,0.00,0.00,6343.41,4091499.45,4256854.48,165355.03,89),('1','273','90','1',645.00,0.00,0.00,2224.20,1434609.00,1509589.26,74980.26,90),('1','273','91','1',645.00,0.00,0.00,7878.58,5081684.10,5264374.16,182690.06,91),('1','273','92','1',645.00,0.00,0.00,1505.57,971092.65,1006618.24,35525.59,92),('1','273','93','1',645.00,0.00,0.00,0.00,0.00,0.00,0.00,93),('1','273','94','1',652.00,0.00,0.00,9759.26,6363037.52,6561365.92,198328.40,94),('1','273','95','1',652.00,0.00,0.00,6564.11,4279799.72,4420497.62,140697.90,95),('1','273','96','1',652.00,0.00,0.00,7792.26,5080553.52,5248818.12,168264.60,96),('1','273','97','1',652.00,0.00,0.00,142.10,92649.20,95207.00,2557.80,97),('1','273','98','1',652.00,0.00,0.00,0.00,0.00,0.00,0.00,98),('1','273','99','1',650.00,0.00,0.00,6105.61,3968646.50,4144290.39,175643.89,99),('1','273','100','1',650.00,0.00,0.00,5707.14,3709641.00,3871498.08,161857.08,100),('1','273','101','1',650.00,0.00,0.00,6393.19,4155573.50,4335720.69,180147.19,101),('1','273','102','1',650.00,0.00,0.00,6670.99,4336143.50,4518671.74,182528.24,102),('1','273','103','1',650.00,0.00,0.00,0.00,0.00,0.00,0.00,103),('1','273','104','1',645.00,0.00,0.00,9901.94,6386751.30,6713584.51,326833.21,104),('1','273','105','1',645.00,0.00,0.00,6644.55,4285734.75,4514277.94,228543.19,105),('1','273','106','1',645.00,0.00,0.00,2756.48,1777929.60,1883674.26,105744.66,106),('1','273','107','1',645.00,0.00,0.00,4930.30,3180043.50,3348533.01,168489.51,107),('1','273','108','1',645.00,0.00,0.00,834.17,538039.65,564736.04,26696.39,108),('1','273','109','1',645.00,0.00,0.00,0.00,0.00,0.00,0.00,109),('1','273','110','1',645.00,712.00,0.00,3624.76,2337970.20,2476512.06,138541.86,110),('1','273','111','1',645.00,0.00,0.00,3555.15,2293071.75,2414161.80,121090.05,111),('1','273','112','1',645.00,0.00,0.00,2778.20,1791939.00,1906356.12,114417.12,112),('1','273','113','1',645.00,0.00,0.00,1434.07,924975.15,976657.84,51682.69,113),('1','273','114','1',645.00,0.00,0.00,3605.24,2325379.80,2453349.02,127969.22,114),('1','273','115','1',645.00,0.00,0.00,2649.91,1709191.95,1803142.19,93950.24,115),('1','273','116','1',645.00,0.00,0.00,1874.21,1208865.45,1267783.52,58918.07,116),('1','273','117','1',645.00,0.00,0.00,3212.03,2071759.35,2169317.48,97558.13,117),('1','273','118','1',645.00,0.00,0.00,993.32,640691.40,675575.84,34884.44,118),('1','273','119','1',645.00,0.00,0.00,886.05,571502.25,595585.08,24082.83,119),('1','273','120','1',645.00,0.00,0.00,0.00,0.00,0.00,0.00,120),('1','273','121','1',645.00,0.00,0.00,3695.00,2383275.00,2502784.52,119509.52,121),('1','273','122','1',645.00,0.00,0.00,4612.29,2974927.05,3118449.48,143522.43,122),('1','273','123','1',645.00,0.00,0.00,3920.30,2528593.50,2651781.26,123187.76,123),('1','273','124','1',645.00,0.00,0.00,3853.33,2485397.85,2603080.96,117683.11,124),('1','273','125','1',645.00,0.00,0.00,3477.40,2242923.00,2359776.70,116853.70,125),('1','273','126','1',645.00,0.00,0.00,3001.83,1936180.35,2028744.30,92563.95,126),('1','273','127','1',645.00,0.00,0.00,2077.85,1340213.25,1405589.42,65376.17,127),('1','273','128','1',645.00,0.00,0.00,0.00,0.00,0.00,0.00,128),('1','273','129','1',645.00,0.00,0.00,2186.57,1410337.65,1487726.84,77389.19,129),('1','273','130','1',645.00,0.00,0.00,3627.44,2339698.80,2450227.28,110528.48,130),('1','273','131','1',645.00,0.00,0.00,2290.90,1477630.50,1557284.80,79654.30,131),('1','273','132','1',645.00,0.00,0.00,2743.56,1769596.20,1864878.30,95282.10,132),('1','273','133','1',645.00,0.00,0.00,2722.62,1756089.90,1841674.44,85584.54,133),('1','273','134','1',645.00,0.00,0.00,2892.84,1865881.80,1959343.08,93461.28,134),('1','273','135','1',645.00,0.00,0.00,3451.62,2226294.90,2333918.04,107623.14,135),('1','273','136','1',645.00,0.00,0.00,1412.21,910875.45,969726.32,58850.87,136),('1','273','137','1',645.00,0.00,0.00,3595.85,2319323.25,2422856.90,103533.65,137),('1','273','138','1',645.00,0.00,0.00,0.00,0.00,0.00,0.00,138),('1','273','139','1',639.00,0.00,0.00,3870.16,2473032.24,2622230.80,149198.56,139),('1','273','140','1',639.00,0.00,0.00,1425.85,911118.15,975557.20,64439.05,140),('1','273','141','1',639.00,0.00,0.00,2767.44,1768394.16,1872429.60,104035.44,141),('1','273','142','1',639.00,0.00,0.00,1354.99,865838.61,920932.88,55094.27,142),('1','273','143','1',639.00,0.00,0.00,2794.98,1785992.22,1878158.76,92166.54,143),('1','273','144','1',639.00,0.00,0.00,4386.51,2802979.89,2936309.12,133329.23,144),('1','273','145','1',639.00,0.00,0.00,2703.74,1727689.86,1825513.50,97823.64,145),('1','273','146','1',639.00,0.00,0.00,5402.31,3452076.09,3605168.72,153092.63,146),('1','273','147','1',639.00,0.00,0.00,0.00,0.00,0.00,0.00,147),('1','273','148','1',639.00,0.00,0.00,4134.46,2641919.94,2776278.02,134358.08,148),('1','273','149','1',639.00,0.00,0.00,1886.92,1205741.88,1271664.31,65922.43,149),('1','273','150','1',639.00,0.00,0.00,3705.12,2367571.68,2497117.52,129545.84,150),('1','273','151','1',639.00,0.00,0.00,2058.50,1315381.50,1399085.50,83704.00,151),('1','273','152','1',639.00,0.00,0.00,3210.92,2051777.88,2158053.54,106275.66,152),('1','273','153','1',639.00,0.00,0.00,1368.79,874656.81,928910.48,54253.67,153),('1','273','154','1',639.00,0.00,0.00,2718.12,1736878.68,1828201.65,91322.97,154),('1','273','155','1',639.00,0.00,0.00,1011.91,646610.49,688801.42,42190.93,155),('1','273','156','1',639.00,0.00,0.00,2461.17,1572687.63,1668269.04,95581.41,156),('1','273','157','1',639.00,0.00,0.00,2065.51,1319860.89,1387490.12,67629.23,157),('1','273','158','1',639.00,0.00,0.00,0.00,0.00,0.00,0.00,158),('1','273','159','1',639.00,0.00,0.00,1276.09,815421.51,863128.08,47706.57,159),('1','273','160','1',639.00,0.00,0.00,2131.53,1362047.67,1441989.36,79941.69,160),('1','273','161','1',639.00,0.00,0.00,3532.32,2257152.48,2358257.84,101105.36,161),('1','273','162','1',639.00,0.00,0.00,1511.13,965612.07,1024002.04,58389.97,162),('1','273','163','1',639.00,0.00,0.00,1578.40,1008597.60,1050547.60,41950.00,163),('1','273','164','1',639.00,0.00,0.00,2081.85,1330302.15,1420704.52,90402.37,164),('1','273','165','1',639.00,0.00,0.00,1326.12,847390.68,904865.16,57474.48,165),('1','273','166','1',639.00,0.00,0.00,2291.14,1464038.46,1542532.88,78494.42,166),('1','273','167','1',639.00,0.00,0.00,1722.33,1100568.87,1163161.08,62592.21,167),('1','273','168','1',639.00,0.00,0.00,2287.51,1461718.89,1537959.32,76240.43,168),('1','273','169','1',639.00,0.00,0.00,2533.21,1618721.19,1700310.08,81588.89,169),('1','273','170','1',639.00,0.00,0.00,1315.02,840297.78,895751.92,55454.14,170),('1','273','171','1',639.00,0.00,0.00,1026.07,655658.73,685464.32,29805.59,171),('1','273','172','1',639.00,0.00,0.00,0.00,0.00,0.00,0.00,172),('1','273','173','1',640.00,0.00,0.00,856.12,547916.80,594895.20,46978.40,173),('1','273','174','1',640.00,0.00,0.00,1051.82,673164.80,729335.40,56170.60,174),('1','273','175','1',640.00,0.00,0.00,1819.39,1164409.60,1246635.80,82226.20,175),('1','273','176','1',640.00,0.00,0.00,1259.77,806252.80,875534.40,69281.60,176),('1','273','177','1',640.00,0.00,0.00,2480.27,1587372.80,1689844.40,102471.60,177),('1','273','178','1',640.00,0.00,0.00,1309.62,838156.80,903589.90,65433.10,178),('1','273','179','1',640.00,0.00,0.00,2450.60,1568384.00,1669282.00,100898.00,179),('1','273','180','1',640.00,0.00,0.00,1437.24,919833.60,1000238.30,80404.70,180),('1','273','181','1',640.00,0.00,0.00,2730.26,1747366.40,1849812.20,102445.80,181),('1','273','182','1',640.00,0.00,0.00,895.17,572908.80,630172.40,57263.60,182),('1','273','183','1',640.00,0.00,0.00,872.09,558137.60,605045.20,46907.60,183),('1','273','184','1',640.00,0.00,0.00,5725.72,3664460.80,3799848.60,135387.80,184),('1','273','185','1',640.00,0.00,0.00,1607.67,1028908.80,1072867.80,43959.00,185),('1','273','186','1',640.00,0.00,0.00,0.00,0.00,0.00,0.00,186),('1','273','187','1',640.00,0.00,0.00,5283.39,3381369.60,3525039.60,143670.00,187),('1','273','188','1',640.00,0.00,0.00,2726.03,1744659.20,1838367.00,93707.80,188),('1','273','189','1',640.00,0.00,0.00,6538.47,4184620.80,4343028.00,158407.20,189),('1','273','190','1',640.00,0.00,0.00,3760.89,2406969.60,2505171.60,98202.00,190),('1','273','191','1',640.00,0.00,0.00,4533.23,2901267.20,3022311.00,121043.80,191),('1','273','192','1',640.00,0.00,0.00,2053.90,1314496.00,1361937.60,47441.60,192),('1','273','193','1',640.00,0.00,0.00,0.00,0.00,0.00,0.00,193),('1','273','194','1',640.00,0.00,0.00,6525.50,4176320.00,4338015.00,161695.00,194),('1','273','195','1',640.00,0.00,0.00,2045.55,1309152.00,1377273.60,68121.60,195),('1','273','196','1',640.00,0.00,0.00,4564.09,2921017.60,3045918.60,124901.00,196),('1','273','197','1',640.00,0.00,0.00,3682.36,2356710.40,2464399.20,107688.80,197),('1','273','198','1',640.00,0.00,0.00,3056.81,1956358.40,2048815.80,92457.40,198),('1','273','199','1',640.00,0.00,0.00,3590.81,2298118.40,2403760.80,105642.40,199),('1','273','200','1',640.00,0.00,0.00,1385.39,886649.60,927580.80,40931.20,200),('1','273','201','1',640.00,0.00,0.00,0.00,0.00,0.00,0.00,201),('1','273','202','1',630.00,0.00,0.00,1723.78,1085981.40,1163148.00,77166.60,202),('1','273','203','1',630.00,0.00,0.00,2894.82,1823736.60,1943228.40,119491.80,203),('1','273','204','1',630.00,0.00,0.00,4009.55,2526016.50,2679126.00,153109.50,204),('1','273','205','1',630.00,0.00,0.00,2759.24,1738321.20,1853007.00,114685.80,205),('1','273','206','1',630.00,0.00,0.00,2996.39,1887725.70,2013114.90,125389.20,206),('1','273','207','1',630.00,0.00,0.00,1382.17,870767.10,934491.00,63723.90,207),('1','273','208','1',630.00,0.00,0.00,2494.90,1571787.00,1675545.60,103758.60,208),('1','273','209','1',630.00,0.00,0.00,2304.69,1451954.70,1555636.80,103682.10,209),('1','273','210','1',630.00,0.00,0.00,2741.74,1727296.20,1840672.20,113376.00,210),('1','273','211','1',630.00,0.00,0.00,812.37,511793.10,536589.00,24795.90,211),('1','273','212','1',630.00,0.00,0.00,0.00,0.00,0.00,0.00,212),('1','273','213','1',630.00,0.00,0.00,1347.21,848742.30,905989.20,57246.90,213),('1','273','214','1',630.00,0.00,0.00,3895.84,2454379.20,2612584.80,158205.60,214),('1','273','215','1',630.00,0.00,0.00,4063.38,2559929.40,2713480.20,153550.80,215),('1','273','216','1',630.00,0.00,0.00,2043.98,1287707.40,1376349.60,88642.20,216),('1','273','217','1',630.00,0.00,0.00,4100.90,2583567.00,2751690.00,168123.00,217),('1','273','218','1',630.00,0.00,0.00,4350.72,2740953.60,2912241.00,171287.40,218),('1','273','219','1',630.00,0.00,0.00,1970.29,1241282.70,1337703.60,96420.90,219),('1','273','220','1',630.00,0.00,0.00,2963.14,1866778.20,1977288.60,110510.40,220),('1','273','221','1',630.00,0.00,0.00,0.00,0.00,0.00,0.00,221),('1','273','222','1',630.00,0.00,0.00,3646.15,2297074.50,2441960.40,144885.90,222),('1','273','223','1',630.00,0.00,0.00,2784.26,1754083.80,1875100.20,121016.40,223),('1','273','224','1',630.00,0.00,0.00,2836.13,1786761.90,1907221.50,120459.60,224),('1','273','225','1',630.00,0.00,0.00,3082.37,1941893.10,2080669.20,138776.10,225),('1','273','226','1',630.00,0.00,0.00,4464.93,2812905.90,2989269.00,176363.10,226),('1','273','227','1',630.00,0.00,0.00,3449.33,2173077.90,2332169.40,159091.50,227),('1','273','228','1',630.00,0.00,0.00,3060.20,1927926.00,2059253.40,131327.40,228),('1','273','229','1',630.00,0.00,0.00,1094.31,689415.30,724384.80,34969.50,229),('1','273','230','1',630.00,0.00,0.00,0.00,0.00,0.00,0.00,230),('1','273','231','1',630.00,0.00,0.00,7276.05,4583911.50,4920759.00,336847.50,231),('1','273','232','1',630.00,0.00,0.00,3374.42,2125884.60,2285318.68,159434.08,232),('1','273','233','1',630.00,0.00,0.00,3874.80,2441124.00,2596746.00,155622.00,233),('1','273','234','1',630.00,0.00,0.00,2378.89,1498700.70,1600682.40,101981.70,234),('1','273','235','1',630.00,0.00,0.00,2214.45,1395103.50,1488829.20,93725.70,235),('1','273','236','1',630.00,0.00,0.00,2522.82,1589376.60,1695241.80,105865.20,236),('1','273','237','1',630.00,0.00,0.00,3045.04,1918375.20,2020045.80,101670.60,237),('1','273','238','1',630.00,0.00,0.00,0.00,0.00,0.00,0.00,238),('1','273','239','1',630.00,0.00,0.00,3012.74,1898026.20,1999802.40,101776.20,239),('1','273','240','1',630.00,0.00,0.00,4327.80,2726514.00,2912899.20,186385.20,240),('1','273','241','1',630.00,0.00,0.00,2033.27,1280960.10,1394112.40,113152.30,241),('1','273','242','1',630.00,0.00,0.00,4132.04,2603185.20,2771940.60,168755.40,242),('1','273','243','1',630.00,0.00,0.00,6739.91,4246143.30,4486580.40,240437.10,243),('1','273','244','1',630.00,0.00,0.00,4191.67,2640752.10,2796864.60,156112.50,244),('1','273','245','1',630.00,0.00,0.00,0.00,0.00,0.00,0.00,245),('1','273','246','1',630.00,0.00,0.00,3145.94,1981942.20,2116066.80,134124.60,246),('1','273','247','1',630.00,0.00,0.00,2825.00,1779750.00,1890780.00,111030.00,247),('1','273','248','1',630.00,0.00,0.00,1467.26,924373.80,1004041.80,79668.00,248),('1','273','249','1',630.00,0.00,0.00,3290.99,2073323.70,2202756.60,129432.90,249),('1','273','250','1',630.00,0.00,0.00,4441.27,2798000.10,2962996.80,164996.70,250),('1','273','251','1',630.00,0.00,0.00,2392.43,1507230.90,1610395.80,103164.90,251),('1','273','252','1',630.00,0.00,0.00,3176.15,2000974.50,2132454.60,131480.10,252),('1','273','253','1',630.00,0.00,0.00,1797.81,1132620.30,1230283.20,97662.90,253),('1','273','254','1',630.00,0.00,0.00,2233.83,1407312.90,1482927.00,75614.10,254),('1','273','255','1',630.00,0.00,0.00,0.00,0.00,0.00,0.00,255),('1','273','256','1',630.00,0.00,0.00,1995.97,1257461.10,1357958.40,100497.30,256),('1','273','257','1',630.00,0.00,0.00,3521.03,2218248.90,2359190.40,140941.50,257),('1','273','258','1',630.00,0.00,0.00,3288.32,2071641.60,2199170.40,127528.80,258),('1','273','259','1',630.00,0.00,0.00,3818.31,2405535.30,2568223.20,162687.90,259),('1','273','260','1',630.00,0.00,0.00,3260.62,2054190.60,2180222.40,126031.80,260),('1','273','261','1',630.00,0.00,0.00,3375.58,2126615.40,2232014.50,105399.10,261),('1','273','262','1',630.00,0.00,0.00,4025.49,2536058.70,2663782.80,127724.10,262),('1','273','263','1',630.00,0.00,0.00,1416.12,892155.60,958076.40,65920.80,263),('1','273','264','1',630.00,0.00,0.00,0.00,0.00,0.00,0.00,264),('1','273','265','1',601.00,0.00,0.00,2686.92,1614838.92,1779909.00,165070.08,265),('1','273','266','1',601.00,0.00,0.00,3544.22,2130076.22,2340024.00,209947.78,266),('1','273','267','1',601.00,0.00,0.00,2649.48,1592337.48,1763702.80,171365.32,267),('1','273','268','1',601.00,0.00,0.00,2689.54,1616413.54,1768135.60,151722.06,268),('1','273','269','1',601.00,0.00,0.00,3803.42,2285855.42,2501443.10,215587.68,269),('1','273','270','1',601.00,0.00,0.00,3834.83,2304732.83,2546107.60,241374.77,270),('1','273','271','1',601.00,0.00,0.00,1240.68,745648.68,845931.80,100283.12,271),('1','273','272','1',601.00,0.00,0.00,3883.10,2333743.10,2548456.00,214712.90,272),('1','273','273','1',601.00,0.00,0.00,0.00,0.00,0.00,0.00,273),('1','273','274','1',615.00,0.00,0.00,4055.91,2494384.65,2671055.20,176670.55,274),('1','273','275','1',615.00,0.00,0.00,4056.24,2494587.60,2692927.70,198340.10,275),('1','273','276','1',615.00,0.00,0.00,4009.99,2466143.85,2641551.60,175407.75,276),('1','273','277','1',615.00,0.00,0.00,3275.90,2014678.50,2167373.00,152694.50,277),('1','273','278','1',615.00,0.00,0.00,5196.82,3196044.30,3416601.70,220557.40,278),('1','273','279','1',615.00,0.00,0.00,1819.33,1118887.95,1240104.50,121216.55,279),('1','273','280','1',615.00,0.00,0.00,2452.00,1507980.00,1607532.60,99552.60,280),('1','273','281','1',615.00,0.00,0.00,0.00,0.00,0.00,0.00,281),('1','273','282','1',601.00,0.00,0.00,3128.69,1880342.69,2084017.70,203675.01,282),('1','273','283','1',601.00,0.00,0.00,4283.86,2574599.86,2831021.90,256422.04,283),('1','273','284','1',601.00,0.00,0.00,2930.54,1761254.54,1946282.60,185028.06,284),('1','273','285','1',601.00,0.00,0.00,3067.55,1843597.55,2027382.90,183785.35,285),('1','273','286','1',601.00,0.00,0.00,2990.97,1797572.97,1980633.40,183060.43,286),('1','273','287','1',601.00,0.00,0.00,1680.35,1009890.35,1143282.00,133391.65,287),('1','273','288','1',601.00,0.00,0.00,3696.60,2221656.60,2439019.90,217363.30,288),('1','273','289','1',601.00,0.00,0.00,2916.35,1752726.35,1908814.80,156088.45,289),('1','273','290','1',601.00,0.00,0.00,0.00,0.00,0.00,0.00,290),('1','273','291','1',601.00,0.00,0.00,4982.02,2994194.02,3296160.30,301966.28,291),('1','273','292','1',601.00,0.00,0.00,3099.01,1862505.01,2058551.70,196046.69,292),('1','273','293','1',601.00,0.00,0.00,3121.55,1876051.55,2075106.00,199054.45,293),('1','273','294','1',601.00,0.00,0.00,2251.27,1353013.27,1514908.50,161895.23,294),('1','273','295','1',601.00,0.00,0.00,4470.49,2686764.49,2951882.70,265118.21,295),('1','273','296','1',601.00,0.00,0.00,2289.02,1375701.02,1532139.40,156438.38,296),('1','273','297','1',601.00,0.00,0.00,3422.38,2056850.38,2273730.40,216880.02,297),('1','273','298','1',601.00,0.00,0.00,853.90,513193.90,556850.10,43656.20,298),('1','273','299','1',601.00,0.00,0.00,0.00,0.00,0.00,0.00,299),('1','273','300','1',601.00,0.00,0.00,6615.64,3975999.64,4358514.50,382514.86,300),('1','273','301','1',601.00,0.00,0.00,4912.57,2952454.57,3242630.40,290175.83,301),('1','273','302','1',601.00,0.00,0.00,1284.25,771834.25,864530.00,92695.75,302),('1','273','303','1',601.00,0.00,0.00,2899.25,1742449.25,1924147.90,181698.65,303),('1','273','304','1',601.00,0.00,0.00,3652.80,2195332.80,2409061.00,213728.20,304),('1','273','305','1',601.00,0.00,0.00,2723.00,1636523.00,1815499.00,178976.00,305),('1','273','306','1',601.00,0.00,0.00,2679.48,1610367.48,1791199.60,180832.12,306),('1','273','307','1',601.00,0.00,0.00,0.00,0.00,0.00,0.00,307),('1','273','308','1',601.00,0.00,0.00,3508.18,2108416.18,2311821.90,203405.72,308),('1','273','309','1',601.00,0.00,0.00,1992.89,1197726.89,1338498.50,140771.61,309),('1','273','310','1',601.00,0.00,0.00,2442.04,1467666.04,1597966.00,130299.96,310),('1','273','311','1',601.00,0.00,0.00,2278.66,1369474.66,1491002.00,121527.34,311),('1','273','312','1',601.00,0.00,0.00,3543.12,2129415.12,2304217.20,174802.08,312),('1','273','313','1',601.00,0.00,0.00,2600.06,1562636.06,1719002.00,156365.94,313),('1','273','314','1',601.00,0.00,0.00,1966.69,1181980.69,1286645.20,104664.51,314),('1','273','315','1',601.00,0.00,0.00,2915.57,1752257.57,1914863.60,162606.03,315),('1','273','316','1',601.00,0.00,0.00,2891.05,1737521.05,1908274.60,170753.55,316),('1','273','317','1',601.00,0.00,0.00,0.00,0.00,0.00,0.00,317),('1','273','318','1',602.00,0.00,0.00,2657.52,1599827.04,1734744.00,134916.96,318),('1','273','319','1',602.00,0.00,0.00,2215.39,1333664.78,1454406.40,120741.62,319),('1','273','320','1',602.00,0.00,0.00,4401.88,2649931.76,2873837.80,223906.04,320),('1','273','321','1',602.00,0.00,0.00,3224.54,1941173.08,2120206.40,179033.32,321),('1','273','322','1',602.00,0.00,0.00,3206.14,1930096.28,2068198.00,138101.72,322);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'273','LPG PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','273','1',1,1,'1','LPG TANK ',25000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2022-05-18 11:43:02','2022-05-18 11:43:02','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','273',1,9174.47,'2023-03-20 16:51:42');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=34766 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,15181070.00,25010.00,0.00,0.00,'2022-05-19 08:26:32','',''),(2,'1','273',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,25000.00,0.00,'2022-05-19 08:34:48','',''),(3,'1','273','1',1,'Received from bridging 2',0.00,0.00,25000.00,0.00,0.00,'2022-05-19 08:34:48','',''),(4,'1','273','1',1,'Retail Sale Id 1',1401.04,0.00,0.00,2.11,120.27,'2022-05-19 12:24:03','',''),(5,'1','273','1',1,'Retail Sale Id 2',1002.64,0.00,0.00,1.51,86.07,'2022-05-19 13:19:49','',''),(6,'1','273','1',1,'Retail Sale Id 2',1998.64,0.00,0.00,3.01,171.57,'2022-05-19 13:19:49','',''),(7,'1','273','1',1,'Retail Sale Id 3',3320.00,0.00,0.00,5.00,285.00,'2022-05-19 14:18:38','',''),(8,'1','273','1',1,'Retail Sale Id 4',3320.00,0.00,0.00,5.00,285.00,'2022-05-19 15:06:36','',''),(9,'1','273','1',1,'Retail Sale Id 5',3984.00,0.00,0.00,6.00,342.00,'2022-05-19 16:06:31','',''),(10,'1','273','1',1,'Retail Sale Id 6',3997.28,0.00,0.00,6.02,343.14,'2022-05-19 16:07:55','',''),(11,'1','273','1',1,'Retail Sale Id 8',1002.64,0.00,0.00,1.51,86.07,'2022-05-19 16:24:35','',''),(12,'1','273','1',1,'Return of Retail Sale Id 5',0.00,3984.00,6.00,0.00,-342.00,'2022-05-19 16:25:59','',''),(13,'1','273','1',1,'Retail Sale Id 9',3831.28,0.00,0.00,5.77,328.89,'2022-05-19 16:28:02','',''),(14,'1','273','1',1,'Retail Sale Id 10',1328.00,0.00,0.00,2.00,114.00,'2022-05-19 16:37:54','',''),(15,'1','273','1',1,'Retail Sale Id 11',1500.64,0.00,0.00,2.26,128.82,'2022-05-19 16:47:26','',''),(16,'1','273','1',1,'Retail Sale Id 12',1002.64,0.00,0.00,1.51,86.07,'2022-05-19 16:51:08','',''),(17,'1','273','1',1,'Retail Sale Id 13',1201.84,0.00,0.00,1.81,103.17,'2022-05-19 16:54:42','',''),(18,'1','273','1',1,'Retail Sale Id 14',597.60,0.00,0.00,0.90,51.30,'2022-05-19 18:06:13','',''),(19,'1','273','1',1,'Retail Sale Id 15',1328.00,0.00,0.00,2.00,114.00,'2022-05-20 06:48:55','',''),(20,'1','273','1',1,'Retail Sale Id 16',650.72,0.00,0.00,0.98,55.86,'2022-05-20 06:53:58','',''),(21,'1','273','1',1,'Retail Sale Id 17',697.20,0.00,0.00,1.05,59.85,'2022-05-20 06:55:01','',''),(22,'1','273','1',1,'Retail Sale Id 18',3320.00,0.00,0.00,5.00,285.00,'2022-05-20 07:16:05','',''),(23,'1','273','1',1,'Retail Sale Id 19',1328.00,0.00,0.00,2.00,114.00,'2022-05-20 08:09:10','',''),(24,'1','273','1',1,'Retail Sale Id 20',1002.64,0.00,0.00,1.51,86.07,'2022-05-20 08:19:52','',''),(25,'1','273','1',1,'Retail Sale Id 21',4648.00,0.00,0.00,7.00,399.00,'2022-05-20 08:51:46','',''),(26,'1','273','1',1,'Retail Sale Id 22',8300.00,0.00,0.00,12.50,712.50,'2022-05-20 10:06:20','',''),(27,'1','273','1',1,'Retail Sale Id 23',664.00,0.00,0.00,1.00,57.00,'2022-05-20 10:13:14','',''),(28,'1','273','1',1,'Retail Sale Id 24',1992.00,0.00,0.00,3.00,171.00,'2022-05-20 10:26:47','',''),(29,'1','273','1',1,'Retail Sale Id 27',6998.56,0.00,0.00,10.54,600.78,'2022-05-20 13:52:24','',''),(30,'1','273','1',1,'Retail Sale Id 28',8300.00,0.00,0.00,12.50,712.50,'2022-05-20 15:00:47','',''),(31,'1','273','1',1,'Retail Sale Id 30',3984.00,0.00,0.00,6.00,342.00,'2022-05-20 15:34:20','',''),(32,'1','273','1',1,'Retail Sale Id 31',697.20,0.00,0.00,1.05,59.85,'2022-05-20 15:50:53','',''),(33,'1','273','1',1,'Retail Sale Id 33',1992.00,0.00,0.00,3.00,171.00,'2022-05-20 16:04:13','',''),(34,'1','273','1',1,'Retail Sale Id 34',1992.00,0.00,0.00,3.00,171.00,'2022-05-20 16:19:11','',''),(35,'1','273','1',1,'Retail Sale Id 35',796.80,0.00,0.00,1.20,68.40,'2022-05-20 16:20:12','',''),(36,'1','273','1',1,'Retail Sale Id 36',0.00,0.00,0.00,2.00,-1214.00,'2022-05-20 16:31:14','',''),(37,'1','273','1',1,'Return of Retail Sale Id 36',0.00,0.00,2.00,0.00,1214.00,'2022-05-20 16:58:44','',''),(38,'1','273','1',1,'Retail Sale Id 38',1328.00,0.00,0.00,2.00,114.00,'2022-05-20 17:01:27','',''),(39,'1','273','1',1,'Retail Sale Id 41',1002.64,0.00,0.00,1.51,86.07,'2022-05-20 17:05:34','',''),(40,'1','273','1',1,'Retail Sale Id 42',6640.00,0.00,0.00,10.00,570.00,'2022-05-20 17:08:34','',''),(41,'1','273','1',1,'Retail Sale Id 43',1998.64,0.00,0.00,3.01,171.57,'2022-05-20 17:12:32','',''),(42,'1','273','1',1,'Retail Sale Id 44',8300.00,0.00,0.00,12.50,712.50,'2022-05-20 17:36:44','',''),(43,'1','273','1',1,'Retail Sale Id 45',1328.00,0.00,0.00,2.00,114.00,'2022-05-20 18:12:04','',''),(44,'1','273','1',1,'Retail Sale Id 46',1992.00,0.00,0.00,3.00,171.00,'2022-05-20 18:17:42','',''),(45,'1','273','1',1,'Retail Sale Id 47',6640.00,0.00,0.00,10.00,570.00,'2022-05-20 18:25:39','',''),(46,'1','273','1',1,'Retail Sale Id 48',1998.64,0.00,0.00,3.01,171.57,'2022-05-20 18:29:30','',''),(47,'1','273','1',1,'Retail Sale Id 49',697.20,0.00,0.00,1.05,59.85,'2022-05-20 18:36:39','',''),(48,'1','273','1',1,'Retail Sale Id 50',2656.00,0.00,0.00,4.00,228.00,'2022-05-20 18:40:24','',''),(49,'1','273','1',1,'Retail Sale Id 51',597.60,0.00,0.00,0.90,51.30,'2022-05-20 19:04:37','',''),(50,'1','273','1',1,'Retail Sale Id 52',956.16,0.00,0.00,1.44,82.08,'2022-05-20 20:06:01','',''),(51,'1','273','1',1,'Retail Sale Id 53',2656.00,0.00,0.00,4.00,228.00,'2022-05-21 06:52:47','',''),(52,'1','273','1',1,'Retail Sale Id 54',1500.64,0.00,0.00,2.26,128.82,'2022-05-21 06:53:41','',''),(53,'1','273','1',1,'Retail Sale Id 55',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 07:23:30','',''),(54,'1','273','1',1,'Retail Sale Id 56',3320.00,0.00,0.00,5.00,285.00,'2022-05-21 07:27:13','',''),(55,'1','273','1',1,'Retail Sale Id 57',1328.00,0.00,0.00,2.00,114.00,'2022-05-21 07:36:24','',''),(56,'1','273','1',1,'Retail Sale Id 58',664.00,0.00,0.00,1.00,57.00,'2022-05-21 08:04:04','',''),(57,'1','273','1',1,'Retail Sale Id 59',3320.00,0.00,0.00,5.00,285.00,'2022-05-21 08:05:51','',''),(58,'1','273','1',1,'Retail Sale Id 60',3001.28,0.00,0.00,4.52,257.64,'2022-05-21 08:06:52','',''),(59,'1','273','1',1,'Retail Sale Id 61',8632.00,0.00,0.00,13.00,741.00,'2022-05-21 08:10:34','',''),(60,'1','273','1',1,'Retail Sale Id 62',664.00,0.00,0.00,1.00,57.00,'2022-05-21 08:28:27','',''),(61,'1','273','1',1,'Retail Sale Id 63',1002.64,0.00,0.00,1.51,86.07,'2022-05-21 09:21:52','',''),(62,'1','273','1',1,'Retail Sale Id 64',0.00,0.00,0.00,4.52,-2743.64,'2022-05-21 09:29:17','',''),(63,'1','273','1',1,'Retail Sale Id 65',3001.28,0.00,0.00,4.52,257.64,'2022-05-21 09:31:48','',''),(64,'1','273','1',1,'Retail Sale Id 67',1992.00,0.00,0.00,3.00,171.00,'2022-05-21 09:37:30','',''),(65,'1','273','1',1,'Retail Sale Id 69',1500.64,0.00,0.00,2.26,128.82,'2022-05-21 09:51:29','',''),(66,'1','273','1',1,'Retail Sale Id 70',1328.00,0.00,0.00,2.00,114.00,'2022-05-21 09:56:32','',''),(67,'1','273','1',1,'Retail Sale Id 71',8300.00,0.00,0.00,12.50,712.50,'2022-05-21 10:32:36','',''),(68,'1','273','1',1,'Retail Sale Id 72',3984.00,0.00,0.00,6.00,342.00,'2022-05-21 10:51:22','',''),(69,'1','273','1',1,'Retail Sale Id 73',3984.00,0.00,0.00,6.00,342.00,'2022-05-21 11:42:49','',''),(70,'1','273','1',1,'Retail Sale Id 74',637.44,0.00,0.00,0.96,54.72,'2022-05-21 11:52:09','',''),(71,'1','273','1',1,'Retail Sale Id 75',1500.64,0.00,0.00,2.26,128.82,'2022-05-21 11:55:31','',''),(72,'1','273','1',1,'Retail Sale Id 76',31000.00,0.00,0.00,50.00,650.00,'2022-05-21 12:05:05','',''),(73,'1','273','1',1,'Retail Sale Id 77',3001.28,0.00,0.00,4.52,257.64,'2022-05-21 12:10:18','',''),(74,'1','273','1',1,'Retail Sale Id 78',1992.00,0.00,0.00,3.00,171.00,'2022-05-21 12:19:31','',''),(75,'1','273','1',1,'Retail Sale Id 79',3001.28,0.00,0.00,4.52,257.64,'2022-05-21 12:26:53','',''),(76,'1','273','1',1,'Retail Sale Id 80',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 12:44:30','',''),(77,'1','273','1',1,'Retail Sale Id 81',498.00,0.00,0.00,0.75,42.75,'2022-05-21 13:28:42','',''),(78,'1','273','1',1,'Retail Sale Id 82',1328.00,0.00,0.00,2.00,114.00,'2022-05-21 13:56:10','',''),(79,'1','273','1',1,'Retail Sale Id 83',3320.00,0.00,0.00,5.00,285.00,'2022-05-21 14:25:40','',''),(80,'1','273','1',1,'Retail Sale Id 84',3320.00,0.00,0.00,5.00,285.00,'2022-05-21 14:31:26','',''),(81,'1','273','1',1,'Retail Sale Id 85',2656.00,0.00,0.00,4.00,228.00,'2022-05-21 14:33:07','',''),(82,'1','273','1',1,'Retail Sale Id 86',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 14:35:27','',''),(83,'1','273','1',1,'Retail Sale Id 87',1002.64,0.00,0.00,1.51,86.07,'2022-05-21 14:56:15','',''),(84,'1','273','1',1,'Retail Sale Id 88',697.20,0.00,0.00,1.05,59.85,'2022-05-21 15:13:22','',''),(85,'1','273','1',1,'Retail Sale Id 89',8300.00,0.00,0.00,12.50,712.50,'2022-05-21 15:18:28','',''),(86,'1','273','1',1,'Retail Sale Id 90',664.00,0.00,0.00,1.00,57.00,'2022-05-21 15:38:07','',''),(87,'1','273','1',1,'Retail Sale Id 91',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 15:51:50','',''),(88,'1','273','1',1,'Retail Sale Id 92',1201.84,0.00,0.00,1.81,103.17,'2022-05-21 16:15:06','',''),(89,'1','273','1',1,'Retail Sale Id 93',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 16:16:10','',''),(90,'1','273','1',1,'Retail Sale Id 94',1002.64,0.00,0.00,1.51,86.07,'2022-05-21 16:17:15','',''),(91,'1','273','1',1,'Retail Sale Id 95',1500.64,0.00,0.00,2.26,128.82,'2022-05-21 16:19:19','',''),(92,'1','273','1',1,'Retail Sale Id 96',2656.00,0.00,0.00,4.00,228.00,'2022-05-21 16:21:56','',''),(93,'1','273','1',1,'Retail Sale Id 97',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 16:24:14','',''),(94,'1','273','1',1,'Retail Sale Id 98',6640.00,0.00,0.00,10.00,570.00,'2022-05-21 16:35:12','',''),(95,'1','273','1',1,'Retail Sale Id 99',1002.64,0.00,0.00,1.51,86.07,'2022-05-21 16:38:05','',''),(96,'1','273','1',1,'Retail Sale Id 100',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 16:44:59','',''),(97,'1','273','1',1,'Retail Sale Id 100',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 16:44:59','',''),(98,'1','273','1',1,'Retail Sale Id 101',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 16:46:54','',''),(99,'1','273','1',1,'Retail Sale Id 102',1201.84,0.00,0.00,1.81,103.17,'2022-05-21 17:03:04','',''),(100,'1','273','1',1,'Retail Sale Id 103',1002.64,0.00,0.00,1.51,86.07,'2022-05-21 17:07:14','',''),(101,'1','273','1',1,'Retail Sale Id 104',1002.64,0.00,0.00,1.51,86.07,'2022-05-21 17:08:12','',''),(102,'1','273','1',1,'Retail Sale Id 105',3997.28,0.00,0.00,6.02,343.14,'2022-05-21 17:13:44','',''),(103,'1','273','1',1,'Retail Sale Id 106',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 17:21:25','',''),(104,'1','273','1',1,'Retail Sale Id 107',1328.00,0.00,0.00,2.00,114.00,'2022-05-21 17:35:08','',''),(105,'1','273','1',1,'Retail Sale Id 108',1002.64,0.00,0.00,1.51,86.07,'2022-05-21 17:47:38','',''),(106,'1','273','1',1,'Retail Sale Id 109',1998.64,0.00,0.00,3.01,171.57,'2022-05-21 17:53:49','',''),(107,'1','273','1',1,'Retail Sale Id 111',1328.00,0.00,0.00,2.00,114.00,'2022-05-21 18:04:25','',''),(108,'1','273','1',1,'Retail Sale Id 112',8300.00,0.00,0.00,12.50,712.50,'2022-05-21 18:06:51','',''),(109,'1','273','1',1,'Retail Sale Id 113',1328.00,0.00,0.00,2.00,114.00,'2022-05-21 18:08:07','',''),(110,'1','273','1',1,'Retail Sale Id 114',1328.00,0.00,0.00,2.00,114.00,'2022-05-21 18:10:56','',''),(111,'1','273','1',1,'Retail Sale Id 115',1328.00,0.00,0.00,2.00,114.00,'2022-05-21 18:19:11','',''),(112,'1','273','1',1,'Retail Sale Id 117',8001.20,0.00,0.00,12.05,686.85,'2022-05-21 18:23:21','',''),(113,'1','273','1',1,'Retail Sale Id 118',1002.64,0.00,0.00,1.51,86.07,'2022-05-22 06:46:34','',''),(114,'1','273','1',1,'Retail Sale Id 119',3320.00,0.00,0.00,5.00,285.00,'2022-05-22 07:21:03','',''),(115,'1','273','1',1,'Retail Sale Id 120',2656.00,0.00,0.00,4.00,228.00,'2022-05-22 07:33:10','',''),(116,'1','273','1',1,'Retail Sale Id 121',664.00,0.00,0.00,1.00,57.00,'2022-05-22 07:39:06','',''),(117,'1','273','1',1,'Retail Sale Id 122',9999.84,0.00,0.00,15.06,858.42,'2022-05-22 07:43:29','',''),(118,'1','273','1',1,'Retail Sale Id 123',697.20,0.00,0.00,1.05,59.85,'2022-05-22 07:44:25','',''),(119,'1','273','1',1,'Return of Retail Sale Id 122',0.00,9999.84,15.06,0.00,-858.42,'2022-05-22 07:52:47','',''),(120,'1','273','1',1,'Retail Sale Id 124',10497.84,0.00,0.00,15.81,901.17,'2022-05-22 07:54:12','',''),(121,'1','273','1',1,'Retail Sale Id 125',664.00,0.00,0.00,1.00,57.00,'2022-05-22 07:55:36','',''),(122,'1','273','1',1,'Retail Sale Id 126',3499.28,0.00,0.00,5.27,300.39,'2022-05-22 08:22:06','',''),(123,'1','273','1',1,'Retail Sale Id 127',3984.00,0.00,0.00,6.00,342.00,'2022-05-22 08:47:58','',''),(124,'1','273','1',1,'Retail Sale Id 128',13001.12,0.00,0.00,19.58,1116.06,'2022-05-22 08:55:37','',''),(125,'1','273','1',1,'Retail Sale Id 128',14999.76,0.00,0.00,22.59,1287.63,'2022-05-22 08:55:37','',''),(126,'1','273','1',1,'Retail Sale Id 129',4648.00,0.00,0.00,7.00,399.00,'2022-05-22 08:57:23','',''),(127,'1','273','1',1,'Retail Sale Id 130',8300.00,0.00,0.00,12.50,712.50,'2022-05-22 09:02:00','',''),(128,'1','273','1',1,'Retail Sale Id 131',8300.00,0.00,0.00,12.50,712.50,'2022-05-22 09:04:38','',''),(129,'1','273','1',1,'Retail Sale Id 132',8300.00,0.00,0.00,12.50,712.50,'2022-05-22 09:09:23','',''),(130,'1','273','1',1,'Retail Sale Id 133',3984.00,0.00,0.00,6.00,342.00,'2022-05-22 09:18:04','',''),(131,'1','273','1',1,'Retail Sale Id 134',3320.00,0.00,0.00,5.00,285.00,'2022-05-22 09:19:45','',''),(132,'1','273','1',1,'Retail Sale Id 135',1002.64,0.00,0.00,1.51,86.07,'2022-05-22 09:22:23','',''),(133,'1','273','1',1,'Retail Sale Id 136',1301.44,0.00,0.00,1.96,111.72,'2022-05-22 09:23:27','',''),(134,'1','273','1',1,'Retail Sale Id 137',6640.00,0.00,0.00,10.00,570.00,'2022-05-22 09:30:58','',''),(135,'1','273','1',1,'Retail Sale Id 138',697.20,0.00,0.00,1.05,59.85,'2022-05-22 09:43:20','',''),(136,'1','273','1',1,'Return of Retail Sale Id 128',0.00,13001.12,19.58,0.00,-1116.06,'2022-05-22 10:03:02','',''),(137,'1','273','1',1,'Return of Retail Sale Id 128',0.00,14999.76,22.59,0.00,-1287.63,'2022-05-22 10:03:02','',''),(138,'1','273','1',1,'Retail Sale Id 139',13001.12,0.00,0.00,19.58,1116.06,'2022-05-22 10:03:43','',''),(139,'1','273','1',1,'Retail Sale Id 141',14999.76,0.00,0.00,22.59,1287.63,'2022-05-22 10:04:41','',''),(140,'1','273','1',1,'Retail Sale Id 142',8300.00,0.00,0.00,12.50,712.50,'2022-05-22 10:23:15','',''),(141,'1','273','1',1,'Retail Sale Id 143',796.80,0.00,0.00,1.20,68.40,'2022-05-22 10:36:35','',''),(142,'1','273','1',1,'Retail Sale Id 144',1301.44,0.00,0.00,1.96,111.72,'2022-05-22 10:53:51','',''),(143,'1','273','1',1,'Retail Sale Id 145',8001.20,0.00,0.00,12.05,686.85,'2022-05-22 10:54:50','',''),(144,'1','273','1',1,'Retail Sale Id 146',3320.00,0.00,0.00,5.00,285.00,'2022-05-22 10:55:52','',''),(145,'1','273','1',1,'Retail Sale Id 147',12995.20,0.00,0.00,20.96,272.48,'2022-05-22 11:19:44','',''),(146,'1','273','1',1,'Retail Sale Id 148',1992.00,0.00,0.00,3.00,171.00,'2022-05-22 11:44:57','',''),(147,'1','273','1',1,'Retail Sale Id 149',5312.00,0.00,0.00,8.00,456.00,'2022-05-22 11:49:10','',''),(148,'1','273','1',1,'Retail Sale Id 150',2503.28,0.00,0.00,3.77,214.89,'2022-05-22 11:58:00','',''),(149,'1','273','1',1,'Retail Sale Id 151',1992.00,0.00,0.00,3.00,171.00,'2022-05-22 12:06:48','',''),(150,'1','273','1',1,'Retail Sale Id 151',5312.00,0.00,0.00,8.00,456.00,'2022-05-22 12:06:48','',''),(151,'1','273','1',1,'Retail Sale Id 151',7968.00,0.00,0.00,12.00,684.00,'2022-05-22 12:06:48','',''),(152,'1','273','1',1,'Retail Sale Id 152',8300.00,0.00,0.00,12.50,712.50,'2022-05-22 12:09:45','',''),(153,'1','273','1',1,'Return of Retail Sale Id 151',0.00,1992.00,3.00,0.00,-171.00,'2022-05-22 12:11:10','',''),(154,'1','273','1',1,'Return of Retail Sale Id 151',0.00,5312.00,8.00,0.00,-456.00,'2022-05-22 12:11:10','',''),(155,'1','273','1',1,'Return of Retail Sale Id 151',0.00,7968.00,12.00,0.00,-684.00,'2022-05-22 12:11:10','',''),(156,'1','273','1',1,'Retail Sale Id 153',1992.00,0.00,0.00,3.00,171.00,'2022-05-22 12:12:43','',''),(157,'1','273','1',1,'Retail Sale Id 153',3984.00,0.00,0.00,6.00,342.00,'2022-05-22 12:12:43','',''),(158,'1','273','1',1,'Retail Sale Id 153',7968.00,0.00,0.00,12.00,684.00,'2022-05-22 12:12:43','',''),(159,'1','273','1',1,'Retail Sale Id 154',1992.00,0.00,0.00,3.00,171.00,'2022-05-22 12:55:40','',''),(160,'1','273','1',1,'Retail Sale Id 155',8300.00,0.00,0.00,12.50,712.50,'2022-05-22 13:00:41','',''),(161,'1','273','1',1,'Retail Sale Id 156',1998.64,0.00,0.00,3.01,171.57,'2022-05-22 13:15:03','',''),(162,'1','273','1',1,'Retail Sale Id 157',14997.80,0.00,0.00,24.19,314.47,'2022-05-22 13:23:12','',''),(163,'1','273','1',1,'Retail Sale Id 158',6640.00,0.00,0.00,10.00,570.00,'2022-05-22 13:26:30','',''),(164,'1','273','1',1,'Retail Sale Id 159',1992.00,0.00,0.00,3.00,171.00,'2022-05-22 13:41:17','',''),(165,'1','273','1',1,'Retail Sale Id 160',1002.64,0.00,0.00,1.51,86.07,'2022-05-22 13:48:22','',''),(166,'1','273','1',1,'Retail Sale Id 161',1500.64,0.00,0.00,2.26,128.82,'2022-05-22 13:49:19','',''),(167,'1','273','1',1,'Retail Sale Id 162',1998.64,0.00,0.00,3.01,171.57,'2022-05-22 13:50:12','',''),(168,'1','273','1',1,'Retail Sale Id 163',697.20,0.00,0.00,1.05,59.85,'2022-05-22 13:51:16','',''),(169,'1','273','1',1,'Retail Sale Id 164',9960.00,0.00,0.00,15.00,855.00,'2022-05-22 13:58:14','',''),(170,'1','273','1',1,'Retail Sale Id 165',1301.44,0.00,0.00,1.96,111.72,'2022-05-22 14:14:35','',''),(171,'1','273','1',1,'Retail Sale Id 166',3997.28,0.00,0.00,6.02,343.14,'2022-05-22 14:42:36','',''),(172,'1','273','1',1,'Retail Sale Id 167',1998.64,0.00,0.00,3.01,171.57,'2022-05-22 14:44:43','',''),(173,'1','273','1',1,'Retail Sale Id 168',1002.64,0.00,0.00,1.51,86.07,'2022-05-22 14:46:15','',''),(174,'1','273','1',1,'Retail Sale Id 169',1998.64,0.00,0.00,3.01,171.57,'2022-05-22 14:51:09','',''),(175,'1','273','1',1,'Retail Sale Id 170',1321.36,0.00,0.00,1.99,113.43,'2022-05-22 15:06:12','',''),(176,'1','273','1',1,'Retail Sale Id 171',7968.00,0.00,0.00,12.00,684.00,'2022-05-22 15:50:39','',''),(177,'1','273','1',1,'Retail Sale Id 172',1699.84,0.00,0.00,2.56,145.92,'2022-05-22 15:52:29','',''),(178,'1','273','1',1,'Retail Sale Id 173',1328.00,0.00,0.00,2.00,114.00,'2022-05-22 15:54:28','',''),(179,'1','273','1',1,'Retail Sale Id 174',1899.04,0.00,0.00,2.86,163.02,'2022-05-22 15:58:56','',''),(180,'1','273','1',1,'Retail Sale Id 175',1998.64,0.00,0.00,3.01,171.57,'2022-05-22 16:15:56','',''),(181,'1','273','1',1,'Retail Sale Id 176',8300.00,0.00,0.00,12.50,712.50,'2022-05-22 16:23:51','',''),(182,'1','273','1',1,'Retail Sale Id 177',1998.64,0.00,0.00,3.01,171.57,'2022-05-22 16:29:33','',''),(183,'1','273','1',1,'Retail Sale Id 178',1002.64,0.00,0.00,1.51,86.07,'2022-05-22 16:39:07','',''),(184,'1','273','1',1,'Retail Sale Id 179',3320.00,0.00,0.00,5.00,285.00,'2022-05-22 16:45:18','',''),(185,'1','273','1',1,'Retail Sale Id 180',1998.64,0.00,0.00,3.01,171.57,'2022-05-22 16:47:10','',''),(186,'1','273','1',1,'Retail Sale Id 181',1998.64,0.00,0.00,3.01,171.57,'2022-05-22 16:49:39','',''),(187,'1','273','1',1,'Retail Sale Id 182',1002.64,0.00,0.00,1.51,86.07,'2022-05-22 17:00:19','',''),(188,'1','273','1',1,'Retail Sale Id 183',697.20,0.00,0.00,1.05,59.85,'2022-05-22 17:03:58','',''),(189,'1','273','1',1,'Retail Sale Id 184',8300.00,0.00,0.00,12.50,712.50,'2022-05-22 17:06:15','',''),(190,'1','273','1',1,'Retail Sale Id 185',3320.00,0.00,0.00,5.00,285.00,'2022-05-22 17:08:19','',''),(191,'1','273','1',1,'Retail Sale Id 186',796.80,0.00,0.00,1.20,68.40,'2022-05-22 17:12:29','',''),(192,'1','273','1',1,'Retail Sale Id 187',1301.44,0.00,0.00,1.96,111.72,'2022-05-22 17:16:47','',''),(193,'1','273','1',1,'Retail Sale Id 188',1002.64,0.00,0.00,1.51,86.07,'2022-05-22 17:22:19','',''),(194,'1','273','1',1,'Retail Sale Id 189',697.20,0.00,0.00,1.05,59.85,'2022-05-22 17:38:40','',''),(195,'1','273','1',1,'Retail Sale Id 190',1998.64,0.00,0.00,3.01,171.57,'2022-05-22 17:42:21','',''),(196,'1','273','1',1,'Retail Sale Id 191',664.00,0.00,0.00,1.00,57.00,'2022-05-22 18:44:49','',''),(197,'1','273','1',1,'Retail Sale Id 192',1998.64,0.00,0.00,3.01,171.57,'2022-05-23 07:37:59','',''),(198,'1','273','1',1,'Retail Sale Id 193',3001.28,0.00,0.00,4.52,257.64,'2022-05-23 07:38:38','',''),(199,'1','273','1',1,'Retail Sale Id 194',4648.00,0.00,0.00,7.00,399.00,'2022-05-23 07:55:23','',''),(200,'1','273','1',1,'Retail Sale Id 195',8300.00,0.00,0.00,12.50,712.50,'2022-05-23 08:01:35','',''),(201,'1','273','1',1,'Retail Sale Id 196',2656.00,0.00,0.00,4.00,228.00,'2022-05-23 08:02:20','',''),(202,'1','273','1',1,'Retail Sale Id 197',1301.44,0.00,0.00,1.96,111.72,'2022-05-23 08:14:18','',''),(203,'1','273','1',1,'Retail Sale Id 199',6640.00,0.00,0.00,10.00,570.00,'2022-05-23 08:25:56','',''),(204,'1','273','1',1,'Retail Sale Id 200',1500.64,0.00,0.00,2.26,128.82,'2022-05-23 08:29:16','',''),(205,'1','273','1',1,'Retail Sale Id 201',3984.00,0.00,0.00,6.00,342.00,'2022-05-23 08:41:06','',''),(206,'1','273','1',1,'Retail Sale Id 202',1799.44,0.00,0.00,2.71,154.47,'2022-05-23 08:54:25','',''),(207,'1','273','1',1,'Retail Sale Id 203',1998.64,0.00,0.00,3.01,171.57,'2022-05-23 08:55:37','',''),(208,'1','273','1',1,'Retail Sale Id 205',7968.00,0.00,0.00,12.00,684.00,'2022-05-23 09:07:14','',''),(209,'1','273','1',1,'Retail Sale Id 205',8300.00,0.00,0.00,12.50,712.50,'2022-05-23 09:07:14','',''),(210,'1','273','1',1,'Retail Sale Id 206',8300.00,0.00,0.00,12.50,712.50,'2022-05-23 09:10:04','',''),(211,'1','273','1',1,'Retail Sale Id 207',1002.64,0.00,0.00,1.51,86.07,'2022-05-23 09:39:06','',''),(212,'1','273','1',1,'Retail Sale Id 208',6640.00,0.00,0.00,10.00,570.00,'2022-05-23 10:01:08','',''),(213,'1','273','1',1,'Retail Sale Id 209',1002.64,0.00,0.00,1.51,86.07,'2022-05-23 10:20:02','',''),(214,'1','273','1',1,'Retail Sale Id 210',1328.00,0.00,0.00,2.00,114.00,'2022-05-23 10:50:19','',''),(215,'1','273','1',1,'Retail Sale Id 213',7350.48,0.00,0.00,11.07,630.99,'2022-05-23 11:12:24','',''),(216,'1','273','1',1,'Retail Sale Id 214',31000.00,0.00,0.00,50.00,650.00,'2022-05-23 15:15:12','',''),(217,'1','273','1',1,'Retail Sale Id 215',62000.00,0.00,0.00,100.00,1300.00,'2022-05-23 15:16:13','',''),(218,'1','273','1',1,'Retail Sale Id 216',1992.00,0.00,0.00,3.00,171.00,'2022-05-23 15:17:06','',''),(219,'1','273','1',1,'Retail Sale Id 217',1002.64,0.00,0.00,1.51,86.07,'2022-05-23 15:44:38','',''),(220,'1','273','1',1,'Retail Sale Id 218',697.20,0.00,0.00,1.05,59.85,'2022-05-23 15:46:09','',''),(221,'1','273','1',1,'Retail Sale Id 219',697.20,0.00,0.00,1.05,59.85,'2022-05-23 16:06:07','',''),(222,'1','273','1',1,'Retail Sale Id 220',1328.00,0.00,0.00,2.00,114.00,'2022-05-23 16:07:22','',''),(223,'1','273','1',1,'Retail Sale Id 221',7968.00,0.00,0.00,12.00,684.00,'2022-05-23 16:08:24','',''),(224,'1','273','1',1,'Retail Sale Id 222',1002.64,0.00,0.00,1.51,86.07,'2022-05-23 16:10:29','',''),(225,'1','273','1',1,'Retail Sale Id 223',697.20,0.00,0.00,1.05,59.85,'2022-05-23 16:12:06','',''),(226,'1','273','1',1,'Retail Sale Id 224',1002.64,0.00,0.00,1.51,86.07,'2022-05-24 06:45:43','',''),(227,'1','273','1',1,'Retail Sale Id 225',1992.00,0.00,0.00,3.00,171.00,'2022-05-24 07:19:19','',''),(228,'1','273','1',1,'Retail Sale Id 226',3320.00,0.00,0.00,5.00,285.00,'2022-05-24 07:30:25','',''),(229,'1','273','1',1,'Return of Retail Sale Id 225',0.00,1992.00,3.00,0.00,-171.00,'2022-05-24 07:32:45','',''),(230,'1','273','1',1,'Retail Sale Id 227',1992.00,0.00,0.00,3.00,171.00,'2022-05-24 07:33:46','',''),(231,'1','273','1',1,'Retail Sale Id 228',1201.84,0.00,0.00,1.81,103.17,'2022-05-24 07:39:33','',''),(232,'1','273','1',1,'Retail Sale Id 229',1002.64,0.00,0.00,1.51,86.07,'2022-05-24 07:42:15','',''),(233,'1','273','1',1,'Retail Sale Id 230',1992.00,0.00,0.00,3.00,171.00,'2022-05-24 07:46:18','',''),(234,'1','273','1',1,'Return of Retail Sale Id 230',0.00,1992.00,3.00,0.00,-171.00,'2022-05-24 07:48:50','',''),(235,'1','273','1',1,'Retail Sale Id 231',1998.64,0.00,0.00,3.01,171.57,'2022-05-24 07:49:18','',''),(236,'1','273','1',1,'Retail Sale Id 232',1998.64,0.00,0.00,3.01,171.57,'2022-05-24 07:54:14','',''),(237,'1','273','1',1,'Retail Sale Id 233',2656.00,0.00,0.00,4.00,228.00,'2022-05-24 08:06:13','',''),(238,'1','273','1',1,'Retail Sale Id 234',9960.00,0.00,0.00,15.00,855.00,'2022-05-24 08:10:53','',''),(239,'1','273','1',1,'Retail Sale Id 235',8300.00,0.00,0.00,12.50,712.50,'2022-05-24 08:14:00','',''),(240,'1','273','1',1,'Retail Sale Id 236',1328.00,0.00,0.00,2.00,114.00,'2022-05-24 08:16:34','',''),(241,'1','273','1',1,'Retail Sale Id 237',31000.00,0.00,0.00,50.00,650.00,'2022-05-24 08:44:30','',''),(242,'1','273','1',1,'Retail Sale Id 238',3320.00,0.00,0.00,5.00,285.00,'2022-05-24 08:50:03','',''),(243,'1','273','1',1,'Retail Sale Id 239',4999.92,0.00,0.00,7.53,429.21,'2022-05-24 08:51:37','',''),(244,'1','273','1',1,'Retail Sale Id 240',8300.00,0.00,0.00,12.50,712.50,'2022-05-24 09:01:44','',''),(245,'1','273','1',1,'Retail Sale Id 241',78740.00,0.00,0.00,127.00,1651.00,'2022-05-24 09:12:00','',''),(246,'1','273','1',1,'Retail Sale Id 242',77500.00,0.00,0.00,125.00,1625.00,'2022-05-24 09:16:04','',''),(247,'1','273','1',1,'Retail Sale Id 243',1328.00,0.00,0.00,2.00,114.00,'2022-05-24 09:22:28','',''),(248,'1','273','1',1,'Retail Sale Id 244',8300.00,0.00,0.00,12.50,712.50,'2022-05-24 09:24:00','',''),(249,'1','273','1',1,'Retail Sale Id 245',145700.00,0.00,0.00,235.00,3055.00,'2022-05-24 09:35:17','',''),(250,'1','273','1',1,'Retail Sale Id 246',710.48,0.00,0.00,1.07,60.99,'2022-05-24 09:36:21','',''),(251,'1','273','1',1,'Retail Sale Id 247',1002.64,0.00,0.00,1.51,86.07,'2022-05-24 09:46:33','',''),(252,'1','273','1',1,'Retail Sale Id 248',664.00,0.00,0.00,1.00,57.00,'2022-05-24 09:55:24','',''),(253,'1','273','1',1,'Return of Retail Sale Id 248',0.00,664.00,1.00,0.00,-57.00,'2022-05-24 09:56:55','',''),(254,'1','273','1',1,'Retail Sale Id 249',697.20,0.00,0.00,1.05,59.85,'2022-05-24 09:57:21','',''),(255,'1','273','1',1,'Return of Retail Sale Id 245',0.00,145700.00,235.00,0.00,-3055.00,'2022-05-24 09:58:59','',''),(256,'1','273','1',1,'Retail Sale Id 250',83700.00,0.00,0.00,135.00,1755.00,'2022-05-24 10:01:00','',''),(257,'1','273','1',1,'Retail Sale Id 251',62000.00,0.00,0.00,100.00,1300.00,'2022-05-24 10:01:53','',''),(258,'1','273','1',1,'Retail Sale Id 252',14999.76,0.00,0.00,22.59,1287.63,'2022-05-24 10:07:23','',''),(259,'1','273','1',1,'Retail Sale Id 253',6002.56,0.00,0.00,9.04,515.28,'2022-05-24 10:08:51','',''),(260,'1','273','1',1,'Retail Sale Id 254',796.80,0.00,0.00,1.20,68.40,'2022-05-24 10:30:50','',''),(261,'1','273','1',1,'Retail Sale Id 254',1899.04,0.00,0.00,2.86,163.02,'2022-05-24 10:30:50','',''),(262,'1','273','1',1,'Retail Sale Id 255',1992.00,0.00,0.00,3.00,171.00,'2022-05-24 10:33:13','',''),(263,'1','273','1',1,'Retail Sale Id 256',697.20,0.00,0.00,1.05,59.85,'2022-05-24 10:34:00','',''),(264,'1','273','1',1,'Retail Sale Id 257',1992.00,0.00,0.00,3.00,171.00,'2022-05-24 10:50:00','',''),(265,'1','273','1',1,'Retail Sale Id 258',1002.64,0.00,0.00,1.51,86.07,'2022-05-24 10:52:56','',''),(266,'1','273','1',1,'Retail Sale Id 259',8001.20,0.00,0.00,12.05,686.85,'2022-05-24 10:54:29','',''),(267,'1','273','1',1,'Retail Sale Id 260',1992.00,0.00,0.00,3.00,171.00,'2022-05-24 10:56:19','',''),(268,'1','273','1',1,'Return of Retail Sale Id 260',0.00,1992.00,3.00,0.00,-171.00,'2022-05-24 10:57:44','',''),(269,'1','273','1',1,'Retail Sale Id 261',1201.84,0.00,0.00,1.81,103.17,'2022-05-24 10:58:58','',''),(270,'1','273','1',1,'Retail Sale Id 262',796.80,0.00,0.00,1.20,68.40,'2022-05-24 11:00:15','',''),(271,'1','273','1',1,'Return of Retail Sale Id 261',0.00,1201.84,1.81,0.00,-103.17,'2022-05-24 11:04:25','',''),(272,'1','273','1',1,'Retail Sale Id 263',1201.84,0.00,0.00,1.81,103.17,'2022-05-24 11:04:59','',''),(273,'1','273','1',1,'Retail Sale Id 264',1998.64,0.00,0.00,3.01,171.57,'2022-05-24 11:11:29','',''),(274,'1','273','1',1,'Retail Sale Id 265',1002.64,0.00,0.00,1.51,86.07,'2022-05-24 11:37:02','',''),(275,'1','273','1',1,'Retail Sale Id 266',697.20,0.00,0.00,1.05,59.85,'2022-05-24 12:10:42','',''),(276,'1','273','1',1,'Retail Sale Id 267',1998.64,0.00,0.00,3.01,171.57,'2022-05-24 12:25:22','',''),(277,'1','273','1',1,'Retail Sale Id 268',796.80,0.00,0.00,1.20,68.40,'2022-05-24 13:11:13','',''),(278,'1','273','1',1,'Retail Sale Id 269',31000.00,0.00,0.00,50.00,650.00,'2022-05-24 13:32:02','',''),(279,'1','273','1',1,'Retail Sale Id 270',29760.00,0.00,0.00,620.00,-346580.00,'2022-05-24 13:32:46','',''),(280,'1','273','1',1,'Return of Retail Sale Id 270',0.00,29760.00,620.00,0.00,346580.00,'2022-05-24 13:38:29','',''),(281,'1','273','1',1,'Retail Sale Id 271',29760.00,0.00,0.00,48.00,624.00,'2022-05-24 13:39:04','',''),(282,'1','273','1',1,'Retail Sale Id 272',697.20,0.00,0.00,1.05,59.85,'2022-05-24 13:45:19','',''),(283,'1','273','1',1,'Retail Sale Id 273',4648.00,0.00,0.00,7.00,399.00,'2022-05-24 14:05:48','',''),(284,'1','273','1',1,'Retail Sale Id 274',8300.00,0.00,0.00,12.50,712.50,'2022-05-24 14:39:19','',''),(285,'1','273','1',1,'Retail Sale Id 279',1500.64,0.00,0.00,2.26,128.82,'2022-05-24 15:19:01','',''),(286,'1','273','1',1,'Retail Sale Id 280',1002.64,0.00,0.00,1.51,86.07,'2022-05-24 15:33:27','',''),(287,'1','273','1',1,'Retail Sale Id 281',2503.28,0.00,0.00,3.77,214.89,'2022-05-24 15:41:25','',''),(288,'1','273','1',1,'Retail Sale Id 282',650.72,0.00,0.00,0.98,55.86,'2022-05-24 15:55:12','',''),(289,'1','273','1',1,'Retail Sale Id 283',1998.64,0.00,0.00,3.01,171.57,'2022-05-24 15:56:52','',''),(290,'1','273','1',1,'Retail Sale Id 284',1998.64,0.00,0.00,3.01,171.57,'2022-05-24 16:05:29','',''),(291,'1','273','1',1,'Retail Sale Id 285',3984.00,0.00,0.00,6.00,342.00,'2022-05-24 16:08:42','',''),(292,'1','273','1',1,'Retail Sale Id 286',91140.00,0.00,0.00,147.00,1911.00,'2022-05-24 16:30:35','',''),(293,'1','273','1',1,'Retail Sale Id 287',650.72,0.00,0.00,0.98,55.86,'2022-05-24 16:31:50','',''),(294,'1','273','1',1,'Retail Sale Id 288',60760.00,0.00,0.00,98.00,1274.00,'2022-05-24 16:33:02','',''),(295,'1','273','1',1,'Retail Sale Id 289',1002.64,0.00,0.00,1.51,86.07,'2022-05-24 16:33:58','',''),(296,'1','273','1',1,'Retail Sale Id 292',3001.28,0.00,0.00,4.52,257.64,'2022-05-24 16:54:15','',''),(297,'1','273','1',1,'Retail Sale Id 293',3997.28,0.00,0.00,6.02,343.14,'2022-05-24 16:55:37','',''),(298,'1','273','1',1,'Retail Sale Id 294',8300.00,0.00,0.00,12.50,712.50,'2022-05-24 17:07:09','',''),(299,'1','273','1',1,'Retail Sale Id 295',8300.00,0.00,0.00,12.50,712.50,'2022-05-24 17:09:32','',''),(300,'1','273','1',1,'Retail Sale Id 296',11288.00,0.00,0.00,17.00,969.00,'2022-05-24 17:12:59','',''),(301,'1','273','1',1,'Retail Sale Id 297',8632.00,0.00,0.00,13.00,741.00,'2022-05-24 17:15:16','',''),(302,'1','273','1',1,'Retail Sale Id 298',1401.04,0.00,0.00,2.11,120.27,'2022-05-24 17:30:19','',''),(303,'1','273','1',1,'Retail Sale Id 299',124000.00,0.00,0.00,200.00,2600.00,'2022-05-24 17:35:17','',''),(304,'1','273','1',1,'Retail Sale Id 300',62000.00,0.00,0.00,100.00,1300.00,'2022-05-24 17:37:08','',''),(305,'1','273','1',1,'Retail Sale Id 301',1998.64,0.00,0.00,3.01,171.57,'2022-05-24 17:40:07','',''),(306,'1','273','1',1,'Retail Sale Id 303',3997.28,0.00,0.00,6.02,343.14,'2022-05-24 17:42:30','',''),(307,'1','273','1',1,'Retail Sale Id 304',6640.00,0.00,0.00,10.00,570.00,'2022-05-24 17:44:17','',''),(308,'1','273','1',1,'Retail Sale Id 305',1998.64,0.00,0.00,3.01,171.57,'2022-05-24 17:54:12','',''),(309,'1','273','1',1,'Retail Sale Id 306',43400.00,0.00,0.00,70.00,910.00,'2022-05-24 17:55:55','',''),(310,'1','273','1',1,'Retail Sale Id 307',37200.00,0.00,0.00,60.00,780.00,'2022-05-24 17:57:03','',''),(311,'1','273','1',1,'Retail Sale Id 308',697.20,0.00,0.00,1.05,59.85,'2022-05-24 18:22:04','',''),(312,'1','273','1',1,'Retail Sale Id 309',1002.64,0.00,0.00,1.51,86.07,'2022-05-24 18:22:49','',''),(313,'1','273','1',1,'Retail Sale Id 310',1201.84,0.00,0.00,1.81,103.17,'2022-05-24 18:23:34','',''),(314,'1','273','1',1,'Retail Sale Id 311',8300.00,0.00,0.00,12.50,712.50,'2022-05-24 18:24:25','',''),(315,'1','273','1',1,'Retail Sale Id 313',650.72,0.00,0.00,0.98,55.86,'2022-05-24 18:25:19','',''),(316,'1','273','1',1,'Retail Sale Id 314',1328.00,0.00,0.00,2.00,114.00,'2022-05-24 18:26:26','',''),(317,'1','273','1',1,'Retail Sale Id 315',7968.00,0.00,0.00,12.00,684.00,'2022-05-24 18:28:13','',''),(318,'1','273','1',1,'Retail Sale Id 316',650.72,0.00,0.00,0.98,55.86,'2022-05-24 18:32:15','',''),(319,'1','273','1',1,'Retail Sale Id 317',5976.00,0.00,0.00,9.00,513.00,'2022-05-24 18:34:29','',''),(320,'1','273','1',1,'Retail Sale Id 318',1500.64,0.00,0.00,2.26,128.82,'2022-05-24 18:36:11','',''),(321,'1','273','1',1,'Retail Sale Id 319',2702.48,0.00,0.00,4.07,231.99,'2022-05-24 18:37:26','',''),(322,'1','273','1',1,'Retail Sale Id 320',3001.28,0.00,0.00,4.52,257.64,'2022-05-24 18:51:25','',''),(323,'1','273','1',1,'Retail Sale Id 322',1135.44,0.00,0.00,1.71,97.47,'2022-05-24 20:10:53','',''),(324,'1','273','1',1,'Retail Sale Id 323',7045.04,0.00,0.00,10.61,604.77,'2022-05-24 20:12:51','',''),(325,'1','273','1',1,'Retail Sale Id 324',7304.00,0.00,0.00,11.00,627.00,'2022-05-25 07:08:56','',''),(326,'1','273','1',1,'Retail Sale Id 325',34100.00,0.00,0.00,55.00,715.00,'2022-05-25 07:13:04','',''),(327,'1','273','1',1,'Retail Sale Id 326',24800.00,0.00,0.00,40.00,520.00,'2022-05-25 07:14:07','',''),(328,'1','273','1',1,'Retail Sale Id 328',1301.44,0.00,0.00,1.96,111.72,'2022-05-25 07:16:54','',''),(329,'1','273','1',1,'Retail Sale Id 329',1347.92,0.00,0.00,2.03,115.71,'2022-05-25 07:18:12','',''),(330,'1','273','1',1,'Retail Sale Id 330',1998.64,0.00,0.00,3.01,171.57,'2022-05-25 07:24:02','',''),(331,'1','273','1',1,'Retail Sale Id 331',1998.64,0.00,0.00,3.01,171.57,'2022-05-25 07:25:28','',''),(332,'1','273','1',1,'Retail Sale Id 332',697.20,0.00,0.00,1.05,59.85,'2022-05-25 07:29:58','',''),(333,'1','273','1',1,'Retail Sale Id 333',2503.28,0.00,0.00,3.77,214.89,'2022-05-25 07:30:53','',''),(334,'1','273','1',1,'Retail Sale Id 334',697.20,0.00,0.00,1.05,59.85,'2022-05-25 07:34:36','',''),(335,'1','273','1',1,'Retail Sale Id 335',31000.00,0.00,0.00,50.00,650.00,'2022-05-25 07:41:56','',''),(336,'1','273','1',1,'Retail Sale Id 336',3001.28,0.00,0.00,4.52,257.64,'2022-05-25 07:43:19','',''),(337,'1','273','1',1,'Retail Sale Id 337',3997.28,0.00,0.00,6.02,343.14,'2022-05-25 07:49:36','',''),(338,'1','273','1',1,'Retail Sale Id 338',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 07:53:57','',''),(339,'1','273','1',1,'Retail Sale Id 339',1998.64,0.00,0.00,3.01,171.57,'2022-05-25 07:54:54','',''),(340,'1','273','1',1,'Retail Sale Id 340',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 08:17:22','',''),(341,'1','273','1',1,'Retail Sale Id 341',3984.00,0.00,0.00,6.00,342.00,'2022-05-25 08:25:15','',''),(342,'1','273','1',1,'Retail Sale Id 342',3984.00,0.00,0.00,6.00,342.00,'2022-05-25 08:41:45','',''),(343,'1','273','1',1,'Retail Sale Id 343',2656.00,0.00,0.00,4.00,228.00,'2022-05-25 08:44:20','',''),(344,'1','273','1',1,'Retail Sale Id 344',1500.64,0.00,0.00,2.26,128.82,'2022-05-25 08:49:18','',''),(345,'1','273','1',1,'Retail Sale Id 345',1002.64,0.00,0.00,1.51,86.07,'2022-05-25 08:59:03','',''),(346,'1','273','1',1,'Retail Sale Id 346',1998.64,0.00,0.00,3.01,171.57,'2022-05-25 09:01:43','',''),(347,'1','273','1',1,'Retail Sale Id 347',796.80,0.00,0.00,1.20,68.40,'2022-05-25 09:03:17','',''),(348,'1','273','1',1,'Retail Sale Id 348',4501.92,0.00,0.00,6.78,386.46,'2022-05-25 09:16:03','',''),(349,'1','273','1',1,'Retail Sale Id 349',62000.00,0.00,0.00,100.00,1300.00,'2022-05-25 09:25:44','',''),(350,'1','273','1',1,'Retail Sale Id 350',31000.00,0.00,0.00,50.00,650.00,'2022-05-25 09:26:46','',''),(351,'1','273','1',1,'Retail Sale Id 351',68200.00,0.00,0.00,110.00,1430.00,'2022-05-25 09:34:00','',''),(352,'1','273','1',1,'Retail Sale Id 352',41850.00,0.00,0.00,67.50,877.50,'2022-05-25 09:34:54','',''),(353,'1','273','1',1,'Retail Sale Id 353',2503.28,0.00,0.00,3.77,214.89,'2022-05-25 09:36:43','',''),(354,'1','273','1',1,'Retail Sale Id 354',1328.00,0.00,0.00,2.00,114.00,'2022-05-25 09:39:02','',''),(355,'1','273','1',1,'Retail Sale Id 355',1998.64,0.00,0.00,3.01,171.57,'2022-05-25 09:40:43','',''),(356,'1','273','1',1,'Retail Sale Id 356',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 10:04:23','',''),(357,'1','273','1',1,'Retail Sale Id 358',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 10:10:44','',''),(358,'1','273','1',1,'Retail Sale Id 359',58280.00,0.00,0.00,94.00,1222.00,'2022-05-25 10:15:26','',''),(359,'1','273','1',1,'Retail Sale Id 360',1998.64,0.00,0.00,3.01,171.57,'2022-05-25 10:16:47','',''),(360,'1','273','1',1,'Retail Sale Id 361',68200.00,0.00,0.00,110.00,1430.00,'2022-05-25 10:18:23','',''),(361,'1','273','1',1,'Retail Sale Id 362',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 10:27:04','',''),(362,'1','273','1',1,'Retail Sale Id 363',124000.00,0.00,0.00,200.00,2600.00,'2022-05-25 10:32:40','',''),(363,'1','273','1',1,'Retail Sale Id 364',124000.00,0.00,0.00,200.00,2600.00,'2022-05-25 10:33:32','',''),(364,'1','273','1',1,'Return of Retail Sale Id 361',0.00,68200.00,110.00,0.00,-1430.00,'2022-05-25 10:34:43','',''),(365,'1','273','1',1,'Retail Sale Id 365',34100.00,0.00,0.00,55.00,715.00,'2022-05-25 10:35:26','',''),(366,'1','273','1',1,'Retail Sale Id 366',34100.00,0.00,0.00,55.00,715.00,'2022-05-25 10:36:20','',''),(367,'1','273','1',1,'Retail Sale Id 367',1992.00,0.00,0.00,3.00,171.00,'2022-05-25 10:54:35','',''),(368,'1','273','1',1,'Retail Sale Id 367',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 10:54:35','',''),(369,'1','273','1',1,'Retail Sale Id 368',148800.00,0.00,0.00,240.00,3120.00,'2022-05-25 11:01:26','',''),(370,'1','273','1',1,'Retail Sale Id 369',38750.00,0.00,0.00,62.50,812.50,'2022-05-25 11:02:37','',''),(371,'1','273','1',1,'Retail Sale Id 370',1002.64,0.00,0.00,1.51,86.07,'2022-05-25 11:08:08','',''),(372,'1','273','1',1,'Retail Sale Id 371',186000.00,0.00,0.00,300.00,3900.00,'2022-05-25 11:18:23','',''),(373,'1','273','1',1,'Retail Sale Id 372',186000.00,0.00,0.00,300.00,3900.00,'2022-05-25 11:19:19','',''),(374,'1','273','1',1,'Retail Sale Id 373',124000.00,0.00,0.00,200.00,2600.00,'2022-05-25 11:36:07','',''),(375,'1','273','1',1,'Retail Sale Id 374',3320.00,0.00,0.00,5.00,285.00,'2022-05-25 11:37:24','',''),(376,'1','273','1',1,'Retail Sale Id 375',1998.64,0.00,0.00,3.01,171.57,'2022-05-25 11:38:29','',''),(377,'1','273','1',1,'Retail Sale Id 376',108500.00,0.00,0.00,175.00,2275.00,'2022-05-25 11:39:38','',''),(378,'1','273','1',1,'Retail Sale Id 377',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 12:03:53','',''),(379,'1','273','1',1,'Retail Sale Id 378',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 12:09:15','',''),(380,'1','273','1',1,'Retail Sale Id 379',62000.00,0.00,0.00,100.00,1300.00,'2022-05-25 12:17:38','',''),(381,'1','273','1',1,'Retail Sale Id 380',6640.00,0.00,0.00,10.00,570.00,'2022-05-25 12:30:07','',''),(382,'1','273','1',1,'Retail Sale Id 381',62000.00,0.00,0.00,100.00,1300.00,'2022-05-25 12:53:22','',''),(383,'1','273','1',1,'Retail Sale Id 382',31000.00,0.00,0.00,50.00,650.00,'2022-05-25 12:53:54','',''),(384,'1','273','1',1,'Retail Sale Id 383',3320.00,0.00,0.00,5.00,285.00,'2022-05-25 13:30:45','',''),(385,'1','273','1',1,'Retail Sale Id 384',1998.64,0.00,0.00,3.01,171.57,'2022-05-25 13:33:38','',''),(386,'1','273','1',1,'Retail Sale Id 385',36580.00,0.00,0.00,59.00,767.00,'2022-05-25 13:37:00','',''),(387,'1','273','1',1,'Retail Sale Id 386',36580.00,0.00,0.00,59.00,767.00,'2022-05-25 13:37:55','',''),(388,'1','273','1',1,'Retail Sale Id 387',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 13:45:15','',''),(389,'1','273','1',1,'Retail Sale Id 388',1301.44,0.00,0.00,1.96,111.72,'2022-05-25 13:51:11','',''),(390,'1','273','1',1,'Retail Sale Id 389',1328.00,0.00,0.00,2.00,114.00,'2022-05-25 14:39:08','',''),(391,'1','273','1',1,'Retail Sale Id 390',650.72,0.00,0.00,0.98,55.86,'2022-05-25 14:46:23','',''),(392,'1','273','1',1,'Retail Sale Id 391',1347.92,0.00,0.00,2.03,115.71,'2022-05-25 15:15:07','',''),(393,'1','273','1',1,'Retail Sale Id 392',16600.00,0.00,0.00,25.00,1425.00,'2022-05-25 15:33:57','',''),(394,'1','273','1',1,'Retail Sale Id 393',1002.64,0.00,0.00,1.51,86.07,'2022-05-25 15:36:48','',''),(395,'1','273','1',1,'Retail Sale Id 394',31000.00,0.00,0.00,50.00,650.00,'2022-05-25 15:37:41','',''),(396,'1','273','1',1,'Retail Sale Id 395',3997.28,0.00,0.00,6.02,343.14,'2022-05-25 15:48:36','',''),(397,'1','273','1',1,'Retail Sale Id 396',1699.84,0.00,0.00,2.56,145.92,'2022-05-25 15:49:53','',''),(398,'1','273','1',1,'Retail Sale Id 397',3320.00,0.00,0.00,5.00,285.00,'2022-05-25 15:50:50','',''),(399,'1','273','1',1,'Retail Sale Id 398',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 15:54:42','',''),(400,'1','273','1',1,'Retail Sale Id 399',6002.56,0.00,0.00,9.04,515.28,'2022-05-25 15:58:34','',''),(401,'1','273','1',1,'Retail Sale Id 400',3320.00,0.00,0.00,5.00,285.00,'2022-05-25 15:59:48','',''),(402,'1','273','1',1,'Retail Sale Id 402',1301.44,0.00,0.00,1.96,111.72,'2022-05-25 16:02:50','',''),(403,'1','273','1',1,'Retail Sale Id 403',2656.00,0.00,0.00,4.00,228.00,'2022-05-25 16:05:09','',''),(404,'1','273','1',1,'Retail Sale Id 404',1002.64,0.00,0.00,1.51,86.07,'2022-05-25 16:15:35','',''),(405,'1','273','1',1,'Retail Sale Id 405',1998.64,0.00,0.00,3.01,171.57,'2022-05-25 16:19:04','',''),(406,'1','273','1',1,'Retail Sale Id 406',1998.64,0.00,0.00,3.01,171.57,'2022-05-25 16:24:01','',''),(407,'1','273','1',1,'Retail Sale Id 407',22320.00,0.00,0.00,36.00,468.00,'2022-05-25 16:30:25','',''),(408,'1','273','1',1,'Retail Sale Id 408',8300.00,0.00,0.00,12.50,712.50,'2022-05-25 16:42:33','',''),(409,'1','273','1',1,'Retail Sale Id 409',3320.00,0.00,0.00,5.00,285.00,'2022-05-25 16:44:00','',''),(410,'1','273','1',1,'Retail Sale Id 410',650.72,0.00,0.00,0.98,55.86,'2022-05-25 16:46:57','',''),(411,'1','273','1',1,'Retail Sale Id 411',3320.00,0.00,0.00,5.00,285.00,'2022-05-25 16:55:04','',''),(412,'1','273','1',1,'Return of Retail Sale Id 411',0.00,3320.00,5.00,0.00,-285.00,'2022-05-25 16:55:53','',''),(413,'1','273','1',1,'Retail Sale Id 412',2656.00,0.00,0.00,4.00,228.00,'2022-05-25 16:56:40','',''),(414,'1','273','1',1,'Retail Sale Id 413',1500.64,0.00,0.00,2.26,128.82,'2022-05-25 16:59:00','',''),(415,'1','273','1',1,'Retail Sale Id 414',1328.00,0.00,0.00,2.00,114.00,'2022-05-25 17:10:28','',''),(416,'1','273','1',1,'Retail Sale Id 415',796.80,0.00,0.00,1.20,68.40,'2022-05-25 17:20:02','',''),(417,'1','273','1',1,'Retail Sale Id 416',1500.64,0.00,0.00,2.26,128.82,'2022-05-25 17:26:25','',''),(418,'1','273','1',1,'Retail Sale Id 417',1002.64,0.00,0.00,1.51,86.07,'2022-05-25 17:28:41','',''),(419,'1','273','1',1,'Retail Sale Id 418',5312.00,0.00,0.00,8.00,456.00,'2022-05-25 17:36:40','',''),(420,'1','273','1',1,'Retail Sale Id 419',3320.00,0.00,0.00,5.00,285.00,'2022-05-25 17:42:08','',''),(421,'1','273','1',1,'Retail Sale Id 420',1347.92,0.00,0.00,2.03,115.71,'2022-05-25 17:45:07','',''),(422,'1','273','1',1,'Retail Sale Id 421',6002.56,0.00,0.00,9.04,515.28,'2022-05-25 17:52:26','',''),(423,'1','273','1',1,'Retail Sale Id 422',1002.64,0.00,0.00,1.51,86.07,'2022-05-26 06:32:21','',''),(424,'1','273','1',1,'Retail Sale Id 423',1002.64,0.00,0.00,1.51,86.07,'2022-05-26 06:51:00','',''),(425,'1','273','1',1,'Retail Sale Id 424',1500.64,0.00,0.00,2.26,128.82,'2022-05-26 06:52:05','',''),(426,'1','273','1',1,'Retail Sale Id 425',3320.00,0.00,0.00,5.00,285.00,'2022-05-26 06:56:14','',''),(427,'1','273','1',1,'Retail Sale Id 427',1328.00,0.00,0.00,2.00,114.00,'2022-05-26 07:04:51','',''),(428,'1','273','1',1,'Retail Sale Id 428',31000.00,0.00,0.00,50.00,650.00,'2022-05-26 07:08:05','',''),(429,'1','273','1',1,'Retail Sale Id 429',2702.48,0.00,0.00,4.07,231.99,'2022-05-26 07:32:45','',''),(430,'1','273','1',1,'Retail Sale Id 430',1002.64,0.00,0.00,1.51,86.07,'2022-05-26 07:37:37','',''),(431,'1','273','1',1,'Retail Sale Id 431',8300.00,0.00,0.00,12.50,712.50,'2022-05-26 07:39:12','',''),(432,'1','273','1',1,'Retail Sale Id 432',13999.60,0.00,0.00,22.58,293.54,'2022-05-26 07:43:43','',''),(433,'1','273','1',1,'Retail Sale Id 433',31000.00,0.00,0.00,50.00,650.00,'2022-05-26 07:56:01','',''),(434,'1','273','1',1,'Retail Sale Id 434',1998.64,0.00,0.00,3.01,171.57,'2022-05-26 08:00:47','',''),(435,'1','273','1',1,'Retail Sale Id 435',3997.28,0.00,0.00,6.02,343.14,'2022-05-26 08:01:39','',''),(436,'1','273','1',1,'Retail Sale Id 436',62000.00,0.00,0.00,100.00,1300.00,'2022-05-26 08:06:34','',''),(437,'1','273','1',1,'Retail Sale Id 437',96100.00,0.00,0.00,155.00,2015.00,'2022-05-26 08:07:39','',''),(438,'1','273','1',1,'Retail Sale Id 438',1347.92,0.00,0.00,2.03,115.71,'2022-05-26 08:14:02','',''),(439,'1','273','1',1,'Retail Sale Id 439',3984.00,0.00,0.00,6.00,342.00,'2022-05-26 08:19:57','',''),(440,'1','273','1',1,'Retail Sale Id 440',1998.64,0.00,0.00,3.01,171.57,'2022-05-26 08:30:01','',''),(441,'1','273','1',1,'Retail Sale Id 441',1998.64,0.00,0.00,3.01,171.57,'2022-05-26 08:33:20','',''),(442,'1','273','1',1,'Retail Sale Id 442',2656.00,0.00,0.00,4.00,228.00,'2022-05-26 09:02:31','',''),(443,'1','273','1',1,'Retail Sale Id 443',796.80,0.00,0.00,1.20,68.40,'2022-05-26 09:18:07','',''),(444,'1','273','1',1,'Retail Sale Id 444',8300.00,0.00,0.00,12.50,712.50,'2022-05-26 09:29:36','',''),(445,'1','273','1',1,'Retail Sale Id 445',31000.00,0.00,0.00,50.00,650.00,'2022-05-26 09:37:42','',''),(446,'1','273','1',1,'Retail Sale Id 446',1002.64,0.00,0.00,1.51,86.07,'2022-05-26 09:57:01','',''),(447,'1','273','1',1,'Retail Sale Id 447',697.20,0.00,0.00,1.05,59.85,'2022-05-26 09:59:34','',''),(448,'1','273','1',1,'Retail Sale Id 448',3984.00,0.00,0.00,6.00,342.00,'2022-05-26 10:03:24','',''),(449,'1','273','1',1,'Retail Sale Id 449',1300.00,0.00,0.00,1.00,693.00,'2022-05-26 10:29:37','',''),(450,'1','273','1',1,'Return of Retail Sale Id 449',0.00,1300.00,1.00,0.00,-693.00,'2022-05-26 10:30:29','',''),(451,'1','273','1',1,'Retail Sale Id 450',1301.44,0.00,0.00,1.96,111.72,'2022-05-26 10:30:55','',''),(452,'1','273','1',1,'Retail Sale Id 451',4999.92,0.00,0.00,7.53,429.21,'2022-05-26 10:42:36','',''),(453,'1','273','1',1,'Retail Sale Id 452',43400.00,0.00,0.00,70.00,910.00,'2022-05-26 11:16:06','',''),(454,'1','273','1',1,'Retail Sale Id 453',6820.00,0.00,0.00,11.00,143.00,'2022-05-26 11:18:45','',''),(455,'1','273','1',1,'Retail Sale Id 454',38750.00,0.00,0.00,62.50,812.50,'2022-05-26 11:21:58','',''),(456,'1','273','1',1,'Retail Sale Id 455',31000.00,0.00,0.00,50.00,650.00,'2022-05-26 11:40:05','',''),(457,'1','273','1',1,'Retail Sale Id 456',3320.00,0.00,0.00,5.00,285.00,'2022-05-26 11:47:45','',''),(458,'1','273','1',1,'Retail Sale Id 456',8300.00,0.00,0.00,12.50,712.50,'2022-05-26 11:47:45','',''),(459,'1','273','1',1,'Retail Sale Id 457',3001.28,0.00,0.00,4.52,257.64,'2022-05-26 12:04:35','',''),(460,'1','273','1',1,'Retail Sale Id 458',91140.00,0.00,0.00,147.00,1911.00,'2022-05-26 12:21:40','',''),(461,'1','273','1',1,'Retail Sale Id 459',60760.00,0.00,0.00,98.00,1274.00,'2022-05-26 12:23:18','',''),(462,'1','273','1',1,'Retail Sale Id 460',31000.00,0.00,0.00,50.00,650.00,'2022-05-26 14:39:44','',''),(463,'1','273','1',1,'Retail Sale Id 462',697.20,0.00,0.00,1.05,59.85,'2022-05-26 14:41:39','',''),(464,'1','273','1',1,'Retail Sale Id 463',1500.64,0.00,0.00,2.26,128.82,'2022-05-26 15:07:04','',''),(465,'1','273','1',1,'Retail Sale Id 464',62000.00,0.00,0.00,100.00,1300.00,'2022-05-26 15:29:57','',''),(466,'1','273','1',1,'Retail Sale Id 465',44950.00,0.00,0.00,72.50,942.50,'2022-05-26 15:32:06','',''),(467,'1','273','1',1,'Retail Sale Id 467',1347.92,0.00,0.00,2.03,115.71,'2022-05-26 15:34:12','',''),(468,'1','273','1',1,'Retail Sale Id 468',1952.16,0.00,0.00,2.94,167.58,'2022-05-26 15:37:40','',''),(469,'1','273','1',1,'Retail Sale Id 469',1998.64,0.00,0.00,3.01,171.57,'2022-05-26 15:41:21','',''),(470,'1','273','1',1,'Retail Sale Id 470',1998.64,0.00,0.00,3.01,171.57,'2022-05-26 15:42:13','',''),(471,'1','273','1',1,'Retail Sale Id 471',1998.64,0.00,0.00,3.01,171.57,'2022-05-26 15:49:13','',''),(472,'1','273','1',1,'Retail Sale Id 472',1002.64,0.00,0.00,1.51,86.07,'2022-05-26 15:59:31','',''),(473,'1','273','1',1,'Retail Sale Id 473',597.60,0.00,0.00,0.90,51.30,'2022-05-26 16:10:07','',''),(474,'1','273','1',1,'Retail Sale Id 474',1347.92,0.00,0.00,2.03,115.71,'2022-05-26 16:13:26','',''),(475,'1','273','1',1,'Retail Sale Id 475',697.20,0.00,0.00,1.05,59.85,'2022-05-26 16:15:42','',''),(476,'1','273','1',1,'Retail Sale Id 476',3499.28,0.00,0.00,5.27,300.39,'2022-05-26 16:24:31','',''),(477,'1','273','1',1,'Retail Sale Id 477',1998.64,0.00,0.00,3.01,171.57,'2022-05-26 16:26:18','',''),(478,'1','273','1',1,'Retail Sale Id 478',1347.92,0.00,0.00,2.03,115.71,'2022-05-26 16:29:39','',''),(479,'1','273','1',1,'Retail Sale Id 479',8300.00,0.00,0.00,12.50,712.50,'2022-05-26 16:34:36','',''),(480,'1','273','1',1,'Retail Sale Id 480',8300.00,0.00,0.00,12.50,712.50,'2022-05-26 16:37:56','',''),(481,'1','273','1',1,'Retail Sale Id 481',8300.00,0.00,0.00,12.50,712.50,'2022-05-26 16:45:36','',''),(482,'1','273','1',1,'Retail Sale Id 482',3001.28,0.00,0.00,4.52,257.64,'2022-05-26 16:47:59','',''),(483,'1','273','1',1,'Retail Sale Id 483',8300.00,0.00,0.00,12.50,712.50,'2022-05-26 17:03:06','',''),(484,'1','273','1',1,'Retail Sale Id 484',6640.00,0.00,0.00,10.00,570.00,'2022-05-26 17:11:51','',''),(485,'1','273','1',1,'Retail Sale Id 485',3984.00,0.00,0.00,6.00,342.00,'2022-05-26 17:13:19','',''),(486,'1','273','1',1,'Retail Sale Id 486',14495.60,0.00,0.00,23.38,303.94,'2022-05-26 17:28:45','',''),(487,'1','273','1',1,'Retail Sale Id 487',697.20,0.00,0.00,1.05,59.85,'2022-05-26 17:29:51','',''),(488,'1','273','1',1,'Retail Sale Id 488',650.72,0.00,0.00,0.98,55.86,'2022-05-26 17:34:32','',''),(489,'1','273','1',1,'Retail Sale Id 489',93000.00,0.00,0.00,150.00,1950.00,'2022-05-26 17:38:45','',''),(490,'1','273','1',1,'Retail Sale Id 490',62000.00,0.00,0.00,100.00,1300.00,'2022-05-26 17:39:36','',''),(491,'1','273','1',1,'Retail Sale Id 491',3320.00,0.00,0.00,5.00,285.00,'2022-05-26 17:40:55','',''),(492,'1','273','1',1,'Retail Sale Id 493',1952.16,0.00,0.00,2.94,167.58,'2022-05-26 17:44:32','',''),(493,'1','273','1',1,'Retail Sale Id 494',2649.36,0.00,0.00,3.99,227.43,'2022-05-26 17:52:21','',''),(494,'1','273','1',1,'Retail Sale Id 495',657.36,0.00,0.00,0.99,56.43,'2022-05-26 18:01:29','',''),(495,'1','273','1',1,'Retail Sale Id 497',1350.00,0.00,0.00,1.00,743.00,'2022-05-26 18:04:03','',''),(496,'1','273','1',1,'Return of Retail Sale Id 497',0.00,1350.00,1.00,0.00,-743.00,'2022-05-26 18:05:35','',''),(497,'1','273','1',1,'Retail Sale Id 498',1347.92,0.00,0.00,2.03,115.71,'2022-05-26 18:06:21','',''),(498,'1','273','1',1,'Retail Sale Id 499',5312.00,0.00,0.00,8.00,456.00,'2022-05-26 18:07:11','',''),(499,'1','273','1',1,'Retail Sale Id 500',1992.00,0.00,0.00,3.00,171.00,'2022-05-26 18:16:38','',''),(500,'1','273','1',1,'Retail Sale Id 501',6308.00,0.00,0.00,9.50,541.50,'2022-05-26 18:18:05','',''),(501,'1','273','1',1,'Retail Sale Id 502',697.20,0.00,0.00,1.05,59.85,'2022-05-26 18:19:41','',''),(502,'1','273','1',1,'Retail Sale Id 503',2139.00,0.00,0.00,3.45,44.85,'2022-05-26 19:25:17','',''),(503,'1','273','1',1,'Retail Sale Id 504',93000.00,0.00,0.00,150.00,1950.00,'2022-05-27 07:01:13','',''),(504,'1','273','1',1,'Retail Sale Id 505',62000.00,0.00,0.00,100.00,1300.00,'2022-05-27 07:01:47','',''),(505,'1','273','1',1,'Retail Sale Id 506',1002.64,0.00,0.00,1.51,86.07,'2022-05-27 07:02:39','',''),(506,'1','273','1',1,'Retail Sale Id 508',1002.64,0.00,0.00,1.51,86.07,'2022-05-27 07:03:27','',''),(507,'1','273','1',1,'Retail Sale Id 509',2702.48,0.00,0.00,4.07,231.99,'2022-05-27 07:04:43','',''),(508,'1','273','1',1,'Retail Sale Id 510',1002.64,0.00,0.00,1.51,86.07,'2022-05-27 07:05:49','',''),(509,'1','273','1',1,'Retail Sale Id 511',3320.00,0.00,0.00,5.00,285.00,'2022-05-27 07:06:46','',''),(510,'1','273','1',1,'Retail Sale Id 512',1002.64,0.00,0.00,1.51,86.07,'2022-05-27 07:22:19','',''),(511,'1','273','1',1,'Retail Sale Id 513',1500.64,0.00,0.00,2.26,128.82,'2022-05-27 07:26:30','',''),(512,'1','273','1',1,'Retail Sale Id 514',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 07:27:38','',''),(513,'1','273','1',1,'Retail Sale Id 515',31000.00,0.00,0.00,50.00,650.00,'2022-05-27 07:31:57','',''),(514,'1','273','1',1,'Retail Sale Id 516',32860.00,0.00,0.00,53.00,689.00,'2022-05-27 07:33:33','',''),(515,'1','273','1',1,'Retail Sale Id 517',10497.84,0.00,0.00,15.81,901.17,'2022-05-27 07:36:45','',''),(516,'1','273','1',1,'Retail Sale Id 518',8300.00,0.00,0.00,12.50,712.50,'2022-05-27 07:38:48','',''),(517,'1','273','1',1,'Retail Sale Id 519',2702.48,0.00,0.00,4.07,231.99,'2022-05-27 07:42:08','',''),(518,'1','273','1',1,'Retail Sale Id 520',4648.00,0.00,0.00,7.00,399.00,'2022-05-27 07:43:32','',''),(519,'1','273','1',1,'Retail Sale Id 521',39060.00,0.00,0.00,63.00,819.00,'2022-05-27 07:54:20','',''),(520,'1','273','1',1,'Retail Sale Id 522',1002.64,0.00,0.00,1.51,86.07,'2022-05-27 07:58:25','',''),(521,'1','273','1',1,'Retail Sale Id 523',1992.00,0.00,0.00,3.00,171.00,'2022-05-27 08:01:06','',''),(522,'1','273','1',1,'Retail Sale Id 523',3320.00,0.00,0.00,5.00,285.00,'2022-05-27 08:01:06','',''),(523,'1','273','1',1,'Retail Sale Id 524',8300.00,0.00,0.00,12.50,712.50,'2022-05-27 08:03:00','',''),(524,'1','273','1',1,'Retail Sale Id 524',8300.00,0.00,0.00,12.50,712.50,'2022-05-27 08:03:00','',''),(525,'1','273','1',1,'Retail Sale Id 525',60760.00,0.00,0.00,98.00,1274.00,'2022-05-27 08:08:50','',''),(526,'1','273','1',1,'Retail Sale Id 526',30380.00,0.00,0.00,49.00,637.00,'2022-05-27 08:09:57','',''),(527,'1','273','1',1,'Retail Sale Id 527',4648.00,0.00,0.00,7.00,399.00,'2022-05-27 08:14:47','',''),(528,'1','273','1',1,'Retail Sale Id 528',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 08:24:59','',''),(529,'1','273','1',1,'Retail Sale Id 529',91140.00,0.00,0.00,147.00,1911.00,'2022-05-27 08:35:30','',''),(530,'1','273','1',1,'Retail Sale Id 530',60760.00,0.00,0.00,98.00,1274.00,'2022-05-27 08:36:19','',''),(531,'1','273','1',1,'Retail Sale Id 531',597.60,0.00,0.00,0.90,51.30,'2022-05-27 08:37:25','',''),(532,'1','273','1',1,'Retail Sale Id 532',3320.00,0.00,0.00,5.00,285.00,'2022-05-27 08:44:04','',''),(533,'1','273','1',1,'Retail Sale Id 533',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 08:48:54','',''),(534,'1','273','1',1,'Retail Sale Id 534',74400.00,0.00,0.00,120.00,1560.00,'2022-05-27 08:50:41','',''),(535,'1','273','1',1,'Retail Sale Id 535',3320.00,0.00,0.00,5.00,285.00,'2022-05-27 09:00:06','',''),(536,'1','273','1',1,'Retail Sale Id 536',74400.00,0.00,0.00,120.00,1560.00,'2022-05-27 09:01:41','',''),(537,'1','273','1',1,'Retail Sale Id 537',73160.00,0.00,0.00,118.00,1534.00,'2022-05-27 09:02:41','',''),(538,'1','273','1',1,'Retail Sale Id 538',6998.56,0.00,0.00,10.54,600.78,'2022-05-27 09:06:52','',''),(539,'1','273','1',1,'Retail Sale Id 539',13999.60,0.00,0.00,22.58,293.54,'2022-05-27 09:12:10','',''),(540,'1','273','1',1,'Retail Sale Id 540',4999.92,0.00,0.00,7.53,429.21,'2022-05-27 09:21:28','',''),(541,'1','273','1',1,'Retail Sale Id 541',8300.00,0.00,0.00,12.50,712.50,'2022-05-27 09:22:06','',''),(542,'1','273','1',1,'Retail Sale Id 543',93000.00,0.00,0.00,150.00,1950.00,'2022-05-27 09:33:14','',''),(543,'1','273','1',1,'Retail Sale Id 544',102300.00,0.00,0.00,165.00,2145.00,'2022-05-27 09:34:25','',''),(544,'1','273','1',1,'Retail Sale Id 545',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 09:38:33','',''),(545,'1','273','1',1,'Retail Sale Id 546',62000.00,0.00,0.00,100.00,1300.00,'2022-05-27 10:10:17','',''),(546,'1','273','1',1,'Retail Sale Id 547',54250.00,0.00,0.00,87.50,1137.50,'2022-05-27 10:11:43','',''),(547,'1','273','1',1,'Retail Sale Id 548',77500.00,0.00,0.00,125.00,1625.00,'2022-05-27 10:23:52','',''),(548,'1','273','1',1,'Retail Sale Id 549',31000.00,0.00,0.00,50.00,650.00,'2022-05-27 10:24:53','',''),(549,'1','273','1',1,'Retail Sale Id 551',91140.00,0.00,0.00,147.00,1911.00,'2022-05-27 10:28:57','',''),(550,'1','273','1',1,'Retail Sale Id 552',60760.00,0.00,0.00,98.00,1274.00,'2022-05-27 10:30:15','',''),(551,'1','273','1',1,'Retail Sale Id 553',124000.00,0.00,0.00,200.00,2600.00,'2022-05-27 10:33:17','',''),(552,'1','273','1',1,'Retail Sale Id 554',93000.00,0.00,0.00,150.00,1950.00,'2022-05-27 10:45:20','',''),(553,'1','273','1',1,'Retail Sale Id 556',93000.00,0.00,0.00,150.00,1950.00,'2022-05-27 10:45:56','',''),(554,'1','273','1',1,'Retail Sale Id 557',74400.00,0.00,0.00,120.00,1560.00,'2022-05-27 10:48:02','',''),(555,'1','273','1',1,'Retail Sale Id 560',3499.28,0.00,0.00,5.27,300.39,'2022-05-27 10:48:56','',''),(556,'1','273','1',1,'Retail Sale Id 561',97030.00,0.00,0.00,156.50,2034.50,'2022-05-27 11:07:42','',''),(557,'1','273','1',1,'Retail Sale Id 562',93000.00,0.00,0.00,150.00,1950.00,'2022-05-27 11:26:50','',''),(558,'1','273','1',1,'Retail Sale Id 563',42160.00,0.00,0.00,68.00,884.00,'2022-05-27 11:27:47','',''),(559,'1','273','1',1,'Retail Sale Id 564',71300.00,0.00,0.00,115.00,1495.00,'2022-05-27 12:33:39','',''),(560,'1','273','1',1,'Retail Sale Id 565',93000.00,0.00,0.00,150.00,1950.00,'2022-05-27 12:37:08','',''),(561,'1','273','1',1,'Retail Sale Id 566',4648.00,0.00,0.00,7.00,399.00,'2022-05-27 12:38:17','',''),(562,'1','273','1',1,'Retail Sale Id 567',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 12:40:27','',''),(563,'1','273','1',1,'Retail Sale Id 568',39060.00,0.00,0.00,63.00,819.00,'2022-05-27 12:42:44','',''),(564,'1','273','1',1,'Retail Sale Id 569',4501.92,0.00,0.00,6.78,386.46,'2022-05-27 12:59:23','',''),(565,'1','273','1',1,'Retail Sale Id 570',151900.00,0.00,0.00,245.00,3185.00,'2022-05-27 13:00:32','',''),(566,'1','273','1',1,'Retail Sale Id 571',93000.00,0.00,0.00,150.00,1950.00,'2022-05-27 13:02:57','',''),(567,'1','273','1',1,'Retail Sale Id 572',6640.00,0.00,0.00,10.00,570.00,'2022-05-27 13:14:15','',''),(568,'1','273','1',1,'Retail Sale Id 573',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 13:15:27','',''),(569,'1','273','1',1,'Retail Sale Id 574',8300.00,0.00,0.00,12.50,712.50,'2022-05-27 13:37:28','',''),(570,'1','273','1',1,'Retail Sale Id 575',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 13:49:25','',''),(571,'1','273','1',1,'Retail Sale Id 576',697.20,0.00,0.00,1.05,59.85,'2022-05-27 13:51:29','',''),(572,'1','273','1',1,'Retail Sale Id 577',8300.00,0.00,0.00,12.50,712.50,'2022-05-27 14:54:40','',''),(573,'1','273','1',1,'Retail Sale Id 578',77500.00,0.00,0.00,125.00,1625.00,'2022-05-27 14:55:47','',''),(574,'1','273','1',1,'Retail Sale Id 579',31000.00,0.00,0.00,50.00,650.00,'2022-05-27 14:58:31','',''),(575,'1','273','1',1,'Retail Sale Id 580',217000.00,0.00,0.00,350.00,4550.00,'2022-05-27 15:01:12','',''),(576,'1','273','1',1,'Retail Sale Id 582',1002.64,0.00,0.00,1.51,86.07,'2022-05-27 15:02:38','',''),(577,'1','273','1',1,'Retail Sale Id 583',1328.00,0.00,0.00,2.00,114.00,'2022-05-27 15:04:15','',''),(578,'1','273','1',1,'Retail Sale Id 584',72540.00,0.00,0.00,117.00,1521.00,'2022-05-27 15:06:38','',''),(579,'1','273','1',1,'Retail Sale Id 585',3997.28,0.00,0.00,6.02,343.14,'2022-05-27 15:07:25','',''),(580,'1','273','1',1,'Retail Sale Id 586',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 15:13:37','',''),(581,'1','273','1',1,'Return of Retail Sale Id 584',0.00,72540.00,117.00,0.00,-1521.00,'2022-05-27 15:14:56','',''),(582,'1','273','1',1,'Retail Sale Id 587',72540.00,0.00,0.00,117.00,1521.00,'2022-05-27 15:15:45','',''),(583,'1','273','1',1,'Retail Sale Id 588',2656.00,0.00,0.00,4.00,228.00,'2022-05-27 15:17:47','',''),(584,'1','273','1',1,'Retail Sale Id 589',151900.00,0.00,0.00,245.00,3185.00,'2022-05-27 15:21:37','',''),(585,'1','273','1',1,'Retail Sale Id 590',8300.00,0.00,0.00,12.50,712.50,'2022-05-27 15:28:45','',''),(586,'1','273','1',1,'Retail Sale Id 591',3001.28,0.00,0.00,4.52,257.64,'2022-05-27 15:33:46','',''),(587,'1','273','1',1,'Retail Sale Id 592',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 15:45:52','',''),(588,'1','273','1',1,'Retail Sale Id 593',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 15:47:37','',''),(589,'1','273','1',1,'Retail Sale Id 594',4648.00,0.00,0.00,7.00,399.00,'2022-05-27 15:48:32','',''),(590,'1','273','1',1,'Retail Sale Id 595',4999.92,0.00,0.00,7.53,429.21,'2022-05-27 16:00:18','',''),(591,'1','273','1',1,'Retail Sale Id 596',1328.00,0.00,0.00,2.00,114.00,'2022-05-27 16:02:28','',''),(592,'1','273','1',1,'Retail Sale Id 597',650.72,0.00,0.00,0.98,55.86,'2022-05-27 16:03:35','',''),(593,'1','273','1',1,'Retail Sale Id 598',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 16:31:40','',''),(594,'1','273','1',1,'Retail Sale Id 599',3001.28,0.00,0.00,4.52,257.64,'2022-05-27 16:34:55','',''),(595,'1','273','1',1,'Retail Sale Id 600',8001.20,0.00,0.00,12.05,686.85,'2022-05-27 16:36:10','',''),(596,'1','273','1',1,'Retail Sale Id 601',3320.00,0.00,0.00,5.00,285.00,'2022-05-27 16:50:46','',''),(597,'1','273','1',1,'Retail Sale Id 602',3320.00,0.00,0.00,5.00,285.00,'2022-05-27 16:53:16','',''),(598,'1','273','1',1,'Retail Sale Id 604',12995.20,0.00,0.00,20.96,272.48,'2022-05-27 16:58:30','',''),(599,'1','273','1',1,'Retail Sale Id 605',1002.64,0.00,0.00,1.51,86.07,'2022-05-27 16:59:38','',''),(600,'1','273','1',1,'Retail Sale Id 606',697.20,0.00,0.00,1.05,59.85,'2022-05-27 17:00:44','',''),(601,'1','273','1',1,'Retail Sale Id 607',1998.64,0.00,0.00,3.01,171.57,'2022-05-27 17:02:01','',''),(602,'1','273','1',1,'Retail Sale Id 608',1799.44,0.00,0.00,2.71,154.47,'2022-05-27 17:12:40','',''),(603,'1','273','1',1,'Retail Sale Id 609',1002.64,0.00,0.00,1.51,86.07,'2022-05-27 17:15:03','',''),(604,'1','273','1',1,'Retail Sale Id 610',7968.00,0.00,0.00,12.00,684.00,'2022-05-27 17:15:54','',''),(605,'1','273','1',1,'Retail Sale Id 611',1002.64,0.00,0.00,1.51,86.07,'2022-05-27 17:37:15','',''),(606,'1','273','1',1,'Retail Sale Id 612',1301.44,0.00,0.00,1.96,111.72,'2022-05-27 17:44:05','',''),(607,'1','273','1',1,'Retail Sale Id 614',697.20,0.00,0.00,1.05,59.85,'2022-05-27 17:48:01','',''),(608,'1','273','1',1,'Retail Sale Id 615',8300.00,0.00,0.00,12.50,712.50,'2022-05-27 17:49:44','',''),(609,'1','273','1',1,'Retail Sale Id 617',2662.64,0.00,0.00,4.01,228.57,'2022-05-27 18:05:13','',''),(610,'1','273','1',1,'Retail Sale Id 618',1426.00,0.00,0.00,2.30,29.90,'2022-05-27 18:53:13','',''),(611,'1','273','1',1,'Retail Sale Id 619',1992.00,0.00,0.00,3.00,171.00,'2022-05-28 06:52:45','',''),(612,'1','273','1',1,'Retail Sale Id 621',11998.48,0.00,0.00,18.07,1029.99,'2022-05-28 07:02:16','',''),(613,'1','273','1',1,'Retail Sale Id 621',13997.12,0.00,0.00,21.08,1201.56,'2022-05-28 07:02:16','',''),(614,'1','273','1',1,'Retail Sale Id 622',3997.28,0.00,0.00,6.02,343.14,'2022-05-28 07:11:33','',''),(615,'1','273','1',1,'Retail Sale Id 623',697.20,0.00,0.00,1.05,59.85,'2022-05-28 07:23:08','',''),(616,'1','273','1',1,'Retail Sale Id 624',3001.28,0.00,0.00,4.52,257.64,'2022-05-28 07:29:43','',''),(617,'1','273','1',1,'Retail Sale Id 627',1500.64,0.00,0.00,2.26,128.82,'2022-05-28 07:31:47','',''),(618,'1','273','1',1,'Retail Sale Id 630',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 07:33:07','',''),(619,'1','273','1',1,'Retail Sale Id 631',3399.68,0.00,0.00,5.12,291.84,'2022-05-28 07:36:40','',''),(620,'1','273','1',1,'Retail Sale Id 632',697.20,0.00,0.00,1.05,59.85,'2022-05-28 07:52:57','',''),(621,'1','273','1',1,'Retail Sale Id 634',1500.64,0.00,0.00,2.26,128.82,'2022-05-28 07:58:43','',''),(622,'1','273','1',1,'Retail Sale Id 635',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 08:07:33','',''),(623,'1','273','1',1,'Retail Sale Id 636',3320.00,0.00,0.00,5.00,285.00,'2022-05-28 08:18:46','',''),(624,'1','273','1',1,'Retail Sale Id 637',2702.48,0.00,0.00,4.07,231.99,'2022-05-28 08:22:31','',''),(625,'1','273','1',1,'Retail Sale Id 640',796.80,0.00,0.00,1.20,68.40,'2022-05-28 08:24:01','',''),(626,'1','273','1',1,'Retail Sale Id 641',3320.00,0.00,0.00,5.00,285.00,'2022-05-28 08:24:56','',''),(627,'1','273','1',1,'Retail Sale Id 642',65100.00,0.00,0.00,105.00,1365.00,'2022-05-28 08:31:35','',''),(628,'1','273','1',1,'Retail Sale Id 643',3997.28,0.00,0.00,6.02,343.14,'2022-05-28 08:34:53','',''),(629,'1','273','1',1,'Retail Sale Id 647',670.64,0.00,0.00,1.01,57.57,'2022-05-28 08:42:25','',''),(630,'1','273','1',1,'Retail Sale Id 647',1328.00,0.00,0.00,2.00,114.00,'2022-05-28 08:42:25','',''),(631,'1','273','1',1,'Retail Sale Id 648',8300.00,0.00,0.00,12.50,712.50,'2022-05-28 08:43:21','',''),(632,'1','273','1',1,'Retail Sale Id 649',2662.64,0.00,0.00,4.01,228.57,'2022-05-28 08:47:16','',''),(633,'1','273','1',1,'Retail Sale Id 650',3320.00,0.00,0.00,5.00,285.00,'2022-05-28 08:50:34','',''),(634,'1','273','1',1,'Retail Sale Id 651',2656.00,0.00,0.00,4.00,228.00,'2022-05-28 08:52:01','',''),(635,'1','273','1',1,'Retail Sale Id 652',1500.64,0.00,0.00,2.26,128.82,'2022-05-28 08:53:23','',''),(636,'1','273','1',1,'Retail Sale Id 653',1500.64,0.00,0.00,2.26,128.82,'2022-05-28 08:54:18','',''),(637,'1','273','1',1,'Retail Sale Id 654',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 08:55:18','',''),(638,'1','273','1',1,'Retail Sale Id 655',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 08:57:40','',''),(639,'1','273','1',1,'Retail Sale Id 656',1201.84,0.00,0.00,1.81,103.17,'2022-05-28 08:58:37','',''),(640,'1','273','1',1,'Retail Sale Id 657',3300.08,0.00,0.00,4.97,283.29,'2022-05-28 08:59:39','',''),(641,'1','273','1',1,'Retail Sale Id 658',1002.64,0.00,0.00,1.51,86.07,'2022-05-28 09:01:41','',''),(642,'1','273','1',1,'Retail Sale Id 659',7968.00,0.00,0.00,12.00,684.00,'2022-05-28 09:07:35','',''),(643,'1','273','1',1,'Retail Sale Id 660',20001.20,0.00,0.00,32.26,419.38,'2022-05-28 09:19:49','',''),(644,'1','273','1',1,'Retail Sale Id 661',31000.00,0.00,0.00,50.00,650.00,'2022-05-28 09:32:42','',''),(645,'1','273','1',1,'Retail Sale Id 662',650.72,0.00,0.00,0.98,55.86,'2022-05-28 09:36:22','',''),(646,'1','273','1',1,'Retail Sale Id 663',77500.00,0.00,0.00,125.00,1625.00,'2022-05-28 09:45:26','',''),(647,'1','273','1',1,'Retail Sale Id 664',4960.00,0.00,0.00,8.00,104.00,'2022-05-28 09:47:24','',''),(648,'1','273','1',1,'Retail Sale Id 665',11952.00,0.00,0.00,18.00,1026.00,'2022-05-28 09:52:29','',''),(649,'1','273','1',1,'Retail Sale Id 666',15500.00,0.00,0.00,25.00,325.00,'2022-05-28 09:54:54','',''),(650,'1','273','1',1,'Retail Sale Id 667',3353.20,0.00,0.00,5.05,287.85,'2022-05-28 09:56:22','',''),(651,'1','273','1',1,'Retail Sale Id 668',8300.00,0.00,0.00,12.50,712.50,'2022-05-28 10:01:11','',''),(652,'1','273','1',1,'Retail Sale Id 669',1992.00,0.00,0.00,3.00,171.00,'2022-05-28 10:02:19','',''),(653,'1','273','1',1,'Retail Sale Id 670',8300.00,0.00,0.00,12.50,712.50,'2022-05-28 10:03:13','',''),(654,'1','273','1',1,'Retail Sale Id 671',111600.00,0.00,0.00,180.00,2340.00,'2022-05-28 10:10:23','',''),(655,'1','273','1',1,'Retail Sale Id 672',697.20,0.00,0.00,1.05,59.85,'2022-05-28 10:12:33','',''),(656,'1','273','1',1,'Retail Sale Id 673',23250.00,0.00,0.00,37.50,487.50,'2022-05-28 10:21:43','',''),(657,'1','273','1',1,'Retail Sale Id 674',31000.00,0.00,0.00,50.00,650.00,'2022-05-28 10:23:43','',''),(658,'1','273','1',1,'Retail Sale Id 675',1002.64,0.00,0.00,1.51,86.07,'2022-05-28 10:24:42','',''),(659,'1','273','1',1,'Retail Sale Id 676',1500.64,0.00,0.00,2.26,128.82,'2022-05-28 10:25:30','',''),(660,'1','273','1',1,'Retail Sale Id 677',1347.92,0.00,0.00,2.03,115.71,'2022-05-28 10:29:50','',''),(661,'1','273','1',1,'Return of Retail Sale Id 677',0.00,1347.92,2.03,0.00,-115.71,'2022-05-28 10:32:11','',''),(662,'1','273','1',1,'Retail Sale Id 678',1347.92,0.00,0.00,2.03,115.71,'2022-05-28 10:33:06','',''),(663,'1','273','1',1,'Retail Sale Id 679',6640.00,0.00,0.00,10.00,570.00,'2022-05-28 10:35:36','',''),(664,'1','273','1',1,'Retail Sale Id 680',124000.00,0.00,0.00,200.00,2600.00,'2022-05-28 10:37:32','',''),(665,'1','273','1',1,'Retail Sale Id 681',1500.64,0.00,0.00,2.26,128.82,'2022-05-28 10:44:22','',''),(666,'1','273','1',1,'Retail Sale Id 681',1500.64,0.00,0.00,2.26,128.82,'2022-05-28 10:44:22','',''),(667,'1','273','1',1,'Retail Sale Id 683',1347.92,0.00,0.00,2.03,115.71,'2022-05-28 10:49:52','',''),(668,'1','273','1',1,'Retail Sale Id 684',3997.28,0.00,0.00,6.02,343.14,'2022-05-28 10:51:03','',''),(669,'1','273','1',1,'Retail Sale Id 685',34100.00,0.00,0.00,55.00,715.00,'2022-05-28 11:26:21','',''),(670,'1','273','1',1,'Retail Sale Id 686',3320.00,0.00,0.00,5.00,285.00,'2022-05-28 11:36:55','',''),(671,'1','273','1',1,'Retail Sale Id 687',131099.00,0.00,0.00,211.45,2748.85,'2022-05-28 11:38:18','',''),(672,'1','273','1',1,'Retail Sale Id 689',5312.00,0.00,0.00,8.00,456.00,'2022-05-28 11:51:13','',''),(673,'1','273','1',1,'Retail Sale Id 689',8300.00,0.00,0.00,12.50,712.50,'2022-05-28 11:51:13','',''),(674,'1','273','1',1,'Retail Sale Id 690',697.20,0.00,0.00,1.05,59.85,'2022-05-28 12:05:02','',''),(675,'1','273','1',1,'Retail Sale Id 692',1952.16,0.00,0.00,2.94,167.58,'2022-05-28 12:06:51','',''),(676,'1','273','1',1,'Retail Sale Id 693',89900.00,0.00,0.00,145.00,1885.00,'2022-05-28 12:10:46','',''),(677,'1','273','1',1,'Retail Sale Id 694',3353.20,0.00,0.00,5.05,287.85,'2022-05-28 12:14:02','',''),(678,'1','273','1',1,'Retail Sale Id 695',3320.00,0.00,0.00,5.00,285.00,'2022-05-28 12:24:09','',''),(679,'1','273','1',1,'Retail Sale Id 696',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 12:38:52','',''),(680,'1','273','1',1,'Retail Sale Id 697',1002.64,0.00,0.00,1.51,86.07,'2022-05-28 12:44:36','',''),(681,'1','273','1',1,'Retail Sale Id 698',5497.92,0.00,0.00,8.28,471.96,'2022-05-28 12:48:26','',''),(682,'1','273','1',1,'Retail Sale Id 699',93000.00,0.00,0.00,150.00,1950.00,'2022-05-28 13:00:39','',''),(683,'1','273','1',1,'Retail Sale Id 700',62000.00,0.00,0.00,100.00,1300.00,'2022-05-28 13:01:52','',''),(684,'1','273','1',1,'Retail Sale Id 701',93000.00,0.00,0.00,150.00,1950.00,'2022-05-28 13:25:35','',''),(685,'1','273','1',1,'Retail Sale Id 702',93000.00,0.00,0.00,150.00,1950.00,'2022-05-28 13:26:19','',''),(686,'1','273','1',1,'Retail Sale Id 703',4648.00,0.00,0.00,7.00,399.00,'2022-05-28 13:28:59','',''),(687,'1','273','1',1,'Retail Sale Id 703',4648.00,0.00,0.00,7.00,399.00,'2022-05-28 13:28:59','',''),(688,'1','273','1',1,'Retail Sale Id 703',4648.00,0.00,0.00,7.00,399.00,'2022-05-28 13:28:59','',''),(689,'1','273','1',1,'Retail Sale Id 703',4648.00,0.00,0.00,7.00,399.00,'2022-05-28 13:28:59','',''),(690,'1','273','1',1,'Retail Sale Id 704',903.04,0.00,0.00,1.36,77.52,'2022-05-28 13:39:11','',''),(691,'1','273','1',1,'Retail Sale Id 706',3997.28,0.00,0.00,6.02,343.14,'2022-05-28 13:41:23','',''),(692,'1','273','1',1,'Retail Sale Id 707',124000.00,0.00,0.00,200.00,2600.00,'2022-05-28 13:50:54','',''),(693,'1','273','1',1,'Retail Sale Id 708',750.32,0.00,0.00,1.13,64.41,'2022-05-28 13:53:19','',''),(694,'1','273','1',1,'Retail Sale Id 709',1347.92,0.00,0.00,2.03,115.71,'2022-05-28 13:55:42','',''),(695,'1','273','1',1,'Retail Sale Id 710',3320.00,0.00,0.00,5.00,285.00,'2022-05-28 13:57:44','',''),(696,'1','273','1',1,'Retail Sale Id 711',3001.28,0.00,0.00,4.52,257.64,'2022-05-28 13:59:36','',''),(697,'1','273','1',1,'Retail Sale Id 712',1347.92,0.00,0.00,2.03,115.71,'2022-05-28 14:05:53','',''),(698,'1','273','1',1,'Retail Sale Id 713',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 14:17:11','',''),(699,'1','273','1',1,'Retail Sale Id 714',1328.00,0.00,0.00,2.00,114.00,'2022-05-28 14:18:15','',''),(700,'1','273','1',1,'Retail Sale Id 715',1500.64,0.00,0.00,2.26,128.82,'2022-05-28 14:19:13','',''),(701,'1','273','1',1,'Retail Sale Id 716',71300.00,0.00,0.00,115.00,1495.00,'2022-05-28 14:34:21','',''),(702,'1','273','1',1,'Retail Sale Id 717',93000.00,0.00,0.00,150.00,1950.00,'2022-05-28 14:42:21','',''),(703,'1','273','1',1,'Retail Sale Id 718',93000.00,0.00,0.00,150.00,1950.00,'2022-05-28 14:43:34','',''),(704,'1','273','1',1,'Retail Sale Id 719',1347.92,0.00,0.00,2.03,115.71,'2022-05-28 15:03:39','',''),(705,'1','273','1',1,'Retail Sale Id 720',697.20,0.00,0.00,1.05,59.85,'2022-05-28 15:06:34','',''),(706,'1','273','1',1,'Retail Sale Id 721',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 15:11:57','',''),(707,'1','273','1',1,'Retail Sale Id 722',3997.28,0.00,0.00,6.02,343.14,'2022-05-28 15:20:35','',''),(708,'1','273','1',1,'Retail Sale Id 723',7968.00,0.00,0.00,12.00,684.00,'2022-05-28 15:35:29','',''),(709,'1','273','1',1,'Retail Sale Id 724',93000.00,0.00,0.00,150.00,1950.00,'2022-05-28 15:40:51','',''),(710,'1','273','1',1,'Retail Sale Id 725',93000.00,0.00,0.00,150.00,1950.00,'2022-05-28 15:41:29','',''),(711,'1','273','1',1,'Retail Sale Id 726',3320.00,0.00,0.00,5.00,285.00,'2022-05-28 15:51:41','',''),(712,'1','273','1',1,'Retail Sale Id 727',3984.00,0.00,0.00,6.00,342.00,'2022-05-28 16:00:49','',''),(713,'1','273','1',1,'Retail Sale Id 727',7968.00,0.00,0.00,12.00,684.00,'2022-05-28 16:00:49','',''),(714,'1','273','1',1,'Retail Sale Id 728',498.00,0.00,0.00,0.75,42.75,'2022-05-28 16:09:41','',''),(715,'1','273','1',1,'Retail Sale Id 729',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 16:14:15','',''),(716,'1','273','1',1,'Retail Sale Id 731',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 16:19:16','',''),(717,'1','273','1',1,'Retail Sale Id 732',3320.00,0.00,0.00,5.00,285.00,'2022-05-28 16:26:08','',''),(718,'1','273','1',1,'Retail Sale Id 733',126480.00,0.00,0.00,204.00,2652.00,'2022-05-28 16:28:20','',''),(719,'1','273','1',1,'Retail Sale Id 734',8001.20,0.00,0.00,12.05,686.85,'2022-05-28 16:29:38','',''),(720,'1','273','1',1,'Retail Sale Id 735',3984.00,0.00,0.00,6.00,342.00,'2022-05-28 16:32:07','',''),(721,'1','273','1',1,'Retail Sale Id 736',8300.00,0.00,0.00,12.50,712.50,'2022-05-28 16:35:32','',''),(722,'1','273','1',1,'Retail Sale Id 736',8300.00,0.00,0.00,12.50,712.50,'2022-05-28 16:35:32','',''),(723,'1','273','1',1,'Retail Sale Id 737',49600.00,0.00,0.00,80.00,1040.00,'2022-05-28 16:39:31','',''),(724,'1','273','1',1,'Retail Sale Id 738',31000.00,0.00,0.00,50.00,650.00,'2022-05-28 16:44:37','',''),(725,'1','273','1',1,'Retail Sale Id 739',1002.64,0.00,0.00,1.51,86.07,'2022-05-28 16:45:25','',''),(726,'1','273','1',1,'Retail Sale Id 739',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 16:45:25','',''),(727,'1','273','1',1,'Retail Sale Id 740',697.20,0.00,0.00,1.05,59.85,'2022-05-28 16:46:28','',''),(728,'1','273','1',1,'Retail Sale Id 741',3997.28,0.00,0.00,6.02,343.14,'2022-05-28 16:47:16','',''),(729,'1','273','1',1,'Retail Sale Id 742',13999.60,0.00,0.00,22.58,293.54,'2022-05-28 16:51:30','',''),(730,'1','273','1',1,'Retail Sale Id 743',1347.92,0.00,0.00,2.03,115.71,'2022-05-28 16:53:02','',''),(731,'1','273','1',1,'Retail Sale Id 744',1002.64,0.00,0.00,1.51,86.07,'2022-05-28 16:57:44','',''),(732,'1','273','1',1,'Retail Sale Id 745',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 17:06:07','',''),(733,'1','273','1',1,'Retail Sale Id 746',1500.64,0.00,0.00,2.26,128.82,'2022-05-28 17:09:13','',''),(734,'1','273','1',1,'Retail Sale Id 747',124000.00,0.00,0.00,200.00,2600.00,'2022-05-28 17:19:48','',''),(735,'1','273','1',1,'Retail Sale Id 748',93000.00,0.00,0.00,150.00,1950.00,'2022-05-28 17:20:32','',''),(736,'1','273','1',1,'Retail Sale Id 749',54560.00,0.00,0.00,88.00,1144.00,'2022-05-28 17:26:21','',''),(737,'1','273','1',1,'Retail Sale Id 750',3320.00,0.00,0.00,5.00,285.00,'2022-05-28 17:29:21','',''),(738,'1','273','1',1,'Retail Sale Id 751',27900.00,0.00,0.00,45.00,585.00,'2022-05-28 17:40:58','',''),(739,'1','273','1',1,'Retail Sale Id 752',1998.64,0.00,0.00,3.01,171.57,'2022-05-28 17:54:45','',''),(740,'1','273','1',1,'Retail Sale Id 753',697.20,0.00,0.00,1.05,59.85,'2022-05-28 17:56:42','',''),(741,'1','273','1',1,'Retail Sale Id 754',1500.64,0.00,0.00,2.26,128.82,'2022-05-28 18:03:41','',''),(742,'1','273','1',1,'Retail Sale Id 755',8300.00,0.00,0.00,12.50,712.50,'2022-05-28 18:04:49','',''),(743,'1','273','1',1,'Retail Sale Id 756',1002.64,0.00,0.00,1.51,86.07,'2022-05-28 18:09:09','',''),(744,'1','273','1',1,'Return of Retail Sale Id 751',0.00,27900.00,45.00,0.00,-585.00,'2022-05-28 19:45:12','',''),(745,'1','273','1',1,'Retail Sale Id 757',27168.40,0.00,0.00,43.82,569.66,'2022-05-28 19:46:17','',''),(746,'1','273','1',1,'Retail Sale Id 758',186000.00,0.00,0.00,300.00,3900.00,'2022-05-29 07:05:06','',''),(747,'1','273','1',1,'Retail Sale Id 759',217000.00,0.00,0.00,350.00,4550.00,'2022-05-29 07:05:58','',''),(748,'1','273','1',1,'Retail Sale Id 760',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 07:06:40','',''),(749,'1','273','1',1,'Retail Sale Id 761',1998.64,0.00,0.00,3.01,171.57,'2022-05-29 10:07:59','',''),(750,'1','273','1',1,'Retail Sale Id 762',8300.00,0.00,0.00,12.50,712.50,'2022-05-29 10:09:19','',''),(751,'1','273','1',1,'Retail Sale Id 763',65100.00,0.00,0.00,105.00,1365.00,'2022-05-29 10:10:45','',''),(752,'1','273','1',1,'Retail Sale Id 764',217000.00,0.00,0.00,350.00,4550.00,'2022-05-29 10:11:23','',''),(753,'1','273','1',1,'Retail Sale Id 765',13999.60,0.00,0.00,22.58,293.54,'2022-05-29 10:12:17','',''),(754,'1','273','1',1,'Retail Sale Id 766',48252.88,0.00,0.00,72.67,4142.19,'2022-05-29 10:13:43','',''),(755,'1','273','1',1,'Retail Sale Id 767',7948.08,0.00,0.00,11.97,682.29,'2022-05-29 10:16:53','',''),(756,'1','273','1',1,'Retail Sale Id 768',697.20,0.00,0.00,1.05,59.85,'2022-05-29 10:29:46','',''),(757,'1','273','1',1,'Retail Sale Id 769',650.72,0.00,0.00,0.98,55.86,'2022-05-29 10:45:32','',''),(758,'1','273','1',1,'Retail Sale Id 770',3997.28,0.00,0.00,6.02,343.14,'2022-05-29 10:57:34','',''),(759,'1','273','1',1,'Retail Sale Id 771',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 10:59:14','',''),(760,'1','273','1',1,'Retail Sale Id 772',8300.00,0.00,0.00,12.50,712.50,'2022-05-29 11:05:06','',''),(761,'1','273','1',1,'Retail Sale Id 774',3997.28,0.00,0.00,6.02,343.14,'2022-05-29 11:13:05','',''),(762,'1','273','1',1,'Retail Sale Id 775',1347.92,0.00,0.00,2.03,115.71,'2022-05-29 11:15:13','',''),(763,'1','273','1',1,'Retail Sale Id 776',3001.28,0.00,0.00,4.52,257.64,'2022-05-29 11:37:57','',''),(764,'1','273','1',1,'Retail Sale Id 777',1998.64,0.00,0.00,3.01,171.57,'2022-05-29 11:39:45','',''),(765,'1','273','1',1,'Retail Sale Id 778',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 11:44:49','',''),(766,'1','273','1',1,'Retail Sale Id 779',4999.92,0.00,0.00,7.53,429.21,'2022-05-29 11:50:29','',''),(767,'1','273','1',1,'Retail Sale Id 780',4648.00,0.00,0.00,7.00,399.00,'2022-05-29 11:52:44','',''),(768,'1','273','1',1,'Retail Sale Id 781',2649.36,0.00,0.00,3.99,227.43,'2022-05-29 11:56:31','',''),(769,'1','273','1',1,'Retail Sale Id 782',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 12:01:37','',''),(770,'1','273','1',1,'Retail Sale Id 783',1998.64,0.00,0.00,3.01,171.57,'2022-05-29 12:04:17','',''),(771,'1','273','1',1,'Retail Sale Id 784',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 12:05:46','',''),(772,'1','273','1',1,'Retail Sale Id 785',8300.00,0.00,0.00,12.50,712.50,'2022-05-29 12:10:29','',''),(773,'1','273','1',1,'Retail Sale Id 786',8300.00,0.00,0.00,12.50,712.50,'2022-05-29 12:16:12','',''),(774,'1','273','1',1,'Retail Sale Id 787',8300.00,0.00,0.00,12.50,712.50,'2022-05-29 12:45:09','',''),(775,'1','273','1',1,'Retail Sale Id 788',697.20,0.00,0.00,1.05,59.85,'2022-05-29 12:46:21','',''),(776,'1','273','1',1,'Retail Sale Id 789',1500.64,0.00,0.00,2.26,128.82,'2022-05-29 12:54:38','',''),(777,'1','273','1',1,'Retail Sale Id 791',8300.00,0.00,0.00,12.50,712.50,'2022-05-29 13:20:03','',''),(778,'1','273','1',1,'Retail Sale Id 793',1998.64,0.00,0.00,3.01,171.57,'2022-05-29 13:20:58','',''),(779,'1','273','1',1,'Retail Sale Id 794',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 13:34:42','',''),(780,'1','273','1',1,'Retail Sale Id 795',2503.28,0.00,0.00,3.77,214.89,'2022-05-29 13:40:38','',''),(781,'1','273','1',1,'Retail Sale Id 796',697.20,0.00,0.00,1.05,59.85,'2022-05-29 13:44:38','',''),(782,'1','273','1',1,'Retail Sale Id 797',8300.00,0.00,0.00,12.50,712.50,'2022-05-29 13:53:23','',''),(783,'1','273','1',1,'Retail Sale Id 798',38750.00,0.00,0.00,62.50,812.50,'2022-05-29 13:56:31','',''),(784,'1','273','1',1,'Retail Sale Id 800',3001.28,0.00,0.00,4.52,257.64,'2022-05-29 13:59:59','',''),(785,'1','273','1',1,'Retail Sale Id 801',2656.00,0.00,0.00,4.00,228.00,'2022-05-29 14:01:16','',''),(786,'1','273','1',1,'Retail Sale Id 802',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 14:02:05','',''),(787,'1','273','1',1,'Retail Sale Id 803',9960.00,0.00,0.00,15.00,855.00,'2022-05-29 14:08:05','',''),(788,'1','273','1',1,'Retail Sale Id 804',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 14:09:03','',''),(789,'1','273','1',1,'Retail Sale Id 805',2702.48,0.00,0.00,4.07,231.99,'2022-05-29 14:10:15','',''),(790,'1','273','1',1,'Retail Sale Id 806',8300.00,0.00,0.00,12.50,712.50,'2022-05-29 14:18:10','',''),(791,'1','273','1',1,'Retail Sale Id 807',1347.92,0.00,0.00,2.03,115.71,'2022-05-29 14:26:36','',''),(792,'1','273','1',1,'Retail Sale Id 808',1998.64,0.00,0.00,3.01,171.57,'2022-05-29 14:27:34','',''),(793,'1','273','1',1,'Retail Sale Id 809',1998.64,0.00,0.00,3.01,171.57,'2022-05-29 14:35:32','',''),(794,'1','273','1',1,'Retail Sale Id 810',8300.00,0.00,0.00,12.50,712.50,'2022-05-29 14:38:18','',''),(795,'1','273','1',1,'Retail Sale Id 811',697.20,0.00,0.00,1.05,59.85,'2022-05-29 14:45:18','',''),(796,'1','273','1',1,'Retail Sale Id 812',73160.00,0.00,0.00,118.00,1534.00,'2022-05-29 14:47:13','',''),(797,'1','273','1',1,'Retail Sale Id 814',8001.20,0.00,0.00,12.05,686.85,'2022-05-29 15:00:38','',''),(798,'1','273','1',1,'Retail Sale Id 815',3997.28,0.00,0.00,6.02,343.14,'2022-05-29 15:11:13','',''),(799,'1','273','1',1,'Retail Sale Id 816',31000.00,0.00,0.00,50.00,650.00,'2022-05-29 15:26:00','',''),(800,'1','273','1',1,'Retail Sale Id 817',126170.00,0.00,0.00,203.50,2645.50,'2022-05-29 15:32:52','',''),(801,'1','273','1',1,'Retail Sale Id 818',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 15:34:14','',''),(802,'1','273','1',1,'Retail Sale Id 819',3997.28,0.00,0.00,6.02,343.14,'2022-05-29 15:35:02','',''),(803,'1','273','1',1,'Retail Sale Id 820',1500.64,0.00,0.00,2.26,128.82,'2022-05-29 15:35:52','',''),(804,'1','273','1',1,'Retail Sale Id 821',697.20,0.00,0.00,1.05,59.85,'2022-05-29 15:36:34','',''),(805,'1','273','1',1,'Retail Sale Id 822',2656.00,0.00,0.00,4.00,228.00,'2022-05-29 15:37:31','',''),(806,'1','273','1',1,'Retail Sale Id 823',1328.00,0.00,0.00,2.00,114.00,'2022-05-29 15:54:40','',''),(807,'1','273','1',1,'Retail Sale Id 824',3997.28,0.00,0.00,6.02,343.14,'2022-05-29 16:03:03','',''),(808,'1','273','1',1,'Retail Sale Id 825',155000.00,0.00,0.00,250.00,3250.00,'2022-05-29 16:06:52','',''),(809,'1','273','1',1,'Retail Sale Id 826',1998.64,0.00,0.00,3.01,171.57,'2022-05-29 16:08:44','',''),(810,'1','273','1',1,'Retail Sale Id 827',126994.60,0.00,0.00,204.83,2662.79,'2022-05-29 16:15:48','',''),(811,'1','273','1',1,'Retail Sale Id 828',1500.64,0.00,0.00,2.26,128.82,'2022-05-29 16:17:00','',''),(812,'1','273','1',1,'Retail Sale Id 829',5312.00,0.00,0.00,8.00,456.00,'2022-05-29 16:18:27','',''),(813,'1','273','1',1,'Retail Sale Id 829',5312.00,0.00,0.00,8.00,456.00,'2022-05-29 16:18:27','',''),(814,'1','273','1',1,'Retail Sale Id 829',5312.00,0.00,0.00,8.00,456.00,'2022-05-29 16:18:27','',''),(815,'1','273','1',1,'Retail Sale Id 830',14997.80,0.00,0.00,24.19,314.47,'2022-05-29 16:20:11','',''),(816,'1','273','1',1,'Retail Sale Id 831',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 16:20:57','',''),(817,'1','273','1',1,'Retail Sale Id 832',1998.64,0.00,0.00,3.01,171.57,'2022-05-29 16:21:43','',''),(818,'1','273','1',1,'Retail Sale Id 833',1500.64,0.00,0.00,2.26,128.82,'2022-05-29 16:38:03','',''),(819,'1','273','1',1,'Retail Sale Id 834',697.20,0.00,0.00,1.05,59.85,'2022-05-29 16:38:54','',''),(820,'1','273','1',1,'Retail Sale Id 835',71300.00,0.00,0.00,115.00,1495.00,'2022-05-29 16:43:56','',''),(821,'1','273','1',1,'Retail Sale Id 836',796.80,0.00,0.00,1.20,68.40,'2022-05-29 16:58:50','',''),(822,'1','273','1',1,'Retail Sale Id 836',1328.00,0.00,0.00,2.00,114.00,'2022-05-29 16:58:50','',''),(823,'1','273','1',1,'Retail Sale Id 837',796.80,0.00,0.00,1.20,68.40,'2022-05-29 17:05:37','',''),(824,'1','273','1',1,'Retail Sale Id 838',1998.64,0.00,0.00,3.01,171.57,'2022-05-29 17:07:42','',''),(825,'1','273','1',1,'Retail Sale Id 839',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 17:08:27','',''),(826,'1','273','1',1,'Retail Sale Id 840',796.80,0.00,0.00,1.20,68.40,'2022-05-29 17:09:23','',''),(827,'1','273','1',1,'Retail Sale Id 841',155000.00,0.00,0.00,250.00,3250.00,'2022-05-29 17:13:38','',''),(828,'1','273','1',1,'Retail Sale Id 842',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 17:14:51','',''),(829,'1','273','1',1,'Retail Sale Id 843',8300.00,0.00,0.00,12.50,712.50,'2022-05-29 17:15:36','',''),(830,'1','273','1',1,'Return of Retail Sale Id 841',0.00,155000.00,250.00,0.00,-3250.00,'2022-05-29 17:18:39','',''),(831,'1','273','1',1,'Retail Sale Id 844',62000.00,0.00,0.00,100.00,1300.00,'2022-05-29 17:19:20','',''),(832,'1','273','1',1,'Retail Sale Id 845',498.00,0.00,0.00,0.75,42.75,'2022-05-29 17:20:21','',''),(833,'1','273','1',1,'Retail Sale Id 846',697.20,0.00,0.00,1.05,59.85,'2022-05-29 17:38:32','',''),(834,'1','273','1',1,'Retail Sale Id 847',62000.00,0.00,0.00,100.00,1300.00,'2022-05-29 17:44:42','',''),(835,'1','273','1',1,'Retail Sale Id 848',93000.00,0.00,0.00,150.00,1950.00,'2022-05-29 17:45:19','',''),(836,'1','273','1',1,'Retail Sale Id 849',1998.64,0.00,0.00,3.01,171.57,'2022-05-29 17:46:12','',''),(837,'1','273','1',1,'Retail Sale Id 850',1500.64,0.00,0.00,2.26,128.82,'2022-05-29 17:47:19','',''),(838,'1','273','1',1,'Retail Sale Id 851',3997.28,0.00,0.00,6.02,343.14,'2022-05-29 17:53:31','',''),(839,'1','273','1',1,'Retail Sale Id 852',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 18:06:47','',''),(840,'1','273','1',1,'Retail Sale Id 853',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 18:12:25','',''),(841,'1','273','1',1,'Retail Sale Id 854',1002.64,0.00,0.00,1.51,86.07,'2022-05-29 18:13:13','',''),(842,'1','273','1',1,'Retail Sale Id 855',849.92,0.00,0.00,1.28,72.96,'2022-05-29 18:51:31','',''),(843,'1','273','1',1,'Retail Sale Id 856',11998.48,0.00,0.00,18.07,1029.99,'2022-05-30 06:52:15','',''),(844,'1','273','1',1,'Retail Sale Id 857',68200.00,0.00,0.00,110.00,1430.00,'2022-05-30 07:14:37','',''),(845,'1','273','1',1,'Retail Sale Id 858',210800.00,0.00,0.00,340.00,4420.00,'2022-05-30 07:23:48','',''),(846,'1','273','1',1,'Retail Sale Id 859',93000.00,0.00,0.00,150.00,1950.00,'2022-05-30 07:24:27','',''),(847,'1','273','1',1,'Retail Sale Id 860',124000.00,0.00,0.00,200.00,2600.00,'2022-05-30 07:33:35','',''),(848,'1','273','1',1,'Retail Sale Id 861',8499.20,0.00,0.00,12.80,729.60,'2022-05-30 07:36:06','',''),(849,'1','273','1',1,'Retail Sale Id 862',4999.92,0.00,0.00,7.53,429.21,'2022-05-30 07:39:01','',''),(850,'1','273','1',1,'Retail Sale Id 863',3001.28,0.00,0.00,4.52,257.64,'2022-05-30 07:56:09','',''),(851,'1','273','1',1,'Retail Sale Id 864',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 07:58:53','',''),(852,'1','273','1',1,'Retail Sale Id 865',8001.20,0.00,0.00,12.05,686.85,'2022-05-30 08:05:16','',''),(853,'1','273','1',1,'Retail Sale Id 867',2662.64,0.00,0.00,4.01,228.57,'2022-05-30 08:22:12','',''),(854,'1','273','1',1,'Retail Sale Id 868',1328.00,0.00,0.00,2.00,114.00,'2022-05-30 08:23:50','',''),(855,'1','273','1',1,'Retail Sale Id 869',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 08:26:10','',''),(856,'1','273','1',1,'Retail Sale Id 871',697.20,0.00,0.00,1.05,59.85,'2022-05-30 08:30:15','',''),(857,'1','273','1',1,'Retail Sale Id 872',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 08:31:16','',''),(858,'1','273','1',1,'Retail Sale Id 873',3320.00,0.00,0.00,5.00,285.00,'2022-05-30 08:43:38','',''),(859,'1','273','1',1,'Retail Sale Id 874',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 08:52:45','',''),(860,'1','273','1',1,'Retail Sale Id 875',2702.48,0.00,0.00,4.07,231.99,'2022-05-30 08:56:00','',''),(861,'1','273','1',1,'Retail Sale Id 876',5976.00,0.00,0.00,9.00,513.00,'2022-05-30 08:59:01','',''),(862,'1','273','1',1,'Retail Sale Id 877',62000.00,0.00,0.00,100.00,1300.00,'2022-05-30 09:03:48','',''),(863,'1','273','1',1,'Retail Sale Id 879',8300.00,0.00,0.00,12.50,712.50,'2022-05-30 09:37:05','',''),(864,'1','273','1',1,'Retail Sale Id 880',1201.84,0.00,0.00,1.81,103.17,'2022-05-30 10:04:42','',''),(865,'1','273','1',1,'Retail Sale Id 881',93000.00,0.00,0.00,150.00,1950.00,'2022-05-30 10:16:30','',''),(866,'1','273','1',1,'Retail Sale Id 883',93000.00,0.00,0.00,150.00,1950.00,'2022-05-30 10:18:38','',''),(867,'1','273','1',1,'Retail Sale Id 884',7968.00,0.00,0.00,12.00,684.00,'2022-05-30 10:24:22','',''),(868,'1','273','1',1,'Retail Sale Id 884',7968.00,0.00,0.00,12.00,684.00,'2022-05-30 10:24:22','',''),(869,'1','273','1',1,'Retail Sale Id 885',8300.00,0.00,0.00,12.50,712.50,'2022-05-30 10:27:18','',''),(870,'1','273','1',1,'Retail Sale Id 886',100440.00,0.00,0.00,162.00,2106.00,'2022-05-30 10:30:41','',''),(871,'1','273','1',1,'Retail Sale Id 887',93000.00,0.00,0.00,150.00,1950.00,'2022-05-30 10:31:43','',''),(872,'1','273','1',1,'Retail Sale Id 888',8300.00,0.00,0.00,12.50,712.50,'2022-05-30 10:38:47','',''),(873,'1','273','1',1,'Retail Sale Id 889',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 10:42:16','',''),(874,'1','273','1',1,'Retail Sale Id 891',2662.64,0.00,0.00,4.01,228.57,'2022-05-30 10:56:46','',''),(875,'1','273','1',1,'Retail Sale Id 892',3320.00,0.00,0.00,5.00,285.00,'2022-05-30 11:09:23','',''),(876,'1','273','1',1,'Retail Sale Id 892',4648.00,0.00,0.00,7.00,399.00,'2022-05-30 11:09:23','',''),(877,'1','273','1',1,'Retail Sale Id 893',8300.00,0.00,0.00,12.50,712.50,'2022-05-30 11:26:20','',''),(878,'1','273','1',1,'Retail Sale Id 894',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 12:01:41','',''),(879,'1','273','1',1,'Retail Sale Id 895',93000.00,0.00,0.00,150.00,1950.00,'2022-05-30 12:09:26','',''),(880,'1','273','1',1,'Retail Sale Id 896',62000.00,0.00,0.00,100.00,1300.00,'2022-05-30 12:10:51','',''),(881,'1','273','1',1,'Retail Sale Id 897',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 13:09:25','',''),(882,'1','273','1',1,'Retail Sale Id 898',6640.00,0.00,0.00,10.00,570.00,'2022-05-30 13:10:38','',''),(883,'1','273','1',1,'Retail Sale Id 899',3320.00,0.00,0.00,5.00,285.00,'2022-05-30 13:11:44','',''),(884,'1','273','1',1,'Retail Sale Id 900',1500.64,0.00,0.00,2.26,128.82,'2022-05-30 13:15:39','',''),(885,'1','273','1',1,'Retail Sale Id 901',73160.00,0.00,0.00,118.00,1534.00,'2022-05-30 13:19:49','',''),(886,'1','273','1',1,'Retail Sale Id 902',74400.00,0.00,0.00,120.00,1560.00,'2022-05-30 13:21:11','',''),(887,'1','273','1',1,'Retail Sale Id 903',155000.00,0.00,0.00,250.00,3250.00,'2022-05-30 13:22:49','',''),(888,'1','273','1',1,'Retail Sale Id 904',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 13:40:43','',''),(889,'1','273','1',1,'Retail Sale Id 905',8300.00,0.00,0.00,12.50,712.50,'2022-05-30 13:42:39','',''),(890,'1','273','1',1,'Retail Sale Id 906',97608.00,0.00,0.00,147.00,8379.00,'2022-05-30 14:07:00','',''),(891,'1','273','1',1,'Retail Sale Id 907',60760.00,0.00,0.00,98.00,1274.00,'2022-05-30 14:09:17','',''),(892,'1','273','1',1,'Return of Retail Sale Id 906',0.00,97608.00,147.00,0.00,-8379.00,'2022-05-30 14:11:57','',''),(893,'1','273','1',1,'Retail Sale Id 908',91140.00,0.00,0.00,147.00,1911.00,'2022-05-30 14:12:42','',''),(894,'1','273','1',1,'Retail Sale Id 909',93000.00,0.00,0.00,150.00,1950.00,'2022-05-30 14:24:43','',''),(895,'1','273','1',1,'Retail Sale Id 910',101680.00,0.00,0.00,164.00,2132.00,'2022-05-30 14:31:48','',''),(896,'1','273','1',1,'Retail Sale Id 911',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 14:32:53','',''),(897,'1','273','1',1,'Retail Sale Id 912',8300.00,0.00,0.00,12.50,712.50,'2022-05-30 14:38:00','',''),(898,'1','273','1',1,'Return of Retail Sale Id 910',0.00,101680.00,164.00,0.00,-2132.00,'2022-05-30 14:57:31','',''),(899,'1','273','1',1,'Retail Sale Id 913',71920.00,0.00,0.00,116.00,1508.00,'2022-05-30 14:58:21','',''),(900,'1','273','1',1,'Retail Sale Id 914',93000.00,0.00,0.00,150.00,1950.00,'2022-05-30 15:17:26','',''),(901,'1','273','1',1,'Retail Sale Id 915',62000.00,0.00,0.00,100.00,1300.00,'2022-05-30 15:17:55','',''),(902,'1','273','1',1,'Retail Sale Id 916',4203.12,0.00,0.00,6.33,360.81,'2022-05-30 15:19:12','',''),(903,'1','273','1',1,'Retail Sale Id 917',22995.80,0.00,0.00,37.09,482.17,'2022-05-30 15:27:01','',''),(904,'1','273','1',1,'Retail Sale Id 918',37200.00,0.00,0.00,60.00,780.00,'2022-05-30 15:35:01','',''),(905,'1','273','1',1,'Retail Sale Id 920',3001.28,0.00,0.00,4.52,257.64,'2022-05-30 15:35:56','',''),(906,'1','273','1',1,'Retail Sale Id 921',3984.00,0.00,0.00,6.00,342.00,'2022-05-30 15:36:46','',''),(907,'1','273','1',1,'Retail Sale Id 922',8300.00,0.00,0.00,12.50,712.50,'2022-05-30 15:38:15','',''),(908,'1','273','1',1,'Retail Sale Id 923',3320.00,0.00,0.00,5.00,285.00,'2022-05-30 15:39:01','',''),(909,'1','273','1',1,'Retail Sale Id 924',66960.00,0.00,0.00,108.00,1404.00,'2022-05-30 15:49:45','',''),(910,'1','273','1',1,'Retail Sale Id 926',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 15:54:03','',''),(911,'1','273','1',1,'Retail Sale Id 927',903.04,0.00,0.00,1.36,77.52,'2022-05-30 15:55:21','',''),(912,'1','273','1',1,'Retail Sale Id 928',27280.00,0.00,0.00,44.00,572.00,'2022-05-30 15:56:39','',''),(913,'1','273','1',1,'Retail Sale Id 929',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 15:57:40','',''),(914,'1','273','1',1,'Retail Sale Id 930',1201.84,0.00,0.00,1.81,103.17,'2022-05-30 16:19:29','',''),(915,'1','273','1',1,'Retail Sale Id 930',1401.04,0.00,0.00,2.11,120.27,'2022-05-30 16:19:29','',''),(916,'1','273','1',1,'Retail Sale Id 931',1328.00,0.00,0.00,2.00,114.00,'2022-05-30 16:22:29','',''),(917,'1','273','1',1,'Retail Sale Id 931',1328.00,0.00,0.00,2.00,114.00,'2022-05-30 16:22:29','',''),(918,'1','273','1',1,'Retail Sale Id 932',4999.92,0.00,0.00,7.53,429.21,'2022-05-30 16:28:03','',''),(919,'1','273','1',1,'Retail Sale Id 933',8300.00,0.00,0.00,12.50,712.50,'2022-05-30 16:29:36','',''),(920,'1','273','1',1,'Retail Sale Id 934',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 16:30:59','',''),(921,'1','273','1',1,'Retail Sale Id 935',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 16:38:46','',''),(922,'1','273','1',1,'Retail Sale Id 936',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 16:42:34','',''),(923,'1','273','1',1,'Retail Sale Id 937',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 16:44:33','',''),(924,'1','273','1',1,'Retail Sale Id 938',62000.00,0.00,0.00,100.00,1300.00,'2022-05-30 16:45:30','',''),(925,'1','273','1',1,'Retail Sale Id 939',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 16:47:57','',''),(926,'1','273','1',1,'Retail Sale Id 940',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 16:48:56','',''),(927,'1','273','1',1,'Retail Sale Id 941',4648.00,0.00,0.00,7.00,399.00,'2022-05-30 16:50:51','',''),(928,'1','273','1',1,'Retail Sale Id 942',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 16:53:59','',''),(929,'1','273','1',1,'Retail Sale Id 943',6640.00,0.00,0.00,10.00,570.00,'2022-05-30 16:56:52','',''),(930,'1','273','1',1,'Retail Sale Id 943',8300.00,0.00,0.00,12.50,712.50,'2022-05-30 16:56:52','',''),(931,'1','273','1',1,'Retail Sale Id 944',1328.00,0.00,0.00,2.00,114.00,'2022-05-30 17:06:33','',''),(932,'1','273','1',1,'Retail Sale Id 946',3997.28,0.00,0.00,6.02,343.14,'2022-05-30 17:10:03','',''),(933,'1','273','1',1,'Retail Sale Id 947',71300.00,0.00,0.00,115.00,1495.00,'2022-05-30 17:11:46','',''),(934,'1','273','1',1,'Retail Sale Id 948',93000.00,0.00,0.00,150.00,1950.00,'2022-05-30 17:14:58','',''),(935,'1','273','1',1,'Retail Sale Id 949',62000.00,0.00,0.00,100.00,1300.00,'2022-05-30 17:16:13','',''),(936,'1','273','1',1,'Retail Sale Id 950',697.20,0.00,0.00,1.05,59.85,'2022-05-30 17:18:04','',''),(937,'1','273','1',1,'Retail Sale Id 951',1301.44,0.00,0.00,1.96,111.72,'2022-05-30 17:21:17','',''),(938,'1','273','1',1,'Retail Sale Id 952',2503.28,0.00,0.00,3.77,214.89,'2022-05-30 17:27:32','',''),(939,'1','273','1',1,'Retail Sale Id 953',1500.64,0.00,0.00,2.26,128.82,'2022-05-30 17:30:34','',''),(940,'1','273','1',1,'Retail Sale Id 954',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 17:31:51','',''),(941,'1','273','1',1,'Retail Sale Id 955',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 17:32:43','',''),(942,'1','273','1',1,'Retail Sale Id 956',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 17:37:25','',''),(943,'1','273','1',1,'Retail Sale Id 957',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 17:38:32','',''),(944,'1','273','1',1,'Retail Sale Id 959',664.00,0.00,0.00,1.00,57.00,'2022-05-30 17:40:41','',''),(945,'1','273','1',1,'Retail Sale Id 959',2656.00,0.00,0.00,4.00,228.00,'2022-05-30 17:40:41','',''),(946,'1','273','1',1,'Retail Sale Id 960',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 17:42:21','',''),(947,'1','273','1',1,'Retail Sale Id 961',110360.00,0.00,0.00,178.00,2314.00,'2022-05-30 17:49:24','',''),(948,'1','273','1',1,'Retail Sale Id 962',27900.00,0.00,0.00,45.00,585.00,'2022-05-30 17:51:28','',''),(949,'1','273','1',1,'Retail Sale Id 963',4340.00,0.00,0.00,7.00,91.00,'2022-05-30 17:56:38','',''),(950,'1','273','1',1,'Retail Sale Id 964',31000.00,0.00,0.00,50.00,650.00,'2022-05-30 18:04:27','',''),(951,'1','273','1',1,'Retail Sale Id 965',1998.64,0.00,0.00,3.01,171.57,'2022-05-30 18:06:54','',''),(952,'1','273','1',1,'Retail Sale Id 966',1002.64,0.00,0.00,1.51,86.07,'2022-05-30 18:15:32','',''),(953,'1','273','1',1,'Retail Sale Id 966',1201.84,0.00,0.00,1.81,103.17,'2022-05-30 18:15:32','',''),(954,'1','273','1',1,'Retail Sale Id 967',3997.28,0.00,0.00,6.02,343.14,'2022-05-30 18:16:48','',''),(955,'1','273','1',1,'Retail Sale Id 968',31000.00,0.00,0.00,50.00,650.00,'2022-05-30 18:25:44','',''),(956,'1','273','1',1,'Retail Sale Id 969',2503.28,0.00,0.00,3.77,214.89,'2022-05-30 18:27:17','',''),(957,'1','273','1',1,'Retail Sale Id 971',697.20,0.00,0.00,1.05,59.85,'2022-05-30 18:28:47','',''),(958,'1','273','1',1,'Retail Sale Id 972',8300.00,0.00,0.00,12.50,712.50,'2022-05-30 18:35:55','',''),(959,'1','273','1',1,'Return of Retail Sale Id 928',0.00,27280.00,44.00,0.00,-572.00,'2022-05-30 20:05:37','',''),(960,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,6070.00,10.00,0.00,0.00,'2022-05-31 07:10:35','',''),(961,'1','273',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,10.00,0.00,'2022-05-31 07:16:27','',''),(962,'1','273','1',1,'Received from bridging 3',0.00,0.00,10.00,0.00,0.00,'2022-05-31 07:16:27','',''),(963,'1','273','1',1,'Retail Sale Id 978',13997.12,0.00,0.00,21.08,1201.56,'2022-05-31 16:49:38','',''),(964,'1','273','1',1,'Retail Sale Id 981',54591.00,0.00,0.00,88.05,1144.65,'2022-05-31 16:52:46','',''),(965,'1','273','1',1,'Retail Sale Id 982',64232.00,0.00,0.00,103.60,1346.80,'2022-05-31 16:56:35','',''),(966,'1','273','1',1,'Retail Sale Id 983',11095.44,0.00,0.00,16.71,952.47,'2022-05-31 16:58:57','',''),(967,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,16350000.00,25000.00,0.00,0.00,'2022-06-02 09:11:14','',''),(968,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,15952368.00,24392.00,0.00,0.00,'2022-06-02 09:19:13','',''),(969,'1','273',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,23000.00,0.00,'2022-06-02 09:21:01','',''),(970,'1','273','1',1,'Received from bridging 5',0.00,0.00,23000.00,0.00,0.00,'2022-06-02 09:21:01','',''),(971,'1','273','1',1,'Retail Sale Id 984',174000.00,0.00,0.00,250.00,10500.00,'2022-06-02 09:26:02','',''),(972,'1','273','1',1,'Retail Sale Id 985',174000.00,0.00,0.00,250.00,10500.00,'2022-06-02 09:46:20','',''),(973,'1','273','1',1,'Retail Sale Id 986',4440.00,0.00,0.00,6.00,516.00,'2022-06-02 09:48:05','',''),(974,'1','273','1',1,'Retail Sale Id 987',34800.00,0.00,0.00,50.00,2100.00,'2022-06-02 09:48:49','',''),(975,'1','273','1',1,'Retail Sale Id 988',2197.80,0.00,0.00,2.97,255.42,'2022-06-02 09:49:57','',''),(976,'1','273','1',1,'Retail Sale Id 989',999.00,0.00,0.00,1.35,116.10,'2022-06-02 09:50:59','',''),(977,'1','273','1',1,'Retail Sale Id 990',7000.40,0.00,0.00,9.46,813.56,'2022-06-02 09:52:30','',''),(978,'1','273','1',1,'Retail Sale Id 991',1502.20,0.00,0.00,2.03,174.58,'2022-06-02 09:53:19','',''),(979,'1','273','1',1,'Retail Sale Id 992',119016.00,0.00,0.00,171.00,7182.00,'2022-06-02 09:56:50','',''),(980,'1','273','1',1,'Retail Sale Id 993',356352.00,0.00,0.00,512.00,21504.00,'2022-06-02 10:03:15','',''),(981,'1','273','1',1,'Retail Sale Id 994',740.00,0.00,0.00,1.00,86.00,'2022-06-02 10:04:35','',''),(982,'1','273','1',1,'Retail Sale Id 995',174000.00,0.00,0.00,250.00,10500.00,'2022-06-02 10:06:58','',''),(983,'1','273','1',1,'Retail Sale Id 996',34800.00,0.00,0.00,50.00,2100.00,'2022-06-02 10:12:25','',''),(984,'1','273','1',1,'Retail Sale Id 997',2501.20,0.00,0.00,3.38,290.68,'2022-06-02 10:16:21','',''),(985,'1','273','1',1,'Retail Sale Id 998',740.00,0.00,0.00,1.00,86.00,'2022-06-02 10:17:24','',''),(986,'1','273','1',1,'Return of Retail Sale Id 998',0.00,740.00,1.00,0.00,-86.00,'2022-06-02 10:19:02','',''),(987,'1','273','1',1,'Retail Sale Id 999',747.40,0.00,0.00,1.01,86.86,'2022-06-02 10:20:02','',''),(988,'1','273','1',1,'Retail Sale Id 1000',1302.40,0.00,0.00,1.76,151.36,'2022-06-02 10:21:18','',''),(989,'1','273','1',1,'Retail Sale Id 1001',4440.00,0.00,0.00,6.00,516.00,'2022-06-02 10:23:26','',''),(990,'1','273','1',1,'Retail Sale Id 1002',100224.00,0.00,0.00,144.00,6048.00,'2022-06-02 10:32:59','',''),(991,'1','273','1',1,'Retail Sale Id 1003',999.00,0.00,0.00,1.35,116.10,'2022-06-02 10:47:45','',''),(992,'1','273','1',1,'Retail Sale Id 1004',208800.00,0.00,0.00,300.00,12600.00,'2022-06-02 10:51:27','',''),(993,'1','273','1',1,'Retail Sale Id 1005',2220.00,0.00,0.00,3.00,258.00,'2022-06-02 10:55:26','',''),(994,'1','273','1',1,'Retail Sale Id 1006',55680.00,0.00,0.00,80.00,3360.00,'2022-06-02 10:57:41','',''),(995,'1','273','1',1,'Retail Sale Id 1007',9250.00,0.00,0.00,12.50,1075.00,'2022-06-02 10:59:08','',''),(996,'1','273','1',1,'Retail Sale Id 1008',2784.00,0.00,0.00,4.00,168.00,'2022-06-02 11:02:17','',''),(997,'1','273','1',1,'Retail Sale Id 1009',747.40,0.00,0.00,1.01,86.86,'2022-06-02 11:06:02','',''),(998,'1','273','1',1,'Retail Sale Id 1010',3596.40,0.00,0.00,4.86,417.96,'2022-06-02 11:08:20','',''),(999,'1','273','1',1,'Retail Sale Id 1011',5180.00,0.00,0.00,7.00,602.00,'2022-06-02 11:11:32','',''),(1000,'1','273','1',1,'Retail Sale Id 1012',2960.00,0.00,0.00,4.00,344.00,'2022-06-02 11:16:47','',''),(1001,'1','273','1',1,'Retail Sale Id 1013',5002.40,0.00,0.00,6.76,581.36,'2022-06-02 11:21:59','',''),(1002,'1','273','1',1,'Retail Sale Id 1014',1198.80,0.00,0.00,1.62,139.32,'2022-06-02 11:24:58','',''),(1003,'1','273','1',1,'Retail Sale Id 1015',1480.00,0.00,0.00,2.00,172.00,'2022-06-02 11:36:54','',''),(1004,'1','273','1',1,'Retail Sale Id 1016',8140.00,0.00,0.00,11.00,946.00,'2022-06-02 11:40:37','',''),(1005,'1','273','1',1,'Retail Sale Id 1017',348000.00,0.00,0.00,500.00,21000.00,'2022-06-02 11:45:56','',''),(1006,'1','273','1',1,'Retail Sale Id 1018',174000.00,0.00,0.00,250.00,10500.00,'2022-06-02 11:47:16','',''),(1007,'1','273','1',1,'Retail Sale Id 1019',2997.00,0.00,0.00,4.05,348.30,'2022-06-02 11:49:37','',''),(1008,'1','273','1',1,'Retail Sale Id 1020',999.00,0.00,0.00,1.35,116.10,'2022-06-02 11:53:59','',''),(1009,'1','273','1',1,'Retail Sale Id 1021',3700.00,0.00,0.00,5.00,430.00,'2022-06-02 11:56:06','',''),(1010,'1','273','1',1,'Retail Sale Id 1022',17020.00,0.00,0.00,23.00,1978.00,'2022-06-02 11:58:32','',''),(1011,'1','273','1',1,'Retail Sale Id 1023',1480.00,0.00,0.00,2.00,172.00,'2022-06-02 12:04:01','',''),(1012,'1','273','1',1,'Return of Retail Sale Id 995',0.00,174000.00,250.00,0.00,-10500.00,'2022-06-02 12:36:25','',''),(1013,'1','273','1',1,'Retail Sale Id 1024',2220.00,0.00,0.00,3.00,258.00,'2022-06-02 12:37:49','',''),(1014,'1','273','1',1,'Retail Sale Id 1025',9250.00,0.00,0.00,12.50,1075.00,'2022-06-02 12:55:23','',''),(1015,'1','273','1',1,'Retail Sale Id 1026',2249.60,0.00,0.00,3.04,261.44,'2022-06-02 12:57:06','',''),(1016,'1','273','1',1,'Retail Sale Id 1027',902.80,0.00,0.00,1.22,104.92,'2022-06-02 14:14:22','',''),(1017,'1','273','1',1,'Retail Sale Id 1029',8880.00,0.00,0.00,12.00,1032.00,'2022-06-02 14:23:45','',''),(1018,'1','273','1',1,'Retail Sale Id 1030',1502.20,0.00,0.00,2.03,174.58,'2022-06-02 14:31:38','',''),(1019,'1','273','1',1,'Retail Sale Id 1031',1502.20,0.00,0.00,2.03,174.58,'2022-06-02 14:32:58','',''),(1020,'1','273','1',1,'Retail Sale Id 1032',999.00,0.00,0.00,1.35,116.10,'2022-06-02 14:58:03','',''),(1021,'1','273','1',1,'Retail Sale Id 1033',9250.00,0.00,0.00,12.50,1075.00,'2022-06-02 14:59:15','',''),(1022,'1','273','1',1,'Retail Sale Id 1034',999.00,0.00,0.00,1.35,116.10,'2022-06-02 15:01:14','',''),(1023,'1','273','1',1,'Retail Sale Id 1035',3700.00,0.00,0.00,5.00,430.00,'2022-06-02 15:02:47','',''),(1024,'1','273','1',1,'Retail Sale Id 1036',9620.00,0.00,0.00,13.00,1118.00,'2022-06-02 15:05:41','',''),(1025,'1','273','1',1,'Retail Sale Id 1037',5920.00,0.00,0.00,8.00,688.00,'2022-06-02 15:11:49','',''),(1026,'1','273','1',1,'Return of Retail Sale Id 1037',0.00,5920.00,8.00,0.00,-688.00,'2022-06-02 15:13:19','',''),(1027,'1','273','1',1,'Retail Sale Id 1038',5920.00,0.00,0.00,8.00,688.00,'2022-06-02 15:14:18','',''),(1028,'1','273','1',1,'Retail Sale Id 1039',2220.00,0.00,0.00,3.00,258.00,'2022-06-02 15:26:52','',''),(1029,'1','273','1',1,'Retail Sale Id 1039',9250.00,0.00,0.00,12.50,1075.00,'2022-06-02 15:26:52','',''),(1030,'1','273','1',1,'Retail Sale Id 1040',2501.20,0.00,0.00,3.38,290.68,'2022-06-02 15:36:08','',''),(1031,'1','273','1',1,'Retail Sale Id 1041',1502.20,0.00,0.00,2.03,174.58,'2022-06-02 15:42:15','',''),(1032,'1','273','1',1,'Retail Sale Id 1042',9250.00,0.00,0.00,12.50,1075.00,'2022-06-02 15:44:50','',''),(1033,'1','273','1',1,'Retail Sale Id 1044',2997.00,0.00,0.00,4.05,348.30,'2022-06-02 15:51:03','',''),(1034,'1','273','1',1,'Retail Sale Id 1045',1998.00,0.00,0.00,2.70,232.20,'2022-06-02 15:51:56','',''),(1035,'1','273','1',1,'Retail Sale Id 1046',2997.00,0.00,0.00,4.05,348.30,'2022-06-02 15:52:47','',''),(1036,'1','273','1',1,'Retail Sale Id 1047',747.40,0.00,0.00,1.01,86.86,'2022-06-02 15:55:05','',''),(1037,'1','273','1',1,'Retail Sale Id 1048',9250.00,0.00,0.00,12.50,1075.00,'2022-06-02 16:00:30','',''),(1038,'1','273','1',1,'Retail Sale Id 1049',1480.00,0.00,0.00,2.00,172.00,'2022-06-02 16:05:11','',''),(1039,'1','273','1',1,'Retail Sale Id 1050',1480.00,0.00,0.00,2.00,172.00,'2022-06-02 16:08:05','',''),(1040,'1','273','1',1,'Retail Sale Id 1051',6001.40,0.00,0.00,8.11,697.46,'2022-06-02 16:09:31','',''),(1041,'1','273','1',1,'Retail Sale Id 1052',5949.60,0.00,0.00,8.04,691.44,'2022-06-02 16:37:37','',''),(1042,'1','273','1',1,'Retail Sale Id 1053',198360.00,0.00,0.00,285.00,11970.00,'2022-06-02 16:50:17','',''),(1043,'1','273','1',1,'Retail Sale Id 1054',6660.00,0.00,0.00,9.00,774.00,'2022-06-02 16:51:41','',''),(1044,'1','273','1',1,'Retail Sale Id 1055',1998.00,0.00,0.00,2.70,232.20,'2022-06-02 16:56:54','',''),(1045,'1','273','1',1,'Retail Sale Id 1056',3500.20,0.00,0.00,4.73,406.78,'2022-06-02 17:06:50','',''),(1046,'1','273','1',1,'Retail Sale Id 1057',5002.40,0.00,0.00,6.76,581.36,'2022-06-02 17:09:46','',''),(1047,'1','273','1',1,'Retail Sale Id 1058',1502.20,0.00,0.00,2.03,174.58,'2022-06-02 17:11:54','',''),(1048,'1','273','1',1,'Retail Sale Id 1059',2197.80,0.00,0.00,2.97,255.42,'2022-06-02 17:14:24','',''),(1049,'1','273','1',1,'Retail Sale Id 1060',1998.00,0.00,0.00,2.70,232.20,'2022-06-02 17:18:29','',''),(1050,'1','273','1',1,'Retail Sale Id 1061',1480.00,0.00,0.00,2.00,172.00,'2022-06-02 17:26:27','',''),(1051,'1','273','1',1,'Retail Sale Id 1062',740.00,0.00,0.00,1.00,86.00,'2022-06-02 17:29:19','',''),(1052,'1','273','1',1,'Retail Sale Id 1063',2220.00,0.00,0.00,3.00,258.00,'2022-06-02 17:30:12','',''),(1053,'1','273','1',1,'Retail Sale Id 1064',3500.20,0.00,0.00,4.73,406.78,'2022-06-02 17:35:25','',''),(1054,'1','273','1',1,'Retail Sale Id 1065',1502.20,0.00,0.00,2.03,174.58,'2022-06-02 17:37:39','',''),(1055,'1','273','1',1,'Retail Sale Id 1066',3500.20,0.00,0.00,4.73,406.78,'2022-06-02 17:44:37','',''),(1056,'1','273','1',1,'Retail Sale Id 1067',3700.00,0.00,0.00,5.00,430.00,'2022-06-02 17:45:48','',''),(1057,'1','273','1',1,'Retail Sale Id 1068',7400.00,0.00,0.00,10.00,860.00,'2022-06-02 17:53:31','',''),(1058,'1','273','1',1,'Retail Sale Id 1069',999.00,0.00,0.00,1.35,116.10,'2022-06-02 17:57:34','',''),(1059,'1','273','1',1,'Retail Sale Id 1070',1998.00,0.00,0.00,2.70,232.20,'2022-06-02 17:58:22','',''),(1060,'1','273','1',1,'Retail Sale Id 1071',747.40,0.00,0.00,1.01,86.86,'2022-06-02 17:59:23','',''),(1061,'1','273','1',1,'Return of Retail Sale Id 1008',0.00,2784.00,4.00,0.00,-168.00,'2022-06-02 18:39:31','',''),(1062,'1','273','1',1,'Retail Sale Id 1072',2784.00,0.00,0.00,4.00,168.00,'2022-06-02 18:44:02','',''),(1063,'1','273','1',1,'Return of Retail Sale Id 996',0.00,34800.00,50.00,0.00,-2100.00,'2022-06-02 18:47:10','',''),(1064,'1','273','1',1,'Retail Sale Id 1073',34298.88,0.00,0.00,49.28,2069.76,'2022-06-02 18:47:59','',''),(1065,'1','273','1',1,'Retail Sale Id 1074',13001.80,0.00,0.00,17.57,1511.02,'2022-06-03 06:57:51','',''),(1066,'1','273','1',1,'Retail Sale Id 1075',4003.40,0.00,0.00,5.41,465.26,'2022-06-03 06:58:51','',''),(1067,'1','273','1',1,'Retail Sale Id 1076',8880.00,0.00,0.00,12.00,1032.00,'2022-06-03 07:02:51','',''),(1068,'1','273','1',1,'Retail Sale Id 1078',1502.20,0.00,0.00,2.03,174.58,'2022-06-03 07:06:38','',''),(1069,'1','273','1',1,'Retail Sale Id 1079',999.00,0.00,0.00,1.35,116.10,'2022-06-03 07:15:06','',''),(1070,'1','273','1',1,'Return of Retail Sale Id 1079',0.00,999.00,1.35,0.00,-116.10,'2022-06-03 07:37:54','',''),(1071,'1','273','1',1,'Retail Sale Id 1080',747.40,0.00,0.00,1.01,86.86,'2022-06-03 07:38:27','',''),(1072,'1','273','1',1,'Retail Sale Id 1081',1502.20,0.00,0.00,2.03,174.58,'2022-06-03 08:14:27','',''),(1073,'1','273','1',1,'Retail Sale Id 1082',1998.00,0.00,0.00,2.70,232.20,'2022-06-03 08:30:52','',''),(1074,'1','273','1',1,'Retail Sale Id 1083',2960.00,0.00,0.00,4.00,344.00,'2022-06-03 08:32:42','',''),(1075,'1','273','1',1,'Retail Sale Id 1084',11840.00,0.00,0.00,16.00,1376.00,'2022-06-03 08:38:00','',''),(1076,'1','273','1',1,'Retail Sale Id 1085',3700.00,0.00,0.00,5.00,430.00,'2022-06-03 08:42:31','',''),(1077,'1','273','1',1,'Retail Sale Id 1086',7400.00,0.00,0.00,10.00,860.00,'2022-06-03 08:44:32','',''),(1078,'1','273','1',1,'Retail Sale Id 1087',5202.20,0.00,0.00,7.03,604.58,'2022-06-03 08:49:52','',''),(1079,'1','273','1',1,'Retail Sale Id 1088',9250.00,0.00,0.00,12.50,1075.00,'2022-06-03 09:00:56','',''),(1080,'1','273','1',1,'Retail Sale Id 1088',9250.00,0.00,0.00,12.50,1075.00,'2022-06-03 09:00:56','',''),(1081,'1','273','1',1,'Retail Sale Id 1089',9250.00,0.00,0.00,12.50,1075.00,'2022-06-03 09:03:52','',''),(1082,'1','273','1',1,'Retail Sale Id 1090',9250.00,0.00,0.00,12.50,1075.00,'2022-06-03 09:09:14','',''),(1083,'1','273','1',1,'Retail Sale Id 1092',999.00,0.00,0.00,1.35,116.10,'2022-06-03 09:23:19','',''),(1084,'1','273','1',1,'Retail Sale Id 1093',999.00,0.00,0.00,1.35,116.10,'2022-06-03 09:31:08','',''),(1085,'1','273','1',1,'Retail Sale Id 1094',1502.20,0.00,0.00,2.03,174.58,'2022-06-03 09:42:42','',''),(1086,'1','273','1',1,'Retail Sale Id 1095',799.20,0.00,0.00,1.08,92.88,'2022-06-03 09:44:38','',''),(1087,'1','273','1',1,'Retail Sale Id 1096',2220.00,0.00,0.00,3.00,258.00,'2022-06-03 09:49:48','',''),(1088,'1','273','1',1,'Retail Sale Id 1097',29232.00,0.00,0.00,42.00,1764.00,'2022-06-03 09:51:21','',''),(1089,'1','273','1',1,'Retail Sale Id 1098',88392.00,0.00,0.00,127.00,5334.00,'2022-06-03 10:01:32','',''),(1090,'1','273','1',1,'Retail Sale Id 1099',999.00,0.00,0.00,1.35,116.10,'2022-06-03 10:02:09','',''),(1091,'1','273','1',1,'Retail Sale Id 1100',1998.00,0.00,0.00,2.70,232.20,'2022-06-03 10:14:28','',''),(1092,'1','273','1',1,'Retail Sale Id 1101',9250.00,0.00,0.00,12.50,1075.00,'2022-06-03 10:43:04','',''),(1093,'1','273','1',1,'Retail Sale Id 1103',69600.00,0.00,0.00,100.00,4200.00,'2022-06-03 10:47:33','',''),(1094,'1','273','1',1,'Retail Sale Id 1104',105096.00,0.00,0.00,151.00,6342.00,'2022-06-03 10:48:41','',''),(1095,'1','273','1',1,'Retail Sale Id 1105',3700.00,0.00,0.00,5.00,430.00,'2022-06-03 11:01:33','',''),(1096,'1','273','1',1,'Retail Sale Id 1106',147552.00,0.00,0.00,212.00,8904.00,'2022-06-03 11:19:52','',''),(1097,'1','273','1',1,'Retail Sale Id 1107',1110.00,0.00,0.00,1.50,129.00,'2022-06-03 11:21:21','',''),(1098,'1','273','1',1,'Retail Sale Id 1108',747.40,0.00,0.00,1.01,86.86,'2022-06-03 11:27:52','',''),(1099,'1','273','1',1,'Retail Sale Id 1108',747.40,0.00,0.00,1.01,86.86,'2022-06-03 11:27:52','',''),(1100,'1','273','1',1,'Retail Sale Id 1109',740.00,0.00,0.00,1.00,86.00,'2022-06-03 11:55:36','',''),(1101,'1','273','1',1,'Retail Sale Id 1113',1502.20,0.00,0.00,2.03,174.58,'2022-06-03 12:13:41','',''),(1102,'1','273','1',1,'Retail Sale Id 1114',4499.20,0.00,0.00,6.08,522.88,'2022-06-03 12:26:06','',''),(1103,'1','273','1',1,'Retail Sale Id 1115',16008.00,0.00,0.00,23.00,966.00,'2022-06-03 12:36:35','',''),(1104,'1','273','1',1,'Retail Sale Id 1116',2997.00,0.00,0.00,4.05,348.30,'2022-06-03 12:43:37','',''),(1105,'1','273','1',1,'Retail Sale Id 1117',9250.00,0.00,0.00,12.50,1075.00,'2022-06-03 13:55:13','',''),(1106,'1','273','1',1,'Retail Sale Id 1118',5180.00,0.00,0.00,7.00,602.00,'2022-06-03 13:57:42','',''),(1107,'1','273','1',1,'Retail Sale Id 1120',740.00,0.00,0.00,1.00,86.00,'2022-06-03 13:58:54','',''),(1108,'1','273','1',1,'Retail Sale Id 1121',9250.00,0.00,0.00,12.50,1075.00,'2022-06-03 14:00:20','',''),(1109,'1','273','1',1,'Retail Sale Id 1122',4003.40,0.00,0.00,5.41,465.26,'2022-06-03 14:02:13','',''),(1110,'1','273','1',1,'Return of Retail Sale Id 1120',0.00,740.00,1.00,0.00,-86.00,'2022-06-03 14:04:30','',''),(1111,'1','273','1',1,'Retail Sale Id 1123',703.00,0.00,0.00,0.95,81.70,'2022-06-03 14:05:33','',''),(1112,'1','273','1',1,'Retail Sale Id 1124',740.00,0.00,0.00,1.00,86.00,'2022-06-03 14:06:42','',''),(1113,'1','273','1',1,'Retail Sale Id 1125',2997.00,0.00,0.00,4.05,348.30,'2022-06-03 14:08:22','',''),(1114,'1','273','1',1,'Retail Sale Id 1126',4440.00,0.00,0.00,6.00,516.00,'2022-06-03 14:09:38','',''),(1115,'1','273','1',1,'Retail Sale Id 1127',740.00,0.00,0.00,1.00,86.00,'2022-06-03 14:56:56','',''),(1116,'1','273','1',1,'Retail Sale Id 1128',1480.00,0.00,0.00,2.00,172.00,'2022-06-03 15:00:39','',''),(1117,'1','273','1',1,'Retail Sale Id 1128',2960.00,0.00,0.00,4.00,344.00,'2022-06-03 15:00:39','',''),(1118,'1','273','1',1,'Retail Sale Id 1129',747.40,0.00,0.00,1.01,86.86,'2022-06-03 15:13:21','',''),(1119,'1','273','1',1,'Retail Sale Id 1130',1502.20,0.00,0.00,2.03,174.58,'2022-06-03 15:23:14','',''),(1120,'1','273','1',1,'Retail Sale Id 1131',2249.60,0.00,0.00,3.04,261.44,'2022-06-03 15:25:31','',''),(1121,'1','273','1',1,'Retail Sale Id 1132',6660.00,0.00,0.00,9.00,774.00,'2022-06-03 15:46:02','',''),(1122,'1','273','1',1,'Retail Sale Id 1133',3700.00,0.00,0.00,5.00,430.00,'2022-06-03 15:48:21','',''),(1123,'1','273','1',1,'Retail Sale Id 1134',1502.20,0.00,0.00,2.03,174.58,'2022-06-03 15:55:12','',''),(1124,'1','273','1',1,'Retail Sale Id 1135',902.80,0.00,0.00,1.22,104.92,'2022-06-03 16:16:58','',''),(1125,'1','273','1',1,'Retail Sale Id 1136',17956.80,0.00,0.00,25.80,1083.60,'2022-06-03 16:28:28','',''),(1126,'1','273','1',1,'Retail Sale Id 1137',747.40,0.00,0.00,1.01,86.86,'2022-06-03 16:32:11','',''),(1127,'1','273','1',1,'Retail Sale Id 1139',4447.40,0.00,0.00,6.01,516.86,'2022-06-03 16:36:23','',''),(1128,'1','273','1',1,'Retail Sale Id 1140',1998.00,0.00,0.00,2.70,232.20,'2022-06-03 16:43:36','',''),(1129,'1','273','1',1,'Retail Sale Id 1141',2249.60,0.00,0.00,3.04,261.44,'2022-06-03 16:50:29','',''),(1130,'1','273','1',1,'Retail Sale Id 1142',2501.20,0.00,0.00,3.38,290.68,'2022-06-03 16:53:18','',''),(1131,'1','273','1',1,'Retail Sale Id 1143',7999.40,0.00,0.00,10.81,929.66,'2022-06-03 16:55:11','',''),(1132,'1','273','1',1,'Retail Sale Id 1144',999.00,0.00,0.00,1.35,116.10,'2022-06-03 16:57:33','',''),(1133,'1','273','1',1,'Retail Sale Id 1145',3480.00,0.00,0.00,5.00,210.00,'2022-06-03 16:58:39','',''),(1134,'1','273','1',1,'Retail Sale Id 1146',999.00,0.00,0.00,1.35,116.10,'2022-06-03 16:59:42','',''),(1135,'1','273','1',1,'Retail Sale Id 1147',1998.00,0.00,0.00,2.70,232.20,'2022-06-03 17:01:14','',''),(1136,'1','273','1',1,'Retail Sale Id 1148',5920.00,0.00,0.00,8.00,688.00,'2022-06-03 17:09:27','',''),(1137,'1','273','1',1,'Retail Sale Id 1149',3700.00,0.00,0.00,5.00,430.00,'2022-06-03 17:14:12','',''),(1138,'1','273','1',1,'Retail Sale Id 1150',62640.00,0.00,0.00,90.00,3780.00,'2022-06-03 17:22:06','',''),(1139,'1','273','1',1,'Retail Sale Id 1151',9250.00,0.00,0.00,12.50,1075.00,'2022-06-03 17:23:04','',''),(1140,'1','273','1',1,'Retail Sale Id 1152',3700.00,0.00,0.00,5.00,430.00,'2022-06-03 17:39:11','',''),(1141,'1','273','1',1,'Retail Sale Id 1153',2197.80,0.00,0.00,2.97,255.42,'2022-06-03 17:45:01','',''),(1142,'1','273','1',1,'Retail Sale Id 1154',1998.00,0.00,0.00,2.70,232.20,'2022-06-03 17:48:32','',''),(1143,'1','273','1',1,'Retail Sale Id 1155',2501.20,0.00,0.00,3.38,290.68,'2022-06-03 17:49:23','',''),(1144,'1','273','1',1,'Retail Sale Id 1155',2501.20,0.00,0.00,3.38,290.68,'2022-06-03 17:49:23','',''),(1145,'1','273','1',1,'Retail Sale Id 1156',1302.40,0.00,0.00,1.76,151.36,'2022-06-03 17:53:16','',''),(1146,'1','273','1',1,'Retail Sale Id 1157',3700.00,0.00,0.00,5.00,430.00,'2022-06-03 17:58:20','',''),(1147,'1','273','1',1,'Retail Sale Id 1158',1998.00,0.00,0.00,2.70,232.20,'2022-06-03 18:00:11','',''),(1148,'1','273','1',1,'Retail Sale Id 1159',1998.00,0.00,0.00,2.70,232.20,'2022-06-03 18:02:33','',''),(1149,'1','273','1',1,'Retail Sale Id 1160',999.00,0.00,0.00,1.35,116.10,'2022-06-03 18:04:55','',''),(1150,'1','273','1',1,'Retail Sale Id 1161',999.00,0.00,0.00,1.35,116.10,'2022-06-04 07:06:52','',''),(1151,'1','273','1',1,'Retail Sale Id 1162',6290.00,0.00,0.00,8.50,731.00,'2022-06-04 07:12:02','',''),(1152,'1','273','1',1,'Retail Sale Id 1163',2220.00,0.00,0.00,3.00,258.00,'2022-06-04 07:17:52','',''),(1153,'1','273','1',1,'Retail Sale Id 1164',6660.00,0.00,0.00,9.00,774.00,'2022-06-04 08:00:19','',''),(1154,'1','273','1',1,'Retail Sale Id 1165',1998.00,0.00,0.00,2.70,232.20,'2022-06-04 08:01:39','',''),(1155,'1','273','1',1,'Retail Sale Id 1166',2997.00,0.00,0.00,4.05,348.30,'2022-06-04 08:02:53','',''),(1156,'1','273','1',1,'Retail Sale Id 1167',1502.20,0.00,0.00,2.03,174.58,'2022-06-04 08:04:58','',''),(1157,'1','273','1',1,'Retail Sale Id 1168',1502.20,0.00,0.00,2.03,174.58,'2022-06-04 08:06:33','',''),(1158,'1','273','1',1,'Retail Sale Id 1169',740.00,0.00,0.00,1.00,86.00,'2022-06-04 08:08:47','',''),(1159,'1','273','1',1,'Retail Sale Id 1170',4003.40,0.00,0.00,5.41,465.26,'2022-06-04 08:13:15','',''),(1160,'1','273','1',1,'Retail Sale Id 1171',740.00,0.00,0.00,1.00,86.00,'2022-06-04 08:14:59','',''),(1161,'1','273','1',1,'Retail Sale Id 1172',1998.00,0.00,0.00,2.70,232.20,'2022-06-04 08:16:22','',''),(1162,'1','273','1',1,'Retail Sale Id 1172',2997.00,0.00,0.00,4.05,348.30,'2022-06-04 08:16:22','',''),(1163,'1','273','1',1,'Retail Sale Id 1173',2249.60,0.00,0.00,3.04,261.44,'2022-06-04 08:21:03','',''),(1164,'1','273','1',1,'Retail Sale Id 1175',1398.60,0.00,0.00,1.89,162.54,'2022-06-04 08:22:12','',''),(1165,'1','273','1',1,'Retail Sale Id 1176',8880.00,0.00,0.00,12.00,1032.00,'2022-06-04 08:28:07','',''),(1166,'1','273','1',1,'Retail Sale Id 1178',999.00,0.00,0.00,1.35,116.10,'2022-06-04 08:29:36','',''),(1167,'1','273','1',1,'Retail Sale Id 1179',4440.00,0.00,0.00,6.00,516.00,'2022-06-04 08:31:06','',''),(1168,'1','273','1',1,'Retail Sale Id 1180',69600.00,0.00,0.00,100.00,4200.00,'2022-06-04 08:41:34','',''),(1169,'1','273','1',1,'Retail Sale Id 1181',119016.00,0.00,0.00,171.00,7182.00,'2022-06-04 08:59:36','',''),(1170,'1','273','1',1,'Retail Sale Id 1182',1502.20,0.00,0.00,2.03,174.58,'2022-06-04 09:02:27','',''),(1171,'1','273','1',1,'Retail Sale Id 1183',69600.00,0.00,0.00,100.00,4200.00,'2022-06-04 09:12:32','',''),(1172,'1','273','1',1,'Retail Sale Id 1184',1480.00,0.00,0.00,2.00,172.00,'2022-06-04 09:14:30','',''),(1173,'1','273','1',1,'Retail Sale Id 1185',999.00,0.00,0.00,1.35,116.10,'2022-06-04 09:19:24','',''),(1174,'1','273','1',1,'Retail Sale Id 1186',1480.00,0.00,0.00,2.00,172.00,'2022-06-04 09:37:39','',''),(1175,'1','273','1',1,'Retail Sale Id 1187',999.00,0.00,0.00,1.35,116.10,'2022-06-04 09:42:09','',''),(1176,'1','273','1',1,'Retail Sale Id 1188',999.00,0.00,0.00,1.35,116.10,'2022-06-04 09:48:23','',''),(1177,'1','273','1',1,'Retail Sale Id 1189',4440.00,0.00,0.00,6.00,516.00,'2022-06-04 09:54:24','',''),(1178,'1','273','1',1,'Retail Sale Id 1190',3700.00,0.00,0.00,5.00,430.00,'2022-06-04 10:04:20','',''),(1179,'1','273','1',1,'Retail Sale Id 1191',999.00,0.00,0.00,1.35,116.10,'2022-06-04 10:08:58','',''),(1180,'1','273','1',1,'Retail Sale Id 1192',104400.00,0.00,0.00,150.00,6300.00,'2022-06-04 10:12:51','',''),(1181,'1','273','1',1,'Retail Sale Id 1193',2960.00,0.00,0.00,4.00,344.00,'2022-06-04 10:20:39','',''),(1182,'1','273','1',1,'Retail Sale Id 1194',9250.00,0.00,0.00,12.50,1075.00,'2022-06-04 10:25:10','',''),(1183,'1','273','1',1,'Retail Sale Id 1194',9250.00,0.00,0.00,12.50,1075.00,'2022-06-04 10:25:10','',''),(1184,'1','273','1',1,'Retail Sale Id 1195',1998.00,0.00,0.00,2.70,232.20,'2022-06-04 10:26:31','',''),(1185,'1','273','1',1,'Retail Sale Id 1196',8140.00,0.00,0.00,11.00,946.00,'2022-06-04 10:30:15','',''),(1186,'1','273','1',1,'Retail Sale Id 1197',999.00,0.00,0.00,1.35,116.10,'2022-06-04 10:32:04','',''),(1187,'1','273','1',1,'Retail Sale Id 1198',9250.00,0.00,0.00,12.50,1075.00,'2022-06-04 10:35:29','',''),(1188,'1','273','1',1,'Retail Sale Id 1199',9997.40,0.00,0.00,13.51,1161.86,'2022-06-04 10:36:40','',''),(1189,'1','273','1',1,'Retail Sale Id 1200',9250.00,0.00,0.00,12.50,1075.00,'2022-06-04 10:38:00','',''),(1190,'1','273','1',1,'Retail Sale Id 1201',999.00,0.00,0.00,1.35,116.10,'2022-06-04 10:39:02','',''),(1191,'1','273','1',1,'Retail Sale Id 1202',8880.00,0.00,0.00,12.00,1032.00,'2022-06-04 10:40:02','',''),(1192,'1','273','1',1,'Retail Sale Id 1203',999.00,0.00,0.00,1.35,116.10,'2022-06-04 10:49:30','',''),(1193,'1','273','1',1,'Retail Sale Id 1204',3700.00,0.00,0.00,5.00,430.00,'2022-06-04 10:51:44','',''),(1194,'1','273','1',1,'Retail Sale Id 1205',27840.00,0.00,0.00,40.00,1680.00,'2022-06-04 10:54:16','',''),(1195,'1','273','1',1,'Retail Sale Id 1206',3700.00,0.00,0.00,5.00,430.00,'2022-06-04 10:55:36','',''),(1196,'1','273','1',1,'Retail Sale Id 1207',4003.40,0.00,0.00,5.41,465.26,'2022-06-04 11:18:01','',''),(1197,'1','273','1',1,'Retail Sale Id 1208',1406.00,0.00,0.00,0.19,1281.74,'2022-06-04 11:26:19','',''),(1198,'1','273','1',1,'Retail Sale Id 1209',2501.20,0.00,0.00,3.38,290.68,'2022-06-04 11:39:49','',''),(1199,'1','273','1',1,'Retail Sale Id 1210',34800.00,0.00,0.00,50.00,2100.00,'2022-06-04 11:50:50','',''),(1200,'1','273','1',1,'Retail Sale Id 1211',2301.40,0.00,0.00,3.11,267.46,'2022-06-04 11:56:40','',''),(1201,'1','273','1',1,'Retail Sale Id 1212',1198.80,0.00,0.00,1.62,139.32,'2022-06-04 11:59:36','',''),(1202,'1','273','1',1,'Retail Sale Id 1213',2249.60,0.00,0.00,3.04,261.44,'2022-06-04 12:08:07','',''),(1203,'1','273','1',1,'Retail Sale Id 1214',2220.00,0.00,0.00,3.00,258.00,'2022-06-04 12:30:13','',''),(1204,'1','273','1',1,'Retail Sale Id 1216',1398.60,0.00,0.00,1.89,162.54,'2022-06-04 12:36:18','',''),(1205,'1','273','1',1,'Retail Sale Id 1217',1502.20,0.00,0.00,2.03,174.58,'2022-06-04 12:45:42','',''),(1206,'1','273','1',1,'Retail Sale Id 1218',8998.40,0.00,0.00,12.16,1045.76,'2022-06-04 12:58:17','',''),(1207,'1','273','1',1,'Retail Sale Id 1219',2220.00,0.00,0.00,3.00,258.00,'2022-06-04 13:03:29','',''),(1208,'1','273','1',1,'Retail Sale Id 1220',7400.00,0.00,0.00,10.00,860.00,'2022-06-04 13:16:22','',''),(1209,'1','273','1',1,'Retail Sale Id 1221',2220.00,0.00,0.00,3.00,258.00,'2022-06-04 13:39:36','',''),(1210,'1','273','1',1,'Retail Sale Id 1222',7400.00,0.00,0.00,10.00,860.00,'2022-06-04 13:44:55','',''),(1211,'1','273','1',1,'Retail Sale Id 1223',6001.40,0.00,0.00,8.11,697.46,'2022-06-04 13:47:45','',''),(1212,'1','273','1',1,'Retail Sale Id 1224',1502.20,0.00,0.00,2.03,174.58,'2022-06-04 13:50:04','',''),(1213,'1','273','1',1,'Retail Sale Id 1225',2249.60,0.00,0.00,3.04,261.44,'2022-06-04 13:54:52','',''),(1214,'1','273','1',1,'Retail Sale Id 1226',2220.00,0.00,0.00,3.00,258.00,'2022-06-04 14:14:41','',''),(1215,'1','273','1',1,'Retail Sale Id 1227',999.00,0.00,0.00,1.35,116.10,'2022-06-04 14:15:43','',''),(1216,'1','273','1',1,'Retail Sale Id 1228',1998.00,0.00,0.00,2.70,232.20,'2022-06-04 14:39:20','',''),(1217,'1','273','1',1,'Retail Sale Id 1229',3700.00,0.00,0.00,5.00,430.00,'2022-06-04 14:40:35','',''),(1218,'1','273','1',1,'Retail Sale Id 1230',3700.00,0.00,0.00,5.00,430.00,'2022-06-04 14:41:40','',''),(1219,'1','273','1',1,'Retail Sale Id 1231',4440.00,0.00,0.00,6.00,516.00,'2022-06-04 14:49:12','',''),(1220,'1','273','1',1,'Retail Sale Id 1232',1198.80,0.00,0.00,1.62,139.32,'2022-06-04 14:59:12','',''),(1221,'1','273','1',1,'Retail Sale Id 1233',3700.00,0.00,0.00,5.00,430.00,'2022-06-04 15:04:29','',''),(1222,'1','273','1',1,'Retail Sale Id 1233',9250.00,0.00,0.00,12.50,1075.00,'2022-06-04 15:04:29','',''),(1223,'1','273','1',1,'Retail Sale Id 1234',2249.60,0.00,0.00,3.04,261.44,'2022-06-04 15:06:09','',''),(1224,'1','273','1',1,'Retail Sale Id 1235',2997.00,0.00,0.00,4.05,348.30,'2022-06-04 15:10:19','',''),(1225,'1','273','1',1,'Retail Sale Id 1236',1998.00,0.00,0.00,2.70,232.20,'2022-06-04 15:27:53','',''),(1226,'1','273','1',1,'Retail Sale Id 1236',1998.00,0.00,0.00,2.70,232.20,'2022-06-04 15:27:53','',''),(1227,'1','273','1',1,'Retail Sale Id 1237',9250.00,0.00,0.00,12.50,1075.00,'2022-06-04 15:29:38','',''),(1228,'1','273','1',1,'Retail Sale Id 1239',36888.00,0.00,0.00,53.00,2226.00,'2022-06-04 15:35:02','',''),(1229,'1','273','1',1,'Retail Sale Id 1240',2249.60,0.00,0.00,3.04,261.44,'2022-06-04 15:37:02','',''),(1230,'1','273','1',1,'Retail Sale Id 1241',4872.00,0.00,0.00,7.00,294.00,'2022-06-04 15:42:13','',''),(1231,'1','273','1',1,'Retail Sale Id 1242',1502.20,0.00,0.00,2.03,174.58,'2022-06-04 16:07:16','',''),(1232,'1','273','1',1,'Retail Sale Id 1243',2220.00,0.00,0.00,3.00,258.00,'2022-06-04 16:08:44','',''),(1233,'1','273','1',1,'Retail Sale Id 1244',1302.40,0.00,0.00,1.76,151.36,'2022-06-04 16:09:52','',''),(1234,'1','273','1',1,'Retail Sale Id 1245',1480.00,0.00,0.00,2.00,172.00,'2022-06-04 16:10:55','',''),(1235,'1','273','1',1,'Retail Sale Id 1246',1502.20,0.00,0.00,2.03,174.58,'2022-06-04 16:12:46','',''),(1236,'1','273','1',1,'Retail Sale Id 1247',999.00,0.00,0.00,1.35,116.10,'2022-06-04 16:17:55','',''),(1237,'1','273','1',1,'Retail Sale Id 1248',2220.00,0.00,0.00,3.00,258.00,'2022-06-04 16:18:48','',''),(1238,'1','273','1',1,'Retail Sale Id 1249',747.40,0.00,0.00,1.01,86.86,'2022-06-04 16:27:27','',''),(1239,'1','273','1',1,'Retail Sale Id 1250',1480.00,0.00,0.00,2.00,172.00,'2022-06-04 16:28:53','',''),(1240,'1','273','1',1,'Retail Sale Id 1251',5002.40,0.00,0.00,6.76,581.36,'2022-06-04 16:32:24','',''),(1241,'1','273','1',1,'Retail Sale Id 1252',2220.00,0.00,0.00,3.00,258.00,'2022-06-04 16:36:47','',''),(1242,'1','273','1',1,'Retail Sale Id 1253',999.00,0.00,0.00,1.35,116.10,'2022-06-04 16:38:49','',''),(1243,'1','273','1',1,'Retail Sale Id 1254',5002.40,0.00,0.00,6.76,581.36,'2022-06-04 16:43:25','',''),(1244,'1','273','1',1,'Retail Sale Id 1255',2997.00,0.00,0.00,4.05,348.30,'2022-06-04 16:44:35','',''),(1245,'1','273','1',1,'Retail Sale Id 1255',2997.00,0.00,0.00,4.05,348.30,'2022-06-04 16:44:35','',''),(1246,'1','273','1',1,'Retail Sale Id 1256',1502.20,0.00,0.00,2.03,174.58,'2022-06-04 16:45:31','',''),(1247,'1','273','1',1,'Retail Sale Id 1257',5002.40,0.00,0.00,6.76,581.36,'2022-06-04 16:52:56','',''),(1248,'1','273','1',1,'Retail Sale Id 1258',3700.00,0.00,0.00,5.00,430.00,'2022-06-04 16:54:01','',''),(1249,'1','273','1',1,'Retail Sale Id 1259',1598.40,0.00,0.00,2.16,185.76,'2022-06-04 16:55:16','',''),(1250,'1','273','1',1,'Retail Sale Id 1260',2997.00,0.00,0.00,4.05,348.30,'2022-06-04 16:56:10','',''),(1251,'1','273','1',1,'Retail Sale Id 1261',999.00,0.00,0.00,1.35,116.10,'2022-06-04 17:04:05','',''),(1252,'1','273','1',1,'Retail Sale Id 1262',2101.60,0.00,0.00,2.84,244.24,'2022-06-04 17:10:43','',''),(1253,'1','273','1',1,'Retail Sale Id 1263',5920.00,0.00,0.00,8.00,688.00,'2022-06-04 17:25:57','',''),(1254,'1','273','1',1,'Retail Sale Id 1263',5920.00,0.00,0.00,8.00,688.00,'2022-06-04 17:25:57','',''),(1255,'1','273','1',1,'Retail Sale Id 1264',1998.00,0.00,0.00,2.70,232.20,'2022-06-04 17:26:27','',''),(1256,'1','273','1',1,'Return of Retail Sale Id 1264',0.00,1998.00,2.70,0.00,-232.20,'2022-06-04 17:30:12','',''),(1257,'1','273','1',1,'Retail Sale Id 1265',2220.00,0.00,0.00,3.00,258.00,'2022-06-04 17:30:40','',''),(1258,'1','273','1',1,'Retail Sale Id 1266',2220.00,0.00,0.00,3.00,258.00,'2022-06-04 17:31:34','',''),(1259,'1','273','1',1,'Retail Sale Id 1267',3700.00,0.00,0.00,5.00,430.00,'2022-06-04 17:46:23','',''),(1260,'1','273','1',1,'Retail Sale Id 1268',1998.00,0.00,0.00,2.70,232.20,'2022-06-04 17:50:54','',''),(1261,'1','273','1',1,'Retail Sale Id 1269',2997.00,0.00,0.00,4.05,348.30,'2022-06-04 18:04:01','',''),(1262,'1','273','1',1,'Retail Sale Id 1270',799.20,0.00,0.00,1.08,92.88,'2022-06-05 07:10:25','',''),(1263,'1','273','1',1,'Retail Sale Id 1271',2501.20,0.00,0.00,3.38,290.68,'2022-06-05 07:32:05','',''),(1264,'1','273','1',1,'Retail Sale Id 1272',2397.60,0.00,0.00,3.24,278.64,'2022-06-05 07:34:29','',''),(1265,'1','273','1',1,'Retail Sale Id 1273',3700.00,0.00,0.00,5.00,430.00,'2022-06-05 07:48:23','',''),(1266,'1','273','1',1,'Retail Sale Id 1274',4499.20,0.00,0.00,6.08,522.88,'2022-06-05 07:49:53','',''),(1267,'1','273','1',1,'Retail Sale Id 1275',747.40,0.00,0.00,1.01,86.86,'2022-06-05 07:54:58','',''),(1268,'1','273','1',1,'Retail Sale Id 1276',999.00,0.00,0.00,1.35,116.10,'2022-06-05 08:05:44','',''),(1269,'1','273','1',1,'Retail Sale Id 1277',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 08:06:50','',''),(1270,'1','273','1',1,'Retail Sale Id 1279',999.00,0.00,0.00,1.35,116.10,'2022-06-05 08:09:05','',''),(1271,'1','273','1',1,'Retail Sale Id 1280',999.00,0.00,0.00,1.35,116.10,'2022-06-05 08:10:53','',''),(1272,'1','273','1',1,'Retail Sale Id 1281',1998.00,0.00,0.00,2.70,232.20,'2022-06-05 08:16:02','',''),(1273,'1','273','1',1,'Retail Sale Id 1282',1998.00,0.00,0.00,2.70,232.20,'2022-06-05 08:20:52','',''),(1274,'1','273','1',1,'Retail Sale Id 1283',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 08:23:45','',''),(1275,'1','273','1',1,'Retail Sale Id 1284',2960.00,0.00,0.00,4.00,344.00,'2022-06-05 08:25:13','',''),(1276,'1','273','1',1,'Retail Sale Id 1285',740.00,0.00,0.00,1.00,86.00,'2022-06-05 08:25:48','',''),(1277,'1','273','1',1,'Retail Sale Id 1286',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 08:26:43','',''),(1278,'1','273','1',1,'Retail Sale Id 1288',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 08:27:21','',''),(1279,'1','273','1',1,'Retail Sale Id 1289',1000.00,0.00,0.00,1.00,346.00,'2022-06-05 08:27:59','',''),(1280,'1','273','1',1,'Return of Retail Sale Id 1289',0.00,1000.00,1.00,0.00,-346.00,'2022-06-05 08:30:26','',''),(1281,'1','273','1',1,'Retail Sale Id 1290',999.00,0.00,0.00,1.35,116.10,'2022-06-05 08:30:59','',''),(1282,'1','273','1',1,'Retail Sale Id 1292',125280.00,0.00,0.00,180.00,7560.00,'2022-06-05 08:42:42','',''),(1283,'1','273','1',1,'Retail Sale Id 1293',1998.00,0.00,0.00,2.70,232.20,'2022-06-05 08:43:34','',''),(1284,'1','273','1',1,'Retail Sale Id 1294',1198.80,0.00,0.00,1.62,139.32,'2022-06-05 08:44:47','',''),(1285,'1','273','1',1,'Retail Sale Id 1295',799.20,0.00,0.00,1.08,92.88,'2022-06-05 08:50:20','',''),(1286,'1','273','1',1,'Retail Sale Id 1296',1998.00,0.00,0.00,2.70,232.20,'2022-06-05 08:54:35','',''),(1287,'1','273','1',1,'Retail Sale Id 1297',2997.00,0.00,0.00,4.05,348.30,'2022-06-05 08:57:14','',''),(1288,'1','273','1',1,'Retail Sale Id 1298',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 08:59:37','',''),(1289,'1','273','1',1,'Retail Sale Id 1299',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 09:05:17','',''),(1290,'1','273','1',1,'Retail Sale Id 1300',999.00,0.00,0.00,1.35,116.10,'2022-06-05 09:13:22','',''),(1291,'1','273','1',1,'Retail Sale Id 1301',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 09:15:20','',''),(1292,'1','273','1',1,'Retail Sale Id 1301',1998.00,0.00,0.00,2.70,232.20,'2022-06-05 09:15:20','',''),(1293,'1','273','1',1,'Retail Sale Id 1302',3700.00,0.00,0.00,5.00,430.00,'2022-06-05 09:17:08','',''),(1294,'1','273','1',1,'Retail Sale Id 1303',2997.00,0.00,0.00,4.05,348.30,'2022-06-05 09:18:31','',''),(1295,'1','273','1',1,'Retail Sale Id 1304',999.00,0.00,0.00,1.35,116.10,'2022-06-05 09:20:58','',''),(1296,'1','273','1',1,'Retail Sale Id 1305',5180.00,0.00,0.00,7.00,602.00,'2022-06-05 09:37:11','',''),(1297,'1','273','1',1,'Retail Sale Id 1306',8140.00,0.00,0.00,11.00,946.00,'2022-06-05 09:39:43','',''),(1298,'1','273','1',1,'Retail Sale Id 1307',8880.00,0.00,0.00,12.00,1032.00,'2022-06-05 09:51:40','',''),(1299,'1','273','1',1,'Retail Sale Id 1308',2501.20,0.00,0.00,3.38,290.68,'2022-06-05 09:52:44','',''),(1300,'1','273','1',1,'Retail Sale Id 1309',20998.32,0.00,0.00,30.17,1267.14,'2022-06-05 09:55:13','',''),(1301,'1','273','1',1,'Retail Sale Id 1310',2249.60,0.00,0.00,3.04,261.44,'2022-06-05 10:28:57','',''),(1302,'1','273','1',1,'Retail Sale Id 1311',2220.00,0.00,0.00,3.00,258.00,'2022-06-05 10:33:18','',''),(1303,'1','273','1',1,'Retail Sale Id 1312',2220.00,0.00,0.00,3.00,258.00,'2022-06-05 10:45:34','',''),(1304,'1','273','1',1,'Retail Sale Id 1313',2220.00,0.00,0.00,3.00,258.00,'2022-06-05 10:48:56','',''),(1305,'1','273','1',1,'Retail Sale Id 1314',4003.40,0.00,0.00,5.41,465.26,'2022-06-05 11:13:49','',''),(1306,'1','273','1',1,'Retail Sale Id 1315',747.40,0.00,0.00,1.01,86.86,'2022-06-05 11:20:28','',''),(1307,'1','273','1',1,'Retail Sale Id 1316',3700.00,0.00,0.00,5.00,430.00,'2022-06-05 11:33:14','',''),(1308,'1','273','1',1,'Retail Sale Id 1317',9250.00,0.00,0.00,12.50,1075.00,'2022-06-05 11:35:46','',''),(1309,'1','273','1',1,'Retail Sale Id 1318',6001.40,0.00,0.00,8.11,697.46,'2022-06-05 11:42:08','',''),(1310,'1','273','1',1,'Retail Sale Id 1319',2109.00,0.00,0.00,2.85,245.10,'2022-06-05 11:49:10','',''),(1311,'1','273','1',1,'Retail Sale Id 1320',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 12:08:49','',''),(1312,'1','273','1',1,'Retail Sale Id 1321',740.00,0.00,0.00,1.00,86.00,'2022-06-05 12:09:37','',''),(1313,'1','273','1',1,'Retail Sale Id 1323',2220.00,0.00,0.00,3.00,258.00,'2022-06-05 12:21:11','',''),(1314,'1','273','1',1,'Retail Sale Id 1324',747.40,0.00,0.00,1.01,86.86,'2022-06-05 12:22:28','',''),(1315,'1','273','1',1,'Retail Sale Id 1325',2220.00,0.00,0.00,3.00,258.00,'2022-06-05 12:26:47','',''),(1316,'1','273','1',1,'Retail Sale Id 1326',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 12:27:47','',''),(1317,'1','273','1',1,'Retail Sale Id 1327',1998.00,0.00,0.00,2.70,232.20,'2022-06-05 12:30:40','',''),(1318,'1','273','1',1,'Retail Sale Id 1328',747.40,0.00,0.00,1.01,86.86,'2022-06-05 12:33:20','',''),(1319,'1','273','1',1,'Retail Sale Id 1330',999.00,0.00,0.00,1.35,116.10,'2022-06-05 12:46:06','',''),(1320,'1','273','1',1,'Retail Sale Id 1331',14998.80,0.00,0.00,21.55,905.10,'2022-06-05 12:49:25','',''),(1321,'1','273','1',1,'Retail Sale Id 1332',2249.60,0.00,0.00,3.04,261.44,'2022-06-05 12:55:05','',''),(1322,'1','273','1',1,'Retail Sale Id 1333',5180.00,0.00,0.00,7.00,602.00,'2022-06-05 12:59:48','',''),(1323,'1','273','1',1,'Retail Sale Id 1334',1480.00,0.00,0.00,2.00,172.00,'2022-06-05 13:03:17','',''),(1324,'1','273','1',1,'Retail Sale Id 1335',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 13:06:07','',''),(1325,'1','273','1',1,'Retail Sale Id 1336',10360.00,0.00,0.00,14.00,1204.00,'2022-06-05 13:09:10','',''),(1326,'1','273','1',1,'Retail Sale Id 1337',999.00,0.00,0.00,1.35,116.10,'2022-06-05 13:27:42','',''),(1327,'1','273','1',1,'Retail Sale Id 1338',747.40,0.00,0.00,1.01,86.86,'2022-06-05 13:32:56','',''),(1328,'1','273','1',1,'Retail Sale Id 1339',2997.00,0.00,0.00,4.05,348.30,'2022-06-05 13:46:32','',''),(1329,'1','273','1',1,'Retail Sale Id 1340',740.00,0.00,0.00,1.00,86.00,'2022-06-05 13:50:36','',''),(1330,'1','273','1',1,'Retail Sale Id 1341',11100.00,0.00,0.00,15.00,1290.00,'2022-06-05 13:51:53','',''),(1331,'1','273','1',1,'Retail Sale Id 1342',4440.00,0.00,0.00,6.00,516.00,'2022-06-05 14:11:38','',''),(1332,'1','273','1',1,'Retail Sale Id 1342',5180.00,0.00,0.00,7.00,602.00,'2022-06-05 14:11:38','',''),(1333,'1','273','1',1,'Retail Sale Id 1343',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 14:13:02','',''),(1334,'1','273','1',1,'Retail Sale Id 1344',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 14:14:11','',''),(1335,'1','273','1',1,'Retail Sale Id 1345',747.40,0.00,0.00,1.01,86.86,'2022-06-05 14:15:23','',''),(1336,'1','273','1',1,'Retail Sale Id 1346',2220.00,0.00,0.00,3.00,258.00,'2022-06-05 14:16:57','',''),(1337,'1','273','1',1,'Retail Sale Id 1347',5002.40,0.00,0.00,6.76,581.36,'2022-06-05 14:32:07','',''),(1338,'1','273','1',1,'Retail Sale Id 1348',3500.20,0.00,0.00,4.73,406.78,'2022-06-05 14:35:28','',''),(1339,'1','273','1',1,'Retail Sale Id 1350',999.00,0.00,0.00,1.35,116.10,'2022-06-05 14:50:04','',''),(1340,'1','273','1',1,'Retail Sale Id 1351',2220.00,0.00,0.00,3.00,258.00,'2022-06-05 15:09:55','',''),(1341,'1','273','1',1,'Retail Sale Id 1351',3700.00,0.00,0.00,5.00,430.00,'2022-06-05 15:09:55','',''),(1342,'1','273','1',1,'Retail Sale Id 1352',2220.00,0.00,0.00,3.00,258.00,'2022-06-05 15:13:31','',''),(1343,'1','273','1',1,'Retail Sale Id 1353',7400.00,0.00,0.00,10.00,860.00,'2022-06-05 15:15:46','',''),(1344,'1','273','1',1,'Retail Sale Id 1354',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 15:17:26','',''),(1345,'1','273','1',1,'Retail Sale Id 1355',747.40,0.00,0.00,1.01,86.86,'2022-06-05 15:23:40','',''),(1346,'1','273','1',1,'Retail Sale Id 1356',999.00,0.00,0.00,1.35,116.10,'2022-06-05 15:37:43','',''),(1347,'1','273','1',1,'Retail Sale Id 1357',747.40,0.00,0.00,1.01,86.86,'2022-06-05 15:45:25','',''),(1348,'1','273','1',1,'Retail Sale Id 1358',1998.00,0.00,0.00,2.70,232.20,'2022-06-05 15:53:20','',''),(1349,'1','273','1',1,'Retail Sale Id 1359',740.00,0.00,0.00,1.00,86.00,'2022-06-05 16:00:00','',''),(1350,'1','273','1',1,'Retail Sale Id 1360',1998.00,0.00,0.00,2.70,232.20,'2022-06-05 16:04:16','',''),(1351,'1','273','1',1,'Retail Sale Id 1361',999.00,0.00,0.00,1.35,116.10,'2022-06-05 16:07:15','',''),(1352,'1','273','1',1,'Retail Sale Id 1363',747.40,0.00,0.00,1.01,86.86,'2022-06-05 16:29:18','',''),(1353,'1','273','1',1,'Retail Sale Id 1364',83520.00,0.00,0.00,120.00,5040.00,'2022-06-05 16:34:17','',''),(1354,'1','273','1',1,'Retail Sale Id 1365',747.40,0.00,0.00,1.01,86.86,'2022-06-05 16:35:28','',''),(1355,'1','273','1',1,'Retail Sale Id 1366',1502.20,0.00,0.00,2.03,174.58,'2022-06-05 16:46:34','',''),(1356,'1','273','1',1,'Retail Sale Id 1366',1998.00,0.00,0.00,2.70,232.20,'2022-06-05 16:46:34','',''),(1357,'1','273','1',1,'Retail Sale Id 1367',8880.00,0.00,0.00,12.00,1032.00,'2022-06-05 16:48:14','',''),(1358,'1','273','1',1,'Retail Sale Id 1368',2960.00,0.00,0.00,4.00,344.00,'2022-06-05 16:49:36','',''),(1359,'1','273','1',1,'Retail Sale Id 1369',2301.40,0.00,0.00,3.11,267.46,'2022-06-05 16:50:41','',''),(1360,'1','273','1',1,'Retail Sale Id 1370',999.00,0.00,0.00,1.35,116.10,'2022-06-05 16:52:01','',''),(1361,'1','273','1',1,'Retail Sale Id 1371',747.40,0.00,0.00,1.01,86.86,'2022-06-05 16:58:41','',''),(1362,'1','273','1',1,'Retail Sale Id 1372',747.40,0.00,0.00,1.01,86.86,'2022-06-05 17:00:18','',''),(1363,'1','273','1',1,'Retail Sale Id 1373',1998.00,0.00,0.00,2.70,232.20,'2022-06-05 17:04:02','',''),(1364,'1','273','1',1,'Retail Sale Id 1373',2997.00,0.00,0.00,4.05,348.30,'2022-06-05 17:04:02','',''),(1365,'1','273','1',1,'Retail Sale Id 1374',2197.80,0.00,0.00,2.97,255.42,'2022-06-05 17:12:13','',''),(1366,'1','273','1',1,'Retail Sale Id 1375',747.40,0.00,0.00,1.01,86.86,'2022-06-05 17:13:36','',''),(1367,'1','273','1',1,'Retail Sale Id 1376',2997.00,0.00,0.00,4.05,348.30,'2022-06-05 17:15:26','',''),(1368,'1','273','1',1,'Retail Sale Id 1377',747.40,0.00,0.00,1.01,86.86,'2022-06-05 17:17:56','',''),(1369,'1','273','1',1,'Retail Sale Id 1378',747.40,0.00,0.00,1.01,86.86,'2022-06-05 17:20:57','',''),(1370,'1','273','1',1,'Retail Sale Id 1379',2220.00,0.00,0.00,3.00,258.00,'2022-06-05 17:22:36','',''),(1371,'1','273','1',1,'Retail Sale Id 1380',1480.00,0.00,0.00,2.00,172.00,'2022-06-05 17:23:46','',''),(1372,'1','273','1',1,'Retail Sale Id 1381',6001.40,0.00,0.00,8.11,697.46,'2022-06-05 17:27:17','',''),(1373,'1','273','1',1,'Retail Sale Id 1382',5002.40,0.00,0.00,6.76,581.36,'2022-06-05 17:38:28','',''),(1374,'1','273','1',1,'Retail Sale Id 1383',999.00,0.00,0.00,1.35,116.10,'2022-06-05 17:47:32','',''),(1375,'1','273','1',1,'Retail Sale Id 1384',2997.00,0.00,0.00,4.05,348.30,'2022-06-05 17:48:37','',''),(1376,'1','273','1',1,'Retail Sale Id 1385',2197.80,0.00,0.00,2.97,255.42,'2022-06-05 17:52:48','',''),(1377,'1','273','1',1,'Return of Retail Sale Id 1331',0.00,14998.80,21.55,0.00,-905.10,'2022-06-05 18:14:49','',''),(1378,'1','273','1',1,'Retail Sale Id 1386',14344.56,0.00,0.00,20.61,865.62,'2022-06-05 18:21:22','',''),(1379,'1','273','1',1,'Retail Sale Id 1387',4003.40,0.00,0.00,5.41,465.26,'2022-06-06 06:55:00','',''),(1380,'1','273','1',1,'Retail Sale Id 1388',15998.80,0.00,0.00,21.62,1859.32,'2022-06-06 06:59:26','',''),(1381,'1','273','1',1,'Retail Sale Id 1389',1302.40,0.00,0.00,1.76,151.36,'2022-06-06 07:01:03','',''),(1382,'1','273','1',1,'Retail Sale Id 1390',17998.56,0.00,0.00,25.86,1086.12,'2022-06-06 07:14:32','',''),(1383,'1','273','1',1,'Retail Sale Id 1391',1502.20,0.00,0.00,2.03,174.58,'2022-06-06 07:35:23','',''),(1384,'1','273','1',1,'Retail Sale Id 1392',5002.40,0.00,0.00,6.76,581.36,'2022-06-06 07:37:44','',''),(1385,'1','273','1',1,'Retail Sale Id 1393',2997.00,0.00,0.00,4.05,348.30,'2022-06-06 08:00:22','',''),(1386,'1','273','1',1,'Retail Sale Id 1394',7503.60,0.00,0.00,10.14,872.04,'2022-06-06 08:02:36','',''),(1387,'1','273','1',1,'Retail Sale Id 1395',799.20,0.00,0.00,1.08,92.88,'2022-06-06 08:06:27','',''),(1388,'1','273','1',1,'Retail Sale Id 1396',1746.40,0.00,0.00,2.36,202.96,'2022-06-06 08:07:22','',''),(1389,'1','273','1',1,'Retail Sale Id 1397',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 08:17:09','',''),(1390,'1','273','1',1,'Retail Sale Id 1398',2220.00,0.00,0.00,3.00,258.00,'2022-06-06 08:24:46','',''),(1391,'1','273','1',1,'Retail Sale Id 1399',1480.00,0.00,0.00,2.00,172.00,'2022-06-06 08:39:52','',''),(1392,'1','273','1',1,'Retail Sale Id 1400',34800.00,0.00,0.00,50.00,2100.00,'2022-06-06 08:50:21','',''),(1393,'1','273','1',1,'Retail Sale Id 1401',747.40,0.00,0.00,1.01,86.86,'2022-06-06 08:51:27','',''),(1394,'1','273','1',1,'Retail Sale Id 1402',503.20,0.00,0.00,0.68,58.48,'2022-06-06 08:53:32','',''),(1395,'1','273','1',1,'Retail Sale Id 1403',1502.20,0.00,0.00,2.03,174.58,'2022-06-06 08:54:49','',''),(1396,'1','273','1',1,'Retail Sale Id 1404',5202.20,0.00,0.00,7.03,604.58,'2022-06-06 08:55:59','',''),(1397,'1','273','1',1,'Retail Sale Id 1405',2220.00,0.00,0.00,3.00,258.00,'2022-06-06 09:03:53','',''),(1398,'1','273','1',1,'Retail Sale Id 1406',999.00,0.00,0.00,1.35,116.10,'2022-06-06 09:09:08','',''),(1399,'1','273','1',1,'Retail Sale Id 1407',3700.00,0.00,0.00,5.00,430.00,'2022-06-06 09:17:33','',''),(1400,'1','273','1',1,'Retail Sale Id 1408',740.00,0.00,0.00,1.00,86.00,'2022-06-06 09:22:07','',''),(1401,'1','273','1',1,'Retail Sale Id 1409',2249.60,0.00,0.00,3.04,261.44,'2022-06-06 09:29:48','',''),(1402,'1','273','1',1,'Retail Sale Id 1410',2220.00,0.00,0.00,3.00,258.00,'2022-06-06 09:37:21','',''),(1403,'1','273','1',1,'Retail Sale Id 1411',27840.00,0.00,0.00,40.00,1680.00,'2022-06-06 09:38:10','',''),(1404,'1','273','1',1,'Retail Sale Id 1412',747.40,0.00,0.00,1.01,86.86,'2022-06-06 09:41:54','',''),(1405,'1','273','1',1,'Retail Sale Id 1413',4440.00,0.00,0.00,6.00,516.00,'2022-06-06 09:42:47','',''),(1406,'1','273','1',1,'Retail Sale Id 1414',2997.00,0.00,0.00,4.05,348.30,'2022-06-06 09:47:53','',''),(1407,'1','273','1',1,'Retail Sale Id 1415',2501.20,0.00,0.00,3.38,290.68,'2022-06-06 09:50:17','',''),(1408,'1','273','1',1,'Retail Sale Id 1416',747.40,0.00,0.00,1.01,86.86,'2022-06-06 09:53:22','',''),(1409,'1','273','1',1,'Retail Sale Id 1417',1998.00,0.00,0.00,2.70,232.20,'2022-06-06 10:06:59','',''),(1410,'1','273','1',1,'Retail Sale Id 1418',104400.00,0.00,0.00,150.00,6300.00,'2022-06-06 10:09:22','',''),(1411,'1','273','1',1,'Retail Sale Id 1419',123888.00,0.00,0.00,178.00,7476.00,'2022-06-06 10:10:05','',''),(1412,'1','273','1',1,'Retail Sale Id 1420',5180.00,0.00,0.00,7.00,602.00,'2022-06-06 10:12:14','',''),(1413,'1','273','1',1,'Retail Sale Id 1421',83520.00,0.00,0.00,120.00,5040.00,'2022-06-06 10:49:14','',''),(1414,'1','273','1',1,'Retail Sale Id 1422',1198.80,0.00,0.00,1.62,139.32,'2022-06-06 10:50:38','',''),(1415,'1','273','1',1,'Retail Sale Id 1423',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 11:06:27','',''),(1416,'1','273','1',1,'Retail Sale Id 1424',2997.00,0.00,0.00,4.05,348.30,'2022-06-06 11:16:08','',''),(1417,'1','273','1',1,'Retail Sale Id 1425',1901.80,0.00,0.00,2.57,221.02,'2022-06-06 11:23:54','',''),(1418,'1','273','1',1,'Retail Sale Id 1426',4003.40,0.00,0.00,5.41,465.26,'2022-06-06 11:48:48','',''),(1419,'1','273','1',1,'Retail Sale Id 1427',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 12:07:20','',''),(1420,'1','273','1',1,'Retail Sale Id 1427',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 12:07:20','',''),(1421,'1','273','1',1,'Retail Sale Id 1428',47328.00,0.00,0.00,68.00,2856.00,'2022-06-06 12:10:39','',''),(1422,'1','273','1',1,'Retail Sale Id 1429',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 12:12:19','',''),(1423,'1','273','1',1,'Retail Sale Id 1430',747.40,0.00,0.00,1.01,86.86,'2022-06-06 12:55:11','',''),(1424,'1','273','1',1,'Retail Sale Id 1431',799.20,0.00,0.00,1.08,92.88,'2022-06-06 13:41:17','',''),(1425,'1','273','1',1,'Retail Sale Id 1432',7400.00,0.00,0.00,10.00,860.00,'2022-06-06 13:46:17','',''),(1426,'1','273','1',1,'Retail Sale Id 1433',5002.40,0.00,0.00,6.76,581.36,'2022-06-06 13:50:40','',''),(1427,'1','273','1',1,'Retail Sale Id 1434',999.00,0.00,0.00,1.35,116.10,'2022-06-06 14:16:27','',''),(1428,'1','273','1',1,'Retail Sale Id 1435',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 14:38:37','',''),(1429,'1','273','1',1,'Retail Sale Id 1436',67512.00,0.00,0.00,97.00,4074.00,'2022-06-06 14:52:03','',''),(1430,'1','273','1',1,'Retail Sale Id 1437',2960.00,0.00,0.00,4.00,344.00,'2022-06-06 15:00:37','',''),(1431,'1','273','1',1,'Retail Sale Id 1439',2249.60,0.00,0.00,3.04,261.44,'2022-06-06 15:04:08','',''),(1432,'1','273','1',1,'Retail Sale Id 1440',2797.20,0.00,0.00,3.78,325.08,'2022-06-06 15:26:41','',''),(1433,'1','273','1',1,'Retail Sale Id 1441',999.00,0.00,0.00,1.35,116.10,'2022-06-06 15:36:08','',''),(1434,'1','273','1',1,'Retail Sale Id 1443',703.00,0.00,0.00,0.95,81.70,'2022-06-06 15:39:27','',''),(1435,'1','273','1',1,'Retail Sale Id 1444',1502.20,0.00,0.00,2.03,174.58,'2022-06-06 15:42:18','',''),(1436,'1','273','1',1,'Retail Sale Id 1445',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 15:45:11','',''),(1437,'1','273','1',1,'Retail Sale Id 1446',999.00,0.00,0.00,1.35,116.10,'2022-06-06 15:52:52','',''),(1438,'1','273','1',1,'Retail Sale Id 1447',1502.20,0.00,0.00,2.03,174.58,'2022-06-06 16:23:25','',''),(1439,'1','273','1',1,'Retail Sale Id 1448',1502.20,0.00,0.00,2.03,174.58,'2022-06-06 16:25:06','',''),(1440,'1','273','1',1,'Retail Sale Id 1449',62640.00,0.00,0.00,90.00,3780.00,'2022-06-06 16:31:19','',''),(1441,'1','273','1',1,'Retail Sale Id 1450',3700.00,0.00,0.00,5.00,430.00,'2022-06-06 16:46:32','',''),(1442,'1','273','1',1,'Retail Sale Id 1451',1502.20,0.00,0.00,2.03,174.58,'2022-06-06 16:47:53','',''),(1443,'1','273','1',1,'Retail Sale Id 1453',2997.00,0.00,0.00,4.05,348.30,'2022-06-06 16:50:09','',''),(1444,'1','273','1',1,'Retail Sale Id 1455',3700.00,0.00,0.00,5.00,430.00,'2022-06-06 16:51:15','',''),(1445,'1','273','1',1,'Retail Sale Id 1456',5202.20,0.00,0.00,7.03,604.58,'2022-06-06 16:52:09','',''),(1446,'1','273','1',1,'Retail Sale Id 1457',4440.00,0.00,0.00,6.00,516.00,'2022-06-06 16:58:19','',''),(1447,'1','273','1',1,'Retail Sale Id 1458',747.40,0.00,0.00,1.01,86.86,'2022-06-06 17:09:05','',''),(1448,'1','273','1',1,'Retail Sale Id 1459',3700.00,0.00,0.00,5.00,430.00,'2022-06-06 17:11:52','',''),(1449,'1','273','1',1,'Retail Sale Id 1460',6660.00,0.00,0.00,9.00,774.00,'2022-06-06 17:14:17','',''),(1450,'1','273','1',1,'Retail Sale Id 1461',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 17:15:35','',''),(1451,'1','273','1',1,'Retail Sale Id 1462',1502.20,0.00,0.00,2.03,174.58,'2022-06-06 17:27:50','',''),(1452,'1','273','1',1,'Retail Sale Id 1463',7000.40,0.00,0.00,9.46,813.56,'2022-06-06 17:30:35','',''),(1453,'1','273','1',1,'Retail Sale Id 1464',2220.00,0.00,0.00,3.00,258.00,'2022-06-06 17:35:33','',''),(1454,'1','273','1',1,'Retail Sale Id 1465',2220.00,0.00,0.00,3.00,258.00,'2022-06-06 17:42:08','',''),(1455,'1','273','1',1,'Retail Sale Id 1467',2220.00,0.00,0.00,3.00,258.00,'2022-06-06 17:44:29','',''),(1456,'1','273','1',1,'Retail Sale Id 1468',1480.00,0.00,0.00,2.00,172.00,'2022-06-06 17:45:37','',''),(1457,'1','273','1',1,'Retail Sale Id 1469',740.00,0.00,0.00,1.00,86.00,'2022-06-06 17:47:57','',''),(1458,'1','273','1',1,'Retail Sale Id 1470',1998.00,0.00,0.00,2.70,232.20,'2022-06-06 17:49:10','',''),(1459,'1','273','1',1,'Retail Sale Id 1471',1198.80,0.00,0.00,1.62,139.32,'2022-06-06 17:50:27','',''),(1460,'1','273','1',1,'Retail Sale Id 1473',747.40,0.00,0.00,1.01,86.86,'2022-06-06 17:54:07','',''),(1461,'1','273','1',1,'Retail Sale Id 1474',740.00,0.00,0.00,1.00,86.00,'2022-06-06 17:55:52','',''),(1462,'1','273','1',1,'Retail Sale Id 1475',5498.20,0.00,0.00,7.43,638.98,'2022-06-06 17:57:06','',''),(1463,'1','273','1',1,'Retail Sale Id 1476',2501.20,0.00,0.00,3.38,290.68,'2022-06-06 17:59:11','',''),(1464,'1','273','1',1,'Retail Sale Id 1477',1998.00,0.00,0.00,2.70,232.20,'2022-06-06 18:00:33','',''),(1465,'1','273','1',1,'Retail Sale Id 1478',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 18:01:45','',''),(1466,'1','273','1',1,'Retail Sale Id 1479',902.80,0.00,0.00,1.22,104.92,'2022-06-06 18:02:59','',''),(1467,'1','273','1',1,'Retail Sale Id 1481',747.40,0.00,0.00,1.01,86.86,'2022-06-06 18:04:55','',''),(1468,'1','273','1',1,'Retail Sale Id 1482',19996.08,0.00,0.00,28.73,1206.66,'2022-06-06 18:06:50','',''),(1469,'1','273','1',1,'Retail Sale Id 1483',12002.80,0.00,0.00,16.22,1394.92,'2022-06-06 18:17:52','',''),(1470,'1','273','1',1,'Retail Sale Id 1483',13001.80,0.00,0.00,17.57,1511.02,'2022-06-06 18:17:52','',''),(1471,'1','273','1',1,'Retail Sale Id 1484',399.60,0.00,0.00,0.54,46.44,'2022-06-06 18:19:06','',''),(1472,'1','273','1',1,'Retail Sale Id 1485',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 18:20:31','',''),(1473,'1','273','1',1,'Retail Sale Id 1486',1502.20,0.00,0.00,2.03,174.58,'2022-06-06 18:21:19','',''),(1474,'1','273','1',1,'Retail Sale Id 1487',799.20,0.00,0.00,1.08,92.88,'2022-06-06 18:22:02','',''),(1475,'1','273','1',1,'Retail Sale Id 1488',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 18:25:39','',''),(1476,'1','273','1',1,'Return of Retail Sale Id 1488',0.00,9250.00,12.50,0.00,-1075.00,'2022-06-06 18:30:06','',''),(1477,'1','273','1',1,'Retail Sale Id 1489',9250.00,0.00,0.00,12.50,1075.00,'2022-06-06 18:31:02','',''),(1478,'1','273','1',1,'Retail Sale Id 1491',2997.00,0.00,0.00,4.05,348.30,'2022-06-06 18:31:44','',''),(1479,'1','273','1',1,'Retail Sale Id 1492',2220.00,0.00,0.00,3.00,258.00,'2022-06-06 18:35:28','',''),(1480,'1','273','1',1,'Retail Sale Id 1493',3700.00,0.00,0.00,5.00,430.00,'2022-06-06 18:39:38','',''),(1481,'1','273','1',1,'Retail Sale Id 1494',917.60,0.00,0.00,1.24,106.64,'2022-06-06 19:19:45','',''),(1482,'1','273','1',1,'Retail Sale Id 1495',2220.00,0.00,0.00,3.00,258.00,'2022-06-07 06:53:48','',''),(1483,'1','273','1',1,'Retail Sale Id 1496',2997.00,0.00,0.00,4.05,348.30,'2022-06-07 07:01:16','',''),(1484,'1','273','1',1,'Retail Sale Id 1497',3700.00,0.00,0.00,5.00,430.00,'2022-06-07 07:14:03','',''),(1485,'1','273','1',1,'Retail Sale Id 1498',7999.40,0.00,0.00,10.81,929.66,'2022-06-07 07:19:36','',''),(1486,'1','273','1',1,'Retail Sale Id 1499',1998.00,0.00,0.00,2.70,232.20,'2022-06-07 07:31:09','',''),(1487,'1','273','1',1,'Retail Sale Id 1500',1480.00,0.00,0.00,2.00,172.00,'2022-06-07 07:32:19','',''),(1488,'1','273','1',1,'Retail Sale Id 1501',999.00,0.00,0.00,1.35,116.10,'2022-06-07 07:52:08','',''),(1489,'1','273','1',1,'Retail Sale Id 1502',7400.00,0.00,0.00,10.00,860.00,'2022-06-07 07:57:02','',''),(1490,'1','273','1',1,'Retail Sale Id 1503',999.00,0.00,0.00,1.35,116.10,'2022-06-07 08:20:22','',''),(1491,'1','273','1',1,'Retail Sale Id 1504',104400.00,0.00,0.00,150.00,6300.00,'2022-06-07 08:21:47','',''),(1492,'1','273','1',1,'Retail Sale Id 1505',104400.00,0.00,0.00,150.00,6300.00,'2022-06-07 08:22:34','',''),(1493,'1','273','1',1,'Retail Sale Id 1506',1198.80,0.00,0.00,1.62,139.32,'2022-06-07 08:37:20','',''),(1494,'1','273','1',1,'Retail Sale Id 1507',2997.00,0.00,0.00,4.05,348.30,'2022-06-07 09:02:17','',''),(1495,'1','273','1',1,'Retail Sale Id 1508',9250.00,0.00,0.00,12.50,1075.00,'2022-06-07 09:03:07','',''),(1496,'1','273','1',1,'Retail Sale Id 1509',799.20,0.00,0.00,1.08,92.88,'2022-06-07 09:04:33','',''),(1497,'1','273','1',1,'Retail Sale Id 1510',16008.00,0.00,0.00,23.00,966.00,'2022-06-07 09:10:04','',''),(1498,'1','273','1',1,'Retail Sale Id 1511',5180.00,0.00,0.00,7.00,602.00,'2022-06-07 09:12:26','',''),(1499,'1','273','1',1,'Retail Sale Id 1512',999.00,0.00,0.00,1.35,116.10,'2022-06-07 09:21:50','',''),(1500,'1','273','1',1,'Retail Sale Id 1513',29232.00,0.00,0.00,42.00,1764.00,'2022-06-07 09:25:05','',''),(1501,'1','273','1',1,'Retail Sale Id 1514',50460.00,0.00,0.00,72.50,3045.00,'2022-06-07 09:43:55','',''),(1502,'1','273','1',1,'Retail Sale Id 1515',3700.00,0.00,0.00,5.00,430.00,'2022-06-07 09:46:31','',''),(1503,'1','273','1',1,'Retail Sale Id 1516',2501.20,0.00,0.00,3.38,290.68,'2022-06-07 09:49:21','',''),(1504,'1','273','1',1,'Retail Sale Id 1517',4440.00,0.00,0.00,6.00,516.00,'2022-06-07 10:20:29','',''),(1505,'1','273','1',1,'Retail Sale Id 1518',6001.40,0.00,0.00,8.11,697.46,'2022-06-07 10:28:14','',''),(1506,'1','273','1',1,'Retail Sale Id 1519',2997.00,0.00,0.00,4.05,348.30,'2022-06-07 10:38:50','',''),(1507,'1','273','1',1,'Retail Sale Id 1520',2997.00,0.00,0.00,4.05,348.30,'2022-06-07 10:53:26','',''),(1508,'1','273','1',1,'Retail Sale Id 1521',139200.00,0.00,0.00,200.00,8400.00,'2022-06-07 11:06:42','',''),(1509,'1','273','1',1,'Retail Sale Id 1522',104400.00,0.00,0.00,150.00,6300.00,'2022-06-07 11:07:59','',''),(1510,'1','273','1',1,'Retail Sale Id 1523',999.00,0.00,0.00,1.35,116.10,'2022-06-07 11:13:35','',''),(1511,'1','273','1',1,'Retail Sale Id 1524',1502.20,0.00,0.00,2.03,174.58,'2022-06-07 11:21:16','',''),(1512,'1','273','1',1,'Retail Sale Id 1525',999.00,0.00,0.00,1.35,116.10,'2022-06-07 11:31:27','',''),(1513,'1','273','1',1,'Retail Sale Id 1526',2960.00,0.00,0.00,4.00,344.00,'2022-06-07 11:54:40','',''),(1514,'1','273','1',1,'Retail Sale Id 1526',5180.00,0.00,0.00,7.00,602.00,'2022-06-07 11:54:40','',''),(1515,'1','273','1',1,'Retail Sale Id 1527',2197.80,0.00,0.00,2.97,255.42,'2022-06-07 12:07:39','',''),(1516,'1','273','1',1,'Retail Sale Id 1528',3700.00,0.00,0.00,5.00,430.00,'2022-06-07 12:53:53','',''),(1517,'1','273','1',1,'Retail Sale Id 1529',1480.00,0.00,0.00,2.00,172.00,'2022-06-07 13:00:53','',''),(1518,'1','273','1',1,'Retail Sale Id 1530',2960.00,0.00,0.00,4.00,344.00,'2022-06-07 13:08:21','',''),(1519,'1','273','1',1,'Retail Sale Id 1531',1598.40,0.00,0.00,2.16,185.76,'2022-06-07 13:23:32','',''),(1520,'1','273','1',1,'Retail Sale Id 1532',3700.00,0.00,0.00,5.00,430.00,'2022-06-07 13:32:07','',''),(1521,'1','273','1',1,'Retail Sale Id 1533',9250.00,0.00,0.00,12.50,1075.00,'2022-06-07 14:14:53','',''),(1522,'1','273','1',1,'Retail Sale Id 1534',3700.00,0.00,0.00,5.00,430.00,'2022-06-07 14:19:44','',''),(1523,'1','273','1',1,'Retail Sale Id 1535',1998.00,0.00,0.00,2.70,232.20,'2022-06-07 14:32:20','',''),(1524,'1','273','1',1,'Retail Sale Id 1536',9250.00,0.00,0.00,12.50,1075.00,'2022-06-07 15:06:50','',''),(1525,'1','273','1',1,'Retail Sale Id 1537',2220.00,0.00,0.00,3.00,258.00,'2022-06-07 15:56:13','',''),(1526,'1','273','1',1,'Retail Sale Id 1538',3500.20,0.00,0.00,4.73,406.78,'2022-06-07 15:59:35','',''),(1527,'1','273','1',1,'Retail Sale Id 1539',1502.20,0.00,0.00,2.03,174.58,'2022-06-07 16:02:48','',''),(1528,'1','273','1',1,'Retail Sale Id 1540',2220.00,0.00,0.00,3.00,258.00,'2022-06-07 16:14:22','',''),(1529,'1','273','1',1,'Retail Sale Id 1541',799.20,0.00,0.00,1.08,92.88,'2022-06-07 16:17:05','',''),(1530,'1','273','1',1,'Retail Sale Id 1542',1998.00,0.00,0.00,2.70,232.20,'2022-06-07 16:18:11','',''),(1531,'1','273','1',1,'Retail Sale Id 1543',3700.00,0.00,0.00,5.00,430.00,'2022-06-07 16:20:07','',''),(1532,'1','273','1',1,'Retail Sale Id 1544',3700.00,0.00,0.00,5.00,430.00,'2022-06-07 16:22:48','',''),(1533,'1','273','1',1,'Retail Sale Id 1545',2997.00,0.00,0.00,4.05,348.30,'2022-06-07 16:24:05','',''),(1534,'1','273','1',1,'Retail Sale Id 1546',1502.20,0.00,0.00,2.03,174.58,'2022-06-07 16:31:47','',''),(1535,'1','273','1',1,'Retail Sale Id 1547',1502.20,0.00,0.00,2.03,174.58,'2022-06-07 16:32:51','',''),(1536,'1','273','1',1,'Retail Sale Id 1548',1998.00,0.00,0.00,2.70,232.20,'2022-06-07 16:49:26','',''),(1537,'1','273','1',1,'Retail Sale Id 1549',3700.00,0.00,0.00,5.00,430.00,'2022-06-07 16:53:03','',''),(1538,'1','273','1',1,'Retail Sale Id 1550',1502.20,0.00,0.00,2.03,174.58,'2022-06-07 16:55:27','',''),(1539,'1','273','1',1,'Retail Sale Id 1551',2020.20,0.00,0.00,2.73,234.78,'2022-06-07 17:06:11','',''),(1540,'1','273','1',1,'Retail Sale Id 1552',9250.00,0.00,0.00,12.50,1075.00,'2022-06-07 17:18:30','',''),(1541,'1','273','1',1,'Retail Sale Id 1553',1502.20,0.00,0.00,2.03,174.58,'2022-06-07 17:23:25','',''),(1542,'1','273','1',1,'Retail Sale Id 1554',2301.40,0.00,0.00,3.11,267.46,'2022-06-07 17:31:01','',''),(1543,'1','273','1',1,'Retail Sale Id 1555',27840.00,0.00,0.00,40.00,1680.00,'2022-06-07 17:32:21','',''),(1544,'1','273','1',1,'Retail Sale Id 1556',2501.20,0.00,0.00,3.38,290.68,'2022-06-07 17:34:05','',''),(1545,'1','273','1',1,'Retail Sale Id 1557',1998.00,0.00,0.00,2.70,232.20,'2022-06-07 17:35:58','',''),(1546,'1','273','1',1,'Retail Sale Id 1558',747.40,0.00,0.00,1.01,86.86,'2022-06-07 17:40:17','',''),(1547,'1','273','1',1,'Retail Sale Id 1559',5498.20,0.00,0.00,7.43,638.98,'2022-06-07 17:41:16','',''),(1548,'1','273','1',1,'Retail Sale Id 1559',5498.20,0.00,0.00,7.43,638.98,'2022-06-07 17:41:16','',''),(1549,'1','273','1',1,'Retail Sale Id 1560',69600.00,0.00,0.00,100.00,4200.00,'2022-06-07 17:43:37','',''),(1550,'1','273','1',1,'Retail Sale Id 1561',7999.40,0.00,0.00,10.81,929.66,'2022-06-07 17:45:01','',''),(1551,'1','273','1',1,'Retail Sale Id 1562',4440.00,0.00,0.00,6.00,516.00,'2022-06-07 17:47:15','',''),(1552,'1','273','1',1,'Retail Sale Id 1563',7400.00,0.00,0.00,10.00,860.00,'2022-06-07 17:52:06','',''),(1553,'1','273','1',1,'Retail Sale Id 1564',747.40,0.00,0.00,1.01,86.86,'2022-06-07 17:54:18','',''),(1554,'1','273','1',1,'Retail Sale Id 1565',747.40,0.00,0.00,1.01,86.86,'2022-06-07 17:57:34','',''),(1555,'1','273','1',1,'Retail Sale Id 1566',999.00,0.00,0.00,1.35,116.10,'2022-06-07 17:58:24','',''),(1556,'1','273','1',1,'Retail Sale Id 1567',4440.00,0.00,0.00,6.00,516.00,'2022-06-07 17:59:18','',''),(1557,'1','273','1',1,'Retail Sale Id 1568',2997.00,0.00,0.00,4.05,348.30,'2022-06-07 18:00:45','',''),(1558,'1','273','1',1,'Retail Sale Id 1569',2797.20,0.00,0.00,3.78,325.08,'2022-06-07 18:10:41','',''),(1559,'1','273','1',1,'Retail Sale Id 1570',1502.20,0.00,0.00,2.03,174.58,'2022-06-07 18:18:23','',''),(1560,'1','273','1',1,'Retail Sale Id 1571',399.60,0.00,0.00,0.54,46.44,'2022-06-07 18:37:37','',''),(1561,'1','273','1',1,'Distributed to OPERATIONAL LOSE for sales id:2',448081.56,0.00,0.00,685.14,0.00,'2022-06-07 21:18:40','',''),(1562,'1','273','1',1,'Retail Sale Id 1572',747.40,0.00,0.00,1.01,86.86,'2022-06-08 07:02:24','',''),(1563,'1','273','1',1,'Retail Sale Id 1573',2220.00,0.00,0.00,3.00,258.00,'2022-06-08 07:03:34','',''),(1564,'1','273','1',1,'Retail Sale Id 1574',1480.00,0.00,0.00,2.00,172.00,'2022-06-08 07:04:55','',''),(1565,'1','273','1',1,'Retail Sale Id 1574',13001.80,0.00,0.00,17.57,1511.02,'2022-06-08 07:04:55','',''),(1566,'1','273','1',1,'Retail Sale Id 1575',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 07:05:55','',''),(1567,'1','273','1',1,'Retail Sale Id 1576',5180.00,0.00,0.00,7.00,602.00,'2022-06-08 07:20:53','',''),(1568,'1','273','1',1,'Retail Sale Id 1577',2501.20,0.00,0.00,3.38,290.68,'2022-06-08 07:26:56','',''),(1569,'1','273','1',1,'Retail Sale Id 1578',1480.00,0.00,0.00,2.00,172.00,'2022-06-08 07:31:49','',''),(1570,'1','273','1',1,'Retail Sale Id 1579',2220.00,0.00,0.00,3.00,258.00,'2022-06-08 07:51:42','',''),(1571,'1','273','1',1,'Retail Sale Id 1581',9250.00,0.00,0.00,12.50,1075.00,'2022-06-08 07:57:17','',''),(1572,'1','273','1',1,'Retail Sale Id 1582',2997.00,0.00,0.00,4.05,348.30,'2022-06-08 08:13:21','',''),(1573,'1','273','1',1,'Retail Sale Id 1583',2249.60,0.00,0.00,3.04,261.44,'2022-06-08 08:14:54','',''),(1574,'1','273','1',1,'Retail Sale Id 1584',34800.00,0.00,0.00,50.00,2100.00,'2022-06-08 08:23:37','',''),(1575,'1','273','1',1,'Retail Sale Id 1585',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 08:26:21','',''),(1576,'1','273','1',1,'Retail Sale Id 1586',9250.00,0.00,0.00,12.50,1075.00,'2022-06-08 08:28:34','',''),(1577,'1','273','1',1,'Retail Sale Id 1587',999.00,0.00,0.00,1.35,116.10,'2022-06-08 08:50:53','',''),(1578,'1','273','1',1,'Retail Sale Id 1588',87696.00,0.00,0.00,126.00,5292.00,'2022-06-08 08:55:39','',''),(1579,'1','273','1',1,'Retail Sale Id 1589',3700.00,0.00,0.00,5.00,430.00,'2022-06-08 08:56:42','',''),(1580,'1','273','1',1,'Retail Sale Id 1590',4440.00,0.00,0.00,6.00,516.00,'2022-06-08 09:10:03','',''),(1581,'1','273','1',1,'Retail Sale Id 1591',740.00,0.00,0.00,1.00,86.00,'2022-06-08 09:12:32','',''),(1582,'1','273','1',1,'Retail Sale Id 1592',999.00,0.00,0.00,1.35,116.10,'2022-06-08 09:17:59','',''),(1583,'1','273','1',1,'Retail Sale Id 1593',1480.00,0.00,0.00,2.00,172.00,'2022-06-08 09:18:56','',''),(1584,'1','273','1',1,'Retail Sale Id 1594',799.20,0.00,0.00,1.08,92.88,'2022-06-08 09:27:56','',''),(1585,'1','273','1',1,'Retail Sale Id 1595',6660.00,0.00,0.00,9.00,774.00,'2022-06-08 09:43:37','',''),(1586,'1','273','1',1,'Retail Sale Id 1597',3700.00,0.00,0.00,5.00,430.00,'2022-06-08 09:45:53','',''),(1587,'1','273','1',1,'Retail Sale Id 1599',11100.00,0.00,0.00,15.00,1290.00,'2022-06-08 09:48:27','',''),(1588,'1','273','1',1,'Retail Sale Id 1601',104400.00,0.00,0.00,150.00,6300.00,'2022-06-08 09:49:52','',''),(1589,'1','273','1',1,'Retail Sale Id 1602',104400.00,0.00,0.00,150.00,6300.00,'2022-06-08 09:50:50','',''),(1590,'1','273','1',1,'Retail Sale Id 1603',1998.00,0.00,0.00,2.70,232.20,'2022-06-08 09:52:09','',''),(1591,'1','273','1',1,'Retail Sale Id 1604',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 09:57:13','',''),(1592,'1','273','1',1,'Return of Retail Sale Id 1599',0.00,11100.00,15.00,0.00,-1290.00,'2022-06-08 10:08:34','',''),(1593,'1','273','1',1,'Retail Sale Id 1605',10552.40,0.00,0.00,14.26,1226.36,'2022-06-08 10:09:39','',''),(1594,'1','273','1',1,'Retail Sale Id 1606',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 10:14:05','',''),(1595,'1','273','1',1,'Retail Sale Id 1606',1998.00,0.00,0.00,2.70,232.20,'2022-06-08 10:14:05','',''),(1596,'1','273','1',1,'Retail Sale Id 1607',747.40,0.00,0.00,1.01,86.86,'2022-06-08 10:16:44','',''),(1597,'1','273','1',1,'Retail Sale Id 1608',999.00,0.00,0.00,1.35,116.10,'2022-06-08 10:24:41','',''),(1598,'1','273','1',1,'Retail Sale Id 1609',9250.00,0.00,0.00,12.50,1075.00,'2022-06-08 10:26:10','',''),(1599,'1','273','1',1,'Retail Sale Id 1610',2501.20,0.00,0.00,3.38,290.68,'2022-06-08 10:34:08','',''),(1600,'1','273','1',1,'Retail Sale Id 1612',9250.00,0.00,0.00,12.50,1075.00,'2022-06-08 10:44:17','',''),(1601,'1','273','1',1,'Retail Sale Id 1613',999.00,0.00,0.00,1.35,116.10,'2022-06-08 10:45:40','',''),(1602,'1','273','1',1,'Retail Sale Id 1614',999.00,0.00,0.00,1.35,116.10,'2022-06-08 10:46:47','',''),(1603,'1','273','1',1,'Retail Sale Id 1615',3700.00,0.00,0.00,5.00,430.00,'2022-06-08 10:53:06','',''),(1604,'1','273','1',1,'Retail Sale Id 1616',747.40,0.00,0.00,1.01,86.86,'2022-06-08 10:54:56','',''),(1605,'1','273','1',1,'Retail Sale Id 1617',125280.00,0.00,0.00,180.00,7560.00,'2022-06-08 10:56:35','',''),(1606,'1','273','1',1,'Retail Sale Id 1618',125280.00,0.00,0.00,180.00,7560.00,'2022-06-08 10:58:06','',''),(1607,'1','273','1',1,'Retail Sale Id 1619',747.40,0.00,0.00,1.01,86.86,'2022-06-08 11:08:26','',''),(1608,'1','273','1',1,'Retail Sale Id 1620',999.00,0.00,0.00,1.35,116.10,'2022-06-08 11:10:40','',''),(1609,'1','273','1',1,'Retail Sale Id 1621',4447.40,0.00,0.00,6.01,516.86,'2022-06-08 11:38:53','',''),(1610,'1','273','1',1,'Retail Sale Id 1622',3700.00,0.00,0.00,5.00,430.00,'2022-06-08 11:43:07','',''),(1611,'1','273','1',1,'Retail Sale Id 1623',4440.00,0.00,0.00,6.00,516.00,'2022-06-08 12:27:00','',''),(1612,'1','273','1',1,'Retail Sale Id 1624',999.00,0.00,0.00,1.35,116.10,'2022-06-08 12:29:12','',''),(1613,'1','273','1',1,'Retail Sale Id 1626',3700.00,0.00,0.00,5.00,430.00,'2022-06-08 13:00:07','',''),(1614,'1','273','1',1,'Retail Sale Id 1627',18500.00,0.00,0.00,25.00,2150.00,'2022-06-08 13:02:39','',''),(1615,'1','273','1',1,'Retail Sale Id 1628',999.00,0.00,0.00,1.35,116.10,'2022-06-08 13:26:50','',''),(1616,'1','273','1',1,'Retail Sale Id 1629',104400.00,0.00,0.00,150.00,6300.00,'2022-06-08 13:35:47','',''),(1617,'1','273','1',1,'Retail Sale Id 1630',57072.00,0.00,0.00,82.00,3444.00,'2022-06-08 13:37:54','',''),(1618,'1','273','1',1,'Retail Sale Id 1631',63983.28,0.00,0.00,91.93,3861.06,'2022-06-08 13:52:42','',''),(1619,'1','273','1',1,'Retail Sale Id 1632',60913.92,0.00,0.00,87.52,3675.84,'2022-06-08 13:53:26','',''),(1620,'1','273','1',1,'Retail Sale Id 1633',999.00,0.00,0.00,1.35,116.10,'2022-06-08 13:54:07','',''),(1621,'1','273','1',1,'Retail Sale Id 1634',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 13:57:53','',''),(1622,'1','273','1',1,'Retail Sale Id 1635',2397.60,0.00,0.00,3.24,278.64,'2022-06-08 14:03:41','',''),(1623,'1','273','1',1,'Retail Sale Id 1636',3263.40,0.00,0.00,4.41,379.26,'2022-06-08 14:04:43','',''),(1624,'1','273','1',1,'Retail Sale Id 1637',9250.00,0.00,0.00,12.50,1075.00,'2022-06-08 14:05:44','',''),(1625,'1','273','1',1,'Retail Sale Id 1638',747.40,0.00,0.00,1.01,86.86,'2022-06-08 14:09:22','',''),(1626,'1','273','1',1,'Retail Sale Id 1639',0.00,0.00,0.00,0.00,0.00,'2022-06-08 14:25:24','',''),(1627,'1','273','1',1,'Return of Retail Sale Id 1639',0.00,0.00,0.00,0.00,0.00,'2022-06-08 14:30:39','',''),(1628,'1','273','1',1,'Retail Sale Id 1640',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 14:31:21','',''),(1629,'1','273','1',1,'Retail Sale Id 1641',4440.00,0.00,0.00,6.00,516.00,'2022-06-08 14:33:06','',''),(1630,'1','273','1',1,'Retail Sale Id 1642',1998.00,0.00,0.00,2.70,232.20,'2022-06-08 14:34:46','',''),(1631,'1','273','1',1,'Return of Retail Sale Id 1641',0.00,4440.00,6.00,0.00,-516.00,'2022-06-08 14:38:09','',''),(1632,'1','273','1',1,'Return of Retail Sale Id 1642',0.00,1998.00,2.70,0.00,-232.20,'2022-06-08 14:38:46','',''),(1633,'1','273','1',1,'Retail Sale Id 1643',1480.00,0.00,0.00,2.00,172.00,'2022-06-08 14:39:19','',''),(1634,'1','273','1',1,'Retail Sale Id 1644',3700.00,0.00,0.00,5.00,430.00,'2022-06-08 14:39:56','',''),(1635,'1','273','1',1,'Retail Sale Id 1645',23664.00,0.00,0.00,34.00,1428.00,'2022-06-08 14:43:47','',''),(1636,'1','273','1',1,'Retail Sale Id 1646',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 15:22:04','',''),(1637,'1','273','1',1,'Retail Sale Id 1647',5180.00,0.00,0.00,7.00,602.00,'2022-06-08 15:27:05','',''),(1638,'1','273','1',1,'Retail Sale Id 1648',1480.00,0.00,0.00,2.00,172.00,'2022-06-08 15:51:35','',''),(1639,'1','273','1',1,'Retail Sale Id 1649',999.00,0.00,0.00,1.35,116.10,'2022-06-08 15:52:34','',''),(1640,'1','273','1',1,'Retail Sale Id 1650',1480.00,0.00,0.00,2.00,172.00,'2022-06-08 15:53:54','',''),(1641,'1','273','1',1,'Retail Sale Id 1651',8880.00,0.00,0.00,12.00,1032.00,'2022-06-08 16:19:58','',''),(1642,'1','273','1',1,'Retail Sale Id 1652',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 16:36:57','',''),(1643,'1','273','1',1,'Retail Sale Id 1653',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 17:09:45','',''),(1644,'1','273','1',1,'Retail Sale Id 1654',87000.00,0.00,0.00,125.00,5250.00,'2022-06-08 17:14:13','',''),(1645,'1','273','1',1,'Retail Sale Id 1655',740.00,0.00,0.00,1.00,86.00,'2022-06-08 17:15:45','',''),(1646,'1','273','1',1,'Retail Sale Id 1656',799.20,0.00,0.00,1.08,92.88,'2022-06-08 17:16:41','',''),(1647,'1','273','1',1,'Retail Sale Id 1657',1998.00,0.00,0.00,2.70,232.20,'2022-06-08 17:22:46','',''),(1648,'1','273','1',1,'Retail Sale Id 1658',4440.00,0.00,0.00,6.00,516.00,'2022-06-08 17:30:18','',''),(1649,'1','273','1',1,'Retail Sale Id 1659',999.00,0.00,0.00,1.35,116.10,'2022-06-08 17:31:31','',''),(1650,'1','273','1',1,'Retail Sale Id 1660',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 17:32:16','',''),(1651,'1','273','1',1,'Retail Sale Id 1661',1398.60,0.00,0.00,1.89,162.54,'2022-06-08 17:33:52','',''),(1652,'1','273','1',1,'Retail Sale Id 1662',104400.00,0.00,0.00,150.00,6300.00,'2022-06-08 17:39:38','',''),(1653,'1','273','1',1,'Retail Sale Id 1663',69600.00,0.00,0.00,100.00,4200.00,'2022-06-08 17:40:16','',''),(1654,'1','273','1',1,'Retail Sale Id 1664',799.20,0.00,0.00,1.08,92.88,'2022-06-08 17:41:21','',''),(1655,'1','273','1',1,'Retail Sale Id 1665',999.00,0.00,0.00,1.35,116.10,'2022-06-08 17:42:01','',''),(1656,'1','273','1',1,'Retail Sale Id 1666',1998.00,0.00,0.00,2.70,232.20,'2022-06-08 17:42:43','',''),(1657,'1','273','1',1,'Retail Sale Id 1667',999.00,0.00,0.00,1.35,116.10,'2022-06-08 17:46:22','',''),(1658,'1','273','1',1,'Retail Sale Id 1668',999.00,0.00,0.00,1.35,116.10,'2022-06-08 17:47:18','',''),(1659,'1','273','1',1,'Retail Sale Id 1669',2220.00,0.00,0.00,3.00,258.00,'2022-06-08 17:51:06','',''),(1660,'1','273','1',1,'Retail Sale Id 1670',2220.00,0.00,0.00,3.00,258.00,'2022-06-08 17:51:47','',''),(1661,'1','273','1',1,'Retail Sale Id 1671',999.00,0.00,0.00,1.35,116.10,'2022-06-08 17:52:51','',''),(1662,'1','273','1',1,'Retail Sale Id 1672',34800.00,0.00,0.00,50.00,2100.00,'2022-06-08 17:56:06','',''),(1663,'1','273','1',1,'Retail Sale Id 1673',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 18:00:32','',''),(1664,'1','273','1',1,'Retail Sale Id 1674',4440.00,0.00,0.00,6.00,516.00,'2022-06-08 18:03:02','',''),(1665,'1','273','1',1,'Retail Sale Id 1675',2960.00,0.00,0.00,4.00,344.00,'2022-06-08 18:13:58','',''),(1666,'1','273','1',1,'Retail Sale Id 1676',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 18:15:04','',''),(1667,'1','273','1',1,'Retail Sale Id 1677',747.40,0.00,0.00,1.01,86.86,'2022-06-08 18:15:53','',''),(1668,'1','273','1',1,'Retail Sale Id 1678',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 18:16:40','',''),(1669,'1','273','1',1,'Retail Sale Id 1679',1502.20,0.00,0.00,2.03,174.58,'2022-06-08 18:17:53','',''),(1670,'1','273','1',1,'Retail Sale Id 1680',9620.00,0.00,0.00,13.00,1118.00,'2022-06-08 18:23:06','',''),(1671,'1','273','1',1,'Return of Retail Sale Id 1658',0.00,4440.00,6.00,0.00,-516.00,'2022-06-08 18:52:25','',''),(1672,'1','273','1',1,'Retail Sale Id 1681',4129.20,0.00,0.00,5.58,479.88,'2022-06-08 18:53:10','',''),(1673,'1','273','1',1,'Retail Sale Id 1683',13001.80,0.00,0.00,17.57,1511.02,'2022-06-09 06:52:09','',''),(1674,'1','273','1',1,'Retail Sale Id 1683',14999.80,0.00,0.00,20.27,1743.22,'2022-06-09 06:52:09','',''),(1675,'1','273','1',1,'Retail Sale Id 1684',2197.80,0.00,0.00,2.97,255.42,'2022-06-09 06:52:46','',''),(1676,'1','273','1',1,'Retail Sale Id 1685',999.00,0.00,0.00,1.35,116.10,'2022-06-09 06:53:42','',''),(1677,'1','273','1',1,'Retail Sale Id 1686',4440.00,0.00,0.00,6.00,516.00,'2022-06-09 06:54:42','',''),(1678,'1','273','1',1,'Retail Sale Id 1687',1998.00,0.00,0.00,2.70,232.20,'2022-06-09 06:55:42','',''),(1679,'1','273','1',1,'Retail Sale Id 1688',2997.00,0.00,0.00,4.05,348.30,'2022-06-09 06:57:21','',''),(1680,'1','273','1',1,'Retail Sale Id 1689',1480.00,0.00,0.00,2.00,172.00,'2022-06-09 07:09:00','',''),(1681,'1','273','1',1,'Retail Sale Id 1691',740.00,0.00,0.00,1.00,86.00,'2022-06-09 07:10:17','',''),(1682,'1','273','1',1,'Retail Sale Id 1692',4440.00,0.00,0.00,6.00,516.00,'2022-06-09 07:21:42','',''),(1683,'1','273','1',1,'Retail Sale Id 1693',1998.00,0.00,0.00,2.70,232.20,'2022-06-09 07:22:37','',''),(1684,'1','273','1',1,'Retail Sale Id 1694',2997.00,0.00,0.00,4.05,348.30,'2022-06-09 07:23:18','',''),(1685,'1','273','1',1,'Retail Sale Id 1695',2997.00,0.00,0.00,4.05,348.30,'2022-06-09 07:24:07','',''),(1686,'1','273','1',1,'Retail Sale Id 1696',1502.20,0.00,0.00,2.03,174.58,'2022-06-09 07:24:58','',''),(1687,'1','273','1',1,'Retail Sale Id 1697',3500.20,0.00,0.00,4.73,406.78,'2022-06-09 07:30:11','',''),(1688,'1','273','1',1,'Retail Sale Id 1698',999.00,0.00,0.00,1.35,116.10,'2022-06-09 07:35:34','',''),(1689,'1','273','1',1,'Retail Sale Id 1699',2997.00,0.00,0.00,4.05,348.30,'2022-06-09 07:37:07','',''),(1690,'1','273','1',1,'Retail Sale Id 1700',999.00,0.00,0.00,1.35,116.10,'2022-06-09 07:37:46','',''),(1691,'1','273','1',1,'Retail Sale Id 1701',2960.00,0.00,0.00,4.00,344.00,'2022-06-09 07:46:11','',''),(1692,'1','273','1',1,'Retail Sale Id 1702',1502.20,0.00,0.00,2.03,174.58,'2022-06-09 07:47:08','',''),(1693,'1','273','1',1,'Retail Sale Id 1703',999.00,0.00,0.00,1.35,116.10,'2022-06-09 07:58:12','',''),(1694,'1','273','1',1,'Retail Sale Id 1704',999.00,0.00,0.00,1.35,116.10,'2022-06-09 08:26:04','',''),(1695,'1','273','1',1,'Retail Sale Id 1705',3700.00,0.00,0.00,5.00,430.00,'2022-06-09 08:46:13','',''),(1696,'1','273','1',1,'Retail Sale Id 1706',62640.00,0.00,0.00,90.00,3780.00,'2022-06-09 08:48:20','',''),(1697,'1','273','1',1,'Retail Sale Id 1707',5498.20,0.00,0.00,7.43,638.98,'2022-06-09 08:49:13','',''),(1698,'1','273','1',1,'Retail Sale Id 1708',3700.00,0.00,0.00,5.00,430.00,'2022-06-09 08:51:52','',''),(1699,'1','273','1',1,'Retail Sale Id 1709',1502.20,0.00,0.00,2.03,174.58,'2022-06-09 09:38:00','',''),(1700,'1','273','1',1,'Retail Sale Id 1710',1480.00,0.00,0.00,2.00,172.00,'2022-06-09 09:40:23','',''),(1701,'1','273','1',1,'Retail Sale Id 1711',747.40,0.00,0.00,1.01,86.86,'2022-06-09 09:43:48','',''),(1702,'1','273','1',1,'Retail Sale Id 1712',2220.00,0.00,0.00,3.00,258.00,'2022-06-09 09:46:14','',''),(1703,'1','273','1',1,'Retail Sale Id 1713',69600.00,0.00,0.00,100.00,4200.00,'2022-06-09 09:50:24','',''),(1704,'1','273','1',1,'Retail Sale Id 1714',1502.20,0.00,0.00,2.03,174.58,'2022-06-09 09:52:51','',''),(1705,'1','273','1',1,'Retail Sale Id 1715',2249.60,0.00,0.00,3.04,261.44,'2022-06-09 09:53:54','',''),(1706,'1','273','1',1,'Retail Sale Id 1716',7400.00,0.00,0.00,10.00,860.00,'2022-06-09 09:55:05','',''),(1707,'1','273','1',1,'Retail Sale Id 1717',3700.00,0.00,0.00,5.00,430.00,'2022-06-09 09:56:17','',''),(1708,'1','273','1',1,'Retail Sale Id 1718',69600.00,0.00,0.00,100.00,4200.00,'2022-06-09 09:58:26','',''),(1709,'1','273','1',1,'Retail Sale Id 1719',348000.00,0.00,0.00,500.00,21000.00,'2022-06-09 09:59:34','',''),(1710,'1','273','1',1,'Retail Sale Id 1720',348000.00,0.00,0.00,500.00,21000.00,'2022-06-09 10:00:20','',''),(1711,'1','273','1',1,'Retail Sale Id 1721',1480.00,0.00,0.00,2.00,172.00,'2022-06-09 10:01:18','',''),(1712,'1','273','1',1,'Retail Sale Id 1722',5002.40,0.00,0.00,6.76,581.36,'2022-06-09 10:08:44','',''),(1713,'1','273','1',1,'Retail Sale Id 1723',1480.00,0.00,0.00,2.00,172.00,'2022-06-09 10:11:31','',''),(1714,'1','273','1',1,'Retail Sale Id 1724',26100.00,0.00,0.00,37.50,1575.00,'2022-06-09 10:39:18','',''),(1715,'1','273','1',1,'Retail Sale Id 1725',34800.00,0.00,0.00,50.00,2100.00,'2022-06-09 11:23:57','',''),(1716,'1','273','1',1,'Retail Sale Id 1726',83520.00,0.00,0.00,120.00,5040.00,'2022-06-09 11:31:24','',''),(1717,'1','273','1',1,'Retail Sale Id 1727',41760.00,0.00,0.00,60.00,2520.00,'2022-06-09 11:32:39','',''),(1718,'1','273','1',1,'Retail Sale Id 1728',2997.00,0.00,0.00,4.05,348.30,'2022-06-09 11:39:46','',''),(1719,'1','273','1',1,'Retail Sale Id 1729',1480.00,0.00,0.00,2.00,172.00,'2022-06-09 11:54:30','',''),(1720,'1','273','1',1,'Retail Sale Id 1730',104400.00,0.00,0.00,150.00,6300.00,'2022-06-09 12:37:32','',''),(1721,'1','273','1',1,'Retail Sale Id 1731',47328.00,0.00,0.00,68.00,2856.00,'2022-06-09 12:39:06','',''),(1722,'1','273','1',1,'Retail Sale Id 1732',9250.00,0.00,0.00,12.50,1075.00,'2022-06-09 13:13:54','',''),(1723,'1','273','1',1,'Retail Sale Id 1733',2220.00,0.00,0.00,3.00,258.00,'2022-06-09 14:10:40','',''),(1724,'1','273','1',1,'Retail Sale Id 1735',999.00,0.00,0.00,1.35,116.10,'2022-06-09 14:18:03','',''),(1725,'1','273','1',1,'Retail Sale Id 1736',740.00,0.00,0.00,1.00,86.00,'2022-06-09 14:56:19','',''),(1726,'1','273','1',1,'Retail Sale Id 1736',1502.20,0.00,0.00,2.03,174.58,'2022-06-09 14:56:19','',''),(1727,'1','273','1',1,'Retail Sale Id 1737',2220.00,0.00,0.00,3.00,258.00,'2022-06-09 14:57:17','',''),(1728,'1','273','1',1,'Retail Sale Id 1738',9250.00,0.00,0.00,12.50,1075.00,'2022-06-09 15:15:26','',''),(1729,'1','273','1',1,'Retail Sale Id 1739',1502.20,0.00,0.00,2.03,174.58,'2022-06-09 15:16:31','',''),(1730,'1','273','1',1,'Retail Sale Id 1740',9250.00,0.00,0.00,12.50,1075.00,'2022-06-09 15:18:43','',''),(1731,'1','273','1',1,'Retail Sale Id 1741',2960.00,0.00,0.00,4.00,344.00,'2022-06-09 15:20:11','',''),(1732,'1','273','1',1,'Retail Sale Id 1741',2960.00,0.00,0.00,4.00,344.00,'2022-06-09 15:20:11','',''),(1733,'1','273','1',1,'Retail Sale Id 1742',740.00,0.00,0.00,1.00,86.00,'2022-06-09 15:21:54','',''),(1734,'1','273','1',1,'Retail Sale Id 1742',740.00,0.00,0.00,1.00,86.00,'2022-06-09 15:21:54','',''),(1735,'1','273','1',1,'Retail Sale Id 1743',4440.00,0.00,0.00,6.00,516.00,'2022-06-09 15:23:20','',''),(1736,'1','273','1',1,'Retail Sale Id 1744',902.80,0.00,0.00,1.22,104.92,'2022-06-09 15:25:02','',''),(1737,'1','273','1',1,'Retail Sale Id 1745',11840.00,0.00,0.00,16.00,1376.00,'2022-06-09 15:26:06','',''),(1738,'1','273','1',1,'Return of Retail Sale Id 1736',0.00,740.00,1.00,0.00,-86.00,'2022-06-09 15:27:56','',''),(1739,'1','273','1',1,'Return of Retail Sale Id 1736',0.00,1502.20,2.03,0.00,-174.58,'2022-06-09 15:27:56','',''),(1740,'1','273','1',1,'Retail Sale Id 1747',740.00,0.00,0.00,1.00,86.00,'2022-06-09 15:28:37','',''),(1741,'1','273','1',1,'Retail Sale Id 1748',1502.20,0.00,0.00,2.03,174.58,'2022-06-09 15:29:26','',''),(1742,'1','273','1',1,'Retail Sale Id 1749',5920.00,0.00,0.00,8.00,688.00,'2022-06-09 15:30:08','',''),(1743,'1','273','1',1,'Retail Sale Id 1750',9250.00,0.00,0.00,12.50,1075.00,'2022-06-09 15:31:12','',''),(1744,'1','273','1',1,'Retail Sale Id 1751',1998.00,0.00,0.00,2.70,232.20,'2022-06-09 15:32:08','',''),(1745,'1','273','1',1,'Retail Sale Id 1752',1998.00,0.00,0.00,2.70,232.20,'2022-06-09 15:35:31','',''),(1746,'1','273','1',1,'Retail Sale Id 1753',2220.00,0.00,0.00,3.00,258.00,'2022-06-09 15:48:25','',''),(1747,'1','273','1',1,'Retail Sale Id 1754',1502.20,0.00,0.00,2.03,174.58,'2022-06-09 15:49:47','',''),(1748,'1','273','1',1,'Retail Sale Id 1755',5920.00,0.00,0.00,8.00,688.00,'2022-06-09 15:51:51','',''),(1749,'1','273','1',1,'Retail Sale Id 1756',5920.00,0.00,0.00,8.00,688.00,'2022-06-09 15:54:05','',''),(1750,'1','273',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,1392.00,0.00,'2022-06-09 16:11:57','',''),(1751,'1','273','1',1,'Received from bridging 6',0.00,0.00,1392.00,0.00,0.00,'2022-06-09 16:11:57','',''),(1752,'1','273','1',1,'Retail Sale Id 1757',9250.00,0.00,0.00,12.50,1075.00,'2022-06-09 16:22:59','',''),(1753,'1','273','1',1,'Retail Sale Id 1758',3700.00,0.00,0.00,5.00,430.00,'2022-06-09 16:23:59','',''),(1754,'1','273','1',1,'Retail Sale Id 1759',31668.00,0.00,0.00,45.50,1911.00,'2022-06-09 16:24:48','',''),(1755,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,448081.56,685.14,0.00,0.00,'2022-06-09 16:49:46','',''),(1756,'1','273',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,685.14,0.00,'2022-06-09 16:50:46','',''),(1757,'1','273','1',1,'Received from bridging 7',0.00,0.00,685.14,0.00,0.00,'2022-06-09 16:50:46','',''),(1758,'1','273','1',1,'Retail Sale Id 1760',740.00,0.00,0.00,1.00,86.00,'2022-06-09 17:08:22','',''),(1759,'1','273','1',1,'Retail Sale Id 1760',740.00,0.00,0.00,1.00,86.00,'2022-06-09 17:08:22','',''),(1760,'1','273','1',1,'Retail Sale Id 1761',747.40,0.00,0.00,1.01,86.86,'2022-06-09 17:11:26','',''),(1761,'1','273','1',1,'Retail Sale Id 1762',747.40,0.00,0.00,1.01,86.86,'2022-06-09 17:12:45','',''),(1762,'1','273','1',1,'Retail Sale Id 1763',999.00,0.00,0.00,1.35,116.10,'2022-06-09 17:17:04','',''),(1763,'1','273','1',1,'Retail Sale Id 1764',1998.00,0.00,0.00,2.70,232.20,'2022-06-09 17:18:47','',''),(1764,'1','273','1',1,'Retail Sale Id 1765',52200.00,0.00,0.00,75.00,3150.00,'2022-06-09 17:23:28','',''),(1765,'1','273','1',1,'Retail Sale Id 1766',1998.00,0.00,0.00,2.70,232.20,'2022-06-09 17:28:44','',''),(1766,'1','273','1',1,'Retail Sale Id 1767',999.00,0.00,0.00,1.35,116.10,'2022-06-09 17:29:58','',''),(1767,'1','273','1',1,'Retail Sale Id 1768',6001.40,0.00,0.00,8.11,697.46,'2022-06-09 17:31:04','',''),(1768,'1','273','1',1,'Retail Sale Id 1769',747.40,0.00,0.00,1.01,86.86,'2022-06-09 17:36:09','',''),(1769,'1','273','1',1,'Retail Sale Id 1770',3404.00,0.00,0.00,4.60,395.60,'2022-06-09 18:35:26','',''),(1770,'1','273','1',1,'Retail Sale Id 1771',12002.80,0.00,0.00,16.22,1394.92,'2022-06-10 06:47:12','',''),(1771,'1','273','1',1,'Retail Sale Id 1771',13001.80,0.00,0.00,17.57,1511.02,'2022-06-10 06:47:12','',''),(1772,'1','273','1',1,'Retail Sale Id 1772',3500.20,0.00,0.00,4.73,406.78,'2022-06-10 07:12:20','',''),(1773,'1','273','1',1,'Retail Sale Id 1773',2597.40,0.00,0.00,3.51,301.86,'2022-06-10 07:22:46','',''),(1774,'1','273','1',1,'Retail Sale Id 1774',3700.00,0.00,0.00,5.00,430.00,'2022-06-10 07:30:40','',''),(1775,'1','273','1',1,'Retail Sale Id 1775',2220.00,0.00,0.00,3.00,258.00,'2022-06-10 07:34:39','',''),(1776,'1','273','1',1,'Retail Sale Id 1776',2952.60,0.00,0.00,3.99,343.14,'2022-06-10 07:37:18','',''),(1777,'1','273','1',1,'Retail Sale Id 1778',999.00,0.00,0.00,1.35,116.10,'2022-06-10 07:43:16','',''),(1778,'1','273','1',1,'Retail Sale Id 1780',3700.00,0.00,0.00,5.00,430.00,'2022-06-10 07:47:15','',''),(1779,'1','273','1',1,'Retail Sale Id 1781',9250.00,0.00,0.00,12.50,1075.00,'2022-06-10 07:51:13','',''),(1780,'1','273','1',1,'Retail Sale Id 1782',69600.00,0.00,0.00,100.00,4200.00,'2022-06-10 07:52:59','',''),(1781,'1','273','1',1,'Retail Sale Id 1783',784.40,0.00,0.00,1.06,91.16,'2022-06-10 07:54:08','',''),(1782,'1','273','1',1,'Return of Retail Sale Id 1780',0.00,3700.00,5.00,0.00,-430.00,'2022-06-10 07:54:58','',''),(1783,'1','273','1',1,'Retail Sale Id 1784',999.00,0.00,0.00,1.35,116.10,'2022-06-10 07:55:49','',''),(1784,'1','273','1',1,'Retail Sale Id 1785',8998.40,0.00,0.00,12.16,1045.76,'2022-06-10 08:06:44','',''),(1785,'1','273','1',1,'Retail Sale Id 1786',8902.20,0.00,0.00,12.03,1034.58,'2022-06-10 08:08:07','',''),(1786,'1','273','1',1,'Retail Sale Id 1787',9250.00,0.00,0.00,12.50,1075.00,'2022-06-10 08:14:51','',''),(1787,'1','273','1',1,'Retail Sale Id 1788',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 08:23:27','',''),(1788,'1','273','1',1,'Retail Sale Id 1789',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 08:29:21','',''),(1789,'1','273','1',1,'Retail Sale Id 1790',9250.00,0.00,0.00,12.50,1075.00,'2022-06-10 08:39:32','',''),(1790,'1','273','1',1,'Retail Sale Id 1792',799.20,0.00,0.00,1.08,92.88,'2022-06-10 08:44:29','',''),(1791,'1','273','1',1,'Retail Sale Id 1793',3700.00,0.00,0.00,5.00,430.00,'2022-06-10 08:45:37','',''),(1792,'1','273','1',1,'Retail Sale Id 1794',34104.00,0.00,0.00,49.00,2058.00,'2022-06-10 08:56:22','',''),(1793,'1','273','1',1,'Retail Sale Id 1796',2960.00,0.00,0.00,4.00,344.00,'2022-06-10 09:01:22','',''),(1794,'1','273','1',1,'Retail Sale Id 1796',2960.00,0.00,0.00,4.00,344.00,'2022-06-10 09:01:22','',''),(1795,'1','273','1',1,'Retail Sale Id 1797',27840.00,0.00,0.00,40.00,1680.00,'2022-06-10 09:02:43','',''),(1796,'1','273','1',1,'Retail Sale Id 1798',8199.20,0.00,0.00,11.08,952.88,'2022-06-10 09:07:58','',''),(1797,'1','273','1',1,'Retail Sale Id 1799',2220.00,0.00,0.00,3.00,258.00,'2022-06-10 09:10:01','',''),(1798,'1','273','1',1,'Retail Sale Id 1799',2960.00,0.00,0.00,4.00,344.00,'2022-06-10 09:10:01','',''),(1799,'1','273','1',1,'Retail Sale Id 1800',5202.20,0.00,0.00,7.03,604.58,'2022-06-10 09:24:27','',''),(1800,'1','273','1',1,'Retail Sale Id 1801',2997.00,0.00,0.00,4.05,348.30,'2022-06-10 09:27:35','',''),(1801,'1','273','1',1,'Retail Sale Id 1802',5002.40,0.00,0.00,6.76,581.36,'2022-06-10 09:38:21','',''),(1802,'1','273','1',1,'Retail Sale Id 1803',2997.00,0.00,0.00,4.05,348.30,'2022-06-10 09:43:17','',''),(1803,'1','273','1',1,'Retail Sale Id 1804',2249.60,0.00,0.00,3.04,261.44,'2022-06-10 09:49:25','',''),(1804,'1','273','1',1,'Retail Sale Id 1805',3700.00,0.00,0.00,5.00,430.00,'2022-06-10 09:51:56','',''),(1805,'1','273','1',1,'Retail Sale Id 1805',9250.00,0.00,0.00,12.50,1075.00,'2022-06-10 09:51:56','',''),(1806,'1','273','1',1,'Retail Sale Id 1806',8140.00,0.00,0.00,11.00,946.00,'2022-06-10 09:53:11','',''),(1807,'1','273','1',1,'Retail Sale Id 1807',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 09:56:07','',''),(1808,'1','273','1',1,'Retail Sale Id 1808',80040.00,0.00,0.00,115.00,4830.00,'2022-06-10 10:00:58','',''),(1809,'1','273','1',1,'Retail Sale Id 1809',999.00,0.00,0.00,1.35,116.10,'2022-06-10 10:02:53','',''),(1810,'1','273','1',1,'Retail Sale Id 1811',2997.00,0.00,0.00,4.05,348.30,'2022-06-10 10:15:38','',''),(1811,'1','273','1',1,'Retail Sale Id 1812',999.00,0.00,0.00,1.35,116.10,'2022-06-10 10:36:27','',''),(1812,'1','273','1',1,'Retail Sale Id 1813',1998.00,0.00,0.00,2.70,232.20,'2022-06-10 10:38:55','',''),(1813,'1','273','1',1,'Retail Sale Id 1814',4440.00,0.00,0.00,6.00,516.00,'2022-06-10 10:41:14','',''),(1814,'1','273','1',1,'Retail Sale Id 1815',1998.00,0.00,0.00,2.70,232.20,'2022-06-10 10:44:02','',''),(1815,'1','273','1',1,'Retail Sale Id 1816',147552.00,0.00,0.00,212.00,8904.00,'2022-06-10 10:52:29','',''),(1816,'1','273','1',1,'Retail Sale Id 1817',144768.00,0.00,0.00,208.00,8736.00,'2022-06-10 10:57:29','',''),(1817,'1','273','1',1,'Retail Sale Id 1818',999.00,0.00,0.00,1.35,116.10,'2022-06-10 10:58:40','',''),(1818,'1','273','1',1,'Retail Sale Id 1819',7999.40,0.00,0.00,10.81,929.66,'2022-06-10 11:02:04','',''),(1819,'1','273','1',1,'Retail Sale Id 1819',7999.40,0.00,0.00,10.81,929.66,'2022-06-10 11:02:04','',''),(1820,'1','273','1',1,'Retail Sale Id 1820',8880.00,0.00,0.00,12.00,1032.00,'2022-06-10 11:04:47','',''),(1821,'1','273','1',1,'Retail Sale Id 1821',34800.00,0.00,0.00,50.00,2100.00,'2022-06-10 11:32:53','',''),(1822,'1','273','1',1,'Retail Sale Id 1822',7400.00,0.00,0.00,10.00,860.00,'2022-06-10 11:42:27','',''),(1823,'1','273','1',1,'Retail Sale Id 1823',3330.00,0.00,0.00,4.50,387.00,'2022-06-10 11:44:43','',''),(1824,'1','273','1',1,'Retail Sale Id 1824',1998.00,0.00,0.00,2.70,232.20,'2022-06-10 11:50:14','',''),(1825,'1','273','1',1,'Retail Sale Id 1825',1498.10,0.00,0.00,2.11,118.16,'2022-06-10 12:08:51','',''),(1826,'1','273','1',1,'Retail Sale Id 1826',999.00,0.00,0.00,1.35,116.10,'2022-06-10 12:35:26','',''),(1827,'1','273','1',1,'Retail Sale Id 1828',2997.00,0.00,0.00,4.05,348.30,'2022-06-10 12:37:36','',''),(1828,'1','273','1',1,'Retail Sale Id 1829',2220.00,0.00,0.00,3.00,258.00,'2022-06-10 12:39:24','',''),(1829,'1','273','1',1,'Retail Sale Id 1829',9250.00,0.00,0.00,12.50,1075.00,'2022-06-10 12:39:24','',''),(1830,'1','273','1',1,'Retail Sale Id 1830',4003.40,0.00,0.00,5.41,465.26,'2022-06-10 12:50:46','',''),(1831,'1','273','1',1,'Retail Sale Id 1831',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 12:52:05','',''),(1832,'1','273','1',1,'Retail Sale Id 1832',999.00,0.00,0.00,1.35,116.10,'2022-06-10 12:56:56','',''),(1833,'1','273','1',1,'Retail Sale Id 1833',740.00,0.00,0.00,1.00,86.00,'2022-06-10 12:57:54','',''),(1834,'1','273','1',1,'Retail Sale Id 1834',5202.20,0.00,0.00,7.03,604.58,'2022-06-10 13:07:47','',''),(1835,'1','273','1',1,'Retail Sale Id 1835',2997.00,0.00,0.00,4.05,348.30,'2022-06-10 13:10:36','',''),(1836,'1','273','1',1,'Retail Sale Id 1836',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 13:14:30','',''),(1837,'1','273','1',1,'Retail Sale Id 1837',2960.00,0.00,0.00,4.00,344.00,'2022-06-10 13:20:41','',''),(1838,'1','273','1',1,'Retail Sale Id 1837',9250.00,0.00,0.00,12.50,1075.00,'2022-06-10 13:20:41','',''),(1839,'1','273','1',1,'Retail Sale Id 1838',69600.00,0.00,0.00,100.00,4200.00,'2022-06-10 13:24:27','',''),(1840,'1','273','1',1,'Retail Sale Id 1839',65424.00,0.00,0.00,94.00,3948.00,'2022-06-10 13:25:45','',''),(1841,'1','273','1',1,'Retail Sale Id 1840',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 13:27:25','',''),(1842,'1','273','1',1,'Retail Sale Id 1842',2997.00,0.00,0.00,4.05,348.30,'2022-06-10 13:28:51','',''),(1843,'1','273','1',1,'Retail Sale Id 1843',2249.60,0.00,0.00,3.04,261.44,'2022-06-10 13:43:43','',''),(1844,'1','273','1',1,'Retail Sale Id 1844',32016.00,0.00,0.00,46.00,1932.00,'2022-06-10 13:46:20','',''),(1845,'1','273','1',1,'Retail Sale Id 1845',9250.00,0.00,0.00,12.50,1075.00,'2022-06-10 13:51:09','',''),(1846,'1','273','1',1,'Retail Sale Id 1846',34800.00,0.00,0.00,50.00,2100.00,'2022-06-10 13:54:11','',''),(1847,'1','273','1',1,'Retail Sale Id 1847',740.00,0.00,0.00,1.00,86.00,'2022-06-10 14:09:07','',''),(1848,'1','273','1',1,'Retail Sale Id 1848',104400.00,0.00,0.00,150.00,6300.00,'2022-06-10 14:21:10','',''),(1849,'1','273','1',1,'Retail Sale Id 1849',43848.00,0.00,0.00,63.00,2646.00,'2022-06-10 14:22:38','',''),(1850,'1','273','1',1,'Retail Sale Id 1850',1998.00,0.00,0.00,2.70,232.20,'2022-06-10 14:38:48','',''),(1851,'1','273','1',1,'Retail Sale Id 1851',999.00,0.00,0.00,1.35,116.10,'2022-06-10 14:40:04','',''),(1852,'1','273','1',1,'Retail Sale Id 1852',2220.00,0.00,0.00,3.00,258.00,'2022-06-10 14:41:25','',''),(1853,'1','273','1',1,'Retail Sale Id 1853',4440.00,0.00,0.00,6.00,516.00,'2022-06-10 14:42:32','',''),(1854,'1','273','1',1,'Retail Sale Id 1854',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 14:43:58','',''),(1855,'1','273','1',1,'Retail Sale Id 1855',2997.00,0.00,0.00,4.05,348.30,'2022-06-10 14:45:21','',''),(1856,'1','273','1',1,'Retail Sale Id 1856',799.20,0.00,0.00,1.08,92.88,'2022-06-10 14:59:47','',''),(1857,'1','273','1',1,'Retail Sale Id 1857',3700.00,0.00,0.00,5.00,430.00,'2022-06-10 15:15:32','',''),(1858,'1','273','1',1,'Retail Sale Id 1858',799.20,0.00,0.00,1.08,92.88,'2022-06-10 15:17:13','',''),(1859,'1','273','1',1,'Retail Sale Id 1859',2220.00,0.00,0.00,3.00,258.00,'2022-06-10 15:22:54','',''),(1860,'1','273','1',1,'Retail Sale Id 1860',747.40,0.00,0.00,1.01,86.86,'2022-06-10 15:27:59','',''),(1861,'1','273','1',1,'Retail Sale Id 1862',747.40,0.00,0.00,1.01,86.86,'2022-06-10 15:45:19','',''),(1862,'1','273','1',1,'Retail Sale Id 1863',999.00,0.00,0.00,1.35,116.10,'2022-06-10 15:55:49','',''),(1863,'1','273','1',1,'Retail Sale Id 1864',2220.00,0.00,0.00,3.00,258.00,'2022-06-10 16:18:00','',''),(1864,'1','273','1',1,'Retail Sale Id 1865',2220.00,0.00,0.00,3.00,258.00,'2022-06-10 16:19:17','',''),(1865,'1','273','1',1,'Retail Sale Id 1866',3700.00,0.00,0.00,5.00,430.00,'2022-06-10 16:20:11','',''),(1866,'1','273','1',1,'Retail Sale Id 1867',1480.00,0.00,0.00,2.00,172.00,'2022-06-10 16:21:49','',''),(1867,'1','273','1',1,'Retail Sale Id 1867',3700.00,0.00,0.00,5.00,430.00,'2022-06-10 16:21:49','',''),(1868,'1','273','1',1,'Retail Sale Id 1868',11100.00,0.00,0.00,15.00,1290.00,'2022-06-10 16:22:55','',''),(1869,'1','273','1',1,'Retail Sale Id 1869',747.40,0.00,0.00,1.01,86.86,'2022-06-10 16:25:39','',''),(1870,'1','273','1',1,'Retail Sale Id 1870',3500.20,0.00,0.00,4.73,406.78,'2022-06-10 16:26:41','',''),(1871,'1','273','1',1,'Retail Sale Id 1871',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 16:28:41','',''),(1872,'1','273','1',1,'Retail Sale Id 1872',999.00,0.00,0.00,1.35,116.10,'2022-06-10 16:31:50','',''),(1873,'1','273','1',1,'Retail Sale Id 1873',2952.60,0.00,0.00,3.99,343.14,'2022-06-10 16:34:54','',''),(1874,'1','273','1',1,'Retail Sale Id 1874',9250.00,0.00,0.00,12.50,1075.00,'2022-06-10 16:36:22','',''),(1875,'1','273','1',1,'Retail Sale Id 1875',747.40,0.00,0.00,1.01,86.86,'2022-06-10 16:40:56','',''),(1876,'1','273','1',1,'Retail Sale Id 1876',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 16:48:30','',''),(1877,'1','273','1',1,'Retail Sale Id 1877',1480.00,0.00,0.00,2.00,172.00,'2022-06-10 16:49:45','',''),(1878,'1','273','1',1,'Retail Sale Id 1878',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 17:06:24','',''),(1879,'1','273','1',1,'Retail Sale Id 1879',999.00,0.00,0.00,1.35,116.10,'2022-06-10 17:09:24','',''),(1880,'1','273','1',1,'Retail Sale Id 1881',1502.20,0.00,0.00,2.03,174.58,'2022-06-10 17:11:50','',''),(1881,'1','273','1',1,'Retail Sale Id 1882',8902.20,0.00,0.00,12.03,1034.58,'2022-06-10 17:14:57','',''),(1882,'1','273','1',1,'Retail Sale Id 1883',8880.00,0.00,0.00,12.00,1032.00,'2022-06-10 17:22:13','',''),(1883,'1','273','1',1,'Retail Sale Id 1884',799.20,0.00,0.00,1.08,92.88,'2022-06-10 17:23:48','',''),(1884,'1','273','1',1,'Retail Sale Id 1885',3700.00,0.00,0.00,5.00,430.00,'2022-06-10 17:25:46','',''),(1885,'1','273','1',1,'Retail Sale Id 1886',9250.00,0.00,0.00,12.50,1075.00,'2022-06-10 17:39:48','',''),(1886,'1','273','1',1,'Retail Sale Id 1887',3700.00,0.00,0.00,5.00,430.00,'2022-06-10 17:41:01','',''),(1887,'1','273','1',1,'Retail Sale Id 1888',2997.00,0.00,0.00,4.05,348.30,'2022-06-10 17:43:41','',''),(1888,'1','273','1',1,'Retail Sale Id 1889',9250.00,0.00,0.00,12.50,1075.00,'2022-06-10 17:44:23','',''),(1889,'1','273','1',1,'Retail Sale Id 1890',999.00,0.00,0.00,1.35,116.10,'2022-06-10 17:51:56','',''),(1890,'1','273','1',1,'Retail Sale Id 1891',4440.00,0.00,0.00,6.00,516.00,'2022-06-10 17:54:09','',''),(1891,'1','273','1',1,'Retail Sale Id 1892',16008.00,0.00,0.00,23.00,966.00,'2022-06-10 18:02:02','',''),(1892,'1','273','1',1,'Retail Sale Id 1893',5180.00,0.00,0.00,7.00,602.00,'2022-06-10 18:02:44','',''),(1893,'1','273','1',1,'Retail Sale Id 1894',6001.40,0.00,0.00,8.11,697.46,'2022-06-10 18:04:01','',''),(1894,'1','273','1',1,'Retail Sale Id 1895',799.20,0.00,0.00,1.08,92.88,'2022-06-11 07:16:50','',''),(1895,'1','273','1',1,'Retail Sale Id 1896',2997.00,0.00,0.00,4.05,348.30,'2022-06-11 07:26:32','',''),(1896,'1','273','1',1,'Retail Sale Id 1897',999.00,0.00,0.00,1.35,116.10,'2022-06-11 07:28:57','',''),(1897,'1','273','1',1,'Retail Sale Id 1898',1998.00,0.00,0.00,2.70,232.20,'2022-06-11 07:31:09','',''),(1898,'1','273','1',1,'Retail Sale Id 1899',2997.00,0.00,0.00,4.05,348.30,'2022-06-11 07:32:29','',''),(1899,'1','273','1',1,'Retail Sale Id 1900',3700.00,0.00,0.00,5.00,430.00,'2022-06-11 07:46:46','',''),(1900,'1','273','1',1,'Retail Sale Id 1901',2301.40,0.00,0.00,3.11,267.46,'2022-06-11 07:56:09','',''),(1901,'1','273','1',1,'Retail Sale Id 1902',5498.20,0.00,0.00,7.43,638.98,'2022-06-11 07:57:43','',''),(1902,'1','273','1',1,'Retail Sale Id 1902',5498.20,0.00,0.00,7.43,638.98,'2022-06-11 07:57:43','',''),(1903,'1','273','1',1,'Retail Sale Id 1903',1998.00,0.00,0.00,2.70,232.20,'2022-06-11 08:05:56','',''),(1904,'1','273','1',1,'Retail Sale Id 1904',999.00,0.00,0.00,1.35,116.10,'2022-06-11 08:10:36','',''),(1905,'1','273','1',1,'Retail Sale Id 1905',1198.80,0.00,0.00,1.62,139.32,'2022-06-11 08:25:23','',''),(1906,'1','273','1',1,'Retail Sale Id 1906',799.20,0.00,0.00,1.08,92.88,'2022-06-11 08:29:39','',''),(1907,'1','273','1',1,'Retail Sale Id 1907',8880.00,0.00,0.00,12.00,1032.00,'2022-06-11 08:34:33','',''),(1908,'1','273','1',1,'Retail Sale Id 1908',5920.00,0.00,0.00,8.00,688.00,'2022-06-11 08:36:21','',''),(1909,'1','273','1',1,'Retail Sale Id 1909',1998.00,0.00,0.00,2.70,232.20,'2022-06-11 08:37:31','',''),(1910,'1','273','1',1,'Retail Sale Id 1910',1480.00,0.00,0.00,2.00,172.00,'2022-06-11 08:38:31','',''),(1911,'1','273','1',1,'Retail Sale Id 1911',70992.00,0.00,0.00,102.00,4284.00,'2022-06-11 08:49:47','',''),(1912,'1','273','1',1,'Retail Sale Id 1912',4003.40,0.00,0.00,5.41,465.26,'2022-06-11 08:52:20','',''),(1913,'1','273','1',1,'Retail Sale Id 1913',2997.00,0.00,0.00,4.05,348.30,'2022-06-11 09:05:23','',''),(1914,'1','273','1',1,'Retail Sale Id 1914',79344.00,0.00,0.00,114.00,4788.00,'2022-06-11 09:07:47','',''),(1915,'1','273','1',1,'Retail Sale Id 1915',999.00,0.00,0.00,1.35,116.10,'2022-06-11 09:16:26','',''),(1916,'1','273','1',1,'Retail Sale Id 1916',43500.00,0.00,0.00,62.50,2625.00,'2022-06-11 09:27:17','',''),(1917,'1','273','1',1,'Retail Sale Id 1917',52200.00,0.00,0.00,75.00,3150.00,'2022-06-11 09:28:22','',''),(1918,'1','273','1',1,'Retail Sale Id 1918',799.20,0.00,0.00,1.08,92.88,'2022-06-11 09:31:47','',''),(1919,'1','273','1',1,'Retail Sale Id 1919',104400.00,0.00,0.00,150.00,6300.00,'2022-06-11 09:33:11','',''),(1920,'1','273','1',1,'Retail Sale Id 1920',62640.00,0.00,0.00,90.00,3780.00,'2022-06-11 09:38:15','',''),(1921,'1','273','1',1,'Retail Sale Id 1921',9250.00,0.00,0.00,12.50,1075.00,'2022-06-11 09:41:10','',''),(1922,'1','273','1',1,'Retail Sale Id 1922',2220.00,0.00,0.00,3.00,258.00,'2022-06-11 09:42:28','',''),(1923,'1','273','1',1,'Retail Sale Id 1923',34800.00,0.00,0.00,50.00,2100.00,'2022-06-11 09:43:25','',''),(1924,'1','273','1',1,'Retail Sale Id 1924',999.00,0.00,0.00,1.35,116.10,'2022-06-11 09:44:23','',''),(1925,'1','273','1',1,'Retail Sale Id 1925',999.00,0.00,0.00,1.35,116.10,'2022-06-11 09:47:33','',''),(1926,'1','273','1',1,'Retail Sale Id 1926',1502.20,0.00,0.00,2.03,174.58,'2022-06-11 09:51:07','',''),(1927,'1','273','1',1,'Retail Sale Id 1927',139200.00,0.00,0.00,200.00,8400.00,'2022-06-11 09:53:31','',''),(1928,'1','273','1',1,'Retail Sale Id 1928',80736.00,0.00,0.00,116.00,4872.00,'2022-06-11 09:55:10','',''),(1929,'1','273','1',1,'Retail Sale Id 1929',1480.00,0.00,0.00,2.00,172.00,'2022-06-11 09:57:45','',''),(1930,'1','273','1',1,'Retail Sale Id 1930',747.40,0.00,0.00,1.01,86.86,'2022-06-11 09:59:59','',''),(1931,'1','273','1',1,'Retail Sale Id 1931',4440.00,0.00,0.00,6.00,516.00,'2022-06-11 10:06:32','',''),(1932,'1','273','1',1,'Retail Sale Id 1932',5920.00,0.00,0.00,8.00,688.00,'2022-06-11 10:08:41','',''),(1933,'1','273','1',1,'Retail Sale Id 1933',17400.00,0.00,0.00,25.00,1050.00,'2022-06-11 10:10:15','',''),(1934,'1','273','1',1,'Retail Sale Id 1934',7400.00,0.00,0.00,10.00,860.00,'2022-06-11 10:11:18','',''),(1935,'1','273','1',1,'Retail Sale Id 1935',2501.20,0.00,0.00,3.38,290.68,'2022-06-11 10:14:07','',''),(1936,'1','273','1',1,'Retail Sale Id 1936',2220.00,0.00,0.00,3.00,258.00,'2022-06-11 10:19:09','',''),(1937,'1','273','1',1,'Retail Sale Id 1937',5180.00,0.00,0.00,7.00,602.00,'2022-06-11 10:20:30','',''),(1938,'1','273','1',1,'Retail Sale Id 1938',1502.20,0.00,0.00,2.03,174.58,'2022-06-11 10:46:47','',''),(1939,'1','273','1',1,'Retail Sale Id 1939',1502.20,0.00,0.00,2.03,174.58,'2022-06-11 10:52:36','',''),(1940,'1','273','1',1,'Retail Sale Id 1940',1346.80,0.00,0.00,1.82,156.52,'2022-06-11 11:02:41','',''),(1941,'1','273','1',1,'Retail Sale Id 1941',34104.00,0.00,0.00,49.00,2058.00,'2022-06-11 11:05:22','',''),(1942,'1','273','1',1,'Retail Sale Id 1942',2220.00,0.00,0.00,3.00,258.00,'2022-06-11 11:15:11','',''),(1943,'1','273','1',1,'Retail Sale Id 1943',2997.00,0.00,0.00,4.05,348.30,'2022-06-11 11:23:52','',''),(1944,'1','273','1',1,'Retail Sale Id 1944',740.00,0.00,0.00,1.00,86.00,'2022-06-11 11:33:00','',''),(1945,'1','273','1',1,'Retail Sale Id 1945',2220.00,0.00,0.00,3.00,258.00,'2022-06-11 11:42:12','',''),(1946,'1','273','1',1,'Retail Sale Id 1946',6660.00,0.00,0.00,9.00,774.00,'2022-06-11 11:45:40','',''),(1947,'1','273','1',1,'Retail Sale Id 1947',740.00,0.00,0.00,1.00,86.00,'2022-06-11 11:50:13','',''),(1948,'1','273','1',1,'Retail Sale Id 1948',740.00,0.00,0.00,1.00,86.00,'2022-06-11 11:56:23','',''),(1949,'1','273','1',1,'Retail Sale Id 1949',747.40,0.00,0.00,1.01,86.86,'2022-06-11 12:04:59','',''),(1950,'1','273','1',1,'Retail Sale Id 1950',43500.00,0.00,0.00,62.50,2625.00,'2022-06-11 12:11:37','',''),(1951,'1','273','1',1,'Retail Sale Id 1951',7400.00,0.00,0.00,10.00,860.00,'2022-06-11 12:25:30','',''),(1952,'1','273','1',1,'Retail Sale Id 1952',747.40,0.00,0.00,1.01,86.86,'2022-06-11 12:37:22','',''),(1953,'1','273','1',1,'Retail Sale Id 1953',747.40,0.00,0.00,1.01,86.86,'2022-06-11 13:02:01','',''),(1954,'1','273','1',1,'Retail Sale Id 1955',851.00,0.00,0.00,1.15,98.90,'2022-06-11 13:08:30','',''),(1955,'1','273','1',1,'Retail Sale Id 1955',851.00,0.00,0.00,1.15,98.90,'2022-06-11 13:08:30','',''),(1956,'1','273','1',1,'Retail Sale Id 1956',799.20,0.00,0.00,1.08,92.88,'2022-06-11 13:09:48','',''),(1957,'1','273','1',1,'Retail Sale Id 1957',1480.00,0.00,0.00,2.00,172.00,'2022-06-11 13:32:21','',''),(1958,'1','273','1',1,'Retail Sale Id 1958',2220.00,0.00,0.00,3.00,258.00,'2022-06-11 13:52:09','',''),(1959,'1','273','1',1,'Retail Sale Id 1959',747.40,0.00,0.00,1.01,86.86,'2022-06-11 13:57:08','',''),(1960,'1','273','1',1,'Retail Sale Id 1960',1502.20,0.00,0.00,2.03,174.58,'2022-06-11 13:58:10','',''),(1961,'1','273','1',1,'Retail Sale Id 1961',2220.00,0.00,0.00,3.00,258.00,'2022-06-11 14:35:58','',''),(1962,'1','273','1',1,'Retail Sale Id 1962',2997.00,0.00,0.00,4.05,348.30,'2022-06-11 14:59:54','',''),(1963,'1','273','1',1,'Retail Sale Id 1963',8140.00,0.00,0.00,11.00,946.00,'2022-06-11 15:05:04','',''),(1964,'1','273','1',1,'Retail Sale Id 1964',999.00,0.00,0.00,1.35,116.10,'2022-06-11 15:07:43','',''),(1965,'1','273','1',1,'Retail Sale Id 1965',747.40,0.00,0.00,1.01,86.86,'2022-06-11 15:13:27','',''),(1966,'1','273','1',1,'Retail Sale Id 1966',3700.00,0.00,0.00,5.00,430.00,'2022-06-11 15:14:56','',''),(1967,'1','273','1',1,'Retail Sale Id 1967',4003.40,0.00,0.00,5.41,465.26,'2022-06-11 15:24:23','',''),(1968,'1','273','1',1,'Retail Sale Id 1968',2960.00,0.00,0.00,4.00,344.00,'2022-06-11 15:26:02','',''),(1969,'1','273','1',1,'Retail Sale Id 1969',9250.00,0.00,0.00,12.50,1075.00,'2022-06-11 15:29:22','',''),(1970,'1','273','1',1,'Retail Sale Id 1970',999.00,0.00,0.00,1.35,116.10,'2022-06-11 15:30:24','',''),(1971,'1','273','1',1,'Retail Sale Id 1971',3700.00,0.00,0.00,5.00,430.00,'2022-06-11 15:31:40','',''),(1972,'1','273','1',1,'Retail Sale Id 1972',999.00,0.00,0.00,1.35,116.10,'2022-06-11 15:33:11','',''),(1973,'1','273','1',1,'Retail Sale Id 1973',3700.00,0.00,0.00,5.00,430.00,'2022-06-11 15:37:53','',''),(1974,'1','273','1',1,'Retail Sale Id 1974',999.00,0.00,0.00,1.35,116.10,'2022-06-11 15:45:29','',''),(1975,'1','273','1',1,'Retail Sale Id 1975',12528.00,0.00,0.00,18.00,756.00,'2022-06-11 15:54:57','',''),(1976,'1','273','1',1,'Retail Sale Id 1976',1502.20,0.00,0.00,2.03,174.58,'2022-06-11 16:03:08','',''),(1977,'1','273','1',1,'Retail Sale Id 1977',2997.00,0.00,0.00,4.05,348.30,'2022-06-11 16:04:08','',''),(1978,'1','273','1',1,'Retail Sale Id 1978',83520.00,0.00,0.00,120.00,5040.00,'2022-06-11 16:11:43','',''),(1979,'1','273','1',1,'Retail Sale Id 1979',83520.00,0.00,0.00,120.00,5040.00,'2022-06-11 16:12:14','',''),(1980,'1','273','1',1,'Retail Sale Id 1980',6001.40,0.00,0.00,8.11,697.46,'2022-06-11 16:12:50','',''),(1981,'1','273','1',1,'Retail Sale Id 1981',1502.20,0.00,0.00,2.03,174.58,'2022-06-11 16:13:27','',''),(1982,'1','273','1',1,'Retail Sale Id 1982',999.00,0.00,0.00,1.35,116.10,'2022-06-11 16:24:02','',''),(1983,'1','273','1',1,'Retail Sale Id 1983',4003.40,0.00,0.00,5.41,465.26,'2022-06-11 16:31:04','',''),(1984,'1','273','1',1,'Retail Sale Id 1984',4499.20,0.00,0.00,6.08,522.88,'2022-06-11 16:35:01','',''),(1985,'1','273','1',1,'Retail Sale Id 1985',2220.00,0.00,0.00,3.00,258.00,'2022-06-11 16:36:07','',''),(1986,'1','273','1',1,'Return of Retail Sale Id 1984',0.00,4499.20,6.08,0.00,-522.88,'2022-06-11 16:37:35','',''),(1987,'1','273','1',1,'Retail Sale Id 1986',4499.20,0.00,0.00,6.08,522.88,'2022-06-11 16:38:18','',''),(1988,'1','273','1',1,'Retail Sale Id 1987',90480.00,0.00,0.00,130.00,5460.00,'2022-06-11 16:45:30','',''),(1989,'1','273','1',1,'Retail Sale Id 1988',7400.00,0.00,0.00,10.00,860.00,'2022-06-11 16:48:01','',''),(1990,'1','273','1',1,'Retail Sale Id 1989',2220.00,0.00,0.00,3.00,258.00,'2022-06-11 16:49:02','',''),(1991,'1','273','1',1,'Retail Sale Id 1990',9250.00,0.00,0.00,12.50,1075.00,'2022-06-11 16:50:16','',''),(1992,'1','273','1',1,'Retail Sale Id 1991',5002.40,0.00,0.00,6.76,581.36,'2022-06-11 16:59:07','',''),(1993,'1','273','1',1,'Retail Sale Id 1992',2301.40,0.00,0.00,3.11,267.46,'2022-06-11 17:01:17','',''),(1994,'1','273','1',1,'Retail Sale Id 1993',747.40,0.00,0.00,1.01,86.86,'2022-06-11 17:04:15','',''),(1995,'1','273','1',1,'Retail Sale Id 1994',4440.00,0.00,0.00,6.00,516.00,'2022-06-11 17:05:56','',''),(1996,'1','273','1',1,'Retail Sale Id 1994',4440.00,0.00,0.00,6.00,516.00,'2022-06-11 17:05:56','',''),(1997,'1','273','1',1,'Retail Sale Id 1994',9250.00,0.00,0.00,12.50,1075.00,'2022-06-11 17:05:56','',''),(1998,'1','273','1',1,'Retail Sale Id 1995',2220.00,0.00,0.00,3.00,258.00,'2022-06-11 17:10:10','',''),(1999,'1','273','1',1,'Retail Sale Id 1997',747.40,0.00,0.00,1.01,86.86,'2022-06-11 17:16:25','',''),(2000,'1','273','1',1,'Retail Sale Id 1998',5180.00,0.00,0.00,7.00,602.00,'2022-06-11 17:18:38','',''),(2001,'1','273','1',1,'Retail Sale Id 1999',4440.00,0.00,0.00,6.00,516.00,'2022-06-11 17:20:22','',''),(2002,'1','273','1',1,'Retail Sale Id 2000',999.00,0.00,0.00,1.35,116.10,'2022-06-11 17:21:30','',''),(2003,'1','273','1',1,'Retail Sale Id 2001',1480.00,0.00,0.00,2.00,172.00,'2022-06-11 17:33:21','',''),(2004,'1','273','1',1,'Retail Sale Id 2002',1480.00,0.00,0.00,2.00,172.00,'2022-06-11 17:44:38','',''),(2005,'1','273','1',1,'Retail Sale Id 2003',9250.00,0.00,0.00,12.50,1075.00,'2022-06-11 17:50:34','',''),(2006,'1','273','1',1,'Retail Sale Id 2004',3700.00,0.00,0.00,5.00,430.00,'2022-06-11 17:56:59','',''),(2007,'1','273','1',1,'Retail Sale Id 2005',999.00,0.00,0.00,1.35,116.10,'2022-06-11 17:57:47','',''),(2008,'1','273','1',1,'Retail Sale Id 2006',7000.40,0.00,0.00,9.46,813.56,'2022-06-11 18:05:59','',''),(2009,'1','273','1',1,'Retail Sale Id 2007',1998.00,0.00,0.00,2.70,232.20,'2022-06-12 07:22:12','',''),(2010,'1','273','1',1,'Retail Sale Id 2008',5180.00,0.00,0.00,7.00,602.00,'2022-06-12 07:24:10','',''),(2011,'1','273','1',1,'Retail Sale Id 2009',2997.00,0.00,0.00,4.05,348.30,'2022-06-12 07:26:03','',''),(2012,'1','273','1',1,'Retail Sale Id 2010',1502.20,0.00,0.00,2.03,174.58,'2022-06-12 07:27:07','',''),(2013,'1','273','1',1,'Retail Sale Id 2011',4176.00,0.00,0.00,6.00,252.00,'2022-06-12 07:38:27','',''),(2014,'1','273','1',1,'Retail Sale Id 2012',3700.00,0.00,0.00,5.00,430.00,'2022-06-12 07:39:15','',''),(2015,'1','273','1',1,'Retail Sale Id 2013',9250.00,0.00,0.00,12.50,1075.00,'2022-06-12 07:40:48','',''),(2016,'1','273','1',1,'Retail Sale Id 2014',9250.00,0.00,0.00,12.50,1075.00,'2022-06-12 07:46:45','',''),(2017,'1','273','1',1,'Retail Sale Id 2015',1502.20,0.00,0.00,2.03,174.58,'2022-06-12 07:47:34','',''),(2018,'1','273','1',1,'Retail Sale Id 2017',5180.00,0.00,0.00,7.00,602.00,'2022-06-12 07:51:27','',''),(2019,'1','273','1',1,'Retail Sale Id 2018',2997.00,0.00,0.00,4.05,348.30,'2022-06-12 07:52:43','',''),(2020,'1','273','1',1,'Retail Sale Id 2019',1502.20,0.00,0.00,2.03,174.58,'2022-06-12 07:53:45','',''),(2021,'1','273','1',1,'Retail Sale Id 2020',1998.00,0.00,0.00,2.70,232.20,'2022-06-12 08:06:36','',''),(2022,'1','273','1',1,'Retail Sale Id 2021',747.40,0.00,0.00,1.01,86.86,'2022-06-12 08:10:21','',''),(2023,'1','273','1',1,'Retail Sale Id 2022',7999.40,0.00,0.00,10.81,929.66,'2022-06-12 08:20:30','',''),(2024,'1','273','1',1,'Retail Sale Id 2023',1480.00,0.00,0.00,2.00,172.00,'2022-06-12 08:21:40','',''),(2025,'1','273','1',1,'Retail Sale Id 2024',999.00,0.00,0.00,1.35,116.10,'2022-06-12 08:26:59','',''),(2026,'1','273','1',1,'Retail Sale Id 2025',4440.00,0.00,0.00,6.00,516.00,'2022-06-12 08:32:12','',''),(2027,'1','273','1',1,'Retail Sale Id 2026',5202.20,0.00,0.00,7.03,604.58,'2022-06-12 08:33:27','',''),(2028,'1','273','1',1,'Retail Sale Id 2027',747.40,0.00,0.00,1.01,86.86,'2022-06-12 08:35:57','',''),(2029,'1','273','1',1,'Retail Sale Id 2028',9250.00,0.00,0.00,12.50,1075.00,'2022-06-12 08:43:02','',''),(2030,'1','273','1',1,'Retail Sale Id 2029',2249.60,0.00,0.00,3.04,261.44,'2022-06-12 08:55:59','',''),(2031,'1','273','1',1,'Retail Sale Id 2030',1102.60,0.00,0.00,1.49,128.14,'2022-06-12 09:13:10','',''),(2032,'1','273','1',1,'Retail Sale Id 2031',4447.40,0.00,0.00,6.01,516.86,'2022-06-12 09:19:10','',''),(2033,'1','273','1',1,'Retail Sale Id 2032',1598.40,0.00,0.00,2.16,185.76,'2022-06-12 09:23:13','',''),(2034,'1','273','1',1,'Retail Sale Id 2033',39672.00,0.00,0.00,57.00,2394.00,'2022-06-12 09:40:26','',''),(2035,'1','273','1',1,'Retail Sale Id 2034',2220.00,0.00,0.00,3.00,258.00,'2022-06-12 09:42:14','',''),(2036,'1','273','1',1,'Retail Sale Id 2035',7400.00,0.00,0.00,10.00,860.00,'2022-06-12 09:48:34','',''),(2037,'1','273','1',1,'Retail Sale Id 2036',4440.00,0.00,0.00,6.00,516.00,'2022-06-12 09:52:22','',''),(2038,'1','273','1',1,'Retail Sale Id 2037',2249.60,0.00,0.00,3.04,261.44,'2022-06-12 10:06:46','',''),(2039,'1','273','1',1,'Retail Sale Id 2038',1110.00,0.00,0.00,1.50,129.00,'2022-06-12 10:18:00','',''),(2040,'1','273','1',1,'Retail Sale Id 2039',2220.00,0.00,0.00,3.00,258.00,'2022-06-12 10:24:45','',''),(2041,'1','273','1',1,'Retail Sale Id 2040',9250.00,0.00,0.00,12.50,1075.00,'2022-06-12 10:25:51','',''),(2042,'1','273','1',1,'Retail Sale Id 2041',999.00,0.00,0.00,1.35,116.10,'2022-06-12 10:30:21','',''),(2043,'1','273','1',1,'Retail Sale Id 2042',747.40,0.00,0.00,1.01,86.86,'2022-06-12 10:47:52','',''),(2044,'1','273','1',1,'Retail Sale Id 2043',799.20,0.00,0.00,1.08,92.88,'2022-06-12 10:58:29','',''),(2045,'1','273','1',1,'Retail Sale Id 2044',1502.20,0.00,0.00,2.03,174.58,'2022-06-12 10:59:51','',''),(2046,'1','273','1',1,'Retail Sale Id 2045',1502.20,0.00,0.00,2.03,174.58,'2022-06-12 11:01:53','',''),(2047,'1','273','1',1,'Retail Sale Id 2046',2997.00,0.00,0.00,4.05,348.30,'2022-06-12 11:13:58','',''),(2048,'1','273','1',1,'Retail Sale Id 2047',2997.00,0.00,0.00,4.05,348.30,'2022-06-12 11:17:56','',''),(2049,'1','273','1',1,'Retail Sale Id 2048',747.40,0.00,0.00,1.01,86.86,'2022-06-12 11:34:34','',''),(2050,'1','273','1',1,'Retail Sale Id 2049',8880.00,0.00,0.00,12.00,1032.00,'2022-06-12 12:01:10','',''),(2051,'1','273','1',1,'Retail Sale Id 2050',2220.00,0.00,0.00,3.00,258.00,'2022-06-12 12:12:36','',''),(2052,'1','273','1',1,'Retail Sale Id 2051',1480.00,0.00,0.00,2.00,172.00,'2022-06-12 12:14:02','',''),(2053,'1','273','1',1,'Retail Sale Id 2052',2197.80,0.00,0.00,2.97,255.42,'2022-06-12 12:22:20','',''),(2054,'1','273','1',1,'Retail Sale Id 2053',799.20,0.00,0.00,1.08,92.88,'2022-06-12 12:25:38','',''),(2055,'1','273','1',1,'Retail Sale Id 2054',1502.20,0.00,0.00,2.03,174.58,'2022-06-12 12:28:31','',''),(2056,'1','273','1',1,'Retail Sale Id 2055',999.00,0.00,0.00,1.35,116.10,'2022-06-12 12:31:03','',''),(2057,'1','273','1',1,'Retail Sale Id 2056',1998.00,0.00,0.00,2.70,232.20,'2022-06-12 12:46:20','',''),(2058,'1','273','1',1,'Retail Sale Id 2057',5180.00,0.00,0.00,7.00,602.00,'2022-06-12 12:50:07','',''),(2059,'1','273','1',1,'Retail Sale Id 2058',747.40,0.00,0.00,1.01,86.86,'2022-06-12 12:57:49','',''),(2060,'1','273','1',1,'Retail Sale Id 2059',2197.80,0.00,0.00,2.97,255.42,'2022-06-12 13:02:21','',''),(2061,'1','273','1',1,'Retail Sale Id 2060',2997.00,0.00,0.00,4.05,348.30,'2022-06-12 13:10:21','',''),(2062,'1','273','1',1,'Retail Sale Id 2061',6660.00,0.00,0.00,9.00,774.00,'2022-06-12 13:11:13','',''),(2063,'1','273','1',1,'Retail Sale Id 2062',3700.00,0.00,0.00,5.00,430.00,'2022-06-12 13:12:02','',''),(2064,'1','273','1',1,'Retail Sale Id 2063',1850.00,0.00,0.00,2.50,215.00,'2022-06-12 13:13:24','',''),(2065,'1','273','1',1,'Retail Sale Id 2064',2220.00,0.00,0.00,3.00,258.00,'2022-06-12 13:21:17','',''),(2066,'1','273','1',1,'Retail Sale Id 2065',2960.00,0.00,0.00,4.00,344.00,'2022-06-12 13:27:29','',''),(2067,'1','273','1',1,'Retail Sale Id 2066',2997.00,0.00,0.00,4.05,348.30,'2022-06-12 13:31:58','',''),(2068,'1','273','1',1,'Retail Sale Id 2067',740.00,0.00,0.00,1.00,86.00,'2022-06-12 13:32:51','',''),(2069,'1','273','1',1,'Retail Sale Id 2068',747.40,0.00,0.00,1.01,86.86,'2022-06-12 13:39:49','',''),(2070,'1','273','1',1,'Retail Sale Id 2069',2723.20,0.00,0.00,3.68,316.48,'2022-06-12 13:40:58','',''),(2071,'1','273','1',1,'Retail Sale Id 2070',2997.00,0.00,0.00,4.05,348.30,'2022-06-12 13:44:38','',''),(2072,'1','273','1',1,'Retail Sale Id 2071',9250.00,0.00,0.00,12.50,1075.00,'2022-06-12 13:45:18','',''),(2073,'1','273','1',1,'Retail Sale Id 2072',9250.00,0.00,0.00,12.50,1075.00,'2022-06-12 13:49:59','',''),(2074,'1','273','1',1,'Retail Sale Id 2074',5498.20,0.00,0.00,7.43,638.98,'2022-06-12 13:52:00','',''),(2075,'1','273','1',1,'Retail Sale Id 2075',3700.00,0.00,0.00,5.00,430.00,'2022-06-12 13:53:28','',''),(2076,'1','273','1',1,'Retail Sale Id 2076',7400.00,0.00,0.00,10.00,860.00,'2022-06-12 13:54:54','',''),(2077,'1','273','1',1,'Retail Sale Id 2077',3700.00,0.00,0.00,5.00,430.00,'2022-06-12 14:00:54','',''),(2078,'1','273','1',1,'Retail Sale Id 2078',747.40,0.00,0.00,1.01,86.86,'2022-06-12 14:03:44','',''),(2079,'1','273','1',1,'Retail Sale Id 2079',4440.00,0.00,0.00,6.00,516.00,'2022-06-12 14:16:00','',''),(2080,'1','273','1',1,'Retail Sale Id 2080',83520.00,0.00,0.00,120.00,5040.00,'2022-06-12 14:23:50','',''),(2081,'1','273','1',1,'Retail Sale Id 2081',83520.00,0.00,0.00,120.00,5040.00,'2022-06-12 14:24:38','',''),(2082,'1','273','1',1,'Retail Sale Id 2082',1480.00,0.00,0.00,2.00,172.00,'2022-06-12 14:34:24','',''),(2083,'1','273','1',1,'Retail Sale Id 2083',2960.00,0.00,0.00,4.00,344.00,'2022-06-12 14:35:37','',''),(2084,'1','273','1',1,'Retail Sale Id 2084',34800.00,0.00,0.00,50.00,2100.00,'2022-06-12 14:37:40','',''),(2085,'1','273','1',1,'Retail Sale Id 2085',1480.00,0.00,0.00,2.00,172.00,'2022-06-12 14:38:49','',''),(2086,'1','273','1',1,'Retail Sale Id 2086',9250.00,0.00,0.00,12.50,1075.00,'2022-06-12 14:44:21','',''),(2087,'1','273','1',1,'Retail Sale Id 2087',2960.00,0.00,0.00,4.00,344.00,'2022-06-12 15:11:35','',''),(2088,'1','273','1',1,'Retail Sale Id 2088',5920.00,0.00,0.00,8.00,688.00,'2022-06-12 15:13:23','',''),(2089,'1','273','1',1,'Retail Sale Id 2089',1502.20,0.00,0.00,2.03,174.58,'2022-06-12 15:38:01','',''),(2090,'1','273','1',1,'Retail Sale Id 2090',999.00,0.00,0.00,1.35,116.10,'2022-06-12 15:38:59','',''),(2091,'1','273','1',1,'Retail Sale Id 2091',2249.60,0.00,0.00,3.04,261.44,'2022-06-12 15:40:17','',''),(2092,'1','273','1',1,'Retail Sale Id 2092',2997.00,0.00,0.00,4.05,348.30,'2022-06-12 15:41:26','',''),(2093,'1','273','1',1,'Retail Sale Id 2093',747.40,0.00,0.00,1.01,86.86,'2022-06-12 15:42:51','',''),(2094,'1','273','1',1,'Retail Sale Id 2094',747.40,0.00,0.00,1.01,86.86,'2022-06-12 15:44:59','',''),(2095,'1','273','1',1,'Retail Sale Id 2095',74472.00,0.00,0.00,107.00,4494.00,'2022-06-12 15:46:12','',''),(2096,'1','273','1',1,'Retail Sale Id 2096',999.00,0.00,0.00,1.35,116.10,'2022-06-12 15:52:06','',''),(2097,'1','273','1',1,'Retail Sale Id 2098',4499.20,0.00,0.00,6.08,522.88,'2022-06-12 15:54:47','',''),(2098,'1','273','1',1,'Retail Sale Id 2099',5920.00,0.00,0.00,8.00,688.00,'2022-06-12 15:56:48','',''),(2099,'1','273','1',1,'Retail Sale Id 2100',740.00,0.00,0.00,1.00,86.00,'2022-06-12 16:22:32','',''),(2100,'1','273','1',1,'Retail Sale Id 2101',747.40,0.00,0.00,1.01,86.86,'2022-06-12 16:27:15','',''),(2101,'1','273','1',1,'Retail Sale Id 2102',1480.00,0.00,0.00,2.00,172.00,'2022-06-12 16:28:49','',''),(2102,'1','273','1',1,'Retail Sale Id 2103',4003.40,0.00,0.00,5.41,465.26,'2022-06-12 16:32:38','',''),(2103,'1','273','1',1,'Retail Sale Id 2104',2197.80,0.00,0.00,2.97,255.42,'2022-06-12 16:42:53','',''),(2104,'1','273','1',1,'Retail Sale Id 2105',1998.00,0.00,0.00,2.70,232.20,'2022-06-12 16:50:28','',''),(2105,'1','273','1',1,'Retail Sale Id 2106',5920.00,0.00,0.00,8.00,688.00,'2022-06-12 16:51:48','',''),(2106,'1','273','1',1,'Retail Sale Id 2107',3700.00,0.00,0.00,5.00,430.00,'2022-06-12 16:59:13','',''),(2107,'1','273','1',1,'Retail Sale Id 2108',2997.00,0.00,0.00,4.05,348.30,'2022-06-12 17:06:52','',''),(2108,'1','273','1',1,'Retail Sale Id 2110',999.00,0.00,0.00,1.35,116.10,'2022-06-12 17:08:18','',''),(2109,'1','273','1',1,'Retail Sale Id 2111',1502.20,0.00,0.00,2.03,174.58,'2022-06-12 17:17:05','',''),(2110,'1','273','1',1,'Retail Sale Id 2111',2501.20,0.00,0.00,3.38,290.68,'2022-06-12 17:17:05','',''),(2111,'1','273','1',1,'Retail Sale Id 2112',4440.00,0.00,0.00,6.00,516.00,'2022-06-12 17:19:30','',''),(2112,'1','273','1',1,'Retail Sale Id 2113',2501.20,0.00,0.00,3.38,290.68,'2022-06-12 17:23:39','',''),(2113,'1','273','1',1,'Retail Sale Id 2114',4440.00,0.00,0.00,6.00,516.00,'2022-06-12 17:25:31','',''),(2114,'1','273','1',1,'Retail Sale Id 2115',8140.00,0.00,0.00,11.00,946.00,'2022-06-12 17:42:15','',''),(2115,'1','273','1',1,'Retail Sale Id 2116',747.40,0.00,0.00,1.01,86.86,'2022-06-12 17:44:01','',''),(2116,'1','273','1',1,'Retail Sale Id 2117',5180.00,0.00,0.00,7.00,602.00,'2022-06-12 17:56:15','',''),(2117,'1','273','1',1,'Retail Sale Id 2118',747.40,0.00,0.00,1.01,86.86,'2022-06-12 17:57:15','',''),(2118,'1','273','1',1,'Retail Sale Id 2119',999.00,0.00,0.00,1.35,116.10,'2022-06-12 18:01:09','',''),(2119,'1','273','1',1,'Retail Sale Id 2120',2220.00,0.00,0.00,3.00,258.00,'2022-06-12 18:06:41','',''),(2120,'1','273','1',1,'Retail Sale Id 2121',9997.40,0.00,0.00,13.51,1161.86,'2022-06-13 07:00:21','',''),(2121,'1','273','1',1,'Retail Sale Id 2121',13001.80,0.00,0.00,17.57,1511.02,'2022-06-13 07:00:21','',''),(2122,'1','273','1',1,'Retail Sale Id 2122',1502.20,0.00,0.00,2.03,174.58,'2022-06-13 07:07:17','',''),(2123,'1','273','1',1,'Retail Sale Id 2123',6001.40,0.00,0.00,8.11,697.46,'2022-06-13 07:24:51','',''),(2124,'1','273','1',1,'Retail Sale Id 2124',2197.80,0.00,0.00,2.97,255.42,'2022-06-13 07:30:16','',''),(2125,'1','273','1',1,'Retail Sale Id 2125',7400.00,0.00,0.00,10.00,860.00,'2022-06-13 07:33:58','',''),(2126,'1','273','1',1,'Retail Sale Id 2126',999.00,0.00,0.00,1.35,116.10,'2022-06-13 07:41:19','',''),(2127,'1','273','1',1,'Retail Sale Id 2127',1480.00,0.00,0.00,2.00,172.00,'2022-06-13 07:44:36','',''),(2128,'1','273','1',1,'Retail Sale Id 2128',9250.00,0.00,0.00,12.50,1075.00,'2022-06-13 07:49:35','',''),(2129,'1','273','1',1,'Retail Sale Id 2129',9250.00,0.00,0.00,12.50,1075.00,'2022-06-13 07:51:19','',''),(2130,'1','273','1',1,'Retail Sale Id 2131',99528.00,0.00,0.00,143.00,6006.00,'2022-06-13 07:53:10','',''),(2131,'1','273','1',1,'Retail Sale Id 2132',69600.00,0.00,0.00,100.00,4200.00,'2022-06-13 07:54:31','',''),(2132,'1','273','1',1,'Retail Sale Id 2133',9250.00,0.00,0.00,12.50,1075.00,'2022-06-13 08:06:49','',''),(2133,'1','273','1',1,'Retail Sale Id 2134',747.40,0.00,0.00,1.01,86.86,'2022-06-13 08:41:34','',''),(2134,'1','273','1',1,'Retail Sale Id 2135',1998.00,0.00,0.00,2.70,232.20,'2022-06-13 08:44:09','',''),(2135,'1','273','1',1,'Retail Sale Id 2136',9250.00,0.00,0.00,12.50,1075.00,'2022-06-13 08:47:19','',''),(2136,'1','273','1',1,'Retail Sale Id 2136',9250.00,0.00,0.00,12.50,1075.00,'2022-06-13 08:47:19','',''),(2137,'1','273','1',1,'Retail Sale Id 2136',9250.00,0.00,0.00,12.50,1075.00,'2022-06-13 08:47:19','',''),(2138,'1','273','1',1,'Retail Sale Id 2137',7503.60,0.00,0.00,10.14,872.04,'2022-06-13 08:49:20','',''),(2139,'1','273','1',1,'Retail Sale Id 2138',999.00,0.00,0.00,1.35,116.10,'2022-06-13 08:57:32','',''),(2140,'1','273','1',1,'Retail Sale Id 2139',6001.40,0.00,0.00,8.11,697.46,'2022-06-13 09:01:43','',''),(2141,'1','273','1',1,'Retail Sale Id 2140',9250.00,0.00,0.00,12.50,1075.00,'2022-06-13 09:04:27','',''),(2142,'1','273','1',1,'Retail Sale Id 2141',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 09:13:13','',''),(2143,'1','273','1',1,'Retail Sale Id 2142',2960.00,0.00,0.00,4.00,344.00,'2022-06-13 09:15:13','',''),(2144,'1','273','1',1,'Retail Sale Id 2143',1480.00,0.00,0.00,2.00,172.00,'2022-06-13 09:16:31','',''),(2145,'1','273','1',1,'Retail Sale Id 2144',110664.00,0.00,0.00,159.00,6678.00,'2022-06-13 09:21:44','',''),(2146,'1','273','1',1,'Retail Sale Id 2145',104400.00,0.00,0.00,150.00,6300.00,'2022-06-13 09:23:04','',''),(2147,'1','273','1',1,'Retail Sale Id 2146',1998.00,0.00,0.00,2.70,232.20,'2022-06-13 09:27:43','',''),(2148,'1','273','1',1,'Retail Sale Id 2147',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 09:36:05','',''),(2149,'1','273','1',1,'Retail Sale Id 2148',20880.00,0.00,0.00,30.00,1260.00,'2022-06-13 09:41:42','',''),(2150,'1','273','1',1,'Retail Sale Id 2149',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 09:43:51','',''),(2151,'1','273','1',1,'Retail Sale Id 2150',747.40,0.00,0.00,1.01,86.86,'2022-06-13 09:50:23','',''),(2152,'1','273','1',1,'Retail Sale Id 2151',34800.00,0.00,0.00,50.00,2100.00,'2022-06-13 09:55:01','',''),(2153,'1','273','1',1,'Retail Sale Id 2152',18500.00,0.00,0.00,25.00,2150.00,'2022-06-13 10:19:10','',''),(2154,'1','273','1',1,'Retail Sale Id 2153',9250.00,0.00,0.00,12.50,1075.00,'2022-06-13 10:44:09','',''),(2155,'1','273','1',1,'Retail Sale Id 2154',999.00,0.00,0.00,1.35,116.10,'2022-06-13 10:47:17','',''),(2156,'1','273','1',1,'Retail Sale Id 2155',1480.00,0.00,0.00,2.00,172.00,'2022-06-13 11:07:41','',''),(2157,'1','273','1',1,'Retail Sale Id 2156',999.00,0.00,0.00,1.35,116.10,'2022-06-13 11:10:32','',''),(2158,'1','273','1',1,'Retail Sale Id 2157',2960.00,0.00,0.00,4.00,344.00,'2022-06-13 11:13:05','',''),(2159,'1','273','1',1,'Retail Sale Id 2158',1502.20,0.00,0.00,2.03,174.58,'2022-06-13 11:15:33','',''),(2160,'1','273','1',1,'Retail Sale Id 2159',4440.00,0.00,0.00,6.00,516.00,'2022-06-13 11:50:48','',''),(2161,'1','273','1',1,'Retail Sale Id 2160',8140.00,0.00,0.00,11.00,946.00,'2022-06-13 12:25:33','',''),(2162,'1','273','1',1,'Retail Sale Id 2161',999.00,0.00,0.00,1.35,116.10,'2022-06-13 12:40:38','',''),(2163,'1','273','1',1,'Retail Sale Id 2162',1502.20,0.00,0.00,2.03,174.58,'2022-06-13 12:43:29','',''),(2164,'1','273','1',1,'Retail Sale Id 2163',999.00,0.00,0.00,1.35,116.10,'2022-06-13 12:51:28','',''),(2165,'1','273','1',1,'Retail Sale Id 2164',125280.00,0.00,0.00,180.00,7560.00,'2022-06-13 12:58:40','',''),(2166,'1','273','1',1,'Retail Sale Id 2165',740.00,0.00,0.00,1.00,86.00,'2022-06-13 13:15:05','',''),(2167,'1','273','1',1,'Retail Sale Id 2166',740.00,0.00,0.00,1.00,86.00,'2022-06-13 13:17:11','',''),(2168,'1','273','1',1,'Retail Sale Id 2167',8352.00,0.00,0.00,12.00,504.00,'2022-06-13 13:19:33','',''),(2169,'1','273','1',1,'Retail Sale Id 2168',29928.00,0.00,0.00,43.00,1806.00,'2022-06-13 13:21:07','',''),(2170,'1','273','1',1,'Retail Sale Id 2169',799.20,0.00,0.00,1.08,92.88,'2022-06-13 13:42:09','',''),(2171,'1','273','1',1,'Retail Sale Id 2170',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 13:53:57','',''),(2172,'1','273','1',1,'Retail Sale Id 2171',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 14:00:05','',''),(2173,'1','273','1',1,'Retail Sale Id 2172',1502.20,0.00,0.00,2.03,174.58,'2022-06-13 14:11:06','',''),(2174,'1','273','1',1,'Retail Sale Id 2173',5920.00,0.00,0.00,8.00,688.00,'2022-06-13 14:26:40','',''),(2175,'1','273','1',1,'Retail Sale Id 2174',2997.00,0.00,0.00,4.05,348.30,'2022-06-13 14:31:28','',''),(2176,'1','273','1',1,'Retail Sale Id 2177',740.00,0.00,0.00,1.00,86.00,'2022-06-13 14:59:01','',''),(2177,'1','273','1',1,'Retail Sale Id 2178',2960.00,0.00,0.00,4.00,344.00,'2022-06-13 15:00:52','',''),(2178,'1','273','1',1,'Retail Sale Id 2179',1998.00,0.00,0.00,2.70,232.20,'2022-06-13 15:02:54','',''),(2179,'1','273','1',1,'Retail Sale Id 2181',1502.20,0.00,0.00,2.03,174.58,'2022-06-13 15:11:58','',''),(2180,'1','273','1',1,'Retail Sale Id 2182',3700.00,0.00,0.00,5.00,430.00,'2022-06-13 15:14:57','',''),(2181,'1','273','1',1,'Retail Sale Id 2183',6660.00,0.00,0.00,9.00,774.00,'2022-06-13 15:22:57','',''),(2182,'1','273','1',1,'Retail Sale Id 2184',3700.00,0.00,0.00,5.00,430.00,'2022-06-13 15:26:31','',''),(2183,'1','273','1',1,'Retail Sale Id 2185',1998.00,0.00,0.00,2.70,232.20,'2022-06-13 15:29:27','',''),(2184,'1','273','1',1,'Retail Sale Id 2186',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 15:35:18','',''),(2185,'1','273','1',1,'Retail Sale Id 2187',10360.00,0.00,0.00,14.00,1204.00,'2022-06-13 15:42:10','',''),(2186,'1','273','1',1,'Retail Sale Id 2191',1998.00,0.00,0.00,2.70,232.20,'2022-06-13 15:48:59','',''),(2187,'1','273','1',1,'Retail Sale Id 2192',5920.00,0.00,0.00,8.00,688.00,'2022-06-13 15:49:55','',''),(2188,'1','273','1',1,'Retail Sale Id 2193',5180.00,0.00,0.00,7.00,602.00,'2022-06-13 15:50:44','',''),(2189,'1','273','1',1,'Retail Sale Id 2195',4440.00,0.00,0.00,6.00,516.00,'2022-06-13 15:54:11','',''),(2190,'1','273','1',1,'Retail Sale Id 2196',4003.40,0.00,0.00,5.41,465.26,'2022-06-13 16:01:42','',''),(2191,'1','273','1',1,'Retail Sale Id 2197',999.00,0.00,0.00,1.35,116.10,'2022-06-13 16:03:05','',''),(2192,'1','273','1',1,'Retail Sale Id 2198',9250.00,0.00,0.00,12.50,1075.00,'2022-06-13 16:32:21','',''),(2193,'1','273','1',1,'Retail Sale Id 2200',1480.00,0.00,0.00,2.00,172.00,'2022-06-13 16:42:08','',''),(2194,'1','273','1',1,'Retail Sale Id 2201',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 16:49:25','',''),(2195,'1','273','1',1,'Retail Sale Id 2202',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 16:51:07','',''),(2196,'1','273','1',1,'Retail Sale Id 2203',5180.00,0.00,0.00,7.00,602.00,'2022-06-13 16:56:08','',''),(2197,'1','273','1',1,'Retail Sale Id 2205',2997.00,0.00,0.00,4.05,348.30,'2022-06-13 16:59:50','',''),(2198,'1','273','1',1,'Retail Sale Id 2206',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 17:01:48','',''),(2199,'1','273','1',1,'Retail Sale Id 2207',1480.00,0.00,0.00,2.00,172.00,'2022-06-13 17:07:28','',''),(2200,'1','273','1',1,'Retail Sale Id 2208',740.00,0.00,0.00,1.00,86.00,'2022-06-13 17:11:41','',''),(2201,'1','273','1',1,'Retail Sale Id 2209',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 17:18:43','',''),(2202,'1','273','1',1,'Retail Sale Id 2210',3700.00,0.00,0.00,5.00,430.00,'2022-06-13 17:41:59','',''),(2203,'1','273','1',1,'Retail Sale Id 2211',6660.00,0.00,0.00,9.00,774.00,'2022-06-13 17:43:18','',''),(2204,'1','273','1',1,'Retail Sale Id 2212',2220.00,0.00,0.00,3.00,258.00,'2022-06-13 17:49:05','',''),(2205,'1','273','1',1,'Retail Sale Id 2214',5601.80,0.00,0.00,7.57,651.02,'2022-06-14 07:04:05','',''),(2206,'1','273','1',1,'Retail Sale Id 2215',69600.00,0.00,0.00,100.00,4200.00,'2022-06-14 07:11:56','',''),(2207,'1','273','1',1,'Retail Sale Id 2216',49416.00,0.00,0.00,71.00,2982.00,'2022-06-14 07:12:46','',''),(2208,'1','273','1',1,'Retail Sale Id 2217',1502.20,0.00,0.00,2.03,174.58,'2022-06-14 07:19:02','',''),(2209,'1','273','1',1,'Retail Sale Id 2218',1480.00,0.00,0.00,2.00,172.00,'2022-06-14 07:20:20','',''),(2210,'1','273','1',1,'Retail Sale Id 2219',2997.00,0.00,0.00,4.05,348.30,'2022-06-14 07:29:36','',''),(2211,'1','273','1',1,'Retail Sale Id 2220',1480.00,0.00,0.00,2.00,172.00,'2022-06-14 07:34:20','',''),(2212,'1','273','1',1,'Retail Sale Id 2221',747.40,0.00,0.00,1.01,86.86,'2022-06-14 07:43:38','',''),(2213,'1','273','1',1,'Retail Sale Id 2222',2220.00,0.00,0.00,3.00,258.00,'2022-06-14 07:50:14','',''),(2214,'1','273','1',1,'Retail Sale Id 2223',3700.00,0.00,0.00,5.00,430.00,'2022-06-14 07:57:23','',''),(2215,'1','273','1',1,'Retail Sale Id 2224',1998.00,0.00,0.00,2.70,232.20,'2022-06-14 08:32:27','',''),(2216,'1','273','1',1,'Retail Sale Id 2225',6001.40,0.00,0.00,8.11,697.46,'2022-06-14 08:34:22','',''),(2217,'1','273','1',1,'Retail Sale Id 2226',1480.00,0.00,0.00,2.00,172.00,'2022-06-14 08:36:04','',''),(2218,'1','273','1',1,'Retail Sale Id 2227',1998.00,0.00,0.00,2.70,232.20,'2022-06-14 08:38:14','',''),(2219,'1','273','1',1,'Retail Sale Id 2228',747.40,0.00,0.00,1.01,86.86,'2022-06-14 08:40:01','',''),(2220,'1','273','1',1,'Retail Sale Id 2229',2997.00,0.00,0.00,4.05,348.30,'2022-06-14 08:41:39','',''),(2221,'1','273','1',1,'Retail Sale Id 2230',9250.00,0.00,0.00,12.50,1075.00,'2022-06-14 08:42:44','',''),(2222,'1','273','1',1,'Retail Sale Id 2231',2997.00,0.00,0.00,4.05,348.30,'2022-06-14 08:50:12','',''),(2223,'1','273','1',1,'Retail Sale Id 2232',2397.60,0.00,0.00,3.24,278.64,'2022-06-14 08:57:55','',''),(2224,'1','273','1',1,'Retail Sale Id 2233',2960.00,0.00,0.00,4.00,344.00,'2022-06-14 09:00:46','',''),(2225,'1','273','1',1,'Retail Sale Id 2233',9250.00,0.00,0.00,12.50,1075.00,'2022-06-14 09:00:46','',''),(2226,'1','273','1',1,'Retail Sale Id 2234',9250.00,0.00,0.00,12.50,1075.00,'2022-06-14 09:01:42','',''),(2227,'1','273','1',1,'Retail Sale Id 2235',9250.00,0.00,0.00,12.50,1075.00,'2022-06-14 09:03:35','',''),(2228,'1','273','1',1,'Retail Sale Id 2236',49993.68,0.00,0.00,71.83,3016.86,'2022-06-14 09:13:37','',''),(2229,'1','273','1',1,'Retail Sale Id 2237',19980.00,0.00,0.00,27.00,2322.00,'2022-06-14 09:17:28','',''),(2230,'1','273','1',1,'Return of Retail Sale Id 2237',0.00,19980.00,27.00,0.00,-2322.00,'2022-06-14 09:19:37','',''),(2231,'1','273','1',1,'Retail Sale Id 2238',19980.00,0.00,0.00,27.00,2322.00,'2022-06-14 09:20:27','',''),(2232,'1','273','1',1,'Retail Sale Id 2239',25056.00,0.00,0.00,36.00,1512.00,'2022-06-14 09:24:27','',''),(2233,'1','273','1',1,'Retail Sale Id 2240',2960.00,0.00,0.00,4.00,344.00,'2022-06-14 10:04:14','',''),(2234,'1','273','1',1,'Retail Sale Id 2241',4440.00,0.00,0.00,6.00,516.00,'2022-06-14 10:05:33','',''),(2235,'1','273','1',1,'Retail Sale Id 2242',3700.00,0.00,0.00,5.00,430.00,'2022-06-14 10:31:22','',''),(2236,'1','273','1',1,'Retail Sale Id 2243',999.00,0.00,0.00,1.35,116.10,'2022-06-14 10:56:58','',''),(2237,'1','273','1',1,'Retail Sale Id 2244',34800.00,0.00,0.00,50.00,2100.00,'2022-06-14 11:08:47','',''),(2238,'1','273','1',1,'Retail Sale Id 2245',2249.60,0.00,0.00,3.04,261.44,'2022-06-14 11:10:17','',''),(2239,'1','273','1',1,'Retail Sale Id 2246',999.00,0.00,0.00,1.35,116.10,'2022-06-14 11:15:43','',''),(2240,'1','273','1',1,'Retail Sale Id 2247',3700.00,0.00,0.00,5.00,430.00,'2022-06-14 11:34:17','',''),(2241,'1','273','1',1,'Retail Sale Id 2248',2220.00,0.00,0.00,3.00,258.00,'2022-06-14 11:36:49','',''),(2242,'1','273','1',1,'Retail Sale Id 2249',1480.00,0.00,0.00,2.00,172.00,'2022-06-14 11:47:56','',''),(2243,'1','273','1',1,'Retail Sale Id 2250',2997.00,0.00,0.00,4.05,348.30,'2022-06-14 11:49:36','',''),(2244,'1','273','1',1,'Retail Sale Id 2252',2997.00,0.00,0.00,4.05,348.30,'2022-06-14 11:50:58','',''),(2245,'1','273','1',1,'Retail Sale Id 2253',102660.00,0.00,0.00,147.50,6195.00,'2022-06-14 11:52:00','',''),(2246,'1','273','1',1,'Retail Sale Id 2254',1502.20,0.00,0.00,2.03,174.58,'2022-06-14 11:52:48','',''),(2247,'1','273','1',1,'Retail Sale Id 2255',2797.20,0.00,0.00,3.78,325.08,'2022-06-14 11:53:25','',''),(2248,'1','273','1',1,'Retail Sale Id 2256',1480.00,0.00,0.00,2.00,172.00,'2022-06-14 11:53:55','',''),(2249,'1','273','1',1,'Retail Sale Id 2257',2997.00,0.00,0.00,4.05,348.30,'2022-06-14 12:28:22','',''),(2250,'1','273','1',1,'Retail Sale Id 2258',36888.00,0.00,0.00,53.00,2226.00,'2022-06-14 12:59:05','',''),(2251,'1','273','1',1,'Retail Sale Id 2259',2220.00,0.00,0.00,3.00,258.00,'2022-06-14 13:09:22','',''),(2252,'1','273','1',1,'Retail Sale Id 2260',3700.00,0.00,0.00,5.00,430.00,'2022-06-14 13:28:25','',''),(2253,'1','273','1',1,'Retail Sale Id 2261',7400.00,0.00,0.00,10.00,860.00,'2022-06-14 14:11:33','',''),(2254,'1','273','1',1,'Retail Sale Id 2262',999.00,0.00,0.00,1.35,116.10,'2022-06-14 14:49:01','',''),(2255,'1','273','1',1,'Retail Sale Id 2263',1502.20,0.00,0.00,2.03,174.58,'2022-06-14 14:55:59','',''),(2256,'1','273','1',1,'Retail Sale Id 2265',31320.00,0.00,0.00,45.00,1890.00,'2022-06-14 14:58:54','',''),(2257,'1','273','1',1,'Retail Sale Id 2266',62640.00,0.00,0.00,90.00,3780.00,'2022-06-14 15:35:15','',''),(2258,'1','273','1',1,'Retail Sale Id 2267',9250.00,0.00,0.00,12.50,1075.00,'2022-06-14 15:36:42','',''),(2259,'1','273','1',1,'Retail Sale Id 2268',1502.20,0.00,0.00,2.03,174.58,'2022-06-14 15:38:31','',''),(2260,'1','273','1',1,'Retail Sale Id 2269',999.00,0.00,0.00,1.35,116.10,'2022-06-14 15:39:33','',''),(2261,'1','273','1',1,'Retail Sale Id 2270',999.00,0.00,0.00,1.35,116.10,'2022-06-14 15:40:55','',''),(2262,'1','273','1',1,'Retail Sale Id 2271',3500.20,0.00,0.00,4.73,406.78,'2022-06-14 15:46:25','',''),(2263,'1','273','1',1,'Retail Sale Id 2272',83520.00,0.00,0.00,120.00,5040.00,'2022-06-14 15:48:24','',''),(2264,'1','273','1',1,'Retail Sale Id 2273',2997.00,0.00,0.00,4.05,348.30,'2022-06-14 15:52:20','',''),(2265,'1','273','1',1,'Retail Sale Id 2274',18500.00,0.00,0.00,25.00,2150.00,'2022-06-14 15:55:56','',''),(2266,'1','273','1',1,'Retail Sale Id 2275',5002.40,0.00,0.00,6.76,581.36,'2022-06-14 15:59:31','',''),(2267,'1','273','1',1,'Retail Sale Id 2276',2960.00,0.00,0.00,4.00,344.00,'2022-06-14 16:00:51','',''),(2268,'1','273','1',1,'Retail Sale Id 2277',2960.00,0.00,0.00,4.00,344.00,'2022-06-14 16:07:11','',''),(2269,'1','273','1',1,'Retail Sale Id 2278',9250.00,0.00,0.00,12.50,1075.00,'2022-06-14 16:08:27','',''),(2270,'1','273','1',1,'Retail Sale Id 2279',3700.00,0.00,0.00,5.00,430.00,'2022-06-14 16:09:39','',''),(2271,'1','273','1',1,'Retail Sale Id 2280',1998.00,0.00,0.00,2.70,232.20,'2022-06-14 16:10:31','',''),(2272,'1','273','1',1,'Retail Sale Id 2281',5920.00,0.00,0.00,8.00,688.00,'2022-06-14 16:20:34','',''),(2273,'1','273','1',1,'Retail Sale Id 2282',2249.60,0.00,0.00,3.04,261.44,'2022-06-14 16:26:10','',''),(2274,'1','273','1',1,'Retail Sale Id 2283',999.00,0.00,0.00,1.35,116.10,'2022-06-14 17:00:36','',''),(2275,'1','273','1',1,'Retail Sale Id 2284',999.00,0.00,0.00,1.35,116.10,'2022-06-14 17:35:52','',''),(2276,'1','273','1',1,'Retail Sale Id 2285',1480.00,0.00,0.00,2.00,172.00,'2022-06-14 17:37:15','',''),(2277,'1','273','1',1,'Retail Sale Id 2286',799.20,0.00,0.00,1.08,92.88,'2022-06-14 17:50:43','',''),(2278,'1','273','1',1,'Retail Sale Id 2287',1480.00,0.00,0.00,2.00,172.00,'2022-06-14 18:09:24','',''),(2279,'1','273','1',1,'Retail Sale Id 2288',1147.00,0.00,0.00,1.55,133.30,'2022-06-14 19:03:15','',''),(2280,'1','273','1',1,'Retail Sale Id 2289',4003.40,0.00,0.00,5.41,465.26,'2022-06-15 07:07:05','',''),(2281,'1','273','1',1,'Retail Sale Id 2290',1598.40,0.00,0.00,2.16,185.76,'2022-06-15 07:07:47','',''),(2282,'1','273','1',1,'Retail Sale Id 2291',4440.00,0.00,0.00,6.00,516.00,'2022-06-15 07:28:31','',''),(2283,'1','273','1',1,'Retail Sale Id 2292',1502.20,0.00,0.00,2.03,174.58,'2022-06-15 07:34:33','',''),(2284,'1','273','1',1,'Retail Sale Id 2293',999.00,0.00,0.00,1.35,116.10,'2022-06-15 07:55:46','',''),(2285,'1','273','1',1,'Retail Sale Id 2294',9250.00,0.00,0.00,12.50,1075.00,'2022-06-15 08:05:14','',''),(2286,'1','273','1',1,'Retail Sale Id 2295',747.40,0.00,0.00,1.01,86.86,'2022-06-15 08:07:44','',''),(2287,'1','273','1',1,'Retail Sale Id 2296',747.40,0.00,0.00,1.01,86.86,'2022-06-15 08:08:30','',''),(2288,'1','273','1',1,'Retail Sale Id 2297',1198.80,0.00,0.00,1.62,139.32,'2022-06-15 08:24:52','',''),(2289,'1','273','1',1,'Retail Sale Id 2298',1480.00,0.00,0.00,2.00,172.00,'2022-06-15 08:31:10','',''),(2290,'1','273','1',1,'Retail Sale Id 2298',9250.00,0.00,0.00,12.50,1075.00,'2022-06-15 08:31:10','',''),(2291,'1','273','1',1,'Retail Sale Id 2300',1998.00,0.00,0.00,2.70,232.20,'2022-06-15 08:32:47','',''),(2292,'1','273','1',1,'Retail Sale Id 2301',4440.00,0.00,0.00,6.00,516.00,'2022-06-15 08:38:13','',''),(2293,'1','273','1',1,'Retail Sale Id 2302',1502.20,0.00,0.00,2.03,174.58,'2022-06-15 08:53:10','',''),(2294,'1','273','1',1,'Retail Sale Id 2303',17760.00,0.00,0.00,24.00,2064.00,'2022-06-15 08:57:45','',''),(2295,'1','273','1',1,'Retail Sale Id 2305',2249.60,0.00,0.00,3.04,261.44,'2022-06-15 09:05:30','',''),(2296,'1','273','1',1,'Retail Sale Id 2306',7000.40,0.00,0.00,9.46,813.56,'2022-06-15 09:06:58','',''),(2297,'1','273','1',1,'Retail Sale Id 2307',104400.00,0.00,0.00,150.00,6300.00,'2022-06-15 09:22:09','',''),(2298,'1','273','1',1,'Retail Sale Id 2309',104400.00,0.00,0.00,150.00,6300.00,'2022-06-15 09:23:13','',''),(2299,'1','273','1',1,'Retail Sale Id 2310',2220.00,0.00,0.00,3.00,258.00,'2022-06-15 09:26:37','',''),(2300,'1','273','1',1,'Retail Sale Id 2311',1502.20,0.00,0.00,2.03,174.58,'2022-06-15 09:29:54','',''),(2301,'1','273','1',1,'Retail Sale Id 2312',89088.00,0.00,0.00,128.00,5376.00,'2022-06-15 09:42:26','',''),(2302,'1','273','1',1,'Retail Sale Id 2313',7400.00,0.00,0.00,10.00,860.00,'2022-06-15 09:43:37','',''),(2303,'1','273','1',1,'Retail Sale Id 2314',34800.00,0.00,0.00,50.00,2100.00,'2022-06-15 09:45:15','',''),(2304,'1','273','1',1,'Retail Sale Id 2316',92568.00,0.00,0.00,133.00,5586.00,'2022-06-15 09:57:36','',''),(2305,'1','273','1',1,'Retail Sale Id 2317',34800.00,0.00,0.00,50.00,2100.00,'2022-06-15 09:59:15','',''),(2306,'1','273','1',1,'Retail Sale Id 2318',8880.00,0.00,0.00,12.00,1032.00,'2022-06-15 10:03:16','',''),(2307,'1','273','1',1,'Retail Sale Id 2319',747.40,0.00,0.00,1.01,86.86,'2022-06-15 10:30:36','',''),(2308,'1','273','1',1,'Retail Sale Id 2320',999.00,0.00,0.00,1.35,116.10,'2022-06-15 10:43:47','',''),(2309,'1','273','1',1,'Retail Sale Id 2320',1502.20,0.00,0.00,2.03,174.58,'2022-06-15 10:43:47','',''),(2310,'1','273','1',1,'Retail Sale Id 2321',69600.00,0.00,0.00,100.00,4200.00,'2022-06-15 10:50:38','',''),(2311,'1','273','1',1,'Retail Sale Id 2322',740.00,0.00,0.00,1.00,86.00,'2022-06-15 11:03:45','',''),(2312,'1','273','1',1,'Return of Retail Sale Id 2322',0.00,740.00,1.00,0.00,-86.00,'2022-06-15 11:07:09','',''),(2313,'1','273','1',1,'Retail Sale Id 2323',6660.00,0.00,0.00,9.00,774.00,'2022-06-15 11:27:28','',''),(2314,'1','273','1',1,'Retail Sale Id 2324',2220.00,0.00,0.00,3.00,258.00,'2022-06-15 11:39:32','',''),(2315,'1','273','1',1,'Retail Sale Id 2325',1502.20,0.00,0.00,2.03,174.58,'2022-06-15 11:43:21','',''),(2316,'1','273','1',1,'Retail Sale Id 2326',2220.00,0.00,0.00,3.00,258.00,'2022-06-15 11:53:00','',''),(2317,'1','273','1',1,'Retail Sale Id 2327',9250.00,0.00,0.00,12.50,1075.00,'2022-06-15 11:55:10','',''),(2318,'1','273','1',1,'Retail Sale Id 2328',2220.00,0.00,0.00,3.00,258.00,'2022-06-15 11:58:55','',''),(2319,'1','273','1',1,'Retail Sale Id 2328',3700.00,0.00,0.00,5.00,430.00,'2022-06-15 11:58:55','',''),(2320,'1','273','1',1,'Retail Sale Id 2329',2997.00,0.00,0.00,4.05,348.30,'2022-06-15 12:22:25','',''),(2321,'1','273','1',1,'Retail Sale Id 2330',9250.00,0.00,0.00,12.50,1075.00,'2022-06-15 12:28:17','',''),(2322,'1','273','1',1,'Retail Sale Id 2331',999.00,0.00,0.00,1.35,116.10,'2022-06-15 12:29:30','',''),(2323,'1','273','1',1,'Retail Sale Id 2332',3700.00,0.00,0.00,5.00,430.00,'2022-06-15 12:35:15','',''),(2324,'1','273','1',1,'Retail Sale Id 2333',6001.40,0.00,0.00,8.11,697.46,'2022-06-15 12:36:32','',''),(2325,'1','273','1',1,'Retail Sale Id 2334',999.00,0.00,0.00,1.35,116.10,'2022-06-15 12:42:43','',''),(2326,'1','273','1',1,'Retail Sale Id 2335',6497.20,0.00,0.00,8.78,755.08,'2022-06-15 12:50:59','',''),(2327,'1','273','1',1,'Retail Sale Id 2336',1480.00,0.00,0.00,2.00,172.00,'2022-06-15 12:54:34','',''),(2328,'1','273','1',1,'Retail Sale Id 2337',1198.80,0.00,0.00,1.62,139.32,'2022-06-15 12:59:40','',''),(2329,'1','273','1',1,'Retail Sale Id 2338',1480.00,0.00,0.00,2.00,172.00,'2022-06-15 13:02:14','',''),(2330,'1','273','1',1,'Retail Sale Id 2339',999.00,0.00,0.00,1.35,116.10,'2022-06-15 13:03:51','',''),(2331,'1','273','1',1,'Retail Sale Id 2340',69600.00,0.00,0.00,100.00,4200.00,'2022-06-15 13:07:20','',''),(2332,'1','273','1',1,'Retail Sale Id 2341',9250.00,0.00,0.00,12.50,1075.00,'2022-06-15 13:15:38','',''),(2333,'1','273','1',1,'Retail Sale Id 2342',4003.40,0.00,0.00,5.41,465.26,'2022-06-15 13:17:17','',''),(2334,'1','273','1',1,'Retail Sale Id 2343',1998.00,0.00,0.00,2.70,232.20,'2022-06-15 13:39:59','',''),(2335,'1','273','1',1,'Retail Sale Id 2344',3700.00,0.00,0.00,5.00,430.00,'2022-06-15 13:51:07','',''),(2336,'1','273','1',1,'Retail Sale Id 2345',799.20,0.00,0.00,1.08,92.88,'2022-06-15 13:52:44','',''),(2337,'1','273','1',1,'Retail Sale Id 2346',4440.00,0.00,0.00,6.00,516.00,'2022-06-15 13:55:00','',''),(2338,'1','273','1',1,'Retail Sale Id 2347',5002.40,0.00,0.00,6.76,581.36,'2022-06-15 14:00:44','',''),(2339,'1','273','1',1,'Retail Sale Id 2348',1502.20,0.00,0.00,2.03,174.58,'2022-06-15 14:31:57','',''),(2340,'1','273','1',1,'Retail Sale Id 2349',9250.00,0.00,0.00,12.50,1075.00,'2022-06-15 14:45:33','',''),(2341,'1','273','1',1,'Retail Sale Id 2350',2997.00,0.00,0.00,4.05,348.30,'2022-06-15 14:48:38','',''),(2342,'1','273','1',1,'Retail Sale Id 2351',2220.00,0.00,0.00,3.00,258.00,'2022-06-15 14:57:18','',''),(2343,'1','273','1',1,'Retail Sale Id 2352',167040.00,0.00,0.00,240.00,10080.00,'2022-06-15 14:59:03','',''),(2344,'1','273','1',1,'Retail Sale Id 2353',125280.00,0.00,0.00,180.00,7560.00,'2022-06-15 15:00:10','',''),(2345,'1','273','1',1,'Retail Sale Id 2354',1480.00,0.00,0.00,2.00,172.00,'2022-06-15 15:00:53','',''),(2346,'1','273','1',1,'Retail Sale Id 2355',1998.00,0.00,0.00,2.70,232.20,'2022-06-15 15:08:22','',''),(2347,'1','273','1',1,'Retail Sale Id 2356',18792.00,0.00,0.00,27.00,1134.00,'2022-06-15 15:11:42','',''),(2348,'1','273','1',1,'Retail Sale Id 2357',747.40,0.00,0.00,1.01,86.86,'2022-06-15 15:13:40','',''),(2349,'1','273','1',1,'Retail Sale Id 2358',999.00,0.00,0.00,1.35,116.10,'2022-06-15 15:16:37','',''),(2350,'1','273','1',1,'Retail Sale Id 2359',999.00,0.00,0.00,1.35,116.10,'2022-06-15 15:24:30','',''),(2351,'1','273','1',1,'Retail Sale Id 2360',2997.00,0.00,0.00,4.05,348.30,'2022-06-15 15:33:10','',''),(2352,'1','273','1',1,'Retail Sale Id 2361',5920.00,0.00,0.00,8.00,688.00,'2022-06-15 15:46:29','',''),(2353,'1','273','1',1,'Retail Sale Id 2362',3700.00,0.00,0.00,5.00,430.00,'2022-06-15 16:13:59','',''),(2354,'1','273','1',1,'Retail Sale Id 2363',8140.00,0.00,0.00,11.00,946.00,'2022-06-15 16:15:47','',''),(2355,'1','273','1',1,'Retail Sale Id 2364',62640.00,0.00,0.00,90.00,3780.00,'2022-06-15 16:18:32','',''),(2356,'1','273','1',1,'Retail Sale Id 2365',1480.00,0.00,0.00,2.00,172.00,'2022-06-15 16:20:46','',''),(2357,'1','273','1',1,'Retail Sale Id 2366',740.00,0.00,0.00,1.00,86.00,'2022-06-15 16:23:49','',''),(2358,'1','273','1',1,'Retail Sale Id 2367',1480.00,0.00,0.00,2.00,172.00,'2022-06-15 16:28:31','',''),(2359,'1','273','1',1,'Retail Sale Id 2368',999.00,0.00,0.00,1.35,116.10,'2022-06-15 16:35:09','',''),(2360,'1','273','1',1,'Retail Sale Id 2369',1502.20,0.00,0.00,2.03,174.58,'2022-06-15 16:39:36','',''),(2361,'1','273','1',1,'Retail Sale Id 2369',2997.00,0.00,0.00,4.05,348.30,'2022-06-15 16:39:36','',''),(2362,'1','273','1',1,'Retail Sale Id 2370',999.00,0.00,0.00,1.35,116.10,'2022-06-15 16:47:06','',''),(2363,'1','273','1',1,'Retail Sale Id 2371',1480.00,0.00,0.00,2.00,172.00,'2022-06-15 16:51:06','',''),(2364,'1','273','1',1,'Retail Sale Id 2372',3700.00,0.00,0.00,5.00,430.00,'2022-06-15 17:02:05','',''),(2365,'1','273','1',1,'Retail Sale Id 2373',5002.40,0.00,0.00,6.76,581.36,'2022-06-15 17:04:47','',''),(2366,'1','273','1',1,'Retail Sale Id 2374',1901.80,0.00,0.00,2.57,221.02,'2022-06-15 17:07:22','',''),(2367,'1','273','1',1,'Retail Sale Id 2376',747.40,0.00,0.00,1.01,86.86,'2022-06-15 17:10:22','',''),(2368,'1','273','1',1,'Retail Sale Id 2377',2997.00,0.00,0.00,4.05,348.30,'2022-06-15 17:11:45','',''),(2369,'1','273','1',1,'Retail Sale Id 2378',2220.00,0.00,0.00,3.00,258.00,'2022-06-15 17:14:34','',''),(2370,'1','273','1',1,'Retail Sale Id 2379',799.20,0.00,0.00,1.08,92.88,'2022-06-15 17:17:37','',''),(2371,'1','273','1',1,'Retail Sale Id 2380',999.00,0.00,0.00,1.35,116.10,'2022-06-15 17:18:50','',''),(2372,'1','273','1',1,'Retail Sale Id 2381',1502.20,0.00,0.00,2.03,174.58,'2022-06-15 17:21:25','',''),(2373,'1','273','1',1,'Retail Sale Id 2382',1502.20,0.00,0.00,2.03,174.58,'2022-06-15 17:24:03','',''),(2374,'1','273','1',1,'Retail Sale Id 2383',1502.20,0.00,0.00,2.03,174.58,'2022-06-15 17:26:40','',''),(2375,'1','273','1',1,'Retail Sale Id 2384',34800.00,0.00,0.00,50.00,2100.00,'2022-06-15 17:36:21','',''),(2376,'1','273','1',1,'Retail Sale Id 2385',1480.00,0.00,0.00,2.00,172.00,'2022-06-15 17:37:33','',''),(2377,'1','273','1',1,'Retail Sale Id 2386',799.20,0.00,0.00,1.08,92.88,'2022-06-15 17:40:50','',''),(2378,'1','273','1',1,'Retail Sale Id 2387',2960.00,0.00,0.00,4.00,344.00,'2022-06-15 17:42:31','',''),(2379,'1','273','1',1,'Retail Sale Id 2388',999.00,0.00,0.00,1.35,116.10,'2022-06-15 17:43:24','',''),(2380,'1','273','1',1,'Retail Sale Id 2389',1998.00,0.00,0.00,2.70,232.20,'2022-06-15 17:52:35','',''),(2381,'1','273','1',1,'Retail Sale Id 2390',9250.00,0.00,0.00,12.50,1075.00,'2022-06-15 17:54:23','',''),(2382,'1','273','1',1,'Retail Sale Id 2391',2997.00,0.00,0.00,4.05,348.30,'2022-06-15 17:55:15','',''),(2383,'1','273','1',1,'Retail Sale Id 2392',4440.00,0.00,0.00,6.00,516.00,'2022-06-15 17:56:08','',''),(2384,'1','273','1',1,'Retail Sale Id 2393',2220.00,0.00,0.00,3.00,258.00,'2022-06-15 17:57:19','',''),(2385,'1','273','1',1,'Retail Sale Id 2394',2220.00,0.00,0.00,3.00,258.00,'2022-06-15 17:58:07','',''),(2386,'1','273','1',1,'Retail Sale Id 2395',4070.00,0.00,0.00,5.50,473.00,'2022-06-15 17:59:06','',''),(2387,'1','273','1',1,'Retail Sale Id 2396',2197.80,0.00,0.00,2.97,255.42,'2022-06-15 18:01:09','',''),(2388,'1','273','1',1,'Retail Sale Id 2397',16008.00,0.00,0.00,23.00,966.00,'2022-06-15 18:02:25','',''),(2389,'1','273','1',1,'Retail Sale Id 2398',740.00,0.00,0.00,1.00,86.00,'2022-06-15 18:03:06','',''),(2390,'1','273','1',1,'Retail Sale Id 2399',1998.00,0.00,0.00,2.70,232.20,'2022-06-15 18:09:04','',''),(2391,'1','273','1',1,'Retail Sale Id 2400',3500.20,0.00,0.00,4.73,406.78,'2022-06-15 18:19:29','',''),(2392,'1','273','1',1,'Return of Retail Sale Id 2391',0.00,2997.00,4.05,0.00,-348.30,'2022-06-15 18:37:29','',''),(2393,'1','273','1',1,'Retail Sale Id 2401',122496.00,0.00,0.00,176.00,7392.00,'2022-06-16 06:57:22','',''),(2394,'1','273','1',1,'Retail Sale Id 2402',24993.36,0.00,0.00,35.91,1508.22,'2022-06-16 06:59:04','',''),(2395,'1','273','1',1,'Retail Sale Id 2403',2997.00,0.00,0.00,4.05,348.30,'2022-06-16 07:01:16','',''),(2396,'1','273','1',1,'Retail Sale Id 2404',2249.60,0.00,0.00,3.04,261.44,'2022-06-16 07:10:59','',''),(2397,'1','273','1',1,'Retail Sale Id 2405',1502.20,0.00,0.00,2.03,174.58,'2022-06-16 07:12:40','',''),(2398,'1','273','1',1,'Retail Sale Id 2406',999.00,0.00,0.00,1.35,116.10,'2022-06-16 07:18:32','',''),(2399,'1','273','1',1,'Retail Sale Id 2409',2197.80,0.00,0.00,2.97,255.42,'2022-06-16 07:45:48','',''),(2400,'1','273','1',1,'Retail Sale Id 2409',5180.00,0.00,0.00,7.00,602.00,'2022-06-16 07:45:48','',''),(2401,'1','273','1',1,'Retail Sale Id 2410',2220.00,0.00,0.00,3.00,258.00,'2022-06-16 07:47:34','',''),(2402,'1','273','1',1,'Retail Sale Id 2410',2960.00,0.00,0.00,4.00,344.00,'2022-06-16 07:47:34','',''),(2403,'1','273','1',1,'Retail Sale Id 2411',5202.20,0.00,0.00,7.03,604.58,'2022-06-16 07:54:36','',''),(2404,'1','273','1',1,'Retail Sale Id 2412',5180.00,0.00,0.00,7.00,602.00,'2022-06-16 08:02:02','',''),(2405,'1','273','1',1,'Retail Sale Id 2413',747.40,0.00,0.00,1.01,86.86,'2022-06-16 08:37:02','',''),(2406,'1','273','1',1,'Retail Sale Id 2414',747.40,0.00,0.00,1.01,86.86,'2022-06-16 08:37:47','',''),(2407,'1','273','1',1,'Retail Sale Id 2415',2997.00,0.00,0.00,4.05,348.30,'2022-06-16 08:39:46','',''),(2408,'1','273','1',1,'Retail Sale Id 2416',1502.20,0.00,0.00,2.03,174.58,'2022-06-16 08:43:56','',''),(2409,'1','273','1',1,'Retail Sale Id 2417',9250.00,0.00,0.00,12.50,1075.00,'2022-06-16 08:46:11','',''),(2410,'1','273','1',1,'Retail Sale Id 2418',3700.00,0.00,0.00,5.00,430.00,'2022-06-16 08:54:42','',''),(2411,'1','273','1',1,'Retail Sale Id 2419',9250.00,0.00,0.00,12.50,1075.00,'2022-06-16 09:01:43','',''),(2412,'1','273','1',1,'Retail Sale Id 2420',9250.00,0.00,0.00,12.50,1075.00,'2022-06-16 09:20:28','',''),(2413,'1','273','1',1,'Retail Sale Id 2421',2997.00,0.00,0.00,4.05,348.30,'2022-06-16 09:23:24','',''),(2414,'1','273','1',1,'Retail Sale Id 2422',747.40,0.00,0.00,1.01,86.86,'2022-06-16 09:27:25','',''),(2415,'1','273','1',1,'Retail Sale Id 2423',999.00,0.00,0.00,1.35,116.10,'2022-06-16 09:45:38','',''),(2416,'1','273','1',1,'Retail Sale Id 2424',2220.00,0.00,0.00,3.00,258.00,'2022-06-16 09:46:31','',''),(2417,'1','273','1',1,'Retail Sale Id 2425',999.00,0.00,0.00,1.35,116.10,'2022-06-16 09:47:34','',''),(2418,'1','273','1',1,'Retail Sale Id 2426',1502.20,0.00,0.00,2.03,174.58,'2022-06-16 10:07:09','',''),(2419,'1','273','1',1,'Retail Sale Id 2427',999.00,0.00,0.00,1.35,116.10,'2022-06-16 10:35:53','',''),(2420,'1','273','1',1,'Retail Sale Id 2428',57072.00,0.00,0.00,82.00,3444.00,'2022-06-16 10:45:26','',''),(2421,'1','273','1',1,'Retail Sale Id 2429',69600.00,0.00,0.00,100.00,4200.00,'2022-06-16 11:06:23','',''),(2422,'1','273','1',1,'Retail Sale Id 2430',9250.00,0.00,0.00,12.50,1075.00,'2022-06-16 11:28:11','',''),(2423,'1','273','1',1,'Retail Sale Id 2431',2220.00,0.00,0.00,3.00,258.00,'2022-06-16 11:32:23','',''),(2424,'1','273','1',1,'Retail Sale Id 2432',740.00,0.00,0.00,1.00,86.00,'2022-06-16 11:34:31','',''),(2425,'1','273','1',1,'Retail Sale Id 2433',7400.00,0.00,0.00,10.00,860.00,'2022-06-16 11:39:49','',''),(2426,'1','273','1',1,'Retail Sale Id 2434',8998.40,0.00,0.00,12.16,1045.76,'2022-06-16 12:09:00','',''),(2427,'1','273','1',1,'Retail Sale Id 2435',747.40,0.00,0.00,1.01,86.86,'2022-06-16 12:49:38','',''),(2428,'1','273','1',1,'Retail Sale Id 2436',2997.00,0.00,0.00,4.05,348.30,'2022-06-16 12:54:20','',''),(2429,'1','273','1',1,'Retail Sale Id 2437',6660.00,0.00,0.00,9.00,774.00,'2022-06-16 13:38:45','',''),(2430,'1','273','1',1,'Retail Sale Id 2438',57072.00,0.00,0.00,82.00,3444.00,'2022-06-16 13:41:52','',''),(2431,'1','273','1',1,'Retail Sale Id 2439',2249.60,0.00,0.00,3.04,261.44,'2022-06-16 14:22:44','',''),(2432,'1','273','1',1,'Retail Sale Id 2440',34800.00,0.00,0.00,50.00,2100.00,'2022-06-16 14:31:44','',''),(2433,'1','273','1',1,'Retail Sale Id 2441',9250.00,0.00,0.00,12.50,1075.00,'2022-06-16 14:33:14','',''),(2434,'1','273','1',1,'Retail Sale Id 2442',2997.00,0.00,0.00,4.05,348.30,'2022-06-16 14:38:25','',''),(2435,'1','273','1',1,'Retail Sale Id 2443',5180.00,0.00,0.00,7.00,602.00,'2022-06-16 14:54:19','',''),(2436,'1','273','1',1,'Retail Sale Id 2444',747.40,0.00,0.00,1.01,86.86,'2022-06-16 15:43:59','',''),(2437,'1','273','1',1,'Retail Sale Id 2445',2997.00,0.00,0.00,4.05,348.30,'2022-06-16 16:11:23','',''),(2438,'1','273','1',1,'Retail Sale Id 2446',1480.00,0.00,0.00,2.00,172.00,'2022-06-16 16:16:51','',''),(2439,'1','273','1',1,'Retail Sale Id 2447',1502.20,0.00,0.00,2.03,174.58,'2022-06-16 16:18:31','',''),(2440,'1','273','1',1,'Retail Sale Id 2448',1502.20,0.00,0.00,2.03,174.58,'2022-06-16 16:48:59','',''),(2441,'1','273','1',1,'Retail Sale Id 2449',1502.20,0.00,0.00,2.03,174.58,'2022-06-16 17:02:32','',''),(2442,'1','273','1',1,'Retail Sale Id 2450',9620.00,0.00,0.00,13.00,1118.00,'2022-06-16 17:06:10','',''),(2443,'1','273','1',1,'Retail Sale Id 2451',5180.00,0.00,0.00,7.00,602.00,'2022-06-16 17:08:28','',''),(2444,'1','273','1',1,'Retail Sale Id 2452',1998.00,0.00,0.00,2.70,232.20,'2022-06-16 17:10:21','',''),(2445,'1','273','1',1,'Retail Sale Id 2453',69600.00,0.00,0.00,100.00,4200.00,'2022-06-16 17:11:46','',''),(2446,'1','273','1',1,'Retail Sale Id 2454',740.00,0.00,0.00,1.00,86.00,'2022-06-16 17:14:33','',''),(2447,'1','273','1',1,'Retail Sale Id 2455',999.00,0.00,0.00,1.35,116.10,'2022-06-16 17:15:55','',''),(2448,'1','273','1',1,'Retail Sale Id 2456',740.00,0.00,0.00,1.00,86.00,'2022-06-16 17:23:12','',''),(2449,'1','273','1',1,'Retail Sale Id 2457',1480.00,0.00,0.00,2.00,172.00,'2022-06-16 17:25:13','',''),(2450,'1','273','1',1,'Retail Sale Id 2458',747.40,0.00,0.00,1.01,86.86,'2022-06-16 17:30:02','',''),(2451,'1','273','1',1,'Retail Sale Id 2459',1998.00,0.00,0.00,2.70,232.20,'2022-06-16 17:31:56','',''),(2452,'1','273','1',1,'Retail Sale Id 2460',747.40,0.00,0.00,1.01,86.86,'2022-06-16 17:36:02','',''),(2453,'1','273','1',1,'Retail Sale Id 2461',9250.00,0.00,0.00,12.50,1075.00,'2022-06-16 17:38:19','',''),(2454,'1','273','1',1,'Retail Sale Id 2462',2249.60,0.00,0.00,3.04,261.44,'2022-06-16 17:49:51','',''),(2455,'1','273','1',1,'Retail Sale Id 2463',1998.00,0.00,0.00,2.70,232.20,'2022-06-16 18:02:48','',''),(2456,'1','273','1',1,'Retail Sale Id 2465',2501.20,0.00,0.00,3.38,290.68,'2022-06-16 18:10:08','',''),(2457,'1','273','1',1,'Retail Sale Id 2466',999.00,0.00,0.00,1.35,116.10,'2022-06-16 18:23:25','',''),(2458,'1','273','1',1,'Retail Sale Id 2467',3700.00,0.00,0.00,5.00,430.00,'2022-06-17 07:03:14','',''),(2459,'1','273','1',1,'Retail Sale Id 2468',2997.00,0.00,0.00,4.05,348.30,'2022-06-17 07:04:33','',''),(2460,'1','273','1',1,'Retail Sale Id 2469',1480.00,0.00,0.00,2.00,172.00,'2022-06-17 07:21:18','',''),(2461,'1','273','1',1,'Retail Sale Id 2470',747.40,0.00,0.00,1.01,86.86,'2022-06-17 07:22:23','',''),(2462,'1','273','1',1,'Retail Sale Id 2471',24360.00,0.00,0.00,35.00,1470.00,'2022-06-17 07:27:28','',''),(2463,'1','273','1',1,'Retail Sale Id 2472',4440.00,0.00,0.00,6.00,516.00,'2022-06-17 07:32:48','',''),(2464,'1','273','1',1,'Retail Sale Id 2473',3700.00,0.00,0.00,5.00,430.00,'2022-06-17 07:34:15','',''),(2465,'1','273','1',1,'Retail Sale Id 2473',3700.00,0.00,0.00,5.00,430.00,'2022-06-17 07:34:15','',''),(2466,'1','273','1',1,'Retail Sale Id 2474',7400.00,0.00,0.00,10.00,860.00,'2022-06-17 07:35:47','',''),(2467,'1','273','1',1,'Retail Sale Id 2475',999.00,0.00,0.00,1.35,116.10,'2022-06-17 07:37:20','',''),(2468,'1','273','1',1,'Retail Sale Id 2476',2220.00,0.00,0.00,3.00,258.00,'2022-06-17 07:43:18','',''),(2469,'1','273','1',1,'Retail Sale Id 2478',5180.00,0.00,0.00,7.00,602.00,'2022-06-17 07:44:15','',''),(2470,'1','273','1',1,'Retail Sale Id 2479',3700.00,0.00,0.00,5.00,430.00,'2022-06-17 08:01:17','',''),(2471,'1','273','1',1,'Retail Sale Id 2480',999.00,0.00,0.00,1.35,116.10,'2022-06-17 08:28:33','',''),(2472,'1','273','1',1,'Retail Sale Id 2481',1502.20,0.00,0.00,2.03,174.58,'2022-06-17 08:33:18','',''),(2473,'1','273','1',1,'Retail Sale Id 2482',9250.00,0.00,0.00,12.50,1075.00,'2022-06-17 08:43:55','',''),(2474,'1','273','1',1,'Retail Sale Id 2483',2220.00,0.00,0.00,3.00,258.00,'2022-06-17 09:01:17','',''),(2475,'1','273','1',1,'Retail Sale Id 2484',999.00,0.00,0.00,1.35,116.10,'2022-06-17 09:25:10','',''),(2476,'1','273','1',1,'Retail Sale Id 2485',5180.00,0.00,0.00,7.00,602.00,'2022-06-17 09:33:22','',''),(2477,'1','273','1',1,'Retail Sale Id 2486',9250.00,0.00,0.00,12.50,1075.00,'2022-06-17 09:46:28','',''),(2478,'1','273','1',1,'Retail Sale Id 2487',5180.00,0.00,0.00,7.00,602.00,'2022-06-17 09:47:59','',''),(2479,'1','273','1',1,'Retail Sale Id 2488',104400.00,0.00,0.00,150.00,6300.00,'2022-06-17 09:51:23','',''),(2480,'1','273','1',1,'Return of Retail Sale Id 2486',0.00,9250.00,12.50,0.00,-1075.00,'2022-06-17 09:52:58','',''),(2481,'1','273','1',1,'Retail Sale Id 2489',9250.00,0.00,0.00,12.50,1075.00,'2022-06-17 09:53:59','',''),(2482,'1','273','1',1,'Retail Sale Id 2490',34800.00,0.00,0.00,50.00,2100.00,'2022-06-17 10:22:31','',''),(2483,'1','273','1',1,'Retail Sale Id 2491',999.00,0.00,0.00,1.35,116.10,'2022-06-17 10:26:01','',''),(2484,'1','273','1',1,'Retail Sale Id 2494',2960.00,0.00,0.00,4.00,344.00,'2022-06-17 11:03:50','',''),(2485,'1','273','1',1,'Retail Sale Id 2495',4440.00,0.00,0.00,6.00,516.00,'2022-06-17 11:38:03','',''),(2486,'1','273','1',1,'Retail Sale Id 2496',2249.60,0.00,0.00,3.04,261.44,'2022-06-17 11:41:22','',''),(2487,'1','273','1',1,'Retail Sale Id 2497',4447.40,0.00,0.00,6.01,516.86,'2022-06-17 11:44:52','',''),(2488,'1','273','1',1,'Retail Sale Id 2498',999.00,0.00,0.00,1.35,116.10,'2022-06-17 11:53:00','',''),(2489,'1','273','1',1,'Retail Sale Id 2499',1502.20,0.00,0.00,2.03,174.58,'2022-06-17 11:54:56','',''),(2490,'1','273','1',1,'Retail Sale Id 2500',22272.00,0.00,0.00,32.00,1344.00,'2022-06-17 12:27:50','',''),(2491,'1','273','1',1,'Retail Sale Id 2501',747.40,0.00,0.00,1.01,86.86,'2022-06-17 12:38:32','',''),(2492,'1','273','1',1,'Retail Sale Id 2502',5069.00,0.00,0.00,6.85,589.10,'2022-06-17 12:51:21','',''),(2493,'1','273','1',1,'Return of Retail Sale Id 2502',0.00,5069.00,6.85,0.00,-589.10,'2022-06-17 12:51:57','',''),(2494,'1','273','1',1,'Retail Sale Id 2503',5180.00,0.00,0.00,7.00,602.00,'2022-06-17 12:52:30','',''),(2495,'1','273','1',1,'Retail Sale Id 2504',999.00,0.00,0.00,1.35,116.10,'2022-06-17 13:00:13','',''),(2496,'1','273','1',1,'Retail Sale Id 2505',1502.20,0.00,0.00,2.03,174.58,'2022-06-17 13:26:01','',''),(2497,'1','273','1',1,'Retail Sale Id 2506',1480.00,0.00,0.00,2.00,172.00,'2022-06-17 13:28:41','',''),(2498,'1','273','1',1,'Retail Sale Id 2507',999.00,0.00,0.00,1.35,116.10,'2022-06-17 13:49:18','',''),(2499,'1','273','1',1,'Retail Sale Id 2508',2960.00,0.00,0.00,4.00,344.00,'2022-06-17 14:55:41','',''),(2500,'1','273','1',1,'Retail Sale Id 2509',2220.00,0.00,0.00,3.00,258.00,'2022-06-17 14:57:27','',''),(2501,'1','273','1',1,'Retail Sale Id 2510',1480.00,0.00,0.00,2.00,172.00,'2022-06-17 14:59:25','',''),(2502,'1','273','1',1,'Retail Sale Id 2511',3700.00,0.00,0.00,5.00,430.00,'2022-06-17 15:24:38','',''),(2503,'1','273','1',1,'Retail Sale Id 2512',104400.00,0.00,0.00,150.00,6300.00,'2022-06-17 15:31:18','',''),(2504,'1','273','1',1,'Retail Sale Id 2513',69600.00,0.00,0.00,100.00,4200.00,'2022-06-17 15:32:41','',''),(2505,'1','273','1',1,'Retail Sale Id 2514',747.40,0.00,0.00,1.01,86.86,'2022-06-17 15:42:41','',''),(2506,'1','273','1',1,'Retail Sale Id 2515',4440.00,0.00,0.00,6.00,516.00,'2022-06-17 15:45:43','',''),(2507,'1','273','1',1,'Retail Sale Id 2516',3700.00,0.00,0.00,5.00,430.00,'2022-06-17 16:01:32','',''),(2508,'1','273','1',1,'Retail Sale Id 2517',748.88,0.00,0.00,1.84,-454.48,'2022-06-17 16:03:43','',''),(2509,'1','273','1',1,'Retail Sale Id 2518',5002.40,0.00,0.00,6.76,581.36,'2022-06-17 16:05:21','',''),(2510,'1','273','1',1,'Return of Retail Sale Id 2517',0.00,748.88,1.84,0.00,454.48,'2022-06-17 16:10:13','',''),(2511,'1','273','1',1,'Retail Sale Id 2519',747.40,0.00,0.00,1.01,86.86,'2022-06-17 16:11:16','',''),(2512,'1','273','1',1,'Retail Sale Id 2520',747.40,0.00,0.00,1.01,86.86,'2022-06-17 16:15:48','',''),(2513,'1','273','1',1,'Retail Sale Id 2521',2997.00,0.00,0.00,4.05,348.30,'2022-06-17 16:19:57','',''),(2514,'1','273','1',1,'Retail Sale Id 2522',747.40,0.00,0.00,1.01,86.86,'2022-06-17 16:22:56','',''),(2515,'1','273','1',1,'Retail Sale Id 2523',1998.00,0.00,0.00,2.70,232.20,'2022-06-17 16:34:37','',''),(2516,'1','273','1',1,'Retail Sale Id 2524',2997.00,0.00,0.00,4.05,348.30,'2022-06-17 16:38:00','',''),(2517,'1','273','1',1,'Retail Sale Id 2525',7400.00,0.00,0.00,10.00,860.00,'2022-06-17 16:42:12','',''),(2518,'1','273','1',1,'Retail Sale Id 2526',139896.00,0.00,0.00,201.00,8442.00,'2022-06-17 16:56:09','',''),(2519,'1','273','1',1,'Retail Sale Id 2527',1480.00,0.00,0.00,2.00,172.00,'2022-06-17 17:01:58','',''),(2520,'1','273','1',1,'Retail Sale Id 2528',9250.00,0.00,0.00,12.50,1075.00,'2022-06-17 17:04:59','',''),(2521,'1','273','1',1,'Retail Sale Id 2529',747.40,0.00,0.00,1.01,86.86,'2022-06-17 17:07:05','',''),(2522,'1','273','1',1,'Retail Sale Id 2530',2249.60,0.00,0.00,3.04,261.44,'2022-06-17 17:08:24','',''),(2523,'1','273','1',1,'Retail Sale Id 2531',4440.00,0.00,0.00,6.00,516.00,'2022-06-17 17:09:45','',''),(2524,'1','273','1',1,'Retail Sale Id 2532',1798.20,0.00,0.00,2.43,208.98,'2022-06-17 17:22:25','',''),(2525,'1','273','1',1,'Retail Sale Id 2533',1480.00,0.00,0.00,2.00,172.00,'2022-06-17 17:36:04','',''),(2526,'1','273','1',1,'Retail Sale Id 2534',9250.00,0.00,0.00,12.50,1075.00,'2022-06-17 17:41:31','',''),(2527,'1','273','1',1,'Retail Sale Id 2535',747.40,0.00,0.00,1.01,86.86,'2022-06-17 17:43:03','',''),(2528,'1','273','1',1,'Retail Sale Id 2536',799.20,0.00,0.00,1.08,92.88,'2022-06-17 17:49:42','',''),(2529,'1','273','1',1,'Retail Sale Id 2537',31320.00,0.00,0.00,45.00,1890.00,'2022-06-17 18:02:21','',''),(2530,'1','273','1',1,'Retail Sale Id 2538',3700.00,0.00,0.00,5.00,430.00,'2022-06-17 18:07:28','',''),(2531,'1','273','1',1,'Retail Sale Id 2539',1480.00,0.00,0.00,2.00,172.00,'2022-06-17 18:10:24','',''),(2532,'1','273','1',1,'Retail Sale Id 2540',740.00,0.00,0.00,1.00,86.00,'2022-06-17 18:11:39','',''),(2533,'1','273','1',1,'Retail Sale Id 2541',1480.00,0.00,0.00,2.00,172.00,'2022-06-17 18:15:46','',''),(2534,'1','273','1',1,'Return of Retail Sale Id 2541',0.00,1480.00,2.00,0.00,-172.00,'2022-06-17 18:16:03','',''),(2535,'1','273','1',1,'Retail Sale Id 2542',1480.00,0.00,0.00,2.00,172.00,'2022-06-17 18:16:32','',''),(2536,'1','273','1',1,'Retail Sale Id 2543',2960.00,0.00,0.00,4.00,344.00,'2022-06-18 07:03:52','',''),(2537,'1','273','1',1,'Retail Sale Id 2543',9250.00,0.00,0.00,12.50,1075.00,'2022-06-18 07:03:52','',''),(2538,'1','273','1',1,'Retail Sale Id 2544',80040.00,0.00,0.00,115.00,4830.00,'2022-06-18 07:06:10','',''),(2539,'1','273','1',1,'Retail Sale Id 2545',1998.00,0.00,0.00,2.70,232.20,'2022-06-18 07:07:13','',''),(2540,'1','273','1',1,'Retail Sale Id 2546',6001.40,0.00,0.00,8.11,697.46,'2022-06-18 07:13:25','',''),(2541,'1','273','1',1,'Retail Sale Id 2547',7400.00,0.00,0.00,10.00,860.00,'2022-06-18 07:16:36','',''),(2542,'1','273','1',1,'Retail Sale Id 2548',3700.00,0.00,0.00,5.00,430.00,'2022-06-18 07:20:40','',''),(2543,'1','273','1',1,'Retail Sale Id 2549',139200.00,0.00,0.00,200.00,8400.00,'2022-06-18 07:22:47','',''),(2544,'1','273','1',1,'Retail Sale Id 2550',69600.00,0.00,0.00,100.00,4200.00,'2022-06-18 07:25:28','',''),(2545,'1','273','1',1,'Retail Sale Id 2551',999.00,0.00,0.00,1.35,116.10,'2022-06-18 07:34:18','',''),(2546,'1','273','1',1,'Retail Sale Id 2552',9250.00,0.00,0.00,12.50,1075.00,'2022-06-18 07:38:53','',''),(2547,'1','273','1',1,'Retail Sale Id 2553',2220.00,0.00,0.00,3.00,258.00,'2022-06-18 07:46:26','',''),(2548,'1','273','1',1,'Retail Sale Id 2554',7400.00,0.00,0.00,10.00,860.00,'2022-06-18 07:50:29','',''),(2549,'1','273','1',1,'Retail Sale Id 2555',9250.00,0.00,0.00,12.50,1075.00,'2022-06-18 07:53:40','',''),(2550,'1','273','1',1,'Retail Sale Id 2556',20880.00,0.00,0.00,30.00,1260.00,'2022-06-18 08:05:03','',''),(2551,'1','273','1',1,'Retail Sale Id 2557',8140.00,0.00,0.00,11.00,946.00,'2022-06-18 08:10:33','',''),(2552,'1','273','1',1,'Retail Sale Id 2558',999.00,0.00,0.00,1.35,116.10,'2022-06-18 08:14:53','',''),(2553,'1','273','1',1,'Retail Sale Id 2559',999.00,0.00,0.00,1.35,116.10,'2022-06-18 08:21:28','',''),(2554,'1','273','1',1,'Retail Sale Id 2560',6001.40,0.00,0.00,8.11,697.46,'2022-06-18 08:26:53','',''),(2555,'1','273','1',1,'Retail Sale Id 2562',3700.00,0.00,0.00,5.00,430.00,'2022-06-18 08:50:01','',''),(2556,'1','273','1',1,'Retail Sale Id 2563',1998.00,0.00,0.00,2.70,232.20,'2022-06-18 09:15:26','',''),(2557,'1','273','1',1,'Retail Sale Id 2564',3500.20,0.00,0.00,4.73,406.78,'2022-06-18 09:16:31','',''),(2558,'1','273','1',1,'Retail Sale Id 2565',1480.00,0.00,0.00,2.00,172.00,'2022-06-18 09:19:41','',''),(2559,'1','273','1',1,'Retail Sale Id 2566',7400.00,0.00,0.00,10.00,860.00,'2022-06-18 09:24:19','',''),(2560,'1','273','1',1,'Retail Sale Id 2567',1480.00,0.00,0.00,2.00,172.00,'2022-06-18 09:30:04','',''),(2561,'1','273','1',1,'Retail Sale Id 2568',1480.00,0.00,0.00,2.00,172.00,'2022-06-18 09:33:50','',''),(2562,'1','273','1',1,'Retail Sale Id 2569',2220.00,0.00,0.00,3.00,258.00,'2022-06-18 09:37:16','',''),(2563,'1','273','1',1,'Retail Sale Id 2570',9250.00,0.00,0.00,12.50,1075.00,'2022-06-18 09:46:46','',''),(2564,'1','273','1',1,'Retail Sale Id 2571',2797.20,0.00,0.00,3.78,325.08,'2022-06-18 09:47:29','',''),(2565,'1','273','1',1,'Retail Sale Id 2572',8880.00,0.00,0.00,12.00,1032.00,'2022-06-18 09:48:44','',''),(2566,'1','273','1',1,'Retail Sale Id 2573',90480.00,0.00,0.00,130.00,5460.00,'2022-06-18 09:53:57','',''),(2567,'1','273','1',1,'Retail Sale Id 2574',8140.00,0.00,0.00,11.00,946.00,'2022-06-18 10:01:28','',''),(2568,'1','273','1',1,'Retail Sale Id 2575',9250.00,0.00,0.00,12.50,1075.00,'2022-06-18 10:04:25','',''),(2569,'1','273','1',1,'Retail Sale Id 2576',9250.00,0.00,0.00,12.50,1075.00,'2022-06-18 10:05:12','',''),(2570,'1','273','1',1,'Retail Sale Id 2577',1998.00,0.00,0.00,2.70,232.20,'2022-06-18 10:08:23','',''),(2571,'1','273','1',1,'Retail Sale Id 2578',1502.20,0.00,0.00,2.03,174.58,'2022-06-18 10:33:47','',''),(2572,'1','273','1',1,'Retail Sale Id 2579',22968.00,0.00,0.00,33.00,1386.00,'2022-06-18 10:45:46','',''),(2573,'1','273','1',1,'Retail Sale Id 2580',3700.00,0.00,0.00,5.00,430.00,'2022-06-18 10:46:55','',''),(2574,'1','273','1',1,'Retail Sale Id 2581',1480.00,0.00,0.00,2.00,172.00,'2022-06-18 11:10:17','',''),(2575,'1','273','1',1,'Retail Sale Id 2582',9250.00,0.00,0.00,12.50,1075.00,'2022-06-18 11:19:08','',''),(2576,'1','273','1',1,'Retail Sale Id 2583',18500.00,0.00,0.00,25.00,2150.00,'2022-06-18 11:33:50','',''),(2577,'1','273','1',1,'Retail Sale Id 2584',1998.00,0.00,0.00,2.70,232.20,'2022-06-18 11:41:05','',''),(2578,'1','273','1',1,'Retail Sale Id 2585',2220.00,0.00,0.00,3.00,258.00,'2022-06-18 11:47:12','',''),(2579,'1','273','1',1,'Retail Sale Id 2587',747.40,0.00,0.00,1.01,86.86,'2022-06-18 11:57:36','',''),(2580,'1','273','1',1,'Retail Sale Id 2588',1480.00,0.00,0.00,2.00,172.00,'2022-06-18 11:58:40','',''),(2581,'1','273','1',1,'Retail Sale Id 2589',62640.00,0.00,0.00,90.00,3780.00,'2022-06-18 12:01:12','',''),(2582,'1','273','1',1,'Retail Sale Id 2590',5002.40,0.00,0.00,6.76,581.36,'2022-06-18 12:05:10','',''),(2583,'1','273','1',1,'Retail Sale Id 2591',1998.00,0.00,0.00,2.70,232.20,'2022-06-18 12:08:11','',''),(2584,'1','273','1',1,'Retail Sale Id 2592',1798.20,0.00,0.00,2.43,208.98,'2022-06-18 12:09:49','',''),(2585,'1','273','1',1,'Retail Sale Id 2593',8352.00,0.00,0.00,12.00,504.00,'2022-06-18 12:10:56','',''),(2586,'1','273','1',1,'Retail Sale Id 2594',3700.00,0.00,0.00,5.00,430.00,'2022-06-18 12:12:11','',''),(2587,'1','273','1',1,'Return of Retail Sale Id 2591',0.00,1998.00,2.70,0.00,-232.20,'2022-06-18 12:13:06','',''),(2588,'1','273','1',1,'Retail Sale Id 2595',1480.00,0.00,0.00,2.00,172.00,'2022-06-18 12:18:12','',''),(2589,'1','273','1',1,'Retail Sale Id 2596',125280.00,0.00,0.00,180.00,7560.00,'2022-06-18 12:24:34','',''),(2590,'1','273','1',1,'Retail Sale Id 2597',1480.00,0.00,0.00,2.00,172.00,'2022-06-18 13:40:02','',''),(2591,'1','273',NULL,1,'Distributed to OPERATIONAL LOSE for sales id:4',95484.00,0.00,0.00,146.00,0.00,'2022-06-18 14:50:33','',''),(2592,'1','273','1',1,'Distributed to OPERATIONAL LOSE for sales id:5',95484.00,0.00,0.00,146.00,0.00,'2022-06-18 15:05:51','',''),(2593,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,16350000.00,25000.00,0.00,0.00,'2022-06-18 15:37:18','',''),(2594,'1','273',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,2499.77,0.00,'2022-06-18 15:44:58','',''),(2595,'1','273','1',1,'Received from bridging 10',0.00,0.00,2499.77,0.00,0.00,'2022-06-18 15:44:58','',''),(2596,'1','273',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,22499.00,0.00,'2022-06-18 16:29:05','',''),(2597,'1','273','1',1,'Received from bridging 11',0.00,0.00,22499.00,0.00,0.00,'2022-06-18 16:29:05','',''),(2598,'1','273','1',1,'Retail Sale Id 2598',799.20,0.00,0.00,1.08,92.88,'2022-06-19 07:15:56','',''),(2599,'1','273','1',1,'Retail Sale Id 2599',999.00,0.00,0.00,1.35,116.10,'2022-06-19 07:30:57','',''),(2600,'1','273','1',1,'Retail Sale Id 2600',1998.00,0.00,0.00,2.70,232.20,'2022-06-19 07:32:00','',''),(2601,'1','273','1',1,'Retail Sale Id 2601',1502.20,0.00,0.00,2.03,174.58,'2022-06-19 07:35:07','',''),(2602,'1','273','1',1,'Retail Sale Id 2603',999.00,0.00,0.00,1.35,116.10,'2022-06-19 07:40:06','',''),(2603,'1','273','1',1,'Retail Sale Id 2604',2301.40,0.00,0.00,3.11,267.46,'2022-06-19 07:46:43','',''),(2604,'1','273','1',1,'Retail Sale Id 2605',1998.00,0.00,0.00,2.70,232.20,'2022-06-19 07:55:42','',''),(2605,'1','273','1',1,'Retail Sale Id 2606',2249.60,0.00,0.00,3.04,261.44,'2022-06-19 08:00:06','',''),(2606,'1','273','1',1,'Retail Sale Id 2608',90390.00,0.00,0.00,131.00,4716.00,'2022-06-19 08:07:45','',''),(2607,'1','273','1',1,'Retail Sale Id 2609',2249.60,0.00,0.00,3.04,261.44,'2022-06-19 08:08:45','',''),(2608,'1','273','1',1,'Retail Sale Id 2611',1998.00,0.00,0.00,2.70,232.20,'2022-06-19 08:10:05','',''),(2609,'1','273','1',1,'Retail Sale Id 2612',1998.00,0.00,0.00,2.70,232.20,'2022-06-19 08:13:29','',''),(2610,'1','273','1',1,'Retail Sale Id 2613',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 08:28:38','',''),(2611,'1','273','1',1,'Retail Sale Id 2614',4440.00,0.00,0.00,6.00,516.00,'2022-06-19 08:31:46','',''),(2612,'1','273','1',1,'Retail Sale Id 2615',1480.00,0.00,0.00,2.00,172.00,'2022-06-19 08:35:59','',''),(2613,'1','273','1',1,'Retail Sale Id 2616',1502.20,0.00,0.00,2.03,174.58,'2022-06-19 08:50:25','',''),(2614,'1','273','1',1,'Retail Sale Id 2617',1480.00,0.00,0.00,2.00,172.00,'2022-06-19 08:56:36','',''),(2615,'1','273','1',1,'Retail Sale Id 2618',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 09:19:38','',''),(2616,'1','273','1',1,'Retail Sale Id 2619',1480.00,0.00,0.00,2.00,172.00,'2022-06-19 09:20:26','',''),(2617,'1','273','1',1,'Retail Sale Id 2620',3500.20,0.00,0.00,4.73,406.78,'2022-06-19 09:40:47','',''),(2618,'1','273','1',1,'Retail Sale Id 2621',9620.00,0.00,0.00,13.00,1118.00,'2022-06-19 09:41:30','',''),(2619,'1','273','1',1,'Retail Sale Id 2622',999.00,0.00,0.00,1.35,116.10,'2022-06-19 09:44:51','',''),(2620,'1','273','1',1,'Retail Sale Id 2623',4003.40,0.00,0.00,5.41,465.26,'2022-06-19 10:05:53','',''),(2621,'1','273','1',1,'Retail Sale Id 2624',747.40,0.00,0.00,1.01,86.86,'2022-06-19 10:12:34','',''),(2622,'1','273','1',1,'Retail Sale Id 2625',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 10:21:25','',''),(2623,'1','273','1',1,'Retail Sale Id 2626',2220.00,0.00,0.00,3.00,258.00,'2022-06-19 10:32:53','',''),(2624,'1','273','1',1,'Retail Sale Id 2627',1480.00,0.00,0.00,2.00,172.00,'2022-06-19 10:41:55','',''),(2625,'1','273','1',1,'Retail Sale Id 2628',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 10:43:53','',''),(2626,'1','273','1',1,'Retail Sale Id 2629',999.00,0.00,0.00,1.35,116.10,'2022-06-19 10:44:52','',''),(2627,'1','273','1',1,'Retail Sale Id 2630',9250.00,0.00,0.00,12.50,1075.00,'2022-06-19 10:48:20','',''),(2628,'1','273','1',1,'Retail Sale Id 2631',1702.00,0.00,0.00,2.30,197.80,'2022-06-19 10:54:33','',''),(2629,'1','273','1',1,'Retail Sale Id 2632',999.00,0.00,0.00,1.35,116.10,'2022-06-19 10:55:39','',''),(2630,'1','273','1',1,'Retail Sale Id 2633',999.00,0.00,0.00,1.35,116.10,'2022-06-19 10:59:51','',''),(2631,'1','273','1',1,'Retail Sale Id 2634',34500.00,0.00,0.00,50.00,1800.00,'2022-06-19 11:13:51','',''),(2632,'1','273','1',1,'Retail Sale Id 2635',34500.00,0.00,0.00,50.00,1800.00,'2022-06-19 11:29:21','',''),(2633,'1','273','1',1,'Retail Sale Id 2636',747.40,0.00,0.00,1.01,86.86,'2022-06-19 11:30:32','',''),(2634,'1','273','1',1,'Retail Sale Id 2637',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 11:31:41','',''),(2635,'1','273','1',1,'Retail Sale Id 2638',2960.00,0.00,0.00,4.00,344.00,'2022-06-19 11:35:53','',''),(2636,'1','273','1',1,'Retail Sale Id 2639',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 11:38:41','',''),(2637,'1','273','1',1,'Retail Sale Id 2640',1502.20,0.00,0.00,2.03,174.58,'2022-06-19 11:48:28','',''),(2638,'1','273','1',1,'Retail Sale Id 2642',2501.20,0.00,0.00,3.38,290.68,'2022-06-19 11:56:52','',''),(2639,'1','273','1',1,'Retail Sale Id 2643',9250.00,0.00,0.00,12.50,1075.00,'2022-06-19 12:01:25','',''),(2640,'1','273','1',1,'Retail Sale Id 2644',9250.00,0.00,0.00,12.50,1075.00,'2022-06-19 12:02:54','',''),(2641,'1','273','1',1,'Retail Sale Id 2645',18500.00,0.00,0.00,25.00,2150.00,'2022-06-19 12:04:27','',''),(2642,'1','273','1',1,'Retail Sale Id 2646',2997.00,0.00,0.00,4.05,348.30,'2022-06-19 12:18:11','',''),(2643,'1','273','1',1,'Retail Sale Id 2647',6896.80,0.00,0.00,9.32,801.52,'2022-06-19 12:20:56','',''),(2644,'1','273','1',1,'Retail Sale Id 2648',2997.00,0.00,0.00,4.05,348.30,'2022-06-19 12:25:23','',''),(2645,'1','273','1',1,'Retail Sale Id 2649',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 12:28:00','',''),(2646,'1','273','1',1,'Retail Sale Id 2650',747.40,0.00,0.00,1.01,86.86,'2022-06-19 12:38:59','',''),(2647,'1','273','1',1,'Retail Sale Id 2651',4440.00,0.00,0.00,6.00,516.00,'2022-06-19 12:42:49','',''),(2648,'1','273','1',1,'Retail Sale Id 2652',2997.00,0.00,0.00,4.05,348.30,'2022-06-19 12:43:42','',''),(2649,'1','273','1',1,'Retail Sale Id 2653',1998.00,0.00,0.00,2.70,232.20,'2022-06-19 12:44:30','',''),(2650,'1','273','1',1,'Retail Sale Id 2655',8140.00,0.00,0.00,11.00,946.00,'2022-06-19 12:53:06','',''),(2651,'1','273','1',1,'Retail Sale Id 2656',2249.60,0.00,0.00,3.04,261.44,'2022-06-19 12:53:54','',''),(2652,'1','273','1',1,'Retail Sale Id 2658',2967.40,0.00,0.00,4.01,344.86,'2022-06-19 13:03:18','',''),(2653,'1','273','1',1,'Retail Sale Id 2659',5180.00,0.00,0.00,7.00,602.00,'2022-06-19 13:07:24','',''),(2654,'1','273','1',1,'Retail Sale Id 2660',2997.00,0.00,0.00,4.05,348.30,'2022-06-19 13:08:20','',''),(2655,'1','273','1',1,'Retail Sale Id 2661',7999.40,0.00,0.00,10.81,929.66,'2022-06-19 13:12:36','',''),(2656,'1','273','1',1,'Retail Sale Id 2662',34500.00,0.00,0.00,50.00,1800.00,'2022-06-19 13:18:49','',''),(2657,'1','273','1',1,'Retail Sale Id 2663',1502.20,0.00,0.00,2.03,174.58,'2022-06-19 13:20:03','',''),(2658,'1','273','1',1,'Retail Sale Id 2664',1502.20,0.00,0.00,2.03,174.58,'2022-06-19 13:30:13','',''),(2659,'1','273','1',1,'Retail Sale Id 2665',5202.20,0.00,0.00,7.03,604.58,'2022-06-19 13:31:52','',''),(2660,'1','273','1',1,'Retail Sale Id 2666',1502.20,0.00,0.00,2.03,174.58,'2022-06-19 13:35:17','',''),(2661,'1','273','1',1,'Retail Sale Id 2667',113850.00,0.00,0.00,165.00,5940.00,'2022-06-19 13:42:40','',''),(2662,'1','273','1',1,'Retail Sale Id 2669',251.60,0.00,0.00,0.34,29.24,'2022-06-19 13:47:34','',''),(2663,'1','273','1',1,'Retail Sale Id 2670',2997.00,0.00,0.00,4.05,348.30,'2022-06-19 14:08:31','',''),(2664,'1','273','1',1,'Retail Sale Id 2671',4440.00,0.00,0.00,6.00,516.00,'2022-06-19 14:11:15','',''),(2665,'1','273','1',1,'Retail Sale Id 2672',1998.00,0.00,0.00,2.70,232.20,'2022-06-19 14:12:49','',''),(2666,'1','273','1',1,'Retail Sale Id 2673',2220.00,0.00,0.00,3.00,258.00,'2022-06-19 14:14:59','',''),(2667,'1','273','1',1,'Retail Sale Id 2674',9250.00,0.00,0.00,12.50,1075.00,'2022-06-19 14:18:44','',''),(2668,'1','273','1',1,'Retail Sale Id 2675',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 14:21:36','',''),(2669,'1','273','1',1,'Retail Sale Id 2675',6660.00,0.00,0.00,9.00,774.00,'2022-06-19 14:21:36','',''),(2670,'1','273','1',1,'Retail Sale Id 2676',5002.40,0.00,0.00,6.76,581.36,'2022-06-19 14:27:08','',''),(2671,'1','273','1',1,'Retail Sale Id 2677',2220.00,0.00,0.00,3.00,258.00,'2022-06-19 14:28:38','',''),(2672,'1','273','1',1,'Return of Retail Sale Id 2676',0.00,5002.40,6.76,0.00,-581.36,'2022-06-19 14:30:27','',''),(2673,'1','273','1',1,'Retail Sale Id 2678',2249.60,0.00,0.00,3.04,261.44,'2022-06-19 14:31:58','',''),(2674,'1','273','1',1,'Retail Sale Id 2679',4440.00,0.00,0.00,6.00,516.00,'2022-06-19 14:37:47','',''),(2675,'1','273','1',1,'Retail Sale Id 2680',34500.00,0.00,0.00,50.00,1800.00,'2022-06-19 14:42:09','',''),(2676,'1','273','1',1,'Retail Sale Id 2681',34500.00,0.00,0.00,50.00,1800.00,'2022-06-19 14:42:44','',''),(2677,'1','273','1',1,'Retail Sale Id 2682',9250.00,0.00,0.00,12.50,1075.00,'2022-06-19 14:45:24','',''),(2678,'1','273','1',1,'Retail Sale Id 2683',999.00,0.00,0.00,1.35,116.10,'2022-06-19 14:48:31','',''),(2679,'1','273','1',1,'Retail Sale Id 2684',27600.00,0.00,0.00,40.00,1440.00,'2022-06-19 14:51:18','',''),(2680,'1','273','1',1,'Retail Sale Id 2685',70725.00,0.00,0.00,102.50,3690.00,'2022-06-19 14:53:39','',''),(2681,'1','273','1',1,'Retail Sale Id 2686',9620.00,0.00,0.00,13.00,1118.00,'2022-06-19 14:55:37','',''),(2682,'1','273','1',1,'Retail Sale Id 2687',69000.00,0.00,0.00,100.00,3600.00,'2022-06-19 15:00:44','',''),(2683,'1','273','1',1,'Retail Sale Id 2688',999.00,0.00,0.00,1.35,116.10,'2022-06-19 15:03:10','',''),(2684,'1','273','1',1,'Retail Sale Id 2689',740.00,0.00,0.00,1.00,86.00,'2022-06-19 15:03:40','',''),(2685,'1','273','1',1,'Retail Sale Id 2690',2501.20,0.00,0.00,3.38,290.68,'2022-06-19 15:07:19','',''),(2686,'1','273','1',1,'Retail Sale Id 2691',1502.20,0.00,0.00,2.03,174.58,'2022-06-19 15:19:18','',''),(2687,'1','273','1',1,'Retail Sale Id 2692',1998.00,0.00,0.00,2.70,232.20,'2022-06-19 15:29:26','',''),(2688,'1','273','1',1,'Retail Sale Id 2693',2501.20,0.00,0.00,3.38,290.68,'2022-06-19 15:32:39','',''),(2689,'1','273','1',1,'Retail Sale Id 2695',4499.20,0.00,0.00,6.08,522.88,'2022-06-19 15:40:40','',''),(2690,'1','273','1',1,'Retail Sale Id 2696',9250.00,0.00,0.00,12.50,1075.00,'2022-06-19 15:57:23','',''),(2691,'1','273','1',1,'Retail Sale Id 2697',1480.00,0.00,0.00,2.00,172.00,'2022-06-19 15:58:24','',''),(2692,'1','273','1',1,'Retail Sale Id 2698',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 16:00:01','',''),(2693,'1','273','1',1,'Retail Sale Id 2699',6001.40,0.00,0.00,8.11,697.46,'2022-06-19 16:06:28','',''),(2694,'1','273','1',1,'Retail Sale Id 2700',747.40,0.00,0.00,1.01,86.86,'2022-06-19 16:09:47','',''),(2695,'1','273','1',1,'Retail Sale Id 2701',999.00,0.00,0.00,1.35,116.10,'2022-06-19 16:11:58','',''),(2696,'1','273','1',1,'Retail Sale Id 2702',747.40,0.00,0.00,1.01,86.86,'2022-06-19 16:13:20','',''),(2697,'1','273','1',1,'Retail Sale Id 2703',1480.00,0.00,0.00,2.00,172.00,'2022-06-19 16:21:44','',''),(2698,'1','273','1',1,'Retail Sale Id 2704',999.00,0.00,0.00,1.35,116.10,'2022-06-19 16:22:39','',''),(2699,'1','273','1',1,'Retail Sale Id 2705',7400.00,0.00,0.00,10.00,860.00,'2022-06-19 16:34:18','',''),(2700,'1','273','1',1,'Retail Sale Id 2706',1998.00,0.00,0.00,2.70,232.20,'2022-06-19 16:35:09','',''),(2701,'1','273','1',1,'Retail Sale Id 2707',1998.00,0.00,0.00,2.70,232.20,'2022-06-19 16:35:47','',''),(2702,'1','273','1',1,'Retail Sale Id 2708',999.00,0.00,0.00,1.35,116.10,'2022-06-19 16:38:50','',''),(2703,'1','273','1',1,'Return of Retail Sale Id 2707',0.00,1998.00,2.70,0.00,-232.20,'2022-06-19 16:39:20','',''),(2704,'1','273','1',1,'Retail Sale Id 2709',2997.00,0.00,0.00,4.05,348.30,'2022-06-19 16:47:08','',''),(2705,'1','273','1',1,'Retail Sale Id 2710',1398.60,0.00,0.00,1.89,162.54,'2022-06-19 16:52:37','',''),(2706,'1','273','1',1,'Retail Sale Id 2712',2220.00,0.00,0.00,3.00,258.00,'2022-06-19 16:57:21','',''),(2707,'1','273','1',1,'Retail Sale Id 2713',5920.00,0.00,0.00,8.00,688.00,'2022-06-19 16:59:17','',''),(2708,'1','273','1',1,'Retail Sale Id 2714',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 17:06:30','',''),(2709,'1','273','1',1,'Retail Sale Id 2715',25875.00,0.00,0.00,37.50,1350.00,'2022-06-19 17:08:34','',''),(2710,'1','273','1',1,'Retail Sale Id 2716',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 17:10:19','',''),(2711,'1','273','1',1,'Retail Sale Id 2717',1502.20,0.00,0.00,2.03,174.58,'2022-06-19 17:14:51','',''),(2712,'1','273','1',1,'Retail Sale Id 2718',1502.20,0.00,0.00,2.03,174.58,'2022-06-19 17:17:00','',''),(2713,'1','273','1',1,'Retail Sale Id 2719',1480.00,0.00,0.00,2.00,172.00,'2022-06-19 17:25:41','',''),(2714,'1','273','1',1,'Retail Sale Id 2720',3700.00,0.00,0.00,5.00,430.00,'2022-06-19 17:42:09','',''),(2715,'1','273','1',1,'Retail Sale Id 2720',9250.00,0.00,0.00,12.50,1075.00,'2022-06-19 17:42:09','',''),(2716,'1','273','1',1,'Retail Sale Id 2721',9250.00,0.00,0.00,12.50,1075.00,'2022-06-19 17:53:34','',''),(2717,'1','273','1',1,'Retail Sale Id 2722',1502.20,0.00,0.00,2.03,174.58,'2022-06-19 17:55:47','',''),(2718,'1','273','1',1,'Retail Sale Id 2723',2220.00,0.00,0.00,3.00,258.00,'2022-06-19 18:09:47','',''),(2719,'1','273','1',1,'Retail Sale Id 2724',34500.00,0.00,0.00,50.00,1800.00,'2022-06-19 18:13:14','',''),(2720,'1','273','1',1,'Retail Sale Id 2725',40020.00,0.00,0.00,58.00,2088.00,'2022-06-19 18:14:00','',''),(2721,'1','273','1',1,'Retail Sale Id 2726',1998.00,0.00,0.00,2.70,232.20,'2022-06-19 18:20:40','',''),(2722,'1','273','1',1,'Retail Sale Id 2727',2501.20,0.00,0.00,3.38,290.68,'2022-06-19 18:26:50','',''),(2723,'1','273','1',1,'Retail Sale Id 2728',999.00,0.00,0.00,1.35,116.10,'2022-06-19 18:27:46','',''),(2724,'1','273','1',1,'Retail Sale Id 2729',324300.00,0.00,0.00,470.00,16920.00,'2022-06-20 07:42:53','',''),(2725,'1','273','1',1,'Retail Sale Id 2730',13110.00,0.00,0.00,19.00,684.00,'2022-06-20 07:44:00','',''),(2726,'1','273','1',1,'Retail Sale Id 2731',83490.00,0.00,0.00,121.00,4356.00,'2022-06-20 07:44:48','',''),(2727,'1','273','1',1,'Retail Sale Id 2732',103500.00,0.00,0.00,150.00,5400.00,'2022-06-20 07:46:45','',''),(2728,'1','273','1',1,'Retail Sale Id 2733',85905.00,0.00,0.00,124.50,4482.00,'2022-06-20 07:47:37','',''),(2729,'1','273','1',1,'Retail Sale Id 2734',9250.00,0.00,0.00,12.50,1075.00,'2022-06-20 07:48:52','',''),(2730,'1','273','1',1,'Retail Sale Id 2735',6800.60,0.00,0.00,9.19,790.34,'2022-06-20 07:50:57','',''),(2731,'1','273','1',1,'Retail Sale Id 2736',9250.00,0.00,0.00,12.50,1075.00,'2022-06-20 07:51:36','',''),(2732,'1','273','1',1,'Retail Sale Id 2738',799.20,0.00,0.00,1.08,92.88,'2022-06-20 08:06:49','',''),(2733,'1','273','1',1,'Retail Sale Id 2739',2249.60,0.00,0.00,3.04,261.44,'2022-06-20 08:12:03','',''),(2734,'1','273','1',1,'Retail Sale Id 2740',2960.00,0.00,0.00,4.00,344.00,'2022-06-20 08:22:46','',''),(2735,'1','273','1',1,'Retail Sale Id 2741',4440.00,0.00,0.00,6.00,516.00,'2022-06-20 08:24:23','',''),(2736,'1','273','1',1,'Retail Sale Id 2742',9250.00,0.00,0.00,12.50,1075.00,'2022-06-20 08:33:51','',''),(2737,'1','273','1',1,'Retail Sale Id 2743',2997.00,0.00,0.00,4.05,348.30,'2022-06-20 08:36:34','',''),(2738,'1','273','1',1,'Retail Sale Id 2744',3500.20,0.00,0.00,4.73,406.78,'2022-06-20 08:40:22','',''),(2739,'1','273','1',1,'Retail Sale Id 2745',1502.20,0.00,0.00,2.03,174.58,'2022-06-20 08:41:33','',''),(2740,'1','273','1',1,'Retail Sale Id 2746',103500.00,0.00,0.00,150.00,5400.00,'2022-06-20 08:44:31','',''),(2741,'1','273','1',1,'Retail Sale Id 2747',740.00,0.00,0.00,1.00,86.00,'2022-06-20 08:45:48','',''),(2742,'1','273','1',1,'Retail Sale Id 2748',103500.00,0.00,0.00,150.00,5400.00,'2022-06-20 08:48:40','',''),(2743,'1','273','1',1,'Retail Sale Id 2749',18500.00,0.00,0.00,25.00,2150.00,'2022-06-20 08:59:20','',''),(2744,'1','273','1',1,'Retail Sale Id 2750',2220.00,0.00,0.00,3.00,258.00,'2022-06-20 09:09:48','',''),(2745,'1','273','1',1,'Retail Sale Id 2751',7400.00,0.00,0.00,10.00,860.00,'2022-06-20 09:16:33','',''),(2746,'1','273','1',1,'Retail Sale Id 2752',747.40,0.00,0.00,1.01,86.86,'2022-06-20 09:25:05','',''),(2747,'1','273','1',1,'Retail Sale Id 2753',999.00,0.00,0.00,1.35,116.10,'2022-06-20 09:27:49','',''),(2748,'1','273','1',1,'Retail Sale Id 2754',69000.00,0.00,0.00,100.00,3600.00,'2022-06-20 09:34:30','',''),(2749,'1','273','1',1,'Retail Sale Id 2755',3500.20,0.00,0.00,4.73,406.78,'2022-06-20 09:36:19','',''),(2750,'1','273','1',1,'Retail Sale Id 2756',129720.00,0.00,0.00,188.00,6768.00,'2022-06-20 09:38:10','',''),(2751,'1','273','1',1,'Retail Sale Id 2757',2220.00,0.00,0.00,3.00,258.00,'2022-06-20 09:54:42','',''),(2752,'1','273','1',1,'Retail Sale Id 2758',82800.00,0.00,0.00,120.00,4320.00,'2022-06-20 10:14:05','',''),(2753,'1','273','1',1,'Retail Sale Id 2759',82800.00,0.00,0.00,120.00,4320.00,'2022-06-20 10:15:20','',''),(2754,'1','273','1',1,'Retail Sale Id 2760',1480.00,0.00,0.00,2.00,172.00,'2022-06-20 10:22:03','',''),(2755,'1','273','1',1,'Retail Sale Id 2761',241500.00,0.00,0.00,350.00,12600.00,'2022-06-20 10:31:38','',''),(2756,'1','273','1',1,'Retail Sale Id 2762',9250.00,0.00,0.00,12.50,1075.00,'2022-06-20 10:32:40','',''),(2757,'1','273','1',1,'Retail Sale Id 2763',241500.00,0.00,0.00,350.00,12600.00,'2022-06-20 10:34:11','',''),(2758,'1','273','1',1,'Retail Sale Id 2764',9250.00,0.00,0.00,12.50,1075.00,'2022-06-20 10:35:01','',''),(2759,'1','273','1',1,'Retail Sale Id 2766',40020.00,0.00,0.00,58.00,2088.00,'2022-06-20 10:36:48','',''),(2760,'1','273','1',1,'Retail Sale Id 2767',2249.60,0.00,0.00,3.04,261.44,'2022-06-20 10:37:52','',''),(2761,'1','273','1',1,'Retail Sale Id 2768',138000.00,0.00,0.00,200.00,7200.00,'2022-06-20 10:46:05','',''),(2762,'1','273','1',1,'Retail Sale Id 2769',121440.00,0.00,0.00,176.00,6336.00,'2022-06-20 10:47:27','',''),(2763,'1','273','1',1,'Retail Sale Id 2770',2701.00,0.00,0.00,3.65,313.90,'2022-06-20 10:50:55','',''),(2764,'1','273','1',1,'Retail Sale Id 2771',37950.00,0.00,0.00,55.00,1980.00,'2022-06-20 10:52:51','',''),(2765,'1','273','1',1,'Retail Sale Id 2772',34500.00,0.00,0.00,50.00,1800.00,'2022-06-20 10:59:36','',''),(2766,'1','273','1',1,'Retail Sale Id 2773',2220.00,0.00,0.00,3.00,258.00,'2022-06-20 11:08:14','',''),(2767,'1','273','1',1,'Retail Sale Id 2774',25530.00,0.00,0.00,37.00,1332.00,'2022-06-20 11:09:54','',''),(2768,'1','273','1',1,'Retail Sale Id 2775',9250.00,0.00,0.00,12.50,1075.00,'2022-06-20 11:13:37','',''),(2769,'1','273','1',1,'Retail Sale Id 2777',26910.00,0.00,0.00,39.00,1404.00,'2022-06-20 11:16:33','',''),(2770,'1','273','1',1,'Retail Sale Id 2778',8140.00,0.00,0.00,11.00,946.00,'2022-06-20 11:22:59','',''),(2771,'1','273','1',1,'Retail Sale Id 2779',747.40,0.00,0.00,1.01,86.86,'2022-06-20 11:25:07','',''),(2772,'1','273','1',1,'Retail Sale Id 2781',2997.00,0.00,0.00,4.05,348.30,'2022-06-20 14:01:49','',''),(2773,'1','273','1',1,'Retail Sale Id 2783',4440.00,0.00,0.00,6.00,516.00,'2022-06-20 14:02:44','',''),(2774,'1','273','1',1,'Retail Sale Id 2784',69000.00,0.00,0.00,100.00,3600.00,'2022-06-20 14:15:21','',''),(2775,'1','273','1',1,'Retail Sale Id 2785',69000.00,0.00,0.00,100.00,3600.00,'2022-06-20 14:19:51','',''),(2776,'1','273','1',1,'Retail Sale Id 2786',4499.20,0.00,0.00,6.08,522.88,'2022-06-20 14:28:03','',''),(2777,'1','273','1',1,'Retail Sale Id 2787',1502.20,0.00,0.00,2.03,174.58,'2022-06-20 14:44:18','',''),(2778,'1','273','1',1,'Retail Sale Id 2788',1480.00,0.00,0.00,2.00,172.00,'2022-06-20 15:09:19','',''),(2779,'1','273','1',1,'Retail Sale Id 2789',747.40,0.00,0.00,1.01,86.86,'2022-06-20 15:17:25','',''),(2780,'1','273','1',1,'Retail Sale Id 2790',1480.00,0.00,0.00,2.00,172.00,'2022-06-20 15:18:16','',''),(2781,'1','273','1',1,'Retail Sale Id 2791',1480.00,0.00,0.00,2.00,172.00,'2022-06-20 15:22:43','',''),(2782,'1','273','1',1,'Retail Sale Id 2792',1502.20,0.00,0.00,2.03,174.58,'2022-06-20 15:25:21','',''),(2783,'1','273','1',1,'Retail Sale Id 2793',740.00,0.00,0.00,1.00,86.00,'2022-06-20 15:35:21','',''),(2784,'1','273','1',1,'Retail Sale Id 2794',5002.40,0.00,0.00,6.76,581.36,'2022-06-20 15:35:50','',''),(2785,'1','273','1',1,'Retail Sale Id 2795',9250.00,0.00,0.00,12.50,1075.00,'2022-06-20 15:54:23','',''),(2786,'1','273','1',1,'Retail Sale Id 2796',3700.00,0.00,0.00,5.00,430.00,'2022-06-20 16:13:34','',''),(2787,'1','273','1',1,'Retail Sale Id 2797',2220.00,0.00,0.00,3.00,258.00,'2022-06-20 16:15:06','',''),(2788,'1','273','1',1,'Retail Sale Id 2798',1998.00,0.00,0.00,2.70,232.20,'2022-06-20 16:20:04','',''),(2789,'1','273','1',1,'Retail Sale Id 2799',1480.00,0.00,0.00,2.00,172.00,'2022-06-20 16:23:23','',''),(2790,'1','273','1',1,'Retail Sale Id 2800',2220.00,0.00,0.00,3.00,258.00,'2022-06-20 16:25:57','',''),(2791,'1','273','1',1,'Retail Sale Id 2801',34500.00,0.00,0.00,50.00,1800.00,'2022-06-20 16:34:01','',''),(2792,'1','273','1',1,'Retail Sale Id 2802',18500.00,0.00,0.00,25.00,2150.00,'2022-06-20 16:38:09','',''),(2793,'1','273','1',1,'Retail Sale Id 2804',24150.00,0.00,0.00,35.00,1260.00,'2022-06-20 16:40:16','',''),(2794,'1','273','1',1,'Retail Sale Id 2805',9250.00,0.00,0.00,12.50,1075.00,'2022-06-20 16:41:10','',''),(2795,'1','273','1',1,'Retail Sale Id 2806',3700.00,0.00,0.00,5.00,430.00,'2022-06-20 16:42:34','',''),(2796,'1','273','1',1,'Retail Sale Id 2809',2960.00,0.00,0.00,4.00,344.00,'2022-06-20 16:44:55','',''),(2797,'1','273','1',1,'Retail Sale Id 2810',1998.00,0.00,0.00,2.70,232.20,'2022-06-20 16:48:02','',''),(2798,'1','273','1',1,'Retail Sale Id 2811',799.20,0.00,0.00,1.08,92.88,'2022-06-20 16:58:57','',''),(2799,'1','273','1',1,'Retail Sale Id 2812',2220.00,0.00,0.00,3.00,258.00,'2022-06-20 17:08:29','',''),(2800,'1','273','1',1,'Retail Sale Id 2813',4003.40,0.00,0.00,5.41,465.26,'2022-06-20 17:13:48','',''),(2801,'1','273','1',1,'Retail Sale Id 2814',11100.00,0.00,0.00,15.00,1290.00,'2022-06-20 17:16:23','',''),(2802,'1','273','1',1,'Retail Sale Id 2815',4440.00,0.00,0.00,6.00,516.00,'2022-06-20 17:20:44','',''),(2803,'1','273','1',1,'Retail Sale Id 2816',999.00,0.00,0.00,1.35,116.10,'2022-06-20 17:36:10','',''),(2804,'1','273','1',1,'Retail Sale Id 2817',1480.00,0.00,0.00,2.00,172.00,'2022-06-20 17:37:27','',''),(2805,'1','273','1',1,'Retail Sale Id 2818',7400.00,0.00,0.00,10.00,860.00,'2022-06-20 17:41:59','',''),(2806,'1','273','1',1,'Retail Sale Id 2819',1480.00,0.00,0.00,2.00,172.00,'2022-06-20 17:43:23','',''),(2807,'1','273','1',1,'Retail Sale Id 2820',4440.00,0.00,0.00,6.00,516.00,'2022-06-20 17:46:12','',''),(2808,'1','273','1',1,'Retail Sale Id 2821',999.00,0.00,0.00,1.35,116.10,'2022-06-20 17:51:11','',''),(2809,'1','273','1',1,'Retail Sale Id 2822',2220.00,0.00,0.00,3.00,258.00,'2022-06-20 18:04:23','',''),(2810,'1','273','1',1,'Retail Sale Id 2823',1480.00,0.00,0.00,2.00,172.00,'2022-06-20 18:09:13','',''),(2811,'1','273','1',1,'Retail Sale Id 2824',740.00,0.00,0.00,1.00,86.00,'2022-06-20 18:11:02','',''),(2812,'1','273','1',1,'Retail Sale Id 2825',1502.20,0.00,0.00,2.03,174.58,'2022-06-20 18:11:50','',''),(2813,'1','273','1',1,'Return of Retail Sale Id 2824',0.00,740.00,1.00,0.00,-86.00,'2022-06-20 18:13:51','',''),(2814,'1','273','1',1,'Retail Sale Id 2826',799.20,0.00,0.00,1.08,92.88,'2022-06-21 06:49:36','',''),(2815,'1','273','1',1,'Retail Sale Id 2827',1502.20,0.00,0.00,2.03,174.58,'2022-06-21 06:52:41','',''),(2816,'1','273','1',1,'Retail Sale Id 2828',6001.40,0.00,0.00,8.11,697.46,'2022-06-21 07:00:55','',''),(2817,'1','273','1',1,'Retail Sale Id 2829',19320.00,0.00,0.00,28.00,1008.00,'2022-06-21 07:07:39','',''),(2818,'1','273','1',1,'Retail Sale Id 2830',3700.00,0.00,0.00,5.00,430.00,'2022-06-21 07:11:54','',''),(2819,'1','273','1',1,'Retail Sale Id 2831',9250.00,0.00,0.00,12.50,1075.00,'2022-06-21 07:28:22','',''),(2820,'1','273','1',1,'Retail Sale Id 2832',2997.00,0.00,0.00,4.05,348.30,'2022-06-21 07:38:23','',''),(2821,'1','273','1',1,'Retail Sale Id 2833',1480.00,0.00,0.00,2.00,172.00,'2022-06-21 07:43:44','',''),(2822,'1','273','1',1,'Retail Sale Id 2834',1502.20,0.00,0.00,2.03,174.58,'2022-06-21 07:46:09','',''),(2823,'1','273','1',1,'Retail Sale Id 2835',1302.40,0.00,0.00,1.76,151.36,'2022-06-21 07:54:28','',''),(2824,'1','273','1',1,'Retail Sale Id 2836',2249.60,0.00,0.00,3.04,261.44,'2022-06-21 08:06:17','',''),(2825,'1','273','1',1,'Retail Sale Id 2837',34500.00,0.00,0.00,50.00,1800.00,'2022-06-21 08:08:42','',''),(2826,'1','273','1',1,'Retail Sale Id 2838',2220.00,0.00,0.00,3.00,258.00,'2022-06-21 08:21:29','',''),(2827,'1','273','1',1,'Retail Sale Id 2839',1998.00,0.00,0.00,2.70,232.20,'2022-06-21 08:22:01','',''),(2828,'1','273','1',1,'Retail Sale Id 2840',11100.00,0.00,0.00,15.00,1290.00,'2022-06-21 08:28:05','',''),(2829,'1','273','1',1,'Retail Sale Id 2841',9250.00,0.00,0.00,12.50,1075.00,'2022-06-21 08:37:37','',''),(2830,'1','273','1',1,'Retail Sale Id 2842',2997.00,0.00,0.00,4.05,348.30,'2022-06-21 08:44:01','',''),(2831,'1','273','1',1,'Retail Sale Id 2843',86250.00,0.00,0.00,125.00,4500.00,'2022-06-21 08:47:02','',''),(2832,'1','273','1',1,'Retail Sale Id 2844',86250.00,0.00,0.00,125.00,4500.00,'2022-06-21 08:48:10','',''),(2833,'1','273','1',1,'Retail Sale Id 2845',1449.00,0.00,0.00,2.10,75.60,'2022-06-21 08:58:34','',''),(2834,'1','273','1',1,'Retail Sale Id 2846',2197.80,0.00,0.00,2.97,255.42,'2022-06-21 09:00:19','',''),(2835,'1','273','1',1,'Retail Sale Id 2847',2220.00,0.00,0.00,3.00,258.00,'2022-06-21 09:13:05','',''),(2836,'1','273','1',1,'Retail Sale Id 2848',3700.00,0.00,0.00,5.00,430.00,'2022-06-21 09:30:34','',''),(2837,'1','273','1',1,'Retail Sale Id 2849',103500.00,0.00,0.00,150.00,5400.00,'2022-06-21 09:36:12','',''),(2838,'1','273','1',1,'Retail Sale Id 2850',747.40,0.00,0.00,1.01,86.86,'2022-06-21 09:46:58','',''),(2839,'1','273','1',1,'Retail Sale Id 2851',1502.20,0.00,0.00,2.03,174.58,'2022-06-21 10:05:45','',''),(2840,'1','273','1',1,'Retail Sale Id 2852',69000.00,0.00,0.00,100.00,3600.00,'2022-06-21 10:10:13','',''),(2841,'1','273','1',1,'Retail Sale Id 2853',5202.20,0.00,0.00,7.03,604.58,'2022-06-21 10:35:04','',''),(2842,'1','273','1',1,'Retail Sale Id 2854',34500.00,0.00,0.00,50.00,1800.00,'2022-06-21 10:41:36','',''),(2843,'1','273','1',1,'Retail Sale Id 2855',98325.00,0.00,0.00,142.50,5130.00,'2022-06-21 10:43:11','',''),(2844,'1','273','1',1,'Retail Sale Id 2856',4440.00,0.00,0.00,6.00,516.00,'2022-06-21 10:51:54','',''),(2845,'1','273','1',1,'Retail Sale Id 2857',740.00,0.00,0.00,1.00,86.00,'2022-06-21 11:19:35','',''),(2846,'1','273','1',1,'Retail Sale Id 2858',9250.00,0.00,0.00,12.50,1075.00,'2022-06-21 11:21:51','',''),(2847,'1','273','1',1,'Retail Sale Id 2859',1480.00,0.00,0.00,2.00,172.00,'2022-06-21 11:32:34','',''),(2848,'1','273','1',1,'Retail Sale Id 2860',9250.00,0.00,0.00,12.50,1075.00,'2022-06-21 12:05:34','',''),(2849,'1','273','1',1,'Retail Sale Id 2861',138000.00,0.00,0.00,200.00,7200.00,'2022-06-21 12:10:10','',''),(2850,'1','273','1',1,'Retail Sale Id 2862',138000.00,0.00,0.00,200.00,7200.00,'2022-06-21 12:11:18','',''),(2851,'1','273','1',1,'Retail Sale Id 2863',2249.60,0.00,0.00,3.04,261.44,'2022-06-21 12:17:33','',''),(2852,'1','273','1',1,'Retail Sale Id 2864',3700.00,0.00,0.00,5.00,430.00,'2022-06-21 12:21:59','',''),(2853,'1','273','1',1,'Retail Sale Id 2865',69000.00,0.00,0.00,100.00,3600.00,'2022-06-21 12:39:02','',''),(2854,'1','273','1',1,'Retail Sale Id 2866',69000.00,0.00,0.00,100.00,3600.00,'2022-06-21 12:40:12','',''),(2855,'1','273','1',1,'Retail Sale Id 2867',3700.00,0.00,0.00,5.00,430.00,'2022-06-21 13:26:16','',''),(2856,'1','273','1',1,'Retail Sale Id 2868',103500.00,0.00,0.00,150.00,5400.00,'2022-06-21 13:31:50','',''),(2857,'1','273','1',1,'Retail Sale Id 2869',103500.00,0.00,0.00,150.00,5400.00,'2022-06-21 13:32:59','',''),(2858,'1','273','1',1,'Retail Sale Id 2870',9250.00,0.00,0.00,12.50,1075.00,'2022-06-21 13:36:57','',''),(2859,'1','273','1',1,'Retail Sale Id 2871',9250.00,0.00,0.00,12.50,1075.00,'2022-06-21 13:39:29','',''),(2860,'1','273','1',1,'Retail Sale Id 2872',51060.00,0.00,0.00,74.00,2664.00,'2022-06-21 13:43:51','',''),(2861,'1','273','1',1,'Retail Sale Id 2873',740.00,0.00,0.00,1.00,86.00,'2022-06-21 14:04:26','',''),(2862,'1','273','1',1,'Retail Sale Id 2874',2997.00,0.00,0.00,4.05,348.30,'2022-06-21 14:29:41','',''),(2863,'1','273','1',1,'Retail Sale Id 2875',2249.60,0.00,0.00,3.04,261.44,'2022-06-21 14:42:47','',''),(2864,'1','273','1',1,'Retail Sale Id 2876',3700.00,0.00,0.00,5.00,430.00,'2022-06-21 14:44:35','',''),(2865,'1','273','1',1,'Retail Sale Id 2877',10360.00,0.00,0.00,14.00,1204.00,'2022-06-21 14:45:21','',''),(2866,'1','273','1',1,'Retail Sale Id 2878',2997.00,0.00,0.00,4.05,348.30,'2022-06-21 14:46:16','',''),(2867,'1','273','1',1,'Retail Sale Id 2879',4440.00,0.00,0.00,6.00,516.00,'2022-06-21 14:48:10','',''),(2868,'1','273','1',1,'Retail Sale Id 2880',164220.00,0.00,0.00,238.00,8568.00,'2022-06-21 14:57:51','',''),(2869,'1','273','1',1,'Retail Sale Id 2881',138000.00,0.00,0.00,200.00,7200.00,'2022-06-21 14:59:09','',''),(2870,'1','273','1',1,'Retail Sale Id 2882',1702.00,0.00,0.00,2.30,197.80,'2022-06-21 15:09:38','',''),(2871,'1','273','1',1,'Retail Sale Id 2883',3700.00,0.00,0.00,5.00,430.00,'2022-06-21 15:13:55','',''),(2872,'1','273','1',1,'Retail Sale Id 2884',740.00,0.00,0.00,1.00,86.00,'2022-06-21 15:28:08','',''),(2873,'1','273','1',1,'Retail Sale Id 2885',1502.20,0.00,0.00,2.03,174.58,'2022-06-21 15:35:24','',''),(2874,'1','273','1',1,'Retail Sale Id 2886',747.40,0.00,0.00,1.01,86.86,'2022-06-21 15:37:04','',''),(2875,'1','273','1',1,'Retail Sale Id 2887',2501.20,0.00,0.00,3.38,290.68,'2022-06-21 15:38:15','',''),(2876,'1','273','1',1,'Retail Sale Id 2888',1998.00,0.00,0.00,2.70,232.20,'2022-06-21 15:40:29','',''),(2877,'1','273','1',1,'Retail Sale Id 2889',747.40,0.00,0.00,1.01,86.86,'2022-06-21 15:41:54','',''),(2878,'1','273','1',1,'Retail Sale Id 2890',4003.40,0.00,0.00,5.41,465.26,'2022-06-21 15:44:57','',''),(2879,'1','273','1',1,'Retail Sale Id 2891',1998.00,0.00,0.00,2.70,232.20,'2022-06-21 15:47:49','',''),(2880,'1','273','1',1,'Retail Sale Id 2892',9250.00,0.00,0.00,12.50,1075.00,'2022-06-21 15:56:32','',''),(2881,'1','273','1',1,'Retail Sale Id 2893',2960.00,0.00,0.00,4.00,344.00,'2022-06-21 16:02:00','',''),(2882,'1','273','1',1,'Retail Sale Id 2894',1998.00,0.00,0.00,2.70,232.20,'2022-06-21 17:52:26','',''),(2883,'1','273','1',1,'Retail Sale Id 2895',747.40,0.00,0.00,1.01,86.86,'2022-06-21 17:54:03','',''),(2884,'1','273','1',1,'Return of Retail Sale Id 2875',0.00,2249.60,3.04,0.00,-261.44,'2022-06-21 18:40:40','',''),(2885,'1','273','1',1,'Retail Sale Id 2896',1901.80,0.00,0.00,2.57,221.02,'2022-06-21 18:41:53','',''),(2886,'1','273','1',1,'Retail Sale Id 2897',5002.40,0.00,0.00,6.76,581.36,'2022-06-22 06:52:34','',''),(2887,'1','273','1',1,'Retail Sale Id 2898',65550.00,0.00,0.00,95.00,3420.00,'2022-06-22 06:58:09','',''),(2888,'1','273','1',1,'Retail Sale Id 2899',2249.60,0.00,0.00,3.04,261.44,'2022-06-22 07:04:56','',''),(2889,'1','273','1',1,'Retail Sale Id 2900',34500.00,0.00,0.00,50.00,1800.00,'2022-06-22 07:06:39','',''),(2890,'1','273','1',1,'Retail Sale Id 2901',34500.00,0.00,0.00,50.00,1800.00,'2022-06-22 07:15:11','',''),(2891,'1','273','1',1,'Retail Sale Id 2902',44850.00,0.00,0.00,65.00,2340.00,'2022-06-22 07:16:08','',''),(2892,'1','273','1',1,'Retail Sale Id 2903',2501.20,0.00,0.00,3.38,290.68,'2022-06-22 07:19:05','',''),(2893,'1','273','1',1,'Retail Sale Id 2904',1998.00,0.00,0.00,2.70,232.20,'2022-06-22 07:32:19','',''),(2894,'1','273','1',1,'Retail Sale Id 2905',1502.20,0.00,0.00,2.03,174.58,'2022-06-22 07:34:46','',''),(2895,'1','273','1',1,'Retail Sale Id 2906',2220.00,0.00,0.00,3.00,258.00,'2022-06-22 07:48:10','',''),(2896,'1','273','1',1,'Retail Sale Id 2907',999.00,0.00,0.00,1.35,116.10,'2022-06-22 07:50:04','',''),(2897,'1','273','1',1,'Retail Sale Id 2908',2220.00,0.00,0.00,3.00,258.00,'2022-06-22 07:55:29','',''),(2898,'1','273','1',1,'Retail Sale Id 2909',5920.00,0.00,0.00,8.00,688.00,'2022-06-22 07:58:36','',''),(2899,'1','273','1',1,'Retail Sale Id 2910',747.40,0.00,0.00,1.01,86.86,'2022-06-22 08:11:07','',''),(2900,'1','273','1',1,'Retail Sale Id 2911',7999.40,0.00,0.00,10.81,929.66,'2022-06-22 08:16:55','',''),(2901,'1','273','1',1,'Retail Sale Id 2912',19996.20,0.00,0.00,28.98,1043.28,'2022-06-22 08:18:13','',''),(2902,'1','273','1',1,'Retail Sale Id 2913',75900.00,0.00,0.00,110.00,3960.00,'2022-06-22 08:20:09','',''),(2903,'1','273','1',1,'Retail Sale Id 2914',747.40,0.00,0.00,1.01,86.86,'2022-06-22 08:21:18','',''),(2904,'1','273','1',1,'Retail Sale Id 2915',1998.00,0.00,0.00,2.70,232.20,'2022-06-22 08:24:04','',''),(2905,'1','273','1',1,'Retail Sale Id 2916',1502.20,0.00,0.00,2.03,174.58,'2022-06-22 08:25:23','',''),(2906,'1','273','1',1,'Retail Sale Id 2917',34500.00,0.00,0.00,50.00,1800.00,'2022-06-22 08:33:00','',''),(2907,'1','273','1',1,'Retail Sale Id 2918',34500.00,0.00,0.00,50.00,1800.00,'2022-06-22 08:34:15','',''),(2908,'1','273','1',1,'Retail Sale Id 2919',8140.00,0.00,0.00,11.00,946.00,'2022-06-22 08:37:19','',''),(2909,'1','273','1',1,'Retail Sale Id 2921',999.00,0.00,0.00,1.35,116.10,'2022-06-22 08:38:09','',''),(2910,'1','273','1',1,'Retail Sale Id 2922',44160.00,0.00,0.00,64.00,2304.00,'2022-06-22 08:39:36','',''),(2911,'1','273','1',1,'Retail Sale Id 2923',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 08:41:57','',''),(2912,'1','273','1',1,'Retail Sale Id 2924',2997.00,0.00,0.00,4.05,348.30,'2022-06-22 08:55:25','',''),(2913,'1','273','1',1,'Retail Sale Id 2925',747.40,0.00,0.00,1.01,86.86,'2022-06-22 08:58:18','',''),(2914,'1','273','1',1,'Retail Sale Id 2926',3700.00,0.00,0.00,5.00,430.00,'2022-06-22 09:05:03','',''),(2915,'1','273','1',1,'Retail Sale Id 2927',999.00,0.00,0.00,1.35,116.10,'2022-06-22 09:08:29','',''),(2916,'1','273','1',1,'Retail Sale Id 2928',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 09:21:03','',''),(2917,'1','273','1',1,'Retail Sale Id 2929',999.00,0.00,0.00,1.35,116.10,'2022-06-22 09:32:56','',''),(2918,'1','273','1',1,'Retail Sale Id 2930',34500.00,0.00,0.00,50.00,1800.00,'2022-06-22 09:43:26','',''),(2919,'1','273','1',1,'Retail Sale Id 2931',55200.00,0.00,0.00,80.00,2880.00,'2022-06-22 09:46:24','',''),(2920,'1','273','1',1,'Retail Sale Id 2932',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 09:55:03','',''),(2921,'1','273','1',1,'Retail Sale Id 2934',1502.20,0.00,0.00,2.03,174.58,'2022-06-22 10:05:29','',''),(2922,'1','273','1',1,'Retail Sale Id 2935',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 10:10:12','',''),(2923,'1','273','1',1,'Retail Sale Id 2936',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 10:11:00','',''),(2924,'1','273','1',1,'Retail Sale Id 2937',85560.00,0.00,0.00,124.00,4464.00,'2022-06-22 10:33:31','',''),(2925,'1','273','1',1,'Retail Sale Id 2939',69000.00,0.00,0.00,100.00,3600.00,'2022-06-22 10:36:41','',''),(2926,'1','273','1',1,'Retail Sale Id 2940',8140.00,0.00,0.00,11.00,946.00,'2022-06-22 11:02:15','',''),(2927,'1','273','1',1,'Retail Sale Id 2941',103500.00,0.00,0.00,150.00,5400.00,'2022-06-22 11:17:36','',''),(2928,'1','273','1',1,'Retail Sale Id 2942',103500.00,0.00,0.00,150.00,5400.00,'2022-06-22 11:19:02','',''),(2929,'1','273','1',1,'Retail Sale Id 2943',82800.00,0.00,0.00,120.00,4320.00,'2022-06-22 11:34:11','',''),(2930,'1','273','1',1,'Retail Sale Id 2944',82800.00,0.00,0.00,120.00,4320.00,'2022-06-22 11:35:20','',''),(2931,'1','273','1',1,'Retail Sale Id 2945',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 11:36:29','',''),(2932,'1','273','1',1,'Retail Sale Id 2946',1502.20,0.00,0.00,2.03,174.58,'2022-06-22 11:38:49','',''),(2933,'1','273','1',1,'Retail Sale Id 2947',740.00,0.00,0.00,1.00,86.00,'2022-06-22 11:42:21','',''),(2934,'1','273','1',1,'Retail Sale Id 2948',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 11:43:27','',''),(2935,'1','273','1',1,'Retail Sale Id 2949',2220.00,0.00,0.00,3.00,258.00,'2022-06-22 12:28:45','',''),(2936,'1','273','1',1,'Retail Sale Id 2950',999.00,0.00,0.00,1.35,116.10,'2022-06-22 12:33:17','',''),(2937,'1','273','1',1,'Retail Sale Id 2951',7400.00,0.00,0.00,10.00,860.00,'2022-06-22 12:38:44','',''),(2938,'1','273','1',1,'Retail Sale Id 2952',34500.00,0.00,0.00,50.00,1800.00,'2022-06-22 12:42:32','',''),(2939,'1','273','1',1,'Retail Sale Id 2953',1480.00,0.00,0.00,2.00,172.00,'2022-06-22 12:45:46','',''),(2940,'1','273','1',1,'Retail Sale Id 2954',8998.40,0.00,0.00,12.16,1045.76,'2022-06-22 12:48:13','',''),(2941,'1','273','1',1,'Retail Sale Id 2955',13320.00,0.00,0.00,18.00,1548.00,'2022-06-22 13:06:10','',''),(2942,'1','273','1',1,'Retail Sale Id 2957',740.00,0.00,0.00,1.00,86.00,'2022-06-22 13:13:04','',''),(2943,'1','273','1',1,'Retail Sale Id 2958',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 13:18:14','',''),(2944,'1','273','1',1,'Retail Sale Id 2959',3700.00,0.00,0.00,5.00,430.00,'2022-06-22 13:33:21','',''),(2945,'1','273','1',1,'Retail Sale Id 2960',1480.00,0.00,0.00,2.00,172.00,'2022-06-22 13:34:48','',''),(2946,'1','273','1',1,'Retail Sale Id 2961',747.40,0.00,0.00,1.01,86.86,'2022-06-22 13:41:51','',''),(2947,'1','273','1',1,'Retail Sale Id 2962',86250.00,0.00,0.00,125.00,4500.00,'2022-06-22 14:04:58','',''),(2948,'1','273','1',1,'Retail Sale Id 2963',86250.00,0.00,0.00,125.00,4500.00,'2022-06-22 14:06:10','',''),(2949,'1','273','1',1,'Retail Sale Id 2964',2220.00,0.00,0.00,3.00,258.00,'2022-06-22 14:09:29','',''),(2950,'1','273','1',1,'Retail Sale Id 2965',3700.00,0.00,0.00,5.00,430.00,'2022-06-22 14:18:07','',''),(2951,'1','273','1',1,'Retail Sale Id 2966',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 14:22:37','',''),(2952,'1','273','1',1,'Retail Sale Id 2967',747.40,0.00,0.00,1.01,86.86,'2022-06-22 14:24:41','',''),(2953,'1','273',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,1.23,0.00,'2022-06-22 14:27:45','',''),(2954,'1','273','1',1,'Received from bridging 12',0.00,0.00,1.23,0.00,0.00,'2022-06-22 14:27:45','',''),(2955,'1','273','1',1,'Retail Sale Id 2969',34500.00,0.00,0.00,50.00,1800.00,'2022-06-22 14:28:32','',''),(2956,'1','273','1',1,'Retail Sale Id 2970',3700.00,0.00,0.00,5.00,430.00,'2022-06-22 14:30:14','',''),(2957,'1','273','1',1,'Retail Sale Id 2971',1480.00,0.00,0.00,2.00,172.00,'2022-06-22 14:42:37','',''),(2958,'1','273','1',1,'Retail Sale Id 2972',747.40,0.00,0.00,1.01,86.86,'2022-06-22 15:10:36','',''),(2959,'1','273','1',1,'Retail Sale Id 2973',999.00,0.00,0.00,1.35,116.10,'2022-06-22 15:15:32','',''),(2960,'1','273','1',1,'Retail Sale Id 2974',2960.00,0.00,0.00,4.00,344.00,'2022-06-22 15:22:00','',''),(2961,'1','273','1',1,'Retail Sale Id 2975',999.00,0.00,0.00,1.35,116.10,'2022-06-22 15:45:31','',''),(2962,'1','273','1',1,'Retail Sale Id 2976',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 15:53:31','',''),(2963,'1','273','1',1,'Retail Sale Id 2977',1502.20,0.00,0.00,2.03,174.58,'2022-06-22 15:55:40','',''),(2964,'1','273','1',1,'Retail Sale Id 2978',1502.20,0.00,0.00,2.03,174.58,'2022-06-22 16:05:06','',''),(2965,'1','273','1',1,'Retail Sale Id 2979',1502.20,0.00,0.00,2.03,174.58,'2022-06-22 16:06:32','',''),(2966,'1','273','1',1,'Retail Sale Id 2980',1480.00,0.00,0.00,2.00,172.00,'2022-06-22 16:12:08','',''),(2967,'1','273','1',1,'Retail Sale Id 2981',2220.00,0.00,0.00,3.00,258.00,'2022-06-22 16:18:49','',''),(2968,'1','273','1',1,'Retail Sale Id 2982',13690.00,0.00,0.00,18.50,1591.00,'2022-06-22 16:21:09','',''),(2969,'1','273','1',1,'Retail Sale Id 2983',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 16:23:17','',''),(2970,'1','273','1',1,'Retail Sale Id 2984',1480.00,0.00,0.00,2.00,172.00,'2022-06-22 16:44:57','',''),(2971,'1','273','1',1,'Retail Sale Id 2985',5180.00,0.00,0.00,7.00,602.00,'2022-06-22 16:48:00','',''),(2972,'1','273','1',1,'Retail Sale Id 2986',1998.00,0.00,0.00,2.70,232.20,'2022-06-22 16:49:36','',''),(2973,'1','273','1',1,'Retail Sale Id 2988',5920.00,0.00,0.00,8.00,688.00,'2022-06-22 17:12:03','',''),(2974,'1','273','1',1,'Retail Sale Id 2989',1502.20,0.00,0.00,2.03,174.58,'2022-06-22 17:16:54','',''),(2975,'1','273','1',1,'Retail Sale Id 2990',3500.20,0.00,0.00,4.73,406.78,'2022-06-22 17:33:25','',''),(2976,'1','273','1',1,'Retail Sale Id 2991',747.40,0.00,0.00,1.01,86.86,'2022-06-22 17:36:32','',''),(2977,'1','273','1',1,'Retail Sale Id 2992',9250.00,0.00,0.00,12.50,1075.00,'2022-06-22 17:38:29','',''),(2978,'1','273','1',1,'Retail Sale Id 2993',747.40,0.00,0.00,1.01,86.86,'2022-06-22 17:41:40','',''),(2979,'1','273','1',1,'Retail Sale Id 2994',2997.00,0.00,0.00,4.05,348.30,'2022-06-22 17:43:08','',''),(2980,'1','273','1',1,'Retail Sale Id 2995',6660.00,0.00,0.00,9.00,774.00,'2022-06-22 17:46:09','',''),(2981,'1','273','1',1,'Retail Sale Id 2996',2249.60,0.00,0.00,3.04,261.44,'2022-06-22 17:53:38','',''),(2982,'1','273','1',1,'Retail Sale Id 2997',4440.00,0.00,0.00,6.00,516.00,'2022-06-22 17:55:10','',''),(2983,'1','273','1',1,'Retail Sale Id 2998',3700.00,0.00,0.00,5.00,430.00,'2022-06-22 18:02:01','',''),(2984,'1','273','1',1,'Retail Sale Id 2999',2997.00,0.00,0.00,4.05,348.30,'2022-06-22 18:03:30','',''),(2985,'1','273','1',1,'Retail Sale Id 3000',5920.00,0.00,0.00,8.00,688.00,'2022-06-22 18:05:09','',''),(2986,'1','273','1',1,'Retail Sale Id 3001',5920.00,0.00,0.00,8.00,688.00,'2022-06-22 18:06:45','',''),(2987,'1','273','1',1,'Retail Sale Id 3002',1998.00,0.00,0.00,2.70,232.20,'2022-06-22 18:08:33','',''),(2988,'1','273','1',1,'Retail Sale Id 3003',5180.00,0.00,0.00,7.00,602.00,'2022-06-22 18:10:13','',''),(2989,'1','273','1',1,'Retail Sale Id 3005',4440.00,0.00,0.00,6.00,516.00,'2022-06-22 18:11:53','',''),(2990,'1','273','1',1,'Return of Retail Sale Id 2994',0.00,2997.00,4.05,0.00,-348.30,'2022-06-22 18:44:42','',''),(2991,'1','273','1',1,'Retail Sale Id 3007',2826.80,0.00,0.00,3.82,328.52,'2022-06-22 18:46:20','',''),(2992,'1','273','1',1,'Retail Sale Id 3008',2301.40,0.00,0.00,3.11,267.46,'2022-06-23 06:47:44','',''),(2993,'1','273','1',1,'Retail Sale Id 3009',27993.30,0.00,0.00,40.57,1460.52,'2022-06-23 06:52:33','',''),(2994,'1','273','1',1,'Retail Sale Id 3011',999.00,0.00,0.00,1.35,116.10,'2022-06-23 07:01:22','',''),(2995,'1','273','1',1,'Retail Sale Id 3012',41400.00,0.00,0.00,60.00,2160.00,'2022-06-23 07:33:54','',''),(2996,'1','273','1',1,'Retail Sale Id 3013',8280.00,0.00,0.00,12.00,432.00,'2022-06-23 07:35:58','',''),(2997,'1','273','1',1,'Retail Sale Id 3014',2997.00,0.00,0.00,4.05,348.30,'2022-06-23 07:47:45','',''),(2998,'1','273','1',1,'Retail Sale Id 3015',3700.00,0.00,0.00,5.00,430.00,'2022-06-23 07:56:49','',''),(2999,'1','273','1',1,'Retail Sale Id 3016',7400.00,0.00,0.00,10.00,860.00,'2022-06-23 07:58:33','',''),(3000,'1','273','1',1,'Retail Sale Id 3017',747.40,0.00,0.00,1.01,86.86,'2022-06-23 08:03:33','',''),(3001,'1','273','1',1,'Retail Sale Id 3018',67965.00,0.00,0.00,98.50,3546.00,'2022-06-23 08:08:27','',''),(3002,'1','273','1',1,'Retail Sale Id 3019',6001.40,0.00,0.00,8.11,697.46,'2022-06-23 08:10:04','',''),(3003,'1','273','1',1,'Retail Sale Id 3020',999.00,0.00,0.00,1.35,116.10,'2022-06-23 08:30:13','',''),(3004,'1','273','1',1,'Retail Sale Id 3021',34500.00,0.00,0.00,50.00,1800.00,'2022-06-23 08:31:15','',''),(3005,'1','273','1',1,'Retail Sale Id 3022',9250.00,0.00,0.00,12.50,1075.00,'2022-06-23 08:33:09','',''),(3006,'1','273','1',1,'Retail Sale Id 3023',9250.00,0.00,0.00,12.50,1075.00,'2022-06-23 08:35:16','',''),(3007,'1','273','1',1,'Retail Sale Id 3024',12580.00,0.00,0.00,17.00,1462.00,'2022-06-23 08:45:54','',''),(3008,'1','273','1',1,'Retail Sale Id 3025',1998.00,0.00,0.00,2.70,232.20,'2022-06-23 09:47:12','',''),(3009,'1','273','1',1,'Retail Sale Id 3026',2220.00,0.00,0.00,3.00,258.00,'2022-06-23 10:08:34','',''),(3010,'1','273','1',1,'Retail Sale Id 3027',37000.00,0.00,0.00,50.00,4300.00,'2022-06-23 10:16:06','',''),(3011,'1','273','1',1,'Retail Sale Id 3028',1502.20,0.00,0.00,2.03,174.58,'2022-06-23 10:50:14','',''),(3012,'1','273','1',1,'Retail Sale Id 3030',5202.20,0.00,0.00,7.03,604.58,'2022-06-23 11:15:33','',''),(3013,'1','273','1',1,'Retail Sale Id 3031',10350.00,0.00,0.00,15.00,540.00,'2022-06-23 11:59:51','',''),(3014,'1','273','1',1,'Retail Sale Id 3033',4440.00,0.00,0.00,6.00,516.00,'2022-06-23 12:05:19','',''),(3015,'1','273','1',1,'Retail Sale Id 3034',1998.00,0.00,0.00,2.70,232.20,'2022-06-23 12:22:04','',''),(3016,'1','273','1',1,'Retail Sale Id 3035',3700.00,0.00,0.00,5.00,430.00,'2022-06-23 12:31:53','',''),(3017,'1','273','1',1,'Retail Sale Id 3036',82800.00,0.00,0.00,120.00,4320.00,'2022-06-23 12:36:32','',''),(3018,'1','273','1',1,'Retail Sale Id 3037',82800.00,0.00,0.00,120.00,4320.00,'2022-06-23 12:38:06','',''),(3019,'1','273','1',1,'Retail Sale Id 3038',138000.00,0.00,0.00,200.00,7200.00,'2022-06-23 12:54:54','',''),(3020,'1','273','1',1,'Retail Sale Id 3040',138000.00,0.00,0.00,200.00,7200.00,'2022-06-23 12:56:46','',''),(3021,'1','273','1',1,'Retail Sale Id 3041',1480.00,0.00,0.00,2.00,172.00,'2022-06-23 13:12:31','',''),(3022,'1','273','1',1,'Retail Sale Id 3042',2960.00,0.00,0.00,4.00,344.00,'2022-06-23 13:21:10','',''),(3023,'1','273','1',1,'Retail Sale Id 3044',9250.00,0.00,0.00,12.50,1075.00,'2022-06-23 13:27:28','',''),(3024,'1','273','1',1,'Retail Sale Id 3045',3700.00,0.00,0.00,5.00,430.00,'2022-06-23 13:53:21','',''),(3025,'1','273','1',1,'Retail Sale Id 3046',1998.00,0.00,0.00,2.70,232.20,'2022-06-23 13:55:30','',''),(3026,'1','273','1',1,'Retail Sale Id 3047',8140.00,0.00,0.00,11.00,946.00,'2022-06-23 14:03:52','',''),(3027,'1','273','1',1,'Retail Sale Id 3048',1480.00,0.00,0.00,2.00,172.00,'2022-06-23 14:06:08','',''),(3028,'1','273','1',1,'Retail Sale Id 3049',2997.00,0.00,0.00,4.05,348.30,'2022-06-23 14:47:38','',''),(3029,'1','273','1',1,'Retail Sale Id 3050',2249.60,0.00,0.00,3.04,261.44,'2022-06-23 14:57:53','',''),(3030,'1','273','1',1,'Retail Sale Id 3051',1480.00,0.00,0.00,2.00,172.00,'2022-06-23 15:08:50','',''),(3031,'1','273','1',1,'Retail Sale Id 3052',47610.00,0.00,0.00,69.00,2484.00,'2022-06-23 15:48:18','',''),(3032,'1','273','1',1,'Retail Sale Id 3053',999.00,0.00,0.00,1.35,116.10,'2022-06-23 15:50:19','',''),(3033,'1','273','1',1,'Retail Sale Id 3054',3700.00,0.00,0.00,5.00,430.00,'2022-06-23 15:51:22','',''),(3034,'1','273','1',1,'Retail Sale Id 3055',1480.00,0.00,0.00,2.00,172.00,'2022-06-23 16:03:51','',''),(3035,'1','273','1',1,'Retail Sale Id 3056',6660.00,0.00,0.00,9.00,774.00,'2022-06-23 16:11:01','',''),(3036,'1','273','1',1,'Retail Sale Id 3057',740.00,0.00,0.00,1.00,86.00,'2022-06-23 16:12:16','',''),(3037,'1','273','1',1,'Retail Sale Id 3058',2960.00,0.00,0.00,4.00,344.00,'2022-06-23 16:13:30','',''),(3038,'1','273','1',1,'Retail Sale Id 3059',1480.00,0.00,0.00,2.00,172.00,'2022-06-23 16:14:52','',''),(3039,'1','273','1',1,'Retail Sale Id 3060',89700.00,0.00,0.00,130.00,4680.00,'2022-06-23 16:19:11','',''),(3040,'1','273','1',1,'Retail Sale Id 3061',4440.00,0.00,0.00,6.00,516.00,'2022-06-23 16:22:40','',''),(3041,'1','273','1',1,'Retail Sale Id 3062',999.00,0.00,0.00,1.35,116.10,'2022-06-23 16:25:25','',''),(3042,'1','273','1',1,'Retail Sale Id 3063',4440.00,0.00,0.00,6.00,516.00,'2022-06-23 16:43:08','',''),(3043,'1','273','1',1,'Retail Sale Id 3064',2997.00,0.00,0.00,4.05,348.30,'2022-06-23 16:54:36','',''),(3044,'1','273','1',1,'Retail Sale Id 3065',1480.00,0.00,0.00,2.00,172.00,'2022-06-23 17:03:19','',''),(3045,'1','273','1',1,'Retail Sale Id 3066',1998.00,0.00,0.00,2.70,232.20,'2022-06-23 17:06:26','',''),(3046,'1','273','1',1,'Retail Sale Id 3067',3700.00,0.00,0.00,5.00,430.00,'2022-06-23 17:11:56','',''),(3047,'1','273','1',1,'Retail Sale Id 3068',999.00,0.00,0.00,1.35,116.10,'2022-06-23 17:18:30','',''),(3048,'1','273','1',1,'Retail Sale Id 3069',703.00,0.00,0.00,0.95,81.70,'2022-06-23 17:19:55','',''),(3049,'1','273','1',1,'Retail Sale Id 3070',740.00,0.00,0.00,1.00,86.00,'2022-06-23 17:34:18','',''),(3050,'1','273','1',1,'Retail Sale Id 3071',4003.40,0.00,0.00,5.41,465.26,'2022-06-23 17:35:56','',''),(3051,'1','273','1',1,'Retail Sale Id 3072',2501.20,0.00,0.00,3.38,290.68,'2022-06-23 17:37:04','',''),(3052,'1','273','1',1,'Retail Sale Id 3073',3500.20,0.00,0.00,4.73,406.78,'2022-06-23 17:38:20','',''),(3053,'1','273','1',1,'Retail Sale Id 3074',34500.00,0.00,0.00,50.00,1800.00,'2022-06-23 17:42:09','',''),(3054,'1','273','1',1,'Retail Sale Id 3075',1502.20,0.00,0.00,2.03,174.58,'2022-06-23 17:46:51','',''),(3055,'1','273','1',1,'Retail Sale Id 3076',747.40,0.00,0.00,1.01,86.86,'2022-06-23 17:52:57','',''),(3056,'1','273','1',1,'Retail Sale Id 3077',2997.00,0.00,0.00,4.05,348.30,'2022-06-23 17:55:48','',''),(3057,'1','273','1',1,'Retail Sale Id 3078',2249.60,0.00,0.00,3.04,261.44,'2022-06-23 17:59:26','',''),(3058,'1','273','1',1,'Retail Sale Id 3079',34500.00,0.00,0.00,50.00,1800.00,'2022-06-23 18:07:32','',''),(3059,'1','273','1',1,'Retail Sale Id 3080',69000.00,0.00,0.00,100.00,3600.00,'2022-06-23 18:08:44','',''),(3060,'1','273','1',1,'Retail Sale Id 3081',999.00,0.00,0.00,1.35,116.10,'2022-06-23 18:10:10','',''),(3061,'1','273','1',1,'Retail Sale Id 3082',0.00,0.00,0.00,1.00,-654.00,'2022-06-23 18:14:04','',''),(3062,'1','273','1',1,'Retail Sale Id 3083',3700.00,0.00,0.00,5.00,430.00,'2022-06-23 18:16:20','',''),(3063,'1','273','1',1,'Retail Sale Id 3084',3700.00,0.00,0.00,5.00,430.00,'2022-06-23 18:17:33','',''),(3064,'1','273','1',1,'Retail Sale Id 3085',2220.00,0.00,0.00,3.00,258.00,'2022-06-23 18:22:30','',''),(3065,'1','273','1',1,'Retail Sale Id 3086',6497.20,0.00,0.00,8.78,755.08,'2022-06-23 18:28:09','',''),(3066,'1','273','1',1,'Retail Sale Id 3087',1480.00,0.00,0.00,2.00,172.00,'2022-06-23 18:32:56','',''),(3067,'1','273','1',1,'Retail Sale Id 3088',1502.20,0.00,0.00,2.03,174.58,'2022-06-24 07:01:21','',''),(3068,'1','273','1',1,'Retail Sale Id 3089',26496.00,0.00,0.00,38.40,1382.40,'2022-06-24 07:29:56','',''),(3069,'1','273','1',1,'Retail Sale Id 3090',138000.00,0.00,0.00,200.00,7200.00,'2022-06-24 07:42:42','',''),(3070,'1','273','1',1,'Retail Sale Id 3091',138000.00,0.00,0.00,200.00,7200.00,'2022-06-24 07:43:41','',''),(3071,'1','273','1',1,'Retail Sale Id 3092',71070.00,0.00,0.00,103.00,3708.00,'2022-06-24 07:46:48','',''),(3072,'1','273','1',1,'Retail Sale Id 3093',40020.00,0.00,0.00,58.00,2088.00,'2022-06-24 07:48:11','',''),(3073,'1','273','1',1,'Retail Sale Id 3094',4440.00,0.00,0.00,6.00,516.00,'2022-06-24 07:52:26','',''),(3074,'1','273','1',1,'Retail Sale Id 3095',2220.00,0.00,0.00,3.00,258.00,'2022-06-24 08:13:50','',''),(3075,'1','273','1',1,'Retail Sale Id 3096',103500.00,0.00,0.00,150.00,5400.00,'2022-06-24 08:19:02','',''),(3076,'1','273','1',1,'Retail Sale Id 3097',69000.00,0.00,0.00,100.00,3600.00,'2022-06-24 08:19:52','',''),(3077,'1','273','1',1,'Retail Sale Id 3098',1480.00,0.00,0.00,2.00,172.00,'2022-06-24 08:20:55','',''),(3078,'1','273','1',1,'Retail Sale Id 3099',2960.00,0.00,0.00,4.00,344.00,'2022-06-24 08:22:02','',''),(3079,'1','273','1',1,'Retail Sale Id 3100',1480.00,0.00,0.00,2.00,172.00,'2022-06-24 08:30:34','',''),(3080,'1','273','1',1,'Retail Sale Id 3101',2997.00,0.00,0.00,4.05,348.30,'2022-06-24 08:31:36','',''),(3081,'1','273','1',1,'Retail Sale Id 3102',999.00,0.00,0.00,1.35,116.10,'2022-06-24 08:38:56','',''),(3082,'1','273','1',1,'Retail Sale Id 3103',103500.00,0.00,0.00,150.00,5400.00,'2022-06-24 08:42:43','',''),(3083,'1','273','1',1,'Retail Sale Id 3104',138000.00,0.00,0.00,200.00,7200.00,'2022-06-24 08:44:43','',''),(3084,'1','273','1',1,'Retail Sale Id 3105',740.00,0.00,0.00,1.00,86.00,'2022-06-24 09:04:13','',''),(3085,'1','273','1',1,'Retail Sale Id 3106',69000.00,0.00,0.00,100.00,3600.00,'2022-06-24 09:07:16','',''),(3086,'1','273','1',1,'Retail Sale Id 3107',138000.00,0.00,0.00,200.00,7200.00,'2022-06-24 09:10:49','',''),(3087,'1','273','1',1,'Retail Sale Id 3108',3700.00,0.00,0.00,5.00,430.00,'2022-06-24 09:18:19','',''),(3088,'1','273','1',1,'Retail Sale Id 3109',3500.20,0.00,0.00,4.73,406.78,'2022-06-24 09:19:07','',''),(3089,'1','273','1',1,'Retail Sale Id 3110',1480.00,0.00,0.00,2.00,172.00,'2022-06-24 09:21:07','',''),(3090,'1','273','1',1,'Retail Sale Id 3111',2220.00,0.00,0.00,3.00,258.00,'2022-06-24 09:42:51','',''),(3091,'1','273','1',1,'Retail Sale Id 3112',3700.00,0.00,0.00,5.00,430.00,'2022-06-24 09:43:37','',''),(3092,'1','273','1',1,'Retail Sale Id 3113',69000.00,0.00,0.00,100.00,3600.00,'2022-06-24 09:45:47','',''),(3093,'1','273','1',1,'Retail Sale Id 3114',69000.00,0.00,0.00,100.00,3600.00,'2022-06-24 09:46:54','',''),(3094,'1','273','1',1,'Retail Sale Id 3115',999.00,0.00,0.00,1.35,116.10,'2022-06-24 09:55:29','',''),(3095,'1','273','1',1,'Retail Sale Id 3116',5180.00,0.00,0.00,7.00,602.00,'2022-06-24 10:01:32','',''),(3096,'1','273','1',1,'Retail Sale Id 3117',4440.00,0.00,0.00,6.00,516.00,'2022-06-24 10:02:48','',''),(3097,'1','273','1',1,'Retail Sale Id 3118',3700.00,0.00,0.00,5.00,430.00,'2022-06-24 10:29:33','',''),(3098,'1','273','1',1,'Retail Sale Id 3119',3700.00,0.00,0.00,5.00,430.00,'2022-06-24 10:31:41','',''),(3099,'1','273','1',1,'Retail Sale Id 3120',5180.00,0.00,0.00,7.00,602.00,'2022-06-24 10:39:42','',''),(3100,'1','273','1',1,'Retail Sale Id 3121',8280.00,0.00,0.00,12.00,432.00,'2022-06-24 11:01:38','',''),(3101,'1','273','1',1,'Retail Sale Id 3122',4440.00,0.00,0.00,6.00,516.00,'2022-06-24 11:07:25','',''),(3102,'1','273','1',1,'Retail Sale Id 3123',2960.00,0.00,0.00,4.00,344.00,'2022-06-24 11:11:41','',''),(3103,'1','273','1',1,'Retail Sale Id 3124',2997.00,0.00,0.00,4.05,348.30,'2022-06-24 11:14:05','',''),(3104,'1','273','1',1,'Retail Sale Id 3125',82800.00,0.00,0.00,120.00,4320.00,'2022-06-24 11:18:33','',''),(3105,'1','273','1',1,'Retail Sale Id 3126',41400.00,0.00,0.00,60.00,2160.00,'2022-06-24 11:19:41','',''),(3106,'1','273','1',1,'Retail Sale Id 3127',37950.00,0.00,0.00,55.00,1980.00,'2022-06-24 11:36:03','',''),(3107,'1','273','1',1,'Retail Sale Id 3128',34500.00,0.00,0.00,50.00,1800.00,'2022-06-24 11:37:42','',''),(3108,'1','273','1',1,'Retail Sale Id 3129',82800.00,0.00,0.00,120.00,4320.00,'2022-06-24 11:49:40','',''),(3109,'1','273','1',1,'Retail Sale Id 3130',38025.90,0.00,0.00,55.11,1983.96,'2022-06-24 11:52:16','',''),(3110,'1','273','1',1,'Retail Sale Id 3131',2960.00,0.00,0.00,4.00,344.00,'2022-06-24 11:56:42','',''),(3111,'1','273','1',1,'Retail Sale Id 3132',747.40,0.00,0.00,1.01,86.86,'2022-06-24 12:32:55','',''),(3112,'1','273','1',1,'Retail Sale Id 3133',1480.00,0.00,0.00,2.00,172.00,'2022-06-24 13:11:43','',''),(3113,'1','273','1',1,'Retail Sale Id 3134',75900.00,0.00,0.00,110.00,3960.00,'2022-06-24 13:19:18','',''),(3114,'1','273','1',1,'Retail Sale Id 3135',5920.00,0.00,0.00,8.00,688.00,'2022-06-24 13:20:55','',''),(3115,'1','273','1',1,'Retail Sale Id 3136',103500.00,0.00,0.00,150.00,5400.00,'2022-06-24 13:23:42','',''),(3116,'1','273','1',1,'Retail Sale Id 3137',27600.00,0.00,0.00,40.00,1440.00,'2022-06-24 13:26:16','',''),(3117,'1','273','1',1,'Retail Sale Id 3138',2997.00,0.00,0.00,4.05,348.30,'2022-06-24 13:30:03','',''),(3118,'1','273','1',1,'Retail Sale Id 3139',9250.00,0.00,0.00,12.50,1075.00,'2022-06-24 13:36:08','',''),(3119,'1','273','1',1,'Retail Sale Id 3140',4003.40,0.00,0.00,5.41,465.26,'2022-06-24 13:55:14','',''),(3120,'1','273','1',1,'Retail Sale Id 3141',747.40,0.00,0.00,1.01,86.86,'2022-06-24 15:02:39','',''),(3121,'1','273','1',1,'Retail Sale Id 3142',732.60,0.00,0.00,0.99,85.14,'2022-06-24 15:15:25','',''),(3122,'1','273','1',1,'Retail Sale Id 3143',747.40,0.00,0.00,1.01,86.86,'2022-06-24 15:16:45','',''),(3123,'1','273','1',1,'Retail Sale Id 3144',3700.00,0.00,0.00,5.00,430.00,'2022-06-24 15:17:46','',''),(3124,'1','273','1',1,'Retail Sale Id 3145',8280.00,0.00,0.00,12.00,432.00,'2022-06-24 15:22:52','',''),(3125,'1','273','1',1,'Retail Sale Id 3146',9620.00,0.00,0.00,13.00,1118.00,'2022-06-24 15:33:50','',''),(3126,'1','273','1',1,'Retail Sale Id 3147',7400.00,0.00,0.00,10.00,860.00,'2022-06-24 15:35:07','',''),(3127,'1','273','1',1,'Retail Sale Id 3148',62100.00,0.00,0.00,90.00,3240.00,'2022-06-24 15:49:12','',''),(3128,'1','273','1',1,'Retail Sale Id 3149',740.00,0.00,0.00,1.00,86.00,'2022-06-24 15:57:16','',''),(3129,'1','273','1',1,'Retail Sale Id 3150',1480.00,0.00,0.00,2.00,172.00,'2022-06-24 16:04:28','',''),(3130,'1','273','1',1,'Retail Sale Id 3151',3500.20,0.00,0.00,4.73,406.78,'2022-06-24 16:09:01','',''),(3131,'1','273','1',1,'Retail Sale Id 3152',999.00,0.00,0.00,1.35,116.10,'2022-06-24 16:10:42','',''),(3132,'1','273','1',1,'Retail Sale Id 3153',3700.00,0.00,0.00,5.00,430.00,'2022-06-24 16:27:26','',''),(3133,'1','273','1',1,'Retail Sale Id 3154',799.20,0.00,0.00,1.08,92.88,'2022-06-24 16:28:51','',''),(3134,'1','273','1',1,'Retail Sale Id 3155',1502.20,0.00,0.00,2.03,174.58,'2022-06-24 16:36:38','',''),(3135,'1','273','1',1,'Retail Sale Id 3156',2220.00,0.00,0.00,3.00,258.00,'2022-06-24 16:43:10','',''),(3136,'1','273','1',1,'Retail Sale Id 3157',2501.20,0.00,0.00,3.38,290.68,'2022-06-24 16:54:06','',''),(3137,'1','273','1',1,'Retail Sale Id 3158',3700.00,0.00,0.00,5.00,430.00,'2022-06-24 16:56:34','',''),(3138,'1','273','1',1,'Retail Sale Id 3159',1480.00,0.00,0.00,2.00,172.00,'2022-06-24 16:58:44','',''),(3139,'1','273','1',1,'Retail Sale Id 3160',3700.00,0.00,0.00,5.00,430.00,'2022-06-24 17:02:07','',''),(3140,'1','273','1',1,'Retail Sale Id 3161',65550.00,0.00,0.00,95.00,3420.00,'2022-06-24 17:04:26','',''),(3141,'1','273','1',1,'Retail Sale Id 3162',1850.00,0.00,0.00,2.50,215.00,'2022-06-24 17:10:38','',''),(3142,'1','273','1',1,'Retail Sale Id 3163',3700.00,0.00,0.00,5.00,430.00,'2022-06-24 17:14:12','',''),(3143,'1','273','1',1,'Retail Sale Id 3164',999.00,0.00,0.00,1.35,116.10,'2022-06-24 17:19:09','',''),(3144,'1','273','1',1,'Retail Sale Id 3165',8140.00,0.00,0.00,11.00,946.00,'2022-06-24 17:22:02','',''),(3145,'1','273','1',1,'Retail Sale Id 3166',1480.00,0.00,0.00,2.00,172.00,'2022-06-24 17:23:56','',''),(3146,'1','273','1',1,'Retail Sale Id 3167',747.40,0.00,0.00,1.01,86.86,'2022-06-24 17:24:59','',''),(3147,'1','273','1',1,'Retail Sale Id 3168',34500.00,0.00,0.00,50.00,1800.00,'2022-06-24 17:26:05','',''),(3148,'1','273','1',1,'Retail Sale Id 3169',4440.00,0.00,0.00,6.00,516.00,'2022-06-24 17:27:35','',''),(3149,'1','273','1',1,'Retail Sale Id 3170',999.00,0.00,0.00,1.35,116.10,'2022-06-24 17:33:43','',''),(3150,'1','273','1',1,'Retail Sale Id 3171',1998.00,0.00,0.00,2.70,232.20,'2022-06-24 17:37:13','',''),(3151,'1','273','1',1,'Retail Sale Id 3172',2997.00,0.00,0.00,4.05,348.30,'2022-06-24 17:42:29','',''),(3152,'1','273','1',1,'Retail Sale Id 3174',1998.00,0.00,0.00,2.70,232.20,'2022-06-24 17:44:36','',''),(3153,'1','273','1',1,'Retail Sale Id 3175',1480.00,0.00,0.00,2.00,172.00,'2022-06-24 17:51:03','',''),(3154,'1','273','1',1,'Retail Sale Id 3176',1502.20,0.00,0.00,2.03,174.58,'2022-06-24 17:52:08','',''),(3155,'1','273','1',1,'Retail Sale Id 3177',747.40,0.00,0.00,1.01,86.86,'2022-06-24 17:55:04','',''),(3156,'1','273','1',1,'Retail Sale Id 3178',747.40,0.00,0.00,1.01,86.86,'2022-06-24 18:41:40','',''),(3157,'1','273','1',1,'Retail Sale Id 3179',999.00,0.00,0.00,1.35,116.10,'2022-06-25 07:09:22','',''),(3158,'1','273','1',1,'Retail Sale Id 3180',8880.00,0.00,0.00,12.00,1032.00,'2022-06-25 07:10:49','',''),(3159,'1','273','1',1,'Retail Sale Id 3181',3700.00,0.00,0.00,5.00,430.00,'2022-06-25 07:11:53','',''),(3160,'1','273','1',1,'Retail Sale Id 3182',12002.80,0.00,0.00,16.22,1394.92,'2022-06-25 07:14:51','',''),(3161,'1','273','1',1,'Retail Sale Id 3183',1502.20,0.00,0.00,2.03,174.58,'2022-06-25 07:21:01','',''),(3162,'1','273','1',1,'Retail Sale Id 3184',1502.20,0.00,0.00,2.03,174.58,'2022-06-25 07:28:12','',''),(3163,'1','273','1',1,'Retail Sale Id 3185',2997.00,0.00,0.00,4.05,348.30,'2022-06-25 07:31:42','',''),(3164,'1','273','1',1,'Retail Sale Id 3186',1502.20,0.00,0.00,2.03,174.58,'2022-06-25 07:32:36','',''),(3165,'1','273','1',1,'Retail Sale Id 3187',9250.00,0.00,0.00,12.50,1075.00,'2022-06-25 07:33:34','',''),(3166,'1','273','1',1,'Retail Sale Id 3188',5180.00,0.00,0.00,7.00,602.00,'2022-06-25 07:36:26','',''),(3167,'1','273','1',1,'Retail Sale Id 3189',1502.20,0.00,0.00,2.03,174.58,'2022-06-25 07:53:36','',''),(3168,'1','273','1',1,'Retail Sale Id 3190',2249.60,0.00,0.00,3.04,261.44,'2022-06-25 07:59:59','',''),(3169,'1','273','1',1,'Retail Sale Id 3191',34500.00,0.00,0.00,50.00,1800.00,'2022-06-25 08:03:01','',''),(3170,'1','273','1',1,'Retail Sale Id 3192',2220.00,0.00,0.00,3.00,258.00,'2022-06-25 08:05:36','',''),(3171,'1','273','1',1,'Retail Sale Id 3193',4003.40,0.00,0.00,5.41,465.26,'2022-06-25 08:24:09','',''),(3172,'1','273','1',1,'Retail Sale Id 3194',999.00,0.00,0.00,1.35,116.10,'2022-06-25 08:24:59','',''),(3173,'1','273','1',1,'Retail Sale Id 3195',4699.00,0.00,0.00,6.35,546.10,'2022-06-25 08:25:57','',''),(3174,'1','273','1',1,'Retail Sale Id 3196',2960.00,0.00,0.00,4.00,344.00,'2022-06-25 08:26:35','',''),(3175,'1','273','1',1,'Retail Sale Id 3197',207000.00,0.00,0.00,300.00,10800.00,'2022-06-25 08:27:14','',''),(3176,'1','273','1',1,'Retail Sale Id 3198',241500.00,0.00,0.00,350.00,12600.00,'2022-06-25 08:28:02','',''),(3177,'1','273','1',1,'Retail Sale Id 3199',77625.00,0.00,0.00,112.50,4050.00,'2022-06-25 08:32:53','',''),(3178,'1','273','1',1,'Retail Sale Id 3200',747.40,0.00,0.00,1.01,86.86,'2022-06-25 08:40:08','',''),(3179,'1','273','1',1,'Retail Sale Id 3201',9250.00,0.00,0.00,12.50,1075.00,'2022-06-25 08:42:46','',''),(3180,'1','273','1',1,'Retail Sale Id 3202',747.40,0.00,0.00,1.01,86.86,'2022-06-25 08:47:43','',''),(3181,'1','273','1',1,'Retail Sale Id 3203',1502.20,0.00,0.00,2.03,174.58,'2022-06-25 08:52:02','',''),(3182,'1','273','1',1,'Retail Sale Id 3204',999.00,0.00,0.00,1.35,116.10,'2022-06-25 09:00:07','',''),(3183,'1','273','1',1,'Retail Sale Id 3205',5202.20,0.00,0.00,7.03,604.58,'2022-06-25 09:01:57','',''),(3184,'1','273','1',1,'Retail Sale Id 3206',3700.00,0.00,0.00,5.00,430.00,'2022-06-25 09:12:46','',''),(3185,'1','273','1',1,'Retail Sale Id 3207',1302.40,0.00,0.00,1.76,151.36,'2022-06-25 09:14:52','',''),(3186,'1','273','1',1,'Retail Sale Id 3208',1998.00,0.00,0.00,2.70,232.20,'2022-06-25 09:25:52','',''),(3187,'1','273','1',1,'Retail Sale Id 3209',9250.00,0.00,0.00,12.50,1075.00,'2022-06-25 09:27:36','',''),(3188,'1','273','1',1,'Retail Sale Id 3210',2249.60,0.00,0.00,3.04,261.44,'2022-06-25 09:32:59','',''),(3189,'1','273','1',1,'Retail Sale Id 3211',7400.00,0.00,0.00,10.00,860.00,'2022-06-25 09:39:41','',''),(3190,'1','273','1',1,'Retail Sale Id 3212',747.40,0.00,0.00,1.01,86.86,'2022-06-25 10:02:58','',''),(3191,'1','273','1',1,'Retail Sale Id 3213',9250.00,0.00,0.00,12.50,1075.00,'2022-06-25 10:08:00','',''),(3192,'1','273','1',1,'Retail Sale Id 3214',17995.20,0.00,0.00,26.08,938.88,'2022-06-25 10:12:55','',''),(3193,'1','273','1',1,'Retail Sale Id 3215',799.20,0.00,0.00,1.08,92.88,'2022-06-25 10:14:09','',''),(3194,'1','273','1',1,'Retail Sale Id 3217',7400.00,0.00,0.00,10.00,860.00,'2022-06-25 10:25:05','',''),(3195,'1','273','1',1,'Retail Sale Id 3218',1998.00,0.00,0.00,2.70,232.20,'2022-06-25 10:26:49','',''),(3196,'1','273','1',1,'Retail Sale Id 3219',1480.00,0.00,0.00,2.00,172.00,'2022-06-25 10:35:28','',''),(3197,'1','273','1',1,'Retail Sale Id 3220',747.40,0.00,0.00,1.01,86.86,'2022-06-25 10:40:10','',''),(3198,'1','273','1',1,'Retail Sale Id 3221',747.40,0.00,0.00,1.01,86.86,'2022-06-25 10:55:56','',''),(3199,'1','273','1',1,'Retail Sale Id 3222',103500.00,0.00,0.00,150.00,5400.00,'2022-06-25 11:01:42','',''),(3200,'1','273','1',1,'Retail Sale Id 3223',82800.00,0.00,0.00,120.00,4320.00,'2022-06-25 11:07:41','',''),(3201,'1','273','1',1,'Retail Sale Id 3224',20700.00,0.00,0.00,30.00,1080.00,'2022-06-25 11:09:38','',''),(3202,'1','273','1',1,'Retail Sale Id 3225',34500.00,0.00,0.00,50.00,1800.00,'2022-06-25 11:15:21','',''),(3203,'1','273','1',1,'Retail Sale Id 3226',4447.40,0.00,0.00,6.01,516.86,'2022-06-25 11:16:42','',''),(3204,'1','273','1',1,'Retail Sale Id 3227',5002.40,0.00,0.00,6.76,581.36,'2022-06-25 11:17:48','',''),(3205,'1','273','1',1,'Retail Sale Id 3228',747.40,0.00,0.00,1.01,86.86,'2022-06-25 11:42:05','',''),(3206,'1','273','1',1,'Retail Sale Id 3229',2220.00,0.00,0.00,3.00,258.00,'2022-06-25 11:42:48','',''),(3207,'1','273','1',1,'Retail Sale Id 3230',1302.40,0.00,0.00,1.76,151.36,'2022-06-25 11:58:14','',''),(3208,'1','273','1',1,'Retail Sale Id 3231',3700.00,0.00,0.00,5.00,430.00,'2022-06-25 12:03:49','',''),(3209,'1','273','1',1,'Retail Sale Id 3232',5002.40,0.00,0.00,6.76,581.36,'2022-06-25 12:16:54','',''),(3210,'1','273','1',1,'Retail Sale Id 3233',1998.00,0.00,0.00,2.70,232.20,'2022-06-25 12:20:29','',''),(3211,'1','273','1',1,'Retail Sale Id 3234',3137.60,0.00,0.00,4.24,364.64,'2022-06-25 12:26:54','',''),(3212,'1','273','1',1,'Retail Sale Id 3235',1480.00,0.00,0.00,2.00,172.00,'2022-06-25 12:33:08','',''),(3213,'1','273','1',1,'Retail Sale Id 3236',2960.00,0.00,0.00,4.00,344.00,'2022-06-25 12:49:36','',''),(3214,'1','273','1',1,'Retail Sale Id 3237',1480.00,0.00,0.00,2.00,172.00,'2022-06-25 12:54:37','',''),(3215,'1','273','1',1,'Retail Sale Id 3238',5920.00,0.00,0.00,8.00,688.00,'2022-06-25 12:59:01','',''),(3216,'1','273','1',1,'Retail Sale Id 3239',1798.20,0.00,0.00,2.43,208.98,'2022-06-25 13:01:29','',''),(3217,'1','273','1',1,'Retail Sale Id 3240',4003.40,0.00,0.00,5.41,465.26,'2022-06-25 13:07:35','',''),(3218,'1','273','1',1,'Retail Sale Id 3241',747.40,0.00,0.00,1.01,86.86,'2022-06-25 13:11:14','',''),(3219,'1','273','1',1,'Retail Sale Id 3242',5949.60,0.00,0.00,8.04,691.44,'2022-06-25 14:10:24','',''),(3220,'1','273','1',1,'Retail Sale Id 3243',5180.00,0.00,0.00,7.00,602.00,'2022-06-25 14:17:32','',''),(3221,'1','273','1',1,'Retail Sale Id 3244',27600.00,0.00,0.00,40.00,1440.00,'2022-06-25 14:39:12','',''),(3222,'1','273','1',1,'Retail Sale Id 3245',1502.20,0.00,0.00,2.03,174.58,'2022-06-25 14:45:44','',''),(3223,'1','273','1',1,'Retail Sale Id 3246',2997.00,0.00,0.00,4.05,348.30,'2022-06-25 14:47:32','',''),(3224,'1','273','1',1,'Retail Sale Id 3247',747.40,0.00,0.00,1.01,86.86,'2022-06-25 14:59:45','',''),(3225,'1','273','1',1,'Retail Sale Id 3248',999.00,0.00,0.00,1.35,116.10,'2022-06-25 15:03:56','',''),(3226,'1','273','1',1,'Retail Sale Id 3249',1480.00,0.00,0.00,2.00,172.00,'2022-06-25 15:06:03','',''),(3227,'1','273','1',1,'Retail Sale Id 3250',14430.00,0.00,0.00,19.50,1677.00,'2022-06-25 15:19:27','',''),(3228,'1','273','1',1,'Retail Sale Id 3251',9250.00,0.00,0.00,12.50,1075.00,'2022-06-25 15:30:00','',''),(3229,'1','273','1',1,'Retail Sale Id 3252',86250.00,0.00,0.00,125.00,4500.00,'2022-06-25 15:33:11','',''),(3230,'1','273','1',1,'Retail Sale Id 3253',86250.00,0.00,0.00,125.00,4500.00,'2022-06-25 15:34:10','',''),(3231,'1','273','1',1,'Retail Sale Id 3254',5180.00,0.00,0.00,7.00,602.00,'2022-06-25 15:36:54','',''),(3232,'1','273','1',1,'Retail Sale Id 3255',1502.20,0.00,0.00,2.03,174.58,'2022-06-25 15:43:01','',''),(3233,'1','273','1',1,'Retail Sale Id 3256',34500.00,0.00,0.00,50.00,1800.00,'2022-06-25 15:46:50','',''),(3234,'1','273','1',1,'Retail Sale Id 3257',34500.00,0.00,0.00,50.00,1800.00,'2022-06-25 15:47:59','',''),(3235,'1','273','1',1,'Retail Sale Id 3258',747.40,0.00,0.00,1.01,86.86,'2022-06-25 16:01:27','',''),(3236,'1','273','1',1,'Retail Sale Id 3262',4440.00,0.00,0.00,6.00,516.00,'2022-06-25 16:04:07','',''),(3237,'1','273','1',1,'Retail Sale Id 3264',4440.00,0.00,0.00,6.00,516.00,'2022-06-25 16:06:02','',''),(3238,'1','273','1',1,'Retail Sale Id 3265',60720.00,0.00,0.00,88.00,3168.00,'2022-06-25 16:11:27','',''),(3239,'1','273','1',1,'Retail Sale Id 3266',27600.00,0.00,0.00,40.00,1440.00,'2022-06-25 16:12:28','',''),(3240,'1','273','1',1,'Retail Sale Id 3267',999.00,0.00,0.00,1.35,116.10,'2022-06-25 16:13:50','',''),(3241,'1','273','1',1,'Retail Sale Id 3268',5920.00,0.00,0.00,8.00,688.00,'2022-06-25 16:16:35','',''),(3242,'1','273','1',1,'Retail Sale Id 3269',2249.60,0.00,0.00,3.04,261.44,'2022-06-25 16:18:50','',''),(3243,'1','273','1',1,'Retail Sale Id 3271',999.00,0.00,0.00,1.35,116.10,'2022-06-25 16:21:02','',''),(3244,'1','273','1',1,'Retail Sale Id 3272',1998.00,0.00,0.00,2.70,232.20,'2022-06-25 16:23:53','',''),(3245,'1','273','1',1,'Retail Sale Id 3273',4440.00,0.00,0.00,6.00,516.00,'2022-06-25 16:25:46','',''),(3246,'1','273','1',1,'Retail Sale Id 3274',747.40,0.00,0.00,1.01,86.86,'2022-06-25 16:33:20','',''),(3247,'1','273','1',1,'Retail Sale Id 3275',1502.20,0.00,0.00,2.03,174.58,'2022-06-25 16:34:35','',''),(3248,'1','273','1',1,'Retail Sale Id 3276',902.80,0.00,0.00,1.22,104.92,'2022-06-25 16:45:27','',''),(3249,'1','273','1',1,'Retail Sale Id 3277',3700.00,0.00,0.00,5.00,430.00,'2022-06-25 17:00:12','',''),(3250,'1','273','1',1,'Retail Sale Id 3278',1198.80,0.00,0.00,1.62,139.32,'2022-06-25 17:01:38','',''),(3251,'1','273','1',1,'Retail Sale Id 3279',747.40,0.00,0.00,1.01,86.86,'2022-06-25 17:03:32','',''),(3252,'1','273','1',1,'Retail Sale Id 3280',4440.00,0.00,0.00,6.00,516.00,'2022-06-25 17:10:10','',''),(3253,'1','273','1',1,'Retail Sale Id 3281',999.00,0.00,0.00,1.35,116.10,'2022-06-25 17:16:02','',''),(3254,'1','273','1',1,'Retail Sale Id 3282',8880.00,0.00,0.00,12.00,1032.00,'2022-06-25 17:19:26','',''),(3255,'1','273','1',1,'Retail Sale Id 3283',2220.00,0.00,0.00,3.00,258.00,'2022-06-25 17:20:52','',''),(3256,'1','273','1',1,'Retail Sale Id 3284',37260.00,0.00,0.00,54.00,1944.00,'2022-06-25 17:56:47','',''),(3257,'1','273','1',1,'Retail Sale Id 3285',18500.00,0.00,0.00,25.00,2150.00,'2022-06-25 17:57:27','',''),(3258,'1','273','1',1,'Retail Sale Id 3286',999.00,0.00,0.00,1.35,116.10,'2022-06-25 17:58:07','',''),(3259,'1','273','1',1,'Retail Sale Id 3287',9250.00,0.00,0.00,12.50,1075.00,'2022-06-25 17:58:54','',''),(3260,'1','273','1',1,'Retail Sale Id 3288',5180.00,0.00,0.00,7.00,602.00,'2022-06-25 18:00:09','',''),(3261,'1','273','1',1,'Retail Sale Id 3289',9250.00,0.00,0.00,12.50,1075.00,'2022-06-25 18:01:29','',''),(3262,'1','273','1',1,'Retail Sale Id 3290',4447.40,0.00,0.00,6.01,516.86,'2022-06-25 18:03:36','',''),(3263,'1','273','1',1,'Retail Sale Id 3290',34410.00,0.00,0.00,46.50,3999.00,'2022-06-25 18:03:36','',''),(3264,'1','273','1',1,'Retail Sale Id 3291',740.00,0.00,0.00,1.00,86.00,'2022-06-25 18:04:28','',''),(3265,'1','273','1',1,'Retail Sale Id 3292',2220.00,0.00,0.00,3.00,258.00,'2022-06-25 18:06:16','',''),(3266,'1','273','1',1,'Retail Sale Id 3293',3700.00,0.00,0.00,5.00,430.00,'2022-06-25 18:10:13','',''),(3267,'1','273','1',1,'Retail Sale Id 3294',1346.80,0.00,0.00,1.82,156.52,'2022-06-25 18:40:47','',''),(3268,'1','273','1',1,'Retail Sale Id 3295',2997.00,0.00,0.00,4.05,348.30,'2022-06-26 07:15:23','',''),(3269,'1','273','1',1,'Retail Sale Id 3295',5920.00,0.00,0.00,8.00,688.00,'2022-06-26 07:15:23','',''),(3270,'1','273','1',1,'Retail Sale Id 3297',103500.00,0.00,0.00,150.00,5400.00,'2022-06-26 07:18:29','',''),(3271,'1','273','1',1,'Retail Sale Id 3298',69000.00,0.00,0.00,100.00,3600.00,'2022-06-26 07:19:18','',''),(3272,'1','273','1',1,'Retail Sale Id 3299',4440.00,0.00,0.00,6.00,516.00,'2022-06-26 07:46:49','',''),(3273,'1','273','1',1,'Retail Sale Id 3299',9250.00,0.00,0.00,12.50,1075.00,'2022-06-26 07:46:50','',''),(3274,'1','273','1',1,'Retail Sale Id 3300',747.40,0.00,0.00,1.01,86.86,'2022-06-26 07:48:45','',''),(3275,'1','273','1',1,'Retail Sale Id 3301',1502.20,0.00,0.00,2.03,174.58,'2022-06-26 07:49:50','',''),(3276,'1','273','1',1,'Retail Sale Id 3302',999.00,0.00,0.00,1.35,116.10,'2022-06-26 07:50:38','',''),(3277,'1','273','1',1,'Retail Sale Id 3303',2220.00,0.00,0.00,3.00,258.00,'2022-06-26 07:59:07','',''),(3278,'1','273','1',1,'Retail Sale Id 3304',2220.00,0.00,0.00,3.00,258.00,'2022-06-26 08:00:30','',''),(3279,'1','273','1',1,'Retail Sale Id 3305',4440.00,0.00,0.00,6.00,516.00,'2022-06-26 08:01:56','',''),(3280,'1','273','1',1,'Retail Sale Id 3306',69000.00,0.00,0.00,100.00,3600.00,'2022-06-26 08:15:49','',''),(3281,'1','273','1',1,'Retail Sale Id 3308',74520.00,0.00,0.00,108.00,3888.00,'2022-06-26 08:17:28','',''),(3282,'1','273','1',1,'Retail Sale Id 3309',40020.00,0.00,0.00,58.00,2088.00,'2022-06-26 08:18:16','',''),(3283,'1','273','1',1,'Retail Sale Id 3310',103500.00,0.00,0.00,150.00,5400.00,'2022-06-26 08:19:01','',''),(3284,'1','273','1',1,'Retail Sale Id 3311',1502.20,0.00,0.00,2.03,174.58,'2022-06-26 08:20:30','',''),(3285,'1','273','1',1,'Retail Sale Id 3312',1480.00,0.00,0.00,2.00,172.00,'2022-06-26 08:27:22','',''),(3286,'1','273','1',1,'Retail Sale Id 3313',2220.00,0.00,0.00,3.00,258.00,'2022-06-26 08:32:50','',''),(3287,'1','273','1',1,'Retail Sale Id 3314',2220.00,0.00,0.00,3.00,258.00,'2022-06-26 08:49:41','',''),(3288,'1','273','1',1,'Retail Sale Id 3315',3700.00,0.00,0.00,5.00,430.00,'2022-06-26 08:53:52','',''),(3289,'1','273','1',1,'Retail Sale Id 3316',3700.00,0.00,0.00,5.00,430.00,'2022-06-26 08:55:09','',''),(3290,'1','273','1',1,'Retail Sale Id 3317',1198.80,0.00,0.00,1.62,139.32,'2022-06-26 08:58:01','',''),(3291,'1','273','1',1,'Retail Sale Id 3318',4440.00,0.00,0.00,6.00,516.00,'2022-06-26 09:03:48','',''),(3292,'1','273','1',1,'Retail Sale Id 3319',747.40,0.00,0.00,1.01,86.86,'2022-06-26 09:04:55','',''),(3293,'1','273','1',1,'Retail Sale Id 3320',2249.60,0.00,0.00,3.04,261.44,'2022-06-26 09:10:29','',''),(3294,'1','273','1',1,'Retail Sale Id 3321',9250.00,0.00,0.00,12.50,1075.00,'2022-06-26 09:22:12','',''),(3295,'1','273','1',1,'Retail Sale Id 3322',8902.20,0.00,0.00,12.03,1034.58,'2022-06-26 09:32:06','',''),(3296,'1','273','1',1,'Retail Sale Id 3323',69000.00,0.00,0.00,100.00,3600.00,'2022-06-26 10:06:45','',''),(3297,'1','273','1',1,'Retail Sale Id 3324',34500.00,0.00,0.00,50.00,1800.00,'2022-06-26 10:08:26','',''),(3298,'1','273','1',1,'Retail Sale Id 3326',9250.00,0.00,0.00,12.50,1075.00,'2022-06-26 10:15:01','',''),(3299,'1','273','1',1,'Retail Sale Id 3327',1502.20,0.00,0.00,2.03,174.58,'2022-06-26 10:17:22','',''),(3300,'1','273','1',1,'Retail Sale Id 3328',8880.00,0.00,0.00,12.00,1032.00,'2022-06-26 10:23:00','',''),(3301,'1','273','1',1,'Retail Sale Id 3329',10500.60,0.00,0.00,14.19,1220.34,'2022-06-26 10:29:56','',''),(3302,'1','273','1',1,'Retail Sale Id 3330',999.00,0.00,0.00,1.35,116.10,'2022-06-26 10:44:28','',''),(3303,'1','273','1',1,'Retail Sale Id 3331',999.00,0.00,0.00,1.35,116.10,'2022-06-26 10:44:56','',''),(3304,'1','273','1',1,'Retail Sale Id 3332',902.80,0.00,0.00,1.22,104.92,'2022-06-26 10:50:49','',''),(3305,'1','273','1',1,'Retail Sale Id 3333',5180.00,0.00,0.00,7.00,602.00,'2022-06-26 11:02:09','',''),(3306,'1','273','1',1,'Retail Sale Id 3334',999.00,0.00,0.00,1.35,116.10,'2022-06-26 11:03:08','',''),(3307,'1','273','1',1,'Retail Sale Id 3335',1502.20,0.00,0.00,2.03,174.58,'2022-06-26 11:04:13','',''),(3308,'1','273','1',1,'Retail Sale Id 3336',1502.20,0.00,0.00,2.03,174.58,'2022-06-26 11:17:29','',''),(3309,'1','273','1',1,'Retail Sale Id 3337',3196.80,0.00,0.00,4.32,371.52,'2022-06-26 11:26:46','',''),(3310,'1','273','1',1,'Retail Sale Id 3338',15994.20,0.00,0.00,23.18,834.48,'2022-06-26 11:38:08','',''),(3311,'1','273','1',1,'Retail Sale Id 3339',1998.00,0.00,0.00,2.70,232.20,'2022-06-26 11:38:48','',''),(3312,'1','273','1',1,'Retail Sale Id 3340',10360.00,0.00,0.00,14.00,1204.00,'2022-06-26 11:50:08','',''),(3313,'1','273','1',1,'Retail Sale Id 3341',999.00,0.00,0.00,1.35,116.10,'2022-06-26 11:56:27','',''),(3314,'1','273','1',1,'Retail Sale Id 3342',2220.00,0.00,0.00,3.00,258.00,'2022-06-26 11:57:00','',''),(3315,'1','273','1',1,'Retail Sale Id 3343',999.00,0.00,0.00,1.35,116.10,'2022-06-26 12:04:52','',''),(3316,'1','273','1',1,'Retail Sale Id 3344',4440.00,0.00,0.00,6.00,516.00,'2022-06-26 12:24:18','',''),(3317,'1','273','1',1,'Retail Sale Id 3345',33499.50,0.00,0.00,48.55,1747.80,'2022-06-26 12:27:20','',''),(3318,'1','273','1',1,'Retail Sale Id 3346',999.00,0.00,0.00,1.35,116.10,'2022-06-26 12:29:08','',''),(3319,'1','273','1',1,'Retail Sale Id 3347',1998.00,0.00,0.00,2.70,232.20,'2022-06-26 12:45:24','',''),(3320,'1','273','1',1,'Retail Sale Id 3349',7400.00,0.00,0.00,10.00,860.00,'2022-06-26 13:13:53','',''),(3321,'1','273','1',1,'Retail Sale Id 3350',18500.00,0.00,0.00,25.00,2150.00,'2022-06-26 13:18:13','',''),(3322,'1','273','1',1,'Retail Sale Id 3351',3700.00,0.00,0.00,5.00,430.00,'2022-06-26 13:21:50','',''),(3323,'1','273','1',1,'Retail Sale Id 3352',3700.00,0.00,0.00,5.00,430.00,'2022-06-26 13:34:37','',''),(3324,'1','273','1',1,'Retail Sale Id 3353',8273.20,0.00,0.00,11.18,961.48,'2022-06-26 13:42:07','',''),(3325,'1','273','1',1,'Retail Sale Id 3354',82800.00,0.00,0.00,120.00,4320.00,'2022-06-26 14:02:23','',''),(3326,'1','273','1',1,'Retail Sale Id 3355',82800.00,0.00,0.00,120.00,4320.00,'2022-06-26 14:03:04','',''),(3327,'1','273','1',1,'Retail Sale Id 3356',999.00,0.00,0.00,1.35,116.10,'2022-06-26 14:13:07','',''),(3328,'1','273','1',1,'Retail Sale Id 3357',5002.40,0.00,0.00,6.76,581.36,'2022-06-26 14:20:01','',''),(3329,'1','273','1',1,'Retail Sale Id 3358',1998.00,0.00,0.00,2.70,232.20,'2022-06-26 14:26:59','',''),(3330,'1','273','1',1,'Retail Sale Id 3359',34500.00,0.00,0.00,50.00,1800.00,'2022-06-26 14:29:13','',''),(3331,'1','273','1',1,'Retail Sale Id 3360',4440.00,0.00,0.00,6.00,516.00,'2022-06-26 14:36:46','',''),(3332,'1','273','1',1,'Retail Sale Id 3361',747.40,0.00,0.00,1.01,86.86,'2022-06-26 14:38:20','',''),(3333,'1','273','1',1,'Retail Sale Id 3362',9250.00,0.00,0.00,12.50,1075.00,'2022-06-26 14:41:16','',''),(3334,'1','273','1',1,'Retail Sale Id 3363',1502.20,0.00,0.00,2.03,174.58,'2022-06-26 14:45:27','',''),(3335,'1','273','1',1,'Retail Sale Id 3364',9250.00,0.00,0.00,12.50,1075.00,'2022-06-26 14:47:02','',''),(3336,'1','273','1',1,'Retail Sale Id 3365',9250.00,0.00,0.00,12.50,1075.00,'2022-06-26 14:48:53','',''),(3337,'1','273','1',1,'Retail Sale Id 3367',4499.20,0.00,0.00,6.08,522.88,'2022-06-26 14:55:27','',''),(3338,'1','273','1',1,'Retail Sale Id 3368',2220.00,0.00,0.00,3.00,258.00,'2022-06-26 14:58:30','',''),(3339,'1','273','1',1,'Retail Sale Id 3369',69000.00,0.00,0.00,100.00,3600.00,'2022-06-26 15:01:26','',''),(3340,'1','273','1',1,'Retail Sale Id 3370',3700.00,0.00,0.00,5.00,430.00,'2022-06-26 15:02:20','',''),(3341,'1','273','1',1,'Retail Sale Id 3371',3500.20,0.00,0.00,4.73,406.78,'2022-06-26 15:03:31','',''),(3342,'1','273','1',1,'Retail Sale Id 3372',2997.00,0.00,0.00,4.05,348.30,'2022-06-26 15:10:33','',''),(3343,'1','273','1',1,'Retail Sale Id 3373',747.40,0.00,0.00,1.01,86.86,'2022-06-26 15:15:55','',''),(3344,'1','273','1',1,'Retail Sale Id 3374',999.00,0.00,0.00,1.35,116.10,'2022-06-26 15:30:42','',''),(3345,'1','273','1',1,'Retail Sale Id 3375',1502.20,0.00,0.00,2.03,174.58,'2022-06-26 15:47:29','',''),(3346,'1','273','1',1,'Retail Sale Id 3376',3700.00,0.00,0.00,5.00,430.00,'2022-06-26 15:49:14','',''),(3347,'1','273','1',1,'Retail Sale Id 3376',6660.00,0.00,0.00,9.00,774.00,'2022-06-26 15:49:14','',''),(3348,'1','273','1',1,'Retail Sale Id 3377',1998.00,0.00,0.00,2.70,232.20,'2022-06-26 16:01:31','',''),(3349,'1','273','1',1,'Retail Sale Id 3378',7400.00,0.00,0.00,10.00,860.00,'2022-06-26 16:05:02','',''),(3350,'1','273','1',1,'Retail Sale Id 3379',8880.00,0.00,0.00,12.00,1032.00,'2022-06-26 16:06:27','',''),(3351,'1','273','1',1,'Retail Sale Id 3380',999.00,0.00,0.00,1.35,116.10,'2022-06-26 16:11:03','',''),(3352,'1','273','1',1,'Retail Sale Id 3381',5498.20,0.00,0.00,7.43,638.98,'2022-06-26 16:12:47','',''),(3353,'1','273','1',1,'Retail Sale Id 3382',4440.00,0.00,0.00,6.00,516.00,'2022-06-26 16:14:14','',''),(3354,'1','273','1',1,'Retail Sale Id 3383',799.20,0.00,0.00,1.08,92.88,'2022-06-26 16:21:59','',''),(3355,'1','273','1',1,'Retail Sale Id 3384',3700.00,0.00,0.00,5.00,430.00,'2022-06-26 16:23:57','',''),(3356,'1','273','1',1,'Retail Sale Id 3385',747.40,0.00,0.00,1.01,86.86,'2022-06-26 16:24:43','',''),(3357,'1','273','1',1,'Retail Sale Id 3386',1502.20,0.00,0.00,2.03,174.58,'2022-06-26 16:29:11','',''),(3358,'1','273','1',1,'Retail Sale Id 3387',2249.60,0.00,0.00,3.04,261.44,'2022-06-26 16:37:15','',''),(3359,'1','273','1',1,'Retail Sale Id 3388',1998.00,0.00,0.00,2.70,232.20,'2022-06-26 16:40:01','',''),(3360,'1','273','1',1,'Retail Sale Id 3389',999.00,0.00,0.00,1.35,116.10,'2022-06-26 16:45:56','',''),(3361,'1','273','1',1,'Retail Sale Id 3390',1480.00,0.00,0.00,2.00,172.00,'2022-06-26 16:58:15','',''),(3362,'1','273','1',1,'Retail Sale Id 3391',2501.20,0.00,0.00,3.38,290.68,'2022-06-26 17:00:13','',''),(3363,'1','273','1',1,'Retail Sale Id 3392',799.20,0.00,0.00,1.08,92.88,'2022-06-26 17:01:44','',''),(3364,'1','273','1',1,'Retail Sale Id 3393',1502.20,0.00,0.00,2.03,174.58,'2022-06-26 17:04:30','',''),(3365,'1','273','1',1,'Retail Sale Id 3394',999.00,0.00,0.00,1.35,116.10,'2022-06-26 17:12:26','',''),(3366,'1','273','1',1,'Retail Sale Id 3395',999.00,0.00,0.00,1.35,116.10,'2022-06-26 17:13:33','',''),(3367,'1','273','1',1,'Retail Sale Id 3396',2220.00,0.00,0.00,3.00,258.00,'2022-06-26 17:35:04','',''),(3368,'1','273','1',1,'Retail Sale Id 3397',799.20,0.00,0.00,1.08,92.88,'2022-06-26 17:36:54','',''),(3369,'1','273','1',1,'Retail Sale Id 3398',3700.00,0.00,0.00,5.00,430.00,'2022-06-26 17:41:50','',''),(3370,'1','273','1',1,'Retail Sale Id 3399',747.40,0.00,0.00,1.01,86.86,'2022-06-26 17:51:31','',''),(3371,'1','273','1',1,'Retail Sale Id 3400',3700.00,0.00,0.00,5.00,430.00,'2022-06-26 17:56:54','',''),(3372,'1','273','1',1,'Retail Sale Id 3401',747.40,0.00,0.00,1.01,86.86,'2022-06-26 17:59:54','',''),(3373,'1','273','1',1,'Return of Retail Sale Id 3398',0.00,3700.00,5.00,0.00,-430.00,'2022-06-26 18:46:22','',''),(3374,'1','273','1',1,'Retail Sale Id 3402',3196.80,0.00,0.00,4.32,371.52,'2022-06-26 18:47:04','',''),(3375,'1','273','1',1,'Retail Sale Id 3403',2960.00,0.00,0.00,4.00,344.00,'2022-06-27 06:51:38','',''),(3376,'1','273','1',1,'Retail Sale Id 3404',72450.00,0.00,0.00,105.00,3780.00,'2022-06-27 06:53:53','',''),(3377,'1','273','1',1,'Retail Sale Id 3405',799.20,0.00,0.00,1.08,92.88,'2022-06-27 06:54:46','',''),(3378,'1','273','1',1,'Retail Sale Id 3406',740.00,0.00,0.00,1.00,86.00,'2022-06-27 06:59:18','',''),(3379,'1','273','1',1,'Retail Sale Id 3407',999.00,0.00,0.00,1.35,116.10,'2022-06-27 07:02:55','',''),(3380,'1','273','1',1,'Retail Sale Id 3408',83496.90,0.00,0.00,121.01,4356.36,'2022-06-27 07:29:31','',''),(3381,'1','273','1',1,'Retail Sale Id 3409',7400.00,0.00,0.00,10.00,860.00,'2022-06-27 07:30:09','',''),(3382,'1','273','1',1,'Retail Sale Id 3410',34500.00,0.00,0.00,50.00,1800.00,'2022-06-27 07:36:29','',''),(3383,'1','273','1',1,'Retail Sale Id 3411',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 07:40:26','',''),(3384,'1','273','1',1,'Retail Sale Id 3412',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 08:03:28','',''),(3385,'1','273','1',1,'Retail Sale Id 3413',2197.80,0.00,0.00,2.97,255.42,'2022-06-27 08:11:39','',''),(3386,'1','273','1',1,'Retail Sale Id 3414',999.00,0.00,0.00,1.35,116.10,'2022-06-27 08:12:49','',''),(3387,'1','273','1',1,'Retail Sale Id 3414',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 08:12:49','',''),(3388,'1','273','1',1,'Retail Sale Id 3415',999.00,0.00,0.00,1.35,116.10,'2022-06-27 08:24:38','',''),(3389,'1','273','1',1,'Retail Sale Id 3416',69000.00,0.00,0.00,100.00,3600.00,'2022-06-27 08:26:35','',''),(3390,'1','273','1',1,'Retail Sale Id 3417',1480.00,0.00,0.00,2.00,172.00,'2022-06-27 08:38:18','',''),(3391,'1','273','1',1,'Retail Sale Id 3418',2997.00,0.00,0.00,4.05,348.30,'2022-06-27 08:40:03','',''),(3392,'1','273','1',1,'Retail Sale Id 3419',103500.00,0.00,0.00,150.00,5400.00,'2022-06-27 08:41:09','',''),(3393,'1','273','1',1,'Retail Sale Id 3420',69000.00,0.00,0.00,100.00,3600.00,'2022-06-27 08:42:04','',''),(3394,'1','273','1',1,'Retail Sale Id 3421',2220.00,0.00,0.00,3.00,258.00,'2022-06-27 09:03:56','',''),(3395,'1','273','1',1,'Retail Sale Id 3422',4003.40,0.00,0.00,5.41,465.26,'2022-06-27 09:15:14','',''),(3396,'1','273','1',1,'Retail Sale Id 3423',7400.00,0.00,0.00,10.00,860.00,'2022-06-27 09:23:53','',''),(3397,'1','273','1',1,'Retail Sale Id 3424',7400.00,0.00,0.00,10.00,860.00,'2022-06-27 09:34:39','',''),(3398,'1','273','1',1,'Retail Sale Id 3425',7400.00,0.00,0.00,10.00,860.00,'2022-06-27 09:35:52','',''),(3399,'1','273','1',1,'Retail Sale Id 3426',5180.00,0.00,0.00,7.00,602.00,'2022-06-27 09:46:14','',''),(3400,'1','273','1',1,'Retail Sale Id 3427',747.40,0.00,0.00,1.01,86.86,'2022-06-27 09:56:53','',''),(3401,'1','273','1',1,'Retail Sale Id 3428',999.00,0.00,0.00,1.35,116.10,'2022-06-27 10:02:57','',''),(3402,'1','273','1',1,'Retail Sale Id 3429',9250.00,0.00,0.00,12.50,1075.00,'2022-06-27 10:04:34','',''),(3403,'1','273','1',1,'Retail Sale Id 3430',2701.00,0.00,0.00,3.65,313.90,'2022-06-27 10:13:25','',''),(3404,'1','273','1',1,'Retail Sale Id 3431',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 10:14:34','',''),(3405,'1','273','1',1,'Retail Sale Id 3432',2249.60,0.00,0.00,3.04,261.44,'2022-06-27 10:16:04','',''),(3406,'1','273','1',1,'Retail Sale Id 3433',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 10:25:10','',''),(3407,'1','273','1',1,'Retail Sale Id 3434',1480.00,0.00,0.00,2.00,172.00,'2022-06-27 10:26:39','',''),(3408,'1','273','1',1,'Retail Sale Id 3435',1480.00,0.00,0.00,2.00,172.00,'2022-06-27 10:39:51','',''),(3409,'1','273','1',1,'Retail Sale Id 3436',747.40,0.00,0.00,1.01,86.86,'2022-06-27 10:40:55','',''),(3410,'1','273','1',1,'Retail Sale Id 3437',1998.00,0.00,0.00,2.70,232.20,'2022-06-27 10:52:43','',''),(3411,'1','273','1',1,'Retail Sale Id 3438',13800.00,0.00,0.00,20.00,720.00,'2022-06-27 10:54:06','',''),(3412,'1','273','1',1,'Retail Sale Id 3439',6001.40,0.00,0.00,8.11,697.46,'2022-06-27 10:54:55','',''),(3413,'1','273','1',1,'Retail Sale Id 3440',4440.00,0.00,0.00,6.00,516.00,'2022-06-27 10:55:42','',''),(3414,'1','273','1',1,'Retail Sale Id 3441',9250.00,0.00,0.00,12.50,1075.00,'2022-06-27 11:01:07','',''),(3415,'1','273','1',1,'Retail Sale Id 3442',13320.00,0.00,0.00,18.00,1548.00,'2022-06-27 11:05:30','',''),(3416,'1','273','1',1,'Retail Sale Id 3443',9250.00,0.00,0.00,12.50,1075.00,'2022-06-27 11:06:24','',''),(3417,'1','273','1',1,'Retail Sale Id 3444',99360.00,0.00,0.00,144.00,5184.00,'2022-06-27 11:08:10','',''),(3418,'1','273','1',1,'Retail Sale Id 3445',82800.00,0.00,0.00,120.00,4320.00,'2022-06-27 11:08:57','',''),(3419,'1','273','1',1,'Retail Sale Id 3446',999.00,0.00,0.00,1.35,116.10,'2022-06-27 11:10:03','',''),(3420,'1','273','1',1,'Retail Sale Id 3447',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 11:21:58','',''),(3421,'1','273','1',1,'Retail Sale Id 3448',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 11:22:48','',''),(3422,'1','273','1',1,'Retail Sale Id 3449',2997.00,0.00,0.00,4.05,348.30,'2022-06-27 11:27:53','',''),(3423,'1','273','1',1,'Retail Sale Id 3450',2997.00,0.00,0.00,4.05,348.30,'2022-06-27 11:35:45','',''),(3424,'1','273','1',1,'Retail Sale Id 3451',4447.40,0.00,0.00,6.01,516.86,'2022-06-27 11:37:51','',''),(3425,'1','273','1',1,'Retail Sale Id 3452',78660.00,0.00,0.00,114.00,4104.00,'2022-06-27 11:52:22','',''),(3426,'1','273','1',1,'Retail Sale Id 3453',48645.00,0.00,0.00,70.50,2538.00,'2022-06-27 11:57:59','',''),(3427,'1','273','1',1,'Retail Sale Id 3454',20700.00,0.00,0.00,30.00,1080.00,'2022-06-27 12:10:47','',''),(3428,'1','273','1',1,'Retail Sale Id 3455',747.40,0.00,0.00,1.01,86.86,'2022-06-27 12:29:13','',''),(3429,'1','273','1',1,'Retail Sale Id 3456',22940.00,0.00,0.00,31.00,2666.00,'2022-06-27 12:46:37','',''),(3430,'1','273','1',1,'Retail Sale Id 3457',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 12:50:49','',''),(3431,'1','273','1',1,'Retail Sale Id 3458',1798.20,0.00,0.00,2.43,208.98,'2022-06-27 13:09:25','',''),(3432,'1','273','1',1,'Retail Sale Id 3459',999.00,0.00,0.00,1.35,116.10,'2022-06-27 13:16:23','',''),(3433,'1','273','1',1,'Retail Sale Id 3460',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 13:26:58','',''),(3434,'1','273','1',1,'Retail Sale Id 3461',1398.60,0.00,0.00,1.89,162.54,'2022-06-27 13:35:45','',''),(3435,'1','273','1',1,'Retail Sale Id 3462',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 13:46:45','',''),(3436,'1','273','1',1,'Retail Sale Id 3463',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 14:41:37','',''),(3437,'1','273','1',1,'Retail Sale Id 3464',103500.00,0.00,0.00,150.00,5400.00,'2022-06-27 14:44:15','',''),(3438,'1','273','1',1,'Retail Sale Id 3465',69000.00,0.00,0.00,100.00,3600.00,'2022-06-27 14:45:05','',''),(3439,'1','273','1',1,'Retail Sale Id 3466',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 14:51:03','',''),(3440,'1','273','1',1,'Retail Sale Id 3467',5202.20,0.00,0.00,7.03,604.58,'2022-06-27 14:55:49','',''),(3441,'1','273','1',1,'Retail Sale Id 3468',999.00,0.00,0.00,1.35,116.10,'2022-06-27 14:56:50','',''),(3442,'1','273','1',1,'Retail Sale Id 3469',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 14:58:30','',''),(3443,'1','273','1',1,'Retail Sale Id 3470',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 15:00:29','',''),(3444,'1','273','1',1,'Retail Sale Id 3471',1998.00,0.00,0.00,2.70,232.20,'2022-06-27 15:03:12','',''),(3445,'1','273','1',1,'Retail Sale Id 3472',799.20,0.00,0.00,1.08,92.88,'2022-06-27 15:07:14','',''),(3446,'1','273','1',1,'Retail Sale Id 3473',2249.60,0.00,0.00,3.04,261.44,'2022-06-27 15:13:39','',''),(3447,'1','273','1',1,'Retail Sale Id 3474',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 15:26:00','',''),(3448,'1','273','1',1,'Retail Sale Id 3475',33300.00,0.00,0.00,45.00,3870.00,'2022-06-27 15:28:10','',''),(3449,'1','273','1',1,'Retail Sale Id 3476',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 15:29:51','',''),(3450,'1','273','1',1,'Retail Sale Id 3477',4003.40,0.00,0.00,5.41,465.26,'2022-06-27 15:38:58','',''),(3451,'1','273','1',1,'Retail Sale Id 3478',747.40,0.00,0.00,1.01,86.86,'2022-06-27 15:40:10','',''),(3452,'1','273','1',1,'Retail Sale Id 3479',2249.60,0.00,0.00,3.04,261.44,'2022-06-27 15:41:33','',''),(3453,'1','273','1',1,'Retail Sale Id 3480',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 15:55:25','',''),(3454,'1','273','1',1,'Retail Sale Id 3480',7400.00,0.00,0.00,10.00,860.00,'2022-06-27 15:55:25','',''),(3455,'1','273','1',1,'Retail Sale Id 3480',8880.00,0.00,0.00,12.00,1032.00,'2022-06-27 15:55:25','',''),(3456,'1','273','1',1,'Retail Sale Id 3481',2220.00,0.00,0.00,3.00,258.00,'2022-06-27 16:05:54','',''),(3457,'1','273','1',1,'Retail Sale Id 3482',902.80,0.00,0.00,1.22,104.92,'2022-06-27 16:11:45','',''),(3458,'1','273','1',1,'Retail Sale Id 3483',740.00,0.00,0.00,1.00,86.00,'2022-06-27 16:12:45','',''),(3459,'1','273','1',1,'Retail Sale Id 3484',9250.00,0.00,0.00,12.50,1075.00,'2022-06-27 16:13:19','',''),(3460,'1','273','1',1,'Retail Sale Id 3486',999.00,0.00,0.00,1.35,116.10,'2022-06-27 16:14:21','',''),(3461,'1','273','1',1,'Retail Sale Id 3487',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 16:16:53','',''),(3462,'1','273','1',1,'Retail Sale Id 3488',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 16:27:58','',''),(3463,'1','273','1',1,'Retail Sale Id 3489',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 16:29:18','',''),(3464,'1','273','1',1,'Retail Sale Id 3490',2997.00,0.00,0.00,4.05,348.30,'2022-06-27 16:30:18','',''),(3465,'1','273','1',1,'Retail Sale Id 3491',7400.00,0.00,0.00,10.00,860.00,'2022-06-27 16:38:46','',''),(3466,'1','273','1',1,'Retail Sale Id 3492',4440.00,0.00,0.00,6.00,516.00,'2022-06-27 16:39:42','',''),(3467,'1','273','1',1,'Retail Sale Id 3493',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 16:41:53','',''),(3468,'1','273','1',1,'Retail Sale Id 3494',747.40,0.00,0.00,1.01,86.86,'2022-06-27 16:43:31','',''),(3469,'1','273','1',1,'Retail Sale Id 3495',9250.00,0.00,0.00,12.50,1075.00,'2022-06-27 16:45:58','',''),(3470,'1','273','1',1,'Retail Sale Id 3496',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 16:47:02','',''),(3471,'1','273','1',1,'Retail Sale Id 3497',2220.00,0.00,0.00,3.00,258.00,'2022-06-27 16:48:16','',''),(3472,'1','273','1',1,'Retail Sale Id 3498',1147.00,0.00,0.00,1.55,133.30,'2022-06-27 16:54:59','',''),(3473,'1','273','1',1,'Retail Sale Id 3499',7000.40,0.00,0.00,9.46,813.56,'2022-06-27 16:57:34','',''),(3474,'1','273','1',1,'Retail Sale Id 3500',999.00,0.00,0.00,1.35,116.10,'2022-06-27 17:02:24','',''),(3475,'1','273','1',1,'Retail Sale Id 3501',9250.00,0.00,0.00,12.50,1075.00,'2022-06-27 17:03:30','',''),(3476,'1','273','1',1,'Retail Sale Id 3502',9250.00,0.00,0.00,12.50,1075.00,'2022-06-27 17:04:45','',''),(3477,'1','273','1',1,'Retail Sale Id 3503',8140.00,0.00,0.00,11.00,946.00,'2022-06-27 17:06:55','',''),(3478,'1','273','1',1,'Retail Sale Id 3504',2249.60,0.00,0.00,3.04,261.44,'2022-06-27 17:15:32','',''),(3479,'1','273','1',1,'Retail Sale Id 3505',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 17:21:30','',''),(3480,'1','273','1',1,'Retail Sale Id 3506',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 17:23:15','',''),(3481,'1','273','1',1,'Retail Sale Id 3507',82800.00,0.00,0.00,120.00,4320.00,'2022-06-27 17:24:37','',''),(3482,'1','273','1',1,'Retail Sale Id 3508',41400.00,0.00,0.00,60.00,2160.00,'2022-06-27 17:25:20','',''),(3483,'1','273','1',1,'Retail Sale Id 3509',747.40,0.00,0.00,1.01,86.86,'2022-06-27 17:26:04','',''),(3484,'1','273','1',1,'Retail Sale Id 3510',740.00,0.00,0.00,1.00,86.00,'2022-06-27 17:32:03','',''),(3485,'1','273','1',1,'Retail Sale Id 3511',41400.00,0.00,0.00,60.00,2160.00,'2022-06-27 17:33:04','',''),(3486,'1','273','1',1,'Retail Sale Id 3512',747.40,0.00,0.00,1.01,86.86,'2022-06-27 17:42:26','',''),(3487,'1','273','1',1,'Retail Sale Id 3513',64170.00,0.00,0.00,93.00,3348.00,'2022-06-27 17:55:53','',''),(3488,'1','273','1',1,'Retail Sale Id 3514',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 17:58:32','',''),(3489,'1','273','1',1,'Retail Sale Id 3515',747.40,0.00,0.00,1.01,86.86,'2022-06-27 18:02:29','',''),(3490,'1','273','1',1,'Retail Sale Id 3516',999.00,0.00,0.00,1.35,116.10,'2022-06-27 18:04:46','',''),(3491,'1','273','1',1,'Retail Sale Id 3517',17250.00,0.00,0.00,25.00,900.00,'2022-06-27 18:06:07','',''),(3492,'1','273','1',1,'Retail Sale Id 3518',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 18:10:20','',''),(3493,'1','273','1',1,'Retail Sale Id 3519',2220.00,0.00,0.00,3.00,258.00,'2022-06-27 18:13:49','',''),(3494,'1','273','1',1,'Retail Sale Id 3520',4003.40,0.00,0.00,5.41,465.26,'2022-06-27 18:15:20','',''),(3495,'1','273','1',1,'Retail Sale Id 3521',2997.00,0.00,0.00,4.05,348.30,'2022-06-27 18:16:12','',''),(3496,'1','273','1',1,'Retail Sale Id 3522',3700.00,0.00,0.00,5.00,430.00,'2022-06-27 18:19:05','',''),(3497,'1','273','1',1,'Retail Sale Id 3523',999.00,0.00,0.00,1.35,116.10,'2022-06-27 18:25:19','',''),(3498,'1','273','1',1,'Retail Sale Id 3524',1502.20,0.00,0.00,2.03,174.58,'2022-06-27 18:28:01','',''),(3499,'1','273','1',1,'Return of Retail Sale Id 3505',0.00,3700.00,5.00,0.00,-430.00,'2022-06-27 19:00:04','',''),(3500,'1','273','1',1,'Retail Sale Id 3525',3196.80,0.00,0.00,4.32,371.52,'2022-06-27 19:00:44','',''),(3501,'1','273','1',1,'Retail Sale Id 3526',1502.20,0.00,0.00,2.03,174.58,'2022-06-28 07:09:29','',''),(3502,'1','273','1',1,'Retail Sale Id 3527',67620.00,0.00,0.00,98.00,3528.00,'2022-06-28 07:16:40','',''),(3503,'1','273','1',1,'Retail Sale Id 3528',40020.00,0.00,0.00,58.00,2088.00,'2022-06-28 07:17:37','',''),(3504,'1','273','1',1,'Retail Sale Id 3529',3500.20,0.00,0.00,4.73,406.78,'2022-06-28 07:24:18','',''),(3505,'1','273','1',1,'Retail Sale Id 3530',9250.00,0.00,0.00,12.50,1075.00,'2022-06-28 07:43:48','',''),(3506,'1','273','1',1,'Retail Sale Id 3531',34500.00,0.00,0.00,50.00,1800.00,'2022-06-28 07:46:29','',''),(3507,'1','273','1',1,'Retail Sale Id 3532',3700.00,0.00,0.00,5.00,430.00,'2022-06-28 08:02:41','',''),(3508,'1','273','1',1,'Retail Sale Id 3533',1502.20,0.00,0.00,2.03,174.58,'2022-06-28 08:05:19','',''),(3509,'1','273','1',1,'Retail Sale Id 3534',2220.00,0.00,0.00,3.00,258.00,'2022-06-28 08:19:02','',''),(3510,'1','273','1',1,'Retail Sale Id 3535',3700.00,0.00,0.00,5.00,430.00,'2022-06-28 08:30:17','',''),(3511,'1','273','1',1,'Retail Sale Id 3536',2227.40,0.00,0.00,3.01,258.86,'2022-06-28 08:37:32','',''),(3512,'1','273','1',1,'Retail Sale Id 3537',31740.00,0.00,0.00,46.00,1656.00,'2022-06-28 08:42:28','',''),(3513,'1','273','1',1,'Retail Sale Id 3538',34500.00,0.00,0.00,50.00,1800.00,'2022-06-28 08:47:37','',''),(3514,'1','273','1',1,'Retail Sale Id 3539',999.00,0.00,0.00,1.35,116.10,'2022-06-28 08:57:27','',''),(3515,'1','273','1',1,'Retail Sale Id 3540',8140.00,0.00,0.00,11.00,946.00,'2022-06-28 08:58:58','',''),(3516,'1','273','1',1,'Retail Sale Id 3541',2249.60,0.00,0.00,3.04,261.44,'2022-06-28 09:00:39','',''),(3517,'1','273','1',1,'Retail Sale Id 3542',33810.00,0.00,0.00,49.00,1764.00,'2022-06-28 09:21:49','',''),(3518,'1','273','1',1,'Retail Sale Id 3543',4440.00,0.00,0.00,6.00,516.00,'2022-06-28 09:30:04','',''),(3519,'1','273','1',1,'Retail Sale Id 3544',34500.00,0.00,0.00,50.00,1800.00,'2022-06-28 09:33:31','',''),(3520,'1','273','1',1,'Retail Sale Id 3546',2301.40,0.00,0.00,3.11,267.46,'2022-06-28 09:49:19','',''),(3521,'1','273','1',1,'Retail Sale Id 3547',103500.00,0.00,0.00,150.00,5400.00,'2022-06-28 10:01:16','',''),(3522,'1','273','1',1,'Retail Sale Id 3548',69000.00,0.00,0.00,100.00,3600.00,'2022-06-28 10:02:38','',''),(3523,'1','273','1',1,'Retail Sale Id 3549',2960.00,0.00,0.00,4.00,344.00,'2022-06-28 10:28:40','',''),(3524,'1','273','1',1,'Retail Sale Id 3550',5180.00,0.00,0.00,7.00,602.00,'2022-06-28 10:50:46','',''),(3525,'1','273','1',1,'Retail Sale Id 3551',3700.00,0.00,0.00,5.00,430.00,'2022-06-28 11:05:49','',''),(3526,'1','273','1',1,'Retail Sale Id 3552',747.40,0.00,0.00,1.01,86.86,'2022-06-28 11:08:57','',''),(3527,'1','273','1',1,'Retail Sale Id 3553',747.40,0.00,0.00,1.01,86.86,'2022-06-28 11:25:11','',''),(3528,'1','273','1',1,'Retail Sale Id 3554',86250.00,0.00,0.00,125.00,4500.00,'2022-06-28 11:32:48','',''),(3529,'1','273','1',1,'Retail Sale Id 3555',86250.00,0.00,0.00,125.00,4500.00,'2022-06-28 11:33:50','',''),(3530,'1','273','1',1,'Retail Sale Id 3556',5180.00,0.00,0.00,7.00,602.00,'2022-06-28 11:35:17','',''),(3531,'1','273','1',1,'Retail Sale Id 3557',15870.00,0.00,0.00,23.00,828.00,'2022-06-28 11:36:33','',''),(3532,'1','273','1',1,'Retail Sale Id 3558',9250.00,0.00,0.00,12.50,1075.00,'2022-06-28 11:37:49','',''),(3533,'1','273','1',1,'Retail Sale Id 3559',9250.00,0.00,0.00,12.50,1075.00,'2022-06-28 11:43:49','',''),(3534,'1','273','1',1,'Retail Sale Id 3560',4003.40,0.00,0.00,5.41,465.26,'2022-06-28 11:48:21','',''),(3535,'1','273','1',1,'Retail Sale Id 3561',2997.00,0.00,0.00,4.05,348.30,'2022-06-28 11:53:20','',''),(3536,'1','273','1',1,'Retail Sale Id 3562',9250.00,0.00,0.00,12.50,1075.00,'2022-06-28 11:58:08','',''),(3537,'1','273','1',1,'Retail Sale Id 3563',37950.00,0.00,0.00,55.00,1980.00,'2022-06-28 12:04:36','',''),(3538,'1','273','1',1,'Retail Sale Id 3564',82800.00,0.00,0.00,120.00,4320.00,'2022-06-28 12:05:31','',''),(3539,'1','273','1',1,'Retail Sale Id 3565',1502.20,0.00,0.00,2.03,174.58,'2022-06-28 12:39:01','',''),(3540,'1','273','1',1,'Retail Sale Id 3566',24150.00,0.00,0.00,35.00,1260.00,'2022-06-28 12:58:59','',''),(3541,'1','273','1',1,'Retail Sale Id 3567',4440.00,0.00,0.00,6.00,516.00,'2022-06-28 13:24:28','',''),(3542,'1','273','1',1,'Retail Sale Id 3568',2997.00,0.00,0.00,4.05,348.30,'2022-06-28 14:10:31','',''),(3543,'1','273','1',1,'Retail Sale Id 3569',999.00,0.00,0.00,1.35,116.10,'2022-06-28 14:14:29','',''),(3544,'1','273','1',1,'Retail Sale Id 3570',5920.00,0.00,0.00,8.00,688.00,'2022-06-28 14:15:39','',''),(3545,'1','273','1',1,'Retail Sale Id 3571',5180.00,0.00,0.00,7.00,602.00,'2022-06-28 14:21:07','',''),(3546,'1','273','1',1,'Retail Sale Id 3572',4440.00,0.00,0.00,6.00,516.00,'2022-06-28 14:22:11','',''),(3547,'1','273','1',1,'Retail Sale Id 3573',3700.00,0.00,0.00,5.00,430.00,'2022-06-28 14:28:18','',''),(3548,'1','273','1',1,'Retail Sale Id 3574',747.40,0.00,0.00,1.01,86.86,'2022-06-28 14:33:32','',''),(3549,'1','273','1',1,'Retail Sale Id 3575',6660.00,0.00,0.00,9.00,774.00,'2022-06-28 14:44:34','',''),(3550,'1','273','1',1,'Retail Sale Id 3576',9301.80,0.00,0.00,12.57,1081.02,'2022-06-28 14:47:04','',''),(3551,'1','273','1',1,'Retail Sale Id 3577',3700.00,0.00,0.00,5.00,430.00,'2022-06-28 15:05:51','',''),(3552,'1','273','1',1,'Retail Sale Id 3578',5002.40,0.00,0.00,6.76,581.36,'2022-06-28 15:11:52','',''),(3553,'1','273','1',1,'Retail Sale Id 3579',2301.40,0.00,0.00,3.11,267.46,'2022-06-28 15:30:52','',''),(3554,'1','273','1',1,'Retail Sale Id 3580',4003.40,0.00,0.00,5.41,465.26,'2022-06-28 15:38:48','',''),(3555,'1','273','1',1,'Retail Sale Id 3581',740.00,0.00,0.00,1.00,86.00,'2022-06-28 15:40:18','',''),(3556,'1','273','1',1,'Retail Sale Id 3582',2220.00,0.00,0.00,3.00,258.00,'2022-06-28 17:05:23','',''),(3557,'1','273','1',1,'Retail Sale Id 3583',999.00,0.00,0.00,1.35,116.10,'2022-06-28 18:15:19','',''),(3558,'1','273','1',1,'Retail Sale Id 3584',7400.00,0.00,0.00,10.00,860.00,'2022-06-28 18:16:27','',''),(3559,'1','273','1',1,'Return of Retail Sale Id 3538',0.00,34500.00,50.00,0.00,-1800.00,'2022-06-28 18:38:04','',''),(3560,'1','273','1',1,'Retail Sale Id 3585',32775.00,0.00,0.00,47.50,1710.00,'2022-06-28 18:39:21','',''),(3561,'1','273','1',1,'Return of Retail Sale Id 3565',0.00,1502.20,2.03,0.00,-174.58,'2022-06-28 18:40:58','',''),(3562,'1','273','1',1,'Retail Sale Id 3586',1228.40,0.00,0.00,1.66,142.76,'2022-06-28 18:41:51','',''),(3563,'1','273','1',1,'Retail Sale Id 3587',9250.00,0.00,0.00,12.50,1075.00,'2022-06-29 06:59:40','',''),(3564,'1','273','1',1,'Retail Sale Id 3588',2220.00,0.00,0.00,3.00,258.00,'2022-06-29 07:00:57','',''),(3565,'1','273','1',1,'Retail Sale Id 3589',1998.00,0.00,0.00,2.70,232.20,'2022-06-29 07:01:33','',''),(3566,'1','273','1',1,'Retail Sale Id 3590',1998.00,0.00,0.00,2.70,232.20,'2022-06-29 07:21:11','',''),(3567,'1','273','1',1,'Retail Sale Id 3591',1502.20,0.00,0.00,2.03,174.58,'2022-06-29 07:30:14','',''),(3568,'1','273','1',1,'Retail Sale Id 3592',3700.00,0.00,0.00,5.00,430.00,'2022-06-29 07:32:37','',''),(3569,'1','273','1',1,'Retail Sale Id 3593',5180.00,0.00,0.00,7.00,602.00,'2022-06-29 07:49:29','',''),(3570,'1','273','1',1,'Retail Sale Id 3595',12002.80,0.00,0.00,16.22,1394.92,'2022-06-29 07:52:50','',''),(3571,'1','273','1',1,'Retail Sale Id 3596',51405.00,0.00,0.00,74.50,2682.00,'2022-06-29 07:57:29','',''),(3572,'1','273','1',1,'Retail Sale Id 3597',3700.00,0.00,0.00,5.00,430.00,'2022-06-29 08:01:20','',''),(3573,'1','273','1',1,'Retail Sale Id 3598',18500.00,0.00,0.00,25.00,2150.00,'2022-06-29 08:08:11','',''),(3574,'1','273','1',1,'Retail Sale Id 3599',9250.00,0.00,0.00,12.50,1075.00,'2022-06-29 08:16:50','',''),(3575,'1','273','1',1,'Retail Sale Id 3600',7400.00,0.00,0.00,10.00,860.00,'2022-06-29 08:18:07','',''),(3576,'1','273','1',1,'Retail Sale Id 3601',3700.00,0.00,0.00,5.00,430.00,'2022-06-29 08:19:09','',''),(3577,'1','273','1',1,'Retail Sale Id 3602',9250.00,0.00,0.00,12.50,1075.00,'2022-06-29 08:31:16','',''),(3578,'1','273','1',1,'Retail Sale Id 3603',747.40,0.00,0.00,1.01,86.86,'2022-06-29 08:39:44','',''),(3579,'1','273','1',1,'Retail Sale Id 3604',4440.00,0.00,0.00,6.00,516.00,'2022-06-29 08:51:11','',''),(3580,'1','273','1',1,'Retail Sale Id 3605',53495.70,0.00,0.00,77.53,2791.08,'2022-06-29 09:04:42','',''),(3581,'1','273','1',1,'Retail Sale Id 3606',2220.00,0.00,0.00,3.00,258.00,'2022-06-29 09:16:21','',''),(3582,'1','273','1',1,'Retail Sale Id 3607',1480.00,0.00,0.00,2.00,172.00,'2022-06-29 09:17:28','',''),(3583,'1','273','1',1,'Retail Sale Id 3608',777.00,0.00,0.00,1.05,90.30,'2022-06-29 09:18:58','',''),(3584,'1','273','1',1,'Retail Sale Id 3609',20700.00,0.00,0.00,30.00,1080.00,'2022-06-29 09:20:39','',''),(3585,'1','273','1',1,'Retail Sale Id 3610',1480.00,0.00,0.00,2.00,172.00,'2022-06-29 09:31:14','',''),(3586,'1','273','1',1,'Retail Sale Id 3611',9250.00,0.00,0.00,12.50,1075.00,'2022-06-29 09:38:26','',''),(3587,'1','273','1',1,'Retail Sale Id 3612',1998.00,0.00,0.00,2.70,232.20,'2022-06-29 09:59:16','',''),(3588,'1','273','1',1,'Retail Sale Id 3613',5180.00,0.00,0.00,7.00,602.00,'2022-06-29 10:12:09','',''),(3589,'1','273','1',1,'Retail Sale Id 3614',69000.00,0.00,0.00,100.00,3600.00,'2022-06-29 10:14:35','',''),(3590,'1','273','1',1,'Retail Sale Id 3615',747.40,0.00,0.00,1.01,86.86,'2022-06-29 10:20:43','',''),(3591,'1','273','1',1,'Retail Sale Id 3616',46920.00,0.00,0.00,68.00,2448.00,'2022-06-29 10:52:19','',''),(3592,'1','273','1',1,'Retail Sale Id 3617',4003.40,0.00,0.00,5.41,465.26,'2022-06-29 11:19:58','',''),(3593,'1','273','1',1,'Retail Sale Id 3618',29670.00,0.00,0.00,43.00,1548.00,'2022-06-29 11:49:59','',''),(3594,'1','273','1',1,'Retail Sale Id 3619',7400.00,0.00,0.00,10.00,860.00,'2022-06-29 12:06:06','',''),(3595,'1','273','1',1,'Retail Sale Id 3620',747.40,0.00,0.00,1.01,86.86,'2022-06-29 12:25:54','',''),(3596,'1','273','1',1,'Retail Sale Id 3621',8880.00,0.00,0.00,12.00,1032.00,'2022-06-29 12:35:01','',''),(3597,'1','273','1',1,'Retail Sale Id 3622',2997.00,0.00,0.00,4.05,348.30,'2022-06-29 12:48:51','',''),(3598,'1','273','1',1,'Retail Sale Id 3623',69000.00,0.00,0.00,100.00,3600.00,'2022-06-29 13:04:05','',''),(3599,'1','273','1',1,'Retail Sale Id 3624',55200.00,0.00,0.00,80.00,2880.00,'2022-06-29 13:05:20','',''),(3600,'1','273','1',1,'Retail Sale Id 3625',9250.00,0.00,0.00,12.50,1075.00,'2022-06-29 13:06:12','',''),(3601,'1','273','1',1,'Retail Sale Id 3626',3700.00,0.00,0.00,5.00,430.00,'2022-06-29 13:06:43','',''),(3602,'1','273','1',1,'Retail Sale Id 3627',9501.60,0.00,0.00,12.84,1104.24,'2022-06-29 13:24:37','',''),(3603,'1','273','1',1,'Retail Sale Id 3629',5949.60,0.00,0.00,8.04,691.44,'2022-06-29 13:31:30','',''),(3604,'1','273','1',1,'Retail Sale Id 3630',9250.00,0.00,0.00,12.50,1075.00,'2022-06-29 13:38:20','',''),(3605,'1','273','1',1,'Retail Sale Id 3631',740.00,0.00,0.00,1.00,86.00,'2022-06-29 14:31:25','',''),(3606,'1','273','1',1,'Retail Sale Id 3632',7400.00,0.00,0.00,10.00,860.00,'2022-06-29 14:34:57','',''),(3607,'1','273','1',1,'Retail Sale Id 3633',8502.60,0.00,0.00,11.49,988.14,'2022-06-29 14:36:52','',''),(3608,'1','273','1',1,'Retail Sale Id 3634',8140.00,0.00,0.00,11.00,946.00,'2022-06-29 14:38:49','',''),(3609,'1','273','1',1,'Retail Sale Id 3635',999.00,0.00,0.00,1.35,116.10,'2022-06-29 14:40:46','',''),(3610,'1','273','1',1,'Retail Sale Id 3636',747.40,0.00,0.00,1.01,86.86,'2022-06-29 15:04:22','',''),(3611,'1','273','1',1,'Retail Sale Id 3637',1502.20,0.00,0.00,2.03,174.58,'2022-06-29 15:05:35','',''),(3612,'1','273','1',1,'Retail Sale Id 3638',3700.00,0.00,0.00,5.00,430.00,'2022-06-29 15:17:05','',''),(3613,'1','273','1',1,'Retail Sale Id 3639',2220.00,0.00,0.00,3.00,258.00,'2022-06-29 15:26:45','',''),(3614,'1','273','1',1,'Retail Sale Id 3643',7400.00,0.00,0.00,10.00,860.00,'2022-06-29 15:29:17','',''),(3615,'1','273','1',1,'Retail Sale Id 3644',4499.20,0.00,0.00,6.08,522.88,'2022-06-29 15:34:55','',''),(3616,'1','273','1',1,'Retail Sale Id 3645',1998.00,0.00,0.00,2.70,232.20,'2022-06-29 15:51:17','',''),(3617,'1','273','1',1,'Retail Sale Id 3646',7400.00,0.00,0.00,10.00,860.00,'2022-06-29 15:58:26','',''),(3618,'1','273','1',1,'Retail Sale Id 3647',1480.00,0.00,0.00,2.00,172.00,'2022-06-29 15:59:18','',''),(3619,'1','273','1',1,'Retail Sale Id 3648',34500.00,0.00,0.00,50.00,1800.00,'2022-06-29 16:11:21','',''),(3620,'1','273','1',1,'Retail Sale Id 3649',2220.00,0.00,0.00,3.00,258.00,'2022-06-29 16:14:56','',''),(3621,'1','273','1',1,'Retail Sale Id 3650',11100.00,0.00,0.00,15.00,1290.00,'2022-06-29 16:20:54','',''),(3622,'1','273','1',1,'Retail Sale Id 3651',1502.20,0.00,0.00,2.03,174.58,'2022-06-29 16:34:48','',''),(3623,'1','273','1',1,'Retail Sale Id 3652',5002.40,0.00,0.00,6.76,581.36,'2022-06-29 17:02:34','',''),(3624,'1','273','1',1,'Retail Sale Id 3653',9250.00,0.00,0.00,12.50,1075.00,'2022-06-29 17:12:52','',''),(3625,'1','273','1',1,'Retail Sale Id 3654',747.40,0.00,0.00,1.01,86.86,'2022-06-29 17:26:39','',''),(3626,'1','273','1',1,'Retail Sale Id 3655',4440.00,0.00,0.00,6.00,516.00,'2022-06-29 17:31:34','',''),(3627,'1','273','1',1,'Retail Sale Id 3655',8880.00,0.00,0.00,12.00,1032.00,'2022-06-29 17:31:34','',''),(3628,'1','273','1',1,'Retail Sale Id 3656',799.20,0.00,0.00,1.08,92.88,'2022-06-29 17:32:47','',''),(3629,'1','273','1',1,'Retail Sale Id 3657',747.40,0.00,0.00,1.01,86.86,'2022-06-29 17:33:38','',''),(3630,'1','273','1',1,'Retail Sale Id 3658',747.40,0.00,0.00,1.01,86.86,'2022-06-29 17:35:22','',''),(3631,'1','273','1',1,'Retail Sale Id 3659',2997.00,0.00,0.00,4.05,348.30,'2022-06-29 17:44:36','',''),(3632,'1','273','1',1,'Retail Sale Id 3660',1480.00,0.00,0.00,2.00,172.00,'2022-06-29 17:45:38','',''),(3633,'1','273','1',1,'Retail Sale Id 3661',7400.00,0.00,0.00,10.00,860.00,'2022-06-29 17:46:18','',''),(3634,'1','273','1',1,'Retail Sale Id 3662',3700.00,0.00,0.00,5.00,430.00,'2022-06-29 17:57:24','',''),(3635,'1','273','1',1,'Retail Sale Id 3663',4440.00,0.00,0.00,6.00,516.00,'2022-06-29 17:58:39','',''),(3636,'1','273','1',1,'Retail Sale Id 3664',2997.00,0.00,0.00,4.05,348.30,'2022-06-29 18:17:26','',''),(3637,'1','273','1',1,'Retail Sale Id 3665',1502.20,0.00,0.00,2.03,174.58,'2022-06-29 18:19:23','',''),(3638,'1','273','1',1,'Retail Sale Id 3666',12950.00,0.00,0.00,17.50,1505.00,'2022-06-29 18:20:21','',''),(3639,'1','273','1',1,'Retail Sale Id 3667',2220.00,0.00,0.00,3.00,258.00,'2022-06-29 18:21:10','',''),(3640,'1','273','1',1,'Retail Sale Id 3668',6660.00,0.00,0.00,9.00,774.00,'2022-06-29 18:24:01','',''),(3641,'1','273','1',1,'Retail Sale Id 3669',999.00,0.00,0.00,1.35,116.10,'2022-06-29 18:28:35','',''),(3642,'1','273','1',1,'Retail Sale Id 3670',2960.00,0.00,0.00,4.00,344.00,'2022-06-29 18:31:01','',''),(3643,'1','273','1',1,'Retail Sale Id 3671',747.40,0.00,0.00,1.01,86.86,'2022-06-29 18:34:15','',''),(3644,'1','273','1',1,'Return of Retail Sale Id 3653',0.00,9250.00,12.50,0.00,-1075.00,'2022-06-29 19:01:48','',''),(3645,'1','273','1',1,'Retail Sale Id 3672',8998.40,0.00,0.00,12.16,1045.76,'2022-06-29 19:02:27','',''),(3646,'1','273','1',1,'Retail Sale Id 3673',999.00,0.00,0.00,1.35,116.10,'2022-06-30 06:54:27','',''),(3647,'1','273','1',1,'Retail Sale Id 3674',999.00,0.00,0.00,1.35,116.10,'2022-06-30 07:15:57','',''),(3648,'1','273','1',1,'Retail Sale Id 3675',82800.00,0.00,0.00,120.00,4320.00,'2022-06-30 07:24:24','',''),(3649,'1','273','1',1,'Retail Sale Id 3676',999.00,0.00,0.00,1.35,116.10,'2022-06-30 07:29:07','',''),(3650,'1','273','1',1,'Retail Sale Id 3677',9250.00,0.00,0.00,12.50,1075.00,'2022-06-30 07:34:34','',''),(3651,'1','273','1',1,'Retail Sale Id 3678',2220.00,0.00,0.00,3.00,258.00,'2022-06-30 07:41:34','',''),(3652,'1','273','1',1,'Retail Sale Id 3678',5180.00,0.00,0.00,7.00,602.00,'2022-06-30 07:41:34','',''),(3653,'1','273','1',1,'Retail Sale Id 3679',1502.20,0.00,0.00,2.03,174.58,'2022-06-30 07:50:58','',''),(3654,'1','273','1',1,'Retail Sale Id 3680',7400.00,0.00,0.00,10.00,860.00,'2022-06-30 07:57:51','',''),(3655,'1','273','1',1,'Retail Sale Id 3681',8140.00,0.00,0.00,11.00,946.00,'2022-06-30 08:01:46','',''),(3656,'1','273','1',1,'Retail Sale Id 3682',2997.00,0.00,0.00,4.05,348.30,'2022-06-30 08:03:26','',''),(3657,'1','273','1',1,'Retail Sale Id 3683',78998.10,0.00,0.00,114.49,4121.64,'2022-06-30 08:31:17','',''),(3658,'1','273','1',1,'Retail Sale Id 3684',1198.80,0.00,0.00,1.62,139.32,'2022-06-30 08:34:14','',''),(3659,'1','273','1',1,'Retail Sale Id 3685',999.00,0.00,0.00,1.35,116.10,'2022-06-30 08:37:20','',''),(3660,'1','273','1',1,'Retail Sale Id 3686',2249.60,0.00,0.00,3.04,261.44,'2022-06-30 08:40:12','',''),(3661,'1','273','1',1,'Retail Sale Id 3687',4440.00,0.00,0.00,6.00,516.00,'2022-06-30 08:54:45','',''),(3662,'1','273','1',1,'Retail Sale Id 3688',37000.00,0.00,0.00,50.00,4300.00,'2022-06-30 08:56:12','',''),(3663,'1','273','1',1,'Retail Sale Id 3689',69000.00,0.00,0.00,100.00,3600.00,'2022-06-30 08:58:35','',''),(3664,'1','273','1',1,'Retail Sale Id 3690',42780.00,0.00,0.00,62.00,2232.00,'2022-06-30 08:59:50','',''),(3665,'1','273','1',1,'Retail Sale Id 3691',1502.20,0.00,0.00,2.03,174.58,'2022-06-30 09:00:40','',''),(3666,'1','273','1',1,'Retail Sale Id 3692',8880.00,0.00,0.00,12.00,1032.00,'2022-06-30 09:25:05','',''),(3667,'1','273','1',1,'Retail Sale Id 3693',69000.00,0.00,0.00,100.00,3600.00,'2022-06-30 09:27:39','',''),(3668,'1','273','1',1,'Retail Sale Id 3694',38640.00,0.00,0.00,56.00,2016.00,'2022-06-30 09:28:42','',''),(3669,'1','273','1',1,'Retail Sale Id 3695',1998.00,0.00,0.00,2.70,232.20,'2022-06-30 09:36:49','',''),(3670,'1','273','1',1,'Retail Sale Id 3696',2501.20,0.00,0.00,3.38,290.68,'2022-06-30 09:50:25','',''),(3671,'1','273','1',1,'Retail Sale Id 3697',2220.00,0.00,0.00,3.00,258.00,'2022-06-30 09:53:02','',''),(3672,'1','273','1',1,'Retail Sale Id 3698',4440.00,0.00,0.00,6.00,516.00,'2022-06-30 10:07:57','',''),(3673,'1','273','1',1,'Retail Sale Id 3699',1998.00,0.00,0.00,2.70,232.20,'2022-06-30 10:10:29','',''),(3674,'1','273','1',1,'Retail Sale Id 3700',9250.00,0.00,0.00,12.50,1075.00,'2022-06-30 10:11:53','',''),(3675,'1','273','1',1,'Retail Sale Id 3701',7400.00,0.00,0.00,10.00,860.00,'2022-06-30 10:17:42','',''),(3676,'1','273','1',1,'Retail Sale Id 3702',27600.00,0.00,0.00,40.00,1440.00,'2022-06-30 10:25:20','',''),(3677,'1','273','1',1,'Retail Sale Id 3703',2220.00,0.00,0.00,3.00,258.00,'2022-06-30 10:31:39','',''),(3678,'1','273','1',1,'Retail Sale Id 3704',4440.00,0.00,0.00,6.00,516.00,'2022-06-30 10:34:50','',''),(3679,'1','273','1',1,'Retail Sale Id 3705',9501.60,0.00,0.00,12.84,1104.24,'2022-06-30 10:44:47','',''),(3680,'1','273','1',1,'Retail Sale Id 3706',9250.00,0.00,0.00,12.50,1075.00,'2022-06-30 10:52:40','',''),(3681,'1','273','1',1,'Retail Sale Id 3707',2220.00,0.00,0.00,3.00,258.00,'2022-06-30 10:53:18','',''),(3682,'1','273','1',1,'Retail Sale Id 3708',2220.00,0.00,0.00,3.00,258.00,'2022-06-30 10:57:43','',''),(3683,'1','273','1',1,'Retail Sale Id 3709',1480.00,0.00,0.00,2.00,172.00,'2022-06-30 11:04:00','',''),(3684,'1','273','1',1,'Retail Sale Id 3710',2960.00,0.00,0.00,4.00,344.00,'2022-06-30 11:06:31','',''),(3685,'1','273','1',1,'Retail Sale Id 3712',3700.00,0.00,0.00,5.00,430.00,'2022-06-30 11:35:22','',''),(3686,'1','273','1',1,'Retail Sale Id 3713',1480.00,0.00,0.00,2.00,172.00,'2022-06-30 11:44:38','',''),(3687,'1','273','1',1,'Retail Sale Id 3714',7999.40,0.00,0.00,10.81,929.66,'2022-06-30 11:59:09','',''),(3688,'1','273','1',1,'Retail Sale Id 3715',21390.00,0.00,0.00,31.00,1116.00,'2022-06-30 12:09:50','',''),(3689,'1','273','1',1,'Retail Sale Id 3716',747.40,0.00,0.00,1.01,86.86,'2022-06-30 12:12:20','',''),(3690,'1','273','1',1,'Retail Sale Id 3717',4440.00,0.00,0.00,6.00,516.00,'2022-06-30 12:25:26','',''),(3691,'1','273','1',1,'Retail Sale Id 3718',3899.80,0.00,0.00,5.27,453.22,'2022-06-30 12:26:32','',''),(3692,'1','273','1',1,'Retail Sale Id 3719',7400.00,0.00,0.00,10.00,860.00,'2022-06-30 12:32:13','',''),(3693,'1','273','1',1,'Retail Sale Id 3720',747.40,0.00,0.00,1.01,86.86,'2022-06-30 12:36:16','',''),(3694,'1','273','1',1,'Retail Sale Id 3721',4440.00,0.00,0.00,6.00,516.00,'2022-06-30 12:39:25','',''),(3695,'1','273','1',1,'Retail Sale Id 3722',4447.40,0.00,0.00,6.01,516.86,'2022-06-30 12:48:30','',''),(3696,'1','273','1',1,'Retail Sale Id 3724',1480.00,0.00,0.00,2.00,172.00,'2022-06-30 12:50:05','',''),(3697,'1','273','1',1,'Retail Sale Id 3725',4003.40,0.00,0.00,5.41,465.26,'2022-06-30 15:37:49','',''),(3698,'1','273','1',1,'Retail Sale Id 3726',6948.60,0.00,0.00,9.39,807.54,'2022-06-30 15:40:22','',''),(3699,'1','273','1',1,'Retail Sale Id 3727',1502.20,0.00,0.00,2.03,174.58,'2022-06-30 15:59:55','',''),(3700,'1','273','1',1,'Retail Sale Id 3728',8502.60,0.00,0.00,11.49,988.14,'2022-06-30 16:15:07','',''),(3701,'1','273','1',1,'Retail Sale Id 3729',1998.00,0.00,0.00,2.70,232.20,'2022-06-30 16:15:43','',''),(3702,'1','273','1',1,'Retail Sale Id 3730',6497.20,0.00,0.00,8.78,755.08,'2022-06-30 16:16:20','',''),(3703,'1','273','1',1,'Retail Sale Id 3731',999.00,0.00,0.00,1.35,116.10,'2022-06-30 16:18:32','',''),(3704,'1','273','1',1,'Retail Sale Id 3732',999.00,0.00,0.00,1.35,116.10,'2022-06-30 16:29:04','',''),(3705,'1','273','1',1,'Retail Sale Id 3733',1502.20,0.00,0.00,2.03,174.58,'2022-06-30 16:38:38','',''),(3706,'1','273','1',1,'Retail Sale Id 3734',1502.20,0.00,0.00,2.03,174.58,'2022-06-30 16:49:25','',''),(3707,'1','273','1',1,'Retail Sale Id 3735',38495.10,0.00,0.00,55.79,2008.44,'2022-06-30 16:50:56','',''),(3708,'1','273','1',1,'Retail Sale Id 3736',34500.00,0.00,0.00,50.00,1800.00,'2022-06-30 16:57:59','',''),(3709,'1','273','1',1,'Retail Sale Id 3737',1502.20,0.00,0.00,2.03,174.58,'2022-06-30 16:59:16','',''),(3710,'1','273','1',1,'Retail Sale Id 3738',2501.20,0.00,0.00,3.38,290.68,'2022-06-30 17:00:20','',''),(3711,'1','273','1',1,'Retail Sale Id 3739',1502.20,0.00,0.00,2.03,174.58,'2022-06-30 17:01:23','',''),(3712,'1','273','1',1,'Retail Sale Id 3740',9250.00,0.00,0.00,12.50,1075.00,'2022-06-30 17:04:38','',''),(3713,'1','273','1',1,'Retail Sale Id 3741',1502.20,0.00,0.00,2.03,174.58,'2022-06-30 17:18:09','',''),(3714,'1','273','1',1,'Retail Sale Id 3742',2220.00,0.00,0.00,3.00,258.00,'2022-06-30 17:28:19','',''),(3715,'1','273','1',1,'Retail Sale Id 3743',3700.00,0.00,0.00,5.00,430.00,'2022-06-30 17:29:08','',''),(3716,'1','273','1',1,'Retail Sale Id 3744',999.00,0.00,0.00,1.35,116.10,'2022-06-30 17:34:56','',''),(3717,'1','273','1',1,'Retail Sale Id 3745',2301.40,0.00,0.00,3.11,267.46,'2022-06-30 17:40:51','',''),(3718,'1','273','1',1,'Retail Sale Id 3746',9250.00,0.00,0.00,12.50,1075.00,'2022-06-30 17:47:43','',''),(3719,'1','273','1',1,'Retail Sale Id 3747',9250.00,0.00,0.00,12.50,1075.00,'2022-06-30 17:48:43','',''),(3720,'1','273','1',1,'Retail Sale Id 3748',4440.00,0.00,0.00,6.00,516.00,'2022-06-30 17:50:06','',''),(3721,'1','273','1',1,'Retail Sale Id 3749',2249.60,0.00,0.00,3.04,261.44,'2022-06-30 17:54:02','',''),(3722,'1','273','1',1,'Retail Sale Id 3750',2501.20,0.00,0.00,3.38,290.68,'2022-06-30 18:00:30','',''),(3723,'1','273','1',1,'Retail Sale Id 3751',9250.00,0.00,0.00,12.50,1075.00,'2022-06-30 18:10:19','',''),(3724,'1','273','1',1,'Retail Sale Id 3752',747.40,0.00,0.00,1.01,86.86,'2022-06-30 18:11:21','',''),(3725,'1','273','1',1,'Retail Sale Id 3753',3700.00,0.00,0.00,5.00,430.00,'2022-06-30 18:14:49','',''),(3726,'1','273','1',1,'Return of Retail Sale Id 3738',0.00,2501.20,3.38,0.00,-290.68,'2022-06-30 18:43:30','',''),(3727,'1','273','1',1,'Retail Sale Id 3754',1857.40,0.00,0.00,2.51,215.86,'2022-06-30 18:44:14','',''),(3728,'1','273','1',1,'Retail Sale Id 3755',3700.00,0.00,0.00,5.00,430.00,'2022-07-01 06:59:37','',''),(3729,'1','273','1',1,'Retail Sale Id 3756',9250.00,0.00,0.00,12.50,1075.00,'2022-07-01 07:04:43','',''),(3730,'1','273','1',1,'Retail Sale Id 3757',7400.00,0.00,0.00,10.00,860.00,'2022-07-01 07:06:49','',''),(3731,'1','273','1',1,'Retail Sale Id 3758',1398.60,0.00,0.00,1.89,162.54,'2022-07-01 07:08:08','',''),(3732,'1','273','1',1,'Retail Sale Id 3759',9620.00,0.00,0.00,13.00,1118.00,'2022-07-01 07:26:57','',''),(3733,'1','273','1',1,'Retail Sale Id 3760',51000.00,0.00,0.00,75.00,1950.00,'2022-07-01 07:33:18','',''),(3734,'1','273','1',1,'Retail Sale Id 3761',39100.00,0.00,0.00,57.50,1495.00,'2022-07-01 07:43:09','',''),(3735,'1','273','1',1,'Retail Sale Id 3762',2997.00,0.00,0.00,4.05,348.30,'2022-07-01 07:44:07','',''),(3736,'1','273','1',1,'Retail Sale Id 3763',747.40,0.00,0.00,1.01,86.86,'2022-07-01 07:48:58','',''),(3737,'1','273','1',1,'Retail Sale Id 3764',2197.80,0.00,0.00,2.97,255.42,'2022-07-01 07:49:54','',''),(3738,'1','273','1',1,'Retail Sale Id 3765',5180.00,0.00,0.00,7.00,602.00,'2022-07-01 07:58:50','',''),(3739,'1','273','1',1,'Retail Sale Id 3766',1998.00,0.00,0.00,2.70,232.20,'2022-07-01 08:01:37','',''),(3740,'1','273','1',1,'Retail Sale Id 3767',5002.40,0.00,0.00,6.76,581.36,'2022-07-01 08:02:54','',''),(3741,'1','273','1',1,'Retail Sale Id 3768',4440.00,0.00,0.00,6.00,516.00,'2022-07-01 08:08:23','',''),(3742,'1','273','1',1,'Retail Sale Id 3769',999.00,0.00,0.00,1.35,116.10,'2022-07-01 08:09:27','',''),(3743,'1','273','1',1,'Retail Sale Id 3770',2249.60,0.00,0.00,3.04,261.44,'2022-07-01 08:17:35','',''),(3744,'1','273','1',1,'Retail Sale Id 3771',74800.00,0.00,0.00,110.00,2860.00,'2022-07-01 08:19:42','',''),(3745,'1','273','1',1,'Retail Sale Id 3772',747.40,0.00,0.00,1.01,86.86,'2022-07-01 08:21:39','',''),(3746,'1','273','1',1,'Retail Sale Id 3773',4440.00,0.00,0.00,6.00,516.00,'2022-07-01 08:22:54','',''),(3747,'1','273','1',1,'Retail Sale Id 3774',999.00,0.00,0.00,1.35,116.10,'2022-07-01 08:29:11','',''),(3748,'1','273','1',1,'Retail Sale Id 3775',3700.00,0.00,0.00,5.00,430.00,'2022-07-01 08:33:22','',''),(3749,'1','273','1',1,'Retail Sale Id 3776',23698.00,0.00,0.00,34.85,906.10,'2022-07-01 08:47:16','',''),(3750,'1','273','1',1,'Retail Sale Id 3777',2960.00,0.00,0.00,4.00,344.00,'2022-07-01 08:52:49','',''),(3751,'1','273','1',1,'Retail Sale Id 3778',68000.00,0.00,0.00,100.00,2600.00,'2022-07-01 08:54:43','',''),(3752,'1','273','1',1,'Retail Sale Id 3779',1480.00,0.00,0.00,2.00,172.00,'2022-07-01 09:00:28','',''),(3753,'1','273','1',1,'Retail Sale Id 3780',1398.60,0.00,0.00,1.89,162.54,'2022-07-01 09:07:30','',''),(3754,'1','273','1',1,'Retail Sale Id 3781',1480.00,0.00,0.00,2.00,172.00,'2022-07-01 09:08:15','',''),(3755,'1','273','1',1,'Retail Sale Id 3782',4440.00,0.00,0.00,6.00,516.00,'2022-07-01 09:08:58','',''),(3756,'1','273','1',1,'Retail Sale Id 3783',1480.00,0.00,0.00,2.00,172.00,'2022-07-01 09:11:45','',''),(3757,'1','273','1',1,'Retail Sale Id 3784',2997.00,0.00,0.00,4.05,348.30,'2022-07-01 09:21:38','',''),(3758,'1','273','1',1,'Retail Sale Id 3785',1502.20,0.00,0.00,2.03,174.58,'2022-07-01 09:22:39','',''),(3759,'1','273','1',1,'Retail Sale Id 3786',2960.00,0.00,0.00,4.00,344.00,'2022-07-01 09:26:01','',''),(3760,'1','273','1',1,'Retail Sale Id 3787',4440.00,0.00,0.00,6.00,516.00,'2022-07-01 09:34:11','',''),(3761,'1','273','1',1,'Retail Sale Id 3788',68000.00,0.00,0.00,100.00,2600.00,'2022-07-01 09:43:51','',''),(3762,'1','273','1',1,'Retail Sale Id 3789',68000.00,0.00,0.00,100.00,2600.00,'2022-07-01 09:44:47','',''),(3763,'1','273','1',1,'Return of Retail Sale Id 3756',0.00,9250.00,12.50,0.00,-1075.00,'2022-07-01 10:05:38','',''),(3764,'1','273','1',1,'Retail Sale Id 3791',222.00,0.00,0.00,0.30,25.80,'2022-07-01 10:09:26','',''),(3765,'1','273','1',1,'Retail Sale Id 3792',92480.00,0.00,0.00,136.00,3536.00,'2022-07-01 11:01:30','',''),(3766,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,135443.40,207.10,0.00,0.00,'2022-07-01 15:21:17','',''),(3767,'1','273',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,207.10,0.00,'2022-07-01 15:23:57','',''),(3768,'1','273','1',1,'Received from bridging 13',0.00,0.00,207.10,0.00,0.00,'2022-07-01 15:23:57','',''),(3769,'1','273','1',1,'Retail Sale Id 3793',25826.00,0.00,0.00,34.90,3001.40,'2022-07-01 15:25:31','',''),(3770,'1','273','1',1,'Retail Sale Id 3794',116960.00,0.00,0.00,172.00,4472.00,'2022-07-01 15:27:01','',''),(3771,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,13113100.00,20020.00,0.00,0.00,'2022-07-01 20:21:29','',''),(3772,'1','273',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,20020.00,0.00,'2022-07-01 20:30:27','',''),(3773,'1','273','1',1,'Received from bridging 14',0.00,0.00,20020.00,0.00,0.00,'2022-07-01 20:30:27','',''),(3774,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,3275000.00,5000.00,0.00,0.00,'2022-07-01 20:31:58','',''),(3775,'1','273',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,4970.00,0.00,'2022-07-01 20:34:14','',''),(3776,'1','273','1',1,'Received from bridging 15',0.00,0.00,4970.00,0.00,0.00,'2022-07-01 20:34:14','',''),(3777,'1','273','1',1,'Retail Sale Id 3795',2997.00,0.00,0.00,4.05,344.25,'2022-07-02 06:51:23','',''),(3778,'1','273','1',1,'Retail Sale Id 3796',2501.20,0.00,0.00,3.38,287.30,'2022-07-02 06:52:09','',''),(3779,'1','273','1',1,'Retail Sale Id 3797',3700.00,0.00,0.00,5.00,425.00,'2022-07-02 06:55:59','',''),(3780,'1','273','1',1,'Retail Sale Id 3798',999.00,0.00,0.00,1.35,114.75,'2022-07-02 07:09:54','',''),(3781,'1','273','1',1,'Retail Sale Id 3799',1998.00,0.00,0.00,2.70,229.50,'2022-07-02 07:21:20','',''),(3782,'1','273','1',1,'Retail Sale Id 3800',1702.00,0.00,0.00,2.30,195.50,'2022-07-02 07:23:36','',''),(3783,'1','273','1',1,'Retail Sale Id 3801',4440.00,0.00,0.00,6.00,510.00,'2022-07-02 07:25:18','',''),(3784,'1','273','1',1,'Retail Sale Id 3802',999.00,0.00,0.00,1.35,114.75,'2022-07-02 07:31:50','',''),(3785,'1','273','1',1,'Retail Sale Id 3803',1502.20,0.00,0.00,2.03,172.55,'2022-07-02 07:39:31','',''),(3786,'1','273','1',1,'Retail Sale Id 3804',4440.00,0.00,0.00,6.00,510.00,'2022-07-02 07:40:23','',''),(3787,'1','273','1',1,'Retail Sale Id 3805',999.00,0.00,0.00,1.35,114.75,'2022-07-02 07:45:50','',''),(3788,'1','273','1',1,'Retail Sale Id 3806',1480.00,0.00,0.00,2.00,170.00,'2022-07-02 07:47:11','',''),(3789,'1','273','1',1,'Retail Sale Id 3807',999.00,0.00,0.00,1.35,114.75,'2022-07-02 07:48:20','',''),(3790,'1','273','1',1,'Retail Sale Id 3808',68000.00,0.00,0.00,100.00,2500.00,'2022-07-02 07:51:49','',''),(3791,'1','273','1',1,'Retail Sale Id 3809',102000.00,0.00,0.00,150.00,3750.00,'2022-07-02 07:52:28','',''),(3792,'1','273','1',1,'Retail Sale Id 3810',1998.00,0.00,0.00,2.70,229.50,'2022-07-02 07:57:58','',''),(3793,'1','273','1',1,'Retail Sale Id 3811',1198.80,0.00,0.00,1.62,137.70,'2022-07-02 07:59:50','',''),(3794,'1','273','1',1,'Retail Sale Id 3812',3700.00,0.00,0.00,5.00,425.00,'2022-07-02 08:09:13','',''),(3795,'1','273','1',1,'Retail Sale Id 3813',4440.00,0.00,0.00,6.00,510.00,'2022-07-02 08:10:12','',''),(3796,'1','273','1',1,'Retail Sale Id 3814',2960.00,0.00,0.00,4.00,340.00,'2022-07-02 08:17:37','',''),(3797,'1','273','1',1,'Retail Sale Id 3815',999.00,0.00,0.00,1.35,114.75,'2022-07-02 08:18:24','',''),(3798,'1','273','1',1,'Retail Sale Id 3816',122400.00,0.00,0.00,180.00,4500.00,'2022-07-02 08:20:06','',''),(3799,'1','273','1',1,'Retail Sale Id 3817',122400.00,0.00,0.00,180.00,4500.00,'2022-07-02 08:20:55','',''),(3800,'1','273','1',1,'Retail Sale Id 3818',3700.00,0.00,0.00,5.00,425.00,'2022-07-02 08:21:26','',''),(3801,'1','273','1',1,'Retail Sale Id 3819',2220.00,0.00,0.00,3.00,255.00,'2022-07-02 08:22:21','',''),(3802,'1','273','1',1,'Retail Sale Id 3820',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 08:23:40','',''),(3803,'1','273','1',1,'Retail Sale Id 3821',740.00,0.00,0.00,1.00,85.00,'2022-07-02 08:26:13','',''),(3804,'1','273','1',1,'Retail Sale Id 3822',1480.00,0.00,0.00,2.00,170.00,'2022-07-02 08:27:51','',''),(3805,'1','273','1',1,'Retail Sale Id 3823',740.00,0.00,0.00,1.00,85.00,'2022-07-02 08:29:37','',''),(3806,'1','273','1',1,'Retail Sale Id 3824',5920.00,0.00,0.00,8.00,680.00,'2022-07-02 08:33:54','',''),(3807,'1','273',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,30.00,0.00,'2022-07-02 08:37:03','',''),(3808,'1','273','1',1,'Received from bridging 16',0.00,0.00,30.00,0.00,0.00,'2022-07-02 08:37:03','',''),(3809,'1','273','1',1,'Retail Sale Id 3825',999.00,0.00,0.00,1.35,114.75,'2022-07-02 08:41:27','',''),(3810,'1','273','1',1,'Retail Sale Id 3826',999.00,0.00,0.00,1.35,114.75,'2022-07-02 08:48:02','',''),(3811,'1','273','1',1,'Retail Sale Id 3827',11840.00,0.00,0.00,16.00,1360.00,'2022-07-02 08:55:32','',''),(3812,'1','273','1',1,'Retail Sale Id 3828',1502.20,0.00,0.00,2.03,172.55,'2022-07-02 08:57:12','',''),(3813,'1','273','1',1,'Retail Sale Id 3829',999.00,0.00,0.00,1.35,114.75,'2022-07-02 08:58:13','',''),(3814,'1','273','1',1,'Retail Sale Id 3830',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 09:03:33','',''),(3815,'1','273','1',1,'Retail Sale Id 3831',747.40,0.00,0.00,1.01,85.85,'2022-07-02 09:04:50','',''),(3816,'1','273','1',1,'Retail Sale Id 3832',999.00,0.00,0.00,1.35,114.75,'2022-07-02 09:08:00','',''),(3817,'1','273','1',1,'Retail Sale Id 3833',5180.00,0.00,0.00,7.00,595.00,'2022-07-02 09:09:13','',''),(3818,'1','273','1',1,'Retail Sale Id 3834',1998.00,0.00,0.00,2.70,229.50,'2022-07-02 09:15:58','',''),(3819,'1','273','1',1,'Retail Sale Id 3835',4440.00,0.00,0.00,6.00,510.00,'2022-07-02 09:17:19','',''),(3820,'1','273','1',1,'Retail Sale Id 3836',102000.00,0.00,0.00,150.00,3750.00,'2022-07-02 09:29:34','',''),(3821,'1','273','1',1,'Retail Sale Id 3837',102000.00,0.00,0.00,150.00,3750.00,'2022-07-02 09:30:52','',''),(3822,'1','273','1',1,'Retail Sale Id 3838',2900.80,0.00,0.00,3.92,333.20,'2022-07-02 09:35:25','',''),(3823,'1','273','1',1,'Retail Sale Id 3839',5180.00,0.00,0.00,7.00,595.00,'2022-07-02 09:40:25','',''),(3824,'1','273','1',1,'Retail Sale Id 3840',1998.00,0.00,0.00,2.70,229.50,'2022-07-02 09:42:54','',''),(3825,'1','273','1',1,'Retail Sale Id 3841',21460.00,0.00,0.00,29.00,2465.00,'2022-07-02 09:44:13','',''),(3826,'1','273','1',1,'Retail Sale Id 3842',61200.00,0.00,0.00,90.00,2250.00,'2022-07-02 09:46:03','',''),(3827,'1','273','1',1,'Retail Sale Id 3843',3700.00,0.00,0.00,5.00,425.00,'2022-07-02 09:47:00','',''),(3828,'1','273','1',1,'Retail Sale Id 3844',740.00,0.00,0.00,1.00,85.00,'2022-07-02 09:50:47','',''),(3829,'1','273','1',1,'Retail Sale Id 3845',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 09:52:21','',''),(3830,'1','273','1',1,'Retail Sale Id 3846',68000.00,0.00,0.00,100.00,2500.00,'2022-07-02 10:38:34','',''),(3831,'1','273','1',1,'Retail Sale Id 3847',102000.00,0.00,0.00,150.00,3750.00,'2022-07-02 10:39:38','',''),(3832,'1','273','1',1,'Retail Sale Id 3848',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 10:45:40','',''),(3833,'1','273','1',1,'Retail Sale Id 3849',17760.00,0.00,0.00,24.00,2040.00,'2022-07-02 10:48:31','',''),(3834,'1','273','1',1,'Retail Sale Id 3850',3700.00,0.00,0.00,5.00,425.00,'2022-07-02 10:57:58','',''),(3835,'1','273','1',1,'Retail Sale Id 3851',2249.60,0.00,0.00,3.04,258.40,'2022-07-02 11:08:04','',''),(3836,'1','273','1',1,'Retail Sale Id 3852',65280.00,0.00,0.00,96.00,2400.00,'2022-07-02 11:13:33','',''),(3837,'1','273','1',1,'Retail Sale Id 3853',1998.00,0.00,0.00,2.70,229.50,'2022-07-02 11:14:35','',''),(3838,'1','273','1',1,'Retail Sale Id 3854',81600.00,0.00,0.00,120.00,3000.00,'2022-07-02 11:16:26','',''),(3839,'1','273','1',1,'Retail Sale Id 3855',1998.00,0.00,0.00,2.70,229.50,'2022-07-02 11:22:08','',''),(3840,'1','273','1',1,'Retail Sale Id 3856',19240.00,0.00,0.00,26.00,2210.00,'2022-07-02 11:27:01','',''),(3841,'1','273','1',1,'Retail Sale Id 3857',747.40,0.00,0.00,1.01,85.85,'2022-07-02 11:33:15','',''),(3842,'1','273','1',1,'Retail Sale Id 3858',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 11:34:47','',''),(3843,'1','273','1',1,'Retail Sale Id 3860',102000.00,0.00,0.00,150.00,3750.00,'2022-07-02 11:40:05','',''),(3844,'1','273','1',1,'Retail Sale Id 3861',69360.00,0.00,0.00,102.00,2550.00,'2022-07-02 11:40:44','',''),(3845,'1','273','1',1,'Retail Sale Id 3862',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 11:44:03','',''),(3846,'1','273','1',1,'Retail Sale Id 3863',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 12:00:14','',''),(3847,'1','273','1',1,'Retail Sale Id 3864',30600.00,0.00,0.00,45.00,1125.00,'2022-07-02 12:02:22','',''),(3848,'1','273','1',1,'Retail Sale Id 3865',36720.00,0.00,0.00,54.00,1350.00,'2022-07-02 12:08:52','',''),(3849,'1','273','1',1,'Retail Sale Id 3866',81600.00,0.00,0.00,120.00,3000.00,'2022-07-02 12:15:10','',''),(3850,'1','273','1',1,'Retail Sale Id 3867',5920.00,0.00,0.00,8.00,680.00,'2022-07-02 12:20:22','',''),(3851,'1','273','1',1,'Retail Sale Id 3868',2997.00,0.00,0.00,4.05,344.25,'2022-07-02 12:30:06','',''),(3852,'1','273','1',1,'Retail Sale Id 3870',1502.20,0.00,0.00,2.03,172.55,'2022-07-02 12:53:15','',''),(3853,'1','273','1',1,'Retail Sale Id 3871',1502.20,0.00,0.00,2.03,172.55,'2022-07-02 12:54:09','',''),(3854,'1','273','1',1,'Retail Sale Id 3872',34000.00,0.00,0.00,50.00,1250.00,'2022-07-02 12:56:38','',''),(3855,'1','273','1',1,'Retail Sale Id 3873',1502.20,0.00,0.00,2.03,172.55,'2022-07-02 13:03:55','',''),(3856,'1','273','1',1,'Retail Sale Id 3874',747.40,0.00,0.00,1.01,85.85,'2022-07-02 13:11:19','',''),(3857,'1','273','1',1,'Retail Sale Id 3875',77520.00,0.00,0.00,114.00,2850.00,'2022-07-02 13:16:37','',''),(3858,'1','273','1',1,'Retail Sale Id 3876',23800.00,0.00,0.00,35.00,875.00,'2022-07-02 13:18:18','',''),(3859,'1','273','1',1,'Retail Sale Id 3877',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 13:24:31','',''),(3860,'1','273','1',1,'Retail Sale Id 3878',1502.20,0.00,0.00,2.03,172.55,'2022-07-02 13:27:47','',''),(3861,'1','273','1',1,'Retail Sale Id 3879',1502.20,0.00,0.00,2.03,172.55,'2022-07-02 13:39:28','',''),(3862,'1','273','1',1,'Retail Sale Id 3880',1502.20,0.00,0.00,2.03,172.55,'2022-07-02 14:01:39','',''),(3863,'1','273','1',1,'Retail Sale Id 3881',747.40,0.00,0.00,1.01,85.85,'2022-07-02 14:03:14','',''),(3864,'1','273','1',1,'Retail Sale Id 3882',2501.20,0.00,0.00,3.38,287.30,'2022-07-02 14:13:33','',''),(3865,'1','273','1',1,'Retail Sale Id 3883',3700.00,0.00,0.00,5.00,425.00,'2022-07-02 14:20:18','',''),(3866,'1','273','1',1,'Retail Sale Id 3884',1998.00,0.00,0.00,2.70,229.50,'2022-07-02 14:22:50','',''),(3867,'1','273','1',1,'Retail Sale Id 3885',999.00,0.00,0.00,1.35,114.75,'2022-07-02 14:24:26','',''),(3868,'1','273','1',1,'Retail Sale Id 3886',1480.00,0.00,0.00,2.00,170.00,'2022-07-02 14:50:06','',''),(3869,'1','273','1',1,'Retail Sale Id 3887',740.00,0.00,0.00,1.00,85.00,'2022-07-02 14:58:21','',''),(3870,'1','273','1',1,'Retail Sale Id 3888',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 14:58:52','',''),(3871,'1','273','1',1,'Retail Sale Id 3889',40800.00,0.00,0.00,60.00,1500.00,'2022-07-02 15:00:24','',''),(3872,'1','273','1',1,'Retail Sale Id 3890',2249.60,0.00,0.00,3.04,258.40,'2022-07-02 15:00:59','',''),(3873,'1','273','1',1,'Retail Sale Id 3891',2960.00,0.00,0.00,4.00,340.00,'2022-07-02 15:09:29','',''),(3874,'1','273','1',1,'Retail Sale Id 3892',13320.00,0.00,0.00,18.00,1530.00,'2022-07-02 15:17:32','',''),(3875,'1','273','1',1,'Retail Sale Id 3893',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 15:19:34','',''),(3876,'1','273','1',1,'Retail Sale Id 3894',7400.00,0.00,0.00,10.00,850.00,'2022-07-02 15:27:35','',''),(3877,'1','273','1',1,'Retail Sale Id 3895',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 15:38:37','',''),(3878,'1','273','1',1,'Retail Sale Id 3896',747.40,0.00,0.00,1.01,85.85,'2022-07-02 15:47:30','',''),(3879,'1','273','1',1,'Retail Sale Id 3897',2997.00,0.00,0.00,4.05,344.25,'2022-07-02 15:50:59','',''),(3880,'1','273','1',1,'Retail Sale Id 3898',81600.00,0.00,0.00,120.00,3000.00,'2022-07-02 16:01:16','',''),(3881,'1','273','1',1,'Retail Sale Id 3899',81600.00,0.00,0.00,120.00,3000.00,'2022-07-02 16:02:17','',''),(3882,'1','273','1',1,'Retail Sale Id 3900',18500.00,0.00,0.00,25.00,2125.00,'2022-07-02 16:03:10','',''),(3883,'1','273','1',1,'Retail Sale Id 3901',3700.00,0.00,0.00,5.00,425.00,'2022-07-02 16:12:30','',''),(3884,'1','273','1',1,'Retail Sale Id 3902',4440.00,0.00,0.00,6.00,510.00,'2022-07-02 16:18:39','',''),(3885,'1','273','1',1,'Retail Sale Id 3903',8902.20,0.00,0.00,12.03,1022.55,'2022-07-02 16:20:59','',''),(3886,'1','273','1',1,'Retail Sale Id 3904',799.20,0.00,0.00,1.08,91.80,'2022-07-02 16:23:13','',''),(3887,'1','273','1',1,'Retail Sale Id 3905',799.20,0.00,0.00,1.08,91.80,'2022-07-02 16:42:37','',''),(3888,'1','273','1',1,'Retail Sale Id 3906',999.00,0.00,0.00,1.35,114.75,'2022-07-02 16:43:56','',''),(3889,'1','273','1',1,'Retail Sale Id 3907',6120.00,0.00,0.00,9.00,225.00,'2022-07-02 16:47:30','',''),(3890,'1','273','1',1,'Retail Sale Id 3908',999.00,0.00,0.00,1.35,114.75,'2022-07-02 17:02:21','',''),(3891,'1','273','1',1,'Retail Sale Id 3909',4440.00,0.00,0.00,6.00,510.00,'2022-07-02 17:03:42','',''),(3892,'1','273','1',1,'Retail Sale Id 3910',999.00,0.00,0.00,1.35,114.75,'2022-07-02 17:10:44','',''),(3893,'1','273','1',1,'Retail Sale Id 3911',7400.00,0.00,0.00,10.00,850.00,'2022-07-02 17:16:39','',''),(3894,'1','273','1',1,'Retail Sale Id 3912',7400.00,0.00,0.00,10.00,850.00,'2022-07-02 17:23:00','',''),(3895,'1','273','1',1,'Retail Sale Id 3913',3700.00,0.00,0.00,5.00,425.00,'2022-07-02 17:25:23','',''),(3896,'1','273','1',1,'Retail Sale Id 3914',1398.60,0.00,0.00,1.89,160.65,'2022-07-02 17:27:02','',''),(3897,'1','273','1',1,'Retail Sale Id 3915',5920.00,0.00,0.00,8.00,680.00,'2022-07-02 17:36:44','',''),(3898,'1','273','1',1,'Retail Sale Id 3916',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 17:39:14','',''),(3899,'1','273','1',1,'Retail Sale Id 3917',9250.00,0.00,0.00,12.50,1062.50,'2022-07-02 17:45:25','',''),(3900,'1','273','1',1,'Retail Sale Id 3918',999.00,0.00,0.00,1.35,114.75,'2022-07-02 17:46:49','',''),(3901,'1','273','1',1,'Retail Sale Id 3919',5920.00,0.00,0.00,8.00,680.00,'2022-07-02 17:49:53','',''),(3902,'1','273','1',1,'Retail Sale Id 3920',1502.20,0.00,0.00,2.03,172.55,'2022-07-02 17:55:14','',''),(3903,'1','273','1',1,'Retail Sale Id 3921',3700.00,0.00,0.00,5.00,425.00,'2022-07-02 18:09:45','',''),(3904,'1','273','1',1,'Retail Sale Id 3922',5202.20,0.00,0.00,7.03,597.55,'2022-07-02 18:12:56','',''),(3905,'1','273','1',1,'Retail Sale Id 3923',4440.00,0.00,0.00,6.00,510.00,'2022-07-02 18:17:10','',''),(3906,'1','273','1',1,'Retail Sale Id 3924',68000.00,0.00,0.00,100.00,2500.00,'2022-07-02 18:24:45','',''),(3907,'1','273','1',1,'Retail Sale Id 3925',102000.00,0.00,0.00,150.00,3750.00,'2022-07-02 18:25:43','',''),(3908,'1','273','1',1,'Retail Sale Id 3926',999.00,0.00,0.00,1.35,114.75,'2022-07-02 18:30:22','',''),(3909,'1','273','1',1,'Retail Sale Id 3927',902.80,0.00,0.00,1.22,103.70,'2022-07-02 18:37:57','',''),(3910,'1','273','1',1,'Retail Sale Id 3928',30600.00,0.00,0.00,45.00,1125.00,'2022-07-03 07:53:49','',''),(3911,'1','273','1',1,'Retail Sale Id 3929',4440.00,0.00,0.00,6.00,510.00,'2022-07-03 07:55:10','',''),(3912,'1','273','1',1,'Retail Sale Id 3930',999.00,0.00,0.00,1.35,114.75,'2022-07-03 07:56:00','',''),(3913,'1','273','1',1,'Retail Sale Id 3931',999.00,0.00,0.00,1.35,114.75,'2022-07-03 07:56:55','',''),(3914,'1','273','1',1,'Retail Sale Id 3932',2997.00,0.00,0.00,4.05,344.25,'2022-07-03 07:57:45','',''),(3915,'1','273','1',1,'Retail Sale Id 3933',1998.00,0.00,0.00,2.70,229.50,'2022-07-03 08:01:51','',''),(3916,'1','273','1',1,'Retail Sale Id 3934',48280.00,0.00,0.00,71.00,1775.00,'2022-07-03 08:03:39','',''),(3917,'1','273','1',1,'Retail Sale Id 3935',77520.00,0.00,0.00,114.00,2850.00,'2022-07-03 08:04:30','',''),(3918,'1','273','1',1,'Retail Sale Id 3936',999.00,0.00,0.00,1.35,114.75,'2022-07-03 08:05:29','',''),(3919,'1','273','1',1,'Retail Sale Id 3937',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 08:17:15','',''),(3920,'1','273','1',1,'Retail Sale Id 3938',2997.00,0.00,0.00,4.05,344.25,'2022-07-03 08:17:58','',''),(3921,'1','273','1',1,'Retail Sale Id 3939',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 08:27:13','',''),(3922,'1','273','1',1,'Retail Sale Id 3940',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 08:28:10','',''),(3923,'1','273','1',1,'Retail Sale Id 3941',3700.00,0.00,0.00,5.00,425.00,'2022-07-03 08:32:45','',''),(3924,'1','273','1',1,'Retail Sale Id 3942',2997.00,0.00,0.00,4.05,344.25,'2022-07-03 08:44:02','',''),(3925,'1','273','1',1,'Retail Sale Id 3943',7999.40,0.00,0.00,10.81,918.85,'2022-07-03 08:47:51','',''),(3926,'1','273','1',1,'Retail Sale Id 3944',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 08:52:41','',''),(3927,'1','273','1',1,'Retail Sale Id 3945',2249.60,0.00,0.00,3.04,258.40,'2022-07-03 08:56:29','',''),(3928,'1','273','1',1,'Retail Sale Id 3946',7400.00,0.00,0.00,10.00,850.00,'2022-07-03 09:01:36','',''),(3929,'1','273','1',1,'Retail Sale Id 3947',3500.20,0.00,0.00,4.73,402.05,'2022-07-03 09:08:53','',''),(3930,'1','273','1',1,'Retail Sale Id 3947',5002.40,0.00,0.00,6.76,574.60,'2022-07-03 09:08:53','',''),(3931,'1','273','1',1,'Retail Sale Id 3948',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 09:16:40','',''),(3932,'1','273','1',1,'Retail Sale Id 3949',10360.00,0.00,0.00,14.00,1190.00,'2022-07-03 09:17:50','',''),(3933,'1','273','1',1,'Retail Sale Id 3950',12210.00,0.00,0.00,16.50,1402.50,'2022-07-03 09:26:54','',''),(3934,'1','273','1',1,'Retail Sale Id 3951',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 09:34:09','',''),(3935,'1','273','1',1,'Retail Sale Id 3952',740.00,0.00,0.00,1.00,85.00,'2022-07-03 09:42:26','',''),(3936,'1','273','1',1,'Retail Sale Id 3953',81600.00,0.00,0.00,120.00,3000.00,'2022-07-03 09:52:24','',''),(3937,'1','273','1',1,'Retail Sale Id 3954',40800.00,0.00,0.00,60.00,1500.00,'2022-07-03 09:53:02','',''),(3938,'1','273','1',1,'Retail Sale Id 3955',999.00,0.00,0.00,1.35,114.75,'2022-07-03 09:53:46','',''),(3939,'1','273','1',1,'Retail Sale Id 3956',740.00,0.00,0.00,1.00,85.00,'2022-07-03 09:54:46','',''),(3940,'1','273','1',1,'Retail Sale Id 3957',4440.00,0.00,0.00,6.00,510.00,'2022-07-03 09:55:32','',''),(3941,'1','273','1',1,'Retail Sale Id 3958',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 10:03:09','',''),(3942,'1','273','1',1,'Retail Sale Id 3959',2040.00,0.00,0.00,3.00,75.00,'2022-07-03 10:20:53','',''),(3943,'1','273','1',1,'Retail Sale Id 3960',9250.00,0.00,0.00,12.50,1062.50,'2022-07-03 10:38:14','',''),(3944,'1','273','1',1,'Retail Sale Id 3961',5180.00,0.00,0.00,7.00,595.00,'2022-07-03 10:41:58','',''),(3945,'1','273','1',1,'Retail Sale Id 3962',1998.00,0.00,0.00,2.70,229.50,'2022-07-03 10:45:38','',''),(3946,'1','273','1',1,'Retail Sale Id 3963',9250.00,0.00,0.00,12.50,1062.50,'2022-07-03 10:49:47','',''),(3947,'1','273','1',1,'Retail Sale Id 3964',5180.00,0.00,0.00,7.00,595.00,'2022-07-03 10:52:59','',''),(3948,'1','273','1',1,'Retail Sale Id 3965',4440.00,0.00,0.00,6.00,510.00,'2022-07-03 10:54:54','',''),(3949,'1','273','1',1,'Retail Sale Id 3966',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 10:58:39','',''),(3950,'1','273','1',1,'Retail Sale Id 3968',2997.00,0.00,0.00,4.05,344.25,'2022-07-03 11:00:18','',''),(3951,'1','273','1',1,'Retail Sale Id 3969',740.00,0.00,0.00,1.00,85.00,'2022-07-03 11:01:02','',''),(3952,'1','273','1',1,'Retail Sale Id 3970',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 11:05:14','',''),(3953,'1','273','1',1,'Retail Sale Id 3971',2997.00,0.00,0.00,4.05,344.25,'2022-07-03 11:10:56','',''),(3954,'1','273','1',1,'Retail Sale Id 3972',3700.00,0.00,0.00,5.00,425.00,'2022-07-03 11:13:31','',''),(3955,'1','273','1',1,'Retail Sale Id 3973',2197.80,0.00,0.00,2.97,252.45,'2022-07-03 11:19:28','',''),(3956,'1','273','1',1,'Retail Sale Id 3974',4440.00,0.00,0.00,6.00,510.00,'2022-07-03 11:20:28','',''),(3957,'1','273','1',1,'Retail Sale Id 3975',2960.00,0.00,0.00,4.00,340.00,'2022-07-03 11:37:49','',''),(3958,'1','273','1',1,'Retail Sale Id 3976',3700.00,0.00,0.00,5.00,425.00,'2022-07-03 11:45:22','',''),(3959,'1','273','1',1,'Retail Sale Id 3977',81600.00,0.00,0.00,120.00,3000.00,'2022-07-03 11:50:39','',''),(3960,'1','273','1',1,'Retail Sale Id 3978',9250.00,0.00,0.00,12.50,1062.50,'2022-07-03 11:51:39','',''),(3961,'1','273','1',1,'Retail Sale Id 3979',122400.00,0.00,0.00,180.00,4500.00,'2022-07-03 11:54:25','',''),(3962,'1','273','1',1,'Retail Sale Id 3980',5180.00,0.00,0.00,7.00,595.00,'2022-07-03 11:56:08','',''),(3963,'1','273','1',1,'Retail Sale Id 3981',1998.00,0.00,0.00,2.70,229.50,'2022-07-03 11:56:54','',''),(3964,'1','273','1',1,'Retail Sale Id 3982',1998.00,0.00,0.00,2.70,229.50,'2022-07-03 11:57:34','',''),(3965,'1','273','1',1,'Retail Sale Id 3983',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 11:58:21','',''),(3966,'1','273','1',1,'Retail Sale Id 3984',5180.00,0.00,0.00,7.00,595.00,'2022-07-03 12:17:27','',''),(3967,'1','273','1',1,'Retail Sale Id 3985',999.00,0.00,0.00,1.35,114.75,'2022-07-03 12:23:12','',''),(3968,'1','273','1',1,'Retail Sale Id 3986',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 12:24:45','',''),(3969,'1','273','1',1,'Retail Sale Id 3987',740.00,0.00,0.00,1.00,85.00,'2022-07-03 12:27:16','',''),(3970,'1','273','1',1,'Retail Sale Id 3988',29994.80,0.00,0.00,44.11,1102.75,'2022-07-03 12:29:18','',''),(3971,'1','273','1',1,'Retail Sale Id 3989',3700.00,0.00,0.00,5.00,425.00,'2022-07-03 12:32:26','',''),(3972,'1','273','1',1,'Retail Sale Id 3990',1480.00,0.00,0.00,2.00,170.00,'2022-07-03 12:33:53','',''),(3973,'1','273','1',1,'Retail Sale Id 3991',9250.00,0.00,0.00,12.50,1062.50,'2022-07-03 12:48:05','',''),(3974,'1','273','1',1,'Retail Sale Id 3992',740.00,0.00,0.00,1.00,85.00,'2022-07-03 12:51:00','',''),(3975,'1','273','1',1,'Retail Sale Id 3993',1480.00,0.00,0.00,2.00,170.00,'2022-07-03 12:53:03','',''),(3976,'1','273','1',1,'Retail Sale Id 3994',999.00,0.00,0.00,1.35,114.75,'2022-07-03 12:55:59','',''),(3977,'1','273','1',1,'Retail Sale Id 3995',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 13:01:11','',''),(3978,'1','273','1',1,'Retail Sale Id 3996',7400.00,0.00,0.00,10.00,850.00,'2022-07-03 13:05:45','',''),(3979,'1','273','1',1,'Retail Sale Id 3997',37000.00,0.00,0.00,50.00,4250.00,'2022-07-03 13:07:18','',''),(3980,'1','273','1',1,'Retail Sale Id 3998',29240.00,0.00,0.00,43.00,1075.00,'2022-07-03 13:10:57','',''),(3981,'1','273','1',1,'Retail Sale Id 3999',68000.00,0.00,0.00,100.00,2500.00,'2022-07-03 13:12:37','',''),(3982,'1','273','1',1,'Retail Sale Id 4000',740.00,0.00,0.00,1.00,85.00,'2022-07-03 13:13:28','',''),(3983,'1','273','1',1,'Retail Sale Id 4001',1480.00,0.00,0.00,2.00,170.00,'2022-07-03 13:14:16','',''),(3984,'1','273','1',1,'Retail Sale Id 4002',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 13:15:25','',''),(3985,'1','273','1',1,'Retail Sale Id 4003',999.00,0.00,0.00,1.35,114.75,'2022-07-03 13:18:46','',''),(3986,'1','273','1',1,'Retail Sale Id 4004',1480.00,0.00,0.00,2.00,170.00,'2022-07-03 13:21:08','',''),(3987,'1','273','1',1,'Retail Sale Id 4005',1480.00,0.00,0.00,2.00,170.00,'2022-07-03 13:29:18','',''),(3988,'1','273','1',1,'Retail Sale Id 4006',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 13:43:52','',''),(3989,'1','273','1',1,'Retail Sale Id 4007',740.00,0.00,0.00,1.00,85.00,'2022-07-03 13:46:15','',''),(3990,'1','273','1',1,'Retail Sale Id 4008',1998.00,0.00,0.00,2.70,229.50,'2022-07-03 13:51:59','',''),(3991,'1','273','1',1,'Retail Sale Id 4009',902.80,0.00,0.00,1.22,103.70,'2022-07-03 14:05:51','',''),(3992,'1','273','1',1,'Retail Sale Id 4010',7400.00,0.00,0.00,10.00,850.00,'2022-07-03 14:14:20','',''),(3993,'1','273','1',1,'Retail Sale Id 4011',7400.00,0.00,0.00,10.00,850.00,'2022-07-03 14:15:42','',''),(3994,'1','273','1',1,'Retail Sale Id 4012',4440.00,0.00,0.00,6.00,510.00,'2022-07-03 14:20:48','',''),(3995,'1','273','1',1,'Retail Sale Id 4013',9250.00,0.00,0.00,12.50,1062.50,'2022-07-03 14:29:43','',''),(3996,'1','273','1',1,'Retail Sale Id 4014',9250.00,0.00,0.00,12.50,1062.50,'2022-07-03 14:36:13','',''),(3997,'1','273','1',1,'Retail Sale Id 4015',4440.00,0.00,0.00,6.00,510.00,'2022-07-03 14:36:59','',''),(3998,'1','273','1',1,'Retail Sale Id 4016',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 14:38:19','',''),(3999,'1','273','1',1,'Retail Sale Id 4017',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 14:39:19','',''),(4000,'1','273','1',1,'Retail Sale Id 4018',3700.00,0.00,0.00,5.00,425.00,'2022-07-03 14:42:19','',''),(4001,'1','273','1',1,'Retail Sale Id 4019',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 14:43:28','',''),(4002,'1','273','1',1,'Retail Sale Id 4020',851.00,0.00,0.00,1.15,97.75,'2022-07-03 14:54:50','',''),(4003,'1','273','1',1,'Retail Sale Id 4021',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 15:01:41','',''),(4004,'1','273','1',1,'Retail Sale Id 4022',5920.00,0.00,0.00,8.00,680.00,'2022-07-03 15:02:32','',''),(4005,'1','273','1',1,'Retail Sale Id 4023',4440.00,0.00,0.00,6.00,510.00,'2022-07-03 15:03:48','',''),(4006,'1','273','1',1,'Retail Sale Id 4024',6001.40,0.00,0.00,8.11,689.35,'2022-07-03 15:05:32','',''),(4007,'1','273','1',1,'Retail Sale Id 4025',1480.00,0.00,0.00,2.00,170.00,'2022-07-03 15:23:32','',''),(4008,'1','273','1',1,'Retail Sale Id 4026',5180.00,0.00,0.00,7.00,595.00,'2022-07-03 15:29:21','',''),(4009,'1','273','1',1,'Retail Sale Id 4027',9250.00,0.00,0.00,12.50,1062.50,'2022-07-03 15:33:03','',''),(4010,'1','273','1',1,'Retail Sale Id 4028',7400.00,0.00,0.00,10.00,850.00,'2022-07-03 15:36:44','',''),(4011,'1','273','1',1,'Retail Sale Id 4029',999.00,0.00,0.00,1.35,114.75,'2022-07-03 15:39:47','',''),(4012,'1','273','1',1,'Retail Sale Id 4030',1998.00,0.00,0.00,2.70,229.50,'2022-07-03 15:42:40','',''),(4013,'1','273','1',1,'Retail Sale Id 4032',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 15:46:31','',''),(4014,'1','273','1',1,'Retail Sale Id 4033',999.00,0.00,0.00,1.35,114.75,'2022-07-03 15:52:34','',''),(4015,'1','273','1',1,'Retail Sale Id 4034',1480.00,0.00,0.00,2.00,170.00,'2022-07-03 16:00:16','',''),(4016,'1','273','1',1,'Retail Sale Id 4035',2997.00,0.00,0.00,4.05,344.25,'2022-07-03 16:11:36','',''),(4017,'1','273','1',1,'Retail Sale Id 4036',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 16:17:12','',''),(4018,'1','273','1',1,'Retail Sale Id 4037',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 16:17:53','',''),(4019,'1','273','1',1,'Retail Sale Id 4038',747.40,0.00,0.00,1.01,85.85,'2022-07-03 16:18:34','',''),(4020,'1','273','1',1,'Retail Sale Id 4039',747.40,0.00,0.00,1.01,85.85,'2022-07-03 16:19:23','',''),(4021,'1','273','1',1,'Retail Sale Id 4040',1998.00,0.00,0.00,2.70,229.50,'2022-07-03 16:20:05','',''),(4022,'1','273','1',1,'Retail Sale Id 4041',747.40,0.00,0.00,1.01,85.85,'2022-07-03 16:20:43','',''),(4023,'1','273','1',1,'Retail Sale Id 4042',747.40,0.00,0.00,1.01,85.85,'2022-07-03 16:28:16','',''),(4024,'1','273','1',1,'Retail Sale Id 4043',747.40,0.00,0.00,1.01,85.85,'2022-07-03 16:36:09','',''),(4025,'1','273','1',1,'Retail Sale Id 4044',1502.20,0.00,0.00,2.03,172.55,'2022-07-03 16:44:05','',''),(4026,'1','273','1',1,'Retail Sale Id 4045',747.40,0.00,0.00,1.01,85.85,'2022-07-03 16:50:01','',''),(4027,'1','273','1',1,'Retail Sale Id 4046',999.00,0.00,0.00,1.35,114.75,'2022-07-03 16:51:50','',''),(4028,'1','273','1',1,'Retail Sale Id 4047',1798.20,0.00,0.00,2.43,206.55,'2022-07-03 16:55:33','',''),(4029,'1','273','1',1,'Retail Sale Id 4048',2220.00,0.00,0.00,3.00,255.00,'2022-07-03 16:58:31','',''),(4030,'1','273','1',1,'Retail Sale Id 4049',740.00,0.00,0.00,1.00,85.00,'2022-07-03 17:06:08','',''),(4031,'1','273','1',1,'Retail Sale Id 4050',11100.00,0.00,0.00,15.00,1275.00,'2022-07-03 17:07:28','',''),(4032,'1','273','1',1,'Retail Sale Id 4051',1998.00,0.00,0.00,2.70,229.50,'2022-07-03 17:08:21','',''),(4033,'1','273','1',1,'Retail Sale Id 4052',740.00,0.00,0.00,1.00,85.00,'2022-07-03 17:11:11','',''),(4034,'1','273','1',1,'Retail Sale Id 4053',4440.00,0.00,0.00,6.00,510.00,'2022-07-03 17:17:30','',''),(4035,'1','273','1',1,'Retail Sale Id 4054',2249.60,0.00,0.00,3.04,258.40,'2022-07-03 17:21:18','',''),(4036,'1','273','1',1,'Retail Sale Id 4055',4003.40,0.00,0.00,5.41,459.85,'2022-07-03 17:30:44','',''),(4037,'1','273','1',1,'Retail Sale Id 4056',4080.00,0.00,0.00,6.00,150.00,'2022-07-03 17:32:53','',''),(4038,'1','273','1',1,'Retail Sale Id 4057',747.40,0.00,0.00,1.01,85.85,'2022-07-03 17:34:37','',''),(4039,'1','273','1',1,'Return of Retail Sale Id 4056',0.00,4080.00,6.00,0.00,-150.00,'2022-07-03 17:41:13','',''),(4040,'1','273','1',1,'Retail Sale Id 4058',4080.00,0.00,0.00,6.00,150.00,'2022-07-03 17:41:52','',''),(4041,'1','273','1',1,'Retail Sale Id 4059',999.00,0.00,0.00,1.35,114.75,'2022-07-03 17:46:56','',''),(4042,'1','273','1',1,'Return of Retail Sale Id 3997',0.00,37000.00,50.00,0.00,-4250.00,'2022-07-03 18:21:15','',''),(4043,'1','273','1',1,'Retail Sale Id 4060',34000.00,0.00,0.00,50.00,1250.00,'2022-07-03 18:21:47','',''),(4044,'1','273','1',1,'Retail Sale Id 4061',113560.00,0.00,0.00,167.00,4175.00,'2022-07-04 06:56:57','',''),(4045,'1','273','1',1,'Retail Sale Id 4062',81600.00,0.00,0.00,120.00,3000.00,'2022-07-04 06:58:04','',''),(4046,'1','273','1',1,'Retail Sale Id 4063',1998.00,0.00,0.00,2.70,229.50,'2022-07-04 07:00:27','',''),(4047,'1','273','1',1,'Retail Sale Id 4064',68000.00,0.00,0.00,100.00,2500.00,'2022-07-04 07:12:36','',''),(4048,'1','273','1',1,'Retail Sale Id 4065',747.40,0.00,0.00,1.01,85.85,'2022-07-04 07:13:53','',''),(4049,'1','273','1',1,'Retail Sale Id 4066',78200.00,0.00,0.00,115.00,2875.00,'2022-07-04 07:17:41','',''),(4050,'1','273','1',1,'Retail Sale Id 4067',102000.00,0.00,0.00,150.00,3750.00,'2022-07-04 07:42:18','',''),(4051,'1','273','1',1,'Retail Sale Id 4068',68000.00,0.00,0.00,100.00,2500.00,'2022-07-04 07:43:24','',''),(4052,'1','273','1',1,'Retail Sale Id 4069',2220.00,0.00,0.00,3.00,255.00,'2022-07-04 07:44:48','',''),(4053,'1','273','1',1,'Retail Sale Id 4070',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 07:49:44','',''),(4054,'1','273','1',1,'Retail Sale Id 4071',2220.00,0.00,0.00,3.00,255.00,'2022-07-04 07:51:34','',''),(4055,'1','273','1',1,'Retail Sale Id 4072',2220.00,0.00,0.00,3.00,255.00,'2022-07-04 07:54:27','',''),(4056,'1','273','1',1,'Retail Sale Id 4073',75140.00,0.00,0.00,110.50,2762.50,'2022-07-04 08:08:04','',''),(4057,'1','273','1',1,'Retail Sale Id 4074',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 08:19:47','',''),(4058,'1','273','1',1,'Retail Sale Id 4075',68000.00,0.00,0.00,100.00,2500.00,'2022-07-04 08:21:28','',''),(4059,'1','273','1',1,'Retail Sale Id 4076',7400.00,0.00,0.00,10.00,850.00,'2022-07-04 08:27:56','',''),(4060,'1','273','1',1,'Retail Sale Id 4077',1502.20,0.00,0.00,2.03,172.55,'2022-07-04 08:31:05','',''),(4061,'1','273','1',1,'Retail Sale Id 4078',999.00,0.00,0.00,1.35,114.75,'2022-07-04 08:37:57','',''),(4062,'1','273','1',1,'Retail Sale Id 4079',102000.00,0.00,0.00,150.00,3750.00,'2022-07-04 08:42:30','',''),(4063,'1','273','1',1,'Retail Sale Id 4080',68000.00,0.00,0.00,100.00,2500.00,'2022-07-04 08:43:19','',''),(4064,'1','273','1',1,'Retail Sale Id 4081',88400.00,0.00,0.00,130.00,3250.00,'2022-07-04 08:52:09','',''),(4065,'1','273','1',1,'Retail Sale Id 4082',9250.00,0.00,0.00,12.50,1062.50,'2022-07-04 08:53:02','',''),(4066,'1','273','1',1,'Retail Sale Id 4083',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 08:53:59','',''),(4067,'1','273','1',1,'Retail Sale Id 4084',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 09:19:49','',''),(4068,'1','273','1',1,'Retail Sale Id 4085',747.40,0.00,0.00,1.01,85.85,'2022-07-04 09:27:36','',''),(4069,'1','273','1',1,'Retail Sale Id 4086',9250.00,0.00,0.00,12.50,1062.50,'2022-07-04 09:46:19','',''),(4070,'1','273','1',1,'Retail Sale Id 4087',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 10:15:05','',''),(4071,'1','273','1',1,'Retail Sale Id 4088',170000.00,0.00,0.00,250.00,6250.00,'2022-07-04 10:25:16','',''),(4072,'1','273','1',1,'Retail Sale Id 4089',9250.00,0.00,0.00,12.50,1062.50,'2022-07-04 10:26:55','',''),(4073,'1','273','1',1,'Retail Sale Id 4090',144160.00,0.00,0.00,212.00,5300.00,'2022-07-04 10:32:03','',''),(4074,'1','273','1',1,'Retail Sale Id 4091',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 11:03:12','',''),(4075,'1','273','1',1,'Retail Sale Id 4092',5002.40,0.00,0.00,6.76,574.60,'2022-07-04 11:18:52','',''),(4076,'1','273','1',1,'Retail Sale Id 4093',6800.00,0.00,0.00,10.00,250.00,'2022-07-04 12:06:13','',''),(4077,'1','273','1',1,'Retail Sale Id 4094',8880.00,0.00,0.00,12.00,1020.00,'2022-07-04 12:11:27','',''),(4078,'1','273','1',1,'Retail Sale Id 4095',6660.00,0.00,0.00,9.00,765.00,'2022-07-04 12:17:04','',''),(4079,'1','273','1',1,'Retail Sale Id 4096',107440.00,0.00,0.00,158.00,3950.00,'2022-07-04 12:19:08','',''),(4080,'1','273','1',1,'Retail Sale Id 4097',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 12:20:12','',''),(4081,'1','273','1',1,'Retail Sale Id 4098',1502.20,0.00,0.00,2.03,172.55,'2022-07-04 12:22:35','',''),(4082,'1','273','1',1,'Retail Sale Id 4099',81600.00,0.00,0.00,120.00,3000.00,'2022-07-04 12:25:36','',''),(4083,'1','273','1',1,'Retail Sale Id 4100',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 12:48:20','',''),(4084,'1','273','1',1,'Retail Sale Id 4101',9997.40,0.00,0.00,13.51,1148.35,'2022-07-04 12:57:45','',''),(4085,'1','273','1',1,'Retail Sale Id 4102',9250.00,0.00,0.00,12.50,1062.50,'2022-07-04 13:05:28','',''),(4086,'1','273','1',1,'Retail Sale Id 4103',4440.00,0.00,0.00,6.00,510.00,'2022-07-04 13:13:16','',''),(4087,'1','273','1',1,'Retail Sale Id 4104',10880.00,0.00,0.00,16.00,400.00,'2022-07-04 13:25:09','',''),(4088,'1','273','1',1,'Retail Sale Id 4105',2220.00,0.00,0.00,3.00,255.00,'2022-07-04 13:33:43','',''),(4089,'1','273','1',1,'Retail Sale Id 4106',11100.00,0.00,0.00,15.00,1275.00,'2022-07-04 13:44:30','',''),(4090,'1','273','1',1,'Retail Sale Id 4107',81600.00,0.00,0.00,120.00,3000.00,'2022-07-04 13:51:59','',''),(4091,'1','273','1',1,'Retail Sale Id 4108',34000.00,0.00,0.00,50.00,1250.00,'2022-07-04 14:20:18','',''),(4092,'1','273','1',1,'Retail Sale Id 4109',4440.00,0.00,0.00,6.00,510.00,'2022-07-04 14:21:09','',''),(4093,'1','273','1',1,'Retail Sale Id 4110',9250.00,0.00,0.00,12.50,1062.50,'2022-07-04 14:27:35','',''),(4094,'1','273','1',1,'Retail Sale Id 4111',2220.00,0.00,0.00,3.00,255.00,'2022-07-04 14:35:38','',''),(4095,'1','273','1',1,'Retail Sale Id 4112',1480.00,0.00,0.00,2.00,170.00,'2022-07-04 14:37:21','',''),(4096,'1','273','1',1,'Retail Sale Id 4113',2220.00,0.00,0.00,3.00,255.00,'2022-07-04 14:38:39','',''),(4097,'1','273','1',1,'Retail Sale Id 4114',1480.00,0.00,0.00,2.00,170.00,'2022-07-04 14:39:30','',''),(4098,'1','273','1',1,'Retail Sale Id 4115',6660.00,0.00,0.00,9.00,765.00,'2022-07-04 14:49:59','',''),(4099,'1','273','1',1,'Retail Sale Id 4116',9250.00,0.00,0.00,12.50,1062.50,'2022-07-04 15:11:45','',''),(4100,'1','273','1',1,'Retail Sale Id 4117',747.40,0.00,0.00,1.01,85.85,'2022-07-04 15:13:38','',''),(4101,'1','273','1',1,'Retail Sale Id 4118',2249.60,0.00,0.00,3.04,258.40,'2022-07-04 15:26:31','',''),(4102,'1','273','1',1,'Retail Sale Id 4119',999.00,0.00,0.00,1.35,114.75,'2022-07-04 15:27:31','',''),(4103,'1','273','1',1,'Retail Sale Id 4120',4440.00,0.00,0.00,6.00,510.00,'2022-07-04 15:30:18','',''),(4104,'1','273','1',1,'Retail Sale Id 4121',2101.60,0.00,0.00,2.84,241.40,'2022-07-04 15:34:59','',''),(4105,'1','273','1',1,'Retail Sale Id 4122',740.00,0.00,0.00,1.00,85.00,'2022-07-04 15:36:37','',''),(4106,'1','273','1',1,'Retail Sale Id 4123',1998.00,0.00,0.00,2.70,229.50,'2022-07-04 15:47:19','',''),(4107,'1','273','1',1,'Retail Sale Id 4124',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 15:51:08','',''),(4108,'1','273','1',1,'Retail Sale Id 4125',3500.20,0.00,0.00,4.73,402.05,'2022-07-04 15:55:58','',''),(4109,'1','273','1',1,'Retail Sale Id 4126',68000.00,0.00,0.00,100.00,2500.00,'2022-07-04 16:06:03','',''),(4110,'1','273','1',1,'Retail Sale Id 4127',68000.00,0.00,0.00,100.00,2500.00,'2022-07-04 16:07:11','',''),(4111,'1','273','1',1,'Retail Sale Id 4128',902.80,0.00,0.00,1.22,103.70,'2022-07-04 16:15:47','',''),(4112,'1','273','1',1,'Retail Sale Id 4129',1480.00,0.00,0.00,2.00,170.00,'2022-07-04 16:17:25','',''),(4113,'1','273','1',1,'Retail Sale Id 4130',1480.00,0.00,0.00,2.00,170.00,'2022-07-04 16:20:17','',''),(4114,'1','273','1',1,'Retail Sale Id 4131',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 16:21:19','',''),(4115,'1','273','1',1,'Retail Sale Id 4132',1998.00,0.00,0.00,2.70,229.50,'2022-07-04 16:22:26','',''),(4116,'1','273','1',1,'Retail Sale Id 4133',747.40,0.00,0.00,1.01,85.85,'2022-07-04 16:23:26','',''),(4117,'1','273','1',1,'Retail Sale Id 4134',27200.00,0.00,0.00,40.00,1000.00,'2022-07-04 16:24:25','',''),(4118,'1','273','1',1,'Retail Sale Id 4135',27880.00,0.00,0.00,41.00,1025.00,'2022-07-04 16:25:08','',''),(4119,'1','273','1',1,'Retail Sale Id 4136',747.40,0.00,0.00,1.01,85.85,'2022-07-04 16:25:47','',''),(4120,'1','273','1',1,'Retail Sale Id 4137',2249.60,0.00,0.00,3.04,258.40,'2022-07-04 16:26:41','',''),(4121,'1','273','1',1,'Retail Sale Id 4138',2249.60,0.00,0.00,3.04,258.40,'2022-07-04 16:27:40','',''),(4122,'1','273','1',1,'Retail Sale Id 4139',4099.60,0.00,0.00,5.54,470.90,'2022-07-04 16:28:51','',''),(4123,'1','273','1',1,'Retail Sale Id 4140',7400.00,0.00,0.00,10.00,850.00,'2022-07-04 16:29:37','',''),(4124,'1','273','1',1,'Retail Sale Id 4141',2220.00,0.00,0.00,3.00,255.00,'2022-07-04 16:31:41','',''),(4125,'1','273','1',1,'Retail Sale Id 4142',1998.00,0.00,0.00,2.70,229.50,'2022-07-04 16:33:33','',''),(4126,'1','273','1',1,'Retail Sale Id 4143',1502.20,0.00,0.00,2.03,172.55,'2022-07-04 16:36:08','',''),(4127,'1','273','1',1,'Retail Sale Id 4144',4440.00,0.00,0.00,6.00,510.00,'2022-07-04 16:36:53','',''),(4128,'1','273','1',1,'Retail Sale Id 4145',2249.60,0.00,0.00,3.04,258.40,'2022-07-04 16:42:50','',''),(4129,'1','273','1',1,'Retail Sale Id 4146',1480.00,0.00,0.00,2.00,170.00,'2022-07-04 16:49:32','',''),(4130,'1','273','1',1,'Retail Sale Id 4147',1850.00,0.00,0.00,2.50,212.50,'2022-07-04 16:56:22','',''),(4131,'1','273','1',1,'Retail Sale Id 4148',3700.00,0.00,0.00,5.00,425.00,'2022-07-04 16:58:04','',''),(4132,'1','273','1',1,'Retail Sale Id 4149',4440.00,0.00,0.00,6.00,510.00,'2022-07-05 06:38:08','',''),(4133,'1','273','1',1,'Retail Sale Id 4150',999.00,0.00,0.00,1.35,114.75,'2022-07-05 06:38:50','',''),(4134,'1','273','1',1,'Retail Sale Id 4151',6001.40,0.00,0.00,8.11,689.35,'2022-07-05 07:05:49','',''),(4135,'1','273','1',1,'Retail Sale Id 4152',2997.00,0.00,0.00,4.05,344.25,'2022-07-05 07:06:56','',''),(4136,'1','273','1',1,'Retail Sale Id 4153',1502.20,0.00,0.00,2.03,172.55,'2022-07-05 07:16:24','',''),(4137,'1','273','1',1,'Retail Sale Id 4154',34000.00,0.00,0.00,50.00,1250.00,'2022-07-05 07:26:43','',''),(4138,'1','273','1',1,'Retail Sale Id 4155',999.00,0.00,0.00,1.35,114.75,'2022-07-05 07:43:59','',''),(4139,'1','273','1',1,'Retail Sale Id 4156',3700.00,0.00,0.00,5.00,425.00,'2022-07-05 07:47:19','',''),(4140,'1','273','1',1,'Retail Sale Id 4157',2197.80,0.00,0.00,2.97,252.45,'2022-07-05 07:52:00','',''),(4141,'1','273','1',1,'Retail Sale Id 4158',740.00,0.00,0.00,1.00,85.00,'2022-07-05 08:03:18','',''),(4142,'1','273','1',1,'Retail Sale Id 4159',1480.00,0.00,0.00,2.00,170.00,'2022-07-05 08:04:59','',''),(4143,'1','273','1',1,'Retail Sale Id 4160',4499.20,0.00,0.00,6.08,516.80,'2022-07-05 08:09:02','',''),(4144,'1','273','1',1,'Retail Sale Id 4161',6001.40,0.00,0.00,8.11,689.35,'2022-07-05 08:10:24','',''),(4145,'1','273','1',1,'Retail Sale Id 4162',9250.00,0.00,0.00,12.50,1062.50,'2022-07-05 08:11:38','',''),(4146,'1','273','1',1,'Retail Sale Id 4163',1480.00,0.00,0.00,2.00,170.00,'2022-07-05 08:18:34','',''),(4147,'1','273','1',1,'Retail Sale Id 4164',2197.80,0.00,0.00,2.97,252.45,'2022-07-05 08:32:01','',''),(4148,'1','273','1',1,'Retail Sale Id 4165',2960.00,0.00,0.00,4.00,340.00,'2022-07-05 08:32:53','',''),(4149,'1','273','1',1,'Retail Sale Id 4166',9250.00,0.00,0.00,12.50,1062.50,'2022-07-05 08:33:44','',''),(4150,'1','273','1',1,'Retail Sale Id 4167',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 08:35:03','',''),(4151,'1','273','1',1,'Retail Sale Id 4168',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 08:45:49','',''),(4152,'1','273','1',1,'Retail Sale Id 4169',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 08:50:02','',''),(4153,'1','273','1',1,'Retail Sale Id 4170',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 08:53:25','',''),(4154,'1','273','1',1,'Retail Sale Id 4171',18500.00,0.00,0.00,25.00,2125.00,'2022-07-05 08:56:19','',''),(4155,'1','273','1',1,'Retail Sale Id 4172',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 12:09:57','',''),(4156,'1','273','1',1,'Retail Sale Id 4173',5180.00,0.00,0.00,7.00,595.00,'2022-07-05 13:11:59','',''),(4157,'1','273','1',1,'Retail Sale Id 4174',3700.00,0.00,0.00,5.00,425.00,'2022-07-05 13:14:44','',''),(4158,'1','273','1',1,'Retail Sale Id 4175',2960.00,0.00,0.00,4.00,340.00,'2022-07-05 13:18:45','',''),(4159,'1','273','1',1,'Retail Sale Id 4176',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 13:30:56','',''),(4160,'1','273','1',1,'Retail Sale Id 4177',1198.80,0.00,0.00,1.62,137.70,'2022-07-05 13:32:11','',''),(4161,'1','273','1',1,'Retail Sale Id 4178',747.40,0.00,0.00,1.01,85.85,'2022-07-05 13:33:22','',''),(4162,'1','273','1',1,'Retail Sale Id 4179',80240.00,0.00,0.00,118.00,2950.00,'2022-07-05 13:35:11','',''),(4163,'1','273','1',1,'Retail Sale Id 4180',5180.00,0.00,0.00,7.00,595.00,'2022-07-05 14:04:48','',''),(4164,'1','273','1',1,'Retail Sale Id 4181',999.00,0.00,0.00,1.35,114.75,'2022-07-05 14:13:54','',''),(4165,'1','273','1',1,'Retail Sale Id 4182',10200.00,0.00,0.00,15.00,375.00,'2022-07-05 14:20:51','',''),(4166,'1','273','1',1,'Retail Sale Id 4183',747.40,0.00,0.00,1.01,85.85,'2022-07-05 14:21:51','',''),(4167,'1','273','1',1,'Retail Sale Id 4184',9250.00,0.00,0.00,12.50,1062.50,'2022-07-05 14:25:41','',''),(4168,'1','273','1',1,'Retail Sale Id 4185',1502.20,0.00,0.00,2.03,172.55,'2022-07-05 14:29:37','',''),(4169,'1','273','1',1,'Retail Sale Id 4186',999.00,0.00,0.00,1.35,114.75,'2022-07-05 14:30:44','',''),(4170,'1','273','1',1,'Retail Sale Id 4187',26640.00,0.00,0.00,36.00,3060.00,'2022-07-05 14:56:48','',''),(4171,'1','273','1',1,'Retail Sale Id 4188',61200.00,0.00,0.00,90.00,2250.00,'2022-07-05 15:00:05','',''),(4172,'1','273','1',1,'Retail Sale Id 4189',61200.00,0.00,0.00,90.00,2250.00,'2022-07-05 15:01:02','',''),(4173,'1','273','1',1,'Retail Sale Id 4190',1480.00,0.00,0.00,2.00,170.00,'2022-07-05 15:01:44','',''),(4174,'1','273','1',1,'Retail Sale Id 4191',2997.00,0.00,0.00,4.05,344.25,'2022-07-05 15:04:03','',''),(4175,'1','273','1',1,'Retail Sale Id 4192',9250.00,0.00,0.00,12.50,1062.50,'2022-07-05 15:06:52','',''),(4176,'1','273','1',1,'Retail Sale Id 4193',68000.00,0.00,0.00,100.00,2500.00,'2022-07-05 15:18:06','',''),(4177,'1','273','1',1,'Retail Sale Id 4194',111180.00,0.00,0.00,163.50,4087.50,'2022-07-05 15:19:13','',''),(4178,'1','273','1',1,'Retail Sale Id 4195',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 15:22:32','',''),(4179,'1','273','1',1,'Retail Sale Id 4196',7400.00,0.00,0.00,10.00,850.00,'2022-07-05 15:23:59','',''),(4180,'1','273','1',1,'Retail Sale Id 4197',999.00,0.00,0.00,1.35,114.75,'2022-07-05 15:27:23','',''),(4181,'1','273','1',1,'Retail Sale Id 4198',747.40,0.00,0.00,1.01,85.85,'2022-07-05 15:28:19','',''),(4182,'1','273','1',1,'Retail Sale Id 4199',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 15:31:14','',''),(4183,'1','273','1',1,'Retail Sale Id 4200',13690.00,0.00,0.00,18.50,1572.50,'2022-07-05 15:35:21','',''),(4184,'1','273','1',1,'Retail Sale Id 4201',5180.00,0.00,0.00,7.00,595.00,'2022-07-05 15:36:45','',''),(4185,'1','273','1',1,'Retail Sale Id 4202',747.40,0.00,0.00,1.01,85.85,'2022-07-05 15:38:46','',''),(4186,'1','273','1',1,'Retail Sale Id 4203',902.80,0.00,0.00,1.22,103.70,'2022-07-05 15:40:20','',''),(4187,'1','273','1',1,'Retail Sale Id 4204',3700.00,0.00,0.00,5.00,425.00,'2022-07-05 15:42:44','',''),(4188,'1','273','1',1,'Retail Sale Id 4205',999.00,0.00,0.00,1.35,114.75,'2022-07-05 15:45:40','',''),(4189,'1','273','1',1,'Retail Sale Id 4206',5180.00,0.00,0.00,7.00,595.00,'2022-07-05 15:48:37','',''),(4190,'1','273','1',1,'Retail Sale Id 4207',1502.20,0.00,0.00,2.03,172.55,'2022-07-05 15:49:49','',''),(4191,'1','273','1',1,'Retail Sale Id 4208',799.20,0.00,0.00,1.08,91.80,'2022-07-05 15:54:40','',''),(4192,'1','273','1',1,'Retail Sale Id 4209',2249.60,0.00,0.00,3.04,258.40,'2022-07-05 15:56:22','',''),(4193,'1','273','1',1,'Retail Sale Id 4210',747.40,0.00,0.00,1.01,85.85,'2022-07-05 15:58:47','',''),(4194,'1','273','1',1,'Retail Sale Id 4211',2249.60,0.00,0.00,3.04,258.40,'2022-07-05 16:12:24','',''),(4195,'1','273','1',1,'Retail Sale Id 4212',747.40,0.00,0.00,1.01,85.85,'2022-07-05 16:14:48','',''),(4196,'1','273','1',1,'Retail Sale Id 4213',2960.00,0.00,0.00,4.00,340.00,'2022-07-05 16:21:09','',''),(4197,'1','273','1',1,'Retail Sale Id 4214',68000.00,0.00,0.00,100.00,2500.00,'2022-07-05 16:31:20','',''),(4198,'1','273','1',1,'Retail Sale Id 4215',3700.00,0.00,0.00,5.00,425.00,'2022-07-05 16:32:31','',''),(4199,'1','273','1',1,'Retail Sale Id 4216',902.80,0.00,0.00,1.22,103.70,'2022-07-05 16:34:00','',''),(4200,'1','273','1',1,'Retail Sale Id 4217',3700.00,0.00,0.00,5.00,425.00,'2022-07-05 16:44:58','',''),(4201,'1','273','1',1,'Retail Sale Id 4218',999.00,0.00,0.00,1.35,114.75,'2022-07-05 16:46:09','',''),(4202,'1','273','1',1,'Retail Sale Id 4219',740.00,0.00,0.00,1.00,85.00,'2022-07-05 16:47:30','',''),(4203,'1','273','1',1,'Retail Sale Id 4220',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 16:52:21','',''),(4204,'1','273','1',1,'Retail Sale Id 4221',747.40,0.00,0.00,1.01,85.85,'2022-07-05 16:55:24','',''),(4205,'1','273','1',1,'Retail Sale Id 4222',747.40,0.00,0.00,1.01,85.85,'2022-07-05 16:57:44','',''),(4206,'1','273','1',1,'Retail Sale Id 4223',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 17:00:36','',''),(4207,'1','273','1',1,'Retail Sale Id 4224',1480.00,0.00,0.00,2.00,170.00,'2022-07-05 17:01:34','',''),(4208,'1','273','1',1,'Retail Sale Id 4225',1502.20,0.00,0.00,2.03,172.55,'2022-07-05 17:03:27','',''),(4209,'1','273','1',1,'Retail Sale Id 4226',999.00,0.00,0.00,1.35,114.75,'2022-07-05 17:10:26','',''),(4210,'1','273','1',1,'Retail Sale Id 4227',23120.00,0.00,0.00,34.00,850.00,'2022-07-05 17:11:59','',''),(4211,'1','273','1',1,'Retail Sale Id 4228',2960.00,0.00,0.00,4.00,340.00,'2022-07-05 17:14:09','',''),(4212,'1','273','1',1,'Retail Sale Id 4229',3700.00,0.00,0.00,5.00,425.00,'2022-07-05 17:20:17','',''),(4213,'1','273','1',1,'Retail Sale Id 4230',2220.00,0.00,0.00,3.00,255.00,'2022-07-05 17:25:51','',''),(4214,'1','273','1',1,'Retail Sale Id 4231',747.40,0.00,0.00,1.01,85.85,'2022-07-05 17:33:52','',''),(4215,'1','273','1',1,'Retail Sale Id 4232',9250.00,0.00,0.00,12.50,1062.50,'2022-07-05 17:36:41','',''),(4216,'1','273','1',1,'Retail Sale Id 4233',7400.00,0.00,0.00,10.00,850.00,'2022-07-05 17:41:09','',''),(4217,'1','273','1',1,'Retail Sale Id 4234',1480.00,0.00,0.00,2.00,170.00,'2022-07-05 17:42:09','',''),(4218,'1','273','1',1,'Retail Sale Id 4235',1480.00,0.00,0.00,2.00,170.00,'2022-07-05 17:43:47','',''),(4219,'1','273','1',1,'Retail Sale Id 4236',999.00,0.00,0.00,1.35,114.75,'2022-07-05 17:45:04','',''),(4220,'1','273','1',1,'Retail Sale Id 4237',747.40,0.00,0.00,1.01,85.85,'2022-07-05 17:49:55','',''),(4221,'1','273','1',1,'Retail Sale Id 4238',2501.20,0.00,0.00,3.38,287.30,'2022-07-05 17:51:16','',''),(4222,'1','273','1',1,'Retail Sale Id 4239',1901.80,0.00,0.00,2.57,218.45,'2022-07-05 17:52:42','',''),(4223,'1','273','1',1,'Retail Sale Id 4240',999.00,0.00,0.00,1.35,114.75,'2022-07-05 17:54:01','',''),(4224,'1','273','1',1,'Retail Sale Id 4241',2197.80,0.00,0.00,2.97,252.45,'2022-07-05 17:56:05','',''),(4225,'1','273','1',1,'Retail Sale Id 4242',2997.00,0.00,0.00,4.05,344.25,'2022-07-05 17:57:15','',''),(4226,'1','273','1',1,'Retail Sale Id 4243',45560.00,0.00,0.00,67.00,1675.00,'2022-07-05 18:01:47','',''),(4227,'1','273','1',1,'Retail Sale Id 4244',747.40,0.00,0.00,1.01,85.85,'2022-07-05 18:07:21','',''),(4228,'1','273','1',1,'Retail Sale Id 4245',799.20,0.00,0.00,1.08,91.80,'2022-07-06 06:46:55','',''),(4229,'1','273','1',1,'Retail Sale Id 4246',747.40,0.00,0.00,1.01,85.85,'2022-07-06 06:55:22','',''),(4230,'1','273','1',1,'Retail Sale Id 4247',6660.00,0.00,0.00,9.00,765.00,'2022-07-06 06:59:30','',''),(4231,'1','273','1',1,'Retail Sale Id 4248',74800.00,0.00,0.00,110.00,2750.00,'2022-07-06 07:02:34','',''),(4232,'1','273','1',1,'Retail Sale Id 4249',77520.00,0.00,0.00,114.00,2850.00,'2022-07-06 07:03:25','',''),(4233,'1','273','1',1,'Retail Sale Id 4250',81600.00,0.00,0.00,120.00,3000.00,'2022-07-06 07:11:10','',''),(4234,'1','273','1',1,'Retail Sale Id 4251',81600.00,0.00,0.00,120.00,3000.00,'2022-07-06 07:11:48','',''),(4235,'1','273','1',1,'Retail Sale Id 4252',1502.20,0.00,0.00,2.03,172.55,'2022-07-06 07:24:18','',''),(4236,'1','273','1',1,'Retail Sale Id 4253',9250.00,0.00,0.00,12.50,1062.50,'2022-07-06 07:42:33','',''),(4237,'1','273','1',1,'Retail Sale Id 4254',102000.00,0.00,0.00,150.00,3750.00,'2022-07-06 07:45:46','',''),(4238,'1','273','1',1,'Retail Sale Id 4255',68000.00,0.00,0.00,100.00,2500.00,'2022-07-06 07:46:27','',''),(4239,'1','273','1',1,'Retail Sale Id 4256',1998.00,0.00,0.00,2.70,229.50,'2022-07-06 07:52:01','',''),(4240,'1','273','1',1,'Retail Sale Id 4257',81600.00,0.00,0.00,120.00,3000.00,'2022-07-06 08:00:51','',''),(4241,'1','273','1',1,'Retail Sale Id 4258',4440.00,0.00,0.00,6.00,510.00,'2022-07-06 08:21:26','',''),(4242,'1','273','1',1,'Retail Sale Id 4259',2220.00,0.00,0.00,3.00,255.00,'2022-07-06 08:24:06','',''),(4243,'1','273','1',1,'Retail Sale Id 4260',34000.00,0.00,0.00,50.00,1250.00,'2022-07-06 08:26:47','',''),(4244,'1','273','1',1,'Retail Sale Id 4261',7400.00,0.00,0.00,10.00,850.00,'2022-07-06 08:38:56','',''),(4245,'1','273','1',1,'Retail Sale Id 4262',71998.40,0.00,0.00,105.88,2647.00,'2022-07-06 08:40:32','',''),(4246,'1','273','1',1,'Retail Sale Id 4263',8140.00,0.00,0.00,11.00,935.00,'2022-07-06 08:41:16','',''),(4247,'1','273','1',1,'Retail Sale Id 4264',102000.00,0.00,0.00,150.00,3750.00,'2022-07-06 08:42:02','',''),(4248,'1','273','1',1,'Retail Sale Id 4265',740.00,0.00,0.00,1.00,85.00,'2022-07-06 08:52:07','',''),(4249,'1','273','1',1,'Retail Sale Id 4266',2960.00,0.00,0.00,4.00,340.00,'2022-07-06 08:56:38','',''),(4250,'1','273','1',1,'Retail Sale Id 4267',747.40,0.00,0.00,1.01,85.85,'2022-07-06 08:57:54','',''),(4251,'1','273','1',1,'Retail Sale Id 4268',999.00,0.00,0.00,1.35,114.75,'2022-07-06 08:59:10','',''),(4252,'1','273','1',1,'Retail Sale Id 4269',999.00,0.00,0.00,1.35,114.75,'2022-07-06 09:00:11','',''),(4253,'1','273','1',1,'Retail Sale Id 4270',3700.00,0.00,0.00,5.00,425.00,'2022-07-06 09:05:28','',''),(4254,'1','273','1',1,'Retail Sale Id 4271',136000.00,0.00,0.00,200.00,5000.00,'2022-07-06 09:08:22','',''),(4255,'1','273','1',1,'Retail Sale Id 4272',102000.00,0.00,0.00,150.00,3750.00,'2022-07-06 09:10:07','',''),(4256,'1','273','1',1,'Retail Sale Id 4273',8880.00,0.00,0.00,12.00,1020.00,'2022-07-06 09:11:02','',''),(4257,'1','273','1',1,'Retail Sale Id 4274',7400.00,0.00,0.00,10.00,850.00,'2022-07-06 09:14:15','',''),(4258,'1','273','1',1,'Retail Sale Id 4275',62900.00,0.00,0.00,92.50,2312.50,'2022-07-06 09:27:30','',''),(4259,'1','273','1',1,'Retail Sale Id 4276',1480.00,0.00,0.00,2.00,170.00,'2022-07-06 09:53:14','',''),(4260,'1','273','1',1,'Retail Sale Id 4277',2220.00,0.00,0.00,3.00,255.00,'2022-07-06 10:01:36','',''),(4261,'1','273','1',1,'Retail Sale Id 4278',999.00,0.00,0.00,1.35,114.75,'2022-07-06 10:49:18','',''),(4262,'1','273','1',1,'Retail Sale Id 4279',46920.00,0.00,0.00,69.00,1725.00,'2022-07-06 11:00:31','',''),(4263,'1','273','1',1,'Retail Sale Id 4280',34000.00,0.00,0.00,50.00,1250.00,'2022-07-06 11:02:05','',''),(4264,'1','273','1',1,'Retail Sale Id 4281',1480.00,0.00,0.00,2.00,170.00,'2022-07-06 11:02:56','',''),(4265,'1','273','1',1,'Retail Sale Id 4282',4440.00,0.00,0.00,6.00,510.00,'2022-07-06 11:15:42','',''),(4266,'1','273','1',1,'Retail Sale Id 4284',8140.00,0.00,0.00,11.00,935.00,'2022-07-06 11:19:06','',''),(4267,'1','273','1',1,'Retail Sale Id 4285',1480.00,0.00,0.00,2.00,170.00,'2022-07-06 11:21:02','',''),(4268,'1','273','1',1,'Retail Sale Id 4286',747.40,0.00,0.00,1.01,85.85,'2022-07-06 11:33:38','',''),(4269,'1','273','1',1,'Retail Sale Id 4289',2997.00,0.00,0.00,4.05,344.25,'2022-07-06 11:35:16','',''),(4270,'1','273','1',1,'Retail Sale Id 4290',4003.40,0.00,0.00,5.41,459.85,'2022-07-06 11:36:27','',''),(4271,'1','273','1',1,'Retail Sale Id 4291',2249.60,0.00,0.00,3.04,258.40,'2022-07-06 11:53:19','',''),(4272,'1','273','1',1,'Retail Sale Id 4292',7400.00,0.00,0.00,10.00,850.00,'2022-07-06 11:59:27','',''),(4273,'1','273','1',1,'Retail Sale Id 4293',20400.00,0.00,0.00,30.00,750.00,'2022-07-06 12:03:58','',''),(4274,'1','273','1',1,'Retail Sale Id 4294',747.40,0.00,0.00,1.01,85.85,'2022-07-06 12:05:08','',''),(4275,'1','273','1',1,'Retail Sale Id 4295',8500.00,0.00,0.00,12.50,312.50,'2022-07-06 12:14:23','',''),(4276,'1','273','1',1,'Retail Sale Id 4296',6660.00,0.00,0.00,9.00,765.00,'2022-07-06 12:15:58','',''),(4277,'1','273','1',1,'Retail Sale Id 4297',34000.00,0.00,0.00,50.00,1250.00,'2022-07-06 12:18:04','',''),(4278,'1','273','1',1,'Retail Sale Id 4298',7400.00,0.00,0.00,10.00,850.00,'2022-07-06 12:21:14','',''),(4279,'1','273','1',1,'Retail Sale Id 4299',10880.00,0.00,0.00,16.00,400.00,'2022-07-06 12:26:12','',''),(4280,'1','273','1',1,'Retail Sale Id 4300',5949.60,0.00,0.00,8.04,683.40,'2022-07-06 12:29:15','',''),(4281,'1','273','1',1,'Retail Sale Id 4301',3700.00,0.00,0.00,5.00,425.00,'2022-07-06 12:30:50','',''),(4282,'1','273','1',1,'Retail Sale Id 4302',902.80,0.00,0.00,1.22,103.70,'2022-07-06 12:47:24','',''),(4283,'1','273','1',1,'Retail Sale Id 4303',740.00,0.00,0.00,1.00,85.00,'2022-07-06 12:53:39','',''),(4284,'1','273','1',1,'Retail Sale Id 4304',1502.20,0.00,0.00,2.03,172.55,'2022-07-06 13:01:48','',''),(4285,'1','273','1',1,'Retail Sale Id 4305',2197.80,0.00,0.00,2.97,252.45,'2022-07-06 13:03:46','',''),(4286,'1','273','1',1,'Retail Sale Id 4306',49640.00,0.00,0.00,73.00,1825.00,'2022-07-06 13:07:50','',''),(4287,'1','273','1',1,'Retail Sale Id 4307',9250.00,0.00,0.00,12.50,1062.50,'2022-07-06 13:12:35','',''),(4288,'1','273','1',1,'Retail Sale Id 4308',8140.00,0.00,0.00,11.00,935.00,'2022-07-06 13:16:26','',''),(4289,'1','273','1',1,'Retail Sale Id 4309',999.00,0.00,0.00,1.35,114.75,'2022-07-06 13:19:57','',''),(4290,'1','273','1',1,'Retail Sale Id 4310',8880.00,0.00,0.00,12.00,1020.00,'2022-07-06 13:32:22','',''),(4291,'1','273','1',1,'Retail Sale Id 4311',2220.00,0.00,0.00,3.00,255.00,'2022-07-06 13:36:31','',''),(4292,'1','273','1',1,'Retail Sale Id 4312',8880.00,0.00,0.00,12.00,1020.00,'2022-07-06 13:37:37','',''),(4293,'1','273','1',1,'Retail Sale Id 4313',9250.00,0.00,0.00,12.50,1062.50,'2022-07-06 13:45:08','',''),(4294,'1','273','1',1,'Retail Sale Id 4314',1998.00,0.00,0.00,2.70,229.50,'2022-07-06 13:49:06','',''),(4295,'1','273','1',1,'Retail Sale Id 4315',9250.00,0.00,0.00,12.50,1062.50,'2022-07-06 13:52:26','',''),(4296,'1','273','1',1,'Retail Sale Id 4316',7400.00,0.00,0.00,10.00,850.00,'2022-07-06 14:06:08','',''),(4297,'1','273','1',1,'Retail Sale Id 4317',4440.00,0.00,0.00,6.00,510.00,'2022-07-06 14:21:44','',''),(4298,'1','273','1',1,'Retail Sale Id 4318',1998.00,0.00,0.00,2.70,229.50,'2022-07-06 14:44:29','',''),(4299,'1','273','1',1,'Retail Sale Id 4319',5180.00,0.00,0.00,7.00,595.00,'2022-07-06 15:18:08','',''),(4300,'1','273','1',1,'Retail Sale Id 4320',7400.00,0.00,0.00,10.00,850.00,'2022-07-06 15:23:59','',''),(4301,'1','273','1',1,'Retail Sale Id 4321',8140.00,0.00,0.00,11.00,935.00,'2022-07-06 15:46:33','',''),(4302,'1','273','1',1,'Retail Sale Id 4322',27200.00,0.00,0.00,40.00,1000.00,'2022-07-06 15:51:21','',''),(4303,'1','273','1',1,'Retail Sale Id 4323',747.40,0.00,0.00,1.01,85.85,'2022-07-06 15:52:44','',''),(4304,'1','273','1',1,'Retail Sale Id 4324',68000.00,0.00,0.00,100.00,2500.00,'2022-07-06 16:23:30','',''),(4305,'1','273','1',1,'Retail Sale Id 4325',38080.00,0.00,0.00,56.00,1400.00,'2022-07-06 16:25:43','',''),(4306,'1','273','1',1,'Retail Sale Id 4326',999.00,0.00,0.00,1.35,114.75,'2022-07-06 16:34:03','',''),(4307,'1','273','1',1,'Retail Sale Id 4327',4440.00,0.00,0.00,6.00,510.00,'2022-07-06 16:51:37','',''),(4308,'1','273','1',1,'Retail Sale Id 4328',40800.00,0.00,0.00,60.00,1500.00,'2022-07-06 16:59:58','',''),(4309,'1','273','1',1,'Retail Sale Id 4329',61200.00,0.00,0.00,90.00,2250.00,'2022-07-06 17:01:17','',''),(4310,'1','273','1',1,'Retail Sale Id 4330',1502.20,0.00,0.00,2.03,172.55,'2022-07-06 17:03:58','',''),(4311,'1','273','1',1,'Retail Sale Id 4331',5180.00,0.00,0.00,7.00,595.00,'2022-07-06 17:06:05','',''),(4312,'1','273','1',1,'Retail Sale Id 4332',2220.00,0.00,0.00,3.00,255.00,'2022-07-06 17:29:43','',''),(4313,'1','273','1',1,'Retail Sale Id 4333',3700.00,0.00,0.00,5.00,425.00,'2022-07-06 17:34:17','',''),(4314,'1','273','1',1,'Retail Sale Id 4334',799.20,0.00,0.00,1.08,91.80,'2022-07-06 17:40:15','',''),(4315,'1','273','1',1,'Retail Sale Id 4335',81600.00,0.00,0.00,120.00,3000.00,'2022-07-06 17:45:40','',''),(4316,'1','273','1',1,'Retail Sale Id 4336',747.40,0.00,0.00,1.01,85.85,'2022-07-06 17:46:32','',''),(4317,'1','273','1',1,'Retail Sale Id 4337',40800.00,0.00,0.00,60.00,1500.00,'2022-07-06 17:49:41','',''),(4318,'1','273','1',1,'Retail Sale Id 4338',1502.20,0.00,0.00,2.03,172.55,'2022-07-06 17:50:30','',''),(4319,'1','273','1',1,'Retail Sale Id 4339',1998.00,0.00,0.00,2.70,229.50,'2022-07-06 17:58:04','',''),(4320,'1','273','1',1,'Retail Sale Id 4340',999.00,0.00,0.00,1.35,114.75,'2022-07-06 18:01:55','',''),(4321,'1','273','1',1,'Retail Sale Id 4341',799.20,0.00,0.00,1.08,91.80,'2022-07-06 18:08:49','',''),(4322,'1','273','1',1,'Retail Sale Id 4342',2997.00,0.00,0.00,4.05,344.25,'2022-07-06 18:09:47','',''),(4323,'1','273','1',1,'Retail Sale Id 4343',1502.20,0.00,0.00,2.03,172.55,'2022-07-06 18:14:36','',''),(4324,'1','273','1',1,'Retail Sale Id 4344',8140.00,0.00,0.00,11.00,935.00,'2022-07-06 18:21:57','',''),(4325,'1','273','1',1,'Return of Retail Sale Id 4295',0.00,8500.00,12.50,0.00,-312.50,'2022-07-06 18:54:32','',''),(4326,'1','273','1',1,'Retail Sale Id 4345',9250.00,0.00,0.00,12.50,1062.50,'2022-07-06 18:55:45','',''),(4327,'1','273','1',1,'Return of Retail Sale Id 4338',0.00,1502.20,2.03,0.00,-172.55,'2022-07-06 19:05:18','',''),(4328,'1','273','1',1,'Retail Sale Id 4346',999.00,0.00,0.00,1.35,114.75,'2022-07-06 19:06:10','',''),(4329,'1','273','1',1,'Return of Retail Sale Id 4280',0.00,34000.00,50.00,0.00,-1250.00,'2022-07-06 19:09:10','',''),(4330,'1','273','1',1,'Retail Sale Id 4347',31960.00,0.00,0.00,47.00,1175.00,'2022-07-06 19:10:33','',''),(4331,'1','273','1',1,'Retail Sale Id 4349',3700.00,0.00,0.00,5.00,425.00,'2022-07-07 06:57:22','',''),(4332,'1','273','1',1,'Retail Sale Id 4350',999.00,0.00,0.00,1.35,114.75,'2022-07-07 07:03:33','',''),(4333,'1','273','1',1,'Retail Sale Id 4351',7400.00,0.00,0.00,10.00,850.00,'2022-07-07 07:13:00','',''),(4334,'1','273','1',1,'Retail Sale Id 4352',747.40,0.00,0.00,1.01,85.85,'2022-07-07 07:36:00','',''),(4335,'1','273','1',1,'Retail Sale Id 4353',1502.20,0.00,0.00,2.03,172.55,'2022-07-07 07:37:44','',''),(4336,'1','273','1',1,'Retail Sale Id 4354',2249.60,0.00,0.00,3.04,258.40,'2022-07-07 07:38:37','',''),(4337,'1','273','1',1,'Retail Sale Id 4355',34000.00,0.00,0.00,680.00,-411400.00,'2022-07-07 07:40:57','',''),(4338,'1','273','1',1,'Retail Sale Id 4356',2997.00,0.00,0.00,4.05,344.25,'2022-07-07 07:44:40','',''),(4339,'1','273','1',1,'Retail Sale Id 4357',2353.20,0.00,0.00,3.18,270.30,'2022-07-07 07:46:49','',''),(4340,'1','273','1',1,'Retail Sale Id 4358',50320.00,0.00,0.00,74.00,1850.00,'2022-07-07 07:49:23','',''),(4341,'1','273','1',1,'Retail Sale Id 4359',5002.40,0.00,0.00,6.76,574.60,'2022-07-07 07:53:32','',''),(4342,'1','273','1',1,'Retail Sale Id 4360',2249.60,0.00,0.00,3.04,258.40,'2022-07-07 07:55:01','',''),(4343,'1','273','1',1,'Retail Sale Id 4361',4440.00,0.00,0.00,6.00,510.00,'2022-07-07 07:59:17','',''),(4344,'1','273','1',1,'Retail Sale Id 4362',3500.20,0.00,0.00,4.73,402.05,'2022-07-07 08:08:24','',''),(4345,'1','273','1',1,'Retail Sale Id 4363',999.00,0.00,0.00,1.35,114.75,'2022-07-07 08:11:24','',''),(4346,'1','273','1',1,'Retail Sale Id 4364',80240.00,0.00,0.00,118.00,2950.00,'2022-07-07 08:14:33','',''),(4347,'1','273','1',1,'Retail Sale Id 4365',48280.00,0.00,0.00,71.00,1775.00,'2022-07-07 08:15:26','',''),(4348,'1','273','1',1,'Retail Sale Id 4366',999.00,0.00,0.00,1.35,114.75,'2022-07-07 08:20:36','',''),(4349,'1','273','1',1,'Retail Sale Id 4367',2960.00,0.00,0.00,4.00,340.00,'2022-07-07 08:33:05','',''),(4350,'1','273','1',1,'Retail Sale Id 4368',4440.00,0.00,0.00,6.00,510.00,'2022-07-07 08:41:23','',''),(4351,'1','273','1',1,'Retail Sale Id 4369',4440.00,0.00,0.00,6.00,510.00,'2022-07-07 08:43:06','',''),(4352,'1','273','1',1,'Retail Sale Id 4370',34000.00,0.00,0.00,50.00,1250.00,'2022-07-07 08:45:53','',''),(4353,'1','273','1',1,'Retail Sale Id 4371',34000.00,0.00,0.00,50.00,1250.00,'2022-07-07 08:46:57','',''),(4354,'1','273','1',1,'Retail Sale Id 4372',999.00,0.00,0.00,1.35,114.75,'2022-07-07 08:53:16','',''),(4355,'1','273','1',1,'Retail Sale Id 4373',95002.80,0.00,0.00,139.71,3492.75,'2022-07-07 08:56:18','',''),(4356,'1','273','1',1,'Retail Sale Id 4374',27200.00,0.00,0.00,40.00,1000.00,'2022-07-07 08:57:04','',''),(4357,'1','273','1',1,'Retail Sale Id 4375',170000.00,0.00,0.00,250.00,6250.00,'2022-07-07 09:10:17','',''),(4358,'1','273','1',1,'Retail Sale Id 4376',1998.00,0.00,0.00,2.70,229.50,'2022-07-07 09:11:00','',''),(4359,'1','273','1',1,'Retail Sale Id 4377',3700.00,0.00,0.00,5.00,425.00,'2022-07-07 09:19:55','',''),(4360,'1','273','1',1,'Retail Sale Id 4378',2997.00,0.00,0.00,4.05,344.25,'2022-07-07 09:38:35','',''),(4361,'1','273','1',1,'Retail Sale Id 4379',3700.00,0.00,0.00,5.00,425.00,'2022-07-07 09:58:18','',''),(4362,'1','273','1',1,'Retail Sale Id 4380',9997.40,0.00,0.00,13.51,1148.35,'2022-07-07 10:21:46','',''),(4363,'1','273','1',1,'Retail Sale Id 4381',4440.00,0.00,0.00,6.00,510.00,'2022-07-07 10:31:47','',''),(4364,'1','273','1',1,'Retail Sale Id 4382',5180.00,0.00,0.00,7.00,595.00,'2022-07-07 10:33:22','',''),(4365,'1','273','1',1,'Retail Sale Id 4383',999.00,0.00,0.00,1.35,114.75,'2022-07-07 10:34:27','',''),(4366,'1','273','1',1,'Retail Sale Id 4384',3700.00,0.00,0.00,5.00,425.00,'2022-07-07 10:41:09','',''),(4367,'1','273','1',1,'Retail Sale Id 4385',170000.00,0.00,0.00,250.00,6250.00,'2022-07-07 10:48:07','',''),(4368,'1','273','1',1,'Retail Sale Id 4386',68000.00,0.00,0.00,100.00,2500.00,'2022-07-07 10:49:18','',''),(4369,'1','273','1',1,'Retail Sale Id 4387',1998.00,0.00,0.00,2.70,229.50,'2022-07-07 10:55:05','',''),(4370,'1','273','1',1,'Retail Sale Id 4388',7400.00,0.00,0.00,10.00,850.00,'2022-07-07 10:56:47','',''),(4371,'1','273','1',1,'Retail Sale Id 4389',2249.60,0.00,0.00,3.04,258.40,'2022-07-07 10:58:59','',''),(4372,'1','273','1',1,'Retail Sale Id 4390',999.00,0.00,0.00,1.35,114.75,'2022-07-07 11:07:14','',''),(4373,'1','273','1',1,'Retail Sale Id 4391',1480.00,0.00,0.00,2.00,170.00,'2022-07-07 11:47:05','',''),(4374,'1','273','1',1,'Retail Sale Id 4392',3700.00,0.00,0.00,5.00,425.00,'2022-07-07 11:57:34','',''),(4375,'1','273','1',1,'Retail Sale Id 4393',13600.00,0.00,0.00,20.00,500.00,'2022-07-07 12:05:07','',''),(4376,'1','273','1',1,'Retail Sale Id 4394',7000.40,0.00,0.00,9.46,804.10,'2022-07-07 12:12:50','',''),(4377,'1','273','1',1,'Retail Sale Id 4395',18500.00,0.00,0.00,25.00,2125.00,'2022-07-07 12:36:01','',''),(4378,'1','273','1',1,'Retail Sale Id 4396',2220.00,0.00,0.00,3.00,255.00,'2022-07-07 12:49:57','',''),(4379,'1','273','1',1,'Retail Sale Id 4397',2397.60,0.00,0.00,3.24,275.40,'2022-07-07 12:55:29','',''),(4380,'1','273','1',1,'Retail Sale Id 4398',4003.40,0.00,0.00,5.41,459.85,'2022-07-07 13:03:41','',''),(4381,'1','273','1',1,'Retail Sale Id 4399',747.40,0.00,0.00,1.01,85.85,'2022-07-07 13:41:51','',''),(4382,'1','273','1',1,'Retail Sale Id 4400',8880.00,0.00,0.00,12.00,1020.00,'2022-07-07 13:50:29','',''),(4383,'1','273','1',1,'Retail Sale Id 4401',5002.40,0.00,0.00,6.76,574.60,'2022-07-07 13:54:00','',''),(4384,'1','273','1',1,'Retail Sale Id 4402',747.40,0.00,0.00,1.01,85.85,'2022-07-07 13:55:16','',''),(4385,'1','273','1',1,'Retail Sale Id 4403',2997.00,0.00,0.00,4.05,344.25,'2022-07-07 13:57:30','',''),(4386,'1','273','1',1,'Retail Sale Id 4404',3700.00,0.00,0.00,5.00,425.00,'2022-07-07 14:29:12','',''),(4387,'1','273','1',1,'Retail Sale Id 4405',10360.00,0.00,0.00,14.00,1190.00,'2022-07-07 14:31:04','',''),(4388,'1','273','1',1,'Retail Sale Id 4406',2220.00,0.00,0.00,3.00,255.00,'2022-07-07 14:38:47','',''),(4389,'1','273','1',1,'Retail Sale Id 4408',1502.20,0.00,0.00,2.03,172.55,'2022-07-07 14:48:47','',''),(4390,'1','273','1',1,'Retail Sale Id 4409',1502.20,0.00,0.00,2.03,172.55,'2022-07-07 14:55:04','',''),(4391,'1','273','1',1,'Retail Sale Id 4410',5002.40,0.00,0.00,6.76,574.60,'2022-07-07 14:59:11','',''),(4392,'1','273','1',1,'Retail Sale Id 4411',5180.00,0.00,0.00,7.00,595.00,'2022-07-07 15:03:40','',''),(4393,'1','273','1',1,'Retail Sale Id 4412',9250.00,0.00,0.00,12.50,1062.50,'2022-07-07 15:28:53','',''),(4394,'1','273','1',1,'Retail Sale Id 4413',799.20,0.00,0.00,1.08,91.80,'2022-07-07 15:41:28','',''),(4395,'1','273','1',1,'Retail Sale Id 4414',9250.00,0.00,0.00,12.50,1062.50,'2022-07-07 15:50:15','',''),(4396,'1','273','1',1,'Retail Sale Id 4415',5180.00,0.00,0.00,7.00,595.00,'2022-07-07 15:57:21','',''),(4397,'1','273','1',1,'Retail Sale Id 4416',68000.00,0.00,0.00,100.00,2500.00,'2022-07-07 16:00:09','',''),(4398,'1','273','1',1,'Retail Sale Id 4417',9250.00,0.00,0.00,12.50,1062.50,'2022-07-07 16:01:13','',''),(4399,'1','273','1',1,'Retail Sale Id 4418',34000.00,0.00,0.00,50.00,1250.00,'2022-07-07 16:02:52','',''),(4400,'1','273','1',1,'Retail Sale Id 4419',1998.00,0.00,0.00,2.70,229.50,'2022-07-07 16:05:19','',''),(4401,'1','273','1',1,'Retail Sale Id 4420',999.00,0.00,0.00,1.35,114.75,'2022-07-07 16:06:28','',''),(4402,'1','273','1',1,'Retail Sale Id 4421',4440.00,0.00,0.00,6.00,510.00,'2022-07-07 16:09:08','',''),(4403,'1','273','1',1,'Retail Sale Id 4422',999.00,0.00,0.00,1.35,114.75,'2022-07-07 16:14:17','',''),(4404,'1','273','1',1,'Retail Sale Id 4423',747.40,0.00,0.00,1.01,85.85,'2022-07-07 16:32:42','',''),(4405,'1','273','1',1,'Retail Sale Id 4424',2960.00,0.00,0.00,4.00,340.00,'2022-07-07 16:35:12','',''),(4406,'1','273','1',1,'Retail Sale Id 4425',1998.00,0.00,0.00,2.70,229.50,'2022-07-07 17:00:00','',''),(4407,'1','273','1',1,'Retail Sale Id 4426',2501.20,0.00,0.00,3.38,287.30,'2022-07-07 17:01:34','',''),(4408,'1','273','1',1,'Retail Sale Id 4427',23800.00,0.00,0.00,35.00,875.00,'2022-07-07 17:07:58','',''),(4409,'1','273','1',1,'Retail Sale Id 4428',3700.00,0.00,0.00,5.00,425.00,'2022-07-07 17:09:03','',''),(4410,'1','273','1',1,'Retail Sale Id 4429',1502.20,0.00,0.00,2.03,172.55,'2022-07-07 17:12:24','',''),(4411,'1','273','1',1,'Retail Sale Id 4430',5202.20,0.00,0.00,7.03,597.55,'2022-07-07 17:21:48','',''),(4412,'1','273','1',1,'Retail Sale Id 4431',2301.40,0.00,0.00,3.11,264.35,'2022-07-07 17:22:46','',''),(4413,'1','273','1',1,'Retail Sale Id 4432',2249.60,0.00,0.00,3.04,258.40,'2022-07-07 17:41:36','',''),(4414,'1','273','1',1,'Retail Sale Id 4433',2220.00,0.00,0.00,3.00,255.00,'2022-07-07 17:43:32','',''),(4415,'1','273','1',1,'Retail Sale Id 4434',5002.40,0.00,0.00,6.76,574.60,'2022-07-07 17:45:37','',''),(4416,'1','273','1',1,'Retail Sale Id 4435',4003.40,0.00,0.00,5.41,459.85,'2022-07-07 17:46:21','',''),(4417,'1','273','1',1,'Retail Sale Id 4436',7400.00,0.00,0.00,10.00,850.00,'2022-07-07 17:47:36','',''),(4418,'1','273','1',1,'Retail Sale Id 4437',569.80,0.00,0.00,0.77,65.45,'2022-07-07 17:57:05','',''),(4419,'1','273','1',1,'Retail Sale Id 4438',3700.00,0.00,0.00,5.00,425.00,'2022-07-07 17:58:45','',''),(4420,'1','273','1',1,'Retail Sale Id 4439',2997.00,0.00,0.00,4.05,344.25,'2022-07-07 18:02:31','',''),(4421,'1','273','1',1,'Retail Sale Id 4440',999.00,0.00,0.00,1.35,114.75,'2022-07-07 18:15:28','',''),(4422,'1','273','1',1,'Retail Sale Id 4441',999.00,0.00,0.00,1.35,114.75,'2022-07-07 18:20:13','',''),(4423,'1','273','1',1,'Return of Retail Sale Id 4370',0.00,34000.00,50.00,0.00,-1250.00,'2022-07-07 18:38:27','',''),(4424,'1','273','1',1,'Retail Sale Id 4442',31960.00,0.00,0.00,47.00,1175.00,'2022-07-07 18:39:53','',''),(4425,'1','273','1',1,'Retail Sale Id 4443',3241.20,0.00,0.00,4.38,372.30,'2022-07-08 07:36:46','',''),(4426,'1','273','1',1,'Retail Sale Id 4444',799.20,0.00,0.00,1.08,91.80,'2022-07-08 08:10:54','',''),(4427,'1','273','1',1,'Retail Sale Id 4445',747.40,0.00,0.00,1.01,85.85,'2022-07-08 08:53:18','',''),(4428,'1','273','1',1,'Retail Sale Id 4446',4440.00,0.00,0.00,6.00,510.00,'2022-07-08 09:01:39','',''),(4429,'1','273','1',1,'Retail Sale Id 4447',2249.60,0.00,0.00,3.04,258.40,'2022-07-08 09:50:05','',''),(4430,'1','273','1',1,'Retail Sale Id 4448',9250.00,0.00,0.00,12.50,1062.50,'2022-07-08 09:56:39','',''),(4431,'1','273','1',1,'Retail Sale Id 4449',1998.00,0.00,0.00,2.70,229.50,'2022-07-08 10:04:35','',''),(4432,'1','273','1',1,'Retail Sale Id 4450',1502.20,0.00,0.00,2.03,172.55,'2022-07-08 10:05:15','',''),(4433,'1','273','1',1,'Retail Sale Id 4451',144160.00,0.00,0.00,212.00,5300.00,'2022-07-08 10:50:16','',''),(4434,'1','273','1',1,'Retail Sale Id 4452',136000.00,0.00,0.00,200.00,5000.00,'2022-07-08 10:51:03','',''),(4435,'1','273','1',1,'Retail Sale Id 4453',8880.00,0.00,0.00,12.00,1020.00,'2022-07-08 11:04:48','',''),(4436,'1','273','1',1,'Retail Sale Id 4454',2220.00,0.00,0.00,3.00,255.00,'2022-07-08 11:23:12','',''),(4437,'1','273','1',1,'Retail Sale Id 4455',1480.00,0.00,0.00,2.00,170.00,'2022-07-08 11:25:07','',''),(4438,'1','273','1',1,'Retail Sale Id 4456',5920.00,0.00,0.00,8.00,680.00,'2022-07-08 11:41:05','',''),(4439,'1','273','1',1,'Retail Sale Id 4457',2997.00,0.00,0.00,4.05,344.25,'2022-07-08 11:42:16','',''),(4440,'1','273','1',1,'Retail Sale Id 4458',6660.00,0.00,0.00,9.00,765.00,'2022-07-08 11:56:51','',''),(4441,'1','273','1',1,'Retail Sale Id 4459',3700.00,0.00,0.00,5.00,425.00,'2022-07-08 12:05:13','',''),(4442,'1','273','1',1,'Retail Sale Id 4460',999.00,0.00,0.00,1.35,114.75,'2022-07-08 12:06:55','',''),(4443,'1','273','1',1,'Retail Sale Id 4461',1502.20,0.00,0.00,2.03,172.55,'2022-07-08 12:48:51','',''),(4444,'1','273','1',1,'Retail Sale Id 4462',7400.00,0.00,0.00,10.00,850.00,'2022-07-08 12:55:30','',''),(4445,'1','273','1',1,'Retail Sale Id 4463',1502.20,0.00,0.00,2.03,172.55,'2022-07-08 12:58:00','',''),(4446,'1','273','1',1,'Retail Sale Id 4464',999.00,0.00,0.00,1.35,114.75,'2022-07-08 13:11:02','',''),(4447,'1','273','1',1,'Retail Sale Id 4465',21760.00,0.00,0.00,32.00,800.00,'2022-07-08 13:21:46','',''),(4448,'1','273','1',1,'Retail Sale Id 4466',3700.00,0.00,0.00,5.00,425.00,'2022-07-08 13:24:29','',''),(4449,'1','273','1',1,'Retail Sale Id 4467',1502.20,0.00,0.00,2.03,172.55,'2022-07-08 13:32:48','',''),(4450,'1','273','1',1,'Retail Sale Id 4468',60996.00,0.00,0.00,89.70,2242.50,'2022-07-08 13:36:31','',''),(4451,'1','273','1',1,'Retail Sale Id 4469',1998.00,0.00,0.00,2.70,229.50,'2022-07-08 16:08:43','',''),(4452,'1','273','1',1,'Retail Sale Id 4470',86360.00,0.00,0.00,127.00,3175.00,'2022-07-08 16:13:05','',''),(4453,'1','273','1',1,'Retail Sale Id 4471',3700.00,0.00,0.00,5.00,425.00,'2022-07-08 16:16:31','',''),(4454,'1','273','1',1,'Retail Sale Id 4472',61200.00,0.00,0.00,90.00,2250.00,'2022-07-08 16:20:28','',''),(4455,'1','273','1',1,'Retail Sale Id 4473',3700.00,0.00,0.00,5.00,425.00,'2022-07-08 16:30:01','',''),(4456,'1','273','1',1,'Retail Sale Id 4474',5180.00,0.00,0.00,7.00,595.00,'2022-07-08 16:34:09','',''),(4457,'1','273','1',1,'Retail Sale Id 4475',1998.00,0.00,0.00,2.70,229.50,'2022-07-08 16:35:28','',''),(4458,'1','273','1',1,'Retail Sale Id 4476',740.00,0.00,0.00,1.00,85.00,'2022-07-08 16:36:47','',''),(4459,'1','273','1',1,'Retail Sale Id 4477',3700.00,0.00,0.00,5.00,425.00,'2022-07-08 16:37:32','',''),(4460,'1','273','1',1,'Retail Sale Id 4478',2249.60,0.00,0.00,3.04,258.40,'2022-07-08 16:39:27','',''),(4461,'1','273','1',1,'Retail Sale Id 4479',5002.40,0.00,0.00,6.76,574.60,'2022-07-08 16:58:25','',''),(4462,'1','273','1',1,'Retail Sale Id 4480',4440.00,0.00,0.00,6.00,510.00,'2022-07-08 17:02:07','',''),(4463,'1','273','1',1,'Retail Sale Id 4482',8880.00,0.00,0.00,12.00,1020.00,'2022-07-08 17:04:23','',''),(4464,'1','273','1',1,'Retail Sale Id 4483',2960.00,0.00,0.00,4.00,340.00,'2022-07-08 17:08:38','',''),(4465,'1','273','1',1,'Retail Sale Id 4484',4440.00,0.00,0.00,6.00,510.00,'2022-07-08 17:10:08','',''),(4466,'1','273','1',1,'Retail Sale Id 4485',3700.00,0.00,0.00,5.00,425.00,'2022-07-08 17:11:33','',''),(4467,'1','273','1',1,'Retail Sale Id 4486',3700.00,0.00,0.00,5.00,425.00,'2022-07-08 17:29:24','',''),(4468,'1','273','1',1,'Retail Sale Id 4487',999.00,0.00,0.00,1.35,114.75,'2022-07-08 17:30:37','',''),(4469,'1','273','1',1,'Retail Sale Id 4488',2197.80,0.00,0.00,2.97,252.45,'2022-07-08 17:35:48','',''),(4470,'1','273','1',1,'Retail Sale Id 4489',9250.00,0.00,0.00,12.50,1062.50,'2022-07-08 17:43:28','',''),(4471,'1','273','1',1,'Retail Sale Id 4490',2501.20,0.00,0.00,3.38,287.30,'2022-07-08 17:49:15','',''),(4472,'1','273','1',1,'Retail Sale Id 4491',34780.00,0.00,0.00,47.00,3995.00,'2022-07-08 18:13:18','',''),(4473,'1','273','1',1,'Retail Sale Id 4492',2249.60,0.00,0.00,3.04,258.40,'2022-07-08 18:24:54','',''),(4474,'1','273','1',1,'Retail Sale Id 4493',1998.00,0.00,0.00,2.70,229.50,'2022-07-08 18:31:17','',''),(4475,'1','273','1',1,'Retail Sale Id 4494',1502.20,0.00,0.00,2.03,172.55,'2022-07-09 07:03:55','',''),(4476,'1','273','1',1,'Retail Sale Id 4495',799.20,0.00,0.00,1.08,91.80,'2022-07-09 07:08:00','',''),(4477,'1','273','1',1,'Retail Sale Id 4496',4499.20,0.00,0.00,6.08,516.80,'2022-07-09 07:14:56','',''),(4478,'1','273','1',1,'Retail Sale Id 4497',747.40,0.00,0.00,1.01,85.85,'2022-07-09 07:20:55','',''),(4479,'1','273','1',1,'Retail Sale Id 4498',34000.00,0.00,0.00,50.00,1250.00,'2022-07-09 07:23:36','',''),(4480,'1','273','1',1,'Retail Sale Id 4499',5002.40,0.00,0.00,6.76,574.60,'2022-07-09 07:24:34','',''),(4481,'1','273','1',1,'Retail Sale Id 4500',4440.00,0.00,0.00,6.00,510.00,'2022-07-09 07:27:29','',''),(4482,'1','273','1',1,'Retail Sale Id 4500',9250.00,0.00,0.00,12.50,1062.50,'2022-07-09 07:27:29','',''),(4483,'1','273','1',1,'Retail Sale Id 4501',9250.00,0.00,0.00,12.50,1062.50,'2022-07-09 07:29:11','',''),(4484,'1','273','1',1,'Retail Sale Id 4502',122400.00,0.00,0.00,180.00,4500.00,'2022-07-09 07:37:22','',''),(4485,'1','273','1',1,'Retail Sale Id 4503',747.40,0.00,0.00,1.01,85.85,'2022-07-09 07:38:27','',''),(4486,'1','273','1',1,'Retail Sale Id 4504',2220.00,0.00,0.00,3.00,255.00,'2022-07-09 07:45:11','',''),(4487,'1','273','1',1,'Retail Sale Id 4505',9250.00,0.00,0.00,12.50,1062.50,'2022-07-09 07:45:53','',''),(4488,'1','273','1',1,'Retail Sale Id 4506',172040.00,0.00,0.00,253.00,6325.00,'2022-07-09 07:50:31','',''),(4489,'1','273','1',1,'Retail Sale Id 4507',1502.20,0.00,0.00,2.03,172.55,'2022-07-09 07:51:36','',''),(4490,'1','273','1',1,'Retail Sale Id 4508',1500.00,0.00,0.00,1.00,845.00,'2022-07-09 07:59:48','',''),(4491,'1','273','1',1,'Retail Sale Id 4509',1502.20,0.00,0.00,2.03,172.55,'2022-07-09 08:00:38','',''),(4492,'1','273','1',1,'Return of Retail Sale Id 4508',0.00,1500.00,1.00,0.00,-845.00,'2022-07-09 08:01:10','',''),(4493,'1','273','1',1,'Retail Sale Id 4510',4440.00,0.00,0.00,6.00,510.00,'2022-07-09 08:08:12','',''),(4494,'1','273','1',1,'Retail Sale Id 4511',34000.00,0.00,0.00,50.00,1250.00,'2022-07-09 08:09:41','',''),(4495,'1','273','1',1,'Retail Sale Id 4512',2960.00,0.00,0.00,4.00,340.00,'2022-07-09 08:14:54','',''),(4496,'1','273','1',1,'Retail Sale Id 4513',9198.20,0.00,0.00,12.43,1056.55,'2022-07-09 08:17:35','',''),(4497,'1','273','1',1,'Retail Sale Id 4514',1480.00,0.00,0.00,2.00,170.00,'2022-07-09 14:08:14','',''),(4498,'1','273','1',1,'Retail Sale Id 4515',1702.00,0.00,0.00,2.30,195.50,'2022-07-09 14:12:46','',''),(4499,'1','273','1',1,'Retail Sale Id 4516',7000.40,0.00,0.00,9.46,804.10,'2022-07-09 14:16:06','',''),(4500,'1','273','1',1,'Retail Sale Id 4517',999.00,0.00,0.00,1.35,114.75,'2022-07-09 14:20:35','',''),(4501,'1','273','1',1,'Retail Sale Id 4518',2249.60,0.00,0.00,3.04,258.40,'2022-07-09 14:28:41','',''),(4502,'1','273','1',1,'Retail Sale Id 4519',9620.00,0.00,0.00,13.00,1105.00,'2022-07-09 14:30:27','',''),(4503,'1','273','1',1,'Retail Sale Id 4520',4447.40,0.00,0.00,6.01,510.85,'2022-07-09 14:32:52','',''),(4504,'1','273','1',1,'Retail Sale Id 4521',1480.00,0.00,0.00,2.00,170.00,'2022-07-09 14:36:41','',''),(4505,'1','273','1',1,'Retail Sale Id 4522',4440.00,0.00,0.00,6.00,510.00,'2022-07-09 14:42:46','',''),(4506,'1','273','1',1,'Retail Sale Id 4523',2997.00,0.00,0.00,4.05,344.25,'2022-07-09 14:47:38','',''),(4507,'1','273','1',1,'Retail Sale Id 4524',9250.00,0.00,0.00,12.50,1062.50,'2022-07-09 14:55:42','',''),(4508,'1','273','1',1,'Retail Sale Id 4525',1598.40,0.00,0.00,2.16,183.60,'2022-07-09 14:56:28','',''),(4509,'1','273','1',1,'Retail Sale Id 4526',747.40,0.00,0.00,1.01,85.85,'2022-07-09 15:20:06','',''),(4510,'1','273','1',1,'Retail Sale Id 4527',2997.00,0.00,0.00,4.05,344.25,'2022-07-09 15:25:27','',''),(4511,'1','273','1',1,'Retail Sale Id 4528',3700.00,0.00,0.00,5.00,425.00,'2022-07-09 15:26:46','',''),(4512,'1','273','1',1,'Retail Sale Id 4529',999.00,0.00,0.00,1.35,114.75,'2022-07-09 15:29:07','',''),(4513,'1','273','1',1,'Retail Sale Id 4530',1502.20,0.00,0.00,2.03,172.55,'2022-07-09 15:40:26','',''),(4514,'1','273','1',1,'Retail Sale Id 4531',9250.00,0.00,0.00,12.50,1062.50,'2022-07-09 15:44:14','',''),(4515,'1','273','1',1,'Retail Sale Id 4531',12950.00,0.00,0.00,17.50,1487.50,'2022-07-09 15:44:14','',''),(4516,'1','273','1',1,'Retail Sale Id 4532',1998.00,0.00,0.00,2.70,229.50,'2022-07-09 15:45:05','',''),(4517,'1','273','1',1,'Retail Sale Id 4533',9250.00,0.00,0.00,12.50,1062.50,'2022-07-09 15:48:41','',''),(4518,'1','273','1',1,'Retail Sale Id 4534',4810.00,0.00,0.00,6.50,552.50,'2022-07-09 15:49:54','',''),(4519,'1','273','1',1,'Retail Sale Id 4535',1502.20,0.00,0.00,2.03,172.55,'2022-07-09 16:03:45','',''),(4520,'1','273','1',1,'Retail Sale Id 4536',3700.00,0.00,0.00,5.00,425.00,'2022-07-09 16:04:27','',''),(4521,'1','273','1',1,'Retail Sale Id 4537',4440.00,0.00,0.00,6.00,510.00,'2022-07-09 16:05:18','',''),(4522,'1','273','1',1,'Retail Sale Id 4538',1502.20,0.00,0.00,2.03,172.55,'2022-07-09 16:09:30','',''),(4523,'1','273','1',1,'Retail Sale Id 4539',7000.40,0.00,0.00,9.46,804.10,'2022-07-09 16:12:41','',''),(4524,'1','273','1',1,'Retail Sale Id 4540',1502.20,0.00,0.00,2.03,172.55,'2022-07-09 16:13:42','',''),(4525,'1','273','1',1,'Retail Sale Id 4541',7999.40,0.00,0.00,10.81,918.85,'2022-07-09 16:22:01','',''),(4526,'1','273','1',1,'Retail Sale Id 4542',747.40,0.00,0.00,1.01,85.85,'2022-07-09 16:28:24','',''),(4527,'1','273','1',1,'Retail Sale Id 4543',5202.20,0.00,0.00,7.03,597.55,'2022-07-09 16:44:44','',''),(4528,'1','273','1',1,'Retail Sale Id 4544',1502.20,0.00,0.00,2.03,172.55,'2022-07-09 16:51:55','',''),(4529,'1','273','1',1,'Retail Sale Id 4545',99960.00,0.00,0.00,147.00,3675.00,'2022-07-09 17:00:11','',''),(4530,'1','273','1',1,'Retail Sale Id 4546',66640.00,0.00,0.00,98.00,2450.00,'2022-07-09 17:00:57','',''),(4531,'1','273','1',1,'Retail Sale Id 4547',7400.00,0.00,0.00,10.00,850.00,'2022-07-09 17:05:58','',''),(4532,'1','273','1',1,'Retail Sale Id 4548',9997.40,0.00,0.00,13.51,1148.35,'2022-07-09 17:15:56','',''),(4533,'1','273','1',1,'Retail Sale Id 4549',740.00,0.00,0.00,1.00,85.00,'2022-07-09 17:18:43','',''),(4534,'1','273','1',1,'Retail Sale Id 4550',1502.20,0.00,0.00,2.03,172.55,'2022-07-09 17:23:22','',''),(4535,'1','273','1',1,'Retail Sale Id 4551',1502.20,0.00,0.00,2.03,172.55,'2022-07-09 17:24:18','',''),(4536,'1','273','1',1,'Retail Sale Id 4552',2101.60,0.00,0.00,2.84,241.40,'2022-07-09 17:26:19','',''),(4537,'1','273','1',1,'Retail Sale Id 4553',7030.00,0.00,0.00,9.50,807.50,'2022-07-09 17:51:11','',''),(4538,'1','273','1',1,'Retail Sale Id 4554',8140.00,0.00,0.00,11.00,935.00,'2022-07-09 17:53:26','',''),(4539,'1','273','1',1,'Retail Sale Id 4555',9250.00,0.00,0.00,12.50,1062.50,'2022-07-09 17:59:32','',''),(4540,'1','273','1',1,'Retail Sale Id 4556',8880.00,0.00,0.00,12.00,1020.00,'2022-07-09 18:01:57','',''),(4541,'1','273','1',1,'Retail Sale Id 4557',2997.00,0.00,0.00,4.05,344.25,'2022-07-09 18:07:53','',''),(4542,'1','273','1',1,'Retail Sale Id 4558',2220.00,0.00,0.00,3.00,255.00,'2022-07-09 18:15:33','',''),(4543,'1','273','1',1,'Retail Sale Id 4559',7999.40,0.00,0.00,10.81,918.85,'2022-07-09 18:19:35','',''),(4544,'1','273','1',1,'Retail Sale Id 4560',747.40,0.00,0.00,1.01,85.85,'2022-07-09 18:23:56','',''),(4545,'1','273','1',1,'Retail Sale Id 4561',503.20,0.00,0.00,0.68,57.80,'2022-07-09 18:38:09','',''),(4546,'1','273','1',1,'Retail Sale Id 4562',2249.60,0.00,0.00,3.04,258.40,'2022-07-10 07:16:20','',''),(4547,'1','273','1',1,'Retail Sale Id 4563',2997.00,0.00,0.00,4.05,344.25,'2022-07-10 07:17:16','',''),(4548,'1','273','1',1,'Retail Sale Id 4564',740.00,0.00,0.00,1.00,85.00,'2022-07-10 07:28:46','',''),(4549,'1','273','1',1,'Retail Sale Id 4565',10360.00,0.00,0.00,14.00,1190.00,'2022-07-10 07:30:06','',''),(4550,'1','273','1',1,'Retail Sale Id 4566',24996.80,0.00,0.00,36.76,919.00,'2022-07-10 07:36:52','',''),(4551,'1','273','1',1,'Retail Sale Id 4567',2249.60,0.00,0.00,3.04,258.40,'2022-07-10 07:38:03','',''),(4552,'1','273','1',1,'Retail Sale Id 4568',3700.00,0.00,0.00,5.00,425.00,'2022-07-10 07:45:49','',''),(4553,'1','273','1',1,'Retail Sale Id 4569',740.00,0.00,0.00,1.00,85.00,'2022-07-10 07:46:50','',''),(4554,'1','273','1',1,'Retail Sale Id 4570',1998.00,0.00,0.00,2.70,229.50,'2022-07-10 07:47:45','',''),(4555,'1','273','1',1,'Retail Sale Id 4571',1502.20,0.00,0.00,2.03,172.55,'2022-07-10 07:56:23','',''),(4556,'1','273','1',1,'Retail Sale Id 4572',747.40,0.00,0.00,1.01,85.85,'2022-07-10 08:00:07','',''),(4557,'1','273','1',1,'Retail Sale Id 4573',740.00,0.00,0.00,1.00,85.00,'2022-07-10 08:06:29','',''),(4558,'1','273','1',1,'Retail Sale Id 4574',6800.00,0.00,0.00,10.00,250.00,'2022-07-10 08:09:59','',''),(4559,'1','273','1',1,'Retail Sale Id 4575',1502.20,0.00,0.00,2.03,172.55,'2022-07-10 08:11:20','',''),(4560,'1','273','1',1,'Retail Sale Id 4576',2220.00,0.00,0.00,3.00,255.00,'2022-07-10 08:27:11','',''),(4561,'1','273','1',1,'Retail Sale Id 4577',2997.00,0.00,0.00,4.05,344.25,'2022-07-10 08:33:25','',''),(4562,'1','273','1',1,'Retail Sale Id 4578',2960.00,0.00,0.00,4.00,340.00,'2022-07-10 08:43:53','',''),(4563,'1','273','1',1,'Retail Sale Id 4579',799.20,0.00,0.00,1.08,91.80,'2022-07-10 08:45:04','',''),(4564,'1','273','1',1,'Retail Sale Id 4580',6660.00,0.00,0.00,9.00,765.00,'2022-07-10 08:46:25','',''),(4565,'1','273','1',1,'Retail Sale Id 4581',999.00,0.00,0.00,1.35,114.75,'2022-07-10 08:47:37','',''),(4566,'1','273','1',1,'Retail Sale Id 4582',799.20,0.00,0.00,1.08,91.80,'2022-07-10 08:48:21','',''),(4567,'1','273','1',1,'Retail Sale Id 4584',2952.60,0.00,0.00,3.99,339.15,'2022-07-10 08:49:53','',''),(4568,'1','273','1',1,'Retail Sale Id 4585',2960.00,0.00,0.00,4.00,340.00,'2022-07-10 09:10:16','',''),(4569,'1','273','1',1,'Retail Sale Id 4586',11470.00,0.00,0.00,15.50,1317.50,'2022-07-10 09:14:41','',''),(4570,'1','273','1',1,'Retail Sale Id 4587',2220.00,0.00,0.00,3.00,255.00,'2022-07-10 09:16:35','',''),(4571,'1','273','1',1,'Retail Sale Id 4588',50320.00,0.00,0.00,74.00,1850.00,'2022-07-10 09:18:23','',''),(4572,'1','273','1',1,'Retail Sale Id 4589',7400.00,0.00,0.00,10.00,850.00,'2022-07-10 09:28:02','',''),(4573,'1','273','1',1,'Retail Sale Id 4590',999.00,0.00,0.00,1.35,114.75,'2022-07-10 09:36:17','',''),(4574,'1','273','1',1,'Retail Sale Id 4591',2997.00,0.00,0.00,4.05,344.25,'2022-07-10 11:05:15','',''),(4575,'1','273','1',1,'Retail Sale Id 4592',999.00,0.00,0.00,1.35,114.75,'2022-07-10 11:53:19','',''),(4576,'1','273','1',1,'Retail Sale Id 4593',1502.20,0.00,0.00,2.03,172.55,'2022-07-10 12:10:47','',''),(4577,'1','273','1',1,'Retail Sale Id 4594',1502.20,0.00,0.00,2.03,172.55,'2022-07-10 12:19:36','',''),(4578,'1','273','1',1,'Retail Sale Id 4596',3700.00,0.00,0.00,5.00,425.00,'2022-07-10 12:20:36','',''),(4579,'1','273','1',1,'Retail Sale Id 4597',2900.80,0.00,0.00,3.92,333.20,'2022-07-10 12:41:34','',''),(4580,'1','273','1',1,'Retail Sale Id 4598',2249.60,0.00,0.00,3.04,258.40,'2022-07-10 12:53:33','',''),(4581,'1','273','1',1,'Retail Sale Id 4599',1502.20,0.00,0.00,2.03,172.55,'2022-07-10 12:55:02','',''),(4582,'1','273','1',1,'Retail Sale Id 4600',2960.00,0.00,0.00,4.00,340.00,'2022-07-10 12:57:32','',''),(4583,'1','273','1',1,'Retail Sale Id 4601',1998.00,0.00,0.00,2.70,229.50,'2022-07-10 13:05:52','',''),(4584,'1','273','1',1,'Retail Sale Id 4602',2220.00,0.00,0.00,3.00,255.00,'2022-07-10 13:36:20','',''),(4585,'1','273','1',1,'Retail Sale Id 4603',1998.00,0.00,0.00,2.70,229.50,'2022-07-10 14:12:40','',''),(4586,'1','273','1',1,'Retail Sale Id 4604',999.00,0.00,0.00,1.35,114.75,'2022-07-10 14:23:31','',''),(4587,'1','273','1',1,'Retail Sale Id 4605',5002.40,0.00,0.00,6.76,574.60,'2022-07-10 14:25:44','',''),(4588,'1','273','1',1,'Retail Sale Id 4606',747.40,0.00,0.00,1.01,85.85,'2022-07-10 14:28:16','',''),(4589,'1','273','1',1,'Retail Sale Id 4607',9250.00,0.00,0.00,12.50,1062.50,'2022-07-10 14:33:21','',''),(4590,'1','273','1',1,'Retail Sale Id 4608',999.00,0.00,0.00,1.35,114.75,'2022-07-10 14:35:25','',''),(4591,'1','273','1',1,'Retail Sale Id 4609',2220.00,0.00,0.00,3.00,255.00,'2022-07-10 14:39:36','',''),(4592,'1','273','1',1,'Retail Sale Id 4610',23800.00,0.00,0.00,35.00,875.00,'2022-07-10 14:43:50','',''),(4593,'1','273','1',1,'Retail Sale Id 4611',1502.20,0.00,0.00,2.03,172.55,'2022-07-10 14:48:14','',''),(4594,'1','273','1',1,'Retail Sale Id 4612',0.00,0.00,0.00,1.00,-655.00,'2022-07-10 14:54:49','',''),(4595,'1','273','1',1,'Retail Sale Id 4613',2997.00,0.00,0.00,4.05,344.25,'2022-07-10 14:56:05','',''),(4596,'1','273','1',1,'Retail Sale Id 4614',3700.00,0.00,0.00,5.00,425.00,'2022-07-10 15:02:32','',''),(4597,'1','273','1',1,'Retail Sale Id 4615',3700.00,0.00,0.00,5.00,425.00,'2022-07-10 15:05:15','',''),(4598,'1','273','1',1,'Retail Sale Id 4616',1998.00,0.00,0.00,2.70,229.50,'2022-07-10 15:08:16','',''),(4599,'1','273','1',1,'Retail Sale Id 4617',1502.20,0.00,0.00,2.03,172.55,'2022-07-10 15:08:57','',''),(4600,'1','273','1',1,'Retail Sale Id 4618',1398.60,0.00,0.00,1.89,160.65,'2022-07-10 15:10:54','',''),(4601,'1','273','1',1,'Retail Sale Id 4619',747.40,0.00,0.00,1.01,85.85,'2022-07-10 15:11:55','',''),(4602,'1','273','1',1,'Retail Sale Id 4620',999.00,0.00,0.00,1.35,114.75,'2022-07-10 15:26:20','',''),(4603,'1','273','1',1,'Retail Sale Id 4621',3700.00,0.00,0.00,5.00,425.00,'2022-07-10 15:27:33','',''),(4604,'1','273','1',1,'Retail Sale Id 4622',747.40,0.00,0.00,1.01,85.85,'2022-07-10 15:28:54','',''),(4605,'1','273','1',1,'Retail Sale Id 4623',1998.00,0.00,0.00,2.70,229.50,'2022-07-10 15:30:59','',''),(4606,'1','273','1',1,'Retail Sale Id 4624',4440.00,0.00,0.00,6.00,510.00,'2022-07-10 15:33:30','',''),(4607,'1','273','1',1,'Retail Sale Id 4625',999.00,0.00,0.00,1.35,114.75,'2022-07-10 15:57:26','',''),(4608,'1','273','1',1,'Retail Sale Id 4626',2220.00,0.00,0.00,3.00,255.00,'2022-07-10 15:58:36','',''),(4609,'1','273','1',1,'Retail Sale Id 4627',5180.00,0.00,0.00,7.00,595.00,'2022-07-10 16:14:10','',''),(4610,'1','273','1',1,'Retail Sale Id 4628',3700.00,0.00,0.00,5.00,425.00,'2022-07-10 16:32:35','',''),(4611,'1','273','1',1,'Retail Sale Id 4629',5180.00,0.00,0.00,7.00,595.00,'2022-07-10 16:34:58','',''),(4612,'1','273','1',1,'Retail Sale Id 4630',5002.40,0.00,0.00,6.76,574.60,'2022-07-10 16:45:15','',''),(4613,'1','273','1',1,'Retail Sale Id 4631',5002.40,0.00,0.00,6.76,574.60,'2022-07-10 16:50:50','',''),(4614,'1','273','1',1,'Retail Sale Id 4632',1998.00,0.00,0.00,2.70,229.50,'2022-07-10 16:53:35','',''),(4615,'1','273','1',1,'Retail Sale Id 4633',5002.40,0.00,0.00,6.76,574.60,'2022-07-10 17:03:15','',''),(4616,'1','273','1',1,'Retail Sale Id 4634',1998.00,0.00,0.00,2.70,229.50,'2022-07-10 17:11:36','',''),(4617,'1','273','1',1,'Retail Sale Id 4635',2249.60,0.00,0.00,3.04,258.40,'2022-07-10 17:18:51','',''),(4618,'1','273','1',1,'Retail Sale Id 4636',9250.00,0.00,0.00,12.50,1062.50,'2022-07-10 17:22:59','',''),(4619,'1','273','1',1,'Retail Sale Id 4637',999.00,0.00,0.00,1.35,114.75,'2022-07-10 17:34:05','',''),(4620,'1','273','1',1,'Retail Sale Id 4638',20400.00,0.00,0.00,30.00,750.00,'2022-07-10 17:36:05','',''),(4621,'1','273','1',1,'Retail Sale Id 4639',9997.40,0.00,0.00,13.51,1148.35,'2022-07-10 17:39:57','',''),(4622,'1','273','1',1,'Retail Sale Id 4640',747.40,0.00,0.00,1.01,85.85,'2022-07-10 17:40:42','',''),(4623,'1','273','1',1,'Retail Sale Id 4641',9250.00,0.00,0.00,12.50,1062.50,'2022-07-10 17:50:58','',''),(4624,'1','273','1',1,'Retail Sale Id 4642',999.00,0.00,0.00,1.35,114.75,'2022-07-10 17:59:54','',''),(4625,'1','273','1',1,'Retail Sale Id 4643',7400.00,0.00,0.00,10.00,850.00,'2022-07-10 18:09:33','',''),(4626,'1','273','1',1,'Retail Sale Id 4644',7400.00,0.00,0.00,10.00,850.00,'2022-07-10 18:14:24','',''),(4627,'1','273','1',1,'Retail Sale Id 4645',2501.20,0.00,0.00,3.38,287.30,'2022-07-10 18:20:15','',''),(4628,'1','273','1',1,'Retail Sale Id 4646',999.00,0.00,0.00,1.35,114.75,'2022-07-10 18:21:07','',''),(4629,'1','273','1',1,'Retail Sale Id 4647',1480.00,0.00,0.00,2.00,170.00,'2022-07-10 18:23:19','',''),(4630,'1','273','1',1,'Retail Sale Id 4648',1998.00,0.00,0.00,2.70,229.50,'2022-07-10 18:25:29','',''),(4631,'1','273','1',1,'Retail Sale Id 4649',1502.20,0.00,0.00,2.03,172.55,'2022-07-10 18:31:11','',''),(4632,'1','273','1',1,'Retail Sale Id 4650',3700.00,0.00,0.00,5.00,425.00,'2022-07-10 18:32:07','',''),(4633,'1','273','1',1,'Retail Sale Id 4651',7400.00,0.00,0.00,10.00,850.00,'2022-07-10 18:33:01','',''),(4634,'1','273','1',1,'Retail Sale Id 4652',1998.00,0.00,0.00,2.70,229.50,'2022-07-10 18:34:04','',''),(4635,'1','273','1',1,'Retail Sale Id 4653',799.20,0.00,0.00,1.08,91.80,'2022-07-10 18:38:29','',''),(4636,'1','273','1',1,'Retail Sale Id 4654',999.00,0.00,0.00,1.35,114.75,'2022-07-10 18:42:57','',''),(4637,'1','273','1',1,'Retail Sale Id 4656',9250.00,0.00,0.00,12.50,1062.50,'2022-07-11 07:21:20','',''),(4638,'1','273','1',1,'Retail Sale Id 4657',102000.00,0.00,0.00,150.00,3750.00,'2022-07-11 07:25:16','',''),(4639,'1','273','1',1,'Retail Sale Id 4658',68000.00,0.00,0.00,100.00,2500.00,'2022-07-11 07:26:19','',''),(4640,'1','273','1',1,'Retail Sale Id 4659',747.40,0.00,0.00,1.01,85.85,'2022-07-11 07:28:49','',''),(4641,'1','273','1',1,'Retail Sale Id 4660',5202.20,0.00,0.00,7.03,597.55,'2022-07-11 07:30:16','',''),(4642,'1','273','1',1,'Retail Sale Id 4661',4440.00,0.00,0.00,6.00,510.00,'2022-07-11 07:31:24','',''),(4643,'1','273','1',1,'Retail Sale Id 4662',76160.00,0.00,0.00,112.00,2800.00,'2022-07-11 07:32:39','',''),(4644,'1','273','1',1,'Retail Sale Id 4663',87720.00,0.00,0.00,129.00,3225.00,'2022-07-11 07:38:43','',''),(4645,'1','273','1',1,'Retail Sale Id 4664',1480.00,0.00,0.00,2.00,170.00,'2022-07-11 07:40:23','',''),(4646,'1','273','1',1,'Retail Sale Id 4665',999.00,0.00,0.00,1.35,114.75,'2022-07-11 07:41:17','',''),(4647,'1','273','1',1,'Retail Sale Id 4666',2720.00,0.00,0.00,4.00,100.00,'2022-07-11 07:43:31','',''),(4648,'1','273','1',1,'Retail Sale Id 4667',36040.00,0.00,0.00,53.00,1325.00,'2022-07-11 07:46:35','',''),(4649,'1','273','1',1,'Retail Sale Id 4668',46240.00,0.00,0.00,68.00,1700.00,'2022-07-11 07:49:48','',''),(4650,'1','273','1',1,'Retail Sale Id 4669',34000.00,0.00,0.00,50.00,1250.00,'2022-07-11 07:51:09','',''),(4651,'1','273','1',1,'Retail Sale Id 4670',999.00,0.00,0.00,1.35,114.75,'2022-07-11 07:56:35','',''),(4652,'1','273','1',1,'Retail Sale Id 4671',3700.00,0.00,0.00,5.00,425.00,'2022-07-11 07:57:30','',''),(4653,'1','273','1',1,'Retail Sale Id 4672',999.00,0.00,0.00,1.35,114.75,'2022-07-11 07:58:12','',''),(4654,'1','273','1',1,'Retail Sale Id 4673',21760.00,0.00,0.00,32.00,800.00,'2022-07-11 08:12:36','',''),(4655,'1','273','1',1,'Retail Sale Id 4674',799.20,0.00,0.00,1.08,91.80,'2022-07-11 08:15:05','',''),(4656,'1','273','1',1,'Retail Sale Id 4675',3700.00,0.00,0.00,5.00,425.00,'2022-07-11 08:21:07','',''),(4657,'1','273','1',1,'Retail Sale Id 4676',5150.40,0.00,0.00,6.96,591.60,'2022-07-11 08:23:22','',''),(4658,'1','273','1',1,'Retail Sale Id 4677',4499.20,0.00,0.00,6.08,516.80,'2022-07-11 08:26:11','',''),(4659,'1','273','1',1,'Retail Sale Id 4678',4499.20,0.00,0.00,6.08,516.80,'2022-07-11 08:28:11','',''),(4660,'1','273','1',1,'Retail Sale Id 4679',999.00,0.00,0.00,1.35,114.75,'2022-07-11 08:29:02','',''),(4661,'1','273','1',1,'Retail Sale Id 4680',2079.40,0.00,0.00,2.81,238.85,'2022-07-11 08:30:28','',''),(4662,'1','273','1',1,'Retail Sale Id 4681',3700.00,0.00,0.00,5.00,425.00,'2022-07-11 08:32:10','',''),(4663,'1','273','1',1,'Retail Sale Id 4682',2249.60,0.00,0.00,3.04,258.40,'2022-07-11 08:35:30','',''),(4664,'1','273','1',1,'Retail Sale Id 4683',2197.80,0.00,0.00,2.97,252.45,'2022-07-11 08:37:23','',''),(4665,'1','273','1',1,'Retail Sale Id 4684',42500.00,0.00,0.00,62.50,1562.50,'2022-07-11 08:39:35','',''),(4666,'1','273','1',1,'Retail Sale Id 4685',8880.00,0.00,0.00,12.00,1020.00,'2022-07-11 08:40:42','',''),(4667,'1','273','1',1,'Retail Sale Id 4686',5002.40,0.00,0.00,6.76,574.60,'2022-07-11 08:42:47','',''),(4668,'1','273','1',1,'Retail Sale Id 4687',9250.00,0.00,0.00,12.50,1062.50,'2022-07-11 08:54:11','',''),(4669,'1','273','1',1,'Retail Sale Id 4688',1998.00,0.00,0.00,2.70,229.50,'2022-07-11 09:12:38','',''),(4670,'1','273','1',1,'Retail Sale Id 4689',999.00,0.00,0.00,1.35,114.75,'2022-07-11 09:15:57','',''),(4671,'1','273','1',1,'Retail Sale Id 4690',4432.60,0.00,0.00,5.99,509.15,'2022-07-11 09:17:18','',''),(4672,'1','273','1',1,'Retail Sale Id 4691',68000.00,0.00,0.00,100.00,2500.00,'2022-07-11 09:24:46','',''),(4673,'1','273','1',1,'Retail Sale Id 4692',1998.00,0.00,0.00,2.70,229.50,'2022-07-11 09:26:40','',''),(4674,'1','273','1',1,'Retail Sale Id 4693',40800.00,0.00,0.00,60.00,1500.00,'2022-07-11 09:35:04','',''),(4675,'1','273','1',1,'Retail Sale Id 4694',1480.00,0.00,0.00,2.00,170.00,'2022-07-11 09:36:34','',''),(4676,'1','273','1',1,'Retail Sale Id 4695',3700.00,0.00,0.00,5.00,425.00,'2022-07-11 09:38:32','',''),(4677,'1','273','1',1,'Retail Sale Id 4696',747.40,0.00,0.00,1.01,85.85,'2022-07-11 09:40:44','',''),(4678,'1','273','1',1,'Retail Sale Id 4697',999.00,0.00,0.00,1.35,114.75,'2022-07-11 09:42:04','',''),(4679,'1','273','1',1,'Retail Sale Id 4698',999.00,0.00,0.00,1.35,114.75,'2022-07-11 09:42:54','',''),(4680,'1','273','1',1,'Retail Sale Id 4699',5002.40,0.00,0.00,6.76,574.60,'2022-07-11 09:43:54','',''),(4681,'1','273','1',1,'Retail Sale Id 4700',2997.00,0.00,0.00,4.05,344.25,'2022-07-11 09:58:34','',''),(4682,'1','273','1',1,'Retail Sale Id 4701',1480.00,0.00,0.00,2.00,170.00,'2022-07-11 09:59:50','',''),(4683,'1','273','1',1,'Retail Sale Id 4702',3700.00,0.00,0.00,5.00,425.00,'2022-07-11 10:06:44','',''),(4684,'1','273','1',1,'Retail Sale Id 4704',7400.00,0.00,0.00,10.00,850.00,'2022-07-11 10:16:17','',''),(4685,'1','273','1',1,'Retail Sale Id 4706',747.40,0.00,0.00,1.01,85.85,'2022-07-11 10:23:34','',''),(4686,'1','273','1',1,'Retail Sale Id 4707',102000.00,0.00,0.00,150.00,3750.00,'2022-07-11 10:25:49','',''),(4687,'1','273','1',1,'Retail Sale Id 4708',84320.00,0.00,0.00,124.00,3100.00,'2022-07-11 10:27:42','',''),(4688,'1','273','1',1,'Retail Sale Id 4709',902.80,0.00,0.00,1.22,103.70,'2022-07-11 10:30:12','',''),(4689,'1','273','1',1,'Retail Sale Id 4710',999.00,0.00,0.00,1.35,114.75,'2022-07-11 10:31:28','',''),(4690,'1','273','1',1,'Retail Sale Id 4711',14430.00,0.00,0.00,19.50,1657.50,'2022-07-11 10:40:08','',''),(4691,'1','273','1',1,'Retail Sale Id 4712',9250.00,0.00,0.00,12.50,1062.50,'2022-07-11 10:47:01','',''),(4692,'1','273','1',1,'Retail Sale Id 4713',102000.00,0.00,0.00,150.00,3750.00,'2022-07-11 10:48:45','',''),(4693,'1','273','1',1,'Retail Sale Id 4714',102000.00,0.00,0.00,150.00,3750.00,'2022-07-11 10:50:48','',''),(4694,'1','273','1',1,'Retail Sale Id 4715',8880.00,0.00,0.00,12.00,1020.00,'2022-07-11 10:53:42','',''),(4695,'1','273','1',1,'Retail Sale Id 4716',1198.80,0.00,0.00,1.62,137.70,'2022-07-11 10:55:26','',''),(4696,'1','273','1',1,'Retail Sale Id 4717',9250.00,0.00,0.00,12.50,1062.50,'2022-07-11 11:00:24','',''),(4697,'1','273','1',1,'Retail Sale Id 4718',1502.20,0.00,0.00,2.03,172.55,'2022-07-11 11:02:22','',''),(4698,'1','273','1',1,'Retail Sale Id 4719',2220.00,0.00,0.00,3.00,255.00,'2022-07-11 11:08:09','',''),(4699,'1','273','1',1,'Retail Sale Id 4720',1480.00,0.00,0.00,2.00,170.00,'2022-07-11 11:12:12','',''),(4700,'1','273','1',1,'Retail Sale Id 4722',7400.00,0.00,0.00,10.00,850.00,'2022-07-11 11:13:56','',''),(4701,'1','273','1',1,'Retail Sale Id 4723',2249.60,0.00,0.00,3.04,258.40,'2022-07-11 11:16:06','',''),(4702,'1','273','1',1,'Retail Sale Id 4724',3700.00,0.00,0.00,5.00,425.00,'2022-07-11 11:18:40','',''),(4703,'1','273','1',1,'Retail Sale Id 4726',3700.00,0.00,0.00,5.00,425.00,'2022-07-11 11:28:05','',''),(4704,'1','273','1',1,'Retail Sale Id 4727',9620.00,0.00,0.00,13.00,1105.00,'2022-07-11 11:30:42','',''),(4705,'1','273','1',1,'Retail Sale Id 4728',740.00,0.00,0.00,1.00,85.00,'2022-07-11 11:31:46','',''),(4706,'1','273','1',1,'Retail Sale Id 4729',1480.00,0.00,0.00,2.00,170.00,'2022-07-11 11:35:10','',''),(4707,'1','273','1',1,'Retail Sale Id 4730',8880.00,0.00,0.00,12.00,1020.00,'2022-07-11 11:36:14','',''),(4708,'1','273','1',1,'Retail Sale Id 4731',1998.00,0.00,0.00,2.70,229.50,'2022-07-11 11:42:34','',''),(4709,'1','273','1',1,'Retail Sale Id 4732',11560.00,0.00,0.00,17.00,425.00,'2022-07-11 11:44:03','',''),(4710,'1','273','1',1,'Retail Sale Id 4733',3700.00,0.00,0.00,5.00,425.00,'2022-07-11 11:46:08','',''),(4711,'1','273','1',1,'Retail Sale Id 4734',2952.60,0.00,0.00,3.99,339.15,'2022-07-11 11:49:16','',''),(4712,'1','273','1',1,'Retail Sale Id 4735',1502.20,0.00,0.00,2.03,172.55,'2022-07-11 12:02:27','',''),(4713,'1','273','1',1,'Retail Sale Id 4736',747.40,0.00,0.00,1.01,85.85,'2022-07-11 12:30:38','',''),(4714,'1','273','1',1,'Retail Sale Id 4737',9250.00,0.00,0.00,12.50,1062.50,'2022-07-11 12:35:30','',''),(4715,'1','273','1',1,'Retail Sale Id 4738',999.00,0.00,0.00,1.35,114.75,'2022-07-11 12:37:12','',''),(4716,'1','273','1',1,'Retail Sale Id 4740',2997.00,0.00,0.00,4.05,344.25,'2022-07-11 12:42:47','',''),(4717,'1','273','1',1,'Retail Sale Id 4741',2997.00,0.00,0.00,4.05,344.25,'2022-07-11 12:49:24','',''),(4718,'1','273','1',1,'Retail Sale Id 4742',1502.20,0.00,0.00,2.03,172.55,'2022-07-11 12:55:14','',''),(4719,'1','273','1',1,'Retail Sale Id 4743',68000.00,0.00,0.00,100.00,2500.00,'2022-07-11 13:02:22','',''),(4720,'1','273','1',1,'Retail Sale Id 4744',68000.00,0.00,0.00,100.00,2500.00,'2022-07-11 13:04:18','',''),(4721,'1','273','1',1,'Retail Sale Id 4745',999.00,0.00,0.00,1.35,114.75,'2022-07-11 13:08:02','',''),(4722,'1','273','1',1,'Retail Sale Id 4746',999.00,0.00,0.00,1.35,114.75,'2022-07-11 13:25:29','',''),(4723,'1','273','1',1,'Retail Sale Id 4747',2997.00,0.00,0.00,4.05,344.25,'2022-07-11 13:34:22','',''),(4724,'1','273','1',1,'Retail Sale Id 4748',2997.00,0.00,0.00,4.05,344.25,'2022-07-11 13:49:14','',''),(4725,'1','273','1',1,'Retail Sale Id 4749',7400.00,0.00,0.00,10.00,850.00,'2022-07-11 14:34:27','',''),(4726,'1','273','1',1,'Retail Sale Id 4750',4440.00,0.00,0.00,6.00,510.00,'2022-07-11 14:37:55','',''),(4727,'1','273','1',1,'Retail Sale Id 4751',2197.80,0.00,0.00,2.97,252.45,'2022-07-11 14:45:53','',''),(4728,'1','273','1',1,'Retail Sale Id 4752',4299.40,0.00,0.00,5.81,493.85,'2022-07-11 14:58:57','',''),(4729,'1','273','1',1,'Retail Sale Id 4753',4499.20,0.00,0.00,6.08,516.80,'2022-07-11 15:01:50','',''),(4730,'1','273','1',1,'Retail Sale Id 4754',4440.00,0.00,0.00,6.00,510.00,'2022-07-11 15:02:56','',''),(4731,'1','273','1',1,'Retail Sale Id 4755',991.60,0.00,0.00,1.34,113.90,'2022-07-11 15:21:31','',''),(4732,'1','273','1',1,'Retail Sale Id 4755',1480.00,0.00,0.00,2.00,170.00,'2022-07-11 15:21:31','',''),(4733,'1','273','1',1,'Retail Sale Id 4756',2220.00,0.00,0.00,3.00,255.00,'2022-07-11 15:23:01','',''),(4734,'1','273','1',1,'Retail Sale Id 4757',5180.00,0.00,0.00,7.00,595.00,'2022-07-11 15:30:18','',''),(4735,'1','273','1',1,'Retail Sale Id 4758',68000.00,0.00,0.00,100.00,2500.00,'2022-07-11 15:32:04','',''),(4736,'1','273','1',1,'Retail Sale Id 4759',56100.00,0.00,0.00,82.50,2062.50,'2022-07-11 15:33:16','',''),(4737,'1','273','1',1,'Retail Sale Id 4760',740.00,0.00,0.00,1.00,85.00,'2022-07-11 15:39:33','',''),(4738,'1','273','1',1,'Retail Sale Id 4761',99960.00,0.00,0.00,147.00,3675.00,'2022-07-11 15:44:51','',''),(4739,'1','273','1',1,'Retail Sale Id 4762',9250.00,0.00,0.00,12.50,1062.50,'2022-07-11 15:46:57','',''),(4740,'1','273','1',1,'Retail Sale Id 4763',1998.00,0.00,0.00,2.70,229.50,'2022-07-11 16:01:03','',''),(4741,'1','273','1',1,'Retail Sale Id 4764',2997.00,0.00,0.00,4.05,344.25,'2022-07-11 16:03:59','',''),(4742,'1','273','1',1,'Retail Sale Id 4765',63920.00,0.00,0.00,94.00,2350.00,'2022-07-11 16:11:52','',''),(4743,'1','273','1',1,'Retail Sale Id 4766',9250.00,0.00,0.00,12.50,1062.50,'2022-07-11 16:16:44','',''),(4744,'1','273','1',1,'Retail Sale Id 4767',740.00,0.00,0.00,1.00,85.00,'2022-07-11 16:22:42','',''),(4745,'1','273','1',1,'Retail Sale Id 4768',999.00,0.00,0.00,1.35,114.75,'2022-07-11 16:24:43','',''),(4746,'1','273','1',1,'Retail Sale Id 4769',1480.00,0.00,0.00,2.00,170.00,'2022-07-11 16:33:23','',''),(4747,'1','273','1',1,'Retail Sale Id 4770',747.40,0.00,0.00,1.01,85.85,'2022-07-11 16:37:17','',''),(4748,'1','273','1',1,'Retail Sale Id 4771',13690.00,0.00,0.00,18.50,1572.50,'2022-07-11 16:53:08','',''),(4749,'1','273','1',1,'Retail Sale Id 4772',5180.00,0.00,0.00,7.00,595.00,'2022-07-11 16:56:07','',''),(4750,'1','273','1',1,'Retail Sale Id 4773',4440.00,0.00,0.00,6.00,510.00,'2022-07-11 16:59:59','',''),(4751,'1','273','1',1,'Retail Sale Id 4774',5927.40,0.00,0.00,8.01,680.85,'2022-07-11 17:19:51','',''),(4752,'1','273','1',1,'Retail Sale Id 4775',4440.00,0.00,0.00,6.00,510.00,'2022-07-11 17:22:20','',''),(4753,'1','273','1',1,'Retail Sale Id 4775',9250.00,0.00,0.00,12.50,1062.50,'2022-07-11 17:22:20','',''),(4754,'1','273','1',1,'Retail Sale Id 4776',3226.40,0.00,0.00,4.36,370.60,'2022-07-11 17:24:53','',''),(4755,'1','273','1',1,'Retail Sale Id 4777',4203.20,0.00,0.00,5.68,482.80,'2022-07-11 17:38:16','',''),(4756,'1','273','1',1,'Retail Sale Id 4778',1998.00,0.00,0.00,2.70,229.50,'2022-07-11 17:45:28','',''),(4757,'1','273','1',1,'Retail Sale Id 4779',1502.20,0.00,0.00,2.03,172.55,'2022-07-11 17:49:17','',''),(4758,'1','273','1',1,'Retail Sale Id 4780',2397.60,0.00,0.00,3.24,275.40,'2022-07-11 17:50:37','',''),(4759,'1','273','1',1,'Retail Sale Id 4781',1502.20,0.00,0.00,2.03,172.55,'2022-07-11 17:51:59','',''),(4760,'1','273','1',1,'Retail Sale Id 4782',999.00,0.00,0.00,1.35,114.75,'2022-07-11 17:54:12','',''),(4761,'1','273','1',1,'Retail Sale Id 4783',747.40,0.00,0.00,1.01,85.85,'2022-07-11 18:01:24','',''),(4762,'1','273','1',1,'Retail Sale Id 4784',747.40,0.00,0.00,1.01,85.85,'2022-07-11 18:02:55','',''),(4763,'1','273','1',1,'Retail Sale Id 4785',1998.00,0.00,0.00,2.70,229.50,'2022-07-11 18:17:26','',''),(4764,'1','273','1',1,'Retail Sale Id 4786',747.40,0.00,0.00,1.01,85.85,'2022-07-11 18:18:25','',''),(4765,'1','273','1',1,'Retail Sale Id 4787',3248.60,0.00,0.00,4.39,373.15,'2022-07-11 18:19:38','',''),(4766,'1','273','1',1,'Return of Retail Sale Id 4769',0.00,1480.00,2.00,0.00,-170.00,'2022-07-11 18:39:40','',''),(4767,'1','273','1',1,'Retail Sale Id 4788',1280.20,0.00,0.00,1.73,147.05,'2022-07-11 18:40:29','',''),(4768,'1','273','1',1,'Retail Sale Id 4789',2220.00,0.00,0.00,3.00,255.00,'2022-07-12 06:59:43','',''),(4769,'1','273','1',1,'Retail Sale Id 4790',747.40,0.00,0.00,1.01,85.85,'2022-07-12 07:17:31','',''),(4770,'1','273','1',1,'Retail Sale Id 4791',34000.00,0.00,0.00,50.00,1250.00,'2022-07-12 07:36:00','',''),(4771,'1','273','1',1,'Retail Sale Id 4792',2997.00,0.00,0.00,4.05,344.25,'2022-07-12 07:43:47','',''),(4772,'1','273','1',1,'Retail Sale Id 4793',747.40,0.00,0.00,1.01,85.85,'2022-07-12 07:44:52','',''),(4773,'1','273','1',1,'Retail Sale Id 4794',72760.00,0.00,0.00,107.00,2675.00,'2022-07-12 07:51:11','',''),(4774,'1','273','1',1,'Retail Sale Id 4795',799.20,0.00,0.00,1.08,91.80,'2022-07-12 07:52:20','',''),(4775,'1','273','1',1,'Retail Sale Id 4796',747.40,0.00,0.00,1.01,85.85,'2022-07-12 08:02:23','',''),(4776,'1','273','1',1,'Retail Sale Id 4797',2997.00,0.00,0.00,4.05,344.25,'2022-07-12 08:15:03','',''),(4777,'1','273','1',1,'Retail Sale Id 4798',999.00,0.00,0.00,1.35,114.75,'2022-07-12 08:18:51','',''),(4778,'1','273','1',1,'Retail Sale Id 4799',2997.00,0.00,0.00,4.05,344.25,'2022-07-12 08:25:22','',''),(4779,'1','273','1',1,'Retail Sale Id 4800',1798.20,0.00,0.00,2.43,206.55,'2022-07-12 08:26:19','',''),(4780,'1','273','1',1,'Retail Sale Id 4801',2197.80,0.00,0.00,2.97,252.45,'2022-07-12 08:38:26','',''),(4781,'1','273','1',1,'Retail Sale Id 4802',999.00,0.00,0.00,1.35,114.75,'2022-07-12 08:44:30','',''),(4782,'1','273','1',1,'Retail Sale Id 4803',1102.60,0.00,0.00,1.49,126.65,'2022-07-12 08:47:56','',''),(4783,'1','273','1',1,'Retail Sale Id 4804',9250.00,0.00,0.00,12.50,1062.50,'2022-07-12 08:54:27','',''),(4784,'1','273','1',1,'Retail Sale Id 4805',1998.00,0.00,0.00,2.70,229.50,'2022-07-12 08:55:22','',''),(4785,'1','273','1',1,'Retail Sale Id 4806',3700.00,0.00,0.00,5.00,425.00,'2022-07-12 08:56:24','',''),(4786,'1','273','1',1,'Retail Sale Id 4807',9250.00,0.00,0.00,12.50,1062.50,'2022-07-12 09:18:04','',''),(4787,'1','273','1',1,'Retail Sale Id 4808',8880.00,0.00,0.00,12.00,1020.00,'2022-07-12 09:19:13','',''),(4788,'1','273','1',1,'Retail Sale Id 4809',4447.40,0.00,0.00,6.01,510.85,'2022-07-12 09:30:32','',''),(4789,'1','273','1',1,'Retail Sale Id 4810',1998.00,0.00,0.00,2.70,229.50,'2022-07-12 09:36:19','',''),(4790,'1','273','1',1,'Retail Sale Id 4811',1502.20,0.00,0.00,2.03,172.55,'2022-07-12 09:52:40','',''),(4791,'1','273','1',1,'Retail Sale Id 4812',20400.00,0.00,0.00,30.00,750.00,'2022-07-12 10:16:30','',''),(4792,'1','273','1',1,'Retail Sale Id 4813',747.40,0.00,0.00,1.01,85.85,'2022-07-12 10:17:45','',''),(4793,'1','273','1',1,'Retail Sale Id 4814',3700.00,0.00,0.00,5.00,425.00,'2022-07-12 10:19:05','',''),(4794,'1','273','1',1,'Retail Sale Id 4815',2249.60,0.00,0.00,3.04,258.40,'2022-07-12 10:36:26','',''),(4795,'1','273','1',1,'Retail Sale Id 4816',7999.40,0.00,0.00,10.81,918.85,'2022-07-12 10:39:15','',''),(4796,'1','273','1',1,'Retail Sale Id 4817',999.00,0.00,0.00,1.35,114.75,'2022-07-12 10:52:06','',''),(4797,'1','273','1',1,'Retail Sale Id 4818',740.00,0.00,0.00,1.00,85.00,'2022-07-12 11:12:48','',''),(4798,'1','273','1',1,'Retail Sale Id 4819',1502.20,0.00,0.00,2.03,172.55,'2022-07-12 11:19:28','',''),(4799,'1','273','1',1,'Retail Sale Id 4820',66640.00,0.00,0.00,98.00,2450.00,'2022-07-12 11:21:14','',''),(4800,'1','273','1',1,'Retail Sale Id 4821',33320.00,0.00,0.00,49.00,1225.00,'2022-07-12 11:22:28','',''),(4801,'1','273','1',1,'Retail Sale Id 4822',4003.40,0.00,0.00,5.41,459.85,'2022-07-12 11:31:20','',''),(4802,'1','273','1',1,'Retail Sale Id 4823',34000.00,0.00,0.00,50.00,1250.00,'2022-07-12 11:33:25','',''),(4803,'1','273','1',1,'Retail Sale Id 4824',43520.00,0.00,0.00,64.00,1600.00,'2022-07-12 11:34:10','',''),(4804,'1','273','1',1,'Retail Sale Id 4825',2997.00,0.00,0.00,4.05,344.25,'2022-07-12 11:41:37','',''),(4805,'1','273','1',1,'Retail Sale Id 4826',9250.00,0.00,0.00,12.50,1062.50,'2022-07-12 11:48:13','',''),(4806,'1','273','1',1,'Retail Sale Id 4827',1480.00,0.00,0.00,2.00,170.00,'2022-07-12 11:50:00','',''),(4807,'1','273','1',1,'Retail Sale Id 4828',1998.00,0.00,0.00,2.70,229.50,'2022-07-12 11:50:57','',''),(4808,'1','273','1',1,'Retail Sale Id 4829',11100.00,0.00,0.00,15.00,1275.00,'2022-07-12 12:16:50','',''),(4809,'1','273','1',1,'Retail Sale Id 4830',1998.00,0.00,0.00,2.70,229.50,'2022-07-12 12:30:01','',''),(4810,'1','273','1',1,'Retail Sale Id 4831',2997.00,0.00,0.00,4.05,344.25,'2022-07-12 12:36:17','',''),(4811,'1','273','1',1,'Retail Sale Id 4832',9250.00,0.00,0.00,12.50,1062.50,'2022-07-12 12:40:16','',''),(4812,'1','273','1',1,'Retail Sale Id 4833',2501.20,0.00,0.00,3.38,287.30,'2022-07-12 12:49:03','',''),(4813,'1','273','1',1,'Retail Sale Id 4834',1998.00,0.00,0.00,2.70,229.50,'2022-07-12 12:51:52','',''),(4814,'1','273','1',1,'Retail Sale Id 4835',5180.00,0.00,0.00,7.00,595.00,'2022-07-12 12:53:30','',''),(4815,'1','273','1',1,'Retail Sale Id 4836',2249.60,0.00,0.00,3.04,258.40,'2022-07-12 12:59:09','',''),(4816,'1','273','1',1,'Retail Sale Id 4837',1480.00,0.00,0.00,2.00,170.00,'2022-07-12 13:00:19','',''),(4817,'1','273','1',1,'Retail Sale Id 4838',740.00,0.00,0.00,1.00,85.00,'2022-07-12 13:01:11','',''),(4818,'1','273','1',1,'Retail Sale Id 4839',50320.00,0.00,0.00,74.00,1850.00,'2022-07-12 13:02:27','',''),(4819,'1','273','1',1,'Retail Sale Id 4840',3700.00,0.00,0.00,5.00,425.00,'2022-07-12 13:13:51','',''),(4820,'1','273','1',1,'Retail Sale Id 4841',34000.00,0.00,0.00,50.00,1250.00,'2022-07-12 13:53:35','',''),(4821,'1','273','1',1,'Retail Sale Id 4842',4440.00,0.00,0.00,6.00,510.00,'2022-07-12 13:58:09','',''),(4822,'1','273','1',1,'Retail Sale Id 4843',5180.00,0.00,0.00,7.00,595.00,'2022-07-12 14:02:23','',''),(4823,'1','273','1',1,'Retail Sale Id 4844',2249.60,0.00,0.00,3.04,258.40,'2022-07-12 14:03:37','',''),(4824,'1','273','1',1,'Retail Sale Id 4845',99960.00,0.00,0.00,147.00,3675.00,'2022-07-12 14:05:35','',''),(4825,'1','273','1',1,'Retail Sale Id 4846',133280.00,0.00,0.00,196.00,4900.00,'2022-07-12 14:06:27','',''),(4826,'1','273','1',1,'Retail Sale Id 4847',91120.00,0.00,0.00,134.00,3350.00,'2022-07-12 14:13:34','',''),(4827,'1','273','1',1,'Retail Sale Id 4848',1502.20,0.00,0.00,2.03,172.55,'2022-07-12 14:20:48','',''),(4828,'1','273','1',1,'Retail Sale Id 4849',2220.00,0.00,0.00,3.00,255.00,'2022-07-12 14:27:47','',''),(4829,'1','273','1',1,'Retail Sale Id 4850',2227.40,0.00,0.00,3.01,255.85,'2022-07-12 14:38:34','',''),(4830,'1','273','1',1,'Retail Sale Id 4851',2220.00,0.00,0.00,3.00,255.00,'2022-07-12 14:42:48','',''),(4831,'1','273','1',1,'Retail Sale Id 4852',9250.00,0.00,0.00,12.50,1062.50,'2022-07-12 14:46:58','',''),(4832,'1','273','1',1,'Retail Sale Id 4853',8140.00,0.00,0.00,11.00,935.00,'2022-07-12 14:49:11','',''),(4833,'1','273','1',1,'Retail Sale Id 4854',10730.00,0.00,0.00,14.50,1232.50,'2022-07-12 15:07:45','',''),(4834,'1','273','1',1,'Retail Sale Id 4855',23800.00,0.00,0.00,35.00,875.00,'2022-07-12 15:14:59','',''),(4835,'1','273','1',1,'Retail Sale Id 4856',34000.00,0.00,0.00,50.00,1250.00,'2022-07-12 15:16:45','',''),(4836,'1','273','1',1,'Retail Sale Id 4857',20400.00,0.00,0.00,30.00,750.00,'2022-07-12 15:19:00','',''),(4837,'1','273','1',1,'Retail Sale Id 4858',4003.40,0.00,0.00,5.41,459.85,'2022-07-12 15:30:57','',''),(4838,'1','273','1',1,'Retail Sale Id 4859',5180.00,0.00,0.00,7.00,595.00,'2022-07-12 15:35:36','',''),(4839,'1','273','1',1,'Retail Sale Id 4860',13600.00,0.00,0.00,20.00,500.00,'2022-07-12 15:37:17','',''),(4840,'1','273','1',1,'Retail Sale Id 4861',2220.00,0.00,0.00,3.00,255.00,'2022-07-12 15:47:56','',''),(4841,'1','273','1',1,'Retail Sale Id 4862',4440.00,0.00,0.00,6.00,510.00,'2022-07-12 15:50:06','',''),(4842,'1','273','1',1,'Retail Sale Id 4863',1850.00,0.00,0.00,2.50,212.50,'2022-07-12 15:59:11','',''),(4843,'1','273','1',1,'Retail Sale Id 4864',740.00,0.00,0.00,1.00,85.00,'2022-07-12 16:05:15','',''),(4844,'1','273','1',1,'Retail Sale Id 4865',6660.00,0.00,0.00,9.00,765.00,'2022-07-12 16:06:29','',''),(4845,'1','273','1',1,'Retail Sale Id 4866',2220.00,0.00,0.00,3.00,255.00,'2022-07-12 16:08:05','',''),(4846,'1','273','1',1,'Retail Sale Id 4867',14800.00,0.00,0.00,20.00,1700.00,'2022-07-12 16:14:36','',''),(4847,'1','273','1',1,'Retail Sale Id 4868',999.00,0.00,0.00,1.35,114.75,'2022-07-12 16:23:00','',''),(4848,'1','273','1',1,'Retail Sale Id 4869',9250.00,0.00,0.00,12.50,1062.50,'2022-07-12 16:40:16','',''),(4849,'1','273','1',1,'Retail Sale Id 4870',9250.00,0.00,0.00,12.50,1062.50,'2022-07-12 16:50:46','',''),(4850,'1','273','1',1,'Retail Sale Id 4871',2101.60,0.00,0.00,2.84,241.40,'2022-07-12 16:53:52','',''),(4851,'1','273','1',1,'Retail Sale Id 4872',5202.20,0.00,0.00,7.03,597.55,'2022-07-12 16:59:34','',''),(4852,'1','273','1',1,'Retail Sale Id 4873',4440.00,0.00,0.00,6.00,510.00,'2022-07-12 17:08:50','',''),(4853,'1','273','1',1,'Retail Sale Id 4874',4003.40,0.00,0.00,5.41,459.85,'2022-07-12 17:09:35','',''),(4854,'1','273','1',1,'Retail Sale Id 4875',9250.00,0.00,0.00,12.50,1062.50,'2022-07-12 17:11:26','',''),(4855,'1','273','1',1,'Retail Sale Id 4876',2997.00,0.00,0.00,4.05,344.25,'2022-07-12 17:13:18','',''),(4856,'1','273','1',1,'Retail Sale Id 4877',740.00,0.00,0.00,1.00,85.00,'2022-07-12 17:19:38','',''),(4857,'1','273','1',1,'Retail Sale Id 4878',2597.40,0.00,0.00,3.51,298.35,'2022-07-12 17:41:13','',''),(4858,'1','273','1',1,'Retail Sale Id 4879',762.20,0.00,0.00,1.03,87.55,'2022-07-12 17:45:58','',''),(4859,'1','273','1',1,'Retail Sale Id 4880',1998.00,0.00,0.00,2.70,229.50,'2022-07-12 17:54:15','',''),(4860,'1','273','1',1,'Retail Sale Id 4881',9250.00,0.00,0.00,12.50,1062.50,'2022-07-12 18:02:41','',''),(4861,'1','273','1',1,'Retail Sale Id 4882',7000.40,0.00,0.00,9.46,804.10,'2022-07-13 07:00:27','',''),(4862,'1','273','1',1,'Retail Sale Id 4883',999.00,0.00,0.00,1.35,114.75,'2022-07-13 07:02:22','',''),(4863,'1','273','1',1,'Retail Sale Id 4884',4440.00,0.00,0.00,6.00,510.00,'2022-07-13 07:12:27','',''),(4864,'1','273','1',1,'Retail Sale Id 4885',106080.00,0.00,0.00,156.00,3900.00,'2022-07-13 07:14:22','',''),(4865,'1','273','1',1,'Return of Retail Sale Id 4885',0.00,106080.00,156.00,0.00,-3900.00,'2022-07-13 07:17:05','',''),(4866,'1','273','1',1,'Retail Sale Id 4886',78880.00,0.00,0.00,116.00,2900.00,'2022-07-13 07:17:57','',''),(4867,'1','273','1',1,'Retail Sale Id 4887',102000.00,0.00,0.00,150.00,3750.00,'2022-07-13 07:19:29','',''),(4868,'1','273','1',1,'Retail Sale Id 4888',68000.00,0.00,0.00,100.00,2500.00,'2022-07-13 07:20:12','',''),(4869,'1','273','1',1,'Retail Sale Id 4889',5002.40,0.00,0.00,6.76,574.60,'2022-07-13 07:25:27','',''),(4870,'1','273','1',1,'Retail Sale Id 4890',3700.00,0.00,0.00,5.00,425.00,'2022-07-13 08:03:04','',''),(4871,'1','273','1',1,'Retail Sale Id 4891',4440.00,0.00,0.00,6.00,510.00,'2022-07-13 08:09:17','',''),(4872,'1','273','1',1,'Retail Sale Id 4893',2249.60,0.00,0.00,3.04,258.40,'2022-07-13 08:38:05','',''),(4873,'1','273','1',1,'Retail Sale Id 4894',1502.20,0.00,0.00,2.03,172.55,'2022-07-13 08:52:48','',''),(4874,'1','273','1',1,'Retail Sale Id 4895',4440.00,0.00,0.00,6.00,510.00,'2022-07-13 08:55:38','',''),(4875,'1','273','1',1,'Retail Sale Id 4896',2220.00,0.00,0.00,3.00,255.00,'2022-07-13 08:58:02','',''),(4876,'1','273','1',1,'Retail Sale Id 4897',2249.60,0.00,0.00,3.04,258.40,'2022-07-13 08:59:37','',''),(4877,'1','273','1',1,'Retail Sale Id 4898',2197.80,0.00,0.00,2.97,252.45,'2022-07-13 09:06:42','',''),(4878,'1','273','1',1,'Retail Sale Id 4899',4440.00,0.00,0.00,6.00,510.00,'2022-07-13 09:30:45','',''),(4879,'1','273','1',1,'Retail Sale Id 4900',2997.00,0.00,0.00,4.05,344.25,'2022-07-13 09:42:48','',''),(4880,'1','273','1',1,'Retail Sale Id 4901',1998.00,0.00,0.00,2.70,229.50,'2022-07-13 10:05:01','',''),(4881,'1','273','1',1,'Retail Sale Id 4902',476000.00,0.00,0.00,700.00,17500.00,'2022-07-13 10:19:14','',''),(4882,'1','273','1',1,'Retail Sale Id 4903',544000.00,0.00,0.00,800.00,20000.00,'2022-07-13 10:20:15','',''),(4883,'1','273','1',1,'Retail Sale Id 4904',3700.00,0.00,0.00,5.00,425.00,'2022-07-13 10:21:09','',''),(4884,'1','273','1',1,'Retail Sale Id 4905',40194.80,0.00,0.00,59.11,1477.75,'2022-07-13 10:25:15','',''),(4885,'1','273','1',1,'Retail Sale Id 4906',999.00,0.00,0.00,1.35,114.75,'2022-07-13 10:30:33','',''),(4886,'1','273','1',1,'Retail Sale Id 4907',7999.40,0.00,0.00,10.81,918.85,'2022-07-13 10:33:29','',''),(4887,'1','273','1',1,'Retail Sale Id 4908',1398.60,0.00,0.00,1.89,160.65,'2022-07-13 10:50:18','',''),(4888,'1','273','1',1,'Retail Sale Id 4909',1850.00,0.00,0.00,2.50,212.50,'2022-07-13 10:59:20','',''),(4889,'1','273','1',1,'Retail Sale Id 4910',6001.40,0.00,0.00,8.11,689.35,'2022-07-13 11:10:10','',''),(4890,'1','273','1',1,'Retail Sale Id 4911',1998.00,0.00,0.00,2.70,229.50,'2022-07-13 11:11:21','',''),(4891,'1','273','1',1,'Retail Sale Id 4912',5180.00,0.00,0.00,7.00,595.00,'2022-07-13 11:13:27','',''),(4892,'1','273','1',1,'Retail Sale Id 4913',7400.00,0.00,0.00,10.00,850.00,'2022-07-13 11:14:33','',''),(4893,'1','273','1',1,'Retail Sale Id 4914',2220.00,0.00,0.00,3.00,255.00,'2022-07-13 11:22:06','',''),(4894,'1','273','1',1,'Retail Sale Id 4915',8880.00,0.00,0.00,12.00,1020.00,'2022-07-13 11:27:00','',''),(4895,'1','273','1',1,'Retail Sale Id 4916',2197.80,0.00,0.00,2.97,252.45,'2022-07-13 11:31:01','',''),(4896,'1','273','1',1,'Retail Sale Id 4917',740.00,0.00,0.00,1.00,85.00,'2022-07-13 11:32:11','',''),(4897,'1','273','1',1,'Retail Sale Id 4918',9250.00,0.00,0.00,12.50,1062.50,'2022-07-13 11:43:05','',''),(4898,'1','273','1',1,'Retail Sale Id 4919',3700.00,0.00,0.00,5.00,425.00,'2022-07-13 11:49:55','',''),(4899,'1','273','1',1,'Retail Sale Id 4920',3700.00,0.00,0.00,5.00,425.00,'2022-07-13 12:04:15','',''),(4900,'1','273','1',1,'Retail Sale Id 4921',1302.40,0.00,0.00,1.76,149.60,'2022-07-13 12:05:07','',''),(4901,'1','273','1',1,'Retail Sale Id 4922',4499.20,0.00,0.00,6.08,516.80,'2022-07-13 12:07:14','',''),(4902,'1','273','1',1,'Retail Sale Id 4923',2249.60,0.00,0.00,3.04,258.40,'2022-07-13 12:29:45','',''),(4903,'1','273','1',1,'Retail Sale Id 4924',66640.00,0.00,0.00,98.00,2450.00,'2022-07-13 12:56:39','',''),(4904,'1','273','1',1,'Retail Sale Id 4925',33320.00,0.00,0.00,49.00,1225.00,'2022-07-13 12:58:00','',''),(4905,'1','273','1',1,'Retail Sale Id 4926',9250.00,0.00,0.00,12.50,1062.50,'2022-07-13 13:45:07','',''),(4906,'1','273','1',1,'Retail Sale Id 4927',2997.00,0.00,0.00,4.05,344.25,'2022-07-13 14:05:47','',''),(4907,'1','273','1',1,'Retail Sale Id 4928',33320.00,0.00,0.00,49.00,1225.00,'2022-07-13 14:15:14','',''),(4908,'1','273','1',1,'Retail Sale Id 4929',66640.00,0.00,0.00,98.00,2450.00,'2022-07-13 14:16:22','',''),(4909,'1','273','1',1,'Retail Sale Id 4930',9250.00,0.00,0.00,12.50,1062.50,'2022-07-13 14:34:17','',''),(4910,'1','273','1',1,'Retail Sale Id 4931',9250.00,0.00,0.00,12.50,1062.50,'2022-07-13 14:37:34','',''),(4911,'1','273','1',1,'Retail Sale Id 4932',9620.00,0.00,0.00,13.00,1105.00,'2022-07-13 14:51:06','',''),(4912,'1','273','1',1,'Retail Sale Id 4933',102000.00,0.00,0.00,150.00,3750.00,'2022-07-13 15:16:14','',''),(4913,'1','273','1',1,'Retail Sale Id 4934',68000.00,0.00,0.00,100.00,2500.00,'2022-07-13 15:18:04','',''),(4914,'1','273','1',1,'Retail Sale Id 4935',1480.00,0.00,0.00,2.00,170.00,'2022-07-13 15:19:46','',''),(4915,'1','273','1',1,'Retail Sale Id 4936',1502.20,0.00,0.00,2.03,172.55,'2022-07-13 15:23:47','',''),(4916,'1','273','1',1,'Return of Retail Sale Id 4932',0.00,9620.00,13.00,0.00,-1105.00,'2022-07-13 15:30:30','',''),(4917,'1','273','1',1,'Retail Sale Id 4937',5180.00,0.00,0.00,7.00,595.00,'2022-07-13 15:52:21','',''),(4918,'1','273','1',1,'Retail Sale Id 4938',999.00,0.00,0.00,1.35,114.75,'2022-07-13 15:54:21','',''),(4919,'1','273','1',1,'Retail Sale Id 4939',9250.00,0.00,0.00,12.50,1062.50,'2022-07-13 15:58:31','',''),(4920,'1','273','1',1,'Retail Sale Id 4940',9250.00,0.00,0.00,12.50,1062.50,'2022-07-13 16:02:20','',''),(4921,'1','273','1',1,'Retail Sale Id 4941',747.40,0.00,0.00,1.01,85.85,'2022-07-13 16:04:20','',''),(4922,'1','273','1',1,'Retail Sale Id 4942',11100.00,0.00,0.00,15.00,1275.00,'2022-07-13 16:06:10','',''),(4923,'1','273','1',1,'Retail Sale Id 4943',3700.00,0.00,0.00,5.00,425.00,'2022-07-13 16:07:22','',''),(4924,'1','273','1',1,'Retail Sale Id 4944',18500.00,0.00,0.00,25.00,2125.00,'2022-07-13 16:09:55','',''),(4925,'1','273','1',1,'Retail Sale Id 4945',9250.00,0.00,0.00,12.50,1062.50,'2022-07-13 16:11:34','',''),(4926,'1','273','1',1,'Retail Sale Id 4946',5180.00,0.00,0.00,7.00,595.00,'2022-07-13 16:18:31','',''),(4927,'1','273','1',1,'Retail Sale Id 4947',747.40,0.00,0.00,1.01,85.85,'2022-07-13 16:22:30','',''),(4928,'1','273','1',1,'Retail Sale Id 4948',10200.00,0.00,0.00,15.00,375.00,'2022-07-13 16:32:03','',''),(4929,'1','273','1',1,'Retail Sale Id 4949',747.40,0.00,0.00,1.01,85.85,'2022-07-13 16:34:08','',''),(4930,'1','273','1',1,'Retail Sale Id 4950',9250.00,0.00,0.00,12.50,1062.50,'2022-07-13 16:39:38','',''),(4931,'1','273','1',1,'Retail Sale Id 4951',4440.00,0.00,0.00,6.00,510.00,'2022-07-13 16:40:53','',''),(4932,'1','273','1',1,'Retail Sale Id 4952',747.40,0.00,0.00,1.01,85.85,'2022-07-13 16:42:52','',''),(4933,'1','273','1',1,'Retail Sale Id 4953',4499.20,0.00,0.00,6.08,516.80,'2022-07-13 16:55:31','',''),(4934,'1','273','1',1,'Retail Sale Id 4954',999.00,0.00,0.00,1.35,114.75,'2022-07-13 16:56:34','',''),(4935,'1','273','1',1,'Retail Sale Id 4955',2197.80,0.00,0.00,2.97,252.45,'2022-07-13 16:57:55','',''),(4936,'1','273','1',1,'Retail Sale Id 4956',2249.60,0.00,0.00,3.04,258.40,'2022-07-13 17:00:37','',''),(4937,'1','273','1',1,'Retail Sale Id 4957',1480.00,0.00,0.00,2.00,170.00,'2022-07-13 17:08:21','',''),(4938,'1','273','1',1,'Retail Sale Id 4958',1502.20,0.00,0.00,2.03,172.55,'2022-07-13 17:09:21','',''),(4939,'1','273','1',1,'Retail Sale Id 4959',799.20,0.00,0.00,1.08,91.80,'2022-07-13 17:10:54','',''),(4940,'1','273','1',1,'Retail Sale Id 4960',34000.00,0.00,0.00,50.00,1250.00,'2022-07-13 17:12:11','',''),(4941,'1','273','1',1,'Retail Sale Id 4961',2701.00,0.00,0.00,3.65,310.25,'2022-07-13 17:14:41','',''),(4942,'1','273','1',1,'Retail Sale Id 4962',3700.00,0.00,0.00,5.00,425.00,'2022-07-13 17:15:51','',''),(4943,'1','273','1',1,'Retail Sale Id 4963',1998.00,0.00,0.00,2.70,229.50,'2022-07-13 17:16:48','',''),(4944,'1','273','1',1,'Retail Sale Id 4964',2220.00,0.00,0.00,3.00,255.00,'2022-07-13 17:17:46','',''),(4945,'1','273','1',1,'Retail Sale Id 4965',999.00,0.00,0.00,1.35,114.75,'2022-07-13 17:18:52','',''),(4946,'1','273','1',1,'Retail Sale Id 4966',9250.00,0.00,0.00,12.50,1062.50,'2022-07-13 17:22:24','',''),(4947,'1','273','1',1,'Retail Sale Id 4967',4440.00,0.00,0.00,6.00,510.00,'2022-07-13 17:25:45','',''),(4948,'1','273','1',1,'Retail Sale Id 4968',999.00,0.00,0.00,1.35,114.75,'2022-07-13 17:28:40','',''),(4949,'1','273','1',1,'Retail Sale Id 4969',851.00,0.00,0.00,1.15,97.75,'2022-07-13 17:30:01','',''),(4950,'1','273','1',1,'Retail Sale Id 4970',2220.00,0.00,0.00,3.00,255.00,'2022-07-13 17:34:47','',''),(4951,'1','273','1',1,'Retail Sale Id 4971',999.00,0.00,0.00,1.35,114.75,'2022-07-13 17:35:41','',''),(4952,'1','273','1',1,'Retail Sale Id 4972',747.40,0.00,0.00,1.01,85.85,'2022-07-13 17:39:35','',''),(4953,'1','273','1',1,'Retail Sale Id 4973',1480.00,0.00,0.00,2.00,170.00,'2022-07-13 17:42:28','',''),(4954,'1','273','1',1,'Retail Sale Id 4974',2997.00,0.00,0.00,4.05,344.25,'2022-07-13 17:44:42','',''),(4955,'1','273','1',1,'Retail Sale Id 4975',4440.00,0.00,0.00,6.00,510.00,'2022-07-13 17:49:29','',''),(4956,'1','273','1',1,'Retail Sale Id 4976',999.00,0.00,0.00,1.35,114.75,'2022-07-13 17:52:24','',''),(4957,'1','273','1',1,'Retail Sale Id 4977',5180.00,0.00,0.00,7.00,595.00,'2022-07-13 17:53:43','',''),(4958,'1','273','1',1,'Retail Sale Id 4978',2220.00,0.00,0.00,3.00,255.00,'2022-07-13 17:58:02','',''),(4959,'1','273','1',1,'Retail Sale Id 4979',747.40,0.00,0.00,1.01,85.85,'2022-07-13 17:58:50','',''),(4960,'1','273','1',1,'Retail Sale Id 4980',1480.00,0.00,0.00,2.00,170.00,'2022-07-13 18:02:13','',''),(4961,'1','273','1',1,'Retail Sale Id 4981',4440.00,0.00,0.00,6.00,510.00,'2022-07-13 18:05:51','',''),(4962,'1','273','1',1,'Retail Sale Id 4982',1502.20,0.00,0.00,2.03,172.55,'2022-07-13 18:12:59','',''),(4963,'1','273','1',1,'Retail Sale Id 4983',902.80,0.00,0.00,1.22,103.70,'2022-07-13 18:20:14','',''),(4964,'1','273','1',1,'Retail Sale Id 4985',999.00,0.00,0.00,1.35,114.75,'2022-07-13 18:27:49','',''),(4965,'1','273','1',1,'Retail Sale Id 4986',68000.00,0.00,0.00,100.00,2500.00,'2022-07-14 06:43:04','',''),(4966,'1','273','1',1,'Retail Sale Id 4987',34000.00,0.00,0.00,50.00,1250.00,'2022-07-14 06:43:39','',''),(4967,'1','273','1',1,'Retail Sale Id 4988',1502.20,0.00,0.00,2.03,172.55,'2022-07-14 06:53:49','',''),(4968,'1','273','1',1,'Retail Sale Id 4989',68000.00,0.00,0.00,100.00,2500.00,'2022-07-14 06:58:06','',''),(4969,'1','273','1',1,'Retail Sale Id 4990',102000.00,0.00,0.00,150.00,3750.00,'2022-07-14 06:58:50','',''),(4970,'1','273','1',1,'Retail Sale Id 4991',2997.00,0.00,0.00,4.05,344.25,'2022-07-14 07:04:09','',''),(4971,'1','273','1',1,'Retail Sale Id 4992',71400.00,0.00,0.00,105.00,2625.00,'2022-07-14 07:06:32','',''),(4972,'1','273','1',1,'Retail Sale Id 4993',7000.40,0.00,0.00,9.46,804.10,'2022-07-14 07:17:33','',''),(4973,'1','273','1',1,'Retail Sale Id 4994',9250.00,0.00,0.00,12.50,1062.50,'2022-07-14 07:22:20','',''),(4974,'1','273','1',1,'Retail Sale Id 4995',2220.00,0.00,0.00,3.00,255.00,'2022-07-14 07:25:20','',''),(4975,'1','273','1',1,'Retail Sale Id 4996',9250.00,0.00,0.00,12.50,1062.50,'2022-07-14 07:31:33','',''),(4976,'1','273','1',1,'Retail Sale Id 4997',740.00,0.00,0.00,1.00,85.00,'2022-07-14 07:33:18','',''),(4977,'1','273','1',1,'Retail Sale Id 4998',64600.00,0.00,0.00,95.00,2375.00,'2022-07-14 07:35:09','',''),(4978,'1','273','1',1,'Retail Sale Id 4999',9620.00,0.00,0.00,13.00,1105.00,'2022-07-14 07:38:07','',''),(4979,'1','273','1',1,'Retail Sale Id 5000',4499.20,0.00,0.00,6.08,516.80,'2022-07-14 07:57:01','',''),(4980,'1','273','1',1,'Retail Sale Id 5001',8880.00,0.00,0.00,12.00,1020.00,'2022-07-14 08:11:24','',''),(4981,'1','273','1',1,'Retail Sale Id 5002',2997.00,0.00,0.00,4.05,344.25,'2022-07-14 08:13:34','',''),(4982,'1','273','1',1,'Retail Sale Id 5003',9250.00,0.00,0.00,12.50,1062.50,'2022-07-14 08:22:47','',''),(4983,'1','273','1',1,'Retail Sale Id 5004',4440.00,0.00,0.00,6.00,510.00,'2022-07-14 08:24:22','',''),(4984,'1','273','1',1,'Retail Sale Id 5005',4447.40,0.00,0.00,6.01,510.85,'2022-07-14 08:25:13','',''),(4985,'1','273','1',1,'Retail Sale Id 5006',747.40,0.00,0.00,1.01,85.85,'2022-07-14 08:25:59','',''),(4986,'1','273','1',1,'Retail Sale Id 5007',799.20,0.00,0.00,1.08,91.80,'2022-07-14 08:39:22','',''),(4987,'1','273','1',1,'Retail Sale Id 5008',7400.00,0.00,0.00,10.00,850.00,'2022-07-14 08:42:29','',''),(4988,'1','273','1',1,'Retail Sale Id 5009',3700.00,0.00,0.00,5.00,425.00,'2022-07-14 08:52:32','',''),(4989,'1','273','1',1,'Retail Sale Id 5010',8140.00,0.00,0.00,11.00,935.00,'2022-07-14 09:02:34','',''),(4990,'1','273','1',1,'Retail Sale Id 5011',799.20,0.00,0.00,1.08,91.80,'2022-07-14 09:04:59','',''),(4991,'1','273','1',1,'Retail Sale Id 5012',8880.00,0.00,0.00,12.00,1020.00,'2022-07-14 09:07:32','',''),(4992,'1','273','1',1,'Retail Sale Id 5013',370.00,0.00,0.00,0.50,42.50,'2022-07-14 09:08:58','',''),(4993,'1','273','1',1,'Retail Sale Id 5014',1480.00,0.00,0.00,2.00,170.00,'2022-07-14 09:39:10','',''),(4994,'1','273','1',1,'Retail Sale Id 5015',4440.00,0.00,0.00,6.00,510.00,'2022-07-14 09:56:29','',''),(4995,'1','273','1',1,'Retail Sale Id 5016',136000.00,0.00,0.00,200.00,5000.00,'2022-07-14 10:09:49','',''),(4996,'1','273','1',1,'Retail Sale Id 5018',43520.00,0.00,0.00,64.00,1600.00,'2022-07-14 10:14:39','',''),(4997,'1','273','1',1,'Retail Sale Id 5019',2960.00,0.00,0.00,4.00,340.00,'2022-07-14 10:22:19','',''),(4998,'1','273','1',1,'Retail Sale Id 5020',5002.40,0.00,0.00,6.76,574.60,'2022-07-14 10:23:28','',''),(4999,'1','273','1',1,'Retail Sale Id 5021',9250.00,0.00,0.00,12.50,1062.50,'2022-07-14 10:29:42','',''),(5000,'1','273','1',1,'Retail Sale Id 5022',6001.40,0.00,0.00,8.11,689.35,'2022-07-14 10:34:30','',''),(5001,'1','273','1',1,'Retail Sale Id 5023',1480.00,0.00,0.00,2.00,170.00,'2022-07-14 10:38:39','',''),(5002,'1','273','1',1,'Retail Sale Id 5023',9250.00,0.00,0.00,12.50,1062.50,'2022-07-14 10:38:39','',''),(5003,'1','273','1',1,'Retail Sale Id 5025',5202.20,0.00,0.00,7.03,597.55,'2022-07-14 10:40:50','',''),(5004,'1','273','1',1,'Retail Sale Id 5026',999.00,0.00,0.00,1.35,114.75,'2022-07-14 11:14:08','',''),(5005,'1','273','1',1,'Retail Sale Id 5027',1502.20,0.00,0.00,2.03,172.55,'2022-07-14 11:15:05','',''),(5006,'1','273','1',1,'Retail Sale Id 5028',1502.20,0.00,0.00,2.03,172.55,'2022-07-14 11:24:00','',''),(5007,'1','273','1',1,'Retail Sale Id 5029',747.40,0.00,0.00,1.01,85.85,'2022-07-14 11:26:42','',''),(5008,'1','273','1',1,'Retail Sale Id 5030',20400.00,0.00,0.00,30.00,750.00,'2022-07-14 11:28:52','',''),(5009,'1','273','1',1,'Retail Sale Id 5033',1502.20,0.00,0.00,2.03,172.55,'2022-07-14 11:31:16','',''),(5010,'1','273','1',1,'Retail Sale Id 5034',999.00,0.00,0.00,1.35,114.75,'2022-07-14 11:31:59','',''),(5011,'1','273','1',1,'Retail Sale Id 5035',9520.00,0.00,0.00,14.00,350.00,'2022-07-14 11:35:25','',''),(5012,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,198792.50,303.50,0.00,0.00,'2022-07-14 13:33:52','',''),(5013,'1','273',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,303.50,0.00,'2022-07-14 13:34:51','',''),(5014,'1','273','1',1,'Received from bridging 17',0.00,0.00,303.50,0.00,0.00,'2022-07-14 13:34:51','',''),(5015,'1','273','1',1,'Retail Sale Id 5037',7.40,0.00,0.00,0.01,0.85,'2022-07-14 13:35:49','',''),(5016,'1','273','1',1,'Retail Sale Id 5039',204340.00,0.00,0.00,300.50,7512.50,'2022-07-14 13:39:24','',''),(5017,'1','273','1',1,'Retail Sale Id 5040',2812.00,0.00,0.00,3.80,323.00,'2022-07-14 13:40:26','',''),(5018,'1','273','1',1,'Return of Retail Sale Id 5040',0.00,2812.00,3.80,0.00,-323.00,'2022-07-14 14:24:17','',''),(5019,'1','273','1',1,'Return of Retail Sale Id 5039',0.00,204340.00,300.50,0.00,-7512.50,'2022-07-14 14:26:23','',''),(5020,'1','273','1',1,'Retail Sale Id 5041',206924.00,0.00,0.00,304.30,7607.50,'2022-07-14 14:28:13','',''),(5021,'1','273','1',1,'Return of Retail Sale Id 5037',0.00,7.40,0.01,0.00,-0.85,'2022-07-14 17:10:09','',''),(5022,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,16375000.00,25000.00,0.00,0.00,'2022-07-14 17:13:36','',''),(5023,'1','273',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,24950.00,0.00,'2022-07-14 17:16:30','',''),(5024,'1','273','1',1,'Received from bridging 18',0.00,0.00,24950.00,0.00,0.00,'2022-07-14 17:16:30','',''),(5025,'1','273','1',1,'Retail Sale Id 5042',2893.40,0.00,0.00,3.91,332.35,'2022-07-14 17:17:37','',''),(5026,'1','273','1',1,'Retail Sale Id 5043',34000.00,0.00,0.00,50.00,1250.00,'2022-07-15 07:24:52','',''),(5027,'1','273','1',1,'Retail Sale Id 5044',1998.00,0.00,0.00,2.70,229.50,'2022-07-15 07:37:29','',''),(5028,'1','273','1',1,'Retail Sale Id 5045',4440.00,0.00,0.00,6.00,510.00,'2022-07-15 08:00:32','',''),(5029,'1','273','1',1,'Retail Sale Id 5046',34000.00,0.00,0.00,50.00,1250.00,'2022-07-15 08:08:00','',''),(5030,'1','273','1',1,'Retail Sale Id 5047',8880.00,0.00,0.00,12.00,1020.00,'2022-07-15 08:39:23','',''),(5031,'1','273','1',1,'Retail Sale Id 5048',8880.00,0.00,0.00,12.00,1020.00,'2022-07-15 08:41:10','',''),(5032,'1','273','1',1,'Retail Sale Id 5049',4440.00,0.00,0.00,6.00,510.00,'2022-07-15 08:46:21','',''),(5033,'1','273','1',1,'Retail Sale Id 5050',4440.00,0.00,0.00,6.00,510.00,'2022-07-15 08:49:44','',''),(5034,'1','273','1',1,'Retail Sale Id 5051',102000.00,0.00,0.00,150.00,3750.00,'2022-07-15 09:01:08','',''),(5035,'1','273','1',1,'Retail Sale Id 5052',102000.00,0.00,0.00,150.00,3750.00,'2022-07-15 09:02:17','',''),(5036,'1','273','1',1,'Retail Sale Id 5054',68000.00,0.00,0.00,100.00,2500.00,'2022-07-15 10:22:11','',''),(5037,'1','273','1',1,'Retail Sale Id 5055',84320.00,0.00,0.00,124.00,3100.00,'2022-07-15 10:22:59','',''),(5038,'1','273','1',1,'Retail Sale Id 5056',1480.00,0.00,0.00,2.00,170.00,'2022-07-15 10:40:36','',''),(5039,'1','273','1',1,'Retail Sale Id 5057',2220.00,0.00,0.00,3.00,255.00,'2022-07-15 10:41:38','',''),(5040,'1','273',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,50.00,0.00,'2022-07-15 11:30:46','',''),(5041,'1','273','1',1,'Received from bridging 19',0.00,0.00,50.00,0.00,0.00,'2022-07-15 11:30:46','',''),(5042,'1','273','1',1,'Retail Sale Id 5058',747.40,0.00,0.00,1.01,85.85,'2022-07-15 11:37:39','',''),(5043,'1','273','1',1,'Retail Sale Id 5059',4440.00,0.00,0.00,6.00,510.00,'2022-07-15 11:46:24','',''),(5044,'1','273','1',1,'Retail Sale Id 5060',4440.00,0.00,0.00,6.00,510.00,'2022-07-15 11:47:22','',''),(5045,'1','273','1',1,'Retail Sale Id 5061',1502.20,0.00,0.00,2.03,172.55,'2022-07-15 11:57:21','',''),(5046,'1','273','1',1,'Retail Sale Id 5062',3700.00,0.00,0.00,5.00,425.00,'2022-07-15 11:58:16','',''),(5047,'1','273','1',1,'Retail Sale Id 5064',2997.00,0.00,0.00,4.05,344.25,'2022-07-15 12:08:05','',''),(5048,'1','273','1',1,'Retail Sale Id 5065',34000.00,0.00,0.00,50.00,1250.00,'2022-07-15 12:28:18','',''),(5049,'1','273','1',1,'Retail Sale Id 5066',59160.00,0.00,0.00,87.00,2175.00,'2022-07-15 12:28:56','',''),(5050,'1','273','1',1,'Retail Sale Id 5067',3700.00,0.00,0.00,5.00,425.00,'2022-07-15 12:29:48','',''),(5051,'1','273','1',1,'Retail Sale Id 5068',8998.40,0.00,0.00,12.16,1033.60,'2022-07-15 12:32:37','',''),(5052,'1','273','1',1,'Retail Sale Id 5069',8500.00,0.00,0.00,12.50,312.50,'2022-07-15 12:35:37','',''),(5053,'1','273','1',1,'Retail Sale Id 5070',3700.00,0.00,0.00,5.00,425.00,'2022-07-15 12:46:56','',''),(5054,'1','273','1',1,'Retail Sale Id 5071',9250.00,0.00,0.00,12.50,1062.50,'2022-07-15 13:22:21','',''),(5055,'1','273','1',1,'Retail Sale Id 5073',2249.60,0.00,0.00,3.04,258.40,'2022-07-15 13:41:55','',''),(5056,'1','273','1',1,'Retail Sale Id 5074',799.20,0.00,0.00,1.08,91.80,'2022-07-15 13:45:49','',''),(5057,'1','273','1',1,'Retail Sale Id 5075',7400.00,0.00,0.00,10.00,850.00,'2022-07-15 13:52:19','',''),(5058,'1','273','1',1,'Retail Sale Id 5076',9301.80,0.00,0.00,12.57,1068.45,'2022-07-15 13:55:42','',''),(5059,'1','273','1',1,'Retail Sale Id 5077',747.40,0.00,0.00,1.01,85.85,'2022-07-15 14:06:54','',''),(5060,'1','273','1',1,'Retail Sale Id 5078',2960.00,0.00,0.00,4.00,340.00,'2022-07-15 14:47:19','',''),(5061,'1','273','1',1,'Retail Sale Id 5079',1480.00,0.00,0.00,2.00,170.00,'2022-07-15 14:48:45','',''),(5062,'1','273','1',1,'Retail Sale Id 5080',5601.80,0.00,0.00,7.57,643.45,'2022-07-15 14:52:41','',''),(5063,'1','273','1',1,'Retail Sale Id 5081',5180.00,0.00,0.00,7.00,595.00,'2022-07-15 14:54:43','',''),(5064,'1','273','1',1,'Retail Sale Id 5082',28560.00,0.00,0.00,42.00,1050.00,'2022-07-15 14:58:49','',''),(5065,'1','273','1',1,'Retail Sale Id 5083',1480.00,0.00,0.00,2.00,170.00,'2022-07-15 15:14:23','',''),(5066,'1','273','1',1,'Retail Sale Id 5084',2220.00,0.00,0.00,3.00,255.00,'2022-07-15 15:15:18','',''),(5067,'1','273','1',1,'Retail Sale Id 5085',1502.20,0.00,0.00,2.03,172.55,'2022-07-15 15:17:40','',''),(5068,'1','273','1',1,'Retail Sale Id 5086',4440.00,0.00,0.00,6.00,510.00,'2022-07-15 15:27:36','',''),(5069,'1','273','1',1,'Retail Sale Id 5087',3400.00,0.00,0.00,5.00,125.00,'2022-07-15 15:36:00','',''),(5070,'1','273','1',1,'Retail Sale Id 5088',9250.00,0.00,0.00,12.50,1062.50,'2022-07-15 15:37:17','',''),(5071,'1','273','1',1,'Retail Sale Id 5089',2501.20,0.00,0.00,3.38,287.30,'2022-07-15 15:46:18','',''),(5072,'1','273','1',1,'Retail Sale Id 5090',2220.00,0.00,0.00,3.00,255.00,'2022-07-15 15:50:42','',''),(5073,'1','273','1',1,'Retail Sale Id 5091',740.00,0.00,0.00,1.00,85.00,'2022-07-15 15:51:17','',''),(5074,'1','273','1',1,'Retail Sale Id 5092',3700.00,0.00,0.00,5.00,425.00,'2022-07-15 15:52:57','',''),(5075,'1','273','1',1,'Retail Sale Id 5093',34000.00,0.00,0.00,50.00,1250.00,'2022-07-15 16:02:55','',''),(5076,'1','273','1',1,'Retail Sale Id 5094',68000.00,0.00,0.00,100.00,2500.00,'2022-07-15 16:03:43','',''),(5077,'1','273','1',1,'Retail Sale Id 5095',1502.20,0.00,0.00,2.03,172.55,'2022-07-15 16:04:53','',''),(5078,'1','273','1',1,'Retail Sale Id 5096',9250.00,0.00,0.00,12.50,1062.50,'2022-07-15 16:10:47','',''),(5079,'1','273','1',1,'Retail Sale Id 5097',2220.00,0.00,0.00,3.00,255.00,'2022-07-15 16:13:41','',''),(5080,'1','273','1',1,'Retail Sale Id 5098',2220.00,0.00,0.00,3.00,255.00,'2022-07-15 16:16:42','',''),(5081,'1','273','1',1,'Retail Sale Id 5099',1998.00,0.00,0.00,2.70,229.50,'2022-07-15 16:24:19','',''),(5082,'1','273','1',1,'Retail Sale Id 5100',4440.00,0.00,0.00,6.00,510.00,'2022-07-15 16:31:28','',''),(5083,'1','273','1',1,'Retail Sale Id 5101',25500.00,0.00,0.00,37.50,937.50,'2022-07-15 16:34:51','',''),(5084,'1','273','1',1,'Retail Sale Id 5102',9250.00,0.00,0.00,12.50,1062.50,'2022-07-15 16:41:16','',''),(5085,'1','273','1',1,'Retail Sale Id 5103',7000.40,0.00,0.00,9.46,804.10,'2022-07-15 16:43:39','',''),(5086,'1','273','1',1,'Retail Sale Id 5104',2220.00,0.00,0.00,3.00,255.00,'2022-07-15 16:46:32','',''),(5087,'1','273','1',1,'Retail Sale Id 5105',999.60,0.00,0.00,1.47,36.75,'2022-07-15 16:52:00','',''),(5088,'1','273','1',1,'Retail Sale Id 5106',999.00,0.00,0.00,1.35,114.75,'2022-07-15 17:01:44','',''),(5089,'1','273','1',1,'Retail Sale Id 5107',2197.80,0.00,0.00,2.97,252.45,'2022-07-15 17:08:48','',''),(5090,'1','273','1',1,'Retail Sale Id 5108',2220.00,0.00,0.00,3.00,255.00,'2022-07-15 17:11:49','',''),(5091,'1','273','1',1,'Retail Sale Id 5109',1480.00,0.00,0.00,2.00,170.00,'2022-07-15 17:14:23','',''),(5092,'1','273','1',1,'Retail Sale Id 5110',999.00,0.00,0.00,1.35,114.75,'2022-07-15 17:15:18','',''),(5093,'1','273','1',1,'Retail Sale Id 5111',2701.00,0.00,0.00,3.65,310.25,'2022-07-15 17:22:29','',''),(5094,'1','273','1',1,'Retail Sale Id 5112',1998.00,0.00,0.00,2.70,229.50,'2022-07-15 17:23:32','',''),(5095,'1','273','1',1,'Retail Sale Id 5114',2997.00,0.00,0.00,4.05,344.25,'2022-07-15 17:32:52','',''),(5096,'1','273','1',1,'Retail Sale Id 5115',747.40,0.00,0.00,1.01,85.85,'2022-07-15 17:36:13','',''),(5097,'1','273','1',1,'Retail Sale Id 5116',999.00,0.00,0.00,1.35,114.75,'2022-07-15 17:37:06','',''),(5098,'1','273','1',1,'Retail Sale Id 5117',4440.00,0.00,0.00,6.00,510.00,'2022-07-15 17:42:46','',''),(5099,'1','273','1',1,'Retail Sale Id 5118',747.40,0.00,0.00,1.01,85.85,'2022-07-15 18:02:37','',''),(5100,'1','273','1',1,'Retail Sale Id 5119',7400.00,0.00,0.00,10.00,850.00,'2022-07-15 18:03:59','',''),(5101,'1','273','1',1,'Retail Sale Id 5120',1302.40,0.00,0.00,1.76,149.60,'2022-07-15 18:26:41','',''),(5102,'1','273','1',1,'Retail Sale Id 5121',1502.20,0.00,0.00,2.03,172.55,'2022-07-15 18:30:42','',''),(5103,'1','273','1',1,'Retail Sale Id 5122',2249.60,0.00,0.00,3.04,258.40,'2022-07-15 18:33:22','',''),(5104,'1','273','1',1,'Return of Retail Sale Id 5043',0.00,34000.00,50.00,0.00,-1250.00,'2022-07-15 19:11:04','',''),(5105,'1','273','1',1,'Retail Sale Id 5123',33728.00,0.00,0.00,49.60,1240.00,'2022-07-15 19:12:09','',''),(5106,'1','273','1',1,'Retail Sale Id 5124',4499.20,0.00,0.00,6.08,516.80,'2022-07-16 07:03:30','',''),(5107,'1','273','1',1,'Retail Sale Id 5125',68000.00,0.00,0.00,100.00,2500.00,'2022-07-16 07:06:02','',''),(5108,'1','273','1',1,'Retail Sale Id 5126',102000.00,0.00,0.00,150.00,3750.00,'2022-07-16 07:06:43','',''),(5109,'1','273','1',1,'Retail Sale Id 5127',2249.60,0.00,0.00,3.04,258.40,'2022-07-16 07:11:11','',''),(5110,'1','273','1',1,'Retail Sale Id 5128',740.00,0.00,0.00,1.00,85.00,'2022-07-16 07:12:18','',''),(5111,'1','273','1',1,'Retail Sale Id 5129',12002.80,0.00,0.00,16.22,1378.70,'2022-07-16 07:17:58','',''),(5112,'1','273','1',1,'Retail Sale Id 5130',2271.80,0.00,0.00,3.07,260.95,'2022-07-16 07:20:21','',''),(5113,'1','273','1',1,'Retail Sale Id 5131',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 07:28:18','',''),(5114,'1','273','1',1,'Retail Sale Id 5132',747.40,0.00,0.00,1.01,85.85,'2022-07-16 07:33:34','',''),(5115,'1','273','1',1,'Retail Sale Id 5133',68000.00,0.00,0.00,100.00,2500.00,'2022-07-16 07:49:34','',''),(5116,'1','273','1',1,'Retail Sale Id 5134',68000.00,0.00,0.00,100.00,2500.00,'2022-07-16 07:50:10','',''),(5117,'1','273','1',1,'Retail Sale Id 5135',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 07:51:55','',''),(5118,'1','273','1',1,'Retail Sale Id 5136',2997.00,0.00,0.00,4.05,344.25,'2022-07-16 07:58:53','',''),(5119,'1','273','1',1,'Retail Sale Id 5137',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 08:00:12','',''),(5120,'1','273','1',1,'Retail Sale Id 5138',2997.00,0.00,0.00,4.05,344.25,'2022-07-16 08:02:31','',''),(5121,'1','273','1',1,'Retail Sale Id 5139',39440.00,0.00,0.00,58.00,1450.00,'2022-07-16 08:03:59','',''),(5122,'1','273','1',1,'Retail Sale Id 5140',54400.00,0.00,0.00,80.00,2000.00,'2022-07-16 08:04:54','',''),(5123,'1','273','1',1,'Retail Sale Id 5141',999.00,0.00,0.00,1.35,114.75,'2022-07-16 08:08:32','',''),(5124,'1','273','1',1,'Retail Sale Id 5142',747.40,0.00,0.00,1.01,85.85,'2022-07-16 08:09:25','',''),(5125,'1','273','1',1,'Retail Sale Id 5143',2220.00,0.00,0.00,3.00,255.00,'2022-07-16 08:15:30','',''),(5126,'1','273','1',1,'Retail Sale Id 5144',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 08:20:47','',''),(5127,'1','273','1',1,'Retail Sale Id 5145',747.40,0.00,0.00,1.01,85.85,'2022-07-16 08:21:37','',''),(5128,'1','273','1',1,'Retail Sale Id 5147',4760.00,0.00,0.00,7.00,175.00,'2022-07-16 08:24:03','',''),(5129,'1','273','1',1,'Retail Sale Id 5148',2301.40,0.00,0.00,3.11,264.35,'2022-07-16 08:25:46','',''),(5130,'1','273','1',1,'Retail Sale Id 5149',999.00,0.00,0.00,1.35,114.75,'2022-07-16 08:30:43','',''),(5131,'1','273','1',1,'Retail Sale Id 5150',1702.00,0.00,0.00,2.30,195.50,'2022-07-16 08:31:21','',''),(5132,'1','273','1',1,'Retail Sale Id 5151',747.40,0.00,0.00,1.01,85.85,'2022-07-16 08:33:31','',''),(5133,'1','273','1',1,'Retail Sale Id 5152',952.50,0.00,0.00,1.27,120.65,'2022-07-16 08:34:46','',''),(5134,'1','273','1',1,'Retail Sale Id 5153',740.00,0.00,0.00,1.00,85.00,'2022-07-16 08:37:53','',''),(5135,'1','273','1',1,'Retail Sale Id 5154',1998.00,0.00,0.00,2.70,229.50,'2022-07-16 08:41:11','',''),(5136,'1','273','1',1,'Retail Sale Id 5155',2960.00,0.00,0.00,4.00,340.00,'2022-07-16 08:49:33','',''),(5137,'1','273','1',1,'Retail Sale Id 5156',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 08:54:20','',''),(5138,'1','273','1',1,'Retail Sale Id 5157',2997.00,0.00,0.00,4.05,344.25,'2022-07-16 09:01:58','',''),(5139,'1','273','1',1,'Retail Sale Id 5158',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 09:03:21','',''),(5140,'1','273','1',1,'Retail Sale Id 5159',3700.00,0.00,0.00,5.00,425.00,'2022-07-16 09:06:15','',''),(5141,'1','273','1',1,'Retail Sale Id 5160',4440.00,0.00,0.00,6.00,510.00,'2022-07-16 09:15:01','',''),(5142,'1','273','1',1,'Retail Sale Id 5161',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 09:20:30','',''),(5143,'1','273','1',1,'Retail Sale Id 5162',23800.00,0.00,0.00,35.00,875.00,'2022-07-16 09:26:16','',''),(5144,'1','273','1',1,'Retail Sale Id 5163',1480.00,0.00,0.00,2.00,170.00,'2022-07-16 09:47:34','',''),(5145,'1','273','1',1,'Retail Sale Id 5164',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 10:00:04','',''),(5146,'1','273','1',1,'Retail Sale Id 5165',1480.00,0.00,0.00,2.00,170.00,'2022-07-16 10:01:00','',''),(5147,'1','273','1',1,'Retail Sale Id 5166',4440.00,0.00,0.00,6.00,510.00,'2022-07-16 10:10:14','',''),(5148,'1','273','1',1,'Retail Sale Id 5167',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 10:19:02','',''),(5149,'1','273','1',1,'Retail Sale Id 5168',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 10:29:40','',''),(5150,'1','273','1',1,'Retail Sale Id 5169',1480.00,0.00,0.00,2.00,170.00,'2022-07-16 10:32:15','',''),(5151,'1','273','1',1,'Retail Sale Id 5170',3700.00,0.00,0.00,5.00,425.00,'2022-07-16 10:38:32','',''),(5152,'1','273','1',1,'Retail Sale Id 5171',1502.20,0.00,0.00,2.03,172.55,'2022-07-16 10:45:01','',''),(5153,'1','273','1',1,'Retail Sale Id 5172',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 10:47:08','',''),(5154,'1','273','1',1,'Retail Sale Id 5174',3700.00,0.00,0.00,5.00,425.00,'2022-07-16 10:58:31','',''),(5155,'1','273','1',1,'Retail Sale Id 5175',2997.00,0.00,0.00,4.05,344.25,'2022-07-16 10:59:18','',''),(5156,'1','273','1',1,'Retail Sale Id 5176',1850.00,0.00,0.00,2.50,212.50,'2022-07-16 10:59:46','',''),(5157,'1','273','1',1,'Retail Sale Id 5177',2960.00,0.00,0.00,4.00,340.00,'2022-07-16 11:01:03','',''),(5158,'1','273','1',1,'Retail Sale Id 5178',999.00,0.00,0.00,1.35,114.75,'2022-07-16 11:02:23','',''),(5159,'1','273','1',1,'Retail Sale Id 5179',11100.00,0.00,0.00,15.00,1275.00,'2022-07-16 11:10:31','',''),(5160,'1','273','1',1,'Retail Sale Id 5180',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 11:21:39','',''),(5161,'1','273','1',1,'Retail Sale Id 5181',2960.00,0.00,0.00,4.00,340.00,'2022-07-16 11:22:49','',''),(5162,'1','273','1',1,'Retail Sale Id 5182',1502.20,0.00,0.00,2.03,172.55,'2022-07-16 11:24:20','',''),(5163,'1','273','1',1,'Retail Sale Id 5183',87040.00,0.00,0.00,128.00,3200.00,'2022-07-16 11:25:56','',''),(5164,'1','273','1',1,'Retail Sale Id 5184',34000.00,0.00,0.00,50.00,1250.00,'2022-07-16 11:27:45','',''),(5165,'1','273','1',1,'Retail Sale Id 5185',6660.00,0.00,0.00,9.00,765.00,'2022-07-16 11:32:32','',''),(5166,'1','273','1',1,'Retail Sale Id 5186',2249.60,0.00,0.00,3.04,258.40,'2022-07-16 11:42:32','',''),(5167,'1','273','1',1,'Retail Sale Id 5187',33320.00,0.00,0.00,49.00,1225.00,'2022-07-16 11:52:01','',''),(5168,'1','273','1',1,'Retail Sale Id 5188',747.40,0.00,0.00,1.01,85.85,'2022-07-16 12:04:19','',''),(5169,'1','273','1',1,'Retail Sale Id 5189',34000.00,0.00,0.00,50.00,1250.00,'2022-07-16 12:08:48','',''),(5170,'1','273','1',1,'Retail Sale Id 5190',1998.00,0.00,0.00,2.70,229.50,'2022-07-16 12:12:13','',''),(5171,'1','273','1',1,'Retail Sale Id 5191',747.40,0.00,0.00,1.01,85.85,'2022-07-16 12:23:40','',''),(5172,'1','273','1',1,'Retail Sale Id 5192',2249.60,0.00,0.00,3.04,258.40,'2022-07-16 12:45:37','',''),(5173,'1','273','1',1,'Retail Sale Id 5193',3700.00,0.00,0.00,5.00,425.00,'2022-07-16 12:47:44','',''),(5174,'1','273','1',1,'Retail Sale Id 5194',2197.80,0.00,0.00,2.97,252.45,'2022-07-16 12:58:13','',''),(5175,'1','273','1',1,'Retail Sale Id 5195',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 13:01:23','',''),(5176,'1','273','1',1,'Retail Sale Id 5196',2997.00,0.00,0.00,4.05,344.25,'2022-07-16 13:04:22','',''),(5177,'1','273','1',1,'Retail Sale Id 5197',747.40,0.00,0.00,1.01,85.85,'2022-07-16 13:09:30','',''),(5178,'1','273','1',1,'Retail Sale Id 5198',3700.00,0.00,0.00,5.00,425.00,'2022-07-16 13:13:57','',''),(5179,'1','273','1',1,'Retail Sale Id 5199',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 13:27:57','',''),(5180,'1','273','1',1,'Retail Sale Id 5200',2249.60,0.00,0.00,3.04,258.40,'2022-07-16 13:40:34','',''),(5181,'1','273','1',1,'Retail Sale Id 5201',1480.00,0.00,0.00,2.00,170.00,'2022-07-16 13:45:09','',''),(5182,'1','273','1',1,'Retail Sale Id 5202',8880.00,0.00,0.00,12.00,1020.00,'2022-07-16 14:04:25','',''),(5183,'1','273','1',1,'Retail Sale Id 5203',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 14:05:53','',''),(5184,'1','273','1',1,'Retail Sale Id 5204',5002.40,0.00,0.00,6.76,574.60,'2022-07-16 14:11:43','',''),(5185,'1','273','1',1,'Retail Sale Id 5205',2220.00,0.00,0.00,3.00,255.00,'2022-07-16 14:26:21','',''),(5186,'1','273','1',1,'Retail Sale Id 5206',99960.00,0.00,0.00,147.00,3675.00,'2022-07-16 14:28:22','',''),(5187,'1','273','1',1,'Retail Sale Id 5207',66640.00,0.00,0.00,98.00,2450.00,'2022-07-16 14:29:50','',''),(5188,'1','273','1',1,'Retail Sale Id 5208',2220.00,0.00,0.00,3.00,255.00,'2022-07-16 14:34:16','',''),(5189,'1','273','1',1,'Retail Sale Id 5209',1480.00,0.00,0.00,2.00,170.00,'2022-07-16 14:48:52','',''),(5190,'1','273','1',1,'Retail Sale Id 5210',2997.00,0.00,0.00,4.05,344.25,'2022-07-16 15:12:16','',''),(5191,'1','273','1',1,'Retail Sale Id 5211',7400.00,0.00,0.00,10.00,850.00,'2022-07-16 15:15:21','',''),(5192,'1','273','1',1,'Retail Sale Id 5212',8902.20,0.00,0.00,12.03,1022.55,'2022-07-16 15:24:53','',''),(5193,'1','273','1',1,'Retail Sale Id 5213',999.00,0.00,0.00,1.35,114.75,'2022-07-16 15:25:49','',''),(5194,'1','273','1',1,'Retail Sale Id 5214',2997.00,0.00,0.00,4.05,344.25,'2022-07-16 15:26:47','',''),(5195,'1','273','1',1,'Retail Sale Id 5215',1502.20,0.00,0.00,2.03,172.55,'2022-07-16 15:27:44','',''),(5196,'1','273','1',1,'Retail Sale Id 5216',2952.60,0.00,0.00,3.99,339.15,'2022-07-16 15:28:47','',''),(5197,'1','273','1',1,'Retail Sale Id 5217',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 15:41:52','',''),(5198,'1','273','1',1,'Retail Sale Id 5218',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 15:46:31','',''),(5199,'1','273','1',1,'Retail Sale Id 5219',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 15:54:46','',''),(5200,'1','273','1',1,'Retail Sale Id 5220',747.40,0.00,0.00,1.01,85.85,'2022-07-16 15:57:15','',''),(5201,'1','273','1',1,'Retail Sale Id 5221',5202.20,0.00,0.00,7.03,597.55,'2022-07-16 15:59:41','',''),(5202,'1','273','1',1,'Retail Sale Id 5222',3700.00,0.00,0.00,5.00,425.00,'2022-07-16 16:00:34','',''),(5203,'1','273','1',1,'Retail Sale Id 5223',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 16:03:25','',''),(5204,'1','273','1',1,'Retail Sale Id 5224',5202.20,0.00,0.00,7.03,597.55,'2022-07-16 16:05:09','',''),(5205,'1','273','1',1,'Retail Sale Id 5225',747.40,0.00,0.00,1.01,85.85,'2022-07-16 16:06:48','',''),(5206,'1','273','1',1,'Retail Sale Id 5226',6001.40,0.00,0.00,8.11,689.35,'2022-07-16 16:13:18','',''),(5207,'1','273','1',1,'Retail Sale Id 5227',5180.00,0.00,0.00,7.00,595.00,'2022-07-16 16:20:30','',''),(5208,'1','273','1',1,'Retail Sale Id 5228',4003.40,0.00,0.00,5.41,459.85,'2022-07-16 16:21:22','',''),(5209,'1','273','1',1,'Retail Sale Id 5229',4440.00,0.00,0.00,6.00,510.00,'2022-07-16 16:26:15','',''),(5210,'1','273','1',1,'Retail Sale Id 5230',81600.00,0.00,0.00,120.00,3000.00,'2022-07-16 16:32:59','',''),(5211,'1','273','1',1,'Retail Sale Id 5231',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 16:36:37','',''),(5212,'1','273','1',1,'Retail Sale Id 5232',4440.00,0.00,0.00,6.00,510.00,'2022-07-16 16:49:15','',''),(5213,'1','273','1',1,'Retail Sale Id 5233',45560.00,0.00,0.00,67.00,1675.00,'2022-07-16 16:52:27','',''),(5214,'1','273','1',1,'Retail Sale Id 5234',2701.00,0.00,0.00,3.65,310.25,'2022-07-16 16:54:01','',''),(5215,'1','273','1',1,'Retail Sale Id 5235',8880.00,0.00,0.00,12.00,1020.00,'2022-07-16 17:02:11','',''),(5216,'1','273','1',1,'Retail Sale Id 5236',1502.20,0.00,0.00,2.03,172.55,'2022-07-16 17:03:31','',''),(5217,'1','273','1',1,'Retail Sale Id 5237',747.40,0.00,0.00,1.01,85.85,'2022-07-16 17:05:33','',''),(5218,'1','273','1',1,'Retail Sale Id 5238',34000.00,0.00,0.00,50.00,1250.00,'2022-07-16 17:16:25','',''),(5219,'1','273','1',1,'Retail Sale Id 5239',2960.00,0.00,0.00,4.00,340.00,'2022-07-16 17:17:15','',''),(5220,'1','273','1',1,'Retail Sale Id 5240',999.00,0.00,0.00,1.35,114.75,'2022-07-16 17:19:22','',''),(5221,'1','273','1',1,'Retail Sale Id 5241',747.40,0.00,0.00,1.01,85.85,'2022-07-16 17:27:52','',''),(5222,'1','273','1',1,'Retail Sale Id 5242',9250.00,0.00,0.00,12.50,1062.50,'2022-07-16 17:29:53','',''),(5223,'1','273','1',1,'Retail Sale Id 5243',999.00,0.00,0.00,1.35,114.75,'2022-07-16 17:34:13','',''),(5224,'1','273','1',1,'Retail Sale Id 5244',999.00,0.00,0.00,1.35,114.75,'2022-07-16 17:35:25','',''),(5225,'1','273','1',1,'Retail Sale Id 5245',8880.00,0.00,0.00,12.00,1020.00,'2022-07-16 17:41:38','',''),(5226,'1','273','1',1,'Retail Sale Id 5246',747.40,0.00,0.00,1.01,85.85,'2022-07-16 17:50:59','',''),(5227,'1','273','1',1,'Retail Sale Id 5247',7400.00,0.00,0.00,10.00,850.00,'2022-07-16 17:53:45','',''),(5228,'1','273','1',1,'Retail Sale Id 5248',2220.00,0.00,0.00,3.00,255.00,'2022-07-16 17:54:30','',''),(5229,'1','273','1',1,'Retail Sale Id 5249',2841.60,0.00,0.00,3.84,326.40,'2022-07-16 18:09:10','',''),(5230,'1','273','1',1,'Retail Sale Id 5250',999.00,0.00,0.00,1.35,114.75,'2022-07-16 18:12:28','',''),(5231,'1','273','1',1,'Retail Sale Id 5251',999.00,0.00,0.00,1.35,114.75,'2022-07-17 06:59:01','',''),(5232,'1','273','1',1,'Retail Sale Id 5252',4499.20,0.00,0.00,6.08,516.80,'2022-07-17 06:59:46','',''),(5233,'1','273','1',1,'Retail Sale Id 5253',8880.00,0.00,0.00,12.00,1020.00,'2022-07-17 07:09:29','',''),(5234,'1','273','1',1,'Retail Sale Id 5254',1502.20,0.00,0.00,2.03,172.55,'2022-07-17 07:10:16','',''),(5235,'1','273','1',1,'Retail Sale Id 5255',1998.00,0.00,0.00,2.70,229.50,'2022-07-17 07:10:56','',''),(5236,'1','273','1',1,'Retail Sale Id 5256',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 07:23:24','',''),(5237,'1','273','1',1,'Retail Sale Id 5257',1502.20,0.00,0.00,2.03,172.55,'2022-07-17 07:40:35','',''),(5238,'1','273','1',1,'Retail Sale Id 5258',29994.80,0.00,0.00,44.11,1102.75,'2022-07-17 07:41:32','',''),(5239,'1','273','1',1,'Retail Sale Id 5259',999.00,0.00,0.00,1.35,114.75,'2022-07-17 07:56:50','',''),(5240,'1','273','1',1,'Retail Sale Id 5260',1480.00,0.00,0.00,2.00,170.00,'2022-07-17 08:01:01','',''),(5241,'1','273','1',1,'Retail Sale Id 5261',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 08:02:15','',''),(5242,'1','273','1',1,'Retail Sale Id 5262',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 08:08:28','',''),(5243,'1','273','1',1,'Retail Sale Id 5263',747.40,0.00,0.00,1.01,85.85,'2022-07-17 08:09:45','',''),(5244,'1','273','1',1,'Retail Sale Id 5264',2249.60,0.00,0.00,3.04,258.40,'2022-07-17 08:10:48','',''),(5245,'1','273','1',1,'Retail Sale Id 5265',799.20,0.00,0.00,1.08,91.80,'2022-07-17 08:11:32','',''),(5246,'1','273','1',1,'Retail Sale Id 5266',2997.00,0.00,0.00,4.05,344.25,'2022-07-17 08:15:09','',''),(5247,'1','273','1',1,'Retail Sale Id 5267',39440.00,0.00,0.00,58.00,1450.00,'2022-07-17 08:23:46','',''),(5248,'1','273','1',1,'Retail Sale Id 5268',29920.00,0.00,0.00,44.00,1100.00,'2022-07-17 08:24:32','',''),(5249,'1','273','1',1,'Retail Sale Id 5269',1302.40,0.00,0.00,1.76,149.60,'2022-07-17 08:27:22','',''),(5250,'1','273','1',1,'Retail Sale Id 5271',999.00,0.00,0.00,1.35,114.75,'2022-07-17 08:28:18','',''),(5251,'1','273','1',1,'Retail Sale Id 5272',1480.00,0.00,0.00,2.00,170.00,'2022-07-17 08:31:19','',''),(5252,'1','273','1',1,'Retail Sale Id 5273',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 09:01:55','',''),(5253,'1','273','1',1,'Retail Sale Id 5274',5002.40,0.00,0.00,6.76,574.60,'2022-07-17 09:02:53','',''),(5254,'1','273','1',1,'Retail Sale Id 5275',2797.20,0.00,0.00,3.78,321.30,'2022-07-17 09:08:42','',''),(5255,'1','273','1',1,'Retail Sale Id 5276',3648.20,0.00,0.00,4.93,419.05,'2022-07-17 09:33:13','',''),(5256,'1','273','1',1,'Retail Sale Id 5277',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 09:36:24','',''),(5257,'1','273','1',1,'Retail Sale Id 5278',999.00,0.00,0.00,1.35,114.75,'2022-07-17 09:37:10','',''),(5258,'1','273','1',1,'Retail Sale Id 5279',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 09:51:23','',''),(5259,'1','273','1',1,'Retail Sale Id 5280',2501.20,0.00,0.00,3.38,287.30,'2022-07-17 10:30:28','',''),(5260,'1','273','1',1,'Retail Sale Id 5281',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 10:35:35','',''),(5261,'1','273','1',1,'Retail Sale Id 5282',4403.00,0.00,0.00,5.95,505.75,'2022-07-17 10:48:32','',''),(5262,'1','273','1',1,'Retail Sale Id 5283',2301.40,0.00,0.00,3.11,264.35,'2022-07-17 11:14:47','',''),(5263,'1','273','1',1,'Retail Sale Id 5284',1480.00,0.00,0.00,2.00,170.00,'2022-07-17 11:23:27','',''),(5264,'1','273','1',1,'Retail Sale Id 5285',2960.00,0.00,0.00,4.00,340.00,'2022-07-17 11:26:56','',''),(5265,'1','273','1',1,'Retail Sale Id 5286',5180.00,0.00,0.00,7.00,595.00,'2022-07-17 11:28:03','',''),(5266,'1','273','1',1,'Retail Sale Id 5287',799.20,0.00,0.00,1.08,91.80,'2022-07-17 11:30:16','',''),(5267,'1','273','1',1,'Retail Sale Id 5288',4440.00,0.00,0.00,6.00,510.00,'2022-07-17 11:32:51','',''),(5268,'1','273','1',1,'Retail Sale Id 5289',18500.00,0.00,0.00,25.00,2125.00,'2022-07-17 11:33:57','',''),(5269,'1','273','1',1,'Retail Sale Id 5290',747.40,0.00,0.00,1.01,85.85,'2022-07-17 11:34:54','',''),(5270,'1','273','1',1,'Retail Sale Id 5291',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 11:37:45','',''),(5271,'1','273','1',1,'Retail Sale Id 5291',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 11:37:45','',''),(5272,'1','273','1',1,'Retail Sale Id 5292',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 11:54:33','',''),(5273,'1','273','1',1,'Retail Sale Id 5293',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 11:55:15','',''),(5274,'1','273','1',1,'Retail Sale Id 5294',1502.20,0.00,0.00,2.03,172.55,'2022-07-17 12:10:40','',''),(5275,'1','273','1',1,'Retail Sale Id 5295',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 12:13:25','',''),(5276,'1','273','1',1,'Retail Sale Id 5296',27200.00,0.00,0.00,40.00,1000.00,'2022-07-17 12:19:25','',''),(5277,'1','273','1',1,'Retail Sale Id 5297',5180.00,0.00,0.00,7.00,595.00,'2022-07-17 12:21:33','',''),(5278,'1','273','1',1,'Retail Sale Id 5298',2220.00,0.00,0.00,3.00,255.00,'2022-07-17 12:28:26','',''),(5279,'1','273','1',1,'Retail Sale Id 5299',2220.00,0.00,0.00,3.00,255.00,'2022-07-17 12:29:28','',''),(5280,'1','273','1',1,'Retail Sale Id 5300',740.00,0.00,0.00,1.00,85.00,'2022-07-17 12:31:11','',''),(5281,'1','273','1',1,'Retail Sale Id 5301',4003.40,0.00,0.00,5.41,459.85,'2022-07-17 12:34:54','',''),(5282,'1','273','1',1,'Retail Sale Id 5302',4440.00,0.00,0.00,6.00,510.00,'2022-07-17 12:46:30','',''),(5283,'1','273','1',1,'Retail Sale Id 5303',2997.00,0.00,0.00,4.05,344.25,'2022-07-17 12:52:42','',''),(5284,'1','273','1',1,'Retail Sale Id 5304',14800.00,0.00,0.00,20.00,1700.00,'2022-07-17 13:07:34','',''),(5285,'1','273','1',1,'Retail Sale Id 5305',2220.00,0.00,0.00,3.00,255.00,'2022-07-17 13:07:59','',''),(5286,'1','273','1',1,'Retail Sale Id 5306',999.00,0.00,0.00,1.35,114.75,'2022-07-17 13:11:04','',''),(5287,'1','273','1',1,'Retail Sale Id 5307',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 13:12:23','',''),(5288,'1','273','1',1,'Retail Sale Id 5308',1502.20,0.00,0.00,2.03,172.55,'2022-07-17 13:13:50','',''),(5289,'1','273','1',1,'Retail Sale Id 5309',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 13:27:07','',''),(5290,'1','273','1',1,'Retail Sale Id 5310',34000.00,0.00,0.00,50.00,1250.00,'2022-07-17 13:31:27','',''),(5291,'1','273','1',1,'Retail Sale Id 5311',740.00,0.00,0.00,1.00,85.00,'2022-07-17 13:32:05','',''),(5292,'1','273','1',1,'Retail Sale Id 5312',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 13:33:08','',''),(5293,'1','273','1',1,'Retail Sale Id 5313',5180.00,0.00,0.00,7.00,595.00,'2022-07-17 13:33:53','',''),(5294,'1','273','1',1,'Retail Sale Id 5315',1480.00,0.00,0.00,2.00,170.00,'2022-07-17 13:37:02','',''),(5295,'1','273','1',1,'Retail Sale Id 5316',2220.00,0.00,0.00,3.00,255.00,'2022-07-17 13:47:51','',''),(5296,'1','273','1',1,'Retail Sale Id 5317',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 13:49:29','',''),(5297,'1','273','1',1,'Retail Sale Id 5317',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 13:49:29','',''),(5298,'1','273','1',1,'Retail Sale Id 5318',6660.00,0.00,0.00,9.00,765.00,'2022-07-17 13:50:34','',''),(5299,'1','273','1',1,'Retail Sale Id 5319',1998.00,0.00,0.00,2.70,229.50,'2022-07-17 13:51:36','',''),(5300,'1','273','1',1,'Retail Sale Id 5320',5920.00,0.00,0.00,8.00,680.00,'2022-07-17 13:56:10','',''),(5301,'1','273','1',1,'Retail Sale Id 5320',8880.00,0.00,0.00,12.00,1020.00,'2022-07-17 13:56:10','',''),(5302,'1','273','1',1,'Retail Sale Id 5321',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 13:57:00','',''),(5303,'1','273','1',1,'Retail Sale Id 5322',1998.00,0.00,0.00,2.70,229.50,'2022-07-17 13:59:57','',''),(5304,'1','273','1',1,'Retail Sale Id 5323',2997.00,0.00,0.00,4.05,344.25,'2022-07-17 14:10:58','',''),(5305,'1','273','1',1,'Retail Sale Id 5324',4440.00,0.00,0.00,6.00,510.00,'2022-07-17 14:21:48','',''),(5306,'1','273','1',1,'Retail Sale Id 5324',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 14:21:48','',''),(5307,'1','273','1',1,'Retail Sale Id 5325',34000.00,0.00,0.00,50.00,1250.00,'2022-07-17 14:26:44','',''),(5308,'1','273','1',1,'Retail Sale Id 5326',40800.00,0.00,0.00,60.00,1500.00,'2022-07-17 14:27:24','',''),(5309,'1','273','1',1,'Retail Sale Id 5327',2501.20,0.00,0.00,3.38,287.30,'2022-07-17 14:33:59','',''),(5310,'1','273','1',1,'Retail Sale Id 5328',1480.00,0.00,0.00,2.00,170.00,'2022-07-17 14:35:21','',''),(5311,'1','273','1',1,'Retail Sale Id 5329',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 14:44:51','',''),(5312,'1','273','1',1,'Retail Sale Id 5330',10360.00,0.00,0.00,14.00,1190.00,'2022-07-17 14:46:03','',''),(5313,'1','273','1',1,'Retail Sale Id 5331',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 14:53:27','',''),(5314,'1','273','1',1,'Retail Sale Id 5332',2997.00,0.00,0.00,4.05,344.25,'2022-07-17 14:55:34','',''),(5315,'1','273','1',1,'Retail Sale Id 5333',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 14:56:20','',''),(5316,'1','273','1',1,'Retail Sale Id 5334',1502.20,0.00,0.00,2.03,172.55,'2022-07-17 14:57:08','',''),(5317,'1','273','1',1,'Retail Sale Id 5335',11100.00,0.00,0.00,15.00,1275.00,'2022-07-17 14:58:03','',''),(5318,'1','273','1',1,'Retail Sale Id 5336',1480.00,0.00,0.00,2.00,170.00,'2022-07-17 15:01:05','',''),(5319,'1','273','1',1,'Retail Sale Id 5337',2997.00,0.00,0.00,4.05,344.25,'2022-07-17 15:04:50','',''),(5320,'1','273','1',1,'Retail Sale Id 5338',740.00,0.00,0.00,1.00,85.00,'2022-07-17 15:05:21','',''),(5321,'1','273','1',1,'Retail Sale Id 5339',2220.00,0.00,0.00,3.00,255.00,'2022-07-17 15:10:06','',''),(5322,'1','273','1',1,'Retail Sale Id 5340',999.00,0.00,0.00,1.35,114.75,'2022-07-17 15:18:17','',''),(5323,'1','273','1',1,'Retail Sale Id 5341',481.00,0.00,0.00,0.65,55.25,'2022-07-17 15:19:34','',''),(5324,'1','273','1',1,'Retail Sale Id 5342',4440.00,0.00,0.00,6.00,510.00,'2022-07-17 15:28:19','',''),(5325,'1','273','1',1,'Retail Sale Id 5343',740.00,0.00,0.00,1.00,85.00,'2022-07-17 15:51:35','',''),(5326,'1','273','1',1,'Retail Sale Id 5344',7999.40,0.00,0.00,10.81,918.85,'2022-07-17 15:56:09','',''),(5327,'1','273','1',1,'Retail Sale Id 5345',747.40,0.00,0.00,1.01,85.85,'2022-07-17 15:57:19','',''),(5328,'1','273','1',1,'Retail Sale Id 5346',1998.00,0.00,0.00,2.70,229.50,'2022-07-17 16:06:18','',''),(5329,'1','273','1',1,'Retail Sale Id 5347',34000.00,0.00,0.00,50.00,1250.00,'2022-07-17 16:11:03','',''),(5330,'1','273','1',1,'Retail Sale Id 5348',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 16:26:21','',''),(5331,'1','273','1',1,'Retail Sale Id 5349',7400.00,0.00,0.00,10.00,850.00,'2022-07-17 16:44:17','',''),(5332,'1','273','1',1,'Retail Sale Id 5350',3700.00,0.00,0.00,5.00,425.00,'2022-07-17 16:46:41','',''),(5333,'1','273','1',1,'Retail Sale Id 5351',1480.00,0.00,0.00,2.00,170.00,'2022-07-17 16:53:20','',''),(5334,'1','273','1',1,'Retail Sale Id 5353',740.00,0.00,0.00,1.00,85.00,'2022-07-17 16:54:03','',''),(5335,'1','273','1',1,'Retail Sale Id 5354',799.20,0.00,0.00,1.08,91.80,'2022-07-17 17:03:18','',''),(5336,'1','273','1',1,'Retail Sale Id 5355',747.40,0.00,0.00,1.01,85.85,'2022-07-17 17:03:58','',''),(5337,'1','273','1',1,'Retail Sale Id 5356',2997.00,0.00,0.00,4.05,344.25,'2022-07-17 17:13:13','',''),(5338,'1','273','1',1,'Retail Sale Id 5357',8140.00,0.00,0.00,11.00,935.00,'2022-07-17 17:14:24','',''),(5339,'1','273','1',1,'Retail Sale Id 5358',747.40,0.00,0.00,1.01,85.85,'2022-07-17 17:15:23','',''),(5340,'1','273','1',1,'Retail Sale Id 5359',4440.00,0.00,0.00,6.00,510.00,'2022-07-17 17:16:09','',''),(5341,'1','273','1',1,'Retail Sale Id 5360',747.40,0.00,0.00,1.01,85.85,'2022-07-17 17:19:37','',''),(5342,'1','273','1',1,'Retail Sale Id 5361',7400.00,0.00,0.00,10.00,850.00,'2022-07-17 17:21:09','',''),(5343,'1','273','1',1,'Retail Sale Id 5362',2220.00,0.00,0.00,3.00,255.00,'2022-07-17 17:25:09','',''),(5344,'1','273','1',1,'Retail Sale Id 5363',999.00,0.00,0.00,1.35,114.75,'2022-07-17 17:28:31','',''),(5345,'1','273','1',1,'Retail Sale Id 5364',5180.00,0.00,0.00,7.00,595.00,'2022-07-17 17:29:54','',''),(5346,'1','273','1',1,'Retail Sale Id 5365',999.00,0.00,0.00,1.35,114.75,'2022-07-17 17:46:36','',''),(5347,'1','273','1',1,'Retail Sale Id 5366',2997.00,0.00,0.00,4.05,344.25,'2022-07-17 18:05:35','',''),(5348,'1','273','1',1,'Retail Sale Id 5367',999.00,0.00,0.00,1.35,114.75,'2022-07-17 18:09:02','',''),(5349,'1','273','1',1,'Retail Sale Id 5367',9250.00,0.00,0.00,12.50,1062.50,'2022-07-17 18:09:02','',''),(5350,'1','273','1',1,'Return of Retail Sale Id 5351',0.00,1480.00,2.00,0.00,-170.00,'2022-07-17 18:35:40','',''),(5351,'1','273','1',1,'Retail Sale Id 5368',1332.00,0.00,0.00,1.80,153.00,'2022-07-17 18:36:15','',''),(5352,'1','273','1',1,'Retail Sale Id 5369',102000.00,0.00,0.00,150.00,3750.00,'2022-07-18 06:59:19','',''),(5353,'1','273','1',1,'Retail Sale Id 5370',68000.00,0.00,0.00,100.00,2500.00,'2022-07-18 07:00:04','',''),(5354,'1','273','1',1,'Retail Sale Id 5371',5002.40,0.00,0.00,6.76,574.60,'2022-07-18 07:02:25','',''),(5355,'1','273','1',1,'Retail Sale Id 5372',2960.00,0.00,0.00,4.00,340.00,'2022-07-18 07:05:13','',''),(5356,'1','273','1',1,'Retail Sale Id 5373',747.40,0.00,0.00,1.01,85.85,'2022-07-18 07:07:18','',''),(5357,'1','273','1',1,'Retail Sale Id 5374',1043.40,0.00,0.00,1.41,119.85,'2022-07-18 07:11:19','',''),(5358,'1','273','1',1,'Retail Sale Id 5375',64600.00,0.00,0.00,95.00,2375.00,'2022-07-18 07:13:04','',''),(5359,'1','273','1',1,'Retail Sale Id 5376',3700.00,0.00,0.00,5.00,425.00,'2022-07-18 07:13:59','',''),(5360,'1','273','1',1,'Retail Sale Id 5377',42920.00,0.00,0.00,58.00,4930.00,'2022-07-18 07:17:19','',''),(5361,'1','273','1',1,'Return of Retail Sale Id 5377',0.00,42920.00,58.00,0.00,-4930.00,'2022-07-18 07:18:50','',''),(5362,'1','273','1',1,'Retail Sale Id 5378',39440.00,0.00,0.00,58.00,1450.00,'2022-07-18 07:19:17','',''),(5363,'1','273','1',1,'Retail Sale Id 5379',2997.00,0.00,0.00,4.05,344.25,'2022-07-18 07:36:29','',''),(5364,'1','273','1',1,'Retail Sale Id 5380',5897.80,0.00,0.00,7.97,677.45,'2022-07-18 07:38:24','',''),(5365,'1','273','1',1,'Retail Sale Id 5381',799.20,0.00,0.00,1.08,91.80,'2022-07-18 07:39:35','',''),(5366,'1','273','1',1,'Retail Sale Id 5382',2960.00,0.00,0.00,4.00,340.00,'2022-07-18 07:43:21','',''),(5367,'1','273','1',1,'Retail Sale Id 5383',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 07:50:04','',''),(5368,'1','273','1',1,'Retail Sale Id 5384',1502.20,0.00,0.00,2.03,172.55,'2022-07-18 07:55:54','',''),(5369,'1','273','1',1,'Retail Sale Id 5385',40800.00,0.00,0.00,60.00,1500.00,'2022-07-18 07:59:20','',''),(5370,'1','273','1',1,'Retail Sale Id 5386',42840.00,0.00,0.00,63.00,1575.00,'2022-07-18 08:00:29','',''),(5371,'1','273','1',1,'Retail Sale Id 5387',3700.00,0.00,0.00,5.00,425.00,'2022-07-18 08:11:43','',''),(5372,'1','273','1',1,'Retail Sale Id 5388',747.40,0.00,0.00,1.01,85.85,'2022-07-18 08:15:47','',''),(5373,'1','273','1',1,'Retail Sale Id 5389',747.40,0.00,0.00,1.01,85.85,'2022-07-18 08:19:31','',''),(5374,'1','273','1',1,'Retail Sale Id 5390',4440.00,0.00,0.00,6.00,510.00,'2022-07-18 08:23:09','',''),(5375,'1','273','1',1,'Retail Sale Id 5391',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 08:28:19','',''),(5376,'1','273','1',1,'Retail Sale Id 5392',4440.00,0.00,0.00,6.00,510.00,'2022-07-18 08:36:39','',''),(5377,'1','273','1',1,'Retail Sale Id 5393',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 08:48:32','',''),(5378,'1','273','1',1,'Retail Sale Id 5394',7400.00,0.00,0.00,10.00,850.00,'2022-07-18 08:49:31','',''),(5379,'1','273','1',1,'Retail Sale Id 5395',1480.00,0.00,0.00,2.00,170.00,'2022-07-18 08:50:30','',''),(5380,'1','273','1',1,'Retail Sale Id 5396',5002.40,0.00,0.00,6.76,574.60,'2022-07-18 08:51:31','',''),(5381,'1','273','1',1,'Retail Sale Id 5397',4003.40,0.00,0.00,5.41,459.85,'2022-07-18 08:54:56','',''),(5382,'1','273','1',1,'Retail Sale Id 5398',2220.00,0.00,0.00,3.00,255.00,'2022-07-18 08:56:57','',''),(5383,'1','273','1',1,'Retail Sale Id 5398',5002.40,0.00,0.00,6.76,574.60,'2022-07-18 08:56:57','',''),(5384,'1','273','1',1,'Retail Sale Id 5399',17000.00,0.00,0.00,25.00,625.00,'2022-07-18 09:05:54','',''),(5385,'1','273','1',1,'Retail Sale Id 5400',7400.00,0.00,0.00,10.00,850.00,'2022-07-18 09:09:30','',''),(5386,'1','273','1',1,'Retail Sale Id 5401',747.40,0.00,0.00,1.01,85.85,'2022-07-18 09:18:34','',''),(5387,'1','273','1',1,'Retail Sale Id 5402',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 09:21:26','',''),(5388,'1','273','1',1,'Retail Sale Id 5403',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 09:22:29','',''),(5389,'1','273','1',1,'Retail Sale Id 5404',27200.00,0.00,0.00,40.00,1000.00,'2022-07-18 09:28:23','',''),(5390,'1','273','1',1,'Retail Sale Id 5405',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 09:31:23','',''),(5391,'1','273','1',1,'Retail Sale Id 5406',1850.00,0.00,0.00,2.50,212.50,'2022-07-18 10:02:48','',''),(5392,'1','273','1',1,'Retail Sale Id 5407',1480.00,0.00,0.00,2.00,170.00,'2022-07-18 10:05:22','',''),(5393,'1','273','1',1,'Retail Sale Id 5408',747.40,0.00,0.00,1.01,85.85,'2022-07-18 10:11:41','',''),(5394,'1','273','1',1,'Retail Sale Id 5409',5180.00,0.00,0.00,7.00,595.00,'2022-07-18 10:12:46','',''),(5395,'1','273','1',1,'Retail Sale Id 5410',2997.00,0.00,0.00,4.05,344.25,'2022-07-18 10:14:04','',''),(5396,'1','273','1',1,'Retail Sale Id 5411',7400.00,0.00,0.00,10.00,850.00,'2022-07-18 10:31:13','',''),(5397,'1','273','1',1,'Retail Sale Id 5413',10360.00,0.00,0.00,14.00,1190.00,'2022-07-18 10:32:53','',''),(5398,'1','273','1',1,'Retail Sale Id 5414',2197.80,0.00,0.00,2.97,252.45,'2022-07-18 10:34:27','',''),(5399,'1','273','1',1,'Retail Sale Id 5415',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 10:37:59','',''),(5400,'1','273','1',1,'Retail Sale Id 5416',740.00,0.00,0.00,1.00,85.00,'2022-07-18 10:49:42','',''),(5401,'1','273','1',1,'Retail Sale Id 5417',8160.00,0.00,0.00,12.00,300.00,'2022-07-18 11:06:46','',''),(5402,'1','273','1',1,'Retail Sale Id 5418',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 11:11:40','',''),(5403,'1','273','1',1,'Retail Sale Id 5419',2997.00,0.00,0.00,4.05,344.25,'2022-07-18 12:09:46','',''),(5404,'1','273','1',1,'Retail Sale Id 5420',999.00,0.00,0.00,1.35,114.75,'2022-07-18 12:10:30','',''),(5405,'1','273','1',1,'Retail Sale Id 5421',3700.00,0.00,0.00,5.00,425.00,'2022-07-18 12:24:07','',''),(5406,'1','273','1',1,'Retail Sale Id 5422',2220.00,0.00,0.00,3.00,255.00,'2022-07-18 12:26:16','',''),(5407,'1','273','1',1,'Retail Sale Id 5422',4440.00,0.00,0.00,6.00,510.00,'2022-07-18 12:26:16','',''),(5408,'1','273','1',1,'Retail Sale Id 5423',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 12:34:07','',''),(5409,'1','273','1',1,'Retail Sale Id 5424',2197.80,0.00,0.00,2.97,252.45,'2022-07-18 12:40:48','',''),(5410,'1','273','1',1,'Retail Sale Id 5425',902.80,0.00,0.00,1.22,103.70,'2022-07-18 12:58:05','',''),(5411,'1','273','1',1,'Retail Sale Id 5426',747.40,0.00,0.00,1.01,85.85,'2022-07-18 13:55:57','',''),(5412,'1','273','1',1,'Retail Sale Id 5427',2220.00,0.00,0.00,3.00,255.00,'2022-07-18 13:56:52','',''),(5413,'1','273','1',1,'Retail Sale Id 5428',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 14:07:33','',''),(5414,'1','273','1',1,'Retail Sale Id 5429',2197.80,0.00,0.00,2.97,252.45,'2022-07-18 14:13:11','',''),(5415,'1','273','1',1,'Retail Sale Id 5430',2227.40,0.00,0.00,3.01,255.85,'2022-07-18 14:22:46','',''),(5416,'1','273','1',1,'Retail Sale Id 5431',999.00,0.00,0.00,1.35,114.75,'2022-07-18 14:26:51','',''),(5417,'1','273','1',1,'Retail Sale Id 5432',1480.00,0.00,0.00,2.00,170.00,'2022-07-18 14:34:46','',''),(5418,'1','273','1',1,'Retail Sale Id 5433',1502.20,0.00,0.00,2.03,172.55,'2022-07-18 14:45:07','',''),(5419,'1','273','1',1,'Retail Sale Id 5434',747.40,0.00,0.00,1.01,85.85,'2022-07-18 14:48:45','',''),(5420,'1','273','1',1,'Retail Sale Id 5435',102000.00,0.00,0.00,150.00,3750.00,'2022-07-18 14:56:06','',''),(5421,'1','273','1',1,'Retail Sale Id 5436',110160.00,0.00,0.00,162.00,4050.00,'2022-07-18 14:58:58','',''),(5422,'1','273','1',1,'Retail Sale Id 5437',1502.20,0.00,0.00,2.03,172.55,'2022-07-18 15:00:02','',''),(5423,'1','273','1',1,'Retail Sale Id 5438',2220.00,0.00,0.00,3.00,255.00,'2022-07-18 15:01:16','',''),(5424,'1','273','1',1,'Retail Sale Id 5439',2301.40,0.00,0.00,3.11,264.35,'2022-07-18 15:05:54','',''),(5425,'1','273','1',1,'Retail Sale Id 5440',3700.00,0.00,0.00,5.00,425.00,'2022-07-18 15:06:37','',''),(5426,'1','273','1',1,'Retail Sale Id 5441',1502.20,0.00,0.00,2.03,172.55,'2022-07-18 15:07:17','',''),(5427,'1','273','1',1,'Retail Sale Id 5442',2997.00,0.00,0.00,4.05,344.25,'2022-07-18 15:28:47','',''),(5428,'1','273','1',1,'Retail Sale Id 5443',2960.00,0.00,0.00,4.00,340.00,'2022-07-18 15:34:45','',''),(5429,'1','273','1',1,'Retail Sale Id 5444',1502.20,0.00,0.00,2.03,172.55,'2022-07-18 15:37:52','',''),(5430,'1','273','1',1,'Retail Sale Id 5445',3700.00,0.00,0.00,5.00,425.00,'2022-07-18 15:38:47','',''),(5431,'1','273','1',1,'Retail Sale Id 5446',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 15:41:23','',''),(5432,'1','273','1',1,'Retail Sale Id 5447',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 15:43:19','',''),(5433,'1','273','1',1,'Retail Sale Id 5448',4499.20,0.00,0.00,6.08,516.80,'2022-07-18 15:48:48','',''),(5434,'1','273','1',1,'Retail Sale Id 5449',2301.40,0.00,0.00,3.11,264.35,'2022-07-18 16:09:29','',''),(5435,'1','273','1',1,'Retail Sale Id 5450',1398.60,0.00,0.00,1.89,160.65,'2022-07-18 16:19:28','',''),(5436,'1','273','1',1,'Retail Sale Id 5451',7400.00,0.00,0.00,10.00,850.00,'2022-07-18 16:20:51','',''),(5437,'1','273','1',1,'Retail Sale Id 5452',2997.00,0.00,0.00,4.05,344.25,'2022-07-18 16:24:51','',''),(5438,'1','273','1',1,'Retail Sale Id 5453',999.00,0.00,0.00,1.35,114.75,'2022-07-18 16:25:55','',''),(5439,'1','273','1',1,'Retail Sale Id 5454',3700.00,0.00,0.00,5.00,425.00,'2022-07-18 16:30:32','',''),(5440,'1','273','1',1,'Retail Sale Id 5455',7400.00,0.00,0.00,10.00,850.00,'2022-07-18 16:33:54','',''),(5441,'1','273','1',1,'Retail Sale Id 5456',999.00,0.00,0.00,1.35,114.75,'2022-07-18 16:34:40','',''),(5442,'1','273','1',1,'Retail Sale Id 5457',7400.00,0.00,0.00,10.00,850.00,'2022-07-18 16:37:47','',''),(5443,'1','273','1',1,'Retail Sale Id 5458',2952.60,0.00,0.00,3.99,339.15,'2022-07-18 16:42:37','',''),(5444,'1','273','1',1,'Retail Sale Id 5459',1998.00,0.00,0.00,2.70,229.50,'2022-07-18 16:46:21','',''),(5445,'1','273','1',1,'Retail Sale Id 5460',799.20,0.00,0.00,1.08,91.80,'2022-07-18 16:56:50','',''),(5446,'1','273','1',1,'Retail Sale Id 5461',999.00,0.00,0.00,1.35,114.75,'2022-07-18 17:04:25','',''),(5447,'1','273','1',1,'Retail Sale Id 5462',3700.00,0.00,0.00,5.00,425.00,'2022-07-18 17:07:32','',''),(5448,'1','273','1',1,'Retail Sale Id 5463',799.20,0.00,0.00,1.08,91.80,'2022-07-18 17:09:27','',''),(5449,'1','273','1',1,'Retail Sale Id 5464',999.00,0.00,0.00,1.35,114.75,'2022-07-18 17:15:36','',''),(5450,'1','273','1',1,'Retail Sale Id 5465',49980.00,0.00,0.00,73.50,1837.50,'2022-07-18 17:20:16','',''),(5451,'1','273','1',1,'Retail Sale Id 5466',1998.00,0.00,0.00,2.70,229.50,'2022-07-18 17:21:59','',''),(5452,'1','273','1',1,'Retail Sale Id 5467',1502.20,0.00,0.00,2.03,172.55,'2022-07-18 17:23:22','',''),(5453,'1','273','1',1,'Retail Sale Id 5468',222.00,0.00,0.00,0.30,25.50,'2022-07-18 17:26:33','',''),(5454,'1','273','1',1,'Retail Sale Id 5470',599.40,0.00,0.00,0.81,68.85,'2022-07-18 17:28:47','',''),(5455,'1','273','1',1,'Retail Sale Id 5471',9250.00,0.00,0.00,12.50,1062.50,'2022-07-18 17:35:45','',''),(5456,'1','273','1',1,'Retail Sale Id 5472',7400.00,0.00,0.00,10.00,850.00,'2022-07-18 17:38:51','',''),(5457,'1','273','1',1,'Retail Sale Id 5473',2249.60,0.00,0.00,3.04,258.40,'2022-07-18 17:49:15','',''),(5458,'1','273','1',1,'Retail Sale Id 5474',1502.20,0.00,0.00,2.03,172.55,'2022-07-18 17:50:18','',''),(5459,'1','273','1',1,'Retail Sale Id 5475',4440.00,0.00,0.00,6.00,510.00,'2022-07-18 17:52:51','',''),(5460,'1','273','1',1,'Retail Sale Id 5476',3700.00,0.00,0.00,5.00,425.00,'2022-07-18 17:54:58','',''),(5461,'1','273','1',1,'Retail Sale Id 5477',1502.20,0.00,0.00,2.03,172.55,'2022-07-18 17:56:52','',''),(5462,'1','273','1',1,'Retail Sale Id 5478',747.40,0.00,0.00,1.01,85.85,'2022-07-18 17:57:38','',''),(5463,'1','273','1',1,'Retail Sale Id 5480',2220.00,0.00,0.00,3.00,255.00,'2022-07-18 18:05:26','',''),(5464,'1','273','1',1,'Retail Sale Id 5481',4440.00,0.00,0.00,6.00,510.00,'2022-07-18 18:06:24','',''),(5465,'1','273','1',1,'Retail Sale Id 5482',1480.00,0.00,0.00,2.00,170.00,'2022-07-18 18:07:41','',''),(5466,'1','273','1',1,'Retail Sale Id 5483',2997.00,0.00,0.00,4.05,344.25,'2022-07-19 06:50:04','',''),(5467,'1','273','1',1,'Retail Sale Id 5484',999.00,0.00,0.00,1.35,114.75,'2022-07-19 06:53:42','',''),(5468,'1','273','1',1,'Retail Sale Id 5485',740.00,0.00,0.00,1.00,85.00,'2022-07-19 06:59:12','',''),(5469,'1','273','1',1,'Retail Sale Id 5486',2997.00,0.00,0.00,4.05,344.25,'2022-07-19 07:04:33','',''),(5470,'1','273','1',1,'Retail Sale Id 5486',8998.40,0.00,0.00,12.16,1033.60,'2022-07-19 07:04:33','',''),(5471,'1','273','1',1,'Retail Sale Id 5487',1502.20,0.00,0.00,2.03,172.55,'2022-07-19 07:13:04','',''),(5472,'1','273','1',1,'Retail Sale Id 5488',4003.40,0.00,0.00,5.41,459.85,'2022-07-19 07:26:09','',''),(5473,'1','273','1',1,'Retail Sale Id 5489',72080.00,0.00,0.00,106.00,2650.00,'2022-07-19 07:28:53','',''),(5474,'1','273','1',1,'Retail Sale Id 5490',3700.00,0.00,0.00,5.00,425.00,'2022-07-19 07:31:24','',''),(5475,'1','273','1',1,'Retail Sale Id 5491',2997.00,0.00,0.00,4.05,344.25,'2022-07-19 07:33:04','',''),(5476,'1','273','1',1,'Retail Sale Id 5492',9250.00,0.00,0.00,12.50,1062.50,'2022-07-19 07:34:10','',''),(5477,'1','273','1',1,'Retail Sale Id 5493',2249.60,0.00,0.00,3.04,258.40,'2022-07-19 07:41:33','',''),(5478,'1','273','1',1,'Retail Sale Id 5495',5180.00,0.00,0.00,7.00,595.00,'2022-07-19 07:42:57','',''),(5479,'1','273','1',1,'Retail Sale Id 5497',72080.00,0.00,0.00,106.00,2650.00,'2022-07-19 07:48:35','',''),(5480,'1','273','1',1,'Retail Sale Id 5499',1480.00,0.00,0.00,2.00,170.00,'2022-07-19 07:49:36','',''),(5481,'1','273','1',1,'Retail Sale Id 5499',5920.00,0.00,0.00,8.00,680.00,'2022-07-19 07:49:36','',''),(5482,'1','273','1',1,'Retail Sale Id 5500',2997.00,0.00,0.00,4.05,344.25,'2022-07-19 08:05:07','',''),(5483,'1','273','1',1,'Retail Sale Id 5501',5180.00,0.00,0.00,7.00,595.00,'2022-07-19 08:12:59','',''),(5484,'1','273','1',1,'Retail Sale Id 5502',1998.00,0.00,0.00,2.70,229.50,'2022-07-19 08:14:36','',''),(5485,'1','273','1',1,'Retail Sale Id 5503',747.40,0.00,0.00,1.01,85.85,'2022-07-19 08:15:26','',''),(5486,'1','273','1',1,'Retail Sale Id 5504',7000.40,0.00,0.00,9.46,804.10,'2022-07-19 08:16:13','',''),(5487,'1','273','1',1,'Retail Sale Id 5505',10200.00,0.00,0.00,15.00,375.00,'2022-07-19 08:20:34','',''),(5488,'1','273','1',1,'Retail Sale Id 5506',999.00,0.00,0.00,1.35,114.75,'2022-07-19 08:26:29','',''),(5489,'1','273','1',1,'Retail Sale Id 5507',4003.40,0.00,0.00,5.41,459.85,'2022-07-19 08:32:48','',''),(5490,'1','273','1',1,'Retail Sale Id 5508',68000.00,0.00,0.00,100.00,2500.00,'2022-07-19 08:35:40','',''),(5491,'1','273','1',1,'Retail Sale Id 5509',1998.00,0.00,0.00,2.70,229.50,'2022-07-19 08:40:00','',''),(5492,'1','273','1',1,'Retail Sale Id 5510',79220.00,0.00,0.00,116.50,2912.50,'2022-07-19 08:44:19','',''),(5493,'1','273','1',1,'Retail Sale Id 5511',34000.00,0.00,0.00,50.00,1250.00,'2022-07-19 08:47:46','',''),(5494,'1','273','1',1,'Retail Sale Id 5512',68000.00,0.00,0.00,100.00,2500.00,'2022-07-19 09:29:55','',''),(5495,'1','273','1',1,'Retail Sale Id 5513',68000.00,0.00,0.00,100.00,2500.00,'2022-07-19 09:30:57','',''),(5496,'1','273','1',1,'Retail Sale Id 5514',68000.00,0.00,0.00,100.00,2500.00,'2022-07-19 09:34:53','',''),(5497,'1','273','1',1,'Retail Sale Id 5515',54400.00,0.00,0.00,80.00,2000.00,'2022-07-19 09:35:32','',''),(5498,'1','273','1',1,'Retail Sale Id 5516',9250.00,0.00,0.00,12.50,1062.50,'2022-07-19 09:42:13','',''),(5499,'1','273','1',1,'Retail Sale Id 5517',9250.00,0.00,0.00,12.50,1062.50,'2022-07-19 09:58:15','',''),(5500,'1','273','1',1,'Retail Sale Id 5518',10360.00,0.00,0.00,14.00,1190.00,'2022-07-19 10:06:23','',''),(5501,'1','273','1',1,'Retail Sale Id 5519',2197.80,0.00,0.00,2.97,252.45,'2022-07-19 10:18:13','',''),(5502,'1','273','1',1,'Retail Sale Id 5520',17000.00,0.00,0.00,25.00,625.00,'2022-07-19 10:21:41','',''),(5503,'1','273','1',1,'Retail Sale Id 5521',22440.00,0.00,0.00,33.00,825.00,'2022-07-19 10:27:28','',''),(5504,'1','273','1',1,'Retail Sale Id 5522',9250.00,0.00,0.00,12.50,1062.50,'2022-07-19 11:10:22','',''),(5505,'1','273','1',1,'Retail Sale Id 5523',999.00,0.00,0.00,1.35,114.75,'2022-07-19 11:21:57','',''),(5506,'1','273','1',1,'Retail Sale Id 5524',9250.00,0.00,0.00,12.50,1062.50,'2022-07-19 11:33:21','',''),(5507,'1','273','1',1,'Retail Sale Id 5525',9250.00,0.00,0.00,12.50,1062.50,'2022-07-19 11:53:01','',''),(5508,'1','273','1',1,'Retail Sale Id 5526',1302.40,0.00,0.00,1.76,149.60,'2022-07-19 12:11:52','',''),(5509,'1','273','1',1,'Retail Sale Id 5527',2220.00,0.00,0.00,3.00,255.00,'2022-07-19 12:13:24','',''),(5510,'1','273','1',1,'Retail Sale Id 5528',4440.00,0.00,0.00,6.00,510.00,'2022-07-19 12:15:53','',''),(5511,'1','273','1',1,'Retail Sale Id 5529',2960.00,0.00,0.00,4.00,340.00,'2022-07-19 12:55:16','',''),(5512,'1','273','1',1,'Retail Sale Id 5530',68000.00,0.00,0.00,100.00,2500.00,'2022-07-19 13:12:59','',''),(5513,'1','273','1',1,'Retail Sale Id 5531',32640.00,0.00,0.00,48.00,1200.00,'2022-07-19 13:15:15','',''),(5514,'1','273','1',1,'Retail Sale Id 5532',9250.00,0.00,0.00,12.50,1062.50,'2022-07-19 13:38:03','',''),(5515,'1','273','1',1,'Retail Sale Id 5533',34000.00,0.00,0.00,50.00,1250.00,'2022-07-19 13:40:08','',''),(5516,'1','273','1',1,'Retail Sale Id 5534',2220.00,0.00,0.00,3.00,255.00,'2022-07-19 13:55:45','',''),(5517,'1','273','1',1,'Retail Sale Id 5535',740.00,0.00,0.00,1.00,85.00,'2022-07-19 14:01:39','',''),(5518,'1','273','1',1,'Retail Sale Id 5536',9250.00,0.00,0.00,12.50,1062.50,'2022-07-19 14:11:48','',''),(5519,'1','273','1',1,'Retail Sale Id 5537',1502.20,0.00,0.00,2.03,172.55,'2022-07-19 14:38:29','',''),(5520,'1','273','1',1,'Retail Sale Id 5538',999.00,0.00,0.00,1.35,114.75,'2022-07-19 14:40:30','',''),(5521,'1','273','1',1,'Retail Sale Id 5540',11100.00,0.00,0.00,15.00,1275.00,'2022-07-19 15:02:51','',''),(5522,'1','273','1',1,'Retail Sale Id 5541',1502.20,0.00,0.00,2.03,172.55,'2022-07-19 15:24:00','',''),(5523,'1','273','1',1,'Retail Sale Id 5542',5002.40,0.00,0.00,6.76,574.60,'2022-07-19 15:25:12','',''),(5524,'1','273','1',1,'Retail Sale Id 5543',747.40,0.00,0.00,1.01,85.85,'2022-07-19 15:30:18','',''),(5525,'1','273','1',1,'Retail Sale Id 5544',1198.80,0.00,0.00,1.62,137.70,'2022-07-19 15:37:54','',''),(5526,'1','273','1',1,'Retail Sale Id 5545',999.00,0.00,0.00,1.35,114.75,'2022-07-19 15:39:21','',''),(5527,'1','273','1',1,'Retail Sale Id 5546',4003.40,0.00,0.00,5.41,459.85,'2022-07-19 15:43:52','',''),(5528,'1','273','1',1,'Retail Sale Id 5547',5180.00,0.00,0.00,7.00,595.00,'2022-07-19 15:46:02','',''),(5529,'1','273','1',1,'Retail Sale Id 5548',61200.00,0.00,0.00,90.00,2250.00,'2022-07-19 15:56:27','',''),(5530,'1','273','1',1,'Retail Sale Id 5549',9250.00,0.00,0.00,12.50,1062.50,'2022-07-19 16:02:34','',''),(5531,'1','273','1',1,'Retail Sale Id 5550',1502.20,0.00,0.00,2.03,172.55,'2022-07-19 16:04:52','',''),(5532,'1','273','1',1,'Retail Sale Id 5551',2249.60,0.00,0.00,3.04,258.40,'2022-07-19 16:06:32','',''),(5533,'1','273','1',1,'Retail Sale Id 5552',2220.00,0.00,0.00,3.00,255.00,'2022-07-19 16:16:24','',''),(5534,'1','273','1',1,'Retail Sale Id 5553',2220.00,0.00,0.00,3.00,255.00,'2022-07-19 16:25:41','',''),(5535,'1','273','1',1,'Retail Sale Id 5554',2197.80,0.00,0.00,2.97,252.45,'2022-07-19 16:34:37','',''),(5536,'1','273','1',1,'Retail Sale Id 5555',2997.00,0.00,0.00,4.05,344.25,'2022-07-19 16:35:47','',''),(5537,'1','273','1',1,'Retail Sale Id 5556',1998.00,0.00,0.00,2.70,229.50,'2022-07-19 16:38:04','',''),(5538,'1','273','1',1,'Retail Sale Id 5557',9250.00,0.00,0.00,12.50,1062.50,'2022-07-19 16:51:16','',''),(5539,'1','273','1',1,'Retail Sale Id 5558',2797.20,0.00,0.00,3.78,321.30,'2022-07-19 17:04:34','',''),(5540,'1','273','1',1,'Retail Sale Id 5559',2997.00,0.00,0.00,4.05,344.25,'2022-07-19 17:05:43','',''),(5541,'1','273','1',1,'Retail Sale Id 5560',999.00,0.00,0.00,1.35,114.75,'2022-07-19 17:06:41','',''),(5542,'1','273','1',1,'Retail Sale Id 5561',2249.60,0.00,0.00,3.04,258.40,'2022-07-19 17:11:14','',''),(5543,'1','273','1',1,'Retail Sale Id 5562',747.40,0.00,0.00,1.01,85.85,'2022-07-19 17:12:26','',''),(5544,'1','273','1',1,'Retail Sale Id 5563',747.40,0.00,0.00,1.01,85.85,'2022-07-19 17:14:49','',''),(5545,'1','273','1',1,'Retail Sale Id 5564',7400.00,0.00,0.00,10.00,850.00,'2022-07-19 17:22:32','',''),(5546,'1','273','1',1,'Retail Sale Id 5565',740.00,0.00,0.00,1.00,85.00,'2022-07-19 17:35:12','',''),(5547,'1','273','1',1,'Retail Sale Id 5566',1502.20,0.00,0.00,2.03,172.55,'2022-07-19 17:39:19','',''),(5548,'1','273','1',1,'Retail Sale Id 5567',2220.00,0.00,0.00,3.00,255.00,'2022-07-19 17:45:08','',''),(5549,'1','273','1',1,'Retail Sale Id 5567',8510.00,0.00,0.00,11.50,977.50,'2022-07-19 17:45:08','',''),(5550,'1','273','1',1,'Retail Sale Id 5568',4440.00,0.00,0.00,6.00,510.00,'2022-07-19 18:01:28','',''),(5551,'1','273','1',1,'Retail Sale Id 5569',799.20,0.00,0.00,1.08,91.80,'2022-07-19 18:03:17','',''),(5552,'1','273','1',1,'Retail Sale Id 5570',1302.40,0.00,0.00,1.76,149.60,'2022-07-19 18:13:00','',''),(5553,'1','273','1',1,'Retail Sale Id 5570',1502.20,0.00,0.00,2.03,172.55,'2022-07-19 18:13:00','',''),(5554,'1','273','1',1,'Retail Sale Id 5571',1998.00,0.00,0.00,2.70,229.50,'2022-07-19 18:16:16','',''),(5555,'1','273','1',1,'Retail Sale Id 5572',747.40,0.00,0.00,1.01,85.85,'2022-07-19 18:18:54','',''),(5556,'1','273','1',1,'Retail Sale Id 5573',999.00,0.00,0.00,1.35,114.75,'2022-07-19 18:20:06','',''),(5557,'1','273','1',1,'Retail Sale Id 5575',1502.20,0.00,0.00,2.03,172.55,'2022-07-19 18:21:22','',''),(5558,'1','273','1',1,'Retail Sale Id 5577',3700.00,0.00,0.00,5.00,425.00,'2022-07-19 18:22:37','',''),(5559,'1','273','1',1,'Retail Sale Id 5578',2197.80,0.00,0.00,2.97,252.45,'2022-07-19 18:25:19','',''),(5560,'1','273','1',1,'Retail Sale Id 5580',1502.20,0.00,0.00,2.03,172.55,'2022-07-19 18:27:41','',''),(5561,'1','273','1',1,'Retail Sale Id 5581',473.60,0.00,0.00,0.64,54.40,'2022-07-19 18:41:59','',''),(5562,'1','273','1',1,'Retail Sale Id 5582',68000.00,0.00,0.00,100.00,2500.00,'2022-07-20 06:55:33','',''),(5563,'1','273','1',1,'Retail Sale Id 5584',102000.00,0.00,0.00,150.00,3750.00,'2022-07-20 06:56:44','',''),(5564,'1','273','1',1,'Retail Sale Id 5585',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 06:58:24','',''),(5565,'1','273','1',1,'Retail Sale Id 5586',747.40,0.00,0.00,1.01,85.85,'2022-07-20 07:07:32','',''),(5566,'1','273','1',1,'Retail Sale Id 5587',999.00,0.00,0.00,1.35,114.75,'2022-07-20 07:12:32','',''),(5567,'1','273','1',1,'Retail Sale Id 5588',11100.00,0.00,0.00,15.00,1275.00,'2022-07-20 07:26:57','',''),(5568,'1','273','1',1,'Retail Sale Id 5589',3700.00,0.00,0.00,5.00,425.00,'2022-07-20 07:41:13','',''),(5569,'1','273','1',1,'Retail Sale Id 5590',747.40,0.00,0.00,1.01,85.85,'2022-07-20 07:45:11','',''),(5570,'1','273','1',1,'Retail Sale Id 5591',2997.00,0.00,0.00,4.05,344.25,'2022-07-20 07:46:34','',''),(5571,'1','273','1',1,'Retail Sale Id 5592',1480.00,0.00,0.00,2.00,170.00,'2022-07-20 07:49:15','',''),(5572,'1','273','1',1,'Retail Sale Id 5593',19040.00,0.00,0.00,28.00,700.00,'2022-07-20 07:56:05','',''),(5573,'1','273','1',1,'Retail Sale Id 5594',1480.00,0.00,0.00,2.00,170.00,'2022-07-20 08:14:49','',''),(5574,'1','273','1',1,'Retail Sale Id 5595',999.00,0.00,0.00,1.35,114.75,'2022-07-20 08:15:54','',''),(5575,'1','273','1',1,'Retail Sale Id 5596',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 08:27:03','',''),(5576,'1','273','1',1,'Retail Sale Id 5597',11100.00,0.00,0.00,15.00,1275.00,'2022-07-20 08:32:40','',''),(5577,'1','273','1',1,'Retail Sale Id 5598',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 08:48:49','',''),(5578,'1','273','1',1,'Retail Sale Id 5599',27200.00,0.00,0.00,40.00,1000.00,'2022-07-20 08:50:27','',''),(5579,'1','273','1',1,'Retail Sale Id 5600',3700.00,0.00,0.00,5.00,425.00,'2022-07-20 08:51:41','',''),(5580,'1','273','1',1,'Retail Sale Id 5601',3700.00,0.00,0.00,5.00,425.00,'2022-07-20 08:52:20','',''),(5581,'1','273','1',1,'Retail Sale Id 5602',7999.40,0.00,0.00,10.81,918.85,'2022-07-20 09:07:53','',''),(5582,'1','273','1',1,'Retail Sale Id 5603',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 09:21:00','',''),(5583,'1','273','1',1,'Retail Sale Id 5604',68000.00,0.00,0.00,100.00,2500.00,'2022-07-20 09:34:33','',''),(5584,'1','273','1',1,'Retail Sale Id 5605',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 09:35:20','',''),(5585,'1','273','1',1,'Retail Sale Id 5606',4440.00,0.00,0.00,6.00,510.00,'2022-07-20 09:39:21','',''),(5586,'1','273','1',1,'Retail Sale Id 5607',1746.40,0.00,0.00,2.36,200.60,'2022-07-20 09:41:20','',''),(5587,'1','273','1',1,'Retail Sale Id 5608',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 09:51:48','',''),(5588,'1','273','1',1,'Retail Sale Id 5609',2249.60,0.00,0.00,3.04,258.40,'2022-07-20 09:56:22','',''),(5589,'1','273','1',1,'Retail Sale Id 5610',4499.20,0.00,0.00,6.08,516.80,'2022-07-20 10:00:12','',''),(5590,'1','273','1',1,'Retail Sale Id 5611',747.40,0.00,0.00,1.01,85.85,'2022-07-20 10:01:09','',''),(5591,'1','273','1',1,'Retail Sale Id 5613',8199.20,0.00,0.00,11.08,941.80,'2022-07-20 10:17:16','',''),(5592,'1','273','1',1,'Retail Sale Id 5614',7400.00,0.00,0.00,10.00,850.00,'2022-07-20 10:42:26','',''),(5593,'1','273','1',1,'Retail Sale Id 5614',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 10:42:26','',''),(5594,'1','273','1',1,'Retail Sale Id 5615',999.00,0.00,0.00,1.35,114.75,'2022-07-20 10:46:19','',''),(5595,'1','273','1',1,'Retail Sale Id 5616',13690.00,0.00,0.00,18.50,1572.50,'2022-07-20 11:20:20','',''),(5596,'1','273','1',1,'Retail Sale Id 5617',68000.00,0.00,0.00,100.00,2500.00,'2022-07-20 11:22:07','',''),(5597,'1','273','1',1,'Retail Sale Id 5618',68000.00,0.00,0.00,100.00,2500.00,'2022-07-20 11:23:05','',''),(5598,'1','273','1',1,'Retail Sale Id 5619',2220.00,0.00,0.00,3.00,255.00,'2022-07-20 11:29:05','',''),(5599,'1','273','1',1,'Retail Sale Id 5620',747.40,0.00,0.00,1.01,85.85,'2022-07-20 11:30:24','',''),(5600,'1','273','1',1,'Retail Sale Id 5621',1302.40,0.00,0.00,1.76,149.60,'2022-07-20 11:38:53','',''),(5601,'1','273','1',1,'Retail Sale Id 5622',1502.20,0.00,0.00,2.03,172.55,'2022-07-20 11:40:36','',''),(5602,'1','273','1',1,'Retail Sale Id 5623',747.40,0.00,0.00,1.01,85.85,'2022-07-20 11:49:28','',''),(5603,'1','273','1',1,'Retail Sale Id 5624',5180.00,0.00,0.00,7.00,595.00,'2022-07-20 12:19:27','',''),(5604,'1','273','1',1,'Retail Sale Id 5625',1502.20,0.00,0.00,2.03,172.55,'2022-07-20 12:22:21','',''),(5605,'1','273','1',1,'Retail Sale Id 5626',999.00,0.00,0.00,1.35,114.75,'2022-07-20 12:47:59','',''),(5606,'1','273','1',1,'Retail Sale Id 5627',747.40,0.00,0.00,1.01,85.85,'2022-07-20 12:50:20','',''),(5607,'1','273','1',1,'Retail Sale Id 5628',6001.40,0.00,0.00,8.11,689.35,'2022-07-20 12:52:33','',''),(5608,'1','273','1',1,'Retail Sale Id 5629',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 13:17:13','',''),(5609,'1','273','1',1,'Retail Sale Id 5630',6001.40,0.00,0.00,8.11,689.35,'2022-07-20 13:18:14','',''),(5610,'1','273','1',1,'Retail Sale Id 5631',3700.00,0.00,0.00,5.00,425.00,'2022-07-20 13:19:58','',''),(5611,'1','273','1',1,'Retail Sale Id 5632',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 13:30:43','',''),(5612,'1','273','1',1,'Retail Sale Id 5633',799.20,0.00,0.00,1.08,91.80,'2022-07-20 13:33:01','',''),(5613,'1','273','1',1,'Retail Sale Id 5634',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 13:47:07','',''),(5614,'1','273','1',1,'Retail Sale Id 5635',1502.20,0.00,0.00,2.03,172.55,'2022-07-20 13:53:19','',''),(5615,'1','273','1',1,'Retail Sale Id 5636',5180.00,0.00,0.00,7.00,595.00,'2022-07-20 14:36:38','',''),(5616,'1','273','1',1,'Retail Sale Id 5637',999.00,0.00,0.00,1.35,114.75,'2022-07-20 14:39:46','',''),(5617,'1','273','1',1,'Retail Sale Id 5638',3700.00,0.00,0.00,5.00,425.00,'2022-07-20 14:45:47','',''),(5618,'1','273','1',1,'Retail Sale Id 5639',999.00,0.00,0.00,1.35,114.75,'2022-07-20 14:46:57','',''),(5619,'1','273','1',1,'Retail Sale Id 5640',747.40,0.00,0.00,1.01,85.85,'2022-07-20 14:59:28','',''),(5620,'1','273','1',1,'Retail Sale Id 5641',4447.40,0.00,0.00,6.01,510.85,'2022-07-20 15:00:45','',''),(5621,'1','273','1',1,'Retail Sale Id 5642',999.00,0.00,0.00,1.35,114.75,'2022-07-20 15:33:11','',''),(5622,'1','273','1',1,'Retail Sale Id 5643',3700.00,0.00,0.00,5.00,425.00,'2022-07-20 15:39:18','',''),(5623,'1','273','1',1,'Retail Sale Id 5644',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 15:44:18','',''),(5624,'1','273','1',1,'Retail Sale Id 5645',747.40,0.00,0.00,1.01,85.85,'2022-07-20 15:45:22','',''),(5625,'1','273','1',1,'Retail Sale Id 5646',1502.20,0.00,0.00,2.03,172.55,'2022-07-20 15:48:49','',''),(5626,'1','273','1',1,'Retail Sale Id 5647',8140.00,0.00,0.00,11.00,935.00,'2022-07-20 15:51:08','',''),(5627,'1','273','1',1,'Retail Sale Id 5648',4003.40,0.00,0.00,5.41,459.85,'2022-07-20 15:53:25','',''),(5628,'1','273','1',1,'Retail Sale Id 5649',17000.00,0.00,0.00,25.00,625.00,'2022-07-20 16:09:07','',''),(5629,'1','273','1',1,'Retail Sale Id 5650',1480.00,0.00,0.00,2.00,170.00,'2022-07-20 16:25:13','',''),(5630,'1','273','1',1,'Retail Sale Id 5651',747.40,0.00,0.00,1.01,85.85,'2022-07-20 16:42:11','',''),(5631,'1','273','1',1,'Retail Sale Id 5652',999.00,0.00,0.00,1.35,114.75,'2022-07-20 16:44:02','',''),(5632,'1','273','1',1,'Retail Sale Id 5653',1502.20,0.00,0.00,2.03,172.55,'2022-07-20 16:50:58','',''),(5633,'1','273','1',1,'Retail Sale Id 5655',2960.00,0.00,0.00,4.00,340.00,'2022-07-20 17:03:40','',''),(5634,'1','273','1',1,'Retail Sale Id 5656',4447.40,0.00,0.00,6.01,510.85,'2022-07-20 17:09:39','',''),(5635,'1','273','1',1,'Retail Sale Id 5657',747.40,0.00,0.00,1.01,85.85,'2022-07-20 17:10:36','',''),(5636,'1','273','1',1,'Retail Sale Id 5658',1480.00,0.00,0.00,2.00,170.00,'2022-07-20 17:21:44','',''),(5637,'1','273','1',1,'Retail Sale Id 5659',2997.00,0.00,0.00,4.05,344.25,'2022-07-20 17:32:45','',''),(5638,'1','273','1',1,'Retail Sale Id 5660',740.00,0.00,0.00,1.00,85.00,'2022-07-20 17:33:27','',''),(5639,'1','273','1',1,'Retail Sale Id 5661',999.00,0.00,0.00,1.35,114.75,'2022-07-20 17:36:02','',''),(5640,'1','273','1',1,'Retail Sale Id 5662',9620.00,0.00,0.00,13.00,1105.00,'2022-07-20 17:41:51','',''),(5641,'1','273','1',1,'Retail Sale Id 5663',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 17:48:31','',''),(5642,'1','273','1',1,'Retail Sale Id 5664',9250.00,0.00,0.00,12.50,1062.50,'2022-07-20 17:49:22','',''),(5643,'1','273','1',1,'Retail Sale Id 5665',7400.00,0.00,0.00,10.00,850.00,'2022-07-20 17:50:14','',''),(5644,'1','273','1',1,'Retail Sale Id 5666',2720.00,0.00,0.00,4.00,100.00,'2022-07-20 18:00:19','',''),(5645,'1','273','1',1,'Retail Sale Id 5667',1502.20,0.00,0.00,2.03,172.55,'2022-07-20 18:12:54','',''),(5646,'1','273','1',1,'Retail Sale Id 5668',740.00,0.00,0.00,1.00,85.00,'2022-07-20 18:13:58','',''),(5647,'1','273','1',1,'Retail Sale Id 5669',3700.00,0.00,0.00,5.00,425.00,'2022-07-20 18:20:57','',''),(5648,'1','273','1',1,'Retail Sale Id 5670',1480.00,0.00,0.00,2.00,170.00,'2022-07-20 18:23:47','',''),(5649,'1','273',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,10.00,0.00,'2022-07-20 20:26:51','',''),(5650,'1','273','1',1,'Received from bridging 20',0.00,0.00,10.00,0.00,0.00,'2022-07-20 20:26:51','',''),(5651,'1','273','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,16538.06,0.00,'2022-07-20 21:43:23','',''),(5652,'1','273','1',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-07-20 21:43:23','',''),(5653,'1','273',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,24854.00,0.00,'2022-07-20 21:45:00','',''),(5654,'1','273','1',1,'Received from bridging 21',0.00,0.00,24854.00,0.00,0.00,'2022-07-20 21:45:00','',''),(5655,'1','273','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,24855.00,0.00,'2022-07-20 21:46:07','',''),(5656,'1','273','1',0,'Inventory adjustment from tank dipping to 16528',0.00,0.00,16528.00,0.00,0.00,'2022-07-20 21:46:07','',''),(5657,'1','273',NULL,1,'Inventory reconciliation by HAFIZ NURA  GAYA',0.00,0.00,16528.06,41392.06,0.00,'2022-07-20 21:48:38','',''),(5658,'1','273','1',1,'Retail Sale Id 5671',999.00,0.00,0.00,1.35,114.75,'2022-07-21 06:37:08','',''),(5659,'1','273','1',1,'Retail Sale Id 5672',3500.20,0.00,0.00,4.73,402.05,'2022-07-21 06:54:52','',''),(5660,'1','273','1',1,'Retail Sale Id 5673',2220.00,0.00,0.00,3.00,255.00,'2022-07-21 06:55:39','',''),(5661,'1','273','1',1,'Retail Sale Id 5674',30600.00,0.00,0.00,45.00,1125.00,'2022-07-21 07:00:03','',''),(5662,'1','273','1',1,'Retail Sale Id 5675',102000.00,0.00,0.00,150.00,3750.00,'2022-07-21 07:04:38','',''),(5663,'1','273','1',1,'Retail Sale Id 5676',68000.00,0.00,0.00,100.00,2500.00,'2022-07-21 07:05:14','',''),(5664,'1','273','1',1,'Retail Sale Id 5677',4440.00,0.00,0.00,6.00,510.00,'2022-07-21 07:27:02','',''),(5665,'1','273','1',1,'Retail Sale Id 5678',34000.00,0.00,0.00,50.00,1250.00,'2022-07-21 07:32:01','',''),(5666,'1','273','1',1,'Retail Sale Id 5679',999.00,0.00,0.00,1.35,114.75,'2022-07-21 07:40:04','',''),(5667,'1','273','1',1,'Retail Sale Id 5680',1998.00,0.00,0.00,2.70,229.50,'2022-07-21 07:45:46','',''),(5668,'1','273','1',1,'Retail Sale Id 5681',1998.00,0.00,0.00,2.70,229.50,'2022-07-21 07:51:44','',''),(5669,'1','273','1',1,'Retail Sale Id 5681',2220.00,0.00,0.00,3.00,255.00,'2022-07-21 07:51:44','',''),(5670,'1','273','1',1,'Retail Sale Id 5681',9250.00,0.00,0.00,12.50,1062.50,'2022-07-21 07:51:44','',''),(5671,'1','273','1',1,'Retail Sale Id 5682',2197.80,0.00,0.00,2.97,252.45,'2022-07-21 07:52:56','',''),(5672,'1','273','1',1,'Retail Sale Id 5685',3700.00,0.00,0.00,5.00,425.00,'2022-07-21 07:55:03','',''),(5673,'1','273','1',1,'Retail Sale Id 5686',7920.00,0.00,0.00,11.00,715.00,'2022-07-21 08:13:39','',''),(5674,'1','273','1',1,'Retail Sale Id 5687',2001.60,0.00,0.00,2.78,180.70,'2022-07-21 08:14:32','',''),(5675,'1','273','1',1,'Retail Sale Id 5688',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 08:19:24','',''),(5676,'1','273','1',1,'Retail Sale Id 5689',1440.00,0.00,0.00,2.00,130.00,'2022-07-21 08:26:53','',''),(5677,'1','273','1',1,'Retail Sale Id 5690',2498.40,0.00,0.00,3.47,225.55,'2022-07-21 08:28:02','',''),(5678,'1','273','1',1,'Retail Sale Id 5691',1497.60,0.00,0.00,2.08,135.20,'2022-07-21 08:29:42','',''),(5679,'1','273','1',1,'Retail Sale Id 5692',2880.00,0.00,0.00,4.00,260.00,'2022-07-21 08:32:19','',''),(5680,'1','273','1',1,'Retail Sale Id 5693',60300.00,0.00,0.00,90.00,1350.00,'2022-07-21 08:38:33','',''),(5681,'1','273','1',1,'Retail Sale Id 5694',1497.60,0.00,0.00,2.08,135.20,'2022-07-21 08:44:03','',''),(5682,'1','273','1',1,'Retail Sale Id 5695',748.80,0.00,0.00,1.04,67.60,'2022-07-21 08:57:45','',''),(5683,'1','273','1',1,'Retail Sale Id 5696',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 09:06:25','',''),(5684,'1','273','1',1,'Retail Sale Id 5697',4003.20,0.00,0.00,5.56,361.40,'2022-07-21 09:15:47','',''),(5685,'1','273','1',1,'Retail Sale Id 5698',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 09:23:11','',''),(5686,'1','273','1',1,'Retail Sale Id 5699',1440.00,0.00,0.00,2.00,130.00,'2022-07-21 09:27:40','',''),(5687,'1','273','1',1,'Retail Sale Id 5700',4320.00,0.00,0.00,6.00,390.00,'2022-07-21 09:32:39','',''),(5688,'1','273','1',1,'Retail Sale Id 5701',748.80,0.00,0.00,1.04,67.60,'2022-07-21 10:22:23','',''),(5689,'1','273','1',1,'Retail Sale Id 5702',7200.00,0.00,0.00,10.00,650.00,'2022-07-21 10:30:17','',''),(5690,'1','273','1',1,'Retail Sale Id 5702',18000.00,0.00,0.00,25.00,1625.00,'2022-07-21 10:30:17','',''),(5691,'1','273','1',1,'Retail Sale Id 5703',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 10:51:57','',''),(5692,'1','273','1',1,'Retail Sale Id 5704',3600.00,0.00,0.00,5.00,325.00,'2022-07-21 10:54:52','',''),(5693,'1','273','1',1,'Retail Sale Id 5705',748.80,0.00,0.00,1.04,67.60,'2022-07-21 10:58:32','',''),(5694,'1','273','1',1,'Retail Sale Id 5706',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 11:08:55','',''),(5695,'1','273','1',1,'Retail Sale Id 5707',1502.20,0.00,0.00,2.03,172.55,'2022-07-21 11:14:17','',''),(5696,'1','273','1',1,'Retail Sale Id 5708',8998.40,0.00,0.00,12.16,1033.60,'2022-07-21 11:16:15','',''),(5697,'1','273','1',1,'Return of Retail Sale Id 5707',0.00,1502.20,2.03,0.00,-172.55,'2022-07-21 11:19:59','',''),(5698,'1','273','1',1,'Return of Retail Sale Id 5708',0.00,8998.40,12.16,0.00,-1033.60,'2022-07-21 11:21:14','',''),(5699,'1','273','1',1,'Retail Sale Id 5709',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 11:21:43','',''),(5700,'1','273','1',1,'Retail Sale Id 5710',1497.60,0.00,0.00,2.08,135.20,'2022-07-21 11:23:26','',''),(5701,'1','273','1',1,'Retail Sale Id 5711',4996.80,0.00,0.00,6.94,451.10,'2022-07-21 11:25:19','',''),(5702,'1','273','1',1,'Retail Sale Id 5712',16750.00,0.00,0.00,25.00,375.00,'2022-07-21 11:37:42','',''),(5703,'1','273','1',1,'Retail Sale Id 5713',3600.00,0.00,0.00,5.00,325.00,'2022-07-21 12:00:55','',''),(5704,'1','273','1',1,'Retail Sale Id 5714',10050.00,0.00,0.00,15.00,225.00,'2022-07-21 12:07:06','',''),(5705,'1','273','1',1,'Retail Sale Id 5715',32160.00,0.00,0.00,48.00,720.00,'2022-07-21 12:13:00','',''),(5706,'1','273','1',1,'Retail Sale Id 5716',3002.40,0.00,0.00,4.17,271.05,'2022-07-21 12:15:54','',''),(5707,'1','273','1',1,'Retail Sale Id 5717',67000.00,0.00,0.00,100.00,1500.00,'2022-07-21 12:24:36','',''),(5708,'1','273','1',1,'Retail Sale Id 5718',1000.80,0.00,0.00,1.39,90.35,'2022-07-21 12:25:40','',''),(5709,'1','273','1',1,'Retail Sale Id 5719',2253.60,0.00,0.00,3.13,203.45,'2022-07-21 12:26:28','',''),(5710,'1','273','1',1,'Retail Sale Id 5720',33500.00,0.00,0.00,50.00,750.00,'2022-07-21 12:27:21','',''),(5711,'1','273','1',1,'Retail Sale Id 5721',6700.00,0.00,0.00,10.00,150.00,'2022-07-21 12:30:06','',''),(5712,'1','273','1',1,'Retail Sale Id 5722',7200.00,0.00,0.00,10.00,650.00,'2022-07-21 12:31:25','',''),(5713,'1','273','1',1,'Retail Sale Id 5723',24790.00,0.00,0.00,37.00,555.00,'2022-07-21 12:33:35','',''),(5714,'1','273','1',1,'Retail Sale Id 5724',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 12:34:22','',''),(5715,'1','273','1',1,'Retail Sale Id 5725',16750.00,0.00,0.00,25.00,375.00,'2022-07-21 12:50:41','',''),(5716,'1','273','1',1,'Retail Sale Id 5726',20100.00,0.00,0.00,30.00,450.00,'2022-07-21 13:13:40','',''),(5717,'1','273','1',1,'Retail Sale Id 5727',3902.40,0.00,0.00,5.42,352.30,'2022-07-21 13:26:01','',''),(5718,'1','273','1',1,'Retail Sale Id 5728',1440.00,0.00,0.00,2.00,130.00,'2022-07-21 14:08:50','',''),(5719,'1','273','1',1,'Retail Sale Id 5729',9496.80,0.00,0.00,13.19,857.35,'2022-07-21 14:18:16','',''),(5720,'1','273','1',1,'Retail Sale Id 5730',1000.80,0.00,0.00,1.39,90.35,'2022-07-21 14:19:02','',''),(5721,'1','273','1',1,'Retail Sale Id 5731',38860.00,0.00,0.00,58.00,870.00,'2022-07-21 14:21:30','',''),(5722,'1','273','1',1,'Retail Sale Id 5732',40200.00,0.00,0.00,60.00,900.00,'2022-07-21 14:22:44','',''),(5723,'1','273','1',1,'Retail Sale Id 5733',3001.60,0.00,0.00,4.48,67.20,'2022-07-21 14:25:10','',''),(5724,'1','273','1',1,'Retail Sale Id 5734',720.00,0.00,0.00,1.00,65.00,'2022-07-21 14:27:00','',''),(5725,'1','273','1',1,'Retail Sale Id 5735',67000.00,0.00,0.00,100.00,1500.00,'2022-07-21 14:44:11','',''),(5726,'1','273','1',1,'Retail Sale Id 5736',67000.00,0.00,0.00,100.00,1500.00,'2022-07-21 14:44:53','',''),(5727,'1','273','1',1,'Retail Sale Id 5737',1440.00,0.00,0.00,2.00,130.00,'2022-07-21 15:00:29','',''),(5728,'1','273','1',1,'Retail Sale Id 5738',3600.00,0.00,0.00,5.00,325.00,'2022-07-21 15:01:58','',''),(5729,'1','273','1',1,'Retail Sale Id 5739',1440.00,0.00,0.00,2.00,130.00,'2022-07-21 15:09:40','',''),(5730,'1','273','1',1,'Retail Sale Id 5740',1447.20,0.00,0.00,2.01,130.65,'2022-07-21 15:11:20','',''),(5731,'1','273','1',1,'Retail Sale Id 5741',2160.00,0.00,0.00,3.00,195.00,'2022-07-21 15:13:32','',''),(5732,'1','273','1',1,'Retail Sale Id 5742',2160.00,0.00,0.00,3.00,195.00,'2022-07-21 15:17:48','',''),(5733,'1','273','1',1,'Retail Sale Id 5743',1447.20,0.00,0.00,2.01,130.65,'2022-07-21 15:28:55','',''),(5734,'1','273','1',1,'Retail Sale Id 5744',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 15:40:08','',''),(5735,'1','273','1',1,'Retail Sale Id 5745',28800.00,0.00,0.00,40.00,2600.00,'2022-07-21 15:42:16','',''),(5736,'1','273','1',1,'Retail Sale Id 5746',3600.00,0.00,0.00,5.00,325.00,'2022-07-21 15:43:01','',''),(5737,'1','273','1',1,'Retail Sale Id 5747',40200.00,0.00,0.00,60.00,900.00,'2022-07-21 15:47:12','',''),(5738,'1','273','1',1,'Retail Sale Id 5748',720.00,0.00,0.00,1.00,65.00,'2022-07-21 15:49:33','',''),(5739,'1','273','1',1,'Retail Sale Id 5749',8280.00,0.00,0.00,11.50,747.50,'2022-07-21 15:52:21','',''),(5740,'1','273','1',1,'Retail Sale Id 5750',8640.00,0.00,0.00,12.00,780.00,'2022-07-21 15:55:08','',''),(5741,'1','273','1',1,'Retail Sale Id 5751',1000.80,0.00,0.00,1.39,90.35,'2022-07-21 16:00:26','',''),(5742,'1','273','1',1,'Retail Sale Id 5752',1447.20,0.00,0.00,2.01,130.65,'2022-07-21 16:01:33','',''),(5743,'1','273','1',1,'Retail Sale Id 5753',2160.00,0.00,0.00,3.00,195.00,'2022-07-21 16:12:36','',''),(5744,'1','273','1',1,'Retail Sale Id 5755',2203.20,0.00,0.00,3.06,198.90,'2022-07-21 16:13:59','',''),(5745,'1','273','1',1,'Retail Sale Id 5756',67000.00,0.00,0.00,100.00,1500.00,'2022-07-21 16:14:59','',''),(5746,'1','273','1',1,'Retail Sale Id 5757',33500.00,0.00,0.00,50.00,750.00,'2022-07-21 16:16:04','',''),(5747,'1','273','1',1,'Retail Sale Id 5758',1497.60,0.00,0.00,2.08,135.20,'2022-07-21 16:19:34','',''),(5748,'1','273','1',1,'Retail Sale Id 5759',1000.80,0.00,0.00,1.39,90.35,'2022-07-21 16:20:47','',''),(5749,'1','273','1',1,'Retail Sale Id 5760',1497.60,0.00,0.00,2.08,135.20,'2022-07-21 16:27:58','',''),(5750,'1','273','1',1,'Retail Sale Id 5762',1000.80,0.00,0.00,1.39,90.35,'2022-07-21 16:46:05','',''),(5751,'1','273','1',1,'Retail Sale Id 5763',1497.60,0.00,0.00,2.08,135.20,'2022-07-21 16:46:59','',''),(5752,'1','273','1',1,'Retail Sale Id 5764',2880.00,0.00,0.00,4.00,260.00,'2022-07-21 16:48:38','',''),(5753,'1','273','1',1,'Retail Sale Id 5765',2203.20,0.00,0.00,3.06,198.90,'2022-07-21 16:56:36','',''),(5754,'1','273','1',1,'Retail Sale Id 5766',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 17:00:47','',''),(5755,'1','273','1',1,'Retail Sale Id 5768',2203.20,0.00,0.00,3.06,198.90,'2022-07-21 17:04:53','',''),(5756,'1','273','1',1,'Retail Sale Id 5769',1000.80,0.00,0.00,1.39,90.35,'2022-07-21 17:05:51','',''),(5757,'1','273','1',1,'Retail Sale Id 5770',799.20,0.00,0.00,1.11,72.15,'2022-07-21 17:11:20','',''),(5758,'1','273','1',1,'Retail Sale Id 5771',4348.80,0.00,0.00,6.04,392.60,'2022-07-21 17:13:11','',''),(5759,'1','273','1',1,'Retail Sale Id 5772',720.00,0.00,0.00,1.00,65.00,'2022-07-21 17:19:06','',''),(5760,'1','273','1',1,'Retail Sale Id 5773',720.00,0.00,0.00,1.00,65.00,'2022-07-21 17:21:19','',''),(5761,'1','273','1',1,'Retail Sale Id 5774',1000.80,0.00,0.00,1.39,90.35,'2022-07-21 17:25:46','',''),(5762,'1','273','1',1,'Retail Sale Id 5775',748.80,0.00,0.00,1.04,67.60,'2022-07-21 17:27:41','',''),(5763,'1','273','1',1,'Retail Sale Id 5776',36180.00,0.00,0.00,54.00,810.00,'2022-07-21 17:35:34','',''),(5764,'1','273','1',1,'Retail Sale Id 5777',1497.60,0.00,0.00,2.08,135.20,'2022-07-21 17:40:40','',''),(5765,'1','273','1',1,'Retail Sale Id 5778',2160.00,0.00,0.00,3.00,195.00,'2022-07-21 17:44:38','',''),(5766,'1','273','1',1,'Retail Sale Id 5779',1440.00,0.00,0.00,2.00,130.00,'2022-07-21 17:46:26','',''),(5767,'1','273','1',1,'Retail Sale Id 5780',2001.60,0.00,0.00,2.78,180.70,'2022-07-21 17:47:24','',''),(5768,'1','273','1',1,'Retail Sale Id 5781',3600.00,0.00,0.00,5.00,325.00,'2022-07-21 17:53:40','',''),(5769,'1','273','1',1,'Retail Sale Id 5782',7560.00,0.00,0.00,10.50,682.50,'2022-07-21 17:57:43','',''),(5770,'1','273','1',1,'Retail Sale Id 5783',1440.00,0.00,0.00,2.00,130.00,'2022-07-21 18:02:46','',''),(5771,'1','273','1',1,'Retail Sale Id 5784',4320.00,0.00,0.00,6.00,390.00,'2022-07-21 18:05:12','',''),(5772,'1','273','1',1,'Retail Sale Id 5784',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 18:05:12','',''),(5773,'1','273','1',1,'Retail Sale Id 5785',9000.00,0.00,0.00,12.50,812.50,'2022-07-21 18:06:27','',''),(5774,'1','273','1',1,'Retail Sale Id 5786',799.20,0.00,0.00,1.11,72.15,'2022-07-21 18:07:09','',''),(5775,'1','273','1',1,'Retail Sale Id 5787',2160.00,0.00,0.00,3.00,195.00,'2022-07-21 18:12:11','',''),(5776,'1','273','1',1,'Retail Sale Id 5788',1000.80,0.00,0.00,1.39,90.35,'2022-07-21 18:15:30','',''),(5777,'1','273','1',1,'Retail Sale Id 5789',799.20,0.00,0.00,1.11,72.15,'2022-07-21 18:18:32','',''),(5778,'1','273','1',1,'Return of Retail Sale Id 5674',0.00,30600.00,45.00,0.00,-1125.00,'2022-07-21 18:59:44','',''),(5779,'1','273','1',1,'Return of Retail Sale Id 5675',0.00,102000.00,150.00,0.00,-3750.00,'2022-07-21 19:01:25','',''),(5780,'1','273','1',1,'Return of Retail Sale Id 5676',0.00,68000.00,100.00,0.00,-2500.00,'2022-07-21 19:08:54','',''),(5781,'1','273','1',1,'Return of Retail Sale Id 5678',0.00,34000.00,50.00,0.00,-1250.00,'2022-07-21 19:10:15','',''),(5782,'1','273','1',1,'Retail Sale Id 5790',231150.00,0.00,0.00,345.00,5175.00,'2022-07-21 19:12:25','',''),(5783,'1','273','1',1,'Return of Retail Sale Id 5731',0.00,38860.00,58.00,0.00,-870.00,'2022-07-21 19:16:22','',''),(5784,'1','273','1',1,'Retail Sale Id 5791',10485.50,0.00,0.00,15.65,234.75,'2022-07-21 19:17:13','',''),(5785,'1','273','1',1,'Retail Sale Id 5792',29347.20,0.00,0.00,40.76,2649.40,'2022-07-21 19:20:03','',''),(5786,'1','273','1',1,'Retail Sale Id 5793',720.00,0.00,0.00,1.00,65.00,'2022-07-22 06:38:56','',''),(5787,'1','273','1',1,'Retail Sale Id 5794',76380.00,0.00,0.00,114.00,1710.00,'2022-07-22 07:08:17','',''),(5788,'1','273','1',1,'Retail Sale Id 5795',78390.00,0.00,0.00,117.00,1755.00,'2022-07-22 07:09:04','',''),(5789,'1','273','1',1,'Retail Sale Id 5796',2001.60,0.00,0.00,2.78,180.70,'2022-07-22 07:12:04','',''),(5790,'1','273','1',1,'Retail Sale Id 5797',8640.00,0.00,0.00,12.00,780.00,'2022-07-22 07:14:34','',''),(5791,'1','273','1',1,'Retail Sale Id 5798',748.80,0.00,0.00,1.04,67.60,'2022-07-22 07:15:30','',''),(5792,'1','273','1',1,'Retail Sale Id 5799',38860.00,0.00,0.00,58.00,870.00,'2022-07-22 07:20:01','',''),(5793,'1','273','1',1,'Retail Sale Id 5800',77720.00,0.00,0.00,116.00,1740.00,'2022-07-22 07:20:51','',''),(5794,'1','273','1',1,'Retail Sale Id 5801',9000.00,0.00,0.00,12.50,812.50,'2022-07-22 07:25:36','',''),(5795,'1','273','1',1,'Retail Sale Id 5802',748.80,0.00,0.00,1.04,67.60,'2022-07-22 07:30:03','',''),(5796,'1','273','1',1,'Retail Sale Id 5803',3600.00,0.00,0.00,5.00,325.00,'2022-07-22 07:31:06','',''),(5797,'1','273','1',1,'Retail Sale Id 5804',1497.60,0.00,0.00,2.08,135.20,'2022-07-22 07:38:42','',''),(5798,'1','273','1',1,'Retail Sale Id 5805',1497.60,0.00,0.00,2.08,135.20,'2022-07-22 07:39:22','',''),(5799,'1','273','1',1,'Retail Sale Id 5806',799.20,0.00,0.00,1.11,72.15,'2022-07-22 07:39:56','',''),(5800,'1','273','1',1,'Retail Sale Id 5807',7200.00,0.00,0.00,10.00,650.00,'2022-07-22 07:40:28','',''),(5801,'1','273','1',1,'Retail Sale Id 5808',40200.00,0.00,0.00,60.00,900.00,'2022-07-22 07:43:09','',''),(5802,'1','273','1',1,'Retail Sale Id 5809',80400.00,0.00,0.00,120.00,1800.00,'2022-07-22 07:44:25','',''),(5803,'1','273','1',1,'Retail Sale Id 5810',8640.00,0.00,0.00,12.00,780.00,'2022-07-22 07:45:03','',''),(5804,'1','273','1',1,'Retail Sale Id 5811',3002.40,0.00,0.00,4.17,271.05,'2022-07-22 07:45:42','',''),(5805,'1','273','1',1,'Retail Sale Id 5812',37520.00,0.00,0.00,56.00,840.00,'2022-07-22 07:47:23','',''),(5806,'1','273','1',1,'Retail Sale Id 5815',2001.60,0.00,0.00,2.78,180.70,'2022-07-22 07:52:25','',''),(5807,'1','273','1',1,'Retail Sale Id 5816',67000.00,0.00,0.00,100.00,1500.00,'2022-07-22 07:58:15','',''),(5808,'1','273','1',1,'Retail Sale Id 5817',3002.40,0.00,0.00,4.17,271.05,'2022-07-22 08:00:05','',''),(5809,'1','273','1',1,'Retail Sale Id 5818',1000.80,0.00,0.00,1.39,90.35,'2022-07-22 08:03:55','',''),(5810,'1','273','1',1,'Retail Sale Id 5819',3600.00,0.00,0.00,5.00,325.00,'2022-07-22 08:04:28','',''),(5811,'1','273','1',1,'Retail Sale Id 5820',8375.00,0.00,0.00,12.50,187.50,'2022-07-22 08:09:37','',''),(5812,'1','273','1',1,'Retail Sale Id 5821',2001.60,0.00,0.00,2.78,180.70,'2022-07-22 08:11:02','',''),(5813,'1','273','1',1,'Retail Sale Id 5822',8375.00,0.00,0.00,12.50,187.50,'2022-07-22 08:16:00','',''),(5814,'1','273','1',1,'Retail Sale Id 5823',67000.00,0.00,0.00,100.00,1500.00,'2022-07-22 08:30:44','',''),(5815,'1','273','1',1,'Retail Sale Id 5824',33500.00,0.00,0.00,50.00,750.00,'2022-07-22 08:33:27','',''),(5816,'1','273','1',1,'Retail Sale Id 5825',7920.00,0.00,0.00,11.00,715.00,'2022-07-22 08:36:19','',''),(5817,'1','273','1',1,'Retail Sale Id 5827',7200.00,0.00,0.00,10.00,650.00,'2022-07-22 08:48:23','',''),(5818,'1','273','1',1,'Retail Sale Id 5828',233830.00,0.00,0.00,349.00,5235.00,'2022-07-22 09:08:13','',''),(5819,'1','273','1',1,'Retail Sale Id 5829',160800.00,0.00,0.00,240.00,3600.00,'2022-07-22 09:09:05','',''),(5820,'1','273','1',1,'Retail Sale Id 5830',7200.00,0.00,0.00,10.00,650.00,'2022-07-22 09:23:12','',''),(5821,'1','273','1',1,'Retail Sale Id 5830',9000.00,0.00,0.00,12.50,812.50,'2022-07-22 09:23:12','',''),(5822,'1','273','1',1,'Retail Sale Id 5831',4320.00,0.00,0.00,6.00,390.00,'2022-07-22 09:25:10','',''),(5823,'1','273','1',1,'Retail Sale Id 5832',2880.00,0.00,0.00,4.00,260.00,'2022-07-22 09:26:54','',''),(5824,'1','273','1',1,'Retail Sale Id 5833',2880.00,0.00,0.00,4.00,260.00,'2022-07-22 09:28:47','',''),(5825,'1','273','1',1,'Retail Sale Id 5834',720.00,0.00,0.00,1.00,65.00,'2022-07-22 10:06:54','',''),(5826,'1','273','1',1,'Retail Sale Id 5836',2203.20,0.00,0.00,3.06,198.90,'2022-07-22 10:09:26','',''),(5827,'1','273','1',1,'Retail Sale Id 5837',9000.00,0.00,0.00,12.50,812.50,'2022-07-22 10:22:56','',''),(5828,'1','273','1',1,'Retail Sale Id 5838',81740.00,0.00,0.00,122.00,1830.00,'2022-07-22 10:28:04','',''),(5829,'1','273','1',1,'Retail Sale Id 5839',33500.00,0.00,0.00,50.00,750.00,'2022-07-22 10:29:24','',''),(5830,'1','273','1',1,'Retail Sale Id 5841',1440.00,0.00,0.00,2.00,130.00,'2022-07-22 10:32:34','',''),(5831,'1','273','1',1,'Retail Sale Id 5844',1440.00,0.00,0.00,2.00,130.00,'2022-07-22 10:36:13','',''),(5832,'1','273','1',1,'Retail Sale Id 5845',9000.00,0.00,0.00,12.50,812.50,'2022-07-22 10:47:50','',''),(5833,'1','273','1',1,'Retail Sale Id 5846',5040.00,0.00,0.00,7.00,455.00,'2022-07-22 10:51:32','',''),(5834,'1','273','1',1,'Retail Sale Id 5847',8640.00,0.00,0.00,12.00,780.00,'2022-07-22 10:53:14','',''),(5835,'1','273','1',1,'Retail Sale Id 5848',1440.00,0.00,0.00,2.00,130.00,'2022-07-22 10:59:04','',''),(5836,'1','273','1',1,'Retail Sale Id 5849',1440.00,0.00,0.00,2.00,130.00,'2022-07-22 11:23:26','',''),(5837,'1','273','1',1,'Retail Sale Id 5850',3600.00,0.00,0.00,5.00,325.00,'2022-07-22 11:25:26','',''),(5838,'1','273','1',1,'Retail Sale Id 5851',720.00,0.00,0.00,1.00,65.00,'2022-07-22 11:27:19','',''),(5839,'1','273','1',1,'Retail Sale Id 5852',50250.00,0.00,0.00,75.00,1125.00,'2022-07-22 11:30:43','',''),(5840,'1','273','1',1,'Retail Sale Id 5853',2880.00,0.00,0.00,4.00,260.00,'2022-07-22 11:55:59','',''),(5841,'1','273','1',1,'Retail Sale Id 5854',9000.00,0.00,0.00,12.50,812.50,'2022-07-22 12:02:09','',''),(5842,'1','273','1',1,'Retail Sale Id 5855',8640.00,0.00,0.00,12.00,780.00,'2022-07-22 12:05:22','',''),(5843,'1','273','1',1,'Retail Sale Id 5856',9000.00,0.00,0.00,12.50,812.50,'2022-07-22 12:06:36','',''),(5844,'1','273','1',1,'Retail Sale Id 5857',100500.00,0.00,0.00,150.00,2250.00,'2022-07-22 12:11:29','',''),(5845,'1','273','1',1,'Retail Sale Id 5858',100500.00,0.00,0.00,150.00,2250.00,'2022-07-22 12:12:31','',''),(5846,'1','273','1',1,'Retail Sale Id 5859',11160.00,0.00,0.00,15.50,1007.50,'2022-07-22 12:17:03','',''),(5847,'1','273','1',1,'Retail Sale Id 5860',720.00,0.00,0.00,1.00,65.00,'2022-07-22 12:26:16','',''),(5848,'1','273','1',1,'Retail Sale Id 5861',3600.00,0.00,0.00,5.00,325.00,'2022-07-22 12:49:52','',''),(5849,'1','273','1',1,'Retail Sale Id 5862',6480.00,0.00,0.00,9.00,585.00,'2022-07-22 13:16:21','',''),(5850,'1','273','1',1,'Retail Sale Id 5863',67000.00,0.00,0.00,100.00,1500.00,'2022-07-22 13:21:30','',''),(5851,'1','273','1',1,'Retail Sale Id 5864',33500.00,0.00,0.00,50.00,750.00,'2022-07-22 13:22:13','',''),(5852,'1','273','1',1,'Retail Sale Id 5865',9000.00,0.00,0.00,12.50,812.50,'2022-07-22 13:37:38','',''),(5853,'1','273','1',1,'Retail Sale Id 5866',5040.00,0.00,0.00,7.00,455.00,'2022-07-22 13:47:08','',''),(5854,'1','273','1',1,'Retail Sale Id 5867',40200.00,0.00,0.00,60.00,900.00,'2022-07-22 13:50:08','',''),(5855,'1','273','1',1,'Retail Sale Id 5868',112560.00,0.00,0.00,168.00,2520.00,'2022-07-22 14:47:15','',''),(5856,'1','273','1',1,'Retail Sale Id 5869',5040.00,0.00,0.00,7.00,455.00,'2022-07-22 14:48:31','',''),(5857,'1','273','1',1,'Retail Sale Id 5870',9000.00,0.00,0.00,12.50,812.50,'2022-07-22 14:56:34','',''),(5858,'1','273','1',1,'Retail Sale Id 5871',1497.60,0.00,0.00,2.08,135.20,'2022-07-22 15:01:41','',''),(5859,'1','273','1',1,'Retail Sale Id 5872',60501.00,0.00,0.00,90.30,1354.50,'2022-07-22 15:34:56','',''),(5860,'1','273','1',1,'Retail Sale Id 5873',16080.00,0.00,0.00,24.00,360.00,'2022-07-22 15:38:48','',''),(5861,'1','273','1',1,'Retail Sale Id 5874',100500.00,0.00,0.00,150.00,2250.00,'2022-07-22 15:42:43','',''),(5862,'1','273','1',1,'Retail Sale Id 5875',67000.00,0.00,0.00,100.00,1500.00,'2022-07-22 15:44:24','',''),(5863,'1','273','1',1,'Retail Sale Id 5876',8640.00,0.00,0.00,12.00,780.00,'2022-07-22 15:45:56','',''),(5864,'1','273','1',1,'Retail Sale Id 5877',720.00,0.00,0.00,1.00,65.00,'2022-07-22 15:51:21','',''),(5865,'1','273','1',1,'Retail Sale Id 5878',3600.00,0.00,0.00,5.00,325.00,'2022-07-22 15:52:24','',''),(5866,'1','273','1',1,'Retail Sale Id 5879',4003.20,0.00,0.00,5.56,361.40,'2022-07-22 16:14:20','',''),(5867,'1','273','1',1,'Retail Sale Id 5880',1497.60,0.00,0.00,2.08,135.20,'2022-07-22 16:21:12','',''),(5868,'1','273','1',1,'Retail Sale Id 5881',1000.80,0.00,0.00,1.39,90.35,'2022-07-22 16:31:05','',''),(5869,'1','273','1',1,'Retail Sale Id 5882',727.20,0.00,0.00,1.01,65.65,'2022-07-22 16:38:10','',''),(5870,'1','273','1',1,'Retail Sale Id 5883',2001.60,0.00,0.00,2.78,180.70,'2022-07-22 16:41:21','',''),(5871,'1','273','1',1,'Retail Sale Id 5884',799.20,0.00,0.00,1.11,72.15,'2022-07-22 16:52:12','',''),(5872,'1','273','1',1,'Retail Sale Id 5885',720.00,0.00,0.00,1.00,65.00,'2022-07-22 16:58:35','',''),(5873,'1','273','1',1,'Retail Sale Id 5886',720.00,0.00,0.00,1.00,65.00,'2022-07-22 17:02:15','',''),(5874,'1','273','1',1,'Retail Sale Id 5887',54270.00,0.00,0.00,81.00,1215.00,'2022-07-22 17:07:06','',''),(5875,'1','273','1',1,'Retail Sale Id 5888',1440.00,0.00,0.00,2.00,130.00,'2022-07-22 17:12:03','',''),(5876,'1','273','1',1,'Retail Sale Id 5889',799.20,0.00,0.00,1.11,72.15,'2022-07-22 17:18:49','',''),(5877,'1','273','1',1,'Retail Sale Id 5890',10800.00,0.00,0.00,15.00,975.00,'2022-07-22 17:27:50','',''),(5878,'1','273','1',1,'Retail Sale Id 5891',2160.00,0.00,0.00,3.00,195.00,'2022-07-22 17:28:30','',''),(5879,'1','273','1',1,'Retail Sale Id 5892',2160.00,0.00,0.00,3.00,195.00,'2022-07-22 17:30:43','',''),(5880,'1','273','1',1,'Retail Sale Id 5893',1440.00,0.00,0.00,2.00,130.00,'2022-07-22 17:35:12','',''),(5881,'1','273','1',1,'Retail Sale Id 5894',1440.00,0.00,0.00,2.00,130.00,'2022-07-22 17:36:33','',''),(5882,'1','273','1',1,'Retail Sale Id 5895',1303.20,0.00,0.00,1.81,117.65,'2022-07-22 17:37:40','',''),(5883,'1','273','1',1,'Retail Sale Id 5896',40200.00,0.00,0.00,60.00,900.00,'2022-07-22 17:40:22','',''),(5884,'1','273','1',1,'Retail Sale Id 5897',80400.00,0.00,0.00,120.00,1800.00,'2022-07-22 17:41:24','',''),(5885,'1','273','1',1,'Retail Sale Id 5898',748.80,0.00,0.00,1.04,67.60,'2022-07-22 17:43:24','',''),(5886,'1','273','1',1,'Retail Sale Id 5899',1303.20,0.00,0.00,1.81,117.65,'2022-07-22 17:44:18','',''),(5887,'1','273','1',1,'Retail Sale Id 5900',1000.80,0.00,0.00,1.39,90.35,'2022-07-22 17:45:01','',''),(5888,'1','273','1',1,'Retail Sale Id 5901',4348.80,0.00,0.00,6.04,392.60,'2022-07-22 17:46:34','',''),(5889,'1','273','1',1,'Retail Sale Id 5902',3600.00,0.00,0.00,5.00,325.00,'2022-07-22 17:48:11','',''),(5890,'1','273','1',1,'Retail Sale Id 5903',1000.80,0.00,0.00,1.39,90.35,'2022-07-22 17:54:57','',''),(5891,'1','273','1',1,'Retail Sale Id 5904',5040.00,0.00,0.00,7.00,455.00,'2022-07-22 18:02:02','',''),(5892,'1','273','1',1,'Retail Sale Id 5905',9000.00,0.00,0.00,12.50,812.50,'2022-07-22 18:03:15','',''),(5893,'1','273','1',1,'Retail Sale Id 5906',7200.00,0.00,0.00,10.00,650.00,'2022-07-23 07:00:31','',''),(5894,'1','273','1',1,'Retail Sale Id 5907',67000.00,0.00,0.00,100.00,1500.00,'2022-07-23 07:08:28','',''),(5895,'1','273','1',1,'Retail Sale Id 5908',100500.00,0.00,0.00,150.00,2250.00,'2022-07-23 07:09:22','',''),(5896,'1','273','1',1,'Retail Sale Id 5909',799.20,0.00,0.00,1.11,72.15,'2022-07-23 07:10:40','',''),(5897,'1','273','1',1,'Retail Sale Id 5910',3600.00,0.00,0.00,5.00,325.00,'2022-07-23 07:11:27','',''),(5898,'1','273','1',1,'Retail Sale Id 5911',9000.00,0.00,0.00,12.50,812.50,'2022-07-23 07:12:57','',''),(5899,'1','273','1',1,'Retail Sale Id 5912',799.20,0.00,0.00,1.11,72.15,'2022-07-23 07:13:41','',''),(5900,'1','273','1',1,'Retail Sale Id 5913',7200.00,0.00,0.00,10.00,650.00,'2022-07-23 07:14:47','',''),(5901,'1','273','1',1,'Retail Sale Id 5914',4320.00,0.00,0.00,6.00,390.00,'2022-07-23 07:20:31','',''),(5902,'1','273','1',1,'Retail Sale Id 5915',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 07:21:30','',''),(5903,'1','273','1',1,'Retail Sale Id 5916',799.20,0.00,0.00,1.11,72.15,'2022-07-23 07:22:05','',''),(5904,'1','273','1',1,'Retail Sale Id 5917',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 07:22:57','',''),(5905,'1','273','1',1,'Retail Sale Id 5918',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 07:24:23','',''),(5906,'1','273','1',1,'Retail Sale Id 5919',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 07:28:16','',''),(5907,'1','273','1',1,'Retail Sale Id 5920',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 07:32:17','',''),(5908,'1','273','1',1,'Retail Sale Id 5922',7200.00,0.00,0.00,10.00,650.00,'2022-07-23 07:39:05','',''),(5909,'1','273','1',1,'Retail Sale Id 5923',1440.00,0.00,0.00,2.00,130.00,'2022-07-23 08:03:18','',''),(5910,'1','273','1',1,'Retail Sale Id 5924',5760.00,0.00,0.00,8.00,520.00,'2022-07-23 08:11:55','',''),(5911,'1','273','1',1,'Retail Sale Id 5925',748.80,0.00,0.00,1.04,67.60,'2022-07-23 08:15:54','',''),(5912,'1','273','1',1,'Retail Sale Id 5926',2160.00,0.00,0.00,3.00,195.00,'2022-07-23 08:18:48','',''),(5913,'1','273','1',1,'Retail Sale Id 5927',1440.00,0.00,0.00,2.00,130.00,'2022-07-23 08:20:08','',''),(5914,'1','273','1',1,'Retail Sale Id 5928',1202.40,0.00,0.00,1.67,108.55,'2022-07-23 08:21:55','',''),(5915,'1','273','1',1,'Retail Sale Id 5929',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 08:22:58','',''),(5916,'1','273','1',1,'Retail Sale Id 5930',80400.00,0.00,0.00,120.00,1800.00,'2022-07-23 08:30:25','',''),(5917,'1','273','1',1,'Retail Sale Id 5931',748.80,0.00,0.00,1.04,67.60,'2022-07-23 08:31:40','',''),(5918,'1','273','1',1,'Retail Sale Id 5932',33500.00,0.00,0.00,50.00,750.00,'2022-07-23 08:35:56','',''),(5919,'1','273','1',1,'Retail Sale Id 5933',748.80,0.00,0.00,1.04,67.60,'2022-07-23 08:44:10','',''),(5920,'1','273','1',1,'Retail Sale Id 5934',748.80,0.00,0.00,1.04,67.60,'2022-07-23 08:46:27','',''),(5921,'1','273','1',1,'Retail Sale Id 5935',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 08:47:29','',''),(5922,'1','273','1',1,'Retail Sale Id 5936',10000.80,0.00,0.00,13.89,902.85,'2022-07-23 08:48:38','',''),(5923,'1','273','1',1,'Retail Sale Id 5937',41875.00,0.00,0.00,62.50,937.50,'2022-07-23 08:52:41','',''),(5924,'1','273','1',1,'Retail Sale Id 5938',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 08:55:29','',''),(5925,'1','273','1',1,'Retail Sale Id 5939',1202.40,0.00,0.00,1.67,108.55,'2022-07-23 08:59:01','',''),(5926,'1','273','1',1,'Retail Sale Id 5940',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 09:03:58','',''),(5927,'1','273','1',1,'Retail Sale Id 5942',65660.00,0.00,0.00,98.00,1470.00,'2022-07-23 09:10:52','',''),(5928,'1','273','1',1,'Retail Sale Id 5943',65660.00,0.00,0.00,98.00,1470.00,'2022-07-23 09:12:04','',''),(5929,'1','273','1',1,'Retail Sale Id 5944',1447.20,0.00,0.00,2.01,130.65,'2022-07-23 09:14:03','',''),(5930,'1','273','1',1,'Retail Sale Id 5945',29480.00,0.00,0.00,44.00,660.00,'2022-07-23 09:16:19','',''),(5931,'1','273','1',1,'Retail Sale Id 5946',100500.00,0.00,0.00,150.00,2250.00,'2022-07-23 09:18:30','',''),(5932,'1','273','1',1,'Retail Sale Id 5947',100500.00,0.00,0.00,150.00,2250.00,'2022-07-23 09:19:49','',''),(5933,'1','273','1',1,'Retail Sale Id 5948',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 09:22:42','',''),(5934,'1','273','1',1,'Retail Sale Id 5949',7200.00,0.00,0.00,10.00,650.00,'2022-07-23 09:24:40','',''),(5935,'1','273','1',1,'Retail Sale Id 5950',748.80,0.00,0.00,1.04,67.60,'2022-07-23 09:30:19','',''),(5936,'1','273','1',1,'Retail Sale Id 5951',3002.40,0.00,0.00,4.17,271.05,'2022-07-23 09:31:46','',''),(5937,'1','273','1',1,'Retail Sale Id 5952',2203.20,0.00,0.00,3.06,198.90,'2022-07-23 09:42:52','',''),(5938,'1','273','1',1,'Retail Sale Id 5953',2203.20,0.00,0.00,3.06,198.90,'2022-07-23 09:46:53','',''),(5939,'1','273','1',1,'Retail Sale Id 5954',97150.00,0.00,0.00,145.00,2175.00,'2022-07-23 09:47:45','',''),(5940,'1','273','1',1,'Retail Sale Id 5955',174200.00,0.00,0.00,260.00,3900.00,'2022-07-23 09:48:58','',''),(5941,'1','273','1',1,'Retail Sale Id 5956',100500.00,0.00,0.00,150.00,2250.00,'2022-07-23 09:53:40','',''),(5942,'1','273','1',1,'Retail Sale Id 5957',3600.00,0.00,0.00,5.00,325.00,'2022-07-23 09:54:39','',''),(5943,'1','273','1',1,'Retail Sale Id 5958',100500.00,0.00,0.00,150.00,2250.00,'2022-07-23 09:58:48','',''),(5944,'1','273','1',1,'Retail Sale Id 5959',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 10:00:30','',''),(5945,'1','273','1',1,'Retail Sale Id 5960',2203.20,0.00,0.00,3.06,198.90,'2022-07-23 10:02:34','',''),(5946,'1','273','1',1,'Retail Sale Id 5961',2901.60,0.00,0.00,4.03,261.95,'2022-07-23 10:05:49','',''),(5947,'1','273','1',1,'Retail Sale Id 5962',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 10:07:58','',''),(5948,'1','273','1',1,'Retail Sale Id 5963',9000.00,0.00,0.00,12.50,812.50,'2022-07-23 10:09:24','',''),(5949,'1','273','1',1,'Retail Sale Id 5964',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 10:11:28','',''),(5950,'1','273','1',1,'Retail Sale Id 5965',1447.20,0.00,0.00,2.01,130.65,'2022-07-23 10:13:24','',''),(5951,'1','273','1',1,'Retail Sale Id 5966',140700.00,0.00,0.00,210.00,3150.00,'2022-07-23 10:19:08','',''),(5952,'1','273','1',1,'Retail Sale Id 5967',3600.00,0.00,0.00,5.00,325.00,'2022-07-23 10:20:55','',''),(5953,'1','273','1',1,'Retail Sale Id 5968',167500.00,0.00,0.00,250.00,3750.00,'2022-07-23 10:23:40','',''),(5954,'1','273','1',1,'Retail Sale Id 5969',4320.00,0.00,0.00,6.00,390.00,'2022-07-23 10:28:59','',''),(5955,'1','273','1',1,'Retail Sale Id 5970',32830.00,0.00,0.00,49.00,735.00,'2022-07-23 10:43:22','',''),(5956,'1','273','1',1,'Retail Sale Id 5971',167500.00,0.00,0.00,250.00,3750.00,'2022-07-23 10:44:04','',''),(5957,'1','273','1',1,'Retail Sale Id 5972',120600.00,0.00,0.00,180.00,2700.00,'2022-07-23 10:45:54','',''),(5958,'1','273','1',1,'Retail Sale Id 5973',1440.00,0.00,0.00,2.00,130.00,'2022-07-23 10:51:32','',''),(5959,'1','273','1',1,'Retail Sale Id 5974',1447.20,0.00,0.00,2.01,130.65,'2022-07-23 11:10:14','',''),(5960,'1','273','1',1,'Retail Sale Id 5975',137350.00,0.00,0.00,205.00,3075.00,'2022-07-23 11:12:37','',''),(5961,'1','273','1',1,'Retail Sale Id 5976',61640.00,0.00,0.00,92.00,1380.00,'2022-07-23 11:14:26','',''),(5962,'1','273','1',1,'Retail Sale Id 5977',3002.40,0.00,0.00,4.17,271.05,'2022-07-23 11:19:08','',''),(5963,'1','273','1',1,'Retail Sale Id 5978',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 11:34:41','',''),(5964,'1','273','1',1,'Retail Sale Id 5979',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 11:49:11','',''),(5965,'1','273','1',1,'Retail Sale Id 5980',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 11:56:07','',''),(5966,'1','273','1',1,'Retail Sale Id 5982',720.00,0.00,0.00,1.00,65.00,'2022-07-23 12:03:05','',''),(5967,'1','273','1',1,'Retail Sale Id 5983',26800.00,0.00,0.00,40.00,600.00,'2022-07-23 12:05:11','',''),(5968,'1','273','1',1,'Retail Sale Id 5984',998.30,0.00,0.00,1.49,22.35,'2022-07-23 12:09:24','',''),(5969,'1','273','1',1,'Retail Sale Id 5985',46498.00,0.00,0.00,69.40,1041.00,'2022-07-23 12:12:09','',''),(5970,'1','273','1',1,'Retail Sale Id 5986',100500.00,0.00,0.00,150.00,2250.00,'2022-07-23 12:14:44','',''),(5971,'1','273','1',1,'Retail Sale Id 5987',1340.00,0.00,0.00,2.00,30.00,'2022-07-23 12:18:32','',''),(5972,'1','273','1',1,'Retail Sale Id 5988',1497.60,0.00,0.00,2.08,135.20,'2022-07-23 12:31:16','',''),(5973,'1','273','1',1,'Retail Sale Id 5989',20100.00,0.00,0.00,30.00,450.00,'2022-07-23 12:35:06','',''),(5974,'1','273','1',1,'Retail Sale Id 5990',7200.00,0.00,0.00,10.00,650.00,'2022-07-23 12:42:30','',''),(5975,'1','273','1',1,'Retail Sale Id 5991',748.80,0.00,0.00,1.04,67.60,'2022-07-23 12:53:34','',''),(5976,'1','273','1',1,'Retail Sale Id 5992',1202.40,0.00,0.00,1.67,108.55,'2022-07-23 12:54:37','',''),(5977,'1','273','1',1,'Retail Sale Id 5993',9000.00,0.00,0.00,12.50,812.50,'2022-07-23 13:07:40','',''),(5978,'1','273','1',1,'Retail Sale Id 5994',67000.00,0.00,0.00,100.00,1500.00,'2022-07-23 13:09:08','',''),(5979,'1','273','1',1,'Retail Sale Id 5995',65660.00,0.00,0.00,98.00,1470.00,'2022-07-23 13:15:26','',''),(5980,'1','273','1',1,'Retail Sale Id 5996',799.20,0.00,0.00,1.11,72.15,'2022-07-23 13:20:41','',''),(5981,'1','273','1',1,'Retail Sale Id 5997',3002.40,0.00,0.00,4.17,271.05,'2022-07-23 13:35:38','',''),(5982,'1','273','1',1,'Retail Sale Id 5998',1447.20,0.00,0.00,2.01,130.65,'2022-07-23 13:41:42','',''),(5983,'1','273','1',1,'Retail Sale Id 5999',3600.00,0.00,0.00,5.00,325.00,'2022-07-23 13:44:27','',''),(5984,'1','273','1',1,'Retail Sale Id 6000',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 14:05:04','',''),(5985,'1','273','1',1,'Retail Sale Id 6001',1447.20,0.00,0.00,2.01,130.65,'2022-07-23 14:10:37','',''),(5986,'1','273','1',1,'Retail Sale Id 6002',2160.00,0.00,0.00,3.00,195.00,'2022-07-23 14:20:59','',''),(5987,'1','273','1',1,'Retail Sale Id 6003',120600.00,0.00,0.00,180.00,2700.00,'2022-07-23 14:25:56','',''),(5988,'1','273','1',1,'Retail Sale Id 6004',80400.00,0.00,0.00,120.00,1800.00,'2022-07-23 14:26:48','',''),(5989,'1','273','1',1,'Retail Sale Id 6005',5040.00,0.00,0.00,7.00,455.00,'2022-07-23 14:27:39','',''),(5990,'1','273','1',1,'Retail Sale Id 6006',2160.00,0.00,0.00,3.00,195.00,'2022-07-23 14:32:09','',''),(5991,'1','273','1',1,'Retail Sale Id 6007',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 14:43:37','',''),(5992,'1','273','1',1,'Retail Sale Id 6008',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 14:45:48','',''),(5993,'1','273','1',1,'Retail Sale Id 6010',2160.00,0.00,0.00,3.00,195.00,'2022-07-23 14:48:12','',''),(5994,'1','273','1',1,'Retail Sale Id 6011',1440.00,0.00,0.00,2.00,130.00,'2022-07-23 15:00:32','',''),(5995,'1','273','1',1,'Retail Sale Id 6013',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 15:06:49','',''),(5996,'1','273','1',1,'Retail Sale Id 6014',2203.20,0.00,0.00,3.06,198.90,'2022-07-23 15:29:53','',''),(5997,'1','273','1',1,'Retail Sale Id 6015',1440.00,0.00,0.00,2.00,130.00,'2022-07-23 15:39:43','',''),(5998,'1','273','1',1,'Retail Sale Id 6016',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 15:42:06','',''),(5999,'1','273','1',1,'Retail Sale Id 6017',720.00,0.00,0.00,1.00,65.00,'2022-07-23 15:43:07','',''),(6000,'1','273','1',1,'Retail Sale Id 6018',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 15:52:25','',''),(6001,'1','273','1',1,'Retail Sale Id 6019',1800.00,0.00,0.00,2.50,162.50,'2022-07-23 15:56:40','',''),(6002,'1','273','1',1,'Retail Sale Id 6019',5040.00,0.00,0.00,7.00,455.00,'2022-07-23 15:56:40','',''),(6003,'1','273','1',1,'Retail Sale Id 6020',2880.00,0.00,0.00,4.00,260.00,'2022-07-23 15:57:44','',''),(6004,'1','273','1',1,'Retail Sale Id 6021',720.00,0.00,0.00,1.00,65.00,'2022-07-23 16:05:54','',''),(6005,'1','273','1',1,'Retail Sale Id 6022',80400.00,0.00,0.00,120.00,1800.00,'2022-07-23 16:16:24','',''),(6006,'1','273','1',1,'Retail Sale Id 6023',4003.20,0.00,0.00,5.56,361.40,'2022-07-23 16:17:24','',''),(6007,'1','273','1',1,'Retail Sale Id 6024',65660.00,0.00,0.00,98.00,1470.00,'2022-07-23 16:20:31','',''),(6008,'1','273','1',1,'Retail Sale Id 6025',3600.00,0.00,0.00,5.00,325.00,'2022-07-23 16:23:08','',''),(6009,'1','273','1',1,'Retail Sale Id 6026',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 16:24:13','',''),(6010,'1','273','1',1,'Retail Sale Id 6027',1497.60,0.00,0.00,2.08,135.20,'2022-07-23 16:28:28','',''),(6011,'1','273','1',1,'Retail Sale Id 6029',9000.00,0.00,0.00,12.50,812.50,'2022-07-23 16:44:54','',''),(6012,'1','273','1',1,'Retail Sale Id 6030',3002.40,0.00,0.00,4.17,271.05,'2022-07-23 16:47:58','',''),(6013,'1','273','1',1,'Retail Sale Id 6031',720.00,0.00,0.00,1.00,65.00,'2022-07-23 17:00:08','',''),(6014,'1','273','1',1,'Retail Sale Id 6032',2037.60,0.00,0.00,2.83,183.95,'2022-07-23 17:01:52','',''),(6015,'1','273','1',1,'Retail Sale Id 6034',3600.00,0.00,0.00,5.00,325.00,'2022-07-23 17:03:50','',''),(6016,'1','273','1',1,'Retail Sale Id 6035',4320.00,0.00,0.00,6.00,390.00,'2022-07-23 17:04:31','',''),(6017,'1','273','1',1,'Retail Sale Id 6036',1303.20,0.00,0.00,1.81,117.65,'2022-07-23 17:06:19','',''),(6018,'1','273','1',1,'Retail Sale Id 6037',748.80,0.00,0.00,1.04,67.60,'2022-07-23 17:06:55','',''),(6019,'1','273','1',1,'Retail Sale Id 6038',1000.80,0.00,0.00,1.39,90.35,'2022-07-23 17:07:24','',''),(6020,'1','273','1',1,'Retail Sale Id 6040',748.80,0.00,0.00,1.04,67.60,'2022-07-23 17:13:18','',''),(6021,'1','273','1',1,'Retail Sale Id 6041',2296.80,0.00,0.00,3.19,207.35,'2022-07-23 17:19:47','',''),(6022,'1','273','1',1,'Retail Sale Id 6042',3002.40,0.00,0.00,4.17,271.05,'2022-07-23 17:20:56','',''),(6023,'1','273','1',1,'Retail Sale Id 6043',2001.60,0.00,0.00,2.78,180.70,'2022-07-23 17:22:01','',''),(6024,'1','273','1',1,'Retail Sale Id 6044',748.80,0.00,0.00,1.04,67.60,'2022-07-23 17:23:11','',''),(6025,'1','273','1',1,'Retail Sale Id 6045',2203.20,0.00,0.00,3.06,198.90,'2022-07-23 17:30:33','',''),(6026,'1','273','1',1,'Retail Sale Id 6046',2203.20,0.00,0.00,3.06,198.90,'2022-07-23 17:31:24','',''),(6027,'1','273','1',1,'Retail Sale Id 6047',900.00,0.00,0.00,1.25,81.25,'2022-07-23 17:32:26','',''),(6028,'1','273','1',1,'Retail Sale Id 6048',43550.00,0.00,0.00,65.00,975.00,'2022-07-23 17:34:45','',''),(6029,'1','273','1',1,'Retail Sale Id 6049',2160.00,0.00,0.00,3.00,195.00,'2022-07-23 17:37:49','',''),(6030,'1','273','1',1,'Retail Sale Id 6050',1800.00,0.00,0.00,2.50,162.50,'2022-07-23 17:47:44','',''),(6031,'1','273','1',1,'Retail Sale Id 6051',4219.20,0.00,0.00,5.86,380.90,'2022-07-23 17:48:50','',''),(6032,'1','273','1',1,'Retail Sale Id 6052',2203.20,0.00,0.00,3.06,198.90,'2022-07-23 17:57:09','',''),(6033,'1','273','1',1,'Retail Sale Id 6053',4996.80,0.00,0.00,6.94,451.10,'2022-07-23 17:58:03','',''),(6034,'1','273','1',1,'Return of Retail Sale Id 5983',0.00,26800.00,40.00,0.00,-600.00,'2022-07-23 18:32:24','',''),(6035,'1','273','1',1,'Retail Sale Id 6054',25527.00,0.00,0.00,38.10,571.50,'2022-07-23 18:33:54','',''),(6036,'1','273','1',1,'Retail Sale Id 6055',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 06:40:58','',''),(6037,'1','273','1',1,'Retail Sale Id 6056',2160.00,0.00,0.00,3.00,195.00,'2022-07-24 07:01:55','',''),(6038,'1','273','1',1,'Retail Sale Id 6057',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 07:14:40','',''),(6039,'1','273','1',1,'Retail Sale Id 6058',5097.60,0.00,0.00,7.08,460.20,'2022-07-24 07:27:26','',''),(6040,'1','273','1',1,'Retail Sale Id 6059',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 07:29:23','',''),(6041,'1','273','1',1,'Retail Sale Id 6060',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 07:36:57','',''),(6042,'1','273','1',1,'Retail Sale Id 6061',7999.20,0.00,0.00,11.11,722.15,'2022-07-24 08:18:55','',''),(6043,'1','273','1',1,'Retail Sale Id 6062',3002.40,0.00,0.00,4.17,271.05,'2022-07-24 08:21:48','',''),(6044,'1','273','1',1,'Retail Sale Id 6063',1440.00,0.00,0.00,2.00,130.00,'2022-07-24 08:24:46','',''),(6045,'1','273','1',1,'Retail Sale Id 6064',4298.40,0.00,0.00,5.97,388.05,'2022-07-24 08:40:33','',''),(6046,'1','273','1',1,'Retail Sale Id 6065',10800.00,0.00,0.00,15.00,975.00,'2022-07-24 08:42:45','',''),(6047,'1','273','1',1,'Retail Sale Id 6066',720.00,0.00,0.00,1.00,65.00,'2022-07-24 08:44:09','',''),(6048,'1','273','1',1,'Retail Sale Id 6067',748.80,0.00,0.00,1.04,67.60,'2022-07-24 08:47:12','',''),(6049,'1','273','1',1,'Retail Sale Id 6068',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 08:54:10','',''),(6050,'1','273','1',1,'Retail Sale Id 6069',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 09:04:50','',''),(6051,'1','273','1',1,'Retail Sale Id 6070',720.00,0.00,0.00,1.00,65.00,'2022-07-24 09:07:24','',''),(6052,'1','273','1',1,'Retail Sale Id 6071',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 09:17:57','',''),(6053,'1','273','1',1,'Retail Sale Id 6072',1447.20,0.00,0.00,2.01,130.65,'2022-07-24 09:27:47','',''),(6054,'1','273','1',1,'Retail Sale Id 6073',2880.00,0.00,0.00,4.00,260.00,'2022-07-24 09:33:45','',''),(6055,'1','273','1',1,'Retail Sale Id 6074',720.00,0.00,0.00,1.00,65.00,'2022-07-24 09:35:05','',''),(6056,'1','273','1',1,'Retail Sale Id 6075',38860.00,0.00,0.00,58.00,870.00,'2022-07-24 09:40:14','',''),(6057,'1','273','1',1,'Retail Sale Id 6076',49580.00,0.00,0.00,74.00,1110.00,'2022-07-24 09:40:54','',''),(6058,'1','273','1',1,'Retail Sale Id 6077',4320.00,0.00,0.00,6.00,390.00,'2022-07-24 09:41:32','',''),(6059,'1','273','1',1,'Retail Sale Id 6078',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 09:46:21','',''),(6060,'1','273','1',1,'Retail Sale Id 6079',2880.00,0.00,0.00,4.00,260.00,'2022-07-24 09:52:21','',''),(6061,'1','273','1',1,'Retail Sale Id 6080',2001.60,0.00,0.00,2.78,180.70,'2022-07-24 10:19:32','',''),(6062,'1','273','1',1,'Retail Sale Id 6081',2160.00,0.00,0.00,3.00,195.00,'2022-07-24 10:25:01','',''),(6063,'1','273','1',1,'Retail Sale Id 6082',2160.00,0.00,0.00,3.00,195.00,'2022-07-24 10:32:11','',''),(6064,'1','273','1',1,'Retail Sale Id 6083',7200.00,0.00,0.00,10.00,650.00,'2022-07-24 10:42:26','',''),(6065,'1','273','1',1,'Retail Sale Id 6084',3600.00,0.00,0.00,5.00,325.00,'2022-07-24 11:04:13','',''),(6066,'1','273','1',1,'Retail Sale Id 6085',3600.00,0.00,0.00,5.00,325.00,'2022-07-24 11:05:11','',''),(6067,'1','273','1',1,'Retail Sale Id 6086',3297.60,0.00,0.00,4.58,297.70,'2022-07-24 11:08:11','',''),(6068,'1','273','1',1,'Retail Sale Id 6087',4320.00,0.00,0.00,6.00,390.00,'2022-07-24 11:09:35','',''),(6069,'1','273','1',1,'Retail Sale Id 6088',3600.00,0.00,0.00,5.00,325.00,'2022-07-24 11:11:08','',''),(6070,'1','273','1',1,'Retail Sale Id 6089',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 11:32:14','',''),(6071,'1','273','1',1,'Retail Sale Id 6090',9360.00,0.00,0.00,13.00,845.00,'2022-07-24 11:57:58','',''),(6072,'1','273','1',1,'Retail Sale Id 6091',748.80,0.00,0.00,1.04,67.60,'2022-07-24 12:05:12','',''),(6073,'1','273','1',1,'Retail Sale Id 6092',2001.60,0.00,0.00,2.78,180.70,'2022-07-24 12:05:57','',''),(6074,'1','273','1',1,'Retail Sale Id 6093',1497.60,0.00,0.00,2.08,135.20,'2022-07-24 12:24:41','',''),(6075,'1','273','1',1,'Retail Sale Id 6094',2001.60,0.00,0.00,2.78,180.70,'2022-07-24 12:44:10','',''),(6076,'1','273','1',1,'Retail Sale Id 6095',3002.40,0.00,0.00,4.17,271.05,'2022-07-24 12:47:05','',''),(6077,'1','273','1',1,'Retail Sale Id 6097',727.20,0.00,0.00,1.01,65.65,'2022-07-24 12:56:54','',''),(6078,'1','273','1',1,'Retail Sale Id 6098',2160.00,0.00,0.00,3.00,195.00,'2022-07-24 13:06:43','',''),(6079,'1','273','1',1,'Retail Sale Id 6098',8640.00,0.00,0.00,12.00,780.00,'2022-07-24 13:06:43','',''),(6080,'1','273','1',1,'Retail Sale Id 6099',4320.00,0.00,0.00,6.00,390.00,'2022-07-24 13:17:04','',''),(6081,'1','273','1',1,'Retail Sale Id 6100',33500.00,0.00,0.00,50.00,750.00,'2022-07-24 13:19:02','',''),(6082,'1','273','1',1,'Retail Sale Id 6101',5047.20,0.00,0.00,7.01,455.65,'2022-07-24 13:22:51','',''),(6083,'1','273','1',1,'Retail Sale Id 6102',33500.00,0.00,0.00,50.00,750.00,'2022-07-24 13:23:37','',''),(6084,'1','273','1',1,'Retail Sale Id 6103',33500.00,0.00,0.00,50.00,750.00,'2022-07-24 13:24:16','',''),(6085,'1','273','1',1,'Retail Sale Id 6104',9000.00,0.00,0.00,12.50,812.50,'2022-07-24 13:26:10','',''),(6086,'1','273','1',1,'Retail Sale Id 6105',9000.00,0.00,0.00,12.50,812.50,'2022-07-24 13:27:03','',''),(6087,'1','273','1',1,'Retail Sale Id 6106',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 13:27:47','',''),(6088,'1','273','1',1,'Retail Sale Id 6107',41540.00,0.00,0.00,62.00,930.00,'2022-07-24 13:33:20','',''),(6089,'1','273','1',1,'Retail Sale Id 6108',748.80,0.00,0.00,1.04,67.60,'2022-07-24 13:33:57','',''),(6090,'1','273','1',1,'Retail Sale Id 6109',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 13:34:47','',''),(6091,'1','273','1',1,'Retail Sale Id 6110',1440.00,0.00,0.00,2.00,130.00,'2022-07-24 13:35:41','',''),(6092,'1','273','1',1,'Retail Sale Id 6111',1497.60,0.00,0.00,2.08,135.20,'2022-07-24 13:54:37','',''),(6093,'1','273','1',1,'Retail Sale Id 6112',2160.00,0.00,0.00,3.00,195.00,'2022-07-24 13:57:57','',''),(6094,'1','273','1',1,'Retail Sale Id 6113',32830.00,0.00,0.00,49.00,735.00,'2022-07-24 14:03:10','',''),(6095,'1','273','1',1,'Retail Sale Id 6114',5040.00,0.00,0.00,7.00,455.00,'2022-07-24 14:09:50','',''),(6096,'1','273','1',1,'Retail Sale Id 6115',4320.00,0.00,0.00,6.00,390.00,'2022-07-24 14:15:00','',''),(6097,'1','273','1',1,'Retail Sale Id 6116',80400.00,0.00,0.00,120.00,1800.00,'2022-07-24 14:18:31','',''),(6098,'1','273','1',1,'Retail Sale Id 6117',2160.00,0.00,0.00,3.00,195.00,'2022-07-24 14:24:40','',''),(6099,'1','273','1',1,'Retail Sale Id 6118',1440.00,0.00,0.00,2.00,130.00,'2022-07-24 14:32:42','',''),(6100,'1','273','1',1,'Retail Sale Id 6119',2880.00,0.00,0.00,4.00,260.00,'2022-07-24 14:38:54','',''),(6101,'1','273','1',1,'Retail Sale Id 6120',748.80,0.00,0.00,1.04,67.60,'2022-07-24 14:39:33','',''),(6102,'1','273','1',1,'Retail Sale Id 6121',2001.60,0.00,0.00,2.78,180.70,'2022-07-24 14:43:47','',''),(6103,'1','273','1',1,'Retail Sale Id 6122',1497.60,0.00,0.00,2.08,135.20,'2022-07-24 14:44:42','',''),(6104,'1','273','1',1,'Retail Sale Id 6123',134000.00,0.00,0.00,200.00,3000.00,'2022-07-24 14:49:27','',''),(6105,'1','273','1',1,'Retail Sale Id 6124',201000.00,0.00,0.00,300.00,4500.00,'2022-07-24 14:50:07','',''),(6106,'1','273','1',1,'Retail Sale Id 6125',1440.00,0.00,0.00,2.00,130.00,'2022-07-24 14:50:50','',''),(6107,'1','273','1',1,'Retail Sale Id 6126',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 14:51:38','',''),(6108,'1','273','1',1,'Retail Sale Id 6127',134000.00,0.00,0.00,200.00,3000.00,'2022-07-24 14:57:37','',''),(6109,'1','273','1',1,'Retail Sale Id 6128',100500.00,0.00,0.00,150.00,2250.00,'2022-07-24 14:58:11','',''),(6110,'1','273','1',1,'Retail Sale Id 6129',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 14:59:04','',''),(6111,'1','273','1',1,'Retail Sale Id 6130',9000.00,0.00,0.00,12.50,812.50,'2022-07-24 15:06:11','',''),(6112,'1','273','1',1,'Retail Sale Id 6131',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 15:15:30','',''),(6113,'1','273','1',1,'Retail Sale Id 6132',2160.00,0.00,0.00,3.00,195.00,'2022-07-24 15:23:01','',''),(6114,'1','273','1',1,'Retail Sale Id 6133',1497.60,0.00,0.00,2.08,135.20,'2022-07-24 15:56:01','',''),(6115,'1','273','1',1,'Retail Sale Id 6134',2001.60,0.00,0.00,2.78,180.70,'2022-07-24 15:56:36','',''),(6116,'1','273','1',1,'Retail Sale Id 6135',3600.00,0.00,0.00,5.00,325.00,'2022-07-24 15:57:32','',''),(6117,'1','273','1',1,'Retail Sale Id 6136',2880.00,0.00,0.00,4.00,260.00,'2022-07-24 16:01:10','',''),(6118,'1','273','1',1,'Retail Sale Id 6137',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 16:06:30','',''),(6119,'1','273','1',1,'Retail Sale Id 6138',2880.00,0.00,0.00,4.00,260.00,'2022-07-24 16:07:03','',''),(6120,'1','273','1',1,'Retail Sale Id 6139',2880.00,0.00,0.00,4.00,260.00,'2022-07-24 16:07:56','',''),(6121,'1','273','1',1,'Retail Sale Id 6140',3002.40,0.00,0.00,4.17,271.05,'2022-07-24 16:14:06','',''),(6122,'1','273','1',1,'Retail Sale Id 6141',2901.60,0.00,0.00,4.03,261.95,'2022-07-24 16:17:15','',''),(6123,'1','273','1',1,'Retail Sale Id 6142',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 16:18:04','',''),(6124,'1','273','1',1,'Retail Sale Id 6143',1800.00,0.00,0.00,2.50,162.50,'2022-07-24 16:18:53','',''),(6125,'1','273','1',1,'Retail Sale Id 6144',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 16:21:04','',''),(6126,'1','273','1',1,'Retail Sale Id 6145',748.80,0.00,0.00,1.04,67.60,'2022-07-24 16:24:21','',''),(6127,'1','273','1',1,'Retail Sale Id 6146',2160.00,0.00,0.00,3.00,195.00,'2022-07-24 16:27:10','',''),(6128,'1','273','1',1,'Retail Sale Id 6147',75710.00,0.00,0.00,113.00,1695.00,'2022-07-24 16:28:08','',''),(6129,'1','273','1',1,'Retail Sale Id 6148',4003.20,0.00,0.00,5.56,361.40,'2022-07-24 16:38:28','',''),(6130,'1','273','1',1,'Retail Sale Id 6149',92460.00,0.00,0.00,138.00,2070.00,'2022-07-24 16:41:42','',''),(6131,'1','273','1',1,'Retail Sale Id 6150',4320.00,0.00,0.00,6.00,390.00,'2022-07-24 16:44:08','',''),(6132,'1','273','1',1,'Retail Sale Id 6152',4802.40,0.00,0.00,6.67,433.55,'2022-07-24 16:57:30','',''),(6133,'1','273','1',1,'Retail Sale Id 6151',799.20,0.00,0.00,1.11,72.15,'2022-07-24 16:57:56','',''),(6134,'1','273','1',1,'Return of Retail Sale Id 6151',0.00,799.20,1.11,0.00,-72.15,'2022-07-24 16:58:05','',''),(6135,'1','273','1',1,'Retail Sale Id 6153',95810.00,0.00,0.00,143.00,2145.00,'2022-07-24 17:06:42','',''),(6136,'1','273','1',1,'Retail Sale Id 6154',1000.80,0.00,0.00,1.39,90.35,'2022-07-24 17:07:56','',''),(6137,'1','273','1',1,'Retail Sale Id 6155',105190.00,0.00,0.00,157.00,2355.00,'2022-07-24 17:11:11','',''),(6138,'1','273','1',1,'Retail Sale Id 6156',9000.00,0.00,0.00,12.50,812.50,'2022-07-24 17:16:08','',''),(6139,'1','273','1',1,'Retail Sale Id 6157',1440.00,0.00,0.00,2.00,130.00,'2022-07-24 17:23:53','',''),(6140,'1','273','1',1,'Retail Sale Id 6158',720.00,0.00,0.00,1.00,65.00,'2022-07-24 17:50:25','',''),(6141,'1','273','1',1,'Retail Sale Id 6159',63495.90,0.00,0.00,94.77,1421.55,'2022-07-24 17:57:32','',''),(6142,'1','273','1',1,'Retail Sale Id 6160',5047.20,0.00,0.00,7.01,455.65,'2022-07-24 17:58:10','',''),(6143,'1','273','1',1,'Retail Sale Id 6161',1497.60,0.00,0.00,2.08,135.20,'2022-07-24 17:58:57','',''),(6144,'1','273','1',1,'Retail Sale Id 6162',2160.00,0.00,0.00,3.00,195.00,'2022-07-24 18:07:00','',''),(6145,'1','273','1',1,'Retail Sale Id 6163',9000.00,0.00,0.00,12.50,812.50,'2022-07-24 18:08:26','',''),(6146,'1','273','1',1,'Retail Sale Id 6164',2160.00,0.00,0.00,3.00,195.00,'2022-07-24 18:10:29','',''),(6147,'1','273','1',1,'Retail Sale Id 6165',1447.20,0.00,0.00,2.01,130.65,'2022-07-24 18:14:08','',''),(6148,'1','273','1',1,'Retail Sale Id 6166',28140.00,0.00,0.00,42.00,630.00,'2022-07-25 06:56:57','',''),(6149,'1','273','1',1,'Retail Sale Id 6167',12240.00,0.00,0.00,17.00,1105.00,'2022-07-25 06:58:01','',''),(6150,'1','273','1',1,'Retail Sale Id 6168',2160.00,0.00,0.00,3.00,195.00,'2022-07-25 07:01:35','',''),(6151,'1','273','1',1,'Retail Sale Id 6169',6998.40,0.00,0.00,9.72,631.80,'2022-07-25 07:03:15','',''),(6152,'1','273','1',1,'Retail Sale Id 6170',1000.80,0.00,0.00,1.39,90.35,'2022-07-25 07:06:25','',''),(6153,'1','273','1',1,'Retail Sale Id 6171',5040.00,0.00,0.00,7.00,455.00,'2022-07-25 07:13:45','',''),(6154,'1','273','1',1,'Retail Sale Id 6172',163480.00,0.00,0.00,244.00,3660.00,'2022-07-25 07:20:35','',''),(6155,'1','273','1',1,'Retail Sale Id 6173',188940.00,0.00,0.00,282.00,4230.00,'2022-07-25 07:21:14','',''),(6156,'1','273','1',1,'Retail Sale Id 6174',1303.20,0.00,0.00,1.81,117.65,'2022-07-25 07:22:50','',''),(6157,'1','273','1',1,'Retail Sale Id 6175',2203.20,0.00,0.00,3.06,198.90,'2022-07-25 07:25:05','',''),(6158,'1','273','1',1,'Retail Sale Id 6176',1396.80,0.00,0.00,1.94,126.10,'2022-07-25 07:27:33','',''),(6159,'1','273','1',1,'Retail Sale Id 6177',15410.00,0.00,0.00,23.00,345.00,'2022-07-25 07:35:28','',''),(6160,'1','273','1',1,'Retail Sale Id 6178',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 07:37:38','',''),(6161,'1','273','1',1,'Retail Sale Id 6179',67000.00,0.00,0.00,100.00,1500.00,'2022-07-25 07:38:17','',''),(6162,'1','273','1',1,'Retail Sale Id 6180',748.80,0.00,0.00,1.04,67.60,'2022-07-25 07:39:51','',''),(6163,'1','273','1',1,'Retail Sale Id 6181',67000.00,0.00,0.00,100.00,1500.00,'2022-07-25 07:41:14','',''),(6164,'1','273','1',1,'Retail Sale Id 6182',3600.00,0.00,0.00,5.00,325.00,'2022-07-25 07:43:27','',''),(6165,'1','273','1',1,'Retail Sale Id 6183',720.00,0.00,0.00,1.00,65.00,'2022-07-25 07:45:31','',''),(6166,'1','273','1',1,'Retail Sale Id 6185',5047.20,0.00,0.00,7.01,455.65,'2022-07-25 07:48:04','',''),(6167,'1','273','1',1,'Retail Sale Id 6186',2160.00,0.00,0.00,3.00,195.00,'2022-07-25 07:55:42','',''),(6168,'1','273','1',1,'Retail Sale Id 6187',4320.00,0.00,0.00,6.00,390.00,'2022-07-25 07:56:40','',''),(6169,'1','273','1',1,'Retail Sale Id 6188',5997.60,0.00,0.00,8.33,541.45,'2022-07-25 07:57:49','',''),(6170,'1','273','1',1,'Retail Sale Id 6189',2203.20,0.00,0.00,3.06,198.90,'2022-07-25 08:07:59','',''),(6171,'1','273','1',1,'Retail Sale Id 6190',1447.20,0.00,0.00,2.01,130.65,'2022-07-25 08:10:23','',''),(6172,'1','273','1',1,'Retail Sale Id 6191',18090.00,0.00,0.00,27.00,405.00,'2022-07-25 08:39:16','',''),(6173,'1','273','1',1,'Retail Sale Id 6192',2203.20,0.00,0.00,3.06,198.90,'2022-07-25 08:43:44','',''),(6174,'1','273','1',1,'Retail Sale Id 6193',9000.00,0.00,0.00,12.50,812.50,'2022-07-25 08:47:11','',''),(6175,'1','273','1',1,'Retail Sale Id 6194',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 08:48:23','',''),(6176,'1','273','1',1,'Retail Sale Id 6195',18000.00,0.00,0.00,25.00,1625.00,'2022-07-25 08:53:10','',''),(6177,'1','273','1',1,'Retail Sale Id 6196',3600.00,0.00,0.00,5.00,325.00,'2022-07-25 08:53:55','',''),(6178,'1','273','1',1,'Retail Sale Id 6197',33500.00,0.00,0.00,50.00,750.00,'2022-07-25 08:58:42','',''),(6179,'1','273','1',1,'Retail Sale Id 6198',4348.80,0.00,0.00,6.04,392.60,'2022-07-25 09:00:04','',''),(6180,'1','273','1',1,'Retail Sale Id 6199',9000.00,0.00,0.00,12.50,812.50,'2022-07-25 09:15:36','',''),(6181,'1','273','1',1,'Retail Sale Id 6200',9000.00,0.00,0.00,12.50,812.50,'2022-07-25 09:17:03','',''),(6182,'1','273','1',1,'Retail Sale Id 6201',1447.20,0.00,0.00,2.01,130.65,'2022-07-25 09:17:52','',''),(6183,'1','273','1',1,'Retail Sale Id 6202',2160.00,0.00,0.00,3.00,195.00,'2022-07-25 09:24:28','',''),(6184,'1','273','1',1,'Retail Sale Id 6203',67000.00,0.00,0.00,100.00,1500.00,'2022-07-25 09:26:30','',''),(6185,'1','273','1',1,'Retail Sale Id 6204',33500.00,0.00,0.00,50.00,750.00,'2022-07-25 09:27:13','',''),(6186,'1','273','1',1,'Retail Sale Id 6205',1000.80,0.00,0.00,1.39,90.35,'2022-07-25 09:32:39','',''),(6187,'1','273','1',1,'Retail Sale Id 6206',67000.00,0.00,0.00,100.00,1500.00,'2022-07-25 09:35:34','',''),(6188,'1','273','1',1,'Retail Sale Id 6207',33500.00,0.00,0.00,50.00,750.00,'2022-07-25 09:36:22','',''),(6189,'1','273','1',1,'Retail Sale Id 6208',748.80,0.00,0.00,1.04,67.60,'2022-07-25 09:54:47','',''),(6190,'1','273','1',1,'Retail Sale Id 6209',2001.60,0.00,0.00,2.78,180.70,'2022-07-25 09:59:20','',''),(6191,'1','273','1',1,'Retail Sale Id 6210',2203.20,0.00,0.00,3.06,198.90,'2022-07-25 10:01:05','',''),(6192,'1','273','1',1,'Retail Sale Id 6211',748.80,0.00,0.00,1.04,67.60,'2022-07-25 10:02:37','',''),(6193,'1','273','1',1,'Retail Sale Id 6212',4003.20,0.00,0.00,5.56,361.40,'2022-07-25 10:16:44','',''),(6194,'1','273','1',1,'Retail Sale Id 6213',2498.40,0.00,0.00,3.47,225.55,'2022-07-25 10:22:53','',''),(6195,'1','273','1',1,'Retail Sale Id 6214',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 10:25:21','',''),(6196,'1','273','1',1,'Retail Sale Id 6215',80400.00,0.00,0.00,120.00,1800.00,'2022-07-25 10:29:38','',''),(6197,'1','273','1',1,'Retail Sale Id 6216',28140.00,0.00,0.00,42.00,630.00,'2022-07-25 10:30:44','',''),(6198,'1','273','1',1,'Retail Sale Id 6217',25125.00,0.00,0.00,37.50,562.50,'2022-07-25 10:32:21','',''),(6199,'1','273','1',1,'Retail Sale Id 6218',4327.20,0.00,0.00,6.01,390.65,'2022-07-25 10:35:30','',''),(6200,'1','273','1',1,'Retail Sale Id 6219',9000.00,0.00,0.00,12.50,812.50,'2022-07-25 10:36:35','',''),(6201,'1','273','1',1,'Retail Sale Id 6220',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 10:38:50','',''),(6202,'1','273','1',1,'Retail Sale Id 6221',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 10:39:41','',''),(6203,'1','273','1',1,'Retail Sale Id 6222',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 10:48:00','',''),(6204,'1','273','1',1,'Retail Sale Id 6223',67000.00,0.00,0.00,100.00,1500.00,'2022-07-25 10:49:09','',''),(6205,'1','273','1',1,'Retail Sale Id 6224',67000.00,0.00,0.00,100.00,1500.00,'2022-07-25 11:41:11','',''),(6206,'1','273','1',1,'Retail Sale Id 6225',66330.00,0.00,0.00,99.00,1485.00,'2022-07-25 11:43:24','',''),(6207,'1','273','1',1,'Retail Sale Id 6226',9000.00,0.00,0.00,12.50,812.50,'2022-07-25 11:50:42','',''),(6208,'1','273','1',1,'Retail Sale Id 6227',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 11:53:09','',''),(6209,'1','273','1',1,'Return of Retail Sale Id 6227',0.00,100500.00,150.00,0.00,-2250.00,'2022-07-25 11:55:13','',''),(6210,'1','273','1',1,'Retail Sale Id 6228',67000.00,0.00,0.00,100.00,1500.00,'2022-07-25 11:55:46','',''),(6211,'1','273','1',1,'Retail Sale Id 6229',2498.40,0.00,0.00,3.47,225.55,'2022-07-25 12:02:33','',''),(6212,'1','273','1',1,'Retail Sale Id 6230',19430.00,0.00,0.00,29.00,435.00,'2022-07-25 12:14:53','',''),(6213,'1','273','1',1,'Retail Sale Id 6231',1000.80,0.00,0.00,1.39,90.35,'2022-07-25 12:15:56','',''),(6214,'1','273','1',1,'Retail Sale Id 6232',2203.20,0.00,0.00,3.06,198.90,'2022-07-25 12:25:53','',''),(6215,'1','273','1',1,'Retail Sale Id 6233',6480.00,0.00,0.00,9.00,585.00,'2022-07-25 12:40:58','',''),(6216,'1','273','1',1,'Retail Sale Id 6234',1000.80,0.00,0.00,1.39,90.35,'2022-07-25 12:43:35','',''),(6217,'1','273','1',1,'Retail Sale Id 6235',3600.00,0.00,0.00,5.00,325.00,'2022-07-25 12:48:22','',''),(6218,'1','273','1',1,'Retail Sale Id 6236',1000.80,0.00,0.00,1.39,90.35,'2022-07-25 13:05:55','',''),(6219,'1','273','1',1,'Retail Sale Id 6237',2901.60,0.00,0.00,4.03,261.95,'2022-07-25 13:12:59','',''),(6220,'1','273','1',1,'Retail Sale Id 6238',2203.20,0.00,0.00,3.06,198.90,'2022-07-25 13:24:06','',''),(6221,'1','273','1',1,'Retail Sale Id 6239',1447.20,0.00,0.00,2.01,130.65,'2022-07-25 13:28:51','',''),(6222,'1','273','1',1,'Retail Sale Id 6240',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 13:31:06','',''),(6223,'1','273','1',1,'Retail Sale Id 6241',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 13:32:10','',''),(6224,'1','273','1',1,'Retail Sale Id 6242',88440.00,0.00,0.00,132.00,1980.00,'2022-07-25 13:37:01','',''),(6225,'1','273','1',1,'Retail Sale Id 6243',110550.00,0.00,0.00,165.00,2475.00,'2022-07-25 13:37:50','',''),(6226,'1','273','1',1,'Retail Sale Id 6244',748.80,0.00,0.00,1.04,67.60,'2022-07-25 13:48:29','',''),(6227,'1','273','1',1,'Retail Sale Id 6245',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 14:04:14','',''),(6228,'1','273','1',1,'Retail Sale Id 6246',131320.00,0.00,0.00,196.00,2940.00,'2022-07-25 14:06:46','',''),(6229,'1','273','1',1,'Retail Sale Id 6247',9000.00,0.00,0.00,12.50,812.50,'2022-07-25 14:07:38','',''),(6230,'1','273','1',1,'Retail Sale Id 6248',80400.00,0.00,0.00,120.00,1800.00,'2022-07-25 14:09:47','',''),(6231,'1','273','1',1,'Retail Sale Id 6249',3499.20,0.00,0.00,4.86,315.90,'2022-07-25 14:20:15','',''),(6232,'1','273','1',1,'Retail Sale Id 6250',1000.80,0.00,0.00,1.39,90.35,'2022-07-25 14:25:32','',''),(6233,'1','273','1',1,'Retail Sale Id 6251',2001.60,0.00,0.00,2.78,180.70,'2022-07-25 14:32:48','',''),(6234,'1','273','1',1,'Retail Sale Id 6252',1440.00,0.00,0.00,2.00,130.00,'2022-07-25 14:54:18','',''),(6235,'1','273','1',1,'Retail Sale Id 6253',4327.20,0.00,0.00,6.01,390.65,'2022-07-25 15:00:39','',''),(6236,'1','273','1',1,'Retail Sale Id 6254',12600.00,0.00,0.00,17.50,1137.50,'2022-07-25 15:10:35','',''),(6237,'1','273','1',1,'Retail Sale Id 6255',100500.00,0.00,0.00,150.00,2250.00,'2022-07-25 15:23:22','',''),(6238,'1','273','1',1,'Distributed to OPERATIONAL LOSE for sales id:6',136240.00,0.00,0.00,208.00,0.00,'2022-07-25 16:20:46','',''),(6239,'1','273',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,16137900.00,25020.00,0.00,0.00,'2022-07-26 10:43:19','',''),(6240,'1','273',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,24900.00,0.00,'2022-07-26 10:44:48','',''),(6241,'1','273','1',1,'Received from bridging 22',0.00,0.00,24900.00,0.00,0.00,'2022-07-26 10:44:48','',''),(6242,'1','273','1',1,'Retail Sale Id 6256',115884.00,0.00,0.00,174.00,3654.00,'2022-07-26 10:46:40','',''),(6243,'1','273','1',1,'Retail Sale Id 6257',53946.00,0.00,0.00,81.00,1701.00,'2022-07-26 10:47:19','',''),(6244,'1','273','1',1,'Retail Sale Id 6258',15984.00,0.00,0.00,24.00,504.00,'2022-07-26 10:47:46','',''),(6245,'1','273','1',1,'Retail Sale Id 6259',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 10:48:42','',''),(6246,'1','273','1',1,'Retail Sale Id 6260',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 10:49:18','',''),(6247,'1','273','1',1,'Retail Sale Id 6261',8551.12,0.00,0.00,12.01,804.67,'2022-07-26 10:51:07','',''),(6248,'1','273','1',1,'Retail Sale Id 6262',747.60,0.00,0.00,1.05,70.35,'2022-07-26 10:51:40','',''),(6249,'1','273','1',1,'Retail Sale Id 6263',747.60,0.00,0.00,1.05,70.35,'2022-07-26 10:52:07','',''),(6250,'1','273','1',1,'Retail Sale Id 6264',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 10:53:04','',''),(6251,'1','273','1',1,'Retail Sale Id 6265',97902.00,0.00,0.00,147.00,3087.00,'2022-07-26 10:58:25','',''),(6252,'1','273','1',1,'Retail Sale Id 6266',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 11:00:14','',''),(6253,'1','273','1',1,'Retail Sale Id 6267',99900.00,0.00,0.00,150.00,3150.00,'2022-07-26 11:01:28','',''),(6254,'1','273','1',1,'Retail Sale Id 6269',4300.48,0.00,0.00,6.04,404.68,'2022-07-26 11:04:45','',''),(6255,'1','273',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,120.00,0.00,'2022-07-26 11:09:05','',''),(6256,'1','273','1',1,'Received from bridging 23',0.00,0.00,120.00,0.00,0.00,'2022-07-26 11:09:05','',''),(6257,'1','273','1',1,'Retail Sale Id 6270',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 11:13:13','',''),(6258,'1','273','1',1,'Retail Sale Id 6271',2997.52,0.00,0.00,4.21,282.07,'2022-07-26 11:15:30','',''),(6259,'1','273','1',1,'Retail Sale Id 6272',7120.00,0.00,0.00,10.00,670.00,'2022-07-26 11:17:20','',''),(6260,'1','273','1',1,'Retail Sale Id 6273',65268.00,0.00,0.00,98.00,2058.00,'2022-07-26 11:21:25','',''),(6261,'1','273','1',1,'Retail Sale Id 6274',99900.00,0.00,0.00,150.00,3150.00,'2022-07-26 11:39:33','',''),(6262,'1','273','1',1,'Retail Sale Id 6275',79920.00,0.00,0.00,120.00,2520.00,'2022-07-26 11:40:33','',''),(6263,'1','273','1',1,'Retail Sale Id 6276',6660.00,0.00,0.00,10.00,210.00,'2022-07-26 11:43:35','',''),(6264,'1','273','1',1,'Retail Sale Id 6277',4499.84,0.00,0.00,6.32,423.44,'2022-07-26 11:53:44','',''),(6265,'1','273','1',1,'Retail Sale Id 6278',79920.00,0.00,0.00,120.00,2520.00,'2022-07-26 11:56:29','',''),(6266,'1','273','1',1,'Retail Sale Id 6279',79920.00,0.00,0.00,120.00,2520.00,'2022-07-26 11:57:31','',''),(6267,'1','273','1',1,'Retail Sale Id 6280',2136.00,0.00,0.00,3.00,201.00,'2022-07-26 12:20:30','',''),(6268,'1','273','1',1,'Retail Sale Id 6281',2000.72,0.00,0.00,2.81,188.27,'2022-07-26 12:27:37','',''),(6269,'1','273','1',1,'Retail Sale Id 6282',133200.00,0.00,0.00,200.00,4200.00,'2022-07-26 12:29:06','',''),(6270,'1','273','1',1,'Retail Sale Id 6283',34632.00,0.00,0.00,52.00,1092.00,'2022-07-26 12:35:43','',''),(6271,'1','273','1',1,'Retail Sale Id 6284',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 12:37:08','',''),(6272,'1','273','1',1,'Retail Sale Id 6285',4272.00,0.00,0.00,6.00,402.00,'2022-07-26 12:40:17','',''),(6273,'1','273','1',1,'Retail Sale Id 6286',2136.00,0.00,0.00,3.00,201.00,'2022-07-26 12:49:16','',''),(6274,'1','273','1',1,'Retail Sale Id 6287',1424.00,0.00,0.00,2.00,134.00,'2022-07-26 12:52:29','',''),(6275,'1','273','1',1,'Retail Sale Id 6288',7120.00,0.00,0.00,10.00,670.00,'2022-07-26 12:53:52','',''),(6276,'1','273','1',1,'Retail Sale Id 6289',22644.00,0.00,0.00,34.00,714.00,'2022-07-26 13:00:00','',''),(6277,'1','273','1',1,'Retail Sale Id 6290',2848.00,0.00,0.00,4.00,268.00,'2022-07-26 13:12:09','',''),(6278,'1','273','1',1,'Retail Sale Id 6291',8544.00,0.00,0.00,12.00,804.00,'2022-07-26 13:21:12','',''),(6279,'1','273','1',1,'Retail Sale Id 6292',747.60,0.00,0.00,1.05,70.35,'2022-07-26 13:44:57','',''),(6280,'1','273','1',1,'Retail Sale Id 6293',99900.00,0.00,0.00,150.00,3150.00,'2022-07-26 14:03:12','',''),(6281,'1','273','1',1,'Retail Sale Id 6294',99900.00,0.00,0.00,150.00,3150.00,'2022-07-26 14:03:54','',''),(6282,'1','273','1',1,'Retail Sale Id 6295',2136.00,0.00,0.00,3.00,201.00,'2022-07-26 14:05:22','',''),(6283,'1','273','1',1,'Retail Sale Id 6296',3560.00,0.00,0.00,5.00,335.00,'2022-07-26 14:11:06','',''),(6284,'1','273','1',1,'Retail Sale Id 6297',33300.00,0.00,0.00,50.00,1050.00,'2022-07-26 14:27:26','',''),(6285,'1','273','1',1,'Retail Sale Id 6298',99900.00,0.00,0.00,150.00,3150.00,'2022-07-26 14:33:31','',''),(6286,'1','273','1',1,'Retail Sale Id 6299',99900.00,0.00,0.00,150.00,3150.00,'2022-07-26 14:34:02','',''),(6287,'1','273','1',1,'Retail Sale Id 6300',2000.72,0.00,0.00,2.81,188.27,'2022-07-26 14:39:09','',''),(6288,'1','273','1',1,'Retail Sale Id 6301',1424.00,0.00,0.00,2.00,134.00,'2022-07-26 14:47:06','',''),(6289,'1','273','1',1,'Retail Sale Id 6302',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 14:52:29','',''),(6290,'1','273','1',1,'Retail Sale Id 6303',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 14:57:55','',''),(6291,'1','273','1',1,'Retail Sale Id 6304',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 15:00:45','',''),(6292,'1','273','1',1,'Retail Sale Id 6305',82370.88,0.00,0.00,123.68,2597.28,'2022-07-26 15:04:43','',''),(6293,'1','273','1',1,'Retail Sale Id 6306',37296.00,0.00,0.00,56.00,1176.00,'2022-07-26 15:05:27','',''),(6294,'1','273','1',1,'Retail Sale Id 6307',3702.40,0.00,0.00,5.20,348.40,'2022-07-26 15:11:14','',''),(6295,'1','273','1',1,'Retail Sale Id 6308',996.80,0.00,0.00,1.40,93.80,'2022-07-26 15:14:45','',''),(6296,'1','273','1',1,'Retail Sale Id 6309',2000.72,0.00,0.00,2.81,188.27,'2022-07-26 15:20:15','',''),(6297,'1','273','1',1,'Retail Sale Id 6310',2136.00,0.00,0.00,3.00,201.00,'2022-07-26 15:23:51','',''),(6298,'1','273','1',1,'Retail Sale Id 6311',747.60,0.00,0.00,1.05,70.35,'2022-07-26 15:31:07','',''),(6299,'1','273','1',1,'Retail Sale Id 6312',66600.00,0.00,0.00,100.00,2100.00,'2022-07-26 15:35:08','',''),(6300,'1','273','1',1,'Retail Sale Id 6313',37296.00,0.00,0.00,56.00,1176.00,'2022-07-26 15:36:10','',''),(6301,'1','273','1',1,'Retail Sale Id 6314',33300.00,0.00,0.00,50.00,1050.00,'2022-07-26 15:44:29','',''),(6302,'1','273','1',1,'Retail Sale Id 6315',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 15:45:08','',''),(6303,'1','273','1',1,'Retail Sale Id 6316',66600.00,0.00,0.00,100.00,2100.00,'2022-07-26 15:53:08','',''),(6304,'1','273','1',1,'Retail Sale Id 6317',7120.00,0.00,0.00,10.00,670.00,'2022-07-26 15:57:11','',''),(6305,'1','273','1',1,'Retail Sale Id 6318',66600.00,0.00,0.00,100.00,2100.00,'2022-07-26 15:59:33','',''),(6306,'1','273','1',1,'Retail Sale Id 6319',2143.12,0.00,0.00,3.01,201.67,'2022-07-26 16:05:07','',''),(6307,'1','273','1',1,'Retail Sale Id 6320',4279.12,0.00,0.00,6.01,402.67,'2022-07-26 16:08:49','',''),(6308,'1','273','1',1,'Retail Sale Id 6321',18648.00,0.00,0.00,28.00,588.00,'2022-07-26 16:11:28','',''),(6309,'1','273','1',1,'Retail Sale Id 6322',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 16:13:56','',''),(6310,'1','273','1',1,'Retail Sale Id 6323',1452.48,0.00,0.00,2.04,136.68,'2022-07-26 16:17:24','',''),(6311,'1','273','1',1,'Retail Sale Id 6324',2000.72,0.00,0.00,2.81,188.27,'2022-07-26 16:18:12','',''),(6312,'1','273','1',1,'Retail Sale Id 6325',1452.48,0.00,0.00,2.04,136.68,'2022-07-26 16:18:59','',''),(6313,'1','273','1',1,'Retail Sale Id 6326',1502.32,0.00,0.00,2.11,141.37,'2022-07-26 16:27:20','',''),(6314,'1','273','1',1,'Retail Sale Id 6327',4300.48,0.00,0.00,6.04,404.68,'2022-07-26 16:30:12','',''),(6315,'1','273','1',1,'Retail Sale Id 6328',2200.08,0.00,0.00,3.09,207.03,'2022-07-26 16:31:26','',''),(6316,'1','273','1',1,'Retail Sale Id 6329',4998.24,0.00,0.00,7.02,470.34,'2022-07-26 16:34:21','',''),(6317,'1','273','1',1,'Retail Sale Id 6329',6998.96,0.00,0.00,9.83,658.61,'2022-07-26 16:34:21','',''),(6318,'1','273','1',1,'Retail Sale Id 6330',2000.72,0.00,0.00,2.81,188.27,'2022-07-26 16:35:28','',''),(6319,'1','273','1',1,'Retail Sale Id 6331',2200.08,0.00,0.00,3.09,207.03,'2022-07-26 16:36:40','',''),(6320,'1','273','1',1,'Retail Sale Id 6332',4001.44,0.00,0.00,5.62,376.54,'2022-07-26 16:43:43','',''),(6321,'1','273','1',1,'Retail Sale Id 6333',2848.00,0.00,0.00,4.00,268.00,'2022-07-26 17:18:00','',''),(6322,'1','273','1',1,'Retail Sale Id 6334',2000.72,0.00,0.00,2.81,188.27,'2022-07-26 17:19:09','',''),(6323,'1','273','1',1,'Retail Sale Id 6335',1993.88,0.00,0.00,0.28,1813.28,'2022-07-26 17:21:51','',''),(6324,'1','273','1',1,'Retail Sale Id 6336',797.44,0.00,0.00,1.12,75.04,'2022-07-26 17:27:15','',''),(6325,'1','273','1',1,'Return of Retail Sale Id 6335',0.00,1993.88,0.28,0.00,-1813.28,'2022-07-26 17:29:35','',''),(6326,'1','273','1',1,'Retail Sale Id 6337',3560.00,0.00,0.00,5.00,335.00,'2022-07-26 17:30:27','',''),(6327,'1','273','1',1,'Retail Sale Id 6338',996.80,0.00,0.00,1.40,93.80,'2022-07-26 17:31:36','',''),(6328,'1','273','1',1,'Retail Sale Id 6339',2000.72,0.00,0.00,2.81,188.27,'2022-07-26 17:32:19','',''),(6329,'1','273','1',1,'Retail Sale Id 6340',3880.40,0.00,0.00,5.45,365.15,'2022-07-26 17:33:13','',''),(6330,'1','273','1',1,'Retail Sale Id 6341',2136.00,0.00,0.00,3.00,201.00,'2022-07-26 17:34:39','',''),(6331,'1','273','1',1,'Retail Sale Id 6343',2150.24,0.00,0.00,3.02,202.34,'2022-07-26 17:53:33','',''),(6332,'1','273','1',1,'Retail Sale Id 6344',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 17:55:29','',''),(6333,'1','273','1',1,'Retail Sale Id 6346',1452.48,0.00,0.00,2.04,136.68,'2022-07-26 17:56:52','',''),(6334,'1','273','1',1,'Retail Sale Id 6347',8900.00,0.00,0.00,12.50,837.50,'2022-07-26 18:05:13','',''),(6335,'1','273','1',1,'Retail Sale Id 6348',3560.00,0.00,0.00,5.00,335.00,'2022-07-27 07:01:09','',''),(6336,'1','273','1',1,'Retail Sale Id 6349',35298.00,0.00,0.00,53.00,1113.00,'2022-07-27 07:06:36','',''),(6337,'1','273','1',1,'Retail Sale Id 6350',99900.00,0.00,0.00,150.00,3150.00,'2022-07-27 07:10:18','',''),(6338,'1','273','1',1,'Retail Sale Id 6351',58608.00,0.00,0.00,88.00,1848.00,'2022-07-27 07:11:41','',''),(6339,'1','273','1',1,'Retail Sale Id 6352',24994.98,0.00,0.00,37.53,788.13,'2022-07-27 07:16:23','',''),(6340,'1','273','1',1,'Retail Sale Id 6353',99900.00,0.00,0.00,150.00,3150.00,'2022-07-27 07:22:04','',''),(6341,'1','273','1',1,'Retail Sale Id 6354',4272.00,0.00,0.00,6.00,402.00,'2022-07-27 07:24:19','',''),(6342,'1','273','1',1,'Retail Sale Id 6355',9968.00,0.00,0.00,14.00,938.00,'2022-07-27 07:25:52','',''),(6343,'1','273','1',1,'Retail Sale Id 6356',712.00,0.00,0.00,1.00,67.00,'2022-07-27 07:27:16','',''),(6344,'1','273','1',1,'Retail Sale Id 6357',4272.00,0.00,0.00,6.00,402.00,'2022-07-27 07:28:25','',''),(6345,'1','273','1',1,'Retail Sale Id 6358',70596.00,0.00,0.00,106.00,2226.00,'2022-07-27 07:30:12','',''),(6346,'1','273','1',1,'Retail Sale Id 6359',66600.00,0.00,0.00,100.00,2100.00,'2022-07-27 07:34:37','',''),(6347,'1','273','1',1,'Retail Sale Id 6360',99900.00,0.00,0.00,150.00,3150.00,'2022-07-27 07:35:28','',''),(6348,'1','273','1',1,'Retail Sale Id 6361',8325.00,0.00,0.00,12.50,262.50,'2022-07-27 07:37:21','',''),(6349,'1','273','1',1,'Retail Sale Id 6362',3560.00,0.00,0.00,5.00,335.00,'2022-07-27 07:40:18','',''),(6350,'1','273','1',1,'Retail Sale Id 6363',33966.00,0.00,0.00,51.00,1071.00,'2022-07-27 07:44:39','',''),(6351,'1','273','1',1,'Retail Sale Id 6365',4272.00,0.00,0.00,6.00,402.00,'2022-07-27 07:46:42','',''),(6352,'1','273','1',1,'Retail Sale Id 6365',8900.00,0.00,0.00,12.50,837.50,'2022-07-27 07:46:42','',''),(6353,'1','273','1',1,'Retail Sale Id 6366',3702.40,0.00,0.00,5.20,348.40,'2022-07-27 07:51:12','',''),(6354,'1','273','1',1,'Retail Sale Id 6367',747.60,0.00,0.00,1.05,70.35,'2022-07-27 07:52:23','',''),(6355,'1','273','1',1,'Retail Sale Id 6368',2997.52,0.00,0.00,4.21,282.07,'2022-07-27 07:58:22','',''),(6356,'1','273','1',1,'Retail Sale Id 6369',4998.24,0.00,0.00,7.02,470.34,'2022-07-27 08:03:11','',''),(6357,'1','273','1',1,'Retail Sale Id 6370',1502.32,0.00,0.00,2.11,141.37,'2022-07-27 08:05:08','',''),(6358,'1','273','1',1,'Retail Sale Id 6371',2200.08,0.00,0.00,3.09,207.03,'2022-07-27 08:06:38','',''),(6359,'1','273','1',1,'Retail Sale Id 6372',8900.00,0.00,0.00,12.50,837.50,'2022-07-27 08:07:37','',''),(6360,'1','273','1',1,'Retail Sale Id 6373',996.80,0.00,0.00,1.40,93.80,'2022-07-27 08:08:35','',''),(6361,'1','273','1',1,'Retail Sale Id 6374',996.80,0.00,0.00,1.40,93.80,'2022-07-27 08:09:17','',''),(6362,'1','273','1',1,'Retail Sale Id 6375',33300.00,0.00,0.00,50.00,1050.00,'2022-07-27 08:12:39','',''),(6363,'1','273','1',1,'Retail Sale Id 6376',996.80,0.00,0.00,1.40,93.80,'2022-07-27 08:14:04','',''),(6364,'1','273','1',1,'Retail Sale Id 6377',66600.00,0.00,0.00,100.00,2100.00,'2022-07-27 08:15:17','',''),(6365,'1','273','1',1,'Retail Sale Id 6378',66600.00,0.00,0.00,100.00,2100.00,'2022-07-27 08:16:06','',''),(6366,'1','273','1',1,'Retail Sale Id 6379',2000.72,0.00,0.00,2.81,188.27,'2022-07-27 08:17:16','',''),(6367,'1','273','1',1,'Retail Sale Id 6380',2150.24,0.00,0.00,3.02,202.34,'2022-07-27 08:26:27','',''),(6368,'1','273','1',1,'Retail Sale Id 6381',2150.24,0.00,0.00,3.02,202.34,'2022-07-27 08:27:56','',''),(6369,'1','273','1',1,'Retail Sale Id 6383',7853.36,0.00,0.00,11.03,739.01,'2022-07-27 08:40:04','',''),(6370,'1','273','1',1,'Retail Sale Id 6384',2848.00,0.00,0.00,4.00,268.00,'2022-07-27 08:48:32','',''),(6371,'1','273','1',1,'Retail Sale Id 6385',996.80,0.00,0.00,1.40,93.80,'2022-07-27 08:56:23','',''),(6372,'1','273','1',1,'Retail Sale Id 6386',2848.00,0.00,0.00,4.00,268.00,'2022-07-27 08:57:19','',''),(6373,'1','273','1',1,'Retail Sale Id 6387',2136.00,0.00,0.00,3.00,201.00,'2022-07-27 09:02:42','',''),(6374,'1','273','1',1,'Retail Sale Id 6388',996.80,0.00,0.00,1.40,93.80,'2022-07-27 09:08:05','',''),(6375,'1','273','1',1,'Retail Sale Id 6389',4101.12,0.00,0.00,5.76,385.92,'2022-07-27 09:11:50','',''),(6376,'1','273','1',1,'Retail Sale Id 6389',8900.00,0.00,0.00,12.50,837.50,'2022-07-27 09:11:50','',''),(6377,'1','273','1',1,'Retail Sale Id 6390',747.60,0.00,0.00,1.05,70.35,'2022-07-27 09:12:56','',''),(6378,'1','273','1',1,'Retail Sale Id 6391',33300.00,0.00,0.00,50.00,1050.00,'2022-07-27 09:22:36','',''),(6379,'1','273','1',1,'Retail Sale Id 6392',2136.00,0.00,0.00,3.00,201.00,'2022-07-27 09:24:55','',''),(6380,'1','273','1',1,'Retail Sale Id 6393',3503.04,0.00,0.00,4.92,329.64,'2022-07-27 09:25:52','',''),(6381,'1','273','1',1,'Retail Sale Id 6394',33300.00,0.00,0.00,50.00,1050.00,'2022-07-27 09:31:30','',''),(6382,'1','273','1',1,'Retail Sale Id 6395',8544.00,0.00,0.00,12.00,804.00,'2022-07-27 09:37:47','',''),(6383,'1','273','1',1,'Retail Sale Id 6396',1502.32,0.00,0.00,2.11,141.37,'2022-07-27 09:38:25','',''),(6384,'1','273','1',1,'Retail Sale Id 6397',4001.44,0.00,0.00,5.62,376.54,'2022-07-27 09:39:01','',''),(6385,'1','273','1',1,'Retail Sale Id 6398',10680.00,0.00,0.00,15.00,1005.00,'2022-07-27 09:39:58','',''),(6386,'1','273','1',1,'Retail Sale Id 6399',7198.32,0.00,0.00,10.11,677.37,'2022-07-27 09:44:30','',''),(6387,'1','273','1',1,'Retail Sale Id 6400',4001.44,0.00,0.00,5.62,376.54,'2022-07-27 09:45:56','',''),(6388,'1','273','1',1,'Retail Sale Id 6401',79920.00,0.00,0.00,120.00,2520.00,'2022-07-27 09:50:09','',''),(6389,'1','273','1',1,'Retail Sale Id 6402',79920.00,0.00,0.00,120.00,2520.00,'2022-07-27 09:50:52','',''),(6390,'1','273','1',1,'Retail Sale Id 6403',24975.00,0.00,0.00,37.50,787.50,'2022-07-27 10:09:32','',''),(6391,'1','273','1',1,'Retail Sale Id 6404',3560.00,0.00,0.00,5.00,335.00,'2022-07-27 10:16:30','',''),(6392,'1','273','1',1,'Retail Sale Id 6405',8900.00,0.00,0.00,12.50,837.50,'2022-07-27 10:34:05','',''),(6393,'1','273','1',1,'Retail Sale Id 6406',996.80,0.00,0.00,1.40,93.80,'2022-07-27 10:34:49','',''),(6394,'1','273','1',1,'Retail Sale Id 6407',3330.00,0.00,0.00,5.00,105.00,'2022-07-27 10:35:41','',''),(6395,'1','273','1',1,'Retail Sale Id 6408',66600.00,0.00,0.00,100.00,2100.00,'2022-07-27 10:37:36','',''),(6396,'1','273','1',1,'Retail Sale Id 6409',73260.00,0.00,0.00,110.00,2310.00,'2022-07-27 10:41:36','',''),(6397,'1','273','1',1,'Retail Sale Id 6410',66600.00,0.00,0.00,100.00,2100.00,'2022-07-27 10:42:53','',''),(6398,'1','273','1',1,'Retail Sale Id 6411',133200.00,0.00,0.00,200.00,4200.00,'2022-07-27 10:45:19','',''),(6399,'1','273','1',1,'Retail Sale Id 6412',99900.00,0.00,0.00,150.00,3150.00,'2022-07-27 10:46:02','',''),(6400,'1','273','1',1,'Retail Sale Id 6413',996.80,0.00,0.00,1.40,93.80,'2022-07-27 10:46:55','',''),(6401,'1','273','1',1,'Retail Sale Id 6414',4279.12,0.00,0.00,6.01,402.67,'2022-07-27 11:06:21','',''),(6402,'1','273','1',1,'Retail Sale Id 6415',1203.28,0.00,0.00,1.69,113.23,'2022-07-27 11:07:49','',''),(6403,'1','273','1',1,'Retail Sale Id 6416',747.60,0.00,0.00,1.05,70.35,'2022-07-27 11:08:38','',''),(6404,'1','273','1',1,'Retail Sale Id 6417',33300.00,0.00,0.00,50.00,1050.00,'2022-07-27 11:14:29','',''),(6405,'1','273','1',1,'Retail Sale Id 6418',3560.00,0.00,0.00,5.00,335.00,'2022-07-27 11:33:10','',''),(6406,'1','273','1',1,'Retail Sale Id 6419',2848.00,0.00,0.00,4.00,268.00,'2022-07-27 11:37:40','',''),(6407,'1','273','1',1,'Retail Sale Id 6420',2150.24,0.00,0.00,3.02,202.34,'2022-07-27 11:39:04','',''),(6408,'1','273','1',1,'Retail Sale Id 6421',16376.00,0.00,0.00,23.00,1541.00,'2022-07-27 11:41:09','',''),(6409,'1','273','1',1,'Retail Sale Id 6422',11392.00,0.00,0.00,16.00,1072.00,'2022-07-27 11:43:30','',''),(6410,'1','273','1',1,'Retail Sale Id 6423',4300.48,0.00,0.00,6.04,404.68,'2022-07-27 11:45:00','',''),(6411,'1','273','1',1,'Retail Sale Id 6424',2997.52,0.00,0.00,4.21,282.07,'2022-07-27 11:47:54','',''),(6412,'1','273','1',1,'Retail Sale Id 6425',4300.48,0.00,0.00,6.04,404.68,'2022-07-27 11:51:44','',''),(6413,'1','273','1',1,'Retail Sale Id 6426',747.60,0.00,0.00,1.05,70.35,'2022-07-27 12:01:16','',''),(6414,'1','273','1',1,'Retail Sale Id 6427',2150.24,0.00,0.00,3.02,202.34,'2022-07-27 12:10:28','',''),(6415,'1','273','1',1,'Retail Sale Id 6428',33300.00,0.00,0.00,50.00,1050.00,'2022-07-27 12:17:24','',''),(6416,'1','273','1',1,'Retail Sale Id 6429',6660.00,0.00,0.00,10.00,210.00,'2022-07-27 12:18:57','',''),(6417,'1','273','1',1,'Retail Sale Id 6430',39960.00,0.00,0.00,60.00,1260.00,'2022-07-27 12:20:41','',''),(6418,'1','273','1',1,'Retail Sale Id 6431',66600.00,0.00,0.00,100.00,2100.00,'2022-07-27 12:57:34','',''),(6419,'1','273','1',1,'Retail Sale Id 6432',66600.00,0.00,0.00,100.00,2100.00,'2022-07-27 12:58:29','',''),(6420,'1','273','1',1,'Retail Sale Id 6433',41625.00,0.00,0.00,62.50,1312.50,'2022-07-27 13:15:28','',''),(6421,'1','273','1',1,'Retail Sale Id 6434',2150.24,0.00,0.00,3.02,202.34,'2022-07-27 13:16:29','',''),(6422,'1','273','1',1,'Retail Sale Id 6435',2150.24,0.00,0.00,3.02,202.34,'2022-07-27 13:40:42','',''),(6423,'1','273','1',1,'Retail Sale Id 6436',299700.00,0.00,0.00,450.00,9450.00,'2022-07-27 13:44:33','',''),(6424,'1','273','1',1,'Retail Sale Id 6437',299700.00,0.00,0.00,450.00,9450.00,'2022-07-27 13:45:15','',''),(6425,'1','273','1',1,'Retail Sale Id 6438',2200.08,0.00,0.00,3.09,207.03,'2022-07-27 13:52:54','',''),(6426,'1','273','1',1,'Retail Sale Id 6439',133200.00,0.00,0.00,200.00,4200.00,'2022-07-27 13:55:55','',''),(6427,'1','273','1',1,'Retail Sale Id 6440',29970.00,0.00,0.00,45.00,945.00,'2022-07-27 13:59:38','',''),(6428,'1','273','1',1,'Retail Sale Id 6441',32634.00,0.00,0.00,49.00,1029.00,'2022-07-27 14:02:05','',''),(6429,'1','273','1',1,'Retail Sale Id 6442',2150.24,0.00,0.00,3.02,202.34,'2022-07-27 14:05:36','',''),(6430,'1','273','1',1,'Retail Sale Id 6443',4300.48,0.00,0.00,6.04,404.68,'2022-07-27 14:08:03','',''),(6431,'1','273','1',1,'Retail Sale Id 6444',747.60,0.00,0.00,1.05,70.35,'2022-07-27 14:14:31','',''),(6432,'1','273','1',1,'Retail Sale Id 6445',65268.00,0.00,0.00,98.00,2058.00,'2022-07-27 14:16:23','',''),(6433,'1','273','1',1,'Retail Sale Id 6446',65268.00,0.00,0.00,98.00,2058.00,'2022-07-27 14:17:30','',''),(6434,'1','273','1',1,'Retail Sale Id 6447',747.60,0.00,0.00,1.05,70.35,'2022-07-27 14:32:00','',''),(6435,'1','273','1',1,'Retail Sale Id 6448',33300.00,0.00,0.00,50.00,1050.00,'2022-07-27 14:34:40','',''),(6436,'1','273','1',1,'Retail Sale Id 6449',1424.00,0.00,0.00,2.00,134.00,'2022-07-27 14:39:30','',''),(6437,'1','273','1',1,'Retail Sale Id 6450',4279.12,0.00,0.00,6.01,402.67,'2022-07-27 14:42:42','',''),(6438,'1','273','1',1,'Retail Sale Id 6452',4499.84,0.00,0.00,6.32,423.44,'2022-07-27 14:55:08','',''),(6439,'1','273','1',1,'Retail Sale Id 6453',2150.24,0.00,0.00,3.02,202.34,'2022-07-27 14:56:41','',''),(6440,'1','273','1',1,'Retail Sale Id 6454',1452.48,0.00,0.00,2.04,136.68,'2022-07-27 14:57:51','',''),(6441,'1','273','1',1,'Retail Sale Id 6455',9996.48,0.00,0.00,14.04,940.68,'2022-07-27 15:04:32','',''),(6442,'1','273','1',1,'Return of Retail Sale Id 6455',0.00,9996.48,14.04,0.00,-940.68,'2022-07-27 15:08:02','',''),(6443,'1','273','1',1,'Retail Sale Id 6456',9263.12,0.00,0.00,13.01,871.67,'2022-07-27 15:09:20','',''),(6444,'1','273','1',1,'Retail Sale Id 6457',747.60,0.00,0.00,1.05,70.35,'2022-07-27 15:12:52','',''),(6445,'1','273','1',1,'Retail Sale Id 6458',3602.72,0.00,0.00,5.06,339.02,'2022-07-27 15:24:20','',''),(6446,'1','273','1',1,'Retail Sale Id 6459',996.80,0.00,0.00,1.40,93.80,'2022-07-27 15:25:20','',''),(6447,'1','273','1',1,'Retail Sale Id 6460',996.80,0.00,0.00,1.40,93.80,'2022-07-27 15:55:39','',''),(6448,'1','273','1',1,'Retail Sale Id 6461',1452.48,0.00,0.00,2.04,136.68,'2022-07-27 17:15:28','',''),(6449,'1','273','1',1,'Retail Sale Id 6462',719.12,0.00,0.00,1.01,67.67,'2022-07-27 17:20:01','',''),(6450,'1','273','1',1,'Retail Sale Id 6463',1452.48,0.00,0.00,2.04,136.68,'2022-07-27 17:40:03','',''),(6451,'1','273','1',1,'Retail Sale Id 6464',4998.24,0.00,0.00,7.02,470.34,'2022-07-27 17:42:13','',''),(6452,'1','273','1',1,'Retail Sale Id 6465',719.12,0.00,0.00,1.01,67.67,'2022-07-27 17:47:37','',''),(6453,'1','273','1',1,'Retail Sale Id 6466',996.80,0.00,0.00,1.40,93.80,'2022-07-27 17:55:41','',''),(6454,'1','273','1',1,'Retail Sale Id 6467',996.80,0.00,0.00,1.40,93.80,'2022-07-27 17:57:54','',''),(6455,'1','273','1',1,'Retail Sale Id 6468',206.48,0.00,0.00,0.29,19.43,'2022-07-27 18:28:37','',''),(6456,'1','273','1',1,'Return of Retail Sale Id 6428',0.00,33300.00,50.00,0.00,-1050.00,'2022-07-27 18:31:00','',''),(6457,'1','273','1',1,'Retail Sale Id 6469',32634.00,0.00,0.00,49.00,1029.00,'2022-07-27 18:32:19','',''),(6458,'1','273','1',1,'Retail Sale Id 6470',66600.00,0.00,0.00,100.00,2100.00,'2022-07-28 07:04:13','',''),(6459,'1','273','1',1,'Retail Sale Id 6471',99900.00,0.00,0.00,150.00,3150.00,'2022-07-28 07:05:30','',''),(6460,'1','273','1',1,'Retail Sale Id 6472',66600.00,0.00,0.00,100.00,2100.00,'2022-07-28 07:06:47','',''),(6461,'1','273','1',1,'Retail Sale Id 6473',45954.00,0.00,0.00,69.00,1449.00,'2022-07-28 07:07:35','',''),(6462,'1','273','1',1,'Retail Sale Id 6474',99900.00,0.00,0.00,150.00,3150.00,'2022-07-28 07:11:02','',''),(6463,'1','273','1',1,'Retail Sale Id 6475',2000.72,0.00,0.00,2.81,188.27,'2022-07-28 07:12:02','',''),(6464,'1','273','1',1,'Retail Sale Id 6476',2997.52,0.00,0.00,4.21,282.07,'2022-07-28 07:15:42','',''),(6465,'1','273','1',1,'Retail Sale Id 6477',99900.00,0.00,0.00,150.00,3150.00,'2022-07-28 07:23:27','',''),(6466,'1','273','1',1,'Retail Sale Id 6478',66600.00,0.00,0.00,100.00,2100.00,'2022-07-28 07:24:03','',''),(6467,'1','273','1',1,'Retail Sale Id 6479',1502.32,0.00,0.00,2.11,141.37,'2022-07-28 07:25:09','',''),(6468,'1','273','1',1,'Retail Sale Id 6480',996.80,0.00,0.00,1.40,93.80,'2022-07-28 07:31:01','',''),(6469,'1','273','1',1,'Retail Sale Id 6481',1203.28,0.00,0.00,1.69,113.23,'2022-07-28 07:32:20','',''),(6470,'1','273','1',1,'Retail Sale Id 6482',38628.00,0.00,0.00,58.00,1218.00,'2022-07-28 07:38:30','',''),(6471,'1','273','1',1,'Retail Sale Id 6483',996.80,0.00,0.00,1.40,93.80,'2022-07-28 07:44:21','',''),(6472,'1','273','1',1,'Retail Sale Id 6484',2997.52,0.00,0.00,4.21,282.07,'2022-07-28 07:48:50','',''),(6473,'1','273','1',1,'Retail Sale Id 6485',119880.00,0.00,0.00,180.00,3780.00,'2022-07-28 07:58:26','',''),(6474,'1','273','1',1,'Retail Sale Id 6486',79920.00,0.00,0.00,120.00,2520.00,'2022-07-28 07:59:10','',''),(6475,'1','273','1',1,'Retail Sale Id 6487',996.80,0.00,0.00,1.40,93.80,'2022-07-28 07:59:58','',''),(6476,'1','273','1',1,'Retail Sale Id 6488',3560.00,0.00,0.00,5.00,335.00,'2022-07-28 08:00:57','',''),(6477,'1','273','1',1,'Retail Sale Id 6489',5696.00,0.00,0.00,8.00,536.00,'2022-07-28 08:02:34','',''),(6478,'1','273','1',1,'Retail Sale Id 6490',7120.00,0.00,0.00,10.00,670.00,'2022-07-28 08:17:01','',''),(6479,'1','273','1',1,'Retail Sale Id 6491',8900.00,0.00,0.00,12.50,837.50,'2022-07-28 08:17:55','',''),(6480,'1','273','1',1,'Retail Sale Id 6492',2200.08,0.00,0.00,3.09,207.03,'2022-07-28 08:18:47','',''),(6481,'1','273','1',1,'Retail Sale Id 6493',2150.24,0.00,0.00,3.02,202.34,'2022-07-28 08:19:48','',''),(6482,'1','273','1',1,'Retail Sale Id 6494',2000.72,0.00,0.00,2.81,188.27,'2022-07-28 08:20:33','',''),(6483,'1','273','1',1,'Retail Sale Id 6495',2499.12,0.00,0.00,3.51,235.17,'2022-07-28 08:33:10','',''),(6484,'1','273','1',1,'Retail Sale Id 6496',2848.00,0.00,0.00,4.00,268.00,'2022-07-28 08:34:29','',''),(6485,'1','273','1',1,'Retail Sale Id 6497',33300.00,0.00,0.00,50.00,1050.00,'2022-07-28 08:38:14','',''),(6486,'1','273','1',1,'Retail Sale Id 6498',33300.00,0.00,0.00,50.00,1050.00,'2022-07-28 08:40:36','',''),(6487,'1','273','1',1,'Retail Sale Id 6499',1452.48,0.00,0.00,2.04,136.68,'2022-07-28 08:48:06','',''),(6488,'1','273','1',1,'Retail Sale Id 6500',4998.24,0.00,0.00,7.02,470.34,'2022-07-28 08:54:35','',''),(6489,'1','273','1',1,'Retail Sale Id 6501',79920.00,0.00,0.00,120.00,2520.00,'2022-07-28 08:58:19','',''),(6490,'1','273','1',1,'Retail Sale Id 6502',2997.52,0.00,0.00,4.21,282.07,'2022-07-28 08:59:19','',''),(6491,'1','273','1',1,'Retail Sale Id 6503',4300.48,0.00,0.00,6.04,404.68,'2022-07-28 09:00:55','',''),(6492,'1','273','1',1,'Retail Sale Id 6504',3560.00,0.00,0.00,5.00,335.00,'2022-07-28 09:02:57','',''),(6493,'1','273','1',1,'Retail Sale Id 6505',8900.00,0.00,0.00,12.50,837.50,'2022-07-28 09:04:30','',''),(6494,'1','273','1',1,'Retail Sale Id 6506',2150.24,0.00,0.00,3.02,202.34,'2022-07-28 09:13:00','',''),(6495,'1','273','1',1,'Retail Sale Id 6507',3560.00,0.00,0.00,5.00,335.00,'2022-07-28 09:18:33','',''),(6496,'1','273','1',1,'Retail Sale Id 6508',4001.44,0.00,0.00,5.62,376.54,'2022-07-28 09:19:41','',''),(6497,'1','273','1',1,'Retail Sale Id 6509',2150.24,0.00,0.00,3.02,202.34,'2022-07-28 09:22:07','',''),(6498,'1','273','1',1,'Retail Sale Id 6510',8900.00,0.00,0.00,12.50,837.50,'2022-07-28 09:27:44','',''),(6499,'1','273','1',1,'Retail Sale Id 6511',2150.24,0.00,0.00,3.02,202.34,'2022-07-28 09:29:08','',''),(6500,'1','273','1',1,'Retail Sale Id 6512',1452.48,0.00,0.00,2.04,136.68,'2022-07-28 09:32:38','',''),(6501,'1','273','1',1,'Retail Sale Id 6513',2000.72,0.00,0.00,2.81,188.27,'2022-07-28 09:36:21','',''),(6502,'1','273','1',1,'Retail Sale Id 6514',166500.00,0.00,0.00,250.00,5250.00,'2022-07-28 09:42:58','',''),(6503,'1','273','1',1,'Retail Sale Id 6515',201798.00,0.00,0.00,303.00,6363.00,'2022-07-28 09:44:18','',''),(6504,'1','273','1',1,'Retail Sale Id 6516',13320.00,0.00,0.00,20.00,420.00,'2022-07-28 09:48:22','',''),(6505,'1','273','1',1,'Retail Sale Id 6517',8900.00,0.00,0.00,12.50,837.50,'2022-07-28 09:49:26','',''),(6506,'1','273','1',1,'Retail Sale Id 6518',4998.24,0.00,0.00,7.02,470.34,'2022-07-28 09:52:38','',''),(6507,'1','273','1',1,'Retail Sale Id 6519',3503.04,0.00,0.00,4.92,329.64,'2022-07-28 09:53:53','',''),(6508,'1','273','1',1,'Retail Sale Id 6520',66600.00,0.00,0.00,100.00,2100.00,'2022-07-28 09:55:56','',''),(6509,'1','273','1',1,'Retail Sale Id 6521',25308.00,0.00,0.00,38.00,798.00,'2022-07-28 09:58:08','',''),(6510,'1','273','1',1,'Retail Sale Id 6522',33300.00,0.00,0.00,50.00,1050.00,'2022-07-28 10:00:58','',''),(6511,'1','273','1',1,'Retail Sale Id 6523',2997.52,0.00,0.00,4.21,282.07,'2022-07-28 10:02:56','',''),(6512,'1','273','1',1,'Retail Sale Id 6524',33300.00,0.00,0.00,50.00,1050.00,'2022-07-28 10:05:31','',''),(6513,'1','273','1',1,'Retail Sale Id 6525',39960.00,0.00,0.00,60.00,1260.00,'2022-07-28 10:06:21','',''),(6514,'1','273','1',1,'Retail Sale Id 6526',4300.48,0.00,0.00,6.04,404.68,'2022-07-28 10:11:55','',''),(6515,'1','273','1',1,'Retail Sale Id 6527',133200.00,0.00,0.00,200.00,4200.00,'2022-07-28 10:14:16','',''),(6516,'1','273','1',1,'Retail Sale Id 6528',99900.00,0.00,0.00,150.00,3150.00,'2022-07-28 10:15:00','',''),(6517,'1','273','1',1,'Retail Sale Id 6529',8900.00,0.00,0.00,12.50,837.50,'2022-07-28 10:22:59','',''),(6518,'1','273','1',1,'Retail Sale Id 6530',747.60,0.00,0.00,1.05,70.35,'2022-07-28 10:23:52','',''),(6519,'1','273','1',1,'Retail Sale Id 6531',747.60,0.00,0.00,1.05,70.35,'2022-07-28 10:24:48','',''),(6520,'1','273','1',1,'Retail Sale Id 6532',11322.00,0.00,0.00,17.00,357.00,'2022-07-28 10:27:26','',''),(6521,'1','273','1',1,'Retail Sale Id 6533',2136.00,0.00,0.00,3.00,201.00,'2022-07-28 10:28:52','',''),(6522,'1','273','1',1,'Retail Sale Id 6534',155178.00,0.00,0.00,233.00,4893.00,'2022-07-28 10:38:07','',''),(6523,'1','273','1',1,'Retail Sale Id 6535',139194.00,0.00,0.00,209.00,4389.00,'2022-07-28 10:38:57','',''),(6524,'1','273','1',1,'Retail Sale Id 6536',3602.72,0.00,0.00,5.06,339.02,'2022-07-28 10:44:09','',''),(6525,'1','273','1',1,'Retail Sale Id 6537',51282.00,0.00,0.00,77.00,1617.00,'2022-07-28 10:48:20','',''),(6526,'1','273','1',1,'Retail Sale Id 6538',14652.00,0.00,0.00,22.00,462.00,'2022-07-28 10:52:30','',''),(6527,'1','273','1',1,'Retail Sale Id 6539',4300.48,0.00,0.00,6.04,404.68,'2022-07-28 10:57:09','',''),(6528,'1','273','1',1,'Retail Sale Id 6540',57276.00,0.00,0.00,86.00,1806.00,'2022-07-28 11:02:54','',''),(6529,'1','273','1',1,'Retail Sale Id 6541',33300.00,0.00,0.00,50.00,1050.00,'2022-07-28 11:03:45','',''),(6530,'1','273','1',1,'Retail Sale Id 6542',8900.00,0.00,0.00,12.50,837.50,'2022-07-28 11:12:05','',''),(6531,'1','273','1',1,'Retail Sale Id 6544',1452.48,0.00,0.00,2.04,136.68,'2022-07-28 11:30:15','',''),(6532,'1','273','1',1,'Retail Sale Id 6545',8900.00,0.00,0.00,12.50,837.50,'2022-07-28 11:41:43','',''),(6533,'1','273','1',1,'Retail Sale Id 6546',79920.00,0.00,0.00,120.00,2520.00,'2022-07-28 11:43:27','',''),(6534,'1','273','1',1,'Retail Sale Id 6547',163170.00,0.00,0.00,245.00,5145.00,'2022-07-28 11:47:27','',''),(6535,'1','273','1',1,'Retail Sale Id 6548',65268.00,0.00,0.00,98.00,2058.00,'2022-07-28 11:48:35','',''),(6536,'1','273','1',1,'Retail Sale Id 6549',7148.48,0.00,0.00,10.04,672.68,'2022-07-28 12:03:18','',''),(6537,'1','273','1',1,'Retail Sale Id 6550',39960.00,0.00,0.00,60.00,1260.00,'2022-07-28 12:04:17','',''),(6538,'1','273','1',1,'Retail Sale Id 6551',33300.00,0.00,0.00,50.00,1050.00,'2022-07-28 12:05:25','',''),(6539,'1','273','1',1,'Retail Sale Id 6552',25308.00,0.00,0.00,38.00,798.00,'2022-07-28 12:32:09','',''),(6540,'1','273','1',1,'Retail Sale Id 6553',3560.00,0.00,0.00,5.00,335.00,'2022-07-28 12:34:58','',''),(6541,'1','273','1',1,'Retail Sale Id 6554',996.80,0.00,0.00,1.40,93.80,'2022-07-28 12:39:30','',''),(6542,'1','273','1',1,'Retail Sale Id 6555',3503.04,0.00,0.00,4.92,329.64,'2022-07-28 12:45:00','',''),(6543,'1','273','1',1,'Retail Sale Id 6556',16650.00,0.00,0.00,25.00,525.00,'2022-07-28 12:58:04','',''),(6544,'1','273','1',1,'Retail Sale Id 6557',719.12,0.00,0.00,1.01,67.67,'2022-07-28 12:59:05','',''),(6545,'1','273','1',1,'Retail Sale Id 6558',4984.00,0.00,0.00,7.00,469.00,'2022-07-28 13:03:52','',''),(6546,'1','273','1',1,'Retail Sale Id 6559',7120.00,0.00,0.00,10.00,670.00,'2022-07-28 13:05:26','',''),(6547,'1','273','1',1,'Retail Sale Id 6560',66600.00,0.00,0.00,100.00,2100.00,'2022-07-28 13:07:11','',''),(6548,'1','273','1',1,'Retail Sale Id 6561',99900.00,0.00,0.00,150.00,3150.00,'2022-07-28 13:12:25','',''),(6549,'1','273','1',1,'Retail Sale Id 6562',66600.00,0.00,0.00,100.00,2100.00,'2022-07-28 13:18:54','',''),(6550,'1','273','1',1,'Retail Sale Id 6563',2000.72,0.00,0.00,2.81,188.27,'2022-07-28 13:28:40','',''),(6551,'1','273','1',1,'Retail Sale Id 6564',996.80,0.00,0.00,1.40,93.80,'2022-07-28 13:29:25','',''),(6552,'1','273','1',1,'Retail Sale Id 6565',2848.00,0.00,0.00,4.00,268.00,'2022-07-28 13:32:59','',''),(6553,'1','273','1',1,'Retail Sale Id 6566',996.80,0.00,0.00,1.40,93.80,'2022-07-28 13:39:02','',''),(6554,'1','273','1',1,'Retail Sale Id 6567',2798.16,0.00,0.00,3.93,263.31,'2022-07-28 13:54:21','',''),(6555,'1','273','1',1,'Retail Sale Id 6568',8900.00,0.00,0.00,12.50,837.50,'2022-07-28 13:56:58','',''),(6556,'1','273','1',1,'Retail Sale Id 6569',1302.96,0.00,0.00,1.83,122.61,'2022-07-28 13:58:22','',''),(6557,'1','273','1',1,'Retail Sale Id 6570',1502.32,0.00,0.00,2.11,141.37,'2022-07-28 14:03:23','',''),(6558,'1','273','1',1,'Retail Sale Id 6571',747.60,0.00,0.00,1.05,70.35,'2022-07-28 14:04:37','',''),(6559,'1','273','1',1,'Retail Sale Id 6572',1452.48,0.00,0.00,2.04,136.68,'2022-07-28 14:09:03','',''),(6560,'1','273','1',1,'Retail Sale Id 6573',797.44,0.00,0.00,1.12,75.04,'2022-07-28 14:11:09','',''),(6561,'1','273','1',1,'Retail Sale Id 6574',1452.48,0.00,0.00,2.04,136.68,'2022-07-28 14:17:08','',''),(6562,'1','273','1',1,'Retail Sale Id 6575',996.80,0.00,0.00,1.40,93.80,'2022-07-28 14:27:33','',''),(6563,'1','273','1',1,'Retail Sale Id 6576',33300.00,0.00,0.00,50.00,1050.00,'2022-07-28 14:37:34','',''),(6564,'1','273','1',1,'Retail Sale Id 6577',56610.00,0.00,0.00,85.00,1785.00,'2022-07-28 14:39:47','',''),(6565,'1','273','1',1,'Retail Sale Id 6578',8002.88,0.00,0.00,11.24,753.08,'2022-07-28 14:44:12','',''),(6566,'1','273','1',1,'Retail Sale Id 6579',1452.48,0.00,0.00,2.04,136.68,'2022-07-28 14:49:20','',''),(6567,'1','273','1',1,'Retail Sale Id 6581',8551.12,0.00,0.00,12.01,804.67,'2022-07-28 14:58:21','',''),(6568,'1','273','1',1,'Retail Sale Id 6582',1502.32,0.00,0.00,2.11,141.37,'2022-07-28 14:59:46','',''),(6569,'1','273','1',1,'Retail Sale Id 6583',1452.48,0.00,0.00,2.04,136.68,'2022-07-28 15:01:42','',''),(6570,'1','273','1',1,'Retail Sale Id 6584',996.80,0.00,0.00,1.40,93.80,'2022-07-28 15:02:34','',''),(6571,'1','273','1',1,'Retail Sale Id 6585',139860.00,0.00,0.00,210.00,4410.00,'2022-07-28 15:14:28','',''),(6572,'1','273','1',1,'Retail Sale Id 6586',133200.00,0.00,0.00,200.00,4200.00,'2022-07-28 15:15:18','',''),(6573,'1','273','1',1,'Retail Sale Id 6587',66600.00,0.00,0.00,100.00,2100.00,'2022-07-28 15:16:13','',''),(6574,'1','273','1',1,'Retail Sale Id 6588',99900.00,0.00,0.00,150.00,3150.00,'2022-07-28 15:31:39','',''),(6575,'1','273','1',1,'Retail Sale Id 6589',1302.96,0.00,0.00,1.83,122.61,'2022-07-28 15:32:39','',''),(6576,'1','273','1',1,'Retail Sale Id 6590',8900.00,0.00,0.00,12.50,837.50,'2022-07-28 15:36:15','',''),(6577,'1','273','1',1,'Retail Sale Id 6591',66600.00,0.00,0.00,100.00,2100.00,'2022-07-28 15:37:27','',''),(6578,'1','273','1',1,'Retail Sale Id 6592',797.44,0.00,0.00,1.12,75.04,'2022-07-28 15:38:15','',''),(6579,'1','273','1',1,'Retail Sale Id 6593',1452.48,0.00,0.00,2.04,136.68,'2022-07-28 15:42:24','',''),(6580,'1','273','1',1,'Retail Sale Id 6594',2157.36,0.00,0.00,3.03,203.01,'2022-07-28 15:55:23','',''),(6581,'1','273','1',1,'Retail Sale Id 6595',797.44,0.00,0.00,1.12,75.04,'2022-07-28 16:00:41','',''),(6582,'1','273','1',1,'Retail Sale Id 6596',797.44,0.00,0.00,1.12,75.04,'2022-07-28 16:06:54','',''),(6583,'1','273','1',1,'Retail Sale Id 6597',7120.00,0.00,0.00,10.00,670.00,'2022-07-28 16:39:51','',''),(6584,'1','273','1',1,'Retail Sale Id 6598',1502.32,0.00,0.00,2.11,141.37,'2022-07-28 16:44:07','',''),(6585,'1','273','1',1,'Retail Sale Id 6599',2150.24,0.00,0.00,3.02,202.34,'2022-07-28 16:46:04','',''),(6586,'1','273','1',1,'Retail Sale Id 6600',2150.24,0.00,0.00,3.02,202.34,'2022-07-28 16:49:12','',''),(6587,'1','273','1',1,'Retail Sale Id 6601',2150.24,0.00,0.00,3.02,202.34,'2022-07-28 16:49:51','',''),(6588,'1','273','1',1,'Retail Sale Id 6602',1502.32,0.00,0.00,2.11,141.37,'2022-07-28 16:54:34','',''),(6589,'1','273','1',1,'Retail Sale Id 6603',719.12,0.00,0.00,1.01,67.67,'2022-07-28 16:55:31','',''),(6590,'1','273','1',1,'Retail Sale Id 6604',33300.00,0.00,0.00,50.00,1050.00,'2022-07-28 16:57:56','',''),(6591,'1','273','1',1,'Retail Sale Id 6605',4300.48,0.00,0.00,6.04,404.68,'2022-07-28 17:02:16','',''),(6592,'1','273','1',1,'Retail Sale Id 6606',2997.52,0.00,0.00,4.21,282.07,'2022-07-28 17:03:02','',''),(6593,'1','273','1',1,'Retail Sale Id 6607',996.80,0.00,0.00,1.40,93.80,'2022-07-28 17:03:45','',''),(6594,'1','273','1',1,'Retail Sale Id 6608',8900.00,0.00,0.00,12.50,837.50,'2022-07-28 17:04:47','',''),(6595,'1','273','1',1,'Retail Sale Id 6609',33300.00,0.00,0.00,50.00,1050.00,'2022-07-28 17:05:44','',''),(6596,'1','273','1',1,'Retail Sale Id 6610',719.12,0.00,0.00,1.01,67.67,'2022-07-28 17:06:34','',''),(6597,'1','273','1',1,'Retail Sale Id 6611',23310.00,0.00,0.00,35.00,735.00,'2022-07-28 17:07:25','',''),(6598,'1','273','1',1,'Retail Sale Id 6612',4272.00,0.00,0.00,6.00,402.00,'2022-07-28 17:09:07','',''),(6599,'1','273','1',1,'Retail Sale Id 6613',4984.00,0.00,0.00,7.00,469.00,'2022-07-28 17:16:38','',''),(6600,'1','273','1',1,'Retail Sale Id 6614',66600.00,0.00,0.00,100.00,2100.00,'2022-07-28 17:21:21','',''),(6601,'1','273','1',1,'Retail Sale Id 6615',2000.72,0.00,0.00,2.81,188.27,'2022-07-28 17:23:50','',''),(6602,'1','273','1',1,'Retail Sale Id 6616',2997.52,0.00,0.00,4.21,282.07,'2022-07-28 17:30:22','',''),(6603,'1','273','1',1,'Retail Sale Id 6617',897.12,0.00,0.00,1.26,84.42,'2022-07-28 17:37:15','',''),(6604,'1','273','1',1,'Retail Sale Id 6618',697.76,0.00,0.00,0.98,65.66,'2022-07-28 17:42:07','',''),(6605,'1','273','1',1,'Retail Sale Id 6619',2848.00,0.00,0.00,4.00,268.00,'2022-07-28 17:43:45','',''),(6606,'1','273','1',1,'Retail Sale Id 6620',747.60,0.00,0.00,1.05,70.35,'2022-07-28 17:56:51','',''),(6607,'1','273','1',1,'Retail Sale Id 6621',2997.52,0.00,0.00,4.21,282.07,'2022-07-28 18:00:53','',''),(6608,'1','273','1',1,'Retail Sale Id 6622',1502.32,0.00,0.00,2.11,141.37,'2022-07-28 18:02:16','',''),(6609,'1','273','1',1,'Retail Sale Id 6623',1871.46,0.00,0.00,2.81,59.01,'2022-07-28 18:34:41','',''),(6610,'1','273','1',1,'Retail Sale Id 6625',58608.00,0.00,0.00,88.00,1848.00,'2022-07-29 06:53:46','',''),(6611,'1','273','1',1,'Retail Sale Id 6626',32634.00,0.00,0.00,49.00,1029.00,'2022-07-29 06:56:18','',''),(6612,'1','273','1',1,'Retail Sale Id 6627',2136.00,0.00,0.00,3.00,201.00,'2022-07-29 07:00:10','',''),(6613,'1','273','1',1,'Retail Sale Id 6629',1452.48,0.00,0.00,2.04,136.68,'2022-07-29 07:21:06','',''),(6614,'1','273','1',1,'Retail Sale Id 6630',66600.00,0.00,0.00,100.00,2100.00,'2022-07-29 07:25:57','',''),(6615,'1','273','1',1,'Retail Sale Id 6631',99900.00,0.00,0.00,150.00,3150.00,'2022-07-29 07:28:17','',''),(6616,'1','273','1',1,'Retail Sale Id 6632',2997.52,0.00,0.00,4.21,282.07,'2022-07-29 07:29:58','',''),(6617,'1','273','1',1,'Retail Sale Id 6633',49284.00,0.00,0.00,74.00,1554.00,'2022-07-29 07:41:18','',''),(6618,'1','273','1',1,'Retail Sale Id 6634',33300.00,0.00,0.00,50.00,1050.00,'2022-07-29 07:42:00','',''),(6619,'1','273','1',1,'Retail Sale Id 6635',3602.72,0.00,0.00,5.06,339.02,'2022-07-29 07:43:39','',''),(6620,'1','273','1',1,'Retail Sale Id 6636',2897.84,0.00,0.00,4.07,272.69,'2022-07-29 07:50:47','',''),(6621,'1','273','1',1,'Retail Sale Id 6637',4998.24,0.00,0.00,7.02,470.34,'2022-07-29 07:51:59','',''),(6622,'1','273','1',1,'Retail Sale Id 6638',3560.00,0.00,0.00,5.00,335.00,'2022-07-29 08:01:11','',''),(6623,'1','273','1',1,'Retail Sale Id 6639',2150.24,0.00,0.00,3.02,202.34,'2022-07-29 08:02:49','',''),(6624,'1','273','1',1,'Retail Sale Id 6640',8900.00,0.00,0.00,12.50,837.50,'2022-07-29 08:03:53','',''),(6625,'1','273','1',1,'Retail Sale Id 6641',1943.76,0.00,0.00,2.73,182.91,'2022-07-29 08:12:44','',''),(6626,'1','273','1',1,'Retail Sale Id 6642',1452.48,0.00,0.00,2.04,136.68,'2022-07-29 08:14:51','',''),(6627,'1','273','1',1,'Retail Sale Id 6643',3552.88,0.00,0.00,4.99,334.33,'2022-07-29 08:18:42','',''),(6628,'1','273','1',1,'Retail Sale Id 6644',1452.48,0.00,0.00,2.04,136.68,'2022-07-29 08:21:26','',''),(6629,'1','273','1',1,'Retail Sale Id 6645',747.60,0.00,0.00,1.05,70.35,'2022-07-29 08:27:33','',''),(6630,'1','273','1',1,'Retail Sale Id 6646',4998.24,0.00,0.00,7.02,470.34,'2022-07-29 08:28:31','',''),(6631,'1','273','1',1,'Retail Sale Id 6647',99900.00,0.00,0.00,150.00,3150.00,'2022-07-29 08:39:29','',''),(6632,'1','273','1',1,'Retail Sale Id 6648',66600.00,0.00,0.00,100.00,2100.00,'2022-07-29 08:39:58','',''),(6633,'1','273','1',1,'Retail Sale Id 6649',10680.00,0.00,0.00,15.00,1005.00,'2022-07-29 09:21:45','',''),(6634,'1','273','1',1,'Retail Sale Id 6650',2200.08,0.00,0.00,3.09,207.03,'2022-07-29 09:33:34','',''),(6635,'1','273','1',1,'Retail Sale Id 6651',3330.00,0.00,0.00,5.00,105.00,'2022-07-29 09:41:30','',''),(6636,'1','273','1',1,'Retail Sale Id 6652',8002.88,0.00,0.00,11.24,753.08,'2022-07-29 09:54:14','',''),(6637,'1','273','1',1,'Retail Sale Id 6653',2848.00,0.00,0.00,4.00,268.00,'2022-07-29 09:55:20','',''),(6638,'1','273','1',1,'Retail Sale Id 6654',33300.00,0.00,0.00,50.00,1050.00,'2022-07-29 10:00:59','',''),(6639,'1','273','1',1,'Retail Sale Id 6655',1502.32,0.00,0.00,2.1