-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_248
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_248`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_248` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_248`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,2500,'',0,'2','1','248','ZENITH E BILLS COLL ACCT','','2022-04-20 10:51:43',5,0.00,0.00,'','178','2022-04-20 10:51:43','178',0,0),(2,7000,'',0,'20','1','248','SALES','','2022-04-20 10:52:02',5,0.00,0.00,'','178','2022-04-20 10:52:02','178',0,0),(3,500,'',0,'6.1','1','248','CASH','','2022-04-20 10:52:18',5,0.00,0.00,'','178','2022-04-20 10:52:18','178',0,0),(4,8000,'',0,'24','1','248','PURCHASES','','2022-04-20 10:53:43',5,0.00,0.00,'','178','2022-04-20 10:53:43','178',0,0),(5,8001,'',0,'24','1','248','AGO CONSUMPTION','','2022-04-20 10:54:06',5,0.00,0.00,'','178','2022-04-20 10:54:06','178',0,0),(6,8002,'',0,'24','1','248','FUELING & REPAIR OF OFFICIAL C','','2022-04-20 10:54:25',5,0.00,0.00,'','178','2022-04-20 10:54:25','178',0,0),(7,8003,'',0,'24','1','248','PRINTING & STATIONARY','','2022-04-20 10:55:52',5,0.00,0.00,'','178','2022-04-20 10:55:52','178',0,0),(8,8004,'',0,'24','1','248','STATION REPAIRS & MAINTAINANCE','','2022-04-20 10:56:09',5,0.00,0.00,'','178','2022-04-20 10:56:09','178',0,0),(9,8005,'',0,'24','1','248','PUBLIC RELATION','','2022-04-20 10:56:33',5,0.00,0.00,'','178','2022-04-20 10:56:33','178',0,0),(10,8006,'',0,'24','1','248','COMPUTER & INTERNET SUBSCRIPTI','','2022-04-20 10:56:57',5,0.00,0.00,'','178','2022-04-20 10:56:57','178',0,0),(11,8007,'',0,'24','1','248','SALARIES ','','2022-04-20 10:57:14',5,0.00,0.00,'','178','2022-04-20 10:57:14','178',0,0),(12,8008,'',0,'24','1','248','RETAIL OPERATING EXPENSES','','2022-04-20 10:57:38',5,0.00,0.00,'','178','2022-04-20 10:57:38','178',0,0),(13,1500,'',0,'5','1','248','INVENTORY VALUE ADJUSTMENT','','2022-04-20 10:58:59',5,0.00,0.00,'','178','2022-04-20 10:58:59','178',0,0),(14,2501,'',0,'2','1','248','CASH IMPREST','','2022-04-20 10:59:26',5,0.00,0.00,'','178','2022-04-20 10:59:26','178',0,0),(15,2502,'',0,'2','1','248','FIDELITY BANK POS','','2022-04-21 15:11:39',5,0.00,0.00,'','454','2022-04-21 15:11:39','454',0,0),(16,2503,'',0,'2','1','248','ECO BANK POS ','','2022-07-08 19:11:25',5,0.00,0.00,'','454','2022-07-08 19:11:25','454',0,0),(17,2504,'',0,'2','1','248','ZENITH-1227084561','','2022-12-12 17:22:35',5,0.00,0.00,'','454','2022-12-12 17:22:35','454',0,0),(18,2505,'',0,'2','1','248','MONIE POINT POS ACCOUNT','','2023-03-10 12:04:53',5,0.00,0.00,'','454','2023-03-10 12:04:53','454',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'1','248','0000-00-00','2022-05-14 18:46:49',10,'807','','0000-00-00 00:00:00','454','2022-06-28 13:58:54'),(2,'1','248','0000-00-00','2022-05-14 18:50:51',10,'807','','0000-00-00 00:00:00','454','2022-06-28 13:58:57'),(3,'1','248','0000-00-00','2022-06-07 19:18:12',10,'807','','0000-00-00 00:00:00','454','2022-06-28 13:59:01'),(5,'1','248','0000-00-00','2022-08-22 13:07:03',10,'807','','0000-00-00 00:00:00','454','2022-08-22 13:31:53'),(6,'1','248','0000-00-00','2022-08-22 13:09:22',10,'807','','0000-00-00 00:00:00','454','2022-08-22 13:32:12'),(7,'1','248','0000-00-00','2022-08-22 13:12:58',10,'807','','0000-00-00 00:00:00','454','2022-08-22 13:32:44'),(8,'1','248','0000-00-00','2022-08-22 13:14:50',10,'807','','0000-00-00 00:00:00','454','2022-08-22 13:34:05'),(9,'1','248','0000-00-00','2022-08-22 13:16:43',10,'807','','0000-00-00 00:00:00','454','2022-08-22 13:34:13'),(10,'1','248','0000-00-00','2022-08-22 13:19:43',10,'807','','0000-00-00 00:00:00','454','2022-08-22 13:34:30'),(11,'1','248','0000-00-00','2022-08-22 13:21:42',10,'807','','0000-00-00 00:00:00','454','2022-08-22 13:34:44'),(12,'1','248','0000-00-00','2022-08-22 13:23:49',10,'807','','0000-00-00 00:00:00','454','2022-08-22 13:34:57'),(13,'1','248','0000-00-00','2022-09-29 16:12:35',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(14,'1','248','0000-00-00','2022-10-09 21:15:58',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(15,'1','248','0000-00-00','2022-10-13 18:40:07',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(16,'1','248','0000-00-00','2022-10-31 11:31:51',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(17,'1','248','0000-00-00','2022-11-11 09:32:58',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(18,'1','248','0000-00-00','2022-11-19 16:30:16',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(19,'1','248','0000-00-00','2022-12-04 10:38:43',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(20,'1','248','0000-00-00','2022-12-07 21:40:56',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(21,'1','248','0000-00-00','2023-01-18 22:41:50',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(22,'1','248','0000-00-00','2023-02-01 22:18:06',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(23,'1','248','0000-00-00','2023-02-24 08:48:45',5,'807','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'1','248','1','1','supplier',750000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 675 TO 700 DIPPING (30,000 @ 25). ',0.00,'2022-05-12'),(2,'1','248','1','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 675 TO 700 DIPPING (30,000 @ 25).	',750000.00,'2022-05-12'),(3,'1','248','2','1','supplier',288000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 700 TO 720 DIPPING (14,400 @ 20). ',0.00,'2022-05-14'),(4,'1','248','2','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 700 TO 720 DIPPING (14,400 @ 20).	',288000.00,'2022-05-14'),(5,'1','248','3','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 770 TO 800 DIPING (11,300 @ 30).	',339000.00,'2022-06-07'),(6,'1','248','3','1','supplier',339000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 770 TO 800 DIPPING (11300@ 30).	',0.00,'2022-06-07'),(7,'1','248','3','1','supplier',741000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 800 TO 820 DIPPING (37,050@20).	',0.00,'2022-06-11'),(8,'1','248','3','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 800 TO 820 DIPPING (37,050 @ 20). ',741000.00,'2022-06-11'),(9,'1','248','3','1','supplier',585000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 820 TO 830 DIPPING (58500 @ 10). ',0.00,'2022-06-17'),(10,'1','248','3','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 820 TO 830 DIPPING (58500 @ 10. ',585000.00,'2022-06-17'),(31,'1','248','5','1','supplier',3000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 720 TO 740 DIPPING (150@ 20). ',0.00,'2022-05-24'),(32,'1','248','5','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 720 TO 740 DIPPING (150 @ 20). ',3000.00,'2022-05-24'),(33,'1','248','6','1','supplier',340000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 740 TO 760 DIPPING (17,000 @ 20). ',0.00,'2022-05-28'),(34,'1','248','6','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 740 TO 760 DIPPING (17,000 @ 20). ',340000.00,'2022-05-28'),(35,'1','248','7','1','supplier',253000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 760 TO 770 DIPPING (25,300 @ 10). ',0.00,'2022-06-04'),(36,'1','248','7','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 760 TO 770 DIPPING (25,300 @ 10). ',253000.00,'2022-06-04'),(37,'1','248','8','1','supplier',300000.00,'INVENTORY VALUE ADJUSTMENT OF PMS INCREAMENT FROM 165 TO 185 DIPPING (15,000 @ 20). ',0.00,'2022-07-11'),(38,'1','248','8','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF PMS INCREAMENT FROM 165 TO 185 DIPPING (15,000 @ 20). ',300000.00,'2022-07-11'),(39,'1','248','9','1','supplier',0.00,'INVENTORY VALUE ADJUSTMENT OF PMS DECREMENT FROM 185 TO 175 DIPPING (2,650 @ 10). ',26500.00,'2022-07-18'),(40,'1','248','9','13','5',26500.00,'INVENTORY VALUE ADJUSTMENT OF PMS DECREMENT FROM 185 TO 175 DIPPING (2,650 @ 10). ',0.00,'2022-07-18'),(41,'1','248','10','1','supplier',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 830 TO 820 DIPPING (56,700 @ 10). ',567000.00,'2022-07-19'),(42,'1','248','10','13','5',567000.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 830 TO 820 DIPPING (56,700 @ 10). ',0.00,'2022-07-19'),(43,'1','248','11','1','supplier',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 820 TO 810 DIPPING (49,200 @ 10). ',492000.00,'2022-07-23'),(44,'1','248','11','13','5',492000.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 820 TO 810 DIPPING (49,000 @ 10). ',0.00,'2022-07-23'),(45,'1','248','12','1','supplier',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 810 TO 800 DIPPING (38,850 @ 10). ',388500.00,'2022-08-17'),(46,'1','248','12','13','5',388500.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 810 TO 800 DIPPING (38,850 @ 10). ',0.00,'2022-08-17'),(50,'1','248','13','1','supplier',105000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 800 TO 815 DIPPING (7,000 @ 15). ',0.00,'2022-09-29'),(51,'1','248','13','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 800 TO 815 DIPPING (7,000 @ 15). ',105000.00,'2022-09-29'),(52,'1','248','14','1','supplier',262000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 815 TO 820 DIPPING (52,400 @ 5). ',0.00,'2022-10-09'),(53,'1','248','14','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 815 TO 820 DIPPING (52,400 @ 5). ',262000.00,'2022-10-09'),(54,'1','248','15','1','supplier',315000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 820 TO 830 DIPPING (31,500 @ 10). ',0.00,'2022-10-13'),(55,'1','248','15','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 820 TO 830 DIPPING (31,500 @ 10). ',315000.00,'2022-10-13'),(56,'1','248','16','1','supplier',521000.00,'INVENTORY VALUE ADJUSTMENT OF PMS INCREAMENT FROM 175 TO 185 DIPPING (52,100 @ 10). ',0.00,'2022-10-31'),(57,'1','248','16','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF PMS INCREAMENT FROM 175 TO 185 DIPPING (52,100 @ 10). ',521000.00,'2022-10-31'),(58,'1','248','17','1','supplier',183000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 830 TO 860 DIPPING (6,100 @ 30). ',0.00,'2022-11-11'),(59,'1','248','17','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 830 TO 860 DIPPING (6,100 @ 30). ',183000.00,'2022-11-11'),(60,'1','248','18','1','supplier',588000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 860 TO 880 DIPPING (29,400 @ 20). ',0.00,'2022-11-19'),(61,'1','248','18','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 860 TO 880 DIPPING (29,400 @ 20). ',588000.00,'2022-11-19'),(62,'1','248','19','1','supplier',536000.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 880 TO 900 DIPPING (26,800 @ 20). ',0.00,'2022-12-04'),(63,'1','248','19','13','5',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO INCREAMENT FROM 880 TO 900 DIPPING (26,800 @ 20). ',536000.00,'2022-12-04'),(64,'1','248','20','1','supplier',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 900 TO 880 DIPPING (18,700 @ 20). ',374000.00,'2022-12-07'),(65,'1','248','20','13','5',374000.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 900 TO 880 DIPPING (18,700 @ 20). ',0.00,'2022-12-07'),(66,'1','248','21','1','supplier',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 880 TO 870 DIPPING (32,600 @ 10). ',326000.00,'2023-01-18'),(67,'1','248','21','13','5',326000.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 880 TO 870 DIPPING (32,600 @ 10). ',0.00,'2023-01-18'),(68,'1','248','22','13','5',398000.00,'PMS INCREMENT FROM 185 TO 195 DIPPING (39,800).',0.00,'2023-02-01'),(69,'1','248','22','1','supplier',0.00,'PMS INCREMENT FROM 185 TO 195 DIPPING (39,800).',398000.00,'2023-02-01'),(70,'1','248','22','1','supplier',0.00,'AGO DECREMENT FROM 870 TO 850 DIPPING (12,550).@20',251000.00,'2023-02-01'),(71,'1','248','22','13','5',251000.00,'AGO DECREMENT FROM 870 TO 850 DIPPING (12,550).@20',0.00,'2023-02-01'),(72,'1','248','23','1','supplier',0.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 850 TO 830 DIPPING (13,650 @ 20). ',273000.00,'2023-02-24'),(73,'1','248','23','13','5',273000.00,'INVENTORY VALUE ADJUSTMENT OF AGO DECREMENT FROM 850 TO 830 DIPPING (13,650, @ 20). ',0.00,'2023-02-24');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','248','DRIVER SHORTAGE','AA RANO TRANSPORT','08035742431','info@rano.com','KANO','KANO','No 7 Maiduguri Road,Opposite NNPC Depot. Kano Nigeria','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-20 16:19:19',5,'454','2022-04-20 16:19:19','454'),(2,'','1','248','NIGERIAN POLICE FORCE (ELECTIO','PAM DAVOU','07080000619','dopstransport@gmail.com','FCT','ABUJA','NPF HEAD QUARTERS LOUIS EDET HOUSE,SHEHU SHAGARI WAY,ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 12:55:14',5,'454','2023-02-21 12:55:14','454');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','248',1,'1',11520.68,16000.00,'2022-04-23','','2022-04-23 16:18:53','611','611',2022,'611','2022-04-23 16:18:53',5),('1','248',2,'2',86.65,20000.00,'2022-05-12','','2022-05-12 19:50:23','454','454',2022,'454','2022-05-12 19:50:23',5),('1','248',3,'4',1273.26,2701.00,'2022-05-18','','2022-05-18 20:59:47','454','454',2022,'454','2022-05-18 20:59:47',5),('1','248',4,'3',6158.71,23707.00,'2022-06-02','','2022-06-02 18:52:27','611','611',2022,'611','2022-06-02 18:52:27',5),('1','248',5,'3',1.65,15031.00,'2022-06-03','','2022-06-03 08:03:14','611','611',2022,'611','2022-06-03 08:03:14',5),('1','248',6,'1',54651.66,500.00,'2022-06-07','','2022-06-07 12:30:23','454','454',2022,'454','2022-06-07 12:30:23',5),('1','248',7,'2',40043.29,900.00,'2022-06-07','','2022-06-07 12:32:45','454','454',2022,'454','2022-06-07 12:32:45',5),('1','248',8,'3',38713.18,4600.00,'2022-06-07','','2022-06-07 12:33:06','454','454',2022,'454','2022-06-07 12:33:06',5),('1','248',9,'4',13986.72,13000.00,'2022-06-07','','2022-06-07 12:33:27','454','454',2022,'454','2022-06-07 12:33:27',5),('1','248',10,'1',500.00,16600.00,'2022-06-07','','2022-06-07 15:36:53','454','454',2022,'454','2022-06-07 15:36:53',5),('1','248',11,'2',900.00,13950.00,'2022-06-07','','2022-06-07 15:37:11','454','454',2022,'454','2022-06-07 15:37:11',5),('1','248',12,'3',4600.00,4750.00,'2022-06-07','','2022-06-07 15:37:27','454','454',2022,'454','2022-06-07 15:37:27',5),('1','248',13,'4',13000.00,13350.00,'2022-06-07','','2022-06-07 15:37:42','454','454',2022,'454','2022-06-07 15:37:42',5),('1','248',14,'1',4383.39,7655.00,'2022-06-09','','2022-06-09 16:01:29','611','611',2022,'611','2022-06-09 16:01:29',5),('1','248',15,'4',1400.55,1960.00,'2022-06-10','','2022-06-10 20:14:26','611','611',2022,'611','2022-06-10 20:14:26',5),('1','248',16,'1',18481.54,21000.00,'2022-06-17','','2022-06-17 22:29:30','611','611',2022,'611','2022-06-17 22:29:30',5),('1','248',17,'2',1046.58,18959.00,'2022-06-20','','2022-06-20 08:52:10','611','611',2022,'611','2022-06-20 08:52:10',5),('1','248',18,'1',5791.92,17532.00,'2022-06-20','','2022-06-20 09:32:47','611','611',2022,'611','2022-06-20 09:32:47',5),('1','248',19,'1',17832.99,18233.00,'2022-06-22','','2022-06-22 11:43:47','611','611',2022,'611','2022-06-22 11:43:47',5),('1','248',20,'2',19088.73,18344.00,'2022-06-22','','2022-06-22 11:44:15','611','611',2022,'611','2022-06-22 11:44:15',5),('1','248',21,'1',18233.00,19669.00,'2022-06-22','','2022-06-22 12:16:13','611','611',2022,'611','2022-06-22 12:16:13',5),('1','248',22,'2',18344.00,15908.00,'2022-06-22','','2022-06-22 12:16:37','611','611',2022,'611','2022-06-22 12:16:37',5),('1','248',23,'1',19655.20,20669.00,'2022-06-23','','2022-06-23 13:12:03','611','611',2022,'611','2022-06-23 13:12:03',5),('1','248',24,'2',15831.74,15908.00,'2022-06-23','','2022-06-23 13:13:23','611','611',2022,'611','2022-06-23 13:13:23',5),('1','248',25,'4',5795.78,6188.00,'2022-06-23','','2022-06-23 13:37:11','611','611',2022,'611','2022-06-23 13:37:11',5),('1','248',26,'1',11425.45,19959.00,'2022-07-01','','2022-07-01 18:51:18','611','611',2022,'611','2022-07-01 18:51:18',5),('1','248',27,'2',25569.65,19770.00,'2022-07-01','','2022-07-01 18:52:45','611','611',2022,'611','2022-07-01 18:52:45',5),('1','248',28,'3',1675.15,15796.00,'2022-07-01','','2022-07-01 18:53:19','611','611',2022,'611','2022-07-01 18:53:19',5),('1','248',29,'5',6512.86,6387.00,'2022-07-01','','2022-07-01 18:54:10','611','611',2022,'611','2022-07-01 18:54:10',5),('1','248',30,'3',15796.00,20126.00,'2022-07-01','','2022-07-01 20:09:23','611','611',2022,'611','2022-07-01 20:09:23',5),('1','248',31,'1',49500.77,1305.00,'2022-08-07','','2022-08-07 17:49:58','611','611',2022,'611','2022-08-07 17:49:58',5),('1','248',32,'5',878.83,1305.00,'2022-08-07','','2022-08-07 17:51:48','611','611',2022,'611','2022-08-07 17:51:48',5),('1','248',33,'1',1305.00,19000.00,'2022-08-07','','2022-08-07 18:48:30','611','611',2022,'611','2022-08-07 18:48:30',5),('1','248',34,'1',19000.00,1200.00,'2022-08-07','','2022-08-07 18:58:23','611','611',2022,'611','2022-08-07 18:58:23',5),('1','248',35,'1',1200.00,20000.00,'2022-08-07','','2022-08-07 19:42:56','611','611',2022,'611','2022-08-07 19:42:56',5),('1','248',36,'1',24081.89,2000.00,'2022-08-10','','2022-08-10 19:26:02','611','611',2022,'611','2022-08-10 19:26:02',5),('1','248',37,'1',2000.00,26300.00,'2022-08-10','','2022-08-10 19:26:53','611','611',2022,'611','2022-08-10 19:26:53',5),('1','248',38,'1',293.38,7200.00,'2022-08-11','','2022-08-11 11:07:49','611','611',2022,'611','2022-08-11 11:07:49',5),('1','248',39,'1',8195.80,2000.00,'2022-08-01','','2022-08-17 16:07:07','611','611',2022,'611','2022-08-17 16:07:07',5),('1','248',40,'1',2000.00,10000.00,'2022-08-01','','2022-08-17 16:07:52','611','611',2022,'611','2022-08-17 16:07:52',5),('1','248',41,'5',1576.65,2500.00,'2022-09-01','','2022-09-01 09:29:12','611','611',2022,'611','2022-09-01 09:29:12',5),('1','248',42,'4',172.56,250.00,'2022-09-13','','2022-09-13 10:38:50','611','611',2022,'611','2022-09-13 10:38:50',5),('1','248',43,'5',2417.81,2700.00,'2022-09-18','','2022-09-18 10:25:21','611','611',2022,'611','2022-09-18 10:25:21',5),('1','248',44,'5',704.54,1200.00,'2022-10-01','','2022-10-01 14:10:40','611','611',2022,'611','2022-10-01 14:10:40',5),('1','248',45,'4',10629.90,10900.00,'2022-10-12','','2022-10-12 11:28:17','611','611',2022,'611','2022-10-12 11:28:17',5),('1','248',46,'3',12429.33,15000.00,'2022-11-19','','2022-11-19 15:56:35','611','611',2022,'611','2022-11-19 15:56:35',5),('1','248',47,'3',18213.71,19000.00,'2022-11-27','','2022-11-27 16:51:37','611','611',2022,'611','2022-11-27 16:51:37',5),('1','248',48,'3',20356.26,21000.00,'2022-12-01','','2022-12-01 09:00:29','611','611',2022,'611','2022-12-01 09:00:29',5),('1','248',49,'3',20491.58,21700.00,'2022-12-17','','2022-12-17 21:28:00','611','611',2022,'611','2022-12-17 21:28:00',5),('1','248',50,'3',14473.75,15500.00,'2022-12-20','','2022-12-20 23:44:29','611','611',2022,'611','2022-12-20 23:44:29',5),('1','248',51,'4',3099.85,3600.00,'2022-12-20','','2022-12-20 23:45:28','611','611',2022,'611','2022-12-20 23:45:28',5),('1','248',52,'3',17286.40,17500.00,'2022-12-25','','2022-12-25 22:58:00','611','611',2022,'611','2022-12-25 22:58:00',5),('1','248',53,'5',3183.15,3300.00,'2022-12-27','','2022-12-27 22:21:55','611','611',2022,'611','2022-12-27 22:21:55',5),('1','248',54,'3',30165.40,30300.00,'2022-12-30','','2022-12-30 21:08:12','611','611',2022,'611','2022-12-30 21:08:12',5),('1','248',55,'3',30300.00,30300.00,'2022-12-30','','2022-12-30 21:08:21','611','611',2022,'611','2022-12-30 21:08:21',5),('1','248',56,'3',50076.04,51000.00,'2022-12-31','','2022-12-31 22:03:52','611','611',2022,'611','2022-12-31 22:03:52',5),('1','248',57,'3',20106.65,20250.00,'2023-01-16','','2023-01-16 12:59:27','913','913',2023,'913','2023-01-16 12:59:27',5),('1','248',58,'5',3634.51,3750.00,'2023-02-04','','2023-02-04 18:39:20','913','913',2023,'913','2023-02-04 18:39:20',5),('1','248',59,'5',1016.55,1232.00,'2023-02-12','','2023-02-12 12:49:15','454','454',2023,'454','2023-02-12 12:49:15',5),('1','248',60,'5',1232.00,1300.00,'2023-02-12','','2023-02-12 14:30:07','454','454',2023,'454','2023-02-12 14:30:07',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','248','1',1,'5','PUMP 1',1421783.41,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 16:59:18','178'),('1','248','1',2,'5','PUMP 2',765813.25,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 16:59:45','178'),('1','248','1',3,'5','PUMP 5',1098821.96,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:00:05','178'),('1','248','1',4,'5','PUMP 6',589559.00,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:04:01','178'),('1','248','1',5,'5','PUMP 9',1391176.87,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:05:03','178'),('1','248','1',6,'5','PUMP 10',475492.44,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:08:12','178'),('1','248','2',7,'5','PUMP 3',1100625.20,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:10:45','178'),('1','248','2',8,'5','PUMP 4',608629.23,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:11:28','178'),('1','248','2',9,'5','PUMP 7',872375.75,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:11:55','178'),('1','248','2',10,'5','PUMP 8',326716.75,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:12:26','178'),('1','248','2',11,'5','PUMP 11',1140967.34,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:13:01','178'),('1','248','2',12,'5','PUMP 12',387838.11,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:13:25','178'),('1','248','3',13,'5','PUMP 13',607629.33,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:15:13','178'),('1','248','3',14,'5','PUMP 14',321451.99,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:15:34','178'),('1','248','3',15,'5','PUMP 15',610450.83,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:15:54','178'),('1','248','3',16,'5','PUMP 16',240272.85,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:16:15','178'),('1','248','3',17,'5','PUMP 17',373250.59,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:16:34','178'),('1','248','3',18,'5','PUMP 18',543196.71,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:16:54','178'),('1','248','3',19,'5','PUMP 19',334162.77,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:17:11','178'),('1','248','3',20,'5','PUMP 20',736712.19,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-19 17:17:33','178'),('1','248','4',21,'5','AGO PUMP 1',368496.77,'DISPENSING AGO','',NULL,NULL,'',5,'2022-04-20 10:48:48','178'),('1','248','4',22,'5','AGO PUMP 2',200394.59,'DISPENSING AGO','',NULL,NULL,'',5,'2022-04-20 10:49:29','178'),('1','248','5',23,'5','AGO PUMP 3',303796.25,'DISPENSING AGO','',NULL,NULL,'',5,'2022-04-20 10:50:06','178'),('1','248','5',24,'5','AGO PUMP 4',23451.89,'DISPENSING AGO','',NULL,NULL,'',5,'2023-02-28 13:45:01','454');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (1,'1','248','23','5','Bulk switch','2022-04-20 11:28:46',0,'178'),(2,'1','248','24','5','Bulk switch','2022-04-20 11:28:46',0,'178');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=530 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','248',1,'FULL DAY ','2022-04-12','2022-04-20 17:30:00','2022-04-21 17:30:00','807',4509500.70,4509500.70,'807','2022-04-20 17:33:20','611','2022-04-20 18:06:31',10,0),('1','248',2,'FULL DAY ','2022-04-13','2022-04-21 12:29:56','2022-04-22 12:29:56','807',11185610.70,11185610.70,'807','2022-04-21 12:52:13','611','2022-04-21 12:53:30',10,0),('1','248',3,'FULL DAY ','2022-04-14','2022-04-21 12:54:40','2022-04-22 12:54:40','807',18769687.50,18769687.50,'807','2022-04-21 13:10:04','611','2022-04-21 13:12:46',10,0),('1','248',4,'FULL DAY ','2022-04-15','2022-04-21 13:13:29','2022-04-22 13:13:29','807',16053019.80,16053019.80,'807','2022-04-21 13:25:17','611','2022-04-21 13:26:17',10,0),('1','248',5,'FULL DAY ','2022-04-16','2022-04-21 13:28:22','2022-04-22 13:28:22','807',14055341.10,14055341.10,'807','2022-04-21 13:35:08','611','2022-04-21 13:38:21',10,0),('1','248',6,'FULL DAY ','2022-04-17','2022-04-21 13:40:19','2022-04-22 13:40:19','807',12920255.85,12920255.85,'807','2022-04-21 13:49:00','611','2022-04-21 13:51:59',10,0),('1','248',7,'FULL DAY ','2022-04-18','2022-04-21 13:55:06','2022-04-22 13:55:06','807',14795824.05,14795824.05,'807','2022-04-21 14:05:30','611','2022-04-21 14:06:49',10,0),('1','248',8,'MORNING SHIFT','2022-04-19','2022-04-21 14:11:11','2022-04-22 14:11:11','807',8854810.05,8854810.05,'807','2022-04-21 14:24:14','611','2022-04-21 14:26:17',10,0),('1','248',9,'AFTERNOON SHIFT','2022-04-19','2022-04-21 14:31:50','2022-04-22 14:31:50','807',7406521.50,7406521.50,'807','2022-04-21 15:04:19','611','2022-04-21 15:09:45',10,0),('1','248',10,'MORNING SHIFT','2022-04-20','2022-04-21 15:10:42','2022-04-22 15:10:42','807',9978434.10,9978434.10,'807','2022-04-21 15:23:17','611','2022-04-21 15:24:03',10,0),('1','248',11,'AFTERNOON SHIFT','2022-04-20','2022-04-21 15:24:35','2022-04-22 15:24:35','807',6184716.00,6184716.00,'807','2022-04-21 15:43:35','611','2022-04-21 15:44:36',10,0),('1','248',12,'MORNING SHIFT','2022-04-21','2022-04-22 17:52:10','2022-04-23 17:52:10','807',8945531.85,8945531.85,'807','2022-04-22 18:03:28','611','2022-04-22 18:06:35',10,0),('1','248',13,'AFTERNOON SHIFT','2022-04-21','2022-04-22 18:07:25','2022-04-23 18:07:25','807',9220366.65,9220366.65,'807','2022-04-22 19:42:55','611','2022-04-22 19:44:02',10,0),('1','248',14,'MORNING SHIFT','2022-04-22','2022-04-22 19:44:51','2022-04-23 19:44:51','807',8440233.60,8440233.60,'807','2022-04-23 15:53:51','611','2022-04-23 15:54:20',10,0),('1','248',15,'AFTERNOON SHIFT','2022-04-22','2022-04-23 15:54:49','2022-04-24 15:54:49','807',9068314.95,9068314.95,'807','2022-04-23 16:46:34','611','2022-04-23 16:47:33',10,0),('1','248',16,'MORNING SHIFT','2022-04-23','2022-04-23 16:51:23','2022-04-24 16:51:23','807',0.00,0.00,'454','2022-04-25 11:12:05','454','2022-04-25 11:12:31',10,0),('1','248',17,'MORNING SHIFT','2022-04-23','2022-04-25 14:12:50','2022-04-26 14:12:50','807',9508439.85,9508439.85,'807','2022-04-25 15:07:04','611','2022-04-25 15:07:53',10,0),('1','248',18,'AFTERNOON SHIFT','2022-04-23','2022-04-25 15:08:43','2022-04-26 15:08:43','807',5212818.60,5212818.60,'807','2022-04-25 15:15:04','611','2022-04-25 15:16:07',10,0),('1','248',19,'MORNING SHIFT','2022-04-24','2022-04-25 15:42:13','2022-04-26 15:42:13','807',4450608.00,4450608.00,'807','2022-04-26 06:59:54','611','2022-04-26 07:01:21',10,0),('1','248',20,'AFTERNOON SHIFT','2022-04-24','2022-04-26 07:02:48','2022-04-27 07:02:48','807',0.00,0.00,'807','2022-04-26 11:30:26','611','2022-04-26 11:30:54',10,0),('1','248',21,'MORNING SHIFT','2022-04-25','2022-04-26 11:31:57','2022-04-27 11:31:57','807',7682466.30,7682466.30,'807','2022-04-26 11:52:29','611','2022-04-26 11:53:40',10,0),('1','248',22,'AFTERNOON SHIFT','2022-04-25','2022-04-26 12:16:10','2022-04-27 12:16:10','807',0.00,0.00,'807','2022-04-28 08:52:43','611','2022-04-28 08:53:42',10,0),('1','248',23,'AFTERNOON SHIFT','2022-04-25','2022-04-28 08:54:18','2022-04-29 08:54:18','807',8758445.55,8758445.55,'807','2022-04-28 09:04:31','611','2022-04-28 09:06:55',10,0),('1','248',24,'MORNING SHIFT','2022-04-26','2022-04-28 09:18:32','2022-04-29 09:18:32','807',9453537.90,9453537.90,'807','2022-04-28 09:28:22','611','2022-04-28 09:35:08',10,0),('1','248',25,'AFTERNOON SHIFT','2022-04-26','2022-04-28 09:39:37','2022-04-29 09:39:37','807',7283094.30,7283094.30,'807','2022-04-28 09:43:42','611','2022-04-28 09:48:12',10,0),('1','248',26,'MORNING SHIFT','2022-04-27','2022-04-28 10:28:23','2022-04-29 10:28:23','807',9887334.90,9887334.90,'807','2022-04-28 11:33:43','611','2022-04-28 11:35:51',10,0),('1','248',27,'AFTERNOON SHIFT','2022-04-27','2022-04-28 11:39:43','2022-04-29 11:39:43','807',8165833.65,8165833.65,'807','2022-04-28 12:20:01','611','2022-04-28 12:27:35',10,0),('1','248',28,'MORNING SHIFT','2022-04-28','2022-04-28 12:33:32','2022-04-29 12:33:32','807',0.00,0.00,'807','2022-04-30 10:47:51','611','2022-04-30 10:49:40',10,0),('1','248',29,'MORNING SHIFT','2022-04-29','2022-04-30 11:17:38','2022-05-01 11:17:38','807',0.00,0.00,'807','2022-04-30 11:21:01','611','2022-04-30 11:37:13',10,0),('1','248',30,'MORNING SHIFT','2022-04-28','2022-04-30 11:44:44','2022-05-01 11:44:44','807',9092309.85,9092309.85,'807','2022-04-30 19:54:15','611','2022-04-30 19:56:47',10,0),('1','248',31,'AFTERNOON SHIFT','2022-04-28','2022-04-30 20:08:42','2022-05-01 20:08:42','807',9571213.80,9571213.80,'807','2022-04-30 20:24:13','611','2022-04-30 20:45:04',10,0),('1','248',32,'MORNING SHIFT','2022-04-29','2022-04-30 20:47:17','2022-05-01 20:47:17','807',0.00,0.00,'454','2022-05-01 23:41:16','454','2022-05-01 23:41:36',10,0),('1','248',33,'MORNING SHIFT','2022-04-28','2022-05-02 00:36:04','2022-05-03 00:36:04','807',0.00,0.00,'454','2022-05-02 01:05:34','454','2022-05-02 01:06:03',10,0),('1','248',34,'MORNING SHIFT','2022-04-29','2022-05-02 01:08:53','2022-05-03 01:08:53','807',9134548.20,9134548.20,'807','2022-05-02 01:15:52','454','2022-05-02 06:23:13',10,0),('1','248',35,'AFTERNOON SHIFT','2022-04-29','2022-05-02 07:25:56','2022-05-03 07:25:56','807',11725137.45,11725137.45,'807','2022-05-02 07:37:51','454','2022-05-02 11:45:26',10,0),('1','248',36,'MORNING SHIFT','2022-04-30','2022-05-02 12:11:50','2022-05-03 12:11:50','807',8051239.50,8051239.50,'807','2022-05-02 12:25:05','454','2022-05-02 13:21:14',10,0),('1','248',37,'AFTERNOON SHIFT','2022-04-30','2022-05-02 13:51:53','2022-05-03 13:51:53','807',6758250.90,6758250.90,'807','2022-05-02 14:08:12','611','2022-05-02 17:31:48',10,0),('1','248',38,'MORNING SHIFT','2022-05-01','2022-05-02 18:18:33','2022-05-03 18:18:33','807',0.00,0.00,'807','2022-05-03 10:55:02','611','2022-05-03 10:56:45',10,0),('1','248',39,'MORNING SHIFT','2022-05-01','2022-05-03 10:57:49','2022-05-04 10:57:49','807',5739054.60,5739054.60,'807','2022-05-03 15:15:11','611','2022-05-03 15:28:33',10,0),('1','248',40,'AFTERNOON SHIFT','2022-05-01','2022-05-03 16:41:16','2022-05-04 16:41:16','807',6670440.45,6670440.45,'807','2022-05-03 16:49:48','454','2022-05-03 21:03:34',10,0),('1','248',41,'FULL DAY ','2022-05-02','2022-05-03 21:18:15','2022-05-04 21:18:15','807',9712284.75,9712284.75,'807','2022-05-03 21:25:40','454','2022-05-03 22:06:08',10,0),('1','248',42,'FULL DAY ','2022-05-03','2022-05-04 16:02:34','2022-05-05 16:02:34','807',9672236.25,9672236.25,'807','2022-05-04 17:01:44','611','2022-05-04 17:06:33',10,0),('1','248',43,'MORNING SHIFT','2022-05-04','2022-05-04 20:09:11','2022-05-05 20:09:11','807',5584538.85,5584538.85,'807','2022-05-04 20:21:30','611','2022-05-05 08:51:58',10,0),('1','248',44,'AFTERNOON SHIFT','2022-05-04','2022-05-05 17:59:24','2022-05-06 17:59:24','807',8285996.70,8285996.70,'807','2022-05-05 18:15:46','611','2022-05-06 09:05:05',10,0),('1','248',45,'MORNING SHIFT','2022-05-05','2022-05-07 00:54:47','2022-05-08 00:54:47','807',5063473.35,5063473.35,'807','2022-05-07 01:00:22','611','2022-05-07 13:03:24',10,0),('1','248',46,'AFTERNOON SHIFT','2022-05-05','2022-05-07 14:58:39','2022-05-08 14:58:39','807',8761206.15,8761206.15,'807','2022-05-07 15:29:16','611','2022-05-07 20:22:23',10,0),('1','248',47,'MORNING SHIFT','2022-05-06','2022-05-07 21:41:09','2022-05-08 21:41:09','807',8352308.40,8352308.40,'807','2022-05-07 23:33:54','611','2022-05-07 23:48:58',10,0),('1','248',48,'AFTERNOON SHIFT','2022-05-06','2022-05-08 00:01:04','2022-05-09 00:01:04','807',8383053.90,8383053.90,'807','2022-05-08 00:23:42','611','2022-05-08 06:31:11',10,0),('1','248',49,'MORNING SHIFT','2022-05-07','2022-05-08 06:45:22','2022-05-09 06:45:22','807',4861734.00,4861734.00,'807','2022-05-08 06:50:22','611','2022-05-08 06:53:47',10,0),('1','248',50,'AFTERNOON SHIFT','2022-05-07','2022-05-08 06:55:11','2022-05-09 06:55:11','807',7617688.95,7617688.95,'807','2022-05-08 11:47:45','611','2022-05-08 16:26:35',10,0),('1','248',51,'MORNING SHIFT','2022-05-08','2022-05-08 21:08:47','2022-05-09 21:08:47','807',4930115.25,4930115.25,'807','2022-05-08 21:14:26','611','2022-05-09 07:01:25',10,0),('1','248',52,'AFTERNOON SHIFT','2022-05-08','2022-05-10 08:45:23','2022-05-11 08:45:23','807',1460659.35,1460659.35,'807','2022-05-10 08:52:10','454','2022-05-10 09:08:13',10,0),('1','248',53,'FULL DAY ','2022-05-09','2022-05-11 14:16:59','2022-05-12 14:16:59','807',4238621.85,4238621.85,'807','2022-05-11 21:59:47','611','2022-05-12 09:34:36',10,0),('1','248',54,'MORNING SHIFT','2022-05-10','2022-05-12 09:38:36','2022-05-13 09:38:36','807',2658346.35,2658346.35,'807','2022-05-12 09:43:28','611','2022-05-12 09:56:45',10,0),('1','248',55,'AFTERNOON SHIFT','2022-05-10','2022-05-12 09:59:43','2022-05-13 09:59:43','807',3083691.60,3083691.60,'807','2022-05-12 10:03:50','611','2022-05-12 10:08:03',10,0),('1','248',56,'MORNING SHIFT','2022-05-11','2022-05-12 10:08:56','2022-05-13 10:08:56','807',0.00,0.00,'807','2022-05-12 10:56:41','611','2022-05-12 10:57:54',10,0),('1','248',57,'MORNING SHIFT','2022-05-11','2022-05-12 16:11:04','2022-05-13 16:11:04','807',3422697.30,3422697.30,'807','2022-05-12 16:14:40','611','2022-05-12 16:23:26',10,0),('1','248',58,'AFTERNOON SHIFT','2022-05-11','2022-05-12 16:28:02','2022-05-13 16:28:02','807',8232869.15,8232869.15,'807','2022-05-12 16:35:19','611','2022-05-12 16:37:44',10,0),('1','248',59,'MORNING SHIFT','2022-05-12','2022-05-13 00:07:19','2022-05-14 00:07:19','807',4184442.90,4184442.90,'807','2022-05-13 01:17:43','611','2022-05-13 18:26:04',10,0),('1','248',60,'AFTERNOON SHIFT','2022-05-12','2022-05-13 21:25:56','2022-05-14 21:25:56','807',9533891.40,9533891.40,'807','2022-05-13 21:34:56','611','2022-05-13 21:39:21',10,0),('1','248',61,'MORNING SHIFT','2022-05-13','2022-05-13 21:51:58','2022-05-14 21:51:58','807',5313117.70,5313117.70,'807','2022-05-13 21:58:57','611','2022-05-13 22:27:54',10,0),('1','248',62,'AFTERNOON SHIFT','2022-05-13','2022-05-14 13:05:38','2022-05-15 13:05:38','807',8306624.40,8306624.40,'807','2022-05-14 13:24:27','611','2022-05-14 13:29:18',10,0),('1','248',63,'MORNING SHIFT','2022-05-14','2022-05-14 18:09:53','2022-05-15 18:09:53','807',0.00,0.00,'807','2022-05-14 18:28:39','611','2022-05-14 18:31:36',10,0),('1','248',64,'AGO CHANGE OF PRICE ','2022-05-14','2022-05-14 18:32:22','2022-05-15 18:32:22','807',867335.00,867335.00,'807','2022-05-14 18:33:27','611','2022-05-14 18:53:04',10,0),('1','248',65,'MORNING SHIFT','2022-05-14','2022-05-14 18:54:24','2022-05-15 18:54:24','807',3616644.60,3616644.60,'807','2022-05-14 18:58:33','611','2022-05-14 19:01:33',10,0),('1','248',66,'AFTERNOON SHIF','2022-05-14','2022-05-15 09:31:03','2022-05-16 09:31:03','807',6812896.80,6812896.80,'807','2022-05-15 10:55:12','611','2022-05-15 11:47:22',10,0),('1','248',67,'MORNING SHIFT','2022-05-15','2022-05-15 20:30:53','2022-05-16 20:30:53','807',5897556.30,5897556.30,'807','2022-05-15 20:59:56','611','2022-05-15 23:18:31',10,0),('1','248',68,'AFTERNOON SHIFT','2022-05-15','2022-05-17 08:03:24','2022-05-18 08:03:24','807',5954159.85,5954159.85,'807','2022-05-17 08:06:50','611','2022-05-17 08:11:57',10,0),('1','248',69,'MORNING SHIFT','2022-05-16','2022-05-17 08:15:22','2022-05-18 08:15:22','807',3677696.55,3677696.55,'807','2022-05-17 08:18:24','611','2022-05-17 08:33:43',10,0),('1','248',70,'AFTERNOON SHIFT','2022-05-16','2022-05-17 08:39:51','2022-05-18 08:39:51','807',8326096.50,8326096.50,'807','2022-05-17 17:47:28','611','2022-05-17 18:02:26',10,0),('1','248',71,'MORNING SHIFT','2022-05-17','2022-05-17 18:27:00','2022-05-18 18:27:00','807',5778830.10,5778830.10,'807','2022-05-17 18:49:13','611','2022-05-18 07:16:28',10,0),('1','248',72,'AFTERNOON SHIFT','2022-05-17','2022-05-18 12:43:21','2022-05-19 12:43:21','807',6493836.15,6493836.15,'807','2022-05-18 13:01:57','611','2022-05-18 19:35:30',10,0),('1','248',73,'MORNING SHIFT','2022-05-18','2022-05-18 19:49:12','2022-05-19 19:49:12','807',3774943.95,3774943.95,'807','2022-05-18 21:22:26','611','2022-05-19 10:20:42',10,0),('1','248',74,'AFTERNOON SHIFT','2022-05-18','2022-05-19 12:50:16','2022-05-20 12:50:16','807',4342524.45,4342524.45,'807','2022-05-19 13:03:55','611','2022-05-19 16:33:47',10,0),('1','248',75,'MORNING SHIFT','2022-05-19','2022-05-19 19:39:38','2022-05-20 19:39:38','807',5293473.90,5293473.90,'807','2022-05-19 19:59:12','611','2022-05-19 20:34:05',10,0),('1','248',76,'AFTERNOON SHIFT','2022-05-20','2022-05-20 12:50:05','2022-05-21 12:50:05','807',0.00,0.00,'807','2022-05-20 18:33:10','611','2022-05-20 20:05:42',10,0),('1','248',77,'AFTERNOON SHIFT','2022-05-19','2022-05-20 20:22:22','2022-05-21 20:22:22','807',6875202.45,6875202.45,'807','2022-05-20 20:43:18','611','2022-05-21 11:25:05',10,0),('1','248',78,'MORNING SHIFT','2022-05-20','2022-05-21 13:05:25','2022-05-22 13:05:25','807',7468012.05,7468012.05,'807','2022-05-21 13:31:35','611','2022-05-21 17:42:29',10,0),('1','248',79,'AFTERNOON SHIFT','2022-05-20','2022-05-22 07:58:39','2022-05-23 07:58:39','807',8735329.95,8735329.95,'807','2022-05-22 08:51:38','611','2022-05-22 09:03:16',10,0),('1','248',80,'MORNING SHIFT','2022-05-21','2022-05-22 09:22:22','2022-05-23 09:22:22','807',6963062.85,6963062.85,'807','2022-05-22 10:18:42','611','2022-05-22 12:55:37',10,0),('1','248',81,'AFTERNOON SHIFT','2022-05-21','2022-05-22 12:56:53','2022-05-23 12:56:53','807',7712674.95,7712674.95,'807','2022-05-22 13:01:41','611','2022-05-22 16:08:21',10,0),('1','248',82,'MORNING SHIFT','2022-05-22','2022-05-22 16:47:02','2022-05-23 16:47:02','807',8461387.65,8461387.65,'807','2022-05-22 17:07:50','611','2022-05-23 08:23:02',10,0),('1','248',83,'AFTERNOON SHIFT','2022-05-22','2022-05-23 11:18:02','2022-05-24 11:18:02','807',6551056.95,6551056.95,'807','2022-05-23 13:12:43','611','2022-05-24 07:03:04',10,0),('1','248',84,'MORNING SHIFT','2022-05-23','2022-05-24 11:21:36','2022-05-25 11:21:36','807',6559342.50,6559342.50,'807','2022-05-24 11:42:24','611','2022-05-24 12:02:22',10,0),('1','248',85,'AFTERNOON SHIFT','2022-05-23','2022-05-24 12:04:15','2022-05-25 12:04:15','807',6484640.25,6484640.25,'807','2022-05-24 12:43:27','611','2022-05-24 14:11:28',10,0),('1','248',86,'MORNING SHIFT','2022-05-24','2022-05-24 15:48:58','2022-05-25 15:48:58','807',2859715.65,2859715.65,'807','2022-05-24 15:54:13','611','2022-05-24 21:59:00',10,0),('1','248',87,'AFTERNOON SHIFT','2022-05-24','2022-05-25 11:44:01','2022-05-26 11:44:01','807',5953127.40,5953127.40,'807','2022-05-25 11:53:40','611','2022-05-25 18:26:46',10,0),('1','248',88,'MORNING SHIFT','2022-05-25','2022-05-25 18:32:00','2022-05-26 18:32:00','807',2229760.50,2229760.50,'807','2022-05-25 18:37:39','611','2022-05-25 23:59:02',10,0),('1','248',89,'FULL DAY ','2022-05-26','2022-05-27 10:16:27','2022-05-28 10:16:27','807',5425622.40,5425622.40,'807','2022-05-27 11:58:49','611','2022-05-27 15:16:09',10,0),('1','248',90,'MORNING SHIFT','2022-05-27','2022-05-27 15:39:24','2022-05-28 15:39:24','807',2761110.00,2761110.00,'807','2022-05-27 16:30:55','611','2022-05-27 18:17:11',10,0),('1','248',91,'AFTERNOON SHIFT','2022-05-27','2022-05-28 12:55:47','2022-05-29 12:55:47','807',5718860.40,5718860.40,'807','2022-05-28 13:08:08','611','2022-05-28 14:00:46',10,0),('1','248',92,'FULL DAY ','2022-05-28','2022-05-29 16:04:53','2022-05-30 16:04:53','807',9200251.45,9200251.45,'807','2022-05-29 16:26:18','611','2022-05-30 07:33:17',10,0),('1','248',93,'FULL DAY ','2022-05-29','2022-05-30 12:22:12','2022-05-31 12:22:12','807',11536860.80,11536860.80,'807','2022-05-30 15:34:36','611','2022-05-30 19:06:24',10,0),('1','248',94,'MORNING SHIFT','2022-05-30','2022-05-30 19:13:47','2022-05-31 19:13:47','807',7951090.40,7951090.40,'807','2022-05-30 19:34:03','611','2022-05-31 08:48:29',10,0),('1','248',95,'AFTERNOON SHIFT','2022-05-30','2022-05-31 09:16:58','2022-06-01 09:16:58','807',9232872.40,9232872.40,'807','2022-05-31 09:46:34','611','2022-05-31 10:08:02',10,0),('1','248',96,'MORNING SHIFT','2022-05-31','2022-05-31 18:45:59','2022-06-01 18:45:59','807',9073052.35,9073052.35,'807','2022-05-31 19:15:07','611','2022-06-01 09:34:48',10,0),('1','248',97,'AFTERNOON SHIFT','2022-06-01','2022-06-01 12:50:11','2022-06-02 12:50:11','807',0.00,0.00,'807','2022-06-01 15:38:57','611','2022-06-01 15:39:18',10,0),('1','248',98,'AFTERNOON SHIFT','2022-05-31','2022-06-01 15:39:57','2022-06-02 15:39:57','807',10171436.80,10171436.80,'807','2022-06-01 15:44:38','611','2022-06-01 15:45:17',10,0),('1','248',99,'MORNING SHIFT','2022-06-01','2022-06-02 16:38:13','2022-06-03 16:38:13','807',8654712.00,8654712.00,'807','2022-06-02 17:27:29','611','2022-06-02 17:31:17',10,0),('1','248',100,'AFTERNOON SHIFT','2022-06-01','2022-06-02 18:07:58','2022-06-03 18:07:58','807',10680481.00,10680481.00,'807','2022-06-02 19:06:11','611','2022-06-03 06:42:56',10,0),('1','248',101,'MORNING SHIFT','2022-06-02','2022-06-03 06:49:37','2022-06-04 06:49:37','807',4567210.85,4567210.85,'807','2022-06-03 08:39:45','611','2022-06-03 10:40:58',10,0),('1','248',102,'AFTERNOON SHIFT','2022-06-02','2022-06-04 09:14:13','2022-06-05 09:14:13','807',6503669.15,6503669.15,'807','2022-06-04 09:41:57','611','2022-06-04 10:33:19',10,0),('1','248',103,'MORNING SHIFT','2022-06-03','2022-06-04 10:56:56','2022-06-05 10:56:56','807',6041027.70,6041027.70,'807','2022-06-04 11:09:15','611','2022-06-04 12:03:09',10,0),('1','248',104,'AFTERNOON SHIFT','2022-06-03','2022-06-04 13:09:09','2022-06-05 13:09:09','807',777426.80,777426.80,'807','2022-06-04 13:24:39','611','2022-06-05 12:25:44',10,0),('1','248',105,'MORNING SHIFT','2022-06-04','2022-06-05 13:19:24','2022-06-06 13:19:24','807',5369210.30,5369210.30,'807','2022-06-05 13:34:10','611','2022-06-05 13:44:10',10,0),('1','248',106,'AFTERNOON SHIFT','2022-06-04','2022-06-05 13:46:12','2022-06-06 13:46:12','807',0.00,0.00,'807','2022-06-06 10:20:15','611','2022-06-06 10:20:45',10,0),('1','248',107,'AFTERNOON SHIFT','2022-06-04','2022-06-06 10:21:25','2022-06-07 10:21:25','807',9264451.35,9264451.35,'807','2022-06-06 12:04:32','611','2022-06-06 12:16:29',10,0),('1','248',108,'MORNING SHIFT','2022-06-05','2022-06-06 12:18:23','2022-06-07 12:18:23','807',4999932.85,4999932.85,'807','2022-06-06 12:26:03','611','2022-06-06 12:33:59',10,0),('1','248',109,'AFTERNOON SHIFT','2022-06-05','2022-06-06 12:36:54','2022-06-07 12:36:54','807',4804424.35,4804424.35,'807','2022-06-06 12:49:40','611','2022-06-06 13:14:58',10,0),('1','248',110,'MORNING SHIFT','2022-06-06','2022-06-06 13:17:25','2022-06-07 13:17:25','807',5587151.35,5587151.35,'807','2022-06-06 19:06:29','611','2022-06-07 06:34:33',10,0),('1','248',111,'AFTERNOON SHIFT','2022-06-06','2022-06-07 10:52:47','2022-06-08 10:52:47','807',7468888.90,7468888.90,'807','2022-06-07 12:09:54','454','2022-06-07 12:27:47',10,0),('1','248',112,'MORNING SHIFT','2022-06-07','2022-06-07 12:29:18','2022-06-08 12:29:18','454',6785692.10,6785692.10,'807','2022-06-07 17:39:24','611','2022-06-08 11:05:31',10,0),('1','248',113,'AFTERNOON SHIFT','2022-06-07','2022-06-08 11:13:22','2022-06-09 11:13:22','807',7251207.85,7251207.85,'807','2022-06-08 11:59:34','611','2022-06-08 12:00:42',10,0),('1','248',114,'MORNING SHIFT','2022-06-08','2022-06-08 12:10:34','2022-06-09 12:10:34','807',3687887.05,3687887.05,'807','2022-06-08 16:36:55','611','2022-06-08 18:21:40',10,0),('1','248',115,'AFTERNOON SHIFT','2022-06-08','2022-06-09 09:13:16','2022-06-10 09:13:16','807',8015602.30,8015602.30,'807','2022-06-09 09:27:36','611','2022-06-09 09:59:16',10,0),('1','248',116,'MORNING SHIFT','2022-06-09','2022-06-09 15:14:27','2022-06-10 15:14:27','807',5600265.15,5600265.15,'807','2022-06-09 16:21:38','611','2022-06-10 06:18:03',10,0),('1','248',117,'AFTERNOON SHIFT','2022-06-09','2022-06-10 09:35:16','2022-06-11 09:35:16','807',6053764.60,6053764.60,'807','2022-06-10 10:29:04','611','2022-06-10 17:00:45',10,0),('1','248',118,'MORNING SHIFT','2022-06-10','2022-06-10 17:45:47','2022-06-11 17:45:47','807',4532655.05,4532655.05,'807','2022-06-10 20:22:20','611','2022-06-11 12:26:45',10,0),('1','248',119,'AFTERNOON SHIFT','2022-06-10','2022-06-11 12:36:41','2022-06-12 12:36:41','807',6972246.00,6972246.00,'807','2022-06-11 13:30:29','611','2022-06-11 18:44:54',10,0),('1','248',120,'MORNING SHIFT','2022-06-11','2022-06-11 18:46:54','2022-06-12 18:46:54','807',6288695.50,6288695.50,'807','2022-06-11 19:19:01','611','2022-06-12 09:42:31',10,0),('1','248',121,'AFTERNOON SHIFT','2022-06-11','2022-06-12 10:15:46','2022-06-13 10:15:46','807',5804636.85,5804636.85,'807','2022-06-12 11:03:55','611','2022-06-12 15:05:25',10,0),('1','248',122,'MORNING SHIFT','2022-06-12','2022-06-13 08:05:15','2022-06-14 08:05:15','807',6487169.80,6487169.80,'807','2022-06-13 08:18:28','611','2022-06-13 08:49:09',10,0),('1','248',123,'AFTERNOON SHIFT','2022-06-12','2022-06-13 12:06:18','2022-06-14 12:06:18','807',2804412.25,2804412.25,'807','2022-06-13 13:03:47','611','2022-06-13 20:03:48',10,0),('1','248',124,'MORNING SHIFT','2022-06-13','2022-06-13 20:20:36','2022-06-14 20:20:36','807',5304787.95,5304787.95,'807','2022-06-13 21:16:04','611','2022-06-14 09:19:27',10,0),('1','248',125,'AFTERNOON SHIFT','2022-06-13','2022-06-14 09:48:18','2022-06-15 09:48:18','807',5766655.95,5766655.95,'807','2022-06-14 10:30:25','611','2022-06-14 12:20:11',10,0),('1','248',126,'MORNING SHIFT','2022-06-14','2022-06-14 20:56:20','2022-06-15 20:56:20','807',6469193.15,6469193.15,'807','2022-06-14 21:05:04','611','2022-06-15 09:05:37',10,0),('1','248',127,'AFTERNOON SHIFT','2022-06-14','2022-06-15 10:56:50','2022-06-16 10:56:50','807',7402369.70,7402369.70,'807','2022-06-15 11:20:37','611','2022-06-15 15:59:03',10,0),('1','248',128,'MORNING SHIFT','2022-06-15','2022-06-15 17:13:12','2022-06-16 17:13:12','807',7759577.00,7759577.00,'807','2022-06-15 17:33:42','611','2022-06-16 10:13:49',10,0),('1','248',129,'AFTERNOON SHIFT','2022-06-15','2022-06-16 12:41:43','2022-06-17 12:41:43','807',6885000.75,6885000.75,'807','2022-06-16 13:07:37','454','2022-06-16 13:19:18',10,0),('1','248',130,'MORNING SHIFT','2022-06-16','2022-06-16 19:07:05','2022-06-17 19:07:05','807',5986778.85,5986778.85,'807','2022-06-16 19:22:22','611','2022-06-17 10:46:56',10,0),('1','248',131,'AFTERNOON SHIFT','2022-06-16','2022-06-17 11:24:59','2022-06-18 11:24:59','807',5038742.15,5038742.15,'807','2022-06-17 18:14:25','611','2022-06-17 21:01:47',10,0),('1','248',132,'MORNING SHIFT','2022-06-17','2022-06-17 21:08:22','2022-06-18 21:08:22','807',5418493.80,5418493.80,'807','2022-06-17 22:39:40','611','2022-06-18 06:48:25',10,0),('1','248',133,'AFTERNOON SHIFT','2022-06-17','2022-06-18 10:49:45','2022-06-19 10:49:45','807',7771082.40,7771082.40,'807','2022-06-18 11:22:51','611','2022-06-18 17:04:40',10,0),('1','248',134,'MORNING SHIFT','2022-06-18','2022-06-19 06:19:25','2022-06-20 06:19:25','807',6183691.95,6183691.95,'807','2022-06-19 06:31:03','611','2022-06-19 08:19:44',10,0),('1','248',135,'AFTERNOON SHIFT','2022-06-18','2022-06-19 10:07:56','2022-06-20 10:07:56','807',5900068.80,5900068.80,'807','2022-06-19 11:17:37','611','2022-06-19 15:41:10',10,0),('1','248',136,'MORNING SHIFT','2022-06-19','2022-06-19 16:39:36','2022-06-20 16:39:36','807',4287956.20,4287956.20,'807','2022-06-19 18:04:19','611','2022-06-19 19:28:54',10,0),('1','248',137,'AFTERNOON SHIFT','2022-06-19','2022-06-20 07:30:09','2022-06-21 07:30:09','807',7127412.40,7127412.40,'807','2022-06-20 09:37:21','611','2022-06-20 10:48:41',10,0),('1','248',138,'MORNING SHIFT','2022-06-20','2022-06-20 21:16:36','2022-06-21 21:16:36','807',6964475.20,6964475.20,'807','2022-06-20 21:32:41','611','2022-06-21 07:58:06',10,0),('1','248',139,'AFTERNOON SHIFT','2022-06-20','2022-06-21 13:23:34','2022-06-22 13:23:34','807',7838901.20,7838901.20,'807','2022-06-21 18:47:38','611','2022-06-21 19:11:03',10,0),('1','248',140,'MORNING SHIFT','2022-06-21','2022-06-21 19:19:09','2022-06-22 19:19:09','807',7718090.65,7718090.65,'807','2022-06-21 19:32:18','611','2022-06-22 08:53:17',10,0),('1','248',141,'AFTERNOON SHIFT','2022-06-21','2022-06-22 11:11:35','2022-06-23 11:11:35','807',8401489.60,8401489.60,'807','2022-06-22 12:52:32','611','2022-06-23 08:15:01',10,0),('1','248',142,'MORNING SHIFT','2022-06-22','2022-06-23 11:06:39','2022-06-24 11:06:39','807',5836026.90,5836026.90,'807','2022-06-23 11:29:40','611','2022-06-23 12:07:30',10,0),('1','248',143,'AFTERNOON SHIFT','2022-06-22','2022-06-23 12:15:08','2022-06-24 12:15:08','807',10312925.30,10312925.30,'807','2022-06-23 13:42:32','611','2022-06-24 08:40:27',10,0),('1','248',144,'MORNING SHIFT','2022-06-23','2022-06-24 12:35:09','2022-06-25 12:35:09','807',5721095.55,5721095.55,'807','2022-06-24 13:02:32','611','2022-06-24 13:09:11',10,0),('1','248',145,'AFTERNOON SHIFT','2022-06-23','2022-06-24 13:14:16','2022-06-25 13:14:16','807',7566297.70,7566297.70,'807','2022-06-24 13:24:02','611','2022-06-24 14:24:43',10,0),('1','248',146,'FULL DAY ','2022-06-24','2022-06-25 11:09:59','2022-06-26 11:09:59','807',7608144.15,7608144.15,'807','2022-06-25 11:28:48','611','2022-06-26 08:17:26',10,0),('1','248',147,'MORNING SHIFT','2022-06-25','2022-06-26 10:39:58','2022-06-27 10:39:58','807',10819993.45,10819993.45,'807','2022-06-26 12:00:27','611','2022-06-26 18:08:11',10,0),('1','248',148,'AFTERNOON SHIFT','2022-06-25','2022-06-26 18:14:00','2022-06-27 18:14:00','807',6069275.55,6069275.55,'807','2022-06-26 18:46:56','611','2022-06-27 09:05:04',10,0),('1','248',149,'MORNING SHIFT','2022-06-26','2022-06-27 13:05:58','2022-06-28 13:05:58','807',6075452.00,6075452.00,'807','2022-06-27 13:17:16','611','2022-06-27 14:58:39',10,0),('1','248',150,'AFTERNOON SHIFT','2022-06-26','2022-06-27 16:05:47','2022-06-28 16:05:47','807',5888061.30,5888061.30,'807','2022-06-27 16:23:19','611','2022-06-27 17:57:51',10,0),('1','248',151,'MORNING SHIFT','2022-06-27','2022-06-27 17:59:56','2022-06-28 17:59:56','807',4063346.15,4063346.15,'807','2022-06-27 18:12:01','611','2022-06-28 09:33:38',10,0),('1','248',152,'AFTERNOON SHIFT','2022-06-27','2022-06-28 11:50:05','2022-06-29 11:50:05','807',10604606.75,10604606.75,'807','2022-06-28 12:02:43','611','2022-06-28 14:04:15',10,0),('1','248',153,'MORNING SHIFT','2022-06-28','2022-06-28 18:04:29','2022-06-29 18:04:29','807',4446705.70,4446705.70,'807','2022-06-28 18:19:48','611','2022-06-29 07:12:04',10,0),('1','248',154,'AFTERNOON SHIFT','2022-06-28','2022-06-29 11:16:53','2022-06-30 11:16:53','807',8873045.30,8873045.30,'807','2022-06-29 12:24:05','611','2022-06-29 17:47:29',10,0),('1','248',155,'MORNING SHIFT','2022-06-29','2022-06-29 17:50:49','2022-06-30 17:50:49','807',3195315.30,3195315.30,'807','2022-06-29 18:03:55','611','2022-06-30 10:48:18',10,0),('1','248',156,'AFTERNOON SHIFT','2022-06-29','2022-06-30 11:00:33','2022-07-01 11:00:33','807',512475.20,512475.20,'807','2022-06-30 11:03:13','454','2022-06-30 11:52:08',10,0),('1','248',157,'FULL DAY ','2022-06-30','2022-07-01 17:48:02','2022-07-02 17:48:02','807',15160778.50,15160778.50,'807','2022-07-01 20:22:40','611','2022-07-02 10:20:23',10,0),('1','248',158,'MORNING SHIFT','2022-07-01','2022-07-02 10:42:43','2022-07-03 10:42:43','807',4226008.05,4226008.05,'807','2022-07-02 10:49:58','611','2022-07-02 16:46:20',10,0),('1','248',159,'MORNING SHIFT','2022-07-02','2022-07-03 06:50:51','2022-07-04 06:50:51','807',3191228.70,3191228.70,'807','2022-07-03 06:57:24','611','2022-07-03 12:05:05',10,0),('1','248',160,'AFTERNOON SHIFT','2022-07-02','2022-07-03 12:16:05','2022-07-04 12:16:05','807',9692929.90,9692929.90,'807','2022-07-04 07:31:38','611','2022-07-04 11:01:29',10,0),('1','248',161,'MORNING SHIFT','2022-07-03','2022-07-04 11:03:53','2022-07-05 11:03:53','807',6438512.00,6438512.00,'807','2022-07-04 12:53:23','611','2022-07-04 16:29:13',10,0),('1','248',162,'AFTERNOON SHIFT','2022-07-03','2022-07-04 16:31:40','2022-07-05 16:31:40','807',5536580.25,5536580.25,'807','2022-07-04 19:24:46','611','2022-07-05 10:50:28',10,0),('1','248',163,'FULL DAY ','2022-07-04','2022-07-05 11:00:21','2022-07-06 11:00:21','807',6238058.65,6238058.65,'807','2022-07-05 11:17:46','611','2022-07-05 11:25:37',10,0),('1','248',164,'MORNING SHIFT','2022-07-05','2022-07-06 08:29:59','2022-07-07 08:29:59','807',2956534.35,2956534.35,'807','2022-07-06 09:01:04','611','2022-07-06 09:13:48',10,0),('1','248',165,'AFTERNOON SHIFT','2022-07-05','2022-07-06 09:16:59','2022-07-07 09:16:59','807',8177417.65,8177417.65,'807','2022-07-06 09:27:52','611','2022-07-06 19:59:39',10,0),('1','248',166,'MORNING SHIFT','2022-07-06','2022-07-06 20:03:50','2022-07-07 20:03:50','807',4314208.80,4314208.80,'807','2022-07-06 20:18:37','611','2022-07-07 08:45:16',10,0),('1','248',167,'AFTERNOON SHIFT','2022-07-06','2022-07-07 10:53:30','2022-07-08 10:53:30','807',9647456.90,9647456.90,'807','2022-07-07 12:23:10','611','2022-07-07 14:05:09',10,0),('1','248',168,'MORNING SHIFT','2022-07-07','2022-07-07 20:07:05','2022-07-08 20:07:05','807',4005105.15,4005105.15,'807','2022-07-07 21:49:39','611','2022-07-08 07:42:26',10,0),('1','248',169,'AFTERNOON SHIFT','2022-07-07','2022-07-08 12:38:11','2022-07-09 12:38:11','807',7826922.30,7826922.30,'807','2022-07-08 12:52:50','611','2022-07-08 18:11:23',10,0),('1','248',170,'FULL DAY ','2022-07-08','2022-07-09 15:11:15','2022-07-10 15:11:15','807',6822654.70,6822654.70,'807','2022-07-09 15:49:09','611','2022-07-09 19:24:51',10,0),('1','248',171,'FULL DAY ','2022-07-09','2022-07-10 14:56:46','2022-07-11 14:56:46','807',4000560.70,4000560.70,'807','2022-07-10 15:16:01','611','2022-07-10 16:13:28',10,0),('1','248',172,'FULL DAY ','2022-07-10','2022-07-11 12:21:03','2022-07-12 12:21:03','807',8305809.40,8305809.40,'807','2022-07-11 14:51:08','611','2022-07-11 16:35:56',10,0),('1','248',173,'MORNING SHIFT','2022-07-11','2022-07-12 11:22:19','2022-07-13 11:22:19','807',2790880.40,2790880.40,'807','2022-07-12 13:37:05','611','2022-07-12 20:44:59',10,0),('1','248',174,'AFTERNOON SHIFT','2022-07-11','2022-07-13 10:28:58','2022-07-14 10:28:58','807',8247879.65,8247879.65,'807','2022-07-13 11:07:29','454','2022-07-13 11:13:04',10,0),('1','248',175,'MORNING SHIFT','2022-07-12','2022-07-13 11:51:10','2022-07-14 11:51:10','807',4585332.30,4585332.30,'807','2022-07-13 12:02:58','611','2022-07-13 15:09:00',10,0),('1','248',176,'AFTERNOON SHIFT','2022-07-12','2022-07-13 17:45:57','2022-07-14 17:45:57','807',727561.40,727561.40,'807','2022-07-13 17:49:26','611','2022-07-13 19:05:44',10,0),('1','248',177,'MORNING SHIFT','2022-07-13','2022-07-13 19:12:43','2022-07-14 19:12:43','807',3136280.95,3136280.95,'807','2022-07-13 19:28:00','611','2022-07-14 10:45:25',10,0),('1','248',178,'AFTERNOON SHIFT','2022-07-13','2022-07-14 10:49:16','2022-07-15 10:49:16','807',7292537.50,7292537.50,'807','2022-07-14 10:56:33','454','2022-07-14 11:50:09',10,0),('1','248',179,'MORNING SHIFT','2022-07-14','2022-07-14 16:13:53','2022-07-15 16:13:53','807',4183407.75,4183407.75,'807','2022-07-14 16:27:46','611','2022-07-14 16:35:53',10,0),('1','248',180,'AFTERNOON SHIFT','2022-07-14','2022-07-15 08:52:05','2022-07-16 08:52:05','807',6059585.20,6059585.20,'807','2022-07-15 09:10:00','454','2022-07-15 11:27:09',10,0),('1','248',181,'MORNING SHIFT','2022-07-15','2022-07-16 09:42:20','2022-07-17 09:42:20','807',4701191.05,4701191.05,'807','2022-07-16 10:16:14','611','2022-07-16 10:31:45',10,0),('1','248',182,'AFTERNOON SHIFT','2022-07-15','2022-07-16 10:36:59','2022-07-17 10:36:59','807',7211810.35,7211810.35,'807','2022-07-16 10:43:32','611','2022-07-16 16:24:48',10,0),('1','248',183,'MORNING SHIFT','2022-07-16','2022-07-17 16:54:53','2022-07-18 16:54:53','807',4192397.00,4192397.00,'807','2022-07-17 17:00:06','611','2022-07-17 17:09:37',10,0),('1','248',184,'AFTERNOON SHIFT','2022-07-16','2022-07-17 17:26:58','2022-07-18 17:26:58','807',6148874.20,6148874.20,'807','2022-07-17 17:33:24','611','2022-07-17 17:38:40',10,0),('1','248',185,'FULL DAY ','2022-07-17','2022-07-18 11:07:46','2022-07-19 11:07:46','807',6530416.00,6530416.00,'807','2022-07-18 11:24:30','611','2022-07-18 11:36:44',10,0),('1','248',186,'FULL DAY ','2022-07-18','2022-07-19 10:14:06','2022-07-20 10:14:06','807',6620223.75,6620223.75,'807','2022-07-19 10:47:55','913','2022-07-19 11:19:57',10,0),('1','248',187,'MORNING SHIFT','2022-07-19','2022-07-19 16:00:33','2022-07-20 16:00:33','807',3943564.80,3943564.80,'807','2022-07-19 16:07:05','913','2022-07-19 16:19:17',10,0),('1','248',188,'AFTERNOON SHIFT','2022-07-19','2022-07-20 17:42:56','2022-07-21 17:42:56','807',1112526.80,1112526.80,'807','2022-07-20 17:47:10','913','2022-07-20 18:25:57',10,0),('1','248',189,'FULL DAY ','2022-07-20','2022-07-21 10:08:32','2022-07-22 10:08:32','807',7885893.15,7885893.15,'807','2022-07-21 10:48:17','913','2022-07-21 13:00:36',10,0),('1','248',190,'FULL DAY ','2022-07-21','2022-07-22 11:19:08','2022-07-23 11:19:08','807',2164849.20,2164849.20,'807','2022-07-22 11:46:03','454','2022-07-22 11:49:23',10,0),('1','248',191,'FULL DAY ','2022-07-22','2022-07-23 09:56:40','2022-07-24 09:56:40','807',666496.00,666496.00,'807','2022-07-23 10:01:18','913','2022-07-23 10:02:52',10,0),('1','248',192,'FULL DAY ','2022-07-23','2022-07-24 12:07:43','2022-07-25 12:07:43','807',8993148.65,8993148.65,'807','2022-07-24 12:29:57','913','2022-07-24 15:40:39',10,0),('1','248',193,'MORNING SHIFT','2022-07-24','2022-07-24 17:23:15','2022-07-25 17:23:15','807',3656049.70,3656049.70,'807','2022-07-24 17:56:13','913','2022-07-24 17:59:29',10,0),('1','248',194,'AFTERNOON SHIFT','2022-07-24','2022-07-25 13:46:27','2022-07-26 13:46:27','807',7333928.90,7333928.90,'807','2022-07-25 13:58:10','913','2022-07-25 14:05:28',10,0),('1','248',195,'MORNING SHIFT','2022-07-25','2022-07-25 20:05:24','2022-07-26 20:05:24','807',5737134.55,5737134.55,'807','2022-07-25 22:20:01','913','2022-07-26 07:20:04',10,0),('1','248',196,'AFTERNOON SHIFT','2022-07-25','2022-07-26 10:29:27','2022-07-27 10:29:27','807',7543110.45,7543110.45,'807','2022-07-26 10:39:22','611','2022-07-26 11:08:39',10,0),('1','248',197,'MORNING SHIFT','2022-07-26','2022-07-26 19:15:36','2022-07-27 19:15:36','807',8958229.20,8958229.20,'807','2022-07-26 20:45:56','611','2022-07-27 07:07:09',10,0),('1','248',198,'AFTERNOON SHIFT','2022-07-26','2022-07-27 10:37:42','2022-07-28 10:37:42','807',9973731.65,9973731.65,'807','2022-07-27 10:46:54','611','2022-07-27 11:17:11',10,0),('1','248',199,'MORNING SHIFT','2022-07-27','2022-07-28 13:19:33','2022-07-29 13:19:33','807',7072395.15,7072395.15,'807','2022-07-28 13:34:48','611','2022-07-28 14:07:30',10,0),('1','248',200,'AFTERNOON SHIFT','2022-07-27','2022-07-28 19:32:12','2022-07-29 19:32:12','807',7364681.55,7364681.55,'807','2022-07-28 19:45:57','913','2022-07-28 20:02:33',10,0),('1','248',201,'MORNING SHIFT','2022-07-28','2022-07-28 20:16:59','2022-07-29 20:16:59','807',6444821.75,6444821.75,'807','2022-07-28 20:33:44','913','2022-07-28 20:50:20',10,0),('1','248',202,'AFTERNOON SHIFT','2022-07-28','2022-07-29 10:12:47','2022-07-30 10:12:47','807',6877254.10,6877254.10,'807','2022-07-29 11:21:53','913','2022-07-29 12:34:22',10,0),('1','248',203,'MORNING SHIFT','2022-07-29','2022-07-29 16:53:04','2022-07-30 16:53:04','807',3756942.70,3756942.70,'807','2022-07-29 19:46:02','913','2022-07-29 20:59:08',10,0),('1','248',204,'AFTERNOON SHIFT','2022-07-29','2022-07-30 10:27:42','2022-07-31 10:27:42','807',5272548.45,5272548.45,'807','2022-07-30 10:56:41','913','2022-07-30 13:48:41',10,0),('1','248',205,'MORNING SHIFT','2022-07-30','2022-07-30 14:40:51','2022-07-31 14:40:51','807',6291405.80,6291405.80,'807','2022-07-30 14:49:12','913','2022-07-30 15:46:45',10,0),('1','248',206,'AFTERNOON SHIFT','2022-07-30','2022-07-31 09:37:03','2022-08-01 09:37:03','807',6023283.30,6023283.30,'807','2022-07-31 09:48:03','913','2022-07-31 10:14:28',10,0),('1','248',207,'MORNING SHIFT','2022-07-31','2022-07-31 14:49:35','2022-08-01 14:49:35','807',2026845.30,2026845.30,'807','2022-07-31 15:03:13','913','2022-07-31 15:39:14',10,0),('1','248',208,'AFTERNOON SHIFT','2022-07-31','2022-08-01 10:19:23','2022-08-02 10:19:23','807',6857602.60,6857602.60,'807','2022-08-01 10:31:16','913','2022-08-01 14:44:52',10,0),('1','248',209,'MORNING SHIFT','2022-08-01','2022-08-01 14:48:38','2022-08-02 14:48:38','807',3529206.80,3529206.80,'807','2022-08-01 14:56:55','913','2022-08-01 18:17:27',10,0),('1','248',210,'AFTERNOON SHIFT','2022-08-01','2022-08-02 12:01:44','2022-08-03 12:01:44','807',5294560.50,5294560.50,'807','2022-08-02 13:02:33','913','2022-08-02 13:04:39',10,0),('1','248',211,'MORNING SHIFT','2022-08-02','2022-08-02 16:36:21','2022-08-03 16:36:21','807',3335287.30,3335287.30,'807','2022-08-02 16:47:32','913','2022-08-02 17:09:11',10,0),('1','248',212,'AFTERNOON SHIFT','2022-08-02','2022-08-03 09:17:56','2022-08-04 09:17:56','807',5752804.00,5752804.00,'807','2022-08-03 09:26:58','913','2022-08-03 13:11:21',10,0),('1','248',213,'MORNING SHIFT','2022-08-03','2022-08-03 17:11:25','2022-08-04 17:11:25','807',3904424.15,3904424.15,'807','2022-08-03 19:00:02','913','2022-08-03 19:46:01',10,0),('1','248',214,'AFTERNOON SHIFT','2022-08-03','2022-08-04 09:12:03','2022-08-05 09:12:03','807',5801376.70,5801376.70,'807','2022-08-04 12:47:24','913','2022-08-04 13:03:29',10,0),('1','248',215,'MORNING SHIFT','2022-08-04','2022-08-04 16:18:03','2022-08-05 16:18:03','807',6347069.50,6347069.50,'807','2022-08-04 16:32:16','913','2022-08-04 18:02:18',10,0),('1','248',216,'AFTERNOON SHIFT','2022-08-04','2022-08-05 09:37:12','2022-08-06 09:37:12','807',7915620.70,7915620.70,'807','2022-08-05 10:15:38','913','2022-08-05 11:09:53',10,0),('1','248',217,'MORNING SHIFT','2022-08-05','2022-08-05 17:44:53','2022-08-06 17:44:53','807',8850555.90,8850555.90,'807','2022-08-05 18:14:02','913','2022-08-05 23:25:04',10,0),('1','248',218,'AFTERNOON SHIFT','2022-08-05','2022-08-06 10:02:39','2022-08-07 10:02:39','807',7639691.15,7639691.15,'807','2022-08-06 10:15:12','913','2022-08-06 14:19:55',10,0),('1','248',219,'MORNING SHIFT','2022-08-06','2022-08-06 17:28:17','2022-08-07 17:28:17','807',9606564.15,9606564.15,'807','2022-08-06 17:50:15','611','2022-08-06 19:37:16',10,0),('1','248',220,'AFTERNOON SHIFT','2022-08-06','2022-08-07 17:14:00','2022-08-08 17:14:00','807',3295090.05,3295090.05,'807','2022-08-07 17:24:04','913','2022-08-07 17:26:08',10,0),('1','248',221,'MORNING SHIFT','2022-08-07','2022-08-07 17:29:05','2022-08-08 17:29:05','807',8674927.00,8674927.00,'807','2022-08-07 19:59:00','913','2022-08-07 23:04:58',10,0),('1','248',222,'AFTERNOON SHIFT','2022-08-07','2022-08-08 09:32:02','2022-08-09 09:32:02','807',4130302.55,4130302.55,'807','2022-08-08 10:36:13','913','2022-08-08 10:44:05',10,0),('1','248',223,'MORNING SHIFT','2022-08-08','2022-08-08 20:13:48','2022-08-09 20:13:48','807',6973006.40,6973006.40,'807','2022-08-08 20:29:08','913','2022-08-08 22:40:14',10,0),('1','248',224,'AFTERNOON SHIFT','2022-08-08','2022-08-09 10:01:33','2022-08-10 10:01:33','807',6581810.35,6581810.35,'807','2022-08-09 10:49:22','913','2022-08-09 10:56:26',10,0),('1','248',225,'MORNING SHIFT','2022-08-09','2022-08-09 16:44:47','2022-08-10 16:44:47','807',7677982.80,7677982.80,'807','2022-08-09 18:56:00','913','2022-08-09 18:57:33',10,0),('1','248',226,'AFTERNOON SHIFT','2022-08-09','2022-08-10 09:43:17','2022-08-11 09:43:17','807',3778180.05,3778180.05,'807','2022-08-10 11:15:49','913','2022-08-10 11:25:04',10,0),('1','248',227,'MORNING SHIFT','2022-08-10','2022-08-10 19:16:00','2022-08-11 19:16:00','807',8493664.80,8493664.80,'807','2022-08-10 19:31:47','913','2022-08-10 19:57:55',10,0),('1','248',228,'AFTERNOON SHIFT','2022-08-10','2022-08-11 09:29:03','2022-08-12 09:29:03','807',1953680.25,1953680.25,'807','2022-08-11 11:11:41','913','2022-08-11 11:16:47',10,0),('1','248',229,'FULL DAY ','2022-08-11','2022-08-12 10:16:36','2022-08-13 10:16:36','807',4846583.15,4846583.15,'807','2022-08-12 10:29:24','913','2022-08-12 10:52:08',10,0),('1','248',230,'MORNING SHIFT','2022-08-12','2022-08-12 19:41:43','2022-08-13 19:41:43','807',5531310.75,5531310.75,'807','2022-08-12 19:48:07','913','2022-08-12 20:43:38',10,0),('1','248',231,'AFTERNOON SHIFT','2022-08-12','2022-08-13 11:03:15','2022-08-14 11:03:15','807',7103893.00,7103893.00,'807','2022-08-13 11:17:51','913','2022-08-13 12:26:40',10,0),('1','248',232,'MORNING SHIFT','2022-08-13','2022-08-13 15:53:12','2022-08-14 15:53:12','807',7059792.95,7059792.95,'807','2022-08-13 16:08:31','913','2022-08-13 20:19:18',10,0),('1','248',233,'AFTERNOON SHIFT','2022-08-13','2022-08-14 10:37:07','2022-08-15 10:37:07','807',6777983.75,6777983.75,'807','2022-08-14 10:48:01','913','2022-08-14 11:00:28',10,0),('1','248',234,'MORNING SHIFT','2022-08-14','2022-08-14 16:53:45','2022-08-15 16:53:45','807',6596932.80,6596932.80,'807','2022-08-14 17:17:55','913','2022-08-14 20:02:14',10,0),('1','248',235,'AFTERNOON SHIFT','2022-08-14','2022-08-15 07:58:41','2022-08-16 07:58:41','807',4594921.90,4594921.90,'807','2022-08-15 09:57:11','454','2022-08-15 11:29:41',10,0),('1','248',236,'MORNING SHIFT','2022-08-15','2022-08-15 18:07:01','2022-08-16 18:07:01','807',6048606.90,6048606.90,'807','2022-08-15 18:23:07','913','2022-08-15 18:24:43',10,0),('1','248',237,'AFTERNOON SHIFT','2022-08-15','2022-08-16 09:06:03','2022-08-17 09:06:03','807',3950442.10,3950442.10,'807','2022-08-16 09:34:08','913','2022-08-16 10:48:12',10,0),('1','248',238,'MORNING SHIFT','2022-08-16','2022-08-16 15:32:49','2022-08-17 15:32:49','807',6251589.45,6251589.45,'807','2022-08-16 15:44:06','913','2022-08-16 16:27:20',10,0),('1','248',239,'AFTERNOON SHIFT','2022-08-16','2022-08-17 09:13:11','2022-08-18 09:13:11','807',3852947.00,3852947.00,'807','2022-08-17 09:24:35','611','2022-08-17 09:34:49',10,0),('1','248',240,'MORNING SHIFT','2022-08-17','2022-08-17 15:40:43','2022-08-18 15:40:43','807',4748632.95,4748632.95,'807','2022-08-17 16:13:47','913','2022-08-17 16:28:04',10,0),('1','248',241,'AFTERNOON SHIFT','2022-08-17','2022-08-18 10:38:40','2022-08-19 10:38:40','807',2162472.00,2162472.00,'807','2022-08-18 10:41:11','913','2022-08-18 10:41:52',10,0),('1','248',242,'MORNING SHIFT','2022-08-18','2022-08-18 11:39:04','2022-08-19 11:39:04','807',8930125.75,8930125.75,'807','2022-08-18 15:40:30','913','2022-08-18 15:47:29',10,0),('1','248',243,'AFTERNOON SHIFT','2022-08-18','2022-08-19 09:51:56','2022-08-20 09:51:56','807',8671648.25,8671648.25,'807','2022-08-19 10:03:55','913','2022-08-19 10:10:28',10,0),('1','248',244,'MORNING SHIFT','2022-08-19','2022-08-19 17:36:20','2022-08-20 17:36:20','807',6761020.25,6761020.25,'807','2022-08-19 17:46:16','913','2022-08-19 17:47:10',10,0),('1','248',245,'AFTERNOON SHIFT','2022-08-19','2022-08-20 09:50:14','2022-08-21 09:50:14','807',6206708.00,6206708.00,'807','2022-08-20 10:08:30','913','2022-08-20 10:59:11',10,0),('1','248',246,'MORNING SHIFT','2022-08-20','2022-08-20 15:14:38','2022-08-21 15:14:38','807',7276492.75,7276492.75,'807','2022-08-20 15:39:28','913','2022-08-20 15:42:08',10,0),('1','248',247,'AFTERNOON SHIFT','2022-08-20','2022-08-21 09:17:48','2022-08-22 09:17:48','807',6952647.50,6952647.50,'807','2022-08-21 09:50:11','913','2022-08-21 12:35:32',10,0),('1','248',248,'MORNING SHIFT','2022-08-21','2022-08-21 16:07:06','2022-08-22 16:07:06','807',7160085.50,7160085.50,'807','2022-08-21 16:13:48','913','2022-08-21 16:45:51',10,0),('1','248',249,'AFTERNOON SHIFT','2022-08-21','2022-08-22 10:49:05','2022-08-23 10:49:05','807',7186688.75,7186688.75,'807','2022-08-22 12:09:24','913','2022-08-22 12:10:57',10,0),('1','248',250,'MORNING SHIFT','2022-08-22','2022-08-22 12:17:57','2022-08-23 12:17:57','807',6254194.25,6254194.25,'807','2022-08-22 17:47:46','913','2022-08-22 17:48:27',10,0),('1','248',251,'AFTERNOON SHIFT','2022-08-22','2022-08-23 10:19:30','2022-08-24 10:19:30','807',7879425.00,7879425.00,'807','2022-08-23 10:24:56','913','2022-08-23 10:40:34',10,0),('1','248',252,'MORNING SHIFT','2022-08-23','2022-08-23 10:55:19','2022-08-24 10:55:19','807',7540625.00,7540625.00,'807','2022-08-23 16:37:01','913','2022-08-23 16:39:21',10,0),('1','248',253,'AFTERNOON SHIFT','2022-08-23','2022-08-24 09:37:41','2022-08-25 09:37:41','807',7253355.50,7253355.50,'807','2022-08-24 11:15:21','913','2022-08-24 11:31:31',10,0),('1','248',254,'MORNING SHIFT','2022-08-24','2022-08-24 12:12:03','2022-08-25 12:12:03','807',7698484.50,7698484.50,'807','2022-08-24 18:51:24','913','2022-08-24 19:49:47',10,0),('1','248',255,'AFTERNOON SHIFT','2022-08-24','2022-08-25 10:20:16','2022-08-26 10:20:16','807',7471329.00,7471329.00,'807','2022-08-25 10:33:01','913','2022-08-25 11:32:30',10,0),('1','248',256,'MORNING SHIFT','2022-08-25','2022-08-25 17:07:50','2022-08-26 17:07:50','807',8314628.75,8314628.75,'807','2022-08-25 17:18:45','611','2022-08-25 19:24:31',10,0),('1','248',257,'AFTERNOON SHIFT','2022-08-25','2022-08-26 09:24:12','2022-08-27 09:24:12','807',8848230.50,8848230.50,'807','2022-08-26 09:39:10','913','2022-08-26 10:59:34',10,0),('1','248',258,'MORNING SHIFT','2022-08-26','2022-08-26 16:04:17','2022-08-27 16:04:17','807',4997545.25,4997545.25,'807','2022-08-26 16:14:56','913','2022-08-26 16:30:22',10,0),('1','248',259,'AFTERNOON SHIFT','2022-08-26','2022-08-27 09:45:56','2022-08-28 09:45:56','807',5963101.00,5963101.00,'807','2022-08-27 09:53:52','913','2022-08-27 10:35:20',10,0),('1','248',260,'MORNING SHIFT','2022-08-27','2022-08-27 15:42:02','2022-08-28 15:42:02','807',4038732.00,4038732.00,'807','2022-08-27 16:40:02','913','2022-08-27 16:42:42',10,0),('1','248',261,'AFTERNOON SHIFT','2022-08-27','2022-08-28 09:14:30','2022-08-29 09:14:30','807',3645610.25,3645610.25,'807','2022-08-28 09:24:44','913','2022-08-28 12:15:00',10,0),('1','248',262,'MORNING SHIFT','2022-08-28','2022-08-28 13:28:11','2022-08-29 13:28:11','807',3045378.00,3045378.00,'807','2022-08-28 13:35:10','913','2022-08-28 15:08:03',10,0),('1','248',263,'AFTERNOON SHIFT','2022-08-28','2022-08-29 10:15:30','2022-08-30 10:15:30','807',5254345.25,5254345.25,'807','2022-08-29 10:40:49','913','2022-08-29 11:38:17',10,0),('1','248',264,'MORNING SHIFT','2022-08-29','2022-08-29 16:13:13','2022-08-30 16:13:13','807',6333207.25,6333207.25,'807','2022-08-29 16:23:15','913','2022-08-29 16:57:13',10,0),('1','248',265,'AFTERNOON SHIFT','2022-08-29','2022-08-30 06:51:40','2022-08-31 06:51:40','807',5847628.00,5847628.00,'807','2022-08-30 09:54:41','913','2022-08-30 10:12:22',10,0),('1','248',266,'MORNING SHIFT','2022-08-30','2022-08-30 16:02:37','2022-08-31 16:02:37','807',8448816.00,8448816.00,'807','2022-08-30 16:15:25','913','2022-08-30 16:49:46',10,0),('1','248',267,'AFTERNOON SHIFT','2022-08-30','2022-08-31 09:19:31','2022-09-01 09:19:31','807',4512280.50,4512280.50,'807','2022-08-31 09:28:09','913','2022-08-31 10:30:18',10,0),('1','248',268,'MORNING SHIFT','2022-08-31','2022-08-31 16:22:23','2022-09-01 16:22:23','807',8453834.25,8453834.25,'807','2022-08-31 16:35:13','913','2022-08-31 20:17:51',10,0),('1','248',269,'AFTERNOON SHIFT','2022-08-31','2022-09-01 09:09:19','2022-09-02 09:09:19','807',7308708.50,7308708.50,'807','2022-09-01 09:42:01','913','2022-09-01 12:28:40',10,0),('1','248',270,'MORNING SHIFT','2022-09-01','2022-09-01 15:00:10','2022-09-02 15:00:10','807',6994553.50,6994553.50,'807','2022-09-01 15:11:56','913','2022-09-01 17:33:00',10,0),('1','248',271,'AFTERNOON SHIFT','2022-09-01','2022-09-02 10:22:13','2022-09-03 10:22:13','807',6629983.25,6629983.25,'807','2022-09-02 11:35:06','913','2022-09-02 12:02:41',10,0),('1','248',272,'MORNING SHIFT','2022-09-02','2022-09-02 17:04:57','2022-09-03 17:04:57','807',6044851.00,6044851.00,'807','2022-09-02 17:22:55','913','2022-09-02 19:08:08',10,0),('1','248',273,'AFTERNOON SHIFT','2022-09-02','2022-09-03 09:08:55','2022-09-04 09:08:55','807',5681759.25,5681759.25,'807','2022-09-03 09:22:42','913','2022-09-03 12:36:45',10,0),('1','248',274,'MORNING SHIFT','2022-09-03','2022-09-03 15:30:08','2022-09-04 15:30:08','807',7353812.50,7353812.50,'807','2022-09-03 15:41:35','913','2022-09-03 18:08:33',10,0),('1','248',275,'AFTERNOON SHIFT','2022-09-03','2022-09-04 09:53:17','2022-09-05 09:53:17','807',2941439.50,2941439.50,'807','2022-09-04 10:08:16','913','2022-09-04 12:06:31',10,0),('1','248',276,'MORNING SHIFT','2022-09-04','2022-09-04 15:32:15','2022-09-05 15:32:15','807',6955080.75,6955080.75,'807','2022-09-04 15:43:37','913','2022-09-04 16:39:10',10,0),('1','248',277,'AFTERNOON SHIFT','2022-09-04','2022-09-05 09:35:52','2022-09-06 09:35:52','807',4695797.25,4695797.25,'807','2022-09-05 09:46:42','913','2022-09-05 11:35:07',10,0),('1','248',278,'MORNING SHIFT','2022-09-05','2022-09-05 18:57:32','2022-09-06 18:57:32','807',6680830.50,6680830.50,'807','2022-09-05 20:50:01','913','2022-09-05 22:22:15',10,0),('1','248',279,'AFTERNOON SHIFT','2022-09-05','2022-09-06 12:07:48','2022-09-07 12:07:48','807',1526120.00,1526120.00,'807','2022-09-06 12:08:49','913','2022-09-06 12:46:14',10,0),('1','248',280,'MORNING SHIFT','2022-09-06','2022-09-06 13:28:25','2022-09-07 13:28:25','807',848192.00,848192.00,'807','2022-09-06 18:38:12','913','2022-09-06 18:48:57',10,0),('1','248',281,'AFTERNOON SHIFT','2022-09-06','2022-09-07 09:47:45','2022-09-08 09:47:45','807',8425866.00,8425866.00,'807','2022-09-07 10:13:42','913','2022-09-07 11:37:32',10,0),('1','248',282,'MORNING SHIFT','2022-09-07','2022-09-07 16:05:09','2022-09-08 16:05:09','807',7215390.75,7215390.75,'807','2022-09-07 16:13:50','913','2022-09-07 18:05:17',10,0),('1','248',283,'AFTERNOON SHIFT','2022-09-07','2022-09-08 10:04:22','2022-09-09 10:04:22','807',7734754.00,7734754.00,'807','2022-09-08 10:14:00','913','2022-09-08 11:03:29',10,0),('1','248',284,'MORNING SHIFT','2022-09-08','2022-09-08 16:34:49','2022-09-09 16:34:49','807',7670619.25,7670619.25,'807','2022-09-08 16:48:35','913','2022-09-08 16:50:13',10,0),('1','248',285,'AFTERNOON SHIFT','2022-09-08','2022-09-08 17:12:36','2022-09-09 17:12:36','807',7032370.50,7032370.50,'807','2022-09-09 09:52:56','913','2022-09-09 11:58:35',10,0),('1','248',286,'MORNING SHIFT','2022-09-09','2022-09-09 15:36:30','2022-09-10 15:36:30','807',5592542.75,5592542.75,'807','2022-09-09 15:49:27','913','2022-09-09 15:55:33',10,0),('1','248',287,'AFTERNOON SHIFT','2022-09-09','2022-09-10 09:49:18','2022-09-11 09:49:18','807',828656.00,828656.00,'807','2022-09-10 09:53:34','913','2022-09-10 10:47:44',10,0),('1','248',288,'FULL DAY ','2022-09-10','2022-09-11 10:13:03','2022-09-12 10:13:03','807',4844043.25,4844043.25,'807','2022-09-11 10:44:50','913','2022-09-11 10:49:35',10,0),('1','248',289,'MORNING SHIFT','2022-09-11','2022-09-11 15:15:06','2022-09-12 15:15:06','807',5627170.00,5627170.00,'807','2022-09-11 15:46:11','913','2022-09-11 16:45:42',10,0),('1','248',290,'AFTERNOON SHIFT','2022-09-11','2022-09-12 09:30:20','2022-09-13 09:30:20','807',6570751.75,6570751.75,'807','2022-09-12 10:02:03','913','2022-09-12 11:28:47',10,0),('1','248',291,'MORNING SHIFT','2022-09-12','2022-09-12 15:07:04','2022-09-13 15:07:04','807',5826028.50,5826028.50,'807','2022-09-12 15:22:12','913','2022-09-12 16:28:23',10,0),('1','248',292,'AFTERNOON SHIFT','2022-09-12','2022-09-13 09:43:47','2022-09-14 09:43:47','807',8149274.50,8149274.50,'807','2022-09-13 10:49:54','913','2022-09-13 10:50:38',10,0),('1','248',293,'MORNING SHIFT','2022-09-13','2022-09-13 15:35:15','2022-09-14 15:35:15','807',6045717.75,6045717.75,'807','2022-09-13 15:45:07','913','2022-09-13 15:57:29',10,0),('1','248',294,'AFTERNOON SHIFT','2022-09-13','2022-09-14 09:14:32','2022-09-15 09:14:32','807',5910043.50,5910043.50,'807','2022-09-14 09:27:19','913','2022-09-14 10:19:07',10,0),('1','248',295,'MORNING SHIFT','2022-09-14','2022-09-14 15:09:23','2022-09-15 15:09:23','807',6456804.00,6456804.00,'807','2022-09-14 15:37:32','913','2022-09-14 16:49:55',10,0),('1','248',296,'AFTERNOON SHIFT','2022-09-14','2022-09-15 09:47:22','2022-09-16 09:47:22','807',6343881.50,6343881.50,'807','2022-09-15 09:58:11','913','2022-09-15 10:19:35',10,0),('1','248',297,'MORNING SHIFT','2022-09-15','2022-09-15 15:31:36','2022-09-16 15:31:36','807',7192347.75,7192347.75,'807','2022-09-15 15:51:33','913','2022-09-15 16:02:05',10,0),('1','248',298,'AFTERNOON SHIFT','2022-09-15','2022-09-16 10:29:05','2022-09-17 10:29:05','807',6896220.25,6896220.25,'807','2022-09-16 10:41:59','913','2022-09-16 11:40:44',10,0),('1','248',299,'MORNING SHIFT','2022-09-16','2022-09-16 15:21:16','2022-09-17 15:21:16','807',2407235.25,2407235.25,'807','2022-09-16 15:34:42','913','2022-09-16 16:21:55',10,0),('1','248',300,'AFTERNOON SHIFT','2022-09-16','2022-09-17 09:34:41','2022-09-18 09:34:41','807',1136128.00,1136128.00,'807','2022-09-17 09:51:53','913','2022-09-17 11:34:54',10,0),('1','248',301,'MORNING SHIFT','2022-09-17','2022-09-17 15:05:05','2022-09-18 15:05:05','807',7235315.75,7235315.75,'807','2022-09-17 15:17:50','913','2022-09-17 17:11:42',10,0),('1','248',302,'AFTERNOON SHIFT','2022-09-17','2022-09-18 09:50:51','2022-09-19 09:50:51','807',8082838.50,8082838.50,'807','2022-09-18 10:34:52','913','2022-09-18 10:41:08',10,0),('1','248',303,'MORNING SHIFT','2022-09-18','2022-09-18 17:10:16','2022-09-19 17:10:16','807',6241655.50,6241655.50,'807','2022-09-18 17:32:10','913','2022-09-18 17:50:15',10,0),('1','248',304,'AFTERNOON SHIFT','2022-09-18','2022-09-19 09:32:51','2022-09-20 09:32:51','807',3123053.00,3123053.00,'807','2022-09-19 09:46:52','913','2022-09-19 10:28:49',10,0),('1','248',305,'MORNING SHIFT','2022-09-19','2022-09-19 15:32:15','2022-09-20 15:32:15','807',6972080.50,6972080.50,'807','2022-09-19 15:41:58','913','2022-09-19 16:23:05',10,0),('1','248',306,'AFTERNOON SHIFT','2022-09-19','2022-09-20 08:22:39','2022-09-21 08:22:39','807',3651463.25,3651463.25,'807','2022-09-20 10:06:23','913','2022-09-20 10:12:04',10,0),('1','248',307,'MORNING SHIFT','2022-09-20','2022-09-20 15:13:03','2022-09-21 15:13:03','807',8180124.75,8180124.75,'807','2022-09-20 15:29:37','913','2022-09-20 15:58:33',10,0),('1','248',308,'AFTERNOON SHIFT','2022-09-20','2022-09-21 09:20:14','2022-09-22 09:20:14','807',6278930.00,6278930.00,'807','2022-09-21 10:08:06','913','2022-09-21 10:37:26',10,0),('1','248',309,'MORNING SHIFT','2022-09-21','2022-09-21 15:25:38','2022-09-22 15:25:38','807',6017351.00,6017351.00,'807','2022-09-21 15:54:07','913','2022-09-21 16:16:30',10,0),('1','248',310,'AFTERNOON SHIFT','2022-09-21','2022-09-22 09:12:38','2022-09-23 09:12:38','807',4319883.50,4319883.50,'807','2022-09-22 10:26:10','913','2022-09-22 12:11:47',10,0),('1','248',311,'MORNING SHIFT','2022-09-22','2022-09-22 14:44:11','2022-09-23 14:44:11','807',7550644.25,7550644.25,'807','2022-09-22 14:55:16','913','2022-09-22 15:18:19',10,0),('1','248',312,'AFTERNOON SHIFT','2022-09-22','2022-09-23 11:04:17','2022-09-24 11:04:17','807',6607056.75,6607056.75,'807','2022-09-23 11:23:40','913','2022-09-23 11:30:54',10,0),('1','248',313,'MORNING SHIFT','2022-09-23','2022-09-23 15:00:02','2022-09-24 15:00:02','807',4464722.00,4464722.00,'807','2022-09-23 15:15:25','913','2022-09-23 15:33:56',10,0),('1','248',314,'AFTERNOON SHIFT','2022-09-23','2022-09-24 09:54:33','2022-09-25 09:54:33','807',5973961.25,5973961.25,'807','2022-09-24 10:02:00','913','2022-09-24 10:58:57',10,0),('1','248',315,'MORNING SHIFT','2022-09-24','2022-09-24 15:28:33','2022-09-25 15:28:33','807',7435552.50,7435552.50,'807','2022-09-24 15:42:39','913','2022-09-24 16:35:14',10,0),('1','248',316,'AFTERNOON SHIFT','2022-09-25','2022-09-25 09:34:34','2022-09-26 09:34:34','807',7263564.00,7263564.00,'807','2022-09-25 09:51:45','913','2022-09-25 11:35:20',10,0),('1','248',317,'MORNING SHIFT','2022-09-25','2022-09-25 15:09:29','2022-09-26 15:09:29','807',6448571.50,6448571.50,'807','2022-09-25 15:24:20','913','2022-09-25 16:55:19',10,0),('1','248',318,'AFTERNOON SHIFT','2022-09-25','2022-09-26 09:02:24','2022-09-27 09:02:24','807',4967161.00,4967161.00,'807','2022-09-26 09:54:09','913','2022-09-26 10:13:00',10,0),('1','248',319,'MORNING SHIFT','2022-09-26','2022-09-26 15:55:29','2022-09-27 15:55:29','807',5208765.75,5208765.75,'807','2022-09-26 16:13:57','913','2022-09-26 17:44:21',10,0),('1','248',320,'AFTERNOON SHIFT','2022-09-26','2022-09-27 11:05:58','2022-09-28 11:05:58','807',6924553.75,6924553.75,'807','2022-09-27 11:18:09','913','2022-09-27 11:21:22',10,0),('1','248',321,'MORNING SHIFT','2022-09-27','2022-09-27 14:35:40','2022-09-28 14:35:40','807',3106651.25,3106651.25,'807','2022-09-27 14:46:50','913','2022-09-27 15:05:02',10,0),('1','248',322,'AFTERNOON SHIFT','2022-09-27','2022-09-28 09:03:48','2022-09-29 09:03:48','807',5028379.75,5028379.75,'807','2022-09-28 09:51:38','913','2022-09-28 10:34:50',10,0),('1','248',323,'MORNING SHIFT','2022-09-28','2022-09-28 15:23:14','2022-09-29 15:23:14','807',6413224.00,6413224.00,'807','2022-09-28 15:40:24','913','2022-09-28 16:17:31',10,0),('1','248',324,'AFTERNOON SHIFT','2022-09-28','2022-09-29 08:29:52','2022-09-30 08:29:52','807',5833299.50,5833299.50,'807','2022-09-29 09:40:36','913','2022-09-29 10:13:03',10,0),('1','248',325,'AGO CHANGE OF PRICE ','2022-09-29','2022-09-29 15:08:07','2022-09-30 15:08:07','807',780176.00,780176.00,'807','2022-09-29 15:12:44','913','2022-09-29 15:31:39',10,0),('1','248',326,'MORNING SHIFT','2022-09-29','2022-09-29 16:34:25','2022-09-30 16:34:25','807',890998.75,890998.75,'807','2022-09-29 16:39:05','913','2022-09-29 18:15:05',10,0),('1','248',327,'AFTERNOON SHIFT','2022-09-29','2022-09-30 09:38:34','2022-10-01 09:38:34','807',3055047.75,3055047.75,'807','2022-09-30 09:45:43','913','2022-09-30 10:47:49',10,0),('1','248',328,'MORNING SHIFT','2022-09-30','2022-09-30 16:36:09','2022-10-01 16:36:09','807',6220973.15,6220973.15,'807','2022-09-30 16:54:04','913','2022-09-30 17:51:41',10,0),('1','248',329,'AFTERNOON SHIFT','2022-09-30','2022-10-01 10:23:15','2022-10-02 10:23:15','807',6379953.30,6379953.30,'807','2022-10-01 14:31:13','913','2022-10-01 14:56:02',10,0),('1','248',330,'FULL DAY ','2022-10-01','2022-10-02 10:52:08','2022-10-03 10:52:08','807',4131317.75,4131317.75,'807','2022-10-02 10:57:25','913','2022-10-02 14:27:42',10,0),('1','248',331,'FULL DAY ','2022-10-02','2022-10-02 20:52:07','2022-10-03 20:52:07','807',1672476.75,1672476.75,'807','2022-10-02 20:57:41','913','2022-10-03 10:04:07',10,0),('1','248',332,'MORNING SHIFT','2022-10-03','2022-10-03 14:04:06','2022-10-04 14:04:06','807',5824747.25,5824747.25,'807','2022-10-03 15:25:26','913','2022-10-03 16:48:09',10,0),('1','248',333,'AFTERNOON SHIFT','2022-10-03','2022-10-04 09:47:52','2022-10-05 09:47:52','807',3447146.50,3447146.50,'807','2022-10-04 10:06:40','913','2022-10-04 11:27:15',10,0),('1','248',334,'MORNING SHIFT','2022-10-04','2022-10-06 14:05:40','2022-10-07 14:05:40','807',3002854.75,3002854.75,'807','2022-10-06 14:24:48','913','2022-10-06 14:56:08',10,0),('1','248',335,'AFTERNOON SHIFT','2022-10-04','2022-10-06 15:22:07','2022-10-07 15:22:07','807',5159603.75,5159603.75,'807','2022-10-06 15:51:21','913','2022-10-07 05:16:09',10,0),('1','248',336,'FULL DAY ','2022-10-05','2022-10-07 10:47:17','2022-10-08 10:47:17','807',1835786.75,1835786.75,'807','2022-10-07 11:39:00','913','2022-10-07 12:08:55',10,0),('1','248',337,'FULL DAY ','2022-10-06','2022-10-07 13:02:32','2022-10-08 13:02:32','807',6519360.45,6519360.45,'807','2022-10-07 13:19:40','913','2022-10-07 16:00:29',10,0),('1','248',338,'FULL DAY ','2022-10-07','2022-10-08 11:08:16','2022-10-09 11:08:16','807',2675783.55,2675783.55,'807','2022-10-08 11:38:25','913','2022-10-08 12:56:38',10,0),('1','248',339,'FULL DAY ','2022-10-08','2022-10-09 17:26:39','2022-10-10 17:26:39','807',4895049.45,4895049.45,'807','2022-10-09 17:35:44','913','2022-10-09 18:02:04',10,0),('1','248',340,'AGO CHANGE OF PRICE ','2022-10-09','2022-10-09 21:04:28','2022-10-10 21:04:28','807',394280.70,394280.70,'807','2022-10-09 21:05:22','913','2022-10-09 22:11:30',10,0),('1','248',341,'FULL DAY ','2022-10-09','2022-10-10 09:20:36','2022-10-11 09:20:36','807',3195355.50,3195355.50,'807','2022-10-10 09:26:52','913','2022-10-10 12:36:08',10,0),('1','248',342,'FULL DAY ','2022-10-10','2022-10-11 11:13:59','2022-10-12 11:13:59','807',2089179.60,2089179.60,'807','2022-10-11 11:19:56','913','2022-10-11 14:52:03',10,0),('1','248',343,'FULL DAY ','2022-10-11','2022-10-12 11:01:41','2022-10-13 11:01:41','807',11982564.05,11982564.05,'807','2022-10-12 11:32:41','913','2022-10-12 12:45:44',10,0),('1','248',344,'FULL DAY ','2022-10-12','2022-10-13 09:19:22','2022-10-14 09:19:22','807',11949256.20,11949256.20,'807','2022-10-13 10:51:19','913','2022-10-13 11:08:46',10,0),('1','248',345,'AGO CHANGE OF PRICE ','2022-10-13','2022-10-13 18:15:32','2022-10-14 18:15:32','807',141991.20,141991.20,'807','2022-10-13 18:18:49','913','2022-10-13 18:56:55',10,0),('1','248',346,'MORNING SHIFT','2022-10-13','2022-10-13 19:01:24','2022-10-14 19:01:24','807',9090628.15,9090628.15,'807','2022-10-13 19:22:21','913','2022-10-13 22:20:36',10,0),('1','248',347,'AFTERNOON SHIFT','2022-10-13','2022-10-14 13:13:47','2022-10-15 13:13:47','807',6379539.80,6379539.80,'807','2022-10-14 13:45:08','913','2022-10-14 14:49:51',10,0),('1','248',348,'MORNING SHIFT','2022-10-14','2022-10-14 18:14:06','2022-10-15 18:14:06','807',4615922.75,4615922.75,'807','2022-10-14 19:01:47','913','2022-10-14 19:54:47',10,0),('1','248',349,'AFTERNOON SHIFT','2022-10-14','2022-10-15 12:34:09','2022-10-16 12:34:09','807',5480497.65,5480497.65,'807','2022-10-15 12:49:57','913','2022-10-15 13:19:46',10,0),('1','248',350,'MORNING SHIFT','2022-10-15','2022-10-15 16:18:44','2022-10-16 16:18:44','807',2721703.70,2721703.70,'807','2022-10-15 16:34:24','913','2022-10-16 06:49:52',10,0),('1','248',351,'AFTERNOON SHIFT','2022-10-15','2022-10-16 10:25:52','2022-10-17 10:25:52','807',5061997.35,5061997.35,'807','2022-10-16 11:06:55','913','2022-10-16 12:43:45',10,0),('1','248',352,'MORNING SHIFT','2022-10-16','2022-10-16 15:47:49','2022-10-17 15:47:49','807',4716256.95,4716256.95,'807','2022-10-16 16:02:35','913','2022-10-16 17:37:23',10,0),('1','248',353,'AFTERNOON SHIFT','2022-10-16','2022-10-17 10:08:28','2022-10-18 10:08:28','807',5066224.90,5066224.90,'807','2022-10-17 10:56:37','913','2022-10-17 11:48:52',10,0),('1','248',354,'MORNING SHIFT','2022-10-17','2022-10-17 15:14:33','2022-10-18 15:14:33','807',2375369.65,2375369.65,'807','2022-10-17 15:27:16','913','2022-10-17 15:38:20',10,0),('1','248',355,'AFTERNOON SHIFT','2022-10-17','2022-10-18 10:14:34','2022-10-19 10:14:34','807',3380810.30,3380810.30,'807','2022-10-18 11:47:01','913','2022-10-18 14:28:24',10,0),('1','248',356,'FULL DAY ','2022-10-18','2022-10-19 10:49:52','2022-10-20 10:49:52','807',7317486.40,7317486.40,'807','2022-10-19 11:27:22','913','2022-10-19 11:35:15',10,0),('1','248',357,'MORNING SHIFT','2022-10-19','2022-10-19 16:54:07','2022-10-20 16:54:07','807',5148117.25,5148117.25,'807','2022-10-19 17:15:04','913','2022-10-19 19:47:56',10,0),('1','248',358,'AFTERNOON SHIFT','2022-10-19','2022-10-20 11:29:48','2022-10-21 11:29:48','807',2214137.75,2214137.75,'807','2022-10-20 11:50:56','913','2022-10-20 11:56:49',10,0),('1','248',359,'MORNING SHIFT','2022-10-20','2022-10-20 17:59:11','2022-10-21 17:59:11','807',12025314.25,12025314.25,'807','2022-10-20 19:30:18','913','2022-10-20 20:06:09',10,0),('1','248',360,'AFTERNOON SHIFT','2022-10-20','2022-10-21 08:55:16','2022-10-22 08:55:16','807',10168138.65,10168138.65,'807','2022-10-21 09:24:17','913','2022-10-21 09:46:25',10,0),('1','248',361,'FULL DAY ','2022-10-21','2022-10-22 11:59:10','2022-10-23 11:59:10','807',10850103.05,10850103.05,'807','2022-10-22 12:21:43','913','2022-10-22 12:39:47',10,0),('1','248',362,'FULL DAY ','2022-10-22','2022-10-23 12:11:51','2022-10-24 12:11:51','807',5728694.60,5728694.60,'807','2022-10-23 12:30:13','913','2022-10-23 12:40:09',10,0),('1','248',363,'MORNING SHIFT','2022-10-23','2022-10-23 14:45:48','2022-10-24 14:45:48','807',7738245.55,7738245.55,'807','2022-10-23 15:14:49','913','2022-10-23 16:25:46',10,0),('1','248',364,'AFTERNOON SHIFT','2022-10-23','2022-10-24 10:21:47','2022-10-25 10:21:47','807',7530831.85,7530831.85,'807','2022-10-24 11:19:46','913','2022-10-24 11:45:22',10,0),('1','248',365,'FULL DAY ','2022-10-24','2022-10-25 10:07:11','2022-10-26 10:07:11','807',5144200.70,5144200.70,'807','2022-10-25 10:23:51','913','2022-10-25 12:43:50',10,0),('1','248',366,'MORNING SHIFT','2022-10-25','2022-10-25 15:38:57','2022-10-26 15:38:57','807',2983739.50,2983739.50,'807','2022-10-25 15:43:46','913','2022-10-25 16:37:51',10,0),('1','248',367,'AFTERNOON SHIFT','2022-10-25','2022-10-26 10:15:15','2022-10-27 10:15:15','807',10489842.75,10489842.75,'807','2022-10-26 10:28:31','913','2022-10-26 11:47:04',10,0),('1','248',368,'MORNING SHIFT','2022-10-26','2022-10-26 17:15:10','2022-10-27 17:15:10','807',1453420.40,1453420.40,'807','2022-10-26 17:27:02','913','2022-10-26 19:30:38',10,0),('1','248',369,'AFTERNOON SHIFT','2022-10-26','2022-10-27 10:42:23','2022-10-28 10:42:23','807',7626413.10,7626413.10,'807','2022-10-27 10:50:44','913','2022-10-27 12:24:45',10,0),('1','248',370,'FULL DAY ','2022-10-27','2022-10-28 09:36:55','2022-10-29 09:36:55','807',6928163.00,6928163.00,'807','2022-10-28 09:47:32','913','2022-10-28 10:17:01',10,0),('1','248',371,'FULL DAY ','2022-10-28','2022-10-29 08:53:07','2022-10-30 08:53:07','807',7639002.30,7639002.30,'807','2022-10-29 09:45:11','913','2022-10-29 10:17:14',10,0),('1','248',372,'FULL DAY ','2022-10-29','2022-10-30 09:09:04','2022-10-31 09:09:04','807',14993331.60,14993331.60,'807','2022-10-30 09:27:36','913','2022-10-30 10:36:06',10,0),('1','248',373,'MORNING SHIFT','2022-10-30','2022-10-30 19:25:27','2022-10-31 19:25:27','807',3347429.75,3347429.75,'807','2022-10-30 19:35:58','913','2022-10-30 22:16:26',10,0),('1','248',374,'AFTERNOON SHIFT','2022-10-30','2022-10-31 11:40:29','2022-11-01 11:40:29','807',8948814.55,8948814.55,'807','2022-10-31 11:51:35','913','2022-10-31 13:43:06',10,0),('1','248',375,'MORNING SHIFT','2022-10-31','2022-10-31 15:59:11','2022-11-01 15:59:11','807',4610254.30,4610254.30,'807','2022-10-31 16:19:35','913','2022-10-31 16:45:21',10,0),('1','248',376,'AFTERNOON SHIFT','2022-10-31','2022-11-01 09:16:42','2022-11-02 09:16:42','807',7806344.55,7806344.55,'807','2022-11-01 09:39:45','913','2022-11-01 09:49:31',10,0),('1','248',377,'FULL DAY ','2022-11-01','2022-11-02 10:10:59','2022-11-03 10:10:59','807',13151519.40,13151519.40,'807','2022-11-02 10:27:59','913','2022-11-02 11:09:38',10,0),('1','248',378,'FULL DAY ','2022-11-02','2022-11-03 10:02:23','2022-11-04 10:02:23','807',10112527.10,10112527.10,'807','2022-11-03 10:37:02','913','2022-11-03 10:52:18',10,0),('1','248',379,'FULL DAY 3','2022-11-03','2022-11-04 10:12:45','2022-11-05 10:12:45','807',14463836.70,14463836.70,'807','2022-11-04 21:31:17','913','2022-11-04 21:45:21',10,0),('1','248',380,'FULL DAY ','2022-11-04','2022-11-04 21:52:40','2022-11-05 21:52:40','807',13376246.65,13376246.65,'807','2022-11-05 11:32:55','913','2022-11-05 14:14:35',10,0),('1','248',381,'FULL DAY ','2022-11-05','2022-11-06 10:02:12','2022-11-07 10:02:12','807',12385675.80,12385675.80,'807','2022-11-06 10:09:39','913','2022-11-06 11:30:39',10,0),('1','248',382,'MORNING SHIFT','2022-11-06','2022-11-07 10:31:06','2022-11-08 10:31:06','807',6348236.30,6348236.30,'807','2022-11-07 10:35:15','913','2022-11-07 10:40:09',10,0),('1','248',383,'AFTERNOON SHIFT','2022-11-06','2022-11-07 10:42:30','2022-11-08 10:42:30','807',511307.45,511307.45,'807','2022-11-07 10:46:35','913','2022-11-07 11:35:11',10,0),('1','248',384,'FULL DAY ','2022-11-07','2022-11-08 10:17:47','2022-11-09 10:17:47','807',9613730.35,9613730.35,'807','2022-11-08 10:29:07','913','2022-11-08 10:47:31',10,0),('1','248',385,'FULL DAY','2022-11-08','2022-11-09 10:36:52','2022-11-10 10:36:52','807',11616978.80,11616978.80,'807','2022-11-09 11:19:42','913','2022-11-09 12:06:44',10,0),('1','248',386,'FULL DAY','2022-11-09','2022-11-10 10:04:01','2022-11-11 10:04:01','807',10412181.30,10412181.30,'807','2022-11-10 12:23:03','913','2022-11-10 14:16:02',10,0),('1','248',387,'AGO CHANGE OF PRICE ','2022-11-10','2022-11-11 09:14:47','2022-11-12 09:14:47','807',1514426.30,1514426.30,'807','2022-11-11 09:15:42','913','2022-11-11 09:18:53',10,0),('1','248',388,'FULL DAY ','2022-11-10','2022-11-11 09:34:28','2022-11-12 09:34:28','807',12417010.30,12417010.30,'807','2022-11-11 09:56:22','913','2022-11-11 09:58:48',10,0),('1','248',389,'FULL DAY ','2022-11-11','2022-11-12 09:50:23','2022-11-13 09:50:23','807',11448882.40,11448882.40,'807','2022-11-12 10:36:48','913','2022-11-12 10:38:26',10,0),('1','248',390,'FULL DAY ','2022-11-12','2022-11-13 09:55:56','2022-11-14 09:55:56','807',9237638.30,9237638.30,'807','2022-11-13 10:41:15','913','2022-11-13 11:51:11',10,0),('1','248',391,'MORNING SHIFT','2022-11-13','2022-11-13 16:17:14','2022-11-14 16:17:14','807',5203321.10,5203321.10,'807','2022-11-13 16:37:18','913','2022-11-14 01:57:01',10,0),('1','248',392,'AFTERNOON SHIFT','2022-11-13','2022-11-14 08:55:56','2022-11-15 08:55:56','807',6865560.90,6865560.90,'807','2022-11-14 09:26:24','913','2022-11-14 10:42:33',10,0),('1','248',393,'FULL DAY ','2022-11-14','2022-11-15 09:23:23','2022-11-16 09:23:23','807',8370728.30,8370728.30,'807','2022-11-15 10:24:44','913','2022-11-15 10:54:39',10,0),('1','248',394,'MORNING SHIFT','2022-11-15','2022-11-15 15:30:34','2022-11-16 15:30:34','807',5467638.00,5467638.00,'807','2022-11-15 16:13:52','913','2022-11-15 16:48:22',10,0),('1','248',395,'AFTERNOON SHIFT','2022-11-15','2022-11-16 08:56:37','2022-11-17 08:56:37','807',8522702.30,8522702.30,'807','2022-11-16 09:15:48','913','2022-11-16 10:44:10',10,0),('1','248',396,'MORNING SHIFT','2022-11-16','2022-11-16 16:45:28','2022-11-17 16:45:28','807',8880070.10,8880070.10,'807','2022-11-16 17:01:46','913','2022-11-16 17:50:35',10,0),('1','248',397,'AFTERNOON SHIFT','2022-11-16','2022-11-17 10:56:22','2022-11-18 10:56:22','807',7395026.60,7395026.60,'807','2022-11-17 11:20:06','913','2022-11-17 11:43:01',10,0),('1','248',398,'FULL DAY ','2022-11-17','2022-11-18 10:17:08','2022-11-19 10:17:08','807',10612763.10,10612763.10,'807','2022-11-18 10:37:17','913','2022-11-18 13:17:31',10,0),('1','248',399,'FULL DAY ','2022-11-18','2022-11-19 09:37:20','2022-11-20 09:37:20','807',9801906.90,9801906.90,'807','2022-11-19 10:25:47','913','2022-11-19 11:33:11',10,0),('1','248',400,'MORNING SHIFT','2022-11-19','2022-11-19 15:27:49','2022-11-20 15:27:49','807',7481586.95,7481586.95,'807','2022-11-19 17:25:28','611','2022-11-19 17:32:22',10,0),('1','248',401,'AFTERNOON SHIFT','2022-11-19','2022-11-20 09:38:11','2022-11-21 09:38:11','807',7882966.30,7882966.30,'807','2022-11-20 09:47:59','913','2022-11-20 10:27:01',10,0),('1','248',402,'MORNING SHIFT','2022-11-20','2022-11-20 15:02:33','2022-11-21 15:02:33','807',4005737.70,4005737.70,'807','2022-11-20 15:11:26','913','2022-11-21 07:51:34',10,0),('1','248',403,'AFTERNOON SHIFT','2022-11-20','2022-11-21 07:57:39','2022-11-22 07:57:39','807',6887382.95,6887382.95,'807','2022-11-21 08:04:54','913','2022-11-21 08:56:14',10,0),('1','248',404,'MORNING SHIFT','2022-11-21','2022-11-21 15:00:14','2022-11-22 15:00:14','807',7153991.50,7153991.50,'807','2022-11-21 15:28:22','913','2022-11-21 15:33:03',10,0),('1','248',405,'AFTERNOON SHIFT','2022-11-21','2022-11-22 08:37:29','2022-11-23 08:37:29','807',1529121.70,1529121.70,'807','2022-11-22 09:45:07','913','2022-11-22 10:23:21',10,0),('1','248',406,'MORNING SHIFT','2022-11-22','2022-11-22 16:30:02','2022-11-23 16:30:02','807',10560859.50,10560859.50,'807','2022-11-22 16:44:13','913','2022-11-22 17:04:52',10,0),('1','248',407,'AFTERNOON SHIFT','2022-11-22','2022-11-23 10:05:41','2022-11-24 10:05:41','807',8294997.65,8294997.65,'807','2022-11-23 15:05:20','913','2022-11-23 16:43:17',10,0),('1','248',408,'MORNING SHIFT','2022-11-23','2022-11-23 17:39:28','2022-11-24 17:39:28','807',3362523.00,3362523.00,'807','2022-11-23 17:48:54','913','2022-11-23 22:48:49',10,0),('1','248',409,'AFTERNOON SHIFT','2022-11-23','2022-11-24 10:28:27','2022-11-25 10:28:27','807',8451955.65,8451955.65,'807','2022-11-24 10:52:41','913','2022-11-24 12:08:50',10,0),('1','248',410,'MORNING SHIFT','2022-11-24','2022-11-24 15:02:24','2022-11-25 15:02:24','807',7041917.40,7041917.40,'807','2022-11-24 15:26:19','913','2022-11-24 15:32:26',10,0),('1','248',411,'AFTERNOON SHIFT','2022-11-24','2022-11-25 09:50:09','2022-11-26 09:50:09','807',6444454.70,6444454.70,'807','2022-11-25 10:08:51','913','2022-11-25 10:50:54',10,0),('1','248',412,'MORNING SHIFT','2022-11-25','2022-11-25 16:57:26','2022-11-26 16:57:26','807',5060581.20,5060581.20,'807','2022-11-25 17:59:18','913','2022-11-25 18:00:00',10,0),('1','248',413,'AFTERNOON SHIFT','2022-11-25','2022-11-26 10:06:09','2022-11-27 10:06:09','807',6056959.80,6056959.80,'807','2022-11-26 10:14:52','913','2022-11-26 12:30:39',10,0),('1','248',414,'MORNING SHIFT','2022-11-26','2022-11-26 17:29:11','2022-11-27 17:29:11','807',5092029.45,5092029.45,'807','2022-11-26 17:42:59','913','2022-11-26 19:42:50',10,0),('1','248',415,'AFTERNOON SHIFT','2022-11-26','2022-11-27 10:39:55','2022-11-28 10:39:55','807',926407.65,926407.65,'807','2022-11-27 10:43:19','913','2022-11-27 11:23:26',10,0),('1','248',416,'MORNING SHIFT','2022-11-27','2022-11-27 16:08:08','2022-11-28 16:08:08','807',9989167.55,9989167.55,'807','2022-11-27 17:06:56','913','2022-11-27 17:19:30',10,0),('1','248',417,'AFTERNOON SHIFT','2022-11-27','2022-11-28 09:12:21','2022-11-29 09:12:21','807',644312.80,644312.80,'807','2022-11-28 09:24:54','913','2022-11-28 11:00:50',10,0),('1','248',418,'FULL DAY ','2022-11-28','2022-11-29 09:30:08','2022-11-30 09:30:08','807',2808717.65,2808717.65,'807','2022-11-29 09:33:01','913','2022-11-29 10:38:46',10,0),('1','248',419,'FULL DAY ','2022-11-29','2022-11-30 09:49:23','2022-12-01 09:49:23','807',7574352.65,7574352.65,'807','2022-11-30 14:34:14','913','2022-11-30 15:05:24',10,0),('1','248',420,'FULL DAY ','2022-11-30','2022-12-01 08:43:19','2022-12-02 08:43:19','807',11168481.05,11168481.05,'807','2022-12-01 09:09:56','913','2022-12-01 10:54:35',10,0),('1','248',421,'FULL DAY ','2022-12-01','2022-12-02 08:55:46','2022-12-03 08:55:46','807',5832833.75,5832833.75,'807','2022-12-02 09:04:40','913','2022-12-02 10:51:59',10,0),('1','248',422,'FULL DAY ','2022-12-02','2022-12-03 08:48:16','2022-12-04 08:48:16','807',12469844.55,12469844.55,'807','2022-12-03 09:58:47','913','2022-12-03 14:17:41',10,0),('1','248',423,'AGO CHANGE OF PRICE ','2022-12-03','2022-12-04 10:02:43','2022-12-05 10:02:43','807',1364783.20,1364783.20,'807','2022-12-04 10:08:46','913','2022-12-04 10:37:23',10,0),('1','248',424,'FULL DAY ','2022-12-03','2022-12-04 10:44:38','2022-12-05 10:44:38','807',2580215.55,2580215.55,'807','2022-12-04 10:59:46','913','2022-12-04 12:15:53',10,0),('1','248',425,'FULL DAY ','2022-12-04','2022-12-05 09:01:28','2022-12-06 09:01:28','807',9503610.05,9503610.05,'807','2022-12-05 09:14:30','913','2022-12-05 10:18:31',10,0),('1','248',426,'FULL DAY ','2022-12-05','2022-12-06 09:46:44','2022-12-07 09:46:44','807',4939402.45,4939402.45,'807','2022-12-06 09:54:03','913','2022-12-06 11:29:00',10,0),('1','248',427,'MORNING SHIFT','2022-12-06','2022-12-06 15:31:42','2022-12-07 15:31:42','807',6068887.65,6068887.65,'807','2022-12-06 15:40:23','913','2022-12-06 16:51:37',10,0),('1','248',428,'AFTERNOON SHIFT','2022-12-06','2022-12-07 08:01:48','2022-12-08 08:01:48','807',1784681.00,1784681.00,'807','2022-12-07 08:06:35','913','2022-12-07 11:28:09',10,0),('1','248',429,'FULL DAY ','2022-12-07','2022-12-07 21:42:30','2022-12-08 21:42:30','807',16881431.30,16881431.30,'807','2022-12-07 21:49:39','913','2022-12-08 09:27:51',10,0),('1','248',430,'FULL DAY ','2022-12-08','2022-12-09 07:41:49','2022-12-10 07:41:49','807',14462656.35,14462656.35,'807','2022-12-09 08:22:53','913','2022-12-09 12:49:21',10,0),('1','248',431,'FULL DAY ','2022-12-09','2022-12-10 07:59:58','2022-12-11 07:59:58','807',17209665.20,17209665.20,'807','2022-12-10 08:14:03','913','2022-12-10 08:59:35',10,0),('1','248',432,'FULL DAY ','2022-12-10','2022-12-11 10:39:54','2022-12-12 10:39:54','807',13470407.98,13470407.98,'807','2022-12-11 10:55:27','913','2022-12-11 12:09:32',10,0),('1','248',433,'FULL DAY ','2022-12-11','2022-12-11 21:05:45','2022-12-12 21:05:45','807',12422698.55,12422698.55,'807','2022-12-11 21:14:52','913','2022-12-12 09:36:24',10,0),('1','248',434,'FULL DAY ','2022-12-12','2022-12-12 19:55:17','2022-12-13 19:55:17','807',9908213.55,9908213.55,'807','2022-12-12 20:52:14','913','2022-12-12 21:35:40',10,0),('1','248',435,'FULL DAY ','2022-12-13','2022-12-14 07:05:38','2022-12-15 07:05:38','807',13575977.15,13575977.15,'807','2022-12-14 11:14:19','913','2022-12-14 11:21:42',10,0),('1','248',436,'FULL DAY ','2022-12-14','2022-12-14 21:09:10','2022-12-15 21:09:10','807',14859180.15,14859180.15,'807','2022-12-14 21:31:22','913','2022-12-14 22:14:17',10,0),('1','248',437,'FULL DAY ','2022-12-15','2022-12-15 19:06:43','2022-12-16 19:06:43','807',12935859.60,12935859.60,'807','2022-12-15 20:14:00','913','2022-12-15 23:54:02',10,0),('1','248',438,'FULL DAY ','2022-12-16','2022-12-16 22:25:54','2022-12-17 22:25:54','807',12118828.55,12118828.55,'807','2022-12-16 22:32:03','913','2022-12-16 22:36:36',10,0),('1','248',439,'FULL DAY ','2022-12-17','2022-12-17 20:52:00','2022-12-18 20:52:00','807',11832926.80,11832926.80,'807','2022-12-17 21:39:03','913','2022-12-18 03:55:51',10,0),('1','248',440,'FULLDAY','2022-12-18','2022-12-18 23:28:17','2022-12-19 23:28:17','807',9681903.25,9681903.25,'807','2022-12-18 23:33:08','913','2022-12-19 08:33:25',10,0),('1','248',441,'FULL DAY ','2022-12-19','2022-12-19 20:03:25','2022-12-20 20:03:25','807',14819435.55,14819435.55,'807','2022-12-20 00:14:44','913','2022-12-20 07:26:47',10,0),('1','248',442,'FULLDAY','2022-12-20','2022-12-20 23:14:07','2022-12-21 23:14:07','807',13773880.00,13773880.00,'807','2022-12-20 23:45:32','913','2022-12-21 07:40:38',10,0),('1','248',443,'FULLDAY','2022-12-21','2022-12-21 21:54:33','2022-12-22 21:54:33','807',11801780.40,11801780.40,'807','2022-12-21 22:34:53','913','2022-12-21 23:22:23',10,0),('1','248',444,'FULLDAY','2022-12-22','2022-12-22 21:23:23','2022-12-23 21:23:23','807',14639308.81,14639308.81,'807','2022-12-23 01:09:20','913','2022-12-23 09:16:27',10,0),('1','248',445,'FULLDAY','2022-12-23','2022-12-23 21:17:00','2022-12-24 21:17:00','807',15822940.75,15822940.75,'807','2022-12-23 21:52:40','913','2022-12-23 22:32:00',10,0),('1','248',446,'FULLDAY','2022-12-24','2022-12-24 17:47:27','2022-12-25 17:47:27','807',12989232.65,12989232.65,'807','2022-12-24 22:05:15','913','2022-12-24 22:59:08',10,0),('1','248',447,'FULLDAY','2022-12-25','2022-12-25 22:24:04','2022-12-26 22:24:04','807',12592112.70,12592112.70,'807','2022-12-25 22:58:18','913','2022-12-26 11:00:05',10,0),('1','248',448,'FULL DAY ','2022-12-26','2022-12-26 20:18:16','2022-12-27 20:18:16','807',2375582.35,2375582.35,'807','2022-12-26 20:31:59','913','2022-12-26 23:38:14',10,0),('1','248',449,'FULLDAY','2022-12-27','2022-12-27 18:06:20','2022-12-28 18:06:20','807',8841435.60,8841435.60,'807','2022-12-27 22:22:07','913','2022-12-28 11:12:41',10,0),('1','248',450,'FULL DAY ','2022-12-28','2022-12-28 20:24:39','2022-12-29 20:24:39','807',15009373.25,15009373.25,'807','2022-12-28 21:54:50','913','2022-12-29 11:40:06',10,0),('1','248',451,'FULL DAY ','2022-12-29','2022-12-29 22:30:27','2022-12-30 22:30:27','807',23216218.65,23216218.65,'807','2022-12-29 23:03:45','913','2022-12-29 23:04:57',10,0),('1','248',452,'FULL DAY ','2022-12-30','2022-12-30 19:55:05','2022-12-31 19:55:05','807',15287093.95,15287093.95,'807','2022-12-30 21:20:05','913','2022-12-30 22:34:00',10,0),('1','248',453,'FULL DAY ','2022-12-31','2022-12-31 20:22:04','2023-01-01 20:22:04','807',12841091.45,12841091.45,'807','2022-12-31 22:32:52','913','2023-01-01 11:20:11',10,0),('1','248',454,'FULL DAY ','2023-01-01','2023-01-01 22:50:58','2023-01-02 22:50:58','807',20333269.25,20333269.25,'807','2023-01-01 23:09:53','913','2023-01-01 23:17:46',10,0),('1','248',455,'FULL DAY ','2023-01-02','2023-01-02 21:24:25','2023-01-03 21:24:25','807',17977808.95,17977808.95,'807','2023-01-02 21:42:35','913','2023-01-03 06:29:22',10,0),('1','248',456,'FULL DAY ','2023-01-03','2023-01-03 20:07:58','2023-01-04 20:07:58','807',3090735.50,3090735.50,'807','2023-01-03 20:47:44','913','2023-01-03 21:00:55',10,0),('1','248',457,'FULL DAY ','2023-01-04','2023-01-04 19:50:43','2023-01-05 19:50:43','807',21007533.40,21007533.40,'807','2023-01-04 20:30:49','913','2023-01-04 21:02:04',10,0),('1','248',458,'FULL DAY ','2023-01-05','2023-01-05 16:54:04','2023-01-06 16:54:04','807',11178612.05,11178612.05,'807','2023-01-05 17:07:42','913','2023-01-05 19:29:34',10,0),('1','248',459,'FULL DAY ','2023-01-06','2023-01-06 18:10:33','2023-01-07 18:10:33','807',9874792.50,9874792.50,'807','2023-01-06 18:22:17','913','2023-01-06 18:27:58',10,0),('1','248',460,'FULL DAY ','2023-01-07','2023-01-07 20:52:00','2023-01-08 20:52:00','807',12065068.75,12065068.75,'807','2023-01-07 21:08:25','913','2023-01-07 21:11:51',10,0),('1','248',461,'FULL DAY ','2023-01-08','2023-01-08 20:33:23','2023-01-09 20:33:23','807',14919580.85,14919580.85,'807','2023-01-08 21:48:52','913','2023-01-09 08:25:43',10,0),('1','248',462,'FULL DAY ','2023-01-09','2023-01-09 20:38:14','2023-01-10 20:38:14','807',13083240.10,13083240.10,'807','2023-01-09 20:54:10','913','2023-01-09 21:51:04',10,0),('1','248',463,'FULL DAY ','2023-01-10','2023-01-10 20:30:34','2023-01-11 20:30:34','807',12647360.55,12647360.55,'807','2023-01-10 21:09:14','913','2023-01-10 21:58:40',10,0),('1','248',464,'FULL DAY ','2023-01-11','2023-01-11 20:09:39','2023-01-12 20:09:39','807',11969186.75,11969186.75,'807','2023-01-11 20:23:38','913','2023-01-11 22:11:04',10,0),('1','248',465,'FULL DAY ','2023-01-12','2023-01-12 19:37:29','2023-01-13 19:37:29','807',16179925.50,16179925.50,'807','2023-01-12 21:14:38','913','2023-01-12 23:35:23',10,0),('1','248',466,'FULL DAY ','2023-01-13','2023-01-14 08:56:00','2023-01-15 08:56:00','807',16773640.00,16773640.00,'807','2023-01-14 09:07:36','913','2023-01-14 10:28:13',10,0),('1','248',467,'FULL DAY ','2023-01-14','2023-01-14 19:17:12','2023-01-15 19:17:12','807',15292507.15,15292507.15,'807','2023-01-14 20:45:48','913','2023-01-14 20:46:57',10,0),('1','248',468,'FULL DAY ','2023-01-15','2023-01-16 12:13:45','2023-01-17 12:13:45','807',13199098.60,13199098.60,'807','2023-01-16 13:26:19','913','2023-01-16 13:27:19',10,0),('1','248',469,'FULL DAY ','2023-01-16','2023-01-16 20:28:16','2023-01-17 20:28:16','807',469374.40,469374.40,'807','2023-01-16 20:29:25','913','2023-01-16 21:35:22',10,0),('1','248',470,'FULL DAY ','2023-01-17','2023-01-18 07:38:05','2023-01-19 07:38:05','807',1729314.40,1729314.40,'807','2023-01-18 07:40:17','913','2023-01-18 10:28:32',10,0),('1','248',471,'FULL DAY ','2023-01-18','2023-01-18 22:07:52','2023-01-19 22:07:52','807',0.00,0.00,'807','2023-01-18 22:46:08','913','2023-01-18 22:48:11',10,0),('1','248',472,'FULL DAY ','2023-01-18','2023-01-18 22:52:11','2023-01-19 22:52:11','807',1785988.20,1785988.20,'807','2023-01-18 22:53:02','913','2023-01-18 22:54:36',10,0),('1','248',473,'AGO CHANGE OF PRICE ','2023-01-19','2023-01-19 21:00:09','2023-01-20 21:00:09','807',621058.20,621058.20,'807','2023-01-19 21:01:04','913','2023-01-19 21:02:11',10,0),('1','248',474,'FULL DAY ','2023-01-19','2023-01-19 21:04:03','2023-01-20 21:04:03','807',1960788.60,1960788.60,'807','2023-01-19 21:05:51','913','2023-01-19 21:06:52',10,0),('1','248',475,'FULL DAY ','2023-01-20','2023-01-20 22:18:49','2023-01-21 22:18:49','807',1307218.50,1307218.50,'807','2023-01-20 22:21:06','913','2023-01-20 22:36:15',10,0),('1','248',476,'FULL DAY ','2023-01-21','2023-01-21 20:53:03','2023-01-22 20:53:03','807',4593843.60,4593843.60,'807','2023-01-21 21:09:18','913','2023-01-21 21:52:33',10,0),('1','248',477,'FULL DAY ','2023-01-22','2023-01-22 20:39:03','2023-01-23 20:39:03','807',2212392.60,2212392.60,'807','2023-01-22 20:49:36','913','2023-01-22 21:14:03',10,0),('1','248',478,'FULL DAY ','2023-01-23','2023-01-23 20:25:08','2023-01-24 20:25:08','807',4084362.90,4084362.90,'807','2023-01-23 20:32:50','913','2023-01-23 22:47:48',10,0),('1','248',479,'FULL DAY ','2023-01-24','2023-01-24 22:05:05','2023-01-25 22:05:05','807',1699197.00,1699197.00,'807','2023-01-24 22:10:30','913','2023-01-24 22:15:35',10,0),('1','248',480,'FULL DAY ','2023-01-25','2023-01-25 22:10:48','2023-01-26 22:10:48','807',2465214.60,2465214.60,'807','2023-01-25 22:18:55','913','2023-01-25 22:21:46',10,0),('1','248',481,'FULL DAY','2023-01-26','2023-01-26 19:51:05','2023-01-27 19:51:05','807',2052956.40,2052956.40,'807','2023-01-26 20:28:06','913','2023-01-26 22:19:13',10,0),('1','248',482,'FULL DAY ','2023-01-27','2023-01-27 21:06:11','2023-01-28 21:06:11','807',3318127.80,3318127.80,'807','2023-01-27 21:11:25','913','2023-01-27 21:55:58',10,0),('1','248',483,'FULL DAY','2023-01-28','2023-01-28 19:23:50','2023-01-29 19:23:50','807',2155738.20,2155738.20,'807','2023-01-28 20:30:59','913','2023-01-28 23:39:08',10,0),('1','248',484,'FULL DAY ','2023-01-29','2023-01-29 19:41:55','2023-01-30 19:41:55','807',1444904.70,1444904.70,'807','2023-01-29 20:00:19','913','2023-01-29 20:07:13',10,0),('1','248',485,'FULL DAY','2023-01-31','2023-01-31 21:35:38','2023-02-01 21:35:38','807',2478395.10,2478395.10,'807','2023-01-31 21:41:51','913','2023-02-01 01:33:58',10,0),('1','248',486,'FULL DAY','2023-02-01','2023-02-01 21:46:10','2023-02-02 21:46:10','807',714435.30,714435.30,'807','2023-02-01 22:02:56','913','2023-02-01 22:09:42',10,0),('1','248',487,'AGO CHANGE OF PRICE','2023-02-01','2023-02-01 22:24:32','2023-02-02 22:24:32','807',664912.50,664912.50,'807','2023-02-01 22:25:26','913','2023-02-02 00:44:47',10,0),('1','248',488,'FULL DAY','2023-02-02','2023-02-02 22:22:32','2023-02-03 22:22:32','807',1774392.00,1774392.00,'807','2023-02-02 22:45:32','913','2023-02-03 08:24:28',10,0),('1','248',489,'FULL DAY','2023-02-03','2023-02-03 21:14:15','2023-02-04 21:14:15','807',4208282.00,4208282.00,'807','2023-02-03 22:25:22','913','2023-02-03 22:54:01',10,0),('1','248',490,'FULL DAY ','2023-02-04','2023-02-04 18:25:57','2023-02-05 18:25:57','807',3183896.00,3183896.00,'807','2023-02-04 18:39:47','913','2023-02-04 20:10:55',10,0),('1','248',491,'FULL DAY','2023-02-06','2023-02-06 20:08:07','2023-02-07 20:08:07','807',1633326.00,1633326.00,'807','2023-02-06 22:13:36','913','2023-02-06 22:15:30',10,0),('1','248',492,'FULL DAY ','2023-02-07','2023-02-08 19:06:50','2023-02-09 19:06:50','807',2669807.50,2669807.50,'807','2023-02-08 19:07:45','913','2023-02-08 22:20:07',10,0),('1','248',493,'FULL DAY','2023-02-08','2023-02-08 22:36:00','2023-02-09 22:36:00','807',2865452.00,2865452.00,'807','2023-02-08 22:39:41','913','2023-02-09 08:18:19',10,0),('1','248',494,'FULL DAY','2023-02-09','2023-02-09 20:07:01','2023-02-10 20:07:01','807',2640431.50,2640431.50,'807','2023-02-09 20:50:48','913','2023-02-10 00:27:34',10,0),('1','248',495,'FULL DAY ','2023-02-10','2023-02-11 09:52:45','2023-02-12 09:52:45','807',2080519.50,2080519.50,'807','2023-02-11 09:54:33','913','2023-02-11 09:57:43',10,0),('1','248',496,'FULL DAY ','2023-02-11','2023-02-12 07:49:02','2023-02-13 07:49:02','807',1047361.50,1047361.50,'807','2023-02-12 14:33:49','913','2023-02-12 15:22:13',10,0),('1','248',497,'FULL DAY ','2023-02-13','2023-02-14 08:48:22','2023-02-15 08:48:22','807',2895567.50,2895567.50,'807','2023-02-14 08:49:39','913','2023-02-14 09:43:47',10,0),('1','248',498,'FULL DAY ','2023-02-14','2023-02-15 08:15:33','2023-02-16 08:15:33','807',2438191.00,2438191.00,'807','2023-02-15 08:16:49','913','2023-02-15 12:50:35',10,0),('1','248',499,'FULL DAY ','2023-02-15','2023-02-16 07:50:11','2023-02-17 07:50:11','807',1525920.00,1525920.00,'807','2023-02-16 07:51:02','913','2023-02-16 11:03:13',10,0),('1','248',500,'FULL DAY ','2023-02-16','2023-02-17 08:00:25','2023-02-18 08:00:25','807',2184015.50,2184015.50,'807','2023-02-17 08:02:13','913','2023-02-17 11:40:14',10,0),('1','248',501,'FULL DAY ','2023-02-17','2023-02-18 08:10:32','2023-02-19 08:10:32','807',2593843.00,2593843.00,'807','2023-02-18 08:12:28','913','2023-02-18 12:48:33',10,0),('1','248',502,'FULL DAYS','2023-02-18','2023-02-19 09:47:26','2023-02-20 09:47:26','807',2243252.00,2243252.00,'807','2023-02-19 09:49:05','913','2023-02-19 12:53:32',10,0),('1','248',503,'FULL DAYS','2023-02-19','2023-02-20 08:12:20','2023-02-21 08:12:20','807',725143.50,725143.50,'807','2023-02-20 08:13:39','913','2023-02-20 11:02:01',10,0),('1','248',504,'FULL DAY ','2023-02-20','2023-02-21 09:18:29','2023-02-22 09:18:29','807',2841983.50,2841983.50,'807','2023-02-21 09:33:24','913','2023-02-21 10:23:30',10,0),('1','248',505,'FULL DAY ','2023-02-21','2023-02-22 08:10:46','2023-02-23 08:10:46','807',3154392.50,3154392.50,'807','2023-02-22 08:12:09','913','2023-02-22 09:57:17',10,0),('1','248',506,'FULL DAYS','2023-02-22','2023-02-23 08:28:31','2023-02-24 08:28:31','807',247656.00,247656.00,'807','2023-02-23 09:29:21','913','2023-02-23 09:48:06',10,0),('1','248',507,'FULL DAY ','2023-02-23','2023-02-24 08:27:13','2023-02-25 08:27:13','807',502044.00,502044.00,'807','2023-02-24 08:28:08','913','2023-02-24 11:46:07',10,0),('1','248',508,'FULL DAY ','2023-02-26','2023-02-27 09:37:59','2023-02-28 09:37:59','807',936663.30,936663.30,'807','2023-02-27 09:39:46','913','2023-02-27 12:49:31',10,0),('1','248',509,'FULL DAY ','2023-02-27','2023-02-28 08:12:15','2023-03-01 08:12:15','807',39698.90,39698.90,'807','2023-02-28 08:13:19','913','2023-02-28 08:41:44',10,0),('1','248',510,'FULL DAYS','2023-02-28','2023-03-01 07:35:14','2023-03-02 07:35:14','807',2469233.40,2469233.40,'807','2023-03-01 07:37:05','913','2023-03-01 08:57:04',10,0),('1','248',511,'FULL DAY ','2023-03-01','2023-03-02 08:22:13','2023-03-03 08:22:13','807',1670599.10,1670599.10,'807','2023-03-02 08:23:58','913','2023-03-02 10:14:22',10,0),('1','248',512,'FULL DAY ','2023-03-02','2023-03-03 08:03:50','2023-03-04 08:03:50','807',984562.60,984562.60,'807','2023-03-03 08:05:57','913','2023-03-03 15:05:54',10,0),('1','248',513,'FULL DAY ','2023-03-03','2023-03-04 08:11:40','2023-03-05 08:11:40','807',2246644.00,2246644.00,'807','2023-03-04 08:13:47','913','2023-03-04 13:02:37',10,0),('1','248',514,'FULL DAY','2023-03-04','2023-03-05 09:13:30','2023-03-06 09:13:30','807',2717461.50,2717461.50,'807','2023-03-05 09:15:03','913','2023-03-05 11:29:43',10,0),('1','248',515,'FULL DAY','2023-03-05','2023-03-06 08:26:38','2023-03-07 08:26:38','807',3890608.40,3890608.40,'807','2023-03-06 08:28:05','913','2023-03-06 12:36:19',10,0),('1','248',516,'FULL DAY ','2023-03-06','2023-03-07 08:15:47','2023-03-08 08:15:47','807',2314571.20,2314571.20,'807','2023-03-07 08:17:08','913','2023-03-07 12:19:21',10,0),('1','248',517,'FULL DAY','2023-03-07','2023-03-08 08:05:39','2023-03-09 08:05:39','807',1684949.80,1684949.80,'807','2023-03-08 08:07:02','913','2023-03-08 13:31:54',10,0),('1','248',518,'FULL DAY','2023-03-08','2023-03-09 08:44:13','2023-03-10 08:44:13','807',1543393.30,1543393.30,'807','2023-03-09 08:46:26','913','2023-03-09 13:10:02',10,0),('1','248',519,'FULL DAY','2023-03-09','2023-03-10 07:47:56','2023-03-11 07:47:56','807',2544456.30,2544456.30,'807','2023-03-10 07:49:16','913','2023-03-10 09:49:53',10,0),('1','248',520,'FULL DAY','2023-03-10','2023-03-11 08:12:05','2023-03-12 08:12:05','807',2297157.80,2297157.80,'807','2023-03-11 08:14:51','913','2023-03-11 09:05:22',10,0),('1','248',521,'FULL DAY','2023-03-11','2023-03-12 08:53:29','2023-03-13 08:53:29','807',4507024.50,4507024.50,'807','2023-03-12 08:54:57','913','2023-03-12 09:09:23',10,0),('1','248',522,'FULL DAY','2023-03-12','2023-03-13 07:47:51','2023-03-14 07:47:51','807',3162582.20,3162582.20,'807','2023-03-13 07:52:58','913','2023-03-13 12:22:47',10,0),('1','248',523,'FULL DAY','2023-03-13','2023-03-14 07:47:18','2023-03-15 07:47:18','807',2368332.20,2368332.20,'807','2023-03-14 07:48:44','913','2023-03-14 10:53:38',10,0),('1','248',524,'FULL DAY','2023-03-14','2023-03-15 07:54:14','2023-03-16 07:54:14','807',5154675.80,5154675.80,'807','2023-03-15 07:55:27','913','2023-03-15 09:28:25',10,0),('1','248',525,'FULL DAY','2023-03-15','2023-03-16 07:56:01','2023-03-17 07:56:01','807',4266304.20,4266304.20,'807','2023-03-16 07:57:04','913','2023-03-16 09:04:55',10,0),('1','248',526,'FULL DAY','2023-03-16','2023-03-17 07:48:56','2023-03-18 07:48:56','807',2291416.20,2291416.20,'807','2023-03-17 07:50:11','913','2023-03-17 08:41:40',10,0),('1','248',527,'FULL DAY','2023-03-17','2023-03-18 08:24:43','2023-03-19 08:24:43','807',2880364.80,2880364.80,'807','2023-03-18 08:27:26','913','2023-03-18 11:20:22',10,0),('1','248',528,'FULL DAY','2023-03-18','2023-03-19 08:01:40','2023-03-20 08:01:40','807',2507633.80,2507633.80,'807','2023-03-19 08:09:20','913','2023-03-19 09:10:58',10,0),('1','248',529,'FULL DAY','2023-03-19','2023-03-20 08:12:15','2023-03-21 08:12:15','807',1172321.20,1172321.20,'807','2023-03-20 08:14:46','913','2023-03-20 09:27:42',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=12697 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','248','1','1',1,'1','1',695.29,4609.59,3914.30,645859.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','1',2,'2','1',589.84,589.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','1',3,'3','1',564.28,4291.86,3727.58,615050.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','1',4,'4','1',503.11,503.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','1',5,'5','1',715.35,3743.11,3027.76,499580.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','1',6,'6','1',567.21,567.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','1',7,'7','1',602.50,5242.66,4640.16,765626.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','1',8,'8','1',663.78,663.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','1',9,'9','1',604.20,4280.48,3676.28,606586.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','1',10,'10','1',522.25,522.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','1',11,'11','1',551.91,4398.48,3846.57,634684.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','1',12,'12','1',624.81,624.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','1',13,'13','1',555.24,555.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','1',14,'14','1',463.20,463.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','1',15,'15','1',612.27,898.59,286.32,47242.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','1',16,'16','1',561.51,612.27,50.76,8375.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','1',17,'17','1',480.82,480.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','1',18,'18','1',628.86,628.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','1',19,'19','1',699.49,699.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','1',20,'20','1',591.02,591.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','1',21,'21','2',656.24,1309.20,652.96,440748.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','1',22,'22','2',588.29,952.36,364.07,245747.25,0.00,0.00,0.00,0.00,0.00),('1','248','5','1',23,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','1',24,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','2',25,'1','1',4609.59,8764.50,4154.91,685560.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','2',26,'2','1',589.84,4539.41,3949.57,651679.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','2',27,'3','1',4291.86,7932.81,3640.95,600756.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','2',28,'4','1',503.11,4161.80,3658.69,603683.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','2',29,'5','1',3743.11,7912.63,4169.52,687970.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','2',30,'6','1',567.21,567.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','2',31,'7','1',5242.66,9245.92,4003.26,660537.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','2',32,'8','1',663.78,4617.18,3953.40,652311.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','2',33,'9','1',4280.48,8472.09,4191.61,691615.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','2',34,'10','1',522.25,3718.73,3196.48,527419.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','2',35,'11','1',4398.48,7875.83,3477.35,573762.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','2',36,'12','1',624.81,3214.14,2589.33,427239.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','2',37,'13','1',555.24,3151.30,2596.06,428349.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','2',38,'14','1',463.20,2745.75,2282.55,376620.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','2',39,'15','1',898.59,3050.74,2152.15,355104.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','2',40,'16','1',612.27,3134.07,2521.80,416097.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','2',41,'17','1',480.82,480.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','2',42,'18','1',628.86,2623.09,1994.23,329047.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','2',43,'19','1',699.49,2675.90,1976.41,326107.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','2',44,'20','1',591.02,3032.93,2441.91,402915.15,0.00,0.00,0.00,0.00,0.00),('1','248','4','2',45,'21','2',1309.20,2743.26,1434.06,967990.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','2',46,'22','2',952.36,2168.42,1216.06,820840.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','2',47,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','2',48,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','3',49,'1','1',8764.50,16486.07,7701.01,1270666.65,0.00,0.00,20.56,0.00,0.00),('1','248','1','3',50,'2','1',4539.41,11841.54,7302.13,1204851.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','3',51,'3','1',7932.81,13729.41,5796.60,956439.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','3',52,'4','1',4161.80,10949.41,6767.15,1116579.75,0.00,0.00,20.46,0.00,0.00),('1','248','1','3',53,'5','1',7912.63,15982.46,8069.83,1331521.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','3',54,'6','1',567.21,567.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','3',55,'7','1',9245.92,14193.57,4927.25,812996.25,0.00,0.00,20.40,0.00,0.00),('1','248','2','3',56,'8','1',4617.18,9043.29,4426.11,730308.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','3',57,'9','1',8472.09,12543.77,4071.68,671827.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','3',58,'10','1',3718.73,10421.89,6703.16,1106021.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','3',59,'11','1',7875.83,13000.87,5125.04,845631.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','3',60,'12','1',3214.14,8374.92,5135.38,847337.70,0.00,0.00,25.40,0.00,0.00),('1','248','3','3',61,'13','1',3151.30,6684.30,3533.00,582945.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','3',62,'14','1',2745.75,6443.30,3697.55,610095.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','3',63,'15','1',3050.74,7224.78,4174.04,688716.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','3',64,'16','1',3134.07,7256.25,4122.18,680159.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','3',65,'17','1',480.82,2178.45,1697.63,280108.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','3',66,'18','1',2623.09,6472.79,3849.70,635200.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','3',67,'19','1',2675.90,5761.72,3085.82,509160.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','3',68,'20','1',3032.93,6511.22,3478.29,573917.85,0.00,0.00,0.00,0.00,0.00),('1','248','4','3',69,'21','2',2743.26,5626.54,2863.03,1932545.25,0.00,0.00,20.25,0.00,0.00),('1','248','4','3',70,'22','2',2168.42,4216.80,2048.38,1382656.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','3',71,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','3',72,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','4',73,'1','1',16486.07,22931.68,6445.61,1063525.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','4',74,'2','1',11841.54,16337.51,4495.97,741835.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','4',75,'3','1',13729.41,18499.64,4770.23,787087.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','4',76,'4','1',10949.41,15452.06,4502.65,742937.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','4',77,'5','1',15982.46,22603.23,6620.77,1092427.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','4',78,'6','1',567.21,569.13,1.92,316.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','4',79,'7','1',14193.57,19193.71,5000.14,825023.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','4',80,'8','1',9043.29,14235.97,5192.68,856792.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','4',81,'9','1',12543.77,17779.58,5235.81,863908.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','4',82,'10','1',10421.89,14938.19,4516.30,745189.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','4',83,'11','1',13000.87,18335.88,5335.01,880276.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','4',84,'12','1',8374.92,12554.84,4179.92,689686.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','4',85,'13','1',6684.30,10181.05,3496.75,576963.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','4',86,'14','1',6443.30,9957.03,3513.73,579765.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','4',87,'15','1',7224.78,11197.01,3972.23,655417.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','4',88,'16','1',7256.25,10464.34,3208.09,529334.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','4',89,'17','1',2178.45,2198.45,20.00,3300.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','4',90,'18','1',6472.79,10704.33,4231.54,698204.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','4',91,'19','1',5761.72,9701.07,3939.35,649992.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','4',92,'20','1',6511.22,10686.24,4175.02,688878.30,0.00,0.00,0.00,0.00,0.00),('1','248','4','4',93,'21','2',5626.54,8668.94,3042.40,2053620.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','4',94,'22','2',4216.80,4723.52,486.72,328536.00,0.00,0.00,20.00,0.00,0.00),('1','248','5','4',95,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','4',96,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','5',97,'1','1',22931.68,29364.11,6432.43,1061350.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','5',98,'2','1',16337.51,20927.94,4590.43,757420.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','5',99,'3','1',18499.64,22624.91,4125.27,680669.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','5',100,'4','1',15452.06,19636.63,4184.57,690454.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','5',101,'5','1',22603.23,28348.60,5735.37,946336.05,0.00,0.00,10.00,0.00,0.00),('1','248','1','5',102,'6','1',569.13,569.13,-1.92,-316.80,0.00,0.00,1.92,0.00,0.00),('1','248','2','5',103,'7','1',19193.71,24514.78,5321.07,877976.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','5',104,'8','1',14235.97,20609.17,6373.20,1051578.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','5',105,'9','1',17779.58,21933.55,4153.97,685405.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','5',106,'10','1',14938.19,20969.88,6031.69,995228.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','5',107,'11','1',18335.88,23282.64,4936.76,814565.40,0.00,0.00,10.00,0.00,0.00),('1','248','2','5',108,'12','1',12554.84,15866.63,3311.79,546445.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','5',109,'13','1',10181.05,11542.94,1361.89,224711.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','5',110,'14','1',9957.03,12001.11,2044.08,337273.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','5',111,'15','1',11197.01,13011.86,1814.85,299450.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','5',112,'16','1',10464.34,12363.84,1867.06,308064.90,0.00,0.00,32.44,0.00,0.00),('1','248','3','5',113,'17','1',2198.45,3866.30,1647.85,271895.25,0.00,0.00,20.00,0.00,0.00),('1','248','3','5',114,'18','1',10704.33,12426.19,1721.86,284106.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','5',115,'19','1',9701.07,11429.23,1667.56,275147.40,0.00,0.00,60.60,0.00,0.00),('1','248','3','5',116,'20','1',10686.24,12221.40,1535.16,253301.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','5',117,'21','2',8668.94,9613.24,908.52,613251.00,0.00,0.00,35.78,0.00,0.00),('1','248','4','5',118,'22','2',4723.52,7806.52,3083.00,2081025.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','5',119,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','5',120,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','6',121,'1','1',29364.11,36588.62,7214.51,1190394.15,0.00,0.00,10.00,0.00,0.00),('1','248','1','6',122,'2','1',20927.94,25949.08,5011.14,826838.10,0.00,0.00,10.00,0.00,0.00),('1','248','1','6',123,'3','1',22624.91,25398.46,2773.55,457635.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','6',124,'4','1',19636.63,24812.80,5176.17,854068.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','6',125,'5','1',28348.60,36484.89,8106.29,1337537.85,0.00,0.00,30.00,0.00,0.00),('1','248','1','6',126,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','6',127,'7','1',24514.78,32410.61,7885.83,1301161.95,0.00,0.00,10.00,0.00,0.00),('1','248','2','6',128,'8','1',20609.17,23791.79,3172.62,523482.30,0.00,0.00,10.00,0.00,0.00),('1','248','2','6',129,'9','1',21933.55,26066.28,4132.73,681900.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','6',130,'10','1',20969.88,27114.85,6144.97,1013920.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','6',131,'11','1',23282.64,26364.98,3082.34,508586.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','6',132,'12','1',15866.63,22263.22,6396.59,1055437.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','6',133,'13','1',11542.94,11542.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','6',134,'14','1',12001.11,12001.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','6',135,'15','1',13011.86,13011.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','6',136,'16','1',12363.84,12363.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','6',137,'17','1',3866.30,3866.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','6',138,'18','1',12426.19,12426.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','6',139,'19','1',11429.23,11429.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','6',140,'20','1',12221.40,12221.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','6',141,'21','2',9613.24,9615.24,2.00,1350.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','6',142,'22','2',7806.52,12499.77,4693.25,3167943.75,0.00,0.00,0.00,0.00,0.00),('1','248','5','6',143,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','6',144,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','7',145,'1','1',36588.62,42107.39,5518.77,910597.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','7',146,'2','1',25949.08,30555.89,4606.81,760123.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','7',147,'3','1',25398.46,30788.04,5389.58,889280.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','7',148,'4','1',24812.80,29361.88,4502.42,742899.30,0.00,0.00,46.66,0.00,0.00),('1','248','1','7',149,'5','1',36484.89,41357.37,4852.48,800659.20,0.00,0.00,20.00,0.00,0.00),('1','248','1','7',150,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','7',151,'7','1',32410.61,32410.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','7',152,'8','1',23791.79,30296.26,6504.47,1073237.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','7',153,'9','1',26066.28,32371.46,6305.18,1040354.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','7',154,'10','1',27114.85,32214.98,5100.13,841521.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','7',155,'11','1',26364.98,26364.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','7',156,'12','1',22263.22,28482.91,6219.69,1026248.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','7',157,'13','1',11542.94,14802.37,3259.43,537805.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','7',158,'14','1',12001.11,15693.48,3692.37,609241.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','7',159,'15','1',13011.86,16147.34,3132.48,516859.20,0.00,0.00,3.00,0.00,0.00),('1','248','3','7',160,'16','1',12363.84,16545.59,4176.75,689163.75,0.00,0.00,5.00,0.00,0.00),('1','248','3','7',161,'17','1',3866.30,3866.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','7',162,'18','1',12426.19,16816.99,4340.80,716232.00,0.00,0.00,50.00,0.00,0.00),('1','248','3','7',163,'19','1',11429.23,11631.23,202.00,33330.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','7',164,'20','1',12221.40,16662.51,4441.11,732783.15,0.00,0.00,0.00,0.00,0.00),('1','248','4','7',165,'21','2',9615.24,9615.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','7',166,'22','2',12499.77,16759.75,4259.98,2875486.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','7',167,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','7',168,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','8',169,'1','1',42107.39,47376.01,5268.62,869322.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','8',170,'2','1',30555.89,32398.16,1842.27,303974.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','8',171,'3','1',30788.04,35779.95,4991.91,823665.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','8',172,'4','1',29361.88,29361.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','8',173,'5','1',41357.37,46438.53,5081.16,838391.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','8',174,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','8',175,'7','1',32410.61,32410.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','8',176,'8','1',30296.26,36003.56,5707.30,941704.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','8',177,'9','1',32371.46,37214.94,4843.48,799174.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','8',178,'10','1',32214.98,33357.95,1142.97,188590.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','8',179,'11','1',26364.98,31146.76,4781.78,788993.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','8',180,'12','1',28482.91,29108.76,625.85,103265.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','8',181,'13','1',14802.37,15366.44,546.07,90101.55,0.00,0.00,18.00,0.00,0.00),('1','248','3','8',182,'14','1',15693.48,16329.04,631.56,104207.40,0.00,0.00,4.00,0.00,0.00),('1','248','3','8',183,'15','1',16147.34,16147.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','8',184,'16','1',16545.59,19568.43,3017.84,497943.60,0.00,0.00,5.00,0.00,0.00),('1','248','3','8',185,'17','1',3866.30,3870.86,-0.44,-72.60,0.00,0.00,5.00,0.00,0.00),('1','248','3','8',186,'18','1',16816.99,20490.29,3667.30,605104.50,0.00,0.00,6.00,0.00,0.00),('1','248','3','8',187,'19','1',11631.23,11635.54,0.31,51.15,0.00,0.00,4.00,0.00,0.00),('1','248','3','8',188,'20','1',16662.51,19381.00,2713.49,447725.85,0.00,0.00,5.00,0.00,0.00),('1','248','4','8',189,'21','2',9615.24,9615.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','8',190,'22','2',16759.75,18911.85,2152.10,1452667.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','8',191,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','8',192,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','9',193,'1','1',47376.01,51934.18,4558.17,752098.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','9',194,'2','1',32398.16,33918.18,1520.02,250803.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','9',195,'3','1',35779.95,40504.04,4724.09,779474.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','9',196,'4','1',29361.88,29361.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','9',197,'5','1',46438.53,50469.03,4030.50,665032.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','9',198,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','9',199,'7','1',32410.61,32410.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','9',200,'8','1',36003.56,39585.58,3522.02,581133.30,0.00,0.00,60.00,0.00,0.00),('1','248','2','9',201,'9','1',37214.94,40310.77,3095.83,510811.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','9',202,'10','1',33357.95,36227.90,2869.95,473541.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','9',203,'11','1',31146.76,31146.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','9',204,'12','1',29108.76,32610.68,3501.92,577816.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','9',205,'13','1',15366.44,15366.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','9',206,'14','1',16329.04,19799.36,3470.32,572602.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','9',207,'15','1',16147.34,18897.72,2735.38,451337.70,0.00,0.00,15.00,0.00,0.00),('1','248','3','9',208,'16','1',19568.43,19568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','9',209,'17','1',3870.86,3870.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','9',210,'18','1',20490.29,20490.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','9',211,'19','1',11635.54,11635.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','9',212,'20','1',19381.00,19381.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','9',213,'21','2',9615.24,11917.76,2236.52,1509651.00,0.00,0.00,66.00,0.00,0.00),('1','248','4','9',214,'22','2',18911.85,19329.95,418.10,282217.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','9',215,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','9',216,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','10',217,'1','1',51934.18,55825.94,3891.76,642140.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','10',218,'2','1',33918.18,37918.92,4000.74,660122.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','10',219,'3','1',40504.04,43598.14,3094.10,510526.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','10',220,'4','1',29361.88,33282.10,3920.22,646836.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','10',221,'5','1',50469.03,56710.86,6241.83,1029901.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','10',222,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','10',223,'7','1',32410.61,36118.12,3707.51,611739.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','10',224,'8','1',39585.58,43130.12,3544.54,584849.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','10',225,'9','1',40310.77,43834.63,3523.86,581436.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','10',226,'10','1',36227.90,40012.80,3784.90,624508.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','10',227,'11','1',31146.76,35657.97,4511.21,744349.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','10',228,'12','1',32610.68,36780.36,4169.68,687997.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','10',229,'13','1',15366.44,15366.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','10',230,'14','1',19799.36,19799.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','10',231,'15','1',18897.72,18897.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','10',232,'16','1',19568.43,19568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','10',233,'17','1',3870.86,3870.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','10',234,'18','1',20490.29,20490.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','10',235,'19','1',11635.54,11635.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','10',236,'20','1',19381.00,19409.64,28.64,4725.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','10',237,'21','2',11917.76,15842.65,3924.89,2649300.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','10',238,'22','2',19329.95,19329.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','10',239,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','10',240,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','11',241,'1','1',55825.94,59050.51,3224.57,532054.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','11',242,'2','1',37918.92,41179.72,3260.80,538032.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','11',243,'3','1',43598.14,46970.28,3372.14,556403.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','11',244,'4','1',33282.10,33282.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','11',245,'5','1',56710.86,60441.91,3731.05,615623.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','11',246,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','11',247,'7','1',36118.12,38991.67,2873.55,474135.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','11',248,'8','1',43130.12,46333.62,3203.50,528577.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','11',249,'9','1',43834.63,43834.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','11',250,'10','1',40012.80,43129.89,3117.09,514319.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','11',251,'11','1',35657.97,38918.62,3260.65,538007.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','11',252,'12','1',36780.36,36780.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','11',253,'13','1',15366.44,15366.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','11',254,'14','1',19799.36,19799.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','11',255,'15','1',18897.72,18897.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','11',256,'16','1',19568.43,19568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','11',257,'17','1',3870.86,3870.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','11',258,'18','1',20490.29,20490.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','11',259,'19','1',11635.54,11635.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','11',260,'20','1',19409.64,19409.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','11',261,'21','2',15842.65,18639.04,2796.39,1887563.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','11',262,'22','2',19329.95,19329.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','11',263,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','11',264,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','12',265,'1','1',59050.51,61940.35,2889.84,476823.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','12',266,'2','1',41179.72,43239.15,2059.43,339805.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','12',267,'3','1',46970.28,49025.56,2055.28,339121.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','12',268,'4','1',33282.10,35595.84,2313.74,381767.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','12',269,'5','1',60441.91,61601.56,1159.65,191342.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','12',270,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','12',271,'7','1',38991.67,38991.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','12',272,'8','1',46333.62,46333.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','12',273,'9','1',43834.63,46843.73,3009.10,496501.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','12',274,'10','1',43129.89,43129.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','12',275,'11','1',38918.62,41438.84,2520.22,415836.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','12',276,'12','1',36780.36,36780.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','12',277,'13','1',15366.44,15366.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','12',278,'14','1',19799.36,25260.49,5461.13,901086.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','12',279,'15','1',18897.72,24584.15,5686.43,938260.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','12',280,'16','1',19568.43,19568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','12',281,'17','1',3870.86,6287.07,2396.21,395374.65,0.00,0.00,20.00,0.00,0.00),('1','248','3','12',282,'18','1',20490.29,25922.43,5432.14,896303.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','12',283,'19','1',11635.54,11635.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','12',284,'20','1',19409.64,25577.21,6167.57,1017649.05,0.00,0.00,0.00,0.00,0.00),('1','248','4','12',285,'21','2',18639.04,21832.61,3193.57,2155659.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','12',286,'22','2',19329.95,19329.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','12',287,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','12',288,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','13',289,'1','1',61940.35,66585.16,4644.81,766393.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','13',290,'2','1',43239.15,45910.50,2671.35,440772.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','13',291,'3','1',49025.56,52830.41,3804.85,627800.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','13',292,'4','1',35595.84,39708.67,4112.83,678616.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','13',293,'5','1',61601.56,66381.33,4779.77,788662.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','13',294,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','13',295,'7','1',38991.67,38991.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','13',296,'8','1',46333.62,50542.82,4209.20,694518.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','13',297,'9','1',46843.73,46843.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','13',298,'10','1',43129.89,43129.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','13',299,'11','1',41438.84,41438.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','13',300,'12','1',36780.36,36780.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','13',301,'13','1',15366.44,19150.92,3784.48,624439.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','13',302,'14','1',25260.49,25260.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','13',303,'15','1',24584.15,28079.18,3495.03,576679.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','13',304,'16','1',19568.43,22935.05,3366.62,555492.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','13',305,'17','1',6287.07,9796.42,3509.35,579042.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','13',306,'18','1',25922.43,25922.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','13',307,'19','1',11635.54,15166.21,3530.67,582560.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','13',308,'20','1',25577.21,25577.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','13',309,'21','2',21832.61,25248.00,3415.39,2305388.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','13',310,'22','2',19329.95,19329.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','13',311,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','13',312,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','14',313,'1','1',66585.16,71914.18,5329.02,879288.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','14',314,'2','1',45910.50,46714.16,803.66,132603.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','14',315,'3','1',52830.41,52830.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','14',316,'4','1',39708.67,44454.88,4746.21,783124.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','14',317,'5','1',66381.33,72001.24,5619.91,927285.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','14',318,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','14',319,'7','1',38991.67,40599.43,1607.76,265280.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','14',320,'8','1',50542.82,50542.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','14',321,'9','1',46843.73,50771.12,3927.39,648019.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','14',322,'10','1',43129.89,45832.82,2702.93,445983.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','14',323,'11','1',41438.84,46281.26,4842.42,798999.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','14',324,'12','1',36780.36,37961.10,1180.74,194822.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','14',325,'13','1',19150.92,19150.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','14',326,'14','1',25260.49,25260.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','14',327,'15','1',28079.18,28079.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','14',328,'16','1',22935.05,25330.25,2395.20,395208.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','14',329,'17','1',9796.42,9796.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','14',330,'18','1',25922.43,28530.27,2607.84,430293.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','14',331,'19','1',15166.21,15166.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','14',332,'20','1',25577.21,27524.17,1946.96,321248.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','14',333,'21','2',25248.00,28534.04,3286.04,2218077.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','14',334,'22','2',19329.95,19329.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','14',335,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','14',336,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','15',337,'1','1',71914.18,77026.21,5112.03,843484.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','15',338,'2','1',46714.16,46714.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','15',339,'3','1',52830.41,54734.15,1903.74,314117.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','15',340,'4','1',44454.88,49032.22,4577.34,755261.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','15',341,'5','1',72001.24,76043.99,4042.75,667053.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','15',342,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','15',343,'7','1',40599.43,44702.51,4103.08,677008.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','15',344,'8','1',50542.82,55612.93,5070.11,836568.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','15',345,'9','1',50771.12,55149.83,4378.71,722487.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','15',346,'10','1',45832.82,49269.92,3437.10,567121.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','15',347,'11','1',46281.26,50833.03,4551.77,751042.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','15',348,'12','1',37961.10,37961.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','15',349,'13','1',19150.92,19150.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','15',350,'14','1',25260.49,25260.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','15',351,'15','1',28079.18,28079.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','15',352,'16','1',25330.25,25330.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','15',353,'17','1',9796.42,9796.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','15',354,'18','1',28530.27,28530.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','15',355,'19','1',15166.21,15166.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','15',356,'20','1',27524.17,27524.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','15',357,'21','2',28534.04,32880.96,4346.92,2934171.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','15',358,'22','2',19329.95,19329.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','15',359,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','15',360,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','16',361,'1','1',77026.21,77026.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','16',362,'2','1',46714.16,46714.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','16',363,'3','1',54734.15,54734.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','16',364,'4','1',49032.22,49032.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','16',365,'5','1',76043.99,76043.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','16',366,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','16',367,'7','1',44702.51,44702.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','16',368,'8','1',55612.93,55612.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','16',369,'9','1',55149.83,55149.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','16',370,'10','1',49269.92,49269.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','16',371,'11','1',50833.03,50833.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','16',372,'12','1',37961.10,37961.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','16',373,'13','1',19150.92,19150.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','16',374,'14','1',25260.49,25260.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','16',375,'15','1',28079.18,28079.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','16',376,'16','1',25330.25,25330.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','16',377,'17','1',9796.42,9796.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','16',378,'18','1',28530.27,28530.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','16',379,'19','1',15166.21,15166.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','16',380,'20','1',27524.17,27524.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','16',381,'21','2',32880.96,32880.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','16',382,'22','2',19329.95,19329.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','16',383,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','16',384,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','17',385,'1','1',77026.21,77026.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','17',386,'2','1',46714.16,48860.25,2146.09,354104.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','17',387,'3','1',54734.15,54734.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','17',388,'4','1',49032.22,51308.53,2276.31,375591.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','17',389,'5','1',76043.99,78310.35,2266.36,373949.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','17',390,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','17',391,'7','1',44702.51,48780.46,4077.95,672861.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','17',392,'8','1',55612.93,56477.15,864.22,142596.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','17',393,'9','1',55149.83,59562.08,4412.25,728021.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','17',394,'10','1',49269.92,49269.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','17',395,'11','1',50833.03,55150.23,4317.20,712338.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','17',396,'12','1',37961.10,40174.44,2213.34,365201.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','17',397,'13','1',19150.92,21351.44,2200.52,363085.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','17',398,'14','1',25260.49,29863.89,4603.40,759561.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','17',399,'15','1',28079.18,33619.01,5539.83,914071.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','17',400,'16','1',25330.25,25330.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','17',401,'17','1',9796.42,9796.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','17',402,'18','1',28530.27,33124.79,4594.52,758095.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','17',403,'19','1',15166.21,17416.72,2250.51,371334.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','17',404,'20','1',27524.17,31064.06,3539.89,584081.85,0.00,0.00,0.00,0.00,0.00),('1','248','4','17',405,'21','2',32880.96,35893.62,3012.66,2033545.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','17',406,'22','2',19329.95,19329.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','17',407,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','17',408,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','18',409,'1','1',77026.21,77026.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','18',410,'2','1',48860.25,48860.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','18',411,'3','1',54734.15,54734.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','18',412,'4','1',51308.53,51308.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','18',413,'5','1',78310.35,78310.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','18',414,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','18',415,'7','1',48780.46,48780.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','18',416,'8','1',56477.15,57621.91,1144.76,188885.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','18',417,'9','1',59562.08,60985.67,1423.59,234892.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','18',418,'10','1',49269.92,49269.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','18',419,'11','1',55150.23,56242.73,1092.50,180262.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','18',420,'12','1',40174.44,40174.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','18',421,'13','1',21351.44,22493.37,1141.93,188418.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','18',422,'14','1',29863.89,32848.52,2984.63,492463.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','18',423,'15','1',33619.01,35783.14,2164.13,357081.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','18',424,'16','1',25330.25,27575.36,2245.11,370443.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','18',425,'17','1',9796.42,10976.62,1180.20,194733.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','18',426,'18','1',33124.79,36098.51,2973.72,490663.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','18',427,'19','1',17416.72,20155.74,2739.02,451938.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','18',428,'20','1',31064.06,33157.91,2093.85,345485.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','18',429,'21','2',35893.62,38458.14,2544.52,1717551.00,0.00,0.00,20.00,0.00,0.00),('1','248','4','18',430,'22','2',19329.95,19329.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','18',431,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','18',432,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','19',433,'1','1',77026.21,78882.00,1835.79,302905.35,0.00,0.00,20.00,0.00,0.00),('1','248','1','19',434,'2','1',48860.25,48880.25,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','248','1','19',435,'3','1',54734.15,56317.42,1563.27,257939.55,0.00,0.00,20.00,0.00,0.00),('1','248','1','19',436,'4','1',51308.53,52725.68,1397.15,230529.75,0.00,0.00,20.00,0.00,0.00),('1','248','1','19',437,'5','1',78310.35,79882.73,1542.38,254492.70,0.00,0.00,30.00,0.00,0.00),('1','248','1','19',438,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','19',439,'7','1',48780.46,48800.46,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','248','2','19',440,'8','1',57621.91,59535.93,1894.02,312513.30,0.00,0.00,20.00,0.00,0.00),('1','248','2','19',441,'9','1',60985.67,62006.56,1000.89,165146.85,0.00,0.00,20.00,0.00,0.00),('1','248','2','19',442,'10','1',49269.92,50165.87,865.95,142881.75,0.00,0.00,30.00,0.00,0.00),('1','248','2','19',443,'11','1',56242.73,58190.18,1937.45,319679.25,0.00,0.00,10.00,0.00,0.00),('1','248','2','19',444,'12','1',40174.44,40194.44,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','248','3','19',445,'13','1',22493.37,22493.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','19',446,'14','1',32848.52,32848.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','19',447,'15','1',35783.14,35783.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','19',448,'16','1',27575.36,27575.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','19',449,'17','1',10976.62,10976.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','19',450,'18','1',36098.51,36098.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','19',451,'19','1',20155.74,20155.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','19',452,'20','1',33157.91,33157.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','19',453,'21','2',38458.14,41232.26,2772.20,1871235.00,0.00,0.00,1.92,0.00,0.00),('1','248','4','19',454,'22','2',19329.95,20208.89,878.94,593284.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','19',455,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','19',456,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','20',457,'1','1',78882.00,78882.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','20',458,'2','1',48880.25,48880.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','20',459,'3','1',56317.42,56317.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','20',460,'4','1',52725.68,52725.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','20',461,'5','1',79882.73,79882.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','20',462,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','20',463,'7','1',48800.46,48800.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','20',464,'8','1',59535.93,59535.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','20',465,'9','1',62006.56,62006.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','20',466,'10','1',50165.87,50165.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','20',467,'11','1',58190.18,58190.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','20',468,'12','1',40194.44,40194.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','20',469,'13','1',22493.37,22493.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','20',470,'14','1',32848.52,32848.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','20',471,'15','1',35783.14,35783.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','20',472,'16','1',27575.36,27575.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','20',473,'17','1',10976.62,10976.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','20',474,'18','1',36098.51,36098.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','20',475,'19','1',20155.74,20155.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','20',476,'20','1',33157.91,33157.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','20',477,'21','2',41232.26,41232.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','20',478,'22','2',20208.89,20208.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','20',479,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','20',480,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','21',481,'1','1',78882.00,85098.88,6216.88,1025785.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','21',482,'2','1',48880.25,48880.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','21',483,'3','1',56317.42,59502.03,3184.61,525460.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','21',484,'4','1',52725.68,57657.49,4931.81,813748.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','21',485,'5','1',79882.73,84790.09,4907.36,809714.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','21',486,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','21',487,'7','1',48800.46,52307.83,3507.37,578716.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','21',488,'8','1',59535.93,63997.41,4461.48,736144.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','21',489,'9','1',62006.56,67263.43,5256.87,867383.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','21',490,'10','1',50165.87,50165.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','21',491,'11','1',58190.18,58190.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','21',492,'12','1',40194.44,45049.72,4855.28,801121.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','21',493,'13','1',22493.37,22657.21,163.84,27033.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','21',494,'14','1',32848.52,32921.97,73.45,12119.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','21',495,'15','1',35783.14,35873.50,90.36,14909.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','21',496,'16','1',27575.36,27696.86,121.50,20047.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','21',497,'17','1',10976.62,11635.49,658.87,108713.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','21',498,'18','1',36098.51,36548.12,449.61,74185.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','21',499,'19','1',20155.74,20557.25,401.51,66249.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','21',500,'20','1',33157.91,33567.73,409.82,67620.30,0.00,0.00,0.00,0.00,0.00),('1','248','4','21',501,'21','2',41232.26,42911.54,1679.28,1133514.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','21',502,'22','2',20208.89,20208.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','21',503,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','21',504,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','22',505,'1','1',85098.88,85098.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','22',506,'2','1',48880.25,48880.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','22',507,'3','1',59502.03,59502.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','22',508,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','22',509,'5','1',84790.09,84790.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','22',510,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','22',511,'7','1',52307.83,52307.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','22',512,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','22',513,'9','1',67263.43,67263.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','22',514,'10','1',50165.87,50165.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','22',515,'11','1',58190.18,58190.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','22',516,'12','1',45049.72,45049.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','22',517,'13','1',22657.21,22657.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','22',518,'14','1',32921.97,32921.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','22',519,'15','1',35873.50,35873.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','22',520,'16','1',27696.86,27696.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','22',521,'17','1',11635.49,11635.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','22',522,'18','1',36548.12,36548.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','22',523,'19','1',20557.25,20557.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','22',524,'20','1',33567.73,33567.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','22',525,'21','2',42911.54,42911.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','22',526,'22','2',20208.89,20208.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','22',527,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','22',528,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','23',529,'1','1',85098.88,86837.56,1738.68,286882.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','23',530,'2','1',48880.25,48880.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','23',531,'3','1',59502.03,59502.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','23',532,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','23',533,'5','1',84790.09,87236.65,2446.56,403682.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','23',534,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','23',535,'7','1',52307.83,54637.28,2329.45,384359.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','23',536,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','23',537,'9','1',67263.43,67263.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','23',538,'10','1',50165.87,50165.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','23',539,'11','1',58190.18,62136.28,3946.10,651106.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','23',540,'12','1',45049.72,45049.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','23',541,'13','1',22657.21,26436.02,3778.81,623503.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','23',542,'14','1',32921.97,36029.17,3107.20,512688.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','23',543,'15','1',35873.50,39798.89,3925.39,647689.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','23',544,'16','1',27696.86,30953.36,3256.50,537322.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','23',545,'17','1',11635.49,13215.33,1579.84,260673.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','23',546,'18','1',36548.12,40540.60,3992.48,658759.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','23',547,'19','1',20557.25,20557.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','23',548,'20','1',33567.73,37756.29,4188.56,691112.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','23',549,'21','2',42911.54,45923.53,3011.99,2033093.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','23',550,'22','2',20208.89,21790.48,1581.59,1067573.25,0.00,0.00,0.00,0.00,0.00),('1','248','5','23',551,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','23',552,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','24',553,'1','1',86837.56,86837.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','24',554,'2','1',48880.25,53278.07,4397.82,725640.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','24',555,'3','1',59502.03,64639.75,5137.72,847723.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','24',556,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','24',557,'5','1',87236.65,91836.73,4600.08,759013.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','24',558,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','24',559,'7','1',54637.28,58675.59,4038.31,666321.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','24',560,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','24',561,'9','1',67263.43,67263.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','24',562,'10','1',50165.87,54858.10,4692.23,774217.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','24',563,'11','1',62136.28,62136.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','24',564,'12','1',45049.72,49925.72,4876.00,804540.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','24',565,'13','1',26436.02,30975.26,4539.24,748974.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','24',566,'14','1',36029.17,36029.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','24',567,'15','1',39798.89,42828.68,3029.79,499915.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','24',568,'16','1',30953.36,30953.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','24',569,'17','1',13215.33,13215.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','24',570,'18','1',40540.60,44948.67,4408.07,727331.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','24',571,'19','1',20557.25,20557.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','24',572,'20','1',37756.29,40751.24,2994.95,494166.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','24',573,'21','2',45923.53,49487.52,3563.99,2405693.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','24',574,'22','2',21790.48,21790.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','24',575,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','24',576,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','25',577,'1','1',86837.56,91748.05,4910.49,810230.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','25',578,'2','1',53278.07,53278.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','25',579,'3','1',64639.75,64639.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','25',580,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','25',581,'5','1',91836.73,95378.47,3541.74,584387.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','25',582,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','25',583,'7','1',58675.59,63859.22,5183.63,855298.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','25',584,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','25',585,'9','1',67263.43,67263.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','25',586,'10','1',54858.10,54858.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','25',587,'11','1',62136.28,62136.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','25',588,'12','1',49925.72,53668.62,3742.90,617578.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','25',589,'13','1',30975.26,33863.15,2887.89,476501.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','25',590,'14','1',36029.17,36029.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','25',591,'15','1',42828.68,47238.38,4409.70,727600.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','25',592,'16','1',30953.36,30953.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','25',593,'17','1',13215.33,13215.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','25',594,'18','1',44948.67,48719.52,3750.85,618890.25,0.00,0.00,20.00,0.00,0.00),('1','248','3','25',595,'19','1',20557.25,20557.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','25',596,'20','1',40751.24,43698.16,2946.92,486241.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','25',597,'21','2',49487.52,52250.35,2762.83,1864910.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','25',598,'22','2',21790.48,22148.19,357.71,241454.25,0.00,0.00,0.00,0.00,0.00),('1','248','5','25',599,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','25',600,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','26',601,'1','1',91748.05,96293.96,4545.91,750075.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','26',602,'2','1',53278.07,53332.62,54.55,9000.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','26',603,'3','1',64639.75,69206.95,4567.20,753588.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','26',604,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','26',605,'5','1',95378.47,99143.60,3765.13,621246.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','26',606,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','26',607,'7','1',63859.22,69742.05,5882.83,970666.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','26',608,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','26',609,'9','1',67263.43,71659.35,4395.92,725326.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','26',610,'10','1',54858.10,54858.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','26',611,'11','1',62136.28,66892.34,4756.06,784749.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','26',612,'12','1',53668.62,53668.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','26',613,'13','1',33863.15,38418.86,4555.71,751692.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','26',614,'14','1',36029.17,36029.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','26',615,'15','1',47238.38,51059.78,3821.40,630531.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','26',616,'16','1',30953.36,30953.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','26',617,'17','1',13215.33,13215.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','26',618,'18','1',48719.52,52720.60,4001.08,660178.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','26',619,'19','1',20557.25,20557.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','26',620,'20','1',43698.16,47073.73,3375.57,556969.05,0.00,0.00,0.00,0.00,0.00),('1','248','4','26',621,'21','2',52250.35,56044.00,3793.65,2560713.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','26',622,'22','2',22148.19,22315.00,166.81,112596.75,0.00,0.00,0.00,0.00,0.00),('1','248','5','26',623,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','26',624,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','27',625,'1','1',96293.96,102906.94,6612.98,1091141.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','27',626,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','27',627,'3','1',69206.95,69206.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','27',628,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','27',629,'5','1',99143.60,100877.58,1733.98,286106.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','27',630,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','27',631,'7','1',69742.05,74754.37,5012.32,827032.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','27',632,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','27',633,'9','1',71659.35,71659.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','27',634,'10','1',54858.10,54858.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','27',635,'11','1',66892.34,72590.75,5698.41,940237.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','27',636,'12','1',53668.62,53668.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','27',637,'13','1',38418.86,38418.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','27',638,'14','1',36029.17,36029.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','27',639,'15','1',51059.78,55591.58,4531.80,747747.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','27',640,'16','1',30953.36,30953.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','27',641,'17','1',13215.33,19844.69,6629.36,1093844.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','27',642,'18','1',52720.60,52720.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','27',643,'19','1',20557.25,20557.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','27',644,'20','1',47073.73,51832.24,4758.51,785154.15,0.00,0.00,0.00,0.00,0.00),('1','248','4','27',645,'21','2',56044.00,59591.51,3547.51,2394569.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','27',646,'22','2',22315.00,22315.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','27',647,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','27',648,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','28',649,'1','1',102906.94,102906.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','28',650,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','28',651,'3','1',69206.95,69206.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','28',652,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','28',653,'5','1',100877.58,100877.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','28',654,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','28',655,'7','1',74754.37,74754.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','28',656,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','28',657,'9','1',71659.35,71659.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','28',658,'10','1',54858.10,54858.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','28',659,'11','1',72590.75,72590.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','28',660,'12','1',53668.62,53668.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','28',661,'13','1',38418.86,38418.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','28',662,'14','1',36029.17,36029.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','28',663,'15','1',55591.58,55591.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','28',664,'16','1',30953.36,30953.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','28',665,'17','1',19844.69,19844.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','28',666,'18','1',52720.60,52720.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','28',667,'19','1',20557.25,20557.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','28',668,'20','1',51832.24,51832.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','28',669,'21','2',59591.51,59591.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','28',670,'22','2',22315.00,22315.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','28',671,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','28',672,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','29',673,'1','1',102906.94,102906.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','29',674,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','29',675,'3','1',69206.95,69206.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','29',676,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','29',677,'5','1',100877.58,100877.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','29',678,'6','1',569.13,569.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','29',679,'7','1',74754.37,74754.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','29',680,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','29',681,'9','1',71659.35,71659.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','29',682,'10','1',54858.10,54858.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','29',683,'11','1',72590.75,72590.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','29',684,'12','1',53668.62,53668.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','29',685,'13','1',38418.86,38418.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','29',686,'14','1',36029.17,36029.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','29',687,'15','1',55591.58,55591.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','29',688,'16','1',30953.36,30953.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','29',689,'17','1',19844.69,19844.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','29',690,'18','1',52720.60,52720.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','29',691,'19','1',20557.25,20557.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','29',692,'20','1',51832.24,51832.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','29',693,'21','2',59591.51,59591.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','29',694,'22','2',22315.00,22315.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','29',695,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','29',696,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','30',697,'1','1',102906.94,108204.48,5297.54,874094.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','30',698,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','30',699,'3','1',69206.95,69206.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','30',700,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','30',701,'5','1',100877.58,104454.52,3576.94,590195.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','30',702,'6','1',569.13,569.27,0.14,23.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','30',703,'7','1',74754.37,78431.50,3677.13,606726.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','30',704,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','30',705,'9','1',71659.35,71659.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','30',706,'10','1',54858.10,54858.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','30',707,'11','1',72590.75,76844.99,4254.24,701949.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','30',708,'12','1',53668.62,53668.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','30',709,'13','1',38418.86,42907.85,4488.99,740683.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','30',710,'14','1',36029.17,40285.04,4255.87,702218.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','30',711,'15','1',55591.58,61085.37,5493.79,906475.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','30',712,'16','1',30953.36,31665.77,712.41,117547.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','30',713,'17','1',19844.69,19844.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','30',714,'18','1',52720.60,58128.10,5407.50,892237.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','30',715,'19','1',20557.25,21984.71,1427.46,235530.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','30',716,'20','1',51832.24,56172.72,4340.48,716179.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','30',717,'21','2',59591.51,62370.68,2779.17,1875939.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','30',718,'22','2',22315.00,22511.31,196.31,132509.25,0.00,0.00,0.00,0.00,0.00),('1','248','5','30',719,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','30',720,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','31',721,'1','1',108204.48,114224.45,6019.97,993295.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','31',722,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','31',723,'3','1',69206.95,69206.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','31',724,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','31',725,'5','1',104454.52,110989.62,6535.10,1078291.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','31',726,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','31',727,'7','1',78431.50,84686.89,6255.39,1032139.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','31',728,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','31',729,'9','1',71659.35,71659.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','31',730,'10','1',54858.10,54858.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','31',731,'11','1',76844.99,83781.56,6936.57,1144534.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','31',732,'12','1',53668.62,53668.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','31',733,'13','1',42907.85,42907.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','31',734,'14','1',40285.04,42185.97,1900.93,313653.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','31',735,'15','1',61085.37,61085.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','31',736,'16','1',31665.77,31665.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','31',737,'17','1',19844.69,19844.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','31',738,'18','1',58128.10,64344.40,6216.30,1025689.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','31',739,'19','1',21984.71,22255.36,270.65,44657.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','31',740,'20','1',56172.72,62333.78,6161.06,1016574.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','31',741,'21','2',62370.68,65464.39,3093.71,2088254.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','31',742,'22','2',22511.31,23747.05,1235.74,834124.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','31',743,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','31',744,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','32',745,'1','1',114224.45,114224.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','32',746,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','32',747,'3','1',69206.95,69206.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','32',748,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','32',749,'5','1',110989.62,110989.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','32',750,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','32',751,'7','1',84686.89,84686.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','32',752,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','32',753,'9','1',71659.35,71659.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','32',754,'10','1',54858.10,54858.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','32',755,'11','1',83781.56,83781.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','32',756,'12','1',53668.62,53668.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','32',757,'13','1',42907.85,42907.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','32',758,'14','1',42185.97,42185.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','32',759,'15','1',61085.37,61085.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','32',760,'16','1',31665.77,31665.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','32',761,'17','1',19844.69,19844.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','32',762,'18','1',64344.40,64344.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','32',763,'19','1',22255.36,22255.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','32',764,'20','1',62333.78,62333.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','32',765,'21','2',65464.39,65464.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','32',766,'22','2',23747.05,23747.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','32',767,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','32',768,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','33',769,'1','1',114224.45,114224.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','33',770,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','33',771,'3','1',69206.95,69206.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','33',772,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','33',773,'5','1',110989.62,110989.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','33',774,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','33',775,'7','1',84686.89,84686.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','33',776,'8','1',63997.41,63997.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','33',777,'9','1',71659.35,71659.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','33',778,'10','1',54858.10,54858.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','33',779,'11','1',83781.56,83781.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','33',780,'12','1',53668.62,53668.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','33',781,'13','1',42907.85,42907.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','33',782,'14','1',42185.97,42185.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','33',783,'15','1',61085.37,61085.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','33',784,'16','1',31665.77,31665.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','33',785,'17','1',19844.69,19844.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','33',786,'18','1',64344.40,64344.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','33',787,'19','1',22255.36,22255.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','33',788,'20','1',62333.78,62333.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','33',789,'21','2',65464.39,65464.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','33',790,'22','2',23747.05,23747.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','33',791,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','33',792,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','34',793,'1','1',114224.45,119455.62,5231.17,863143.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','34',794,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','34',795,'3','1',69206.95,74231.17,5024.22,828996.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','34',796,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','34',797,'5','1',110989.62,116424.49,5434.87,896753.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','34',798,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','34',799,'7','1',84686.89,89478.23,4791.34,790571.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','34',800,'8','1',63997.41,66496.83,2499.42,412404.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','34',801,'9','1',71659.35,76939.81,5280.46,871275.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','34',802,'10','1',54858.10,54858.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','34',803,'11','1',83781.56,88788.89,5007.33,826209.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','34',804,'12','1',53668.62,53668.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','34',805,'13','1',42907.85,46624.48,3716.63,613243.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','34',806,'14','1',42185.97,42195.97,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','34',807,'15','1',61085.37,65078.38,3993.01,658846.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','34',808,'16','1',31665.77,31715.77,50.00,8250.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','34',809,'17','1',19844.69,19858.73,14.04,2316.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','34',810,'18','1',64344.40,66083.54,1739.14,286958.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','34',811,'19','1',22255.36,22265.36,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','34',812,'20','1',62333.78,65311.28,2977.50,491287.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','34',813,'21','2',65464.39,67779.93,2315.54,1562989.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','34',814,'22','2',23747.05,23773.72,26.67,18002.25,0.00,0.00,0.00,0.00,0.00),('1','248','5','34',815,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','34',816,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','35',817,'1','1',119455.62,123778.27,4322.65,713237.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','35',818,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','35',819,'3','1',74231.17,77315.98,3084.81,508993.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','35',820,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','35',821,'5','1',116424.49,121927.79,5503.30,908044.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','35',822,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','35',823,'7','1',89478.23,94791.24,5313.01,876646.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','35',824,'8','1',66496.83,66496.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','35',825,'9','1',76939.81,80028.73,3088.92,509671.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','35',826,'10','1',54858.10,55524.82,666.72,110008.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','35',827,'11','1',88788.89,93871.26,5082.37,838591.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','35',828,'12','1',53668.62,53747.41,78.79,13000.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','35',829,'13','1',46624.48,51928.37,5303.89,875141.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','35',830,'14','1',42195.97,42195.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','35',831,'15','1',65078.38,65839.12,760.74,125522.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','35',832,'16','1',31715.77,31715.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','35',833,'17','1',19858.73,20465.07,606.34,100046.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','35',834,'18','1',66083.54,68796.34,2712.80,447612.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','35',835,'19','1',22265.36,22265.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','35',836,'20','1',65311.28,69777.17,4465.89,736871.85,0.00,0.00,0.00,0.00,0.00),('1','248','4','35',837,'21','2',67779.93,70211.94,2432.01,1641606.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','35',838,'22','2',23773.72,28692.45,4918.73,3320142.75,0.00,0.00,0.00,0.00,0.00),('1','248','5','35',839,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','35',840,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','36',841,'1','1',123778.27,123778.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','36',842,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','36',843,'3','1',77315.98,77315.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','36',844,'4','1',57657.49,57657.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','36',845,'5','1',121927.79,121927.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','36',846,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','36',847,'7','1',94791.24,100373.01,5581.77,920992.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','36',848,'8','1',66496.83,66496.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','36',849,'9','1',80028.73,84865.70,4836.97,798100.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','36',850,'10','1',55524.82,55524.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','36',851,'11','1',93871.26,99608.24,5736.98,946601.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','36',852,'12','1',53747.41,53747.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','36',853,'13','1',51928.37,56728.62,4800.25,792041.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','36',854,'14','1',42195.97,45672.18,3476.21,573574.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','36',855,'15','1',65839.12,70503.14,4664.02,769563.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','36',856,'16','1',31715.77,35488.00,3772.23,622417.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','36',857,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','36',858,'18','1',68796.34,74025.22,5228.88,862765.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','36',859,'19','1',22265.36,26168.21,3902.85,643970.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','36',860,'20','1',69777.17,70094.16,316.99,52303.35,0.00,0.00,0.00,0.00,0.00),('1','248','4','36',861,'21','2',70211.94,71792.99,1581.05,1067208.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','36',862,'22','2',28692.45,28694.97,2.52,1701.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','36',863,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','36',864,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','37',865,'1','1',123778.27,127664.36,3886.09,641204.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','37',866,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','37',867,'3','1',77315.98,79694.54,2378.56,392462.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','37',868,'4','1',57657.49,58073.49,416.00,68640.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','37',869,'5','1',121927.79,125032.55,3084.76,508985.40,0.00,0.00,20.00,0.00,0.00),('1','248','1','37',870,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','37',871,'7','1',100373.01,100373.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','37',872,'8','1',66496.83,71793.63,5296.80,873972.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','37',873,'9','1',84865.70,85916.82,1051.12,173434.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','37',874,'10','1',55524.82,61588.24,6063.42,1000464.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','37',875,'11','1',99608.24,104870.16,5261.92,868216.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','37',876,'12','1',53747.41,54201.02,453.61,74845.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','37',877,'13','1',56728.62,58985.55,2256.93,372393.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','37',878,'14','1',45672.18,46493.81,821.63,135568.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','37',879,'15','1',70503.14,72685.92,2182.78,360158.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','37',880,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','37',881,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','37',882,'18','1',74025.22,75662.46,1637.24,270144.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','37',883,'19','1',26168.21,26168.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','37',884,'20','1',70094.16,72620.71,2526.55,416880.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','37',885,'21','2',71792.99,71908.92,115.93,78252.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','37',886,'22','2',28694.97,29469.23,774.26,522625.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','37',887,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','37',888,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','38',889,'1','1',127664.36,127664.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','38',890,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','38',891,'3','1',79694.54,79694.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','38',892,'4','1',58073.49,58073.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','38',893,'5','1',125032.55,125032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','38',894,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','38',895,'7','1',100373.01,100373.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','38',896,'8','1',71793.63,71793.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','38',897,'9','1',85916.82,85916.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','38',898,'10','1',61588.24,61588.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','38',899,'11','1',104870.16,104870.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','38',900,'12','1',54201.02,54201.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','38',901,'13','1',58985.55,58985.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','38',902,'14','1',46493.81,46493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','38',903,'15','1',72685.92,72685.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','38',904,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','38',905,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','38',906,'18','1',75662.46,75662.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','38',907,'19','1',26168.21,26168.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','38',908,'20','1',72620.71,72620.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','38',909,'21','2',71908.92,71908.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','38',910,'22','2',29469.23,29469.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','38',911,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','38',912,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','39',913,'1','1',127664.36,131435.32,3770.96,622208.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','39',914,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','39',915,'3','1',79694.54,83530.99,3836.45,633014.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','39',916,'4','1',58073.49,58073.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','39',917,'5','1',125032.55,128425.85,3393.30,559894.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','39',918,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','39',919,'7','1',100373.01,105234.93,4861.92,802216.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','39',920,'8','1',71793.63,71793.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','39',921,'9','1',85916.82,89255.69,3338.87,550913.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','39',922,'10','1',61588.24,61588.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','39',923,'11','1',104870.16,108830.57,3960.41,653467.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','39',924,'12','1',54201.02,54201.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','39',925,'13','1',58985.55,62266.33,3280.78,541328.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','39',926,'14','1',46493.81,46493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','39',927,'15','1',72685.92,73542.56,856.64,141345.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','39',928,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','39',929,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','39',930,'18','1',75662.46,78055.40,2392.94,394835.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','39',931,'19','1',26168.21,26168.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','39',932,'20','1',72620.71,75597.43,2976.72,491158.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','39',933,'21','2',71908.92,72330.20,421.28,284364.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','39',934,'22','2',29469.23,29564.50,95.27,64307.25,0.00,0.00,0.00,0.00,0.00),('1','248','5','39',935,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','39',936,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','40',937,'1','1',131435.32,136583.58,5148.26,849462.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','40',938,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','40',939,'3','1',83530.99,88751.95,5220.96,861458.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','40',940,'4','1',58073.49,58073.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','40',941,'5','1',128425.85,132647.09,4221.24,696504.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','40',942,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','40',943,'7','1',105234.93,108356.90,3121.97,515125.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','40',944,'8','1',71793.63,71793.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','40',945,'9','1',89255.69,92931.88,3676.19,606571.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','40',946,'10','1',61588.24,61588.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','40',947,'11','1',108830.57,108830.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','40',948,'12','1',54201.02,54201.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','40',949,'13','1',62266.33,67324.66,5058.33,834624.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','40',950,'14','1',46493.81,46493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','40',951,'15','1',73542.56,79259.36,5716.80,943272.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','40',952,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','40',953,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','40',954,'18','1',78055.40,78055.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','40',955,'19','1',26168.21,26216.09,47.88,7900.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','40',956,'20','1',75597.43,75597.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','40',957,'21','2',72330.20,73386.06,1055.86,712705.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','40',958,'22','2',29564.50,30516.82,952.32,642816.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','40',959,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','40',960,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','41',961,'1','1',136583.58,147155.09,10571.51,1744299.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','41',962,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','41',963,'3','1',88751.95,88751.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','41',964,'4','1',58073.49,58073.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','41',965,'5','1',132647.09,141154.58,8507.49,1403735.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','41',966,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','41',967,'7','1',108356.90,117495.38,9138.48,1507849.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','41',968,'8','1',71793.63,71793.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','41',969,'9','1',92931.88,92931.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','41',970,'10','1',61588.24,61588.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','41',971,'11','1',108830.57,118397.00,9566.43,1578460.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','41',972,'12','1',54201.02,54201.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','41',973,'13','1',67324.66,67423.43,98.77,16297.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','41',974,'14','1',46493.81,46493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','41',975,'15','1',79259.36,79259.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','41',976,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','41',977,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','41',978,'18','1',78055.40,84031.80,5976.40,986106.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','41',979,'19','1',26216.09,26216.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','41',980,'20','1',75597.43,81025.50,5428.07,895631.55,0.00,0.00,0.00,0.00,0.00),('1','248','4','41',981,'21','2',73386.06,74344.31,958.25,646818.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','41',982,'22','2',30516.82,31899.17,1382.35,933086.25,0.00,0.00,0.00,0.00,0.00),('1','248','5','41',983,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','41',984,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','42',985,'1','1',147155.09,150212.18,3057.09,504419.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','42',986,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','42',987,'3','1',88751.95,98007.16,9255.21,1527109.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','42',988,'4','1',58073.49,58073.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','42',989,'5','1',141154.58,141154.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','42',990,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','42',991,'7','1',117495.38,125135.39,7579.41,1250602.65,0.00,0.00,60.60,0.00,0.00),('1','248','2','42',992,'8','1',71793.63,71793.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','42',993,'9','1',92931.88,97518.68,4586.80,756822.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','42',994,'10','1',61588.24,62866.51,1235.85,203915.25,0.00,0.00,42.42,0.00,0.00),('1','248','2','42',995,'11','1',118397.00,128506.92,10109.92,1668136.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','42',996,'12','1',54201.02,54201.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','42',997,'13','1',67423.43,70815.21,3361.78,554693.70,0.00,0.00,30.00,0.00,0.00),('1','248','3','42',998,'14','1',46493.81,46493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','42',999,'15','1',79259.36,79259.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','42',1000,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','42',1001,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','42',1002,'18','1',84031.80,92237.19,8205.39,1353889.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','42',1003,'19','1',26216.09,26216.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','42',1004,'20','1',81025.50,89198.45,8172.95,1348536.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','42',1005,'21','2',74344.31,74962.26,609.06,411115.50,0.00,0.00,8.89,0.00,0.00),('1','248','4','42',1006,'22','2',31899.17,32036.94,137.77,92994.75,0.00,0.00,0.00,0.00,0.00),('1','248','5','42',1007,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','42',1008,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','43',1009,'1','1',150212.18,155929.26,5717.08,943318.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','43',1010,'2','1',53332.62,53332.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','43',1011,'3','1',98007.16,100568.62,2561.46,422640.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','43',1012,'4','1',58073.49,58073.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','43',1013,'5','1',141154.58,141154.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','43',1014,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','43',1015,'7','1',125135.39,129912.58,4777.19,788236.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','43',1016,'8','1',71793.63,71793.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','43',1017,'9','1',97518.68,100402.20,2883.52,475780.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','43',1018,'10','1',62866.51,62866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','43',1019,'11','1',128506.92,133053.75,4545.83,750061.95,0.00,0.00,1.00,0.00,0.00),('1','248','2','43',1020,'12','1',54201.02,54201.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','43',1021,'13','1',70815.21,70815.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','43',1022,'14','1',46493.81,46493.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','43',1023,'15','1',79259.36,81893.09,2633.73,434565.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','43',1024,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','43',1025,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','43',1026,'18','1',92237.19,98057.06,5819.87,960278.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','43',1027,'19','1',26216.09,26216.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','43',1028,'20','1',89198.45,94105.46,4907.01,809656.65,0.00,0.00,0.00,0.00,0.00),('1','248','4','43',1029,'21','2',74962.26,74962.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','43',1030,'22','2',32036.94,32036.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','43',1031,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','43',1032,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','44',1033,'1','1',155929.26,158310.07,2380.81,392833.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','44',1034,'2','1',53332.62,53900.26,567.64,93660.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','44',1035,'3','1',100568.62,102075.04,1506.42,248559.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','44',1036,'4','1',58073.49,59153.11,1079.62,178137.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','44',1037,'5','1',141154.58,143921.78,2767.20,456588.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','44',1038,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','44',1039,'7','1',129912.58,134845.62,4933.04,813951.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','44',1040,'8','1',71793.63,71793.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','44',1041,'9','1',100402.20,103760.38,3358.18,554099.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','44',1042,'10','1',62866.51,63211.21,344.70,56875.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','44',1043,'11','1',133053.75,137051.62,3997.87,659648.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','44',1044,'12','1',54201.02,55134.10,933.08,153958.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','44',1045,'13','1',70815.21,73067.79,2252.58,371675.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','44',1046,'14','1',46493.81,48021.10,1527.29,252002.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','44',1047,'15','1',81893.09,84563.87,2670.78,440678.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','44',1048,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','44',1049,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','44',1050,'18','1',98057.06,100439.67,2352.61,388180.65,0.00,0.00,30.00,0.00,0.00),('1','248','3','44',1051,'19','1',26216.09,26837.73,621.64,102570.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','44',1052,'20','1',94105.46,95821.18,1715.72,283093.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','44',1053,'21','2',74962.26,78211.51,3151.26,2127100.50,0.00,0.00,97.99,0.00,0.00),('1','248','4','44',1054,'22','2',32036.94,33092.32,1055.38,712381.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','44',1055,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','44',1056,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','45',1057,'1','1',158310.07,162056.16,3746.09,618104.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','45',1058,'2','1',53900.26,57683.71,3783.45,624269.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','45',1059,'3','1',102075.04,106359.63,4284.59,706957.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','45',1060,'4','1',59153.11,63237.09,4083.98,673856.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','45',1061,'5','1',143921.78,148922.66,5000.88,825145.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','45',1062,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','45',1063,'7','1',134845.62,134845.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','45',1064,'8','1',71793.63,71793.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','45',1065,'9','1',103760.38,103760.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','45',1066,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','45',1067,'11','1',137051.62,137051.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','45',1068,'12','1',55134.10,55134.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','45',1069,'13','1',73067.79,73067.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','45',1070,'14','1',48021.10,48021.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','45',1071,'15','1',84563.87,84563.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','45',1072,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','45',1073,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','45',1074,'18','1',100439.67,100439.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','45',1075,'19','1',26837.73,26837.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','45',1076,'20','1',95821.18,95821.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','45',1077,'21','2',78211.51,79565.80,1354.29,914145.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','45',1078,'22','2',33092.32,34130.83,1038.51,700994.25,0.00,0.00,0.00,0.00,0.00),('1','248','5','45',1079,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','45',1080,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','46',1081,'1','1',162056.16,164609.45,2553.29,421292.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','46',1082,'2','1',57683.71,62259.31,4575.60,754974.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','46',1083,'3','1',106359.63,111248.80,4889.17,806713.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','46',1084,'4','1',63237.09,65578.03,2340.94,386255.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','46',1085,'5','1',148922.66,154125.41,5202.75,858453.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','46',1086,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','46',1087,'7','1',134845.62,137462.84,2617.22,431841.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','46',1088,'8','1',71793.63,71793.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','46',1089,'9','1',103760.38,106111.93,2351.55,388005.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','46',1090,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','46',1091,'11','1',137051.62,139392.93,2341.31,386316.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','46',1092,'12','1',55134.10,55134.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','46',1093,'13','1',73067.79,75809.61,2741.82,452400.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','46',1094,'14','1',48021.10,48021.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','46',1095,'15','1',84563.87,87423.99,2860.12,471919.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','46',1096,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','46',1097,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','46',1098,'18','1',100439.67,102406.35,1966.68,324502.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','46',1099,'19','1',26837.73,26837.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','46',1100,'20','1',95821.18,98039.14,2217.96,365963.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','46',1101,'21','2',79565.80,82572.83,3007.03,2029745.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','46',1102,'22','2',34130.83,35142.42,1011.59,682823.25,0.00,0.00,0.00,0.00,0.00),('1','248','5','46',1103,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','46',1104,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','47',1105,'1','1',164609.45,169712.02,5102.57,841924.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','47',1106,'2','1',62259.31,62259.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','47',1107,'3','1',111248.80,111248.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','47',1108,'4','1',65578.03,65578.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','47',1109,'5','1',154125.41,158810.35,4684.94,773015.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','47',1110,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','47',1111,'7','1',137462.84,142044.41,4581.57,755959.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','47',1112,'8','1',71793.63,71793.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','47',1113,'9','1',106111.93,109556.57,3444.64,568365.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','47',1114,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','47',1115,'11','1',139392.93,143926.17,4533.24,747984.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','47',1116,'12','1',55134.10,55134.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','47',1117,'13','1',75809.61,80723.17,4913.56,810737.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','47',1118,'14','1',48021.10,48021.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','47',1119,'15','1',87423.99,91331.23,3907.24,644694.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','47',1120,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','47',1121,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','47',1122,'18','1',102406.35,107271.63,4865.28,802771.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','47',1123,'19','1',26837.73,26837.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','47',1124,'20','1',98039.14,102795.41,4756.27,784784.55,0.00,0.00,0.00,0.00,0.00),('1','248','4','47',1125,'21','2',82572.83,83861.92,1289.09,870135.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','47',1126,'22','2',35142.42,36256.40,1113.98,751936.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','47',1127,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','47',1128,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','48',1129,'1','1',169712.02,173695.63,3983.61,657295.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','48',1130,'2','1',62259.31,64551.00,2261.69,373178.85,0.00,0.00,30.00,0.00,0.00),('1','248','1','48',1131,'3','1',111248.80,115366.35,4117.55,679395.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','48',1132,'4','1',65578.03,65578.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','48',1133,'5','1',158810.35,161838.30,3027.95,499611.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','48',1134,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','48',1135,'7','1',142044.41,145701.72,3657.31,603456.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','48',1136,'8','1',71793.63,73307.13,1513.50,249727.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','48',1137,'9','1',109556.57,112899.17,3342.60,551529.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','48',1138,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','48',1139,'11','1',143926.17,146675.14,2748.97,453580.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','48',1140,'12','1',55134.10,55134.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','48',1141,'13','1',80723.17,83927.47,3204.30,528709.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','48',1142,'14','1',48021.10,48021.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','48',1143,'15','1',91331.23,94304.11,2972.88,490525.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','48',1144,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','48',1145,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','48',1146,'18','1',107271.63,109694.92,2423.29,399842.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','48',1147,'19','1',26837.73,26837.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','48',1148,'20','1',102795.41,105824.07,3028.66,499728.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','48',1149,'21','2',83861.92,85988.06,2126.14,1435144.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','48',1150,'22','2',36256.40,37680.59,1424.19,961328.25,0.00,0.00,0.00,0.00,0.00),('1','248','5','48',1151,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','48',1152,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','49',1153,'1','1',173695.63,177847.87,4152.24,685119.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','49',1154,'2','1',64551.00,68642.07,4091.07,675026.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','49',1155,'3','1',115366.35,118613.04,3246.69,535703.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','49',1156,'4','1',65578.03,69053.52,3475.49,573455.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','49',1157,'5','1',161838.30,166501.61,4663.31,769446.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','49',1158,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','49',1159,'7','1',145701.72,146745.86,1044.14,172283.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','49',1160,'8','1',73307.13,74421.69,1114.56,183902.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','49',1161,'9','1',112899.17,114332.20,1433.03,236449.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','49',1162,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','49',1163,'11','1',146675.14,147831.31,1156.17,190768.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','49',1164,'12','1',55134.10,55134.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','49',1165,'13','1',83927.47,83927.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','49',1166,'14','1',48021.10,48021.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','49',1167,'15','1',94304.11,94304.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','49',1168,'16','1',35488.00,35488.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','49',1169,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','49',1170,'18','1',109694.92,109694.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','49',1171,'19','1',26837.73,26837.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','49',1172,'20','1',105824.07,105824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','49',1173,'21','2',85988.06,86336.11,348.05,234933.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','49',1174,'22','2',37680.59,38576.36,895.77,604644.75,0.00,0.00,0.00,0.00,0.00),('1','248','5','49',1175,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','49',1176,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','50',1177,'1','1',177847.87,183047.25,5199.38,857897.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','50',1178,'2','1',68642.07,68642.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','50',1179,'3','1',118613.04,123012.40,4399.36,725894.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','50',1180,'4','1',69053.52,69053.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','50',1181,'5','1',166501.61,171865.23,5363.62,884997.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','50',1182,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','50',1183,'7','1',146745.86,146745.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','50',1184,'8','1',74421.69,74421.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','50',1185,'9','1',114332.20,114332.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','50',1186,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','50',1187,'11','1',147831.31,147831.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','50',1188,'12','1',55134.10,55134.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','50',1189,'13','1',83927.47,87464.53,3537.06,583614.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','50',1190,'14','1',48021.10,48021.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','50',1191,'15','1',94304.11,97534.51,3230.40,533016.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','50',1192,'16','1',35488.00,37963.42,2475.42,408444.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','50',1193,'17','1',20465.07,20465.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','50',1194,'18','1',109694.92,113317.49,3622.57,597724.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','50',1195,'19','1',26837.73,26837.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','50',1196,'20','1',105824.07,109130.84,3306.77,545617.05,0.00,0.00,0.00,0.00,0.00),('1','248','4','50',1197,'21','2',86336.11,88439.12,2103.01,1419531.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','50',1198,'22','2',38576.36,40148.14,1571.78,1060951.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','50',1199,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','50',1200,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','51',1201,'1','1',183047.25,183047.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','51',1202,'2','1',68642.07,68642.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','51',1203,'3','1',123012.40,123012.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','51',1204,'4','1',69053.52,69053.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','51',1205,'5','1',171865.23,171865.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','51',1206,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','51',1207,'7','1',146745.86,146745.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','51',1208,'8','1',74421.69,74421.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','51',1209,'9','1',114332.20,114332.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','51',1210,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','51',1211,'11','1',147831.31,147831.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','51',1212,'12','1',55134.10,55134.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','51',1213,'13','1',87464.53,90436.87,2972.34,490436.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','51',1214,'14','1',48021.10,51036.78,3015.68,497587.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','51',1215,'15','1',97534.51,101319.45,3784.94,624515.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','51',1216,'16','1',37963.42,37963.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','51',1217,'17','1',20465.07,23917.25,3422.18,564659.70,0.00,0.00,30.00,0.00,0.00),('1','248','3','51',1218,'18','1',113317.49,114120.70,803.21,132529.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','51',1219,'19','1',26837.73,30173.28,3335.55,550365.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','51',1220,'20','1',109130.84,112586.14,3455.30,570124.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','51',1221,'21','2',88439.12,89180.82,741.70,500647.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','51',1222,'22','2',40148.14,41628.51,1480.37,999249.75,0.00,0.00,0.00,0.00,0.00),('1','248','5','51',1223,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','51',1224,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','52',1225,'1','1',183047.25,183047.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','52',1226,'2','1',68642.07,68642.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','52',1227,'3','1',123012.40,123012.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','52',1228,'4','1',69053.52,69053.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','52',1229,'5','1',171865.23,171865.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','52',1230,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','52',1231,'7','1',146745.86,146745.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','52',1232,'8','1',74421.69,74421.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','52',1233,'9','1',114332.20,114332.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','52',1234,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','52',1235,'11','1',147831.31,147831.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','52',1236,'12','1',55134.10,55134.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','52',1237,'13','1',90436.87,90436.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','52',1238,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','52',1239,'15','1',101319.45,101324.85,5.40,891.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','52',1240,'16','1',37963.42,38015.37,51.95,8571.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','52',1241,'17','1',23917.25,23923.78,6.53,1077.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','52',1242,'18','1',114120.70,114139.66,18.96,3128.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','52',1243,'19','1',30173.28,30173.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','52',1244,'20','1',112586.14,112586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','52',1245,'21','2',89180.82,89523.41,342.59,231248.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','52',1246,'22','2',41628.51,43429.61,1801.10,1215742.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','52',1247,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','52',1248,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','53',1249,'1','1',183047.25,183047.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','53',1250,'2','1',68642.07,68642.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','53',1251,'3','1',123012.40,126607.50,3595.10,593191.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','53',1252,'4','1',69053.52,73182.43,4128.91,681270.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','53',1253,'5','1',171865.23,174329.09,2463.86,406536.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','53',1254,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','53',1255,'7','1',146745.86,146745.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','53',1256,'8','1',74421.69,74421.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','53',1257,'9','1',114332.20,114332.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','53',1258,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','53',1259,'11','1',147831.31,151911.43,4080.12,673219.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','53',1260,'12','1',55134.10,58305.45,3171.35,523272.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','53',1261,'13','1',90436.87,90436.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','53',1262,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','53',1263,'15','1',101324.85,101324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','53',1264,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','53',1265,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','53',1266,'18','1',114139.66,114139.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','53',1267,'19','1',30173.28,30173.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','53',1268,'20','1',112586.14,112586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','53',1269,'21','2',89523.41,89523.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','53',1270,'22','2',43429.61,45446.10,2016.49,1361130.75,0.00,0.00,0.00,0.00,0.00),('1','248','5','53',1271,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','53',1272,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','54',1273,'1','1',183047.25,183047.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','54',1274,'2','1',68642.07,68642.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','54',1275,'3','1',126607.50,131115.30,4507.80,743787.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','54',1276,'4','1',73182.43,77032.51,3850.08,635263.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','54',1277,'5','1',174329.09,174329.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','54',1278,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','54',1279,'7','1',146745.86,146745.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','54',1280,'8','1',74421.69,74421.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','54',1281,'9','1',114332.20,114332.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','54',1282,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','54',1283,'11','1',151911.43,155681.23,3769.80,622017.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','54',1284,'12','1',58305.45,62288.96,3983.51,657279.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','54',1285,'13','1',90436.87,90436.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','54',1286,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','54',1287,'15','1',101324.85,101324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','54',1288,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','54',1289,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','54',1290,'18','1',114139.66,114139.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','54',1291,'19','1',30173.28,30173.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','54',1292,'20','1',112586.14,112586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','54',1293,'21','2',89523.41,89523.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','54',1294,'22','2',45446.10,45446.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','54',1295,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','54',1296,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','55',1297,'1','1',183047.25,185628.36,2581.11,425883.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','55',1298,'2','1',68642.07,70868.70,2226.63,367393.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','55',1299,'3','1',131115.30,132030.26,914.96,150968.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','55',1300,'4','1',77032.51,77759.61,727.10,119971.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','55',1301,'5','1',174329.09,178232.18,3903.09,644009.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','55',1302,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','55',1303,'7','1',146745.86,148905.50,2159.64,356340.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','55',1304,'8','1',74421.69,75037.23,615.54,101564.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','55',1305,'9','1',114332.20,114332.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','55',1306,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','55',1307,'11','1',155681.23,158578.07,2896.84,477978.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','55',1308,'12','1',62288.96,64953.09,2664.13,439581.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','55',1309,'13','1',90436.87,90436.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','55',1310,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','55',1311,'15','1',101324.85,101324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','55',1312,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','55',1313,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','55',1314,'18','1',114139.66,114139.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','55',1315,'19','1',30173.28,30173.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','55',1316,'20','1',112586.14,112586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','55',1317,'21','2',89523.41,89523.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','55',1318,'22','2',45446.10,45446.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','55',1319,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','55',1320,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','56',1321,'1','1',185628.36,185628.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','56',1322,'2','1',70868.70,70868.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','56',1323,'3','1',132030.26,132030.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','56',1324,'4','1',77759.61,77759.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','56',1325,'5','1',178232.18,178232.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','56',1326,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','56',1327,'7','1',148905.50,148905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','56',1328,'8','1',75037.23,75037.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','56',1329,'9','1',114332.20,114332.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','56',1330,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','56',1331,'11','1',158578.07,158578.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','56',1332,'12','1',64953.09,64953.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','56',1333,'13','1',90436.87,90436.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','56',1334,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','56',1335,'15','1',101324.85,101324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','56',1336,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','56',1337,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','56',1338,'18','1',114139.66,114139.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','56',1339,'19','1',30173.28,30173.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','56',1340,'20','1',112586.14,112586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','56',1341,'21','2',89523.41,89523.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','56',1342,'22','2',45446.10,45446.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','56',1343,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','56',1344,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','57',1345,'1','1',185628.36,189896.27,4227.91,697605.15,0.00,0.00,40.00,0.00,0.00),('1','248','1','57',1346,'2','1',70868.70,70868.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','57',1347,'3','1',132030.26,135855.01,3804.75,627783.75,0.00,0.00,20.00,0.00,0.00),('1','248','1','57',1348,'4','1',77759.61,77759.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','57',1349,'5','1',178232.18,181762.45,3520.27,580844.55,0.00,0.00,10.00,0.00,0.00),('1','248','1','57',1350,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','57',1351,'7','1',148905.50,148905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','57',1352,'8','1',75037.23,78411.33,3374.10,556726.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','57',1353,'9','1',114332.20,114332.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','57',1354,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','57',1355,'11','1',158578.07,161967.90,3389.83,559321.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','57',1356,'12','1',64953.09,67379.85,2426.76,400415.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','57',1357,'13','1',90436.87,90436.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','57',1358,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','57',1359,'15','1',101324.85,101324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','57',1360,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','57',1361,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','57',1362,'18','1',114139.66,114139.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','57',1363,'19','1',30173.28,30173.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','57',1364,'20','1',112586.14,112586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','57',1365,'21','2',89523.41,89523.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','57',1366,'22','2',45446.10,45446.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','57',1367,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','57',1368,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','58',1369,'1','1',189896.27,193726.80,3830.53,632037.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','58',1370,'2','1',70868.70,73631.43,2752.73,454200.45,0.00,0.00,10.00,0.00,0.00),('1','248','1','58',1371,'3','1',135855.01,139954.49,4089.48,674764.20,0.00,0.00,10.00,0.00,0.00),('1','248','1','58',1372,'4','1',77759.61,80515.11,2745.50,453007.50,0.00,0.00,10.00,0.00,0.00),('1','248','1','58',1373,'5','1',181762.45,186360.76,4571.04,754221.60,0.00,0.00,27.27,0.00,0.00),('1','248','1','58',1374,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','58',1375,'7','1',148905.50,148905.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','58',1376,'8','1',78411.33,83319.07,4884.71,805977.15,0.00,0.00,23.03,0.00,0.00),('1','248','2','58',1377,'9','1',114332.20,114332.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','58',1378,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','58',1379,'11','1',161967.90,166436.84,4464.14,736583.10,0.00,0.00,4.80,0.00,0.00),('1','248','2','58',1380,'12','1',67379.85,70605.63,3185.78,525653.70,0.00,0.00,40.00,0.00,0.00),('1','248','3','58',1381,'13','1',90436.87,90436.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','58',1382,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','58',1383,'15','1',101324.85,101324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','58',1384,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','58',1385,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','58',1386,'18','1',114139.66,114139.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','58',1387,'19','1',30173.28,30173.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','58',1388,'20','1',112586.14,112586.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','58',1389,'21','2',89523.41,91313.87,1790.46,1253322.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','58',1390,'22','2',45446.10,48221.96,2775.86,1943102.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','58',1391,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','58',1392,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','59',1393,'1','1',193726.80,196825.98,3099.18,511364.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','59',1394,'2','1',73631.43,73631.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','59',1395,'3','1',139954.49,142554.46,2599.97,428995.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','59',1396,'4','1',80515.11,80515.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','59',1397,'5','1',186360.76,189233.60,2872.84,474018.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','59',1398,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','59',1399,'7','1',148905.50,150133.08,1227.58,202550.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','59',1400,'8','1',83319.07,86871.41,3552.34,586136.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','59',1401,'9','1',114332.20,118582.99,4250.79,701380.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','59',1402,'10','1',63211.21,63211.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','59',1403,'11','1',166436.84,172310.26,5873.42,969114.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','59',1404,'12','1',70605.63,70605.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','59',1405,'13','1',90436.87,90436.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','59',1406,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','59',1407,'15','1',101324.85,101324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','59',1408,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','59',1409,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','59',1410,'18','1',114139.66,115421.78,1282.12,211549.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','59',1411,'19','1',30173.28,30173.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','59',1412,'20','1',112586.14,113188.16,602.02,99333.30,0.00,0.00,0.00,0.00,0.00),('1','248','4','59',1413,'21','2',91313.87,91313.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','59',1414,'22','2',48221.96,48221.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','59',1415,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','59',1416,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','60',1417,'1','1',196825.98,203097.07,6271.09,1034729.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','60',1418,'2','1',73631.43,73631.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','60',1419,'3','1',142554.46,147752.80,5198.34,857726.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','60',1420,'4','1',80515.11,80515.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','60',1421,'5','1',189233.60,193845.59,4611.99,760978.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','60',1422,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','60',1423,'7','1',150133.08,150133.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','60',1424,'8','1',86871.41,91693.42,4822.01,795631.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','60',1425,'9','1',118582.99,124185.51,5602.52,924415.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','60',1426,'10','1',63211.21,63625.56,414.35,68367.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','60',1427,'11','1',172310.26,177529.40,5219.14,861158.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','60',1428,'12','1',70605.63,70627.83,22.20,3663.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','60',1429,'13','1',90436.87,90436.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','60',1430,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','60',1431,'15','1',101324.85,101324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','60',1432,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','60',1433,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','60',1434,'18','1',115421.78,120312.22,4890.44,806922.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','60',1435,'19','1',30173.28,30173.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','60',1436,'20','1',113188.16,117626.84,4438.68,732382.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','60',1437,'21','2',91313.87,92761.70,1447.83,1013481.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','60',1438,'22','2',48221.96,50614.01,2392.05,1674435.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','60',1439,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','60',1440,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','61',1441,'1','1',203097.07,207378.51,4281.44,706437.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','61',1442,'2','1',73631.43,75091.56,1460.13,240921.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','61',1443,'3','1',147752.80,151507.46,3754.66,619518.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','61',1444,'4','1',80515.11,82248.91,1733.80,286077.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','61',1445,'5','1',193845.59,197988.58,4142.99,683593.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','61',1446,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','61',1447,'7','1',150133.08,150133.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','61',1448,'8','1',91693.42,94285.83,2592.41,427747.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','61',1449,'9','1',124185.51,125009.72,824.21,135994.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','61',1450,'10','1',63625.56,63625.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','61',1451,'11','1',177529.40,181173.32,3643.92,601246.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','61',1452,'12','1',70627.83,70627.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','61',1453,'13','1',90436.87,90436.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','61',1454,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','61',1455,'15','1',101324.85,101324.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','61',1456,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','61',1457,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','61',1458,'18','1',120312.22,121794.75,1482.53,244617.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','61',1459,'19','1',30173.28,30434.09,260.81,43033.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','61',1460,'20','1',117626.84,119691.32,2064.48,340639.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','61',1461,'21','2',92761.70,93405.49,643.79,450653.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','61',1462,'22','2',50614.01,51374.92,760.91,532637.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','61',1463,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','61',1464,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','62',1465,'1','1',207378.51,208690.56,1302.05,214838.25,0.00,0.00,10.00,0.00,0.00),('1','248','1','62',1466,'2','1',75091.56,75091.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','62',1467,'3','1',151507.46,151507.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','62',1468,'4','1',82248.91,82248.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','62',1469,'5','1',197988.58,199128.76,1131.98,186776.70,0.00,0.00,8.20,0.00,0.00),('1','248','1','62',1470,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','62',1471,'7','1',150133.08,154424.91,4281.83,706501.95,0.00,0.00,10.00,0.00,0.00),('1','248','2','62',1472,'8','1',94285.83,94285.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','62',1473,'9','1',125009.72,128051.40,3031.68,500227.20,0.00,0.00,10.00,0.00,0.00),('1','248','2','62',1474,'10','1',63625.56,64759.86,1124.30,185509.50,0.00,0.00,10.00,0.00,0.00),('1','248','2','62',1475,'11','1',181173.32,186352.56,5179.24,854574.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','62',1476,'12','1',70627.83,70627.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','62',1477,'13','1',90436.87,95555.56,5089.69,839798.85,0.00,0.00,29.00,0.00,0.00),('1','248','3','62',1478,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','62',1479,'15','1',101324.85,104083.10,2738.25,451811.25,0.00,0.00,20.00,0.00,0.00),('1','248','3','62',1480,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','62',1481,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','62',1482,'18','1',121794.75,127734.39,5899.64,973440.60,0.00,0.00,40.00,0.00,0.00),('1','248','3','62',1483,'19','1',30434.09,30472.74,38.65,6377.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','62',1484,'20','1',119691.32,125256.77,5515.45,910049.25,0.00,0.00,50.00,0.00,0.00),('1','248','4','62',1485,'21','2',93405.49,95287.23,1881.74,1317218.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','62',1486,'22','2',51374.92,53031.35,1656.43,1159501.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','62',1487,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','62',1488,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','63',1489,'1','1',208690.56,208690.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','63',1490,'2','1',75091.56,75091.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','63',1491,'3','1',151507.46,151507.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','63',1492,'4','1',82248.91,82248.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','63',1493,'5','1',199128.76,199128.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','63',1494,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','63',1495,'7','1',154424.91,154424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','63',1496,'8','1',94285.83,94285.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','63',1497,'9','1',128051.40,128051.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','63',1498,'10','1',64759.86,64759.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','63',1499,'11','1',186352.56,186352.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','63',1500,'12','1',70627.83,70627.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','63',1501,'13','1',95555.56,95555.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','63',1502,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','63',1503,'15','1',104083.10,104083.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','63',1504,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','63',1505,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','63',1506,'18','1',127734.39,127734.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','63',1507,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','63',1508,'20','1',125256.77,125256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','63',1509,'21','2',95287.23,95287.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','63',1510,'22','2',53031.35,53031.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','63',1511,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','63',1512,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','64',1513,'1','1',208690.56,208690.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','64',1514,'2','1',75091.56,75091.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','64',1515,'3','1',151507.46,151507.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','64',1516,'4','1',82248.91,82248.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','64',1517,'5','1',199128.76,199128.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','64',1518,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','64',1519,'7','1',154424.91,154424.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','64',1520,'8','1',94285.83,94285.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','64',1521,'9','1',128051.40,128051.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','64',1522,'10','1',64759.86,64759.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','64',1523,'11','1',186352.56,186352.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','64',1524,'12','1',70627.83,70627.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','64',1525,'13','1',95555.56,95555.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','64',1526,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','64',1527,'15','1',104083.10,104083.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','64',1528,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','64',1529,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','64',1530,'18','1',127734.39,127734.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','64',1531,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','64',1532,'20','1',125256.77,125256.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','64',1533,'21','2',95287.23,95834.22,546.99,382893.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','64',1534,'22','2',53031.35,53723.41,692.06,484442.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','64',1535,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','64',1536,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','65',1537,'1','1',208690.56,208690.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','65',1538,'2','1',75091.56,75091.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','65',1539,'3','1',151507.46,151507.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','65',1540,'4','1',82248.91,82248.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','65',1541,'5','1',199128.76,199128.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','65',1542,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','65',1543,'7','1',154424.91,158290.19,3865.28,637771.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','65',1544,'8','1',94285.83,94285.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','65',1545,'9','1',128051.40,128103.11,51.71,8532.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','65',1546,'10','1',64759.86,64759.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','65',1547,'11','1',186352.56,186352.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','65',1548,'12','1',70627.83,70627.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','65',1549,'13','1',95555.56,100339.03,4783.47,789272.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','65',1550,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','65',1551,'15','1',104083.10,108587.29,4504.19,743191.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','65',1552,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','65',1553,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','65',1554,'18','1',127734.39,132482.75,4748.36,783479.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','65',1555,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','65',1556,'20','1',125256.77,129081.00,3824.23,630997.95,0.00,0.00,0.00,0.00,0.00),('1','248','4','65',1557,'21','2',95834.22,95866.72,32.50,23400.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','65',1558,'22','2',53723.41,53723.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','65',1559,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','65',1560,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','66',1561,'1','1',208690.56,212802.51,4111.95,678471.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','66',1562,'2','1',75091.56,75091.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','66',1563,'3','1',151507.46,154620.46,3113.00,513645.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','66',1564,'4','1',82248.91,85098.08,2849.17,470113.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','66',1565,'5','1',199128.76,203119.75,3990.99,658513.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','66',1566,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','66',1567,'7','1',158290.19,163484.44,5194.25,857051.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','66',1568,'8','1',94285.83,94285.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','66',1569,'9','1',128103.11,130610.67,2507.56,413747.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','66',1570,'10','1',64759.86,67620.73,2860.87,472043.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','66',1571,'11','1',186352.56,191085.11,4732.55,780870.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','66',1572,'12','1',70627.83,70627.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','66',1573,'13','1',100339.03,100915.25,576.22,95076.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','66',1574,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','66',1575,'15','1',108587.29,109256.00,668.71,110337.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','66',1576,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','66',1577,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','66',1578,'18','1',132482.75,133201.13,718.38,118532.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','66',1579,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','66',1580,'20','1',129081.00,129748.07,667.07,110066.55,0.00,0.00,0.00,0.00,0.00),('1','248','4','66',1581,'21','2',95866.72,97215.90,1349.18,971409.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','66',1582,'22','2',53723.41,54505.38,781.97,563018.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','66',1583,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','66',1584,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','67',1585,'1','1',212802.51,216044.61,3242.10,534946.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','67',1586,'2','1',75091.56,78598.91,3507.35,578712.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','67',1587,'3','1',154620.46,157772.33,3151.87,520058.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','67',1588,'4','1',85098.08,88521.81,3423.73,564915.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','67',1589,'5','1',203119.75,208546.00,5426.25,895331.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','67',1590,'6','1',569.27,569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','67',1591,'7','1',163484.44,165177.09,1692.65,279287.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','67',1592,'8','1',94285.83,95531.60,1245.77,205552.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','67',1593,'9','1',130610.67,131544.96,934.29,154157.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','67',1594,'10','1',67620.73,67620.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','67',1595,'11','1',191085.11,194158.12,3073.01,507046.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','67',1596,'12','1',70627.83,70627.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','67',1597,'13','1',100915.25,100915.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','67',1598,'14','1',51036.78,51036.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','67',1599,'15','1',109256.00,109256.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','67',1600,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','67',1601,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','67',1602,'18','1',133201.13,133201.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','67',1603,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','67',1604,'20','1',129748.07,129748.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','67',1605,'21','2',97215.90,98117.23,901.33,648957.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','67',1606,'22','2',54505.38,55906.20,1400.82,1008590.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','67',1607,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','67',1608,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','68',1609,'1','1',216044.61,221225.29,5180.68,854812.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','68',1610,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','68',1611,'3','1',157772.33,157772.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','68',1612,'4','1',88521.81,91933.49,3411.68,562927.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','68',1613,'5','1',208546.00,212713.04,4167.04,687561.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','68',1614,'6','1',569.27,716.68,147.41,24322.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','68',1615,'7','1',165177.09,169013.36,3836.27,632984.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','68',1616,'8','1',95531.60,95531.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','68',1617,'9','1',131544.96,135247.33,3702.37,610891.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','68',1618,'10','1',67620.73,67620.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','68',1619,'11','1',194158.12,198169.17,4011.05,661823.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','68',1620,'12','1',70627.83,70627.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','68',1621,'13','1',100915.25,105484.48,4569.23,753922.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','68',1622,'14','1',51036.78,51309.14,272.36,44939.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','68',1623,'15','1',109256.00,113954.68,4698.68,775282.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','68',1624,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','68',1625,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','68',1626,'18','1',133201.13,133201.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','68',1627,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','68',1628,'20','1',129748.07,129748.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','68',1629,'21','2',98117.23,98127.79,10.56,7603.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','68',1630,'22','2',55906.20,56374.38,468.18,337089.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','68',1631,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','68',1632,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','69',1633,'1','1',221225.29,222960.04,1734.75,286233.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','69',1634,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','69',1635,'3','1',157772.33,157772.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','69',1636,'4','1',91933.49,91933.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','69',1637,'5','1',212713.04,212713.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','69',1638,'6','1',716.68,716.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','69',1639,'7','1',169013.36,169013.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','69',1640,'8','1',95531.60,95531.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','69',1641,'9','1',135247.33,135247.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','69',1642,'10','1',67620.73,67620.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','69',1643,'11','1',198169.17,198169.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','69',1644,'12','1',70627.83,70627.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','69',1645,'13','1',105484.48,109473.05,3988.57,658114.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','69',1646,'14','1',51309.14,51309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','69',1647,'15','1',113954.68,118297.98,4343.30,716644.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','69',1648,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','69',1649,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','69',1650,'18','1',133201.13,137522.84,4321.71,713082.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','69',1651,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','69',1652,'20','1',129748.07,132890.09,3142.02,518433.30,0.00,0.00,0.00,0.00,0.00),('1','248','4','69',1653,'21','2',98127.79,98668.91,541.12,389606.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','69',1654,'22','2',56374.38,56923.80,549.42,395582.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','69',1655,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','69',1656,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','70',1657,'1','1',222960.04,228771.30,5762.78,950858.70,0.00,0.00,48.48,0.00,0.00),('1','248','1','70',1658,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','70',1659,'3','1',157772.33,162652.03,4879.70,805150.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','70',1660,'4','1',91933.49,93736.07,1802.58,297425.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','70',1661,'5','1',212713.04,218142.35,5408.94,892475.10,0.00,0.00,20.37,0.00,0.00),('1','248','1','70',1662,'6','1',716.68,716.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','70',1663,'7','1',169013.36,174702.45,5689.09,938699.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','70',1664,'8','1',95531.60,95531.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','70',1665,'9','1',135247.33,137509.01,2261.68,373177.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','70',1666,'10','1',67620.73,69069.00,1448.27,238964.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','70',1667,'11','1',198169.17,203323.72,5154.55,850500.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','70',1668,'12','1',70627.83,70627.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','70',1669,'13','1',109473.05,109473.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','70',1670,'14','1',51309.14,51631.13,321.99,53128.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','70',1671,'15','1',118297.98,118805.49,507.51,83739.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','70',1672,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','70',1673,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','70',1674,'18','1',137522.84,139691.40,2168.56,357812.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','70',1675,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','70',1676,'20','1',132890.09,134299.10,1409.01,232486.65,0.00,0.00,0.00,0.00,0.00),('1','248','4','70',1677,'21','2',98668.91,100197.73,1528.82,1100750.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','70',1678,'22','2',56923.80,58522.31,1598.51,1150927.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','70',1679,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','70',1680,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','71',1681,'1','1',228771.30,234712.37,5941.07,980276.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','71',1682,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','71',1683,'3','1',162652.03,168882.59,6230.56,1028042.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','71',1684,'4','1',93736.07,94411.93,675.86,111516.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','71',1685,'5','1',218142.35,224494.53,6352.18,1048109.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','71',1686,'6','1',716.68,1586.61,869.93,143538.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','71',1687,'7','1',174702.45,174702.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','71',1688,'8','1',95531.60,95531.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','71',1689,'9','1',137509.01,137509.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','71',1690,'10','1',69069.00,69069.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','71',1691,'11','1',203323.72,206677.49,3353.77,553372.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','71',1692,'12','1',70627.83,72502.00,1874.17,309238.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','71',1693,'13','1',109473.05,109473.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','71',1694,'14','1',51631.13,51631.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','71',1695,'15','1',118805.49,118805.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','71',1696,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','71',1697,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','71',1698,'18','1',139691.40,139691.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','71',1699,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','71',1700,'20','1',134299.10,134299.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','71',1701,'21','2',100197.73,101229.80,1032.07,743090.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','71',1702,'22','2',58522.31,59719.04,1196.73,861645.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','71',1703,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','71',1704,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','72',1705,'1','1',234712.37,239862.66,5150.29,849797.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','72',1706,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','72',1707,'3','1',168882.59,173063.34,4180.75,689823.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','72',1708,'4','1',94411.93,94411.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','72',1709,'5','1',224494.53,229537.86,5043.33,832149.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','72',1710,'6','1',1586.61,1606.88,20.27,3344.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','72',1711,'7','1',174702.45,174702.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','72',1712,'8','1',95531.60,99081.79,3550.19,585781.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','72',1713,'9','1',137509.01,142829.75,5320.74,877922.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','72',1714,'10','1',69069.00,69069.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','72',1715,'11','1',206677.49,208509.41,1831.92,302266.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','72',1716,'12','1',72502.00,76754.14,4252.14,701603.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','72',1717,'13','1',109473.05,109473.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','72',1718,'14','1',51631.13,51631.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','72',1719,'15','1',118805.49,118805.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','72',1720,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','72',1721,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','72',1722,'18','1',139691.40,139691.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','72',1723,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','72',1724,'20','1',134299.10,134299.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','72',1725,'21','2',101229.80,102201.18,971.38,699393.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','72',1726,'22','2',59719.04,61040.92,1321.88,951753.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','72',1727,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','72',1728,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','73',1729,'1','1',239862.66,247047.14,7184.48,1185439.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','73',1730,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','73',1731,'3','1',173063.34,173063.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','73',1732,'4','1',94411.93,94411.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','73',1733,'5','1',229537.86,236667.37,7129.51,1176369.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','73',1734,'6','1',1606.88,1809.52,202.64,33435.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','73',1735,'7','1',174702.45,174702.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','73',1736,'8','1',99081.79,99081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','73',1737,'9','1',142829.75,142829.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','73',1738,'10','1',69069.00,69069.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','73',1739,'11','1',208509.41,208509.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','73',1740,'12','1',76754.14,76754.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','73',1741,'13','1',109473.05,109473.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','73',1742,'14','1',51631.13,51631.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','73',1743,'15','1',118805.49,118805.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','73',1744,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','73',1745,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','73',1746,'18','1',139691.40,139691.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','73',1747,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','73',1748,'20','1',134299.10,134299.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','73',1749,'21','2',102201.18,102576.22,375.04,270028.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','73',1750,'22','2',61040.92,62582.13,1541.21,1109671.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','73',1751,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','73',1752,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','74',1753,'1','1',247047.14,250288.92,3241.78,534893.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','74',1754,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','74',1755,'3','1',173063.34,175985.27,2921.93,482118.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','74',1756,'4','1',94411.93,94411.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','74',1757,'5','1',236667.37,240848.11,4180.74,689822.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','74',1758,'6','1',1809.52,1809.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','74',1759,'7','1',174702.45,178598.27,3895.82,642810.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','74',1760,'8','1',99081.79,99081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','74',1761,'9','1',142829.75,145893.64,3063.89,505541.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','74',1762,'10','1',69069.00,71324.99,2255.99,372238.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','74',1763,'11','1',208509.41,212494.10,3984.69,657473.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','74',1764,'12','1',76754.14,79527.63,2773.49,457625.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','74',1765,'13','1',109473.05,109473.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','74',1766,'14','1',51631.13,51631.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','74',1767,'15','1',118805.49,118805.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','74',1768,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','74',1769,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','74',1770,'18','1',139691.40,139691.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','74',1771,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','74',1772,'20','1',134299.10,134299.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','74',1773,'21','2',102576.22,102576.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','74',1774,'22','2',62582.13,62582.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','74',1775,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','74',1776,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','75',1777,'1','1',250288.92,255224.64,4935.72,814393.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','75',1778,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','75',1779,'3','1',175985.27,179919.56,3934.29,649157.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','75',1780,'4','1',94411.93,98372.34,3960.41,653467.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','75',1781,'5','1',240848.11,242629.17,1781.06,293874.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','75',1782,'6','1',1809.52,5649.43,3794.91,626160.15,0.00,0.00,45.00,0.00,0.00),('1','248','2','75',1783,'7','1',178598.27,181662.92,3064.65,505667.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','75',1784,'8','1',99081.79,101636.66,2554.87,421553.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','75',1785,'9','1',145893.64,149336.24,3442.60,568029.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','75',1786,'10','1',71324.99,71324.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','75',1787,'11','1',212494.10,214910.22,2416.12,398659.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','75',1788,'12','1',79527.63,81724.66,2197.03,362509.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','75',1789,'13','1',109473.05,109473.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','75',1790,'14','1',51631.13,51631.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','75',1791,'15','1',118805.49,118805.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','75',1792,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','75',1793,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','75',1794,'18','1',139691.40,139691.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','75',1795,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','75',1796,'20','1',134299.10,134299.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','75',1797,'21','2',102576.22,102576.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','75',1798,'22','2',62582.13,62582.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','75',1799,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','75',1800,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','76',1801,'1','1',255224.64,255224.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','76',1802,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','76',1803,'3','1',179919.56,179919.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','76',1804,'4','1',98372.34,98372.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','76',1805,'5','1',242629.17,242629.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','76',1806,'6','1',5649.43,5649.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','76',1807,'7','1',181662.92,181662.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','76',1808,'8','1',101636.66,101636.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','76',1809,'9','1',149336.24,149336.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','76',1810,'10','1',71324.99,71324.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','76',1811,'11','1',214910.22,214910.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','76',1812,'12','1',81724.66,81724.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','76',1813,'13','1',109473.05,109473.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','76',1814,'14','1',51631.13,51631.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','76',1815,'15','1',118805.49,118805.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','76',1816,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','76',1817,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','76',1818,'18','1',139691.40,139691.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','76',1819,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','76',1820,'20','1',134299.10,134299.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','76',1821,'21','2',102576.22,102576.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','76',1822,'22','2',62582.13,62582.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','76',1823,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','76',1824,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','77',1825,'1','1',255224.64,260509.57,5284.93,872013.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','77',1826,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','77',1827,'3','1',179919.56,182940.31,3020.75,498423.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','77',1828,'4','1',98372.34,98372.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','77',1829,'5','1',242629.17,245847.69,3218.52,531055.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','77',1830,'6','1',5649.43,5649.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','77',1831,'7','1',181662.92,181666.56,3.64,600.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','77',1832,'8','1',101636.66,106298.28,4661.62,769167.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','77',1833,'9','1',149336.24,152792.82,3456.58,570335.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','77',1834,'10','1',71324.99,71324.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','77',1835,'11','1',214910.22,219040.51,4130.29,681497.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','77',1836,'12','1',81724.66,81724.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','77',1837,'13','1',109473.05,112836.89,3363.84,555033.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','77',1838,'14','1',51631.13,51631.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','77',1839,'15','1',118805.49,121662.62,2857.13,471426.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','77',1840,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','77',1841,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','77',1842,'18','1',139691.40,142651.73,2960.33,488454.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','77',1843,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','77',1844,'20','1',134299.10,137923.24,3624.14,597983.10,0.00,0.00,0.00,0.00,0.00),('1','248','4','77',1845,'21','2',102576.22,103042.36,466.14,335620.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','77',1846,'22','2',62582.13,63281.56,699.43,503589.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','77',1847,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','77',1848,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','78',1849,'1','1',260509.57,265775.62,5266.05,868898.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','78',1850,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','78',1851,'3','1',182940.31,187112.27,4171.96,688373.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','78',1852,'4','1',98372.34,98372.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','78',1853,'5','1',245847.69,250614.66,4766.97,786550.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','78',1854,'6','1',5649.43,5649.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','78',1855,'7','1',181666.56,185288.97,3622.41,597697.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','78',1856,'8','1',106298.28,106298.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','78',1857,'9','1',152792.82,153158.12,365.30,60274.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','78',1858,'10','1',71324.99,71324.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','78',1859,'11','1',219040.51,222484.01,3443.50,568177.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','78',1860,'12','1',81724.66,81724.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','78',1861,'13','1',112836.89,114718.14,1881.25,310406.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','78',1862,'14','1',51631.13,51631.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','78',1863,'15','1',121662.62,123293.70,1631.08,269128.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','78',1864,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','78',1865,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','78',1866,'18','1',142651.73,148121.95,5470.22,902586.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','78',1867,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','78',1868,'20','1',137923.24,144144.67,6221.43,1026535.95,0.00,0.00,0.00,0.00,0.00),('1','248','4','78',1869,'21','2',103042.36,104002.29,959.93,691149.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','78',1870,'22','2',63281.56,64251.33,969.77,698234.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','78',1871,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','78',1872,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','79',1873,'1','1',265775.62,272519.22,6743.60,1112694.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','79',1874,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','79',1875,'3','1',187112.27,191453.69,4341.42,716334.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','79',1876,'4','1',98372.34,98372.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','79',1877,'5','1',250614.66,255639.07,5024.41,829027.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','79',1878,'6','1',5649.43,5649.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','79',1879,'7','1',185288.97,189849.02,4560.05,752408.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','79',1880,'8','1',106298.28,106298.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','79',1881,'9','1',153158.12,155075.46,1917.34,316361.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','79',1882,'10','1',71324.99,71963.64,638.65,105377.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','79',1883,'11','1',222484.01,226556.43,4072.42,671949.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','79',1884,'12','1',81724.66,81724.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','79',1885,'13','1',114718.14,114718.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','79',1886,'14','1',51631.13,53323.27,1692.14,279203.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','79',1887,'15','1',123293.70,125451.46,2157.76,356030.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','79',1888,'16','1',38015.37,38015.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','79',1889,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','79',1890,'18','1',148121.95,149654.88,1532.93,252933.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','79',1891,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','79',1892,'20','1',144144.67,145746.74,1602.07,264341.55,0.00,0.00,0.00,0.00,0.00),('1','248','4','79',1893,'21','2',104002.29,105520.43,1518.14,1093060.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','79',1894,'22','2',64251.33,67009.12,2757.79,1985608.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','79',1895,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','79',1896,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','80',1897,'1','1',272519.22,274404.54,1885.32,311077.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','80',1898,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','80',1899,'3','1',191453.69,191453.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','80',1900,'4','1',98372.34,98372.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','80',1901,'5','1',255639.07,257153.72,1514.65,249917.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','80',1902,'6','1',5649.43,5649.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','80',1903,'7','1',189849.02,194547.60,4698.58,775265.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','80',1904,'8','1',106298.28,106878.35,580.07,95711.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','80',1905,'9','1',155075.46,155646.14,570.68,94162.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','80',1906,'10','1',71963.64,72838.05,874.41,144277.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','80',1907,'11','1',226556.43,231139.16,4582.73,756150.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','80',1908,'12','1',81724.66,84251.49,2526.83,416926.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','80',1909,'13','1',114718.14,117141.76,2423.62,399897.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','80',1910,'14','1',53323.27,55700.34,2377.07,392216.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','80',1911,'15','1',125451.46,128395.68,2944.22,485796.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','80',1912,'16','1',38015.37,38867.72,852.35,140637.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','80',1913,'17','1',23923.78,23923.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','80',1914,'18','1',149654.88,152043.38,2388.50,394102.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','80',1915,'19','1',30472.74,30472.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','80',1916,'20','1',145746.74,148822.36,3075.62,507477.30,0.00,0.00,0.00,0.00,0.00),('1','248','4','80',1917,'21','2',105520.43,106629.10,1108.67,798242.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','80',1918,'22','2',67009.12,68399.68,1390.56,1001203.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','80',1919,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','80',1920,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','81',1921,'1','1',274404.54,278180.66,3776.12,623059.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','81',1922,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','81',1923,'3','1',191453.69,197042.16,5588.47,922097.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','81',1924,'4','1',98372.34,98372.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','81',1925,'5','1',257153.72,261434.53,4280.81,706333.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','81',1926,'6','1',5649.43,5649.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','81',1927,'7','1',194547.60,194547.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','81',1928,'8','1',106878.35,112169.69,5291.34,873071.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','81',1929,'9','1',155646.14,160082.23,4436.09,731954.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','81',1930,'10','1',72838.05,72893.97,55.92,9226.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','81',1931,'11','1',231139.16,231139.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','81',1932,'12','1',84251.49,87988.33,3736.84,616578.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','81',1933,'13','1',117141.76,117352.50,210.74,34772.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','81',1934,'14','1',55700.34,55700.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','81',1935,'15','1',128395.68,128395.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','81',1936,'16','1',38867.72,42599.82,3732.10,615796.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','81',1937,'17','1',23923.78,24035.68,111.90,18463.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','81',1938,'18','1',152043.38,156896.77,4853.39,800809.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','81',1939,'19','1',30472.74,30538.44,65.70,10840.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','81',1940,'20','1',148822.36,152032.33,3209.97,529645.05,0.00,0.00,0.00,0.00,0.00),('1','248','4','81',1941,'21','2',106629.10,107047.86,418.76,301507.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','81',1942,'22','2',68399.68,69675.40,1275.72,918518.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','81',1943,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','81',1944,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','82',1945,'1','1',278180.66,284150.96,5970.30,985099.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','82',1946,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','82',1947,'3','1',197042.16,199898.12,2855.96,471233.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','82',1948,'4','1',98372.34,98372.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','82',1949,'5','1',261434.53,266195.83,4761.30,785614.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','82',1950,'6','1',5649.43,5649.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','82',1951,'7','1',194547.60,199554.78,5007.18,826184.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','82',1952,'8','1',112169.69,114895.98,2726.29,449837.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','82',1953,'9','1',160082.23,163557.79,3475.56,573467.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','82',1954,'10','1',72893.97,72893.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','82',1955,'11','1',231139.16,237137.93,5998.77,989797.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','82',1956,'12','1',87988.33,87988.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','82',1957,'13','1',117352.50,120146.90,2794.40,461076.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','82',1958,'14','1',55700.34,55700.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','82',1959,'15','1',128395.68,128395.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','82',1960,'16','1',42599.82,42599.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','82',1961,'17','1',24035.68,24035.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','82',1962,'18','1',156896.77,159654.11,2757.34,454961.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','82',1963,'19','1',30538.44,30538.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','82',1964,'20','1',152032.33,154131.56,2099.23,346372.95,0.00,0.00,0.00,0.00,0.00),('1','248','4','82',1965,'21','2',107047.86,107547.38,499.52,359654.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','82',1966,'22','2',69675.40,72117.19,2441.79,1758088.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','82',1967,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','82',1968,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','83',1969,'1','1',284150.96,289906.34,5755.38,949637.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','83',1970,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','83',1971,'3','1',199898.12,203696.49,3798.37,626731.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','83',1972,'4','1',98372.34,101949.41,3577.07,590216.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','83',1973,'5','1',266195.83,271083.82,4887.99,806518.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','83',1974,'6','1',5649.43,7601.34,1951.91,322065.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','83',1975,'7','1',199554.78,201854.70,2299.92,379486.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','83',1976,'8','1',114895.98,115676.99,781.01,128866.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','83',1977,'9','1',163557.79,165639.70,2081.91,343515.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','83',1978,'10','1',72893.97,73895.88,1001.91,165315.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','83',1979,'11','1',237137.93,239838.32,2700.39,445564.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','83',1980,'12','1',87988.33,88437.14,448.81,74053.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','83',1981,'13','1',120146.90,120146.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','83',1982,'14','1',55700.34,55700.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','83',1983,'15','1',128395.68,128395.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','83',1984,'16','1',42599.82,42599.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','83',1985,'17','1',24035.68,24035.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','83',1986,'18','1',159654.11,159654.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','83',1987,'19','1',30538.44,30538.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','83',1988,'20','1',154131.56,154131.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','83',1989,'21','2',107547.38,108551.55,1004.17,723002.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','83',1990,'22','2',72117.19,73500.64,1383.45,996084.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','83',1991,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','83',1992,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','84',1993,'1','1',289906.34,292849.58,2943.24,485634.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','84',1994,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','84',1995,'3','1',203696.49,206996.16,3299.67,544445.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','84',1996,'4','1',101949.41,101949.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','84',1997,'5','1',271083.82,274525.54,3441.72,567883.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','84',1998,'6','1',7601.34,7601.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','84',1999,'7','1',201854.70,201854.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','84',2000,'8','1',115676.99,115676.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','84',2001,'9','1',165639.70,165639.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','84',2002,'10','1',73895.88,73895.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','84',2003,'11','1',239838.32,239838.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','84',2004,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','84',2005,'13','1',120146.90,123610.63,3463.73,571515.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','84',2006,'14','1',55700.34,59552.90,3852.56,635672.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','84',2007,'15','1',128395.68,132261.74,3866.06,637899.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','84',2008,'16','1',42599.82,46880.78,4280.96,706358.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','84',2009,'17','1',24035.68,25613.06,1577.38,260267.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','84',2010,'18','1',159654.11,164496.89,4842.78,799058.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','84',2011,'19','1',30538.44,33779.54,3241.10,534781.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','84',2012,'20','1',154131.56,156985.42,2853.86,470886.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','84',2013,'21','2',108551.55,108707.92,156.37,112586.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','84',2014,'22','2',73500.64,73823.35,322.71,232351.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','84',2015,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','84',2016,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','85',2017,'1','1',292849.58,298279.35,5429.77,895912.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','85',2018,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','85',2019,'3','1',206996.16,208708.84,1712.68,282592.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','85',2020,'4','1',101949.41,101949.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','85',2021,'5','1',274525.54,279681.72,5156.18,850769.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','85',2022,'6','1',7601.34,8496.91,895.57,147769.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','85',2023,'7','1',201854.70,207468.25,5613.55,926235.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','85',2024,'8','1',115676.99,116964.10,1287.11,212373.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','85',2025,'9','1',165639.70,167698.44,2058.74,339692.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','85',2026,'10','1',73895.88,73895.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','85',2027,'11','1',239838.32,245046.25,5207.93,859308.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','85',2028,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','85',2029,'13','1',123610.63,126625.58,3014.95,497466.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','85',2030,'14','1',59552.90,59552.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','85',2031,'15','1',132261.74,135269.67,3007.93,496308.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','85',2032,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','85',2033,'17','1',25613.06,25613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','85',2034,'18','1',164496.89,167470.07,2973.18,490574.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','85',2035,'19','1',33779.54,33779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','85',2036,'20','1',156985.42,159928.68,2943.26,485637.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','85',2037,'21','2',108707.92,108707.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','85',2038,'22','2',73823.35,73823.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','85',2039,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','85',2040,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','86',2041,'1','1',298279.35,303207.03,4927.68,813067.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','86',2042,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','86',2043,'3','1',208708.84,212742.60,4033.76,665570.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','86',2044,'4','1',101949.41,101949.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','86',2045,'5','1',279681.72,285185.73,5454.01,899911.65,0.00,0.00,50.00,0.00,0.00),('1','248','1','86',2046,'6','1',8496.91,10721.73,2224.82,367095.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','86',2047,'7','1',207468.25,207468.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','86',2048,'8','1',116964.10,116964.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','86',2049,'9','1',167698.44,167698.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','86',2050,'10','1',73895.88,73895.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','86',2051,'11','1',245046.25,245777.37,691.34,114071.10,0.00,0.00,39.78,0.00,0.00),('1','248','2','86',2052,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','86',2053,'13','1',126625.58,126625.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','86',2054,'14','1',59552.90,59552.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','86',2055,'15','1',135269.67,135269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','86',2056,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','86',2057,'17','1',25613.06,25613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','86',2058,'18','1',167470.07,167470.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','86',2059,'19','1',33779.54,33779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','86',2060,'20','1',159928.68,159928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','86',2061,'21','2',108707.92,108707.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','86',2062,'22','2',73823.35,73823.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','86',2063,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','86',2064,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','87',2065,'1','1',303207.03,309533.37,6326.34,1043846.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','87',2066,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','87',2067,'3','1',212742.60,218877.07,6134.47,1012187.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','87',2068,'4','1',101949.41,101949.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','87',2069,'5','1',285185.73,291882.18,6696.45,1104914.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','87',2070,'6','1',10721.73,10721.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','87',2071,'7','1',207468.25,211579.25,4111.00,678315.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','87',2072,'8','1',116964.10,120748.64,3784.54,624449.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','87',2073,'9','1',167698.44,171852.65,4154.21,685444.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','87',2074,'10','1',73895.88,73895.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','87',2075,'11','1',245777.37,250649.92,4872.55,803970.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','87',2076,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','87',2077,'13','1',126625.58,126625.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','87',2078,'14','1',59552.90,59552.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','87',2079,'15','1',135269.67,135269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','87',2080,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','87',2081,'17','1',25613.06,25613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','87',2082,'18','1',167470.07,167470.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','87',2083,'19','1',33779.54,33779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','87',2084,'20','1',159928.68,159928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','87',2085,'21','2',108707.92,108707.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','87',2086,'22','2',73823.35,73823.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','87',2087,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','87',2088,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','88',2089,'1','1',309533.37,313267.18,3733.81,616078.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','88',2090,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','88',2091,'3','1',218877.07,222376.61,3499.54,577424.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','88',2092,'4','1',101949.41,103925.73,1976.32,326092.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','88',2093,'5','1',291882.18,296186.21,4304.03,710164.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','88',2094,'6','1',10721.73,10721.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','88',2095,'7','1',211579.25,211579.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','88',2096,'8','1',120748.64,120748.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','88',2097,'9','1',171852.65,171852.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','88',2098,'10','1',73895.88,73895.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','88',2099,'11','1',250649.92,250649.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','88',2100,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','88',2101,'13','1',126625.58,126625.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','88',2102,'14','1',59552.90,59552.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','88',2103,'15','1',135269.67,135269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','88',2104,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','88',2105,'17','1',25613.06,25613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','88',2106,'18','1',167470.07,167470.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','88',2107,'19','1',33779.54,33779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','88',2108,'20','1',159928.68,159928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','88',2109,'21','2',108707.92,108707.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','88',2110,'22','2',73823.35,73823.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','88',2111,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','88',2112,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','89',2113,'1','1',313267.18,319646.85,6379.67,1052645.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','89',2114,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','89',2115,'3','1',222376.61,227532.81,5156.20,850773.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','89',2116,'4','1',103925.73,103968.15,42.42,6999.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','89',2117,'5','1',296186.21,302955.03,6768.82,1116855.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','89',2118,'6','1',10721.73,10721.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','89',2119,'7','1',211579.25,217147.55,5568.30,918769.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','89',2120,'8','1',120748.64,120748.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','89',2121,'9','1',171852.65,175572.66,3720.01,613801.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','89',2122,'10','1',73895.88,73895.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','89',2123,'11','1',250649.92,255897.06,5247.14,865778.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','89',2124,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','89',2125,'13','1',126625.58,126625.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','89',2126,'14','1',59552.90,59552.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','89',2127,'15','1',135269.67,135269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','89',2128,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','89',2129,'17','1',25613.06,25613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','89',2130,'18','1',167470.07,167470.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','89',2131,'19','1',33779.54,33779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','89',2132,'20','1',159928.68,159928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','89',2133,'21','2',108707.92,108707.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','89',2134,'22','2',73823.35,73823.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','89',2135,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','89',2136,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','90',2137,'1','1',319646.85,325066.42,5419.57,894229.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','90',2138,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','90',2139,'3','1',227532.81,232169.29,4636.48,765019.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','90',2140,'4','1',103968.15,106391.61,2423.46,399870.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','90',2141,'5','1',302955.03,307209.52,4254.49,701990.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','90',2142,'6','1',10721.73,10721.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','90',2143,'7','1',217147.55,217147.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','90',2144,'8','1',120748.64,120748.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','90',2145,'9','1',175572.66,175572.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','90',2146,'10','1',73895.88,73895.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','90',2147,'11','1',255897.06,255897.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','90',2148,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','90',2149,'13','1',126625.58,126625.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','90',2150,'14','1',59552.90,59552.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','90',2151,'15','1',135269.67,135269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','90',2152,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','90',2153,'17','1',25613.06,25613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','90',2154,'18','1',167470.07,167470.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','90',2155,'19','1',33779.54,33779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','90',2156,'20','1',159928.68,159928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','90',2157,'21','2',108707.92,108707.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','90',2158,'22','2',73823.35,73823.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','90',2159,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','90',2160,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','91',2161,'1','1',325066.42,331638.43,6572.01,1084381.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','91',2162,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','91',2163,'3','1',232169.29,236578.34,4409.05,727493.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','91',2164,'4','1',106391.61,110353.81,3962.20,653763.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','91',2165,'5','1',307209.52,312152.67,4943.15,815619.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','91',2166,'6','1',10721.73,10721.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','91',2167,'7','1',217147.55,222104.73,4957.18,817934.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','91',2168,'8','1',120748.64,120748.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','91',2169,'9','1',175572.66,180293.32,4720.66,778908.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','91',2170,'10','1',73895.88,74119.49,223.61,36895.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','91',2171,'11','1',255897.06,260768.96,4871.90,803863.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','91',2172,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','91',2173,'13','1',126625.58,126625.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','91',2174,'14','1',59552.90,59552.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','91',2175,'15','1',135269.67,135269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','91',2176,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','91',2177,'17','1',25613.06,25613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','91',2178,'18','1',167470.07,167470.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','91',2179,'19','1',33779.54,33779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','91',2180,'20','1',159928.68,159928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','91',2181,'21','2',108707.92,108707.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','91',2182,'22','2',73823.35,73823.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','91',2183,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','91',2184,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','92',2185,'1','1',331638.43,340806.14,9167.71,1512672.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','92',2186,'2','1',78598.91,78598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','92',2187,'3','1',236578.34,245247.59,8669.25,1430426.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','92',2188,'4','1',110353.81,110353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','92',2189,'5','1',312152.67,322248.27,10065.30,1660774.50,0.00,0.00,30.30,0.00,0.00),('1','248','1','92',2190,'6','1',10721.73,10721.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','92',2191,'7','1',222104.73,225773.90,3669.17,605413.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','92',2192,'8','1',120748.64,124136.31,3387.67,558965.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','92',2193,'9','1',180293.32,184896.80,4603.48,759574.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','92',2194,'10','1',74119.49,74119.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','92',2195,'11','1',260768.96,265939.63,5170.67,853160.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','92',2196,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','92',2197,'13','1',126625.58,126625.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','92',2198,'14','1',59552.90,59552.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','92',2199,'15','1',135269.67,135269.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','92',2200,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','92',2201,'17','1',25613.06,25613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','92',2202,'18','1',167470.07,167470.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','92',2203,'19','1',33779.54,33779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','92',2204,'20','1',159928.68,159928.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','92',2205,'21','2',108707.92,109866.36,1158.44,880414.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','92',2206,'22','2',73823.35,75058.68,1235.33,938850.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','92',2207,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','92',2208,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','93',2209,'1','1',340806.14,348382.76,7576.62,1250142.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','93',2210,'2','1',78598.91,78809.48,210.57,34744.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','93',2211,'3','1',245247.59,253101.57,7853.98,1295906.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','93',2212,'4','1',110353.81,110353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','93',2213,'5','1',322248.27,329918.76,7650.49,1262330.85,0.00,0.00,20.00,0.00,0.00),('1','248','1','93',2214,'6','1',10721.73,10899.83,178.10,29386.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','93',2215,'7','1',225773.90,225773.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','93',2216,'8','1',124136.31,124136.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','93',2217,'9','1',184896.80,187415.34,2518.54,415559.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','93',2218,'10','1',74119.49,74119.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','93',2219,'11','1',265939.63,265939.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','93',2220,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','93',2221,'13','1',126625.58,130316.82,3660.94,604055.10,0.00,0.00,30.30,0.00,0.00),('1','248','3','93',2222,'14','1',59552.90,59552.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','93',2223,'15','1',135269.67,139238.23,3968.56,654812.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','93',2224,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','93',2225,'17','1',25613.06,25613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','93',2226,'18','1',167470.07,171694.95,4224.88,697105.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','93',2227,'19','1',33779.54,33779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','93',2228,'20','1',159928.68,163957.44,4028.76,664745.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','93',2229,'21','2',109866.36,113338.59,3462.23,2631294.80,0.00,0.00,10.00,0.00,0.00),('1','248','4','93',2230,'22','2',75058.68,77686.02,2627.34,1996778.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','93',2231,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','93',2232,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','94',2233,'1','1',348382.76,354049.44,5666.68,935002.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','94',2234,'2','1',78809.48,78809.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','94',2235,'3','1',253101.57,256988.59,3887.02,641358.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','94',2236,'4','1',110353.81,110353.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','94',2237,'5','1',329918.76,334362.66,4443.90,733243.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','94',2238,'6','1',10899.83,10899.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','94',2239,'7','1',225773.90,230513.32,4739.42,782004.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','94',2240,'8','1',124136.31,124136.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','94',2241,'9','1',187415.34,192894.10,5478.76,903995.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','94',2242,'10','1',74119.49,74119.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','94',2243,'11','1',265939.63,269460.53,3520.90,580948.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','94',2244,'12','1',88437.14,88437.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','94',2245,'13','1',130316.82,134604.18,4287.36,707414.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','94',2246,'14','1',59552.90,59552.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','94',2247,'15','1',139238.23,143323.63,4085.40,674091.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','94',2248,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','94',2249,'17','1',25613.06,25613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','94',2250,'18','1',171694.95,175539.38,3844.43,634330.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','94',2251,'19','1',33779.54,33779.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','94',2252,'20','1',163957.44,168236.45,4279.01,706036.65,0.00,0.00,0.00,0.00,0.00),('1','248','4','94',2253,'21','2',113338.59,113757.36,418.77,318265.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','94',2254,'22','2',77686.02,78126.02,440.00,334400.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','94',2255,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','94',2256,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','95',2257,'1','1',354049.44,359055.36,5005.92,825976.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','95',2258,'2','1',78809.48,78809.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','95',2259,'3','1',256988.59,260695.94,3707.35,611712.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','95',2260,'4','1',110353.81,112265.05,1911.24,315354.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','95',2261,'5','1',334362.66,338818.86,4456.20,735273.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','95',2262,'6','1',10899.83,10899.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','95',2263,'7','1',230513.32,233804.77,3291.45,543089.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','95',2264,'8','1',124136.31,126360.56,2224.25,367001.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','95',2265,'9','1',192894.10,197505.09,4610.99,760813.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','95',2266,'10','1',74119.49,74119.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','95',2267,'11','1',269460.53,273049.46,3588.93,592173.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','95',2268,'12','1',88437.14,89901.78,1464.64,241665.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','95',2269,'13','1',134604.18,136650.85,2046.67,337700.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','95',2270,'14','1',59552.90,60979.55,1426.65,235397.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','95',2271,'15','1',143323.63,146520.77,3197.14,527528.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','95',2272,'16','1',46880.78,46880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','95',2273,'17','1',25613.06,25873.53,260.47,42977.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','95',2274,'18','1',175539.38,178573.55,3034.17,500638.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','95',2275,'19','1',33779.54,33826.99,47.45,7829.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','95',2276,'20','1',168236.45,170627.01,2390.56,394442.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','95',2277,'21','2',113757.36,115581.57,1824.21,1386399.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','95',2278,'22','2',78126.02,79187.73,1061.71,806899.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','95',2279,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','95',2280,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','96',2281,'1','1',359055.36,364256.25,5200.89,858146.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','96',2282,'2','1',78809.48,78809.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','96',2283,'3','1',260695.94,266565.42,5869.48,968464.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','96',2284,'4','1',112265.05,112265.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','96',2285,'5','1',338818.86,344964.39,6145.53,1014012.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','96',2286,'6','1',10899.83,10899.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','96',2287,'7','1',233804.77,237519.25,3714.48,612889.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','96',2288,'8','1',126360.56,126360.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','96',2289,'9','1',197505.09,202415.82,4895.73,807795.45,0.00,0.00,15.00,0.00,0.00),('1','248','2','96',2290,'10','1',74119.49,74119.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','96',2291,'11','1',273049.46,273049.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','96',2292,'12','1',89901.78,89901.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','96',2293,'13','1',136650.85,141603.45,4952.60,817179.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','96',2294,'14','1',60979.55,60979.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','96',2295,'15','1',146520.77,152399.43,5878.66,969978.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','96',2296,'16','1',46880.78,47228.74,347.96,57413.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','96',2297,'17','1',25873.53,25873.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','96',2298,'18','1',178573.55,182694.97,4121.42,680034.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','96',2299,'19','1',33826.99,33826.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','96',2300,'20','1',170627.01,176014.41,5387.40,888921.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','96',2301,'21','2',115581.57,116148.93,564.07,428693.20,0.00,0.00,3.29,0.00,0.00),('1','248','4','96',2302,'22','2',79187.73,80463.42,1275.69,969524.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','96',2303,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','96',2304,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','97',2305,'1','1',364256.25,364256.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','97',2306,'2','1',78809.48,78809.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','97',2307,'3','1',266565.42,266565.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','97',2308,'4','1',112265.05,112265.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','97',2309,'5','1',344964.39,344964.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','97',2310,'6','1',10899.83,10899.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','97',2311,'7','1',237519.25,237519.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','97',2312,'8','1',126360.56,126360.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','97',2313,'9','1',202415.82,202415.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','97',2314,'10','1',74119.49,74119.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','97',2315,'11','1',273049.46,273049.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','97',2316,'12','1',89901.78,89901.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','97',2317,'13','1',141603.45,141603.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','97',2318,'14','1',60979.55,60979.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','97',2319,'15','1',152399.43,152399.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','97',2320,'16','1',47228.74,47228.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','97',2321,'17','1',25873.53,25873.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','97',2322,'18','1',182694.97,182694.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','97',2323,'19','1',33826.99,33826.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','97',2324,'20','1',176014.41,176014.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','97',2325,'21','2',116148.93,116148.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','97',2326,'22','2',80463.42,80463.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','97',2327,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','97',2328,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','98',2329,'1','1',364256.25,369283.07,5026.82,829425.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','98',2330,'2','1',78809.48,78809.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','98',2331,'3','1',266565.42,271512.13,4946.71,816207.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','98',2332,'4','1',112265.05,112265.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','98',2333,'5','1',344964.39,351195.31,6230.92,1028101.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','98',2334,'6','1',10899.83,10899.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','98',2335,'7','1',237519.25,242080.07,4560.82,752535.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','98',2336,'8','1',126360.56,126360.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','98',2337,'9','1',202415.82,205787.21,3371.39,556279.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','98',2338,'10','1',74119.49,74119.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','98',2339,'11','1',273049.46,275974.62,2925.16,482651.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','98',2340,'12','1',89901.78,89901.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','98',2341,'13','1',141603.45,147347.04,5743.59,947692.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','98',2342,'14','1',60979.55,60979.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','98',2343,'15','1',152399.43,158341.49,5942.06,980439.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','98',2344,'16','1',47228.74,47228.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','98',2345,'17','1',25873.53,25873.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','98',2346,'18','1',182694.97,188230.07,5535.10,913291.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','98',2347,'19','1',33826.99,33826.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','98',2348,'20','1',176014.41,181098.72,5084.31,838911.15,0.00,0.00,0.00,0.00,0.00),('1','248','4','98',2349,'21','2',116148.93,118228.56,2079.63,1580518.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','98',2350,'22','2',80463.42,81049.45,586.03,445382.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','98',2351,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','98',2352,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','99',2353,'1','1',369283.07,374151.48,4868.41,803287.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','99',2354,'2','1',78809.48,81648.05,2838.57,468364.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','99',2355,'3','1',271512.13,276037.49,4525.36,746684.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','99',2356,'4','1',112265.05,115265.69,3000.64,495105.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','99',2357,'5','1',351195.31,356091.65,4896.34,807896.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','99',2358,'6','1',10899.83,14114.88,3215.05,530483.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','99',2359,'7','1',242080.07,245890.15,3810.08,628663.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','99',2360,'8','1',126360.56,130065.65,3705.09,611339.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','99',2361,'9','1',205787.21,209829.97,4042.76,667055.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','99',2362,'10','1',74119.49,75998.01,1878.52,309955.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','99',2363,'11','1',275974.62,279373.80,3399.18,560864.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','99',2364,'12','1',89901.78,90981.23,1079.45,178109.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','99',2365,'13','1',147347.04,149108.38,1761.34,290621.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','99',2366,'14','1',60979.55,60979.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','99',2367,'15','1',158341.49,160287.86,1946.37,321151.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','99',2368,'16','1',47228.74,47228.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','99',2369,'17','1',25873.53,25873.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','99',2370,'18','1',188230.07,189825.37,1595.30,263224.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','99',2371,'19','1',33826.99,33826.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','99',2372,'20','1',181098.72,182585.62,1486.90,245338.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','99',2373,'21','2',118228.56,118497.56,269.00,204440.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','99',2374,'22','2',81049.45,81736.46,687.01,522127.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','99',2375,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','99',2376,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','100',2377,'1','1',374151.48,378570.65,4419.17,729163.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','100',2378,'2','1',81648.05,82377.09,729.04,120291.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','100',2379,'3','1',276037.49,279885.78,3848.29,634967.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','100',2380,'4','1',115265.69,115894.13,628.44,103692.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','100',2381,'5','1',356091.65,359643.63,3551.98,586076.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','100',2382,'6','1',14114.88,14856.26,741.38,122327.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','100',2383,'7','1',245890.15,250119.67,4229.52,697870.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','100',2384,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','100',2385,'9','1',209829.97,213599.10,3769.13,621906.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','100',2386,'10','1',75998.01,79452.38,3454.37,569971.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','100',2387,'11','1',279373.80,283019.72,3645.92,601576.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','100',2388,'12','1',90981.23,92768.44,1787.21,294889.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','100',2389,'13','1',149108.38,154524.37,5415.99,893638.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','100',2390,'14','1',60979.55,62442.78,1463.23,241432.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','100',2391,'15','1',160287.86,165554.27,5266.41,868957.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','100',2392,'16','1',47228.74,47228.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','100',2393,'17','1',25873.53,27380.24,1506.71,248607.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','100',2394,'18','1',189825.37,194972.69,5147.32,849307.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','100',2395,'19','1',33826.99,33942.11,115.12,18994.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','100',2396,'20','1',182585.62,187376.19,4790.57,790444.05,0.00,0.00,0.00,0.00,0.00),('1','248','4','100',2397,'21','2',118497.56,120709.22,2211.66,1680861.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','100',2398,'22','2',81736.46,81743.70,7.24,5502.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','100',2399,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','100',2400,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','101',2401,'1','1',378570.65,378570.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','101',2402,'2','1',82377.09,82377.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','101',2403,'3','1',279885.78,279885.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','101',2404,'4','1',115894.13,115894.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','101',2405,'5','1',359643.63,359643.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','101',2406,'6','1',14856.26,14856.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','101',2407,'7','1',250119.67,251631.80,1512.13,249501.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','101',2408,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','101',2409,'9','1',213599.10,213599.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','101',2410,'10','1',79452.38,79569.87,117.49,19385.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','101',2411,'11','1',283019.72,284381.19,1361.47,224642.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','101',2412,'12','1',92768.44,92768.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','101',2413,'13','1',154524.37,157559.21,3034.84,500748.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','101',2414,'14','1',62442.78,63687.15,1244.37,205321.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','101',2415,'15','1',165554.27,168360.52,2806.25,463031.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','101',2416,'16','1',47228.74,48078.82,850.08,140263.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','101',2417,'17','1',27380.24,30403.47,3023.23,498832.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','101',2418,'18','1',194972.69,196093.25,1120.56,184892.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','101',2419,'19','1',33942.11,35115.07,1172.96,193538.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','101',2420,'20','1',187376.19,190326.90,2950.71,486867.15,0.00,0.00,0.00,0.00,0.00),('1','248','4','101',2421,'21','2',120709.22,121424.99,715.77,543985.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','101',2422,'22','2',81743.70,82870.28,1126.58,856200.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','101',2423,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','101',2424,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','102',2425,'1','1',378570.65,382013.46,3442.81,568063.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','102',2426,'2','1',82377.09,85139.53,2762.44,455802.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','102',2427,'3','1',279885.78,283663.54,3777.76,623330.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','102',2428,'4','1',115894.13,115894.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','102',2429,'5','1',359643.63,363304.97,3621.34,597521.10,0.00,0.00,40.00,0.00,0.00),('1','248','1','102',2430,'6','1',14856.26,17421.44,2565.18,423254.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','102',2431,'7','1',251631.80,255660.71,3980.43,656770.95,0.00,0.00,48.48,0.00,0.00),('1','248','2','102',2432,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','102',2433,'9','1',213599.10,216767.10,3168.00,522720.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','102',2434,'10','1',79569.87,82509.48,2879.01,475036.65,0.00,0.00,60.60,0.00,0.00),('1','248','2','102',2435,'11','1',284381.19,288193.76,3779.54,623624.10,0.00,0.00,33.03,0.00,0.00),('1','248','2','102',2436,'12','1',92768.44,92768.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','102',2437,'13','1',157559.21,157559.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','102',2438,'14','1',63687.15,63687.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','102',2439,'15','1',168360.52,168360.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','102',2440,'16','1',48078.82,48078.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','102',2441,'17','1',30403.47,30403.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','102',2442,'18','1',196093.25,196093.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','102',2443,'19','1',35115.07,35118.07,3.00,495.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','102',2444,'20','1',190326.90,190326.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','102',2445,'21','2',121424.99,123017.04,1592.05,1209958.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','102',2446,'22','2',82870.28,83326.98,456.70,347092.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','102',2447,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','102',2448,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','103',2449,'1','1',382013.46,387677.39,5663.93,934548.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','103',2450,'2','1',85139.53,87044.15,1904.62,314262.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','103',2451,'3','1',283663.54,289228.71,5565.17,918253.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','103',2452,'4','1',115894.13,118529.42,2635.29,434822.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','103',2453,'5','1',363304.97,369115.76,5810.79,958780.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','103',2454,'6','1',17421.44,19522.76,2101.32,346717.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','103',2455,'7','1',255660.71,258535.83,2875.12,474394.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','103',2456,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','103',2457,'9','1',216767.10,216767.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','103',2458,'10','1',82509.48,82738.50,229.02,37788.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','103',2459,'11','1',288193.76,291018.84,2825.08,466138.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','103',2460,'12','1',92768.44,92768.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','103',2461,'13','1',157559.21,157559.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','103',2462,'14','1',63687.15,63687.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','103',2463,'15','1',168360.52,168360.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','103',2464,'16','1',48078.82,48078.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','103',2465,'17','1',30403.47,30403.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','103',2466,'18','1',196093.25,196093.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','103',2467,'19','1',35118.07,35118.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','103',2468,'20','1',190326.90,190326.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','103',2469,'21','2',123017.04,123770.09,753.05,572318.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','103',2470,'22','2',83326.98,84094.09,767.11,583003.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','103',2471,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','103',2472,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','104',2473,'1','1',387677.39,387677.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','104',2474,'2','1',87044.15,87044.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','104',2475,'3','1',289228.71,289228.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','104',2476,'4','1',118529.42,118529.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','104',2477,'5','1',369115.76,369115.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','104',2478,'6','1',19522.76,19522.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','104',2479,'7','1',258535.83,258535.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','104',2480,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','104',2481,'9','1',216767.10,216767.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','104',2482,'10','1',82738.50,82738.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','104',2483,'11','1',291018.84,291018.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','104',2484,'12','1',92768.44,92768.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','104',2485,'13','1',157559.21,157559.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','104',2486,'14','1',63687.15,63687.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','104',2487,'15','1',168360.52,168360.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','104',2488,'16','1',48078.82,48078.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','104',2489,'17','1',30403.47,30403.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','104',2490,'18','1',196093.25,196093.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','104',2491,'19','1',35118.07,35118.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','104',2492,'20','1',190326.90,190326.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','104',2493,'21','2',123770.09,124380.49,610.40,463904.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','104',2494,'22','2',84094.09,84506.62,412.53,313522.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','104',2495,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','104',2496,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','105',2497,'1','1',387677.39,390552.10,2874.71,474327.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','105',2498,'2','1',87044.15,87044.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','105',2499,'3','1',289228.71,291394.17,2165.46,357300.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','105',2500,'4','1',118529.42,120996.36,2466.94,407045.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','105',2501,'5','1',369115.76,371940.61,2824.85,466100.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','105',2502,'6','1',19522.76,21834.00,2311.24,381354.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','105',2503,'7','1',258535.83,260491.20,1955.37,322636.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','105',2504,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','105',2505,'9','1',216767.10,218534.30,1767.20,291588.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','105',2506,'10','1',82738.50,84296.37,1557.87,257048.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','105',2507,'11','1',291018.84,291917.50,898.66,148278.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','105',2508,'12','1',92768.44,92768.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','105',2509,'13','1',157559.21,157559.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','105',2510,'14','1',63687.15,63687.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','105',2511,'15','1',168360.52,168360.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','105',2512,'16','1',48078.82,48078.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','105',2513,'17','1',30403.47,30403.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','105',2514,'18','1',196093.25,196093.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','105',2515,'19','1',35118.07,35118.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','105',2516,'20','1',190326.90,190326.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','105',2517,'21','2',124380.49,127088.78,2708.29,2058300.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','105',2518,'22','2',84506.62,84776.66,270.04,205230.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','105',2519,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','105',2520,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','106',2521,'1','1',390552.10,390552.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','106',2522,'2','1',87044.15,87044.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','106',2523,'3','1',291394.17,291394.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','106',2524,'4','1',120996.36,120996.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','106',2525,'5','1',371940.61,371940.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','106',2526,'6','1',21834.00,21834.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','106',2527,'7','1',260491.20,260491.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','106',2528,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','106',2529,'9','1',218534.30,218534.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','106',2530,'10','1',84296.37,84296.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','106',2531,'11','1',291917.50,291917.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','106',2532,'12','1',92768.44,92768.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','106',2533,'13','1',157559.21,157559.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','106',2534,'14','1',63687.15,63687.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','106',2535,'15','1',168360.52,168360.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','106',2536,'16','1',48078.82,48078.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','106',2537,'17','1',30403.47,30403.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','106',2538,'18','1',196093.25,196093.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','106',2539,'19','1',35118.07,35118.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','106',2540,'20','1',190326.90,190326.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','106',2541,'21','2',127088.78,127088.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','106',2542,'22','2',84776.66,84776.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','106',2543,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','106',2544,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','107',2545,'1','1',390552.10,394075.53,3523.43,581365.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','107',2546,'2','1',87044.15,92680.75,5636.60,930039.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','107',2547,'3','1',291394.17,297468.14,6073.97,1002205.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','107',2548,'4','1',120996.36,121745.20,748.84,123558.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','107',2549,'5','1',371940.61,377198.82,5258.21,867604.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','107',2550,'6','1',21834.00,23931.17,2097.17,346033.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','107',2551,'7','1',260491.20,263550.23,3059.03,504739.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','107',2552,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','107',2553,'9','1',218534.30,221222.83,2688.53,443607.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','107',2554,'10','1',84296.37,84296.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','107',2555,'11','1',291917.50,293536.61,1609.11,265503.15,0.00,0.00,10.00,0.00,0.00),('1','248','2','107',2556,'12','1',92768.44,92838.17,59.73,9855.45,0.00,0.00,10.00,0.00,0.00),('1','248','3','107',2557,'13','1',157559.21,161368.41,3799.20,626868.00,0.00,0.00,10.00,0.00,0.00),('1','248','3','107',2558,'14','1',63687.15,64338.43,641.28,105811.20,0.00,0.00,10.00,0.00,0.00),('1','248','3','107',2559,'15','1',168360.52,174245.93,5875.41,969442.65,0.00,0.00,10.00,0.00,0.00),('1','248','3','107',2560,'16','1',48078.82,48088.82,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','248','3','107',2561,'17','1',30403.47,30413.47,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','248','3','107',2562,'18','1',196093.25,201313.56,5210.31,859701.15,0.00,0.00,10.00,0.00,0.00),('1','248','3','107',2563,'19','1',35118.07,35128.07,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','107',2564,'20','1',190326.90,194095.99,3720.61,613900.65,0.00,0.00,48.48,0.00,0.00),('1','248','4','107',2565,'21','2',127088.78,127430.47,341.69,263101.30,0.00,0.00,0.00,0.00,0.00),('1','248','4','107',2566,'22','2',84776.66,85749.99,973.33,749464.10,0.00,0.00,0.00,0.00,0.00),('1','248','5','107',2567,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','107',2568,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','108',2569,'1','1',394075.53,394075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','108',2570,'2','1',92680.75,92680.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','108',2571,'3','1',297468.14,297468.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','108',2572,'4','1',121745.20,121745.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','108',2573,'5','1',377198.82,377198.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','108',2574,'6','1',23931.17,23931.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','108',2575,'7','1',263550.23,263550.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','108',2576,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','108',2577,'9','1',221222.83,221222.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','108',2578,'10','1',84296.37,84296.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','108',2579,'11','1',293536.61,293536.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','108',2580,'12','1',92838.17,92838.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','108',2581,'13','1',161368.41,161752.68,384.27,63404.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','108',2582,'14','1',64338.43,69832.88,5494.45,906584.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','108',2583,'15','1',174245.93,180983.67,6737.74,1111727.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','108',2584,'16','1',48088.82,48088.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','108',2585,'17','1',30413.47,30672.49,259.02,42738.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','108',2586,'18','1',201313.56,208063.48,6749.92,1113736.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','108',2587,'19','1',35128.07,35128.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','108',2588,'20','1',194095.99,200325.60,6229.61,1027885.65,0.00,0.00,0.00,0.00,0.00),('1','248','4','108',2589,'21','2',127430.47,127593.98,163.51,125902.70,0.00,0.00,0.00,0.00,0.00),('1','248','4','108',2590,'22','2',85749.99,86539.54,789.55,607953.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','108',2591,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','108',2592,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','109',2593,'1','1',394075.53,396460.62,2385.09,393539.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','109',2594,'2','1',92680.75,95008.20,2327.45,384029.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','109',2595,'3','1',297468.14,299700.29,2232.15,368304.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','109',2596,'4','1',121745.20,124321.35,2576.15,425064.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','109',2597,'5','1',377198.82,380134.00,2935.18,484304.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','109',2598,'6','1',23931.17,23931.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','109',2599,'7','1',263550.23,266594.27,3044.04,502266.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','109',2600,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','109',2601,'9','1',221222.83,224496.80,3273.97,540205.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','109',2602,'10','1',84296.37,84296.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','109',2603,'11','1',293536.61,296709.41,3172.80,523512.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','109',2604,'12','1',92838.17,92838.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','109',2605,'13','1',161752.68,161752.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','109',2606,'14','1',69832.88,69832.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','109',2607,'15','1',180983.67,180983.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','109',2608,'16','1',48088.82,48088.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','109',2609,'17','1',30672.49,30672.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','109',2610,'18','1',208063.48,208063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','109',2611,'19','1',35128.07,35128.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','109',2612,'20','1',200325.60,200325.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','109',2613,'21','2',127593.98,128879.35,1285.37,989734.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','109',2614,'22','2',86539.54,86790.79,251.25,193462.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','109',2615,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','109',2616,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','110',2617,'1','1',396460.62,402064.37,5603.75,924618.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','110',2618,'2','1',95008.20,95511.17,502.97,82990.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','110',2619,'3','1',299700.29,304240.68,4540.39,749164.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','110',2620,'4','1',124321.35,128783.40,4462.05,736238.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','110',2621,'5','1',380134.00,385253.93,5119.93,844788.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','110',2622,'6','1',23931.17,24880.96,949.79,156715.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','110',2623,'7','1',266594.27,270014.14,3419.87,564278.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','110',2624,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','110',2625,'9','1',224496.80,224496.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','110',2626,'10','1',84296.37,84296.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','110',2627,'11','1',296709.41,299349.59,2640.18,435629.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','110',2628,'12','1',92838.17,93087.73,249.56,41177.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','110',2629,'13','1',161752.68,161752.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','110',2630,'14','1',69832.88,69832.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','110',2631,'15','1',180983.67,180983.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','110',2632,'16','1',48088.82,48088.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','110',2633,'17','1',30672.49,30672.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','110',2634,'18','1',208063.48,208063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','110',2635,'19','1',35128.07,35128.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','110',2636,'20','1',200325.60,200325.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','110',2637,'21','2',128879.35,129019.18,139.83,107669.10,0.00,0.00,0.00,0.00,0.00),('1','248','4','110',2638,'22','2',86790.79,88016.61,1225.82,943881.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','110',2639,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','110',2640,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','111',2641,'1','1',402064.37,406796.83,4732.46,780855.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','111',2642,'2','1',95511.17,95511.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','111',2643,'3','1',304240.68,307460.29,3219.61,531235.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','111',2644,'4','1',128783.40,131347.26,2563.86,423036.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','111',2645,'5','1',385253.93,388550.45,3296.52,543925.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','111',2646,'6','1',24880.96,24880.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','111',2647,'7','1',270014.14,274320.17,4306.03,710494.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','111',2648,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','111',2649,'9','1',224496.80,228175.89,3679.09,607049.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','111',2650,'10','1',84296.37,87369.90,3073.53,507132.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','111',2651,'11','1',299349.59,303253.82,3904.23,644197.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','111',2652,'12','1',93087.73,94253.62,1165.89,192371.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','111',2653,'13','1',161752.68,161752.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','111',2654,'14','1',69832.88,69832.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','111',2655,'15','1',180983.67,180983.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','111',2656,'16','1',48088.82,48088.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','111',2657,'17','1',30672.49,30672.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','111',2658,'18','1',208063.48,208063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','111',2659,'19','1',35128.07,35128.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','111',2660,'20','1',200325.60,200325.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','111',2661,'21','2',129019.18,130430.55,1411.37,1086754.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','111',2662,'22','2',88016.61,89889.12,1872.51,1441832.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','111',2663,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','111',2664,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','112',2665,'1','1',406796.83,410868.15,4071.32,671767.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','112',2666,'2','1',95511.17,99040.97,3529.80,582417.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','112',2667,'3','1',307460.29,311873.85,4413.56,728237.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','112',2668,'4','1',131347.26,131347.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','112',2669,'5','1',388550.45,392657.63,4107.18,677684.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','112',2670,'6','1',24880.96,25204.63,323.67,53405.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','112',2671,'7','1',274320.17,278518.73,4198.56,692762.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','112',2672,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','112',2673,'9','1',228175.89,230840.07,2664.18,439589.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','112',2674,'10','1',87369.90,90217.33,2847.43,469825.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','112',2675,'11','1',303253.82,306966.78,3712.96,612638.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','112',2676,'12','1',94253.62,94253.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','112',2677,'13','1',161752.68,161752.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','112',2678,'14','1',69832.88,69832.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','112',2679,'15','1',180983.67,180983.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','112',2680,'16','1',48088.82,48088.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','112',2681,'17','1',30672.49,30672.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','112',2682,'18','1',208063.48,208063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','112',2683,'19','1',35128.07,35128.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','112',2684,'20','1',200325.60,200325.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','112',2685,'21','2',130430.55,132572.81,2142.26,1649540.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','112',2686,'22','2',89889.12,90159.02,269.90,207823.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','112',2687,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','112',2688,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','113',2689,'1','1',410868.15,417111.82,6243.67,1030205.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','113',2690,'2','1',99040.97,101380.74,2339.77,386062.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','113',2691,'3','1',311873.85,318236.79,6362.94,1049885.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','113',2692,'4','1',131347.26,131347.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','113',2693,'5','1',392657.63,399440.83,6783.20,1119228.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','113',2694,'6','1',25204.63,25204.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','113',2695,'7','1',278518.73,278518.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','113',2696,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','113',2697,'9','1',230840.07,230840.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','113',2698,'10','1',90217.33,90217.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','113',2699,'11','1',306966.78,312965.77,5998.99,989833.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','113',2700,'12','1',94253.62,100499.74,6246.12,1030609.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','113',2701,'13','1',161752.68,161752.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','113',2702,'14','1',69832.88,69832.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','113',2703,'15','1',180983.67,180983.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','113',2704,'16','1',48088.82,48088.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','113',2705,'17','1',30672.49,30672.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','113',2706,'18','1',208063.48,208063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','113',2707,'19','1',35128.07,35128.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','113',2708,'20','1',200325.60,200325.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','113',2709,'21','2',132572.81,134072.02,1499.21,1199368.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','113',2710,'22','2',90159.02,90716.54,557.52,446016.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','113',2711,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','113',2712,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','114',2713,'1','1',417111.82,419785.71,2673.89,441191.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','114',2714,'2','1',101380.74,102330.28,949.54,156674.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','114',2715,'3','1',318236.79,320759.33,2522.54,416219.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','114',2716,'4','1',131347.26,133509.52,2162.26,356772.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','114',2717,'5','1',399440.83,402167.59,2726.76,449915.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','114',2718,'6','1',25204.63,26006.72,802.09,132344.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','114',2719,'7','1',278518.73,278882.38,363.65,60002.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','114',2720,'8','1',130065.65,130065.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','114',2721,'9','1',230840.07,232715.63,1875.56,309467.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','114',2722,'10','1',90217.33,90217.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','114',2723,'11','1',312965.77,314389.45,1423.68,234907.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','114',2724,'12','1',100499.74,100499.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','114',2725,'13','1',161752.68,161752.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','114',2726,'14','1',69832.88,69832.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','114',2727,'15','1',180983.67,180983.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','114',2728,'16','1',48088.82,48088.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','114',2729,'17','1',30672.49,30672.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','114',2730,'18','1',208063.48,208063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','114',2731,'19','1',35128.07,35128.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','114',2732,'20','1',200325.60,200325.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','114',2733,'21','2',134072.02,135258.94,1186.92,949536.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','114',2734,'22','2',90716.54,90942.61,226.07,180856.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','114',2735,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','114',2736,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','115',2737,'1','1',419785.71,425421.58,5635.87,929918.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','115',2738,'2','1',102330.28,103733.64,1403.36,231554.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','115',2739,'3','1',320759.33,325832.63,5073.30,837094.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','115',2740,'4','1',133509.52,137560.63,4051.11,668433.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','115',2741,'5','1',402167.59,406910.41,4732.82,780915.30,0.00,0.00,10.00,0.00,0.00),('1','248','1','115',2742,'6','1',26006.72,27314.68,1307.96,215813.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','115',2743,'7','1',278882.38,283258.99,4376.61,722140.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','115',2744,'8','1',130065.65,132058.51,1992.86,328821.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','115',2745,'9','1',232715.63,237054.79,4339.16,715961.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','115',2746,'10','1',90217.33,90217.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','115',2747,'11','1',314389.45,318813.82,4424.37,730021.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','115',2748,'12','1',100499.74,100499.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','115',2749,'13','1',161752.68,161752.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','115',2750,'14','1',69832.88,69832.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','115',2751,'15','1',180983.67,180983.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','115',2752,'16','1',48088.82,48088.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','115',2753,'17','1',30672.49,30672.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','115',2754,'18','1',208063.48,208063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','115',2755,'19','1',35128.07,35128.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','115',2756,'20','1',200325.60,200325.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','115',2757,'21','2',135258.94,137427.60,2168.66,1734928.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','115',2758,'22','2',90942.61,91092.61,150.00,120000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','115',2759,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','115',2760,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','116',2761,'1','1',425421.58,425421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','116',2762,'2','1',103733.64,103733.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','116',2763,'3','1',325832.63,325832.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','116',2764,'4','1',137560.63,137560.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','116',2765,'5','1',406910.41,410796.51,3886.10,641206.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','116',2766,'6','1',27314.68,31068.57,3753.89,619391.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','116',2767,'7','1',283258.99,283258.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','116',2768,'8','1',132058.51,132058.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','116',2769,'9','1',237054.79,239865.82,2811.03,463819.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','116',2770,'10','1',90217.33,93566.39,3349.06,552594.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','116',2771,'11','1',318813.82,323284.79,4460.97,736060.05,0.00,0.00,10.00,0.00,0.00),('1','248','2','116',2772,'12','1',100499.74,104600.20,4100.46,676575.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','116',2773,'13','1',161752.68,161752.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','116',2774,'14','1',69832.88,69832.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','116',2775,'15','1',180983.67,180983.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','116',2776,'16','1',48088.82,48088.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','116',2777,'17','1',30672.49,30672.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','116',2778,'18','1',208063.48,208063.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','116',2779,'19','1',35128.07,35128.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','116',2780,'20','1',200325.60,200325.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','116',2781,'21','2',137427.60,139424.76,1997.16,1597728.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','116',2782,'22','2',91092.61,91483.72,391.11,312888.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','116',2783,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','116',2784,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','117',2785,'1','1',425421.58,425421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','117',2786,'2','1',103733.64,103733.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','117',2787,'3','1',325832.63,325832.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','117',2788,'4','1',137560.63,137560.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','117',2789,'5','1',410796.51,410796.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','117',2790,'6','1',31068.57,31068.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','117',2791,'7','1',283258.99,283258.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','117',2792,'8','1',132058.51,132058.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','117',2793,'9','1',239865.82,239865.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','117',2794,'10','1',93566.39,93566.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','117',2795,'11','1',323284.79,323284.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','117',2796,'12','1',104600.20,104600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','117',2797,'13','1',161752.68,168675.24,6922.56,1142222.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','117',2798,'14','1',69832.88,69832.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','117',2799,'15','1',180983.67,188225.08,7195.96,1187333.40,0.00,0.00,45.45,0.00,0.00),('1','248','3','117',2800,'16','1',48088.82,48191.36,102.54,16919.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','117',2801,'17','1',30672.49,32045.15,1372.66,226488.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','117',2802,'18','1',208063.48,213644.68,5581.20,920898.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','117',2803,'19','1',35128.07,38017.48,2889.41,476752.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','117',2804,'20','1',200325.60,206353.71,6028.11,994638.15,0.00,0.00,0.00,0.00,0.00),('1','248','4','117',2805,'21','2',139424.76,140785.40,1360.64,1088512.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','117',2806,'22','2',91483.72,91483.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','117',2807,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','117',2808,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','118',2809,'1','1',425421.58,425421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','118',2810,'2','1',103733.64,103733.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','118',2811,'3','1',325832.63,325832.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','118',2812,'4','1',137560.63,137560.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','118',2813,'5','1',410796.51,410796.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','118',2814,'6','1',31068.57,31068.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','118',2815,'7','1',283258.99,283258.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','118',2816,'8','1',132058.51,132058.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','118',2817,'9','1',239865.82,239865.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','118',2818,'10','1',93566.39,93566.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','118',2819,'11','1',323284.79,323284.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','118',2820,'12','1',104600.20,104600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','118',2821,'13','1',168675.24,171727.19,3051.95,503571.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','118',2822,'14','1',69832.88,72199.76,2366.88,390535.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','118',2823,'15','1',188225.08,191443.04,3217.96,530963.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','118',2824,'16','1',48191.36,51345.34,3153.98,520406.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','118',2825,'17','1',32045.15,32396.11,350.96,57908.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','118',2826,'18','1',213644.68,217200.14,3555.46,586650.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','118',2827,'19','1',38017.48,38802.60,785.12,129544.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','118',2828,'20','1',206353.71,209601.77,3248.06,535929.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','118',2829,'21','2',140785.40,142160.61,1375.21,1100168.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','118',2830,'22','2',91483.72,91704.94,221.22,176976.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','118',2831,'23','2',527.35,527.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','118',2832,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','119',2833,'1','1',425421.58,429960.07,4538.49,748850.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','119',2834,'2','1',103733.64,106210.49,2476.85,408680.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','119',2835,'3','1',325832.63,329562.87,3730.24,615489.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','119',2836,'4','1',137560.63,137560.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','119',2837,'5','1',410796.51,415099.37,4302.86,709971.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','119',2838,'6','1',31068.57,31068.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','119',2839,'7','1',283258.99,287951.09,4692.10,774196.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','119',2840,'8','1',132058.51,132200.02,141.51,23349.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','119',2841,'9','1',239865.82,245281.03,5415.21,893509.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','119',2842,'10','1',93566.39,93566.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','119',2843,'11','1',323284.79,327894.33,4609.54,760574.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','119',2844,'12','1',104600.20,104600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','119',2845,'13','1',171727.19,171727.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','119',2846,'14','1',72199.76,72199.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','119',2847,'15','1',191443.04,191443.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','119',2848,'16','1',51345.34,51345.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','119',2849,'17','1',32396.11,32396.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','119',2850,'18','1',217200.14,217200.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','119',2851,'19','1',38802.60,38802.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','119',2852,'20','1',209601.77,209601.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','119',2853,'21','2',142160.61,142168.51,7.90,6320.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','119',2854,'22','2',91704.94,91704.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','119',2855,'23','2',527.35,3066.48,2539.13,2031304.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','119',2856,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','120',2857,'1','1',429960.07,434456.77,4496.70,741955.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','120',2858,'2','1',106210.49,106210.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','120',2859,'3','1',329562.87,333090.37,3527.50,582037.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','120',2860,'4','1',137560.63,140270.82,2710.19,447181.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','120',2861,'5','1',415099.37,419024.75,3925.38,647687.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','120',2862,'6','1',31068.57,31068.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','120',2863,'7','1',287951.09,291573.29,3622.20,597663.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','120',2864,'8','1',132200.02,135897.18,3697.16,610031.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','120',2865,'9','1',245281.03,249418.10,4137.07,682616.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','120',2866,'10','1',93566.39,93566.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','120',2867,'11','1',327894.33,331229.95,3335.62,550377.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','120',2868,'12','1',104600.20,104600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','120',2869,'13','1',171727.19,171727.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','120',2870,'14','1',72199.76,72199.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','120',2871,'15','1',191443.04,191443.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','120',2872,'16','1',51345.34,51345.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','120',2873,'17','1',32396.11,32396.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','120',2874,'18','1',217200.14,217200.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','120',2875,'19','1',38802.60,38802.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','120',2876,'20','1',209601.77,209601.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','120',2877,'21','2',142168.51,142168.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','120',2878,'22','2',91704.94,91704.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','120',2879,'23','2',3066.48,4839.34,1742.86,1429145.20,0.00,0.00,30.00,0.00,0.00),('1','248','5','120',2880,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','121',2881,'1','1',434456.77,438146.63,3689.86,608826.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','121',2882,'2','1',106210.49,110722.24,4511.75,744438.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','121',2883,'3','1',333090.37,337364.16,4273.79,705175.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','121',2884,'4','1',140270.82,140270.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','121',2885,'5','1',419024.75,423323.48,4298.73,709290.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','121',2886,'6','1',31068.57,31068.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','121',2887,'7','1',291573.29,297597.95,6024.66,994068.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','121',2888,'8','1',135897.18,135897.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','121',2889,'9','1',249418.10,254267.61,4849.51,800169.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','121',2890,'10','1',93566.39,93566.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','121',2891,'11','1',331229.95,336596.02,5366.07,885401.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','121',2892,'12','1',104600.20,104600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','121',2893,'13','1',171727.19,171727.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','121',2894,'14','1',72199.76,72199.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','121',2895,'15','1',191443.04,191443.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','121',2896,'16','1',51345.34,51345.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','121',2897,'17','1',32396.11,32396.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','121',2898,'18','1',217200.14,217200.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','121',2899,'19','1',38802.60,38802.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','121',2900,'20','1',209601.77,209601.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','121',2901,'21','2',142168.51,142168.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','121',2902,'22','2',91704.94,91704.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','121',2903,'23','2',4839.34,5275.03,435.69,357265.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','121',2904,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','122',2905,'1','1',438146.63,442386.02,4239.39,699499.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','122',2906,'2','1',110722.24,114521.00,3798.76,626795.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','122',2907,'3','1',337364.16,340428.82,3064.66,505668.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','122',2908,'4','1',140270.82,144423.03,4152.21,685114.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','122',2909,'5','1',423323.48,428006.11,4682.63,772633.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','122',2910,'6','1',31068.57,34276.99,3208.42,529389.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','122',2911,'7','1',297597.95,298690.66,1092.71,180297.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','122',2912,'8','1',135897.18,135897.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','122',2913,'9','1',254267.61,255521.76,1254.15,206934.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','122',2914,'10','1',93566.39,93749.51,183.12,30214.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','122',2915,'11','1',336596.02,337723.05,1127.03,185959.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','122',2916,'12','1',104600.20,104600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','122',2917,'13','1',171727.19,171727.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','122',2918,'14','1',72199.76,72199.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','122',2919,'15','1',191443.04,191443.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','122',2920,'16','1',51345.34,51345.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','122',2921,'17','1',32396.11,32396.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','122',2922,'18','1',217200.14,217200.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','122',2923,'19','1',38802.60,38802.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','122',2924,'20','1',209601.77,209601.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','122',2925,'21','2',142168.51,142179.46,10.95,8979.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','122',2926,'22','2',91704.94,91704.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','122',2927,'23','2',5275.03,7781.96,2506.93,2055682.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','122',2928,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','123',2929,'1','1',442386.02,443887.88,1501.86,247806.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','123',2930,'2','1',114521.00,116654.65,2133.65,352052.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','123',2931,'3','1',340428.82,342715.45,2286.63,377293.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','123',2932,'4','1',144423.03,144423.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','123',2933,'5','1',428006.11,431043.76,3037.65,501212.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','123',2934,'6','1',34276.99,34276.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','123',2935,'7','1',298690.66,301004.27,2313.61,381745.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','123',2936,'8','1',135897.18,135897.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','123',2937,'9','1',255521.76,257876.14,2354.38,388472.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','123',2938,'10','1',93749.51,93749.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','123',2939,'11','1',337723.05,340291.04,2567.99,423718.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','123',2940,'12','1',104600.20,104600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','123',2941,'13','1',171727.19,171727.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','123',2942,'14','1',72199.76,72199.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','123',2943,'15','1',191443.04,191443.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','123',2944,'16','1',51345.34,51345.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','123',2945,'17','1',32396.11,32396.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','123',2946,'18','1',217200.14,217200.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','123',2947,'19','1',38802.60,38802.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','123',2948,'20','1',209601.77,209601.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','123',2949,'21','2',142179.46,142179.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','123',2950,'22','2',91704.94,91704.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','123',2951,'23','2',7781.96,7943.07,161.11,132110.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','123',2952,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','124',2953,'1','1',443887.88,447914.58,4026.70,664405.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','124',2954,'2','1',116654.65,119705.13,3050.48,503329.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','124',2955,'3','1',342715.45,347370.84,4655.39,768139.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','124',2956,'4','1',144423.03,144423.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','124',2957,'5','1',431043.76,435888.14,4844.38,799322.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','124',2958,'6','1',34276.99,34276.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','124',2959,'7','1',301004.27,306359.96,5355.69,883688.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','124',2960,'8','1',135897.18,135897.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','124',2961,'9','1',257876.14,262986.36,5110.22,843186.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','124',2962,'10','1',93749.51,93749.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','124',2963,'11','1',340291.04,345398.41,5107.37,842716.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','124',2964,'12','1',104600.20,104600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','124',2965,'13','1',171727.19,171727.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','124',2966,'14','1',72199.76,72199.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','124',2967,'15','1',191443.04,191443.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','124',2968,'16','1',51345.34,51345.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','124',2969,'17','1',32396.11,32396.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','124',2970,'18','1',217200.14,217200.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','124',2971,'19','1',38802.60,38802.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','124',2972,'20','1',209601.77,209601.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','124',2973,'21','2',142179.46,142179.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','124',2974,'22','2',91704.94,91704.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','124',2975,'23','2',7943.07,7943.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','124',2976,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','125',2977,'1','1',447914.58,450201.90,2287.32,377407.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','125',2978,'2','1',119705.13,119705.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','125',2979,'3','1',347370.84,347370.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','125',2980,'4','1',144423.03,144423.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','125',2981,'5','1',435888.14,437891.67,2003.53,330582.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','125',2982,'6','1',34276.99,34276.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','125',2983,'7','1',306359.96,309950.66,3590.70,592465.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','125',2984,'8','1',135897.18,135897.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','125',2985,'9','1',262986.36,262986.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','125',2986,'10','1',93749.51,93749.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','125',2987,'11','1',345398.41,348840.66,3442.25,567971.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','125',2988,'12','1',104600.20,104600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','125',2989,'13','1',171727.19,175751.65,4024.46,664035.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','125',2990,'14','1',72199.76,74643.22,2443.46,403170.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','125',2991,'15','1',191443.04,195431.03,3987.99,658018.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','125',2992,'16','1',51345.34,53629.45,2284.11,376878.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','125',2993,'17','1',32396.11,33295.99,899.88,148480.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','125',2994,'18','1',217200.14,221351.91,4151.77,685042.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','125',2995,'19','1',38802.60,40191.22,1388.62,229122.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','125',2996,'20','1',209601.77,214047.11,4445.34,733481.10,0.00,0.00,0.00,0.00,0.00),('1','248','4','125',2997,'21','2',142179.46,142179.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','125',2998,'22','2',91704.94,91704.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','125',2999,'23','2',7943.07,7943.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','125',3000,'24','2',463.92,463.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','126',3001,'1','1',450201.90,450201.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','126',3002,'2','1',119705.13,119705.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','126',3003,'3','1',347370.84,347370.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','126',3004,'4','1',144423.03,144423.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','126',3005,'5','1',437891.67,437891.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','126',3006,'6','1',34276.99,34276.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','126',3007,'7','1',309950.66,309950.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','126',3008,'8','1',135897.18,135897.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','126',3009,'9','1',262986.36,262986.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','126',3010,'10','1',93749.51,93749.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','126',3011,'11','1',348840.66,348840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','126',3012,'12','1',104600.20,104600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','126',3013,'13','1',175751.65,180911.22,5159.57,851329.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','126',3014,'14','1',74643.22,74643.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','126',3015,'15','1',195431.03,200761.59,5330.56,879542.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','126',3016,'16','1',53629.45,53629.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','126',3017,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','126',3018,'18','1',221351.91,227358.01,6006.10,991006.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','126',3019,'19','1',40191.22,42020.34,1829.12,301804.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','126',3020,'20','1',214047.11,219506.63,5459.52,900820.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','126',3021,'21','2',142179.46,143213.70,1034.24,848076.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','126',3022,'22','2',91704.94,92830.28,1125.34,922778.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','126',3023,'23','2',7943.07,8885.55,942.48,772833.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','126',3024,'24','2',463.92,465.14,1.22,1000.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','127',3025,'1','1',450201.90,454065.08,3863.18,637424.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','127',3026,'2','1',119705.13,123107.41,3402.28,561376.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','127',3027,'3','1',347370.84,350654.33,3283.49,541775.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','127',3028,'4','1',144423.03,147596.03,3173.00,523545.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','127',3029,'5','1',437891.67,441486.12,3594.45,593084.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','127',3030,'6','1',34276.99,37483.72,3206.73,529110.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','127',3031,'7','1',309950.66,313322.18,3371.52,556300.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','127',3032,'8','1',135897.18,135897.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','127',3033,'9','1',262986.36,265714.97,2728.61,450220.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','127',3034,'10','1',93749.51,96368.83,2619.32,432187.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','127',3035,'11','1',348840.66,351724.64,2883.98,475856.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','127',3036,'12','1',104600.20,107166.79,2566.59,423487.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','127',3037,'13','1',180911.22,181276.24,365.02,60228.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','127',3038,'14','1',74643.22,74912.29,269.07,44396.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','127',3039,'15','1',200761.59,201224.96,463.37,76456.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','127',3040,'16','1',53629.45,53820.96,191.51,31599.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','127',3041,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','127',3042,'18','1',227358.01,227618.01,260.00,42900.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','127',3043,'19','1',42020.34,42341.74,321.40,53031.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','127',3044,'20','1',219506.63,219856.33,349.70,57700.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','127',3045,'21','2',143213.70,144470.28,1256.58,1030395.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','127',3046,'22','2',92830.28,93173.32,343.04,281292.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','127',3047,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','127',3048,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','128',3049,'1','1',454065.08,456351.72,2286.64,377295.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','128',3050,'2','1',123107.41,124992.95,1885.54,311114.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','128',3051,'3','1',350654.33,353377.28,2722.95,449286.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','128',3052,'4','1',147596.03,147596.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','128',3053,'5','1',441486.12,444057.93,2571.81,424348.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','128',3054,'6','1',37483.72,37544.30,60.58,9995.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','128',3055,'7','1',313322.18,316414.85,3092.67,510290.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','128',3056,'8','1',135897.18,137905.09,2007.91,331305.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','128',3057,'9','1',265714.97,268875.89,3160.92,521551.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','128',3058,'10','1',96368.83,98820.92,2452.09,404594.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','128',3059,'11','1',351724.64,355130.05,3405.41,561892.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','128',3060,'12','1',107166.79,108944.19,1777.40,293271.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','128',3061,'13','1',181276.24,181276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','128',3062,'14','1',74912.29,74912.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','128',3063,'15','1',201224.96,201224.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','128',3064,'16','1',53820.96,53820.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','128',3065,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','128',3066,'18','1',227618.01,227618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','128',3067,'19','1',42341.74,42341.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','128',3068,'20','1',219856.33,219856.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','128',3069,'21','2',144470.28,148662.91,4192.63,3437956.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','128',3070,'22','2',93173.32,93327.80,154.48,126673.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','128',3071,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','128',3072,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','129',3073,'1','1',456351.72,460461.41,4109.69,678098.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','129',3074,'2','1',124992.95,129272.67,4279.72,706153.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','129',3075,'3','1',353377.28,357633.86,4256.58,702335.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','129',3076,'4','1',147596.03,147596.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','129',3077,'5','1',444057.93,449542.69,5484.76,904985.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','129',3078,'6','1',37544.30,37544.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','129',3079,'7','1',316414.85,319915.39,3488.42,575589.30,0.00,0.00,12.12,0.00,0.00),('1','248','2','129',3080,'8','1',137905.09,141678.75,3773.66,622653.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','129',3081,'9','1',268875.89,272202.44,3306.55,545580.75,0.00,0.00,20.00,0.00,0.00),('1','248','2','129',3082,'10','1',98820.92,98820.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','129',3083,'11','1',355130.05,358803.45,3673.40,606111.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','129',3084,'12','1',108944.19,112079.36,3135.17,517303.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','129',3085,'13','1',181276.24,181276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','129',3086,'14','1',74912.29,74912.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','129',3087,'15','1',201224.96,201224.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','129',3088,'16','1',53820.96,53820.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','129',3089,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','129',3090,'18','1',227618.01,227618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','129',3091,'19','1',42341.74,42341.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','129',3092,'20','1',219856.33,219856.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','129',3093,'21','2',148662.91,149208.31,457.43,375092.60,0.00,0.00,87.97,0.00,0.00),('1','248','4','129',3094,'22','2',93327.80,94121.82,794.02,651096.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','129',3095,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','129',3096,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','130',3097,'1','1',460461.41,463329.23,2867.82,473190.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','130',3098,'2','1',129272.67,131228.63,1955.96,322733.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','130',3099,'3','1',357633.86,360314.00,2680.14,442223.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','130',3100,'4','1',147596.03,147596.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','130',3101,'5','1',449542.69,451988.73,2446.04,403596.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','130',3102,'6','1',37544.30,39383.91,1839.61,303535.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','130',3103,'7','1',319915.39,322413.92,2498.53,412257.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','130',3104,'8','1',141678.75,144125.57,2446.82,403725.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','130',3105,'9','1',272202.44,275268.58,3066.14,505913.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','130',3106,'10','1',98820.92,98820.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','130',3107,'11','1',358803.45,361341.89,2538.44,418842.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','130',3108,'12','1',112079.36,114055.99,1976.63,326143.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','130',3109,'13','1',181276.24,181276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','130',3110,'14','1',74912.29,74912.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','130',3111,'15','1',201224.96,201224.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','130',3112,'16','1',53820.96,53820.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','130',3113,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','130',3114,'18','1',227618.01,227618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','130',3115,'19','1',42341.74,42341.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','130',3116,'20','1',219856.33,219856.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','130',3117,'21','2',149208.31,150001.02,792.71,650022.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','130',3118,'22','2',94121.82,95737.18,1615.36,1324595.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','130',3119,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','130',3120,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','131',3121,'1','1',463329.23,467062.21,3732.98,615941.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','131',3122,'2','1',131228.63,131238.63,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','131',3123,'3','1',360314.00,364285.28,3971.28,655261.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','131',3124,'4','1',147596.03,147606.03,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','131',3125,'5','1',451988.73,455810.97,3822.24,630669.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','131',3126,'6','1',39383.91,39393.91,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','131',3127,'7','1',322413.92,324842.74,2428.82,400755.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','131',3128,'8','1',144125.57,146640.47,2514.90,414958.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','131',3129,'9','1',275268.58,278822.22,3553.64,586350.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','131',3130,'10','1',98820.92,98830.92,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','131',3131,'11','1',361341.89,364565.54,3223.65,531902.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','131',3132,'12','1',114055.99,114883.76,827.77,136582.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','131',3133,'13','1',181276.24,181276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','131',3134,'14','1',74912.29,74912.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','131',3135,'15','1',201224.96,201225.47,0.51,84.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','131',3136,'16','1',53820.96,53820.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','131',3137,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','131',3138,'18','1',227618.01,227618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','131',3139,'19','1',42341.74,42341.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','131',3140,'20','1',219856.33,219856.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','131',3141,'21','2',150001.02,150396.30,395.28,324129.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','131',3142,'22','2',95737.18,96634.14,896.96,735507.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','131',3143,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','131',3144,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','132',3145,'1','1',467062.21,470962.25,3900.04,643506.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','132',3146,'2','1',131238.63,134916.48,3677.85,606845.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','132',3147,'3','1',364285.28,367852.13,3566.85,588530.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','132',3148,'4','1',147606.03,150685.35,3079.32,508087.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','132',3149,'5','1',455810.97,460199.53,4388.56,724112.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','132',3150,'6','1',39393.91,41777.79,2383.88,393340.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','132',3151,'7','1',324842.74,325898.56,1055.82,174210.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','132',3152,'8','1',146640.47,146874.34,233.87,38588.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','132',3153,'9','1',278822.22,280103.95,1281.73,211485.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','132',3154,'10','1',98830.92,98830.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','132',3155,'11','1',364565.54,365459.55,894.01,147511.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','132',3156,'12','1',114883.76,114883.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','132',3157,'13','1',181276.24,181276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','132',3158,'14','1',74912.29,74912.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','132',3159,'15','1',201225.47,201242.08,16.61,2740.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','132',3160,'16','1',53820.96,53820.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','132',3161,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','132',3162,'18','1',227618.01,227618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','132',3163,'19','1',42341.74,42341.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','132',3164,'20','1',219856.33,219856.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','132',3165,'21','2',150396.30,151923.08,1526.78,1267227.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','132',3166,'22','2',96634.14,96769.45,135.31,112307.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','132',3167,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','132',3168,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','133',3169,'1','1',470962.25,474666.64,3704.39,611224.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','133',3170,'2','1',134916.48,136769.94,1853.46,305820.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','133',3171,'3','1',367852.13,370947.27,3095.14,510698.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','133',3172,'4','1',150685.35,153750.46,3065.11,505743.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','133',3173,'5','1',460199.53,463966.51,3766.98,621551.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','133',3174,'6','1',41777.79,41777.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','133',3175,'7','1',325898.56,328805.75,2907.19,479686.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','133',3176,'8','1',146874.34,150112.61,3238.27,534314.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','133',3177,'9','1',280103.95,283821.25,3717.30,613354.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','133',3178,'10','1',98830.92,98830.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','133',3179,'11','1',365459.55,370486.49,5026.94,829445.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','133',3180,'12','1',114883.76,114883.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','133',3181,'13','1',181276.24,181276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','133',3182,'14','1',74912.29,74912.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','133',3183,'15','1',201242.08,201242.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','133',3184,'16','1',53820.96,53820.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','133',3185,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','133',3186,'18','1',227618.01,227618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','133',3187,'19','1',42341.74,42341.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','133',3188,'20','1',219856.33,219856.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','133',3189,'21','2',151923.08,153918.82,1995.74,1656464.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','133',3190,'22','2',96769.45,98098.10,1328.65,1102779.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','133',3191,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','133',3192,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','134',3193,'1','1',474666.64,477475.58,2808.94,463475.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','134',3194,'2','1',136769.94,139623.25,2853.31,470796.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','134',3195,'3','1',370947.27,372385.14,1437.87,237248.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','134',3196,'4','1',153750.46,155892.50,2142.04,353436.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','134',3197,'5','1',463966.51,466715.53,2749.02,453588.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','134',3198,'6','1',41777.79,43937.90,2160.11,356418.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','134',3199,'7','1',328805.75,332174.44,3368.69,555833.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','134',3200,'8','1',150112.61,153100.13,2987.52,492940.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','134',3201,'9','1',283821.25,286874.04,3052.79,503710.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','134',3202,'10','1',98830.92,100968.91,2137.99,352768.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','134',3203,'11','1',370486.49,374047.98,3561.49,587645.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','134',3204,'12','1',114883.76,114883.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','134',3205,'13','1',181276.24,181276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','134',3206,'14','1',74912.29,74912.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','134',3207,'15','1',201242.08,201242.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','134',3208,'16','1',53820.96,53820.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','134',3209,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','134',3210,'18','1',227618.01,227618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','134',3211,'19','1',42341.74,42341.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','134',3212,'20','1',219856.33,219856.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','134',3213,'21','2',153918.82,153918.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','134',3214,'22','2',98098.10,99731.63,1633.53,1355829.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','134',3215,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','134',3216,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','135',3217,'1','1',477475.58,482755.92,5280.34,871256.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','135',3218,'2','1',139623.25,140575.95,952.70,157195.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','135',3219,'3','1',372385.14,377135.43,4750.29,783797.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','135',3220,'4','1',155892.50,155892.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','135',3221,'5','1',466715.53,471316.60,4601.07,759176.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','135',3222,'6','1',43937.90,43937.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','135',3223,'7','1',332174.44,336147.70,3973.26,655587.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','135',3224,'8','1',153100.13,155305.93,2205.80,363957.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','135',3225,'9','1',286874.04,291443.59,4569.55,753975.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','135',3226,'10','1',100968.91,100968.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','135',3227,'11','1',374047.98,378643.57,4595.59,758272.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','135',3228,'12','1',114883.76,114883.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','135',3229,'13','1',181276.24,181276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','135',3230,'14','1',74912.29,74912.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','135',3231,'15','1',201242.08,201242.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','135',3232,'16','1',53820.96,53820.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','135',3233,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','135',3234,'18','1',227618.01,227618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','135',3235,'19','1',42341.74,42341.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','135',3236,'20','1',219856.33,219856.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','135',3237,'21','2',153918.82,154878.88,960.06,796849.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','135',3238,'22','2',99731.63,99731.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','135',3239,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','135',3240,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','136',3241,'1','1',482755.92,485537.62,2781.70,458980.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','136',3242,'2','1',140575.95,143272.64,2696.69,444953.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','136',3243,'3','1',377135.43,379507.38,2371.95,391371.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','136',3244,'4','1',155892.50,158161.50,2269.00,374385.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','136',3245,'5','1',471316.60,473986.51,2669.91,440535.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','136',3246,'6','1',43937.90,46239.46,2301.56,379757.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','136',3247,'7','1',336147.70,336147.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','136',3248,'8','1',155305.93,155305.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','136',3249,'9','1',291443.59,292996.49,1552.90,256228.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','136',3250,'10','1',100968.91,102457.14,1488.23,245557.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','136',3251,'11','1',378643.57,378643.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','136',3252,'12','1',114883.76,114883.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','136',3253,'13','1',181276.24,181276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','136',3254,'14','1',74912.29,74912.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','136',3255,'15','1',201242.08,201242.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','136',3256,'16','1',53820.96,53820.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','136',3257,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','136',3258,'18','1',227618.01,227618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','136',3259,'19','1',42341.74,42341.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','136',3260,'20','1',219856.33,219856.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','136',3261,'21','2',154878.88,156368.27,1489.39,1236193.70,0.00,0.00,0.00,0.00,0.00),('1','248','4','136',3262,'22','2',99731.63,99803.91,72.28,59992.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','136',3263,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','136',3264,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','137',3265,'1','1',485537.62,489726.49,4188.87,691163.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','137',3266,'2','1',143272.64,146817.97,3545.33,584979.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','137',3267,'3','1',379507.38,383352.21,3844.83,634396.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','137',3268,'4','1',158161.50,158161.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','137',3269,'5','1',473986.51,479939.28,5952.77,982207.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','137',3270,'6','1',46239.46,46239.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','137',3271,'7','1',336147.70,340955.14,4807.44,793227.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','137',3272,'8','1',155305.93,159268.56,3962.63,653833.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','137',3273,'9','1',292996.49,297851.84,4855.35,801132.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','137',3274,'10','1',102457.14,102501.27,44.13,7281.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','137',3275,'11','1',378643.57,383932.46,5288.89,872666.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','137',3276,'12','1',114883.76,114883.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','137',3277,'13','1',181276.24,181276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','137',3278,'14','1',74912.29,74912.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','137',3279,'15','1',201242.08,201242.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','137',3280,'16','1',53820.96,53820.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','137',3281,'17','1',33295.99,33295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','137',3282,'18','1',227618.01,227618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','137',3283,'19','1',42341.74,42341.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','137',3284,'20','1',219856.33,219856.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','137',3285,'21','2',156368.27,157697.82,1329.55,1103526.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','137',3286,'22','2',99803.91,99807.52,3.61,2996.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','137',3287,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','137',3288,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','138',3289,'1','1',489726.49,492412.90,2686.41,443257.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','138',3290,'2','1',146817.97,149400.94,2582.97,426190.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','138',3291,'3','1',383352.21,386598.11,3245.90,535573.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','138',3292,'4','1',158161.50,158161.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','138',3293,'5','1',479939.28,483662.49,3723.21,614329.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','138',3294,'6','1',46239.46,46239.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','138',3295,'7','1',340955.14,343036.24,2081.10,343381.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','138',3296,'8','1',159268.56,161863.91,2595.35,428232.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','138',3297,'9','1',297851.84,300497.84,2621.76,432590.40,0.00,0.00,24.24,0.00,0.00),('1','248','2','138',3298,'10','1',102501.27,103164.62,663.35,109452.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','138',3299,'11','1',383932.46,386826.71,2894.25,477551.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','138',3300,'12','1',114883.76,114883.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','138',3301,'13','1',181276.24,181562.66,286.42,47259.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','138',3302,'14','1',74912.29,75058.17,145.88,24070.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','138',3303,'15','1',201242.08,201423.86,181.78,29993.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','138',3304,'16','1',53820.96,53995.73,174.77,28837.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','138',3305,'17','1',33295.99,33688.03,392.04,64686.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','138',3306,'18','1',227618.01,228644.80,1026.79,169420.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','138',3307,'19','1',42341.74,42704.40,362.66,59838.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','138',3308,'20','1',219856.33,221231.45,1375.12,226894.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','138',3309,'21','2',157697.82,160473.60,2775.78,2303897.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','138',3310,'22','2',99807.52,100047.30,239.78,199017.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','138',3311,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','138',3312,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','139',3313,'1','1',492412.90,496909.40,4496.50,741922.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','139',3314,'2','1',149400.94,153721.66,4320.72,712918.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','139',3315,'3','1',386598.11,391695.14,5097.03,841009.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','139',3316,'4','1',158161.50,158161.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','139',3317,'5','1',483662.49,489442.55,5780.06,953709.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','139',3318,'6','1',46239.46,46239.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','139',3319,'7','1',343036.24,347785.25,4749.01,783586.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','139',3320,'8','1',161863.91,165531.44,3667.53,605142.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','139',3321,'9','1',300497.84,306333.43,5835.59,962872.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','139',3322,'10','1',103164.62,103505.32,340.70,56215.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','139',3323,'11','1',386826.71,392289.90,5463.19,901426.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','139',3324,'12','1',114883.76,114883.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','139',3325,'13','1',181562.66,181562.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','139',3326,'14','1',75058.17,75058.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','139',3327,'15','1',201423.86,201423.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','139',3328,'16','1',53995.73,53995.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','139',3329,'17','1',33688.03,33688.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','139',3330,'18','1',228644.80,230473.22,1828.42,301689.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','139',3331,'19','1',42704.40,42704.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','139',3332,'20','1',221231.45,223548.68,2317.23,382342.95,0.00,0.00,0.00,0.00,0.00),('1','248','4','139',3333,'21','2',160473.60,161013.62,540.02,448216.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','139',3334,'22','2',100047.30,100225.43,178.13,147847.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','139',3335,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','139',3336,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','140',3337,'1','1',496909.40,501107.98,4198.58,692765.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','140',3338,'2','1',153721.66,158293.16,4571.50,754297.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','140',3339,'3','1',391695.14,392207.57,512.43,84550.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','140',3340,'4','1',158161.50,161746.62,3585.12,591544.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','140',3341,'5','1',489442.55,492805.45,3362.90,554878.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','140',3342,'6','1',46239.46,50243.34,4003.88,660640.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','140',3343,'7','1',347785.25,347785.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','140',3344,'8','1',165531.44,165531.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','140',3345,'9','1',306333.43,306333.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','140',3346,'10','1',103505.32,103505.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','140',3347,'11','1',392289.90,392289.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','140',3348,'12','1',114883.76,114883.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','140',3349,'13','1',181562.66,186207.78,4645.12,766444.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','140',3350,'14','1',75058.17,75058.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','140',3351,'15','1',201423.86,205994.57,4570.71,754167.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','140',3352,'16','1',53995.73,53995.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','140',3353,'17','1',33688.03,33688.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','140',3354,'18','1',230473.22,233907.80,3434.58,566705.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','140',3355,'19','1',42704.40,42704.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','140',3356,'20','1',223548.68,226653.99,3105.31,512376.15,0.00,0.00,0.00,0.00,0.00),('1','248','4','140',3357,'21','2',161013.62,162758.19,1744.57,1447993.10,0.00,0.00,0.00,0.00,0.00),('1','248','4','140',3358,'22','2',100225.43,100625.10,399.67,331726.10,0.00,0.00,0.00,0.00,0.00),('1','248','5','140',3359,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','140',3360,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','141',3361,'1','1',501107.98,504311.10,3203.12,528514.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','141',3362,'2','1',158293.16,162411.62,4118.46,679545.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','141',3363,'3','1',392207.57,395950.82,3743.25,617636.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','141',3364,'4','1',161746.62,164517.73,2771.11,457233.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','141',3365,'5','1',492805.45,496391.54,3586.09,591704.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','141',3366,'6','1',50243.34,53489.65,3246.31,535641.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','141',3367,'7','1',347785.25,352782.35,4997.10,824521.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','141',3368,'8','1',165531.44,165531.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','141',3369,'9','1',306333.43,310134.75,3801.32,627217.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','141',3370,'10','1',103505.32,103505.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','141',3371,'11','1',392289.90,395988.17,3698.27,610214.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','141',3372,'12','1',114883.76,118294.65,3410.89,562796.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','141',3373,'13','1',186207.78,186207.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','141',3374,'14','1',75058.17,75058.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','141',3375,'15','1',205994.57,205994.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','141',3376,'16','1',53995.73,53995.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','141',3377,'17','1',33688.03,33688.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','141',3378,'18','1',233907.80,233907.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','141',3379,'19','1',42704.40,42704.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','141',3380,'20','1',226653.99,226653.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','141',3381,'21','2',162758.19,164591.16,1832.97,1521365.10,0.00,0.00,0.00,0.00,0.00),('1','248','4','141',3382,'22','2',100625.10,101643.29,1018.19,845097.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','141',3383,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','141',3384,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','142',3385,'1','1',504311.10,507715.69,3404.59,561757.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','142',3386,'2','1',162411.62,162442.93,31.31,5166.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','142',3387,'3','1',395950.82,399022.37,3071.55,506805.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','142',3388,'4','1',164517.73,164517.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','142',3389,'5','1',496391.54,499229.55,2838.01,468271.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','142',3390,'6','1',53489.65,53489.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','142',3391,'7','1',352782.35,355556.21,2773.86,457686.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','142',3392,'8','1',165531.44,168541.77,3010.33,496704.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','142',3393,'9','1',310134.75,313933.06,3798.31,626721.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','142',3394,'10','1',103505.32,103505.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','142',3395,'11','1',395988.17,399484.96,3496.79,576970.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','142',3396,'12','1',118294.65,119384.04,1089.39,179749.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','142',3397,'13','1',186207.78,186207.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','142',3398,'14','1',75058.17,75058.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','142',3399,'15','1',205994.57,205994.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','142',3400,'16','1',53995.73,53995.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','142',3401,'17','1',33688.03,33688.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','142',3402,'18','1',233907.80,233907.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','142',3403,'19','1',42704.40,42704.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','142',3404,'20','1',226653.99,226653.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','142',3405,'21','2',164591.16,165787.60,1196.44,993045.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','142',3406,'22','2',101643.29,102803.71,1160.42,963148.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','142',3407,'23','2',8885.55,8885.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','142',3408,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','143',3409,'1','1',507715.69,507715.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','143',3410,'2','1',162442.93,162442.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','143',3411,'3','1',399022.37,399022.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','143',3412,'4','1',164517.73,164517.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','143',3413,'5','1',499229.55,499229.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','143',3414,'6','1',53489.65,53489.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','143',3415,'7','1',355556.21,355556.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','143',3416,'8','1',168541.77,168541.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','143',3417,'9','1',313933.06,313933.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','143',3418,'10','1',103505.32,103505.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','143',3419,'11','1',399484.96,399484.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','143',3420,'12','1',119384.04,119384.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','143',3421,'13','1',186207.78,189090.29,2882.51,475614.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','143',3422,'14','1',75058.17,78561.62,3473.45,573119.25,0.00,0.00,30.00,0.00,0.00),('1','248','3','143',3423,'15','1',205994.57,209228.98,3234.41,533677.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','143',3424,'16','1',53995.73,56772.15,2776.42,458109.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','143',3425,'17','1',33688.03,37742.41,4054.38,668972.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','143',3426,'18','1',233907.80,237874.56,3966.76,654515.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','143',3427,'19','1',42704.40,46215.95,3511.55,579405.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','143',3428,'20','1',226653.99,230062.17,3408.18,562349.70,0.00,0.00,0.00,0.00,0.00),('1','248','4','143',3429,'21','2',165787.60,171398.86,5611.26,4657345.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','143',3430,'22','2',102803.71,103379.70,552.99,458981.70,0.00,0.00,23.00,0.00,0.00),('1','248','5','143',3431,'23','2',8885.55,9717.88,832.33,690833.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','143',3432,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','144',3433,'1','1',507715.69,507715.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','144',3434,'2','1',162442.93,162442.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','144',3435,'3','1',399022.37,399022.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','144',3436,'4','1',164517.73,164517.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','144',3437,'5','1',499229.55,499229.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','144',3438,'6','1',53489.65,53489.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','144',3439,'7','1',355556.21,355556.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','144',3440,'8','1',168541.77,168541.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','144',3441,'9','1',313933.06,313933.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','144',3442,'10','1',103505.32,103505.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','144',3443,'11','1',399484.96,399484.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','144',3444,'12','1',119384.04,119384.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','144',3445,'13','1',189090.29,191951.07,2860.78,472028.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','144',3446,'14','1',78561.62,81211.97,2650.35,437307.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','144',3447,'15','1',209228.98,211474.92,2245.94,370580.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','144',3448,'16','1',56772.15,59247.87,2475.72,408493.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','144',3449,'17','1',37742.41,41062.00,3319.59,547732.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','144',3450,'18','1',237874.56,241226.48,3351.92,553066.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','144',3451,'19','1',46215.95,48926.99,2711.04,447321.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','144',3452,'20','1',230062.17,232788.60,2726.43,449860.95,0.00,0.00,0.00,0.00,0.00),('1','248','4','144',3453,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','144',3454,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','144',3455,'23','2',9717.88,12169.33,2451.45,2034703.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','144',3456,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','145',3457,'1','1',507715.69,512278.44,4562.75,752853.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','145',3458,'2','1',162442.93,163997.58,1554.65,256517.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','145',3459,'3','1',399022.37,400367.39,1345.02,221928.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','145',3460,'4','1',164517.73,168316.57,3798.84,626808.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','145',3461,'5','1',499229.55,503711.27,4481.72,739483.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','145',3462,'6','1',53489.65,57655.97,4166.32,687442.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','145',3463,'7','1',355556.21,358859.71,3303.50,545077.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','145',3464,'8','1',168541.77,171607.00,3065.23,505762.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','145',3465,'9','1',313933.06,318036.48,4103.42,677064.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','145',3466,'10','1',103505.32,106146.73,2641.41,435832.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','145',3467,'11','1',399484.96,403311.22,3826.26,631332.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','145',3468,'12','1',119384.04,122415.32,3031.28,500161.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','145',3469,'13','1',191951.07,191951.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','145',3470,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','145',3471,'15','1',211474.92,211474.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','145',3472,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','145',3473,'17','1',41062.00,41062.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','145',3474,'18','1',241226.48,241226.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','145',3475,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','145',3476,'20','1',232788.60,232788.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','145',3477,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','145',3478,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','145',3479,'23','2',12169.33,13357.32,1187.99,986031.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','145',3480,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','146',3481,'1','1',512278.44,514613.11,2334.67,385220.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','146',3482,'2','1',163997.58,166175.87,2178.29,359417.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','146',3483,'3','1',400367.39,402135.62,1768.23,291757.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','146',3484,'4','1',168316.57,170568.57,2252.00,371580.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','146',3485,'5','1',503711.27,506015.71,2304.44,380232.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','146',3486,'6','1',57655.97,57655.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','146',3487,'7','1',358859.71,360997.78,2138.07,352781.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','146',3488,'8','1',171607.00,173236.96,1629.96,268943.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','146',3489,'9','1',318036.48,319996.87,1960.39,323464.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','146',3490,'10','1',106146.73,108031.38,1884.65,310967.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','146',3491,'11','1',403311.22,406215.11,2903.89,479141.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','146',3492,'12','1',122415.32,123471.61,1056.29,174287.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','146',3493,'13','1',191951.07,193517.78,1566.71,258507.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','146',3494,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','146',3495,'15','1',211474.92,213503.74,2028.82,334755.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','146',3496,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','146',3497,'17','1',41062.00,41062.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','146',3498,'18','1',241226.48,242872.59,1646.11,271608.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','146',3499,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','146',3500,'20','1',232788.60,234510.83,1722.23,284167.95,0.00,0.00,0.00,0.00,0.00),('1','248','4','146',3501,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','146',3502,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','146',3503,'23','2',13357.32,16684.20,3326.88,2761310.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','146',3504,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','147',3505,'1','1',514613.11,520659.39,6046.28,997636.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','147',3506,'2','1',166175.87,167774.83,1598.96,263828.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','147',3507,'3','1',402135.62,406244.50,4108.88,677965.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','147',3508,'4','1',170568.57,171837.59,1269.02,209388.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','147',3509,'5','1',506015.71,511581.71,5566.00,918390.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','147',3510,'6','1',57655.97,57843.51,187.54,30944.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','147',3511,'7','1',360997.78,365807.68,4809.90,793633.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','147',3512,'8','1',173236.96,177086.39,3849.43,635155.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','147',3513,'9','1',319996.87,323624.61,3627.74,598577.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','147',3514,'10','1',108031.38,108949.56,918.18,151499.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','147',3515,'11','1',406215.11,411167.42,4952.31,817131.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','147',3516,'12','1',123471.61,123471.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','147',3517,'13','1',193517.78,197326.35,3808.57,628414.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','147',3518,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','147',3519,'15','1',213503.74,216579.02,3075.28,507421.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','147',3520,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','147',3521,'17','1',41062.00,44018.00,2956.00,487740.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','147',3522,'18','1',242872.59,242872.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','147',3523,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','147',3524,'20','1',234510.83,237801.77,3290.94,543005.10,0.00,0.00,0.00,0.00,0.00),('1','248','4','147',3525,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','147',3526,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','147',3527,'23','2',16684.20,19767.65,3083.45,2559263.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','147',3528,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','148',3529,'1','1',520659.39,526054.33,5394.94,890165.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','148',3530,'2','1',167774.83,168708.33,933.50,154027.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','148',3531,'3','1',406244.50,410126.74,3882.24,640569.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','148',3532,'4','1',171837.59,171837.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','148',3533,'5','1',511581.71,516942.78,5361.07,884576.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','148',3534,'6','1',57843.51,57843.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','148',3535,'7','1',365807.68,371633.49,5825.81,961258.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','148',3536,'8','1',177086.39,177678.94,592.55,97770.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','148',3537,'9','1',323624.61,329077.12,5452.51,899664.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','148',3538,'10','1',108949.56,108949.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','148',3539,'11','1',411167.42,415835.69,4668.27,770264.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','148',3540,'12','1',123471.61,123471.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','148',3541,'13','1',197326.35,197326.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','148',3542,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','148',3543,'15','1',216579.02,216579.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','148',3544,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','148',3545,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','148',3546,'18','1',242872.59,242872.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','148',3547,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','148',3548,'20','1',237801.77,237801.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','148',3549,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','148',3550,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','148',3551,'23','2',19767.65,20696.54,928.89,770978.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','148',3552,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','149',3553,'1','1',526054.33,529887.04,3832.71,632397.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','149',3554,'2','1',168708.33,172183.93,3475.60,573474.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','149',3555,'3','1',410126.74,413990.09,3863.35,637452.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','149',3556,'4','1',171837.59,176218.44,4380.85,722840.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','149',3557,'5','1',516942.78,521310.46,4367.68,720667.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','149',3558,'6','1',57843.51,62164.65,4321.14,712988.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','149',3559,'7','1',371633.49,371633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','149',3560,'8','1',177678.94,177678.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','149',3561,'9','1',329077.12,329077.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','149',3562,'10','1',108949.56,108949.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','149',3563,'11','1',415835.69,417780.25,1944.56,320852.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','149',3564,'12','1',123471.61,125036.20,1564.59,258157.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','149',3565,'13','1',197326.35,197326.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','149',3566,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','149',3567,'15','1',216579.02,216579.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','149',3568,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','149',3569,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','149',3570,'18','1',242872.59,242872.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','149',3571,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','149',3572,'20','1',237801.77,237801.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','149',3573,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','149',3574,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','149',3575,'23','2',20696.54,22499.70,1803.16,1496622.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','149',3576,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','150',3577,'1','1',529887.04,533546.01,3658.97,603730.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','150',3578,'2','1',172183.93,175873.93,3690.00,608850.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','150',3579,'3','1',413990.09,413990.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','150',3580,'4','1',176218.44,179863.17,3644.73,601380.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','150',3581,'5','1',521310.46,525287.75,3928.81,648253.65,0.00,0.00,48.48,0.00,0.00),('1','248','1','150',3582,'6','1',62164.65,62528.89,364.24,60099.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','150',3583,'7','1',371633.49,374340.91,2707.42,446724.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','150',3584,'8','1',177678.94,180930.58,3251.64,536520.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','150',3585,'9','1',329077.12,331536.38,2459.26,405777.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','150',3586,'10','1',108949.56,111556.38,2606.82,430125.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','150',3587,'11','1',417780.25,420905.60,3125.35,515682.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','150',3588,'12','1',125036.20,125379.56,343.36,56654.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','150',3589,'13','1',197326.35,197326.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','150',3590,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','150',3591,'15','1',216579.02,216579.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','150',3592,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','150',3593,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','150',3594,'18','1',242872.59,242872.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','150',3595,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','150',3596,'20','1',237801.77,237801.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','150',3597,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','150',3598,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','150',3599,'23','2',22499.70,23673.51,1173.81,974262.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','150',3600,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','151',3601,'1','1',533546.01,535577.21,2031.20,335148.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','151',3602,'2','1',175873.93,177379.88,1505.95,248481.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','151',3603,'3','1',413990.09,416429.20,2439.11,402453.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','151',3604,'4','1',179863.17,179863.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','151',3605,'5','1',525287.75,527220.08,1932.33,318834.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','151',3606,'6','1',62528.89,63680.11,1151.22,189951.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','151',3607,'7','1',374340.91,376124.39,1783.48,294274.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','151',3608,'8','1',180930.58,182705.83,1775.25,292916.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','151',3609,'9','1',331536.38,333734.08,2197.70,362620.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','151',3610,'10','1',111556.38,113180.06,1623.68,267907.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','151',3611,'11','1',420905.60,422657.90,1752.30,289129.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','151',3612,'12','1',125379.56,126817.03,1437.47,237182.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','151',3613,'13','1',197326.35,197326.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','151',3614,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','151',3615,'15','1',216579.02,216579.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','151',3616,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','151',3617,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','151',3618,'18','1',242872.59,242872.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','151',3619,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','151',3620,'20','1',237801.77,237801.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','151',3621,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','151',3622,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','151',3623,'23','2',23673.51,24666.82,993.31,824447.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','151',3624,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','152',3625,'1','1',535577.21,542217.73,6640.52,1095685.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','152',3626,'2','1',177379.88,177379.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','152',3627,'3','1',416429.20,419731.89,3302.69,544943.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','152',3628,'4','1',179863.17,179863.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','152',3629,'5','1',527220.08,533175.44,5955.36,982634.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','152',3630,'6','1',63680.11,63680.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','152',3631,'7','1',376124.39,382355.60,6231.21,1028149.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','152',3632,'8','1',182705.83,182705.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','152',3633,'9','1',333734.08,338215.75,4481.67,739475.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','152',3634,'10','1',113180.06,113180.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','152',3635,'11','1',422657.90,428248.69,5590.79,922480.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','152',3636,'12','1',126817.03,126817.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','152',3637,'13','1',197326.35,200815.44,3459.09,570749.85,0.00,0.00,30.00,0.00,0.00),('1','248','3','152',3638,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','152',3639,'15','1',216579.02,220732.92,4153.90,685393.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','152',3640,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','152',3641,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','152',3642,'18','1',242872.59,248122.50,5249.91,866235.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','152',3643,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','152',3644,'20','1',237801.77,242575.94,4774.17,787738.05,0.00,0.00,0.00,0.00,0.00),('1','248','4','152',3645,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','152',3646,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','152',3647,'23','2',24666.82,27535.64,2868.82,2381120.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','152',3648,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','153',3649,'1','1',542217.73,542217.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','153',3650,'2','1',177379.88,177379.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','153',3651,'3','1',419731.89,419731.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','153',3652,'4','1',179863.17,179863.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','153',3653,'5','1',533175.44,535217.94,2042.50,337012.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','153',3654,'6','1',63680.11,65612.34,1932.23,318817.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','153',3655,'7','1',382355.60,382355.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','153',3656,'8','1',182705.83,182705.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','153',3657,'9','1',338215.75,338215.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','153',3658,'10','1',113180.06,113180.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','153',3659,'11','1',428248.69,430158.07,1909.38,315047.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','153',3660,'12','1',126817.03,128557.86,1740.83,287236.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','153',3661,'13','1',200815.44,200815.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','153',3662,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','153',3663,'15','1',220732.92,220732.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','153',3664,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','153',3665,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','153',3666,'18','1',248122.50,249895.15,1772.65,292487.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','153',3667,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','153',3668,'20','1',242575.94,243049.75,473.81,78178.65,0.00,0.00,0.00,0.00,0.00),('1','248','4','153',3669,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','153',3670,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','153',3671,'23','2',27535.64,30930.73,3395.09,2817924.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','153',3672,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','154',3673,'1','1',542217.73,547529.07,5311.34,876371.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','154',3674,'2','1',177379.88,178950.42,1570.54,259139.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','154',3675,'3','1',419731.89,423909.15,4177.26,689247.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','154',3676,'4','1',179863.17,181434.40,1571.23,259252.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','154',3677,'5','1',535217.94,540894.86,5676.92,936691.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','154',3678,'6','1',65612.34,66768.67,1156.33,190794.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','154',3679,'7','1',382355.60,387651.92,5296.32,873892.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','154',3680,'8','1',182705.83,183311.37,605.54,99914.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','154',3681,'9','1',338215.75,343842.78,5627.03,928459.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','154',3682,'10','1',113180.06,113180.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','154',3683,'11','1',430158.07,433649.72,3491.65,576122.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','154',3684,'12','1',128557.86,128557.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','154',3685,'13','1',200815.44,205023.50,4208.06,694329.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','154',3686,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','154',3687,'15','1',220732.92,223719.39,2986.47,492767.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','154',3688,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','154',3689,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','154',3690,'18','1',249895.15,254022.05,4126.90,680938.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','154',3691,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','154',3692,'20','1',243049.75,246858.22,3808.47,628397.55,0.00,0.00,0.00,0.00,0.00),('1','248','4','154',3693,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','154',3694,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','154',3695,'23','2',30930.73,31758.11,827.38,686725.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','154',3696,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','155',3697,'1','1',547529.07,549792.24,2243.17,370123.05,0.00,0.00,20.00,0.00,0.00),('1','248','1','155',3698,'2','1',178950.42,180885.87,1915.45,316049.25,0.00,0.00,20.00,0.00,0.00),('1','248','1','155',3699,'3','1',423909.15,427060.84,3131.69,516728.85,0.00,0.00,20.00,0.00,0.00),('1','248','1','155',3700,'4','1',181434.40,184550.83,3096.43,510910.95,0.00,0.00,20.00,0.00,0.00),('1','248','1','155',3701,'5','1',540894.86,540981.50,86.64,14295.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','155',3702,'6','1',66768.67,66768.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','155',3703,'7','1',387651.92,387651.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','155',3704,'8','1',183311.37,183311.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','155',3705,'9','1',343842.78,343842.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','155',3706,'10','1',113180.06,113180.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','155',3707,'11','1',433649.72,433649.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','155',3708,'12','1',128557.86,128557.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','155',3709,'13','1',205023.50,205023.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','155',3710,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','155',3711,'15','1',223719.39,223719.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','155',3712,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','155',3713,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','155',3714,'18','1',254022.05,254022.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','155',3715,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','155',3716,'20','1',246858.22,246858.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','155',3717,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','155',3718,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','155',3719,'23','2',31758.11,33525.83,1767.72,1467207.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','155',3720,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','156',3721,'1','1',549792.24,549792.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','156',3722,'2','1',180885.87,180885.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','156',3723,'3','1',427060.84,427060.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','156',3724,'4','1',184550.83,184550.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','156',3725,'5','1',540981.50,540981.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','156',3726,'6','1',66768.67,66768.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','156',3727,'7','1',387651.92,387651.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','156',3728,'8','1',183311.37,183311.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','156',3729,'9','1',343842.78,343842.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','156',3730,'10','1',113180.06,113180.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','156',3731,'11','1',433649.72,433649.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','156',3732,'12','1',128557.86,128557.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','156',3733,'13','1',205023.50,205023.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','156',3734,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','156',3735,'15','1',223719.39,223719.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','156',3736,'16','1',59247.87,59247.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','156',3737,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','156',3738,'18','1',254022.05,254022.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','156',3739,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','156',3740,'20','1',246858.22,246858.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','156',3741,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','156',3742,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','156',3743,'23','2',33525.83,34143.27,617.44,512475.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','156',3744,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','157',3745,'1','1',549792.24,554022.21,4229.97,697945.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','157',3746,'2','1',180885.87,185604.08,4718.21,778504.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','157',3747,'3','1',427060.84,431532.45,4451.61,734515.65,0.00,0.00,20.00,0.00,0.00),('1','248','1','157',3748,'4','1',184550.83,186060.32,1489.49,245765.85,0.00,0.00,20.00,0.00,0.00),('1','248','1','157',3749,'5','1',540981.50,545800.59,4799.09,791849.85,0.00,0.00,20.00,0.00,0.00),('1','248','1','157',3750,'6','1',66768.67,66979.12,190.45,31424.25,0.00,0.00,20.00,0.00,0.00),('1','248','2','157',3751,'7','1',387651.92,391299.07,3633.21,599479.65,0.00,0.00,13.94,0.00,0.00),('1','248','2','157',3752,'8','1',183311.37,186654.03,3342.66,551538.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','157',3753,'9','1',343842.78,347748.82,3906.04,644496.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','157',3754,'10','1',113180.06,116656.06,3476.00,573540.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','157',3755,'11','1',433649.72,436591.09,2941.37,485326.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','157',3756,'12','1',128557.86,131013.82,2455.96,405233.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','157',3757,'13','1',205023.50,209656.97,4633.47,764522.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','157',3758,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','157',3759,'15','1',223719.39,229318.85,5599.46,923910.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','157',3760,'16','1',59247.87,60179.96,932.09,153794.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','157',3761,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','157',3762,'18','1',254022.05,258351.62,4329.57,714379.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','157',3763,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','157',3764,'20','1',246858.22,251487.75,4629.53,763872.45,0.00,0.00,0.00,0.00,0.00),('1','248','4','157',3765,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','157',3766,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','157',3767,'23','2',34143.27,40529.63,6386.36,5300678.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','157',3768,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','158',3769,'1','1',554022.21,556549.74,2527.53,417042.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','158',3770,'2','1',185604.08,188283.91,2679.83,442171.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','158',3771,'3','1',431532.45,433008.21,1475.76,243500.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','158',3772,'4','1',186060.32,186266.91,206.59,34087.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','158',3773,'5','1',545800.59,548281.23,2480.64,409305.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','158',3774,'6','1',66979.12,69214.38,2235.26,368817.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','158',3775,'7','1',391299.07,393686.79,2387.72,393973.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','158',3776,'8','1',186654.03,188754.33,2100.30,346549.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','158',3777,'9','1',347748.82,350170.13,2421.31,399516.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','158',3778,'10','1',116656.06,118608.60,1952.54,322169.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','158',3779,'11','1',436591.09,439223.71,2632.62,434382.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','158',3780,'12','1',131013.82,133525.89,2512.07,414491.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','158',3781,'13','1',209656.97,209656.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','158',3782,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','158',3783,'15','1',229318.85,229318.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','158',3784,'16','1',60179.96,60179.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','158',3785,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','158',3786,'18','1',258351.62,258351.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','158',3787,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','158',3788,'20','1',251487.75,251487.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','158',3789,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','158',3790,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','158',3791,'23','2',40529.63,40529.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','158',3792,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','159',3793,'1','1',556549.74,559711.30,3161.56,521657.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','159',3794,'2','1',188283.91,191758.57,3474.66,573318.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','159',3795,'3','1',433008.21,436871.28,3863.07,637406.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','159',3796,'4','1',186266.91,188844.33,2577.42,425274.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','159',3797,'5','1',548281.23,551253.54,2972.31,490431.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','159',3798,'6','1',69214.38,71524.09,2309.71,381102.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','159',3799,'7','1',393686.79,393686.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','159',3800,'8','1',188754.33,188754.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','159',3801,'9','1',350170.13,350170.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','159',3802,'10','1',118608.60,118608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','159',3803,'11','1',439223.71,440205.76,982.05,162038.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','159',3804,'12','1',133525.89,133525.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','159',3805,'13','1',209656.97,209656.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','159',3806,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','159',3807,'15','1',229318.85,229318.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','159',3808,'16','1',60179.96,60179.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','159',3809,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','159',3810,'18','1',258351.62,258351.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','159',3811,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','159',3812,'20','1',251487.75,251487.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','159',3813,'21','2',171398.86,171398.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','159',3814,'22','2',103379.70,103379.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','159',3815,'23','2',40529.63,40529.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','159',3816,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','160',3817,'1','1',559711.30,562814.15,3102.85,511970.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','160',3818,'2','1',191758.57,195543.94,3765.37,621286.05,0.00,0.00,20.00,0.00,0.00),('1','248','1','160',3819,'3','1',436871.28,440168.76,3297.48,544084.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','160',3820,'4','1',188844.33,192128.64,3284.31,541911.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','160',3821,'5','1',551253.54,554951.91,3698.37,610231.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','160',3822,'6','1',71524.09,71524.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','160',3823,'7','1',393686.79,397562.99,3876.20,639573.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','160',3824,'8','1',188754.33,192020.38,3235.75,533898.75,0.00,0.00,30.30,0.00,0.00),('1','248','2','160',3825,'9','1',350170.13,353331.16,3161.03,521569.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','160',3826,'10','1',118608.60,118608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','160',3827,'11','1',440205.76,444313.22,4107.46,677730.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','160',3828,'12','1',133525.89,134990.57,1464.68,241672.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','160',3829,'13','1',209656.97,209656.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','160',3830,'14','1',81211.97,81211.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','160',3831,'15','1',229318.85,229318.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','160',3832,'16','1',60179.96,60179.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','160',3833,'17','1',44018.00,44018.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','160',3834,'18','1',258351.62,258351.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','160',3835,'19','1',48926.99,48926.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','160',3836,'20','1',251487.75,251487.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','160',3837,'21','2',171398.86,171522.36,123.50,102505.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','160',3838,'22','2',103379.70,103381.45,1.75,1452.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','160',3839,'23','2',40529.63,45523.66,4994.03,4145044.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','160',3840,'24','2',465.14,465.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','161',3841,'1','1',562814.15,564114.73,1300.58,214595.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','161',3842,'2','1',195543.94,195543.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','161',3843,'3','1',440168.76,440168.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','161',3844,'4','1',192128.64,192128.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','161',3845,'5','1',554951.91,556354.20,1402.29,231377.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','161',3846,'6','1',71524.09,71524.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','161',3847,'7','1',397562.99,399816.21,2253.22,371781.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','161',3848,'8','1',192020.38,192020.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','161',3849,'9','1',353331.16,353331.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','161',3850,'10','1',118608.60,118608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','161',3851,'11','1',444313.22,446065.97,1752.75,289203.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','161',3852,'12','1',134990.57,134990.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','161',3853,'13','1',209656.97,213197.63,3540.66,584208.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','161',3854,'14','1',81211.97,83633.86,2421.89,399611.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','161',3855,'15','1',229318.85,232040.15,2721.30,449014.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','161',3856,'16','1',60179.96,61522.14,1342.18,221459.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','161',3857,'17','1',44018.00,47110.07,3092.07,510191.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','161',3858,'18','1',258351.62,261607.48,3255.86,537216.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','161',3859,'19','1',48926.99,50521.21,1594.22,263046.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','161',3860,'20','1',251487.75,253590.37,2102.62,346932.30,0.00,0.00,0.00,0.00,0.00),('1','248','4','161',3861,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','161',3862,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','161',3863,'23','2',45523.66,47974.09,2430.43,2017256.90,0.00,0.00,20.00,0.00,0.00),('1','248','5','161',3864,'24','2',465.14,468.29,3.15,2614.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','162',3865,'1','1',564114.73,567017.57,2902.84,478968.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','162',3866,'2','1',195543.94,198525.22,2981.28,491911.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','162',3867,'3','1',440168.76,442317.19,2148.43,354490.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','162',3868,'4','1',192128.64,195153.24,3024.60,499059.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','162',3869,'5','1',556354.20,558294.72,1910.22,315186.30,0.00,0.00,30.30,0.00,0.00),('1','248','1','162',3870,'6','1',71524.09,74008.98,2484.89,410006.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','162',3871,'7','1',399816.21,399816.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','162',3872,'8','1',192020.38,192020.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','162',3873,'9','1',353331.16,353331.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','162',3874,'10','1',118608.60,118608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','162',3875,'11','1',446065.97,446065.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','162',3876,'12','1',134990.57,134990.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','162',3877,'13','1',213197.63,213405.33,207.70,34270.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','162',3878,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','162',3879,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','162',3880,'16','1',61522.14,61957.87,435.73,71895.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','162',3881,'17','1',47110.07,50461.11,3351.04,552921.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','162',3882,'18','1',261607.48,265023.25,3415.77,563602.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','162',3883,'19','1',50521.21,53889.00,3367.79,555685.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','162',3884,'20','1',253590.37,257047.01,3456.64,570345.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','162',3885,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','162',3886,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','162',3887,'23','2',47974.09,48743.05,768.96,638236.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','162',3888,'24','2',468.29,468.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','163',3889,'1','1',567017.57,571508.44,4490.87,740993.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','163',3890,'2','1',198525.22,198525.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','163',3891,'3','1',442317.19,444933.38,2616.19,431671.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','163',3892,'4','1',195153.24,198325.07,3171.83,523351.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','163',3893,'5','1',558294.72,562270.42,3957.52,652990.80,0.00,0.00,18.18,0.00,0.00),('1','248','1','163',3894,'6','1',74008.98,74008.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','163',3895,'7','1',399816.21,404020.34,4204.13,693681.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','163',3896,'8','1',192020.38,192020.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','163',3897,'9','1',353331.16,357285.93,3954.77,652537.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','163',3898,'10','1',118608.60,119012.15,403.55,66585.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','163',3899,'11','1',446065.97,450249.00,4183.03,690199.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','163',3900,'12','1',134990.57,135017.45,26.88,4435.20,0.00,0.00,0.00,0.00,0.00),('1','248','3','163',3901,'13','1',213405.33,213405.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','163',3902,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','163',3903,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','163',3904,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','163',3905,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','163',3906,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','163',3907,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','163',3908,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','163',3909,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','163',3910,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','163',3911,'23','2',48743.05,50889.57,2146.52,1781611.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','163',3912,'24','2',468.29,468.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','164',3913,'1','1',571508.44,575437.33,3928.89,648266.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','164',3914,'2','1',198525.22,203178.20,4652.98,767741.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','164',3915,'3','1',444933.38,447162.12,2208.74,364442.10,0.00,0.00,20.00,0.00,0.00),('1','248','1','164',3916,'4','1',198325.07,199866.69,1521.62,251067.30,0.00,0.00,20.00,0.00,0.00),('1','248','1','164',3917,'5','1',562270.42,564210.23,1919.81,316768.65,0.00,0.00,20.00,0.00,0.00),('1','248','1','164',3918,'6','1',74008.98,75546.60,1524.56,251552.40,0.00,0.00,13.06,0.00,0.00),('1','248','2','164',3919,'7','1',404020.34,404020.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','164',3920,'8','1',192020.38,192020.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','164',3921,'9','1',357285.93,357285.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','164',3922,'10','1',119012.15,119012.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','164',3923,'11','1',450249.00,451526.81,1277.81,210838.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','164',3924,'12','1',135017.45,135901.43,883.98,145856.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','164',3925,'13','1',213405.33,213405.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','164',3926,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','164',3927,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','164',3928,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','164',3929,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','164',3930,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','164',3931,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','164',3932,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','164',3933,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','164',3934,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','164',3935,'23','2',50889.57,50889.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','164',3936,'24','2',468.29,468.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','165',3937,'1','1',575437.33,581392.05,5954.72,982528.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','165',3938,'2','1',203178.20,203178.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','165',3939,'3','1',447162.12,452053.36,4891.24,807054.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','165',3940,'4','1',199866.69,199866.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','165',3941,'5','1',564210.23,569636.59,5377.88,887350.20,0.00,0.00,48.48,0.00,0.00),('1','248','1','165',3942,'6','1',75546.60,75702.38,155.78,25703.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','165',3943,'7','1',404020.34,407521.25,3500.91,577650.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','165',3944,'8','1',192020.38,195904.13,3883.75,640818.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','165',3945,'9','1',357285.93,362144.03,4858.10,801586.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','165',3946,'10','1',119012.15,119012.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','165',3947,'11','1',451526.81,456636.94,5110.13,843171.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','165',3948,'12','1',135901.43,135901.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','165',3949,'13','1',213405.33,213405.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','165',3950,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','165',3951,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','165',3952,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','165',3953,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','165',3954,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','165',3955,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','165',3956,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','165',3957,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','165',3958,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','165',3959,'23','2',50889.57,54036.02,3146.45,2611553.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','165',3960,'24','2',468.29,478.34,0.00,0.00,0.00,0.00,10.05,0.00,0.00),('1','248','1','166',3961,'1','1',581392.05,585212.48,3820.43,630370.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','166',3962,'2','1',203178.20,206465.00,3286.80,542322.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','166',3963,'3','1',452053.36,455316.84,3263.48,538474.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','166',3964,'4','1',199866.69,199866.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','166',3965,'5','1',569636.59,571731.23,2094.64,345615.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','166',3966,'6','1',75702.38,76860.70,1158.32,191122.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','166',3967,'7','1',407521.25,411803.56,4282.31,706581.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','166',3968,'8','1',195904.13,195934.37,30.24,4989.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','166',3969,'9','1',362144.03,366249.42,4105.39,677389.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','166',3970,'10','1',119012.15,119012.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','166',3971,'11','1',456636.94,460742.05,4105.11,677343.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','166',3972,'12','1',135901.43,135901.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','166',3973,'13','1',213405.33,213405.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','166',3974,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','166',3975,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','166',3976,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','166',3977,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','166',3978,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','166',3979,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','166',3980,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','166',3981,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','166',3982,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','166',3983,'23','2',54036.02,54036.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','166',3984,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','167',3985,'1','1',585212.48,589942.23,4729.75,780408.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','167',3986,'2','1',206465.00,207841.85,1376.85,227180.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','167',3987,'3','1',455316.84,460243.41,4926.57,812884.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','167',3988,'4','1',199866.69,199866.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','167',3989,'5','1',571731.23,576451.44,4720.21,778834.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','167',3990,'6','1',76860.70,76860.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','167',3991,'7','1',411803.56,415783.39,3979.83,656671.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','167',3992,'8','1',195934.37,200488.51,4554.14,751433.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','167',3993,'9','1',366249.42,369696.56,3447.14,568778.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','167',3994,'10','1',119012.15,122767.94,3755.79,619705.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','167',3995,'11','1',460742.05,465770.07,5028.02,829623.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','167',3996,'12','1',135901.43,135901.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','167',3997,'13','1',213405.33,213405.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','167',3998,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','167',3999,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','167',4000,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','167',4001,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','167',4002,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','167',4003,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','167',4004,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','167',4005,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','167',4006,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','167',4007,'23','2',54036.02,58399.80,4363.78,3621937.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','167',4008,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','168',4009,'1','1',589942.23,593699.56,3757.33,619959.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','168',4010,'2','1',207841.85,210105.22,2263.37,373456.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','168',4011,'3','1',460243.41,463512.33,3268.92,539371.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','168',4012,'4','1',199866.69,201994.15,2127.46,351030.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','168',4013,'5','1',576451.44,579023.98,2572.54,424469.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','168',4014,'6','1',76860.70,76860.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','168',4015,'7','1',415783.39,417976.69,2193.30,361894.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','168',4016,'8','1',200488.51,202459.64,1971.13,325236.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','168',4017,'9','1',369696.56,372067.62,2371.06,391224.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','168',4018,'10','1',122767.94,122804.90,36.96,6098.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','168',4019,'11','1',465770.07,468153.50,2383.43,393265.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','168',4020,'12','1',135901.43,135901.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','168',4021,'13','1',213405.33,213472.50,67.17,11083.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','168',4022,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','168',4023,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','168',4024,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','168',4025,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','168',4026,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','168',4027,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','168',4028,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','168',4029,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','168',4030,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','168',4031,'23','2',58399.80,58650.42,250.62,208014.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','168',4032,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','169',4033,'1','1',593699.56,599365.67,5633.38,929507.70,0.00,0.00,32.73,0.00,0.00),('1','248','1','169',4034,'2','1',210105.22,213154.97,3049.75,503208.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','169',4035,'3','1',463512.33,464638.04,1125.71,185742.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','169',4036,'4','1',201994.15,202742.24,748.09,123434.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','169',4037,'5','1',579023.98,582765.20,3741.22,617301.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','169',4038,'6','1',76860.70,78128.08,1267.38,209117.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','169',4039,'7','1',417976.69,422419.97,4443.28,733141.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','169',4040,'8','1',202459.64,205331.22,2871.58,473810.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','169',4041,'9','1',372067.62,372067.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','169',4042,'10','1',122804.90,122804.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','169',4043,'11','1',468153.50,473106.07,4952.57,817174.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','169',4044,'12','1',135901.43,137699.23,1797.80,296637.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','169',4045,'13','1',213472.50,213596.52,124.02,20463.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','169',4046,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','169',4047,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','169',4048,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','169',4049,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','169',4050,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','169',4051,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','169',4052,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','169',4053,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','169',4054,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','169',4055,'23','2',58650.42,62165.34,3514.92,2917383.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','169',4056,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','170',4057,'1','1',599365.67,603320.17,3954.50,652492.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','170',4058,'2','1',213154.97,217215.33,4060.36,669959.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','170',4059,'3','1',464638.04,464638.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','170',4060,'4','1',202742.24,205884.77,3142.53,518517.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','170',4061,'5','1',582765.20,586382.79,3617.59,596902.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','170',4062,'6','1',78128.08,78543.32,415.24,68514.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','170',4063,'7','1',422419.97,425913.72,3493.75,576468.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','170',4064,'8','1',205331.22,208313.55,2982.33,492084.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','170',4065,'9','1',372067.62,375533.45,3465.83,571861.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','170',4066,'10','1',122804.90,124091.81,1286.91,212340.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','170',4067,'11','1',473106.07,476997.05,3890.98,642011.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','170',4068,'12','1',137699.23,137699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','170',4069,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','170',4070,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','170',4071,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','170',4072,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','170',4073,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','170',4074,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','170',4075,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','170',4076,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','170',4077,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','170',4078,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','170',4079,'23','2',62165.34,64359.92,2194.58,1821501.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','170',4080,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','171',4081,'1','1',603320.17,606060.40,2740.23,452137.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','171',4082,'2','1',217215.33,220102.37,2887.04,476361.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','171',4083,'3','1',464638.04,467893.55,3255.51,537159.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','171',4084,'4','1',205884.77,206622.21,737.44,121677.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','171',4085,'5','1',586382.79,589999.46,3616.67,596750.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','171',4086,'6','1',78543.32,79955.39,1412.07,232991.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','171',4087,'7','1',425913.72,425913.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','171',4088,'8','1',208313.55,208313.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','171',4089,'9','1',375533.45,375533.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','171',4090,'10','1',124091.81,124091.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','171',4091,'11','1',476997.05,476997.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','171',4092,'12','1',137699.23,137699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','171',4093,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','171',4094,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','171',4095,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','171',4096,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','171',4097,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','171',4098,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','171',4099,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','171',4100,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','171',4101,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','171',4102,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','171',4103,'23','2',64359.92,66267.73,1907.81,1583482.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','171',4104,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','172',4105,'1','1',606060.40,611291.48,5231.08,863128.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','172',4106,'2','1',220102.37,224621.73,4519.36,745694.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','172',4107,'3','1',467893.55,471752.01,3858.46,636645.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','172',4108,'4','1',206622.21,209964.90,3342.69,551543.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','172',4109,'5','1',589999.46,595873.88,5874.42,969279.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','172',4110,'6','1',79955.39,81470.85,1515.46,250050.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','172',4111,'7','1',425913.72,430962.34,5048.62,833022.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','172',4112,'8','1',208313.55,210646.52,2332.97,384940.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','172',4113,'9','1',375533.45,380110.28,4576.83,755176.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','172',4114,'10','1',124091.81,125911.46,1819.65,300242.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','172',4115,'11','1',476997.05,481165.92,4168.87,687863.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','172',4116,'12','1',137699.23,139766.62,2067.39,341119.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','172',4117,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','172',4118,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','172',4119,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','172',4120,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','172',4121,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','172',4122,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','172',4123,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','172',4124,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','172',4125,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','172',4126,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','172',4127,'23','2',66267.73,67457.01,1189.28,987102.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','172',4128,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','173',4129,'1','1',611291.48,613549.37,2257.89,417709.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','173',4130,'2','1',224621.73,227577.92,2956.19,546895.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','173',4131,'3','1',471752.01,473812.90,2060.89,381264.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','173',4132,'4','1',209964.90,211918.60,1953.70,361434.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','173',4133,'5','1',595873.88,598821.16,2947.28,545246.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','173',4134,'6','1',81470.85,84380.74,2909.89,538329.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','173',4135,'7','1',430962.34,430962.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','173',4136,'8','1',210646.52,210646.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','173',4137,'9','1',380110.28,380110.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','173',4138,'10','1',125911.46,125911.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','173',4139,'11','1',481165.92,481165.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','173',4140,'12','1',139766.62,139766.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','173',4141,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','173',4142,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','173',4143,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','173',4144,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','173',4145,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','173',4146,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','173',4147,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','173',4148,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','173',4149,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','173',4150,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','173',4151,'23','2',67457.01,67457.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','173',4152,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','174',4153,'1','1',613549.37,616862.77,3313.40,612979.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','174',4154,'2','1',227577.92,231030.66,3452.74,638756.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','174',4155,'3','1',473812.90,476433.61,2620.71,484831.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','174',4156,'4','1',211918.60,213864.29,1945.69,359952.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','174',4157,'5','1',598821.16,603103.58,4282.42,792247.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','174',4158,'6','1',84380.74,84380.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','174',4159,'7','1',430962.34,434136.72,3174.38,587260.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','174',4160,'8','1',210646.52,214649.53,4003.01,740556.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','174',4161,'9','1',380110.28,382854.51,2744.23,507682.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','174',4162,'10','1',125911.46,128144.28,2232.82,413071.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','174',4163,'11','1',481165.92,484523.48,3357.56,621148.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','174',4164,'12','1',139766.62,143323.63,3557.01,658046.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','174',4165,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','174',4166,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','174',4167,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','174',4168,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','174',4169,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','174',4170,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','174',4171,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','174',4172,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','174',4173,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','174',4174,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','174',4175,'23','2',67457.01,69663.45,2206.44,1831345.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','174',4176,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','175',4177,'1','1',616862.77,620284.19,3421.42,632962.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','175',4178,'2','1',231030.66,233578.10,2547.44,471276.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','175',4179,'3','1',476433.61,478054.82,1621.21,299923.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','175',4180,'4','1',213864.29,216589.45,2725.16,504154.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','175',4181,'5','1',603103.58,606609.13,3505.55,648526.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','175',4182,'6','1',84380.74,84734.54,353.80,65453.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','175',4183,'7','1',434136.72,436656.49,2519.77,466157.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','175',4184,'8','1',214649.53,217361.54,2712.01,501721.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','175',4185,'9','1',382854.51,382854.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','175',4186,'10','1',128144.28,131181.51,3037.23,561887.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','175',4187,'11','1',484523.48,486486.73,1963.25,363201.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','175',4188,'12','1',143323.63,143702.37,378.74,70066.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','175',4189,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','175',4190,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','175',4191,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','175',4192,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','175',4193,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','175',4194,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','175',4195,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','175',4196,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','175',4197,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','175',4198,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','175',4199,'23','2',69663.45,69663.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','175',4200,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','176',4201,'1','1',620284.19,620284.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','176',4202,'2','1',233578.10,233578.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','176',4203,'3','1',478054.82,478054.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','176',4204,'4','1',216589.45,216589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','176',4205,'5','1',606609.13,606609.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','176',4206,'6','1',84734.54,84734.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','176',4207,'7','1',436656.49,436656.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','176',4208,'8','1',217361.54,217361.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','176',4209,'9','1',382854.51,382854.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','176',4210,'10','1',131181.51,131181.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','176',4211,'11','1',486486.73,486486.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','176',4212,'12','1',143702.37,143702.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','176',4213,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','176',4214,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','176',4215,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','176',4216,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','176',4217,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','176',4218,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','176',4219,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','176',4220,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','176',4221,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','176',4222,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','176',4223,'23','2',69663.45,70540.03,876.58,727561.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','176',4224,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','177',4225,'1','1',620284.19,623276.37,2992.18,553553.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','177',4226,'2','1',233578.10,236484.25,2906.15,537637.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','177',4227,'3','1',478054.82,480613.69,2558.87,473390.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','177',4228,'4','1',216589.45,219470.21,2880.76,532940.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','177',4229,'5','1',606609.13,609385.91,2746.50,508102.50,0.00,0.00,30.28,0.00,0.00),('1','248','1','177',4230,'6','1',84734.54,87602.95,2868.41,530655.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','177',4231,'7','1',436656.49,436656.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','177',4232,'8','1',217361.54,217361.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','177',4233,'9','1',382854.51,382854.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','177',4234,'10','1',131181.51,131181.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','177',4235,'11','1',486486.73,486486.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','177',4236,'12','1',143702.37,143702.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','177',4237,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','177',4238,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','177',4239,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','177',4240,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','177',4241,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','177',4242,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','177',4243,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','177',4244,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','177',4245,'21','2',171522.36,171522.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','177',4246,'22','2',103381.45,103381.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','177',4247,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','177',4248,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','178',4249,'1','1',623276.37,626970.42,3694.05,683399.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','178',4250,'2','1',236484.25,239839.85,3355.60,620786.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','178',4251,'3','1',480613.69,483404.67,2790.98,516331.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','178',4252,'4','1',219470.21,221152.48,1682.27,311219.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','178',4253,'5','1',609385.91,613697.29,4311.38,797605.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','178',4254,'6','1',87602.95,87602.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','178',4255,'7','1',436656.49,440163.40,3506.91,648778.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','178',4256,'8','1',217361.54,220829.58,3468.04,641587.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','178',4257,'9','1',382854.51,386742.94,3888.43,719359.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','178',4258,'10','1',131181.51,133759.43,2577.92,476915.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','178',4259,'11','1',486486.73,490731.94,4245.21,785363.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','178',4260,'12','1',143702.37,143907.44,205.07,37937.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','178',4261,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','178',4262,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','178',4263,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','178',4264,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','178',4265,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','178',4266,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','178',4267,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','178',4268,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','178',4269,'21','2',171522.36,172687.81,1165.45,967323.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','178',4270,'22','2',103381.45,103484.98,103.53,85929.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','178',4271,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','178',4272,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','179',4273,'1','1',626970.42,629143.63,2173.21,402043.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','179',4274,'2','1',239839.85,242031.85,2192.00,405520.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','179',4275,'3','1',483404.67,485237.11,1832.44,339001.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','179',4276,'4','1',221152.48,223279.19,2126.71,393441.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','179',4277,'5','1',613697.29,616218.04,2520.75,466338.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','179',4278,'6','1',87602.95,88966.75,1363.80,252303.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','179',4279,'7','1',440163.40,441184.42,1021.02,188888.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','179',4280,'8','1',220829.58,221664.09,834.51,154384.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','179',4281,'9','1',386742.94,387815.50,1072.56,198423.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','179',4282,'10','1',133759.43,133910.96,151.53,28033.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','179',4283,'11','1',490731.94,491750.04,1018.10,188348.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','179',4284,'12','1',143907.44,143907.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','179',4285,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','179',4286,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','179',4287,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','179',4288,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','179',4289,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','179',4290,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','179',4291,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','179',4292,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','179',4293,'21','2',172687.81,173793.45,1105.64,917681.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','179',4294,'22','2',103484.98,103784.98,300.00,249000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','179',4295,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','179',4296,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','180',4297,'1','1',629143.63,632462.52,3318.89,613994.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','180',4298,'2','1',242031.85,245005.75,2973.90,550171.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','180',4299,'3','1',485237.11,488423.82,3186.71,589541.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','180',4300,'4','1',223279.19,224789.35,1510.16,279379.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','180',4301,'5','1',616218.04,620318.44,4100.40,758574.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','180',4302,'6','1',88966.75,88966.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','180',4303,'7','1',441184.42,444813.86,3629.44,671446.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','180',4304,'8','1',221664.09,225122.47,3458.38,639800.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','180',4305,'9','1',387815.50,392383.58,4568.08,845094.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','180',4306,'10','1',133910.96,134146.85,235.89,43639.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','180',4307,'11','1',491750.04,495306.47,3556.43,657939.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','180',4308,'12','1',143907.44,143907.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','180',4309,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','180',4310,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','180',4311,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','180',4312,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','180',4313,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','180',4314,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','180',4315,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','180',4316,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','180',4317,'21','2',173793.45,174287.43,493.98,410003.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','180',4318,'22','2',103784.98,103784.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','180',4319,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','180',4320,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','181',4321,'1','1',632462.52,635748.17,3285.65,607845.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','181',4322,'2','1',245005.75,248266.13,3260.38,603170.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','181',4323,'3','1',488423.82,490928.04,2504.22,463280.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','181',4324,'4','1',224789.35,227445.26,2655.91,491343.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','181',4325,'5','1',620318.44,623515.60,3197.16,591474.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','181',4326,'6','1',88966.75,91711.08,2744.33,507701.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','181',4327,'7','1',444813.86,444867.93,54.07,10002.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','181',4328,'8','1',225122.47,225122.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','181',4329,'9','1',392383.58,392383.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','181',4330,'10','1',134146.85,134146.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','181',4331,'11','1',495306.47,496137.48,831.01,153736.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','181',4332,'12','1',143907.44,144556.08,648.64,119998.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','181',4333,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','181',4334,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','181',4335,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','181',4336,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','181',4337,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','181',4338,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','181',4339,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','181',4340,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','181',4341,'21','2',174287.43,175676.15,1388.72,1152637.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','181',4342,'22','2',103784.98,103784.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','181',4343,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','181',4344,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','182',4345,'1','1',635748.17,639067.13,3318.96,614007.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','182',4346,'2','1',248266.13,251596.91,3330.78,616194.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','182',4347,'3','1',490928.04,494907.62,3979.58,736222.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','182',4348,'4','1',227445.26,227445.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','182',4349,'5','1',623515.60,627655.95,4140.35,765964.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','182',4350,'6','1',91711.08,91711.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','182',4351,'7','1',444867.93,448868.51,4000.58,740107.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','182',4352,'8','1',225122.47,228193.56,3071.09,568151.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','182',4353,'9','1',392383.58,396746.37,4362.79,807116.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','182',4354,'10','1',134146.85,134652.67,505.82,93576.70,0.00,0.00,0.00,0.00,0.00),('1','248','2','182',4355,'11','1',496137.48,500245.96,4108.48,760068.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','182',4356,'12','1',144556.08,144556.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','182',4357,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','182',4358,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','182',4359,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','182',4360,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','182',4361,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','182',4362,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','182',4363,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','182',4364,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','182',4365,'21','2',175676.15,177495.91,1819.76,1510400.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','182',4366,'22','2',103784.98,103784.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','182',4367,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','182',4368,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','183',4369,'1','1',639067.13,642238.57,3171.44,586716.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','183',4370,'2','1',251596.91,254941.90,3344.99,618823.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','183',4371,'3','1',494907.62,497747.68,2840.06,525411.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','183',4372,'4','1',227445.26,230186.20,2740.94,507073.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','183',4373,'5','1',627655.95,630602.11,2946.16,545039.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','183',4374,'6','1',91711.08,94634.09,2923.01,540756.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','183',4375,'7','1',448868.51,448868.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','183',4376,'8','1',228193.56,228193.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','183',4377,'9','1',396746.37,396746.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','183',4378,'10','1',134652.67,134652.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','183',4379,'11','1',500245.96,500836.51,590.55,109251.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','183',4380,'12','1',144556.08,145051.83,495.75,91713.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','183',4381,'13','1',213596.52,213596.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','183',4382,'14','1',83633.86,83633.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','183',4383,'15','1',232040.15,232040.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','183',4384,'16','1',61957.87,61957.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','183',4385,'17','1',50461.11,50461.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','183',4386,'18','1',265023.25,265023.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','183',4387,'19','1',53889.00,53889.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','183',4388,'20','1',257047.01,257047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','183',4389,'21','2',177495.91,178300.26,804.35,667610.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','183',4390,'22','2',103784.98,103784.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','183',4391,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','183',4392,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','184',4393,'1','1',642238.57,644646.61,2408.04,445487.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','184',4394,'2','1',254941.90,257401.68,2459.78,455059.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','184',4395,'3','1',497747.68,500112.30,2364.62,437454.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','184',4396,'4','1',230186.20,232764.85,2578.65,477050.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','184',4397,'5','1',630602.11,633084.88,2482.77,459312.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','184',4398,'6','1',94634.09,97382.16,2748.07,508392.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','184',4399,'7','1',448868.51,448868.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','184',4400,'8','1',228193.56,228193.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','184',4401,'9','1',396746.37,396746.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','184',4402,'10','1',134652.67,134652.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','184',4403,'11','1',500836.51,500836.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','184',4404,'12','1',145051.83,145051.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','184',4405,'13','1',213596.52,216487.58,2891.06,534846.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','184',4406,'14','1',83633.86,84442.54,808.68,149605.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','184',4407,'15','1',232040.15,235366.30,3326.15,615337.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','184',4408,'16','1',61957.87,62510.03,545.67,100948.95,0.00,0.00,6.49,0.00,0.00),('1','248','3','184',4409,'17','1',50461.11,51475.24,1014.13,187614.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','184',4410,'18','1',265023.25,267216.56,2193.31,405762.35,0.00,0.00,0.00,0.00,0.00),('1','248','3','184',4411,'19','1',53889.00,54732.89,843.89,156119.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','184',4412,'20','1',257047.01,259875.33,2828.32,523239.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','184',4413,'21','2',178300.26,179134.77,834.51,692643.30,0.00,0.00,0.00,0.00,0.00),('1','248','4','184',4414,'22','2',103784.98,103784.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','184',4415,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','184',4416,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','185',4417,'1','1',644646.61,648888.26,4241.65,784705.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','185',4418,'2','1',257401.68,259382.16,1980.48,366388.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','185',4419,'3','1',500112.30,504895.67,4783.37,884923.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','185',4420,'4','1',232764.85,232764.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','185',4421,'5','1',633084.88,637763.11,4678.23,865472.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','185',4422,'6','1',97382.16,97382.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','185',4423,'7','1',448868.51,454210.70,5342.19,988305.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','185',4424,'8','1',228193.56,230262.91,2069.35,382829.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','185',4425,'9','1',396746.37,401708.73,4962.36,918036.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','185',4426,'10','1',134652.67,134652.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','185',4427,'11','1',500836.51,505177.51,4341.00,803085.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','185',4428,'12','1',145051.83,145430.13,378.30,69985.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','185',4429,'13','1',216487.58,216487.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','185',4430,'14','1',84442.54,84442.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','185',4431,'15','1',235366.30,235379.31,13.01,2406.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','185',4432,'16','1',62510.03,62510.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','185',4433,'17','1',51475.24,51475.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','185',4434,'18','1',267216.56,267216.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','185',4435,'19','1',54732.89,54732.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','185',4436,'20','1',259875.33,259875.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','185',4437,'21','2',179134.77,179694.14,559.37,464277.10,0.00,0.00,0.00,0.00,0.00),('1','248','4','185',4438,'22','2',103784.98,103784.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','185',4439,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','185',4440,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','186',4441,'1','1',648888.26,651024.10,2135.84,373772.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','186',4442,'2','1',259382.16,261024.04,1641.88,287329.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','186',4443,'3','1',504895.67,506474.65,1578.98,276321.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','186',4444,'4','1',232764.85,234867.65,2102.80,367990.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','186',4445,'5','1',637763.11,640159.40,2396.29,419350.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','186',4446,'6','1',97382.16,97382.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','186',4447,'7','1',454210.70,456480.63,2269.93,397237.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','186',4448,'8','1',230262.91,232409.17,2146.26,375595.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','186',4449,'9','1',401708.73,404070.17,2361.44,413252.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','186',4450,'10','1',134652.67,134652.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','186',4451,'11','1',505177.51,507161.64,1984.13,347222.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','186',4452,'12','1',145430.13,146825.65,1395.52,244216.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','186',4453,'13','1',216487.58,216487.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','186',4454,'14','1',84442.54,84442.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','186',4455,'15','1',235379.31,235379.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','186',4456,'16','1',62510.03,62510.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','186',4457,'17','1',51475.24,51475.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','186',4458,'18','1',267216.56,267216.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','186',4459,'19','1',54732.89,54732.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','186',4460,'20','1',259875.33,259875.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','186',4461,'21','2',179694.14,182874.54,3180.40,2639732.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','186',4462,'22','2',103784.98,104361.13,576.15,478204.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','186',4463,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','186',4464,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','187',4465,'1','1',651024.10,653237.27,2213.17,387304.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','187',4466,'2','1',261024.04,263103.15,2079.11,363844.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','187',4467,'3','1',506474.65,509170.16,2695.51,471714.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','187',4468,'4','1',234867.65,234867.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','187',4469,'5','1',640159.40,643257.02,3097.62,542083.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','187',4470,'6','1',97382.16,97382.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','187',4471,'7','1',456480.63,459360.52,2879.89,503980.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','187',4472,'8','1',232409.17,232864.24,455.07,79637.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','187',4473,'9','1',404070.17,406792.63,2722.46,476430.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','187',4474,'10','1',134652.67,134652.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','187',4475,'11','1',507161.64,508984.46,1822.82,318993.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','187',4476,'12','1',146825.65,148711.10,1885.45,329953.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','187',4477,'13','1',216487.58,216487.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','187',4478,'14','1',84442.54,84442.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','187',4479,'15','1',235379.31,235379.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','187',4480,'16','1',62510.03,62510.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','187',4481,'17','1',51475.24,51475.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','187',4482,'18','1',267216.56,267216.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','187',4483,'19','1',54732.89,54732.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','187',4484,'20','1',259875.33,259875.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','187',4485,'21','2',182874.54,183440.07,565.53,469389.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','187',4486,'22','2',104361.13,104361.41,0.28,232.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','187',4487,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','187',4488,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','188',4489,'1','1',653237.27,653237.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','188',4490,'2','1',263103.15,263103.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','188',4491,'3','1',509170.16,509170.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','188',4492,'4','1',234867.65,234867.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','188',4493,'5','1',643257.02,643257.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','188',4494,'6','1',97382.16,97382.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','188',4495,'7','1',459360.52,459360.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','188',4496,'8','1',232864.24,232864.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','188',4497,'9','1',406792.63,406792.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','188',4498,'10','1',134652.67,134652.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','188',4499,'11','1',508984.46,508984.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','188',4500,'12','1',148711.10,148711.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','188',4501,'13','1',216487.58,216487.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','188',4502,'14','1',84442.54,84442.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','188',4503,'15','1',235379.31,235379.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','188',4504,'16','1',62510.03,62510.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','188',4505,'17','1',51475.24,51475.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','188',4506,'18','1',267216.56,267216.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','188',4507,'19','1',54732.89,54732.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','188',4508,'20','1',259875.33,259875.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','188',4509,'21','2',183440.07,184796.81,1356.74,1112526.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','188',4510,'22','2',104361.41,104361.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','188',4511,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','188',4512,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','189',4513,'1','1',653237.27,658641.55,5404.28,945749.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','189',4514,'2','1',263103.15,266433.09,3329.94,582739.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','189',4515,'3','1',509170.16,509170.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','189',4516,'4','1',234867.65,234867.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','189',4517,'5','1',643257.02,649394.96,6137.94,1074139.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','189',4518,'6','1',97382.16,97382.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','189',4519,'7','1',459360.52,465193.71,5833.19,1020808.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','189',4520,'8','1',232864.24,235518.69,2654.45,464528.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','189',4521,'9','1',406792.63,406792.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','189',4522,'10','1',134652.67,134652.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','189',4523,'11','1',508984.46,515416.07,6431.61,1125531.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','189',4524,'12','1',148711.10,148711.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','189',4525,'13','1',216487.58,216487.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','189',4526,'14','1',84442.54,84442.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','189',4527,'15','1',235379.31,235379.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','189',4528,'16','1',62510.03,62510.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','189',4529,'17','1',51475.24,51475.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','189',4530,'18','1',267216.56,267216.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','189',4531,'19','1',54732.89,54732.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','189',4532,'20','1',259875.33,259875.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','189',4533,'21','2',184796.81,187341.94,2545.13,2087006.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','189',4534,'22','2',104361.41,105075.30,713.89,585389.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','189',4535,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','189',4536,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','190',4537,'1','1',658641.55,658641.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','190',4538,'2','1',266433.09,266433.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','190',4539,'3','1',509170.16,509170.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','190',4540,'4','1',234867.65,234867.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','190',4541,'5','1',649394.96,649394.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','190',4542,'6','1',97382.16,97382.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','190',4543,'7','1',465193.71,465193.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','190',4544,'8','1',235518.69,235518.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','190',4545,'9','1',406792.63,406792.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','190',4546,'10','1',134652.67,134652.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','190',4547,'11','1',515416.07,515416.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','190',4548,'12','1',148711.10,148711.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','190',4549,'13','1',216487.58,216487.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','190',4550,'14','1',84442.54,84442.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','190',4551,'15','1',235379.31,235379.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','190',4552,'16','1',62510.03,62510.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','190',4553,'17','1',51475.24,51475.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','190',4554,'18','1',267216.56,267216.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','190',4555,'19','1',54732.89,54732.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','190',4556,'20','1',259875.33,259875.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','190',4557,'21','2',187341.94,189982.00,2640.06,2164849.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','190',4558,'22','2',105075.30,105075.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','190',4559,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','190',4560,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','191',4561,'1','1',658641.55,658641.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','191',4562,'2','1',266433.09,266433.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','191',4563,'3','1',509170.16,509170.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','191',4564,'4','1',234867.65,234867.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','191',4565,'5','1',649394.96,649394.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','191',4566,'6','1',97382.16,97382.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','191',4567,'7','1',465193.71,465193.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','191',4568,'8','1',235518.69,235518.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','191',4569,'9','1',406792.63,406792.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','191',4570,'10','1',134652.67,134652.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','191',4571,'11','1',515416.07,515416.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','191',4572,'12','1',148711.10,148711.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','191',4573,'13','1',216487.58,216487.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','191',4574,'14','1',84442.54,84442.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','191',4575,'15','1',235379.31,235379.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','191',4576,'16','1',62510.03,62510.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','191',4577,'17','1',51475.24,51475.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','191',4578,'18','1',267216.56,267216.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','191',4579,'19','1',54732.89,54732.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','191',4580,'20','1',259875.33,259875.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','191',4581,'21','2',189982.00,190794.80,812.80,666496.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','191',4582,'22','2',105075.30,105075.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','191',4583,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','191',4584,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','192',4585,'1','1',658641.55,663609.78,4968.23,869440.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','192',4586,'2','1',266433.09,267983.58,1550.49,271335.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','192',4587,'3','1',509170.16,509170.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','192',4588,'4','1',234867.65,234867.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','192',4589,'5','1',649394.96,654578.35,5183.39,907093.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','192',4590,'6','1',97382.16,97440.51,58.35,10211.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','192',4591,'7','1',465193.71,469137.77,3944.06,690210.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','192',4592,'8','1',235518.69,239170.89,3652.20,639135.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','192',4593,'9','1',406792.63,409979.99,3187.36,557788.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','192',4594,'10','1',134652.67,137938.34,3285.67,574992.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','192',4595,'11','1',515416.07,519371.02,3954.95,692116.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','192',4596,'12','1',148711.10,148978.67,267.57,46824.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','192',4597,'13','1',216487.58,218809.78,2322.20,406385.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','192',4598,'14','1',84442.54,84623.49,180.95,31666.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','192',4599,'15','1',235379.31,237451.82,2072.51,362689.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','192',4600,'16','1',62510.03,62913.40,403.37,70589.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','192',4601,'17','1',51475.24,51766.30,291.06,50935.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','192',4602,'18','1',267216.56,269916.13,2699.57,472424.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','192',4603,'19','1',54732.89,55466.65,733.76,128408.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','192',4604,'20','1',259875.33,261683.11,1807.78,316361.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','192',4605,'21','2',190794.80,192427.06,1632.26,1322130.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','192',4606,'22','2',105075.30,105781.98,706.68,572410.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','192',4607,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','192',4608,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','193',4609,'1','1',663609.78,665911.86,2302.08,402864.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','193',4610,'2','1',267983.58,269171.46,1187.88,207879.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','193',4611,'3','1',509170.16,510564.09,1393.93,243937.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','193',4612,'4','1',234867.65,234867.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','193',4613,'5','1',654578.35,657821.35,3185.86,557525.50,0.00,0.00,57.14,0.00,0.00),('1','248','1','193',4614,'6','1',97440.51,97440.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','193',4615,'7','1',469137.77,469875.97,738.20,129185.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','193',4616,'8','1',239170.89,239170.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','193',4617,'9','1',409979.99,409979.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','193',4618,'10','1',137938.34,137938.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','193',4619,'11','1',519371.02,520009.35,638.33,111707.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','193',4620,'12','1',148978.67,149070.24,91.57,16024.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','193',4621,'13','1',218809.78,220594.99,1785.21,312411.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','193',4622,'14','1',84623.49,85093.27,469.78,82211.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','193',4623,'15','1',237451.82,239137.66,1685.84,295022.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','193',4624,'16','1',62913.40,63260.87,347.47,60807.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','193',4625,'17','1',51766.30,52309.28,542.98,95021.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','193',4626,'18','1',269916.13,272362.86,2446.73,428177.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','193',4627,'19','1',55466.65,56236.96,770.31,134804.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','193',4628,'20','1',261683.11,263156.34,1473.23,257815.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','193',4629,'21','2',192427.06,192822.93,395.87,320654.70,0.00,0.00,0.00,0.00,0.00),('1','248','4','193',4630,'22','2',105781.98,105781.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','193',4631,'23','2',70540.03,70540.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','193',4632,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','194',4633,'1','1',665911.86,669243.88,3332.02,583103.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','194',4634,'2','1',269171.46,272349.91,3178.45,556228.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','194',4635,'3','1',510564.09,510564.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','194',4636,'4','1',234867.65,239132.25,4264.60,746305.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','194',4637,'5','1',657821.35,661386.03,3549.68,621194.00,0.00,0.00,15.00,0.00,0.00),('1','248','1','194',4638,'6','1',97440.51,97440.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','194',4639,'7','1',469875.97,473810.64,3934.67,688567.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','194',4640,'8','1',239170.89,243178.38,4007.49,701310.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','194',4641,'9','1',409979.99,414701.93,4721.94,826339.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','194',4642,'10','1',137938.34,137938.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','194',4643,'11','1',520009.35,523509.10,3499.75,612456.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','194',4644,'12','1',149070.24,149070.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','194',4645,'13','1',220594.99,220594.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','194',4646,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','194',4647,'15','1',239137.66,239137.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','194',4648,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','194',4649,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','194',4650,'18','1',272362.86,272362.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','194',4651,'19','1',56236.96,56236.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','194',4652,'20','1',263156.34,263156.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','194',4653,'21','2',192822.93,193995.96,1173.03,950154.30,0.00,0.00,0.00,0.00,0.00),('1','248','4','194',4654,'22','2',105781.98,106586.14,804.16,651369.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','194',4655,'23','2',70540.03,71030.03,490.00,396900.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','194',4656,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','195',4657,'1','1',669243.88,674451.68,5207.80,911365.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','195',4658,'2','1',272349.91,275577.30,3227.39,564793.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','195',4659,'3','1',510564.09,515822.14,5258.05,920158.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','195',4660,'4','1',239132.25,241159.21,2026.96,354718.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','195',4661,'5','1',661386.03,666556.32,5170.29,904800.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','195',4662,'6','1',97440.51,99697.36,2256.85,394948.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','195',4663,'7','1',473810.64,475016.32,1205.68,210994.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','195',4664,'8','1',243178.38,243178.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','195',4665,'9','1',414701.93,416111.80,1409.87,246727.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','195',4666,'10','1',137938.34,137938.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','195',4667,'11','1',523509.10,524771.06,1261.96,220843.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','195',4668,'12','1',149070.24,149070.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','195',4669,'13','1',220594.99,220594.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','195',4670,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','195',4671,'15','1',239137.66,239137.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','195',4672,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','195',4673,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','195',4674,'18','1',272362.86,272362.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','195',4675,'19','1',56236.96,56236.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','195',4676,'20','1',263156.34,263156.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','195',4677,'21','2',193995.96,194323.98,328.02,265696.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','195',4678,'22','2',106586.14,107502.30,916.16,742089.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','195',4679,'23','2',71030.03,71030.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','195',4680,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','196',4681,'1','1',674451.68,676589.24,2137.56,374073.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','196',4682,'2','1',275577.30,276974.49,1397.19,244508.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','196',4683,'3','1',515822.14,515822.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','196',4684,'4','1',241159.21,241801.85,642.64,112462.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','196',4685,'5','1',666556.32,669584.54,3028.22,529938.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','196',4686,'6','1',99697.36,99697.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','196',4687,'7','1',475016.32,478531.02,3514.70,615072.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','196',4688,'8','1',243178.38,243576.43,398.05,69658.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','196',4689,'9','1',416111.80,416111.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','196',4690,'10','1',137938.34,137938.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','196',4691,'11','1',524771.06,528551.94,3780.88,661654.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','196',4692,'12','1',149070.24,149070.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','196',4693,'13','1',220594.99,224962.13,4367.14,764249.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','196',4694,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','196',4695,'15','1',239137.66,241393.15,2255.49,394710.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','196',4696,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','196',4697,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','196',4698,'18','1',272362.86,276541.08,4178.22,731188.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','196',4699,'19','1',56236.96,56236.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','196',4700,'20','1',263156.34,267754.24,4597.90,804632.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','196',4701,'21','2',194323.98,196997.97,2673.99,2165931.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','196',4702,'22','2',107502.30,107508.47,6.17,4997.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','196',4703,'23','2',71030.03,71116.49,86.46,70032.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','196',4704,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','197',4705,'1','1',676589.24,682757.41,6168.17,1079429.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','197',4706,'2','1',276974.49,276974.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','197',4707,'3','1',515822.14,521120.64,5298.50,927237.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','197',4708,'4','1',241801.85,241801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','197',4709,'5','1',669584.54,674189.58,4605.04,805882.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','197',4710,'6','1',99697.36,99697.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','197',4711,'7','1',478531.02,483349.55,4818.53,843242.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','197',4712,'8','1',243576.43,243646.15,69.72,12201.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','197',4713,'9','1',416111.80,421727.35,5615.55,982721.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','197',4714,'10','1',137938.34,137938.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','197',4715,'11','1',528551.94,528551.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','197',4716,'12','1',149070.24,149070.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','197',4717,'13','1',224962.13,230185.44,5223.31,914079.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','197',4718,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','197',4719,'15','1',241393.15,246139.50,4746.35,830611.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','197',4720,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','197',4721,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','197',4722,'18','1',276541.08,276541.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','197',4723,'19','1',56236.96,56236.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','197',4724,'20','1',267754.24,271536.99,3782.75,661981.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','197',4725,'21','2',196997.97,197102.89,104.92,84985.20,0.00,0.00,0.00,0.00,0.00),('1','248','4','197',4726,'22','2',107508.47,107508.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','197',4727,'23','2',71116.49,73358.29,2241.80,1815858.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','197',4728,'24','2',478.34,478.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','198',4729,'1','1',682757.41,689118.13,6360.72,1113126.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','198',4730,'2','1',276974.49,278657.60,1683.11,294544.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','198',4731,'3','1',521120.64,521888.67,768.03,134405.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','198',4732,'4','1',241801.85,243720.63,1918.78,335786.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','198',4733,'5','1',674189.58,679335.28,5145.70,900497.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','198',4734,'6','1',99697.36,102276.85,2579.49,451410.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','198',4735,'7','1',483349.55,486993.75,3644.20,637735.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','198',4736,'8','1',243646.15,244667.70,1021.55,178771.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','198',4737,'9','1',421727.35,423450.10,1722.75,301481.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','198',4738,'10','1',137938.34,137938.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','198',4739,'11','1',528551.94,531489.66,2937.72,514101.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','198',4740,'12','1',149070.24,150395.93,1325.69,231995.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','198',4741,'13','1',230185.44,234222.95,4037.51,706564.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','198',4742,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','198',4743,'15','1',246139.50,250529.09,4389.59,768178.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','198',4744,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','198',4745,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','198',4746,'18','1',276541.08,279441.41,2900.33,507557.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','198',4747,'19','1',56236.96,57548.02,1311.06,229435.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','198',4748,'20','1',271536.99,274546.31,3009.32,526631.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','198',4749,'21','2',197102.89,197102.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','198',4750,'22','2',107508.47,107508.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','198',4751,'23','2',73358.29,75527.56,2169.27,1757108.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','198',4752,'24','2',478.34,959.54,474.57,384401.70,0.00,0.00,6.63,0.00,0.00),('1','248','1','199',4753,'1','1',689118.13,695154.93,6036.80,1056440.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','199',4754,'2','1',278657.60,283425.29,4767.69,834345.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','199',4755,'3','1',521888.67,521928.67,0.00,0.00,0.00,0.00,40.00,0.00,0.00),('1','248','1','199',4756,'4','1',243720.63,243720.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','199',4757,'5','1',679335.28,685213.60,5878.32,1028706.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','199',4758,'6','1',102276.85,103291.59,1014.74,177579.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','199',4759,'7','1',486993.75,493162.10,6168.35,1079461.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','199',4760,'8','1',244667.70,244929.91,262.21,45886.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','199',4761,'9','1',423450.10,429552.15,6102.05,1067858.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','199',4762,'10','1',137938.34,139391.49,1453.15,254301.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','199',4763,'11','1',531489.66,537371.66,5882.00,1029350.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','199',4764,'12','1',150395.93,150395.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','199',4765,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','199',4766,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','199',4767,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','199',4768,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','199',4769,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','199',4770,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','199',4771,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','199',4772,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','199',4773,'21','2',197102.89,197102.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','199',4774,'22','2',107508.47,107508.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','199',4775,'23','2',75527.56,76039.86,512.30,414963.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','199',4776,'24','2',959.54,1062.63,103.09,83502.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','200',4777,'1','1',695154.93,697625.38,2470.45,432328.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','200',4778,'2','1',283425.29,285551.83,2126.54,372144.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','200',4779,'3','1',521928.67,524733.23,2804.56,490798.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','200',4780,'4','1',243720.63,245700.33,1979.70,346447.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','200',4781,'5','1',685213.60,687727.73,2505.86,438525.50,0.00,0.00,8.27,0.00,0.00),('1','248','1','200',4782,'6','1',103291.59,104897.79,1606.20,281085.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','200',4783,'7','1',493162.10,497035.39,3873.29,677825.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','200',4784,'8','1',244929.91,248637.44,3707.53,648817.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','200',4785,'9','1',429552.15,433473.69,3921.54,686269.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','200',4786,'10','1',139391.49,141876.64,2480.73,434127.75,0.00,0.00,4.42,0.00,0.00),('1','248','2','200',4787,'11','1',537371.66,541216.10,3844.44,672777.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','200',4788,'12','1',150395.93,152588.12,2192.19,383633.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','200',4789,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','200',4790,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','200',4791,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','200',4792,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','200',4793,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','200',4794,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','200',4795,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','200',4796,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','200',4797,'21','2',197102.89,197102.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','200',4798,'22','2',107508.47,107508.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','200',4799,'23','2',76039.86,77891.59,1851.73,1499901.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','200',4800,'24','2',1062.63,1062.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','201',4801,'1','1',697625.38,702940.29,5314.91,930109.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','201',4802,'2','1',285551.83,285924.04,372.21,65136.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','201',4803,'3','1',524733.23,528530.70,3797.47,664557.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','201',4804,'4','1',245700.33,245990.35,290.02,50753.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','201',4805,'5','1',687727.73,691927.31,4199.58,734926.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','201',4806,'6','1',104897.79,107158.09,2260.30,395552.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','201',4807,'7','1',497035.39,500373.64,3338.25,584193.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','201',4808,'8','1',248637.44,251827.35,3189.91,558234.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','201',4809,'9','1',433473.69,436483.27,3009.58,526676.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','201',4810,'10','1',141876.64,143621.99,1745.35,305436.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','201',4811,'11','1',541216.10,544695.17,3479.07,608837.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','201',4812,'12','1',152588.12,153680.06,1091.94,191089.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','201',4813,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','201',4814,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','201',4815,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','201',4816,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','201',4817,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','201',4818,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','201',4819,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','201',4820,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','201',4821,'21','2',197102.89,197102.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','201',4822,'22','2',107508.47,107508.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','201',4823,'23','2',77891.59,78830.87,939.28,760816.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','201',4824,'24','2',1062.63,1147.20,84.57,68501.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','202',4825,'1','1',702940.29,706695.94,3755.65,657238.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','202',4826,'2','1',285924.04,288464.40,2540.36,444563.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','202',4827,'3','1',528530.70,530861.14,2330.44,407827.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','202',4828,'4','1',245990.35,247246.79,1256.44,219877.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','202',4829,'5','1',691927.31,695539.87,3612.56,632198.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','202',4830,'6','1',107158.09,107158.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','202',4831,'7','1',500373.64,503701.70,3328.06,582410.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','202',4832,'8','1',251827.35,253930.52,2103.17,368054.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','202',4833,'9','1',436483.27,440923.64,4440.37,777064.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','202',4834,'10','1',143621.99,143621.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','202',4835,'11','1',544695.17,548395.83,3700.66,647615.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','202',4836,'12','1',153680.06,156262.41,2582.35,451911.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','202',4837,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','202',4838,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','202',4839,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','202',4840,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','202',4841,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','202',4842,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','202',4843,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','202',4844,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','202',4845,'21','2',197102.89,197102.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','202',4846,'22','2',107508.47,107508.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','202',4847,'23','2',78830.87,80915.43,2084.56,1688493.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','202',4848,'24','2',1147.20,1147.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','203',4849,'1','1',706695.94,708839.78,2143.84,375172.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','203',4850,'2','1',288464.40,290402.64,1938.24,339192.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','203',4851,'3','1',530861.14,533109.86,2248.72,393526.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','203',4852,'4','1',247246.79,247246.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','203',4853,'5','1',695539.87,697816.16,2276.29,398350.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','203',4854,'6','1',107158.09,108506.34,1348.25,235943.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','203',4855,'7','1',503701.70,505240.72,1539.02,269328.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','203',4856,'8','1',253930.52,253930.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','203',4857,'9','1',440923.64,442609.32,1685.68,294994.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','203',4858,'10','1',143621.99,143793.64,171.65,30038.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','203',4859,'11','1',548395.83,550153.56,1757.73,307602.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','203',4860,'12','1',156262.41,156262.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','203',4861,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','203',4862,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','203',4863,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','203',4864,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','203',4865,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','203',4866,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','203',4867,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','203',4868,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','203',4869,'21','2',197102.89,197102.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','203',4870,'22','2',107508.47,107508.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','203',4871,'23','2',80915.43,82289.25,1373.82,1112794.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','203',4872,'24','2',1147.20,1147.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','204',4873,'1','1',708839.78,711628.91,2789.13,488097.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','204',4874,'2','1',290402.64,292049.26,1646.62,288158.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','204',4875,'3','1',533109.86,535809.32,2699.46,472405.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','204',4876,'4','1',247246.79,247246.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','204',4877,'5','1',697816.16,700852.55,3036.39,531368.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','204',4878,'6','1',108506.34,108506.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','204',4879,'7','1',505240.72,507249.52,2008.80,351540.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','204',4880,'8','1',253930.52,256070.39,2139.87,374477.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','204',4881,'9','1',442609.32,444587.75,1978.43,346225.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','204',4882,'10','1',143793.64,145822.43,2008.79,351538.25,0.00,0.00,20.00,0.00,0.00),('1','248','2','204',4883,'11','1',550153.56,552327.78,2174.22,380488.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','204',4884,'12','1',156262.41,157461.85,1199.44,209902.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','204',4885,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','204',4886,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','204',4887,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','204',4888,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','204',4889,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','204',4890,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','204',4891,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','204',4892,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','204',4893,'21','2',197102.89,197102.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','204',4894,'22','2',107508.47,107508.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','204',4895,'23','2',82289.25,84114.37,1825.12,1478347.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','204',4896,'24','2',1147.20,1147.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','205',4897,'1','1',711628.91,715500.08,3871.17,677454.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','205',4898,'2','1',292049.26,295769.29,3720.03,651005.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','205',4899,'3','1',535809.32,539470.76,3661.44,640752.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','205',4900,'4','1',247246.79,250902.04,3655.25,639668.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','205',4901,'5','1',700852.55,705314.17,4461.62,780783.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','205',4902,'6','1',108506.34,112480.78,3974.44,695527.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','205',4903,'7','1',507249.52,508831.26,1581.74,276804.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','205',4904,'8','1',256070.39,257059.52,989.13,173097.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','205',4905,'9','1',444587.75,444587.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','205',4906,'10','1',145822.43,145822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','205',4907,'11','1',552327.78,554387.92,2060.14,360524.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','205',4908,'12','1',157461.85,157585.27,123.42,21598.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','205',4909,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','205',4910,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','205',4911,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','205',4912,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','205',4913,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','205',4914,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','205',4915,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','205',4916,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','205',4917,'21','2',197102.89,197109.13,6.24,5054.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','205',4918,'22','2',107508.47,107509.43,0.96,777.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','205',4919,'23','2',84114.37,85803.70,1689.33,1368357.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','205',4920,'24','2',1147.20,1147.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','206',4921,'1','1',715500.08,719040.77,3540.69,619620.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','206',4922,'2','1',295769.29,299499.98,3730.69,652870.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','206',4923,'3','1',539470.76,543718.71,4247.95,743391.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','206',4924,'4','1',250902.04,250902.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','206',4925,'5','1',705314.17,708987.91,3673.74,642904.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','206',4926,'6','1',112480.78,112586.51,105.73,18502.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','206',4927,'7','1',508831.26,512096.78,3265.52,571466.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','206',4928,'8','1',257059.52,260166.43,3106.91,543709.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','206',4929,'9','1',444587.75,448932.43,4344.68,760319.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','206',4930,'10','1',145822.43,145822.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','206',4931,'11','1',554387.92,558871.71,4483.79,784663.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','206',4932,'12','1',157585.27,157643.27,58.00,10150.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','206',4933,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','206',4934,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','206',4935,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','206',4936,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','206',4937,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','206',4938,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','206',4939,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','206',4940,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','206',4941,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','206',4942,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','206',4943,'23','2',85803.70,86637.88,834.18,675685.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','206',4944,'24','2',1147.20,1147.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','207',4945,'1','1',719040.77,720709.68,1668.91,292059.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','207',4946,'2','1',299499.98,299828.93,328.95,57566.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','207',4947,'3','1',543718.71,545232.01,1513.30,264827.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','207',4948,'4','1',250902.04,250902.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','207',4949,'5','1',708987.91,710365.21,1377.30,241027.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','207',4950,'6','1',112586.51,112586.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','207',4951,'7','1',512096.78,513710.64,1613.86,282425.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','207',4952,'8','1',260166.43,260166.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','207',4953,'9','1',448932.43,450270.36,1337.93,234137.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','207',4954,'10','1',145822.43,146688.66,866.23,151590.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','207',4955,'11','1',558871.71,559747.29,875.58,153226.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','207',4956,'12','1',157643.27,157643.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','207',4957,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','207',4958,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','207',4959,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','207',4960,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','207',4961,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','207',4962,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','207',4963,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','207',4964,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','207',4965,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','207',4966,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','207',4967,'23','2',86637.88,87069.96,432.08,349984.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','207',4968,'24','2',1147.20,1147.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','208',4969,'1','1',720709.68,724651.74,3942.06,689860.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','208',4970,'2','1',299828.93,302200.04,2371.11,414944.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','208',4971,'3','1',545232.01,549132.23,3900.22,682538.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','208',4972,'4','1',250902.04,250902.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','208',4973,'5','1',710365.21,715889.14,5523.93,966687.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','208',4974,'6','1',112586.51,112586.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','208',4975,'7','1',513710.64,518067.90,4357.26,762520.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','208',4976,'8','1',260166.43,261381.15,1214.72,212576.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','208',4977,'9','1',450270.36,455205.48,4935.12,863646.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','208',4978,'10','1',146688.66,146688.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','208',4979,'11','1',559747.29,564107.29,4360.00,763000.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','208',4980,'12','1',157643.27,157643.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','208',4981,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','208',4982,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','208',4983,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','208',4984,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','208',4985,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','208',4986,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','208',4987,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','208',4988,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','208',4989,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','208',4990,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','208',4991,'23','2',87069.96,88096.72,1026.76,831675.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','208',4992,'24','2',1147.20,1974.55,827.35,670153.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','209',4993,'1','1',724651.74,727061.44,2409.70,421697.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','209',4994,'2','1',302200.04,304780.50,2580.46,451580.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','209',4995,'3','1',549132.23,551127.15,1994.92,349111.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','209',4996,'4','1',250902.04,253367.30,2465.26,431420.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','209',4997,'5','1',715889.14,718167.41,2278.27,398697.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','209',4998,'6','1',112586.51,114940.40,2353.89,411930.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','209',4999,'7','1',518067.90,518067.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','209',5000,'8','1',261381.15,261381.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','209',5001,'9','1',455205.48,455205.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','209',5002,'10','1',146688.66,146688.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','209',5003,'11','1',564107.29,564107.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','209',5004,'12','1',157643.27,157643.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','209',5005,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','209',5006,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','209',5007,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','209',5008,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','209',5009,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','209',5010,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','209',5011,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','209',5012,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','209',5013,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','209',5014,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','209',5015,'23','2',88096.72,89411.25,1314.53,1064769.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','209',5016,'24','2',1974.55,1974.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','210',5017,'1','1',727061.44,729531.25,2469.81,432216.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','210',5018,'2','1',304780.50,306921.51,2141.01,374676.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','210',5019,'3','1',551127.15,553316.32,2189.17,383104.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','210',5020,'4','1',253367.30,254422.20,1054.90,184607.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','210',5021,'5','1',718167.41,720588.51,2421.10,423692.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','210',5022,'6','1',114940.40,116765.17,1824.77,319334.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','210',5023,'7','1',518067.90,520498.63,2430.73,425377.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','210',5024,'8','1',261381.15,263940.00,2558.85,447798.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','210',5025,'9','1',455205.48,458854.95,3649.47,638657.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','210',5026,'10','1',146688.66,146688.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','210',5027,'11','1',564107.29,567478.84,3371.55,590021.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','210',5028,'12','1',157643.27,157643.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','210',5029,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','210',5030,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','210',5031,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','210',5032,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','210',5033,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','210',5034,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','210',5035,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','210',5036,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','210',5037,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','210',5038,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','210',5039,'23','2',89411.25,90738.50,1327.25,1075072.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','210',5040,'24','2',1974.55,1974.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','211',5041,'1','1',729531.25,731287.44,1756.19,307333.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','211',5042,'2','1',306921.51,308222.26,1300.75,227631.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','211',5043,'3','1',553316.32,554994.61,1678.29,293700.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','211',5044,'4','1',254422.20,254422.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','211',5045,'5','1',720588.51,722237.01,1648.50,288487.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','211',5046,'6','1',116765.17,117972.24,1207.07,211237.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','211',5047,'7','1',520498.63,522589.77,2091.14,365949.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','211',5048,'8','1',263940.00,265844.80,1904.80,333340.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','211',5049,'9','1',458854.95,461218.01,2363.06,413535.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','211',5050,'10','1',146688.66,146688.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','211',5051,'11','1',567478.84,569496.22,2017.38,353041.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','211',5052,'12','1',157643.27,157769.21,125.94,22039.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','211',5053,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','211',5054,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','211',5055,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','211',5056,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','211',5057,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','211',5058,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','211',5059,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','211',5060,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','211',5061,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','211',5062,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','211',5063,'23','2',90738.50,90800.64,62.14,50333.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','211',5064,'24','2',1974.55,2553.14,578.59,468657.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','212',5065,'1','1',731287.44,734665.01,3372.57,590199.75,0.00,0.00,5.00,0.00,0.00),('1','248','1','212',5066,'2','1',308222.26,310652.19,2429.93,425237.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','212',5067,'3','1',554994.61,557720.44,2725.83,477020.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','212',5068,'4','1',254422.20,256775.25,2353.05,411783.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','212',5069,'5','1',722237.01,725853.18,3616.17,632829.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','212',5070,'6','1',117972.24,117972.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','212',5071,'7','1',522589.77,526132.03,3542.26,619895.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','212',5072,'8','1',265844.80,265844.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','212',5073,'9','1',461218.01,464810.70,3592.69,628720.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','212',5074,'10','1',146688.66,147446.03,757.37,132539.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','212',5075,'11','1',569496.22,572533.07,3036.85,531448.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','212',5076,'12','1',157769.21,157769.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','212',5077,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','212',5078,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','212',5079,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','212',5080,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','212',5081,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','212',5082,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','212',5083,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','212',5084,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','212',5085,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','212',5086,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','212',5087,'23','2',90800.64,92211.38,1410.74,1142699.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','212',5088,'24','2',2553.14,2751.20,198.06,160428.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','213',5089,'1','1',734665.01,737910.13,3225.12,564396.00,0.00,0.00,20.00,0.00,0.00),('1','248','1','213',5090,'2','1',310652.19,313583.42,2911.23,509465.25,0.00,0.00,20.00,0.00,0.00),('1','248','1','213',5091,'3','1',557720.44,560126.16,2385.72,417501.00,0.00,0.00,20.00,0.00,0.00),('1','248','1','213',5092,'4','1',256775.25,259843.90,3048.65,533513.75,0.00,0.00,20.00,0.00,0.00),('1','248','1','213',5093,'5','1',725853.18,729946.16,4082.98,714521.50,0.00,0.00,10.00,0.00,0.00),('1','248','1','213',5094,'6','1',117972.24,117982.24,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','248','2','213',5095,'7','1',526132.03,527670.15,1528.12,267421.00,0.00,0.00,10.00,0.00,0.00),('1','248','2','213',5096,'8','1',265844.80,266784.48,929.68,162694.00,0.00,0.00,10.00,0.00,0.00),('1','248','2','213',5097,'9','1',464810.70,464820.70,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','248','2','213',5098,'10','1',147446.03,147456.03,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','248','2','213',5099,'11','1',572533.07,574098.54,1555.47,272207.25,0.00,0.00,10.00,0.00,0.00),('1','248','2','213',5100,'12','1',157769.21,157779.21,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','248','3','213',5101,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','213',5102,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','213',5103,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','213',5104,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','213',5105,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','213',5106,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','213',5107,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','213',5108,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','213',5109,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','213',5110,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','213',5111,'23','2',92211.38,92782.62,571.24,462704.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','213',5112,'24','2',2751.20,2751.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','214',5113,'1','1',737910.13,740567.30,2657.17,465004.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','214',5114,'2','1',313583.42,315896.52,2313.10,404792.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','214',5115,'3','1',560126.16,562373.96,2247.80,393365.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','214',5116,'4','1',259843.90,260281.71,437.81,76616.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','214',5117,'5','1',729946.16,732455.79,2509.63,439185.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','214',5118,'6','1',117982.24,118833.56,851.32,148981.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','214',5119,'7','1',527670.15,530385.87,2715.72,475251.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','214',5120,'8','1',266784.48,269613.13,2828.65,495013.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','214',5121,'9','1',464820.70,467790.02,2969.32,519631.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','214',5122,'10','1',147456.03,147456.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','214',5123,'11','1',574098.54,577002.12,2903.58,508126.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','214',5124,'12','1',157779.21,157779.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','214',5125,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','214',5126,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','214',5127,'15','1',250529.09,250529.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','214',5128,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','214',5129,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','214',5130,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','214',5131,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','214',5132,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','214',5133,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','214',5134,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','214',5135,'23','2',92782.62,95079.42,2296.80,1860408.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','214',5136,'24','2',2751.20,2769.72,18.52,15001.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','215',5137,'1','1',740567.30,744564.06,3996.76,699433.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','215',5138,'2','1',315896.52,319133.18,3236.66,566415.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','215',5139,'3','1',562373.96,566055.94,3681.98,644346.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','215',5140,'4','1',260281.71,261782.91,1501.20,262710.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','215',5141,'5','1',732455.79,736417.29,3961.50,693262.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','215',5142,'6','1',118833.56,120558.69,1725.13,301897.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','215',5143,'7','1',530385.87,532577.29,2191.42,383498.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','215',5144,'8','1',269613.13,271679.60,2066.47,361632.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','215',5145,'9','1',467790.02,470230.64,2440.62,427108.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','215',5146,'10','1',147456.03,147554.37,98.34,17209.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','215',5147,'11','1',577002.12,578951.55,1949.43,341150.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','215',5148,'12','1',157779.21,158849.42,1070.21,187286.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','215',5149,'13','1',234222.95,234222.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','215',5150,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','215',5151,'15','1',250529.09,250561.54,0.00,0.00,0.00,0.00,32.45,0.00,0.00),('1','248','3','215',5152,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','215',5153,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','215',5154,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','215',5155,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','215',5156,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','215',5157,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','215',5158,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','215',5159,'23','2',95079.42,96275.17,1193.35,966613.50,0.00,0.00,2.40,0.00,0.00),('1','248','5','215',5160,'24','2',2769.72,3380.22,610.50,494505.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','216',5161,'1','1',744564.06,748082.30,3518.24,615692.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','216',5162,'2','1',319133.18,322736.26,3603.08,630539.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','216',5163,'3','1',566055.94,570886.10,4830.16,845278.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','216',5164,'4','1',261782.91,261782.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','216',5165,'5','1',736417.29,740038.77,3621.48,633759.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','216',5166,'6','1',120558.69,120558.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','216',5167,'7','1',532577.29,536401.70,3824.41,669271.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','216',5168,'8','1',271679.60,275275.25,3595.65,629238.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','216',5169,'9','1',470230.64,474463.06,4192.42,733673.50,0.00,0.00,40.00,0.00,0.00),('1','248','2','216',5170,'10','1',147554.37,147554.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','216',5171,'11','1',578951.55,582614.48,3662.93,641012.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','216',5172,'12','1',158849.42,158849.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','216',5173,'13','1',234222.95,234417.84,194.89,34105.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','216',5174,'14','1',85093.27,85093.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','216',5175,'15','1',250561.54,250797.94,236.40,41370.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','216',5176,'16','1',63260.87,63260.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','216',5177,'17','1',52309.28,52309.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','216',5178,'18','1',279441.41,279441.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','216',5179,'19','1',57548.02,57548.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','216',5180,'20','1',274546.31,274546.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','216',5181,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','216',5182,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','216',5183,'23','2',96275.17,96606.58,331.41,268442.10,0.00,0.00,0.00,0.00,0.00),('1','248','5','216',5184,'24','2',3380.22,6063.23,2683.01,2173238.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','217',5185,'1','1',748082.30,755038.13,6955.83,1217270.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','217',5186,'2','1',322736.26,322736.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','217',5187,'3','1',570886.10,576140.65,5254.55,919546.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','217',5188,'4','1',261782.91,265051.56,3268.65,572013.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','217',5189,'5','1',740038.77,744821.01,4782.24,836892.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','217',5190,'6','1',120558.69,123392.69,2834.00,495950.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','217',5191,'7','1',536401.70,538347.07,1945.37,340439.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','217',5192,'8','1',275275.25,276459.30,1184.05,207208.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','217',5193,'9','1',474463.06,474463.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','217',5194,'10','1',147554.37,147554.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','217',5195,'11','1',582614.48,584556.07,1941.59,339778.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','217',5196,'12','1',158849.42,158849.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','217',5197,'13','1',234417.84,236897.51,2479.67,433942.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','217',5198,'14','1',85093.27,86895.02,1801.75,315306.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','217',5199,'15','1',250797.94,252263.35,1465.41,256446.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','217',5200,'16','1',63260.87,64523.31,1262.44,220927.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','217',5201,'17','1',52309.28,53790.37,1481.09,259190.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','217',5202,'18','1',279441.41,282577.92,3136.51,548889.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','217',5203,'19','1',57548.02,58989.56,1441.54,252269.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','217',5204,'20','1',274546.31,276796.92,2250.61,393856.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','217',5205,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','217',5206,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','217',5207,'23','2',96606.58,97210.40,603.82,489094.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','217',5208,'24','2',6063.23,6991.05,927.82,751534.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','218',5209,'1','1',755038.13,758154.39,3116.26,545345.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','218',5210,'2','1',322736.26,325125.86,2389.60,418180.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','218',5211,'3','1',576140.65,579053.50,2912.85,509748.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','218',5212,'4','1',265051.56,265051.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','218',5213,'5','1',744821.01,748661.92,3840.91,672159.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','218',5214,'6','1',123392.69,123392.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','218',5215,'7','1',538347.07,541342.06,2994.99,524123.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','218',5216,'8','1',276459.30,276459.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','218',5217,'9','1',474463.06,476528.99,2065.93,361537.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','218',5218,'10','1',147554.37,148982.20,1427.83,249870.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','218',5219,'11','1',584556.07,587218.04,2661.97,465844.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','218',5220,'12','1',158849.42,158849.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','218',5221,'13','1',236897.51,238566.23,1668.72,292026.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','218',5222,'14','1',86895.02,87749.25,854.23,149490.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','218',5223,'15','1',252263.35,253406.93,1143.58,200126.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','218',5224,'16','1',64523.31,64583.42,60.11,10519.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','218',5225,'17','1',53790.37,54193.52,403.15,70551.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','218',5226,'18','1',282577.92,284315.26,1737.34,304034.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','218',5227,'19','1',58989.56,59806.73,817.17,143004.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','218',5228,'20','1',276796.92,278608.07,1811.15,316951.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','218',5229,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','218',5230,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','218',5231,'23','2',97210.40,97507.51,297.11,240659.10,0.00,0.00,0.00,0.00,0.00),('1','248','5','218',5232,'24','2',6991.05,9664.53,2673.48,2165518.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','219',5233,'1','1',758154.39,763176.81,4971.00,869925.00,0.00,0.00,51.42,0.00,0.00),('1','248','1','219',5234,'2','1',325125.86,326992.97,1867.11,326744.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','219',5235,'3','1',579053.50,579053.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','219',5236,'4','1',265051.56,265051.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','219',5237,'5','1',748661.92,752435.84,3773.92,660436.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','219',5238,'6','1',123392.69,125897.50,2504.81,438341.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','219',5239,'7','1',541342.06,546084.53,4742.47,829932.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','219',5240,'8','1',276459.30,279023.69,2564.39,448768.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','219',5241,'9','1',476528.99,481904.89,5375.90,940782.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','219',5242,'10','1',148982.20,150990.34,2008.14,351424.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','219',5243,'11','1',587218.04,591250.57,4032.53,705692.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','219',5244,'12','1',158849.42,158849.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','219',5245,'13','1',238566.23,241367.67,2801.44,490252.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','219',5246,'14','1',87749.25,89337.52,1588.27,277947.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','219',5247,'15','1',253406.93,255985.65,2578.72,451276.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','219',5248,'16','1',64583.42,65830.40,1246.98,218221.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','219',5249,'17','1',54193.52,55943.48,1749.96,306243.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','219',5250,'18','1',284315.26,288026.13,3710.87,649402.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','219',5251,'19','1',59806.73,62366.59,2559.86,447975.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','219',5252,'20','1',278608.07,281255.13,2647.06,463235.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','219',5253,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','219',5254,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','219',5255,'23','2',97507.51,97519.86,12.35,10003.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','219',5256,'24','2',9664.53,10553.37,888.84,719960.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','220',5257,'1','1',763176.81,764873.79,1696.98,296971.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','220',5258,'2','1',326992.97,328141.29,1148.32,200956.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','220',5259,'3','1',579053.50,580091.98,1038.48,181734.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','220',5260,'4','1',265051.56,265268.55,216.99,37973.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','220',5261,'5','1',752435.84,753849.25,1413.41,247346.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','220',5262,'6','1',125897.50,126933.18,1035.68,181244.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','220',5263,'7','1',546084.53,547041.46,956.93,167462.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','220',5264,'8','1',279023.69,279590.84,567.15,99251.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','220',5265,'9','1',481904.89,481904.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','220',5266,'10','1',150990.34,150990.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','220',5267,'11','1',591250.57,592367.04,1116.47,195382.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','220',5268,'12','1',158849.42,158849.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','220',5269,'13','1',241367.67,241367.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','220',5270,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','220',5271,'15','1',255985.65,255985.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','220',5272,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','220',5273,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','220',5274,'18','1',288026.13,288026.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','220',5275,'19','1',62366.59,62366.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','220',5276,'20','1',281255.13,281255.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','220',5277,'21','2',197109.13,197109.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','220',5278,'22','2',107509.43,107509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','220',5279,'23','2',97519.86,97608.99,89.13,72195.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','220',5280,'24','2',10553.37,12546.67,1993.30,1614573.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','221',5281,'1','1',764873.79,769430.92,4557.13,797497.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','221',5282,'2','1',328141.29,331096.85,2955.56,517223.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','221',5283,'3','1',580091.98,584761.90,4669.92,817236.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','221',5284,'4','1',265268.55,269090.16,3821.61,668781.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','221',5285,'5','1',753849.25,757347.82,3498.57,612249.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','221',5286,'6','1',126933.18,126933.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','221',5287,'7','1',547041.46,551891.38,4849.92,848736.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','221',5288,'8','1',279590.84,283602.91,4012.07,702112.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','221',5289,'9','1',481904.89,487216.48,5311.59,929528.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','221',5290,'10','1',150990.34,151498.94,508.60,89005.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','221',5291,'11','1',592367.04,597093.68,4726.64,827162.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','221',5292,'12','1',158849.42,160012.15,1162.73,203477.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','221',5293,'13','1',241367.67,241367.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','221',5294,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','221',5295,'15','1',255985.65,255985.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','221',5296,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','221',5297,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','221',5298,'18','1',288026.13,288026.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','221',5299,'19','1',62366.59,62366.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','221',5300,'20','1',281255.13,281255.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','221',5301,'21','2',197109.13,197139.23,30.10,24381.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','221',5302,'22','2',107509.43,108252.60,743.17,601967.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','221',5303,'23','2',97608.99,98536.36,927.37,751169.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','221',5304,'24','2',12546.67,12897.78,351.11,284399.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','222',5305,'1','1',769430.92,771964.15,2533.23,443315.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','222',5306,'2','1',331096.85,331919.12,822.27,143897.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','222',5307,'3','1',584761.90,587528.51,2766.61,484156.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','222',5308,'4','1',269090.16,269906.61,816.45,142878.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','222',5309,'5','1',757347.82,760883.42,3535.60,618730.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','222',5310,'6','1',126933.18,127035.69,102.51,17939.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','222',5311,'7','1',551891.38,555284.09,3392.71,593724.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','222',5312,'8','1',283602.91,284043.41,440.50,77087.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','222',5313,'9','1',487216.48,490507.36,3290.88,575904.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','222',5314,'10','1',151498.94,151498.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','222',5315,'11','1',597093.68,599387.50,2293.82,401418.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','222',5316,'12','1',160012.15,160563.87,551.72,96551.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','222',5317,'13','1',241367.67,241605.78,238.11,41669.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','222',5318,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','222',5319,'15','1',255985.65,255985.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','222',5320,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','222',5321,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','222',5322,'18','1',288026.13,288026.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','222',5323,'19','1',62366.59,62366.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','222',5324,'20','1',281255.13,281255.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','222',5325,'21','2',197139.23,197159.23,20.00,16200.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','222',5326,'22','2',108252.60,108841.28,588.68,476830.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','222',5327,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','222',5328,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','223',5329,'1','1',771964.15,775659.97,3695.82,646768.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','223',5330,'2','1',331919.12,334285.99,2366.87,414202.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','223',5331,'3','1',587528.51,587528.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','223',5332,'4','1',269906.61,269906.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','223',5333,'5','1',760883.42,765546.83,4663.41,816096.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','223',5334,'6','1',127035.69,128838.81,1803.12,315546.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','223',5335,'7','1',555284.09,559262.36,3978.27,696197.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','223',5336,'8','1',284043.41,285194.57,1151.16,201453.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','223',5337,'9','1',490507.36,494262.04,3754.68,657069.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','223',5338,'10','1',151498.94,152877.73,1378.79,241288.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','223',5339,'11','1',599387.50,603882.14,4494.64,786562.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','223',5340,'12','1',160563.87,161647.82,1083.95,189691.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','223',5341,'13','1',241605.78,242394.75,788.97,138069.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','223',5342,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','223',5343,'15','1',255985.65,259663.36,3677.71,643599.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','223',5344,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','223',5345,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','223',5346,'18','1',288026.13,291697.80,3671.67,642542.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','223',5347,'19','1',62366.59,62366.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','223',5348,'20','1',281255.13,281255.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','223',5349,'21','2',197159.23,197179.23,20.00,16200.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','223',5350,'22','2',108841.28,109542.17,700.89,567720.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','223',5351,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','223',5352,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','224',5353,'1','1',775659.97,779289.30,3629.33,635132.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','224',5354,'2','1',334285.99,336374.66,2088.67,365517.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','224',5355,'3','1',587528.51,590971.39,3442.88,602504.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','224',5356,'4','1',269906.61,271518.52,1611.91,282084.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','224',5357,'5','1',765546.83,769482.28,3935.45,688703.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','224',5358,'6','1',128838.81,130611.09,1772.28,310149.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','224',5359,'7','1',559262.36,560706.47,1444.11,252719.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','224',5360,'8','1',285194.57,286239.68,1045.11,182894.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','224',5361,'9','1',494262.04,495675.31,1413.27,247322.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','224',5362,'10','1',152877.73,153370.72,492.99,86273.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','224',5363,'11','1',603882.14,604986.49,1104.35,193261.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','224',5364,'12','1',161647.82,161647.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','224',5365,'13','1',242394.75,242394.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','224',5366,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','224',5367,'15','1',259663.36,259663.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','224',5368,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','224',5369,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','224',5370,'18','1',291697.80,292858.36,1160.56,203098.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','224',5371,'19','1',62366.59,62415.16,48.57,8499.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','224',5372,'20','1',281255.13,286366.04,5110.91,894409.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','224',5373,'21','2',197179.23,197179.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','224',5374,'22','2',109542.17,111553.58,2011.41,1629242.10,0.00,0.00,0.00,0.00,0.00),('1','248','5','224',5375,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','224',5376,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','225',5377,'1','1',779289.30,783382.57,4073.27,712822.25,0.00,0.00,20.00,0.00,0.00),('1','248','1','225',5378,'2','1',336374.66,340054.65,3659.99,640498.25,0.00,0.00,20.00,0.00,0.00),('1','248','1','225',5379,'3','1',590971.39,593667.59,2676.20,468335.00,0.00,0.00,20.00,0.00,0.00),('1','248','1','225',5380,'4','1',271518.52,273518.52,1980.00,346500.00,0.00,0.00,20.00,0.00,0.00),('1','248','1','225',5381,'5','1',769482.28,773180.73,3678.45,643728.75,0.00,0.00,20.00,0.00,0.00),('1','248','1','225',5382,'6','1',130611.09,133866.89,3235.80,566265.00,0.00,0.00,20.00,0.00,0.00),('1','248','2','225',5383,'7','1',560706.47,564634.27,3907.80,683865.00,0.00,0.00,20.00,0.00,0.00),('1','248','2','225',5384,'8','1',286239.68,290378.48,4118.80,720790.00,0.00,0.00,20.00,0.00,0.00),('1','248','2','225',5385,'9','1',495675.31,499454.91,3759.60,657930.00,0.00,0.00,20.00,0.00,0.00),('1','248','2','225',5386,'10','1',153370.72,155905.95,2515.23,440165.25,0.00,0.00,20.00,0.00,0.00),('1','248','2','225',5387,'11','1',604986.49,609442.19,4435.70,776247.50,0.00,0.00,20.00,0.00,0.00),('1','248','2','225',5388,'12','1',161647.82,162837.28,1169.46,204655.50,0.00,0.00,20.00,0.00,0.00),('1','248','3','225',5389,'13','1',242394.75,242394.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','225',5390,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','225',5391,'15','1',259663.36,259663.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','225',5392,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','225',5393,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','225',5394,'18','1',292858.36,292858.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','225',5395,'19','1',62415.16,62415.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','225',5396,'20','1',286366.04,286366.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','225',5397,'21','2',197179.23,197179.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','225',5398,'22','2',111553.58,112561.21,1007.63,816180.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','225',5399,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','225',5400,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','226',5401,'1','1',783382.57,785058.61,1676.04,293307.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','226',5402,'2','1',340054.65,341246.69,1192.04,208607.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','226',5403,'3','1',593667.59,595161.38,1493.79,261413.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','226',5404,'4','1',273518.52,273518.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','226',5405,'5','1',773180.73,774545.54,1364.81,238841.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','226',5406,'6','1',133866.89,134665.41,798.52,139741.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','226',5407,'7','1',564634.27,566189.48,1555.21,272161.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','226',5408,'8','1',290378.48,291662.77,1284.29,224750.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','226',5409,'9','1',499454.91,501283.11,1828.20,319935.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','226',5410,'10','1',155905.95,155905.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','226',5411,'11','1',609442.19,611246.04,1803.85,315673.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','226',5412,'12','1',162837.28,162837.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','226',5413,'13','1',242394.75,242394.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','226',5414,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','226',5415,'15','1',259663.36,259663.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','226',5416,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','226',5417,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','226',5418,'18','1',292858.36,292858.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','226',5419,'19','1',62415.16,62415.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','226',5420,'20','1',286366.04,286366.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','226',5421,'21','2',197179.23,197189.33,10.10,8181.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','226',5422,'22','2',112561.21,114407.59,1846.38,1495567.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','226',5423,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','226',5424,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','227',5425,'1','1',785058.61,790511.29,5452.68,954219.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','227',5426,'2','1',341246.69,346272.96,5026.27,879597.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','227',5427,'3','1',595161.38,599803.56,4642.18,812381.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','227',5428,'4','1',273518.52,276165.20,2646.68,463169.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','227',5429,'5','1',774545.54,779183.32,4637.78,811611.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','227',5430,'6','1',134665.41,138266.44,3601.03,630180.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','227',5431,'7','1',566189.48,569034.61,2845.13,497897.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','227',5432,'8','1',291662.77,293733.79,2071.02,362428.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','227',5433,'9','1',501283.11,504524.39,3241.28,567224.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','227',5434,'10','1',155905.95,157495.34,1589.39,278143.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','227',5435,'11','1',611246.04,614047.67,2801.63,490285.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','227',5436,'12','1',162837.28,163969.09,1131.81,198066.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','227',5437,'13','1',242394.75,242394.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','227',5438,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','227',5439,'15','1',259663.36,259663.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','227',5440,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','227',5441,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','227',5442,'18','1',292858.36,292858.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','227',5443,'19','1',62415.16,62415.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','227',5444,'20','1',286366.04,286366.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','227',5445,'21','2',197189.33,197429.62,240.29,194634.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','227',5446,'22','2',114407.59,116078.98,1671.39,1353825.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','227',5447,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','227',5448,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','228',5449,'1','1',790511.29,791768.42,1257.13,219997.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','228',5450,'2','1',346272.96,347352.70,1079.74,188954.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','228',5451,'3','1',599803.56,601037.93,1234.37,216014.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','228',5452,'4','1',276165.20,277302.56,1137.36,199038.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','228',5453,'5','1',779183.32,780534.44,1351.12,236446.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','228',5454,'6','1',138266.44,139350.23,1083.79,189663.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','228',5455,'7','1',569034.61,569034.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','228',5456,'8','1',293733.79,293733.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','228',5457,'9','1',504524.39,504524.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','228',5458,'10','1',157495.34,157495.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','228',5459,'11','1',614047.67,614047.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','228',5460,'12','1',163969.09,163969.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','228',5461,'13','1',242394.75,242394.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','228',5462,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','228',5463,'15','1',259663.36,259663.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','228',5464,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','228',5465,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','228',5466,'18','1',292858.36,292858.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','228',5467,'19','1',62415.16,62415.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','228',5468,'20','1',286366.04,286366.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','228',5469,'21','2',197429.62,197429.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','228',5470,'22','2',116078.98,116947.58,868.60,703566.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','228',5471,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','228',5472,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','229',5473,'1','1',791768.42,793516.66,1748.24,305942.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','229',5474,'2','1',347352.70,348189.64,836.94,146464.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','229',5475,'3','1',601037.93,603333.60,2295.67,401742.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','229',5476,'4','1',277302.56,277302.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','229',5477,'5','1',780534.44,782440.91,1906.47,333632.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','229',5478,'6','1',139350.23,139350.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','229',5479,'7','1',569034.61,570669.19,1634.58,286051.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','229',5480,'8','1',293733.79,294670.02,936.23,163840.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','229',5481,'9','1',504524.39,506530.19,2005.80,351015.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','229',5482,'10','1',157495.34,157495.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','229',5483,'11','1',614047.67,615569.21,1521.54,266269.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','229',5484,'12','1',163969.09,164493.73,524.64,91812.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','229',5485,'13','1',242394.75,242394.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','229',5486,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','229',5487,'15','1',259663.36,259663.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','229',5488,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','229',5489,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','229',5490,'18','1',292858.36,292858.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','229',5491,'19','1',62415.16,62415.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','229',5492,'20','1',286366.04,286366.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','229',5493,'21','2',197429.62,198476.06,1046.44,847616.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','229',5494,'22','2',116947.58,118987.33,2039.75,1652197.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','229',5495,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','229',5496,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','230',5497,'1','1',793516.66,798254.83,4738.17,829179.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','230',5498,'2','1',348189.64,353185.47,4995.83,874270.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','230',5499,'3','1',603333.60,607458.79,4125.19,721908.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','230',5500,'4','1',277302.56,281135.28,3832.72,670726.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','230',5501,'5','1',782440.91,787190.17,4749.26,831120.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','230',5502,'6','1',139350.23,142155.88,2805.65,490988.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','230',5503,'7','1',570669.19,572262.67,1593.48,278859.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','230',5504,'8','1',294670.02,296075.68,1405.66,245990.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','230',5505,'9','1',506530.19,508258.23,1728.04,302407.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','230',5506,'10','1',157495.34,157495.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','230',5507,'11','1',615569.21,617112.28,1543.07,270037.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','230',5508,'12','1',164493.73,164584.15,90.42,15823.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','230',5509,'13','1',242394.75,242394.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','230',5510,'14','1',89337.52,89337.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','230',5511,'15','1',259663.36,259663.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','230',5512,'16','1',65830.40,65830.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','230',5513,'17','1',55943.48,55943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','230',5514,'18','1',292858.36,292858.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','230',5515,'19','1',62415.16,62415.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','230',5516,'20','1',286366.04,286366.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','230',5517,'21','2',198476.06,198476.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','230',5518,'22','2',118987.33,118987.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','230',5519,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','230',5520,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','231',5521,'1','1',798254.83,801205.67,2950.84,516397.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','231',5522,'2','1',353185.47,355509.53,2324.06,406710.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','231',5523,'3','1',607458.79,611554.15,4095.36,716688.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','231',5524,'4','1',281135.28,281135.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','231',5525,'5','1',787190.17,790488.51,3298.34,577209.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','231',5526,'6','1',142155.88,142618.13,462.25,80893.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','231',5527,'7','1',572262.67,572262.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','231',5528,'8','1',296075.68,296075.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','231',5529,'9','1',508258.23,508258.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','231',5530,'10','1',157495.34,157495.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','231',5531,'11','1',617112.28,617112.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','231',5532,'12','1',164584.15,164584.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','231',5533,'13','1',242394.75,244660.48,2265.73,396502.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','231',5534,'14','1',89337.52,89629.56,292.04,51107.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','231',5535,'15','1',259663.36,261437.52,1774.16,310478.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','231',5536,'16','1',65830.40,66616.11,785.71,137499.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','231',5537,'17','1',55943.48,57056.32,1112.84,194747.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','231',5538,'18','1',292858.36,294825.12,1966.76,344183.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','231',5539,'19','1',62415.16,62761.77,346.61,60656.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','231',5540,'20','1',286366.04,288055.62,1689.58,295676.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','231',5541,'21','2',198476.06,200993.77,2517.71,2039345.10,0.00,0.00,0.00,0.00,0.00),('1','248','4','231',5542,'22','2',118987.33,120192.02,1204.69,975798.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','231',5543,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','231',5544,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','232',5545,'1','1',801205.67,804394.63,3188.96,558068.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','232',5546,'2','1',355509.53,356971.37,1461.84,255822.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','232',5547,'3','1',611554.15,615024.39,3470.24,607292.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','232',5548,'4','1',281135.28,281384.50,249.22,43613.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','232',5549,'5','1',790488.51,794408.74,3920.23,686040.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','232',5550,'6','1',142618.13,142618.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','232',5551,'7','1',572262.67,576043.00,3780.33,661557.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','232',5552,'8','1',296075.68,298041.76,1966.08,344064.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','232',5553,'9','1',508258.23,512187.47,3929.24,687617.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','232',5554,'10','1',157495.34,157495.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','232',5555,'11','1',617112.28,620893.97,3781.69,661795.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','232',5556,'12','1',164584.15,164584.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','232',5557,'13','1',244660.48,245376.74,716.26,125345.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','232',5558,'14','1',89629.56,89629.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','232',5559,'15','1',261437.52,262345.55,908.03,158905.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','232',5560,'16','1',66616.11,66616.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','232',5561,'17','1',57056.32,58014.20,957.88,167629.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','232',5562,'18','1',294825.12,298253.90,3428.78,600036.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','232',5563,'19','1',62761.77,63476.44,714.67,125067.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','232',5564,'20','1',288055.62,290601.82,2546.20,445585.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','232',5565,'21','2',200993.77,202129.14,1135.37,919649.70,0.00,0.00,0.00,0.00,0.00),('1','248','4','232',5566,'22','2',120192.02,120206.47,14.45,11704.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','232',5567,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','232',5568,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','233',5569,'1','1',804394.63,809019.81,4625.18,809406.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','233',5570,'2','1',356971.37,359834.11,2862.74,500979.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','233',5571,'3','1',615024.39,615024.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','233',5572,'4','1',281384.50,281384.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','233',5573,'5','1',794408.74,799274.84,4866.10,851567.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','233',5574,'6','1',142618.13,142618.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','233',5575,'7','1',576043.00,578598.11,2555.11,447144.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','233',5576,'8','1',298041.76,299631.30,1589.54,278169.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','233',5577,'9','1',512187.47,512187.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','233',5578,'10','1',157495.34,157495.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','233',5579,'11','1',620893.97,623162.63,2268.66,397015.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','233',5580,'12','1',164584.15,164584.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','233',5581,'13','1',245376.74,245376.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','233',5582,'14','1',89629.56,89629.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','233',5583,'15','1',262345.55,262345.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','233',5584,'16','1',66616.11,66616.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','233',5585,'17','1',58014.20,58014.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','233',5586,'18','1',298253.90,300364.91,2111.01,369426.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','233',5587,'19','1',63476.44,64922.52,1446.08,253064.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','233',5588,'20','1',290601.82,294047.81,3445.99,603048.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','233',5589,'21','2',202129.14,203128.60,999.46,809562.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','233',5590,'22','2',120206.47,122007.21,1800.74,1458599.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','233',5591,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','233',5592,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','234',5593,'1','1',809019.81,811145.30,2125.49,371960.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','234',5594,'2','1',359834.11,361735.21,1901.10,332692.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','234',5595,'3','1',615024.39,615024.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','234',5596,'4','1',281384.50,281384.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','234',5597,'5','1',799274.84,802084.55,2809.71,491699.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','234',5598,'6','1',142618.13,142618.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','234',5599,'7','1',578598.11,581964.68,3366.57,589149.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','234',5600,'8','1',299631.30,302338.28,2706.98,473721.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','234',5601,'9','1',512187.47,512187.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','234',5602,'10','1',157495.34,157495.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','234',5603,'11','1',623162.63,627451.23,4288.60,750505.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','234',5604,'12','1',164584.15,168189.17,3605.02,630878.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','234',5605,'13','1',245376.74,247723.10,2346.36,410613.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','234',5606,'14','1',89629.56,91018.15,1388.59,243003.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','234',5607,'15','1',262345.55,264756.44,2410.89,421905.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','234',5608,'16','1',66616.11,66616.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','234',5609,'17','1',58014.20,58664.15,649.95,113741.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','234',5610,'18','1',300364.91,303771.47,3406.56,596148.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','234',5611,'19','1',64922.52,65809.20,886.68,155169.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','234',5612,'20','1',294047.81,296820.91,2773.10,485292.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','234',5613,'21','2',203128.60,203783.48,654.88,530452.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','234',5614,'22','2',122007.21,122007.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','234',5615,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','234',5616,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','235',5617,'1','1',811145.30,811145.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','235',5618,'2','1',361735.21,361735.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','235',5619,'3','1',615024.39,615024.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','235',5620,'4','1',281384.50,281384.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','235',5621,'5','1',802084.55,802763.13,678.58,118751.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','235',5622,'6','1',142618.13,143124.36,506.23,88590.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','235',5623,'7','1',581964.68,584758.09,2793.41,488846.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','235',5624,'8','1',302338.28,304583.90,2245.62,392983.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','235',5625,'9','1',512187.47,512187.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','235',5626,'10','1',157495.34,157495.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','235',5627,'11','1',627451.23,630459.56,3008.33,526457.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','235',5628,'12','1',168189.17,169875.04,1685.87,295027.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','235',5629,'13','1',247723.10,249665.71,1942.61,339956.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','235',5630,'14','1',91018.15,92155.60,1137.45,199053.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','235',5631,'15','1',264756.44,266193.50,1437.06,251485.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','235',5632,'16','1',66616.11,67322.88,706.77,123684.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','235',5633,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','235',5634,'18','1',303771.47,305394.23,1622.76,283983.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','235',5635,'19','1',65809.20,65809.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','235',5636,'20','1',296820.91,298450.18,1629.27,285122.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','235',5637,'21','2',203783.48,205266.17,1482.69,1200978.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','235',5638,'22','2',122007.21,122007.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','235',5639,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','235',5640,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','236',5641,'1','1',811145.30,816430.81,5285.51,924964.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','236',5642,'2','1',361735.21,366467.55,4732.34,828159.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','236',5643,'3','1',615024.39,620675.07,5650.68,988869.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','236',5644,'4','1',281384.50,284510.95,3126.45,547128.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','236',5645,'5','1',802763.13,808185.27,5422.14,948874.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','236',5646,'6','1',143124.36,148452.92,5328.56,932498.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','236',5647,'7','1',584758.09,584758.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','236',5648,'8','1',304583.90,304583.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','236',5649,'9','1',512187.47,512187.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','236',5650,'10','1',157495.34,157495.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','236',5651,'11','1',630459.56,630459.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','236',5652,'12','1',169875.04,169875.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','236',5653,'13','1',249665.71,249665.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','236',5654,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','236',5655,'15','1',266193.50,266193.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','236',5656,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','236',5657,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','236',5658,'18','1',305394.23,305394.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','236',5659,'19','1',65809.20,65809.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','236',5660,'20','1',298450.18,298450.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','236',5661,'21','2',205266.17,205266.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','236',5662,'22','2',122007.21,123091.30,1084.09,878112.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','236',5663,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','236',5664,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','237',5665,'1','1',816430.81,817759.04,1328.23,232440.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','237',5666,'2','1',366467.55,368045.28,1577.73,276102.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','237',5667,'3','1',620675.07,622520.30,1845.23,322915.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','237',5668,'4','1',284510.95,284510.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','237',5669,'5','1',808185.27,809801.12,1615.85,282773.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','237',5670,'6','1',148452.92,148809.56,356.64,62412.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','237',5671,'7','1',584758.09,585956.59,1198.50,209737.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','237',5672,'8','1',304583.90,305507.57,923.67,161642.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','237',5673,'9','1',512187.47,513440.55,1253.08,219289.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','237',5674,'10','1',157495.34,158156.49,661.15,115701.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','237',5675,'11','1',630459.56,631906.19,1446.63,253160.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','237',5676,'12','1',169875.04,169966.81,91.77,16059.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','237',5677,'13','1',249665.71,249665.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','237',5678,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','237',5679,'15','1',266193.50,266193.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','237',5680,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','237',5681,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','237',5682,'18','1',305394.23,305394.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','237',5683,'19','1',65809.20,65809.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','237',5684,'20','1',298450.18,298450.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','237',5685,'21','2',205266.17,206366.17,1100.00,891000.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','237',5686,'22','2',123091.30,124211.31,1120.01,907208.10,0.00,0.00,0.00,0.00,0.00),('1','248','5','237',5687,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','237',5688,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','238',5689,'1','1',817759.04,821075.52,3316.48,580384.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','238',5690,'2','1',368045.28,372542.51,4497.23,787015.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','238',5691,'3','1',622520.30,627168.77,4648.47,813482.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','238',5692,'4','1',284510.95,286872.98,2362.03,413355.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','238',5693,'5','1',809801.12,814311.67,4510.55,789346.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','238',5694,'6','1',148809.56,153004.13,4194.57,734049.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','238',5695,'7','1',585956.59,588405.56,2448.97,428569.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','238',5696,'8','1',305507.57,307434.87,1927.30,337277.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','238',5697,'9','1',513440.55,515738.04,2297.49,402060.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','238',5698,'10','1',158156.49,158699.00,542.51,94939.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','238',5699,'11','1',631906.19,634195.36,2289.17,400604.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','238',5700,'12','1',169966.81,169966.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','238',5701,'13','1',249665.71,249665.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','238',5702,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','238',5703,'15','1',266193.50,266193.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','238',5704,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','238',5705,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','238',5706,'18','1',305394.23,305394.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','238',5707,'19','1',65809.20,65809.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','238',5708,'20','1',298450.18,298450.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','238',5709,'21','2',206366.17,206366.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','238',5710,'22','2',124211.31,124792.18,580.87,470504.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','238',5711,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','238',5712,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','239',5713,'1','1',821075.52,823346.13,2270.61,397356.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','239',5714,'2','1',372542.51,374805.93,2263.42,396098.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','239',5715,'3','1',627168.77,629189.33,2020.56,353598.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','239',5716,'4','1',286872.98,288859.54,1986.56,347648.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','239',5717,'5','1',814311.67,817601.91,3290.24,575792.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','239',5718,'6','1',153004.13,153004.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','239',5719,'7','1',588405.56,591453.85,3048.29,533450.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','239',5720,'8','1',307434.87,309643.07,2208.20,386435.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','239',5721,'9','1',515738.04,517695.51,1957.47,342557.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','239',5722,'10','1',158699.00,158699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','239',5723,'11','1',634195.36,637166.85,2971.49,520010.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','239',5724,'12','1',169966.81,169966.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','239',5725,'13','1',249665.71,249665.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','239',5726,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','239',5727,'15','1',266193.50,266193.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','239',5728,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','239',5729,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','239',5730,'18','1',305394.23,305394.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','239',5731,'19','1',65809.20,65809.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','239',5732,'20','1',298450.18,298450.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','239',5733,'21','2',206366.17,206366.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','239',5734,'22','2',124792.18,124792.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','239',5735,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','239',5736,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','240',5737,'1','1',823346.13,825708.05,2361.92,413336.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','240',5738,'2','1',374805.93,376668.94,1863.01,326026.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','240',5739,'3','1',629189.33,630697.38,1508.05,263908.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','240',5740,'4','1',288859.54,290170.14,1310.60,229355.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','240',5741,'5','1',817601.91,819715.68,2113.77,369909.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','240',5742,'6','1',153004.13,153004.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','240',5743,'7','1',591453.85,594247.52,2793.67,488892.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','240',5744,'8','1',309643.07,310993.28,1350.21,236286.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','240',5745,'9','1',517695.51,520796.66,3101.15,542701.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','240',5746,'10','1',158699.00,158699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','240',5747,'11','1',637166.85,638884.52,1717.67,300592.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','240',5748,'12','1',169966.81,170944.43,977.62,171083.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','240',5749,'13','1',249665.71,249665.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','240',5750,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','240',5751,'15','1',266193.50,266193.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','240',5752,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','240',5753,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','240',5754,'18','1',305394.23,305394.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','240',5755,'19','1',65809.20,65809.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','240',5756,'20','1',298450.18,298450.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','240',5757,'21','2',206366.17,208102.93,1734.91,1405277.10,0.00,0.00,1.85,0.00,0.00),('1','248','4','240',5758,'22','2',124792.18,124793.74,1.56,1263.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','240',5759,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','240',5760,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','241',5761,'1','1',825708.05,825708.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','241',5762,'2','1',376668.94,376668.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','241',5763,'3','1',630697.38,630697.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','241',5764,'4','1',290170.14,290170.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','241',5765,'5','1',819715.68,819715.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','241',5766,'6','1',153004.13,153004.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','241',5767,'7','1',594247.52,594247.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','241',5768,'8','1',310993.28,310993.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','241',5769,'9','1',520796.66,520796.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','241',5770,'10','1',158699.00,158699.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','241',5771,'11','1',638884.52,638884.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','241',5772,'12','1',170944.43,170944.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','241',5773,'13','1',249665.71,249665.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','241',5774,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','241',5775,'15','1',266193.50,266193.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','241',5776,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','241',5777,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','241',5778,'18','1',305394.23,305394.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','241',5779,'19','1',65809.20,65809.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','241',5780,'20','1',298450.18,298450.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','241',5781,'21','2',208102.93,210806.02,2703.09,2162472.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','241',5782,'22','2',124793.74,124793.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','241',5783,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','241',5784,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','242',5785,'1','1',825708.05,830318.84,4610.79,806888.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','242',5786,'2','1',376668.94,379453.58,2784.64,487312.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','242',5787,'3','1',630697.38,635174.49,4477.11,783494.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','242',5788,'4','1',290170.14,291509.56,1339.42,234398.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','242',5789,'5','1',819715.68,823743.86,4028.18,704931.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','242',5790,'6','1',153004.13,155366.07,2361.94,413339.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','242',5791,'7','1',594247.52,598127.32,3879.80,678965.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','242',5792,'8','1',310993.28,313169.04,2175.76,380758.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','242',5793,'9','1',520796.66,523259.28,2462.62,430958.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','242',5794,'10','1',158699.00,160537.75,1838.75,321781.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','242',5795,'11','1',638884.52,643474.48,4589.96,803243.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','242',5796,'12','1',170944.43,172585.22,1640.79,287138.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','242',5797,'13','1',249665.71,249665.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','242',5798,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','242',5799,'15','1',266193.50,267089.58,896.08,156814.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','242',5800,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','242',5801,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','242',5802,'18','1',305394.23,306913.85,1519.62,265933.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','242',5803,'19','1',65809.20,65809.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','242',5804,'20','1',298450.18,300294.81,1844.63,322810.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','242',5805,'21','2',210806.02,212880.11,2074.09,1659272.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','242',5806,'22','2',124793.74,125033.85,240.11,192088.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','242',5807,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','242',5808,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','243',5809,'1','1',830318.84,835219.24,4900.40,857570.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','243',5810,'2','1',379453.58,379686.64,233.06,40785.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','243',5811,'3','1',635174.49,639637.16,4462.67,780967.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','243',5812,'4','1',291509.56,291509.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','243',5813,'5','1',823743.86,828415.26,4671.40,817495.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','243',5814,'6','1',155366.07,155366.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','243',5815,'7','1',598127.32,603884.44,5757.12,1007496.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','243',5816,'8','1',313169.04,313169.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','243',5817,'9','1',523259.28,523259.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','243',5818,'10','1',160537.75,160537.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','243',5819,'11','1',643474.48,647050.04,3575.56,625723.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','243',5820,'12','1',172585.22,173239.79,654.57,114549.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','243',5821,'13','1',249665.71,249665.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','243',5822,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','243',5823,'15','1',267089.58,267089.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','243',5824,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','243',5825,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','243',5826,'18','1',306913.85,311106.07,4192.22,733638.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','243',5827,'19','1',65809.20,66307.52,498.32,87206.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','243',5828,'20','1',300294.81,304676.71,4336.19,758833.25,0.00,0.00,45.71,0.00,0.00),('1','248','4','243',5829,'21','2',212880.11,215382.13,2502.02,2001616.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','243',5830,'22','2',125033.85,126091.06,1057.21,845768.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','243',5831,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','243',5832,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','244',5833,'1','1',835219.24,839469.08,4249.84,743722.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','244',5834,'2','1',379686.64,380418.53,731.89,128080.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','244',5835,'3','1',639637.16,639637.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','244',5836,'4','1',291509.56,291509.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','244',5837,'5','1',828415.26,831933.41,3518.15,615676.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','244',5838,'6','1',155366.07,155988.60,622.53,108942.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','244',5839,'7','1',603884.44,607714.73,3830.29,670300.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','244',5840,'8','1',313169.04,315270.20,2101.16,367703.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','244',5841,'9','1',523259.28,525839.46,2580.18,451531.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','244',5842,'10','1',160537.75,161802.95,1265.20,221410.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','244',5843,'11','1',647050.04,650754.19,3704.15,648226.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','244',5844,'12','1',173239.79,174481.38,1241.59,217278.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','244',5845,'13','1',249665.71,252290.69,2624.98,459371.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','244',5846,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','244',5847,'15','1',267089.58,267181.12,91.54,16019.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','244',5848,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','244',5849,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','244',5850,'18','1',311106.07,313894.22,2788.15,487926.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','244',5851,'19','1',66307.52,66307.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','244',5852,'20','1',304676.71,308168.41,3491.70,611047.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','244',5853,'21','2',215382.13,215461.67,79.54,63632.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','244',5854,'22','2',126091.06,127278.75,1187.69,950152.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','244',5855,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','244',5856,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','245',5857,'1','1',839469.08,842695.99,3226.91,564709.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','245',5858,'2','1',380418.53,380923.09,504.56,88298.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','245',5859,'3','1',639637.16,641263.61,1606.45,281128.75,0.00,0.00,20.00,0.00,0.00),('1','248','1','245',5860,'4','1',291509.56,292307.27,797.71,139599.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','245',5861,'5','1',831933.41,835586.92,3653.51,639364.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','245',5862,'6','1',155988.60,155988.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','245',5863,'7','1',607714.73,612296.15,4581.42,801748.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','245',5864,'8','1',315270.20,315270.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','245',5865,'9','1',525839.46,526201.45,361.99,63348.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','245',5866,'10','1',161802.95,161802.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','245',5867,'11','1',650754.19,654066.92,3312.73,579727.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','245',5868,'12','1',174481.38,174481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','245',5869,'13','1',252290.69,254647.91,2357.22,412513.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','245',5870,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','245',5871,'15','1',267181.12,269375.63,2194.51,384039.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','245',5872,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','245',5873,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','245',5874,'18','1',313894.22,315518.32,1614.10,282467.50,0.00,0.00,10.00,0.00,0.00),('1','248','3','245',5875,'19','1',66307.52,66307.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','245',5876,'20','1',308168.41,310454.10,2285.69,399995.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','245',5877,'21','2',215461.67,215663.76,202.09,161672.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','245',5878,'22','2',127278.75,129038.87,1760.12,1408096.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','245',5879,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','245',5880,'24','2',12897.78,12897.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','246',5881,'1','1',842695.99,846689.63,3993.64,698887.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','246',5882,'2','1',380923.09,382943.71,2020.62,353608.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','246',5883,'3','1',641263.61,646373.41,5099.80,892465.00,0.00,0.00,10.00,0.00,0.00),('1','248','1','246',5884,'4','1',292307.27,292307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','246',5885,'5','1',835586.92,839421.03,3814.11,667469.25,0.00,0.00,20.00,0.00,0.00),('1','248','1','246',5886,'6','1',155988.60,155988.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','246',5887,'7','1',612296.15,616848.26,4552.11,796619.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','246',5888,'8','1',315270.20,317183.70,1913.50,334862.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','246',5889,'9','1',526201.45,526201.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','246',5890,'10','1',161802.95,161802.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','246',5891,'11','1',654066.92,658145.83,4078.91,713809.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','246',5892,'12','1',174481.38,175574.25,1092.87,191252.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','246',5893,'13','1',254647.91,254647.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','246',5894,'14','1',92155.60,92155.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','246',5895,'15','1',269375.63,269375.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','246',5896,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','246',5897,'17','1',58664.15,58664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','246',5898,'18','1',315518.32,319414.15,3895.83,681770.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','246',5899,'19','1',66307.52,66307.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','246',5900,'20','1',310454.10,314656.60,4202.50,735437.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','246',5901,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','246',5902,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','246',5903,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','246',5904,'24','2',12897.78,14413.96,1512.89,1210312.00,0.00,0.00,3.29,0.00,0.00),('1','248','1','247',5905,'1','1',846689.63,851229.67,4540.04,794507.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','247',5906,'2','1',382943.71,382943.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','247',5907,'3','1',646373.41,647573.04,1199.63,209935.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','247',5908,'4','1',292307.27,292307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','247',5909,'5','1',839421.03,843588.92,4167.89,729380.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','247',5910,'6','1',155988.60,156043.48,54.88,9604.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','247',5911,'7','1',616848.26,622070.22,5221.96,913843.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','247',5912,'8','1',317183.70,317183.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','247',5913,'9','1',526201.45,529936.11,3734.66,653565.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','247',5914,'10','1',161802.95,161837.24,34.29,6000.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','247',5915,'11','1',658145.83,660670.37,2524.54,441794.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','247',5916,'12','1',175574.25,177235.62,1661.37,290739.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','247',5917,'13','1',254647.91,257466.82,2818.91,493309.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','247',5918,'14','1',92155.60,92285.93,130.33,22807.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','247',5919,'15','1',269375.63,269443.47,67.84,11872.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','247',5920,'16','1',67322.88,67322.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','247',5921,'17','1',58664.15,61768.86,3104.71,543324.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','247',5922,'18','1',319414.15,319548.90,134.75,23581.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','247',5923,'19','1',66307.52,68012.35,1704.83,298345.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','247',5924,'20','1',314656.60,316077.75,1421.15,248701.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','247',5925,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','247',5926,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','247',5927,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','247',5928,'24','2',14413.96,15990.63,1576.67,1261336.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','248',5929,'1','1',851229.67,855002.32,3772.65,660213.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','248',5930,'2','1',382943.71,384725.07,1781.36,311738.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','248',5931,'3','1',647573.04,647573.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','248',5932,'4','1',292307.27,292307.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','248',5933,'5','1',843588.92,846870.46,3281.54,574269.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','248',5934,'6','1',156043.48,157881.43,1837.95,321641.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','248',5935,'7','1',622070.22,626125.15,4054.93,709612.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','248',5936,'8','1',317183.70,318380.57,1196.87,209452.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','248',5937,'9','1',529936.11,531152.87,1216.76,212933.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','248',5938,'10','1',161837.24,162495.88,658.64,115262.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','248',5939,'11','1',660670.37,664048.07,3377.70,591097.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','248',5940,'12','1',177235.62,178124.58,888.96,155568.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','248',5941,'13','1',257466.82,257883.95,417.13,72997.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','248',5942,'14','1',92285.93,92553.59,267.66,46840.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','248',5943,'15','1',269443.47,269771.93,328.46,57480.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','248',5944,'16','1',67322.88,67578.62,255.74,44754.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','248',5945,'17','1',61768.86,63173.44,1404.58,245801.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','248',5946,'18','1',319548.90,321912.14,2363.24,413567.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','248',5947,'19','1',68012.35,69446.09,1433.74,250904.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','248',5948,'20','1',316077.75,318735.30,2657.55,465071.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','248',5949,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','248',5950,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','248',5951,'23','2',98536.36,98536.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','248',5952,'24','2',15990.63,18116.73,2126.10,1700880.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','249',5953,'1','1',855002.32,859107.28,4104.96,718368.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','249',5954,'2','1',384725.07,386763.00,2037.93,356637.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','249',5955,'3','1',647573.04,648354.17,781.13,136697.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','249',5956,'4','1',292307.27,293231.94,924.67,161817.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','249',5957,'5','1',846870.46,852078.13,5207.67,911342.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','249',5958,'6','1',157881.43,158757.81,876.38,153366.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','249',5959,'7','1',626125.15,630325.76,4200.61,735106.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','249',5960,'8','1',318380.57,318558.65,178.08,31164.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','249',5961,'9','1',531152.87,531152.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','249',5962,'10','1',162495.88,162495.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','249',5963,'11','1',664048.07,667360.15,3312.08,579614.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','249',5964,'12','1',178124.58,179096.47,971.89,170080.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','249',5965,'13','1',257883.95,257883.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','249',5966,'14','1',92553.59,92553.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','249',5967,'15','1',269771.93,269771.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','249',5968,'16','1',67578.62,67578.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','249',5969,'17','1',63173.44,63173.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','249',5970,'18','1',321912.14,325103.03,3190.89,558405.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','249',5971,'19','1',69446.09,69446.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','249',5972,'20','1',318735.30,318735.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','249',5973,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','249',5974,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','249',5975,'23','2',98536.36,99372.62,836.26,669008.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','249',5976,'24','2',18116.73,20623.08,2506.35,2005080.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','250',5977,'1','1',859107.28,863073.80,3966.52,694141.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','250',5978,'2','1',386763.00,388532.15,1769.15,309601.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','250',5979,'3','1',648354.17,650418.90,2064.73,361327.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','250',5980,'4','1',293231.94,293231.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','250',5981,'5','1',852078.13,855703.07,3624.94,634364.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','250',5982,'6','1',158757.81,160345.86,1588.05,277908.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','250',5983,'7','1',630325.76,634832.47,4506.71,788674.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','250',5984,'8','1',318558.65,319909.04,1350.39,236318.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','250',5985,'9','1',531152.87,531152.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','250',5986,'10','1',162495.88,162495.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','250',5987,'11','1',667360.15,672139.98,4779.83,836470.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','250',5988,'12','1',179096.47,179096.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','250',5989,'13','1',257883.95,257883.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','250',5990,'14','1',92553.59,92553.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','250',5991,'15','1',269771.93,269771.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','250',5992,'16','1',67578.62,67578.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','250',5993,'17','1',63173.44,64850.30,1676.86,293450.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','250',5994,'18','1',325103.03,328331.05,3228.02,564903.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','250',5995,'19','1',69446.09,71004.88,1558.79,272788.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','250',5996,'20','1',318735.30,320465.62,1730.32,302806.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','250',5997,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','250',5998,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','250',5999,'23','2',99372.62,99563.42,190.80,152640.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','250',6000,'24','2',20623.08,21284.08,661.00,528800.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','251',6001,'1','1',863073.80,867661.60,4587.80,802865.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','251',6002,'2','1',388532.15,390165.31,1633.16,285803.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','251',6003,'3','1',650418.90,654789.16,4370.26,764795.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','251',6004,'4','1',293231.94,293860.57,628.63,110010.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','251',6005,'5','1',855703.07,856522.31,819.24,143367.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','251',6006,'6','1',160345.86,160951.58,605.72,106001.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','251',6007,'7','1',634832.47,640079.54,5247.07,918237.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','251',6008,'8','1',319909.04,320853.20,944.16,165228.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','251',6009,'9','1',531152.87,535262.83,4109.96,719243.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','251',6010,'10','1',162495.88,162495.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','251',6011,'11','1',672139.98,672139.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','251',6012,'12','1',179096.47,179096.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','251',6013,'13','1',257883.95,260542.43,2658.48,465234.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','251',6014,'14','1',92553.59,94123.72,1570.13,274772.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','251',6015,'15','1',269771.93,272196.95,2425.02,424378.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','251',6016,'16','1',67578.62,67578.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','251',6017,'17','1',64850.30,65590.32,740.02,129503.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','251',6018,'18','1',328331.05,329869.17,1538.12,269171.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','251',6019,'19','1',71004.88,71004.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','251',6020,'20','1',320465.62,323459.49,2993.87,523927.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','251',6021,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','251',6022,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','251',6023,'23','2',99563.42,100806.18,1242.76,994208.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','251',6024,'24','2',21284.08,22262.43,978.35,782680.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','252',6025,'1','1',867661.60,871582.18,3920.58,686101.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','252',6026,'2','1',390165.31,390878.55,713.24,124817.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','252',6027,'3','1',654789.16,658335.43,3546.27,620597.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','252',6028,'4','1',293860.57,293860.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','252',6029,'5','1',856522.31,859792.77,3224.75,564331.25,0.00,0.00,45.71,0.00,0.00),('1','248','1','252',6030,'6','1',160951.58,161893.98,942.40,164920.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','252',6031,'7','1',640079.54,643653.03,3573.49,625360.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','252',6032,'8','1',320853.20,322884.87,2031.67,355542.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','252',6033,'9','1',535262.83,538701.55,3438.72,601776.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','252',6034,'10','1',162495.88,163040.87,544.99,95373.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','252',6035,'11','1',672139.98,675413.88,3273.90,572932.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','252',6036,'12','1',179096.47,179096.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','252',6037,'13','1',260542.43,263525.65,2983.22,522063.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','252',6038,'14','1',94123.72,94123.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','252',6039,'15','1',272196.95,272196.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','252',6040,'16','1',67578.62,67578.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','252',6041,'17','1',65590.32,65590.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','252',6042,'18','1',329869.17,332342.79,2473.62,432883.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','252',6043,'19','1',71004.88,71004.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','252',6044,'20','1',323459.49,327284.44,3824.95,669366.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','252',6045,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','252',6046,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','252',6047,'23','2',100806.18,101050.43,244.25,195400.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','252',6048,'24','2',22262.43,23898.88,1636.45,1309160.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','253',6049,'1','1',871582.18,874673.21,3091.03,540930.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','253',6050,'2','1',390878.55,392032.39,1153.84,201922.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','253',6051,'3','1',658335.43,659978.27,1642.84,287497.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','253',6052,'4','1',293860.57,294653.87,793.30,138827.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','253',6053,'5','1',859792.77,862673.63,2880.86,504150.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','253',6054,'6','1',161893.98,163041.41,1147.43,200800.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','253',6055,'7','1',643653.03,646686.74,3033.71,530899.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','253',6056,'8','1',322884.87,324286.70,1401.83,245320.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','253',6057,'9','1',538701.55,540534.24,1832.69,320720.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','253',6058,'10','1',163040.87,163334.40,293.53,51367.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','253',6059,'11','1',675413.88,678836.00,3422.12,598871.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','253',6060,'12','1',179096.47,179181.08,84.61,14806.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','253',6061,'13','1',263525.65,264969.53,1443.88,252679.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','253',6062,'14','1',94123.72,94491.40,367.68,64344.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','253',6063,'15','1',272196.95,273436.82,1239.87,216977.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','253',6064,'16','1',67578.62,67852.30,273.68,47894.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','253',6065,'17','1',65590.32,66105.99,515.67,90242.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','253',6066,'18','1',332342.79,333562.27,1219.48,213409.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','253',6067,'19','1',71004.88,71388.76,383.88,67179.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','253',6068,'20','1',327284.44,327816.77,532.33,93157.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','253',6069,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','253',6070,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','253',6071,'23','2',101050.43,102218.31,1167.88,934304.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','253',6072,'24','2',23898.88,25945.20,2046.32,1637056.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','254',6073,'1','1',874673.21,878794.16,4120.95,721166.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','254',6074,'2','1',392032.39,392032.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','254',6075,'3','1',659978.27,664127.88,4149.61,726181.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','254',6076,'4','1',294653.87,294653.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','254',6077,'5','1',862673.63,866554.34,3880.71,679124.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','254',6078,'6','1',163041.41,163041.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','254',6079,'7','1',646686.74,650354.37,3667.63,641835.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','254',6080,'8','1',324286.70,325704.06,1417.36,248038.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','254',6081,'9','1',540534.24,544126.88,3592.64,628712.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','254',6082,'10','1',163334.40,163851.42,517.02,90478.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','254',6083,'11','1',678836.00,680587.93,1751.93,306587.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','254',6084,'12','1',179181.08,179689.71,508.63,89010.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','254',6085,'13','1',264969.53,267687.34,2717.81,475616.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','254',6086,'14','1',94491.40,95091.29,599.89,104980.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','254',6087,'15','1',273436.82,275570.11,2133.29,373325.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','254',6088,'16','1',67852.30,68172.53,320.23,56040.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','254',6089,'17','1',66105.99,66800.01,694.02,121453.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','254',6090,'18','1',333562.27,336176.23,2613.96,457443.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','254',6091,'19','1',71388.76,71388.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','254',6092,'20','1',327816.77,330861.95,3045.18,532906.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','254',6093,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','254',6094,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','254',6095,'23','2',102218.31,103845.37,1627.06,1301648.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','254',6096,'24','2',25945.20,26125.12,179.92,143936.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','255',6097,'1','1',878794.16,881128.43,2334.27,408497.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','255',6098,'2','1',392032.39,392661.97,629.58,110176.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','255',6099,'3','1',664127.88,666717.89,2590.01,453251.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','255',6100,'4','1',294653.87,294653.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','255',6101,'5','1',866554.34,870766.80,4212.46,737180.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','255',6102,'6','1',163041.41,163041.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','255',6103,'7','1',650354.37,654983.38,4629.01,810076.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','255',6104,'8','1',325704.06,326691.79,987.73,172852.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','255',6105,'9','1',544126.88,548540.69,4413.81,772416.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','255',6106,'10','1',163851.42,163851.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','255',6107,'11','1',680587.93,684554.16,3966.23,694090.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','255',6108,'12','1',179689.71,179689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','255',6109,'13','1',267687.34,267687.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','255',6110,'14','1',95091.29,95091.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','255',6111,'15','1',275570.11,275570.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','255',6112,'16','1',68172.53,68172.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','255',6113,'17','1',66800.01,66800.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','255',6114,'18','1',336176.23,338676.25,2500.02,437503.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','255',6115,'19','1',71388.76,71388.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','255',6116,'20','1',330861.95,334065.35,3203.40,560595.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','255',6117,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','255',6118,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','255',6119,'23','2',103845.37,104488.76,643.39,514712.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','255',6120,'24','2',26125.12,28375.09,2249.97,1799976.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','256',6121,'1','1',881128.43,884228.11,3099.68,542444.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','256',6122,'2','1',392661.97,395402.68,2740.71,479624.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','256',6123,'3','1',666717.89,670488.43,3770.54,659844.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','256',6124,'4','1',294653.87,294653.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','256',6125,'5','1',870766.80,873983.21,3216.41,562871.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','256',6126,'6','1',163041.41,163849.97,808.56,141498.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','256',6127,'7','1',654983.38,659148.24,4164.86,728850.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','256',6128,'8','1',326691.79,328402.90,1711.11,299444.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','256',6129,'9','1',548540.69,551129.36,2588.67,453017.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','256',6130,'10','1',163851.42,165024.61,1173.19,205308.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','256',6131,'11','1',684554.16,688700.96,4146.80,725690.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','256',6132,'12','1',179689.71,179689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','256',6133,'13','1',267687.34,270733.01,3045.67,532992.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','256',6134,'14','1',95091.29,95091.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','256',6135,'15','1',275570.11,278498.32,2928.21,512436.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','256',6136,'16','1',68172.53,68941.66,769.13,134597.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','256',6137,'17','1',66800.01,66800.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','256',6138,'18','1',338676.25,341305.88,2629.63,460185.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','256',6139,'19','1',71388.76,71388.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','256',6140,'20','1',334065.35,334065.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','256',6141,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','256',6142,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','256',6143,'23','2',104488.76,104488.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','256',6144,'24','2',28375.09,30729.87,2344.78,1875824.00,0.00,0.00,10.00,0.00,0.00),('1','248','1','257',6145,'1','1',884228.11,888580.40,4352.29,761650.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','257',6146,'2','1',395402.68,396944.95,1542.27,269897.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','257',6147,'3','1',670488.43,674738.63,4250.20,743785.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','257',6148,'4','1',294653.87,295628.39,974.52,170541.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','257',6149,'5','1',873983.21,878265.65,4282.44,749427.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','257',6150,'6','1',163849.97,164739.87,889.90,155732.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','257',6151,'7','1',659148.24,660435.43,1287.19,225258.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','257',6152,'8','1',328402.90,328402.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','257',6153,'9','1',551129.36,552161.95,1032.59,180703.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','257',6154,'10','1',165024.61,165024.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','257',6155,'11','1',688700.96,688700.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','257',6156,'12','1',179689.71,179689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','257',6157,'13','1',270733.01,274048.11,3315.10,580142.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','257',6158,'14','1',95091.29,95407.61,316.32,55356.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','257',6159,'15','1',278498.32,281632.01,3133.69,548395.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','257',6160,'16','1',68941.66,70071.64,1129.98,197746.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','257',6161,'17','1',66800.01,67408.82,608.81,106541.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','257',6162,'18','1',341305.88,344386.98,3081.10,539192.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','257',6163,'19','1',71388.76,71388.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','257',6164,'20','1',334065.35,336444.53,2379.18,416356.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','257',6165,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','257',6166,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','257',6167,'23','2',104488.76,105432.51,943.75,755000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','257',6168,'24','2',30729.87,33720.50,2990.63,2392504.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','258',6169,'1','1',888580.40,891664.64,3084.24,539742.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','258',6170,'2','1',396944.95,400444.61,3499.66,612440.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','258',6171,'3','1',674738.63,678094.34,3355.71,587249.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','258',6172,'4','1',295628.39,297861.30,2232.91,390759.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','258',6173,'5','1',878265.65,881752.94,3487.29,610275.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','258',6174,'6','1',164739.87,167945.63,3205.76,561008.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','258',6175,'7','1',660435.43,660435.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','258',6176,'8','1',328402.90,328402.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','258',6177,'9','1',552161.95,552161.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','258',6178,'10','1',165024.61,165024.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','258',6179,'11','1',688700.96,688700.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','258',6180,'12','1',179689.71,179689.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','258',6181,'13','1',274048.11,274824.18,776.07,135812.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','258',6182,'14','1',95407.61,95407.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','258',6183,'15','1',281632.01,282489.36,857.35,150036.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','258',6184,'16','1',70071.64,70276.29,204.65,35813.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','258',6185,'17','1',67408.82,67759.68,350.86,61400.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','258',6186,'18','1',344386.98,345190.38,803.40,140595.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','258',6187,'19','1',71388.76,71666.14,277.38,48541.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','258',6188,'20','1',336444.53,337193.60,749.07,131087.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','258',6189,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','258',6190,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','258',6191,'23','2',105432.51,105432.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','258',6192,'24','2',33720.50,34961.48,1240.98,992784.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','259',6193,'1','1',891664.64,895406.96,3742.32,654906.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','259',6194,'2','1',400444.61,401336.38,891.77,156059.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','259',6195,'3','1',678094.34,681397.17,3302.83,577995.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','259',6196,'4','1',297861.30,297861.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','259',6197,'5','1',881752.94,884978.69,3225.75,564506.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','259',6198,'6','1',167945.63,169407.67,1462.04,255857.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','259',6199,'7','1',660435.43,663961.41,3525.98,617046.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','259',6200,'8','1',328402.90,328402.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','259',6201,'9','1',552161.95,555592.66,3430.71,600374.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','259',6202,'10','1',165024.61,165817.53,792.92,138761.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','259',6203,'11','1',688700.96,691879.54,3178.58,556251.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','259',6204,'12','1',179689.71,181838.37,2148.66,376015.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','259',6205,'13','1',274824.18,274824.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','259',6206,'14','1',95407.61,95407.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','259',6207,'15','1',282489.36,282489.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','259',6208,'16','1',70276.29,70276.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','259',6209,'17','1',67759.68,67759.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','259',6210,'18','1',345190.38,345190.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','259',6211,'19','1',71666.14,71666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','259',6212,'20','1',337193.60,337193.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','259',6213,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','259',6214,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','259',6215,'23','2',105432.51,105587.51,155.00,124000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','259',6216,'24','2',34961.48,36638.14,1676.66,1341328.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','260',6217,'1','1',895406.96,897240.33,1833.37,320839.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','260',6218,'2','1',401336.38,402113.66,777.28,136024.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','260',6219,'3','1',681397.17,683017.54,1620.37,283564.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','260',6220,'4','1',297861.30,298054.09,138.51,24239.25,0.00,0.00,54.28,0.00,0.00),('1','248','1','260',6221,'5','1',884978.69,886834.23,1855.54,324719.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','260',6222,'6','1',169407.67,170520.26,1112.59,194703.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','260',6223,'7','1',663961.41,665369.82,1408.41,246471.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','260',6224,'8','1',328402.90,329908.36,1505.46,263455.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','260',6225,'9','1',555592.66,556979.69,1387.03,242730.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','260',6226,'10','1',165817.53,166438.78,621.25,108718.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','260',6227,'11','1',691879.54,693329.97,1450.43,253825.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','260',6228,'12','1',181838.37,182386.53,548.16,95928.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','260',6229,'13','1',274824.18,274824.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','260',6230,'14','1',95407.61,95407.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','260',6231,'15','1',282489.36,282489.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','260',6232,'16','1',70276.29,70276.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','260',6233,'17','1',67759.68,67759.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','260',6234,'18','1',345190.38,345190.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','260',6235,'19','1',71666.14,71666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','260',6236,'20','1',337193.60,337193.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','260',6237,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','260',6238,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','260',6239,'23','2',105587.51,106329.99,742.48,593984.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','260',6240,'24','2',36638.14,37825.05,1186.91,949528.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','261',6241,'1','1',897240.33,900008.37,2768.04,484407.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','261',6242,'2','1',402113.66,404531.06,2417.40,423045.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','261',6243,'3','1',683017.54,685063.11,2045.57,357974.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','261',6244,'4','1',298054.09,300344.05,2289.96,400743.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','261',6245,'5','1',886834.23,889745.63,2911.40,509495.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','261',6246,'6','1',170520.26,172817.00,2296.74,401929.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','261',6247,'7','1',665369.82,665369.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','261',6248,'8','1',329908.36,329908.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','261',6249,'9','1',556979.69,556979.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','261',6250,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','261',6251,'11','1',693329.97,693329.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','261',6252,'12','1',182386.53,182386.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','261',6253,'13','1',274824.18,274824.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','261',6254,'14','1',95407.61,95407.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','261',6255,'15','1',282489.36,282489.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','261',6256,'16','1',70276.29,70276.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','261',6257,'17','1',67759.68,67759.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','261',6258,'18','1',345190.38,345190.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','261',6259,'19','1',71666.14,71666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','261',6260,'20','1',337193.60,337193.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','261',6261,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','261',6262,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','261',6263,'23','2',106329.99,106340.62,10.63,8504.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','261',6264,'24','2',37825.05,39149.44,1324.39,1059512.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','262',6265,'1','1',900008.37,902440.34,2431.97,425594.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','262',6266,'2','1',404531.06,407323.81,2792.75,488731.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','262',6267,'3','1',685063.11,687988.32,2925.21,511911.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','262',6268,'4','1',300344.05,302591.53,2247.48,393309.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','262',6269,'5','1',889745.63,892155.61,2409.98,421746.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','262',6270,'6','1',172817.00,175276.09,2459.09,430340.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','262',6271,'7','1',665369.82,665369.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','262',6272,'8','1',329908.36,329908.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','262',6273,'9','1',556979.69,556979.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','262',6274,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','262',6275,'11','1',693329.97,693329.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','262',6276,'12','1',182386.53,182386.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','262',6277,'13','1',274824.18,274824.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','262',6278,'14','1',95407.61,95407.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','262',6279,'15','1',282489.36,282489.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','262',6280,'16','1',70276.29,70276.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','262',6281,'17','1',67759.68,67759.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','262',6282,'18','1',345190.38,345190.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','262',6283,'19','1',71666.14,71666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','262',6284,'20','1',337193.60,337193.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','262',6285,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','262',6286,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','262',6287,'23','2',106340.62,106340.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','262',6288,'24','2',39149.44,39616.62,467.18,373744.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','263',6289,'1','1',902440.34,905933.54,3493.20,611310.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','263',6290,'2','1',407323.81,407323.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','263',6291,'3','1',687988.32,687988.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','263',6292,'4','1',302591.53,302591.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','263',6293,'5','1',892155.61,895643.94,3488.33,610457.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','263',6294,'6','1',175276.09,176279.28,1003.19,175558.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','263',6295,'7','1',665369.82,669063.47,3693.65,646388.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','263',6296,'8','1',329908.36,329908.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','263',6297,'9','1',556979.69,556979.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','263',6298,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','263',6299,'11','1',693329.97,697407.16,4077.19,713508.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','263',6300,'12','1',182386.53,182386.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','263',6301,'13','1',274824.18,274824.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','263',6302,'14','1',95407.61,95407.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','263',6303,'15','1',282489.36,282489.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','263',6304,'16','1',70276.29,70276.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','263',6305,'17','1',67759.68,68673.16,913.48,159859.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','263',6306,'18','1',345190.38,348204.90,3014.52,527541.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','263',6307,'19','1',71666.14,72021.23,355.09,62140.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','263',6308,'20','1',337193.60,339860.74,2667.14,466749.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','263',6309,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','263',6310,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','263',6311,'23','2',106340.62,106749.30,388.68,310944.00,0.00,0.00,20.00,0.00,0.00),('1','248','5','263',6312,'24','2',39616.62,40828.98,1212.36,969888.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','264',6313,'1','1',905933.54,910182.19,4248.65,743513.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','264',6314,'2','1',407323.81,408106.20,782.39,136918.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','264',6315,'3','1',687988.32,692134.17,4145.85,725523.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','264',6316,'4','1',302591.53,302591.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','264',6317,'5','1',895643.94,898684.52,3040.58,532101.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','264',6318,'6','1',176279.28,176279.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','264',6319,'7','1',669063.47,674262.81,5199.34,909884.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','264',6320,'8','1',329908.36,329908.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','264',6321,'9','1',556979.69,556979.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','264',6322,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','264',6323,'11','1',697407.16,701414.19,4007.03,701230.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','264',6324,'12','1',182386.53,183259.72,873.19,152808.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','264',6325,'13','1',274824.18,274824.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','264',6326,'14','1',95407.61,95407.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','264',6327,'15','1',282489.36,282489.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','264',6328,'16','1',70276.29,70276.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','264',6329,'17','1',68673.16,69339.36,666.20,116585.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','264',6330,'18','1',348204.90,352228.92,4024.02,704203.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','264',6331,'19','1',72021.23,72021.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','264',6332,'20','1',339860.74,344871.20,5010.46,876830.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','264',6333,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','264',6334,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','264',6335,'23','2',106749.30,106749.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','264',6336,'24','2',40828.98,41745.99,917.01,733608.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','265',6337,'1','1',910182.19,912524.36,2342.17,409879.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','265',6338,'2','1',408106.20,409672.76,1566.56,274148.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','265',6339,'3','1',692134.17,694342.33,2208.16,386428.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','265',6340,'4','1',302591.53,303595.62,1004.09,175715.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','265',6341,'5','1',898684.52,901934.75,3250.23,568790.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','265',6342,'6','1',176279.28,176384.42,105.14,18399.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','265',6343,'7','1',674262.81,678195.02,3932.21,688136.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','265',6344,'8','1',329908.36,329908.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','265',6345,'9','1',556979.69,556979.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','265',6346,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','265',6347,'11','1',701414.19,704936.99,3522.80,616490.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','265',6348,'12','1',183259.72,183259.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','265',6349,'13','1',274824.18,275568.63,744.45,130278.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','265',6350,'14','1',95407.61,95554.82,147.21,25761.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','265',6351,'15','1',282489.36,283241.76,752.40,131670.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','265',6352,'16','1',70276.29,70661.14,384.85,67348.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','265',6353,'17','1',69339.36,69339.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','265',6354,'18','1',352228.92,355058.66,2829.74,495204.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','265',6355,'19','1',72021.23,72184.93,163.70,28647.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','265',6356,'20','1',344871.20,346943.09,2071.89,362580.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','265',6357,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','265',6358,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','265',6359,'23','2',106749.30,106994.93,245.63,196504.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','265',6360,'24','2',41745.99,43335.55,1589.56,1271644.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','266',6361,'1','1',912524.36,915663.77,3139.41,549396.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','266',6362,'2','1',409672.76,411144.88,1472.12,257621.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','266',6363,'3','1',694342.33,694342.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','266',6364,'4','1',303595.62,303595.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','266',6365,'5','1',901934.75,904938.24,3003.49,525610.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','266',6366,'6','1',176384.42,178375.16,1990.74,348379.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','266',6367,'7','1',678195.02,683064.26,4869.24,852117.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','266',6368,'8','1',329908.36,332166.37,2258.01,395151.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','266',6369,'9','1',556979.69,559849.65,2869.96,502243.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','266',6370,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','266',6371,'11','1',704936.99,709178.66,4241.67,742292.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','266',6372,'12','1',183259.72,184318.86,1059.14,185349.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','266',6373,'13','1',275568.63,278441.40,2872.77,502734.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','266',6374,'14','1',95554.82,97249.08,1694.26,296495.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','266',6375,'15','1',283241.76,283887.18,645.42,112948.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','266',6376,'16','1',70661.14,71224.04,562.90,98507.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','266',6377,'17','1',69339.36,69961.29,621.93,108837.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','266',6378,'18','1',355058.66,358822.57,3763.91,658684.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','266',6379,'19','1',72184.93,73881.71,1696.78,296936.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','266',6380,'20','1',346943.09,350814.30,3871.21,677461.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','266',6381,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','266',6382,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','266',6383,'23','2',106994.93,107378.43,383.50,306800.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','266',6384,'24','2',43335.55,44624.61,1289.06,1031248.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','267',6385,'1','1',915663.77,917868.79,2205.02,385878.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','267',6386,'2','1',411144.88,412220.17,1075.29,188175.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','267',6387,'3','1',694342.33,694342.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','267',6388,'4','1',303595.62,303595.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','267',6389,'5','1',904938.24,906827.64,1889.40,330645.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','267',6390,'6','1',178375.16,179683.48,1308.32,228956.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','267',6391,'7','1',683064.26,684886.06,1821.80,318815.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','267',6392,'8','1',332166.37,332166.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','267',6393,'9','1',559849.65,559849.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','267',6394,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','267',6395,'11','1',709178.66,710922.15,1743.49,305110.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','267',6396,'12','1',184318.86,184318.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','267',6397,'13','1',278441.40,279744.22,1302.82,227993.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','267',6398,'14','1',97249.08,97249.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','267',6399,'15','1',283887.18,284058.03,170.85,29898.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','267',6400,'16','1',71224.04,71323.77,99.73,17452.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','267',6401,'17','1',69961.29,70039.38,78.09,13665.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','267',6402,'18','1',358822.57,358941.21,118.64,20762.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','267',6403,'19','1',73881.71,73881.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','267',6404,'20','1',350814.30,351001.95,187.65,32838.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','267',6405,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','267',6406,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','267',6407,'23','2',107378.43,107949.68,571.25,457000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','267',6408,'24','2',44624.61,47068.47,2443.86,1955088.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','268',6409,'1','1',917868.79,922093.44,4224.65,739313.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','268',6410,'2','1',412220.17,414057.85,1837.68,321594.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','268',6411,'3','1',694342.33,698044.80,3702.47,647932.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','268',6412,'4','1',303595.62,305350.08,1754.46,307030.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','268',6413,'5','1',906827.64,910583.27,3755.63,657235.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','268',6414,'6','1',179683.48,181623.92,1940.44,339577.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','268',6415,'7','1',684886.06,687593.33,2707.27,473772.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','268',6416,'8','1',332166.37,334125.82,1959.45,342903.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','268',6417,'9','1',559849.65,563983.37,4133.72,723401.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','268',6418,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','268',6419,'11','1',710922.15,712596.97,1674.82,293093.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','268',6420,'12','1',184318.86,184536.25,217.39,38043.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','268',6421,'13','1',279744.22,279744.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','268',6422,'14','1',97249.08,97249.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','268',6423,'15','1',284058.03,287646.48,3588.45,627978.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','268',6424,'16','1',71323.77,72146.62,822.85,143998.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','268',6425,'17','1',70039.38,72358.26,2318.88,405804.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','268',6426,'18','1',358941.21,362124.22,3183.01,557026.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','268',6427,'19','1',73881.71,74380.80,489.09,85590.75,0.00,0.00,10.00,0.00,0.00),('1','248','3','268',6428,'20','1',351001.95,354613.20,3601.25,630218.75,0.00,0.00,10.00,0.00,0.00),('1','248','4','268',6429,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','268',6430,'22','2',129038.87,129038.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','268',6431,'23','2',107949.68,109170.25,1220.57,976456.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','268',6432,'24','2',47068.47,47247.05,178.58,142864.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','269',6433,'1','1',922093.44,926693.36,4599.92,804986.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','269',6434,'2','1',414057.85,414800.53,742.68,129969.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','269',6435,'3','1',698044.80,699884.74,1839.94,321989.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','269',6436,'4','1',305350.08,306153.64,803.56,140623.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','269',6437,'5','1',910583.27,913508.40,2925.13,511897.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','269',6438,'6','1',181623.92,183197.31,1573.39,275343.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','269',6439,'7','1',687593.33,690524.98,2931.65,513038.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','269',6440,'8','1',334125.82,334125.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','269',6441,'9','1',563983.37,564832.96,849.59,148678.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','269',6442,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','269',6443,'11','1',712596.97,716241.83,3644.86,637850.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','269',6444,'12','1',184536.25,184536.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','269',6445,'13','1',279744.22,279744.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','269',6446,'14','1',97249.08,97249.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','269',6447,'15','1',287646.48,291015.59,3369.11,589594.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','269',6448,'16','1',72146.62,72146.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','269',6449,'17','1',72358.26,72415.97,57.71,10099.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','269',6450,'18','1',362124.22,365007.92,2883.70,504647.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','269',6451,'19','1',74380.80,74380.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','269',6452,'20','1',354613.20,357811.78,3198.58,559751.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','269',6453,'21','2',215663.76,215663.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','269',6454,'22','2',129038.87,129243.87,205.00,164000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','269',6455,'23','2',109170.25,109419.00,248.75,199000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','269',6456,'24','2',47247.05,49493.60,2246.55,1797240.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','270',6457,'1','1',926693.36,930293.33,3599.97,629994.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','270',6458,'2','1',414800.53,416687.85,1887.32,330281.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','270',6459,'3','1',699884.74,703297.87,3413.13,597297.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','270',6460,'4','1',306153.64,308301.53,2147.89,375880.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','270',6461,'5','1',913508.40,915407.09,1898.69,332270.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','270',6462,'6','1',183197.31,184038.60,841.29,147225.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','270',6463,'7','1',690524.98,694688.55,4117.86,720625.50,0.00,0.00,45.71,0.00,0.00),('1','248','2','270',6464,'8','1',334125.82,335756.46,1630.64,285362.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','270',6465,'9','1',564832.96,566760.82,1927.86,337375.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','270',6466,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','270',6467,'11','1',716241.83,719992.37,3750.54,656344.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','270',6468,'12','1',184536.25,184536.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','270',6469,'13','1',279744.22,279744.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','270',6470,'14','1',97249.08,97249.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','270',6471,'15','1',291015.59,291015.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','270',6472,'16','1',72146.62,72146.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','270',6473,'17','1',72415.97,73734.94,1318.97,230819.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','270',6474,'18','1',365007.92,367727.28,2719.36,475888.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','270',6475,'19','1',74380.80,75265.04,884.24,154742.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','270',6476,'20','1',357811.78,360392.52,2580.74,451629.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','270',6477,'21','2',215663.76,216597.75,933.99,747192.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','270',6478,'22','2',129243.87,129895.90,652.03,521624.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','270',6479,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','270',6480,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','271',6481,'1','1',930293.33,933852.50,3559.17,622854.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','271',6482,'2','1',416687.85,416687.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','271',6483,'3','1',703297.87,706792.36,3494.49,611535.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','271',6484,'4','1',308301.53,308301.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','271',6485,'5','1',915407.09,917743.85,2336.76,408933.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','271',6486,'6','1',184038.60,184816.70,778.10,136167.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','271',6487,'7','1',694688.55,698201.69,3513.14,614799.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','271',6488,'8','1',335756.46,335756.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','271',6489,'9','1',566760.82,567396.05,635.23,111165.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','271',6490,'10','1',166438.78,166438.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','271',6491,'11','1',719992.37,722310.46,2318.09,405665.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','271',6492,'12','1',184536.25,184536.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','271',6493,'13','1',279744.22,282087.66,2343.44,410102.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','271',6494,'14','1',97249.08,97961.05,711.97,124594.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','271',6495,'15','1',291015.59,293873.98,2858.39,500218.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','271',6496,'16','1',72146.62,72146.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','271',6497,'17','1',73734.94,74089.96,355.02,62128.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','271',6498,'18','1',367727.28,369995.12,2267.84,396872.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','271',6499,'19','1',75265.04,75776.40,511.36,89488.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','271',6500,'20','1',360392.52,361796.19,1403.67,245642.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','271',6501,'21','2',216597.75,218953.77,2356.02,1884816.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','271',6502,'22','2',129895.90,129902.15,6.25,5000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','271',6503,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','271',6504,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','272',6505,'1','1',933852.50,936003.37,2150.87,376402.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','272',6506,'2','1',416687.85,417178.30,490.45,85828.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','272',6507,'3','1',706792.36,708775.45,1983.09,347040.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','272',6508,'4','1',308301.53,309852.49,1550.96,271418.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','272',6509,'5','1',917743.85,917743.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','272',6510,'6','1',184816.70,184816.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','272',6511,'7','1',698201.69,701514.58,3312.89,579755.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','272',6512,'8','1',335756.46,337267.09,1510.63,264360.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','272',6513,'9','1',567396.05,568829.90,1433.85,250923.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','272',6514,'10','1',166438.78,166946.70,507.92,88886.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','272',6515,'11','1',722310.46,725725.79,3415.33,597682.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','272',6516,'12','1',184536.25,184933.97,397.72,69601.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','272',6517,'13','1',282087.66,284823.27,2735.61,478731.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','272',6518,'14','1',97961.05,98877.31,916.26,160345.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','272',6519,'15','1',293873.98,296674.63,2800.65,490113.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','272',6520,'16','1',72146.62,73110.36,963.74,168654.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','272',6521,'17','1',74089.96,75156.63,1066.67,186667.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','272',6522,'18','1',369995.12,372652.16,2657.04,464982.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','272',6523,'19','1',75776.40,76358.94,582.54,101944.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','272',6524,'20','1',361796.19,364184.17,2387.98,417896.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','272',6525,'21','2',218953.77,219758.29,804.52,643616.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','272',6526,'22','2',129902.15,129902.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','272',6527,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','272',6528,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','273',6529,'1','1',936003.37,937577.12,1573.75,275406.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','273',6530,'2','1',417178.30,417988.29,809.99,141748.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','273',6531,'3','1',708775.45,710836.15,2060.70,360622.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','273',6532,'4','1',309852.49,309852.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','273',6533,'5','1',917743.85,919979.58,2235.73,391252.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','273',6534,'6','1',184816.70,184816.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','273',6535,'7','1',701514.58,703768.69,2254.11,394469.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','273',6536,'8','1',337267.09,337267.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','273',6537,'9','1',568829.90,568829.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','273',6538,'10','1',166946.70,166946.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','273',6539,'11','1',725725.79,727970.96,2245.17,392904.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','273',6540,'12','1',184933.97,185317.32,383.35,67086.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','273',6541,'13','1',284823.27,286575.10,1751.83,306570.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','273',6542,'14','1',98877.31,100100.27,1222.96,214018.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','273',6543,'15','1',296674.63,298338.63,1664.00,291200.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','273',6544,'16','1',73110.36,74838.96,1728.60,302505.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','273',6545,'17','1',75156.63,75313.55,156.92,27461.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','273',6546,'18','1',372652.16,375957.72,3305.56,578473.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','273',6547,'19','1',76358.94,76358.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','273',6548,'20','1',364184.17,366980.57,2796.40,489370.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','273',6549,'21','2',219758.29,220608.29,850.00,680000.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','273',6550,'22','2',129902.15,130862.99,960.84,768672.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','273',6551,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','273',6552,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','274',6553,'1','1',937577.12,940917.43,3340.31,584554.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','274',6554,'2','1',417988.29,419941.42,1953.13,341797.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','274',6555,'3','1',710836.15,710836.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','274',6556,'4','1',309852.49,309852.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','274',6557,'5','1',919979.58,922537.98,2558.40,447720.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','274',6558,'6','1',184816.70,186888.53,2071.83,362570.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','274',6559,'7','1',703768.69,707098.93,3330.24,582792.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','274',6560,'8','1',337267.09,339304.06,2036.97,356469.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','274',6561,'9','1',568829.90,568829.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','274',6562,'10','1',166946.70,166946.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','274',6563,'11','1',727970.96,731224.16,3253.20,569310.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','274',6564,'12','1',185317.32,186458.08,1140.76,199633.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','274',6565,'13','1',286575.10,287926.90,1351.80,236565.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','274',6566,'14','1',100100.27,100925.70,825.43,144450.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','274',6567,'15','1',298338.63,301328.67,2990.04,523257.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','274',6568,'16','1',74838.96,76889.26,2050.30,358802.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','274',6569,'17','1',75313.55,78991.41,3677.86,643625.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','274',6570,'18','1',375957.72,377839.51,1881.79,329313.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','274',6571,'19','1',76358.94,78629.73,2270.79,397388.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','274',6572,'20','1',366980.57,369747.86,2767.29,484275.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','274',6573,'21','2',220608.29,220758.29,150.00,120000.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','274',6574,'22','2',130862.99,131702.10,839.11,671288.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','274',6575,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','274',6576,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','275',6577,'1','1',940917.43,940917.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','275',6578,'2','1',419941.42,419941.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','275',6579,'3','1',710836.15,710893.86,57.71,10099.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','275',6580,'4','1',309852.49,309852.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','275',6581,'5','1',922537.98,922687.54,149.56,26173.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','275',6582,'6','1',186888.53,186888.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','275',6583,'7','1',707098.93,707098.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','275',6584,'8','1',339304.06,339304.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','275',6585,'9','1',568829.90,568910.75,80.85,14148.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','275',6586,'10','1',166946.70,166946.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','275',6587,'11','1',731224.16,731403.59,179.43,31400.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','275',6588,'12','1',186458.08,186458.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','275',6589,'13','1',287926.90,289315.87,1388.97,243069.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','275',6590,'14','1',100925.70,102536.58,1610.88,281904.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','275',6591,'15','1',301328.67,302803.84,1475.17,258154.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','275',6592,'16','1',76889.26,77709.57,820.31,143554.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','275',6593,'17','1',78991.41,80231.66,1240.25,217043.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','275',6594,'18','1',377839.51,378709.06,869.55,152171.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','275',6595,'19','1',78629.73,78629.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','275',6596,'20','1',369747.86,370851.36,1103.50,193112.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','275',6597,'21','2',220758.29,221492.29,734.00,587200.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','275',6598,'22','2',131702.10,132681.36,979.26,783408.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','275',6599,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','275',6600,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','276',6601,'1','1',940917.43,944213.82,3296.39,576868.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','276',6602,'2','1',419941.42,422624.88,2683.46,469605.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','276',6603,'3','1',710893.86,713992.78,3098.92,542311.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','276',6604,'4','1',309852.49,311289.46,1436.97,251469.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','276',6605,'5','1',922687.54,925697.75,3010.21,526786.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','276',6606,'6','1',186888.53,188188.02,1299.49,227410.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','276',6607,'7','1',707098.93,710264.01,3165.08,553889.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','276',6608,'8','1',339304.06,342693.43,3389.37,593139.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','276',6609,'9','1',568910.75,572009.47,3098.72,542276.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','276',6610,'10','1',166946.70,168835.92,1889.22,330613.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','276',6611,'11','1',731403.59,733419.30,2015.71,352749.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','276',6612,'12','1',186458.08,187689.63,1231.55,215521.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','276',6613,'13','1',289315.87,289315.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','276',6614,'14','1',102536.58,102536.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','276',6615,'15','1',302803.84,302803.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','276',6616,'16','1',77709.57,77709.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','276',6617,'17','1',80231.66,80231.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','276',6618,'18','1',378709.06,378709.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','276',6619,'19','1',78629.73,78629.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','276',6620,'20','1',370851.36,370851.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','276',6621,'21','2',221492.29,222186.19,693.90,555120.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','276',6622,'22','2',132681.36,134203.01,1521.65,1217320.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','276',6623,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','276',6624,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','277',6625,'1','1',944213.82,946783.31,2569.49,449660.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','277',6626,'2','1',422624.88,423019.39,394.51,69039.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','277',6627,'3','1',713992.78,713992.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','277',6628,'4','1',311289.46,311289.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','277',6629,'5','1',925697.75,927764.95,2067.20,361760.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','277',6630,'6','1',188188.02,188188.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','277',6631,'7','1',710264.01,713153.57,2889.56,505673.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','277',6632,'8','1',342693.43,343150.62,457.19,80008.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','277',6633,'9','1',572009.47,572009.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','277',6634,'10','1',168835.92,168835.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','277',6635,'11','1',733419.30,735962.39,2543.09,445040.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','277',6636,'12','1',187689.63,187689.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','277',6637,'13','1',289315.87,289315.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','277',6638,'14','1',102536.58,102536.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','277',6639,'15','1',302803.84,302803.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','277',6640,'16','1',77709.57,77709.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','277',6641,'17','1',80231.66,80231.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','277',6642,'18','1',378709.06,381190.38,2481.32,434231.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','277',6643,'19','1',78629.73,78629.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','277',6644,'20','1',370851.36,373303.75,2452.39,429168.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','277',6645,'21','2',222186.19,224332.33,2146.14,1716912.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','277',6646,'22','2',134203.01,134458.39,255.38,204304.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','277',6647,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','277',6648,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','278',6649,'1','1',946783.31,951789.67,4976.36,870863.00,0.00,0.00,30.00,0.00,0.00),('1','248','1','278',6650,'2','1',423019.39,423043.68,-5.71,-999.25,0.00,0.00,30.00,0.00,0.00),('1','248','1','278',6651,'3','1',713992.78,714012.78,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','248','1','278',6652,'4','1',311289.46,311309.46,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','248','1','278',6653,'5','1',927764.95,932157.87,4382.92,767011.00,0.00,0.00,10.00,0.00,0.00),('1','248','1','278',6654,'6','1',188188.02,188208.02,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','248','2','278',6655,'7','1',713153.57,716911.28,3727.71,652349.25,0.00,0.00,30.00,0.00,0.00),('1','248','2','278',6656,'8','1',343150.62,344675.26,1494.64,261562.00,0.00,0.00,30.00,0.00,0.00),('1','248','2','278',6657,'9','1',572009.47,572029.47,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','248','2','278',6658,'10','1',168835.92,168855.92,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','248','2','278',6659,'11','1',735962.39,739409.47,3437.08,601489.00,0.00,0.00,10.00,0.00,0.00),('1','248','2','278',6660,'12','1',187689.63,187779.66,80.03,14005.25,0.00,0.00,10.00,0.00,0.00),('1','248','3','278',6661,'13','1',289315.87,293382.27,4056.40,709870.00,0.00,0.00,10.00,0.00,0.00),('1','248','3','278',6662,'14','1',102536.58,102556.58,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','248','3','278',6663,'15','1',302803.84,306313.46,3499.62,612433.50,0.00,0.00,10.00,0.00,0.00),('1','248','3','278',6664,'16','1',77709.57,77809.52,79.95,13991.25,0.00,0.00,20.00,0.00,0.00),('1','248','3','278',6665,'17','1',80231.66,80251.65,-0.01,-1.75,0.00,0.00,20.00,0.00,0.00),('1','248','3','278',6666,'18','1',381190.38,384745.11,3544.73,620327.75,0.00,0.00,10.00,0.00,0.00),('1','248','3','278',6667,'19','1',78629.73,79687.62,1047.89,183380.75,0.00,0.00,10.00,0.00,0.00),('1','248','3','278',6668,'20','1',373303.75,377171.56,3857.81,675116.75,0.00,0.00,10.00,0.00,0.00),('1','248','4','278',6669,'21','2',224332.33,225096.61,764.28,611424.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','278',6670,'22','2',134458.39,134568.40,110.01,88008.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','278',6671,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','278',6672,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','279',6673,'1','1',951789.67,951789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','279',6674,'2','1',423043.68,423043.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','279',6675,'3','1',714012.78,714012.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','279',6676,'4','1',311309.46,311309.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','279',6677,'5','1',932157.87,932157.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','279',6678,'6','1',188208.02,188208.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','279',6679,'7','1',716911.28,716911.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','279',6680,'8','1',344675.26,344675.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','279',6681,'9','1',572029.47,572029.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','279',6682,'10','1',168855.92,168855.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','279',6683,'11','1',739409.47,739409.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','279',6684,'12','1',187779.66,187779.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','279',6685,'13','1',293382.27,293382.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','279',6686,'14','1',102556.58,102556.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','279',6687,'15','1',306313.46,306313.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','279',6688,'16','1',77809.52,77809.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','279',6689,'17','1',80251.65,80251.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','279',6690,'18','1',384745.11,384745.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','279',6691,'19','1',79687.62,79687.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','279',6692,'20','1',377171.56,377171.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','279',6693,'21','2',225096.61,227004.26,1907.65,1526120.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','279',6694,'22','2',134568.40,134568.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','279',6695,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','279',6696,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','280',6697,'1','1',951789.67,951789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','280',6698,'2','1',423043.68,423043.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','280',6699,'3','1',714012.78,714012.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','280',6700,'4','1',311309.46,311309.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','280',6701,'5','1',932157.87,932157.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','280',6702,'6','1',188208.02,188208.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','280',6703,'7','1',716911.28,716911.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','280',6704,'8','1',344675.26,344675.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','280',6705,'9','1',572029.47,572029.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','280',6706,'10','1',168855.92,168855.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','280',6707,'11','1',739409.47,739409.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','280',6708,'12','1',187779.66,187779.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','280',6709,'13','1',293382.27,293382.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','280',6710,'14','1',102556.58,102556.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','280',6711,'15','1',306313.46,306313.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','280',6712,'16','1',77809.52,77809.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','280',6713,'17','1',80251.65,80251.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','280',6714,'18','1',384745.11,384745.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','280',6715,'19','1',79687.62,79687.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','280',6716,'20','1',377171.56,377171.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','280',6717,'21','2',227004.26,227004.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','280',6718,'22','2',134568.40,135628.64,1060.24,848192.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','280',6719,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','280',6720,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','281',6721,'1','1',951789.67,954056.58,2266.91,396709.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','281',6722,'2','1',423043.68,423464.34,420.66,73615.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','281',6723,'3','1',714012.78,714012.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','281',6724,'4','1',311309.46,311309.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','281',6725,'5','1',932157.87,932157.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','281',6726,'6','1',188208.02,188208.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','281',6727,'7','1',716911.28,719016.85,2105.57,368474.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','281',6728,'8','1',344675.26,345188.24,512.98,89771.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','281',6729,'9','1',572029.47,572029.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','281',6730,'10','1',168855.92,168855.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','281',6731,'11','1',739409.47,742005.87,2596.40,454370.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','281',6732,'12','1',187779.66,187779.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','281',6733,'13','1',293382.27,298135.93,4753.66,831890.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','281',6734,'14','1',102556.58,103836.01,1279.43,223900.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','281',6735,'15','1',306313.46,309837.02,3523.56,616623.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','281',6736,'16','1',77809.52,79405.63,1596.11,279319.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','281',6737,'17','1',80251.65,81346.43,1094.78,191586.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','281',6738,'18','1',384745.11,388561.93,3816.82,667943.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','281',6739,'19','1',79687.62,81337.96,1650.34,288809.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','281',6740,'20','1',377171.56,380504.98,3333.42,583348.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','281',6741,'21','2',227004.26,229569.06,2564.80,2051840.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','281',6742,'22','2',135628.64,137263.22,1634.58,1307664.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','281',6743,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','281',6744,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','282',6745,'1','1',954056.58,958034.65,3978.07,696162.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','282',6746,'2','1',423464.34,425416.43,1952.09,341615.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','282',6747,'3','1',714012.78,716274.75,2261.97,395844.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','282',6748,'4','1',311309.46,311309.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','282',6749,'5','1',932157.87,935183.78,3025.91,529534.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','282',6750,'6','1',188208.02,189032.98,824.96,144368.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','282',6751,'7','1',719016.85,723051.10,4034.25,705993.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','282',6752,'8','1',345188.24,347277.65,2089.41,365646.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','282',6753,'9','1',572029.47,572663.19,633.72,110901.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','282',6754,'10','1',168855.92,168855.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','282',6755,'11','1',742005.87,746165.03,4159.16,727853.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','282',6756,'12','1',187779.66,189535.88,1756.22,307338.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','282',6757,'13','1',298135.93,298591.02,455.09,79640.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','282',6758,'14','1',103836.01,103836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','282',6759,'15','1',309837.02,309837.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','282',6760,'16','1',79405.63,79405.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','282',6761,'17','1',81346.43,83221.23,1874.80,328090.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','282',6762,'18','1',388561.93,392777.89,4215.96,737793.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','282',6763,'19','1',81337.96,82466.30,1128.34,197459.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','282',6764,'20','1',380504.98,384075.48,3570.50,624837.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','282',6765,'21','2',229569.06,230721.95,1152.89,922312.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','282',6766,'22','2',137263.22,137263.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','282',6767,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','282',6768,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','283',6769,'1','1',958034.65,962986.46,4951.81,866566.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','283',6770,'2','1',425416.43,426471.61,1055.18,184656.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','283',6771,'3','1',716274.75,716274.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','283',6772,'4','1',311309.46,311309.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','283',6773,'5','1',935183.78,940694.44,5510.66,964365.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','283',6774,'6','1',189032.98,189032.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','283',6775,'7','1',723051.10,728463.38,5412.28,947149.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','283',6776,'8','1',347277.65,348203.64,925.99,162048.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','283',6777,'9','1',572663.19,576830.98,4167.79,729363.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','283',6778,'10','1',168855.92,168941.63,85.71,14999.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','283',6779,'11','1',746165.03,746165.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','283',6780,'12','1',189535.88,189535.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','283',6781,'13','1',298591.02,298591.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','283',6782,'14','1',103836.01,103836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','283',6783,'15','1',309837.02,309837.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','283',6784,'16','1',79405.63,79405.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','283',6785,'17','1',83221.23,83221.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','283',6786,'18','1',392777.89,395489.59,2711.70,474547.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','283',6787,'19','1',82466.30,82466.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','283',6788,'20','1',384075.48,389570.12,5494.64,961562.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','283',6789,'21','2',230721.95,233743.93,3021.98,2417584.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','283',6790,'22','2',137263.22,137278.11,14.89,11912.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','283',6791,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','283',6792,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','284',6793,'1','1',962986.46,967233.77,4247.31,743279.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','284',6794,'2','1',426471.61,426984.23,512.62,89708.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','284',6795,'3','1',716274.75,719742.26,3467.51,606814.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','284',6796,'4','1',311309.46,312870.04,1560.58,273101.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','284',6797,'5','1',940694.44,945517.57,4823.13,844047.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','284',6798,'6','1',189032.98,189032.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','284',6799,'7','1',728463.38,732514.82,4051.44,709002.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','284',6800,'8','1',348203.64,350209.93,2006.29,351100.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','284',6801,'9','1',576830.98,576830.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','284',6802,'10','1',168941.63,168941.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','284',6803,'11','1',746165.03,750451.77,4286.74,750179.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','284',6804,'12','1',189535.88,189535.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','284',6805,'13','1',298591.02,298645.88,54.86,9600.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','284',6806,'14','1',103836.01,103836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','284',6807,'15','1',309837.02,309837.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','284',6808,'16','1',79405.63,79405.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','284',6809,'17','1',83221.23,83221.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','284',6810,'18','1',395489.59,400280.91,4791.32,838481.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','284',6811,'19','1',82466.30,83654.54,1188.24,207942.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','284',6812,'20','1',389570.12,392937.95,3367.83,589370.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','284',6813,'21','2',233743.93,235214.54,1470.61,1176488.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','284',6814,'22','2',137278.11,137879.99,601.88,481504.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','284',6815,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','284',6816,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','285',6817,'1','1',967233.77,972231.12,4997.35,874536.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','285',6818,'2','1',426984.23,426984.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','285',6819,'3','1',719742.26,721699.76,1957.50,342562.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','285',6820,'4','1',312870.04,312870.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','285',6821,'5','1',945517.57,949767.33,4249.76,743708.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','285',6822,'6','1',189032.98,190018.80,985.82,172518.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','285',6823,'7','1',732514.82,736867.49,4352.67,761717.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','285',6824,'8','1',350209.93,350815.05,605.12,105896.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','285',6825,'9','1',576830.98,578468.13,1637.15,286501.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','285',6826,'10','1',168941.63,169271.42,329.79,57713.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','285',6827,'11','1',750451.77,754645.99,4194.22,733988.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','285',6828,'12','1',189535.88,189759.87,223.99,39198.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','285',6829,'13','1',298645.88,298645.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','285',6830,'14','1',103836.01,103836.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','285',6831,'15','1',309837.02,309837.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','285',6832,'16','1',79405.63,79405.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','285',6833,'17','1',83221.23,83221.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','285',6834,'18','1',400280.91,402763.56,2482.65,434463.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','285',6835,'19','1',83654.54,84383.65,729.11,127594.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','285',6836,'20','1',392937.95,395136.56,2198.61,384756.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','285',6837,'21','2',235214.54,237671.06,2456.52,1965216.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','285',6838,'22','2',137879.99,137882.49,2.50,2000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','285',6839,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','285',6840,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','286',6841,'1','1',972231.12,974087.32,1856.20,324835.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','286',6842,'2','1',426984.23,427329.39,345.16,60403.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','286',6843,'3','1',721699.76,721699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','286',6844,'4','1',312870.04,312870.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','286',6845,'5','1',949767.33,951388.90,1621.57,283774.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','286',6846,'6','1',190018.80,190018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','286',6847,'7','1',736867.49,738172.25,1304.76,228333.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','286',6848,'8','1',350815.05,350815.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','286',6849,'9','1',578468.13,578468.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','286',6850,'10','1',169271.42,169271.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','286',6851,'11','1',754645.99,755974.46,1282.76,224483.00,0.00,0.00,45.71,0.00,0.00),('1','248','2','286',6852,'12','1',189759.87,189759.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','286',6853,'13','1',298645.88,302105.75,3459.87,605477.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','286',6854,'14','1',103836.01,105856.91,2020.90,353657.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','286',6855,'15','1',309837.02,312779.63,2942.61,514956.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','286',6856,'16','1',79405.63,81697.54,2291.91,401084.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','286',6857,'17','1',83221.23,84659.03,1437.80,251615.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','286',6858,'18','1',402763.56,405722.65,2959.09,517840.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','286',6859,'19','1',84383.65,86069.64,1685.99,295048.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','286',6860,'20','1',395136.56,398083.59,2947.03,515730.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','286',6861,'21','2',237671.06,238877.69,1206.63,965304.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','286',6862,'22','2',137882.49,137944.99,62.50,50000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','286',6863,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','286',6864,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','287',6865,'1','1',974087.32,974087.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','287',6866,'2','1',427329.39,427329.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','287',6867,'3','1',721699.76,721699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','287',6868,'4','1',312870.04,312870.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','287',6869,'5','1',951388.90,951388.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','287',6870,'6','1',190018.80,190018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','287',6871,'7','1',738172.25,738172.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','287',6872,'8','1',350815.05,350815.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','287',6873,'9','1',578468.13,578468.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','287',6874,'10','1',169271.42,169271.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','287',6875,'11','1',755974.46,755974.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','287',6876,'12','1',189759.87,189759.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','287',6877,'13','1',302105.75,302105.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','287',6878,'14','1',105856.91,105856.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','287',6879,'15','1',312779.63,312779.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','287',6880,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','287',6881,'17','1',84659.03,84659.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','287',6882,'18','1',405722.65,405722.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','287',6883,'19','1',86069.64,86069.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','287',6884,'20','1',398083.59,398083.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','287',6885,'21','2',238877.69,239312.20,434.51,347608.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','287',6886,'22','2',137944.99,138546.30,601.31,481048.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','287',6887,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','287',6888,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','288',6889,'1','1',974087.32,977008.13,2920.81,511141.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','288',6890,'2','1',427329.39,428170.81,841.42,147248.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','288',6891,'3','1',721699.76,725058.70,3358.94,587814.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','288',6892,'4','1',312870.04,313723.06,853.02,149278.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','288',6893,'5','1',951388.90,954419.14,3030.24,530292.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','288',6894,'6','1',190018.80,190018.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','288',6895,'7','1',738172.25,739660.74,1488.49,260485.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','288',6896,'8','1',350815.05,350815.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','288',6897,'9','1',578468.13,581251.54,2783.41,487096.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','288',6898,'10','1',169271.42,169297.14,25.72,4501.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','288',6899,'11','1',755974.46,757722.44,1747.98,305896.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','288',6900,'12','1',189759.87,189759.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','288',6901,'13','1',302105.75,302105.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','288',6902,'14','1',105856.91,105856.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','288',6903,'15','1',312779.63,312779.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','288',6904,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','288',6905,'17','1',84659.03,84659.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','288',6906,'18','1',405722.65,405722.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','288',6907,'19','1',86069.64,86069.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','288',6908,'20','1',398083.59,398083.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','288',6909,'21','2',239312.20,241637.56,2325.36,1860288.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','288',6910,'22','2',138546.30,138546.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','288',6911,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','288',6912,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','289',6913,'1','1',977008.13,981457.43,4449.30,778627.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','289',6914,'2','1',428170.81,429646.69,1475.88,258279.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','289',6915,'3','1',725058.70,727517.77,2459.07,430337.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','289',6916,'4','1',313723.06,314590.32,867.26,151770.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','289',6917,'5','1',954419.14,957818.25,3399.11,594844.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','289',6918,'6','1',190018.80,192042.77,2023.97,354194.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','289',6919,'7','1',739660.74,743970.77,4310.03,754255.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','289',6920,'8','1',350815.05,353205.96,2390.91,418409.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','289',6921,'9','1',581251.54,585150.25,3898.71,682274.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','289',6922,'10','1',169297.14,169967.31,670.17,117279.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','289',6923,'11','1',757722.44,762298.91,4576.47,800882.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','289',6924,'12','1',189759.87,189759.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','289',6925,'13','1',302105.75,302105.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','289',6926,'14','1',105856.91,105856.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','289',6927,'15','1',312779.63,312779.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','289',6928,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','289',6929,'17','1',84659.03,84659.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','289',6930,'18','1',405722.65,405722.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','289',6931,'19','1',86069.64,86069.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','289',6932,'20','1',398083.59,398083.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','289',6933,'21','2',241637.56,241637.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','289',6934,'22','2',138546.30,138903.82,357.52,286016.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','289',6935,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','289',6936,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','290',6937,'1','1',981457.43,984535.12,3077.69,538595.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','290',6938,'2','1',429646.69,430102.07,455.38,79691.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','290',6939,'3','1',727517.77,730250.62,2732.85,478248.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','290',6940,'4','1',314590.32,314590.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','290',6941,'5','1',957818.25,959360.77,1542.52,269941.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','290',6942,'6','1',192042.77,193208.55,1165.78,204011.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','290',6943,'7','1',743970.77,747100.00,3129.23,547615.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','290',6944,'8','1',353205.96,353978.59,772.63,135210.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','290',6945,'9','1',585150.25,588809.87,3659.62,640433.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','290',6946,'10','1',169967.31,170315.96,348.65,61013.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','290',6947,'11','1',762298.91,766292.29,3993.38,698841.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','290',6948,'12','1',189759.87,190017.27,257.40,45045.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','290',6949,'13','1',302105.75,302105.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','290',6950,'14','1',105856.91,105856.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','290',6951,'15','1',312779.63,312779.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','290',6952,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','290',6953,'17','1',84659.03,84659.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','290',6954,'18','1',405722.65,405722.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','290',6955,'19','1',86069.64,86069.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','290',6956,'20','1',398083.59,398083.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','290',6957,'21','2',241637.56,244197.69,2560.13,2048104.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','290',6958,'22','2',138903.82,139933.82,1030.00,824000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','290',6959,'23','2',109419.00,109419.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','290',6960,'24','2',49493.60,49493.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','291',6961,'1','1',984535.12,988198.73,3643.61,637631.75,0.00,0.00,20.00,0.00,0.00),('1','248','1','291',6962,'2','1',430102.07,431319.39,1217.32,213031.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','291',6963,'3','1',730250.62,733895.02,3644.40,637770.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','291',6964,'4','1',314590.32,314590.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','291',6965,'5','1',959360.77,962429.01,3068.24,536942.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','291',6966,'6','1',193208.55,193991.34,782.79,136988.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','291',6967,'7','1',747100.00,751598.36,4498.36,787213.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','291',6968,'8','1',353978.59,355916.97,1938.38,339216.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','291',6969,'9','1',588809.87,592522.62,3712.75,649731.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','291',6970,'10','1',170315.96,172085.37,1769.41,309646.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','291',6971,'11','1',766292.29,770557.28,4264.99,746373.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','291',6972,'12','1',190017.27,191556.68,1539.41,269396.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','291',6973,'13','1',302105.75,302105.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','291',6974,'14','1',105856.91,105856.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','291',6975,'15','1',312779.63,312779.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','291',6976,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','291',6977,'17','1',84659.03,84659.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','291',6978,'18','1',405722.65,405722.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','291',6979,'19','1',86069.64,86069.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','291',6980,'20','1',398083.59,398083.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','291',6981,'21','2',244197.69,244907.78,700.09,560072.00,0.00,0.00,10.00,0.00,0.00),('1','248','4','291',6982,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','291',6983,'23','2',109419.00,109420.25,1.25,1000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','291',6984,'24','2',49493.60,49494.87,1.27,1016.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','292',6985,'1','1',988198.73,989933.00,1734.27,303497.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','292',6986,'2','1',431319.39,431319.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','292',6987,'3','1',733895.02,735062.80,1167.78,204361.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','292',6988,'4','1',314590.32,314590.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','292',6989,'5','1',962429.01,964149.62,1720.61,301106.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','292',6990,'6','1',193991.34,194154.63,163.29,28575.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','292',6991,'7','1',751598.36,755821.75,4223.39,739093.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','292',6992,'8','1',355916.97,357847.00,1930.03,337755.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','292',6993,'9','1',592522.62,594626.40,2103.78,368161.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','292',6994,'10','1',172085.37,173590.60,1505.23,263415.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','292',6995,'11','1',770557.28,774438.04,3880.76,679133.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','292',6996,'12','1',191556.68,193477.97,1921.29,336225.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','292',6997,'13','1',302105.75,302105.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','292',6998,'14','1',105856.91,105856.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','292',6999,'15','1',312779.63,312779.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','292',7000,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','292',7001,'17','1',84659.03,87001.91,2342.88,410004.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','292',7002,'18','1',405722.65,406508.32,785.67,137492.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','292',7003,'19','1',86069.64,86751.01,681.37,119239.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','292',7004,'20','1',398083.59,400709.22,2625.63,459485.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','292',7005,'21','2',244907.78,245109.79,202.01,161608.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','292',7006,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','292',7007,'23','2',109420.25,111256.64,1836.39,1469112.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','292',7008,'24','2',49494.87,51783.63,2288.76,1831008.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','293',7009,'1','1',989933.00,993237.07,3304.07,578212.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','293',7010,'2','1',431319.39,432469.55,1150.16,201278.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','293',7011,'3','1',735062.80,735062.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','293',7012,'4','1',314590.32,314590.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','293',7013,'5','1',964149.62,967869.22,3719.60,650930.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','293',7014,'6','1',194154.63,195150.80,996.17,174329.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','293',7015,'7','1',755821.75,759147.84,3326.09,582065.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','293',7016,'8','1',357847.00,359950.14,2103.14,368049.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','293',7017,'9','1',594626.40,594626.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','293',7018,'10','1',173590.60,173590.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','293',7019,'11','1',774438.04,777855.38,3417.34,598034.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','293',7020,'12','1',193477.97,194290.85,812.88,142254.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','293',7021,'13','1',302105.75,305263.53,3157.78,552611.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','293',7022,'14','1',105856.91,106422.15,565.24,98917.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','293',7023,'15','1',312779.63,312779.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','293',7024,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','293',7025,'17','1',87001.91,87786.15,784.24,137242.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','293',7026,'18','1',406508.32,408769.31,2260.99,395673.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','293',7027,'19','1',86751.01,87627.71,876.70,153422.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','293',7028,'20','1',400709.22,404201.71,3492.49,611185.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','293',7029,'21','2',245109.79,245109.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','293',7030,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','293',7031,'23','2',111256.64,111456.64,200.00,160000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','293',7032,'24','2',51783.63,52585.52,801.89,641512.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','294',7033,'1','1',993237.07,997133.45,3896.38,681866.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','294',7034,'2','1',432469.55,433436.77,967.22,169263.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','294',7035,'3','1',735062.80,735062.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','294',7036,'4','1',314590.32,314590.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','294',7037,'5','1',967869.22,971543.30,3674.08,642964.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','294',7038,'6','1',195150.80,195150.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','294',7039,'7','1',759147.84,762637.55,3489.71,610699.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','294',7040,'8','1',359950.14,360931.86,981.72,171801.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','294',7041,'9','1',594626.40,595595.74,969.34,169634.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','294',7042,'10','1',173590.60,174452.00,861.40,150745.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','294',7043,'11','1',777855.38,781320.45,3465.07,606387.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','294',7044,'12','1',194290.85,194922.89,632.04,110607.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','294',7045,'13','1',305263.53,308746.02,3482.49,609435.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','294',7046,'14','1',106422.15,106422.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','294',7047,'15','1',312779.63,312779.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','294',7048,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','294',7049,'17','1',87786.15,87786.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','294',7050,'18','1',408769.31,408769.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','294',7051,'19','1',87627.71,88538.80,911.09,159440.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','294',7052,'20','1',404201.71,407780.95,3579.24,626367.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','294',7053,'21','2',245109.79,245109.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','294',7054,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','294',7055,'23','2',111456.64,111514.14,57.50,46000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','294',7056,'24','2',52585.52,54029.06,1443.54,1154832.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','295',7057,'1','1',997133.45,1001770.92,4588.90,803057.50,0.00,0.00,48.57,0.00,0.00),('1','248','1','295',7058,'2','1',433436.77,435577.81,2141.04,374682.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','295',7059,'3','1',735062.80,735062.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','295',7060,'4','1',314590.32,314590.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','295',7061,'5','1',971543.30,975169.79,3626.49,634635.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','295',7062,'6','1',195150.80,196929.44,1778.64,311262.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','295',7063,'7','1',762637.55,766386.87,3749.32,656131.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','295',7064,'8','1',360931.86,362872.67,1940.81,339641.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','295',7065,'9','1',595595.74,595595.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','295',7066,'10','1',174452.00,174452.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','295',7067,'11','1',781320.45,785271.04,3950.59,691353.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','295',7068,'12','1',194922.89,197324.41,2401.52,420266.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','295',7069,'13','1',308746.02,308746.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','295',7070,'14','1',106422.15,106422.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','295',7071,'15','1',312779.63,312779.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','295',7072,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','295',7073,'17','1',87786.15,89218.29,1432.14,250624.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','295',7074,'18','1',408769.31,411868.71,3099.40,542395.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','295',7075,'19','1',88538.80,90101.70,1562.90,273507.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','295',7076,'20','1',407780.95,411822.32,4041.37,707239.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','295',7077,'21','2',245109.79,245109.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','295',7078,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','295',7079,'23','2',111514.14,111514.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','295',7080,'24','2',54029.06,54594.07,565.01,452008.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','296',7081,'1','1',1001770.92,1005659.03,3888.11,680419.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','296',7082,'2','1',435577.81,435577.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','296',7083,'3','1',735062.80,735062.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','296',7084,'4','1',314590.32,314590.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','296',7085,'5','1',975169.79,977756.42,2586.63,452660.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','296',7086,'6','1',196929.44,196929.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','296',7087,'7','1',766386.87,769763.74,3376.87,590952.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','296',7088,'8','1',362872.67,364417.60,1544.93,270362.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','296',7089,'9','1',595595.74,599103.32,3507.58,613826.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','296',7090,'10','1',174452.00,174452.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','296',7091,'11','1',785271.04,788683.50,3412.46,597180.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','296',7092,'12','1',197324.41,197324.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','296',7093,'13','1',308746.02,308746.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','296',7094,'14','1',106422.15,106422.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','296',7095,'15','1',312779.63,312779.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','296',7096,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','296',7097,'17','1',89218.29,89327.26,108.97,19069.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','296',7098,'18','1',411868.71,415026.85,3158.14,552674.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','296',7099,'19','1',90101.70,90101.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','296',7100,'20','1',411822.32,415229.13,3406.81,596191.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','296',7101,'21','2',245109.79,245109.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','296',7102,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','296',7103,'23','2',111514.14,112788.64,1271.45,1017160.00,0.00,0.00,3.05,0.00,0.00),('1','248','5','296',7104,'24','2',54594.07,55785.80,1191.73,953384.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','297',7105,'1','1',1005659.03,1008413.89,2754.86,482100.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','297',7106,'2','1',435577.81,437476.10,1898.29,332200.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','297',7107,'3','1',735062.80,737243.76,2180.96,381668.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','297',7108,'4','1',314590.32,316413.68,1823.36,319088.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','297',7109,'5','1',977756.42,980385.33,2628.91,460059.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','297',7110,'6','1',196929.44,198979.57,2050.13,358772.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','297',7111,'7','1',769763.74,773315.15,3551.41,621496.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','297',7112,'8','1',364417.60,367046.18,2628.58,460001.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','297',7113,'9','1',599103.32,600068.18,964.86,168850.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','297',7114,'10','1',174452.00,175875.32,1423.32,249081.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','297',7115,'11','1',788683.50,792909.64,4226.14,739574.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','297',7116,'12','1',197324.41,199353.13,2028.72,355026.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','297',7117,'13','1',308746.02,308746.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','297',7118,'14','1',106422.15,106422.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','297',7119,'15','1',312779.63,314528.78,1749.15,306101.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','297',7120,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','297',7121,'17','1',89327.26,90316.36,989.10,173092.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','297',7122,'18','1',415026.85,416922.04,1895.19,331658.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','297',7123,'19','1',90101.70,91085.66,983.96,172193.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','297',7124,'20','1',415229.13,416765.40,1536.27,268847.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','297',7125,'21','2',245109.79,245109.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','297',7126,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','297',7127,'23','2',112788.64,113638.64,850.00,680000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','297',7128,'24','2',55785.80,56201.47,415.67,332536.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','298',7129,'1','1',1008413.89,1011798.43,3384.54,592294.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','298',7130,'2','1',437476.10,437476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','298',7131,'3','1',737243.76,740365.69,3121.93,546337.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','298',7132,'4','1',316413.68,316958.94,545.26,95420.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','298',7133,'5','1',980385.33,983868.57,3483.24,609567.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','298',7134,'6','1',198979.57,198979.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','298',7135,'7','1',773315.15,775904.62,2589.47,453157.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','298',7136,'8','1',367046.18,367898.36,852.18,149131.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','298',7137,'9','1',600068.18,600915.03,846.85,148198.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','298',7138,'10','1',175875.32,176935.60,1060.28,185549.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','298',7139,'11','1',792909.64,794674.02,1764.38,308766.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','298',7140,'12','1',199353.13,200456.00,1102.87,193002.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','298',7141,'13','1',308746.02,310113.52,1367.50,239312.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','298',7142,'14','1',106422.15,106422.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','298',7143,'15','1',314528.78,315983.48,1454.70,254572.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','298',7144,'16','1',81697.54,81697.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','298',7145,'17','1',90316.36,90316.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','298',7146,'18','1',416922.04,419080.68,2158.64,377762.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','298',7147,'19','1',91085.66,91097.95,12.29,2150.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','298',7148,'20','1',416765.40,419655.58,2890.18,505781.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','298',7149,'21','2',245109.79,245109.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','298',7150,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','298',7151,'23','2',113638.64,114197.40,558.76,447008.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','298',7152,'24','2',56201.47,58436.73,2235.26,1788208.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','299',7153,'1','1',1011798.43,1012982.65,1184.22,207238.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','299',7154,'2','1',437476.10,438219.96,743.86,130175.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','299',7155,'3','1',740365.69,741644.74,1279.05,223833.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','299',7156,'4','1',316958.94,316958.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','299',7157,'5','1',983868.57,984960.36,1091.79,191063.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','299',7158,'6','1',198979.57,199639.70,660.13,115522.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','299',7159,'7','1',775904.62,775904.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','299',7160,'8','1',367898.36,367898.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','299',7161,'9','1',600915.03,600915.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','299',7162,'10','1',176935.60,176935.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','299',7163,'11','1',794674.02,794674.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','299',7164,'12','1',200456.00,200456.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','299',7165,'13','1',310113.52,310744.18,630.66,110365.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','299',7166,'14','1',106422.15,107046.61,624.46,109280.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','299',7167,'15','1',315983.48,317228.05,1244.57,217799.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','299',7168,'16','1',81697.54,82179.04,481.50,84262.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','299',7169,'17','1',90316.36,90801.39,485.03,84880.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','299',7170,'18','1',419080.68,420122.70,1042.02,182353.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','299',7171,'19','1',91097.95,91881.91,783.96,137193.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','299',7172,'20','1',419655.58,420898.20,1242.62,217458.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','299',7173,'21','2',245109.79,245109.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','299',7174,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','299',7175,'23','2',114197.40,114226.40,29.00,23200.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','299',7176,'24','2',58436.73,58902.49,465.76,372608.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','300',7177,'1','1',1012982.65,1012982.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','300',7178,'2','1',438219.96,438219.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','300',7179,'3','1',741644.74,741644.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','300',7180,'4','1',316958.94,316958.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','300',7181,'5','1',984960.36,984960.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','300',7182,'6','1',199639.70,199639.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','300',7183,'7','1',775904.62,775904.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','300',7184,'8','1',367898.36,367898.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','300',7185,'9','1',600915.03,600915.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','300',7186,'10','1',176935.60,176935.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','300',7187,'11','1',794674.02,794674.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','300',7188,'12','1',200456.00,200456.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','300',7189,'13','1',310744.18,310744.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','300',7190,'14','1',107046.61,107046.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','300',7191,'15','1',317228.05,317228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','300',7192,'16','1',82179.04,82179.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','300',7193,'17','1',90801.39,90801.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','300',7194,'18','1',420122.70,420122.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','300',7195,'19','1',91881.91,91881.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','300',7196,'20','1',420898.20,420898.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','300',7197,'21','2',245109.79,245109.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','300',7198,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','300',7199,'23','2',114226.40,114226.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','300',7200,'24','2',58902.49,60322.65,1420.16,1136128.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','301',7201,'1','1',1012982.65,1016281.49,3298.84,577297.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','301',7202,'2','1',438219.96,440332.02,2112.06,369610.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','301',7203,'3','1',741644.74,744710.62,3065.88,536529.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','301',7204,'4','1',316958.94,319065.68,2106.74,368679.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','301',7205,'5','1',984960.36,986448.76,1488.40,260470.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','301',7206,'6','1',199639.70,202212.39,2572.69,450220.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','301',7207,'7','1',775904.62,779421.32,3516.70,615422.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','301',7208,'8','1',367898.36,370248.45,2350.09,411265.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','301',7209,'9','1',600915.03,604262.00,3346.97,585719.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','301',7210,'10','1',176935.60,179997.02,3061.42,535748.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','301',7211,'11','1',794674.02,797624.03,2950.01,516251.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','301',7212,'12','1',200456.00,202772.05,2316.05,405308.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','301',7213,'13','1',310744.18,310744.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','301',7214,'14','1',107046.61,107046.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','301',7215,'15','1',317228.05,317228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','301',7216,'16','1',82179.04,82179.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','301',7217,'17','1',90801.39,90801.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','301',7218,'18','1',420122.70,420122.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','301',7219,'19','1',91881.91,91881.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','301',7220,'20','1',420898.20,420898.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','301',7221,'21','2',245109.79,245109.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','301',7222,'22','2',139933.82,139933.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','301',7223,'23','2',114226.40,114291.65,65.25,52200.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','301',7224,'24','2',60322.65,62260.89,1938.24,1550592.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','302',7225,'1','1',1016281.49,1020059.35,3777.86,661125.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','302',7226,'2','1',440332.02,442652.97,2320.95,406166.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','302',7227,'3','1',744710.62,747277.13,2566.51,449139.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','302',7228,'4','1',319065.68,321966.46,2900.78,507636.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','302',7229,'5','1',986448.76,989576.04,3127.28,547274.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','302',7230,'6','1',202212.39,203686.68,1474.29,258000.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','302',7231,'7','1',779421.32,780884.13,1462.81,255991.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','302',7232,'8','1',370248.45,371298.98,1050.53,183842.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','302',7233,'9','1',604262.00,605818.61,1556.61,272406.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','302',7234,'10','1',179997.02,180167.15,170.13,29772.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','302',7235,'11','1',797624.03,798909.85,1285.82,225018.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','302',7236,'12','1',202772.05,202772.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','302',7237,'13','1',310744.18,311701.69,911.80,159565.00,0.00,0.00,45.71,0.00,0.00),('1','248','3','302',7238,'14','1',107046.61,107046.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','302',7239,'15','1',317228.05,318953.65,1725.60,301980.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','302',7240,'16','1',82179.04,83862.19,1683.15,294551.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','302',7241,'17','1',90801.39,90801.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','302',7242,'18','1',420122.70,422174.99,2052.29,359150.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','302',7243,'19','1',91881.91,92132.07,250.16,43778.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','302',7244,'20','1',420898.20,423117.53,2219.33,388382.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','302',7245,'21','2',245109.79,245112.07,2.28,1824.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','302',7246,'22','2',139933.82,140751.09,817.27,653816.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','302',7247,'23','2',114291.65,114782.83,491.18,392944.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','302',7248,'24','2',62260.89,64373.98,2113.09,1690472.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','303',7249,'1','1',1020059.35,1023306.16,3246.81,568191.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','303',7250,'2','1',442652.97,445466.71,2813.74,492404.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','303',7251,'3','1',747277.13,750109.40,2832.27,495647.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','303',7252,'4','1',321966.46,324222.59,2256.13,394822.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','303',7253,'5','1',989576.04,992670.65,3094.61,541556.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','303',7254,'6','1',203686.68,206386.17,2699.49,472410.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','303',7255,'7','1',780884.13,780884.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','303',7256,'8','1',371298.98,371298.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','303',7257,'9','1',605818.61,605818.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','303',7258,'10','1',180167.15,180167.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','303',7259,'11','1',798909.85,798909.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','303',7260,'12','1',202772.05,202772.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','303',7261,'13','1',311701.69,313878.65,2176.96,380968.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','303',7262,'14','1',107046.61,108437.29,1390.68,243369.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','303',7263,'15','1',318953.65,322032.29,3078.64,538762.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','303',7264,'16','1',83862.19,85093.37,1231.18,215456.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','303',7265,'17','1',90801.39,90801.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','303',7266,'18','1',422174.99,425506.75,3331.76,583058.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','303',7267,'19','1',92132.07,93512.22,1380.15,241526.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','303',7268,'20','1',423117.53,425618.89,2501.36,437738.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','303',7269,'21','2',245112.07,245905.50,793.43,634744.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','303',7270,'22','2',140751.09,140752.34,1.25,1000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','303',7271,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','303',7272,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','304',7273,'1','1',1023306.16,1024871.15,1564.99,273873.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','304',7274,'2','1',445466.71,447184.52,1717.81,300616.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','304',7275,'3','1',750109.40,751782.22,1672.82,292743.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','304',7276,'4','1',324222.59,325381.70,1159.11,202844.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','304',7277,'5','1',992670.65,994779.96,2109.31,369129.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','304',7278,'6','1',206386.17,206386.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','304',7279,'7','1',780884.13,780884.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','304',7280,'8','1',371298.98,371298.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','304',7281,'9','1',605818.61,605818.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','304',7282,'10','1',180167.15,180167.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','304',7283,'11','1',798909.85,798909.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','304',7284,'12','1',202772.05,202772.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','304',7285,'13','1',313878.65,315753.12,1874.47,328032.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','304',7286,'14','1',108437.29,108437.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','304',7287,'15','1',322032.29,322271.55,239.26,41870.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','304',7288,'16','1',85093.37,86933.37,1840.00,322000.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','304',7289,'17','1',90801.39,90801.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','304',7290,'18','1',425506.75,426922.84,1416.09,247815.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','304',7291,'19','1',93512.22,93512.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','304',7292,'20','1',425618.89,426245.31,626.42,109623.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','304',7293,'21','2',245905.50,246667.38,761.88,609504.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','304',7294,'22','2',140752.34,140783.59,31.25,25000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','304',7295,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','304',7296,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','305',7297,'1','1',1024871.15,1029098.21,4227.06,739735.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','305',7298,'2','1',447184.52,447184.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','305',7299,'3','1',751782.22,755448.16,3665.94,641539.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','305',7300,'4','1',325381.70,325381.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','305',7301,'5','1',994779.96,998208.38,3428.42,599973.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','305',7302,'6','1',206386.17,206386.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','305',7303,'7','1',780884.13,785097.90,4213.77,737409.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','305',7304,'8','1',371298.98,371298.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','305',7305,'9','1',605818.61,609589.44,3770.83,659895.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','305',7306,'10','1',180167.15,180167.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','305',7307,'11','1',798909.85,802507.91,3598.06,629660.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','305',7308,'12','1',202772.05,202772.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','305',7309,'13','1',315753.12,317811.37,2058.25,360193.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','305',7310,'14','1',108437.29,108437.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','305',7311,'15','1',322271.55,323187.61,916.06,160310.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','305',7312,'16','1',86933.37,88368.82,1435.45,251203.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','305',7313,'17','1',90801.39,90801.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','305',7314,'18','1',426922.84,429762.32,2839.48,496909.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','305',7315,'19','1',93512.22,93512.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','305',7316,'20','1',426245.31,428638.05,2392.74,418729.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','305',7317,'21','2',246667.38,247973.03,1305.65,1044520.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','305',7318,'22','2',140783.59,141073.59,290.00,232000.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','305',7319,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','305',7320,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','306',7321,'1','1',1029098.21,1030901.08,1802.87,315502.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','306',7322,'2','1',447184.52,448088.08,903.56,158123.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','306',7323,'3','1',755448.16,756592.25,1144.09,200215.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','306',7324,'4','1',325381.70,325850.92,469.22,82113.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','306',7325,'5','1',998208.38,1000244.95,2036.57,356399.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','306',7326,'6','1',206386.17,207104.46,718.29,125700.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','306',7327,'7','1',785097.90,786538.89,1440.99,252173.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','306',7328,'8','1',371298.98,371298.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','306',7329,'9','1',609589.44,609589.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','306',7330,'10','1',180167.15,180167.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','306',7331,'11','1',802507.91,803198.62,690.71,120874.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','306',7332,'12','1',202772.05,202772.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','306',7333,'13','1',317811.37,319539.05,1727.68,302344.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','306',7334,'14','1',108437.29,108798.75,361.46,63255.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','306',7335,'15','1',323187.61,323705.90,518.29,90700.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','306',7336,'16','1',88368.82,90265.86,1897.04,331982.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','306',7337,'17','1',90801.39,90994.88,193.49,33860.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','306',7338,'18','1',429762.32,431271.46,1509.14,264099.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','306',7339,'19','1',93512.22,93680.76,168.54,29494.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','306',7340,'20','1',428638.05,429184.06,546.01,95551.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','306',7341,'21','2',247973.03,249009.37,1036.34,829072.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','306',7342,'22','2',141073.59,141073.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','306',7343,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','306',7344,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','307',7345,'1','1',1030901.08,1033011.03,2109.95,369241.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','307',7346,'2','1',448088.08,449384.48,1296.40,226870.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','307',7347,'3','1',756592.25,760086.71,3494.46,611530.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','307',7348,'4','1',325850.92,327835.48,1984.56,347298.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','307',7349,'5','1',1000244.95,1003901.18,3656.23,639840.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','307',7350,'6','1',207104.46,207104.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','307',7351,'7','1',786538.89,791554.38,5015.49,877710.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','307',7352,'8','1',371298.98,371298.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','307',7353,'9','1',609589.44,613961.03,4371.59,765028.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','307',7354,'10','1',180167.15,180167.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','307',7355,'11','1',803198.62,806547.38,3348.76,586033.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','307',7356,'12','1',202772.05,202772.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','307',7357,'13','1',319539.05,323051.76,3512.71,614724.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','307',7358,'14','1',108798.75,108798.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','307',7359,'15','1',323705.90,327152.70,3446.80,603190.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','307',7360,'16','1',90265.86,90265.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','307',7361,'17','1',90994.88,90994.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','307',7362,'18','1',431271.46,434080.53,2809.07,491587.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','307',7363,'19','1',93680.76,93680.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','307',7364,'20','1',429184.06,432190.09,3006.03,526055.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','307',7365,'21','2',249009.37,250910.64,1901.27,1521016.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','307',7366,'22','2',141073.59,141073.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','307',7367,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','307',7368,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','308',7369,'1','1',1033011.03,1034368.06,1357.03,237480.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','308',7370,'2','1',449384.48,450415.86,1031.38,180491.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','308',7371,'3','1',760086.71,762070.30,1983.59,347128.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','308',7372,'4','1',327835.48,328309.71,474.23,82990.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','308',7373,'5','1',1003901.18,1005895.85,1994.67,349067.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','308',7374,'6','1',207104.46,207554.20,449.74,78704.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','308',7375,'7','1',791554.38,794598.91,3044.53,532792.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','308',7376,'8','1',371298.98,372961.56,1662.58,290951.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','308',7377,'9','1',613961.03,616025.00,2063.97,361194.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','308',7378,'10','1',180167.15,181199.90,1032.75,180731.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','308',7379,'11','1',806547.38,809282.91,2735.53,478717.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','308',7380,'12','1',202772.05,203680.34,908.29,158950.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','308',7381,'13','1',323051.76,323809.80,758.04,132657.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','308',7382,'14','1',108798.75,108798.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','308',7383,'15','1',327152.70,328528.19,1375.49,240710.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','308',7384,'16','1',90265.86,90265.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','308',7385,'17','1',90994.88,90994.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','308',7386,'18','1',434080.53,434722.30,641.77,112309.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','308',7387,'19','1',93680.76,93680.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','308',7388,'20','1',432190.09,433138.82,948.73,166027.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','308',7389,'21','2',250910.64,252849.32,1938.68,1550944.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','308',7390,'22','2',141073.59,142069.94,996.35,797080.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','308',7391,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','308',7392,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','309',7393,'1','1',1034368.06,1038382.42,4004.36,700763.00,0.00,0.00,10.00,0.00,0.00),('1','248','1','309',7394,'2','1',450415.86,453709.14,3283.28,574574.00,0.00,0.00,10.00,0.00,0.00),('1','248','1','309',7395,'3','1',762070.30,765987.77,3907.47,683807.25,0.00,0.00,10.00,0.00,0.00),('1','248','1','309',7396,'4','1',328309.71,331043.61,2723.90,476682.50,0.00,0.00,10.00,0.00,0.00),('1','248','1','309',7397,'5','1',1005895.85,1010276.50,4370.65,764863.75,0.00,0.00,10.00,0.00,0.00),('1','248','1','309',7398,'6','1',207554.20,209684.53,2130.33,372807.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','309',7399,'7','1',794598.91,796217.05,1608.14,281424.50,0.00,0.00,10.00,0.00,0.00),('1','248','2','309',7400,'8','1',372961.56,374409.04,1447.48,253309.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','309',7401,'9','1',616025.00,618060.23,1995.23,349165.25,0.00,0.00,40.00,0.00,0.00),('1','248','2','309',7402,'10','1',181199.90,181199.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','309',7403,'11','1',809282.91,810482.36,1199.45,209903.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','309',7404,'12','1',203680.34,204684.01,1003.67,175642.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','309',7405,'13','1',323809.80,323809.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','309',7406,'14','1',108798.75,108798.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','309',7407,'15','1',328528.19,328528.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','309',7408,'16','1',90265.86,90265.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','309',7409,'17','1',90994.88,90994.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','309',7410,'18','1',434722.30,434722.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','309',7411,'19','1',93680.76,93680.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','309',7412,'20','1',433138.82,433138.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','309',7413,'21','2',252849.32,253959.98,1110.66,888528.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','309',7414,'22','2',142069.94,142427.29,357.35,285880.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','309',7415,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','309',7416,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','310',7417,'1','1',1038382.42,1040161.55,1779.13,311347.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','310',7418,'2','1',453709.14,454786.77,1077.63,188585.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','310',7419,'3','1',765987.77,768491.52,2503.75,438156.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','310',7420,'4','1',331043.61,331970.21,926.60,162155.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','310',7421,'5','1',1010276.50,1012090.74,1814.24,317492.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','310',7422,'6','1',209684.53,210741.79,1057.26,185020.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','310',7423,'7','1',796217.05,796217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','310',7424,'8','1',374409.04,374409.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','310',7425,'9','1',618060.23,618445.89,385.66,67490.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','310',7426,'10','1',181199.90,181199.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','310',7427,'11','1',810482.36,810948.77,466.41,81621.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','310',7428,'12','1',204684.01,204684.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','310',7429,'13','1',323809.80,324757.36,947.56,165823.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','310',7430,'14','1',108798.75,109050.91,252.16,44128.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','310',7431,'15','1',328528.19,329489.44,961.25,168218.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','310',7432,'16','1',90265.86,90383.86,118.00,20650.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','310',7433,'17','1',90994.88,90994.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','310',7434,'18','1',434722.30,435635.50,913.20,159810.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','310',7435,'19','1',93680.76,93680.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','310',7436,'20','1',433138.82,433887.03,748.21,130936.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','310',7437,'21','2',253959.98,256308.04,2348.06,1878448.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','310',7438,'22','2',142427.29,142427.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','310',7439,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','310',7440,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','311',7441,'1','1',1040161.55,1044401.98,4240.43,742075.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','311',7442,'2','1',454786.77,454786.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','311',7443,'3','1',768491.52,771746.73,3255.21,569661.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','311',7444,'4','1',331970.21,331970.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','311',7445,'5','1',1012090.74,1015495.85,3405.11,595894.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','311',7446,'6','1',210741.79,211251.15,509.36,89138.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','311',7447,'7','1',796217.05,799865.91,3648.86,638550.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','311',7448,'8','1',374409.04,375322.28,913.24,159817.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','311',7449,'9','1',618445.89,622514.67,4068.78,712036.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','311',7450,'10','1',181199.90,181199.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','311',7451,'11','1',810948.77,814416.46,3467.69,606845.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','311',7452,'12','1',204684.01,204684.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','311',7453,'13','1',324757.36,327825.55,3068.19,536933.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','311',7454,'14','1',109050.91,109050.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','311',7455,'15','1',329489.44,332844.84,3355.40,587195.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','311',7456,'16','1',90383.86,90383.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','311',7457,'17','1',90994.88,90994.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','311',7458,'18','1',435635.50,438748.50,3113.00,544775.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','311',7459,'19','1',93680.76,93680.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','311',7460,'20','1',433887.03,437107.75,3220.72,563626.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','311',7461,'21','2',256308.04,257813.16,1505.12,1204096.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','311',7462,'22','2',142427.29,142427.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','311',7463,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','311',7464,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','312',7465,'1','1',1044401.98,1048528.57,4126.59,722153.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','312',7466,'2','1',454786.77,454817.64,30.87,5402.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','312',7467,'3','1',771746.73,774378.36,2631.63,460535.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','312',7468,'4','1',331970.21,331970.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','312',7469,'5','1',1015495.85,1018428.58,2932.73,513227.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','312',7470,'6','1',211251.15,211361.42,110.27,19297.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','312',7471,'7','1',799865.91,801971.40,2105.49,368460.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','312',7472,'8','1',375322.28,376225.27,902.99,158023.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','312',7473,'9','1',622514.67,626024.23,3509.56,614173.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','312',7474,'10','1',181199.90,182060.81,860.91,150659.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','312',7475,'11','1',814416.46,817041.11,2624.65,459313.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','312',7476,'12','1',204684.01,204684.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','312',7477,'13','1',327825.55,330054.11,2228.56,389998.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','312',7478,'14','1',109050.91,109229.37,178.46,31230.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','312',7479,'15','1',332844.84,336611.73,3766.89,659205.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','312',7480,'16','1',90383.86,90383.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','312',7481,'17','1',90994.88,90994.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','312',7482,'18','1',438748.50,441050.60,2302.10,402867.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','312',7483,'19','1',93680.76,93680.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','312',7484,'20','1',437107.75,439448.90,2341.15,409701.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','312',7485,'21','2',257813.16,259016.91,1203.75,963000.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','312',7486,'22','2',142427.29,142777.05,349.76,279808.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','312',7487,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','312',7488,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','313',7489,'1','1',1048528.57,1048528.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','313',7490,'2','1',454817.64,454817.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','313',7491,'3','1',774378.36,774378.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','313',7492,'4','1',331970.21,331970.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','313',7493,'5','1',1018428.58,1018428.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','313',7494,'6','1',211361.42,211361.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','313',7495,'7','1',801971.40,803161.70,1190.30,208302.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','313',7496,'8','1',376225.27,377599.81,1374.54,240544.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','313',7497,'9','1',626024.23,627231.88,1207.65,211338.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','313',7498,'10','1',182060.81,183090.83,1030.02,180253.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','313',7499,'11','1',817041.11,818162.46,1121.35,196236.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','313',7500,'12','1',204684.01,205685.43,1001.42,175248.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','313',7501,'13','1',330054.11,332022.26,1968.15,344426.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','313',7502,'14','1',109229.37,109983.64,754.27,131997.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','313',7503,'15','1',336611.73,339102.13,2490.40,435820.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','313',7504,'16','1',90383.86,91830.52,1446.66,253165.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','313',7505,'17','1',90994.88,91860.86,865.98,151546.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','313',7506,'18','1',441050.60,443134.35,2083.75,364656.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','313',7507,'19','1',93680.76,94752.97,1072.21,187636.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','313',7508,'20','1',439448.90,441345.48,1896.58,331901.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','313',7509,'21','2',259016.91,260331.47,1314.56,1051648.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','313',7510,'22','2',142777.05,142777.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','313',7511,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','313',7512,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','314',7513,'1','1',1048528.57,1050609.97,2081.40,364245.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','314',7514,'2','1',454817.64,457056.70,2239.06,391835.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','314',7515,'3','1',774378.36,776080.47,1702.11,297869.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','314',7516,'4','1',331970.21,333816.46,1846.25,323093.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','314',7517,'5','1',1018428.58,1020898.22,2469.64,432187.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','314',7518,'6','1',211361.42,212324.50,963.08,168539.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','314',7519,'7','1',803161.70,805164.65,2002.95,350516.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','314',7520,'8','1',377599.81,377599.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','314',7521,'9','1',627231.88,627231.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','314',7522,'10','1',183090.83,183090.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','314',7523,'11','1',818162.46,819943.41,1780.95,311666.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','314',7524,'12','1',205685.43,206540.68,855.25,149668.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','314',7525,'13','1',332022.26,332493.60,471.34,82484.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','314',7526,'14','1',109983.64,109983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','314',7527,'15','1',339102.13,339102.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','314',7528,'16','1',91830.52,91830.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','314',7529,'17','1',91860.86,91860.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','314',7530,'18','1',443134.35,443134.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','314',7531,'19','1',94752.97,94752.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','314',7532,'20','1',441345.48,441345.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','314',7533,'21','2',260331.47,263678.22,3346.75,2677400.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','314',7534,'22','2',142777.05,143307.62,530.57,424456.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','314',7535,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','314',7536,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','315',7537,'1','1',1050609.97,1054088.52,3458.55,605246.25,0.00,0.00,20.00,0.00,0.00),('1','248','1','315',7538,'2','1',457056.70,458031.20,954.50,167037.50,0.00,0.00,20.00,0.00,0.00),('1','248','1','315',7539,'3','1',776080.47,779638.00,3537.53,619067.75,0.00,0.00,20.00,0.00,0.00),('1','248','1','315',7540,'4','1',333816.46,334637.37,800.91,140159.25,0.00,0.00,20.00,0.00,0.00),('1','248','1','315',7541,'5','1',1020898.22,1022812.04,1893.82,331418.50,0.00,0.00,20.00,0.00,0.00),('1','248','1','315',7542,'6','1',212324.50,212324.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','315',7543,'7','1',805164.65,808781.02,3616.37,632864.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','315',7544,'8','1',377599.81,379805.13,2205.32,385931.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','315',7545,'9','1',627231.88,630851.94,3620.06,633510.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','315',7546,'10','1',183090.83,183090.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','315',7547,'11','1',819943.41,823243.90,3300.49,577585.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','315',7548,'12','1',206540.68,206540.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','315',7549,'13','1',332493.60,336209.63,3716.03,650305.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','315',7550,'14','1',109983.64,109983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','315',7551,'15','1',339102.13,342034.38,2932.25,513143.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','315',7552,'16','1',91830.52,91830.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','315',7553,'17','1',91860.86,91860.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','315',7554,'18','1',443134.35,446358.55,3224.20,564235.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','315',7555,'19','1',94752.97,94752.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','315',7556,'20','1',441345.48,444624.47,3278.99,573823.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','315',7557,'21','2',263678.22,265009.75,1301.53,1041224.00,0.00,0.00,30.00,0.00,0.00),('1','248','4','315',7558,'22','2',143307.62,143307.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','315',7559,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','315',7560,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','316',7561,'1','1',1054088.52,1057864.35,3775.83,660770.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','316',7562,'2','1',458031.20,459008.34,977.14,170999.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','316',7563,'3','1',779638.00,783296.76,3658.76,640283.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','316',7564,'4','1',334637.37,334637.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','316',7565,'5','1',1022812.04,1025001.36,2189.32,383131.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','316',7566,'6','1',212324.50,212324.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','316',7567,'7','1',808781.02,810956.31,2175.29,380675.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','316',7568,'8','1',379805.13,379805.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','316',7569,'9','1',630851.94,633429.60,2577.66,451090.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','316',7570,'10','1',183090.83,183318.21,227.38,39791.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','316',7571,'11','1',823243.90,826734.66,3490.76,610883.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','316',7572,'12','1',206540.68,206540.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','316',7573,'13','1',336209.63,338518.06,2308.43,403975.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','316',7574,'14','1',109983.64,110472.92,489.28,85624.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','316',7575,'15','1',342034.38,343766.19,1731.81,303066.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','316',7576,'16','1',91830.52,92631.43,800.91,140159.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','316',7577,'17','1',91860.86,91860.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','316',7578,'18','1',446358.55,447821.13,1462.58,255951.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','316',7579,'19','1',94752.97,94752.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','316',7580,'20','1',444624.47,447825.72,3201.25,560218.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','316',7581,'21','2',265009.75,266859.21,1849.46,1479568.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','316',7582,'22','2',143307.62,144179.34,871.72,697376.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','316',7583,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','316',7584,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','317',7585,'1','1',1057864.35,1059554.67,1690.32,295806.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','317',7586,'2','1',459008.34,460168.70,1160.36,203063.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','317',7587,'3','1',783296.76,784854.93,1558.17,272679.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','317',7588,'4','1',334637.37,334637.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','317',7589,'5','1',1025001.36,1027453.26,2451.90,429082.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','317',7590,'6','1',212324.50,213276.19,951.69,166545.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','317',7591,'7','1',810956.31,814127.45,3171.14,554949.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','317',7592,'8','1',379805.13,380977.29,1172.16,205128.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','317',7593,'9','1',633429.60,635528.47,2098.87,367302.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','317',7594,'10','1',183318.21,184171.92,853.71,149399.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','317',7595,'11','1',826734.66,827713.21,978.55,171246.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','317',7596,'12','1',206540.68,208345.34,1804.66,315815.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','317',7597,'13','1',338518.06,340815.44,2297.38,402041.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','317',7598,'14','1',110472.92,112017.90,1544.98,270371.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','317',7599,'15','1',343766.19,346267.59,2501.40,437745.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','317',7600,'16','1',92631.43,93963.17,1331.74,233054.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','317',7601,'17','1',91860.86,92874.74,1013.88,177429.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','317',7602,'18','1',447821.13,449518.97,1697.84,297122.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','317',7603,'19','1',94752.97,95790.72,1037.75,181606.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','317',7604,'20','1',447825.72,449436.28,1610.56,281848.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','317',7605,'21','2',266859.21,267957.52,1098.31,878648.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','317',7606,'22','2',144179.34,144376.45,197.11,157688.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','317',7607,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','317',7608,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','318',7609,'1','1',1059554.67,1062608.19,3053.52,534366.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','318',7610,'2','1',460168.70,460545.71,377.01,65976.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','318',7611,'3','1',784854.93,784854.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','318',7612,'4','1',334637.37,334637.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','318',7613,'5','1',1027453.26,1030007.73,2554.47,447032.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','318',7614,'6','1',213276.19,213276.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','318',7615,'7','1',814127.45,816743.30,2615.85,457773.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','318',7616,'8','1',380977.29,381568.76,591.47,103507.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','318',7617,'9','1',635528.47,639754.99,4226.52,739641.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','318',7618,'10','1',184171.92,184171.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','318',7619,'11','1',827713.21,827713.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','318',7620,'12','1',208345.34,208345.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','318',7621,'13','1',340815.44,343288.54,2473.10,432792.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','318',7622,'14','1',112017.90,112224.02,206.12,36071.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','318',7623,'15','1',346267.59,349820.01,3552.42,621673.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','318',7624,'16','1',93963.17,93963.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','318',7625,'17','1',92874.74,93521.55,646.81,113191.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','318',7626,'18','1',449518.97,451502.68,1983.71,347149.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','318',7627,'19','1',95790.72,96033.69,242.97,42519.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','318',7628,'20','1',449436.28,450357.71,921.43,161250.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','318',7629,'21','2',267957.52,268823.90,866.38,693104.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','318',7630,'22','2',144376.45,144590.34,213.89,171112.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','318',7631,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','318',7632,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','319',7633,'1','1',1062608.19,1064681.57,2073.38,362841.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','319',7634,'2','1',460545.71,462720.95,2175.24,380667.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','319',7635,'3','1',784854.93,787514.22,2659.29,465375.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','319',7636,'4','1',334637.37,335165.30,527.93,92387.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','319',7637,'5','1',1030007.73,1033502.63,3494.90,611607.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','319',7638,'6','1',213276.19,213276.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','319',7639,'7','1',816743.30,819537.25,2793.95,488941.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','319',7640,'8','1',381568.76,381568.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','319',7641,'9','1',639754.99,642714.45,2959.46,517905.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','319',7642,'10','1',184171.92,184171.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','319',7643,'11','1',827713.21,829010.03,1296.82,226943.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','319',7644,'12','1',208345.34,208345.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','319',7645,'13','1',343288.54,344745.14,1456.60,254905.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','319',7646,'14','1',112224.02,112515.25,291.23,50965.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','319',7647,'15','1',349820.01,351903.80,2083.79,364663.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','319',7648,'16','1',93963.17,93963.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','319',7649,'17','1',93521.55,93521.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','319',7650,'18','1',451502.68,453494.88,1992.20,348635.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','319',7651,'19','1',96033.69,96033.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','319',7652,'20','1',450357.71,452520.45,2162.74,378479.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','319',7653,'21','2',268823.90,269654.46,830.56,664448.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','319',7654,'22','2',144590.34,144590.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','319',7655,'23','2',114782.83,114782.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','319',7656,'24','2',64373.98,64373.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','320',7657,'1','1',1064681.57,1065844.96,1163.39,203593.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','320',7658,'2','1',462720.95,462720.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','320',7659,'3','1',787514.22,788847.47,1333.25,233318.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','320',7660,'4','1',335165.30,335165.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','320',7661,'5','1',1033502.63,1033796.05,293.42,51348.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','320',7662,'6','1',213276.19,213276.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','320',7663,'7','1',819537.25,822435.84,2898.59,507253.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','320',7664,'8','1',381568.76,382487.87,919.11,160844.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','320',7665,'9','1',642714.45,645300.98,2586.53,452642.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','320',7666,'10','1',184171.92,184171.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','320',7667,'11','1',829010.03,831251.29,2241.26,392220.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','320',7668,'12','1',208345.34,209318.21,972.87,170252.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','320',7669,'13','1',344745.14,347804.61,3059.47,535407.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','320',7670,'14','1',112515.25,113011.82,496.57,86899.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','320',7671,'15','1',351903.80,355410.78,3506.98,613721.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','320',7672,'16','1',93963.17,94158.89,195.72,34251.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','320',7673,'17','1',93521.55,94189.75,668.20,116935.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','320',7674,'18','1',453494.88,457205.82,3710.94,649414.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','320',7675,'19','1',96033.69,97905.75,1872.06,327610.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','320',7676,'20','1',452520.45,454634.74,2114.29,370000.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','320',7677,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','320',7678,'22','2',144590.34,145445.50,855.16,684128.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','320',7679,'23','2',114782.83,115155.91,373.08,298464.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','320',7680,'24','2',64373.98,65701.35,1295.31,1036248.00,0.00,0.00,32.06,0.00,0.00),('1','248','1','321',7681,'1','1',1065844.96,1065844.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','321',7682,'2','1',462720.95,462720.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','321',7683,'3','1',788847.47,788847.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','321',7684,'4','1',335165.30,335165.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','321',7685,'5','1',1033796.05,1033796.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','321',7686,'6','1',213276.19,213276.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','321',7687,'7','1',822435.84,822435.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','321',7688,'8','1',382487.87,382487.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','321',7689,'9','1',645300.98,645300.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','321',7690,'10','1',184171.92,184171.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','321',7691,'11','1',831251.29,831251.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','321',7692,'12','1',209318.21,209318.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','321',7693,'13','1',347804.61,348699.92,895.31,156679.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','321',7694,'14','1',113011.82,114583.57,1571.75,275056.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','321',7695,'15','1',355410.78,356536.31,1125.53,196967.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','321',7696,'16','1',94158.89,95458.78,1299.89,227480.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','321',7697,'17','1',94189.75,95493.10,1303.35,228086.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','321',7698,'18','1',457205.82,458446.36,1240.54,217094.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','321',7699,'19','1',97905.75,99290.53,1384.78,242336.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','321',7700,'20','1',454634.74,455673.22,1038.48,181734.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','321',7701,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','321',7702,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','321',7703,'23','2',115155.91,115488.79,332.88,266304.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','321',7704,'24','2',65701.35,67094.99,1393.64,1114912.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','322',7705,'1','1',1065844.96,1068069.61,2224.65,389313.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','322',7706,'2','1',462720.95,464812.49,2091.54,366019.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','322',7707,'3','1',788847.47,791458.05,2610.58,456851.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','322',7708,'4','1',335165.30,335229.86,64.56,11298.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','322',7709,'5','1',1033796.05,1035945.97,2149.92,376236.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','322',7710,'6','1',213276.19,214575.44,1299.25,227368.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','322',7711,'7','1',822435.84,825306.93,2871.09,502440.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','322',7712,'8','1',382487.87,382487.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','322',7713,'9','1',645300.98,647424.65,2123.67,371642.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','322',7714,'10','1',184171.92,184512.99,341.07,59687.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','322',7715,'11','1',831251.29,833640.13,2388.84,418047.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','322',7716,'12','1',209318.21,209864.01,545.80,95515.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','322',7717,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','322',7718,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','322',7719,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','322',7720,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','322',7721,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','322',7722,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','322',7723,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','322',7724,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','322',7725,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','322',7726,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','322',7727,'23','2',115488.79,116214.36,725.57,580456.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','322',7728,'24','2',67094.99,68561.87,1466.88,1173504.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','323',7729,'1','1',1068069.61,1073106.67,5037.06,881485.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','323',7730,'2','1',464812.49,469542.14,4729.65,827688.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','323',7731,'3','1',791458.05,795548.48,4090.43,715825.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','323',7732,'4','1',335229.86,339408.01,4178.15,731176.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','323',7733,'5','1',1035945.97,1040158.67,4212.70,737222.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','323',7734,'6','1',214575.44,218754.31,4178.87,731302.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','323',7735,'7','1',825306.93,827060.99,1754.06,306960.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','323',7736,'8','1',382487.87,382808.43,320.56,56098.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','323',7737,'9','1',647424.65,648304.34,879.69,153945.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','323',7738,'10','1',184512.99,185057.29,544.30,95252.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','323',7739,'11','1',833640.13,834898.02,1257.89,220130.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','323',7740,'12','1',209864.01,209864.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','323',7741,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','323',7742,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','323',7743,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','323',7744,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','323',7745,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','323',7746,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','323',7747,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','323',7748,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','323',7749,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','323',7750,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','323',7751,'23','2',116214.36,116214.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','323',7752,'24','2',68561.87,69757.04,1195.17,956136.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','324',7753,'1','1',1073106.67,1076847.44,3740.77,654634.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','324',7754,'2','1',469542.14,469542.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','324',7755,'3','1',795548.48,798587.39,3038.91,531809.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','324',7756,'4','1',339408.01,341549.88,2141.87,374827.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','324',7757,'5','1',1040158.67,1043608.52,3449.85,603723.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','324',7758,'6','1',218754.31,219692.88,938.57,164249.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','324',7759,'7','1',827060.99,830270.96,3209.97,561744.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','324',7760,'8','1',382808.43,383620.44,812.01,142101.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','324',7761,'9','1',648304.34,651858.74,3554.40,622020.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','324',7762,'10','1',185057.29,185057.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','324',7763,'11','1',834898.02,838158.41,3260.39,570568.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','324',7764,'12','1',209864.01,210370.73,506.72,88676.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','324',7765,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','324',7766,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','324',7767,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','324',7768,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','324',7769,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','324',7770,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','324',7771,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','324',7772,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','324',7773,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','324',7774,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','324',7775,'23','2',116214.36,116214.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','324',7776,'24','2',69757.04,71655.72,1898.68,1518944.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','325',7777,'1','1',1076847.44,1076847.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','325',7778,'2','1',469542.14,469542.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','325',7779,'3','1',798587.39,798587.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','325',7780,'4','1',341549.88,341549.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','325',7781,'5','1',1043608.52,1043608.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','325',7782,'6','1',219692.88,219692.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','325',7783,'7','1',830270.96,830270.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','325',7784,'8','1',383620.44,383620.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','325',7785,'9','1',651858.74,651858.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','325',7786,'10','1',185057.29,185057.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','325',7787,'11','1',838158.41,838158.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','325',7788,'12','1',210370.73,210370.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','325',7789,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','325',7790,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','325',7791,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','325',7792,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','325',7793,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','325',7794,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','325',7795,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','325',7796,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','325',7797,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','325',7798,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','325',7799,'23','2',116214.36,117189.58,975.22,780176.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','325',7800,'24','2',71655.72,71655.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','326',7801,'1','1',1076847.44,1076847.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','326',7802,'2','1',469542.14,469542.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','326',7803,'3','1',798587.39,798587.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','326',7804,'4','1',341549.88,341549.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','326',7805,'5','1',1043608.52,1043608.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','326',7806,'6','1',219692.88,219692.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','326',7807,'7','1',830270.96,830270.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','326',7808,'8','1',383620.44,383620.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','326',7809,'9','1',651858.74,651858.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','326',7810,'10','1',185057.29,185057.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','326',7811,'11','1',838158.41,838158.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','326',7812,'12','1',210370.73,210370.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','326',7813,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','326',7814,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','326',7815,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','326',7816,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','326',7817,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','326',7818,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','326',7819,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','326',7820,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','326',7821,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','326',7822,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','326',7823,'23','2',117189.58,118282.83,1093.25,890998.75,0.00,0.00,0.00,0.00,0.00),('1','248','5','326',7824,'24','2',71655.72,71655.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','327',7825,'1','1',1076847.44,1077721.61,874.17,152979.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','327',7826,'2','1',469542.14,469542.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','327',7827,'3','1',798587.39,798587.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','327',7828,'4','1',341549.88,341549.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','327',7829,'5','1',1043608.52,1044413.95,805.43,140950.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','327',7830,'6','1',219692.88,219692.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','327',7831,'7','1',830270.96,832041.29,1770.33,309807.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','327',7832,'8','1',383620.44,383620.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','327',7833,'9','1',651858.74,651858.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','327',7834,'10','1',185057.29,185057.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','327',7835,'11','1',838158.41,839396.71,1238.30,216702.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','327',7836,'12','1',210370.73,211005.73,635.00,111125.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','327',7837,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','327',7838,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','327',7839,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','327',7840,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','327',7841,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','327',7842,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','327',7843,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','327',7844,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','327',7845,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','327',7846,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','327',7847,'23','2',118282.83,118716.24,433.41,353229.15,0.00,0.00,0.00,0.00,0.00),('1','248','5','327',7848,'24','2',71655.72,73827.81,2172.09,1770253.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','328',7849,'1','1',1077721.61,1080677.70,2956.09,517315.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','328',7850,'2','1',469542.14,471335.55,1793.41,313846.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','328',7851,'3','1',798587.39,800826.22,2238.83,391795.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','328',7852,'4','1',341549.88,343713.62,2163.74,378654.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','328',7853,'5','1',1044413.95,1046695.56,2281.61,399281.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','328',7854,'6','1',219692.88,222254.50,2561.62,448283.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','328',7855,'7','1',832041.29,835261.74,3220.45,563578.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','328',7856,'8','1',383620.44,386139.23,2518.79,440788.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','328',7857,'9','1',651858.74,654971.34,3112.60,544705.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','328',7858,'10','1',185057.29,187563.95,2506.66,438665.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','328',7859,'11','1',839396.71,842087.13,2690.42,470823.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','328',7860,'12','1',211005.73,212986.51,1980.78,346636.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','328',7861,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','328',7862,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','328',7863,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','328',7864,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','328',7865,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','328',7866,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','328',7867,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','328',7868,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','328',7869,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','328',7870,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','328',7871,'23','2',118716.24,119216.24,500.00,407500.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','328',7872,'24','2',73827.81,74513.82,686.01,559098.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','329',7873,'1','1',1080677.70,1084272.62,3594.92,629111.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','329',7874,'2','1',471335.55,473962.51,2626.96,459718.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','329',7875,'3','1',800826.22,804530.42,3704.20,648235.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','329',7876,'4','1',343713.62,345980.54,2266.92,396711.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','329',7877,'5','1',1046695.56,1049767.28,3071.72,537551.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','329',7878,'6','1',222254.50,223258.48,1003.98,175696.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','329',7879,'7','1',835261.74,838987.40,3725.66,651990.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','329',7880,'8','1',386139.23,388712.08,2572.85,450248.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','329',7881,'9','1',654971.34,658475.35,3504.01,613201.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','329',7882,'10','1',187563.95,189437.81,1816.72,317926.00,0.00,0.00,57.14,0.00,0.00),('1','248','2','329',7883,'11','1',842087.13,845155.95,3023.11,529044.25,0.00,0.00,45.71,0.00,0.00),('1','248','2','329',7884,'12','1',212986.51,213889.77,903.26,158070.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','329',7885,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','329',7886,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','329',7887,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','329',7888,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','329',7889,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','329',7890,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','329',7891,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','329',7892,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','329',7893,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','329',7894,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','329',7895,'23','2',119216.24,119224.22,7.98,6503.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','329',7896,'24','2',74513.82,75502.71,988.89,805945.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','330',7897,'1','1',1084272.62,1087018.22,2745.60,480480.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','330',7898,'2','1',473962.51,476247.72,2285.21,399911.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','330',7899,'3','1',804530.42,808637.78,4107.36,718788.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','330',7900,'4','1',345980.54,345980.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','330',7901,'5','1',1049767.28,1053018.54,3251.26,568970.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','330',7902,'6','1',223258.48,223258.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','330',7903,'7','1',838987.40,841915.79,2928.39,512468.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','330',7904,'8','1',388712.08,390992.19,2280.11,399019.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','330',7905,'9','1',658475.35,661654.73,3179.38,556391.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','330',7906,'10','1',189437.81,189437.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','330',7907,'11','1',845155.95,847986.17,2830.22,495288.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','330',7908,'12','1',213889.77,213889.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','330',7909,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','330',7910,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','330',7911,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','330',7912,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','330',7913,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','330',7914,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','330',7915,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','330',7916,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','330',7917,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','330',7918,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','330',7919,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','330',7920,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','331',7921,'1','1',1087018.22,1088446.23,1428.01,249901.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','331',7922,'2','1',476247.72,476296.58,48.86,8550.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','331',7923,'3','1',808637.78,809440.85,803.07,140537.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','331',7924,'4','1',345980.54,346731.15,750.61,131356.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','331',7925,'5','1',1053018.54,1053966.89,948.35,165961.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','331',7926,'6','1',223258.48,224148.41,889.93,155737.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','331',7927,'7','1',841915.79,842819.06,903.27,158072.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','331',7928,'8','1',390992.19,391866.46,874.27,152997.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','331',7929,'9','1',661654.73,662639.64,984.91,172359.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','331',7930,'10','1',189437.81,189977.22,539.41,94396.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','331',7931,'11','1',847986.17,848973.30,987.13,172747.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','331',7932,'12','1',213889.77,214288.96,399.19,69858.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','331',7933,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','331',7934,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','331',7935,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','331',7936,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','331',7937,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','331',7938,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','331',7939,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','331',7940,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','331',7941,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','331',7942,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','331',7943,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','331',7944,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','332',7945,'1','1',1088446.23,1092191.47,3745.24,655417.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','332',7946,'2','1',476296.58,478373.86,2077.28,363524.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','332',7947,'3','1',809440.85,812240.61,2799.76,489958.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','332',7948,'4','1',346731.15,349773.28,3042.13,532372.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','332',7949,'5','1',1053966.89,1057653.62,3686.73,645177.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','332',7950,'6','1',224148.41,225733.78,1585.37,277439.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','332',7951,'7','1',842819.06,846866.63,4047.57,708324.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','332',7952,'8','1',391866.46,394046.83,2180.37,381564.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','332',7953,'9','1',662639.64,666598.31,3958.67,692767.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','332',7954,'10','1',189977.22,189977.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','332',7955,'11','1',848973.30,852048.48,3075.18,538156.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','332',7956,'12','1',214288.96,217374.93,3085.97,540044.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','332',7957,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','332',7958,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','332',7959,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','332',7960,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','332',7961,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','332',7962,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','332',7963,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','332',7964,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','332',7965,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','332',7966,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','332',7967,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','332',7968,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','333',7969,'1','1',1092191.47,1094830.14,2638.67,461767.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','333',7970,'2','1',478373.86,479738.14,1364.28,238749.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','333',7971,'3','1',812240.61,814135.85,1895.24,331667.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','333',7972,'4','1',349773.28,351136.64,1363.36,238588.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','333',7973,'5','1',1057653.62,1059723.96,2070.34,362309.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','333',7974,'6','1',225733.78,226532.05,798.27,139697.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','333',7975,'7','1',846866.63,849025.72,2159.09,377840.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','333',7976,'8','1',394046.83,395550.55,1503.72,263151.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','333',7977,'9','1',666598.31,668941.11,2342.80,409990.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','333',7978,'10','1',189977.22,190696.81,719.59,125928.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','333',7979,'11','1',852048.48,854040.56,1992.08,348614.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','333',7980,'12','1',217374.93,218225.47,850.54,148844.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','333',7981,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','333',7982,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','333',7983,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','333',7984,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','333',7985,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','333',7986,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','333',7987,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','333',7988,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','333',7989,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','333',7990,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','333',7991,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','333',7992,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','334',7993,'1','1',1094830.14,1096467.08,1636.94,286464.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','334',7994,'2','1',479738.14,480771.60,1033.46,180855.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','334',7995,'3','1',814135.85,816129.94,1994.09,348965.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','334',7996,'4','1',351136.64,351825.46,688.82,120543.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','334',7997,'5','1',1059723.96,1061753.92,2029.96,355243.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','334',7998,'6','1',226532.05,227884.30,1352.25,236643.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','334',7999,'7','1',849025.72,850822.79,1797.07,314487.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','334',8000,'8','1',395550.55,397178.62,1628.07,284912.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','334',8001,'9','1',668941.11,670279.98,1338.87,234302.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','334',8002,'10','1',190696.81,192063.80,1366.99,239223.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','334',8003,'11','1',854040.56,855899.02,1858.46,325230.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','334',8004,'12','1',218225.47,218659.66,434.19,75983.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','334',8005,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','334',8006,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','334',8007,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','334',8008,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','334',8009,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','334',8010,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','334',8011,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','334',8012,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','334',8013,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','334',8014,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','334',8015,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','334',8016,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','335',8017,'1','1',1096467.08,1099129.82,2662.74,465979.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','335',8018,'2','1',480771.60,483575.94,2804.34,490759.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','335',8019,'3','1',816129.94,818582.49,2452.55,429196.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','335',8020,'4','1',351825.46,354473.28,2647.82,463368.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','335',8021,'5','1',1061753.92,1064373.34,2619.42,458398.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','335',8022,'6','1',227884.30,229882.66,1998.36,349713.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','335',8023,'7','1',850822.79,854073.11,3250.32,568806.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','335',8024,'8','1',397178.62,400215.21,3036.59,531403.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','335',8025,'9','1',670279.98,671096.81,816.83,142945.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','335',8026,'10','1',192063.80,194893.64,2829.84,495222.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','335',8027,'11','1',855899.02,859273.99,3374.97,590619.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','335',8028,'12','1',218659.66,219649.33,989.67,173192.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','335',8029,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','335',8030,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','335',8031,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','335',8032,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','335',8033,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','335',8034,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','335',8035,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','335',8036,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','335',8037,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','335',8038,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','335',8039,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','335',8040,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','336',8041,'1','1',1099129.82,1100077.77,947.95,165891.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','336',8042,'2','1',483575.94,484445.17,869.23,152115.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','336',8043,'3','1',818582.49,819561.92,979.43,171400.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','336',8044,'4','1',354473.28,354910.66,437.38,76541.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','336',8045,'5','1',1064373.34,1065119.32,745.98,130546.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','336',8046,'6','1',229882.66,230667.19,784.53,137292.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','336',8047,'7','1',854073.11,855470.18,1397.07,244487.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','336',8048,'8','1',400215.21,401097.53,882.32,154406.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','336',8049,'9','1',671096.81,672497.11,1400.30,245052.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','336',8050,'10','1',194893.64,194930.09,36.45,6378.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','336',8051,'11','1',859273.99,860377.08,1103.09,193040.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','336',8052,'12','1',219649.33,220555.81,906.48,158634.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','336',8053,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','336',8054,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','336',8055,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','336',8056,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','336',8057,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','336',8058,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','336',8059,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','336',8060,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','336',8061,'21','2',269654.46,269654.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','336',8062,'22','2',145445.50,145445.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','336',8063,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','336',8064,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','337',8065,'1','1',1100077.77,1102450.53,2372.76,415233.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','337',8066,'2','1',484445.17,486679.37,2234.20,390985.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','337',8067,'3','1',819561.92,821605.81,2043.89,357680.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','337',8068,'4','1',354910.66,356165.83,1255.17,219654.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','337',8069,'5','1',1065119.32,1067364.23,2199.20,384860.00,0.00,0.00,45.71,0.00,0.00),('1','248','1','337',8070,'6','1',230667.19,232236.05,1568.86,274550.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','337',8071,'7','1',855470.18,858212.74,2742.56,479948.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','337',8072,'8','1',401097.53,403542.23,2444.70,427822.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','337',8073,'9','1',672497.11,674985.53,2488.42,435473.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','337',8074,'10','1',194930.09,197001.20,2071.11,362444.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','337',8075,'11','1',860377.08,862878.52,2501.44,437752.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','337',8076,'12','1',220555.81,222249.58,1693.77,296409.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','337',8077,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','337',8078,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','337',8079,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','337',8080,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','337',8081,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','337',8082,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','337',8083,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','337',8084,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','337',8085,'21','2',269654.46,271214.47,1560.01,1271408.15,0.00,0.00,0.00,0.00,0.00),('1','248','4','337',8086,'22','2',145445.50,146384.32,938.82,765138.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','337',8087,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','337',8088,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','338',8089,'1','1',1102450.53,1102450.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','338',8090,'2','1',486679.37,486679.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','338',8091,'3','1',821605.81,821605.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','338',8092,'4','1',356165.83,356165.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','338',8093,'5','1',1067364.23,1067364.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','338',8094,'6','1',232236.05,232236.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','338',8095,'7','1',858212.74,858212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','338',8096,'8','1',403542.23,403542.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','338',8097,'9','1',674985.53,674985.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','338',8098,'10','1',197001.20,197001.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','338',8099,'11','1',862878.52,862878.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','338',8100,'12','1',222249.58,222249.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','338',8101,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','338',8102,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','338',8103,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','338',8104,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','338',8105,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','338',8106,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','338',8107,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','338',8108,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','338',8109,'21','2',271214.47,272205.62,991.15,807787.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','338',8110,'22','2',146384.32,148676.34,2292.02,1867996.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','338',8111,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','338',8112,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','339',8113,'1','1',1102450.53,1104074.43,1623.90,284182.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','339',8114,'2','1',486679.37,488549.37,1870.00,327250.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','339',8115,'3','1',821605.81,823331.05,1725.24,301917.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','339',8116,'4','1',356165.83,358012.38,1846.55,323146.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','339',8117,'5','1',1067364.23,1071683.28,4319.05,755833.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','339',8118,'6','1',232236.05,235155.82,2919.77,510959.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','339',8119,'7','1',858212.74,858212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','339',8120,'8','1',403542.23,403542.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','339',8121,'9','1',674985.53,674985.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','339',8122,'10','1',197001.20,197001.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','339',8123,'11','1',862878.52,863713.65,835.13,146147.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','339',8124,'12','1',222249.58,222544.25,294.67,51567.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','339',8125,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','339',8126,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','339',8127,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','339',8128,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','339',8129,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','339',8130,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','339',8131,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','339',8132,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','339',8133,'21','2',272205.62,273698.85,1493.23,1216982.45,0.00,0.00,0.00,0.00,0.00),('1','248','4','339',8134,'22','2',148676.34,149875.19,1198.85,977062.75,0.00,0.00,0.00,0.00,0.00),('1','248','5','339',8135,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','339',8136,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','340',8137,'1','1',1104074.43,1104074.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','340',8138,'2','1',488549.37,488549.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','340',8139,'3','1',823331.05,823331.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','340',8140,'4','1',358012.38,358012.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','340',8141,'5','1',1071683.28,1071683.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','340',8142,'6','1',235155.82,235155.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','340',8143,'7','1',858212.74,858212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','340',8144,'8','1',403542.23,403542.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','340',8145,'9','1',674985.53,674985.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','340',8146,'10','1',197001.20,197001.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','340',8147,'11','1',863713.65,863713.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','340',8148,'12','1',222544.25,222544.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','340',8149,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','340',8150,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','340',8151,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','340',8152,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','340',8153,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','340',8154,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','340',8155,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','340',8156,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','340',8157,'21','2',273698.85,274172.63,473.78,386130.70,0.00,0.00,0.00,0.00,0.00),('1','248','4','340',8158,'22','2',149875.19,149885.19,10.00,8150.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','340',8159,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','340',8160,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','341',8161,'1','1',1104074.43,1106280.98,2206.55,386146.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','341',8162,'2','1',488549.37,490961.44,2412.07,422112.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','341',8163,'3','1',823331.05,825557.75,2226.70,389672.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','341',8164,'4','1',358012.38,360299.23,2286.85,400198.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','341',8165,'5','1',1071683.28,1076579.34,4896.06,856810.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','341',8166,'6','1',235155.82,239217.61,4061.79,710813.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','341',8167,'7','1',858212.74,858212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','341',8168,'8','1',403542.23,403542.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','341',8169,'9','1',674985.53,674985.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','341',8170,'10','1',197001.20,197001.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','341',8171,'11','1',863713.65,863713.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','341',8172,'12','1',222544.25,222544.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','341',8173,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','341',8174,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','341',8175,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','341',8176,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','341',8177,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','341',8178,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','341',8179,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','341',8180,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','341',8181,'21','2',274172.63,274208.73,36.10,29602.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','341',8182,'22','2',149885.19,149885.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','341',8183,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','341',8184,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','342',8185,'1','1',1106280.98,1106280.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','342',8186,'2','1',490961.44,490961.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','342',8187,'3','1',825557.75,825557.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','342',8188,'4','1',360299.23,360299.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','342',8189,'5','1',1076579.34,1076579.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','342',8190,'6','1',239217.61,239217.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','342',8191,'7','1',858212.74,858212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','342',8192,'8','1',403542.23,403542.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','342',8193,'9','1',674985.53,674985.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','342',8194,'10','1',197001.20,197001.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','342',8195,'11','1',863713.65,863713.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','342',8196,'12','1',222544.25,222544.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','342',8197,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','342',8198,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','342',8199,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','342',8200,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','342',8201,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','342',8202,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','342',8203,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','342',8204,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','342',8205,'21','2',274208.73,275728.53,1519.80,1246236.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','342',8206,'22','2',149885.19,150913.17,1027.98,842943.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','342',8207,'23','2',119224.22,119224.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','342',8208,'24','2',75502.71,75502.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','343',8209,'1','1',1106280.98,1106280.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','343',8210,'2','1',490961.44,490961.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','343',8211,'3','1',825557.75,825557.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','343',8212,'4','1',360299.23,360299.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','343',8213,'5','1',1076579.34,1077955.14,1375.80,240765.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','343',8214,'6','1',239217.61,240953.56,1735.95,303791.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','343',8215,'7','1',858212.74,858212.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','343',8216,'8','1',403542.23,403542.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','343',8217,'9','1',674985.53,674985.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','343',8218,'10','1',197001.20,197001.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','343',8219,'11','1',863713.65,863713.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','343',8220,'12','1',222544.25,222544.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','343',8221,'13','1',348699.92,348699.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','343',8222,'14','1',114583.57,114583.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','343',8223,'15','1',356536.31,356536.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','343',8224,'16','1',95458.78,95458.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','343',8225,'17','1',95493.10,95493.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','343',8226,'18','1',458446.36,458446.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','343',8227,'19','1',99290.53,99290.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','343',8228,'20','1',455673.22,455673.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','343',8229,'21','2',275728.53,282488.22,6759.69,5542945.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','343',8230,'22','2',150913.17,154974.15,4060.98,3330003.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','343',8231,'23','2',119224.22,121461.63,2237.41,1834676.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','343',8232,'24','2',75502.71,76393.42,890.71,730382.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','344',8233,'1','1',1106280.98,1107412.64,1131.66,198040.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','344',8234,'2','1',490961.44,492491.87,1530.43,267825.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','344',8235,'3','1',825557.75,826115.10,557.35,97536.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','344',8236,'4','1',360299.23,360923.24,624.01,109201.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','344',8237,'5','1',1077955.14,1078719.78,764.64,133812.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','344',8238,'6','1',240953.56,241552.45,598.89,104805.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','344',8239,'7','1',858212.74,860320.41,2107.67,368842.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','344',8240,'8','1',403542.23,405456.02,1913.79,334913.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','344',8241,'9','1',674985.53,676836.55,1851.02,323928.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','344',8242,'10','1',197001.20,198806.08,1804.88,315854.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','344',8243,'11','1',863713.65,865895.66,2182.01,381851.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','344',8244,'12','1',222544.25,224117.28,1573.03,275280.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','344',8245,'13','1',348699.92,352857.91,4157.99,727648.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','344',8246,'14','1',114583.57,118954.14,4370.57,764849.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','344',8247,'15','1',356536.31,360977.06,4440.75,777131.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','344',8248,'16','1',95458.78,99538.94,4080.16,714028.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','344',8249,'17','1',95493.10,99713.39,4220.29,738550.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','344',8250,'18','1',458446.36,462444.52,3998.16,699678.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','344',8251,'19','1',99290.53,102497.55,3207.02,561228.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','344',8252,'20','1',455673.22,459895.74,4222.52,738941.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','344',8253,'21','2',282488.22,282488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','344',8254,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','344',8255,'23','2',121461.63,122487.55,1021.77,837851.40,0.00,0.00,4.15,0.00,0.00),('1','248','5','344',8256,'24','2',76393.42,79414.71,3021.29,2477457.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','345',8257,'1','1',1107412.64,1107412.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','345',8258,'2','1',492491.87,492491.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','345',8259,'3','1',826115.10,826115.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','345',8260,'4','1',360923.24,360923.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','345',8261,'5','1',1078719.78,1078719.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','345',8262,'6','1',241552.45,241552.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','345',8263,'7','1',860320.41,860320.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','345',8264,'8','1',405456.02,405456.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','345',8265,'9','1',676836.55,676836.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','345',8266,'10','1',198806.08,198806.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','345',8267,'11','1',865895.66,865895.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','345',8268,'12','1',224117.28,224117.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','345',8269,'13','1',352857.91,352857.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','345',8270,'14','1',118954.14,118954.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','345',8271,'15','1',360977.06,360977.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','345',8272,'16','1',99538.94,99538.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','345',8273,'17','1',99713.39,99713.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','345',8274,'18','1',462444.52,462444.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','345',8275,'19','1',102497.55,102497.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','345',8276,'20','1',459895.74,459895.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','345',8277,'21','2',282488.22,282488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','345',8278,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','345',8279,'23','2',122487.55,122487.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','345',8280,'24','2',79414.71,79587.87,173.16,141991.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','346',8281,'1','1',1107412.64,1109084.87,1672.23,292640.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','346',8282,'2','1',492491.87,494096.43,1604.56,280798.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','346',8283,'3','1',826115.10,828366.52,2251.42,393998.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','346',8284,'4','1',360923.24,362895.44,1972.20,345135.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','346',8285,'5','1',1078719.78,1080618.95,1899.17,332354.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','346',8286,'6','1',241552.45,243635.90,2083.45,364603.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','346',8287,'7','1',860320.41,863698.51,3378.10,591167.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','346',8288,'8','1',405456.02,408369.37,2913.35,509836.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','346',8289,'9','1',676836.55,679962.19,3125.64,546987.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','346',8290,'10','1',198806.08,201523.71,2717.63,475585.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','346',8291,'11','1',865895.66,867799.45,1903.79,333163.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','346',8292,'12','1',224117.28,226933.52,2816.24,492842.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','346',8293,'13','1',352857.91,354326.79,1468.88,257054.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','346',8294,'14','1',118954.14,121459.94,2505.80,438515.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','346',8295,'15','1',360977.06,363913.44,2936.38,513866.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','346',8296,'16','1',99538.94,100945.50,1406.56,246148.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','346',8297,'17','1',99713.39,102064.07,2350.68,411369.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','346',8298,'18','1',462444.52,465009.25,2564.73,448827.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','346',8299,'19','1',102497.55,104641.88,2144.33,375257.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','346',8300,'20','1',459895.74,461458.21,1562.47,273432.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','346',8301,'21','2',282488.22,282488.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','346',8302,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','346',8303,'23','2',122487.55,122520.70,33.15,27514.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','346',8304,'24','2',79587.87,80960.80,1372.93,1139531.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','347',8305,'1','1',1109084.87,1111756.47,2671.60,467530.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','347',8306,'2','1',494096.43,496906.65,2810.22,491788.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','347',8307,'3','1',828366.52,830618.39,2251.87,394077.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','347',8308,'4','1',362895.44,364391.50,1496.06,261810.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','347',8309,'5','1',1080618.95,1084138.79,3519.84,615972.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','347',8310,'6','1',243635.90,244734.82,1098.92,192311.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','347',8311,'7','1',863698.51,866215.20,2516.69,440420.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','347',8312,'8','1',408369.37,410604.28,2234.91,391109.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','347',8313,'9','1',679962.19,682734.80,2772.61,485206.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','347',8314,'10','1',201523.71,203941.26,2417.55,423071.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','347',8315,'11','1',867799.45,870626.54,2827.09,494740.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','347',8316,'12','1',226933.52,227986.38,1052.86,184250.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','347',8317,'13','1',354326.79,354326.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','347',8318,'14','1',121459.94,121459.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','347',8319,'15','1',363913.44,363913.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','347',8320,'16','1',100945.50,100945.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','347',8321,'17','1',102064.07,102064.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','347',8322,'18','1',465009.25,465009.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','347',8323,'19','1',104641.88,104641.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','347',8324,'20','1',461458.21,461458.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','347',8325,'21','2',282488.22,282490.92,2.70,2241.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','347',8326,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','347',8327,'23','2',122520.70,122522.99,2.29,1900.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','347',8328,'24','2',80960.80,82807.92,1847.12,1533109.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','348',8329,'1','1',1111756.47,1114270.82,2514.35,440011.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','348',8330,'2','1',496906.65,499397.82,2491.17,435954.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','348',8331,'3','1',830618.39,833196.30,2577.91,451134.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','348',8332,'4','1',364391.50,366937.06,2545.56,445473.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','348',8333,'5','1',1084138.79,1087621.44,3482.65,609463.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','348',8334,'6','1',244734.82,247608.78,2873.96,502943.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','348',8335,'7','1',866215.20,867074.30,859.10,150342.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','348',8336,'8','1',410604.28,411043.67,439.39,76893.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','348',8337,'9','1',682734.80,683442.66,707.86,123875.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','348',8338,'10','1',203941.26,204543.55,602.29,105400.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','348',8339,'11','1',870626.54,871350.89,724.35,126761.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','348',8340,'12','1',227986.38,228207.56,221.18,38706.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','348',8341,'13','1',354326.79,354326.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','348',8342,'14','1',121459.94,121459.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','348',8343,'15','1',363913.44,363913.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','348',8344,'16','1',100945.50,100945.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','348',8345,'17','1',102064.07,102064.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','348',8346,'18','1',465009.25,465009.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','348',8347,'19','1',104641.88,104641.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','348',8348,'20','1',461458.21,461458.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','348',8349,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','348',8350,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','348',8351,'23','2',122522.99,122522.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','348',8352,'24','2',82807.92,84144.02,1336.10,1108963.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','349',8353,'1','1',1114270.82,1115745.88,1475.06,258135.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','349',8354,'2','1',499397.82,500969.03,1571.21,274961.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','349',8355,'3','1',833196.30,834754.98,1558.68,272769.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','349',8356,'4','1',366937.06,368486.00,1548.94,271064.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','349',8357,'5','1',1087621.44,1089541.76,1920.32,336056.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','349',8358,'6','1',247608.78,248979.48,1370.70,239872.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','349',8359,'7','1',867074.30,868562.36,1488.06,260410.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','349',8360,'8','1',411043.67,412388.52,1344.85,235348.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','349',8361,'9','1',683442.66,685051.03,1608.37,281464.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','349',8362,'10','1',204543.55,205497.78,954.23,166990.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','349',8363,'11','1',871350.89,872402.76,1051.87,184077.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','349',8364,'12','1',228207.56,229447.02,1239.46,216905.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','349',8365,'13','1',354326.79,354326.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','349',8366,'14','1',121459.94,122818.10,1358.16,237678.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','349',8367,'15','1',363913.44,364860.33,946.89,165705.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','349',8368,'16','1',100945.50,102407.56,1462.06,255860.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','349',8369,'17','1',102064.07,102979.59,915.52,160216.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','349',8370,'18','1',465009.25,465898.81,889.56,155673.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','349',8371,'19','1',104641.88,104641.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','349',8372,'20','1',461458.21,463372.92,1914.71,335074.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','349',8373,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','349',8374,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','349',8375,'23','2',122522.99,122552.16,29.17,24211.10,0.00,0.00,0.00,0.00,0.00),('1','248','5','349',8376,'24','2',84144.02,85527.18,1383.16,1148022.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','350',8377,'1','1',1115745.88,1116173.93,428.05,74908.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','350',8378,'2','1',500969.03,501379.70,410.67,71867.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','350',8379,'3','1',834754.98,835162.36,407.38,71291.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','350',8380,'4','1',368486.00,368660.22,174.22,30488.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','350',8381,'5','1',1089541.76,1090428.99,887.23,155265.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','350',8382,'6','1',248979.48,249597.75,618.27,108197.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','350',8383,'7','1',868562.36,869097.24,534.88,93604.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','350',8384,'8','1',412388.52,412987.93,599.41,104896.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','350',8385,'9','1',685051.03,685855.59,804.56,140798.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','350',8386,'10','1',205497.78,206287.90,790.12,138271.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','350',8387,'11','1',872402.76,873289.50,886.74,155179.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','350',8388,'12','1',229447.02,230273.02,826.00,144550.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','350',8389,'13','1',354326.79,354874.51,547.72,95851.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','350',8390,'14','1',122818.10,123055.73,237.63,41585.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','350',8391,'15','1',364860.33,365503.96,643.63,112635.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','350',8392,'16','1',102407.56,102469.51,61.95,10841.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','350',8393,'17','1',102979.59,103510.15,530.56,92848.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','350',8394,'18','1',465898.81,466378.31,479.50,83912.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','350',8395,'19','1',104641.88,105096.42,454.54,79544.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','350',8396,'20','1',463372.92,463854.90,481.98,84346.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','350',8397,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','350',8398,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','350',8399,'23','2',122552.16,122552.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','350',8400,'24','2',85527.18,86528.17,1000.99,830821.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','351',8401,'1','1',1116173.93,1117365.02,1191.09,208440.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','351',8402,'2','1',501379.70,502842.18,1462.48,255934.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','351',8403,'3','1',835162.36,836340.63,1168.27,204447.25,0.00,0.00,10.00,0.00,0.00),('1','248','1','351',8404,'4','1',368660.22,370045.38,1375.16,240653.00,0.00,0.00,10.00,0.00,0.00),('1','248','1','351',8405,'5','1',1090428.99,1092565.24,2126.25,372093.75,0.00,0.00,10.00,0.00,0.00),('1','248','1','351',8406,'6','1',249597.75,250602.97,995.22,174163.50,0.00,0.00,10.00,0.00,0.00),('1','248','2','351',8407,'7','1',869097.24,869097.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','351',8408,'8','1',412987.93,412987.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','351',8409,'9','1',685855.59,685855.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','351',8410,'10','1',206287.90,206287.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','351',8411,'11','1',873289.50,873289.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','351',8412,'12','1',230273.02,230273.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','351',8413,'13','1',354874.51,356639.74,1765.23,308915.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','351',8414,'14','1',123055.73,124379.44,1323.71,231649.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','351',8415,'15','1',365503.96,367602.24,2098.28,367199.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','351',8416,'16','1',102469.51,104302.34,1832.83,320745.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','351',8417,'17','1',103510.15,105030.53,1520.38,266066.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','351',8418,'18','1',466378.31,467848.08,1469.77,257209.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','351',8419,'19','1',105096.42,106350.99,1254.57,219549.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','351',8420,'20','1',463854.90,465359.93,1505.03,263380.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','351',8421,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','351',8422,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','351',8423,'23','2',122552.16,122552.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','351',8424,'24','2',86528.17,88180.64,1652.47,1371550.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','352',8425,'1','1',1117365.02,1119757.42,2392.40,418670.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','352',8426,'2','1',502842.18,505136.60,2294.42,401523.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','352',8427,'3','1',836340.63,838364.95,2024.32,354256.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','352',8428,'4','1',370045.38,372399.46,2354.08,411964.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','352',8429,'5','1',1092565.24,1094786.00,2220.76,388633.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','352',8430,'6','1',250602.97,252696.30,2093.33,366332.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','352',8431,'7','1',869097.24,869097.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','352',8432,'8','1',412987.93,412987.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','352',8433,'9','1',685855.59,685855.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','352',8434,'10','1',206287.90,206287.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','352',8435,'11','1',873289.50,873289.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','352',8436,'12','1',230273.02,230273.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','352',8437,'13','1',356639.74,358142.04,1502.30,262902.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','352',8438,'14','1',124379.44,125875.38,1495.94,261789.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','352',8439,'15','1',367602.24,369084.98,1482.74,259479.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','352',8440,'16','1',104302.34,105695.48,1393.14,243799.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','352',8441,'17','1',105030.53,105987.79,957.26,167520.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','352',8442,'18','1',467848.08,469304.12,1456.04,254807.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','352',8443,'19','1',106350.99,107555.29,1204.30,210752.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','352',8444,'20','1',465359.93,466840.85,1480.92,259161.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','352',8445,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','352',8446,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','352',8447,'23','2',122552.16,122552.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','352',8448,'24','2',88180.64,88728.43,547.79,454665.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','353',8449,'1','1',1119757.42,1121953.92,2196.50,384387.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','353',8450,'2','1',505136.60,506853.28,1716.68,300419.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','353',8451,'3','1',838364.95,840074.48,1709.53,299167.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','353',8452,'4','1',372399.46,374285.05,1885.59,329978.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','353',8453,'5','1',1094786.00,1097042.30,2256.30,394852.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','353',8454,'6','1',252696.30,254597.68,1901.38,332741.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','353',8455,'7','1',869097.24,870974.32,1867.08,326739.00,0.00,0.00,10.00,0.00,0.00),('1','248','2','353',8456,'8','1',412987.93,415205.69,2207.76,386358.00,0.00,0.00,10.00,0.00,0.00),('1','248','2','353',8457,'9','1',685855.59,687620.29,1764.70,308822.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','353',8458,'10','1',206287.90,207934.00,1646.10,288067.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','353',8459,'11','1',873289.50,875766.83,2477.33,433532.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','353',8460,'12','1',230273.02,231590.75,1317.73,230602.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','353',8461,'13','1',358142.04,358142.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','353',8462,'14','1',125875.38,125875.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','353',8463,'15','1',369084.98,369084.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','353',8464,'16','1',105695.48,105695.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','353',8465,'17','1',105987.79,105987.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','353',8466,'18','1',469304.12,469304.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','353',8467,'19','1',107555.29,107555.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','353',8468,'20','1',466840.85,466840.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','353',8469,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','353',8470,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','353',8471,'23','2',122552.16,122552.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','353',8472,'24','2',88728.43,89994.16,1265.73,1050555.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','354',8473,'1','1',1121953.92,1123041.06,1087.14,190249.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','354',8474,'2','1',506853.28,507809.17,955.89,167280.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','354',8475,'3','1',840074.48,841085.93,1011.45,177003.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','354',8476,'4','1',374285.05,374542.28,257.23,45015.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','354',8477,'5','1',1097042.30,1098422.27,1379.97,241494.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','354',8478,'6','1',254597.68,255618.14,1020.46,178580.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','354',8479,'7','1',870974.32,871812.32,838.00,146650.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','354',8480,'8','1',415205.69,415850.79,645.10,112892.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','354',8481,'9','1',687620.29,688476.30,856.01,149801.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','354',8482,'10','1',207934.00,208648.05,714.05,124958.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','354',8483,'11','1',875766.83,876275.97,509.14,89099.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','354',8484,'12','1',231590.75,232030.92,440.17,77029.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','354',8485,'13','1',358142.04,358142.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','354',8486,'14','1',125875.38,125875.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','354',8487,'15','1',369084.98,369084.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','354',8488,'16','1',105695.48,105695.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','354',8489,'17','1',105987.79,105987.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','354',8490,'18','1',469304.12,469304.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','354',8491,'19','1',107555.29,107555.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','354',8492,'20','1',466840.85,466840.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','354',8493,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','354',8494,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','354',8495,'23','2',122552.16,122552.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','354',8496,'24','2',89994.16,90807.79,813.63,675312.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','355',8497,'1','1',1123041.06,1125767.00,2725.94,477039.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','355',8498,'2','1',507809.17,510587.03,2777.86,486125.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','355',8499,'3','1',841085.93,843320.25,2234.32,391006.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','355',8500,'4','1',374542.28,377221.60,2679.32,468881.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','355',8501,'5','1',1098422.27,1100823.44,2401.17,420204.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','355',8502,'6','1',255618.14,258269.57,2651.43,464000.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','355',8503,'7','1',871812.32,871812.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','355',8504,'8','1',415850.79,415850.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','355',8505,'9','1',688476.30,688476.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','355',8506,'10','1',208648.05,208648.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','355',8507,'11','1',876275.97,876275.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','355',8508,'12','1',232030.92,232030.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','355',8509,'13','1',358142.04,358142.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','355',8510,'14','1',125875.38,125875.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','355',8511,'15','1',369084.98,369084.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','355',8512,'16','1',105695.48,105695.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','355',8513,'17','1',105987.79,105987.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','355',8514,'18','1',469304.12,469304.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','355',8515,'19','1',107555.29,107555.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','355',8516,'20','1',466840.85,466840.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','355',8517,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','355',8518,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','355',8519,'23','2',122552.16,122708.16,156.00,129480.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','355',8520,'24','2',90807.79,91463.30,655.51,544073.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','356',8521,'1','1',1125767.00,1127977.64,2210.64,386862.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','356',8522,'2','1',510587.03,513246.08,2659.05,465333.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','356',8523,'3','1',843320.25,845490.81,2170.56,379848.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','356',8524,'4','1',377221.60,379364.58,2142.98,375021.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','356',8525,'5','1',1100823.44,1104001.85,3178.41,556221.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','356',8526,'6','1',258269.57,261359.99,3090.42,540823.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','356',8527,'7','1',871812.32,873465.28,1652.96,289268.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','356',8528,'8','1',415850.79,417649.15,1798.36,314713.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','356',8529,'9','1',688476.30,690201.60,1725.30,301927.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','356',8530,'10','1',208648.05,210274.25,1626.20,284585.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','356',8531,'11','1',876275.97,878793.78,2517.81,440616.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','356',8532,'12','1',232030.92,233545.13,1514.21,264986.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','356',8533,'13','1',358142.04,358142.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','356',8534,'14','1',125875.38,125875.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','356',8535,'15','1',369084.98,369084.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','356',8536,'16','1',105695.48,105695.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','356',8537,'17','1',105987.79,105987.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','356',8538,'18','1',469304.12,469304.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','356',8539,'19','1',107555.29,107555.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','356',8540,'20','1',466840.85,466840.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','356',8541,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','356',8542,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','356',8543,'23','2',122708.16,123398.16,690.00,572700.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','356',8544,'24','2',91463.30,94047.13,2583.83,2144578.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','357',8545,'1','1',1127977.64,1130170.97,2193.33,383832.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','357',8546,'2','1',513246.08,515195.72,1949.64,341187.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','357',8547,'3','1',845490.81,847502.12,2011.31,351979.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','357',8548,'4','1',379364.58,381200.75,1836.17,321329.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','357',8549,'5','1',1104001.85,1107064.75,3062.90,536007.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','357',8550,'6','1',261359.99,264066.36,2706.37,473614.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','357',8551,'7','1',873465.28,874822.59,1357.31,237529.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','357',8552,'8','1',417649.15,419165.62,1516.47,265382.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','357',8553,'9','1',690201.60,691938.03,1736.43,303875.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','357',8554,'10','1',210274.25,211579.76,1305.51,228464.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','357',8555,'11','1',878793.78,881933.14,3093.65,541388.75,0.00,0.00,45.71,0.00,0.00),('1','248','2','357',8556,'12','1',233545.13,235776.83,2231.70,390547.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','357',8557,'13','1',358142.04,358142.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','357',8558,'14','1',125875.38,125875.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','357',8559,'15','1',369084.98,369084.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','357',8560,'16','1',105695.48,105695.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','357',8561,'17','1',105987.79,105987.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','357',8562,'18','1',469304.12,469304.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','357',8563,'19','1',107555.29,107555.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','357',8564,'20','1',466840.85,466840.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','357',8565,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','357',8566,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','357',8567,'23','2',123398.16,123398.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','357',8568,'24','2',94047.13,94978.43,931.30,772979.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','358',8569,'1','1',1130170.97,1130170.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','358',8570,'2','1',515195.72,515195.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','358',8571,'3','1',847502.12,847502.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','358',8572,'4','1',381200.75,381200.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','358',8573,'5','1',1107064.75,1107861.25,796.50,139387.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','358',8574,'6','1',264066.36,264893.72,827.36,144788.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','358',8575,'7','1',874822.59,874822.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','358',8576,'8','1',419165.62,419165.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','358',8577,'9','1',691938.03,691938.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','358',8578,'10','1',211579.76,211579.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','358',8579,'11','1',881933.14,881933.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','358',8580,'12','1',235776.83,235776.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','358',8581,'13','1',358142.04,358142.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','358',8582,'14','1',125875.38,125875.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','358',8583,'15','1',369084.98,369084.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','358',8584,'16','1',105695.48,105695.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','358',8585,'17','1',105987.79,105987.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','358',8586,'18','1',469304.12,469441.69,137.57,24074.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','358',8587,'19','1',107555.29,107555.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','358',8588,'20','1',466840.85,466840.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','358',8589,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','358',8590,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','358',8591,'23','2',123398.16,123754.54,356.38,295795.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','358',8592,'24','2',94978.43,96918.30,1939.87,1610092.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','359',8593,'1','1',1130170.97,1132578.01,2407.04,421232.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','359',8594,'2','1',515195.72,517724.12,2528.40,442470.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','359',8595,'3','1',847502.12,849608.17,2106.05,368558.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','359',8596,'4','1',381200.75,382886.50,1685.75,295006.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','359',8597,'5','1',1107861.25,1110353.79,2492.54,436194.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','359',8598,'6','1',264893.72,266262.49,1368.77,239534.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','359',8599,'7','1',874822.59,876822.16,1999.57,349924.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','359',8600,'8','1',419165.62,421450.25,2284.63,399810.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','359',8601,'9','1',691938.03,693764.50,1826.47,319632.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','359',8602,'10','1',211579.76,213647.59,2067.83,361870.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','359',8603,'11','1',881933.14,885582.13,3648.99,638573.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','359',8604,'12','1',235776.83,238918.85,3142.02,549853.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','359',8605,'13','1',358142.04,361679.72,3537.68,619094.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','359',8606,'14','1',125875.38,128956.50,3081.12,539196.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','359',8607,'15','1',369084.98,373248.63,4163.65,728638.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','359',8608,'16','1',105695.48,108615.96,2920.48,511084.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','359',8609,'17','1',105987.79,109625.62,3637.83,636620.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','359',8610,'18','1',469441.69,473847.10,4405.41,770946.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','359',8611,'19','1',107555.29,111752.30,4197.01,734476.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','359',8612,'20','1',466840.85,471097.32,4256.47,744882.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','359',8613,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','359',8614,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','359',8615,'23','2',123754.54,123930.94,176.40,146412.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','359',8616,'24','2',96918.30,99052.40,2134.10,1771303.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','360',8617,'1','1',1132578.01,1135825.41,3247.40,568295.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','360',8618,'2','1',517724.12,520444.75,2720.63,476110.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','360',8619,'3','1',849608.17,852348.69,2740.52,479591.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','360',8620,'4','1',382886.50,384736.01,1849.51,323664.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','360',8621,'5','1',1110353.79,1112757.07,2403.28,420574.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','360',8622,'6','1',266262.49,268504.67,2242.18,392381.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','360',8623,'7','1',876822.16,879769.67,2947.51,515814.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','360',8624,'8','1',421450.25,424968.25,3518.00,615650.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','360',8625,'9','1',693764.50,696105.26,2340.76,409633.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','360',8626,'10','1',213647.59,215731.61,2084.02,364703.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','360',8627,'11','1',885582.13,888699.14,3117.01,545476.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','360',8628,'12','1',238918.85,240186.79,1267.94,221889.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','360',8629,'13','1',361679.72,363831.64,2151.92,376586.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','360',8630,'14','1',128956.50,130959.37,2002.87,350502.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','360',8631,'15','1',373248.63,375043.07,1794.44,314027.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','360',8632,'16','1',108615.96,109833.31,1217.35,213036.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','360',8633,'17','1',109625.62,110721.04,1095.42,191698.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','360',8634,'18','1',473847.10,477213.28,3366.18,589081.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','360',8635,'19','1',111752.30,112948.89,1196.59,209403.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','360',8636,'20','1',471097.32,473428.80,2331.48,408009.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','360',8637,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','360',8638,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','360',8639,'23','2',123930.94,124967.08,1036.14,859996.20,0.00,0.00,0.00,0.00,0.00),('1','248','5','360',8640,'24','2',99052.40,100645.19,1592.79,1322015.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','361',8641,'1','1',1135825.41,1138725.09,2899.68,507444.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','361',8642,'2','1',520444.75,523306.92,2862.17,500879.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','361',8643,'3','1',852348.69,854783.09,2434.40,426020.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','361',8644,'4','1',384736.01,386130.59,1394.58,244051.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','361',8645,'5','1',1112757.07,1116249.06,3491.99,611098.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','361',8646,'6','1',268504.67,270295.79,1791.12,313446.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','361',8647,'7','1',879769.67,882915.45,3145.78,550511.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','361',8648,'8','1',424968.25,427756.08,2787.83,487870.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','361',8649,'9','1',696105.26,699035.15,2929.89,512730.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','361',8650,'10','1',215731.61,217399.11,1667.50,291812.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','361',8651,'11','1',888699.14,891425.31,2726.17,477079.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','361',8652,'12','1',240186.79,241319.00,1132.21,198136.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','361',8653,'13','1',363831.64,366456.54,2624.90,459357.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','361',8654,'14','1',130959.37,132152.35,1192.98,208771.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','361',8655,'15','1',375043.07,377644.87,2601.80,455315.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','361',8656,'16','1',109833.31,111235.85,1402.54,245444.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','361',8657,'17','1',110721.04,112850.17,2129.13,372597.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','361',8658,'18','1',477213.28,479063.45,1850.17,323779.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','361',8659,'19','1',112948.89,115344.20,2395.31,419179.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','361',8660,'20','1',473428.80,476034.14,2605.34,455934.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','361',8661,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','361',8662,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','361',8663,'23','2',124967.08,125318.94,351.86,292043.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','361',8664,'24','2',100645.19,103653.14,3007.95,2496598.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','362',8665,'1','1',1138725.09,1140344.98,1619.89,283480.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','362',8666,'2','1',523306.92,523730.84,423.92,74186.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','362',8667,'3','1',854783.09,855670.07,886.98,155221.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','362',8668,'4','1',386130.59,387094.75,964.16,168728.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','362',8669,'5','1',1116249.06,1119409.65,3160.59,553103.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','362',8670,'6','1',270295.79,271553.54,1257.75,220106.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','362',8671,'7','1',882915.45,884292.55,1377.10,240992.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','362',8672,'8','1',427756.08,428891.15,1135.07,198637.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','362',8673,'9','1',699035.15,700191.85,1156.70,202422.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','362',8674,'10','1',217399.11,218402.77,1003.66,175640.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','362',8675,'11','1',891425.31,893577.90,2152.59,376703.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','362',8676,'12','1',241319.00,242915.70,1596.70,279422.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','362',8677,'13','1',366456.54,368054.43,1597.89,279630.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','362',8678,'14','1',132152.35,132831.21,678.86,118800.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','362',8679,'15','1',377644.87,379046.08,1401.21,245211.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','362',8680,'16','1',111235.85,112018.46,782.61,136956.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','362',8681,'17','1',112850.17,113484.43,634.26,110995.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','362',8682,'18','1',479063.45,480232.18,1168.73,204527.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','362',8683,'19','1',115344.20,116077.96,733.76,128408.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','362',8684,'20','1',476034.14,476503.19,469.05,82083.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','362',8685,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','362',8686,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','362',8687,'23','2',125318.94,125361.93,42.99,35681.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','362',8688,'24','2',103653.14,105409.47,1756.33,1457753.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','363',8689,'1','1',1140344.98,1142598.75,2253.77,394409.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','363',8690,'2','1',523730.84,526084.72,2353.88,411929.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','363',8691,'3','1',855670.07,858047.45,2377.38,416041.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','363',8692,'4','1',387094.75,389344.68,2249.93,393737.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','363',8693,'5','1',1119409.65,1121417.51,2007.86,351375.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','363',8694,'6','1',271553.54,273377.83,1824.29,319250.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','363',8695,'7','1',884292.55,886234.40,1941.85,339823.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','363',8696,'8','1',428891.15,430057.70,1166.55,204146.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','363',8697,'9','1',700191.85,702161.02,1969.17,344604.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','363',8698,'10','1',218402.77,220152.02,1749.25,306118.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','363',8699,'11','1',893577.90,897609.06,4031.16,705453.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','363',8700,'12','1',242915.70,245754.52,2838.82,496793.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','363',8701,'13','1',368054.43,369782.26,1727.83,302370.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','363',8702,'14','1',132831.21,134662.08,1830.87,320402.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','363',8703,'15','1',379046.08,381182.84,2136.76,373933.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','363',8704,'16','1',112018.46,112924.28,905.82,158518.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','363',8705,'17','1',113484.43,115216.85,1732.42,303173.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','363',8706,'18','1',480232.18,481995.36,1763.18,308556.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','363',8707,'19','1',116077.96,117628.29,1550.33,271307.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','363',8708,'20','1',476503.19,478152.98,1649.79,288713.25,0.00,0.00,0.00,0.00,0.00),('1','248','4','363',8709,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','363',8710,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','363',8711,'23','2',125361.93,125361.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','363',8712,'24','2',105409.47,106286.08,876.61,727586.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','364',8713,'1','1',1142598.75,1145691.21,3072.46,537680.50,0.00,0.00,20.00,0.00,0.00),('1','248','1','364',8714,'2','1',526084.72,528151.90,2067.18,361756.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','364',8715,'3','1',858047.45,860496.28,2428.83,425045.25,0.00,0.00,20.00,0.00,0.00),('1','248','1','364',8716,'4','1',389344.68,391168.80,1804.12,315721.00,0.00,0.00,20.00,0.00,0.00),('1','248','1','364',8717,'5','1',1121417.51,1124272.49,2834.98,496121.50,0.00,0.00,20.00,0.00,0.00),('1','248','1','364',8718,'6','1',273377.83,275472.81,2074.98,363121.50,0.00,0.00,20.00,0.00,0.00),('1','248','2','364',8719,'7','1',886234.40,888490.08,2235.68,391244.00,0.00,0.00,20.00,0.00,0.00),('1','248','2','364',8720,'8','1',430057.70,431787.11,1709.41,299146.75,0.00,0.00,20.00,0.00,0.00),('1','248','2','364',8721,'9','1',702161.02,704679.02,2498.00,437150.00,0.00,0.00,20.00,0.00,0.00),('1','248','2','364',8722,'10','1',220152.02,221900.83,1728.81,302541.75,0.00,0.00,20.00,0.00,0.00),('1','248','2','364',8723,'11','1',897609.06,900006.80,2377.74,416104.50,0.00,0.00,20.00,0.00,0.00),('1','248','2','364',8724,'12','1',245754.52,246700.52,946.00,165550.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','364',8725,'13','1',369782.26,369782.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','364',8726,'14','1',134662.08,134662.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','364',8727,'15','1',381182.84,383092.08,1909.24,334117.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','364',8728,'16','1',112924.28,113661.98,737.70,129097.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','364',8729,'17','1',115216.85,117537.82,2320.97,406169.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','364',8730,'18','1',481995.36,484806.92,2811.56,492023.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','364',8731,'19','1',117628.29,119551.18,1922.89,336505.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','364',8732,'20','1',478152.98,480323.94,2170.96,379918.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','364',8733,'21','2',282490.92,282490.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','364',8734,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','364',8735,'23','2',125361.93,125364.34,2.41,2000.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','364',8736,'24','2',106286.08,107438.39,1132.31,939817.30,0.00,0.00,20.00,0.00,0.00),('1','248','1','365',8737,'1','1',1145691.21,1145994.25,303.04,53032.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','365',8738,'2','1',528151.90,528509.04,357.14,62499.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','365',8739,'3','1',860496.28,861206.76,710.48,124334.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','365',8740,'4','1',391168.80,391461.28,292.48,51184.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','365',8741,'5','1',1124272.49,1125198.04,925.55,161971.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','365',8742,'6','1',275472.81,276863.53,1390.72,243376.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','365',8743,'7','1',888490.08,888490.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','365',8744,'8','1',431787.11,431787.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','365',8745,'9','1',704679.02,705323.83,644.81,112841.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','365',8746,'10','1',221900.83,222434.81,533.98,93446.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','365',8747,'11','1',900006.80,901779.50,1772.70,310222.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','365',8748,'12','1',246700.52,248319.09,1618.57,283249.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','365',8749,'13','1',369782.26,371217.78,1435.52,251216.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','365',8750,'14','1',134662.08,135806.60,1144.52,200291.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','365',8751,'15','1',383092.08,385579.70,2487.62,435333.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','365',8752,'16','1',113661.98,115616.00,1954.02,341953.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','365',8753,'17','1',117537.82,119832.78,2294.96,401618.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','365',8754,'18','1',484806.92,487209.43,2402.51,420439.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','365',8755,'19','1',119551.18,122027.92,2476.74,433429.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','365',8756,'20','1',480323.94,482442.26,2118.32,370706.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','365',8757,'21','2',282490.92,282498.71,7.79,6465.70,0.00,0.00,0.00,0.00,0.00),('1','248','4','365',8758,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','365',8759,'23','2',125364.34,125382.41,18.07,14998.10,0.00,0.00,0.00,0.00,0.00),('1','248','5','365',8760,'24','2',107438.39,108368.02,929.63,771592.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','366',8761,'1','1',1145994.25,1148744.46,2750.21,481286.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','366',8762,'2','1',528509.04,531116.32,2577.28,451024.00,0.00,0.00,30.00,0.00,0.00),('1','248','1','366',8763,'3','1',861206.76,863195.09,1988.33,347957.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','366',8764,'4','1',391461.28,393511.14,2049.86,358725.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','366',8765,'5','1',1125198.04,1129531.87,4333.83,758420.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','366',8766,'6','1',276863.53,280213.96,3350.43,586325.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','366',8767,'7','1',888490.08,888490.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','366',8768,'8','1',431787.11,431787.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','366',8769,'9','1',705323.83,705323.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','366',8770,'10','1',222434.81,222434.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','366',8771,'11','1',901779.50,901779.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','366',8772,'12','1',248319.09,248319.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','366',8773,'13','1',371217.78,371217.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','366',8774,'14','1',135806.60,135806.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','366',8775,'15','1',385579.70,385579.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','366',8776,'16','1',115616.00,115616.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','366',8777,'17','1',119832.78,119832.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','366',8778,'18','1',487209.43,487209.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','366',8779,'19','1',122027.92,122027.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','366',8780,'20','1',482442.26,482442.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','366',8781,'21','2',282498.71,282498.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','366',8782,'22','2',154974.15,154974.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','366',8783,'23','2',125382.41,125382.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','366',8784,'24','2',108368.02,108368.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','367',8785,'1','1',1148744.46,1152511.31,3766.85,659198.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','367',8786,'2','1',531116.32,534634.23,3517.91,615634.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','367',8787,'3','1',863195.09,866297.48,3102.39,542918.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','367',8788,'4','1',393511.14,396177.72,2666.58,466651.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','367',8789,'5','1',1129531.87,1132958.47,3426.60,599655.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','367',8790,'6','1',280213.96,284049.95,3835.99,671298.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','367',8791,'7','1',888490.08,891979.48,3489.40,610645.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','367',8792,'8','1',431787.11,434769.75,2982.64,521962.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','367',8793,'9','1',705323.83,708459.14,3135.31,548679.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','367',8794,'10','1',222434.81,224661.52,2226.71,389674.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','367',8795,'11','1',901779.50,904531.87,2752.37,481664.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','367',8796,'12','1',248319.09,250051.83,1732.74,303229.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','367',8797,'13','1',371217.78,373715.50,2497.72,437101.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','367',8798,'14','1',135806.60,138032.34,2225.74,389504.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','367',8799,'15','1',385579.70,389064.10,3484.40,609770.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','367',8800,'16','1',115616.00,116559.58,943.58,165126.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','367',8801,'17','1',119832.78,122771.23,2938.45,514228.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','367',8802,'18','1',487209.43,489624.53,2415.10,422642.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','367',8803,'19','1',122027.92,124342.79,2314.87,405102.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','367',8804,'20','1',482442.26,485561.44,3119.18,545856.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','367',8805,'21','2',282498.71,283494.02,318.92,264703.60,0.00,0.00,676.39,0.00,0.00),('1','248','4','367',8806,'22','2',154974.15,155365.23,391.08,324596.40,0.00,0.00,0.00,0.00,0.00),('1','248','5','367',8807,'23','2',125382.41,125382.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','367',8808,'24','2',108368.02,108368.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','368',8809,'1','1',1152511.31,1152511.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','368',8810,'2','1',534634.23,534634.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','368',8811,'3','1',866297.48,866297.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','368',8812,'4','1',396177.72,396177.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','368',8813,'5','1',1132958.47,1132958.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','368',8814,'6','1',284049.95,284049.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','368',8815,'7','1',891979.48,891979.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','368',8816,'8','1',434769.75,434769.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','368',8817,'9','1',708459.14,708459.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','368',8818,'10','1',224661.52,224661.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','368',8819,'11','1',904531.87,906537.29,2005.42,350948.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','368',8820,'12','1',250051.83,251831.11,1779.28,311374.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','368',8821,'13','1',373715.50,373715.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','368',8822,'14','1',138032.34,138032.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','368',8823,'15','1',389064.10,389064.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','368',8824,'16','1',116559.58,116559.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','368',8825,'17','1',122771.23,122771.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','368',8826,'18','1',489624.53,489624.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','368',8827,'19','1',124342.79,124342.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','368',8828,'20','1',485561.44,485561.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','368',8829,'21','2',283494.02,283494.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','368',8830,'22','2',155365.23,156318.36,953.13,791097.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','368',8831,'23','2',125382.41,125382.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','368',8832,'24','2',108368.02,108368.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','369',8833,'1','1',1152511.31,1152511.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','369',8834,'2','1',534634.23,534634.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','369',8835,'3','1',866297.48,866297.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','369',8836,'4','1',396177.72,396177.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','369',8837,'5','1',1132958.47,1132958.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','369',8838,'6','1',284049.95,284049.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','369',8839,'7','1',891979.48,891979.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','369',8840,'8','1',434769.75,434769.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','369',8841,'9','1',708459.14,708459.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','369',8842,'10','1',224661.52,224661.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','369',8843,'11','1',906537.29,906537.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','369',8844,'12','1',251831.11,251831.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','369',8845,'13','1',373715.50,377353.38,3637.88,636629.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','369',8846,'14','1',138032.34,141642.13,3609.79,631713.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','369',8847,'15','1',389064.10,393531.34,4467.24,781767.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','369',8848,'16','1',116559.58,120420.45,3860.87,675652.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','369',8849,'17','1',122771.23,127577.10,4805.87,841027.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','369',8850,'18','1',489624.53,494085.45,4460.92,780661.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','369',8851,'19','1',124342.79,128410.06,4067.27,711772.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','369',8852,'20','1',485561.44,489360.38,3798.94,664814.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','369',8853,'21','2',283494.02,285786.04,2292.02,1902376.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','369',8854,'22','2',156318.36,156318.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','369',8855,'23','2',125382.41,125382.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','369',8856,'24','2',108368.02,108368.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','370',8857,'1','1',1152511.31,1154897.25,2385.94,417539.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','370',8858,'2','1',534634.23,536369.07,1734.84,303597.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','370',8859,'3','1',866297.48,868638.71,2296.66,401915.50,0.00,0.00,44.57,0.00,0.00),('1','248','1','370',8860,'4','1',396177.72,398314.80,2091.37,365989.75,0.00,0.00,45.71,0.00,0.00),('1','248','1','370',8861,'5','1',1132958.47,1135244.18,2240.00,392000.00,0.00,0.00,45.71,0.00,0.00),('1','248','1','370',8862,'6','1',284049.95,286059.27,2009.32,351631.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','370',8863,'7','1',891979.48,891979.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','370',8864,'8','1',434769.75,434769.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','370',8865,'9','1',708459.14,708459.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','370',8866,'10','1',224661.52,224661.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','370',8867,'11','1',906537.29,906537.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','370',8868,'12','1',251831.11,251831.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','370',8869,'13','1',377353.38,378851.40,1498.02,262153.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','370',8870,'14','1',141642.13,143106.16,1464.03,256205.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','370',8871,'15','1',393531.34,395455.94,1924.60,336805.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','370',8872,'16','1',120420.45,121766.30,1345.85,235523.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','370',8873,'17','1',127577.10,129073.94,1496.84,261947.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','370',8874,'18','1',494085.45,495818.08,1732.63,303210.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','370',8875,'19','1',128410.06,129654.89,1244.83,217845.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','370',8876,'20','1',489360.38,490824.07,1463.69,256145.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','370',8877,'21','2',285786.04,288897.19,3091.15,2565654.50,0.00,0.00,20.00,0.00,0.00),('1','248','4','370',8878,'22','2',156318.36,156318.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','370',8879,'23','2',125382.41,125382.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','370',8880,'24','2',108368.02,108368.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','371',8881,'1','1',1154897.25,1156768.65,1871.40,327495.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','371',8882,'2','1',536369.07,538518.07,2149.00,376075.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','371',8883,'3','1',868638.71,870352.13,1713.42,299848.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','371',8884,'4','1',398314.80,400382.46,2067.66,361840.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','371',8885,'5','1',1135244.18,1137829.12,2584.94,452364.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','371',8886,'6','1',286059.27,288520.39,2461.12,430696.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','371',8887,'7','1',891979.48,894084.37,2104.89,368355.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','371',8888,'8','1',434769.75,436970.55,2200.80,385140.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','371',8889,'9','1',708459.14,710470.25,2011.11,351944.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','371',8890,'10','1',224661.52,226267.35,1605.83,281020.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','371',8891,'11','1',906537.29,908852.39,2315.10,405142.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','371',8892,'12','1',251831.11,253867.84,2036.73,356427.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','371',8893,'13','1',378851.40,378851.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','371',8894,'14','1',143106.16,143106.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','371',8895,'15','1',395455.94,395455.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','371',8896,'16','1',121766.30,121766.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','371',8897,'17','1',129073.94,129073.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','371',8898,'18','1',495818.08,495818.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','371',8899,'19','1',129654.89,129654.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','371',8900,'20','1',490824.07,490824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','371',8901,'21','2',288897.19,292692.77,3795.58,3150331.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','371',8902,'22','2',156318.36,156429.59,111.23,92320.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','371',8903,'23','2',125382.41,125382.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','371',8904,'24','2',108368.02,108368.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','372',8905,'1','1',1156768.65,1162059.56,5250.91,918909.25,0.00,0.00,40.00,0.00,0.00),('1','248','1','372',8906,'2','1',538518.07,543619.60,5101.53,892767.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','372',8907,'3','1',870352.13,876106.67,5754.54,1007044.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','372',8908,'4','1',400382.46,405718.31,5335.85,933773.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','372',8909,'5','1',1137829.12,1143649.14,5820.02,1018503.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','372',8910,'6','1',288520.39,293768.27,5247.88,918379.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','372',8911,'7','1',894084.37,897155.04,3070.67,537367.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','372',8912,'8','1',436970.55,439412.68,2442.13,427372.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','372',8913,'9','1',710470.25,714021.06,3550.81,621391.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','372',8914,'10','1',226267.35,227806.46,1539.11,269344.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','372',8915,'11','1',908852.39,913095.47,4243.08,742539.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','372',8916,'12','1',253867.84,257145.52,3277.68,573594.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','372',8917,'13','1',378851.40,381579.18,2727.78,477361.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','372',8918,'14','1',143106.16,143106.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','372',8919,'15','1',395455.94,397591.21,2135.27,373672.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','372',8920,'16','1',121766.30,124293.03,2526.73,442177.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','372',8921,'17','1',129073.94,130914.68,1840.74,322129.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','372',8922,'18','1',495818.08,498130.75,2312.67,404717.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','372',8923,'19','1',129654.89,131890.93,2236.04,391307.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','372',8924,'20','1',490824.07,492980.59,2156.52,377391.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','372',8925,'21','2',292692.77,293997.28,1304.51,1082743.30,0.00,0.00,0.00,0.00,0.00),('1','248','4','372',8926,'22','2',156429.59,159153.50,2723.91,2260845.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','372',8927,'23','2',125382.41,125382.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','372',8928,'24','2',108368.02,108368.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','373',8929,'1','1',1162059.56,1163377.62,1318.06,230660.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','373',8930,'2','1',543619.60,544894.50,1274.90,223107.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','373',8931,'3','1',876106.67,877081.54,974.87,170602.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','373',8932,'4','1',405718.31,406650.51,932.20,163135.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','373',8933,'5','1',1143649.14,1145775.46,2126.32,372106.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','373',8934,'6','1',293768.27,295204.57,1436.30,251352.50,0.00,0.00,0.00,0.00,0.00),('1','248','2','373',8935,'7','1',897155.04,897155.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','373',8936,'8','1',439412.68,439412.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','373',8937,'9','1',714021.06,714021.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','373',8938,'10','1',227806.46,227806.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','373',8939,'11','1',913095.47,913095.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','373',8940,'12','1',257145.52,257145.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','373',8941,'13','1',381579.18,382883.13,1303.95,228191.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','373',8942,'14','1',143106.16,143726.57,620.41,108571.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','373',8943,'15','1',397591.21,398968.11,1376.90,240957.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','373',8944,'16','1',124293.03,125373.18,1080.15,189026.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','373',8945,'17','1',130914.68,132725.90,1811.22,316963.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','373',8946,'18','1',498130.75,499965.57,1834.82,321093.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','373',8947,'19','1',131890.93,133299.40,1408.47,246482.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','373',8948,'20','1',492980.59,494610.19,1629.60,285180.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','373',8949,'21','2',293997.28,293997.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','373',8950,'22','2',159153.50,159153.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','373',8951,'23','2',125382.41,125382.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','373',8952,'24','2',108368.02,108368.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','374',8953,'1','1',1163377.62,1165890.69,2513.07,464917.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','374',8954,'2','1',544894.50,547375.20,2480.70,458929.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','374',8955,'3','1',877081.54,878869.90,1788.36,330846.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','374',8956,'4','1',406650.51,408174.60,1524.09,281956.65,0.00,0.00,0.00,0.00,0.00),('1','248','1','374',8957,'5','1',1145775.46,1147883.70,2108.24,390024.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','374',8958,'6','1',295204.57,297080.02,1875.45,346958.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','374',8959,'7','1',897155.04,897155.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','374',8960,'8','1',439412.68,439412.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','374',8961,'9','1',714021.06,714021.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','374',8962,'10','1',227806.46,227806.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','374',8963,'11','1',913095.47,913095.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','374',8964,'12','1',257145.52,257145.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','374',8965,'13','1',382883.13,385251.79,2368.66,438202.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','374',8966,'14','1',143726.57,145815.37,2088.80,386428.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','374',8967,'15','1',398968.11,401406.98,2438.87,451190.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','374',8968,'16','1',125373.18,127648.75,2275.57,420980.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','374',8969,'17','1',132725.90,134901.07,2175.17,402406.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','374',8970,'18','1',499965.57,502357.74,2392.17,442551.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','374',8971,'19','1',133299.40,135446.23,2146.83,397163.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','374',8972,'20','1',494610.19,496553.00,1942.81,359419.85,0.00,0.00,0.00,0.00,0.00),('1','248','4','374',8973,'21','2',293997.28,295136.11,1138.83,945228.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','374',8974,'22','2',159153.50,162083.15,2929.65,2431609.50,0.00,0.00,0.00,0.00,0.00),('1','248','5','374',8975,'23','2',125382.41,125382.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','374',8976,'24','2',108368.02,108368.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','375',8977,'1','1',1165890.69,1168612.61,2721.92,503555.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','375',8978,'2','1',547375.20,549523.90,2148.70,397509.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','375',8979,'3','1',878869.90,881217.71,2347.81,434344.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','375',8980,'4','1',408174.60,410489.00,2314.40,428164.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','375',8981,'5','1',1147883.70,1150565.36,2681.66,496107.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','375',8982,'6','1',297080.02,299463.99,2383.97,441034.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','375',8983,'7','1',897155.04,897155.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','375',8984,'8','1',439412.68,439412.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','375',8985,'9','1',714021.06,714021.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','375',8986,'10','1',227806.46,227806.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','375',8987,'11','1',913095.47,913095.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','375',8988,'12','1',257145.52,257145.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','375',8989,'13','1',385251.79,385934.37,682.58,126277.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','375',8990,'14','1',145815.37,146271.53,456.16,84389.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','375',8991,'15','1',401406.98,402296.96,889.98,164646.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','375',8992,'16','1',127648.75,128253.68,604.93,111912.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','375',8993,'17','1',134901.07,135587.64,686.57,127015.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','375',8994,'18','1',502357.74,503122.35,764.61,141452.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','375',8995,'19','1',135446.23,135682.44,236.21,43698.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','375',8996,'20','1',496553.00,497578.28,1025.28,189676.80,0.00,0.00,0.00,0.00,0.00),('1','248','4','375',8997,'21','2',295136.11,295510.48,374.37,310727.10,0.00,0.00,0.00,0.00,0.00),('1','248','4','375',8998,'22','2',162083.15,162083.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','375',8999,'23','2',125382.41,125824.07,441.66,366577.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','375',9000,'24','2',108368.02,108660.99,292.97,243165.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','376',9001,'1','1',1168612.61,1171614.01,3001.40,555259.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','376',9002,'2','1',549523.90,552345.81,2821.91,522053.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','376',9003,'3','1',881217.71,881217.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','376',9004,'4','1',410489.00,410489.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','376',9005,'5','1',1150565.36,1154216.17,3650.81,675399.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','376',9006,'6','1',299463.99,302284.17,2820.18,521733.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','376',9007,'7','1',897155.04,900631.83,3476.79,643206.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','376',9008,'8','1',439412.68,442326.67,2913.99,539088.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','376',9009,'9','1',714021.06,714021.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','376',9010,'10','1',227806.46,227806.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','376',9011,'11','1',913095.47,916370.75,3275.28,605926.80,0.00,0.00,0.00,0.00,0.00),('1','248','2','376',9012,'12','1',257145.52,259441.36,2295.84,424730.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','376',9013,'13','1',385934.37,385934.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','376',9014,'14','1',146271.53,146454.53,183.00,33855.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','376',9015,'15','1',402296.96,402296.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','376',9016,'16','1',128253.68,128253.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','376',9017,'17','1',135587.64,137850.77,2263.13,418679.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','376',9018,'18','1',503122.35,505122.95,2000.60,370111.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','376',9019,'19','1',135682.44,137295.71,1613.27,298454.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','376',9020,'20','1',497578.28,501137.63,3559.35,658479.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','376',9021,'21','2',295510.48,295510.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','376',9022,'22','2',162083.15,162083.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','376',9023,'23','2',125824.07,126780.80,956.73,794085.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','376',9024,'24','2',108660.99,109558.92,897.93,745281.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','377',9025,'1','1',1171614.01,1176185.09,4571.08,845649.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','377',9026,'2','1',552345.81,556104.19,3758.38,695300.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','377',9027,'3','1',881217.71,886525.64,5307.93,981967.05,0.00,0.00,0.00,0.00,0.00),('1','248','1','377',9028,'4','1',410489.00,413411.66,2922.66,540692.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','377',9029,'5','1',1154216.17,1158711.64,4495.47,831661.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','377',9030,'6','1',302284.17,305989.57,3705.40,685499.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','377',9031,'7','1',900631.83,901342.99,711.16,131564.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','377',9032,'8','1',442326.67,442837.33,510.66,94472.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','377',9033,'9','1',714021.06,714774.82,753.76,139445.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','377',9034,'10','1',227806.46,227806.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','377',9035,'11','1',916370.75,917364.49,993.74,183841.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','377',9036,'12','1',259441.36,259829.95,388.59,71889.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','377',9037,'13','1',385934.37,389975.27,4040.90,747566.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','377',9038,'14','1',146454.53,148893.81,2439.28,451266.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','377',9039,'15','1',402296.96,406251.32,3954.36,731556.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','377',9040,'16','1',128253.68,131364.98,3111.30,575590.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','377',9041,'17','1',137850.77,140592.10,2741.33,507146.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','377',9042,'18','1',505122.95,509240.94,4117.99,761828.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','377',9043,'19','1',137295.71,140418.61,3122.90,577736.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','377',9044,'20','1',501137.63,505032.16,3894.53,720488.05,0.00,0.00,0.00,0.00,0.00),('1','248','4','377',9045,'21','2',295510.48,295510.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','377',9046,'22','2',162083.15,162083.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','377',9047,'23','2',126780.80,128683.73,1902.93,1579431.90,0.00,0.00,0.00,0.00,0.00),('1','248','5','377',9048,'24','2',109558.92,111121.48,1562.56,1296924.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','378',9049,'1','1',1176185.09,1179848.29,3663.20,677692.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','378',9050,'2','1',556104.19,559260.22,3156.03,583865.55,0.00,0.00,0.00,0.00,0.00),('1','248','1','378',9051,'3','1',886525.64,889406.60,2880.96,532977.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','378',9052,'4','1',413411.66,415483.21,2071.55,383236.75,0.00,0.00,0.00,0.00,0.00),('1','248','1','378',9053,'5','1',1158711.64,1161758.38,3046.74,563646.90,0.00,0.00,0.00,0.00,0.00),('1','248','1','378',9054,'6','1',305989.57,308508.04,2518.47,465916.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','378',9055,'7','1',901342.99,901342.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','378',9056,'8','1',442837.33,442837.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','378',9057,'9','1',714774.82,714774.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','378',9058,'10','1',227806.46,227806.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','378',9059,'11','1',917364.49,917560.42,195.93,36247.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','378',9060,'12','1',259829.95,260454.58,624.63,115556.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','378',9061,'13','1',389975.27,393095.20,3104.93,574412.05,0.00,0.00,15.00,0.00,0.00),('1','248','3','378',9062,'14','1',148893.81,150941.66,2047.85,378852.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','378',9063,'15','1',406251.32,409490.00,3238.68,599155.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','378',9064,'16','1',131364.98,133211.02,1846.04,341517.40,0.00,0.00,0.00,0.00,0.00),('1','248','3','378',9065,'17','1',140592.10,142753.71,2161.61,399897.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','378',9066,'18','1',509240.94,511816.60,2575.66,476497.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','378',9067,'19','1',140418.61,142466.71,2048.10,378898.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','378',9068,'20','1',505032.16,506736.70,1704.54,315339.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','378',9069,'21','2',295510.48,295510.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','378',9070,'22','2',162083.15,162083.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','378',9071,'23','2',128683.73,129652.39,968.66,803987.80,0.00,0.00,0.00,0.00,0.00),('1','248','5','378',9072,'24','2',111121.48,114115.25,2993.77,2484829.10,0.00,0.00,0.00,0.00,0.00),('1','248','1','379',9073,'1','1',1179848.29,1184272.71,4424.42,818517.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','379',9074,'2','1',559260.22,562567.63,3307.41,611870.85,0.00,0.00,0.00,0.00,0.00),('1','248','1','379',9075,'3','1',889406.60,892988.64,3582.04,662677.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','379',9076,'4','1',415483.21,418506.45,3003.24,555599.40,0.00,0.00,20.00,0.00,0.00),('1','248','1','379',9077,'5','1',1161758.38,1165289.17,3530.79,653196.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','379',9078,'6','1',308508.04,311883.70,3375.66,624497.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','379',9079,'7','1',901342.99,904797.80,3454.81,639139.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','379',9080,'8','1',442837.33,445420.06,2582.73,477805.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','379',9081,'9','1',714774.82,714774.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','379',9082,'10','1',227806.46,227806.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','379',9083,'11','1',917560.42,920930.86,3370.44,623531.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','379',9084,'12','1',260454.58,262788.28,2333.70,431734.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','379',9085,'13','1',393095.20,396703.59,3608.39,667552.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','379',9086,'14','1',150941.66,153955.62,3013.96,557582.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','379',9087,'15','1',409490.00,412961.99,3471.99,642318.15,0.00,0.00,0.00,0.00,0.00),('1','248','3','379',9088,'16','1',133211.02,135640.63,2429.61,449477.85,0.00,0.00,0.00,0.00,0.00),('1','248','3','379',9089,'17','1',142753.71,144870.73,2117.02,391648.70,0.00,0.00,0.00,0.00,0.00),('1','248','3','379',9090,'18','1',511816.60,513910.07,2093.47,387291.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','379',9091,'19','1',142466.71,145186.87,2720.16,503229.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','379',9092,'20','1',506736.70,510261.10,3524.40,652014.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','379',9093,'21','2',295510.48,295510.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','379',9094,'22','2',162083.15,162083.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','379',9095,'23','2',129652.39,130242.71,590.32,489965.60,0.00,0.00,0.00,0.00,0.00),('1','248','5','379',9096,'24','2',114115.25,118481.74,4366.49,3624186.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','380',9097,'1','1',1184272.71,1186940.88,2668.17,493611.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','380',9098,'2','1',562567.63,563689.87,1122.24,207614.40,0.00,0.00,0.00,0.00,0.00),('1','248','1','380',9099,'3','1',892988.64,896151.26,3162.62,585084.70,0.00,0.00,0.00,0.00,0.00),('1','248','1','380',9100,'4','1',418506.45,420394.77,1888.32,349339.20,0.00,0.00,0.00,0.00,0.00),('1','248','1','380',9101,'5','1',1165289.17,1168112.84,2823.67,522378.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','380',9102,'6','1',311883.70,314124.06,2240.36,414466.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','380',9103,'7','1',904797.80,907549.15,2751.35,508999.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','380',9104,'8','1',445420.06,447297.98,1877.92,347415.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','380',9105,'9','1',714774.82,717725.34,2950.52,545846.20,0.00,0.00,0.00,0.00,0.00),('1','248','2','380',9106,'10','1',227806.46,229139.11,1332.65,246540.25,0.00,0.00,0.00,0.00,0.00),('1','248','2','380',9107,'11','1',920930.86,922558.64,1584.54,293139.90,0.00,0.00,43.24,0.00,0.00),('1','248','2','380',9108,'12','1',262788.28,264115.36,1327.08,245509.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','380',9109,'13','1',396703.59,399615.68,2912.09,538736.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','380',9110,'14','1',153955.62,156272.35,2316.73,428595.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','380',9111,'15','1',412961.99,416617.67,3655.68,676300.80,0.00,0.00,0.00,0.00,0.00),('1','248','3','380',9112,'16','1',135640.63,137961.48,2320.85,429357.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','380',9113,'17','1',144870.73,147950.80,3080.07,569812.95,0.00,0.00,0.00,0.00,0.00),('1','248','3','380',9114,'18','1',513910.07,516780.56,2870.49,531040.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','380',9115,'19','1',145186.87,148082.52,2895.65,535695.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','380',9116,'20','1',510261.10,513262.25,3001.15,555212.75,0.00,0.00,0.00,0.00,0.00),('1','248','4','380',9117,'21','2',295510.48,298275.83,2765.35,2295240.50,0.00,0.00,0.00,0.00,0.00),('1','248','4','380',9118,'22','2',162083.15,164277.46,2194.31,1821277.30,0.00,0.00,0.00,0.00,0.00),('1','248','5','380',9119,'23','2',130242.71,130525.88,283.17,235031.10,0.00,0.00,0.00,0.00,0.00),('1','248','5','380',9120,'24','2',118481.74,118481.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','381',9121,'1','1',1186940.88,1190152.86,3211.98,594216.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','381',9122,'2','1',563689.87,566383.35,2693.48,498293.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','381',9123,'3','1',896151.26,899614.13,3462.87,640630.95,0.00,0.00,0.00,0.00,0.00),('1','248','1','381',9124,'4','1',420394.77,423229.13,2834.36,524356.60,0.00,0.00,0.00,0.00,0.00),('1','248','1','381',9125,'5','1',1168112.84,1172268.12,4155.28,768726.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','381',9126,'6','1',314124.06,316628.83,2504.77,463382.45,0.00,0.00,0.00,0.00,0.00),('1','248','2','381',9127,'7','1',907549.15,911154.30,3605.15,666952.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','381',9128,'8','1',447297.98,448625.76,1327.78,245639.30,0.00,0.00,0.00,0.00,0.00),('1','248','2','381',9129,'9','1',717725.34,720177.10,2451.76,453575.60,0.00,0.00,0.00,0.00,0.00),('1','248','2','381',9130,'10','1',229139.11,231305.32,2166.21,400748.85,0.00,0.00,0.00,0.00,0.00),('1','248','2','381',9131,'11','1',922558.64,926984.27,4425.63,818741.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','381',9132,'12','1',264115.36,266807.32,2691.96,498012.60,0.00,0.00,0.00,0.00,0.00),('1','248','3','381',9133,'13','1',399615.68,399615.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','381',9134,'14','1',156272.35,156272.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','381',9135,'15','1',416617.67,416959.70,342.03,63275.55,0.00,0.00,0.00,0.00,0.00),('1','248','3','381',9136,'16','1',137961.48,138386.46,424.98,78621.30,0.00,0.00,0.00,0.00,0.00),('1','248','3','381',9137,'17','1',147950.80,150127.35,2176.55,402661.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','381',9138,'18','1',516780.56,519070.01,2289.45,423548.25,0.00,0.00,0.00,0.00,0.00),('1','248','3','381',9139,'19','1',148082.52,150084.98,2002.46,370455.10,0.00,0.00,0.00,0.00,0.00),('1','248','3','381',9140,'20','1',513262.25,516113.79,2851.54,527534.90,0.00,0.00,0.00,0.00,0.00),('1','248','4','381',9141,'21','2',298275.83,300250.11,1974.28,1638652.40,0.00,0.00,0.00,0.00,0.00),('1','248','4','381',9142,'22','2',164277.46,167057.76,2780.30,2307649.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','381',9143,'23','2',130525.88,130525.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','381',9144,'24','2',118481.74,118481.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','382',9145,'1','1',1190152.86,1191977.77,1824.91,337608.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','382',9146,'2','1',566383.35,567889.54,1506.19,278645.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','382',9147,'3','1',899614.13,899614.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','382',9148,'4','1',423229.13,423229.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','382',9149,'5','1',1172268.12,1174128.30,1860.18,344133.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','382',9150,'6','1',316628.83,318279.90,1651.07,305447.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','382',9151,'7','1',911154.30,912977.79,1823.49,337345.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','382',9152,'8','1',448625.76,450041.39,1415.63,261891.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','382',9153,'9','1',720177.10,722599.61,2422.51,448164.35,0.00,0.00,0.00,0.00,0.00),('1','248','2','382',9154,'10','1',231305.32,233009.46,1704.14,315265.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','382',9155,'11','1',926984.27,929510.66,2526.39,467382.15,0.00,0.00,0.00,0.00,0.00),('1','248','2','382',9156,'12','1',266807.32,268714.27,1906.95,352785.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','382',9157,'13','1',399615.68,399615.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','382',9158,'14','1',156272.35,156272.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','382',9159,'15','1',416959.70,419071.79,2112.09,390736.65,0.00,0.00,0.00,0.00,0.00),('1','248','3','382',9160,'16','1',138386.46,139394.00,1007.54,186394.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','382',9161,'17','1',150127.35,152005.90,1878.55,347531.75,0.00,0.00,0.00,0.00,0.00),('1','248','3','382',9162,'18','1',519070.01,520450.41,1380.40,255374.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','382',9163,'19','1',150084.98,151985.91,1900.93,351672.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','382',9164,'20','1',516113.79,517966.80,1853.01,342806.85,0.00,0.00,0.00,0.00,0.00),('1','248','4','382',9165,'21','2',300250.11,301485.11,1235.00,1025050.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','382',9166,'22','2',167057.76,167057.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','382',9167,'23','2',130525.88,130525.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','382',9168,'24','2',118481.74,118481.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','383',9169,'1','1',1191977.77,1191977.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','383',9170,'2','1',567889.54,567889.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','383',9171,'3','1',899614.13,899614.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','383',9172,'4','1',423229.13,423229.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','383',9173,'5','1',1174128.30,1174128.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','383',9174,'6','1',318279.90,318279.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','383',9175,'7','1',912977.79,912977.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','383',9176,'8','1',450041.39,450041.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','383',9177,'9','1',722599.61,722599.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','383',9178,'10','1',233009.46,233174.53,165.07,30537.95,0.00,0.00,0.00,0.00,0.00),('1','248','2','383',9179,'11','1',929510.66,929644.00,133.34,24667.90,0.00,0.00,0.00,0.00,0.00),('1','248','2','383',9180,'12','1',268714.27,268714.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','383',9181,'13','1',399615.68,399615.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','383',9182,'14','1',156272.35,156272.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','383',9183,'15','1',419071.79,419071.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','383',9184,'16','1',139394.00,139394.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','383',9185,'17','1',152005.90,152005.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','383',9186,'18','1',520450.41,520450.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','383',9187,'19','1',151985.91,151985.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','383',9188,'20','1',517966.80,517966.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','383',9189,'21','2',301485.11,302034.63,549.52,456101.60,0.00,0.00,0.00,0.00,0.00),('1','248','4','383',9190,'22','2',167057.76,167057.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','383',9191,'23','2',130525.88,130525.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','383',9192,'24','2',118481.74,118481.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','384',9193,'1','1',1191977.77,1194817.14,2839.37,525283.45,0.00,0.00,0.00,0.00,0.00),('1','248','1','384',9194,'2','1',567889.54,569796.79,1907.25,352841.25,0.00,0.00,0.00,0.00,0.00),('1','248','1','384',9195,'3','1',899614.13,899614.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','384',9196,'4','1',423229.13,423229.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','384',9197,'5','1',1174128.30,1176500.58,2372.28,438871.80,0.00,0.00,0.00,0.00,0.00),('1','248','1','384',9198,'6','1',318279.90,320243.33,1963.43,363234.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','384',9199,'7','1',912977.79,915774.59,2796.80,517408.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','384',9200,'8','1',450041.39,452309.63,2268.24,419624.40,0.00,0.00,0.00,0.00,0.00),('1','248','2','384',9201,'9','1',722599.61,725516.27,2916.66,539582.10,0.00,0.00,0.00,0.00,0.00),('1','248','2','384',9202,'10','1',233174.53,233174.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','2','384',9203,'11','1',929644.00,932425.33,2781.33,514546.05,0.00,0.00,0.00,0.00,0.00),('1','248','2','384',9204,'12','1',268714.27,270290.81,1576.54,291659.90,0.00,0.00,0.00,0.00,0.00),('1','248','3','384',9205,'13','1',399615.68,399615.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','384',9206,'14','1',156272.35,156272.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','3','384',9207,'15','1',419071.79,421962.52,2890.73,534785.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','384',9208,'16','1',139394.00,141413.13,2019.13,373539.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','384',9209,'17','1',152005.90,155123.47,3117.57,576750.45,0.00,0.00,0.00,0.00,0.00),('1','248','3','384',9210,'18','1',520450.41,522359.11,1908.70,353109.50,0.00,0.00,0.00,0.00,0.00),('1','248','3','384',9211,'19','1',151985.91,153721.44,1735.53,321073.05,0.00,0.00,0.00,0.00,0.00),('1','248','3','384',9212,'20','1',517966.80,520642.73,2675.93,495047.05,0.00,0.00,0.00,0.00,0.00),('1','248','4','384',9213,'21','2',302034.63,302034.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','4','384',9214,'22','2',167057.76,170667.85,3610.09,2996374.70,0.00,0.00,0.00,0.00,0.00),('1','248','5','384',9215,'23','2',130525.88,130525.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','5','384',9216,'24','2',118481.74,118481.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','248','1','385',9217,'1','1',1194817.14,1198865.25,4048.11,748900.35,0.00,0.00,0.00,0.00,0.00),('1','248','1','385',9218,'2','1',569796.79,572958.29,3161.50,584877.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','385',9219,'3','1',899614.13,900917.43,1303.30,241110.50,0.00,0.00,0.00,0.00,0.00),('1','248','1','385',9220,'4','1',423229.13,424635.92,1406.79,260256.15,0.00,0.00,0.00,0.00,0.00),('1','248','1','385',9221,'5','1',1176500.58,1181280.76,4780.18,884333.30,0.00,0.00,0.00,0.00,0.00),('1','248','1','385',9222,'6','1',320243.33,323878.16,3634.83,672443.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','385',9223,'7','1',915774.59,919137.82,3363.23,622197.55,0.00,0.00,0.00,0.00,0.00),('1','248','2','385',9224,'8','1',452309.63,454452.92,2143.29,396508.65,0.00,0.00,0.00,0.00,0.00),('1','248','2','385',9225,'9','1',725516.27,727894.22,2377.95,439920.75,0.00,0.00,0.00,0.00,0.00),('1','248','2','385',9226,'10','1',233174.53,234390.80,1216.27,225009.95,0.00,0.00,0