-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_223
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_223`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_223` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_223`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,500,'',0,'6.1','1','223','CASH','','2022-03-02 14:20:19',5,0.00,0.00,'','487','2022-03-02 14:20:19','487',0,0),(2,7000,'',0,'20','1','223','SALES','','2022-03-02 14:20:39',5,0.00,0.00,'','487','2022-03-02 14:20:39','487',0,0),(3,8000,'',0,'24','1','223','PURCHASES','','2022-03-02 14:21:08',5,0.00,0.00,'','487','2022-03-02 14:21:08','487',0,0),(4,8001,'',0,'24','1','223','SALARIES & WAGES','','2022-03-02 14:21:37',5,0.00,0.00,'','487','2022-03-02 14:21:37','487',0,0),(5,2500,'',0,'2','1','223','DANKANO-EBILLS(ZNB:1014717618)','','2022-03-03 06:12:12',5,0.00,0.00,'','487','2022-03-03 06:12:12','487',0,0),(6,2501,'',0,'2','1','223','ZENITH BANK POS','','2022-03-03 06:12:44',5,0.00,0.00,'','487','2022-03-03 06:12:44','487',0,0),(7,2502,'',0,'2','1','223','FID POS COLLECTION (5620141491','','2022-03-15 17:26:40',5,0.00,0.00,'','487','2022-03-15 17:26:40','487',0,0),(8,2503,'',0,'2','1','223','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:38:57',5,0.00,0.00,'','792','2023-02-20 14:38:57','792',0,0),(9,2504,'',0,'2','1','223','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:40:52',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:58:26','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','223','A A RANO NIGERIA LIMITED','A A RANO L P G','08067096252','@gmail.com','Lokoja','Lokoja','Lokoja L P G','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-05 08:09:11',5,'765','2022-03-05 08:09:11','765'),(2,'','1','223','DAVID GAS','MR David Nnajidu ','08039737069','@gmail.com','Lokoja','Kogi','Beside GT  Plaza ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 12:26:24',5,'765','2022-03-06 12:26:24','765'),(3,'','1','223','MSR Gas','Muhammad Mansur','07054544455','@gmail.com','Lokoja','Kogi','Beside Olympic Hotel','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 13:04:42',5,'765','2022-03-06 13:04:42','765'),(4,'','1','223','Hassan Gas','Alhassan Sulaiman','08033687351','@gmail.com','Lokoja','Kogi','Felele Phase 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 16:32:05',5,'765','2022-03-06 16:32:05','765'),(5,'','1','223','DAYORX','YUSUF ODUNAYO','08149204837','@gmail.com','Lokoja','Kogi','SARKIN NOMA LOKOJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 10:00:51',5,'765','2022-03-08 10:00:51','765'),(6,'','1','223','GT FAST FOOD','KEYSLY','08038421441','@gmail.com','Lokoja','Kogi','FELELE LOKOJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 10:50:02',5,'765','2022-03-08 10:50:02','765'),(7,'','1','223','DV Gas','DV GAS','07067161078','@gmail.com','Lokoja','Kogi','Opposite Habso Filling Station','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 16:16:13',5,'765','2022-03-08 16:16:13','765'),(8,'','1','223','MOBEL GAS','Obajana ','08035924270','mobelgas8@gmail.com','Lokoja','Kogi ','Obajana','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 20:16:52',5,'765','2022-04-21 16:51:14','765'),(9,'','1','223','Yemdot Das','Victor','08066394144','@gmail.com','Lokoja','Kogi','Felele Basa Village  Phase 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-10 15:26:14',5,'765','2022-03-10 15:26:14','765'),(10,'','1','223','OBAMA GAS','DOMNIC OKFOF','08100619466','@gmail.com','Lokoja','Kogi ','FUL CROSHER','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-10 17:28:42',5,'765','2022-03-10 17:28:42','765'),(11,'','1','223','Ebuka  ','Ebuka Gas','08035291078','@gmail.com','Lokoja','Kogi','Pholy gate','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-12 08:45:55',5,'765','2022-03-12 08:45:55','765'),(12,'','1','223','BOLA BEST GAS','B0LA GAS','08107494077','@gmail.com','Lokoja','Kogi','Ize Shopping Complex, Along Kabba Road Orgaminana, Adavi L.G.A Kogi State.','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-12 10:48:34',5,'765','2022-04-27 11:13:36','765'),(13,'','1','223','I K GAS','I K GAS','08104481902','@gmail.com','Lokoja','Kogi','DONAMIS JUNCTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-13 11:33:02',5,'765','2022-03-13 11:33:02','765'),(14,'','1','223','JOE GAS','JOE','08104557196','@gmail.com','Lokoja','Kogi','Beside Mohco Gas, Assemble Quaters','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-16 08:39:13',5,'765','2022-03-16 08:39:13','765'),(15,'','1','223','LORD MERCY GAS','LORD MERCY ','07056246652','@gmail.com','Lokoja','Kogi','200 Housing Unit Junction','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-18 12:42:52',5,'765','2022-03-18 12:42:52','765'),(16,'','1','223','BANDA GAS','Muhammad Usman ','07047709862','@gmail.com','Lokoja','Kogi','Opposite Checking Point Band','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-25 18:10:14',5,'765','2022-03-25 18:10:14','765'),(17,'','1','223','TO GOD GAS','Muokwe Tochukwu','08139522007','@gmail.com','Lokoja','Kogi','New Market, Galili','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-31 09:44:03',5,'765','2022-03-31 09:44:03','765'),(18,'','1','223','Blessing Merch Gas','Blessing Merch Das','08035901300','@gmail.com','Lokoja','Kogi','31 New Market road Lokoja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-14 08:26:20',5,'765','2022-04-14 08:26:20','765'),(19,'','1','223','OLA BIYIS - GAS','OLA BIYIS ','07061501640','@gmail.com','SHERIA','Kogi','SHERIA BASSA LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-28 12:14:12',5,'765','2022-04-28 12:14:12','765'),(20,'','1','223','FLOURISH GAS','ZAINAB ','09074334708','@gmail.com','Lokoja','Kogi','KABA JUNCTION ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-28 12:59:38',5,'765','2022-08-20 17:37:37','765'),(21,'','1','223','GRAPJEEN GAS','ABDULFATAH ','08164875965','@gmail.com','Lokoja','Kogi ','ZANGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-07 15:38:38',5,'765','2022-07-07 15:38:38','765'),(22,'','1','223','AKOREDE GAS','MUMKOREDE','09166118291','@gmail.com','Lokoja','Kogi','FELELE, LOKOJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-07 18:50:26',5,'765','2022-07-07 18:50:26','765'),(23,'','1','223','ROSES RESTUARANT','GODWIN','08031379862','rosesrestuarant2022@gmail.com','Lokoja','Kogi','Beside polygate ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 12:30:34',5,'765','2022-07-23 12:30:34','765'),(24,'','1','223','YASH GAS','Mr. Yaks','08062863361','lokojalpgplant@gmail.com','Lokoja','Kogi','Okene','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-26 11:36:33',5,'765','2022-08-15 12:28:49','765'),(25,'','1','223','AFFAR GAS','Abdulmalik','09030865821','@gmail.com','Lokoja','Kogi','Felele Bustop','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-29 09:26:01',5,'765','2022-08-29 09:26:01','765'),(26,'','1','223','ABOGO GAS','Mr. Abogo','07065487006','@gmail.com','Lokoja','Kogi','Okene','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-29 17:01:08',5,'765','2022-08-29 17:01:08','765'),(27,'','1','223','JULIOLAD GAS','Eng yenka','08033778704','@gmail.com','Lokoja','Kogi','Kaba Junction','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-01 15:36:35',5,'765','2022-09-01 15:36:35','765'),(28,'','1','223','IDRIS A JAMES','08168757569','08168757569','nuraddeenbaffa700@gmail.com','LOKOJA','KOGI STATE','nuraddin@gmail.com','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-10 11:14:25',5,'765','2022-09-10 11:14:25','765'),(29,'','1','223','BAMMY O GAS','OGECHUKWU BAMIDELEI','08141148769','prttysound66@gmail.com','KOGI','KOGI STATE','ZANGO DAJI LOKOJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-02 09:50:43',5,'765','2022-10-02 09:50:43','765'),(30,'','1','223','EFIKPO GAS','OMOYELE','08027635820','busuyiomoyele@gmail.com','Lokoja','Kogi ','plot 5 wada road ganaja village','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-10 12:01:44',5,'765','2022-10-10 12:01:44','765'),(31,'','1','223','RAMCY GAS','Ladi TIjjani','08035780914','aarano@gmail.com','KOGI','KOGI STATE','200 UNIT ROAD 7','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-10 13:44:54',5,'765','2022-10-10 13:44:54','765'),(32,'','1','223','GIRINYA GAS','Chinonso christian Gas','09054893504','aarano@gmail.com','KOGI','KOGI STATE','Girinya Local GOVT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-12 06:55:53',5,'765','2022-10-12 06:55:53','765'),(33,'','1','223','MB GAS','Martha\'s bolarind ayorind ','07030909517','aaranogas@gmail.com','Lokoja ','Kogi ','Obajan ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-13 08:49:13',5,'765','2022-10-13 08:49:13','765'),(34,'','1','223','ALIYU ISYAKA','IDAH','07058370133','annurdanwanka@gmail.com','Lokoja','Kogi','IDAH LOKOJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-26 14:17:54',5,'765','2022-10-26 14:17:54','765'),(35,'','1','223','CRISTIAN GAS','PIUS ','08135154396','@gmail.com','KOTOKARFE LGA','Kogi','GRIAN TOWN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-13 18:11:04',5,'765','2022-11-13 18:11:04','765'),(36,'','1','223','LEINAD GAS','Leinad ventures','07010681289','@gmail.com','Lokoja','Kogi','OBAJANA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-26 09:09:51',5,'765','2022-11-26 09:09:51','765'),(37,'','1','223','OBANLA GAS','OBANLA ','07039118208','@gmail.com','Lokoja','Kogi','OBAJANA LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-12 11:20:30',5,'765','2022-12-12 11:20:30','765'),(38,'','1','223','YEMBANK GAS','Idah','07035104340','@gmail.com','Lokoja','Kogi ','Beside civil defence idah','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-17 10:38:30',5,'765','2022-12-17 10:38:30','765'),(39,'','1','223','FA GAS','FELELE','08065324912','annurdanwanka@gmail.com','Lokoja','Kogi ','POLY GATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-08 14:09:32',5,'765','2023-01-08 14:09:32','765'),(40,'','1','223','Mr. Dayo','Idah','08056462497','@gmail.com','IDAH','Kogi','Idah ajaka road','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-18 11:22:35',5,'765','2023-01-18 11:22:35','765'),(41,'','1','223','USMAN GAS','UNIT LAYOUT','07034363554','ubello19@gmail.com','Lokoja','Kogi ','NO. 31 UNIT LAYOUT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-11 12:27:18',5,'765','2023-02-11 12:27:18','765'),(42,'','1','223','DIVIN FAVORRE  GAS','OLNIKAWU A SAMUEL','08032372621','@gmail.com','Lokoja','Kogi','CRUSHER LOKOJA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-02 12:39:33',5,'765','2023-03-02 12:39:33','765');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','223','1',1,'5','LPG NOZZLE 1',50883.72,'','',NULL,NULL,'',5,'2022-03-02 14:17:07','487'),('1','223','1',2,'5','LPG NOZZLE 2',49974.99,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','223','1',3,'5','LPG NOZZLE 3',131018.09,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','223','1',4,'5','LPG NOZZLE 4',106010.93,'','',NULL,NULL,'',5,'2022-03-02 14:19:29','487');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=367 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','223',1,'DAILY SHIFT','2022-03-05','2022-03-05 08:00:43','2022-03-06 08:00:43','765',0.00,0.00,'765','2022-03-05 20:14:49','765','2022-03-05 20:15:16',10,0),('1','223',2,'DAILY SHIFT','2022-03-06','2022-03-06 08:16:35','2022-03-07 08:16:35','765',0.00,0.00,'765','2022-03-06 19:30:44','765','2022-03-06 19:31:25',10,0),('1','223',3,'DAILY SHIFT','2022-03-07','2022-03-07 07:49:02','2022-03-08 07:49:02','765',0.00,0.00,'765','2022-03-07 19:31:52','765','2022-03-07 19:32:20',10,0),('1','223',4,'DAILY SHIFT','2022-03-08','2022-03-08 07:18:25','2022-03-09 07:18:25','765',0.00,0.00,'765','2022-03-08 20:39:59','765','2022-03-08 20:40:24',10,0),('1','223',5,'DAILY SHIFT','2022-03-10','2022-03-10 07:18:04','2022-03-11 07:18:04','765',0.00,0.00,'765','2022-03-10 19:15:31','765','2022-03-10 19:15:55',10,0),('1','223',6,'DAILY SALES','2022-03-11','2022-03-11 07:53:48','2022-03-12 07:53:48','765',0.00,0.00,'765','2022-03-11 19:25:25','765','2022-03-11 19:25:47',10,0),('1','223',7,'DAILY SHIFT','2022-03-12','2022-03-12 07:24:28','2022-03-13 07:24:28','765',0.00,0.00,'765','2022-03-12 19:33:09','765','2022-03-12 19:33:34',10,0),('1','223',10,'DAILY SHIFT','2022-03-13','2022-03-13 07:21:11','2022-03-14 07:21:11','765',0.00,0.00,'765','2022-03-13 19:58:51','765','2022-03-13 19:59:15',10,0),('1','223',11,'DAILY SHIFT','2022-03-14','2022-03-14 07:08:35','2022-03-15 07:08:35','765',0.00,0.00,'765','2022-03-14 19:36:52','765','2022-03-14 19:37:11',10,0),('1','223',12,'DAILY SHIFT','2022-03-15','2022-03-15 07:42:54','2022-03-16 07:42:54','765',0.00,0.00,'765','2022-03-15 19:36:16','765','2022-03-15 19:36:31',10,0),('1','223',13,'DAILY SHIFT','2022-03-16','2022-03-16 06:51:30','2022-03-17 06:51:30','765',0.00,0.00,'765','2022-03-16 19:41:28','765','2022-03-16 19:41:54',10,0),('1','223',14,'DAILY SHIFT','2022-03-17','2022-03-17 07:08:44','2022-03-18 07:08:44','765',0.00,0.00,'765','2022-03-17 19:42:16','765','2022-03-17 19:42:35',10,0),('1','223',15,'DAILY SHIFT','2022-03-18','2022-03-18 07:04:35','2022-03-19 07:04:35','765',0.00,0.00,'765','2022-03-18 19:23:23','765','2022-03-18 19:23:43',10,0),('1','223',16,'DAILY SALES','2022-03-19','2022-03-19 07:05:39','2022-03-20 07:05:39','765',0.00,0.00,'765','2022-03-19 19:32:20','765','2022-03-19 19:32:37',10,0),('1','223',17,'DAILY SHIFT','2022-03-20','2022-03-20 07:06:10','2022-03-21 07:06:10','765',0.00,0.00,'765','2022-03-20 19:53:34','765','2022-03-20 19:53:55',10,0),('1','223',18,'DAILY SHIFT','2022-03-21','2022-03-21 07:12:00','2022-03-22 07:12:00','765',0.00,0.00,'765','2022-03-21 19:29:49','765','2022-03-21 19:30:11',10,0),('1','223',19,'DAILY SHIFT','2022-03-22','2022-03-22 07:50:02','2022-03-23 07:50:02','765',0.00,0.00,'765','2022-03-22 21:41:45','765','2022-03-22 21:42:07',10,0),('1','223',20,'OPPERATIONAL LOST','2022-03-22','2022-03-22 21:43:39','2022-03-23 21:43:39','765',0.00,0.00,'765','2022-03-22 21:51:35','765','2022-03-22 21:52:23',10,0),('1','223',21,'DAILY SHIFT','2022-03-22','2022-03-23 06:27:57','2022-03-24 06:27:57','765',0.00,0.00,'765','2022-03-23 06:32:43','765','2022-03-23 06:33:15',10,0),('1','223',22,'DAILY SHIFT','2022-03-23','2022-03-23 06:35:20','2022-03-24 06:35:20','765',0.00,0.00,'765','2022-03-23 20:04:24','765','2022-03-23 20:04:44',10,0),('1','223',23,'DAILY SHIFT','2022-03-24','2022-03-24 06:47:58','2022-03-25 06:47:58','765',0.00,0.00,'765','2022-03-24 19:41:53','765','2022-03-24 19:42:55',10,0),('1','223',24,'DAILY SHIFT','2022-03-25','2022-03-25 06:46:13','2022-03-26 06:46:13','765',0.00,0.00,'765','2022-03-25 19:23:54','765','2022-03-25 19:24:23',10,0),('1','223',25,'DAILY SHIFT','2022-03-26','2022-03-26 07:19:48','2022-03-27 07:19:48','765',0.00,0.00,'765','2022-03-26 19:31:26','765','2022-03-26 19:32:02',10,0),('1','223',26,'DAILY SHIFT','2022-03-27','2022-03-27 07:00:39','2022-03-28 07:00:39','765',0.00,0.00,'765','2022-03-27 19:36:23','765','2022-03-27 19:36:56',10,0),('1','223',27,'DAILY SHIFT','2022-03-28','2022-03-28 07:01:06','2022-03-29 07:01:06','765',0.00,0.00,'765','2022-03-28 19:40:36','765','2022-03-28 19:41:08',10,0),('1','223',28,'DAILY SHIFT','2022-03-29','2022-03-29 07:02:58','2022-03-30 07:02:58','765',0.00,0.00,'765','2022-03-29 19:28:23','765','2022-03-29 19:28:43',10,0),('1','223',29,'DAILY SHIFT','2022-03-30','2022-03-30 07:01:02','2022-03-31 07:01:02','765',0.00,0.00,'765','2022-03-30 20:04:16','765','2022-03-30 20:04:37',10,0),('1','223',30,'DAILY SHIFT','2022-03-31','2022-03-31 07:26:28','2022-04-01 07:26:28','765',0.00,0.00,'765','2022-03-31 19:17:04','765','2022-03-31 19:17:24',10,0),('1','223',31,'DAILY SHIFT','2022-04-01','2022-04-01 07:09:26','2022-04-02 07:09:26','765',0.00,0.00,'765','2022-04-01 19:51:46','765','2022-04-01 19:52:08',10,0),('1','223',32,'DAILY SHIFT','2022-04-02','2022-04-02 07:07:10','2022-04-03 07:07:10','765',0.00,0.00,'765','2022-04-02 20:39:14','765','2022-04-02 20:39:37',10,0),('1','223',33,'DAILY SHIFT','2022-04-03','2022-04-03 07:14:04','2022-04-04 07:14:04','765',0.00,0.00,'765','2022-04-03 19:30:51','765','2022-04-03 19:31:10',10,0),('1','223',34,'DAILY SHIFT','2022-04-04','2022-04-04 07:18:51','2022-04-05 07:18:51','765',0.00,0.00,'765','2022-04-04 19:41:04','765','2022-04-04 19:41:22',10,0),('1','223',35,'DAILY SHIFT','2022-04-05','2022-04-05 07:01:22','2022-04-06 07:01:22','765',0.00,0.00,'765','2022-04-05 19:29:35','765','2022-04-05 19:30:05',10,0),('1','223',36,'DAILY SHIFT','2022-04-06','2022-04-06 07:10:13','2022-04-07 07:10:13','765',0.00,0.00,'765','2022-04-06 19:24:41','765','2022-04-06 19:24:59',10,0),('1','223',37,'DAILY SHIFT','2022-04-07','2022-04-07 07:02:56','2022-04-08 07:02:56','765',0.00,0.00,'765','2022-04-08 07:21:34','765','2022-04-08 07:24:04',10,0),('1','223',38,'OPPERATIONAL LOST','2022-04-08','2022-04-08 08:44:13','2022-04-09 08:44:13','765',0.00,0.00,'765','2022-04-08 08:48:16','765','2022-04-08 08:48:33',10,0),('1','223',39,'DAILY SHIFT','2022-04-08','2022-04-08 09:22:32','2022-04-09 09:22:32','765',0.00,0.00,'765','2022-04-08 19:38:18','765','2022-04-08 19:38:35',10,0),('1','223',40,'DAILY SHIFT','2022-04-09','2022-04-09 07:14:28','2022-04-10 07:14:28','765',0.00,0.00,'765','2022-04-09 19:11:58','765','2022-04-09 19:12:19',10,0),('1','223',41,'DAILY SHIFT','2022-04-10','2022-04-10 07:17:26','2022-04-11 07:17:26','765',0.00,0.00,'765','2022-04-10 19:54:54','765','2022-04-10 19:55:11',10,0),('1','223',42,'DAILY SHIFT','2022-04-11','2022-04-11 07:25:26','2022-04-12 07:25:26','765',0.00,0.00,'765','2022-04-11 19:15:08','765','2022-04-11 19:15:25',10,0),('1','223',43,'DAILY SHIFT','2022-04-12','2022-04-12 08:19:36','2022-04-13 08:19:36','765',0.00,0.00,'765','2022-04-12 15:12:20','765','2022-04-12 15:12:37',10,0),('1','223',44,'DAILY SHIFT','2022-04-13','2022-04-13 09:21:26','2022-04-14 09:21:26','765',0.00,0.00,'765','2022-04-13 09:25:24','765','2022-04-13 09:25:40',10,0),('1','223',45,'DAILY SHIFT','2022-04-13','2022-04-13 09:26:02','2022-04-14 09:26:02','765',0.00,0.00,'765','2022-04-13 20:57:30','765','2022-04-13 20:57:51',10,0),('1','223',46,'DAILY SHIFT','2022-04-14','2022-04-14 07:32:22','2022-04-15 07:32:22','765',0.00,0.00,'765','2022-04-14 19:42:30','765','2022-04-14 19:42:52',10,0),('1','223',47,'DAILY SHIFT','2022-04-15','2022-04-15 07:12:02','2022-04-16 07:12:02','765',0.00,0.00,'765','2022-04-15 19:38:28','765','2022-04-15 19:38:47',10,0),('1','223',48,'DAILY SALES','2022-04-16','2022-04-16 07:21:37','2022-04-17 07:21:37','765',0.00,0.00,'765','2022-04-16 20:19:06','765','2022-04-16 20:19:25',10,0),('1','223',49,'DAILY SHIFT','2022-04-17','2022-04-17 05:43:46','2022-04-18 05:43:46','765',0.00,0.00,'765','2022-04-17 19:25:50','765','2022-04-17 19:26:13',10,0),('1','223',50,'DAILY SALES','2022-04-18','2022-04-18 07:11:04','2022-04-19 07:11:04','765',0.00,0.00,'765','2022-04-18 19:47:28','765','2022-04-18 19:47:53',10,0),('1','223',51,'DAILY SALES','2022-04-19','2022-04-19 06:50:17','2022-04-20 06:50:17','765',0.00,0.00,'765','2022-04-19 11:53:58','765','2022-04-19 11:54:14',10,0),('1','223',52,'OPERATINAL LOST','2022-04-20','2022-04-20 07:24:42','2022-04-21 07:24:42','765',0.00,0.00,'765','2022-04-20 07:34:12','765','2022-04-20 07:34:31',10,0),('1','223',53,'DAILY SHIFT','2022-04-20','2022-04-20 07:34:58','2022-04-21 07:34:58','765',0.00,0.00,'765','2022-04-20 19:41:40','765','2022-04-20 19:41:57',10,0),('1','223',54,'DAILY SHIFT','2022-04-21','2022-04-21 06:41:18','2022-04-22 06:41:18','765',0.00,0.00,'765','2022-04-21 21:30:56','765','2022-04-21 21:31:14',10,0),('1','223',55,'DAILY SHIFT','2022-04-22','2022-04-22 07:07:13','2022-04-23 07:07:13','765',0.00,0.00,'765','2022-04-22 19:39:06','765','2022-04-22 19:39:30',10,0),('1','223',56,'DAILY SHIFT','2022-04-23','2022-04-23 07:03:28','2022-04-24 07:03:28','765',0.00,0.00,'765','2022-04-23 18:50:39','765','2022-04-23 18:51:19',10,0),('1','223',57,'DAILY SHIFT','2022-04-24','2022-04-24 07:44:31','2022-04-25 07:44:31','765',0.00,0.00,'765','2022-04-24 19:56:05','765','2022-04-24 19:56:23',10,0),('1','223',58,'DAILY SALES','2022-04-25','2022-04-25 06:52:02','2022-04-26 06:52:02','765',0.00,0.00,'765','2022-04-25 20:04:21','765','2022-04-25 20:04:38',10,0),('1','223',59,'DAILY SHIFT','2022-04-26','2022-04-26 07:16:09','2022-04-27 07:16:09','765',0.00,0.00,'765','2022-04-26 09:56:30','765','2022-04-26 09:56:50',10,0),('1','223',60,'OPERATINAL LOST','2022-04-26','2022-04-26 09:57:18','2022-04-27 09:57:18','765',0.00,0.00,'765','2022-04-26 10:01:02','765','2022-04-26 10:01:21',10,0),('1','223',61,'DAILY SALES','2022-04-27','2022-04-27 12:28:33','2022-04-28 12:28:33','765',0.00,0.00,'765','2022-04-27 19:52:49','765','2022-04-27 20:06:46',10,0),('1','223',62,'DAILY SALES','2022-04-28','2022-04-28 07:23:16','2022-04-29 07:23:16','765',0.00,0.00,'765','2022-04-28 19:38:03','765','2022-04-28 19:38:21',10,0),('1','223',63,'DAILY SHIFT','2022-04-29','2022-04-29 07:57:31','2022-04-30 07:57:31','765',0.00,0.00,'765','2022-04-29 19:30:39','765','2022-04-29 19:30:58',10,0),('1','223',64,'DAILY SHIFT','2022-04-30','2022-04-30 07:30:29','2022-05-01 07:30:29','765',0.00,0.00,'765','2022-04-30 19:45:51','765','2022-04-30 19:46:15',10,0),('1','223',65,'OPERATINAL LOST','2022-05-01','2022-05-01 07:24:49','2022-05-02 07:24:49','765',0.00,0.00,'765','2022-05-01 11:17:28','765','2022-05-01 11:17:53',10,0),('1','223',66,'DAILY SALES','2022-05-01','2022-05-01 18:35:28','2022-05-02 18:35:28','765',0.00,0.00,'765','2022-05-01 19:38:33','765','2022-05-01 19:39:01',10,0),('1','223',67,'DAILY SHIFT','2022-05-02','2022-05-02 10:12:56','2022-05-03 10:12:56','765',0.00,0.00,'765','2022-05-02 19:25:52','765','2022-05-02 19:26:20',10,0),('1','223',68,'DAILY SHIFT','2022-05-03','2022-05-03 07:23:10','2022-05-04 07:23:10','765',0.00,0.00,'765','2022-05-03 19:27:34','765','2022-05-03 19:27:54',10,0),('1','223',69,'DAILY SHIFT','2022-05-04','2022-05-04 08:17:15','2022-05-05 08:17:15','765',0.00,0.00,'765','2022-05-04 18:59:17','765','2022-05-04 18:59:35',10,0),('1','223',70,'DAILY SALES','2022-05-05','2022-05-05 07:03:19','2022-05-06 07:03:19','765',0.00,0.00,'765','2022-05-05 19:37:48','765','2022-05-05 19:38:08',10,0),('1','223',71,'DAILY SHIFT','2022-05-06','2022-05-06 06:50:48','2022-05-07 06:50:48','765',0.00,0.00,'765','2022-05-06 19:11:02','765','2022-05-06 19:11:16',10,0),('1','223',72,'DAILY SALES','2022-05-07','2022-05-07 07:00:26','2022-05-08 07:00:26','765',0.00,0.00,'765','2022-05-07 19:31:53','765','2022-05-07 19:32:09',10,0),('1','223',73,'DAILY SALES','2022-05-08','2022-05-08 07:03:29','2022-05-09 07:03:29','765',0.00,0.00,'765','2022-05-08 18:55:02','765','2022-05-08 18:55:31',10,0),('1','223',74,'DAILY SHIFT','2022-05-09','2022-05-09 07:16:18','2022-05-10 07:16:18','765',0.00,0.00,'765','2022-05-09 19:32:49','765','2022-05-09 19:33:08',10,0),('1','223',75,'DAILY SALES','2022-05-10','2022-05-10 07:11:35','2022-05-11 07:11:35','765',0.00,0.00,'765','2022-05-10 19:46:50','765','2022-05-10 19:47:18',10,0),('1','223',76,'DAILY SHIFT','2022-05-11','2022-05-11 06:40:43','2022-05-12 06:40:43','765',0.00,0.00,'765','2022-05-11 15:24:56','765','2022-05-11 15:25:33',10,0),('1','223',77,'OPERATINAL LOST','2022-05-11','2022-05-11 16:28:07','2022-05-12 16:28:07','765',0.00,0.00,'765','2022-05-11 16:30:29','765','2022-05-11 16:30:44',10,0),('1','223',78,'DAILY SHIFT','2022-05-11','2022-05-11 20:13:43','2022-05-12 20:13:43','765',0.00,0.00,'765','2022-05-11 20:17:03','765','2022-05-11 20:17:21',10,0),('1','223',79,'DAILY SALES','2022-05-12','2022-05-12 06:27:17','2022-05-13 06:27:17','765',0.00,0.00,'765','2022-05-12 19:43:30','765','2022-05-12 19:43:49',10,0),('1','223',80,'DAILY SHIFT','2022-05-13','2022-05-13 06:56:04','2022-05-14 06:56:04','765',0.00,0.00,'765','2022-05-13 19:47:01','765','2022-05-13 19:47:23',10,0),('1','223',81,'DAILY SHIFT','2022-05-14','2022-05-14 07:02:14','2022-05-15 07:02:14','765',0.00,0.00,'765','2022-05-14 19:27:59','765','2022-05-14 19:28:15',10,0),('1','223',82,'DAILY SHIFT','2022-05-15','2022-05-15 06:47:54','2022-05-16 06:47:54','765',0.00,0.00,'765','2022-05-15 19:15:30','765','2022-05-15 19:15:46',10,0),('1','223',83,'DAILY SHIFT','2022-05-16','2022-05-16 07:16:33','2022-05-17 07:16:33','765',0.00,0.00,'765','2022-05-16 19:23:16','765','2022-05-16 19:23:33',10,0),('1','223',84,'DAILY SHIFTt','2022-05-17','2022-05-17 07:14:13','2022-05-18 07:14:13','765',0.00,0.00,'765','2022-05-17 19:11:38','765','2022-05-17 19:11:54',10,0),('1','223',85,'DAILY SHIFT','2022-05-18','2022-05-18 07:06:29','2022-05-19 07:06:29','765',0.00,0.00,'765','2022-05-18 19:33:48','765','2022-05-18 19:35:13',10,0),('1','223',86,'DAILY SHIFT','2022-05-19','2022-05-19 07:01:49','2022-05-20 07:01:49','765',0.00,0.00,'765','2022-05-19 14:51:13','765','2022-05-19 14:51:33',10,0),('1','223',87,'DAILY SALES','2022-05-30','2022-05-30 07:21:25','2022-05-31 07:21:25','765',0.00,0.00,'765','2022-05-30 20:25:39','765','2022-05-30 20:27:39',10,0),('1','223',88,'DAILY SALES','2022-07-04','2022-07-04 15:09:12','2022-07-05 15:09:12','765',0.00,0.00,'765','2022-07-04 15:17:27','765','2022-07-04 15:17:54',10,0),('1','223',89,'OPERATINAL LOST','2022-07-04','2022-07-04 15:18:22','2022-07-05 15:18:22','765',0.00,0.00,'765','2022-07-04 15:35:51','765','2022-07-04 15:36:06',10,0),('1','223',90,'DAILY SALES','2022-07-04','2022-07-04 15:51:34','2022-07-05 15:51:34','765',0.00,0.00,'765','2022-07-04 19:17:43','765','2022-07-04 19:18:00',10,0),('1','223',91,'DAILY SALES','2022-07-05','2022-07-05 07:19:43','2022-07-06 07:19:43','765',0.00,0.00,'765','2022-07-05 19:29:41','765','2022-07-05 19:29:59',10,0),('1','223',92,'DAILY SALES','2022-07-06','2022-07-06 07:10:51','2022-07-07 07:10:51','765',0.00,0.00,'765','2022-07-06 19:51:12','765','2022-07-06 19:51:37',10,0),('1','223',93,'DAILY SALES','2022-07-07','2022-07-07 07:33:25','2022-07-08 07:33:25','765',0.00,0.00,'765','2022-07-07 19:42:13','765','2022-07-07 19:42:36',10,0),('1','223',94,'DAILY SALES','2022-07-08','2022-07-08 07:17:17','2022-07-09 07:17:17','765',0.00,0.00,'765','2022-07-08 20:18:03','765','2022-07-08 20:19:26',10,0),('1','223',95,'DAILY SALES','2022-07-09','2022-07-09 11:05:07','2022-07-10 11:05:07','765',0.00,0.00,'765','2022-07-09 18:58:59','765','2022-07-09 18:59:17',10,0),('1','223',96,'DAILY SALES','2022-07-10','2022-07-10 07:35:40','2022-07-11 07:35:40','765',0.00,0.00,'765','2022-07-10 16:09:52','765','2022-07-10 16:10:09',10,0),('1','223',97,'OPERATINAL LOST','2022-07-10','2022-07-10 16:10:44','2022-07-11 16:10:44','765',0.00,0.00,'765','2022-07-10 16:15:47','765','2022-07-10 16:16:00',10,0),('1','223',98,'DAILY SALES','2022-07-10','2022-07-10 16:17:40','2022-07-11 16:17:40','765',0.00,0.00,'765','2022-07-10 18:51:13','765','2022-07-10 18:51:35',10,0),('1','223',99,'DAILY SALES','2022-07-11','2022-07-11 07:11:24','2022-07-12 07:11:24','765',0.00,0.00,'765','2022-07-11 19:14:53','765','2022-07-11 19:15:09',10,0),('1','223',100,'DAILY SALES','2022-07-12','2022-07-12 07:10:22','2022-07-13 07:10:22','765',0.00,0.00,'765','2022-07-12 19:23:42','765','2022-07-12 19:23:56',10,0),('1','223',101,'DAILY SALES','2022-07-13','2022-07-13 07:41:09','2022-07-14 07:41:09','765',0.00,0.00,'765','2022-07-13 19:26:27','765','2022-07-13 19:26:42',10,0),('1','223',102,'DAILY SALES','2022-07-14','2022-07-14 06:58:49','2022-07-15 06:58:49','765',0.00,0.00,'765','2022-07-14 19:47:10','765','2022-07-14 19:47:31',10,0),('1','223',103,'DAILY SALES','2022-07-15','2022-07-15 07:07:36','2022-07-16 07:07:36','765',0.00,0.00,'765','2022-07-15 19:38:13','765','2022-07-15 19:38:30',10,0),('1','223',104,'DAILY SALES','2022-07-16','2022-07-16 07:37:43','2022-07-17 07:37:43','765',0.00,0.00,'765','2022-07-16 20:09:51','765','2022-07-16 20:10:23',10,0),('1','223',105,'OPERATINAL LOST','2022-07-17','2022-07-17 07:58:24','2022-07-18 07:58:24','765',0.00,0.00,'765','2022-07-17 08:01:24','765','2022-07-17 08:01:40',10,0),('1','223',106,'DAILY SALES','2022-07-17','2022-07-17 08:02:08','2022-07-18 08:02:08','765',0.00,0.00,'765','2022-07-17 19:55:30','765','2022-07-17 19:55:51',10,0),('1','223',107,'DAILY SALES','2022-07-18','2022-07-18 07:38:38','2022-07-19 07:38:38','765',0.00,0.00,'765','2022-07-18 19:16:43','765','2022-07-18 19:17:01',10,0),('1','223',108,'DAILY SALES','2022-07-19','2022-07-19 07:19:25','2022-07-20 07:19:25','765',0.00,0.00,'765','2022-07-19 18:42:45','765','2022-07-19 18:43:11',10,0),('1','223',109,'DAILY SALES','2022-07-20','2022-07-20 07:13:00','2022-07-21 07:13:00','765',0.00,0.00,'765','2022-07-20 19:15:43','765','2022-07-20 19:15:59',10,0),('1','223',110,'DAILY SALES','2022-07-21','2022-07-21 06:54:22','2022-07-22 06:54:22','765',0.00,0.00,'765','2022-07-21 19:03:31','765','2022-07-21 19:10:06',10,0),('1','223',111,'DAILY SALES','2022-07-22','2022-07-22 07:02:27','2022-07-23 07:02:27','765',0.00,0.00,'765','2022-07-22 19:31:23','765','2022-07-22 19:31:41',10,0),('1','223',112,'DAILY SHIFT','2022-07-23','2022-07-23 06:49:10','2022-07-24 06:49:10','765',0.00,0.00,'765','2022-07-23 19:17:55','765','2022-07-23 19:18:11',10,0),('1','223',113,'DAILY SALES','2022-07-24','2022-07-24 07:08:59','2022-07-25 07:08:59','765',0.00,0.00,'765','2022-07-24 19:22:39','765','2022-07-24 19:23:28',10,0),('1','223',114,'DAILY SALES','2022-07-25','2022-07-25 07:19:21','2022-07-26 07:19:21','765',0.00,0.00,'765','2022-07-25 19:37:40','765','2022-07-25 19:38:14',10,0),('1','223',115,'DAILY SALES','2022-07-26','2022-07-26 08:00:51','2022-07-27 08:00:51','765',0.00,0.00,'765','2022-07-26 19:17:48','765','2022-07-26 19:18:25',10,0),('1','223',116,'OPERATIONAL LOST','2022-07-27','2022-07-27 09:23:35','2022-07-28 09:23:35','765',0.00,0.00,'765','2022-07-27 09:29:15','765','2022-07-27 09:29:39',10,0),('1','223',117,'OPERATINAL LOST','2022-07-28','2022-07-28 07:10:49','2022-07-29 07:10:49','765',0.00,0.00,'765','2022-07-28 07:16:55','765','2022-07-28 07:17:19',10,0),('1','223',118,'DAILY SALES','2022-07-28','2022-07-28 07:27:42','2022-07-29 07:27:42','765',0.00,0.00,'765','2022-07-28 19:27:27','765','2022-07-28 19:27:43',10,0),('1','223',119,'DAILY SALES','2022-07-29','2022-07-29 07:10:42','2022-07-30 07:10:42','765',0.00,0.00,'765','2022-07-29 19:29:08','765','2022-07-29 19:29:27',10,0),('1','223',120,'DAILY SALES','2022-07-30','2022-07-30 07:13:03','2022-07-31 07:13:03','765',0.00,0.00,'765','2022-07-30 19:18:55','765','2022-07-30 19:19:15',10,0),('1','223',121,'DAILY SALES','2022-07-31','2022-07-31 07:43:52','2022-08-01 07:43:52','765',0.00,0.00,'765','2022-07-31 19:05:33','765','2022-07-31 19:05:49',10,0),('1','223',122,'DAILY SALES','2022-08-01','2022-08-01 07:05:41','2022-08-02 07:05:41','765',0.00,0.00,'765','2022-08-01 19:02:09','765','2022-08-01 19:02:29',10,0),('1','223',123,'DAILY SALES ','2022-08-02','2022-08-02 07:04:13','2022-08-03 07:04:13','765',0.00,0.00,'765','2022-08-02 19:51:06','765','2022-08-02 19:51:25',10,0),('1','223',124,'DAILY SALES ','2022-08-03','2022-08-03 06:57:23','2022-08-04 06:57:23','765',0.00,0.00,'765','2022-08-03 19:26:17','765','2022-08-03 19:26:39',10,0),('1','223',125,'DAILY SALES','2022-08-04','2022-08-04 06:59:50','2022-08-05 06:59:50','765',0.00,0.00,'765','2022-08-04 19:29:44','765','2022-08-04 19:48:00',10,0),('1','223',126,'DAILY SALES','2022-08-05','2022-08-05 07:00:16','2022-08-06 07:00:16','765',0.00,0.00,'765','2022-08-05 19:10:55','765','2022-08-05 19:11:15',10,0),('1','223',127,'DAILY SALES','2022-08-06','2022-08-06 06:38:20','2022-08-07 06:38:20','765',0.00,0.00,'765','2022-08-06 15:30:13','765','2022-08-06 15:30:35',10,0),('1','223',128,'OPERATINAL LOST','2022-08-06','2022-08-06 15:31:04','2022-08-07 15:31:04','765',0.00,0.00,'765','2022-08-06 15:33:40','765','2022-08-06 15:33:58',10,0),('1','223',129,'DAILY SALES','2022-08-06','2022-08-06 15:36:16','2022-08-07 15:36:16','765',0.00,0.00,'765','2022-08-06 19:16:04','765','2022-08-06 19:16:21',10,0),('1','223',130,'DAILY SALES','2022-08-07','2022-08-07 07:19:18','2022-08-08 07:19:18','765',0.00,0.00,'765','2022-08-07 18:52:53','765','2022-08-07 18:53:09',10,0),('1','223',131,'DAILY SALES','2022-08-08','2022-08-08 07:15:06','2022-08-09 07:15:06','765',0.00,0.00,'765','2022-08-08 19:02:58','765','2022-08-08 19:03:25',10,0),('1','223',132,'DAILY SALES','2022-08-09','2022-08-09 07:08:02','2022-08-10 07:08:02','765',0.00,0.00,'765','2022-08-09 19:03:50','765','2022-08-09 19:04:06',10,0),('1','223',133,'DAILY SALES','2022-08-10','2022-08-10 07:11:23','2022-08-11 07:11:23','765',0.00,0.00,'765','2022-08-10 11:41:53','765','2022-08-10 12:01:38',10,0),('1','223',134,'OPERATINAL LOST','2022-08-10','2022-08-10 12:01:56','2022-08-11 12:01:56','765',0.00,0.00,'765','2022-08-10 12:04:27','765','2022-08-10 12:04:42',10,0),('1','223',135,'DAILY SALES','2022-08-10','2022-08-10 12:18:41','2022-08-11 12:18:41','765',0.00,0.00,'765','2022-08-10 19:06:11','765','2022-08-10 19:06:32',10,0),('1','223',136,'DAILY SALES','2022-08-11','2022-08-11 07:09:54','2022-08-12 07:09:54','765',0.00,0.00,'765','2022-08-11 19:29:41','765','2022-08-11 19:29:57',10,0),('1','223',137,'DAILY SALES','2022-08-12','2022-08-12 07:04:13','2022-08-13 07:04:13','765',0.00,0.00,'765','2022-08-12 18:48:45','765','2022-08-12 18:50:31',10,0),('1','223',138,'DAILY SALES','2022-08-13','2022-08-13 07:23:29','2022-08-14 07:23:29','765',0.00,0.00,'765','2022-08-13 19:15:07','765','2022-08-13 19:15:25',10,0),('1','223',139,'DAILY SALES','2022-08-14','2022-08-14 07:08:49','2022-08-15 07:08:49','765',0.00,0.00,'765','2022-08-14 19:20:42','765','2022-08-14 19:21:04',10,0),('1','223',140,'DAILY SALES','2022-08-15','2022-08-15 07:13:54','2022-08-16 07:13:54','765',0.00,0.00,'765','2022-08-15 19:31:57','765','2022-08-15 19:32:13',10,0),('1','223',141,'DAILY SALES','2022-08-16','2022-08-16 07:16:02','2022-08-17 07:16:02','765',0.00,0.00,'765','2022-08-16 19:04:14','765','2022-08-16 19:04:38',10,0),('1','223',142,'DAILY SALES','2022-08-17','2022-08-17 06:49:35','2022-08-18 06:49:35','765',0.00,0.00,'765','2022-08-17 19:08:05','765','2022-08-17 19:08:24',10,0),('1','223',143,'DAILY SALES','2022-08-18','2022-08-18 07:02:09','2022-08-19 07:02:09','765',0.00,0.00,'765','2022-08-18 19:26:56','765','2022-08-18 19:27:17',10,0),('1','223',144,'DAILY SALES','2022-08-19','2022-08-19 07:05:38','2022-08-20 07:05:38','765',0.00,0.00,'765','2022-08-19 19:11:35','765','2022-08-19 19:11:52',10,0),('1','223',145,'OPERATIONAL LOST','2022-08-20','2022-08-20 05:57:33','2022-08-21 05:57:33','765',0.00,0.00,'765','2022-08-20 06:17:04','765','2022-08-20 06:17:58',10,0),('1','223',146,'DAILY SALES','2022-08-20','2022-08-20 06:26:11','2022-08-21 06:26:11','765',0.00,0.00,'765','2022-08-20 19:09:01','765','2022-08-20 19:09:29',10,0),('1','223',147,'DAILY SALES','2022-08-21','2022-08-21 07:08:41','2022-08-22 07:08:41','765',0.00,0.00,'765','2022-08-21 19:10:16','765','2022-08-21 19:10:32',10,0),('1','223',148,'DAILY SALES','2022-08-22','2022-08-22 06:58:24','2022-08-23 06:58:24','765',0.00,0.00,'765','2022-08-22 19:12:45','765','2022-08-22 19:12:59',10,0),('1','223',149,'DAILY SALES','2022-08-23','2022-08-23 06:53:22','2022-08-24 06:53:22','765',0.00,0.00,'765','2022-08-23 17:32:49','765','2022-08-23 17:33:16',10,0),('1','223',150,'OPERATINAL LOST','2022-08-23','2022-08-23 17:37:53','2022-08-24 17:37:53','765',0.00,0.00,'765','2022-08-23 17:55:02','765','2022-08-23 17:55:18',10,0),('1','223',151,'DAILY SALES','2022-08-23','2022-08-23 17:56:41','2022-08-24 17:56:41','765',0.00,0.00,'765','2022-08-23 19:12:39','765','2022-08-23 19:12:55',10,0),('1','223',152,'DAILY SALES','2022-08-24','2022-08-24 07:03:38','2022-08-25 07:03:38','765',0.00,0.00,'765','2022-08-24 19:05:23','765','2022-08-24 19:05:41',10,0),('1','223',153,'DAILY SALES','2022-08-25','2022-08-25 06:53:22','2022-08-26 06:53:22','765',0.00,0.00,'765','2022-08-25 19:18:49','765','2022-08-25 19:19:13',10,0),('1','223',154,'DAILY SHIFT','2022-08-26','2022-08-26 07:19:31','2022-08-27 07:19:31','765',0.00,0.00,'765','2022-08-26 18:20:54','765','2022-08-26 18:21:22',10,0),('1','223',155,'OPPERATIONAL LOST','2022-08-26','2022-08-26 23:14:45','2022-08-27 23:14:45','765',0.00,0.00,'765','2022-08-26 23:25:53','765','2022-08-26 23:26:12',10,0),('1','223',156,'DAILY SALES','2022-08-28','2022-08-28 17:19:26','2022-08-29 17:19:26','765',0.00,0.00,'765','2022-08-28 19:06:45','765','2022-08-28 19:07:02',10,0),('1','223',157,'DAILY SALES','2022-08-29','2022-08-29 06:47:49','2022-08-30 06:47:49','765',0.00,0.00,'765','2022-08-29 19:19:32','765','2022-08-29 19:19:55',10,0),('1','223',158,'DAILY SALES','2022-08-30','2022-08-30 08:47:14','2022-08-31 08:47:14','765',0.00,0.00,'765','2022-08-30 19:04:20','765','2022-08-30 19:04:34',10,0),('1','223',159,'DAILY SALES','2022-08-31','2022-08-31 07:26:55','2022-09-01 07:26:55','765',0.00,0.00,'765','2022-08-31 19:20:32','765','2022-08-31 19:20:48',10,0),('1','223',160,'OPERATIONAL LOST','2022-09-01','2022-09-01 05:59:04','2022-09-02 05:59:04','765',0.00,0.00,'765','2022-09-01 06:02:24','765','2022-09-01 06:02:43',10,0),('1','223',161,'DAILY SALES','2022-09-01','2022-09-01 06:05:48','2022-09-02 06:05:48','765',0.00,0.00,'765','2022-09-01 19:05:20','765','2022-09-01 19:05:38',10,0),('1','223',162,'DAILY SALES','2022-09-02','2022-09-02 07:03:40','2022-09-03 07:03:40','765',0.00,0.00,'765','2022-09-02 19:03:52','765','2022-09-02 19:04:14',10,0),('1','223',163,'DAILY SALES','2022-09-03','2022-09-03 07:39:17','2022-09-04 07:39:17','765',0.00,0.00,'765','2022-09-03 07:39:44','765','2022-09-03 07:42:33',10,0),('1','223',164,'DAILY SALES ','2022-09-03','2022-09-03 07:43:33','2022-09-04 07:43:33','765',0.00,0.00,'765','2022-09-03 19:01:31','765','2022-09-03 19:01:53',10,0),('1','223',165,'DAILY SALES','2022-09-04','2022-09-04 06:50:00','2022-09-05 06:50:00','765',0.00,0.00,'765','2022-09-04 14:10:20','765','2022-09-04 14:11:38',10,0),('1','223',166,'OPERATINAL LOST','2022-09-04','2022-09-04 14:12:44','2022-09-05 14:12:44','765',0.00,0.00,'765','2022-09-04 14:21:04','765','2022-09-04 14:22:43',10,0),('1','223',167,'DAILY SALES','2022-09-05','2022-09-05 06:10:34','2022-09-06 06:10:34','765',0.00,0.00,'765','2022-09-05 19:30:59','765','2022-09-05 19:31:15',10,0),('1','223',168,'DAILY SALES','2022-09-06','2022-09-06 07:03:22','2022-09-07 07:03:22','765',0.00,0.00,'765','2022-09-06 18:55:08','765','2022-09-06 18:55:30',10,0),('1','223',169,'DAILY SALES','2022-09-07','2022-09-07 06:47:30','2022-09-08 06:47:30','765',0.00,0.00,'765','2022-09-07 11:56:52','765','2022-09-07 11:59:22',10,0),('1','223',170,'OPERATINAL LOST','2022-09-07','2022-09-07 12:07:30','2022-09-08 12:07:30','765',0.00,0.00,'765','2022-09-07 12:14:01','765','2022-09-07 12:14:16',10,0),('1','223',171,'DAILY SALES ','2022-09-07','2022-09-07 14:13:12','2022-09-08 14:13:12','765',0.00,0.00,'765','2022-09-07 19:04:44','765','2022-09-07 19:05:03',10,0),('1','223',172,'DAILY SALES','2022-09-08','2022-09-08 07:16:22','2022-09-09 07:16:22','765',0.00,0.00,'765','2022-09-08 19:22:51','765','2022-09-08 19:23:52',10,0),('1','223',173,'DAILY SALES','2022-09-09','2022-09-09 07:03:11','2022-09-10 07:03:11','765',0.00,0.00,'765','2022-09-09 19:15:02','765','2022-09-09 19:15:21',10,0),('1','223',174,'DAILY SALES','2022-09-10','2022-09-10 09:47:20','2022-09-11 09:47:20','765',0.00,0.00,'765','2022-09-10 17:10:30','765','2022-09-10 17:10:49',10,0),('1','223',175,'OPERATIONAL LOST','2022-09-11','2022-09-11 14:25:53','2022-09-12 14:25:53','765',0.00,0.00,'765','2022-09-11 14:28:53','765','2022-09-11 14:29:15',10,0),('1','223',176,'DAILY SALES','2022-09-11','2022-09-11 17:24:53','2022-09-12 17:24:53','765',0.00,0.00,'765','2022-09-11 18:48:18','765','2022-09-11 18:48:36',10,0),('1','223',177,'DAILY SALES','2022-09-12','2022-09-12 06:42:28','2022-09-13 06:42:28','765',0.00,0.00,'765','2022-09-12 19:13:36','765','2022-09-12 19:13:58',10,0),('1','223',178,'DAILY SALES','2022-09-13','2022-09-13 07:06:18','2022-09-14 07:06:18','765',0.00,0.00,'765','2022-09-13 18:55:43','765','2022-09-13 18:55:59',10,0),('1','223',179,'DAILY SALES','2022-09-14','2022-09-14 06:50:44','2022-09-15 06:50:44','765',0.00,0.00,'765','2022-09-14 19:37:38','765','2022-09-14 19:37:58',10,0),('1','223',180,'DAILY SALES ','2022-09-15','2022-09-15 07:07:33','2022-09-16 07:07:33','765',0.00,0.00,'765','2022-09-15 19:02:08','765','2022-09-15 19:02:30',10,0),('1','223',181,'DAILY SALES','2022-09-16','2022-09-16 07:01:44','2022-09-17 07:01:44','765',0.00,0.00,'765','2022-09-16 18:20:01','765','2022-09-16 18:20:20',10,0),('1','223',182,'OPPERATIONAL LOST','2022-09-17','2022-09-17 12:49:11','2022-09-18 12:49:11','765',0.00,0.00,'765','2022-09-17 12:52:35','765','2022-09-17 12:53:13',10,0),('1','223',183,'DAILY SALES','2022-09-19','2022-09-19 07:58:27','2022-09-20 07:58:27','765',0.00,0.00,'765','2022-09-19 20:19:41','765','2022-09-19 20:20:01',10,0),('1','223',184,'DAILY SALES','2022-09-20','2022-09-20 07:10:10','2022-09-21 07:10:10','765',0.00,0.00,'765','2022-09-20 19:15:37','765','2022-09-20 19:15:54',10,0),('1','223',185,'DAILY SALES','2022-09-21','2022-09-21 06:49:48','2022-09-22 06:49:48','765',0.00,0.00,'765','2022-09-21 19:06:26','765','2022-09-21 19:06:46',10,0),('1','223',186,'DAILY SALES','2022-09-22','2022-09-22 07:13:50','2022-09-23 07:13:50','765',0.00,0.00,'765','2022-09-22 19:16:27','765','2022-09-22 19:16:49',10,0),('1','223',187,'DAILY SALES','2022-09-23','2022-09-23 06:57:57','2022-09-24 06:57:57','765',0.00,0.00,'765','2022-09-23 19:03:50','765','2022-09-23 19:04:10',10,0),('1','223',188,'DAILY SALES','2022-09-24','2022-09-24 07:06:03','2022-09-25 07:06:03','765',0.00,0.00,'765','2022-09-24 19:01:57','765','2022-09-24 19:02:24',10,0),('1','223',189,'DAILY SALES','2022-09-25','2022-09-25 07:48:02','2022-09-26 07:48:02','765',0.00,0.00,'765','2022-09-25 18:57:47','765','2022-09-25 18:58:57',10,0),('1','223',190,'DAILY SHIFT','2022-09-26','2022-09-26 07:06:47','2022-09-27 07:06:47','765',0.00,0.00,'765','2022-09-26 19:07:21','765','2022-09-26 19:07:41',10,0),('1','223',191,'DAILY SALES','2022-09-27','2022-09-27 06:53:07','2022-09-28 06:53:07','765',0.00,0.00,'765','2022-09-27 17:19:43','765','2022-09-27 17:20:02',10,0),('1','223',192,'OPERATIONAL LOST','2022-09-27','2022-09-27 21:56:28','2022-09-28 21:56:28','765',0.00,0.00,'765','2022-09-27 22:03:05','765','2022-09-27 22:03:51',10,0),('1','223',193,'DAILY SALES','2022-09-28','2022-09-28 08:48:06','2022-09-29 08:48:06','765',0.00,0.00,'765','2022-09-28 19:05:17','765','2022-09-28 19:05:51',10,0),('1','223',194,'DAILY SALES','2022-09-29','2022-09-29 06:55:10','2022-09-30 06:55:10','765',0.00,0.00,'765','2022-09-29 19:28:53','765','2022-09-29 19:29:15',10,0),('1','223',195,'DAILY SALES','2022-09-30','2022-09-30 10:29:06','2022-10-01 10:29:06','765',0.00,0.00,'765','2022-09-30 19:05:33','765','2022-09-30 19:05:50',10,0),('1','223',196,'DAILY SALES','2022-10-01','2022-10-01 06:43:47','2022-10-02 06:43:47','765',0.00,0.00,'765','2022-10-01 19:35:32','765','2022-10-01 19:35:53',10,0),('1','223',197,'DAILY SALES','2022-10-02','2022-10-02 07:01:40','2022-10-03 07:01:40','765',0.00,0.00,'765','2022-10-02 18:49:59','765','2022-10-02 18:50:16',10,0),('1','223',198,'DAILY SALES','2022-10-03','2022-10-03 06:32:03','2022-10-04 06:32:03','765',0.00,0.00,'765','2022-10-03 18:51:58','765','2022-10-03 18:52:27',10,0),('1','223',199,'DAILY SALES','2022-10-04','2022-10-04 06:44:18','2022-10-05 06:44:18','765',0.00,0.00,'765','2022-10-04 19:01:37','765','2022-10-04 19:02:06',10,0),('1','223',200,'DAILY SALES','2022-10-05','2022-10-05 06:34:19','2022-10-06 06:34:19','765',0.00,0.00,'765','2022-10-05 19:10:56','765','2022-10-05 19:11:11',10,0),('1','223',201,'DAILY SALES','2022-10-06','2022-10-06 06:41:05','2022-10-07 06:41:05','765',0.00,0.00,'765','2022-10-06 10:03:11','765','2022-10-06 10:03:32',10,0),('1','223',202,'OPERATIONAL LOST','2022-10-08','2022-10-08 09:11:09','2022-10-09 09:11:09','765',0.00,0.00,'765','2022-10-08 09:19:25','765','2022-10-08 09:20:44',10,0),('1','223',203,'DAILY SALES','2022-10-08','2022-10-08 09:26:19','2022-10-09 09:26:19','765',0.00,0.00,'765','2022-10-08 19:25:37','765','2022-10-08 19:25:56',10,0),('1','223',204,'DAILY SALES','2022-10-09','2022-10-09 06:55:31','2022-10-10 06:55:31','765',0.00,0.00,'765','2022-10-09 18:50:00','765','2022-10-09 18:50:29',10,0),('1','223',205,'DAILY SALES','2022-10-10','2022-10-10 06:59:16','2022-10-11 06:59:16','765',0.00,0.00,'765','2022-10-10 18:48:30','765','2022-10-10 18:51:29',10,0),('1','223',206,'DAILY SALES','2022-10-11','2022-10-11 06:44:16','2022-10-12 06:44:16','765',0.00,0.00,'765','2022-10-11 19:08:38','765','2022-10-11 19:08:56',10,0),('1','223',207,'DAILY SALES','2022-10-12','2022-10-12 06:38:53','2022-10-13 06:38:53','765',0.00,0.00,'765','2022-10-12 18:53:25','765','2022-10-12 18:53:50',10,0),('1','223',208,'DAILY SALES','2022-10-13','2022-10-13 06:47:14','2022-10-14 06:47:14','765',0.00,0.00,'765','2022-10-13 18:59:28','765','2022-10-13 18:59:45',10,0),('1','223',209,'DAILY SALES','2022-10-14','2022-10-14 06:39:29','2022-10-15 06:39:29','765',0.00,0.00,'765','2022-10-14 15:00:05','765','2022-10-14 15:00:32',10,0),('1','223',210,'OPERATINAL LOST','2022-10-14','2022-10-14 15:01:56','2022-10-15 15:01:56','765',0.00,0.00,'765','2022-10-14 15:11:25','765','2022-10-14 15:11:50',10,0),('1','223',211,'DAILY SALES','2022-10-19','2022-10-19 07:09:45','2022-10-20 07:09:45','765',0.00,0.00,'765','2022-10-19 19:09:24','765','2022-10-19 19:10:27',10,0),('1','223',212,'DAILY SALES','2022-10-20','2022-10-20 06:57:50','2022-10-21 06:57:50','765',0.00,0.00,'765','2022-10-21 01:39:26','765','2022-10-21 01:39:50',10,0),('1','223',213,'DAILY SALES','2022-10-21','2022-10-21 06:49:03','2022-10-22 06:49:03','765',0.00,0.00,'765','2022-10-21 11:46:27','765','2022-10-21 11:47:04',10,0),('1','223',214,'OPERATINAL LOST','2022-10-21','2022-10-21 11:48:02','2022-10-22 11:48:02','765',0.00,0.00,'765','2022-10-21 11:56:51','765','2022-10-21 11:57:19',10,0),('1','223',215,'DAILY SALES','2022-10-22','2022-10-22 15:44:49','2022-10-23 15:44:49','765',0.00,0.00,'765','2022-10-22 18:57:54','765','2022-10-22 18:58:39',10,0),('1','223',216,'DAILY SALES','2022-10-23','2022-10-23 07:16:31','2022-10-24 07:16:31','765',0.00,0.00,'765','2022-10-23 18:39:33','765','2022-10-23 18:40:03',10,0),('1','223',217,'DAILY SALES','2022-10-24','2022-10-24 07:26:54','2022-10-25 07:26:54','765',0.00,0.00,'765','2022-10-24 19:15:39','765','2022-10-24 19:16:08',10,0),('1','223',218,'DAILY SALES','2022-10-25','2022-10-25 07:13:51','2022-10-26 07:13:51','765',0.00,0.00,'765','2022-10-25 19:05:47','765','2022-10-25 19:06:12',10,0),('1','223',219,'OPERATINAL LOST','2022-10-26','2022-10-26 10:09:07','2022-10-27 10:09:07','765',0.00,0.00,'765','2022-10-26 10:13:42','765','2022-10-26 10:14:00',10,0),('1','223',220,'DAILY SALES','2022-10-26','2022-10-26 10:34:08','2022-10-27 10:34:08','765',0.00,0.00,'765','2022-10-26 19:24:27','765','2022-10-26 19:24:43',10,0),('1','223',221,'DAILY SALES','2022-10-27','2022-10-27 07:13:35','2022-10-28 07:13:35','765',0.00,0.00,'765','2022-10-27 18:50:08','765','2022-10-27 18:50:26',10,0),('1','223',222,'DAILY SALES','2022-10-28','2022-10-28 07:41:32','2022-10-29 07:41:32','765',0.00,0.00,'765','2022-10-28 18:50:55','765','2022-10-28 18:52:16',10,0),('1','223',223,'DAILY SALES','2022-10-29','2022-10-29 07:16:42','2022-10-30 07:16:42','765',0.00,0.00,'765','2022-10-29 18:53:35','765','2022-10-29 18:53:50',10,0),('1','223',224,'DAILY SALES','2022-10-30','2022-10-30 07:18:21','2022-10-31 07:18:21','765',0.00,0.00,'765','2022-10-30 18:44:35','765','2022-10-30 18:44:52',10,0),('1','223',225,'DAILY SALES','2022-10-31','2022-10-31 07:00:59','2022-11-01 07:00:59','765',0.00,0.00,'765','2022-10-31 12:17:30','765','2022-10-31 12:17:53',10,0),('1','223',226,'OPERATINAL LOST','2022-10-31','2022-10-31 12:18:56','2022-11-01 12:18:56','765',0.00,0.00,'765','2022-10-31 12:21:10','765','2022-10-31 12:21:27',10,0),('1','223',227,'DAILY SALES','2022-11-05','2022-11-05 07:55:36','2022-11-06 07:55:36','765',0.00,0.00,'765','2022-11-05 18:44:56','765','2022-11-05 18:45:10',10,0),('1','223',228,'DAILY SALES','2022-11-06','2022-11-06 08:02:33','2022-11-07 08:02:33','765',0.00,0.00,'765','2022-11-06 18:54:43','765','2022-11-06 18:57:15',10,0),('1','223',229,'DAILY SALES','2022-11-07','2022-11-07 07:00:37','2022-11-08 07:00:37','765',0.00,0.00,'765','2022-11-07 18:57:25','765','2022-11-07 18:57:41',10,0),('1','223',230,'DAILY SALES','2022-11-08','2022-11-08 06:56:31','2022-11-09 06:56:31','765',0.00,0.00,'765','2022-11-08 18:44:42','765','2022-11-08 18:45:04',10,0),('1','223',231,'DAILY SALES','2022-11-09','2022-11-09 07:00:27','2022-11-10 07:00:27','765',0.00,0.00,'765','2022-11-09 18:39:59','765','2022-11-09 18:40:17',10,0),('1','223',232,'DAILY SALES','2022-11-10','2022-11-10 07:16:59','2022-11-11 07:16:59','765',0.00,0.00,'765','2022-11-10 18:41:13','765','2022-11-10 18:41:33',10,0),('1','223',233,'DAILY SALES','2022-11-11','2022-11-11 07:19:02','2022-11-12 07:19:02','765',0.00,0.00,'765','2022-11-11 18:33:06','765','2022-11-11 18:33:22',10,0),('1','223',234,'DAILY SALES','2022-11-12','2022-11-12 07:04:02','2022-11-13 07:04:02','765',0.00,0.00,'765','2022-11-12 18:56:18','765','2022-11-12 18:56:37',10,0),('1','223',235,'DAILY SALES','2022-11-13','2022-11-13 07:09:23','2022-11-14 07:09:23','765',0.00,0.00,'765','2022-11-13 18:45:54','765','2022-11-13 18:46:11',10,0),('1','223',236,'DAILY SALES','2022-11-14','2022-11-14 07:20:01','2022-11-15 07:20:01','765',0.00,0.00,'765','2022-11-14 18:49:24','765','2022-11-14 18:49:58',10,0),('1','223',237,'DAILY SALES','2022-11-15','2022-11-15 07:01:30','2022-11-16 07:01:30','765',0.00,0.00,'765','2022-11-15 19:01:42','765','2022-11-15 19:02:05',10,0),('1','223',238,'DAILY SALES','2022-11-16','2022-11-16 07:07:06','2022-11-17 07:07:06','765',0.00,0.00,'765','2022-11-16 18:55:57','765','2022-11-16 18:56:17',10,0),('1','223',239,'DAILY SALES','2022-11-17','2022-11-17 06:10:55','2022-11-18 06:10:55','765',0.00,0.00,'765','2022-11-17 18:48:51','765','2022-11-17 18:49:34',10,0),('1','223',240,'DAILY SALES','2022-11-18','2022-11-18 07:15:03','2022-11-19 07:15:03','765',0.00,0.00,'765','2022-11-18 18:55:51','765','2022-11-18 18:56:07',10,0),('1','223',241,'DAILY SALES','2022-11-19','2022-11-19 07:15:56','2022-11-20 07:15:56','765',0.00,0.00,'765','2022-11-19 18:38:47','765','2022-11-19 18:39:07',10,0),('1','223',242,'DAILY SALES','2022-11-20','2022-11-20 07:08:53','2022-11-21 07:08:53','765',0.00,0.00,'765','2022-11-20 18:23:20','765','2022-11-20 18:23:41',10,0),('1','223',243,'OPERATIONAL LOST','2022-11-20','2022-11-20 18:24:14','2022-11-21 18:24:14','765',0.00,0.00,'765','2022-11-20 18:37:08','765','2022-11-20 18:37:34',10,0),('1','223',244,'DAILY SALES','2022-11-21','2022-11-21 11:17:11','2022-11-22 11:17:11','765',0.00,0.00,'765','2022-11-21 18:42:36','765','2022-11-21 18:42:51',10,0),('1','223',245,'DAILY SALES','2022-11-22','2022-11-22 06:46:45','2022-11-23 06:46:45','765',0.00,0.00,'765','2022-11-22 18:38:01','765','2022-11-22 18:38:20',10,0),('1','223',246,'DAILY SALES','2022-11-23','2022-11-23 06:45:56','2022-11-24 06:45:56','765',0.00,0.00,'765','2022-11-24 06:38:24','765','2022-11-24 06:39:01',10,0),('1','223',247,'DAILY SALES','2022-11-24','2022-11-24 06:39:37','2022-11-25 06:39:37','765',0.00,0.00,'765','2022-11-24 18:45:45','765','2022-11-24 18:46:07',10,0),('1','223',248,'DAILY SALES','2022-11-25','2022-11-25 06:46:24','2022-11-26 06:46:24','765',0.00,0.00,'765','2022-11-25 18:42:49','765','2022-11-25 18:43:04',10,0),('1','223',249,'DAILY SALES','2022-11-26','2022-11-26 06:49:39','2022-11-27 06:49:39','765',0.00,0.00,'765','2022-11-26 18:57:31','765','2022-11-26 18:57:54',10,0),('1','223',250,'OPERATINAL LOST','2022-11-27','2022-11-27 07:04:33','2022-11-28 07:04:33','765',0.00,0.00,'765','2022-11-27 07:06:42','765','2022-11-27 07:07:02',10,0),('1','223',251,'DAILY SALES','2022-11-27','2022-11-27 07:16:07','2022-11-28 07:16:07','765',0.00,0.00,'765','2022-11-27 18:36:26','765','2022-11-27 18:36:46',10,0),('1','223',252,'DAILY SALES','2022-11-28','2022-11-28 06:44:05','2022-11-29 06:44:05','765',0.00,0.00,'765','2022-11-28 18:35:57','765','2022-11-28 18:36:24',10,0),('1','223',253,'DAILY SALES','2022-11-29','2022-11-29 07:07:11','2022-11-30 07:07:11','765',0.00,0.00,'765','2022-11-29 18:49:16','765','2022-11-29 18:49:34',10,0),('1','223',254,'DAILY SALES','2022-11-30','2022-11-30 07:03:36','2022-12-01 07:03:36','765',0.00,0.00,'765','2022-11-30 18:50:55','765','2022-11-30 18:52:00',10,0),('1','223',255,'DAILY SALES','2022-12-01','2022-12-01 06:51:49','2022-12-02 06:51:49','765',0.00,0.00,'765','2022-12-01 18:48:27','765','2022-12-01 18:48:55',10,0),('1','223',256,'DAILY SALES','2022-12-02','2022-12-02 07:01:44','2022-12-03 07:01:44','765',0.00,0.00,'765','2022-12-02 18:52:18','765','2022-12-02 18:52:34',10,0),('1','223',257,'DAILY SALES','2022-12-03','2022-12-03 06:39:46','2022-12-04 06:39:46','765',0.00,0.00,'765','2022-12-03 18:49:03','765','2022-12-03 18:49:20',10,0),('1','223',258,'DAILY SALES','2022-12-04','2022-12-04 07:07:37','2022-12-05 07:07:37','765',0.00,0.00,'765','2022-12-04 18:50:25','765','2022-12-04 18:50:43',10,0),('1','223',259,'DAILY SALES','2022-12-05','2022-12-05 06:54:09','2022-12-06 06:54:09','765',0.00,0.00,'765','2022-12-05 19:12:57','765','2022-12-05 19:13:32',10,0),('1','223',260,'DAILY SALES','2022-12-06','2022-12-06 06:42:20','2022-12-07 06:42:20','765',0.00,0.00,'765','2022-12-06 18:40:48','765','2022-12-06 18:41:11',10,0),('1','223',261,'DAILY SALES','2022-12-07','2022-12-07 06:48:54','2022-12-08 06:48:54','765',0.00,0.00,'765','2022-12-07 18:46:35','765','2022-12-07 18:47:02',10,0),('1','223',262,'DAILY SALES','2022-12-08','2022-12-08 06:55:24','2022-12-09 06:55:24','765',0.00,0.00,'765','2022-12-08 10:29:31','765','2022-12-08 10:30:00',10,0),('1','223',263,'operational  lost','2022-12-08','2022-12-08 10:31:54','2022-12-09 10:31:54','765',0.00,0.00,'765','2022-12-09 11:11:25','765','2022-12-09 11:11:51',10,0),('1','223',264,'DAILY SALES','2022-12-09','2022-12-09 11:45:37','2022-12-10 11:45:37','765',0.00,0.00,'765','2022-12-09 12:22:14','765','2022-12-09 12:22:32',10,0),('1','223',265,'DAILY SALES','2022-12-09','2022-12-09 12:22:50','2022-12-10 12:22:50','765',0.00,0.00,'765','2022-12-09 19:19:23','765','2022-12-09 19:19:45',10,0),('1','223',266,'DAILY SALES','2022-12-10','2022-12-10 06:58:41','2022-12-11 06:58:41','765',0.00,0.00,'765','2022-12-10 18:51:30','765','2022-12-10 18:51:51',10,0),('1','223',267,'DAILY SALES','2022-12-11','2022-12-11 07:14:07','2022-12-12 07:14:07','765',0.00,0.00,'765','2022-12-11 18:32:25','765','2022-12-11 18:32:47',10,0),('1','223',268,'DAILY SALES','2022-12-12','2022-12-12 07:17:18','2022-12-13 07:17:18','765',0.00,0.00,'765','2022-12-12 18:47:41','765','2022-12-12 18:48:11',10,0),('1','223',269,'DAILY SALES','2022-12-13','2022-12-13 07:14:02','2022-12-14 07:14:02','765',0.00,0.00,'765','2022-12-13 18:43:31','765','2022-12-13 18:43:53',10,0),('1','223',270,'DAILY SALES','2022-12-14','2022-12-14 07:00:11','2022-12-15 07:00:11','765',0.00,0.00,'765','2022-12-14 18:52:36','765','2022-12-14 18:53:28',10,0),('1','223',271,'DAILY SALES','2022-12-15','2022-12-15 06:54:59','2022-12-16 06:54:59','765',0.00,0.00,'765','2022-12-15 19:00:34','765','2022-12-15 19:00:52',10,0),('1','223',272,'DAILY SALES','2022-12-16','2022-12-16 07:08:37','2022-12-17 07:08:37','765',0.00,0.00,'765','2022-12-16 18:52:12','765','2022-12-16 18:52:38',10,0),('1','223',273,'DAILY SALES ','2022-12-17','2022-12-17 07:13:18','2022-12-18 07:13:18','765',0.00,0.00,'765','2022-12-17 18:40:42','765','2022-12-17 18:40:58',10,0),('1','223',274,'DAILY SALES ','2022-12-18','2022-12-18 07:10:45','2022-12-19 07:10:45','765',0.00,0.00,'765','2022-12-18 18:45:35','765','2022-12-18 18:45:56',10,0),('1','223',275,'DAILY SALES','2022-12-19','2022-12-19 07:18:31','2022-12-20 07:18:31','765',0.00,0.00,'765','2022-12-19 18:52:21','765','2022-12-19 18:52:42',10,0),('1','223',276,'DAILY SALES ','2022-12-20','2022-12-20 10:51:31','2022-12-21 10:51:31','765',0.00,0.00,'765','2022-12-20 15:52:19','765','2022-12-20 15:52:37',10,0),('1','223',277,'OPERATINAL LOST','2022-12-20','2022-12-20 15:53:18','2022-12-21 15:53:18','765',0.00,0.00,'765','2022-12-20 15:57:35','765','2022-12-20 15:58:30',10,0),('1','223',278,'DAILY SALES','2022-12-20','2022-12-20 17:28:48','2022-12-21 17:28:48','765',0.00,0.00,'765','2022-12-20 18:57:04','765','2022-12-20 18:57:40',10,0),('1','223',279,'DAILY SALES ','2022-12-21','2022-12-21 06:59:57','2022-12-22 06:59:57','765',0.00,0.00,'765','2022-12-21 18:22:36','765','2022-12-21 18:23:14',10,0),('1','223',280,'DAILY SALES','2022-12-22','2022-12-22 12:42:23','2022-12-23 12:42:23','765',0.00,0.00,'765','2022-12-22 19:09:13','765','2022-12-22 19:09:34',10,0),('1','223',281,'DAILY SALES','2022-12-23','2022-12-23 07:23:12','2022-12-24 07:23:12','765',0.00,0.00,'765','2022-12-23 18:50:01','765','2022-12-23 18:50:17',10,0),('1','223',282,'DAILY SALES','2022-12-24','2022-12-24 07:21:39','2022-12-25 07:21:39','765',0.00,0.00,'765','2022-12-24 18:46:29','765','2022-12-24 18:46:44',10,0),('1','223',283,'DAILY SALES','2022-12-25','2022-12-25 07:17:21','2022-12-26 07:17:21','765',0.00,0.00,'765','2022-12-25 18:47:42','765','2022-12-25 18:48:01',10,0),('1','223',284,'DAILY SALES','2022-12-26','2022-12-26 12:24:32','2022-12-27 12:24:32','765',0.00,0.00,'765','2022-12-26 18:52:41','765','2022-12-26 18:52:58',10,0),('1','223',285,'DAILY SALES','2022-12-27','2022-12-27 07:43:36','2022-12-28 07:43:36','765',0.00,0.00,'765','2022-12-27 18:47:59','765','2022-12-27 18:48:17',10,0),('1','223',286,'DAILY SALES','2022-12-28','2022-12-28 07:44:10','2022-12-29 07:44:10','765',0.00,0.00,'765','2022-12-28 18:38:44','765','2022-12-28 18:39:15',10,0),('1','223',287,'DAILY SALES','2022-12-29','2022-12-29 07:34:54','2022-12-30 07:34:54','765',0.00,0.00,'765','2022-12-29 19:00:09','765','2022-12-29 19:00:29',10,0),('1','223',288,'DAILY SALES','2022-12-30','2022-12-30 07:43:50','2022-12-31 07:43:50','765',0.00,0.00,'765','2022-12-30 19:08:45','765','2022-12-30 19:09:03',10,0),('1','223',289,'OPPERATIONAL LOST','2023-01-05','2023-01-05 00:08:39','2023-01-06 00:08:39','765',0.00,0.00,'765','2023-01-05 00:12:21','765','2023-01-05 00:12:41',10,0),('1','223',290,'DAILY SALES','2023-01-05','2023-01-05 12:32:26','2023-01-06 12:32:26','765',0.00,0.00,'765','2023-01-05 19:00:15','765','2023-01-05 19:00:30',10,0),('1','223',291,'DAILY SALES','2023-01-06','2023-01-06 07:22:09','2023-01-07 07:22:09','765',0.00,0.00,'765','2023-01-06 19:11:04','765','2023-01-06 19:11:22',10,0),('1','223',292,'DAILY SALES','2023-01-07','2023-01-07 07:10:02','2023-01-08 07:10:02','765',0.00,0.00,'765','2023-01-07 19:26:41','765','2023-01-07 19:26:59',10,0),('1','223',293,'DAILY SALES','2023-01-08','2023-01-08 07:09:37','2023-01-09 07:09:37','765',0.00,0.00,'765','2023-01-08 19:13:05','765','2023-01-08 19:13:26',10,0),('1','223',294,'DAILY SALES','2023-01-09','2023-01-09 07:04:46','2023-01-10 07:04:46','765',0.00,0.00,'765','2023-01-09 19:45:14','765','2023-01-09 19:45:54',10,0),('1','223',295,'DAILY SALES','2023-01-10','2023-01-10 07:08:12','2023-01-11 07:08:12','765',0.00,0.00,'765','2023-01-10 19:19:51','765','2023-01-10 19:20:30',10,0),('1','223',296,'DAILY SALES','2023-01-11','2023-01-11 07:03:06','2023-01-12 07:03:06','765',0.00,0.00,'765','2023-01-11 19:57:31','765','2023-01-11 19:58:01',10,0),('1','223',297,'DAILY SALES','2023-01-12','2023-01-12 07:12:20','2023-01-13 07:12:20','765',0.00,0.00,'765','2023-01-12 19:45:01','765','2023-01-12 19:45:54',10,0),('1','223',298,'DAILY SALES','2023-01-13','2023-01-13 07:55:34','2023-01-14 07:55:34','765',0.00,0.00,'765','2023-01-13 19:38:06','765','2023-01-13 19:38:23',10,0),('1','223',299,'DAILY SALES','2023-01-14','2023-01-14 07:48:24','2023-01-15 07:48:24','765',0.00,0.00,'765','2023-01-14 19:01:05','765','2023-01-14 19:01:39',10,0),('1','223',300,'DAILY SALES','2023-01-15','2023-01-15 07:30:56','2023-01-16 07:30:56','765',0.00,0.00,'765','2023-01-15 19:02:09','765','2023-01-15 19:02:32',10,0),('1','223',301,'OPERATINAL LOST','2023-01-15','2023-01-15 19:03:25','2023-01-16 19:03:25','765',0.00,0.00,'765','2023-01-15 19:07:18','765','2023-01-15 19:07:40',10,0),('1','223',302,'DAILY SALES','2023-01-16','2023-01-16 07:58:15','2023-01-17 07:58:15','765',0.00,0.00,'765','2023-01-16 19:18:43','765','2023-01-16 19:19:14',10,0),('1','223',303,'DAILY SALES','2023-01-17','2023-01-17 08:21:05','2023-01-18 08:21:05','765',0.00,0.00,'765','2023-01-17 19:11:11','765','2023-01-17 19:11:34',10,0),('1','223',304,'DAILY SALES','2023-01-18','2023-01-18 07:29:29','2023-01-19 07:29:29','765',0.00,0.00,'765','2023-01-18 19:15:38','765','2023-01-18 19:16:01',10,0),('1','223',305,'DAILY SALES','2023-01-19','2023-01-19 07:21:30','2023-01-20 07:21:30','765',0.00,0.00,'765','2023-01-20 07:20:26','765','2023-01-20 07:20:45',10,0),('1','223',306,'DAILY SALES','2023-01-20','2023-01-20 07:21:10','2023-01-21 07:21:10','765',0.00,0.00,'765','2023-01-20 18:54:15','765','2023-01-20 18:55:01',10,0),('1','223',307,'DAILY SALES','2023-01-21','2023-01-21 07:34:28','2023-01-22 07:34:28','765',0.00,0.00,'765','2023-01-21 18:56:25','765','2023-01-21 18:57:06',10,0),('1','223',308,'DAILY SALES','2023-01-22','2023-01-22 07:11:55','2023-01-23 07:11:55','765',0.00,0.00,'765','2023-01-22 18:55:48','765','2023-01-22 18:56:13',10,0),('1','223',309,'DAILY SALES','2023-01-23','2023-01-23 07:24:40','2023-01-24 07:24:40','765',0.00,0.00,'765','2023-01-23 19:41:43','765','2023-01-23 19:42:36',10,0),('1','223',310,'DAILY SALES','2023-01-24','2023-01-24 07:17:18','2023-01-25 07:17:18','765',0.00,0.00,'765','2023-01-24 19:16:41','765','2023-01-24 19:18:10',10,0),('1','223',311,'DAILY SALES','2023-01-25','2023-01-25 07:19:11','2023-01-26 07:19:11','765',0.00,0.00,'765','2023-01-25 22:33:33','765','2023-01-25 23:41:50',10,0),('1','223',312,'DAILY SALES','2023-01-26','2023-01-26 07:37:26','2023-01-27 07:37:26','765',0.00,0.00,'765','2023-01-27 08:52:14','765','2023-01-27 08:52:39',10,0),('1','223',313,'OPERATINAL LOST','2023-01-27','2023-01-27 08:53:01','2023-01-28 08:53:01','765',0.00,0.00,'765','2023-01-27 08:56:08','765','2023-01-27 08:56:43',10,0),('1','223',314,'DAILY SALES','2023-01-27','2023-01-27 08:59:06','2023-01-28 08:59:06','765',0.00,0.00,'765','2023-01-27 19:14:24','765','2023-01-27 19:14:56',10,0),('1','223',315,'DAILY SALES','2023-01-28','2023-01-28 07:08:52','2023-01-29 07:08:52','765',0.00,0.00,'765','2023-01-28 18:59:58','765','2023-01-28 19:01:26',10,0),('1','223',316,'DAILY SALES','2023-01-29','2023-01-29 07:27:42','2023-01-30 07:27:42','765',0.00,0.00,'765','2023-01-29 19:18:55','765','2023-01-29 19:19:24',10,0),('1','223',317,'DAILY SALES','2023-01-30','2023-01-30 07:50:38','2023-01-31 07:50:38','765',0.00,0.00,'765','2023-01-30 21:17:43','765','2023-01-30 21:18:04',10,0),('1','223',318,'OPERATINAL LOST','2023-01-31','2023-01-31 08:30:13','2023-02-01 08:30:13','765',0.00,0.00,'765','2023-01-31 08:32:38','765','2023-01-31 08:32:55',10,0),('1','223',319,'DAILY SALES','2023-01-31','2023-01-31 08:35:04','2023-02-01 08:35:04','765',0.00,0.00,'765','2023-01-31 19:15:27','765','2023-01-31 19:15:57',10,0),('1','223',320,'DAILY SALES','2023-02-01','2023-02-01 07:39:22','2023-02-02 07:39:22','765',0.00,0.00,'765','2023-02-01 19:31:27','765','2023-02-01 19:32:05',10,0),('1','223',321,'DAILY SALES','2023-02-02','2023-02-02 08:07:34','2023-02-03 08:07:34','765',0.00,0.00,'765','2023-02-02 19:08:31','765','2023-02-02 19:08:54',10,0),('1','223',322,'DAILY SALES ','2023-02-03','2023-02-03 07:31:34','2023-02-04 07:31:34','765',0.00,0.00,'765','2023-02-03 19:23:21','765','2023-02-03 19:24:46',10,0),('1','223',323,'DAILY SALES','2023-02-04','2023-02-04 07:32:45','2023-02-05 07:32:45','765',0.00,0.00,'765','2023-02-04 13:49:58','765','2023-02-04 13:50:42',10,0),('1','223',324,'OPERATINAL LOST','2023-02-04','2023-02-04 13:51:23','2023-02-05 13:51:23','765',0.00,0.00,'765','2023-02-04 14:02:10','765','2023-02-04 14:02:36',10,0),('1','223',325,'DAILY SALES','2023-02-04','2023-02-04 14:17:13','2023-02-05 14:17:13','765',0.00,0.00,'765','2023-02-05 08:11:53','765','2023-02-05 08:12:35',10,0),('1','223',326,'DAILY SALES','2023-02-05','2023-02-05 08:13:53','2023-02-06 08:13:53','765',0.00,0.00,'765','2023-02-05 19:46:41','765','2023-02-05 19:47:11',10,0),('1','223',327,'DAILY SALES','2023-02-06','2023-02-06 07:51:25','2023-02-07 07:51:25','765',0.00,0.00,'765','2023-02-06 19:29:49','765','2023-02-06 19:30:32',10,0),('1','223',328,'DAILY SALES','2023-02-07','2023-02-07 07:34:47','2023-02-08 07:34:47','765',0.00,0.00,'765','2023-02-07 19:48:20','765','2023-02-07 19:49:23',10,0),('1','223',329,'DAILY SALES','2023-02-08','2023-02-08 07:27:28','2023-02-09 07:27:28','765',0.00,0.00,'765','2023-02-08 19:19:22','765','2023-02-08 19:19:58',10,0),('1','223',330,'DAILY SALES','2023-02-09','2023-02-09 07:41:54','2023-02-10 07:41:54','765',0.00,0.00,'765','2023-02-09 19:36:04','765','2023-02-09 19:36:35',10,0),('1','223',331,'DAILY SALES','2023-02-10','2023-02-10 07:38:10','2023-02-11 07:38:10','765',0.00,0.00,'765','2023-02-10 19:28:40','765','2023-02-10 19:29:46',10,0),('1','223',332,'DAILY SALES','2023-02-11','2023-02-11 07:48:10','2023-02-12 07:48:10','765',0.00,0.00,'765','2023-02-11 20:27:14','765','2023-02-11 20:27:45',10,0),('1','223',333,'DAILY SALES','2023-02-12','2023-02-12 07:32:53','2023-02-13 07:32:53','765',0.00,0.00,'765','2023-02-12 19:18:10','765','2023-02-12 19:18:31',10,0),('1','223',334,'DAILY SALES','2023-02-13','2023-02-13 08:10:57','2023-02-14 08:10:57','765',0.00,0.00,'765','2023-02-13 19:46:36','765','2023-02-13 19:46:56',10,0),('1','223',335,'DAILY SALES','2023-02-14','2023-02-14 07:12:52','2023-02-15 07:12:52','765',0.00,0.00,'765','2023-02-14 19:42:20','765','2023-02-14 19:42:51',10,0),('1','223',336,'DAILY SALES','2023-02-15','2023-02-15 07:26:40','2023-02-16 07:26:40','765',0.00,0.00,'765','2023-02-15 15:34:33','765','2023-02-15 15:34:52',10,0),('1','223',337,'OPERATINAL LOST','2023-02-15','2023-02-15 15:37:31','2023-02-16 15:37:31','765',0.00,0.00,'765','2023-02-15 15:44:20','765','2023-02-15 15:44:55',10,0),('1','223',338,'DAILY SALES','2023-02-16','2023-02-16 09:25:14','2023-02-17 09:25:14','765',0.00,0.00,'765','2023-02-16 19:13:53','765','2023-02-16 19:14:17',10,0),('1','223',339,'DAILY SALES','2023-02-17','2023-02-17 07:48:06','2023-02-18 07:48:06','765',0.00,0.00,'765','2023-02-17 19:32:30','765','2023-02-17 19:32:50',10,0),('1','223',340,'DAILY SALES','2023-02-18','2023-02-18 07:59:51','2023-02-19 07:59:51','765',0.00,0.00,'765','2023-02-18 19:32:30','765','2023-02-18 19:32:59',10,0),('1','223',341,'DAILY SALES','2023-02-19','2023-02-19 07:46:23','2023-02-20 07:46:23','765',0.00,0.00,'765','2023-02-19 19:22:34','765','2023-02-19 19:23:04',10,0),('1','223',342,'DAILY SALES','2023-02-20','2023-02-20 07:18:21','2023-02-21 07:18:21','765',0.00,0.00,'765','2023-02-20 22:36:15','765','2023-02-20 22:37:36',10,0),('1','223',343,'DAILY SALES','2023-02-21','2023-02-21 07:21:24','2023-02-22 07:21:24','765',0.00,0.00,'765','2023-02-21 20:29:55','765','2023-02-21 20:30:20',10,0),('1','223',344,'DAILY SALES','2023-02-22','2023-02-22 07:52:24','2023-02-23 07:52:24','765',0.00,0.00,'765','2023-02-22 19:22:48','765','2023-02-22 19:23:22',10,0),('1','223',345,'DAILY SALES','2023-02-23','2023-02-23 07:15:57','2023-02-24 07:15:57','765',0.00,0.00,'765','2023-02-23 21:45:20','765','2023-02-23 21:45:44',10,0),('1','223',346,'DAILY SALES','2023-02-24','2023-02-24 07:19:12','2023-02-25 07:19:12','765',0.00,0.00,'765','2023-02-24 23:05:43','765','2023-02-24 23:06:09',10,0),('1','223',347,'DAILY SALES','2023-03-01','2023-03-01 07:40:38','2023-03-02 07:40:38','765',0.00,0.00,'765','2023-03-01 19:23:26','765','2023-03-01 19:23:46',10,0),('1','223',348,'DAILY SALES','2023-03-02','2023-03-02 07:21:38','2023-03-03 07:21:38','765',0.00,0.00,'765','2023-03-02 19:16:00','765','2023-03-02 19:16:59',10,0),('1','223',349,'DAILY SALES','2023-03-03','2023-03-03 07:29:12','2023-03-04 07:29:12','765',0.00,0.00,'765','2023-03-03 19:07:19','765','2023-03-03 19:07:34',10,0),('1','223',350,'DAILY SALES','2023-03-04','2023-03-04 07:33:31','2023-03-05 07:33:31','765',0.00,0.00,'765','2023-03-04 19:10:03','765','2023-03-04 19:11:21',10,0),('1','223',351,'DAILY SALES','2023-03-05','2023-03-05 07:24:54','2023-03-06 07:24:54','765',0.00,0.00,'765','2023-03-05 18:54:42','765','2023-03-05 18:55:04',10,0),('1','223',352,'DAILY SALES','2023-03-06','2023-03-06 07:26:51','2023-03-07 07:26:51','765',0.00,0.00,'765','2023-03-06 11:43:33','765','2023-03-06 11:44:03',10,0),('1','223',353,'DAILY SALES','2023-03-07','2023-03-07 07:42:39','2023-03-08 07:42:39','765',0.00,0.00,'765','2023-03-07 19:34:03','765','2023-03-07 19:34:33',10,0),('1','223',354,'DAILY SALES','2023-03-08','2023-03-08 07:19:36','2023-03-09 07:19:36','765',0.00,0.00,'765','2023-03-08 19:12:48','765','2023-03-08 19:13:40',10,0),('1','223',355,'DAILY SALES','2023-03-09','2023-03-09 07:30:03','2023-03-10 07:30:03','765',0.00,0.00,'765','2023-03-09 19:22:29','765','2023-03-09 19:22:50',10,0),('1','223',356,'DAILY SALES','2023-03-10','2023-03-10 07:23:11','2023-03-11 07:23:11','765',0.00,0.00,'765','2023-03-10 19:06:25','765','2023-03-10 19:07:02',10,0),('1','223',357,'DAILY SALES','2023-03-11','2023-03-11 07:27:18','2023-03-12 07:27:18','765',0.00,0.00,'765','2023-03-11 18:07:24','765','2023-03-11 18:07:47',10,0),('1','223',358,'OPERATIONAL LOST','2023-03-13','2023-03-13 06:38:02','2023-03-14 06:38:02','765',0.00,0.00,'765','2023-03-13 06:43:01','765','2023-03-13 06:43:26',10,0),('1','223',359,'DAILY SALES','2023-03-13','2023-03-13 08:03:54','2023-03-14 08:03:54','765',0.00,0.00,'765','2023-03-13 19:25:38','765','2023-03-13 19:25:57',10,0),('1','223',360,'DAILY SALES','2023-03-14','2023-03-14 07:12:10','2023-03-15 07:12:10','765',0.00,0.00,'765','2023-03-14 19:24:52','765','2023-03-14 19:25:14',10,0),('1','223',361,'DAILY SALES','2023-03-15','2023-03-15 07:10:57','2023-03-16 07:10:57','765',0.00,0.00,'765','2023-03-15 18:37:16','765','2023-03-15 18:39:07',10,0),('1','223',362,'DAILY SALES','2023-03-16','2023-03-16 07:30:42','2023-03-17 07:30:42','765',0.00,0.00,'765','2023-03-16 18:43:16','765','2023-03-16 18:43:52',10,0),('1','223',363,'DAILY SALES','2023-03-17','2023-03-17 07:29:09','2023-03-18 07:29:09','765',0.00,0.00,'765','2023-03-17 19:28:49','765','2023-03-17 19:29:13',10,0),('1','223',364,'DAILY SALES','2023-03-18','2023-03-18 16:43:59','2023-03-19 16:43:59','765',0.00,0.00,'765','2023-03-18 19:54:18','765','2023-03-18 19:54:45',10,0),('1','223',365,'DAILY SALES','2023-03-19','2023-03-19 07:24:25','2023-03-20 07:24:25','765',0.00,0.00,'765','2023-03-19 19:12:26','765','2023-03-19 19:14:04',10,0),('1','223',366,'DAILY SALES','2023-03-20','2023-03-20 07:14:56','2023-03-21 07:14:56','765',0.00,0.00,'765','2023-03-20 20:02:02','765','2023-03-20 20:02:36',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1457 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','223','1','1',1,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','1',3,'3','1',0.00,105.47,0.00,0.00,105.47,61172.60,0.00,0.00,0.00),('1','223','1','1',4,'4','1',0.00,100.00,0.00,0.00,100.00,53500.00,0.00,0.00,0.00),('1','223','1','2',5,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','2',6,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','2',7,'3','1',105.47,222.83,0.00,0.00,117.36,68068.80,0.00,0.00,0.00),('1','223','1','2',8,'4','1',100.00,550.00,0.00,0.00,450.00,240750.00,0.00,0.00,0.00),('1','223','1','3',9,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','3',10,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','3',11,'3','1',222.83,409.64,0.00,0.00,186.81,108349.80,0.00,0.00,0.00),('1','223','1','3',12,'4','1',550.00,550.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','4',13,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','4',14,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','4',15,'3','1',409.64,567.75,0.00,0.00,158.11,91703.80,0.00,0.00,0.00),('1','223','1','4',16,'4','1',550.00,2023.10,0.00,0.00,1473.10,501883.50,0.00,0.00,0.00),('1','223','1','5',17,'1','1',0.00,50.69,0.00,0.00,50.69,29400.20,0.00,0.00,0.00),('1','223','1','5',18,'2','1',0.00,22.81,0.00,0.00,22.81,13229.80,0.00,0.00,0.00),('1','223','1','5',19,'3','1',567.75,779.90,0.00,0.00,212.15,123047.00,0.00,0.00,0.00),('1','223','1','5',20,'4','1',2023.10,2433.10,0.00,0.00,410.00,219350.00,0.00,0.00,0.00),('1','223','1','6',21,'1','1',50.69,194.42,0.00,0.00,143.73,83363.40,0.00,0.00,0.00),('1','223','1','6',22,'2','1',22.81,68.06,0.00,0.00,45.25,26245.00,0.00,0.00,0.00),('1','223','1','6',23,'3','1',779.90,779.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','6',24,'4','1',2433.10,2595.60,0.00,0.00,162.50,86937.50,0.00,0.00,0.00),('1','223','1','7',25,'1','1',194.42,399.48,0.00,0.00,205.06,118934.80,0.00,0.00,0.00),('1','223','1','7',26,'2','1',68.06,220.66,0.00,0.00,152.60,88508.00,0.00,0.00,0.00),('1','223','1','7',27,'3','1',779.90,1069.90,0.00,0.00,290.00,155150.00,0.00,0.00,0.00),('1','223','1','7',28,'4','1',2595.60,3000.19,0.00,0.00,404.59,216455.65,0.00,0.00,0.00),('1','223','1','10',29,'1','1',399.48,550.15,0.00,0.00,150.67,87388.60,0.00,0.00,0.00),('1','223','1','10',30,'2','1',220.66,388.66,0.00,0.00,168.00,97440.00,0.00,0.00,0.00),('1','223','1','10',31,'3','1',1069.90,1124.90,0.00,0.00,55.00,29425.00,0.00,0.00,0.00),('1','223','1','10',32,'4','1',3000.19,3190.19,0.00,0.00,190.00,101650.00,0.00,0.00,0.00),('1','223','1','11',33,'1','1',550.15,705.93,0.00,0.00,155.78,90352.40,0.00,0.00,0.00),('1','223','1','11',34,'2','1',388.66,505.12,0.00,0.00,116.46,67546.80,0.00,0.00,0.00),('1','223','1','11',35,'3','1',1124.90,1344.90,0.00,0.00,220.00,117700.00,0.00,0.00,0.00),('1','223','1','11',36,'4','1',3190.19,3290.19,0.00,0.00,100.00,53500.00,0.00,0.00,0.00),('1','223','1','12',37,'1','1',705.93,816.63,0.00,0.00,110.70,64206.00,0.00,0.00,0.00),('1','223','1','12',38,'2','1',505.12,625.78,0.00,0.00,120.66,69982.80,0.00,0.00,0.00),('1','223','1','12',39,'3','1',1344.90,1800.90,0.00,0.00,456.00,243960.00,0.00,0.00,0.00),('1','223','1','12',40,'4','1',3290.19,3580.19,0.00,0.00,290.00,155150.00,0.00,0.00,0.00),('1','223','1','13',41,'1','1',816.63,972.60,0.00,0.00,155.97,90462.60,0.00,0.00,0.00),('1','223','1','13',42,'2','1',625.78,738.01,0.00,0.00,112.23,65093.40,0.00,0.00,0.00),('1','223','1','13',43,'3','1',1800.90,1986.40,0.00,0.00,185.50,99242.50,0.00,0.00,0.00),('1','223','1','13',44,'4','1',3580.19,3744.69,0.00,0.00,164.50,88007.50,0.00,0.00,0.00),('1','223','1','14',45,'1','1',972.60,1070.30,0.00,0.00,97.70,56666.00,0.00,0.00,0.00),('1','223','1','14',46,'2','1',738.01,869.72,0.00,0.00,131.71,76391.80,0.00,0.00,0.00),('1','223','1','14',47,'3','1',1986.40,2041.40,0.00,0.00,55.00,29425.00,0.00,0.00,0.00),('1','223','1','14',48,'4','1',3744.69,3844.69,0.00,0.00,100.00,53500.00,0.00,0.00,0.00),('1','223','1','15',49,'1','1',1070.30,1158.50,0.00,0.00,88.20,51156.00,0.00,0.00,0.00),('1','223','1','15',50,'2','1',869.72,960.48,0.00,0.00,90.76,52640.80,0.00,0.00,0.00),('1','223','1','15',51,'3','1',2041.40,2241.40,0.00,0.00,200.00,107000.00,0.00,0.00,0.00),('1','223','1','15',52,'4','1',3844.69,4114.69,0.00,0.00,270.00,144450.00,0.00,0.00,0.00),('1','223','1','16',53,'1','1',1158.50,1317.12,0.00,0.00,158.62,91999.60,0.00,0.00,0.00),('1','223','1','16',54,'2','1',960.48,1168.57,0.00,0.00,208.09,120692.20,0.00,0.00,0.00),('1','223','1','16',55,'3','1',2241.40,2589.40,0.00,0.00,348.00,186180.00,0.00,0.00,0.00),('1','223','1','16',56,'4','1',4114.69,5570.49,0.00,0.00,1455.80,778853.00,0.00,0.00,0.00),('1','223','1','17',57,'1','1',1317.12,1464.74,0.00,0.00,147.62,85619.60,0.00,0.00,0.00),('1','223','1','17',58,'2','1',1168.57,1345.85,0.00,0.00,177.28,102822.40,0.00,0.00,0.00),('1','223','1','17',59,'3','1',2589.40,2589.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','17',60,'4','1',5570.49,5625.49,0.00,0.00,55.00,29425.00,0.00,0.00,0.00),('1','223','1','18',61,'1','1',1464.74,1656.81,0.00,0.00,192.07,111400.60,0.00,0.00,0.00),('1','223','1','18',62,'2','1',1345.85,1567.67,0.00,0.00,221.82,128655.60,0.00,0.00,0.00),('1','223','1','18',63,'3','1',2589.40,2766.40,0.00,0.00,177.00,94695.00,0.00,0.00,0.00),('1','223','1','18',64,'4','1',5625.49,5768.99,0.00,0.00,143.50,76772.50,0.00,0.00,0.00),('1','223','1','19',65,'1','1',1656.81,1826.85,0.00,0.00,170.04,98623.20,0.00,0.00,0.00),('1','223','1','19',66,'2','1',1567.67,1701.87,0.00,0.00,134.20,77836.00,0.00,0.00,0.00),('1','223','1','19',67,'3','1',2766.40,3297.34,0.00,0.00,530.94,284052.90,0.00,0.00,0.00),('1','223','1','19',68,'4','1',5768.99,5768.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','20',69,'1','1',1826.85,1826.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','20',70,'2','1',1701.87,1701.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','20',71,'3','1',3297.34,3297.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','20',72,'4','1',5768.99,5768.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','21',73,'1','1',1826.85,1976.96,0.00,0.00,150.11,87063.80,0.00,0.00,0.00),('1','223','1','21',74,'2','1',1701.87,1777.67,0.00,0.00,75.80,43964.00,0.00,0.00,0.00),('1','223','1','21',75,'3','1',3297.34,3297.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','21',76,'4','1',5768.99,5768.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','22',77,'1','1',1976.96,2349.51,0.00,0.00,372.55,230981.00,0.00,0.00,0.00),('1','223','1','22',78,'2','1',1777.67,2165.68,0.00,0.00,388.01,240566.20,0.00,0.00,0.00),('1','223','1','22',79,'3','1',3297.34,3427.76,0.00,0.00,130.42,78252.00,0.00,0.00,0.00),('1','223','1','22',80,'4','1',5768.99,5943.99,0.00,0.00,175.00,105000.00,0.00,0.00,0.00),('1','223','1','23',81,'1','1',2349.51,2716.22,0.00,0.00,366.71,227360.20,0.00,0.00,0.00),('1','223','1','23',82,'2','1',2165.68,2529.30,0.00,0.00,363.62,225444.40,0.00,0.00,0.00),('1','223','1','23',83,'3','1',3427.76,3722.76,0.00,0.00,295.00,177000.00,0.00,0.00,0.00),('1','223','1','23',84,'4','1',5943.99,5943.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','24',85,'1','1',2716.22,3063.19,0.00,0.00,346.97,215121.40,0.00,0.00,0.00),('1','223','1','24',86,'2','1',2529.30,2813.76,0.00,0.00,284.46,176365.20,0.00,0.00,0.00),('1','223','1','24',87,'3','1',3722.76,3722.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','24',88,'4','1',5943.99,6043.99,0.00,0.00,100.00,60000.00,0.00,0.00,0.00),('1','223','1','25',89,'1','1',3063.19,3251.87,0.00,0.00,188.68,116981.60,0.00,0.00,0.00),('1','223','1','25',90,'2','1',2813.76,3046.72,0.00,0.00,232.96,144435.20,0.00,0.00,0.00),('1','223','1','25',91,'3','1',3722.76,3835.26,0.00,0.00,112.50,67500.00,0.00,0.00,0.00),('1','223','1','25',92,'4','1',6043.99,6098.99,0.00,0.00,55.00,33000.00,0.00,0.00,0.00),('1','223','1','26',93,'1','1',3251.87,3383.17,0.00,0.00,131.30,81406.00,0.00,0.00,0.00),('1','223','1','26',94,'2','1',3046.72,3183.32,0.00,0.00,136.60,84692.00,0.00,0.00,0.00),('1','223','1','26',95,'3','1',3835.26,3896.26,0.00,0.00,61.00,36600.00,0.00,0.00,0.00),('1','223','1','26',96,'4','1',6098.99,6098.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','27',97,'1','1',3383.17,3540.50,0.00,0.00,157.33,97544.60,0.00,0.00,0.00),('1','223','1','27',98,'2','1',3183.32,3306.18,0.00,0.00,122.86,76173.20,0.00,0.00,0.00),('1','223','1','27',99,'3','1',3896.26,3896.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','27',100,'4','1',6098.99,6138.99,0.00,0.00,40.00,24000.00,0.00,0.00,0.00),('1','223','1','28',101,'1','1',3540.50,3719.97,0.00,0.00,179.47,111271.40,0.00,0.00,0.00),('1','223','1','28',102,'2','1',3306.18,3498.78,0.00,0.00,192.60,119412.00,0.00,0.00,0.00),('1','223','1','28',103,'3','1',3896.26,4021.26,0.00,0.00,125.00,75000.00,0.00,0.00,0.00),('1','223','1','28',104,'4','1',6138.99,6238.99,0.00,0.00,100.00,60000.00,0.00,0.00,0.00),('1','223','1','29',105,'1','1',3719.97,3917.77,0.00,0.00,197.80,122636.00,0.00,0.00,0.00),('1','223','1','29',106,'2','1',3498.78,3681.07,0.00,0.00,182.29,113019.80,0.00,0.00,0.00),('1','223','1','29',107,'3','1',4021.26,4079.26,0.00,0.00,58.00,34800.00,0.00,0.00,0.00),('1','223','1','29',108,'4','1',6238.99,6238.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','30',109,'1','1',3917.77,4085.09,0.00,0.00,167.32,103738.40,0.00,0.00,0.00),('1','223','1','30',110,'2','1',3681.07,3849.05,0.00,0.00,167.98,104147.60,0.00,0.00,0.00),('1','223','1','30',111,'3','1',4079.26,4291.76,0.00,0.00,212.50,127500.00,0.00,0.00,0.00),('1','223','1','30',112,'4','1',6238.99,6318.99,0.00,0.00,80.00,48000.00,0.00,0.00,0.00),('1','223','1','31',113,'1','1',4085.09,4451.28,0.00,0.00,366.19,227037.80,0.00,0.00,0.00),('1','223','1','31',114,'2','1',3849.05,4140.71,0.00,0.00,291.66,180829.20,0.00,0.00,0.00),('1','223','1','31',115,'3','1',4291.76,4441.76,0.00,0.00,150.00,90000.00,0.00,0.00,0.00),('1','223','1','31',116,'4','1',6318.99,6436.99,0.00,0.00,118.00,70800.00,0.00,0.00,0.00),('1','223','1','32',117,'1','1',4451.28,4936.48,0.00,0.00,485.20,300824.00,0.00,0.00,0.00),('1','223','1','32',118,'2','1',4140.71,4600.69,0.00,0.00,459.98,285187.60,0.00,0.00,0.00),('1','223','1','32',119,'3','1',4441.76,4604.26,0.00,0.00,162.50,97500.00,0.00,0.00,0.00),('1','223','1','32',120,'4','1',6436.99,6519.99,0.00,0.00,83.00,49800.00,0.00,0.00,0.00),('1','223','1','33',121,'1','1',4936.48,5209.49,0.00,0.00,273.01,169266.20,0.00,0.00,0.00),('1','223','1','33',122,'2','1',4600.69,4842.74,0.00,0.00,242.05,150071.00,0.00,0.00,0.00),('1','223','1','33',123,'3','1',4604.26,4664.26,0.00,0.00,60.00,36000.00,0.00,0.00,0.00),('1','223','1','33',124,'4','1',6519.99,6519.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','34',125,'1','1',5209.49,5446.33,0.00,0.00,236.84,146840.80,0.00,0.00,0.00),('1','223','1','34',126,'2','1',4842.74,5040.23,0.00,0.00,197.49,122443.80,0.00,0.00,0.00),('1','223','1','34',127,'3','1',4664.26,4814.26,0.00,0.00,150.00,90000.00,0.00,0.00,0.00),('1','223','1','34',128,'4','1',6519.99,6639.99,0.00,0.00,120.00,72000.00,0.00,0.00,0.00),('1','223','1','35',129,'1','1',5446.33,5617.62,0.00,0.00,171.29,106199.80,0.00,0.00,0.00),('1','223','1','35',130,'2','1',5040.23,5222.82,0.00,0.00,182.59,113205.80,0.00,0.00,0.00),('1','223','1','35',131,'3','1',4814.26,5696.26,0.00,0.00,882.00,529200.00,0.00,0.00,0.00),('1','223','1','35',132,'4','1',6639.99,6764.99,0.00,0.00,125.00,75000.00,0.00,0.00,0.00),('1','223','1','36',133,'1','1',5617.62,5858.38,0.00,0.00,240.76,149271.20,0.00,0.00,0.00),('1','223','1','36',134,'2','1',5222.82,5440.08,0.00,0.00,217.26,134701.20,0.00,0.00,0.00),('1','223','1','36',135,'3','1',5696.26,5746.26,0.00,0.00,50.00,30000.00,0.00,0.00,0.00),('1','223','1','36',136,'4','1',6764.99,6920.99,0.00,0.00,156.00,93600.00,0.00,0.00,0.00),('1','223','1','37',137,'1','1',5858.38,5951.25,0.00,0.00,92.87,57579.40,0.00,0.00,0.00),('1','223','1','37',138,'2','1',5440.08,5494.85,0.00,0.00,54.77,33957.40,0.00,0.00,0.00),('1','223','1','37',139,'3','1',5746.26,5979.26,0.00,0.00,233.00,139800.00,0.00,0.00,0.00),('1','223','1','37',140,'4','1',6920.99,7020.99,0.00,0.00,100.00,60000.00,0.00,0.00,0.00),('1','223','1','38',141,'1','1',5951.25,5951.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','38',142,'2','1',5494.85,5494.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','38',143,'3','1',5979.26,5979.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','38',144,'4','1',7020.99,7020.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','39',145,'1','1',5951.25,6154.07,0.00,0.00,202.82,125748.40,0.00,0.00,0.00),('1','223','1','39',146,'2','1',5494.85,5694.93,0.00,0.00,200.08,124049.60,0.00,0.00,0.00),('1','223','1','39',147,'3','1',5979.26,7050.26,0.00,0.00,1071.00,642600.00,0.00,0.00,0.00),('1','223','1','39',148,'4','1',7020.99,7358.49,0.00,0.00,337.50,202500.00,0.00,0.00,0.00),('1','223','1','40',149,'1','1',6154.07,6444.93,0.00,0.00,290.86,180333.20,0.00,0.00,0.00),('1','223','1','40',150,'2','1',5694.93,6022.98,0.00,0.00,328.05,203391.00,0.00,0.00,0.00),('1','223','1','40',151,'3','1',7050.26,7050.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','40',152,'4','1',7358.49,7460.99,0.00,0.00,102.50,61500.00,0.00,0.00,0.00),('1','223','1','41',153,'1','1',6444.93,6742.29,0.00,0.00,297.36,184363.20,0.00,0.00,0.00),('1','223','1','41',154,'2','1',6022.98,6280.13,0.00,0.00,257.15,159433.00,0.00,0.00,0.00),('1','223','1','41',155,'3','1',7050.26,7620.26,0.00,0.00,570.00,342000.00,0.00,0.00,0.00),('1','223','1','41',156,'4','1',7460.99,7519.99,0.00,0.00,59.00,35400.00,0.00,0.00,0.00),('1','223','1','42',157,'1','1',6742.29,7030.91,0.00,0.00,288.62,178944.40,0.00,0.00,0.00),('1','223','1','42',158,'2','1',6280.13,6562.88,0.00,0.00,282.75,175305.00,0.00,0.00,0.00),('1','223','1','42',159,'3','1',7620.26,7795.26,0.00,0.00,175.00,105000.00,0.00,0.00,0.00),('1','223','1','42',160,'4','1',7519.99,7519.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','43',161,'1','1',7030.91,7120.41,0.00,0.00,89.50,55490.00,0.00,0.00,0.00),('1','223','1','43',162,'2','1',6562.88,6702.88,0.00,0.00,140.00,86800.00,0.00,0.00,0.00),('1','223','1','43',163,'3','1',7795.26,7795.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','43',164,'4','1',7519.99,7519.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','44',165,'1','1',7120.41,7120.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','44',166,'2','1',6702.88,6702.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','44',167,'3','1',7795.26,7795.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','44',168,'4','1',7519.99,7519.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','45',169,'1','1',7120.41,7419.68,0.00,0.00,299.27,185547.40,0.00,0.00,0.00),('1','223','1','45',170,'2','1',6702.88,6825.93,0.00,0.00,123.05,76291.00,0.00,0.00,0.00),('1','223','1','45',171,'3','1',7795.26,9028.99,0.00,0.00,1233.73,740238.00,0.00,0.00,0.00),('1','223','1','45',172,'4','1',7519.99,7519.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','46',173,'1','1',7419.68,7631.03,0.00,0.00,211.35,131037.00,0.00,0.00,0.00),('1','223','1','46',174,'2','1',6825.93,6998.85,0.00,0.00,172.92,107210.40,0.00,0.00,0.00),('1','223','1','46',175,'3','1',9028.99,9328.99,0.00,0.00,300.00,180000.00,0.00,0.00,0.00),('1','223','1','46',176,'4','1',7519.99,7519.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','47',177,'1','1',7631.03,7920.33,0.00,0.00,289.30,179366.00,0.00,0.00,0.00),('1','223','1','47',178,'2','1',6998.85,7226.97,0.00,0.00,228.12,141434.40,0.00,0.00,0.00),('1','223','1','47',179,'3','1',9328.99,9601.49,0.00,0.00,272.50,163500.00,0.00,0.00,0.00),('1','223','1','47',180,'4','1',7519.99,7579.99,0.00,0.00,60.00,36000.00,0.00,0.00,0.00),('1','223','1','48',181,'1','1',7920.33,8214.60,0.00,0.00,294.27,182447.40,0.00,0.00,0.00),('1','223','1','48',182,'2','1',7226.97,7397.89,0.00,0.00,170.92,105970.40,0.00,0.00,0.00),('1','223','1','48',183,'3','1',9601.49,9900.99,0.00,0.00,299.50,179700.00,0.00,0.00,0.00),('1','223','1','48',184,'4','1',7579.99,7635.96,0.00,0.00,55.97,33701.40,0.00,0.00,0.00),('1','223','1','49',185,'1','1',8214.60,8403.35,0.00,0.00,188.75,117025.00,0.00,0.00,0.00),('1','223','1','49',186,'2','1',7397.89,7559.23,0.00,0.00,161.34,100030.80,0.00,0.00,0.00),('1','223','1','49',187,'3','1',9900.99,9900.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','49',188,'4','1',7635.96,7695.96,0.00,0.00,60.00,36000.00,0.00,0.00,0.00),('1','223','1','50',189,'1','1',8403.35,8703.80,0.00,0.00,300.45,186279.00,0.00,0.00,0.00),('1','223','1','50',190,'2','1',7559.23,7747.35,0.00,0.00,188.12,116634.40,0.00,0.00,0.00),('1','223','1','50',191,'3','1',9900.99,10000.99,0.00,0.00,100.00,60000.00,0.00,0.00,0.00),('1','223','1','50',192,'4','1',7695.96,7755.96,0.00,0.00,60.00,36000.00,0.00,0.00,0.00),('1','223','1','51',193,'1','1',8703.80,8741.12,0.00,0.00,37.32,23138.40,0.00,0.00,0.00),('1','223','1','51',194,'2','1',7747.35,7779.81,0.00,0.00,32.46,20125.20,0.00,0.00,0.00),('1','223','1','51',195,'3','1',10000.99,10582.99,0.00,0.00,582.00,349200.00,0.00,0.00,0.00),('1','223','1','51',196,'4','1',7755.96,7755.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','52',197,'1','1',8741.12,8741.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','52',198,'2','1',7779.81,7779.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','52',199,'3','1',10582.99,10582.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','52',200,'4','1',7755.96,7755.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','53',201,'1','1',8741.12,8957.99,0.00,0.00,216.87,134459.40,0.00,0.00,0.00),('1','223','1','53',202,'2','1',7779.81,7959.44,0.00,0.00,179.63,111370.60,0.00,0.00,0.00),('1','223','1','53',203,'3','1',10582.99,10699.66,0.00,0.00,116.67,70002.00,0.00,0.00,0.00),('1','223','1','53',204,'4','1',7755.96,7819.96,0.00,0.00,64.00,38400.00,0.00,0.00,0.00),('1','223','1','54',205,'1','1',8957.99,9186.34,0.00,0.00,228.35,141577.00,0.00,0.00,0.00),('1','223','1','54',206,'2','1',7959.44,8159.30,0.00,0.00,199.86,123913.20,0.00,0.00,0.00),('1','223','1','54',207,'3','1',10699.66,11805.16,0.00,0.00,1105.50,663300.00,0.00,0.00,0.00),('1','223','1','54',208,'4','1',7819.96,7919.96,0.00,0.00,100.00,60000.00,0.00,0.00,0.00),('1','223','1','55',209,'1','1',9186.34,9410.24,0.00,0.00,223.90,138818.00,0.00,0.00,0.00),('1','223','1','55',210,'2','1',8159.30,8338.08,0.00,0.00,178.78,110843.60,0.00,0.00,0.00),('1','223','1','55',211,'3','1',11805.16,12142.66,0.00,0.00,337.50,202500.00,0.00,0.00,0.00),('1','223','1','55',212,'4','1',7919.96,7959.96,0.00,0.00,40.00,24000.00,0.00,0.00,0.00),('1','223','1','56',213,'1','1',9410.24,9694.27,0.00,0.00,284.03,176098.60,0.00,0.00,0.00),('1','223','1','56',214,'2','1',8338.08,8520.72,0.00,0.00,182.64,113236.80,0.00,0.00,0.00),('1','223','1','56',215,'3','1',12142.66,12189.66,0.00,0.00,47.00,28200.00,0.00,0.00,0.00),('1','223','1','56',216,'4','1',7959.96,7993.96,0.00,0.00,34.00,20400.00,0.00,0.00,0.00),('1','223','1','57',217,'1','1',9694.27,9999.44,0.00,0.00,305.17,189205.40,0.00,0.00,0.00),('1','223','1','57',218,'2','1',8520.72,8745.31,0.00,0.00,224.59,139245.80,0.00,0.00,0.00),('1','223','1','57',219,'3','1',12189.66,12249.66,0.00,0.00,60.00,36000.00,0.00,0.00,0.00),('1','223','1','57',220,'4','1',7993.96,7993.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','58',221,'1','1',9999.44,10300.16,0.00,0.00,300.72,186446.40,0.00,0.00,0.00),('1','223','1','58',222,'2','1',8745.31,8913.15,0.00,0.00,167.84,104060.80,0.00,0.00,0.00),('1','223','1','58',223,'3','1',12249.66,13132.66,0.00,0.00,883.00,529800.00,0.00,0.00,0.00),('1','223','1','58',224,'4','1',7993.96,8143.96,0.00,0.00,150.00,90000.00,0.00,0.00,0.00),('1','223','1','59',225,'1','1',10300.16,10351.72,0.00,0.00,51.56,31967.20,0.00,0.00,0.00),('1','223','1','59',226,'2','1',8913.15,8918.15,0.00,0.00,5.00,3100.00,0.00,0.00,0.00),('1','223','1','59',227,'3','1',13132.66,13586.66,0.00,0.00,454.00,272400.00,0.00,0.00,0.00),('1','223','1','59',228,'4','1',8143.96,8143.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','60',229,'1','1',10351.72,10351.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','60',230,'2','1',8918.15,8918.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','60',231,'3','1',13586.66,13586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','60',232,'4','1',8143.96,8143.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','61',233,'1','1',10351.72,10790.12,0.00,0.00,438.40,271808.00,0.00,0.00,0.00),('1','223','1','61',234,'2','1',8918.15,9247.93,0.00,0.00,329.78,204463.60,0.00,0.00,0.00),('1','223','1','61',235,'3','1',13586.66,13924.66,0.00,0.00,338.00,202800.00,0.00,0.00,0.00),('1','223','1','61',236,'4','1',8143.96,9158.41,0.00,0.00,1014.45,608670.00,0.00,0.00,0.00),('1','223','1','62',237,'1','1',10790.12,11073.09,0.00,0.00,282.97,175441.40,0.00,0.00,0.00),('1','223','1','62',238,'2','1',9247.93,9493.35,0.00,0.00,245.42,152160.40,0.00,0.00,0.00),('1','223','1','62',239,'3','1',13924.66,14790.66,0.00,0.00,866.00,519600.00,0.00,0.00,0.00),('1','223','1','62',240,'4','1',9158.41,9188.41,0.00,0.00,30.00,18000.00,0.00,0.00,0.00),('1','223','1','63',241,'1','1',11073.09,11391.86,0.00,0.00,318.77,197637.40,0.00,0.00,0.00),('1','223','1','63',242,'2','1',9493.35,9759.58,0.00,0.00,266.23,165062.60,0.00,0.00,0.00),('1','223','1','63',243,'3','1',14790.66,15003.16,0.00,0.00,212.50,127500.00,0.00,0.00,0.00),('1','223','1','63',244,'4','1',9188.41,9368.41,0.00,0.00,180.00,108000.00,0.00,0.00,0.00),('1','223','1','64',245,'1','1',11391.86,11711.98,0.00,0.00,320.12,198474.40,0.00,0.00,0.00),('1','223','1','64',246,'2','1',9759.58,10012.46,0.00,0.00,252.88,156785.60,0.00,0.00,0.00),('1','223','1','64',247,'3','1',15003.16,16085.08,0.00,0.00,1081.92,649152.00,0.00,0.00,0.00),('1','223','1','64',248,'4','1',9368.41,9528.41,0.00,0.00,160.00,96000.00,0.00,0.00,0.00),('1','223','1','65',249,'1','1',11711.98,11711.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','65',250,'2','1',10012.46,10012.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','65',251,'3','1',16085.08,16085.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','65',252,'4','1',9528.41,9528.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','66',253,'1','1',11711.98,12064.94,0.00,0.00,352.96,218835.20,0.00,0.00,0.00),('1','223','1','66',254,'2','1',10012.46,10403.00,0.00,0.00,390.54,242134.80,0.00,0.00,0.00),('1','223','1','66',255,'3','1',16085.08,16210.08,0.00,0.00,125.00,75000.00,0.00,0.00,0.00),('1','223','1','66',256,'4','1',9528.41,9578.41,0.00,0.00,50.00,30000.00,0.00,0.00,0.00),('1','223','1','67',257,'1','1',12064.94,12243.65,0.00,0.00,178.71,110800.20,0.00,0.00,0.00),('1','223','1','67',258,'2','1',10403.00,10547.16,0.00,0.00,144.16,89379.20,0.00,0.00,0.00),('1','223','1','67',259,'3','1',16210.08,16898.08,0.00,0.00,688.00,405920.00,0.00,0.00,0.00),('1','223','1','67',260,'4','1',9578.41,9711.91,0.00,0.00,133.50,78765.00,0.00,0.00,0.00),('1','223','1','68',261,'1','1',12243.65,12450.24,0.00,0.00,206.59,128085.80,0.00,0.00,0.00),('1','223','1','68',262,'2','1',10547.16,10746.94,0.00,0.00,199.78,123863.60,0.00,0.00,0.00),('1','223','1','68',263,'3','1',16898.08,17953.08,0.00,0.00,1055.00,622450.00,0.00,0.00,0.00),('1','223','1','68',264,'4','1',9711.91,9791.91,0.00,0.00,80.00,47200.00,0.00,0.00,0.00),('1','223','1','69',265,'1','1',12450.24,12666.78,0.00,0.00,216.54,134254.80,0.00,0.00,0.00),('1','223','1','69',266,'2','1',10746.94,10992.93,0.00,0.00,245.99,152513.80,0.00,0.00,0.00),('1','223','1','69',267,'3','1',17953.08,18044.08,0.00,0.00,91.00,53690.00,0.00,0.00,0.00),('1','223','1','69',268,'4','1',9791.91,10026.91,0.00,0.00,235.00,138650.00,0.00,0.00,0.00),('1','223','1','70',269,'1','1',12666.78,12883.94,0.00,0.00,217.16,134639.20,0.00,0.00,0.00),('1','223','1','70',270,'2','1',10992.93,11265.57,0.00,0.00,272.64,169036.80,0.00,0.00,0.00),('1','223','1','70',271,'3','1',18044.08,18410.77,0.00,0.00,366.69,216347.10,0.00,0.00,0.00),('1','223','1','70',272,'4','1',10026.91,10076.91,0.00,0.00,50.00,29500.00,0.00,0.00,0.00),('1','223','1','71',273,'1','1',12883.94,13237.69,0.00,0.00,353.75,219325.00,0.00,0.00,0.00),('1','223','1','71',274,'2','1',11265.57,11591.42,0.00,0.00,325.85,202027.00,0.00,0.00,0.00),('1','223','1','71',275,'3','1',18410.77,18500.77,0.00,0.00,90.00,53100.00,0.00,0.00,0.00),('1','223','1','71',276,'4','1',10076.91,10076.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','72',277,'1','1',13237.69,13508.44,0.00,0.00,270.75,167865.00,0.00,0.00,0.00),('1','223','1','72',278,'2','1',11591.42,11944.59,0.00,0.00,353.17,218965.40,0.00,0.00,0.00),('1','223','1','72',279,'3','1',18500.77,19533.77,0.00,0.00,1033.00,609470.00,0.00,0.00,0.00),('1','223','1','72',280,'4','1',10076.91,10426.91,0.00,0.00,350.00,206500.00,0.00,0.00,0.00),('1','223','1','73',281,'1','1',13508.44,13755.09,0.00,0.00,246.65,152923.00,0.00,0.00,0.00),('1','223','1','73',282,'2','1',11944.59,12196.44,0.00,0.00,251.85,156147.00,0.00,0.00,0.00),('1','223','1','73',283,'3','1',19533.77,19583.77,0.00,0.00,50.00,29500.00,0.00,0.00,0.00),('1','223','1','73',284,'4','1',10426.91,10426.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','74',285,'1','1',13755.09,14013.52,0.00,0.00,258.43,160226.60,0.00,0.00,0.00),('1','223','1','74',286,'2','1',12196.44,12474.85,0.00,0.00,278.41,172614.20,0.00,0.00,0.00),('1','223','1','74',287,'3','1',19583.77,19803.77,0.00,0.00,220.00,129800.00,0.00,0.00,0.00),('1','223','1','74',288,'4','1',10426.91,10756.91,0.00,0.00,330.00,194700.00,0.00,0.00,0.00),('1','223','1','75',289,'1','1',14013.52,14266.16,0.00,0.00,252.64,156636.80,0.00,0.00,0.00),('1','223','1','75',290,'2','1',12474.85,12755.37,0.00,0.00,280.52,173922.40,0.00,0.00,0.00),('1','223','1','75',291,'3','1',19803.77,20621.77,0.00,0.00,818.00,482620.00,0.00,0.00,0.00),('1','223','1','75',292,'4','1',10756.91,10956.91,0.00,0.00,200.00,118000.00,0.00,0.00,0.00),('1','223','1','76',293,'1','1',14266.16,14421.31,0.00,0.00,155.15,96193.00,0.00,0.00,0.00),('1','223','1','76',294,'2','1',12755.37,12940.38,0.00,0.00,185.01,114706.20,0.00,0.00,0.00),('1','223','1','76',295,'3','1',20621.77,20771.98,0.00,0.00,150.21,88623.90,0.00,0.00,0.00),('1','223','1','76',296,'4','1',10956.91,10956.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','77',297,'1','1',14421.31,14421.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','77',298,'2','1',12940.38,12940.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','77',299,'3','1',20771.98,20771.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','77',300,'4','1',10956.91,10956.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','78',301,'1','1',14421.31,14462.25,0.00,0.00,40.94,25382.80,0.00,0.00,0.00),('1','223','1','78',302,'2','1',12940.38,13005.28,0.00,0.00,64.90,40238.00,0.00,0.00,0.00),('1','223','1','78',303,'3','1',20771.98,20846.77,0.00,0.00,74.79,44126.10,0.00,0.00,0.00),('1','223','1','78',304,'4','1',10956.91,10956.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','79',305,'1','1',14462.25,14714.55,0.00,0.00,252.30,158949.00,0.00,0.00,0.00),('1','223','1','79',306,'2','1',13005.28,13297.47,0.00,0.00,292.19,184079.70,0.00,0.00,0.00),('1','223','1','79',307,'3','1',20846.77,21773.79,0.00,0.00,927.02,558993.06,0.00,0.00,0.00),('1','223','1','79',308,'4','1',10956.91,11072.91,0.00,0.00,116.00,69948.00,0.00,0.00,0.00),('1','223','1','80',309,'1','1',14714.55,14972.86,0.00,0.00,258.31,162735.30,0.00,0.00,0.00),('1','223','1','80',310,'2','1',13297.47,13483.46,0.00,0.00,185.99,117173.70,0.00,0.00,0.00),('1','223','1','80',311,'3','1',21773.79,22901.44,0.00,0.00,1127.65,679972.95,0.00,0.00,0.00),('1','223','1','80',312,'4','1',11072.91,11072.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','81',313,'1','1',14972.86,15199.87,0.00,0.00,227.01,143016.30,0.00,0.00,0.00),('1','223','1','81',314,'2','1',13483.46,13726.13,0.00,0.00,242.67,152882.10,0.00,0.00,0.00),('1','223','1','81',315,'3','1',22901.44,22981.44,0.00,0.00,80.00,48240.00,0.00,0.00,0.00),('1','223','1','81',316,'4','1',11072.91,11444.41,0.00,0.00,371.50,224014.50,0.00,0.00,0.00),('1','223','1','82',317,'1','1',15199.87,15493.52,0.00,0.00,293.65,197332.80,0.00,0.00,0.00),('1','223','1','82',318,'2','1',13726.13,13937.30,0.00,0.00,211.17,141906.24,0.00,0.00,0.00),('1','223','1','82',319,'3','1',22981.44,22981.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','82',320,'4','1',11444.41,11444.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','83',321,'1','1',15493.52,15838.59,0.00,0.00,345.07,229687.04,0.00,0.00,0.00),('1','223','1','83',322,'2','1',13937.30,14259.80,0.00,0.00,322.50,216720.00,0.00,0.00,0.00),('1','223','1','83',323,'3','1',22981.44,23183.45,0.00,0.00,202.01,126950.72,0.00,0.00,0.00),('1','223','1','83',324,'4','1',11444.41,11536.41,0.00,0.00,92.00,57776.00,0.00,0.00,0.00),('1','223','1','84',325,'1','1',15838.59,16116.75,0.00,0.00,278.16,186923.52,0.00,0.00,0.00),('1','223','1','84',326,'2','1',14259.80,14541.86,0.00,0.00,282.06,189544.32,0.00,0.00,0.00),('1','223','1','84',327,'3','1',23183.45,23233.45,0.00,0.00,50.00,31400.00,0.00,0.00,0.00),('1','223','1','84',328,'4','1',11536.41,11566.41,0.00,0.00,30.00,18840.00,0.00,0.00,0.00),('1','223','1','85',329,'1','1',16116.75,16425.40,0.00,0.00,308.65,207412.80,0.00,0.00,0.00),('1','223','1','85',330,'2','1',14541.86,14771.87,0.00,0.00,230.01,154566.72,0.00,0.00,0.00),('1','223','1','85',331,'3','1',23233.45,23463.45,0.00,0.00,230.00,144440.00,0.00,0.00,0.00),('1','223','1','85',332,'4','1',11566.41,11801.41,0.00,0.00,235.00,147580.00,0.00,0.00,0.00),('1','223','1','86',333,'1','1',16425.40,16563.31,0.00,0.00,137.91,92675.52,0.00,0.00,0.00),('1','223','1','86',334,'2','1',14771.87,14838.70,0.00,0.00,66.83,44909.76,0.00,0.00,0.00),('1','223','1','86',335,'3','1',23463.45,23513.45,0.00,0.00,50.00,31400.00,0.00,0.00,0.00),('1','223','1','86',336,'4','1',11801.41,11956.41,0.00,0.00,155.00,97340.00,0.00,0.00,0.00),('1','223','1','87',337,'1','1',16563.31,16771.07,0.00,0.00,207.76,139614.72,0.00,0.00,0.00),('1','223','1','87',338,'2','1',14838.70,14858.95,0.00,0.00,20.25,13608.00,0.00,0.00,0.00),('1','223','1','87',339,'3','1',23513.45,24275.47,0.00,0.00,762.02,478548.56,0.00,0.00,0.00),('1','223','1','87',340,'4','1',11956.41,15968.91,0.00,0.00,4012.50,2519850.00,0.00,0.00,0.00),('1','223','1','88',341,'1','1',16771.07,16771.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','88',342,'2','1',14858.95,14858.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','88',343,'3','1',24275.47,24344.34,0.00,0.00,68.87,43250.36,0.00,0.00,0.00),('1','223','1','88',344,'4','1',15968.91,15968.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','89',345,'1','1',16771.07,16771.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','89',346,'2','1',14858.95,14858.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','89',347,'3','1',24344.34,24344.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','89',348,'4','1',15968.91,15968.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','90',349,'1','1',16771.07,16837.21,0.00,0.00,66.14,48149.92,0.00,0.00,0.00),('1','223','1','90',350,'2','1',14858.95,14908.15,0.00,0.00,49.20,35817.60,0.00,0.00,0.00),('1','223','1','90',351,'3','1',24344.34,24404.34,0.00,0.00,60.00,41400.00,0.00,0.00,0.00),('1','223','1','90',352,'4','1',15968.91,15968.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','91',353,'1','1',16837.21,16922.57,0.00,0.00,85.36,62142.08,0.00,0.00,0.00),('1','223','1','91',354,'2','1',14908.15,15006.98,0.00,0.00,98.83,71948.24,0.00,0.00,0.00),('1','223','1','91',355,'3','1',24404.34,25152.34,0.00,0.00,748.00,516120.00,0.00,0.00,0.00),('1','223','1','91',356,'4','1',15968.91,16118.91,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','223','1','92',357,'1','1',16922.57,17047.66,0.00,0.00,125.09,91065.52,0.00,0.00,0.00),('1','223','1','92',358,'2','1',15006.98,15113.05,0.00,0.00,106.07,77218.96,0.00,0.00,0.00),('1','223','1','92',359,'3','1',25152.34,26207.34,0.00,0.00,1055.00,727950.00,0.00,0.00,0.00),('1','223','1','92',360,'4','1',16118.91,16756.91,0.00,0.00,638.00,440220.00,0.00,0.00,0.00),('1','223','1','93',361,'1','1',17047.66,17209.35,0.00,0.00,161.69,117710.32,0.00,0.00,0.00),('1','223','1','93',362,'2','1',15113.05,15221.46,0.00,0.00,108.41,78922.48,0.00,0.00,0.00),('1','223','1','93',363,'3','1',26207.34,26490.34,0.00,0.00,283.00,195270.00,0.00,0.00,0.00),('1','223','1','93',364,'4','1',16756.91,16856.91,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','223','1','94',365,'1','1',17209.35,17410.53,0.00,0.00,201.18,146459.04,0.00,0.00,0.00),('1','223','1','94',366,'2','1',15221.46,15418.95,0.00,0.00,197.49,143772.72,0.00,0.00,0.00),('1','223','1','94',367,'3','1',26490.34,26799.84,0.00,0.00,309.50,213555.00,0.00,0.00,0.00),('1','223','1','94',368,'4','1',16856.91,16911.91,0.00,0.00,55.00,37950.00,0.00,0.00,0.00),('1','223','1','95',369,'1','1',17410.53,17534.28,0.00,0.00,123.75,90090.00,0.00,0.00,0.00),('1','223','1','95',370,'2','1',15418.95,15529.71,0.00,0.00,110.76,80633.28,0.00,0.00,0.00),('1','223','1','95',371,'3','1',26799.84,26866.34,0.00,0.00,66.50,45885.00,0.00,0.00,0.00),('1','223','1','95',372,'4','1',16911.91,16911.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','96',373,'1','1',17534.28,17547.86,0.00,0.00,13.58,9886.24,0.00,0.00,0.00),('1','223','1','96',374,'2','1',15529.71,15539.76,0.00,0.00,10.05,7316.40,0.00,0.00,0.00),('1','223','1','96',375,'3','1',26866.34,27416.59,0.00,0.00,550.25,379672.50,0.00,0.00,0.00),('1','223','1','96',376,'4','1',16911.91,16915.99,0.00,0.00,4.08,2815.20,0.00,0.00,0.00),('1','223','1','97',377,'1','1',17547.86,17547.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','97',378,'2','1',15539.76,15539.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','97',379,'3','1',27416.59,27416.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','97',380,'4','1',16915.99,16915.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','98',381,'1','1',17547.86,17590.41,0.00,0.00,42.55,30976.40,0.00,0.00,0.00),('1','223','1','98',382,'2','1',15539.76,15567.74,0.00,0.00,27.98,20369.44,0.00,0.00,0.00),('1','223','1','98',383,'3','1',27416.59,27416.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','98',384,'4','1',16915.99,16915.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','99',385,'1','1',17590.41,17800.00,0.00,0.00,209.59,152581.52,0.00,0.00,0.00),('1','223','1','99',386,'2','1',15567.74,15724.63,0.00,0.00,156.89,114215.92,0.00,0.00,0.00),('1','223','1','99',387,'3','1',27416.59,27526.59,0.00,0.00,110.00,75900.00,0.00,0.00,0.00),('1','223','1','99',388,'4','1',16915.99,16915.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','100',389,'1','1',17800.00,18022.41,0.00,0.00,222.41,161914.48,0.00,0.00,0.00),('1','223','1','100',390,'2','1',15724.63,15934.70,0.00,0.00,210.07,152930.96,0.00,0.00,0.00),('1','223','1','100',391,'3','1',27526.59,27526.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','100',392,'4','1',16915.99,16915.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','101',393,'1','1',18022.41,18182.46,0.00,0.00,160.05,116516.40,0.00,0.00,0.00),('1','223','1','101',394,'2','1',15934.70,16090.92,0.00,0.00,156.22,113728.16,0.00,0.00,0.00),('1','223','1','101',395,'3','1',27526.59,27641.59,0.00,0.00,115.00,79350.00,0.00,0.00,0.00),('1','223','1','101',396,'4','1',16915.99,16975.99,0.00,0.00,60.00,41400.00,0.00,0.00,0.00),('1','223','1','102',397,'1','1',18182.46,18341.91,0.00,0.00,159.45,116079.60,0.00,0.00,0.00),('1','223','1','102',398,'2','1',16090.92,16260.41,0.00,0.00,169.49,123388.72,0.00,0.00,0.00),('1','223','1','102',399,'3','1',27641.59,28304.59,0.00,0.00,663.00,457470.00,0.00,0.00,0.00),('1','223','1','102',400,'4','1',16975.99,17327.49,0.00,0.00,351.50,242535.00,0.00,0.00,0.00),('1','223','1','103',401,'1','1',18341.91,18490.16,0.00,0.00,148.25,107926.00,0.00,0.00,0.00),('1','223','1','103',402,'2','1',16260.41,16442.85,0.00,0.00,182.44,132816.32,0.00,0.00,0.00),('1','223','1','103',403,'3','1',28304.59,28304.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','103',404,'4','1',17327.49,17382.49,0.00,0.00,55.00,37950.00,0.00,0.00,0.00),('1','223','1','104',405,'1','1',18490.16,18599.84,0.00,0.00,109.68,79847.04,0.00,0.00,0.00),('1','223','1','104',406,'2','1',16442.85,16556.23,0.00,0.00,113.38,82540.64,0.00,0.00,0.00),('1','223','1','104',407,'3','1',28304.59,28489.59,0.00,0.00,185.00,127650.00,0.00,0.00,0.00),('1','223','1','104',408,'4','1',17382.49,17457.49,0.00,0.00,75.00,51750.00,0.00,0.00,0.00),('1','223','1','105',409,'1','1',18599.84,18599.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','105',410,'2','1',16556.23,16556.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','105',411,'3','1',28489.59,28489.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','105',412,'4','1',17457.49,17457.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','106',413,'1','1',18599.84,18837.72,0.00,0.00,237.88,173176.64,0.00,0.00,0.00),('1','223','1','106',414,'2','1',16556.23,16763.28,0.00,0.00,207.05,150732.40,0.00,0.00,0.00),('1','223','1','106',415,'3','1',28489.59,29227.59,0.00,0.00,738.00,509220.00,0.00,0.00,0.00),('1','223','1','106',416,'4','1',17457.49,17482.49,0.00,0.00,25.00,17250.00,0.00,0.00,0.00),('1','223','1','107',417,'1','1',18837.72,19025.21,0.00,0.00,187.49,136492.72,0.00,0.00,0.00),('1','223','1','107',418,'2','1',16763.28,16961.60,0.00,0.00,198.32,144376.96,0.00,0.00,0.00),('1','223','1','107',419,'3','1',29227.59,29230.59,0.00,0.00,3.00,2070.00,0.00,0.00,0.00),('1','223','1','107',420,'4','1',17482.49,17806.49,0.00,0.00,324.00,223560.00,0.00,0.00,0.00),('1','223','1','108',421,'1','1',19025.21,19162.63,0.00,0.00,137.42,100041.76,0.00,0.00,0.00),('1','223','1','108',422,'2','1',16961.60,17132.08,0.00,0.00,170.48,124109.44,0.00,0.00,0.00),('1','223','1','108',423,'3','1',29230.59,29636.59,0.00,0.00,406.00,280140.00,0.00,0.00,0.00),('1','223','1','108',424,'4','1',17806.49,17914.49,0.00,0.00,108.00,74520.00,0.00,0.00,0.00),('1','223','1','109',425,'1','1',19162.63,19403.85,0.00,0.00,241.22,175608.16,0.00,0.00,0.00),('1','223','1','109',426,'2','1',17132.08,17360.33,0.00,0.00,228.25,166166.00,0.00,0.00,0.00),('1','223','1','109',427,'3','1',29636.59,29689.63,0.00,0.00,53.04,36597.60,0.00,0.00,0.00),('1','223','1','109',428,'4','1',17914.49,18079.99,0.00,0.00,165.50,114195.00,0.00,0.00,0.00),('1','223','1','110',429,'1','1',19403.85,19513.41,0.00,0.00,109.56,79759.68,0.00,0.00,0.00),('1','223','1','110',430,'2','1',17360.33,17513.82,0.00,0.00,153.49,111740.72,0.00,0.00,0.00),('1','223','1','110',431,'3','1',29689.63,30174.03,0.00,0.00,484.40,334236.00,0.00,0.00,0.00),('1','223','1','110',432,'4','1',18079.99,18287.99,0.00,0.00,208.00,143520.00,0.00,0.00,0.00),('1','223','1','111',433,'1','1',19513.41,19739.36,0.00,0.00,225.95,164491.60,0.00,0.00,0.00),('1','223','1','111',434,'2','1',17513.82,17714.13,0.00,0.00,200.31,145825.68,0.00,0.00,0.00),('1','223','1','111',435,'3','1',30174.03,30812.03,0.00,0.00,638.00,440220.00,0.00,0.00,0.00),('1','223','1','111',436,'4','1',18287.99,18556.09,0.00,0.00,268.10,184989.00,0.00,0.00,0.00),('1','223','1','112',437,'1','1',19739.36,19938.91,0.00,0.00,199.55,145272.40,0.00,0.00,0.00),('1','223','1','112',438,'2','1',17714.13,17998.24,0.00,0.00,284.11,206832.08,0.00,0.00,0.00),('1','223','1','112',439,'3','1',30812.03,31008.03,0.00,0.00,196.00,135240.00,0.00,0.00,0.00),('1','223','1','112',440,'4','1',18556.09,19105.09,0.00,0.00,549.00,378810.00,0.00,0.00,0.00),('1','223','1','113',441,'1','1',19938.91,20130.20,0.00,0.00,191.29,139259.12,0.00,0.00,0.00),('1','223','1','113',442,'2','1',17998.24,18211.95,0.00,0.00,213.71,155580.88,0.00,0.00,0.00),('1','223','1','113',443,'3','1',31008.03,31646.03,0.00,0.00,638.00,440220.00,0.00,0.00,0.00),('1','223','1','113',444,'4','1',19105.09,20465.04,0.00,0.00,1359.95,938365.50,0.00,0.00,0.00),('1','223','1','114',445,'1','1',20130.20,20337.76,0.00,0.00,207.56,151103.68,0.00,0.00,0.00),('1','223','1','114',446,'2','1',18211.95,18473.95,0.00,0.00,262.00,190736.00,0.00,0.00,0.00),('1','223','1','114',447,'3','1',31646.03,32302.26,0.00,0.00,656.23,452798.70,0.00,0.00,0.00),('1','223','1','114',448,'4','1',20465.04,20665.04,0.00,0.00,200.00,138000.00,0.00,0.00,0.00),('1','223','1','115',449,'1','1',20337.76,20449.53,0.00,0.00,111.77,81368.56,0.00,0.00,0.00),('1','223','1','115',450,'2','1',18473.95,18613.10,0.00,0.00,139.15,101301.20,0.00,0.00,0.00),('1','223','1','115',451,'3','1',32302.26,33157.26,0.00,0.00,855.00,589950.00,0.00,0.00,0.00),('1','223','1','115',452,'4','1',20665.04,21101.54,0.00,0.00,436.50,301185.00,0.00,0.00,0.00),('1','223','1','116',453,'1','1',20449.53,20449.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','116',454,'2','1',18613.10,18613.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','116',455,'3','1',33157.26,33157.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','116',456,'4','1',21101.54,21101.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','117',457,'1','1',20449.53,20449.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','117',458,'2','1',18613.10,18613.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','117',459,'3','1',33157.26,33157.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','117',460,'4','1',21101.54,21101.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','118',461,'1','1',20449.53,20596.07,0.00,0.00,146.54,106681.12,0.00,0.00,0.00),('1','223','1','118',462,'2','1',18613.10,18805.11,0.00,0.00,192.01,139783.28,0.00,0.00,0.00),('1','223','1','118',463,'3','1',33157.26,33157.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','118',464,'4','1',21101.54,21369.54,0.00,0.00,268.00,183580.00,0.00,0.00,0.00),('1','223','1','119',465,'1','1',20596.07,20830.46,0.00,0.00,234.39,170635.92,0.00,0.00,0.00),('1','223','1','119',466,'2','1',18805.11,19042.00,0.00,0.00,236.89,172455.92,0.00,0.00,0.00),('1','223','1','119',467,'3','1',33157.26,33825.26,0.00,0.00,668.00,457580.00,0.00,0.00,0.00),('1','223','1','119',468,'4','1',21369.54,21549.54,0.00,0.00,180.00,123300.00,0.00,0.00,0.00),('1','223','1','120',469,'1','1',20830.46,21036.57,0.00,0.00,206.11,150048.08,0.00,0.00,0.00),('1','223','1','120',470,'2','1',19042.00,19331.12,0.00,0.00,289.12,210479.36,0.00,0.00,0.00),('1','223','1','120',471,'3','1',33825.26,34281.26,0.00,0.00,456.00,312360.00,0.00,0.00,0.00),('1','223','1','120',472,'4','1',21549.54,21807.04,0.00,0.00,257.50,176387.50,0.00,0.00,0.00),('1','223','1','121',473,'1','1',21036.57,21212.01,0.00,0.00,175.44,127720.32,0.00,0.00,0.00),('1','223','1','121',474,'2','1',19331.12,19535.19,0.00,0.00,204.07,148562.96,0.00,0.00,0.00),('1','223','1','121',475,'3','1',34281.26,34396.26,0.00,0.00,115.00,78775.00,0.00,0.00,0.00),('1','223','1','121',476,'4','1',21807.04,22213.04,0.00,0.00,406.00,278110.00,0.00,0.00,0.00),('1','223','1','122',477,'1','1',21212.01,21447.81,0.00,0.00,235.80,171662.40,0.00,0.00,0.00),('1','223','1','122',478,'2','1',19535.19,19833.85,0.00,0.00,298.66,217424.48,0.00,0.00,0.00),('1','223','1','122',479,'3','1',34396.26,34852.26,0.00,0.00,456.00,312360.00,0.00,0.00,0.00),('1','223','1','122',480,'4','1',22213.04,22438.04,0.00,0.00,225.00,154125.00,0.00,0.00,0.00),('1','223','1','123',481,'1','1',21447.81,21636.85,0.00,0.00,189.04,137621.12,0.00,0.00,0.00),('1','223','1','123',482,'2','1',19833.85,20091.79,0.00,0.00,257.94,187780.32,0.00,0.00,0.00),('1','223','1','123',483,'3','1',34852.26,35179.91,0.00,0.00,327.65,224440.25,0.00,0.00,0.00),('1','223','1','123',484,'4','1',22438.04,22538.04,0.00,0.00,100.00,68500.00,0.00,0.00,0.00),('1','223','1','124',485,'1','1',21636.85,21877.88,0.00,0.00,241.03,175469.84,0.00,0.00,0.00),('1','223','1','124',486,'2','1',20091.79,20430.37,0.00,0.00,338.58,249258.24,0.00,0.00,0.00),('1','223','1','124',487,'3','1',35179.91,35307.91,0.00,0.00,128.00,87680.00,0.00,0.00,0.00),('1','223','1','124',488,'4','1',22538.04,23766.04,0.00,0.00,1228.00,841180.00,0.00,0.00,0.00),('1','223','1','125',489,'1','1',21877.88,22143.86,0.00,0.00,265.98,193633.44,0.00,0.00,0.00),('1','223','1','125',490,'2','1',20430.37,20723.90,0.00,0.00,293.53,213689.84,0.00,0.00,0.00),('1','223','1','125',491,'3','1',35307.91,35327.91,0.00,0.00,20.00,13700.00,0.00,0.00,0.00),('1','223','1','125',492,'4','1',23766.04,25005.24,0.00,0.00,1239.20,848852.00,0.00,0.00,0.00),('1','223','1','126',493,'1','1',22143.86,22313.47,0.00,0.00,169.61,123476.08,0.00,0.00,0.00),('1','223','1','126',494,'2','1',20723.90,20846.74,0.00,0.00,122.84,89427.52,0.00,0.00,0.00),('1','223','1','126',495,'3','1',35327.91,35407.91,0.00,0.00,80.00,54800.00,0.00,0.00,0.00),('1','223','1','126',496,'4','1',25005.24,25242.74,0.00,0.00,237.50,162687.50,0.00,0.00,0.00),('1','223','1','127',497,'1','1',22313.47,22326.52,0.00,0.00,13.05,9500.40,0.00,0.00,0.00),('1','223','1','127',498,'2','1',20846.74,20855.74,0.00,0.00,9.00,6552.00,0.00,0.00,0.00),('1','223','1','127',499,'3','1',35407.91,35413.91,0.00,0.00,6.00,4110.00,0.00,0.00,0.00),('1','223','1','127',500,'4','1',25242.74,26146.65,0.00,0.00,903.91,619178.35,0.00,0.00,0.00),('1','223','1','128',501,'1','1',22326.52,22326.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','128',502,'2','1',20855.74,20855.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','128',503,'3','1',35413.91,35413.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','128',504,'4','1',26146.65,26146.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','129',505,'1','1',22326.52,22428.74,0.00,0.00,102.22,74416.16,0.00,0.00,0.00),('1','223','1','129',506,'2','1',20855.74,20968.99,0.00,0.00,113.25,82446.00,0.00,0.00,0.00),('1','223','1','129',507,'3','1',35413.91,35463.91,0.00,0.00,50.00,34250.00,0.00,0.00,0.00),('1','223','1','129',508,'4','1',26146.65,26484.90,0.00,0.00,338.25,231701.25,0.00,0.00,0.00),('1','223','1','130',509,'1','1',22428.74,22673.67,0.00,0.00,244.93,178309.04,0.00,0.00,0.00),('1','223','1','130',510,'2','1',20968.99,21146.96,0.00,0.00,177.97,129562.16,0.00,0.00,0.00),('1','223','1','130',511,'3','1',35463.91,35507.91,0.00,0.00,44.00,30140.00,0.00,0.00,0.00),('1','223','1','130',512,'4','1',26484.90,26534.90,0.00,0.00,50.00,34250.00,0.00,0.00,0.00),('1','223','1','131',513,'1','1',22673.67,22862.36,0.00,0.00,188.69,137366.32,0.00,0.00,0.00),('1','223','1','131',514,'2','1',21146.96,21324.09,0.00,0.00,177.13,128950.64,0.00,0.00,0.00),('1','223','1','131',515,'3','1',35507.91,36315.91,0.00,0.00,808.00,553480.00,0.00,0.00,0.00),('1','223','1','131',516,'4','1',26534.90,26822.40,0.00,0.00,287.50,196937.50,0.00,0.00,0.00),('1','223','1','132',517,'1','1',22862.36,23026.84,0.00,0.00,164.48,119741.44,0.00,0.00,0.00),('1','223','1','132',518,'2','1',21324.09,21520.91,0.00,0.00,196.82,143284.96,0.00,0.00,0.00),('1','223','1','132',519,'3','1',36315.91,36465.91,0.00,0.00,150.00,102750.00,0.00,0.00,0.00),('1','223','1','132',520,'4','1',26822.40,28619.70,0.00,0.00,1797.30,1231150.50,0.00,0.00,0.00),('1','223','1','133',521,'1','1',23026.84,23060.37,0.00,0.00,33.53,24409.84,0.00,0.00,0.00),('1','223','1','133',522,'2','1',21520.91,21580.38,0.00,0.00,59.47,43294.16,0.00,0.00,0.00),('1','223','1','133',523,'3','1',36465.91,36565.91,0.00,0.00,100.00,68500.00,0.00,0.00,0.00),('1','223','1','133',524,'4','1',28619.70,28619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','134',525,'1','1',23060.37,23060.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','134',526,'2','1',21580.38,21580.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','134',527,'3','1',36565.91,36565.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','134',528,'4','1',28619.70,28619.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','135',529,'1','1',23060.37,23215.68,0.00,0.00,155.31,113065.68,0.00,0.00,0.00),('1','223','1','135',530,'2','1',21580.38,21747.67,0.00,0.00,167.29,121787.12,0.00,0.00,0.00),('1','223','1','135',531,'3','1',36565.91,36828.41,0.00,0.00,262.50,179812.50,0.00,0.00,0.00),('1','223','1','135',532,'4','1',28619.70,28691.70,0.00,0.00,72.00,49320.00,0.00,0.00,0.00),('1','223','1','136',533,'1','1',23215.68,23421.03,0.00,0.00,205.35,149494.80,0.00,0.00,0.00),('1','223','1','136',534,'2','1',21747.67,22003.26,0.00,0.00,255.59,186069.52,0.00,0.00,0.00),('1','223','1','136',535,'3','1',36828.41,37466.41,0.00,0.00,638.00,437030.00,0.00,0.00,0.00),('1','223','1','136',536,'4','1',28691.70,28866.70,0.00,0.00,175.00,119875.00,0.00,0.00,0.00),('1','223','1','137',537,'1','1',23421.03,23598.36,0.00,0.00,177.33,129096.24,0.00,0.00,0.00),('1','223','1','137',538,'2','1',22003.26,22215.76,0.00,0.00,212.50,154700.00,0.00,0.00,0.00),('1','223','1','137',539,'3','1',37466.41,37570.41,0.00,0.00,104.00,70768.00,0.00,0.00,0.00),('1','223','1','137',540,'4','1',28866.70,29901.70,0.00,0.00,1035.00,703800.00,0.00,0.00,0.00),('1','223','1','138',541,'1','1',23598.36,23763.67,0.00,0.00,165.31,120345.68,0.00,0.00,0.00),('1','223','1','138',542,'2','1',22215.76,22471.56,0.00,0.00,255.80,186222.40,0.00,0.00,0.00),('1','223','1','138',543,'3','1',37570.41,37572.18,0.00,0.00,1.77,1203.60,0.00,0.00,0.00),('1','223','1','138',544,'4','1',29901.70,30419.70,0.00,0.00,518.00,352240.00,0.00,0.00,0.00),('1','223','1','139',545,'1','1',23763.67,23967.00,0.00,0.00,203.33,148024.24,0.00,0.00,0.00),('1','223','1','139',546,'2','1',22471.56,22739.54,0.00,0.00,267.98,195089.44,0.00,0.00,0.00),('1','223','1','139',547,'3','1',37572.18,37572.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','139',548,'4','1',30419.70,31057.70,0.00,0.00,638.00,433840.00,0.00,0.00,0.00),('1','223','1','140',549,'1','1',23967.00,24342.21,0.00,0.00,375.21,273152.88,0.00,0.00,0.00),('1','223','1','140',550,'2','1',22739.54,23215.15,0.00,0.00,475.61,346244.08,0.00,0.00,0.00),('1','223','1','140',551,'3','1',37572.18,37920.51,0.00,0.00,348.33,236864.40,0.00,0.00,0.00),('1','223','1','140',552,'4','1',31057.70,32043.70,0.00,0.00,986.00,670480.00,0.00,0.00,0.00),('1','223','1','141',553,'1','1',24342.21,24549.54,0.00,0.00,207.33,150936.24,0.00,0.00,0.00),('1','223','1','141',554,'2','1',23215.15,23465.42,0.00,0.00,250.27,182196.56,0.00,0.00,0.00),('1','223','1','141',555,'3','1',37920.51,37920.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','141',556,'4','1',32043.70,32741.70,0.00,0.00,698.00,474640.00,0.00,0.00,0.00),('1','223','1','142',557,'1','1',24549.54,24756.08,0.00,0.00,206.54,150361.12,0.00,0.00,0.00),('1','223','1','142',558,'2','1',23465.42,23708.16,0.00,0.00,242.74,176714.72,0.00,0.00,0.00),('1','223','1','142',559,'3','1',37920.51,38070.51,0.00,0.00,150.00,102000.00,0.00,0.00,0.00),('1','223','1','142',560,'4','1',32741.70,33372.70,0.00,0.00,631.00,429080.00,0.00,0.00,0.00),('1','223','1','143',561,'1','1',24756.08,24995.82,0.00,0.00,239.74,174530.72,0.00,0.00,0.00),('1','223','1','143',562,'2','1',23708.16,23953.49,0.00,0.00,245.33,178600.24,0.00,0.00,0.00),('1','223','1','143',563,'3','1',38070.51,38128.51,0.00,0.00,58.00,39440.00,0.00,0.00,0.00),('1','223','1','143',564,'4','1',33372.70,34194.70,0.00,0.00,822.00,558960.00,0.00,0.00,0.00),('1','223','1','144',565,'1','1',24995.82,25172.62,0.00,0.00,176.80,128710.40,0.00,0.00,0.00),('1','223','1','144',566,'2','1',23953.49,24133.73,0.00,0.00,180.24,131214.72,0.00,0.00,0.00),('1','223','1','144',567,'3','1',38128.51,38293.51,0.00,0.00,165.00,112200.00,0.00,0.00,0.00),('1','223','1','144',568,'4','1',34194.70,34671.06,0.00,0.00,476.36,323924.80,0.00,0.00,0.00),('1','223','1','145',569,'1','1',25172.62,25172.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','145',570,'2','1',24133.73,24133.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','145',571,'3','1',38293.51,38293.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','145',572,'4','1',34671.06,34671.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','146',573,'1','1',25172.62,25458.94,0.00,0.00,286.32,208440.96,0.00,0.00,0.00),('1','223','1','146',574,'2','1',24133.73,24379.61,0.00,0.00,245.88,179000.64,0.00,0.00,0.00),('1','223','1','146',575,'3','1',38293.51,39130.51,0.00,0.00,837.00,569160.00,0.00,0.00,0.00),('1','223','1','146',576,'4','1',34671.06,35545.06,0.00,0.00,874.00,594320.00,0.00,0.00,0.00),('1','223','1','147',577,'1','1',25458.94,25683.27,0.00,0.00,224.33,163312.24,0.00,0.00,0.00),('1','223','1','147',578,'2','1',24379.61,24608.49,0.00,0.00,228.88,166624.64,0.00,0.00,0.00),('1','223','1','147',579,'3','1',39130.51,39130.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','147',580,'4','1',35545.06,35545.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','148',581,'1','1',25683.27,25920.93,0.00,0.00,237.66,173016.48,0.00,0.00,0.00),('1','223','1','148',582,'2','1',24608.49,24826.58,0.00,0.00,218.09,158769.52,0.00,0.00,0.00),('1','223','1','148',583,'3','1',39130.51,39824.51,0.00,0.00,694.00,471920.00,0.00,0.00,0.00),('1','223','1','148',584,'4','1',35545.06,35821.06,0.00,0.00,276.00,187680.00,0.00,0.00,0.00),('1','223','1','149',585,'1','1',25920.93,26045.30,0.00,0.00,124.37,90541.36,0.00,0.00,0.00),('1','223','1','149',586,'2','1',24826.58,24981.67,0.00,0.00,155.09,112905.52,0.00,0.00,0.00),('1','223','1','149',587,'3','1',39824.51,39982.51,0.00,0.00,158.00,107440.00,0.00,0.00,0.00),('1','223','1','149',588,'4','1',35821.06,36335.31,0.00,0.00,514.25,349690.00,0.00,0.00,0.00),('1','223','1','150',589,'1','1',26045.30,26045.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','150',590,'2','1',24981.67,24981.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','150',591,'3','1',39982.51,39982.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','150',592,'4','1',36335.31,36335.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','151',593,'1','1',26045.30,26112.41,0.00,0.00,67.11,48856.08,0.00,0.00,0.00),('1','223','1','151',594,'2','1',24981.67,25066.45,0.00,0.00,84.78,61719.84,0.00,0.00,0.00),('1','223','1','151',595,'3','1',39982.51,40038.51,0.00,0.00,56.00,38080.00,0.00,0.00,0.00),('1','223','1','151',596,'4','1',36335.31,37195.06,0.00,0.00,859.75,584630.00,0.00,0.00,0.00),('1','223','1','152',597,'1','1',26112.41,26327.09,0.00,0.00,214.68,156287.04,0.00,0.00,0.00),('1','223','1','152',598,'2','1',25066.45,25260.72,0.00,0.00,194.27,141428.56,0.00,0.00,0.00),('1','223','1','152',599,'3','1',40038.51,40702.51,0.00,0.00,664.00,451520.00,0.00,0.00,0.00),('1','223','1','152',600,'4','1',37195.06,37198.29,0.00,0.00,3.23,2196.40,0.00,0.00,0.00),('1','223','1','153',601,'1','1',26327.09,26608.01,0.00,0.00,280.92,204509.76,0.00,0.00,0.00),('1','223','1','153',602,'2','1',25260.72,25512.12,0.00,0.00,251.40,183019.20,0.00,0.00,0.00),('1','223','1','153',603,'3','1',40702.51,41258.51,0.00,0.00,556.00,378080.00,0.00,0.00,0.00),('1','223','1','153',604,'4','1',37198.29,37218.29,0.00,0.00,20.00,13600.00,0.00,0.00,0.00),('1','223','1','154',605,'1','1',26608.01,26829.64,0.00,0.00,221.63,161346.64,0.00,0.00,0.00),('1','223','1','154',606,'2','1',25512.12,25656.24,0.00,0.00,144.12,104919.36,0.00,0.00,0.00),('1','223','1','154',607,'3','1',41258.51,42392.01,0.00,0.00,1133.50,770780.00,0.00,0.00,0.00),('1','223','1','154',608,'4','1',37218.29,38336.81,0.00,0.00,1118.52,760738.56,0.00,0.00,0.00),('1','223','1','155',609,'1','1',26829.64,26829.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','155',610,'2','1',25656.24,25656.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','155',611,'3','1',42392.01,42392.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','155',612,'4','1',38336.81,38336.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','156',613,'1','1',26829.64,26859.11,0.00,0.00,29.47,21454.16,0.00,0.00,0.00),('1','223','1','156',614,'2','1',25656.24,25697.80,0.00,0.00,41.56,30255.68,0.00,0.00,0.00),('1','223','1','156',615,'3','1',42392.01,42898.01,0.00,0.00,506.00,344080.00,0.00,0.00,0.00),('1','223','1','156',616,'4','1',38336.81,38336.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','157',617,'1','1',26859.11,27092.68,0.00,0.00,233.57,170038.96,0.00,0.00,0.00),('1','223','1','157',618,'2','1',25697.80,25859.11,0.00,0.00,161.31,117433.68,0.00,0.00,0.00),('1','223','1','157',619,'3','1',42898.01,42938.01,0.00,0.00,40.00,27200.00,0.00,0.00,0.00),('1','223','1','157',620,'4','1',38336.81,39453.81,0.00,0.00,1117.00,759560.00,0.00,0.00,0.00),('1','223','1','158',621,'1','1',27092.68,27409.76,0.00,0.00,317.08,230834.24,0.00,0.00,0.00),('1','223','1','158',622,'2','1',25859.11,26216.66,0.00,0.00,357.55,260296.40,0.00,0.00,0.00),('1','223','1','158',623,'3','1',42938.01,43088.01,0.00,0.00,150.00,102000.00,0.00,0.00,0.00),('1','223','1','158',624,'4','1',39453.81,40609.81,0.00,0.00,1156.00,786080.00,0.00,0.00,0.00),('1','223','1','159',625,'1','1',27409.76,27614.02,0.00,0.00,204.26,148701.28,0.00,0.00,0.00),('1','223','1','159',626,'2','1',26216.66,26445.38,0.00,0.00,228.72,166508.16,0.00,0.00,0.00),('1','223','1','159',627,'3','1',43088.01,43594.01,0.00,0.00,506.00,344080.00,0.00,0.00,0.00),('1','223','1','159',628,'4','1',40609.81,40738.39,0.00,0.00,128.58,87434.40,0.00,0.00,0.00),('1','223','1','160',629,'1','1',27614.02,27614.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','160',630,'2','1',26445.38,26445.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','160',631,'3','1',43594.01,43594.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','160',632,'4','1',40738.39,40738.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','161',633,'1','1',27614.02,27839.48,0.00,0.00,225.46,164134.88,0.00,0.00,0.00),('1','223','1','161',634,'2','1',26445.38,26801.02,0.00,0.00,355.64,258905.92,0.00,0.00,0.00),('1','223','1','161',635,'3','1',43594.01,44102.01,0.00,0.00,508.00,345440.00,0.00,0.00,0.00),('1','223','1','161',636,'4','1',40738.39,41733.85,0.00,0.00,995.46,676912.80,0.00,0.00,0.00),('1','223','1','162',637,'1','1',27839.48,28022.80,0.00,0.00,183.32,133456.96,0.00,0.00,0.00),('1','223','1','162',638,'2','1',26801.02,27044.36,0.00,0.00,243.34,177151.52,0.00,0.00,0.00),('1','223','1','162',639,'3','1',44102.01,44749.01,0.00,0.00,647.00,439960.00,0.00,0.00,0.00),('1','223','1','162',640,'4','1',41733.85,41746.35,0.00,0.00,12.50,8500.00,0.00,0.00,0.00),('1','223','1','163',641,'1','1',28022.80,28022.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','163',642,'2','1',27044.36,27044.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','163',643,'3','1',44749.01,44749.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','163',644,'4','1',41746.35,41746.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','164',645,'1','1',28022.80,28353.74,0.00,0.00,330.94,240924.32,0.00,0.00,0.00),('1','223','1','164',646,'2','1',27044.36,27347.51,0.00,0.00,303.15,220693.20,0.00,0.00,0.00),('1','223','1','164',647,'3','1',44749.01,45720.01,0.00,0.00,971.00,660280.00,0.00,0.00,0.00),('1','223','1','164',648,'4','1',41746.35,41746.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','165',649,'1','1',28353.74,28426.97,0.00,0.00,73.23,53311.44,0.00,0.00,0.00),('1','223','1','165',650,'2','1',27347.51,27502.78,0.00,0.00,155.27,113036.56,0.00,0.00,0.00),('1','223','1','165',651,'3','1',45720.01,45870.01,0.00,0.00,150.00,102000.00,0.00,0.00,0.00),('1','223','1','165',652,'4','1',41746.35,41748.55,0.00,0.00,2.20,1496.00,0.00,0.00,0.00),('1','223','1','166',653,'1','1',28426.97,28426.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','166',654,'2','1',27502.78,27502.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','166',655,'3','1',45870.01,45870.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','166',656,'4','1',41748.55,41748.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','167',657,'1','1',28426.97,28634.63,0.00,0.00,207.66,151176.48,0.00,0.00,0.00),('1','223','1','167',658,'2','1',27502.78,27749.26,0.00,0.00,246.48,179437.44,0.00,0.00,0.00),('1','223','1','167',659,'3','1',45870.01,47273.51,0.00,0.00,1403.50,954380.00,0.00,0.00,0.00),('1','223','1','167',660,'4','1',41748.55,42232.52,0.00,0.00,483.97,329099.60,0.00,0.00,0.00),('1','223','1','168',661,'1','1',28634.63,28766.05,0.00,0.00,131.42,95673.76,0.00,0.00,0.00),('1','223','1','168',662,'2','1',27749.26,27978.44,0.00,0.00,229.18,166843.04,0.00,0.00,0.00),('1','223','1','168',663,'3','1',47273.51,47729.51,0.00,0.00,456.00,310080.00,0.00,0.00,0.00),('1','223','1','168',664,'4','1',42232.52,42332.52,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','223','1','169',665,'1','1',28766.05,28825.50,0.00,0.00,59.45,43279.60,0.00,0.00,0.00),('1','223','1','169',666,'2','1',27978.44,28053.46,0.00,0.00,75.02,54614.56,0.00,0.00,0.00),('1','223','1','169',667,'3','1',47729.51,48417.51,0.00,0.00,688.00,467840.00,0.00,0.00,0.00),('1','223','1','169',668,'4','1',42332.52,42862.12,0.00,0.00,529.60,360128.00,0.00,0.00,0.00),('1','223','1','170',669,'1','1',28825.50,28825.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','170',670,'2','1',28053.46,28053.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','170',671,'3','1',48417.51,48417.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','170',672,'4','1',42862.12,42862.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','171',673,'1','1',28825.50,28952.91,0.00,0.00,127.41,92754.48,0.00,0.00,0.00),('1','223','1','171',674,'2','1',28053.46,28194.29,0.00,0.00,140.83,102524.24,0.00,0.00,0.00),('1','223','1','171',675,'3','1',48417.51,48740.51,0.00,0.00,323.00,219640.00,0.00,0.00,0.00),('1','223','1','171',676,'4','1',42862.12,42862.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','172',677,'1','1',28952.91,29166.70,0.00,0.00,213.79,155639.12,0.00,0.00,0.00),('1','223','1','172',678,'2','1',28194.29,28431.27,0.00,0.00,236.98,172521.44,0.00,0.00,0.00),('1','223','1','172',679,'3','1',48740.51,50564.95,0.00,0.00,1824.44,1240619.20,0.00,0.00,0.00),('1','223','1','172',680,'4','1',42862.12,42912.12,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','223','1','173',681,'1','1',29166.70,29350.31,0.00,0.00,183.61,133668.08,0.00,0.00,0.00),('1','223','1','173',682,'2','1',28431.27,28688.76,0.00,0.00,257.49,187452.72,0.00,0.00,0.00),('1','223','1','173',683,'3','1',50564.95,51273.95,0.00,0.00,709.00,482120.00,0.00,0.00,0.00),('1','223','1','173',684,'4','1',42912.12,43062.12,0.00,0.00,150.00,102000.00,0.00,0.00,0.00),('1','223','1','174',685,'1','1',29350.31,29530.27,0.00,0.00,179.96,131010.88,0.00,0.00,0.00),('1','223','1','174',686,'2','1',28688.76,28880.78,0.00,0.00,192.02,139790.56,0.00,0.00,0.00),('1','223','1','174',687,'3','1',51273.95,51761.45,0.00,0.00,487.50,331500.00,0.00,0.00,0.00),('1','223','1','174',688,'4','1',43062.12,43062.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','175',689,'1','1',29530.27,29530.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','175',690,'2','1',28880.78,28880.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','175',691,'3','1',51761.45,51761.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','175',692,'4','1',43062.12,43062.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','176',693,'1','1',29530.27,29576.95,0.00,0.00,46.68,33983.04,0.00,0.00,0.00),('1','223','1','176',694,'2','1',28880.78,28903.03,0.00,0.00,22.25,16198.00,0.00,0.00,0.00),('1','223','1','176',695,'3','1',51761.45,51761.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','176',696,'4','1',43062.12,43062.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','177',697,'1','1',29576.95,29864.34,0.00,0.00,287.39,209219.92,0.00,0.00,0.00),('1','223','1','177',698,'2','1',28903.03,29143.42,0.00,0.00,240.39,175003.92,0.00,0.00,0.00),('1','223','1','177',699,'3','1',51761.45,52069.45,0.00,0.00,308.00,209440.00,0.00,0.00,0.00),('1','223','1','177',700,'4','1',43062.12,44268.62,0.00,0.00,1206.50,820420.00,0.00,0.00,0.00),('1','223','1','178',701,'1','1',29864.34,30082.97,0.00,0.00,218.63,159162.64,0.00,0.00,0.00),('1','223','1','178',702,'2','1',29143.42,29335.59,0.00,0.00,192.17,139899.76,0.00,0.00,0.00),('1','223','1','178',703,'3','1',52069.45,53642.45,0.00,0.00,1573.00,1069640.00,0.00,0.00,0.00),('1','223','1','178',704,'4','1',44268.62,44491.62,0.00,0.00,223.00,151640.00,0.00,0.00,0.00),('1','223','1','179',705,'1','1',30082.97,30322.27,0.00,0.00,239.30,174210.40,0.00,0.00,0.00),('1','223','1','179',706,'2','1',29335.59,29540.78,0.00,0.00,205.19,149378.32,0.00,0.00,0.00),('1','223','1','179',707,'3','1',53642.45,54098.45,0.00,0.00,456.00,310080.00,0.00,0.00,0.00),('1','223','1','179',708,'4','1',44491.62,44501.62,0.00,0.00,10.00,6800.00,0.00,0.00,0.00),('1','223','1','180',709,'1','1',30322.27,30507.75,0.00,0.00,185.48,135029.44,0.00,0.00,0.00),('1','223','1','180',710,'2','1',29540.78,29683.41,0.00,0.00,142.63,103834.64,0.00,0.00,0.00),('1','223','1','180',711,'3','1',54098.45,54206.45,0.00,0.00,108.00,73440.00,0.00,0.00,0.00),('1','223','1','180',712,'4','1',44501.62,44726.62,0.00,0.00,225.00,153000.00,0.00,0.00,0.00),('1','223','1','181',713,'1','1',30507.75,30524.42,0.00,0.00,16.67,12135.76,0.00,0.00,0.00),('1','223','1','181',714,'2','1',29683.41,29704.53,0.00,0.00,21.12,15375.36,0.00,0.00,0.00),('1','223','1','181',715,'3','1',54206.45,54326.66,0.00,0.00,120.21,81742.80,0.00,0.00,0.00),('1','223','1','181',716,'4','1',44726.62,45132.62,0.00,0.00,406.00,276080.00,0.00,0.00,0.00),('1','223','1','182',717,'1','1',30524.42,30524.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','182',718,'2','1',29704.53,29704.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','182',719,'3','1',54326.66,54326.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','182',720,'4','1',45132.62,45132.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','183',721,'1','1',30524.42,30716.92,0.00,0.00,192.50,140140.00,0.00,0.00,0.00),('1','223','1','183',722,'2','1',29704.53,29958.85,0.00,0.00,254.32,185144.96,0.00,0.00,0.00),('1','223','1','183',723,'3','1',54326.66,55612.66,0.00,0.00,1286.00,874480.00,0.00,0.00,0.00),('1','223','1','183',724,'4','1',45132.62,46815.12,0.00,0.00,1682.50,1144100.00,0.00,0.00,0.00),('1','223','1','184',725,'1','1',30716.92,30937.70,0.00,0.00,220.78,160727.84,0.00,0.00,0.00),('1','223','1','184',726,'2','1',29958.85,30178.64,0.00,0.00,219.79,160007.12,0.00,0.00,0.00),('1','223','1','184',727,'3','1',55612.66,56124.66,0.00,0.00,512.00,348160.00,0.00,0.00,0.00),('1','223','1','184',728,'4','1',46815.12,46818.12,0.00,0.00,3.00,2040.00,0.00,0.00,0.00),('1','223','1','185',729,'1','1',30937.70,31123.82,0.00,0.00,186.12,135495.36,0.00,0.00,0.00),('1','223','1','185',730,'2','1',30178.64,30382.41,0.00,0.00,203.77,148344.56,0.00,0.00,0.00),('1','223','1','185',731,'3','1',56124.66,56386.66,0.00,0.00,262.00,178160.00,0.00,0.00,0.00),('1','223','1','185',732,'4','1',46818.12,47274.12,0.00,0.00,456.00,310080.00,0.00,0.00,0.00),('1','223','1','186',733,'1','1',31123.82,31286.87,0.00,0.00,163.05,118700.40,0.00,0.00,0.00),('1','223','1','186',734,'2','1',30382.41,30584.54,0.00,0.00,202.13,147150.64,0.00,0.00,0.00),('1','223','1','186',735,'3','1',56386.66,57100.66,0.00,0.00,714.00,485520.00,0.00,0.00,0.00),('1','223','1','186',736,'4','1',47274.12,47374.12,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','223','1','187',737,'1','1',31286.87,31521.27,0.00,0.00,234.40,170643.20,0.00,0.00,0.00),('1','223','1','187',738,'2','1',30584.54,30840.25,0.00,0.00,255.71,186156.88,0.00,0.00,0.00),('1','223','1','187',739,'3','1',57100.66,57100.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','187',740,'4','1',47374.12,47374.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','188',741,'1','1',31521.27,31780.30,0.00,0.00,259.03,188573.84,0.00,0.00,0.00),('1','223','1','188',742,'2','1',30840.25,31107.74,0.00,0.00,267.49,192332.72,0.00,0.00,0.00),('1','223','1','188',743,'3','1',57100.66,57508.66,0.00,0.00,408.00,277440.00,0.00,0.00,0.00),('1','223','1','188',744,'4','1',47374.12,49001.62,0.00,0.00,1627.50,1106700.00,0.00,0.00,0.00),('1','223','1','189',745,'1','1',31780.30,31989.20,0.00,0.00,208.90,152079.20,0.00,0.00,0.00),('1','223','1','189',746,'2','1',31107.74,31306.55,0.00,0.00,198.81,144733.68,0.00,0.00,0.00),('1','223','1','189',747,'3','1',57508.66,57777.68,0.00,0.00,269.02,183078.56,0.00,0.00,0.00),('1','223','1','189',748,'4','1',49001.62,49001.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','190',749,'1','1',31989.20,32277.69,0.00,0.00,288.49,210020.72,0.00,0.00,0.00),('1','223','1','190',750,'2','1',31306.55,31560.98,0.00,0.00,254.43,185225.04,0.00,0.00,0.00),('1','223','1','190',751,'3','1',57777.68,57835.68,0.00,0.00,58.00,39440.00,0.00,0.00,0.00),('1','223','1','190',752,'4','1',49001.62,49304.62,0.00,0.00,303.00,206040.00,0.00,0.00,0.00),('1','223','1','191',753,'1','1',32277.69,32414.44,0.00,0.00,136.75,99554.00,0.00,0.00,0.00),('1','223','1','191',754,'2','1',31560.98,31686.24,0.00,0.00,125.26,91189.28,0.00,0.00,0.00),('1','223','1','191',755,'3','1',57835.68,58085.68,0.00,0.00,250.00,170000.00,0.00,0.00,0.00),('1','223','1','191',756,'4','1',49304.62,49885.62,0.00,0.00,581.00,395080.00,0.00,0.00,0.00),('1','223','1','192',757,'1','1',32414.44,32414.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','192',758,'2','1',31686.24,31686.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','192',759,'3','1',58085.68,58085.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','192',760,'4','1',49885.62,49885.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','193',761,'1','1',32414.44,32654.70,0.00,0.00,240.26,174909.28,0.00,0.00,0.00),('1','223','1','193',762,'2','1',31686.24,32022.79,0.00,0.00,336.55,245008.40,0.00,0.00,0.00),('1','223','1','193',763,'3','1',58085.68,59566.18,0.00,0.00,1480.50,1006740.00,0.00,0.00,0.00),('1','223','1','193',764,'4','1',49885.62,49946.56,0.00,0.00,60.94,41439.20,0.00,0.00,0.00),('1','223','1','194',765,'1','1',32654.70,32840.19,0.00,0.00,185.49,135036.72,0.00,0.00,0.00),('1','223','1','194',766,'2','1',32022.79,32276.15,0.00,0.00,253.36,184446.08,0.00,0.00,0.00),('1','223','1','194',767,'3','1',59566.18,59838.68,0.00,0.00,272.50,185300.00,0.00,0.00,0.00),('1','223','1','194',768,'4','1',49946.56,50554.06,0.00,0.00,607.50,413100.00,0.00,0.00,0.00),('1','223','1','195',769,'1','1',32840.19,32992.77,0.00,0.00,152.58,111078.24,0.00,0.00,0.00),('1','223','1','195',770,'2','1',32276.15,32479.85,0.00,0.00,203.70,148293.60,0.00,0.00,0.00),('1','223','1','195',771,'3','1',59838.68,59888.68,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','223','1','195',772,'4','1',50554.06,50554.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','196',773,'1','1',32992.77,33358.67,0.00,0.00,365.90,266375.20,0.00,0.00,0.00),('1','223','1','196',774,'2','1',32479.85,32749.36,0.00,0.00,269.51,196203.28,0.00,0.00,0.00),('1','223','1','196',775,'3','1',59888.68,60845.15,0.00,0.00,956.47,650399.60,0.00,0.00,0.00),('1','223','1','196',776,'4','1',50554.06,51844.56,0.00,0.00,1290.50,877540.00,0.00,0.00,0.00),('1','223','1','197',777,'1','1',33358.67,33612.83,0.00,0.00,254.16,185028.48,0.00,0.00,0.00),('1','223','1','197',778,'2','1',32749.36,33053.21,0.00,0.00,303.85,221202.80,0.00,0.00,0.00),('1','223','1','197',779,'3','1',60845.15,60945.15,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','223','1','197',780,'4','1',51844.56,51850.56,0.00,0.00,6.00,4080.00,0.00,0.00,0.00),('1','223','1','198',781,'1','1',33612.83,33968.48,0.00,0.00,355.65,258913.20,0.00,0.00,0.00),('1','223','1','198',782,'2','1',33053.21,33423.21,0.00,0.00,370.00,269360.00,0.00,0.00,0.00),('1','223','1','198',783,'3','1',60945.15,61286.15,0.00,0.00,341.00,231880.00,0.00,0.00,0.00),('1','223','1','198',784,'4','1',51850.56,51850.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','199',785,'1','1',33968.48,34239.98,0.00,0.00,271.50,197652.00,0.00,0.00,0.00),('1','223','1','199',786,'2','1',33423.21,33730.09,0.00,0.00,306.88,223408.64,0.00,0.00,0.00),('1','223','1','199',787,'3','1',61286.15,61944.15,0.00,0.00,658.00,447440.00,0.00,0.00,0.00),('1','223','1','199',788,'4','1',51850.56,52269.06,0.00,0.00,418.50,284580.00,0.00,0.00,0.00),('1','223','1','200',789,'1','1',34239.98,34489.33,0.00,0.00,249.35,181526.80,0.00,0.00,0.00),('1','223','1','200',790,'2','1',33730.09,34054.00,0.00,0.00,323.91,235806.48,0.00,0.00,0.00),('1','223','1','200',791,'3','1',61944.15,62425.97,0.00,0.00,481.82,327637.60,0.00,0.00,0.00),('1','223','1','200',792,'4','1',52269.06,52900.06,0.00,0.00,631.00,429080.00,0.00,0.00,0.00),('1','223','1','201',793,'1','1',34489.33,34550.56,0.00,0.00,61.23,44575.44,0.00,0.00,0.00),('1','223','1','201',794,'2','1',34054.00,34088.93,0.00,0.00,34.93,25429.04,0.00,0.00,0.00),('1','223','1','201',795,'3','1',62425.97,62593.97,0.00,0.00,168.00,114240.00,0.00,0.00,0.00),('1','223','1','201',796,'4','1',52900.06,53306.06,0.00,0.00,406.00,276080.00,0.00,0.00,0.00),('1','223','1','202',797,'1','1',34550.56,34550.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','202',798,'2','1',34088.93,34088.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','202',799,'3','1',62593.97,62593.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','202',800,'4','1',53306.06,53306.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','203',801,'1','1',34550.56,34778.93,0.00,0.00,228.37,166253.36,0.00,0.00,0.00),('1','223','1','203',802,'2','1',34088.93,34317.45,0.00,0.00,228.52,166362.56,0.00,0.00,0.00),('1','223','1','203',803,'3','1',62593.97,63967.97,0.00,0.00,1374.00,934320.00,0.00,0.00,0.00),('1','223','1','203',804,'4','1',53306.06,53556.06,0.00,0.00,250.00,170000.00,0.00,0.00,0.00),('1','223','1','204',805,'1','1',34778.93,34978.90,0.00,0.00,199.97,145578.16,0.00,0.00,0.00),('1','223','1','204',806,'2','1',34317.45,34512.90,0.00,0.00,195.45,142287.60,0.00,0.00,0.00),('1','223','1','204',807,'3','1',63967.97,64217.97,0.00,0.00,250.00,170000.00,0.00,0.00,0.00),('1','223','1','204',808,'4','1',53556.06,54194.06,0.00,0.00,638.00,433840.00,0.00,0.00,0.00),('1','223','1','205',809,'1','1',34978.90,35168.55,0.00,0.00,189.65,138065.20,0.00,0.00,0.00),('1','223','1','205',810,'2','1',34512.90,34762.84,0.00,0.00,249.94,181956.32,0.00,0.00,0.00),('1','223','1','205',811,'3','1',64217.97,65323.97,0.00,0.00,1106.00,752080.00,0.00,0.00,0.00),('1','223','1','205',812,'4','1',54194.06,54302.06,0.00,0.00,108.00,73440.00,0.00,0.00,0.00),('1','223','1','206',813,'1','1',35168.55,35366.58,0.00,0.00,198.03,144165.84,0.00,0.00,0.00),('1','223','1','206',814,'2','1',34762.84,35041.64,0.00,0.00,278.80,202966.40,0.00,0.00,0.00),('1','223','1','206',815,'3','1',65323.97,65846.97,0.00,0.00,523.00,355640.00,0.00,0.00,0.00),('1','223','1','206',816,'4','1',54302.06,54861.06,0.00,0.00,559.00,380120.00,0.00,0.00,0.00),('1','223','1','207',817,'1','1',35366.58,35476.99,0.00,0.00,110.41,80378.48,0.00,0.00,0.00),('1','223','1','207',818,'2','1',35041.64,35295.07,0.00,0.00,253.43,184497.04,0.00,0.00,0.00),('1','223','1','207',819,'3','1',65846.97,66346.97,0.00,0.00,500.00,340000.00,0.00,0.00,0.00),('1','223','1','207',820,'4','1',54861.06,55311.06,0.00,0.00,450.00,306000.00,0.00,0.00,0.00),('1','223','1','208',821,'1','1',35476.99,35739.44,0.00,0.00,262.45,191063.60,0.00,0.00,0.00),('1','223','1','208',822,'2','1',35295.07,35506.31,0.00,0.00,211.24,153782.72,0.00,0.00,0.00),('1','223','1','208',823,'3','1',66346.97,66784.47,0.00,0.00,437.50,297500.00,0.00,0.00,0.00),('1','223','1','208',824,'4','1',55311.06,56115.06,0.00,0.00,804.00,546720.00,0.00,0.00,0.00),('1','223','1','209',825,'1','1',35739.44,35818.25,0.00,0.00,78.81,57373.68,0.00,0.00,0.00),('1','223','1','209',826,'2','1',35506.31,35622.53,0.00,0.00,116.22,84608.16,0.00,0.00,0.00),('1','223','1','209',827,'3','1',66784.47,67843.47,0.00,0.00,1059.00,720120.00,0.00,0.00,0.00),('1','223','1','209',828,'4','1',56115.06,57330.56,0.00,0.00,1215.50,826540.00,0.00,0.00,0.00),('1','223','1','210',829,'1','1',35818.25,35818.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','210',830,'2','1',35622.53,35622.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','210',831,'3','1',67843.47,67843.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','210',832,'4','1',57330.56,57330.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','211',833,'1','1',35818.25,36077.44,0.00,0.00,259.19,188690.32,0.00,0.00,0.00),('1','223','1','211',834,'2','1',35622.53,35804.35,0.00,0.00,181.82,132364.96,0.00,0.00,0.00),('1','223','1','211',835,'3','1',67843.47,68560.47,0.00,0.00,717.00,487560.00,0.00,0.00,0.00),('1','223','1','211',836,'4','1',57330.56,57622.06,0.00,0.00,291.50,198220.00,0.00,0.00,0.00),('1','223','1','212',837,'1','1',36077.44,36370.17,0.00,0.00,292.73,213107.44,0.00,0.00,0.00),('1','223','1','212',838,'2','1',35804.35,35923.91,0.00,0.00,119.56,87039.68,0.00,0.00,0.00),('1','223','1','212',839,'3','1',68560.47,69150.47,0.00,0.00,590.00,401200.00,0.00,0.00,0.00),('1','223','1','212',840,'4','1',57622.06,57747.06,0.00,0.00,125.00,85000.00,0.00,0.00,0.00),('1','223','1','213',841,'1','1',36370.17,36442.61,0.00,0.00,72.44,52736.32,0.00,0.00,0.00),('1','223','1','213',842,'2','1',35923.91,35955.76,0.00,0.00,31.85,23186.80,0.00,0.00,0.00),('1','223','1','213',843,'3','1',69150.47,69788.47,0.00,0.00,638.00,433840.00,0.00,0.00,0.00),('1','223','1','213',844,'4','1',57747.06,57847.06,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','223','1','214',845,'1','1',36442.61,36442.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','214',846,'2','1',35955.76,35955.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','214',847,'3','1',69788.47,69788.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','214',848,'4','1',57847.06,57847.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','215',849,'1','1',36442.61,36511.22,0.00,0.00,68.61,49948.08,0.00,0.00,0.00),('1','223','1','215',850,'2','1',35955.76,35995.48,0.00,0.00,39.72,28916.16,0.00,0.00,0.00),('1','223','1','215',851,'3','1',69788.47,71050.76,0.00,0.00,1262.29,858357.20,0.00,0.00,0.00),('1','223','1','215',852,'4','1',57847.06,58253.06,0.00,0.00,406.00,276080.00,0.00,0.00,0.00),('1','223','1','216',853,'1','1',36511.22,36802.14,0.00,0.00,290.92,211789.76,0.00,0.00,0.00),('1','223','1','216',854,'2','1',35995.48,36175.65,0.00,0.00,180.17,131163.76,0.00,0.00,0.00),('1','223','1','216',855,'3','1',71050.76,71456.76,0.00,0.00,406.00,276080.00,0.00,0.00,0.00),('1','223','1','216',856,'4','1',58253.06,58751.06,0.00,0.00,498.00,338640.00,0.00,0.00,0.00),('1','223','1','217',857,'1','1',36802.14,37060.77,0.00,0.00,258.63,188282.64,0.00,0.00,0.00),('1','223','1','217',858,'2','1',36175.65,36429.35,0.00,0.00,253.70,184693.60,0.00,0.00,0.00),('1','223','1','217',859,'3','1',71456.76,71706.76,0.00,0.00,250.00,170000.00,0.00,0.00,0.00),('1','223','1','217',860,'4','1',58751.06,59051.06,0.00,0.00,300.00,204000.00,0.00,0.00,0.00),('1','223','1','218',861,'1','1',37060.77,37332.24,0.00,0.00,271.47,197630.16,0.00,0.00,0.00),('1','223','1','218',862,'2','1',36429.35,36688.93,0.00,0.00,259.58,188974.24,0.00,0.00,0.00),('1','223','1','218',863,'3','1',71706.76,72022.76,0.00,0.00,316.00,214880.00,0.00,0.00,0.00),('1','223','1','218',864,'4','1',59051.06,59506.36,0.00,0.00,455.30,309604.00,0.00,0.00,0.00),('1','223','1','219',865,'1','1',37332.24,37332.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','219',866,'2','1',36688.93,36688.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','219',867,'3','1',72022.76,72022.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','219',868,'4','1',59506.36,59506.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','220',869,'1','1',37332.24,37549.71,0.00,0.00,217.47,167451.90,0.00,0.00,0.00),('1','223','1','220',870,'2','1',36688.93,36851.18,0.00,0.00,162.25,124932.50,0.00,0.00,0.00),('1','223','1','220',871,'3','1',72022.76,73398.26,0.00,0.00,1375.50,990360.00,0.00,0.00,0.00),('1','223','1','220',872,'4','1',59506.36,59506.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','221',873,'1','1',37549.71,37829.40,0.00,0.00,279.69,215361.30,0.00,0.00,0.00),('1','223','1','221',874,'2','1',36851.18,37013.10,0.00,0.00,161.92,124678.40,0.00,0.00,0.00),('1','223','1','221',875,'3','1',73398.26,73944.87,0.00,0.00,546.61,393559.20,0.00,0.00,0.00),('1','223','1','221',876,'4','1',59506.36,59606.36,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','223','1','222',877,'1','1',37829.40,38016.24,0.00,0.00,186.84,143866.80,0.00,0.00,0.00),('1','223','1','222',878,'2','1',37013.10,37192.80,0.00,0.00,179.70,138369.00,0.00,0.00,0.00),('1','223','1','222',879,'3','1',73944.87,73944.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','222',880,'4','1',59606.36,59756.36,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','223','1','223',881,'1','1',38016.24,38358.67,0.00,0.00,342.43,260912.60,0.00,0.00,0.00),('1','223','1','223',882,'2','1',37192.80,37417.27,0.00,0.00,224.47,171118.20,0.00,0.00,0.00),('1','223','1','223',883,'3','1',73944.87,74057.37,0.00,0.00,112.50,79875.00,0.00,0.00,0.00),('1','223','1','223',884,'4','1',59756.36,59756.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','224',885,'1','1',38358.67,38628.20,0.00,0.00,269.53,204842.80,0.00,0.00,0.00),('1','223','1','224',886,'2','1',37417.27,37629.20,0.00,0.00,211.93,161066.80,0.00,0.00,0.00),('1','223','1','224',887,'3','1',74057.37,74057.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','224',888,'4','1',59756.36,59756.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','225',889,'1','1',38628.20,38736.28,0.00,0.00,108.08,79640.80,0.00,0.00,0.00),('1','223','1','225',890,'2','1',37629.20,37693.92,0.00,0.00,64.72,49187.20,0.00,0.00,0.00),('1','223','1','225',891,'3','1',74057.37,74207.37,0.00,0.00,150.00,106500.00,0.00,0.00,0.00),('1','223','1','225',892,'4','1',59756.36,59943.86,0.00,0.00,187.50,133125.00,0.00,0.00,0.00),('1','223','1','226',893,'1','1',38736.28,38736.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','226',894,'2','1',37693.92,37693.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','226',895,'3','1',74207.37,74207.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','226',896,'4','1',59943.86,59943.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','227',897,'1','1',38736.28,38969.73,0.00,0.00,233.45,177422.00,0.00,0.00,0.00),('1','223','1','227',898,'2','1',37693.92,37987.10,0.00,0.00,293.18,222816.80,0.00,0.00,0.00),('1','223','1','227',899,'3','1',74207.37,74260.37,0.00,0.00,53.00,37630.00,0.00,0.00,0.00),('1','223','1','227',900,'4','1',59943.86,60018.86,0.00,0.00,75.00,53250.00,0.00,0.00,0.00),('1','223','1','228',901,'1','1',38969.73,39215.78,0.00,0.00,246.05,186998.00,0.00,0.00,0.00),('1','223','1','228',902,'2','1',37987.10,38208.13,0.00,0.00,221.03,167982.80,0.00,0.00,0.00),('1','223','1','228',903,'3','1',74260.37,74260.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','228',904,'4','1',60018.86,60018.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','229',905,'1','1',39215.78,39682.76,0.00,0.00,466.98,354904.80,0.00,0.00,0.00),('1','223','1','229',906,'2','1',38208.13,38526.97,0.00,0.00,318.84,226540.90,0.00,0.00,0.00),('1','223','1','229',907,'3','1',74260.37,74260.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','229',908,'4','1',60018.86,60018.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','230',909,'1','1',39682.76,40104.90,0.00,0.00,422.14,320826.40,0.00,0.00,0.00),('1','223','1','230',910,'2','1',38526.97,38734.97,0.00,0.00,208.00,147680.00,0.00,0.00,0.00),('1','223','1','230',911,'3','1',74260.37,74260.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','230',912,'4','1',60018.86,60018.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','231',913,'1','1',40104.90,40473.96,0.00,0.00,369.06,280485.60,0.00,0.00,0.00),('1','223','1','231',914,'2','1',38734.97,38734.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','231',915,'3','1',74260.37,74260.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','231',916,'4','1',60018.86,60018.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','232',917,'1','1',40473.96,40886.96,0.00,0.00,413.00,313880.00,0.00,0.00,0.00),('1','223','1','232',918,'2','1',38734.97,39340.97,0.00,0.00,606.00,430260.00,0.00,0.00,0.00),('1','223','1','232',919,'3','1',74260.37,74260.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','232',920,'4','1',60018.86,60018.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','233',921,'1','1',40886.96,41336.56,0.00,0.00,449.60,341696.00,0.00,0.00,0.00),('1','223','1','233',922,'2','1',39340.97,39340.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','233',923,'3','1',74260.37,74260.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','233',924,'4','1',60018.86,60018.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','234',925,'1','1',41336.56,41763.37,0.00,0.00,426.81,324375.60,0.00,0.00,0.00),('1','223','1','234',926,'2','1',39340.97,39636.53,0.00,0.00,295.56,210750.60,0.00,0.00,0.00),('1','223','1','234',927,'3','1',74260.37,74310.37,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','223','1','234',928,'4','1',60018.86,60018.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','235',929,'1','1',41763.37,42205.88,0.00,0.00,442.51,336307.60,0.00,0.00,0.00),('1','223','1','235',930,'2','1',39636.53,39936.53,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','223','1','235',931,'3','1',74310.37,74310.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','235',932,'4','1',60018.86,60018.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','236',933,'1','1',42205.88,42427.92,0.00,0.00,222.04,168750.40,0.00,0.00,0.00),('1','223','1','236',934,'2','1',39936.53,40135.10,0.00,0.00,198.57,150913.20,0.00,0.00,0.00),('1','223','1','236',935,'3','1',74310.37,74360.37,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','223','1','236',936,'4','1',60018.86,60018.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','237',937,'1','1',42427.92,42661.18,0.00,0.00,233.26,177277.60,0.00,0.00,0.00),('1','223','1','237',938,'2','1',40135.10,40384.13,0.00,0.00,249.03,189262.80,0.00,0.00,0.00),('1','223','1','237',939,'3','1',74360.37,74497.87,0.00,0.00,137.50,97625.00,0.00,0.00,0.00),('1','223','1','237',940,'4','1',60018.86,60021.86,0.00,0.00,3.00,2130.00,0.00,0.00,0.00),('1','223','1','238',941,'1','1',42661.18,42864.01,0.00,0.00,202.83,154150.80,0.00,0.00,0.00),('1','223','1','238',942,'2','1',40384.13,40596.87,0.00,0.00,212.74,161682.40,0.00,0.00,0.00),('1','223','1','238',943,'3','1',74497.87,75098.87,0.00,0.00,601.00,426710.00,0.00,0.00,0.00),('1','223','1','238',944,'4','1',60021.86,60071.86,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','223','1','239',945,'1','1',42864.01,43025.03,0.00,0.00,161.02,119154.80,0.00,0.00,0.00),('1','223','1','239',946,'2','1',40596.87,40802.94,0.00,0.00,206.07,152491.80,0.00,0.00,0.00),('1','223','1','239',947,'3','1',75098.87,75418.16,0.00,0.00,319.29,223503.00,0.00,0.00,0.00),('1','223','1','239',948,'4','1',60071.86,60171.86,0.00,0.00,100.00,70000.00,0.00,0.00,0.00),('1','223','1','240',949,'1','1',43025.03,43237.87,0.00,0.00,212.84,157501.60,0.00,0.00,0.00),('1','223','1','240',950,'2','1',40802.94,40992.70,0.00,0.00,189.76,140422.40,0.00,0.00,0.00),('1','223','1','240',951,'3','1',75418.16,75518.16,0.00,0.00,100.00,70000.00,0.00,0.00,0.00),('1','223','1','240',952,'4','1',60171.86,60627.86,0.00,0.00,456.00,319200.00,0.00,0.00,0.00),('1','223','1','241',953,'1','1',43237.87,43422.87,0.00,0.00,185.00,136900.00,0.00,0.00,0.00),('1','223','1','241',954,'2','1',40992.70,41225.93,0.00,0.00,233.23,172590.20,0.00,0.00,0.00),('1','223','1','241',955,'3','1',75518.16,75924.16,0.00,0.00,406.00,284200.00,0.00,0.00,0.00),('1','223','1','241',956,'4','1',60627.86,61052.86,0.00,0.00,425.00,297500.00,0.00,0.00,0.00),('1','223','1','242',957,'1','1',43422.87,43597.50,0.00,0.00,174.63,129226.20,0.00,0.00,0.00),('1','223','1','242',958,'2','1',41225.93,41461.36,0.00,0.00,235.43,174218.20,0.00,0.00,0.00),('1','223','1','242',959,'3','1',75924.16,75924.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','242',960,'4','1',61052.86,61152.86,0.00,0.00,100.00,70000.00,0.00,0.00,0.00),('1','223','1','243',961,'1','1',43597.50,43597.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','243',962,'2','1',41461.36,41461.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','243',963,'3','1',75924.16,75924.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','243',964,'4','1',61152.86,61152.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','244',965,'1','1',43597.50,43745.67,0.00,0.00,148.17,109645.80,0.00,0.00,0.00),('1','223','1','244',966,'2','1',41461.36,41583.27,0.00,0.00,121.91,90213.40,0.00,0.00,0.00),('1','223','1','244',967,'3','1',75924.16,76061.66,0.00,0.00,137.50,96250.00,0.00,0.00,0.00),('1','223','1','244',968,'4','1',61152.86,61327.86,0.00,0.00,175.00,122500.00,0.00,0.00,0.00),('1','223','1','245',969,'1','1',43745.67,44013.05,0.00,0.00,267.38,197861.20,0.00,0.00,0.00),('1','223','1','245',970,'2','1',41583.27,41765.65,0.00,0.00,182.38,134961.20,0.00,0.00,0.00),('1','223','1','245',971,'3','1',76061.66,76211.66,0.00,0.00,150.00,105000.00,0.00,0.00,0.00),('1','223','1','245',972,'4','1',61327.86,61527.86,0.00,0.00,200.00,140000.00,0.00,0.00,0.00),('1','223','1','246',973,'1','1',44013.05,44201.08,0.00,0.00,188.03,139142.20,0.00,0.00,0.00),('1','223','1','246',974,'2','1',41765.65,41939.74,0.00,0.00,174.09,128826.60,0.00,0.00,0.00),('1','223','1','246',975,'3','1',76211.66,76561.66,0.00,0.00,350.00,245000.00,0.00,0.00,0.00),('1','223','1','246',976,'4','1',61527.86,61742.86,0.00,0.00,215.00,150500.00,0.00,0.00,0.00),('1','223','1','247',977,'1','1',44201.08,44480.32,0.00,0.00,279.24,206637.60,0.00,0.00,0.00),('1','223','1','247',978,'2','1',41939.74,42102.13,0.00,0.00,162.39,120168.60,0.00,0.00,0.00),('1','223','1','247',979,'3','1',76561.66,76874.16,0.00,0.00,312.50,218750.00,0.00,0.00,0.00),('1','223','1','247',980,'4','1',61742.86,62208.86,0.00,0.00,466.00,326200.00,0.00,0.00,0.00),('1','223','1','248',981,'1','1',44480.32,44663.84,0.00,0.00,183.52,135804.80,0.00,0.00,0.00),('1','223','1','248',982,'2','1',42102.13,42199.24,0.00,0.00,97.11,71861.40,0.00,0.00,0.00),('1','223','1','248',983,'3','1',76874.16,76940.16,0.00,0.00,66.00,46200.00,0.00,0.00,0.00),('1','223','1','248',984,'4','1',62208.86,62614.86,0.00,0.00,406.00,284200.00,0.00,0.00,0.00),('1','223','1','249',985,'1','1',44663.84,44891.99,0.00,0.00,228.15,168831.00,0.00,0.00,0.00),('1','223','1','249',986,'2','1',42199.24,42378.14,0.00,0.00,178.90,132386.00,0.00,0.00,0.00),('1','223','1','249',987,'3','1',76940.16,77327.66,0.00,0.00,387.50,271250.00,0.00,0.00,0.00),('1','223','1','249',988,'4','1',62614.86,62714.86,0.00,0.00,100.00,70000.00,0.00,0.00,0.00),('1','223','1','250',989,'1','1',44891.99,44891.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','250',990,'2','1',42378.14,42378.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','250',991,'3','1',77327.66,77327.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','250',992,'4','1',62714.86,62714.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','251',993,'1','1',44891.99,45220.81,0.00,0.00,328.82,243326.80,0.00,0.00,0.00),('1','223','1','251',994,'2','1',42378.14,42671.33,0.00,0.00,293.19,216960.60,0.00,0.00,0.00),('1','223','1','251',995,'3','1',77327.66,77357.66,0.00,0.00,30.00,21000.00,0.00,0.00,0.00),('1','223','1','251',996,'4','1',62714.86,62925.86,0.00,0.00,211.00,147700.00,0.00,0.00,0.00),('1','223','1','252',997,'1','1',45220.81,45471.65,0.00,0.00,250.84,185621.60,0.00,0.00,0.00),('1','223','1','252',998,'2','1',42671.33,42864.09,0.00,0.00,192.76,142642.40,0.00,0.00,0.00),('1','223','1','252',999,'3','1',77357.66,77663.66,0.00,0.00,306.00,214200.00,0.00,0.00,0.00),('1','223','1','252',1000,'4','1',62925.86,62975.86,0.00,0.00,50.00,35000.00,0.00,0.00,0.00),('1','223','1','253',1001,'1','1',45471.65,45724.51,0.00,0.00,252.86,187116.40,0.00,0.00,0.00),('1','223','1','253',1002,'2','1',42864.09,43142.90,0.00,0.00,278.81,206319.40,0.00,0.00,0.00),('1','223','1','253',1003,'3','1',77663.66,78257.16,0.00,0.00,593.50,415450.00,0.00,0.00,0.00),('1','223','1','253',1004,'4','1',62975.86,63025.86,0.00,0.00,50.00,35000.00,0.00,0.00,0.00),('1','223','1','254',1005,'1','1',45724.51,46011.69,0.00,0.00,287.18,212513.20,0.00,0.00,0.00),('1','223','1','254',1006,'2','1',43142.90,43465.91,0.00,0.00,323.01,239027.40,0.00,0.00,0.00),('1','223','1','254',1007,'3','1',78257.16,78319.66,0.00,0.00,62.50,43125.00,0.00,0.00,0.00),('1','223','1','254',1008,'4','1',63025.86,63581.86,0.00,0.00,556.00,383640.00,0.00,0.00,0.00),('1','223','1','255',1009,'1','1',46011.69,46263.62,0.00,0.00,251.93,186428.20,0.00,0.00,0.00),('1','223','1','255',1010,'2','1',43465.91,43702.88,0.00,0.00,236.97,175357.80,0.00,0.00,0.00),('1','223','1','255',1011,'3','1',78319.66,78824.01,0.00,0.00,504.35,348001.50,0.00,0.00,0.00),('1','223','1','255',1012,'4','1',63581.86,63694.36,0.00,0.00,112.50,77625.00,0.00,0.00,0.00),('1','223','1','256',1013,'1','1',46263.62,46486.21,0.00,0.00,222.59,164716.60,0.00,0.00,0.00),('1','223','1','256',1014,'2','1',43702.88,43945.22,0.00,0.00,242.34,179331.60,0.00,0.00,0.00),('1','223','1','256',1015,'3','1',78824.01,79461.36,0.00,0.00,637.35,439939.00,0.00,0.00,0.00),('1','223','1','256',1016,'4','1',63694.36,63911.36,0.00,0.00,217.00,149730.00,0.00,0.00,0.00),('1','223','1','257',1017,'1','1',46486.21,46691.16,0.00,0.00,204.95,151663.00,0.00,0.00,0.00),('1','223','1','257',1018,'2','1',43945.22,44253.04,0.00,0.00,307.82,227786.80,0.00,0.00,0.00),('1','223','1','257',1019,'3','1',79461.36,80185.94,0.00,0.00,724.58,500264.20,0.00,0.00,0.00),('1','223','1','257',1020,'4','1',63911.36,64001.36,0.00,0.00,90.00,62100.00,0.00,0.00,0.00),('1','223','1','258',1021,'1','1',46691.16,46962.77,0.00,0.00,271.61,200991.40,0.00,0.00,0.00),('1','223','1','258',1022,'2','1',44253.04,44590.71,0.00,0.00,337.67,247375.80,0.00,0.00,0.00),('1','223','1','258',1023,'3','1',80185.94,80350.94,0.00,0.00,165.00,113850.00,0.00,0.00,0.00),('1','223','1','258',1024,'4','1',64001.36,64151.36,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','223','1','259',1025,'1','1',46962.77,47253.57,0.00,0.00,290.80,215192.00,0.00,0.00,0.00),('1','223','1','259',1026,'2','1',44590.71,44843.07,0.00,0.00,252.36,186746.40,0.00,0.00,0.00),('1','223','1','259',1027,'3','1',80350.94,80859.91,0.00,0.00,508.97,351337.80,0.00,0.00,0.00),('1','223','1','259',1028,'4','1',64151.36,64151.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','260',1029,'1','1',47253.57,47410.91,0.00,0.00,157.34,116431.60,0.00,0.00,0.00),('1','223','1','260',1030,'2','1',44843.07,45148.17,0.00,0.00,305.10,225774.00,0.00,0.00,0.00),('1','223','1','260',1031,'3','1',80859.91,81096.91,0.00,0.00,237.00,163530.00,0.00,0.00,0.00),('1','223','1','260',1032,'4','1',64151.36,64301.36,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','223','1','261',1033,'1','1',47410.91,47622.67,0.00,0.00,211.76,156702.40,0.00,0.00,0.00),('1','223','1','261',1034,'2','1',45148.17,45321.18,0.00,0.00,173.01,128027.40,0.00,0.00,0.00),('1','223','1','261',1035,'3','1',81096.91,81154.91,0.00,0.00,58.00,40020.00,0.00,0.00,0.00),('1','223','1','261',1036,'4','1',64301.36,64301.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','262',1037,'1','1',47622.67,47661.20,0.00,0.00,38.53,28512.20,0.00,0.00,0.00),('1','223','1','262',1038,'2','1',45321.18,45386.98,0.00,0.00,65.80,48692.00,0.00,0.00,0.00),('1','223','1','262',1039,'3','1',81154.91,81154.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','262',1040,'4','1',64301.36,64707.36,0.00,0.00,406.00,280140.00,0.00,0.00,0.00),('1','223','1','263',1041,'1','1',47661.20,47661.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','263',1042,'2','1',45386.98,45386.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','263',1043,'3','1',81154.91,81154.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','263',1044,'4','1',64707.36,64707.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','264',1045,'1','1',47661.20,47773.64,0.00,0.00,112.44,83205.60,0.00,0.00,0.00),('1','223','1','264',1046,'2','1',45386.98,45568.90,0.00,0.00,181.92,134620.80,0.00,0.00,0.00),('1','223','1','264',1047,'3','1',81154.91,81279.91,0.00,0.00,125.00,86250.00,0.00,0.00,0.00),('1','223','1','264',1048,'4','1',64707.36,65010.36,0.00,0.00,303.00,209070.00,0.00,0.00,0.00),('1','223','1','265',1049,'1','1',47773.64,47987.65,0.00,0.00,214.01,155799.28,0.00,0.00,0.00),('1','223','1','265',1050,'2','1',45568.90,45780.70,0.00,0.00,211.80,154190.40,0.00,0.00,0.00),('1','223','1','265',1051,'3','1',81279.91,81286.91,0.00,0.00,7.00,5096.00,0.00,0.00,0.00),('1','223','1','265',1052,'4','1',65010.36,65010.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','266',1053,'1','1',47987.65,48287.31,0.00,0.00,299.66,218152.48,0.00,0.00,0.00),('1','223','1','266',1054,'2','1',45780.70,46044.08,0.00,0.00,263.38,191740.64,0.00,0.00,0.00),('1','223','1','266',1055,'3','1',81286.91,81805.41,0.00,0.00,518.50,352580.00,0.00,0.00,0.00),('1','223','1','266',1056,'4','1',65010.36,65225.36,0.00,0.00,215.00,146200.00,0.00,0.00,0.00),('1','223','1','267',1057,'1','1',48287.31,48515.15,0.00,0.00,227.84,165867.52,0.00,0.00,0.00),('1','223','1','267',1058,'2','1',46044.08,46240.91,0.00,0.00,196.83,143292.24,0.00,0.00,0.00),('1','223','1','267',1059,'3','1',81805.41,81856.51,0.00,0.00,51.10,34800.80,0.00,0.00,0.00),('1','223','1','267',1060,'4','1',65225.36,65675.36,0.00,0.00,450.00,306000.00,0.00,0.00,0.00),('1','223','1','268',1061,'1','1',48515.15,48739.49,0.00,0.00,224.34,163319.52,0.00,0.00,0.00),('1','223','1','268',1062,'2','1',46240.91,46469.20,0.00,0.00,228.29,166195.12,0.00,0.00,0.00),('1','223','1','268',1063,'3','1',81856.51,82320.51,0.00,0.00,464.00,315520.00,0.00,0.00,0.00),('1','223','1','268',1064,'4','1',65675.36,66400.36,0.00,0.00,725.00,493000.00,0.00,0.00,0.00),('1','223','1','269',1065,'1','1',48739.49,48901.30,0.00,0.00,161.81,117797.68,0.00,0.00,0.00),('1','223','1','269',1066,'2','1',46469.20,46786.65,0.00,0.00,317.45,231103.60,0.00,0.00,0.00),('1','223','1','269',1067,'3','1',82320.51,82566.55,0.00,0.00,246.04,167597.12,0.00,0.00,0.00),('1','223','1','269',1068,'4','1',66400.36,66553.36,0.00,0.00,153.00,104040.00,0.00,0.00,0.00),('1','223','1','270',1069,'1','1',48901.30,49130.36,0.00,0.00,229.06,164355.68,0.00,0.00,0.00),('1','223','1','270',1070,'2','1',46786.65,47013.23,0.00,0.00,226.58,164950.24,0.00,0.00,0.00),('1','223','1','270',1071,'3','1',82566.55,82666.55,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','223','1','270',1072,'4','1',66553.36,66959.36,0.00,0.00,406.00,276080.00,0.00,0.00,0.00),('1','223','1','271',1073,'1','1',49130.36,49287.41,0.00,0.00,157.05,114332.40,0.00,0.00,0.00),('1','223','1','271',1074,'2','1',47013.23,47225.03,0.00,0.00,211.80,154190.40,0.00,0.00,0.00),('1','223','1','271',1075,'3','1',82666.55,82925.55,0.00,0.00,259.00,176120.00,0.00,0.00,0.00),('1','223','1','271',1076,'4','1',66959.36,67009.36,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','223','1','272',1077,'1','1',49287.41,49508.49,0.00,0.00,221.08,160946.24,0.00,0.00,0.00),('1','223','1','272',1078,'2','1',47225.03,47406.75,0.00,0.00,181.72,132292.16,0.00,0.00,0.00),('1','223','1','272',1079,'3','1',82925.55,83069.59,0.00,0.00,144.04,97947.20,0.00,0.00,0.00),('1','223','1','272',1080,'4','1',67009.36,67009.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','273',1081,'1','1',49508.49,49765.64,0.00,0.00,257.15,187205.20,0.00,0.00,0.00),('1','223','1','273',1082,'2','1',47406.75,47727.00,0.00,0.00,320.25,233142.00,0.00,0.00,0.00),('1','223','1','273',1083,'3','1',83069.59,83634.59,0.00,0.00,565.00,384200.00,0.00,0.00,0.00),('1','223','1','273',1084,'4','1',67009.36,67415.36,0.00,0.00,406.00,276080.00,0.00,0.00,0.00),('1','223','1','274',1085,'1','1',49765.64,50013.18,0.00,0.00,247.54,180209.12,0.00,0.00,0.00),('1','223','1','274',1086,'2','1',47727.00,47983.37,0.00,0.00,256.37,186637.36,0.00,0.00,0.00),('1','223','1','274',1087,'3','1',83634.59,83887.59,0.00,0.00,253.00,172040.00,0.00,0.00,0.00),('1','223','1','274',1088,'4','1',67415.36,68038.36,0.00,0.00,623.00,423640.00,0.00,0.00,0.00),('1','223','1','275',1089,'1','1',50013.18,50248.27,0.00,0.00,235.09,171145.52,0.00,0.00,0.00),('1','223','1','275',1090,'2','1',47983.37,48271.66,0.00,0.00,288.29,209875.12,0.00,0.00,0.00),('1','223','1','275',1091,'3','1',83887.59,84062.59,0.00,0.00,175.00,119000.00,0.00,0.00,0.00),('1','223','1','275',1092,'4','1',68038.36,68088.36,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','223','1','276',1093,'1','1',50248.27,50276.43,0.00,0.00,28.16,20500.48,0.00,0.00,0.00),('1','223','1','276',1094,'2','1',48271.66,48285.61,0.00,0.00,13.95,10155.60,0.00,0.00,0.00),('1','223','1','276',1095,'3','1',84062.59,84450.84,0.00,0.00,388.25,264010.00,0.00,0.00,0.00),('1','223','1','276',1096,'4','1',68088.36,68088.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','277',1097,'1','1',50276.43,50276.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','277',1098,'2','1',48285.61,48285.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','277',1099,'3','1',84450.84,84450.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','277',1100,'4','1',68088.36,68088.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','278',1101,'1','1',50276.43,50542.09,0.00,0.00,265.66,193400.48,0.00,0.00,0.00),('1','223','1','278',1102,'2','1',48285.61,48314.29,0.00,0.00,28.68,20879.04,0.00,0.00,0.00),('1','223','1','278',1103,'3','1',84450.84,84450.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','278',1104,'4','1',68088.36,68088.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','279',1105,'1','1',50542.09,50692.69,0.00,0.00,150.60,109636.80,0.00,0.00,0.00),('1','223','1','279',1106,'2','1',48314.29,48404.26,0.00,0.00,89.97,65498.16,0.00,0.00,0.00),('1','223','1','279',1107,'3','1',84450.84,84750.84,0.00,0.00,300.00,204000.00,0.00,0.00,0.00),('1','223','1','279',1108,'4','1',68088.36,68088.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','280',1109,'1','1',50692.69,50821.09,0.00,0.00,128.40,93475.20,0.00,0.00,0.00),('1','223','1','280',1110,'2','1',48404.26,48467.00,0.00,0.00,62.74,45530.72,0.00,0.00,0.00),('1','223','1','280',1111,'3','1',84750.84,84840.94,0.00,0.00,90.10,65592.80,0.00,0.00,0.00),('1','223','1','280',1112,'4','1',68088.36,68842.37,0.00,0.00,754.01,512919.28,0.00,0.00,0.00),('1','223','1','281',1113,'1','1',50821.09,50835.53,0.00,0.00,14.44,10512.32,0.00,0.00,0.00),('1','223','1','281',1114,'2','1',48467.00,48486.14,0.00,0.00,19.14,13933.92,0.00,0.00,0.00),('1','223','1','281',1115,'3','1',84840.94,85261.57,0.00,0.00,420.63,306218.64,0.00,0.00,0.00),('1','223','1','281',1116,'4','1',68842.37,69207.37,0.00,0.00,365.00,248200.00,0.00,0.00,0.00),('1','223','1','282',1117,'1','1',50835.53,50840.34,0.00,0.00,4.81,3501.68,0.00,0.00,0.00),('1','223','1','282',1118,'2','1',48486.14,48637.14,0.00,0.00,151.00,109928.00,0.00,0.00,0.00),('1','223','1','282',1119,'3','1',85261.57,86578.00,0.00,0.00,1316.43,938873.04,0.00,0.00,0.00),('1','223','1','282',1120,'4','1',69207.37,69650.87,0.00,0.00,443.50,301580.00,0.00,0.00,0.00),('1','223','1','283',1121,'1','1',50840.34,50840.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','283',1122,'2','1',48637.14,48727.07,0.00,0.00,89.93,65469.04,0.00,0.00,0.00),('1','223','1','283',1123,'3','1',86578.00,86941.30,0.00,0.00,363.30,264482.40,0.00,0.00,0.00),('1','223','1','283',1124,'4','1',69650.87,69800.87,0.00,0.00,150.00,102000.00,0.00,0.00,0.00),('1','223','1','284',1125,'1','1',50840.34,50842.26,0.00,0.00,1.92,1397.76,0.00,0.00,0.00),('1','223','1','284',1126,'2','1',48727.07,48744.73,0.00,0.00,17.66,12856.48,0.00,0.00,0.00),('1','223','1','284',1127,'3','1',86941.30,87208.75,0.00,0.00,267.45,194703.60,0.00,0.00,0.00),('1','223','1','284',1128,'4','1',69800.87,70911.37,0.00,0.00,1110.50,755140.00,0.00,0.00,0.00),('1','223','1','285',1129,'1','1',50842.26,50842.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','285',1130,'2','1',48744.73,48765.71,0.00,0.00,20.98,15273.44,0.00,0.00,0.00),('1','223','1','285',1131,'3','1',87208.75,87668.36,0.00,0.00,459.61,334596.08,0.00,0.00,0.00),('1','223','1','285',1132,'4','1',70911.37,71567.37,0.00,0.00,656.00,446080.00,0.00,0.00,0.00),('1','223','1','286',1133,'1','1',50842.26,50842.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','286',1134,'2','1',48765.71,48786.90,0.00,0.00,21.19,15426.32,0.00,0.00,0.00),('1','223','1','286',1135,'3','1',87668.36,87980.26,0.00,0.00,311.90,227063.20,0.00,0.00,0.00),('1','223','1','286',1136,'4','1',71567.37,71754.87,0.00,0.00,187.50,127500.00,0.00,0.00,0.00),('1','223','1','287',1137,'1','1',50842.26,50842.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','287',1138,'2','1',48786.90,48799.39,0.00,0.00,12.49,9092.72,0.00,0.00,0.00),('1','223','1','287',1139,'3','1',87980.26,88333.97,0.00,0.00,353.71,257500.88,0.00,0.00,0.00),('1','223','1','287',1140,'4','1',71754.87,72398.91,0.00,0.00,644.04,438237.12,0.00,0.00,0.00),('1','223','1','288',1141,'1','1',50842.26,50845.38,0.00,0.00,3.12,2271.36,0.00,0.00,0.00),('1','223','1','288',1142,'2','1',48799.39,48802.41,0.00,0.00,3.02,2198.56,0.00,0.00,0.00),('1','223','1','288',1143,'3','1',88333.97,88569.67,0.00,0.00,235.70,171589.60,0.00,0.00,0.00),('1','223','1','288',1144,'4','1',72398.91,73315.91,0.00,0.00,917.00,623560.00,0.00,0.00,0.00),('1','223','1','289',1145,'1','1',50845.38,50845.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','289',1146,'2','1',48802.41,48802.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','289',1147,'3','1',88569.67,88569.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','289',1148,'4','1',73315.91,73315.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','290',1149,'1','1',50845.38,50845.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','290',1150,'2','1',48802.41,48802.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','290',1151,'3','1',88569.67,88970.00,0.00,0.00,400.33,289936.65,0.00,0.00,0.00),('1','223','1','290',1152,'4','1',73315.91,73580.91,0.00,0.00,265.00,180200.00,0.00,0.00,0.00),('1','223','1','291',1153,'1','1',50845.38,50845.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','291',1154,'2','1',48802.41,48814.43,0.00,0.00,12.02,8702.48,0.00,0.00,0.00),('1','223','1','291',1155,'3','1',88970.00,89626.85,0.00,0.00,656.85,468959.40,0.00,0.00,0.00),('1','223','1','291',1156,'4','1',73580.91,74219.45,0.00,0.00,638.54,434340.96,0.00,0.00,0.00),('1','223','1','292',1157,'1','1',50845.38,50845.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','292',1158,'2','1',48814.43,48819.43,0.00,0.00,5.00,3620.00,0.00,0.00,0.00),('1','223','1','292',1159,'3','1',89626.85,90251.01,0.00,0.00,624.16,451891.84,0.00,0.00,0.00),('1','223','1','292',1160,'4','1',74219.45,74654.95,0.00,0.00,435.50,296140.00,0.00,0.00,0.00),('1','223','1','293',1161,'1','1',50845.38,50845.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','293',1162,'2','1',48819.43,48830.90,0.00,0.00,11.47,8304.28,0.00,0.00,0.00),('1','223','1','293',1163,'3','1',90251.01,91000.27,0.00,0.00,749.26,542464.24,0.00,0.00,0.00),('1','223','1','293',1164,'4','1',74654.95,74912.95,0.00,0.00,258.00,175440.00,0.00,0.00,0.00),('1','223','1','294',1165,'1','1',50845.38,50845.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','294',1166,'2','1',48830.90,48851.34,0.00,0.00,20.44,14798.56,0.00,0.00,0.00),('1','223','1','294',1167,'3','1',91000.27,91674.28,0.00,0.00,674.01,487983.24,0.00,0.00,0.00),('1','223','1','294',1168,'4','1',74912.95,75325.45,0.00,0.00,412.50,280500.00,0.00,0.00,0.00),('1','223','1','295',1169,'1','1',50845.38,50849.43,0.00,0.00,4.05,2932.20,0.00,0.00,0.00),('1','223','1','295',1170,'2','1',48851.34,48898.27,0.00,0.00,46.93,33977.32,0.00,0.00,0.00),('1','223','1','295',1171,'3','1',91674.28,92361.80,0.00,0.00,687.52,497764.48,0.00,0.00,0.00),('1','223','1','295',1172,'4','1',75325.45,76232.90,0.00,0.00,907.45,617066.00,0.00,0.00,0.00),('1','223','1','296',1173,'1','1',50849.43,50849.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','296',1174,'2','1',48898.27,48935.26,0.00,0.00,36.99,26780.76,0.00,0.00,0.00),('1','223','1','296',1175,'3','1',92361.80,93040.16,0.00,0.00,678.36,491132.64,0.00,0.00,0.00),('1','223','1','296',1176,'4','1',76232.90,76645.90,0.00,0.00,413.00,280840.00,0.00,0.00,0.00),('1','223','1','297',1177,'1','1',50849.43,50849.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','297',1178,'2','1',48935.26,48980.72,0.00,0.00,45.46,32913.04,0.00,0.00,0.00),('1','223','1','297',1179,'3','1',93040.16,93634.19,0.00,0.00,594.03,430077.72,0.00,0.00,0.00),('1','223','1','297',1180,'4','1',76645.90,77327.08,0.00,0.00,681.18,463430.32,0.00,0.00,0.00),('1','223','1','298',1181,'1','1',50849.43,50849.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','298',1182,'2','1',48980.72,48992.80,0.00,0.00,12.08,8745.92,0.00,0.00,0.00),('1','223','1','298',1183,'3','1',93634.19,94285.08,0.00,0.00,650.89,466404.36,0.00,0.00,0.00),('1','223','1','298',1184,'4','1',77327.08,77604.08,0.00,0.00,277.00,188360.00,0.00,0.00,0.00),('1','223','1','299',1185,'1','1',50849.43,50849.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','299',1186,'2','1',48992.80,49000.60,0.00,0.00,7.80,5647.20,0.00,0.00,0.00),('1','223','1','299',1187,'3','1',94285.08,95004.65,0.00,0.00,719.57,520968.68,0.00,0.00,0.00),('1','223','1','299',1188,'4','1',77604.08,77804.08,0.00,0.00,200.00,136000.00,0.00,0.00,0.00),('1','223','1','300',1189,'1','1',50849.43,50849.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','300',1190,'2','1',49000.60,49016.87,0.00,0.00,16.27,11779.48,0.00,0.00,0.00),('1','223','1','300',1191,'3','1',95004.65,95680.57,0.00,0.00,675.92,482766.08,0.00,0.00,0.00),('1','223','1','300',1192,'4','1',77804.08,77804.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','301',1193,'1','1',50849.43,50849.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','301',1194,'2','1',49016.87,49016.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','301',1195,'3','1',95680.57,95680.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','301',1196,'4','1',77804.08,77804.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','302',1197,'1','1',50849.43,50849.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','302',1198,'2','1',49016.87,49022.73,0.00,0.00,5.86,4102.00,0.00,0.00,0.00),('1','223','1','302',1199,'3','1',95680.57,96505.89,0.00,0.00,825.32,574724.00,0.00,0.00,0.00),('1','223','1','302',1200,'4','1',77804.08,78220.08,0.00,0.00,416.00,278870.00,0.00,0.00,0.00),('1','223','1','303',1201,'1','1',50849.43,50849.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','303',1202,'2','1',49022.73,49025.80,0.00,0.00,3.07,2149.00,0.00,0.00,0.00),('1','223','1','303',1203,'3','1',96505.89,97176.18,0.00,0.00,670.29,467703.00,0.00,0.00,0.00),('1','223','1','303',1204,'4','1',78220.08,79218.08,0.00,0.00,998.00,668660.00,0.00,0.00,0.00),('1','223','1','304',1205,'1','1',50849.43,50853.43,0.00,0.00,4.00,2800.00,0.00,0.00,0.00),('1','223','1','304',1206,'2','1',49025.80,49029.80,0.00,0.00,4.00,2800.00,0.00,0.00,0.00),('1','223','1','304',1207,'3','1',97176.18,97860.87,0.00,0.00,684.69,475623.00,0.00,0.00,0.00),('1','223','1','304',1208,'4','1',79218.08,80083.08,0.00,0.00,865.00,579550.00,0.00,0.00,0.00),('1','223','1','305',1209,'1','1',50853.43,50853.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','305',1210,'2','1',49029.80,49031.80,0.00,0.00,2.00,1400.00,0.00,0.00,0.00),('1','223','1','305',1211,'3','1',97860.87,98365.35,0.00,0.00,504.48,353136.00,0.00,0.00,0.00),('1','223','1','305',1212,'4','1',80083.08,80685.45,0.00,0.00,602.37,403767.90,0.00,0.00,0.00),('1','223','1','306',1213,'1','1',50853.43,50853.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','306',1214,'2','1',49031.80,49043.51,0.00,0.00,11.71,8197.00,0.00,0.00,0.00),('1','223','1','306',1215,'3','1',98365.35,98954.21,0.00,0.00,588.86,412202.00,0.00,0.00,0.00),('1','223','1','306',1216,'4','1',80685.45,80953.45,0.00,0.00,268.00,179800.00,0.00,0.00,0.00),('1','223','1','307',1217,'1','1',50853.43,50853.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','307',1218,'2','1',49043.51,49048.65,0.00,0.00,5.14,3598.00,0.00,0.00,0.00),('1','223','1','307',1219,'3','1',98954.21,99511.56,0.00,0.00,557.35,390145.00,0.00,0.00,0.00),('1','223','1','307',1220,'4','1',80953.45,81654.88,0.00,0.00,701.43,470001.00,0.00,0.00,0.00),('1','223','1','308',1221,'1','1',50853.43,50853.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','308',1222,'2','1',49048.65,49062.65,0.00,0.00,14.00,9800.00,0.00,0.00,0.00),('1','223','1','308',1223,'3','1',99511.56,100014.36,0.00,0.00,502.80,351960.00,0.00,0.00,0.00),('1','223','1','308',1224,'4','1',81654.88,81943.67,0.00,0.00,288.79,193588.00,0.00,0.00,0.00),('1','223','1','309',1225,'1','1',50853.43,50853.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','309',1226,'2','1',49062.65,49105.94,0.00,0.00,43.29,30303.00,0.00,0.00,0.00),('1','223','1','309',1227,'3','1',100014.36,100620.06,0.00,0.00,605.70,423990.00,0.00,0.00,0.00),('1','223','1','309',1228,'4','1',81943.67,82823.81,0.00,0.00,880.14,589848.00,0.00,0.00,0.00),('1','223','1','310',1229,'1','1',50853.43,50853.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','310',1230,'2','1',49105.94,49109.94,0.00,0.00,4.00,2800.00,0.00,0.00,0.00),('1','223','1','310',1231,'3','1',100620.06,101167.00,0.00,0.00,546.94,379348.00,0.00,0.00,0.00),('1','223','1','310',1232,'4','1',82823.81,83364.49,0.00,0.00,540.68,362255.60,0.00,0.00,0.00),('1','223','1','311',1233,'1','1',50853.43,50853.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','311',1234,'2','1',49109.94,49109.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','311',1235,'3','1',101167.00,101383.00,0.00,0.00,216.00,151200.00,0.00,0.00,0.00),('1','223','1','311',1236,'4','1',83364.49,83871.63,0.00,0.00,507.14,339848.00,0.00,0.00,0.00),('1','223','1','312',1237,'1','1',50853.43,50855.43,0.00,0.00,2.00,1400.00,0.00,0.00,0.00),('1','223','1','312',1238,'2','1',49109.94,49112.80,0.00,0.00,2.86,2002.00,0.00,0.00,0.00),('1','223','1','312',1239,'3','1',101383.00,101792.67,0.00,0.00,409.67,286769.00,0.00,0.00,0.00),('1','223','1','312',1240,'4','1',83871.63,83957.31,0.00,0.00,85.68,57534.30,0.00,0.00,0.00),('1','223','1','313',1241,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','313',1242,'2','1',49112.80,49112.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','313',1243,'3','1',101792.67,101792.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','313',1244,'4','1',83957.31,83957.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','314',1245,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','314',1246,'2','1',49112.80,49127.80,0.00,0.00,15.00,10500.00,0.00,0.00,0.00),('1','223','1','314',1247,'3','1',101792.67,102345.04,0.00,0.00,552.37,386659.00,0.00,0.00,0.00),('1','223','1','314',1248,'4','1',83957.31,84330.31,0.00,0.00,373.00,249940.00,0.00,0.00,0.00),('1','223','1','315',1249,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','315',1250,'2','1',49127.80,49134.87,0.00,0.00,7.07,4949.00,0.00,0.00,0.00),('1','223','1','315',1251,'3','1',102345.04,102979.73,0.00,0.00,634.69,442783.00,0.00,0.00,0.00),('1','223','1','315',1252,'4','1',84330.31,84837.31,0.00,0.00,507.00,339690.00,0.00,0.00,0.00),('1','223','1','316',1253,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','316',1254,'2','1',49134.87,49137.72,0.00,0.00,2.85,1995.00,0.00,0.00,0.00),('1','223','1','316',1255,'3','1',102979.73,103625.33,0.00,0.00,645.60,451920.00,0.00,0.00,0.00),('1','223','1','316',1256,'4','1',84837.31,85448.31,0.00,0.00,611.00,409370.00,0.00,0.00,0.00),('1','223','1','317',1257,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','317',1258,'2','1',49137.72,49141.86,0.00,0.00,4.14,2898.00,0.00,0.00,0.00),('1','223','1','317',1259,'3','1',103625.33,104156.62,0.00,0.00,531.29,371903.00,0.00,0.00,0.00),('1','223','1','317',1260,'4','1',85448.31,86567.51,0.00,0.00,1119.20,749864.00,0.00,0.00,0.00),('1','223','1','318',1261,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','318',1262,'2','1',49141.86,49141.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','318',1263,'3','1',104156.62,104156.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','318',1264,'4','1',86567.51,86567.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','319',1265,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','319',1266,'2','1',49141.86,49141.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','319',1267,'3','1',104156.62,104848.49,0.00,0.00,691.87,479809.00,0.00,0.00,0.00),('1','223','1','319',1268,'4','1',86567.51,86793.51,0.00,0.00,226.00,151420.00,0.00,0.00,0.00),('1','223','1','320',1269,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','320',1270,'2','1',49141.86,49146.86,0.00,0.00,5.00,3500.00,0.00,0.00,0.00),('1','223','1','320',1271,'3','1',104848.49,105361.10,0.00,0.00,512.61,358827.00,0.00,0.00,0.00),('1','223','1','320',1272,'4','1',86793.51,86866.56,0.00,0.00,73.05,48943.50,0.00,0.00,0.00),('1','223','1','321',1273,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','321',1274,'2','1',49146.86,49146.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','321',1275,'3','1',105361.10,105859.96,0.00,0.00,498.86,349202.00,0.00,0.00,0.00),('1','223','1','321',1276,'4','1',86866.56,87197.06,0.00,0.00,330.50,221435.00,0.00,0.00,0.00),('1','223','1','322',1277,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','322',1278,'2','1',49146.86,49147.72,0.00,0.00,0.86,602.00,0.00,0.00,0.00),('1','223','1','322',1279,'3','1',105859.96,106710.86,0.00,0.00,850.90,591130.00,0.00,0.00,0.00),('1','223','1','322',1280,'4','1',87197.06,87736.64,0.00,0.00,539.58,361518.60,0.00,0.00,0.00),('1','223','1','323',1281,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','323',1282,'2','1',49147.72,49149.72,0.00,0.00,2.00,1400.00,0.00,0.00,0.00),('1','223','1','323',1283,'3','1',106710.86,107387.64,0.00,0.00,676.78,466546.00,0.00,0.00,0.00),('1','223','1','323',1284,'4','1',87736.64,88509.64,0.00,0.00,773.00,517910.00,0.00,0.00,0.00),('1','223','1','324',1285,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','324',1286,'2','1',49149.72,49149.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','324',1287,'3','1',107387.64,107387.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','324',1288,'4','1',88509.64,88509.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','325',1289,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','325',1290,'2','1',49149.72,49149.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','325',1291,'3','1',107387.64,107599.46,0.00,0.00,211.82,148274.00,0.00,0.00,0.00),('1','223','1','325',1292,'4','1',88509.64,88794.14,0.00,0.00,284.50,190615.00,0.00,0.00,0.00),('1','223','1','326',1293,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','326',1294,'2','1',49149.72,49149.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','326',1295,'3','1',107599.46,108640.14,0.00,0.00,1040.68,728476.00,0.00,0.00,0.00),('1','223','1','326',1296,'4','1',88794.14,89440.14,0.00,0.00,646.00,432820.00,0.00,0.00,0.00),('1','223','1','327',1297,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','327',1298,'2','1',49149.72,49149.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','327',1299,'3','1',108640.14,109591.76,0.00,0.00,951.62,664874.00,0.00,0.00,0.00),('1','223','1','327',1300,'4','1',89440.14,89729.50,0.00,0.00,289.36,193999.90,0.00,0.00,0.00),('1','223','1','328',1301,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','328',1302,'2','1',49149.72,49154.72,0.00,0.00,5.00,3500.00,0.00,0.00,0.00),('1','223','1','328',1303,'3','1',109591.76,110151.11,0.00,0.00,559.35,391545.00,0.00,0.00,0.00),('1','223','1','328',1304,'4','1',89729.50,89937.50,0.00,0.00,208.00,139360.00,0.00,0.00,0.00),('1','223','1','329',1305,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','329',1306,'2','1',49154.72,49163.72,0.00,0.00,9.00,6300.00,0.00,0.00,0.00),('1','223','1','329',1307,'3','1',110151.11,110792.87,0.00,0.00,641.76,449232.00,0.00,0.00,0.00),('1','223','1','329',1308,'4','1',89937.50,90711.30,0.00,0.00,773.80,518596.00,0.00,0.00,0.00),('1','223','1','330',1309,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','330',1310,'2','1',49163.72,49179.22,0.00,0.00,15.50,10850.00,0.00,0.00,0.00),('1','223','1','330',1311,'3','1',110792.87,111264.57,0.00,0.00,471.70,330190.00,0.00,0.00,0.00),('1','223','1','330',1312,'4','1',90711.30,91293.80,0.00,0.00,582.50,390275.00,0.00,0.00,0.00),('1','223','1','331',1313,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','331',1314,'2','1',49179.22,49187.22,0.00,0.00,8.00,5600.00,0.00,0.00,0.00),('1','223','1','331',1315,'3','1',111264.57,111969.16,0.00,0.00,704.59,490213.00,0.00,0.00,0.00),('1','223','1','331',1316,'4','1',91293.80,92163.74,0.00,0.00,869.94,582859.80,0.00,0.00,0.00),('1','223','1','332',1317,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','332',1318,'2','1',49187.22,49199.72,0.00,0.00,12.50,8750.00,0.00,0.00,0.00),('1','223','1','332',1319,'3','1',111969.16,112735.66,0.00,0.00,766.50,533430.00,0.00,0.00,0.00),('1','223','1','332',1320,'4','1',92163.74,92339.24,0.00,0.00,175.50,117585.00,0.00,0.00,0.00),('1','223','1','333',1321,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','333',1322,'2','1',49199.72,49204.29,0.00,0.00,4.57,3199.00,0.00,0.00,0.00),('1','223','1','333',1323,'3','1',112735.66,113387.50,0.00,0.00,651.84,456288.00,0.00,0.00,0.00),('1','223','1','333',1324,'4','1',92339.24,92699.24,0.00,0.00,360.00,241200.00,0.00,0.00,0.00),('1','223','1','334',1325,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','334',1326,'2','1',49204.29,49218.15,0.00,0.00,13.86,9702.00,0.00,0.00,0.00),('1','223','1','334',1327,'3','1',113387.50,114031.49,0.00,0.00,643.99,450793.00,0.00,0.00,0.00),('1','223','1','334',1328,'4','1',92699.24,92985.10,0.00,0.00,285.86,191732.00,0.00,0.00,0.00),('1','223','1','335',1329,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','335',1330,'2','1',49218.15,49237.15,0.00,0.00,19.00,13300.00,0.00,0.00,0.00),('1','223','1','335',1331,'3','1',114031.49,114504.44,0.00,0.00,472.95,331065.00,0.00,0.00,0.00),('1','223','1','335',1332,'4','1',92985.10,93251.10,0.00,0.00,266.00,178460.00,0.00,0.00,0.00),('1','223','1','336',1333,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','336',1334,'2','1',49237.15,49240.15,0.00,0.00,3.00,2100.00,0.00,0.00,0.00),('1','223','1','336',1335,'3','1',114504.44,114716.08,0.00,0.00,211.64,148148.00,0.00,0.00,0.00),('1','223','1','336',1336,'4','1',93251.10,93351.10,0.00,0.00,100.00,67000.00,0.00,0.00,0.00),('1','223','1','337',1337,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','337',1338,'2','1',49240.15,49240.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','337',1339,'3','1',114716.08,114716.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','337',1340,'4','1',93351.10,93351.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','338',1341,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','338',1342,'2','1',49240.15,49259.44,0.00,0.00,19.29,13503.00,0.00,0.00,0.00),('1','223','1','338',1343,'3','1',114716.08,115348.38,0.00,0.00,632.30,442610.00,0.00,0.00,0.00),('1','223','1','338',1344,'4','1',93351.10,93803.60,0.00,0.00,452.50,301600.00,0.00,0.00,0.00),('1','223','1','339',1345,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','339',1346,'2','1',49259.44,49273.44,0.00,0.00,14.00,9800.00,0.00,0.00,0.00),('1','223','1','339',1347,'3','1',115348.38,116047.27,0.00,0.00,698.89,489223.00,0.00,0.00,0.00),('1','223','1','339',1348,'4','1',93803.60,94323.60,0.00,0.00,520.00,346290.00,0.00,0.00,0.00),('1','223','1','340',1349,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','340',1350,'2','1',49273.44,49283.30,0.00,0.00,9.86,6902.00,0.00,0.00,0.00),('1','223','1','340',1351,'3','1',116047.27,116650.95,0.00,0.00,603.68,422576.00,0.00,0.00,0.00),('1','223','1','340',1352,'4','1',94323.60,94994.10,0.00,0.00,670.50,445882.50,0.00,0.00,0.00),('1','223','1','341',1353,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','341',1354,'2','1',49283.30,49302.51,0.00,0.00,19.21,13447.00,0.00,0.00,0.00),('1','223','1','341',1355,'3','1',116650.95,117327.80,0.00,0.00,676.85,473795.00,0.00,0.00,0.00),('1','223','1','341',1356,'4','1',94994.10,95153.10,0.00,0.00,159.00,106050.00,0.00,0.00,0.00),('1','223','1','342',1357,'1','1',50855.43,50855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','342',1358,'2','1',49302.51,49322.37,0.00,0.00,19.86,13902.00,0.00,0.00,0.00),('1','223','1','342',1359,'3','1',117327.80,117947.54,0.00,0.00,619.74,433818.00,0.00,0.00,0.00),('1','223','1','342',1360,'4','1',95153.10,95899.66,0.00,0.00,746.56,496562.50,0.00,0.00,0.00),('1','223','1','343',1361,'1','1',50855.43,50856.43,0.00,0.00,1.00,700.00,0.00,0.00,0.00),('1','223','1','343',1362,'2','1',49322.37,49337.94,0.00,0.00,15.57,10899.00,0.00,0.00,0.00),('1','223','1','343',1363,'3','1',117947.54,118413.21,0.00,0.00,465.67,325969.00,0.00,0.00,0.00),('1','223','1','343',1364,'4','1',95899.66,95999.66,0.00,0.00,100.00,66500.00,0.00,0.00,0.00),('1','223','1','344',1365,'1','1',50856.43,50856.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','344',1366,'2','1',49337.94,49352.80,0.00,0.00,14.86,10402.00,0.00,0.00,0.00),('1','223','1','344',1367,'3','1',118413.21,118936.91,0.00,0.00,523.70,366590.00,0.00,0.00,0.00),('1','223','1','344',1368,'4','1',95999.66,96202.66,0.00,0.00,203.00,135100.00,0.00,0.00,0.00),('1','223','1','345',1369,'1','1',50856.43,50856.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','345',1370,'2','1',49352.80,49409.51,0.00,0.00,56.71,39697.00,0.00,0.00,0.00),('1','223','1','345',1371,'3','1',118936.91,119471.82,0.00,0.00,534.91,374437.00,0.00,0.00,0.00),('1','223','1','345',1372,'4','1',96202.66,98175.26,0.00,0.00,1972.60,1311849.00,0.00,0.00,0.00),('1','223','1','346',1373,'1','1',50856.43,50856.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','346',1374,'2','1',49409.51,49442.73,0.00,0.00,33.22,23254.00,0.00,0.00,0.00),('1','223','1','346',1375,'3','1',119471.82,120035.84,0.00,0.00,564.02,393064.00,0.00,0.00,0.00),('1','223','1','346',1376,'4','1',98175.26,99017.76,0.00,0.00,842.50,560472.50,0.00,0.00,0.00),('1','223','1','347',1377,'1','1',50856.43,50857.43,0.00,0.00,1.00,700.00,0.00,0.00,0.00),('1','223','1','347',1378,'2','1',49442.73,49525.37,0.00,0.00,82.64,57848.00,0.00,0.00,0.00),('1','223','1','347',1379,'3','1',120035.84,120447.58,0.00,0.00,411.74,288218.00,0.00,0.00,0.00),('1','223','1','347',1380,'4','1',99017.76,99355.76,0.00,0.00,338.00,225155.00,0.00,0.00,0.00),('1','223','1','348',1381,'1','1',50857.43,50861.43,0.00,0.00,4.00,2800.00,0.00,0.00,0.00),('1','223','1','348',1382,'2','1',49525.37,49550.37,0.00,0.00,25.00,17500.00,0.00,0.00,0.00),('1','223','1','348',1383,'3','1',120447.58,120945.84,0.00,0.00,498.26,348782.00,0.00,0.00,0.00),('1','223','1','348',1384,'4','1',99355.76,100206.81,0.00,0.00,851.05,566158.25,0.00,0.00,0.00),('1','223','1','349',1385,'1','1',50861.43,50861.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','349',1386,'2','1',49550.37,49569.37,0.00,0.00,19.00,13300.00,0.00,0.00,0.00),('1','223','1','349',1387,'3','1',120945.84,121347.85,0.00,0.00,402.01,281407.00,0.00,0.00,0.00),('1','223','1','349',1388,'4','1',100206.81,100513.24,0.00,0.00,306.43,203826.00,0.00,0.00,0.00),('1','223','1','350',1389,'1','1',50861.43,50861.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','350',1390,'2','1',49569.37,49597.87,0.00,0.00,28.50,19950.00,0.00,0.00,0.00),('1','223','1','350',1391,'3','1',121347.85,121808.85,0.00,0.00,461.00,320950.00,0.00,0.00,0.00),('1','223','1','350',1392,'4','1',100513.24,100795.24,0.00,0.00,282.00,187530.00,0.00,0.00,0.00),('1','223','1','351',1393,'1','1',50861.43,50874.29,0.00,0.00,12.86,9002.00,0.00,0.00,0.00),('1','223','1','351',1394,'2','1',49597.87,49624.87,0.00,0.00,27.00,18900.00,0.00,0.00,0.00),('1','223','1','351',1395,'3','1',121808.85,122307.68,0.00,0.00,498.83,349181.00,0.00,0.00,0.00),('1','223','1','351',1396,'4','1',100795.24,101344.24,0.00,0.00,549.00,365085.00,0.00,0.00,0.00),('1','223','1','352',1397,'1','1',50874.29,50875.29,0.00,0.00,1.00,700.00,0.00,0.00,0.00),('1','223','1','352',1398,'2','1',49624.87,49643.87,0.00,0.00,19.00,13300.00,0.00,0.00,0.00),('1','223','1','352',1399,'3','1',122307.68,122429.69,0.00,0.00,122.01,85407.00,0.00,0.00,0.00),('1','223','1','352',1400,'4','1',101344.24,101433.91,0.00,0.00,89.67,59630.55,0.00,0.00,0.00),('1','223','1','353',1401,'1','1',50875.29,50877.29,0.00,0.00,2.00,1400.00,0.00,0.00,0.00),('1','223','1','353',1402,'2','1',49643.87,49675.87,0.00,0.00,32.00,22400.00,0.00,0.00,0.00),('1','223','1','353',1403,'3','1',122429.69,122911.84,0.00,0.00,482.15,337505.00,0.00,0.00,0.00),('1','223','1','353',1404,'4','1',101433.91,101997.05,0.00,0.00,563.14,374738.00,0.00,0.00,0.00),('1','223','1','354',1405,'1','1',50877.29,50881.72,0.00,0.00,4.43,3101.00,0.00,0.00,0.00),('1','223','1','354',1406,'2','1',49675.87,49706.02,0.00,0.00,30.15,21105.00,0.00,0.00,0.00),('1','223','1','354',1407,'3','1',122911.84,123354.70,0.00,0.00,442.86,310002.00,0.00,0.00,0.00),('1','223','1','354',1408,'4','1',101997.05,102644.05,0.00,0.00,647.00,430255.00,0.00,0.00,0.00),('1','223','1','355',1409,'1','1',50881.72,50881.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','355',1410,'2','1',49706.02,49740.45,0.00,0.00,34.43,24101.00,0.00,0.00,0.00),('1','223','1','355',1411,'3','1',123354.70,123910.08,0.00,0.00,555.38,388766.00,0.00,0.00,0.00),('1','223','1','355',1412,'4','1',102644.05,103812.05,0.00,0.00,1168.00,776895.00,0.00,0.00,0.00),('1','223','1','356',1413,'1','1',50881.72,50883.72,0.00,0.00,2.00,1400.00,0.00,0.00,0.00),('1','223','1','356',1414,'2','1',49740.45,49772.41,0.00,0.00,31.96,22372.00,0.00,0.00,0.00),('1','223','1','356',1415,'3','1',123910.08,124374.90,0.00,0.00,464.82,325374.00,0.00,0.00,0.00),('1','223','1','356',1416,'4','1',103812.05,103854.65,0.00,0.00,42.60,28504.00,0.00,0.00,0.00),('1','223','1','357',1417,'1','1',50883.72,50883.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','357',1418,'2','1',49772.41,49798.41,0.00,0.00,26.00,18200.00,0.00,0.00,0.00),('1','223','1','357',1419,'3','1',124374.90,124857.92,0.00,0.00,483.02,338114.00,0.00,0.00,0.00),('1','223','1','357',1420,'4','1',103854.65,103910.65,0.00,0.00,56.00,37345.00,0.00,0.00,0.00),('1','223','1','358',1421,'1','1',50883.72,50883.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','358',1422,'2','1',49798.41,49798.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','358',1423,'3','1',124857.92,124857.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','358',1424,'4','1',103910.65,103910.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','359',1425,'1','1',50883.72,50883.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','359',1426,'2','1',49798.41,49827.42,0.00,0.00,29.01,20307.00,0.00,0.00,0.00),('1','223','1','359',1427,'3','1',124857.92,125932.31,0.00,0.00,1074.39,721315.00,0.00,0.00,0.00),('1','223','1','359',1428,'4','1',103910.65,103956.08,0.00,0.00,45.43,31801.00,0.00,0.00,0.00),('1','223','1','360',1429,'1','1',50883.72,50883.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','360',1430,'2','1',49827.42,49838.99,0.00,0.00,11.57,8099.00,0.00,0.00,0.00),('1','223','1','360',1431,'3','1',125932.31,126963.05,0.00,0.00,1030.74,698918.00,0.00,0.00,0.00),('1','223','1','360',1432,'4','1',103956.08,104198.51,0.00,0.00,242.43,159701.00,0.00,0.00,0.00),('1','223','1','361',1433,'1','1',50883.72,50883.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','361',1434,'2','1',49838.99,49858.42,0.00,0.00,19.43,13601.00,0.00,0.00,0.00),('1','223','1','361',1435,'3','1',126963.05,128160.79,0.00,0.00,1197.74,808468.00,0.00,0.00,0.00),('1','223','1','361',1436,'4','1',104198.51,104345.84,0.00,0.00,147.33,97831.00,0.00,0.00,0.00),('1','223','1','362',1437,'1','1',50883.72,50883.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','362',1438,'2','1',49858.42,49869.42,0.00,0.00,11.00,7700.00,0.00,0.00,0.00),('1','223','1','362',1439,'3','1',128160.79,128932.11,0.00,0.00,771.32,527385.50,0.00,0.00,0.00),('1','223','1','362',1440,'4','1',104345.84,104521.92,0.00,0.00,176.08,118256.00,0.00,0.00,0.00),('1','223','1','363',1441,'1','1',50883.72,50883.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','363',1442,'2','1',49869.42,49890.85,0.00,0.00,21.43,15001.00,0.00,0.00,0.00),('1','223','1','363',1443,'3','1',128932.11,129485.04,0.00,0.00,552.93,379551.00,0.00,0.00,0.00),('1','223','1','363',1444,'4','1',104521.92,104682.38,0.00,0.00,160.46,112322.00,0.00,0.00,0.00),('1','223','1','364',1445,'1','1',50883.72,50883.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','364',1446,'2','1',49890.85,49891.85,0.00,0.00,1.00,700.00,0.00,0.00,0.00),('1','223','1','364',1447,'3','1',129485.04,129504.90,0.00,0.00,19.86,13902.00,0.00,0.00,0.00),('1','223','1','364',1448,'4','1',104682.38,104880.30,0.00,0.00,197.92,138544.00,0.00,0.00,0.00),('1','223','1','365',1449,'1','1',50883.72,50883.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','365',1450,'2','1',49891.85,49919.06,0.00,0.00,27.21,19047.00,0.00,0.00,0.00),('1','223','1','365',1451,'3','1',129504.90,130234.05,0.00,0.00,729.15,502755.00,0.00,0.00,0.00),('1','223','1','365',1452,'4','1',104880.30,105276.59,0.00,0.00,396.29,269903.00,0.00,0.00,0.00),('1','223','1','366',1453,'1','1',50883.72,50883.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','223','1','366',1454,'2','1',49919.06,49974.99,0.00,0.00,55.93,39151.00,0.00,0.00,0.00),('1','223','1','366',1455,'3','1',130234.05,131018.09,0.00,0.00,784.04,541310.50,0.00,0.00,0.00),('1','223','1','366',1456,'4','1',105276.59,106010.93,0.00,0.00,734.34,499413.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=365 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','223','1','1',521.00,580.00,0.00,205.47,107049.87,114672.60,7622.73,1),('1','223','2','1',521.00,580.00,0.00,567.36,295594.56,308818.80,13224.24,2),('1','223','3','1',521.00,0.00,0.00,186.81,97328.01,108349.80,11021.79,3),('1','223','4','1',521.00,0.00,0.00,1631.21,849860.41,593587.30,-256273.11,4),('1','223','5','1',521.00,0.00,0.00,695.65,362433.65,385027.00,22593.35,5),('1','223','6','1',521.00,0.00,0.00,351.48,183121.08,196545.90,13424.82,6),('1','223','7','1',521.00,0.00,0.00,1052.25,548222.25,579048.45,30826.20,7),('1','223','10','1',521.00,0.00,0.00,563.67,293672.07,315903.60,22231.53,8),('1','223','11','1',521.00,0.00,0.00,592.24,308557.04,329099.20,20542.16,9),('1','223','12','1',521.00,0.00,0.00,977.36,509204.56,533298.80,24094.24,10),('1','223','13','1',521.00,0.00,0.00,618.20,322082.20,342806.00,20723.80,11),('1','223','14','1',521.00,0.00,0.00,384.41,200277.61,215982.80,15705.19,12),('1','223','15','1',521.00,0.00,0.00,648.96,338108.16,355246.80,17138.64,13),('1','223','16','1',521.00,0.00,0.00,2170.51,1130835.71,1177724.80,46889.09,14),('1','223','17','1',521.00,0.00,0.00,379.90,197927.90,217867.00,19939.10,15),('1','223','18','1',521.00,0.00,0.00,734.39,382617.19,411523.70,28906.51,16),('1','223','19','1',521.00,0.00,0.00,835.18,435128.78,460512.10,25383.32,17),('1','223','20','1',521.00,521.00,0.00,0.00,0.00,0.00,0.00,18),('1','223','21','1',588.00,0.00,0.00,225.91,132835.08,131027.80,-1807.28,19),('1','223','22','1',588.00,0.00,0.00,1065.98,626796.24,654799.20,28002.96,20),('1','223','23','1',588.00,0.00,0.00,1025.33,602894.04,629804.60,26910.56,21),('1','223','24','1',588.00,0.00,0.00,731.43,430080.84,451486.60,21405.76,22),('1','223','25','1',588.00,620.00,0.00,589.14,346414.32,361916.80,15502.48,23),('1','223','26','1',588.00,620.00,0.00,328.90,193393.20,202698.00,9304.80,24),('1','223','27','1',588.00,0.00,0.00,320.19,188271.72,197717.80,9446.08,25),('1','223','28','1',588.00,0.00,0.00,597.07,351077.16,365683.40,14606.24,26),('1','223','29','1',588.00,0.00,0.00,438.09,257596.92,270455.80,12858.88,27),('1','223','30','1',588.00,620.00,0.00,627.80,369146.40,383386.00,14239.60,28),('1','223','31','1',588.00,0.00,0.00,925.85,544399.80,568667.00,24267.20,29),('1','223','32','1',588.00,0.00,0.00,1190.68,700119.84,733311.60,33191.76,30),('1','223','33','1',588.00,0.00,0.00,575.06,338135.28,355337.20,17201.92,31),('1','223','34','1',588.00,0.00,0.00,704.33,414146.04,431284.60,17138.56,32),('1','223','35','1',588.00,0.00,0.00,1360.88,800197.44,823605.60,23408.16,33),('1','223','36','1',588.00,0.00,0.00,664.02,390443.76,407572.40,17128.64,34),('1','223','37','1',588.00,0.00,0.00,480.64,282616.32,291336.80,8720.48,35),('1','223','38','1',588.00,0.00,0.00,0.00,0.00,0.00,0.00,36),('1','223','39','1',588.00,620.00,0.00,1811.40,1065103.20,1094898.00,29794.80,37),('1','223','40','1',588.00,620.00,0.00,721.41,424189.08,445224.20,21035.12,38),('1','223','41','1',588.00,620.00,0.00,1183.51,695903.88,721196.20,25292.32,39),('1','223','42','1',588.00,620.00,0.00,746.37,438865.56,459249.40,20383.84,40),('1','223','43','1',588.00,620.00,0.00,229.50,134946.00,142290.00,7344.00,41),('1','223','44','1',588.00,620.00,0.00,0.00,0.00,0.00,0.00,42),('1','223','45','1',588.00,620.00,0.00,1656.05,973757.40,1002076.40,28319.00,43),('1','223','46','1',588.00,620.00,0.00,684.27,402350.76,418247.40,15896.64,44),('1','223','47','1',588.00,620.00,0.00,849.92,499752.96,520300.40,20547.44,45),('1','223','48','1',588.00,620.00,0.00,820.66,482548.08,501819.20,19271.12,46),('1','223','49','1',588.00,620.00,0.00,410.09,241132.92,253055.80,11922.88,47),('1','223','50','1',588.00,620.00,0.00,648.57,381359.16,398913.40,17554.24,48),('1','223','51','1',588.00,620.00,0.00,651.78,383246.64,392463.60,9216.96,49),('1','223','52','1',588.00,620.00,0.00,0.00,0.00,0.00,0.00,50),('1','223','53','1',588.00,620.00,0.00,577.17,339375.96,354232.00,14856.04,51),('1','223','54','1',588.00,620.00,0.00,1633.71,960621.48,988790.20,28168.72,52),('1','223','55','1',588.00,620.00,0.00,780.18,458745.84,476161.60,17415.76,53),('1','223','56','1',588.00,620.00,0.00,547.67,322029.96,337935.40,15905.44,54),('1','223','57','1',588.00,620.00,0.00,589.76,346778.88,364451.20,17672.32,55),('1','223','58','1',588.00,620.00,0.00,1501.56,882917.28,910307.20,27389.92,56),('1','223','59','1',588.00,620.00,0.00,510.56,300209.28,307467.20,7257.92,57),('1','223','60','1',588.00,620.00,0.00,0.00,0.00,0.00,0.00,58),('1','223','61','1',588.00,620.00,0.00,2120.63,1246930.44,1287741.60,40811.16,59),('1','223','62','1',588.00,620.00,0.00,1424.39,837541.32,865201.80,27660.48,60),('1','223','63','1',588.00,620.00,0.00,977.50,574770.00,598200.00,23430.00,61),('1','223','64','1',588.00,620.00,0.00,1814.92,1067172.96,1100412.00,33239.04,62),('1','223','65','1',588.00,620.00,0.00,0.00,0.00,0.00,0.00,63),('1','223','66','1',578.00,620.00,0.00,918.50,530893.00,565970.00,35077.00,64),('1','223','67','1',578.00,620.00,0.00,1144.37,661445.86,684864.40,23418.54,65),('1','223','68','1',578.00,620.00,0.00,1541.37,890911.86,921599.40,30687.54,66),('1','223','69','1',578.00,620.00,0.00,788.53,455770.34,479108.60,23338.26,67),('1','223','70','1',578.00,620.00,0.00,906.49,523951.22,549523.10,25571.88,68),('1','223','71','1',578.00,620.00,0.00,769.60,444828.80,474452.00,29623.20,69),('1','223','72','1',578.00,620.00,0.00,2006.92,1159999.76,1202800.40,42800.64,70),('1','223','73','1',578.00,620.00,0.00,548.50,317033.00,338570.00,21537.00,71),('1','223','74','1',578.00,620.00,0.00,1086.84,628193.52,657340.80,29147.28,72),('1','223','75','1',578.00,620.00,0.00,1551.16,896570.48,931179.20,34608.72,73),('1','223','76','1',578.00,620.00,0.00,490.37,283433.86,299523.10,16089.24,74),('1','223','77','1',578.00,620.00,0.00,0.00,0.00,0.00,0.00,75),('1','223','78','1',588.00,620.00,0.00,180.63,106210.44,109746.90,3536.46,76),('1','223','79','1',588.00,630.00,0.00,1587.51,933455.88,971969.76,38513.88,77),('1','223','80','1',588.00,630.00,0.00,1571.95,924306.60,959881.95,35575.35,78),('1','223','81','1',588.00,630.00,0.00,921.18,541653.84,568152.90,26499.06,79),('1','223','82','1',588.00,672.00,0.00,504.82,296834.16,339239.04,42404.88,80),('1','223','83','1',588.00,672.00,0.00,961.58,565409.04,631133.76,65724.72,81),('1','223','84','1',588.00,672.00,0.00,640.22,376449.36,426707.84,50258.48,82),('1','223','85','1',588.00,672.00,0.00,1003.66,590152.08,653999.52,63847.44,83),('1','223','86','1',588.00,672.00,0.00,409.74,240927.12,266325.28,25398.16,84),('1','223','87','1',588.00,672.00,0.00,5002.53,2941487.64,3151621.28,210133.64,85),('1','223','88','1',588.00,672.00,0.00,68.87,40495.56,43250.36,2754.80,86),('1','223','89','1',588.00,672.00,0.00,0.00,0.00,0.00,0.00,87),('1','223','90','1',672.00,672.00,0.00,175.34,117828.48,125367.52,7539.04,88),('1','223','91','1',672.00,728.00,0.00,1082.19,727231.68,753710.32,26478.64,89),('1','223','92','1',672.00,728.00,0.00,1924.16,1293035.52,1336454.48,43418.96,90),('1','223','93','1',672.00,728.00,0.00,653.10,438883.20,460902.80,22019.60,91),('1','223','94','1',672.00,728.00,0.00,763.17,512850.24,541736.76,28886.52,92),('1','223','95','1',672.00,728.00,0.00,301.01,202278.72,216608.28,14329.56,93),('1','223','96','1',672.00,728.00,0.00,577.96,388389.12,399690.34,11301.22,94),('1','223','97','1',672.00,728.00,0.00,0.00,0.00,0.00,0.00,95),('1','223','98','1',672.00,728.00,0.00,70.53,47396.16,51345.84,3949.68,96),('1','223','99','1',672.00,728.00,0.00,476.48,320194.56,342697.44,22502.88,97),('1','223','100','1',672.00,728.00,0.00,432.48,290626.56,314845.44,24218.88,98),('1','223','101','1',672.00,728.00,0.00,491.27,330133.44,350994.56,20861.12,99),('1','223','102','1',672.00,728.00,0.00,1343.44,902791.68,939473.32,36681.64,100),('1','223','103','1',672.00,728.00,0.00,385.69,259183.68,278692.32,19508.64,101),('1','223','104','1',672.00,728.00,0.00,483.06,324616.32,341787.68,17171.36,102),('1','223','105','1',672.00,728.00,0.00,0.00,0.00,0.00,0.00,103),('1','223','106','1',672.00,728.00,0.00,1207.93,811728.96,850379.04,38650.08,104),('1','223','107','1',672.00,728.00,0.00,712.81,479008.32,506499.68,27491.36,105),('1','223','108','1',672.00,728.00,0.00,821.90,552316.80,578811.20,26494.40,106),('1','223','109','1',672.00,728.00,0.00,688.01,462342.72,492566.76,30224.04,107),('1','223','110','1',672.00,728.00,0.00,955.45,642062.40,669256.40,27194.00,108),('1','223','111','1',672.00,728.00,0.00,1332.36,895345.92,935526.28,40180.36,109),('1','223','112','1',672.00,728.00,0.00,1228.66,825659.52,866154.48,40494.96,110),('1','223','113','1',672.00,728.00,0.00,2402.95,1614782.40,1673425.50,58643.10,111),('1','223','114','1',672.00,728.00,0.00,1325.79,890930.88,932638.38,41707.50,112),('1','223','115','1',672.00,728.00,0.00,1542.42,1036506.24,1073804.76,37298.52,113),('1','223','116','1',672.00,728.00,0.00,0.00,0.00,0.00,0.00,114),('1','223','117','1',672.00,728.00,0.00,0.00,0.00,0.00,0.00,115),('1','223','118','1',665.00,728.00,0.00,606.55,403355.75,430044.40,26688.65,116),('1','223','119','1',665.00,728.00,0.00,1319.28,877321.20,923971.84,46650.64,117),('1','223','120','1',665.00,728.00,0.00,1208.73,803805.45,849274.94,45469.49,118),('1','223','121','1',665.00,728.00,0.00,900.51,598839.15,633168.28,34329.13,119),('1','223','122','1',665.00,728.00,0.00,1215.46,808280.90,855571.88,47290.98,120),('1','223','123','1',665.00,728.00,0.00,874.63,581628.95,618341.69,36712.74,121),('1','223','124','1',665.00,728.00,0.00,1935.61,1287180.65,1353588.08,66407.43,122),('1','223','125','1',665.00,728.00,0.00,1818.71,1209442.15,1269875.28,60433.13,123),('1','223','126','1',665.00,728.00,0.00,609.95,405616.75,430391.10,24774.35,124),('1','223','127','1',665.00,728.00,0.00,931.96,619753.40,639340.75,19587.35,125),('1','223','128','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,126),('1','223','129','1',665.00,728.00,0.00,603.72,401473.80,422813.41,21339.61,127),('1','223','130','1',665.00,728.00,0.00,516.90,343738.50,372261.20,28522.70,128),('1','223','131','1',665.00,728.00,0.00,1461.32,971777.80,1016734.46,44956.66,129),('1','223','132','1',665.00,728.00,0.00,2308.60,1535219.00,1596926.90,61707.90,130),('1','223','133','1',665.00,728.00,0.00,193.00,128345.00,136204.00,7859.00,131),('1','223','134','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,132),('1','223','135','1',665.00,728.00,0.00,657.10,436971.50,463985.30,27013.80,133),('1','223','136','1',665.00,728.00,0.00,1273.94,847170.10,892469.32,45299.22,134),('1','223','137','1',665.00,728.00,0.00,1528.83,1016671.95,1058364.24,41692.29,135),('1','223','138','1',665.00,728.00,0.00,940.88,625685.20,660011.68,34326.48,136),('1','223','139','1',665.00,728.00,0.00,1109.31,737691.15,776953.68,39262.53,137),('1','223','140','1',665.00,728.00,0.00,2185.15,1453124.75,1526741.36,73616.61,138),('1','223','141','1',665.00,728.00,0.00,1155.60,768474.00,807772.80,39298.80,139),('1','223','142','1',665.00,728.00,0.00,1230.28,818136.20,858155.84,40019.64,140),('1','223','143','1',665.00,728.00,0.00,1365.07,907771.55,951530.96,43759.41,141),('1','223','144','1',665.00,728.00,0.00,998.40,663936.00,696049.92,32113.92,142),('1','223','145','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,143),('1','223','146','1',665.00,728.00,0.00,2243.20,1491728.00,1550921.60,59193.60,144),('1','223','147','1',665.00,728.00,0.00,453.21,301384.65,329936.88,28552.23,145),('1','223','148','1',665.00,728.00,0.00,1425.75,948123.75,991386.00,43262.25,146),('1','223','149','1',665.00,728.00,0.00,951.71,632887.15,660576.88,27689.73,147),('1','223','150','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,148),('1','223','151','1',665.00,728.00,0.00,1067.64,709980.60,733285.92,23305.32,149),('1','223','152','1',665.00,728.00,0.00,1076.18,715659.70,751432.00,35772.30,150),('1','223','153','1',665.00,728.00,0.00,1108.32,737032.80,779208.96,42176.16,151),('1','223','154','1',665.00,728.00,0.00,2617.77,1740817.05,1797784.56,56967.51,152),('1','223','155','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,153),('1','223','156','1',665.00,728.00,0.00,577.03,383724.95,395789.84,12064.89,154),('1','223','157','1',665.00,728.00,0.00,1551.88,1032000.20,1074232.64,42232.44,155),('1','223','158','1',665.00,728.00,0.00,1980.63,1317118.95,1379210.64,62091.69,156),('1','223','159','1',665.00,728.00,0.00,1067.56,709927.40,746723.84,36796.44,157),('1','223','160','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,158),('1','223','161','1',665.00,728.00,0.00,2084.56,1386232.40,1445393.60,59161.20,159),('1','223','162','1',665.00,728.00,0.00,1086.16,722296.40,759068.48,36772.08,160),('1','223','163','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,161),('1','223','164','1',665.00,728.00,0.00,1605.09,1067384.85,1121897.52,54512.67,162),('1','223','165','1',665.00,728.00,0.00,380.70,253165.50,269844.00,16678.50,163),('1','223','166','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,164),('1','223','167','1',665.00,728.00,0.00,2341.61,1557170.65,1614093.52,56922.87,165),('1','223','168','1',665.00,728.00,0.00,916.60,609539.00,640596.80,31057.80,166),('1','223','169','1',665.00,728.00,0.00,1352.07,899126.55,925862.16,26735.61,167),('1','223','170','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,168),('1','223','171','1',665.00,728.00,0.00,591.24,393174.60,414918.72,21744.12,169),('1','223','172','1',665.00,728.00,0.00,2325.21,1546264.65,1602779.76,56515.11,170),('1','223','173','1',665.00,728.00,0.00,1300.10,864566.50,905240.80,40674.30,171),('1','223','174','1',665.00,728.00,0.00,859.48,571554.20,602301.44,30747.24,172),('1','223','175','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,173),('1','223','176','1',665.00,728.00,0.00,68.93,45838.45,50181.04,4342.59,174),('1','223','177','1',665.00,728.00,0.00,2042.28,1358116.20,1414083.84,55967.64,175),('1','223','178','1',665.00,728.00,0.00,2206.80,1467522.00,1520342.40,52820.40,176),('1','223','179','1',665.00,728.00,0.00,910.49,605475.85,640468.72,34992.87,177),('1','223','180','1',665.00,728.00,0.00,661.11,439638.15,465304.08,25665.93,178),('1','223','181','1',665.00,728.00,0.00,564.00,375060.00,385333.92,10273.92,179),('1','223','182','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,180),('1','223','183','1',665.00,728.00,0.00,3415.32,2271187.80,2343864.96,72677.16,181),('1','223','184','1',665.00,728.00,0.00,955.57,635454.05,670934.96,35480.91,182),('1','223','185','1',665.00,728.00,0.00,1107.89,736746.85,772079.92,35333.07,183),('1','223','186','1',665.00,728.00,0.00,1179.18,784154.70,819371.04,35216.34,184),('1','223','187','1',665.00,728.00,0.00,490.11,325923.15,356800.08,30876.93,185),('1','223','188','1',665.00,728.00,0.00,2562.02,1703743.30,1765046.56,61303.26,186),('1','223','189','1',665.00,728.00,0.00,676.73,450025.45,479891.44,29865.99,187),('1','223','190','1',665.00,728.00,0.00,903.92,601106.80,640725.76,39618.96,188),('1','223','191','1',665.00,728.00,0.00,1093.01,726851.65,755823.28,28971.63,189),('1','223','192','1',665.00,728.00,0.00,0.00,0.00,0.00,0.00,190),('1','223','193','1',660.00,728.00,0.00,2118.25,1398045.00,1468096.88,70051.88,191),('1','223','194','1',660.00,728.00,0.00,1318.85,870441.00,917882.80,47441.80,192),('1','223','195','1',660.00,728.00,0.00,406.28,268144.80,293371.84,25227.04,193),('1','223','196','1',660.00,728.00,0.00,2882.38,1902370.80,1990518.08,88147.28,194),('1','223','197','1',660.00,728.00,0.00,664.01,438246.60,478311.28,40064.68,195),('1','223','198','1',660.00,728.00,0.00,1066.65,703989.00,760153.20,56164.20,196),('1','223','199','1',660.00,728.00,0.00,1654.88,1092220.80,1153080.64,60859.84,197),('1','223','200','1',660.00,728.00,0.00,1686.08,1112812.80,1174050.88,61238.08,198),('1','223','201','1',660.00,728.00,0.00,670.16,442305.60,460324.48,18018.88,199),('1','223','202','1',660.00,728.00,0.00,0.00,0.00,0.00,0.00,200),('1','223','203','1',660.00,728.00,0.00,2080.89,1373387.40,1436935.92,63548.52,201),('1','223','204','1',660.00,728.00,0.00,1283.42,847057.20,891705.76,44648.56,202),('1','223','205','1',660.00,728.00,0.00,1653.59,1091369.40,1145541.52,54172.12,203),('1','223','206','1',660.00,728.00,0.00,1558.83,1028827.80,1082892.24,54064.44,204),('1','223','207','1',660.00,728.00,0.00,1313.84,867134.40,910875.52,43741.12,205),('1','223','208','1',660.00,728.00,0.00,1715.19,1132025.40,1189066.32,57040.92,206),('1','223','209','1',660.00,728.00,0.00,2469.53,1629889.80,1688641.84,58752.04,207),('1','223','210','1',660.00,660.00,0.00,0.00,0.00,0.00,0.00,208),('1','223','211','1',660.00,728.00,0.00,1449.51,956676.60,1006835.28,50158.68,209),('1','223','212','1',660.00,728.00,0.00,1127.29,744011.40,786347.12,42335.72,210),('1','223','213','1',660.00,728.00,0.00,842.29,555911.40,577763.12,21851.72,211),('1','223','214','1',660.00,728.00,0.00,0.00,0.00,0.00,0.00,212),('1','223','215','1',660.00,728.00,0.00,1776.62,1172569.20,1213301.44,40732.24,213),('1','223','216','1',660.00,728.00,0.00,1375.09,907559.40,957673.52,50114.12,214),('1','223','217','1',660.00,728.00,0.00,1062.33,701137.80,746976.24,45838.44,215),('1','223','218','1',660.00,728.00,0.00,1302.35,859551.00,911088.40,51537.40,216),('1','223','219','1',660.00,728.00,0.00,0.00,0.00,0.00,0.00,217),('1','223','220','1',675.00,770.00,0.00,1755.22,1184773.50,1282744.40,97970.90,218),('1','223','221','1',675.00,770.00,0.00,1088.22,734548.50,805598.90,71050.40,219),('1','223','222','1',675.00,770.00,0.00,516.54,348664.50,390235.80,41571.30,220),('1','223','223','1',675.00,770.00,0.00,679.40,458595.00,511905.80,53310.80,221),('1','223','224','1',675.00,760.00,0.00,481.46,324985.50,365909.60,40924.10,222),('1','223','225','1',675.00,760.00,0.00,510.30,344452.50,368453.00,24000.50,223),('1','223','226','1',675.00,760.00,0.00,0.00,0.00,0.00,0.00,224),('1','223','227','1',661.00,760.00,0.00,654.63,432710.43,491118.80,58408.37,225),('1','223','228','1',661.00,760.00,0.00,467.08,308739.88,354980.80,46240.92,226),('1','223','229','1',661.00,760.00,0.00,785.82,519427.02,581445.70,62018.68,227),('1','223','230','1',661.00,760.00,0.00,630.14,416522.54,468506.40,51983.86,228),('1','223','231','1',661.00,760.00,0.00,369.06,243948.66,280485.60,36536.94,229),('1','223','232','1',661.00,760.00,0.00,1019.00,673559.00,744140.00,70581.00,230),('1','223','233','1',661.00,760.00,0.00,449.60,297185.60,341696.00,44510.40,231),('1','223','234','1',661.00,760.00,0.00,772.37,510536.57,570626.20,60089.63,232),('1','223','235','1',661.00,760.00,0.00,742.51,490799.11,549307.60,58508.49,233),('1','223','236','1',661.00,760.00,0.00,470.61,311073.21,355163.60,44090.39,234),('1','223','237','1',661.00,760.00,0.00,622.79,411664.19,466295.40,54631.21,235),('1','223','238','1',661.00,760.00,0.00,1066.57,705002.77,778043.20,73040.43,236),('1','223','239','1',661.00,740.00,0.00,786.38,519797.18,565149.60,45352.42,237),('1','223','240','1',661.00,740.00,0.00,958.60,633634.60,687124.00,53489.40,238),('1','223','241','1',661.00,740.00,0.00,1249.23,825741.03,891190.20,65449.17,239),('1','223','242','1',661.00,740.00,0.00,510.06,337149.66,373444.40,36294.74,240),('1','223','243','1',661.00,740.00,0.00,0.00,0.00,0.00,0.00,241),('1','223','244','1',675.00,740.00,0.00,582.58,393241.50,418609.20,25367.70,242),('1','223','245','1',675.00,740.00,0.00,799.76,539838.00,577822.40,37984.40,243),('1','223','246','1',675.00,740.00,0.00,927.12,625806.00,663468.80,37662.80,244),('1','223','247','1',675.00,740.00,0.00,1220.13,823587.75,871756.20,48168.45,245),('1','223','248','1',675.00,740.00,0.00,752.63,508025.25,538066.20,30040.95,246),('1','223','249','1',675.00,740.00,0.00,894.55,603821.25,642467.00,38645.75,247),('1','223','250','1',675.00,740.00,0.00,0.00,0.00,0.00,0.00,248),('1','223','251','1',675.00,740.00,0.00,863.01,582531.75,628987.40,46455.65,249),('1','223','252','1',675.00,740.00,0.00,799.60,539730.00,577464.00,37734.00,250),('1','223','253','1',675.00,740.00,0.00,1175.17,793239.75,843885.80,50646.05,251),('1','223','254','1',675.00,740.00,0.00,1228.69,829365.75,878305.60,48939.85,252),('1','223','255','1',675.00,740.00,0.00,1105.75,746381.25,787412.50,41031.25,253),('1','223','256','1',675.00,740.00,0.00,1319.28,890514.00,933717.20,43203.20,254),('1','223','257','1',675.00,740.00,0.00,1327.35,895961.25,941814.00,45852.75,255),('1','223','258','1',675.00,740.00,0.00,924.28,623889.00,665717.20,41828.20,256),('1','223','259','1',675.00,740.00,0.00,1052.13,710187.75,753276.20,43088.45,257),('1','223','260','1',675.00,740.00,0.00,849.44,573372.00,609235.60,35863.60,258),('1','223','261','1',675.00,740.00,0.00,442.77,298869.75,324749.80,25880.05,259),('1','223','262','1',675.00,740.00,0.00,510.33,344472.75,357344.20,12871.45,260),('1','223','263','1',675.00,740.00,0.00,0.00,0.00,0.00,0.00,261),('1','223','264','1',650.00,740.00,0.00,722.36,469534.00,513146.40,43612.40,262),('1','223','265','1',650.00,740.00,0.00,432.81,281326.50,315085.68,33759.18,263),('1','223','266','1',650.00,728.00,0.00,1296.54,842751.00,908673.12,65922.12,264),('1','223','267','1',650.00,728.00,0.00,925.77,601750.50,649960.56,48210.06,265),('1','223','268','1',650.00,728.00,0.00,1641.63,1067059.50,1138034.64,70975.14,266),('1','223','269','1',650.00,728.00,0.00,878.30,570895.00,620538.40,49643.40,267),('1','223','270','1',650.00,728.00,0.00,961.64,625066.00,673385.92,48319.92,268),('1','223','271','1',650.00,728.00,0.00,677.85,440602.50,478642.80,38040.30,269),('1','223','272','1',650.00,728.00,0.00,546.84,355446.00,391185.60,35739.60,270),('1','223','273','1',650.00,728.00,0.00,1548.40,1006460.00,1080627.20,74167.20,271),('1','223','274','1',650.00,728.00,0.00,1379.91,896941.50,962526.48,65584.98,272),('1','223','275','1',650.00,728.00,0.00,748.38,486447.00,534020.64,47573.64,273),('1','223','276','1',650.00,728.00,0.00,430.36,279734.00,294666.08,14932.08,274),('1','223','277','1',650.00,728.00,0.00,0.00,0.00,0.00,0.00,275),('1','223','278','1',650.00,728.00,0.00,294.34,191321.00,214279.52,22958.52,276),('1','223','279','1',650.00,728.00,0.00,540.57,351370.50,379134.96,27764.46,277),('1','223','280','1',650.00,728.00,0.00,1035.25,672912.50,717518.00,44605.50,278),('1','223','281','1',650.00,728.00,0.00,819.21,532486.50,578864.88,46378.38,279),('1','223','282','1',650.00,728.00,0.00,1915.74,1245231.00,1353882.72,108651.72,280),('1','223','283','1',650.00,728.00,0.00,603.23,392099.50,431951.44,39851.94,281),('1','223','284','1',650.00,728.00,0.00,1397.53,908394.50,964097.84,55703.34,282),('1','223','285','1',650.00,728.00,0.00,1136.59,738783.50,795949.52,57166.02,283),('1','223','286','1',650.00,728.00,0.00,520.59,338383.50,369989.52,31606.02,284),('1','223','287','1',650.00,728.00,0.00,1010.24,656656.00,704830.72,48174.72,285),('1','223','288','1',650.00,728.00,0.00,1158.84,753246.00,799619.52,46373.52,286),('1','223','289','1',650.00,728.00,0.00,0.00,0.00,0.00,0.00,287),('1','223','290','1',650.00,725.00,0.00,665.33,432464.50,470136.65,37672.15,288),('1','223','291','1',650.00,724.00,0.00,1307.41,849816.50,912002.84,62186.34,289),('1','223','292','1',650.00,724.00,0.00,1064.66,692029.00,751651.84,59622.84,290),('1','223','293','1',650.00,724.00,0.00,1018.73,662174.50,726208.52,64034.02,291),('1','223','294','1',650.00,724.00,0.00,1106.95,719517.50,783281.80,63764.30,292),('1','223','295','1',650.00,724.00,0.00,1645.95,1069867.50,1151740.00,81872.50,293),('1','223','296','1',650.00,724.00,0.00,1128.35,733427.50,798753.40,65325.90,294),('1','223','297','1',650.00,724.00,0.00,1320.67,858435.50,926421.08,67985.58,295),('1','223','298','1',650.00,724.00,0.00,939.97,610980.50,663510.28,52529.78,296),('1','223','299','1',650.00,724.00,0.00,927.37,602790.50,662615.88,59825.38,297),('1','223','300','1',650.00,724.00,0.00,692.19,449923.50,494545.56,44622.06,298),('1','223','301','1',650.00,724.00,0.00,0.00,0.00,0.00,0.00,299),('1','223','302','1',638.00,700.00,0.00,1247.18,795700.84,857696.00,61995.16,300),('1','223','303','1',638.00,700.00,0.00,1671.36,1066327.68,1138512.00,72184.32,301),('1','223','304','1',638.00,700.00,0.00,1557.69,993806.22,1060773.00,66966.78,302),('1','223','305','1',638.00,700.00,0.00,1108.85,707446.30,758303.90,50857.60,303),('1','223','306','1',638.00,700.00,0.00,868.57,554147.66,600199.00,46051.34,304),('1','223','307','1',638.00,700.00,0.00,1263.92,806380.96,863744.00,57363.04,305),('1','223','308','1',638.00,700.00,0.00,805.59,513966.42,555348.00,41381.58,306),('1','223','309','1',638.00,700.00,0.00,1529.13,975584.94,1044141.00,68556.06,307),('1','223','310','1',638.00,700.00,0.00,1091.62,696453.56,744403.60,47950.04,308),('1','223','311','1',638.00,700.00,0.00,723.14,461363.32,491048.00,29684.68,309),('1','223','312','1',638.00,700.00,0.00,500.21,319133.98,347705.30,28571.32,310),('1','223','313','1',638.00,700.00,0.00,0.00,0.00,0.00,0.00,311),('1','223','314','1',638.00,700.00,0.00,940.37,599956.06,647099.00,47142.94,312),('1','223','315','1',638.00,700.00,0.00,1148.76,732908.88,787422.00,54513.12,313),('1','223','316','1',638.00,700.00,0.00,1259.45,803529.10,863285.00,59755.90,314),('1','223','317','1',638.00,700.00,0.00,1654.63,1055653.94,1124665.00,69011.06,315),('1','223','318','1',638.00,700.00,0.00,0.00,0.00,0.00,0.00,316),('1','223','319','1',638.00,700.00,0.00,917.87,585601.06,631229.00,45627.94,317),('1','223','320','1',638.00,700.00,0.00,590.66,376841.08,411270.50,34429.42,318),('1','223','321','1',638.00,700.00,0.00,829.36,529131.68,570637.00,41505.32,319),('1','223','322','1',638.00,700.00,0.00,1391.34,887674.92,953250.60,65575.68,320),('1','223','323','1',638.00,700.00,0.00,1451.78,926235.64,985856.00,59620.36,321),('1','223','324','1',638.00,700.00,0.00,0.00,0.00,0.00,0.00,322),('1','223','325','1',633.00,700.00,0.00,496.32,314170.56,338889.00,24718.44,323),('1','223','326','1',633.00,700.00,0.00,1686.68,1067668.44,1161296.00,93627.56,324),('1','223','327','1',633.00,700.00,0.00,1240.98,785540.34,858873.90,73333.56,325),('1','223','328','1',633.00,700.00,0.00,772.35,488897.55,534405.00,45507.45,326),('1','223','329','1',633.00,700.00,0.00,1424.56,901746.48,974128.00,72381.52,327),('1','223','330','1',633.00,700.00,0.00,1069.70,677120.10,731315.00,54194.90,328),('1','223','331','1',633.00,700.00,0.00,1582.53,1001741.49,1078672.80,76931.31,329),('1','223','332','1',633.00,700.00,0.00,954.50,604198.50,659765.00,55566.50,330),('1','223','333','1',633.00,700.00,0.00,1016.41,643387.53,700687.00,57299.47,331),('1','223','334','1',633.00,700.00,0.00,943.71,597368.43,652227.00,54858.57,332),('1','223','335','1',633.00,700.00,0.00,757.95,479782.35,522825.00,43042.65,333),('1','223','336','1',633.00,700.00,0.00,314.64,199167.12,217248.00,18080.88,334),('1','223','337','1',633.00,700.00,0.00,0.00,0.00,0.00,0.00,335),('1','223','338','1',628.00,700.00,0.00,1104.09,693368.52,757713.00,64344.48,336),('1','223','339','1',628.00,700.00,0.00,1232.89,774254.92,845313.00,71058.08,337),('1','223','340','1',628.00,700.00,0.00,1284.04,806377.12,875360.50,68983.38,338),('1','223','341','1',628.00,700.00,0.00,855.06,536977.68,593292.00,56314.32,339),('1','223','342','1',628.00,700.00,0.00,1386.16,870508.48,944282.50,73774.02,340),('1','223','343','1',628.00,700.00,0.00,582.24,365646.72,404068.00,38421.28,341),('1','223','344','1',628.00,700.00,0.00,741.56,465699.68,512092.00,46392.32,342),('1','223','345','1',628.00,700.00,0.00,2564.22,1610330.16,1725983.00,115652.84,343),('1','223','346','1',628.00,700.00,0.00,1439.74,904156.72,976790.50,72633.78,344),('1','223','347','1',628.00,700.00,0.00,833.38,523362.64,571921.00,48558.36,345),('1','223','348','1',628.00,700.00,0.00,1378.31,865578.68,935240.25,69661.57,346),('1','223','349','1',628.00,700.00,0.00,727.44,456832.32,498533.00,41700.68,347),('1','223','350','1',628.00,700.00,0.00,771.50,484502.00,528430.00,43928.00,348),('1','223','351','1',628.00,700.00,0.00,1087.69,683069.32,742168.00,59098.68,349),('1','223','352','1',628.00,700.00,0.00,231.68,145495.04,159037.55,13542.51,350),('1','223','353','1',628.00,700.00,0.00,1079.29,677794.12,736043.00,58248.88,351),('1','223','354','1',628.00,700.00,0.00,1124.44,706148.32,764463.00,58314.68,352),('1','223','355','1',628.00,700.00,0.00,1757.81,1103904.68,1189762.00,85857.32,353),('1','223','356','1',628.00,700.00,0.00,541.38,339986.64,377650.00,37663.36,354),('1','223','357','1',628.00,700.00,0.00,565.02,354832.56,393659.00,38826.44,355),('1','223','358','1',628.00,700.00,0.00,0.00,0.00,0.00,0.00,356),('1','223','359','1',620.00,700.00,0.00,1148.83,712274.60,773423.00,61148.40,357),('1','223','360','1',620.00,700.00,0.00,1284.74,796538.80,866718.00,70179.20,358),('1','223','361','1',620.00,700.00,0.00,1364.50,845990.00,919900.00,73910.00,359),('1','223','362','1',620.00,700.00,0.00,958.40,594208.00,653341.50,59133.50,360),('1','223','363','1',620.00,700.00,0.00,734.82,455588.40,506874.00,51285.60,361),('1','223','364','1',620.00,700.00,0.00,218.78,135643.60,153146.00,17502.40,362),('1','223','365','1',620.00,700.00,0.00,1152.65,714643.00,791705.00,77062.00,363),('1','223','366','1',620.00,700.00,0.00,1574.31,976072.20,1079874.50,103802.30,364);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'223','PRODUCT TANK','TANK CONTAINING LPG PRODUCT');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','223','1',1,1,'1','LPG TANK',15000.00,0.00,NULL,'','487','2022-03-02 14:15:46','2022-03-02 14:15:46','487',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','223',1,3842.97,'2023-03-20 19:59:33');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=41525 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,6773000.00,13000.00,0.00,0.00,'2022-03-05 07:50:24','',''),(2,'1','223',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,13000.00,0.00,'2022-03-05 07:55:00','',''),(3,'1','223','1',1,'Received from bridging 1',0.00,0.00,13000.00,0.00,0.00,'2022-03-05 07:55:00','',''),(4,'1','223','1',1,'Retail Sale Id 1',53500.00,0.00,0.00,100.00,1400.00,'2022-03-05 08:10:42','',''),(5,'1','223','1',1,'Retail Sale Id 2',16298.00,0.00,0.00,28.10,1657.90,'2022-03-05 08:18:01','',''),(6,'1','223','1',1,'Retail Sale Id 3',1751.60,0.00,0.00,3.02,178.18,'2022-03-05 08:55:03','',''),(7,'1','223','1',1,'Retail Sale Id 4',3480.00,0.00,0.00,6.00,354.00,'2022-03-05 10:26:34','',''),(8,'1','223','1',1,'Retail Sale Id 5',2900.00,0.00,0.00,5.00,295.00,'2022-03-05 10:36:16','',''),(9,'1','223','1',1,'Retail Sale Id 6',3497.40,0.00,0.00,6.03,355.77,'2022-03-05 11:55:11','',''),(10,'1','223','1',1,'Retail Sale Id 8',1200.60,0.00,0.00,2.07,122.13,'2022-03-05 11:57:48','',''),(11,'1','223','1',1,'Retail Sale Id 9',1200.60,0.00,0.00,2.07,122.13,'2022-03-05 12:58:54','',''),(12,'1','223','1',1,'Retail Sale Id 10',2900.00,0.00,0.00,5.00,295.00,'2022-03-05 13:23:07','',''),(13,'1','223','1',1,'Retail Sale Id 11',1740.00,0.00,0.00,3.00,177.00,'2022-03-05 14:49:19','',''),(14,'1','223','1',1,'Retail Sale Id 12',7250.00,0.00,0.00,12.50,737.50,'2022-03-05 15:02:37','',''),(15,'1','223','1',1,'Retail Sale Id 13',2900.00,0.00,0.00,5.00,295.00,'2022-03-05 16:13:27','',''),(16,'1','223','1',1,'Retail Sale Id 15',1200.60,0.00,0.00,2.07,122.13,'2022-03-05 17:14:52','',''),(17,'1','223','1',1,'Retail Sale Id 16',997.60,0.00,0.00,1.72,101.48,'2022-03-05 17:25:04','',''),(18,'1','223','1',1,'Retail Sale Id 17',597.40,0.00,0.00,1.03,60.77,'2022-03-05 17:55:31','',''),(19,'1','223','1',1,'Retail Sale Id 18',1200.60,0.00,0.00,2.07,122.13,'2022-03-05 18:02:57','',''),(20,'1','223','1',1,'Retail Sale Id 19',1751.60,0.00,0.00,3.02,178.18,'2022-03-05 18:12:17','',''),(21,'1','223','1',1,'Retail Sale Id 20',1740.00,0.00,0.00,3.00,177.00,'2022-03-05 18:24:53','',''),(22,'1','223','1',1,'Retail Sale Id 21',1160.00,0.00,0.00,2.00,118.00,'2022-03-05 18:35:20','',''),(23,'1','223','1',1,'Retail Sale Id 23',1751.60,0.00,0.00,3.02,178.18,'2022-03-05 18:43:01','',''),(24,'1','223','1',1,'Retail Sale Id 24',597.40,0.00,0.00,1.03,60.77,'2022-03-05 18:56:03','',''),(25,'1','223','1',1,'Retail Sale Id 25',997.60,0.00,0.00,1.72,101.48,'2022-03-05 18:59:47','',''),(26,'1','223','1',1,'Retail Sale Id 26',2900.00,0.00,0.00,5.00,295.00,'2022-03-05 19:17:51','',''),(27,'1','223','1',1,'Retail Sale Id 7',1160.00,0.00,0.00,2.00,118.00,'2022-03-05 19:59:35','',''),(28,'1','223','1',1,'Retail Sale Id 27',3480.00,0.00,0.00,6.00,354.00,'2022-03-06 08:17:41','',''),(29,'1','223','1',1,'Retail Sale Id 29',3480.00,0.00,0.00,6.00,354.00,'2022-03-06 10:32:48','',''),(30,'1','223','1',1,'Retail Sale Id 30',1740.00,0.00,0.00,3.00,177.00,'2022-03-06 10:35:09','',''),(31,'1','223','1',1,'Retail Sale Id 31',2900.00,0.00,0.00,5.00,295.00,'2022-03-06 10:36:30','',''),(32,'1','223','1',1,'Retail Sale Id 32',160500.00,0.00,0.00,300.00,4200.00,'2022-03-06 12:15:58','',''),(33,'1','223','1',1,'Retail Sale Id 33',1502.20,0.00,0.00,2.59,152.81,'2022-03-06 12:38:16','',''),(34,'1','223','1',1,'Retail Sale Id 34',2302.60,0.00,0.00,3.97,234.23,'2022-03-06 12:39:56','',''),(35,'1','223','1',1,'Retail Sale Id 35',1699.40,0.00,0.00,2.93,172.87,'2022-03-06 12:41:47','',''),(36,'1','223','1',1,'Retail Sale Id 36',1751.60,0.00,0.00,3.02,178.18,'2022-03-06 12:43:08','',''),(37,'1','223','1',1,'Retail Sale Id 37',26750.00,0.00,0.00,50.00,700.00,'2022-03-06 13:06:04','',''),(38,'1','223','1',1,'Retail Sale Id 38',3480.00,0.00,0.00,6.00,354.00,'2022-03-06 13:12:52','',''),(39,'1','223','1',1,'Retail Sale Id 39',2001.00,0.00,0.00,3.45,203.55,'2022-03-06 13:17:56','',''),(40,'1','223','1',1,'Retail Sale Id 40',3497.40,0.00,0.00,6.03,355.77,'2022-03-06 13:45:58','',''),(41,'1','223','1',1,'Return of Retail Sale Id 32',0.00,160500.00,300.00,0.00,-4200.00,'2022-03-06 13:47:21','',''),(42,'1','223','1',1,'Retail Sale Id 41',184575.00,0.00,0.00,345.00,4830.00,'2022-03-06 13:50:47','',''),(43,'1','223','1',1,'Retail Sale Id 42',1751.60,0.00,0.00,3.02,178.18,'2022-03-06 13:54:10','',''),(44,'1','223','1',1,'Retail Sale Id 43',3497.40,0.00,0.00,6.03,355.77,'2022-03-06 14:05:00','',''),(45,'1','223','1',1,'Retail Sale Id 44',1751.60,0.00,0.00,3.02,178.18,'2022-03-06 14:15:20','',''),(46,'1','223','1',1,'Retail Sale Id 57',1751.60,0.00,0.00,3.02,178.18,'2022-03-06 15:00:00','',''),(47,'1','223','1',1,'Retail Sale Id 58',2900.00,0.00,0.00,5.00,295.00,'2022-03-06 15:07:40','',''),(48,'1','223','1',1,'Retail Sale Id 59',2320.00,0.00,0.00,4.00,236.00,'2022-03-06 15:10:58','',''),(49,'1','223','1',1,'Retail Sale Id 60',3480.00,0.00,0.00,6.00,354.00,'2022-03-06 15:12:05','',''),(50,'1','223','1',1,'Retail Sale Id 61',597.40,0.00,0.00,1.03,60.77,'2022-03-06 15:20:24','',''),(51,'1','223','1',1,'Retail Sale Id 62',4999.60,0.00,0.00,8.62,508.58,'2022-03-06 15:22:01','',''),(52,'1','223','1',1,'Retail Sale Id 63',2349.00,0.00,0.00,4.05,238.95,'2022-03-06 15:30:27','',''),(53,'1','223','1',1,'Retail Sale Id 64',3480.00,0.00,0.00,6.00,354.00,'2022-03-06 15:44:23','',''),(54,'1','223','1',1,'Retail Sale Id 65',1200.60,0.00,0.00,2.07,122.13,'2022-03-06 15:48:22','',''),(55,'1','223','1',1,'Retail Sale Id 66',29425.00,0.00,0.00,55.00,770.00,'2022-03-06 16:33:20','',''),(56,'1','223','1',1,'Retail Sale Id 67',1751.60,0.00,0.00,3.02,178.18,'2022-03-06 17:02:49','',''),(57,'1','223','1',1,'Retail Sale Id 68',2001.00,0.00,0.00,3.45,203.55,'2022-03-06 17:43:24','',''),(58,'1','223','1',1,'Retail Sale Id 69',2900.00,0.00,0.00,5.00,295.00,'2022-03-06 17:47:09','',''),(59,'1','223','1',1,'Retail Sale Id 71',1751.60,0.00,0.00,3.02,178.18,'2022-03-06 17:59:23','',''),(60,'1','223','1',1,'Retail Sale Id 72',1751.60,0.00,0.00,3.02,178.18,'2022-03-06 18:28:41','',''),(61,'1','223','1',1,'Retail Sale Id 73',597.40,0.00,0.00,1.03,60.77,'2022-03-07 08:55:05','',''),(62,'1','223','1',1,'Retail Sale Id 74',6397.40,0.00,0.00,11.03,650.77,'2022-03-07 09:47:54','',''),(63,'1','223','1',1,'Retail Sale Id 75',3497.40,0.00,0.00,6.03,355.77,'2022-03-07 10:16:22','',''),(64,'1','223','1',1,'Retail Sale Id 76',1740.00,0.00,0.00,3.00,177.00,'2022-03-07 10:23:03','',''),(65,'1','223','1',1,'Retail Sale Id 77',3497.40,0.00,0.00,6.03,355.77,'2022-03-07 10:45:12','',''),(66,'1','223','1',1,'Retail Sale Id 78',2001.00,0.00,0.00,3.45,203.55,'2022-03-07 10:46:58','',''),(67,'1','223','1',1,'Retail Sale Id 79',2349.00,0.00,0.00,4.05,238.95,'2022-03-07 10:58:46','',''),(68,'1','223','1',1,'Retail Sale Id 80',2900.00,0.00,0.00,5.00,295.00,'2022-03-07 11:34:32','',''),(69,'1','223','1',1,'Retail Sale Id 81',1502.20,0.00,0.00,2.59,152.81,'2022-03-07 11:39:13','',''),(70,'1','223','1',1,'Retail Sale Id 82',2900.00,0.00,0.00,5.00,295.00,'2022-03-07 12:27:17','',''),(71,'1','223','1',1,'Retail Sale Id 84',3497.40,0.00,0.00,6.03,355.77,'2022-03-07 13:40:49','',''),(72,'1','223','1',1,'Retail Sale Id 85',1160.00,0.00,0.00,2.00,118.00,'2022-03-07 14:17:07','',''),(73,'1','223','1',1,'Retail Sale Id 86',1740.00,0.00,0.00,3.00,177.00,'2022-03-07 14:19:12','',''),(74,'1','223','1',1,'Retail Sale Id 88',2320.00,0.00,0.00,4.00,236.00,'2022-03-07 14:51:59','',''),(75,'1','223','1',1,'Retail Sale Id 89',597.40,0.00,0.00,1.03,60.77,'2022-03-07 15:07:11','',''),(76,'1','223','1',1,'Retail Sale Id 90',3497.40,0.00,0.00,6.03,355.77,'2022-03-07 15:18:17','',''),(77,'1','223','1',1,'Retail Sale Id 91',1200.60,0.00,0.00,2.07,122.13,'2022-03-07 15:30:57','',''),(78,'1','223','1',1,'Retail Sale Id 92',3480.00,0.00,0.00,6.00,354.00,'2022-03-07 16:37:39','',''),(79,'1','223','1',1,'Retail Sale Id 94',1148.40,0.00,0.00,1.98,116.82,'2022-03-07 16:40:53','',''),(80,'1','223','1',1,'Retail Sale Id 95',1200.60,0.00,0.00,2.07,122.13,'2022-03-07 17:00:07','',''),(81,'1','223','1',1,'Retail Sale Id 96',1751.60,0.00,0.00,3.02,178.18,'2022-03-07 17:12:25','',''),(82,'1','223','1',1,'Retail Sale Id 97',2998.60,0.00,0.00,5.17,305.03,'2022-03-07 17:16:21','',''),(83,'1','223','1',1,'Retail Sale Id 98',1751.60,0.00,0.00,3.02,178.18,'2022-03-07 17:18:02','',''),(84,'1','223','1',1,'Retail Sale Id 99',3451.00,0.00,0.00,5.95,351.05,'2022-03-07 17:22:46','',''),(85,'1','223','1',1,'Retail Sale Id 100',2900.00,0.00,0.00,5.00,295.00,'2022-03-07 17:24:51','',''),(86,'1','223','1',1,'Retail Sale Id 101',1751.60,0.00,0.00,3.02,178.18,'2022-03-07 17:26:51','',''),(87,'1','223','1',1,'Retail Sale Id 102',1751.60,0.00,0.00,3.02,178.18,'2022-03-07 17:33:15','',''),(88,'1','223','1',1,'Retail Sale Id 103',2349.00,0.00,0.00,4.05,238.95,'2022-03-07 17:34:41','',''),(89,'1','223','1',1,'Retail Sale Id 104',1200.60,0.00,0.00,2.07,122.13,'2022-03-07 17:35:51','',''),(90,'1','223','1',1,'Retail Sale Id 105',2349.00,0.00,0.00,4.05,238.95,'2022-03-07 17:39:29','',''),(91,'1','223','1',1,'Retail Sale Id 106',1200.60,0.00,0.00,2.07,122.13,'2022-03-07 17:46:52','',''),(92,'1','223','1',1,'Retail Sale Id 107',1502.20,0.00,0.00,2.59,152.81,'2022-03-07 17:51:06','',''),(93,'1','223','1',1,'Return of Retail Sale Id 99',0.00,3451.00,5.95,0.00,-351.05,'2022-03-07 17:52:06','',''),(94,'1','223','1',1,'Retail Sale Id 108',3497.40,0.00,0.00,6.03,355.77,'2022-03-07 17:53:51','',''),(95,'1','223','1',1,'Retail Sale Id 109',3480.00,0.00,0.00,6.00,354.00,'2022-03-07 17:55:06','',''),(96,'1','223','1',1,'Retail Sale Id 110',3497.40,0.00,0.00,6.03,355.77,'2022-03-07 17:59:15','',''),(97,'1','223','1',1,'Retail Sale Id 111',3497.40,0.00,0.00,6.03,355.77,'2022-03-07 18:00:50','',''),(98,'1','223','1',1,'Retail Sale Id 112',2320.00,0.00,0.00,4.00,236.00,'2022-03-07 18:05:21','',''),(99,'1','223','1',1,'Retail Sale Id 113',1160.00,0.00,0.00,2.00,118.00,'2022-03-07 18:26:38','',''),(100,'1','223','1',1,'Retail Sale Id 114',1160.00,0.00,0.00,2.00,118.00,'2022-03-07 18:33:05','',''),(101,'1','223','1',1,'Retail Sale Id 115',2900.00,0.00,0.00,5.00,295.00,'2022-03-07 18:34:19','',''),(102,'1','223','1',1,'Retail Sale Id 116',1699.40,0.00,0.00,2.93,172.87,'2022-03-07 18:38:10','',''),(103,'1','223','1',1,'Retail Sale Id 117',2349.00,0.00,0.00,4.05,238.95,'2022-03-07 18:43:54','',''),(104,'1','223','1',1,'Retail Sale Id 118',1502.20,0.00,0.00,2.59,152.81,'2022-03-07 18:45:10','',''),(105,'1','223','1',1,'Retail Sale Id 119',2349.00,0.00,0.00,4.05,238.95,'2022-03-07 18:50:18','',''),(106,'1','223','1',1,'Retail Sale Id 120',1200.60,0.00,0.00,2.07,122.13,'2022-03-07 18:59:58','',''),(107,'1','223','1',1,'Retail Sale Id 121',7250.00,0.00,0.00,12.50,737.50,'2022-03-07 19:07:20','',''),(108,'1','223','1',1,'Retail Sale Id 122',597.40,0.00,0.00,1.03,60.77,'2022-03-07 19:11:31','',''),(109,'1','223','1',1,'Retail Sale Id 123',1160.00,0.00,0.00,2.00,118.00,'2022-03-07 19:14:28','',''),(110,'1','223','1',1,'Retail Sale Id 124',7250.00,0.00,0.00,12.50,737.50,'2022-03-08 07:18:59','',''),(111,'1','223','1',1,'Retail Sale Id 125',2900.00,0.00,0.00,5.00,295.00,'2022-03-08 07:40:34','',''),(112,'1','223','1',1,'Retail Sale Id 126',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 07:48:16','',''),(113,'1','223','1',1,'Retail Sale Id 127',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 08:25:06','',''),(114,'1','223','1',1,'Retail Sale Id 129',1200.60,0.00,0.00,2.07,122.13,'2022-03-08 08:39:32','',''),(115,'1','223','1',1,'Retail Sale Id 130',0.00,0.00,0.00,535.00,-278735.00,'2022-03-08 08:49:47','',''),(116,'1','223','1',1,'Retail Sale Id 131',597.40,0.00,0.00,1.03,60.77,'2022-03-08 08:51:13','',''),(117,'1','223','1',1,'Retail Sale Id 132',29425.00,0.00,0.00,55.00,770.00,'2022-03-08 08:54:11','',''),(118,'1','223','1',1,'Retail Sale Id 133',1200.60,0.00,0.00,2.07,122.13,'2022-03-08 09:05:55','',''),(119,'1','223','1',1,'Retail Sale Id 134',1200.60,0.00,0.00,2.07,122.13,'2022-03-08 09:06:45','',''),(120,'1','223','1',1,'Retail Sale Id 135',1200.60,0.00,0.00,2.07,122.13,'2022-03-08 09:56:56','',''),(121,'1','223','1',1,'Retail Sale Id 136',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 09:58:18','',''),(122,'1','223','1',1,'Retail Sale Id 137',53500.00,0.00,0.00,100.00,1400.00,'2022-03-08 10:02:15','',''),(123,'1','223','1',1,'Retail Sale Id 138',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 10:08:14','',''),(124,'1','223','1',1,'Retail Sale Id 139',1200.60,0.00,0.00,2.07,122.13,'2022-03-08 10:33:05','',''),(125,'1','223','1',1,'Retail Sale Id 140',1200.60,0.00,0.00,2.07,122.13,'2022-03-08 10:36:31','',''),(126,'1','223','1',1,'Retail Sale Id 141',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 10:37:30','',''),(127,'1','223','1',1,'Retail Sale Id 142',80250.00,0.00,0.00,150.00,2100.00,'2022-03-08 10:51:11','',''),(128,'1','223','1',1,'Retail Sale Id 143',1160.00,0.00,0.00,2.00,118.00,'2022-03-08 11:37:57','',''),(129,'1','223','1',1,'Retail Sale Id 144',3480.00,0.00,0.00,6.00,354.00,'2022-03-08 11:41:55','',''),(130,'1','223','1',1,'Retail Sale Id 145',1740.00,0.00,0.00,3.00,177.00,'2022-03-08 11:43:44','',''),(131,'1','223','1',1,'Retail Sale Id 146',3480.00,0.00,0.00,6.00,354.00,'2022-03-08 11:52:59','',''),(132,'1','223','1',1,'Retail Sale Id 147',2900.00,0.00,0.00,5.00,295.00,'2022-03-08 11:57:59','',''),(133,'1','223','1',1,'Retail Sale Id 149',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 12:10:57','',''),(134,'1','223','1',1,'Retail Sale Id 150',1200.60,0.00,0.00,2.07,122.13,'2022-03-08 12:11:51','',''),(135,'1','223','1',1,'Retail Sale Id 151',2900.00,0.00,0.00,5.00,295.00,'2022-03-08 12:48:35','',''),(136,'1','223','1',1,'Retail Sale Id 152',7250.00,0.00,0.00,12.50,737.50,'2022-03-08 13:04:49','',''),(137,'1','223','1',1,'Retail Sale Id 153',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 14:42:23','',''),(138,'1','223','1',1,'Retail Sale Id 154',1200.60,0.00,0.00,2.07,122.13,'2022-03-08 15:01:21','',''),(139,'1','223','1',1,'Retail Sale Id 155',597.40,0.00,0.00,1.03,60.77,'2022-03-08 15:34:46','',''),(140,'1','223','1',1,'Retail Sale Id 156',597.40,0.00,0.00,1.03,60.77,'2022-03-08 15:41:30','',''),(141,'1','223','1',1,'Retail Sale Id 157',29425.00,0.00,0.00,55.00,770.00,'2022-03-08 16:09:44','',''),(142,'1','223','1',1,'Retail Sale Id 158',3497.40,0.00,0.00,6.03,355.77,'2022-03-08 16:14:11','',''),(143,'1','223','1',1,'Retail Sale Id 159',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 16:50:46','',''),(144,'1','223','1',1,'Retail Sale Id 160',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 16:58:21','',''),(145,'1','223','1',1,'Retail Sale Id 161',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 17:14:31','',''),(146,'1','223','1',1,'Retail Sale Id 162',2320.00,0.00,0.00,4.00,236.00,'2022-03-08 17:20:53','',''),(147,'1','223','1',1,'Retail Sale Id 163',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 17:35:15','',''),(148,'1','223','1',1,'Retail Sale Id 164',26001.00,0.00,0.00,48.60,680.40,'2022-03-08 17:50:37','',''),(149,'1','223','1',1,'Retail Sale Id 165',1200.60,0.00,0.00,2.07,122.13,'2022-03-08 17:59:56','',''),(150,'1','223','1',1,'Retail Sale Id 166',1200.60,0.00,0.00,2.07,122.13,'2022-03-08 18:06:13','',''),(151,'1','223','1',1,'Retail Sale Id 167',597.40,0.00,0.00,1.03,60.77,'2022-03-08 18:18:23','',''),(152,'1','223','1',1,'Retail Sale Id 168',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 18:22:00','',''),(153,'1','223','1',1,'Retail Sale Id 169',2900.00,0.00,0.00,5.00,295.00,'2022-03-08 18:24:58','',''),(154,'1','223','1',1,'Retail Sale Id 170',3480.00,0.00,0.00,6.00,354.00,'2022-03-08 18:26:05','',''),(155,'1','223','1',1,'Retail Sale Id 171',3480.00,0.00,0.00,6.00,354.00,'2022-03-08 18:28:18','',''),(156,'1','223','1',1,'Retail Sale Id 172',3480.00,0.00,0.00,6.00,354.00,'2022-03-08 18:28:57','',''),(157,'1','223','1',1,'Retail Sale Id 173',1751.60,0.00,0.00,3.02,178.18,'2022-03-08 18:31:13','',''),(158,'1','223','1',1,'Retail Sale Id 174',2320.00,0.00,0.00,4.00,236.00,'2022-03-08 18:34:19','',''),(159,'1','223','1',1,'Retail Sale Id 175',283282.50,0.00,0.00,529.50,7413.00,'2022-03-08 20:17:55','',''),(160,'1','223','1',1,'Retail Sale Id 176',3497.40,0.00,0.00,6.03,355.77,'2022-03-10 07:18:43','',''),(161,'1','223','1',1,'Retail Sale Id 177',48150.00,0.00,0.00,90.00,1260.00,'2022-03-10 07:21:13','',''),(162,'1','223','1',1,'Retail Sale Id 180',3497.40,0.00,0.00,6.03,355.77,'2022-03-10 07:22:48','',''),(163,'1','223','1',1,'Retail Sale Id 181',59438.40,0.00,0.00,102.48,6046.32,'2022-03-10 07:25:10','',''),(164,'1','223','1',1,'Retail Sale Id 182',3497.40,0.00,0.00,6.03,355.77,'2022-03-10 07:47:24','',''),(165,'1','223','1',1,'Retail Sale Id 183',3497.40,0.00,0.00,6.03,355.77,'2022-03-10 08:10:56','',''),(166,'1','223','1',1,'Retail Sale Id 184',1751.60,0.00,0.00,3.02,178.18,'2022-03-10 08:25:44','',''),(167,'1','223','1',1,'Retail Sale Id 185',1200.60,0.00,0.00,2.07,122.13,'2022-03-10 09:03:43','',''),(168,'1','223','1',1,'Retail Sale Id 186',1200.60,0.00,0.00,2.07,122.13,'2022-03-10 09:10:25','',''),(169,'1','223','1',1,'Retail Sale Id 187',1751.60,0.00,0.00,3.02,178.18,'2022-03-10 09:12:16','',''),(170,'1','223','1',1,'Retail Sale Id 189',7250.00,0.00,0.00,12.50,737.50,'2022-03-10 09:21:55','',''),(171,'1','223','1',1,'Retail Sale Id 190',3497.40,0.00,0.00,6.03,355.77,'2022-03-10 09:32:56','',''),(172,'1','223','1',1,'Retail Sale Id 191',3497.40,0.00,0.00,6.03,355.77,'2022-03-10 10:20:32','',''),(173,'1','223','1',1,'Retail Sale Id 192',1751.60,0.00,0.00,3.02,178.18,'2022-03-10 10:46:49','',''),(174,'1','223','1',1,'Retail Sale Id 193',3497.40,0.00,0.00,6.03,355.77,'2022-03-10 11:02:03','',''),(175,'1','223','1',1,'Retail Sale Id 194',7250.00,0.00,0.00,12.50,737.50,'2022-03-10 11:59:31','',''),(176,'1','223','1',1,'Retail Sale Id 195',2320.00,0.00,0.00,4.00,236.00,'2022-03-10 12:00:45','',''),(177,'1','223','1',1,'Retail Sale Id 196',2900.00,0.00,0.00,5.00,295.00,'2022-03-10 12:12:17','',''),(178,'1','223','1',1,'Retail Sale Id 197',1751.60,0.00,0.00,3.02,178.18,'2022-03-10 12:20:21','',''),(179,'1','223','1',1,'Retail Sale Id 198',2349.00,0.00,0.00,4.05,238.95,'2022-03-10 12:54:22','',''),(180,'1','223','1',1,'Retail Sale Id 199',1200.60,0.00,0.00,2.07,122.13,'2022-03-10 12:58:01','',''),(181,'1','223','1',1,'Retail Sale Id 200',58850.00,0.00,0.00,110.00,1540.00,'2022-03-10 13:29:43','',''),(182,'1','223','1',1,'Retail Sale Id 201',597.40,0.00,0.00,1.03,60.77,'2022-03-10 13:59:06','',''),(183,'1','223','1',1,'Retail Sale Id 202',1751.60,0.00,0.00,3.02,178.18,'2022-03-10 14:20:57','',''),(184,'1','223','1',1,'Retail Sale Id 203',2900.00,0.00,0.00,5.00,295.00,'2022-03-10 15:03:56','',''),(185,'1','223','1',1,'Retail Sale Id 204',26750.00,0.00,0.00,50.00,700.00,'2022-03-10 15:28:33','',''),(186,'1','223','1',1,'Retail Sale Id 205',1200.60,0.00,0.00,2.07,122.13,'2022-03-10 15:32:15','',''),(187,'1','223','1',1,'Retail Sale Id 206',1740.00,0.00,0.00,3.00,177.00,'2022-03-10 15:40:46','',''),(188,'1','223','1',1,'Retail Sale Id 207',1751.60,0.00,0.00,3.02,178.18,'2022-03-10 15:45:14','',''),(189,'1','223','1',1,'Retail Sale Id 208',3480.00,0.00,0.00,6.00,354.00,'2022-03-10 15:46:41','',''),(190,'1','223','1',1,'Retail Sale Id 209',26750.00,0.00,0.00,50.00,700.00,'2022-03-10 16:03:30','',''),(191,'1','223','1',1,'Retail Sale Id 210',2001.00,0.00,0.00,3.45,203.55,'2022-03-10 16:07:59','',''),(192,'1','223','1',1,'Retail Sale Id 211',2320.00,0.00,0.00,4.00,236.00,'2022-03-10 16:34:36','',''),(193,'1','223','1',1,'Retail Sale Id 212',1751.60,0.00,0.00,3.02,178.18,'2022-03-10 16:39:48','',''),(194,'1','223','1',1,'Retail Sale Id 213',1160.00,0.00,0.00,2.00,118.00,'2022-03-10 16:41:57','',''),(195,'1','223','1',1,'Retail Sale Id 214',2900.00,0.00,0.00,5.00,295.00,'2022-03-10 16:43:14','',''),(196,'1','223','1',1,'Retail Sale Id 215',2349.00,0.00,0.00,4.05,238.95,'2022-03-10 16:50:03','',''),(197,'1','223','1',1,'Retail Sale Id 216',1751.60,0.00,0.00,3.02,178.18,'2022-03-10 16:51:21','',''),(198,'1','223','1',1,'Retail Sale Id 217',3480.00,0.00,0.00,6.00,354.00,'2022-03-10 16:58:46','',''),(199,'1','223','1',1,'Retail Sale Id 218',1200.60,0.00,0.00,2.07,122.13,'2022-03-10 17:19:03','',''),(200,'1','223','1',1,'Retail Sale Id 219',26750.00,0.00,0.00,50.00,700.00,'2022-03-10 17:29:35','',''),(201,'1','223','1',1,'Retail Sale Id 225',2320.00,0.00,0.00,4.00,236.00,'2022-03-10 17:35:01','',''),(202,'1','223','1',1,'Retail Sale Id 227',2900.00,0.00,0.00,5.00,295.00,'2022-03-10 17:42:03','',''),(203,'1','223','1',1,'Retail Sale Id 228',1200.60,0.00,0.00,2.07,122.13,'2022-03-10 17:51:37','',''),(204,'1','223','1',1,'Retail Sale Id 230',1160.00,0.00,0.00,2.00,118.00,'2022-03-10 17:54:36','',''),(205,'1','223','1',1,'Retail Sale Id 231',997.60,0.00,0.00,1.72,101.48,'2022-03-10 18:03:16','',''),(206,'1','223','1',1,'Retail Sale Id 232',2320.00,0.00,0.00,4.00,236.00,'2022-03-10 18:05:20','',''),(207,'1','223','1',1,'Retail Sale Id 233',1751.60,0.00,0.00,3.02,178.18,'2022-03-10 18:06:25','',''),(208,'1','223','1',1,'Retail Sale Id 234',597.40,0.00,0.00,1.03,60.77,'2022-03-10 18:16:09','',''),(209,'1','223','1',1,'Retail Sale Id 237',597.40,0.00,0.00,1.03,60.77,'2022-03-10 18:35:30','',''),(210,'1','223','1',1,'Retail Sale Id 238',32100.00,0.00,0.00,60.00,840.00,'2022-03-10 18:51:12','',''),(211,'1','223','1',1,'Retail Sale Id 242',2900.00,0.00,0.00,5.00,295.00,'2022-03-10 18:56:01','',''),(212,'1','223','1',1,'Retail Sale Id 243',1740.00,0.00,0.00,3.00,177.00,'2022-03-11 07:55:01','',''),(213,'1','223','1',1,'Retail Sale Id 244',3480.00,0.00,0.00,6.00,354.00,'2022-03-11 08:26:31','',''),(214,'1','223','1',1,'Retail Sale Id 245',3497.40,0.00,0.00,6.03,355.77,'2022-03-11 08:35:45','',''),(215,'1','223','1',1,'Retail Sale Id 246',3480.00,0.00,0.00,6.00,354.00,'2022-03-11 08:39:12','',''),(216,'1','223','1',1,'Retail Sale Id 247',1740.00,0.00,0.00,3.00,177.00,'2022-03-11 08:39:49','',''),(217,'1','223','1',1,'Retail Sale Id 248',1160.00,0.00,0.00,2.00,118.00,'2022-03-11 08:40:26','',''),(218,'1','223','1',1,'Retail Sale Id 249',3497.40,0.00,0.00,6.03,355.77,'2022-03-11 08:41:17','',''),(219,'1','223','1',1,'Retail Sale Id 250',1160.00,0.00,0.00,2.00,118.00,'2022-03-11 08:52:26','',''),(220,'1','223','1',1,'Retail Sale Id 251',1200.60,0.00,0.00,2.07,122.13,'2022-03-11 08:53:10','',''),(221,'1','223','1',1,'Retail Sale Id 252',3480.00,0.00,0.00,6.00,354.00,'2022-03-11 09:00:13','',''),(222,'1','223','1',1,'Retail Sale Id 254',3480.00,0.00,0.00,6.00,354.00,'2022-03-11 09:21:10','',''),(223,'1','223','1',1,'Retail Sale Id 255',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 09:22:30','',''),(224,'1','223','1',1,'Retail Sale Id 256',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 09:31:04','',''),(225,'1','223','1',1,'Retail Sale Id 257',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 09:33:34','',''),(226,'1','223','1',1,'Retail Sale Id 258',2900.00,0.00,0.00,5.00,295.00,'2022-03-11 09:40:25','',''),(227,'1','223','1',1,'Retail Sale Id 259',2001.00,0.00,0.00,3.45,203.55,'2022-03-11 09:43:51','',''),(228,'1','223','1',1,'Retail Sale Id 260',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 09:50:58','',''),(229,'1','223','1',1,'Retail Sale Id 261',2900.00,0.00,0.00,5.00,295.00,'2022-03-11 10:01:25','',''),(230,'1','223','1',1,'Retail Sale Id 262',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 10:57:41','',''),(231,'1','223','1',1,'Retail Sale Id 263',2320.00,0.00,0.00,4.00,236.00,'2022-03-11 11:09:25','',''),(232,'1','223','1',1,'Retail Sale Id 264',86937.50,0.00,0.00,162.50,2275.00,'2022-03-11 11:35:39','',''),(233,'1','223','1',1,'Return of Retail Sale Id 264',0.00,86937.50,162.50,0.00,-2275.00,'2022-03-11 11:56:14','',''),(234,'1','223','1',1,'Retail Sale Id 265',46812.50,0.00,0.00,87.50,1225.00,'2022-03-11 11:57:11','',''),(235,'1','223','1',1,'Retail Sale Id 266',40125.00,0.00,0.00,75.00,1050.00,'2022-03-11 11:58:33','',''),(236,'1','223','1',1,'Retail Sale Id 267',7250.00,0.00,0.00,12.50,737.50,'2022-03-11 12:00:15','',''),(237,'1','223','1',1,'Retail Sale Id 268',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 12:54:59','',''),(238,'1','223','1',1,'Retail Sale Id 269',1200.60,0.00,0.00,2.07,122.13,'2022-03-11 13:00:04','',''),(239,'1','223','1',1,'Retail Sale Id 271',2900.00,0.00,0.00,5.00,295.00,'2022-03-11 13:00:51','',''),(240,'1','223','1',1,'Retail Sale Id 272',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 14:21:31','',''),(241,'1','223','1',1,'Retail Sale Id 273',3480.00,0.00,0.00,6.00,354.00,'2022-03-11 14:58:52','',''),(242,'1','223','1',1,'Retail Sale Id 274',2900.00,0.00,0.00,5.00,295.00,'2022-03-11 15:09:10','',''),(243,'1','223','1',1,'Retail Sale Id 275',597.40,0.00,0.00,1.03,60.77,'2022-03-11 15:22:09','',''),(244,'1','223','1',1,'Retail Sale Id 276',597.40,0.00,0.00,1.03,60.77,'2022-03-11 15:24:12','',''),(245,'1','223','1',1,'Retail Sale Id 277',597.40,0.00,0.00,1.03,60.77,'2022-03-11 15:30:38','',''),(246,'1','223','1',1,'Retail Sale Id 279',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 15:52:10','',''),(247,'1','223','1',1,'Retail Sale Id 280',597.40,0.00,0.00,1.03,60.77,'2022-03-11 16:23:22','',''),(248,'1','223','1',1,'Retail Sale Id 281',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 16:25:46','',''),(249,'1','223','1',1,'Retail Sale Id 282',3497.40,0.00,0.00,6.03,355.77,'2022-03-11 16:28:38','',''),(250,'1','223','1',1,'Retail Sale Id 283',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 16:31:50','',''),(251,'1','223','1',1,'Retail Sale Id 284',1740.00,0.00,0.00,3.00,177.00,'2022-03-11 16:36:17','',''),(252,'1','223','1',1,'Retail Sale Id 285',1160.00,0.00,0.00,2.00,118.00,'2022-03-11 16:37:23','',''),(253,'1','223','1',1,'Retail Sale Id 286',3497.40,0.00,0.00,6.03,355.77,'2022-03-11 16:43:18','',''),(254,'1','223','1',1,'Retail Sale Id 287',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 16:53:46','',''),(255,'1','223','1',1,'Retail Sale Id 288',1740.00,0.00,0.00,3.00,177.00,'2022-03-11 17:12:36','',''),(256,'1','223','1',1,'Retail Sale Id 289',1200.60,0.00,0.00,2.07,122.13,'2022-03-11 17:18:53','',''),(257,'1','223','1',1,'Retail Sale Id 291',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 17:21:49','',''),(258,'1','223','1',1,'Retail Sale Id 292',1200.60,0.00,0.00,2.07,122.13,'2022-03-11 17:24:09','',''),(259,'1','223','1',1,'Retail Sale Id 293',2349.00,0.00,0.00,4.05,238.95,'2022-03-11 17:26:09','',''),(260,'1','223','1',1,'Retail Sale Id 294',1200.60,0.00,0.00,2.07,122.13,'2022-03-11 17:36:05','',''),(261,'1','223','1',1,'Retail Sale Id 295',1200.60,0.00,0.00,2.07,122.13,'2022-03-11 18:01:05','',''),(262,'1','223','1',1,'Retail Sale Id 296',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 18:13:00','',''),(263,'1','223','1',1,'Retail Sale Id 297',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 18:34:12','',''),(264,'1','223','1',1,'Retail Sale Id 299',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 18:38:34','',''),(265,'1','223','1',1,'Retail Sale Id 300',2900.00,0.00,0.00,5.00,295.00,'2022-03-11 18:42:29','',''),(266,'1','223','1',1,'Retail Sale Id 302',1740.00,0.00,0.00,3.00,177.00,'2022-03-11 18:46:28','',''),(267,'1','223','1',1,'Retail Sale Id 303',1751.60,0.00,0.00,3.02,178.18,'2022-03-11 18:49:46','',''),(268,'1','223','1',1,'Retail Sale Id 304',2349.00,0.00,0.00,4.05,238.95,'2022-03-12 07:24:57','',''),(269,'1','223','1',1,'Retail Sale Id 305',5997.20,0.00,0.00,10.34,610.06,'2022-03-12 07:28:13','',''),(270,'1','223','1',1,'Retail Sale Id 306',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 08:05:46','',''),(271,'1','223','1',1,'Retail Sale Id 307',1102.00,0.00,0.00,1.90,112.10,'2022-03-12 08:20:58','',''),(272,'1','223','1',1,'Retail Sale Id 308',1699.40,0.00,0.00,2.93,172.87,'2022-03-12 08:30:59','',''),(273,'1','223','1',1,'Retail Sale Id 309',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 08:35:42','',''),(274,'1','223','1',1,'Retail Sale Id 310',1740.00,0.00,0.00,3.00,177.00,'2022-03-12 08:37:17','',''),(275,'1','223','1',1,'Retail Sale Id 311',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 08:38:59','',''),(276,'1','223','1',1,'Retail Sale Id 312',4060.00,0.00,0.00,7.00,413.00,'2022-03-12 08:40:20','',''),(277,'1','223','1',1,'Retail Sale Id 313',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 08:41:47','',''),(278,'1','223','1',1,'Retail Sale Id 314',2349.00,0.00,0.00,4.05,238.95,'2022-03-12 08:44:09','',''),(279,'1','223','1',1,'Retail Sale Id 315',28890.00,0.00,0.00,54.00,756.00,'2022-03-12 08:47:00','',''),(280,'1','223','1',1,'Retail Sale Id 316',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 08:47:30','',''),(281,'1','223','1',1,'Retail Sale Id 318',7250.00,0.00,0.00,12.50,737.50,'2022-03-12 08:49:36','',''),(282,'1','223','1',1,'Retail Sale Id 319',3497.40,0.00,0.00,6.03,355.77,'2022-03-12 08:50:24','',''),(283,'1','223','1',1,'Retail Sale Id 320',1740.00,0.00,0.00,3.00,177.00,'2022-03-12 08:51:24','',''),(284,'1','223','1',1,'Retail Sale Id 321',6960.00,0.00,0.00,12.00,708.00,'2022-03-12 08:52:51','',''),(285,'1','223','1',1,'Retail Sale Id 322',2900.00,0.00,0.00,5.00,295.00,'2022-03-12 08:54:46','',''),(286,'1','223','1',1,'Retail Sale Id 323',1200.60,0.00,0.00,2.07,122.13,'2022-03-12 08:55:12','',''),(287,'1','223','1',1,'Retail Sale Id 325',4640.00,0.00,0.00,8.00,472.00,'2022-03-12 09:01:00','',''),(288,'1','223','1',1,'Retail Sale Id 328',3480.00,0.00,0.00,6.00,354.00,'2022-03-12 09:04:33','',''),(289,'1','223','1',1,'Retail Sale Id 329',2001.00,0.00,0.00,3.45,203.55,'2022-03-12 09:19:24','',''),(290,'1','223','1',1,'Retail Sale Id 330',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 09:21:35','',''),(291,'1','223','1',1,'Retail Sale Id 331',1502.20,0.00,0.00,2.59,152.81,'2022-03-12 09:24:06','',''),(292,'1','223','1',1,'Retail Sale Id 332',1200.60,0.00,0.00,2.07,122.13,'2022-03-12 09:48:03','',''),(293,'1','223','1',1,'Retail Sale Id 333',580.00,0.00,0.00,1.00,59.00,'2022-03-12 09:53:14','',''),(294,'1','223','1',1,'Retail Sale Id 334',580.00,0.00,0.00,1.00,59.00,'2022-03-12 09:55:27','',''),(295,'1','223','1',1,'Retail Sale Id 335',580.00,0.00,0.00,1.00,59.00,'2022-03-12 09:58:25','',''),(296,'1','223','1',1,'Retail Sale Id 336',597.40,0.00,0.00,1.03,60.77,'2022-03-12 09:59:54','',''),(297,'1','223','1',1,'Retail Sale Id 337',3497.40,0.00,0.00,6.03,355.77,'2022-03-12 10:12:05','',''),(298,'1','223','1',1,'Retail Sale Id 338',4999.60,0.00,0.00,8.62,508.58,'2022-03-12 10:20:53','',''),(299,'1','223','1',1,'Retail Sale Id 339',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 10:28:43','',''),(300,'1','223','1',1,'Retail Sale Id 342',1740.00,0.00,0.00,3.00,177.00,'2022-03-12 10:49:42','',''),(301,'1','223','1',1,'Retail Sale Id 345',1502.20,0.00,0.00,2.59,152.81,'2022-03-12 10:53:53','',''),(302,'1','223','1',1,'Retail Sale Id 346',1200.60,0.00,0.00,2.07,122.13,'2022-03-12 11:41:38','',''),(303,'1','223','1',1,'Retail Sale Id 347',2320.00,0.00,0.00,4.00,236.00,'2022-03-12 11:45:40','',''),(304,'1','223','1',1,'Retail Sale Id 348',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 11:47:36','',''),(305,'1','223','1',1,'Retail Sale Id 349',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 11:48:40','',''),(306,'1','223','1',1,'Retail Sale Id 350',2349.00,0.00,0.00,4.05,238.95,'2022-03-12 11:52:45','',''),(307,'1','223','1',1,'Retail Sale Id 351',155150.00,0.00,0.00,290.00,4060.00,'2022-03-12 11:56:42','',''),(308,'1','223','1',1,'Retail Sale Id 352',187565.65,0.00,0.00,350.59,4908.26,'2022-03-12 11:58:29','',''),(309,'1','223','1',1,'Retail Sale Id 353',1200.60,0.00,0.00,2.07,122.13,'2022-03-12 12:06:28','',''),(310,'1','223','1',1,'Retail Sale Id 354',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 12:09:31','',''),(311,'1','223','1',1,'Retail Sale Id 355',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 12:22:28','',''),(312,'1','223','1',1,'Retail Sale Id 356',3480.00,0.00,0.00,6.00,354.00,'2022-03-12 12:56:29','',''),(313,'1','223','1',1,'Retail Sale Id 357',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 12:57:44','',''),(314,'1','223','1',1,'Retail Sale Id 358',3497.40,0.00,0.00,6.03,355.77,'2022-03-12 13:09:24','',''),(315,'1','223','1',1,'Retail Sale Id 359',2001.00,0.00,0.00,3.45,203.55,'2022-03-12 13:20:41','',''),(316,'1','223','1',1,'Retail Sale Id 360',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 13:40:51','',''),(317,'1','223','1',1,'Retail Sale Id 361',7250.00,0.00,0.00,12.50,737.50,'2022-03-12 14:09:19','',''),(318,'1','223','1',1,'Retail Sale Id 362',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 14:11:40','',''),(319,'1','223','1',1,'Retail Sale Id 363',1160.00,0.00,0.00,2.00,118.00,'2022-03-12 14:25:23','',''),(320,'1','223','1',1,'Retail Sale Id 364',2900.00,0.00,0.00,5.00,295.00,'2022-03-12 14:35:12','',''),(321,'1','223','1',1,'Return of Retail Sale Id 364',0.00,2900.00,5.00,0.00,-295.00,'2022-03-12 14:35:37','',''),(322,'1','223','1',1,'Retail Sale Id 365',3497.40,0.00,0.00,6.03,355.77,'2022-03-12 14:36:21','',''),(323,'1','223','1',1,'Retail Sale Id 366',1160.00,0.00,0.00,2.00,118.00,'2022-03-12 14:38:05','',''),(324,'1','223','1',1,'Retail Sale Id 367',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 15:18:20','',''),(325,'1','223','1',1,'Retail Sale Id 368',3480.00,0.00,0.00,6.00,354.00,'2022-03-12 15:25:18','',''),(326,'1','223','1',1,'Retail Sale Id 369',2320.00,0.00,0.00,4.00,236.00,'2022-03-12 15:29:37','',''),(327,'1','223','1',1,'Retail Sale Id 370',580.00,0.00,0.00,1.00,59.00,'2022-03-12 15:32:19','',''),(328,'1','223','1',1,'Retail Sale Id 372',1148.40,0.00,0.00,1.98,116.82,'2022-03-12 15:46:31','',''),(329,'1','223','1',1,'Retail Sale Id 373',2900.00,0.00,0.00,5.00,295.00,'2022-03-12 16:04:09','',''),(330,'1','223','1',1,'Retail Sale Id 376',2900.00,0.00,0.00,5.00,295.00,'2022-03-12 16:08:39','',''),(331,'1','223','1',1,'Retail Sale Id 377',1200.60,0.00,0.00,2.07,122.13,'2022-03-12 16:28:22','',''),(332,'1','223','1',1,'Retail Sale Id 378',997.60,0.00,0.00,1.72,101.48,'2022-03-12 16:43:17','',''),(333,'1','223','1',1,'Retail Sale Id 379',2320.00,0.00,0.00,4.00,236.00,'2022-03-12 16:48:01','',''),(334,'1','223','1',1,'Retail Sale Id 380',4999.60,0.00,0.00,8.62,508.58,'2022-03-12 16:49:48','',''),(335,'1','223','1',1,'Retail Sale Id 381',3480.00,0.00,0.00,6.00,354.00,'2022-03-12 16:56:31','',''),(336,'1','223','1',1,'Retail Sale Id 383',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 17:02:06','',''),(337,'1','223','1',1,'Retail Sale Id 384',3480.00,0.00,0.00,6.00,354.00,'2022-03-12 17:04:14','',''),(338,'1','223','1',1,'Retail Sale Id 386',1740.00,0.00,0.00,3.00,177.00,'2022-03-12 17:15:35','',''),(339,'1','223','1',1,'Retail Sale Id 387',7250.00,0.00,0.00,12.50,737.50,'2022-03-12 17:18:15','',''),(340,'1','223','1',1,'Retail Sale Id 388',1160.00,0.00,0.00,2.00,118.00,'2022-03-12 17:19:19','',''),(341,'1','223','1',1,'Retail Sale Id 389',1740.00,0.00,0.00,3.00,177.00,'2022-03-12 17:32:05','',''),(342,'1','223','1',1,'Retail Sale Id 391',3497.40,0.00,0.00,6.03,355.77,'2022-03-12 17:40:04','',''),(343,'1','223','1',1,'Retail Sale Id 392',1740.00,0.00,0.00,3.00,177.00,'2022-03-12 17:41:59','',''),(344,'1','223','1',1,'Retail Sale Id 393',997.60,0.00,0.00,1.72,101.48,'2022-03-12 17:43:07','',''),(345,'1','223','1',1,'Retail Sale Id 394',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 17:45:03','',''),(346,'1','223','1',1,'Retail Sale Id 395',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 17:50:13','',''),(347,'1','223','1',1,'Retail Sale Id 396',3480.00,0.00,0.00,6.00,354.00,'2022-03-12 18:03:00','',''),(348,'1','223','1',1,'Retail Sale Id 397',800.40,0.00,0.00,1.38,81.42,'2022-03-12 18:06:40','',''),(349,'1','223','1',1,'Retail Sale Id 398',1200.60,0.00,0.00,2.07,122.13,'2022-03-12 18:08:51','',''),(350,'1','223','1',1,'Retail Sale Id 399',1160.00,0.00,0.00,2.00,118.00,'2022-03-12 18:14:01','',''),(351,'1','223','1',1,'Retail Sale Id 400',2900.00,0.00,0.00,5.00,295.00,'2022-03-12 18:15:47','',''),(352,'1','223','1',1,'Retail Sale Id 401',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 18:15:51','',''),(353,'1','223','1',1,'Retail Sale Id 402',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 18:17:13','',''),(354,'1','223','1',1,'Retail Sale Id 403',1751.60,0.00,0.00,3.02,178.18,'2022-03-12 18:18:57','',''),(355,'1','223','1',1,'Retail Sale Id 404',2900.00,0.00,0.00,5.00,295.00,'2022-03-12 18:21:39','',''),(356,'1','223','1',1,'Retail Sale Id 405',597.40,0.00,0.00,1.03,60.77,'2022-03-12 18:33:06','',''),(357,'1','223','1',1,'Retail Sale Id 406',1200.60,0.00,0.00,2.07,122.13,'2022-03-12 18:35:40','',''),(358,'1','223','1',1,'Retail Sale Id 407',1200.60,0.00,0.00,2.07,122.13,'2022-03-12 18:37:22','',''),(359,'1','223','1',1,'Retail Sale Id 408',2001.00,0.00,0.00,3.45,203.55,'2022-03-12 18:43:04','',''),(360,'1','223','1',1,'Retail Sale Id 409',5249.00,0.00,0.00,9.05,533.95,'2022-03-12 18:45:19','',''),(361,'1','223','1',1,'Retail Sale Id 410',597.40,0.00,0.00,1.03,60.77,'2022-03-12 19:00:21','',''),(362,'1','223','1',1,'Retail Sale Id 411',580.00,0.00,0.00,1.00,59.00,'2022-03-12 19:32:04','',''),(363,'1','223','1',1,'Retail Sale Id 412',2320.00,0.00,0.00,4.00,236.00,'2022-03-13 07:22:47','',''),(364,'1','223','1',1,'Retail Sale Id 413',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 07:31:09','',''),(365,'1','223','1',1,'Retail Sale Id 415',7250.00,0.00,0.00,12.50,737.50,'2022-03-13 07:48:32','',''),(366,'1','223','1',1,'Retail Sale Id 416',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 08:01:32','',''),(367,'1','223','1',1,'Retail Sale Id 417',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 08:10:30','',''),(368,'1','223','1',1,'Retail Sale Id 418',1200.60,0.00,0.00,2.07,122.13,'2022-03-13 08:18:50','',''),(369,'1','223','1',1,'Retail Sale Id 419',1160.00,0.00,0.00,2.00,118.00,'2022-03-13 08:50:58','',''),(370,'1','223','1',1,'Retail Sale Id 420',1740.00,0.00,0.00,3.00,177.00,'2022-03-13 08:55:24','',''),(371,'1','223','1',1,'Retail Sale Id 421',6397.40,0.00,0.00,11.03,650.77,'2022-03-13 08:58:12','',''),(372,'1','223','1',1,'Retail Sale Id 422',997.60,0.00,0.00,1.72,101.48,'2022-03-13 09:02:29','',''),(373,'1','223','1',1,'Retail Sale Id 423',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 09:16:03','',''),(374,'1','223','1',1,'Retail Sale Id 424',2900.00,0.00,0.00,5.00,295.00,'2022-03-13 09:18:35','',''),(375,'1','223','1',1,'Retail Sale Id 425',1200.60,0.00,0.00,2.07,122.13,'2022-03-13 09:44:50','',''),(376,'1','223','1',1,'Retail Sale Id 426',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 09:49:18','',''),(377,'1','223','1',1,'Retail Sale Id 428',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 10:16:41','',''),(378,'1','223','1',1,'Retail Sale Id 429',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 10:21:12','',''),(379,'1','223','1',1,'Retail Sale Id 430',1740.00,0.00,0.00,3.00,177.00,'2022-03-13 10:39:02','',''),(380,'1','223','1',1,'Retail Sale Id 431',1160.00,0.00,0.00,2.00,118.00,'2022-03-13 10:56:57','',''),(381,'1','223','1',1,'Retail Sale Id 432',2900.00,0.00,0.00,5.00,295.00,'2022-03-13 11:21:28','',''),(382,'1','223','1',1,'Retail Sale Id 433',5800.00,0.00,0.00,10.00,590.00,'2022-03-13 11:26:18','',''),(383,'1','223','1',1,'Retail Sale Id 434',3480.00,0.00,0.00,6.00,354.00,'2022-03-13 11:29:31','',''),(384,'1','223','1',1,'Retail Sale Id 435',29425.00,0.00,0.00,55.00,770.00,'2022-03-13 11:34:10','',''),(385,'1','223','1',1,'Retail Sale Id 436',29425.00,0.00,0.00,55.00,770.00,'2022-03-13 11:35:51','',''),(386,'1','223','1',1,'Retail Sale Id 437',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 11:37:25','',''),(387,'1','223','1',1,'Retail Sale Id 438',4999.60,0.00,0.00,8.62,508.58,'2022-03-13 11:46:41','',''),(388,'1','223','1',1,'Retail Sale Id 439',2998.60,0.00,0.00,5.17,305.03,'2022-03-13 11:52:52','',''),(389,'1','223','1',1,'Retail Sale Id 440',7250.00,0.00,0.00,12.50,737.50,'2022-03-13 11:59:31','',''),(390,'1','223','1',1,'Retail Sale Id 441',1200.60,0.00,0.00,2.07,122.13,'2022-03-13 12:00:52','',''),(391,'1','223','1',1,'Retail Sale Id 442',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 12:13:53','',''),(392,'1','223','1',1,'Retail Sale Id 443',3497.40,0.00,0.00,6.03,355.77,'2022-03-13 12:22:39','',''),(393,'1','223','1',1,'Retail Sale Id 444',2001.00,0.00,0.00,3.45,203.55,'2022-03-13 12:32:25','',''),(394,'1','223','1',1,'Retail Sale Id 445',1200.60,0.00,0.00,2.07,122.13,'2022-03-13 12:36:48','',''),(395,'1','223','1',1,'Retail Sale Id 446',3480.00,0.00,0.00,6.00,354.00,'2022-03-13 12:38:05','',''),(396,'1','223','1',1,'Retail Sale Id 447',3497.40,0.00,0.00,6.03,355.77,'2022-03-13 12:49:46','',''),(397,'1','223','1',1,'Retail Sale Id 448',2900.00,0.00,0.00,5.00,295.00,'2022-03-13 12:51:32','',''),(398,'1','223','1',1,'Retail Sale Id 449',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 12:57:48','',''),(399,'1','223','1',1,'Retail Sale Id 450',1740.00,0.00,0.00,3.00,177.00,'2022-03-13 13:07:03','',''),(400,'1','223','1',1,'Retail Sale Id 451',1160.00,0.00,0.00,2.00,118.00,'2022-03-13 13:10:35','',''),(401,'1','223','1',1,'Retail Sale Id 452',2900.00,0.00,0.00,5.00,295.00,'2022-03-13 13:14:15','',''),(402,'1','223','1',1,'Retail Sale Id 453',1699.40,0.00,0.00,2.93,172.87,'2022-03-13 13:17:41','',''),(403,'1','223','1',1,'Retail Sale Id 454',2900.00,0.00,0.00,5.00,295.00,'2022-03-13 13:22:46','',''),(404,'1','223','1',1,'Retail Sale Id 455',2900.00,0.00,0.00,5.00,295.00,'2022-03-13 13:24:25','',''),(405,'1','223','1',1,'Retail Sale Id 456',3497.40,0.00,0.00,6.03,355.77,'2022-03-13 13:25:30','',''),(406,'1','223','1',1,'Retail Sale Id 457',2320.00,0.00,0.00,4.00,236.00,'2022-03-13 13:33:18','',''),(407,'1','223','1',1,'Retail Sale Id 458',1200.60,0.00,0.00,2.07,122.13,'2022-03-13 13:35:25','',''),(408,'1','223','1',1,'Retail Sale Id 459',7250.00,0.00,0.00,12.50,737.50,'2022-03-13 13:53:49','',''),(409,'1','223','1',1,'Retail Sale Id 460',3497.40,0.00,0.00,6.03,355.77,'2022-03-13 14:13:46','',''),(410,'1','223','1',1,'Retail Sale Id 461',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 14:16:03','',''),(411,'1','223','1',1,'Retail Sale Id 462',32100.00,0.00,0.00,60.00,840.00,'2022-03-13 14:22:09','',''),(412,'1','223','1',1,'Retail Sale Id 463',701.80,0.00,0.00,1.21,71.39,'2022-03-13 14:52:10','',''),(413,'1','223','1',1,'Retail Sale Id 464',3497.40,0.00,0.00,6.03,355.77,'2022-03-13 14:53:27','',''),(414,'1','223','1',1,'Retail Sale Id 465',3497.40,0.00,0.00,6.03,355.77,'2022-03-13 15:17:07','',''),(415,'1','223','1',1,'Retail Sale Id 466',2001.00,0.00,0.00,3.45,203.55,'2022-03-13 15:27:59','',''),(416,'1','223','1',1,'Retail Sale Id 467',498.80,0.00,0.00,0.86,50.74,'2022-03-13 15:29:41','',''),(417,'1','223','1',1,'Retail Sale Id 468',2499.80,0.00,0.00,4.31,254.29,'2022-03-13 16:06:45','',''),(418,'1','223','1',1,'Retail Sale Id 469',1740.00,0.00,0.00,3.00,177.00,'2022-03-13 16:13:51','',''),(419,'1','223','1',1,'Retail Sale Id 470',2900.00,0.00,0.00,5.00,295.00,'2022-03-13 16:26:22','',''),(420,'1','223','1',1,'Retail Sale Id 471',1200.60,0.00,0.00,2.07,122.13,'2022-03-13 16:31:35','',''),(421,'1','223','1',1,'Retail Sale Id 474',1740.00,0.00,0.00,3.00,177.00,'2022-03-13 16:40:11','',''),(422,'1','223','1',1,'Retail Sale Id 475',1160.00,0.00,0.00,2.00,118.00,'2022-03-13 16:41:11','',''),(423,'1','223','1',1,'Retail Sale Id 476',4002.00,0.00,0.00,6.90,407.10,'2022-03-13 17:12:02','',''),(424,'1','223','1',1,'Retail Sale Id 477',40125.00,0.00,0.00,75.00,1050.00,'2022-03-13 17:23:20','',''),(425,'1','223','1',1,'Retail Sale Id 478',1160.00,0.00,0.00,2.00,118.00,'2022-03-13 17:25:16','',''),(426,'1','223','1',1,'Retail Sale Id 479',7250.00,0.00,0.00,12.50,737.50,'2022-03-13 17:26:22','',''),(427,'1','223','1',1,'Retail Sale Id 480',2900.00,0.00,0.00,5.00,295.00,'2022-03-13 17:31:21','',''),(428,'1','223','1',1,'Retail Sale Id 481',1740.00,0.00,0.00,3.00,177.00,'2022-03-13 17:37:02','',''),(429,'1','223','1',1,'Retail Sale Id 482',1200.60,0.00,0.00,2.07,122.13,'2022-03-13 17:41:50','',''),(430,'1','223','1',1,'Retail Sale Id 483',1502.20,0.00,0.00,2.59,152.81,'2022-03-13 17:50:20','',''),(431,'1','223','1',1,'Retail Sale Id 484',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 17:52:50','',''),(432,'1','223','1',1,'Retail Sale Id 485',3480.00,0.00,0.00,6.00,354.00,'2022-03-13 17:56:26','',''),(433,'1','223','1',1,'Retail Sale Id 486',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 18:02:24','',''),(434,'1','223','1',1,'Retail Sale Id 487',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 18:20:41','',''),(435,'1','223','1',1,'Retail Sale Id 488',3300.20,0.00,0.00,5.69,335.71,'2022-03-13 18:33:17','',''),(436,'1','223','1',1,'Retail Sale Id 489',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 18:45:00','',''),(437,'1','223','1',1,'Retail Sale Id 490',997.60,0.00,0.00,1.72,101.48,'2022-03-13 18:52:34','',''),(438,'1','223','1',1,'Retail Sale Id 491',3497.40,0.00,0.00,6.03,355.77,'2022-03-13 18:59:49','',''),(439,'1','223','1',1,'Retail Sale Id 492',1751.60,0.00,0.00,3.02,178.18,'2022-03-13 19:00:30','',''),(440,'1','223','1',1,'Retail Sale Id 493',3497.40,0.00,0.00,6.03,355.77,'2022-03-14 07:32:00','',''),(441,'1','223','1',1,'Retail Sale Id 494',3497.40,0.00,0.00,6.03,355.77,'2022-03-14 07:44:05','',''),(442,'1','223','1',1,'Retail Sale Id 495',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 08:39:07','',''),(443,'1','223','1',1,'Retail Sale Id 496',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 08:53:57','',''),(444,'1','223','1',1,'Retail Sale Id 497',1502.20,0.00,0.00,2.59,152.81,'2022-03-14 09:30:05','',''),(445,'1','223','1',1,'Retail Sale Id 498',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 10:44:58','',''),(446,'1','223','1',1,'Retail Sale Id 499',2001.00,0.00,0.00,3.45,203.55,'2022-03-14 10:52:13','',''),(447,'1','223','1',1,'Retail Sale Id 500',4651.60,0.00,0.00,8.02,473.18,'2022-03-14 11:06:02','',''),(448,'1','223','1',1,'Retail Sale Id 501',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 11:13:26','',''),(449,'1','223','1',1,'Retail Sale Id 502',3497.40,0.00,0.00,6.03,355.77,'2022-03-14 11:33:50','',''),(450,'1','223','1',1,'Retail Sale Id 503',171200.00,0.00,0.00,320.00,4480.00,'2022-03-14 11:39:30','',''),(451,'1','223','1',1,'Retail Sale Id 504',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 11:48:38','',''),(452,'1','223','1',1,'Return of Retail Sale Id 503',0.00,171200.00,320.00,0.00,-4480.00,'2022-03-14 12:10:45','',''),(453,'1','223','1',1,'Retail Sale Id 506',60048.40,0.00,0.00,112.24,1571.36,'2022-03-14 12:12:05','',''),(454,'1','223','1',1,'Retail Sale Id 507',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 12:13:38','',''),(455,'1','223','1',1,'Retail Sale Id 508',53500.00,0.00,0.00,100.00,1400.00,'2022-03-14 12:15:24','',''),(456,'1','223','1',1,'Return of Retail Sale Id 506',0.00,60048.40,112.24,0.00,-1571.36,'2022-03-14 12:16:07','',''),(457,'1','223','1',1,'Retail Sale Id 509',117700.00,0.00,0.00,220.00,3080.00,'2022-03-14 12:17:06','',''),(458,'1','223','1',1,'Retail Sale Id 510',2900.00,0.00,0.00,5.00,295.00,'2022-03-14 12:40:22','',''),(459,'1','223','1',1,'Retail Sale Id 511',3497.40,0.00,0.00,6.03,355.77,'2022-03-14 12:57:32','',''),(460,'1','223','1',1,'Retail Sale Id 512',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 12:59:37','',''),(461,'1','223','1',1,'Retail Sale Id 513',3497.40,0.00,0.00,6.03,355.77,'2022-03-14 13:27:17','',''),(462,'1','223','1',1,'Retail Sale Id 514',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 13:31:39','',''),(463,'1','223','1',1,'Retail Sale Id 515',3497.40,0.00,0.00,6.03,355.77,'2022-03-14 13:32:37','',''),(464,'1','223','1',1,'Retail Sale Id 516',3480.00,0.00,0.00,6.00,354.00,'2022-03-14 13:39:04','',''),(465,'1','223','1',1,'Retail Sale Id 517',1740.00,0.00,0.00,3.00,177.00,'2022-03-14 13:41:31','',''),(466,'1','223','1',1,'Retail Sale Id 518',2320.00,0.00,0.00,4.00,236.00,'2022-03-14 13:42:48','',''),(467,'1','223','1',1,'Retail Sale Id 519',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 13:44:42','',''),(468,'1','223','1',1,'Retail Sale Id 520',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 13:46:46','',''),(469,'1','223','1',1,'Retail Sale Id 521',3497.40,0.00,0.00,6.03,355.77,'2022-03-14 13:52:14','',''),(470,'1','223','1',1,'Retail Sale Id 522',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 13:57:28','',''),(471,'1','223','1',1,'Retail Sale Id 523',2998.60,0.00,0.00,5.17,305.03,'2022-03-14 14:02:27','',''),(472,'1','223','1',1,'Retail Sale Id 524',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 14:21:19','',''),(473,'1','223','1',1,'Retail Sale Id 525',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 14:25:51','',''),(474,'1','223','1',1,'Retail Sale Id 526',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 14:32:07','',''),(475,'1','223','1',1,'Retail Sale Id 527',1502.20,0.00,0.00,2.59,152.81,'2022-03-14 14:38:55','',''),(476,'1','223','1',1,'Retail Sale Id 529',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 15:12:03','',''),(477,'1','223','1',1,'Retail Sale Id 530',597.40,0.00,0.00,1.03,60.77,'2022-03-14 15:24:35','',''),(478,'1','223','1',1,'Retail Sale Id 532',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 15:25:30','',''),(479,'1','223','1',1,'Retail Sale Id 533',2499.80,0.00,0.00,4.31,254.29,'2022-03-14 15:29:14','',''),(480,'1','223','1',1,'Retail Sale Id 534',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 16:09:33','',''),(481,'1','223','1',1,'Retail Sale Id 535',1160.00,0.00,0.00,2.00,118.00,'2022-03-14 16:11:46','',''),(482,'1','223','1',1,'Retail Sale Id 536',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 16:14:19','',''),(483,'1','223','1',1,'Retail Sale Id 537',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 16:18:24','',''),(484,'1','223','1',1,'Retail Sale Id 538',2900.00,0.00,0.00,5.00,295.00,'2022-03-14 16:33:34','',''),(485,'1','223','1',1,'Retail Sale Id 540',2900.00,0.00,0.00,5.00,295.00,'2022-03-14 16:35:55','',''),(486,'1','223','1',1,'Retail Sale Id 541',3480.00,0.00,0.00,6.00,354.00,'2022-03-14 16:41:03','',''),(487,'1','223','1',1,'Retail Sale Id 542',800.40,0.00,0.00,1.38,81.42,'2022-03-14 16:42:21','',''),(488,'1','223','1',1,'Retail Sale Id 543',1740.00,0.00,0.00,3.00,177.00,'2022-03-14 16:47:09','',''),(489,'1','223','1',1,'Retail Sale Id 544',7250.00,0.00,0.00,12.50,737.50,'2022-03-14 16:53:23','',''),(490,'1','223','1',1,'Retail Sale Id 545',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 16:55:53','',''),(491,'1','223','1',1,'Retail Sale Id 546',7250.00,0.00,0.00,12.50,737.50,'2022-03-14 17:05:13','',''),(492,'1','223','1',1,'Retail Sale Id 547',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 17:06:39','',''),(493,'1','223','1',1,'Retail Sale Id 548',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 17:09:12','',''),(494,'1','223','1',1,'Retail Sale Id 549',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 17:13:21','',''),(495,'1','223','1',1,'Retail Sale Id 551',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 17:20:42','',''),(496,'1','223','1',1,'Retail Sale Id 552',3480.00,0.00,0.00,6.00,354.00,'2022-03-14 17:49:31','',''),(497,'1','223','1',1,'Retail Sale Id 553',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 17:53:56','',''),(498,'1','223','1',1,'Retail Sale Id 554',3480.00,0.00,0.00,6.00,354.00,'2022-03-14 17:55:28','',''),(499,'1','223','1',1,'Retail Sale Id 555',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 17:58:12','',''),(500,'1','223','1',1,'Retail Sale Id 556',1740.00,0.00,0.00,3.00,177.00,'2022-03-14 18:01:00','',''),(501,'1','223','1',1,'Retail Sale Id 557',1200.60,0.00,0.00,2.07,122.13,'2022-03-14 18:02:56','',''),(502,'1','223','1',1,'Retail Sale Id 558',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 18:06:10','',''),(503,'1','223','1',1,'Retail Sale Id 559',3497.40,0.00,0.00,6.03,355.77,'2022-03-14 18:09:00','',''),(504,'1','223','1',1,'Retail Sale Id 560',1751.60,0.00,0.00,3.02,178.18,'2022-03-14 18:14:10','',''),(505,'1','223','1',1,'Retail Sale Id 561',3480.00,0.00,0.00,6.00,354.00,'2022-03-14 18:25:20','',''),(506,'1','223','1',1,'Retail Sale Id 562',1740.00,0.00,0.00,3.00,177.00,'2022-03-14 18:28:05','',''),(507,'1','223','1',1,'Retail Sale Id 564',5220.00,0.00,0.00,9.00,531.00,'2022-03-14 18:30:38','',''),(508,'1','223','1',1,'Retail Sale Id 565',3480.00,0.00,0.00,6.00,354.00,'2022-03-14 18:32:19','',''),(509,'1','223','1',1,'Retail Sale Id 566',1160.00,0.00,0.00,2.00,118.00,'2022-03-14 18:33:41','',''),(510,'1','223','1',1,'Retail Sale Id 567',1740.00,0.00,0.00,3.00,177.00,'2022-03-14 18:34:55','',''),(511,'1','223','1',1,'Retail Sale Id 568',1740.00,0.00,0.00,3.00,177.00,'2022-03-14 18:35:54','',''),(512,'1','223','1',1,'Retail Sale Id 569',2320.00,0.00,0.00,4.00,236.00,'2022-03-14 18:37:45','',''),(513,'1','223','1',1,'Retail Sale Id 570',997.60,0.00,0.00,1.72,101.48,'2022-03-14 18:38:39','',''),(514,'1','223','1',1,'Retail Sale Id 571',2035.80,0.00,0.00,3.51,207.09,'2022-03-14 19:21:01','',''),(515,'1','223','1',1,'Retail Sale Id 573',1740.00,0.00,0.00,3.00,177.00,'2022-03-15 07:43:39','',''),(516,'1','223','1',1,'Retail Sale Id 574',1740.00,0.00,0.00,3.00,177.00,'2022-03-15 07:44:39','',''),(517,'1','223','1',1,'Retail Sale Id 576',2001.00,0.00,0.00,3.45,203.55,'2022-03-15 07:57:02','',''),(518,'1','223','1',1,'Retail Sale Id 577',3497.40,0.00,0.00,6.03,355.77,'2022-03-15 08:07:39','',''),(519,'1','223','1',1,'Retail Sale Id 578',1740.00,0.00,0.00,3.00,177.00,'2022-03-15 08:22:26','',''),(520,'1','223','1',1,'Retail Sale Id 579',1160.00,0.00,0.00,2.00,118.00,'2022-03-15 09:11:33','',''),(521,'1','223','1',1,'Retail Sale Id 580',3497.40,0.00,0.00,6.03,355.77,'2022-03-15 09:15:48','',''),(522,'1','223','1',1,'Retail Sale Id 581',1751.60,0.00,0.00,3.02,178.18,'2022-03-15 09:28:00','',''),(523,'1','223','1',1,'Retail Sale Id 582',3497.40,0.00,0.00,6.03,355.77,'2022-03-15 09:32:05','',''),(524,'1','223','1',1,'Retail Sale Id 583',1751.60,0.00,0.00,3.02,178.18,'2022-03-15 09:42:03','',''),(525,'1','223','1',1,'Retail Sale Id 584',1740.00,0.00,0.00,3.00,177.00,'2022-03-15 09:52:03','',''),(526,'1','223','1',1,'Retail Sale Id 586',2900.00,0.00,0.00,5.00,295.00,'2022-03-15 09:52:43','',''),(527,'1','223','1',1,'Retail Sale Id 587',1740.00,0.00,0.00,3.00,177.00,'2022-03-15 09:53:45','',''),(528,'1','223','1',1,'Retail Sale Id 588',2900.00,0.00,0.00,5.00,295.00,'2022-03-15 09:55:07','',''),(529,'1','223','1',1,'Retail Sale Id 589',1751.60,0.00,0.00,3.02,178.18,'2022-03-15 09:56:05','',''),(530,'1','223','1',1,'Retail Sale Id 590',1751.60,0.00,0.00,3.02,178.18,'2022-03-15 09:57:28','',''),(531,'1','223','1',1,'Retail Sale Id 591',2349.00,0.00,0.00,4.05,238.95,'2022-03-15 10:37:09','',''),(532,'1','223','1',1,'Retail Sale Id 592',2900.00,0.00,0.00,5.00,295.00,'2022-03-15 10:40:36','',''),(533,'1','223','1',1,'Retail Sale Id 593',2998.60,0.00,0.00,5.17,305.03,'2022-03-15 10:52:37','',''),(534,'1','223','1',1,'Retail Sale Id 594',1751.60,0.00,0.00,3.02,178.18,'2022-03-15 10:56:55','',''),(535,'1','223','1',1,'Retail Sale Id 595',1751.60,0.00,0.00,3.02,178.18,'2022-03-15 11:15:29','',''),(536,'1','223','1',1,'Retail Sale Id 596',1200.60,0.00,0.00,2.07,122.13,'2022-03-15 11:40:11','',''),(537,'1','223','1',1,'Retail Sale Id 597',26750.00,0.00,0.00,50.00,700.00,'2022-03-15 11:55:10','',''),(538,'1','223','1',1,'Retail Sale Id 598',186180.00,0.00,0.00,348.00,4872.00,'2022-03-15 12:21:27','',''),(539,'1','223','1',1,'Retail Sale Id 599',155150.00,0.00,0.00,290.00,4060.00,'2022-03-15 12:22:29','',''),(540,'1','223','1',1,'Retail Sale Id 600',3497.40,0.00,0.00,6.03,355.77,'2022-03-15 12:55:31','',''),(541,'1','223','1',1,'Retail Sale Id 601',1751.60,0.00,0.00,3.02,178.18,'2022-03-15 12:56:25','',''),(542,'1','223','1',1,'Retail Sale Id 602',7250.00,0.00,0.00,12.50,737.50,'2022-03-15 13:16:07','',''),(543,'1','223','1',1,'Retail Sale Id 603',7250.00,0.00,0.00,12.50,737.50,'2022-03-15 13:20:21','',''),(544,'1','223','1',1,'Retail Sale Id 604',2900.00,0.00,0.00,5.00,295.00,'2022-03-15 13:45:15','',''),(545,'1','223','1',1,'Retail Sale Id 605',3497.40,0.00,0.00,6.03,355.77,'2022-03-15 13:55:40','',''),(546,'1','223','1',1,'Retail Sale Id 606',1200.60,0.00,0.00,2.07,122.13,'2022-03-15 14:10:31','',''),(547,'1','223','1',1,'Retail Sale Id 607',1200.60,0.00,0.00,2.07,122.13,'2022-03-15 14:20:26','',''),(548,'1','223','1',1,'Retail Sale Id 608',1160.00,0.00,0.00,2.00,118.00,'2022-03-15 14:22:29','',''),(549,'1','223','1',1,'Retail Sale Id 609',3497.40,0.00,0.00,6.03,355.77,'2022-03-15 14:28:29','',''),(550,'1','223','1',1,'Retail Sale Id 610',2001.00,0.00,0.00,3.45,203.55,'2022-03-15 14:30:01','',''),(551,'1','223','1',1,'Retail Sale Id 611',1798.00,0.00,0.00,3.10,182.90,'2022-03-15 14:39:11','',''),(552,'1','223','1',1,'Retail Sale Id 612',2349.00,0.00,0.00,4.05,238.95,'2022-03-15 14:44:46','',''),(553,'1','223','1',1,'Retail Sale Id 613',1740.00,0.00,0.00,3.00,177.00,'2022-03-15 14:58:12','',''),(554,'1','223','1',1,'Retail Sale Id 614',1751.60,0.00,0.00,3.02,178.18,'2022-03-15 15:12:53','',''),(555,'1','223','1',1,'Retail Sale Id 616',997.60,0.00,0.00,1.72,101.48,'2022-03-15 15:40:08','',''),(556,'1','223','1',1,'Retail Sale Id 617',1200.60,0.00,0.00,2.07,122.13,'2022-03-15 16:06:03','',''),(557,'1','223','1',1,'Retail Sale Id 622',2900.00,0.00,0.00,5.00,295.00,'2022-03-15 16:26:12','',''),(558,'1','223','1',1,'Retail Sale Id 624',5800.00,0.00,0.00,10.00,590.00,'2022-03-15 16:32:46','',''),(559,'1','223','1',1,'Retail Sale Id 625',1751.60,0.00,0.00,3.02,178.18,'2022-03-15 16:39:25','',''),(560,'1','223','1',1,'Retail Sale Id 627',7250.00,0.00,0.00,12.50,737.50,'2022-03-15 16:52:47','',''),(561,'1','223','1',1,'Retail Sale Id 628',800.40,0.00,0.00,1.38,81.42,'2022-03-15 17:22:13','',''),(562,'1','223','1',1,'Retail Sale Id 629',1200.60,0.00,0.00,2.07,122.13,'2022-03-15 17:26:24','',''),(563,'1','223','1',1,'Retail Sale Id 630',2900.00,0.00,0.00,5.00,295.00,'2022-03-15 17:35:32','',''),(564,'1','223','1',1,'Retail Sale Id 631',1200.60,0.00,0.00,2.07,122.13,'2022-03-15 17:37:14','',''),(565,'1','223','1',1,'Retail Sale Id 632',1751.60,0.00,0.00,3.02,178.18,'2022-03-15 17:50:14','',''),(566,'1','223','1',1,'Retail Sale Id 633',1200.60,0.00,0.00,2.07,122.13,'2022-03-15 17:56:23','',''),(567,'1','223','1',1,'Retail Sale Id 634',31030.00,0.00,0.00,58.00,812.00,'2022-03-15 18:12:47','',''),(568,'1','223','1',1,'Retail Sale Id 637',7250.00,0.00,0.00,12.50,737.50,'2022-03-15 18:14:19','',''),(569,'1','223','1',1,'Retail Sale Id 638',2320.00,0.00,0.00,4.00,236.00,'2022-03-15 18:22:15','',''),(570,'1','223','1',1,'Retail Sale Id 639',1160.00,0.00,0.00,2.00,118.00,'2022-03-15 18:28:28','',''),(571,'1','223','1',1,'Retail Sale Id 640',3480.00,0.00,0.00,6.00,354.00,'2022-03-15 18:38:26','',''),(572,'1','223','1',1,'Retail Sale Id 641',69.60,0.00,0.00,0.12,7.08,'2022-03-15 19:34:15','',''),(573,'1','223','1',1,'Retail Sale Id 643',3497.40,0.00,0.00,6.03,355.77,'2022-03-16 07:33:38','',''),(574,'1','223','1',1,'Retail Sale Id 644',2998.60,0.00,0.00,5.17,305.03,'2022-03-16 07:36:28','',''),(575,'1','223','1',1,'Retail Sale Id 645',1200.60,0.00,0.00,2.07,122.13,'2022-03-16 07:38:07','',''),(576,'1','223','1',1,'Retail Sale Id 646',1751.60,0.00,0.00,3.02,178.18,'2022-03-16 07:55:48','',''),(577,'1','223','1',1,'Retail Sale Id 647',3497.40,0.00,0.00,6.03,355.77,'2022-03-16 07:57:09','',''),(578,'1','223','1',1,'Retail Sale Id 648',1798.00,0.00,0.00,3.10,182.90,'2022-03-16 07:58:45','',''),(579,'1','223','1',1,'Retail Sale Id 649',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 08:08:37','',''),(580,'1','223','1',1,'Retail Sale Id 650',1200.60,0.00,0.00,2.07,122.13,'2022-03-16 08:25:07','',''),(581,'1','223','1',1,'Retail Sale Id 651',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 08:39:59','',''),(582,'1','223','1',1,'Retail Sale Id 652',1751.60,0.00,0.00,3.02,178.18,'2022-03-16 08:43:41','',''),(583,'1','223','1',1,'Retail Sale Id 653',1751.60,0.00,0.00,3.02,178.18,'2022-03-16 08:50:01','',''),(584,'1','223','1',1,'Retail Sale Id 654',53500.00,0.00,0.00,100.00,1400.00,'2022-03-16 09:07:14','',''),(585,'1','223','1',1,'Retail Sale Id 655',26750.00,0.00,0.00,50.00,700.00,'2022-03-16 09:08:33','',''),(586,'1','223','1',1,'Retail Sale Id 656',45742.50,0.00,0.00,85.50,1197.00,'2022-03-16 09:20:38','',''),(587,'1','223','1',1,'Retail Sale Id 657',61257.50,0.00,0.00,114.50,1603.00,'2022-03-16 09:21:13','',''),(588,'1','223','1',1,'Retail Sale Id 661',1160.00,0.00,0.00,2.00,118.00,'2022-03-16 09:30:19','',''),(589,'1','223','1',1,'Retail Sale Id 663',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 09:35:28','',''),(590,'1','223','1',1,'Retail Sale Id 664',597.40,0.00,0.00,1.03,60.77,'2022-03-16 09:46:07','',''),(591,'1','223','1',1,'Retail Sale Id 665',1148.40,0.00,0.00,1.98,116.82,'2022-03-16 10:44:49','',''),(592,'1','223','1',1,'Retail Sale Id 666',1160.00,0.00,0.00,2.00,118.00,'2022-03-16 10:46:44','',''),(593,'1','223','1',1,'Retail Sale Id 667',3480.00,0.00,0.00,6.00,354.00,'2022-03-16 10:57:40','',''),(594,'1','223','1',1,'Retail Sale Id 669',580.00,0.00,0.00,1.00,59.00,'2022-03-16 11:44:38','',''),(595,'1','223','1',1,'Retail Sale Id 670',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 12:06:56','',''),(596,'1','223','1',1,'Retail Sale Id 671',3480.00,0.00,0.00,6.00,354.00,'2022-03-16 13:06:52','',''),(597,'1','223','1',1,'Retail Sale Id 672',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 13:13:24','',''),(598,'1','223','1',1,'Retail Sale Id 673',997.60,0.00,0.00,1.72,101.48,'2022-03-16 13:34:19','',''),(599,'1','223','1',1,'Retail Sale Id 675',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 13:37:07','',''),(600,'1','223','1',1,'Return of Retail Sale Id 673',0.00,997.60,1.72,0.00,-101.48,'2022-03-16 13:40:21','',''),(601,'1','223','1',1,'Retail Sale Id 676',870.00,0.00,0.00,1.50,88.50,'2022-03-16 13:40:54','',''),(602,'1','223','1',1,'Retail Sale Id 678',580.00,0.00,0.00,1.00,59.00,'2022-03-16 13:44:52','',''),(603,'1','223','1',1,'Retail Sale Id 680',1160.00,0.00,0.00,2.00,118.00,'2022-03-16 13:47:20','',''),(604,'1','223','1',1,'Retail Sale Id 681',7250.00,0.00,0.00,12.50,737.50,'2022-03-16 13:52:16','',''),(605,'1','223','1',1,'Retail Sale Id 682',1751.60,0.00,0.00,3.02,178.18,'2022-03-16 14:01:01','',''),(606,'1','223','1',1,'Retail Sale Id 683',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 14:10:53','',''),(607,'1','223','1',1,'Retail Sale Id 684',997.60,0.00,0.00,1.72,101.48,'2022-03-16 14:19:21','',''),(608,'1','223','1',1,'Retail Sale Id 685',2998.60,0.00,0.00,5.17,305.03,'2022-03-16 14:31:56','',''),(609,'1','223','1',1,'Retail Sale Id 687',2320.00,0.00,0.00,4.00,236.00,'2022-03-16 14:32:20','',''),(610,'1','223','1',1,'Retail Sale Id 689',1502.20,0.00,0.00,2.59,152.81,'2022-03-16 15:09:18','',''),(611,'1','223','1',1,'Retail Sale Id 691',2900.00,0.00,0.00,5.00,295.00,'2022-03-16 15:15:42','',''),(612,'1','223','1',1,'Retail Sale Id 692',3480.00,0.00,0.00,6.00,354.00,'2022-03-16 15:20:01','',''),(613,'1','223','1',1,'Retail Sale Id 693',2320.00,0.00,0.00,4.00,236.00,'2022-03-16 15:35:29','',''),(614,'1','223','1',1,'Retail Sale Id 694',1160.00,0.00,0.00,2.00,118.00,'2022-03-16 16:04:26','',''),(615,'1','223','1',1,'Retail Sale Id 695',2900.00,0.00,0.00,5.00,295.00,'2022-03-16 16:32:18','',''),(616,'1','223','1',1,'Retail Sale Id 698',2001.00,0.00,0.00,3.45,203.55,'2022-03-16 16:33:40','',''),(617,'1','223','1',1,'Retail Sale Id 699',1160.00,0.00,0.00,2.00,118.00,'2022-03-16 16:47:20','',''),(618,'1','223','1',1,'Retail Sale Id 700',1160.00,0.00,0.00,2.00,118.00,'2022-03-16 16:56:54','',''),(619,'1','223','1',1,'Retail Sale Id 701',3480.00,0.00,0.00,6.00,354.00,'2022-03-16 16:57:56','',''),(620,'1','223','1',1,'Retail Sale Id 702',7250.00,0.00,0.00,12.50,737.50,'2022-03-16 17:00:34','',''),(621,'1','223','1',1,'Retail Sale Id 705',1450.00,0.00,0.00,2.50,147.50,'2022-03-16 17:05:11','',''),(622,'1','223','1',1,'Retail Sale Id 706',1160.00,0.00,0.00,2.00,118.00,'2022-03-16 17:18:38','',''),(623,'1','223','1',1,'Retail Sale Id 707',6501.80,0.00,0.00,11.21,661.39,'2022-03-16 17:24:15','',''),(624,'1','223','1',1,'Retail Sale Id 708',1200.60,0.00,0.00,2.07,122.13,'2022-03-16 17:29:00','',''),(625,'1','223','1',1,'Retail Sale Id 709',3480.00,0.00,0.00,6.00,354.00,'2022-03-16 17:31:18','',''),(626,'1','223','1',1,'Retail Sale Id 710',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 17:41:40','',''),(627,'1','223','1',1,'Retail Sale Id 711',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 17:42:39','',''),(628,'1','223','1',1,'Retail Sale Id 712',3480.00,0.00,0.00,6.00,354.00,'2022-03-16 17:44:15','',''),(629,'1','223','1',1,'Retail Sale Id 713',3480.00,0.00,0.00,6.00,354.00,'2022-03-16 17:45:59','',''),(630,'1','223','1',1,'Retail Sale Id 714',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 17:48:51','',''),(631,'1','223','1',1,'Retail Sale Id 715',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 17:59:13','',''),(632,'1','223','1',1,'Retail Sale Id 717',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 18:00:35','',''),(633,'1','223','1',1,'Retail Sale Id 718',3480.00,0.00,0.00,6.00,354.00,'2022-03-16 18:02:43','',''),(634,'1','223','1',1,'Retail Sale Id 719',1751.60,0.00,0.00,3.02,178.18,'2022-03-16 18:04:20','',''),(635,'1','223','1',1,'Retail Sale Id 720',2900.00,0.00,0.00,5.00,295.00,'2022-03-16 18:06:43','',''),(636,'1','223','1',1,'Retail Sale Id 721',3480.00,0.00,0.00,6.00,354.00,'2022-03-16 18:09:10','',''),(637,'1','223','1',1,'Retail Sale Id 722',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 18:09:48','',''),(638,'1','223','1',1,'Retail Sale Id 723',1160.00,0.00,0.00,2.00,118.00,'2022-03-16 18:12:51','',''),(639,'1','223','1',1,'Retail Sale Id 724',1200.60,0.00,0.00,2.07,122.13,'2022-03-16 18:13:49','',''),(640,'1','223','1',1,'Retail Sale Id 726',1200.60,0.00,0.00,2.07,122.13,'2022-03-16 18:21:05','',''),(641,'1','223','1',1,'Retail Sale Id 727',3497.40,0.00,0.00,6.03,355.77,'2022-03-16 18:23:16','',''),(642,'1','223','1',1,'Retail Sale Id 729',2499.80,0.00,0.00,4.31,254.29,'2022-03-16 18:24:05','',''),(643,'1','223','1',1,'Retail Sale Id 730',1200.60,0.00,0.00,2.07,122.13,'2022-03-16 18:28:09','',''),(644,'1','223','1',1,'Retail Sale Id 731',597.40,0.00,0.00,1.03,60.77,'2022-03-16 18:29:08','',''),(645,'1','223','1',1,'Retail Sale Id 732',1102.00,0.00,0.00,1.90,112.10,'2022-03-16 18:30:07','',''),(646,'1','223','1',1,'Retail Sale Id 734',3480.00,0.00,0.00,6.00,354.00,'2022-03-16 19:06:09','',''),(647,'1','223','1',1,'Retail Sale Id 735',1740.00,0.00,0.00,3.00,177.00,'2022-03-16 19:07:11','',''),(648,'1','223','1',1,'Retail Sale Id 736',997.60,0.00,0.00,1.72,101.48,'2022-03-16 19:11:35','',''),(649,'1','223','1',1,'Retail Sale Id 737',2499.80,0.00,0.00,4.31,254.29,'2022-03-16 19:17:38','',''),(650,'1','223','1',1,'Retail Sale Id 738',1102.00,0.00,0.00,1.90,112.10,'2022-03-16 19:19:35','',''),(651,'1','223','1',1,'Retail Sale Id 739',1751.60,0.00,0.00,3.02,178.18,'2022-03-17 07:10:07','',''),(652,'1','223','1',1,'Retail Sale Id 740',1751.60,0.00,0.00,3.02,178.18,'2022-03-17 07:41:16','',''),(653,'1','223','1',1,'Retail Sale Id 741',3497.40,0.00,0.00,6.03,355.77,'2022-03-17 07:57:11','',''),(654,'1','223','1',1,'Retail Sale Id 742',3497.40,0.00,0.00,6.03,355.77,'2022-03-17 08:11:57','',''),(655,'1','223','1',1,'Retail Sale Id 743',2900.00,0.00,0.00,5.00,295.00,'2022-03-17 08:12:47','',''),(656,'1','223','1',1,'Retail Sale Id 744',5800.00,0.00,0.00,10.00,590.00,'2022-03-17 08:14:45','',''),(657,'1','223','1',1,'Retail Sale Id 745',997.60,0.00,0.00,1.72,101.48,'2022-03-17 08:16:04','',''),(658,'1','223','1',1,'Retail Sale Id 746',3497.40,0.00,0.00,6.03,355.77,'2022-03-17 08:29:40','',''),(659,'1','223','1',1,'Retail Sale Id 747',1751.60,0.00,0.00,3.02,178.18,'2022-03-17 08:32:49','',''),(660,'1','223','1',1,'Retail Sale Id 751',6397.40,0.00,0.00,11.03,650.77,'2022-03-17 08:34:22','',''),(661,'1','223','1',1,'Retail Sale Id 752',580.00,0.00,0.00,1.00,59.00,'2022-03-17 09:10:08','',''),(662,'1','223','1',1,'Retail Sale Id 753',2320.00,0.00,0.00,4.00,236.00,'2022-03-17 09:11:15','',''),(663,'1','223','1',1,'Retail Sale Id 754',3497.40,0.00,0.00,6.03,355.77,'2022-03-17 09:13:11','',''),(664,'1','223','1',1,'Return of Retail Sale Id 752',0.00,580.00,1.00,0.00,-59.00,'2022-03-17 09:18:55','',''),(665,'1','223','1',1,'Return of Retail Sale Id 753',0.00,2320.00,4.00,0.00,-236.00,'2022-03-17 09:20:57','',''),(666,'1','223','1',1,'Retail Sale Id 755',2320.00,0.00,0.00,4.00,236.00,'2022-03-17 09:21:46','',''),(667,'1','223','1',1,'Retail Sale Id 756',1740.00,0.00,0.00,3.00,177.00,'2022-03-17 09:33:45','',''),(668,'1','223','1',1,'Retail Sale Id 757',2900.00,0.00,0.00,5.00,295.00,'2022-03-17 09:40:11','',''),(669,'1','223','1',1,'Retail Sale Id 758',1200.60,0.00,0.00,2.07,122.13,'2022-03-17 09:45:42','',''),(670,'1','223','1',1,'Retail Sale Id 759',29425.00,0.00,0.00,55.00,770.00,'2022-03-17 09:51:18','',''),(671,'1','223','1',1,'Retail Sale Id 760',2900.00,0.00,0.00,5.00,295.00,'2022-03-17 10:19:24','',''),(672,'1','223','1',1,'Retail Sale Id 761',701.80,0.00,0.00,1.21,71.39,'2022-03-17 10:29:26','',''),(673,'1','223','1',1,'Retail Sale Id 762',701.80,0.00,0.00,1.21,71.39,'2022-03-17 10:33:49','',''),(674,'1','223','1',1,'Retail Sale Id 763',2900.00,0.00,0.00,5.00,295.00,'2022-03-17 10:44:21','',''),(675,'1','223','1',1,'Return of Retail Sale Id 761',0.00,701.80,1.21,0.00,-71.39,'2022-03-17 10:45:32','',''),(676,'1','223','1',1,'Retail Sale Id 764',1200.60,0.00,0.00,2.07,122.13,'2022-03-17 10:49:26','',''),(677,'1','223','1',1,'Retail Sale Id 766',3480.00,0.00,0.00,6.00,354.00,'2022-03-17 11:17:02','',''),(678,'1','223','1',1,'Retail Sale Id 769',4100.60,0.00,0.00,7.07,417.13,'2022-03-17 12:04:11','',''),(679,'1','223','1',1,'Retail Sale Id 770',1200.60,0.00,0.00,2.07,122.13,'2022-03-17 12:26:14','',''),(680,'1','223','1',1,'Retail Sale Id 771',1502.20,0.00,0.00,2.59,152.81,'2022-03-17 12:27:10','',''),(681,'1','223','1',1,'Retail Sale Id 772',2499.80,0.00,0.00,4.31,254.29,'2022-03-17 13:22:15','',''),(682,'1','223','1',1,'Retail Sale Id 773',1160.00,0.00,0.00,2.00,118.00,'2022-03-17 13:27:11','',''),(683,'1','223','1',1,'Retail Sale Id 774',2320.00,0.00,0.00,4.00,236.00,'2022-03-17 13:41:08','',''),(684,'1','223','1',1,'Retail Sale Id 775',2320.00,0.00,0.00,4.00,236.00,'2022-03-17 14:07:37','',''),(685,'1','223','1',1,'Retail Sale Id 777',53500.00,0.00,0.00,100.00,1400.00,'2022-03-17 14:13:44','',''),(686,'1','223','1',1,'Retail Sale Id 778',2900.00,0.00,0.00,5.00,295.00,'2022-03-17 14:26:35','',''),(687,'1','223','1',1,'Retail Sale Id 779',1740.00,0.00,0.00,3.00,177.00,'2022-03-17 14:27:19','',''),(688,'1','223','1',1,'Retail Sale Id 780',2998.60,0.00,0.00,5.17,305.03,'2022-03-17 14:50:59','',''),(689,'1','223','1',1,'Retail Sale Id 781',580.00,0.00,0.00,1.00,59.00,'2022-03-17 15:53:28','',''),(690,'1','223','1',1,'Retail Sale Id 782',5800.00,0.00,0.00,10.00,590.00,'2022-03-17 15:57:24','',''),(691,'1','223','1',1,'Retail Sale Id 783',1160.00,0.00,0.00,2.00,118.00,'2022-03-17 16:29:18','',''),(692,'1','223','1',1,'Retail Sale Id 785',1740.00,0.00,0.00,3.00,177.00,'2022-03-17 16:31:17','',''),(693,'1','223','1',1,'Retail Sale Id 786',597.40,0.00,0.00,1.03,60.77,'2022-03-17 16:34:08','',''),(694,'1','223','1',1,'Retail Sale Id 787',997.60,0.00,0.00,1.72,101.48,'2022-03-17 16:39:12','',''),(695,'1','223','1',1,'Retail Sale Id 788',2900.00,0.00,0.00,5.00,295.00,'2022-03-17 16:39:57','',''),(696,'1','223','1',1,'Retail Sale Id 790',2900.00,0.00,0.00,5.00,295.00,'2022-03-17 16:40:39','',''),(697,'1','223','1',1,'Retail Sale Id 792',1740.00,0.00,0.00,3.00,177.00,'2022-03-17 16:47:13','',''),(698,'1','223','1',1,'Retail Sale Id 793',2900.00,0.00,0.00,5.00,295.00,'2022-03-17 16:48:10','',''),(699,'1','223','1',1,'Retail Sale Id 794',2349.00,0.00,0.00,4.05,238.95,'2022-03-17 16:51:50','',''),(700,'1','223','1',1,'Retail Sale Id 795',1160.00,0.00,0.00,2.00,118.00,'2022-03-17 16:55:11','',''),(701,'1','223','1',1,'Retail Sale Id 796',7250.00,0.00,0.00,12.50,737.50,'2022-03-17 17:04:44','',''),(702,'1','223','1',1,'Retail Sale Id 797',1751.60,0.00,0.00,3.02,178.18,'2022-03-17 17:12:43','',''),(703,'1','223','1',1,'Retail Sale Id 798',3480.00,0.00,0.00,6.00,354.00,'2022-03-17 17:28:35','',''),(704,'1','223','1',1,'Retail Sale Id 799',701.80,0.00,0.00,1.21,71.39,'2022-03-17 17:50:43','',''),(705,'1','223','1',1,'Retail Sale Id 800',1751.60,0.00,0.00,3.02,178.18,'2022-03-17 18:18:53','',''),(706,'1','223','1',1,'Retail Sale Id 802',3497.40,0.00,0.00,6.03,355.77,'2022-03-17 18:20:17','',''),(707,'1','223','1',1,'Retail Sale Id 804',597.40,0.00,0.00,1.03,60.77,'2022-03-17 18:20:55','',''),(708,'1','223','1',1,'Retail Sale Id 805',580.00,0.00,0.00,1.00,59.00,'2022-03-17 18:27:30','',''),(709,'1','223','1',1,'Retail Sale Id 806',2349.00,0.00,0.00,4.05,238.95,'2022-03-17 18:33:23','',''),(710,'1','223','1',1,'Retail Sale Id 807',1751.60,0.00,0.00,3.02,178.18,'2022-03-17 18:34:33','',''),(711,'1','223','1',1,'Retail Sale Id 809',1160.00,0.00,0.00,2.00,118.00,'2022-03-17 18:40:54','',''),(712,'1','223','1',1,'Retail Sale Id 811',2900.00,0.00,0.00,5.00,295.00,'2022-03-17 19:04:02','',''),(713,'1','223','1',1,'Retail Sale Id 813',1751.60,0.00,0.00,3.02,178.18,'2022-03-17 19:05:23','',''),(714,'1','223','1',1,'Retail Sale Id 814',1287.60,0.00,0.00,2.22,130.98,'2022-03-17 19:39:40','',''),(715,'1','223','1',1,'Retail Sale Id 816',2499.80,0.00,0.00,4.31,254.29,'2022-03-18 07:25:51','',''),(716,'1','223','1',1,'Retail Sale Id 820',1740.00,0.00,0.00,3.00,177.00,'2022-03-18 07:27:20','',''),(717,'1','223','1',1,'Retail Sale Id 821',1200.60,0.00,0.00,2.07,122.13,'2022-03-18 07:42:22','',''),(718,'1','223','1',1,'Retail Sale Id 822',2900.00,0.00,0.00,5.00,295.00,'2022-03-18 07:43:14','',''),(719,'1','223','1',1,'Retail Sale Id 823',1160.00,0.00,0.00,2.00,118.00,'2022-03-18 08:35:06','',''),(720,'1','223','1',1,'Retail Sale Id 828',1171.60,0.00,0.00,2.02,119.18,'2022-03-18 08:39:45','',''),(721,'1','223','1',1,'Retail Sale Id 829',2900.00,0.00,0.00,5.00,295.00,'2022-03-18 09:46:03','',''),(722,'1','223','1',1,'Retail Sale Id 830',2900.00,0.00,0.00,5.00,295.00,'2022-03-18 09:46:55','',''),(723,'1','223','1',1,'Retail Sale Id 831',7250.00,0.00,0.00,12.50,737.50,'2022-03-18 09:48:24','',''),(724,'1','223','1',1,'Retail Sale Id 832',1160.00,0.00,0.00,2.00,118.00,'2022-03-18 09:50:36','',''),(725,'1','223','1',1,'Retail Sale Id 833',1740.00,0.00,0.00,3.00,177.00,'2022-03-18 10:15:28','',''),(726,'1','223','1',1,'Retail Sale Id 834',1740.00,0.00,0.00,3.00,177.00,'2022-03-18 10:19:53','',''),(727,'1','223','1',1,'Retail Sale Id 836',2900.00,0.00,0.00,5.00,295.00,'2022-03-18 10:25:44','',''),(728,'1','223','1',1,'Retail Sale Id 837',1740.00,0.00,0.00,3.00,177.00,'2022-03-18 10:27:08','',''),(729,'1','223','1',1,'Retail Sale Id 838',1740.00,0.00,0.00,3.00,177.00,'2022-03-18 11:24:43','',''),(730,'1','223','1',1,'Retail Sale Id 839',2349.00,0.00,0.00,4.05,238.95,'2022-03-18 11:43:28','',''),(731,'1','223','1',1,'Retail Sale Id 840',2900.00,0.00,0.00,5.00,295.00,'2022-03-18 12:14:35','',''),(732,'1','223','1',1,'Retail Sale Id 841',1200.60,0.00,0.00,2.07,122.13,'2022-03-18 12:18:06','',''),(733,'1','223','1',1,'Retail Sale Id 842',29425.00,0.00,0.00,55.00,770.00,'2022-03-18 12:20:58','',''),(734,'1','223','1',1,'Retail Sale Id 843',1751.60,0.00,0.00,3.02,178.18,'2022-03-18 12:40:06','',''),(735,'1','223','1',1,'Retail Sale Id 845',7250.00,0.00,0.00,12.50,737.50,'2022-03-18 12:43:09','',''),(736,'1','223','1',1,'Retail Sale Id 846',1200.60,0.00,0.00,2.07,122.13,'2022-03-18 12:46:12','',''),(737,'1','223','1',1,'Retail Sale Id 847',107000.00,0.00,0.00,200.00,2800.00,'2022-03-18 12:46:29','',''),(738,'1','223','1',1,'Retail Sale Id 848',1200.60,0.00,0.00,2.07,122.13,'2022-03-18 12:54:50','',''),(739,'1','223','1',1,'Retail Sale Id 849',1751.60,0.00,0.00,3.02,178.18,'2022-03-18 13:04:26','',''),(740,'1','223','1',1,'Retail Sale Id 850',1171.60,0.00,0.00,2.02,119.18,'2022-03-18 13:12:25','',''),(741,'1','223','1',1,'Retail Sale Id 851',1740.00,0.00,0.00,3.00,177.00,'2022-03-18 13:33:06','',''),(742,'1','223','1',1,'Retail Sale Id 852',1751.60,0.00,0.00,3.02,178.18,'2022-03-18 13:38:47','',''),(743,'1','223','1',1,'Retail Sale Id 853',1751.60,0.00,0.00,3.02,178.18,'2022-03-18 13:40:43','',''),(744,'1','223','1',1,'Retail Sale Id 854',3480.00,0.00,0.00,6.00,354.00,'2022-03-18 14:40:56','',''),(745,'1','223','1',1,'Retail Sale Id 855',1699.40,0.00,0.00,2.93,172.87,'2022-03-18 14:53:45','',''),(746,'1','223','1',1,'Retail Sale Id 856',1740.00,0.00,0.00,3.00,177.00,'2022-03-18 15:11:05','',''),(747,'1','223','1',1,'Retail Sale Id 858',1751.60,0.00,0.00,3.02,178.18,'2022-03-18 15:53:13','',''),(748,'1','223','1',1,'Retail Sale Id 859',1751.60,0.00,0.00,3.02,178.18,'2022-03-18 16:22:05','',''),(749,'1','223','1',1,'Retail Sale Id 860',29425.00,0.00,0.00,55.00,770.00,'2022-03-18 16:34:54','',''),(750,'1','223','1',1,'Retail Sale Id 861',53500.00,0.00,0.00,100.00,1400.00,'2022-03-18 16:35:36','',''),(751,'1','223','1',1,'Retail Sale Id 863',1502.20,0.00,0.00,2.59,152.81,'2022-03-18 16:53:41','',''),(752,'1','223','1',1,'Retail Sale Id 864',1751.60,0.00,0.00,3.02,178.18,'2022-03-18 16:55:33','',''),(753,'1','223','1',1,'Retail Sale Id 865',1751.60,0.00,0.00,3.02,178.18,'2022-03-18 17:26:39','',''),(754,'1','223','1',1,'Retail Sale Id 867',997.60,0.00,0.00,1.72,101.48,'2022-03-18 17:27:26','',''),(755,'1','223','1',1,'Retail Sale Id 868',1740.00,0.00,0.00,3.00,177.00,'2022-03-18 17:28:16','',''),(756,'1','223','1',1,'Retail Sale Id 869',1740.00,0.00,0.00,3.00,177.00,'2022-03-18 17:30:26','',''),(757,'1','223','1',1,'Retail Sale Id 870',2001.00,0.00,0.00,3.45,203.55,'2022-03-18 17:36:15','',''),(758,'1','223','1',1,'Retail Sale Id 871',3480.00,0.00,0.00,6.00,354.00,'2022-03-18 17:37:46','',''),(759,'1','223','1',1,'Retail Sale Id 872',1160.00,0.00,0.00,2.00,118.00,'2022-03-18 17:42:47','',''),(760,'1','223','1',1,'Retail Sale Id 873',1200.60,0.00,0.00,2.07,122.13,'2022-03-18 17:43:52','',''),(761,'1','223','1',1,'Retail Sale Id 874',1200.60,0.00,0.00,2.07,122.13,'2022-03-18 17:45:00','',''),(762,'1','223','1',1,'Retail Sale Id 875',2349.00,0.00,0.00,4.05,238.95,'2022-03-18 18:03:26','',''),(763,'1','223','1',1,'Retail Sale Id 876',597.40,0.00,0.00,1.03,60.77,'2022-03-18 18:10:54','',''),(764,'1','223','1',1,'Retail Sale Id 877',1751.60,0.00,0.00,3.02,178.18,'2022-03-18 18:13:16','',''),(765,'1','223','1',1,'Retail Sale Id 878',3497.40,0.00,0.00,6.03,355.77,'2022-03-18 18:21:43','',''),(766,'1','223','1',1,'Retail Sale Id 879',1740.00,0.00,0.00,3.00,177.00,'2022-03-18 18:22:48','',''),(767,'1','223','1',1,'Retail Sale Id 880',1751.60,0.00,0.00,3.02,178.18,'2022-03-18 18:23:56','',''),(768,'1','223','1',1,'Retail Sale Id 881',1200.60,0.00,0.00,2.07,122.13,'2022-03-18 18:24:58','',''),(769,'1','223','1',1,'Retail Sale Id 882',32100.00,0.00,0.00,60.00,840.00,'2022-03-18 18:29:14','',''),(770,'1','223','1',1,'Retail Sale Id 883',1200.60,0.00,0.00,2.07,122.13,'2022-03-18 18:32:11','',''),(771,'1','223','1',1,'Retail Sale Id 884',2001.00,0.00,0.00,3.45,203.55,'2022-03-19 07:06:24','',''),(772,'1','223','1',1,'Retail Sale Id 885',1160.00,0.00,0.00,2.00,118.00,'2022-03-19 07:13:27','',''),(773,'1','223','1',1,'Retail Sale Id 886',2900.00,0.00,0.00,5.00,295.00,'2022-03-19 07:35:43','',''),(774,'1','223','1',1,'Retail Sale Id 887',1740.00,0.00,0.00,3.00,177.00,'2022-03-19 07:49:08','',''),(775,'1','223','1',1,'Retail Sale Id 888',1502.20,0.00,0.00,2.59,152.81,'2022-03-19 08:09:56','',''),(776,'1','223','1',1,'Retail Sale Id 889',1502.20,0.00,0.00,2.59,152.81,'2022-03-19 08:14:44','',''),(777,'1','223','1',1,'Retail Sale Id 890',2401.20,0.00,0.00,4.14,244.26,'2022-03-19 08:17:02','',''),(778,'1','223','1',1,'Retail Sale Id 891',2001.00,0.00,0.00,3.45,203.55,'2022-03-19 08:21:06','',''),(779,'1','223','1',1,'Retail Sale Id 892',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 08:28:44','',''),(780,'1','223','1',1,'Retail Sale Id 893',1200.60,0.00,0.00,2.07,122.13,'2022-03-19 08:37:47','',''),(781,'1','223','1',1,'Retail Sale Id 894',155150.00,0.00,0.00,290.00,4060.00,'2022-03-19 08:39:52','',''),(782,'1','223','1',1,'Retail Sale Id 895',186180.00,0.00,0.00,348.00,4872.00,'2022-03-19 08:40:20','',''),(783,'1','223','1',1,'Retail Sale Id 896',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 08:40:25','',''),(784,'1','223','1',1,'Retail Sale Id 897',1740.00,0.00,0.00,3.00,177.00,'2022-03-19 08:44:35','',''),(785,'1','223','1',1,'Retail Sale Id 898',3497.40,0.00,0.00,6.03,355.77,'2022-03-19 08:51:33','',''),(786,'1','223','1',1,'Retail Sale Id 899',1200.60,0.00,0.00,2.07,122.13,'2022-03-19 08:53:50','',''),(787,'1','223','1',1,'Retail Sale Id 901',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 08:58:35','',''),(788,'1','223','1',1,'Retail Sale Id 903',3497.40,0.00,0.00,6.03,355.77,'2022-03-19 09:03:18','',''),(789,'1','223','1',1,'Retail Sale Id 904',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 09:04:31','',''),(790,'1','223','1',1,'Retail Sale Id 905',3480.00,0.00,0.00,6.00,354.00,'2022-03-19 09:07:25','',''),(791,'1','223','1',1,'Retail Sale Id 909',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 09:23:32','',''),(792,'1','223','1',1,'Retail Sale Id 910',1502.20,0.00,0.00,2.59,152.81,'2022-03-19 09:25:08','',''),(793,'1','223','1',1,'Retail Sale Id 911',3497.40,0.00,0.00,6.03,355.77,'2022-03-19 09:26:17','',''),(794,'1','223','1',1,'Retail Sale Id 912',997.60,0.00,0.00,1.72,101.48,'2022-03-19 09:30:54','',''),(795,'1','223','1',1,'Retail Sale Id 913',1502.20,0.00,0.00,2.59,152.81,'2022-03-19 09:50:48','',''),(796,'1','223','1',1,'Retail Sale Id 914',997.60,0.00,0.00,1.72,101.48,'2022-03-19 09:51:02','',''),(797,'1','223','1',1,'Retail Sale Id 915',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 09:52:10','',''),(798,'1','223','1',1,'Retail Sale Id 916',2320.00,0.00,0.00,4.00,236.00,'2022-03-19 10:02:47','',''),(799,'1','223','1',1,'Retail Sale Id 917',1200.60,0.00,0.00,2.07,122.13,'2022-03-19 10:17:54','',''),(800,'1','223','1',1,'Retail Sale Id 921',3480.00,0.00,0.00,6.00,354.00,'2022-03-19 10:28:56','',''),(801,'1','223','1',1,'Retail Sale Id 922',53500.00,0.00,0.00,100.00,1400.00,'2022-03-19 10:35:57','',''),(802,'1','223','1',1,'Retail Sale Id 927',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 10:37:45','',''),(803,'1','223','1',1,'Retail Sale Id 928',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 10:39:57','',''),(804,'1','223','1',1,'Retail Sale Id 929',5220.00,0.00,0.00,9.00,531.00,'2022-03-19 10:45:23','',''),(805,'1','223','1',1,'Retail Sale Id 930',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 10:46:24','',''),(806,'1','223','1',1,'Retail Sale Id 931',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 10:58:10','',''),(807,'1','223','1',1,'Retail Sale Id 933',1102.00,0.00,0.00,1.90,112.10,'2022-03-19 11:01:10','',''),(808,'1','223','1',1,'Retail Sale Id 935',1740.00,0.00,0.00,3.00,177.00,'2022-03-19 11:11:13','',''),(809,'1','223','1',1,'Retail Sale Id 936',3480.00,0.00,0.00,6.00,354.00,'2022-03-19 11:14:52','',''),(810,'1','223','1',1,'Retail Sale Id 938',2198.20,0.00,0.00,3.79,223.61,'2022-03-19 11:19:58','',''),(811,'1','223','1',1,'Retail Sale Id 939',3497.40,0.00,0.00,6.03,355.77,'2022-03-19 11:37:34','',''),(812,'1','223','1',1,'Retail Sale Id 940',1200.60,0.00,0.00,2.07,122.13,'2022-03-19 11:38:55','',''),(813,'1','223','1',1,'Retail Sale Id 942',3497.40,0.00,0.00,6.03,355.77,'2022-03-19 11:44:27','',''),(814,'1','223','1',1,'Retail Sale Id 944',7250.00,0.00,0.00,12.50,737.50,'2022-03-19 12:13:25','',''),(815,'1','223','1',1,'Retail Sale Id 945',2900.00,0.00,0.00,5.00,295.00,'2022-03-19 12:14:09','',''),(816,'1','223','1',1,'Retail Sale Id 946',1200.60,0.00,0.00,2.07,122.13,'2022-03-19 12:17:30','',''),(817,'1','223','1',1,'Retail Sale Id 947',1502.20,0.00,0.00,2.59,152.81,'2022-03-19 12:28:45','',''),(818,'1','223','1',1,'Retail Sale Id 948',997.60,0.00,0.00,1.72,101.48,'2022-03-19 12:33:30','',''),(819,'1','223','1',1,'Retail Sale Id 949',7000.60,0.00,0.00,12.07,712.13,'2022-03-19 12:49:23','',''),(820,'1','223','1',1,'Retail Sale Id 950',5800.00,0.00,0.00,10.00,590.00,'2022-03-19 12:50:57','',''),(821,'1','223','1',1,'Retail Sale Id 951',1200.60,0.00,0.00,2.07,122.13,'2022-03-19 12:53:32','',''),(822,'1','223','1',1,'Retail Sale Id 953',5800.00,0.00,0.00,10.00,590.00,'2022-03-19 13:02:34','',''),(823,'1','223','1',1,'Retail Sale Id 954',1200.60,0.00,0.00,2.07,122.13,'2022-03-19 13:05:20','',''),(824,'1','223','1',1,'Retail Sale Id 955',701.80,0.00,0.00,1.21,71.39,'2022-03-19 13:34:57','',''),(825,'1','223','1',1,'Retail Sale Id 956',597.40,0.00,0.00,1.03,60.77,'2022-03-19 13:47:39','',''),(826,'1','223','1',1,'Retail Sale Id 957',2320.00,0.00,0.00,4.00,236.00,'2022-03-19 14:07:14','',''),(827,'1','223','1',1,'Retail Sale Id 958',2900.00,0.00,0.00,5.00,295.00,'2022-03-19 14:15:20','',''),(828,'1','223','1',1,'Retail Sale Id 959',53500.00,0.00,0.00,100.00,1400.00,'2022-03-19 14:37:28','',''),(829,'1','223','1',1,'Retail Sale Id 960',997.60,0.00,0.00,1.72,101.48,'2022-03-19 14:44:42','',''),(830,'1','223','1',1,'Retail Sale Id 961',1299.20,0.00,0.00,2.24,132.16,'2022-03-19 14:48:17','',''),(831,'1','223','1',1,'Retail Sale Id 963',580.00,0.00,0.00,1.00,59.00,'2022-03-19 14:52:44','',''),(832,'1','223','1',1,'Retail Sale Id 965',2900.00,0.00,0.00,5.00,295.00,'2022-03-19 15:29:35','',''),(833,'1','223','1',1,'Retail Sale Id 966',493805.00,0.00,0.00,923.00,12922.00,'2022-03-19 15:34:55','',''),(834,'1','223','1',1,'Retail Sale Id 967',1200.60,0.00,0.00,2.07,122.13,'2022-03-19 15:42:48','',''),(835,'1','223','1',1,'Retail Sale Id 968',26750.00,0.00,0.00,50.00,700.00,'2022-03-19 16:06:02','',''),(836,'1','223','1',1,'Retail Sale Id 969',1740.00,0.00,0.00,3.00,177.00,'2022-03-19 16:07:25','',''),(837,'1','223','1',1,'Retail Sale Id 970',2331.60,0.00,0.00,4.02,237.18,'2022-03-19 16:14:18','',''),(838,'1','223','1',1,'Retail Sale Id 971',7250.00,0.00,0.00,12.50,737.50,'2022-03-19 16:15:20','',''),(839,'1','223','1',1,'Retail Sale Id 972',2349.00,0.00,0.00,4.05,238.95,'2022-03-19 16:24:38','',''),(840,'1','223','1',1,'Retail Sale Id 973',1160.00,0.00,0.00,2.00,118.00,'2022-03-19 16:29:01','',''),(841,'1','223','1',1,'Retail Sale Id 974',997.60,0.00,0.00,1.72,101.48,'2022-03-19 16:33:30','',''),(842,'1','223','1',1,'Retail Sale Id 975',4640.00,0.00,0.00,8.00,472.00,'2022-03-19 16:35:40','',''),(843,'1','223','1',1,'Retail Sale Id 976',5800.00,0.00,0.00,10.00,590.00,'2022-03-19 16:38:11','',''),(844,'1','223','1',1,'Retail Sale Id 978',2900.00,0.00,0.00,5.00,295.00,'2022-03-19 16:44:09','',''),(845,'1','223','1',1,'Retail Sale Id 979',2900.00,0.00,0.00,5.00,295.00,'2022-03-19 16:45:30','',''),(846,'1','223','1',1,'Retail Sale Id 980',2320.00,0.00,0.00,4.00,236.00,'2022-03-19 16:47:08','',''),(847,'1','223','1',1,'Retail Sale Id 981',597.40,0.00,0.00,1.03,60.77,'2022-03-19 16:48:09','',''),(848,'1','223','1',1,'Retail Sale Id 982',1200.60,0.00,0.00,2.07,122.13,'2022-03-19 16:52:33','',''),(849,'1','223','1',1,'Retail Sale Id 983',1740.00,0.00,0.00,3.00,177.00,'2022-03-19 17:02:27','',''),(850,'1','223','1',1,'Retail Sale Id 984',597.40,0.00,0.00,1.03,60.77,'2022-03-19 17:08:20','',''),(851,'1','223','1',1,'Retail Sale Id 985',6380.00,0.00,0.00,11.00,649.00,'2022-03-19 17:40:00','',''),(852,'1','223','1',1,'Retail Sale Id 988',1160.00,0.00,0.00,2.00,118.00,'2022-03-19 17:41:03','',''),(853,'1','223','1',1,'Retail Sale Id 989',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 17:47:54','',''),(854,'1','223','1',1,'Retail Sale Id 992',2320.00,0.00,0.00,4.00,236.00,'2022-03-19 17:48:49','',''),(855,'1','223','1',1,'Retail Sale Id 994',580.00,0.00,0.00,1.00,59.00,'2022-03-19 17:49:47','',''),(856,'1','223','1',1,'Retail Sale Id 995',1160.00,0.00,0.00,2.00,118.00,'2022-03-19 17:52:06','',''),(857,'1','223','1',1,'Retail Sale Id 996',1740.00,0.00,0.00,3.00,177.00,'2022-03-19 17:52:55','',''),(858,'1','223','1',1,'Retail Sale Id 997',1200.60,0.00,0.00,2.07,122.13,'2022-03-19 17:54:51','',''),(859,'1','223','1',1,'Retail Sale Id 998',1171.60,0.00,0.00,2.02,119.18,'2022-03-19 17:57:20','',''),(860,'1','223','1',1,'Retail Sale Id 999',1740.00,0.00,0.00,3.00,177.00,'2022-03-19 18:05:55','',''),(861,'1','223','1',1,'Retail Sale Id 1000',2900.00,0.00,0.00,5.00,295.00,'2022-03-19 18:13:09','',''),(862,'1','223','1',1,'Retail Sale Id 1001',2900.00,0.00,0.00,5.00,295.00,'2022-03-19 18:19:03','',''),(863,'1','223','1',1,'Retail Sale Id 1002',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 18:23:56','',''),(864,'1','223','1',1,'Retail Sale Id 1003',3480.00,0.00,0.00,6.00,354.00,'2022-03-19 18:26:23','',''),(865,'1','223','1',1,'Retail Sale Id 1004',4999.60,0.00,0.00,8.62,508.58,'2022-03-19 18:34:17','',''),(866,'1','223','1',1,'Retail Sale Id 1006',1160.00,0.00,0.00,2.00,118.00,'2022-03-19 18:36:49','',''),(867,'1','223','1',1,'Retail Sale Id 1007',1751.60,0.00,0.00,3.02,178.18,'2022-03-19 18:37:48','',''),(868,'1','223','1',1,'Retail Sale Id 1008',2001.00,0.00,0.00,3.45,203.55,'2022-03-19 18:48:34','',''),(869,'1','223','1',1,'Retail Sale Id 1009',899.00,0.00,0.00,1.55,91.45,'2022-03-19 18:51:39','',''),(870,'1','223','1',1,'Return of Retail Sale Id 966',0.00,493805.00,923.00,0.00,-12922.00,'2022-03-19 19:26:26','',''),(871,'1','223','1',1,'Retail Sale Id 1010',489953.00,0.00,0.00,915.80,12821.20,'2022-03-19 19:27:53','',''),(872,'1','223','1',1,'Retail Sale Id 1023',997.60,0.00,0.00,1.72,101.48,'2022-03-20 07:28:04','',''),(873,'1','223','1',1,'Retail Sale Id 1024',597.40,0.00,0.00,1.03,60.77,'2022-03-20 07:29:02','',''),(874,'1','223','1',1,'Retail Sale Id 1025',1200.60,0.00,0.00,2.07,122.13,'2022-03-20 07:56:33','',''),(875,'1','223','1',1,'Retail Sale Id 1026',1200.60,0.00,0.00,2.07,122.13,'2022-03-20 07:57:21','',''),(876,'1','223','1',1,'Retail Sale Id 1027',2900.00,0.00,0.00,5.00,295.00,'2022-03-20 07:58:40','',''),(877,'1','223','1',1,'Retail Sale Id 1028',1740.00,0.00,0.00,3.00,177.00,'2022-03-20 07:59:53','',''),(878,'1','223','1',1,'Retail Sale Id 1030',2499.80,0.00,0.00,4.31,254.29,'2022-03-20 08:03:26','',''),(879,'1','223','1',1,'Retail Sale Id 1031',1160.00,0.00,0.00,2.00,118.00,'2022-03-20 08:09:03','',''),(880,'1','223','1',1,'Retail Sale Id 1032',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 08:11:34','',''),(881,'1','223','1',1,'Retail Sale Id 1033',1160.00,0.00,0.00,2.00,118.00,'2022-03-20 08:14:28','',''),(882,'1','223','1',1,'Retail Sale Id 1034',1200.60,0.00,0.00,2.07,122.13,'2022-03-20 08:21:57','',''),(883,'1','223','1',1,'Retail Sale Id 1035',2349.00,0.00,0.00,4.05,238.95,'2022-03-20 08:30:31','',''),(884,'1','223','1',1,'Retail Sale Id 1036',597.40,0.00,0.00,1.03,60.77,'2022-03-20 08:35:04','',''),(885,'1','223','1',1,'Retail Sale Id 1037',2900.00,0.00,0.00,5.00,295.00,'2022-03-20 08:41:49','',''),(886,'1','223','1',1,'Retail Sale Id 1039',2349.00,0.00,0.00,4.05,238.95,'2022-03-20 08:43:10','',''),(887,'1','223','1',1,'Retail Sale Id 1040',2349.00,0.00,0.00,4.05,238.95,'2022-03-20 08:59:54','',''),(888,'1','223','1',1,'Retail Sale Id 1041',7000.60,0.00,0.00,12.07,712.13,'2022-03-20 09:03:54','',''),(889,'1','223','1',1,'Retail Sale Id 1042',2349.00,0.00,0.00,4.05,238.95,'2022-03-20 09:05:23','',''),(890,'1','223','1',1,'Retail Sale Id 1043',997.60,0.00,0.00,1.72,101.48,'2022-03-20 09:07:44','',''),(891,'1','223','1',1,'Retail Sale Id 1044',3497.40,0.00,0.00,6.03,355.77,'2022-03-20 09:19:50','',''),(892,'1','223','1',1,'Retail Sale Id 1045',1740.00,0.00,0.00,3.00,177.00,'2022-03-20 09:21:39','',''),(893,'1','223','1',1,'Retail Sale Id 1046',5800.00,0.00,0.00,10.00,590.00,'2022-03-20 09:29:17','',''),(894,'1','223','1',1,'Retail Sale Id 1047',2349.00,0.00,0.00,4.05,238.95,'2022-03-20 09:39:07','',''),(895,'1','223','1',1,'Retail Sale Id 1048',3497.40,0.00,0.00,6.03,355.77,'2022-03-20 10:11:52','',''),(896,'1','223','1',1,'Retail Sale Id 1049',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 10:27:43','',''),(897,'1','223','1',1,'Retail Sale Id 1050',3497.40,0.00,0.00,6.03,355.77,'2022-03-20 10:51:32','',''),(898,'1','223','1',1,'Retail Sale Id 1051',2349.00,0.00,0.00,4.05,238.95,'2022-03-20 10:53:47','',''),(899,'1','223','1',1,'Retail Sale Id 1052',597.40,0.00,0.00,1.03,60.77,'2022-03-20 11:05:04','',''),(900,'1','223','1',1,'Retail Sale Id 1053',3497.40,0.00,0.00,6.03,355.77,'2022-03-20 11:30:17','',''),(901,'1','223','1',1,'Retail Sale Id 1054',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 11:36:52','',''),(902,'1','223','1',1,'Retail Sale Id 1055',2001.00,0.00,0.00,3.45,203.55,'2022-03-20 11:41:45','',''),(903,'1','223','1',1,'Retail Sale Id 1056',7250.00,0.00,0.00,12.50,737.50,'2022-03-20 11:43:23','',''),(904,'1','223','1',1,'Retail Sale Id 1057',1740.00,0.00,0.00,3.00,177.00,'2022-03-20 11:44:37','',''),(905,'1','223','1',1,'Retail Sale Id 1058',597.40,0.00,0.00,1.03,60.77,'2022-03-20 11:45:47','',''),(906,'1','223','1',1,'Retail Sale Id 1059',3480.00,0.00,0.00,6.00,354.00,'2022-03-20 11:50:14','',''),(907,'1','223','1',1,'Retail Sale Id 1060',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 12:04:03','',''),(908,'1','223','1',1,'Retail Sale Id 1061',2349.00,0.00,0.00,4.05,238.95,'2022-03-20 12:11:03','',''),(909,'1','223','1',1,'Retail Sale Id 1062',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 12:16:31','',''),(910,'1','223','1',1,'Retail Sale Id 1063',2320.00,0.00,0.00,4.00,236.00,'2022-03-20 12:27:24','',''),(911,'1','223','1',1,'Retail Sale Id 1064',29425.00,0.00,0.00,55.00,770.00,'2022-03-20 12:36:35','',''),(912,'1','223','1',1,'Retail Sale Id 1065',2349.00,0.00,0.00,4.05,238.95,'2022-03-20 12:38:27','',''),(913,'1','223','1',1,'Retail Sale Id 1066',7000.60,0.00,0.00,12.07,712.13,'2022-03-20 12:40:14','',''),(914,'1','223','1',1,'Retail Sale Id 1067',7250.00,0.00,0.00,12.50,737.50,'2022-03-20 12:47:03','',''),(915,'1','223','1',1,'Retail Sale Id 1068',1699.40,0.00,0.00,2.93,172.87,'2022-03-20 13:05:17','',''),(916,'1','223','1',1,'Retail Sale Id 1069',2900.00,0.00,0.00,5.00,295.00,'2022-03-20 13:34:00','',''),(917,'1','223','1',1,'Retail Sale Id 1070',2001.00,0.00,0.00,3.45,203.55,'2022-03-20 13:41:32','',''),(918,'1','223','1',1,'Retail Sale Id 1071',1740.00,0.00,0.00,3.00,177.00,'2022-03-20 13:42:53','',''),(919,'1','223','1',1,'Retail Sale Id 1072',597.40,0.00,0.00,1.03,60.77,'2022-03-20 13:45:56','',''),(920,'1','223','1',1,'Retail Sale Id 1074',2349.00,0.00,0.00,4.05,238.95,'2022-03-20 13:53:08','',''),(921,'1','223','1',1,'Retail Sale Id 1075',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 13:54:18','',''),(922,'1','223','1',1,'Retail Sale Id 1076',1160.00,0.00,0.00,2.00,118.00,'2022-03-20 13:55:42','',''),(923,'1','223','1',1,'Retail Sale Id 1077',2900.00,0.00,0.00,5.00,295.00,'2022-03-20 14:08:22','',''),(924,'1','223','1',1,'Retail Sale Id 1078',2900.00,0.00,0.00,5.00,295.00,'2022-03-20 14:09:48','',''),(925,'1','223','1',1,'Retail Sale Id 1079',899.00,0.00,0.00,1.55,91.45,'2022-03-20 14:22:35','',''),(926,'1','223','1',1,'Retail Sale Id 1080',7250.00,0.00,0.00,12.50,737.50,'2022-03-20 14:24:09','',''),(927,'1','223','1',1,'Retail Sale Id 1081',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 14:26:18','',''),(928,'1','223','1',1,'Retail Sale Id 1082',1740.00,0.00,0.00,3.00,177.00,'2022-03-20 14:46:34','',''),(929,'1','223','1',1,'Retail Sale Id 1083',1502.20,0.00,0.00,2.59,152.81,'2022-03-20 15:13:47','',''),(930,'1','223','1',1,'Retail Sale Id 1084',2900.00,0.00,0.00,5.00,295.00,'2022-03-20 15:17:52','',''),(931,'1','223','1',1,'Retail Sale Id 1085',1397.80,0.00,0.00,2.41,142.19,'2022-03-20 15:22:04','',''),(932,'1','223','1',1,'Retail Sale Id 1086',597.40,0.00,0.00,1.03,60.77,'2022-03-20 15:29:13','',''),(933,'1','223','1',1,'Retail Sale Id 1087',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 15:35:59','',''),(934,'1','223','1',1,'Retail Sale Id 1088',2900.00,0.00,0.00,5.00,295.00,'2022-03-20 15:37:27','',''),(935,'1','223','1',1,'Retail Sale Id 1089',2900.00,0.00,0.00,5.00,295.00,'2022-03-20 15:42:42','',''),(936,'1','223','1',1,'Retail Sale Id 1090',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 16:01:41','',''),(937,'1','223','1',1,'Retail Sale Id 1091',3497.40,0.00,0.00,6.03,355.77,'2022-03-20 16:05:08','',''),(938,'1','223','1',1,'Retail Sale Id 1092',1160.00,0.00,0.00,2.00,118.00,'2022-03-20 16:12:59','',''),(939,'1','223','1',1,'Retail Sale Id 1093',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 16:36:27','',''),(940,'1','223','1',1,'Retail Sale Id 1094',3480.00,0.00,0.00,6.00,354.00,'2022-03-20 16:43:57','',''),(941,'1','223','1',1,'Retail Sale Id 1097',1740.00,0.00,0.00,3.00,177.00,'2022-03-20 16:55:46','',''),(942,'1','223','1',1,'Retail Sale Id 1099',1740.00,0.00,0.00,3.00,177.00,'2022-03-20 16:59:02','',''),(943,'1','223','1',1,'Retail Sale Id 1100',3480.00,0.00,0.00,6.00,354.00,'2022-03-20 17:07:14','',''),(944,'1','223','1',1,'Retail Sale Id 1101',1200.60,0.00,0.00,2.07,122.13,'2022-03-20 17:08:27','',''),(945,'1','223','1',1,'Retail Sale Id 1102',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 17:18:14','',''),(946,'1','223','1',1,'Retail Sale Id 1103',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 17:20:34','',''),(947,'1','223','1',1,'Retail Sale Id 1106',2900.00,0.00,0.00,5.00,295.00,'2022-03-20 17:38:09','',''),(948,'1','223','1',1,'Retail Sale Id 1107',2900.00,0.00,0.00,5.00,295.00,'2022-03-20 17:39:44','',''),(949,'1','223','1',1,'Retail Sale Id 1108',2001.00,0.00,0.00,3.45,203.55,'2022-03-20 17:54:56','',''),(950,'1','223','1',1,'Retail Sale Id 1110',1200.60,0.00,0.00,2.07,122.13,'2022-03-20 18:00:55','',''),(951,'1','223','1',1,'Retail Sale Id 1111',1751.60,0.00,0.00,3.02,178.18,'2022-03-20 18:08:58','',''),(952,'1','223','1',1,'Retail Sale Id 1112',597.40,0.00,0.00,1.03,60.77,'2022-03-20 18:42:29','',''),(953,'1','223','1',1,'Retail Sale Id 1113',1740.00,0.00,0.00,3.00,177.00,'2022-03-20 19:06:31','',''),(954,'1','223','1',1,'Retail Sale Id 1115',1740.00,0.00,0.00,3.00,177.00,'2022-03-20 19:11:01','',''),(955,'1','223','1',1,'Retail Sale Id 1116',580.00,0.00,0.00,1.00,59.00,'2022-03-20 19:41:27','',''),(956,'1','223','1',1,'Return of Retail Sale Id 1116',0.00,580.00,1.00,0.00,-59.00,'2022-03-20 19:42:07','',''),(957,'1','223','1',1,'Return of Retail Sale Id 1111',0.00,1751.60,3.02,0.00,-178.18,'2022-03-20 19:43:07','',''),(958,'1','223','1',1,'Return of Retail Sale Id 1110',0.00,1200.60,2.07,0.00,-122.13,'2022-03-20 19:43:31','',''),(959,'1','223','1',1,'Return of Retail Sale Id 1115',0.00,1740.00,3.00,0.00,-177.00,'2022-03-20 19:45:47','',''),(960,'1','223','1',1,'Retail Sale Id 1117',1757.40,0.00,0.00,3.03,178.77,'2022-03-20 19:46:22','',''),(961,'1','223','1',1,'Retail Sale Id 1118',185.60,0.00,0.00,0.32,18.88,'2022-03-20 19:53:15','',''),(962,'1','223','1',1,'Retail Sale Id 1119',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 08:12:38','',''),(963,'1','223','1',1,'Retail Sale Id 1120',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 08:18:21','',''),(964,'1','223','1',1,'Retail Sale Id 1121',1160.00,0.00,0.00,2.00,118.00,'2022-03-21 08:27:50','',''),(965,'1','223','1',1,'Retail Sale Id 1122',2349.00,0.00,0.00,4.05,238.95,'2022-03-21 08:41:26','',''),(966,'1','223','1',1,'Retail Sale Id 1123',3497.40,0.00,0.00,6.03,355.77,'2022-03-21 08:47:50','',''),(967,'1','223','1',1,'Retail Sale Id 1124',2900.00,0.00,0.00,5.00,295.00,'2022-03-21 09:06:57','',''),(968,'1','223','1',1,'Retail Sale Id 1125',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 09:26:34','',''),(969,'1','223','1',1,'Retail Sale Id 1126',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 09:32:54','',''),(970,'1','223','1',1,'Retail Sale Id 1127',997.60,0.00,0.00,1.72,101.48,'2022-03-21 09:34:18','',''),(971,'1','223','1',1,'Retail Sale Id 1128',1502.20,0.00,0.00,2.59,152.81,'2022-03-21 09:38:55','',''),(972,'1','223','1',1,'Retail Sale Id 1129',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 09:43:15','',''),(973,'1','223','1',1,'Retail Sale Id 1130',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 09:55:19','',''),(974,'1','223','1',1,'Retail Sale Id 1131',31030.00,0.00,0.00,58.00,812.00,'2022-03-21 10:03:09','',''),(975,'1','223','1',1,'Retail Sale Id 1132',1299.20,0.00,0.00,2.24,132.16,'2022-03-21 10:13:32','',''),(976,'1','223','1',1,'Retail Sale Id 1133',3497.40,0.00,0.00,6.03,355.77,'2022-03-21 10:21:43','',''),(977,'1','223','1',1,'Retail Sale Id 1134',7250.00,0.00,0.00,12.50,737.50,'2022-03-21 10:50:31','',''),(978,'1','223','1',1,'Retail Sale Id 1135',580.00,0.00,0.00,1.00,59.00,'2022-03-21 10:52:25','',''),(979,'1','223','1',1,'Retail Sale Id 1136',2900.00,0.00,0.00,5.00,295.00,'2022-03-21 10:53:46','',''),(980,'1','223','1',1,'Retail Sale Id 1137',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 10:55:15','',''),(981,'1','223','1',1,'Return of Retail Sale Id 1135',0.00,580.00,1.00,0.00,-59.00,'2022-03-21 10:58:40','',''),(982,'1','223','1',1,'Retail Sale Id 1138',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 11:08:21','',''),(983,'1','223','1',1,'Retail Sale Id 1139',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 11:09:32','',''),(984,'1','223','1',1,'Retail Sale Id 1140',2349.00,0.00,0.00,4.05,238.95,'2022-03-21 11:22:49','',''),(985,'1','223','1',1,'Retail Sale Id 1141',53500.00,0.00,0.00,100.00,1400.00,'2022-03-21 11:31:36','',''),(986,'1','223','1',1,'Retail Sale Id 1142',86937.50,0.00,0.00,162.50,2275.00,'2022-03-21 11:38:37','',''),(987,'1','223','1',1,'Retail Sale Id 1143',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 11:43:36','',''),(988,'1','223','1',1,'Retail Sale Id 1144',26750.00,0.00,0.00,50.00,700.00,'2022-03-21 11:45:20','',''),(989,'1','223','1',1,'Retail Sale Id 1145',26750.00,0.00,0.00,50.00,700.00,'2022-03-21 11:46:36','',''),(990,'1','223','1',1,'Return of Retail Sale Id 1141',0.00,53500.00,100.00,0.00,-1400.00,'2022-03-21 11:48:03','',''),(991,'1','223','1',1,'Retail Sale Id 1146',997.60,0.00,0.00,1.72,101.48,'2022-03-21 12:04:44','',''),(992,'1','223','1',1,'Retail Sale Id 1147',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 12:08:09','',''),(993,'1','223','1',1,'Return of Retail Sale Id 1142',0.00,86937.50,162.50,0.00,-2275.00,'2022-03-21 12:11:33','',''),(994,'1','223','1',1,'Retail Sale Id 1148',67945.00,0.00,0.00,127.00,1778.00,'2022-03-21 12:13:01','',''),(995,'1','223','1',1,'Retail Sale Id 1149',18992.50,0.00,0.00,35.50,497.00,'2022-03-21 12:14:49','',''),(996,'1','223','1',1,'Retail Sale Id 1150',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 12:18:09','',''),(997,'1','223','1',1,'Retail Sale Id 1151',2900.00,0.00,0.00,5.00,295.00,'2022-03-21 12:55:45','',''),(998,'1','223','1',1,'Retail Sale Id 1152',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 13:01:21','',''),(999,'1','223','1',1,'Retail Sale Id 1153',2320.00,0.00,0.00,4.00,236.00,'2022-03-21 13:05:51','',''),(1000,'1','223','1',1,'Retail Sale Id 1154',1600.80,0.00,0.00,2.76,162.84,'2022-03-21 13:08:00','',''),(1001,'1','223','1',1,'Retail Sale Id 1155',2001.00,0.00,0.00,3.45,203.55,'2022-03-21 13:08:50','',''),(1002,'1','223','1',1,'Retail Sale Id 1156',597.40,0.00,0.00,1.03,60.77,'2022-03-21 13:38:58','',''),(1003,'1','223','1',1,'Retail Sale Id 1157',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 13:48:33','',''),(1004,'1','223','1',1,'Retail Sale Id 1158',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 14:05:06','',''),(1005,'1','223','1',1,'Retail Sale Id 1159',3480.00,0.00,0.00,6.00,354.00,'2022-03-21 14:07:24','',''),(1006,'1','223','1',1,'Retail Sale Id 1160',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 14:17:18','',''),(1007,'1','223','1',1,'Retail Sale Id 1161',2349.00,0.00,0.00,4.05,238.95,'2022-03-21 14:25:31','',''),(1008,'1','223','1',1,'Return of Retail Sale Id 1161',0.00,2349.00,4.05,0.00,-238.95,'2022-03-21 14:26:06','',''),(1009,'1','223','1',1,'Retail Sale Id 1162',2499.80,0.00,0.00,4.31,254.29,'2022-03-21 14:26:52','',''),(1010,'1','223','1',1,'Retail Sale Id 1163',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 14:45:47','',''),(1011,'1','223','1',1,'Retail Sale Id 1164',701.80,0.00,0.00,1.21,71.39,'2022-03-21 15:19:47','',''),(1012,'1','223','1',1,'Retail Sale Id 1165',2001.00,0.00,0.00,3.45,203.55,'2022-03-21 15:26:18','',''),(1013,'1','223','1',1,'Retail Sale Id 1166',7250.00,0.00,0.00,12.50,737.50,'2022-03-21 15:44:44','',''),(1014,'1','223','1',1,'Retail Sale Id 1167',2900.00,0.00,0.00,5.00,295.00,'2022-03-21 16:01:22','',''),(1015,'1','223','1',1,'Retail Sale Id 1168',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 16:04:27','',''),(1016,'1','223','1',1,'Retail Sale Id 1171',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 16:16:14','',''),(1017,'1','223','1',1,'Retail Sale Id 1172',3480.00,0.00,0.00,6.00,354.00,'2022-03-21 16:17:07','',''),(1018,'1','223','1',1,'Retail Sale Id 1173',3480.00,0.00,0.00,6.00,354.00,'2022-03-21 16:18:08','',''),(1019,'1','223','1',1,'Retail Sale Id 1174',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 16:20:01','',''),(1020,'1','223','1',1,'Retail Sale Id 1175',2349.00,0.00,0.00,4.05,238.95,'2022-03-21 16:24:07','',''),(1021,'1','223','1',1,'Retail Sale Id 1176',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 16:27:26','',''),(1022,'1','223','1',1,'Retail Sale Id 1177',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 16:35:34','',''),(1023,'1','223','1',1,'Retail Sale Id 1178',1160.00,0.00,0.00,2.00,118.00,'2022-03-21 16:44:14','',''),(1024,'1','223','1',1,'Retail Sale Id 1179',597.40,0.00,0.00,1.03,60.77,'2022-03-21 16:53:04','',''),(1025,'1','223','1',1,'Retail Sale Id 1181',1299.20,0.00,0.00,2.24,132.16,'2022-03-21 17:01:10','',''),(1026,'1','223','1',1,'Retail Sale Id 1182',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 17:02:32','',''),(1027,'1','223','1',1,'Retail Sale Id 1183',1160.00,0.00,0.00,2.00,118.00,'2022-03-21 17:03:32','',''),(1028,'1','223','1',1,'Retail Sale Id 1184',3480.00,0.00,0.00,6.00,354.00,'2022-03-21 17:11:00','',''),(1029,'1','223','1',1,'Retail Sale Id 1186',2900.00,0.00,0.00,5.00,295.00,'2022-03-21 17:11:49','',''),(1030,'1','223','1',1,'Retail Sale Id 1187',3480.00,0.00,0.00,6.00,354.00,'2022-03-21 17:15:44','',''),(1031,'1','223','1',1,'Retail Sale Id 1188',597.40,0.00,0.00,1.03,60.77,'2022-03-21 17:16:57','',''),(1032,'1','223','1',1,'Retail Sale Id 1189',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 17:23:57','',''),(1033,'1','223','1',1,'Retail Sale Id 1191',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 17:25:26','',''),(1034,'1','223','1',1,'Retail Sale Id 1192',2900.00,0.00,0.00,5.00,295.00,'2022-03-21 17:31:25','',''),(1035,'1','223','1',1,'Retail Sale Id 1193',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 17:32:27','',''),(1036,'1','223','1',1,'Retail Sale Id 1194',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 17:36:20','',''),(1037,'1','223','1',1,'Retail Sale Id 1195',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 17:41:03','',''),(1038,'1','223','1',1,'Retail Sale Id 1196',580.00,0.00,0.00,1.00,59.00,'2022-03-21 17:41:38','',''),(1039,'1','223','1',1,'Retail Sale Id 1197',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 17:43:59','',''),(1040,'1','223','1',1,'Retail Sale Id 1198',3480.00,0.00,0.00,6.00,354.00,'2022-03-21 17:45:58','',''),(1041,'1','223','1',1,'Retail Sale Id 1199',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 17:46:53','',''),(1042,'1','223','1',1,'Retail Sale Id 1200',3480.00,0.00,0.00,6.00,354.00,'2022-03-21 17:47:37','',''),(1043,'1','223','1',1,'Retail Sale Id 1201',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 17:48:45','',''),(1044,'1','223','1',1,'Retail Sale Id 1202',3480.00,0.00,0.00,6.00,354.00,'2022-03-21 17:49:39','',''),(1045,'1','223','1',1,'Retail Sale Id 1203',597.40,0.00,0.00,1.03,60.77,'2022-03-21 17:53:58','',''),(1046,'1','223','1',1,'Retail Sale Id 1205',5800.00,0.00,0.00,10.00,590.00,'2022-03-21 17:54:38','',''),(1047,'1','223','1',1,'Retail Sale Id 1206',597.40,0.00,0.00,1.03,60.77,'2022-03-21 17:55:36','',''),(1048,'1','223','1',1,'Retail Sale Id 1207',2320.00,0.00,0.00,4.00,236.00,'2022-03-21 17:57:04','',''),(1049,'1','223','1',1,'Retail Sale Id 1208',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 17:58:19','',''),(1050,'1','223','1',1,'Retail Sale Id 1210',3480.00,0.00,0.00,6.00,354.00,'2022-03-21 17:59:17','',''),(1051,'1','223','1',1,'Retail Sale Id 1212',2900.00,0.00,0.00,5.00,295.00,'2022-03-21 18:00:01','',''),(1052,'1','223','1',1,'Retail Sale Id 1214',2900.00,0.00,0.00,5.00,295.00,'2022-03-21 18:00:39','',''),(1053,'1','223','1',1,'Retail Sale Id 1215',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 18:01:22','',''),(1054,'1','223','1',1,'Retail Sale Id 1217',580.00,0.00,0.00,1.00,59.00,'2022-03-21 18:02:02','',''),(1055,'1','223','1',1,'Retail Sale Id 1218',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 18:02:38','',''),(1056,'1','223','1',1,'Retail Sale Id 1219',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 18:03:37','',''),(1057,'1','223','1',1,'Retail Sale Id 1220',2349.00,0.00,0.00,4.05,238.95,'2022-03-21 18:04:31','',''),(1058,'1','223','1',1,'Retail Sale Id 1221',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 18:04:46','',''),(1059,'1','223','1',1,'Retail Sale Id 1222',580.00,0.00,0.00,1.00,59.00,'2022-03-21 18:05:36','',''),(1060,'1','223','1',1,'Retail Sale Id 1224',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 18:05:41','',''),(1061,'1','223','1',1,'Retail Sale Id 1225',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 18:06:56','',''),(1062,'1','223','1',1,'Retail Sale Id 1226',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 18:07:38','',''),(1063,'1','223','1',1,'Retail Sale Id 1227',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 18:07:41','',''),(1064,'1','223','1',1,'Retail Sale Id 1228',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 18:08:40','',''),(1065,'1','223','1',1,'Retail Sale Id 1229',1798.00,0.00,0.00,3.10,182.90,'2022-03-21 18:09:14','',''),(1066,'1','223','1',1,'Retail Sale Id 1230',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 18:09:31','',''),(1067,'1','223','1',1,'Retail Sale Id 1231',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 18:10:28','',''),(1068,'1','223','1',1,'Retail Sale Id 1233',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 18:10:41','',''),(1069,'1','223','1',1,'Retail Sale Id 1234',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 18:11:48','',''),(1070,'1','223','1',1,'Retail Sale Id 1235',3480.00,0.00,0.00,6.00,354.00,'2022-03-21 18:12:53','',''),(1071,'1','223','1',1,'Retail Sale Id 1236',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 18:14:08','',''),(1072,'1','223','1',1,'Retail Sale Id 1237',3497.40,0.00,0.00,6.03,355.77,'2022-03-21 18:16:37','',''),(1073,'1','223','1',1,'Retail Sale Id 1238',1502.20,0.00,0.00,2.59,152.81,'2022-03-21 18:19:51','',''),(1074,'1','223','1',1,'Retail Sale Id 1239',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 18:21:56','',''),(1075,'1','223','1',1,'Retail Sale Id 1240',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 18:22:15','',''),(1076,'1','223','1',1,'Retail Sale Id 1241',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 18:26:15','',''),(1077,'1','223','1',1,'Retail Sale Id 1242',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 18:27:51','',''),(1078,'1','223','1',1,'Retail Sale Id 1243',2900.00,0.00,0.00,5.00,295.00,'2022-03-21 18:29:14','',''),(1079,'1','223','1',1,'Retail Sale Id 1244',3497.40,0.00,0.00,6.03,355.77,'2022-03-21 18:31:17','',''),(1080,'1','223','1',1,'Retail Sale Id 1245',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 18:31:52','',''),(1081,'1','223','1',1,'Retail Sale Id 1246',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 18:33:08','',''),(1082,'1','223','1',1,'Retail Sale Id 1247',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 18:33:52','',''),(1083,'1','223','1',1,'Retail Sale Id 1248',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 18:34:40','',''),(1084,'1','223','1',1,'Retail Sale Id 1249',1740.00,0.00,0.00,3.00,177.00,'2022-03-21 18:35:27','',''),(1085,'1','223','1',1,'Retail Sale Id 1250',2900.00,0.00,0.00,5.00,295.00,'2022-03-21 18:35:55','',''),(1086,'1','223','1',1,'Retail Sale Id 1251',1160.00,0.00,0.00,2.00,118.00,'2022-03-21 18:37:11','',''),(1087,'1','223','1',1,'Retail Sale Id 1252',1751.60,0.00,0.00,3.02,178.18,'2022-03-21 18:41:32','',''),(1088,'1','223','1',1,'Retail Sale Id 1253',7250.00,0.00,0.00,12.50,737.50,'2022-03-21 18:43:15','',''),(1089,'1','223','1',1,'Retail Sale Id 1254',1200.60,0.00,0.00,2.07,122.13,'2022-03-21 18:45:06','',''),(1090,'1','223','1',1,'Retail Sale Id 1255',5800.00,0.00,0.00,10.00,590.00,'2022-03-21 18:46:30','',''),(1091,'1','223','1',1,'Retail Sale Id 1256',597.40,0.00,0.00,1.03,60.77,'2022-03-21 18:48:30','',''),(1092,'1','223','1',1,'Retail Sale Id 1257',1160.00,0.00,0.00,2.00,118.00,'2022-03-21 18:50:49','',''),(1093,'1','223','1',1,'Return of Retail Sale Id 1250',0.00,2900.00,5.00,0.00,-295.00,'2022-03-21 19:27:38','',''),(1094,'1','223','1',1,'Retail Sale Id 1258',3114.60,0.00,0.00,5.37,316.83,'2022-03-21 19:28:57','',''),(1095,'1','223','1',1,'Retail Sale Id 1259',997.60,0.00,0.00,1.72,101.48,'2022-03-22 07:50:36','',''),(1096,'1','223','1',1,'Retail Sale Id 1260',3480.00,0.00,0.00,6.00,354.00,'2022-03-22 07:58:45','',''),(1097,'1','223','1',1,'Retail Sale Id 1261',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 08:02:07','',''),(1098,'1','223','1',1,'Retail Sale Id 1263',997.60,0.00,0.00,1.72,101.48,'2022-03-22 08:03:20','',''),(1099,'1','223','1',1,'Retail Sale Id 1264',3480.00,0.00,0.00,6.00,354.00,'2022-03-22 08:04:13','',''),(1100,'1','223','1',1,'Retail Sale Id 1265',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 08:09:21','',''),(1101,'1','223','1',1,'Retail Sale Id 1266',1502.20,0.00,0.00,2.59,152.81,'2022-03-22 08:12:38','',''),(1102,'1','223','1',1,'Retail Sale Id 1268',2900.00,0.00,0.00,5.00,295.00,'2022-03-22 08:23:02','',''),(1103,'1','223','1',1,'Retail Sale Id 1269',1502.20,0.00,0.00,2.59,152.81,'2022-03-22 08:31:24','',''),(1104,'1','223','1',1,'Retail Sale Id 1270',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 08:45:14','',''),(1105,'1','223','1',1,'Retail Sale Id 1271',597.40,0.00,0.00,1.03,60.77,'2022-03-22 09:08:21','',''),(1106,'1','223','1',1,'Retail Sale Id 1272',3480.00,0.00,0.00,6.00,354.00,'2022-03-22 09:24:56','',''),(1107,'1','223','1',1,'Retail Sale Id 1273',597.40,0.00,0.00,1.03,60.77,'2022-03-22 09:35:38','',''),(1108,'1','223','1',1,'Retail Sale Id 1274',29425.00,0.00,0.00,55.00,770.00,'2022-03-22 09:39:51','',''),(1109,'1','223','1',1,'Retail Sale Id 1275',227696.00,0.00,0.00,425.60,5958.40,'2022-03-22 09:46:14','',''),(1110,'1','223','1',1,'Retail Sale Id 1276',2349.00,0.00,0.00,4.05,238.95,'2022-03-22 09:49:09','',''),(1111,'1','223','1',1,'Retail Sale Id 1277',2349.00,0.00,0.00,4.05,238.95,'2022-03-22 09:51:23','',''),(1112,'1','223','1',1,'Retail Sale Id 1278',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 09:53:45','',''),(1113,'1','223','1',1,'Retail Sale Id 1279',1160.00,0.00,0.00,2.00,118.00,'2022-03-22 10:08:39','',''),(1114,'1','223','1',1,'Retail Sale Id 1280',2998.60,0.00,0.00,5.17,305.03,'2022-03-22 10:14:00','',''),(1115,'1','223','1',1,'Retail Sale Id 1281',2900.00,0.00,0.00,5.00,295.00,'2022-03-22 10:26:08','',''),(1116,'1','223','1',1,'Retail Sale Id 1282',1200.60,0.00,0.00,2.07,122.13,'2022-03-22 10:35:53','',''),(1117,'1','223','1',1,'Retail Sale Id 1283',580.00,0.00,0.00,1.00,59.00,'2022-03-22 10:58:33','',''),(1118,'1','223','1',1,'Retail Sale Id 1285',701.80,0.00,0.00,1.21,71.39,'2022-03-22 11:16:34','',''),(1119,'1','223','1',1,'Retail Sale Id 1286',2349.00,0.00,0.00,4.05,238.95,'2022-03-22 11:20:05','',''),(1120,'1','223','1',1,'Retail Sale Id 1287',597.40,0.00,0.00,1.03,60.77,'2022-03-22 11:39:53','',''),(1121,'1','223','1',1,'Retail Sale Id 1288',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 11:54:33','',''),(1122,'1','223','1',1,'Retail Sale Id 1289',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 11:57:53','',''),(1123,'1','223','1',1,'Retail Sale Id 1290',2900.00,0.00,0.00,5.00,295.00,'2022-03-22 12:00:54','',''),(1124,'1','223','1',1,'Retail Sale Id 1291',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 12:08:22','',''),(1125,'1','223','1',1,'Retail Sale Id 1293',2702.80,0.00,0.00,4.66,274.94,'2022-03-22 12:22:34','',''),(1126,'1','223','1',1,'Retail Sale Id 1294',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 12:43:59','',''),(1127,'1','223','1',1,'Retail Sale Id 1295',649.60,0.00,0.00,1.12,66.08,'2022-03-22 13:01:22','',''),(1128,'1','223','1',1,'Retail Sale Id 1296',1200.60,0.00,0.00,2.07,122.13,'2022-03-22 13:04:54','',''),(1129,'1','223','1',1,'Retail Sale Id 1297',997.60,0.00,0.00,1.72,101.48,'2022-03-22 13:20:00','',''),(1130,'1','223','1',1,'Retail Sale Id 1298',3480.00,0.00,0.00,6.00,354.00,'2022-03-22 13:24:54','',''),(1131,'1','223','1',1,'Retail Sale Id 1299',1200.60,0.00,0.00,2.07,122.13,'2022-03-22 13:29:56','',''),(1132,'1','223','1',1,'Retail Sale Id 1301',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 13:33:43','',''),(1133,'1','223','1',1,'Retail Sale Id 1302',1160.00,0.00,0.00,2.00,118.00,'2022-03-22 13:39:31','',''),(1134,'1','223','1',1,'Retail Sale Id 1303',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 13:47:16','',''),(1135,'1','223','1',1,'Retail Sale Id 1304',580.00,0.00,0.00,1.00,59.00,'2022-03-22 13:49:44','',''),(1136,'1','223','1',1,'Retail Sale Id 1305',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 13:52:09','',''),(1137,'1','223','1',1,'Retail Sale Id 1306',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 13:53:41','',''),(1138,'1','223','1',1,'Return of Retail Sale Id 1304',0.00,580.00,1.00,0.00,-59.00,'2022-03-22 13:55:11','',''),(1139,'1','223','1',1,'Retail Sale Id 1307',2320.00,0.00,0.00,4.00,236.00,'2022-03-22 15:06:37','',''),(1140,'1','223','1',1,'Retail Sale Id 1308',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 15:21:43','',''),(1141,'1','223','1',1,'Retail Sale Id 1309',2900.00,0.00,0.00,5.00,295.00,'2022-03-22 15:22:33','',''),(1142,'1','223','1',1,'Retail Sale Id 1310',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 15:25:11','',''),(1143,'1','223','1',1,'Retail Sale Id 1311',3480.00,0.00,0.00,6.00,354.00,'2022-03-22 15:30:32','',''),(1144,'1','223','1',1,'Retail Sale Id 1313',3480.00,0.00,0.00,6.00,354.00,'2022-03-22 15:31:21','',''),(1145,'1','223','1',1,'Retail Sale Id 1314',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 15:34:03','',''),(1146,'1','223','1',1,'Retail Sale Id 1316',2001.00,0.00,0.00,3.45,203.55,'2022-03-22 15:39:31','',''),(1147,'1','223','1',1,'Retail Sale Id 1317',3480.00,0.00,0.00,6.00,354.00,'2022-03-22 15:46:23','',''),(1148,'1','223','1',1,'Retail Sale Id 1318',2320.00,0.00,0.00,4.00,236.00,'2022-03-22 15:49:17','',''),(1149,'1','223','1',1,'Retail Sale Id 1320',2900.00,0.00,0.00,5.00,295.00,'2022-03-22 15:50:12','',''),(1150,'1','223','1',1,'Retail Sale Id 1321',1502.20,0.00,0.00,2.59,152.81,'2022-03-22 15:53:30','',''),(1151,'1','223','1',1,'Retail Sale Id 1322',3480.00,0.00,0.00,6.00,354.00,'2022-03-22 16:00:11','',''),(1152,'1','223','1',1,'Retail Sale Id 1323',2998.60,0.00,0.00,5.17,305.03,'2022-03-22 16:01:02','',''),(1153,'1','223','1',1,'Retail Sale Id 1324',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 16:06:09','',''),(1154,'1','223','1',1,'Retail Sale Id 1325',1200.60,0.00,0.00,2.07,122.13,'2022-03-22 16:07:57','',''),(1155,'1','223','1',1,'Retail Sale Id 1326',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 16:08:45','',''),(1156,'1','223','1',1,'Retail Sale Id 1327',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 16:14:52','',''),(1157,'1','223','1',1,'Retail Sale Id 1328',1200.60,0.00,0.00,2.07,122.13,'2022-03-22 16:17:26','',''),(1158,'1','223','1',1,'Retail Sale Id 1329',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 16:19:22','',''),(1159,'1','223','1',1,'Retail Sale Id 1330',3497.40,0.00,0.00,6.03,355.77,'2022-03-22 16:20:45','',''),(1160,'1','223','1',1,'Retail Sale Id 1331',5800.00,0.00,0.00,10.00,590.00,'2022-03-22 16:26:01','',''),(1161,'1','223','1',1,'Retail Sale Id 1332',1160.00,0.00,0.00,2.00,118.00,'2022-03-22 16:27:35','',''),(1162,'1','223','1',1,'Retail Sale Id 1333',1798.00,0.00,0.00,3.10,182.90,'2022-03-22 16:28:49','',''),(1163,'1','223','1',1,'Retail Sale Id 1334',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 16:32:08','',''),(1164,'1','223','1',1,'Retail Sale Id 1335',2900.00,0.00,0.00,5.00,295.00,'2022-03-22 16:37:29','',''),(1165,'1','223','1',1,'Retail Sale Id 1336',597.40,0.00,0.00,1.03,60.77,'2022-03-22 16:39:01','',''),(1166,'1','223','1',1,'Retail Sale Id 1337',7250.00,0.00,0.00,12.50,737.50,'2022-03-22 16:40:42','',''),(1167,'1','223','1',1,'Retail Sale Id 1338',1160.00,0.00,0.00,2.00,118.00,'2022-03-22 16:43:47','',''),(1168,'1','223','1',1,'Retail Sale Id 1339',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 16:53:28','',''),(1169,'1','223','1',1,'Retail Sale Id 1340',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 16:55:02','',''),(1170,'1','223','1',1,'Retail Sale Id 1341',2320.00,0.00,0.00,4.00,236.00,'2022-03-22 16:56:18','',''),(1171,'1','223','1',1,'Retail Sale Id 1342',3480.00,0.00,0.00,6.00,354.00,'2022-03-22 17:26:59','',''),(1172,'1','223','1',1,'Retail Sale Id 1343',2250.40,0.00,0.00,3.88,228.92,'2022-03-22 17:28:13','',''),(1173,'1','223','1',1,'Retail Sale Id 1344',1160.00,0.00,0.00,2.00,118.00,'2022-03-22 17:30:19','',''),(1174,'1','223','1',1,'Retail Sale Id 1345',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 17:31:44','',''),(1175,'1','223','1',1,'Retail Sale Id 1346',2900.00,0.00,0.00,5.00,295.00,'2022-03-22 17:33:09','',''),(1176,'1','223','1',1,'Retail Sale Id 1347',3497.40,0.00,0.00,6.03,355.77,'2022-03-22 17:34:07','',''),(1177,'1','223','1',1,'Retail Sale Id 1348',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 17:35:09','',''),(1178,'1','223','1',1,'Retail Sale Id 1349',1160.00,0.00,0.00,2.00,118.00,'2022-03-22 17:35:16','',''),(1179,'1','223','1',1,'Retail Sale Id 1350',1397.80,0.00,0.00,2.41,142.19,'2022-03-22 17:36:00','',''),(1180,'1','223','1',1,'Retail Sale Id 1351',2900.00,0.00,0.00,5.00,295.00,'2022-03-22 17:36:18','',''),(1181,'1','223','1',1,'Retail Sale Id 1352',1160.00,0.00,0.00,2.00,118.00,'2022-03-22 17:36:30','',''),(1182,'1','223','1',1,'Retail Sale Id 1353',1160.00,0.00,0.00,2.00,118.00,'2022-03-22 17:37:11','',''),(1183,'1','223','1',1,'Retail Sale Id 1354',7250.00,0.00,0.00,12.50,737.50,'2022-03-22 17:37:43','',''),(1184,'1','223','1',1,'Retail Sale Id 1355',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 17:37:52','',''),(1185,'1','223','1',1,'Retail Sale Id 1356',1200.60,0.00,0.00,2.07,122.13,'2022-03-22 17:38:23','',''),(1186,'1','223','1',1,'Retail Sale Id 1357',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 17:39:21','',''),(1187,'1','223','1',1,'Retail Sale Id 1358',997.60,0.00,0.00,1.72,101.48,'2022-03-22 17:40:02','',''),(1188,'1','223','1',1,'Retail Sale Id 1359',1699.40,0.00,0.00,2.93,172.87,'2022-03-22 17:44:32','',''),(1189,'1','223','1',1,'Retail Sale Id 1360',2320.00,0.00,0.00,4.00,236.00,'2022-03-22 17:45:27','',''),(1190,'1','223','1',1,'Retail Sale Id 1361',5800.00,0.00,0.00,10.00,590.00,'2022-03-22 17:47:29','',''),(1191,'1','223','1',1,'Retail Sale Id 1362',1160.00,0.00,0.00,2.00,118.00,'2022-03-22 17:48:42','',''),(1192,'1','223','1',1,'Retail Sale Id 1363',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 17:50:10','',''),(1193,'1','223','1',1,'Retail Sale Id 1364',2900.00,0.00,0.00,5.00,295.00,'2022-03-22 17:51:17','',''),(1194,'1','223','1',1,'Retail Sale Id 1365',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 17:52:22','',''),(1195,'1','223','1',1,'Retail Sale Id 1366',1740.00,0.00,0.00,3.00,177.00,'2022-03-22 17:53:23','',''),(1196,'1','223','1',1,'Retail Sale Id 1367',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 17:54:15','',''),(1197,'1','223','1',1,'Retail Sale Id 1368',2001.00,0.00,0.00,3.45,203.55,'2022-03-22 17:55:05','',''),(1198,'1','223','1',1,'Retail Sale Id 1369',1200.60,0.00,0.00,2.07,122.13,'2022-03-22 17:56:12','',''),(1199,'1','223','1',1,'Retail Sale Id 1370',1751.60,0.00,0.00,3.02,178.18,'2022-03-22 18:04:26','',''),(1200,'1','223','1',1,'Retail Sale Id 1371',580.00,0.00,0.00,1.00,59.00,'2022-03-22 18:06:05','',''),(1201,'1','223','1',1,'Return of Retail Sale Id 1370',0.00,1751.60,3.02,0.00,-178.18,'2022-03-22 20:51:45','',''),(1202,'1','223','1',1,'Return of Retail Sale Id 1371',0.00,580.00,1.00,0.00,-59.00,'2022-03-22 20:52:19','',''),(1203,'1','223','1',1,'Return of Retail Sale Id 1354',0.00,7250.00,12.50,0.00,-737.50,'2022-03-22 20:55:48','',''),(1204,'1','223','1',1,'Return of Retail Sale Id 1361',0.00,5800.00,10.00,0.00,-590.00,'2022-03-22 21:16:41','',''),(1205,'1','223','1',1,'Return of Retail Sale Id 1331',0.00,5800.00,10.00,0.00,-590.00,'2022-03-22 21:17:40','',''),(1206,'1','223','1',1,'Return of Retail Sale Id 1260',0.00,3480.00,6.00,0.00,-354.00,'2022-03-22 21:19:33','',''),(1207,'1','223','1',1,'Return of Retail Sale Id 1309',0.00,2900.00,5.00,0.00,-295.00,'2022-03-22 21:19:55','',''),(1208,'1','223','1',1,'Return of Retail Sale Id 1364',0.00,2900.00,5.00,0.00,-295.00,'2022-03-22 21:21:09','',''),(1209,'1','223','1',1,'Return of Retail Sale Id 1272',0.00,3480.00,6.00,0.00,-354.00,'2022-03-22 21:21:16','',''),(1210,'1','223','1',1,'Return of Retail Sale Id 1290',0.00,2900.00,5.00,0.00,-295.00,'2022-03-22 21:22:40','',''),(1211,'1','223','1',1,'Return of Retail Sale Id 1352',0.00,1160.00,2.00,0.00,-118.00,'2022-03-22 21:24:24','',''),(1212,'1','223','1',1,'Retail Sale Id 1372',1357.20,0.00,0.00,2.34,138.06,'2022-03-22 21:25:02','',''),(1213,'1','223','1',1,'Retail Sale Id 1373',24931.00,0.00,0.00,46.60,652.40,'2022-03-22 21:27:14','',''),(1214,'1','223','1',1,'Retail Sale Id 1374',26931.90,0.00,0.00,50.34,704.76,'2022-03-22 21:39:12','',''),(1215,'1','223','1',1,'Return of Retail Sale Id 1373',0.00,24931.00,46.60,0.00,-652.40,'2022-03-22 21:40:08','',''),(1216,'1','223','1',1,'Distributed to A A RANO NIGERIA LIMITED for sales id:1',210978.95,0.00,0.00,404.95,0.00,'2022-03-22 21:49:29','',''),(1217,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,7056000.00,12000.00,0.00,0.00,'2022-03-22 21:55:37','',''),(1218,'1','223',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,12000.00,0.00,'2022-03-22 21:57:03','',''),(1219,'1','223','1',1,'Received from bridging 2',0.00,0.00,12000.00,0.00,0.00,'2022-03-22 21:57:03','',''),(1220,'1','223','1',1,'Retail Sale Id 1375',87063.80,0.00,0.00,150.11,-1200.88,'2022-03-23 06:31:04','',''),(1221,'1','223','1',1,'Retail Sale Id 1376',43964.00,0.00,0.00,75.80,-606.40,'2022-03-23 06:32:05','',''),(1222,'1','223','1',1,'Retail Sale Id 1377',7750.00,0.00,0.00,12.50,400.00,'2022-03-23 07:11:53','',''),(1223,'1','223','1',1,'Retail Sale Id 1378',3000.80,0.00,0.00,4.84,154.88,'2022-03-23 07:14:46','',''),(1224,'1','223','1',1,'Retail Sale Id 1379',6200.00,0.00,0.00,10.00,320.00,'2022-03-23 07:18:03','',''),(1225,'1','223','1',1,'Retail Sale Id 1380',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 07:19:48','',''),(1226,'1','223','1',1,'Retail Sale Id 1381',1798.00,0.00,0.00,2.90,92.80,'2022-03-23 07:21:25','',''),(1227,'1','223','1',1,'Retail Sale Id 1382',2002.60,0.00,0.00,3.23,103.36,'2022-03-23 07:23:54','',''),(1228,'1','223','1',1,'Retail Sale Id 1383',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 07:31:56','',''),(1229,'1','223','1',1,'Retail Sale Id 1385',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 07:32:54','',''),(1230,'1','223','1',1,'Retail Sale Id 1386',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 07:53:55','',''),(1231,'1','223','1',1,'Retail Sale Id 1387',1698.80,0.00,0.00,2.74,87.68,'2022-03-23 08:09:05','',''),(1232,'1','223','1',1,'Retail Sale Id 1388',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 08:10:00','',''),(1233,'1','223','1',1,'Retail Sale Id 1389',7750.00,0.00,0.00,12.50,400.00,'2022-03-23 08:12:22','',''),(1234,'1','223','1',1,'Retail Sale Id 1390',2498.60,0.00,0.00,4.03,128.96,'2022-03-23 08:13:59','',''),(1235,'1','223','1',1,'Retail Sale Id 1391',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 08:20:04','',''),(1236,'1','223','1',1,'Retail Sale Id 1392',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 08:25:57','',''),(1237,'1','223','1',1,'Retail Sale Id 1393',6820.00,0.00,0.00,11.00,352.00,'2022-03-23 08:30:03','',''),(1238,'1','223','1',1,'Retail Sale Id 1396',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 08:32:06','',''),(1239,'1','223','1',1,'Retail Sale Id 1397',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 08:35:10','',''),(1240,'1','223','1',1,'Retail Sale Id 1398',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 08:35:56','',''),(1241,'1','223','1',1,'Retail Sale Id 1399',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 08:37:03','',''),(1242,'1','223','1',1,'Retail Sale Id 1400',3000.80,0.00,0.00,4.84,154.88,'2022-03-23 08:39:01','',''),(1243,'1','223','1',1,'Retail Sale Id 1401',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 08:44:02','',''),(1244,'1','223','1',1,'Retail Sale Id 1402',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 08:47:58','',''),(1245,'1','223','1',1,'Retail Sale Id 1403',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 08:50:04','',''),(1246,'1','223','1',1,'Retail Sale Id 1405',651.00,0.00,0.00,1.05,33.60,'2022-03-23 08:51:28','',''),(1247,'1','223','1',1,'Retail Sale Id 1408',2498.60,0.00,0.00,4.03,128.96,'2022-03-23 08:52:31','',''),(1248,'1','223','1',1,'Retail Sale Id 1409',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 08:53:24','',''),(1249,'1','223','1',1,'Retail Sale Id 1411',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 08:58:43','',''),(1250,'1','223','1',1,'Retail Sale Id 1412',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 09:00:38','',''),(1251,'1','223','1',1,'Retail Sale Id 1413',998.20,0.00,0.00,1.61,51.52,'2022-03-23 09:13:21','',''),(1252,'1','223','1',1,'Retail Sale Id 1414',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 09:17:34','',''),(1253,'1','223','1',1,'Retail Sale Id 1415',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 09:19:08','',''),(1254,'1','223','1',1,'Retail Sale Id 1416',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 09:20:46','',''),(1255,'1','223','1',1,'Retail Sale Id 1417',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 09:22:46','',''),(1256,'1','223','1',1,'Retail Sale Id 1418',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 09:24:30','',''),(1257,'1','223','1',1,'Retail Sale Id 1419',6200.00,0.00,0.00,10.00,320.00,'2022-03-23 09:29:52','',''),(1258,'1','223','1',1,'Retail Sale Id 1420',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 09:44:57','',''),(1259,'1','223','1',1,'Retail Sale Id 1421',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 09:47:44','',''),(1260,'1','223','1',1,'Retail Sale Id 1422',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 09:48:56','',''),(1261,'1','223','1',1,'Retail Sale Id 1423',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 09:50:48','',''),(1262,'1','223','1',1,'Retail Sale Id 1424',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 09:51:46','',''),(1263,'1','223','1',1,'Retail Sale Id 1425',1202.80,0.00,0.00,1.94,62.08,'2022-03-23 09:53:52','',''),(1264,'1','223','1',1,'Retail Sale Id 1426',2498.60,0.00,0.00,4.03,128.96,'2022-03-23 09:58:13','',''),(1265,'1','223','1',1,'Retail Sale Id 1427',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 10:12:44','',''),(1266,'1','223','1',1,'Retail Sale Id 1428',1847.60,0.00,0.00,2.98,95.36,'2022-03-23 10:18:23','',''),(1267,'1','223','1',1,'Retail Sale Id 1429',7750.00,0.00,0.00,12.50,400.00,'2022-03-23 10:30:28','',''),(1268,'1','223','1',1,'Retail Sale Id 1431',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 10:33:29','',''),(1269,'1','223','1',1,'Retail Sale Id 1432',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 10:34:42','',''),(1270,'1','223','1',1,'Retail Sale Id 1433',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 10:38:38','',''),(1271,'1','223','1',1,'Retail Sale Id 1434',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 10:45:34','',''),(1272,'1','223','1',1,'Retail Sale Id 1435',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 10:49:43','',''),(1273,'1','223','1',1,'Retail Sale Id 1436',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 10:51:27','',''),(1274,'1','223','1',1,'Retail Sale Id 1437',1500.40,0.00,0.00,2.42,77.44,'2022-03-23 11:02:53','',''),(1275,'1','223','1',1,'Retail Sale Id 1438',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 11:18:39','',''),(1276,'1','223','1',1,'Retail Sale Id 1440',30000.00,0.00,0.00,50.00,600.00,'2022-03-23 11:21:37','',''),(1277,'1','223','1',1,'Retail Sale Id 1441',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 11:25:40','',''),(1278,'1','223','1',1,'Retail Sale Id 1442',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 11:26:41','',''),(1279,'1','223','1',1,'Retail Sale Id 1444',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 11:29:42','',''),(1280,'1','223','1',1,'Retail Sale Id 1445',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 11:39:41','',''),(1281,'1','223','1',1,'Retail Sale Id 1446',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 11:41:42','',''),(1282,'1','223','1',1,'Retail Sale Id 1447',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 12:14:38','',''),(1283,'1','223','1',1,'Retail Sale Id 1448',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 12:32:11','',''),(1284,'1','223','1',1,'Retail Sale Id 1449',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 12:34:34','',''),(1285,'1','223','1',1,'Retail Sale Id 1450',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 12:38:59','',''),(1286,'1','223','1',1,'Retail Sale Id 1451',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 12:40:20','',''),(1287,'1','223','1',1,'Retail Sale Id 1452',2498.60,0.00,0.00,4.03,128.96,'2022-03-23 12:42:40','',''),(1288,'1','223','1',1,'Retail Sale Id 1453',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 12:45:17','',''),(1289,'1','223','1',1,'Retail Sale Id 1454',998.20,0.00,0.00,1.61,51.52,'2022-03-23 12:52:18','',''),(1290,'1','223','1',1,'Retail Sale Id 1455',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 12:58:16','',''),(1291,'1','223','1',1,'Retail Sale Id 1456',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 13:11:53','',''),(1292,'1','223','1',1,'Retail Sale Id 1457',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 13:15:21','',''),(1293,'1','223','1',1,'Retail Sale Id 1458',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 13:17:21','',''),(1294,'1','223','1',1,'Retail Sale Id 1459',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 13:24:58','',''),(1295,'1','223','1',1,'Retail Sale Id 1460',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 13:31:45','',''),(1296,'1','223','1',1,'Retail Sale Id 1461',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 13:36:13','',''),(1297,'1','223','1',1,'Retail Sale Id 1463',2002.60,0.00,0.00,3.23,103.36,'2022-03-23 13:46:26','',''),(1298,'1','223','1',1,'Retail Sale Id 1464',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 13:47:33','',''),(1299,'1','223','1',1,'Retail Sale Id 1465',620.00,0.00,0.00,1.00,32.00,'2022-03-23 13:53:05','',''),(1300,'1','223','1',1,'Return of Retail Sale Id 1465',0.00,620.00,1.00,0.00,-32.00,'2022-03-23 13:54:26','',''),(1301,'1','223','1',1,'Retail Sale Id 1467',651.00,0.00,0.00,1.05,33.60,'2022-03-23 13:54:59','',''),(1302,'1','223','1',1,'Retail Sale Id 1468',3602.20,0.00,0.00,5.81,185.92,'2022-03-23 13:56:01','',''),(1303,'1','223','1',1,'Retail Sale Id 1469',18000.00,0.00,0.00,30.00,360.00,'2022-03-23 14:11:45','',''),(1304,'1','223','1',1,'Retail Sale Id 1470',30000.00,0.00,0.00,50.00,600.00,'2022-03-23 14:29:43','',''),(1305,'1','223','1',1,'Retail Sale Id 1471',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 14:34:04','',''),(1306,'1','223','1',1,'Retail Sale Id 1472',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 14:39:48','',''),(1307,'1','223','1',1,'Retail Sale Id 1473',3503.00,0.00,0.00,5.65,180.80,'2022-03-23 14:41:12','',''),(1308,'1','223','1',1,'Retail Sale Id 1474',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 14:44:46','',''),(1309,'1','223','1',1,'Retail Sale Id 1475',651.00,0.00,0.00,1.05,33.60,'2022-03-23 14:46:00','',''),(1310,'1','223','1',1,'Retail Sale Id 1476',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 14:49:52','',''),(1311,'1','223','1',1,'Retail Sale Id 1477',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 14:51:46','',''),(1312,'1','223','1',1,'Retail Sale Id 1478',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 14:53:17','',''),(1313,'1','223','1',1,'Retail Sale Id 1479',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 14:54:26','',''),(1314,'1','223','1',1,'Retail Sale Id 1480',1500.40,0.00,0.00,2.42,77.44,'2022-03-23 14:57:31','',''),(1315,'1','223','1',1,'Retail Sale Id 1481',799.80,0.00,0.00,1.29,41.28,'2022-03-23 15:01:54','',''),(1316,'1','223','1',1,'Retail Sale Id 1482',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 15:13:22','',''),(1317,'1','223','1',1,'Retail Sale Id 1483',2498.60,0.00,0.00,4.03,128.96,'2022-03-23 15:14:50','',''),(1318,'1','223','1',1,'Retail Sale Id 1484',3751.00,0.00,0.00,6.05,193.60,'2022-03-23 15:25:05','',''),(1319,'1','223','1',1,'Retail Sale Id 1485',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 15:31:52','',''),(1320,'1','223','1',1,'Retail Sale Id 1486',1798.00,0.00,0.00,2.90,92.80,'2022-03-23 15:33:31','',''),(1321,'1','223','1',1,'Retail Sale Id 1487',7452.40,0.00,0.00,12.02,384.64,'2022-03-23 15:36:45','',''),(1322,'1','223','1',1,'Retail Sale Id 1488',2498.60,0.00,0.00,4.03,128.96,'2022-03-23 15:44:29','',''),(1323,'1','223','1',1,'Retail Sale Id 1489',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 15:46:28','',''),(1324,'1','223','1',1,'Retail Sale Id 1490',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 15:47:54','',''),(1325,'1','223','1',1,'Retail Sale Id 1491',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 15:49:29','',''),(1326,'1','223','1',1,'Retail Sale Id 1492',2498.60,0.00,0.00,4.03,128.96,'2022-03-23 15:50:33','',''),(1327,'1','223','1',1,'Retail Sale Id 1494',3751.00,0.00,0.00,6.05,193.60,'2022-03-23 15:52:31','',''),(1328,'1','223','1',1,'Retail Sale Id 1495',1202.80,0.00,0.00,1.94,62.08,'2022-03-23 15:57:48','',''),(1329,'1','223','1',1,'Retail Sale Id 1496',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 16:00:37','',''),(1330,'1','223','1',1,'Retail Sale Id 1497',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 16:02:11','',''),(1331,'1','223','1',1,'Retail Sale Id 1498',620.00,0.00,0.00,1.00,32.00,'2022-03-23 16:03:21','',''),(1332,'1','223','1',1,'Retail Sale Id 1499',2498.60,0.00,0.00,4.03,128.96,'2022-03-23 16:08:46','',''),(1333,'1','223','1',1,'Retail Sale Id 1500',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 16:09:29','',''),(1334,'1','223','1',1,'Retail Sale Id 1501',998.20,0.00,0.00,1.61,51.52,'2022-03-23 16:10:33','',''),(1335,'1','223','1',1,'Retail Sale Id 1502',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 16:11:23','',''),(1336,'1','223','1',1,'Retail Sale Id 1503',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 16:12:12','',''),(1337,'1','223','1',1,'Retail Sale Id 1507',2480.00,0.00,0.00,4.00,128.00,'2022-03-23 16:15:01','',''),(1338,'1','223','1',1,'Retail Sale Id 1508',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 16:25:52','',''),(1339,'1','223','1',1,'Retail Sale Id 1509',1698.80,0.00,0.00,2.74,87.68,'2022-03-23 16:27:10','',''),(1340,'1','223','1',1,'Retail Sale Id 1510',1599.60,0.00,0.00,2.58,82.56,'2022-03-23 16:33:11','',''),(1341,'1','223','1',1,'Retail Sale Id 1511',3751.00,0.00,0.00,6.05,193.60,'2022-03-23 16:34:18','',''),(1342,'1','223','1',1,'Retail Sale Id 1512',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 16:38:03','',''),(1343,'1','223','1',1,'Retail Sale Id 1513',2498.60,0.00,0.00,4.03,128.96,'2022-03-23 16:39:35','',''),(1344,'1','223','1',1,'Retail Sale Id 1514',7750.00,0.00,0.00,12.50,400.00,'2022-03-23 16:42:43','',''),(1345,'1','223','1',1,'Retail Sale Id 1515',3701.40,0.00,0.00,5.97,191.04,'2022-03-23 16:45:10','',''),(1346,'1','223','1',1,'Retail Sale Id 1516',1847.60,0.00,0.00,2.98,95.36,'2022-03-23 16:47:18','',''),(1347,'1','223','1',1,'Retail Sale Id 1517',6820.00,0.00,0.00,11.00,352.00,'2022-03-23 16:48:46','',''),(1348,'1','223','1',1,'Retail Sale Id 1518',7750.00,0.00,0.00,12.50,400.00,'2022-03-23 16:50:40','',''),(1349,'1','223','1',1,'Retail Sale Id 1519',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 16:54:11','',''),(1350,'1','223','1',1,'Retail Sale Id 1520',1847.60,0.00,0.00,2.98,95.36,'2022-03-23 16:56:40','',''),(1351,'1','223','1',1,'Retail Sale Id 1521',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 16:59:52','',''),(1352,'1','223','1',1,'Retail Sale Id 1522',3751.00,0.00,0.00,6.05,193.60,'2022-03-23 17:02:30','',''),(1353,'1','223','1',1,'Retail Sale Id 1523',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 17:03:10','',''),(1354,'1','223','1',1,'Retail Sale Id 1524',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 17:04:25','',''),(1355,'1','223','1',1,'Return of Retail Sale Id 1519',0.00,3720.00,6.00,0.00,-192.00,'2022-03-23 17:05:33','',''),(1356,'1','223','1',1,'Retail Sale Id 1525',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 17:05:48','',''),(1357,'1','223','1',1,'Retail Sale Id 1526',2002.60,0.00,0.00,3.23,103.36,'2022-03-23 17:07:06','',''),(1358,'1','223','1',1,'Retail Sale Id 1527',2498.60,0.00,0.00,4.03,128.96,'2022-03-23 17:08:29','',''),(1359,'1','223','1',1,'Retail Sale Id 1528',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 17:10:03','',''),(1360,'1','223','1',1,'Retail Sale Id 1529',620.00,0.00,0.00,1.00,32.00,'2022-03-23 17:11:53','',''),(1361,'1','223','1',1,'Retail Sale Id 1530',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 17:12:58','',''),(1362,'1','223','1',1,'Retail Sale Id 1531',2002.60,0.00,0.00,3.23,103.36,'2022-03-23 17:13:50','',''),(1363,'1','223','1',1,'Retail Sale Id 1532',105000.00,0.00,0.00,175.00,2100.00,'2022-03-23 17:21:01','',''),(1364,'1','223','1',1,'Retail Sale Id 1533',998.20,0.00,0.00,1.61,51.52,'2022-03-23 17:23:19','',''),(1365,'1','223','1',1,'Retail Sale Id 1534',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 17:24:37','',''),(1366,'1','223','1',1,'Retail Sale Id 1535',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 17:26:46','',''),(1367,'1','223','1',1,'Retail Sale Id 1536',2480.00,0.00,0.00,4.00,128.00,'2022-03-23 17:28:20','',''),(1368,'1','223','1',1,'Retail Sale Id 1537',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 17:32:34','',''),(1369,'1','223','1',1,'Retail Sale Id 1539',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 17:34:05','',''),(1370,'1','223','1',1,'Retail Sale Id 1540',3751.00,0.00,0.00,6.05,193.60,'2022-03-23 17:35:36','',''),(1371,'1','223','1',1,'Retail Sale Id 1541',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 17:37:16','',''),(1372,'1','223','1',1,'Retail Sale Id 1542',2480.00,0.00,0.00,4.00,128.00,'2022-03-23 17:38:23','',''),(1373,'1','223','1',1,'Retail Sale Id 1543',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 17:39:41','',''),(1374,'1','223','1',1,'Retail Sale Id 1544',620.00,0.00,0.00,1.00,32.00,'2022-03-23 17:40:38','',''),(1375,'1','223','1',1,'Retail Sale Id 1545',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 17:42:01','',''),(1376,'1','223','1',1,'Retail Sale Id 1546',5580.00,0.00,0.00,9.00,288.00,'2022-03-23 17:44:43','',''),(1377,'1','223','1',1,'Retail Sale Id 1547',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 17:47:10','',''),(1378,'1','223','1',1,'Retail Sale Id 1548',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 17:50:13','',''),(1379,'1','223','1',1,'Retail Sale Id 1549',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 17:51:25','',''),(1380,'1','223','1',1,'Retail Sale Id 1550',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 17:53:07','',''),(1381,'1','223','1',1,'Retail Sale Id 1551',1202.80,0.00,0.00,1.94,62.08,'2022-03-23 17:56:18','',''),(1382,'1','223','1',1,'Retail Sale Id 1552',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 17:59:11','',''),(1383,'1','223','1',1,'Retail Sale Id 1553',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 18:02:11','',''),(1384,'1','223','1',1,'Retail Sale Id 1554',3751.00,0.00,0.00,6.05,193.60,'2022-03-23 18:06:37','',''),(1385,'1','223','1',1,'Retail Sale Id 1555',1798.00,0.00,0.00,2.90,92.80,'2022-03-23 18:07:42','',''),(1386,'1','223','1',1,'Retail Sale Id 1556',1798.00,0.00,0.00,2.90,92.80,'2022-03-23 18:08:50','',''),(1387,'1','223','1',1,'Retail Sale Id 1557',3751.00,0.00,0.00,6.05,193.60,'2022-03-23 18:10:12','',''),(1388,'1','223','1',1,'Retail Sale Id 1558',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 18:11:21','',''),(1389,'1','223','1',1,'Retail Sale Id 1559',998.20,0.00,0.00,1.61,51.52,'2022-03-23 18:12:32','',''),(1390,'1','223','1',1,'Retail Sale Id 1560',6200.00,0.00,0.00,10.00,320.00,'2022-03-23 18:13:36','',''),(1391,'1','223','1',1,'Retail Sale Id 1561',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 18:14:59','',''),(1392,'1','223','1',1,'Retail Sale Id 1562',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 18:15:53','',''),(1393,'1','223','1',1,'Retail Sale Id 1563',3751.00,0.00,0.00,6.05,193.60,'2022-03-23 18:17:37','',''),(1394,'1','223','1',1,'Retail Sale Id 1564',620.00,0.00,0.00,1.00,32.00,'2022-03-23 18:19:19','',''),(1395,'1','223','1',1,'Retail Sale Id 1565',1202.80,0.00,0.00,1.94,62.08,'2022-03-23 18:21:17','',''),(1396,'1','223','1',1,'Retail Sale Id 1566',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 18:23:44','',''),(1397,'1','223','1',1,'Retail Sale Id 1567',620.00,0.00,0.00,1.00,32.00,'2022-03-23 18:25:36','',''),(1398,'1','223','1',1,'Retail Sale Id 1568',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 18:26:47','',''),(1399,'1','223','1',1,'Retail Sale Id 1569',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 18:27:59','',''),(1400,'1','223','1',1,'Retail Sale Id 1570',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 18:29:30','',''),(1401,'1','223','1',1,'Retail Sale Id 1571',6200.00,0.00,0.00,10.00,320.00,'2022-03-23 18:30:24','',''),(1402,'1','223','1',1,'Retail Sale Id 1572',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 18:32:27','',''),(1403,'1','223','1',1,'Retail Sale Id 1573',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 18:33:24','',''),(1404,'1','223','1',1,'Retail Sale Id 1574',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 18:34:33','',''),(1405,'1','223','1',1,'Retail Sale Id 1575',1202.80,0.00,0.00,1.94,62.08,'2022-03-23 18:35:27','',''),(1406,'1','223','1',1,'Retail Sale Id 1576',1202.80,0.00,0.00,1.94,62.08,'2022-03-23 18:36:35','',''),(1407,'1','223','1',1,'Retail Sale Id 1577',1847.60,0.00,0.00,2.98,95.36,'2022-03-23 18:38:25','',''),(1408,'1','223','1',1,'Retail Sale Id 1578',1240.00,0.00,0.00,2.00,64.00,'2022-03-23 18:39:47','',''),(1409,'1','223','1',1,'Retail Sale Id 1579',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 18:45:17','',''),(1410,'1','223','1',1,'Retail Sale Id 1580',3720.00,0.00,0.00,6.00,192.00,'2022-03-23 19:00:18','',''),(1411,'1','223','1',1,'Retail Sale Id 1581',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 19:01:36','',''),(1412,'1','223','1',1,'Retail Sale Id 1582',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 19:06:36','',''),(1413,'1','223','1',1,'Retail Sale Id 1583',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 19:09:57','',''),(1414,'1','223','1',1,'Retail Sale Id 1584',1302.00,0.00,0.00,2.10,67.20,'2022-03-23 19:12:03','',''),(1415,'1','223','1',1,'Retail Sale Id 1585',3100.00,0.00,0.00,5.00,160.00,'2022-03-23 19:16:17','',''),(1416,'1','223','1',1,'Retail Sale Id 1586',1897.20,0.00,0.00,3.06,97.92,'2022-03-23 19:17:43','',''),(1417,'1','223','1',1,'Retail Sale Id 1587',1252.40,0.00,0.00,2.02,64.64,'2022-03-23 19:18:50','',''),(1418,'1','223','1',1,'Retail Sale Id 1588',1860.00,0.00,0.00,3.00,96.00,'2022-03-23 19:19:57','',''),(1419,'1','223','1',1,'Return of Retail Sale Id 1469',0.00,18000.00,30.00,0.00,-360.00,'2022-03-23 19:56:57','',''),(1420,'1','223','1',1,'Retail Sale Id 1589',18252.00,0.00,0.00,30.42,365.04,'2022-03-23 19:58:20','',''),(1421,'1','223','1',1,'Return of Retail Sale Id 1587',0.00,1252.40,2.02,0.00,-64.64,'2022-03-23 19:59:43','',''),(1422,'1','223','1',1,'Retail Sale Id 1590',2219.60,0.00,0.00,3.58,114.56,'2022-03-23 20:00:32','',''),(1423,'1','223','1',1,'Retail Sale Id 1591',1240.00,0.00,0.00,2.00,64.00,'2022-03-24 06:48:42','',''),(1424,'1','223','1',1,'Retail Sale Id 1592',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 07:09:01','',''),(1425,'1','223','1',1,'Retail Sale Id 1593',700.60,0.00,0.00,1.13,36.16,'2022-03-24 07:17:01','',''),(1426,'1','223','1',1,'Retail Sale Id 1594',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 07:38:08','',''),(1427,'1','223','1',1,'Retail Sale Id 1595',651.00,0.00,0.00,1.05,33.60,'2022-03-24 07:39:17','',''),(1428,'1','223','1',1,'Retail Sale Id 1596',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 07:49:57','',''),(1429,'1','223','1',1,'Retail Sale Id 1597',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 07:57:07','',''),(1430,'1','223','1',1,'Retail Sale Id 1598',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 07:58:51','',''),(1431,'1','223','1',1,'Retail Sale Id 1599',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 08:01:09','',''),(1432,'1','223','1',1,'Retail Sale Id 1600',1500.40,0.00,0.00,2.42,77.44,'2022-03-24 10:10:09','',''),(1433,'1','223','1',1,'Retail Sale Id 1601',25680.40,0.00,0.00,41.42,1325.44,'2022-03-24 10:12:33','',''),(1434,'1','223','1',1,'Retail Sale Id 1602',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 10:16:11','',''),(1435,'1','223','1',1,'Retail Sale Id 1604',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 10:17:36','',''),(1436,'1','223','1',1,'Retail Sale Id 1605',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 10:18:25','',''),(1437,'1','223','1',1,'Retail Sale Id 1606',37621.60,0.00,0.00,60.68,1941.76,'2022-03-24 10:20:58','',''),(1438,'1','223','1',1,'Retail Sale Id 1607',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 10:27:27','',''),(1439,'1','223','1',1,'Retail Sale Id 1608',7750.00,0.00,0.00,12.50,400.00,'2022-03-24 10:29:06','',''),(1440,'1','223','1',1,'Retail Sale Id 1609',1878.60,0.00,0.00,3.03,96.96,'2022-03-24 10:34:45','',''),(1441,'1','223','1',1,'Retail Sale Id 1610',30000.00,0.00,0.00,50.00,600.00,'2022-03-24 10:38:06','',''),(1442,'1','223','1',1,'Retail Sale Id 1611',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 10:39:58','',''),(1443,'1','223','1',1,'Retail Sale Id 1612',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 10:43:34','',''),(1444,'1','223','1',1,'Retail Sale Id 1613',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 10:47:43','',''),(1445,'1','223','1',1,'Retail Sale Id 1614',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 10:48:48','',''),(1446,'1','223','1',1,'Retail Sale Id 1615',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 10:49:58','',''),(1447,'1','223','1',1,'Retail Sale Id 1616',2480.00,0.00,0.00,4.00,128.00,'2022-03-24 10:50:36','',''),(1448,'1','223','1',1,'Retail Sale Id 1617',4960.00,0.00,0.00,8.00,256.00,'2022-03-24 10:51:38','',''),(1449,'1','223','1',1,'Retail Sale Id 1618',700.60,0.00,0.00,1.13,36.16,'2022-03-24 10:53:05','',''),(1450,'1','223','1',1,'Retail Sale Id 1619',651.00,0.00,0.00,1.05,33.60,'2022-03-24 10:56:36','',''),(1451,'1','223','1',1,'Retail Sale Id 1620',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 10:57:46','',''),(1452,'1','223','1',1,'Retail Sale Id 1621',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 10:59:23','',''),(1453,'1','223','1',1,'Retail Sale Id 1622',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 11:02:17','',''),(1454,'1','223','1',1,'Retail Sale Id 1623',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 11:03:29','',''),(1455,'1','223','1',1,'Retail Sale Id 1624',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 11:04:43','',''),(1456,'1','223','1',1,'Retail Sale Id 1627',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 11:17:18','',''),(1457,'1','223','1',1,'Retail Sale Id 1628',66000.00,0.00,0.00,110.00,1320.00,'2022-03-24 11:25:22','',''),(1458,'1','223','1',1,'Retail Sale Id 1629',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 11:38:19','',''),(1459,'1','223','1',1,'Retail Sale Id 1630',26502.00,0.00,0.00,44.17,530.04,'2022-03-24 11:49:30','',''),(1460,'1','223','1',1,'Retail Sale Id 1631',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 11:51:20','',''),(1461,'1','223','1',1,'Retail Sale Id 1632',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 11:53:04','',''),(1462,'1','223','1',1,'Return of Retail Sale Id 1630',0.00,26502.00,44.17,0.00,-530.04,'2022-03-24 12:00:23','',''),(1463,'1','223','1',1,'Retail Sale Id 1633',30000.00,0.00,0.00,50.00,600.00,'2022-03-24 12:01:19','',''),(1464,'1','223','1',1,'Retail Sale Id 1634',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 12:07:26','',''),(1465,'1','223','1',1,'Retail Sale Id 1635',7750.00,0.00,0.00,12.50,400.00,'2022-03-24 12:15:00','',''),(1466,'1','223','1',1,'Retail Sale Id 1636',651.00,0.00,0.00,1.05,33.60,'2022-03-24 12:23:05','',''),(1467,'1','223','1',1,'Retail Sale Id 1637',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 12:24:32','',''),(1468,'1','223','1',1,'Retail Sale Id 1638',1798.00,0.00,0.00,2.90,92.80,'2022-03-24 12:37:44','',''),(1469,'1','223','1',1,'Retail Sale Id 1639',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 12:40:43','',''),(1470,'1','223','1',1,'Retail Sale Id 1640',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 12:52:14','',''),(1471,'1','223','1',1,'Retail Sale Id 1641',651.00,0.00,0.00,1.05,33.60,'2022-03-24 13:02:21','',''),(1472,'1','223','1',1,'Retail Sale Id 1642',2498.60,0.00,0.00,4.03,128.96,'2022-03-24 13:04:50','',''),(1473,'1','223','1',1,'Retail Sale Id 1643',7750.00,0.00,0.00,12.50,400.00,'2022-03-24 13:12:37','',''),(1474,'1','223','1',1,'Retail Sale Id 1644',30000.00,0.00,0.00,50.00,600.00,'2022-03-24 13:25:55','',''),(1475,'1','223','1',1,'Retail Sale Id 1645',1500.40,0.00,0.00,2.42,77.44,'2022-03-24 13:27:38','',''),(1476,'1','223','1',1,'Retail Sale Id 1646',3751.00,0.00,0.00,6.05,193.60,'2022-03-24 13:37:22','',''),(1477,'1','223','1',1,'Retail Sale Id 1649',3000.80,0.00,0.00,4.84,154.88,'2022-03-24 13:40:17','',''),(1478,'1','223','1',1,'Retail Sale Id 1650',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 13:42:44','',''),(1479,'1','223','1',1,'Retail Sale Id 1651',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 13:47:26','',''),(1480,'1','223','1',1,'Retail Sale Id 1652',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 14:00:21','',''),(1481,'1','223','1',1,'Retail Sale Id 1653',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 14:17:26','',''),(1482,'1','223','1',1,'Retail Sale Id 1654',1698.80,0.00,0.00,2.74,87.68,'2022-03-24 14:19:07','',''),(1483,'1','223','1',1,'Retail Sale Id 1655',1798.00,0.00,0.00,2.90,92.80,'2022-03-24 14:20:34','',''),(1484,'1','223','1',1,'Retail Sale Id 1656',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 14:23:24','',''),(1485,'1','223','1',1,'Retail Sale Id 1657',3751.00,0.00,0.00,6.05,193.60,'2022-03-24 14:24:38','',''),(1486,'1','223','1',1,'Retail Sale Id 1658',6200.00,0.00,0.00,10.00,320.00,'2022-03-24 14:25:43','',''),(1487,'1','223','1',1,'Retail Sale Id 1659',3751.00,0.00,0.00,6.05,193.60,'2022-03-24 14:26:56','',''),(1488,'1','223','1',1,'Retail Sale Id 1660',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 14:30:27','',''),(1489,'1','223','1',1,'Retail Sale Id 1661',1847.60,0.00,0.00,2.98,95.36,'2022-03-24 14:39:31','',''),(1490,'1','223','1',1,'Retail Sale Id 1662',3751.00,0.00,0.00,6.05,193.60,'2022-03-24 14:41:29','',''),(1491,'1','223','1',1,'Retail Sale Id 1663',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 14:52:41','',''),(1492,'1','223','1',1,'Retail Sale Id 1664',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 15:06:00','',''),(1493,'1','223','1',1,'Retail Sale Id 1665',3751.00,0.00,0.00,6.05,193.60,'2022-03-24 15:08:02','',''),(1494,'1','223','1',1,'Retail Sale Id 1666',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 15:09:16','',''),(1495,'1','223','1',1,'Retail Sale Id 1667',1847.60,0.00,0.00,2.98,95.36,'2022-03-24 15:10:28','',''),(1496,'1','223','1',1,'Retail Sale Id 1668',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 15:12:29','',''),(1497,'1','223','1',1,'Retail Sale Id 1669',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 15:14:14','',''),(1498,'1','223','1',1,'Retail Sale Id 1670',1240.00,0.00,0.00,2.00,64.00,'2022-03-24 15:15:54','',''),(1499,'1','223','1',1,'Retail Sale Id 1671',2498.60,0.00,0.00,4.03,128.96,'2022-03-24 15:18:04','',''),(1500,'1','223','1',1,'Retail Sale Id 1672',2498.60,0.00,0.00,4.03,128.96,'2022-03-24 15:19:50','',''),(1501,'1','223','1',1,'Retail Sale Id 1673',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 15:21:06','',''),(1502,'1','223','1',1,'Retail Sale Id 1674',3503.00,0.00,0.00,5.65,180.80,'2022-03-24 15:25:59','',''),(1503,'1','223','1',1,'Retail Sale Id 1675',1500.40,0.00,0.00,2.42,77.44,'2022-03-24 15:29:00','',''),(1504,'1','223','1',1,'Retail Sale Id 1676',998.20,0.00,0.00,1.61,51.52,'2022-03-24 15:30:09','',''),(1505,'1','223','1',1,'Retail Sale Id 1677',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 15:31:15','',''),(1506,'1','223','1',1,'Retail Sale Id 1678',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 15:35:35','',''),(1507,'1','223','1',1,'Retail Sale Id 1679',2002.60,0.00,0.00,3.23,103.36,'2022-03-24 15:37:55','',''),(1508,'1','223','1',1,'Retail Sale Id 1681',1847.60,0.00,0.00,2.98,95.36,'2022-03-24 15:42:28','',''),(1509,'1','223','1',1,'Retail Sale Id 1682',3751.00,0.00,0.00,6.05,193.60,'2022-03-24 15:45:24','',''),(1510,'1','223','1',1,'Retail Sale Id 1683',3751.00,0.00,0.00,6.05,193.60,'2022-03-24 15:50:45','',''),(1511,'1','223','1',1,'Retail Sale Id 1684',2498.60,0.00,0.00,4.03,128.96,'2022-03-24 15:58:49','',''),(1512,'1','223','1',1,'Retail Sale Id 1685',1401.20,0.00,0.00,2.26,72.32,'2022-03-24 16:06:17','',''),(1513,'1','223','1',1,'Retail Sale Id 1686',21000.00,0.00,0.00,35.00,420.00,'2022-03-24 16:24:58','',''),(1514,'1','223','1',1,'Retail Sale Id 1687',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 16:27:24','',''),(1515,'1','223','1',1,'Retail Sale Id 1688',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 16:28:30','',''),(1516,'1','223','1',1,'Retail Sale Id 1689',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 16:29:57','',''),(1517,'1','223','1',1,'Retail Sale Id 1690',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 16:33:23','',''),(1518,'1','223','1',1,'Retail Sale Id 1691',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 16:34:25','',''),(1519,'1','223','1',1,'Retail Sale Id 1692',7750.00,0.00,0.00,12.50,400.00,'2022-03-24 16:35:34','',''),(1520,'1','223','1',1,'Retail Sale Id 1693',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 16:36:46','',''),(1521,'1','223','1',1,'Retail Sale Id 1694',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 16:37:50','',''),(1522,'1','223','1',1,'Retail Sale Id 1695',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 16:39:35','',''),(1523,'1','223','1',1,'Retail Sale Id 1696',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 16:40:51','',''),(1524,'1','223','1',1,'Retail Sale Id 1697',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 16:42:31','',''),(1525,'1','223','1',1,'Retail Sale Id 1698',7750.00,0.00,0.00,12.50,400.00,'2022-03-24 16:43:34','',''),(1526,'1','223','1',1,'Retail Sale Id 1699',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 16:44:35','',''),(1527,'1','223','1',1,'Retail Sale Id 1700',620.00,0.00,0.00,1.00,32.00,'2022-03-24 16:45:22','',''),(1528,'1','223','1',1,'Retail Sale Id 1701',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 16:46:43','',''),(1529,'1','223','1',1,'Retail Sale Id 1702',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 16:47:51','',''),(1530,'1','223','1',1,'Retail Sale Id 1703',1847.60,0.00,0.00,2.98,95.36,'2022-03-24 16:48:55','',''),(1531,'1','223','1',1,'Retail Sale Id 1704',3000.80,0.00,0.00,4.84,154.88,'2022-03-24 16:50:02','',''),(1532,'1','223','1',1,'Retail Sale Id 1705',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 16:51:03','',''),(1533,'1','223','1',1,'Retail Sale Id 1706',9300.00,0.00,0.00,15.00,480.00,'2022-03-24 16:54:07','',''),(1534,'1','223','1',1,'Retail Sale Id 1707',1240.00,0.00,0.00,2.00,64.00,'2022-03-24 16:55:48','',''),(1535,'1','223','1',1,'Retail Sale Id 1708',2498.60,0.00,0.00,4.03,128.96,'2022-03-24 16:57:11','',''),(1536,'1','223','1',1,'Retail Sale Id 1709',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 16:58:46','',''),(1537,'1','223','1',1,'Retail Sale Id 1710',998.20,0.00,0.00,1.61,51.52,'2022-03-24 17:01:39','',''),(1538,'1','223','1',1,'Retail Sale Id 1711',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 17:02:39','',''),(1539,'1','223','1',1,'Retail Sale Id 1712',7750.00,0.00,0.00,12.50,400.00,'2022-03-24 17:03:43','',''),(1540,'1','223','1',1,'Retail Sale Id 1713',620.00,0.00,0.00,1.00,32.00,'2022-03-24 17:05:05','',''),(1541,'1','223','1',1,'Retail Sale Id 1714',620.00,0.00,0.00,1.00,32.00,'2022-03-24 17:05:58','',''),(1542,'1','223','1',1,'Retail Sale Id 1715',2480.00,0.00,0.00,4.00,128.00,'2022-03-24 17:07:25','',''),(1543,'1','223','1',1,'Retail Sale Id 1716',2002.60,0.00,0.00,3.23,103.36,'2022-03-24 17:08:30','',''),(1544,'1','223','1',1,'Retail Sale Id 1717',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 17:09:29','',''),(1545,'1','223','1',1,'Retail Sale Id 1718',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 17:10:36','',''),(1546,'1','223','1',1,'Retail Sale Id 1719',1698.80,0.00,0.00,2.74,87.68,'2022-03-24 17:11:36','',''),(1547,'1','223','1',1,'Retail Sale Id 1720',1798.00,0.00,0.00,2.90,92.80,'2022-03-24 17:14:05','',''),(1548,'1','223','1',1,'Retail Sale Id 1721',3701.40,0.00,0.00,5.97,191.04,'2022-03-24 17:20:07','',''),(1549,'1','223','1',1,'Retail Sale Id 1722',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 17:23:48','',''),(1550,'1','223','1',1,'Retail Sale Id 1723',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 17:24:58','',''),(1551,'1','223','1',1,'Retail Sale Id 1724',3701.40,0.00,0.00,5.97,191.04,'2022-03-24 17:28:06','',''),(1552,'1','223','1',1,'Retail Sale Id 1725',998.20,0.00,0.00,1.61,51.52,'2022-03-24 17:29:06','',''),(1553,'1','223','1',1,'Retail Sale Id 1726',1798.00,0.00,0.00,2.90,92.80,'2022-03-24 17:30:24','',''),(1554,'1','223','1',1,'Retail Sale Id 1727',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 17:31:41','',''),(1555,'1','223','1',1,'Retail Sale Id 1728',1847.60,0.00,0.00,2.98,95.36,'2022-03-24 17:33:39','',''),(1556,'1','223','1',1,'Retail Sale Id 1729',1302.00,0.00,0.00,2.10,67.20,'2022-03-24 17:36:17','',''),(1557,'1','223','1',1,'Retail Sale Id 1730',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 17:39:05','',''),(1558,'1','223','1',1,'Retail Sale Id 1731',651.00,0.00,0.00,1.05,33.60,'2022-03-24 17:45:02','',''),(1559,'1','223','1',1,'Retail Sale Id 1732',1847.60,0.00,0.00,2.98,95.36,'2022-03-24 17:46:04','',''),(1560,'1','223','1',1,'Retail Sale Id 1733',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 17:46:40','',''),(1561,'1','223','1',1,'Retail Sale Id 1734',2498.60,0.00,0.00,4.03,128.96,'2022-03-24 17:49:29','',''),(1562,'1','223','1',1,'Retail Sale Id 1735',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 17:50:37','',''),(1563,'1','223','1',1,'Retail Sale Id 1736',1202.80,0.00,0.00,1.94,62.08,'2022-03-24 17:51:47','',''),(1564,'1','223','1',1,'Retail Sale Id 1737',3999.00,0.00,0.00,6.45,206.40,'2022-03-24 17:54:05','',''),(1565,'1','223','1',1,'Retail Sale Id 1738',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 17:56:16','',''),(1566,'1','223','1',1,'Retail Sale Id 1739',1202.80,0.00,0.00,1.94,62.08,'2022-03-24 17:57:37','',''),(1567,'1','223','1',1,'Retail Sale Id 1740',1240.00,0.00,0.00,2.00,64.00,'2022-03-24 17:58:27','',''),(1568,'1','223','1',1,'Retail Sale Id 1742',1240.00,0.00,0.00,2.00,64.00,'2022-03-24 17:59:03','',''),(1569,'1','223','1',1,'Retail Sale Id 1743',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 18:00:19','',''),(1570,'1','223','1',1,'Retail Sale Id 1744',1500.40,0.00,0.00,2.42,77.44,'2022-03-24 18:01:17','',''),(1571,'1','223','1',1,'Retail Sale Id 1745',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 18:02:55','',''),(1572,'1','223','1',1,'Retail Sale Id 1746',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 18:04:00','',''),(1573,'1','223','1',1,'Retail Sale Id 1747',1897.20,0.00,0.00,3.06,97.92,'2022-03-24 18:08:25','',''),(1574,'1','223','1',1,'Retail Sale Id 1748',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 18:10:41','',''),(1575,'1','223','1',1,'Retail Sale Id 1749',998.20,0.00,0.00,1.61,51.52,'2022-03-24 18:14:36','',''),(1576,'1','223','1',1,'Retail Sale Id 1750',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 18:19:17','',''),(1577,'1','223','1',1,'Retail Sale Id 1751',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 18:20:16','',''),(1578,'1','223','1',1,'Retail Sale Id 1752',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 18:22:14','',''),(1579,'1','223','1',1,'Retail Sale Id 1753',1798.00,0.00,0.00,2.90,92.80,'2022-03-24 18:24:17','',''),(1580,'1','223','1',1,'Retail Sale Id 1754',998.20,0.00,0.00,1.61,51.52,'2022-03-24 18:25:11','',''),(1581,'1','223','1',1,'Return of Retail Sale Id 1606',0.00,37621.60,60.68,0.00,-1941.76,'2022-03-24 18:29:53','',''),(1582,'1','223','1',1,'Retail Sale Id 1755',2002.60,0.00,0.00,3.23,103.36,'2022-03-24 18:30:26','',''),(1583,'1','223','1',1,'Retail Sale Id 1756',37454.20,0.00,0.00,60.41,1933.12,'2022-03-24 18:31:25','',''),(1584,'1','223','1',1,'Retail Sale Id 1757',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 18:32:09','',''),(1585,'1','223','1',1,'Retail Sale Id 1758',6200.00,0.00,0.00,10.00,320.00,'2022-03-24 18:33:12','',''),(1586,'1','223','1',1,'Retail Sale Id 1759',2498.60,0.00,0.00,4.03,128.96,'2022-03-24 18:36:02','',''),(1587,'1','223','1',1,'Retail Sale Id 1760',1302.00,0.00,0.00,2.10,67.20,'2022-03-24 18:38:20','',''),(1588,'1','223','1',1,'Retail Sale Id 1761',3100.00,0.00,0.00,5.00,160.00,'2022-03-24 18:40:14','',''),(1589,'1','223','1',1,'Retail Sale Id 1762',1860.00,0.00,0.00,3.00,96.00,'2022-03-24 18:41:37','',''),(1590,'1','223','1',1,'Retail Sale Id 1763',3720.00,0.00,0.00,6.00,192.00,'2022-03-24 18:42:52','',''),(1591,'1','223','1',1,'Retail Sale Id 1764',2498.60,0.00,0.00,4.03,128.96,'2022-03-24 18:44:07','',''),(1592,'1','223','1',1,'Retail Sale Id 1765',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 18:45:20','',''),(1593,'1','223','1',1,'Retail Sale Id 1766',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 18:47:40','',''),(1594,'1','223','1',1,'Retail Sale Id 1767',3751.00,0.00,0.00,6.05,193.60,'2022-03-24 19:03:35','',''),(1595,'1','223','1',1,'Retail Sale Id 1768',1202.80,0.00,0.00,1.94,62.08,'2022-03-24 19:04:44','',''),(1596,'1','223','1',1,'Retail Sale Id 1769',1252.40,0.00,0.00,2.02,64.64,'2022-03-24 19:06:30','',''),(1597,'1','223','1',1,'Retail Sale Id 1770',1240.00,0.00,0.00,2.00,64.00,'2022-03-24 19:13:14','',''),(1598,'1','223','1',1,'Retail Sale Id 1771',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 07:04:02','',''),(1599,'1','223','1',1,'Retail Sale Id 1772',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 07:21:23','',''),(1600,'1','223','1',1,'Retail Sale Id 1773',2498.60,0.00,0.00,4.03,128.96,'2022-03-25 07:30:26','',''),(1601,'1','223','1',1,'Retail Sale Id 1774',1240.00,0.00,0.00,2.00,64.00,'2022-03-25 07:31:14','',''),(1602,'1','223','1',1,'Retail Sale Id 1775',2498.60,0.00,0.00,4.03,128.96,'2022-03-25 07:37:52','',''),(1603,'1','223','1',1,'Retail Sale Id 1776',1500.40,0.00,0.00,2.42,77.44,'2022-03-25 07:38:37','',''),(1604,'1','223','1',1,'Retail Sale Id 1777',3800.60,0.00,0.00,6.13,196.16,'2022-03-25 07:58:30','',''),(1605,'1','223','1',1,'Retail Sale Id 1778',700.60,0.00,0.00,1.13,36.16,'2022-03-25 08:10:28','',''),(1606,'1','223','1',1,'Retail Sale Id 1779',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 08:11:25','',''),(1607,'1','223','1',1,'Retail Sale Id 1780',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 08:15:39','',''),(1608,'1','223','1',1,'Retail Sale Id 1781',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 08:16:20','',''),(1609,'1','223','1',1,'Retail Sale Id 1782',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 08:25:08','',''),(1610,'1','223','1',1,'Retail Sale Id 1783',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 08:26:57','',''),(1611,'1','223','1',1,'Retail Sale Id 1784',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 08:29:35','',''),(1612,'1','223','1',1,'Retail Sale Id 1785',2498.60,0.00,0.00,4.03,128.96,'2022-03-25 08:30:38','',''),(1613,'1','223','1',1,'Retail Sale Id 1786',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 08:36:03','',''),(1614,'1','223','1',1,'Retail Sale Id 1787',1240.00,0.00,0.00,2.00,64.00,'2022-03-25 08:39:21','',''),(1615,'1','223','1',1,'Retail Sale Id 1788',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 08:52:27','',''),(1616,'1','223','1',1,'Retail Sale Id 1789',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 08:53:23','',''),(1617,'1','223','1',1,'Retail Sale Id 1790',2002.60,0.00,0.00,3.23,103.36,'2022-03-25 08:56:29','',''),(1618,'1','223','1',1,'Retail Sale Id 1791',620.00,0.00,0.00,1.00,32.00,'2022-03-25 08:57:18','',''),(1619,'1','223','1',1,'Retail Sale Id 1792',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 09:01:01','',''),(1620,'1','223','1',1,'Retail Sale Id 1793',7750.00,0.00,0.00,12.50,400.00,'2022-03-25 09:05:39','',''),(1621,'1','223','1',1,'Retail Sale Id 1794',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 09:12:05','',''),(1622,'1','223','1',1,'Retail Sale Id 1795',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 09:18:41','',''),(1623,'1','223','1',1,'Retail Sale Id 1796',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 09:25:23','',''),(1624,'1','223','1',1,'Retail Sale Id 1797',2498.60,0.00,0.00,4.03,128.96,'2022-03-25 09:26:10','',''),(1625,'1','223','1',1,'Retail Sale Id 1798',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 09:27:08','',''),(1626,'1','223','1',1,'Retail Sale Id 1799',3751.00,0.00,0.00,6.05,193.60,'2022-03-25 09:40:04','',''),(1627,'1','223','1',1,'Retail Sale Id 1800',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 09:40:49','',''),(1628,'1','223','1',1,'Retail Sale Id 1801',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 09:54:00','',''),(1629,'1','223','1',1,'Retail Sale Id 1802',1202.80,0.00,0.00,1.94,62.08,'2022-03-25 09:54:56','',''),(1630,'1','223','1',1,'Retail Sale Id 1803',1798.00,0.00,0.00,2.90,92.80,'2022-03-25 09:55:39','',''),(1631,'1','223','1',1,'Retail Sale Id 1804',3503.00,0.00,0.00,5.65,180.80,'2022-03-25 09:57:58','',''),(1632,'1','223','1',1,'Retail Sale Id 1805',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 10:01:35','',''),(1633,'1','223','1',1,'Retail Sale Id 1806',1240.00,0.00,0.00,2.00,64.00,'2022-03-25 10:05:14','',''),(1634,'1','223','1',1,'Retail Sale Id 1807',1240.00,0.00,0.00,2.00,64.00,'2022-03-25 10:06:17','',''),(1635,'1','223','1',1,'Retail Sale Id 1808',1240.00,0.00,0.00,2.00,64.00,'2022-03-25 10:07:32','',''),(1636,'1','223','1',1,'Retail Sale Id 1809',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 10:08:24','',''),(1637,'1','223','1',1,'Retail Sale Id 1810',700.60,0.00,0.00,1.13,36.16,'2022-03-25 10:14:39','',''),(1638,'1','223','1',1,'Retail Sale Id 1811',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 10:15:46','',''),(1639,'1','223','1',1,'Retail Sale Id 1812',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 10:23:52','',''),(1640,'1','223','1',1,'Retail Sale Id 1813',2498.60,0.00,0.00,4.03,128.96,'2022-03-25 10:33:12','',''),(1641,'1','223','1',1,'Retail Sale Id 1814',1202.80,0.00,0.00,1.94,62.08,'2022-03-25 10:40:38','',''),(1642,'1','223','1',1,'Retail Sale Id 1815',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 10:45:16','',''),(1643,'1','223','1',1,'Retail Sale Id 1817',6200.00,0.00,0.00,10.00,320.00,'2022-03-25 10:46:54','',''),(1644,'1','223','1',1,'Retail Sale Id 1818',1202.80,0.00,0.00,1.94,62.08,'2022-03-25 10:51:38','',''),(1645,'1','223','1',1,'Retail Sale Id 1819',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 10:55:18','',''),(1646,'1','223','1',1,'Retail Sale Id 1820',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 10:58:54','',''),(1647,'1','223','1',1,'Retail Sale Id 1821',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 10:59:53','',''),(1648,'1','223','1',1,'Retail Sale Id 1822',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 11:00:55','',''),(1649,'1','223','1',1,'Retail Sale Id 1823',7750.00,0.00,0.00,12.50,400.00,'2022-03-25 11:02:19','',''),(1650,'1','223','1',1,'Retail Sale Id 1824',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 11:14:33','',''),(1651,'1','223','1',1,'Retail Sale Id 1825',998.20,0.00,0.00,1.61,51.52,'2022-03-25 11:17:34','',''),(1652,'1','223','1',1,'Retail Sale Id 1826',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 11:18:36','',''),(1653,'1','223','1',1,'Retail Sale Id 1827',2498.60,0.00,0.00,4.03,128.96,'2022-03-25 11:20:43','',''),(1654,'1','223','1',1,'Retail Sale Id 1828',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 11:28:44','',''),(1655,'1','223','1',1,'Retail Sale Id 1829',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 11:29:41','',''),(1656,'1','223','1',1,'Retail Sale Id 1831',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 11:31:21','',''),(1657,'1','223','1',1,'Retail Sale Id 1832',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 11:32:03','',''),(1658,'1','223','1',1,'Retail Sale Id 1833',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 11:49:14','',''),(1659,'1','223','1',1,'Retail Sale Id 1834',1240.00,0.00,0.00,2.00,64.00,'2022-03-25 11:56:04','',''),(1660,'1','223','1',1,'Retail Sale Id 1835',4960.00,0.00,0.00,8.00,256.00,'2022-03-25 12:01:37','',''),(1661,'1','223','1',1,'Retail Sale Id 1836',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 12:05:53','',''),(1662,'1','223','1',1,'Retail Sale Id 1837',3999.00,0.00,0.00,6.45,206.40,'2022-03-25 12:18:35','',''),(1663,'1','223','1',1,'Retail Sale Id 1838',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 12:27:10','',''),(1664,'1','223','1',1,'Retail Sale Id 1839',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 12:48:39','',''),(1665,'1','223','1',1,'Retail Sale Id 1840',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 12:50:00','',''),(1666,'1','223','1',1,'Retail Sale Id 1841',3751.00,0.00,0.00,6.05,193.60,'2022-03-25 12:58:16','',''),(1667,'1','223','1',1,'Retail Sale Id 1842',3651.80,0.00,0.00,5.89,188.48,'2022-03-25 13:05:14','',''),(1668,'1','223','1',1,'Return of Retail Sale Id 1841',0.00,3751.00,6.05,0.00,-193.60,'2022-03-25 13:06:57','',''),(1669,'1','223','1',1,'Retail Sale Id 1843',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 13:09:50','',''),(1670,'1','223','1',1,'Retail Sale Id 1844',6999.80,0.00,0.00,11.29,361.28,'2022-03-25 13:11:15','',''),(1671,'1','223','1',1,'Retail Sale Id 1845',3720.00,0.00,0.00,6.00,192.00,'2022-03-25 13:18:18','',''),(1672,'1','223','1',1,'Retail Sale Id 1846',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 13:20:33','',''),(1673,'1','223','1',1,'Retail Sale Id 1847',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 13:23:30','',''),(1674,'1','223','1',1,'Retail Sale Id 1848',1202.80,0.00,0.00,1.94,62.08,'2022-03-25 13:26:31','',''),(1675,'1','223','1',1,'Retail Sale Id 1849',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 13:38:34','',''),(1676,'1','223','1',1,'Retail Sale Id 1850',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 13:40:06','',''),(1677,'1','223','1',1,'Retail Sale Id 1851',1240.00,0.00,0.00,2.00,64.00,'2022-03-25 13:43:52','',''),(1678,'1','223','1',1,'Retail Sale Id 1852',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 13:52:31','',''),(1679,'1','223','1',1,'Retail Sale Id 1853',7750.00,0.00,0.00,12.50,400.00,'2022-03-25 14:05:32','',''),(1680,'1','223','1',1,'Retail Sale Id 1854',3720.00,0.00,0.00,6.00,192.00,'2022-03-25 14:08:50','',''),(1681,'1','223','1',1,'Retail Sale Id 1855',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 14:10:08','',''),(1682,'1','223','1',1,'Retail Sale Id 1856',30000.00,0.00,0.00,50.00,600.00,'2022-03-25 14:20:12','',''),(1683,'1','223','1',1,'Retail Sale Id 1857',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 14:27:18','',''),(1684,'1','223','1',1,'Retail Sale Id 1858',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 14:36:54','',''),(1685,'1','223','1',1,'Retail Sale Id 1859',2498.60,0.00,0.00,4.03,128.96,'2022-03-25 14:46:14','',''),(1686,'1','223','1',1,'Retail Sale Id 1860',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 14:58:37','',''),(1687,'1','223','1',1,'Return of Retail Sale Id 1859',0.00,2498.60,4.03,0.00,-128.96,'2022-03-25 15:01:36','',''),(1688,'1','223','1',1,'Retail Sale Id 1861',3720.00,0.00,0.00,6.00,192.00,'2022-03-25 15:05:41','',''),(1689,'1','223','1',1,'Retail Sale Id 1862',3720.00,0.00,0.00,6.00,192.00,'2022-03-25 15:27:49','',''),(1690,'1','223','1',1,'Retail Sale Id 1863',2498.60,0.00,0.00,4.03,128.96,'2022-03-25 15:28:59','',''),(1691,'1','223','1',1,'Retail Sale Id 1864',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 15:30:49','',''),(1692,'1','223','1',1,'Retail Sale Id 1865',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 15:33:47','',''),(1693,'1','223','1',1,'Retail Sale Id 1866',1798.00,0.00,0.00,2.90,92.80,'2022-03-25 15:40:01','',''),(1694,'1','223','1',1,'Retail Sale Id 1870',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 15:43:19','',''),(1695,'1','223','1',1,'Retail Sale Id 1871',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 15:47:26','',''),(1696,'1','223','1',1,'Retail Sale Id 1872',2498.60,0.00,0.00,4.03,128.96,'2022-03-25 15:49:35','',''),(1697,'1','223','1',1,'Retail Sale Id 1873',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 15:52:48','',''),(1698,'1','223','1',1,'Retail Sale Id 1874',6200.00,0.00,0.00,10.00,320.00,'2022-03-25 15:54:02','',''),(1699,'1','223','1',1,'Retail Sale Id 1875',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 15:55:49','',''),(1700,'1','223','1',1,'Retail Sale Id 1876',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 15:57:10','',''),(1701,'1','223','1',1,'Retail Sale Id 1877',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 15:58:08','',''),(1702,'1','223','1',1,'Retail Sale Id 1878',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 15:59:01','',''),(1703,'1','223','1',1,'Retail Sale Id 1879',7750.00,0.00,0.00,12.50,400.00,'2022-03-25 16:00:57','',''),(1704,'1','223','1',1,'Retail Sale Id 1880',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 16:04:45','',''),(1705,'1','223','1',1,'Retail Sale Id 1881',6200.00,0.00,0.00,10.00,320.00,'2022-03-25 16:08:39','',''),(1706,'1','223','1',1,'Retail Sale Id 1882',2002.60,0.00,0.00,3.23,103.36,'2022-03-25 16:11:00','',''),(1707,'1','223','1',1,'Retail Sale Id 1883',700.60,0.00,0.00,1.13,36.16,'2022-03-25 16:13:36','',''),(1708,'1','223','1',1,'Retail Sale Id 1884',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 16:21:44','',''),(1709,'1','223','1',1,'Retail Sale Id 1885',1847.60,0.00,0.00,2.98,95.36,'2022-03-25 16:23:31','',''),(1710,'1','223','1',1,'Retail Sale Id 1886',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 16:27:09','',''),(1711,'1','223','1',1,'Retail Sale Id 1887',3720.00,0.00,0.00,6.00,192.00,'2022-03-25 16:28:15','',''),(1712,'1','223','1',1,'Retail Sale Id 1888',4997.20,0.00,0.00,8.06,257.92,'2022-03-25 16:33:24','',''),(1713,'1','223','1',1,'Retail Sale Id 1889',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 16:34:37','',''),(1714,'1','223','1',1,'Retail Sale Id 1890',1500.40,0.00,0.00,2.42,77.44,'2022-03-25 16:35:40','',''),(1715,'1','223','1',1,'Retail Sale Id 1891',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 16:36:45','',''),(1716,'1','223','1',1,'Retail Sale Id 1892',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 16:38:01','',''),(1717,'1','223','1',1,'Retail Sale Id 1893',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 16:39:49','',''),(1718,'1','223','1',1,'Retail Sale Id 1894',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 16:42:35','',''),(1719,'1','223','1',1,'Retail Sale Id 1895',3751.00,0.00,0.00,6.05,193.60,'2022-03-25 16:44:45','',''),(1720,'1','223','1',1,'Retail Sale Id 1896',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 16:45:49','',''),(1721,'1','223','1',1,'Retail Sale Id 1897',620.00,0.00,0.00,1.00,32.00,'2022-03-25 16:49:13','',''),(1722,'1','223','1',1,'Retail Sale Id 1898',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 16:50:57','',''),(1723,'1','223','1',1,'Retail Sale Id 1899',998.20,0.00,0.00,1.61,51.52,'2022-03-25 16:52:25','',''),(1724,'1','223','1',1,'Retail Sale Id 1900',998.20,0.00,0.00,1.61,51.52,'2022-03-25 17:02:06','',''),(1725,'1','223','1',1,'Retail Sale Id 1901',2002.60,0.00,0.00,3.23,103.36,'2022-03-25 17:03:35','',''),(1726,'1','223','1',1,'Retail Sale Id 1902',3720.00,0.00,0.00,6.00,192.00,'2022-03-25 17:05:38','',''),(1727,'1','223','1',1,'Retail Sale Id 1903',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 17:08:21','',''),(1728,'1','223','1',1,'Retail Sale Id 1904',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 17:09:28','',''),(1729,'1','223','1',1,'Retail Sale Id 1905',2480.00,0.00,0.00,4.00,128.00,'2022-03-25 17:12:01','',''),(1730,'1','223','1',1,'Retail Sale Id 1906',700.60,0.00,0.00,1.13,36.16,'2022-03-25 17:12:58','',''),(1731,'1','223','1',1,'Retail Sale Id 1907',651.00,0.00,0.00,1.05,33.60,'2022-03-25 17:14:12','',''),(1732,'1','223','1',1,'Retail Sale Id 1908',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 17:16:37','',''),(1733,'1','223','1',1,'Retail Sale Id 1909',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 17:17:59','',''),(1734,'1','223','1',1,'Retail Sale Id 1910',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 17:25:32','',''),(1735,'1','223','1',1,'Retail Sale Id 1911',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 17:26:47','',''),(1736,'1','223','1',1,'Retail Sale Id 1912',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 17:27:47','',''),(1737,'1','223','1',1,'Retail Sale Id 1913',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 17:29:06','',''),(1738,'1','223','1',1,'Retail Sale Id 1914',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 17:30:36','',''),(1739,'1','223','1',1,'Retail Sale Id 1916',3751.00,0.00,0.00,6.05,193.60,'2022-03-25 17:33:02','',''),(1740,'1','223','1',1,'Retail Sale Id 1917',1500.40,0.00,0.00,2.42,77.44,'2022-03-25 17:40:04','',''),(1741,'1','223','1',1,'Retail Sale Id 1918',3751.00,0.00,0.00,6.05,193.60,'2022-03-25 17:43:54','',''),(1742,'1','223','1',1,'Retail Sale Id 1920',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 17:45:38','',''),(1743,'1','223','1',1,'Retail Sale Id 1921',651.00,0.00,0.00,1.05,33.60,'2022-03-25 17:47:01','',''),(1744,'1','223','1',1,'Retail Sale Id 1922',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 17:48:04','',''),(1745,'1','223','1',1,'Retail Sale Id 1923',2480.00,0.00,0.00,4.00,128.00,'2022-03-25 17:51:18','',''),(1746,'1','223','1',1,'Return of Retail Sale Id 1923',0.00,2480.00,4.00,0.00,-128.00,'2022-03-25 17:53:13','',''),(1747,'1','223','1',1,'Retail Sale Id 1924',3720.00,0.00,0.00,6.00,192.00,'2022-03-25 17:54:21','',''),(1748,'1','223','1',1,'Retail Sale Id 1925',3720.00,0.00,0.00,6.00,192.00,'2022-03-25 17:56:17','',''),(1749,'1','223','1',1,'Retail Sale Id 1926',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 17:57:47','',''),(1750,'1','223','1',1,'Retail Sale Id 1927',1202.80,0.00,0.00,1.94,62.08,'2022-03-25 17:58:53','',''),(1751,'1','223','1',1,'Retail Sale Id 1928',7750.00,0.00,0.00,12.50,400.00,'2022-03-25 18:00:12','',''),(1752,'1','223','1',1,'Retail Sale Id 1929',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 18:01:23','',''),(1753,'1','223','1',1,'Retail Sale Id 1930',620.00,0.00,0.00,1.00,32.00,'2022-03-25 18:02:20','',''),(1754,'1','223','1',1,'Retail Sale Id 1931',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 18:03:35','',''),(1755,'1','223','1',1,'Retail Sale Id 1932',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 18:04:55','',''),(1756,'1','223','1',1,'Retail Sale Id 1933',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 18:05:57','',''),(1757,'1','223','1',1,'Retail Sale Id 1934',1847.60,0.00,0.00,2.98,95.36,'2022-03-25 18:07:26','',''),(1758,'1','223','1',1,'Retail Sale Id 1935',30000.00,0.00,0.00,50.00,600.00,'2022-03-25 18:11:08','',''),(1759,'1','223','1',1,'Retail Sale Id 1936',1798.00,0.00,0.00,2.90,92.80,'2022-03-25 18:13:56','',''),(1760,'1','223','1',1,'Retail Sale Id 1937',3751.00,0.00,0.00,6.05,193.60,'2022-03-25 18:15:47','',''),(1761,'1','223','1',1,'Retail Sale Id 1938',11470.00,0.00,0.00,18.50,592.00,'2022-03-25 18:18:58','',''),(1762,'1','223','1',1,'Retail Sale Id 1939',1847.60,0.00,0.00,2.98,95.36,'2022-03-25 18:24:33','',''),(1763,'1','223','1',1,'Retail Sale Id 1940',3100.00,0.00,0.00,5.00,160.00,'2022-03-25 18:28:11','',''),(1764,'1','223','1',1,'Retail Sale Id 1941',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 18:35:53','',''),(1765,'1','223','1',1,'Retail Sale Id 1942',1860.00,0.00,0.00,3.00,96.00,'2022-03-25 18:45:31','',''),(1766,'1','223','1',1,'Retail Sale Id 1943',2480.00,0.00,0.00,4.00,128.00,'2022-03-25 18:47:48','',''),(1767,'1','223','1',1,'Retail Sale Id 1944',2480.00,0.00,0.00,4.00,128.00,'2022-03-25 18:48:52','',''),(1768,'1','223','1',1,'Retail Sale Id 1945',1897.20,0.00,0.00,3.06,97.92,'2022-03-25 18:53:39','',''),(1769,'1','223','1',1,'Retail Sale Id 1946',700.60,0.00,0.00,1.13,36.16,'2022-03-25 18:54:54','',''),(1770,'1','223','1',1,'Retail Sale Id 1947',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 18:55:59','',''),(1771,'1','223','1',1,'Retail Sale Id 1948',1252.40,0.00,0.00,2.02,64.64,'2022-03-25 18:58:02','',''),(1772,'1','223','1',1,'Retail Sale Id 1949',1240.00,0.00,0.00,2.00,64.00,'2022-03-25 18:59:45','',''),(1773,'1','223','1',1,'Retail Sale Id 1950',1202.80,0.00,0.00,1.94,62.08,'2022-03-26 07:28:53','',''),(1774,'1','223','1',1,'Retail Sale Id 1951',651.00,0.00,0.00,1.05,33.60,'2022-03-26 07:30:23','',''),(1775,'1','223','1',1,'Retail Sale Id 1952',2002.60,0.00,0.00,3.23,103.36,'2022-03-26 07:34:34','',''),(1776,'1','223','1',1,'Retail Sale Id 1953',3100.00,0.00,0.00,5.00,160.00,'2022-03-26 07:51:04','',''),(1777,'1','223','1',1,'Retail Sale Id 1954',33000.00,0.00,0.00,55.00,660.00,'2022-03-26 07:52:34','',''),(1778,'1','223','1',1,'Retail Sale Id 1955',3751.00,0.00,0.00,6.05,193.60,'2022-03-26 07:56:01','',''),(1779,'1','223','1',1,'Retail Sale Id 1956',1897.20,0.00,0.00,3.06,97.92,'2022-03-26 07:57:14','',''),(1780,'1','223','1',1,'Retail Sale Id 1957',2480.00,0.00,0.00,4.00,128.00,'2022-03-26 08:01:58','',''),(1781,'1','223','1',1,'Retail Sale Id 1958',700.60,0.00,0.00,1.13,36.16,'2022-03-26 08:24:54','',''),(1782,'1','223','1',1,'Retail Sale Id 1959',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 08:37:25','',''),(1783,'1','223','1',1,'Retail Sale Id 1960',1500.40,0.00,0.00,2.42,77.44,'2022-03-26 08:41:01','',''),(1784,'1','223','1',1,'Retail Sale Id 1961',2002.60,0.00,0.00,3.23,103.36,'2022-03-26 09:00:45','',''),(1785,'1','223','1',1,'Retail Sale Id 1962',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 09:09:41','',''),(1786,'1','223','1',1,'Retail Sale Id 1963',998.20,0.00,0.00,1.61,51.52,'2022-03-26 09:11:33','',''),(1787,'1','223','1',1,'Retail Sale Id 1964',1202.80,0.00,0.00,1.94,62.08,'2022-03-26 09:13:20','',''),(1788,'1','223','1',1,'Retail Sale Id 1966',1302.00,0.00,0.00,2.10,67.20,'2022-03-26 09:16:31','',''),(1789,'1','223','1',1,'Retail Sale Id 1967',1252.40,0.00,0.00,2.02,64.64,'2022-03-26 09:21:53','',''),(1790,'1','223','1',1,'Retail Sale Id 1968',3100.00,0.00,0.00,5.00,160.00,'2022-03-26 09:22:48','',''),(1791,'1','223','1',1,'Retail Sale Id 1969',1847.60,0.00,0.00,2.98,95.36,'2022-03-26 09:37:33','',''),(1792,'1','223','1',1,'Retail Sale Id 1970',1897.20,0.00,0.00,3.06,97.92,'2022-03-26 09:38:54','',''),(1793,'1','223','1',1,'Retail Sale Id 1971',1252.40,0.00,0.00,2.02,64.64,'2022-03-26 09:41:33','',''),(1794,'1','223','1',1,'Retail Sale Id 1972',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 09:43:03','',''),(1795,'1','223','1',1,'Retail Sale Id 1973',3720.00,0.00,0.00,6.00,192.00,'2022-03-26 09:49:17','',''),(1796,'1','223','1',1,'Retail Sale Id 1974',1252.40,0.00,0.00,2.02,64.64,'2022-03-26 09:50:31','',''),(1797,'1','223','1',1,'Retail Sale Id 1975',4960.00,0.00,0.00,8.00,256.00,'2022-03-26 10:03:45','',''),(1798,'1','223','1',1,'Retail Sale Id 1976',1240.00,0.00,0.00,2.00,64.00,'2022-03-26 10:21:07','',''),(1799,'1','223','1',1,'Retail Sale Id 1977',3999.00,0.00,0.00,6.45,206.40,'2022-03-26 10:22:51','',''),(1800,'1','223','1',1,'Retail Sale Id 1978',620.00,0.00,0.00,1.00,32.00,'2022-03-26 10:24:24','',''),(1801,'1','223','1',1,'Retail Sale Id 1979',2480.00,0.00,0.00,4.00,128.00,'2022-03-26 10:28:22','',''),(1802,'1','223','1',1,'Retail Sale Id 1980',1500.40,0.00,0.00,2.42,77.44,'2022-03-26 10:44:24','',''),(1803,'1','223','1',1,'Retail Sale Id 1981',620.00,0.00,0.00,1.00,32.00,'2022-03-26 10:45:27','',''),(1804,'1','223','1',1,'Retail Sale Id 1983',620.00,0.00,0.00,1.00,32.00,'2022-03-26 11:05:11','',''),(1805,'1','223','1',1,'Retail Sale Id 1984',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 11:09:17','',''),(1806,'1','223','1',1,'Retail Sale Id 1985',1252.40,0.00,0.00,2.02,64.64,'2022-03-26 11:27:43','',''),(1807,'1','223','1',1,'Retail Sale Id 1986',7750.00,0.00,0.00,12.50,400.00,'2022-03-26 11:34:01','',''),(1808,'1','223','1',1,'Retail Sale Id 1987',2002.60,0.00,0.00,3.23,103.36,'2022-03-26 11:37:41','',''),(1809,'1','223','1',1,'Retail Sale Id 1988',3100.00,0.00,0.00,5.00,160.00,'2022-03-26 11:42:47','',''),(1810,'1','223','1',1,'Retail Sale Id 1989',620.00,0.00,0.00,1.00,32.00,'2022-03-26 11:46:14','',''),(1811,'1','223','1',1,'Retail Sale Id 1990',620.00,0.00,0.00,1.00,32.00,'2022-03-26 12:06:56','',''),(1812,'1','223','1',1,'Retail Sale Id 1991',1202.80,0.00,0.00,1.94,62.08,'2022-03-26 12:09:29','',''),(1813,'1','223','1',1,'Retail Sale Id 1992',2802.40,0.00,0.00,4.52,144.64,'2022-03-26 12:30:11','',''),(1814,'1','223','1',1,'Retail Sale Id 1993',7750.00,0.00,0.00,12.50,400.00,'2022-03-26 12:32:47','',''),(1815,'1','223','1',1,'Retail Sale Id 1994',1240.00,0.00,0.00,2.00,64.00,'2022-03-26 12:38:23','',''),(1816,'1','223','1',1,'Retail Sale Id 1995',3000.80,0.00,0.00,4.84,154.88,'2022-03-26 12:55:55','',''),(1817,'1','223','1',1,'Retail Sale Id 1996',1240.00,0.00,0.00,2.00,64.00,'2022-03-26 12:57:03','',''),(1818,'1','223','1',1,'Retail Sale Id 1997',1252.40,0.00,0.00,2.02,64.64,'2022-03-26 13:10:05','',''),(1819,'1','223','1',1,'Retail Sale Id 1998',1252.40,0.00,0.00,2.02,64.64,'2022-03-26 13:11:45','',''),(1820,'1','223','1',1,'Retail Sale Id 1999',3100.00,0.00,0.00,5.00,160.00,'2022-03-26 13:20:46','',''),(1821,'1','223','1',1,'Retail Sale Id 2000',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 13:36:22','',''),(1822,'1','223','1',1,'Retail Sale Id 2001',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 13:37:42','',''),(1823,'1','223','1',1,'Retail Sale Id 2002',719.20,0.00,0.00,1.16,37.12,'2022-03-26 13:44:23','',''),(1824,'1','223','1',1,'Return of Retail Sale Id 2001',0.00,1860.00,3.00,0.00,-96.00,'2022-03-26 13:45:54','',''),(1825,'1','223','1',1,'Retail Sale Id 2003',6820.00,0.00,0.00,11.00,352.00,'2022-03-26 13:57:01','',''),(1826,'1','223','1',1,'Retail Sale Id 2004',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 13:59:47','',''),(1827,'1','223','1',1,'Retail Sale Id 2005',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 14:02:37','',''),(1828,'1','223','1',1,'Return of Retail Sale Id 2002',0.00,719.20,1.16,0.00,-37.12,'2022-03-26 14:09:56','',''),(1829,'1','223','1',1,'Retail Sale Id 2006',7750.00,0.00,0.00,12.50,400.00,'2022-03-26 14:10:27','',''),(1830,'1','223','1',1,'Retail Sale Id 2007',1140.80,0.00,0.00,1.84,58.88,'2022-03-26 14:11:37','',''),(1831,'1','223','1',1,'Retail Sale Id 2008',1252.40,0.00,0.00,2.02,64.64,'2022-03-26 14:27:44','',''),(1832,'1','223','1',1,'Retail Sale Id 2009',1252.40,0.00,0.00,2.02,64.64,'2022-03-26 14:37:38','',''),(1833,'1','223','1',1,'Retail Sale Id 2010',1097.40,0.00,0.00,1.77,56.64,'2022-03-26 14:42:26','',''),(1834,'1','223','1',1,'Retail Sale Id 2011',1097.40,0.00,0.00,1.77,56.64,'2022-03-26 14:43:11','',''),(1835,'1','223','1',1,'Retail Sale Id 2013',3100.00,0.00,0.00,5.00,160.00,'2022-03-26 14:48:56','',''),(1836,'1','223','1',1,'Retail Sale Id 2014',3720.00,0.00,0.00,6.00,192.00,'2022-03-26 14:52:59','',''),(1837,'1','223','1',1,'Retail Sale Id 2015',1240.00,0.00,0.00,2.00,64.00,'2022-03-26 14:55:29','',''),(1838,'1','223','1',1,'Retail Sale Id 2016',3720.00,0.00,0.00,6.00,192.00,'2022-03-26 15:06:27','',''),(1839,'1','223','1',1,'Retail Sale Id 2017',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 15:07:39','',''),(1840,'1','223','1',1,'Retail Sale Id 2018',2498.60,0.00,0.00,4.03,128.96,'2022-03-26 15:08:49','',''),(1841,'1','223','1',1,'Retail Sale Id 2020',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 15:13:52','',''),(1842,'1','223','1',1,'Retail Sale Id 2021',1240.00,0.00,0.00,2.00,64.00,'2022-03-26 15:28:43','',''),(1843,'1','223','1',1,'Retail Sale Id 2022',620.00,0.00,0.00,1.00,32.00,'2022-03-26 15:32:22','',''),(1844,'1','223','1',1,'Retail Sale Id 2023',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 15:43:42','',''),(1845,'1','223','1',1,'Retail Sale Id 2024',3720.00,0.00,0.00,6.00,192.00,'2022-03-26 15:49:56','',''),(1846,'1','223','1',1,'Retail Sale Id 2025',3100.00,0.00,0.00,5.00,160.00,'2022-03-26 15:50:43','',''),(1847,'1','223','1',1,'Retail Sale Id 2026',620.00,0.00,0.00,1.00,32.00,'2022-03-26 15:52:24','',''),(1848,'1','223','1',1,'Retail Sale Id 2027',3720.00,0.00,0.00,6.00,192.00,'2022-03-26 15:53:05','',''),(1849,'1','223','1',1,'Retail Sale Id 2028',67500.00,0.00,0.00,112.50,1350.00,'2022-03-26 15:55:08','',''),(1850,'1','223','1',1,'Retail Sale Id 2029',6200.00,0.00,0.00,10.00,320.00,'2022-03-26 16:00:21','',''),(1851,'1','223','1',1,'Retail Sale Id 2030',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 16:01:17','',''),(1852,'1','223','1',1,'Retail Sale Id 2031',7750.00,0.00,0.00,12.50,400.00,'2022-03-26 16:04:41','',''),(1853,'1','223','1',1,'Retail Sale Id 2032',3100.00,0.00,0.00,5.00,160.00,'2022-03-26 16:16:14','',''),(1854,'1','223','1',1,'Retail Sale Id 2033',998.20,0.00,0.00,1.61,51.52,'2022-03-26 16:25:02','',''),(1855,'1','223','1',1,'Retail Sale Id 2034',620.00,0.00,0.00,1.00,32.00,'2022-03-26 16:28:08','',''),(1856,'1','223','1',1,'Retail Sale Id 2035',2480.00,0.00,0.00,4.00,128.00,'2022-03-26 16:29:04','',''),(1857,'1','223','1',1,'Retail Sale Id 2036',2480.00,0.00,0.00,4.00,128.00,'2022-03-26 16:29:53','',''),(1858,'1','223','1',1,'Retail Sale Id 2037',2498.60,0.00,0.00,4.03,128.96,'2022-03-26 16:33:23','',''),(1859,'1','223','1',1,'Retail Sale Id 2038',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 16:41:46','',''),(1860,'1','223','1',1,'Retail Sale Id 2039',2480.00,0.00,0.00,4.00,128.00,'2022-03-26 16:55:14','',''),(1861,'1','223','1',1,'Retail Sale Id 2040',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 17:00:40','',''),(1862,'1','223','1',1,'Retail Sale Id 2041',3100.00,0.00,0.00,5.00,160.00,'2022-03-26 17:02:23','',''),(1863,'1','223','1',1,'Retail Sale Id 2042',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 17:04:47','',''),(1864,'1','223','1',1,'Retail Sale Id 2043',3100.00,0.00,0.00,5.00,160.00,'2022-03-26 17:05:52','',''),(1865,'1','223','1',1,'Retail Sale Id 2044',3720.00,0.00,0.00,6.00,192.00,'2022-03-26 17:06:51','',''),(1866,'1','223','1',1,'Retail Sale Id 2045',7750.00,0.00,0.00,12.50,400.00,'2022-03-26 17:08:48','',''),(1867,'1','223','1',1,'Retail Sale Id 2046',1240.00,0.00,0.00,2.00,64.00,'2022-03-26 17:11:25','',''),(1868,'1','223','1',1,'Retail Sale Id 2047',799.80,0.00,0.00,1.29,41.28,'2022-03-26 17:14:17','',''),(1869,'1','223','1',1,'Retail Sale Id 2048',7750.00,0.00,0.00,12.50,400.00,'2022-03-26 17:17:44','',''),(1870,'1','223','1',1,'Retail Sale Id 2049',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 17:19:50','',''),(1871,'1','223','1',1,'Retail Sale Id 2050',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 17:21:13','',''),(1872,'1','223','1',1,'Retail Sale Id 2051',3100.00,0.00,0.00,5.00,160.00,'2022-03-26 17:22:55','',''),(1873,'1','223','1',1,'Retail Sale Id 2052',1252.40,0.00,0.00,2.02,64.64,'2022-03-26 17:23:51','',''),(1874,'1','223','1',1,'Retail Sale Id 2053',1240.00,0.00,0.00,2.00,64.00,'2022-03-26 17:29:31','',''),(1875,'1','223','1',1,'Retail Sale Id 2054',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 17:31:35','',''),(1876,'1','223','1',1,'Retail Sale Id 2055',2480.00,0.00,0.00,4.00,128.00,'2022-03-26 17:40:39','',''),(1877,'1','223','1',1,'Retail Sale Id 2056',1240.00,0.00,0.00,2.00,64.00,'2022-03-26 17:44:03','',''),(1878,'1','223','1',1,'Retail Sale Id 2057',2480.00,0.00,0.00,4.00,128.00,'2022-03-26 17:50:35','',''),(1879,'1','223','1',1,'Retail Sale Id 2058',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 18:01:53','',''),(1880,'1','223','1',1,'Retail Sale Id 2059',1240.00,0.00,0.00,2.00,64.00,'2022-03-26 18:04:01','',''),(1881,'1','223','1',1,'Retail Sale Id 2060',1202.80,0.00,0.00,1.94,62.08,'2022-03-26 18:05:19','',''),(1882,'1','223','1',1,'Retail Sale Id 2061',3000.80,0.00,0.00,4.84,154.88,'2022-03-26 18:06:02','',''),(1883,'1','223','1',1,'Retail Sale Id 2062',1748.40,0.00,0.00,2.82,90.24,'2022-03-26 18:08:25','',''),(1884,'1','223','1',1,'Retail Sale Id 2063',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 18:10:50','',''),(1885,'1','223','1',1,'Retail Sale Id 2064',2480.00,0.00,0.00,4.00,128.00,'2022-03-26 18:12:51','',''),(1886,'1','223','1',1,'Retail Sale Id 2065',1252.40,0.00,0.00,2.02,64.64,'2022-03-26 18:15:02','',''),(1887,'1','223','1',1,'Retail Sale Id 2066',1240.00,0.00,0.00,2.00,64.00,'2022-03-26 18:21:47','',''),(1888,'1','223','1',1,'Retail Sale Id 2067',1860.00,0.00,0.00,3.00,96.00,'2022-03-26 18:23:23','',''),(1889,'1','223','1',1,'Retail Sale Id 2068',620.00,0.00,0.00,1.00,32.00,'2022-03-26 18:41:48','',''),(1890,'1','223','1',1,'Return of Retail Sale Id 2066',0.00,1240.00,2.00,0.00,-64.00,'2022-03-26 18:43:03','',''),(1891,'1','223','1',1,'Retail Sale Id 2069',3720.00,0.00,0.00,6.00,192.00,'2022-03-26 18:44:42','',''),(1892,'1','223','1',1,'Retail Sale Id 2070',2002.60,0.00,0.00,3.23,103.36,'2022-03-26 18:49:15','',''),(1893,'1','223','1',1,'Retail Sale Id 2071',43.40,0.00,0.00,0.07,2.24,'2022-03-26 19:28:13','',''),(1894,'1','223','1',1,'Retail Sale Id 2072',3100.00,0.00,0.00,5.00,160.00,'2022-03-27 07:01:37','',''),(1895,'1','223','1',1,'Retail Sale Id 2073',7750.00,0.00,0.00,12.50,400.00,'2022-03-27 07:51:38','',''),(1896,'1','223','1',1,'Retail Sale Id 2074',1240.00,0.00,0.00,2.00,64.00,'2022-03-27 07:55:53','',''),(1897,'1','223','1',1,'Retail Sale Id 2075',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 07:59:10','',''),(1898,'1','223','1',1,'Retail Sale Id 2076',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 09:24:57','',''),(1899,'1','223','1',1,'Retail Sale Id 2077',998.20,0.00,0.00,1.61,51.52,'2022-03-27 09:32:24','',''),(1900,'1','223','1',1,'Retail Sale Id 2078',2697.00,0.00,0.00,4.35,139.20,'2022-03-27 09:34:50','',''),(1901,'1','223','1',1,'Retail Sale Id 2079',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 09:38:12','',''),(1902,'1','223','1',1,'Retail Sale Id 2080',3100.00,0.00,0.00,5.00,160.00,'2022-03-27 09:48:13','',''),(1903,'1','223','1',1,'Retail Sale Id 2081',2480.00,0.00,0.00,4.00,128.00,'2022-03-27 10:06:43','',''),(1904,'1','223','1',1,'Retail Sale Id 2082',620.00,0.00,0.00,1.00,32.00,'2022-03-27 10:24:07','',''),(1905,'1','223','1',1,'Retail Sale Id 2083',1252.40,0.00,0.00,2.02,64.64,'2022-03-27 10:31:57','',''),(1906,'1','223','1',1,'Retail Sale Id 2084',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 11:03:16','',''),(1907,'1','223','1',1,'Retail Sale Id 2085',2480.00,0.00,0.00,4.00,128.00,'2022-03-27 11:05:26','',''),(1908,'1','223','1',1,'Retail Sale Id 2086',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 11:06:43','',''),(1909,'1','223','1',1,'Retail Sale Id 2087',1252.40,0.00,0.00,2.02,64.64,'2022-03-27 11:09:37','',''),(1910,'1','223','1',1,'Retail Sale Id 2088',998.20,0.00,0.00,1.61,51.52,'2022-03-27 11:14:51','',''),(1911,'1','223','1',1,'Retail Sale Id 2089',2480.00,0.00,0.00,4.00,128.00,'2022-03-27 11:32:53','',''),(1912,'1','223','1',1,'Retail Sale Id 2090',1240.00,0.00,0.00,2.00,64.00,'2022-03-27 11:37:12','',''),(1913,'1','223','1',1,'Retail Sale Id 2091',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 11:44:51','',''),(1914,'1','223','1',1,'Retail Sale Id 2092',3100.00,0.00,0.00,5.00,160.00,'2022-03-27 11:48:13','',''),(1915,'1','223','1',1,'Retail Sale Id 2093',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 11:58:14','',''),(1916,'1','223','1',1,'Retail Sale Id 2094',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 12:00:24','',''),(1917,'1','223','1',1,'Retail Sale Id 2095',2480.00,0.00,0.00,4.00,128.00,'2022-03-27 12:03:02','',''),(1918,'1','223','1',1,'Retail Sale Id 2097',1240.00,0.00,0.00,2.00,64.00,'2022-03-27 12:40:18','',''),(1919,'1','223','1',1,'Retail Sale Id 2098',2802.40,0.00,0.00,4.52,144.64,'2022-03-27 12:55:31','',''),(1920,'1','223','1',1,'Retail Sale Id 2099',3100.00,0.00,0.00,5.00,160.00,'2022-03-27 12:57:06','',''),(1921,'1','223','1',1,'Retail Sale Id 2100',3100.00,0.00,0.00,5.00,160.00,'2022-03-27 13:03:41','',''),(1922,'1','223','1',1,'Retail Sale Id 2101',1698.80,0.00,0.00,2.74,87.68,'2022-03-27 13:05:42','',''),(1923,'1','223','1',1,'Retail Sale Id 2102',998.20,0.00,0.00,1.61,51.52,'2022-03-27 13:32:09','',''),(1924,'1','223','1',1,'Retail Sale Id 2103',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 13:37:08','',''),(1925,'1','223','1',1,'Retail Sale Id 2104',3100.00,0.00,0.00,5.00,160.00,'2022-03-27 13:39:46','',''),(1926,'1','223','1',1,'Retail Sale Id 2105',1240.00,0.00,0.00,2.00,64.00,'2022-03-27 13:41:30','',''),(1927,'1','223','1',1,'Retail Sale Id 2106',1128.40,0.00,0.00,1.82,58.24,'2022-03-27 13:48:11','',''),(1928,'1','223','1',1,'Retail Sale Id 2107',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 14:01:24','',''),(1929,'1','223','1',1,'Retail Sale Id 2108',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 14:13:33','',''),(1930,'1','223','1',1,'Retail Sale Id 2109',2480.00,0.00,0.00,4.00,128.00,'2022-03-27 14:20:56','',''),(1931,'1','223','1',1,'Retail Sale Id 2110',3100.00,0.00,0.00,5.00,160.00,'2022-03-27 14:21:44','',''),(1932,'1','223','1',1,'Retail Sale Id 2111',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 14:26:54','',''),(1933,'1','223','1',1,'Retail Sale Id 2112',1252.40,0.00,0.00,2.02,64.64,'2022-03-27 14:33:25','',''),(1934,'1','223','1',1,'Return of Retail Sale Id 2109',0.00,2480.00,4.00,0.00,-128.00,'2022-03-27 14:34:00','',''),(1935,'1','223','1',1,'Retail Sale Id 2113',1252.40,0.00,0.00,2.02,64.64,'2022-03-27 14:39:52','',''),(1936,'1','223','1',1,'Retail Sale Id 2114',1500.40,0.00,0.00,2.42,77.44,'2022-03-27 14:59:51','',''),(1937,'1','223','1',1,'Retail Sale Id 2115',1302.00,0.00,0.00,2.10,67.20,'2022-03-27 15:15:18','',''),(1938,'1','223','1',1,'Retail Sale Id 2116',5598.60,0.00,0.00,9.03,288.96,'2022-03-27 15:30:23','',''),(1939,'1','223','1',1,'Retail Sale Id 2117',2002.60,0.00,0.00,3.23,103.36,'2022-03-27 15:41:34','',''),(1940,'1','223','1',1,'Retail Sale Id 2118',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 15:48:21','',''),(1941,'1','223','1',1,'Retail Sale Id 2119',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 15:57:41','',''),(1942,'1','223','1',1,'Retail Sale Id 2120',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 15:58:34','',''),(1943,'1','223','1',1,'Retail Sale Id 2121',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 16:06:24','',''),(1944,'1','223','1',1,'Retail Sale Id 2122',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 16:09:58','',''),(1945,'1','223','1',1,'Retail Sale Id 2123',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 16:14:02','',''),(1946,'1','223','1',1,'Retail Sale Id 2124',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 16:28:18','',''),(1947,'1','223','1',1,'Retail Sale Id 2125',998.20,0.00,0.00,1.61,51.52,'2022-03-27 16:46:45','',''),(1948,'1','223','1',1,'Retail Sale Id 2126',998.20,0.00,0.00,1.61,51.52,'2022-03-27 16:47:13','',''),(1949,'1','223','1',1,'Retail Sale Id 2127',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 16:50:26','',''),(1950,'1','223','1',1,'Retail Sale Id 2128',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 17:23:31','',''),(1951,'1','223','1',1,'Retail Sale Id 2129',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 17:27:14','',''),(1952,'1','223','1',1,'Retail Sale Id 2130',1897.20,0.00,0.00,3.06,97.92,'2022-03-27 17:34:54','',''),(1953,'1','223','1',1,'Retail Sale Id 2131',3100.00,0.00,0.00,5.00,160.00,'2022-03-27 17:41:56','',''),(1954,'1','223','1',1,'Retail Sale Id 2132',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 17:42:41','',''),(1955,'1','223','1',1,'Retail Sale Id 2133',2002.60,0.00,0.00,3.23,103.36,'2022-03-27 17:55:42','',''),(1956,'1','223','1',1,'Retail Sale Id 2134',3100.00,0.00,0.00,5.00,160.00,'2022-03-27 18:04:55','',''),(1957,'1','223','1',1,'Retail Sale Id 2135',998.20,0.00,0.00,1.61,51.52,'2022-03-27 18:06:46','',''),(1958,'1','223','1',1,'Retail Sale Id 2136',620.00,0.00,0.00,1.00,32.00,'2022-03-27 18:08:19','',''),(1959,'1','223','1',1,'Retail Sale Id 2137',3720.00,0.00,0.00,6.00,192.00,'2022-03-27 18:14:07','',''),(1960,'1','223','1',1,'Retail Sale Id 2138',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 18:15:52','',''),(1961,'1','223','1',1,'Retail Sale Id 2139',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 18:17:08','',''),(1962,'1','223','1',1,'Retail Sale Id 2140',2480.00,0.00,0.00,4.00,128.00,'2022-03-27 18:17:57','',''),(1963,'1','223','1',1,'Retail Sale Id 2141',1252.40,0.00,0.00,2.02,64.64,'2022-03-27 18:19:26','',''),(1964,'1','223','1',1,'Retail Sale Id 2142',2399.40,0.00,0.00,3.87,123.84,'2022-03-27 18:20:39','',''),(1965,'1','223','1',1,'Retail Sale Id 2143',36600.00,0.00,0.00,61.00,732.00,'2022-03-27 18:28:48','',''),(1966,'1','223','1',1,'Retail Sale Id 2144',998.20,0.00,0.00,1.61,51.52,'2022-03-27 18:29:33','',''),(1967,'1','223','1',1,'Retail Sale Id 2145',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 18:30:25','',''),(1968,'1','223','1',1,'Retail Sale Id 2146',1860.00,0.00,0.00,3.00,96.00,'2022-03-27 18:45:29','',''),(1969,'1','223','1',1,'Retail Sale Id 2147',930.00,0.00,0.00,1.50,48.00,'2022-03-27 18:53:28','',''),(1970,'1','223','1',1,'Return of Retail Sale Id 2147',0.00,930.00,1.50,0.00,-48.00,'2022-03-27 19:34:49','',''),(1971,'1','223','1',1,'Retail Sale Id 2148',1029.20,0.00,0.00,1.66,53.12,'2022-03-27 19:35:33','',''),(1972,'1','223','1',1,'Retail Sale Id 2149',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 07:31:08','',''),(1973,'1','223','1',1,'Retail Sale Id 2150',1302.00,0.00,0.00,2.10,67.20,'2022-03-28 07:53:59','',''),(1974,'1','223','1',1,'Retail Sale Id 2151',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 08:02:29','',''),(1975,'1','223','1',1,'Retail Sale Id 2152',3720.00,0.00,0.00,6.00,192.00,'2022-03-28 08:03:27','',''),(1976,'1','223','1',1,'Retail Sale Id 2153',620.00,0.00,0.00,1.00,32.00,'2022-03-28 08:23:20','',''),(1977,'1','223','1',1,'Retail Sale Id 2154',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 08:29:28','',''),(1978,'1','223','1',1,'Retail Sale Id 2155',1252.40,0.00,0.00,2.02,64.64,'2022-03-28 08:48:46','',''),(1979,'1','223','1',1,'Retail Sale Id 2156',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 08:50:59','',''),(1980,'1','223','1',1,'Retail Sale Id 2157',1252.40,0.00,0.00,2.02,64.64,'2022-03-28 08:57:47','',''),(1981,'1','223','1',1,'Retail Sale Id 2158',3100.00,0.00,0.00,5.00,160.00,'2022-03-28 09:05:21','',''),(1982,'1','223','1',1,'Retail Sale Id 2159',2498.60,0.00,0.00,4.03,128.96,'2022-03-28 09:30:51','',''),(1983,'1','223','1',1,'Retail Sale Id 2160',998.20,0.00,0.00,1.61,51.52,'2022-03-28 09:31:39','',''),(1984,'1','223','1',1,'Retail Sale Id 2161',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 09:36:38','',''),(1985,'1','223','1',1,'Retail Sale Id 2162',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 09:52:31','',''),(1986,'1','223','1',1,'Retail Sale Id 2163',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 10:03:53','',''),(1987,'1','223','1',1,'Retail Sale Id 2164',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 10:04:54','',''),(1988,'1','223','1',1,'Retail Sale Id 2165',3999.00,0.00,0.00,6.45,206.40,'2022-03-28 10:06:17','',''),(1989,'1','223','1',1,'Retail Sale Id 2166',6200.00,0.00,0.00,10.00,320.00,'2022-03-28 10:46:02','',''),(1990,'1','223','1',1,'Retail Sale Id 2167',3100.00,0.00,0.00,5.00,160.00,'2022-03-28 10:54:15','',''),(1991,'1','223','1',1,'Retail Sale Id 2168',7750.00,0.00,0.00,12.50,400.00,'2022-03-28 11:02:58','',''),(1992,'1','223','1',1,'Retail Sale Id 2169',998.20,0.00,0.00,1.61,51.52,'2022-03-28 11:24:15','',''),(1993,'1','223','1',1,'Retail Sale Id 2170',1252.40,0.00,0.00,2.02,64.64,'2022-03-28 11:25:35','',''),(1994,'1','223','1',1,'Retail Sale Id 2171',502.20,0.00,0.00,0.81,25.92,'2022-03-28 11:46:28','',''),(1995,'1','223','1',1,'Retail Sale Id 2172',2002.60,0.00,0.00,3.23,103.36,'2022-03-28 11:59:10','',''),(1996,'1','223','1',1,'Retail Sale Id 2173',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 12:07:12','',''),(1997,'1','223','1',1,'Retail Sale Id 2175',2002.60,0.00,0.00,3.23,103.36,'2022-03-28 12:13:09','',''),(1998,'1','223','1',1,'Retail Sale Id 2176',3100.00,0.00,0.00,5.00,160.00,'2022-03-28 12:24:22','',''),(1999,'1','223','1',1,'Retail Sale Id 2177',1252.40,0.00,0.00,2.02,64.64,'2022-03-28 12:30:41','',''),(2000,'1','223','1',1,'Retail Sale Id 2178',1252.40,0.00,0.00,2.02,64.64,'2022-03-28 12:31:27','',''),(2001,'1','223','1',1,'Retail Sale Id 2179',3100.00,0.00,0.00,5.00,160.00,'2022-03-28 13:19:07','',''),(2002,'1','223','1',1,'Retail Sale Id 2180',2498.60,0.00,0.00,4.03,128.96,'2022-03-28 13:36:26','',''),(2003,'1','223','1',1,'Retail Sale Id 2181',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 13:39:59','',''),(2004,'1','223','1',1,'Retail Sale Id 2182',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 13:46:49','',''),(2005,'1','223','1',1,'Retail Sale Id 2183',3720.00,0.00,0.00,6.00,192.00,'2022-03-28 13:48:27','',''),(2006,'1','223','1',1,'Return of Retail Sale Id 2182',0.00,1860.00,3.00,0.00,-96.00,'2022-03-28 13:54:27','',''),(2007,'1','223','1',1,'Retail Sale Id 2184',1847.60,0.00,0.00,2.98,95.36,'2022-03-28 13:55:03','',''),(2008,'1','223','1',1,'Retail Sale Id 2185',1240.00,0.00,0.00,2.00,64.00,'2022-03-28 14:06:20','',''),(2009,'1','223','1',1,'Retail Sale Id 2186',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 14:12:16','',''),(2010,'1','223','1',1,'Retail Sale Id 2187',3100.00,0.00,0.00,5.00,160.00,'2022-03-28 14:44:10','',''),(2011,'1','223','1',1,'Retail Sale Id 2188',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 15:06:13','',''),(2012,'1','223','1',1,'Retail Sale Id 2189',7750.00,0.00,0.00,12.50,400.00,'2022-03-28 15:08:33','',''),(2013,'1','223','1',1,'Retail Sale Id 2190',1897.20,0.00,0.00,3.06,97.92,'2022-03-28 15:27:55','',''),(2014,'1','223','1',1,'Retail Sale Id 2191',1500.40,0.00,0.00,2.42,77.44,'2022-03-28 15:42:30','',''),(2015,'1','223','1',1,'Retail Sale Id 2192',700.60,0.00,0.00,1.13,36.16,'2022-03-28 16:04:14','',''),(2016,'1','223','1',1,'Retail Sale Id 2193',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 16:12:11','',''),(2017,'1','223','1',1,'Retail Sale Id 2194',3100.00,0.00,0.00,5.00,160.00,'2022-03-28 16:21:58','',''),(2018,'1','223','1',1,'Retail Sale Id 2195',2498.60,0.00,0.00,4.03,128.96,'2022-03-28 16:26:36','',''),(2019,'1','223','1',1,'Retail Sale Id 2196',3100.00,0.00,0.00,5.00,160.00,'2022-03-28 16:34:35','',''),(2020,'1','223','1',1,'Retail Sale Id 2197',1240.00,0.00,0.00,2.00,64.00,'2022-03-28 16:36:02','',''),(2021,'1','223','1',1,'Retail Sale Id 2198',1897.20,0.00,0.00,3.06,97.92,'2022-03-28 16:40:01','',''),(2022,'1','223','1',1,'Retail Sale Id 2199',3000.80,0.00,0.00,4.84,154.88,'2022-03-28 16:59:46','',''),(2023,'1','223','1',1,'Retail Sale Id 2200',5580.00,0.00,0.00,9.00,288.00,'2022-03-28 17:09:23','',''),(2024,'1','223','1',1,'Return of Retail Sale Id 2200',0.00,5580.00,9.00,0.00,-288.00,'2022-03-28 17:12:33','',''),(2025,'1','223','1',1,'Retail Sale Id 2201',3751.00,0.00,0.00,6.05,193.60,'2022-03-28 17:13:37','',''),(2026,'1','223','1',1,'Retail Sale Id 2202',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 17:15:06','',''),(2027,'1','223','1',1,'Retail Sale Id 2203',1202.80,0.00,0.00,1.94,62.08,'2022-03-28 17:23:28','',''),(2028,'1','223','1',1,'Retail Sale Id 2204',2002.60,0.00,0.00,3.23,103.36,'2022-03-28 17:26:00','',''),(2029,'1','223','1',1,'Retail Sale Id 2205',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 17:28:51','',''),(2030,'1','223','1',1,'Retail Sale Id 2206',620.00,0.00,0.00,1.00,32.00,'2022-03-28 17:31:04','',''),(2031,'1','223','1',1,'Retail Sale Id 2207',4352.40,0.00,0.00,7.02,224.64,'2022-03-28 17:40:50','',''),(2032,'1','223','1',1,'Retail Sale Id 2208',3720.00,0.00,0.00,6.00,192.00,'2022-03-28 17:42:33','',''),(2033,'1','223','1',1,'Retail Sale Id 2209',1240.00,0.00,0.00,2.00,64.00,'2022-03-28 17:43:53','',''),(2034,'1','223','1',1,'Retail Sale Id 2210',1240.00,0.00,0.00,2.00,64.00,'2022-03-28 17:45:15','',''),(2035,'1','223','1',1,'Retail Sale Id 2211',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 17:48:21','',''),(2036,'1','223','1',1,'Retail Sale Id 2212',1240.00,0.00,0.00,2.00,64.00,'2022-03-28 17:54:50','',''),(2037,'1','223','1',1,'Retail Sale Id 2213',3720.00,0.00,0.00,6.00,192.00,'2022-03-28 17:56:54','',''),(2038,'1','223','1',1,'Retail Sale Id 2214',1202.80,0.00,0.00,1.94,62.08,'2022-03-28 18:00:26','',''),(2039,'1','223','1',1,'Retail Sale Id 2215',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 18:03:36','',''),(2040,'1','223','1',1,'Retail Sale Id 2216',1252.40,0.00,0.00,2.02,64.64,'2022-03-28 18:08:46','',''),(2041,'1','223','1',1,'Retail Sale Id 2217',24000.00,0.00,0.00,40.00,480.00,'2022-03-28 18:13:36','',''),(2042,'1','223','1',1,'Retail Sale Id 2218',7750.00,0.00,0.00,12.50,400.00,'2022-03-28 18:16:41','',''),(2043,'1','223','1',1,'Retail Sale Id 2219',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 18:26:51','',''),(2044,'1','223','1',1,'Retail Sale Id 2220',1897.20,0.00,0.00,3.06,97.92,'2022-03-28 18:28:17','',''),(2045,'1','223','1',1,'Retail Sale Id 2221',651.00,0.00,0.00,1.05,33.60,'2022-03-28 18:32:15','',''),(2046,'1','223','1',1,'Retail Sale Id 2223',3720.00,0.00,0.00,6.00,192.00,'2022-03-28 18:38:18','',''),(2047,'1','223','1',1,'Retail Sale Id 2224',1500.40,0.00,0.00,2.42,77.44,'2022-03-28 18:42:35','',''),(2048,'1','223','1',1,'Retail Sale Id 2225',998.20,0.00,0.00,1.61,51.52,'2022-03-28 18:50:32','',''),(2049,'1','223','1',1,'Retail Sale Id 2226',998.20,0.00,0.00,1.61,51.52,'2022-03-28 18:53:59','',''),(2050,'1','223','1',1,'Retail Sale Id 2228',1252.40,0.00,0.00,2.02,64.64,'2022-03-28 18:57:02','',''),(2051,'1','223','1',1,'Retail Sale Id 2229',3720.00,0.00,0.00,6.00,192.00,'2022-03-28 19:03:12','',''),(2052,'1','223','1',1,'Retail Sale Id 2230',1860.00,0.00,0.00,3.00,96.00,'2022-03-28 19:10:24','',''),(2053,'1','223','1',1,'Retail Sale Id 2231',7750.00,0.00,0.00,12.50,400.00,'2022-03-29 07:07:15','',''),(2054,'1','223','1',1,'Retail Sale Id 2232',1252.40,0.00,0.00,2.02,64.64,'2022-03-29 07:29:29','',''),(2055,'1','223','1',1,'Retail Sale Id 2233',1252.40,0.00,0.00,2.02,64.64,'2022-03-29 08:04:30','',''),(2056,'1','223','1',1,'Retail Sale Id 2235',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 08:06:34','',''),(2057,'1','223','1',1,'Retail Sale Id 2236',1897.20,0.00,0.00,3.06,97.92,'2022-03-29 08:09:12','',''),(2058,'1','223','1',1,'Retail Sale Id 2237',1252.40,0.00,0.00,2.02,64.64,'2022-03-29 08:12:47','',''),(2059,'1','223','1',1,'Retail Sale Id 2238',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 08:22:17','',''),(2060,'1','223','1',1,'Retail Sale Id 2239',3999.00,0.00,0.00,6.45,206.40,'2022-03-29 08:23:28','',''),(2061,'1','223','1',1,'Return of Retail Sale Id 2238',0.00,3720.00,6.00,0.00,-192.00,'2022-03-29 08:24:25','',''),(2062,'1','223','1',1,'Retail Sale Id 2240',651.00,0.00,0.00,1.05,33.60,'2022-03-29 08:33:47','',''),(2063,'1','223','1',1,'Retail Sale Id 2241',3751.00,0.00,0.00,6.05,193.60,'2022-03-29 08:35:07','',''),(2064,'1','223','1',1,'Retail Sale Id 2242',1860.00,0.00,0.00,3.00,96.00,'2022-03-29 08:36:58','',''),(2065,'1','223','1',1,'Retail Sale Id 2243',7750.00,0.00,0.00,12.50,400.00,'2022-03-29 08:40:54','',''),(2066,'1','223','1',1,'Retail Sale Id 2244',3100.00,0.00,0.00,5.00,160.00,'2022-03-29 08:42:14','',''),(2067,'1','223','1',1,'Retail Sale Id 2245',1202.80,0.00,0.00,1.94,62.08,'2022-03-29 08:50:51','',''),(2068,'1','223','1',1,'Retail Sale Id 2246',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 08:51:25','',''),(2069,'1','223','1',1,'Retail Sale Id 2247',1240.00,0.00,0.00,2.00,64.00,'2022-03-29 08:56:27','',''),(2070,'1','223','1',1,'Retail Sale Id 2248',998.20,0.00,0.00,1.61,51.52,'2022-03-29 08:57:07','',''),(2071,'1','223','1',1,'Retail Sale Id 2249',1252.40,0.00,0.00,2.02,64.64,'2022-03-29 09:04:41','',''),(2072,'1','223','1',1,'Retail Sale Id 2250',651.00,0.00,0.00,1.05,33.60,'2022-03-29 09:15:10','',''),(2073,'1','223','1',1,'Retail Sale Id 2251',1252.40,0.00,0.00,2.02,64.64,'2022-03-29 09:16:32','',''),(2074,'1','223','1',1,'Retail Sale Id 2252',998.20,0.00,0.00,1.61,51.52,'2022-03-29 09:23:27','',''),(2075,'1','223','1',1,'Retail Sale Id 2253',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 09:24:17','',''),(2076,'1','223','1',1,'Retail Sale Id 2254',30000.00,0.00,0.00,50.00,600.00,'2022-03-29 09:27:43','',''),(2077,'1','223','1',1,'Retail Sale Id 2255',1860.00,0.00,0.00,3.00,96.00,'2022-03-29 09:29:50','',''),(2078,'1','223','1',1,'Retail Sale Id 2256',3100.00,0.00,0.00,5.00,160.00,'2022-03-29 09:48:52','',''),(2079,'1','223','1',1,'Retail Sale Id 2257',1202.80,0.00,0.00,1.94,62.08,'2022-03-29 09:54:52','',''),(2080,'1','223','1',1,'Retail Sale Id 2258',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 09:59:11','',''),(2081,'1','223','1',1,'Retail Sale Id 2259',1202.80,0.00,0.00,1.94,62.08,'2022-03-29 10:08:34','',''),(2082,'1','223','1',1,'Retail Sale Id 2260',998.20,0.00,0.00,1.61,51.52,'2022-03-29 10:15:57','',''),(2083,'1','223','1',1,'Retail Sale Id 2261',651.00,0.00,0.00,1.05,33.60,'2022-03-29 10:24:58','',''),(2084,'1','223','1',1,'Retail Sale Id 2262',3100.00,0.00,0.00,5.00,160.00,'2022-03-29 10:25:48','',''),(2085,'1','223','1',1,'Retail Sale Id 2263',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 10:32:07','',''),(2086,'1','223','1',1,'Retail Sale Id 2264',1860.00,0.00,0.00,3.00,96.00,'2022-03-29 10:39:22','',''),(2087,'1','223','1',1,'Retail Sale Id 2265',1897.20,0.00,0.00,3.06,97.92,'2022-03-29 11:18:01','',''),(2088,'1','223','1',1,'Retail Sale Id 2266',1897.20,0.00,0.00,3.06,97.92,'2022-03-29 11:20:08','',''),(2089,'1','223','1',1,'Retail Sale Id 2267',75000.00,0.00,0.00,125.00,1500.00,'2022-03-29 11:38:46','',''),(2090,'1','223','1',1,'Retail Sale Id 2268',3100.00,0.00,0.00,5.00,160.00,'2022-03-29 11:42:48','',''),(2091,'1','223','1',1,'Retail Sale Id 2269',21000.00,0.00,0.00,35.00,420.00,'2022-03-29 11:45:07','',''),(2092,'1','223','1',1,'Retail Sale Id 2270',30000.00,0.00,0.00,50.00,600.00,'2022-03-29 11:46:54','',''),(2093,'1','223','1',1,'Return of Retail Sale Id 2269',0.00,21000.00,35.00,0.00,-420.00,'2022-03-29 11:47:28','',''),(2094,'1','223','1',1,'Retail Sale Id 2271',1872.40,0.00,0.00,3.02,96.64,'2022-03-29 11:52:39','',''),(2095,'1','223','1',1,'Retail Sale Id 2272',1897.20,0.00,0.00,3.06,97.92,'2022-03-29 11:56:45','',''),(2096,'1','223','1',1,'Retail Sale Id 2273',1252.40,0.00,0.00,2.02,64.64,'2022-03-29 12:34:22','',''),(2097,'1','223','1',1,'Retail Sale Id 2274',1500.40,0.00,0.00,2.42,77.44,'2022-03-29 12:37:53','',''),(2098,'1','223','1',1,'Retail Sale Id 2275',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 12:47:36','',''),(2099,'1','223','1',1,'Retail Sale Id 2276',1252.40,0.00,0.00,2.02,64.64,'2022-03-29 12:56:59','',''),(2100,'1','223','1',1,'Retail Sale Id 2277',2498.60,0.00,0.00,4.03,128.96,'2022-03-29 13:02:07','',''),(2101,'1','223','1',1,'Retail Sale Id 2278',4960.00,0.00,0.00,8.00,256.00,'2022-03-29 13:21:42','',''),(2102,'1','223','1',1,'Retail Sale Id 2279',1847.60,0.00,0.00,2.98,95.36,'2022-03-29 14:25:11','',''),(2103,'1','223','1',1,'Retail Sale Id 2280',1860.00,0.00,0.00,3.00,96.00,'2022-03-29 14:58:32','',''),(2104,'1','223','1',1,'Retail Sale Id 2281',1252.40,0.00,0.00,2.02,64.64,'2022-03-29 15:00:12','',''),(2105,'1','223','1',1,'Retail Sale Id 2282',7750.00,0.00,0.00,12.50,400.00,'2022-03-29 15:10:28','',''),(2106,'1','223','1',1,'Retail Sale Id 2283',1500.40,0.00,0.00,2.42,77.44,'2022-03-29 15:15:57','',''),(2107,'1','223','1',1,'Retail Sale Id 2284',7750.00,0.00,0.00,12.50,400.00,'2022-03-29 15:23:19','',''),(2108,'1','223','1',1,'Retail Sale Id 2285',3100.00,0.00,0.00,5.00,160.00,'2022-03-29 15:35:39','',''),(2109,'1','223','1',1,'Retail Sale Id 2286',3100.00,0.00,0.00,5.00,160.00,'2022-03-29 15:38:28','',''),(2110,'1','223','1',1,'Retail Sale Id 2287',1860.00,0.00,0.00,3.00,96.00,'2022-03-29 15:41:46','',''),(2111,'1','223','1',1,'Retail Sale Id 2288',2480.00,0.00,0.00,4.00,128.00,'2022-03-29 16:20:38','',''),(2112,'1','223','1',1,'Retail Sale Id 2289',1897.20,0.00,0.00,3.06,97.92,'2022-03-29 16:22:46','',''),(2113,'1','223','1',1,'Retail Sale Id 2290',1252.40,0.00,0.00,2.02,64.64,'2022-03-29 16:23:43','',''),(2114,'1','223','1',1,'Retail Sale Id 2291',7750.00,0.00,0.00,12.50,400.00,'2022-03-29 16:24:55','',''),(2115,'1','223','1',1,'Retail Sale Id 2292',2002.60,0.00,0.00,3.23,103.36,'2022-03-29 16:26:15','',''),(2116,'1','223','1',1,'Retail Sale Id 2293',620.00,0.00,0.00,1.00,32.00,'2022-03-29 16:28:16','',''),(2117,'1','223','1',1,'Retail Sale Id 2294',1798.00,0.00,0.00,2.90,92.80,'2022-03-29 16:35:49','',''),(2118,'1','223','1',1,'Retail Sale Id 2295',4997.20,0.00,0.00,8.06,257.92,'2022-03-29 16:37:03','',''),(2119,'1','223','1',1,'Retail Sale Id 2296',3000.80,0.00,0.00,4.84,154.88,'2022-03-29 16:41:19','',''),(2120,'1','223','1',1,'Retail Sale Id 2297',3000.80,0.00,0.00,4.84,154.88,'2022-03-29 16:42:21','',''),(2121,'1','223','1',1,'Retail Sale Id 2298',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 16:43:49','',''),(2122,'1','223','1',1,'Retail Sale Id 2299',651.00,0.00,0.00,1.05,33.60,'2022-03-29 16:45:07','',''),(2123,'1','223','1',1,'Retail Sale Id 2300',1302.00,0.00,0.00,2.10,67.20,'2022-03-29 16:47:04','',''),(2124,'1','223','1',1,'Retail Sale Id 2301',1302.00,0.00,0.00,2.10,67.20,'2022-03-29 16:50:55','',''),(2125,'1','223','1',1,'Retail Sale Id 2302',1897.20,0.00,0.00,3.06,97.92,'2022-03-29 16:53:19','',''),(2126,'1','223','1',1,'Retail Sale Id 2303',3999.00,0.00,0.00,6.45,206.40,'2022-03-29 16:54:58','',''),(2127,'1','223','1',1,'Retail Sale Id 2304',6200.00,0.00,0.00,10.00,320.00,'2022-03-29 17:01:38','',''),(2128,'1','223','1',1,'Retail Sale Id 2305',998.20,0.00,0.00,1.61,51.52,'2022-03-29 17:03:10','',''),(2129,'1','223','1',1,'Retail Sale Id 2306',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 17:08:06','',''),(2130,'1','223','1',1,'Retail Sale Id 2307',2498.60,0.00,0.00,4.03,128.96,'2022-03-29 17:10:02','',''),(2131,'1','223','1',1,'Retail Sale Id 2308',998.20,0.00,0.00,1.61,51.52,'2022-03-29 17:11:53','',''),(2132,'1','223','1',1,'Retail Sale Id 2309',3100.00,0.00,0.00,5.00,160.00,'2022-03-29 17:13:03','',''),(2133,'1','223','1',1,'Retail Sale Id 2310',620.00,0.00,0.00,1.00,32.00,'2022-03-29 17:21:48','',''),(2134,'1','223','1',1,'Retail Sale Id 2311',1847.60,0.00,0.00,2.98,95.36,'2022-03-29 17:26:16','',''),(2135,'1','223','1',1,'Retail Sale Id 2312',1860.00,0.00,0.00,3.00,96.00,'2022-03-29 17:27:53','',''),(2136,'1','223','1',1,'Retail Sale Id 2313',3100.00,0.00,0.00,5.00,160.00,'2022-03-29 17:30:00','',''),(2137,'1','223','1',1,'Retail Sale Id 2315',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 17:42:14','',''),(2138,'1','223','1',1,'Retail Sale Id 2316',3100.00,0.00,0.00,5.00,160.00,'2022-03-29 17:51:06','',''),(2139,'1','223','1',1,'Retail Sale Id 2317',1897.20,0.00,0.00,3.06,97.92,'2022-03-29 18:01:11','',''),(2140,'1','223','1',1,'Retail Sale Id 2318',7750.00,0.00,0.00,12.50,400.00,'2022-03-29 18:07:23','',''),(2141,'1','223','1',1,'Retail Sale Id 2319',1550.00,0.00,0.00,2.50,80.00,'2022-03-29 18:14:55','',''),(2142,'1','223','1',1,'Retail Sale Id 2320',2002.60,0.00,0.00,3.23,103.36,'2022-03-29 18:16:56','',''),(2143,'1','223','1',1,'Retail Sale Id 2321',998.20,0.00,0.00,1.61,51.52,'2022-03-29 18:18:14','',''),(2144,'1','223','1',1,'Retail Sale Id 2322',1202.80,0.00,0.00,1.94,62.08,'2022-03-29 18:19:20','',''),(2145,'1','223','1',1,'Retail Sale Id 2326',1860.00,0.00,0.00,3.00,96.00,'2022-03-29 18:27:08','',''),(2146,'1','223','1',1,'Retail Sale Id 2328',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 18:40:03','',''),(2147,'1','223','1',1,'Retail Sale Id 2329',998.20,0.00,0.00,1.61,51.52,'2022-03-29 18:42:32','',''),(2148,'1','223','1',1,'Retail Sale Id 2330',998.20,0.00,0.00,1.61,51.52,'2022-03-29 18:44:35','',''),(2149,'1','223','1',1,'Retail Sale Id 2331',3720.00,0.00,0.00,6.00,192.00,'2022-03-29 19:11:43','',''),(2150,'1','223','1',1,'Retail Sale Id 2332',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 07:04:18','',''),(2151,'1','223','1',1,'Retail Sale Id 2333',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 07:19:22','',''),(2152,'1','223','1',1,'Retail Sale Id 2334',4340.00,0.00,0.00,7.00,224.00,'2022-03-30 07:21:06','',''),(2153,'1','223','1',1,'Retail Sale Id 2335',2498.60,0.00,0.00,4.03,128.96,'2022-03-30 07:37:19','',''),(2154,'1','223','1',1,'Retail Sale Id 2336',1252.40,0.00,0.00,2.02,64.64,'2022-03-30 07:48:56','',''),(2155,'1','223','1',1,'Retail Sale Id 2337',620.00,0.00,0.00,1.00,32.00,'2022-03-30 07:50:22','',''),(2156,'1','223','1',1,'Retail Sale Id 2338',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 07:55:40','',''),(2157,'1','223','1',1,'Retail Sale Id 2339',1252.40,0.00,0.00,2.02,64.64,'2022-03-30 08:02:24','',''),(2158,'1','223','1',1,'Retail Sale Id 2340',1252.40,0.00,0.00,2.02,64.64,'2022-03-30 08:06:35','',''),(2159,'1','223','1',1,'Retail Sale Id 2341',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 08:07:29','',''),(2160,'1','223','1',1,'Retail Sale Id 2342',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 08:09:21','',''),(2161,'1','223','1',1,'Retail Sale Id 2343',1897.20,0.00,0.00,3.06,97.92,'2022-03-30 08:16:12','',''),(2162,'1','223','1',1,'Retail Sale Id 2344',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 08:23:13','',''),(2163,'1','223','1',1,'Retail Sale Id 2345',1860.00,0.00,0.00,3.00,96.00,'2022-03-30 08:26:41','',''),(2164,'1','223','1',1,'Retail Sale Id 2346',998.20,0.00,0.00,1.61,51.52,'2022-03-30 08:28:51','',''),(2165,'1','223','1',1,'Retail Sale Id 2347',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 08:33:54','',''),(2166,'1','223','1',1,'Retail Sale Id 2348',34800.00,0.00,0.00,58.00,696.00,'2022-03-30 08:47:33','',''),(2167,'1','223','1',1,'Retail Sale Id 2349',1860.00,0.00,0.00,3.00,96.00,'2022-03-30 09:22:58','',''),(2168,'1','223','1',1,'Retail Sale Id 2350',1897.20,0.00,0.00,3.06,97.92,'2022-03-30 09:24:42','',''),(2169,'1','223','1',1,'Retail Sale Id 2351',1897.20,0.00,0.00,3.06,97.92,'2022-03-30 09:26:04','',''),(2170,'1','223','1',1,'Retail Sale Id 2352',2498.60,0.00,0.00,4.03,128.96,'2022-03-30 09:28:42','',''),(2171,'1','223','1',1,'Retail Sale Id 2353',2480.00,0.00,0.00,4.00,128.00,'2022-03-30 09:36:07','',''),(2172,'1','223','1',1,'Retail Sale Id 2354',2480.00,0.00,0.00,4.00,128.00,'2022-03-30 09:39:03','',''),(2173,'1','223','1',1,'Retail Sale Id 2355',7750.00,0.00,0.00,12.50,400.00,'2022-03-30 09:43:42','',''),(2174,'1','223','1',1,'Retail Sale Id 2356',1860.00,0.00,0.00,3.00,96.00,'2022-03-30 09:54:26','',''),(2175,'1','223','1',1,'Retail Sale Id 2357',1252.40,0.00,0.00,2.02,64.64,'2022-03-30 09:58:53','',''),(2176,'1','223','1',1,'Retail Sale Id 2358',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 10:00:18','',''),(2177,'1','223','1',1,'Retail Sale Id 2359',1897.20,0.00,0.00,3.06,97.92,'2022-03-30 10:01:28','',''),(2178,'1','223','1',1,'Return of Retail Sale Id 2358',0.00,3720.00,6.00,0.00,-192.00,'2022-03-30 10:02:06','',''),(2179,'1','223','1',1,'Retail Sale Id 2360',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 10:05:20','',''),(2180,'1','223','1',1,'Retail Sale Id 2361',2498.60,0.00,0.00,4.03,128.96,'2022-03-30 10:11:50','',''),(2181,'1','223','1',1,'Retail Sale Id 2362',6200.00,0.00,0.00,10.00,320.00,'2022-03-30 10:29:01','',''),(2182,'1','223','1',1,'Retail Sale Id 2363',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 10:35:05','',''),(2183,'1','223','1',1,'Retail Sale Id 2365',1500.40,0.00,0.00,2.42,77.44,'2022-03-30 11:08:49','',''),(2184,'1','223','1',1,'Retail Sale Id 2366',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 11:15:13','',''),(2185,'1','223','1',1,'Retail Sale Id 2367',1240.00,0.00,0.00,2.00,64.00,'2022-03-30 11:21:38','',''),(2186,'1','223','1',1,'Retail Sale Id 2368',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 11:31:03','',''),(2187,'1','223','1',1,'Retail Sale Id 2369',1202.80,0.00,0.00,1.94,62.08,'2022-03-30 11:33:11','',''),(2188,'1','223','1',1,'Retail Sale Id 2370',1860.00,0.00,0.00,3.00,96.00,'2022-03-30 11:37:20','',''),(2189,'1','223','1',1,'Retail Sale Id 2371',1252.40,0.00,0.00,2.02,64.64,'2022-03-30 11:44:11','',''),(2190,'1','223','1',1,'Retail Sale Id 2372',2498.60,0.00,0.00,4.03,128.96,'2022-03-30 12:19:30','',''),(2191,'1','223','1',1,'Retail Sale Id 2373',1897.20,0.00,0.00,3.06,97.92,'2022-03-30 12:42:17','',''),(2192,'1','223','1',1,'Retail Sale Id 2374',998.20,0.00,0.00,1.61,51.52,'2022-03-30 12:44:25','',''),(2193,'1','223','1',1,'Retail Sale Id 2375',1897.20,0.00,0.00,3.06,97.92,'2022-03-30 12:47:02','',''),(2194,'1','223','1',1,'Retail Sale Id 2376',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 13:03:12','',''),(2195,'1','223','1',1,'Retail Sale Id 2377',799.80,0.00,0.00,1.29,41.28,'2022-03-30 13:16:31','',''),(2196,'1','223','1',1,'Retail Sale Id 2378',1500.40,0.00,0.00,2.42,77.44,'2022-03-30 13:22:23','',''),(2197,'1','223','1',1,'Retail Sale Id 2379',1860.00,0.00,0.00,3.00,96.00,'2022-03-30 13:31:23','',''),(2198,'1','223','1',1,'Retail Sale Id 2380',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 13:39:52','',''),(2199,'1','223','1',1,'Retail Sale Id 2381',2002.60,0.00,0.00,3.23,103.36,'2022-03-30 13:43:45','',''),(2200,'1','223','1',1,'Retail Sale Id 2382',2498.60,0.00,0.00,4.03,128.96,'2022-03-30 14:07:21','',''),(2201,'1','223','1',1,'Retail Sale Id 2383',1897.20,0.00,0.00,3.06,97.92,'2022-03-30 14:57:23','',''),(2202,'1','223','1',1,'Retail Sale Id 2384',6702.20,0.00,0.00,10.81,345.92,'2022-03-30 15:25:49','',''),(2203,'1','223','1',1,'Retail Sale Id 2385',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 15:27:24','',''),(2204,'1','223','1',1,'Retail Sale Id 2386',1847.60,0.00,0.00,2.98,95.36,'2022-03-30 15:37:20','',''),(2205,'1','223','1',1,'Retail Sale Id 2387',1897.20,0.00,0.00,3.06,97.92,'2022-03-30 15:39:51','',''),(2206,'1','223','1',1,'Retail Sale Id 2389',1847.60,0.00,0.00,2.98,95.36,'2022-03-30 15:41:45','',''),(2207,'1','223','1',1,'Retail Sale Id 2390',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 16:04:26','',''),(2208,'1','223','1',1,'Retail Sale Id 2391',3751.00,0.00,0.00,6.05,193.60,'2022-03-30 16:13:36','',''),(2209,'1','223','1',1,'Retail Sale Id 2392',651.00,0.00,0.00,1.05,33.60,'2022-03-30 16:17:52','',''),(2210,'1','223','1',1,'Retail Sale Id 2393',4960.00,0.00,0.00,8.00,256.00,'2022-03-30 16:47:49','',''),(2211,'1','223','1',1,'Retail Sale Id 2394',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 16:49:20','',''),(2212,'1','223','1',1,'Retail Sale Id 2395',7750.00,0.00,0.00,12.50,400.00,'2022-03-30 17:01:21','',''),(2213,'1','223','1',1,'Return of Retail Sale Id 2395',0.00,7750.00,12.50,0.00,-400.00,'2022-03-30 17:02:37','',''),(2214,'1','223','1',1,'Retail Sale Id 2396',6999.80,0.00,0.00,11.29,361.28,'2022-03-30 17:03:49','',''),(2215,'1','223','1',1,'Retail Sale Id 2397',7750.00,0.00,0.00,12.50,400.00,'2022-03-30 17:05:36','',''),(2216,'1','223','1',1,'Retail Sale Id 2398',1897.20,0.00,0.00,3.06,97.92,'2022-03-30 17:09:30','',''),(2217,'1','223','1',1,'Retail Sale Id 2399',4960.00,0.00,0.00,8.00,256.00,'2022-03-30 17:11:50','',''),(2218,'1','223','1',1,'Retail Sale Id 2400',6200.00,0.00,0.00,10.00,320.00,'2022-03-30 17:18:55','',''),(2219,'1','223','1',1,'Retail Sale Id 2401',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 17:21:05','',''),(2220,'1','223','1',1,'Retail Sale Id 2402',1897.20,0.00,0.00,3.06,97.92,'2022-03-30 17:24:54','',''),(2221,'1','223','1',1,'Retail Sale Id 2403',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 17:29:20','',''),(2222,'1','223','1',1,'Retail Sale Id 2404',5580.00,0.00,0.00,9.00,288.00,'2022-03-30 17:31:08','',''),(2223,'1','223','1',1,'Retail Sale Id 2405',3751.00,0.00,0.00,6.05,193.60,'2022-03-30 17:32:44','',''),(2224,'1','223','1',1,'Retail Sale Id 2406',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 17:33:44','',''),(2225,'1','223','1',1,'Retail Sale Id 2407',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 17:41:35','',''),(2226,'1','223','1',1,'Retail Sale Id 2408',1500.40,0.00,0.00,2.42,77.44,'2022-03-30 17:42:32','',''),(2227,'1','223','1',1,'Retail Sale Id 2409',3751.00,0.00,0.00,6.05,193.60,'2022-03-30 17:44:42','',''),(2228,'1','223','1',1,'Retail Sale Id 2410',1202.80,0.00,0.00,1.94,62.08,'2022-03-30 17:56:35','',''),(2229,'1','223','1',1,'Retail Sale Id 2411',3751.00,0.00,0.00,6.05,193.60,'2022-03-30 17:58:28','',''),(2230,'1','223','1',1,'Retail Sale Id 2412',1500.40,0.00,0.00,2.42,77.44,'2022-03-30 18:03:53','',''),(2231,'1','223','1',1,'Retail Sale Id 2413',2480.00,0.00,0.00,4.00,128.00,'2022-03-30 18:07:53','',''),(2232,'1','223','1',1,'Retail Sale Id 2414',620.00,0.00,0.00,1.00,32.00,'2022-03-30 18:09:28','',''),(2233,'1','223','1',1,'Retail Sale Id 2415',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 18:16:26','',''),(2234,'1','223','1',1,'Retail Sale Id 2416',1860.00,0.00,0.00,3.00,96.00,'2022-03-30 18:20:53','',''),(2235,'1','223','1',1,'Retail Sale Id 2417',3100.00,0.00,0.00,5.00,160.00,'2022-03-30 18:31:31','',''),(2236,'1','223','1',1,'Retail Sale Id 2418',2480.00,0.00,0.00,4.00,128.00,'2022-03-30 18:36:00','',''),(2237,'1','223','1',1,'Retail Sale Id 2419',3720.00,0.00,0.00,6.00,192.00,'2022-03-30 18:38:22','',''),(2238,'1','223','1',1,'Retail Sale Id 2420',998.20,0.00,0.00,1.61,51.52,'2022-03-30 18:42:21','',''),(2239,'1','223','1',1,'Retail Sale Id 2421',1252.40,0.00,0.00,2.02,64.64,'2022-03-30 18:50:45','',''),(2240,'1','223','1',1,'Retail Sale Id 2422',3751.00,0.00,0.00,6.05,193.60,'2022-03-31 07:33:26','',''),(2241,'1','223','1',1,'Retail Sale Id 2423',1240.00,0.00,0.00,2.00,64.00,'2022-03-31 07:42:20','',''),(2242,'1','223','1',1,'Retail Sale Id 2424',1897.20,0.00,0.00,3.06,97.92,'2022-03-31 07:44:09','',''),(2243,'1','223','1',1,'Retail Sale Id 2425',6200.00,0.00,0.00,10.00,320.00,'2022-03-31 07:47:14','',''),(2244,'1','223','1',1,'Retail Sale Id 2426',3100.00,0.00,0.00,5.00,160.00,'2022-03-31 07:50:01','',''),(2245,'1','223','1',1,'Return of Retail Sale Id 2426',0.00,3100.00,5.00,0.00,-160.00,'2022-03-31 07:50:44','',''),(2246,'1','223','1',1,'Retail Sale Id 2427',1500.40,0.00,0.00,2.42,77.44,'2022-03-31 07:51:14','',''),(2247,'1','223','1',1,'Retail Sale Id 2428',1252.40,0.00,0.00,2.02,64.64,'2022-03-31 07:53:14','',''),(2248,'1','223','1',1,'Retail Sale Id 2429',1897.20,0.00,0.00,3.06,97.92,'2022-03-31 08:15:24','',''),(2249,'1','223','1',1,'Retail Sale Id 2430',3000.80,0.00,0.00,4.84,154.88,'2022-03-31 08:37:53','',''),(2250,'1','223','1',1,'Retail Sale Id 2431',3701.40,0.00,0.00,5.97,191.04,'2022-03-31 08:42:43','',''),(2251,'1','223','1',1,'Retail Sale Id 2432',1860.00,0.00,0.00,3.00,96.00,'2022-03-31 08:44:37','',''),(2252,'1','223','1',1,'Retail Sale Id 2433',3751.00,0.00,0.00,6.05,193.60,'2022-03-31 08:45:50','',''),(2253,'1','223','1',1,'Retail Sale Id 2434',3751.00,0.00,0.00,6.05,193.60,'2022-03-31 09:15:43','',''),(2254,'1','223','1',1,'Retail Sale Id 2435',2002.60,0.00,0.00,3.23,103.36,'2022-03-31 09:24:46','',''),(2255,'1','223','1',1,'Retail Sale Id 2436',6200.00,0.00,0.00,10.00,320.00,'2022-03-31 09:26:53','',''),(2256,'1','223','1',1,'Retail Sale Id 2437',1897.20,0.00,0.00,3.06,97.92,'2022-03-31 09:32:52','',''),(2257,'1','223','1',1,'Retail Sale Id 2438',1401.20,0.00,0.00,2.26,72.32,'2022-03-31 09:35:47','',''),(2258,'1','223','1',1,'Retail Sale Id 2439',18000.00,0.00,0.00,30.00,360.00,'2022-03-31 09:45:09','',''),(2259,'1','223','1',1,'Retail Sale Id 2440',3100.00,0.00,0.00,5.00,160.00,'2022-03-31 09:49:22','',''),(2260,'1','223','1',1,'Retail Sale Id 2441',1897.20,0.00,0.00,3.06,97.92,'2022-03-31 09:50:59','',''),(2261,'1','223','1',1,'Retail Sale Id 2442',1252.40,0.00,0.00,2.02,64.64,'2022-03-31 09:52:02','',''),(2262,'1','223','1',1,'Retail Sale Id 2443',1240.00,0.00,0.00,2.00,64.00,'2022-03-31 10:00:27','',''),(2263,'1','223','1',1,'Retail Sale Id 2444',6820.00,0.00,0.00,11.00,352.00,'2022-03-31 10:26:33','',''),(2264,'1','223','1',1,'Retail Sale Id 2445',998.20,0.00,0.00,1.61,51.52,'2022-03-31 10:30:09','',''),(2265,'1','223','1',1,'Retail Sale Id 2446',651.00,0.00,0.00,1.05,33.60,'2022-03-31 10:33:14','',''),(2266,'1','223','1',1,'Retail Sale Id 2447',1252.40,0.00,0.00,2.02,64.64,'2022-03-31 10:34:43','',''),(2267,'1','223','1',1,'Retail Sale Id 2448',651.00,0.00,0.00,1.05,33.60,'2022-03-31 10:39:04','',''),(2268,'1','223','1',1,'Retail Sale Id 2449',651.00,0.00,0.00,1.05,33.60,'2022-03-31 10:43:17','',''),(2269,'1','223','1',1,'Retail Sale Id 2450',1252.40,0.00,0.00,2.02,64.64,'2022-03-31 10:44:36','',''),(2270,'1','223','1',1,'Retail Sale Id 2452',3720.00,0.00,0.00,6.00,192.00,'2022-03-31 10:49:16','',''),(2271,'1','223','1',1,'Retail Sale Id 2453',1860.00,0.00,0.00,3.00,96.00,'2022-03-31 10:52:24','',''),(2272,'1','223','1',1,'Retail Sale Id 2454',1860.00,0.00,0.00,3.00,96.00,'2022-03-31 11:08:25','',''),(2273,'1','223','1',1,'Return of Retail Sale Id 2454',0.00,1860.00,3.00,0.00,-96.00,'2022-03-31 11:09:18','',''),(2274,'1','223','1',1,'Retail Sale Id 2455',3100.00,0.00,0.00,5.00,160.00,'2022-03-31 11:09:55','',''),(2275,'1','223','1',1,'Retail Sale Id 2456',2498.60,0.00,0.00,4.03,128.96,'2022-03-31 11:33:59','',''),(2276,'1','223','1',1,'Retail Sale Id 2457',1860.00,0.00,0.00,3.00,96.00,'2022-03-31 11:35:19','',''),(2277,'1','223','1',1,'Retail Sale Id 2458',9300.00,0.00,0.00,15.00,480.00,'2022-03-31 11:41:19','',''),(2278,'1','223','1',1,'Retail Sale Id 2459',1897.20,0.00,0.00,3.06,97.92,'2022-03-31 11:45:07','',''),(2279,'1','223','1',1,'Retail Sale Id 2460',1202.80,0.00,0.00,1.94,62.08,'2022-03-31 11:46:32','',''),(2280,'1','223','1',1,'Retail Sale Id 2461',651.00,0.00,0.00,1.05,33.60,'2022-03-31 11:48:14','',''),(2281,'1','223','1',1,'Retail Sale Id 2462',1798.00,0.00,0.00,2.90,92.80,'2022-03-31 12:25:37','',''),(2282,'1','223','1',1,'Retail Sale Id 2463',6200.00,0.00,0.00,10.00,320.00,'2022-03-31 12:28:16','',''),(2283,'1','223','1',1,'Retail Sale Id 2465',3720.00,0.00,0.00,6.00,192.00,'2022-03-31 12:34:16','',''),(2284,'1','223','1',1,'Retail Sale Id 2466',1897.20,0.00,0.00,3.06,97.92,'2022-03-31 12:43:33','',''),(2285,'1','223','1',1,'Retail Sale Id 2467',7750.00,0.00,0.00,12.50,400.00,'2022-03-31 13:02:39','',''),(2286,'1','223','1',1,'Retail Sale Id 2468',7750.00,0.00,0.00,12.50,400.00,'2022-03-31 13:40:21','',''),(2287,'1','223','1',1,'Retail Sale Id 2469',127500.00,0.00,0.00,212.50,2550.00,'2022-03-31 13:59:07','',''),(2288,'1','223','1',1,'Retail Sale Id 2470',7750.00,0.00,0.00,12.50,400.00,'2022-03-31 14:26:18','',''),(2289,'1','223','1',1,'Retail Sale Id 2471',2300.20,0.00,0.00,3.71,118.72,'2022-03-31 14:35:19','',''),(2290,'1','223','1',1,'Retail Sale Id 2472',1860.00,0.00,0.00,3.00,96.00,'2022-03-31 14:47:05','',''),(2291,'1','223','1',1,'Retail Sale Id 2473',30000.00,0.00,0.00,50.00,600.00,'2022-03-31 15:56:38','',''),(2292,'1','223','1',1,'Retail Sale Id 2474',3720.00,0.00,0.00,6.00,192.00,'2022-03-31 16:07:56','',''),(2293,'1','223','1',1,'Retail Sale Id 2475',1897.20,0.00,0.00,3.06,97.92,'2022-03-31 16:18:44','',''),(2294,'1','223','1',1,'Retail Sale Id 2476',1860.00,0.00,0.00,3.00,96.00,'2022-03-31 16:20:16','',''),(2295,'1','223','1',1,'Retail Sale Id 2477',1240.00,0.00,0.00,2.00,64.00,'2022-03-31 16:20:52','',''),(2296,'1','223','1',1,'Retail Sale Id 2478',1897.20,0.00,0.00,3.06,97.92,'2022-03-31 16:23:07','',''),(2297,'1','223','1',1,'Retail Sale Id 2479',998.20,0.00,0.00,1.61,51.52,'2022-03-31 16:24:00','',''),(2298,'1','223','1',1,'Retail Sale Id 2480',651.00,0.00,0.00,1.05,33.60,'2022-03-31 16:24:40','',''),(2299,'1','223','1',1,'Retail Sale Id 2481',1860.00,0.00,0.00,3.00,96.00,'2022-03-31 16:25:35','',''),(2300,'1','223','1',1,'Retail Sale Id 2482',7750.00,0.00,0.00,12.50,400.00,'2022-03-31 16:40:58','',''),(2301,'1','223','1',1,'Retail Sale Id 2483',3100.00,0.00,0.00,5.00,160.00,'2022-03-31 16:45:12','',''),(2302,'1','223','1',1,'Retail Sale Id 2484',2498.60,0.00,0.00,4.03,128.96,'2022-03-31 16:47:55','',''),(2303,'1','223','1',1,'Retail Sale Id 2485',2480.00,0.00,0.00,4.00,128.00,'2022-03-31 16:49:29','',''),(2304,'1','223','1',1,'Retail Sale Id 2486',1240.00,0.00,0.00,2.00,64.00,'2022-03-31 16:52:50','',''),(2305,'1','223','1',1,'Retail Sale Id 2487',1202.80,0.00,0.00,1.94,62.08,'2022-03-31 16:58:31','',''),(2306,'1','223','1',1,'Retail Sale Id 2488',1302.00,0.00,0.00,2.10,67.20,'2022-03-31 17:00:05','',''),(2307,'1','223','1',1,'Retail Sale Id 2489',1860.00,0.00,0.00,3.00,96.00,'2022-03-31 17:01:19','',''),(2308,'1','223','1',1,'Retail Sale Id 2490',1252.40,0.00,0.00,2.02,64.64,'2022-03-31 17:02:10','',''),(2309,'1','223','1',1,'Return of Retail Sale Id 2488',0.00,1302.00,2.10,0.00,-67.20,'2022-03-31 17:03:34','',''),(2310,'1','223','1',1,'Retail Sale Id 2491',998.20,0.00,0.00,1.61,51.52,'2022-03-31 17:06:55','',''),(2311,'1','223','1',1,'Retail Sale Id 2492',1240.00,0.00,0.00,2.00,64.00,'2022-03-31 17:10:35','',''),(2312,'1','223','1',1,'Retail Sale Id 2493',1847.60,0.00,0.00,2.98,95.36,'2022-03-31 17:17:16','',''),(2313,'1','223','1',1,'Retail Sale Id 2494',6200.00,0.00,0.00,10.00,320.00,'2022-03-31 17:19:37','',''),(2314,'1','223','1',1,'Retail Sale Id 2495',3100.00,0.00,0.00,5.00,160.00,'2022-03-31 17:20:14','',''),(2315,'1','223','1',1,'Retail Sale Id 2496',3720.00,0.00,0.00,6.00,192.00,'2022-03-31 17:21:17','',''),(2316,'1','223','1',1,'Retail Sale Id 2497',2498.60,0.00,0.00,4.03,128.96,'2022-03-31 17:25:00','',''),(2317,'1','223','1',1,'Retail Sale Id 2498',651.00,0.00,0.00,1.05,33.60,'2022-03-31 17:27:45','',''),(2318,'1','223','1',1,'Retail Sale Id 2499',1860.00,0.00,0.00,3.00,96.00,'2022-03-31 17:31:06','',''),(2319,'1','223','1',1,'Retail Sale Id 2500',620.00,0.00,0.00,1.00,32.00,'2022-03-31 17:32:48','',''),(2320,'1','223','1',1,'Retail Sale Id 2501',632.40,0.00,0.00,1.02,32.64,'2022-03-31 17:38:26','',''),(2321,'1','223','1',1,'Retail Sale Id 2502',1748.40,0.00,0.00,2.82,90.24,'2022-03-31 17:45:57','',''),(2322,'1','223','1',1,'Retail Sale Id 2503',3000.80,0.00,0.00,4.84,154.88,'2022-03-31 17:49:13','',''),(2323,'1','223','1',1,'Retail Sale Id 2504',1240.00,0.00,0.00,2.00,64.00,'2022-03-31 17:51:04','',''),(2324,'1','223','1',1,'Retail Sale Id 2505',1252.40,0.00,0.00,2.02,64.64,'2022-03-31 18:03:20','',''),(2325,'1','223','1',1,'Retail Sale Id 2506',1252.40,0.00,0.00,2.02,64.64,'2022-03-31 18:12:52','',''),(2326,'1','223','1',1,'Retail Sale Id 2507',1860.00,0.00,0.00,3.00,96.00,'2022-03-31 18:26:24','',''),(2327,'1','223','1',1,'Retail Sale Id 2508',1252.40,0.00,0.00,2.02,64.64,'2022-03-31 18:30:47','',''),(2328,'1','223','1',1,'Retail Sale Id 2509',1500.40,0.00,0.00,2.42,77.44,'2022-03-31 19:00:49','',''),(2329,'1','223','1',1,'Retail Sale Id 2511',3720.00,0.00,0.00,6.00,192.00,'2022-03-31 19:02:37','',''),(2330,'1','223','1',1,'Retail Sale Id 2513',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 07:10:18','',''),(2331,'1','223','1',1,'Retail Sale Id 2514',1240.00,0.00,0.00,2.00,64.00,'2022-04-01 07:17:11','',''),(2332,'1','223','1',1,'Retail Sale Id 2515',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 07:31:45','',''),(2333,'1','223','1',1,'Retail Sale Id 2517',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 07:33:09','',''),(2334,'1','223','1',1,'Retail Sale Id 2518',7750.00,0.00,0.00,12.50,400.00,'2022-04-01 07:34:05','',''),(2335,'1','223','1',1,'Retail Sale Id 2519',1500.40,0.00,0.00,2.42,77.44,'2022-04-01 08:16:54','',''),(2336,'1','223','1',1,'Retail Sale Id 2520',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 08:25:32','',''),(2337,'1','223','1',1,'Retail Sale Id 2521',2002.60,0.00,0.00,3.23,103.36,'2022-04-01 08:29:50','',''),(2338,'1','223','1',1,'Retail Sale Id 2522',66000.00,0.00,0.00,110.00,1320.00,'2022-04-01 08:38:17','',''),(2339,'1','223','1',1,'Retail Sale Id 2524',1897.20,0.00,0.00,3.06,97.92,'2022-04-01 08:47:08','',''),(2340,'1','223','1',1,'Retail Sale Id 2526',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 08:53:41','',''),(2341,'1','223','1',1,'Retail Sale Id 2527',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 08:54:43','',''),(2342,'1','223','1',1,'Retail Sale Id 2528',3000.80,0.00,0.00,4.84,154.88,'2022-04-01 08:55:24','',''),(2343,'1','223','1',1,'Retail Sale Id 2529',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 08:59:52','',''),(2344,'1','223','1',1,'Retail Sale Id 2530',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 09:00:44','',''),(2345,'1','223','1',1,'Retail Sale Id 2531',620.00,0.00,0.00,1.00,32.00,'2022-04-01 09:04:15','',''),(2346,'1','223','1',1,'Retail Sale Id 2532',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 09:06:28','',''),(2347,'1','223','1',1,'Retail Sale Id 2535',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 09:09:59','',''),(2348,'1','223','1',1,'Retail Sale Id 2537',3503.00,0.00,0.00,5.65,180.80,'2022-04-01 09:15:41','',''),(2349,'1','223','1',1,'Retail Sale Id 2538',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 09:16:45','',''),(2350,'1','223','1',1,'Retail Sale Id 2539',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 09:21:00','',''),(2351,'1','223','1',1,'Retail Sale Id 2540',2480.00,0.00,0.00,4.00,128.00,'2022-04-01 09:25:40','',''),(2352,'1','223','1',1,'Retail Sale Id 2542',1897.20,0.00,0.00,3.06,97.92,'2022-04-01 09:41:36','',''),(2353,'1','223','1',1,'Retail Sale Id 2543',2002.60,0.00,0.00,3.23,103.36,'2022-04-01 09:42:37','',''),(2354,'1','223','1',1,'Retail Sale Id 2544',4960.00,0.00,0.00,8.00,256.00,'2022-04-01 09:45:59','',''),(2355,'1','223','1',1,'Retail Sale Id 2545',7750.00,0.00,0.00,12.50,400.00,'2022-04-01 10:02:00','',''),(2356,'1','223','1',1,'Retail Sale Id 2547',6820.00,0.00,0.00,11.00,352.00,'2022-04-01 10:07:06','',''),(2357,'1','223','1',1,'Retail Sale Id 2548',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 10:12:31','',''),(2358,'1','223','1',1,'Retail Sale Id 2549',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 10:18:35','',''),(2359,'1','223','1',1,'Retail Sale Id 2550',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 10:47:20','',''),(2360,'1','223','1',1,'Retail Sale Id 2551',24000.00,0.00,0.00,40.00,480.00,'2022-04-01 10:50:52','',''),(2361,'1','223','1',1,'Retail Sale Id 2552',2480.00,0.00,0.00,4.00,128.00,'2022-04-01 10:53:39','',''),(2362,'1','223','1',1,'Retail Sale Id 2553',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 10:55:36','',''),(2363,'1','223','1',1,'Retail Sale Id 2554',2480.00,0.00,0.00,4.00,128.00,'2022-04-01 10:58:53','',''),(2364,'1','223','1',1,'Retail Sale Id 2556',7750.00,0.00,0.00,12.50,400.00,'2022-04-01 11:49:54','',''),(2365,'1','223','1',1,'Retail Sale Id 2557',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 11:57:16','',''),(2366,'1','223','1',1,'Retail Sale Id 2558',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 12:15:04','',''),(2367,'1','223','1',1,'Retail Sale Id 2559',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 12:16:24','',''),(2368,'1','223','1',1,'Retail Sale Id 2560',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 12:40:08','',''),(2369,'1','223','1',1,'Retail Sale Id 2561',36000.00,0.00,0.00,60.00,720.00,'2022-04-01 12:50:53','',''),(2370,'1','223','1',1,'Retail Sale Id 2562',1240.00,0.00,0.00,2.00,64.00,'2022-04-01 13:00:29','',''),(2371,'1','223','1',1,'Retail Sale Id 2563',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 13:23:44','',''),(2372,'1','223','1',1,'Retail Sale Id 2565',2498.60,0.00,0.00,4.03,128.96,'2022-04-01 13:30:48','',''),(2373,'1','223','1',1,'Retail Sale Id 2566',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 14:04:09','',''),(2374,'1','223','1',1,'Retail Sale Id 2567',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 14:07:09','',''),(2375,'1','223','1',1,'Retail Sale Id 2568',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 14:10:30','',''),(2376,'1','223','1',1,'Retail Sale Id 2569',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 14:13:32','',''),(2377,'1','223','1',1,'Retail Sale Id 2570',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 14:14:32','',''),(2378,'1','223','1',1,'Retail Sale Id 2571',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 14:26:46','',''),(2379,'1','223','1',1,'Retail Sale Id 2572',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 14:28:35','',''),(2380,'1','223','1',1,'Retail Sale Id 2573',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 14:29:33','',''),(2381,'1','223','1',1,'Retail Sale Id 2574',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 14:33:51','',''),(2382,'1','223','1',1,'Retail Sale Id 2575',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 14:41:48','',''),(2383,'1','223','1',1,'Retail Sale Id 2577',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 14:44:23','',''),(2384,'1','223','1',1,'Retail Sale Id 2578',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 14:50:39','',''),(2385,'1','223','1',1,'Retail Sale Id 2579',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 14:53:12','',''),(2386,'1','223','1',1,'Return of Retail Sale Id 2578',0.00,3720.00,6.00,0.00,-192.00,'2022-04-01 14:56:34','',''),(2387,'1','223','1',1,'Retail Sale Id 2580',2002.60,0.00,0.00,3.23,103.36,'2022-04-01 14:57:08','',''),(2388,'1','223','1',1,'Retail Sale Id 2581',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 15:00:08','',''),(2389,'1','223','1',1,'Retail Sale Id 2583',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 15:07:07','',''),(2390,'1','223','1',1,'Retail Sale Id 2584',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 15:11:35','',''),(2391,'1','223','1',1,'Retail Sale Id 2585',6200.00,0.00,0.00,10.00,320.00,'2022-04-01 15:14:29','',''),(2392,'1','223','1',1,'Retail Sale Id 2586',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 15:20:03','',''),(2393,'1','223','1',1,'Retail Sale Id 2587',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 15:29:15','',''),(2394,'1','223','1',1,'Retail Sale Id 2588',7750.00,0.00,0.00,12.50,400.00,'2022-04-01 15:32:03','',''),(2395,'1','223','1',1,'Retail Sale Id 2589',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 15:37:03','',''),(2396,'1','223','1',1,'Retail Sale Id 2590',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 15:41:25','',''),(2397,'1','223','1',1,'Retail Sale Id 2591',1897.20,0.00,0.00,3.06,97.92,'2022-04-01 15:50:49','',''),(2398,'1','223','1',1,'Retail Sale Id 2592',1897.20,0.00,0.00,3.06,97.92,'2022-04-01 15:52:02','',''),(2399,'1','223','1',1,'Retail Sale Id 2593',1798.00,0.00,0.00,2.90,92.80,'2022-04-01 15:53:02','',''),(2400,'1','223','1',1,'Retail Sale Id 2594',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 15:54:08','',''),(2401,'1','223','1',1,'Retail Sale Id 2595',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 16:02:58','',''),(2402,'1','223','1',1,'Retail Sale Id 2596',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 16:05:33','',''),(2403,'1','223','1',1,'Retail Sale Id 2597',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 16:15:38','',''),(2404,'1','223','1',1,'Retail Sale Id 2598',998.20,0.00,0.00,1.61,51.52,'2022-04-01 16:24:51','',''),(2405,'1','223','1',1,'Retail Sale Id 2599',7750.00,0.00,0.00,12.50,400.00,'2022-04-01 16:32:03','',''),(2406,'1','223','1',1,'Retail Sale Id 2600',3701.40,0.00,0.00,5.97,191.04,'2022-04-01 16:34:11','',''),(2407,'1','223','1',1,'Retail Sale Id 2601',3503.00,0.00,0.00,5.65,180.80,'2022-04-01 16:35:05','',''),(2408,'1','223','1',1,'Retail Sale Id 2602',998.20,0.00,0.00,1.61,51.52,'2022-04-01 16:36:17','',''),(2409,'1','223','1',1,'Retail Sale Id 2603',1897.20,0.00,0.00,3.06,97.92,'2022-04-01 16:39:35','',''),(2410,'1','223','1',1,'Retail Sale Id 2604',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 16:40:16','',''),(2411,'1','223','1',1,'Retail Sale Id 2605',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 16:42:36','',''),(2412,'1','223','1',1,'Retail Sale Id 2606',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 16:43:26','',''),(2413,'1','223','1',1,'Retail Sale Id 2607',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 16:44:07','',''),(2414,'1','223','1',1,'Retail Sale Id 2608',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 16:49:19','',''),(2415,'1','223','1',1,'Retail Sale Id 2609',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 16:50:55','',''),(2416,'1','223','1',1,'Retail Sale Id 2610',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 16:52:07','',''),(2417,'1','223','1',1,'Retail Sale Id 2611',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 16:52:41','',''),(2418,'1','223','1',1,'Retail Sale Id 2612',2002.60,0.00,0.00,3.23,103.36,'2022-04-01 16:53:43','',''),(2419,'1','223','1',1,'Retail Sale Id 2613',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 16:57:41','',''),(2420,'1','223','1',1,'Retail Sale Id 2614',998.20,0.00,0.00,1.61,51.52,'2022-04-01 16:58:38','',''),(2421,'1','223','1',1,'Retail Sale Id 2615',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 16:59:56','',''),(2422,'1','223','1',1,'Retail Sale Id 2616',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 17:00:32','',''),(2423,'1','223','1',1,'Retail Sale Id 2617',1240.00,0.00,0.00,2.00,64.00,'2022-04-01 17:03:27','',''),(2424,'1','223','1',1,'Retail Sale Id 2618',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 17:04:52','',''),(2425,'1','223','1',1,'Retail Sale Id 2619',998.20,0.00,0.00,1.61,51.52,'2022-04-01 17:05:47','',''),(2426,'1','223','1',1,'Retail Sale Id 2620',2480.00,0.00,0.00,4.00,128.00,'2022-04-01 17:08:45','',''),(2427,'1','223','1',1,'Retail Sale Id 2621',502.20,0.00,0.00,0.81,25.92,'2022-04-01 17:13:06','',''),(2428,'1','223','1',1,'Retail Sale Id 2622',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 17:14:38','',''),(2429,'1','223','1',1,'Retail Sale Id 2623',3751.00,0.00,0.00,6.05,193.60,'2022-04-01 17:17:46','',''),(2430,'1','223','1',1,'Retail Sale Id 2624',1872.40,0.00,0.00,3.02,96.64,'2022-04-01 17:19:48','',''),(2431,'1','223','1',1,'Retail Sale Id 2625',2480.00,0.00,0.00,4.00,128.00,'2022-04-01 17:20:43','',''),(2432,'1','223','1',1,'Retail Sale Id 2626',7750.00,0.00,0.00,12.50,400.00,'2022-04-01 17:22:56','',''),(2433,'1','223','1',1,'Retail Sale Id 2627',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 17:24:39','',''),(2434,'1','223','1',1,'Retail Sale Id 2628',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 17:27:15','',''),(2435,'1','223','1',1,'Retail Sale Id 2629',34800.00,0.00,0.00,58.00,696.00,'2022-04-01 17:31:55','',''),(2436,'1','223','1',1,'Retail Sale Id 2630',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 17:34:41','',''),(2437,'1','223','1',1,'Retail Sale Id 2631',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 17:35:39','',''),(2438,'1','223','1',1,'Retail Sale Id 2632',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 17:36:26','',''),(2439,'1','223','1',1,'Retail Sale Id 2633',4960.00,0.00,0.00,8.00,256.00,'2022-04-01 17:39:01','',''),(2440,'1','223','1',1,'Retail Sale Id 2634',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 17:41:21','',''),(2441,'1','223','1',1,'Retail Sale Id 2635',2002.60,0.00,0.00,3.23,103.36,'2022-04-01 17:43:25','',''),(2442,'1','223','1',1,'Retail Sale Id 2636',2002.60,0.00,0.00,3.23,103.36,'2022-04-01 17:44:12','',''),(2443,'1','223','1',1,'Retail Sale Id 2637',2498.60,0.00,0.00,4.03,128.96,'2022-04-01 17:45:08','',''),(2444,'1','223','1',1,'Retail Sale Id 2638',7750.00,0.00,0.00,12.50,400.00,'2022-04-01 17:45:46','',''),(2445,'1','223','1',1,'Retail Sale Id 2639',2002.60,0.00,0.00,3.23,103.36,'2022-04-01 17:46:51','',''),(2446,'1','223','1',1,'Retail Sale Id 2640',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 17:48:20','',''),(2447,'1','223','1',1,'Retail Sale Id 2641',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 17:51:34','',''),(2448,'1','223','1',1,'Retail Sale Id 2642',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 17:52:36','',''),(2449,'1','223','1',1,'Retail Sale Id 2644',1252.40,0.00,0.00,2.02,64.64,'2022-04-01 17:57:54','',''),(2450,'1','223','1',1,'Retail Sale Id 2645',700.60,0.00,0.00,1.13,36.16,'2022-04-01 17:58:56','',''),(2451,'1','223','1',1,'Retail Sale Id 2646',7750.00,0.00,0.00,12.50,400.00,'2022-04-01 17:59:33','',''),(2452,'1','223','1',1,'Retail Sale Id 2647',1302.00,0.00,0.00,2.10,67.20,'2022-04-01 18:00:24','',''),(2453,'1','223','1',1,'Retail Sale Id 2648',1500.40,0.00,0.00,2.42,77.44,'2022-04-01 18:01:04','',''),(2454,'1','223','1',1,'Retail Sale Id 2649',998.20,0.00,0.00,1.61,51.52,'2022-04-01 18:01:46','',''),(2455,'1','223','1',1,'Retail Sale Id 2650',1847.60,0.00,0.00,2.98,95.36,'2022-04-01 18:04:10','',''),(2456,'1','223','1',1,'Retail Sale Id 2651',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 18:05:05','',''),(2457,'1','223','1',1,'Retail Sale Id 2652',1240.00,0.00,0.00,2.00,64.00,'2022-04-01 18:07:30','',''),(2458,'1','223','1',1,'Retail Sale Id 2653',1240.00,0.00,0.00,2.00,64.00,'2022-04-01 18:08:23','',''),(2459,'1','223','1',1,'Retail Sale Id 2654',1847.60,0.00,0.00,2.98,95.36,'2022-04-01 18:13:47','',''),(2460,'1','223','1',1,'Retail Sale Id 2655',1897.20,0.00,0.00,3.06,97.92,'2022-04-01 18:15:26','',''),(2461,'1','223','1',1,'Retail Sale Id 2656',6200.00,0.00,0.00,10.00,320.00,'2022-04-01 18:16:22','',''),(2462,'1','223','1',1,'Retail Sale Id 2657',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 18:17:22','',''),(2463,'1','223','1',1,'Retail Sale Id 2658',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 18:18:32','',''),(2464,'1','223','1',1,'Retail Sale Id 2659',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 18:20:00','',''),(2465,'1','223','1',1,'Retail Sale Id 2660',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 18:20:50','',''),(2466,'1','223','1',1,'Retail Sale Id 2661',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 18:22:03','',''),(2467,'1','223','1',1,'Retail Sale Id 2662',502.20,0.00,0.00,0.81,25.92,'2022-04-01 18:22:46','',''),(2468,'1','223','1',1,'Retail Sale Id 2663',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 18:23:23','',''),(2469,'1','223','1',1,'Retail Sale Id 2664',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 18:24:07','',''),(2470,'1','223','1',1,'Retail Sale Id 2665',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 18:25:23','',''),(2471,'1','223','1',1,'Retail Sale Id 2666',1897.20,0.00,0.00,3.06,97.92,'2022-04-01 18:29:01','',''),(2472,'1','223','1',1,'Retail Sale Id 2667',1897.20,0.00,0.00,3.06,97.92,'2022-04-01 18:30:45','',''),(2473,'1','223','1',1,'Retail Sale Id 2668',1500.40,0.00,0.00,2.42,77.44,'2022-04-01 18:38:49','',''),(2474,'1','223','1',1,'Retail Sale Id 2669',998.20,0.00,0.00,1.61,51.52,'2022-04-01 18:44:04','',''),(2475,'1','223','1',1,'Retail Sale Id 2670',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 18:45:41','',''),(2476,'1','223','1',1,'Retail Sale Id 2671',998.20,0.00,0.00,1.61,51.52,'2022-04-01 18:52:41','',''),(2477,'1','223','1',1,'Retail Sale Id 2672',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 18:53:51','',''),(2478,'1','223','1',1,'Retail Sale Id 2674',1872.40,0.00,0.00,3.02,96.64,'2022-04-01 18:56:22','',''),(2479,'1','223','1',1,'Retail Sale Id 2675',3100.00,0.00,0.00,5.00,160.00,'2022-04-01 18:57:29','',''),(2480,'1','223','1',1,'Retail Sale Id 2676',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 19:00:27','',''),(2481,'1','223','1',1,'Retail Sale Id 2677',1302.00,0.00,0.00,2.10,67.20,'2022-04-01 19:02:42','',''),(2482,'1','223','1',1,'Retail Sale Id 2678',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 19:11:34','',''),(2483,'1','223','1',1,'Retail Sale Id 2679',1240.00,0.00,0.00,2.00,64.00,'2022-04-01 19:12:36','',''),(2484,'1','223','1',1,'Retail Sale Id 2680',3720.00,0.00,0.00,6.00,192.00,'2022-04-01 19:16:35','',''),(2485,'1','223','1',1,'Retail Sale Id 2681',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 19:19:22','',''),(2486,'1','223','1',1,'Retail Sale Id 2682',1860.00,0.00,0.00,3.00,96.00,'2022-04-01 19:20:34','',''),(2487,'1','223','1',1,'Retail Sale Id 2686',1798.00,0.00,0.00,2.90,92.80,'2022-04-01 19:26:01','',''),(2488,'1','223','1',1,'Retail Sale Id 2687',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 07:07:44','',''),(2489,'1','223','1',1,'Retail Sale Id 2688',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 07:32:07','',''),(2490,'1','223','1',1,'Retail Sale Id 2689',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 07:33:12','',''),(2491,'1','223','1',1,'Retail Sale Id 2690',3999.00,0.00,0.00,6.45,206.40,'2022-04-02 07:40:23','',''),(2492,'1','223','1',1,'Retail Sale Id 2691',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 07:43:34','',''),(2493,'1','223','1',1,'Retail Sale Id 2692',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 07:45:48','',''),(2494,'1','223','1',1,'Retail Sale Id 2693',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 07:46:52','',''),(2495,'1','223','1',1,'Retail Sale Id 2694',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 07:52:20','',''),(2496,'1','223','1',1,'Retail Sale Id 2695',5580.00,0.00,0.00,9.00,288.00,'2022-04-02 07:54:13','',''),(2497,'1','223','1',1,'Retail Sale Id 2696',2901.60,0.00,0.00,4.68,149.76,'2022-04-02 07:56:46','',''),(2498,'1','223','1',1,'Retail Sale Id 2697',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 07:58:44','',''),(2499,'1','223','1',1,'Retail Sale Id 2698',24000.00,0.00,0.00,40.00,480.00,'2022-04-02 08:01:31','',''),(2500,'1','223','1',1,'Retail Sale Id 2700',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 08:03:26','',''),(2501,'1','223','1',1,'Retail Sale Id 2701',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 08:13:01','',''),(2502,'1','223','1',1,'Retail Sale Id 2702',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 08:18:46','',''),(2503,'1','223','1',1,'Retail Sale Id 2703',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 08:21:20','',''),(2504,'1','223','1',1,'Retail Sale Id 2704',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 08:30:11','',''),(2505,'1','223','1',1,'Retail Sale Id 2705',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 08:32:55','',''),(2506,'1','223','1',1,'Retail Sale Id 2706',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 08:33:38','',''),(2507,'1','223','1',1,'Retail Sale Id 2707',3751.00,0.00,0.00,6.05,193.60,'2022-04-02 08:34:57','',''),(2508,'1','223','1',1,'Retail Sale Id 2708',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 08:36:37','',''),(2509,'1','223','1',1,'Retail Sale Id 2709',2498.60,0.00,0.00,4.03,128.96,'2022-04-02 08:37:30','',''),(2510,'1','223','1',1,'Retail Sale Id 2710',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 08:38:46','',''),(2511,'1','223','1',1,'Retail Sale Id 2711',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 08:43:11','',''),(2512,'1','223','1',1,'Retail Sale Id 2712',3751.00,0.00,0.00,6.05,193.60,'2022-04-02 08:44:11','',''),(2513,'1','223','1',1,'Retail Sale Id 2713',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 08:45:21','',''),(2514,'1','223','1',1,'Retail Sale Id 2714',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 08:46:19','',''),(2515,'1','223','1',1,'Retail Sale Id 2715',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 08:47:13','',''),(2516,'1','223','1',1,'Retail Sale Id 2716',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 08:48:13','',''),(2517,'1','223','1',1,'Retail Sale Id 2717',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 08:50:38','',''),(2518,'1','223','1',1,'Retail Sale Id 2718',2498.60,0.00,0.00,4.03,128.96,'2022-04-02 08:51:33','',''),(2519,'1','223','1',1,'Retail Sale Id 2719',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 08:52:50','',''),(2520,'1','223','1',1,'Retail Sale Id 2720',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 08:53:20','',''),(2521,'1','223','1',1,'Retail Sale Id 2721',1202.80,0.00,0.00,1.94,62.08,'2022-04-02 08:59:09','',''),(2522,'1','223','1',1,'Retail Sale Id 2722',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 08:59:47','',''),(2523,'1','223','1',1,'Retail Sale Id 2723',2498.60,0.00,0.00,4.03,128.96,'2022-04-02 09:00:54','',''),(2524,'1','223','1',1,'Retail Sale Id 2724',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 09:05:12','',''),(2525,'1','223','1',1,'Retail Sale Id 2725',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 09:16:29','',''),(2526,'1','223','1',1,'Retail Sale Id 2728',24000.00,0.00,0.00,40.00,480.00,'2022-04-02 09:22:53','',''),(2527,'1','223','1',1,'Retail Sale Id 2730',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 09:23:32','',''),(2528,'1','223','1',1,'Retail Sale Id 2731',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 09:24:36','',''),(2529,'1','223','1',1,'Retail Sale Id 2732',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 09:27:23','',''),(2530,'1','223','1',1,'Retail Sale Id 2733',700.60,0.00,0.00,1.13,36.16,'2022-04-02 09:34:32','',''),(2531,'1','223','1',1,'Retail Sale Id 2734',1649.20,0.00,0.00,2.66,85.12,'2022-04-02 09:41:00','',''),(2532,'1','223','1',1,'Retail Sale Id 2735',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 09:41:59','',''),(2533,'1','223','1',1,'Retail Sale Id 2736',1798.00,0.00,0.00,2.90,92.80,'2022-04-02 09:43:24','',''),(2534,'1','223','1',1,'Retail Sale Id 2737',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 09:49:33','',''),(2535,'1','223','1',1,'Retail Sale Id 2738',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 09:52:36','',''),(2536,'1','223','1',1,'Retail Sale Id 2739',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 09:56:45','',''),(2537,'1','223','1',1,'Retail Sale Id 2740',998.20,0.00,0.00,1.61,51.52,'2022-04-02 09:58:22','',''),(2538,'1','223','1',1,'Retail Sale Id 2741',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 10:08:31','',''),(2539,'1','223','1',1,'Retail Sale Id 2743',1500.40,0.00,0.00,2.42,77.44,'2022-04-02 10:11:05','',''),(2540,'1','223','1',1,'Retail Sale Id 2744',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 10:21:11','',''),(2541,'1','223','1',1,'Retail Sale Id 2745',1302.00,0.00,0.00,2.10,67.20,'2022-04-02 10:22:28','',''),(2542,'1','223','1',1,'Retail Sale Id 2747',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 10:23:07','',''),(2543,'1','223','1',1,'Retail Sale Id 2748',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 10:24:54','',''),(2544,'1','223','1',1,'Retail Sale Id 2749',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 10:25:31','',''),(2545,'1','223','1',1,'Retail Sale Id 2750',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 10:26:04','',''),(2546,'1','223','1',1,'Retail Sale Id 2751',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 10:27:58','',''),(2547,'1','223','1',1,'Retail Sale Id 2752',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 10:31:37','',''),(2548,'1','223','1',1,'Retail Sale Id 2756',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 10:33:51','',''),(2549,'1','223','1',1,'Retail Sale Id 2757',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 10:38:31','',''),(2550,'1','223','1',1,'Retail Sale Id 2758',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 10:39:43','',''),(2551,'1','223','1',1,'Retail Sale Id 2759',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 10:44:12','',''),(2552,'1','223','1',1,'Retail Sale Id 2760',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 10:46:52','',''),(2553,'1','223','1',1,'Retail Sale Id 2761',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 10:47:21','',''),(2554,'1','223','1',1,'Retail Sale Id 2762',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 10:49:01','',''),(2555,'1','223','1',1,'Retail Sale Id 2763',3000.80,0.00,0.00,4.84,154.88,'2022-04-02 10:54:07','',''),(2556,'1','223','1',1,'Retail Sale Id 2764',7440.00,0.00,0.00,12.00,384.00,'2022-04-02 10:55:07','',''),(2557,'1','223','1',1,'Retail Sale Id 2765',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 10:58:29','',''),(2558,'1','223','1',1,'Retail Sale Id 2766',1500.40,0.00,0.00,2.42,77.44,'2022-04-02 10:59:43','',''),(2559,'1','223','1',1,'Retail Sale Id 2767',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 11:02:08','',''),(2560,'1','223','1',1,'Retail Sale Id 2768',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 11:08:22','',''),(2561,'1','223','1',1,'Retail Sale Id 2769',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 11:10:05','',''),(2562,'1','223','1',1,'Retail Sale Id 2770',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 11:14:08','',''),(2563,'1','223','1',1,'Retail Sale Id 2771',36000.00,0.00,0.00,60.00,720.00,'2022-04-02 11:26:41','',''),(2564,'1','223','1',1,'Retail Sale Id 2773',2498.60,0.00,0.00,4.03,128.96,'2022-04-02 11:27:52','',''),(2565,'1','223','1',1,'Retail Sale Id 2774',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 11:29:06','',''),(2566,'1','223','1',1,'Retail Sale Id 2775',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 11:30:20','',''),(2567,'1','223','1',1,'Retail Sale Id 2776',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 11:31:35','',''),(2568,'1','223','1',1,'Retail Sale Id 2777',1500.40,0.00,0.00,2.42,77.44,'2022-04-02 11:33:38','',''),(2569,'1','223','1',1,'Return of Retail Sale Id 2775',0.00,1897.20,3.06,0.00,-97.92,'2022-04-02 11:34:30','',''),(2570,'1','223','1',1,'Retail Sale Id 2778',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 11:35:37','',''),(2571,'1','223','1',1,'Retail Sale Id 2779',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 11:48:48','',''),(2572,'1','223','1',1,'Retail Sale Id 2780',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 12:00:29','',''),(2573,'1','223','1',1,'Retail Sale Id 2781',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 12:02:06','',''),(2574,'1','223','1',1,'Retail Sale Id 2782',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 12:02:43','',''),(2575,'1','223','1',1,'Return of Retail Sale Id 2780',0.00,1860.00,3.00,0.00,-96.00,'2022-04-02 12:04:46','',''),(2576,'1','223','1',1,'Retail Sale Id 2783',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 12:06:34','',''),(2577,'1','223','1',1,'Retail Sale Id 2784',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 12:07:30','',''),(2578,'1','223','1',1,'Retail Sale Id 2785',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 12:18:28','',''),(2579,'1','223','1',1,'Retail Sale Id 2786',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 12:22:26','',''),(2580,'1','223','1',1,'Retail Sale Id 2787',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 12:23:11','',''),(2581,'1','223','1',1,'Retail Sale Id 2788',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 12:27:29','',''),(2582,'1','223','1',1,'Retail Sale Id 2789',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 12:37:54','',''),(2583,'1','223','1',1,'Retail Sale Id 2790',3999.00,0.00,0.00,6.45,206.40,'2022-04-02 12:39:14','',''),(2584,'1','223','1',1,'Retail Sale Id 2791',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 12:41:13','',''),(2585,'1','223','1',1,'Retail Sale Id 2792',3000.80,0.00,0.00,4.84,154.88,'2022-04-02 12:44:07','',''),(2586,'1','223','1',1,'Retail Sale Id 2793',3000.80,0.00,0.00,4.84,154.88,'2022-04-02 12:44:51','',''),(2587,'1','223','1',1,'Retail Sale Id 2794',3732.40,0.00,0.00,6.02,192.64,'2022-04-02 12:57:19','',''),(2588,'1','223','1',1,'Retail Sale Id 2795',1847.60,0.00,0.00,2.98,95.36,'2022-04-02 12:58:30','',''),(2589,'1','223','1',1,'Retail Sale Id 2796',1847.60,0.00,0.00,2.98,95.36,'2022-04-02 12:59:22','',''),(2590,'1','223','1',1,'Retail Sale Id 2797',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 13:06:45','',''),(2591,'1','223','1',1,'Retail Sale Id 2798',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 13:14:12','',''),(2592,'1','223','1',1,'Retail Sale Id 2799',2498.60,0.00,0.00,4.03,128.96,'2022-04-02 13:22:14','',''),(2593,'1','223','1',1,'Retail Sale Id 2801',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 13:23:22','',''),(2594,'1','223','1',1,'Retail Sale Id 2802',37500.00,0.00,0.00,62.50,750.00,'2022-04-02 13:25:06','',''),(2595,'1','223','1',1,'Retail Sale Id 2803',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 13:27:41','',''),(2596,'1','223','1',1,'Retail Sale Id 2804',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 13:28:54','',''),(2597,'1','223','1',1,'Retail Sale Id 2805',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 13:32:50','',''),(2598,'1','223','1',1,'Retail Sale Id 2806',2480.00,0.00,0.00,4.00,128.00,'2022-04-02 13:39:40','',''),(2599,'1','223','1',1,'Return of Retail Sale Id 2802',0.00,37500.00,62.50,0.00,-750.00,'2022-04-02 13:42:34','',''),(2600,'1','223','1',1,'Retail Sale Id 2807',37500.00,0.00,0.00,62.50,750.00,'2022-04-02 13:45:19','',''),(2601,'1','223','1',1,'Retail Sale Id 2808',1800.00,0.00,0.00,3.00,36.00,'2022-04-02 13:46:41','',''),(2602,'1','223','1',1,'Retail Sale Id 2809',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 13:59:35','',''),(2603,'1','223','1',1,'Retail Sale Id 2810',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 14:01:13','',''),(2604,'1','223','1',1,'Retail Sale Id 2811',1500.40,0.00,0.00,2.42,77.44,'2022-04-02 14:07:04','',''),(2605,'1','223','1',1,'Return of Retail Sale Id 2811',0.00,1500.40,2.42,0.00,-77.44,'2022-04-02 14:07:52','',''),(2606,'1','223','1',1,'Retail Sale Id 2812',1698.80,0.00,0.00,2.74,87.68,'2022-04-02 14:08:18','',''),(2607,'1','223','1',1,'Retail Sale Id 2813',1202.80,0.00,0.00,1.94,62.08,'2022-04-02 14:12:10','',''),(2608,'1','223','1',1,'Retail Sale Id 2814',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 14:13:38','',''),(2609,'1','223','1',1,'Retail Sale Id 2815',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 14:18:53','',''),(2610,'1','223','1',1,'Retail Sale Id 2816',2498.60,0.00,0.00,4.03,128.96,'2022-04-02 14:21:16','',''),(2611,'1','223','1',1,'Retail Sale Id 2817',1798.00,0.00,0.00,2.90,92.80,'2022-04-02 14:24:13','',''),(2612,'1','223','1',1,'Retail Sale Id 2818',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 14:31:38','',''),(2613,'1','223','1',1,'Retail Sale Id 2819',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 14:32:47','',''),(2614,'1','223','1',1,'Retail Sale Id 2820',2480.00,0.00,0.00,4.00,128.00,'2022-04-02 14:45:10','',''),(2615,'1','223','1',1,'Retail Sale Id 2821',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 14:46:20','',''),(2616,'1','223','1',1,'Retail Sale Id 2822',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 14:53:12','',''),(2617,'1','223','1',1,'Retail Sale Id 2823',1847.60,0.00,0.00,2.98,95.36,'2022-04-02 14:54:46','',''),(2618,'1','223','1',1,'Retail Sale Id 2824',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 14:56:15','',''),(2619,'1','223','1',1,'Retail Sale Id 2825',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 14:57:18','',''),(2620,'1','223','1',1,'Retail Sale Id 2826',3850.20,0.00,0.00,6.21,198.72,'2022-04-02 15:02:55','',''),(2621,'1','223','1',1,'Retail Sale Id 2827',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 15:04:54','',''),(2622,'1','223','1',1,'Retail Sale Id 2828',3503.00,0.00,0.00,5.65,180.80,'2022-04-02 15:07:08','',''),(2623,'1','223','1',1,'Retail Sale Id 2829',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 15:10:24','',''),(2624,'1','223','1',1,'Retail Sale Id 2830',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 15:12:31','',''),(2625,'1','223','1',1,'Retail Sale Id 2831',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 15:14:25','',''),(2626,'1','223','1',1,'Retail Sale Id 2832',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 15:15:09','',''),(2627,'1','223','1',1,'Retail Sale Id 2833',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 15:26:53','',''),(2628,'1','223','1',1,'Retail Sale Id 2834',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 15:28:22','',''),(2629,'1','223','1',1,'Retail Sale Id 2835',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 15:29:37','',''),(2630,'1','223','1',1,'Retail Sale Id 2836',4997.20,0.00,0.00,8.06,257.92,'2022-04-02 15:30:52','',''),(2631,'1','223','1',1,'Retail Sale Id 2837',2498.60,0.00,0.00,4.03,128.96,'2022-04-02 15:36:44','',''),(2632,'1','223','1',1,'Retail Sale Id 2838',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 15:39:08','',''),(2633,'1','223','1',1,'Retail Sale Id 2839',4960.00,0.00,0.00,8.00,256.00,'2022-04-02 15:42:24','',''),(2634,'1','223','1',1,'Retail Sale Id 2840',1500.40,0.00,0.00,2.42,77.44,'2022-04-02 15:46:56','',''),(2635,'1','223','1',1,'Retail Sale Id 2841',1202.80,0.00,0.00,1.94,62.08,'2022-04-02 15:47:41','',''),(2636,'1','223','1',1,'Retail Sale Id 2842',1500.40,0.00,0.00,2.42,77.44,'2022-04-02 15:51:03','',''),(2637,'1','223','1',1,'Retail Sale Id 2843',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 15:52:24','',''),(2638,'1','223','1',1,'Retail Sale Id 2844',2498.60,0.00,0.00,4.03,128.96,'2022-04-02 15:54:16','',''),(2639,'1','223','1',1,'Retail Sale Id 2845',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 15:55:27','',''),(2640,'1','223','1',1,'Retail Sale Id 2846',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 16:03:13','',''),(2641,'1','223','1',1,'Retail Sale Id 2847',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 16:05:11','',''),(2642,'1','223','1',1,'Retail Sale Id 2848',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 16:06:26','',''),(2643,'1','223','1',1,'Retail Sale Id 2849',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 16:12:15','',''),(2644,'1','223','1',1,'Retail Sale Id 2850',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 16:13:30','',''),(2645,'1','223','1',1,'Retail Sale Id 2851',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 16:15:04','',''),(2646,'1','223','1',1,'Retail Sale Id 2852',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 16:16:01','',''),(2647,'1','223','1',1,'Retail Sale Id 2853',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 16:17:39','',''),(2648,'1','223','1',1,'Retail Sale Id 2854',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 16:20:00','',''),(2649,'1','223','1',1,'Retail Sale Id 2856',2498.60,0.00,0.00,4.03,128.96,'2022-04-02 16:22:30','',''),(2650,'1','223','1',1,'Retail Sale Id 2857',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 16:26:26','',''),(2651,'1','223','1',1,'Retail Sale Id 2858',3503.00,0.00,0.00,5.65,180.80,'2022-04-02 16:27:39','',''),(2652,'1','223','1',1,'Retail Sale Id 2859',1202.80,0.00,0.00,1.94,62.08,'2022-04-02 16:28:47','',''),(2653,'1','223','1',1,'Retail Sale Id 2860',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 16:29:45','',''),(2654,'1','223','1',1,'Retail Sale Id 2861',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 16:31:02','',''),(2655,'1','223','1',1,'Retail Sale Id 2862',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 16:33:40','',''),(2656,'1','223','1',1,'Retail Sale Id 2863',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 16:36:27','',''),(2657,'1','223','1',1,'Retail Sale Id 2864',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 16:38:34','',''),(2658,'1','223','1',1,'Retail Sale Id 2865',7750.00,0.00,0.00,12.50,400.00,'2022-04-02 16:39:43','',''),(2659,'1','223','1',1,'Retail Sale Id 2866',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 16:40:54','',''),(2660,'1','223','1',1,'Retail Sale Id 2867',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 16:42:39','',''),(2661,'1','223','1',1,'Retail Sale Id 2868',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 16:50:11','',''),(2662,'1','223','1',1,'Retail Sale Id 2869',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 16:57:32','',''),(2663,'1','223','1',1,'Retail Sale Id 2870',1847.60,0.00,0.00,2.98,95.36,'2022-04-02 17:04:21','',''),(2664,'1','223','1',1,'Retail Sale Id 2871',3199.20,0.00,0.00,5.16,165.12,'2022-04-02 17:05:19','',''),(2665,'1','223','1',1,'Retail Sale Id 2872',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 17:07:07','',''),(2666,'1','223','1',1,'Retail Sale Id 2873',1847.60,0.00,0.00,2.98,95.36,'2022-04-02 17:09:00','',''),(2667,'1','223','1',1,'Retail Sale Id 2874',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 17:11:23','',''),(2668,'1','223','1',1,'Retail Sale Id 2875',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 17:12:41','',''),(2669,'1','223','1',1,'Retail Sale Id 2876',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 17:13:21','',''),(2670,'1','223','1',1,'Retail Sale Id 2878',1847.60,0.00,0.00,2.98,95.36,'2022-04-02 17:15:26','',''),(2671,'1','223','1',1,'Retail Sale Id 2879',1847.60,0.00,0.00,2.98,95.36,'2022-04-02 17:16:31','',''),(2672,'1','223','1',1,'Retail Sale Id 2880',1847.60,0.00,0.00,2.98,95.36,'2022-04-02 17:17:27','',''),(2673,'1','223','1',1,'Retail Sale Id 2881',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 17:18:25','',''),(2674,'1','223','1',1,'Retail Sale Id 2882',998.20,0.00,0.00,1.61,51.52,'2022-04-02 17:19:39','',''),(2675,'1','223','1',1,'Retail Sale Id 2883',1240.00,0.00,0.00,2.00,64.00,'2022-04-02 17:20:54','',''),(2676,'1','223','1',1,'Retail Sale Id 2885',1698.80,0.00,0.00,2.74,87.68,'2022-04-02 17:22:26','',''),(2677,'1','223','1',1,'Retail Sale Id 2886',5580.00,0.00,0.00,9.00,288.00,'2022-04-02 17:23:40','',''),(2678,'1','223','1',1,'Retail Sale Id 2887',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 17:25:42','',''),(2679,'1','223','1',1,'Retail Sale Id 2888',1872.40,0.00,0.00,3.02,96.64,'2022-04-02 17:28:01','',''),(2680,'1','223','1',1,'Retail Sale Id 2889',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 17:30:40','',''),(2681,'1','223','1',1,'Retail Sale Id 2890',3751.00,0.00,0.00,6.05,193.60,'2022-04-02 17:32:34','',''),(2682,'1','223','1',1,'Retail Sale Id 2891',1500.40,0.00,0.00,2.42,77.44,'2022-04-02 17:34:27','',''),(2683,'1','223','1',1,'Retail Sale Id 2892',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 17:35:15','',''),(2684,'1','223','1',1,'Retail Sale Id 2893',651.00,0.00,0.00,1.05,33.60,'2022-04-02 17:36:24','',''),(2685,'1','223','1',1,'Retail Sale Id 2894',1500.40,0.00,0.00,2.42,77.44,'2022-04-02 17:39:24','',''),(2686,'1','223','1',1,'Retail Sale Id 2895',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 17:41:47','',''),(2687,'1','223','1',1,'Retail Sale Id 2896',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 17:45:57','',''),(2688,'1','223','1',1,'Retail Sale Id 2897',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 17:47:06','',''),(2689,'1','223','1',1,'Retail Sale Id 2898',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 17:59:57','',''),(2690,'1','223','1',1,'Retail Sale Id 2899',1847.60,0.00,0.00,2.98,95.36,'2022-04-02 18:01:00','',''),(2691,'1','223','1',1,'Retail Sale Id 2900',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 18:04:39','',''),(2692,'1','223','1',1,'Retail Sale Id 2901',1252.40,0.00,0.00,2.02,64.64,'2022-04-02 18:06:35','',''),(2693,'1','223','1',1,'Retail Sale Id 2902',1798.00,0.00,0.00,2.90,92.80,'2022-04-02 18:07:44','',''),(2694,'1','223','1',1,'Retail Sale Id 2903',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 18:11:02','',''),(2695,'1','223','1',1,'Retail Sale Id 2904',3100.00,0.00,0.00,5.00,160.00,'2022-04-02 18:15:39','',''),(2696,'1','223','1',1,'Retail Sale Id 2905',998.20,0.00,0.00,1.61,51.52,'2022-04-02 18:20:01','',''),(2697,'1','223','1',1,'Retail Sale Id 2906',620.00,0.00,0.00,1.00,32.00,'2022-04-02 18:21:52','',''),(2698,'1','223','1',1,'Retail Sale Id 2907',1847.60,0.00,0.00,2.98,95.36,'2022-04-02 18:26:45','',''),(2699,'1','223','1',1,'Retail Sale Id 2908',2498.60,0.00,0.00,4.03,128.96,'2022-04-02 18:27:48','',''),(2700,'1','223','1',1,'Retail Sale Id 2909',3602.20,0.00,0.00,5.81,185.92,'2022-04-02 18:30:12','',''),(2701,'1','223','1',1,'Retail Sale Id 2910',1860.00,0.00,0.00,3.00,96.00,'2022-04-02 18:32:54','',''),(2702,'1','223','1',1,'Retail Sale Id 2911',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 18:35:17','',''),(2703,'1','223','1',1,'Retail Sale Id 2912',3720.00,0.00,0.00,6.00,192.00,'2022-04-02 18:40:21','',''),(2704,'1','223','1',1,'Retail Sale Id 2913',24000.00,0.00,0.00,40.00,480.00,'2022-04-02 18:43:50','',''),(2705,'1','223','1',1,'Retail Sale Id 2914',7440.00,0.00,0.00,12.00,384.00,'2022-04-02 18:45:46','',''),(2706,'1','223','1',1,'Retail Sale Id 2915',1897.20,0.00,0.00,3.06,97.92,'2022-04-02 18:50:28','',''),(2707,'1','223','1',1,'Retail Sale Id 2916',2002.60,0.00,0.00,3.23,103.36,'2022-04-02 19:08:45','',''),(2708,'1','223','1',1,'Retail Sale Id 2918',632.40,0.00,0.00,1.02,32.64,'2022-04-02 19:12:27','',''),(2709,'1','223','1',1,'Retail Sale Id 2919',737.80,0.00,0.00,1.19,38.08,'2022-04-02 20:35:12','',''),(2710,'1','223','1',1,'Retail Sale Id 2920',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 07:20:52','',''),(2711,'1','223','1',1,'Retail Sale Id 2921',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 07:23:09','',''),(2712,'1','223','1',1,'Retail Sale Id 2922',1252.40,0.00,0.00,2.02,64.64,'2022-04-03 07:24:49','',''),(2713,'1','223','1',1,'Retail Sale Id 2923',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 07:25:48','',''),(2714,'1','223','1',1,'Retail Sale Id 2924',620.00,0.00,0.00,1.00,32.00,'2022-04-03 07:34:06','',''),(2715,'1','223','1',1,'Retail Sale Id 2925',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 07:38:20','',''),(2716,'1','223','1',1,'Retail Sale Id 2926',998.20,0.00,0.00,1.61,51.52,'2022-04-03 07:59:12','',''),(2717,'1','223','1',1,'Retail Sale Id 2927',3751.00,0.00,0.00,6.05,193.60,'2022-04-03 08:00:53','',''),(2718,'1','223','1',1,'Retail Sale Id 2928',3720.00,0.00,0.00,6.00,192.00,'2022-04-03 08:02:30','',''),(2719,'1','223','1',1,'Retail Sale Id 2929',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 08:07:22','',''),(2720,'1','223','1',1,'Retail Sale Id 2932',3503.00,0.00,0.00,5.65,180.80,'2022-04-03 08:18:09','',''),(2721,'1','223','1',1,'Retail Sale Id 2933',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 08:34:37','',''),(2722,'1','223','1',1,'Retail Sale Id 2934',1847.60,0.00,0.00,2.98,95.36,'2022-04-03 08:38:37','',''),(2723,'1','223','1',1,'Retail Sale Id 2935',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 08:41:11','',''),(2724,'1','223','1',1,'Retail Sale Id 2936',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 08:44:54','',''),(2725,'1','223','1',1,'Retail Sale Id 2937',3720.00,0.00,0.00,6.00,192.00,'2022-04-03 09:03:13','',''),(2726,'1','223','1',1,'Retail Sale Id 2938',4340.00,0.00,0.00,7.00,224.00,'2022-04-03 09:05:37','',''),(2727,'1','223','1',1,'Retail Sale Id 2939',651.00,0.00,0.00,1.05,33.60,'2022-04-03 09:11:34','',''),(2728,'1','223','1',1,'Retail Sale Id 2940',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 09:14:11','',''),(2729,'1','223','1',1,'Retail Sale Id 2941',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 09:14:50','',''),(2730,'1','223','1',1,'Retail Sale Id 2942',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 09:16:10','',''),(2731,'1','223','1',1,'Retail Sale Id 2943',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 09:17:28','',''),(2732,'1','223','1',1,'Retail Sale Id 2944',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 09:18:27','',''),(2733,'1','223','1',1,'Retail Sale Id 2945',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 09:22:05','',''),(2734,'1','223','1',1,'Retail Sale Id 2946',3720.00,0.00,0.00,6.00,192.00,'2022-04-03 09:23:55','',''),(2735,'1','223','1',1,'Retail Sale Id 2947',3751.00,0.00,0.00,6.05,193.60,'2022-04-03 09:36:16','',''),(2736,'1','223','1',1,'Retail Sale Id 2948',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 09:40:57','',''),(2737,'1','223','1',1,'Retail Sale Id 2949',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 09:45:02','',''),(2738,'1','223','1',1,'Retail Sale Id 2950',4997.20,0.00,0.00,8.06,257.92,'2022-04-03 09:48:21','',''),(2739,'1','223','1',1,'Retail Sale Id 2952',2002.60,0.00,0.00,3.23,103.36,'2022-04-03 09:59:56','',''),(2740,'1','223','1',1,'Retail Sale Id 2953',4997.20,0.00,0.00,8.06,257.92,'2022-04-03 10:11:05','',''),(2741,'1','223','1',1,'Retail Sale Id 2954',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 10:13:36','',''),(2742,'1','223','1',1,'Retail Sale Id 2955',3720.00,0.00,0.00,6.00,192.00,'2022-04-03 10:14:39','',''),(2743,'1','223','1',1,'Retail Sale Id 2956',1500.40,0.00,0.00,2.42,77.44,'2022-04-03 10:23:58','',''),(2744,'1','223','1',1,'Retail Sale Id 2957',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 10:45:22','',''),(2745,'1','223','1',1,'Retail Sale Id 2958',2498.60,0.00,0.00,4.03,128.96,'2022-04-03 10:49:50','',''),(2746,'1','223','1',1,'Retail Sale Id 2959',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 11:28:23','',''),(2747,'1','223','1',1,'Retail Sale Id 2960',2498.60,0.00,0.00,4.03,128.96,'2022-04-03 11:34:20','',''),(2748,'1','223','1',1,'Retail Sale Id 2961',620.00,0.00,0.00,1.00,32.00,'2022-04-03 11:35:54','',''),(2749,'1','223','1',1,'Retail Sale Id 2962',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 11:37:14','',''),(2750,'1','223','1',1,'Retail Sale Id 2963',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 11:37:42','',''),(2751,'1','223','1',1,'Retail Sale Id 2964',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 11:39:37','',''),(2752,'1','223','1',1,'Retail Sale Id 2965',3000.80,0.00,0.00,4.84,154.88,'2022-04-03 11:41:54','',''),(2753,'1','223','1',1,'Retail Sale Id 2966',3751.00,0.00,0.00,6.05,193.60,'2022-04-03 11:50:02','',''),(2754,'1','223','1',1,'Retail Sale Id 2967',1302.00,0.00,0.00,2.10,67.20,'2022-04-03 11:51:15','',''),(2755,'1','223','1',1,'Retail Sale Id 2970',1202.80,0.00,0.00,1.94,62.08,'2022-04-03 12:13:35','',''),(2756,'1','223','1',1,'Retail Sale Id 2971',2498.60,0.00,0.00,4.03,128.96,'2022-04-03 12:17:42','',''),(2757,'1','223','1',1,'Retail Sale Id 2972',3800.60,0.00,0.00,6.13,196.16,'2022-04-03 12:34:34','',''),(2758,'1','223','1',1,'Retail Sale Id 2973',1500.40,0.00,0.00,2.42,77.44,'2022-04-03 12:43:46','',''),(2759,'1','223','1',1,'Retail Sale Id 2974',1698.80,0.00,0.00,2.74,87.68,'2022-04-03 12:51:22','',''),(2760,'1','223','1',1,'Retail Sale Id 2975',2498.60,0.00,0.00,4.03,128.96,'2022-04-03 12:59:09','',''),(2761,'1','223','1',1,'Retail Sale Id 2976',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 13:04:41','',''),(2762,'1','223','1',1,'Retail Sale Id 2977',1847.60,0.00,0.00,2.98,95.36,'2022-04-03 13:10:40','',''),(2763,'1','223','1',1,'Retail Sale Id 2980',2002.60,0.00,0.00,3.23,103.36,'2022-04-03 13:16:45','',''),(2764,'1','223','1',1,'Retail Sale Id 2981',1252.40,0.00,0.00,2.02,64.64,'2022-04-03 13:17:51','',''),(2765,'1','223','1',1,'Retail Sale Id 2982',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 13:21:02','',''),(2766,'1','223','1',1,'Retail Sale Id 2983',2498.60,0.00,0.00,4.03,128.96,'2022-04-03 13:23:07','',''),(2767,'1','223','1',1,'Retail Sale Id 2984',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 13:30:58','',''),(2768,'1','223','1',1,'Retail Sale Id 2985',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 13:32:42','',''),(2769,'1','223','1',1,'Retail Sale Id 2986',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 13:34:09','',''),(2770,'1','223','1',1,'Retail Sale Id 2987',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 13:37:53','',''),(2771,'1','223','1',1,'Retail Sale Id 2988',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 13:48:44','',''),(2772,'1','223','1',1,'Retail Sale Id 2989',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 13:55:28','',''),(2773,'1','223','1',1,'Retail Sale Id 2990',2492.40,0.00,0.00,4.02,128.64,'2022-04-03 13:56:16','',''),(2774,'1','223','1',1,'Retail Sale Id 2991',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 13:56:59','',''),(2775,'1','223','1',1,'Retail Sale Id 2992',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 13:57:36','',''),(2776,'1','223','1',1,'Retail Sale Id 2993',3720.00,0.00,0.00,6.00,192.00,'2022-04-03 14:01:39','',''),(2777,'1','223','1',1,'Retail Sale Id 2994',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 14:07:32','',''),(2778,'1','223','1',1,'Retail Sale Id 2995',799.80,0.00,0.00,1.29,41.28,'2022-04-03 14:08:11','',''),(2779,'1','223','1',1,'Retail Sale Id 2996',3720.00,0.00,0.00,6.00,192.00,'2022-04-03 14:08:51','',''),(2780,'1','223','1',1,'Retail Sale Id 2997',1252.40,0.00,0.00,2.02,64.64,'2022-04-03 14:28:00','',''),(2781,'1','223','1',1,'Retail Sale Id 2998',7750.00,0.00,0.00,12.50,400.00,'2022-04-03 14:28:45','',''),(2782,'1','223','1',1,'Retail Sale Id 2999',1302.00,0.00,0.00,2.10,67.20,'2022-04-03 14:37:11','',''),(2783,'1','223','1',1,'Retail Sale Id 3000',2002.60,0.00,0.00,3.23,103.36,'2022-04-03 14:39:39','',''),(2784,'1','223','1',1,'Retail Sale Id 3001',3751.00,0.00,0.00,6.05,193.60,'2022-04-03 15:02:32','',''),(2785,'1','223','1',1,'Retail Sale Id 3002',2802.40,0.00,0.00,4.52,144.64,'2022-04-03 15:08:41','',''),(2786,'1','223','1',1,'Retail Sale Id 3003',1872.40,0.00,0.00,3.02,96.64,'2022-04-03 15:10:14','',''),(2787,'1','223','1',1,'Retail Sale Id 3004',1202.80,0.00,0.00,1.94,62.08,'2022-04-03 15:13:41','',''),(2788,'1','223','1',1,'Retail Sale Id 3006',3757.20,0.00,0.00,6.06,193.92,'2022-04-03 15:20:33','',''),(2789,'1','223','1',1,'Retail Sale Id 3007',3720.00,0.00,0.00,6.00,192.00,'2022-04-03 15:23:57','',''),(2790,'1','223','1',1,'Retail Sale Id 3009',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 15:30:33','',''),(2791,'1','223','1',1,'Retail Sale Id 3010',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 15:31:27','',''),(2792,'1','223','1',1,'Retail Sale Id 3011',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 15:39:59','',''),(2793,'1','223','1',1,'Retail Sale Id 3012',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 15:47:15','',''),(2794,'1','223','1',1,'Retail Sale Id 3014',700.60,0.00,0.00,1.13,36.16,'2022-04-03 15:53:53','',''),(2795,'1','223','1',1,'Retail Sale Id 3015',0.00,0.00,0.00,3.00,-1764.00,'2022-04-03 16:06:08','',''),(2796,'1','223','1',1,'Retail Sale Id 3016',0.00,0.00,0.00,3.00,-1764.00,'2022-04-03 16:09:47','',''),(2797,'1','223','1',1,'Return of Retail Sale Id 3015',0.00,0.00,3.00,0.00,1764.00,'2022-04-03 16:13:48','',''),(2798,'1','223','1',1,'Return of Retail Sale Id 3016',0.00,0.00,3.00,0.00,1764.00,'2022-04-03 16:14:54','',''),(2799,'1','223','1',1,'Retail Sale Id 3017',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 16:15:45','',''),(2800,'1','223','1',1,'Retail Sale Id 3018',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 16:17:15','',''),(2801,'1','223','1',1,'Retail Sale Id 3019',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 16:19:38','',''),(2802,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,111720.00,190.00,0.00,0.00,'2022-04-03 16:21:59','',''),(2803,'1','223',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,190.00,0.00,'2022-04-03 16:24:07','',''),(2804,'1','223','1',1,'Received from bridging 3',0.00,0.00,190.00,0.00,0.00,'2022-04-03 16:24:07','',''),(2805,'1','223','1',1,'Retail Sale Id 3020',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 16:26:22','',''),(2806,'1','223','1',1,'Retail Sale Id 3021',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 16:34:42','',''),(2807,'1','223','1',1,'Retail Sale Id 3022',1202.80,0.00,0.00,1.94,62.08,'2022-04-03 16:38:35','',''),(2808,'1','223','1',1,'Retail Sale Id 3023',3701.40,0.00,0.00,5.97,191.04,'2022-04-03 16:40:13','',''),(2809,'1','223','1',1,'Retail Sale Id 3024',2480.00,0.00,0.00,4.00,128.00,'2022-04-03 16:43:58','',''),(2810,'1','223','1',1,'Retail Sale Id 3026',1202.80,0.00,0.00,1.94,62.08,'2022-04-03 16:49:13','',''),(2811,'1','223','1',1,'Retail Sale Id 3027',3000.80,0.00,0.00,4.84,154.88,'2022-04-03 16:53:18','',''),(2812,'1','223','1',1,'Retail Sale Id 3028',36000.00,0.00,0.00,60.00,720.00,'2022-04-03 17:01:18','',''),(2813,'1','223','1',1,'Retail Sale Id 3029',3720.00,0.00,0.00,6.00,192.00,'2022-04-03 17:05:03','',''),(2814,'1','223','1',1,'Retail Sale Id 3031',998.20,0.00,0.00,1.61,51.52,'2022-04-03 17:06:03','',''),(2815,'1','223','1',1,'Retail Sale Id 3032',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 17:06:56','',''),(2816,'1','223','1',1,'Retail Sale Id 3034',1252.40,0.00,0.00,2.02,64.64,'2022-04-03 17:08:56','',''),(2817,'1','223','1',1,'Retail Sale Id 3035',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 17:09:55','',''),(2818,'1','223','1',1,'Retail Sale Id 3036',7750.00,0.00,0.00,12.50,400.00,'2022-04-03 17:11:35','',''),(2819,'1','223','1',1,'Retail Sale Id 3037',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 17:12:18','',''),(2820,'1','223','1',1,'Retail Sale Id 3038',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 17:13:33','',''),(2821,'1','223','1',1,'Retail Sale Id 3039',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 17:14:06','',''),(2822,'1','223','1',1,'Retail Sale Id 3041',6200.00,0.00,0.00,10.00,320.00,'2022-04-03 17:15:01','',''),(2823,'1','223','1',1,'Retail Sale Id 3042',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 17:16:11','',''),(2824,'1','223','1',1,'Retail Sale Id 3043',651.00,0.00,0.00,1.05,33.60,'2022-04-03 17:17:37','',''),(2825,'1','223','1',1,'Retail Sale Id 3044',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 17:21:17','',''),(2826,'1','223','1',1,'Retail Sale Id 3045',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 17:22:27','',''),(2827,'1','223','1',1,'Retail Sale Id 3046',3000.80,0.00,0.00,4.84,154.88,'2022-04-03 17:23:40','',''),(2828,'1','223','1',1,'Retail Sale Id 3047',1500.40,0.00,0.00,2.42,77.44,'2022-04-03 17:25:53','',''),(2829,'1','223','1',1,'Retail Sale Id 3048',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 17:32:58','',''),(2830,'1','223','1',1,'Retail Sale Id 3049',502.20,0.00,0.00,0.81,25.92,'2022-04-03 17:33:56','',''),(2831,'1','223','1',1,'Retail Sale Id 3050',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 17:34:47','',''),(2832,'1','223','1',1,'Retail Sale Id 3051',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 17:36:51','',''),(2833,'1','223','1',1,'Retail Sale Id 3052',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 17:47:46','',''),(2834,'1','223','1',1,'Retail Sale Id 3053',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 17:48:47','',''),(2835,'1','223','1',1,'Retail Sale Id 3054',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 17:50:51','',''),(2836,'1','223','1',1,'Retail Sale Id 3055',3732.40,0.00,0.00,6.02,192.64,'2022-04-03 17:56:14','',''),(2837,'1','223','1',1,'Retail Sale Id 3056',3720.00,0.00,0.00,6.00,192.00,'2022-04-03 18:02:24','',''),(2838,'1','223','1',1,'Retail Sale Id 3057',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 18:03:35','',''),(2839,'1','223','1',1,'Retail Sale Id 3059',5598.60,0.00,0.00,9.03,288.96,'2022-04-03 18:06:29','',''),(2840,'1','223','1',1,'Retail Sale Id 3060',1240.00,0.00,0.00,2.00,64.00,'2022-04-03 18:07:12','',''),(2841,'1','223','1',1,'Retail Sale Id 3061',998.20,0.00,0.00,1.61,51.52,'2022-04-03 18:08:32','',''),(2842,'1','223','1',1,'Retail Sale Id 3062',998.20,0.00,0.00,1.61,51.52,'2022-04-03 18:10:03','',''),(2843,'1','223','1',1,'Retail Sale Id 3063',3100.00,0.00,0.00,5.00,160.00,'2022-04-03 18:16:48','',''),(2844,'1','223','1',1,'Retail Sale Id 3064',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 18:24:42','',''),(2845,'1','223','1',1,'Retail Sale Id 3065',1860.00,0.00,0.00,3.00,96.00,'2022-04-03 18:25:34','',''),(2846,'1','223','1',1,'Retail Sale Id 3066',1897.20,0.00,0.00,3.06,97.92,'2022-04-03 18:27:34','',''),(2847,'1','223','1',1,'Retail Sale Id 3067',1252.40,0.00,0.00,2.02,64.64,'2022-04-03 18:30:14','',''),(2848,'1','223','1',1,'Retail Sale Id 3068',3720.00,0.00,0.00,6.00,192.00,'2022-04-03 18:33:50','',''),(2849,'1','223','1',1,'Retail Sale Id 3069',1798.00,0.00,0.00,2.90,92.80,'2022-04-03 18:35:33','',''),(2850,'1','223','1',1,'Retail Sale Id 3070',700.60,0.00,0.00,1.13,36.16,'2022-04-03 18:38:02','',''),(2851,'1','223','1',1,'Retail Sale Id 3071',2498.60,0.00,0.00,4.03,128.96,'2022-04-03 18:41:51','',''),(2852,'1','223','1',1,'Retail Sale Id 3072',2697.00,0.00,0.00,4.35,139.20,'2022-04-03 18:52:43','',''),(2853,'1','223','1',1,'Retail Sale Id 3073',1252.40,0.00,0.00,2.02,64.64,'2022-04-03 18:53:36','',''),(2854,'1','223','1',1,'Retail Sale Id 3074',1252.40,0.00,0.00,2.02,64.64,'2022-04-03 18:54:21','',''),(2855,'1','223','1',1,'Retail Sale Id 3075',2498.60,0.00,0.00,4.03,128.96,'2022-04-04 07:19:57','',''),(2856,'1','223','1',1,'Retail Sale Id 3076',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 07:37:45','',''),(2857,'1','223','1',1,'Retail Sale Id 3077',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 07:39:49','',''),(2858,'1','223','1',1,'Retail Sale Id 3078',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 07:43:57','',''),(2859,'1','223','1',1,'Retail Sale Id 3079',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 08:04:19','',''),(2860,'1','223','1',1,'Retail Sale Id 3080',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 08:04:59','',''),(2861,'1','223','1',1,'Retail Sale Id 3081',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 08:12:28','',''),(2862,'1','223','1',1,'Retail Sale Id 3082',1798.00,0.00,0.00,2.90,92.80,'2022-04-04 08:14:46','',''),(2863,'1','223','1',1,'Retail Sale Id 3084',3751.00,0.00,0.00,6.05,193.60,'2022-04-04 08:20:08','',''),(2864,'1','223','1',1,'Retail Sale Id 3085',1252.40,0.00,0.00,2.02,64.64,'2022-04-04 08:24:56','',''),(2865,'1','223','1',1,'Retail Sale Id 3086',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 08:27:32','',''),(2866,'1','223','1',1,'Retail Sale Id 3087',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 08:44:24','',''),(2867,'1','223','1',1,'Retail Sale Id 3088',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 08:45:11','',''),(2868,'1','223','1',1,'Retail Sale Id 3089',2498.60,0.00,0.00,4.03,128.96,'2022-04-04 09:18:41','',''),(2869,'1','223','1',1,'Retail Sale Id 3090',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 09:23:47','',''),(2870,'1','223','1',1,'Retail Sale Id 3091',1023.00,0.00,0.00,1.65,52.80,'2022-04-04 09:25:19','',''),(2871,'1','223','1',1,'Retail Sale Id 3092',1798.00,0.00,0.00,2.90,92.80,'2022-04-04 09:26:39','',''),(2872,'1','223','1',1,'Retail Sale Id 3095',1252.40,0.00,0.00,2.02,64.64,'2022-04-04 09:56:35','',''),(2873,'1','223','1',1,'Retail Sale Id 3096',7502.00,0.00,0.00,12.10,387.20,'2022-04-04 10:13:37','',''),(2874,'1','223','1',1,'Retail Sale Id 3097',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 10:20:45','',''),(2875,'1','223','1',1,'Retail Sale Id 3098',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 10:22:27','',''),(2876,'1','223','1',1,'Retail Sale Id 3099',1599.60,0.00,0.00,2.58,82.56,'2022-04-04 10:27:08','',''),(2877,'1','223','1',1,'Retail Sale Id 3100',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 10:46:52','',''),(2878,'1','223','1',1,'Retail Sale Id 3101',1897.20,0.00,0.00,3.06,97.92,'2022-04-04 10:55:18','',''),(2879,'1','223','1',1,'Retail Sale Id 3102',1798.00,0.00,0.00,2.90,92.80,'2022-04-04 11:05:51','',''),(2880,'1','223','1',1,'Retail Sale Id 3103',700.60,0.00,0.00,1.13,36.16,'2022-04-04 11:23:56','',''),(2881,'1','223','1',1,'Retail Sale Id 3104',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 11:27:31','',''),(2882,'1','223','1',1,'Retail Sale Id 3105',1798.00,0.00,0.00,2.90,92.80,'2022-04-04 11:29:36','',''),(2883,'1','223','1',1,'Retail Sale Id 3106',3100.00,0.00,0.00,5.00,160.00,'2022-04-04 11:36:56','',''),(2884,'1','223','1',1,'Retail Sale Id 3107',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 12:20:57','',''),(2885,'1','223','1',1,'Retail Sale Id 3108',3503.00,0.00,0.00,5.65,180.80,'2022-04-04 12:44:00','',''),(2886,'1','223','1',1,'Retail Sale Id 3109',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 12:51:16','',''),(2887,'1','223','1',1,'Retail Sale Id 3110',1252.40,0.00,0.00,2.02,64.64,'2022-04-04 13:02:05','',''),(2888,'1','223','1',1,'Retail Sale Id 3111',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 13:22:59','',''),(2889,'1','223','1',1,'Retail Sale Id 3112',30000.00,0.00,0.00,50.00,600.00,'2022-04-04 13:36:44','',''),(2890,'1','223','1',1,'Retail Sale Id 3114',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 13:41:13','',''),(2891,'1','223','1',1,'Retail Sale Id 3115',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 13:42:49','',''),(2892,'1','223','1',1,'Retail Sale Id 3117',1897.20,0.00,0.00,3.06,97.92,'2022-04-04 13:44:34','',''),(2893,'1','223','1',1,'Retail Sale Id 3118',700.60,0.00,0.00,1.13,36.16,'2022-04-04 13:45:30','',''),(2894,'1','223','1',1,'Retail Sale Id 3119',3782.00,0.00,0.00,6.10,195.20,'2022-04-04 13:53:52','',''),(2895,'1','223','1',1,'Retail Sale Id 3120',2498.60,0.00,0.00,4.03,128.96,'2022-04-04 13:54:53','',''),(2896,'1','223','1',1,'Retail Sale Id 3121',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 14:08:16','',''),(2897,'1','223','1',1,'Retail Sale Id 3122',2002.60,0.00,0.00,3.23,103.36,'2022-04-04 14:18:31','',''),(2898,'1','223','1',1,'Retail Sale Id 3123',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 14:42:30','',''),(2899,'1','223','1',1,'Retail Sale Id 3124',74400.00,0.00,0.00,120.00,3840.00,'2022-04-04 14:46:47','',''),(2900,'1','223','1',1,'Return of Retail Sale Id 3124',0.00,74400.00,120.00,0.00,-3840.00,'2022-04-04 14:47:35','',''),(2901,'1','223','1',1,'Retail Sale Id 3125',72000.00,0.00,0.00,120.00,1440.00,'2022-04-04 14:48:19','',''),(2902,'1','223','1',1,'Retail Sale Id 3126',2498.60,0.00,0.00,4.03,128.96,'2022-04-04 14:52:14','',''),(2903,'1','223','1',1,'Retail Sale Id 3128',3100.00,0.00,0.00,5.00,160.00,'2022-04-04 14:59:46','',''),(2904,'1','223','1',1,'Retail Sale Id 3129',2480.00,0.00,0.00,4.00,128.00,'2022-04-04 15:01:11','',''),(2905,'1','223','1',1,'Retail Sale Id 3130',1097.40,0.00,0.00,1.77,56.64,'2022-04-04 15:06:56','',''),(2906,'1','223','1',1,'Retail Sale Id 3131',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 15:12:00','',''),(2907,'1','223','1',1,'Retail Sale Id 3132',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 15:12:54','',''),(2908,'1','223','1',1,'Retail Sale Id 3133',30000.00,0.00,0.00,50.00,600.00,'2022-04-04 15:24:21','',''),(2909,'1','223','1',1,'Retail Sale Id 3134',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 15:25:33','',''),(2910,'1','223','1',1,'Retail Sale Id 3135',1500.40,0.00,0.00,2.42,77.44,'2022-04-04 15:27:44','',''),(2911,'1','223','1',1,'Retail Sale Id 3136',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 15:29:20','',''),(2912,'1','223','1',1,'Retail Sale Id 3137',3100.00,0.00,0.00,5.00,160.00,'2022-04-04 15:30:45','',''),(2913,'1','223','1',1,'Retail Sale Id 3138',3000.80,0.00,0.00,4.84,154.88,'2022-04-04 15:31:43','',''),(2914,'1','223','1',1,'Retail Sale Id 3139',3100.00,0.00,0.00,5.00,160.00,'2022-04-04 15:34:03','',''),(2915,'1','223','1',1,'Retail Sale Id 3140',3701.40,0.00,0.00,5.97,191.04,'2022-04-04 15:44:14','',''),(2916,'1','223','1',1,'Retail Sale Id 3142',651.00,0.00,0.00,1.05,33.60,'2022-04-04 15:48:10','',''),(2917,'1','223','1',1,'Retail Sale Id 3143',2498.60,0.00,0.00,4.03,128.96,'2022-04-04 15:52:31','',''),(2918,'1','223','1',1,'Retail Sale Id 3144',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 16:00:49','',''),(2919,'1','223','1',1,'Retail Sale Id 3145',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 16:02:47','',''),(2920,'1','223','1',1,'Retail Sale Id 3146',1500.40,0.00,0.00,2.42,77.44,'2022-04-04 16:12:21','',''),(2921,'1','223','1',1,'Retail Sale Id 3147',4997.20,0.00,0.00,8.06,257.92,'2022-04-04 16:17:06','',''),(2922,'1','223','1',1,'Retail Sale Id 3148',4997.20,0.00,0.00,8.06,257.92,'2022-04-04 16:17:39','',''),(2923,'1','223','1',1,'Retail Sale Id 3149',7750.00,0.00,0.00,12.50,400.00,'2022-04-04 16:25:18','',''),(2924,'1','223','1',1,'Retail Sale Id 3150',620.00,0.00,0.00,1.00,32.00,'2022-04-04 16:28:11','',''),(2925,'1','223','1',1,'Retail Sale Id 3151',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 16:30:22','',''),(2926,'1','223','1',1,'Retail Sale Id 3152',3100.00,0.00,0.00,5.00,160.00,'2022-04-04 16:33:32','',''),(2927,'1','223','1',1,'Retail Sale Id 3153',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 16:38:46','',''),(2928,'1','223','1',1,'Retail Sale Id 3154',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 16:39:46','',''),(2929,'1','223','1',1,'Retail Sale Id 3155',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 16:44:50','',''),(2930,'1','223','1',1,'Retail Sale Id 3156',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 16:45:54','',''),(2931,'1','223','1',1,'Retail Sale Id 3157',3000.80,0.00,0.00,4.84,154.88,'2022-04-04 16:49:08','',''),(2932,'1','223','1',1,'Retail Sale Id 3158',719.20,0.00,0.00,1.16,37.12,'2022-04-04 16:50:25','',''),(2933,'1','223','1',1,'Retail Sale Id 3159',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 16:51:16','',''),(2934,'1','223','1',1,'Retail Sale Id 3160',2480.00,0.00,0.00,4.00,128.00,'2022-04-04 16:52:37','',''),(2935,'1','223','1',1,'Retail Sale Id 3161',3410.00,0.00,0.00,5.50,176.00,'2022-04-04 16:54:30','',''),(2936,'1','223','1',1,'Retail Sale Id 3162',6200.00,0.00,0.00,10.00,320.00,'2022-04-04 16:57:00','',''),(2937,'1','223','1',1,'Retail Sale Id 3163',2480.00,0.00,0.00,4.00,128.00,'2022-04-04 17:00:24','',''),(2938,'1','223','1',1,'Retail Sale Id 3164',7750.00,0.00,0.00,12.50,400.00,'2022-04-04 17:04:20','',''),(2939,'1','223','1',1,'Retail Sale Id 3166',30000.00,0.00,0.00,50.00,600.00,'2022-04-04 17:08:26','',''),(2940,'1','223','1',1,'Retail Sale Id 3167',2498.60,0.00,0.00,4.03,128.96,'2022-04-04 17:09:46','',''),(2941,'1','223','1',1,'Retail Sale Id 3168',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 17:14:04','',''),(2942,'1','223','1',1,'Retail Sale Id 3169',2480.00,0.00,0.00,4.00,128.00,'2022-04-04 17:15:56','',''),(2943,'1','223','1',1,'Retail Sale Id 3170',2002.60,0.00,0.00,3.23,103.36,'2022-04-04 17:16:51','',''),(2944,'1','223','1',1,'Retail Sale Id 3171',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 17:18:58','',''),(2945,'1','223','1',1,'Retail Sale Id 3172',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 17:19:47','',''),(2946,'1','223','1',1,'Retail Sale Id 3173',7750.00,0.00,0.00,12.50,400.00,'2022-04-04 17:28:10','',''),(2947,'1','223','1',1,'Retail Sale Id 3174',998.20,0.00,0.00,1.61,51.52,'2022-04-04 17:30:51','',''),(2948,'1','223','1',1,'Retail Sale Id 3175',998.20,0.00,0.00,1.61,51.52,'2022-04-04 17:38:02','',''),(2949,'1','223','1',1,'Retail Sale Id 3176',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 17:42:19','',''),(2950,'1','223','1',1,'Retail Sale Id 3177',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 17:44:49','',''),(2951,'1','223','1',1,'Retail Sale Id 3178',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 17:45:59','',''),(2952,'1','223','1',1,'Retail Sale Id 3179',3100.00,0.00,0.00,5.00,160.00,'2022-04-04 17:49:09','',''),(2953,'1','223','1',1,'Retail Sale Id 3180',2498.60,0.00,0.00,4.03,128.96,'2022-04-04 17:53:01','',''),(2954,'1','223','1',1,'Retail Sale Id 3181',1897.20,0.00,0.00,3.06,97.92,'2022-04-04 17:56:45','',''),(2955,'1','223','1',1,'Retail Sale Id 3182',2498.60,0.00,0.00,4.03,128.96,'2022-04-04 17:59:59','',''),(2956,'1','223','1',1,'Retail Sale Id 3183',1302.00,0.00,0.00,2.10,67.20,'2022-04-04 18:01:05','',''),(2957,'1','223','1',1,'Retail Sale Id 3184',5580.00,0.00,0.00,9.00,288.00,'2022-04-04 18:03:06','',''),(2958,'1','223','1',1,'Retail Sale Id 3185',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 18:08:44','',''),(2959,'1','223','1',1,'Retail Sale Id 3186',1860.00,0.00,0.00,3.00,96.00,'2022-04-04 18:09:40','',''),(2960,'1','223','1',1,'Retail Sale Id 3187',2498.60,0.00,0.00,4.03,128.96,'2022-04-04 18:16:09','',''),(2961,'1','223','1',1,'Retail Sale Id 3188',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 18:17:23','',''),(2962,'1','223','1',1,'Retail Sale Id 3189',3720.00,0.00,0.00,6.00,192.00,'2022-04-04 18:26:35','',''),(2963,'1','223','1',1,'Retail Sale Id 3190',2002.60,0.00,0.00,3.23,103.36,'2022-04-04 18:28:47','',''),(2964,'1','223','1',1,'Retail Sale Id 3191',2002.60,0.00,0.00,3.23,103.36,'2022-04-04 18:29:19','',''),(2965,'1','223','1',1,'Retail Sale Id 3192',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 18:30:16','',''),(2966,'1','223','1',1,'Retail Sale Id 3193',1240.00,0.00,0.00,2.00,64.00,'2022-04-04 18:32:49','',''),(2967,'1','223','1',1,'Retail Sale Id 3194',2480.00,0.00,0.00,4.00,128.00,'2022-04-04 18:36:50','',''),(2968,'1','223','1',1,'Retail Sale Id 3195',3100.00,0.00,0.00,5.00,160.00,'2022-04-04 18:54:04','',''),(2969,'1','223','1',1,'Retail Sale Id 3196',3100.00,0.00,0.00,5.00,160.00,'2022-04-05 07:01:53','',''),(2970,'1','223','1',1,'Retail Sale Id 3197',2002.60,0.00,0.00,3.23,103.36,'2022-04-05 07:03:22','',''),(2971,'1','223','1',1,'Retail Sale Id 3199',620.00,0.00,0.00,1.00,32.00,'2022-04-05 07:14:25','',''),(2972,'1','223','1',1,'Retail Sale Id 3200',1302.00,0.00,0.00,2.10,67.20,'2022-04-05 07:15:42','',''),(2973,'1','223','1',1,'Retail Sale Id 3201',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 07:22:25','',''),(2974,'1','223','1',1,'Retail Sale Id 3202',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 07:51:29','',''),(2975,'1','223','1',1,'Retail Sale Id 3203',620.00,0.00,0.00,1.00,32.00,'2022-04-05 07:52:49','',''),(2976,'1','223','1',1,'Retail Sale Id 3204',998.20,0.00,0.00,1.61,51.52,'2022-04-05 07:55:44','',''),(2977,'1','223','1',1,'Retail Sale Id 3205',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 08:00:34','',''),(2978,'1','223','1',1,'Retail Sale Id 3206',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 08:11:25','',''),(2979,'1','223','1',1,'Retail Sale Id 3207',7750.00,0.00,0.00,12.50,400.00,'2022-04-05 08:26:12','',''),(2980,'1','223','1',1,'Retail Sale Id 3208',7750.00,0.00,0.00,12.50,400.00,'2022-04-05 08:28:23','',''),(2981,'1','223','1',1,'Retail Sale Id 3209',1897.20,0.00,0.00,3.06,97.92,'2022-04-05 08:42:49','',''),(2982,'1','223','1',1,'Retail Sale Id 3210',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 08:45:23','',''),(2983,'1','223','1',1,'Retail Sale Id 3211',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 08:53:28','',''),(2984,'1','223','1',1,'Retail Sale Id 3212',799.80,0.00,0.00,1.29,41.28,'2022-04-05 09:00:36','',''),(2985,'1','223','1',1,'Retail Sale Id 3213',1202.80,0.00,0.00,1.94,62.08,'2022-04-05 09:08:03','',''),(2986,'1','223','1',1,'Retail Sale Id 3214',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 09:10:00','',''),(2987,'1','223','1',1,'Retail Sale Id 3215',1897.20,0.00,0.00,3.06,97.92,'2022-04-05 09:18:47','',''),(2988,'1','223','1',1,'Retail Sale Id 3216',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 09:27:56','',''),(2989,'1','223','1',1,'Retail Sale Id 3217',1897.20,0.00,0.00,3.06,97.92,'2022-04-05 09:39:29','',''),(2990,'1','223','1',1,'Retail Sale Id 3218',57000.00,0.00,0.00,95.00,1140.00,'2022-04-05 09:44:34','',''),(2991,'1','223','1',1,'Retail Sale Id 3219',75000.00,0.00,0.00,125.00,1500.00,'2022-04-05 09:47:08','',''),(2992,'1','223','1',1,'Retail Sale Id 3220',1798.00,0.00,0.00,2.90,92.80,'2022-04-05 09:56:29','',''),(2993,'1','223','1',1,'Retail Sale Id 3221',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 10:04:22','',''),(2994,'1','223','1',1,'Retail Sale Id 3222',620.00,0.00,0.00,1.00,32.00,'2022-04-05 10:05:21','',''),(2995,'1','223','1',1,'Retail Sale Id 3223',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 10:10:30','',''),(2996,'1','223','1',1,'Retail Sale Id 3224',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 10:11:41','',''),(2997,'1','223','1',1,'Retail Sale Id 3225',2480.00,0.00,0.00,4.00,128.00,'2022-04-05 10:41:53','',''),(2998,'1','223','1',1,'Retail Sale Id 3226',1897.20,0.00,0.00,3.06,97.92,'2022-04-05 10:52:04','',''),(2999,'1','223','1',1,'Retail Sale Id 3227',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 10:55:47','',''),(3000,'1','223','1',1,'Retail Sale Id 3228',6851.00,0.00,0.00,11.05,353.60,'2022-04-05 11:00:31','',''),(3001,'1','223','1',1,'Retail Sale Id 3229',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 11:34:05','',''),(3002,'1','223','1',1,'Retail Sale Id 3230',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 11:37:42','',''),(3003,'1','223','1',1,'Retail Sale Id 3231',2498.60,0.00,0.00,4.03,128.96,'2022-04-05 11:44:51','',''),(3004,'1','223','1',1,'Retail Sale Id 3232',24000.00,0.00,0.00,40.00,480.00,'2022-04-05 12:33:22','',''),(3005,'1','223','1',1,'Retail Sale Id 3233',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 12:39:53','',''),(3006,'1','223','1',1,'Retail Sale Id 3234',2498.60,0.00,0.00,4.03,128.96,'2022-04-05 12:42:03','',''),(3007,'1','223','1',1,'Retail Sale Id 3235',1897.20,0.00,0.00,3.06,97.92,'2022-04-05 13:01:52','',''),(3008,'1','223','1',1,'Retail Sale Id 3236',1252.40,0.00,0.00,2.02,64.64,'2022-04-05 13:13:36','',''),(3009,'1','223','1',1,'Retail Sale Id 3237',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 13:25:55','',''),(3010,'1','223','1',1,'Retail Sale Id 3238',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 13:27:21','',''),(3011,'1','223','1',1,'Retail Sale Id 3239',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 13:27:48','',''),(3012,'1','223','1',1,'Retail Sale Id 3240',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 13:29:53','',''),(3013,'1','223','1',1,'Retail Sale Id 3241',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 13:32:13','',''),(3014,'1','223','1',1,'Retail Sale Id 3242',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 13:35:33','',''),(3015,'1','223','1',1,'Retail Sale Id 3243',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 13:57:18','',''),(3016,'1','223','1',1,'Retail Sale Id 3245',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 14:00:10','',''),(3017,'1','223','1',1,'Retail Sale Id 3246',3100.00,0.00,0.00,5.00,160.00,'2022-04-05 14:44:32','',''),(3018,'1','223','1',1,'Retail Sale Id 3247',2498.60,0.00,0.00,4.03,128.96,'2022-04-05 14:52:57','',''),(3019,'1','223','1',1,'Retail Sale Id 3248',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 14:55:32','',''),(3020,'1','223','1',1,'Retail Sale Id 3248',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 14:55:32','',''),(3021,'1','223','1',1,'Retail Sale Id 3249',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 15:00:11','',''),(3022,'1','223','1',1,'Retail Sale Id 3250',2002.60,0.00,0.00,3.23,103.36,'2022-04-05 15:02:54','',''),(3023,'1','223','1',1,'Retail Sale Id 3252',2498.60,0.00,0.00,4.03,128.96,'2022-04-05 15:04:34','',''),(3024,'1','223','1',1,'Retail Sale Id 3253',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 15:16:15','',''),(3025,'1','223','1',1,'Retail Sale Id 3254',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 15:17:04','',''),(3026,'1','223','1',1,'Retail Sale Id 3255',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 15:19:40','',''),(3027,'1','223','1',1,'Retail Sale Id 3256',2002.60,0.00,0.00,3.23,103.36,'2022-04-05 15:40:52','',''),(3028,'1','223','1',1,'Retail Sale Id 3257',2498.60,0.00,0.00,4.03,128.96,'2022-04-05 15:43:12','',''),(3029,'1','223','1',1,'Retail Sale Id 3258',6200.00,0.00,0.00,10.00,320.00,'2022-04-05 15:49:11','',''),(3030,'1','223','1',1,'Retail Sale Id 3259',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 15:50:01','',''),(3031,'1','223','1',1,'Retail Sale Id 3260',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 16:00:52','',''),(3032,'1','223','1',1,'Retail Sale Id 3261',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 16:08:02','',''),(3033,'1','223','1',1,'Retail Sale Id 3262',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 16:22:11','',''),(3034,'1','223','1',1,'Retail Sale Id 3263',1897.20,0.00,0.00,3.06,97.92,'2022-04-05 16:25:52','',''),(3035,'1','223','1',1,'Retail Sale Id 3264',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 16:27:39','',''),(3036,'1','223','1',1,'Retail Sale Id 3265',448200.00,0.00,0.00,747.00,8964.00,'2022-04-05 16:43:26','',''),(3037,'1','223','1',1,'Retail Sale Id 3266',998.20,0.00,0.00,1.61,51.52,'2022-04-05 16:44:16','',''),(3038,'1','223','1',1,'Retail Sale Id 3268',3100.00,0.00,0.00,5.00,160.00,'2022-04-05 16:53:12','',''),(3039,'1','223','1',1,'Retail Sale Id 3269',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 16:54:11','',''),(3040,'1','223','1',1,'Retail Sale Id 3270',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 16:54:49','',''),(3041,'1','223','1',1,'Retail Sale Id 3271',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 16:58:22','',''),(3042,'1','223','1',1,'Retail Sale Id 3272',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 16:59:31','',''),(3043,'1','223','1',1,'Retail Sale Id 3274',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 17:04:13','',''),(3044,'1','223','1',1,'Retail Sale Id 3275',3720.00,0.00,0.00,6.00,192.00,'2022-04-05 17:05:08','',''),(3045,'1','223','1',1,'Retail Sale Id 3276',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 17:06:06','',''),(3046,'1','223','1',1,'Retail Sale Id 3277',3100.00,0.00,0.00,5.00,160.00,'2022-04-05 17:10:54','',''),(3047,'1','223','1',1,'Retail Sale Id 3278',998.20,0.00,0.00,1.61,51.52,'2022-04-05 17:20:58','',''),(3048,'1','223','1',1,'Retail Sale Id 3279',7750.00,0.00,0.00,12.50,400.00,'2022-04-05 17:22:37','',''),(3049,'1','223','1',1,'Retail Sale Id 3280',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 17:23:16','',''),(3050,'1','223','1',1,'Retail Sale Id 3281',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 17:27:44','',''),(3051,'1','223','1',1,'Retail Sale Id 3282',1252.40,0.00,0.00,2.02,64.64,'2022-04-05 17:30:58','',''),(3052,'1','223','1',1,'Retail Sale Id 3283',2498.60,0.00,0.00,4.03,128.96,'2022-04-05 17:31:51','',''),(3053,'1','223','1',1,'Retail Sale Id 3284',5580.00,0.00,0.00,9.00,288.00,'2022-04-05 17:32:55','',''),(3054,'1','223','1',1,'Retail Sale Id 3285',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 17:35:28','',''),(3055,'1','223','1',1,'Retail Sale Id 3286',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 17:36:21','',''),(3056,'1','223','1',1,'Retail Sale Id 3287',2498.60,0.00,0.00,4.03,128.96,'2022-04-05 17:53:31','',''),(3057,'1','223','1',1,'Return of Retail Sale Id 3287',0.00,2498.60,4.03,0.00,-128.96,'2022-04-05 17:53:48','',''),(3058,'1','223','1',1,'Retail Sale Id 3288',2101.80,0.00,0.00,3.39,108.48,'2022-04-05 17:54:20','',''),(3059,'1','223','1',1,'Retail Sale Id 3289',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 18:05:29','',''),(3060,'1','223','1',1,'Retail Sale Id 3290',3100.00,0.00,0.00,5.00,160.00,'2022-04-05 18:06:29','',''),(3061,'1','223','1',1,'Retail Sale Id 3291',2480.00,0.00,0.00,4.00,128.00,'2022-04-05 18:08:36','',''),(3062,'1','223','1',1,'Retail Sale Id 3292',1240.00,0.00,0.00,2.00,64.00,'2022-04-05 18:12:57','',''),(3063,'1','223','1',1,'Retail Sale Id 3293',1252.40,0.00,0.00,2.02,64.64,'2022-04-05 18:21:35','',''),(3064,'1','223','1',1,'Retail Sale Id 3294',2498.60,0.00,0.00,4.03,128.96,'2022-04-05 18:25:59','',''),(3065,'1','223','1',1,'Retail Sale Id 3295',998.20,0.00,0.00,1.61,51.52,'2022-04-05 18:26:33','',''),(3066,'1','223','1',1,'Retail Sale Id 3296',1500.40,0.00,0.00,2.42,77.44,'2022-04-05 18:29:01','',''),(3067,'1','223','1',1,'Retail Sale Id 3297',1351.60,0.00,0.00,2.18,69.76,'2022-04-05 18:39:08','',''),(3068,'1','223','1',1,'Retail Sale Id 3298',799.80,0.00,0.00,1.29,41.28,'2022-04-05 18:43:27','',''),(3069,'1','223','1',1,'Retail Sale Id 3299',1860.00,0.00,0.00,3.00,96.00,'2022-04-05 18:47:40','',''),(3070,'1','223','1',1,'Retail Sale Id 3300',1897.20,0.00,0.00,3.06,97.92,'2022-04-05 18:48:44','',''),(3071,'1','223','1',1,'Retail Sale Id 3301',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 07:12:48','',''),(3072,'1','223','1',1,'Retail Sale Id 3302',1897.20,0.00,0.00,3.06,97.92,'2022-04-06 07:34:09','',''),(3073,'1','223','1',1,'Retail Sale Id 3303',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 07:37:53','',''),(3074,'1','223','1',1,'Retail Sale Id 3304',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 07:44:06','',''),(3075,'1','223','1',1,'Retail Sale Id 3305',998.20,0.00,0.00,1.61,51.52,'2022-04-06 07:47:18','',''),(3076,'1','223','1',1,'Retail Sale Id 3306',2498.60,0.00,0.00,4.03,128.96,'2022-04-06 07:48:17','',''),(3077,'1','223','1',1,'Retail Sale Id 3307',3701.40,0.00,0.00,5.97,191.04,'2022-04-06 07:55:22','',''),(3078,'1','223','1',1,'Retail Sale Id 3308',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 08:03:01','',''),(3079,'1','223','1',1,'Retail Sale Id 3309',1302.00,0.00,0.00,2.10,67.20,'2022-04-06 08:11:11','',''),(3080,'1','223','1',1,'Retail Sale Id 3310',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 08:15:46','',''),(3081,'1','223','1',1,'Retail Sale Id 3312',601.40,0.00,0.00,0.97,31.04,'2022-04-06 08:30:38','',''),(3082,'1','223','1',1,'Retail Sale Id 3313',4997.20,0.00,0.00,8.06,257.92,'2022-04-06 08:37:09','',''),(3083,'1','223','1',1,'Retail Sale Id 3314',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 08:51:01','',''),(3084,'1','223','1',1,'Retail Sale Id 3315',3751.00,0.00,0.00,6.05,193.60,'2022-04-06 08:58:38','',''),(3085,'1','223','1',1,'Retail Sale Id 3316',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 09:00:08','',''),(3086,'1','223','1',1,'Retail Sale Id 3317',6851.00,0.00,0.00,11.05,353.60,'2022-04-06 09:01:55','',''),(3087,'1','223','1',1,'Retail Sale Id 3318',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 09:02:33','',''),(3088,'1','223','1',1,'Retail Sale Id 3319',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 09:03:15','',''),(3089,'1','223','1',1,'Retail Sale Id 3320',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 09:09:26','',''),(3090,'1','223','1',1,'Retail Sale Id 3321',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 09:32:16','',''),(3091,'1','223','1',1,'Retail Sale Id 3322',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 09:38:46','',''),(3092,'1','223','1',1,'Retail Sale Id 3323',1252.40,0.00,0.00,2.02,64.64,'2022-04-06 09:43:01','',''),(3093,'1','223','1',1,'Retail Sale Id 3324',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 09:53:17','',''),(3094,'1','223','1',1,'Retail Sale Id 3325',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 10:02:04','',''),(3095,'1','223','1',1,'Retail Sale Id 3326',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 10:18:51','',''),(3096,'1','223','1',1,'Retail Sale Id 3327',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 10:20:00','',''),(3097,'1','223','1',1,'Retail Sale Id 3328',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 10:22:01','',''),(3098,'1','223','1',1,'Retail Sale Id 3329',4340.00,0.00,0.00,7.00,224.00,'2022-04-06 10:26:44','',''),(3099,'1','223','1',1,'Retail Sale Id 3330',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 10:27:37','',''),(3100,'1','223','1',1,'Retail Sale Id 3331',7750.00,0.00,0.00,12.50,400.00,'2022-04-06 10:38:31','',''),(3101,'1','223','1',1,'Retail Sale Id 3332',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 10:48:05','',''),(3102,'1','223','1',1,'Retail Sale Id 3333',1252.40,0.00,0.00,2.02,64.64,'2022-04-06 11:10:32','',''),(3103,'1','223','1',1,'Retail Sale Id 3334',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 11:24:19','',''),(3104,'1','223','1',1,'Retail Sale Id 3335',2697.00,0.00,0.00,4.35,139.20,'2022-04-06 11:26:55','',''),(3105,'1','223','1',1,'Retail Sale Id 3337',1240.00,0.00,0.00,2.00,64.00,'2022-04-06 11:48:09','',''),(3106,'1','223','1',1,'Retail Sale Id 3338',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 12:01:13','',''),(3107,'1','223','1',1,'Retail Sale Id 3339',998.20,0.00,0.00,1.61,51.52,'2022-04-06 12:02:43','',''),(3108,'1','223','1',1,'Retail Sale Id 3340',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 12:03:16','',''),(3109,'1','223','1',1,'Retail Sale Id 3341',66000.00,0.00,0.00,110.00,1320.00,'2022-04-06 12:06:09','',''),(3110,'1','223','1',1,'Retail Sale Id 3342',1202.80,0.00,0.00,1.94,62.08,'2022-04-06 12:07:59','',''),(3111,'1','223','1',1,'Retail Sale Id 3343',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 12:08:51','',''),(3112,'1','223','1',1,'Retail Sale Id 3344',3000.80,0.00,0.00,4.84,154.88,'2022-04-06 12:15:40','',''),(3113,'1','223','1',1,'Retail Sale Id 3345',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 12:27:31','',''),(3114,'1','223','1',1,'Retail Sale Id 3346',30000.00,0.00,0.00,50.00,600.00,'2022-04-06 12:37:37','',''),(3115,'1','223','1',1,'Retail Sale Id 3347',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 12:57:56','',''),(3116,'1','223','1',1,'Retail Sale Id 3348',1897.20,0.00,0.00,3.06,97.92,'2022-04-06 13:02:04','',''),(3117,'1','223','1',1,'Retail Sale Id 3349',651.00,0.00,0.00,1.05,33.60,'2022-04-06 13:08:46','',''),(3118,'1','223','1',1,'Retail Sale Id 3350',1897.20,0.00,0.00,3.06,97.92,'2022-04-06 13:09:28','',''),(3119,'1','223','1',1,'Retail Sale Id 3351',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 13:21:50','',''),(3120,'1','223','1',1,'Retail Sale Id 3352',2498.60,0.00,0.00,4.03,128.96,'2022-04-06 13:22:48','',''),(3121,'1','223','1',1,'Retail Sale Id 3353',2498.60,0.00,0.00,4.03,128.96,'2022-04-06 13:57:04','',''),(3122,'1','223','1',1,'Retail Sale Id 3354',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 14:14:12','',''),(3123,'1','223','1',1,'Retail Sale Id 3355',1252.40,0.00,0.00,2.02,64.64,'2022-04-06 14:16:53','',''),(3124,'1','223','1',1,'Retail Sale Id 3356',1240.00,0.00,0.00,2.00,64.00,'2022-04-06 14:29:00','',''),(3125,'1','223','1',1,'Retail Sale Id 3357',799.80,0.00,0.00,1.29,41.28,'2022-04-06 14:30:59','',''),(3126,'1','223','1',1,'Retail Sale Id 3358',2002.60,0.00,0.00,3.23,103.36,'2022-04-06 14:32:47','',''),(3127,'1','223','1',1,'Retail Sale Id 3359',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 14:34:54','',''),(3128,'1','223','1',1,'Retail Sale Id 3360',3999.00,0.00,0.00,6.45,206.40,'2022-04-06 14:44:50','',''),(3129,'1','223','1',1,'Retail Sale Id 3361',998.20,0.00,0.00,1.61,51.52,'2022-04-06 14:45:26','',''),(3130,'1','223','1',1,'Retail Sale Id 3362',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 14:48:59','',''),(3131,'1','223','1',1,'Retail Sale Id 3363',7750.00,0.00,0.00,12.50,400.00,'2022-04-06 14:52:33','',''),(3132,'1','223','1',1,'Retail Sale Id 3364',1240.00,0.00,0.00,2.00,64.00,'2022-04-06 15:06:31','',''),(3133,'1','223','1',1,'Retail Sale Id 3365',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 15:07:24','',''),(3134,'1','223','1',1,'Retail Sale Id 3366',27600.00,0.00,0.00,46.00,552.00,'2022-04-06 15:09:35','',''),(3135,'1','223','1',1,'Retail Sale Id 3367',2498.60,0.00,0.00,4.03,128.96,'2022-04-06 15:11:25','',''),(3136,'1','223','1',1,'Retail Sale Id 3368',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 15:13:29','',''),(3137,'1','223','1',1,'Retail Sale Id 3369',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 15:16:45','',''),(3138,'1','223','1',1,'Retail Sale Id 3370',2498.60,0.00,0.00,4.03,128.96,'2022-04-06 15:21:29','',''),(3139,'1','223','1',1,'Retail Sale Id 3371',2498.60,0.00,0.00,4.03,128.96,'2022-04-06 15:33:13','',''),(3140,'1','223','1',1,'Retail Sale Id 3372',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 15:41:20','',''),(3141,'1','223','1',1,'Retail Sale Id 3373',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 15:44:32','',''),(3142,'1','223','1',1,'Retail Sale Id 3374',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 15:46:06','',''),(3143,'1','223','1',1,'Retail Sale Id 3375',2480.00,0.00,0.00,4.00,128.00,'2022-04-06 15:48:09','',''),(3144,'1','223','1',1,'Retail Sale Id 3376',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 15:49:29','',''),(3145,'1','223','1',1,'Retail Sale Id 3377',1302.00,0.00,0.00,2.10,67.20,'2022-04-06 15:57:17','',''),(3146,'1','223','1',1,'Retail Sale Id 3378',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 16:04:16','',''),(3147,'1','223','1',1,'Retail Sale Id 3379',2498.60,0.00,0.00,4.03,128.96,'2022-04-06 16:15:20','',''),(3148,'1','223','1',1,'Retail Sale Id 3380',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 16:26:36','',''),(3149,'1','223','1',1,'Retail Sale Id 3381',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 16:28:57','',''),(3150,'1','223','1',1,'Retail Sale Id 3382',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 16:38:54','',''),(3151,'1','223','1',1,'Retail Sale Id 3383',7750.00,0.00,0.00,12.50,400.00,'2022-04-06 16:43:18','',''),(3152,'1','223','1',1,'Retail Sale Id 3384',2002.60,0.00,0.00,3.23,103.36,'2022-04-06 16:46:08','',''),(3153,'1','223','1',1,'Retail Sale Id 3385',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 16:47:51','',''),(3154,'1','223','1',1,'Retail Sale Id 3386',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 16:48:51','',''),(3155,'1','223','1',1,'Retail Sale Id 3387',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 16:49:36','',''),(3156,'1','223','1',1,'Retail Sale Id 3388',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 16:53:03','',''),(3157,'1','223','1',1,'Retail Sale Id 3389',1240.00,0.00,0.00,2.00,64.00,'2022-04-06 16:53:47','',''),(3158,'1','223','1',1,'Retail Sale Id 3390',1240.00,0.00,0.00,2.00,64.00,'2022-04-06 16:59:23','',''),(3159,'1','223','1',1,'Retail Sale Id 3390',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 16:59:23','',''),(3160,'1','223','1',1,'Retail Sale Id 3391',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 17:12:49','',''),(3161,'1','223','1',1,'Retail Sale Id 3392',3000.80,0.00,0.00,4.84,154.88,'2022-04-06 17:14:22','',''),(3162,'1','223','1',1,'Retail Sale Id 3393',1897.20,0.00,0.00,3.06,97.92,'2022-04-06 17:15:47','',''),(3163,'1','223','1',1,'Retail Sale Id 3394',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 17:21:39','',''),(3164,'1','223','1',1,'Retail Sale Id 3395',1240.00,0.00,0.00,2.00,64.00,'2022-04-06 17:26:33','',''),(3165,'1','223','1',1,'Retail Sale Id 3396',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 17:37:51','',''),(3166,'1','223','1',1,'Retail Sale Id 3397',1202.80,0.00,0.00,1.94,62.08,'2022-04-06 17:42:14','',''),(3167,'1','223','1',1,'Retail Sale Id 3398',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 17:42:57','',''),(3168,'1','223','1',1,'Retail Sale Id 3399',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 17:44:05','',''),(3169,'1','223','1',1,'Retail Sale Id 3400',1202.80,0.00,0.00,1.94,62.08,'2022-04-06 17:48:02','',''),(3170,'1','223','1',1,'Retail Sale Id 3401',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 17:48:58','',''),(3171,'1','223','1',1,'Retail Sale Id 3402',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 17:51:31','',''),(3172,'1','223','1',1,'Retail Sale Id 3403',1202.80,0.00,0.00,1.94,62.08,'2022-04-06 17:52:47','',''),(3173,'1','223','1',1,'Retail Sale Id 3404',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 17:54:45','',''),(3174,'1','223','1',1,'Retail Sale Id 3405',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 17:56:06','',''),(3175,'1','223','1',1,'Retail Sale Id 3406',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 17:57:12','',''),(3176,'1','223','1',1,'Retail Sale Id 3407',3720.00,0.00,0.00,6.00,192.00,'2022-04-06 17:58:26','',''),(3177,'1','223','1',1,'Retail Sale Id 3408',4960.00,0.00,0.00,8.00,256.00,'2022-04-06 17:59:49','',''),(3178,'1','223','1',1,'Retail Sale Id 3409',3000.80,0.00,0.00,4.84,154.88,'2022-04-06 18:05:48','',''),(3179,'1','223','1',1,'Retail Sale Id 3410',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 18:08:55','',''),(3180,'1','223','1',1,'Retail Sale Id 3411',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 18:21:21','',''),(3181,'1','223','1',1,'Retail Sale Id 3412',1860.00,0.00,0.00,3.00,96.00,'2022-04-06 18:29:06','',''),(3182,'1','223','1',1,'Retail Sale Id 3413',1252.40,0.00,0.00,2.02,64.64,'2022-04-06 18:29:36','',''),(3183,'1','223','1',1,'Retail Sale Id 3414',1847.60,0.00,0.00,2.98,95.36,'2022-04-06 18:32:16','',''),(3184,'1','223','1',1,'Retail Sale Id 3415',3100.00,0.00,0.00,5.00,160.00,'2022-04-06 18:46:06','',''),(3185,'1','223','1',1,'Retail Sale Id 3416',1240.00,0.00,0.00,2.00,64.00,'2022-04-07 07:21:17','',''),(3186,'1','223','1',1,'Retail Sale Id 3418',10608.20,0.00,0.00,17.11,547.52,'2022-04-07 07:26:29','',''),(3187,'1','223','1',1,'Retail Sale Id 3419',3100.00,0.00,0.00,5.00,160.00,'2022-04-07 07:44:28','',''),(3188,'1','223','1',1,'Retail Sale Id 3420',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 08:00:43','',''),(3189,'1','223','1',1,'Retail Sale Id 3421',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 08:08:22','',''),(3190,'1','223','1',1,'Retail Sale Id 3422',2498.60,0.00,0.00,4.03,128.96,'2022-04-07 08:15:29','',''),(3191,'1','223','1',1,'Retail Sale Id 3423',4997.20,0.00,0.00,8.06,257.92,'2022-04-07 08:31:33','',''),(3192,'1','223','1',1,'Retail Sale Id 3424',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 08:38:57','',''),(3193,'1','223','1',1,'Retail Sale Id 3425',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 08:48:48','',''),(3194,'1','223','1',1,'Retail Sale Id 3426',4340.00,0.00,0.00,7.00,224.00,'2022-04-07 08:53:27','',''),(3195,'1','223','1',1,'Retail Sale Id 3427',1252.40,0.00,0.00,2.02,64.64,'2022-04-07 08:55:44','',''),(3196,'1','223','1',1,'Retail Sale Id 3428',1252.40,0.00,0.00,2.02,64.64,'2022-04-07 08:56:23','',''),(3197,'1','223','1',1,'Retail Sale Id 3429',1698.80,0.00,0.00,2.74,87.68,'2022-04-07 08:57:34','',''),(3198,'1','223','1',1,'Retail Sale Id 3430',28800.00,0.00,0.00,48.00,576.00,'2022-04-07 09:03:40','',''),(3199,'1','223','1',1,'Retail Sale Id 3431',2498.60,0.00,0.00,4.03,128.96,'2022-04-07 09:15:07','',''),(3200,'1','223','1',1,'Retail Sale Id 3432',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 09:22:14','',''),(3201,'1','223','1',1,'Retail Sale Id 3433',3100.00,0.00,0.00,5.00,160.00,'2022-04-07 09:26:37','',''),(3202,'1','223','1',1,'Retail Sale Id 3434',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 09:28:51','',''),(3203,'1','223','1',1,'Retail Sale Id 3435',1500.00,0.00,0.00,2.50,30.00,'2022-04-07 09:34:37','',''),(3204,'1','223','1',1,'Retail Sale Id 3436',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 09:54:45','',''),(3205,'1','223','1',1,'Retail Sale Id 3437',3100.00,0.00,0.00,5.00,160.00,'2022-04-07 09:59:07','',''),(3206,'1','223','1',1,'Retail Sale Id 3438',3720.00,0.00,0.00,6.00,192.00,'2022-04-07 10:09:39','',''),(3207,'1','223','1',1,'Retail Sale Id 3439',998.20,0.00,0.00,1.61,51.52,'2022-04-07 10:24:22','',''),(3208,'1','223','1',1,'Retail Sale Id 3440',60000.00,0.00,0.00,100.00,1200.00,'2022-04-07 10:46:04','',''),(3209,'1','223','1',1,'Retail Sale Id 3441',1202.80,0.00,0.00,1.94,62.08,'2022-04-07 10:59:45','',''),(3210,'1','223','1',1,'Retail Sale Id 3442',1240.00,0.00,0.00,2.00,64.00,'2022-04-07 11:07:19','',''),(3211,'1','223','1',1,'Retail Sale Id 3443',1202.80,0.00,0.00,1.94,62.08,'2022-04-07 11:15:20','',''),(3212,'1','223','1',1,'Retail Sale Id 3444',1240.00,0.00,0.00,2.00,64.00,'2022-04-07 11:24:36','',''),(3213,'1','223','1',1,'Retail Sale Id 3445',2498.60,0.00,0.00,4.03,128.96,'2022-04-07 11:27:10','',''),(3214,'1','223','1',1,'Retail Sale Id 3446',1240.00,0.00,0.00,2.00,64.00,'2022-04-07 11:30:54','',''),(3215,'1','223','1',1,'Retail Sale Id 3447',30000.00,0.00,0.00,50.00,600.00,'2022-04-07 11:49:10','',''),(3216,'1','223','1',1,'Retail Sale Id 3448',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 11:57:02','',''),(3217,'1','223','1',1,'Retail Sale Id 3450',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 12:01:59','',''),(3218,'1','223','1',1,'Retail Sale Id 3451',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 12:02:47','',''),(3219,'1','223','1',1,'Retail Sale Id 3452',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 12:30:22','',''),(3220,'1','223','1',1,'Retail Sale Id 3454',1897.20,0.00,0.00,3.06,97.92,'2022-04-07 12:32:33','',''),(3221,'1','223','1',1,'Retail Sale Id 3455',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 12:39:33','',''),(3222,'1','223','1',1,'Retail Sale Id 3456',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 13:06:08','',''),(3223,'1','223','1',1,'Retail Sale Id 3459',3751.00,0.00,0.00,6.05,193.60,'2022-04-07 13:08:27','',''),(3224,'1','223','1',1,'Retail Sale Id 3460',1860.00,0.00,0.00,3.00,96.00,'2022-04-07 13:37:56','',''),(3225,'1','223','1',1,'Retail Sale Id 3461',3720.00,0.00,0.00,6.00,192.00,'2022-04-07 13:50:52','',''),(3226,'1','223','1',1,'Retail Sale Id 3462',3100.00,0.00,0.00,5.00,160.00,'2022-04-07 13:59:59','',''),(3227,'1','223','1',1,'Retail Sale Id 3463',79500.00,0.00,0.00,132.50,1590.00,'2022-04-07 15:16:19','',''),(3228,'1','223','1',1,'Distributed to A A RANO NIGERIA LIMITED for sales id:2',199155.60,0.00,0.00,338.70,0.00,'2022-04-08 08:47:43','',''),(3229,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,1764000.00,3000.00,0.00,0.00,'2022-04-08 09:11:02','',''),(3230,'1','223',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,3000.00,0.00,'2022-04-08 09:14:25','',''),(3231,'1','223','1',1,'Received from bridging 4',0.00,0.00,3000.00,0.00,0.00,'2022-04-08 09:14:25','',''),(3232,'1','223','1',1,'Retail Sale Id 3464',112500.00,0.00,0.00,187.50,2250.00,'2022-04-08 09:26:04','',''),(3233,'1','223','1',1,'Retail Sale Id 3465',35400.00,0.00,0.00,59.00,708.00,'2022-04-08 09:27:05','',''),(3234,'1','223','1',1,'Retail Sale Id 3466',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 09:29:55','',''),(3235,'1','223','1',1,'Retail Sale Id 3467',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 09:32:11','',''),(3236,'1','223','1',1,'Retail Sale Id 3468',998.20,0.00,0.00,1.61,51.52,'2022-04-08 09:33:04','',''),(3237,'1','223','1',1,'Retail Sale Id 3469',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 09:40:51','',''),(3238,'1','223','1',1,'Retail Sale Id 3470',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 09:42:03','',''),(3239,'1','223','1',1,'Retail Sale Id 3471',3720.00,0.00,0.00,6.00,192.00,'2022-04-08 09:43:04','',''),(3240,'1','223','1',1,'Retail Sale Id 3472',1897.20,0.00,0.00,3.06,97.92,'2022-04-08 09:49:58','',''),(3241,'1','223','1',1,'Retail Sale Id 3473',7750.00,0.00,0.00,12.50,400.00,'2022-04-08 09:50:32','',''),(3242,'1','223','1',1,'Retail Sale Id 3474',1897.20,0.00,0.00,3.06,97.92,'2022-04-08 09:57:55','',''),(3243,'1','223','1',1,'Retail Sale Id 3475',998.20,0.00,0.00,1.61,51.52,'2022-04-08 09:59:54','',''),(3244,'1','223','1',1,'Retail Sale Id 3476',998.20,0.00,0.00,1.61,51.52,'2022-04-08 10:02:23','',''),(3245,'1','223','1',1,'Retail Sale Id 3477',1302.00,0.00,0.00,2.10,67.20,'2022-04-08 10:10:09','',''),(3246,'1','223','1',1,'Retail Sale Id 3478',31291.40,0.00,0.00,50.47,1615.04,'2022-04-08 10:15:28','',''),(3247,'1','223','1',1,'Retail Sale Id 3479',3100.00,0.00,0.00,5.00,160.00,'2022-04-08 10:16:10','',''),(3248,'1','223','1',1,'Retail Sale Id 3480',14043.00,0.00,0.00,22.65,724.80,'2022-04-08 10:17:37','',''),(3249,'1','223','1',1,'Return of Retail Sale Id 3480',0.00,14043.00,22.65,0.00,-724.80,'2022-04-08 10:20:54','',''),(3250,'1','223','1',1,'Retail Sale Id 3481',15140.40,0.00,0.00,24.42,781.44,'2022-04-08 10:21:33','',''),(3251,'1','223','1',1,'Retail Sale Id 3482',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 10:59:51','',''),(3252,'1','223','1',1,'Retail Sale Id 3483',1202.80,0.00,0.00,1.94,62.08,'2022-04-08 11:04:53','',''),(3253,'1','223','1',1,'Return of Retail Sale Id 3483',0.00,1202.80,1.94,0.00,-62.08,'2022-04-08 11:05:56','',''),(3254,'1','223','1',1,'Retail Sale Id 3484',1240.00,0.00,0.00,2.00,64.00,'2022-04-08 11:06:19','',''),(3255,'1','223','1',1,'Retail Sale Id 3485',3751.00,0.00,0.00,6.05,193.60,'2022-04-08 11:08:44','',''),(3256,'1','223','1',1,'Retail Sale Id 3486',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 11:24:13','',''),(3257,'1','223','1',1,'Retail Sale Id 3487',2170.00,0.00,0.00,3.50,112.00,'2022-04-08 11:25:26','',''),(3258,'1','223','1',1,'Retail Sale Id 3488',1897.20,0.00,0.00,3.06,97.92,'2022-04-08 12:07:24','',''),(3259,'1','223','1',1,'Retail Sale Id 3489',1897.20,0.00,0.00,3.06,97.92,'2022-04-08 12:20:09','',''),(3260,'1','223','1',1,'Retail Sale Id 3490',6820.00,0.00,0.00,11.00,352.00,'2022-04-08 12:27:40','',''),(3261,'1','223','1',1,'Retail Sale Id 3491',3000.80,0.00,0.00,4.84,154.88,'2022-04-08 12:40:09','',''),(3262,'1','223','1',1,'Retail Sale Id 3492',3751.00,0.00,0.00,6.05,193.60,'2022-04-08 12:41:22','',''),(3263,'1','223','1',1,'Return of Retail Sale Id 3491',0.00,3000.80,4.84,0.00,-154.88,'2022-04-08 12:41:52','',''),(3264,'1','223','1',1,'Retail Sale Id 3493',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 12:49:33','',''),(3265,'1','223','1',1,'Retail Sale Id 3494',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 13:28:38','',''),(3266,'1','223','1',1,'Retail Sale Id 3495',2498.60,0.00,0.00,4.03,128.96,'2022-04-08 13:44:29','',''),(3267,'1','223','1',1,'Retail Sale Id 3496',1240.00,0.00,0.00,2.00,64.00,'2022-04-08 14:11:05','',''),(3268,'1','223','1',1,'Retail Sale Id 3497',2480.00,0.00,0.00,4.00,128.00,'2022-04-08 14:36:27','',''),(3269,'1','223','1',1,'Retail Sale Id 3498',3720.00,0.00,0.00,6.00,192.00,'2022-04-08 14:38:17','',''),(3270,'1','223','1',1,'Retail Sale Id 3499',998.20,0.00,0.00,1.61,51.52,'2022-04-08 14:51:15','',''),(3271,'1','223','1',1,'Retail Sale Id 3500',3100.00,0.00,0.00,5.00,160.00,'2022-04-08 15:20:18','',''),(3272,'1','223','1',1,'Retail Sale Id 3501',3100.00,0.00,0.00,5.00,160.00,'2022-04-08 15:24:53','',''),(3273,'1','223','1',1,'Retail Sale Id 3502',3100.00,0.00,0.00,5.00,160.00,'2022-04-08 15:26:05','',''),(3274,'1','223','1',1,'Retail Sale Id 3503',2498.60,0.00,0.00,4.03,128.96,'2022-04-08 15:27:57','',''),(3275,'1','223','1',1,'Retail Sale Id 3504',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 15:31:02','',''),(3276,'1','223','1',1,'Retail Sale Id 3506',2498.60,0.00,0.00,4.03,128.96,'2022-04-08 15:44:50','',''),(3277,'1','223','1',1,'Retail Sale Id 3507',1860.00,0.00,0.00,3.00,96.00,'2022-04-08 15:47:57','',''),(3278,'1','223','1',1,'Retail Sale Id 3508',1500.40,0.00,0.00,2.42,77.44,'2022-04-08 15:51:12','',''),(3279,'1','223','1',1,'Retail Sale Id 3509',1860.00,0.00,0.00,3.00,96.00,'2022-04-08 16:03:14','',''),(3280,'1','223','1',1,'Retail Sale Id 3511',2498.60,0.00,0.00,4.03,128.96,'2022-04-08 16:05:58','',''),(3281,'1','223','1',1,'Retail Sale Id 3512',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 16:08:52','',''),(3282,'1','223','1',1,'Retail Sale Id 3513',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 16:20:04','',''),(3283,'1','223','1',1,'Retail Sale Id 3514',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 16:20:30','',''),(3284,'1','223','1',1,'Retail Sale Id 3515',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 16:26:28','',''),(3285,'1','223','1',1,'Retail Sale Id 3516',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 16:28:54','',''),(3286,'1','223','1',1,'Retail Sale Id 3517',6200.00,0.00,0.00,10.00,320.00,'2022-04-08 16:33:44','',''),(3287,'1','223','1',1,'Retail Sale Id 3518',651.00,0.00,0.00,1.05,33.60,'2022-04-08 16:34:45','',''),(3288,'1','223','1',1,'Retail Sale Id 3519',2002.60,0.00,0.00,3.23,103.36,'2022-04-08 16:35:48','',''),(3289,'1','223','1',1,'Retail Sale Id 3520',7750.00,0.00,0.00,12.50,400.00,'2022-04-08 16:36:26','',''),(3290,'1','223','1',1,'Retail Sale Id 3521',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 16:41:14','',''),(3291,'1','223','1',1,'Retail Sale Id 3522',2002.60,0.00,0.00,3.23,103.36,'2022-04-08 16:42:03','',''),(3292,'1','223','1',1,'Retail Sale Id 3523',502.20,0.00,0.00,0.81,25.92,'2022-04-08 16:47:30','',''),(3293,'1','223','1',1,'Retail Sale Id 3524',3100.00,0.00,0.00,5.00,160.00,'2022-04-08 16:48:46','',''),(3294,'1','223','1',1,'Retail Sale Id 3525',1897.20,0.00,0.00,3.06,97.92,'2022-04-08 16:49:43','',''),(3295,'1','223','1',1,'Retail Sale Id 3526',1897.20,0.00,0.00,3.06,97.92,'2022-04-08 16:50:23','',''),(3296,'1','223','1',1,'Retail Sale Id 3527',3100.00,0.00,0.00,5.00,160.00,'2022-04-08 16:57:09','',''),(3297,'1','223','1',1,'Retail Sale Id 3528',3100.00,0.00,0.00,5.00,160.00,'2022-04-08 16:59:32','',''),(3298,'1','223','1',1,'Retail Sale Id 3529',502.20,0.00,0.00,0.81,25.92,'2022-04-08 17:00:25','',''),(3299,'1','223','1',1,'Retail Sale Id 3530',25200.00,0.00,0.00,42.00,504.00,'2022-04-08 17:01:14','',''),(3300,'1','223','1',1,'Retail Sale Id 3531',1798.00,0.00,0.00,2.90,92.80,'2022-04-08 17:03:34','',''),(3301,'1','223','1',1,'Retail Sale Id 3532',7750.00,0.00,0.00,12.50,400.00,'2022-04-08 17:04:45','',''),(3302,'1','223','1',1,'Retail Sale Id 3533',1860.00,0.00,0.00,3.00,96.00,'2022-04-08 17:07:57','',''),(3303,'1','223','1',1,'Retail Sale Id 3534',3720.00,0.00,0.00,6.00,192.00,'2022-04-08 17:18:31','',''),(3304,'1','223','1',1,'Retail Sale Id 3535',700.60,0.00,0.00,1.13,36.16,'2022-04-08 17:19:50','',''),(3305,'1','223','1',1,'Retail Sale Id 3536',750.20,0.00,0.00,1.21,38.72,'2022-04-08 17:20:21','',''),(3306,'1','223','1',1,'Retail Sale Id 3537',750.20,0.00,0.00,1.21,38.72,'2022-04-08 17:21:11','',''),(3307,'1','223','1',1,'Retail Sale Id 3538',60000.00,0.00,0.00,100.00,1200.00,'2022-04-08 17:22:59','',''),(3308,'1','223','1',1,'Retail Sale Id 3539',998.20,0.00,0.00,1.61,51.52,'2022-04-08 17:23:51','',''),(3309,'1','223','1',1,'Retail Sale Id 3540',3100.00,0.00,0.00,5.00,160.00,'2022-04-08 17:26:41','',''),(3310,'1','223','1',1,'Retail Sale Id 3541',799.80,0.00,0.00,1.29,41.28,'2022-04-08 17:31:57','',''),(3311,'1','223','1',1,'Retail Sale Id 3542',582000.00,0.00,0.00,970.00,11640.00,'2022-04-08 17:34:02','',''),(3312,'1','223','1',1,'Retail Sale Id 3544',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 17:36:41','',''),(3313,'1','223','1',1,'Retail Sale Id 3545',3100.00,0.00,0.00,5.00,160.00,'2022-04-08 17:38:37','',''),(3314,'1','223','1',1,'Retail Sale Id 3546',7750.00,0.00,0.00,12.50,400.00,'2022-04-08 17:45:09','',''),(3315,'1','223','1',1,'Retail Sale Id 3547',3720.00,0.00,0.00,6.00,192.00,'2022-04-08 17:46:10','',''),(3316,'1','223','1',1,'Retail Sale Id 3548',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 17:50:01','',''),(3317,'1','223','1',1,'Retail Sale Id 3549',1897.20,0.00,0.00,3.06,97.92,'2022-04-08 17:51:50','',''),(3318,'1','223','1',1,'Retail Sale Id 3550',502.20,0.00,0.00,0.81,25.92,'2022-04-08 17:54:00','',''),(3319,'1','223','1',1,'Retail Sale Id 3551',3720.00,0.00,0.00,6.00,192.00,'2022-04-08 18:01:50','',''),(3320,'1','223','1',1,'Retail Sale Id 3552',1500.40,0.00,0.00,2.42,77.44,'2022-04-08 18:04:22','',''),(3321,'1','223','1',1,'Retail Sale Id 3553',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 18:04:54','',''),(3322,'1','223','1',1,'Retail Sale Id 3554',440.20,0.00,0.00,0.71,22.72,'2022-04-08 18:07:44','',''),(3323,'1','223','1',1,'Retail Sale Id 3555',1897.20,0.00,0.00,3.06,97.92,'2022-04-08 18:08:36','',''),(3324,'1','223','1',1,'Retail Sale Id 3556',30000.00,0.00,0.00,50.00,600.00,'2022-04-08 18:14:42','',''),(3325,'1','223','1',1,'Retail Sale Id 3557',3999.00,0.00,0.00,6.45,206.40,'2022-04-08 18:21:50','',''),(3326,'1','223','1',1,'Retail Sale Id 3558',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 18:23:16','',''),(3327,'1','223','1',1,'Retail Sale Id 3559',1252.40,0.00,0.00,2.02,64.64,'2022-04-08 18:23:43','',''),(3328,'1','223','1',1,'Retail Sale Id 3560',2002.60,0.00,0.00,3.23,103.36,'2022-04-08 18:24:09','',''),(3329,'1','223','1',1,'Retail Sale Id 3561',1240.00,0.00,0.00,2.00,64.00,'2022-04-08 18:25:43','',''),(3330,'1','223','1',1,'Retail Sale Id 3562',5580.00,0.00,0.00,9.00,288.00,'2022-04-08 18:29:33','',''),(3331,'1','223','1',1,'Retail Sale Id 3563',1897.20,0.00,0.00,3.06,97.92,'2022-04-08 18:32:25','',''),(3332,'1','223','1',1,'Retail Sale Id 3564',1500.40,0.00,0.00,2.42,77.44,'2022-04-08 18:39:27','',''),(3333,'1','223','1',1,'Retail Sale Id 3565',2498.60,0.00,0.00,4.03,128.96,'2022-04-08 18:40:46','',''),(3334,'1','223','1',1,'Retail Sale Id 3566',3000.80,0.00,0.00,4.84,154.88,'2022-04-08 18:41:42','',''),(3335,'1','223','1',1,'Retail Sale Id 3567',2002.60,0.00,0.00,3.23,103.36,'2022-04-09 07:28:13','',''),(3336,'1','223','1',1,'Retail Sale Id 3568',1240.00,0.00,0.00,2.00,64.00,'2022-04-09 07:55:26','',''),(3337,'1','223','1',1,'Retail Sale Id 3569',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 07:58:27','',''),(3338,'1','223','1',1,'Retail Sale Id 3570',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 08:02:24','',''),(3339,'1','223','1',1,'Retail Sale Id 3571',620.00,0.00,0.00,1.00,32.00,'2022-04-09 08:09:36','',''),(3340,'1','223','1',1,'Retail Sale Id 3572',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 08:14:16','',''),(3341,'1','223','1',1,'Retail Sale Id 3573',1847.60,0.00,0.00,2.98,95.36,'2022-04-09 08:24:56','',''),(3342,'1','223','1',1,'Retail Sale Id 3574',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 08:30:31','',''),(3343,'1','223','1',1,'Retail Sale Id 3575',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 08:31:52','',''),(3344,'1','223','1',1,'Retail Sale Id 3576',998.20,0.00,0.00,1.61,51.52,'2022-04-09 08:33:07','',''),(3345,'1','223','1',1,'Retail Sale Id 3577',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 08:34:19','',''),(3346,'1','223','1',1,'Retail Sale Id 3578',24000.00,0.00,0.00,40.00,480.00,'2022-04-09 08:51:29','',''),(3347,'1','223','1',1,'Retail Sale Id 3579',998.20,0.00,0.00,1.61,51.52,'2022-04-09 08:53:22','',''),(3348,'1','223','1',1,'Retail Sale Id 3580',620.00,0.00,0.00,1.00,32.00,'2022-04-09 08:54:17','',''),(3349,'1','223','1',1,'Retail Sale Id 3581',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 08:56:00','',''),(3350,'1','223','1',1,'Retail Sale Id 3582',1798.00,0.00,0.00,2.90,92.80,'2022-04-09 08:59:32','',''),(3351,'1','223','1',1,'Retail Sale Id 3583',1599.60,0.00,0.00,2.58,82.56,'2022-04-09 09:04:23','',''),(3352,'1','223','1',1,'Retail Sale Id 3584',1847.60,0.00,0.00,2.98,95.36,'2022-04-09 09:05:28','',''),(3353,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,1087800.00,1850.00,0.00,0.00,'2022-04-09 09:09:57','',''),(3354,'1','223',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,1850.00,0.00,'2022-04-09 09:12:28','',''),(3355,'1','223','1',1,'Received from bridging 5',0.00,0.00,1850.00,0.00,0.00,'2022-04-09 09:12:28','',''),(3356,'1','223','1',1,'Retail Sale Id 3585',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 09:13:40','',''),(3357,'1','223','1',1,'Retail Sale Id 3586',1202.80,0.00,0.00,1.94,62.08,'2022-04-09 09:15:14','',''),(3358,'1','223','1',1,'Retail Sale Id 3587',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 09:16:55','',''),(3359,'1','223','1',1,'Retail Sale Id 3588',6200.00,0.00,0.00,10.00,320.00,'2022-04-09 09:17:57','',''),(3360,'1','223','1',1,'Retail Sale Id 3589',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 09:21:10','',''),(3361,'1','223','1',1,'Retail Sale Id 3590',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 09:22:21','',''),(3362,'1','223','1',1,'Retail Sale Id 3591',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 09:39:29','',''),(3363,'1','223','1',1,'Retail Sale Id 3592',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 09:43:25','',''),(3364,'1','223','1',1,'Retail Sale Id 3593',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 10:04:21','',''),(3365,'1','223','1',1,'Retail Sale Id 3594',15500.00,0.00,0.00,25.00,800.00,'2022-04-09 10:06:23','',''),(3366,'1','223','1',1,'Retail Sale Id 3595',7750.00,0.00,0.00,12.50,400.00,'2022-04-09 10:07:26','',''),(3367,'1','223','1',1,'Retail Sale Id 3596',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 10:08:14','',''),(3368,'1','223','1',1,'Retail Sale Id 3597',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 10:12:33','',''),(3369,'1','223','1',1,'Retail Sale Id 3598',4997.20,0.00,0.00,8.06,257.92,'2022-04-09 10:16:48','',''),(3370,'1','223','1',1,'Retail Sale Id 3599',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 10:19:31','',''),(3371,'1','223','1',1,'Retail Sale Id 3600',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 10:21:12','',''),(3372,'1','223','1',1,'Retail Sale Id 3601',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 10:22:20','',''),(3373,'1','223','1',1,'Retail Sale Id 3602',2498.60,0.00,0.00,4.03,128.96,'2022-04-09 10:23:35','',''),(3374,'1','223','1',1,'Retail Sale Id 3603',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 10:25:30','',''),(3375,'1','223','1',1,'Retail Sale Id 3604',620.00,0.00,0.00,1.00,32.00,'2022-04-09 10:31:32','',''),(3376,'1','223','1',1,'Retail Sale Id 3605',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 10:32:53','',''),(3377,'1','223','1',1,'Retail Sale Id 3606',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 10:37:00','',''),(3378,'1','223','1',1,'Retail Sale Id 3607',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 10:39:07','',''),(3379,'1','223','1',1,'Retail Sale Id 3608',1500.40,0.00,0.00,2.42,77.44,'2022-04-09 10:43:14','',''),(3380,'1','223','1',1,'Retail Sale Id 3609',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 10:51:07','',''),(3381,'1','223','1',1,'Retail Sale Id 3610',651.00,0.00,0.00,1.05,33.60,'2022-04-09 10:52:24','',''),(3382,'1','223','1',1,'Retail Sale Id 3611',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 10:59:24','',''),(3383,'1','223','1',1,'Retail Sale Id 3612',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 11:03:53','',''),(3384,'1','223','1',1,'Retail Sale Id 3613',7750.00,0.00,0.00,12.50,400.00,'2022-04-09 11:04:59','',''),(3385,'1','223','1',1,'Retail Sale Id 3614',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 11:24:14','',''),(3386,'1','223','1',1,'Retail Sale Id 3615',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 11:26:44','',''),(3387,'1','223','1',1,'Retail Sale Id 3616',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 11:27:43','',''),(3388,'1','223','1',1,'Retail Sale Id 3617',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 11:31:48','',''),(3389,'1','223','1',1,'Retail Sale Id 3618',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 11:52:55','',''),(3390,'1','223','1',1,'Retail Sale Id 3619',2480.00,0.00,0.00,4.00,128.00,'2022-04-09 11:55:16','',''),(3391,'1','223','1',1,'Retail Sale Id 3620',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 11:56:49','',''),(3392,'1','223','1',1,'Retail Sale Id 3621',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 12:00:36','',''),(3393,'1','223','1',1,'Retail Sale Id 3622',2480.00,0.00,0.00,4.00,128.00,'2022-04-09 12:09:59','',''),(3394,'1','223','1',1,'Return of Retail Sale Id 3622',0.00,2480.00,4.00,0.00,-128.00,'2022-04-09 12:11:41','',''),(3395,'1','223','1',1,'Retail Sale Id 3623',3000.80,0.00,0.00,4.84,154.88,'2022-04-09 12:12:35','',''),(3396,'1','223','1',1,'Retail Sale Id 3624',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 12:14:05','',''),(3397,'1','223','1',1,'Retail Sale Id 3625',620.00,0.00,0.00,1.00,32.00,'2022-04-09 12:18:46','',''),(3398,'1','223','1',1,'Retail Sale Id 3626',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 12:23:58','',''),(3399,'1','223','1',1,'Retail Sale Id 3627',1500.40,0.00,0.00,2.42,77.44,'2022-04-09 12:26:51','',''),(3400,'1','223','1',1,'Retail Sale Id 3628',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 12:31:42','',''),(3401,'1','223','1',1,'Retail Sale Id 3629',7750.00,0.00,0.00,12.50,400.00,'2022-04-09 12:41:57','',''),(3402,'1','223','1',1,'Retail Sale Id 3630',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 12:48:17','',''),(3403,'1','223','1',1,'Retail Sale Id 3631',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 12:57:39','',''),(3404,'1','223','1',1,'Retail Sale Id 3632',3720.00,0.00,0.00,6.00,192.00,'2022-04-09 12:59:07','',''),(3405,'1','223','1',1,'Retail Sale Id 3633',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 13:00:27','',''),(3406,'1','223','1',1,'Retail Sale Id 3634',1779.40,0.00,0.00,2.87,91.84,'2022-04-09 13:01:35','',''),(3407,'1','223','1',1,'Retail Sale Id 3635',2498.60,0.00,0.00,4.03,128.96,'2022-04-09 13:04:08','',''),(3408,'1','223','1',1,'Retail Sale Id 3636',1847.60,0.00,0.00,2.98,95.36,'2022-04-09 13:10:23','',''),(3409,'1','223','1',1,'Retail Sale Id 3637',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 13:13:52','',''),(3410,'1','223','1',1,'Retail Sale Id 3638',2498.60,0.00,0.00,4.03,128.96,'2022-04-09 13:34:01','',''),(3411,'1','223','1',1,'Retail Sale Id 3639',1847.60,0.00,0.00,2.98,95.36,'2022-04-09 13:40:27','',''),(3412,'1','223','1',1,'Retail Sale Id 3640',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 13:43:41','',''),(3413,'1','223','1',1,'Retail Sale Id 3641',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 13:44:29','',''),(3414,'1','223','1',1,'Retail Sale Id 3642',1302.00,0.00,0.00,2.10,67.20,'2022-04-09 13:45:37','',''),(3415,'1','223','1',1,'Retail Sale Id 3643',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 13:57:45','',''),(3416,'1','223','1',1,'Retail Sale Id 3644',2498.60,0.00,0.00,4.03,128.96,'2022-04-09 14:00:18','',''),(3417,'1','223','1',1,'Retail Sale Id 3645',651.00,0.00,0.00,1.05,33.60,'2022-04-09 14:04:59','',''),(3418,'1','223','1',1,'Retail Sale Id 3646',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 14:05:35','',''),(3419,'1','223','1',1,'Retail Sale Id 3647',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 14:06:38','',''),(3420,'1','223','1',1,'Retail Sale Id 3648',998.20,0.00,0.00,1.61,51.52,'2022-04-09 14:08:06','',''),(3421,'1','223','1',1,'Retail Sale Id 3649',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 14:08:56','',''),(3422,'1','223','1',1,'Retail Sale Id 3650',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 14:09:28','',''),(3423,'1','223','1',1,'Retail Sale Id 3651',3720.00,0.00,0.00,6.00,192.00,'2022-04-09 14:10:30','',''),(3424,'1','223','1',1,'Retail Sale Id 3652',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 14:12:29','',''),(3425,'1','223','1',1,'Retail Sale Id 3653',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 14:16:07','',''),(3426,'1','223','1',1,'Retail Sale Id 3654',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 14:22:16','',''),(3427,'1','223','1',1,'Retail Sale Id 3655',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 14:23:15','',''),(3428,'1','223','1',1,'Retail Sale Id 3656',1302.00,0.00,0.00,2.10,67.20,'2022-04-09 14:27:53','',''),(3429,'1','223','1',1,'Retail Sale Id 3657',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 14:29:39','',''),(3430,'1','223','1',1,'Retail Sale Id 3658',1240.00,0.00,0.00,2.00,64.00,'2022-04-09 14:39:18','',''),(3431,'1','223','1',1,'Retail Sale Id 3659',1240.00,0.00,0.00,2.00,64.00,'2022-04-09 14:39:43','',''),(3432,'1','223','1',1,'Retail Sale Id 3660',2002.60,0.00,0.00,3.23,103.36,'2022-04-09 14:45:54','',''),(3433,'1','223','1',1,'Retail Sale Id 3663',1240.00,0.00,0.00,2.00,64.00,'2022-04-09 14:56:21','',''),(3434,'1','223','1',1,'Retail Sale Id 3664',3000.80,0.00,0.00,4.84,154.88,'2022-04-09 14:57:09','',''),(3435,'1','223','1',1,'Retail Sale Id 3665',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 15:04:28','',''),(3436,'1','223','1',1,'Retail Sale Id 3666',2498.60,0.00,0.00,4.03,128.96,'2022-04-09 15:05:25','',''),(3437,'1','223','1',1,'Retail Sale Id 3667',2498.60,0.00,0.00,4.03,128.96,'2022-04-09 15:08:05','',''),(3438,'1','223','1',1,'Return of Retail Sale Id 3666',0.00,2498.60,4.03,0.00,-128.96,'2022-04-09 15:08:31','',''),(3439,'1','223','1',1,'Retail Sale Id 3668',1240.00,0.00,0.00,2.00,64.00,'2022-04-09 15:09:02','',''),(3440,'1','223','1',1,'Retail Sale Id 3669',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 15:13:03','',''),(3441,'1','223','1',1,'Retail Sale Id 3670',1500.40,0.00,0.00,2.42,77.44,'2022-04-09 15:17:18','',''),(3442,'1','223','1',1,'Retail Sale Id 3671',37500.00,0.00,0.00,62.50,750.00,'2022-04-09 15:25:21','',''),(3443,'1','223','1',1,'Retail Sale Id 3672',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 15:30:07','',''),(3444,'1','223','1',1,'Retail Sale Id 3673',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 15:31:02','',''),(3445,'1','223','1',1,'Retail Sale Id 3674',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 15:35:58','',''),(3446,'1','223','1',1,'Retail Sale Id 3675',3720.00,0.00,0.00,6.00,192.00,'2022-04-09 15:39:42','',''),(3447,'1','223','1',1,'Retail Sale Id 3676',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 15:44:54','',''),(3448,'1','223','1',1,'Retail Sale Id 3677',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 15:46:07','',''),(3449,'1','223','1',1,'Retail Sale Id 3678',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 15:49:05','',''),(3450,'1','223','1',1,'Retail Sale Id 3679',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 15:49:34','',''),(3451,'1','223','1',1,'Retail Sale Id 3680',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 15:50:24','',''),(3452,'1','223','1',1,'Retail Sale Id 3681',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 15:51:17','',''),(3453,'1','223','1',1,'Retail Sale Id 3682',4352.40,0.00,0.00,7.02,224.64,'2022-04-09 15:54:54','',''),(3454,'1','223','1',1,'Retail Sale Id 3683',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 15:57:03','',''),(3455,'1','223','1',1,'Retail Sale Id 3684',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 15:58:34','',''),(3456,'1','223','1',1,'Retail Sale Id 3685',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 16:02:02','',''),(3457,'1','223','1',1,'Retail Sale Id 3686',2498.60,0.00,0.00,4.03,128.96,'2022-04-09 16:02:58','',''),(3458,'1','223','1',1,'Return of Retail Sale Id 3678',0.00,1860.00,3.00,0.00,-96.00,'2022-04-09 16:06:33','',''),(3459,'1','223','1',1,'Retail Sale Id 3687',998.20,0.00,0.00,1.61,51.52,'2022-04-09 16:06:53','',''),(3460,'1','223','1',1,'Retail Sale Id 3689',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 16:11:58','',''),(3461,'1','223','1',1,'Retail Sale Id 3690',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 16:16:01','',''),(3462,'1','223','1',1,'Retail Sale Id 3691',2498.60,0.00,0.00,4.03,128.96,'2022-04-09 16:17:00','',''),(3463,'1','223','1',1,'Retail Sale Id 3692',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 16:26:41','',''),(3464,'1','223','1',1,'Retail Sale Id 3693',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 16:31:21','',''),(3465,'1','223','1',1,'Retail Sale Id 3694',7750.00,0.00,0.00,12.50,400.00,'2022-04-09 16:32:06','',''),(3466,'1','223','1',1,'Retail Sale Id 3695',1302.00,0.00,0.00,2.10,67.20,'2022-04-09 16:44:51','',''),(3467,'1','223','1',1,'Retail Sale Id 3696',3999.00,0.00,0.00,6.45,206.40,'2022-04-09 16:47:01','',''),(3468,'1','223','1',1,'Retail Sale Id 3697',7750.00,0.00,0.00,12.50,400.00,'2022-04-09 16:51:03','',''),(3469,'1','223','1',1,'Retail Sale Id 3699',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 16:52:22','',''),(3470,'1','223','1',1,'Retail Sale Id 3700',3720.00,0.00,0.00,6.00,192.00,'2022-04-09 16:56:16','',''),(3471,'1','223','1',1,'Retail Sale Id 3701',601.40,0.00,0.00,0.97,31.04,'2022-04-09 17:09:12','',''),(3472,'1','223','1',1,'Retail Sale Id 3702',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 17:10:53','',''),(3473,'1','223','1',1,'Retail Sale Id 3703',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 17:11:32','',''),(3474,'1','223','1',1,'Retail Sale Id 3704',998.20,0.00,0.00,1.61,51.52,'2022-04-09 17:12:32','',''),(3475,'1','223','1',1,'Retail Sale Id 3705',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 17:13:12','',''),(3476,'1','223','1',1,'Retail Sale Id 3706',1500.40,0.00,0.00,2.42,77.44,'2022-04-09 17:13:45','',''),(3477,'1','223','1',1,'Retail Sale Id 3707',7750.00,0.00,0.00,12.50,400.00,'2022-04-09 17:14:42','',''),(3478,'1','223','1',1,'Retail Sale Id 3708',1202.80,0.00,0.00,1.94,62.08,'2022-04-09 17:15:36','',''),(3479,'1','223','1',1,'Return of Retail Sale Id 3708',0.00,1202.80,1.94,0.00,-62.08,'2022-04-09 17:15:59','',''),(3480,'1','223','1',1,'Retail Sale Id 3709',998.20,0.00,0.00,1.61,51.52,'2022-04-09 17:16:20','',''),(3481,'1','223','1',1,'Retail Sale Id 3710',1240.00,0.00,0.00,2.00,64.00,'2022-04-09 17:18:17','',''),(3482,'1','223','1',1,'Retail Sale Id 3711',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 17:19:56','',''),(3483,'1','223','1',1,'Retail Sale Id 3712',7750.00,0.00,0.00,12.50,400.00,'2022-04-09 17:21:27','',''),(3484,'1','223','1',1,'Retail Sale Id 3713',1202.80,0.00,0.00,1.94,62.08,'2022-04-09 17:22:01','',''),(3485,'1','223','1',1,'Retail Sale Id 3714',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 17:22:46','',''),(3486,'1','223','1',1,'Retail Sale Id 3715',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 17:23:22','',''),(3487,'1','223','1',1,'Retail Sale Id 3716',2498.60,0.00,0.00,4.03,128.96,'2022-04-09 17:23:55','',''),(3488,'1','223','1',1,'Retail Sale Id 3717',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 17:25:07','',''),(3489,'1','223','1',1,'Retail Sale Id 3718',3720.00,0.00,0.00,6.00,192.00,'2022-04-09 17:28:01','',''),(3490,'1','223','1',1,'Retail Sale Id 3719',3100.00,0.00,0.00,5.00,160.00,'2022-04-09 17:28:46','',''),(3491,'1','223','1',1,'Retail Sale Id 3720',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 17:32:15','',''),(3492,'1','223','1',1,'Retail Sale Id 3721',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 17:33:28','',''),(3493,'1','223','1',1,'Retail Sale Id 3722',7750.00,0.00,0.00,12.50,400.00,'2022-04-09 17:34:19','',''),(3494,'1','223','1',1,'Retail Sale Id 3723',2498.60,0.00,0.00,4.03,128.96,'2022-04-09 17:35:37','',''),(3495,'1','223','1',1,'Retail Sale Id 3724',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 17:37:59','',''),(3496,'1','223','1',1,'Retail Sale Id 3725',620.00,0.00,0.00,1.00,32.00,'2022-04-09 17:39:14','',''),(3497,'1','223','1',1,'Retail Sale Id 3726',3720.00,0.00,0.00,6.00,192.00,'2022-04-09 17:49:29','',''),(3498,'1','223','1',1,'Retail Sale Id 3727',620.00,0.00,0.00,1.00,32.00,'2022-04-09 17:50:23','',''),(3499,'1','223','1',1,'Retail Sale Id 3728',601.40,0.00,0.00,0.97,31.04,'2022-04-09 17:51:47','',''),(3500,'1','223','1',1,'Retail Sale Id 3729',1860.00,0.00,0.00,3.00,96.00,'2022-04-09 17:52:34','',''),(3501,'1','223','1',1,'Retail Sale Id 3730',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 17:57:50','',''),(3502,'1','223','1',1,'Retail Sale Id 3732',3751.00,0.00,0.00,6.05,193.60,'2022-04-09 18:10:54','',''),(3503,'1','223','1',1,'Retail Sale Id 3733',1252.40,0.00,0.00,2.02,64.64,'2022-04-09 18:12:18','',''),(3504,'1','223','1',1,'Retail Sale Id 3734',1240.00,0.00,0.00,2.00,64.00,'2022-04-09 18:13:10','',''),(3505,'1','223','1',1,'Retail Sale Id 3735',1302.00,0.00,0.00,2.10,67.20,'2022-04-09 18:14:31','',''),(3506,'1','223','1',1,'Retail Sale Id 3736',3000.80,0.00,0.00,4.84,154.88,'2022-04-09 18:16:31','',''),(3507,'1','223','1',1,'Retail Sale Id 3737',601.40,0.00,0.00,0.97,31.04,'2022-04-09 18:35:03','',''),(3508,'1','223','1',1,'Retail Sale Id 3738',1897.20,0.00,0.00,3.06,97.92,'2022-04-09 18:38:14','',''),(3509,'1','223','1',1,'Retail Sale Id 3739',3701.40,0.00,0.00,5.97,191.04,'2022-04-10 07:18:11','',''),(3510,'1','223','1',1,'Retail Sale Id 3740',2498.60,0.00,0.00,4.03,128.96,'2022-04-10 07:31:32','',''),(3511,'1','223','1',1,'Retail Sale Id 3741',1847.60,0.00,0.00,2.98,95.36,'2022-04-10 07:54:01','',''),(3512,'1','223','1',1,'Retail Sale Id 3742',35400.00,0.00,0.00,59.00,708.00,'2022-04-10 07:59:13','',''),(3513,'1','223','1',1,'Retail Sale Id 3743',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 08:01:31','',''),(3514,'1','223','1',1,'Retail Sale Id 3744',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 08:10:23','',''),(3515,'1','223','1',1,'Retail Sale Id 3745',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 08:20:59','',''),(3516,'1','223','1',1,'Retail Sale Id 3746',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 08:24:01','',''),(3517,'1','223','1',1,'Retail Sale Id 3747',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 08:29:42','',''),(3518,'1','223','1',1,'Retail Sale Id 3748',651.00,0.00,0.00,1.05,33.60,'2022-04-10 08:32:29','',''),(3519,'1','223','1',1,'Retail Sale Id 3749',2498.60,0.00,0.00,4.03,128.96,'2022-04-10 08:33:59','',''),(3520,'1','223','1',1,'Retail Sale Id 3750',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 08:35:17','',''),(3521,'1','223','1',1,'Retail Sale Id 3751',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 09:02:38','',''),(3522,'1','223','1',1,'Retail Sale Id 3752',3751.00,0.00,0.00,6.05,193.60,'2022-04-10 09:09:46','',''),(3523,'1','223','1',1,'Retail Sale Id 3753',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 09:11:37','',''),(3524,'1','223','1',1,'Retail Sale Id 3754',2498.60,0.00,0.00,4.03,128.96,'2022-04-10 09:14:01','',''),(3525,'1','223','1',1,'Retail Sale Id 3755',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 09:23:13','',''),(3526,'1','223','1',1,'Retail Sale Id 3756',6200.00,0.00,0.00,10.00,320.00,'2022-04-10 09:26:05','',''),(3527,'1','223','1',1,'Retail Sale Id 3757',60000.00,0.00,0.00,100.00,1200.00,'2022-04-10 09:28:05','',''),(3528,'1','223','1',1,'Retail Sale Id 3758',1240.00,0.00,0.00,2.00,64.00,'2022-04-10 09:34:30','',''),(3529,'1','223','1',1,'Retail Sale Id 3759',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 09:42:45','',''),(3530,'1','223','1',1,'Retail Sale Id 3760',1847.60,0.00,0.00,2.98,95.36,'2022-04-10 09:50:59','',''),(3531,'1','223','1',1,'Retail Sale Id 3761',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 09:56:10','',''),(3532,'1','223','1',1,'Retail Sale Id 3762',1847.60,0.00,0.00,2.98,95.36,'2022-04-10 09:59:01','',''),(3533,'1','223','1',1,'Retail Sale Id 3763',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 10:02:09','',''),(3534,'1','223','1',1,'Retail Sale Id 3764',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 10:22:29','',''),(3535,'1','223','1',1,'Retail Sale Id 3766',2002.60,0.00,0.00,3.23,103.36,'2022-04-10 10:30:43','',''),(3536,'1','223','1',1,'Retail Sale Id 3767',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 10:34:15','',''),(3537,'1','223','1',1,'Retail Sale Id 3768',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 10:36:40','',''),(3538,'1','223','1',1,'Retail Sale Id 3769',2002.60,0.00,0.00,3.23,103.36,'2022-04-10 10:40:01','',''),(3539,'1','223','1',1,'Retail Sale Id 3770',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 10:44:04','',''),(3540,'1','223','1',1,'Retail Sale Id 3771',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 11:08:56','',''),(3541,'1','223','1',1,'Retail Sale Id 3772',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 11:09:55','',''),(3542,'1','223','1',1,'Retail Sale Id 3773',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 11:13:06','',''),(3543,'1','223','1',1,'Retail Sale Id 3774',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 11:17:50','',''),(3544,'1','223','1',1,'Retail Sale Id 3775',700.60,0.00,0.00,1.13,36.16,'2022-04-10 11:26:35','',''),(3545,'1','223','1',1,'Retail Sale Id 3776',3751.00,0.00,0.00,6.05,193.60,'2022-04-10 11:32:12','',''),(3546,'1','223','1',1,'Retail Sale Id 3777',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 11:35:22','',''),(3547,'1','223','1',1,'Retail Sale Id 3778',7750.00,0.00,0.00,12.50,400.00,'2022-04-10 11:41:21','',''),(3548,'1','223','1',1,'Retail Sale Id 3779',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 11:45:26','',''),(3549,'1','223','1',1,'Retail Sale Id 3780',620.00,0.00,0.00,1.00,32.00,'2022-04-10 11:47:38','',''),(3550,'1','223','1',1,'Retail Sale Id 3781',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 11:48:59','',''),(3551,'1','223','1',1,'Retail Sale Id 3782',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 11:50:33','',''),(3552,'1','223','1',1,'Retail Sale Id 3783',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 11:52:03','',''),(3553,'1','223','1',1,'Retail Sale Id 3784',998.20,0.00,0.00,1.61,51.52,'2022-04-10 11:55:34','',''),(3554,'1','223','1',1,'Retail Sale Id 3785',1240.00,0.00,0.00,2.00,64.00,'2022-04-10 12:04:27','',''),(3555,'1','223','1',1,'Retail Sale Id 3786',2002.60,0.00,0.00,3.23,103.36,'2022-04-10 12:08:47','',''),(3556,'1','223','1',1,'Retail Sale Id 3788',1240.00,0.00,0.00,2.00,64.00,'2022-04-10 12:09:46','',''),(3557,'1','223','1',1,'Retail Sale Id 3789',3751.00,0.00,0.00,6.05,193.60,'2022-04-10 12:18:21','',''),(3558,'1','223','1',1,'Retail Sale Id 3790',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 12:19:42','',''),(3559,'1','223','1',1,'Retail Sale Id 3791',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 12:21:11','',''),(3560,'1','223','1',1,'Retail Sale Id 3792',1847.60,0.00,0.00,2.98,95.36,'2022-04-10 12:22:44','',''),(3561,'1','223','1',1,'Retail Sale Id 3793',2697.00,0.00,0.00,4.35,139.20,'2022-04-10 12:24:40','',''),(3562,'1','223','1',1,'Retail Sale Id 3794',1240.00,0.00,0.00,2.00,64.00,'2022-04-10 12:27:30','',''),(3563,'1','223','1',1,'Retail Sale Id 3795',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 12:29:15','',''),(3564,'1','223','1',1,'Retail Sale Id 3796',3751.00,0.00,0.00,6.05,193.60,'2022-04-10 12:32:02','',''),(3565,'1','223','1',1,'Retail Sale Id 3797',66000.00,0.00,0.00,110.00,1320.00,'2022-04-10 12:35:54','',''),(3566,'1','223','1',1,'Retail Sale Id 3798',4997.20,0.00,0.00,8.06,257.92,'2022-04-10 12:38:53','',''),(3567,'1','223','1',1,'Retail Sale Id 3799',620.00,0.00,0.00,1.00,32.00,'2022-04-10 12:42:50','',''),(3568,'1','223','1',1,'Retail Sale Id 3800',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 12:55:39','',''),(3569,'1','223','1',1,'Retail Sale Id 3801',651.00,0.00,0.00,1.05,33.60,'2022-04-10 13:09:38','',''),(3570,'1','223','1',1,'Retail Sale Id 3802',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 13:19:26','',''),(3571,'1','223','1',1,'Retail Sale Id 3803',7750.00,0.00,0.00,12.50,400.00,'2022-04-10 13:22:51','',''),(3572,'1','223','1',1,'Retail Sale Id 3804',2002.60,0.00,0.00,3.23,103.36,'2022-04-10 13:39:46','',''),(3573,'1','223','1',1,'Retail Sale Id 3805',7750.00,0.00,0.00,12.50,400.00,'2022-04-10 13:53:29','',''),(3574,'1','223','1',1,'Retail Sale Id 3806',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 13:54:24','',''),(3575,'1','223','1',1,'Retail Sale Id 3807',7750.00,0.00,0.00,12.50,400.00,'2022-04-10 14:00:37','',''),(3576,'1','223','1',1,'Retail Sale Id 3808',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 14:21:51','',''),(3577,'1','223','1',1,'Retail Sale Id 3809',1847.60,0.00,0.00,2.98,95.36,'2022-04-10 14:24:08','',''),(3578,'1','223','1',1,'Retail Sale Id 3810',6001.60,0.00,0.00,9.68,309.76,'2022-04-10 14:30:14','',''),(3579,'1','223','1',1,'Retail Sale Id 3811',620.00,0.00,0.00,1.00,32.00,'2022-04-10 14:36:59','',''),(3580,'1','223','1',1,'Retail Sale Id 3812',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 14:49:12','',''),(3581,'1','223','1',1,'Retail Sale Id 3813',3000.80,0.00,0.00,4.84,154.88,'2022-04-10 14:55:24','',''),(3582,'1','223','1',1,'Retail Sale Id 3814',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 15:03:39','',''),(3583,'1','223','1',1,'Retail Sale Id 3815',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 15:05:11','',''),(3584,'1','223','1',1,'Retail Sale Id 3816',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 15:10:38','',''),(3585,'1','223','1',1,'Retail Sale Id 3817',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 15:13:27','',''),(3586,'1','223','1',1,'Retail Sale Id 3818',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 15:15:58','',''),(3587,'1','223','1',1,'Retail Sale Id 3819',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 15:29:26','',''),(3588,'1','223','1',1,'Retail Sale Id 3820',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 15:40:57','',''),(3589,'1','223','1',1,'Retail Sale Id 3821',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 15:46:35','',''),(3590,'1','223','1',1,'Retail Sale Id 3822',3751.00,0.00,0.00,6.05,193.60,'2022-04-10 15:48:51','',''),(3591,'1','223','1',1,'Retail Sale Id 3823',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 15:49:43','',''),(3592,'1','223','1',1,'Retail Sale Id 3824',651.00,0.00,0.00,1.05,33.60,'2022-04-10 15:50:36','',''),(3593,'1','223','1',1,'Retail Sale Id 3825',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 15:51:38','',''),(3594,'1','223','1',1,'Retail Sale Id 3826',651.00,0.00,0.00,1.05,33.60,'2022-04-10 15:53:13','',''),(3595,'1','223','1',1,'Retail Sale Id 3827',2498.60,0.00,0.00,4.03,128.96,'2022-04-10 15:54:10','',''),(3596,'1','223','1',1,'Retail Sale Id 3828',620.00,0.00,0.00,1.00,32.00,'2022-04-10 15:59:12','',''),(3597,'1','223','1',1,'Retail Sale Id 3830',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 16:07:02','',''),(3598,'1','223','1',1,'Retail Sale Id 3831',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 16:07:48','',''),(3599,'1','223','1',1,'Retail Sale Id 3832',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 16:12:03','',''),(3600,'1','223','1',1,'Retail Sale Id 3833',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 16:14:40','',''),(3601,'1','223','1',1,'Retail Sale Id 3834',6200.00,0.00,0.00,10.00,320.00,'2022-04-10 16:19:39','',''),(3602,'1','223','1',1,'Retail Sale Id 3835',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 16:22:15','',''),(3603,'1','223','1',1,'Retail Sale Id 3836',1240.00,0.00,0.00,2.00,64.00,'2022-04-10 16:23:31','',''),(3604,'1','223','1',1,'Retail Sale Id 3837',998.20,0.00,0.00,1.61,51.52,'2022-04-10 16:24:45','',''),(3605,'1','223','1',1,'Retail Sale Id 3838',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 16:34:43','',''),(3606,'1','223','1',1,'Retail Sale Id 3839',1847.60,0.00,0.00,2.98,95.36,'2022-04-10 16:39:20','',''),(3607,'1','223','1',1,'Retail Sale Id 3840',1500.40,0.00,0.00,2.42,77.44,'2022-04-10 16:40:56','',''),(3608,'1','223','1',1,'Retail Sale Id 3841',502.20,0.00,0.00,0.81,25.92,'2022-04-10 16:41:21','',''),(3609,'1','223','1',1,'Retail Sale Id 3842',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 16:42:48','',''),(3610,'1','223','1',1,'Retail Sale Id 3843',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 16:43:22','',''),(3611,'1','223','1',1,'Retail Sale Id 3844',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 16:44:59','',''),(3612,'1','223','1',1,'Retail Sale Id 3845',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 16:45:53','',''),(3613,'1','223','1',1,'Retail Sale Id 3846',7750.00,0.00,0.00,12.50,400.00,'2022-04-10 16:48:48','',''),(3614,'1','223','1',1,'Retail Sale Id 3847',2498.60,0.00,0.00,4.03,128.96,'2022-04-10 16:50:25','',''),(3615,'1','223','1',1,'Retail Sale Id 3849',1847.60,0.00,0.00,2.98,95.36,'2022-04-10 16:58:14','',''),(3616,'1','223','1',1,'Retail Sale Id 3850',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 17:02:10','',''),(3617,'1','223','1',1,'Retail Sale Id 3851',1798.00,0.00,0.00,2.90,92.80,'2022-04-10 17:04:59','',''),(3618,'1','223','1',1,'Retail Sale Id 3852',998.20,0.00,0.00,1.61,51.52,'2022-04-10 17:08:12','',''),(3619,'1','223','1',1,'Retail Sale Id 3853',998.20,0.00,0.00,1.61,51.52,'2022-04-10 17:08:50','',''),(3620,'1','223','1',1,'Retail Sale Id 3854',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 17:09:49','',''),(3621,'1','223','1',1,'Retail Sale Id 3855',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 17:18:50','',''),(3622,'1','223','1',1,'Retail Sale Id 3856',2498.60,0.00,0.00,4.03,128.96,'2022-04-10 17:19:54','',''),(3623,'1','223','1',1,'Retail Sale Id 3857',998.20,0.00,0.00,1.61,51.52,'2022-04-10 17:22:31','',''),(3624,'1','223','1',1,'Retail Sale Id 3858',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 17:23:14','',''),(3625,'1','223','1',1,'Retail Sale Id 3859',1240.00,0.00,0.00,2.00,64.00,'2022-04-10 17:24:12','',''),(3626,'1','223','1',1,'Retail Sale Id 3860',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 17:24:34','',''),(3627,'1','223','1',1,'Retail Sale Id 3861',620.00,0.00,0.00,1.00,32.00,'2022-04-10 17:25:35','',''),(3628,'1','223','1',1,'Retail Sale Id 3862',1878.60,0.00,0.00,3.03,96.96,'2022-04-10 17:26:47','',''),(3629,'1','223','1',1,'Retail Sale Id 3863',998.20,0.00,0.00,1.61,51.52,'2022-04-10 17:27:31','',''),(3630,'1','223','1',1,'Retail Sale Id 3864',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 17:28:08','',''),(3631,'1','223','1',1,'Retail Sale Id 3865',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 17:29:00','',''),(3632,'1','223','1',1,'Return of Retail Sale Id 3865',0.00,1860.00,3.00,0.00,-96.00,'2022-04-10 17:30:12','',''),(3633,'1','223','1',1,'Retail Sale Id 3866',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 17:30:41','',''),(3634,'1','223','1',1,'Retail Sale Id 3867',3720.00,0.00,0.00,6.00,192.00,'2022-04-10 17:31:54','',''),(3635,'1','223','1',1,'Retail Sale Id 3868',6200.00,0.00,0.00,10.00,320.00,'2022-04-10 17:32:46','',''),(3636,'1','223','1',1,'Retail Sale Id 3869',1500.40,0.00,0.00,2.42,77.44,'2022-04-10 17:33:27','',''),(3637,'1','223','1',1,'Retail Sale Id 3870',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 17:39:18','',''),(3638,'1','223','1',1,'Retail Sale Id 3871',1500.40,0.00,0.00,2.42,77.44,'2022-04-10 17:42:03','',''),(3639,'1','223','1',1,'Retail Sale Id 3872',620.00,0.00,0.00,1.00,32.00,'2022-04-10 17:43:05','',''),(3640,'1','223','1',1,'Retail Sale Id 3873',1798.00,0.00,0.00,2.90,92.80,'2022-04-10 17:46:48','',''),(3641,'1','223','1',1,'Retail Sale Id 3874',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 17:52:00','',''),(3642,'1','223','1',1,'Retail Sale Id 3875',1847.60,0.00,0.00,2.98,95.36,'2022-04-10 17:53:09','',''),(3643,'1','223','1',1,'Retail Sale Id 3876',2498.60,0.00,0.00,4.03,128.96,'2022-04-10 17:53:40','',''),(3644,'1','223','1',1,'Retail Sale Id 3877',998.20,0.00,0.00,1.61,51.52,'2022-04-10 17:54:11','',''),(3645,'1','223','1',1,'Retail Sale Id 3878',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 17:54:44','',''),(3646,'1','223','1',1,'Retail Sale Id 3879',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 17:59:27','',''),(3647,'1','223','1',1,'Retail Sale Id 3880',1252.40,0.00,0.00,2.02,64.64,'2022-04-10 18:09:54','',''),(3648,'1','223','1',1,'Retail Sale Id 3881',216000.00,0.00,0.00,360.00,4320.00,'2022-04-10 18:11:02','',''),(3649,'1','223','1',1,'Retail Sale Id 3882',1860.00,0.00,0.00,3.00,96.00,'2022-04-10 18:12:15','',''),(3650,'1','223','1',1,'Retail Sale Id 3883',3100.00,0.00,0.00,5.00,160.00,'2022-04-10 18:15:51','',''),(3651,'1','223','1',1,'Retail Sale Id 3884',3701.40,0.00,0.00,5.97,191.04,'2022-04-10 18:21:24','',''),(3652,'1','223','1',1,'Retail Sale Id 3885',7440.00,0.00,0.00,12.00,384.00,'2022-04-10 18:22:24','',''),(3653,'1','223','1',1,'Retail Sale Id 3886',1240.00,0.00,0.00,2.00,64.00,'2022-04-10 18:23:39','',''),(3654,'1','223','1',1,'Retail Sale Id 3887',1500.40,0.00,0.00,2.42,77.44,'2022-04-10 18:26:28','',''),(3655,'1','223','1',1,'Retail Sale Id 3888',620.00,0.00,0.00,1.00,32.00,'2022-04-10 18:30:53','',''),(3656,'1','223','1',1,'Retail Sale Id 3889',1897.20,0.00,0.00,3.06,97.92,'2022-04-10 18:34:18','',''),(3657,'1','223','1',1,'Retail Sale Id 3890',7750.00,0.00,0.00,12.50,400.00,'2022-04-11 07:25:46','',''),(3658,'1','223','1',1,'Retail Sale Id 3891',7750.00,0.00,0.00,12.50,400.00,'2022-04-11 07:29:20','',''),(3659,'1','223','1',1,'Retail Sale Id 3892',5567.60,0.00,0.00,8.98,287.36,'2022-04-11 07:30:43','',''),(3660,'1','223','1',1,'Retail Sale Id 3893',4352.40,0.00,0.00,7.02,224.64,'2022-04-11 07:31:32','',''),(3661,'1','223','1',1,'Retail Sale Id 3894',620.00,0.00,0.00,1.00,32.00,'2022-04-11 07:32:01','',''),(3662,'1','223','1',1,'Retail Sale Id 3895',998.20,0.00,0.00,1.61,51.52,'2022-04-11 08:13:33','',''),(3663,'1','223','1',1,'Retail Sale Id 3896',1847.60,0.00,0.00,2.98,95.36,'2022-04-11 08:14:47','',''),(3664,'1','223','1',1,'Retail Sale Id 3897',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 08:21:18','',''),(3665,'1','223','1',1,'Retail Sale Id 3898',7750.00,0.00,0.00,12.50,400.00,'2022-04-11 08:24:10','',''),(3666,'1','223','1',1,'Retail Sale Id 3899',620.00,0.00,0.00,1.00,32.00,'2022-04-11 08:25:31','',''),(3667,'1','223','1',1,'Retail Sale Id 3900',2498.60,0.00,0.00,4.03,128.96,'2022-04-11 08:39:28','',''),(3668,'1','223','1',1,'Retail Sale Id 3901',1202.80,0.00,0.00,1.94,62.08,'2022-04-11 08:48:36','',''),(3669,'1','223','1',1,'Retail Sale Id 3902',799.80,0.00,0.00,1.29,41.28,'2022-04-11 08:50:32','',''),(3670,'1','223','1',1,'Retail Sale Id 3903',3751.00,0.00,0.00,6.05,193.60,'2022-04-11 08:56:32','',''),(3671,'1','223','1',1,'Retail Sale Id 3904',1847.60,0.00,0.00,2.98,95.36,'2022-04-11 08:59:04','',''),(3672,'1','223','1',1,'Retail Sale Id 3905',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 09:01:38','',''),(3673,'1','223','1',1,'Retail Sale Id 3906',2002.60,0.00,0.00,3.23,103.36,'2022-04-11 09:19:58','',''),(3674,'1','223','1',1,'Retail Sale Id 3907',105000.00,0.00,0.00,175.00,2100.00,'2022-04-11 09:24:55','',''),(3675,'1','223','1',1,'Retail Sale Id 3908',3751.00,0.00,0.00,6.05,193.60,'2022-04-11 09:35:05','',''),(3676,'1','223','1',1,'Retail Sale Id 3909',3100.00,0.00,0.00,5.00,160.00,'2022-04-11 09:39:56','',''),(3677,'1','223','1',1,'Retail Sale Id 3910',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 09:45:22','',''),(3678,'1','223','1',1,'Retail Sale Id 3911',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 09:46:55','',''),(3679,'1','223','1',1,'Retail Sale Id 3912',1202.80,0.00,0.00,1.94,62.08,'2022-04-11 09:50:16','',''),(3680,'1','223','1',1,'Retail Sale Id 3913',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 10:07:37','',''),(3681,'1','223','1',1,'Retail Sale Id 3914',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 10:26:41','',''),(3682,'1','223','1',1,'Retail Sale Id 3915',3000.80,0.00,0.00,4.84,154.88,'2022-04-11 10:30:41','',''),(3683,'1','223','1',1,'Retail Sale Id 3916',3100.00,0.00,0.00,5.00,160.00,'2022-04-11 10:34:43','',''),(3684,'1','223','1',1,'Retail Sale Id 3917',1202.80,0.00,0.00,1.94,62.08,'2022-04-11 10:46:46','',''),(3685,'1','223','1',1,'Retail Sale Id 3918',3100.00,0.00,0.00,5.00,160.00,'2022-04-11 11:01:40','',''),(3686,'1','223','1',1,'Retail Sale Id 3920',4352.40,0.00,0.00,7.02,224.64,'2022-04-11 11:36:24','',''),(3687,'1','223','1',1,'Retail Sale Id 3921',3720.00,0.00,0.00,6.00,192.00,'2022-04-11 11:41:07','',''),(3688,'1','223','1',1,'Retail Sale Id 3922',1550.00,0.00,0.00,2.50,80.00,'2022-04-11 11:48:13','',''),(3689,'1','223','1',1,'Retail Sale Id 3923',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 11:49:02','',''),(3690,'1','223','1',1,'Retail Sale Id 3924',3100.00,0.00,0.00,5.00,160.00,'2022-04-11 11:49:58','',''),(3691,'1','223','1',1,'Retail Sale Id 3925',1401.20,0.00,0.00,2.26,72.32,'2022-04-11 11:55:40','',''),(3692,'1','223','1',1,'Retail Sale Id 3926',3751.00,0.00,0.00,6.05,193.60,'2022-04-11 11:57:34','',''),(3693,'1','223','1',1,'Retail Sale Id 3927',1847.60,0.00,0.00,2.98,95.36,'2022-04-11 12:03:51','',''),(3694,'1','223','1',1,'Retail Sale Id 3928',3100.00,0.00,0.00,5.00,160.00,'2022-04-11 12:05:26','',''),(3695,'1','223','1',1,'Retail Sale Id 3929',1202.80,0.00,0.00,1.94,62.08,'2022-04-11 12:07:19','',''),(3696,'1','223','1',1,'Retail Sale Id 3930',1302.00,0.00,0.00,2.10,67.20,'2022-04-11 12:08:10','',''),(3697,'1','223','1',1,'Retail Sale Id 3931',1847.60,0.00,0.00,2.98,95.36,'2022-04-11 12:16:22','',''),(3698,'1','223','1',1,'Retail Sale Id 3932',3720.00,0.00,0.00,6.00,192.00,'2022-04-11 12:24:33','',''),(3699,'1','223','1',1,'Retail Sale Id 3933',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 12:31:40','',''),(3700,'1','223','1',1,'Retail Sale Id 3934',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 12:42:36','',''),(3701,'1','223','1',1,'Retail Sale Id 3935',1240.00,0.00,0.00,2.00,64.00,'2022-04-11 12:46:41','',''),(3702,'1','223','1',1,'Retail Sale Id 3936',651.00,0.00,0.00,1.05,33.60,'2022-04-11 13:02:12','',''),(3703,'1','223','1',1,'Retail Sale Id 3937',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 13:07:13','',''),(3704,'1','223','1',1,'Retail Sale Id 3938',2498.60,0.00,0.00,4.03,128.96,'2022-04-11 13:10:22','',''),(3705,'1','223','1',1,'Retail Sale Id 3939',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 13:15:57','',''),(3706,'1','223','1',1,'Retail Sale Id 3940',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 13:30:32','',''),(3707,'1','223','1',1,'Retail Sale Id 3941',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 13:33:00','',''),(3708,'1','223','1',1,'Retail Sale Id 3942',620.00,0.00,0.00,1.00,32.00,'2022-04-11 13:36:40','',''),(3709,'1','223','1',1,'Retail Sale Id 3943',651.00,0.00,0.00,1.05,33.60,'2022-04-11 13:37:25','',''),(3710,'1','223','1',1,'Retail Sale Id 3945',24800.00,0.00,0.00,40.00,1280.00,'2022-04-11 13:39:10','',''),(3711,'1','223','1',1,'Retail Sale Id 3946',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 13:39:45','',''),(3712,'1','223','1',1,'Retail Sale Id 3947',1847.60,0.00,0.00,2.98,95.36,'2022-04-11 13:49:05','',''),(3713,'1','223','1',1,'Return of Retail Sale Id 3942',0.00,620.00,1.00,0.00,-32.00,'2022-04-11 13:50:12','',''),(3714,'1','223','1',1,'Retail Sale Id 3948',601.40,0.00,0.00,0.97,31.04,'2022-04-11 13:51:04','',''),(3715,'1','223','1',1,'Retail Sale Id 3949',3999.00,0.00,0.00,6.45,206.40,'2022-04-11 13:55:20','',''),(3716,'1','223','1',1,'Retail Sale Id 3950',1240.00,0.00,0.00,2.00,64.00,'2022-04-11 13:56:00','',''),(3717,'1','223','1',1,'Retail Sale Id 3951',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 13:57:32','',''),(3718,'1','223','1',1,'Retail Sale Id 3952',1847.60,0.00,0.00,2.98,95.36,'2022-04-11 14:14:29','',''),(3719,'1','223','1',1,'Retail Sale Id 3953',2498.60,0.00,0.00,4.03,128.96,'2022-04-11 14:20:17','',''),(3720,'1','223','1',1,'Retail Sale Id 3954',4997.20,0.00,0.00,8.06,257.92,'2022-04-11 14:26:04','',''),(3721,'1','223','1',1,'Retail Sale Id 3955',620.00,0.00,0.00,1.00,32.00,'2022-04-11 14:30:59','',''),(3722,'1','223','1',1,'Retail Sale Id 3956',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 14:43:41','',''),(3723,'1','223','1',1,'Retail Sale Id 3957',998.20,0.00,0.00,1.61,51.52,'2022-04-11 14:53:02','',''),(3724,'1','223','1',1,'Retail Sale Id 3958',1240.00,0.00,0.00,2.00,64.00,'2022-04-11 14:56:55','',''),(3725,'1','223','1',1,'Retail Sale Id 3959',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 14:58:39','',''),(3726,'1','223','1',1,'Retail Sale Id 3960',3100.00,0.00,0.00,5.00,160.00,'2022-04-11 15:01:08','',''),(3727,'1','223','1',1,'Retail Sale Id 3961',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 15:06:54','',''),(3728,'1','223','1',1,'Retail Sale Id 3962',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 15:09:13','',''),(3729,'1','223','1',1,'Retail Sale Id 3963',3100.00,0.00,0.00,5.00,160.00,'2022-04-11 15:13:54','',''),(3730,'1','223','1',1,'Retail Sale Id 3964',1847.60,0.00,0.00,2.98,95.36,'2022-04-11 15:16:56','',''),(3731,'1','223','1',1,'Retail Sale Id 3965',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 15:18:39','',''),(3732,'1','223','1',1,'Retail Sale Id 3966',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 15:19:59','',''),(3733,'1','223','1',1,'Retail Sale Id 3967',3751.00,0.00,0.00,6.05,193.60,'2022-04-11 15:29:54','',''),(3734,'1','223','1',1,'Retail Sale Id 3968',1240.00,0.00,0.00,2.00,64.00,'2022-04-11 15:30:53','',''),(3735,'1','223','1',1,'Retail Sale Id 3969',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 15:45:31','',''),(3736,'1','223','1',1,'Retail Sale Id 3970',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 15:47:47','',''),(3737,'1','223','1',1,'Retail Sale Id 3971',7750.00,0.00,0.00,12.50,400.00,'2022-04-11 15:55:31','',''),(3738,'1','223','1',1,'Retail Sale Id 3972',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 16:02:27','',''),(3739,'1','223','1',1,'Retail Sale Id 3973',998.20,0.00,0.00,1.61,51.52,'2022-04-11 16:03:58','',''),(3740,'1','223','1',1,'Retail Sale Id 3974',998.20,0.00,0.00,1.61,51.52,'2022-04-11 16:04:39','',''),(3741,'1','223','1',1,'Retail Sale Id 3975',998.20,0.00,0.00,1.61,51.52,'2022-04-11 16:05:22','',''),(3742,'1','223','1',1,'Retail Sale Id 3976',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 16:08:16','',''),(3743,'1','223','1',1,'Retail Sale Id 3977',700.60,0.00,0.00,1.13,36.16,'2022-04-11 16:09:45','',''),(3744,'1','223','1',1,'Retail Sale Id 3978',1500.40,0.00,0.00,2.42,77.44,'2022-04-11 16:11:03','',''),(3745,'1','223','1',1,'Retail Sale Id 3979',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 16:12:54','',''),(3746,'1','223','1',1,'Retail Sale Id 3980',2498.60,0.00,0.00,4.03,128.96,'2022-04-11 16:13:41','',''),(3747,'1','223','1',1,'Retail Sale Id 3981',1847.60,0.00,0.00,2.98,95.36,'2022-04-11 16:17:10','',''),(3748,'1','223','1',1,'Retail Sale Id 3982',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 16:18:40','',''),(3749,'1','223','1',1,'Retail Sale Id 3983',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 16:20:18','',''),(3750,'1','223','1',1,'Retail Sale Id 3984',3503.00,0.00,0.00,5.65,180.80,'2022-04-11 16:21:16','',''),(3751,'1','223','1',1,'Retail Sale Id 3985',2498.60,0.00,0.00,4.03,128.96,'2022-04-11 16:25:34','',''),(3752,'1','223','1',1,'Retail Sale Id 3986',998.20,0.00,0.00,1.61,51.52,'2022-04-11 16:28:07','',''),(3753,'1','223','1',1,'Retail Sale Id 3987',998.20,0.00,0.00,1.61,51.52,'2022-04-11 16:29:52','',''),(3754,'1','223','1',1,'Retail Sale Id 3988',998.20,0.00,0.00,1.61,51.52,'2022-04-11 16:40:39','',''),(3755,'1','223','1',1,'Retail Sale Id 3989',2697.00,0.00,0.00,4.35,139.20,'2022-04-11 16:43:09','',''),(3756,'1','223','1',1,'Retail Sale Id 3990',1872.40,0.00,0.00,3.02,96.64,'2022-04-11 16:44:37','',''),(3757,'1','223','1',1,'Retail Sale Id 3992',1798.00,0.00,0.00,2.90,92.80,'2022-04-11 16:49:00','',''),(3758,'1','223','1',1,'Retail Sale Id 3993',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 16:50:28','',''),(3759,'1','223','1',1,'Retail Sale Id 3994',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 16:53:54','',''),(3760,'1','223','1',1,'Retail Sale Id 3995',632.40,0.00,0.00,1.02,32.64,'2022-04-11 16:57:39','',''),(3761,'1','223','1',1,'Retail Sale Id 3996',1240.00,0.00,0.00,2.00,64.00,'2022-04-11 16:58:07','',''),(3762,'1','223','1',1,'Retail Sale Id 3997',620.00,0.00,0.00,1.00,32.00,'2022-04-11 16:59:42','',''),(3763,'1','223','1',1,'Retail Sale Id 3998',651.00,0.00,0.00,1.05,33.60,'2022-04-11 17:02:46','',''),(3764,'1','223','1',1,'Retail Sale Id 3999',1798.00,0.00,0.00,2.90,92.80,'2022-04-11 17:03:43','',''),(3765,'1','223','1',1,'Retail Sale Id 4000',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 17:04:30','',''),(3766,'1','223','1',1,'Retail Sale Id 4001',1097.40,0.00,0.00,1.77,56.64,'2022-04-11 17:05:40','',''),(3767,'1','223','1',1,'Retail Sale Id 4002',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 17:10:50','',''),(3768,'1','223','1',1,'Retail Sale Id 4003',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 17:13:35','',''),(3769,'1','223','1',1,'Retail Sale Id 4004',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 17:14:28','',''),(3770,'1','223','1',1,'Retail Sale Id 4005',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 17:17:00','',''),(3771,'1','223','1',1,'Retail Sale Id 4006',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 17:19:10','',''),(3772,'1','223','1',1,'Retail Sale Id 4007',1240.00,0.00,0.00,2.00,64.00,'2022-04-11 17:20:08','',''),(3773,'1','223','1',1,'Retail Sale Id 4008',6999.80,0.00,0.00,11.29,361.28,'2022-04-11 17:24:27','',''),(3774,'1','223','1',1,'Retail Sale Id 4009',1240.00,0.00,0.00,2.00,64.00,'2022-04-11 17:24:58','',''),(3775,'1','223','1',1,'Retail Sale Id 4010',1240.00,0.00,0.00,2.00,64.00,'2022-04-11 17:25:24','',''),(3776,'1','223','1',1,'Retail Sale Id 4011',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 17:29:30','',''),(3777,'1','223','1',1,'Retail Sale Id 4012',601.40,0.00,0.00,0.97,31.04,'2022-04-11 17:31:59','',''),(3778,'1','223','1',1,'Retail Sale Id 4013',2002.60,0.00,0.00,3.23,103.36,'2022-04-11 17:33:15','',''),(3779,'1','223','1',1,'Retail Sale Id 4014',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 17:34:02','',''),(3780,'1','223','1',1,'Retail Sale Id 4015',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 17:34:53','',''),(3781,'1','223','1',1,'Retail Sale Id 4016',7750.00,0.00,0.00,12.50,400.00,'2022-04-11 17:35:19','',''),(3782,'1','223','1',1,'Retail Sale Id 4017',1302.00,0.00,0.00,2.10,67.20,'2022-04-11 17:38:38','',''),(3783,'1','223','1',1,'Retail Sale Id 4018',2498.60,0.00,0.00,4.03,128.96,'2022-04-11 17:39:27','',''),(3784,'1','223','1',1,'Retail Sale Id 4019',620.00,0.00,0.00,1.00,32.00,'2022-04-11 17:41:08','',''),(3785,'1','223','1',1,'Retail Sale Id 4020',2002.60,0.00,0.00,3.23,103.36,'2022-04-11 17:44:38','',''),(3786,'1','223','1',1,'Retail Sale Id 4021',2498.60,0.00,0.00,4.03,128.96,'2022-04-11 17:45:39','',''),(3787,'1','223','1',1,'Retail Sale Id 4024',1202.80,0.00,0.00,1.94,62.08,'2022-04-11 17:46:23','',''),(3788,'1','223','1',1,'Retail Sale Id 4025',3751.00,0.00,0.00,6.05,193.60,'2022-04-11 17:47:16','',''),(3789,'1','223','1',1,'Retail Sale Id 4028',1798.00,0.00,0.00,2.90,92.80,'2022-04-11 17:48:37','',''),(3790,'1','223','1',1,'Retail Sale Id 4029',1500.40,0.00,0.00,2.42,77.44,'2022-04-11 17:49:26','',''),(3791,'1','223','1',1,'Retail Sale Id 4030',620.00,0.00,0.00,1.00,32.00,'2022-04-11 17:54:03','',''),(3792,'1','223','1',1,'Retail Sale Id 4031',3100.00,0.00,0.00,5.00,160.00,'2022-04-11 17:56:01','',''),(3793,'1','223','1',1,'Retail Sale Id 4032',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 18:04:06','',''),(3794,'1','223','1',1,'Retail Sale Id 4033',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 18:04:42','',''),(3795,'1','223','1',1,'Retail Sale Id 4034',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 18:05:28','',''),(3796,'1','223','1',1,'Retail Sale Id 4035',6200.00,0.00,0.00,10.00,320.00,'2022-04-11 18:06:18','',''),(3797,'1','223','1',1,'Retail Sale Id 4036',2002.60,0.00,0.00,3.23,103.36,'2022-04-11 18:08:09','',''),(3798,'1','223','1',1,'Retail Sale Id 4037',5580.00,0.00,0.00,9.00,288.00,'2022-04-11 18:11:02','',''),(3799,'1','223','1',1,'Retail Sale Id 4038',1897.20,0.00,0.00,3.06,97.92,'2022-04-11 18:12:22','',''),(3800,'1','223','1',1,'Retail Sale Id 4039',651.00,0.00,0.00,1.05,33.60,'2022-04-11 18:13:32','',''),(3801,'1','223','1',1,'Retail Sale Id 4040',1500.40,0.00,0.00,2.42,77.44,'2022-04-11 18:24:30','',''),(3802,'1','223','1',1,'Retail Sale Id 4041',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 18:27:19','',''),(3803,'1','223','1',1,'Retail Sale Id 4042',3751.00,0.00,0.00,6.05,193.60,'2022-04-11 18:29:00','',''),(3804,'1','223','1',1,'Retail Sale Id 4043',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 18:29:54','',''),(3805,'1','223','1',1,'Retail Sale Id 4044',998.20,0.00,0.00,1.61,51.52,'2022-04-11 18:30:17','',''),(3806,'1','223','1',1,'Retail Sale Id 4045',3100.00,0.00,0.00,5.00,160.00,'2022-04-11 18:31:36','',''),(3807,'1','223','1',1,'Retail Sale Id 4048',6200.00,0.00,0.00,10.00,320.00,'2022-04-11 18:32:17','',''),(3808,'1','223','1',1,'Retail Sale Id 4049',1252.40,0.00,0.00,2.02,64.64,'2022-04-11 18:32:55','',''),(3809,'1','223','1',1,'Retail Sale Id 4050',1698.80,0.00,0.00,2.74,87.68,'2022-04-11 18:33:43','',''),(3810,'1','223','1',1,'Retail Sale Id 4051',1847.60,0.00,0.00,2.98,95.36,'2022-04-11 18:35:15','',''),(3811,'1','223','1',1,'Retail Sale Id 4052',1860.00,0.00,0.00,3.00,96.00,'2022-04-11 18:36:25','',''),(3812,'1','223','1',1,'Retail Sale Id 4053',3701.40,0.00,0.00,5.97,191.04,'2022-04-11 18:37:55','',''),(3813,'1','223','1',1,'Retail Sale Id 4054',502.20,0.00,0.00,0.81,25.92,'2022-04-11 18:38:45','',''),(3814,'1','223','1',1,'Return of Retail Sale Id 4048',0.00,6200.00,10.00,0.00,-320.00,'2022-04-11 18:40:46','',''),(3815,'1','223','1',1,'Retail Sale Id 4055',3751.00,0.00,0.00,6.05,193.60,'2022-04-12 08:21:11','',''),(3816,'1','223','1',1,'Retail Sale Id 4056',86800.00,0.00,0.00,140.00,4480.00,'2022-04-12 15:08:17','',''),(3817,'1','223','1',1,'Retail Sale Id 4057',51739.00,0.00,0.00,83.45,2670.40,'2022-04-12 15:09:57','',''),(3818,'1','223','1',1,'Distributed to A A RANO NIGERIA LIMITED for sales id:3',92792.28,0.00,0.00,157.81,0.00,'2022-04-13 09:24:58','',''),(3819,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,1764000.00,3000.00,0.00,0.00,'2022-04-13 09:32:13','',''),(3820,'1','223',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,3000.00,0.00,'2022-04-13 09:34:36','',''),(3821,'1','223','1',1,'Received from bridging 6',0.00,0.00,3000.00,0.00,0.00,'2022-04-13 09:34:36','',''),(3822,'1','223','1',1,'Retail Sale Id 4058',3701.40,0.00,0.00,5.97,191.04,'2022-04-13 09:38:33','',''),(3823,'1','223','1',1,'Retail Sale Id 4059',1202.80,0.00,0.00,1.94,62.08,'2022-04-13 09:40:24','',''),(3824,'1','223','1',1,'Retail Sale Id 4060',4947.60,0.00,0.00,7.98,255.36,'2022-04-13 09:43:40','',''),(3825,'1','223','1',1,'Retail Sale Id 4061',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 09:45:20','',''),(3826,'1','223','1',1,'Retail Sale Id 4062',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 09:50:29','',''),(3827,'1','223','1',1,'Retail Sale Id 4063',1847.60,0.00,0.00,2.98,95.36,'2022-04-13 09:57:08','',''),(3828,'1','223','1',1,'Retail Sale Id 4064',35400.00,0.00,0.00,59.00,708.00,'2022-04-13 10:03:57','',''),(3829,'1','223','1',1,'Retail Sale Id 4067',2480.00,0.00,0.00,4.00,128.00,'2022-04-13 10:37:55','',''),(3830,'1','223','1',1,'Retail Sale Id 4068',2480.00,0.00,0.00,4.00,128.00,'2022-04-13 10:38:43','',''),(3831,'1','223','1',1,'Retail Sale Id 4069',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 10:39:27','',''),(3832,'1','223','1',1,'Retail Sale Id 4070',3701.40,0.00,0.00,5.97,191.04,'2022-04-13 10:40:09','',''),(3833,'1','223','1',1,'Retail Sale Id 4071',620.00,0.00,0.00,1.00,32.00,'2022-04-13 10:40:47','',''),(3834,'1','223','1',1,'Retail Sale Id 4072',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 10:41:27','',''),(3835,'1','223','1',1,'Retail Sale Id 4073',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 10:53:45','',''),(3836,'1','223','1',1,'Retail Sale Id 4074',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 11:07:48','',''),(3837,'1','223','1',1,'Retail Sale Id 4075',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 11:09:13','',''),(3838,'1','223','1',1,'Retail Sale Id 4077',1897.20,0.00,0.00,3.06,97.92,'2022-04-13 11:10:33','',''),(3839,'1','223','1',1,'Retail Sale Id 4078',3751.00,0.00,0.00,6.05,193.60,'2022-04-13 11:11:44','',''),(3840,'1','223','1',1,'Retail Sale Id 4079',1798.00,0.00,0.00,2.90,92.80,'2022-04-13 11:25:29','',''),(3841,'1','223','1',1,'Retail Sale Id 4080',1847.60,0.00,0.00,2.98,95.36,'2022-04-13 11:31:05','',''),(3842,'1','223','1',1,'Retail Sale Id 4081',30000.00,0.00,0.00,50.00,600.00,'2022-04-13 11:39:57','',''),(3843,'1','223','1',1,'Retail Sale Id 4082',1897.20,0.00,0.00,3.06,97.92,'2022-04-13 12:00:31','',''),(3844,'1','223','1',1,'Retail Sale Id 4083',3100.00,0.00,0.00,5.00,160.00,'2022-04-13 12:26:32','',''),(3845,'1','223','1',1,'Retail Sale Id 4084',1897.20,0.00,0.00,3.06,97.92,'2022-04-13 12:30:52','',''),(3846,'1','223','1',1,'Retail Sale Id 4085',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 12:31:49','',''),(3847,'1','223','1',1,'Retail Sale Id 4086',60000.00,0.00,0.00,100.00,1200.00,'2022-04-13 12:35:38','',''),(3848,'1','223','1',1,'Retail Sale Id 4087',3100.00,0.00,0.00,5.00,160.00,'2022-04-13 12:43:44','',''),(3849,'1','223','1',1,'Retail Sale Id 4088',3751.00,0.00,0.00,6.05,193.60,'2022-04-13 12:57:30','',''),(3850,'1','223','1',1,'Retail Sale Id 4089',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 13:03:38','',''),(3851,'1','223','1',1,'Retail Sale Id 4090',1798.00,0.00,0.00,2.90,92.80,'2022-04-13 13:17:18','',''),(3852,'1','223','1',1,'Retail Sale Id 4091',2002.60,0.00,0.00,3.23,103.36,'2022-04-13 13:21:26','',''),(3853,'1','223','1',1,'Retail Sale Id 4092',7750.00,0.00,0.00,12.50,400.00,'2022-04-13 13:31:18','',''),(3854,'1','223','1',1,'Retail Sale Id 4093',3720.00,0.00,0.00,6.00,192.00,'2022-04-13 14:03:58','',''),(3855,'1','223','1',1,'Retail Sale Id 4094',1847.60,0.00,0.00,2.98,95.36,'2022-04-13 14:08:52','',''),(3856,'1','223','1',1,'Retail Sale Id 4095',1240.00,0.00,0.00,2.00,64.00,'2022-04-13 14:11:38','',''),(3857,'1','223','1',1,'Retail Sale Id 4096',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 14:15:13','',''),(3858,'1','223','1',1,'Retail Sale Id 4099',7502.00,0.00,0.00,12.10,387.20,'2022-04-13 14:20:55','',''),(3859,'1','223','1',1,'Retail Sale Id 4100',7750.00,0.00,0.00,12.50,400.00,'2022-04-13 14:31:23','',''),(3860,'1','223','1',1,'Retail Sale Id 4101',3000.80,0.00,0.00,4.84,154.88,'2022-04-13 14:35:43','',''),(3861,'1','223','1',1,'Return of Retail Sale Id 4101',0.00,3000.80,4.84,0.00,-154.88,'2022-04-13 14:36:08','',''),(3862,'1','223','1',1,'Retail Sale Id 4102',3100.00,0.00,0.00,5.00,160.00,'2022-04-13 14:36:28','',''),(3863,'1','223','1',1,'Retail Sale Id 4103',1202.80,0.00,0.00,1.94,62.08,'2022-04-13 14:47:12','',''),(3864,'1','223','1',1,'Retail Sale Id 4104',1302.00,0.00,0.00,2.10,67.20,'2022-04-13 14:48:21','',''),(3865,'1','223','1',1,'Retail Sale Id 4105',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 14:52:43','',''),(3866,'1','223','1',1,'Retail Sale Id 4106',1202.80,0.00,0.00,1.94,62.08,'2022-04-13 14:54:59','',''),(3867,'1','223','1',1,'Retail Sale Id 4107',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 14:56:58','',''),(3868,'1','223','1',1,'Retail Sale Id 4108',2498.60,0.00,0.00,4.03,128.96,'2022-04-13 15:03:27','',''),(3869,'1','223','1',1,'Retail Sale Id 4109',3100.00,0.00,0.00,5.00,160.00,'2022-04-13 15:10:50','',''),(3870,'1','223','1',1,'Retail Sale Id 4112',3720.00,0.00,0.00,6.00,192.00,'2022-04-13 15:15:29','',''),(3871,'1','223','1',1,'Retail Sale Id 4113',1698.80,0.00,0.00,2.74,87.68,'2022-04-13 15:18:42','',''),(3872,'1','223','1',1,'Retail Sale Id 4114',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 15:23:03','',''),(3873,'1','223','1',1,'Retail Sale Id 4115',3720.00,0.00,0.00,6.00,192.00,'2022-04-13 15:28:41','',''),(3874,'1','223','1',1,'Retail Sale Id 4116',2300.20,0.00,0.00,3.71,118.72,'2022-04-13 15:39:24','',''),(3875,'1','223','1',1,'Retail Sale Id 4117',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 15:45:20','',''),(3876,'1','223','1',1,'Retail Sale Id 4118',1500.40,0.00,0.00,2.42,77.44,'2022-04-13 16:09:49','',''),(3877,'1','223','1',1,'Retail Sale Id 4119',7750.00,0.00,0.00,12.50,400.00,'2022-04-13 16:21:02','',''),(3878,'1','223','1',1,'Retail Sale Id 4120',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 16:22:29','',''),(3879,'1','223','1',1,'Retail Sale Id 4121',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 16:23:22','',''),(3880,'1','223','1',1,'Retail Sale Id 4122',1500.40,0.00,0.00,2.42,77.44,'2022-04-13 16:24:18','',''),(3881,'1','223','1',1,'Retail Sale Id 4123',1847.60,0.00,0.00,2.98,95.36,'2022-04-13 16:38:31','',''),(3882,'1','223','1',1,'Retail Sale Id 4124',1240.00,0.00,0.00,2.00,64.00,'2022-04-13 16:39:26','',''),(3883,'1','223','1',1,'Retail Sale Id 4125',1202.80,0.00,0.00,1.94,62.08,'2022-04-13 16:40:07','',''),(3884,'1','223','1',1,'Retail Sale Id 4126',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 16:40:46','',''),(3885,'1','223','1',1,'Retail Sale Id 4127',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 16:47:25','',''),(3886,'1','223','1',1,'Retail Sale Id 4128',3100.00,0.00,0.00,5.00,160.00,'2022-04-13 16:47:52','',''),(3887,'1','223','1',1,'Retail Sale Id 4130',998.20,0.00,0.00,1.61,51.52,'2022-04-13 16:50:32','',''),(3888,'1','223','1',1,'Retail Sale Id 4131',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 16:52:33','',''),(3889,'1','223','1',1,'Retail Sale Id 4132',633660.00,0.00,0.00,1056.10,12673.20,'2022-04-13 16:57:39','',''),(3890,'1','223','1',1,'Retail Sale Id 4133',1847.60,0.00,0.00,2.98,95.36,'2022-04-13 17:00:03','',''),(3891,'1','223','1',1,'Retail Sale Id 4134',7750.00,0.00,0.00,12.50,400.00,'2022-04-13 17:02:32','',''),(3892,'1','223','1',1,'Retail Sale Id 4135',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 17:03:36','',''),(3893,'1','223','1',1,'Retail Sale Id 4136',3000.80,0.00,0.00,4.84,154.88,'2022-04-13 17:07:52','',''),(3894,'1','223','1',1,'Retail Sale Id 4137',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 17:19:33','',''),(3895,'1','223','1',1,'Retail Sale Id 4138',2002.60,0.00,0.00,3.23,103.36,'2022-04-13 17:25:51','',''),(3896,'1','223','1',1,'Retail Sale Id 4139',1897.20,0.00,0.00,3.06,97.92,'2022-04-13 17:26:30','',''),(3897,'1','223','1',1,'Retail Sale Id 4140',1872.40,0.00,0.00,3.02,96.64,'2022-04-13 17:29:11','',''),(3898,'1','223','1',1,'Retail Sale Id 4141',1202.80,0.00,0.00,1.94,62.08,'2022-04-13 17:30:07','',''),(3899,'1','223','1',1,'Retail Sale Id 4142',1798.00,0.00,0.00,2.90,92.80,'2022-04-13 17:30:44','',''),(3900,'1','223','1',1,'Retail Sale Id 4143',7750.00,0.00,0.00,12.50,400.00,'2022-04-13 17:31:46','',''),(3901,'1','223','1',1,'Retail Sale Id 4144',1798.00,0.00,0.00,2.90,92.80,'2022-04-13 17:33:05','',''),(3902,'1','223','1',1,'Retail Sale Id 4145',3503.00,0.00,0.00,5.65,180.80,'2022-04-13 17:33:47','',''),(3903,'1','223','1',1,'Retail Sale Id 4146',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 17:34:30','',''),(3904,'1','223','1',1,'Retail Sale Id 4147',2498.60,0.00,0.00,4.03,128.96,'2022-04-13 17:35:23','',''),(3905,'1','223','1',1,'Retail Sale Id 4148',3100.00,0.00,0.00,5.00,160.00,'2022-04-13 17:35:59','',''),(3906,'1','223','1',1,'Retail Sale Id 4149',620.00,0.00,0.00,1.00,32.00,'2022-04-13 17:40:41','',''),(3907,'1','223','1',1,'Retail Sale Id 4150',3100.00,0.00,0.00,5.00,160.00,'2022-04-13 17:42:46','',''),(3908,'1','223','1',1,'Retail Sale Id 4151',1847.60,0.00,0.00,2.98,95.36,'2022-04-13 17:44:13','',''),(3909,'1','223','1',1,'Retail Sale Id 4152',1202.80,0.00,0.00,1.94,62.08,'2022-04-13 17:44:55','',''),(3910,'1','223','1',1,'Retail Sale Id 4153',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 17:47:42','',''),(3911,'1','223','1',1,'Retail Sale Id 4154',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 17:48:31','',''),(3912,'1','223','1',1,'Retail Sale Id 4155',1500.40,0.00,0.00,2.42,77.44,'2022-04-13 17:49:47','',''),(3913,'1','223','1',1,'Retail Sale Id 4156',2498.60,0.00,0.00,4.03,128.96,'2022-04-13 17:54:12','',''),(3914,'1','223','1',1,'Retail Sale Id 4157',7750.00,0.00,0.00,12.50,400.00,'2022-04-13 17:56:05','',''),(3915,'1','223','1',1,'Retail Sale Id 4158',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 17:57:08','',''),(3916,'1','223','1',1,'Retail Sale Id 4159',1847.60,0.00,0.00,2.98,95.36,'2022-04-13 18:03:51','',''),(3917,'1','223','1',1,'Retail Sale Id 4160',1798.00,0.00,0.00,2.90,92.80,'2022-04-13 18:04:52','',''),(3918,'1','223','1',1,'Retail Sale Id 4162',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 18:10:07','',''),(3919,'1','223','1',1,'Retail Sale Id 4163',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 18:10:33','',''),(3920,'1','223','1',1,'Retail Sale Id 4164',6200.00,0.00,0.00,10.00,320.00,'2022-04-13 18:17:01','',''),(3921,'1','223','1',1,'Retail Sale Id 4165',1860.00,0.00,0.00,3.00,96.00,'2022-04-13 18:27:53','',''),(3922,'1','223','1',1,'Return of Retail Sale Id 4165',0.00,1860.00,3.00,0.00,-96.00,'2022-04-13 18:28:48','',''),(3923,'1','223','1',1,'Retail Sale Id 4166',1798.00,0.00,0.00,2.90,92.80,'2022-04-13 18:29:11','',''),(3924,'1','223','1',1,'Retail Sale Id 4167',3100.00,0.00,0.00,5.00,160.00,'2022-04-13 18:32:26','',''),(3925,'1','223','1',1,'Retail Sale Id 4168',3701.40,0.00,0.00,5.97,191.04,'2022-04-13 18:35:33','',''),(3926,'1','223','1',1,'Retail Sale Id 4169',1252.40,0.00,0.00,2.02,64.64,'2022-04-13 18:36:53','',''),(3927,'1','223','1',1,'Return of Retail Sale Id 4086',0.00,60000.00,100.00,0.00,-1200.00,'2022-04-13 20:31:43','',''),(3928,'1','223','1',1,'Retail Sale Id 4171',41178.00,0.00,0.00,68.63,823.56,'2022-04-13 20:40:05','',''),(3929,'1','223','1',1,'Retail Sale Id 4172',18841.80,0.00,0.00,30.39,972.48,'2022-04-13 20:42:46','',''),(3930,'1','223','1',1,'Retail Sale Id 4173',1897.20,0.00,0.00,3.06,97.92,'2022-04-14 07:33:07','',''),(3931,'1','223','1',1,'Retail Sale Id 4174',6820.00,0.00,0.00,11.00,352.00,'2022-04-14 08:02:36','',''),(3932,'1','223','1',1,'Retail Sale Id 4175',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 08:04:00','',''),(3933,'1','223','1',1,'Retail Sale Id 4176',1500.40,0.00,0.00,2.42,77.44,'2022-04-14 08:09:56','',''),(3934,'1','223','1',1,'Retail Sale Id 4177',4340.00,0.00,0.00,7.00,224.00,'2022-04-14 08:12:17','',''),(3935,'1','223','1',1,'Return of Retail Sale Id 4177',0.00,4340.00,7.00,0.00,-224.00,'2022-04-14 08:15:22','',''),(3936,'1','223','1',1,'Retail Sale Id 4178',6820.00,0.00,0.00,11.00,352.00,'2022-04-14 08:16:31','',''),(3937,'1','223','1',1,'Retail Sale Id 4179',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 08:18:49','',''),(3938,'1','223','1',1,'Retail Sale Id 4180',1897.20,0.00,0.00,3.06,97.92,'2022-04-14 08:21:05','',''),(3939,'1','223','1',1,'Retail Sale Id 4181',90000.00,0.00,0.00,150.00,1800.00,'2022-04-14 08:28:52','',''),(3940,'1','223','1',1,'Retail Sale Id 4182',7750.00,0.00,0.00,12.50,400.00,'2022-04-14 08:31:10','',''),(3941,'1','223','1',1,'Retail Sale Id 4183',1847.60,0.00,0.00,2.98,95.36,'2022-04-14 08:40:18','',''),(3942,'1','223','1',1,'Retail Sale Id 4184',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 08:46:35','',''),(3943,'1','223','1',1,'Retail Sale Id 4185',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 08:56:51','',''),(3944,'1','223','1',1,'Retail Sale Id 4186',1798.00,0.00,0.00,2.90,92.80,'2022-04-14 09:04:00','',''),(3945,'1','223','1',1,'Retail Sale Id 4187',1847.60,0.00,0.00,2.98,95.36,'2022-04-14 09:05:12','',''),(3946,'1','223','1',1,'Retail Sale Id 4188',1897.20,0.00,0.00,3.06,97.92,'2022-04-14 09:11:47','',''),(3947,'1','223','1',1,'Retail Sale Id 4189',2480.00,0.00,0.00,4.00,128.00,'2022-04-14 09:22:57','',''),(3948,'1','223','1',1,'Retail Sale Id 4190',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 09:24:24','',''),(3949,'1','223','1',1,'Retail Sale Id 4191',651.00,0.00,0.00,1.05,33.60,'2022-04-14 09:35:09','',''),(3950,'1','223','1',1,'Retail Sale Id 4192',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 09:40:41','',''),(3951,'1','223','1',1,'Retail Sale Id 4193',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 09:42:37','',''),(3952,'1','223','1',1,'Retail Sale Id 4194',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 09:43:58','',''),(3953,'1','223','1',1,'Retail Sale Id 4195',3751.00,0.00,0.00,6.05,193.60,'2022-04-14 09:45:59','',''),(3954,'1','223','1',1,'Retail Sale Id 4196',1897.20,0.00,0.00,3.06,97.92,'2022-04-14 09:47:13','',''),(3955,'1','223','1',1,'Retail Sale Id 4197',1698.80,0.00,0.00,2.74,87.68,'2022-04-14 09:55:34','',''),(3956,'1','223','1',1,'Retail Sale Id 4198',620.00,0.00,0.00,1.00,32.00,'2022-04-14 10:01:25','',''),(3957,'1','223','1',1,'Retail Sale Id 4199',1240.00,0.00,0.00,2.00,64.00,'2022-04-14 10:07:44','',''),(3958,'1','223','1',1,'Retail Sale Id 4200',3100.00,0.00,0.00,5.00,160.00,'2022-04-14 10:14:57','',''),(3959,'1','223','1',1,'Retail Sale Id 4201',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 10:16:08','',''),(3960,'1','223','1',1,'Retail Sale Id 4202',7750.00,0.00,0.00,12.50,400.00,'2022-04-14 10:52:55','',''),(3961,'1','223','1',1,'Retail Sale Id 4203',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 11:06:44','',''),(3962,'1','223','1',1,'Retail Sale Id 4204',1240.00,0.00,0.00,2.00,64.00,'2022-04-14 11:10:10','',''),(3963,'1','223','1',1,'Retail Sale Id 4205',2480.00,0.00,0.00,4.00,128.00,'2022-04-14 11:41:59','',''),(3964,'1','223','1',1,'Retail Sale Id 4206',30000.00,0.00,0.00,50.00,600.00,'2022-04-14 11:45:18','',''),(3965,'1','223','1',1,'Retail Sale Id 4207',2480.00,0.00,0.00,4.00,128.00,'2022-04-14 11:57:46','',''),(3966,'1','223','1',1,'Retail Sale Id 4208',1798.00,0.00,0.00,2.90,92.80,'2022-04-14 11:59:10','',''),(3967,'1','223','1',1,'Retail Sale Id 4209',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 12:11:44','',''),(3968,'1','223','1',1,'Retail Sale Id 4210',998.20,0.00,0.00,1.61,51.52,'2022-04-14 12:19:29','',''),(3969,'1','223','1',1,'Retail Sale Id 4211',1847.60,0.00,0.00,2.98,95.36,'2022-04-14 12:40:01','',''),(3970,'1','223','1',1,'Retail Sale Id 4212',60000.00,0.00,0.00,100.00,1200.00,'2022-04-14 12:41:40','',''),(3971,'1','223','1',1,'Retail Sale Id 4213',3751.00,0.00,0.00,6.05,193.60,'2022-04-14 12:46:17','',''),(3972,'1','223','1',1,'Retail Sale Id 4214',7750.00,0.00,0.00,12.50,400.00,'2022-04-14 12:48:23','',''),(3973,'1','223','1',1,'Retail Sale Id 4216',3751.00,0.00,0.00,6.05,193.60,'2022-04-14 12:50:22','',''),(3974,'1','223','1',1,'Retail Sale Id 4217',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 12:52:43','',''),(3975,'1','223','1',1,'Retail Sale Id 4218',3720.00,0.00,0.00,6.00,192.00,'2022-04-14 12:55:12','',''),(3976,'1','223','1',1,'Retail Sale Id 4219',7750.00,0.00,0.00,12.50,400.00,'2022-04-14 13:10:01','',''),(3977,'1','223','1',1,'Retail Sale Id 4220',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 13:16:03','',''),(3978,'1','223','1',1,'Retail Sale Id 4221',2480.00,0.00,0.00,4.00,128.00,'2022-04-14 13:26:03','',''),(3979,'1','223','1',1,'Retail Sale Id 4222',2480.00,0.00,0.00,4.00,128.00,'2022-04-14 14:06:10','',''),(3980,'1','223','1',1,'Retail Sale Id 4223',700.60,0.00,0.00,1.13,36.16,'2022-04-14 14:14:19','',''),(3981,'1','223','1',1,'Retail Sale Id 4224',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 14:23:33','',''),(3982,'1','223','1',1,'Retail Sale Id 4225',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 14:24:01','',''),(3983,'1','223','1',1,'Retail Sale Id 4226',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 14:24:30','',''),(3984,'1','223','1',1,'Retail Sale Id 4227',1240.00,0.00,0.00,2.00,64.00,'2022-04-14 14:34:39','',''),(3985,'1','223','1',1,'Retail Sale Id 4228',1240.00,0.00,0.00,2.00,64.00,'2022-04-14 15:09:08','',''),(3986,'1','223','1',1,'Retail Sale Id 4229',1897.20,0.00,0.00,3.06,97.92,'2022-04-14 15:10:39','',''),(3987,'1','223','1',1,'Retail Sale Id 4230',3100.00,0.00,0.00,5.00,160.00,'2022-04-14 15:15:04','',''),(3988,'1','223','1',1,'Return of Retail Sale Id 4230',0.00,3100.00,5.00,0.00,-160.00,'2022-04-14 15:17:22','',''),(3989,'1','223','1',1,'Retail Sale Id 4231',3720.00,0.00,0.00,6.00,192.00,'2022-04-14 15:17:51','',''),(3990,'1','223','1',1,'Retail Sale Id 4232',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 15:24:28','',''),(3991,'1','223','1',1,'Retail Sale Id 4233',2480.00,0.00,0.00,4.00,128.00,'2022-04-14 15:29:56','',''),(3992,'1','223','1',1,'Retail Sale Id 4234',4997.20,0.00,0.00,8.06,257.92,'2022-04-14 15:30:31','',''),(3993,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,1728720.00,2940.00,0.00,0.00,'2022-04-14 15:38:37','',''),(3994,'1','223','1',1,'Retail Sale Id 4235',998.20,0.00,0.00,1.61,51.52,'2022-04-14 15:40:43','',''),(3995,'1','223','1',1,'Retail Sale Id 4237',3100.00,0.00,0.00,5.00,160.00,'2022-04-14 15:41:22','',''),(3996,'1','223',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,2940.00,0.00,'2022-04-14 15:41:29','',''),(3997,'1','223','1',1,'Received from bridging 7',0.00,0.00,2940.00,0.00,0.00,'2022-04-14 15:41:29','',''),(3998,'1','223','1',1,'Retail Sale Id 4239',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 15:42:29','',''),(3999,'1','223','1',1,'Retail Sale Id 4240',2002.60,0.00,0.00,3.23,103.36,'2022-04-14 15:48:05','',''),(4000,'1','223','1',1,'Retail Sale Id 4241',1240.00,0.00,0.00,2.00,64.00,'2022-04-14 16:06:25','',''),(4001,'1','223','1',1,'Retail Sale Id 4242',1302.00,0.00,0.00,2.10,67.20,'2022-04-14 16:24:35','',''),(4002,'1','223','1',1,'Retail Sale Id 4243',1897.20,0.00,0.00,3.06,97.92,'2022-04-14 16:29:42','',''),(4003,'1','223','1',1,'Retail Sale Id 4244',3100.00,0.00,0.00,5.00,160.00,'2022-04-14 16:34:49','',''),(4004,'1','223','1',1,'Retail Sale Id 4245',2002.60,0.00,0.00,3.23,103.36,'2022-04-14 16:40:10','',''),(4005,'1','223','1',1,'Retail Sale Id 4246',1847.60,0.00,0.00,2.98,95.36,'2022-04-14 16:42:48','',''),(4006,'1','223','1',1,'Retail Sale Id 4247',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 16:47:25','',''),(4007,'1','223','1',1,'Retail Sale Id 4248',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 16:54:02','',''),(4008,'1','223','1',1,'Retail Sale Id 4249',1897.20,0.00,0.00,3.06,97.92,'2022-04-14 17:01:07','',''),(4009,'1','223','1',1,'Retail Sale Id 4250',1240.00,0.00,0.00,2.00,64.00,'2022-04-14 17:08:54','',''),(4010,'1','223','1',1,'Retail Sale Id 4251',7750.00,0.00,0.00,12.50,400.00,'2022-04-14 17:11:38','',''),(4011,'1','223','1',1,'Retail Sale Id 4252',1847.60,0.00,0.00,2.98,95.36,'2022-04-14 17:13:17','',''),(4012,'1','223','1',1,'Retail Sale Id 4253',7750.00,0.00,0.00,12.50,400.00,'2022-04-14 17:15:24','',''),(4013,'1','223','1',1,'Retail Sale Id 4254',1240.00,0.00,0.00,2.00,64.00,'2022-04-14 17:16:35','',''),(4014,'1','223','1',1,'Retail Sale Id 4255',3100.00,0.00,0.00,5.00,160.00,'2022-04-14 17:17:39','',''),(4015,'1','223','1',1,'Retail Sale Id 4256',7750.00,0.00,0.00,12.50,400.00,'2022-04-14 17:18:30','',''),(4016,'1','223','1',1,'Retail Sale Id 4257',1240.00,0.00,0.00,2.00,64.00,'2022-04-14 17:19:22','',''),(4017,'1','223','1',1,'Retail Sale Id 4258',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 17:19:48','',''),(4018,'1','223','1',1,'Retail Sale Id 4259',3751.00,0.00,0.00,6.05,193.60,'2022-04-14 17:24:18','',''),(4019,'1','223','1',1,'Retail Sale Id 4260',1202.80,0.00,0.00,1.94,62.08,'2022-04-14 17:29:21','',''),(4020,'1','223','1',1,'Retail Sale Id 4261',1847.60,0.00,0.00,2.98,95.36,'2022-04-14 17:30:28','',''),(4021,'1','223','1',1,'Retail Sale Id 4262',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 17:34:47','',''),(4022,'1','223','1',1,'Retail Sale Id 4263',1847.60,0.00,0.00,2.98,95.36,'2022-04-14 17:36:28','',''),(4023,'1','223','1',1,'Retail Sale Id 4265',1897.20,0.00,0.00,3.06,97.92,'2022-04-14 17:37:29','',''),(4024,'1','223','1',1,'Retail Sale Id 4266',3100.00,0.00,0.00,5.00,160.00,'2022-04-14 17:43:18','',''),(4025,'1','223','1',1,'Retail Sale Id 4267',700.60,0.00,0.00,1.13,36.16,'2022-04-14 17:44:15','',''),(4026,'1','223','1',1,'Retail Sale Id 4268',998.20,0.00,0.00,1.61,51.52,'2022-04-14 17:45:49','',''),(4027,'1','223','1',1,'Retail Sale Id 4270',1847.60,0.00,0.00,2.98,95.36,'2022-04-14 17:48:20','',''),(4028,'1','223','1',1,'Retail Sale Id 4271',1897.20,0.00,0.00,3.06,97.92,'2022-04-14 17:49:14','',''),(4029,'1','223','1',1,'Retail Sale Id 4272',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 17:51:12','',''),(4030,'1','223','1',1,'Retail Sale Id 4273',4997.20,0.00,0.00,8.06,257.92,'2022-04-14 17:52:52','',''),(4031,'1','223','1',1,'Retail Sale Id 4274',1847.60,0.00,0.00,2.98,95.36,'2022-04-14 17:55:31','',''),(4032,'1','223','1',1,'Retail Sale Id 4275',1240.00,0.00,0.00,2.00,64.00,'2022-04-14 18:03:17','',''),(4033,'1','223','1',1,'Retail Sale Id 4276',1860.00,0.00,0.00,3.00,96.00,'2022-04-14 18:03:55','',''),(4034,'1','223','1',1,'Retail Sale Id 4277',1252.40,0.00,0.00,2.02,64.64,'2022-04-14 18:04:53','',''),(4035,'1','223','1',1,'Retail Sale Id 4278',998.20,0.00,0.00,1.61,51.52,'2022-04-14 18:22:28','',''),(4036,'1','223','1',1,'Retail Sale Id 4279',1698.80,0.00,0.00,2.74,87.68,'2022-04-14 18:23:43','',''),(4037,'1','223','1',1,'Retail Sale Id 4280',799.80,0.00,0.00,1.29,41.28,'2022-04-14 18:24:07','',''),(4038,'1','223','1',1,'Retail Sale Id 4281',998.20,0.00,0.00,1.61,51.52,'2022-04-14 18:24:38','',''),(4039,'1','223','1',1,'Retail Sale Id 4282',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 07:13:01','',''),(4040,'1','223','1',1,'Retail Sale Id 4283',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 07:39:06','',''),(4041,'1','223','1',1,'Retail Sale Id 4284',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 07:58:51','',''),(4042,'1','223','1',1,'Retail Sale Id 4285',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 08:06:05','',''),(4043,'1','223','1',1,'Retail Sale Id 4287',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 08:09:54','',''),(4044,'1','223','1',1,'Retail Sale Id 4288',3751.00,0.00,0.00,6.05,193.60,'2022-04-15 08:16:31','',''),(4045,'1','223','1',1,'Retail Sale Id 4289',651.00,0.00,0.00,1.05,33.60,'2022-04-15 08:18:55','',''),(4046,'1','223','1',1,'Retail Sale Id 4290',1500.40,0.00,0.00,2.42,77.44,'2022-04-15 08:20:23','',''),(4047,'1','223','1',1,'Retail Sale Id 4291',2480.00,0.00,0.00,4.00,128.00,'2022-04-15 08:31:43','',''),(4048,'1','223','1',1,'Retail Sale Id 4292',7750.00,0.00,0.00,12.50,400.00,'2022-04-15 08:41:22','',''),(4049,'1','223','1',1,'Retail Sale Id 4293',3720.00,0.00,0.00,6.00,192.00,'2022-04-15 08:44:57','',''),(4050,'1','223','1',1,'Retail Sale Id 4294',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 08:51:15','',''),(4051,'1','223','1',1,'Retail Sale Id 4295',6851.00,0.00,0.00,11.05,353.60,'2022-04-15 08:52:19','',''),(4052,'1','223','1',1,'Retail Sale Id 4296',3000.80,0.00,0.00,4.84,154.88,'2022-04-15 08:53:15','',''),(4053,'1','223','1',1,'Retail Sale Id 4297',620.00,0.00,0.00,1.00,32.00,'2022-04-15 08:57:51','',''),(4054,'1','223','1',1,'Retail Sale Id 4298',97500.00,0.00,0.00,162.50,1950.00,'2022-04-15 08:59:02','',''),(4055,'1','223','1',1,'Retail Sale Id 4299',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 09:05:29','',''),(4056,'1','223','1',1,'Retail Sale Id 4300',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 09:10:23','',''),(4057,'1','223','1',1,'Retail Sale Id 4301',1847.60,0.00,0.00,2.98,95.36,'2022-04-15 09:11:25','',''),(4058,'1','223','1',1,'Retail Sale Id 4302',1500.40,0.00,0.00,2.42,77.44,'2022-04-15 09:22:48','',''),(4059,'1','223','1',1,'Retail Sale Id 4303',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 09:31:12','',''),(4060,'1','223','1',1,'Retail Sale Id 4304',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 09:49:23','',''),(4061,'1','223','1',1,'Retail Sale Id 4305',4358.60,0.00,0.00,7.03,224.96,'2022-04-15 09:50:41','',''),(4062,'1','223','1',1,'Retail Sale Id 4306',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 09:52:25','',''),(4063,'1','223','1',1,'Retail Sale Id 4307',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 09:53:26','',''),(4064,'1','223','1',1,'Retail Sale Id 4308',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 09:59:59','',''),(4065,'1','223','1',1,'Retail Sale Id 4309',7750.00,0.00,0.00,12.50,400.00,'2022-04-15 10:14:30','',''),(4066,'1','223','1',1,'Retail Sale Id 4310',3751.00,0.00,0.00,6.05,193.60,'2022-04-15 10:21:12','',''),(4067,'1','223','1',1,'Retail Sale Id 4311',1798.00,0.00,0.00,2.90,92.80,'2022-04-15 10:28:54','',''),(4068,'1','223','1',1,'Retail Sale Id 4313',4501.20,0.00,0.00,7.26,232.32,'2022-04-15 10:36:44','',''),(4069,'1','223','1',1,'Retail Sale Id 4314',3751.00,0.00,0.00,6.05,193.60,'2022-04-15 10:37:57','',''),(4070,'1','223','1',1,'Retail Sale Id 4315',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 10:51:20','',''),(4071,'1','223','1',1,'Retail Sale Id 4316',6200.00,0.00,0.00,10.00,320.00,'2022-04-15 10:55:07','',''),(4072,'1','223','1',1,'Retail Sale Id 4317',1847.60,0.00,0.00,2.98,95.36,'2022-04-15 10:57:50','',''),(4073,'1','223','1',1,'Retail Sale Id 4318',2498.60,0.00,0.00,4.03,128.96,'2022-04-15 11:25:20','',''),(4074,'1','223','1',1,'Retail Sale Id 4319',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 11:36:53','',''),(4075,'1','223','1',1,'Retail Sale Id 4321',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 11:49:36','',''),(4076,'1','223','1',1,'Retail Sale Id 4322',2480.00,0.00,0.00,4.00,128.00,'2022-04-15 12:32:18','',''),(4077,'1','223','1',1,'Retail Sale Id 4323',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 12:41:58','',''),(4078,'1','223','1',1,'Retail Sale Id 4324',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 12:50:02','',''),(4079,'1','223','1',1,'Retail Sale Id 4325',2480.00,0.00,0.00,4.00,128.00,'2022-04-15 13:01:55','',''),(4080,'1','223','1',1,'Retail Sale Id 4326',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 13:06:38','',''),(4081,'1','223','1',1,'Retail Sale Id 4327',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 13:39:51','',''),(4082,'1','223','1',1,'Retail Sale Id 4328',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 13:51:42','',''),(4083,'1','223','1',1,'Retail Sale Id 4329',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 13:57:47','',''),(4084,'1','223','1',1,'Retail Sale Id 4330',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 14:02:56','',''),(4085,'1','223','1',1,'Retail Sale Id 4331',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 14:03:55','',''),(4086,'1','223','1',1,'Retail Sale Id 4332',2002.60,0.00,0.00,3.23,103.36,'2022-04-15 14:07:27','',''),(4087,'1','223','1',1,'Retail Sale Id 4333',1500.40,0.00,0.00,2.42,77.44,'2022-04-15 14:23:17','',''),(4088,'1','223','1',1,'Retail Sale Id 4334',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 14:25:00','',''),(4089,'1','223','1',1,'Retail Sale Id 4335',998.20,0.00,0.00,1.61,51.52,'2022-04-15 14:37:53','',''),(4090,'1','223','1',1,'Retail Sale Id 4336',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 14:44:05','',''),(4091,'1','223','1',1,'Retail Sale Id 4337',3720.00,0.00,0.00,6.00,192.00,'2022-04-15 14:46:04','',''),(4092,'1','223','1',1,'Retail Sale Id 4338',2498.60,0.00,0.00,4.03,128.96,'2022-04-15 14:57:16','',''),(4093,'1','223','1',1,'Retail Sale Id 4339',4997.20,0.00,0.00,8.06,257.92,'2022-04-15 14:59:09','',''),(4094,'1','223','1',1,'Retail Sale Id 4340',998.20,0.00,0.00,1.61,51.52,'2022-04-15 15:00:17','',''),(4095,'1','223','1',1,'Retail Sale Id 4341',3720.00,0.00,0.00,6.00,192.00,'2022-04-15 15:03:02','',''),(4096,'1','223','1',1,'Retail Sale Id 4342',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 15:04:45','',''),(4097,'1','223','1',1,'Retail Sale Id 4343',998.20,0.00,0.00,1.61,51.52,'2022-04-15 15:05:53','',''),(4098,'1','223','1',1,'Retail Sale Id 4344',620.00,0.00,0.00,1.00,32.00,'2022-04-15 15:08:41','',''),(4099,'1','223','1',1,'Retail Sale Id 4345',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 15:09:54','',''),(4100,'1','223','1',1,'Retail Sale Id 4346',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 15:27:17','',''),(4101,'1','223','1',1,'Retail Sale Id 4347',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 15:34:54','',''),(4102,'1','223','1',1,'Retail Sale Id 4349',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 15:36:18','',''),(4103,'1','223','1',1,'Retail Sale Id 4350',3720.00,0.00,0.00,6.00,192.00,'2022-04-15 15:40:09','',''),(4104,'1','223','1',1,'Retail Sale Id 4351',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 15:41:28','',''),(4105,'1','223','1',1,'Retail Sale Id 4352',502.20,0.00,0.00,0.81,25.92,'2022-04-15 15:44:31','',''),(4106,'1','223','1',1,'Retail Sale Id 4353',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 15:54:09','',''),(4107,'1','223','1',1,'Retail Sale Id 4354',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 15:55:25','',''),(4108,'1','223','1',1,'Retail Sale Id 4355',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 16:02:43','',''),(4109,'1','223','1',1,'Retail Sale Id 4356',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 16:06:34','',''),(4110,'1','223','1',1,'Retail Sale Id 4357',2480.00,0.00,0.00,4.00,128.00,'2022-04-15 16:09:32','',''),(4111,'1','223','1',1,'Retail Sale Id 4358',1909.60,0.00,0.00,3.08,98.56,'2022-04-15 16:10:21','',''),(4112,'1','223','1',1,'Retail Sale Id 4360',1500.40,0.00,0.00,2.42,77.44,'2022-04-15 16:11:05','',''),(4113,'1','223','1',1,'Return of Retail Sale Id 4355',0.00,3100.00,5.00,0.00,-160.00,'2022-04-15 16:11:35','',''),(4114,'1','223','1',1,'Retail Sale Id 4361',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 16:12:40','',''),(4115,'1','223','1',1,'Retail Sale Id 4362',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 16:15:55','',''),(4116,'1','223','1',1,'Retail Sale Id 4363',2498.60,0.00,0.00,4.03,128.96,'2022-04-15 16:17:25','',''),(4117,'1','223','1',1,'Retail Sale Id 4364',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 16:18:50','',''),(4118,'1','223','1',1,'Retail Sale Id 4365',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 16:20:20','',''),(4119,'1','223','1',1,'Retail Sale Id 4366',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 16:23:44','',''),(4120,'1','223','1',1,'Retail Sale Id 4367',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 16:33:58','',''),(4121,'1','223','1',1,'Retail Sale Id 4368',2498.60,0.00,0.00,4.03,128.96,'2022-04-15 16:37:43','',''),(4122,'1','223','1',1,'Retail Sale Id 4369',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 16:41:36','',''),(4123,'1','223','1',1,'Retail Sale Id 4370',2002.60,0.00,0.00,3.23,103.36,'2022-04-15 16:46:08','',''),(4124,'1','223','1',1,'Retail Sale Id 4371',3751.00,0.00,0.00,6.05,193.60,'2022-04-15 16:48:49','',''),(4125,'1','223','1',1,'Retail Sale Id 4372',998.20,0.00,0.00,1.61,51.52,'2022-04-15 16:49:55','',''),(4126,'1','223','1',1,'Retail Sale Id 4373',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 16:51:33','',''),(4127,'1','223','1',1,'Retail Sale Id 4374',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 16:53:37','',''),(4128,'1','223','1',1,'Retail Sale Id 4375',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 16:54:12','',''),(4129,'1','223','1',1,'Retail Sale Id 4376',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 16:54:59','',''),(4130,'1','223','1',1,'Retail Sale Id 4377',3000.80,0.00,0.00,4.84,154.88,'2022-04-15 16:55:49','',''),(4131,'1','223','1',1,'Retail Sale Id 4378',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 16:56:18','',''),(4132,'1','223','1',1,'Retail Sale Id 4379',3720.00,0.00,0.00,6.00,192.00,'2022-04-15 16:57:39','',''),(4133,'1','223','1',1,'Retail Sale Id 4380',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 16:58:35','',''),(4134,'1','223','1',1,'Retail Sale Id 4381',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 17:04:23','',''),(4135,'1','223','1',1,'Retail Sale Id 4382',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 17:07:26','',''),(4136,'1','223','1',1,'Retail Sale Id 4383',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 17:08:11','',''),(4137,'1','223','1',1,'Retail Sale Id 4384',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 17:11:58','',''),(4138,'1','223','1',1,'Retail Sale Id 4388',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 17:13:49','',''),(4139,'1','223','1',1,'Retail Sale Id 4389',4352.40,0.00,0.00,7.02,224.64,'2022-04-15 17:16:57','',''),(4140,'1','223','1',1,'Retail Sale Id 4390',3720.00,0.00,0.00,6.00,192.00,'2022-04-15 17:18:26','',''),(4141,'1','223','1',1,'Retail Sale Id 4391',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 17:19:39','',''),(4142,'1','223','1',1,'Retail Sale Id 4393',1798.00,0.00,0.00,2.90,92.80,'2022-04-15 17:20:14','',''),(4143,'1','223','1',1,'Retail Sale Id 4394',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 17:21:29','',''),(4144,'1','223','1',1,'Retail Sale Id 4396',1798.00,0.00,0.00,2.90,92.80,'2022-04-15 17:21:55','',''),(4145,'1','223','1',1,'Retail Sale Id 4397',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 17:22:23','',''),(4146,'1','223','1',1,'Retail Sale Id 4398',2498.60,0.00,0.00,4.03,128.96,'2022-04-15 17:23:06','',''),(4147,'1','223','1',1,'Retail Sale Id 4399',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 17:23:38','',''),(4148,'1','223','1',1,'Retail Sale Id 4400',7750.00,0.00,0.00,12.50,400.00,'2022-04-15 17:24:10','',''),(4149,'1','223','1',1,'Retail Sale Id 4401',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 17:25:10','',''),(4150,'1','223','1',1,'Retail Sale Id 4402',1147.00,0.00,0.00,1.85,59.20,'2022-04-15 17:26:44','',''),(4151,'1','223','1',1,'Retail Sale Id 4403',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 17:29:06','',''),(4152,'1','223','1',1,'Retail Sale Id 4404',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 17:29:59','',''),(4153,'1','223','1',1,'Retail Sale Id 4405',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 17:31:43','',''),(4154,'1','223','1',1,'Retail Sale Id 4407',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 17:34:49','',''),(4155,'1','223','1',1,'Retail Sale Id 4408',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 17:35:24','',''),(4156,'1','223','1',1,'Retail Sale Id 4409',7750.00,0.00,0.00,12.50,400.00,'2022-04-15 17:36:17','',''),(4157,'1','223','1',1,'Retail Sale Id 4411',2002.60,0.00,0.00,3.23,103.36,'2022-04-15 17:37:04','',''),(4158,'1','223','1',1,'Retail Sale Id 4412',998.20,0.00,0.00,1.61,51.52,'2022-04-15 17:38:28','',''),(4159,'1','223','1',1,'Retail Sale Id 4414',620.00,0.00,0.00,1.00,32.00,'2022-04-15 17:41:25','',''),(4160,'1','223','1',1,'Retail Sale Id 4416',2300.20,0.00,0.00,3.71,118.72,'2022-04-15 17:42:41','',''),(4161,'1','223','1',1,'Retail Sale Id 4417',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 17:49:31','',''),(4162,'1','223','1',1,'Retail Sale Id 4418',1202.80,0.00,0.00,1.94,62.08,'2022-04-15 17:55:15','',''),(4163,'1','223','1',1,'Retail Sale Id 4419',601.40,0.00,0.00,0.97,31.04,'2022-04-15 17:55:58','',''),(4164,'1','223','1',1,'Retail Sale Id 4420',998.20,0.00,0.00,1.61,51.52,'2022-04-15 18:01:50','',''),(4165,'1','223','1',1,'Retail Sale Id 4422',1302.00,0.00,0.00,2.10,67.20,'2022-04-15 18:02:55','',''),(4166,'1','223','1',1,'Retail Sale Id 4423',1202.80,0.00,0.00,1.94,62.08,'2022-04-15 18:03:21','',''),(4167,'1','223','1',1,'Retail Sale Id 4424',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 18:04:10','',''),(4168,'1','223','1',1,'Retail Sale Id 4425',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 18:04:51','',''),(4169,'1','223','1',1,'Retail Sale Id 4426',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 18:05:28','',''),(4170,'1','223','1',1,'Retail Sale Id 4427',36000.00,0.00,0.00,60.00,720.00,'2022-04-15 18:07:00','',''),(4171,'1','223','1',1,'Retail Sale Id 4429',2498.60,0.00,0.00,4.03,128.96,'2022-04-15 18:11:06','',''),(4172,'1','223','1',1,'Retail Sale Id 4430',1240.00,0.00,0.00,2.00,64.00,'2022-04-15 18:12:10','',''),(4173,'1','223','1',1,'Retail Sale Id 4432',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 18:12:41','',''),(4174,'1','223','1',1,'Retail Sale Id 4434',3100.00,0.00,0.00,5.00,160.00,'2022-04-15 18:13:25','',''),(4175,'1','223','1',1,'Retail Sale Id 4435',1500.40,0.00,0.00,2.42,77.44,'2022-04-15 18:16:16','',''),(4176,'1','223','1',1,'Retail Sale Id 4436',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 18:17:16','',''),(4177,'1','223','1',1,'Retail Sale Id 4438',1798.00,0.00,0.00,2.90,92.80,'2022-04-15 18:18:06','',''),(4178,'1','223','1',1,'Retail Sale Id 4439',2498.60,0.00,0.00,4.03,128.96,'2022-04-15 18:18:42','',''),(4179,'1','223','1',1,'Retail Sale Id 4440',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 18:19:34','',''),(4180,'1','223','1',1,'Retail Sale Id 4441',1798.00,0.00,0.00,2.90,92.80,'2022-04-15 18:21:09','',''),(4181,'1','223','1',1,'Retail Sale Id 4442',3701.40,0.00,0.00,5.97,191.04,'2022-04-15 18:21:53','',''),(4182,'1','223','1',1,'Retail Sale Id 4443',66000.00,0.00,0.00,110.00,1320.00,'2022-04-15 18:23:27','',''),(4183,'1','223','1',1,'Retail Sale Id 4445',1097.40,0.00,0.00,1.77,56.64,'2022-04-15 18:24:40','',''),(4184,'1','223','1',1,'Retail Sale Id 4446',1897.20,0.00,0.00,3.06,97.92,'2022-04-15 18:25:26','',''),(4185,'1','223','1',1,'Retail Sale Id 4447',2480.00,0.00,0.00,4.00,128.00,'2022-04-15 18:35:57','',''),(4186,'1','223','1',1,'Retail Sale Id 4448',1302.00,0.00,0.00,2.10,67.20,'2022-04-15 18:37:31','',''),(4187,'1','223','1',1,'Retail Sale Id 4449',1252.40,0.00,0.00,2.02,64.64,'2022-04-15 18:47:07','',''),(4188,'1','223','1',1,'Retail Sale Id 4450',2002.60,0.00,0.00,3.23,103.36,'2022-04-15 18:48:18','',''),(4189,'1','223','1',1,'Retail Sale Id 4451',601.40,0.00,0.00,0.97,31.04,'2022-04-15 18:49:37','',''),(4190,'1','223','1',1,'Retail Sale Id 4452',1860.00,0.00,0.00,3.00,96.00,'2022-04-15 18:50:38','',''),(4191,'1','223','1',1,'Return of Retail Sale Id 4446',0.00,1897.20,3.06,0.00,-97.92,'2022-04-15 19:16:22','',''),(4192,'1','223','1',1,'Retail Sale Id 4453',1531.40,0.00,0.00,2.47,79.04,'2022-04-15 19:17:14','',''),(4193,'1','223','1',1,'Retail Sale Id 4454',502.20,0.00,0.00,0.81,25.92,'2022-04-15 19:22:35','',''),(4194,'1','223','1',1,'Return of Retail Sale Id 4454',0.00,502.20,0.81,0.00,-25.92,'2022-04-15 19:35:25','',''),(4195,'1','223','1',1,'Retail Sale Id 4455',2597.80,0.00,0.00,4.19,134.08,'2022-04-16 07:33:11','',''),(4196,'1','223','1',1,'Retail Sale Id 4456',1897.20,0.00,0.00,3.06,97.92,'2022-04-16 07:36:16','',''),(4197,'1','223','1',1,'Retail Sale Id 4457',700.60,0.00,0.00,1.13,36.16,'2022-04-16 07:37:08','',''),(4198,'1','223','1',1,'Retail Sale Id 4458',1897.20,0.00,0.00,3.06,97.92,'2022-04-16 07:37:57','',''),(4199,'1','223','1',1,'Retail Sale Id 4459',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 07:38:52','',''),(4200,'1','223','1',1,'Retail Sale Id 4460',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 07:46:45','',''),(4201,'1','223','1',1,'Retail Sale Id 4461',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 08:03:40','',''),(4202,'1','223','1',1,'Retail Sale Id 4462',1240.00,0.00,0.00,2.00,64.00,'2022-04-16 08:05:42','',''),(4203,'1','223','1',1,'Retail Sale Id 4463',4997.20,0.00,0.00,8.06,257.92,'2022-04-16 08:14:12','',''),(4204,'1','223','1',1,'Retail Sale Id 4464',1897.20,0.00,0.00,3.06,97.92,'2022-04-16 08:15:33','',''),(4205,'1','223','1',1,'Retail Sale Id 4465',1097.40,0.00,0.00,1.77,56.64,'2022-04-16 08:19:28','',''),(4206,'1','223','1',1,'Retail Sale Id 4466',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 08:31:24','',''),(4207,'1','223','1',1,'Retail Sale Id 4467',2002.60,0.00,0.00,3.23,103.36,'2022-04-16 08:35:20','',''),(4208,'1','223','1',1,'Retail Sale Id 4468',799.80,0.00,0.00,1.29,41.28,'2022-04-16 08:45:39','',''),(4209,'1','223','1',1,'Retail Sale Id 4469',5580.00,0.00,0.00,9.00,288.00,'2022-04-16 08:47:30','',''),(4210,'1','223','1',1,'Retail Sale Id 4470',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 08:53:35','',''),(4211,'1','223','1',1,'Retail Sale Id 4471',1302.00,0.00,0.00,2.10,67.20,'2022-04-16 08:58:07','',''),(4212,'1','223','1',1,'Retail Sale Id 4472',1897.20,0.00,0.00,3.06,97.92,'2022-04-16 08:59:46','',''),(4213,'1','223','1',1,'Retail Sale Id 4473',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 09:03:07','',''),(4214,'1','223','1',1,'Retail Sale Id 4474',1302.00,0.00,0.00,2.10,67.20,'2022-04-16 09:04:31','',''),(4215,'1','223','1',1,'Retail Sale Id 4475',2498.60,0.00,0.00,4.03,128.96,'2022-04-16 09:11:30','',''),(4216,'1','223','1',1,'Retail Sale Id 4476',82500.00,0.00,0.00,137.50,1650.00,'2022-04-16 09:17:48','',''),(4217,'1','223','1',1,'Retail Sale Id 4477',1240.00,0.00,0.00,2.00,64.00,'2022-04-16 09:18:58','',''),(4218,'1','223','1',1,'Retail Sale Id 4478',2498.60,0.00,0.00,4.03,128.96,'2022-04-16 09:20:12','',''),(4219,'1','223','1',1,'Retail Sale Id 4479',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 09:22:32','',''),(4220,'1','223','1',1,'Retail Sale Id 4480',2002.60,0.00,0.00,3.23,103.36,'2022-04-16 09:27:30','',''),(4221,'1','223','1',1,'Retail Sale Id 4481',1202.80,0.00,0.00,1.94,62.08,'2022-04-16 09:28:48','',''),(4222,'1','223','1',1,'Retail Sale Id 4482',3000.80,0.00,0.00,4.84,154.88,'2022-04-16 09:29:59','',''),(4223,'1','223','1',1,'Retail Sale Id 4483',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 09:36:22','',''),(4224,'1','223','1',1,'Retail Sale Id 4484',1240.00,0.00,0.00,2.00,64.00,'2022-04-16 09:45:16','',''),(4225,'1','223','1',1,'Retail Sale Id 4485',3720.00,0.00,0.00,6.00,192.00,'2022-04-16 09:51:24','',''),(4226,'1','223','1',1,'Retail Sale Id 4486',2002.60,0.00,0.00,3.23,103.36,'2022-04-16 10:00:54','',''),(4227,'1','223','1',1,'Retail Sale Id 4487',1798.00,0.00,0.00,2.90,92.80,'2022-04-16 10:02:49','',''),(4228,'1','223','1',1,'Retail Sale Id 4488',7750.00,0.00,0.00,12.50,400.00,'2022-04-16 10:10:22','',''),(4229,'1','223','1',1,'Retail Sale Id 4489',1302.00,0.00,0.00,2.10,67.20,'2022-04-16 10:12:11','',''),(4230,'1','223','1',1,'Retail Sale Id 4490',3701.40,0.00,0.00,5.97,191.04,'2022-04-16 10:29:58','',''),(4231,'1','223','1',1,'Retail Sale Id 4491',899.00,0.00,0.00,1.45,46.40,'2022-04-16 10:31:51','',''),(4232,'1','223','1',1,'Retail Sale Id 4492',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 10:33:40','',''),(4233,'1','223','1',1,'Retail Sale Id 4493',2480.00,0.00,0.00,4.00,128.00,'2022-04-16 10:35:12','',''),(4234,'1','223','1',1,'Retail Sale Id 4496',7750.00,0.00,0.00,12.50,400.00,'2022-04-16 10:43:56','',''),(4235,'1','223','1',1,'Retail Sale Id 4497',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 10:45:18','',''),(4236,'1','223','1',1,'Retail Sale Id 4498',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 10:45:50','',''),(4237,'1','223','1',1,'Retail Sale Id 4499',1698.80,0.00,0.00,2.74,87.68,'2022-04-16 10:47:09','',''),(4238,'1','223','1',1,'Retail Sale Id 4500',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 10:47:49','',''),(4239,'1','223','1',1,'Retail Sale Id 4501',799.80,0.00,0.00,1.29,41.28,'2022-04-16 10:58:58','',''),(4240,'1','223','1',1,'Retail Sale Id 4502',36000.00,0.00,0.00,60.00,720.00,'2022-04-16 10:59:59','',''),(4241,'1','223','1',1,'Retail Sale Id 4503',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 11:02:28','',''),(4242,'1','223','1',1,'Retail Sale Id 4504',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 11:14:44','',''),(4243,'1','223','1',1,'Retail Sale Id 4505',2498.60,0.00,0.00,4.03,128.96,'2022-04-16 11:16:10','',''),(4244,'1','223','1',1,'Retail Sale Id 4506',3000.80,0.00,0.00,4.84,154.88,'2022-04-16 12:09:48','',''),(4245,'1','223','1',1,'Retail Sale Id 4507',2201.00,0.00,0.00,3.55,113.60,'2022-04-16 12:16:23','',''),(4246,'1','223','1',1,'Retail Sale Id 4508',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 12:36:55','',''),(4247,'1','223','1',1,'Retail Sale Id 4509',1897.20,0.00,0.00,3.06,97.92,'2022-04-16 12:49:15','',''),(4248,'1','223','1',1,'Retail Sale Id 4510',3720.00,0.00,0.00,6.00,192.00,'2022-04-16 13:05:57','',''),(4249,'1','223','1',1,'Retail Sale Id 4511',1847.60,0.00,0.00,2.98,95.36,'2022-04-16 13:08:55','',''),(4250,'1','223','1',1,'Retail Sale Id 4512',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 13:09:52','',''),(4251,'1','223','1',1,'Retail Sale Id 4513',998.20,0.00,0.00,1.61,51.52,'2022-04-16 13:11:06','',''),(4252,'1','223','1',1,'Retail Sale Id 4514',2498.60,0.00,0.00,4.03,128.96,'2022-04-16 13:37:55','',''),(4253,'1','223','1',1,'Retail Sale Id 4515',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 13:43:53','',''),(4254,'1','223','1',1,'Retail Sale Id 4516',1798.00,0.00,0.00,2.90,92.80,'2022-04-16 13:45:04','',''),(4255,'1','223','1',1,'Retail Sale Id 4517',1847.60,0.00,0.00,2.98,95.36,'2022-04-16 13:58:12','',''),(4256,'1','223','1',1,'Retail Sale Id 4518',2002.60,0.00,0.00,3.23,103.36,'2022-04-16 14:05:00','',''),(4257,'1','223','1',1,'Retail Sale Id 4519',2480.00,0.00,0.00,4.00,128.00,'2022-04-16 14:05:59','',''),(4258,'1','223','1',1,'Retail Sale Id 4520',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 14:14:15','',''),(4259,'1','223','1',1,'Retail Sale Id 4521',998.20,0.00,0.00,1.61,51.52,'2022-04-16 14:22:45','',''),(4260,'1','223','1',1,'Retail Sale Id 4522',1798.00,0.00,0.00,2.90,92.80,'2022-04-16 14:23:57','',''),(4261,'1','223','1',1,'Retail Sale Id 4523',998.20,0.00,0.00,1.61,51.52,'2022-04-16 14:25:24','',''),(4262,'1','223','1',1,'Retail Sale Id 4526',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 14:37:26','',''),(4263,'1','223','1',1,'Retail Sale Id 4528',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 14:37:56','',''),(4264,'1','223','1',1,'Retail Sale Id 4529',1798.00,0.00,0.00,2.90,92.80,'2022-04-16 14:39:17','',''),(4265,'1','223','1',1,'Retail Sale Id 4530',1202.80,0.00,0.00,1.94,62.08,'2022-04-16 14:40:48','',''),(4266,'1','223','1',1,'Retail Sale Id 4531',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 14:42:11','',''),(4267,'1','223','1',1,'Retail Sale Id 4532',2498.60,0.00,0.00,4.03,128.96,'2022-04-16 14:44:08','',''),(4268,'1','223','1',1,'Retail Sale Id 4534',3701.40,0.00,0.00,5.97,191.04,'2022-04-16 14:54:05','',''),(4269,'1','223','1',1,'Retail Sale Id 4535',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 14:57:36','',''),(4270,'1','223','1',1,'Retail Sale Id 4541',2498.60,0.00,0.00,4.03,128.96,'2022-04-16 15:07:22','',''),(4271,'1','223','1',1,'Retail Sale Id 4542',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 15:23:25','',''),(4272,'1','223','1',1,'Retail Sale Id 4543',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 15:26:23','',''),(4273,'1','223','1',1,'Retail Sale Id 4544',1240.00,0.00,0.00,2.00,64.00,'2022-04-16 15:28:26','',''),(4274,'1','223','1',1,'Retail Sale Id 4545',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 15:29:35','',''),(4275,'1','223','1',1,'Retail Sale Id 4546',1798.00,0.00,0.00,2.90,92.80,'2022-04-16 15:34:22','',''),(4276,'1','223','1',1,'Retail Sale Id 4547',3751.00,0.00,0.00,6.05,193.60,'2022-04-16 15:35:27','',''),(4277,'1','223','1',1,'Retail Sale Id 4548',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 15:36:26','',''),(4278,'1','223','1',1,'Retail Sale Id 4549',2002.60,0.00,0.00,3.23,103.36,'2022-04-16 15:38:37','',''),(4279,'1','223','1',1,'Retail Sale Id 4550',998.20,0.00,0.00,1.61,51.52,'2022-04-16 15:57:57','',''),(4280,'1','223','1',1,'Retail Sale Id 4551',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 16:06:21','',''),(4281,'1','223','1',1,'Retail Sale Id 4552',1897.20,0.00,0.00,3.06,97.92,'2022-04-16 16:07:53','',''),(4282,'1','223','1',1,'Retail Sale Id 4553',2498.60,0.00,0.00,4.03,128.96,'2022-04-16 16:08:51','',''),(4283,'1','223','1',1,'Retail Sale Id 4554',3751.00,0.00,0.00,6.05,193.60,'2022-04-16 16:10:15','',''),(4284,'1','223','1',1,'Retail Sale Id 4555',502.20,0.00,0.00,0.81,25.92,'2022-04-16 16:11:16','',''),(4285,'1','223','1',1,'Retail Sale Id 4556',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 16:17:26','',''),(4286,'1','223','1',1,'Retail Sale Id 4557',1897.20,0.00,0.00,3.06,97.92,'2022-04-16 16:17:59','',''),(4287,'1','223','1',1,'Retail Sale Id 4558',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 16:21:37','',''),(4288,'1','223','1',1,'Retail Sale Id 4559',7750.00,0.00,0.00,12.50,400.00,'2022-04-16 16:31:02','',''),(4289,'1','223','1',1,'Retail Sale Id 4560',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 16:35:23','',''),(4290,'1','223','1',1,'Retail Sale Id 4561',1500.40,0.00,0.00,2.42,77.44,'2022-04-16 16:37:16','',''),(4291,'1','223','1',1,'Retail Sale Id 4563',3720.00,0.00,0.00,6.00,192.00,'2022-04-16 16:39:58','',''),(4292,'1','223','1',1,'Retail Sale Id 4564',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 16:41:50','',''),(4293,'1','223','1',1,'Retail Sale Id 4565',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 16:44:48','',''),(4294,'1','223','1',1,'Retail Sale Id 4566',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 16:46:33','',''),(4295,'1','223','1',1,'Retail Sale Id 4567',1240.00,0.00,0.00,2.00,64.00,'2022-04-16 16:47:34','',''),(4296,'1','223','1',1,'Retail Sale Id 4568',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 16:49:13','',''),(4297,'1','223','1',1,'Retail Sale Id 4569',1500.40,0.00,0.00,2.42,77.44,'2022-04-16 16:51:06','',''),(4298,'1','223','1',1,'Retail Sale Id 4570',1240.00,0.00,0.00,2.00,64.00,'2022-04-16 16:52:20','',''),(4299,'1','223','1',1,'Retail Sale Id 4571',3720.00,0.00,0.00,6.00,192.00,'2022-04-16 17:05:36','',''),(4300,'1','223','1',1,'Retail Sale Id 4572',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 17:06:54','',''),(4301,'1','223','1',1,'Retail Sale Id 4573',1240.00,0.00,0.00,2.00,64.00,'2022-04-16 17:08:37','',''),(4302,'1','223','1',1,'Retail Sale Id 4574',1240.00,0.00,0.00,2.00,64.00,'2022-04-16 17:12:04','',''),(4303,'1','223','1',1,'Retail Sale Id 4575',1240.00,0.00,0.00,2.00,64.00,'2022-04-16 17:15:48','',''),(4304,'1','223','1',1,'Retail Sale Id 4576',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 17:19:34','',''),(4305,'1','223','1',1,'Retail Sale Id 4577',1240.00,0.00,0.00,2.00,64.00,'2022-04-16 17:21:00','',''),(4306,'1','223','1',1,'Retail Sale Id 4578',1500.40,0.00,0.00,2.42,77.44,'2022-04-16 17:21:48','',''),(4307,'1','223','1',1,'Retail Sale Id 4579',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 17:23:09','',''),(4308,'1','223','1',1,'Retail Sale Id 4581',620.00,0.00,0.00,1.00,32.00,'2022-04-16 17:23:40','',''),(4309,'1','223','1',1,'Retail Sale Id 4583',998.20,0.00,0.00,1.61,51.52,'2022-04-16 17:24:15','',''),(4310,'1','223','1',1,'Retail Sale Id 4584',1860.00,0.00,0.00,3.00,96.00,'2022-04-16 17:30:25','',''),(4311,'1','223','1',1,'Retail Sale Id 4585',4501.20,0.00,0.00,7.26,232.32,'2022-04-16 17:34:20','',''),(4312,'1','223','1',1,'Retail Sale Id 4586',7750.00,0.00,0.00,12.50,400.00,'2022-04-16 17:36:52','',''),(4313,'1','223','1',1,'Retail Sale Id 4587',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 17:38:14','',''),(4314,'1','223','1',1,'Retail Sale Id 4588',1302.00,0.00,0.00,2.10,67.20,'2022-04-16 17:39:15','',''),(4315,'1','223','1',1,'Retail Sale Id 4589',1302.00,0.00,0.00,2.10,67.20,'2022-04-16 17:43:40','',''),(4316,'1','223','1',1,'Retail Sale Id 4590',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 17:44:20','',''),(4317,'1','223','1',1,'Retail Sale Id 4591',1798.00,0.00,0.00,2.90,92.80,'2022-04-16 17:45:04','',''),(4318,'1','223','1',1,'Retail Sale Id 4592',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 17:47:51','',''),(4319,'1','223','1',1,'Retail Sale Id 4593',1897.20,0.00,0.00,3.06,97.92,'2022-04-16 17:55:57','',''),(4320,'1','223','1',1,'Retail Sale Id 4594',1897.20,0.00,0.00,3.06,97.92,'2022-04-16 17:59:31','',''),(4321,'1','223','1',1,'Retail Sale Id 4595',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 18:04:25','',''),(4322,'1','223','1',1,'Retail Sale Id 4596',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 18:08:50','',''),(4323,'1','223','1',1,'Retail Sale Id 4598',61200.00,0.00,0.00,102.00,1224.00,'2022-04-16 18:13:05','',''),(4324,'1','223','1',1,'Retail Sale Id 4599',30000.00,0.00,0.00,50.00,600.00,'2022-04-16 18:14:06','',''),(4325,'1','223','1',1,'Retail Sale Id 4600',3701.40,0.00,0.00,5.97,191.04,'2022-04-16 18:16:25','',''),(4326,'1','223','1',1,'Retail Sale Id 4601',3000.80,0.00,0.00,4.84,154.88,'2022-04-16 18:18:12','',''),(4327,'1','223','1',1,'Retail Sale Id 4602',1798.00,0.00,0.00,2.90,92.80,'2022-04-16 18:22:46','',''),(4328,'1','223','1',1,'Retail Sale Id 4603',1252.40,0.00,0.00,2.02,64.64,'2022-04-16 18:27:06','',''),(4329,'1','223','1',1,'Retail Sale Id 4604',620.00,0.00,0.00,1.00,32.00,'2022-04-16 18:29:37','',''),(4330,'1','223','1',1,'Retail Sale Id 4606',3751.00,0.00,0.00,6.05,193.60,'2022-04-16 18:34:50','',''),(4331,'1','223','1',1,'Retail Sale Id 4607',1897.20,0.00,0.00,3.06,97.92,'2022-04-16 18:35:29','',''),(4332,'1','223','1',1,'Retail Sale Id 4608',3100.00,0.00,0.00,5.00,160.00,'2022-04-16 18:36:56','',''),(4333,'1','223','1',1,'Retail Sale Id 4609',620.00,0.00,0.00,1.00,32.00,'2022-04-16 18:38:42','',''),(4334,'1','223','1',1,'Return of Retail Sale Id 4608',0.00,3100.00,5.00,0.00,-160.00,'2022-04-16 18:40:40','',''),(4335,'1','223','1',1,'Return of Retail Sale Id 4566',0.00,1860.00,3.00,0.00,-96.00,'2022-04-16 18:44:25','',''),(4336,'1','223','1',1,'Retail Sale Id 4610',551.80,0.00,0.00,0.89,28.48,'2022-04-16 20:14:21','',''),(4337,'1','223','1',1,'Retail Sale Id 4611',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 07:28:39','',''),(4338,'1','223','1',1,'Retail Sale Id 4612',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 07:35:13','',''),(4339,'1','223','1',1,'Retail Sale Id 4613',3720.00,0.00,0.00,6.00,192.00,'2022-04-17 07:56:39','',''),(4340,'1','223','1',1,'Retail Sale Id 4614',7750.00,0.00,0.00,12.50,400.00,'2022-04-17 07:59:18','',''),(4341,'1','223','1',1,'Retail Sale Id 4615',2002.60,0.00,0.00,3.23,103.36,'2022-04-17 08:10:10','',''),(4342,'1','223','1',1,'Retail Sale Id 4616',620.00,0.00,0.00,1.00,32.00,'2022-04-17 08:15:17','',''),(4343,'1','223','1',1,'Retail Sale Id 4617',4960.00,0.00,0.00,8.00,256.00,'2022-04-17 08:22:48','',''),(4344,'1','223','1',1,'Retail Sale Id 4618',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 08:37:10','',''),(4345,'1','223','1',1,'Retail Sale Id 4619',1500.40,0.00,0.00,2.42,77.44,'2022-04-17 08:38:49','',''),(4346,'1','223','1',1,'Retail Sale Id 4620',3720.00,0.00,0.00,6.00,192.00,'2022-04-17 08:40:02','',''),(4347,'1','223','1',1,'Retail Sale Id 4621',2480.00,0.00,0.00,4.00,128.00,'2022-04-17 08:42:19','',''),(4348,'1','223','1',1,'Retail Sale Id 4622',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 08:43:44','',''),(4349,'1','223','1',1,'Retail Sale Id 4623',3000.80,0.00,0.00,4.84,154.88,'2022-04-17 08:46:45','',''),(4350,'1','223','1',1,'Retail Sale Id 4624',3720.00,0.00,0.00,6.00,192.00,'2022-04-17 08:47:44','',''),(4351,'1','223','1',1,'Retail Sale Id 4625',1202.80,0.00,0.00,1.94,62.08,'2022-04-17 08:49:34','',''),(4352,'1','223','1',1,'Retail Sale Id 4626',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 09:10:53','',''),(4353,'1','223','1',1,'Retail Sale Id 4627',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 09:13:18','',''),(4354,'1','223','1',1,'Retail Sale Id 4628',1847.60,0.00,0.00,2.98,95.36,'2022-04-17 09:14:52','',''),(4355,'1','223','1',1,'Retail Sale Id 4629',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 09:16:01','',''),(4356,'1','223','1',1,'Retail Sale Id 4630',998.20,0.00,0.00,1.61,51.52,'2022-04-17 09:17:28','',''),(4357,'1','223','1',1,'Retail Sale Id 4631',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 09:25:54','',''),(4358,'1','223','1',1,'Retail Sale Id 4632',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 09:40:53','',''),(4359,'1','223','1',1,'Retail Sale Id 4633',1500.40,0.00,0.00,2.42,77.44,'2022-04-17 09:45:11','',''),(4360,'1','223','1',1,'Retail Sale Id 4634',7750.00,0.00,0.00,12.50,400.00,'2022-04-17 09:47:26','',''),(4361,'1','223','1',1,'Retail Sale Id 4635',1798.00,0.00,0.00,2.90,92.80,'2022-04-17 09:51:57','',''),(4362,'1','223','1',1,'Retail Sale Id 4636',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 09:55:22','',''),(4363,'1','223','1',1,'Retail Sale Id 4637',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 09:56:20','',''),(4364,'1','223','1',1,'Retail Sale Id 4638',1202.80,0.00,0.00,1.94,62.08,'2022-04-17 10:11:29','',''),(4365,'1','223','1',1,'Retail Sale Id 4640',620.00,0.00,0.00,1.00,32.00,'2022-04-17 10:30:53','',''),(4366,'1','223','1',1,'Retail Sale Id 4641',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 10:32:06','',''),(4367,'1','223','1',1,'Retail Sale Id 4642',620.00,0.00,0.00,1.00,32.00,'2022-04-17 10:34:36','',''),(4368,'1','223','1',1,'Retail Sale Id 4643',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 11:03:27','',''),(4369,'1','223','1',1,'Retail Sale Id 4644',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 11:04:51','',''),(4370,'1','223','1',1,'Retail Sale Id 4645',7750.00,0.00,0.00,12.50,400.00,'2022-04-17 11:07:15','',''),(4371,'1','223','1',1,'Retail Sale Id 4646',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 11:13:54','',''),(4372,'1','223','1',1,'Retail Sale Id 4647',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 11:17:12','',''),(4373,'1','223','1',1,'Retail Sale Id 4648',2498.60,0.00,0.00,4.03,128.96,'2022-04-17 11:18:34','',''),(4374,'1','223','1',1,'Retail Sale Id 4649',700.60,0.00,0.00,1.13,36.16,'2022-04-17 11:28:24','',''),(4375,'1','223','1',1,'Retail Sale Id 4650',620.00,0.00,0.00,1.00,32.00,'2022-04-17 11:30:33','',''),(4376,'1','223','1',1,'Retail Sale Id 4651',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 11:31:44','',''),(4377,'1','223','1',1,'Retail Sale Id 4652',1202.80,0.00,0.00,1.94,62.08,'2022-04-17 11:35:01','',''),(4378,'1','223','1',1,'Retail Sale Id 4653',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 11:49:08','',''),(4379,'1','223','1',1,'Retail Sale Id 4654',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 11:50:24','',''),(4380,'1','223','1',1,'Retail Sale Id 4655',3751.00,0.00,0.00,6.05,193.60,'2022-04-17 12:03:36','',''),(4381,'1','223','1',1,'Retail Sale Id 4656',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 12:12:25','',''),(4382,'1','223','1',1,'Retail Sale Id 4657',2002.60,0.00,0.00,3.23,103.36,'2022-04-17 12:17:16','',''),(4383,'1','223','1',1,'Retail Sale Id 4658',651.00,0.00,0.00,1.05,33.60,'2022-04-17 12:47:01','',''),(4384,'1','223','1',1,'Retail Sale Id 4659',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 12:50:15','',''),(4385,'1','223','1',1,'Retail Sale Id 4660',700.60,0.00,0.00,1.13,36.16,'2022-04-17 12:51:50','',''),(4386,'1','223','1',1,'Retail Sale Id 4661',4960.00,0.00,0.00,8.00,256.00,'2022-04-17 12:53:32','',''),(4387,'1','223','1',1,'Retail Sale Id 4662',799.80,0.00,0.00,1.29,41.28,'2022-04-17 13:05:56','',''),(4388,'1','223','1',1,'Retail Sale Id 4663',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 13:12:50','',''),(4389,'1','223','1',1,'Retail Sale Id 4664',3720.00,0.00,0.00,6.00,192.00,'2022-04-17 13:20:53','',''),(4390,'1','223','1',1,'Retail Sale Id 4665',2480.00,0.00,0.00,4.00,128.00,'2022-04-17 13:26:39','',''),(4391,'1','223','1',1,'Retail Sale Id 4666',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 13:55:36','',''),(4392,'1','223','1',1,'Retail Sale Id 4667',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 14:15:42','',''),(4393,'1','223','1',1,'Retail Sale Id 4668',3720.00,0.00,0.00,6.00,192.00,'2022-04-17 14:30:09','',''),(4394,'1','223','1',1,'Retail Sale Id 4670',1252.40,0.00,0.00,2.02,64.64,'2022-04-17 14:38:37','',''),(4395,'1','223','1',1,'Retail Sale Id 4671',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 14:41:35','',''),(4396,'1','223','1',1,'Retail Sale Id 4672',403.00,0.00,0.00,0.65,20.80,'2022-04-17 14:48:35','',''),(4397,'1','223','1',1,'Retail Sale Id 4673',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 14:57:24','',''),(4398,'1','223','1',1,'Retail Sale Id 4674',2002.60,0.00,0.00,3.23,103.36,'2022-04-17 15:00:22','',''),(4399,'1','223','1',1,'Retail Sale Id 4675',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 15:05:32','',''),(4400,'1','223','1',1,'Retail Sale Id 4676',651.00,0.00,0.00,1.05,33.60,'2022-04-17 15:08:45','',''),(4401,'1','223','1',1,'Retail Sale Id 4679',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 15:14:26','',''),(4402,'1','223','1',1,'Retail Sale Id 4680',651.00,0.00,0.00,1.05,33.60,'2022-04-17 15:19:23','',''),(4403,'1','223','1',1,'Retail Sale Id 4681',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 15:23:56','',''),(4404,'1','223','1',1,'Retail Sale Id 4682',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 15:24:55','',''),(4405,'1','223','1',1,'Retail Sale Id 4683',1847.60,0.00,0.00,2.98,95.36,'2022-04-17 15:32:29','',''),(4406,'1','223','1',1,'Retail Sale Id 4684',998.20,0.00,0.00,1.61,51.52,'2022-04-17 15:33:15','',''),(4407,'1','223','1',1,'Retail Sale Id 4685',998.20,0.00,0.00,1.61,51.52,'2022-04-17 15:36:17','',''),(4408,'1','223','1',1,'Retail Sale Id 4686',1500.40,0.00,0.00,2.42,77.44,'2022-04-17 15:44:30','',''),(4409,'1','223','1',1,'Retail Sale Id 4687',2498.60,0.00,0.00,4.03,128.96,'2022-04-17 15:46:44','',''),(4410,'1','223','1',1,'Retail Sale Id 4688',799.80,0.00,0.00,1.29,41.28,'2022-04-17 15:49:03','',''),(4411,'1','223','1',1,'Retail Sale Id 4689',2002.60,0.00,0.00,3.23,103.36,'2022-04-17 15:49:59','',''),(4412,'1','223','1',1,'Retail Sale Id 4690',7750.00,0.00,0.00,12.50,400.00,'2022-04-17 15:55:11','',''),(4413,'1','223','1',1,'Retail Sale Id 4691',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 16:05:23','',''),(4414,'1','223','1',1,'Retail Sale Id 4692',7750.00,0.00,0.00,12.50,400.00,'2022-04-17 16:10:29','',''),(4415,'1','223','1',1,'Retail Sale Id 4693',1847.60,0.00,0.00,2.98,95.36,'2022-04-17 16:14:10','',''),(4416,'1','223','1',1,'Retail Sale Id 4694',1302.00,0.00,0.00,2.10,67.20,'2022-04-17 16:18:11','',''),(4417,'1','223','1',1,'Retail Sale Id 4695',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 16:19:35','',''),(4418,'1','223','1',1,'Retail Sale Id 4696',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 16:31:46','',''),(4419,'1','223','1',1,'Retail Sale Id 4697',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 16:33:56','',''),(4420,'1','223','1',1,'Retail Sale Id 4698',3720.00,0.00,0.00,6.00,192.00,'2022-04-17 16:37:20','',''),(4421,'1','223','1',1,'Retail Sale Id 4699',2480.00,0.00,0.00,4.00,128.00,'2022-04-17 16:40:08','',''),(4422,'1','223','1',1,'Retail Sale Id 4700',651.00,0.00,0.00,1.05,33.60,'2022-04-17 16:50:36','',''),(4423,'1','223','1',1,'Retail Sale Id 4701',36000.00,0.00,0.00,60.00,720.00,'2022-04-17 16:52:50','',''),(4424,'1','223','1',1,'Retail Sale Id 4702',2498.60,0.00,0.00,4.03,128.96,'2022-04-17 16:57:24','',''),(4425,'1','223','1',1,'Retail Sale Id 4703',1860.00,0.00,0.00,3.00,96.00,'2022-04-17 17:10:42','',''),(4426,'1','223','1',1,'Retail Sale Id 4704',1599.60,0.00,0.00,2.58,82.56,'2022-04-17 17:14:56','',''),(4427,'1','223','1',1,'Retail Sale Id 4705',3999.00,0.00,0.00,6.45,206.40,'2022-04-17 17:16:15','',''),(4428,'1','223','1',1,'Retail Sale Id 4706',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 17:23:10','',''),(4429,'1','223','1',1,'Retail Sale Id 4707',1240.00,0.00,0.00,2.00,64.00,'2022-04-17 17:27:45','',''),(4430,'1','223','1',1,'Retail Sale Id 4708',1500.40,0.00,0.00,2.42,77.44,'2022-04-17 17:33:05','',''),(4431,'1','223','1',1,'Retail Sale Id 4709',601.40,0.00,0.00,0.97,31.04,'2022-04-17 17:34:20','',''),(4432,'1','223','1',1,'Retail Sale Id 4710',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 17:36:39','',''),(4433,'1','223','1',1,'Retail Sale Id 4711',3100.00,0.00,0.00,5.00,160.00,'2022-04-17 17:37:57','',''),(4434,'1','223','1',1,'Retail Sale Id 4712',1500.40,0.00,0.00,2.42,77.44,'2022-04-17 17:38:30','',''),(4435,'1','223','1',1,'Retail Sale Id 4713',179.80,0.00,0.00,0.29,9.28,'2022-04-17 19:20:17','',''),(4436,'1','223','1',1,'Retail Sale Id 4714',651.00,0.00,0.00,1.05,33.60,'2022-04-18 07:29:20','',''),(4437,'1','223','1',1,'Retail Sale Id 4715',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 07:36:11','',''),(4438,'1','223','1',1,'Retail Sale Id 4716',1860.00,0.00,0.00,3.00,96.00,'2022-04-18 07:40:37','',''),(4439,'1','223','1',1,'Retail Sale Id 4717',3720.00,0.00,0.00,6.00,192.00,'2022-04-18 07:42:16','',''),(4440,'1','223','1',1,'Retail Sale Id 4718',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 07:54:48','',''),(4441,'1','223','1',1,'Retail Sale Id 4719',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 07:55:33','',''),(4442,'1','223','1',1,'Retail Sale Id 4720',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 07:56:24','',''),(4443,'1','223','1',1,'Retail Sale Id 4721',998.20,0.00,0.00,1.61,51.52,'2022-04-18 07:58:03','',''),(4444,'1','223','1',1,'Retail Sale Id 4722',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 07:59:04','',''),(4445,'1','223','1',1,'Retail Sale Id 4723',7750.00,0.00,0.00,12.50,400.00,'2022-04-18 08:02:34','',''),(4446,'1','223','1',1,'Retail Sale Id 4724',1860.00,0.00,0.00,3.00,96.00,'2022-04-18 08:04:07','',''),(4447,'1','223','1',1,'Retail Sale Id 4725',6999.80,0.00,0.00,11.29,361.28,'2022-04-18 08:05:36','',''),(4448,'1','223','1',1,'Retail Sale Id 4726',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 08:07:35','',''),(4449,'1','223','1',1,'Retail Sale Id 4727',1240.00,0.00,0.00,2.00,64.00,'2022-04-18 08:09:01','',''),(4450,'1','223','1',1,'Retail Sale Id 4728',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 08:10:18','',''),(4451,'1','223','1',1,'Retail Sale Id 4729',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 08:11:00','',''),(4452,'1','223','1',1,'Retail Sale Id 4730',1240.00,0.00,0.00,2.00,64.00,'2022-04-18 08:28:58','',''),(4453,'1','223','1',1,'Retail Sale Id 4731',3751.00,0.00,0.00,6.05,193.60,'2022-04-18 08:32:08','',''),(4454,'1','223','1',1,'Retail Sale Id 4732',2498.60,0.00,0.00,4.03,128.96,'2022-04-18 08:46:00','',''),(4455,'1','223','1',1,'Retail Sale Id 4733',607.60,0.00,0.00,0.98,31.36,'2022-04-18 08:47:48','',''),(4456,'1','223','1',1,'Retail Sale Id 4734',1240.00,0.00,0.00,2.00,64.00,'2022-04-18 08:59:26','',''),(4457,'1','223','1',1,'Retail Sale Id 4735',2498.60,0.00,0.00,4.03,128.96,'2022-04-18 09:06:50','',''),(4458,'1','223','1',1,'Retail Sale Id 4736',1202.80,0.00,0.00,1.94,62.08,'2022-04-18 09:07:24','',''),(4459,'1','223','1',1,'Retail Sale Id 4738',1240.00,0.00,0.00,2.00,64.00,'2022-04-18 09:12:03','',''),(4460,'1','223','1',1,'Retail Sale Id 4739',1860.00,0.00,0.00,3.00,96.00,'2022-04-18 09:19:35','',''),(4461,'1','223','1',1,'Retail Sale Id 4740',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 09:20:26','',''),(4462,'1','223','1',1,'Retail Sale Id 4741',4960.00,0.00,0.00,8.00,256.00,'2022-04-18 09:21:39','',''),(4463,'1','223','1',1,'Retail Sale Id 4742',2480.00,0.00,0.00,4.00,128.00,'2022-04-18 09:22:06','',''),(4464,'1','223','1',1,'Retail Sale Id 4743',6200.00,0.00,0.00,10.00,320.00,'2022-04-18 09:26:04','',''),(4465,'1','223','1',1,'Retail Sale Id 4744',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 09:27:16','',''),(4466,'1','223','1',1,'Retail Sale Id 4745',998.20,0.00,0.00,1.61,51.52,'2022-04-18 09:27:54','',''),(4467,'1','223','1',1,'Retail Sale Id 4746',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 09:28:48','',''),(4468,'1','223','1',1,'Retail Sale Id 4747',60000.00,0.00,0.00,100.00,1200.00,'2022-04-18 09:29:36','',''),(4469,'1','223','1',1,'Retail Sale Id 4748',3720.00,0.00,0.00,6.00,192.00,'2022-04-18 09:32:02','',''),(4470,'1','223','1',1,'Retail Sale Id 4749',3800.60,0.00,0.00,6.13,196.16,'2022-04-18 09:33:10','',''),(4471,'1','223','1',1,'Retail Sale Id 4750',1500.40,0.00,0.00,2.42,77.44,'2022-04-18 09:40:00','',''),(4472,'1','223','1',1,'Retail Sale Id 4751',7750.00,0.00,0.00,12.50,400.00,'2022-04-18 09:49:36','',''),(4473,'1','223','1',1,'Retail Sale Id 4752',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 09:57:17','',''),(4474,'1','223','1',1,'Retail Sale Id 4753',3751.00,0.00,0.00,6.05,193.60,'2022-04-18 10:09:18','',''),(4475,'1','223','1',1,'Retail Sale Id 4754',11470.00,0.00,0.00,18.50,592.00,'2022-04-18 10:30:26','',''),(4476,'1','223','1',1,'Retail Sale Id 4755',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 10:35:02','',''),(4477,'1','223','1',1,'Retail Sale Id 4756',2498.60,0.00,0.00,4.03,128.96,'2022-04-18 10:37:18','',''),(4478,'1','223','1',1,'Retail Sale Id 4757',1847.60,0.00,0.00,2.98,95.36,'2022-04-18 10:39:15','',''),(4479,'1','223','1',1,'Retail Sale Id 4758',1872.40,0.00,0.00,3.02,96.64,'2022-04-18 10:52:24','',''),(4480,'1','223','1',1,'Retail Sale Id 4759',1860.00,0.00,0.00,3.00,96.00,'2022-04-18 11:17:03','',''),(4481,'1','223','1',1,'Retail Sale Id 4761',4997.20,0.00,0.00,8.06,257.92,'2022-04-18 11:28:45','',''),(4482,'1','223','1',1,'Retail Sale Id 4762',1240.00,0.00,0.00,2.00,64.00,'2022-04-18 11:33:57','',''),(4483,'1','223','1',1,'Retail Sale Id 4763',36000.00,0.00,0.00,60.00,720.00,'2022-04-18 11:42:21','',''),(4484,'1','223','1',1,'Retail Sale Id 4764',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 11:45:58','',''),(4485,'1','223','1',1,'Retail Sale Id 4765',3720.00,0.00,0.00,6.00,192.00,'2022-04-18 11:48:22','',''),(4486,'1','223','1',1,'Retail Sale Id 4766',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 11:55:57','',''),(4487,'1','223','1',1,'Retail Sale Id 4767',1860.00,0.00,0.00,3.00,96.00,'2022-04-18 12:06:53','',''),(4488,'1','223','1',1,'Retail Sale Id 4768',3720.00,0.00,0.00,6.00,192.00,'2022-04-18 12:25:12','',''),(4489,'1','223','1',1,'Retail Sale Id 4769',7750.00,0.00,0.00,12.50,400.00,'2022-04-18 12:35:41','',''),(4490,'1','223','1',1,'Retail Sale Id 4770',651.00,0.00,0.00,1.05,33.60,'2022-04-18 12:36:28','',''),(4491,'1','223','1',1,'Return of Retail Sale Id 4770',0.00,651.00,1.05,0.00,-33.60,'2022-04-18 12:36:59','',''),(4492,'1','223','1',1,'Retail Sale Id 4771',1147.00,0.00,0.00,1.85,59.20,'2022-04-18 12:37:20','',''),(4493,'1','223','1',1,'Return of Retail Sale Id 4765',0.00,3720.00,6.00,0.00,-192.00,'2022-04-18 12:39:35','',''),(4494,'1','223','1',1,'Retail Sale Id 4772',2480.00,0.00,0.00,4.00,128.00,'2022-04-18 12:40:06','',''),(4495,'1','223','1',1,'Retail Sale Id 4773',601.40,0.00,0.00,0.97,31.04,'2022-04-18 12:46:55','',''),(4496,'1','223','1',1,'Retail Sale Id 4774',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 12:47:53','',''),(4497,'1','223','1',1,'Retail Sale Id 4776',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 12:51:57','',''),(4498,'1','223','1',1,'Retail Sale Id 4777',1798.00,0.00,0.00,2.90,92.80,'2022-04-18 12:56:58','',''),(4499,'1','223','1',1,'Retail Sale Id 4778',1240.00,0.00,0.00,2.00,64.00,'2022-04-18 13:03:40','',''),(4500,'1','223','1',1,'Retail Sale Id 4779',651.00,0.00,0.00,1.05,33.60,'2022-04-18 13:21:10','',''),(4501,'1','223','1',1,'Retail Sale Id 4780',6820.00,0.00,0.00,11.00,352.00,'2022-04-18 13:27:34','',''),(4502,'1','223','1',1,'Retail Sale Id 4781',1860.00,0.00,0.00,3.00,96.00,'2022-04-18 13:35:14','',''),(4503,'1','223','1',1,'Retail Sale Id 4782',620.00,0.00,0.00,1.00,32.00,'2022-04-18 13:36:29','',''),(4504,'1','223','1',1,'Retail Sale Id 4783',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 13:52:33','',''),(4505,'1','223','1',1,'Retail Sale Id 4784',2480.00,0.00,0.00,4.00,128.00,'2022-04-18 13:59:32','',''),(4506,'1','223','1',1,'Retail Sale Id 4785',1240.00,0.00,0.00,2.00,64.00,'2022-04-18 14:00:19','',''),(4507,'1','223','1',1,'Retail Sale Id 4786',1847.60,0.00,0.00,2.98,95.36,'2022-04-18 14:23:23','',''),(4508,'1','223','1',1,'Retail Sale Id 4787',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 14:35:51','',''),(4509,'1','223','1',1,'Retail Sale Id 4788',1500.40,0.00,0.00,2.42,77.44,'2022-04-18 14:37:41','',''),(4510,'1','223','1',1,'Retail Sale Id 4789',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 15:13:19','',''),(4511,'1','223','1',1,'Retail Sale Id 4790',651.00,0.00,0.00,1.05,33.60,'2022-04-18 15:32:34','',''),(4512,'1','223','1',1,'Retail Sale Id 4791',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 15:47:58','',''),(4513,'1','223','1',1,'Retail Sale Id 4792',2480.00,0.00,0.00,4.00,128.00,'2022-04-18 15:49:51','',''),(4514,'1','223','1',1,'Retail Sale Id 4793',2002.60,0.00,0.00,3.23,103.36,'2022-04-18 15:54:13','',''),(4515,'1','223','1',1,'Retail Sale Id 4794',7750.00,0.00,0.00,12.50,400.00,'2022-04-18 15:55:37','',''),(4516,'1','223','1',1,'Retail Sale Id 4795',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 15:57:20','',''),(4517,'1','223','1',1,'Retail Sale Id 4796',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 15:58:17','',''),(4518,'1','223','1',1,'Retail Sale Id 4797',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 15:59:03','',''),(4519,'1','223','1',1,'Retail Sale Id 4798',1500.40,0.00,0.00,2.42,77.44,'2022-04-18 16:02:10','',''),(4520,'1','223','1',1,'Retail Sale Id 4799',1240.00,0.00,0.00,2.00,64.00,'2022-04-18 16:03:24','',''),(4521,'1','223','1',1,'Retail Sale Id 4800',3720.00,0.00,0.00,6.00,192.00,'2022-04-18 16:05:38','',''),(4522,'1','223','1',1,'Retail Sale Id 4801',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 16:07:04','',''),(4523,'1','223','1',1,'Retail Sale Id 4802',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 16:07:54','',''),(4524,'1','223','1',1,'Retail Sale Id 4803',651.00,0.00,0.00,1.05,33.60,'2022-04-18 16:14:14','',''),(4525,'1','223','1',1,'Retail Sale Id 4804',3701.40,0.00,0.00,5.97,191.04,'2022-04-18 16:16:38','',''),(4526,'1','223','1',1,'Retail Sale Id 4805',998.20,0.00,0.00,1.61,51.52,'2022-04-18 16:17:44','',''),(4527,'1','223','1',1,'Return of Retail Sale Id 4804',0.00,3701.40,5.97,0.00,-191.04,'2022-04-18 16:23:50','',''),(4528,'1','223','1',1,'Retail Sale Id 4806',3701.40,0.00,0.00,5.97,191.04,'2022-04-18 16:24:13','',''),(4529,'1','223','1',1,'Retail Sale Id 4807',1860.00,0.00,0.00,3.00,96.00,'2022-04-18 16:25:25','',''),(4530,'1','223','1',1,'Retail Sale Id 4808',2002.60,0.00,0.00,3.23,103.36,'2022-04-18 16:26:30','',''),(4531,'1','223','1',1,'Retail Sale Id 4809',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 16:35:57','',''),(4532,'1','223','1',1,'Retail Sale Id 4810',651.00,0.00,0.00,1.05,33.60,'2022-04-18 16:39:08','',''),(4533,'1','223','1',1,'Retail Sale Id 4811',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 16:40:35','',''),(4534,'1','223','1',1,'Retail Sale Id 4812',1847.60,0.00,0.00,2.98,95.36,'2022-04-18 16:42:29','',''),(4535,'1','223','1',1,'Retail Sale Id 4813',1500.40,0.00,0.00,2.42,77.44,'2022-04-18 16:43:16','',''),(4536,'1','223','1',1,'Retail Sale Id 4814',620.00,0.00,0.00,1.00,32.00,'2022-04-18 16:49:27','',''),(4537,'1','223','1',1,'Retail Sale Id 4815',502.20,0.00,0.00,0.81,25.92,'2022-04-18 16:52:07','',''),(4538,'1','223','1',1,'Retail Sale Id 4816',3720.00,0.00,0.00,6.00,192.00,'2022-04-18 16:53:19','',''),(4539,'1','223','1',1,'Retail Sale Id 4817',1500.40,0.00,0.00,2.42,77.44,'2022-04-18 16:54:21','',''),(4540,'1','223','1',1,'Retail Sale Id 4818',1860.00,0.00,0.00,3.00,96.00,'2022-04-18 16:58:23','',''),(4541,'1','223','1',1,'Retail Sale Id 4819',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 17:00:35','',''),(4542,'1','223','1',1,'Retail Sale Id 4820',3100.00,0.00,0.00,5.00,160.00,'2022-04-18 17:02:24','',''),(4543,'1','223','1',1,'Retail Sale Id 4821',998.20,0.00,0.00,1.61,51.52,'2022-04-18 17:13:12','',''),(4544,'1','223','1',1,'Retail Sale Id 4822',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 17:16:07','',''),(4545,'1','223','1',1,'Return of Retail Sale Id 4822',0.00,1252.40,2.02,0.00,-64.64,'2022-04-18 17:16:59','',''),(4546,'1','223','1',1,'Retail Sale Id 4823',1500.40,0.00,0.00,2.42,77.44,'2022-04-18 17:17:35','',''),(4547,'1','223','1',1,'Retail Sale Id 4824',1860.00,0.00,0.00,3.00,96.00,'2022-04-18 17:21:59','',''),(4548,'1','223','1',1,'Retail Sale Id 4825',7750.00,0.00,0.00,12.50,400.00,'2022-04-18 17:25:30','',''),(4549,'1','223','1',1,'Retail Sale Id 4826',2002.60,0.00,0.00,3.23,103.36,'2022-04-18 17:30:53','',''),(4550,'1','223','1',1,'Retail Sale Id 4827',620.00,0.00,0.00,1.00,32.00,'2022-04-18 17:31:40','',''),(4551,'1','223','1',1,'Retail Sale Id 4828',998.20,0.00,0.00,1.61,51.52,'2022-04-18 17:33:26','',''),(4552,'1','223','1',1,'Retail Sale Id 4829',1240.00,0.00,0.00,2.00,64.00,'2022-04-18 17:34:31','',''),(4553,'1','223','1',1,'Retail Sale Id 4830',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 17:35:31','',''),(4554,'1','223','1',1,'Retail Sale Id 4831',1847.60,0.00,0.00,2.98,95.36,'2022-04-18 17:41:31','',''),(4555,'1','223','1',1,'Retail Sale Id 4832',2498.60,0.00,0.00,4.03,128.96,'2022-04-18 17:42:20','',''),(4556,'1','223','1',1,'Retail Sale Id 4833',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 17:44:10','',''),(4557,'1','223','1',1,'Retail Sale Id 4834',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 17:45:16','',''),(4558,'1','223','1',1,'Retail Sale Id 4835',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 17:45:59','',''),(4559,'1','223','1',1,'Retail Sale Id 4836',1847.60,0.00,0.00,2.98,95.36,'2022-04-18 17:48:12','',''),(4560,'1','223','1',1,'Retail Sale Id 4837',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 17:49:53','',''),(4561,'1','223','1',1,'Retail Sale Id 4838',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 17:52:24','',''),(4562,'1','223','1',1,'Retail Sale Id 4839',3720.00,0.00,0.00,6.00,192.00,'2022-04-18 18:02:33','',''),(4563,'1','223','1',1,'Retail Sale Id 4840',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 18:06:05','',''),(4564,'1','223','1',1,'Retail Sale Id 4842',1798.00,0.00,0.00,2.90,92.80,'2022-04-18 18:17:25','',''),(4565,'1','223','1',1,'Retail Sale Id 4843',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 18:19:42','',''),(4566,'1','223','1',1,'Retail Sale Id 4844',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 18:28:21','',''),(4567,'1','223','1',1,'Retail Sale Id 4845',2002.60,0.00,0.00,3.23,103.36,'2022-04-18 18:29:07','',''),(4568,'1','223','1',1,'Retail Sale Id 4846',1897.20,0.00,0.00,3.06,97.92,'2022-04-18 18:29:50','',''),(4569,'1','223','1',1,'Retail Sale Id 4847',3751.00,0.00,0.00,6.05,193.60,'2022-04-18 18:31:45','',''),(4570,'1','223','1',1,'Retail Sale Id 4848',998.20,0.00,0.00,1.61,51.52,'2022-04-18 18:33:37','',''),(4571,'1','223','1',1,'Retail Sale Id 4849',3751.00,0.00,0.00,6.05,193.60,'2022-04-18 18:38:26','',''),(4572,'1','223','1',1,'Retail Sale Id 4850',1252.40,0.00,0.00,2.02,64.64,'2022-04-18 18:41:29','',''),(4573,'1','223','1',1,'Retail Sale Id 4851',700.60,0.00,0.00,1.13,36.16,'2022-04-19 07:31:53','',''),(4574,'1','223','1',1,'Retail Sale Id 4852',1302.00,0.00,0.00,2.10,67.20,'2022-04-19 07:33:04','',''),(4575,'1','223','1',1,'Retail Sale Id 4853',2002.60,0.00,0.00,3.23,103.36,'2022-04-19 07:33:56','',''),(4576,'1','223','1',1,'Retail Sale Id 4854',2002.60,0.00,0.00,3.23,103.36,'2022-04-19 07:39:00','',''),(4577,'1','223','1',1,'Retail Sale Id 4855',1872.40,0.00,0.00,3.02,96.64,'2022-04-19 07:52:42','',''),(4578,'1','223','1',1,'Retail Sale Id 4856',2498.60,0.00,0.00,4.03,128.96,'2022-04-19 07:53:39','',''),(4579,'1','223','1',1,'Retail Sale Id 4857',3720.00,0.00,0.00,6.00,192.00,'2022-04-19 08:13:15','',''),(4580,'1','223','1',1,'Retail Sale Id 4858',3100.00,0.00,0.00,5.00,160.00,'2022-04-19 08:14:22','',''),(4581,'1','223','1',1,'Retail Sale Id 4859',1847.60,0.00,0.00,2.98,95.36,'2022-04-19 08:17:21','',''),(4582,'1','223','1',1,'Retail Sale Id 4860',3100.00,0.00,0.00,5.00,160.00,'2022-04-19 08:34:57','',''),(4583,'1','223','1',1,'Retail Sale Id 4861',7750.00,0.00,0.00,12.50,400.00,'2022-04-19 08:41:56','',''),(4584,'1','223','1',1,'Retail Sale Id 4862',1252.40,0.00,0.00,2.02,64.64,'2022-04-19 08:46:37','',''),(4585,'1','223','1',1,'Retail Sale Id 4863',1252.40,0.00,0.00,2.02,64.64,'2022-04-19 08:56:57','',''),(4586,'1','223','1',1,'Retail Sale Id 4864',1252.40,0.00,0.00,2.02,64.64,'2022-04-19 09:00:01','',''),(4587,'1','223','1',1,'Retail Sale Id 4865',349200.00,0.00,0.00,582.00,6984.00,'2022-04-19 10:06:45','',''),(4588,'1','223','1',1,'Return of Retail Sale Id 4865',0.00,349200.00,582.00,0.00,-6984.00,'2022-04-19 10:08:43','',''),(4589,'1','223','1',1,'Retail Sale Id 4867',349200.00,0.00,0.00,582.00,6984.00,'2022-04-19 10:09:33','',''),(4590,'1','223','1',1,'Retail Sale Id 4869',3974.20,0.00,0.00,6.41,205.12,'2022-04-19 10:12:46','',''),(4591,'1','223','1',1,'Retail Sale Id 4870',5617.20,0.00,0.00,9.06,289.92,'2022-04-19 10:15:37','',''),(4592,'1','223','1',1,'Retail Sale Id 4871',18.60,0.00,0.00,0.03,0.96,'2022-04-19 11:17:33','',''),(4593,'1','223','1',1,'Distributed to A A RANO NIGERIA LIMITED for sales id:4',128572.08,0.00,0.00,218.66,0.00,'2022-04-20 07:33:12','',''),(4594,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,1764000.00,3000.00,0.00,0.00,'2022-04-20 07:36:12','',''),(4595,'1','223',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,3000.00,0.00,'2022-04-20 07:37:51','',''),(4596,'1','223','1',1,'Received from bridging 8',0.00,0.00,3000.00,0.00,0.00,'2022-04-20 07:37:51','',''),(4597,'1','223','1',1,'Retail Sale Id 4872',17645.20,0.00,0.00,28.46,910.72,'2022-04-20 07:41:00','',''),(4598,'1','223','1',1,'Retail Sale Id 4873',22208.40,0.00,0.00,35.82,1146.24,'2022-04-20 07:43:36','',''),(4599,'1','223','1',1,'Retail Sale Id 4874',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 07:45:08','',''),(4600,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,1922760.00,3270.00,0.00,0.00,'2022-04-20 07:52:09','',''),(4601,'1','223',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,3270.00,0.00,'2022-04-20 07:52:54','',''),(4602,'1','223','1',1,'Received from bridging 9',0.00,0.00,3270.00,0.00,0.00,'2022-04-20 07:52:54','',''),(4603,'1','223','1',1,'Retail Sale Id 4880',3100.00,0.00,0.00,5.00,160.00,'2022-04-20 08:06:51','',''),(4604,'1','223','1',1,'Retail Sale Id 4881',3100.00,0.00,0.00,5.00,160.00,'2022-04-20 08:18:20','',''),(4605,'1','223','1',1,'Retail Sale Id 4882',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 08:19:13','',''),(4606,'1','223','1',1,'Retail Sale Id 4883',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 08:20:16','',''),(4607,'1','223','1',1,'Retail Sale Id 4884',2498.60,0.00,0.00,4.03,128.96,'2022-04-20 08:30:23','',''),(4608,'1','223','1',1,'Retail Sale Id 4886',1500.40,0.00,0.00,2.42,77.44,'2022-04-20 08:31:25','',''),(4609,'1','223','1',1,'Retail Sale Id 4888',998.20,0.00,0.00,1.61,51.52,'2022-04-20 08:39:02','',''),(4610,'1','223','1',1,'Retail Sale Id 4889',71100.00,0.00,0.00,118.50,1422.00,'2022-04-20 08:39:56','',''),(4611,'1','223','1',1,'Retail Sale Id 4890',1240.00,0.00,0.00,2.00,64.00,'2022-04-20 08:42:33','',''),(4612,'1','223','1',1,'Retail Sale Id 4891',3100.00,0.00,0.00,5.00,160.00,'2022-04-20 08:43:44','',''),(4613,'1','223','1',1,'Retail Sale Id 4892',2002.60,0.00,0.00,3.23,103.36,'2022-04-20 09:01:48','',''),(4614,'1','223','1',1,'Retail Sale Id 4893',1860.00,0.00,0.00,3.00,96.00,'2022-04-20 09:07:53','',''),(4615,'1','223','1',1,'Retail Sale Id 4894',3751.00,0.00,0.00,6.05,193.60,'2022-04-20 09:18:30','',''),(4616,'1','223','1',1,'Retail Sale Id 4895',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 09:19:59','',''),(4617,'1','223','1',1,'Retail Sale Id 4896',998.20,0.00,0.00,1.61,51.52,'2022-04-20 09:30:03','',''),(4618,'1','223','1',1,'Retail Sale Id 4898',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 09:35:14','',''),(4619,'1','223','1',1,'Retail Sale Id 4899',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 09:46:10','',''),(4620,'1','223','1',1,'Retail Sale Id 4900',1860.00,0.00,0.00,3.00,96.00,'2022-04-20 09:50:14','',''),(4621,'1','223','1',1,'Retail Sale Id 4901',998.20,0.00,0.00,1.61,51.52,'2022-04-20 09:50:49','',''),(4622,'1','223','1',1,'Retail Sale Id 4902',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 09:57:13','',''),(4623,'1','223','1',1,'Retail Sale Id 4903',1500.40,0.00,0.00,2.42,77.44,'2022-04-20 10:01:08','',''),(4624,'1','223','1',1,'Retail Sale Id 4904',7750.00,0.00,0.00,12.50,400.00,'2022-04-20 10:19:04','',''),(4625,'1','223','1',1,'Retail Sale Id 4906',3720.00,0.00,0.00,6.00,192.00,'2022-04-20 10:24:11','',''),(4626,'1','223','1',1,'Retail Sale Id 4907',3720.00,0.00,0.00,6.00,192.00,'2022-04-20 10:26:52','',''),(4627,'1','223','1',1,'Retail Sale Id 4908',1847.60,0.00,0.00,2.98,95.36,'2022-04-20 10:40:09','',''),(4628,'1','223','1',1,'Retail Sale Id 4909',1860.00,0.00,0.00,3.00,96.00,'2022-04-20 10:44:43','',''),(4629,'1','223','1',1,'Retail Sale Id 4910',1202.80,0.00,0.00,1.94,62.08,'2022-04-20 10:53:49','',''),(4630,'1','223','1',1,'Retail Sale Id 4911',3100.00,0.00,0.00,5.00,160.00,'2022-04-20 11:16:07','',''),(4631,'1','223','1',1,'Retail Sale Id 4912',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 11:20:55','',''),(4632,'1','223','1',1,'Retail Sale Id 4913',1202.80,0.00,0.00,1.94,62.08,'2022-04-20 11:34:36','',''),(4633,'1','223','1',1,'Retail Sale Id 4914',1897.20,0.00,0.00,3.06,97.92,'2022-04-20 11:47:29','',''),(4634,'1','223','1',1,'Retail Sale Id 4915',1202.80,0.00,0.00,1.94,62.08,'2022-04-20 11:52:01','',''),(4635,'1','223','1',1,'Retail Sale Id 4916',38400.00,0.00,0.00,64.00,768.00,'2022-04-20 14:56:22','',''),(4636,'1','223','1',1,'Retail Sale Id 4917',1847.60,0.00,0.00,2.98,95.36,'2022-04-20 14:59:09','',''),(4637,'1','223','1',1,'Retail Sale Id 4918',11718.00,0.00,0.00,18.90,604.80,'2022-04-20 15:00:37','',''),(4638,'1','223','1',1,'Retail Sale Id 4919',3100.00,0.00,0.00,5.00,160.00,'2022-04-20 15:02:24','',''),(4639,'1','223','1',1,'Retail Sale Id 4920',11848.20,0.00,0.00,19.11,611.52,'2022-04-20 15:03:32','',''),(4640,'1','223','1',1,'Retail Sale Id 4921',11618.80,0.00,0.00,18.74,599.68,'2022-04-20 15:05:19','',''),(4641,'1','223','1',1,'Retail Sale Id 4922',5480.80,0.00,0.00,8.84,282.88,'2022-04-20 15:06:26','',''),(4642,'1','223','1',1,'Retail Sale Id 4923',3720.00,0.00,0.00,6.00,192.00,'2022-04-20 15:15:40','',''),(4643,'1','223','1',1,'Retail Sale Id 4924',1240.00,0.00,0.00,2.00,64.00,'2022-04-20 15:18:27','',''),(4644,'1','223','1',1,'Retail Sale Id 4925',6919.20,0.00,0.00,11.16,357.12,'2022-04-20 15:24:40','',''),(4645,'1','223','1',1,'Retail Sale Id 4926',1302.00,0.00,0.00,2.10,67.20,'2022-04-20 15:31:40','',''),(4646,'1','223','1',1,'Retail Sale Id 4927',3720.00,0.00,0.00,6.00,192.00,'2022-04-20 15:40:06','',''),(4647,'1','223','1',1,'Retail Sale Id 4928',3720.00,0.00,0.00,6.00,192.00,'2022-04-20 15:40:27','',''),(4648,'1','223','1',1,'Retail Sale Id 4929',1860.00,0.00,0.00,3.00,96.00,'2022-04-20 15:42:31','',''),(4649,'1','223','1',1,'Retail Sale Id 4930',1698.80,0.00,0.00,2.74,87.68,'2022-04-20 15:51:13','',''),(4650,'1','223','1',1,'Return of Retail Sale Id 4928',0.00,3720.00,6.00,0.00,-192.00,'2022-04-20 15:51:51','',''),(4651,'1','223','1',1,'Retail Sale Id 4931',1302.00,0.00,0.00,2.10,67.20,'2022-04-20 15:53:30','',''),(4652,'1','223','1',1,'Retail Sale Id 4932',1897.20,0.00,0.00,3.06,97.92,'2022-04-20 16:16:50','',''),(4653,'1','223','1',1,'Retail Sale Id 4933',1897.20,0.00,0.00,3.06,97.92,'2022-04-20 16:20:57','',''),(4654,'1','223','1',1,'Retail Sale Id 4934',3100.00,0.00,0.00,5.00,160.00,'2022-04-20 16:24:14','',''),(4655,'1','223','1',1,'Retail Sale Id 4935',1897.20,0.00,0.00,3.06,97.92,'2022-04-20 16:27:55','',''),(4656,'1','223','1',1,'Retail Sale Id 4936',1798.00,0.00,0.00,2.90,92.80,'2022-04-20 16:29:12','',''),(4657,'1','223','1',1,'Retail Sale Id 4937',651.00,0.00,0.00,1.05,33.60,'2022-04-20 16:30:58','',''),(4658,'1','223','1',1,'Retail Sale Id 4938',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 16:33:02','',''),(4659,'1','223','1',1,'Retail Sale Id 4939',700.60,0.00,0.00,1.13,36.16,'2022-04-20 16:33:49','',''),(4660,'1','223','1',1,'Retail Sale Id 4940',1897.20,0.00,0.00,3.06,97.92,'2022-04-20 16:35:06','',''),(4661,'1','223','1',1,'Retail Sale Id 4941',6200.00,0.00,0.00,10.00,320.00,'2022-04-20 16:47:58','',''),(4662,'1','223','1',1,'Retail Sale Id 4942',998.20,0.00,0.00,1.61,51.52,'2022-04-20 16:55:10','',''),(4663,'1','223','1',1,'Retail Sale Id 4943',3701.40,0.00,0.00,5.97,191.04,'2022-04-20 16:56:48','',''),(4664,'1','223','1',1,'Retail Sale Id 4944',3751.00,0.00,0.00,6.05,193.60,'2022-04-20 17:02:13','',''),(4665,'1','223','1',1,'Retail Sale Id 4945',1860.00,0.00,0.00,3.00,96.00,'2022-04-20 17:16:09','',''),(4666,'1','223','1',1,'Retail Sale Id 4946',3100.00,0.00,0.00,5.00,160.00,'2022-04-20 17:17:07','',''),(4667,'1','223','1',1,'Retail Sale Id 4947',1240.00,0.00,0.00,2.00,64.00,'2022-04-20 17:26:43','',''),(4668,'1','223','1',1,'Retail Sale Id 4948',1860.00,0.00,0.00,3.00,96.00,'2022-04-20 17:28:59','',''),(4669,'1','223','1',1,'Retail Sale Id 4949',1240.00,0.00,0.00,2.00,64.00,'2022-04-20 17:29:56','',''),(4670,'1','223','1',1,'Retail Sale Id 4950',1897.20,0.00,0.00,3.06,97.92,'2022-04-20 17:32:16','',''),(4671,'1','223','1',1,'Retail Sale Id 4951',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 17:33:37','',''),(4672,'1','223','1',1,'Retail Sale Id 4952',2498.60,0.00,0.00,4.03,128.96,'2022-04-20 17:36:19','',''),(4673,'1','223','1',1,'Retail Sale Id 4953',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 17:37:12','',''),(4674,'1','223','1',1,'Retail Sale Id 4954',620.00,0.00,0.00,1.00,32.00,'2022-04-20 17:38:06','',''),(4675,'1','223','1',1,'Retail Sale Id 4955',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 17:39:18','',''),(4676,'1','223','1',1,'Retail Sale Id 4956',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 17:40:08','',''),(4677,'1','223','1',1,'Retail Sale Id 4957',3100.00,0.00,0.00,5.00,160.00,'2022-04-20 17:43:55','',''),(4678,'1','223','1',1,'Retail Sale Id 4958',3720.00,0.00,0.00,6.00,192.00,'2022-04-20 17:48:17','',''),(4679,'1','223','1',1,'Retail Sale Id 4959',1240.00,0.00,0.00,2.00,64.00,'2022-04-20 17:56:28','',''),(4680,'1','223','1',1,'Retail Sale Id 4960',998.20,0.00,0.00,1.61,51.52,'2022-04-20 17:59:48','',''),(4681,'1','223','1',1,'Retail Sale Id 4961',3100.00,0.00,0.00,5.00,160.00,'2022-04-20 18:08:13','',''),(4682,'1','223','1',1,'Retail Sale Id 4962',1847.60,0.00,0.00,2.98,95.36,'2022-04-20 18:09:15','',''),(4683,'1','223','1',1,'Retail Sale Id 4963',1252.40,0.00,0.00,2.02,64.64,'2022-04-20 18:10:20','',''),(4684,'1','223','1',1,'Retail Sale Id 4964',1847.60,0.00,0.00,2.98,95.36,'2022-04-20 18:12:44','',''),(4685,'1','223','1',1,'Retail Sale Id 4965',620.00,0.00,0.00,1.00,32.00,'2022-04-20 18:14:53','',''),(4686,'1','223','1',1,'Retail Sale Id 4966',1401.20,0.00,0.00,2.26,72.32,'2022-04-20 18:15:49','',''),(4687,'1','223','1',1,'Retail Sale Id 4967',1860.00,0.00,0.00,3.00,96.00,'2022-04-20 18:16:53','',''),(4688,'1','223','1',1,'Retail Sale Id 4968',620.00,0.00,0.00,1.00,32.00,'2022-04-20 18:29:16','',''),(4689,'1','223','1',1,'Retail Sale Id 4969',1897.20,0.00,0.00,3.06,97.92,'2022-04-20 18:33:35','',''),(4690,'1','223','1',1,'Return of Retail Sale Id 4889',0.00,71100.00,118.50,0.00,-1422.00,'2022-04-20 19:33:03','',''),(4691,'1','223','1',1,'Retail Sale Id 4970',70002.00,0.00,0.00,116.67,1400.04,'2022-04-20 19:35:55','',''),(4692,'1','223','1',1,'Retail Sale Id 4971',5648.20,0.00,0.00,9.11,291.52,'2022-04-21 06:45:33','',''),(4693,'1','223','1',1,'Retail Sale Id 4972',31800.00,0.00,0.00,53.00,636.00,'2022-04-21 06:56:00','',''),(4694,'1','223','1',1,'Retail Sale Id 4973',1897.20,0.00,0.00,3.06,97.92,'2022-04-21 07:23:55','',''),(4695,'1','223','1',1,'Return of Retail Sale Id 4973',0.00,1897.20,3.06,0.00,-97.92,'2022-04-21 07:29:21','',''),(4696,'1','223','1',1,'Retail Sale Id 4974',1395.00,0.00,0.00,2.25,72.00,'2022-04-21 07:30:12','',''),(4697,'1','223','1',1,'Retail Sale Id 4975',3701.40,0.00,0.00,5.97,191.04,'2022-04-21 07:33:04','',''),(4698,'1','223','1',1,'Retail Sale Id 4977',3100.00,0.00,0.00,5.00,160.00,'2022-04-21 07:33:39','',''),(4699,'1','223','1',1,'Retail Sale Id 4978',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 07:46:30','',''),(4700,'1','223','1',1,'Retail Sale Id 4979',998.20,0.00,0.00,1.61,51.52,'2022-04-21 07:50:12','',''),(4701,'1','223','1',1,'Retail Sale Id 4980',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 08:01:49','',''),(4702,'1','223','1',1,'Retail Sale Id 4981',651.00,0.00,0.00,1.05,33.60,'2022-04-21 08:05:54','',''),(4703,'1','223','1',1,'Retail Sale Id 4982',6200.00,0.00,0.00,10.00,320.00,'2022-04-21 08:10:37','',''),(4704,'1','223','1',1,'Retail Sale Id 4983',2498.60,0.00,0.00,4.03,128.96,'2022-04-21 08:47:42','',''),(4705,'1','223','1',1,'Retail Sale Id 4984',3720.00,0.00,0.00,6.00,192.00,'2022-04-21 08:48:50','',''),(4706,'1','223','1',1,'Retail Sale Id 4985',3100.00,0.00,0.00,5.00,160.00,'2022-04-21 08:53:07','',''),(4707,'1','223','1',1,'Retail Sale Id 4986',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 09:05:08','',''),(4708,'1','223','1',1,'Retail Sale Id 4987',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 09:06:12','',''),(4709,'1','223','1',1,'Retail Sale Id 4988',2002.60,0.00,0.00,3.23,103.36,'2022-04-21 09:17:49','',''),(4710,'1','223','1',1,'Retail Sale Id 4989',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 09:18:26','',''),(4711,'1','223','1',1,'Retail Sale Id 4990',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 09:22:15','',''),(4712,'1','223','1',1,'Retail Sale Id 4991',502.20,0.00,0.00,0.81,25.92,'2022-04-21 09:26:49','',''),(4713,'1','223','1',1,'Retail Sale Id 4992',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 09:30:25','',''),(4714,'1','223','1',1,'Retail Sale Id 4993',3100.00,0.00,0.00,5.00,160.00,'2022-04-21 09:41:05','',''),(4715,'1','223','1',1,'Retail Sale Id 4994',1798.00,0.00,0.00,2.90,92.80,'2022-04-21 09:58:51','',''),(4716,'1','223','1',1,'Retail Sale Id 4995',2002.60,0.00,0.00,3.23,103.36,'2022-04-21 09:59:39','',''),(4717,'1','223','1',1,'Retail Sale Id 4996',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 10:00:11','',''),(4718,'1','223','1',1,'Retail Sale Id 4997',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 10:03:39','',''),(4719,'1','223','1',1,'Retail Sale Id 4998',1500.40,0.00,0.00,2.42,77.44,'2022-04-21 10:04:22','',''),(4720,'1','223','1',1,'Retail Sale Id 4999',2498.60,0.00,0.00,4.03,128.96,'2022-04-21 10:13:47','',''),(4721,'1','223','1',1,'Retail Sale Id 5000',3000.80,0.00,0.00,4.84,154.88,'2022-04-21 10:15:19','',''),(4722,'1','223','1',1,'Retail Sale Id 5001',651.00,0.00,0.00,1.05,33.60,'2022-04-21 10:17:17','',''),(4723,'1','223','1',1,'Retail Sale Id 5002',3751.00,0.00,0.00,6.05,193.60,'2022-04-21 10:22:30','',''),(4724,'1','223','1',1,'Retail Sale Id 5003',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 10:26:05','',''),(4725,'1','223','1',1,'Retail Sale Id 5004',998.20,0.00,0.00,1.61,51.52,'2022-04-21 10:26:40','',''),(4726,'1','223','1',1,'Retail Sale Id 5005',3720.00,0.00,0.00,6.00,192.00,'2022-04-21 10:32:02','',''),(4727,'1','223','1',1,'Retail Sale Id 5006',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 10:59:20','',''),(4728,'1','223','1',1,'Retail Sale Id 5007',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 11:00:28','',''),(4729,'1','223','1',1,'Retail Sale Id 5008',4997.20,0.00,0.00,8.06,257.92,'2022-04-21 11:21:50','',''),(4730,'1','223','1',1,'Retail Sale Id 5009',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 11:24:59','',''),(4731,'1','223','1',1,'Retail Sale Id 5010',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 11:36:56','',''),(4732,'1','223','1',1,'Retail Sale Id 5011',3720.00,0.00,0.00,6.00,192.00,'2022-04-21 11:39:19','',''),(4733,'1','223','1',1,'Retail Sale Id 5012',3100.00,0.00,0.00,5.00,160.00,'2022-04-21 11:44:54','',''),(4734,'1','223','1',1,'Retail Sale Id 5013',9300.00,0.00,0.00,15.00,480.00,'2022-04-21 12:03:10','',''),(4735,'1','223','1',1,'Retail Sale Id 5014',6851.00,0.00,0.00,11.05,353.60,'2022-04-21 12:06:10','',''),(4736,'1','223','1',1,'Retail Sale Id 5015',2480.00,0.00,0.00,4.00,128.00,'2022-04-21 12:23:00','',''),(4737,'1','223','1',1,'Retail Sale Id 5016',2480.00,0.00,0.00,4.00,128.00,'2022-04-21 12:23:55','',''),(4738,'1','223','1',1,'Retail Sale Id 5017',2498.60,0.00,0.00,4.03,128.96,'2022-04-21 12:27:53','',''),(4739,'1','223','1',1,'Retail Sale Id 5018',3100.00,0.00,0.00,5.00,160.00,'2022-04-21 12:41:02','',''),(4740,'1','223','1',1,'Retail Sale Id 5019',1897.20,0.00,0.00,3.06,97.92,'2022-04-21 12:44:07','',''),(4741,'1','223','1',1,'Retail Sale Id 5020',24000.00,0.00,0.00,40.00,480.00,'2022-04-21 13:00:25','',''),(4742,'1','223','1',1,'Retail Sale Id 5021',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 13:13:16','',''),(4743,'1','223','1',1,'Retail Sale Id 5022',1202.80,0.00,0.00,1.94,62.08,'2022-04-21 13:17:39','',''),(4744,'1','223','1',1,'Retail Sale Id 5023',3503.00,0.00,0.00,5.65,180.80,'2022-04-21 13:22:24','',''),(4745,'1','223','1',1,'Retail Sale Id 5024',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 13:25:09','',''),(4746,'1','223','1',1,'Retail Sale Id 5025',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 13:33:00','',''),(4747,'1','223','1',1,'Retail Sale Id 5026',3000.80,0.00,0.00,4.84,154.88,'2022-04-21 13:40:06','',''),(4748,'1','223','1',1,'Retail Sale Id 5027',3720.00,0.00,0.00,6.00,192.00,'2022-04-21 13:44:42','',''),(4749,'1','223','1',1,'Retail Sale Id 5028',7750.00,0.00,0.00,12.50,400.00,'2022-04-21 13:47:07','',''),(4750,'1','223','1',1,'Retail Sale Id 5030',3999.00,0.00,0.00,6.45,206.40,'2022-04-21 13:51:53','',''),(4751,'1','223','1',1,'Retail Sale Id 5031',1847.60,0.00,0.00,2.98,95.36,'2022-04-21 14:04:00','',''),(4752,'1','223','1',1,'Retail Sale Id 5032',3100.00,0.00,0.00,5.00,160.00,'2022-04-21 14:31:22','',''),(4753,'1','223','1',1,'Retail Sale Id 5033',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 14:32:08','',''),(4754,'1','223','1',1,'Retail Sale Id 5034',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 14:43:00','',''),(4755,'1','223','1',1,'Retail Sale Id 5035',2498.60,0.00,0.00,4.03,128.96,'2022-04-21 14:44:37','',''),(4756,'1','223','1',1,'Retail Sale Id 5036',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 14:50:23','',''),(4757,'1','223','1',1,'Retail Sale Id 5037',2480.00,0.00,0.00,4.00,128.00,'2022-04-21 14:53:30','',''),(4758,'1','223','1',1,'Retail Sale Id 5038',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 14:54:30','',''),(4759,'1','223','1',1,'Retail Sale Id 5039',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 15:04:51','',''),(4760,'1','223','1',1,'Retail Sale Id 5040',1897.20,0.00,0.00,3.06,97.92,'2022-04-21 15:08:36','',''),(4761,'1','223','1',1,'Retail Sale Id 5041',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 15:09:42','',''),(4762,'1','223','1',1,'Retail Sale Id 5042',1897.20,0.00,0.00,3.06,97.92,'2022-04-21 15:16:22','',''),(4763,'1','223','1',1,'Retail Sale Id 5043',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 15:17:04','',''),(4764,'1','223','1',1,'Retail Sale Id 5044',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 15:22:30','',''),(4765,'1','223','1',1,'Retail Sale Id 5045',1897.20,0.00,0.00,3.06,97.92,'2022-04-21 15:25:15','',''),(4766,'1','223','1',1,'Retail Sale Id 5046',651.00,0.00,0.00,1.05,33.60,'2022-04-21 15:38:52','',''),(4767,'1','223','1',1,'Retail Sale Id 5047',651.00,0.00,0.00,1.05,33.60,'2022-04-21 15:43:20','',''),(4768,'1','223','1',1,'Retail Sale Id 5048',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 15:45:24','',''),(4769,'1','223','1',1,'Retail Sale Id 5049',502.20,0.00,0.00,0.81,25.92,'2022-04-21 15:46:26','',''),(4770,'1','223','1',1,'Retail Sale Id 5050',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 15:50:43','',''),(4771,'1','223','1',1,'Retail Sale Id 5051',651.00,0.00,0.00,1.05,33.60,'2022-04-21 15:52:15','',''),(4772,'1','223','1',1,'Retail Sale Id 5052',3701.40,0.00,0.00,5.97,191.04,'2022-04-21 15:53:14','',''),(4773,'1','223','1',1,'Retail Sale Id 5053',36000.00,0.00,0.00,60.00,720.00,'2022-04-21 16:12:48','',''),(4774,'1','223','1',1,'Retail Sale Id 5054',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 16:13:48','',''),(4775,'1','223','1',1,'Retail Sale Id 5055',3720.00,0.00,0.00,6.00,192.00,'2022-04-21 16:31:11','',''),(4776,'1','223','1',1,'Retail Sale Id 5056',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 16:32:14','',''),(4777,'1','223','1',1,'Retail Sale Id 5057',2002.60,0.00,0.00,3.23,103.36,'2022-04-21 16:33:34','',''),(4778,'1','223','1',1,'Retail Sale Id 5059',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 16:34:48','',''),(4779,'1','223','1',1,'Retail Sale Id 5060',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 16:35:55','',''),(4780,'1','223','1',1,'Retail Sale Id 5061',998.20,0.00,0.00,1.61,51.52,'2022-04-21 16:37:40','',''),(4781,'1','223','1',1,'Retail Sale Id 5062',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 16:39:38','',''),(4782,'1','223','1',1,'Retail Sale Id 5063',3720.00,0.00,0.00,6.00,192.00,'2022-04-21 16:40:39','',''),(4783,'1','223','1',1,'Retail Sale Id 5064',566100.00,0.00,0.00,943.50,11322.00,'2022-04-21 16:44:02','',''),(4784,'1','223','1',1,'Retail Sale Id 5065',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 16:45:51','',''),(4785,'1','223','1',1,'Retail Sale Id 5066',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 16:47:31','',''),(4786,'1','223','1',1,'Retail Sale Id 5067',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 16:48:42','',''),(4787,'1','223','1',1,'Retail Sale Id 5068',620.00,0.00,0.00,1.00,32.00,'2022-04-21 16:55:01','',''),(4788,'1','223','1',1,'Retail Sale Id 5069',3720.00,0.00,0.00,6.00,192.00,'2022-04-21 16:56:31','',''),(4789,'1','223','1',1,'Retail Sale Id 5070',1748.40,0.00,0.00,2.82,90.24,'2022-04-21 16:57:48','',''),(4790,'1','223','1',1,'Retail Sale Id 5071',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 17:04:05','',''),(4791,'1','223','1',1,'Retail Sale Id 5072',1240.00,0.00,0.00,2.00,64.00,'2022-04-21 17:05:10','',''),(4792,'1','223','1',1,'Retail Sale Id 5073',2480.00,0.00,0.00,4.00,128.00,'2022-04-21 17:07:11','',''),(4793,'1','223','1',1,'Retail Sale Id 5074',2002.60,0.00,0.00,3.23,103.36,'2022-04-21 17:08:16','',''),(4794,'1','223','1',1,'Retail Sale Id 5075',651.00,0.00,0.00,1.05,33.60,'2022-04-21 17:17:15','',''),(4795,'1','223','1',1,'Retail Sale Id 5076',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 17:20:54','',''),(4796,'1','223','1',1,'Retail Sale Id 5078',1897.20,0.00,0.00,3.06,97.92,'2022-04-21 17:22:22','',''),(4797,'1','223','1',1,'Retail Sale Id 5079',3751.00,0.00,0.00,6.05,193.60,'2022-04-21 17:26:31','',''),(4798,'1','223','1',1,'Retail Sale Id 5080',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 17:28:28','',''),(4799,'1','223','1',1,'Retail Sale Id 5081',30000.00,0.00,0.00,50.00,600.00,'2022-04-21 17:31:46','',''),(4800,'1','223','1',1,'Retail Sale Id 5082',998.20,0.00,0.00,1.61,51.52,'2022-04-21 17:35:46','',''),(4801,'1','223','1',1,'Retail Sale Id 5083',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 17:47:10','',''),(4802,'1','223','1',1,'Retail Sale Id 5084',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 17:50:54','',''),(4803,'1','223','1',1,'Retail Sale Id 5085',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 17:52:18','',''),(4804,'1','223','1',1,'Retail Sale Id 5086',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 17:53:28','',''),(4805,'1','223','1',1,'Retail Sale Id 5087',998.20,0.00,0.00,1.61,51.52,'2022-04-21 17:56:22','',''),(4806,'1','223','1',1,'Retail Sale Id 5088',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 18:02:13','',''),(4807,'1','223','1',1,'Retail Sale Id 5089',1202.80,0.00,0.00,1.94,62.08,'2022-04-21 18:02:58','',''),(4808,'1','223','1',1,'Retail Sale Id 5090',3000.80,0.00,0.00,4.84,154.88,'2022-04-21 18:03:53','',''),(4809,'1','223','1',1,'Retail Sale Id 5091',1302.00,0.00,0.00,2.10,67.20,'2022-04-21 18:04:59','',''),(4810,'1','223','1',1,'Retail Sale Id 5092',3720.00,0.00,0.00,6.00,192.00,'2022-04-21 18:07:14','',''),(4811,'1','223','1',1,'Retail Sale Id 5093',998.20,0.00,0.00,1.61,51.52,'2022-04-21 18:08:29','',''),(4812,'1','223','1',1,'Retail Sale Id 5094',1847.60,0.00,0.00,2.98,95.36,'2022-04-21 18:09:35','',''),(4813,'1','223','1',1,'Retail Sale Id 5095',1252.40,0.00,0.00,2.02,64.64,'2022-04-21 18:11:38','',''),(4814,'1','223','1',1,'Retail Sale Id 5096',1847.60,0.00,0.00,2.98,95.36,'2022-04-21 18:12:43','',''),(4815,'1','223','1',1,'Retail Sale Id 5097',1847.60,0.00,0.00,2.98,95.36,'2022-04-21 18:19:07','',''),(4816,'1','223','1',1,'Retail Sale Id 5098',1500.40,0.00,0.00,2.42,77.44,'2022-04-21 18:23:01','',''),(4817,'1','223','1',1,'Retail Sale Id 5100',998.20,0.00,0.00,1.61,51.52,'2022-04-21 18:24:26','',''),(4818,'1','223','1',1,'Retail Sale Id 5101',1860.00,0.00,0.00,3.00,96.00,'2022-04-21 18:26:21','',''),(4819,'1','223','1',1,'Retail Sale Id 5102',2480.00,0.00,0.00,4.00,128.00,'2022-04-21 18:27:33','',''),(4820,'1','223','1',1,'Retail Sale Id 5103',3720.00,0.00,0.00,6.00,192.00,'2022-04-21 18:33:58','',''),(4821,'1','223','1',1,'Retail Sale Id 5104',192.20,0.00,0.00,0.31,9.92,'2022-04-21 21:01:40','',''),(4822,'1','223','1',1,'Retail Sale Id 5105',35400.00,0.00,0.00,59.00,708.00,'2022-04-21 21:02:27','',''),(4823,'1','223','1',1,'Retail Sale Id 5106',5697.80,0.00,0.00,9.19,294.08,'2022-04-22 07:08:31','',''),(4824,'1','223','1',1,'Retail Sale Id 5107',60000.00,0.00,0.00,100.00,1200.00,'2022-04-22 07:09:49','',''),(4825,'1','223','1',1,'Retail Sale Id 5108',3751.00,0.00,0.00,6.05,193.60,'2022-04-22 07:32:02','',''),(4826,'1','223','1',1,'Retail Sale Id 5109',3720.00,0.00,0.00,6.00,192.00,'2022-04-22 07:55:57','',''),(4827,'1','223','1',1,'Retail Sale Id 5110',3100.00,0.00,0.00,5.00,160.00,'2022-04-22 07:58:33','',''),(4828,'1','223','1',1,'Retail Sale Id 5111',3100.00,0.00,0.00,5.00,160.00,'2022-04-22 08:02:06','',''),(4829,'1','223','1',1,'Retail Sale Id 5112',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 08:04:16','',''),(4830,'1','223','1',1,'Retail Sale Id 5113',1872.40,0.00,0.00,3.02,96.64,'2022-04-22 08:12:06','',''),(4831,'1','223','1',1,'Retail Sale Id 5114',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 08:28:22','',''),(4832,'1','223','1',1,'Retail Sale Id 5115',142500.00,0.00,0.00,237.50,2850.00,'2022-04-22 08:32:08','',''),(4833,'1','223','1',1,'Retail Sale Id 5116',1401.20,0.00,0.00,2.26,72.32,'2022-04-22 08:33:07','',''),(4834,'1','223','1',1,'Retail Sale Id 5117',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 08:34:00','',''),(4835,'1','223','1',1,'Retail Sale Id 5118',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 08:36:25','',''),(4836,'1','223','1',1,'Retail Sale Id 5119',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 08:37:12','',''),(4837,'1','223','1',1,'Retail Sale Id 5120',3720.00,0.00,0.00,6.00,192.00,'2022-04-22 08:38:51','',''),(4838,'1','223','1',1,'Retail Sale Id 5121',998.20,0.00,0.00,1.61,51.52,'2022-04-22 08:50:30','',''),(4839,'1','223','1',1,'Retail Sale Id 5122',1500.40,0.00,0.00,2.42,77.44,'2022-04-22 08:58:02','',''),(4840,'1','223','1',1,'Retail Sale Id 5123',6200.00,0.00,0.00,10.00,320.00,'2022-04-22 09:06:27','',''),(4841,'1','223','1',1,'Retail Sale Id 5124',2002.60,0.00,0.00,3.23,103.36,'2022-04-22 09:10:20','',''),(4842,'1','223','1',1,'Retail Sale Id 5125',24000.00,0.00,0.00,40.00,480.00,'2022-04-22 09:11:26','',''),(4843,'1','223','1',1,'Retail Sale Id 5126',6200.00,0.00,0.00,10.00,320.00,'2022-04-22 09:12:23','',''),(4844,'1','223','1',1,'Retail Sale Id 5127',998.20,0.00,0.00,1.61,51.52,'2022-04-22 09:13:00','',''),(4845,'1','223','1',1,'Retail Sale Id 5128',3100.00,0.00,0.00,5.00,160.00,'2022-04-22 09:13:30','',''),(4846,'1','223','1',1,'Retail Sale Id 5130',620.00,0.00,0.00,1.00,32.00,'2022-04-22 09:21:18','',''),(4847,'1','223','1',1,'Retail Sale Id 5131',1798.00,0.00,0.00,2.90,92.80,'2022-04-22 09:29:11','',''),(4848,'1','223','1',1,'Retail Sale Id 5132',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 09:31:06','',''),(4849,'1','223','1',1,'Retail Sale Id 5133',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 09:58:54','',''),(4850,'1','223','1',1,'Retail Sale Id 5134',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 10:00:35','',''),(4851,'1','223','1',1,'Retail Sale Id 5135',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 10:07:16','',''),(4852,'1','223','1',1,'Retail Sale Id 5136',1240.00,0.00,0.00,2.00,64.00,'2022-04-22 10:53:40','',''),(4853,'1','223','1',1,'Retail Sale Id 5137',1240.00,0.00,0.00,2.00,64.00,'2022-04-22 10:54:43','',''),(4854,'1','223','1',1,'Retail Sale Id 5138',1240.00,0.00,0.00,2.00,64.00,'2022-04-22 10:55:14','',''),(4855,'1','223','1',1,'Retail Sale Id 5139',2002.60,0.00,0.00,3.23,103.36,'2022-04-22 11:19:39','',''),(4856,'1','223','1',1,'Retail Sale Id 5140',1240.00,0.00,0.00,2.00,64.00,'2022-04-22 11:28:08','',''),(4857,'1','223','1',1,'Return of Retail Sale Id 5140',0.00,1240.00,2.00,0.00,-64.00,'2022-04-22 11:29:21','',''),(4858,'1','223','1',1,'Retail Sale Id 5141',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 11:29:39','',''),(4859,'1','223','1',1,'Retail Sale Id 5142',3100.00,0.00,0.00,5.00,160.00,'2022-04-22 11:52:34','',''),(4860,'1','223','1',1,'Retail Sale Id 5144',998.20,0.00,0.00,1.61,51.52,'2022-04-22 12:01:28','',''),(4861,'1','223','1',1,'Retail Sale Id 5145',1897.20,0.00,0.00,3.06,97.92,'2022-04-22 12:14:26','',''),(4862,'1','223','1',1,'Retail Sale Id 5146',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 12:20:54','',''),(4863,'1','223','1',1,'Retail Sale Id 5147',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 12:40:25','',''),(4864,'1','223','1',1,'Retail Sale Id 5148',5580.00,0.00,0.00,9.00,288.00,'2022-04-22 13:30:38','',''),(4865,'1','223','1',1,'Retail Sale Id 5149',3720.00,0.00,0.00,6.00,192.00,'2022-04-22 13:57:35','',''),(4866,'1','223','1',1,'Retail Sale Id 5150',2498.60,0.00,0.00,4.03,128.96,'2022-04-22 14:07:30','',''),(4867,'1','223','1',1,'Retail Sale Id 5151',6200.00,0.00,0.00,10.00,320.00,'2022-04-22 14:11:37','',''),(4868,'1','223','1',1,'Retail Sale Id 5152',651.00,0.00,0.00,1.05,33.60,'2022-04-22 14:33:40','',''),(4869,'1','223','1',1,'Retail Sale Id 5153',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 14:54:39','',''),(4870,'1','223','1',1,'Retail Sale Id 5154',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 14:55:33','',''),(4871,'1','223','1',1,'Retail Sale Id 5155',700.60,0.00,0.00,1.13,36.16,'2022-04-22 14:58:27','',''),(4872,'1','223','1',1,'Retail Sale Id 5156',1847.60,0.00,0.00,2.98,95.36,'2022-04-22 15:02:12','',''),(4873,'1','223','1',1,'Retail Sale Id 5157',3720.00,0.00,0.00,6.00,192.00,'2022-04-22 15:03:09','',''),(4874,'1','223','1',1,'Retail Sale Id 5159',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 15:12:45','',''),(4875,'1','223','1',1,'Retail Sale Id 5160',3000.80,0.00,0.00,4.84,154.88,'2022-04-22 15:24:50','',''),(4876,'1','223','1',1,'Retail Sale Id 5161',7750.00,0.00,0.00,12.50,400.00,'2022-04-22 15:44:00','',''),(4877,'1','223','1',1,'Retail Sale Id 5162',3100.00,0.00,0.00,5.00,160.00,'2022-04-22 15:45:14','',''),(4878,'1','223','1',1,'Retail Sale Id 5163',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 15:49:55','',''),(4879,'1','223','1',1,'Retail Sale Id 5164',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 15:58:13','',''),(4880,'1','223','1',1,'Retail Sale Id 5165',3720.00,0.00,0.00,6.00,192.00,'2022-04-22 15:59:14','',''),(4881,'1','223','1',1,'Retail Sale Id 5166',1847.60,0.00,0.00,2.98,95.36,'2022-04-22 16:00:36','',''),(4882,'1','223','1',1,'Retail Sale Id 5167',651.00,0.00,0.00,1.05,33.60,'2022-04-22 16:03:53','',''),(4883,'1','223','1',1,'Retail Sale Id 5168',998.20,0.00,0.00,1.61,51.52,'2022-04-22 16:06:03','',''),(4884,'1','223','1',1,'Retail Sale Id 5169',3100.00,0.00,0.00,5.00,160.00,'2022-04-22 16:19:55','',''),(4885,'1','223','1',1,'Retail Sale Id 5170',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 16:34:38','',''),(4886,'1','223','1',1,'Retail Sale Id 5171',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 16:35:24','',''),(4887,'1','223','1',1,'Retail Sale Id 5172',7477.20,0.00,0.00,12.06,385.92,'2022-04-22 16:37:11','',''),(4888,'1','223','1',1,'Retail Sale Id 5173',7750.00,0.00,0.00,12.50,400.00,'2022-04-22 16:38:39','',''),(4889,'1','223','1',1,'Retail Sale Id 5174',6820.00,0.00,0.00,11.00,352.00,'2022-04-22 16:41:34','',''),(4890,'1','223','1',1,'Retail Sale Id 5175',998.20,0.00,0.00,1.61,51.52,'2022-04-22 16:43:50','',''),(4891,'1','223','1',1,'Retail Sale Id 5176',1897.20,0.00,0.00,3.06,97.92,'2022-04-22 16:46:16','',''),(4892,'1','223','1',1,'Retail Sale Id 5177',2498.60,0.00,0.00,4.03,128.96,'2022-04-22 16:48:16','',''),(4893,'1','223','1',1,'Retail Sale Id 5178',7750.00,0.00,0.00,12.50,400.00,'2022-04-22 16:50:21','',''),(4894,'1','223','1',1,'Retail Sale Id 5179',1698.80,0.00,0.00,2.74,87.68,'2022-04-22 16:54:05','',''),(4895,'1','223','1',1,'Retail Sale Id 5180',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 17:00:58','',''),(4896,'1','223','1',1,'Retail Sale Id 5181',1302.00,0.00,0.00,2.10,67.20,'2022-04-22 17:03:54','',''),(4897,'1','223','1',1,'Retail Sale Id 5183',1221.40,0.00,0.00,1.97,63.04,'2022-04-22 17:07:39','',''),(4898,'1','223','1',1,'Retail Sale Id 5184',1897.20,0.00,0.00,3.06,97.92,'2022-04-22 17:09:36','',''),(4899,'1','223','1',1,'Retail Sale Id 5185',998.20,0.00,0.00,1.61,51.52,'2022-04-22 17:11:42','',''),(4900,'1','223','1',1,'Retail Sale Id 5186',1897.20,0.00,0.00,3.06,97.92,'2022-04-22 17:18:36','',''),(4901,'1','223','1',1,'Retail Sale Id 5187',3720.00,0.00,0.00,6.00,192.00,'2022-04-22 17:20:37','',''),(4902,'1','223','1',1,'Retail Sale Id 5188',2498.60,0.00,0.00,4.03,128.96,'2022-04-22 17:21:43','',''),(4903,'1','223','1',1,'Retail Sale Id 5189',998.20,0.00,0.00,1.61,51.52,'2022-04-22 17:23:38','',''),(4904,'1','223','1',1,'Return of Retail Sale Id 5189',0.00,998.20,1.61,0.00,-51.52,'2022-04-22 17:24:27','',''),(4905,'1','223','1',1,'Retail Sale Id 5190',700.60,0.00,0.00,1.13,36.16,'2022-04-22 17:24:58','',''),(4906,'1','223','1',1,'Retail Sale Id 5191',998.20,0.00,0.00,1.61,51.52,'2022-04-22 17:26:35','',''),(4907,'1','223','1',1,'Retail Sale Id 5192',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 17:27:31','',''),(4908,'1','223','1',1,'Retail Sale Id 5193',3100.00,0.00,0.00,5.00,160.00,'2022-04-22 17:28:26','',''),(4909,'1','223','1',1,'Retail Sale Id 5194',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 17:29:25','',''),(4910,'1','223','1',1,'Retail Sale Id 5195',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 17:30:58','',''),(4911,'1','223','1',1,'Retail Sale Id 5196',1202.80,0.00,0.00,1.94,62.08,'2022-04-22 17:35:39','',''),(4912,'1','223','1',1,'Retail Sale Id 5197',2498.60,0.00,0.00,4.03,128.96,'2022-04-22 17:36:33','',''),(4913,'1','223','1',1,'Retail Sale Id 5198',1202.80,0.00,0.00,1.94,62.08,'2022-04-22 17:47:24','',''),(4914,'1','223','1',1,'Retail Sale Id 5199',1401.20,0.00,0.00,2.26,72.32,'2022-04-22 17:48:16','',''),(4915,'1','223','1',1,'Retail Sale Id 5200',3000.80,0.00,0.00,4.84,154.88,'2022-04-22 17:49:06','',''),(4916,'1','223','1',1,'Retail Sale Id 5201',1401.20,0.00,0.00,2.26,72.32,'2022-04-22 17:50:14','',''),(4917,'1','223','1',1,'Retail Sale Id 5202',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 17:55:00','',''),(4918,'1','223','1',1,'Retail Sale Id 5203',3701.40,0.00,0.00,5.97,191.04,'2022-04-22 17:58:47','',''),(4919,'1','223','1',1,'Retail Sale Id 5204',6200.00,0.00,0.00,10.00,320.00,'2022-04-22 17:59:45','',''),(4920,'1','223','1',1,'Retail Sale Id 5205',7750.00,0.00,0.00,12.50,400.00,'2022-04-22 18:05:07','',''),(4921,'1','223','1',1,'Retail Sale Id 5206',6200.00,0.00,0.00,10.00,320.00,'2022-04-22 18:08:37','',''),(4922,'1','223','1',1,'Return of Retail Sale Id 5206',0.00,6200.00,10.00,0.00,-320.00,'2022-04-22 18:09:55','',''),(4923,'1','223','1',1,'Retail Sale Id 5207',1240.00,0.00,0.00,2.00,64.00,'2022-04-22 18:11:30','',''),(4924,'1','223','1',1,'Retail Sale Id 5208',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 18:12:32','',''),(4925,'1','223','1',1,'Retail Sale Id 5209',2498.60,0.00,0.00,4.03,128.96,'2022-04-22 18:13:16','',''),(4926,'1','223','1',1,'Retail Sale Id 5210',998.20,0.00,0.00,1.61,51.52,'2022-04-22 18:15:01','',''),(4927,'1','223','1',1,'Retail Sale Id 5211',651.00,0.00,0.00,1.05,33.60,'2022-04-22 18:17:31','',''),(4928,'1','223','1',1,'Retail Sale Id 5212',1252.40,0.00,0.00,2.02,64.64,'2022-04-22 18:19:01','',''),(4929,'1','223','1',1,'Retail Sale Id 5213',2498.60,0.00,0.00,4.03,128.96,'2022-04-22 18:20:08','',''),(4930,'1','223','1',1,'Retail Sale Id 5214',998.20,0.00,0.00,1.61,51.52,'2022-04-22 18:21:48','',''),(4931,'1','223','1',1,'Retail Sale Id 5215',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 18:22:35','',''),(4932,'1','223','1',1,'Retail Sale Id 5216',1860.00,0.00,0.00,3.00,96.00,'2022-04-22 18:27:21','',''),(4933,'1','223','1',1,'Retail Sale Id 5217',1240.00,0.00,0.00,2.00,64.00,'2022-04-22 18:28:53','',''),(4934,'1','223','1',1,'Retail Sale Id 5218',1798.00,0.00,0.00,2.90,92.80,'2022-04-22 18:33:35','',''),(4935,'1','223','1',1,'Retail Sale Id 5219',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 07:04:35','',''),(4936,'1','223','1',1,'Retail Sale Id 5220',799.80,0.00,0.00,1.29,41.28,'2022-04-23 07:42:33','',''),(4937,'1','223','1',1,'Retail Sale Id 5221',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 07:45:06','',''),(4938,'1','223','1',1,'Retail Sale Id 5222',1500.40,0.00,0.00,2.42,77.44,'2022-04-23 07:57:11','',''),(4939,'1','223','1',1,'Retail Sale Id 5223',2002.60,0.00,0.00,3.23,103.36,'2022-04-23 07:58:10','',''),(4940,'1','223','1',1,'Retail Sale Id 5224',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 08:01:25','',''),(4941,'1','223','1',1,'Retail Sale Id 5225',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 08:05:14','',''),(4942,'1','223','1',1,'Retail Sale Id 5226',1798.00,0.00,0.00,2.90,92.80,'2022-04-23 08:06:01','',''),(4943,'1','223','1',1,'Retail Sale Id 5227',3701.40,0.00,0.00,5.97,191.04,'2022-04-23 08:22:52','',''),(4944,'1','223','1',1,'Retail Sale Id 5228',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 08:27:24','',''),(4945,'1','223','1',1,'Retail Sale Id 5229',7750.00,0.00,0.00,12.50,400.00,'2022-04-23 08:32:19','',''),(4946,'1','223','1',1,'Retail Sale Id 5230',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 08:38:56','',''),(4947,'1','223','1',1,'Retail Sale Id 5231',1847.60,0.00,0.00,2.98,95.36,'2022-04-23 08:44:34','',''),(4948,'1','223','1',1,'Retail Sale Id 5232',998.20,0.00,0.00,1.61,51.52,'2022-04-23 08:55:41','',''),(4949,'1','223','1',1,'Retail Sale Id 5233',3751.00,0.00,0.00,6.05,193.60,'2022-04-23 09:04:54','',''),(4950,'1','223','1',1,'Retail Sale Id 5234',6200.00,0.00,0.00,10.00,320.00,'2022-04-23 09:12:09','',''),(4951,'1','223','1',1,'Retail Sale Id 5235',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 09:13:46','',''),(4952,'1','223','1',1,'Retail Sale Id 5236',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 09:22:35','',''),(4953,'1','223','1',1,'Retail Sale Id 5237',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 09:24:03','',''),(4954,'1','223','1',1,'Retail Sale Id 5238',7440.00,0.00,0.00,12.00,384.00,'2022-04-23 09:25:43','',''),(4955,'1','223','1',1,'Retail Sale Id 5239',3751.00,0.00,0.00,6.05,193.60,'2022-04-23 09:29:53','',''),(4956,'1','223','1',1,'Retail Sale Id 5240',1847.60,0.00,0.00,2.98,95.36,'2022-04-23 09:38:09','',''),(4957,'1','223','1',1,'Retail Sale Id 5241',2498.60,0.00,0.00,4.03,128.96,'2022-04-23 09:39:25','',''),(4958,'1','223','1',1,'Retail Sale Id 5242',3720.00,0.00,0.00,6.00,192.00,'2022-04-23 09:44:04','',''),(4959,'1','223','1',1,'Retail Sale Id 5243',1847.60,0.00,0.00,2.98,95.36,'2022-04-23 09:48:17','',''),(4960,'1','223','1',1,'Retail Sale Id 5244',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 09:49:37','',''),(4961,'1','223','1',1,'Retail Sale Id 5245',1401.20,0.00,0.00,2.26,72.32,'2022-04-23 09:51:30','',''),(4962,'1','223','1',1,'Retail Sale Id 5246',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 09:58:52','',''),(4963,'1','223','1',1,'Retail Sale Id 5247',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 10:00:13','',''),(4964,'1','223','1',1,'Return of Retail Sale Id 5247',0.00,1240.00,2.00,0.00,-64.00,'2022-04-23 10:00:42','',''),(4965,'1','223','1',1,'Retail Sale Id 5248',3100.00,0.00,0.00,5.00,160.00,'2022-04-23 10:01:08','',''),(4966,'1','223','1',1,'Retail Sale Id 5249',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 10:07:40','',''),(4967,'1','223','1',1,'Retail Sale Id 5250',1202.80,0.00,0.00,1.94,62.08,'2022-04-23 10:08:28','',''),(4968,'1','223','1',1,'Retail Sale Id 5251',2498.60,0.00,0.00,4.03,128.96,'2022-04-23 10:09:16','',''),(4969,'1','223','1',1,'Retail Sale Id 5252',3100.00,0.00,0.00,5.00,160.00,'2022-04-23 10:10:03','',''),(4970,'1','223','1',1,'Retail Sale Id 5253',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 10:15:28','',''),(4971,'1','223','1',1,'Retail Sale Id 5254',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 10:26:34','',''),(4972,'1','223','1',1,'Retail Sale Id 5255',3100.00,0.00,0.00,5.00,160.00,'2022-04-23 10:28:00','',''),(4973,'1','223','1',1,'Retail Sale Id 5256',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 10:36:39','',''),(4974,'1','223','1',1,'Retail Sale Id 5257',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 10:45:40','',''),(4975,'1','223','1',1,'Retail Sale Id 5258',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 10:48:03','',''),(4976,'1','223','1',1,'Retail Sale Id 5259',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 10:49:40','',''),(4977,'1','223','1',1,'Retail Sale Id 5260',1847.60,0.00,0.00,2.98,95.36,'2022-04-23 10:55:06','',''),(4978,'1','223','1',1,'Retail Sale Id 5261',6999.80,0.00,0.00,11.29,361.28,'2022-04-23 11:07:35','',''),(4979,'1','223','1',1,'Retail Sale Id 5262',3720.00,0.00,0.00,6.00,192.00,'2022-04-23 11:17:43','',''),(4980,'1','223','1',1,'Retail Sale Id 5263',2002.60,0.00,0.00,3.23,103.36,'2022-04-23 11:18:54','',''),(4981,'1','223','1',1,'Retail Sale Id 5264',3100.00,0.00,0.00,5.00,160.00,'2022-04-23 11:19:58','',''),(4982,'1','223','1',1,'Retail Sale Id 5265',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 11:24:31','',''),(4983,'1','223','1',1,'Retail Sale Id 5267',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 11:30:37','',''),(4984,'1','223','1',1,'Retail Sale Id 5268',1847.60,0.00,0.00,2.98,95.36,'2022-04-23 11:32:21','',''),(4985,'1','223','1',1,'Retail Sale Id 5269',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 11:33:46','',''),(4986,'1','223','1',1,'Retail Sale Id 5270',3720.00,0.00,0.00,6.00,192.00,'2022-04-23 11:38:03','',''),(4987,'1','223','1',1,'Retail Sale Id 5271',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 11:39:38','',''),(4988,'1','223','1',1,'Retail Sale Id 5272',3720.00,0.00,0.00,6.00,192.00,'2022-04-23 11:47:24','',''),(4989,'1','223','1',1,'Retail Sale Id 5273',998.20,0.00,0.00,1.61,51.52,'2022-04-23 11:48:54','',''),(4990,'1','223','1',1,'Retail Sale Id 5274',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 11:58:27','',''),(4991,'1','223','1',1,'Retail Sale Id 5275',7750.00,0.00,0.00,12.50,400.00,'2022-04-23 11:59:44','',''),(4992,'1','223','1',1,'Retail Sale Id 5277',5598.60,0.00,0.00,9.03,288.96,'2022-04-23 12:03:33','',''),(4993,'1','223','1',1,'Retail Sale Id 5278',6801.40,0.00,0.00,10.97,351.04,'2022-04-23 12:06:00','',''),(4994,'1','223','1',1,'Retail Sale Id 5279',3720.00,0.00,0.00,6.00,192.00,'2022-04-23 12:06:56','',''),(4995,'1','223','1',1,'Retail Sale Id 5280',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 12:08:29','',''),(4996,'1','223','1',1,'Retail Sale Id 5281',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 12:17:10','',''),(4997,'1','223','1',1,'Retail Sale Id 5282',6200.00,0.00,0.00,10.00,320.00,'2022-04-23 12:24:31','',''),(4998,'1','223','1',1,'Retail Sale Id 5283',1202.80,0.00,0.00,1.94,62.08,'2022-04-23 12:29:02','',''),(4999,'1','223','1',1,'Retail Sale Id 5284',3100.00,0.00,0.00,5.00,160.00,'2022-04-23 12:41:34','',''),(5000,'1','223','1',1,'Retail Sale Id 5285',28200.00,0.00,0.00,47.00,564.00,'2022-04-23 13:05:12','',''),(5001,'1','223','1',1,'Retail Sale Id 5286',998.20,0.00,0.00,1.61,51.52,'2022-04-23 13:11:00','',''),(5002,'1','223','1',1,'Retail Sale Id 5287',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 13:13:38','',''),(5003,'1','223','1',1,'Retail Sale Id 5288',20400.00,0.00,0.00,34.00,408.00,'2022-04-23 14:17:42','',''),(5004,'1','223','1',1,'Retail Sale Id 5289',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 14:27:05','',''),(5005,'1','223','1',1,'Retail Sale Id 5290',7750.00,0.00,0.00,12.50,400.00,'2022-04-23 14:30:44','',''),(5006,'1','223','1',1,'Retail Sale Id 5291',651.00,0.00,0.00,1.05,33.60,'2022-04-23 14:39:56','',''),(5007,'1','223','1',1,'Retail Sale Id 5292',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 14:41:56','',''),(5008,'1','223','1',1,'Retail Sale Id 5293',998.20,0.00,0.00,1.61,51.52,'2022-04-23 14:47:05','',''),(5009,'1','223','1',1,'Retail Sale Id 5294',2002.60,0.00,0.00,3.23,103.36,'2022-04-23 15:27:41','',''),(5010,'1','223','1',1,'Retail Sale Id 5295',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 15:29:55','',''),(5011,'1','223','1',1,'Retail Sale Id 5296',1798.00,0.00,0.00,2.90,92.80,'2022-04-23 15:30:43','',''),(5012,'1','223','1',1,'Retail Sale Id 5297',998.20,0.00,0.00,1.61,51.52,'2022-04-23 15:31:32','',''),(5013,'1','223','1',1,'Retail Sale Id 5298',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 15:59:27','',''),(5014,'1','223','1',1,'Retail Sale Id 5299',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 15:59:56','',''),(5015,'1','223','1',1,'Retail Sale Id 5300',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 16:00:45','',''),(5016,'1','223','1',1,'Retail Sale Id 5301',998.20,0.00,0.00,1.61,51.52,'2022-04-23 16:01:23','',''),(5017,'1','223','1',1,'Retail Sale Id 5302',651.00,0.00,0.00,1.05,33.60,'2022-04-23 16:13:21','',''),(5018,'1','223','1',1,'Retail Sale Id 5303',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 16:21:46','',''),(5019,'1','223','1',1,'Retail Sale Id 5305',502.20,0.00,0.00,0.81,25.92,'2022-04-23 16:22:57','',''),(5020,'1','223','1',1,'Retail Sale Id 5306',799.80,0.00,0.00,1.29,41.28,'2022-04-23 16:26:31','',''),(5021,'1','223','1',1,'Retail Sale Id 5307',1302.00,0.00,0.00,2.10,67.20,'2022-04-23 16:29:08','',''),(5022,'1','223','1',1,'Retail Sale Id 5308',3720.00,0.00,0.00,6.00,192.00,'2022-04-23 16:30:59','',''),(5023,'1','223','1',1,'Retail Sale Id 5309',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 16:38:29','',''),(5024,'1','223','1',1,'Retail Sale Id 5310',3100.00,0.00,0.00,5.00,160.00,'2022-04-23 16:39:00','',''),(5025,'1','223','1',1,'Retail Sale Id 5311',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 16:40:14','',''),(5026,'1','223','1',1,'Retail Sale Id 5312',620.00,0.00,0.00,1.00,32.00,'2022-04-23 16:40:48','',''),(5027,'1','223','1',1,'Retail Sale Id 5313',799.80,0.00,0.00,1.29,41.28,'2022-04-23 16:42:22','',''),(5028,'1','223','1',1,'Retail Sale Id 5314',1240.00,0.00,0.00,2.00,64.00,'2022-04-23 16:46:19','',''),(5029,'1','223','1',1,'Return of Retail Sale Id 5314',0.00,1240.00,2.00,0.00,-64.00,'2022-04-23 16:46:35','',''),(5030,'1','223','1',1,'Retail Sale Id 5316',1202.80,0.00,0.00,1.94,62.08,'2022-04-23 16:46:54','',''),(5031,'1','223','1',1,'Retail Sale Id 5319',1847.60,0.00,0.00,2.98,95.36,'2022-04-23 16:55:44','',''),(5032,'1','223','1',1,'Retail Sale Id 5320',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 17:01:51','',''),(5033,'1','223','1',1,'Retail Sale Id 5321',2480.00,0.00,0.00,4.00,128.00,'2022-04-23 17:02:20','',''),(5034,'1','223','1',1,'Retail Sale Id 5322',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 17:05:36','',''),(5035,'1','223','1',1,'Retail Sale Id 5323',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 17:12:19','',''),(5036,'1','223','1',1,'Retail Sale Id 5324',502.20,0.00,0.00,0.81,25.92,'2022-04-23 17:16:30','',''),(5037,'1','223','1',1,'Retail Sale Id 5325',3100.00,0.00,0.00,5.00,160.00,'2022-04-23 17:24:27','',''),(5038,'1','223','1',1,'Retail Sale Id 5326',1500.40,0.00,0.00,2.42,77.44,'2022-04-23 17:25:25','',''),(5039,'1','223','1',1,'Retail Sale Id 5329',7750.00,0.00,0.00,12.50,400.00,'2022-04-23 17:26:19','',''),(5040,'1','223','1',1,'Retail Sale Id 5330',2480.00,0.00,0.00,4.00,128.00,'2022-04-23 17:27:13','',''),(5041,'1','223','1',1,'Retail Sale Id 5331',2498.60,0.00,0.00,4.03,128.96,'2022-04-23 17:33:11','',''),(5042,'1','223','1',1,'Retail Sale Id 5332',1798.00,0.00,0.00,2.90,92.80,'2022-04-23 17:35:24','',''),(5043,'1','223','1',1,'Retail Sale Id 5333',998.20,0.00,0.00,1.61,51.52,'2022-04-23 17:35:55','',''),(5044,'1','223','1',1,'Retail Sale Id 5334',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 17:44:08','',''),(5045,'1','223','1',1,'Retail Sale Id 5335',3100.00,0.00,0.00,5.00,160.00,'2022-04-23 17:44:37','',''),(5046,'1','223','1',1,'Retail Sale Id 5336',1302.00,0.00,0.00,2.10,67.20,'2022-04-23 17:45:40','',''),(5047,'1','223','1',1,'Retail Sale Id 5337',2498.60,0.00,0.00,4.03,128.96,'2022-04-23 17:48:15','',''),(5048,'1','223','1',1,'Retail Sale Id 5338',3720.00,0.00,0.00,6.00,192.00,'2022-04-23 17:56:07','',''),(5049,'1','223','1',1,'Retail Sale Id 5339',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 17:57:06','',''),(5050,'1','223','1',1,'Retail Sale Id 5340',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 17:59:56','',''),(5051,'1','223','1',1,'Retail Sale Id 5341',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 18:02:06','',''),(5052,'1','223','1',1,'Retail Sale Id 5342',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 18:05:48','',''),(5053,'1','223','1',1,'Retail Sale Id 5343',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 18:07:16','',''),(5054,'1','223','1',1,'Retail Sale Id 5344',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 18:09:16','',''),(5055,'1','223','1',1,'Retail Sale Id 5345',1860.00,0.00,0.00,3.00,96.00,'2022-04-23 18:10:35','',''),(5056,'1','223','1',1,'Retail Sale Id 5347',3800.60,0.00,0.00,6.13,196.16,'2022-04-23 18:14:51','',''),(5057,'1','223','1',1,'Retail Sale Id 5348',1252.40,0.00,0.00,2.02,64.64,'2022-04-23 18:19:46','',''),(5058,'1','223','1',1,'Retail Sale Id 5349',2498.60,0.00,0.00,4.03,128.96,'2022-04-23 18:20:41','',''),(5059,'1','223','1',1,'Retail Sale Id 5350',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 18:24:48','',''),(5060,'1','223','1',1,'Retail Sale Id 5351',3720.00,0.00,0.00,6.00,192.00,'2022-04-23 18:25:46','',''),(5061,'1','223','1',1,'Retail Sale Id 5352',1897.20,0.00,0.00,3.06,97.92,'2022-04-23 18:28:53','',''),(5062,'1','223','1',1,'Retail Sale Id 5353',1872.40,0.00,0.00,3.02,96.64,'2022-04-23 18:31:55','',''),(5063,'1','223','1',1,'Retail Sale Id 5354',2480.00,0.00,0.00,4.00,128.00,'2022-04-23 18:32:43','',''),(5064,'1','223','1',1,'Retail Sale Id 5355',1500.40,0.00,0.00,2.42,77.44,'2022-04-23 18:34:40','',''),(5065,'1','223','1',1,'Retail Sale Id 5356',1500.40,0.00,0.00,2.42,77.44,'2022-04-23 18:37:02','',''),(5066,'1','223','1',1,'Retail Sale Id 5357',1202.80,0.00,0.00,1.94,62.08,'2022-04-23 18:37:26','',''),(5067,'1','223','1',1,'Retail Sale Id 5358',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 07:47:03','',''),(5068,'1','223','1',1,'Retail Sale Id 5359',1240.00,0.00,0.00,2.00,64.00,'2022-04-24 07:57:44','',''),(5069,'1','223','1',1,'Retail Sale Id 5360',700.60,0.00,0.00,1.13,36.16,'2022-04-24 08:23:16','',''),(5070,'1','223','1',1,'Retail Sale Id 5361',3751.00,0.00,0.00,6.05,193.60,'2022-04-24 08:33:15','',''),(5071,'1','223','1',1,'Retail Sale Id 5362',998.20,0.00,0.00,1.61,51.52,'2022-04-24 08:37:43','',''),(5072,'1','223','1',1,'Retail Sale Id 5363',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 08:49:38','',''),(5073,'1','223','1',1,'Retail Sale Id 5364',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 08:50:45','',''),(5074,'1','223','1',1,'Retail Sale Id 5365',1500.40,0.00,0.00,2.42,77.44,'2022-04-24 08:53:30','',''),(5075,'1','223','1',1,'Retail Sale Id 5366',998.20,0.00,0.00,1.61,51.52,'2022-04-24 08:58:08','',''),(5076,'1','223','1',1,'Retail Sale Id 5367',2480.00,0.00,0.00,4.00,128.00,'2022-04-24 09:02:54','',''),(5077,'1','223','1',1,'Retail Sale Id 5368',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 09:15:51','',''),(5078,'1','223','1',1,'Retail Sale Id 5369',3701.40,0.00,0.00,5.97,191.04,'2022-04-24 09:28:11','',''),(5079,'1','223','1',1,'Retail Sale Id 5370',3720.00,0.00,0.00,6.00,192.00,'2022-04-24 09:37:12','',''),(5080,'1','223','1',1,'Retail Sale Id 5371',1202.80,0.00,0.00,1.94,62.08,'2022-04-24 09:38:28','',''),(5081,'1','223','1',1,'Retail Sale Id 5372',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 09:41:55','',''),(5082,'1','223','1',1,'Retail Sale Id 5373',1847.60,0.00,0.00,2.98,95.36,'2022-04-24 09:50:39','',''),(5083,'1','223','1',1,'Retail Sale Id 5374',1798.00,0.00,0.00,2.90,92.80,'2022-04-24 09:59:26','',''),(5084,'1','223','1',1,'Retail Sale Id 5375',1897.20,0.00,0.00,3.06,97.92,'2022-04-24 10:01:53','',''),(5085,'1','223','1',1,'Retail Sale Id 5376',2498.60,0.00,0.00,4.03,128.96,'2022-04-24 10:09:34','',''),(5086,'1','223','1',1,'Retail Sale Id 5377',1798.00,0.00,0.00,2.90,92.80,'2022-04-24 10:22:17','',''),(5087,'1','223','1',1,'Retail Sale Id 5378',1847.60,0.00,0.00,2.98,95.36,'2022-04-24 10:24:49','',''),(5088,'1','223','1',1,'Retail Sale Id 5379',799.80,0.00,0.00,1.29,41.28,'2022-04-24 10:27:16','',''),(5089,'1','223','1',1,'Retail Sale Id 5380',36000.00,0.00,0.00,60.00,720.00,'2022-04-24 10:28:33','',''),(5090,'1','223','1',1,'Retail Sale Id 5381',2498.60,0.00,0.00,4.03,128.96,'2022-04-24 10:30:26','',''),(5091,'1','223','1',1,'Retail Sale Id 5382',1897.20,0.00,0.00,3.06,97.92,'2022-04-24 10:34:34','',''),(5092,'1','223','1',1,'Retail Sale Id 5384',7799.60,0.00,0.00,12.58,402.56,'2022-04-24 10:40:27','',''),(5093,'1','223','1',1,'Retail Sale Id 5385',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 10:41:30','',''),(5094,'1','223','1',1,'Retail Sale Id 5386',1847.60,0.00,0.00,2.98,95.36,'2022-04-24 10:43:18','',''),(5095,'1','223','1',1,'Retail Sale Id 5387',620.00,0.00,0.00,1.00,32.00,'2022-04-24 10:44:53','',''),(5096,'1','223','1',1,'Retail Sale Id 5388',3100.00,0.00,0.00,5.00,160.00,'2022-04-24 10:51:52','',''),(5097,'1','223','1',1,'Retail Sale Id 5389',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 10:56:06','',''),(5098,'1','223','1',1,'Retail Sale Id 5390',1240.00,0.00,0.00,2.00,64.00,'2022-04-24 10:58:43','',''),(5099,'1','223','1',1,'Retail Sale Id 5391',998.20,0.00,0.00,1.61,51.52,'2022-04-24 11:09:31','',''),(5100,'1','223','1',1,'Retail Sale Id 5392',3100.00,0.00,0.00,5.00,160.00,'2022-04-24 11:14:07','',''),(5101,'1','223','1',1,'Retail Sale Id 5393',4352.40,0.00,0.00,7.02,224.64,'2022-04-24 11:18:23','',''),(5102,'1','223','1',1,'Retail Sale Id 5394',1240.00,0.00,0.00,2.00,64.00,'2022-04-24 11:19:22','',''),(5103,'1','223','1',1,'Retail Sale Id 5395',3701.40,0.00,0.00,5.97,191.04,'2022-04-24 11:20:11','',''),(5104,'1','223','1',1,'Retail Sale Id 5396',998.20,0.00,0.00,1.61,51.52,'2022-04-24 11:24:00','',''),(5105,'1','223','1',1,'Retail Sale Id 5397',3751.00,0.00,0.00,6.05,193.60,'2022-04-24 11:25:26','',''),(5106,'1','223','1',1,'Retail Sale Id 5398',2480.00,0.00,0.00,4.00,128.00,'2022-04-24 11:43:53','',''),(5107,'1','223','1',1,'Retail Sale Id 5399',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 11:44:58','',''),(5108,'1','223','1',1,'Retail Sale Id 5400',3751.00,0.00,0.00,6.05,193.60,'2022-04-24 11:46:22','',''),(5109,'1','223','1',1,'Retail Sale Id 5401',2002.60,0.00,0.00,3.23,103.36,'2022-04-24 11:53:35','',''),(5110,'1','223','1',1,'Retail Sale Id 5402',3751.00,0.00,0.00,6.05,193.60,'2022-04-24 12:04:58','',''),(5111,'1','223','1',1,'Retail Sale Id 5403',799.80,0.00,0.00,1.29,41.28,'2022-04-24 12:06:12','',''),(5112,'1','223','1',1,'Retail Sale Id 5404',3751.00,0.00,0.00,6.05,193.60,'2022-04-24 12:12:06','',''),(5113,'1','223','1',1,'Retail Sale Id 5405',2498.60,0.00,0.00,4.03,128.96,'2022-04-24 12:12:56','',''),(5114,'1','223','1',1,'Retail Sale Id 5406',1847.60,0.00,0.00,2.98,95.36,'2022-04-24 12:13:56','',''),(5115,'1','223','1',1,'Retail Sale Id 5407',2002.60,0.00,0.00,3.23,103.36,'2022-04-24 12:20:53','',''),(5116,'1','223','1',1,'Retail Sale Id 5408',1798.00,0.00,0.00,2.90,92.80,'2022-04-24 12:22:03','',''),(5117,'1','223','1',1,'Retail Sale Id 5409',1798.00,0.00,0.00,2.90,92.80,'2022-04-24 12:24:21','',''),(5118,'1','223','1',1,'Retail Sale Id 5410',1240.00,0.00,0.00,2.00,64.00,'2022-04-24 12:26:46','',''),(5119,'1','223','1',1,'Retail Sale Id 5411',6200.00,0.00,0.00,10.00,320.00,'2022-04-24 12:29:31','',''),(5120,'1','223','1',1,'Retail Sale Id 5412',651.00,0.00,0.00,1.05,33.60,'2022-04-24 12:44:58','',''),(5121,'1','223','1',1,'Retail Sale Id 5413',1897.20,0.00,0.00,3.06,97.92,'2022-04-24 12:48:45','',''),(5122,'1','223','1',1,'Retail Sale Id 5414',1500.40,0.00,0.00,2.42,77.44,'2022-04-24 12:51:47','',''),(5123,'1','223','1',1,'Retail Sale Id 5415',3720.00,0.00,0.00,6.00,192.00,'2022-04-24 12:54:35','',''),(5124,'1','223','1',1,'Retail Sale Id 5416',998.20,0.00,0.00,1.61,51.52,'2022-04-24 13:09:48','',''),(5125,'1','223','1',1,'Retail Sale Id 5417',7750.00,0.00,0.00,12.50,400.00,'2022-04-24 13:17:57','',''),(5126,'1','223','1',1,'Retail Sale Id 5418',3000.80,0.00,0.00,4.84,154.88,'2022-04-24 13:23:46','',''),(5127,'1','223','1',1,'Retail Sale Id 5419',1897.20,0.00,0.00,3.06,97.92,'2022-04-24 13:26:38','',''),(5128,'1','223','1',1,'Retail Sale Id 5420',2480.00,0.00,0.00,4.00,128.00,'2022-04-24 13:29:53','',''),(5129,'1','223','1',1,'Retail Sale Id 5421',998.20,0.00,0.00,1.61,51.52,'2022-04-24 13:30:37','',''),(5130,'1','223','1',1,'Retail Sale Id 5422',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 13:35:36','',''),(5131,'1','223','1',1,'Retail Sale Id 5423',998.20,0.00,0.00,1.61,51.52,'2022-04-24 13:37:53','',''),(5132,'1','223','1',1,'Retail Sale Id 5424',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 13:41:28','',''),(5133,'1','223','1',1,'Retail Sale Id 5425',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 13:42:22','',''),(5134,'1','223','1',1,'Retail Sale Id 5426',7750.00,0.00,0.00,12.50,400.00,'2022-04-24 13:42:49','',''),(5135,'1','223','1',1,'Retail Sale Id 5427',651.00,0.00,0.00,1.05,33.60,'2022-04-24 13:45:28','',''),(5136,'1','223','1',1,'Retail Sale Id 5428',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 13:47:54','',''),(5137,'1','223','1',1,'Retail Sale Id 5429',998.20,0.00,0.00,1.61,51.52,'2022-04-24 13:48:41','',''),(5138,'1','223','1',1,'Retail Sale Id 5430',651.00,0.00,0.00,1.05,33.60,'2022-04-24 13:53:56','',''),(5139,'1','223','1',1,'Retail Sale Id 5431',3720.00,0.00,0.00,6.00,192.00,'2022-04-24 13:54:49','',''),(5140,'1','223','1',1,'Retail Sale Id 5432',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 13:58:22','',''),(5141,'1','223','1',1,'Retail Sale Id 5433',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 13:59:34','',''),(5142,'1','223','1',1,'Retail Sale Id 5434',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 14:03:12','',''),(5143,'1','223','1',1,'Retail Sale Id 5435',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 14:05:59','',''),(5144,'1','223','1',1,'Retail Sale Id 5436',1847.60,0.00,0.00,2.98,95.36,'2022-04-24 14:07:29','',''),(5145,'1','223','1',1,'Retail Sale Id 5437',3751.00,0.00,0.00,6.05,193.60,'2022-04-24 14:12:06','',''),(5146,'1','223','1',1,'Retail Sale Id 5439',1698.80,0.00,0.00,2.74,87.68,'2022-04-24 14:14:39','',''),(5147,'1','223','1',1,'Retail Sale Id 5440',998.20,0.00,0.00,1.61,51.52,'2022-04-24 14:21:11','',''),(5148,'1','223','1',1,'Retail Sale Id 5441',1240.00,0.00,0.00,2.00,64.00,'2022-04-24 14:31:05','',''),(5149,'1','223','1',1,'Retail Sale Id 5442',1302.00,0.00,0.00,2.10,67.20,'2022-04-24 14:37:14','',''),(5150,'1','223','1',1,'Retail Sale Id 5443',1847.60,0.00,0.00,2.98,95.36,'2022-04-24 14:40:15','',''),(5151,'1','223','1',1,'Retail Sale Id 5444',2002.60,0.00,0.00,3.23,103.36,'2022-04-24 14:41:04','',''),(5152,'1','223','1',1,'Retail Sale Id 5445',1847.60,0.00,0.00,2.98,95.36,'2022-04-24 14:42:10','',''),(5153,'1','223','1',1,'Retail Sale Id 5446',620.00,0.00,0.00,1.00,32.00,'2022-04-24 14:45:31','',''),(5154,'1','223','1',1,'Retail Sale Id 5447',1698.80,0.00,0.00,2.74,87.68,'2022-04-24 14:46:40','',''),(5155,'1','223','1',1,'Retail Sale Id 5448',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 14:50:59','',''),(5156,'1','223','1',1,'Retail Sale Id 5449',2498.60,0.00,0.00,4.03,128.96,'2022-04-24 15:15:17','',''),(5157,'1','223','1',1,'Retail Sale Id 5450',1897.20,0.00,0.00,3.06,97.92,'2022-04-24 15:17:29','',''),(5158,'1','223','1',1,'Retail Sale Id 5451',3751.00,0.00,0.00,6.05,193.60,'2022-04-24 15:20:20','',''),(5159,'1','223','1',1,'Retail Sale Id 5452',2498.60,0.00,0.00,4.03,128.96,'2022-04-24 15:32:17','',''),(5160,'1','223','1',1,'Retail Sale Id 5454',998.20,0.00,0.00,1.61,51.52,'2022-04-24 15:33:40','',''),(5161,'1','223','1',1,'Retail Sale Id 5455',2901.60,0.00,0.00,4.68,149.76,'2022-04-24 15:34:13','',''),(5162,'1','223','1',1,'Retail Sale Id 5456',651.00,0.00,0.00,1.05,33.60,'2022-04-24 15:34:54','',''),(5163,'1','223','1',1,'Retail Sale Id 5457',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 15:36:23','',''),(5164,'1','223','1',1,'Retail Sale Id 5458',502.20,0.00,0.00,0.81,25.92,'2022-04-24 15:38:03','',''),(5165,'1','223','1',1,'Retail Sale Id 5459',1798.00,0.00,0.00,2.90,92.80,'2022-04-24 15:38:43','',''),(5166,'1','223','1',1,'Retail Sale Id 5460',1847.60,0.00,0.00,2.98,95.36,'2022-04-24 15:43:17','',''),(5167,'1','223','1',1,'Retail Sale Id 5461',6200.00,0.00,0.00,10.00,320.00,'2022-04-24 15:45:52','',''),(5168,'1','223','1',1,'Retail Sale Id 5462',3720.00,0.00,0.00,6.00,192.00,'2022-04-24 15:52:15','',''),(5169,'1','223','1',1,'Retail Sale Id 5463',2498.60,0.00,0.00,4.03,128.96,'2022-04-24 15:53:03','',''),(5170,'1','223','1',1,'Retail Sale Id 5464',3100.00,0.00,0.00,5.00,160.00,'2022-04-24 15:53:50','',''),(5171,'1','223','1',1,'Retail Sale Id 5465',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 16:03:23','',''),(5172,'1','223','1',1,'Retail Sale Id 5466',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 16:26:29','',''),(5173,'1','223','1',1,'Retail Sale Id 5467',1500.40,0.00,0.00,2.42,77.44,'2022-04-24 16:27:04','',''),(5174,'1','223','1',1,'Retail Sale Id 5468',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 16:30:28','',''),(5175,'1','223','1',1,'Retail Sale Id 5469',620.00,0.00,0.00,1.00,32.00,'2022-04-24 16:31:18','',''),(5176,'1','223','1',1,'Retail Sale Id 5470',1240.00,0.00,0.00,2.00,64.00,'2022-04-24 16:31:52','',''),(5177,'1','223','1',1,'Retail Sale Id 5471',3100.00,0.00,0.00,5.00,160.00,'2022-04-24 16:36:06','',''),(5178,'1','223','1',1,'Retail Sale Id 5472',1500.40,0.00,0.00,2.42,77.44,'2022-04-24 16:38:42','',''),(5179,'1','223','1',1,'Retail Sale Id 5473',1500.40,0.00,0.00,2.42,77.44,'2022-04-24 16:39:11','',''),(5180,'1','223','1',1,'Retail Sale Id 5474',799.80,0.00,0.00,1.29,41.28,'2022-04-24 16:39:49','',''),(5181,'1','223','1',1,'Retail Sale Id 5475',1240.00,0.00,0.00,2.00,64.00,'2022-04-24 16:41:48','',''),(5182,'1','223','1',1,'Retail Sale Id 5477',1500.40,0.00,0.00,2.42,77.44,'2022-04-24 16:47:45','',''),(5183,'1','223','1',1,'Retail Sale Id 5478',3720.00,0.00,0.00,6.00,192.00,'2022-04-24 16:54:28','',''),(5184,'1','223','1',1,'Retail Sale Id 5479',998.20,0.00,0.00,1.61,51.52,'2022-04-24 16:55:43','',''),(5185,'1','223','1',1,'Retail Sale Id 5480',651.00,0.00,0.00,1.05,33.60,'2022-04-24 16:56:20','',''),(5186,'1','223','1',1,'Retail Sale Id 5481',2498.60,0.00,0.00,4.03,128.96,'2022-04-24 16:57:06','',''),(5187,'1','223','1',1,'Retail Sale Id 5482',3100.00,0.00,0.00,5.00,160.00,'2022-04-24 17:02:08','',''),(5188,'1','223','1',1,'Retail Sale Id 5483',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 17:02:53','',''),(5189,'1','223','1',1,'Retail Sale Id 5484',2498.60,0.00,0.00,4.03,128.96,'2022-04-24 17:03:36','',''),(5190,'1','223','1',1,'Retail Sale Id 5485',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 17:04:20','',''),(5191,'1','223','1',1,'Retail Sale Id 5486',3100.00,0.00,0.00,5.00,160.00,'2022-04-24 17:06:00','',''),(5192,'1','223','1',1,'Retail Sale Id 5487',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 17:07:39','',''),(5193,'1','223','1',1,'Retail Sale Id 5488',1847.60,0.00,0.00,2.98,95.36,'2022-04-24 17:19:06','',''),(5194,'1','223','1',1,'Retail Sale Id 5489',998.20,0.00,0.00,1.61,51.52,'2022-04-24 17:19:54','',''),(5195,'1','223','1',1,'Retail Sale Id 5491',3000.80,0.00,0.00,4.84,154.88,'2022-04-24 17:21:38','',''),(5196,'1','223','1',1,'Retail Sale Id 5492',1872.40,0.00,0.00,3.02,96.64,'2022-04-24 17:26:36','',''),(5197,'1','223','1',1,'Return of Retail Sale Id 5484',0.00,2498.60,4.03,0.00,-128.96,'2022-04-24 17:33:04','',''),(5198,'1','223','1',1,'Retail Sale Id 5493',6200.00,0.00,0.00,10.00,320.00,'2022-04-24 17:40:51','',''),(5199,'1','223','1',1,'Retail Sale Id 5494',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 17:43:36','',''),(5200,'1','223','1',1,'Retail Sale Id 5495',1500.40,0.00,0.00,2.42,77.44,'2022-04-24 17:46:30','',''),(5201,'1','223','1',1,'Retail Sale Id 5496',1500.40,0.00,0.00,2.42,77.44,'2022-04-24 17:47:18','',''),(5202,'1','223','1',1,'Retail Sale Id 5497',1897.20,0.00,0.00,3.06,97.92,'2022-04-24 17:47:57','',''),(5203,'1','223','1',1,'Retail Sale Id 5498',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 17:48:29','',''),(5204,'1','223','1',1,'Retail Sale Id 5499',1897.20,0.00,0.00,3.06,97.92,'2022-04-24 17:49:30','',''),(5205,'1','223','1',1,'Retail Sale Id 5501',3751.00,0.00,0.00,6.05,193.60,'2022-04-24 17:50:41','',''),(5206,'1','223','1',1,'Retail Sale Id 5503',3100.00,0.00,0.00,5.00,160.00,'2022-04-24 17:51:22','',''),(5207,'1','223','1',1,'Retail Sale Id 5504',3100.00,0.00,0.00,5.00,160.00,'2022-04-24 17:51:53','',''),(5208,'1','223','1',1,'Retail Sale Id 5505',899.00,0.00,0.00,1.45,46.40,'2022-04-24 17:52:44','',''),(5209,'1','223','1',1,'Retail Sale Id 5506',3751.00,0.00,0.00,6.05,193.60,'2022-04-24 17:54:21','',''),(5210,'1','223','1',1,'Retail Sale Id 5507',1500.40,0.00,0.00,2.42,77.44,'2022-04-24 17:58:40','',''),(5211,'1','223','1',1,'Retail Sale Id 5508',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 17:59:25','',''),(5212,'1','223','1',1,'Retail Sale Id 5509',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 18:00:13','',''),(5213,'1','223','1',1,'Retail Sale Id 5510',1302.00,0.00,0.00,2.10,67.20,'2022-04-24 18:03:40','',''),(5214,'1','223','1',1,'Retail Sale Id 5511',7750.00,0.00,0.00,12.50,400.00,'2022-04-24 18:04:46','',''),(5215,'1','223','1',1,'Retail Sale Id 5512',1240.00,0.00,0.00,2.00,64.00,'2022-04-24 18:10:13','',''),(5216,'1','223','1',1,'Retail Sale Id 5513',3100.00,0.00,0.00,5.00,160.00,'2022-04-24 18:22:04','',''),(5217,'1','223','1',1,'Retail Sale Id 5514',601.40,0.00,0.00,0.97,31.04,'2022-04-24 18:24:09','',''),(5218,'1','223','1',1,'Return of Retail Sale Id 5514',0.00,601.40,0.97,0.00,-31.04,'2022-04-24 18:24:33','',''),(5219,'1','223','1',1,'Retail Sale Id 5515',502.20,0.00,0.00,0.81,25.92,'2022-04-24 18:24:53','',''),(5220,'1','223','1',1,'Retail Sale Id 5516',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 18:25:44','',''),(5221,'1','223','1',1,'Retail Sale Id 5518',1860.00,0.00,0.00,3.00,96.00,'2022-04-24 18:29:52','',''),(5222,'1','223','1',1,'Retail Sale Id 5519',651.00,0.00,0.00,1.05,33.60,'2022-04-24 18:32:50','',''),(5223,'1','223','1',1,'Retail Sale Id 5520',998.20,0.00,0.00,1.61,51.52,'2022-04-24 18:37:55','',''),(5224,'1','223','1',1,'Retail Sale Id 5521',2002.60,0.00,0.00,3.23,103.36,'2022-04-24 18:39:16','',''),(5225,'1','223','1',1,'Retail Sale Id 5522',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 18:49:39','',''),(5226,'1','223','1',1,'Retail Sale Id 5523',1252.40,0.00,0.00,2.02,64.64,'2022-04-24 19:32:54','',''),(5227,'1','223','1',1,'Retail Sale Id 5524',1500.40,0.00,0.00,2.42,77.44,'2022-04-25 07:28:05','',''),(5228,'1','223','1',1,'Retail Sale Id 5525',3720.00,0.00,0.00,6.00,192.00,'2022-04-25 07:29:25','',''),(5229,'1','223','1',1,'Retail Sale Id 5526',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 07:32:00','',''),(5230,'1','223','1',1,'Retail Sale Id 5527',502.20,0.00,0.00,0.81,25.92,'2022-04-25 07:34:58','',''),(5231,'1','223','1',1,'Retail Sale Id 5528',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 07:37:04','',''),(5232,'1','223','1',1,'Retail Sale Id 5529',3720.00,0.00,0.00,6.00,192.00,'2022-04-25 07:47:31','',''),(5233,'1','223','1',1,'Retail Sale Id 5530',60000.00,0.00,0.00,100.00,1200.00,'2022-04-25 07:59:16','',''),(5234,'1','223','1',1,'Retail Sale Id 5531',3720.00,0.00,0.00,6.00,192.00,'2022-04-25 08:03:52','',''),(5235,'1','223','1',1,'Return of Retail Sale Id 5531',0.00,3720.00,6.00,0.00,-192.00,'2022-04-25 08:04:12','',''),(5236,'1','223','1',1,'Retail Sale Id 5532',3751.00,0.00,0.00,6.05,193.60,'2022-04-25 08:04:48','',''),(5237,'1','223','1',1,'Retail Sale Id 5533',3720.00,0.00,0.00,6.00,192.00,'2022-04-25 08:06:26','',''),(5238,'1','223','1',1,'Return of Retail Sale Id 5532',0.00,3751.00,6.05,0.00,-193.60,'2022-04-25 08:07:46','',''),(5239,'1','223','1',1,'Retail Sale Id 5534',3751.00,0.00,0.00,6.05,193.60,'2022-04-25 08:08:15','',''),(5240,'1','223','1',1,'Retail Sale Id 5535',3720.00,0.00,0.00,6.00,192.00,'2022-04-25 08:20:37','',''),(5241,'1','223','1',1,'Retail Sale Id 5536',382800.00,0.00,0.00,638.00,7656.00,'2022-04-25 08:25:40','',''),(5242,'1','223','1',1,'Retail Sale Id 5537',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 08:27:13','',''),(5243,'1','223','1',1,'Retail Sale Id 5538',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 08:30:23','',''),(5244,'1','223','1',1,'Retail Sale Id 5539',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 08:47:39','',''),(5245,'1','223','1',1,'Retail Sale Id 5540',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 09:02:42','',''),(5246,'1','223','1',1,'Retail Sale Id 5541',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 09:03:53','',''),(5247,'1','223','1',1,'Retail Sale Id 5542',6200.00,0.00,0.00,10.00,320.00,'2022-04-25 09:06:11','',''),(5248,'1','223','1',1,'Retail Sale Id 5543',1897.20,0.00,0.00,3.06,97.92,'2022-04-25 09:07:20','',''),(5249,'1','223','1',1,'Retail Sale Id 5544',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 09:11:40','',''),(5250,'1','223','1',1,'Retail Sale Id 5545',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 09:12:19','',''),(5251,'1','223','1',1,'Retail Sale Id 5546',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 09:18:29','',''),(5252,'1','223','1',1,'Retail Sale Id 5548',620.00,0.00,0.00,1.00,32.00,'2022-04-25 09:24:09','',''),(5253,'1','223','1',1,'Retail Sale Id 5549',2480.00,0.00,0.00,4.00,128.00,'2022-04-25 09:24:54','',''),(5254,'1','223','1',1,'Retail Sale Id 5550',1872.40,0.00,0.00,3.02,96.64,'2022-04-25 09:27:40','',''),(5255,'1','223','1',1,'Retail Sale Id 5551',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 09:29:52','',''),(5256,'1','223','1',1,'Retail Sale Id 5552',3720.00,0.00,0.00,6.00,192.00,'2022-04-25 09:37:37','',''),(5257,'1','223','1',1,'Retail Sale Id 5553',2498.60,0.00,0.00,4.03,128.96,'2022-04-25 09:42:22','',''),(5258,'1','223','1',1,'Retail Sale Id 5554',3751.00,0.00,0.00,6.05,193.60,'2022-04-25 09:47:37','',''),(5259,'1','223','1',1,'Retail Sale Id 5555',620.00,0.00,0.00,1.00,32.00,'2022-04-25 09:48:18','',''),(5260,'1','223','1',1,'Retail Sale Id 5556',1897.20,0.00,0.00,3.06,97.92,'2022-04-25 09:49:33','',''),(5261,'1','223','1',1,'Retail Sale Id 5557',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 09:58:00','',''),(5262,'1','223','1',1,'Retail Sale Id 5558',7750.00,0.00,0.00,12.50,400.00,'2022-04-25 10:16:13','',''),(5263,'1','223','1',1,'Retail Sale Id 5559',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 10:25:14','',''),(5264,'1','223','1',1,'Retail Sale Id 5560',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 10:33:59','',''),(5265,'1','223','1',1,'Retail Sale Id 5561',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 10:34:24','',''),(5266,'1','223','1',1,'Retail Sale Id 5562',2498.60,0.00,0.00,4.03,128.96,'2022-04-25 11:04:01','',''),(5267,'1','223','1',1,'Retail Sale Id 5563',1897.20,0.00,0.00,3.06,97.92,'2022-04-25 11:13:33','',''),(5268,'1','223','1',1,'Retail Sale Id 5564',90000.00,0.00,0.00,150.00,1800.00,'2022-04-25 11:25:28','',''),(5269,'1','223','1',1,'Retail Sale Id 5565',1202.80,0.00,0.00,1.94,62.08,'2022-04-25 11:30:53','',''),(5270,'1','223','1',1,'Retail Sale Id 5566',1500.40,0.00,0.00,2.42,77.44,'2022-04-25 11:39:54','',''),(5271,'1','223','1',1,'Retail Sale Id 5567',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 11:50:21','',''),(5272,'1','223','1',1,'Retail Sale Id 5568',700.60,0.00,0.00,1.13,36.16,'2022-04-25 11:56:51','',''),(5273,'1','223','1',1,'Retail Sale Id 5569',3751.00,0.00,0.00,6.05,193.60,'2022-04-25 12:09:32','',''),(5274,'1','223','1',1,'Retail Sale Id 5570',1872.40,0.00,0.00,3.02,96.64,'2022-04-25 12:21:46','',''),(5275,'1','223','1',1,'Retail Sale Id 5571',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 12:29:27','',''),(5276,'1','223','1',1,'Retail Sale Id 5572',3751.00,0.00,0.00,6.05,193.60,'2022-04-25 12:33:24','',''),(5277,'1','223','1',1,'Retail Sale Id 5574',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 12:34:29','',''),(5278,'1','223','1',1,'Retail Sale Id 5575',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 12:35:10','',''),(5279,'1','223','1',1,'Retail Sale Id 5576',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 13:45:22','',''),(5280,'1','223','1',1,'Retail Sale Id 5578',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 14:12:06','',''),(5281,'1','223','1',1,'Retail Sale Id 5579',1847.60,0.00,0.00,2.98,95.36,'2022-04-25 14:14:16','',''),(5282,'1','223','1',1,'Retail Sale Id 5580',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 14:48:49','',''),(5283,'1','223','1',1,'Retail Sale Id 5581',3720.00,0.00,0.00,6.00,192.00,'2022-04-25 14:54:20','',''),(5284,'1','223','1',1,'Retail Sale Id 5582',1500.40,0.00,0.00,2.42,77.44,'2022-04-25 14:55:36','',''),(5285,'1','223','1',1,'Retail Sale Id 5583',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 14:57:38','',''),(5286,'1','223','1',1,'Retail Sale Id 5584',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 15:01:45','',''),(5287,'1','223','1',1,'Retail Sale Id 5585',1847.60,0.00,0.00,2.98,95.36,'2022-04-25 15:16:19','',''),(5288,'1','223','1',1,'Retail Sale Id 5586',7502.00,0.00,0.00,12.10,387.20,'2022-04-25 15:33:23','',''),(5289,'1','223','1',1,'Retail Sale Id 5587',1798.00,0.00,0.00,2.90,92.80,'2022-04-25 15:38:30','',''),(5290,'1','223','1',1,'Retail Sale Id 5588',1302.00,0.00,0.00,2.10,67.20,'2022-04-25 15:43:48','',''),(5291,'1','223','1',1,'Retail Sale Id 5589',1401.20,0.00,0.00,2.26,72.32,'2022-04-25 15:44:40','',''),(5292,'1','223','1',1,'Retail Sale Id 5590',11470.00,0.00,0.00,18.50,592.00,'2022-04-25 15:45:49','',''),(5293,'1','223','1',1,'Retail Sale Id 5591',3000.80,0.00,0.00,4.84,154.88,'2022-04-25 15:55:39','',''),(5294,'1','223','1',1,'Retail Sale Id 5592',2002.60,0.00,0.00,3.23,103.36,'2022-04-25 15:56:35','',''),(5295,'1','223','1',1,'Retail Sale Id 5593',998.20,0.00,0.00,1.61,51.52,'2022-04-25 15:57:30','',''),(5296,'1','223','1',1,'Retail Sale Id 5594',2002.60,0.00,0.00,3.23,103.36,'2022-04-25 16:04:38','',''),(5297,'1','223','1',1,'Retail Sale Id 5595',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 16:06:44','',''),(5298,'1','223','1',1,'Retail Sale Id 5596',2802.40,0.00,0.00,4.52,144.64,'2022-04-25 16:10:45','',''),(5299,'1','223','1',1,'Retail Sale Id 5597',998.20,0.00,0.00,1.61,51.52,'2022-04-25 16:12:04','',''),(5300,'1','223','1',1,'Retail Sale Id 5598',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 16:16:19','',''),(5301,'1','223','1',1,'Retail Sale Id 5599',2480.00,0.00,0.00,4.00,128.00,'2022-04-25 16:17:45','',''),(5302,'1','223','1',1,'Retail Sale Id 5600',1202.80,0.00,0.00,1.94,62.08,'2022-04-25 16:20:25','',''),(5303,'1','223','1',1,'Retail Sale Id 5601',66000.00,0.00,0.00,110.00,1320.00,'2022-04-25 16:22:25','',''),(5304,'1','223','1',1,'Retail Sale Id 5602',4352.40,0.00,0.00,7.02,224.64,'2022-04-25 16:26:04','',''),(5305,'1','223','1',1,'Retail Sale Id 5603',2002.60,0.00,0.00,3.23,103.36,'2022-04-25 16:33:34','',''),(5306,'1','223','1',1,'Retail Sale Id 5604',502.20,0.00,0.00,0.81,25.92,'2022-04-25 16:34:39','',''),(5307,'1','223','1',1,'Retail Sale Id 5605',21000.00,0.00,0.00,35.00,420.00,'2022-04-25 16:38:19','',''),(5308,'1','223','1',1,'Retail Sale Id 5606',1302.00,0.00,0.00,2.10,67.20,'2022-04-25 16:40:14','',''),(5309,'1','223','1',1,'Retail Sale Id 5607',1897.20,0.00,0.00,3.06,97.92,'2022-04-25 16:45:17','',''),(5310,'1','223','1',1,'Retail Sale Id 5608',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 16:47:16','',''),(5311,'1','223','1',1,'Retail Sale Id 5609',998.20,0.00,0.00,1.61,51.52,'2022-04-25 16:52:02','',''),(5312,'1','223','1',1,'Return of Retail Sale Id 5609',0.00,998.20,1.61,0.00,-51.52,'2022-04-25 16:52:43','',''),(5313,'1','223','1',1,'Retail Sale Id 5610',1897.20,0.00,0.00,3.06,97.92,'2022-04-25 16:53:23','',''),(5314,'1','223','1',1,'Retail Sale Id 5611',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 16:54:40','',''),(5315,'1','223','1',1,'Retail Sale Id 5612',700.60,0.00,0.00,1.13,36.16,'2022-04-25 16:55:33','',''),(5316,'1','223','1',1,'Retail Sale Id 5613',799.80,0.00,0.00,1.29,41.28,'2022-04-25 16:56:29','',''),(5317,'1','223','1',1,'Retail Sale Id 5614',3751.00,0.00,0.00,6.05,193.60,'2022-04-25 16:57:24','',''),(5318,'1','223','1',1,'Retail Sale Id 5615',3701.40,0.00,0.00,5.97,191.04,'2022-04-25 16:58:32','',''),(5319,'1','223','1',1,'Retail Sale Id 5616',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 16:59:17','',''),(5320,'1','223','1',1,'Retail Sale Id 5617',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 17:00:33','',''),(5321,'1','223','1',1,'Retail Sale Id 5618',502.20,0.00,0.00,0.81,25.92,'2022-04-25 17:01:44','',''),(5322,'1','223','1',1,'Retail Sale Id 5619',1847.60,0.00,0.00,2.98,95.36,'2022-04-25 17:02:39','',''),(5323,'1','223','1',1,'Retail Sale Id 5620',2498.60,0.00,0.00,4.03,128.96,'2022-04-25 17:04:00','',''),(5324,'1','223','1',1,'Retail Sale Id 5621',2498.60,0.00,0.00,4.03,128.96,'2022-04-25 17:04:42','',''),(5325,'1','223','1',1,'Retail Sale Id 5622',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 17:05:26','',''),(5326,'1','223','1',1,'Retail Sale Id 5623',1500.40,0.00,0.00,2.42,77.44,'2022-04-25 17:07:08','',''),(5327,'1','223','1',1,'Retail Sale Id 5624',1798.00,0.00,0.00,2.90,92.80,'2022-04-25 17:08:00','',''),(5328,'1','223','1',1,'Retail Sale Id 5625',3720.00,0.00,0.00,6.00,192.00,'2022-04-25 17:08:44','',''),(5329,'1','223','1',1,'Retail Sale Id 5626',651.00,0.00,0.00,1.05,33.60,'2022-04-25 17:09:43','',''),(5330,'1','223','1',1,'Retail Sale Id 5627',3720.00,0.00,0.00,6.00,192.00,'2022-04-25 17:10:43','',''),(5331,'1','223','1',1,'Retail Sale Id 5628',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 17:16:42','',''),(5332,'1','223','1',1,'Retail Sale Id 5629',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 17:17:33','',''),(5333,'1','223','1',1,'Retail Sale Id 5630',620.00,0.00,0.00,1.00,32.00,'2022-04-25 17:19:18','',''),(5334,'1','223','1',1,'Retail Sale Id 5631',1401.20,0.00,0.00,2.26,72.32,'2022-04-25 17:22:03','',''),(5335,'1','223','1',1,'Retail Sale Id 5632',620.00,0.00,0.00,1.00,32.00,'2022-04-25 17:23:02','',''),(5336,'1','223','1',1,'Retail Sale Id 5633',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 17:29:20','',''),(5337,'1','223','1',1,'Retail Sale Id 5634',620.00,0.00,0.00,1.00,32.00,'2022-04-25 17:30:40','',''),(5338,'1','223','1',1,'Retail Sale Id 5635',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 17:31:25','',''),(5339,'1','223','1',1,'Retail Sale Id 5636',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 17:36:20','',''),(5340,'1','223','1',1,'Retail Sale Id 5637',7750.00,0.00,0.00,12.50,400.00,'2022-04-25 17:37:14','',''),(5341,'1','223','1',1,'Retail Sale Id 5638',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 17:39:04','',''),(5342,'1','223','1',1,'Return of Retail Sale Id 5638',0.00,1860.00,3.00,0.00,-96.00,'2022-04-25 17:39:18','',''),(5343,'1','223','1',1,'Retail Sale Id 5639',1897.20,0.00,0.00,3.06,97.92,'2022-04-25 17:39:48','',''),(5344,'1','223','1',1,'Retail Sale Id 5640',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 17:40:36','',''),(5345,'1','223','1',1,'Retail Sale Id 5641',1599.60,0.00,0.00,2.58,82.56,'2022-04-25 17:48:20','',''),(5346,'1','223','1',1,'Retail Sale Id 5642',998.20,0.00,0.00,1.61,51.52,'2022-04-25 17:49:31','',''),(5347,'1','223','1',1,'Retail Sale Id 5643',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 17:50:18','',''),(5348,'1','223','1',1,'Retail Sale Id 5644',1500.40,0.00,0.00,2.42,77.44,'2022-04-25 17:52:40','',''),(5349,'1','223','1',1,'Retail Sale Id 5645',2480.00,0.00,0.00,4.00,128.00,'2022-04-25 17:53:34','',''),(5350,'1','223','1',1,'Retail Sale Id 5647',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 17:57:18','',''),(5351,'1','223','1',1,'Retail Sale Id 5648',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 17:58:13','',''),(5352,'1','223','1',1,'Retail Sale Id 5649',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 17:59:12','',''),(5353,'1','223','1',1,'Retail Sale Id 5650',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 17:59:57','',''),(5354,'1','223','1',1,'Retail Sale Id 5651',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 18:00:33','',''),(5355,'1','223','1',1,'Retail Sale Id 5652',799.80,0.00,0.00,1.29,41.28,'2022-04-25 18:02:10','',''),(5356,'1','223','1',1,'Retail Sale Id 5653',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 18:03:22','',''),(5357,'1','223','1',1,'Retail Sale Id 5655',998.20,0.00,0.00,1.61,51.52,'2022-04-25 18:04:38','',''),(5358,'1','223','1',1,'Retail Sale Id 5656',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 18:05:21','',''),(5359,'1','223','1',1,'Retail Sale Id 5657',3100.00,0.00,0.00,5.00,160.00,'2022-04-25 18:08:35','',''),(5360,'1','223','1',1,'Retail Sale Id 5658',998.20,0.00,0.00,1.61,51.52,'2022-04-25 18:09:39','',''),(5361,'1','223','1',1,'Retail Sale Id 5659',620.00,0.00,0.00,1.00,32.00,'2022-04-25 18:10:40','',''),(5362,'1','223','1',1,'Retail Sale Id 5660',899.00,0.00,0.00,1.45,46.40,'2022-04-25 18:13:25','',''),(5363,'1','223','1',1,'Retail Sale Id 5661',1847.60,0.00,0.00,2.98,95.36,'2022-04-25 18:15:25','',''),(5364,'1','223','1',1,'Retail Sale Id 5662',1401.20,0.00,0.00,2.26,72.32,'2022-04-25 18:16:31','',''),(5365,'1','223','1',1,'Retail Sale Id 5663',3751.00,0.00,0.00,6.05,193.60,'2022-04-25 18:17:58','',''),(5366,'1','223','1',1,'Retail Sale Id 5664',1240.00,0.00,0.00,2.00,64.00,'2022-04-25 18:19:00','',''),(5367,'1','223','1',1,'Retail Sale Id 5665',1860.00,0.00,0.00,3.00,96.00,'2022-04-25 18:19:44','',''),(5368,'1','223','1',1,'Retail Sale Id 5666',1500.40,0.00,0.00,2.42,77.44,'2022-04-25 18:21:06','',''),(5369,'1','223','1',1,'Retail Sale Id 5667',1897.20,0.00,0.00,3.06,97.92,'2022-04-25 18:22:20','',''),(5370,'1','223','1',1,'Retail Sale Id 5668',2002.60,0.00,0.00,3.23,103.36,'2022-04-25 18:23:11','',''),(5371,'1','223','1',1,'Retail Sale Id 5669',1252.40,0.00,0.00,2.02,64.64,'2022-04-25 18:23:47','',''),(5372,'1','223','1',1,'Retail Sale Id 5670',1847.60,0.00,0.00,2.98,95.36,'2022-04-25 18:28:15','',''),(5373,'1','223','1',1,'Retail Sale Id 5671',3751.00,0.00,0.00,6.05,193.60,'2022-04-25 18:35:10','',''),(5374,'1','223','1',1,'Retail Sale Id 5672',60000.00,0.00,0.00,100.00,1200.00,'2022-04-26 07:17:23','',''),(5375,'1','223','1',1,'Retail Sale Id 5673',1302.00,0.00,0.00,2.10,67.20,'2022-04-26 07:20:39','',''),(5376,'1','223','1',1,'Retail Sale Id 5674',2002.60,0.00,0.00,3.23,103.36,'2022-04-26 07:38:02','',''),(5377,'1','223','1',1,'Retail Sale Id 5675',8060.00,0.00,0.00,13.00,416.00,'2022-04-26 07:42:53','',''),(5378,'1','223','1',1,'Retail Sale Id 5676',3751.00,0.00,0.00,6.05,193.60,'2022-04-26 07:44:48','',''),(5379,'1','223','1',1,'Retail Sale Id 5677',3100.00,0.00,0.00,5.00,160.00,'2022-04-26 07:46:27','',''),(5380,'1','223','1',1,'Retail Sale Id 5678',1798.00,0.00,0.00,2.90,92.80,'2022-04-26 07:48:22','',''),(5381,'1','223','1',1,'Return of Retail Sale Id 5676',0.00,3751.00,6.05,0.00,-193.60,'2022-04-26 07:49:07','',''),(5382,'1','223','1',1,'Retail Sale Id 5679',3751.00,0.00,0.00,6.05,193.60,'2022-04-26 07:49:49','',''),(5383,'1','223','1',1,'Retail Sale Id 5680',1897.20,0.00,0.00,3.06,97.92,'2022-04-26 07:53:35','',''),(5384,'1','223','1',1,'Retail Sale Id 5681',3751.00,0.00,0.00,6.05,193.60,'2022-04-26 07:58:29','',''),(5385,'1','223','1',1,'Retail Sale Id 5682',1252.40,0.00,0.00,2.02,64.64,'2022-04-26 08:00:14','',''),(5386,'1','223','1',1,'Retail Sale Id 5683',2002.60,0.00,0.00,3.23,103.36,'2022-04-26 08:01:54','',''),(5387,'1','223','1',1,'Retail Sale Id 5684',1798.00,0.00,0.00,2.90,92.80,'2022-04-26 08:06:23','',''),(5388,'1','223','1',1,'Retail Sale Id 5685',1252.40,0.00,0.00,2.02,64.64,'2022-04-26 08:11:13','',''),(5389,'1','223','1',1,'Retail Sale Id 5686',3100.00,0.00,0.00,5.00,160.00,'2022-04-26 09:23:56','',''),(5390,'1','223','1',1,'Retail Sale Id 5687',212400.00,0.00,0.00,354.00,4248.00,'2022-04-26 09:25:46','',''),(5391,'1','223','1',1,'Distributed to A A RANO NIGERIA LIMITED for sales id:5',76081.32,0.00,0.00,129.39,0.00,'2022-04-26 10:00:22','',''),(5392,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,3827880.00,6510.00,0.00,0.00,'2022-04-27 12:26:43','',''),(5393,'1','223',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,6510.00,0.00,'2022-04-27 12:27:59','',''),(5394,'1','223','1',1,'Received from bridging 10',0.00,0.00,6510.00,0.00,0.00,'2022-04-27 12:27:59','',''),(5395,'1','223','1',1,'Retail Sale Id 5690',2498.60,0.00,0.00,4.03,128.96,'2022-04-27 12:51:52','',''),(5396,'1','223','1',1,'Retail Sale Id 5691',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 12:58:56','',''),(5397,'1','223','1',1,'Retail Sale Id 5692',96379.00,0.00,0.00,155.45,4974.40,'2022-04-27 13:01:00','',''),(5398,'1','223','1',1,'Retail Sale Id 5693',74406.20,0.00,0.00,120.01,3840.32,'2022-04-27 13:01:43','',''),(5399,'1','223','1',1,'Retail Sale Id 5694',48000.00,0.00,0.00,80.00,960.00,'2022-04-27 13:03:03','',''),(5400,'1','223','1',1,'Retail Sale Id 5695',80426.40,0.00,0.00,129.72,4151.04,'2022-04-27 13:04:18','',''),(5401,'1','223','1',1,'Retail Sale Id 5696',34410.00,0.00,0.00,55.50,1776.00,'2022-04-27 13:05:24','',''),(5402,'1','223','1',1,'Retail Sale Id 5697',94800.00,0.00,0.00,158.00,1896.00,'2022-04-27 13:10:30','',''),(5403,'1','223','1',1,'Retail Sale Id 5698',1500.40,0.00,0.00,2.42,77.44,'2022-04-27 13:11:15','',''),(5404,'1','223','1',1,'Retail Sale Id 5699',3751.00,0.00,0.00,6.05,193.60,'2022-04-27 13:16:32','',''),(5405,'1','223','1',1,'Retail Sale Id 5700',2498.60,0.00,0.00,4.03,128.96,'2022-04-27 13:27:39','',''),(5406,'1','223','1',1,'Retail Sale Id 5701',998.20,0.00,0.00,1.61,51.52,'2022-04-27 13:33:40','',''),(5407,'1','223','1',1,'Retail Sale Id 5702',3751.00,0.00,0.00,6.05,193.60,'2022-04-27 13:38:40','',''),(5408,'1','223','1',1,'Retail Sale Id 5703',60000.00,0.00,0.00,100.00,1200.00,'2022-04-27 13:54:09','',''),(5409,'1','223','1',1,'Retail Sale Id 5704',6200.00,0.00,0.00,10.00,320.00,'2022-04-27 13:56:26','',''),(5410,'1','223','1',1,'Retail Sale Id 5705',3720.00,0.00,0.00,6.00,192.00,'2022-04-27 14:02:39','',''),(5411,'1','223','1',1,'Retail Sale Id 5706',1897.20,0.00,0.00,3.06,97.92,'2022-04-27 14:06:07','',''),(5412,'1','223','1',1,'Retail Sale Id 5707',1240.00,0.00,0.00,2.00,64.00,'2022-04-27 14:10:58','',''),(5413,'1','223','1',1,'Retail Sale Id 5708',1860.00,0.00,0.00,3.00,96.00,'2022-04-27 14:16:26','',''),(5414,'1','223','1',1,'Retail Sale Id 5709',3100.00,0.00,0.00,5.00,160.00,'2022-04-27 14:20:02','',''),(5415,'1','223','1',1,'Retail Sale Id 5710',700.60,0.00,0.00,1.13,36.16,'2022-04-27 14:33:40','',''),(5416,'1','223','1',1,'Retail Sale Id 5711',3100.00,0.00,0.00,5.00,160.00,'2022-04-27 14:35:08','',''),(5417,'1','223','1',1,'Retail Sale Id 5712',1847.60,0.00,0.00,2.98,95.36,'2022-04-27 14:59:08','',''),(5418,'1','223','1',1,'Retail Sale Id 5713',2498.60,0.00,0.00,4.03,128.96,'2022-04-27 15:21:30','',''),(5419,'1','223','1',1,'Retail Sale Id 5714',620.00,0.00,0.00,1.00,32.00,'2022-04-27 15:23:02','',''),(5420,'1','223','1',1,'Retail Sale Id 5715',1860.00,0.00,0.00,3.00,96.00,'2022-04-27 15:26:25','',''),(5421,'1','223','1',1,'Retail Sale Id 5716',998.20,0.00,0.00,1.61,51.52,'2022-04-27 15:27:16','',''),(5422,'1','223','1',1,'Retail Sale Id 5717',1860.00,0.00,0.00,3.00,96.00,'2022-04-27 15:37:09','',''),(5423,'1','223','1',1,'Retail Sale Id 5718',700.60,0.00,0.00,1.13,36.16,'2022-04-27 15:39:34','',''),(5424,'1','223','1',1,'Retail Sale Id 5719',1897.20,0.00,0.00,3.06,97.92,'2022-04-27 15:41:34','',''),(5425,'1','223','1',1,'Retail Sale Id 5720',3720.00,0.00,0.00,6.00,192.00,'2022-04-27 15:46:48','',''),(5426,'1','223','1',1,'Retail Sale Id 5721',1847.60,0.00,0.00,2.98,95.36,'2022-04-27 15:49:47','',''),(5427,'1','223','1',1,'Retail Sale Id 5722',4352.40,0.00,0.00,7.02,224.64,'2022-04-27 15:51:11','',''),(5428,'1','223','1',1,'Retail Sale Id 5723',3100.00,0.00,0.00,5.00,160.00,'2022-04-27 15:53:51','',''),(5429,'1','223','1',1,'Retail Sale Id 5724',6200.00,0.00,0.00,10.00,320.00,'2022-04-27 15:56:09','',''),(5430,'1','223','1',1,'Retail Sale Id 5725',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 16:08:59','',''),(5431,'1','223','1',1,'Retail Sale Id 5726',608670.00,0.00,0.00,1014.45,12173.40,'2022-04-27 16:11:40','',''),(5432,'1','223','1',1,'Retail Sale Id 5727',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 16:13:03','',''),(5433,'1','223','1',1,'Retail Sale Id 5728',1860.00,0.00,0.00,3.00,96.00,'2022-04-27 16:15:59','',''),(5434,'1','223','1',1,'Retail Sale Id 5729',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 16:17:27','',''),(5435,'1','223','1',1,'Retail Sale Id 5730',3100.00,0.00,0.00,5.00,160.00,'2022-04-27 16:18:15','',''),(5436,'1','223','1',1,'Retail Sale Id 5731',3751.00,0.00,0.00,6.05,193.60,'2022-04-27 16:19:43','',''),(5437,'1','223','1',1,'Retail Sale Id 5732',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 16:20:51','',''),(5438,'1','223','1',1,'Retail Sale Id 5733',1847.60,0.00,0.00,2.98,95.36,'2022-04-27 16:22:19','',''),(5439,'1','223','1',1,'Retail Sale Id 5735',1847.60,0.00,0.00,2.98,95.36,'2022-04-27 16:32:50','',''),(5440,'1','223','1',1,'Retail Sale Id 5737',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 16:40:14','',''),(5441,'1','223','1',1,'Return of Retail Sale Id 5737',0.00,1252.40,2.02,0.00,-64.64,'2022-04-27 16:41:12','',''),(5442,'1','223','1',1,'Retail Sale Id 5738',1897.20,0.00,0.00,3.06,97.92,'2022-04-27 16:41:35','',''),(5443,'1','223','1',1,'Retail Sale Id 5739',651.00,0.00,0.00,1.05,33.60,'2022-04-27 16:42:43','',''),(5444,'1','223','1',1,'Retail Sale Id 5740',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 16:44:14','',''),(5445,'1','223','1',1,'Retail Sale Id 5741',998.20,0.00,0.00,1.61,51.52,'2022-04-27 16:45:47','',''),(5446,'1','223','1',1,'Retail Sale Id 5742',3751.00,0.00,0.00,6.05,193.60,'2022-04-27 16:48:58','',''),(5447,'1','223','1',1,'Retail Sale Id 5743',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 16:51:47','',''),(5448,'1','223','1',1,'Retail Sale Id 5744',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 16:52:27','',''),(5449,'1','223','1',1,'Retail Sale Id 5745',3751.00,0.00,0.00,6.05,193.60,'2022-04-27 16:55:35','',''),(5450,'1','223','1',1,'Retail Sale Id 5746',3751.00,0.00,0.00,6.05,193.60,'2022-04-27 16:56:40','',''),(5451,'1','223','1',1,'Retail Sale Id 5747',6200.00,0.00,0.00,10.00,320.00,'2022-04-27 16:57:40','',''),(5452,'1','223','1',1,'Retail Sale Id 5748',2498.60,0.00,0.00,4.03,128.96,'2022-04-27 16:59:13','',''),(5453,'1','223','1',1,'Retail Sale Id 5749',1500.40,0.00,0.00,2.42,77.44,'2022-04-27 17:03:33','',''),(5454,'1','223','1',1,'Retail Sale Id 5750',1860.00,0.00,0.00,3.00,96.00,'2022-04-27 17:04:38','',''),(5455,'1','223','1',1,'Retail Sale Id 5751',502.20,0.00,0.00,0.81,25.92,'2022-04-27 17:05:14','',''),(5456,'1','223','1',1,'Retail Sale Id 5752',502.20,0.00,0.00,0.81,25.92,'2022-04-27 17:05:38','',''),(5457,'1','223','1',1,'Retail Sale Id 5753',998.20,0.00,0.00,1.61,51.52,'2022-04-27 17:06:46','',''),(5458,'1','223','1',1,'Retail Sale Id 5754',7502.00,0.00,0.00,12.10,387.20,'2022-04-27 17:07:24','',''),(5459,'1','223','1',1,'Retail Sale Id 5755',502.20,0.00,0.00,0.81,25.92,'2022-04-27 17:11:39','',''),(5460,'1','223','1',1,'Retail Sale Id 5756',1798.00,0.00,0.00,2.90,92.80,'2022-04-27 17:16:40','',''),(5461,'1','223','1',1,'Retail Sale Id 5757',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 17:19:05','',''),(5462,'1','223','1',1,'Retail Sale Id 5758',4997.20,0.00,0.00,8.06,257.92,'2022-04-27 17:23:35','',''),(5463,'1','223','1',1,'Retail Sale Id 5759',1872.40,0.00,0.00,3.02,96.64,'2022-04-27 17:25:52','',''),(5464,'1','223','1',1,'Retail Sale Id 5760',1798.00,0.00,0.00,2.90,92.80,'2022-04-27 17:26:26','',''),(5465,'1','223','1',1,'Retail Sale Id 5762',2002.60,0.00,0.00,3.23,103.36,'2022-04-27 17:26:53','',''),(5466,'1','223','1',1,'Retail Sale Id 5763',1240.00,0.00,0.00,2.00,64.00,'2022-04-27 17:27:39','',''),(5467,'1','223','1',1,'Retail Sale Id 5764',3100.00,0.00,0.00,5.00,160.00,'2022-04-27 17:28:13','',''),(5468,'1','223','1',1,'Retail Sale Id 5765',3100.00,0.00,0.00,5.00,160.00,'2022-04-27 17:31:26','',''),(5469,'1','223','1',1,'Retail Sale Id 5766',1240.00,0.00,0.00,2.00,64.00,'2022-04-27 17:33:09','',''),(5470,'1','223','1',1,'Retail Sale Id 5767',1240.00,0.00,0.00,2.00,64.00,'2022-04-27 17:35:40','',''),(5471,'1','223','1',1,'Retail Sale Id 5768',651.00,0.00,0.00,1.05,33.60,'2022-04-27 17:38:25','',''),(5472,'1','223','1',1,'Retail Sale Id 5769',998.20,0.00,0.00,1.61,51.52,'2022-04-27 17:39:50','',''),(5473,'1','223','1',1,'Retail Sale Id 5770',2498.60,0.00,0.00,4.03,128.96,'2022-04-27 17:41:17','',''),(5474,'1','223','1',1,'Retail Sale Id 5771',1860.00,0.00,0.00,3.00,96.00,'2022-04-27 17:46:32','',''),(5475,'1','223','1',1,'Retail Sale Id 5772',7750.00,0.00,0.00,12.50,400.00,'2022-04-27 17:49:08','',''),(5476,'1','223','1',1,'Retail Sale Id 5773',1860.00,0.00,0.00,3.00,96.00,'2022-04-27 17:50:15','',''),(5477,'1','223','1',1,'Retail Sale Id 5774',3000.80,0.00,0.00,4.84,154.88,'2022-04-27 17:53:49','',''),(5478,'1','223','1',1,'Retail Sale Id 5775',1897.20,0.00,0.00,3.06,97.92,'2022-04-27 17:59:17','',''),(5479,'1','223','1',1,'Retail Sale Id 5776',651.00,0.00,0.00,1.05,33.60,'2022-04-27 18:00:08','',''),(5480,'1','223','1',1,'Retail Sale Id 5777',2480.00,0.00,0.00,4.00,128.00,'2022-04-27 18:00:56','',''),(5481,'1','223','1',1,'Retail Sale Id 5778',1240.00,0.00,0.00,2.00,64.00,'2022-04-27 18:01:23','',''),(5482,'1','223','1',1,'Retail Sale Id 5779',5580.00,0.00,0.00,9.00,288.00,'2022-04-27 18:10:23','',''),(5483,'1','223','1',1,'Retail Sale Id 5780',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 18:11:12','',''),(5484,'1','223','1',1,'Retail Sale Id 5781',1252.40,0.00,0.00,2.02,64.64,'2022-04-27 18:11:58','',''),(5485,'1','223','1',1,'Retail Sale Id 5782',2002.60,0.00,0.00,3.23,103.36,'2022-04-27 18:14:14','',''),(5486,'1','223','1',1,'Retail Sale Id 5783',3100.00,0.00,0.00,5.00,160.00,'2022-04-27 18:16:49','',''),(5487,'1','223','1',1,'Retail Sale Id 5784',1302.00,0.00,0.00,2.10,67.20,'2022-04-27 18:21:17','',''),(5488,'1','223','1',1,'Retail Sale Id 5785',24.80,0.00,0.00,0.04,1.28,'2022-04-27 19:35:53','',''),(5489,'1','223','1',1,'Retail Sale Id 5786',5059.20,0.00,0.00,8.16,261.12,'2022-04-28 07:28:00','',''),(5490,'1','223','1',1,'Retail Sale Id 5787',3751.00,0.00,0.00,6.05,193.60,'2022-04-28 08:12:10','',''),(5491,'1','223','1',1,'Retail Sale Id 5788',3751.00,0.00,0.00,6.05,193.60,'2022-04-28 08:17:01','',''),(5492,'1','223','1',1,'Retail Sale Id 5789',382800.00,0.00,0.00,638.00,7656.00,'2022-04-28 08:24:42','',''),(5493,'1','223','1',1,'Retail Sale Id 5790',2002.60,0.00,0.00,3.23,103.36,'2022-04-28 08:29:11','',''),(5494,'1','223','1',1,'Retail Sale Id 5791',3720.00,0.00,0.00,6.00,192.00,'2022-04-28 08:30:24','',''),(5495,'1','223','1',1,'Retail Sale Id 5792',3701.40,0.00,0.00,5.97,191.04,'2022-04-28 08:31:03','',''),(5496,'1','223','1',1,'Return of Retail Sale Id 5791',0.00,3720.00,6.00,0.00,-192.00,'2022-04-28 08:31:37','',''),(5497,'1','223','1',1,'Retail Sale Id 5793',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 08:36:06','',''),(5498,'1','223','1',1,'Retail Sale Id 5794',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 08:50:08','',''),(5499,'1','223','1',1,'Retail Sale Id 5795',620.00,0.00,0.00,1.00,32.00,'2022-04-28 08:51:45','',''),(5500,'1','223','1',1,'Retail Sale Id 5796',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 09:00:16','',''),(5501,'1','223','1',1,'Retail Sale Id 5797',620.00,0.00,0.00,1.00,32.00,'2022-04-28 09:00:56','',''),(5502,'1','223','1',1,'Retail Sale Id 5798',4352.40,0.00,0.00,7.02,224.64,'2022-04-28 09:03:55','',''),(5503,'1','223','1',1,'Retail Sale Id 5799',998.20,0.00,0.00,1.61,51.52,'2022-04-28 09:06:31','',''),(5504,'1','223','1',1,'Retail Sale Id 5800',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 09:09:11','',''),(5505,'1','223','1',1,'Retail Sale Id 5801',30000.00,0.00,0.00,50.00,600.00,'2022-04-28 09:12:03','',''),(5506,'1','223','1',1,'Retail Sale Id 5802',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 09:13:07','',''),(5507,'1','223','1',1,'Retail Sale Id 5803',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 09:33:14','',''),(5508,'1','223','1',1,'Retail Sale Id 5804',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 09:34:30','',''),(5509,'1','223','1',1,'Retail Sale Id 5805',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 09:47:28','',''),(5510,'1','223','1',1,'Retail Sale Id 5806',1897.20,0.00,0.00,3.06,97.92,'2022-04-28 10:22:58','',''),(5511,'1','223','1',1,'Retail Sale Id 5807',1847.60,0.00,0.00,2.98,95.36,'2022-04-28 10:24:11','',''),(5512,'1','223','1',1,'Retail Sale Id 5808',1897.20,0.00,0.00,3.06,97.92,'2022-04-28 10:24:50','',''),(5513,'1','223','1',1,'Retail Sale Id 5809',6200.00,0.00,0.00,10.00,320.00,'2022-04-28 10:25:30','',''),(5514,'1','223','1',1,'Retail Sale Id 5810',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 10:26:08','',''),(5515,'1','223','1',1,'Retail Sale Id 5811',7750.00,0.00,0.00,12.50,400.00,'2022-04-28 10:26:55','',''),(5516,'1','223','1',1,'Retail Sale Id 5812',1500.40,0.00,0.00,2.42,77.44,'2022-04-28 10:28:26','',''),(5517,'1','223','1',1,'Retail Sale Id 5813',18000.00,0.00,0.00,30.00,360.00,'2022-04-28 10:29:27','',''),(5518,'1','223','1',1,'Retail Sale Id 5814',998.20,0.00,0.00,1.61,51.52,'2022-04-28 10:30:53','',''),(5519,'1','223','1',1,'Retail Sale Id 5815',998.20,0.00,0.00,1.61,51.52,'2022-04-28 10:35:26','',''),(5520,'1','223','1',1,'Retail Sale Id 5816',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 10:42:46','',''),(5521,'1','223','1',1,'Retail Sale Id 5817',3999.00,0.00,0.00,6.45,206.40,'2022-04-28 10:47:02','',''),(5522,'1','223','1',1,'Retail Sale Id 5818',3720.00,0.00,0.00,6.00,192.00,'2022-04-28 10:50:51','',''),(5523,'1','223','1',1,'Retail Sale Id 5819',2480.00,0.00,0.00,4.00,128.00,'2022-04-28 10:59:25','',''),(5524,'1','223','1',1,'Retail Sale Id 5820',2480.00,0.00,0.00,4.00,128.00,'2022-04-28 10:59:57','',''),(5525,'1','223','1',1,'Retail Sale Id 5821',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 11:05:03','',''),(5526,'1','223','1',1,'Retail Sale Id 5822',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 11:15:30','',''),(5527,'1','223','1',1,'Retail Sale Id 5823',2480.00,0.00,0.00,4.00,128.00,'2022-04-28 11:22:17','',''),(5528,'1','223','1',1,'Retail Sale Id 5824',2498.60,0.00,0.00,4.03,128.96,'2022-04-28 11:33:32','',''),(5529,'1','223','1',1,'Retail Sale Id 5825',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 11:37:51','',''),(5530,'1','223','1',1,'Retail Sale Id 5826',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 11:38:39','',''),(5531,'1','223','1',1,'Retail Sale Id 5827',1240.00,0.00,0.00,2.00,64.00,'2022-04-28 11:39:21','',''),(5532,'1','223','1',1,'Retail Sale Id 5828',2498.60,0.00,0.00,4.03,128.96,'2022-04-28 11:44:29','',''),(5533,'1','223','1',1,'Retail Sale Id 5829',2498.60,0.00,0.00,4.03,128.96,'2022-04-28 11:45:23','',''),(5534,'1','223','1',1,'Retail Sale Id 5830',31800.00,0.00,0.00,53.00,636.00,'2022-04-28 12:14:54','',''),(5535,'1','223','1',1,'Retail Sale Id 5831',7502.00,0.00,0.00,12.10,387.20,'2022-04-28 12:19:31','',''),(5536,'1','223','1',1,'Retail Sale Id 5832',601.40,0.00,0.00,0.97,31.04,'2022-04-28 12:26:32','',''),(5537,'1','223','1',1,'Retail Sale Id 5833',1897.20,0.00,0.00,3.06,97.92,'2022-04-28 12:45:03','',''),(5538,'1','223','1',1,'Retail Sale Id 5835',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 12:49:08','',''),(5539,'1','223','1',1,'Retail Sale Id 5836',1847.60,0.00,0.00,2.98,95.36,'2022-04-28 12:55:22','',''),(5540,'1','223','1',1,'Retail Sale Id 5837',75000.00,0.00,0.00,125.00,1500.00,'2022-04-28 13:00:18','',''),(5541,'1','223','1',1,'Retail Sale Id 5838',1897.20,0.00,0.00,3.06,97.92,'2022-04-28 13:05:03','',''),(5542,'1','223','1',1,'Retail Sale Id 5839',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 13:20:46','',''),(5543,'1','223','1',1,'Retail Sale Id 5840',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 13:53:19','',''),(5544,'1','223','1',1,'Retail Sale Id 5841',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 14:03:55','',''),(5545,'1','223','1',1,'Retail Sale Id 5842',3720.00,0.00,0.00,6.00,192.00,'2022-04-28 14:08:24','',''),(5546,'1','223','1',1,'Retail Sale Id 5843',8680.00,0.00,0.00,14.00,448.00,'2022-04-28 14:09:13','',''),(5547,'1','223','1',1,'Retail Sale Id 5844',6200.00,0.00,0.00,10.00,320.00,'2022-04-28 14:18:00','',''),(5548,'1','223','1',1,'Retail Sale Id 5845',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 14:34:28','',''),(5549,'1','223','1',1,'Retail Sale Id 5846',3720.00,0.00,0.00,6.00,192.00,'2022-04-28 14:41:49','',''),(5550,'1','223','1',1,'Retail Sale Id 5847',1240.00,0.00,0.00,2.00,64.00,'2022-04-28 14:48:28','',''),(5551,'1','223','1',1,'Retail Sale Id 5848',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 14:52:34','',''),(5552,'1','223','1',1,'Retail Sale Id 5849',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 14:59:57','',''),(5553,'1','223','1',1,'Retail Sale Id 5850',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 15:00:53','',''),(5554,'1','223','1',1,'Retail Sale Id 5851',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 15:01:22','',''),(5555,'1','223','1',1,'Retail Sale Id 5852',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 15:02:25','',''),(5556,'1','223','1',1,'Retail Sale Id 5853',1302.00,0.00,0.00,2.10,67.20,'2022-04-28 15:03:38','',''),(5557,'1','223','1',1,'Retail Sale Id 5854',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 15:04:42','',''),(5558,'1','223','1',1,'Retail Sale Id 5855',1302.00,0.00,0.00,2.10,67.20,'2022-04-28 15:05:58','',''),(5559,'1','223','1',1,'Retail Sale Id 5856',2480.00,0.00,0.00,4.00,128.00,'2022-04-28 15:08:00','',''),(5560,'1','223','1',1,'Retail Sale Id 5857',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 15:17:26','',''),(5561,'1','223','1',1,'Retail Sale Id 5858',1240.00,0.00,0.00,2.00,64.00,'2022-04-28 15:19:12','',''),(5562,'1','223','1',1,'Retail Sale Id 5859',1500.40,0.00,0.00,2.42,77.44,'2022-04-28 15:22:14','',''),(5563,'1','223','1',1,'Retail Sale Id 5860',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 15:23:40','',''),(5564,'1','223','1',1,'Retail Sale Id 5861',1240.00,0.00,0.00,2.00,64.00,'2022-04-28 15:24:30','',''),(5565,'1','223','1',1,'Retail Sale Id 5862',1240.00,0.00,0.00,2.00,64.00,'2022-04-28 15:26:06','',''),(5566,'1','223','1',1,'Retail Sale Id 5864',2498.60,0.00,0.00,4.03,128.96,'2022-04-28 15:28:24','',''),(5567,'1','223','1',1,'Retail Sale Id 5865',651.00,0.00,0.00,1.05,33.60,'2022-04-28 15:30:00','',''),(5568,'1','223','1',1,'Retail Sale Id 5866',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 15:35:17','',''),(5569,'1','223','1',1,'Retail Sale Id 5867',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 15:37:26','',''),(5570,'1','223','1',1,'Retail Sale Id 5868',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 15:45:28','',''),(5571,'1','223','1',1,'Retail Sale Id 5869',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 15:49:05','',''),(5572,'1','223','1',1,'Retail Sale Id 5870',998.20,0.00,0.00,1.61,51.52,'2022-04-28 15:59:30','',''),(5573,'1','223','1',1,'Retail Sale Id 5871',2498.60,0.00,0.00,4.03,128.96,'2022-04-28 16:04:31','',''),(5574,'1','223','1',1,'Retail Sale Id 5872',6200.00,0.00,0.00,10.00,320.00,'2022-04-28 16:07:57','',''),(5575,'1','223','1',1,'Retail Sale Id 5873',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 16:15:30','',''),(5576,'1','223','1',1,'Retail Sale Id 5874',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 16:19:42','',''),(5577,'1','223','1',1,'Retail Sale Id 5875',998.20,0.00,0.00,1.61,51.52,'2022-04-28 16:20:36','',''),(5578,'1','223','1',1,'Retail Sale Id 5876',651.00,0.00,0.00,1.05,33.60,'2022-04-28 16:21:07','',''),(5579,'1','223','1',1,'Retail Sale Id 5877',7750.00,0.00,0.00,12.50,400.00,'2022-04-28 16:25:04','',''),(5580,'1','223','1',1,'Retail Sale Id 5878',1897.20,0.00,0.00,3.06,97.92,'2022-04-28 16:28:23','',''),(5581,'1','223','1',1,'Retail Sale Id 5879',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 16:29:49','',''),(5582,'1','223','1',1,'Retail Sale Id 5880',998.20,0.00,0.00,1.61,51.52,'2022-04-28 16:32:08','',''),(5583,'1','223','1',1,'Retail Sale Id 5881',1897.20,0.00,0.00,3.06,97.92,'2022-04-28 16:35:05','',''),(5584,'1','223','1',1,'Retail Sale Id 5882',1401.20,0.00,0.00,2.26,72.32,'2022-04-28 16:35:53','',''),(5585,'1','223','1',1,'Retail Sale Id 5883',998.20,0.00,0.00,1.61,51.52,'2022-04-28 16:40:17','',''),(5586,'1','223','1',1,'Retail Sale Id 5884',1500.40,0.00,0.00,2.42,77.44,'2022-04-28 16:42:28','',''),(5587,'1','223','1',1,'Retail Sale Id 5885',1897.20,0.00,0.00,3.06,97.92,'2022-04-28 16:43:31','',''),(5588,'1','223','1',1,'Retail Sale Id 5886',1202.80,0.00,0.00,1.94,62.08,'2022-04-28 16:44:06','',''),(5589,'1','223','1',1,'Retail Sale Id 5887',3751.00,0.00,0.00,6.05,193.60,'2022-04-28 16:44:57','',''),(5590,'1','223','1',1,'Retail Sale Id 5888',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 16:48:13','',''),(5591,'1','223','1',1,'Retail Sale Id 5889',3720.00,0.00,0.00,6.00,192.00,'2022-04-28 16:49:28','',''),(5592,'1','223','1',1,'Retail Sale Id 5890',3720.00,0.00,0.00,6.00,192.00,'2022-04-28 16:51:19','',''),(5593,'1','223','1',1,'Retail Sale Id 5891',2498.60,0.00,0.00,4.03,128.96,'2022-04-28 16:54:44','',''),(5594,'1','223','1',1,'Retail Sale Id 5893',601.40,0.00,0.00,0.97,31.04,'2022-04-28 16:55:26','',''),(5595,'1','223','1',1,'Retail Sale Id 5896',1897.20,0.00,0.00,3.06,97.92,'2022-04-28 17:03:18','',''),(5596,'1','223','1',1,'Retail Sale Id 5897',2498.60,0.00,0.00,4.03,128.96,'2022-04-28 17:04:00','',''),(5597,'1','223','1',1,'Retail Sale Id 5898',3751.00,0.00,0.00,6.05,193.60,'2022-04-28 17:12:25','',''),(5598,'1','223','1',1,'Retail Sale Id 5899',3720.00,0.00,0.00,6.00,192.00,'2022-04-28 17:14:01','',''),(5599,'1','223','1',1,'Retail Sale Id 5900',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 17:15:14','',''),(5600,'1','223','1',1,'Retail Sale Id 5901',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 17:17:52','',''),(5601,'1','223','1',1,'Retail Sale Id 5902',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 17:18:29','',''),(5602,'1','223','1',1,'Retail Sale Id 5903',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 17:20:56','',''),(5603,'1','223','1',1,'Retail Sale Id 5904',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 17:22:51','',''),(5604,'1','223','1',1,'Retail Sale Id 5905',3720.00,0.00,0.00,6.00,192.00,'2022-04-28 17:26:10','',''),(5605,'1','223','1',1,'Retail Sale Id 5906',2498.60,0.00,0.00,4.03,128.96,'2022-04-28 17:30:26','',''),(5606,'1','223','1',1,'Retail Sale Id 5907',998.20,0.00,0.00,1.61,51.52,'2022-04-28 17:31:11','',''),(5607,'1','223','1',1,'Retail Sale Id 5908',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 17:40:10','',''),(5608,'1','223','1',1,'Retail Sale Id 5909',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 17:43:11','',''),(5609,'1','223','1',1,'Retail Sale Id 5910',1240.00,0.00,0.00,2.00,64.00,'2022-04-28 17:44:20','',''),(5610,'1','223','1',1,'Retail Sale Id 5911',3720.00,0.00,0.00,6.00,192.00,'2022-04-28 17:45:51','',''),(5611,'1','223','1',1,'Retail Sale Id 5912',3100.00,0.00,0.00,5.00,160.00,'2022-04-28 17:49:57','',''),(5612,'1','223','1',1,'Retail Sale Id 5913',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 17:50:39','',''),(5613,'1','223','1',1,'Retail Sale Id 5915',5580.00,0.00,0.00,9.00,288.00,'2022-04-28 17:51:49','',''),(5614,'1','223','1',1,'Retail Sale Id 5916',6200.00,0.00,0.00,10.00,320.00,'2022-04-28 17:58:33','',''),(5615,'1','223','1',1,'Retail Sale Id 5917',700.60,0.00,0.00,1.13,36.16,'2022-04-28 17:59:09','',''),(5616,'1','223','1',1,'Retail Sale Id 5918',620.00,0.00,0.00,1.00,32.00,'2022-04-28 18:00:04','',''),(5617,'1','223','1',1,'Retail Sale Id 5919',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 18:00:44','',''),(5618,'1','223','1',1,'Retail Sale Id 5920',6200.00,0.00,0.00,10.00,320.00,'2022-04-28 18:01:15','',''),(5619,'1','223','1',1,'Retail Sale Id 5921',1860.00,0.00,0.00,3.00,96.00,'2022-04-28 18:01:52','',''),(5620,'1','223','1',1,'Retail Sale Id 5922',1500.40,0.00,0.00,2.42,77.44,'2022-04-28 18:04:34','',''),(5621,'1','223','1',1,'Retail Sale Id 5923',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 18:07:47','',''),(5622,'1','223','1',1,'Retail Sale Id 5924',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 18:08:58','',''),(5623,'1','223','1',1,'Retail Sale Id 5925',1798.00,0.00,0.00,2.90,92.80,'2022-04-28 18:12:17','',''),(5624,'1','223','1',1,'Retail Sale Id 5926',6200.00,0.00,0.00,10.00,320.00,'2022-04-28 18:13:40','',''),(5625,'1','223','1',1,'Retail Sale Id 5929',3751.00,0.00,0.00,6.05,193.60,'2022-04-28 18:17:03','',''),(5626,'1','223','1',1,'Retail Sale Id 5930',620.00,0.00,0.00,1.00,32.00,'2022-04-28 18:22:20','',''),(5627,'1','223','1',1,'Retail Sale Id 5931',2498.60,0.00,0.00,4.03,128.96,'2022-04-28 18:22:55','',''),(5628,'1','223','1',1,'Retail Sale Id 5932',1252.40,0.00,0.00,2.02,64.64,'2022-04-28 18:25:36','',''),(5629,'1','223','1',1,'Retail Sale Id 5933',1240.00,0.00,0.00,2.00,64.00,'2022-04-28 18:26:31','',''),(5630,'1','223','1',1,'Retail Sale Id 5934',3720.00,0.00,0.00,6.00,192.00,'2022-04-28 18:29:43','',''),(5631,'1','223','1',1,'Retail Sale Id 5935',1240.00,0.00,0.00,2.00,64.00,'2022-04-28 18:31:31','',''),(5632,'1','223','1',1,'Retail Sale Id 5937',2480.00,0.00,0.00,4.00,128.00,'2022-04-28 18:32:28','',''),(5633,'1','223','1',1,'Return of Retail Sale Id 5935',0.00,1240.00,2.00,0.00,-64.00,'2022-04-28 19:31:51','',''),(5634,'1','223','1',1,'Retail Sale Id 5938',18.60,0.00,0.00,0.03,0.96,'2022-04-28 19:33:41','',''),(5635,'1','223','1',1,'Retail Sale Id 5939',1252.40,0.00,0.00,2.02,64.64,'2022-04-29 07:57:53','',''),(5636,'1','223','1',1,'Retail Sale Id 5940',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 08:01:44','',''),(5637,'1','223','1',1,'Retail Sale Id 5941',1897.20,0.00,0.00,3.06,97.92,'2022-04-29 08:03:03','',''),(5638,'1','223','1',1,'Retail Sale Id 5942',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 08:04:06','',''),(5639,'1','223','1',1,'Retail Sale Id 5943',7750.00,0.00,0.00,12.50,400.00,'2022-04-29 08:04:47','',''),(5640,'1','223','1',1,'Retail Sale Id 5944',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 08:09:42','',''),(5641,'1','223','1',1,'Retail Sale Id 5945',998.20,0.00,0.00,1.61,51.52,'2022-04-29 08:10:25','',''),(5642,'1','223','1',1,'Retail Sale Id 5946',1897.20,0.00,0.00,3.06,97.92,'2022-04-29 08:19:04','',''),(5643,'1','223','1',1,'Retail Sale Id 5947',998.20,0.00,0.00,1.61,51.52,'2022-04-29 08:24:37','',''),(5644,'1','223','1',1,'Retail Sale Id 5948',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 08:25:15','',''),(5645,'1','223','1',1,'Retail Sale Id 5949',2480.00,0.00,0.00,4.00,128.00,'2022-04-29 08:26:42','',''),(5646,'1','223','1',1,'Retail Sale Id 5951',620.00,0.00,0.00,1.00,32.00,'2022-04-29 08:39:33','',''),(5647,'1','223','1',1,'Retail Sale Id 5952',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 08:40:12','',''),(5648,'1','223','1',1,'Retail Sale Id 5953',7452.40,0.00,0.00,12.02,384.64,'2022-04-29 08:46:40','',''),(5649,'1','223','1',1,'Retail Sale Id 5954',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 09:02:26','',''),(5650,'1','223','1',1,'Retail Sale Id 5955',1401.20,0.00,0.00,2.26,72.32,'2022-04-29 09:11:54','',''),(5651,'1','223','1',1,'Retail Sale Id 5956',3100.00,0.00,0.00,5.00,160.00,'2022-04-29 09:13:39','',''),(5652,'1','223','1',1,'Retail Sale Id 5957',2002.60,0.00,0.00,3.23,103.36,'2022-04-29 09:31:16','',''),(5653,'1','223','1',1,'Retail Sale Id 5958',1252.40,0.00,0.00,2.02,64.64,'2022-04-29 09:46:01','',''),(5654,'1','223','1',1,'Retail Sale Id 5959',1500.40,0.00,0.00,2.42,77.44,'2022-04-29 10:46:25','',''),(5655,'1','223','1',1,'Retail Sale Id 5960',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 11:08:21','',''),(5656,'1','223','1',1,'Retail Sale Id 5962',1897.20,0.00,0.00,3.06,97.92,'2022-04-29 11:15:22','',''),(5657,'1','223','1',1,'Retail Sale Id 5963',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 11:17:32','',''),(5658,'1','223','1',1,'Return of Retail Sale Id 5963',0.00,1860.00,3.00,0.00,-96.00,'2022-04-29 11:18:06','',''),(5659,'1','223','1',1,'Retail Sale Id 5964',1897.20,0.00,0.00,3.06,97.92,'2022-04-29 11:18:24','',''),(5660,'1','223','1',1,'Retail Sale Id 5965',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 11:30:37','',''),(5661,'1','223','1',1,'Retail Sale Id 5966',1252.40,0.00,0.00,2.02,64.64,'2022-04-29 11:36:36','',''),(5662,'1','223','1',1,'Retail Sale Id 5967',1847.60,0.00,0.00,2.98,95.36,'2022-04-29 11:43:11','',''),(5663,'1','223','1',1,'Retail Sale Id 5969',2498.60,0.00,0.00,4.03,128.96,'2022-04-29 11:49:12','',''),(5664,'1','223','1',1,'Retail Sale Id 5970',1847.60,0.00,0.00,2.98,95.36,'2022-04-29 11:52:39','',''),(5665,'1','223','1',1,'Retail Sale Id 5971',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 11:53:49','',''),(5666,'1','223','1',1,'Retail Sale Id 5972',97500.00,0.00,0.00,162.50,1950.00,'2022-04-29 12:06:43','',''),(5667,'1','223','1',1,'Retail Sale Id 5973',1240.00,0.00,0.00,2.00,64.00,'2022-04-29 12:51:04','',''),(5668,'1','223','1',1,'Retail Sale Id 5974',4197.40,0.00,0.00,6.77,216.64,'2022-04-29 12:54:12','',''),(5669,'1','223','1',1,'Retail Sale Id 5975',2498.60,0.00,0.00,4.03,128.96,'2022-04-29 12:57:00','',''),(5670,'1','223','1',1,'Retail Sale Id 5976',3100.00,0.00,0.00,5.00,160.00,'2022-04-29 12:57:46','',''),(5671,'1','223','1',1,'Retail Sale Id 5977',1500.40,0.00,0.00,2.42,77.44,'2022-04-29 13:03:29','',''),(5672,'1','223','1',1,'Retail Sale Id 5978',2498.60,0.00,0.00,4.03,128.96,'2022-04-29 13:09:09','',''),(5673,'1','223','1',1,'Retail Sale Id 5979',4997.20,0.00,0.00,8.06,257.92,'2022-04-29 13:14:17','',''),(5674,'1','223','1',1,'Retail Sale Id 5980',1872.40,0.00,0.00,3.02,96.64,'2022-04-29 13:19:03','',''),(5675,'1','223','1',1,'Retail Sale Id 5981',998.20,0.00,0.00,1.61,51.52,'2022-04-29 13:19:37','',''),(5676,'1','223','1',1,'Retail Sale Id 5982',1252.40,0.00,0.00,2.02,64.64,'2022-04-29 13:25:06','',''),(5677,'1','223','1',1,'Retail Sale Id 5983',2480.00,0.00,0.00,4.00,128.00,'2022-04-29 13:28:46','',''),(5678,'1','223','1',1,'Retail Sale Id 5984',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 13:38:11','',''),(5679,'1','223','1',1,'Retail Sale Id 5985',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 13:40:08','',''),(5680,'1','223','1',1,'Retail Sale Id 5986',998.20,0.00,0.00,1.61,51.52,'2022-04-29 13:48:13','',''),(5681,'1','223','1',1,'Retail Sale Id 5987',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 13:48:53','',''),(5682,'1','223','1',1,'Retail Sale Id 5988',1847.60,0.00,0.00,2.98,95.36,'2022-04-29 13:50:34','',''),(5683,'1','223','1',1,'Retail Sale Id 5989',3100.00,0.00,0.00,5.00,160.00,'2022-04-29 13:59:39','',''),(5684,'1','223','1',1,'Retail Sale Id 5990',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 14:02:45','',''),(5685,'1','223','1',1,'Retail Sale Id 5991',1240.00,0.00,0.00,2.00,64.00,'2022-04-29 14:07:55','',''),(5686,'1','223','1',1,'Retail Sale Id 5992',1847.60,0.00,0.00,2.98,95.36,'2022-04-29 14:17:43','',''),(5687,'1','223','1',1,'Retail Sale Id 5993',18000.00,0.00,0.00,30.00,360.00,'2022-04-29 14:27:53','',''),(5688,'1','223','1',1,'Retail Sale Id 5994',30000.00,0.00,0.00,50.00,600.00,'2022-04-29 14:32:50','',''),(5689,'1','223','1',1,'Retail Sale Id 5995',1847.60,0.00,0.00,2.98,95.36,'2022-04-29 14:43:27','',''),(5690,'1','223','1',1,'Retail Sale Id 5998',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 14:45:50','',''),(5691,'1','223','1',1,'Retail Sale Id 5999',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 14:46:46','',''),(5692,'1','223','1',1,'Retail Sale Id 6000',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 14:47:24','',''),(5693,'1','223','1',1,'Retail Sale Id 6001',2498.60,0.00,0.00,4.03,128.96,'2022-04-29 14:55:26','',''),(5694,'1','223','1',1,'Retail Sale Id 6002',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 15:00:15','',''),(5695,'1','223','1',1,'Retail Sale Id 6003',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 15:01:28','',''),(5696,'1','223','1',1,'Retail Sale Id 6004',2002.60,0.00,0.00,3.23,103.36,'2022-04-29 15:02:01','',''),(5697,'1','223','1',1,'Retail Sale Id 6005',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 15:05:01','',''),(5698,'1','223','1',1,'Retail Sale Id 6006',60000.00,0.00,0.00,100.00,1200.00,'2022-04-29 15:06:09','',''),(5699,'1','223','1',1,'Retail Sale Id 6007',651.00,0.00,0.00,1.05,33.60,'2022-04-29 15:16:31','',''),(5700,'1','223','1',1,'Retail Sale Id 6008',1897.20,0.00,0.00,3.06,97.92,'2022-04-29 15:19:23','',''),(5701,'1','223','1',1,'Retail Sale Id 6009',1240.00,0.00,0.00,2.00,64.00,'2022-04-29 15:22:12','',''),(5702,'1','223','1',1,'Retail Sale Id 6011',4501.20,0.00,0.00,7.26,232.32,'2022-04-29 15:24:20','',''),(5703,'1','223','1',1,'Retail Sale Id 6012',2498.60,0.00,0.00,4.03,128.96,'2022-04-29 15:26:05','',''),(5704,'1','223','1',1,'Retail Sale Id 6013',2498.60,0.00,0.00,4.03,128.96,'2022-04-29 15:26:46','',''),(5705,'1','223','1',1,'Retail Sale Id 6014',3800.60,0.00,0.00,6.13,196.16,'2022-04-29 15:28:32','',''),(5706,'1','223','1',1,'Retail Sale Id 6015',998.20,0.00,0.00,1.61,51.52,'2022-04-29 15:32:10','',''),(5707,'1','223','1',1,'Retail Sale Id 6016',1240.00,0.00,0.00,2.00,64.00,'2022-04-29 15:35:00','',''),(5708,'1','223','1',1,'Retail Sale Id 6017',6200.00,0.00,0.00,10.00,320.00,'2022-04-29 15:40:47','',''),(5709,'1','223','1',1,'Retail Sale Id 6018',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 15:41:36','',''),(5710,'1','223','1',1,'Retail Sale Id 6019',1897.20,0.00,0.00,3.06,97.92,'2022-04-29 15:47:35','',''),(5711,'1','223','1',1,'Retail Sale Id 6020',1252.40,0.00,0.00,2.02,64.64,'2022-04-29 15:48:46','',''),(5712,'1','223','1',1,'Retail Sale Id 6021',1240.00,0.00,0.00,2.00,64.00,'2022-04-29 15:53:08','',''),(5713,'1','223','1',1,'Retail Sale Id 6022',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 15:58:16','',''),(5714,'1','223','1',1,'Retail Sale Id 6023',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 16:04:11','',''),(5715,'1','223','1',1,'Retail Sale Id 6025',651.00,0.00,0.00,1.05,33.60,'2022-04-29 16:09:32','',''),(5716,'1','223','1',1,'Retail Sale Id 6026',1897.20,0.00,0.00,3.06,97.92,'2022-04-29 16:14:48','',''),(5717,'1','223','1',1,'Retail Sale Id 6027',1897.20,0.00,0.00,3.06,97.92,'2022-04-29 16:16:56','',''),(5718,'1','223','1',1,'Retail Sale Id 6028',651.00,0.00,0.00,1.05,33.60,'2022-04-29 16:19:09','',''),(5719,'1','223','1',1,'Retail Sale Id 6029',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 16:26:25','',''),(5720,'1','223','1',1,'Retail Sale Id 6030',7750.00,0.00,0.00,12.50,400.00,'2022-04-29 16:27:59','',''),(5721,'1','223','1',1,'Retail Sale Id 6031',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 16:32:20','',''),(5722,'1','223','1',1,'Retail Sale Id 6032',1897.20,0.00,0.00,3.06,97.92,'2022-04-29 16:34:26','',''),(5723,'1','223','1',1,'Retail Sale Id 6033',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 16:36:47','',''),(5724,'1','223','1',1,'Retail Sale Id 6034',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 16:37:35','',''),(5725,'1','223','1',1,'Retail Sale Id 6035',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 16:38:17','',''),(5726,'1','223','1',1,'Retail Sale Id 6036',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 16:38:49','',''),(5727,'1','223','1',1,'Retail Sale Id 6037',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 16:39:21','',''),(5728,'1','223','1',1,'Retail Sale Id 6038',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 16:39:56','',''),(5729,'1','223','1',1,'Retail Sale Id 6039',3701.40,0.00,0.00,5.97,191.04,'2022-04-29 16:40:44','',''),(5730,'1','223','1',1,'Retail Sale Id 6040',620.00,0.00,0.00,1.00,32.00,'2022-04-29 16:41:14','',''),(5731,'1','223','1',1,'Retail Sale Id 6041',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 16:41:39','',''),(5732,'1','223','1',1,'Retail Sale Id 6042',3100.00,0.00,0.00,5.00,160.00,'2022-04-29 16:43:06','',''),(5733,'1','223','1',1,'Retail Sale Id 6043',3701.40,0.00,0.00,5.97,191.04,'2022-04-29 16:43:51','',''),(5734,'1','223','1',1,'Retail Sale Id 6044',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 16:44:24','',''),(5735,'1','223','1',1,'Retail Sale Id 6045',1240.00,0.00,0.00,2.00,64.00,'2022-04-29 16:44:59','',''),(5736,'1','223','1',1,'Retail Sale Id 6046',1240.00,0.00,0.00,2.00,64.00,'2022-04-29 16:45:50','',''),(5737,'1','223','1',1,'Retail Sale Id 6048',3701.40,0.00,0.00,5.97,191.04,'2022-04-29 16:46:23','',''),(5738,'1','223','1',1,'Retail Sale Id 6049',1500.40,0.00,0.00,2.42,77.44,'2022-04-29 16:47:16','',''),(5739,'1','223','1',1,'Retail Sale Id 6050',7750.00,0.00,0.00,12.50,400.00,'2022-04-29 16:55:32','',''),(5740,'1','223','1',1,'Retail Sale Id 6051',2480.00,0.00,0.00,4.00,128.00,'2022-04-29 16:57:42','',''),(5741,'1','223','1',1,'Retail Sale Id 6053',30000.00,0.00,0.00,50.00,600.00,'2022-04-29 17:03:55','',''),(5742,'1','223','1',1,'Retail Sale Id 6054',1500.40,0.00,0.00,2.42,77.44,'2022-04-29 17:07:17','',''),(5743,'1','223','1',1,'Retail Sale Id 6055',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 17:10:58','',''),(5744,'1','223','1',1,'Retail Sale Id 6056',1202.80,0.00,0.00,1.94,62.08,'2022-04-29 17:12:04','',''),(5745,'1','223','1',1,'Retail Sale Id 6057',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 17:13:06','',''),(5746,'1','223','1',1,'Retail Sale Id 6059',3100.00,0.00,0.00,5.00,160.00,'2022-04-29 17:14:36','',''),(5747,'1','223','1',1,'Retail Sale Id 6061',1240.00,0.00,0.00,2.00,64.00,'2022-04-29 17:16:45','',''),(5748,'1','223','1',1,'Retail Sale Id 6062',2002.60,0.00,0.00,3.23,103.36,'2022-04-29 17:17:55','',''),(5749,'1','223','1',1,'Retail Sale Id 6063',1847.60,0.00,0.00,2.98,95.36,'2022-04-29 17:19:10','',''),(5750,'1','223','1',1,'Retail Sale Id 6064',1500.40,0.00,0.00,2.42,77.44,'2022-04-29 17:19:49','',''),(5751,'1','223','1',1,'Retail Sale Id 6065',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 17:21:37','',''),(5752,'1','223','1',1,'Retail Sale Id 6066',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 17:22:46','',''),(5753,'1','223','1',1,'Retail Sale Id 6067',2300.20,0.00,0.00,3.71,118.72,'2022-04-29 17:24:42','',''),(5754,'1','223','1',1,'Retail Sale Id 6068',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 17:30:23','',''),(5755,'1','223','1',1,'Retail Sale Id 6069',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 17:31:07','',''),(5756,'1','223','1',1,'Return of Retail Sale Id 6069',0.00,3751.00,6.05,0.00,-193.60,'2022-04-29 17:31:20','',''),(5757,'1','223','1',1,'Retail Sale Id 6070',3999.00,0.00,0.00,6.45,206.40,'2022-04-29 17:31:42','',''),(5758,'1','223','1',1,'Retail Sale Id 6071',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 17:32:26','',''),(5759,'1','223','1',1,'Retail Sale Id 6072',2480.00,0.00,0.00,4.00,128.00,'2022-04-29 17:33:01','',''),(5760,'1','223','1',1,'Retail Sale Id 6073',2498.60,0.00,0.00,4.03,128.96,'2022-04-29 17:34:32','',''),(5761,'1','223','1',1,'Retail Sale Id 6074',7750.00,0.00,0.00,12.50,400.00,'2022-04-29 17:37:24','',''),(5762,'1','223','1',1,'Retail Sale Id 6075',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 17:43:16','',''),(5763,'1','223','1',1,'Retail Sale Id 6076',2480.00,0.00,0.00,4.00,128.00,'2022-04-29 17:45:18','',''),(5764,'1','223','1',1,'Retail Sale Id 6077',1847.60,0.00,0.00,2.98,95.36,'2022-04-29 17:46:12','',''),(5765,'1','223','1',1,'Retail Sale Id 6078',2002.60,0.00,0.00,3.23,103.36,'2022-04-29 17:46:52','',''),(5766,'1','223','1',1,'Retail Sale Id 6079',620.00,0.00,0.00,1.00,32.00,'2022-04-29 17:47:23','',''),(5767,'1','223','1',1,'Retail Sale Id 6080',1798.00,0.00,0.00,2.90,92.80,'2022-04-29 17:47:53','',''),(5768,'1','223','1',1,'Retail Sale Id 6081',2498.60,0.00,0.00,4.03,128.96,'2022-04-29 17:49:28','',''),(5769,'1','223','1',1,'Retail Sale Id 6082',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 17:53:15','',''),(5770,'1','223','1',1,'Retail Sale Id 6083',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 17:59:04','',''),(5771,'1','223','1',1,'Retail Sale Id 6084',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 18:00:07','',''),(5772,'1','223','1',1,'Retail Sale Id 6085',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 18:02:49','',''),(5773,'1','223','1',1,'Retail Sale Id 6086',1500.40,0.00,0.00,2.42,77.44,'2022-04-29 18:03:17','',''),(5774,'1','223','1',1,'Retail Sale Id 6088',3100.00,0.00,0.00,5.00,160.00,'2022-04-29 18:05:40','',''),(5775,'1','223','1',1,'Retail Sale Id 6089',3100.00,0.00,0.00,5.00,160.00,'2022-04-29 18:06:15','',''),(5776,'1','223','1',1,'Retail Sale Id 6090',3100.00,0.00,0.00,5.00,160.00,'2022-04-29 18:10:55','',''),(5777,'1','223','1',1,'Retail Sale Id 6091',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 18:12:45','',''),(5778,'1','223','1',1,'Retail Sale Id 6092',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 18:13:39','',''),(5779,'1','223','1',1,'Retail Sale Id 6093',3100.00,0.00,0.00,5.00,160.00,'2022-04-29 18:14:20','',''),(5780,'1','223','1',1,'Retail Sale Id 6094',3751.00,0.00,0.00,6.05,193.60,'2022-04-29 18:16:01','',''),(5781,'1','223','1',1,'Retail Sale Id 6095',1860.00,0.00,0.00,3.00,96.00,'2022-04-29 18:18:07','',''),(5782,'1','223','1',1,'Retail Sale Id 6096',1252.40,0.00,0.00,2.02,64.64,'2022-04-29 18:18:40','',''),(5783,'1','223','1',1,'Retail Sale Id 6098',1302.00,0.00,0.00,2.10,67.20,'2022-04-29 18:23:04','',''),(5784,'1','223','1',1,'Retail Sale Id 6099',3720.00,0.00,0.00,6.00,192.00,'2022-04-29 18:24:14','',''),(5785,'1','223','1',1,'Retail Sale Id 6100',2002.60,0.00,0.00,3.23,103.36,'2022-04-29 18:24:48','',''),(5786,'1','223','1',1,'Retail Sale Id 6101',3100.00,0.00,0.00,5.00,160.00,'2022-04-29 18:38:04','',''),(5787,'1','223','1',1,'Retail Sale Id 6102',799.80,0.00,0.00,1.29,41.28,'2022-04-29 18:38:40','',''),(5788,'1','223','1',1,'Retail Sale Id 6103',3701.40,0.00,0.00,5.97,191.04,'2022-04-30 07:31:15','',''),(5789,'1','223','1',1,'Retail Sale Id 6104',1302.00,0.00,0.00,2.10,67.20,'2022-04-30 07:44:45','',''),(5790,'1','223','1',1,'Retail Sale Id 6105',1252.40,0.00,0.00,2.02,64.64,'2022-04-30 07:46:41','',''),(5791,'1','223','1',1,'Retail Sale Id 6106',651.00,0.00,0.00,1.05,33.60,'2022-04-30 07:55:04','',''),(5792,'1','223','1',1,'Retail Sale Id 6107',2002.60,0.00,0.00,3.23,103.36,'2022-04-30 08:03:26','',''),(5793,'1','223','1',1,'Retail Sale Id 6109',1847.60,0.00,0.00,2.98,95.36,'2022-04-30 08:04:20','',''),(5794,'1','223','1',1,'Retail Sale Id 6110',601.40,0.00,0.00,0.97,31.04,'2022-04-30 08:05:03','',''),(5795,'1','223','1',1,'Retail Sale Id 6111',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 08:10:11','',''),(5796,'1','223','1',1,'Retail Sale Id 6112',3162.00,0.00,0.00,5.10,163.20,'2022-04-30 08:13:49','',''),(5797,'1','223','1',1,'Retail Sale Id 6113',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 08:15:35','',''),(5798,'1','223','1',1,'Retail Sale Id 6114',700.60,0.00,0.00,1.13,36.16,'2022-04-30 08:16:46','',''),(5799,'1','223','1',1,'Retail Sale Id 6115',1419.80,0.00,0.00,2.29,73.28,'2022-04-30 08:23:08','',''),(5800,'1','223','1',1,'Retail Sale Id 6117',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 08:24:21','',''),(5801,'1','223','1',1,'Retail Sale Id 6118',2002.60,0.00,0.00,3.23,103.36,'2022-04-30 08:24:47','',''),(5802,'1','223','1',1,'Retail Sale Id 6119',6200.00,0.00,0.00,10.00,320.00,'2022-04-30 08:30:34','',''),(5803,'1','223','1',1,'Retail Sale Id 6120',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 08:30:57','',''),(5804,'1','223','1',1,'Retail Sale Id 6121',998.20,0.00,0.00,1.61,51.52,'2022-04-30 08:38:42','',''),(5805,'1','223','1',1,'Retail Sale Id 6122',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 08:47:15','',''),(5806,'1','223','1',1,'Retail Sale Id 6123',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 08:51:48','',''),(5807,'1','223','1',1,'Retail Sale Id 6124',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 08:52:38','',''),(5808,'1','223','1',1,'Retail Sale Id 6125',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 08:53:16','',''),(5809,'1','223','1',1,'Retail Sale Id 6126',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 08:54:38','',''),(5810,'1','223','1',1,'Retail Sale Id 6127',1252.40,0.00,0.00,2.02,64.64,'2022-04-30 08:57:31','',''),(5811,'1','223','1',1,'Retail Sale Id 6128',4997.20,0.00,0.00,8.06,257.92,'2022-04-30 08:58:13','',''),(5812,'1','223','1',1,'Retail Sale Id 6129',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 09:04:22','',''),(5813,'1','223','1',1,'Retail Sale Id 6130',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 09:05:16','',''),(5814,'1','223','1',1,'Retail Sale Id 6131',1240.00,0.00,0.00,2.00,64.00,'2022-04-30 09:07:31','',''),(5815,'1','223','1',1,'Retail Sale Id 6132',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 09:08:29','',''),(5816,'1','223','1',1,'Retail Sale Id 6133',1798.00,0.00,0.00,2.90,92.80,'2022-04-30 09:11:10','',''),(5817,'1','223','1',1,'Retail Sale Id 6134',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 09:16:57','',''),(5818,'1','223','1',1,'Retail Sale Id 6135',998.20,0.00,0.00,1.61,51.52,'2022-04-30 09:33:55','',''),(5819,'1','223','1',1,'Retail Sale Id 6136',1202.80,0.00,0.00,1.94,62.08,'2022-04-30 09:34:36','',''),(5820,'1','223','1',1,'Retail Sale Id 6137',1252.40,0.00,0.00,2.02,64.64,'2022-04-30 09:35:39','',''),(5821,'1','223','1',1,'Retail Sale Id 6138',2498.60,0.00,0.00,4.03,128.96,'2022-04-30 09:36:17','',''),(5822,'1','223','1',1,'Retail Sale Id 6139',1798.00,0.00,0.00,2.90,92.80,'2022-04-30 09:38:08','',''),(5823,'1','223','1',1,'Retail Sale Id 6140',998.20,0.00,0.00,1.61,51.52,'2022-04-30 09:39:35','',''),(5824,'1','223','1',1,'Return of Retail Sale Id 6140',0.00,998.20,1.61,0.00,-51.52,'2022-04-30 09:40:04','',''),(5825,'1','223','1',1,'Retail Sale Id 6141',2449.00,0.00,0.00,3.95,126.40,'2022-04-30 09:40:45','',''),(5826,'1','223','1',1,'Retail Sale Id 6142',3751.00,0.00,0.00,6.05,193.60,'2022-04-30 09:42:10','',''),(5827,'1','223','1',1,'Retail Sale Id 6143',651.00,0.00,0.00,1.05,33.60,'2022-04-30 09:43:26','',''),(5828,'1','223','1',1,'Retail Sale Id 6144',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 09:45:04','',''),(5829,'1','223','1',1,'Retail Sale Id 6145',2498.60,0.00,0.00,4.03,128.96,'2022-04-30 09:51:33','',''),(5830,'1','223','1',1,'Retail Sale Id 6146',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 09:52:03','',''),(5831,'1','223','1',1,'Retail Sale Id 6147',1252.40,0.00,0.00,2.02,64.64,'2022-04-30 09:53:00','',''),(5832,'1','223','1',1,'Retail Sale Id 6148',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 09:54:53','',''),(5833,'1','223','1',1,'Retail Sale Id 6149',3751.00,0.00,0.00,6.05,193.60,'2022-04-30 09:55:36','',''),(5834,'1','223','1',1,'Retail Sale Id 6150',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 10:05:55','',''),(5835,'1','223','1',1,'Retail Sale Id 6151',1252.40,0.00,0.00,2.02,64.64,'2022-04-30 10:07:51','',''),(5836,'1','223','1',1,'Retail Sale Id 6152',1798.00,0.00,0.00,2.90,92.80,'2022-04-30 10:12:12','',''),(5837,'1','223','1',1,'Retail Sale Id 6153',1847.60,0.00,0.00,2.98,95.36,'2022-04-30 10:13:55','',''),(5838,'1','223','1',1,'Return of Retail Sale Id 6153',0.00,1847.60,2.98,0.00,-95.36,'2022-04-30 10:15:21','',''),(5839,'1','223','1',1,'Retail Sale Id 6154',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 10:15:57','',''),(5840,'1','223','1',1,'Retail Sale Id 6155',998.20,0.00,0.00,1.61,51.52,'2022-04-30 10:19:10','',''),(5841,'1','223','1',1,'Retail Sale Id 6156',30000.00,0.00,0.00,50.00,600.00,'2022-04-30 10:30:37','',''),(5842,'1','223','1',1,'Retail Sale Id 6157',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 10:36:21','',''),(5843,'1','223','1',1,'Retail Sale Id 6158',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 10:37:46','',''),(5844,'1','223','1',1,'Retail Sale Id 6159',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 10:41:47','',''),(5845,'1','223','1',1,'Retail Sale Id 6160',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 10:43:00','',''),(5846,'1','223','1',1,'Retail Sale Id 6161',2498.60,0.00,0.00,4.03,128.96,'2022-04-30 10:48:18','',''),(5847,'1','223','1',1,'Retail Sale Id 6164',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 10:51:51','',''),(5848,'1','223','1',1,'Retail Sale Id 6165',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 10:52:18','',''),(5849,'1','223','1',1,'Retail Sale Id 6166',1252.40,0.00,0.00,2.02,64.64,'2022-04-30 10:52:54','',''),(5850,'1','223','1',1,'Retail Sale Id 6167',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 10:55:22','',''),(5851,'1','223','1',1,'Retail Sale Id 6168',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 10:57:09','',''),(5852,'1','223','1',1,'Retail Sale Id 6169',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 10:58:02','',''),(5853,'1','223','1',1,'Retail Sale Id 6170',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 11:07:00','',''),(5854,'1','223','1',1,'Retail Sale Id 6171',1500.40,0.00,0.00,2.42,77.44,'2022-04-30 11:10:57','',''),(5855,'1','223','1',1,'Return of Retail Sale Id 6171',0.00,1500.40,2.42,0.00,-77.44,'2022-04-30 11:11:19','',''),(5856,'1','223','1',1,'Retail Sale Id 6172',2002.60,0.00,0.00,3.23,103.36,'2022-04-30 11:11:41','',''),(5857,'1','223','1',1,'Retail Sale Id 6173',2498.60,0.00,0.00,4.03,128.96,'2022-04-30 11:15:04','',''),(5858,'1','223','1',1,'Retail Sale Id 6174',1202.80,0.00,0.00,1.94,62.08,'2022-04-30 11:23:25','',''),(5859,'1','223','1',1,'Retail Sale Id 6175',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 11:24:03','',''),(5860,'1','223','1',1,'Retail Sale Id 6176',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 11:25:01','',''),(5861,'1','223','1',1,'Retail Sale Id 6177',2002.60,0.00,0.00,3.23,103.36,'2022-04-30 11:37:14','',''),(5862,'1','223','1',1,'Retail Sale Id 6178',1240.00,0.00,0.00,2.00,64.00,'2022-04-30 11:39:37','',''),(5863,'1','223','1',1,'Retail Sale Id 6179',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 11:55:09','',''),(5864,'1','223','1',1,'Retail Sale Id 6180',2002.60,0.00,0.00,3.23,103.36,'2022-04-30 12:07:56','',''),(5865,'1','223','1',1,'Retail Sale Id 6181',2498.60,0.00,0.00,4.03,128.96,'2022-04-30 12:09:04','',''),(5866,'1','223','1',1,'Retail Sale Id 6183',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 12:12:09','',''),(5867,'1','223','1',1,'Retail Sale Id 6184',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 12:14:10','',''),(5868,'1','223','1',1,'Retail Sale Id 6185',1240.00,0.00,0.00,2.00,64.00,'2022-04-30 12:15:04','',''),(5869,'1','223','1',1,'Retail Sale Id 6186',899.00,0.00,0.00,1.45,46.40,'2022-04-30 12:18:15','',''),(5870,'1','223','1',1,'Retail Sale Id 6187',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 12:31:02','',''),(5871,'1','223','1',1,'Retail Sale Id 6188',5902.40,0.00,0.00,9.52,304.64,'2022-04-30 12:40:28','',''),(5872,'1','223','1',1,'Retail Sale Id 6189',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 12:47:30','',''),(5873,'1','223','1',1,'Retail Sale Id 6190',2002.60,0.00,0.00,3.23,103.36,'2022-04-30 12:48:02','',''),(5874,'1','223','1',1,'Retail Sale Id 6191',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 12:50:05','',''),(5875,'1','223','1',1,'Retail Sale Id 6192',30000.00,0.00,0.00,50.00,600.00,'2022-04-30 12:51:42','',''),(5876,'1','223','1',1,'Retail Sale Id 6193',1252.40,0.00,0.00,2.02,64.64,'2022-04-30 12:53:18','',''),(5877,'1','223','1',1,'Retail Sale Id 6194',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 13:11:22','',''),(5878,'1','223','1',1,'Retail Sale Id 6195',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 13:18:08','',''),(5879,'1','223','1',1,'Retail Sale Id 6196',2498.60,0.00,0.00,4.03,128.96,'2022-04-30 13:22:34','',''),(5880,'1','223','1',1,'Retail Sale Id 6197',1798.00,0.00,0.00,2.90,92.80,'2022-04-30 13:23:10','',''),(5881,'1','223','1',1,'Retail Sale Id 6198',1847.60,0.00,0.00,2.98,95.36,'2022-04-30 13:25:08','',''),(5882,'1','223','1',1,'Retail Sale Id 6199',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 13:32:00','',''),(5883,'1','223','1',1,'Retail Sale Id 6201',7750.00,0.00,0.00,12.50,400.00,'2022-04-30 13:36:57','',''),(5884,'1','223','1',1,'Retail Sale Id 6202',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 13:38:46','',''),(5885,'1','223','1',1,'Retail Sale Id 6203',1240.00,0.00,0.00,2.00,64.00,'2022-04-30 13:39:31','',''),(5886,'1','223','1',1,'Retail Sale Id 6204',1500.40,0.00,0.00,2.42,77.44,'2022-04-30 13:52:56','',''),(5887,'1','223','1',1,'Retail Sale Id 6205',7750.00,0.00,0.00,12.50,400.00,'2022-04-30 14:04:41','',''),(5888,'1','223','1',1,'Retail Sale Id 6206',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 14:06:06','',''),(5889,'1','223','1',1,'Retail Sale Id 6207',3751.00,0.00,0.00,6.05,193.60,'2022-04-30 14:10:53','',''),(5890,'1','223','1',1,'Retail Sale Id 6208',1847.60,0.00,0.00,2.98,95.36,'2022-04-30 14:12:06','',''),(5891,'1','223','1',1,'Retail Sale Id 6209',651.00,0.00,0.00,1.05,33.60,'2022-04-30 14:23:18','',''),(5892,'1','223','1',1,'Retail Sale Id 6210',3751.00,0.00,0.00,6.05,193.60,'2022-04-30 14:33:55','',''),(5893,'1','223','1',1,'Retail Sale Id 6211',1240.00,0.00,0.00,2.00,64.00,'2022-04-30 14:38:59','',''),(5894,'1','223','1',1,'Retail Sale Id 6212',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 14:45:59','',''),(5895,'1','223','1',1,'Retail Sale Id 6213',715200.00,0.00,0.00,1192.00,14304.00,'2022-04-30 14:49:51','',''),(5896,'1','223','1',1,'Return of Retail Sale Id 6213',0.00,715200.00,1192.00,0.00,-14304.00,'2022-04-30 14:51:06','',''),(5897,'1','223','1',1,'Retail Sale Id 6214',601152.00,0.00,0.00,1001.92,12023.04,'2022-04-30 14:52:09','',''),(5898,'1','223','1',1,'Retail Sale Id 6215',2002.60,0.00,0.00,3.23,103.36,'2022-04-30 14:55:13','',''),(5899,'1','223','1',1,'Retail Sale Id 6216',502.20,0.00,0.00,0.81,25.92,'2022-04-30 14:57:24','',''),(5900,'1','223','1',1,'Retail Sale Id 6217',3751.00,0.00,0.00,6.05,193.60,'2022-04-30 15:03:14','',''),(5901,'1','223','1',1,'Retail Sale Id 6218',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 15:04:20','',''),(5902,'1','223','1',1,'Retail Sale Id 6219',998.20,0.00,0.00,1.61,51.52,'2022-04-30 15:06:28','',''),(5903,'1','223','1',1,'Retail Sale Id 6220',2002.60,0.00,0.00,3.23,103.36,'2022-04-30 15:07:13','',''),(5904,'1','223','1',1,'Retail Sale Id 6221',2498.60,0.00,0.00,4.03,128.96,'2022-04-30 15:08:01','',''),(5905,'1','223','1',1,'Retail Sale Id 6222',1240.00,0.00,0.00,2.00,64.00,'2022-04-30 15:12:58','',''),(5906,'1','223','1',1,'Retail Sale Id 6223',998.20,0.00,0.00,1.61,51.52,'2022-04-30 15:19:39','',''),(5907,'1','223','1',1,'Retail Sale Id 6224',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 15:26:20','',''),(5908,'1','223','1',1,'Retail Sale Id 6225',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 15:32:15','',''),(5909,'1','223','1',1,'Retail Sale Id 6226',7750.00,0.00,0.00,12.50,400.00,'2022-04-30 15:50:23','',''),(5910,'1','223','1',1,'Retail Sale Id 6227',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 15:56:24','',''),(5911,'1','223','1',1,'Retail Sale Id 6228',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 15:57:11','',''),(5912,'1','223','1',1,'Retail Sale Id 6229',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 15:58:11','',''),(5913,'1','223','1',1,'Retail Sale Id 6230',1847.60,0.00,0.00,2.98,95.36,'2022-04-30 16:01:34','',''),(5914,'1','223','1',1,'Retail Sale Id 6231',66000.00,0.00,0.00,110.00,1320.00,'2022-04-30 16:02:31','',''),(5915,'1','223','1',1,'Retail Sale Id 6232',1252.40,0.00,0.00,2.02,64.64,'2022-04-30 16:05:00','',''),(5916,'1','223','1',1,'Retail Sale Id 6233',1252.40,0.00,0.00,2.02,64.64,'2022-04-30 16:05:46','',''),(5917,'1','223','1',1,'Retail Sale Id 6235',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 16:10:02','',''),(5918,'1','223','1',1,'Retail Sale Id 6236',3751.00,0.00,0.00,6.05,193.60,'2022-04-30 16:11:47','',''),(5919,'1','223','1',1,'Retail Sale Id 6237',1252.40,0.00,0.00,2.02,64.64,'2022-04-30 16:13:46','',''),(5920,'1','223','1',1,'Retail Sale Id 6238',3732.40,0.00,0.00,6.02,192.64,'2022-04-30 16:21:40','',''),(5921,'1','223','1',1,'Retail Sale Id 6240',3000.80,0.00,0.00,4.84,154.88,'2022-04-30 16:26:23','',''),(5922,'1','223','1',1,'Retail Sale Id 6241',3720.00,0.00,0.00,6.00,192.00,'2022-04-30 16:28:06','',''),(5923,'1','223','1',1,'Retail Sale Id 6242',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 16:30:40','',''),(5924,'1','223','1',1,'Retail Sale Id 6243',2498.60,0.00,0.00,4.03,128.96,'2022-04-30 16:32:18','',''),(5925,'1','223','1',1,'Retail Sale Id 6244',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 16:33:06','',''),(5926,'1','223','1',1,'Retail Sale Id 6245',1897.20,0.00,0.00,3.06,97.92,'2022-04-30 16:34:08','',''),(5927,'1','223','1',1,'Retail Sale Id 6246',1500.40,0.00,0.00,2.42,77.44,'2022-04-30 16:34:35','',''),(5928,'1','223','1',1,'Retail Sale Id 6247',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 16:36:42','',''),(5929,'1','223','1',1,'Retail Sale Id 6248',2480.00,0.00,0.00,4.00,128.00,'2022-04-30 16:37:37','',''),(5930,'1','223','1',1,'Retail Sale Id 6249',2480.00,0.00,0.00,4.00,128.00,'2022-04-30 16:40:24','',''),(5931,'1','223','1',1,'Retail Sale Id 6250',1240.00,0.00,0.00,2.00,64.00,'2022-04-30 16:41:13','',''),(5932,'1','223','1',1,'Retail Sale Id 6251',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 16:44:37','',''),(5933,'1','223','1',1,'Retail Sale Id 6252',1860.00,0.00,0.00,3.00,96.00,'2022-04-30 16:47:12','',''),(5934,'1','223','1',1,'Retail Sale Id 6253',18000.00,0.00,0.00,30.00,360.00,'2022-04-30 16:51:27','',''),(5935,'1','223','1',1,'Retail Sale Id 6254',620.00,0.00,0.00,1.00,32.00,'2022-04-30 16:52:49','',''),(5936,'1','223','1',1,'Retail Sale Id 6255',1240.00,0.00,0.00,2.00,64.00,'2022-04-30 16:54:27','',''),(5937,'1','223','1',1,'Retail Sale Id 6256',3100.00,0.00,0.00,5.00,160.00,'2022-04-30 17:14:26','',''),(5938,'1','223','1',1,'Retail Sale Id 6257',2170.00,0.00,0.00,3.50,112.00,'2022-04-30 17:39:38','',''),(5939,'1','223','1',1,'Retail Sale Id 6258',28551.00,0.00,0.00,46.05,1473.60,'2022-04-30 17:42:19','',''),(5940,'1','223','1',1,'Distributed to A A RANO NIGERIA LIMITED for sales id:6',101465.28,0.00,0.00,172.56,0.00,'2022-05-01 08:32:50','',''),(5941,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,2890000.00,5000.00,0.00,0.00,'2022-05-01 18:24:53','',''),(5942,'1','223',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,5000.00,0.00,'2022-05-01 18:27:12','',''),(5943,'1','223','1',1,'Received from bridging 11',0.00,0.00,5000.00,0.00,0.00,'2022-05-01 18:27:12','',''),(5944,'1','223','1',1,'Retail Sale Id 6259',218835.20,0.00,0.00,352.96,14824.32,'2022-05-01 19:11:36','',''),(5945,'1','223','1',1,'Retail Sale Id 6260',242134.80,0.00,0.00,390.54,16402.68,'2022-05-01 19:12:21','',''),(5946,'1','223','1',1,'Retail Sale Id 6262',30000.00,0.00,0.00,50.00,1100.00,'2022-05-01 19:13:46','',''),(5947,'1','223','1',1,'Retail Sale Id 6263',75000.00,0.00,0.00,125.00,2750.00,'2022-05-01 19:14:32','',''),(5948,'1','223','1',1,'Retail Sale Id 6264',24998.40,0.00,0.00,40.32,1693.44,'2022-05-02 10:15:29','',''),(5949,'1','223','1',1,'Retail Sale Id 6265',2002.60,0.00,0.00,3.23,135.66,'2022-05-02 10:16:47','',''),(5950,'1','223','1',1,'Retail Sale Id 6266',3552.60,0.00,0.00,5.73,240.66,'2022-05-02 10:20:41','',''),(5951,'1','223','1',1,'Retail Sale Id 6267',998.20,0.00,0.00,1.61,67.62,'2022-05-02 10:21:20','',''),(5952,'1','223','1',1,'Retail Sale Id 6268',620.00,0.00,0.00,1.00,42.00,'2022-05-02 10:23:43','',''),(5953,'1','223','1',1,'Retail Sale Id 6269',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 10:25:48','',''),(5954,'1','223','1',1,'Retail Sale Id 6270',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 11:32:50','',''),(5955,'1','223','1',1,'Retail Sale Id 6271',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 11:47:58','',''),(5956,'1','223','1',1,'Retail Sale Id 6272',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 11:48:46','',''),(5957,'1','223','1',1,'Retail Sale Id 6273',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 11:49:54','',''),(5958,'1','223','1',1,'Retail Sale Id 6274',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 11:50:58','',''),(5959,'1','223','1',1,'Retail Sale Id 6275',376420.00,0.00,0.00,638.00,7656.00,'2022-05-02 11:54:14','',''),(5960,'1','223','1',1,'Retail Sale Id 6276',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 11:58:54','',''),(5961,'1','223','1',1,'Retail Sale Id 6277',3000.80,0.00,0.00,4.84,203.28,'2022-05-02 11:59:47','',''),(5962,'1','223','1',1,'Retail Sale Id 6278',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 12:00:40','',''),(5963,'1','223','1',1,'Retail Sale Id 6279',6200.00,0.00,0.00,10.00,420.00,'2022-05-02 12:02:18','',''),(5964,'1','223','1',1,'Retail Sale Id 6280',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 12:03:21','',''),(5965,'1','223','1',1,'Retail Sale Id 6281',9579.00,0.00,0.00,15.45,648.90,'2022-05-02 12:06:07','',''),(5966,'1','223','1',1,'Return of Retail Sale Id 6264',0.00,24998.40,40.32,0.00,-1693.44,'2022-05-02 12:07:06','',''),(5967,'1','223','1',1,'Retail Sale Id 6282',23600.00,0.00,0.00,40.00,480.00,'2022-05-02 12:08:07','',''),(5968,'1','223','1',1,'Retail Sale Id 6283',2498.60,0.00,0.00,4.03,169.26,'2022-05-02 12:13:14','',''),(5969,'1','223','1',1,'Retail Sale Id 6284',1897.20,0.00,0.00,3.06,128.52,'2022-05-02 12:15:20','',''),(5970,'1','223','1',1,'Retail Sale Id 6285',1240.00,0.00,0.00,2.00,84.00,'2022-05-02 12:33:02','',''),(5971,'1','223','1',1,'Retail Sale Id 6286',7750.00,0.00,0.00,12.50,525.00,'2022-05-02 12:40:09','',''),(5972,'1','223','1',1,'Retail Sale Id 6287',3720.00,0.00,0.00,6.00,252.00,'2022-05-02 12:41:11','',''),(5973,'1','223','1',1,'Retail Sale Id 6288',51625.00,0.00,0.00,87.50,1050.00,'2022-05-02 12:48:17','',''),(5974,'1','223','1',1,'Retail Sale Id 6289',1240.00,0.00,0.00,2.00,84.00,'2022-05-02 12:49:58','',''),(5975,'1','223','1',1,'Retail Sale Id 6290',7750.00,0.00,0.00,12.50,525.00,'2022-05-02 12:50:38','',''),(5976,'1','223','1',1,'Retail Sale Id 6291',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 13:17:28','',''),(5977,'1','223','1',1,'Retail Sale Id 6292',1202.80,0.00,0.00,1.94,81.48,'2022-05-02 13:21:04','',''),(5978,'1','223','1',1,'Retail Sale Id 6293',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 13:26:03','',''),(5979,'1','223','1',1,'Retail Sale Id 6294',1302.00,0.00,0.00,2.10,88.20,'2022-05-02 13:35:34','',''),(5980,'1','223','1',1,'Retail Sale Id 6295',998.20,0.00,0.00,1.61,67.62,'2022-05-02 14:04:14','',''),(5981,'1','223','1',1,'Retail Sale Id 6296',2480.00,0.00,0.00,4.00,168.00,'2022-05-02 14:11:06','',''),(5982,'1','223','1',1,'Retail Sale Id 6297',2002.60,0.00,0.00,3.23,135.66,'2022-05-02 14:22:05','',''),(5983,'1','223','1',1,'Retail Sale Id 6298',998.20,0.00,0.00,1.61,67.62,'2022-05-02 14:25:50','',''),(5984,'1','223','1',1,'Retail Sale Id 6299',7440.00,0.00,0.00,12.00,504.00,'2022-05-02 14:31:20','',''),(5985,'1','223','1',1,'Retail Sale Id 6300',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 14:36:14','',''),(5986,'1','223','1',1,'Retail Sale Id 6301',3720.00,0.00,0.00,6.00,252.00,'2022-05-02 14:38:13','',''),(5987,'1','223','1',1,'Retail Sale Id 6302',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 15:06:20','',''),(5988,'1','223','1',1,'Retail Sale Id 6303',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 15:30:04','',''),(5989,'1','223','1',1,'Retail Sale Id 6304',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 15:31:02','',''),(5990,'1','223','1',1,'Retail Sale Id 6305',2498.60,0.00,0.00,4.03,169.26,'2022-05-02 15:32:23','',''),(5991,'1','223','1',1,'Retail Sale Id 6306',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 15:33:21','',''),(5992,'1','223','1',1,'Retail Sale Id 6307',998.20,0.00,0.00,1.61,67.62,'2022-05-02 15:33:59','',''),(5993,'1','223','1',1,'Retail Sale Id 6308',2480.00,0.00,0.00,4.00,168.00,'2022-05-02 15:38:31','',''),(5994,'1','223','1',1,'Retail Sale Id 6309',3751.00,0.00,0.00,6.05,254.10,'2022-05-02 15:40:50','',''),(5995,'1','223','1',1,'Retail Sale Id 6310',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 15:46:28','',''),(5996,'1','223','1',1,'Retail Sale Id 6311',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 16:06:29','',''),(5997,'1','223','1',1,'Retail Sale Id 6312',1897.20,0.00,0.00,3.06,128.52,'2022-05-02 16:07:30','',''),(5998,'1','223','1',1,'Retail Sale Id 6313',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 16:08:29','',''),(5999,'1','223','1',1,'Retail Sale Id 6314',3751.00,0.00,0.00,6.05,254.10,'2022-05-02 16:17:38','',''),(6000,'1','223','1',1,'Retail Sale Id 6315',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 16:25:22','',''),(6001,'1','223','1',1,'Retail Sale Id 6317',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 16:26:25','',''),(6002,'1','223','1',1,'Retail Sale Id 6318',1847.60,0.00,0.00,2.98,125.16,'2022-05-02 16:32:12','',''),(6003,'1','223','1',1,'Retail Sale Id 6319',29500.00,0.00,0.00,50.00,600.00,'2022-05-02 16:33:29','',''),(6004,'1','223','1',1,'Retail Sale Id 6320',7750.00,0.00,0.00,12.50,525.00,'2022-05-02 16:43:21','',''),(6005,'1','223','1',1,'Retail Sale Id 6321',998.20,0.00,0.00,1.61,67.62,'2022-05-02 16:46:05','',''),(6006,'1','223','1',1,'Retail Sale Id 6322',1897.20,0.00,0.00,3.06,128.52,'2022-05-02 16:53:15','',''),(6007,'1','223','1',1,'Retail Sale Id 6323',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 16:59:32','',''),(6008,'1','223','1',1,'Retail Sale Id 6324',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 17:00:15','',''),(6009,'1','223','1',1,'Retail Sale Id 6326',1240.00,0.00,0.00,2.00,84.00,'2022-05-02 17:01:12','',''),(6010,'1','223','1',1,'Retail Sale Id 6327',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 17:04:37','',''),(6011,'1','223','1',1,'Retail Sale Id 6328',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 17:05:43','',''),(6012,'1','223','1',1,'Retail Sale Id 6329',601.40,0.00,0.00,0.97,40.74,'2022-05-02 17:08:18','',''),(6013,'1','223','1',1,'Retail Sale Id 6330',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 17:09:08','',''),(6014,'1','223','1',1,'Retail Sale Id 6331',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 17:09:47','',''),(6015,'1','223','1',1,'Retail Sale Id 6332',7750.00,0.00,0.00,12.50,525.00,'2022-05-02 17:11:49','',''),(6016,'1','223','1',1,'Retail Sale Id 6334',3720.00,0.00,0.00,6.00,252.00,'2022-05-02 17:13:39','',''),(6017,'1','223','1',1,'Retail Sale Id 6335',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 17:32:25','',''),(6018,'1','223','1',1,'Retail Sale Id 6336',3540.00,0.00,0.00,6.00,72.00,'2022-05-02 17:35:50','',''),(6019,'1','223','1',1,'Retail Sale Id 6337',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 17:40:43','',''),(6020,'1','223','1',1,'Retail Sale Id 6338',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 17:45:45','',''),(6021,'1','223','1',1,'Retail Sale Id 6339',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 17:49:36','',''),(6022,'1','223','1',1,'Retail Sale Id 6340',1860.00,0.00,0.00,3.00,126.00,'2022-05-02 17:55:15','',''),(6023,'1','223','1',1,'Retail Sale Id 6341',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 17:58:40','',''),(6024,'1','223','1',1,'Retail Sale Id 6342',651.00,0.00,0.00,1.05,44.10,'2022-05-02 18:03:44','',''),(6025,'1','223','1',1,'Retail Sale Id 6343',2002.60,0.00,0.00,3.23,135.66,'2022-05-02 18:04:41','',''),(6026,'1','223','1',1,'Retail Sale Id 6344',1897.20,0.00,0.00,3.06,128.52,'2022-05-02 18:06:41','',''),(6027,'1','223','1',1,'Retail Sale Id 6345',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 18:08:04','',''),(6028,'1','223','1',1,'Retail Sale Id 6346',1252.40,0.00,0.00,2.02,84.84,'2022-05-02 18:10:45','',''),(6029,'1','223','1',1,'Retail Sale Id 6347',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 18:11:37','',''),(6030,'1','223','1',1,'Retail Sale Id 6348',1302.00,0.00,0.00,2.10,88.20,'2022-05-02 18:20:44','',''),(6031,'1','223','1',1,'Retail Sale Id 6349',1302.00,0.00,0.00,2.10,88.20,'2022-05-02 18:22:59','',''),(6032,'1','223','1',1,'Retail Sale Id 6350',3100.00,0.00,0.00,5.00,210.00,'2022-05-02 18:44:14','',''),(6033,'1','223','1',1,'Retail Sale Id 6351',2002.60,0.00,0.00,3.23,135.66,'2022-05-02 19:17:51','',''),(6034,'1','223','1',1,'Retail Sale Id 6352',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 07:30:12','',''),(6035,'1','223','1',1,'Retail Sale Id 6353',1202.80,0.00,0.00,1.94,81.48,'2022-05-03 07:35:24','',''),(6036,'1','223','1',1,'Retail Sale Id 6354',3720.00,0.00,0.00,6.00,252.00,'2022-05-03 07:44:59','',''),(6037,'1','223','1',1,'Retail Sale Id 6355',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 08:03:31','',''),(6038,'1','223','1',1,'Retail Sale Id 6356',2002.60,0.00,0.00,3.23,135.66,'2022-05-03 08:04:28','',''),(6039,'1','223','1',1,'Retail Sale Id 6357',3751.00,0.00,0.00,6.05,254.10,'2022-05-03 08:11:30','',''),(6040,'1','223','1',1,'Retail Sale Id 6358',1897.20,0.00,0.00,3.06,128.52,'2022-05-03 08:13:19','',''),(6041,'1','223','1',1,'Retail Sale Id 6359',998.20,0.00,0.00,1.61,67.62,'2022-05-03 08:14:04','',''),(6042,'1','223','1',1,'Retail Sale Id 6362',1860.00,0.00,0.00,3.00,126.00,'2022-05-03 08:21:34','',''),(6043,'1','223','1',1,'Retail Sale Id 6363',1240.00,0.00,0.00,2.00,84.00,'2022-05-03 08:27:23','',''),(6044,'1','223','1',1,'Retail Sale Id 6364',998.20,0.00,0.00,1.61,67.62,'2022-05-03 08:28:05','',''),(6045,'1','223','1',1,'Retail Sale Id 6365',2480.00,0.00,0.00,4.00,168.00,'2022-05-03 08:29:35','',''),(6046,'1','223','1',1,'Retail Sale Id 6366',998.20,0.00,0.00,1.61,67.62,'2022-05-03 08:31:44','',''),(6047,'1','223','1',1,'Retail Sale Id 6367',1302.00,0.00,0.00,2.10,88.20,'2022-05-03 08:35:44','',''),(6048,'1','223','1',1,'Retail Sale Id 6368',700.60,0.00,0.00,1.13,47.46,'2022-05-03 08:37:05','',''),(6049,'1','223','1',1,'Retail Sale Id 6369',1860.00,0.00,0.00,3.00,126.00,'2022-05-03 08:51:30','',''),(6050,'1','223','1',1,'Retail Sale Id 6371',2498.60,0.00,0.00,4.03,169.26,'2022-05-03 09:00:05','',''),(6051,'1','223','1',1,'Retail Sale Id 6372',3720.00,0.00,0.00,6.00,252.00,'2022-05-03 09:03:14','',''),(6052,'1','223','1',1,'Retail Sale Id 6373',2002.60,0.00,0.00,3.23,135.66,'2022-05-03 09:05:09','',''),(6053,'1','223','1',1,'Retail Sale Id 6374',1252.40,0.00,0.00,2.02,84.84,'2022-05-03 09:06:10','',''),(6054,'1','223','1',1,'Retail Sale Id 6375',1252.40,0.00,0.00,2.02,84.84,'2022-05-03 09:08:36','',''),(6055,'1','223','1',1,'Retail Sale Id 6377',2201.00,0.00,0.00,3.55,149.10,'2022-05-03 09:09:30','',''),(6056,'1','223','1',1,'Retail Sale Id 6378',1897.20,0.00,0.00,3.06,128.52,'2022-05-03 09:10:29','',''),(6057,'1','223','1',1,'Retail Sale Id 6380',2002.60,0.00,0.00,3.23,135.66,'2022-05-03 09:11:29','',''),(6058,'1','223','1',1,'Retail Sale Id 6381',899.00,0.00,0.00,1.45,60.90,'2022-05-03 09:13:01','',''),(6059,'1','223','1',1,'Retail Sale Id 6382',3701.40,0.00,0.00,5.97,250.74,'2022-05-03 09:14:15','',''),(6060,'1','223','1',1,'Retail Sale Id 6383',2480.00,0.00,0.00,4.00,168.00,'2022-05-03 09:17:24','',''),(6061,'1','223','1',1,'Retail Sale Id 6384',1240.00,0.00,0.00,2.00,84.00,'2022-05-03 09:17:53','',''),(6062,'1','223','1',1,'Retail Sale Id 6385',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 09:19:47','',''),(6063,'1','223','1',1,'Retail Sale Id 6386',3503.00,0.00,0.00,5.65,237.30,'2022-05-03 09:27:42','',''),(6064,'1','223','1',1,'Retail Sale Id 6387',3720.00,0.00,0.00,6.00,252.00,'2022-05-03 09:30:33','',''),(6065,'1','223','1',1,'Retail Sale Id 6388',1252.40,0.00,0.00,2.02,84.84,'2022-05-03 09:31:32','',''),(6066,'1','223','1',1,'Retail Sale Id 6389',1798.00,0.00,0.00,2.90,121.80,'2022-05-03 09:44:48','',''),(6067,'1','223','1',1,'Retail Sale Id 6390',3751.00,0.00,0.00,6.05,254.10,'2022-05-03 09:51:08','',''),(6068,'1','223','1',1,'Retail Sale Id 6391',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 09:58:13','',''),(6069,'1','223','1',1,'Retail Sale Id 6392',2498.60,0.00,0.00,4.03,169.26,'2022-05-03 09:59:53','',''),(6070,'1','223','1',1,'Retail Sale Id 6393',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 10:00:24','',''),(6071,'1','223','1',1,'Retail Sale Id 6394',2498.60,0.00,0.00,4.03,169.26,'2022-05-03 10:01:27','',''),(6072,'1','223','1',1,'Retail Sale Id 6395',1302.00,0.00,0.00,2.10,88.20,'2022-05-03 10:02:40','',''),(6073,'1','223','1',1,'Retail Sale Id 6397',2498.60,0.00,0.00,4.03,169.26,'2022-05-03 10:03:48','',''),(6074,'1','223','1',1,'Retail Sale Id 6398',2498.60,0.00,0.00,4.03,169.26,'2022-05-03 10:14:42','',''),(6075,'1','223','1',1,'Retail Sale Id 6399',3999.00,0.00,0.00,6.45,270.90,'2022-05-03 10:16:43','',''),(6076,'1','223','1',1,'Retail Sale Id 6400',3720.00,0.00,0.00,6.00,252.00,'2022-05-03 10:53:36','',''),(6077,'1','223','1',1,'Retail Sale Id 6401',1860.00,0.00,0.00,3.00,126.00,'2022-05-03 11:08:55','',''),(6078,'1','223','1',1,'Retail Sale Id 6402',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 11:09:53','',''),(6079,'1','223','1',1,'Retail Sale Id 6403',1240.00,0.00,0.00,2.00,84.00,'2022-05-03 11:14:50','',''),(6080,'1','223','1',1,'Retail Sale Id 6404',601.40,0.00,0.00,0.97,40.74,'2022-05-03 11:20:09','',''),(6081,'1','223','1',1,'Retail Sale Id 6405',1240.00,0.00,0.00,2.00,84.00,'2022-05-03 11:45:12','',''),(6082,'1','223','1',1,'Retail Sale Id 6406',7750.00,0.00,0.00,12.50,525.00,'2022-05-03 11:45:57','',''),(6083,'1','223','1',1,'Retail Sale Id 6407',651.00,0.00,0.00,1.05,44.10,'2022-05-03 12:00:11','',''),(6084,'1','223','1',1,'Retail Sale Id 6408',30680.00,0.00,0.00,52.00,624.00,'2022-05-03 12:01:56','',''),(6085,'1','223','1',1,'Retail Sale Id 6409',1252.40,0.00,0.00,2.02,84.84,'2022-05-03 12:15:02','',''),(6086,'1','223','1',1,'Retail Sale Id 6410',3000.80,0.00,0.00,4.84,203.28,'2022-05-03 12:16:58','',''),(6087,'1','223','1',1,'Retail Sale Id 6411',3000.80,0.00,0.00,4.84,203.28,'2022-05-03 12:17:31','',''),(6088,'1','223','1',1,'Retail Sale Id 6412',1240.00,0.00,0.00,2.00,84.00,'2022-05-03 12:19:44','',''),(6089,'1','223','1',1,'Retail Sale Id 6413',1240.00,0.00,0.00,2.00,84.00,'2022-05-03 12:20:26','',''),(6090,'1','223','1',1,'Retail Sale Id 6414',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 12:29:57','',''),(6091,'1','223','1',1,'Retail Sale Id 6415',4997.20,0.00,0.00,8.06,338.52,'2022-05-03 12:32:14','',''),(6092,'1','223','1',1,'Retail Sale Id 6416',1252.40,0.00,0.00,2.02,84.84,'2022-05-03 12:35:24','',''),(6093,'1','223','1',1,'Retail Sale Id 6417',1897.20,0.00,0.00,3.06,128.52,'2022-05-03 12:46:58','',''),(6094,'1','223','1',1,'Retail Sale Id 6418',998.20,0.00,0.00,1.61,67.62,'2022-05-03 13:14:27','',''),(6095,'1','223','1',1,'Retail Sale Id 6421',2002.60,0.00,0.00,3.23,135.66,'2022-05-03 13:19:58','',''),(6096,'1','223','1',1,'Retail Sale Id 6422',2480.00,0.00,0.00,4.00,168.00,'2022-05-03 13:41:25','',''),(6097,'1','223','1',1,'Retail Sale Id 6423',3751.00,0.00,0.00,6.05,254.10,'2022-05-03 13:47:47','',''),(6098,'1','223','1',1,'Retail Sale Id 6424',1847.60,0.00,0.00,2.98,125.16,'2022-05-03 14:01:33','',''),(6099,'1','223','1',1,'Retail Sale Id 6425',591770.00,0.00,0.00,1003.00,12036.00,'2022-05-03 14:02:54','',''),(6100,'1','223','1',1,'Retail Sale Id 6426',1500.40,0.00,0.00,2.42,101.64,'2022-05-03 14:24:48','',''),(6101,'1','223','1',1,'Retail Sale Id 6427',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 14:25:40','',''),(6102,'1','223','1',1,'Retail Sale Id 6428',620.00,0.00,0.00,1.00,42.00,'2022-05-03 14:54:26','',''),(6103,'1','223','1',1,'Retail Sale Id 6429',3720.00,0.00,0.00,6.00,252.00,'2022-05-03 14:56:13','',''),(6104,'1','223','1',1,'Retail Sale Id 6430',998.20,0.00,0.00,1.61,67.62,'2022-05-03 14:57:54','',''),(6105,'1','223','1',1,'Retail Sale Id 6431',3720.00,0.00,0.00,6.00,252.00,'2022-05-03 14:58:45','',''),(6106,'1','223','1',1,'Retail Sale Id 6432',1860.00,0.00,0.00,3.00,126.00,'2022-05-03 15:01:03','',''),(6107,'1','223','1',1,'Retail Sale Id 6433',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 15:10:25','',''),(6108,'1','223','1',1,'Retail Sale Id 6434',17700.00,0.00,0.00,30.00,360.00,'2022-05-03 15:18:02','',''),(6109,'1','223','1',1,'Retail Sale Id 6435',1897.20,0.00,0.00,3.06,128.52,'2022-05-03 15:29:58','',''),(6110,'1','223','1',1,'Retail Sale Id 6436',1252.40,0.00,0.00,2.02,84.84,'2022-05-03 15:55:42','',''),(6111,'1','223','1',1,'Retail Sale Id 6437',1897.20,0.00,0.00,3.06,128.52,'2022-05-03 15:59:17','',''),(6112,'1','223','1',1,'Retail Sale Id 6438',1847.60,0.00,0.00,2.98,125.16,'2022-05-03 16:00:41','',''),(6113,'1','223','1',1,'Retail Sale Id 6439',1500.40,0.00,0.00,2.42,101.64,'2022-05-03 16:14:43','',''),(6114,'1','223','1',1,'Retail Sale Id 6441',1500.40,0.00,0.00,2.42,101.64,'2022-05-03 16:15:54','',''),(6115,'1','223','1',1,'Retail Sale Id 6442',1897.20,0.00,0.00,3.06,128.52,'2022-05-03 16:22:24','',''),(6116,'1','223','1',1,'Retail Sale Id 6443',1860.00,0.00,0.00,3.00,126.00,'2022-05-03 16:25:54','',''),(6117,'1','223','1',1,'Retail Sale Id 6450',3751.00,0.00,0.00,6.05,254.10,'2022-05-03 16:28:43','',''),(6118,'1','223','1',1,'Retail Sale Id 6451',1860.00,0.00,0.00,3.00,126.00,'2022-05-03 16:42:46','',''),(6119,'1','223','1',1,'Retail Sale Id 6452',1252.40,0.00,0.00,2.02,84.84,'2022-05-03 16:50:48','',''),(6120,'1','223','1',1,'Retail Sale Id 6453',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 16:53:24','',''),(6121,'1','223','1',1,'Retail Sale Id 6454',1500.40,0.00,0.00,2.42,101.64,'2022-05-03 16:54:57','',''),(6122,'1','223','1',1,'Retail Sale Id 6455',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 17:05:31','',''),(6123,'1','223','1',1,'Retail Sale Id 6456',3000.80,0.00,0.00,4.84,203.28,'2022-05-03 17:06:45','',''),(6124,'1','223','1',1,'Retail Sale Id 6457',502.20,0.00,0.00,0.81,34.02,'2022-05-03 17:15:49','',''),(6125,'1','223','1',1,'Retail Sale Id 6458',1252.40,0.00,0.00,2.02,84.84,'2022-05-03 17:18:36','',''),(6126,'1','223','1',1,'Retail Sale Id 6459',1860.00,0.00,0.00,3.00,126.00,'2022-05-03 17:19:33','',''),(6127,'1','223','1',1,'Retail Sale Id 6460',1240.00,0.00,0.00,2.00,84.00,'2022-05-03 17:20:27','',''),(6128,'1','223','1',1,'Retail Sale Id 6461',29500.00,0.00,0.00,50.00,600.00,'2022-05-03 17:24:39','',''),(6129,'1','223','1',1,'Retail Sale Id 6462',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 17:25:39','',''),(6130,'1','223','1',1,'Retail Sale Id 6463',7750.00,0.00,0.00,12.50,525.00,'2022-05-03 17:29:15','',''),(6131,'1','223','1',1,'Retail Sale Id 6464',1860.00,0.00,0.00,3.00,126.00,'2022-05-03 17:39:56','',''),(6132,'1','223','1',1,'Retail Sale Id 6466',2002.60,0.00,0.00,3.23,135.66,'2022-05-03 17:40:56','',''),(6133,'1','223','1',1,'Retail Sale Id 6467',7750.00,0.00,0.00,12.50,525.00,'2022-05-03 17:47:52','',''),(6134,'1','223','1',1,'Retail Sale Id 6469',2002.60,0.00,0.00,3.23,135.66,'2022-05-03 17:48:53','',''),(6135,'1','223','1',1,'Retail Sale Id 6471',2002.60,0.00,0.00,3.23,135.66,'2022-05-03 17:51:59','',''),(6136,'1','223','1',1,'Retail Sale Id 6472',1302.00,0.00,0.00,2.10,88.20,'2022-05-03 18:04:18','',''),(6137,'1','223','1',1,'Retail Sale Id 6475',1798.00,0.00,0.00,2.90,121.80,'2022-05-03 18:11:37','',''),(6138,'1','223','1',1,'Retail Sale Id 6476',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 18:12:32','',''),(6139,'1','223','1',1,'Retail Sale Id 6479',4352.40,0.00,0.00,7.02,294.84,'2022-05-03 18:13:32','',''),(6140,'1','223','1',1,'Retail Sale Id 6480',3100.00,0.00,0.00,5.00,210.00,'2022-05-03 18:14:41','',''),(6141,'1','223','1',1,'Retail Sale Id 6481',2480.00,0.00,0.00,4.00,168.00,'2022-05-03 18:24:20','',''),(6142,'1','223','1',1,'Retail Sale Id 6485',1847.60,0.00,0.00,2.98,125.16,'2022-05-03 18:30:38','',''),(6143,'1','223','1',1,'Retail Sale Id 6486',1252.40,0.00,0.00,2.02,84.84,'2022-05-03 18:31:53','',''),(6144,'1','223','1',1,'Retail Sale Id 6487',1240.00,0.00,0.00,2.00,84.00,'2022-05-03 18:32:40','',''),(6145,'1','223','1',1,'Retail Sale Id 6488',620.00,0.00,0.00,1.00,42.00,'2022-05-03 18:33:14','',''),(6146,'1','223','1',1,'Retail Sale Id 6489',2480.00,0.00,0.00,4.00,168.00,'2022-05-03 18:38:26','',''),(6147,'1','223','1',1,'Retail Sale Id 6490',31.00,0.00,0.00,0.05,2.10,'2022-05-03 19:13:27','',''),(6148,'1','223','1',1,'Return of Retail Sale Id 6490',0.00,31.00,0.05,0.00,-2.10,'2022-05-03 19:14:01','',''),(6149,'1','223','1',1,'Retail Sale Id 6491',18.60,0.00,0.00,0.03,1.26,'2022-05-03 19:14:24','',''),(6150,'1','223','1',1,'Retail Sale Id 6492',7750.00,0.00,0.00,12.50,525.00,'2022-05-04 08:17:53','',''),(6151,'1','223','1',1,'Retail Sale Id 6493',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 08:53:59','',''),(6152,'1','223','1',1,'Retail Sale Id 6494',2002.60,0.00,0.00,3.23,135.66,'2022-05-04 09:14:29','',''),(6153,'1','223','1',1,'Retail Sale Id 6495',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 09:15:56','',''),(6154,'1','223','1',1,'Retail Sale Id 6496',2480.00,0.00,0.00,4.00,168.00,'2022-05-04 09:21:24','',''),(6155,'1','223','1',1,'Retail Sale Id 6497',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 09:30:32','',''),(6156,'1','223','1',1,'Retail Sale Id 6498',1698.80,0.00,0.00,2.74,115.08,'2022-05-04 09:35:47','',''),(6157,'1','223','1',1,'Retail Sale Id 6499',2498.60,0.00,0.00,4.03,169.26,'2022-05-04 09:40:13','',''),(6158,'1','223','1',1,'Retail Sale Id 6500',601.40,0.00,0.00,0.97,40.74,'2022-05-04 09:48:26','',''),(6159,'1','223','1',1,'Retail Sale Id 6501',3720.00,0.00,0.00,6.00,252.00,'2022-05-04 10:10:14','',''),(6160,'1','223','1',1,'Retail Sale Id 6502',1872.40,0.00,0.00,3.02,126.84,'2022-05-04 10:24:47','',''),(6161,'1','223','1',1,'Return of Retail Sale Id 6502',0.00,1872.40,3.02,0.00,-126.84,'2022-05-04 10:25:01','',''),(6162,'1','223','1',1,'Retail Sale Id 6503',1897.20,0.00,0.00,3.06,128.52,'2022-05-04 10:25:27','',''),(6163,'1','223','1',1,'Retail Sale Id 6504',3720.00,0.00,0.00,6.00,252.00,'2022-05-04 10:33:39','',''),(6164,'1','223','1',1,'Retail Sale Id 6505',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 10:35:55','',''),(6165,'1','223','1',1,'Retail Sale Id 6506',3100.00,0.00,0.00,5.00,210.00,'2022-05-04 10:43:15','',''),(6166,'1','223','1',1,'Retail Sale Id 6507',998.20,0.00,0.00,1.61,67.62,'2022-05-04 10:47:02','',''),(6167,'1','223','1',1,'Retail Sale Id 6509',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 10:49:21','',''),(6168,'1','223','1',1,'Retail Sale Id 6510',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 10:56:50','',''),(6169,'1','223','1',1,'Retail Sale Id 6511',998.20,0.00,0.00,1.61,67.62,'2022-05-04 11:03:50','',''),(6170,'1','223','1',1,'Retail Sale Id 6513',1500.40,0.00,0.00,2.42,101.64,'2022-05-04 11:11:19','',''),(6171,'1','223','1',1,'Retail Sale Id 6514',998.20,0.00,0.00,1.61,67.62,'2022-05-04 11:13:21','',''),(6172,'1','223','1',1,'Retail Sale Id 6515',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 11:20:04','',''),(6173,'1','223','1',1,'Retail Sale Id 6516',1202.80,0.00,0.00,1.94,81.48,'2022-05-04 11:21:39','',''),(6174,'1','223','1',1,'Retail Sale Id 6517',2498.60,0.00,0.00,4.03,169.26,'2022-05-04 11:22:31','',''),(6175,'1','223','1',1,'Retail Sale Id 6518',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 11:23:10','',''),(6176,'1','223','1',1,'Retail Sale Id 6520',1798.00,0.00,0.00,2.90,121.80,'2022-05-04 11:24:28','',''),(6177,'1','223','1',1,'Retail Sale Id 6521',2498.60,0.00,0.00,4.03,169.26,'2022-05-04 11:35:23','',''),(6178,'1','223','1',1,'Retail Sale Id 6522',3751.00,0.00,0.00,6.05,254.10,'2022-05-04 11:37:01','',''),(6179,'1','223','1',1,'Retail Sale Id 6523',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 11:37:55','',''),(6180,'1','223','1',1,'Retail Sale Id 6524',3100.00,0.00,0.00,5.00,210.00,'2022-05-04 11:40:33','',''),(6181,'1','223','1',1,'Retail Sale Id 6531',998.20,0.00,0.00,1.61,67.62,'2022-05-04 11:41:38','',''),(6182,'1','223','1',1,'Retail Sale Id 6532',3100.00,0.00,0.00,5.00,210.00,'2022-05-04 11:42:26','',''),(6183,'1','223','1',1,'Retail Sale Id 6533',2002.60,0.00,0.00,3.23,135.66,'2022-05-04 11:44:13','',''),(6184,'1','223','1',1,'Retail Sale Id 6534',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 11:46:50','',''),(6185,'1','223','1',1,'Retail Sale Id 6535',3720.00,0.00,0.00,6.00,252.00,'2022-05-04 11:48:58','',''),(6186,'1','223','1',1,'Retail Sale Id 6536',620.00,0.00,0.00,1.00,42.00,'2022-05-04 11:51:04','',''),(6187,'1','223','1',1,'Retail Sale Id 6537',620.00,0.00,0.00,1.00,42.00,'2022-05-04 11:51:29','',''),(6188,'1','223','1',1,'Retail Sale Id 6538',1500.40,0.00,0.00,2.42,101.64,'2022-05-04 11:52:49','',''),(6189,'1','223','1',1,'Return of Retail Sale Id 6538',0.00,1500.40,2.42,0.00,-101.64,'2022-05-04 11:53:14','',''),(6190,'1','223','1',1,'Retail Sale Id 6539',1599.60,0.00,0.00,2.58,108.36,'2022-05-04 11:53:30','',''),(6191,'1','223','1',1,'Retail Sale Id 6540',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 11:54:09','',''),(6192,'1','223','1',1,'Retail Sale Id 6541',1897.20,0.00,0.00,3.06,128.52,'2022-05-04 11:55:40','',''),(6193,'1','223','1',1,'Return of Retail Sale Id 6541',0.00,1897.20,3.06,0.00,-128.52,'2022-05-04 11:56:02','',''),(6194,'1','223','1',1,'Retail Sale Id 6543',2300.20,0.00,0.00,3.71,155.82,'2022-05-04 11:56:21','',''),(6195,'1','223','1',1,'Retail Sale Id 6544',64900.00,0.00,0.00,110.00,1320.00,'2022-05-04 12:01:43','',''),(6196,'1','223','1',1,'Retail Sale Id 6545',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 12:03:18','',''),(6197,'1','223','1',1,'Retail Sale Id 6546',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 12:04:08','',''),(6198,'1','223','1',1,'Retail Sale Id 6547',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 12:05:07','',''),(6199,'1','223','1',1,'Retail Sale Id 6549',7750.00,0.00,0.00,12.50,525.00,'2022-05-04 12:16:24','',''),(6200,'1','223','1',1,'Retail Sale Id 6550',620.00,0.00,0.00,1.00,42.00,'2022-05-04 12:21:47','',''),(6201,'1','223','1',1,'Retail Sale Id 6551',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 12:22:42','',''),(6202,'1','223','1',1,'Retail Sale Id 6552',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 12:23:47','',''),(6203,'1','223','1',1,'Retail Sale Id 6553',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 12:29:37','',''),(6204,'1','223','1',1,'Retail Sale Id 6554',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 12:34:15','',''),(6205,'1','223','1',1,'Retail Sale Id 6555',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 12:37:37','',''),(6206,'1','223','1',1,'Retail Sale Id 6556',1500.40,0.00,0.00,2.42,101.64,'2022-05-04 12:38:33','',''),(6207,'1','223','1',1,'Retail Sale Id 6557',2480.00,0.00,0.00,4.00,168.00,'2022-05-04 12:48:41','',''),(6208,'1','223','1',1,'Retail Sale Id 6558',2480.00,0.00,0.00,4.00,168.00,'2022-05-04 12:52:15','',''),(6209,'1','223','1',1,'Retail Sale Id 6559',7750.00,0.00,0.00,12.50,525.00,'2022-05-04 13:01:31','',''),(6210,'1','223','1',1,'Retail Sale Id 6560',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 13:02:24','',''),(6211,'1','223','1',1,'Retail Sale Id 6561',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 13:04:32','',''),(6212,'1','223','1',1,'Retail Sale Id 6562',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 13:17:42','',''),(6213,'1','223','1',1,'Retail Sale Id 6563',6200.00,0.00,0.00,10.00,420.00,'2022-05-04 13:18:53','',''),(6214,'1','223','1',1,'Retail Sale Id 6565',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 13:22:28','',''),(6215,'1','223','1',1,'Retail Sale Id 6566',3100.00,0.00,0.00,5.00,210.00,'2022-05-04 13:27:16','',''),(6216,'1','223','1',1,'Retail Sale Id 6567',3000.80,0.00,0.00,4.84,203.28,'2022-05-04 13:29:51','',''),(6217,'1','223','1',1,'Retail Sale Id 6570',3720.00,0.00,0.00,6.00,252.00,'2022-05-04 13:33:33','',''),(6218,'1','223','1',1,'Retail Sale Id 6571',1401.20,0.00,0.00,2.26,94.92,'2022-05-04 13:34:39','',''),(6219,'1','223','1',1,'Retail Sale Id 6572',1897.20,0.00,0.00,3.06,128.52,'2022-05-04 13:38:45','',''),(6220,'1','223','1',1,'Retail Sale Id 6573',1302.00,0.00,0.00,2.10,88.20,'2022-05-04 13:41:24','',''),(6221,'1','223','1',1,'Retail Sale Id 6574',1500.40,0.00,0.00,2.42,101.64,'2022-05-04 13:43:49','',''),(6222,'1','223','1',1,'Retail Sale Id 6575',1500.40,0.00,0.00,2.42,101.64,'2022-05-04 13:44:36','',''),(6223,'1','223','1',1,'Retail Sale Id 6576',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 13:45:14','',''),(6224,'1','223','1',1,'Retail Sale Id 6577',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 13:47:13','',''),(6225,'1','223','1',1,'Retail Sale Id 6578',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 13:49:22','',''),(6226,'1','223','1',1,'Retail Sale Id 6579',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 13:56:19','',''),(6227,'1','223','1',1,'Retail Sale Id 6580',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 14:07:37','',''),(6228,'1','223','1',1,'Retail Sale Id 6581',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 14:11:27','',''),(6229,'1','223','1',1,'Retail Sale Id 6582',1302.00,0.00,0.00,2.10,88.20,'2022-05-04 14:18:44','',''),(6230,'1','223','1',1,'Retail Sale Id 6583',4997.20,0.00,0.00,8.06,338.52,'2022-05-04 14:26:23','',''),(6231,'1','223','1',1,'Retail Sale Id 6584',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 14:28:20','',''),(6232,'1','223','1',1,'Retail Sale Id 6585',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 14:32:08','',''),(6233,'1','223','1',1,'Retail Sale Id 6586',3100.00,0.00,0.00,5.00,210.00,'2022-05-04 14:33:05','',''),(6234,'1','223','1',1,'Retail Sale Id 6587',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 14:42:18','',''),(6235,'1','223','1',1,'Retail Sale Id 6588',34810.00,0.00,0.00,59.00,708.00,'2022-05-04 14:46:30','',''),(6236,'1','223','1',1,'Retail Sale Id 6589',7750.00,0.00,0.00,12.50,525.00,'2022-05-04 14:48:23','',''),(6237,'1','223','1',1,'Retail Sale Id 6590',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 14:50:36','',''),(6238,'1','223','1',1,'Retail Sale Id 6591',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 14:51:17','',''),(6239,'1','223','1',1,'Retail Sale Id 6592',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 14:51:58','',''),(6240,'1','223','1',1,'Retail Sale Id 6593',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 14:59:10','',''),(6241,'1','223','1',1,'Retail Sale Id 6594',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 15:06:04','',''),(6242,'1','223','1',1,'Retail Sale Id 6595',3751.00,0.00,0.00,6.05,254.10,'2022-05-04 15:11:36','',''),(6243,'1','223','1',1,'Retail Sale Id 6597',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 15:41:46','',''),(6244,'1','223','1',1,'Retail Sale Id 6598',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 15:45:06','',''),(6245,'1','223','1',1,'Retail Sale Id 6599',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 15:46:02','',''),(6246,'1','223','1',1,'Retail Sale Id 6600',620.00,0.00,0.00,1.00,42.00,'2022-05-04 15:48:59','',''),(6247,'1','223','1',1,'Retail Sale Id 6601',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 15:54:15','',''),(6248,'1','223','1',1,'Retail Sale Id 6602',620.00,0.00,0.00,1.00,42.00,'2022-05-04 16:00:28','',''),(6249,'1','223','1',1,'Retail Sale Id 6603',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 16:02:17','',''),(6250,'1','223','1',1,'Retail Sale Id 6604',73750.00,0.00,0.00,125.00,1500.00,'2022-05-04 16:05:42','',''),(6251,'1','223','1',1,'Retail Sale Id 6605',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 16:06:29','',''),(6252,'1','223','1',1,'Retail Sale Id 6607',2399.40,0.00,0.00,3.87,162.54,'2022-05-04 16:10:05','',''),(6253,'1','223','1',1,'Retail Sale Id 6609',3100.00,0.00,0.00,5.00,210.00,'2022-05-04 16:18:53','',''),(6254,'1','223','1',1,'Retail Sale Id 6610',3720.00,0.00,0.00,6.00,252.00,'2022-05-04 16:20:30','',''),(6255,'1','223','1',1,'Retail Sale Id 6611',3720.00,0.00,0.00,6.00,252.00,'2022-05-04 16:21:52','',''),(6256,'1','223','1',1,'Retail Sale Id 6612',1202.80,0.00,0.00,1.94,81.48,'2022-05-04 16:23:06','',''),(6257,'1','223','1',1,'Retail Sale Id 6613',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 16:29:36','',''),(6258,'1','223','1',1,'Retail Sale Id 6614',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 16:33:44','',''),(6259,'1','223','1',1,'Retail Sale Id 6615',17700.00,0.00,0.00,30.00,360.00,'2022-05-04 16:37:06','',''),(6260,'1','223','1',1,'Retail Sale Id 6616',998.20,0.00,0.00,1.61,67.62,'2022-05-04 16:38:50','',''),(6261,'1','223','1',1,'Retail Sale Id 6617',6200.00,0.00,0.00,10.00,420.00,'2022-05-04 16:40:13','',''),(6262,'1','223','1',1,'Retail Sale Id 6618',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 16:46:44','',''),(6263,'1','223','1',1,'Retail Sale Id 6619',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 17:01:10','',''),(6264,'1','223','1',1,'Retail Sale Id 6620',3100.00,0.00,0.00,5.00,210.00,'2022-05-04 17:01:56','',''),(6265,'1','223','1',1,'Retail Sale Id 6621',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 17:07:09','',''),(6266,'1','223','1',1,'Retail Sale Id 6622',297.60,0.00,0.00,0.48,20.16,'2022-05-04 17:08:43','',''),(6267,'1','223','1',1,'Retail Sale Id 6623',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 17:09:50','',''),(6268,'1','223','1',1,'Retail Sale Id 6623',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 17:09:50','',''),(6269,'1','223','1',1,'Retail Sale Id 6624',3100.00,0.00,0.00,5.00,210.00,'2022-05-04 17:11:38','',''),(6270,'1','223','1',1,'Retail Sale Id 6625',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 17:12:54','',''),(6271,'1','223','1',1,'Retail Sale Id 6626',1847.60,0.00,0.00,2.98,125.16,'2022-05-04 17:14:24','',''),(6272,'1','223','1',1,'Retail Sale Id 6627',651.00,0.00,0.00,1.05,44.10,'2022-05-04 17:22:32','',''),(6273,'1','223','1',1,'Retail Sale Id 6629',2002.60,0.00,0.00,3.23,135.66,'2022-05-04 17:23:56','',''),(6274,'1','223','1',1,'Retail Sale Id 6630',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 17:25:31','',''),(6275,'1','223','1',1,'Retail Sale Id 6631',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 17:32:55','',''),(6276,'1','223','1',1,'Retail Sale Id 6632',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 17:34:43','',''),(6277,'1','223','1',1,'Retail Sale Id 6633',2002.60,0.00,0.00,3.23,135.66,'2022-05-04 17:37:25','',''),(6278,'1','223','1',1,'Retail Sale Id 6634',1500.40,0.00,0.00,2.42,101.64,'2022-05-04 17:38:05','',''),(6279,'1','223','1',1,'Retail Sale Id 6635',1401.20,0.00,0.00,2.26,94.92,'2022-05-04 17:42:19','',''),(6280,'1','223','1',1,'Retail Sale Id 6636',998.20,0.00,0.00,1.61,67.62,'2022-05-04 17:44:00','',''),(6281,'1','223','1',1,'Retail Sale Id 6637',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 17:44:38','',''),(6282,'1','223','1',1,'Retail Sale Id 6638',620.00,0.00,0.00,1.00,42.00,'2022-05-04 17:46:05','',''),(6283,'1','223','1',1,'Retail Sale Id 6639',651.00,0.00,0.00,1.05,44.10,'2022-05-04 17:49:08','',''),(6284,'1','223','1',1,'Retail Sale Id 6640',1180.00,0.00,0.00,2.00,24.00,'2022-05-04 17:52:11','',''),(6285,'1','223','1',1,'Retail Sale Id 6641',3720.00,0.00,0.00,6.00,252.00,'2022-05-04 17:54:18','',''),(6286,'1','223','1',1,'Retail Sale Id 6642',620.00,0.00,0.00,1.00,42.00,'2022-05-04 17:55:09','',''),(6287,'1','223','1',1,'Retail Sale Id 6643',3100.00,0.00,0.00,5.00,210.00,'2022-05-04 17:55:58','',''),(6288,'1','223','1',1,'Retail Sale Id 6644',620.00,0.00,0.00,1.00,42.00,'2022-05-04 17:57:55','',''),(6289,'1','223','1',1,'Retail Sale Id 6646',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 17:59:28','',''),(6290,'1','223','1',1,'Retail Sale Id 6648',3720.00,0.00,0.00,6.00,252.00,'2022-05-04 18:01:56','',''),(6291,'1','223','1',1,'Retail Sale Id 6649',998.20,0.00,0.00,1.61,67.62,'2022-05-04 18:07:01','',''),(6292,'1','223','1',1,'Retail Sale Id 6649',998.20,0.00,0.00,1.61,67.62,'2022-05-04 18:07:01','',''),(6293,'1','223','1',1,'Retail Sale Id 6650',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 18:08:04','',''),(6294,'1','223','1',1,'Retail Sale Id 6651',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 18:20:19','',''),(6295,'1','223','1',1,'Retail Sale Id 6652',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 18:21:17','',''),(6296,'1','223','1',1,'Retail Sale Id 6653',2002.60,0.00,0.00,3.23,135.66,'2022-05-04 18:22:21','',''),(6297,'1','223','1',1,'Retail Sale Id 6654',1252.40,0.00,0.00,2.02,84.84,'2022-05-04 18:24:06','',''),(6298,'1','223','1',1,'Retail Sale Id 6655',1860.00,0.00,0.00,3.00,126.00,'2022-05-04 18:26:35','',''),(6299,'1','223','1',1,'Retail Sale Id 6656',1240.00,0.00,0.00,2.00,84.00,'2022-05-04 18:27:11','',''),(6300,'1','223','1',1,'Retail Sale Id 6657',620.00,0.00,0.00,1.00,42.00,'2022-05-04 18:28:01','',''),(6301,'1','223','1',1,'Retail Sale Id 6658',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 07:04:37','',''),(6302,'1','223','1',1,'Retail Sale Id 6659',3100.00,0.00,0.00,5.00,210.00,'2022-05-05 07:37:36','',''),(6303,'1','223','1',1,'Retail Sale Id 6660',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 07:43:54','',''),(6304,'1','223','1',1,'Retail Sale Id 6662',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 07:44:44','',''),(6305,'1','223','1',1,'Retail Sale Id 6663',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 07:48:39','',''),(6306,'1','223','1',1,'Retail Sale Id 6664',2480.00,0.00,0.00,4.00,168.00,'2022-05-05 07:49:29','',''),(6307,'1','223','1',1,'Retail Sale Id 6674',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 08:00:42','',''),(6308,'1','223','1',1,'Retail Sale Id 6681',2480.00,0.00,0.00,4.00,168.00,'2022-05-05 08:07:48','',''),(6309,'1','223','1',1,'Retail Sale Id 6682',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 08:08:45','',''),(6310,'1','223','1',1,'Retail Sale Id 6683',3100.00,0.00,0.00,5.00,210.00,'2022-05-05 08:11:22','',''),(6311,'1','223','1',1,'Retail Sale Id 6684',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 08:12:06','',''),(6312,'1','223','1',1,'Retail Sale Id 6685',3100.00,0.00,0.00,5.00,210.00,'2022-05-05 08:16:19','',''),(6313,'1','223','1',1,'Retail Sale Id 6686',2480.00,0.00,0.00,4.00,168.00,'2022-05-05 08:24:19','',''),(6314,'1','223','1',1,'Retail Sale Id 6687',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 08:25:23','',''),(6315,'1','223','1',1,'Retail Sale Id 6688',1798.00,0.00,0.00,2.90,121.80,'2022-05-05 08:30:31','',''),(6316,'1','223','1',1,'Retail Sale Id 6690',1252.40,0.00,0.00,2.02,84.84,'2022-05-05 08:35:03','',''),(6317,'1','223','1',1,'Retail Sale Id 6691',1401.20,0.00,0.00,2.26,94.92,'2022-05-05 08:37:59','',''),(6318,'1','223','1',1,'Retail Sale Id 6692',1401.20,0.00,0.00,2.26,94.92,'2022-05-05 08:39:13','',''),(6319,'1','223','1',1,'Retail Sale Id 6693',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 08:44:00','',''),(6320,'1','223','1',1,'Retail Sale Id 6694',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 08:44:59','',''),(6321,'1','223','1',1,'Retail Sale Id 6695',1202.80,0.00,0.00,1.94,81.48,'2022-05-05 09:00:10','',''),(6322,'1','223','1',1,'Retail Sale Id 6696',1798.00,0.00,0.00,2.90,121.80,'2022-05-05 09:01:05','',''),(6323,'1','223','1',1,'Retail Sale Id 6697',103250.00,0.00,0.00,175.00,2100.00,'2022-05-05 09:10:50','',''),(6324,'1','223','1',1,'Retail Sale Id 6698',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 09:11:41','',''),(6325,'1','223','1',1,'Retail Sale Id 6699',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 09:21:23','',''),(6326,'1','223','1',1,'Retail Sale Id 6700',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 09:22:07','',''),(6327,'1','223','1',1,'Retail Sale Id 6701',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 09:26:32','',''),(6328,'1','223','1',1,'Retail Sale Id 6702',6200.00,0.00,0.00,10.00,420.00,'2022-05-05 09:37:24','',''),(6329,'1','223','1',1,'Retail Sale Id 6703',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 09:43:15','',''),(6330,'1','223','1',1,'Retail Sale Id 6704',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 09:44:08','',''),(6331,'1','223','1',1,'Retail Sale Id 6705',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 09:44:50','',''),(6332,'1','223','1',1,'Retail Sale Id 6706',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 09:50:41','',''),(6333,'1','223','1',1,'Retail Sale Id 6707',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 09:54:19','',''),(6334,'1','223','1',1,'Retail Sale Id 6708',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 09:55:01','',''),(6335,'1','223','1',1,'Retail Sale Id 6709',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 10:01:13','',''),(6336,'1','223','1',1,'Retail Sale Id 6712',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 10:06:14','',''),(6337,'1','223','1',1,'Retail Sale Id 6713',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 10:16:37','',''),(6338,'1','223','1',1,'Retail Sale Id 6714',2480.00,0.00,0.00,4.00,168.00,'2022-05-05 10:17:28','',''),(6339,'1','223','1',1,'Retail Sale Id 6715',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 10:32:30','',''),(6340,'1','223','1',1,'Retail Sale Id 6716',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 10:33:30','',''),(6341,'1','223','1',1,'Retail Sale Id 6717',1202.80,0.00,0.00,1.94,81.48,'2022-05-05 10:35:48','',''),(6342,'1','223','1',1,'Retail Sale Id 6718',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 10:40:26','',''),(6343,'1','223','1',1,'Retail Sale Id 6719',3100.00,0.00,0.00,5.00,210.00,'2022-05-05 10:53:31','',''),(6344,'1','223','1',1,'Retail Sale Id 6720',2002.60,0.00,0.00,3.23,135.66,'2022-05-05 10:55:33','',''),(6345,'1','223','1',1,'Retail Sale Id 6721',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 11:05:33','',''),(6346,'1','223','1',1,'Retail Sale Id 6722',2002.60,0.00,0.00,3.23,135.66,'2022-05-05 11:06:37','',''),(6347,'1','223','1',1,'Retail Sale Id 6723',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 11:12:04','',''),(6348,'1','223','1',1,'Retail Sale Id 6724',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 11:12:50','',''),(6349,'1','223','1',1,'Retail Sale Id 6725',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 11:20:31','',''),(6350,'1','223','1',1,'Retail Sale Id 6726',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 11:21:38','',''),(6351,'1','223','1',1,'Retail Sale Id 6727',2101.80,0.00,0.00,3.39,142.38,'2022-05-05 11:25:21','',''),(6352,'1','223','1',1,'Retail Sale Id 6730',799.80,0.00,0.00,1.29,54.18,'2022-05-05 11:26:00','',''),(6353,'1','223','1',1,'Retail Sale Id 6731',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 11:26:36','',''),(6354,'1','223','1',1,'Retail Sale Id 6732',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 11:27:16','',''),(6355,'1','223','1',1,'Retail Sale Id 6733',2480.00,0.00,0.00,4.00,168.00,'2022-05-05 11:44:44','',''),(6356,'1','223','1',1,'Retail Sale Id 6734',502.20,0.00,0.00,0.81,34.02,'2022-05-05 11:52:54','',''),(6357,'1','223','1',1,'Retail Sale Id 6735',601.40,0.00,0.00,0.97,40.74,'2022-05-05 11:54:38','',''),(6358,'1','223','1',1,'Retail Sale Id 6736',7452.40,0.00,0.00,12.02,504.84,'2022-05-05 12:07:18','',''),(6359,'1','223','1',1,'Retail Sale Id 6737',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 12:09:53','',''),(6360,'1','223','1',1,'Retail Sale Id 6738',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 12:21:10','',''),(6361,'1','223','1',1,'Retail Sale Id 6739',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 12:27:31','',''),(6362,'1','223','1',1,'Retail Sale Id 6740',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 12:37:27','',''),(6363,'1','223','1',1,'Retail Sale Id 6741',1401.20,0.00,0.00,2.26,94.92,'2022-05-05 12:41:49','',''),(6364,'1','223','1',1,'Retail Sale Id 6742',1252.40,0.00,0.00,2.02,84.84,'2022-05-05 12:43:29','',''),(6365,'1','223','1',1,'Retail Sale Id 6743',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 12:55:54','',''),(6366,'1','223','1',1,'Retail Sale Id 6744',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 12:56:39','',''),(6367,'1','223','1',1,'Retail Sale Id 6745',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 13:04:47','',''),(6368,'1','223','1',1,'Retail Sale Id 6746',620.00,0.00,0.00,1.00,42.00,'2022-05-05 13:13:45','',''),(6369,'1','223','1',1,'Retail Sale Id 6747',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 13:24:40','',''),(6370,'1','223','1',1,'Retail Sale Id 6748',2480.00,0.00,0.00,4.00,168.00,'2022-05-05 13:27:13','',''),(6371,'1','223','1',1,'Retail Sale Id 6749',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 13:28:38','',''),(6372,'1','223','1',1,'Retail Sale Id 6750',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 13:33:24','',''),(6373,'1','223','1',1,'Retail Sale Id 6751',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 13:34:52','',''),(6374,'1','223','1',1,'Retail Sale Id 6752',620.00,0.00,0.00,1.00,42.00,'2022-05-05 13:40:22','',''),(6375,'1','223','1',1,'Retail Sale Id 6753',998.20,0.00,0.00,1.61,67.62,'2022-05-05 13:41:23','',''),(6376,'1','223','1',1,'Retail Sale Id 6754',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 14:10:57','',''),(6377,'1','223','1',1,'Retail Sale Id 6755',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 14:15:35','',''),(6378,'1','223','1',1,'Retail Sale Id 6756',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 14:17:11','',''),(6379,'1','223','1',1,'Retail Sale Id 6757',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 14:21:41','',''),(6380,'1','223','1',1,'Retail Sale Id 6758',1698.80,0.00,0.00,2.74,115.08,'2022-05-05 14:27:24','',''),(6381,'1','223','1',1,'Retail Sale Id 6759',64900.00,0.00,0.00,110.00,1320.00,'2022-05-05 14:46:36','',''),(6382,'1','223','1',1,'Retail Sale Id 6760',2480.00,0.00,0.00,4.00,168.00,'2022-05-05 15:00:57','',''),(6383,'1','223','1',1,'Retail Sale Id 6761',2002.60,0.00,0.00,3.23,135.66,'2022-05-05 15:11:53','',''),(6384,'1','223','1',1,'Retail Sale Id 6762',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 15:14:43','',''),(6385,'1','223','1',1,'Retail Sale Id 6763',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 15:23:20','',''),(6386,'1','223','1',1,'Retail Sale Id 6764',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 15:27:04','',''),(6387,'1','223','1',1,'Retail Sale Id 6765',2480.00,0.00,0.00,4.00,168.00,'2022-05-05 15:27:49','',''),(6388,'1','223','1',1,'Retail Sale Id 6767',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 15:33:02','',''),(6389,'1','223','1',1,'Retail Sale Id 6768',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 15:34:37','',''),(6390,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,2890000.00,5000.00,0.00,0.00,'2022-05-05 15:57:23','',''),(6391,'1','223',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,5000.00,0.00,'2022-05-05 15:58:35','',''),(6392,'1','223','1',1,'Received from bridging 12',0.00,0.00,5000.00,0.00,0.00,'2022-05-05 15:58:35','',''),(6393,'1','223','1',1,'Retail Sale Id 6769',29500.00,0.00,0.00,50.00,600.00,'2022-05-05 15:58:36','',''),(6394,'1','223','1',1,'Retail Sale Id 6770',2002.60,0.00,0.00,3.23,135.66,'2022-05-05 15:59:06','',''),(6395,'1','223','1',1,'Retail Sale Id 6771',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 16:01:09','',''),(6396,'1','223','1',1,'Retail Sale Id 6772',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 16:02:11','',''),(6397,'1','223','1',1,'Retail Sale Id 6773',1252.40,0.00,0.00,2.02,84.84,'2022-05-05 16:19:54','',''),(6398,'1','223','1',1,'Retail Sale Id 6774',1252.40,0.00,0.00,2.02,84.84,'2022-05-05 16:25:42','',''),(6399,'1','223','1',1,'Retail Sale Id 6775',3100.00,0.00,0.00,5.00,210.00,'2022-05-05 16:29:55','',''),(6400,'1','223','1',1,'Retail Sale Id 6776',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 16:31:13','',''),(6401,'1','223','1',1,'Retail Sale Id 6777',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 16:31:55','',''),(6402,'1','223','1',1,'Retail Sale Id 6778',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 16:41:48','',''),(6403,'1','223','1',1,'Retail Sale Id 6779',998.20,0.00,0.00,1.61,67.62,'2022-05-05 16:45:16','',''),(6404,'1','223','1',1,'Retail Sale Id 6780',3100.00,0.00,0.00,5.00,210.00,'2022-05-05 16:46:04','',''),(6405,'1','223','1',1,'Retail Sale Id 6781',620.00,0.00,0.00,1.00,42.00,'2022-05-05 16:48:21','',''),(6406,'1','223','1',1,'Retail Sale Id 6782',3100.00,0.00,0.00,5.00,210.00,'2022-05-05 16:49:27','',''),(6407,'1','223','1',1,'Retail Sale Id 6783',2002.60,0.00,0.00,3.23,135.66,'2022-05-05 16:52:52','',''),(6408,'1','223','1',1,'Retail Sale Id 6784',17700.00,0.00,0.00,30.00,360.00,'2022-05-05 16:57:55','',''),(6409,'1','223','1',1,'Retail Sale Id 6785',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 16:58:55','',''),(6410,'1','223','1',1,'Retail Sale Id 6786',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 17:02:26','',''),(6411,'1','223','1',1,'Retail Sale Id 6787',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 17:03:23','',''),(6412,'1','223','1',1,'Retail Sale Id 6788',1872.40,0.00,0.00,3.02,126.84,'2022-05-05 17:05:46','',''),(6413,'1','223','1',1,'Retail Sale Id 6788',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 17:05:46','',''),(6414,'1','223','1',1,'Retail Sale Id 6789',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 17:07:13','',''),(6415,'1','223','1',1,'Retail Sale Id 6790',651.00,0.00,0.00,1.05,44.10,'2022-05-05 17:08:24','',''),(6416,'1','223','1',1,'Retail Sale Id 6791',29500.00,0.00,0.00,50.00,600.00,'2022-05-05 17:09:54','',''),(6417,'1','223','1',1,'Retail Sale Id 6792',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 17:11:10','',''),(6418,'1','223','1',1,'Retail Sale Id 6793',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 17:11:51','',''),(6419,'1','223','1',1,'Retail Sale Id 6794',1897.20,0.00,0.00,3.06,128.52,'2022-05-05 17:13:36','',''),(6420,'1','223','1',1,'Retail Sale Id 6795',3751.00,0.00,0.00,6.05,254.10,'2022-05-05 17:16:44','',''),(6421,'1','223','1',1,'Retail Sale Id 6796',1897.20,0.00,0.00,3.06,128.52,'2022-05-05 17:22:11','',''),(6422,'1','223','1',1,'Retail Sale Id 6797',1897.20,0.00,0.00,3.06,128.52,'2022-05-05 17:23:13','',''),(6423,'1','223','1',1,'Retail Sale Id 6798',601.40,0.00,0.00,0.97,40.74,'2022-05-05 17:24:28','',''),(6424,'1','223','1',1,'Retail Sale Id 6799',7750.00,0.00,0.00,12.50,525.00,'2022-05-05 17:30:03','',''),(6425,'1','223','1',1,'Retail Sale Id 6800',1897.20,0.00,0.00,3.06,128.52,'2022-05-05 17:32:22','',''),(6426,'1','223','1',1,'Retail Sale Id 6801',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 17:34:15','',''),(6427,'1','223','1',1,'Retail Sale Id 6802',2498.60,0.00,0.00,4.03,169.26,'2022-05-05 17:35:10','',''),(6428,'1','223','1',1,'Retail Sale Id 6803',998.20,0.00,0.00,1.61,67.62,'2022-05-05 17:36:18','',''),(6429,'1','223','1',1,'Retail Sale Id 6804',651.00,0.00,0.00,1.05,44.10,'2022-05-05 17:38:19','',''),(6430,'1','223','1',1,'Retail Sale Id 6805',1202.80,0.00,0.00,1.94,81.48,'2022-05-05 17:39:47','',''),(6431,'1','223','1',1,'Retail Sale Id 6806',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 17:41:19','',''),(6432,'1','223','1',1,'Retail Sale Id 6807',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 17:42:39','',''),(6433,'1','223','1',1,'Retail Sale Id 6808',3100.00,0.00,0.00,5.00,210.00,'2022-05-05 17:46:14','',''),(6434,'1','223','1',1,'Retail Sale Id 6809',998.20,0.00,0.00,1.61,67.62,'2022-05-05 17:47:25','',''),(6435,'1','223','1',1,'Retail Sale Id 6810',2002.60,0.00,0.00,3.23,135.66,'2022-05-05 17:52:41','',''),(6436,'1','223','1',1,'Retail Sale Id 6811',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 17:53:41','',''),(6437,'1','223','1',1,'Retail Sale Id 6812',1847.60,0.00,0.00,2.98,125.16,'2022-05-05 17:59:16','',''),(6438,'1','223','1',1,'Retail Sale Id 6813',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 18:06:01','',''),(6439,'1','223','1',1,'Retail Sale Id 6814',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 18:15:35','',''),(6440,'1','223','1',1,'Retail Sale Id 6814',1240.00,0.00,0.00,2.00,84.00,'2022-05-05 18:15:35','',''),(6441,'1','223','1',1,'Retail Sale Id 6815',1500.40,0.00,0.00,2.42,101.64,'2022-05-05 18:17:28','',''),(6442,'1','223','1',1,'Retail Sale Id 6816',601.40,0.00,0.00,0.97,40.74,'2022-05-05 18:20:19','',''),(6443,'1','223','1',1,'Retail Sale Id 6817',1698.80,0.00,0.00,2.74,115.08,'2022-05-05 18:21:20','',''),(6444,'1','223','1',1,'Retail Sale Id 6818',2002.60,0.00,0.00,3.23,135.66,'2022-05-05 18:23:00','',''),(6445,'1','223','1',1,'Retail Sale Id 6819',2002.60,0.00,0.00,3.23,135.66,'2022-05-05 18:23:40','',''),(6446,'1','223','1',1,'Retail Sale Id 6820',998.20,0.00,0.00,1.61,67.62,'2022-05-05 18:24:22','',''),(6447,'1','223','1',1,'Retail Sale Id 6821',1798.00,0.00,0.00,2.90,121.80,'2022-05-05 18:25:43','',''),(6448,'1','223','1',1,'Retail Sale Id 6823',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 18:27:31','',''),(6449,'1','223','1',1,'Retail Sale Id 6824',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 18:29:03','',''),(6450,'1','223','1',1,'Retail Sale Id 6825',997.10,0.00,0.00,1.69,20.28,'2022-05-05 18:30:32','',''),(6451,'1','223','1',1,'Retail Sale Id 6826',3720.00,0.00,0.00,6.00,252.00,'2022-05-05 18:36:24','',''),(6452,'1','223','1',1,'Retail Sale Id 6827',651.00,0.00,0.00,1.05,44.10,'2022-05-05 18:37:20','',''),(6453,'1','223','1',1,'Retail Sale Id 6828',2498.60,0.00,0.00,4.03,169.26,'2022-05-05 18:38:15','',''),(6454,'1','223','1',1,'Retail Sale Id 6829',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 18:42:09','',''),(6455,'1','223','1',1,'Retail Sale Id 6830',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 18:42:52','',''),(6456,'1','223','1',1,'Retail Sale Id 6831',3100.00,0.00,0.00,5.00,210.00,'2022-05-05 18:43:27','',''),(6457,'1','223','1',1,'Retail Sale Id 6832',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 18:44:26','',''),(6458,'1','223','1',1,'Retail Sale Id 6833',651.00,0.00,0.00,1.05,44.10,'2022-05-05 18:47:36','',''),(6459,'1','223','1',1,'Retail Sale Id 6834',601.40,0.00,0.00,0.97,40.74,'2022-05-05 18:48:12','',''),(6460,'1','223','1',1,'Retail Sale Id 6835',1860.00,0.00,0.00,3.00,126.00,'2022-05-05 18:48:45','',''),(6461,'1','223','1',1,'Return of Retail Sale Id 6734',0.00,502.20,0.81,0.00,-34.02,'2022-05-05 19:35:35','',''),(6462,'1','223','1',1,'Retail Sale Id 6836',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 06:51:33','',''),(6463,'1','223','1',1,'Retail Sale Id 6837',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 06:52:03','',''),(6464,'1','223','1',1,'Retail Sale Id 6838',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 06:58:27','',''),(6465,'1','223','1',1,'Retail Sale Id 6839',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 07:04:28','',''),(6466,'1','223','1',1,'Retail Sale Id 6840',7750.00,0.00,0.00,12.50,525.00,'2022-05-06 07:09:58','',''),(6467,'1','223','1',1,'Retail Sale Id 6841',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 07:24:42','',''),(6468,'1','223','1',1,'Retail Sale Id 6842',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 07:47:02','',''),(6469,'1','223','1',1,'Retail Sale Id 6843',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 08:04:47','',''),(6470,'1','223','1',1,'Retail Sale Id 6844',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 08:05:44','',''),(6471,'1','223','1',1,'Retail Sale Id 6845',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 08:06:54','',''),(6472,'1','223','1',1,'Retail Sale Id 6846',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 08:09:15','',''),(6473,'1','223','1',1,'Retail Sale Id 6847',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 08:11:22','',''),(6474,'1','223','1',1,'Retail Sale Id 6848',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 08:16:03','',''),(6475,'1','223','1',1,'Retail Sale Id 6849',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 08:21:35','',''),(6476,'1','223','1',1,'Retail Sale Id 6850',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 08:30:18','',''),(6477,'1','223','1',1,'Retail Sale Id 6851',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 08:32:29','',''),(6478,'1','223','1',1,'Retail Sale Id 6852',1798.00,0.00,0.00,2.90,121.80,'2022-05-06 08:38:46','',''),(6479,'1','223','1',1,'Retail Sale Id 6853',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 08:40:04','',''),(6480,'1','223','1',1,'Retail Sale Id 6854',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 08:41:37','',''),(6481,'1','223','1',1,'Retail Sale Id 6855',2480.00,0.00,0.00,4.00,168.00,'2022-05-06 08:52:19','',''),(6482,'1','223','1',1,'Retail Sale Id 6856',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 08:55:26','',''),(6483,'1','223','1',1,'Retail Sale Id 6857',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 09:00:51','',''),(6484,'1','223','1',1,'Retail Sale Id 6858',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 09:03:21','',''),(6485,'1','223','1',1,'Retail Sale Id 6859',1798.00,0.00,0.00,2.90,121.80,'2022-05-06 09:08:30','',''),(6486,'1','223','1',1,'Retail Sale Id 6860',4960.00,0.00,0.00,8.00,336.00,'2022-05-06 09:13:49','',''),(6487,'1','223','1',1,'Retail Sale Id 6861',1698.80,0.00,0.00,2.74,115.08,'2022-05-06 09:27:59','',''),(6488,'1','223','1',1,'Retail Sale Id 6862',1500.40,0.00,0.00,2.42,101.64,'2022-05-06 09:28:51','',''),(6489,'1','223','1',1,'Retail Sale Id 6863',7750.00,0.00,0.00,12.50,525.00,'2022-05-06 09:35:07','',''),(6490,'1','223','1',1,'Retail Sale Id 6864',1500.40,0.00,0.00,2.42,101.64,'2022-05-06 09:36:02','',''),(6491,'1','223','1',1,'Retail Sale Id 6865',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 09:36:46','',''),(6492,'1','223',NULL,1,'Purchased from A A RANO NIGERIA LTD',0.00,1075080.00,1860.00,0.00,0.00,'2022-05-06 09:38:23','',''),(6493,'1','223',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,1860.00,0.00,'2022-05-06 09:40:56','',''),(6494,'1','223','1',1,'Received from bridging 13',0.00,0.00,1860.00,0.00,0.00,'2022-05-06 09:40:56','',''),(6495,'1','223','1',1,'Retail Sale Id 6866',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 09:42:54','',''),(6496,'1','223','1',1,'Retail Sale Id 6867',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 09:46:29','',''),(6497,'1','223','1',1,'Retail Sale Id 6868',6851.00,0.00,0.00,11.05,464.10,'2022-05-06 09:47:53','',''),(6498,'1','223','1',1,'Retail Sale Id 6869',1202.80,0.00,0.00,1.94,81.48,'2022-05-06 09:49:17','',''),(6499,'1','223','1',1,'Retail Sale Id 6870',12400.00,0.00,0.00,20.00,840.00,'2022-05-06 09:50:31','',''),(6500,'1','223','1',1,'Retail Sale Id 6871',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 09:57:17','',''),(6501,'1','223','1',1,'Retail Sale Id 6872',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 10:02:27','',''),(6502,'1','223','1',1,'Retail Sale Id 6873',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 10:04:03','',''),(6503,'1','223','1',1,'Retail Sale Id 6874',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 10:12:23','',''),(6504,'1','223','1',1,'Retail Sale Id 6875',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 10:17:36','',''),(6505,'1','223','1',1,'Retail Sale Id 6876',620.00,0.00,0.00,1.00,42.00,'2022-05-06 10:25:32','',''),(6506,'1','223','1',1,'Retail Sale Id 6877',998.20,0.00,0.00,1.61,67.62,'2022-05-06 10:26:09','',''),(6507,'1','223','1',1,'Retail Sale Id 6878',3751.00,0.00,0.00,6.05,254.10,'2022-05-06 10:39:06','',''),(6508,'1','223','1',1,'Retail Sale Id 6879',35400.00,0.00,0.00,60.00,720.00,'2022-05-06 10:44:04','',''),(6509,'1','223','1',1,'Retail Sale Id 6880',651.00,0.00,0.00,1.05,44.10,'2022-05-06 10:48:10','',''),(6510,'1','223','1',1,'Retail Sale Id 6881',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 10:54:06','',''),(6511,'1','223','1',1,'Retail Sale Id 6882',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 10:57:41','',''),(6512,'1','223','1',1,'Retail Sale Id 6883',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 11:03:09','',''),(6513,'1','223','1',1,'Retail Sale Id 6884',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 11:06:32','',''),(6514,'1','223','1',1,'Retail Sale Id 6885',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 11:17:08','',''),(6515,'1','223','1',1,'Retail Sale Id 6886',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 11:19:45','',''),(6516,'1','223','1',1,'Retail Sale Id 6888',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 11:21:12','',''),(6517,'1','223','1',1,'Retail Sale Id 6891',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 11:27:14','',''),(6518,'1','223','1',1,'Retail Sale Id 6892',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 11:38:25','',''),(6519,'1','223','1',1,'Retail Sale Id 6893',998.20,0.00,0.00,1.61,67.62,'2022-05-06 11:41:10','',''),(6520,'1','223','1',1,'Retail Sale Id 6894',1500.40,0.00,0.00,2.42,101.64,'2022-05-06 11:48:06','',''),(6521,'1','223','1',1,'Retail Sale Id 6895',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 11:52:39','',''),(6522,'1','223','1',1,'Retail Sale Id 6896',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 12:04:46','',''),(6523,'1','223','1',1,'Retail Sale Id 6897',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 12:07:23','',''),(6524,'1','223','1',1,'Retail Sale Id 6898',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 12:09:05','',''),(6525,'1','223','1',1,'Retail Sale Id 6899',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 12:11:54','',''),(6526,'1','223','1',1,'Retail Sale Id 6900',620.00,0.00,0.00,1.00,42.00,'2022-05-06 12:13:11','',''),(6527,'1','223','1',1,'Retail Sale Id 6901',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 12:14:19','',''),(6528,'1','223','1',1,'Retail Sale Id 6902',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 12:18:19','',''),(6529,'1','223','1',1,'Retail Sale Id 6903',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 12:20:19','',''),(6530,'1','223','1',1,'Retail Sale Id 6904',651.00,0.00,0.00,1.05,44.10,'2022-05-06 12:21:27','',''),(6531,'1','223','1',1,'Retail Sale Id 6905',2498.60,0.00,0.00,4.03,169.26,'2022-05-06 12:22:09','',''),(6532,'1','223','1',1,'Retail Sale Id 6906',1500.40,0.00,0.00,2.42,101.64,'2022-05-06 12:32:24','',''),(6533,'1','223','1',1,'Retail Sale Id 6907',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 12:34:42','',''),(6534,'1','223','1',1,'Retail Sale Id 6908',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 12:37:39','',''),(6535,'1','223','1',1,'Retail Sale Id 6909',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 12:48:56','',''),(6536,'1','223','1',1,'Retail Sale Id 6910',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 12:57:33','',''),(6537,'1','223','1',1,'Retail Sale Id 6911',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 13:03:27','',''),(6538,'1','223','1',1,'Retail Sale Id 6912',2498.60,0.00,0.00,4.03,169.26,'2022-05-06 13:09:59','',''),(6539,'1','223','1',1,'Retail Sale Id 6913',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 13:17:11','',''),(6540,'1','223','1',1,'Retail Sale Id 6914',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 13:18:02','',''),(6541,'1','223','1',1,'Retail Sale Id 6915',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 13:18:49','',''),(6542,'1','223','1',1,'Retail Sale Id 6916',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 13:22:33','',''),(6543,'1','223','1',1,'Retail Sale Id 6917',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 13:27:33','',''),(6544,'1','223','1',1,'Retail Sale Id 6918',1798.00,0.00,0.00,2.90,121.80,'2022-05-06 13:36:23','',''),(6545,'1','223','1',1,'Retail Sale Id 6919',998.20,0.00,0.00,1.61,67.62,'2022-05-06 13:38:14','',''),(6546,'1','223','1',1,'Retail Sale Id 6920',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 13:39:46','',''),(6547,'1','223','1',1,'Retail Sale Id 6921',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 13:42:28','',''),(6548,'1','223','1',1,'Retail Sale Id 6922',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 13:48:07','',''),(6549,'1','223','1',1,'Retail Sale Id 6923',3751.00,0.00,0.00,6.05,254.10,'2022-05-06 13:56:07','',''),(6550,'1','223','1',1,'Retail Sale Id 6924',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 13:56:48','',''),(6551,'1','223','1',1,'Retail Sale Id 6925',2002.60,0.00,0.00,3.23,135.66,'2022-05-06 13:57:58','',''),(6552,'1','223','1',1,'Retail Sale Id 6926',1401.20,0.00,0.00,2.26,94.92,'2022-05-06 13:59:30','',''),(6553,'1','223','1',1,'Retail Sale Id 6927',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 14:05:52','',''),(6554,'1','223','1',1,'Retail Sale Id 6928',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 14:06:35','',''),(6555,'1','223','1',1,'Retail Sale Id 6929',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 14:09:04','',''),(6556,'1','223','1',1,'Retail Sale Id 6930',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 14:15:57','',''),(6557,'1','223','1',1,'Retail Sale Id 6931',7750.00,0.00,0.00,12.50,525.00,'2022-05-06 14:22:10','',''),(6558,'1','223','1',1,'Retail Sale Id 6932',700.60,0.00,0.00,1.13,47.46,'2022-05-06 14:31:39','',''),(6559,'1','223','1',1,'Retail Sale Id 6933',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 14:32:23','',''),(6560,'1','223','1',1,'Retail Sale Id 6934',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 14:37:56','',''),(6561,'1','223','1',1,'Retail Sale Id 6935',2480.00,0.00,0.00,4.00,168.00,'2022-05-06 14:39:11','',''),(6562,'1','223','1',1,'Retail Sale Id 6936',1599.60,0.00,0.00,2.58,108.36,'2022-05-06 14:47:03','',''),(6563,'1','223','1',1,'Retail Sale Id 6937',1202.80,0.00,0.00,1.94,81.48,'2022-05-06 14:47:49','',''),(6564,'1','223','1',1,'Retail Sale Id 6938',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 14:48:29','',''),(6565,'1','223','1',1,'Retail Sale Id 6939',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 14:50:16','',''),(6566,'1','223','1',1,'Retail Sale Id 6940',7750.00,0.00,0.00,12.50,525.00,'2022-05-06 14:53:31','',''),(6567,'1','223','1',1,'Retail Sale Id 6941',4960.00,0.00,0.00,8.00,336.00,'2022-05-06 14:57:14','',''),(6568,'1','223','1',1,'Retail Sale Id 6942',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 14:58:43','',''),(6569,'1','223','1',1,'Retail Sale Id 6943',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 15:09:00','',''),(6570,'1','223','1',1,'Retail Sale Id 6944',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 15:11:15','',''),(6571,'1','223','1',1,'Retail Sale Id 6945',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 15:11:57','',''),(6572,'1','223','1',1,'Retail Sale Id 6946',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 15:19:27','',''),(6573,'1','223','1',1,'Retail Sale Id 6947',2002.60,0.00,0.00,3.23,135.66,'2022-05-06 15:35:55','',''),(6574,'1','223','1',1,'Retail Sale Id 6948',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 15:42:07','',''),(6575,'1','223','1',1,'Retail Sale Id 6949',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 15:44:21','',''),(6576,'1','223','1',1,'Retail Sale Id 6950',2498.60,0.00,0.00,4.03,169.26,'2022-05-06 15:46:07','',''),(6577,'1','223','1',1,'Retail Sale Id 6951',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 15:46:37','',''),(6578,'1','223','1',1,'Retail Sale Id 6952',2480.00,0.00,0.00,4.00,168.00,'2022-05-06 15:50:57','',''),(6579,'1','223','1',1,'Retail Sale Id 6953',799.80,0.00,0.00,1.29,54.18,'2022-05-06 15:57:19','',''),(6580,'1','223','1',1,'Retail Sale Id 6954',1240.00,0.00,0.00,2.00,84.00,'2022-05-06 15:57:55','',''),(6581,'1','223','1',1,'Retail Sale Id 6955',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 15:58:35','',''),(6582,'1','223','1',1,'Retail Sale Id 6956',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 15:59:49','',''),(6583,'1','223','1',1,'Retail Sale Id 6957',502.20,0.00,0.00,0.81,34.02,'2022-05-06 16:05:20','',''),(6584,'1','223','1',1,'Retail Sale Id 6958',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 16:06:11','',''),(6585,'1','223','1',1,'Retail Sale Id 6959',651.00,0.00,0.00,1.05,44.10,'2022-05-06 16:08:10','',''),(6586,'1','223','1',1,'Retail Sale Id 6960',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 16:08:40','',''),(6587,'1','223','1',1,'Retail Sale Id 6961',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 16:09:29','',''),(6588,'1','223','1',1,'Retail Sale Id 6962',2480.00,0.00,0.00,4.00,168.00,'2022-05-06 16:11:30','',''),(6589,'1','223','1',1,'Retail Sale Id 6963',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 16:12:05','',''),(6590,'1','223','1',1,'Retail Sale Id 6964',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 16:12:50','',''),(6591,'1','223','1',1,'Retail Sale Id 6965',998.20,0.00,0.00,1.61,67.62,'2022-05-06 16:26:26','',''),(6592,'1','223','1',1,'Retail Sale Id 6966',17700.00,0.00,0.00,30.00,360.00,'2022-05-06 16:28:19','',''),(6593,'1','223','1',1,'Retail Sale Id 6967',998.20,0.00,0.00,1.61,67.62,'2022-05-06 16:30:04','',''),(6594,'1','223','1',1,'Retail Sale Id 6968',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 16:33:12','',''),(6595,'1','223','1',1,'Retail Sale Id 6969',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 16:38:46','',''),(6596,'1','223','1',1,'Retail Sale Id 6970',1500.40,0.00,0.00,2.42,101.64,'2022-05-06 16:41:41','',''),(6597,'1','223','1',1,'Retail Sale Id 6971',651.00,0.00,0.00,1.05,44.10,'2022-05-06 16:43:58','',''),(6598,'1','223','1',1,'Retail Sale Id 6972',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 16:45:49','',''),(6599,'1','223','1',1,'Retail Sale Id 6973',998.20,0.00,0.00,1.61,67.62,'2022-05-06 16:49:07','',''),(6600,'1','223','1',1,'Retail Sale Id 6974',1847.60,0.00,0.00,2.98,125.16,'2022-05-06 16:50:23','',''),(6601,'1','223','1',1,'Retail Sale Id 6975',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 16:51:52','',''),(6602,'1','223','1',1,'Retail Sale Id 6976',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 16:53:25','',''),(6603,'1','223','1',1,'Retail Sale Id 6977',3751.00,0.00,0.00,6.05,254.10,'2022-05-06 16:55:09','',''),(6604,'1','223','1',1,'Retail Sale Id 6978',2480.00,0.00,0.00,4.00,168.00,'2022-05-06 17:04:46','',''),(6605,'1','223','1',1,'Retail Sale Id 6979',651.00,0.00,0.00,1.05,44.10,'2022-05-06 17:06:07','',''),(6606,'1','223','1',1,'Retail Sale Id 6980',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 17:10:33','',''),(6607,'1','223','1',1,'Retail Sale Id 6981',1897.20,0.00,0.00,3.06,128.52,'2022-05-06 17:13:29','',''),(6608,'1','223','1',1,'Retail Sale Id 6982',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 17:15:25','',''),(6609,'1','223','1',1,'Retail Sale Id 6983',620.00,0.00,0.00,1.00,42.00,'2022-05-06 17:19:55','',''),(6610,'1','223','1',1,'Retail Sale Id 6984',2201.00,0.00,0.00,3.55,149.10,'2022-05-06 17:21:42','',''),(6611,'1','223','1',1,'Retail Sale Id 6985',998.20,0.00,0.00,1.61,67.62,'2022-05-06 17:22:38','',''),(6612,'1','223','1',1,'Retail Sale Id 6986',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 17:25:22','',''),(6613,'1','223','1',1,'Retail Sale Id 6987',1252.40,0.00,0.00,2.02,84.84,'2022-05-06 17:27:29','',''),(6614,'1','223','1',1,'Retail Sale Id 6988',1302.00,0.00,0.00,2.10,88.20,'2022-05-06 17:28:57','',''),(6615,'1','223','1',1,'Retail Sale Id 6989',7750.00,0.00,0.00,12.50,525.00,'2022-05-06 17:30:09','',''),(6616,'1','223','1',1,'Retail Sale Id 6990',3100.00,0.00,0.00,5.00,210.00,'2022-05-06 17:35:38','',''),(6617,'1','223','1',1,'Retail Sale Id 6991',1798.00,0.00,0.00,2.90,121.80,'2022-05-06 17:37:47','',''),(6618,'1','223','1',1,'Retail Sale Id 6992',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 17:40:58','',''),(6619,'1','223','1',1,'Retail Sale Id 6993',1798.00,0.00,0.00,2.90,121.80,'2022-05-06 17:45:18','',''),(6620,'1','223','1',1,'Retail Sale Id 6994',2498.60,0.00,0.00,4.03,169.26,'2022-05-06 17:46:17','',''),(6621,'1','223','1',1,'Retail Sale Id 6995',3751.00,0.00,0.00,6.05,254.10,'2022-05-06 17:57:37','',''),(6622,'1','223','1',1,'Retail Sale Id 6996',1860.00,0.00,0.00,3.00,126.00,'2022-05-06 17:58:46','',''),(6623,'1','223','1',1,'Retail Sale Id 6997',1798.00,0.00,0.00,2.90,121.80,'2022-05-06 18:00:05','',''),(6624,'1','223','1',1,'Retail Sale Id 6998',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 18:03:14','',''),(6625,'1','223','1',1,'Retail Sale Id 6999',700.60,0.00,0.00,1.13,47.46,'2022-05-06 18:04:53','',''),(6626,'1','223','1',1,'Retail Sale Id 7000',6119.40,0.00,0.00,9.87,414.54,'2022-05-06 18:11:31','',''),(6627,'1','223','1',1,'Retail Sale Id 7001',3899.80,0.00,0.00,6.29,264.18,'2022-05-06 18:12:08','',''),(6628,'1','223','1',1,'Retail Sale Id 7002',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 18:13:35','',''),(6629,'1','223','1',1,'Retail Sale Id 7003',2002.60,0.00,0.00,3.23,135.66,'2022-05-06 18:14:18','',''),(6630,'1','223','1',1,'Retail Sale Id 7004',1599.60,0.00,0.00,2.58,108.36,'2022-05-06 18:31:55','',''),(6631,'1','223','1',1,'Retail Sale Id 7005',5598.60,0.00,0.00,9.03,379.26,'2022-05-06 18:32:49','',''),(6632,'1','223','1',1,'Retail Sale Id 7006',3720.00,0.00,0.00,6.00,252.00,'2022-05-06 18:33:26','',''),(6633,'1','223','1',1,'Retail Sale Id 7007',5580.00,0.00,0.00,9.00,378.00,'2022-05-06 18:35:40','',''),(6634,'1','223','1',1,'Retail Sale Id 7008',7750.00,0.00,0.00,12.50,525.00,'2022-05-06 19:02:35','',''),(6635,'1','223','1',1,'Retail Sale Id 7009',4972.40,0.00,0.00,8.02,336.84,'2022-05-06 19:08:02','',''),(6636,'1','223','1',1,'Retail Sale Id 7011',998.20,0.00,0.00,1.61,67.62,'2022-05-07 07:07:40','',''),(6637,'1','223','1',1,'Retail Sale Id 7012',3100.00,0.00,0.00,5.00,210.00,'2022-05-07 07:12:22','',''),(6638,'1','223','1',1,'Retail Sale Id 7013',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 07:15:20','',''),(6639,'1','223','1',1,'Retail Sale Id 7014',1872.40,0.00,0.00,3.02,126.84,'2022-05-07 07:16:51','',''),(6640,'1','223','1',1,'Retail Sale Id 7015',2002.60,0.00,0.00,3.23,135.66,'2022-05-07 07:22:12','',''),(6641,'1','223','1',1,'Retail Sale Id 7016',3100.00,0.00,0.00,5.00,210.00,'2022-05-07 07:37:27','',''),(6642,'1','223','1',1,'Retail Sale Id 7017',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 07:51:46','',''),(6643,'1','223','1',1,'Retail Sale Id 7018',2002.60,0.00,0.00,3.23,135.66,'2022-05-07 07:53:23','',''),(6644,'1','223','1',1,'Retail Sale Id 7019',1599.60,0.00,0.00,2.58,108.36,'2022-05-07 07:59:31','',''),(6645,'1','223','1',1,'Retail Sale Id 7020',6200.00,0.00,0.00,10.00,420.00,'2022-05-07 08:01:52','',''),(6646,'1','223','1',1,'Retail Sale Id 7021',6200.00,0.00,0.00,10.00,420.00,'2022-05-07 08:02:49','',''),(6647,'1','223','1',1,'Retail Sale Id 7022',1847.60,0.00,0.00,2.98,125.16,'2022-05-07 08:10:06','',''),(6648,'1','223','1',1,'Retail Sale Id 7024',59000.00,0.00,0.00,100.00,1200.00,'2022-05-07 08:15:15','',''),(6649,'1','223','1',1,'Retail Sale Id 7025',1252.40,0.00,0.00,2.02,84.84,'2022-05-07 08:17:54','',''),(6650,'1','223','1',1,'Retail Sale Id 7026',1252.40,0.00,0.00,2.02,84.84,'2022-05-07 08:25:18','',''),(6651,'1','223','1',1,'Retail Sale Id 7027',1252.40,0.00,0.00,2.02,84.84,'2022-05-07 08:26:12','',''),(6652,'1','223','1',1,'Retail Sale Id 7028',2498.60,0.00,0.00,4.03,169.26,'2022-05-07 08:27:53','',''),(6653,'1','223','1',1,'Retail Sale Id 7029',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 08:34:12','',''),(6654,'1','223','1',1,'Retail Sale Id 7030',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 08:35:13','',''),(6655,'1','223','1',1,'Retail Sale Id 7031',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 08:36:04','',''),(6656,'1','223','1',1,'Retail Sale Id 7032',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 08:39:39','',''),(6657,'1','223','1',1,'Retail Sale Id 7033',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 08:40:44','',''),(6658,'1','223','1',1,'Retail Sale Id 7034',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 08:45:47','',''),(6659,'1','223','1',1,'Retail Sale Id 7035',2498.60,0.00,0.00,4.03,169.26,'2022-05-07 08:46:46','',''),(6660,'1','223','1',1,'Retail Sale Id 7036',1302.00,0.00,0.00,2.10,88.20,'2022-05-07 08:47:15','',''),(6661,'1','223','1',1,'Retail Sale Id 7037',1897.20,0.00,0.00,3.06,128.52,'2022-05-07 08:48:01','',''),(6662,'1','223','1',1,'Retail Sale Id 7038',1252.40,0.00,0.00,2.02,84.84,'2022-05-07 08:48:44','',''),(6663,'1','223','1',1,'Retail Sale Id 7039',3751.00,0.00,0.00,6.05,254.10,'2022-05-07 08:57:35','',''),(6664,'1','223','1',1,'Retail Sale Id 7040',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 09:00:18','',''),(6665,'1','223','1',1,'Retail Sale Id 7041',3751.00,0.00,0.00,6.05,254.10,'2022-05-07 09:01:30','',''),(6666,'1','223','1',1,'Retail Sale Id 7042',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 09:02:24','',''),(6667,'1','223','1',1,'Retail Sale Id 7043',1302.00,0.00,0.00,2.10,88.20,'2022-05-07 09:03:36','',''),(6668,'1','223','1',1,'Retail Sale Id 7044',2498.60,0.00,0.00,4.03,169.26,'2022-05-07 09:12:52','',''),(6669,'1','223','1',1,'Retail Sale Id 7045',2002.60,0.00,0.00,3.23,135.66,'2022-05-07 09:17:09','',''),(6670,'1','223','1',1,'Retail Sale Id 7046',620.00,0.00,0.00,1.00,42.00,'2022-05-07 09:19:52','',''),(6671,'1','223','1',1,'Retail Sale Id 7047',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 09:20:46','',''),(6672,'1','223','1',1,'Retail Sale Id 7048',998.20,0.00,0.00,1.61,67.62,'2022-05-07 09:26:21','',''),(6673,'1','223','1',1,'Retail Sale Id 7049',118000.00,0.00,0.00,200.00,2400.00,'2022-05-07 09:28:33','',''),(6674,'1','223','1',1,'Retail Sale Id 7050',7750.00,0.00,0.00,12.50,525.00,'2022-05-07 09:29:18','',''),(6675,'1','223','1',1,'Retail Sale Id 7051',1500.40,0.00,0.00,2.42,101.64,'2022-05-07 09:31:18','',''),(6676,'1','223','1',1,'Retail Sale Id 7052',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 09:46:09','',''),(6677,'1','223','1',1,'Retail Sale Id 7053',998.20,0.00,0.00,1.61,67.62,'2022-05-07 09:47:30','',''),(6678,'1','223','1',1,'Retail Sale Id 7054',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 09:48:14','',''),(6679,'1','223','1',1,'Retail Sale Id 7055',998.20,0.00,0.00,1.61,67.62,'2022-05-07 10:00:14','',''),(6680,'1','223','1',1,'Retail Sale Id 7056',1897.20,0.00,0.00,3.06,128.52,'2022-05-07 10:00:50','',''),(6681,'1','223','1',1,'Retail Sale Id 7057',17700.00,0.00,0.00,30.00,360.00,'2022-05-07 10:24:10','',''),(6682,'1','223','1',1,'Retail Sale Id 7058',2498.60,0.00,0.00,4.03,169.26,'2022-05-07 10:37:05','',''),(6683,'1','223','1',1,'Retail Sale Id 7059',1302.00,0.00,0.00,2.10,88.20,'2022-05-07 10:37:48','',''),(6684,'1','223','1',1,'Retail Sale Id 7060',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 10:40:11','',''),(6685,'1','223','1',1,'Retail Sale Id 7061',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 10:45:29','',''),(6686,'1','223','1',1,'Retail Sale Id 7062',1252.40,0.00,0.00,2.02,84.84,'2022-05-07 10:46:29','',''),(6687,'1','223','1',1,'Retail Sale Id 7063',3000.80,0.00,0.00,4.84,203.28,'2022-05-07 10:48:58','',''),(6688,'1','223','1',1,'Retail Sale Id 7064',998.20,0.00,0.00,1.61,67.62,'2022-05-07 10:51:20','',''),(6689,'1','223','1',1,'Retail Sale Id 7066',7750.00,0.00,0.00,12.50,525.00,'2022-05-07 10:55:43','',''),(6690,'1','223','1',1,'Retail Sale Id 7067',1252.40,0.00,0.00,2.02,84.84,'2022-05-07 10:56:28','',''),(6691,'1','223','1',1,'Retail Sale Id 7070',3701.40,0.00,0.00,5.97,250.74,'2022-05-07 10:59:22','',''),(6692,'1','223','1',1,'Retail Sale Id 7071',2480.00,0.00,0.00,4.00,168.00,'2022-05-07 11:06:49','',''),(6693,'1','223','1',1,'Retail Sale Id 7072',2480.00,0.00,0.00,4.00,168.00,'2022-05-07 11:07:47','',''),(6694,'1','223','1',1,'Retail Sale Id 7073',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 11:09:14','',''),(6695,'1','223','1',1,'Retail Sale Id 7074',1897.20,0.00,0.00,3.06,128.52,'2022-05-07 11:12:58','',''),(6696,'1','223','1',1,'Retail Sale Id 7075',1302.00,0.00,0.00,2.10,88.20,'2022-05-07 11:16:11','',''),(6697,'1','223','1',1,'Retail Sale Id 7076',1798.00,0.00,0.00,2.90,121.80,'2022-05-07 11:17:12','',''),(6698,'1','223','1',1,'Retail Sale Id 7077',998.20,0.00,0.00,1.61,67.62,'2022-05-07 11:18:50','',''),(6699,'1','223','1',1,'Retail Sale Id 7078',1302.00,0.00,0.00,2.10,88.20,'2022-05-07 11:21:32','',''),(6700,'1','223','1',1,'Retail Sale Id 7079',1302.00,0.00,0.00,2.10,88.20,'2022-05-07 11:22:03','',''),(6701,'1','223','1',1,'Retail Sale Id 7080',2498.60,0.00,0.00,4.03,169.26,'2022-05-07 11:22:50','',''),(6702,'1','223','1',1,'Retail Sale Id 7081',3999.00,0.00,0.00,6.45,270.90,'2022-05-07 11:45:10','',''),(6703,'1','223','1',1,'Retail Sale Id 7082',3000.80,0.00,0.00,4.84,203.28,'2022-05-07 11:55:48','',''),(6704,'1','223','1',1,'Retail Sale Id 7083',998.20,0.00,0.00,1.61,67.62,'2022-05-07 11:59:17','',''),(6705,'1','223','1',1,'Retail Sale Id 7084',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 12:01:41','',''),(6706,'1','223','1',1,'Return of Retail Sale Id 7084',0.00,1240.00,2.00,0.00,-84.00,'2022-05-07 12:01:57','',''),(6707,'1','223','1',1,'Retail Sale Id 7085',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 12:02:20','',''),(6708,'1','223','1',1,'Retail Sale Id 7086',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 12:10:30','',''),(6709,'1','223','1',1,'Retail Sale Id 7087',1897.20,0.00,0.00,3.06,128.52,'2022-05-07 12:35:19','',''),(6710,'1','223','1',1,'Return of Retail Sale Id 7087',0.00,1897.20,3.06,0.00,-128.52,'2022-05-07 12:35:44','',''),(6711,'1','223','1',1,'Retail Sale Id 7088',2002.60,0.00,0.00,3.23,135.66,'2022-05-07 12:36:04','',''),(6712,'1','223','1',1,'Retail Sale Id 7089',2480.00,0.00,0.00,4.00,168.00,'2022-05-07 12:40:29','',''),(6713,'1','223','1',1,'Retail Sale Id 7090',1897.20,0.00,0.00,3.06,128.52,'2022-05-07 12:53:13','',''),(6714,'1','223','1',1,'Retail Sale Id 7091',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 13:32:59','',''),(6715,'1','223','1',1,'Retail Sale Id 7092',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 14:07:32','',''),(6716,'1','223','1',1,'Retail Sale Id 7093',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 14:10:39','',''),(6717,'1','223','1',1,'Retail Sale Id 7094',1202.80,0.00,0.00,1.94,81.48,'2022-05-07 14:48:52','',''),(6718,'1','223','1',1,'Retail Sale Id 7095',7750.00,0.00,0.00,12.50,525.00,'2022-05-07 14:50:01','',''),(6719,'1','223','1',1,'Retail Sale Id 7096',3100.00,0.00,0.00,5.00,210.00,'2022-05-07 14:51:35','',''),(6720,'1','223','1',1,'Retail Sale Id 7097',1302.00,0.00,0.00,2.10,88.20,'2022-05-07 15:06:00','',''),(6721,'1','223','1',1,'Retail Sale Id 7098',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 15:09:22','',''),(6722,'1','223','1',1,'Retail Sale Id 7099',2480.00,0.00,0.00,4.00,168.00,'2022-05-07 15:21:09','',''),(6723,'1','223','1',1,'Retail Sale Id 7100',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 15:29:16','',''),(6724,'1','223','1',1,'Retail Sale Id 7100',7750.00,0.00,0.00,12.50,525.00,'2022-05-07 15:29:16','',''),(6725,'1','223','1',1,'Retail Sale Id 7101',651.00,0.00,0.00,1.05,44.10,'2022-05-07 15:34:54','',''),(6726,'1','223','1',1,'Retail Sale Id 7102',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 15:36:09','',''),(6727,'1','223','1',1,'Retail Sale Id 7104',1252.40,0.00,0.00,2.02,84.84,'2022-05-07 15:39:49','',''),(6728,'1','223','1',1,'Retail Sale Id 7105',2480.00,0.00,0.00,4.00,168.00,'2022-05-07 15:48:34','',''),(6729,'1','223','1',1,'Retail Sale Id 7106',6200.00,0.00,0.00,10.00,420.00,'2022-05-07 15:50:38','',''),(6730,'1','223','1',1,'Retail Sale Id 7107',3999.00,0.00,0.00,6.45,270.90,'2022-05-07 15:51:47','',''),(6731,'1','223','1',1,'Retail Sale Id 7108',2002.60,0.00,0.00,3.23,135.66,'2022-05-07 15:52:50','',''),(6732,'1','223','1',1,'Retail Sale Id 7110',1897.20,0.00,0.00,3.06,128.52,'2022-05-07 15:59:57','',''),(6733,'1','223','1',1,'Retail Sale Id 7111',2480.00,0.00,0.00,4.00,168.00,'2022-05-07 16:02:03','',''),(6734,'1','223','1',1,'Retail Sale Id 7112',998.20,0.00,0.00,1.61,67.62,'2022-05-07 16:04:47','',''),(6735,'1','223','1',1,'Retail Sale Id 7113',998.20,0.00,0.00,1.61,67.62,'2022-05-07 16:08:11','',''),(6736,'1','223','1',1,'Retail Sale Id 7114',1202.80,0.00,0.00,1.94,81.48,'2022-05-07 16:10:35','',''),(6737,'1','223','1',1,'Retail Sale Id 7115',998.20,0.00,0.00,1.61,67.62,'2022-05-07 16:11:44','',''),(6738,'1','223','1',1,'Retail Sale Id 7116',700.60,0.00,0.00,1.13,47.46,'2022-05-07 16:12:25','',''),(6739,'1','223','1',1,'Retail Sale Id 7117',1798.00,0.00,0.00,2.90,121.80,'2022-05-07 16:16:27','',''),(6740,'1','223','1',1,'Retail Sale Id 7118',1500.40,0.00,0.00,2.42,101.64,'2022-05-07 16:23:05','',''),(6741,'1','223','1',1,'Retail Sale Id 7119',1897.20,0.00,0.00,3.06,128.52,'2022-05-07 16:25:15','',''),(6742,'1','223','1',1,'Retail Sale Id 7120',1202.80,0.00,0.00,1.94,81.48,'2022-05-07 16:43:03','',''),(6743,'1','223','1',1,'Retail Sale Id 7121',1401.20,0.00,0.00,2.26,94.92,'2022-05-07 16:44:29','',''),(6744,'1','223','1',1,'Retail Sale Id 7122',0.00,0.00,0.00,0.00,0.00,'2022-05-07 16:48:51','',''),(6745,'1','223','1',1,'Retail Sale Id 7123',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 16:50:03','',''),(6746,'1','223','1',1,'Retail Sale Id 7124',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 16:50:58','',''),(6747,'1','223','1',1,'Retail Sale Id 7125',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 16:52:46','',''),(6748,'1','223','1',1,'Retail Sale Id 7126',1252.40,0.00,0.00,2.02,84.84,'2022-05-07 16:54:50','',''),(6749,'1','223','1',1,'Retail Sale Id 7128',3100.00,0.00,0.00,5.00,210.00,'2022-05-07 16:59:27','',''),(6750,'1','223','1',1,'Retail Sale Id 7129',1252.40,0.00,0.00,2.02,84.84,'2022-05-07 17:00:30','',''),(6751,'1','223','1',1,'Retail Sale Id 7130',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 17:10:15','',''),(6752,'1','223','1',1,'Retail Sale Id 7130',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 17:10:15','',''),(6753,'1','223','1',1,'Return of Retail Sale Id 7122',0.00,0.00,0.00,0.00,0.00,'2022-05-07 17:11:45','',''),(6754,'1','223','1',1,'Retail Sale Id 7131',1500.40,0.00,0.00,2.42,101.64,'2022-05-07 17:13:47','',''),(6755,'1','223','1',1,'Retail Sale Id 7132',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 17:14:29','',''),(6756,'1','223','1',1,'Retail Sale Id 7134',1847.60,0.00,0.00,2.98,125.16,'2022-05-07 17:16:47','',''),(6757,'1','223','1',1,'Retail Sale Id 7135',3100.00,0.00,0.00,5.00,210.00,'2022-05-07 17:18:27','',''),(6758,'1','223','1',1,'Retail Sale Id 7136',3100.00,0.00,0.00,5.00,210.00,'2022-05-07 17:19:28','',''),(6759,'1','223','1',1,'Retail Sale Id 7137',620.00,0.00,0.00,1.00,42.00,'2022-05-07 17:25:18','',''),(6760,'1','223','1',1,'Retail Sale Id 7137',620.00,0.00,0.00,1.00,42.00,'2022-05-07 17:25:18','',''),(6761,'1','223','1',1,'Retail Sale Id 7138',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 17:26:36','',''),(6762,'1','223','1',1,'Retail Sale Id 7139',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 17:29:40','',''),(6763,'1','223','1',1,'Retail Sale Id 7140',1847.60,0.00,0.00,2.98,125.16,'2022-05-07 17:35:44','',''),(6764,'1','223','1',1,'Retail Sale Id 7141',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 17:38:57','',''),(6765,'1','223','1',1,'Retail Sale Id 7144',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 17:40:40','',''),(6766,'1','223','1',1,'Retail Sale Id 7145',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 17:41:27','',''),(6767,'1','223','1',1,'Retail Sale Id 7146',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 17:42:54','',''),(6768,'1','223','1',1,'Retail Sale Id 7147',591770.00,0.00,0.00,1003.00,12036.00,'2022-05-07 17:44:59','',''),(6769,'1','223','1',1,'Retail Sale Id 7148',3100.00,0.00,0.00,5.00,210.00,'2022-05-07 17:45:23','',''),(6770,'1','223','1',1,'Retail Sale Id 7149',2201.00,0.00,0.00,3.55,149.10,'2022-05-07 17:47:10','',''),(6771,'1','223','1',1,'Retail Sale Id 7152',998.20,0.00,0.00,1.61,67.62,'2022-05-07 17:50:07','',''),(6772,'1','223','1',1,'Retail Sale Id 7153',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 17:50:43','',''),(6773,'1','223','1',1,'Retail Sale Id 7154',10230.00,0.00,0.00,16.50,693.00,'2022-05-07 17:51:41','',''),(6774,'1','223','1',1,'Retail Sale Id 7155',998.20,0.00,0.00,1.61,67.62,'2022-05-07 17:53:02','',''),(6775,'1','223','1',1,'Retail Sale Id 7156',7750.00,0.00,0.00,12.50,525.00,'2022-05-07 17:55:27','',''),(6776,'1','223','1',1,'Retail Sale Id 7157',620.00,0.00,0.00,1.00,42.00,'2022-05-07 17:56:58','',''),(6777,'1','223','1',1,'Retail Sale Id 7159',2480.00,0.00,0.00,4.00,168.00,'2022-05-07 17:58:43','',''),(6778,'1','223','1',1,'Retail Sale Id 7160',3503.00,0.00,0.00,5.65,237.30,'2022-05-07 18:01:49','',''),(6779,'1','223','1',1,'Retail Sale Id 7161',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 18:02:16','',''),(6780,'1','223','1',1,'Retail Sale Id 7162',29500.00,0.00,0.00,50.00,600.00,'2022-05-07 18:03:23','',''),(6781,'1','223','1',1,'Retail Sale Id 7163',2002.60,0.00,0.00,3.23,135.66,'2022-05-07 18:04:16','',''),(6782,'1','223','1',1,'Retail Sale Id 7164',3100.00,0.00,0.00,5.00,210.00,'2022-05-07 18:05:15','',''),(6783,'1','223','1',1,'Retail Sale Id 7165',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 18:09:09','',''),(6784,'1','223','1',1,'Retail Sale Id 7167',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 18:10:04','',''),(6785,'1','223','1',1,'Retail Sale Id 7168',6497.60,0.00,0.00,10.48,440.16,'2022-05-07 18:12:46','',''),(6786,'1','223','1',1,'Retail Sale Id 7170',1240.00,0.00,0.00,2.00,84.00,'2022-05-07 18:13:38','',''),(6787,'1','223','1',1,'Retail Sale Id 7171',3100.00,0.00,0.00,5.00,210.00,'2022-05-07 18:16:17','',''),(6788,'1','223','1',1,'Retail Sale Id 7172',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 18:17:24','',''),(6789,'1','223','1',1,'Retail Sale Id 7173',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 18:18:04','',''),(6790,'1','223','1',1,'Retail Sale Id 7174',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 18:19:54','',''),(6791,'1','223','1',1,'Retail Sale Id 7175',3100.00,0.00,0.00,5.00,210.00,'2022-05-07 18:20:43','',''),(6792,'1','223','1',1,'Retail Sale Id 7176',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 18:21:34','',''),(6793,'1','223','1',1,'Retail Sale Id 7177',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 18:22:19','',''),(6794,'1','223','1',1,'Retail Sale Id 7178',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 18:23:15','',''),(6795,'1','223','1',1,'Retail Sale Id 7179',3720.00,0.00,0.00,6.00,252.00,'2022-05-07 18:23:37','',''),(6796,'1','223','1',1,'Retail Sale Id 7180',2480.00,0.00,0.00,4.00,168.00,'2022-05-07 18:24:30','',''),(6797,'1','223','1',1,'Retail Sale Id 7181',7750.00,0.00,0.00,12.50,525.00,'2022-05-07 18:27:15','',''),(6798,'1','223','1',1,'Retail Sale Id 7182',2002.60,0.00,0.00,3.23,135.66,'2022-05-07 18:28:08','',''),(6799,'1','223','1',1,'Retail Sale Id 7183',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 18:28:46','',''),(6800,'1','223','1',1,'Retail Sale Id 7184',1897.20,0.00,0.00,3.06,128.52,'2022-05-07 18:32:16','',''),(6801,'1','223','1',1,'Retail Sale Id 7185',6200.00,0.00,0.00,10.00,420.00,'2022-05-07 18:32:47','',''),(6802,'1','223','1',1,'Retail Sale Id 7186',799.80,0.00,0.00,1.29,54.18,'2022-05-07 18:33:32','',''),(6803,'1','223','1',1,'Retail Sale Id 7187',1860.00,0.00,0.00,3.00,126.00,'2022-05-07 18:38:09','',''),(6804,'1','223','1',1,'Retail Sale Id 7188',7750.00,0.00,0.00,12.50,525.00,'2022-05-07 18:38:59','',''),(6805,'1','223','1',1,'Retail Sale Id 7190',1798.00,0.00,0.00,2.90,121.80,'2022-05-07 18:50:48','',''),(6806,'1','223','1',1,'Return of Retail Sale Id 7082',0.00,3000.80,4.84,0.00,-203.28,'2022-05-07 19:24:49','',''),(6807,'1','223','1',1,'Retail Sale Id 7191',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 07:19:09','',''),(6808,'1','223','1',1,'Retail Sale Id 7192',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 07:20:53','',''),(6809,'1','223','1',1,'Retail Sale Id 7194',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 07:21:24','',''),(6810,'1','223','1',1,'Retail Sale Id 7195',601.40,0.00,0.00,0.97,40.74,'2022-05-08 07:24:34','',''),(6811,'1','223','1',1,'Retail Sale Id 7196',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 07:31:37','',''),(6812,'1','223','1',1,'Retail Sale Id 7197',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 07:37:25','',''),(6813,'1','223','1',1,'Retail Sale Id 7198',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 07:50:12','',''),(6814,'1','223','1',1,'Retail Sale Id 7199',620.00,0.00,0.00,1.00,42.00,'2022-05-08 08:05:22','',''),(6815,'1','223','1',1,'Retail Sale Id 7200',700.60,0.00,0.00,1.13,47.46,'2022-05-08 08:08:07','',''),(6816,'1','223','1',1,'Retail Sale Id 7203',700.60,0.00,0.00,1.13,47.46,'2022-05-08 08:08:41','',''),(6817,'1','223','1',1,'Retail Sale Id 7204',3100.00,0.00,0.00,5.00,210.00,'2022-05-08 08:16:34','',''),(6818,'1','223','1',1,'Retail Sale Id 7205',1302.00,0.00,0.00,2.10,88.20,'2022-05-08 08:22:04','',''),(6819,'1','223','1',1,'Retail Sale Id 7206',2480.00,0.00,0.00,4.00,168.00,'2022-05-08 08:25:03','',''),(6820,'1','223','1',1,'Retail Sale Id 7207',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 08:25:51','',''),(6821,'1','223','1',1,'Retail Sale Id 7208',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 08:27:10','',''),(6822,'1','223','1',1,'Retail Sale Id 7209',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 08:36:55','',''),(6823,'1','223','1',1,'Retail Sale Id 7210',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 08:39:00','',''),(6824,'1','223','1',1,'Retail Sale Id 7211',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 08:42:12','',''),(6825,'1','223','1',1,'Retail Sale Id 7212',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 08:44:21','',''),(6826,'1','223','1',1,'Retail Sale Id 7213',3100.00,0.00,0.00,5.00,210.00,'2022-05-08 08:56:38','',''),(6827,'1','223','1',1,'Retail Sale Id 7214',1401.20,0.00,0.00,2.26,94.92,'2022-05-08 09:13:48','',''),(6828,'1','223','1',1,'Retail Sale Id 7215',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 09:17:44','',''),(6829,'1','223','1',1,'Retail Sale Id 7216',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 09:32:29','',''),(6830,'1','223','1',1,'Retail Sale Id 7217',2480.00,0.00,0.00,4.00,168.00,'2022-05-08 09:41:00','',''),(6831,'1','223','1',1,'Retail Sale Id 7218',601.40,0.00,0.00,0.97,40.74,'2022-05-08 09:42:51','',''),(6832,'1','223','1',1,'Retail Sale Id 7219',601.40,0.00,0.00,0.97,40.74,'2022-05-08 09:43:32','',''),(6833,'1','223','1',1,'Retail Sale Id 7220',3000.80,0.00,0.00,4.84,203.28,'2022-05-08 09:44:11','',''),(6834,'1','223','1',1,'Retail Sale Id 7221',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 09:46:37','',''),(6835,'1','223','1',1,'Retail Sale Id 7222',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 09:52:00','',''),(6836,'1','223','1',1,'Retail Sale Id 7223',3751.00,0.00,0.00,6.05,254.10,'2022-05-08 09:55:55','',''),(6837,'1','223','1',1,'Retail Sale Id 7224',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 10:00:12','',''),(6838,'1','223','1',1,'Retail Sale Id 7225',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 10:02:10','',''),(6839,'1','223','1',1,'Retail Sale Id 7226',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 10:17:29','',''),(6840,'1','223','1',1,'Retail Sale Id 7227',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 10:18:58','',''),(6841,'1','223','1',1,'Retail Sale Id 7228',4340.00,0.00,0.00,7.00,294.00,'2022-05-08 10:25:11','',''),(6842,'1','223','1',1,'Retail Sale Id 7229',1202.80,0.00,0.00,1.94,81.48,'2022-05-08 10:28:14','',''),(6843,'1','223','1',1,'Retail Sale Id 7230',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 10:30:16','',''),(6844,'1','223','1',1,'Retail Sale Id 7231',700.60,0.00,0.00,1.13,47.46,'2022-05-08 10:39:30','',''),(6845,'1','223','1',1,'Retail Sale Id 7232',6200.00,0.00,0.00,10.00,420.00,'2022-05-08 10:46:49','',''),(6846,'1','223','1',1,'Retail Sale Id 7234',3800.60,0.00,0.00,6.13,257.46,'2022-05-08 11:03:17','',''),(6847,'1','223','1',1,'Retail Sale Id 7235',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 11:04:02','',''),(6848,'1','223','1',1,'Retail Sale Id 7236',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 11:10:43','',''),(6849,'1','223','1',1,'Retail Sale Id 7237',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 11:15:50','',''),(6850,'1','223','1',1,'Retail Sale Id 7238',3100.00,0.00,0.00,5.00,210.00,'2022-05-08 11:19:03','',''),(6851,'1','223','1',1,'Retail Sale Id 7239',998.20,0.00,0.00,1.61,67.62,'2022-05-08 11:21:12','',''),(6852,'1','223','1',1,'Retail Sale Id 7240',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 11:21:54','',''),(6853,'1','223','1',1,'Retail Sale Id 7241',6200.00,0.00,0.00,10.00,420.00,'2022-05-08 11:26:10','',''),(6854,'1','223','1',1,'Retail Sale Id 7242',6200.00,0.00,0.00,10.00,420.00,'2022-05-08 11:28:18','',''),(6855,'1','223','1',1,'Retail Sale Id 7243',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 11:30:14','',''),(6856,'1','223','1',1,'Retail Sale Id 7244',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 11:55:14','',''),(6857,'1','223','1',1,'Retail Sale Id 7245',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 12:05:29','',''),(6858,'1','223','1',1,'Retail Sale Id 7246',3100.00,0.00,0.00,5.00,210.00,'2022-05-08 12:14:41','',''),(6859,'1','223','1',1,'Retail Sale Id 7247',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 12:33:40','',''),(6860,'1','223','1',1,'Retail Sale Id 7248',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 12:34:21','',''),(6861,'1','223','1',1,'Retail Sale Id 7249',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 12:41:08','',''),(6862,'1','223','1',1,'Retail Sale Id 7250',4340.00,0.00,0.00,7.00,294.00,'2022-05-08 12:47:26','',''),(6863,'1','223','1',1,'Retail Sale Id 7251',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 12:48:45','',''),(6864,'1','223','1',1,'Retail Sale Id 7252',998.20,0.00,0.00,1.61,67.62,'2022-05-08 12:49:14','',''),(6865,'1','223','1',1,'Retail Sale Id 7253',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 12:59:22','',''),(6866,'1','223','1',1,'Retail Sale Id 7254',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 13:02:29','',''),(6867,'1','223','1',1,'Retail Sale Id 7255',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 13:06:50','',''),(6868,'1','223','1',1,'Retail Sale Id 7256',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 13:07:32','',''),(6869,'1','223','1',1,'Retail Sale Id 7257',700.60,0.00,0.00,1.13,47.46,'2022-05-08 13:08:33','',''),(6870,'1','223','1',1,'Retail Sale Id 7258',651.00,0.00,0.00,1.05,44.10,'2022-05-08 13:22:36','',''),(6871,'1','223','1',1,'Retail Sale Id 7259',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 13:32:23','',''),(6872,'1','223','1',1,'Retail Sale Id 7260',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 13:33:27','',''),(6873,'1','223','1',1,'Retail Sale Id 7261',9920.00,0.00,0.00,16.00,672.00,'2022-05-08 13:44:40','',''),(6874,'1','223','1',1,'Retail Sale Id 7262',3100.00,0.00,0.00,5.00,210.00,'2022-05-08 13:49:21','',''),(6875,'1','223','1',1,'Retail Sale Id 7263',1847.60,0.00,0.00,2.98,125.16,'2022-05-08 13:58:21','',''),(6876,'1','223','1',1,'Retail Sale Id 7264',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 14:06:34','',''),(6877,'1','223','1',1,'Retail Sale Id 7265',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 14:17:14','',''),(6878,'1','223','1',1,'Retail Sale Id 7266',2498.60,0.00,0.00,4.03,169.26,'2022-05-08 14:23:32','',''),(6879,'1','223','1',1,'Retail Sale Id 7267',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 14:26:52','',''),(6880,'1','223','1',1,'Retail Sale Id 7268',998.20,0.00,0.00,1.61,67.62,'2022-05-08 14:30:36','',''),(6881,'1','223','1',1,'Retail Sale Id 7269',3100.00,0.00,0.00,5.00,210.00,'2022-05-08 14:31:13','',''),(6882,'1','223','1',1,'Retail Sale Id 7270',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 14:32:36','',''),(6883,'1','223','1',1,'Retail Sale Id 7271',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 14:33:28','',''),(6884,'1','223','1',1,'Retail Sale Id 7272',998.20,0.00,0.00,1.61,67.62,'2022-05-08 14:52:07','',''),(6885,'1','223','1',1,'Retail Sale Id 7273',700.60,0.00,0.00,1.13,47.46,'2022-05-08 15:03:26','',''),(6886,'1','223','1',1,'Retail Sale Id 7274',3751.00,0.00,0.00,6.05,254.10,'2022-05-08 15:07:44','',''),(6887,'1','223','1',1,'Retail Sale Id 7275',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 15:12:50','',''),(6888,'1','223','1',1,'Retail Sale Id 7276',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 15:22:14','',''),(6889,'1','223','1',1,'Retail Sale Id 7277',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 15:29:09','',''),(6890,'1','223','1',1,'Retail Sale Id 7278',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 15:32:27','',''),(6891,'1','223','1',1,'Retail Sale Id 7279',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 15:36:04','',''),(6892,'1','223','1',1,'Retail Sale Id 7280',1798.00,0.00,0.00,2.90,121.80,'2022-05-08 15:42:30','',''),(6893,'1','223','1',1,'Retail Sale Id 7281',651.00,0.00,0.00,1.05,44.10,'2022-05-08 15:43:49','',''),(6894,'1','223','1',1,'Retail Sale Id 7282',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 15:44:52','',''),(6895,'1','223','1',1,'Retail Sale Id 7283',601.40,0.00,0.00,0.97,40.74,'2022-05-08 15:53:21','',''),(6896,'1','223','1',1,'Retail Sale Id 7284',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 15:54:39','',''),(6897,'1','223','1',1,'Retail Sale Id 7285',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 15:55:17','',''),(6898,'1','223','1',1,'Retail Sale Id 7286',2480.00,0.00,0.00,4.00,168.00,'2022-05-08 15:56:00','',''),(6899,'1','223','1',1,'Retail Sale Id 7287',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 15:57:32','',''),(6900,'1','223','1',1,'Retail Sale Id 7288',4352.40,0.00,0.00,7.02,294.84,'2022-05-08 16:02:27','',''),(6901,'1','223','1',1,'Retail Sale Id 7289',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 16:09:46','',''),(6902,'1','223','1',1,'Retail Sale Id 7290',2498.60,0.00,0.00,4.03,169.26,'2022-05-08 16:12:16','',''),(6903,'1','223','1',1,'Retail Sale Id 7291',1202.80,0.00,0.00,1.94,81.48,'2022-05-08 16:14:10','',''),(6904,'1','223','1',1,'Retail Sale Id 7292',3100.00,0.00,0.00,5.00,210.00,'2022-05-08 16:15:06','',''),(6905,'1','223','1',1,'Return of Retail Sale Id 7292',0.00,3100.00,5.00,0.00,-210.00,'2022-05-08 16:15:45','',''),(6906,'1','223','1',1,'Retail Sale Id 7293',3701.40,0.00,0.00,5.97,250.74,'2022-05-08 16:16:08','',''),(6907,'1','223','1',1,'Retail Sale Id 7294',3100.00,0.00,0.00,5.00,210.00,'2022-05-08 16:17:03','',''),(6908,'1','223','1',1,'Retail Sale Id 7296',3751.00,0.00,0.00,6.05,254.10,'2022-05-08 16:18:23','',''),(6909,'1','223','1',1,'Retail Sale Id 7297',1097.40,0.00,0.00,1.77,74.34,'2022-05-08 16:22:09','',''),(6910,'1','223','1',1,'Retail Sale Id 7298',1500.40,0.00,0.00,2.42,101.64,'2022-05-08 16:23:50','',''),(6911,'1','223','1',1,'Retail Sale Id 7299',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 16:30:12','',''),(6912,'1','223','1',1,'Retail Sale Id 7301',700.60,0.00,0.00,1.13,47.46,'2022-05-08 16:32:16','',''),(6913,'1','223','1',1,'Retail Sale Id 7302',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 16:33:47','',''),(6914,'1','223','1',1,'Retail Sale Id 7303',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 16:35:10','',''),(6915,'1','223','1',1,'Retail Sale Id 7304',1500.40,0.00,0.00,2.42,101.64,'2022-05-08 16:37:28','',''),(6916,'1','223','1',1,'Retail Sale Id 7305',1500.40,0.00,0.00,2.42,101.64,'2022-05-08 16:41:26','',''),(6917,'1','223','1',1,'Retail Sale Id 7306',2480.00,0.00,0.00,4.00,168.00,'2022-05-08 16:44:59','',''),(6918,'1','223','1',1,'Retail Sale Id 7307',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 16:53:22','',''),(6919,'1','223','1',1,'Retail Sale Id 7308',7750.00,0.00,0.00,12.50,525.00,'2022-05-08 16:58:46','',''),(6920,'1','223','1',1,'Retail Sale Id 7309',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 16:59:32','',''),(6921,'1','223','1',1,'Retail Sale Id 7310',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 17:00:15','',''),(6922,'1','223','1',1,'Retail Sale Id 7311',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 17:11:25','',''),(6923,'1','223','1',1,'Retail Sale Id 7312',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 17:17:22','',''),(6924,'1','223','1',1,'Retail Sale Id 7313',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 17:17:55','',''),(6925,'1','223','1',1,'Retail Sale Id 7314',3751.00,0.00,0.00,6.05,254.10,'2022-05-08 17:20:09','',''),(6926,'1','223','1',1,'Retail Sale Id 7315',700.60,0.00,0.00,1.13,47.46,'2022-05-08 17:21:31','',''),(6927,'1','223','1',1,'Retail Sale Id 7316',601.40,0.00,0.00,0.97,40.74,'2022-05-08 17:24:41','',''),(6928,'1','223','1',1,'Retail Sale Id 7317',998.20,0.00,0.00,1.61,67.62,'2022-05-08 17:25:23','',''),(6929,'1','223','1',1,'Retail Sale Id 7318',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 17:27:43','',''),(6930,'1','223','1',1,'Retail Sale Id 7319',2480.00,0.00,0.00,4.00,168.00,'2022-05-08 17:32:50','',''),(6931,'1','223','1',1,'Retail Sale Id 7320',1240.00,0.00,0.00,2.00,84.00,'2022-05-08 17:33:42','',''),(6932,'1','223','1',1,'Retail Sale Id 7336',3100.00,0.00,0.00,5.00,210.00,'2022-05-08 17:35:46','',''),(6933,'1','223','1',1,'Retail Sale Id 7337',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 17:36:48','',''),(6934,'1','223','1',1,'Retail Sale Id 7338',3751.00,0.00,0.00,6.05,254.10,'2022-05-08 17:40:42','',''),(6935,'1','223','1',1,'Retail Sale Id 7339',1860.00,0.00,0.00,3.00,126.00,'2022-05-08 17:41:44','',''),(6936,'1','223','1',1,'Retail Sale Id 7340',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 17:42:47','',''),(6937,'1','223','1',1,'Retail Sale Id 7341',1847.60,0.00,0.00,2.98,125.16,'2022-05-08 17:44:46','',''),(6938,'1','223','1',1,'Retail Sale Id 7342',750.20,0.00,0.00,1.21,50.82,'2022-05-08 17:46:18','',''),(6939,'1','223','1',1,'Retail Sale Id 7343',1847.60,0.00,0.00,2.98,125.16,'2022-05-08 17:48:59','',''),(6940,'1','223','1',1,'Retail Sale Id 7344',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 17:53:30','',''),(6941,'1','223','1',1,'Retail Sale Id 7345',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 17:57:52','',''),(6942,'1','223','1',1,'Retail Sale Id 7346',1798.00,0.00,0.00,2.90,121.80,'2022-05-08 18:06:04','',''),(6943,'1','223','1',1,'Retail Sale Id 7347',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 18:06:41','',''),(6944,'1','223','1',1,'Retail Sale Id 7348',6200.00,0.00,0.00,10.00,420.00,'2022-05-08 18:07:33','',''),(6945,'1','223','1',1,'Retail Sale Id 7349',1252.40,0.00,0.00,2.02,84.84,'2022-05-08 18:08:15','',''),(6946,'1','223','1',1,'Retail Sale Id 7351',651.00,0.00,0.00,1.05,44.10,'2022-05-08 18:10:32','',''),(6947,'1','223','1',1,'Retail Sale Id 7352',29500.00,0.00,0.00,50.00,600.00,'2022-05-08 18:11:47','',''),(6948,'1','223','1',1,'Retail Sale Id 7353',3720.00,0.00,0.00,6.00,252.00,'2022-05-08 18:13:56','',''),(6949,'1','223','1',1,'Retail Sale Id 7354',998.20,0.00,0.00,1.61,67.62,'2022-05-08 18:14:40','',''),(6950,'1','223','1',1,'Retail Sale Id 7355',1897.20,0.00,0.00,3.06,128.52,'2022-05-08 18:26:13','',''),(6951,'1','223','1',1,'Retail Sale Id 7356',1897.20,0.00,0.00,3.06,128.52,'2022-05-09 07:17:36','',''),(6952,'1','223','1',1,'Retail Sale Id 7357',1252.40,0.00,0.00,2.02,84.84,'2022-05-09 07:23:21','',''),(6953,'1','223','1',1