-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_219
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_219`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_219` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_219`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,8000,'',0,'24','1','219','PURCHASES ','','2022-02-25 16:39:33',5,0.00,0.00,'','178','2022-02-25 16:39:33','178',0,0),(2,7000,'',0,'20','1','219','SALES','','2022-02-25 16:39:59',5,0.00,0.00,'','178','2022-02-25 16:39:59','178',0,0),(3,8001,'',0,'24','1','219','SALARIES & WAGES','','2022-02-25 16:40:37',5,0.00,0.00,'','178','2022-02-25 16:40:37','178',0,0),(4,500,'',0,'6.1','1','219','CASH','','2022-02-25 16:40:52',5,0.00,0.00,'','178','2022-02-25 16:40:52','178',0,0),(5,2500,'',0,'2','1','219','DANKANO E-BILL(ZBN1014717618)','','2022-03-02 18:40:45',5,0.00,0.00,'','487','2022-03-02 18:40:45','487',0,0),(6,2501,'',0,'2','1','219','ZENITH BANK POS','','2022-03-02 18:45:23',5,0.00,0.00,'','487','2022-03-02 18:45:23','487',0,0),(7,2502,'',0,'2','1','219','ZB(LPG)1014471475','','2022-03-03 06:08:42',5,0.00,0.00,'','487','2022-03-03 06:08:42','487',0,0),(8,2503,'',0,'2','1','219','FB(IBAL)2023855223','','2022-03-03 06:09:03',5,0.00,0.00,'','487','2022-03-03 06:09:03','487',0,0),(9,2504,'',0,'2','1','219','ZB 1015394845','','2022-03-03 06:09:39',5,0.00,0.00,'','487','2022-03-03 06:09:39','487',0,0),(10,2505,'',0,'2','1','219','E-BILLS 1015372548','','2022-03-03 06:10:17',5,0.00,0.00,'','487','2022-03-03 06:10:17','487',0,0),(11,2506,'',0,'2','1','219','E-BILLS IBAL 1015372548','','2022-03-03 06:10:46',5,0.00,0.00,'','487','2022-03-03 06:10:46','487',0,0),(12,2507,'',0,'2','1','219','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:02:38',5,0.00,0.00,'','792','2023-02-20 14:02:38','792',0,0),(13,2508,'',0,'2','1','219','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:15:30',5,0.00,0.00,'2023-03-17','792','2023-03-17 12:20:39','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','219','ALKHAIRAT GAS ','ASHIRU MAGAJI','08036224118','sagirmasudeljibril@gmail.com','KANO','KANO STATE','KWAKWACHI DAWAKIN TOFA ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-02-26 13:03:49',5,'756','2022-02-26 13:03:49','756'),(2,'','1','219','M & H GAS','TASIU ADAMU IBRAHIM','09124298829','sagirmasudeljibril@gmail.com','KANO','KANO STATE','DAWAKIN TOFA ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-02-27 10:23:49',5,'756','2022-02-27 10:23:49','756'),(3,'','1','219','BINDAWA GAS','ABBA MUHAMMAD','08107186730','sagirmasudeljibril@gmail.com','KANO','KANO STATE','KUNTURE OPP GIDAN TAKI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-01 08:59:34',5,'756','2022-03-01 08:59:34','756'),(4,'','1','219','MARS GAS ','SADIQ SURAJ ABDULLAHI','08036873537','sagirmasudeljibril@gmail.com','KANO','KANO STATE','GANDU GRA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-03 13:04:12',5,'756','2022-03-03 13:04:12','756'),(5,'','1','219','MAI SCALEY GAS ','ABDULWAHAB SABIU','09026822696','sagirmasudeljibril@gmail.com','KAZAURE ','JIGAWA','KAZAURE ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-06 09:12:23',5,'756','2022-03-06 09:12:23','756'),(6,'','1','219','ZOLA GAS','SAFIYANU ADO MARAKU','08066378481','sagirmasudeljibril@gmail.com','KANO','KANO STATE','SHARADA PHASE ONE MUNICIPAL L. G. A','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-06 17:55:46',5,'756','2022-03-06 17:55:46','756'),(7,'','1','219','YUSUF  GAS','YUSUF SADI ABUBAKAR','08065829594','yusufsadiabubakargas@gmail.com','KANO','KANO STATE','Bachirawa','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-09 09:56:01',5,'756','2022-03-09 09:56:01','756'),(8,'','1','219','ISAH GAS','KAMALU GAMBO','08168176308','sagirmasudeljibril@gmail.com','KANO','KANO STATE','BACHIRAWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-09 14:01:35',5,'756','2022-03-09 14:01:35','756'),(9,'','1','219','GASKE BO GAS','JIBRIN UBA MAGAJI','08063046511','sagirmasudeljibril@gmail.com','KANO','KANO STATE','MILTARA ROUND','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-09 16:52:22',5,'756','2022-03-09 16:52:22','756'),(10,'','1','219','S.F.Y KERO AND GAS','SAFIYANU IBRAHIM','08037640303','sagirmasudeljibril@gmail.com','KANO','KANO STATE','RIJIYAR LEMO TITIN JAJIRA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-09 16:59:39',5,'756','2022-03-09 16:59:39','756'),(11,'','1','219','AMINCI  GAS','HAMISU YUSUF TAHIR','07035030184','sagirmasudeljibril@gmail.com','KANO','KANO STATE','RIJIYAR LEMO DOGON BENE FAGGE LOCAL GOVT KANO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-10 14:07:48',5,'756','2022-03-10 14:07:48','756'),(12,'','1','219','CLASSIC  GAS','SADIQ MUKTAR','08122206882','sagirmasudeljibril@gmail.com','KANO','KANO STATE','SHARADA PHASE ONEGWALE LGA KANO ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-10 14:12:07',5,'756','2022-03-10 14:12:07','756'),(13,'','1','219','OPERATIONAL LOST','OPERATIONAL LOST','00000000000','sagirmasudeljibril@gmail.com','Dawanau Mile-9','KANO STATE','DAWANAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-10 21:12:50',5,'756','2022-03-10 21:12:50','756'),(14,'','1','219','DAN KASUWA GAS','JAMILU IBRAHIM','07039605109','sagirmasudeljibril@gmail.comba','KANO','KANO STATE','BACHIRAWA TITIN ZANGO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-11 07:44:01',5,'756','2022-03-11 07:44:01','756'),(15,'','1','219','NUR GAS','IBRAHIM MUHAMMAD','08034851043','sagirmasudeljibril@gmail.com','KANO','KANO STATE','GIGINYU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-11 08:18:04',5,'756','2022-03-11 08:18:04','756'),(16,'','1','219','ABDUL GAS','ABDUL','0906666060','sagirmasudeljibril@gmail.com','KANO','KANO STATE','IKEJA MARKET','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-11 12:21:14',5,'756','2022-03-11 12:21:14','756'),(17,'','1','219','BARKIYA GAS','ISMAIL ABUBAKAR','07035854939','sagirmasudeljibril@gmail.com','KANO','KANO STATE','DAKATA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-11 15:26:56',5,'756','2022-03-11 15:26:56','756'),(18,'','1','219','AA SADIK GAS','ABUBAKAR ABDULLAHI','08140334008','sagirmasudeljibril@gmail.com','KANO','KANO STATE','BACHIRAWA KWANAR MADUGU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-11 16:04:54',5,'756','2022-03-11 16:04:54','756'),(19,'','1','219','RAHMANIYYA GAS','MUJITTAFA WALID','07042713149','sagirmasudeljibril@gmail.com','KANO','KANO STATE','BACHIRAWA KWANAR MADUGU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-11 16:26:25',5,'756','2022-03-11 16:26:25','756'),(20,'','1','219','DAN SAA GAS','USMAN HARUNA','08068826955','bashiribrahim.bsuccess33@gmail','KANO','KANO STATE','BACHIRA\r\nWA KWANAR MADUGU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-12 10:06:00',5,'756','2022-03-12 10:06:00','756'),(21,'','1','219','A.S FAGE GAS','MUSA KAKALE FAGE','08146911827','sagirmasudeljibril@gmail.com','KANO','KANO STATE','KWANAR UNGWAGGO,TITIN MAYANKA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-13 11:45:17',5,'756','2022-03-13 11:45:17','756'),(22,'','1','219','S.B DAN KASUWA GAS','USMAN IBRAHIM ','07032798593','sagirmasudeljibril@gmail.com','KANO','KANO STATE','LAYIN BAURE R/LEMO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-30 11:07:27',5,'756','2022-03-30 11:07:27','756'),(23,'','1','219','EPIDERM','RABIU ALKASIM','08060937735','sagirmasudeljibril@gmail.com','KANO','KANO STATE','RIJIYAR LEMO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-31 09:44:09',5,'756','2022-04-03 21:46:21','756'),(24,'','1','219','SALUHU GAS','SALIHU ASHIRU','09069231219','sagirmasudeljibril@gmail.com','KANO','KANO STATE','DAN DINSHE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-31 16:02:45',5,'756','2022-03-31 16:02:45','756'),(25,'','1','219','SA\'A GAS','HUSSAINI ADAM','07061820432','sagirmasudeljibril@gmail.com','KANO','KANO STATE','DAN RIMI R/LEMO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-04-01 10:05:20',5,'756','2022-04-01 10:05:20','756'),(26,'','1','219','UMMINA GAS','UMAR DAUDA ADAM','08032838127','sagirmasudeljibril@gmail.com','KANO','KANO STATE','KURNA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-04-01 18:40:16',5,'756','2022-04-01 18:40:16','756'),(27,'','1','219','M H D  GAS','MUHAMMAD SALISU','08168319281','sagirmasudeljibril@gmail.com','KANO','KANO STATE','KURNA LAYIN DAN ZAGO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-04-02 10:16:01',5,'756','2022-04-02 10:16:01','756'),(28,'','1','219','FREE MAN GAS','ABDULAZIZ ABDURRAHIM','08036253289','sagirmasudeljibril@gmail.com','KANO','KANO STATE','KURNA LAYIN GIDAN KARA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-04-02 16:59:37',5,'756','2022-04-02 16:59:37','756'),(29,'','1','219','SA\'A GASS','ABBA LONGER','09060246619','sagirmasudeljibril@gmail.com','KANO','KANO STATE','R/LEMO TITIN JAJIRA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-04-03 09:09:06',5,'756','2022-04-03 09:09:06','756'),(30,'','1','219','ALI GAS','ALIYU ABUBAKAR','09032394666','sagirmasudeljibril@gmail.com','KANO','KANO STATE','NASIRU AHLI,KURNA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-04-04 12:30:34',5,'756','2022-04-04 12:30:34','756'),(31,'','1','219','K.N GAS','BELLO GAS','07037059919','sagirmasudeljibril@gmail.com','KANO','KANO STATE','KURNA LAYIN GIDAN KARA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-04-04 17:10:18',5,'756','2022-04-04 17:10:18','756'),(32,'','1','219','UMAR GAS','UMAR IS\'HAQ','09037698844','sagirmasudeljibril@gmail.com','KANO','KANO STATE','MIL TARA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-04-11 12:20:06',5,'756','2022-04-11 12:20:06','756'),(33,'','1','219','NA KOWA ULTIMATE GAS','NURA MUSTAPHA','08081236482','sagirmasudeljibril@gmail.com','KANO','KANO STATE','DAN ZAGO STREAT,TUDUN FULANI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-04-13 09:05:30',5,'756','2022-04-13 09:05:30','756'),(34,'','1','219','HUSSAINI GAS','HUSSAINI DANDALAM','08061351820','bashiribrahim.bsuccess33@gmail','KANO','KANO STATE','DANDALAMA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-05-01 10:27:36',5,'756','2022-05-01 10:27:36','756'),(35,'','1','219','KOMAI DA RUWAN KA GAS','YUSIF USADA','08134260088','sagirmasudeljibril@gmail.com','KATSINA','KATSINA','SABON GARI BAKIN KASUWA,KATISINA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-05-11 08:18:50',5,'756','2022-05-11 08:18:50','756'),(36,'','1','219','UBAIYYU BIN KAAB GAS','MUHAMMAD ZINGINA','08035040521','bashiribrahim.bsuccess33@gmail','KANO','KANO STATE','BAGADAWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-05-16 08:02:01',5,'756','2022-05-16 08:02:01','756'),(37,'','1','219','AMAZONE GAS','SALISU ABUBAKAR','07041338407','sagirmasudeljibril@gmail.com','KANO','KANO STATE','RIJYAR LEMO,TITIN JAJIRA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-07-16 13:45:01',5,'756','2022-07-16 13:45:01','756'),(38,'','1','219','YES GAS AND POS','ABDURRAMAN SADIQ','07037779944','sagirmasudeljibril@gmail.com','KANO','KANO STATE','TITIN JAJIRA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-08-04 12:44:18',5,'756','2022-12-07 10:49:45','756'),(39,'','1','219','A.MALAM','A.MALAM','08092135690','sagirmasudeljibril@gmail.com','KANO','KANO STATE','KABUGA,TUDUN YOLA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-08-07 14:59:45',5,'756','2022-08-07 14:59:45','756'),(40,'','1','219','SHUKHRAN GAS','RABI\'U ABDULLAHI','09064484672','bashiribrahim.bsuccess33@gmail','KANO','KANO','RIJYAR LEMO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-09-16 17:06:23',5,'756','2022-09-16 17:06:23','756'),(41,'','1','219','BEST FREIND','ZAHARADDEEN ALIYU','08061288756','bashiribrahim.bsuccess33@gmail','KANO','KANO','RONI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-09-22 09:01:56',5,'756','2022-09-22 09:01:56','756'),(42,'','1','219','UMMUL BILAL GAS','BALA HARUNA','07038609651','bashiribrahim.bsuccess33@gmail','JIGAWA','JIGAWA STATE','RONI,KOFAR KUDU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-09-26 10:40:52',5,'756','2022-09-26 10:40:52','756'),(43,'','1','219','ALHERI GAS','HARUNA MUHAMMAD','07069230884','bashiribrahim.bsuccess33@gmail','KANO','KANO','\'YAN BABURA,RIJIYAR LEMO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-10-02 09:51:22',5,'756','2022-10-02 09:51:22','756'),(44,'','1','219','SARIM-K GAS','SHUA\'AIBU ABUBAKAR','08067717381','bashiribrahim.bsuccess33@gmail','KANO','KANO','RIMAYE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-10-03 11:35:00',5,'756','2022-10-03 11:35:00','756'),(45,'','1','219','LUDUFI GAS','ABDULHAMID SANI ABUBAKAR','08164845015','abdulsani@gmail.com','KANO','KANO','KURNA.LAYIN FALWAYA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-10-25 11:16:39',5,'756','2022-10-25 11:16:39','756'),(46,'','1','219','A A GAS','ALI AUWALU MUSA','07030794323','aliauwalumusa@gmail.com','KANO','KANO','R/LEMO T JAJIRA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-01-10 09:59:40',5,'756','2023-01-10 09:59:40','756'),(47,'','1','219','HUMAIRAH GAS','MUJITAFA ABDULLAHI','07042713149','mujitafahabdullahi@gmail.com','KANO','KANO','BACHIRAWA KWANAR MADUGU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-03-15 10:11:27',5,'756','2023-03-15 10:11:27','756');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','219','1',1,'5','LPG NOZZLE 1',128816.80,'','',NULL,NULL,'',5,'2022-02-25 15:06:22','483'),('1','219','1',2,'5','LPG NOZZLE 2',127521.87,'','',NULL,NULL,'',5,'2022-02-25 15:06:53','483'),('1','219','1',3,'5','LPG NOZZLE 3',20186.77,'','',NULL,NULL,'',5,'2022-02-25 15:07:21','483'),('1','219','1',4,'5','LPG NOZZLE 4',17005.85,'','',NULL,NULL,'',5,'2022-02-25 15:08:36','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=432 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','219',1,'DAILY SHIFTS','2022-02-26','2022-02-26 08:07:51','2022-02-27 08:07:51','756',0.00,0.00,'756','2022-02-26 22:40:42','756','2022-02-26 22:41:01',10,0),('1','219',2,'DAILY SHIFTS','2022-02-27','2022-02-27 07:19:57','2022-02-28 07:19:57','756',0.00,0.00,'756','2022-02-27 21:15:37','756','2022-02-27 21:15:53',10,0),('1','219',3,'DAILY SHIFTS','2022-02-22','2022-02-27 21:16:54','2022-02-28 21:16:54','756',0.00,0.00,'756','2022-02-27 21:20:27','756','2022-02-27 21:20:52',10,0),('1','219',4,'DAILY SHIFTS','2022-02-23','2022-02-27 21:21:18','2022-02-28 21:21:18','756',0.00,0.00,'756','2022-02-27 21:22:50','756','2022-02-27 21:23:45',10,0),('1','219',5,'DAILY SHIFTS','2022-02-24','2022-02-27 21:27:14','2022-02-28 21:27:14','756',0.00,0.00,'756','2022-02-27 21:35:44','756','2022-02-27 21:36:02',10,0),('1','219',6,'DAILY SHIFTS','2022-02-25','2022-02-27 21:36:35','2022-02-28 21:36:35','756',0.00,0.00,'756','2022-02-27 22:13:28','756','2022-02-27 22:13:50',10,0),('1','219',7,'DAILY SHIFTS','2022-02-28','2022-02-28 07:07:47','2022-03-01 07:07:47','756',0.00,0.00,'756','2022-02-28 22:52:08','756','2022-02-28 22:52:31',10,0),('1','219',8,'DAILY SHIFTS','2022-03-01','2022-03-01 07:01:06','2022-03-02 07:01:06','756',0.00,0.00,'756','2022-03-01 22:05:27','756','2022-03-01 22:05:52',10,0),('1','219',9,'DAILY SHIFTS','2022-03-02','2022-03-02 07:37:19','2022-03-03 07:37:19','756',0.00,0.00,'756','2022-03-02 21:38:51','756','2022-03-02 21:39:08',10,0),('1','219',10,'DAILY SHIFTS','2022-03-03','2022-03-03 07:25:00','2022-03-04 07:25:00','756',0.00,0.00,'756','2022-03-04 07:52:17','756','2022-03-04 07:52:40',10,0),('1','219',11,'DAILY SHIFTS','2022-03-04','2022-03-04 07:53:42','2022-03-05 07:53:42','756',0.00,0.00,'756','2022-03-05 07:52:56','756','2022-03-05 07:53:21',10,0),('1','219',12,'DAILY SHIFTS','2022-03-05','2022-03-05 07:54:47','2022-03-06 07:54:47','756',0.00,0.00,'756','2022-03-05 21:17:32','756','2022-03-05 21:17:55',10,0),('1','219',13,'DAILY SHIFTS','2022-03-06','2022-03-06 07:59:45','2022-03-07 07:59:45','756',0.00,0.00,'756','2022-03-07 07:24:11','756','2022-03-07 07:26:03',10,0),('1','219',14,'DAILY SHIFTS','2022-03-07','2022-03-07 07:26:31','2022-03-08 07:26:31','756',0.00,0.00,'756','2022-03-08 07:15:29','756','2022-03-08 07:15:47',10,0),('1','219',15,'DAILY SHIFTS','2022-03-08','2022-03-08 07:16:22','2022-03-09 07:16:22','756',0.00,0.00,'756','2022-03-08 20:36:27','756','2022-03-08 20:36:46',10,0),('1','219',16,'DAILY SHIFTS','2022-03-09','2022-03-09 07:21:41','2022-03-10 07:21:41','756',0.00,0.00,'756','2022-03-09 20:52:16','756','2022-03-09 20:52:34',10,0),('1','219',17,'DAILY SHIFTS','2022-03-10','2022-03-10 07:39:32','2022-03-11 07:39:32','756',0.00,0.00,'756','2022-03-10 15:32:09','756','2022-03-10 15:32:25',10,0),('1','219',18,'DAILY SHIFTS','2022-03-10','2022-03-10 15:47:54','2022-03-11 15:47:54','756',0.00,0.00,'756','2022-03-11 07:05:37','756','2022-03-11 07:05:57',10,0),('1','219',19,'DAILY SHIFTS','2022-03-11','2022-03-11 07:12:46','2022-03-12 07:12:46','756',0.00,0.00,'756','2022-03-11 22:57:42','756','2022-03-11 22:57:57',10,0),('1','219',20,'DAILY SHIFTS','2022-03-12','2022-03-12 06:19:56','2022-03-13 06:19:56','756',0.00,0.00,'756','2022-03-12 23:20:34','756','2022-03-12 23:20:51',10,0),('1','219',21,'DAILY SHIFTS','2022-03-13','2022-03-13 07:30:54','2022-03-14 07:30:54','756',0.00,0.00,'756','2022-03-14 06:25:20','756','2022-03-14 06:25:36',10,0),('1','219',22,'DAILY SHIFTS','2022-03-14','2022-03-14 06:25:55','2022-03-15 06:25:55','756',0.00,0.00,'756','2022-03-14 19:59:00','756','2022-03-14 19:59:16',10,0),('1','219',23,'DAILY SHIFTS','2022-03-15','2022-03-15 07:39:53','2022-03-16 07:39:53','756',0.00,0.00,'756','2022-03-16 07:29:04','756','2022-03-16 07:29:22',10,0),('1','219',24,'DAILY SHIFTS','2022-03-16','2022-03-16 07:29:46','2022-03-17 07:29:46','756',0.00,0.00,'756','2022-03-16 22:04:45','756','2022-03-16 22:05:01',10,0),('1','219',25,'DAILY SHIFTS','2022-03-17','2022-03-17 07:02:52','2022-03-18 07:02:52','756',0.00,0.00,'756','2022-03-17 17:58:11','756','2022-03-17 17:58:33',10,0),('1','219',26,'DAILY SHIFTS','2022-03-17','2022-03-17 18:12:30','2022-03-18 18:12:30','756',0.00,0.00,'756','2022-03-17 23:16:16','756','2022-03-17 23:16:39',10,0),('1','219',27,'DAILY SHIFTS','2022-03-18','2022-03-18 07:07:33','2022-03-19 07:07:33','756',0.00,0.00,'756','2022-03-18 22:32:39','756','2022-03-18 22:32:59',10,0),('1','219',28,'DAILY SHIFTS','2022-03-19','2022-03-19 07:42:14','2022-03-20 07:42:14','756',0.00,0.00,'756','2022-03-19 22:27:11','756','2022-03-19 22:27:26',10,0),('1','219',29,'DAILY SHIFTS','2022-03-20','2022-03-20 07:14:01','2022-03-21 07:14:01','756',0.00,0.00,'756','2022-03-20 22:05:04','756','2022-03-20 22:05:19',10,0),('1','219',30,'DAILY SHIFTS','2022-03-21','2022-03-21 08:07:40','2022-03-22 08:07:40','756',0.00,0.00,'756','2022-03-21 22:53:51','756','2022-03-21 22:54:15',10,0),('1','219',31,'DAILY SHIFTS','2022-03-22','2022-03-22 07:39:59','2022-03-23 07:39:59','756',0.00,0.00,'756','2022-03-22 22:26:07','756','2022-03-22 22:26:29',10,0),('1','219',32,'DAILY SHIFTS','2022-03-23','2022-03-23 07:51:41','2022-03-24 07:51:41','756',0.00,0.00,'756','2022-03-23 23:32:51','756','2022-03-23 23:33:06',10,0),('1','219',33,'DAILY SHIFTS','2022-03-24','2022-03-24 07:45:36','2022-03-25 07:45:36','756',0.00,0.00,'756','2022-03-24 23:29:02','756','2022-03-24 23:29:19',10,0),('1','219',34,'DAILY SHIFTS','2022-03-25','2022-03-25 07:29:35','2022-03-26 07:29:35','756',0.00,0.00,'756','2022-03-25 19:44:46','756','2022-03-25 19:45:04',10,0),('1','219',35,'DAILY SHIFTS','2022-03-26','2022-03-26 08:02:21','2022-03-27 08:02:21','756',0.00,0.00,'756','2022-03-26 23:34:12','756','2022-03-26 23:34:25',10,0),('1','219',36,'DAILY SHIFT','2022-03-27','2022-03-27 08:46:55','2022-03-28 08:46:55','756',0.00,0.00,'756','2022-03-27 19:20:27','756','2022-03-27 19:20:40',10,0),('1','219',37,'DAILY SHIFTS','2022-03-28','2022-03-28 08:00:05','2022-03-29 08:00:05','756',0.00,0.00,'756','2022-03-28 19:44:35','756','2022-03-28 19:44:49',10,0),('1','219',38,'DAILY SHIFT','2022-03-29','2022-03-29 07:52:30','2022-03-30 07:52:30','756',0.00,0.00,'756','2022-03-29 23:44:53','756','2022-03-29 23:45:11',10,0),('1','219',39,'DAILY SHIFTS','2022-03-30','2022-03-30 08:06:12','2022-03-31 08:06:12','756',0.00,0.00,'756','2022-03-30 22:26:00','756','2022-03-30 22:26:18',10,0),('1','219',40,'DAILY SHIFTS','2022-03-31','2022-03-31 06:07:59','2022-04-01 06:07:59','756',0.00,0.00,'756','2022-03-31 22:09:02','756','2022-03-31 22:09:18',10,0),('1','219',41,'DAILY SHIFTS','2022-04-01','2022-04-01 08:00:49','2022-04-02 08:00:49','756',0.00,0.00,'756','2022-04-01 15:46:10','756','2022-04-01 15:46:25',10,0),('1','219',42,'DAILY SHIFTS','2022-04-01','2022-04-01 16:41:21','2022-04-02 16:41:21','756',0.00,0.00,'756','2022-04-01 21:41:45','756','2022-04-01 21:42:01',10,0),('1','219',43,'DAILY SHIFT','2022-04-02','2022-04-02 07:29:46','2022-04-03 07:29:46','756',0.00,0.00,'756','2022-04-02 17:54:01','756','2022-04-02 17:54:16',10,0),('1','219',44,'DAILY SHIFTS','2022-04-02','2022-04-02 17:55:11','2022-04-03 17:55:11','756',0.00,0.00,'756','2022-04-02 23:26:17','756','2022-04-02 23:27:11',10,0),('1','219',45,'DAILY SHIFTS','2022-04-03','2022-04-03 07:27:37','2022-04-04 07:27:37','756',0.00,0.00,'756','2022-04-03 22:07:20','756','2022-04-03 22:07:34',10,0),('1','219',46,'DAILY SHIFT','2022-04-04','2022-04-04 07:19:54','2022-04-05 07:19:54','756',0.00,0.00,'756','2022-04-04 16:35:13','756','2022-04-04 16:35:26',10,0),('1','219',47,'DAILY SHIFTS','2022-04-04','2022-04-04 16:35:43','2022-04-05 16:35:43','756',0.00,0.00,'756','2022-04-04 22:23:59','756','2022-04-04 22:24:18',10,0),('1','219',48,'DAILY SHIFTS','2022-04-05','2022-04-05 08:15:46','2022-04-06 08:15:46','756',0.00,0.00,'756','2022-04-05 22:54:27','756','2022-04-05 22:54:42',10,0),('1','219',49,'DAILY SHIFT','2022-04-06','2022-04-06 07:26:32','2022-04-07 07:26:32','756',0.00,0.00,'756','2022-04-06 23:10:05','756','2022-04-06 23:10:23',10,0),('1','219',50,'DAILY SHIFTS','2022-04-07','2022-04-07 08:17:03','2022-04-08 08:17:03','756',0.00,0.00,'756','2022-04-07 22:21:54','756','2022-04-07 22:22:18',10,0),('1','219',51,'DAILY SHIFT','2022-04-08','2022-04-08 07:34:33','2022-04-09 07:34:33','756',0.00,0.00,'756','2022-04-08 21:20:12','756','2022-04-08 21:20:38',10,0),('1','219',52,'DAILY SHIFTS','2022-04-09','2022-04-09 07:43:58','2022-04-10 07:43:58','756',0.00,0.00,'756','2022-04-10 08:06:01','756','2022-04-10 08:09:53',10,0),('1','219',53,'DAILY SHIFT','2022-04-10','2022-04-10 08:10:41','2022-04-11 08:10:41','756',0.00,0.00,'756','2022-04-10 22:19:51','756','2022-04-10 22:20:15',10,0),('1','219',54,'DAILY SHIFTS','2022-04-11','2022-04-11 07:41:45','2022-04-12 07:41:45','756',0.00,0.00,'756','2022-04-12 07:31:13','756','2022-04-12 07:31:41',10,0),('1','219',55,'DAILY SHIFT','2022-04-12','2022-04-12 07:32:27','2022-04-13 07:32:27','756',0.00,0.00,'756','2022-04-13 07:10:27','756','2022-04-13 07:10:49',10,0),('1','219',56,'DAILY SHIFT','2022-04-13','2022-04-13 07:11:33','2022-04-14 07:11:33','756',0.00,0.00,'756','2022-04-13 23:45:53','756','2022-04-13 23:46:24',10,0),('1','219',57,'DAILY SHIFTS','2022-04-14','2022-04-14 05:25:38','2022-04-15 05:25:38','756',0.00,0.00,'756','2022-04-14 22:36:01','756','2022-04-14 22:36:15',10,0),('1','219',58,'DAILY SHIFT','2022-04-15','2022-04-15 07:16:25','2022-04-16 07:16:25','756',0.00,0.00,'756','2022-04-15 22:31:04','756','2022-04-15 22:32:04',10,0),('1','219',59,'DAILY SHIFTS','2022-04-16','2022-04-16 07:24:26','2022-04-17 07:24:26','756',0.00,0.00,'756','2022-04-16 22:59:32','756','2022-04-16 22:59:54',10,0),('1','219',60,'DAILY SHIFT','2022-04-17','2022-04-17 07:20:06','2022-04-18 07:20:06','756',0.00,0.00,'756','2022-04-17 14:06:42','756','2022-04-17 14:06:58',10,0),('1','219',61,'DAILY SHIFTS','2022-04-17','2022-04-17 14:07:18','2022-04-18 14:07:18','756',0.00,0.00,'756','2022-04-17 22:09:39','756','2022-04-17 22:10:06',10,0),('1','219',62,'DAILY SHIFTS','2022-04-18','2022-04-18 07:41:10','2022-04-19 07:41:10','756',0.00,0.00,'756','2022-04-18 23:40:44','756','2022-04-18 23:41:21',10,0),('1','219',63,'DAILY SHIFT','2022-04-19','2022-04-19 07:04:48','2022-04-20 07:04:48','756',0.00,0.00,'756','2022-04-19 20:05:59','756','2022-04-19 20:06:14',10,0),('1','219',64,'DAILY SHIFTS','2022-04-20','2022-04-20 08:12:03','2022-04-21 08:12:03','756',0.00,0.00,'756','2022-04-20 19:05:59','756','2022-04-20 19:06:14',10,0),('1','219',65,'DAILY SHIFT','2022-04-21','2022-04-21 06:55:53','2022-04-22 06:55:53','756',0.00,0.00,'756','2022-04-21 23:10:50','756','2022-04-21 23:11:12',10,0),('1','219',66,'DAILY SHIFTS','2022-04-22','2022-04-22 07:31:29','2022-04-23 07:31:29','756',0.00,0.00,'756','2022-04-22 23:54:59','756','2022-04-22 23:55:13',10,0),('1','219',67,'DAILY SHIFT','2022-04-23','2022-04-23 07:00:53','2022-04-24 07:00:53','756',0.00,0.00,'756','2022-04-24 00:01:33','756','2022-04-24 00:01:49',10,0),('1','219',68,'DAILY SHIFTS','2022-04-24','2022-04-24 07:24:50','2022-04-25 07:24:50','756',0.00,0.00,'756','2022-04-24 23:23:17','756','2022-04-24 23:23:32',10,0),('1','219',69,'DAILY SHIFT','2022-04-25','2022-04-25 07:10:28','2022-04-26 07:10:28','756',0.00,0.00,'756','2022-04-25 22:05:45','756','2022-04-25 22:05:59',10,0),('1','219',70,'DAILY SHIFTS','2022-04-26','2022-04-26 07:21:59','2022-04-27 07:21:59','756',0.00,0.00,'756','2022-04-27 00:15:38','756','2022-04-27 00:15:58',10,0),('1','219',71,'DAILY SHIFT','2022-04-27','2022-04-27 07:05:45','2022-04-28 07:05:45','756',0.00,0.00,'756','2022-04-27 23:00:14','756','2022-04-27 23:00:36',10,0),('1','219',72,'DAILY SHIFTS','2022-04-28','2022-04-28 07:22:59','2022-04-29 07:22:59','756',0.00,0.00,'756','2022-04-28 15:05:36','756','2022-04-28 15:05:50',10,0),('1','219',73,'DAILY SHIFTS','2022-04-28','2022-04-28 15:06:06','2022-04-29 15:06:06','756',0.00,0.00,'756','2022-04-29 05:29:54','756','2022-04-29 05:30:11',10,0),('1','219',74,'DAILY SHIFTS','2022-04-29','2022-04-29 05:30:27','2022-04-30 05:30:27','756',0.00,0.00,'756','2022-04-30 00:33:46','756','2022-04-30 00:34:04',10,0),('1','219',75,'DAILY SHIFTS','2022-04-30','2022-04-30 10:06:54','2022-05-01 10:06:54','756',0.00,0.00,'756','2022-04-30 23:31:00','756','2022-04-30 23:31:17',10,0),('1','219',76,'DAILY SHIFT','2022-05-01','2022-05-01 06:54:08','2022-05-02 06:54:08','756',0.00,0.00,'756','2022-05-01 22:44:01','756','2022-05-01 22:45:38',10,0),('1','219',77,'DAILY SHIFTS','2022-05-02','2022-05-02 09:53:40','2022-05-03 09:53:40','756',0.00,0.00,'756','2022-05-02 22:09:19','756','2022-05-02 22:09:38',10,0),('1','219',78,'DAILY SHIFT','2022-05-03','2022-05-03 06:59:44','2022-05-04 06:59:44','756',0.00,0.00,'756','2022-05-04 07:28:06','756','2022-05-04 07:30:43',10,0),('1','219',79,'DAILY SHIFTS','2022-05-04','2022-05-04 07:31:59','2022-05-05 07:31:59','756',0.00,0.00,'756','2022-05-04 21:03:57','756','2022-05-04 21:04:22',10,0),('1','219',80,'DAILY SHIFT','2022-05-05','2022-05-05 06:50:19','2022-05-06 06:50:19','756',0.00,0.00,'756','2022-05-06 00:06:55','756','2022-05-06 00:07:17',10,0),('1','219',81,'DAILY SHIFTS','2022-05-06','2022-05-06 07:22:04','2022-05-07 07:22:04','756',0.00,0.00,'756','2022-05-06 23:11:36','756','2022-05-06 23:11:55',10,0),('1','219',82,'DAILY SHIFT','2022-05-07','2022-05-07 06:58:26','2022-05-08 06:58:26','756',0.00,0.00,'756','2022-05-07 21:39:03','756','2022-05-07 21:39:18',10,0),('1','219',83,'DAILY SHIFTS','2022-05-08','2022-05-08 07:32:34','2022-05-09 07:32:34','756',0.00,0.00,'756','2022-05-08 16:29:00','756','2022-05-08 16:29:15',10,0),('1','219',84,'DAILY SHIFTS','2022-05-08','2022-05-08 16:29:33','2022-05-09 16:29:33','756',0.00,0.00,'756','2022-05-08 23:31:40','756','2022-05-08 23:31:57',10,0),('1','219',85,'DAILY SHIFT','2022-05-09','2022-05-09 07:02:00','2022-05-10 07:02:00','756',0.00,0.00,'756','2022-05-10 00:41:00','756','2022-05-10 00:41:18',10,0),('1','219',86,'DAILY SHIFTS','2022-05-10','2022-05-10 07:19:10','2022-05-11 07:19:10','756',0.00,0.00,'756','2022-05-11 00:49:01','756','2022-05-11 00:49:16',10,0),('1','219',87,'DAILY SHIFT','2022-05-11','2022-05-11 07:06:40','2022-05-12 07:06:40','756',0.00,0.00,'756','2022-05-11 23:42:01','756','2022-05-11 23:42:18',10,0),('1','219',88,'DAILY SHIFTS','2022-05-12','2022-05-12 07:21:16','2022-05-13 07:21:16','756',0.00,0.00,'756','2022-05-13 00:17:36','756','2022-05-13 00:17:52',10,0),('1','219',89,'DAILY SHIFT','2022-05-13','2022-05-13 07:06:56','2022-05-14 07:06:56','756',0.00,0.00,'756','2022-05-13 23:49:45','756','2022-05-13 23:50:10',10,0),('1','219',90,'DAILY SHIFTS','2022-05-14','2022-05-14 07:22:08','2022-05-15 07:22:08','756',0.00,0.00,'756','2022-05-14 23:50:56','756','2022-05-14 23:51:17',10,0),('1','219',91,'DAILY SHIFT','2022-05-15','2022-05-15 07:02:59','2022-05-16 07:02:59','756',0.00,0.00,'756','2022-05-16 00:05:46','756','2022-05-16 00:06:04',10,0),('1','219',92,'DAILY SHIFTS','2022-05-16','2022-05-16 07:46:11','2022-05-17 07:46:11','756',0.00,0.00,'756','2022-05-16 23:08:33','756','2022-05-16 23:08:50',10,0),('1','219',93,'DAILY SHIFT','2022-05-17','2022-05-17 07:06:39','2022-05-18 07:06:39','756',0.00,0.00,'756','2022-05-17 23:22:25','756','2022-05-17 23:22:57',10,0),('1','219',94,'DAILY SHIFTS','2022-05-18','2022-05-18 07:21:43','2022-05-19 07:21:43','756',0.00,0.00,'756','2022-05-18 23:08:51','756','2022-05-18 23:09:31',10,0),('1','219',95,'DAILY SHIFT','2022-05-19','2022-05-19 07:01:17','2022-05-20 07:01:17','756',0.00,0.00,'756','2022-05-19 22:30:08','756','2022-05-19 22:30:29',10,0),('1','219',96,'DAILY SHIFTS','2022-05-20','2022-05-20 07:30:16','2022-05-21 07:30:16','756',0.00,0.00,'756','2022-05-20 10:47:21','756','2022-05-20 10:48:17',10,0),('1','219',97,'DAILY SHIFTS','2022-05-20','2022-05-20 11:58:45','2022-05-21 11:58:45','756',0.00,0.00,'756','2022-05-21 00:14:23','756','2022-05-21 00:14:43',10,0),('1','219',98,'DAILY SHIFT','2022-05-21','2022-05-21 07:12:29','2022-05-22 07:12:29','756',0.00,0.00,'756','2022-05-21 10:15:43','756','2022-05-21 10:16:36',10,0),('1','219',99,'DAILY SHIFT','2022-05-21','2022-05-21 10:17:04','2022-05-22 10:17:04','756',0.00,0.00,'756','2022-05-21 23:12:20','756','2022-05-21 23:22:09',10,0),('1','219',100,'DAILY SHIFTS','2022-05-22','2022-05-22 11:16:33','2022-05-23 11:16:33','756',0.00,0.00,'756','2022-05-23 00:06:32','756','2022-05-23 00:06:49',10,0),('1','219',101,'DAILY SHIFT','2022-05-23','2022-05-23 07:24:04','2022-05-24 07:24:04','756',0.00,0.00,'756','2022-05-23 22:07:44','756','2022-05-23 22:08:10',10,0),('1','219',102,'DAILY SHIFTS','2022-05-24','2022-05-24 07:21:52','2022-05-25 07:21:52','756',0.00,0.00,'756','2022-05-24 23:23:57','756','2022-05-24 23:24:17',10,0),('1','219',103,'DAILY SHIFT','2022-05-25','2022-05-25 07:04:37','2022-05-26 07:04:37','756',0.00,0.00,'756','2022-05-26 00:19:59','756','2022-05-26 00:20:20',10,0),('1','219',104,'DAILY SHIFTS','2022-05-26','2022-05-26 07:10:08','2022-05-27 07:10:08','756',0.00,0.00,'756','2022-05-26 19:24:12','756','2022-05-26 19:25:17',10,0),('1','219',105,'DAILY SHIFT','2022-05-27','2022-05-27 07:01:09','2022-05-28 07:01:09','756',0.00,0.00,'756','2022-05-27 23:23:24','756','2022-05-27 23:24:04',10,0),('1','219',106,'DAILY SHIFTS','2022-05-28','2022-05-28 07:29:22','2022-05-29 07:29:22','756',0.00,0.00,'756','2022-05-29 00:09:18','756','2022-05-29 00:09:34',10,0),('1','219',107,'DAILY SHIFTS','2022-05-29','2022-05-29 06:03:11','2022-05-30 06:03:11','756',0.00,0.00,'756','2022-05-29 23:31:36','756','2022-05-29 23:31:55',10,0),('1','219',108,'DAILY SHIFTS','2022-05-30','2022-05-30 07:24:10','2022-05-31 07:24:10','756',0.00,0.00,'756','2022-05-30 23:13:50','756','2022-05-30 23:14:11',10,0),('1','219',109,'DAILY SHIFT','2022-05-31','2022-05-31 06:57:48','2022-06-01 06:57:48','756',0.00,0.00,'756','2022-05-31 22:31:56','756','2022-05-31 22:32:13',10,0),('1','219',110,'DAILY SHIFT','2022-06-01','2022-06-01 07:00:18','2022-06-02 07:00:18','756',0.00,0.00,'756','2022-06-01 23:18:37','756','2022-06-01 23:18:53',10,0),('1','219',111,'DAILY SHIFTS','2022-06-02','2022-06-02 07:17:07','2022-06-03 07:17:07','756',0.00,0.00,'756','2022-06-02 19:17:11','756','2022-06-02 19:17:31',10,0),('1','219',112,'DAILY SHIFT','2022-06-03','2022-06-03 07:18:55','2022-06-04 07:18:55','756',0.00,0.00,'756','2022-06-03 16:09:21','756','2022-06-03 16:09:41',10,0),('1','219',113,'DAILY SHIFTS','2022-06-03','2022-06-03 16:10:06','2022-06-04 16:10:06','756',0.00,0.00,'756','2022-06-03 19:22:49','756','2022-06-03 19:23:06',10,0),('1','219',114,'DAILY SHIFT','2022-06-04','2022-06-04 07:12:29','2022-06-05 07:12:29','756',0.00,0.00,'756','2022-06-04 21:55:47','756','2022-06-04 21:56:06',10,0),('1','219',115,'DAILY SHIFTS','2022-06-05','2022-06-05 07:34:59','2022-06-06 07:34:59','756',0.00,0.00,'756','2022-06-05 20:53:38','756','2022-06-05 20:54:01',10,0),('1','219',116,'DAILY SHIFT','2022-06-06','2022-06-06 07:07:54','2022-06-07 07:07:54','756',0.00,0.00,'756','2022-06-06 23:56:04','756','2022-06-06 23:56:24',10,0),('1','219',117,'DAILY SHIFTS','2022-06-07','2022-06-07 07:24:44','2022-06-08 07:24:44','756',0.00,0.00,'756','2022-06-08 07:33:18','756','2022-06-08 07:33:41',10,0),('1','219',118,'DAILY SHIFT','2022-06-08','2022-06-08 07:34:34','2022-06-09 07:34:34','756',0.00,0.00,'756','2022-06-08 22:02:40','756','2022-06-08 22:03:05',10,0),('1','219',119,'DAILY SHIFTS','2022-06-09','2022-06-09 07:11:36','2022-06-10 07:11:36','756',0.00,0.00,'756','2022-06-09 21:48:23','756','2022-06-09 21:48:46',10,0),('1','219',120,'DAILY SHIFT','2022-06-10','2022-06-10 06:56:48','2022-06-11 06:56:48','756',0.00,0.00,'756','2022-06-10 18:51:00','756','2022-06-10 18:51:14',10,0),('1','219',121,'DAILY SHIFTS','2022-06-11','2022-06-11 07:10:51','2022-06-12 07:10:51','756',0.00,0.00,'756','2022-06-11 19:01:26','756','2022-06-11 19:01:42',10,0),('1','219',122,'DAILY SHIFT','2022-06-12','2022-06-12 06:51:57','2022-06-13 06:51:57','756',0.00,0.00,'756','2022-06-12 19:12:10','756','2022-06-12 19:12:25',10,0),('1','219',123,'DAILY SHIFTS','2022-06-13','2022-06-13 07:22:02','2022-06-14 07:22:02','756',0.00,0.00,'756','2022-06-13 19:30:19','756','2022-06-13 19:30:35',10,0),('1','219',124,'DAILY SHIFTS','2022-06-14','2022-06-14 07:19:22','2022-06-15 07:19:22','756',0.00,0.00,'756','2022-06-14 23:01:16','756','2022-06-14 23:03:39',10,0),('1','219',125,'DAILY SHIFTS','2022-06-15','2022-06-15 07:09:42','2022-06-16 07:09:42','756',0.00,0.00,'756','2022-06-16 07:04:18','756','2022-06-16 07:05:18',10,0),('1','219',126,'DAILY SHIFT','2022-06-16','2022-06-16 07:06:21','2022-06-17 07:06:21','756',0.00,0.00,'756','2022-06-16 20:52:31','756','2022-06-16 20:52:47',10,0),('1','219',127,'DAILY SHIFTS','2022-06-17','2022-06-17 07:15:13','2022-06-18 07:15:13','756',0.00,0.00,'756','2022-06-17 18:01:46','756','2022-06-17 18:02:01',10,0),('1','219',128,'DAILY SHIFTS','2022-06-17','2022-06-17 18:02:20','2022-06-18 18:02:20','756',0.00,0.00,'756','2022-06-17 23:15:12','756','2022-06-17 23:15:36',10,0),('1','219',129,'DAILY SHIFT','2022-06-18','2022-06-18 06:57:30','2022-06-19 06:57:30','756',0.00,0.00,'756','2022-06-19 07:12:47','756','2022-06-19 07:13:44',10,0),('1','219',130,'DAILY SHIFTS','2022-06-19','2022-06-19 07:14:24','2022-06-20 07:14:24','756',0.00,0.00,'756','2022-06-19 19:33:01','756','2022-06-19 19:33:17',10,0),('1','219',131,'DAILY SHIFT','2022-06-20','2022-06-20 06:55:49','2022-06-21 06:55:49','756',0.00,0.00,'756','2022-06-20 22:38:35','756','2022-06-20 22:39:01',10,0),('1','219',132,'DAILY SHIFTS','2022-06-21','2022-06-21 07:09:24','2022-06-22 07:09:24','756',0.00,0.00,'756','2022-06-21 19:01:13','756','2022-06-21 19:01:28',10,0),('1','219',133,'DAILY SHIFT','2022-06-22','2022-06-22 06:55:12','2022-06-23 06:55:12','756',0.00,0.00,'756','2022-06-22 19:01:29','756','2022-06-22 19:01:42',10,0),('1','219',134,'DAILY SHIFTS','2022-06-23','2022-06-23 07:20:54','2022-06-24 07:20:54','756',0.00,0.00,'756','2022-06-23 23:08:20','756','2022-06-23 23:10:13',10,0),('1','219',135,'DAILY SHIFT','2022-06-24','2022-06-24 07:01:27','2022-06-25 07:01:27','756',0.00,0.00,'756','2022-06-24 19:29:28','756','2022-06-24 19:29:45',10,0),('1','219',136,'DAILY SHIFTS','2022-06-25','2022-06-25 07:52:00','2022-06-26 07:52:00','756',0.00,0.00,'756','2022-06-25 20:12:20','756','2022-06-25 20:12:39',10,0),('1','219',137,'DAILY SHIFT','2022-06-26','2022-06-26 07:52:25','2022-06-27 07:52:25','756',0.00,0.00,'756','2022-06-26 22:36:57','756','2022-06-26 22:37:12',10,0),('1','219',138,'DAILY SHIFTS','2022-06-27','2022-06-27 07:17:37','2022-06-28 07:17:37','756',0.00,0.00,'756','2022-06-27 19:35:37','756','2022-06-27 19:35:57',10,0),('1','219',139,'DAILY SHIFT','2022-06-28','2022-06-28 07:01:25','2022-06-29 07:01:25','756',0.00,0.00,'756','2022-06-28 19:45:40','756','2022-06-28 19:48:20',10,0),('1','219',140,'DAILY SHIFTS','2022-06-29','2022-06-29 07:37:37','2022-06-30 07:37:37','756',0.00,0.00,'756','2022-06-29 19:28:00','756','2022-06-29 19:28:13',10,0),('1','219',141,'DAILY SHIFT','2022-06-30','2022-06-30 07:04:28','2022-07-01 07:04:28','756',0.00,0.00,'756','2022-06-30 21:48:07','756','2022-06-30 21:48:28',10,0),('1','219',142,'DAILY SHIFTS','2022-07-01','2022-07-01 07:22:37','2022-07-02 07:22:37','756',0.00,0.00,'756','2022-07-01 17:45:34','756','2022-07-01 17:45:54',10,0),('1','219',143,'DAILY SHIFTS','2022-07-01','2022-07-01 17:46:22','2022-07-02 17:46:22','756',0.00,0.00,'756','2022-07-01 21:38:44','756','2022-07-01 21:39:03',10,0),('1','219',144,'DAILY SHIFT','2022-07-02','2022-07-02 06:56:51','2022-07-03 06:56:51','756',0.00,0.00,'756','2022-07-02 21:27:10','756','2022-07-02 21:28:02',10,0),('1','219',145,'DAILY SHIFTS','2022-07-03','2022-07-03 07:39:16','2022-07-04 07:39:16','756',0.00,0.00,'756','2022-07-04 00:49:54','756','2022-07-04 00:50:10',10,0),('1','219',146,'DAILY SHIFT','2022-07-04','2022-07-04 07:08:54','2022-07-05 07:08:54','756',0.00,0.00,'756','2022-07-04 19:33:43','756','2022-07-04 19:34:07',10,0),('1','219',147,'DAILY SHIFTS','2022-07-05','2022-07-05 07:26:57','2022-07-06 07:26:57','756',0.00,0.00,'756','2022-07-05 19:31:50','756','2022-07-05 19:32:20',10,0),('1','219',148,'DAILY SHIFT','2022-07-06','2022-07-06 07:04:27','2022-07-07 07:04:27','756',0.00,0.00,'756','2022-07-06 23:18:28','756','2022-07-06 23:18:53',10,0),('1','219',149,'DAILY SHIFTS','2022-07-07','2022-07-07 07:28:32','2022-07-08 07:28:32','756',0.00,0.00,'756','2022-07-07 21:32:57','756','2022-07-07 21:33:15',10,0),('1','219',150,'DAILY SHIFT','2022-07-08','2022-07-08 07:01:19','2022-07-09 07:01:19','756',0.00,0.00,'756','2022-07-08 22:16:30','756','2022-07-08 22:16:47',10,0),('1','219',151,'Daily shift','2022-07-09','2022-07-09 09:19:55','2022-07-10 09:19:55','756',0.00,0.00,'756','2022-07-10 07:00:48','756','2022-07-10 07:01:16',10,0),('1','219',152,'DAILY SHIFT','2022-07-10','2022-07-10 07:01:44','2022-07-11 07:01:44','756',0.00,0.00,'756','2022-07-10 19:45:03','756','2022-07-10 19:45:31',10,0),('1','219',153,'DAILY SHIFTS','2022-07-11','2022-07-11 07:55:36','2022-07-12 07:55:36','756',0.00,0.00,'756','2022-07-11 19:55:57','756','2022-07-11 19:56:12',10,0),('1','219',154,'DAILY SHIFT','2022-07-12','2022-07-12 07:03:31','2022-07-13 07:03:31','756',0.00,0.00,'756','2022-07-12 20:19:14','756','2022-07-12 20:19:31',10,0),('1','219',155,'DAILY SHIFTS','2022-07-13','2022-07-13 07:38:03','2022-07-14 07:38:03','756',0.00,0.00,'756','2022-07-13 21:05:58','756','2022-07-13 21:06:15',10,0),('1','219',156,'DAILY SHIFT','2022-07-14','2022-07-14 06:58:52','2022-07-15 06:58:52','756',0.00,0.00,'756','2022-07-14 15:04:14','756','2022-07-14 15:04:38',10,0),('1','219',157,'DAILY SHIFTS','2022-07-14','2022-07-14 15:06:00','2022-07-15 15:06:00','756',0.00,0.00,'756','2022-07-15 07:39:52','756','2022-07-15 07:40:33',10,0),('1','219',158,'DAILY SHIFTS','2022-07-15','2022-07-15 07:41:21','2022-07-16 07:41:21','756',0.00,0.00,'756','2022-07-15 22:36:03','756','2022-07-15 22:36:25',10,0),('1','219',159,'DAILY SHIFT','2022-07-16','2022-07-16 07:03:24','2022-07-17 07:03:24','756',0.00,0.00,'756','2022-07-16 23:07:52','756','2022-07-16 23:08:19',10,0),('1','219',160,'DAILY SHIFTS','2022-07-17','2022-07-17 07:20:38','2022-07-18 07:20:38','756',0.00,0.00,'756','2022-07-18 08:08:41','756','2022-07-18 08:09:03',10,0),('1','219',161,'DAILY SHIFT','2022-07-18','2022-07-18 08:09:36','2022-07-19 08:09:36','756',0.00,0.00,'756','2022-07-18 19:32:50','756','2022-07-18 19:33:17',10,0),('1','219',162,'DAILY SHIFTS','2022-07-19','2022-07-19 07:31:39','2022-07-20 07:31:39','756',0.00,0.00,'756','2022-07-19 23:51:53','756','2022-07-19 23:52:16',10,0),('1','219',163,'DAILY SHIFT','2022-07-20','2022-07-20 07:03:57','2022-07-21 07:03:57','756',0.00,0.00,'756','2022-07-20 19:37:25','756','2022-07-20 19:37:49',10,0),('1','219',164,'DAILY SHIFT','2022-07-21','2022-07-21 06:37:54','2022-07-22 06:37:54','756',0.00,0.00,'756','2022-07-21 23:46:04','756','2022-07-21 23:46:20',10,0),('1','219',165,'DAILY SHIFT','2022-07-22','2022-07-22 07:00:48','2022-07-23 07:00:48','756',0.00,0.00,'756','2022-07-22 16:03:41','756','2022-07-22 16:03:58',10,0),('1','219',166,'Daily shift','2022-07-22','2022-07-22 16:04:36','2022-07-23 16:04:36','756',0.00,0.00,'756','2022-07-22 23:22:30','756','2022-07-22 23:22:47',10,0),('1','219',167,'DAILY SHIFTS','2022-07-23','2022-07-23 07:27:27','2022-07-24 07:27:27','756',0.00,0.00,'756','2022-07-23 21:47:10','756','2022-07-23 21:47:25',10,0),('1','219',168,'DAILY SHIFT','2022-07-24','2022-07-24 07:12:05','2022-07-25 07:12:05','756',0.00,0.00,'756','2022-07-24 20:16:19','756','2022-07-24 20:16:34',10,0),('1','219',169,'DAILY SHIFTS','2022-07-25','2022-07-25 07:32:22','2022-07-26 07:32:22','756',0.00,0.00,'756','2022-07-25 20:27:19','756','2022-07-25 20:27:42',10,0),('1','219',170,'DAILY SHIFT','2022-07-26','2022-07-26 07:07:01','2022-07-27 07:07:01','756',0.00,0.00,'756','2022-07-26 20:31:13','756','2022-07-26 20:31:28',10,0),('1','219',171,'DAILY SHIFTS','2022-07-27','2022-07-27 07:29:05','2022-07-28 07:29:05','756',0.00,0.00,'756','2022-07-27 19:39:54','756','2022-07-27 19:40:27',10,0),('1','219',172,'DAILY SHIFTS','2022-07-28','2022-07-28 07:22:12','2022-07-29 07:22:12','756',0.00,0.00,'756','2022-07-29 05:53:15','756','2022-07-29 05:53:32',10,0),('1','219',173,'DAILY SHIFT','2022-07-29','2022-07-29 07:19:05','2022-07-30 07:19:05','756',0.00,0.00,'756','2022-07-29 19:25:30','756','2022-07-29 22:07:24',10,0),('1','219',174,'Daily shift','2022-07-30','2022-07-30 10:06:46','2022-07-31 10:06:46','756',0.00,0.00,'756','2022-07-30 21:33:41','756','2022-07-30 21:34:00',10,0),('1','219',175,'DAILY SHIFTS','2022-07-31','2022-07-31 08:15:39','2022-08-01 08:15:39','756',0.00,0.00,'756','2022-07-31 19:21:43','756','2022-07-31 19:22:17',10,0),('1','219',176,'DAILY SHIFT','2022-08-01','2022-08-01 06:59:07','2022-08-02 06:59:07','756',0.00,0.00,'756','2022-08-01 18:45:21','756','2022-08-01 18:45:41',10,0),('1','219',177,'DAILY SHIFTS','2022-08-02','2022-08-02 07:34:02','2022-08-03 07:34:02','756',0.00,0.00,'756','2022-08-02 15:23:25','756','2022-08-02 15:24:21',10,0),('1','219',178,'DAILY SHIFT','2022-08-03','2022-08-03 07:07:17','2022-08-04 07:07:17','756',0.00,0.00,'756','2022-08-03 18:55:19','756','2022-08-03 18:56:21',10,0),('1','219',179,'DAILY SHIFTS','2022-08-04','2022-08-04 07:29:52','2022-08-05 07:29:52','756',0.00,0.00,'756','2022-08-04 19:05:02','756','2022-08-04 19:05:53',10,0),('1','219',180,'DAILY SHIFT','2022-08-05','2022-08-05 07:05:50','2022-08-06 07:05:50','756',0.00,0.00,'756','2022-08-05 18:29:39','756','2022-08-05 18:31:06',10,0),('1','219',181,'DAILY SHIFTS','2022-08-06','2022-08-06 07:26:23','2022-08-07 07:26:23','756',0.00,0.00,'756','2022-08-06 20:07:06','756','2022-08-06 20:07:43',10,0),('1','219',182,'DAILY SHIFT','2022-08-07','2022-08-07 07:05:45','2022-08-08 07:05:45','756',0.00,0.00,'756','2022-08-07 18:46:52','756','2022-08-07 18:47:15',10,0),('1','219',183,'DAILY SHIFTS','2022-08-08','2022-08-08 07:13:26','2022-08-09 07:13:26','756',0.00,0.00,'756','2022-08-08 18:20:47','756','2022-08-08 18:21:25',10,0),('1','219',184,'DAILY SHIFT','2022-08-09','2022-08-09 07:00:46','2022-08-10 07:00:46','756',0.00,0.00,'756','2022-08-09 21:16:09','756','2022-08-09 21:16:50',10,0),('1','219',185,'DAILY SHIFTS','2022-08-10','2022-08-10 07:17:16','2022-08-11 07:17:16','756',0.00,0.00,'756','2022-08-10 21:49:48','756','2022-08-10 21:50:08',10,0),('1','219',186,'DAILY SHIFT','2022-08-11','2022-08-11 07:55:45','2022-08-12 07:55:45','756',0.00,0.00,'756','2022-08-11 18:20:08','756','2022-08-11 18:20:54',10,0),('1','219',187,'DAILY SHIFTS','2022-08-12','2022-08-12 07:19:20','2022-08-13 07:19:20','756',0.00,0.00,'756','2022-08-12 17:20:50','756','2022-08-12 17:21:13',10,0),('1','219',188,'DAILY SHIFT','2022-08-13','2022-08-13 07:13:04','2022-08-14 07:13:04','756',0.00,0.00,'756','2022-08-13 18:50:44','756','2022-08-13 18:51:05',10,0),('1','219',189,'DAILY SHIFTS','2022-08-14','2022-08-14 07:19:13','2022-08-15 07:19:13','756',0.00,0.00,'756','2022-08-14 18:36:14','756','2022-08-14 18:36:52',10,0),('1','219',190,'DAILY SHIFTS','2022-08-15','2022-08-15 07:07:52','2022-08-16 07:07:52','756',0.00,0.00,'756','2022-08-15 19:00:47','756','2022-08-15 19:01:09',10,0),('1','219',191,'DAILY SHIFTS','2022-08-16','2022-08-16 07:28:41','2022-08-17 07:28:41','756',0.00,0.00,'756','2022-08-16 19:38:59','756','2022-08-16 19:39:21',10,0),('1','219',192,'DAILY SHIFTS','2022-08-17','2022-08-17 07:05:52','2022-08-18 07:05:52','756',0.00,0.00,'756','2022-08-17 21:56:59','756','2022-08-17 21:57:37',10,0),('1','219',193,'DAILY SHIFTS','2022-08-18','2022-08-18 07:15:23','2022-08-19 07:15:23','756',0.00,0.00,'756','2022-08-18 19:26:49','756','2022-08-18 19:27:19',10,0),('1','219',194,'DAILY SHIFTS','2022-08-19','2022-08-19 07:12:45','2022-08-20 07:12:45','756',0.00,0.00,'756','2022-08-19 18:45:41','756','2022-08-19 18:46:09',10,0),('1','219',195,'DAILY SHIFTS','2022-08-20','2022-08-20 07:12:08','2022-08-21 07:12:08','756',0.00,0.00,'756','2022-08-20 18:36:35','756','2022-08-20 18:37:30',10,0),('1','219',196,'DAILY SHIFTS','2022-08-21','2022-08-21 07:09:29','2022-08-22 07:09:29','756',0.00,0.00,'756','2022-08-21 19:36:42','756','2022-08-21 19:36:59',10,0),('1','219',197,'DAILY SHIFTS','2022-08-22','2022-08-22 07:19:09','2022-08-23 07:19:09','756',0.00,0.00,'756','2022-08-22 20:11:17','756','2022-08-22 20:11:41',10,0),('1','219',198,'DAILY SHIFTS','2022-08-23','2022-08-23 07:12:37','2022-08-24 07:12:37','756',0.00,0.00,'756','2022-08-23 18:16:58','756','2022-08-23 18:17:17',10,0),('1','219',199,'DAILY SHIFTS','2022-08-24','2022-08-24 07:16:26','2022-08-25 07:16:26','756',0.00,0.00,'756','2022-08-24 19:24:37','756','2022-08-24 19:25:09',10,0),('1','219',200,'DAILY SHIFTS','2022-08-25','2022-08-25 07:54:43','2022-08-26 07:54:43','756',0.00,0.00,'756','2022-08-25 18:16:59','756','2022-08-25 18:17:21',10,0),('1','219',201,'DAILY SHIFTS','2022-08-26','2022-08-26 07:21:07','2022-08-27 07:21:07','756',0.00,0.00,'756','2022-08-26 19:37:50','756','2022-08-26 19:38:27',10,0),('1','219',202,'DAILY SHIFTS','2022-08-27','2022-08-27 09:43:32','2022-08-28 09:43:32','756',0.00,0.00,'756','2022-08-27 21:41:02','756','2022-08-27 21:41:27',10,0),('1','219',203,'DAILY SHIFTS','2022-08-28','2022-08-28 07:23:55','2022-08-29 07:23:55','756',0.00,0.00,'756','2022-08-28 20:34:06','756','2022-08-28 20:34:30',10,0),('1','219',204,'DAILY SHIFTS','2022-08-29','2022-08-29 07:11:16','2022-08-30 07:11:16','756',0.00,0.00,'756','2022-08-29 16:33:21','756','2022-08-29 16:33:41',10,0),('1','219',205,'DAILY SHIFTS','2022-08-29','2022-08-29 17:14:27','2022-08-30 17:14:27','756',0.00,0.00,'756','2022-08-29 17:25:10','756','2022-08-29 17:25:32',10,0),('1','219',206,'DAILY SHIFTS','2022-08-30','2022-08-30 07:12:34','2022-08-31 07:12:34','756',0.00,0.00,'756','2022-08-30 18:49:05','756','2022-08-30 18:49:24',10,0),('1','219',207,'DAILY SHIFTS','2022-08-31','2022-08-31 07:05:55','2022-09-01 07:05:55','756',0.00,0.00,'756','2022-08-31 19:18:15','756','2022-08-31 19:18:37',10,0),('1','219',208,'DAILY SHIFTS','2022-09-01','2022-09-01 07:21:59','2022-09-02 07:21:59','756',0.00,0.00,'756','2022-09-01 18:12:42','756','2022-09-01 18:13:00',10,0),('1','219',209,'DAILY SHIFTS','2022-09-02','2022-09-02 07:12:01','2022-09-03 07:12:01','756',0.00,0.00,'756','2022-09-02 21:59:44','756','2022-09-02 22:00:08',10,0),('1','219',210,'DAILY SHIFTS','2022-09-03','2022-09-03 07:20:12','2022-09-04 07:20:12','756',0.00,0.00,'756','2022-09-03 13:40:17','756','2022-09-03 13:40:35',10,0),('1','219',211,'DAILY SHIFTS','2022-09-03','2022-09-03 13:52:20','2022-09-04 13:52:20','756',0.00,0.00,'756','2022-09-03 19:11:41','756','2022-09-03 19:12:03',10,0),('1','219',212,'DAILY SHIFTS','2022-09-04','2022-09-04 07:11:04','2022-09-05 07:11:04','756',0.00,0.00,'756','2022-09-04 19:39:17','756','2022-09-04 19:39:47',10,0),('1','219',213,'DAILY SHIFTS','2022-09-05','2022-09-05 07:11:05','2022-09-06 07:11:05','756',0.00,0.00,'756','2022-09-05 18:44:45','756','2022-09-05 18:47:21',10,0),('1','219',214,'DAILY SHIFTS','2022-09-06','2022-09-06 07:11:38','2022-09-07 07:11:38','756',0.00,0.00,'756','2022-09-06 18:43:58','756','2022-09-06 18:44:30',10,0),('1','219',215,'DAILY SHIFTS','2022-09-07','2022-09-07 07:15:46','2022-09-08 07:15:46','756',0.00,0.00,'756','2022-09-07 17:54:57','756','2022-09-07 17:55:20',10,0),('1','219',216,'DAILY SHIFTS','2022-09-08','2022-09-08 07:04:48','2022-09-09 07:04:48','756',0.00,0.00,'756','2022-09-08 19:30:22','756','2022-09-08 19:30:45',10,0),('1','219',217,'DAILY SHIFTS','2022-09-09','2022-09-09 07:19:32','2022-09-10 07:19:32','756',0.00,0.00,'756','2022-09-09 19:06:34','756','2022-09-09 19:07:08',10,0),('1','219',218,'DAILY SHIFTS','2022-09-10','2022-09-10 07:11:05','2022-09-11 07:11:05','756',0.00,0.00,'756','2022-09-10 18:53:13','756','2022-09-10 18:53:37',10,0),('1','219',219,'DAILY SHIFTS','2022-09-11','2022-09-11 07:15:44','2022-09-12 07:15:44','756',0.00,0.00,'756','2022-09-11 15:13:31','756','2022-09-11 15:13:55',10,0),('1','219',220,'DAILY SHIFTS','2022-09-12','2022-09-12 07:05:04','2022-09-13 07:05:04','756',0.00,0.00,'756','2022-09-12 20:35:51','756','2022-09-12 20:36:31',10,0),('1','219',221,'DAILY SHIFTS','2022-09-13','2022-09-13 07:13:00','2022-09-14 07:13:00','756',0.00,0.00,'756','2022-09-13 21:32:26','756','2022-09-13 21:32:49',10,0),('1','219',222,'DAILY SHIFTS','2022-09-14','2022-09-14 07:12:43','2022-09-15 07:12:43','756',0.00,0.00,'756','2022-09-14 16:58:42','756','2022-09-14 16:59:01',10,0),('1','219',223,'DAILY SHIFTS','2022-09-15','2022-09-15 07:10:30','2022-09-16 07:10:30','756',0.00,0.00,'756','2022-09-15 22:22:31','756','2022-09-15 22:23:22',10,0),('1','219',224,'DAILY SHIFTS','2022-09-16','2022-09-16 07:23:42','2022-09-17 07:23:42','756',0.00,0.00,'756','2022-09-16 22:59:01','756','2022-09-16 22:59:32',10,0),('1','219',225,'DAILY SHIFTS','2022-09-17','2022-09-17 07:30:44','2022-09-18 07:30:44','756',0.00,0.00,'756','2022-09-17 19:12:56','756','2022-09-17 19:13:14',10,0),('1','219',226,'DAILY SHIFTS','2022-09-18','2022-09-18 07:18:28','2022-09-19 07:18:28','756',0.00,0.00,'756','2022-09-18 20:14:27','756','2022-09-18 20:14:57',10,0),('1','219',227,'DAILY SHIFTS','2022-09-19','2022-09-19 07:25:51','2022-09-20 07:25:51','756',0.00,0.00,'756','2022-09-19 20:33:03','756','2022-09-19 20:33:28',10,0),('1','219',228,'DAILY SHIFTS','2022-09-20','2022-09-20 07:32:59','2022-09-21 07:32:59','756',0.00,0.00,'756','2022-09-20 10:58:22','756','2022-09-20 10:58:43',10,0),('1','219',229,'DAILY SHIFTS','2022-09-21','2022-09-21 07:35:58','2022-09-22 07:35:58','756',0.00,0.00,'756','2022-09-21 19:09:14','756','2022-09-21 19:18:32',10,0),('1','219',230,'DAILY SHIFTS','2022-09-22','2022-09-22 07:06:20','2022-09-23 07:06:20','756',0.00,0.00,'756','2022-09-22 18:29:11','756','2022-09-22 18:29:34',10,0),('1','219',231,'DAILY SHIFTS','2022-09-23','2022-09-23 08:32:42','2022-09-24 08:32:42','756',0.00,0.00,'756','2022-09-23 19:08:46','756','2022-09-23 19:09:07',10,0),('1','219',232,'DAILY SHIFTS','2022-09-24','2022-09-24 09:45:23','2022-09-25 09:45:23','756',0.00,0.00,'756','2022-09-24 18:45:47','756','2022-09-24 18:46:24',10,0),('1','219',233,'DAILY SHIFTS','2022-09-25','2022-09-25 07:16:58','2022-09-26 07:16:58','756',0.00,0.00,'756','2022-09-25 19:23:41','756','2022-09-25 19:24:19',10,0),('1','219',234,'DAILY SHIFTS','2022-09-26','2022-09-26 07:06:17','2022-09-27 07:06:17','756',0.00,0.00,'756','2022-09-26 19:28:28','756','2022-09-26 19:28:47',10,0),('1','219',235,'DAILY SHIFTS','2022-09-27','2022-09-27 08:26:01','2022-09-28 08:26:01','756',0.00,0.00,'756','2022-09-27 18:33:12','756','2022-09-27 18:33:32',10,0),('1','219',236,'DAILY SHIFTS','2022-09-28','2022-09-28 07:14:46','2022-09-29 07:14:46','756',0.00,0.00,'756','2022-09-28 17:40:52','756','2022-09-28 17:42:40',10,0),('1','219',237,'DAILY SHIFTS','2022-09-29','2022-09-29 08:01:37','2022-09-30 08:01:37','756',0.00,0.00,'756','2022-09-29 19:09:02','756','2022-09-29 19:09:20',10,0),('1','219',238,'DAILY SHIFTS','2022-09-30','2022-09-30 07:12:14','2022-10-01 07:12:14','756',0.00,0.00,'756','2022-09-30 19:09:28','756','2022-09-30 19:09:53',10,0),('1','219',239,'DAILY SHIFTS','2022-10-01','2022-10-01 07:12:19','2022-10-02 07:12:19','756',0.00,0.00,'756','2022-10-01 18:56:55','756','2022-10-01 18:57:22',10,0),('1','219',240,'DAILY SHIFTS','2022-10-02','2022-10-02 07:14:04','2022-10-03 07:14:04','756',0.00,0.00,'756','2022-10-02 13:21:26','756','2022-10-02 13:21:47',10,0),('1','219',241,'DAILY SHIFTS','2022-10-02','2022-10-02 13:23:19','2022-10-03 13:23:19','756',0.00,0.00,'756','2022-10-02 17:50:25','756','2022-10-02 17:50:44',10,0),('1','219',242,'DAILY SHIFTS','2022-10-03','2022-10-03 07:12:48','2022-10-04 07:12:48','756',0.00,0.00,'756','2022-10-03 13:14:11','756','2022-10-03 13:14:29',10,0),('1','219',243,'DAILY SHIFTS','2022-10-03','2022-10-03 13:15:36','2022-10-04 13:15:36','756',0.00,0.00,'756','2022-10-03 18:48:19','756','2022-10-03 18:48:41',10,0),('1','219',244,'DAILY SHIFTS','2022-10-04','2022-10-04 07:14:28','2022-10-05 07:14:28','756',0.00,0.00,'756','2022-10-04 13:32:22','756','2022-10-04 13:33:29',10,0),('1','219',245,'DAILY SHIFTS','2022-10-05','2022-10-05 12:05:08','2022-10-06 12:05:08','756',0.00,0.00,'756','2022-10-05 18:09:20','756','2022-10-05 18:09:46',10,0),('1','219',246,'DAILY SHIFTS','2022-10-06','2022-10-06 07:12:32','2022-10-07 07:12:32','756',0.00,0.00,'756','2022-10-06 18:43:09','756','2022-10-06 18:43:40',10,0),('1','219',247,'DAILY SHIFTS','2022-10-07','2022-10-07 07:15:43','2022-10-08 07:15:43','756',0.00,0.00,'756','2022-10-07 18:35:42','756','2022-10-07 18:37:04',10,0),('1','219',248,'DAILY SHIFTS','2022-10-07','2022-10-07 18:57:55','2022-10-08 18:57:55','756',0.00,0.00,'756','2022-10-07 19:03:29','756','2022-10-07 19:03:51',10,0),('1','219',249,'DAILY SHIFTS','2022-10-08','2022-10-08 07:13:16','2022-10-09 07:13:16','756',0.00,0.00,'756','2022-10-08 18:43:18','756','2022-10-08 18:43:58',10,0),('1','219',250,'DAILY','2022-10-09','2022-10-09 07:25:58','2022-10-10 07:25:58','756',0.00,0.00,'756','2022-10-09 21:01:31','756','2022-10-09 21:02:07',10,0),('1','219',251,'DAILY','2022-10-10','2022-10-10 07:20:30','2022-10-11 07:20:30','756',0.00,0.00,'756','2022-10-10 18:45:29','756','2022-10-10 18:45:53',10,0),('1','219',252,'DAILY','2022-10-11','2022-10-11 07:35:55','2022-10-12 07:35:55','756',0.00,0.00,'756','2022-10-11 18:42:03','756','2022-10-11 18:43:00',10,0),('1','219',253,'DAILY','2022-10-12','2022-10-12 07:11:44','2022-10-13 07:11:44','756',0.00,0.00,'756','2022-10-12 21:30:15','756','2022-10-12 21:30:47',10,0),('1','219',254,'DAILY','2022-10-13','2022-10-13 07:08:08','2022-10-14 07:08:08','756',0.00,0.00,'756','2022-10-13 19:18:50','756','2022-10-13 19:19:09',10,0),('1','219',255,'DAILY','2022-10-14','2022-10-14 07:11:43','2022-10-15 07:11:43','756',0.00,0.00,'756','2022-10-14 18:09:13','756','2022-10-14 18:09:36',10,0),('1','219',256,'DAILY','2022-10-15','2022-10-15 07:26:34','2022-10-16 07:26:34','756',0.00,0.00,'756','2022-10-15 18:10:57','756','2022-10-15 18:11:16',10,0),('1','219',257,'DAILY','2022-10-16','2022-10-16 07:17:27','2022-10-17 07:17:27','756',0.00,0.00,'756','2022-10-16 15:14:58','756','2022-10-16 15:15:43',10,0),('1','219',258,'DAILY SHIFTS','2022-10-16','2022-10-16 15:34:35','2022-10-17 15:34:35','756',0.00,0.00,'756','2022-10-16 18:37:16','756','2022-10-16 18:37:36',10,0),('1','219',259,'DAILY','2022-10-17','2022-10-17 07:08:40','2022-10-18 07:08:40','756',0.00,0.00,'756','2022-10-17 18:14:57','756','2022-10-17 18:15:16',10,0),('1','219',260,'DAILY SHIFTS','2022-10-18','2022-10-18 07:22:40','2022-10-19 07:22:40','756',0.00,0.00,'756','2022-10-18 19:17:11','756','2022-10-18 19:17:36',10,0),('1','219',261,'DAILY','2022-10-19','2022-10-19 07:19:00','2022-10-20 07:19:00','756',0.00,0.00,'756','2022-10-19 21:55:53','756','2022-10-19 21:56:15',10,0),('1','219',262,'DAILY SHIFTS','2022-10-20','2022-10-20 07:15:19','2022-10-21 07:15:19','756',0.00,0.00,'756','2022-10-20 21:41:30','756','2022-10-20 21:41:49',10,0),('1','219',263,'DAILY','2022-10-21','2022-10-21 07:19:18','2022-10-22 07:19:18','756',0.00,0.00,'756','2022-10-21 21:32:49','756','2022-10-21 21:33:34',10,0),('1','219',264,'DAILY SHIFTS','2022-10-23','2022-10-23 09:44:09','2022-10-24 09:44:09','756',0.00,0.00,'756','2022-10-23 09:57:33','756','2022-10-23 09:57:52',10,0),('1','219',265,'DAILY SHIFTS','2022-10-23','2022-10-23 10:07:04','2022-10-24 10:07:04','756',0.00,0.00,'756','2022-10-23 21:46:42','756','2022-10-23 21:47:13',10,0),('1','219',266,'DAILY SHIFTS','2022-10-24','2022-10-24 07:14:52','2022-10-25 07:14:52','756',0.00,0.00,'756','2022-10-24 20:06:46','756','2022-10-24 20:07:50',10,0),('1','219',267,'DAILY','2022-10-25','2022-10-25 07:19:13','2022-10-26 07:19:13','756',0.00,0.00,'756','2022-10-25 20:16:56','756','2022-10-25 20:17:29',10,0),('1','219',268,'DAILY SHIFTS','2022-10-26','2022-10-26 07:38:30','2022-10-27 07:38:30','756',0.00,0.00,'756','2022-10-26 20:56:28','756','2022-10-26 20:56:56',10,0),('1','219',269,'DAILY','2022-10-27','2022-10-27 07:30:28','2022-10-28 07:30:28','756',0.00,0.00,'756','2022-10-27 13:50:28','756','2022-10-27 13:51:06',10,0),('1','219',270,'DAILY SHIFTS','2022-10-27','2022-10-27 15:56:50','2022-10-28 15:56:50','756',0.00,0.00,'756','2022-10-27 20:35:28','756','2022-10-27 20:36:04',10,0),('1','219',271,'DAILY SHIFTS','2022-10-28','2022-10-28 06:45:13','2022-10-29 06:45:13','756',0.00,0.00,'756','2022-10-28 19:42:42','756','2022-10-28 19:43:06',10,0),('1','219',272,'DAILY SHIFTS','2022-10-29','2022-10-29 09:57:29','2022-10-30 09:57:29','756',0.00,0.00,'756','2022-10-29 20:31:56','756','2022-10-29 20:32:17',10,0),('1','219',273,'DAILY SHIFTS','2022-10-30','2022-10-30 06:56:02','2022-10-31 06:56:02','756',0.00,0.00,'756','2022-10-30 19:09:49','756','2022-10-30 19:10:10',10,0),('1','219',274,'DAILY','2022-10-31','2022-10-31 07:02:14','2022-11-01 07:02:14','756',0.00,0.00,'756','2022-10-31 19:00:14','756','2022-10-31 19:00:34',10,0),('1','219',275,'DAILY SHIFTS','2022-11-06','2022-11-06 14:27:29','2022-11-07 14:27:29','756',0.00,0.00,'756','2022-11-06 21:12:08','756','2022-11-06 21:12:58',10,0),('1','219',276,'DAILY SHIFT','2022-11-07','2022-11-07 06:59:43','2022-11-08 06:59:43','756',0.00,0.00,'756','2022-11-07 18:17:58','756','2022-11-07 18:18:24',10,0),('1','219',277,'DAILY SHIFT','2022-11-08','2022-11-08 07:14:27','2022-11-09 07:14:27','756',0.00,0.00,'756','2022-11-08 18:49:38','756','2022-11-08 18:50:00',10,0),('1','219',278,'DAILY SHIFT','2022-11-09','2022-11-09 07:04:06','2022-11-10 07:04:06','756',0.00,0.00,'756','2022-11-09 13:08:45','756','2022-11-09 13:11:49',10,0),('1','219',279,'DAILY SHIFT','2022-11-09','2022-11-09 13:24:01','2022-11-10 13:24:01','756',0.00,0.00,'756','2022-11-09 13:27:41','756','2022-11-09 13:28:01',10,0),('1','219',280,'DAILY SHIFT','2022-11-10','2022-11-10 09:41:41','2022-11-11 09:41:41','756',0.00,0.00,'756','2022-11-10 18:24:06','756','2022-11-10 18:24:23',10,0),('1','219',281,'DAILY SHIFT','2022-11-11','2022-11-11 07:17:54','2022-11-12 07:17:54','756',0.00,0.00,'756','2022-11-11 21:37:56','756','2022-11-11 21:38:19',10,0),('1','219',282,'DAILY SHIFT','2022-11-12','2022-11-12 07:17:39','2022-11-13 07:17:39','756',0.00,0.00,'756','2022-11-12 19:20:57','756','2022-11-12 19:21:25',10,0),('1','219',283,'DAILY SHIFT','2022-11-13','2022-11-13 07:06:35','2022-11-14 07:06:35','756',0.00,0.00,'756','2022-11-13 18:03:37','756','2022-11-13 18:04:01',10,0),('1','219',284,'DAILY SHIFT','2022-11-14','2022-11-14 07:13:36','2022-11-15 07:13:36','756',0.00,0.00,'756','2022-11-14 22:29:28','756','2022-11-14 22:29:54',10,0),('1','219',285,'DAILY SHIFT','2022-11-15','2022-11-15 06:54:43','2022-11-16 06:54:43','756',0.00,0.00,'756','2022-11-15 19:51:36','756','2022-11-15 19:51:58',10,0),('1','219',286,'DAILY SHIFT','2022-11-16','2022-11-16 07:10:07','2022-11-17 07:10:07','756',0.00,0.00,'756','2022-11-16 18:34:11','756','2022-11-16 18:34:34',10,0),('1','219',287,'DAILY SHIFT ','2022-11-17','2022-11-17 07:06:36','2022-11-18 07:06:36','756',0.00,0.00,'756','2022-11-17 16:48:41','756','2022-11-17 16:49:12',10,0),('1','219',288,'DAILY SHIFT','2022-11-18','2022-11-18 07:06:14','2022-11-19 07:06:14','756',0.00,0.00,'756','2022-11-18 18:42:00','756','2022-11-18 18:42:27',10,0),('1','219',289,'DAILY SHIFT','2022-11-19','2022-11-19 07:03:27','2022-11-20 07:03:27','756',0.00,0.00,'756','2022-11-19 18:38:01','756','2022-11-19 18:38:23',10,0),('1','219',290,'DAILY SHIFT','2022-11-20','2022-11-20 07:43:20','2022-11-21 07:43:20','756',0.00,0.00,'756','2022-11-20 18:00:08','756','2022-11-20 18:00:25',10,0),('1','219',291,'DAILY SHIFT','2022-11-21','2022-11-21 06:58:56','2022-11-22 06:58:56','756',0.00,0.00,'756','2022-11-21 18:32:05','756','2022-11-21 18:32:27',10,0),('1','219',292,'DAILY SHIFT','2022-11-22','2022-11-22 07:14:18','2022-11-23 07:14:18','756',0.00,0.00,'756','2022-11-22 21:19:55','756','2022-11-22 21:20:17',10,0),('1','219',293,'DAILY SHIFT','2022-11-23','2022-11-23 07:09:30','2022-11-24 07:09:30','756',0.00,0.00,'756','2022-11-23 18:54:11','756','2022-11-23 18:54:37',10,0),('1','219',294,'DAILY SHIFT','2022-11-24','2022-11-24 07:11:08','2022-11-25 07:11:08','756',0.00,0.00,'756','2022-11-24 10:50:36','756','2022-11-24 10:50:55',10,0),('1','219',295,'DAILY SHIFT','2022-11-24','2022-11-24 11:04:25','2022-11-25 11:04:25','756',0.00,0.00,'756','2022-11-24 11:07:47','756','2022-11-24 11:08:08',10,0),('1','219',296,'DAILY SHIFT','2022-11-24','2022-11-24 13:37:57','2022-11-25 13:37:57','756',0.00,0.00,'756','2022-11-24 19:14:56','756','2022-11-24 19:15:15',10,0),('1','219',297,'DAILY SHIFT','2022-11-25','2022-11-25 07:08:59','2022-11-26 07:08:59','756',0.00,0.00,'756','2022-11-25 18:39:49','756','2022-11-25 18:40:50',10,0),('1','219',298,'DAILY SHIFT','2022-11-26','2022-11-26 10:19:48','2022-11-27 10:19:48','756',0.00,0.00,'756','2022-11-26 20:14:58','756','2022-11-26 20:15:35',10,0),('1','219',299,'DAILY SHIFT','2022-11-27','2022-11-27 07:08:36','2022-11-28 07:08:36','756',0.00,0.00,'756','2022-11-27 18:54:26','756','2022-11-27 18:54:52',10,0),('1','219',300,'DAILY SHIFT','2022-11-28','2022-11-28 07:13:24','2022-11-29 07:13:24','756',0.00,0.00,'756','2022-11-28 17:56:01','756','2022-11-28 17:56:22',10,0),('1','219',301,'DAILY SHIFT','2022-11-29','2022-11-29 07:16:33','2022-11-30 07:16:33','756',0.00,0.00,'756','2022-11-29 18:55:46','756','2022-11-29 18:56:09',10,0),('1','219',302,'DAILY SHIFT','2022-11-30','2022-11-30 07:04:24','2022-12-01 07:04:24','756',0.00,0.00,'756','2022-11-30 15:48:16','756','2022-11-30 15:48:37',10,0),('1','219',303,'DAILY SHIFT','2022-12-01','2022-12-01 07:14:59','2022-12-02 07:14:59','756',0.00,0.00,'756','2022-12-01 18:50:06','756','2022-12-01 18:50:48',10,0),('1','219',304,'DAILY SHIFT','2022-12-02','2022-12-02 07:08:43','2022-12-03 07:08:43','756',0.00,0.00,'756','2022-12-02 12:14:07','756','2022-12-02 12:14:42',10,0),('1','219',305,'DAILY SHIFT','2022-12-03','2022-12-03 07:51:50','2022-12-04 07:51:50','756',0.00,0.00,'756','2022-12-03 18:59:20','756','2022-12-03 18:59:48',10,0),('1','219',306,'DAILY SHIFT','2022-12-04','2022-12-04 07:21:01','2022-12-05 07:21:01','756',0.00,0.00,'756','2022-12-04 18:03:18','756','2022-12-04 18:03:44',10,0),('1','219',307,'DAILY SHIFT','2022-12-05','2022-12-05 07:09:54','2022-12-06 07:09:54','756',0.00,0.00,'756','2022-12-05 18:11:21','756','2022-12-05 18:11:42',10,0),('1','219',308,'DAILY SHIFT','2022-12-06','2022-12-06 07:15:09','2022-12-07 07:15:09','756',0.00,0.00,'756','2022-12-06 18:07:56','756','2022-12-06 18:09:34',10,0),('1','219',309,'DAILY SHIFT','2022-12-07','2022-12-07 07:12:24','2022-12-08 07:12:24','756',0.00,0.00,'756','2022-12-07 23:17:49','756','2022-12-07 23:18:18',10,0),('1','219',310,'DAILY SHIFT','2022-10-31','2022-12-08 03:37:05','2022-12-09 03:37:05','756',0.00,0.00,'756','2022-12-08 03:45:17','756','2022-12-08 03:46:01',10,0),('1','219',311,'DAILY SHIFT','2022-12-08','2022-12-08 07:16:47','2022-12-09 07:16:47','756',0.00,0.00,'756','2022-12-08 09:00:19','756','2022-12-08 09:00:47',10,0),('1','219',312,'DAILY SHIFT','2022-12-08','2022-12-08 09:01:19','2022-12-09 09:01:19','756',0.00,0.00,'756','2022-12-08 21:17:57','756','2022-12-08 21:18:19',10,0),('1','219',313,'DAILY SHIFT','2022-12-09','2022-12-09 07:11:21','2022-12-10 07:11:21','756',0.00,0.00,'756','2022-12-09 18:26:02','756','2022-12-09 18:27:15',10,0),('1','219',314,'DAILY SHIFT','2022-12-10','2022-12-10 07:15:29','2022-12-11 07:15:29','756',0.00,0.00,'756','2022-12-10 21:13:50','756','2022-12-10 21:14:29',10,0),('1','219',315,'DAILY SHIFT','2022-12-11','2022-12-11 07:25:39','2022-12-12 07:25:39','756',0.00,0.00,'756','2022-12-11 18:39:37','756','2022-12-11 18:39:53',10,0),('1','219',316,'DAILY SHIFT','2022-12-12','2022-12-12 07:20:29','2022-12-13 07:20:29','756',0.00,0.00,'756','2022-12-12 17:45:38','756','2022-12-12 17:45:56',10,0),('1','219',317,'DAILY SHIFT','2022-12-13','2022-12-13 07:20:05','2022-12-14 07:20:05','756',0.00,0.00,'756','2022-12-13 14:03:00','756','2022-12-13 14:03:21',10,0),('1','219',318,'DAILY SHIFT','2022-12-13','2022-12-13 14:08:20','2022-12-14 14:08:20','756',0.00,0.00,'756','2022-12-13 15:34:36','756','2022-12-13 15:34:54',10,0),('1','219',319,'DAILY SHIFT','2022-12-13','2022-12-13 15:35:20','2022-12-14 15:35:20','756',0.00,0.00,'756','2022-12-13 18:33:34','756','2022-12-13 18:34:03',10,0),('1','219',320,'DAILY SHIFT','2022-12-14','2022-12-14 07:15:09','2022-12-15 07:15:09','756',0.00,0.00,'756','2022-12-14 20:33:00','756','2022-12-14 20:33:26',10,0),('1','219',321,'DAILY SHIFT','2022-12-15','2022-12-15 07:06:17','2022-12-16 07:06:17','756',0.00,0.00,'756','2022-12-15 18:12:36','756','2022-12-15 18:13:52',10,0),('1','219',322,'DAILY SHIFT','2022-12-16','2022-12-16 07:21:19','2022-12-17 07:21:19','756',0.00,0.00,'756','2022-12-16 22:17:55','756','2022-12-16 22:18:21',10,0),('1','219',323,'DAILY SHIFT','2022-12-17','2022-12-17 07:05:24','2022-12-18 07:05:24','756',0.00,0.00,'756','2022-12-17 19:37:02','756','2022-12-17 19:37:20',10,0),('1','219',324,'DAILY SHIFT','2022-12-18','2022-12-18 07:17:59','2022-12-19 07:17:59','756',0.00,0.00,'756','2022-12-18 11:03:34','756','2022-12-18 11:03:51',10,0),('1','219',325,'DAILY SHIFT','2022-12-18','2022-12-18 11:10:37','2022-12-19 11:10:37','756',0.00,0.00,'756','2022-12-18 11:14:44','756','2022-12-18 11:15:08',10,0),('1','219',326,'DAILY SHIFT','2022-12-18','2022-12-18 14:41:41','2022-12-19 14:41:41','756',0.00,0.00,'756','2022-12-18 21:14:04','756','2022-12-18 21:14:27',10,0),('1','219',327,'DAILY SHIFT','2022-12-19','2022-12-19 07:18:09','2022-12-20 07:18:09','756',0.00,0.00,'756','2022-12-19 19:02:08','756','2022-12-19 19:02:32',10,0),('1','219',328,'DAILY SHIFT','2022-12-20','2022-12-20 07:27:28','2022-12-21 07:27:28','756',0.00,0.00,'756','2022-12-20 18:26:25','756','2022-12-20 18:26:56',10,0),('1','219',329,'DAILY SHIFT','2022-12-21','2022-12-21 07:11:07','2022-12-22 07:11:07','756',0.00,0.00,'756','2022-12-21 18:42:22','756','2022-12-21 18:42:43',10,0),('1','219',330,'DAILY SHIFT','2022-12-22','2022-12-22 07:23:43','2022-12-23 07:23:43','756',0.00,0.00,'756','2022-12-22 19:49:44','756','2022-12-22 19:50:09',10,0),('1','219',331,'DAILY SHIFT','2022-12-23','2022-12-23 07:16:22','2022-12-24 07:16:22','756',0.00,0.00,'756','2022-12-23 11:49:33','756','2022-12-23 11:49:49',10,0),('1','219',332,'DAILY SHIFT','2022-12-23','2022-12-23 11:51:48','2022-12-24 11:51:48','756',0.00,0.00,'756','2022-12-23 16:21:43','756','2022-12-23 16:22:19',10,0),('1','219',333,'DAILY SHIFT','2022-12-23','2022-12-23 16:23:13','2022-12-24 16:23:13','756',0.00,0.00,'756','2022-12-23 19:21:53','756','2022-12-23 19:22:10',10,0),('1','219',334,'DAILY SHIFT','2022-12-24','2022-12-24 07:22:19','2022-12-25 07:22:19','756',0.00,0.00,'756','2022-12-24 20:16:48','756','2022-12-24 20:17:12',10,0),('1','219',335,'DAILY SHIFT','2022-12-25','2022-12-25 07:20:30','2022-12-26 07:20:30','756',0.00,0.00,'756','2022-12-25 18:30:42','756','2022-12-25 18:31:02',10,0),('1','219',336,'DAILY SHIFT','2022-12-26','2022-12-26 07:30:43','2022-12-27 07:30:43','756',0.00,0.00,'756','2022-12-26 18:38:53','756','2022-12-26 18:39:13',10,0),('1','219',337,'DAILY SHIFT','2022-12-27','2022-12-27 07:16:18','2022-12-28 07:16:18','756',0.00,0.00,'756','2022-12-27 16:33:45','756','2022-12-27 16:34:28',10,0),('1','219',338,'DAILY SHIFT','2022-12-28','2022-12-28 07:24:29','2022-12-29 07:24:29','756',0.00,0.00,'756','2022-12-28 17:57:52','756','2022-12-28 17:58:14',10,0),('1','219',339,'DAILY SHIFT','2022-12-29','2022-12-29 07:17:24','2022-12-30 07:17:24','756',0.00,0.00,'756','2022-12-29 18:14:54','756','2022-12-29 18:15:17',10,0),('1','219',340,'DAILY SHIFT','2022-12-30','2022-12-30 07:24:38','2022-12-31 07:24:38','756',0.00,0.00,'756','2022-12-30 20:18:02','756','2022-12-30 20:18:35',10,0),('1','219',341,'DAILY SHIFT','2022-12-31','2022-12-31 10:02:53','2023-01-01 10:02:53','756',0.00,0.00,'756','2022-12-31 19:18:35','756','2022-12-31 19:19:04',10,0),('1','219',342,'DAILY SHIFT','2023-01-01','2023-01-01 07:37:42','2023-01-02 07:37:42','756',0.00,0.00,'756','2023-01-01 15:48:52','756','2023-01-01 15:49:10',10,0),('1','219',343,'DAILY SHIFT','2023-01-02','2023-01-02 07:26:06','2023-01-03 07:26:06','756',0.00,0.00,'756','2023-01-02 21:03:41','756','2023-01-02 21:04:03',10,0),('1','219',344,'DAILY SHIFT','2023-01-03','2023-01-03 07:29:27','2023-01-04 07:29:27','756',0.00,0.00,'756','2023-01-03 17:35:22','756','2023-01-03 17:35:39',10,0),('1','219',345,'DAILY SHIFT','2023-01-04','2023-01-04 07:22:03','2023-01-05 07:22:03','756',0.00,0.00,'756','2023-01-04 19:06:36','756','2023-01-04 19:07:09',10,0),('1','219',346,'DAILY SHIFT','2023-01-05','2023-01-05 07:38:02','2023-01-06 07:38:02','756',0.00,0.00,'756','2023-01-05 21:13:02','756','2023-01-05 21:13:23',10,0),('1','219',347,'DAILY SHIFT','2023-01-06','2023-01-06 07:27:57','2023-01-07 07:27:57','756',0.00,0.00,'756','2023-01-06 14:53:52','756','2023-01-06 14:54:10',10,0),('1','219',348,'DAILY SHIFT','2023-01-06','2023-01-06 15:43:45','2023-01-07 15:43:45','756',0.00,0.00,'756','2023-01-06 18:02:03','756','2023-01-06 18:02:21',10,0),('1','219',349,'DAILY SHIFT','2023-01-07','2023-01-07 07:34:55','2023-01-08 07:34:55','756',0.00,0.00,'756','2023-01-07 18:40:33','756','2023-01-07 18:40:53',10,0),('1','219',350,'DAILY SHIFT','2023-01-08','2023-01-08 07:18:58','2023-01-09 07:18:58','756',0.00,0.00,'756','2023-01-08 18:48:18','756','2023-01-08 18:48:38',10,0),('1','219',351,'DAILY SHIFT','2023-01-09','2023-01-09 07:37:24','2023-01-10 07:37:24','756',0.00,0.00,'756','2023-01-09 18:25:02','756','2023-01-09 18:25:22',10,0),('1','219',352,'DAILY SHIFT','2023-01-10','2023-01-10 07:15:31','2023-01-11 07:15:31','756',0.00,0.00,'756','2023-01-10 18:56:31','756','2023-01-10 18:56:53',10,0),('1','219',353,'DAILY SHIFT','2023-01-11','2023-01-11 07:37:19','2023-01-12 07:37:19','756',0.00,0.00,'756','2023-01-11 18:08:32','756','2023-01-11 18:08:54',10,0),('1','219',354,'DAILY SHIFT','2023-01-12','2023-01-12 07:21:53','2023-01-13 07:21:53','756',0.00,0.00,'756','2023-01-12 18:19:28','756','2023-01-12 18:19:50',10,0),('1','219',355,'DAILY SHIFT','2023-01-13','2023-01-13 07:33:20','2023-01-14 07:33:20','756',0.00,0.00,'756','2023-01-13 18:45:47','756','2023-01-13 18:46:31',10,0),('1','219',356,'DAILY SHIFT','2023-01-14','2023-01-14 07:17:21','2023-01-15 07:17:21','756',0.00,0.00,'756','2023-01-14 19:04:52','756','2023-01-14 19:05:21',10,0),('1','219',357,'DAILY SHIFT','2023-01-15','2023-01-15 07:32:50','2023-01-16 07:32:50','756',0.00,0.00,'756','2023-01-15 18:46:32','756','2023-01-15 18:47:00',10,0),('1','219',358,'DAILY SHIFT','2023-01-16','2023-01-16 07:24:03','2023-01-17 07:24:03','756',0.00,0.00,'756','2023-01-16 16:26:52','756','2023-01-16 16:27:10',10,0),('1','219',359,'DAILY SHIFT','2023-01-17','2023-01-17 07:35:01','2023-01-18 07:35:01','756',0.00,0.00,'756','2023-01-17 18:52:58','756','2023-01-17 18:53:23',10,0),('1','219',360,'DAILY SHIFT','2023-01-18','2023-01-18 07:17:45','2023-01-19 07:17:45','756',0.00,0.00,'756','2023-01-18 18:17:08','756','2023-01-18 18:17:30',10,0),('1','219',361,'DAILY SHIFT','2023-01-19','2023-01-19 07:38:14','2023-01-20 07:38:14','756',0.00,0.00,'756','2023-01-19 18:37:10','756','2023-01-19 18:37:29',10,0),('1','219',362,'DAILY SHIFT','2023-01-20','2023-01-20 07:20:27','2023-01-21 07:20:27','756',0.00,0.00,'756','2023-01-20 18:01:59','756','2023-01-20 18:02:53',10,0),('1','219',363,'DAILY SHIFT','2023-01-21','2023-01-21 07:36:45','2023-01-22 07:36:45','756',0.00,0.00,'756','2023-01-21 09:53:48','756','2023-01-21 09:54:13',10,0),('1','219',364,'DAILY SHIFT','2023-01-21','2023-01-21 10:13:26','2023-01-22 10:13:26','756',0.00,0.00,'756','2023-01-21 18:41:45','756','2023-01-21 18:42:11',10,0),('1','219',365,'DAILY SHIFT','2023-01-22','2023-01-22 07:22:10','2023-01-23 07:22:10','756',0.00,0.00,'756','2023-01-22 18:08:34','756','2023-01-22 18:08:54',10,0),('1','219',366,'DAILY SHIFT','2023-01-23','2023-01-23 07:35:57','2023-01-24 07:35:57','756',0.00,0.00,'756','2023-01-23 18:53:07','756','2023-01-23 18:53:31',10,0),('1','219',367,'DAILY SHIFT','2023-01-24','2023-01-24 07:25:25','2023-01-25 07:25:25','756',0.00,0.00,'756','2023-01-24 19:02:37','756','2023-01-24 19:02:58',10,0),('1','219',368,'DAILY SHIFT','2023-01-25','2023-01-25 07:37:22','2023-01-26 07:37:22','756',0.00,0.00,'756','2023-01-25 19:21:59','756','2023-01-25 19:22:19',10,0),('1','219',369,'DAILY SHIFT','2023-01-26','2023-01-26 07:21:57','2023-01-27 07:21:57','756',0.00,0.00,'756','2023-01-26 19:17:43','756','2023-01-26 19:18:11',10,0),('1','219',370,'DAILY SHIFT','2023-01-27','2023-01-27 07:42:51','2023-01-28 07:42:51','756',0.00,0.00,'756','2023-01-27 12:11:57','756','2023-01-27 12:12:27',10,0),('1','219',371,'DAILY SHIFT','2023-01-27','2023-01-27 12:57:01','2023-01-28 12:57:01','756',0.00,0.00,'756','2023-01-27 22:49:26','756','2023-01-27 22:49:49',10,0),('1','219',372,'DAILY SHIFT','2023-01-28','2023-01-28 07:21:42','2023-01-29 07:21:42','756',0.00,0.00,'756','2023-01-28 19:15:35','756','2023-01-28 19:15:54',10,0),('1','219',373,'DAILY SHIFT','2023-01-29','2023-01-29 07:35:47','2023-01-30 07:35:47','756',0.00,0.00,'756','2023-01-29 18:26:01','756','2023-01-29 18:26:23',10,0),('1','219',374,'DAILY SHIFT','2023-01-30','2023-01-30 07:22:56','2023-01-31 07:22:56','756',0.00,0.00,'756','2023-01-30 19:05:44','756','2023-01-30 19:06:37',10,0),('1','219',375,'DAILY SHIFT','2023-01-31','2023-01-31 07:39:57','2023-02-01 07:39:57','756',0.00,0.00,'756','2023-01-31 18:25:49','756','2023-01-31 18:26:21',10,0),('1','219',376,'DAILY SHIFT','2023-02-01','2023-02-01 07:31:26','2023-02-02 07:31:26','756',0.00,0.00,'756','2023-02-01 19:14:08','756','2023-02-01 19:14:34',10,0),('1','219',377,'DAILY SHIFT','2023-02-02','2023-02-02 07:36:07','2023-02-03 07:36:07','756',0.00,0.00,'756','2023-02-02 19:10:36','756','2023-02-02 19:11:20',10,0),('1','219',378,'DAILY SHIFT','2023-02-03','2023-02-03 07:27:12','2023-02-04 07:27:12','756',0.00,0.00,'756','2023-02-03 14:49:50','756','2023-02-03 14:50:08',10,0),('1','219',379,'DAILY SHIFT','2023-02-03','2023-02-03 14:54:53','2023-02-04 14:54:53','756',0.00,0.00,'756','2023-02-03 19:03:21','756','2023-02-03 19:03:49',10,0),('1','219',380,'DAILY SHIFT','2023-02-04','2023-02-04 07:36:16','2023-02-05 07:36:16','756',0.00,0.00,'756','2023-02-04 19:14:13','756','2023-02-04 19:15:02',10,0),('1','219',381,'DAILY SHIFT','2023-02-05','2023-02-05 07:23:43','2023-02-06 07:23:43','756',0.00,0.00,'756','2023-02-05 18:27:04','756','2023-02-05 18:27:23',10,0),('1','219',382,'DAILY SHIFT','2023-02-05','2023-02-05 18:55:21','2023-02-06 18:55:21','756',0.00,0.00,'756','2023-02-05 18:56:29','756','2023-02-05 18:57:00',10,0),('1','219',383,'DAILY SHIFT','2023-02-06','2023-02-06 07:36:01','2023-02-07 07:36:01','756',0.00,0.00,'756','2023-02-06 18:59:21','756','2023-02-06 18:59:42',10,0),('1','219',384,'DAILY SHIFT','2023-02-07','2023-02-07 07:19:06','2023-02-08 07:19:06','756',0.00,0.00,'756','2023-02-07 19:07:28','756','2023-02-07 19:07:48',10,0),('1','219',385,'DAILY SHIFT','2023-02-08','2023-02-08 07:38:53','2023-02-09 07:38:53','756',0.00,0.00,'756','2023-02-08 18:58:49','756','2023-02-08 18:59:11',10,0),('1','219',386,'DAILY SHIFT','2023-02-09','2023-02-09 07:22:56','2023-02-10 07:22:56','756',0.00,0.00,'756','2023-02-09 19:06:06','756','2023-02-09 19:06:28',10,0),('1','219',387,'DAILY SHIFT','2023-02-10','2023-02-10 07:35:27','2023-02-11 07:35:27','756',0.00,0.00,'756','2023-02-10 18:23:50','756','2023-02-10 18:24:09',10,0),('1','219',388,'DAILY SHIFT','2023-02-11','2023-02-11 07:25:19','2023-02-12 07:25:19','756',0.00,0.00,'756','2023-02-11 18:32:11','756','2023-02-11 18:32:30',10,0),('1','219',389,'DAILY SHIFT','2023-02-12','2023-02-12 07:39:19','2023-02-13 07:39:19','756',0.00,0.00,'756','2023-02-12 18:32:11','756','2023-02-12 18:32:47',10,0),('1','219',390,'DAILY SHIFT','2023-02-13','2023-02-13 07:20:53','2023-02-14 07:20:53','756',0.00,0.00,'756','2023-02-13 15:30:30','756','2023-02-13 15:30:50',10,0),('1','219',391,'DAILY SHIFT','2023-02-13','2023-02-13 15:46:09','2023-02-14 15:46:09','756',0.00,0.00,'756','2023-02-13 15:51:44','756','2023-02-13 15:52:03',10,0),('1','219',392,'DAILY SHIFT','2023-02-14','2023-02-14 07:32:20','2023-02-15 07:32:20','756',0.00,0.00,'756','2023-02-14 19:27:28','756','2023-02-14 19:27:51',10,0),('1','219',393,'DAILY SHIFT','2023-02-15','2023-02-15 07:23:59','2023-02-16 07:23:59','756',0.00,0.00,'756','2023-02-15 19:32:33','756','2023-02-15 19:32:54',10,0),('1','219',394,'DAILY SHIFT','2023-02-16','2023-02-16 12:30:06','2023-02-17 12:30:06','756',0.00,0.00,'756','2023-02-16 12:55:35','756','2023-02-16 12:55:56',10,0),('1','219',395,'DAILY SHIFT','2023-02-16','2023-02-16 13:07:34','2023-02-17 13:07:34','756',0.00,0.00,'756','2023-02-16 13:11:30','756','2023-02-16 13:11:52',10,0),('1','219',396,'DAILY SHIFT','2023-02-16','2023-02-16 13:15:04','2023-02-17 13:15:04','756',0.00,0.00,'756','2023-02-16 21:14:24','756','2023-02-16 21:14:48',10,0),('1','219',397,'DAILY SHIFT','2023-02-17','2023-02-17 07:25:28','2023-02-18 07:25:28','756',0.00,0.00,'756','2023-02-17 18:23:05','756','2023-02-17 18:23:23',10,0),('1','219',398,'DAILY SHIFT','2023-02-18','2023-02-18 07:33:47','2023-02-19 07:33:47','756',0.00,0.00,'756','2023-02-18 18:34:25','756','2023-02-18 18:34:46',10,0),('1','219',399,'DAILY SHIFT','2023-02-19','2023-02-19 07:22:29','2023-02-20 07:22:29','756',0.00,0.00,'756','2023-02-19 18:39:51','756','2023-02-19 18:40:17',10,0),('1','219',400,'DAILY SHIFT','2023-02-20','2023-02-20 07:42:04','2023-02-21 07:42:04','756',0.00,0.00,'756','2023-02-20 18:34:44','756','2023-02-20 18:35:03',10,0),('1','219',401,'DAILY SHIFT','2023-02-21','2023-02-21 07:20:09','2023-02-22 07:20:09','756',0.00,0.00,'756','2023-02-21 18:59:30','756','2023-02-21 18:59:52',10,0),('1','219',402,'DAILY SHIFT','2023-02-22','2023-02-22 07:30:54','2023-02-23 07:30:54','756',0.00,0.00,'756','2023-02-22 18:33:31','756','2023-02-22 18:33:51',10,0),('1','219',403,'DAILY SHIFT','2023-02-23','2023-02-23 07:15:23','2023-02-24 07:15:23','756',0.00,0.00,'756','2023-02-23 13:47:22','756','2023-02-23 13:47:42',10,0),('1','219',404,'DAILY SHIFT','2023-02-23','2023-02-23 13:59:10','2023-02-24 13:59:10','756',0.00,0.00,'756','2023-02-23 18:37:18','756','2023-02-23 18:37:38',10,0),('1','219',405,'DAILY SHIFT','2023-02-24','2023-02-24 07:32:44','2023-02-25 07:32:44','756',0.00,0.00,'756','2023-02-24 19:09:41','756','2023-02-24 19:10:03',10,0),('1','219',406,'DAILY SHIFT','2023-02-26','2023-02-26 07:19:12','2023-02-27 07:19:12','756',0.00,0.00,'756','2023-02-26 13:45:43','756','2023-02-26 13:46:03',10,0),('1','219',407,'DAILY SHIFT','2023-02-26','2023-02-26 19:44:04','2023-02-27 19:44:04','756',0.00,0.00,'756','2023-02-26 19:47:18','756','2023-02-26 19:47:38',10,0),('1','219',408,'DAILY SHIFT','2023-02-27','2023-02-27 07:43:15','2023-02-28 07:43:15','756',0.00,0.00,'756','2023-02-27 19:14:33','756','2023-02-27 19:14:54',10,0),('1','219',409,'DAILY SHIFT','2023-02-28','2023-02-28 07:19:50','2023-03-01 07:19:50','756',0.00,0.00,'756','2023-02-28 19:02:32','756','2023-02-28 19:02:56',10,0),('1','219',410,'DAILY SHIFT','2023-03-01','2023-03-01 07:43:26','2023-03-02 07:43:26','756',0.00,0.00,'756','2023-03-01 19:03:28','756','2023-03-01 19:04:11',10,0),('1','219',411,'DAILY SHIFT','2023-03-02','2023-03-02 07:28:21','2023-03-03 07:28:21','756',0.00,0.00,'756','2023-03-02 18:37:54','756','2023-03-02 18:38:12',10,0),('1','219',412,'DAILY SHIFT','2023-03-03','2023-03-03 07:17:01','2023-03-04 07:17:01','756',0.00,0.00,'756','2023-03-03 19:02:24','756','2023-03-03 19:03:00',10,0),('1','219',413,'DAILY SHIFT','2023-03-04','2023-03-04 07:29:08','2023-03-05 07:29:08','756',0.00,0.00,'756','2023-03-04 21:18:03','756','2023-03-04 21:18:28',10,0),('1','219',414,'DAILY SHIFT','2023-03-05','2023-03-05 07:20:53','2023-03-06 07:20:53','756',0.00,0.00,'756','2023-03-05 19:15:58','756','2023-03-05 19:16:27',10,0),('1','219',415,'DAILY SHIFT','2023-03-06','2023-03-06 07:40:10','2023-03-07 07:40:10','756',0.00,0.00,'756','2023-03-06 18:27:25','756','2023-03-06 18:27:43',10,0),('1','219',416,'DAILY SHIFT','2023-03-07','2023-03-07 07:26:34','2023-03-08 07:26:34','756',0.00,0.00,'756','2023-03-07 15:24:31','756','2023-03-07 15:24:52',10,0),('1','219',417,'DAILY SHIFT','2023-03-07','2023-03-07 15:28:42','2023-03-08 15:28:42','756',0.00,0.00,'756','2023-03-07 15:31:56','756','2023-03-07 15:32:16',10,0),('1','219',418,'DAILY SHIFT','2023-03-07','2023-03-07 16:35:05','2023-03-08 16:35:05','756',0.00,0.00,'756','2023-03-07 18:35:50','756','2023-03-07 18:36:29',10,0),('1','219',419,'DAILY SHIFT','2023-03-08','2023-03-08 07:36:10','2023-03-09 07:36:10','756',0.00,0.00,'756','2023-03-08 18:30:45','756','2023-03-08 18:31:05',10,0),('1','219',420,'DAILY SHIFT','2023-03-09','2023-03-09 07:13:35','2023-03-10 07:13:35','756',0.00,0.00,'756','2023-03-09 19:02:43','756','2023-03-09 19:03:07',10,0),('1','219',421,'DAILY SHIFT','2023-03-10','2023-03-10 08:01:37','2023-03-11 08:01:37','756',0.00,0.00,'756','2023-03-10 19:21:23','756','2023-03-10 19:21:53',10,0),('1','219',422,'DAILY SHIFT','2023-03-11','2023-03-11 07:33:29','2023-03-12 07:33:29','756',0.00,0.00,'756','2023-03-11 19:02:29','756','2023-03-11 19:03:04',10,0),('1','219',423,'DAILY SHIFT','2023-03-12','2023-03-12 07:48:25','2023-03-13 07:48:25','756',0.00,0.00,'756','2023-03-12 19:10:14','756','2023-03-12 19:10:34',10,0),('1','219',424,'DAILY SHIFT','2023-03-13','2023-03-13 07:38:51','2023-03-14 07:38:51','756',0.00,0.00,'756','2023-03-13 21:45:46','756','2023-03-13 21:46:08',10,0),('1','219',425,'DAILY SHIFT','2023-03-14','2023-03-14 07:37:04','2023-03-15 07:37:04','756',0.00,0.00,'756','2023-03-14 19:28:32','756','2023-03-14 19:28:54',10,0),('1','219',426,'DAILY SHIFT','2023-03-15','2023-03-15 07:03:07','2023-03-16 07:03:07','756',0.00,0.00,'756','2023-03-15 19:02:18','756','2023-03-15 19:02:41',10,0),('1','219',427,'DAILY SHIFT','2023-03-16','2023-03-16 07:36:20','2023-03-17 07:36:20','756',0.00,0.00,'756','2023-03-16 10:54:29','756','2023-03-16 10:54:47',10,0),('1','219',428,'DAILY SHIFT','2023-03-16','2023-03-16 11:28:42','2023-03-17 11:28:42','756',0.00,0.00,'756','2023-03-16 11:32:39','756','2023-03-16 11:33:18',10,0),('1','219',429,'DAILY SHIFT','2023-03-16','2023-03-16 11:37:18','2023-03-17 11:37:18','756',0.00,0.00,'756','2023-03-16 18:46:18','756','2023-03-16 18:46:34',10,0),('1','219',430,'DAILY SHIFT','2023-03-17','2023-03-17 07:11:49','2023-03-18 07:11:49','756',0.00,0.00,'756','2023-03-17 19:39:17','756','2023-03-17 19:39:44',10,0),('1','219',431,'DAILY SHIFT','2023-03-19','2023-03-19 07:25:41','2023-03-20 07:25:41','756',0.00,0.00,'756','2023-03-19 17:25:27','756','2023-03-19 17:25:47',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1725 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','219','1','1',1,'1','1',2.79,131.76,0.00,0.00,128.97,73254.96,0.00,0.00,0.00),('1','219','1','1',2,'2','1',47.79,116.10,0.00,0.00,68.31,38800.08,0.00,0.00,0.00),('1','219','1','1',3,'3','1',1.63,1.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','1',4,'4','1',2.59,177.59,0.00,0.00,175.00,94500.00,0.00,0.00,0.00),('1','219','1','2',5,'1','1',131.76,227.51,0.00,0.00,95.75,54386.00,0.00,0.00,0.00),('1','219','1','2',6,'2','1',116.10,202.57,0.00,0.00,86.47,49114.96,0.00,0.00,0.00),('1','219','1','2',7,'3','1',1.63,1.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','2',8,'4','1',177.59,277.59,0.00,0.00,100.00,54000.00,0.00,0.00,0.00),('1','219','1','3',9,'1','1',227.51,328.17,0.00,0.00,100.66,57174.88,0.00,0.00,0.00),('1','219','1','3',10,'2','1',202.57,202.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','3',11,'3','1',1.63,1.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','3',12,'4','1',277.59,277.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','4',13,'1','1',328.17,328.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','4',14,'2','1',202.57,334.54,0.00,0.00,131.97,74958.96,0.00,0.00,0.00),('1','219','1','4',15,'3','1',1.63,1.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','4',16,'4','1',277.59,277.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','5',17,'1','1',328.17,409.61,0.00,0.00,81.44,46257.92,0.00,0.00,0.00),('1','219','1','5',18,'2','1',334.54,380.19,0.00,0.00,45.65,25929.20,0.00,0.00,0.00),('1','219','1','5',19,'3','1',1.63,15.66,0.00,0.00,14.03,7969.04,0.00,0.00,0.00),('1','219','1','5',20,'4','1',277.59,277.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','6',21,'1','1',409.61,409.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','6',22,'2','1',380.19,433.83,0.00,0.00,53.64,30467.52,0.00,0.00,0.00),('1','219','1','6',23,'3','1',15.66,15.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','6',24,'4','1',277.59,379.01,0.00,0.00,101.42,57606.56,0.00,0.00,0.00),('1','219','1','7',25,'1','1',409.61,566.54,0.00,0.00,156.93,89136.24,0.00,0.00,0.00),('1','219','1','7',26,'2','1',433.83,576.69,0.00,0.00,142.86,81144.48,0.00,0.00,0.00),('1','219','1','7',27,'3','1',15.66,15.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','7',28,'4','1',379.01,379.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','8',29,'1','1',566.54,649.11,0.00,0.00,82.57,46899.76,0.00,0.00,0.00),('1','219','1','8',30,'2','1',576.69,663.93,0.00,0.00,87.24,49552.32,0.00,0.00,0.00),('1','219','1','8',31,'3','1',15.66,15.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','8',32,'4','1',379.01,429.01,0.00,0.00,50.00,27000.00,0.00,0.00,0.00),('1','219','1','9',33,'1','1',649.11,726.91,0.00,0.00,77.80,44190.40,0.00,0.00,0.00),('1','219','1','9',34,'2','1',663.93,762.16,0.00,0.00,98.23,55794.64,0.00,0.00,0.00),('1','219','1','9',35,'3','1',15.66,48.59,0.00,0.00,32.93,18704.24,0.00,0.00,0.00),('1','219','1','9',36,'4','1',429.01,429.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','10',37,'1','1',726.91,822.52,0.00,0.00,95.61,54306.48,0.00,0.00,0.00),('1','219','1','10',38,'2','1',762.16,795.02,0.00,0.00,32.86,18664.48,0.00,0.00,0.00),('1','219','1','10',39,'3','1',48.59,148.59,0.00,0.00,100.00,54000.00,0.00,0.00,0.00),('1','219','1','10',40,'4','1',429.01,479.01,0.00,0.00,50.00,27000.00,0.00,0.00,0.00),('1','219','1','11',41,'1','1',822.52,915.29,0.00,0.00,92.77,52693.36,0.00,0.00,0.00),('1','219','1','11',42,'2','1',795.02,902.91,0.00,0.00,107.89,61281.52,0.00,0.00,0.00),('1','219','1','11',43,'3','1',148.59,148.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','11',44,'4','1',479.01,479.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','12',45,'1','1',915.29,1052.03,0.00,0.00,136.74,77668.32,0.00,0.00,0.00),('1','219','1','12',46,'2','1',902.91,1052.64,0.00,0.00,149.73,85046.64,0.00,0.00,0.00),('1','219','1','12',47,'3','1',148.59,148.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','12',48,'4','1',479.01,479.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','13',49,'1','1',1052.03,1218.37,0.00,0.00,166.34,94481.12,0.00,0.00,0.00),('1','219','1','13',50,'2','1',1052.64,1198.67,0.00,0.00,146.03,82945.04,0.00,0.00,0.00),('1','219','1','13',51,'3','1',148.59,281.08,0.00,0.00,132.49,71544.60,0.00,0.00,0.00),('1','219','1','13',52,'4','1',479.01,833.39,0.00,0.00,354.38,191365.20,0.00,0.00,0.00),('1','219','1','14',53,'1','1',1218.37,1348.58,0.00,0.00,130.21,73959.28,0.00,0.00,0.00),('1','219','1','14',54,'2','1',1198.67,1376.25,0.00,0.00,177.58,100865.44,0.00,0.00,0.00),('1','219','1','14',55,'3','1',281.08,281.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','14',56,'4','1',833.39,873.39,0.00,0.00,40.00,21600.00,0.00,0.00,0.00),('1','219','1','15',57,'1','1',1348.58,1488.82,0.00,0.00,140.24,79656.32,0.00,0.00,0.00),('1','219','1','15',58,'2','1',1376.25,1513.48,0.00,0.00,137.23,77946.64,0.00,0.00,0.00),('1','219','1','15',59,'3','1',281.08,331.08,0.00,0.00,50.00,27000.00,0.00,0.00,0.00),('1','219','1','15',60,'4','1',873.39,987.56,0.00,0.00,114.17,61651.80,0.00,0.00,0.00),('1','219','1','16',61,'1','1',1488.82,1586.19,0.00,0.00,97.37,55306.16,0.00,0.00,0.00),('1','219','1','16',62,'2','1',1513.48,1612.47,0.00,0.00,98.99,56226.32,0.00,0.00,0.00),('1','219','1','16',63,'3','1',331.08,681.08,0.00,0.00,350.00,189000.00,0.00,0.00,0.00),('1','219','1','16',64,'4','1',987.56,1297.56,0.00,0.00,310.00,167400.00,0.00,0.00,0.00),('1','219','1','17',65,'1','1',1586.19,1618.90,0.00,0.00,32.71,18579.28,0.00,0.00,0.00),('1','219','1','17',66,'2','1',1612.47,1635.45,0.00,0.00,22.98,13052.64,0.00,0.00,0.00),('1','219','1','17',67,'3','1',681.08,1004.67,0.00,0.00,323.59,174738.60,0.00,0.00,0.00),('1','219','1','17',68,'4','1',1297.56,1540.56,0.00,0.00,243.00,131220.00,0.00,0.00,0.00),('1','219','1','18',69,'1','1',1618.90,1618.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','18',70,'2','1',1635.45,1635.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','18',71,'3','1',1004.67,1004.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','18',72,'4','1',1540.56,1540.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','19',73,'1','1',1618.90,1772.80,0.00,0.00,153.90,87415.20,0.00,0.00,0.00),('1','219','1','19',74,'2','1',1635.45,1871.01,0.00,0.00,235.56,133798.08,0.00,0.00,0.00),('1','219','1','19',75,'3','1',1004.67,2338.67,0.00,0.00,1334.00,720360.00,0.00,0.00,0.00),('1','219','1','19',76,'4','1',1540.56,2740.56,0.00,0.00,1200.00,648000.00,0.00,0.00,0.00),('1','219','1','20',77,'1','1',1772.80,1864.28,0.00,0.00,91.48,58547.20,0.00,0.00,0.00),('1','219','1','20',78,'2','1',1871.01,1987.62,0.00,0.00,116.61,74630.40,0.00,0.00,0.00),('1','219','1','20',79,'3','1',2338.67,2495.92,0.00,0.00,157.25,97495.00,0.00,0.00,0.00),('1','219','1','20',80,'4','1',2740.56,3005.96,0.00,0.00,265.40,164548.00,0.00,0.00,0.00),('1','219','1','21',81,'1','1',1864.28,1986.79,0.00,0.00,122.51,78406.40,0.00,0.00,0.00),('1','219','1','21',82,'2','1',1987.62,2106.35,0.00,0.00,118.73,75987.20,0.00,0.00,0.00),('1','219','1','21',83,'3','1',2495.92,3061.92,0.00,0.00,566.00,350920.00,0.00,0.00,0.00),('1','219','1','21',84,'4','1',3005.96,3379.46,0.00,0.00,373.50,231570.00,0.00,0.00,0.00),('1','219','1','22',85,'1','1',1986.79,2099.68,0.00,0.00,112.89,72249.60,0.00,0.00,0.00),('1','219','1','22',86,'2','1',2106.35,2223.79,0.00,0.00,117.44,75161.60,0.00,0.00,0.00),('1','219','1','22',87,'3','1',3061.92,3238.92,0.00,0.00,177.00,109740.00,0.00,0.00,0.00),('1','219','1','22',88,'4','1',3379.46,3466.46,0.00,0.00,87.00,53940.00,0.00,0.00,0.00),('1','219','1','23',89,'1','1',2099.68,2189.51,0.00,0.00,89.83,61084.40,0.00,0.00,0.00),('1','219','1','23',90,'2','1',2223.79,2299.58,0.00,0.00,75.79,51537.20,0.00,0.00,0.00),('1','219','1','23',91,'3','1',3238.92,3238.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','23',92,'4','1',3466.46,3466.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','24',93,'1','1',2189.51,2303.22,0.00,0.00,113.71,77322.80,0.00,0.00,0.00),('1','219','1','24',94,'2','1',2299.58,2408.67,0.00,0.00,109.09,74181.20,0.00,0.00,0.00),('1','219','1','24',95,'3','1',3238.92,3238.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','24',96,'4','1',3466.46,3482.95,0.00,0.00,16.49,10553.60,0.00,0.00,0.00),('1','219','1','25',97,'1','1',2303.22,2385.35,0.00,0.00,82.13,55848.40,0.00,0.00,0.00),('1','219','1','25',98,'2','1',2408.67,2469.24,0.00,0.00,60.57,41187.60,0.00,0.00,0.00),('1','219','1','25',99,'3','1',3238.92,3238.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','25',100,'4','1',3482.95,3491.95,0.00,0.00,9.00,5760.00,0.00,0.00,0.00),('1','219','1','26',101,'1','1',2385.35,2442.43,0.00,0.00,57.08,38814.40,0.00,0.00,0.00),('1','219','1','26',102,'2','1',2469.24,2500.33,0.00,0.00,31.09,21141.20,0.00,0.00,0.00),('1','219','1','26',103,'3','1',3238.92,3238.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','26',104,'4','1',3491.95,3491.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','27',105,'1','1',2442.43,2523.35,0.00,0.00,80.92,51788.80,0.00,0.00,0.00),('1','219','1','27',106,'2','1',2500.33,2548.42,0.00,0.00,48.09,30777.60,0.00,0.00,0.00),('1','219','1','27',107,'3','1',3238.92,3338.92,0.00,0.00,100.00,61600.00,0.00,0.00,0.00),('1','219','1','27',108,'4','1',3491.95,3550.95,0.00,0.00,59.00,36344.00,0.00,0.00,0.00),('1','219','1','28',109,'1','1',2523.35,2664.19,0.00,0.00,140.84,90137.60,0.00,0.00,0.00),('1','219','1','28',110,'2','1',2548.42,2616.74,0.00,0.00,68.32,43724.80,0.00,0.00,0.00),('1','219','1','28',111,'3','1',3338.92,3416.92,0.00,0.00,78.00,48048.00,0.00,0.00,0.00),('1','219','1','28',112,'4','1',3550.95,3609.95,0.00,0.00,59.00,36344.00,0.00,0.00,0.00),('1','219','1','29',113,'1','1',2664.19,2762.61,0.00,0.00,98.42,62988.80,0.00,0.00,0.00),('1','219','1','29',114,'2','1',2616.74,2759.46,0.00,0.00,142.72,91340.80,0.00,0.00,0.00),('1','219','1','29',115,'3','1',3416.92,3479.42,0.00,0.00,62.50,38500.00,0.00,0.00,0.00),('1','219','1','29',116,'4','1',3609.95,3609.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','30',117,'1','1',2762.61,2881.72,0.00,0.00,119.11,76230.40,0.00,0.00,0.00),('1','219','1','30',118,'2','1',2759.46,2888.95,0.00,0.00,129.49,82873.60,0.00,0.00,0.00),('1','219','1','30',119,'3','1',3479.42,3578.24,0.00,0.00,98.82,60873.12,0.00,0.00,0.00),('1','219','1','30',120,'4','1',3609.95,3609.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','31',121,'1','1',2881.72,3009.30,0.00,0.00,127.58,81651.20,0.00,0.00,0.00),('1','219','1','31',122,'2','1',2888.95,2992.15,0.00,0.00,103.20,66048.00,0.00,0.00,0.00),('1','219','1','31',123,'3','1',3578.24,3607.74,0.00,0.00,29.50,18172.00,0.00,0.00,0.00),('1','219','1','31',124,'4','1',3609.95,3609.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','32',125,'1','1',3009.30,3096.37,0.00,0.00,87.07,55724.80,0.00,0.00,0.00),('1','219','1','32',126,'2','1',2992.15,3053.41,0.00,0.00,61.26,39206.40,0.00,0.00,0.00),('1','219','1','32',127,'3','1',3607.74,3662.74,0.00,0.00,55.00,33880.00,0.00,0.00,0.00),('1','219','1','32',128,'4','1',3609.95,3664.95,0.00,0.00,55.00,33880.00,0.00,0.00,0.00),('1','219','1','33',129,'1','1',3096.37,3268.59,0.00,0.00,172.22,110220.80,0.00,0.00,0.00),('1','219','1','33',130,'2','1',3053.41,3234.22,0.00,0.00,180.81,115718.40,0.00,0.00,0.00),('1','219','1','33',131,'3','1',3662.74,3672.74,0.00,0.00,10.00,6160.00,0.00,0.00,0.00),('1','219','1','33',132,'4','1',3664.95,3664.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','34',133,'1','1',3268.59,3371.28,0.00,0.00,102.69,65721.60,0.00,0.00,0.00),('1','219','1','34',134,'2','1',3234.22,3310.53,0.00,0.00,76.31,48838.40,0.00,0.00,0.00),('1','219','1','34',135,'3','1',3672.74,3727.93,0.00,0.00,55.19,33997.04,0.00,0.00,0.00),('1','219','1','34',136,'4','1',3664.95,3664.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','35',137,'1','1',3371.28,3454.19,0.00,0.00,82.91,53062.40,0.00,0.00,0.00),('1','219','1','35',138,'2','1',3310.53,3415.37,0.00,0.00,104.84,67097.60,0.00,0.00,0.00),('1','219','1','35',139,'3','1',3727.93,3783.93,0.00,0.00,56.00,34496.00,0.00,0.00,0.00),('1','219','1','35',140,'4','1',3664.95,3664.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','36',141,'1','1',3454.19,3604.66,0.00,0.00,150.47,102319.60,0.00,0.00,0.00),('1','219','1','36',142,'2','1',3415.37,3560.58,0.00,0.00,145.21,98742.80,0.00,0.00,0.00),('1','219','1','36',143,'3','1',3783.93,3960.23,0.00,0.00,176.30,113184.60,0.00,0.00,0.00),('1','219','1','36',144,'4','1',3664.95,3739.95,0.00,0.00,75.00,48150.00,0.00,0.00,0.00),('1','219','1','37',145,'1','1',3604.66,3728.58,0.00,0.00,123.92,84265.60,0.00,0.00,0.00),('1','219','1','37',146,'2','1',3560.58,3730.90,0.00,0.00,170.32,115817.60,0.00,0.00,0.00),('1','219','1','37',147,'3','1',3960.23,4010.23,0.00,0.00,50.00,32100.00,0.00,0.00,0.00),('1','219','1','37',148,'4','1',3739.95,3739.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','38',149,'1','1',3728.58,3875.12,0.00,0.00,146.54,99647.20,0.00,0.00,0.00),('1','219','1','38',150,'2','1',3730.90,3874.02,0.00,0.00,143.12,97321.60,0.00,0.00,0.00),('1','219','1','38',151,'3','1',4010.23,4066.73,0.00,0.00,56.50,36273.00,0.00,0.00,0.00),('1','219','1','38',152,'4','1',3739.95,3739.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','39',153,'1','1',3875.12,4011.98,0.00,0.00,136.86,93064.80,0.00,0.00,0.00),('1','219','1','39',154,'2','1',3874.02,4035.12,0.00,0.00,161.10,109548.00,0.00,0.00,0.00),('1','219','1','39',155,'3','1',4066.73,4176.73,0.00,0.00,110.00,70620.00,0.00,0.00,0.00),('1','219','1','39',156,'4','1',3739.95,3739.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','40',157,'1','1',4011.98,4264.14,0.00,0.00,252.16,161382.40,0.00,0.00,0.00),('1','219','1','40',158,'2','1',4035.12,4238.21,0.00,0.00,203.09,129977.60,0.00,0.00,0.00),('1','219','1','40',159,'3','1',4176.73,4545.23,0.00,0.00,368.50,228470.00,0.00,0.00,0.00),('1','219','1','40',160,'4','1',3739.95,3739.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','41',161,'1','1',4264.14,4391.35,0.00,0.00,127.21,81414.40,0.00,0.00,0.00),('1','219','1','41',162,'2','1',4238.21,4347.70,0.00,0.00,109.49,70073.60,0.00,0.00,0.00),('1','219','1','41',163,'3','1',4545.23,4824.31,0.00,0.00,279.08,173029.60,0.00,0.00,0.00),('1','219','1','41',164,'4','1',3739.95,3789.95,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','219','1','42',165,'1','1',4391.35,4572.32,0.00,0.00,180.97,115820.80,0.00,0.00,0.00),('1','219','1','42',166,'2','1',4347.70,4504.55,0.00,0.00,156.85,100384.00,0.00,0.00,0.00),('1','219','1','42',167,'3','1',4824.31,5353.31,0.00,0.00,529.00,327980.00,0.00,0.00,0.00),('1','219','1','42',168,'4','1',3789.95,4121.30,0.00,0.00,331.35,205437.00,0.00,0.00,0.00),('1','219','1','43',169,'1','1',4572.32,5092.66,0.00,0.00,520.34,333017.60,0.00,0.00,0.00),('1','219','1','43',170,'2','1',4504.55,5678.21,0.00,0.00,1173.66,730658.20,0.00,0.00,0.00),('1','219','1','43',171,'3','1',5353.31,7302.09,0.00,0.00,1948.78,1208243.60,0.00,0.00,0.00),('1','219','1','43',172,'4','1',4121.30,5031.30,0.00,0.00,910.00,564200.00,0.00,0.00,0.00),('1','219','1','44',173,'1','1',5092.66,5381.99,0.00,0.00,289.33,185171.20,0.00,0.00,0.00),('1','219','1','44',174,'2','1',5678.21,5678.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','44',175,'3','1',7302.09,7652.45,0.00,0.00,350.36,217223.20,0.00,0.00,0.00),('1','219','1','44',176,'4','1',5031.30,5575.20,0.00,0.00,543.90,337218.00,0.00,0.00,0.00),('1','219','1','45',177,'1','1',5381.99,5736.24,0.00,0.00,354.25,226720.00,0.00,0.00,0.00),('1','219','1','45',178,'2','1',5678.21,5838.50,0.00,0.00,160.29,102585.60,0.00,0.00,0.00),('1','219','1','45',179,'3','1',7652.45,9056.35,0.00,0.00,1403.90,870418.00,0.00,0.00,0.00),('1','219','1','45',180,'4','1',5575.20,7195.83,0.00,0.00,1620.63,1004790.60,0.00,0.00,0.00),('1','219','1','46',181,'1','1',5736.24,5881.28,0.00,0.00,145.04,92825.60,0.00,0.00,0.00),('1','219','1','46',182,'2','1',5838.50,5942.88,0.00,0.00,104.38,66803.20,0.00,0.00,0.00),('1','219','1','46',183,'3','1',9056.35,9596.35,0.00,0.00,540.00,334800.00,0.00,0.00,0.00),('1','219','1','46',184,'4','1',7195.83,7578.83,0.00,0.00,383.00,237460.00,0.00,0.00,0.00),('1','219','1','47',185,'1','1',5881.28,5998.55,0.00,0.00,117.27,75052.80,0.00,0.00,0.00),('1','219','1','47',186,'2','1',5942.88,6098.08,0.00,0.00,155.20,99328.00,0.00,0.00,0.00),('1','219','1','47',187,'3','1',9596.35,9851.76,0.00,0.00,255.41,158354.20,0.00,0.00,0.00),('1','219','1','47',188,'4','1',7578.83,7881.77,0.00,0.00,302.94,187822.80,0.00,0.00,0.00),('1','219','1','48',189,'1','1',5998.55,6167.06,0.00,0.00,168.51,107846.40,0.00,0.00,0.00),('1','219','1','48',190,'2','1',6098.08,6225.53,0.00,0.00,127.45,81568.00,0.00,0.00,0.00),('1','219','1','48',191,'3','1',9851.76,10085.76,0.00,0.00,234.00,145080.00,0.00,0.00,0.00),('1','219','1','48',192,'4','1',7881.77,7915.64,0.00,0.00,33.87,20999.40,0.00,0.00,0.00),('1','219','1','49',193,'1','1',6167.06,6333.38,0.00,0.00,166.32,106444.80,0.00,0.00,0.00),('1','219','1','49',194,'2','1',6225.53,6355.19,0.00,0.00,129.66,82982.40,0.00,0.00,0.00),('1','219','1','49',195,'3','1',10085.76,10675.67,0.00,0.00,589.91,365744.20,0.00,0.00,0.00),('1','219','1','49',196,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','50',197,'1','1',6333.38,6444.97,0.00,0.00,111.59,71417.60,0.00,0.00,0.00),('1','219','1','50',198,'2','1',6355.19,6479.65,0.00,0.00,124.46,79654.40,0.00,0.00,0.00),('1','219','1','50',199,'3','1',10675.67,11040.17,0.00,0.00,364.50,225990.00,0.00,0.00,0.00),('1','219','1','50',200,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','51',201,'1','1',6444.97,6594.59,0.00,0.00,149.62,95756.80,0.00,0.00,0.00),('1','219','1','51',202,'2','1',6479.65,6592.77,0.00,0.00,113.12,72396.80,0.00,0.00,0.00),('1','219','1','51',203,'3','1',11040.17,11214.17,0.00,0.00,174.00,107880.00,0.00,0.00,0.00),('1','219','1','51',204,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','52',205,'1','1',6594.59,6740.88,0.00,0.00,146.29,93625.60,0.00,0.00,0.00),('1','219','1','52',206,'2','1',6592.77,6700.78,0.00,0.00,108.01,69126.40,0.00,0.00,0.00),('1','219','1','52',207,'3','1',11214.17,11294.17,0.00,0.00,80.00,49600.00,0.00,0.00,0.00),('1','219','1','52',208,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','53',209,'1','1',6740.88,6901.07,0.00,0.00,160.19,102521.60,0.00,0.00,0.00),('1','219','1','53',210,'2','1',6700.78,6833.23,0.00,0.00,132.45,84768.00,0.00,0.00,0.00),('1','219','1','53',211,'3','1',11294.17,11400.17,0.00,0.00,106.00,65720.00,0.00,0.00,0.00),('1','219','1','53',212,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','54',213,'1','1',6901.07,7033.70,0.00,0.00,132.63,84883.20,0.00,0.00,0.00),('1','219','1','54',214,'2','1',6833.23,6921.53,0.00,0.00,88.30,56512.00,0.00,0.00,0.00),('1','219','1','54',215,'3','1',11400.17,11472.17,0.00,0.00,72.00,44640.00,0.00,0.00,0.00),('1','219','1','54',216,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','55',217,'1','1',7033.70,7145.96,0.00,0.00,112.26,71846.40,0.00,0.00,0.00),('1','219','1','55',218,'2','1',6921.53,7018.74,0.00,0.00,97.21,62214.40,0.00,0.00,0.00),('1','219','1','55',219,'3','1',11472.17,11588.17,0.00,0.00,116.00,71920.00,0.00,0.00,0.00),('1','219','1','55',220,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','56',221,'1','1',7145.96,7276.59,0.00,0.00,130.63,83603.20,0.00,0.00,0.00),('1','219','1','56',222,'2','1',7018.74,7125.86,0.00,0.00,107.12,68556.80,0.00,0.00,0.00),('1','219','1','56',223,'3','1',11588.17,11692.25,0.00,0.00,104.08,64529.60,0.00,0.00,0.00),('1','219','1','56',224,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','57',225,'1','1',7276.59,7379.49,0.00,0.00,102.90,65856.00,0.00,0.00,0.00),('1','219','1','57',226,'2','1',7125.86,7234.52,0.00,0.00,108.66,69542.40,0.00,0.00,0.00),('1','219','1','57',227,'3','1',11692.25,11731.50,0.00,0.00,39.25,24335.00,0.00,0.00,0.00),('1','219','1','57',228,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','58',229,'1','1',7379.49,7464.63,0.00,0.00,85.14,54489.60,0.00,0.00,0.00),('1','219','1','58',230,'2','1',7234.52,7306.35,0.00,0.00,71.83,45971.20,0.00,0.00,0.00),('1','219','1','58',231,'3','1',11731.50,11824.50,0.00,0.00,93.00,57660.00,0.00,0.00,0.00),('1','219','1','58',232,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','59',233,'1','1',7464.63,7556.91,0.00,0.00,92.28,59059.20,0.00,0.00,0.00),('1','219','1','59',234,'2','1',7306.35,7421.99,0.00,0.00,115.64,74009.60,0.00,0.00,0.00),('1','219','1','59',235,'3','1',11824.50,11861.70,0.00,0.00,37.20,23064.00,0.00,0.00,0.00),('1','219','1','59',236,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','60',237,'1','1',7556.91,7600.92,0.00,0.00,44.01,28166.40,0.00,0.00,0.00),('1','219','1','60',238,'2','1',7421.99,7463.82,0.00,0.00,41.83,26771.20,0.00,0.00,0.00),('1','219','1','60',239,'3','1',11861.70,11923.70,0.00,0.00,62.00,38440.00,0.00,0.00,0.00),('1','219','1','60',240,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','61',241,'1','1',7600.92,7679.52,0.00,0.00,78.60,50304.00,0.00,0.00,0.00),('1','219','1','61',242,'2','1',7463.82,7518.31,0.00,0.00,54.49,34873.60,0.00,0.00,0.00),('1','219','1','61',243,'3','1',11923.70,11923.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','61',244,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','62',245,'1','1',7679.52,7832.50,0.00,0.00,152.98,97335.28,0.00,0.00,0.00),('1','219','1','62',246,'2','1',7518.31,7688.96,0.00,0.00,170.65,108564.64,0.00,0.00,0.00),('1','219','1','62',247,'3','1',11923.70,12035.70,0.00,0.00,112.00,68768.00,0.00,0.00,0.00),('1','219','1','62',248,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','63',249,'1','1',7832.50,8005.11,0.00,0.00,172.61,109779.96,0.00,0.00,0.00),('1','219','1','63',250,'2','1',7688.96,7808.78,0.00,0.00,119.82,76205.52,0.00,0.00,0.00),('1','219','1','63',251,'3','1',12035.70,12350.20,0.00,0.00,314.50,193103.00,0.00,0.00,0.00),('1','219','1','63',252,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','64',253,'1','1',8005.11,8135.33,0.00,0.00,130.22,82819.92,0.00,0.00,0.00),('1','219','1','64',254,'2','1',7808.78,7919.06,0.00,0.00,110.28,70138.08,0.00,0.00,0.00),('1','219','1','64',255,'3','1',12350.20,12417.65,0.00,0.00,67.45,41414.30,0.00,0.00,0.00),('1','219','1','64',256,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','65',257,'1','1',8135.33,8219.49,0.00,0.00,84.16,53525.76,0.00,0.00,0.00),('1','219','1','65',258,'2','1',7919.06,8006.28,0.00,0.00,87.22,55471.92,0.00,0.00,0.00),('1','219','1','65',259,'3','1',12417.65,12427.65,0.00,0.00,10.00,6140.00,0.00,0.00,0.00),('1','219','1','65',260,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','66',261,'1','1',8219.49,8278.91,0.00,0.00,59.42,37791.12,0.00,0.00,0.00),('1','219','1','66',262,'2','1',8006.28,8116.67,0.00,0.00,110.39,70208.04,0.00,0.00,0.00),('1','219','1','66',263,'3','1',12427.65,12528.15,0.00,0.00,100.50,61707.00,0.00,0.00,0.00),('1','219','1','66',264,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','67',265,'1','1',8278.91,8435.19,0.00,0.00,156.28,99394.08,0.00,0.00,0.00),('1','219','1','67',266,'2','1',8116.67,8272.40,0.00,0.00,155.73,99044.28,0.00,0.00,0.00),('1','219','1','67',267,'3','1',12528.15,12725.71,0.00,0.00,197.56,121301.84,0.00,0.00,0.00),('1','219','1','67',268,'4','1',7915.64,7915.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','68',269,'1','1',8435.19,8542.52,0.00,0.00,107.33,68261.88,0.00,0.00,0.00),('1','219','1','68',270,'2','1',8272.40,8382.14,0.00,0.00,109.74,69794.64,0.00,0.00,0.00),('1','219','1','68',271,'3','1',12725.71,13229.71,0.00,0.00,504.00,309456.00,0.00,0.00,0.00),('1','219','1','68',272,'4','1',7915.64,7932.87,0.00,0.00,17.23,86.15,0.00,0.00,0.00),('1','219','1','69',273,'1','1',8542.52,8660.70,0.00,0.00,118.18,75162.48,0.00,0.00,0.00),('1','219','1','69',274,'2','1',8382.14,8479.44,0.00,0.00,97.30,61882.80,0.00,0.00,0.00),('1','219','1','69',275,'3','1',13229.71,13286.71,0.00,0.00,57.00,34998.00,0.00,0.00,0.00),('1','219','1','69',276,'4','1',7932.87,7932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','70',277,'1','1',8660.70,8790.17,0.00,0.00,129.47,82342.92,0.00,0.00,0.00),('1','219','1','70',278,'2','1',8479.44,8611.72,0.00,0.00,132.28,84130.08,0.00,0.00,0.00),('1','219','1','70',279,'3','1',13286.71,13421.30,0.00,0.00,134.59,82638.26,0.00,0.00,0.00),('1','219','1','70',280,'4','1',7932.87,7932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','71',281,'1','1',8790.17,8893.50,0.00,0.00,103.33,65717.88,0.00,0.00,0.00),('1','219','1','71',282,'2','1',8611.72,8749.99,0.00,0.00,138.27,87939.72,0.00,0.00,0.00),('1','219','1','71',283,'3','1',13421.30,13430.30,0.00,0.00,9.00,5526.00,0.00,0.00,0.00),('1','219','1','71',284,'4','1',7932.87,7932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','72',285,'1','1',8893.50,8956.90,0.00,0.00,63.40,40322.40,0.00,0.00,0.00),('1','219','1','72',286,'2','1',8749.99,8799.08,0.00,0.00,49.09,31221.24,0.00,0.00,0.00),('1','219','1','72',287,'3','1',13430.30,13442.80,0.00,0.00,12.50,7675.00,0.00,0.00,0.00),('1','219','1','72',288,'4','1',7932.87,7932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','73',289,'1','1',8956.90,9047.47,0.00,0.00,90.57,57602.52,0.00,0.00,0.00),('1','219','1','73',290,'2','1',8799.08,8844.79,0.00,0.00,45.71,29071.56,0.00,0.00,0.00),('1','219','1','73',291,'3','1',13442.80,13455.30,0.00,0.00,12.50,7675.00,0.00,0.00,0.00),('1','219','1','73',292,'4','1',7932.87,7932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','74',293,'1','1',9047.47,9139.91,0.00,0.00,92.44,58791.84,0.00,0.00,0.00),('1','219','1','74',294,'2','1',8844.79,8971.30,0.00,0.00,126.51,80460.36,0.00,0.00,0.00),('1','219','1','74',295,'3','1',13455.30,13517.80,0.00,0.00,62.50,38375.00,0.00,0.00,0.00),('1','219','1','74',296,'4','1',7932.87,7932.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','75',297,'1','1',9139.91,9579.52,0.00,0.00,439.61,279591.96,0.00,0.00,0.00),('1','219','1','75',298,'2','1',8971.30,9008.92,0.00,0.00,37.62,23926.32,0.00,0.00,0.00),('1','219','1','75',299,'3','1',13517.80,13594.81,0.00,0.00,77.01,47284.14,0.00,0.00,0.00),('1','219','1','75',300,'4','1',7932.87,8032.87,0.00,0.00,100.00,61400.00,0.00,0.00,0.00),('1','219','1','76',301,'1','1',9579.52,10084.12,0.00,0.00,504.60,320925.60,0.00,0.00,0.00),('1','219','1','76',302,'2','1',9008.92,9008.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','76',303,'3','1',13594.81,13600.81,0.00,0.00,6.00,3684.00,0.00,0.00,0.00),('1','219','1','76',304,'4','1',8032.87,8398.87,0.00,0.00,366.00,224724.00,0.00,0.00,0.00),('1','219','1','77',305,'1','1',10084.12,10283.01,0.00,0.00,198.89,122118.46,0.00,0.00,0.00),('1','219','1','77',306,'2','1',9008.92,9196.92,0.00,0.00,188.00,115432.00,0.00,0.00,0.00),('1','219','1','77',307,'3','1',13600.81,13694.42,0.00,0.00,93.61,59535.96,0.00,0.00,0.00),('1','219','1','77',308,'4','1',8398.87,8542.52,0.00,0.00,143.65,91361.40,0.00,0.00,0.00),('1','219','1','78',309,'1','1',10283.01,10636.64,0.00,0.00,353.63,223346.68,0.00,0.00,0.00),('1','219','1','78',310,'2','1',9196.92,9301.92,0.00,0.00,105.00,64470.00,0.00,0.00,0.00),('1','219','1','78',311,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','78',312,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','79',313,'1','1',10636.64,10915.57,0.00,0.00,278.93,177399.48,0.00,0.00,0.00),('1','219','1','79',314,'2','1',9301.92,9407.92,0.00,0.00,106.00,65084.00,0.00,0.00,0.00),('1','219','1','79',315,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','79',316,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','80',317,'1','1',10915.57,11363.03,0.00,0.00,447.46,284584.56,0.00,0.00,0.00),('1','219','1','80',318,'2','1',9407.92,9829.42,0.00,0.00,421.50,258801.00,0.00,0.00,0.00),('1','219','1','80',319,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','80',320,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','81',321,'1','1',11363.03,11817.66,0.00,0.00,454.63,289144.68,0.00,0.00,0.00),('1','219','1','81',322,'2','1',9829.42,9951.04,0.00,0.00,121.62,74674.68,0.00,0.00,0.00),('1','219','1','81',323,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','81',324,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','82',325,'1','1',11817.66,12187.87,0.00,0.00,370.21,235453.56,0.00,0.00,0.00),('1','219','1','82',326,'2','1',9951.04,10310.04,0.00,0.00,359.00,220426.00,0.00,0.00,0.00),('1','219','1','82',327,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','82',328,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','83',329,'1','1',12187.87,12322.60,0.00,0.00,134.73,85688.28,0.00,0.00,0.00),('1','219','1','83',330,'2','1',10310.04,10321.11,0.00,0.00,11.07,6796.98,0.00,0.00,0.00),('1','219','1','83',331,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','83',332,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','84',333,'1','1',12322.60,12433.18,0.00,0.00,110.58,70328.88,0.00,0.00,0.00),('1','219','1','84',334,'2','1',10321.11,10637.69,0.00,0.00,316.58,194380.12,0.00,0.00,0.00),('1','219','1','84',335,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','84',336,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','85',337,'1','1',12433.18,12820.38,0.00,0.00,387.20,246259.20,0.00,0.00,0.00),('1','219','1','85',338,'2','1',10637.69,10922.65,0.00,0.00,284.96,174965.44,0.00,0.00,0.00),('1','219','1','85',339,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','85',340,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','86',341,'1','1',12820.38,13218.05,0.00,0.00,397.67,252918.12,0.00,0.00,0.00),('1','219','1','86',342,'2','1',10922.65,11138.65,0.00,0.00,216.00,132624.00,0.00,0.00,0.00),('1','219','1','86',343,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','86',344,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','87',345,'1','1',13218.05,13643.72,0.00,0.00,425.67,270726.12,0.00,0.00,0.00),('1','219','1','87',346,'2','1',11138.65,11499.15,0.00,0.00,360.50,221347.00,0.00,0.00,0.00),('1','219','1','87',347,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','87',348,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','88',349,'1','1',13643.72,13953.90,0.00,0.00,310.18,197274.48,0.00,0.00,0.00),('1','219','1','88',350,'2','1',11499.15,11554.15,0.00,0.00,55.00,33770.00,0.00,0.00,0.00),('1','219','1','88',351,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','88',352,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','89',353,'1','1',13953.90,14244.27,0.00,0.00,290.37,184675.32,0.00,0.00,0.00),('1','219','1','89',354,'2','1',11554.15,11572.65,0.00,0.00,18.50,11359.00,0.00,0.00,0.00),('1','219','1','89',355,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','89',356,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','90',357,'1','1',14244.27,14612.98,0.00,0.00,368.71,234499.56,0.00,0.00,0.00),('1','219','1','90',358,'2','1',11572.65,11668.15,0.00,0.00,95.50,58637.00,0.00,0.00,0.00),('1','219','1','90',359,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','90',360,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','91',361,'1','1',14612.98,14978.35,0.00,0.00,365.37,254297.52,0.00,0.00,0.00),('1','219','1','91',362,'2','1',11668.15,11692.15,0.00,0.00,24.00,15648.00,0.00,0.00,0.00),('1','219','1','91',363,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','91',364,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','92',365,'1','1',14978.35,15342.09,0.00,0.00,363.74,253163.04,0.00,0.00,0.00),('1','219','1','92',366,'2','1',11692.15,12008.15,0.00,0.00,316.00,206032.00,0.00,0.00,0.00),('1','219','1','92',367,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','92',368,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','93',369,'1','1',15342.09,15714.97,0.00,0.00,372.88,259524.48,0.00,0.00,0.00),('1','219','1','93',370,'2','1',12008.15,12055.24,0.00,0.00,47.09,30702.68,0.00,0.00,0.00),('1','219','1','93',371,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','93',372,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','94',373,'1','1',15714.97,16092.60,0.00,0.00,377.63,262830.48,0.00,0.00,0.00),('1','219','1','94',374,'2','1',12055.24,12069.31,0.00,0.00,14.07,9173.64,0.00,0.00,0.00),('1','219','1','94',375,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','94',376,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','95',377,'1','1',16092.60,16427.37,0.00,0.00,334.77,232999.92,0.00,0.00,0.00),('1','219','1','95',378,'2','1',12069.31,12078.06,0.00,0.00,8.75,5958.00,0.00,0.00,0.00),('1','219','1','95',379,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','95',380,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','96',381,'1','1',16427.37,16442.31,0.00,0.00,14.94,10398.24,0.00,0.00,0.00),('1','219','1','96',382,'2','1',12078.06,12078.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','96',383,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','96',384,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','97',385,'1','1',16442.31,16677.68,0.00,0.00,235.37,163817.52,0.00,0.00,0.00),('1','219','1','97',386,'2','1',12078.06,12145.56,0.00,0.00,67.50,44010.00,0.00,0.00,0.00),('1','219','1','97',387,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','97',388,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','98',389,'1','1',16677.68,16756.75,0.00,0.00,79.07,55032.72,0.00,0.00,0.00),('1','219','1','98',390,'2','1',12145.56,12158.06,0.00,0.00,12.50,8150.00,0.00,0.00,0.00),('1','219','1','98',391,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','98',392,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','99',393,'1','1',16756.75,17007.64,0.00,0.00,250.89,170605.20,0.00,0.00,0.00),('1','219','1','99',394,'2','1',12158.06,12164.06,0.00,0.00,6.00,3840.00,0.00,0.00,0.00),('1','219','1','99',395,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','99',396,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','100',397,'1','1',17007.64,17307.27,0.00,0.00,299.63,203748.40,0.00,0.00,0.00),('1','219','1','100',398,'2','1',12164.06,12478.56,0.00,0.00,314.50,201280.00,0.00,0.00,0.00),('1','219','1','100',399,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','100',400,'4','1',8542.52,8542.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','101',401,'1','1',17307.27,17587.97,0.00,0.00,280.70,190876.00,0.00,0.00,0.00),('1','219','1','101',402,'2','1',12478.56,12788.56,0.00,0.00,310.00,198400.00,0.00,0.00,0.00),('1','219','1','101',403,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','101',404,'4','1',8542.52,8544.58,0.00,0.00,2.06,1400.80,0.00,0.00,0.00),('1','219','1','102',405,'1','1',17587.97,17827.78,0.00,0.00,239.81,163070.80,0.00,0.00,0.00),('1','219','1','102',406,'2','1',12788.56,12864.61,0.00,0.00,76.05,48672.00,0.00,0.00,0.00),('1','219','1','102',407,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','102',408,'4','1',8544.58,8544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','103',409,'1','1',17827.78,18099.54,0.00,0.00,271.76,201102.40,0.00,0.00,0.00),('1','219','1','103',410,'2','1',12864.61,12873.48,0.00,0.00,8.87,6173.52,0.00,0.00,0.00),('1','219','1','103',411,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','103',412,'4','1',8544.58,8544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','104',413,'1','1',18099.54,18327.78,0.00,0.00,228.24,168897.60,0.00,0.00,0.00),('1','219','1','104',414,'2','1',12873.48,12951.48,0.00,0.00,78.00,54288.00,0.00,0.00,0.00),('1','219','1','104',415,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','104',416,'4','1',8544.58,8544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','105',417,'1','1',18327.78,18626.27,0.00,0.00,298.49,220882.60,0.00,0.00,0.00),('1','219','1','105',418,'2','1',12951.48,13071.54,0.00,0.00,120.06,83561.76,0.00,0.00,0.00),('1','219','1','105',419,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','105',420,'4','1',8544.58,8544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','106',421,'1','1',18626.27,18951.68,0.00,0.00,325.41,240803.40,0.00,0.00,0.00),('1','219','1','106',422,'2','1',13071.54,13123.54,0.00,0.00,52.00,36192.00,0.00,0.00,0.00),('1','219','1','106',423,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','106',424,'4','1',8544.58,8544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','107',425,'1','1',18951.68,19355.49,0.00,0.00,403.81,282667.00,0.00,0.00,0.00),('1','219','1','107',426,'2','1',13123.54,13241.54,0.00,0.00,118.00,82128.00,0.00,0.00,0.00),('1','219','1','107',427,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','107',428,'4','1',8544.58,8545.58,0.00,0.00,1.00,700.00,0.00,0.00,0.00),('1','219','1','108',429,'1','1',19355.49,19722.65,0.00,0.00,367.16,257012.00,0.00,0.00,0.00),('1','219','1','108',430,'2','1',13241.54,13241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','108',431,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','108',432,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','109',433,'1','1',19722.65,20078.33,0.00,0.00,355.68,241862.40,0.00,0.00,0.00),('1','219','1','109',434,'2','1',13241.54,13241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','109',435,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','109',436,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','110',437,'1','1',20078.33,20494.02,0.00,0.00,415.69,282669.20,0.00,0.00,0.00),('1','219','1','110',438,'2','1',13241.54,13250.54,0.00,0.00,9.00,5958.00,0.00,0.00,0.00),('1','219','1','110',439,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','110',440,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','111',441,'1','1',20494.02,20829.57,0.00,0.00,335.55,228174.00,0.00,0.00,0.00),('1','219','1','111',442,'2','1',13250.54,13319.04,0.00,0.00,68.50,45347.00,0.00,0.00,0.00),('1','219','1','111',443,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','111',444,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','112',445,'1','1',20829.57,21061.37,0.00,0.00,231.80,157624.00,0.00,0.00,0.00),('1','219','1','112',446,'2','1',13319.04,13355.04,0.00,0.00,36.00,23832.00,0.00,0.00,0.00),('1','219','1','112',447,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','112',448,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','113',449,'1','1',21061.37,21193.79,0.00,0.00,132.42,90045.60,0.00,0.00,0.00),('1','219','1','113',450,'2','1',13355.04,13393.81,0.00,0.00,38.77,25665.74,0.00,0.00,0.00),('1','219','1','113',451,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','113',452,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','114',453,'1','1',21193.79,21623.76,0.00,0.00,429.97,292379.60,0.00,0.00,0.00),('1','219','1','114',454,'2','1',13393.81,13504.52,0.00,0.00,110.71,73290.02,0.00,0.00,0.00),('1','219','1','114',455,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','114',456,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','115',457,'1','1',21623.76,21948.77,0.00,0.00,325.01,221006.80,0.00,0.00,0.00),('1','219','1','115',458,'2','1',13504.52,13535.89,0.00,0.00,31.37,20819.86,0.00,0.00,0.00),('1','219','1','115',459,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','115',460,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','116',461,'1','1',21948.77,22324.12,0.00,0.00,375.35,255238.00,0.00,0.00,0.00),('1','219','1','116',462,'2','1',13535.89,13601.41,0.00,0.00,65.52,43374.24,0.00,0.00,0.00),('1','219','1','116',463,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','116',464,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','117',465,'1','1',22324.12,22730.67,0.00,0.00,406.55,276454.00,0.00,0.00,0.00),('1','219','1','117',466,'2','1',13601.41,13612.41,0.00,0.00,11.00,7390.00,0.00,0.00,0.00),('1','219','1','117',467,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','117',468,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','118',469,'1','1',22730.67,23138.56,0.00,0.00,407.89,277365.20,0.00,0.00,0.00),('1','219','1','118',470,'2','1',13612.41,13739.18,0.00,0.00,126.77,83921.74,0.00,0.00,0.00),('1','219','1','118',471,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','118',472,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','119',473,'1','1',23138.56,23403.28,0.00,0.00,264.72,180009.60,0.00,0.00,0.00),('1','219','1','119',474,'2','1',13739.18,13766.68,0.00,0.00,27.50,18205.00,0.00,0.00,0.00),('1','219','1','119',475,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','119',476,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','120',477,'1','1',23403.28,23730.79,0.00,0.00,327.51,245632.50,0.00,0.00,0.00),('1','219','1','120',478,'2','1',13766.68,14009.18,0.00,0.00,242.50,172175.00,0.00,0.00,0.00),('1','219','1','120',479,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','120',480,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','121',481,'1','1',23730.79,24007.60,0.00,0.00,276.81,207607.50,0.00,0.00,0.00),('1','219','1','121',482,'2','1',14009.18,14069.45,0.00,0.00,60.27,42791.70,0.00,0.00,0.00),('1','219','1','121',483,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','121',484,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','122',485,'1','1',24007.60,24356.55,0.00,0.00,348.95,261712.50,0.00,0.00,0.00),('1','219','1','122',486,'2','1',14069.45,14074.45,0.00,0.00,5.00,3550.00,0.00,0.00,0.00),('1','219','1','122',487,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','122',488,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','123',489,'1','1',24356.55,24555.36,0.00,0.00,198.81,149107.50,0.00,0.00,0.00),('1','219','1','123',490,'2','1',14074.45,14135.45,0.00,0.00,61.00,43310.00,0.00,0.00,0.00),('1','219','1','123',491,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','123',492,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','124',493,'1','1',24555.36,24943.21,0.00,0.00,387.85,211725.00,0.00,0.00,0.00),('1','219','1','124',494,'2','1',14135.45,14138.94,0.00,0.00,3.49,2477.90,0.00,0.00,0.00),('1','219','1','124',495,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','124',496,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','125',497,'1','1',24943.21,25222.73,0.00,0.00,279.52,209640.00,0.00,0.00,0.00),('1','219','1','125',498,'2','1',14138.94,14389.94,0.00,0.00,251.00,178210.00,0.00,0.00,0.00),('1','219','1','125',499,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','125',500,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','126',501,'1','1',25222.73,25696.06,0.00,0.00,473.33,354997.50,0.00,0.00,0.00),('1','219','1','126',502,'2','1',14389.94,14449.44,0.00,0.00,59.50,42245.00,0.00,0.00,0.00),('1','219','1','126',503,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','126',504,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','127',505,'1','1',25696.06,25872.10,0.00,0.00,176.04,132030.00,0.00,0.00,0.00),('1','219','1','127',506,'2','1',14449.44,14483.44,0.00,0.00,34.00,24140.00,0.00,0.00,0.00),('1','219','1','127',507,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','127',508,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','128',509,'1','1',25872.10,26012.46,0.00,0.00,140.36,105270.00,0.00,0.00,0.00),('1','219','1','128',510,'2','1',14483.44,14496.78,0.00,0.00,13.34,9471.40,0.00,0.00,0.00),('1','219','1','128',511,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','128',512,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','129',513,'1','1',26012.46,26480.68,0.00,0.00,468.22,351165.00,0.00,0.00,0.00),('1','219','1','129',514,'2','1',14496.78,14785.99,0.00,0.00,289.21,205339.10,0.00,0.00,0.00),('1','219','1','129',515,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','129',516,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','130',517,'1','1',26480.68,26816.11,0.00,0.00,335.43,251572.50,0.00,0.00,0.00),('1','219','1','130',518,'2','1',14785.99,14868.49,0.00,0.00,82.50,58575.00,0.00,0.00,0.00),('1','219','1','130',519,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','130',520,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','131',521,'1','1',26816.11,27096.02,0.00,0.00,279.91,209932.50,0.00,0.00,0.00),('1','219','1','131',522,'2','1',14868.49,14910.90,0.00,0.00,42.41,30111.10,0.00,0.00,0.00),('1','219','1','131',523,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','131',524,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','132',525,'1','1',27096.02,27331.62,0.00,0.00,235.60,176700.00,0.00,0.00,0.00),('1','219','1','132',526,'2','1',14910.90,14960.40,0.00,0.00,49.50,35145.00,0.00,0.00,0.00),('1','219','1','132',527,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','132',528,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','133',529,'1','1',27331.62,27720.87,0.00,0.00,389.25,291937.50,0.00,0.00,0.00),('1','219','1','133',530,'2','1',14960.40,14960.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','133',531,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','133',532,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','134',533,'1','1',27720.87,28036.08,0.00,0.00,315.21,236407.50,0.00,0.00,0.00),('1','219','1','134',534,'2','1',14960.40,15025.90,0.00,0.00,65.50,46865.00,0.00,0.00,0.00),('1','219','1','134',535,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','134',536,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','135',537,'1','1',28036.08,28384.85,0.00,0.00,348.77,261577.50,0.00,0.00,0.00),('1','219','1','135',538,'2','1',15025.90,15077.94,0.00,0.00,52.04,36948.40,0.00,0.00,0.00),('1','219','1','135',539,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','135',540,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','136',541,'1','1',28384.85,28673.16,0.00,0.00,288.31,216232.50,0.00,0.00,0.00),('1','219','1','136',542,'2','1',15077.94,15145.04,0.00,0.00,67.10,47641.00,0.00,0.00,0.00),('1','219','1','136',543,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','136',544,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','137',545,'1','1',28673.16,29044.32,0.00,0.00,371.16,278370.00,0.00,0.00,0.00),('1','219','1','137',546,'2','1',15145.04,15173.22,0.00,0.00,28.18,20007.80,0.00,0.00,0.00),('1','219','1','137',547,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','137',548,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','138',549,'1','1',29044.32,29402.90,0.00,0.00,358.58,268935.00,0.00,0.00,0.00),('1','219','1','138',550,'2','1',15173.22,15332.45,0.00,0.00,159.23,113053.30,0.00,0.00,0.00),('1','219','1','138',551,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','138',552,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','139',553,'1','1',29402.90,29793.78,0.00,0.00,390.88,293160.00,0.00,0.00,0.00),('1','219','1','139',554,'2','1',15332.45,15437.18,0.00,0.00,104.73,74358.30,0.00,0.00,0.00),('1','219','1','139',555,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','139',556,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','140',557,'1','1',29793.78,30164.10,0.00,0.00,370.32,277740.00,0.00,0.00,0.00),('1','219','1','140',558,'2','1',15437.18,15563.68,0.00,0.00,126.50,89815.00,0.00,0.00,0.00),('1','219','1','140',559,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','140',560,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','141',561,'1','1',30164.10,30440.44,0.00,0.00,276.34,207255.00,0.00,0.00,0.00),('1','219','1','141',562,'2','1',15563.68,15579.52,0.00,0.00,15.84,11246.40,0.00,0.00,0.00),('1','219','1','141',563,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','141',564,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','142',565,'1','1',30440.44,30608.08,0.00,0.00,167.64,125730.00,0.00,0.00,0.00),('1','219','1','142',566,'2','1',15579.52,15646.45,0.00,0.00,66.93,47520.30,0.00,0.00,0.00),('1','219','1','142',567,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','142',568,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','143',569,'1','1',30608.08,30904.71,0.00,0.00,296.63,222472.50,0.00,0.00,0.00),('1','219','1','143',570,'2','1',15646.45,15649.45,0.00,0.00,3.00,2130.00,0.00,0.00,0.00),('1','219','1','143',571,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','143',572,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','144',573,'1','1',30904.71,31437.82,0.00,0.00,533.11,399832.50,0.00,0.00,0.00),('1','219','1','144',574,'2','1',15649.45,15665.45,0.00,0.00,16.00,11360.00,0.00,0.00,0.00),('1','219','1','144',575,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','144',576,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','145',577,'1','1',31437.82,31676.61,0.00,0.00,238.79,179092.50,0.00,0.00,0.00),('1','219','1','145',578,'2','1',15665.45,15724.45,0.00,0.00,59.00,41890.00,0.00,0.00,0.00),('1','219','1','145',579,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','145',580,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','146',581,'1','1',31676.61,32022.96,0.00,0.00,346.35,259762.50,0.00,0.00,0.00),('1','219','1','146',582,'2','1',15724.45,15724.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','146',583,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','146',584,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','147',585,'1','1',32022.96,32353.82,0.00,0.00,330.86,248145.00,0.00,0.00,0.00),('1','219','1','147',586,'2','1',15724.45,15758.62,0.00,0.00,34.17,24260.70,0.00,0.00,0.00),('1','219','1','147',587,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','147',588,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','148',589,'1','1',32353.82,32862.38,0.00,0.00,508.56,381420.00,0.00,0.00,0.00),('1','219','1','148',590,'2','1',15758.62,15827.11,0.00,0.00,68.49,48627.90,0.00,0.00,0.00),('1','219','1','148',591,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','148',592,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','149',593,'1','1',32862.38,33363.13,0.00,0.00,500.75,375562.50,0.00,0.00,0.00),('1','219','1','149',594,'2','1',15827.11,16005.11,0.00,0.00,178.00,126380.00,0.00,0.00,0.00),('1','219','1','149',595,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','149',596,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','150',597,'1','1',33363.13,34208.62,0.00,0.00,845.49,634117.50,0.00,0.00,0.00),('1','219','1','150',598,'2','1',16005.11,16109.34,0.00,0.00,104.23,74003.30,0.00,0.00,0.00),('1','219','1','150',599,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','150',600,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','151',601,'1','1',34208.62,34410.25,0.00,0.00,201.63,151222.50,0.00,0.00,0.00),('1','219','1','151',602,'2','1',16109.34,16146.34,0.00,0.00,37.00,26270.00,0.00,0.00,0.00),('1','219','1','151',603,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','151',604,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','152',605,'1','1',34410.25,34748.01,0.00,0.00,337.76,253320.00,0.00,0.00,0.00),('1','219','1','152',606,'2','1',16146.34,16257.34,0.00,0.00,111.00,78810.00,0.00,0.00,0.00),('1','219','1','152',607,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','152',608,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','153',609,'1','1',34748.01,35001.47,0.00,0.00,253.46,190095.00,0.00,0.00,0.00),('1','219','1','153',610,'2','1',16257.34,16367.34,0.00,0.00,110.00,78100.00,0.00,0.00,0.00),('1','219','1','153',611,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','153',612,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','154',613,'1','1',35001.47,35311.77,0.00,0.00,310.30,232725.00,0.00,0.00,0.00),('1','219','1','154',614,'2','1',16367.34,16370.34,0.00,0.00,3.00,2130.00,0.00,0.00,0.00),('1','219','1','154',615,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','154',616,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','155',617,'1','1',35311.77,35593.77,0.00,0.00,282.00,211500.00,0.00,0.00,0.00),('1','219','1','155',618,'2','1',16370.34,16482.34,0.00,0.00,112.00,79520.00,0.00,0.00,0.00),('1','219','1','155',619,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','155',620,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','156',621,'1','1',35593.77,35631.07,0.00,0.00,37.30,27975.00,0.00,0.00,0.00),('1','219','1','156',622,'2','1',16482.34,16482.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','156',623,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','156',624,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','157',625,'1','1',35631.07,35951.97,0.00,0.00,320.90,240675.00,0.00,0.00,0.00),('1','219','1','157',626,'2','1',16482.34,16506.84,0.00,0.00,24.50,17395.00,0.00,0.00,0.00),('1','219','1','157',627,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','157',628,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','158',629,'1','1',35951.97,36323.54,0.00,0.00,371.57,278677.50,0.00,0.00,0.00),('1','219','1','158',630,'2','1',16506.84,16815.34,0.00,0.00,308.50,219035.00,0.00,0.00,0.00),('1','219','1','158',631,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','158',632,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','159',633,'1','1',36323.54,36942.18,0.00,0.00,618.64,463980.00,0.00,0.00,0.00),('1','219','1','159',634,'2','1',16815.34,17217.59,0.00,0.00,402.25,285597.50,0.00,0.00,0.00),('1','219','1','159',635,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','159',636,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','160',637,'1','1',36942.18,37236.04,0.00,0.00,293.86,220395.00,0.00,0.00,0.00),('1','219','1','160',638,'2','1',17217.59,17620.59,0.00,0.00,403.00,286130.00,0.00,0.00,0.00),('1','219','1','160',639,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','160',640,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','161',641,'1','1',37236.04,37779.46,0.00,0.00,543.42,407565.00,0.00,0.00,0.00),('1','219','1','161',642,'2','1',17620.59,17852.59,0.00,0.00,232.00,164760.00,0.00,0.00,0.00),('1','219','1','161',643,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','161',644,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','162',645,'1','1',37779.46,38240.59,0.00,0.00,461.13,345847.50,0.00,0.00,0.00),('1','219','1','162',646,'2','1',17852.59,18068.41,0.00,0.00,215.82,153232.20,0.00,0.00,0.00),('1','219','1','162',647,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','162',648,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','163',649,'1','1',38240.59,38603.50,0.00,0.00,362.91,272182.50,0.00,0.00,0.00),('1','219','1','163',650,'2','1',18068.41,18151.73,0.00,0.00,83.32,59157.20,0.00,0.00,0.00),('1','219','1','163',651,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','163',652,'4','1',8545.58,8545.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','164',653,'1','1',38603.50,38972.53,0.00,0.00,369.03,276772.50,0.00,0.00,0.00),('1','219','1','164',654,'2','1',18151.73,18639.73,0.00,0.00,488.00,346480.00,0.00,0.00,0.00),('1','219','1','164',655,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','164',656,'4','1',8545.58,8645.58,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','219','1','165',657,'1','1',38972.53,39259.68,0.00,0.00,287.15,215362.50,0.00,0.00,0.00),('1','219','1','165',658,'2','1',18639.73,18652.73,0.00,0.00,13.00,9230.00,0.00,0.00,0.00),('1','219','1','165',659,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','165',660,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','166',661,'1','1',39259.68,39363.09,0.00,0.00,103.41,77557.50,0.00,0.00,0.00),('1','219','1','166',662,'2','1',18652.73,18661.55,0.00,0.00,8.82,6262.20,0.00,0.00,0.00),('1','219','1','166',663,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','166',664,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','167',665,'1','1',39363.09,39744.00,0.00,0.00,380.91,285682.50,0.00,0.00,0.00),('1','219','1','167',666,'2','1',18661.55,18796.05,0.00,0.00,134.50,95495.00,0.00,0.00,0.00),('1','219','1','167',667,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','167',668,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','168',669,'1','1',39744.00,40131.32,0.00,0.00,387.32,290490.00,0.00,0.00,0.00),('1','219','1','168',670,'2','1',18796.05,18849.05,0.00,0.00,53.00,37630.00,0.00,0.00,0.00),('1','219','1','168',671,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','168',672,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','169',673,'1','1',40131.32,40402.65,0.00,0.00,271.33,203497.50,0.00,0.00,0.00),('1','219','1','169',674,'2','1',18849.05,19159.55,0.00,0.00,310.50,220455.00,0.00,0.00,0.00),('1','219','1','169',675,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','169',676,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','170',677,'1','1',40402.65,40836.82,0.00,0.00,434.17,325627.50,0.00,0.00,0.00),('1','219','1','170',678,'2','1',19159.55,19204.05,0.00,0.00,44.50,31595.00,0.00,0.00,0.00),('1','219','1','170',679,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','170',680,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','171',681,'1','1',40836.82,41082.24,0.00,0.00,245.42,184065.00,0.00,0.00,0.00),('1','219','1','171',682,'2','1',19204.05,19391.05,0.00,0.00,187.00,133210.00,0.00,0.00,0.00),('1','219','1','171',683,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','171',684,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','172',685,'1','1',41082.24,41345.02,0.00,0.00,262.78,197085.00,0.00,0.00,0.00),('1','219','1','172',686,'2','1',19391.05,19515.01,0.00,0.00,123.96,88011.60,0.00,0.00,0.00),('1','219','1','172',687,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','172',688,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','173',689,'1','1',41345.02,41822.72,0.00,0.00,477.70,358275.00,0.00,0.00,0.00),('1','219','1','173',690,'2','1',19515.01,19705.01,0.00,0.00,190.00,134900.00,0.00,0.00,0.00),('1','219','1','173',691,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','173',692,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','174',693,'1','1',41822.72,42177.47,0.00,0.00,354.75,266062.50,0.00,0.00,0.00),('1','219','1','174',694,'2','1',19705.01,20033.65,0.00,0.00,328.64,233334.40,0.00,0.00,0.00),('1','219','1','174',695,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','174',696,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','175',697,'1','1',42177.47,42588.34,0.00,0.00,410.87,308152.50,0.00,0.00,0.00),('1','219','1','175',698,'2','1',20033.65,20424.06,0.00,0.00,390.41,277191.10,0.00,0.00,0.00),('1','219','1','175',699,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','175',700,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','176',701,'1','1',42588.34,42861.41,0.00,0.00,273.07,204802.50,0.00,0.00,0.00),('1','219','1','176',702,'2','1',20424.06,20699.56,0.00,0.00,275.50,195605.00,0.00,0.00,0.00),('1','219','1','176',703,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','176',704,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','177',705,'1','1',42861.41,42943.62,0.00,0.00,82.21,61657.50,0.00,0.00,0.00),('1','219','1','177',706,'2','1',20699.56,20886.61,0.00,0.00,187.05,132805.50,0.00,0.00,0.00),('1','219','1','177',707,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','177',708,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','178',709,'1','1',42943.62,43471.70,0.00,0.00,528.08,396060.00,0.00,0.00,0.00),('1','219','1','178',710,'2','1',20886.61,21308.92,0.00,0.00,422.31,299840.10,0.00,0.00,0.00),('1','219','1','178',711,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','178',712,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','179',713,'1','1',43471.70,44178.90,0.00,0.00,707.20,530400.00,0.00,0.00,0.00),('1','219','1','179',714,'2','1',21308.92,22268.97,0.00,0.00,960.05,681635.50,0.00,0.00,0.00),('1','219','1','179',715,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','179',716,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','180',717,'1','1',44178.90,44703.19,0.00,0.00,524.29,393217.50,0.00,0.00,0.00),('1','219','1','180',718,'2','1',22268.97,23175.22,0.00,0.00,906.25,646109.50,0.00,0.00,0.00),('1','219','1','180',719,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','180',720,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','181',721,'1','1',44703.19,45188.46,0.00,0.00,485.27,363952.50,0.00,0.00,0.00),('1','219','1','181',722,'2','1',23175.22,24485.72,0.00,0.00,1310.50,930455.00,0.00,0.00,0.00),('1','219','1','181',723,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','181',724,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','182',725,'1','1',45188.46,45680.60,0.00,0.00,492.14,369105.00,0.00,0.00,0.00),('1','219','1','182',726,'2','1',24485.72,25500.02,0.00,0.00,1014.30,720153.00,0.00,0.00,0.00),('1','219','1','182',727,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','182',728,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','183',729,'1','1',45680.60,46158.83,0.00,0.00,478.23,358672.50,0.00,0.00,0.00),('1','219','1','183',730,'2','1',25500.02,26260.52,0.00,0.00,760.50,539955.00,0.00,0.00,0.00),('1','219','1','183',731,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','183',732,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','184',733,'1','1',46158.83,46625.16,0.00,0.00,466.33,349747.50,0.00,0.00,0.00),('1','219','1','184',734,'2','1',26260.52,26603.02,0.00,0.00,342.50,243295.00,0.00,0.00,0.00),('1','219','1','184',735,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','184',736,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','185',737,'1','1',46625.16,46892.77,0.00,0.00,267.61,200707.50,0.00,0.00,0.00),('1','219','1','185',738,'2','1',26603.02,27161.67,0.00,0.00,558.65,396641.50,0.00,0.00,0.00),('1','219','1','185',739,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','185',740,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','186',741,'1','1',46892.77,47345.68,0.00,0.00,452.91,339682.50,0.00,0.00,0.00),('1','219','1','186',742,'2','1',27161.67,27411.00,0.00,0.00,249.33,177024.30,0.00,0.00,0.00),('1','219','1','186',743,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','186',744,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','187',745,'1','1',47345.68,47667.65,0.00,0.00,321.97,241477.50,0.00,0.00,0.00),('1','219','1','187',746,'2','1',27411.00,27809.50,0.00,0.00,398.50,282935.00,0.00,0.00,0.00),('1','219','1','187',747,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','187',748,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','188',749,'1','1',47667.65,48139.54,0.00,0.00,471.89,353917.50,0.00,0.00,0.00),('1','219','1','188',750,'2','1',27809.50,28213.50,0.00,0.00,404.00,287340.00,0.00,0.00,0.00),('1','219','1','188',751,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','188',752,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','189',753,'1','1',48139.54,48513.16,0.00,0.00,373.62,280215.00,0.00,0.00,0.00),('1','219','1','189',754,'2','1',28213.50,28721.16,0.00,0.00,507.66,360438.60,0.00,0.00,0.00),('1','219','1','189',755,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','189',756,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','190',757,'1','1',48513.16,49109.72,0.00,0.00,596.56,447420.00,0.00,0.00,0.00),('1','219','1','190',758,'2','1',28721.16,29181.66,0.00,0.00,460.50,326955.00,0.00,0.00,0.00),('1','219','1','190',759,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','190',760,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','191',761,'1','1',49109.72,49498.60,0.00,0.00,388.88,291660.00,0.00,0.00,0.00),('1','219','1','191',762,'2','1',29181.66,29638.96,0.00,0.00,457.30,324683.00,0.00,0.00,0.00),('1','219','1','191',763,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','191',764,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','192',765,'1','1',49498.60,49930.97,0.00,0.00,432.37,324277.50,0.00,0.00,0.00),('1','219','1','192',766,'2','1',29638.96,29735.74,0.00,0.00,96.78,68713.80,0.00,0.00,0.00),('1','219','1','192',767,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','192',768,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','193',769,'1','1',49930.97,50209.72,0.00,0.00,278.75,209062.50,0.00,0.00,0.00),('1','219','1','193',770,'2','1',29735.74,29989.41,0.00,0.00,253.67,180105.70,0.00,0.00,0.00),('1','219','1','193',771,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','193',772,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','194',773,'1','1',50209.72,50700.18,0.00,0.00,490.46,367845.00,0.00,0.00,0.00),('1','219','1','194',774,'2','1',29989.41,30106.41,0.00,0.00,117.00,83070.00,0.00,0.00,0.00),('1','219','1','194',775,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','194',776,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','195',777,'1','1',50700.18,51125.63,0.00,0.00,425.45,319087.50,0.00,0.00,0.00),('1','219','1','195',778,'2','1',30106.41,30245.91,0.00,0.00,139.50,99045.00,0.00,0.00,0.00),('1','219','1','195',779,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','195',780,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','196',781,'1','1',51125.63,51577.63,0.00,0.00,452.00,339000.00,0.00,0.00,0.00),('1','219','1','196',782,'2','1',30245.91,30318.24,0.00,0.00,72.33,51407.50,0.00,0.00,0.00),('1','219','1','196',783,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','196',784,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','197',785,'1','1',51577.63,51959.72,0.00,0.00,382.09,286567.50,0.00,0.00,0.00),('1','219','1','197',786,'2','1',30318.24,30463.74,0.00,0.00,145.50,103305.00,0.00,0.00,0.00),('1','219','1','197',787,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','197',788,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','198',789,'1','1',51959.72,52360.46,0.00,0.00,400.74,300555.00,0.00,0.00,0.00),('1','219','1','198',790,'2','1',30463.74,30512.24,0.00,0.00,48.50,34669.80,0.00,0.00,0.00),('1','219','1','198',791,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','198',792,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','199',793,'1','1',52360.46,52670.66,0.00,0.00,310.20,232650.00,0.00,0.00,0.00),('1','219','1','199',794,'2','1',30512.24,30634.82,0.00,0.00,122.58,87031.80,0.00,0.00,0.00),('1','219','1','199',795,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','199',796,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','200',797,'1','1',52670.66,53123.53,0.00,0.00,452.87,339652.50,0.00,0.00,0.00),('1','219','1','200',798,'2','1',30634.82,30728.82,0.00,0.00,94.00,66740.00,0.00,0.00,0.00),('1','219','1','200',799,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','200',800,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','201',801,'1','1',53123.53,53558.49,0.00,0.00,434.96,326220.00,0.00,0.00,0.00),('1','219','1','201',802,'2','1',30728.82,31159.62,0.00,0.00,430.80,305868.00,0.00,0.00,0.00),('1','219','1','201',803,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','201',804,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','202',805,'1','1',53558.49,54106.29,0.00,0.00,547.80,410850.00,0.00,0.00,0.00),('1','219','1','202',806,'2','1',31159.62,31472.64,0.00,0.00,313.02,222244.20,0.00,0.00,0.00),('1','219','1','202',807,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','202',808,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','203',809,'1','1',54106.29,54625.48,0.00,0.00,519.19,389392.50,0.00,0.00,0.00),('1','219','1','203',810,'2','1',31472.64,31768.14,0.00,0.00,295.50,209805.00,0.00,0.00,0.00),('1','219','1','203',811,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','203',812,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','204',813,'1','1',54625.48,54956.63,0.00,0.00,331.15,248362.50,0.00,0.00,0.00),('1','219','1','204',814,'2','1',31768.14,31992.08,0.00,0.00,223.94,158997.40,0.00,0.00,0.00),('1','219','1','204',815,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','204',816,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','205',817,'1','1',54956.63,54956.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','205',818,'2','1',31992.08,31992.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','205',819,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','205',820,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','206',821,'1','1',54956.63,55479.74,0.00,0.00,523.11,392332.50,0.00,0.00,0.00),('1','219','1','206',822,'2','1',31992.08,32708.08,0.00,0.00,716.00,508360.00,0.00,0.00,0.00),('1','219','1','206',823,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','206',824,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','207',825,'1','1',55479.74,56042.43,0.00,0.00,562.69,422017.50,0.00,0.00,0.00),('1','219','1','207',826,'2','1',32708.08,33431.07,0.00,0.00,722.99,513322.90,0.00,0.00,0.00),('1','219','1','207',827,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','207',828,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','208',829,'1','1',56042.43,56500.14,0.00,0.00,457.71,343282.50,0.00,0.00,0.00),('1','219','1','208',830,'2','1',33431.07,34341.58,0.00,0.00,910.51,646462.10,0.00,0.00,0.00),('1','219','1','208',831,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','208',832,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','209',833,'1','1',56500.14,56986.54,0.00,0.00,486.40,364800.00,0.00,0.00,0.00),('1','219','1','209',834,'2','1',34341.58,35470.15,0.00,0.00,1128.57,801284.70,0.00,0.00,0.00),('1','219','1','209',835,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','209',836,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','210',837,'1','1',56986.54,57168.63,0.00,0.00,182.09,136567.50,0.00,0.00,0.00),('1','219','1','210',838,'2','1',35470.15,35658.15,0.00,0.00,188.00,133480.00,0.00,0.00,0.00),('1','219','1','210',839,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','210',840,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','211',841,'1','1',57168.63,57530.53,0.00,0.00,361.90,271425.00,0.00,0.00,0.00),('1','219','1','211',842,'2','1',35658.15,35985.15,0.00,0.00,327.00,232170.00,0.00,0.00,0.00),('1','219','1','211',843,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','211',844,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','212',845,'1','1',57530.53,58021.10,0.00,0.00,490.57,367927.50,0.00,0.00,0.00),('1','219','1','212',846,'2','1',35985.15,36638.00,0.00,0.00,652.85,463523.50,0.00,0.00,0.00),('1','219','1','212',847,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','212',848,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','213',849,'1','1',58021.10,58540.64,0.00,0.00,519.54,389655.00,0.00,0.00,0.00),('1','219','1','213',850,'2','1',36638.00,37530.50,0.00,0.00,892.50,633675.00,0.00,0.00,0.00),('1','219','1','213',851,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','213',852,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','214',853,'1','1',58540.64,59052.50,0.00,0.00,511.86,383895.00,0.00,0.00,0.00),('1','219','1','214',854,'2','1',37530.50,38137.01,0.00,0.00,606.51,430622.10,0.00,0.00,0.00),('1','219','1','214',855,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','214',856,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','215',857,'1','1',59052.50,59457.36,0.00,0.00,404.86,303645.00,0.00,0.00,0.00),('1','219','1','215',858,'2','1',38137.01,39160.78,0.00,0.00,1023.77,726956.70,0.00,0.00,0.00),('1','219','1','215',859,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','215',860,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','216',861,'1','1',59457.36,59962.87,0.00,0.00,505.51,379132.50,0.00,0.00,0.00),('1','219','1','216',862,'2','1',39160.78,40315.11,0.00,0.00,1154.33,819574.30,0.00,0.00,0.00),('1','219','1','216',863,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','216',864,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','217',865,'1','1',59962.87,60387.83,0.00,0.00,424.96,318720.00,0.00,0.00,0.00),('1','219','1','217',866,'2','1',40315.11,41287.76,0.00,0.00,972.65,690581.50,0.00,0.00,0.00),('1','219','1','217',867,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','217',868,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','218',869,'1','1',60387.83,60870.03,0.00,0.00,482.20,361650.00,0.00,0.00,0.00),('1','219','1','218',870,'2','1',41287.76,42136.59,0.00,0.00,848.83,604669.30,0.00,0.00,0.00),('1','219','1','218',871,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','218',872,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','219',873,'1','1',60870.03,61090.23,0.00,0.00,220.20,165150.00,0.00,0.00,0.00),('1','219','1','219',874,'2','1',42136.59,43392.52,0.00,0.00,1255.93,891710.30,0.00,0.00,0.00),('1','219','1','219',875,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','219',876,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','220',877,'1','1',61090.23,61567.39,0.00,0.00,477.16,357870.00,0.00,0.00,0.00),('1','219','1','220',878,'2','1',43392.52,44883.53,0.00,0.00,1491.01,1058617.10,0.00,0.00,0.00),('1','219','1','220',879,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','220',880,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','221',881,'1','1',61567.39,61946.09,0.00,0.00,378.70,284025.00,0.00,0.00,0.00),('1','219','1','221',882,'2','1',44883.53,45573.53,0.00,0.00,690.00,489900.00,0.00,0.00,0.00),('1','219','1','221',883,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','221',884,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','222',885,'1','1',61946.09,62250.66,0.00,0.00,304.57,228427.50,0.00,0.00,0.00),('1','219','1','222',886,'2','1',45573.53,46097.40,0.00,0.00,523.87,371947.70,0.00,0.00,0.00),('1','219','1','222',887,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','222',888,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','223',889,'1','1',62250.66,62559.68,0.00,0.00,309.02,231765.00,0.00,0.00,0.00),('1','219','1','223',890,'2','1',46097.40,46860.49,0.00,0.00,763.09,541793.90,0.00,0.00,0.00),('1','219','1','223',891,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','223',892,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','224',893,'1','1',62559.68,62960.40,0.00,0.00,400.72,300540.00,0.00,0.00,0.00),('1','219','1','224',894,'2','1',46860.49,47842.39,0.00,0.00,981.90,697309.00,0.00,0.00,0.00),('1','219','1','224',895,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','224',896,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','225',897,'1','1',62960.40,63376.07,0.00,0.00,415.67,311752.50,0.00,0.00,0.00),('1','219','1','225',898,'2','1',47842.39,48633.39,0.00,0.00,791.00,561610.00,0.00,0.00,0.00),('1','219','1','225',899,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','225',900,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','226',901,'1','1',63376.07,63844.76,0.00,0.00,468.69,351517.50,0.00,0.00,0.00),('1','219','1','226',902,'2','1',48633.39,49182.35,0.00,0.00,548.96,389761.60,0.00,0.00,0.00),('1','219','1','226',903,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','226',904,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','227',905,'1','1',63844.76,64390.74,0.00,0.00,545.98,409485.00,0.00,0.00,0.00),('1','219','1','227',906,'2','1',49182.35,49762.99,0.00,0.00,580.64,412254.40,0.00,0.00,0.00),('1','219','1','227',907,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','227',908,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','228',909,'1','1',64390.74,64407.14,0.00,0.00,16.40,12300.00,0.00,0.00,0.00),('1','219','1','228',910,'2','1',49762.99,49832.33,0.00,0.00,69.34,49231.40,0.00,0.00,0.00),('1','219','1','228',911,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','228',912,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','229',913,'1','1',64407.14,64926.01,0.00,0.00,518.87,389152.50,0.00,0.00,0.00),('1','219','1','229',914,'2','1',49832.33,50220.90,0.00,0.00,388.57,275884.70,0.00,0.00,0.00),('1','219','1','229',915,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','229',916,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','230',917,'1','1',64926.01,65077.50,0.00,0.00,151.49,113617.50,0.00,0.00,0.00),('1','219','1','230',918,'2','1',50220.90,50915.76,0.00,0.00,694.86,493350.60,0.00,0.00,0.00),('1','219','1','230',919,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','230',920,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','231',921,'1','1',65077.50,65504.53,0.00,0.00,427.03,320272.50,0.00,0.00,0.00),('1','219','1','231',922,'2','1',50915.76,51142.58,0.00,0.00,226.82,161042.20,0.00,0.00,0.00),('1','219','1','231',923,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','231',924,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','232',925,'1','1',65504.53,65715.68,0.00,0.00,211.15,158362.50,0.00,0.00,0.00),('1','219','1','232',926,'2','1',51142.58,51363.86,0.00,0.00,221.28,157108.80,0.00,0.00,0.00),('1','219','1','232',927,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','232',928,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','233',929,'1','1',65715.68,66170.98,0.00,0.00,455.30,341475.00,0.00,0.00,0.00),('1','219','1','233',930,'2','1',51363.86,51575.40,0.00,0.00,211.54,150193.40,0.00,0.00,0.00),('1','219','1','233',931,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','233',932,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','234',933,'1','1',66170.98,66526.89,0.00,0.00,355.91,266932.50,0.00,0.00,0.00),('1','219','1','234',934,'2','1',51575.40,51982.82,0.00,0.00,407.42,289268.20,0.00,0.00,0.00),('1','219','1','234',935,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','234',936,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','235',937,'1','1',66526.89,66847.44,0.00,0.00,320.55,240412.50,0.00,0.00,0.00),('1','219','1','235',938,'2','1',51982.82,52162.37,0.00,0.00,179.55,127480.50,0.00,0.00,0.00),('1','219','1','235',939,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','235',940,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','236',941,'1','1',66847.44,67094.29,0.00,0.00,246.85,185137.50,0.00,0.00,0.00),('1','219','1','236',942,'2','1',52162.37,52356.53,0.00,0.00,194.16,137853.60,0.00,0.00,0.00),('1','219','1','236',943,'3','1',13694.42,13694.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','236',944,'4','1',8645.58,8645.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','237',945,'1','1',67094.29,67581.16,0.00,0.00,486.87,365152.50,0.00,0.00,0.00),('1','219','1','237',946,'2','1',52356.53,52486.11,0.00,0.00,129.58,90706.00,0.00,0.00,0.00),('1','219','1','237',947,'3','1',13694.42,13856.25,0.00,0.00,161.83,113281.00,0.00,0.00,0.00),('1','219','1','237',948,'4','1',8645.58,8649.18,0.00,0.00,3.60,2700.00,0.00,0.00,0.00),('1','219','1','238',949,'1','1',67581.16,68069.10,0.00,0.00,487.94,365955.00,0.00,0.00,0.00),('1','219','1','238',950,'2','1',52486.11,52684.11,0.00,0.00,198.00,138600.00,0.00,0.00,0.00),('1','219','1','238',951,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','238',952,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','239',953,'1','1',68069.10,68506.45,0.00,0.00,437.35,328012.50,0.00,0.00,0.00),('1','219','1','239',954,'2','1',52684.11,53163.11,0.00,0.00,479.00,335300.00,0.00,0.00,0.00),('1','219','1','239',955,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','239',956,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','240',957,'1','1',68506.45,68743.99,0.00,0.00,237.54,178155.00,0.00,0.00,0.00),('1','219','1','240',958,'2','1',53163.11,53357.28,0.00,0.00,194.17,136069.00,0.00,0.00,0.00),('1','219','1','240',959,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','240',960,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','241',961,'1','1',68743.99,68936.62,0.00,0.00,192.63,144472.50,0.00,0.00,0.00),('1','219','1','241',962,'2','1',53357.28,53368.28,0.00,0.00,11.00,7700.00,0.00,0.00,0.00),('1','219','1','241',963,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','241',964,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','242',965,'1','1',68936.62,69267.99,0.00,0.00,331.37,248527.50,0.00,0.00,0.00),('1','219','1','242',966,'2','1',53368.28,53617.28,0.00,0.00,249.00,174300.00,0.00,0.00,0.00),('1','219','1','242',967,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','242',968,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','243',969,'1','1',69267.99,69480.00,0.00,0.00,212.01,159007.50,0.00,0.00,0.00),('1','219','1','243',970,'2','1',53617.28,53745.78,0.00,0.00,128.50,89950.00,0.00,0.00,0.00),('1','219','1','243',971,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','243',972,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','244',973,'1','1',69480.00,69666.78,0.00,0.00,186.78,140085.00,0.00,0.00,0.00),('1','219','1','244',974,'2','1',53745.78,53907.28,0.00,0.00,161.50,113050.00,0.00,0.00,0.00),('1','219','1','244',975,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','244',976,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','245',977,'1','1',69666.78,69992.24,0.00,0.00,325.46,244095.00,0.00,0.00,0.00),('1','219','1','245',978,'2','1',53907.28,54024.78,0.00,0.00,117.50,82250.00,0.00,0.00,0.00),('1','219','1','245',979,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','245',980,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','246',981,'1','1',69992.24,70444.10,0.00,0.00,451.86,338895.00,0.00,0.00,0.00),('1','219','1','246',982,'2','1',54024.78,54701.31,0.00,0.00,676.53,473571.00,0.00,0.00,0.00),('1','219','1','246',983,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','246',984,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','247',985,'1','1',70444.10,70663.90,0.00,0.00,219.80,164850.00,0.00,0.00,0.00),('1','219','1','247',986,'2','1',54701.31,54896.53,0.00,0.00,195.22,136654.00,0.00,0.00,0.00),('1','219','1','247',987,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','247',988,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','248',989,'1','1',70663.90,70734.51,0.00,0.00,70.61,52957.50,0.00,0.00,0.00),('1','219','1','248',990,'2','1',54896.53,54995.21,0.00,0.00,98.68,69076.00,0.00,0.00,0.00),('1','219','1','248',991,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','248',992,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','249',993,'1','1',70734.51,71140.47,0.00,0.00,405.96,304470.00,0.00,0.00,0.00),('1','219','1','249',994,'2','1',54995.21,55212.05,0.00,0.00,216.84,151788.00,0.00,0.00,0.00),('1','219','1','249',995,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','249',996,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','250',997,'1','1',71140.47,71522.35,0.00,0.00,381.88,286410.00,0.00,0.00,0.00),('1','219','1','250',998,'2','1',55212.05,55535.88,0.00,0.00,323.83,226681.00,0.00,0.00,0.00),('1','219','1','250',999,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','250',1000,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','251',1001,'1','1',71522.35,71869.71,0.00,0.00,347.36,260520.00,0.00,0.00,0.00),('1','219','1','251',1002,'2','1',55535.88,56204.38,0.00,0.00,668.50,467950.00,0.00,0.00,0.00),('1','219','1','251',1003,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','251',1004,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','252',1005,'1','1',71869.71,72221.86,0.00,0.00,352.15,263862.50,0.00,0.00,0.00),('1','219','1','252',1006,'2','1',56204.38,56385.06,0.00,0.00,180.68,126576.00,0.00,0.00,0.00),('1','219','1','252',1007,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','252',1008,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','253',1009,'1','1',72221.86,72553.63,0.00,0.00,331.77,248827.50,0.00,0.00,0.00),('1','219','1','253',1010,'2','1',56385.06,56588.06,0.00,0.00,203.00,142100.00,0.00,0.00,0.00),('1','219','1','253',1011,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','253',1012,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','254',1013,'1','1',72553.63,72872.63,0.00,0.00,319.00,239250.00,0.00,0.00,0.00),('1','219','1','254',1014,'2','1',56588.06,56807.56,0.00,0.00,219.50,153650.00,0.00,0.00,0.00),('1','219','1','254',1015,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','254',1016,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','255',1017,'1','1',72872.63,73177.33,0.00,0.00,304.70,228525.00,0.00,0.00,0.00),('1','219','1','255',1018,'2','1',56807.56,57349.64,0.00,0.00,542.08,379456.00,0.00,0.00,0.00),('1','219','1','255',1019,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','255',1020,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','256',1021,'1','1',73177.33,73482.95,0.00,0.00,305.62,229215.00,0.00,0.00,0.00),('1','219','1','256',1022,'2','1',57349.64,57756.64,0.00,0.00,407.00,284900.00,0.00,0.00,0.00),('1','219','1','256',1023,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','256',1024,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','257',1025,'1','1',73482.95,73647.35,0.00,0.00,164.40,123300.00,0.00,0.00,0.00),('1','219','1','257',1026,'2','1',57756.64,57906.64,0.00,0.00,150.00,105000.00,0.00,0.00,0.00),('1','219','1','257',1027,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','257',1028,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','258',1029,'1','1',73647.35,73866.54,0.00,0.00,219.19,164392.50,0.00,0.00,0.00),('1','219','1','258',1030,'2','1',57906.64,58255.64,0.00,0.00,349.00,244300.00,0.00,0.00,0.00),('1','219','1','258',1031,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','258',1032,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','259',1033,'1','1',73866.54,74233.03,0.00,0.00,366.49,274867.50,0.00,0.00,0.00),('1','219','1','259',1034,'2','1',58255.64,59065.97,0.00,0.00,810.33,567231.00,0.00,0.00,0.00),('1','219','1','259',1035,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','259',1036,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','260',1037,'1','1',74233.03,74720.03,0.00,0.00,487.00,365250.00,0.00,0.00,0.00),('1','219','1','260',1038,'2','1',59065.97,59925.65,0.00,0.00,859.68,601776.00,0.00,0.00,0.00),('1','219','1','260',1039,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','260',1040,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','261',1041,'1','1',74720.03,74959.01,0.00,0.00,238.98,179235.00,0.00,0.00,0.00),('1','219','1','261',1042,'2','1',59925.65,60654.16,0.00,0.00,728.51,524527.20,0.00,0.00,0.00),('1','219','1','261',1043,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','261',1044,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','262',1045,'1','1',74959.01,75244.33,0.00,0.00,285.32,213990.00,0.00,0.00,0.00),('1','219','1','262',1046,'2','1',60654.16,61506.23,0.00,0.00,852.07,613490.40,0.00,0.00,0.00),('1','219','1','262',1047,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','262',1048,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','263',1049,'1','1',75244.33,75332.89,0.00,0.00,88.56,66420.00,0.00,0.00,0.00),('1','219','1','263',1050,'2','1',61506.23,61822.23,0.00,0.00,316.00,227520.00,0.00,0.00,0.00),('1','219','1','263',1051,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','263',1052,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','264',1053,'1','1',75332.89,75332.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','264',1054,'2','1',61822.23,61822.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','264',1055,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','264',1056,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','265',1057,'1','1',75332.89,75643.84,0.00,0.00,310.95,233212.50,0.00,0.00,0.00),('1','219','1','265',1058,'2','1',61822.23,62559.03,0.00,0.00,736.80,530496.00,0.00,0.00,0.00),('1','219','1','265',1059,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','265',1060,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','266',1061,'1','1',75643.84,76123.39,0.00,0.00,479.55,359662.50,0.00,0.00,0.00),('1','219','1','266',1062,'2','1',62559.03,63608.85,0.00,0.00,1049.82,755926.50,0.00,0.00,0.00),('1','219','1','266',1063,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','266',1064,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','267',1065,'1','1',76123.39,76373.11,0.00,0.00,249.72,187290.00,0.00,0.00,0.00),('1','219','1','267',1066,'2','1',63608.85,64824.35,0.00,0.00,1215.50,875160.00,0.00,0.00,0.00),('1','219','1','267',1067,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','267',1068,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','268',1069,'1','1',76373.11,76695.93,0.00,0.00,322.82,242115.00,0.00,0.00,0.00),('1','219','1','268',1070,'2','1',64824.35,66260.31,0.00,0.00,1435.96,1033891.20,0.00,0.00,0.00),('1','219','1','268',1071,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','268',1072,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','269',1073,'1','1',76695.93,76705.31,0.00,0.00,9.38,7316.40,0.00,0.00,0.00),('1','219','1','269',1074,'2','1',66260.31,66327.40,0.00,0.00,67.09,49646.60,0.00,0.00,0.00),('1','219','1','269',1075,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','269',1076,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','270',1077,'1','1',76705.31,76705.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','270',1078,'2','1',66327.40,66327.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','270',1079,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','270',1080,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','271',1081,'1','1',76705.31,77342.31,0.00,0.00,637.00,496860.00,0.00,0.00,0.00),('1','219','1','271',1082,'2','1',66327.40,68593.72,0.00,0.00,2266.32,1677076.80,0.00,0.00,0.00),('1','219','1','271',1083,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','271',1084,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','272',1085,'1','1',77342.31,77927.30,0.00,0.00,584.99,456292.20,0.00,0.00,0.00),('1','219','1','272',1086,'2','1',68593.72,68790.28,0.00,0.00,196.56,153316.80,0.00,0.00,0.00),('1','219','1','272',1087,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','272',1088,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','273',1089,'1','1',77927.30,78402.11,0.00,0.00,474.81,370351.80,0.00,0.00,0.00),('1','219','1','273',1090,'2','1',68790.28,68828.38,0.00,0.00,38.10,29718.00,0.00,0.00,0.00),('1','219','1','273',1091,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','273',1092,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','274',1093,'1','1',78402.11,78979.14,0.00,0.00,577.03,450083.40,0.00,0.00,0.00),('1','219','1','274',1094,'2','1',68828.38,68828.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','274',1095,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','274',1096,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','275',1097,'1','1',78979.14,80001.19,0.00,0.00,1022.05,797199.00,0.00,0.00,0.00),('1','219','1','275',1098,'2','1',68828.38,68828.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','275',1099,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','275',1100,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','276',1101,'1','1',80001.19,80681.27,0.00,0.00,680.08,530462.40,0.00,0.00,0.00),('1','219','1','276',1102,'2','1',68828.38,69279.71,0.00,0.00,451.33,352037.40,0.00,0.00,0.00),('1','219','1','276',1103,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','276',1104,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','277',1105,'1','1',80681.27,81238.45,0.00,0.00,557.18,434600.40,0.00,0.00,0.00),('1','219','1','277',1106,'2','1',69279.71,69647.64,0.00,0.00,367.93,286985.40,0.00,0.00,0.00),('1','219','1','277',1107,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','277',1108,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','278',1109,'1','1',81238.45,81394.55,0.00,0.00,156.10,121758.00,0.00,0.00,0.00),('1','219','1','278',1110,'2','1',69647.64,69741.80,0.00,0.00,94.16,73444.80,0.00,0.00,0.00),('1','219','1','278',1111,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','278',1112,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','279',1113,'1','1',81394.55,81394.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','279',1114,'2','1',69741.80,69741.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','279',1115,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','279',1116,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','280',1117,'1','1',81394.55,81852.77,0.00,0.00,458.22,357411.60,0.00,0.00,0.00),('1','219','1','280',1118,'2','1',69741.80,69994.02,0.00,0.00,252.22,196731.60,0.00,0.00,0.00),('1','219','1','280',1119,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','280',1120,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','281',1121,'1','1',81852.77,82188.42,0.00,0.00,335.65,261807.00,0.00,0.00,0.00),('1','219','1','281',1122,'2','1',69994.02,70321.60,0.00,0.00,327.58,255512.40,0.00,0.00,0.00),('1','219','1','281',1123,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','281',1124,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','282',1125,'1','1',82188.42,82566.90,0.00,0.00,378.48,295214.40,0.00,0.00,0.00),('1','219','1','282',1126,'2','1',70321.60,70733.95,0.00,0.00,412.35,321633.00,0.00,0.00,0.00),('1','219','1','282',1127,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','282',1128,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','283',1129,'1','1',82566.90,82845.13,0.00,0.00,278.23,217019.40,0.00,0.00,0.00),('1','219','1','283',1130,'2','1',70733.95,71148.15,0.00,0.00,414.20,323076.00,0.00,0.00,0.00),('1','219','1','283',1131,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','283',1132,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','284',1133,'1','1',82845.13,83314.32,0.00,0.00,469.19,365968.20,0.00,0.00,0.00),('1','219','1','284',1134,'2','1',71148.15,71592.35,0.00,0.00,444.20,346476.00,0.00,0.00,0.00),('1','219','1','284',1135,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','284',1136,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','285',1137,'1','1',83314.32,83735.53,0.00,0.00,421.21,328543.80,0.00,0.00,0.00),('1','219','1','285',1138,'2','1',71592.35,71949.79,0.00,0.00,357.44,278803.20,0.00,0.00,0.00),('1','219','1','285',1139,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','285',1140,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','286',1141,'1','1',83735.53,83973.23,0.00,0.00,237.70,185406.00,0.00,0.00,0.00),('1','219','1','286',1142,'2','1',71949.79,72355.38,0.00,0.00,405.59,316360.20,0.00,0.00,0.00),('1','219','1','286',1143,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','286',1144,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','287',1145,'1','1',83973.23,84272.08,0.00,0.00,298.85,233103.00,0.00,0.00,0.00),('1','219','1','287',1146,'2','1',72355.38,72570.06,0.00,0.00,214.68,158863.20,0.00,0.00,0.00),('1','219','1','287',1147,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','287',1148,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','288',1149,'1','1',84272.08,84699.21,0.00,0.00,427.13,333161.40,0.00,0.00,0.00),('1','219','1','288',1150,'2','1',72570.06,72929.47,0.00,0.00,359.41,265963.40,0.00,0.00,0.00),('1','219','1','288',1151,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','288',1152,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','289',1153,'1','1',84699.21,85066.45,0.00,0.00,367.24,286447.20,0.00,0.00,0.00),('1','219','1','289',1154,'2','1',72929.47,73488.09,0.00,0.00,558.62,413378.80,0.00,0.00,0.00),('1','219','1','289',1155,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','289',1156,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','290',1157,'1','1',85066.45,85538.81,0.00,0.00,472.36,368440.80,0.00,0.00,0.00),('1','219','1','290',1158,'2','1',73488.09,74016.47,0.00,0.00,528.38,391001.20,0.00,0.00,0.00),('1','219','1','290',1159,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','290',1160,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','291',1161,'1','1',85538.81,85879.62,0.00,0.00,340.81,265831.80,0.00,0.00,0.00),('1','219','1','291',1162,'2','1',74016.47,74385.61,0.00,0.00,369.14,273163.60,0.00,0.00,0.00),('1','219','1','291',1163,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','291',1164,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','292',1165,'1','1',85879.62,86463.80,0.00,0.00,584.18,455660.40,0.00,0.00,0.00),('1','219','1','292',1166,'2','1',74385.61,74707.24,0.00,0.00,321.63,238006.20,0.00,0.00,0.00),('1','219','1','292',1167,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','292',1168,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','293',1169,'1','1',86463.80,86859.84,0.00,0.00,396.04,308911.20,0.00,0.00,0.00),('1','219','1','293',1170,'2','1',74707.24,75386.83,0.00,0.00,679.59,502896.60,0.00,0.00,0.00),('1','219','1','293',1171,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','293',1172,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','294',1173,'1','1',86859.84,87012.34,0.00,0.00,152.50,118950.00,0.00,0.00,0.00),('1','219','1','294',1174,'2','1',75386.83,75555.34,0.00,0.00,168.51,124697.40,0.00,0.00,0.00),('1','219','1','294',1175,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','294',1176,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','295',1177,'1','1',87012.34,87012.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','295',1178,'2','1',75555.34,75555.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','295',1179,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','295',1180,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','296',1181,'1','1',87012.34,87149.59,0.00,0.00,137.25,107055.00,0.00,0.00,0.00),('1','219','1','296',1182,'2','1',75555.34,75813.84,0.00,0.00,258.50,191290.00,0.00,0.00,0.00),('1','219','1','296',1183,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','296',1184,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','297',1185,'1','1',87149.59,87627.95,0.00,0.00,478.36,373120.80,0.00,0.00,0.00),('1','219','1','297',1186,'2','1',75813.84,76392.68,0.00,0.00,578.84,428341.60,0.00,0.00,0.00),('1','219','1','297',1187,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','297',1188,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','298',1189,'1','1',87627.95,88085.61,0.00,0.00,457.66,356974.80,0.00,0.00,0.00),('1','219','1','298',1190,'2','1',76392.68,76848.23,0.00,0.00,455.55,337107.00,0.00,0.00,0.00),('1','219','1','298',1191,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','298',1192,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','299',1193,'1','1',88085.61,88656.55,0.00,0.00,570.94,445333.20,0.00,0.00,0.00),('1','219','1','299',1194,'2','1',76848.23,77356.28,0.00,0.00,508.05,375957.00,0.00,0.00,0.00),('1','219','1','299',1195,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','299',1196,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','300',1197,'1','1',88656.55,88923.37,0.00,0.00,266.82,197975.40,0.00,0.00,0.00),('1','219','1','300',1198,'2','1',77356.28,77628.68,0.00,0.00,272.40,193404.00,0.00,0.00,0.00),('1','219','1','300',1199,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','300',1200,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','301',1201,'1','1',88923.37,89275.01,0.00,0.00,351.64,258807.04,0.00,0.00,0.00),('1','219','1','301',1202,'2','1',77628.68,78214.05,0.00,0.00,585.37,415612.70,0.00,0.00,0.00),('1','219','1','301',1203,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','301',1204,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','302',1205,'1','1',89275.01,89572.70,0.00,0.00,297.69,219099.84,0.00,0.00,0.00),('1','219','1','302',1206,'2','1',78214.05,78678.88,0.00,0.00,464.83,330029.30,0.00,0.00,0.00),('1','219','1','302',1207,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','302',1208,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','303',1209,'1','1',89572.70,89688.74,0.00,0.00,116.04,85405.44,0.00,0.00,0.00),('1','219','1','303',1210,'2','1',78678.88,78738.67,0.00,0.00,59.79,42450.90,0.00,0.00,0.00),('1','219','1','303',1211,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','303',1212,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','304',1213,'1','1',89688.74,89863.77,0.00,0.00,175.03,128822.08,0.00,0.00,0.00),('1','219','1','304',1214,'2','1',78738.67,79179.81,0.00,0.00,441.14,313209.40,0.00,0.00,0.00),('1','219','1','304',1215,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','304',1216,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','305',1217,'1','1',89863.77,90527.22,0.00,0.00,663.45,488299.20,0.00,0.00,0.00),('1','219','1','305',1218,'2','1',79179.81,79942.86,0.00,0.00,763.05,541765.50,0.00,0.00,0.00),('1','219','1','305',1219,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','305',1220,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','306',1221,'1','1',90527.22,91005.05,0.00,0.00,477.83,351682.88,0.00,0.00,0.00),('1','219','1','306',1222,'2','1',79942.86,80597.03,0.00,0.00,654.17,464460.70,0.00,0.00,0.00),('1','219','1','306',1223,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','306',1224,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','307',1225,'1','1',91005.05,91454.51,0.00,0.00,449.46,330802.56,0.00,0.00,0.00),('1','219','1','307',1226,'2','1',80597.03,81233.66,0.00,0.00,636.63,452007.30,0.00,0.00,0.00),('1','219','1','307',1227,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','307',1228,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','308',1229,'1','1',91454.51,91857.58,0.00,0.00,403.07,296659.52,0.00,0.00,0.00),('1','219','1','308',1230,'2','1',81233.66,81984.56,0.00,0.00,750.90,533139.00,0.00,0.00,0.00),('1','219','1','308',1231,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','308',1232,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','309',1233,'1','1',91857.58,92265.04,0.00,0.00,407.46,299890.56,0.00,0.00,0.00),('1','219','1','309',1234,'2','1',81984.56,82566.70,0.00,0.00,582.14,413319.40,0.00,0.00,0.00),('1','219','1','309',1235,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','309',1236,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','310',1237,'1','1',92265.04,92265.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','310',1238,'2','1',82566.70,82566.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','310',1239,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','310',1240,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','311',1241,'1','1',92265.04,92265.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','311',1242,'2','1',82566.70,82566.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','311',1243,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','311',1244,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','312',1245,'1','1',92265.04,92660.40,0.00,0.00,395.36,290984.96,0.00,0.00,0.00),('1','219','1','312',1246,'2','1',82566.70,82966.46,0.00,0.00,399.76,283829.60,0.00,0.00,0.00),('1','219','1','312',1247,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','312',1248,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','313',1249,'1','1',92660.40,93144.52,0.00,0.00,484.12,356312.32,0.00,0.00,0.00),('1','219','1','313',1250,'2','1',82966.46,83635.32,0.00,0.00,668.86,474890.60,0.00,0.00,0.00),('1','219','1','313',1251,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','313',1252,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','314',1253,'1','1',93144.52,93526.81,0.00,0.00,382.29,281365.44,0.00,0.00,0.00),('1','219','1','314',1254,'2','1',83635.32,84300.04,0.00,0.00,664.72,471951.20,0.00,0.00,0.00),('1','219','1','314',1255,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','314',1256,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','315',1257,'1','1',93526.81,94033.24,0.00,0.00,506.43,371042.48,0.00,0.00,0.00),('1','219','1','315',1258,'2','1',84300.04,85105.76,0.00,0.00,805.72,572061.20,0.00,0.00,0.00),('1','219','1','315',1259,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','315',1260,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','316',1261,'1','1',94033.24,94439.64,0.00,0.00,406.40,299110.40,0.00,0.00,0.00),('1','219','1','316',1262,'2','1',85105.76,85595.53,0.00,0.00,489.77,347736.70,0.00,0.00,0.00),('1','219','1','316',1263,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','316',1264,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','317',1265,'1','1',94439.64,94656.57,0.00,0.00,216.93,159660.48,0.00,0.00,0.00),('1','219','1','317',1266,'2','1',85595.53,85925.78,0.00,0.00,330.25,234477.50,0.00,0.00,0.00),('1','219','1','317',1267,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','317',1268,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','318',1269,'1','1',94656.57,94656.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','318',1270,'2','1',85925.78,85925.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','318',1271,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','318',1272,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','319',1273,'1','1',94656.57,94801.30,0.00,0.00,144.73,106521.28,0.00,0.00,0.00),('1','219','1','319',1274,'2','1',85925.78,86096.42,0.00,0.00,170.64,121154.40,0.00,0.00,0.00),('1','219','1','319',1275,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','319',1276,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','320',1277,'1','1',94801.30,95243.07,0.00,0.00,441.77,325142.72,0.00,0.00,0.00),('1','219','1','320',1278,'2','1',86096.42,87294.26,0.00,0.00,1197.84,850466.40,0.00,0.00,0.00),('1','219','1','320',1279,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','320',1280,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','321',1281,'1','1',95243.07,95573.50,0.00,0.00,330.43,243196.48,0.00,0.00,0.00),('1','219','1','321',1282,'2','1',87294.26,88190.94,0.00,0.00,896.68,636642.80,0.00,0.00,0.00),('1','219','1','321',1283,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','321',1284,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','322',1285,'1','1',95573.50,95968.81,0.00,0.00,395.31,290948.16,0.00,0.00,0.00),('1','219','1','322',1286,'2','1',88190.94,88806.93,0.00,0.00,615.99,437352.90,0.00,0.00,0.00),('1','219','1','322',1287,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','322',1288,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','323',1289,'1','1',95968.81,96406.12,0.00,0.00,437.31,321860.16,0.00,0.00,0.00),('1','219','1','323',1290,'2','1',88806.93,89712.28,0.00,0.00,905.35,642798.50,0.00,0.00,0.00),('1','219','1','323',1291,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','323',1292,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','324',1293,'1','1',96406.12,96444.64,0.00,0.00,38.52,28350.72,0.00,0.00,0.00),('1','219','1','324',1294,'2','1',89712.28,89874.14,0.00,0.00,161.86,114920.60,0.00,0.00,0.00),('1','219','1','324',1295,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','324',1296,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','325',1297,'1','1',96444.64,96444.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','325',1298,'2','1',89874.14,89874.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','325',1299,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','325',1300,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','326',1301,'1','1',96444.64,96596.30,0.00,0.00,151.66,111621.76,0.00,0.00,0.00),('1','219','1','326',1302,'2','1',89874.14,90155.29,0.00,0.00,281.15,199616.50,0.00,0.00,0.00),('1','219','1','326',1303,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','326',1304,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','327',1305,'1','1',96596.30,97006.34,0.00,0.00,410.04,301789.44,0.00,0.00,0.00),('1','219','1','327',1306,'2','1',90155.29,91074.18,0.00,0.00,918.89,652411.90,0.00,0.00,0.00),('1','219','1','327',1307,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','327',1308,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','328',1309,'1','1',97006.34,97382.08,0.00,0.00,375.74,276544.64,0.00,0.00,0.00),('1','219','1','328',1310,'2','1',91074.18,91830.74,0.00,0.00,756.56,537157.60,0.00,0.00,0.00),('1','219','1','328',1311,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','328',1312,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','329',1313,'1','1',97382.08,97746.33,0.00,0.00,364.25,268088.00,0.00,0.00,0.00),('1','219','1','329',1314,'2','1',91830.74,92693.64,0.00,0.00,862.90,612659.00,0.00,0.00,0.00),('1','219','1','329',1315,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','329',1316,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','330',1317,'1','1',97746.33,98128.03,0.00,0.00,381.70,280931.20,0.00,0.00,0.00),('1','219','1','330',1318,'2','1',92693.64,93711.83,0.00,0.00,1018.19,722914.90,0.00,0.00,0.00),('1','219','1','330',1319,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','330',1320,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','331',1321,'1','1',98128.03,98157.04,0.00,0.00,29.01,21351.36,0.00,0.00,0.00),('1','219','1','331',1322,'2','1',93711.83,93846.61,0.00,0.00,134.78,95693.80,0.00,0.00,0.00),('1','219','1','331',1323,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','331',1324,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','332',1325,'1','1',98157.04,98157.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','332',1326,'2','1',93846.61,93846.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','332',1327,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','332',1328,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','333',1329,'1','1',98157.04,98363.29,0.00,0.00,206.25,151800.00,0.00,0.00,0.00),('1','219','1','333',1330,'2','1',93846.61,94398.46,0.00,0.00,551.85,391813.50,0.00,0.00,0.00),('1','219','1','333',1331,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','333',1332,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','334',1333,'1','1',98363.29,98831.18,0.00,0.00,467.89,344367.04,0.00,0.00,0.00),('1','219','1','334',1334,'2','1',94398.46,95412.22,0.00,0.00,1013.76,719769.60,0.00,0.00,0.00),('1','219','1','334',1335,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','334',1336,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','335',1337,'1','1',98831.18,99328.71,0.00,0.00,497.53,366182.08,0.00,0.00,0.00),('1','219','1','335',1338,'2','1',95412.22,96376.10,0.00,0.00,963.88,684354.80,0.00,0.00,0.00),('1','219','1','335',1339,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','335',1340,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','336',1341,'1','1',99328.71,99811.73,0.00,0.00,483.02,355502.72,0.00,0.00,0.00),('1','219','1','336',1342,'2','1',96376.10,97279.91,0.00,0.00,903.81,641705.10,0.00,0.00,0.00),('1','219','1','336',1343,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','336',1344,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','337',1345,'1','1',99811.73,100028.34,0.00,0.00,216.61,159424.96,0.00,0.00,0.00),('1','219','1','337',1346,'2','1',97279.91,97809.31,0.00,0.00,529.40,375874.00,0.00,0.00,0.00),('1','219','1','337',1347,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','337',1348,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','338',1349,'1','1',100028.34,100380.20,0.00,0.00,351.86,258968.96,0.00,0.00,0.00),('1','219','1','338',1350,'2','1',97809.31,98216.20,0.00,0.00,406.89,288891.90,0.00,0.00,0.00),('1','219','1','338',1351,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','338',1352,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','339',1353,'1','1',100380.20,101001.33,0.00,0.00,621.13,457151.68,0.00,0.00,0.00),('1','219','1','339',1354,'2','1',98216.20,99709.45,0.00,0.00,1493.25,1060207.50,0.00,0.00,0.00),('1','219','1','339',1355,'3','1',13856.25,13856.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','339',1356,'4','1',8649.18,8649.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','340',1357,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','340',1358,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','340',1359,'3','1',13856.25,14278.18,0.00,0.00,421.93,310540.48,0.00,0.00,0.00),('1','219','1','340',1360,'4','1',8649.18,9354.12,0.00,0.00,704.94,500507.40,0.00,0.00,0.00),('1','219','1','341',1361,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','341',1362,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','341',1363,'3','1',14278.18,14804.97,0.00,0.00,526.79,387717.44,0.00,0.00,0.00),('1','219','1','341',1364,'4','1',9354.12,9957.16,0.00,0.00,603.04,428158.40,0.00,0.00,0.00),('1','219','1','342',1365,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','342',1366,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','342',1367,'3','1',14804.97,15091.93,0.00,0.00,286.96,211202.56,0.00,0.00,0.00),('1','219','1','342',1368,'4','1',9957.16,10430.78,0.00,0.00,473.62,336270.20,0.00,0.00,0.00),('1','219','1','343',1369,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','343',1370,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','343',1371,'3','1',15091.93,15667.20,0.00,0.00,575.27,423398.72,0.00,0.00,0.00),('1','219','1','343',1372,'4','1',10430.78,11479.95,0.00,0.00,1049.17,744910.70,0.00,0.00,0.00),('1','219','1','344',1373,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','344',1374,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','344',1375,'3','1',15667.20,16129.08,0.00,0.00,461.88,339943.68,0.00,0.00,0.00),('1','219','1','344',1376,'4','1',11479.95,12296.66,0.00,0.00,816.71,579864.10,0.00,0.00,0.00),('1','219','1','345',1377,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','345',1378,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','345',1379,'3','1',16129.08,16598.73,0.00,0.00,469.65,345662.40,0.00,0.00,0.00),('1','219','1','345',1380,'4','1',12296.66,13388.43,0.00,0.00,1091.77,775156.70,0.00,0.00,0.00),('1','219','1','346',1381,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','346',1382,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','346',1383,'3','1',16598.73,17167.38,0.00,0.00,568.65,418526.40,0.00,0.00,0.00),('1','219','1','346',1384,'4','1',13388.43,13793.11,0.00,0.00,404.68,287322.80,0.00,0.00,0.00),('1','219','1','347',1385,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','347',1386,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','347',1387,'3','1',17167.38,17561.09,0.00,0.00,393.71,289770.56,0.00,0.00,0.00),('1','219','1','347',1388,'4','1',13793.11,13861.96,0.00,0.00,68.85,48883.50,0.00,0.00,0.00),('1','219','1','348',1389,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','348',1390,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','348',1391,'3','1',17561.09,17717.55,0.00,0.00,156.46,115154.56,0.00,0.00,0.00),('1','219','1','348',1392,'4','1',13861.96,14002.39,0.00,0.00,140.43,99705.30,0.00,0.00,0.00),('1','219','1','349',1393,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','349',1394,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','349',1395,'3','1',17717.55,18158.75,0.00,0.00,441.20,324723.20,0.00,0.00,0.00),('1','219','1','349',1396,'4','1',14002.39,14612.33,0.00,0.00,609.94,433057.40,0.00,0.00,0.00),('1','219','1','350',1397,'1','1',101001.33,101001.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','350',1398,'2','1',99709.45,99709.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','350',1399,'3','1',18158.75,18617.67,0.00,0.00,458.92,337765.12,0.00,0.00,0.00),('1','219','1','350',1400,'4','1',14612.33,15213.34,0.00,0.00,601.01,426717.10,0.00,0.00,0.00),('1','219','1','351',1401,'1','1',101001.33,101167.58,0.00,0.00,166.25,122360.00,0.00,0.00,0.00),('1','219','1','351',1402,'2','1',99709.45,99727.04,0.00,0.00,17.59,12488.90,0.00,0.00,0.00),('1','219','1','351',1403,'3','1',18617.67,18855.06,0.00,0.00,237.39,174719.04,0.00,0.00,0.00),('1','219','1','351',1404,'4','1',15213.34,15693.98,0.00,0.00,480.64,341254.40,0.00,0.00,0.00),('1','219','1','352',1405,'1','1',101167.58,101625.93,0.00,0.00,458.35,337345.60,0.00,0.00,0.00),('1','219','1','352',1406,'2','1',99727.04,100672.48,0.00,0.00,945.44,671262.40,0.00,0.00,0.00),('1','219','1','352',1407,'3','1',18855.06,18855.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','352',1408,'4','1',15693.98,15693.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','353',1409,'1','1',101625.93,101625.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','353',1410,'2','1',100672.48,100672.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','353',1411,'3','1',18855.06,19333.94,0.00,0.00,478.88,352455.68,0.00,0.00,0.00),('1','219','1','353',1412,'4','1',15693.98,16279.58,0.00,0.00,585.60,415776.00,0.00,0.00,0.00),('1','219','1','354',1413,'1','1',101625.93,101796.58,0.00,0.00,170.65,125598.40,0.00,0.00,0.00),('1','219','1','354',1414,'2','1',100672.48,100794.14,0.00,0.00,121.66,86378.60,0.00,0.00,0.00),('1','219','1','354',1415,'3','1',19333.94,19635.09,0.00,0.00,301.15,221646.40,0.00,0.00,0.00),('1','219','1','354',1416,'4','1',16279.58,16785.70,0.00,0.00,506.12,359345.20,0.00,0.00,0.00),('1','219','1','355',1417,'1','1',101796.58,102223.28,0.00,0.00,426.70,314051.20,0.00,0.00,0.00),('1','219','1','355',1418,'2','1',100794.14,101188.00,0.00,0.00,393.86,279640.60,0.00,0.00,0.00),('1','219','1','355',1419,'3','1',19635.09,19635.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','355',1420,'4','1',16785.70,16785.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','356',1421,'1','1',102223.28,102642.69,0.00,0.00,419.41,308685.76,0.00,0.00,0.00),('1','219','1','356',1422,'2','1',101188.00,101859.49,0.00,0.00,671.49,476757.90,0.00,0.00,0.00),('1','219','1','356',1423,'3','1',19635.09,19635.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','356',1424,'4','1',16785.70,16785.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','357',1425,'1','1',102642.69,103129.41,0.00,0.00,486.72,358225.92,0.00,0.00,0.00),('1','219','1','357',1426,'2','1',101859.49,103066.55,0.00,0.00,1207.06,857012.60,0.00,0.00,0.00),('1','219','1','357',1427,'3','1',19635.09,19635.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','357',1428,'4','1',16785.70,16785.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','358',1429,'1','1',103129.41,103372.84,0.00,0.00,243.43,179164.48,0.00,0.00,0.00),('1','219','1','358',1430,'2','1',103066.55,104039.73,0.00,0.00,973.18,690957.80,0.00,0.00,0.00),('1','219','1','358',1431,'3','1',19635.09,19635.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','358',1432,'4','1',16785.70,16785.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','359',1433,'1','1',103372.84,104182.89,0.00,0.00,810.05,596196.80,0.00,0.00,0.00),('1','219','1','359',1434,'2','1',104039.73,104973.98,0.00,0.00,934.25,663317.50,0.00,0.00,0.00),('1','219','1','359',1435,'3','1',19635.09,19635.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','359',1436,'4','1',16785.70,16785.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','360',1437,'1','1',104182.89,104562.37,0.00,0.00,379.48,279297.28,0.00,0.00,0.00),('1','219','1','360',1438,'2','1',104973.98,105588.90,0.00,0.00,614.92,436593.20,0.00,0.00,0.00),('1','219','1','360',1439,'3','1',19635.09,19635.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','360',1440,'4','1',16785.70,16785.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','361',1441,'1','1',104562.37,105302.30,0.00,0.00,739.93,544588.48,0.00,0.00,0.00),('1','219','1','361',1442,'2','1',105588.90,106690.56,0.00,0.00,1101.66,782178.60,0.00,0.00,0.00),('1','219','1','361',1443,'3','1',19635.09,19635.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','361',1444,'4','1',16785.70,16785.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','362',1445,'1','1',105302.30,105525.88,0.00,0.00,223.58,164554.88,0.00,0.00,0.00),('1','219','1','362',1446,'2','1',106690.56,107207.45,0.00,0.00,516.89,366991.90,0.00,0.00,0.00),('1','219','1','362',1447,'3','1',19635.09,19813.07,0.00,0.00,177.98,130993.28,0.00,0.00,0.00),('1','219','1','362',1448,'4','1',16785.70,16993.35,0.00,0.00,207.65,147431.50,0.00,0.00,0.00),('1','219','1','363',1449,'1','1',105525.88,105551.58,0.00,0.00,25.70,18915.20,0.00,0.00,0.00),('1','219','1','363',1450,'2','1',107207.45,107307.45,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','219','1','363',1451,'3','1',19813.07,19813.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','363',1452,'4','1',16993.35,16993.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','364',1453,'1','1',105551.58,106190.88,0.00,0.00,639.30,470524.80,0.00,0.00,0.00),('1','219','1','364',1454,'2','1',107307.45,108418.71,0.00,0.00,1111.26,788994.60,0.00,0.00,0.00),('1','219','1','364',1455,'3','1',19813.07,19829.87,0.00,0.00,16.80,12364.80,0.00,0.00,0.00),('1','219','1','364',1456,'4','1',16993.35,17005.85,0.00,0.00,12.50,8875.00,0.00,0.00,0.00),('1','219','1','365',1457,'1','1',106190.88,106811.19,0.00,0.00,620.31,456548.16,0.00,0.00,0.00),('1','219','1','365',1458,'2','1',108418.71,109562.57,0.00,0.00,1143.86,812140.60,0.00,0.00,0.00),('1','219','1','365',1459,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','365',1460,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','366',1461,'1','1',106811.19,107403.39,0.00,0.00,592.20,435859.20,0.00,0.00,0.00),('1','219','1','366',1462,'2','1',109562.57,110148.68,0.00,0.00,586.11,416244.18,0.00,0.00,0.00),('1','219','1','366',1463,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','366',1464,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','367',1465,'1','1',107403.39,107897.78,0.00,0.00,494.39,361921.04,0.00,0.00,0.00),('1','219','1','367',1466,'2','1',110148.68,110723.14,0.00,0.00,574.46,407866.60,0.00,0.00,0.00),('1','219','1','367',1467,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','367',1468,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','368',1469,'1','1',107897.78,108496.04,0.00,0.00,598.26,440319.36,0.00,0.00,0.00),('1','219','1','368',1470,'2','1',110723.14,111449.94,0.00,0.00,726.80,516028.00,0.00,0.00,0.00),('1','219','1','368',1471,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','368',1472,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','369',1473,'1','1',108496.04,108912.16,0.00,0.00,416.12,306264.32,0.00,0.00,0.00),('1','219','1','369',1474,'2','1',111449.94,112061.97,0.00,0.00,612.03,434725.64,0.00,0.00,0.00),('1','219','1','369',1475,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','369',1476,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','370',1477,'1','1',108912.16,109098.69,0.00,0.00,186.53,137286.08,0.00,0.00,0.00),('1','219','1','370',1478,'2','1',112061.97,112111.97,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','219','1','370',1479,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','370',1480,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','371',1481,'1','1',109098.69,109522.57,0.00,0.00,423.88,311975.68,0.00,0.00,0.00),('1','219','1','371',1482,'2','1',112111.97,112507.97,0.00,0.00,396.00,281160.00,0.00,0.00,0.00),('1','219','1','371',1483,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','371',1484,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','372',1485,'1','1',109522.57,109906.13,0.00,0.00,383.56,279700.16,0.00,0.00,0.00),('1','219','1','372',1486,'2','1',112507.97,113075.82,0.00,0.00,567.85,403173.50,0.00,0.00,0.00),('1','219','1','372',1487,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','372',1488,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','373',1489,'1','1',109906.13,110626.01,0.00,0.00,719.88,529831.68,0.00,0.00,0.00),('1','219','1','373',1490,'2','1',113075.82,113118.82,0.00,0.00,43.00,30530.00,0.00,0.00,0.00),('1','219','1','373',1491,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','373',1492,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','374',1493,'1','1',110626.01,111086.85,0.00,0.00,460.84,339178.24,0.00,0.00,0.00),('1','219','1','374',1494,'2','1',113118.82,113388.62,0.00,0.00,269.80,191558.00,0.00,0.00,0.00),('1','219','1','374',1495,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','374',1496,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','375',1497,'1','1',111086.85,111491.94,0.00,0.00,405.09,298146.24,0.00,0.00,0.00),('1','219','1','375',1498,'2','1',113388.62,113777.12,0.00,0.00,388.50,275835.00,0.00,0.00,0.00),('1','219','1','375',1499,'3','1',19829.87,19829.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','375',1500,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','376',1501,'1','1',111491.94,111741.88,0.00,0.00,249.94,183955.84,0.00,0.00,0.00),('1','219','1','376',1502,'2','1',113777.12,113877.10,0.00,0.00,99.98,70985.80,0.00,0.00,0.00),('1','219','1','376',1503,'3','1',19829.87,19842.66,0.00,0.00,12.79,9413.44,0.00,0.00,0.00),('1','219','1','376',1504,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','377',1505,'1','1',111741.88,112199.12,0.00,0.00,457.24,336528.64,0.00,0.00,0.00),('1','219','1','377',1506,'2','1',113877.10,114331.61,0.00,0.00,454.51,322702.10,0.00,0.00,0.00),('1','219','1','377',1507,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','377',1508,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','378',1509,'1','1',112199.12,112408.09,0.00,0.00,208.97,153801.92,0.00,0.00,0.00),('1','219','1','378',1510,'2','1',114331.61,114561.05,0.00,0.00,229.44,162902.40,0.00,0.00,0.00),('1','219','1','378',1511,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','378',1512,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','379',1513,'1','1',112408.09,112614.68,0.00,0.00,206.59,152050.24,0.00,0.00,0.00),('1','219','1','379',1514,'2','1',114561.05,114648.47,0.00,0.00,87.42,62068.20,0.00,0.00,0.00),('1','219','1','379',1515,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','379',1516,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','380',1517,'1','1',112614.68,113160.24,0.00,0.00,545.56,401532.16,0.00,0.00,0.00),('1','219','1','380',1518,'2','1',114648.47,115076.49,0.00,0.00,428.02,303894.20,0.00,0.00,0.00),('1','219','1','380',1519,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','380',1520,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','381',1521,'1','1',113160.24,113627.66,0.00,0.00,467.42,344021.12,0.00,0.00,0.00),('1','219','1','381',1522,'2','1',115076.49,115416.96,0.00,0.00,340.47,241733.70,0.00,0.00,0.00),('1','219','1','381',1523,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','381',1524,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','382',1525,'1','1',113627.66,113633.09,0.00,0.00,5.43,3996.48,0.00,0.00,0.00),('1','219','1','382',1526,'2','1',115416.96,115416.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','382',1527,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','382',1528,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','383',1529,'1','1',113633.09,113928.05,0.00,0.00,294.96,217090.56,0.00,0.00,0.00),('1','219','1','383',1530,'2','1',115416.96,115526.46,0.00,0.00,109.50,77745.00,0.00,0.00,0.00),('1','219','1','383',1531,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','383',1532,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','384',1533,'1','1',113928.05,114275.61,0.00,0.00,347.56,255804.16,0.00,0.00,0.00),('1','219','1','384',1534,'2','1',115526.46,115675.53,0.00,0.00,149.07,105839.70,0.00,0.00,0.00),('1','219','1','384',1535,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','384',1536,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','385',1537,'1','1',114275.61,114622.04,0.00,0.00,346.43,254972.48,0.00,0.00,0.00),('1','219','1','385',1538,'2','1',115675.53,115681.53,0.00,0.00,6.00,4260.00,0.00,0.00,0.00),('1','219','1','385',1539,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','385',1540,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','386',1541,'1','1',114622.04,114957.12,0.00,0.00,335.08,246618.88,0.00,0.00,0.00),('1','219','1','386',1542,'2','1',115681.53,115770.99,0.00,0.00,89.46,63516.60,0.00,0.00,0.00),('1','219','1','386',1543,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','386',1544,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','387',1545,'1','1',114957.12,115099.21,0.00,0.00,142.09,104578.24,0.00,0.00,0.00),('1','219','1','387',1546,'2','1',115770.99,115798.99,0.00,0.00,28.00,19880.00,0.00,0.00,0.00),('1','219','1','387',1547,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','387',1548,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','388',1549,'1','1',115099.21,115367.19,0.00,0.00,267.98,197233.28,0.00,0.00,0.00),('1','219','1','388',1550,'2','1',115798.99,115831.09,0.00,0.00,32.10,22791.00,0.00,0.00,0.00),('1','219','1','388',1551,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','388',1552,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','389',1553,'1','1',115367.19,115955.51,0.00,0.00,588.32,433003.52,0.00,0.00,0.00),('1','219','1','389',1554,'2','1',115831.09,116022.10,0.00,0.00,191.01,135617.10,0.00,0.00,0.00),('1','219','1','389',1555,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','389',1556,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','390',1557,'1','1',115955.51,116294.41,0.00,0.00,338.90,249430.40,0.00,0.00,0.00),('1','219','1','390',1558,'2','1',116022.10,116438.39,0.00,0.00,416.29,295565.90,0.00,0.00,0.00),('1','219','1','390',1559,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','390',1560,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','391',1561,'1','1',116294.41,116294.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','391',1562,'2','1',116438.39,116438.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','391',1563,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','391',1564,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','392',1565,'1','1',116294.41,116801.99,0.00,0.00,507.58,373578.88,0.00,0.00,0.00),('1','219','1','392',1566,'2','1',116438.39,116699.67,0.00,0.00,261.28,185508.80,0.00,0.00,0.00),('1','219','1','392',1567,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','392',1568,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','393',1569,'1','1',116801.99,117193.93,0.00,0.00,391.94,288467.84,0.00,0.00,0.00),('1','219','1','393',1570,'2','1',116699.67,117171.92,0.00,0.00,472.25,335297.50,0.00,0.00,0.00),('1','219','1','393',1571,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','393',1572,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','394',1573,'1','1',117193.93,117231.41,0.00,0.00,37.48,27585.28,0.00,0.00,0.00),('1','219','1','394',1574,'2','1',117171.92,117171.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','394',1575,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','394',1576,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','395',1577,'1','1',117231.41,117231.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','395',1578,'2','1',117171.92,117171.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','395',1579,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','395',1580,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','396',1581,'1','1',117231.41,117623.25,0.00,0.00,391.84,288394.24,0.00,0.00,0.00),('1','219','1','396',1582,'2','1',117171.92,117325.22,0.00,0.00,153.30,108843.00,0.00,0.00,0.00),('1','219','1','396',1583,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','396',1584,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','397',1585,'1','1',117623.25,118008.84,0.00,0.00,385.59,283794.24,0.00,0.00,0.00),('1','219','1','397',1586,'2','1',117325.22,118257.06,0.00,0.00,931.84,661788.40,0.00,0.00,0.00),('1','219','1','397',1587,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','397',1588,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','398',1589,'1','1',118008.84,118270.59,0.00,0.00,261.75,192648.00,0.00,0.00,0.00),('1','219','1','398',1590,'2','1',118257.06,118431.09,0.00,0.00,174.03,123561.30,0.00,0.00,0.00),('1','219','1','398',1591,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','398',1592,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','399',1593,'1','1',118270.59,118795.95,0.00,0.00,525.36,386664.96,0.00,0.00,0.00),('1','219','1','399',1594,'2','1',118431.09,118632.17,0.00,0.00,201.08,142766.80,0.00,0.00,0.00),('1','219','1','399',1595,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','399',1596,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','400',1597,'1','1',118795.95,119413.72,0.00,0.00,617.77,454678.72,0.00,0.00,0.00),('1','219','1','400',1598,'2','1',118632.17,118815.01,0.00,0.00,182.84,129816.40,0.00,0.00,0.00),('1','219','1','400',1599,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','400',1600,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','401',1601,'1','1',119413.72,119928.61,0.00,0.00,514.89,378634.04,0.00,0.00,0.00),('1','219','1','401',1602,'2','1',118815.01,119275.21,0.00,0.00,460.20,326742.00,0.00,0.00,0.00),('1','219','1','401',1603,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','401',1604,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','402',1605,'1','1',119928.61,120508.51,0.00,0.00,579.90,426806.40,0.00,0.00,0.00),('1','219','1','402',1606,'2','1',119275.21,119369.71,0.00,0.00,94.50,67095.00,0.00,0.00,0.00),('1','219','1','402',1607,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','402',1608,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','403',1609,'1','1',120508.51,120693.16,0.00,0.00,184.65,135902.40,0.00,0.00,0.00),('1','219','1','403',1610,'2','1',119369.71,119555.12,0.00,0.00,185.41,131641.10,0.00,0.00,0.00),('1','219','1','403',1611,'3','1',19842.66,19842.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','403',1612,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','404',1613,'1','1',120693.16,120921.12,0.00,0.00,227.96,167778.56,0.00,0.00,0.00),('1','219','1','404',1614,'2','1',119555.12,119854.12,0.00,0.00,299.00,212290.00,0.00,0.00,0.00),('1','219','1','404',1615,'3','1',19842.66,20108.96,0.00,0.00,266.30,195996.80,0.00,0.00,0.00),('1','219','1','404',1616,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','405',1617,'1','1',120921.12,121585.55,0.00,0.00,664.43,489020.48,0.00,0.00,0.00),('1','219','1','405',1618,'2','1',119854.12,120173.13,0.00,0.00,319.01,226497.10,0.00,0.00,0.00),('1','219','1','405',1619,'3','1',20108.96,20108.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','405',1620,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','406',1621,'1','1',121585.55,121729.81,0.00,0.00,144.26,106175.36,0.00,0.00,0.00),('1','219','1','406',1622,'2','1',120173.13,120357.42,0.00,0.00,184.29,130845.90,0.00,0.00,0.00),('1','219','1','406',1623,'3','1',20108.96,20108.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','406',1624,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','407',1625,'1','1',121729.81,121744.32,0.00,0.00,14.51,10679.36,0.00,0.00,0.00),('1','219','1','407',1626,'2','1',120357.42,120423.21,0.00,0.00,65.79,46710.90,0.00,0.00,0.00),('1','219','1','407',1627,'3','1',20108.96,20108.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','407',1628,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','408',1629,'1','1',121744.32,122132.79,0.00,0.00,388.47,285913.92,0.00,0.00,0.00),('1','219','1','408',1630,'2','1',120423.21,120832.02,0.00,0.00,408.81,290255.10,0.00,0.00,0.00),('1','219','1','408',1631,'3','1',20108.96,20108.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','408',1632,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','409',1633,'1','1',122132.79,122647.04,0.00,0.00,514.25,378488.00,0.00,0.00,0.00),('1','219','1','409',1634,'2','1',120832.02,121078.27,0.00,0.00,246.25,174837.50,0.00,0.00,0.00),('1','219','1','409',1635,'3','1',20108.96,20108.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','409',1636,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','410',1637,'1','1',122647.04,122871.81,0.00,0.00,224.77,165430.72,0.00,0.00,0.00),('1','219','1','410',1638,'2','1',121078.27,121779.30,0.00,0.00,701.03,497731.30,0.00,0.00,0.00),('1','219','1','410',1639,'3','1',20108.96,20108.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','410',1640,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','411',1641,'1','1',122871.81,123194.65,0.00,0.00,322.84,237610.24,0.00,0.00,0.00),('1','219','1','411',1642,'2','1',121779.30,122110.06,0.00,0.00,330.76,234839.60,0.00,0.00,0.00),('1','219','1','411',1643,'3','1',20108.96,20108.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','411',1644,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','412',1645,'1','1',123194.65,123493.72,0.00,0.00,299.07,219673.52,0.00,0.00,0.00),('1','219','1','412',1646,'2','1',122110.06,122286.86,0.00,0.00,176.80,125528.00,0.00,0.00,0.00),('1','219','1','412',1647,'3','1',20108.96,20108.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','412',1648,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','413',1649,'1','1',123493.72,123734.38,0.00,0.00,240.66,177125.76,0.00,0.00,0.00),('1','219','1','413',1650,'2','1',122286.86,122578.56,0.00,0.00,291.70,207107.00,0.00,0.00,0.00),('1','219','1','413',1651,'3','1',20108.96,20108.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','413',1652,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','414',1653,'1','1',123734.38,124032.34,0.00,0.00,297.96,219298.56,0.00,0.00,0.00),('1','219','1','414',1654,'2','1',122578.56,122851.56,0.00,0.00,273.00,193830.00,0.00,0.00,0.00),('1','219','1','414',1655,'3','1',20108.96,20186.77,0.00,0.00,77.81,57268.16,0.00,0.00,0.00),('1','219','1','414',1656,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','415',1657,'1','1',124032.34,124314.37,0.00,0.00,282.03,207574.08,0.00,0.00,0.00),('1','219','1','415',1658,'2','1',122851.56,123096.01,0.00,0.00,244.45,173559.50,0.00,0.00,0.00),('1','219','1','415',1659,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','415',1660,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','416',1661,'1','1',124314.37,124428.08,0.00,0.00,113.71,83690.56,0.00,0.00,0.00),('1','219','1','416',1662,'2','1',123096.01,123174.43,0.00,0.00,78.42,55678.20,0.00,0.00,0.00),('1','219','1','416',1663,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','416',1664,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','417',1665,'1','1',124428.08,124428.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','417',1666,'2','1',123174.43,123174.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','417',1667,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','417',1668,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','418',1669,'1','1',124428.08,124510.79,0.00,0.00,82.71,60874.56,0.00,0.00,0.00),('1','219','1','418',1670,'2','1',123174.43,123242.51,0.00,0.00,68.08,48336.80,0.00,0.00,0.00),('1','219','1','418',1671,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','418',1672,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','419',1673,'1','1',124510.79,124727.51,0.00,0.00,216.72,157338.72,0.00,0.00,0.00),('1','219','1','419',1674,'2','1',123242.51,123562.58,0.00,0.00,320.07,224049.00,0.00,0.00,0.00),('1','219','1','419',1675,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','419',1676,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','420',1677,'1','1',124727.51,125048.52,0.00,0.00,321.01,233053.26,0.00,0.00,0.00),('1','219','1','420',1678,'2','1',123562.58,123788.97,0.00,0.00,226.39,158473.00,0.00,0.00,0.00),('1','219','1','420',1679,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','420',1680,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','421',1681,'1','1',125048.52,125361.74,0.00,0.00,313.22,227397.72,0.00,0.00,0.00),('1','219','1','421',1682,'2','1',123788.97,123978.06,0.00,0.00,189.09,132363.00,0.00,0.00,0.00),('1','219','1','421',1683,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','421',1684,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','422',1685,'1','1',125361.74,125660.62,0.00,0.00,298.88,216986.88,0.00,0.00,0.00),('1','219','1','422',1686,'2','1',123978.06,124468.75,0.00,0.00,490.69,343483.00,0.00,0.00,0.00),('1','219','1','422',1687,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','422',1688,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','423',1689,'1','1',125660.62,126311.96,0.00,0.00,651.34,472872.84,0.00,0.00,0.00),('1','219','1','423',1690,'2','1',124468.75,124640.89,0.00,0.00,172.14,120498.00,0.00,0.00,0.00),('1','219','1','423',1691,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','423',1692,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','424',1693,'1','1',126311.96,126555.08,0.00,0.00,243.12,176505.12,0.00,0.00,0.00),('1','219','1','424',1694,'2','1',124640.89,124890.81,0.00,0.00,249.92,174944.00,0.00,0.00,0.00),('1','219','1','424',1695,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','424',1696,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','425',1697,'1','1',126555.08,126962.83,0.00,0.00,407.75,296026.50,0.00,0.00,0.00),('1','219','1','425',1698,'2','1',124890.81,125054.38,0.00,0.00,163.57,114499.00,0.00,0.00,0.00),('1','219','1','425',1699,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','425',1700,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','426',1701,'1','1',126962.83,127319.40,0.00,0.00,356.57,258869.82,0.00,0.00,0.00),('1','219','1','426',1702,'2','1',125054.38,125590.62,0.00,0.00,536.24,375368.00,0.00,0.00,0.00),('1','219','1','426',1703,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','426',1704,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','427',1705,'1','1',127319.40,127354.70,0.00,0.00,35.30,25627.80,0.00,0.00,0.00),('1','219','1','427',1706,'2','1',125590.62,125590.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','427',1707,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','427',1708,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','428',1709,'1','1',127354.70,127354.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','428',1710,'2','1',125590.62,125590.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','428',1711,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','428',1712,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','429',1713,'1','1',127354.70,127867.52,0.00,0.00,512.82,372307.32,0.00,0.00,0.00),('1','219','1','429',1714,'2','1',125590.62,125655.87,0.00,0.00,65.25,45675.00,0.00,0.00,0.00),('1','219','1','429',1715,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','429',1716,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','430',1717,'1','1',127867.52,128563.58,0.00,0.00,696.06,505339.56,0.00,0.00,0.00),('1','219','1','430',1718,'2','1',125655.87,126636.00,0.00,0.00,980.13,686091.00,0.00,0.00,0.00),('1','219','1','430',1719,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','430',1720,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','431',1721,'1','1',128563.58,128816.80,0.00,0.00,253.22,183837.72,0.00,0.00,0.00),('1','219','1','431',1722,'2','1',126636.00,127521.87,0.00,0.00,885.87,620109.00,0.00,0.00,0.00),('1','219','1','431',1723,'3','1',20186.77,20186.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','219','1','431',1724,'4','1',17005.85,17005.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=432 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','219','1','1',517.00,568.00,0.00,372.28,192468.76,206555.04,14086.28,1),('1','219','2','1',517.00,568.00,0.00,282.22,145907.74,157500.96,11593.22,2),('1','219','3','1',517.00,568.00,0.00,100.66,52041.22,57174.88,5133.66,3),('1','219','4','1',517.00,568.00,0.00,131.97,68228.49,74958.96,6730.47,4),('1','219','5','1',517.00,568.00,0.00,141.12,72959.04,80156.16,7197.12,5),('1','219','6','1',517.00,568.00,0.00,155.06,80166.02,88074.08,7908.06,6),('1','219','7','1',517.00,568.00,0.00,299.79,154991.43,170280.72,15289.29,7),('1','219','8','1',517.00,568.00,0.00,219.81,113641.77,123452.08,9810.31,8),('1','219','9','1',517.00,568.00,0.00,208.96,108032.32,118689.28,10656.96,9),('1','219','10','1',517.00,568.00,0.00,278.47,143968.99,153970.96,10001.97,10),('1','219','11','1',517.00,568.00,0.00,200.66,103741.22,113974.88,10233.66,11),('1','219','12','1',517.00,568.00,0.00,286.47,148104.99,162714.96,14609.97,12),('1','219','13','1',517.00,568.00,0.00,799.24,413207.08,440335.96,27128.88,13),('1','219','14','1',517.00,568.00,0.00,347.79,179807.43,196424.72,16617.29,14),('1','219','15','1',517.00,568.00,0.00,441.64,228327.88,246254.76,17926.88,15),('1','219','16','1',517.00,568.00,0.00,856.36,442738.12,467932.48,25194.36,16),('1','219','17','1',517.00,568.00,0.00,622.28,321718.76,337590.52,15871.76,17),('1','219','18','1',517.00,568.00,0.00,0.00,0.00,0.00,0.00,18),('1','219','19','1',527.00,568.00,0.00,2923.46,1540663.42,1589573.28,48909.86,19),('1','219','20','1',527.00,640.00,0.00,630.74,332399.98,395220.60,62820.62,20),('1','219','21','1',527.00,640.00,0.00,1180.74,622249.98,736883.60,114633.62,21),('1','219','22','1',527.00,640.00,0.00,494.33,260511.91,311091.20,50579.29,22),('1','219','23','1',527.00,680.00,0.00,165.62,87281.74,112621.60,25339.86,23),('1','219','24','1',527.00,680.00,0.00,239.29,126105.83,162057.60,35951.77,24),('1','219','25','1',527.00,680.00,0.00,151.70,79945.90,102796.00,22850.10,25),('1','219','26','1',612.00,680.00,0.00,88.17,53960.04,59955.60,5995.56,26),('1','219','27','1',612.00,680.00,0.00,288.01,176262.12,180510.40,4248.28,27),('1','219','28','1',612.00,640.00,0.00,346.16,211849.92,218254.40,6404.48,28),('1','219','29','1',612.00,640.00,0.00,303.64,185827.68,192829.60,7001.92,29),('1','219','30','1',612.00,640.00,0.00,347.42,212621.04,219977.12,7356.08,30),('1','219','31','1',612.00,640.00,0.00,260.28,159291.36,165871.20,6579.84,31),('1','219','32','1',612.00,640.00,0.00,258.33,158097.96,162691.20,4593.24,32),('1','219','33','1',612.00,640.00,0.00,363.03,222174.36,232099.20,9924.84,33),('1','219','34','1',612.00,640.00,0.00,234.19,143324.28,148557.04,5232.76,34),('1','219','35','1',612.00,640.00,0.00,243.75,149175.00,154656.00,5481.00,35),('1','219','36','1',612.00,680.00,0.00,546.98,334751.76,362397.00,27645.24,36),('1','219','37','1',612.00,680.00,0.00,344.24,210674.88,232183.20,21508.32,37),('1','219','38','1',612.00,680.00,0.00,346.16,211849.92,233241.80,21391.88,38),('1','219','39','1',612.00,680.00,0.00,407.96,249671.52,273232.80,23561.28,39),('1','219','40','1',620.00,640.00,0.00,823.75,510725.00,519830.00,9105.00,40),('1','219','41','1',620.00,640.00,0.00,565.78,350783.60,355517.60,4734.00,41),('1','219','42','1',612.00,640.00,0.00,1198.17,733280.04,749621.80,16341.76,42),('1','219','43','1',612.00,640.00,0.00,4552.78,2786301.36,2836119.40,49818.04,43),('1','219','44','1',612.00,640.00,0.00,1183.59,724357.08,739612.40,15255.32,44),('1','219','45','1',612.00,640.00,0.00,3539.07,2165910.84,2204514.20,38603.36,45),('1','219','46','1',612.00,640.00,0.00,1172.42,717521.04,731888.80,14367.76,46),('1','219','47','1',612.00,640.00,0.00,830.82,508461.84,520557.80,12095.96,47),('1','219','48','1',612.00,640.00,0.00,563.83,345063.96,355493.80,10429.84,48),('1','219','49','1',612.00,640.00,0.00,885.89,542164.68,555171.40,13006.72,49),('1','219','50','1',612.00,640.00,0.00,600.55,367536.60,377062.00,9525.40,50),('1','219','51','1',612.00,640.00,0.00,436.74,267284.88,276033.60,8748.72,51),('1','219','52','1',612.00,640.00,0.00,334.30,204591.60,212352.00,7760.40,52),('1','219','53','1',612.00,640.00,0.00,398.64,243967.68,253009.60,9041.92,53),('1','219','54','1',612.00,640.00,0.00,292.93,179273.16,186035.20,6762.04,54),('1','219','55','1',612.00,640.00,0.00,325.47,199187.64,205980.80,6793.16,55),('1','219','56','1',612.00,640.00,0.00,341.83,209199.96,216689.60,7489.64,56),('1','219','57','1',612.00,640.00,0.00,250.81,153495.72,159733.40,6237.68,57),('1','219','58','1',612.00,640.00,0.00,249.97,152981.64,158120.80,5139.16,58),('1','219','59','1',612.00,640.00,0.00,245.12,150013.44,156132.80,6119.36,59),('1','219','60','1',612.00,640.00,0.00,147.84,90478.08,93377.60,2899.52,60),('1','219','61','1',612.00,640.00,0.00,133.09,81451.08,85177.60,3726.52,61),('1','219','62','1',612.00,640.00,0.00,435.63,266605.56,274667.92,8062.36,62),('1','219','63','1',612.00,636.00,0.00,606.93,371441.16,379088.48,7647.32,63),('1','219','64','1',612.00,636.00,0.00,307.95,188465.40,194372.30,5906.90,64),('1','219','65','1',612.00,636.00,0.00,181.38,111004.56,115137.68,4133.12,65),('1','219','66','1',612.00,636.00,0.00,270.31,165429.72,169706.16,4276.44,66),('1','219','67','1',612.00,636.00,0.00,509.57,311856.84,319740.20,7883.36,67),('1','219','68','1',612.00,636.00,0.00,738.30,451839.60,447598.67,-4240.93,68),('1','219','69','1',612.00,636.00,0.00,272.48,166757.76,172043.28,5285.52,69),('1','219','70','1',612.00,636.00,0.00,396.34,242560.08,249111.26,6551.18,70),('1','219','71','1',612.00,636.00,0.00,250.60,153367.20,159183.60,5816.40,71),('1','219','72','1',612.00,636.00,0.00,124.99,76493.88,79218.64,2724.76,72),('1','219','73','1',602.00,636.00,0.00,148.78,89565.56,94349.08,4783.52,73),('1','219','74','1',602.00,636.00,0.00,281.45,169432.90,177627.20,8194.30,74),('1','219','75','1',602.00,636.00,0.00,654.24,393852.48,412202.42,18349.94,75),('1','219','76','1',602.00,636.00,0.00,876.60,527713.20,549333.60,21620.40,76),('1','219','77','1',602.00,636.00,0.00,624.15,375738.30,388447.82,12709.52,77),('1','219','78','1',602.00,636.00,0.00,458.63,276095.26,287816.68,11721.42,78),('1','219','79','1',602.00,636.00,0.00,384.93,231727.86,242483.48,10755.62,79),('1','219','80','1',602.00,636.00,0.00,868.96,523113.92,543385.56,20271.64,80),('1','219','81','1',602.00,636.00,0.00,576.25,346902.50,363819.36,16916.86,81),('1','219','82','1',602.00,636.00,0.00,729.21,438984.42,455879.56,16895.14,82),('1','219','83','1',602.00,636.00,0.00,145.80,87771.60,92485.26,4713.66,83),('1','219','84','1',602.00,636.00,0.00,427.16,257150.32,264709.00,7558.68,84),('1','219','85','1',602.00,636.00,0.00,672.16,404640.32,421224.64,16584.32,85),('1','219','86','1',602.00,636.00,0.00,613.67,369429.34,385542.12,16112.78,86),('1','219','87','1',602.00,636.00,0.00,786.17,473274.34,492073.12,18798.78,87),('1','219','88','1',602.00,636.00,0.00,365.18,219838.36,231044.48,11206.12,88),('1','219','89','1',602.00,636.00,0.00,308.87,185939.74,196034.32,10094.58,89),('1','219','90','1',602.00,636.00,0.00,464.21,279454.42,293136.56,13682.14,90),('1','219','91','1',602.00,696.00,0.00,389.37,234400.74,269945.52,35544.78,91),('1','219','92','1',602.00,696.00,0.00,679.74,409203.48,459195.04,49991.56,92),('1','219','93','1',602.00,696.00,0.00,419.97,252821.94,290227.16,37405.22,93),('1','219','94','1',602.00,696.00,0.00,391.70,235803.40,272004.12,36200.72,94),('1','219','95','1',602.00,696.00,0.00,343.52,206799.04,238957.92,32158.88,95),('1','219','96','1',602.00,696.00,0.00,14.94,8993.88,10398.24,1404.36,96),('1','219','97','1',602.00,696.00,0.00,302.87,188383.14,207827.52,19444.38,97),('1','219','98','1',622.00,696.00,0.00,91.57,56956.54,63182.72,6226.18,98),('1','219','99','1',622.00,680.00,0.00,256.89,159785.58,174445.20,14659.62,99),('1','219','100','1',622.00,680.00,0.00,614.13,381988.86,405028.40,23039.54,100),('1','219','101','1',622.00,680.00,0.00,592.76,368696.72,390676.80,21980.08,101),('1','219','102','1',622.00,680.00,0.00,315.86,196464.92,211742.80,15277.88,102),('1','219','103','1',622.00,680.00,0.00,280.63,174551.86,207275.92,32724.06,103),('1','219','104','1',622.00,740.00,0.00,306.24,190481.28,223185.60,32704.32,104),('1','219','105','1',622.00,740.00,0.00,418.55,260338.10,304444.36,44106.26,105),('1','219','106','1',622.00,740.00,0.00,377.41,234749.02,276995.40,42246.38,106),('1','219','107','1',622.00,700.00,0.00,522.81,325187.82,365495.00,40307.18,107),('1','219','108','1',622.00,700.00,0.00,367.16,228373.52,257012.00,28638.48,108),('1','219','109','1',622.00,700.00,0.00,355.68,221232.96,241862.40,20629.44,109),('1','219','110','1',622.00,680.00,0.00,424.69,264157.18,288627.20,24470.02,110),('1','219','111','1',622.00,680.00,0.00,404.05,251319.10,273521.00,22201.90,111),('1','219','112','1',622.00,680.00,0.00,267.80,166571.60,181456.00,14884.40,112),('1','219','113','1',622.00,680.00,0.00,171.19,106480.18,115711.34,9231.16,113),('1','219','114','1',622.00,680.00,0.00,540.68,336302.96,365669.62,29366.66,114),('1','219','115','1',622.00,680.00,0.00,356.38,221668.36,241826.66,20158.30,115),('1','219','116','1',622.00,680.00,0.00,440.87,274221.14,298612.24,24391.10,116),('1','219','117','1',622.00,680.00,0.00,417.55,259716.10,283844.00,24127.90,117),('1','219','118','1',622.00,680.00,0.00,534.66,332558.52,361286.94,28728.42,118),('1','219','119','1',622.00,680.00,0.00,292.22,181760.84,198214.60,16453.76,119),('1','219','120','1',622.00,750.00,0.00,570.01,354546.22,417807.50,63261.28,120),('1','219','121','1',622.00,750.00,0.00,337.08,209663.76,250399.20,40735.44,121),('1','219','122','1',622.00,750.00,0.00,353.95,220156.90,265262.50,45105.60,122),('1','219','123','1',622.00,750.00,0.00,259.81,161601.82,192417.50,30815.68,123),('1','219','124','1',622.00,750.00,0.00,391.34,243413.48,214202.90,-29210.58,124),('1','219','125','1',622.00,750.00,0.00,530.52,329983.44,387850.00,57866.56,125),('1','219','126','1',622.00,750.00,0.00,532.83,331420.26,397242.50,65822.24,126),('1','219','127','1',622.00,750.00,0.00,210.04,133453.98,156170.00,22716.02,127),('1','219','128','1',692.00,750.00,0.00,153.70,106360.40,114741.40,8381.00,128),('1','219','129','1',692.00,750.00,0.00,757.43,524141.56,556504.10,32362.54,129),('1','219','130','1',692.00,750.00,0.00,417.93,289207.56,310147.50,20939.94,130),('1','219','131','1',692.00,750.00,0.00,322.32,223045.44,240043.60,16998.16,131),('1','219','132','1',692.00,750.00,0.00,285.10,197289.20,211845.00,14555.80,132),('1','219','133','1',692.00,750.00,0.00,389.25,269361.00,291937.50,22576.50,133),('1','219','134','1',692.00,750.00,0.00,380.71,263451.32,283272.50,19821.18,134),('1','219','135','1',692.00,750.00,0.00,400.81,277360.52,298525.90,21165.38,135),('1','219','136','1',692.00,750.00,0.00,355.41,245943.72,263873.50,17929.78,136),('1','219','137','1',692.00,750.00,0.00,399.34,276343.28,298377.80,22034.52,137),('1','219','138','1',692.00,750.00,0.00,517.81,358324.52,381988.30,23663.78,138),('1','219','139','1',692.00,750.00,0.00,495.61,342962.12,367518.30,24556.18,139),('1','219','140','1',692.00,750.00,0.00,496.82,343799.44,367555.00,23755.56,140),('1','219','141','1',692.00,750.00,0.00,292.18,202188.56,218501.40,16312.84,141),('1','219','142','1',692.00,750.00,0.00,234.57,162322.44,173250.30,10927.86,142),('1','219','143','1',692.00,750.00,0.00,299.63,207343.96,224602.50,17258.54,143),('1','219','144','1',692.00,750.00,0.00,549.11,379984.12,411192.50,31208.38,144),('1','219','145','1',692.00,750.00,0.00,297.79,206070.68,220982.50,14911.82,145),('1','219','146','1',692.00,750.00,0.00,346.35,239674.20,259762.50,20088.30,146),('1','219','147','1',692.00,750.00,0.00,365.03,252600.76,272405.70,19804.94,147),('1','219','148','1',692.00,750.00,0.00,577.05,399318.60,430047.90,30729.30,148),('1','219','149','1',692.00,750.00,0.00,678.75,469695.00,501942.50,32247.50,149),('1','219','150','1',692.00,750.00,0.00,949.72,657206.24,708120.80,50914.56,150),('1','219','151','1',692.00,750.00,0.00,238.63,165131.96,177492.50,12360.54,151),('1','219','152','1',692.00,750.00,0.00,448.76,310541.92,332130.00,21588.08,152),('1','219','153','1',692.00,750.00,0.00,363.46,251514.32,268195.00,16680.68,153),('1','219','154','1',692.00,750.00,0.00,313.30,216803.60,234855.00,18051.40,154),('1','219','155','1',692.00,750.00,0.00,394.00,272648.00,291020.00,18372.00,155),('1','219','156','1',692.00,750.00,0.00,37.30,25811.60,27975.00,2163.40,156),('1','219','157','1',692.00,750.00,0.00,345.40,239016.80,258070.00,19053.20,157),('1','219','158','1',692.00,750.00,0.00,680.07,470608.44,497712.50,27104.06,158),('1','219','159','1',692.00,750.00,0.00,1020.89,706455.88,749577.50,43121.62,159),('1','219','160','1',692.00,750.00,0.00,696.86,482227.12,506525.00,24297.88,160),('1','219','161','1',692.00,750.00,0.00,775.42,536590.64,572325.00,35734.36,161),('1','219','162','1',692.00,750.00,0.00,676.95,468449.40,499079.70,30630.30,162),('1','219','163','1',692.00,750.00,0.00,446.23,308791.16,331339.70,22548.54,163),('1','219','164','1',692.00,750.00,0.00,957.03,662264.76,694252.50,31987.74,164),('1','219','165','1',692.00,750.00,0.00,300.15,207703.80,224592.50,16888.70,165),('1','219','166','1',692.00,750.00,0.00,112.23,77663.16,83819.70,6156.54,166),('1','219','167','1',692.00,750.00,0.00,515.41,356663.72,381177.50,24513.78,167),('1','219','168','1',692.00,750.00,0.00,440.32,304701.44,328120.00,23418.56,168),('1','219','169','1',692.00,750.00,0.00,581.83,402626.36,423952.50,21326.14,169),('1','219','170','1',692.00,750.00,0.00,478.67,331239.64,357222.50,25982.86,170),('1','219','171','1',692.00,750.00,0.00,432.42,299234.64,317275.00,18040.36,171),('1','219','172','1',692.00,750.00,0.00,386.74,267624.08,285096.60,17472.52,172),('1','219','173','1',692.00,750.00,0.00,667.70,462048.40,493175.00,31126.60,173),('1','219','174','1',692.00,750.00,0.00,683.39,472905.88,499396.90,26491.02,174),('1','219','175','1',692.00,750.00,0.00,801.28,554485.76,585343.60,30857.84,175),('1','219','176','1',692.00,750.00,0.00,548.57,379610.44,400407.50,20797.06,176),('1','219','177','1',692.00,750.00,0.00,269.26,186327.92,194463.00,8135.08,177),('1','219','178','1',692.00,750.00,0.00,950.39,657669.88,695900.10,38230.22,178),('1','219','179','1',692.00,750.00,0.00,1667.25,1153737.00,1212035.50,58298.50,179),('1','219','180','1',692.00,750.00,0.00,1430.54,989933.68,1039327.00,49393.32,180),('1','219','181','1',692.00,750.00,0.00,1795.77,1242672.84,1294407.50,51734.66,181),('1','219','182','1',692.00,750.00,0.00,1506.44,1042456.48,1089258.00,46801.52,182),('1','219','183','1',692.00,750.00,0.00,1238.73,857201.16,898627.50,41426.34,183),('1','219','184','1',692.00,750.00,0.00,808.83,559710.36,593042.50,33332.14,184),('1','219','185','1',692.00,750.00,0.00,826.26,571771.92,597349.00,25577.08,185),('1','219','186','1',692.00,750.00,0.00,702.24,485950.08,516706.80,30756.72,186),('1','219','187','1',692.00,750.00,0.00,720.47,498565.24,524412.50,25847.26,187),('1','219','188','1',697.00,750.00,0.00,875.89,610495.33,641257.50,30762.17,188),('1','219','189','1',697.00,750.00,0.00,881.28,614252.16,640653.60,26401.44,189),('1','219','190','1',697.00,750.00,0.00,1057.06,736770.82,774375.00,37604.18,190),('1','219','191','1',697.00,750.00,0.00,846.18,589787.46,616343.00,26555.54,191),('1','219','192','1',697.00,750.00,0.00,529.15,368817.55,392991.30,24173.75,192),('1','219','193','1',697.00,750.00,0.00,532.42,371096.74,389168.20,18071.46,193),('1','219','194','1',697.00,750.00,0.00,607.46,423399.62,450915.00,27515.38,194),('1','219','195','1',697.00,750.00,0.00,564.95,393770.15,418132.50,24362.35,195),('1','219','196','1',697.00,750.00,0.00,524.33,365458.01,390407.50,24949.49,196),('1','219','197','1',697.00,750.00,0.00,527.59,367730.23,389872.50,22142.27,197),('1','219','198','1',697.00,750.00,0.00,449.24,313120.28,335224.80,22104.52,198),('1','219','199','1',697.00,750.00,0.00,432.78,301647.66,319681.80,18034.14,199),('1','219','200','1',697.00,750.00,0.00,546.87,381168.39,406392.50,25224.11,200),('1','219','201','1',697.00,750.00,0.00,865.76,603434.72,632088.00,28653.28,201),('1','219','202','1',697.00,750.00,0.00,860.82,599991.54,633094.20,33102.66,202),('1','219','203','1',697.00,750.00,0.00,814.69,567838.93,599197.50,31358.57,203),('1','219','204','1',697.00,750.00,0.00,555.09,386897.73,407359.90,20462.17,204),('1','219','205','1',697.00,697.00,0.00,0.00,0.00,0.00,0.00,205),('1','219','206','1',697.00,750.00,0.00,1239.11,863659.67,900692.50,37032.83,206),('1','219','207','1',697.00,750.00,0.00,1285.68,896118.96,935340.40,39221.44,207),('1','219','208','1',697.00,750.00,0.00,1368.22,953649.34,989744.60,36095.26,208),('1','219','209','1',697.00,750.00,0.00,1614.97,1125634.09,1166084.70,40450.61,209),('1','219','210','1',697.00,750.00,0.00,370.09,257952.73,270047.50,12094.77,210),('1','219','211','1',685.00,750.00,0.00,688.90,471896.50,503595.00,31698.50,211),('1','219','212','1',685.00,750.00,0.00,1143.42,783242.70,831451.00,48208.30,212),('1','219','213','1',685.00,750.00,0.00,1412.04,967247.40,1023330.00,56082.60,213),('1','219','214','1',685.00,750.00,0.00,1118.37,766083.45,814517.10,48433.65,214),('1','219','215','1',685.00,750.00,0.00,1428.63,978611.55,1030601.70,51990.15,215),('1','219','216','1',685.00,750.00,0.00,1659.84,1136990.40,1198706.80,61716.40,216),('1','219','217','1',685.00,750.00,0.00,1397.61,957362.85,1009301.50,51938.65,217),('1','219','218','1',685.00,750.00,0.00,1331.03,911755.55,966319.30,54563.75,218),('1','219','219','1',685.00,750.00,0.00,1476.13,1011149.05,1056860.30,45711.25,219),('1','219','220','1',685.00,750.00,0.00,1968.17,1348196.45,1416487.10,68290.65,220),('1','219','221','1',685.00,750.00,0.00,1068.70,732059.50,773925.00,41865.50,221),('1','219','222','1',685.00,750.00,0.00,828.44,567481.40,600375.20,32893.80,222),('1','219','223','1',685.00,750.00,0.00,1072.11,734395.35,773558.90,39163.55,223),('1','219','224','1',685.00,750.00,0.00,1382.62,947094.70,997849.00,50754.30,224),('1','219','225','1',685.00,750.00,0.00,1206.67,826568.95,873362.50,46793.55,225),('1','219','226','1',685.00,750.00,0.00,1017.65,697090.25,741279.10,44188.85,226),('1','219','227','1',685.00,750.00,0.00,1126.62,771734.70,821739.40,50004.70,227),('1','219','228','1',685.00,750.00,0.00,85.74,58731.90,61531.40,2799.50,228),('1','219','229','1',677.00,750.00,0.00,907.44,614336.88,665037.20,50700.32,229),('1','219','230','1',677.00,750.00,0.00,846.35,572978.95,606968.10,33989.15,230),('1','219','231','1',677.00,750.00,0.00,653.85,442656.45,481314.70,38658.25,231),('1','219','232','1',677.00,750.00,0.00,432.43,292755.11,315471.30,22716.19,232),('1','219','233','1',677.00,750.00,0.00,666.84,451450.68,491668.40,40217.72,233),('1','219','234','1',677.00,750.00,0.00,763.33,516774.41,556200.70,39426.29,234),('1','219','235','1',677.00,750.00,0.00,500.10,338567.70,367893.00,29325.30,235),('1','219','236','1',677.00,750.00,0.00,441.01,298563.77,322991.10,24427.33,236),('1','219','237','1',677.00,750.00,0.00,781.88,529332.76,571839.50,42506.74,237),('1','219','238','1',677.00,750.00,0.00,685.94,464381.38,504555.00,40173.62,238),('1','219','239','1',677.00,750.00,0.00,916.35,620368.95,663312.50,42943.55,239),('1','219','240','1',677.00,750.00,0.00,431.71,292267.67,314224.00,21956.33,240),('1','219','241','1',677.00,750.00,0.00,203.63,137857.51,152172.50,14314.99,241),('1','219','242','1',677.00,750.00,0.00,580.37,392910.49,422827.50,29917.01,242),('1','219','243','1',677.00,750.00,0.00,340.51,230525.27,248957.50,18432.23,243),('1','219','244','1',677.00,750.00,0.00,348.28,235785.56,253135.00,17349.44,244),('1','219','245','1',677.00,750.00,0.00,442.96,299883.92,326345.00,26461.08,245),('1','219','246','1',677.00,750.00,0.00,1128.39,763920.03,812466.00,48545.97,246),('1','219','247','1',677.00,750.00,0.00,415.02,280968.54,301504.00,20535.46,247),('1','219','248','1',677.00,750.00,0.00,169.29,114609.33,122033.50,7424.17,248),('1','219','249','1',677.00,750.00,0.00,622.80,421635.60,456258.00,34622.40,249),('1','219','250','1',677.00,750.00,0.00,705.71,477765.67,513091.00,35325.33,250),('1','219','251','1',677.00,750.00,0.00,1015.86,687737.22,728470.00,40732.78,251),('1','219','252','1',677.00,750.00,0.00,532.83,360725.91,390438.50,29712.59,252),('1','219','253','1',677.00,750.00,0.00,534.77,362039.29,390927.50,28888.21,253),('1','219','254','1',677.00,750.00,0.00,538.50,364564.50,392900.00,28335.50,254),('1','219','255','1',677.00,750.00,0.00,846.78,573270.06,607981.00,34710.94,255),('1','219','256','1',677.00,750.00,0.00,712.62,482443.74,514115.00,31671.26,256),('1','219','257','1',677.00,750.00,0.00,314.40,212848.80,228300.00,15451.20,257),('1','219','258','1',677.00,750.00,0.00,568.19,384664.63,408692.50,24027.87,258),('1','219','259','1',677.00,750.00,0.00,1176.82,796707.14,842098.50,45391.36,259),('1','219','260','1',677.00,750.00,0.00,1346.68,911702.36,967026.00,55323.64,260),('1','219','261','1',677.00,750.00,0.00,967.49,654990.73,703762.20,48771.47,261),('1','219','262','1',677.00,750.00,0.00,1137.39,770013.03,827480.40,57467.37,262),('1','219','263','1',677.00,750.00,0.00,404.56,273887.12,293940.00,20052.88,263),('1','219','264','1',677.00,677.00,0.00,0.00,0.00,0.00,0.00,264),('1','219','265','1',677.00,750.00,0.00,1047.75,709326.75,763708.50,54381.75,265),('1','219','266','1',677.00,750.00,0.00,1529.37,1035383.49,1115589.00,80205.51,266),('1','219','267','1',677.00,750.00,0.00,1465.22,991953.94,1062450.00,70496.06,267),('1','219','268','1',677.00,750.00,0.00,1758.78,1190694.06,1276006.20,85312.14,268),('1','219','269','1',677.00,780.00,0.00,76.47,51770.19,56963.00,5192.81,269),('1','219','270','1',685.00,780.00,0.00,0.00,0.00,0.00,0.00,270),('1','219','271','1',685.00,780.00,0.00,2903.32,1988774.20,2173936.80,185162.60,271),('1','219','272','1',685.00,780.00,0.00,781.55,535361.75,609609.00,74247.25,272),('1','219','273','1',685.00,780.00,0.00,512.91,351343.35,400069.80,48726.45,273),('1','219','274','1',685.00,780.00,0.00,577.03,395265.55,450083.40,54817.85,274),('1','219','275','1',685.00,780.00,0.00,1022.05,700104.25,797199.00,97094.75,275),('1','219','276','1',685.00,780.00,0.00,1131.41,775015.85,882499.80,107483.95,276),('1','219','277','1',685.00,780.00,0.00,925.11,633700.35,721585.80,87885.45,277),('1','219','278','1',685.00,780.00,0.00,250.26,171428.10,195202.80,23774.70,278),('1','219','279','1',685.00,685.00,0.00,0.00,0.00,0.00,0.00,279),('1','219','280','1',685.00,780.00,0.00,710.44,486651.40,554143.20,67491.80,280),('1','219','281','1',685.00,780.00,0.00,663.23,454312.55,517319.40,63006.85,281),('1','219','282','1',685.00,780.00,0.00,790.83,541718.55,616847.40,75128.85,282),('1','219','283','1',685.00,780.00,0.00,692.43,474314.55,540095.40,65780.85,283),('1','219','284','1',685.00,780.00,0.00,913.39,625672.15,712444.20,86772.05,284),('1','219','285','1',685.00,780.00,0.00,778.65,533375.25,607347.00,73971.75,285),('1','219','286','1',685.00,780.00,0.00,643.29,440653.65,501766.20,61112.55,286),('1','219','287','1',685.00,780.00,0.00,513.53,351768.05,391966.20,40198.15,287),('1','219','288','1',697.00,780.00,0.00,786.54,548218.38,599124.80,50906.42,288),('1','219','289','1',697.00,780.00,0.00,925.86,645324.42,699826.00,54501.58,289),('1','219','290','1',697.00,780.00,0.00,1000.74,697515.78,759442.00,61926.22,290),('1','219','291','1',697.00,780.00,0.00,709.95,494835.15,538995.40,44160.25,291),('1','219','292','1',697.00,780.00,0.00,905.81,631349.57,693666.60,62317.03,292),('1','219','293','1',697.00,780.00,0.00,1075.63,749714.11,811807.80,62093.69,293),('1','219','294','1',697.00,780.00,0.00,321.01,223743.97,243647.40,19903.43,294),('1','219','295','1',697.00,685.00,0.00,0.00,0.00,0.00,0.00,295),('1','219','296','1',685.00,780.00,0.00,395.75,271088.75,298345.00,27256.25,296),('1','219','297','1',685.00,780.00,0.00,1057.20,724182.00,801462.40,77280.40,297),('1','219','298','1',685.00,780.00,0.00,913.21,625548.85,694081.80,68532.95,298),('1','219','299','1',685.00,780.00,0.00,1078.99,739108.15,821290.20,82182.05,299),('1','219','300','1',685.00,780.00,0.00,539.22,369365.70,391379.40,22013.70,300),('1','219','301','1',685.00,736.00,0.00,937.01,641851.85,674419.74,32567.89,301),('1','219','302','1',685.00,736.00,0.00,762.52,522326.20,549129.14,26802.94,302),('1','219','303','1',685.00,736.00,0.00,175.83,120443.55,127856.34,7412.79,303),('1','219','304','1',685.00,736.00,0.00,616.17,422076.45,442031.48,19955.03,304),('1','219','305','1',685.00,736.00,0.00,1426.50,977152.50,1030064.70,52912.20,305),('1','219','306','1',685.00,736.00,0.00,1132.00,775420.00,816143.58,40723.58,306),('1','219','307','1',685.00,736.00,0.00,1086.09,743971.65,782809.86,38838.21,307),('1','219','308','1',685.00,736.00,0.00,1153.97,790469.45,829798.52,39329.07,308),('1','219','309','1',685.00,736.00,0.00,989.60,677876.00,713209.96,35333.96,309),('1','219','310','1',685.00,685.00,0.00,0.00,0.00,0.00,0.00,310),('1','219','311','1',685.00,736.00,0.00,0.00,0.00,0.00,0.00,311),('1','219','312','1',685.00,736.00,0.00,795.12,544657.20,574814.56,30157.36,312),('1','219','313','1',685.00,736.00,0.00,1152.98,789791.30,831202.92,41411.62,313),('1','219','314','1',685.00,736.00,0.00,1047.01,717201.85,753316.64,36114.79,314),('1','219','315','1',685.00,736.00,0.00,1312.15,898822.75,943103.68,44280.93,315),('1','219','316','1',685.00,736.00,0.00,896.17,613876.45,646847.10,32970.65,316),('1','219','317','1',685.00,736.00,0.00,547.18,374818.30,394137.98,19319.68,317),('1','219','318','1',685.00,685.00,0.00,0.00,0.00,0.00,0.00,318),('1','219','319','1',676.00,736.00,0.00,315.37,213190.12,227675.68,14485.56,319),('1','219','320','1',676.00,736.00,0.00,1639.61,1108376.36,1175609.12,67232.76,320),('1','219','321','1',676.00,736.00,0.00,1227.11,829526.36,879839.28,50312.92,321),('1','219','322','1',676.00,736.00,0.00,1011.30,683638.80,728301.06,44662.26,322),('1','219','323','1',676.00,736.00,0.00,1342.66,907638.16,964658.66,57020.50,323),('1','219','324','1',676.00,736.00,0.00,200.38,135456.88,143271.32,7814.44,324),('1','219','325','1',676.00,676.00,0.00,0.00,0.00,0.00,0.00,325),('1','219','326','1',676.00,736.00,0.00,432.81,292579.56,311238.26,18658.70,326),('1','219','327','1',676.00,736.00,0.00,1328.93,898356.68,954201.34,55844.66,327),('1','219','328','1',676.00,736.00,0.00,1132.30,765434.80,813702.24,48267.44,328),('1','219','329','1',676.00,736.00,0.00,1227.15,829553.40,880747.00,51193.60,329),('1','219','330','1',676.00,736.00,0.00,1399.89,946325.64,1003846.10,57520.46,330),('1','219','331','1',676.00,736.00,0.00,163.79,110722.04,117045.16,6323.12,331),('1','219','332','1',676.00,676.00,0.00,0.00,0.00,0.00,0.00,332),('1','219','333','1',676.00,736.00,0.00,758.10,512475.60,543613.50,31137.90,333),('1','219','334','1',676.00,736.00,0.00,1481.65,1001595.40,1064136.64,62541.24,334),('1','219','335','1',676.00,736.00,0.00,1461.41,987913.16,1050536.88,62623.72,335),('1','219','336','1',676.00,736.00,0.00,1386.83,937497.08,997207.82,59710.74,336),('1','219','337','1',676.00,736.00,0.00,746.01,504302.76,535298.96,30996.20,337),('1','219','338','1',676.00,736.00,0.00,758.75,512915.00,547860.86,34945.86,338),('1','219','339','1',676.00,736.00,0.00,2114.38,1429320.88,1517359.18,88038.30,339),('1','219','340','1',676.00,736.00,0.00,1126.87,761764.12,811047.88,49283.76,340),('1','219','341','1',676.00,736.00,0.00,1129.83,763765.08,815875.84,52110.76,341),('1','219','342','1',676.00,736.00,0.00,760.58,514152.08,547472.76,33320.68,342),('1','219','343','1',676.00,736.00,0.00,1624.44,1098121.44,1168309.42,70187.98,343),('1','219','344','1',676.00,736.00,0.00,1278.59,864326.84,919807.78,55480.94,344),('1','219','345','1',676.00,736.00,0.00,1561.42,1055519.92,1120819.10,65299.18,345),('1','219','346','1',676.00,736.00,0.00,973.33,657971.08,705849.20,47878.12,346),('1','219','347','1',676.00,736.00,0.00,462.56,312690.56,338654.06,25963.50,347),('1','219','348','1',676.00,736.00,0.00,296.89,200697.64,214859.86,14162.22,348),('1','219','349','1',676.00,736.00,0.00,1051.14,710570.64,757780.60,47209.96,349),('1','219','350','1',676.00,736.00,0.00,1059.93,716512.68,764482.22,47969.54,350),('1','219','351','1',676.00,736.00,0.00,901.87,609664.12,650822.34,41158.22,351),('1','219','352','1',676.00,736.00,0.00,1403.79,948962.04,1008608.00,59645.96,352),('1','219','353','1',676.00,736.00,0.00,1064.48,719588.48,768231.68,48643.20,353),('1','219','354','1',676.00,736.00,0.00,1099.58,743316.08,792968.60,49652.52,354),('1','219','355','1',676.00,736.00,0.00,820.56,554698.56,593691.80,38993.24,355),('1','219','356','1',676.00,736.00,0.00,1090.90,737448.40,785443.66,47995.26,356),('1','219','357','1',676.00,736.00,0.00,1693.78,1144995.28,1215238.52,70243.24,357),('1','219','358','1',676.00,736.00,0.00,1216.61,822428.36,870122.28,47693.92,358),('1','219','359','1',676.00,736.00,0.00,1744.30,1179146.80,1259514.30,80367.50,359),('1','219','360','1',676.00,736.00,0.00,994.40,672214.40,715890.48,43676.08,360),('1','219','361','1',676.00,736.00,0.00,1841.59,1244914.84,1326767.08,81852.24,361),('1','219','362','1',676.00,736.00,0.00,1126.10,761243.60,809971.56,48727.96,362),('1','219','363','1',676.00,736.00,0.00,125.70,84973.20,89915.20,4942.00,363),('1','219','364','1',676.00,736.00,0.00,1779.86,1203185.36,1280759.20,77573.84,364),('1','219','365','1',676.00,736.00,0.00,1764.17,1192578.92,1268688.76,76109.84,365),('1','219','366','1',676.00,736.00,0.00,1178.31,796537.56,852103.38,55565.82,366),('1','219','367','1',676.00,736.00,0.00,1068.85,721851.35,769787.64,47936.29,367),('1','219','368','1',651.00,736.00,0.00,1325.06,862614.06,956347.36,93733.30,368),('1','219','369','1',651.00,736.00,0.00,1028.15,669325.65,740989.96,71664.31,369),('1','219','370','1',651.00,736.00,0.00,236.53,153981.03,172786.08,18805.05,370),('1','219','371','1',651.00,736.00,0.00,819.88,533741.88,593135.68,59393.80,371),('1','219','372','1',651.00,736.00,0.00,951.41,619367.91,682873.66,63505.75,372),('1','219','373','1',651.00,736.00,0.00,762.88,496634.88,560361.68,63726.80,373),('1','219','374','1',651.00,736.00,0.00,730.64,475646.64,530736.24,55089.60,374),('1','219','375','1',651.00,736.00,0.00,793.59,516627.09,573981.24,57354.15,375),('1','219','376','1',651.00,736.00,0.00,362.71,236124.21,264355.08,28230.87,376),('1','219','377','1',651.00,736.00,0.00,911.75,593549.25,659230.74,65681.49,377),('1','219','378','1',651.00,736.00,0.00,438.41,285404.91,316704.32,31299.41,378),('1','219','379','1',651.00,736.00,0.00,294.01,191400.51,214118.44,22717.93,379),('1','219','380','1',651.00,736.00,0.00,973.58,633800.58,705426.36,71625.78,380),('1','219','381','1',651.00,736.00,0.00,807.89,525936.39,585754.82,59818.43,381),('1','219','382','1',651.00,736.00,0.00,5.43,3534.93,3996.48,461.55,382),('1','219','383','1',651.00,736.00,0.00,404.46,263303.46,294835.56,31532.10,383),('1','219','384','1',651.00,736.00,0.00,496.63,323306.13,361643.86,38337.73,384),('1','219','385','1',651.00,736.00,0.00,352.43,229431.93,259232.48,29800.55,385),('1','219','386','1',651.00,736.00,0.00,424.54,276375.54,310135.48,33759.94,386),('1','219','387','1',651.00,736.00,0.00,170.09,110728.59,124458.24,13729.65,387),('1','219','388','1',651.00,736.00,0.00,300.08,195352.08,220024.28,24672.20,388),('1','219','389','1',651.00,736.00,0.00,779.33,507343.83,568620.62,61276.79,389),('1','219','390','1',651.00,736.00,0.00,755.19,491628.69,544996.30,53367.61,390),('1','219','391','1',651.00,651.00,0.00,0.00,0.00,0.00,0.00,391),('1','219','392','1',651.00,736.00,0.00,768.86,500527.86,559087.68,58559.82,392),('1','219','393','1',651.00,736.00,0.00,864.19,562587.69,623765.34,61177.65,393),('1','219','394','1',651.00,736.00,0.00,37.48,24399.48,27585.28,3185.80,394),('1','219','395','1',651.00,651.00,0.00,0.00,0.00,0.00,0.00,395),('1','219','396','1',661.00,736.00,0.00,545.14,360337.54,397237.24,36899.70,396),('1','219','397','1',661.00,736.00,0.00,1317.43,870821.23,945582.64,74761.41,397),('1','219','398','1',661.00,736.00,0.00,435.78,288050.58,316209.30,28158.72,398),('1','219','399','1',661.00,736.00,0.00,726.44,480176.84,529431.76,49254.92,399),('1','219','400','1',661.00,736.00,0.00,800.61,529203.21,584495.12,55291.91,400),('1','219','401','1',661.00,736.00,0.00,975.09,644534.49,705376.04,60841.55,401),('1','219','402','1',661.00,736.00,0.00,674.40,445778.40,493901.40,48123.00,402),('1','219','403','1',661.00,736.00,0.00,370.06,244609.66,267543.50,22933.84,403),('1','219','404','1',661.00,736.00,0.00,793.26,524344.86,576065.36,51720.50,404),('1','219','405','1',661.00,736.00,0.00,983.44,650053.84,715517.58,65463.74,405),('1','219','406','1',661.00,736.00,0.00,328.55,217171.55,237021.26,19849.71,406),('1','219','407','1',651.00,736.00,0.00,80.30,52275.30,57390.26,5114.96,407),('1','219','408','1',651.00,736.00,0.00,797.28,519029.28,576169.02,57139.74,408),('1','219','409','1',651.00,736.00,0.00,760.50,495085.50,553325.50,58240.00,409),('1','219','410','1',651.00,736.00,0.00,925.80,602695.80,663162.02,60466.22,410),('1','219','411','1',651.00,736.00,0.00,653.60,425493.60,472449.84,46956.24,411),('1','219','412','1',651.00,736.00,0.00,475.87,309791.37,345201.52,35410.15,412),('1','219','413','1',651.00,736.00,0.00,532.36,346566.36,384232.76,37666.40,413),('1','219','414','1',651.00,736.00,0.00,648.77,422349.27,470396.72,48047.45,414),('1','219','415','1',651.00,736.00,0.00,526.48,342738.48,381133.58,38395.10,415),('1','219','416','1',651.00,736.00,0.00,192.13,125076.63,139368.76,14292.13,416),('1','219','417','1',651.00,651.00,0.00,0.00,0.00,0.00,0.00,417),('1','219','418','1',651.00,736.00,0.00,150.79,98164.29,109211.36,11047.07,418),('1','219','419','1',651.00,726.00,0.00,536.79,349450.29,381387.72,31937.43,419),('1','219','420','1',651.00,726.00,0.00,547.40,356357.40,391526.26,35168.86,420),('1','219','421','1',651.00,726.00,0.00,502.31,327003.81,359760.72,32756.91,421),('1','219','422','1',651.00,726.00,0.00,789.57,514010.07,560469.88,46459.81,422),('1','219','423','1',651.00,726.00,0.00,823.48,536085.48,593370.84,57285.36,423),('1','219','424','1',651.00,726.00,0.00,493.04,320969.04,351449.12,30480.08,424),('1','219','425','1',651.00,726.00,0.00,571.32,371929.32,410525.50,38596.18,425),('1','219','426','1',651.00,726.00,0.00,892.81,581219.31,634237.82,53018.51,426),('1','219','427','1',651.00,726.00,0.00,35.30,22980.30,25627.80,2647.50,427),('1','219','428','1',651.00,651.00,0.00,0.00,0.00,0.00,0.00,428),('1','219','429','1',646.00,726.00,0.00,578.07,373433.22,417982.32,44549.10,429),('1','219','430','1',646.00,726.00,0.00,1676.19,1082818.74,1191430.56,108611.82,430),('1','219','431','1',646.00,726.00,0.00,1139.09,735852.14,803946.72,68094.58,431);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'219','PRODUCT TANK ','Tank Containing LPG Product');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','219','1',1,1,'1','LPG TANK',7000.00,0.00,NULL,'','487','2022-02-23 11:24:57','2022-02-23 11:25:31','487',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','219',1,2372.65,'2023-03-19 17:24:51');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=35241 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,3049783.00,5899.00,0.00,0.00,'2022-02-25 17:14:17','',''),(2,'1','219',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,5899.00,0.00,'2022-02-25 17:19:25','',''),(3,'1','219','1',1,'Received from bridging 1',0.00,0.00,5899.00,0.00,0.00,'2022-02-25 17:19:25','',''),(4,'1','219','1',1,'Retail Sale Id 1',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 08:09:23','',''),(5,'1','219','1',1,'Return of Retail Sale Id 1',0.00,7100.00,12.50,0.00,-637.50,'2022-02-26 08:46:10','',''),(6,'1','219','1',1,'Retail Sale Id 2',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 11:01:42','',''),(7,'1','219','1',1,'Retail Sale Id 3',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 11:34:26','',''),(8,'1','219','1',1,'Retail Sale Id 4',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 11:57:46','',''),(9,'1','219','1',1,'Retail Sale Id 6',499.84,0.00,0.00,0.88,44.88,'2022-02-26 11:59:13','',''),(10,'1','219','1',1,'Retail Sale Id 10',2209.52,0.00,0.00,3.89,198.39,'2022-02-26 12:09:01','',''),(11,'1','219','1',1,'Retail Sale Id 11',1999.36,0.00,0.00,3.52,179.52,'2022-02-26 12:20:02','',''),(12,'1','219','1',1,'Retail Sale Id 16',1999.36,0.00,0.00,3.52,179.52,'2022-02-26 12:26:58','',''),(13,'1','219','1',1,'Retail Sale Id 17',3697.68,0.00,0.00,6.51,332.01,'2022-02-26 12:43:35','',''),(14,'1','219','1',1,'Retail Sale Id 18',1147.36,0.00,0.00,2.02,103.02,'2022-02-26 12:49:21','',''),(15,'1','219','1',1,'Retail Sale Id 19',3402.32,0.00,0.00,5.99,305.49,'2022-02-26 12:53:19','',''),(16,'1','219','1',1,'Retail Sale Id 20',94500.00,0.00,0.00,175.00,4025.00,'2022-02-26 13:08:48','',''),(17,'1','219','1',1,'Retail Sale Id 23',499.84,0.00,0.00,0.88,44.88,'2022-02-26 13:56:56','',''),(18,'1','219','1',1,'Retail Sale Id 25',1698.32,0.00,0.00,2.99,152.49,'2022-02-26 14:09:21','',''),(19,'1','219','1',1,'Retail Sale Id 26',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 14:35:06','',''),(20,'1','219','1',1,'Retail Sale Id 26',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 14:35:06','',''),(21,'1','219','1',1,'Retail Sale Id 27',2840.00,0.00,0.00,5.00,255.00,'2022-02-26 14:36:03','',''),(22,'1','219','1',1,'Retail Sale Id 28',1698.32,0.00,0.00,2.99,152.49,'2022-02-26 14:37:21','',''),(23,'1','219','1',1,'Retail Sale Id 29',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 14:38:39','',''),(24,'1','219','1',1,'Retail Sale Id 30',3419.36,0.00,0.00,6.02,307.02,'2022-02-26 14:40:29','',''),(25,'1','219','1',1,'Retail Sale Id 31',5680.00,0.00,0.00,10.00,510.00,'2022-02-26 15:57:02','',''),(26,'1','219','1',1,'Retail Sale Id 31',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 15:57:02','',''),(27,'1','219','1',1,'Retail Sale Id 33',1698.32,0.00,0.00,2.99,152.49,'2022-02-26 16:38:15','',''),(28,'1','219','1',1,'Retail Sale Id 34',2999.04,0.00,0.00,5.28,269.28,'2022-02-26 16:39:59','',''),(29,'1','219','1',1,'Retail Sale Id 35',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 16:46:34','',''),(30,'1','219','1',1,'Retail Sale Id 36',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 16:54:14','',''),(31,'1','219','1',1,'Retail Sale Id 36',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 16:54:14','',''),(32,'1','219','1',1,'Retail Sale Id 37',2999.04,0.00,0.00,5.28,269.28,'2022-02-26 17:12:30','',''),(33,'1','219','1',1,'Retail Sale Id 39',1101.92,0.00,0.00,1.94,98.94,'2022-02-26 17:22:03','',''),(34,'1','219','1',1,'Return of Retail Sale Id 29',0.00,7100.00,12.50,0.00,-637.50,'2022-02-26 17:55:17','',''),(35,'1','219','1',1,'Return of Retail Sale Id 34',0.00,2999.04,5.28,0.00,-269.28,'2022-02-26 18:00:21','',''),(36,'1','219','1',1,'Return of Retail Sale Id 4',0.00,3408.00,6.00,0.00,-306.00,'2022-02-26 18:01:57','',''),(37,'1','219','1',1,'Retail Sale Id 40',13507.04,0.00,0.00,23.78,1212.78,'2022-02-26 18:03:51','',''),(38,'1','219','1',1,'Retail Sale Id 41',999.68,0.00,0.00,1.76,89.76,'2022-02-26 18:08:39','',''),(39,'1','219','1',1,'Retail Sale Id 42',1709.68,0.00,0.00,3.01,153.51,'2022-02-26 18:17:51','',''),(40,'1','219','1',1,'Retail Sale Id 43',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 18:26:04','',''),(41,'1','219','1',1,'Retail Sale Id 44',1709.68,0.00,0.00,3.01,153.51,'2022-02-26 18:32:51','',''),(42,'1','219','1',1,'Retail Sale Id 45',999.68,0.00,0.00,1.76,89.76,'2022-02-26 19:05:45','',''),(43,'1','219','1',1,'Retail Sale Id 48',1999.36,0.00,0.00,3.52,179.52,'2022-02-26 19:18:53','',''),(44,'1','219','1',1,'Retail Sale Id 49',9099.36,0.00,0.00,16.02,817.02,'2022-02-26 20:04:34','',''),(45,'1','219','1',1,'Return of Retail Sale Id 40',0.00,13507.04,23.78,0.00,-1212.78,'2022-02-26 21:39:20','',''),(46,'1','219','1',1,'Retail Sale Id 50',13507.04,0.00,0.00,23.78,1212.78,'2022-02-26 21:41:38','',''),(47,'1','219','1',1,'Return of Retail Sale Id 2',0.00,3408.00,6.00,0.00,-306.00,'2022-02-26 21:52:37','',''),(48,'1','219','1',1,'Retail Sale Id 51',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 21:53:14','',''),(49,'1','219','1',1,'Return of Retail Sale Id 36',0.00,7100.00,12.50,0.00,-637.50,'2022-02-26 22:19:22','',''),(50,'1','219','1',1,'Return of Retail Sale Id 36',0.00,7100.00,12.50,0.00,-637.50,'2022-02-26 22:19:22','',''),(51,'1','219','1',1,'Retail Sale Id 52',10099.04,0.00,0.00,17.78,906.78,'2022-02-26 22:20:49','',''),(52,'1','219','1',1,'Retail Sale Id 53',4100.96,0.00,0.00,7.22,368.22,'2022-02-26 22:21:44','',''),(53,'1','219','1',1,'Retail Sale Id 54',568.00,0.00,0.00,1.00,51.00,'2022-02-27 08:42:47','',''),(54,'1','219','1',1,'Retail Sale Id 55',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 08:45:15','',''),(55,'1','219','1',1,'Retail Sale Id 56',1800.56,0.00,0.00,3.17,161.67,'2022-02-27 08:46:37','',''),(56,'1','219','1',1,'Retail Sale Id 57',3498.88,0.00,0.00,6.16,314.16,'2022-02-27 08:56:02','',''),(57,'1','219','1',1,'Retail Sale Id 58',1709.68,0.00,0.00,3.01,153.51,'2022-02-27 09:59:47','',''),(58,'1','219','1',1,'Retail Sale Id 59',3498.88,0.00,0.00,6.16,314.16,'2022-02-27 10:05:48','',''),(59,'1','219','1',1,'Retail Sale Id 60',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 10:08:58','',''),(60,'1','219','1',1,'Retail Sale Id 61',54000.00,0.00,0.00,100.00,2300.00,'2022-02-27 10:26:52','',''),(61,'1','219','1',1,'Retail Sale Id 62',1709.68,0.00,0.00,3.01,153.51,'2022-02-27 10:41:55','',''),(62,'1','219','1',1,'Retail Sale Id 65',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 10:44:04','',''),(63,'1','219','1',1,'Retail Sale Id 66',2840.00,0.00,0.00,5.00,255.00,'2022-02-27 11:25:29','',''),(64,'1','219','1',1,'Retail Sale Id 68',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 11:43:36','',''),(65,'1','219','1',1,'Retail Sale Id 72',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 12:42:37','',''),(66,'1','219','1',1,'Retail Sale Id 73',698.64,0.00,0.00,1.23,62.73,'2022-02-27 12:43:49','',''),(67,'1','219','1',1,'Retail Sale Id 74',2840.00,0.00,0.00,5.00,255.00,'2022-02-27 12:44:35','',''),(68,'1','219','1',1,'Retail Sale Id 79',1198.48,0.00,0.00,2.11,107.61,'2022-02-27 12:49:59','',''),(69,'1','219','1',1,'Retail Sale Id 80',2840.00,0.00,0.00,5.00,255.00,'2022-02-27 13:58:14','',''),(70,'1','219','1',1,'Retail Sale Id 81',1147.36,0.00,0.00,2.02,103.02,'2022-02-27 14:00:36','',''),(71,'1','219','1',1,'Retail Sale Id 84',7100.00,0.00,0.00,12.50,637.50,'2022-02-27 14:30:12','',''),(72,'1','219','1',1,'Retail Sale Id 89',3498.88,0.00,0.00,6.16,314.16,'2022-02-27 15:11:47','',''),(73,'1','219','1',1,'Retail Sale Id 90',1709.68,0.00,0.00,3.01,153.51,'2022-02-27 15:19:36','',''),(74,'1','219','1',1,'Retail Sale Id 92',4549.68,0.00,0.00,8.01,408.51,'2022-02-27 16:12:31','',''),(75,'1','219','1',1,'Retail Sale Id 93',2840.00,0.00,0.00,5.00,255.00,'2022-02-27 16:19:25','',''),(76,'1','219','1',1,'Retail Sale Id 94',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 16:21:56','',''),(77,'1','219','1',1,'Retail Sale Id 95',1601.76,0.00,0.00,2.82,143.82,'2022-02-27 16:26:01','',''),(78,'1','219','1',1,'Retail Sale Id 97',1999.36,0.00,0.00,3.52,179.52,'2022-02-27 16:35:53','',''),(79,'1','219','1',1,'Retail Sale Id 98',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 16:51:12','',''),(80,'1','219','1',1,'Retail Sale Id 103',3419.36,0.00,0.00,6.02,307.02,'2022-02-27 16:53:22','',''),(81,'1','219','1',1,'Retail Sale Id 104',1198.48,0.00,0.00,2.11,107.61,'2022-02-27 16:54:42','',''),(82,'1','219','1',1,'Retail Sale Id 105',2999.04,0.00,0.00,5.28,269.28,'2022-02-27 16:56:40','',''),(83,'1','219','1',1,'Retail Sale Id 106',7100.00,0.00,0.00,12.50,637.50,'2022-02-27 17:01:31','',''),(84,'1','219','1',1,'Retail Sale Id 107',1709.68,0.00,0.00,3.01,153.51,'2022-02-27 17:12:19','',''),(85,'1','219','1',1,'Retail Sale Id 108',2840.00,0.00,0.00,5.00,255.00,'2022-02-27 17:13:37','',''),(86,'1','219','1',1,'Retail Sale Id 109',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 18:02:41','',''),(87,'1','219','1',1,'Retail Sale Id 113',499.84,0.00,0.00,0.88,44.88,'2022-02-27 18:16:24','',''),(88,'1','219','1',1,'Retail Sale Id 119',499.84,0.00,0.00,0.88,44.88,'2022-02-27 18:21:37','',''),(89,'1','219','1',1,'Retail Sale Id 121',7100.00,0.00,0.00,12.50,637.50,'2022-02-27 18:23:17','',''),(90,'1','219','1',1,'Retail Sale Id 123',698.64,0.00,0.00,1.23,62.73,'2022-02-27 18:25:31','',''),(91,'1','219','1',1,'Retail Sale Id 125',1147.36,0.00,0.00,2.02,103.02,'2022-02-27 18:39:54','',''),(92,'1','219','1',1,'Retail Sale Id 126',568.00,0.00,0.00,1.00,51.00,'2022-02-27 19:32:24','',''),(93,'1','219','1',1,'Retail Sale Id 127',2272.00,0.00,0.00,4.00,204.00,'2022-02-27 19:37:05','',''),(94,'1','219','1',1,'Retail Sale Id 128',147.68,0.00,0.00,0.26,13.26,'2022-02-27 19:52:30','',''),(95,'1','219','1',1,'Retail Sale Id 129',57174.88,0.00,0.00,100.66,5133.66,'2022-02-27 21:19:43','',''),(96,'1','219','1',1,'Retail Sale Id 130',74958.96,0.00,0.00,131.97,6730.47,'2022-02-27 21:22:06','',''),(97,'1','219','1',1,'Retail Sale Id 131',46257.92,0.00,0.00,81.44,4153.44,'2022-02-27 21:29:27','',''),(98,'1','219','1',1,'Retail Sale Id 132',7969.04,0.00,0.00,14.03,715.53,'2022-02-27 21:32:37','',''),(99,'1','219','1',1,'Retail Sale Id 133',25929.20,0.00,0.00,45.65,2328.15,'2022-02-27 21:34:01','',''),(100,'1','219','1',1,'Retail Sale Id 134',30467.52,0.00,0.00,53.64,2735.64,'2022-02-27 21:38:37','',''),(101,'1','219','1',1,'Retail Sale Id 135',57606.56,0.00,0.00,101.42,5172.42,'2022-02-27 21:44:39','',''),(102,'1','219','1',1,'Retail Sale Id 137',2499.20,0.00,0.00,4.40,224.40,'2022-02-28 08:44:21','',''),(103,'1','219','1',1,'Retail Sale Id 138',1698.32,0.00,0.00,2.99,152.49,'2022-02-28 08:47:44','',''),(104,'1','219','1',1,'Retail Sale Id 138',2800.24,0.00,0.00,4.93,251.43,'2022-02-28 08:47:44','',''),(105,'1','219','1',1,'Retail Sale Id 139',3447.76,0.00,0.00,6.07,309.57,'2022-02-28 08:48:55','',''),(106,'1','219','1',1,'Retail Sale Id 140',3498.88,0.00,0.00,6.16,314.16,'2022-02-28 08:50:11','',''),(107,'1','219','1',1,'Retail Sale Id 141',1499.52,0.00,0.00,2.64,134.64,'2022-02-28 09:15:15','',''),(108,'1','219','1',1,'Retail Sale Id 142',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 09:49:50','',''),(109,'1','219','1',1,'Retail Sale Id 143',1709.68,0.00,0.00,3.01,153.51,'2022-02-28 09:52:08','',''),(110,'1','219','1',1,'Retail Sale Id 144',3498.88,0.00,0.00,6.16,314.16,'2022-02-28 09:56:06','',''),(111,'1','219','1',1,'Retail Sale Id 145',3447.76,0.00,0.00,6.07,309.57,'2022-02-28 10:01:33','',''),(112,'1','219','1',1,'Retail Sale Id 145',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 10:01:33','',''),(113,'1','219','1',1,'Retail Sale Id 146',5702.72,0.00,0.00,10.04,512.04,'2022-02-28 10:32:24','',''),(114,'1','219','1',1,'Retail Sale Id 147',1698.32,0.00,0.00,2.99,152.49,'2022-02-28 10:52:18','',''),(115,'1','219','1',1,'Retail Sale Id 148',1698.32,0.00,0.00,2.99,152.49,'2022-02-28 10:53:56','',''),(116,'1','219','1',1,'Retail Sale Id 149',1999.36,0.00,0.00,3.52,179.52,'2022-02-28 10:55:17','',''),(117,'1','219','1',1,'Retail Sale Id 150',2300.40,0.00,0.00,4.05,206.55,'2022-02-28 11:01:47','',''),(118,'1','219','1',1,'Retail Sale Id 151',1709.68,0.00,0.00,3.01,153.51,'2022-02-28 11:51:51','',''),(119,'1','219','1',1,'Retail Sale Id 152',1709.68,0.00,0.00,3.01,153.51,'2022-02-28 12:01:40','',''),(120,'1','219','1',1,'Retail Sale Id 152',1709.68,0.00,0.00,3.01,153.51,'2022-02-28 12:01:40','',''),(121,'1','219','1',1,'Retail Sale Id 153',1709.68,0.00,0.00,3.01,153.51,'2022-02-28 12:02:34','',''),(122,'1','219','1',1,'Retail Sale Id 154',1709.68,0.00,0.00,3.01,153.51,'2022-02-28 12:23:21','',''),(123,'1','219','1',1,'Retail Sale Id 155',4549.68,0.00,0.00,8.01,408.51,'2022-02-28 12:40:18','',''),(124,'1','219','1',1,'Retail Sale Id 156',1709.68,0.00,0.00,3.01,153.51,'2022-02-28 12:41:32','',''),(125,'1','219','1',1,'Retail Sale Id 157',1499.52,0.00,0.00,2.64,134.64,'2022-02-28 12:53:31','',''),(126,'1','219','1',1,'Retail Sale Id 158',1499.52,0.00,0.00,2.64,134.64,'2022-02-28 13:21:25','',''),(127,'1','219','1',1,'Retail Sale Id 159',568.00,0.00,0.00,1.00,51.00,'2022-02-28 13:45:14','',''),(128,'1','219','1',1,'Retail Sale Id 160',6821.68,0.00,0.00,12.01,612.51,'2022-02-28 13:54:27','',''),(129,'1','219','1',1,'Retail Sale Id 161',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 13:55:31','',''),(130,'1','219','1',1,'Retail Sale Id 162',1709.68,0.00,0.00,3.01,153.51,'2022-02-28 13:57:15','',''),(131,'1','219','1',1,'Retail Sale Id 163',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 14:28:42','',''),(132,'1','219','1',1,'Retail Sale Id 171',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 15:04:09','',''),(133,'1','219','1',1,'Retail Sale Id 174',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 15:27:15','',''),(134,'1','219','1',1,'Retail Sale Id 175',2300.40,0.00,0.00,4.05,206.55,'2022-02-28 15:35:06','',''),(135,'1','219','1',1,'Retail Sale Id 176',5680.00,0.00,0.00,10.00,510.00,'2022-02-28 16:26:12','',''),(136,'1','219','1',1,'Retail Sale Id 177',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 16:31:14','',''),(137,'1','219','1',1,'Retail Sale Id 179',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 16:32:47','',''),(138,'1','219','1',1,'Retail Sale Id 181',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 16:50:17','',''),(139,'1','219','1',1,'Retail Sale Id 183',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 16:58:48','',''),(140,'1','219','1',1,'Retail Sale Id 184',1709.68,0.00,0.00,3.01,153.51,'2022-02-28 17:12:09','',''),(141,'1','219','1',1,'Retail Sale Id 185',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 17:18:10','',''),(142,'1','219','1',1,'Retail Sale Id 186',1698.32,0.00,0.00,2.99,152.49,'2022-02-28 17:22:34','',''),(143,'1','219','1',1,'Retail Sale Id 186',1698.32,0.00,0.00,2.99,152.49,'2022-02-28 17:22:34','',''),(144,'1','219','1',1,'Retail Sale Id 187',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 17:24:11','',''),(145,'1','219','1',1,'Retail Sale Id 188',2499.20,0.00,0.00,4.40,224.40,'2022-02-28 17:25:34','',''),(146,'1','219','1',1,'Retail Sale Id 189',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 17:29:31','',''),(147,'1','219','1',1,'Retail Sale Id 190',602.08,0.00,0.00,1.06,54.06,'2022-02-28 17:48:26','',''),(148,'1','219','1',1,'Retail Sale Id 191',1147.36,0.00,0.00,2.02,103.02,'2022-02-28 18:26:05','',''),(149,'1','219','1',1,'Retail Sale Id 192',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 18:36:47','',''),(150,'1','219','1',1,'Retail Sale Id 194',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 18:38:49','',''),(151,'1','219','1',1,'Retail Sale Id 195',1709.68,0.00,0.00,3.01,153.51,'2022-02-28 18:50:41','',''),(152,'1','219','1',1,'Retail Sale Id 197',602.08,0.00,0.00,1.06,54.06,'2022-02-28 18:51:52','',''),(153,'1','219','1',1,'Retail Sale Id 198',1499.52,0.00,0.00,2.64,134.64,'2022-02-28 19:18:52','',''),(154,'1','219','1',1,'Retail Sale Id 199',602.08,0.00,0.00,1.06,54.06,'2022-02-28 19:19:57','',''),(155,'1','219','1',1,'Retail Sale Id 200',1198.48,0.00,0.00,2.11,107.61,'2022-02-28 19:23:17','',''),(156,'1','219','1',1,'Retail Sale Id 201',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 22:51:01','',''),(157,'1','219','1',1,'Retail Sale Id 202',27000.00,0.00,0.00,50.00,1150.00,'2022-03-01 09:00:52','',''),(158,'1','219','1',1,'Retail Sale Id 203',1147.36,0.00,0.00,2.02,103.02,'2022-03-01 09:01:52','',''),(159,'1','219','1',1,'Retail Sale Id 204',7401.04,0.00,0.00,13.03,664.53,'2022-03-01 09:21:16','',''),(160,'1','219','1',1,'Retail Sale Id 206',1698.32,0.00,0.00,2.99,152.49,'2022-03-01 09:31:53','',''),(161,'1','219','1',1,'Retail Sale Id 207',3447.76,0.00,0.00,6.07,309.57,'2022-03-01 10:04:47','',''),(162,'1','219','1',1,'Retail Sale Id 208',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 10:06:06','',''),(163,'1','219','1',1,'Retail Sale Id 209',3998.72,0.00,0.00,7.04,359.04,'2022-03-01 10:20:32','',''),(164,'1','219','1',1,'Retail Sale Id 210',7100.00,0.00,0.00,12.50,637.50,'2022-03-01 10:51:54','',''),(165,'1','219','1',1,'Retail Sale Id 212',2499.20,0.00,0.00,4.40,224.40,'2022-03-01 11:05:39','',''),(166,'1','219','1',1,'Retail Sale Id 213',800.88,0.00,0.00,1.41,71.91,'2022-03-01 11:15:02','',''),(167,'1','219','1',1,'Retail Sale Id 214',897.44,0.00,0.00,1.58,80.58,'2022-03-01 11:16:42','',''),(168,'1','219','1',1,'Retail Sale Id 215',1499.52,0.00,0.00,2.64,134.64,'2022-03-01 11:44:37','',''),(169,'1','219','1',1,'Retail Sale Id 216',999.68,0.00,0.00,1.76,89.76,'2022-03-01 11:48:20','',''),(170,'1','219','1',1,'Retail Sale Id 217',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 11:54:02','',''),(171,'1','219','1',1,'Retail Sale Id 218',1709.68,0.00,0.00,3.01,153.51,'2022-03-01 12:13:20','',''),(172,'1','219','1',1,'Retail Sale Id 219',7100.00,0.00,0.00,12.50,637.50,'2022-03-01 12:26:13','',''),(173,'1','219','1',1,'Retail Sale Id 220',7100.00,0.00,0.00,12.50,637.50,'2022-03-01 12:34:53','',''),(174,'1','219','1',1,'Retail Sale Id 221',1709.68,0.00,0.00,3.01,153.51,'2022-03-01 13:35:27','',''),(175,'1','219','1',1,'Retail Sale Id 222',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 14:08:45','',''),(176,'1','219','1',1,'Retail Sale Id 223',698.64,0.00,0.00,1.23,62.73,'2022-03-01 15:02:56','',''),(177,'1','219','1',1,'Retail Sale Id 224',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 15:29:10','',''),(178,'1','219','1',1,'Retail Sale Id 228',1147.36,0.00,0.00,2.02,103.02,'2022-03-01 16:00:26','',''),(179,'1','219','1',1,'Retail Sale Id 229',1800.56,0.00,0.00,3.17,161.67,'2022-03-01 16:02:56','',''),(180,'1','219','1',1,'Retail Sale Id 231',999.68,0.00,0.00,1.76,89.76,'2022-03-01 16:32:11','',''),(181,'1','219','1',1,'Retail Sale Id 233',2300.40,0.00,0.00,4.05,206.55,'2022-03-01 16:43:01','',''),(182,'1','219','1',1,'Retail Sale Id 234',1709.68,0.00,0.00,3.01,153.51,'2022-03-01 17:01:07','',''),(183,'1','219','1',1,'Retail Sale Id 235',1499.52,0.00,0.00,2.64,134.64,'2022-03-01 17:25:09','',''),(184,'1','219','1',1,'Retail Sale Id 236',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 17:30:22','',''),(185,'1','219','1',1,'Retail Sale Id 237',1999.36,0.00,0.00,3.52,179.52,'2022-03-01 17:49:32','',''),(186,'1','219','1',1,'Retail Sale Id 238',5702.72,0.00,0.00,10.04,512.04,'2022-03-01 18:05:50','',''),(187,'1','219','1',1,'Retail Sale Id 239',5680.00,0.00,0.00,10.00,510.00,'2022-03-01 18:12:10','',''),(188,'1','219','1',1,'Retail Sale Id 240',1709.68,0.00,0.00,3.01,153.51,'2022-03-01 18:20:37','',''),(189,'1','219','1',1,'Retail Sale Id 241',1147.36,0.00,0.00,2.02,103.02,'2022-03-01 18:23:41','',''),(190,'1','219','1',1,'Retail Sale Id 242',499.84,0.00,0.00,0.88,44.88,'2022-03-01 18:24:57','',''),(191,'1','219','1',1,'Retail Sale Id 243',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 19:21:32','',''),(192,'1','219','1',1,'Retail Sale Id 244',568.00,0.00,0.00,1.00,51.00,'2022-03-02 08:26:23','',''),(193,'1','219','1',1,'Retail Sale Id 245',5998.08,0.00,0.00,10.56,538.56,'2022-03-02 08:47:16','',''),(194,'1','219','1',1,'Retail Sale Id 246',4998.40,0.00,0.00,8.80,448.80,'2022-03-02 08:48:47','',''),(195,'1','219','1',1,'Retail Sale Id 248',1698.32,0.00,0.00,2.99,152.49,'2022-03-02 08:55:52','',''),(196,'1','219','1',1,'Retail Sale Id 250',5680.00,0.00,0.00,10.00,510.00,'2022-03-02 11:13:23','',''),(197,'1','219','1',1,'Retail Sale Id 251',7100.00,0.00,0.00,12.50,637.50,'2022-03-02 11:23:27','',''),(198,'1','219','1',1,'Retail Sale Id 252',7100.00,0.00,0.00,12.50,637.50,'2022-03-02 11:45:39','',''),(199,'1','219','1',1,'Retail Sale Id 253',1709.68,0.00,0.00,3.01,153.51,'2022-03-02 11:47:08','',''),(200,'1','219','1',1,'Retail Sale Id 255',2999.04,0.00,0.00,5.28,269.28,'2022-03-02 11:56:52','',''),(201,'1','219','1',1,'Retail Sale Id 256',1499.52,0.00,0.00,2.64,134.64,'2022-03-02 12:13:49','',''),(202,'1','219','1',1,'Retail Sale Id 257',7100.00,0.00,0.00,12.50,637.50,'2022-03-02 12:29:37','',''),(203,'1','219','1',1,'Retail Sale Id 258',3408.00,0.00,0.00,6.00,306.00,'2022-03-02 12:35:02','',''),(204,'1','219','1',1,'Retail Sale Id 259',1698.32,0.00,0.00,2.99,152.49,'2022-03-02 12:53:37','',''),(205,'1','219','1',1,'Retail Sale Id 259',1698.32,0.00,0.00,2.99,152.49,'2022-03-02 12:53:37','',''),(206,'1','219','1',1,'Retail Sale Id 261',2999.04,0.00,0.00,5.28,269.28,'2022-03-02 13:17:55','',''),(207,'1','219','1',1,'Retail Sale Id 261',2999.04,0.00,0.00,5.28,269.28,'2022-03-02 13:17:55','',''),(208,'1','219','1',1,'Retail Sale Id 262',499.84,0.00,0.00,0.88,44.88,'2022-03-02 13:33:19','',''),(209,'1','219','1',1,'Retail Sale Id 263',3408.00,0.00,0.00,6.00,306.00,'2022-03-02 14:03:03','',''),(210,'1','219','1',1,'Retail Sale Id 264',3408.00,0.00,0.00,6.00,306.00,'2022-03-02 14:11:51','',''),(211,'1','219','1',1,'Retail Sale Id 265',3408.00,0.00,0.00,6.00,306.00,'2022-03-02 14:15:18','',''),(212,'1','219','1',1,'Retail Sale Id 267',1709.68,0.00,0.00,3.01,153.51,'2022-03-02 14:35:01','',''),(213,'1','219','1',1,'Retail Sale Id 268',5680.00,0.00,0.00,10.00,510.00,'2022-03-02 14:40:10','',''),(214,'1','219','1',1,'Retail Sale Id 269',1709.68,0.00,0.00,3.01,153.51,'2022-03-02 14:46:16','',''),(215,'1','219','1',1,'Retail Sale Id 270',3197.84,0.00,0.00,5.63,287.13,'2022-03-02 15:27:41','',''),(216,'1','219','1',1,'Retail Sale Id 271',1709.68,0.00,0.00,3.01,153.51,'2022-03-02 15:36:18','',''),(217,'1','219','1',1,'Retail Sale Id 271',2840.00,0.00,0.00,5.00,255.00,'2022-03-02 15:36:18','',''),(218,'1','219','1',1,'Retail Sale Id 272',2840.00,0.00,0.00,5.00,255.00,'2022-03-02 15:38:26','',''),(219,'1','219','1',1,'Retail Sale Id 273',2300.40,0.00,0.00,4.05,206.55,'2022-03-02 16:26:42','',''),(220,'1','219','1',1,'Retail Sale Id 274',397.60,0.00,0.00,0.70,35.70,'2022-03-02 16:31:10','',''),(221,'1','219','1',1,'Retail Sale Id 275',3408.00,0.00,0.00,6.00,306.00,'2022-03-02 16:46:35','',''),(222,'1','219','1',1,'Retail Sale Id 276',1709.68,0.00,0.00,3.01,153.51,'2022-03-02 17:24:56','',''),(223,'1','219','1',1,'Retail Sale Id 277',1709.68,0.00,0.00,3.01,153.51,'2022-03-02 17:42:37','',''),(224,'1','219','1',1,'Retail Sale Id 279',7100.00,0.00,0.00,12.50,637.50,'2022-03-02 17:54:26','',''),(225,'1','219','1',1,'Retail Sale Id 281',999.68,0.00,0.00,1.76,89.76,'2022-03-02 18:34:01','',''),(226,'1','219','1',1,'Retail Sale Id 281',999.68,0.00,0.00,1.76,89.76,'2022-03-02 18:34:01','',''),(227,'1','219','1',1,'Retail Sale Id 283',999.68,0.00,0.00,1.76,89.76,'2022-03-02 18:37:03','',''),(228,'1','219','1',1,'Retail Sale Id 284',301.04,0.00,0.00,0.53,27.03,'2022-03-02 18:38:40','',''),(229,'1','219','1',1,'Retail Sale Id 291',7100.00,0.00,0.00,12.50,637.50,'2022-03-02 19:15:42','',''),(230,'1','219','1',1,'Retail Sale Id 292',1999.36,0.00,0.00,3.52,179.52,'2022-03-02 19:34:47','',''),(231,'1','219','1',1,'Retail Sale Id 293',1147.36,0.00,0.00,2.02,103.02,'2022-03-03 08:31:46','',''),(232,'1','219','1',1,'Retail Sale Id 295',1999.36,0.00,0.00,3.52,179.52,'2022-03-03 08:44:12','',''),(233,'1','219','1',1,'Retail Sale Id 296',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 08:53:11','',''),(234,'1','219','1',1,'Retail Sale Id 296',7100.00,0.00,0.00,12.50,637.50,'2022-03-03 08:53:11','',''),(235,'1','219','1',1,'Retail Sale Id 300',550.96,0.00,0.00,0.97,49.47,'2022-03-03 10:12:48','',''),(236,'1','219','1',1,'Retail Sale Id 301',2300.40,0.00,0.00,4.05,206.55,'2022-03-03 11:08:05','',''),(237,'1','219','1',1,'Retail Sale Id 302',7100.00,0.00,0.00,12.50,637.50,'2022-03-03 11:27:01','',''),(238,'1','219','1',1,'Retail Sale Id 304',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 11:28:36','',''),(239,'1','219','1',1,'Retail Sale Id 305',800.88,0.00,0.00,1.41,71.91,'2022-03-03 11:31:51','',''),(240,'1','219','1',1,'Retail Sale Id 306',2840.00,0.00,0.00,5.00,255.00,'2022-03-03 11:33:05','',''),(241,'1','219','1',1,'Retail Sale Id 309',1999.36,0.00,0.00,3.52,179.52,'2022-03-03 11:42:12','',''),(242,'1','219','1',1,'Retail Sale Id 310',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 12:23:22','',''),(243,'1','219','1',1,'Retail Sale Id 311',56800.00,0.00,0.00,100.00,5100.00,'2022-03-03 13:05:06','',''),(244,'1','219','1',1,'Return of Retail Sale Id 311',0.00,56800.00,100.00,0.00,-5100.00,'2022-03-03 13:06:06','',''),(245,'1','219','1',1,'Retail Sale Id 312',54000.00,0.00,0.00,100.00,2300.00,'2022-03-03 13:07:11','',''),(246,'1','219','1',1,'Retail Sale Id 313',27000.00,0.00,0.00,50.00,1150.00,'2022-03-03 13:07:56','',''),(247,'1','219','1',1,'Retail Sale Id 316',3498.88,0.00,0.00,6.16,314.16,'2022-03-03 13:43:08','',''),(248,'1','219','1',1,'Retail Sale Id 317',6821.68,0.00,0.00,12.01,612.51,'2022-03-03 14:35:40','',''),(249,'1','219','1',1,'Retail Sale Id 318',1709.68,0.00,0.00,3.01,153.51,'2022-03-03 15:10:42','',''),(250,'1','219','1',1,'Retail Sale Id 320',999.68,0.00,0.00,1.76,89.76,'2022-03-03 16:25:06','',''),(251,'1','219','1',1,'Retail Sale Id 320',1499.52,0.00,0.00,2.64,134.64,'2022-03-03 16:25:06','',''),(252,'1','219','1',1,'Retail Sale Id 320',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 16:25:06','',''),(253,'1','219','1',1,'Retail Sale Id 321',1999.36,0.00,0.00,3.52,179.52,'2022-03-03 17:27:41','',''),(254,'1','219','1',1,'Retail Sale Id 322',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 17:40:14','',''),(255,'1','219','1',1,'Retail Sale Id 323',1397.28,0.00,0.00,2.46,125.46,'2022-03-03 18:00:01','',''),(256,'1','219','1',1,'Retail Sale Id 324',499.84,0.00,0.00,0.88,44.88,'2022-03-03 18:05:48','',''),(257,'1','219','1',1,'Retail Sale Id 326',2999.04,0.00,0.00,5.28,269.28,'2022-03-03 18:43:24','',''),(258,'1','219','1',1,'Retail Sale Id 327',1709.68,0.00,0.00,3.01,153.51,'2022-03-03 19:10:22','',''),(259,'1','219','1',1,'Retail Sale Id 328',1709.68,0.00,0.00,3.01,153.51,'2022-03-03 19:12:53','',''),(260,'1','219','1',1,'Retail Sale Id 329',698.64,0.00,0.00,1.23,62.73,'2022-03-03 19:14:46','',''),(261,'1','219','1',1,'Retail Sale Id 330',1709.68,0.00,0.00,3.01,153.51,'2022-03-03 19:17:02','',''),(262,'1','219','1',1,'Retail Sale Id 331',2840.00,0.00,0.00,5.00,255.00,'2022-03-03 19:34:40','',''),(263,'1','219','1',1,'Retail Sale Id 332',1198.48,0.00,0.00,2.11,107.61,'2022-03-04 08:23:06','',''),(264,'1','219','1',1,'Retail Sale Id 333',4498.56,0.00,0.00,7.92,403.92,'2022-03-04 08:27:22','',''),(265,'1','219','1',1,'Retail Sale Id 334',1198.48,0.00,0.00,2.11,107.61,'2022-03-04 08:57:10','',''),(266,'1','219','1',1,'Retail Sale Id 335',5998.08,0.00,0.00,10.56,538.56,'2022-03-04 09:01:37','',''),(267,'1','219','1',1,'Retail Sale Id 336',3998.72,0.00,0.00,7.04,359.04,'2022-03-04 09:02:34','',''),(268,'1','219','1',1,'Retail Sale Id 337',1709.68,0.00,0.00,3.01,153.51,'2022-03-04 09:45:28','',''),(269,'1','219','1',1,'Retail Sale Id 338',2851.36,0.00,0.00,5.02,256.02,'2022-03-04 10:46:20','',''),(270,'1','219','1',1,'Retail Sale Id 339',3402.32,0.00,0.00,5.99,305.49,'2022-03-04 11:21:40','',''),(271,'1','219','1',1,'Retail Sale Id 341',698.64,0.00,0.00,1.23,62.73,'2022-03-04 11:59:30','',''),(272,'1','219','1',1,'Retail Sale Id 342',1147.36,0.00,0.00,2.02,103.02,'2022-03-04 12:03:49','',''),(273,'1','219','1',1,'Retail Sale Id 343',1999.36,0.00,0.00,3.52,179.52,'2022-03-04 12:16:53','',''),(274,'1','219','1',1,'Retail Sale Id 344',3998.72,0.00,0.00,7.04,359.04,'2022-03-04 12:55:59','',''),(275,'1','219','1',1,'Retail Sale Id 345',602.08,0.00,0.00,1.06,54.06,'2022-03-04 14:08:14','',''),(276,'1','219','1',1,'Retail Sale Id 346',7100.00,0.00,0.00,12.50,637.50,'2022-03-04 15:02:38','',''),(277,'1','219','1',1,'Retail Sale Id 347',1698.32,0.00,0.00,2.99,152.49,'2022-03-04 15:03:43','',''),(278,'1','219','1',1,'Retail Sale Id 348',4549.68,0.00,0.00,8.01,408.51,'2022-03-04 15:21:01','',''),(279,'1','219','1',1,'Retail Sale Id 349',2851.36,0.00,0.00,5.02,256.02,'2022-03-04 15:22:15','',''),(280,'1','219','1',1,'Retail Sale Id 350',2840.00,0.00,0.00,5.00,255.00,'2022-03-04 15:35:23','',''),(281,'1','219','1',1,'Retail Sale Id 351',2840.00,0.00,0.00,5.00,255.00,'2022-03-04 15:59:26','',''),(282,'1','219','1',1,'Retail Sale Id 353',1999.36,0.00,0.00,3.52,179.52,'2022-03-04 16:13:46','',''),(283,'1','219','1',1,'Retail Sale Id 354',1709.68,0.00,0.00,3.01,153.51,'2022-03-04 16:18:48','',''),(284,'1','219','1',1,'Retail Sale Id 355',999.68,0.00,0.00,1.76,89.76,'2022-03-04 16:27:25','',''),(285,'1','219','1',1,'Retail Sale Id 356',3498.88,0.00,0.00,6.16,314.16,'2022-03-04 16:55:40','',''),(286,'1','219','1',1,'Retail Sale Id 357',2851.36,0.00,0.00,5.02,256.02,'2022-03-04 17:16:06','',''),(287,'1','219','1',1,'Retail Sale Id 358',499.84,0.00,0.00,0.88,44.88,'2022-03-04 17:22:14','',''),(288,'1','219','1',1,'Retail Sale Id 359',7100.00,0.00,0.00,12.50,637.50,'2022-03-04 17:29:02','',''),(289,'1','219','1',1,'Retail Sale Id 359',7100.00,0.00,0.00,12.50,637.50,'2022-03-04 17:29:02','',''),(290,'1','219','1',1,'Retail Sale Id 360',1147.36,0.00,0.00,2.02,103.02,'2022-03-04 17:38:44','',''),(291,'1','219','1',1,'Retail Sale Id 361',1721.04,0.00,0.00,3.03,154.53,'2022-03-04 17:58:57','',''),(292,'1','219','1',1,'Retail Sale Id 362',7100.00,0.00,0.00,12.50,637.50,'2022-03-04 18:01:33','',''),(293,'1','219','1',1,'Retail Sale Id 363',3419.36,0.00,0.00,6.02,307.02,'2022-03-04 18:13:37','',''),(294,'1','219','1',1,'Retail Sale Id 364',2840.00,0.00,0.00,5.00,255.00,'2022-03-04 18:18:04','',''),(295,'1','219','1',1,'Retail Sale Id 365',1709.68,0.00,0.00,3.01,153.51,'2022-03-04 18:20:53','',''),(296,'1','219','1',1,'Retail Sale Id 366',7100.00,0.00,0.00,12.50,637.50,'2022-03-04 18:24:24','',''),(297,'1','219','1',1,'Retail Sale Id 367',1709.68,0.00,0.00,3.01,153.51,'2022-03-04 18:25:35','',''),(298,'1','219','1',1,'Retail Sale Id 368',4998.40,0.00,0.00,8.80,448.80,'2022-03-04 18:41:16','',''),(299,'1','219','1',1,'Retail Sale Id 369',698.64,0.00,0.00,1.23,62.73,'2022-03-04 19:01:33','',''),(300,'1','219','1',1,'Retail Sale Id 370',301.04,0.00,0.00,0.53,27.03,'2022-03-04 19:20:35','',''),(301,'1','219','1',1,'Retail Sale Id 371',499.84,0.00,0.00,0.88,44.88,'2022-03-04 19:37:54','',''),(302,'1','219','1',1,'Retail Sale Id 372',999.68,0.00,0.00,1.76,89.76,'2022-03-04 19:39:21','',''),(303,'1','219','1',1,'Return of Retail Sale Id 368',0.00,4998.40,8.80,0.00,-448.80,'2022-03-04 20:16:35','',''),(304,'1','219','1',1,'Retail Sale Id 373',3748.80,0.00,0.00,6.60,336.60,'2022-03-04 20:17:24','',''),(305,'1','219','1',1,'Retail Sale Id 374',39.76,0.00,0.00,0.07,3.57,'2022-03-04 20:18:56','',''),(306,'1','219','1',1,'Retail Sale Id 375',5680.00,0.00,0.00,10.00,510.00,'2022-03-05 07:56:11','',''),(307,'1','219','1',1,'Retail Sale Id 376',2999.04,0.00,0.00,5.28,269.28,'2022-03-05 08:04:47','',''),(308,'1','219','1',1,'Retail Sale Id 378',602.08,0.00,0.00,1.06,54.06,'2022-03-05 08:26:03','',''),(309,'1','219','1',1,'Retail Sale Id 379',2999.04,0.00,0.00,5.28,269.28,'2022-03-05 08:49:51','',''),(310,'1','219','1',1,'Retail Sale Id 380',5702.72,0.00,0.00,10.04,512.04,'2022-03-05 09:04:59','',''),(311,'1','219','1',1,'Retail Sale Id 381',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 09:08:41','',''),(312,'1','219','1',1,'Retail Sale Id 382',3998.72,0.00,0.00,7.04,359.04,'2022-03-05 09:31:28','',''),(313,'1','219','1',1,'Retail Sale Id 383',698.64,0.00,0.00,1.23,62.73,'2022-03-05 09:32:47','',''),(314,'1','219','1',1,'Retail Sale Id 384',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 10:10:15','',''),(315,'1','219','1',1,'Retail Sale Id 385',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 10:17:03','',''),(316,'1','219','1',1,'Retail Sale Id 386',999.68,0.00,0.00,1.76,89.76,'2022-03-05 10:19:12','',''),(317,'1','219','1',1,'Retail Sale Id 387',2499.20,0.00,0.00,4.40,224.40,'2022-03-05 10:46:15','',''),(318,'1','219','1',1,'Retail Sale Id 388',1749.44,0.00,0.00,3.08,157.08,'2022-03-05 10:51:17','',''),(319,'1','219','1',1,'Retail Sale Id 389',1698.32,0.00,0.00,2.99,152.49,'2022-03-05 11:48:10','',''),(320,'1','219','1',1,'Retail Sale Id 391',999.68,0.00,0.00,1.76,89.76,'2022-03-05 12:02:33','',''),(321,'1','219','1',1,'Retail Sale Id 392',1698.32,0.00,0.00,2.99,152.49,'2022-03-05 12:17:04','',''),(322,'1','219','1',1,'Retail Sale Id 393',1499.52,0.00,0.00,2.64,134.64,'2022-03-05 12:18:34','',''),(323,'1','219','1',1,'Retail Sale Id 393',1499.52,0.00,0.00,2.64,134.64,'2022-03-05 12:18:34','',''),(324,'1','219','1',1,'Retail Sale Id 394',1147.36,0.00,0.00,2.02,103.02,'2022-03-05 12:38:12','',''),(325,'1','219','1',1,'Retail Sale Id 395',1709.68,0.00,0.00,3.01,153.51,'2022-03-05 12:41:04','',''),(326,'1','219','1',1,'Retail Sale Id 396',1999.36,0.00,0.00,3.52,179.52,'2022-03-05 12:42:25','',''),(327,'1','219','1',1,'Retail Sale Id 397',2999.04,0.00,0.00,5.28,269.28,'2022-03-05 12:59:09','',''),(328,'1','219','1',1,'Retail Sale Id 398',800.88,0.00,0.00,1.41,71.91,'2022-03-05 13:07:52','',''),(329,'1','219','1',1,'Retail Sale Id 400',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 13:26:59','',''),(330,'1','219','1',1,'Retail Sale Id 401',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 13:39:58','',''),(331,'1','219','1',1,'Retail Sale Id 401',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 13:39:58','',''),(332,'1','219','1',1,'Retail Sale Id 402',1709.68,0.00,0.00,3.01,153.51,'2022-03-05 13:40:47','',''),(333,'1','219','1',1,'Retail Sale Id 403',2300.40,0.00,0.00,4.05,206.55,'2022-03-05 14:02:19','',''),(334,'1','219','1',1,'Retail Sale Id 404',301.04,0.00,0.00,0.53,27.03,'2022-03-05 14:14:51','',''),(335,'1','219','1',1,'Retail Sale Id 405',3976.00,0.00,0.00,7.00,357.00,'2022-03-05 14:17:07','',''),(336,'1','219','1',1,'Retail Sale Id 406',1147.36,0.00,0.00,2.02,103.02,'2022-03-05 14:52:12','',''),(337,'1','219','1',1,'Retail Sale Id 407',3498.88,0.00,0.00,6.16,314.16,'2022-03-05 15:40:39','',''),(338,'1','219','1',1,'Retail Sale Id 408',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 16:21:04','',''),(339,'1','219','1',1,'Retail Sale Id 409',4549.68,0.00,0.00,8.01,408.51,'2022-03-05 16:39:44','',''),(340,'1','219','1',1,'Retail Sale Id 410',602.08,0.00,0.00,1.06,54.06,'2022-03-05 16:44:07','',''),(341,'1','219','1',1,'Retail Sale Id 411',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 16:53:54','',''),(342,'1','219','1',1,'Retail Sale Id 412',2840.00,0.00,0.00,5.00,255.00,'2022-03-05 16:55:49','',''),(343,'1','219','1',1,'Retail Sale Id 413',1709.68,0.00,0.00,3.01,153.51,'2022-03-05 16:58:24','',''),(344,'1','219','1',1,'Retail Sale Id 414',3498.88,0.00,0.00,6.16,314.16,'2022-03-05 17:01:04','',''),(345,'1','219','1',1,'Retail Sale Id 415',1499.52,0.00,0.00,2.64,134.64,'2022-03-05 17:15:07','',''),(346,'1','219','1',1,'Retail Sale Id 417',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 17:30:48','',''),(347,'1','219','1',1,'Retail Sale Id 418',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 17:39:04','',''),(348,'1','219','1',1,'Retail Sale Id 419',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 17:43:44','',''),(349,'1','219','1',1,'Retail Sale Id 419',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 17:43:44','',''),(350,'1','219','1',1,'Retail Sale Id 420',5702.72,0.00,0.00,10.04,512.04,'2022-03-05 17:45:46','',''),(351,'1','219','1',1,'Retail Sale Id 421',2840.00,0.00,0.00,5.00,255.00,'2022-03-05 17:50:43','',''),(352,'1','219','1',1,'Retail Sale Id 422',4549.68,0.00,0.00,8.01,408.51,'2022-03-05 17:56:27','',''),(353,'1','219','1',1,'Retail Sale Id 423',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 17:58:50','',''),(354,'1','219','1',1,'Retail Sale Id 424',698.64,0.00,0.00,1.23,62.73,'2022-03-05 18:03:02','',''),(355,'1','219','1',1,'Retail Sale Id 425',698.64,0.00,0.00,1.23,62.73,'2022-03-05 18:15:47','',''),(356,'1','219','1',1,'Retail Sale Id 426',1698.32,0.00,0.00,2.99,152.49,'2022-03-05 18:20:25','',''),(357,'1','219','1',1,'Retail Sale Id 427',499.84,0.00,0.00,0.88,44.88,'2022-03-05 18:31:36','',''),(358,'1','219','1',1,'Retail Sale Id 428',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 18:48:15','',''),(359,'1','219','1',1,'Retail Sale Id 429',2851.36,0.00,0.00,5.02,256.02,'2022-03-05 18:56:35','',''),(360,'1','219','1',1,'Retail Sale Id 430',499.84,0.00,0.00,0.88,44.88,'2022-03-05 19:14:57','',''),(361,'1','219','1',1,'Retail Sale Id 431',1198.48,0.00,0.00,2.11,107.61,'2022-03-05 19:56:07','',''),(362,'1','219','1',1,'Return of Retail Sale Id 431',0.00,1198.48,2.11,0.00,-107.61,'2022-03-05 19:57:18','',''),(363,'1','219','1',1,'Retail Sale Id 432',198.80,0.00,0.00,0.35,17.85,'2022-03-05 21:13:58','',''),(364,'1','219','1',1,'Retail Sale Id 433',999.68,0.00,0.00,1.76,89.76,'2022-03-05 21:16:01','',''),(365,'1','219','1',1,'Retail Sale Id 434',2840.00,0.00,0.00,5.00,255.00,'2022-03-06 08:15:29','',''),(366,'1','219','1',1,'Retail Sale Id 435',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 08:55:14','',''),(367,'1','219','1',1,'Retail Sale Id 436',1698.32,0.00,0.00,2.99,152.49,'2022-03-06 09:13:11','',''),(368,'1','219','1',1,'Retail Sale Id 437',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 09:18:18','',''),(369,'1','219','1',1,'Retail Sale Id 438',170100.00,0.00,0.00,315.00,7245.00,'2022-03-06 09:20:07','',''),(370,'1','219','1',1,'Retail Sale Id 439',999.68,0.00,0.00,1.76,89.76,'2022-03-06 09:21:37','',''),(371,'1','219','1',1,'Retail Sale Id 440',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 09:48:02','',''),(372,'1','219','1',1,'Retail Sale Id 442',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 10:03:39','',''),(373,'1','219','1',1,'Retail Sale Id 443',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 10:06:24','',''),(374,'1','219','1',1,'Retail Sale Id 444',3998.72,0.00,0.00,7.04,359.04,'2022-03-06 10:26:24','',''),(375,'1','219','1',1,'Retail Sale Id 445',7100.00,0.00,0.00,12.50,637.50,'2022-03-06 10:33:54','',''),(376,'1','219','1',1,'Retail Sale Id 446',2840.00,0.00,0.00,5.00,255.00,'2022-03-06 10:59:09','',''),(377,'1','219','1',1,'Retail Sale Id 447',1198.48,0.00,0.00,2.11,107.61,'2022-03-06 11:00:49','',''),(378,'1','219','1',1,'Retail Sale Id 448',1999.36,0.00,0.00,3.52,179.52,'2022-03-06 11:02:16','',''),(379,'1','219','1',1,'Retail Sale Id 449',1999.36,0.00,0.00,3.52,179.52,'2022-03-06 11:14:02','',''),(380,'1','219','1',1,'Retail Sale Id 451',2300.40,0.00,0.00,4.05,206.55,'2022-03-06 11:16:35','',''),(381,'1','219','1',1,'Retail Sale Id 452',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 11:46:04','',''),(382,'1','219','1',1,'Retail Sale Id 452',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 11:46:04','',''),(383,'1','219','1',1,'Retail Sale Id 453',54000.00,0.00,0.00,100.00,2300.00,'2022-03-06 11:54:08','',''),(384,'1','219','1',1,'Retail Sale Id 454',40500.00,0.00,0.00,75.00,1725.00,'2022-03-06 11:55:57','',''),(385,'1','219','1',1,'Retail Sale Id 455',3998.72,0.00,0.00,7.04,359.04,'2022-03-06 12:00:41','',''),(386,'1','219','1',1,'Retail Sale Id 456',7100.00,0.00,0.00,12.50,637.50,'2022-03-06 12:07:22','',''),(387,'1','219','1',1,'Retail Sale Id 458',1999.36,0.00,0.00,3.52,179.52,'2022-03-06 12:19:00','',''),(388,'1','219','1',1,'Retail Sale Id 459',999.68,0.00,0.00,1.76,89.76,'2022-03-06 12:23:49','',''),(389,'1','219','1',1,'Retail Sale Id 460',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 12:27:19','',''),(390,'1','219','1',1,'Retail Sale Id 462',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 12:43:51','',''),(391,'1','219','1',1,'Retail Sale Id 463',1999.36,0.00,0.00,3.52,179.52,'2022-03-06 12:49:06','',''),(392,'1','219','1',1,'Retail Sale Id 464',7100.00,0.00,0.00,12.50,637.50,'2022-03-06 13:01:47','',''),(393,'1','219','1',1,'Retail Sale Id 465',301.04,0.00,0.00,0.53,27.03,'2022-03-06 13:11:01','',''),(394,'1','219','1',1,'Retail Sale Id 466',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 13:17:31','',''),(395,'1','219','1',1,'Retail Sale Id 467',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 13:18:33','',''),(396,'1','219','1',1,'Retail Sale Id 468',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 13:19:22','',''),(397,'1','219','1',1,'Retail Sale Id 469',3197.84,0.00,0.00,5.63,287.13,'2022-03-06 13:22:10','',''),(398,'1','219','1',1,'Retail Sale Id 470',5680.00,0.00,0.00,10.00,510.00,'2022-03-06 13:25:40','',''),(399,'1','219','1',1,'Retail Sale Id 471',1999.36,0.00,0.00,3.52,179.52,'2022-03-06 13:32:06','',''),(400,'1','219','1',1,'Retail Sale Id 472',800.88,0.00,0.00,1.41,71.91,'2022-03-06 13:33:37','',''),(401,'1','219','1',1,'Retail Sale Id 473',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 13:51:05','',''),(402,'1','219','1',1,'Retail Sale Id 474',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 14:30:25','',''),(403,'1','219','1',1,'Retail Sale Id 475',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 14:31:02','',''),(404,'1','219','1',1,'Retail Sale Id 476',2840.00,0.00,0.00,5.00,255.00,'2022-03-06 14:32:01','',''),(405,'1','219','1',1,'Retail Sale Id 477',1147.36,0.00,0.00,2.02,103.02,'2022-03-06 14:32:59','',''),(406,'1','219','1',1,'Retail Sale Id 478',1101.92,0.00,0.00,1.94,98.94,'2022-03-06 14:33:47','',''),(407,'1','219','1',1,'Retail Sale Id 479',7100.00,0.00,0.00,12.50,637.50,'2022-03-06 14:55:27','',''),(408,'1','219','1',1,'Retail Sale Id 481',1147.36,0.00,0.00,2.02,103.02,'2022-03-06 15:13:35','',''),(409,'1','219','1',1,'Retail Sale Id 482',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 15:27:16','',''),(410,'1','219','1',1,'Retail Sale Id 483',999.68,0.00,0.00,1.76,89.76,'2022-03-06 15:28:40','',''),(411,'1','219','1',1,'Retail Sale Id 489',2851.36,0.00,0.00,5.02,256.02,'2022-03-06 17:12:23','',''),(412,'1','219','1',1,'Retail Sale Id 490',2851.36,0.00,0.00,5.02,256.02,'2022-03-06 17:14:10','',''),(413,'1','219','1',1,'Retail Sale Id 491',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 17:17:07','',''),(414,'1','219','1',1,'Retail Sale Id 492',3419.36,0.00,0.00,6.02,307.02,'2022-03-06 17:18:45','',''),(415,'1','219','1',1,'Retail Sale Id 493',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 17:20:40','',''),(416,'1','219','1',1,'Retail Sale Id 499',999.68,0.00,0.00,1.76,89.76,'2022-03-06 17:38:18','',''),(417,'1','219','1',1,'Retail Sale Id 501',1147.36,0.00,0.00,2.02,103.02,'2022-03-06 17:39:12','',''),(418,'1','219','1',1,'Retail Sale Id 503',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 17:40:56','',''),(419,'1','219','1',1,'Retail Sale Id 503',5680.00,0.00,0.00,10.00,510.00,'2022-03-06 17:40:56','',''),(420,'1','219','1',1,'Retail Sale Id 504',1709.68,0.00,0.00,3.01,153.51,'2022-03-06 17:47:44','',''),(421,'1','219','1',1,'Retail Sale Id 505',1800.56,0.00,0.00,3.17,161.67,'2022-03-06 17:48:57','',''),(422,'1','219','1',1,'Retail Sale Id 506',6997.76,0.00,0.00,12.32,628.32,'2022-03-06 17:50:37','',''),(423,'1','219','1',1,'Retail Sale Id 507',7100.00,0.00,0.00,12.50,637.50,'2022-03-06 17:51:42','',''),(424,'1','219','1',1,'Retail Sale Id 508',1999.36,0.00,0.00,3.52,179.52,'2022-03-06 18:02:58','',''),(425,'1','219','1',1,'Retail Sale Id 509',301.04,0.00,0.00,0.53,27.03,'2022-03-06 18:28:10','',''),(426,'1','219','1',1,'Retail Sale Id 510',1800.56,0.00,0.00,3.17,161.67,'2022-03-06 18:47:45','',''),(427,'1','219','1',1,'Retail Sale Id 511',4544.00,0.00,0.00,8.00,408.00,'2022-03-06 18:49:31','',''),(428,'1','219','1',1,'Retail Sale Id 512',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 18:51:08','',''),(429,'1','219','1',1,'Retail Sale Id 513',6816.00,0.00,0.00,12.00,612.00,'2022-03-06 18:52:22','',''),(430,'1','219','1',1,'Retail Sale Id 514',698.64,0.00,0.00,1.23,62.73,'2022-03-06 19:13:32','',''),(431,'1','219','1',1,'Retail Sale Id 514',698.64,0.00,0.00,1.23,62.73,'2022-03-06 19:13:32','',''),(432,'1','219','1',1,'Return of Retail Sale Id 453',0.00,54000.00,100.00,0.00,-2300.00,'2022-03-06 22:02:03','',''),(433,'1','219','1',1,'Retail Sale Id 515',31044.60,0.00,0.00,57.49,1322.27,'2022-03-06 22:04:37','',''),(434,'1','219','1',1,'Retail Sale Id 517',22955.40,0.00,0.00,42.51,977.73,'2022-03-06 22:06:54','',''),(435,'1','219','1',1,'Return of Retail Sale Id 517',0.00,22955.40,42.51,0.00,-977.73,'2022-03-06 22:07:48','',''),(436,'1','219','1',1,'Retail Sale Id 518',21265.20,0.00,0.00,39.38,905.74,'2022-03-06 22:10:12','',''),(437,'1','219','1',1,'Return of Retail Sale Id 514',0.00,698.64,1.23,0.00,-62.73,'2022-03-06 22:12:22','',''),(438,'1','219','1',1,'Return of Retail Sale Id 514',0.00,698.64,1.23,0.00,-62.73,'2022-03-06 22:12:22','',''),(439,'1','219','1',1,'Retail Sale Id 519',840.64,0.00,0.00,1.48,75.48,'2022-03-06 22:13:54','',''),(440,'1','219','1',1,'Retail Sale Id 521',602.08,0.00,0.00,1.06,54.06,'2022-03-06 22:15:48','',''),(441,'1','219','1',1,'Retail Sale Id 522',1709.68,0.00,0.00,3.01,153.51,'2022-03-07 07:42:04','',''),(442,'1','219','1',1,'Retail Sale Id 523',1198.48,0.00,0.00,2.11,107.61,'2022-03-07 08:05:49','',''),(443,'1','219','1',1,'Retail Sale Id 524',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 09:02:16','',''),(444,'1','219','1',1,'Retail Sale Id 525',4498.56,0.00,0.00,7.92,403.92,'2022-03-07 09:31:38','',''),(445,'1','219','1',1,'Retail Sale Id 526',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 09:48:10','',''),(446,'1','219','1',1,'Retail Sale Id 527',1198.48,0.00,0.00,2.11,107.61,'2022-03-07 10:13:12','',''),(447,'1','219','1',1,'Retail Sale Id 528',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 10:39:19','',''),(448,'1','219','1',1,'Retail Sale Id 529',5702.72,0.00,0.00,10.04,512.04,'2022-03-07 11:05:00','',''),(449,'1','219','1',1,'Retail Sale Id 530',3408.00,0.00,0.00,6.00,306.00,'2022-03-07 11:15:53','',''),(450,'1','219','1',1,'Retail Sale Id 531',999.68,0.00,0.00,1.76,89.76,'2022-03-07 11:20:43','',''),(451,'1','219','1',1,'Retail Sale Id 532',3498.88,0.00,0.00,6.16,314.16,'2022-03-07 11:30:08','',''),(452,'1','219','1',1,'Retail Sale Id 533',5680.00,0.00,0.00,10.00,510.00,'2022-03-07 11:42:52','',''),(453,'1','219','1',1,'Retail Sale Id 534',3408.00,0.00,0.00,6.00,306.00,'2022-03-07 12:01:37','',''),(454,'1','219','1',1,'Retail Sale Id 535',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 12:34:45','',''),(455,'1','219','1',1,'Retail Sale Id 536',2999.04,0.00,0.00,5.28,269.28,'2022-03-07 12:44:00','',''),(456,'1','219','1',1,'Retail Sale Id 537',1709.68,0.00,0.00,3.01,153.51,'2022-03-07 12:49:50','',''),(457,'1','219','1',1,'Retail Sale Id 538',800.88,0.00,0.00,1.41,71.91,'2022-03-07 13:48:30','',''),(458,'1','219','1',1,'Retail Sale Id 539',2851.36,0.00,0.00,5.02,256.02,'2022-03-07 13:50:24','',''),(459,'1','219','1',1,'Retail Sale Id 540',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 13:53:14','',''),(460,'1','219','1',1,'Retail Sale Id 541',4998.40,0.00,0.00,8.80,448.80,'2022-03-07 14:06:41','',''),(461,'1','219','1',1,'Retail Sale Id 542',1709.68,0.00,0.00,3.01,153.51,'2022-03-07 14:40:23','',''),(462,'1','219','1',1,'Retail Sale Id 543',5680.00,0.00,0.00,10.00,510.00,'2022-03-07 14:47:21','',''),(463,'1','219','1',1,'Retail Sale Id 544',301.04,0.00,0.00,0.53,27.03,'2022-03-07 14:48:42','',''),(464,'1','219','1',1,'Retail Sale Id 545',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 15:03:42','',''),(465,'1','219','1',1,'Retail Sale Id 546',5100.64,0.00,0.00,8.98,457.98,'2022-03-07 15:29:24','',''),(466,'1','219','1',1,'Retail Sale Id 547',999.68,0.00,0.00,1.76,89.76,'2022-03-07 15:38:30','',''),(467,'1','219','1',1,'Retail Sale Id 548',2840.00,0.00,0.00,5.00,255.00,'2022-03-07 16:45:08','',''),(468,'1','219','1',1,'Retail Sale Id 549',1147.36,0.00,0.00,2.02,103.02,'2022-03-07 16:46:42','',''),(469,'1','219','1',1,'Retail Sale Id 550',21600.00,0.00,0.00,40.00,920.00,'2022-03-07 16:48:28','',''),(470,'1','219','1',1,'Retail Sale Id 551',999.68,0.00,0.00,1.76,89.76,'2022-03-07 16:59:33','',''),(471,'1','219','1',1,'Retail Sale Id 552',1499.52,0.00,0.00,2.64,134.64,'2022-03-07 17:07:50','',''),(472,'1','219','1',1,'Retail Sale Id 553',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 17:13:10','',''),(473,'1','219','1',1,'Retail Sale Id 554',3408.00,0.00,0.00,6.00,306.00,'2022-03-07 17:14:34','',''),(474,'1','219','1',1,'Retail Sale Id 555',3498.88,0.00,0.00,6.16,314.16,'2022-03-07 17:16:02','',''),(475,'1','219','1',1,'Retail Sale Id 556',1499.52,0.00,0.00,2.64,134.64,'2022-03-07 17:18:45','',''),(476,'1','219','1',1,'Retail Sale Id 557',5680.00,0.00,0.00,10.00,510.00,'2022-03-07 17:20:15','',''),(477,'1','219','1',1,'Retail Sale Id 558',3998.72,0.00,0.00,7.04,359.04,'2022-03-07 17:35:49','',''),(478,'1','219','1',1,'Retail Sale Id 558',3998.72,0.00,0.00,7.04,359.04,'2022-03-07 17:35:49','',''),(479,'1','219','1',1,'Retail Sale Id 559',5680.00,0.00,0.00,10.00,510.00,'2022-03-07 17:43:30','',''),(480,'1','219','1',1,'Retail Sale Id 560',3498.88,0.00,0.00,6.16,314.16,'2022-03-07 17:52:44','',''),(481,'1','219','1',1,'Retail Sale Id 561',1709.68,0.00,0.00,3.01,153.51,'2022-03-07 17:55:08','',''),(482,'1','219','1',1,'Retail Sale Id 562',1198.48,0.00,0.00,2.11,107.61,'2022-03-07 18:02:00','',''),(483,'1','219','1',1,'Retail Sale Id 563',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 18:27:53','',''),(484,'1','219','1',1,'Retail Sale Id 564',698.64,0.00,0.00,1.23,62.73,'2022-03-07 18:28:59','',''),(485,'1','219','1',1,'Retail Sale Id 565',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 18:37:06','',''),(486,'1','219','1',1,'Retail Sale Id 566',3498.88,0.00,0.00,6.16,314.16,'2022-03-07 18:54:36','',''),(487,'1','219','1',1,'Retail Sale Id 567',1499.52,0.00,0.00,2.64,134.64,'2022-03-07 18:55:36','',''),(488,'1','219','1',1,'Retail Sale Id 568',3408.00,0.00,0.00,6.00,306.00,'2022-03-07 19:24:11','',''),(489,'1','219','1',1,'Retail Sale Id 569',499.84,0.00,0.00,0.88,44.88,'2022-03-07 19:27:39','',''),(490,'1','219','1',1,'Retail Sale Id 570',2209.52,0.00,0.00,3.89,198.39,'2022-03-07 19:35:47','',''),(491,'1','219','1',1,'Retail Sale Id 571',14200.00,0.00,0.00,25.00,1275.00,'2022-03-08 07:54:33','',''),(492,'1','219','1',1,'Retail Sale Id 572',1198.48,0.00,0.00,2.11,107.61,'2022-03-08 07:57:35','',''),(493,'1','219','1',1,'Retail Sale Id 573',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 08:15:46','',''),(494,'1','219','1',1,'Retail Sale Id 574',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 08:36:50','',''),(495,'1','219','1',1,'Retail Sale Id 575',562.32,0.00,0.00,0.99,50.49,'2022-03-08 08:48:41','',''),(496,'1','219','1',1,'Retail Sale Id 576',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 08:59:12','',''),(497,'1','219','1',1,'Retail Sale Id 577',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 09:16:38','',''),(498,'1','219','1',1,'Retail Sale Id 578',1709.68,0.00,0.00,3.01,153.51,'2022-03-08 09:18:01','',''),(499,'1','219','1',1,'Retail Sale Id 578',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 09:18:01','',''),(500,'1','219','1',1,'Retail Sale Id 579',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 09:23:34','',''),(501,'1','219','1',1,'Retail Sale Id 580',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 09:30:55','',''),(502,'1','219','1',1,'Retail Sale Id 581',602.08,0.00,0.00,1.06,54.06,'2022-03-08 09:59:07','',''),(503,'1','219','1',1,'Retail Sale Id 582',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 10:45:08','',''),(504,'1','219','1',1,'Retail Sale Id 585',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 10:48:59','',''),(505,'1','219','1',1,'Retail Sale Id 585',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 10:48:59','',''),(506,'1','219','1',1,'Retail Sale Id 586',1709.68,0.00,0.00,3.01,153.51,'2022-03-08 10:58:29','',''),(507,'1','219','1',1,'Retail Sale Id 586',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 10:58:29','',''),(508,'1','219','1',1,'Retail Sale Id 587',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 11:11:09','',''),(509,'1','219','1',1,'Retail Sale Id 588',1499.52,0.00,0.00,2.64,134.64,'2022-03-08 11:16:21','',''),(510,'1','219','1',1,'Retail Sale Id 589',2840.00,0.00,0.00,5.00,255.00,'2022-03-08 11:24:26','',''),(511,'1','219','1',1,'Retail Sale Id 590',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 11:38:52','',''),(512,'1','219','1',1,'Retail Sale Id 591',1709.68,0.00,0.00,3.01,153.51,'2022-03-08 11:57:52','',''),(513,'1','219','1',1,'Retail Sale Id 592',5400.00,0.00,0.00,10.00,230.00,'2022-03-08 12:06:43','',''),(514,'1','219','1',1,'Retail Sale Id 593',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 12:14:47','',''),(515,'1','219','1',1,'Retail Sale Id 594',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 12:20:23','',''),(516,'1','219','1',1,'Retail Sale Id 595',499.84,0.00,0.00,0.88,44.88,'2022-03-08 12:29:46','',''),(517,'1','219','1',1,'Retail Sale Id 597',2999.04,0.00,0.00,5.28,269.28,'2022-03-08 12:44:16','',''),(518,'1','219','1',1,'Retail Sale Id 598',1800.56,0.00,0.00,3.17,161.67,'2022-03-08 13:07:38','',''),(519,'1','219','1',1,'Retail Sale Id 599',54000.00,0.00,0.00,100.00,2300.00,'2022-03-08 13:11:46','',''),(520,'1','219','1',1,'Retail Sale Id 600',602.08,0.00,0.00,1.06,54.06,'2022-03-08 13:20:12','',''),(521,'1','219','1',1,'Retail Sale Id 601',999.68,0.00,0.00,1.76,89.76,'2022-03-08 13:23:42','',''),(522,'1','219','1',1,'Retail Sale Id 602',800.88,0.00,0.00,1.41,71.91,'2022-03-08 13:28:50','',''),(523,'1','219','1',1,'Retail Sale Id 603',27000.00,0.00,0.00,50.00,1150.00,'2022-03-08 13:41:14','',''),(524,'1','219','1',1,'Retail Sale Id 604',2840.00,0.00,0.00,5.00,255.00,'2022-03-08 13:59:01','',''),(525,'1','219','1',1,'Retail Sale Id 605',2402.64,0.00,0.00,4.23,215.73,'2022-03-08 14:06:13','',''),(526,'1','219','1',1,'Retail Sale Id 606',800.88,0.00,0.00,1.41,71.91,'2022-03-08 14:08:24','',''),(527,'1','219','1',1,'Retail Sale Id 607',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 14:20:40','',''),(528,'1','219','1',1,'Retail Sale Id 608',1999.36,0.00,0.00,3.52,179.52,'2022-03-08 14:26:56','',''),(529,'1','219','1',1,'Retail Sale Id 609',1709.68,0.00,0.00,3.01,153.51,'2022-03-08 14:56:03','',''),(530,'1','219','1',1,'Retail Sale Id 611',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 15:07:56','',''),(531,'1','219','1',1,'Retail Sale Id 612',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 15:12:03','',''),(532,'1','219','1',1,'Retail Sale Id 613',1709.68,0.00,0.00,3.01,153.51,'2022-03-08 16:19:31','',''),(533,'1','219','1',1,'Retail Sale Id 614',800.88,0.00,0.00,1.41,71.91,'2022-03-08 16:30:00','',''),(534,'1','219','1',1,'Retail Sale Id 616',2851.20,0.00,0.00,5.28,121.44,'2022-03-08 16:50:39','',''),(535,'1','219','1',1,'Retail Sale Id 617',499.84,0.00,0.00,0.88,44.88,'2022-03-08 17:10:25','',''),(536,'1','219','1',1,'Retail Sale Id 618',8520.00,0.00,0.00,15.00,765.00,'2022-03-08 17:18:06','',''),(537,'1','219','1',1,'Retail Sale Id 619',1709.68,0.00,0.00,3.01,153.51,'2022-03-08 17:30:16','',''),(538,'1','219','1',1,'Retail Sale Id 620',1698.32,0.00,0.00,2.99,152.49,'2022-03-08 17:31:59','',''),(539,'1','219','1',1,'Retail Sale Id 621',3998.72,0.00,0.00,7.04,359.04,'2022-03-08 17:33:17','',''),(540,'1','219','1',1,'Retail Sale Id 622',3498.88,0.00,0.00,6.16,314.16,'2022-03-08 17:49:58','',''),(541,'1','219','1',1,'Retail Sale Id 623',499.84,0.00,0.00,0.88,44.88,'2022-03-08 18:17:14','',''),(542,'1','219','1',1,'Retail Sale Id 624',698.64,0.00,0.00,1.23,62.73,'2022-03-08 18:43:04','',''),(543,'1','219','1',1,'Retail Sale Id 625',1709.68,0.00,0.00,3.01,153.51,'2022-03-08 18:49:14','',''),(544,'1','219','1',1,'Retail Sale Id 625',1709.68,0.00,0.00,3.01,153.51,'2022-03-08 18:49:14','',''),(545,'1','219','1',1,'Return of Retail Sale Id 616',0.00,2851.20,5.28,0.00,-121.44,'2022-03-08 20:13:45','',''),(546,'1','219','1',1,'Retail Sale Id 626',2251.80,0.00,0.00,4.17,95.91,'2022-03-08 20:15:43','',''),(547,'1','219','1',1,'Return of Retail Sale Id 621',0.00,3998.72,7.04,0.00,-359.04,'2022-03-08 20:18:48','',''),(548,'1','219','1',1,'Retail Sale Id 627',1607.44,0.00,0.00,2.83,144.33,'2022-03-08 20:20:22','',''),(549,'1','219','1',1,'Return of Retail Sale Id 627',0.00,1607.44,2.83,0.00,-144.33,'2022-03-08 20:21:21','',''),(550,'1','219','1',1,'Retail Sale Id 628',1596.08,0.00,0.00,2.81,143.31,'2022-03-08 20:22:34','',''),(551,'1','219','1',1,'Retail Sale Id 629',2277.68,0.00,0.00,4.01,204.51,'2022-03-08 20:24:04','',''),(552,'1','219','1',1,'Retail Sale Id 630',6816.00,0.00,0.00,12.00,612.00,'2022-03-09 07:54:01','',''),(553,'1','219','1',1,'Retail Sale Id 631',3498.88,0.00,0.00,6.16,314.16,'2022-03-09 08:03:29','',''),(554,'1','219','1',1,'Retail Sale Id 632',1698.32,0.00,0.00,2.99,152.49,'2022-03-09 08:25:19','',''),(555,'1','219','1',1,'Retail Sale Id 635',1698.32,0.00,0.00,2.99,152.49,'2022-03-09 09:13:53','',''),(556,'1','219','1',1,'Retail Sale Id 636',1709.68,0.00,0.00,3.01,153.51,'2022-03-09 09:41:23','',''),(557,'1','219','1',1,'Retail Sale Id 636',2039.12,0.00,0.00,3.59,183.09,'2022-03-09 09:41:23','',''),(558,'1','219','1',1,'Retail Sale Id 637',3498.88,0.00,0.00,6.16,314.16,'2022-03-09 09:57:55','',''),(559,'1','219','1',1,'Retail Sale Id 638',999.68,0.00,0.00,1.76,89.76,'2022-03-09 09:58:45','',''),(560,'1','219','1',1,'Retail Sale Id 639',27000.00,0.00,0.00,50.00,1150.00,'2022-03-09 10:00:06','',''),(561,'1','219','1',1,'Retail Sale Id 640',27000.00,0.00,0.00,50.00,1150.00,'2022-03-09 10:01:14','',''),(562,'1','219','1',1,'Retail Sale Id 641',3408.00,0.00,0.00,6.00,306.00,'2022-03-09 10:15:33','',''),(563,'1','219','1',1,'Retail Sale Id 642',3498.88,0.00,0.00,6.16,314.16,'2022-03-09 10:42:20','',''),(564,'1','219','1',1,'Retail Sale Id 643',3408.00,0.00,0.00,6.00,306.00,'2022-03-09 11:09:14','',''),(565,'1','219','1',1,'Retail Sale Id 644',1999.36,0.00,0.00,3.52,179.52,'2022-03-09 11:38:31','',''),(566,'1','219','1',1,'Retail Sale Id 645',3998.72,0.00,0.00,7.04,359.04,'2022-03-09 11:51:03','',''),(567,'1','219','1',1,'Retail Sale Id 646',1198.48,0.00,0.00,2.11,107.61,'2022-03-09 12:18:11','',''),(568,'1','219','1',1,'Retail Sale Id 647',2840.00,0.00,0.00,5.00,255.00,'2022-03-09 12:28:50','',''),(569,'1','219','1',1,'Retail Sale Id 648',1198.48,0.00,0.00,2.11,107.61,'2022-03-09 12:40:43','',''),(570,'1','219','1',1,'Retail Sale Id 649',7100.00,0.00,0.00,12.50,637.50,'2022-03-09 12:45:48','',''),(571,'1','219','1',1,'Retail Sale Id 650',1499.52,0.00,0.00,2.64,134.64,'2022-03-09 12:57:01','',''),(572,'1','219','1',1,'Retail Sale Id 651',800.88,0.00,0.00,1.41,71.91,'2022-03-09 13:08:32','',''),(573,'1','219','1',1,'Retail Sale Id 652',3408.00,0.00,0.00,6.00,306.00,'2022-03-09 13:23:50','',''),(574,'1','219','1',1,'Retail Sale Id 653',3498.88,0.00,0.00,6.16,314.16,'2022-03-09 13:27:40','',''),(575,'1','219','1',1,'Retail Sale Id 654',5400.00,0.00,0.00,10.00,230.00,'2022-03-09 13:39:33','',''),(576,'1','219','1',1,'Retail Sale Id 655',27000.00,0.00,0.00,50.00,1150.00,'2022-03-09 14:03:50','',''),(577,'1','219','1',1,'Retail Sale Id 657',7100.00,0.00,0.00,12.50,637.50,'2022-03-09 14:23:24','',''),(578,'1','219','1',1,'Retail Sale Id 658',2840.00,0.00,0.00,5.00,255.00,'2022-03-09 15:01:49','',''),(579,'1','219','1',1,'Retail Sale Id 659',499.84,0.00,0.00,0.88,44.88,'2022-03-09 15:34:09','',''),(580,'1','219','1',1,'Retail Sale Id 660',54000.00,0.00,0.00,100.00,2300.00,'2022-03-09 15:51:56','',''),(581,'1','219','1',1,'Retail Sale Id 661',54000.00,0.00,0.00,100.00,2300.00,'2022-03-09 15:57:25','',''),(582,'1','219','1',1,'Retail Sale Id 662',1709.68,0.00,0.00,3.01,153.51,'2022-03-09 16:01:40','',''),(583,'1','219','1',1,'Retail Sale Id 662',1709.68,0.00,0.00,3.01,153.51,'2022-03-09 16:01:40','',''),(584,'1','219','1',1,'Retail Sale Id 662',2300.40,0.00,0.00,4.05,206.55,'2022-03-09 16:01:40','',''),(585,'1','219','1',1,'Retail Sale Id 663',2840.00,0.00,0.00,5.00,255.00,'2022-03-09 16:03:08','',''),(586,'1','219','1',1,'Retail Sale Id 664',3408.00,0.00,0.00,6.00,306.00,'2022-03-09 16:18:28','',''),(587,'1','219','1',1,'Retail Sale Id 665',3408.00,0.00,0.00,6.00,306.00,'2022-03-09 16:29:06','',''),(588,'1','219','1',1,'Retail Sale Id 666',2999.04,0.00,0.00,5.28,269.28,'2022-03-09 16:37:04','',''),(589,'1','219','1',1,'Retail Sale Id 667',1499.52,0.00,0.00,2.64,134.64,'2022-03-09 16:42:44','',''),(590,'1','219','1',1,'Retail Sale Id 668',27000.00,0.00,0.00,50.00,1150.00,'2022-03-09 16:55:11','',''),(591,'1','219','1',1,'Retail Sale Id 669',27000.00,0.00,0.00,50.00,1150.00,'2022-03-09 16:56:52','',''),(592,'1','219','1',1,'Retail Sale Id 670',27000.00,0.00,0.00,50.00,1150.00,'2022-03-09 17:02:45','',''),(593,'1','219','1',1,'Retail Sale Id 671',27000.00,0.00,0.00,50.00,1150.00,'2022-03-09 17:04:05','',''),(594,'1','219','1',1,'Retail Sale Id 673',27000.00,0.00,0.00,50.00,1150.00,'2022-03-09 17:09:42','',''),(595,'1','219','1',1,'Retail Sale Id 674',27000.00,0.00,0.00,50.00,1150.00,'2022-03-09 17:11:13','',''),(596,'1','219','1',1,'Retail Sale Id 675',3402.32,0.00,0.00,5.99,305.49,'2022-03-09 17:20:38','',''),(597,'1','219','1',1,'Retail Sale Id 676',999.68,0.00,0.00,1.76,89.76,'2022-03-09 17:27:38','',''),(598,'1','219','1',1,'Retail Sale Id 677',7100.00,0.00,0.00,12.50,637.50,'2022-03-09 17:40:02','',''),(599,'1','219','1',1,'Retail Sale Id 678',1147.36,0.00,0.00,2.02,103.02,'2022-03-09 17:48:55','',''),(600,'1','219','1',1,'Retail Sale Id 679',3498.88,0.00,0.00,6.16,314.16,'2022-03-09 18:13:16','',''),(601,'1','219','1',1,'Retail Sale Id 680',698.64,0.00,0.00,1.23,62.73,'2022-03-09 18:16:03','',''),(602,'1','219','1',1,'Retail Sale Id 681',1147.36,0.00,0.00,2.02,103.02,'2022-03-09 18:40:17','',''),(603,'1','219','1',1,'Retail Sale Id 682',3408.00,0.00,0.00,6.00,306.00,'2022-03-09 18:41:30','',''),(604,'1','219','1',1,'Retail Sale Id 683',2499.20,0.00,0.00,4.40,224.40,'2022-03-10 10:00:39','',''),(605,'1','219','1',1,'Retail Sale Id 684',1147.36,0.00,0.00,2.02,103.02,'2022-03-10 10:36:25','',''),(606,'1','219','1',1,'Retail Sale Id 685',3402.32,0.00,0.00,5.99,305.49,'2022-03-10 10:51:03','',''),(607,'1','219','1',1,'Retail Sale Id 686',999.68,0.00,0.00,1.76,89.76,'2022-03-10 10:59:59','',''),(608,'1','219','1',1,'Retail Sale Id 687',1704.00,0.00,0.00,3.00,153.00,'2022-03-10 11:14:48','',''),(609,'1','219','1',1,'Retail Sale Id 689',999.68,0.00,0.00,1.76,89.76,'2022-03-10 11:45:18','',''),(610,'1','219','1',1,'Retail Sale Id 690',2499.20,0.00,0.00,4.40,224.40,'2022-03-10 11:49:15','',''),(611,'1','219','1',1,'Retail Sale Id 691',3498.88,0.00,0.00,6.16,314.16,'2022-03-10 12:29:14','',''),(612,'1','219','1',1,'Retail Sale Id 692',3498.88,0.00,0.00,6.16,314.16,'2022-03-10 12:30:07','',''),(613,'1','219','1',1,'Retail Sale Id 693',5680.00,0.00,0.00,10.00,510.00,'2022-03-10 12:31:09','',''),(614,'1','219','1',1,'Retail Sale Id 694',800.88,0.00,0.00,1.41,71.91,'2022-03-10 13:30:49','',''),(615,'1','219','1',1,'Retail Sale Id 695',2499.20,0.00,0.00,4.40,224.40,'2022-03-10 14:08:51','',''),(616,'1','219','1',1,'Retail Sale Id 696',2402.64,0.00,0.00,4.23,215.73,'2022-03-10 14:13:49','',''),(617,'1','219','1',1,'Retail Sale Id 697',270000.00,0.00,0.00,500.00,11500.00,'2022-03-10 14:33:16','',''),(618,'1','219','1',1,'Retail Sale Id 698',35958.60,0.00,0.00,66.59,1531.57,'2022-03-10 15:12:14','',''),(619,'1','219','1',1,'Return of Retail Sale Id 697',0.00,270000.00,500.00,0.00,-11500.00,'2022-03-10 15:14:28','',''),(620,'1','219','1',1,'Retail Sale Id 699',131220.00,0.00,0.00,243.00,5589.00,'2022-03-10 15:16:09','',''),(621,'1','219','1',1,'Retail Sale Id 700',138780.00,0.00,0.00,257.00,5911.00,'2022-03-10 15:17:29','',''),(622,'1','219','1',1,'Distributed to OPERATIONAL LOST for sales id:1',0.00,0.00,0.00,0.00,0.00,'2022-03-10 21:18:10','',''),(623,'1','219','1',1,'Distributed to OPERATIONAL LOST for sales id:1',0.00,0.00,0.00,0.00,0.00,'2022-03-10 21:22:12','',''),(624,'1','219','1',1,'Distributed to OPERATIONAL LOST for sales id:2',79731.74,0.00,0.00,154.22,0.00,'2022-03-10 21:31:36','',''),(625,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,3108773.00,5899.00,0.00,0.00,'2022-03-10 22:16:23','',''),(626,'1','219',NULL,1,'Returned purchase #2 to AA RANO NIG. LTD',3108773.00,0.00,0.00,5899.00,0.00,'2022-03-10 22:34:11','',''),(627,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,3108773.00,5899.00,0.00,0.00,'2022-03-11 07:09:16','',''),(628,'1','219',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,5899.00,0.00,'2022-03-11 07:11:07','',''),(629,'1','219','1',1,'Received from bridging 2',0.00,0.00,5899.00,0.00,0.00,'2022-03-11 07:11:07','',''),(630,'1','219','1',1,'Retail Sale Id 701',27000.00,0.00,0.00,50.00,650.00,'2022-03-11 07:47:58','',''),(631,'1','219','1',1,'Retail Sale Id 702',28400.00,0.00,0.00,50.00,2050.00,'2022-03-11 07:50:05','',''),(632,'1','219','1',1,'Retail Sale Id 703',56800.00,0.00,0.00,100.00,4100.00,'2022-03-11 07:51:26','',''),(633,'1','219','1',1,'Retail Sale Id 704',57780.00,0.00,0.00,107.00,1391.00,'2022-03-11 08:19:34','',''),(634,'1','219','1',1,'Retail Sale Id 705',3408.00,0.00,0.00,6.00,246.00,'2022-03-11 08:30:38','',''),(635,'1','219','1',1,'Retail Sale Id 706',2840.00,0.00,0.00,5.00,205.00,'2022-03-11 09:15:30','',''),(636,'1','219','1',1,'Retail Sale Id 707',3408.00,0.00,0.00,6.00,246.00,'2022-03-11 09:17:47','',''),(637,'1','219','1',1,'Retail Sale Id 708',1198.48,0.00,0.00,2.11,86.51,'2022-03-11 09:19:39','',''),(638,'1','219','1',1,'Retail Sale Id 709',602.08,0.00,0.00,1.06,43.46,'2022-03-11 09:23:01','',''),(639,'1','219','1',1,'Retail Sale Id 710',1999.36,0.00,0.00,3.52,144.32,'2022-03-11 09:24:23','',''),(640,'1','219','1',1,'Retail Sale Id 711',5680.00,0.00,0.00,10.00,410.00,'2022-03-11 09:45:47','',''),(641,'1','219','1',1,'Retail Sale Id 712',135000.00,0.00,0.00,250.00,3250.00,'2022-03-11 09:58:44','',''),(642,'1','219','1',1,'Retail Sale Id 713',135000.00,0.00,0.00,250.00,3250.00,'2022-03-11 10:00:34','',''),(643,'1','219','1',1,'Retail Sale Id 714',2300.40,0.00,0.00,4.05,166.05,'2022-03-11 10:11:42','',''),(644,'1','219','1',1,'Retail Sale Id 714',5680.00,0.00,0.00,10.00,410.00,'2022-03-11 10:11:42','',''),(645,'1','219','1',1,'Retail Sale Id 715',698.64,0.00,0.00,1.23,50.43,'2022-03-11 10:12:57','',''),(646,'1','219','1',1,'Retail Sale Id 716',54000.00,0.00,0.00,100.00,1300.00,'2022-03-11 10:14:16','',''),(647,'1','219','1',1,'Retail Sale Id 717',54000.00,0.00,0.00,100.00,1300.00,'2022-03-11 10:15:45','',''),(648,'1','219','1',1,'Retail Sale Id 718',1999.36,0.00,0.00,3.52,144.32,'2022-03-11 10:55:43','',''),(649,'1','219','1',1,'Retail Sale Id 719',7100.00,0.00,0.00,12.50,512.50,'2022-03-11 11:16:28','',''),(650,'1','219','1',1,'Retail Sale Id 720',499.84,0.00,0.00,0.88,36.08,'2022-03-11 11:29:54','',''),(651,'1','219','1',1,'Retail Sale Id 721',1499.52,0.00,0.00,2.64,108.24,'2022-03-11 11:31:07','',''),(652,'1','219','1',1,'Retail Sale Id 722',2499.20,0.00,0.00,4.40,180.40,'2022-03-11 11:32:05','',''),(653,'1','219','1',1,'Retail Sale Id 723',5197.20,0.00,0.00,9.15,375.15,'2022-03-11 11:34:35','',''),(654,'1','219','1',1,'Retail Sale Id 724',999.68,0.00,0.00,1.76,72.16,'2022-03-11 11:35:45','',''),(655,'1','219','1',1,'Retail Sale Id 725',5680.00,0.00,0.00,10.00,410.00,'2022-03-11 11:37:38','',''),(656,'1','219','1',1,'Retail Sale Id 727',499.84,0.00,0.00,0.88,36.08,'2022-03-11 11:39:11','',''),(657,'1','219','1',1,'Retail Sale Id 729',568.00,0.00,0.00,1.00,41.00,'2022-03-11 11:51:21','',''),(658,'1','219','1',1,'Retail Sale Id 730',6480.00,0.00,0.00,12.00,156.00,'2022-03-11 11:53:12','',''),(659,'1','219','1',1,'Retail Sale Id 731',3408.00,0.00,0.00,6.00,246.00,'2022-03-11 12:03:28','',''),(660,'1','219','1',1,'Retail Sale Id 732',4549.68,0.00,0.00,8.01,328.41,'2022-03-11 12:28:19','',''),(661,'1','219','1',1,'Retail Sale Id 733',162000.00,0.00,0.00,300.00,3900.00,'2022-03-11 13:01:23','',''),(662,'1','219','1',1,'Retail Sale Id 734',162000.00,0.00,0.00,300.00,3900.00,'2022-03-11 13:03:45','',''),(663,'1','219','1',1,'Retail Sale Id 735',2851.36,0.00,0.00,5.02,205.82,'2022-03-11 14:26:35','',''),(664,'1','219','1',1,'Retail Sale Id 736',7100.00,0.00,0.00,12.50,512.50,'2022-03-11 14:31:39','',''),(665,'1','219','1',1,'Retail Sale Id 737',3498.88,0.00,0.00,6.16,252.56,'2022-03-11 14:32:54','',''),(666,'1','219','1',1,'Retail Sale Id 738',27000.00,0.00,0.00,50.00,650.00,'2022-03-11 14:35:15','',''),(667,'1','219','1',1,'Retail Sale Id 739',5680.00,0.00,0.00,10.00,410.00,'2022-03-11 14:43:29','',''),(668,'1','219','1',1,'Retail Sale Id 740',301.04,0.00,0.00,0.53,21.73,'2022-03-11 14:54:53','',''),(669,'1','219','1',1,'Retail Sale Id 741',1499.52,0.00,0.00,2.64,108.24,'2022-03-11 15:04:42','',''),(670,'1','219','1',1,'Retail Sale Id 742',1709.68,0.00,0.00,3.01,123.41,'2022-03-11 15:07:36','',''),(671,'1','219','1',1,'Retail Sale Id 743',162000.00,0.00,0.00,300.00,3900.00,'2022-03-11 15:28:38','',''),(672,'1','219','1',1,'Retail Sale Id 744',243000.00,0.00,0.00,450.00,5850.00,'2022-03-11 15:30:46','',''),(673,'1','219','1',1,'Retail Sale Id 745',3408.00,0.00,0.00,6.00,246.00,'2022-03-11 15:50:18','',''),(674,'1','219','1',1,'Retail Sale Id 746',62100.00,0.00,0.00,115.00,1495.00,'2022-03-11 16:06:18','',''),(675,'1','219','1',1,'Retail Sale Id 747',2840.00,0.00,0.00,5.00,205.00,'2022-03-11 16:18:45','',''),(676,'1','219','1',1,'Retail Sale Id 748',3498.88,0.00,0.00,6.16,252.56,'2022-03-11 16:20:25','',''),(677,'1','219','1',1,'Retail Sale Id 749',81000.00,0.00,0.00,150.00,1950.00,'2022-03-11 16:28:00','',''),(678,'1','219','1',1,'Retail Sale Id 750',3408.00,0.00,0.00,6.00,246.00,'2022-03-11 16:35:10','',''),(679,'1','219','1',1,'Retail Sale Id 751',1800.56,0.00,0.00,3.17,129.97,'2022-03-11 16:43:03','',''),(680,'1','219','1',1,'Retail Sale Id 752',1999.36,0.00,0.00,3.52,144.32,'2022-03-11 16:44:01','',''),(681,'1','219','1',1,'Retail Sale Id 753',7100.00,0.00,0.00,12.50,512.50,'2022-03-11 16:51:59','',''),(682,'1','219','1',1,'Retail Sale Id 754',54000.00,0.00,0.00,100.00,1300.00,'2022-03-11 17:01:18','',''),(683,'1','219','1',1,'Retail Sale Id 755',2840.00,0.00,0.00,5.00,205.00,'2022-03-11 17:08:21','',''),(684,'1','219','1',1,'Retail Sale Id 756',3408.00,0.00,0.00,6.00,246.00,'2022-03-11 17:16:25','',''),(685,'1','219','1',1,'Retail Sale Id 757',2840.00,0.00,0.00,5.00,205.00,'2022-03-11 17:19:09','',''),(686,'1','219','1',1,'Retail Sale Id 758',2499.20,0.00,0.00,4.40,180.40,'2022-03-11 17:21:40','',''),(687,'1','219','1',1,'Retail Sale Id 759',499.84,0.00,0.00,0.88,36.08,'2022-03-11 17:23:16','',''),(688,'1','219','1',1,'Retail Sale Id 760',1999.36,0.00,0.00,3.52,144.32,'2022-03-11 17:30:28','',''),(689,'1','219','1',1,'Retail Sale Id 761',7100.00,0.00,0.00,12.50,512.50,'2022-03-11 17:37:58','',''),(690,'1','219','1',1,'Retail Sale Id 762',301.04,0.00,0.00,0.53,21.73,'2022-03-11 17:59:23','',''),(691,'1','219','1',1,'Retail Sale Id 763',1709.68,0.00,0.00,3.01,123.41,'2022-03-11 18:11:58','',''),(692,'1','219','1',1,'Retail Sale Id 764',397.60,0.00,0.00,0.70,28.70,'2022-03-11 18:23:27','',''),(693,'1','219','1',1,'Retail Sale Id 765',3408.00,0.00,0.00,6.00,246.00,'2022-03-11 18:28:39','',''),(694,'1','219','1',1,'Return of Retail Sale Id 754',0.00,54000.00,100.00,0.00,-1300.00,'2022-03-11 18:41:16','',''),(695,'1','219','1',1,'Retail Sale Id 766',4000.00,0.00,0.00,6.25,706.25,'2022-03-12 09:29:57','',''),(696,'1','219','1',1,'Retail Sale Id 767',2803.20,0.00,0.00,4.38,494.94,'2022-03-12 09:36:07','',''),(697,'1','219','1',1,'Retail Sale Id 768',6200.00,0.00,0.00,10.00,930.00,'2022-03-12 09:38:27','',''),(698,'1','219','1',1,'Retail Sale Id 769',2002.60,0.00,0.00,3.23,300.39,'2022-03-12 09:42:01','',''),(699,'1','219','1',1,'Retail Sale Id 770',3852.80,0.00,0.00,6.02,680.26,'2022-03-12 09:49:40','',''),(700,'1','219','1',1,'Retail Sale Id 771',601.60,0.00,0.00,0.94,106.22,'2022-03-12 09:53:55','',''),(701,'1','219','1',1,'Retail Sale Id 772',6200.00,0.00,0.00,10.00,930.00,'2022-03-12 09:58:23','',''),(702,'1','219','1',1,'Retail Sale Id 773',124000.00,0.00,0.00,200.00,18600.00,'2022-03-12 10:06:49','',''),(703,'1','219','1',1,'Retail Sale Id 774',124000.00,0.00,0.00,200.00,18600.00,'2022-03-12 10:07:50','',''),(704,'1','219','1',1,'Retail Sale Id 775',2803.20,0.00,0.00,4.38,494.94,'2022-03-12 10:16:58','',''),(705,'1','219','1',1,'Retail Sale Id 776',1299.20,0.00,0.00,2.03,229.39,'2022-03-12 10:19:27','',''),(706,'1','219','1',1,'Retail Sale Id 777',499.20,0.00,0.00,0.78,88.14,'2022-03-12 10:44:20','',''),(707,'1','219','1',1,'Retail Sale Id 778',2003.20,0.00,0.00,3.13,353.69,'2022-03-12 10:49:00','',''),(708,'1','219','1',1,'Retail Sale Id 779',3897.60,0.00,0.00,6.09,688.17,'2022-03-12 11:03:46','',''),(709,'1','219','1',1,'Retail Sale Id 780',3801.60,0.00,0.00,5.94,671.22,'2022-03-12 11:35:35','',''),(710,'1','219','1',1,'Retail Sale Id 781',4000.00,0.00,0.00,6.25,706.25,'2022-03-12 11:39:20','',''),(711,'1','219','1',1,'Retail Sale Id 782',3840.00,0.00,0.00,6.00,678.00,'2022-03-12 11:53:32','',''),(712,'1','219','1',1,'Retail Sale Id 782',3840.00,0.00,0.00,6.00,678.00,'2022-03-12 11:53:32','',''),(713,'1','219','1',1,'Retail Sale Id 783',8000.00,0.00,0.00,12.50,1412.50,'2022-03-12 11:55:08','',''),(714,'1','219','1',1,'Retail Sale Id 784',3897.60,0.00,0.00,6.09,688.17,'2022-03-12 12:01:36','',''),(715,'1','219','1',1,'Retail Sale Id 785',2502.40,0.00,0.00,3.91,441.83,'2022-03-12 12:03:44','',''),(716,'1','219','1',1,'Retail Sale Id 786',998.40,0.00,0.00,1.56,176.28,'2022-03-12 12:14:36','',''),(717,'1','219','1',1,'Retail Sale Id 786',1497.60,0.00,0.00,2.34,264.42,'2022-03-12 12:14:36','',''),(718,'1','219','1',1,'Retail Sale Id 787',3840.00,0.00,0.00,6.00,678.00,'2022-03-12 12:37:07','',''),(719,'1','219','1',1,'Retail Sale Id 788',1299.20,0.00,0.00,2.03,229.39,'2022-03-12 13:09:39','',''),(720,'1','219','1',1,'Retail Sale Id 789',1900.80,0.00,0.00,2.97,335.61,'2022-03-12 13:42:54','',''),(721,'1','219','1',1,'Retail Sale Id 790',1497.60,0.00,0.00,2.34,264.42,'2022-03-12 13:45:59','',''),(722,'1','219','1',1,'Retail Sale Id 791',2003.20,0.00,0.00,3.13,353.69,'2022-03-12 13:55:04','',''),(723,'1','219','1',1,'Retail Sale Id 793',1920.00,0.00,0.00,3.00,339.00,'2022-03-12 14:37:30','',''),(724,'1','219','1',1,'Retail Sale Id 795',1497.60,0.00,0.00,2.34,264.42,'2022-03-12 14:39:15','',''),(725,'1','219','1',1,'Retail Sale Id 796',1920.00,0.00,0.00,3.00,339.00,'2022-03-12 15:05:00','',''),(726,'1','219','1',1,'Retail Sale Id 796',2560.00,0.00,0.00,4.00,452.00,'2022-03-12 15:05:00','',''),(727,'1','219','1',1,'Retail Sale Id 797',8000.00,0.00,0.00,12.50,1412.50,'2022-03-12 15:23:22','',''),(728,'1','219','1',1,'Retail Sale Id 798',2502.40,0.00,0.00,3.91,441.83,'2022-03-12 15:27:09','',''),(729,'1','219','1',1,'Retail Sale Id 799',4403.20,0.00,0.00,6.88,777.44,'2022-03-12 15:49:25','',''),(730,'1','219','1',1,'Retail Sale Id 800',499.20,0.00,0.00,0.78,88.14,'2022-03-12 16:00:36','',''),(731,'1','219','1',1,'Retail Sale Id 801',4403.20,0.00,0.00,6.88,777.44,'2022-03-12 16:02:12','',''),(732,'1','219','1',1,'Retail Sale Id 802',4499.20,0.00,0.00,7.03,794.39,'2022-03-12 16:09:49','',''),(733,'1','219','1',1,'Retail Sale Id 803',800.00,0.00,0.00,1.25,141.25,'2022-03-12 16:34:38','',''),(734,'1','219','1',1,'Retail Sale Id 804',3840.00,0.00,0.00,6.00,678.00,'2022-03-12 16:37:07','',''),(735,'1','219','1',1,'Retail Sale Id 805',998.40,0.00,0.00,1.56,176.28,'2022-03-12 16:41:11','',''),(736,'1','219','1',1,'Retail Sale Id 806',3840.00,0.00,0.00,6.00,678.00,'2022-03-12 17:04:32','',''),(737,'1','219','1',1,'Retail Sale Id 807',1920.00,0.00,0.00,3.00,339.00,'2022-03-12 17:05:56','',''),(738,'1','219','1',1,'Retail Sale Id 808',8000.00,0.00,0.00,12.50,1412.50,'2022-03-12 17:12:36','',''),(739,'1','219','1',1,'Retail Sale Id 809',3840.00,0.00,0.00,6.00,678.00,'2022-03-12 17:21:38','',''),(740,'1','219','1',1,'Retail Sale Id 809',3840.00,0.00,0.00,6.00,678.00,'2022-03-12 17:21:38','',''),(741,'1','219','1',1,'Retail Sale Id 810',3852.80,0.00,0.00,6.02,680.26,'2022-03-12 17:34:44','',''),(742,'1','219','1',1,'Retail Sale Id 811',3001.60,0.00,0.00,4.69,529.97,'2022-03-12 17:46:05','',''),(743,'1','219','1',1,'Retail Sale Id 812',403.20,0.00,0.00,0.63,71.19,'2022-03-12 18:08:59','',''),(744,'1','219','1',1,'Retail Sale Id 813',1900.80,0.00,0.00,2.97,335.61,'2022-03-12 18:36:38','',''),(745,'1','219','1',1,'Return of Retail Sale Id 808',0.00,8000.00,12.50,0.00,-1412.50,'2022-03-12 23:03:57','',''),(746,'1','219','1',1,'Retail Sale Id 814',8064.00,0.00,0.00,12.60,1423.80,'2022-03-12 23:04:47','',''),(747,'1','219','1',1,'Return of Retail Sale Id 805',0.00,998.40,1.56,0.00,-176.28,'2022-03-12 23:07:17','',''),(748,'1','219','1',1,'Retail Sale Id 815',992.00,0.00,0.00,1.55,175.15,'2022-03-12 23:07:57','',''),(749,'1','219','1',1,'Return of Retail Sale Id 774',0.00,124000.00,200.00,0.00,-18600.00,'2022-03-12 23:10:38','',''),(750,'1','219','1',1,'Retail Sale Id 816',89292.40,0.00,0.00,144.02,13393.86,'2022-03-12 23:11:49','',''),(751,'1','219','1',1,'Retail Sale Id 817',34348.00,0.00,0.00,55.40,5152.20,'2022-03-12 23:15:15','',''),(752,'1','219','1',1,'Retail Sale Id 818',3200.00,0.00,0.00,5.00,565.00,'2022-03-13 07:52:58','',''),(753,'1','219','1',1,'Retail Sale Id 819',2003.20,0.00,0.00,3.13,353.69,'2022-03-13 08:19:55','',''),(754,'1','219','1',1,'Retail Sale Id 820',6400.00,0.00,0.00,10.00,1130.00,'2022-03-13 09:17:10','',''),(755,'1','219','1',1,'Retail Sale Id 820',8000.00,0.00,0.00,12.50,1412.50,'2022-03-13 09:17:10','',''),(756,'1','219','1',1,'Retail Sale Id 821',1920.00,0.00,0.00,3.00,339.00,'2022-03-13 09:32:24','',''),(757,'1','219','1',1,'Retail Sale Id 822',31000.00,0.00,0.00,50.00,4650.00,'2022-03-13 09:41:50','',''),(758,'1','219','1',1,'Retail Sale Id 823',31000.00,0.00,0.00,50.00,4650.00,'2022-03-13 09:43:08','',''),(759,'1','219','1',1,'Retail Sale Id 824',1920.00,0.00,0.00,3.00,339.00,'2022-03-13 09:49:59','',''),(760,'1','219','1',1,'Retail Sale Id 824',3200.00,0.00,0.00,5.00,565.00,'2022-03-13 09:49:59','',''),(761,'1','219','1',1,'Retail Sale Id 825',998.40,0.00,0.00,1.56,176.28,'2022-03-13 10:03:07','',''),(762,'1','219','1',1,'Retail Sale Id 826',2003.20,0.00,0.00,3.13,353.69,'2022-03-13 10:19:16','',''),(763,'1','219','1',1,'Retail Sale Id 827',2003.20,0.00,0.00,3.13,353.69,'2022-03-13 10:23:01','',''),(764,'1','219','1',1,'Retail Sale Id 828',1497.60,0.00,0.00,2.34,264.42,'2022-03-13 10:23:59','',''),(765,'1','219','1',1,'Retail Sale Id 829',8000.00,0.00,0.00,12.50,1412.50,'2022-03-13 10:31:31','',''),(766,'1','219','1',1,'Retail Sale Id 830',3001.60,0.00,0.00,4.69,529.97,'2022-03-13 10:39:23','',''),(767,'1','219','1',1,'Retail Sale Id 831',3852.80,0.00,0.00,6.02,680.26,'2022-03-13 11:03:39','',''),(768,'1','219','1',1,'Retail Sale Id 832',62000.00,0.00,0.00,100.00,9300.00,'2022-03-13 11:35:07','',''),(769,'1','219','1',1,'Retail Sale Id 833',38750.00,0.00,0.00,62.50,5812.50,'2022-03-13 11:36:46','',''),(770,'1','219','1',1,'Retail Sale Id 834',6200.00,0.00,0.00,10.00,930.00,'2022-03-13 11:47:15','',''),(771,'1','219','1',1,'Retail Sale Id 835',2502.40,0.00,0.00,3.91,441.83,'2022-03-13 11:55:42','',''),(772,'1','219','1',1,'Retail Sale Id 836',7500.80,0.00,0.00,11.72,1324.36,'2022-03-13 12:13:26','',''),(773,'1','219','1',1,'Retail Sale Id 837',8000.00,0.00,0.00,12.50,1412.50,'2022-03-13 12:22:41','',''),(774,'1','219','1',1,'Retail Sale Id 838',1932.80,0.00,0.00,3.02,341.26,'2022-03-13 12:42:15','',''),(775,'1','219','1',1,'Retail Sale Id 839',1299.20,0.00,0.00,2.03,229.39,'2022-03-13 12:45:45','',''),(776,'1','219','1',1,'Retail Sale Id 840',31000.00,0.00,0.00,50.00,4650.00,'2022-03-13 13:03:47','',''),(777,'1','219','1',1,'Retail Sale Id 841',3720.00,0.00,0.00,6.00,558.00,'2022-03-13 13:10:37','',''),(778,'1','219','1',1,'Retail Sale Id 842',3001.60,0.00,0.00,4.69,529.97,'2022-03-13 13:15:39','',''),(779,'1','219','1',1,'Retail Sale Id 843',1920.00,0.00,0.00,3.00,339.00,'2022-03-13 13:19:01','',''),(780,'1','219','1',1,'Retail Sale Id 844',186000.00,0.00,0.00,300.00,27900.00,'2022-03-13 13:32:52','',''),(781,'1','219','1',1,'Retail Sale Id 845',155000.00,0.00,0.00,250.00,23250.00,'2022-03-13 13:34:42','',''),(782,'1','219','1',1,'Retail Sale Id 846',3500.80,0.00,0.00,5.47,618.11,'2022-03-13 13:53:56','',''),(783,'1','219','1',1,'Retail Sale Id 847',3840.00,0.00,0.00,6.00,678.00,'2022-03-13 14:17:41','',''),(784,'1','219','1',1,'Retail Sale Id 848',3200.00,0.00,0.00,5.00,565.00,'2022-03-13 14:26:20','',''),(785,'1','219','1',1,'Retail Sale Id 849',998.40,0.00,0.00,1.56,176.28,'2022-03-13 14:34:50','',''),(786,'1','219','1',1,'Retail Sale Id 850',2003.20,0.00,0.00,3.13,353.69,'2022-03-13 14:35:58','',''),(787,'1','219','1',1,'Retail Sale Id 851',31000.00,0.00,0.00,50.00,4650.00,'2022-03-13 14:43:27','',''),(788,'1','219','1',1,'Retail Sale Id 852',9600.00,0.00,0.00,15.00,1695.00,'2022-03-13 15:23:05','',''),(789,'1','219','1',1,'Retail Sale Id 853',1497.60,0.00,0.00,2.34,264.42,'2022-03-13 15:29:16','',''),(790,'1','219','1',1,'Retail Sale Id 854',1203.20,0.00,0.00,1.88,212.44,'2022-03-13 15:31:10','',''),(791,'1','219','1',1,'Retail Sale Id 855',652.80,0.00,0.00,1.02,115.26,'2022-03-13 15:55:41','',''),(792,'1','219','1',1,'Retail Sale Id 856',1900.80,0.00,0.00,2.97,335.61,'2022-03-13 16:14:34','',''),(793,'1','219','1',1,'Retail Sale Id 857',6400.00,0.00,0.00,10.00,1130.00,'2022-03-13 16:38:00','',''),(794,'1','219','1',1,'Retail Sale Id 858',800.00,0.00,0.00,1.25,141.25,'2022-03-13 16:50:57','',''),(795,'1','219','1',1,'Retail Sale Id 859',1920.00,0.00,0.00,3.00,339.00,'2022-03-13 16:56:36','',''),(796,'1','219','1',1,'Retail Sale Id 860',3500.80,0.00,0.00,5.47,618.11,'2022-03-13 17:01:36','',''),(797,'1','219','1',1,'Retail Sale Id 861',697.60,0.00,0.00,1.09,123.17,'2022-03-13 17:04:28','',''),(798,'1','219','1',1,'Retail Sale Id 862',3200.00,0.00,0.00,5.00,565.00,'2022-03-13 17:05:41','',''),(799,'1','219','1',1,'Retail Sale Id 863',1920.00,0.00,0.00,3.00,339.00,'2022-03-13 17:07:29','',''),(800,'1','219','1',1,'Retail Sale Id 864',1920.00,0.00,0.00,3.00,339.00,'2022-03-13 17:09:06','',''),(801,'1','219','1',1,'Retail Sale Id 865',3840.00,0.00,0.00,6.00,678.00,'2022-03-13 17:45:54','',''),(802,'1','219','1',1,'Retail Sale Id 866',1497.60,0.00,0.00,2.34,264.42,'2022-03-13 17:51:25','',''),(803,'1','219','1',1,'Retail Sale Id 868',7097.60,0.00,0.00,11.09,1253.17,'2022-03-13 17:54:57','',''),(804,'1','219','1',1,'Retail Sale Id 869',640.00,0.00,0.00,1.00,113.00,'2022-03-13 17:57:46','',''),(805,'1','219','1',1,'Retail Sale Id 870',499.20,0.00,0.00,0.78,88.14,'2022-03-13 18:07:04','',''),(806,'1','219','1',1,'Retail Sale Id 871',1932.80,0.00,0.00,3.02,341.26,'2022-03-13 18:18:17','',''),(807,'1','219','1',1,'Retail Sale Id 872',3200.00,0.00,0.00,5.00,565.00,'2022-03-13 18:20:34','',''),(808,'1','219','1',1,'Retail Sale Id 873',2502.40,0.00,0.00,3.91,441.83,'2022-03-13 18:27:21','',''),(809,'1','219','1',1,'Retail Sale Id 874',8000.00,0.00,0.00,12.50,1412.50,'2022-03-13 18:32:56','',''),(810,'1','219','1',1,'Retail Sale Id 875',569.60,0.00,0.00,0.89,100.57,'2022-03-13 18:37:50','',''),(811,'1','219','1',1,'Retail Sale Id 876',499.20,0.00,0.00,0.78,88.14,'2022-03-13 18:46:34','',''),(812,'1','219','1',1,'Retail Sale Id 877',1203.20,0.00,0.00,1.88,212.44,'2022-03-13 18:54:46','',''),(813,'1','219','1',1,'Retail Sale Id 878',4960.00,0.00,0.00,8.00,744.00,'2022-03-13 19:14:48','',''),(814,'1','219','1',1,'Retail Sale Id 879',1860.00,0.00,0.00,3.00,279.00,'2022-03-13 19:15:47','',''),(815,'1','219','1',1,'Retail Sale Id 880',1920.00,0.00,0.00,3.00,339.00,'2022-03-14 08:23:32','',''),(816,'1','219','1',1,'Retail Sale Id 881',2182.40,0.00,0.00,3.41,385.33,'2022-03-14 08:32:55','',''),(817,'1','219','1',1,'Retail Sale Id 882',3897.60,0.00,0.00,6.09,688.17,'2022-03-14 09:16:36','',''),(818,'1','219','1',1,'Retail Sale Id 890',15500.00,0.00,0.00,25.00,2325.00,'2022-03-14 11:25:02','',''),(819,'1','219','1',1,'Retail Sale Id 891',1798.40,0.00,0.00,2.81,317.53,'2022-03-14 11:31:09','',''),(820,'1','219','1',1,'Retail Sale Id 892',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 11:34:44','',''),(821,'1','219','1',1,'Retail Sale Id 893',31000.00,0.00,0.00,50.00,4650.00,'2022-03-14 11:38:07','',''),(822,'1','219','1',1,'Retail Sale Id 894',31000.00,0.00,0.00,50.00,4650.00,'2022-03-14 11:49:36','',''),(823,'1','219','1',1,'Retail Sale Id 896',2003.20,0.00,0.00,3.13,353.69,'2022-03-14 11:59:42','',''),(824,'1','219','1',1,'Retail Sale Id 897',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 12:01:55','',''),(825,'1','219','1',1,'Retail Sale Id 898',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 12:04:09','',''),(826,'1','219','1',1,'Retail Sale Id 899',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 12:05:39','',''),(827,'1','219','1',1,'Retail Sale Id 900',3200.00,0.00,0.00,5.00,565.00,'2022-03-14 12:06:41','',''),(828,'1','219','1',1,'Retail Sale Id 901',2003.20,0.00,0.00,3.13,353.69,'2022-03-14 12:08:04','',''),(829,'1','219','1',1,'Retail Sale Id 902',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 12:09:24','',''),(830,'1','219','1',1,'Retail Sale Id 903',1702.40,0.00,0.00,2.66,300.58,'2022-03-14 12:10:29','',''),(831,'1','219','1',1,'Retail Sale Id 904',1497.60,0.00,0.00,2.34,264.42,'2022-03-14 12:21:57','',''),(832,'1','219','1',1,'Retail Sale Id 905',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 12:23:13','',''),(833,'1','219','1',1,'Retail Sale Id 906',998.40,0.00,0.00,1.56,176.28,'2022-03-14 12:24:24','',''),(834,'1','219','1',1,'Retail Sale Id 909',8000.00,0.00,0.00,12.50,1412.50,'2022-03-14 13:00:25','',''),(835,'1','219','1',1,'Retail Sale Id 910',40300.00,0.00,0.00,65.00,6045.00,'2022-03-14 14:51:15','',''),(836,'1','219','1',1,'Retail Sale Id 911',3200.00,0.00,0.00,5.00,565.00,'2022-03-14 14:55:01','',''),(837,'1','219','1',1,'Retail Sale Id 912',8000.00,0.00,0.00,12.50,1412.50,'2022-03-14 15:05:54','',''),(838,'1','219','1',1,'Retail Sale Id 913',8000.00,0.00,0.00,12.50,1412.50,'2022-03-14 15:08:33','',''),(839,'1','219','1',1,'Retail Sale Id 914',38440.00,0.00,0.00,62.00,5766.00,'2022-03-14 15:12:59','',''),(840,'1','219','1',1,'Retail Sale Id 916',3500.80,0.00,0.00,5.47,618.11,'2022-03-14 15:18:14','',''),(841,'1','219','1',1,'Retail Sale Id 917',800.00,0.00,0.00,1.25,141.25,'2022-03-14 15:19:34','',''),(842,'1','219','1',1,'Retail Sale Id 918',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 15:20:59','',''),(843,'1','219','1',1,'Retail Sale Id 919',499.20,0.00,0.00,0.78,88.14,'2022-03-14 15:45:27','',''),(844,'1','219','1',1,'Retail Sale Id 920',7440.00,0.00,0.00,12.00,1116.00,'2022-03-14 16:18:08','',''),(845,'1','219','1',1,'Retail Sale Id 921',998.40,0.00,0.00,1.56,176.28,'2022-03-14 16:23:06','',''),(846,'1','219','1',1,'Retail Sale Id 922',6003.20,0.00,0.00,9.38,1059.94,'2022-03-14 16:27:58','',''),(847,'1','219','1',1,'Retail Sale Id 924',2003.20,0.00,0.00,3.13,353.69,'2022-03-14 16:33:17','',''),(848,'1','219','1',1,'Retail Sale Id 924',2003.20,0.00,0.00,3.13,353.69,'2022-03-14 16:33:17','',''),(849,'1','219','1',1,'Retail Sale Id 925',1920.00,0.00,0.00,3.00,339.00,'2022-03-14 16:36:12','',''),(850,'1','219','1',1,'Retail Sale Id 925',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 16:36:12','',''),(851,'1','219','1',1,'Retail Sale Id 926',3500.80,0.00,0.00,5.47,618.11,'2022-03-14 16:37:55','',''),(852,'1','219','1',1,'Retail Sale Id 927',300.80,0.00,0.00,0.47,53.11,'2022-03-14 16:39:49','',''),(853,'1','219','1',1,'Retail Sale Id 928',1920.00,0.00,0.00,3.00,339.00,'2022-03-14 16:46:49','',''),(854,'1','219','1',1,'Retail Sale Id 929',2003.20,0.00,0.00,3.13,353.69,'2022-03-14 17:01:48','',''),(855,'1','219','1',1,'Retail Sale Id 930',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 17:10:10','',''),(856,'1','219','1',1,'Retail Sale Id 931',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 17:11:22','',''),(857,'1','219','1',1,'Retail Sale Id 932',3001.60,0.00,0.00,4.69,529.97,'2022-03-14 17:12:23','',''),(858,'1','219','1',1,'Retail Sale Id 933',6003.20,0.00,0.00,9.38,1059.94,'2022-03-14 17:15:35','',''),(859,'1','219','1',1,'Retail Sale Id 934',1920.00,0.00,0.00,3.00,339.00,'2022-03-14 17:17:10','',''),(860,'1','219','1',1,'Retail Sale Id 935',2560.00,0.00,0.00,4.00,452.00,'2022-03-14 17:18:45','',''),(861,'1','219','1',1,'Retail Sale Id 936',998.40,0.00,0.00,1.56,176.28,'2022-03-14 17:21:58','',''),(862,'1','219','1',1,'Retail Sale Id 937',3840.00,0.00,0.00,6.00,678.00,'2022-03-14 17:45:23','',''),(863,'1','219','1',1,'Retail Sale Id 938',1497.60,0.00,0.00,2.34,264.42,'2022-03-14 17:53:51','',''),(864,'1','219','1',1,'Retail Sale Id 938',1497.60,0.00,0.00,2.34,264.42,'2022-03-14 17:53:51','',''),(865,'1','219','1',1,'Retail Sale Id 939',1600.00,0.00,0.00,2.50,282.50,'2022-03-14 18:02:47','',''),(866,'1','219','1',1,'Retail Sale Id 940',499.20,0.00,0.00,0.78,88.14,'2022-03-14 18:08:53','',''),(867,'1','219','1',1,'Retail Sale Id 940',697.60,0.00,0.00,1.09,123.17,'2022-03-14 18:08:53','',''),(868,'1','219','1',1,'Retail Sale Id 941',6003.20,0.00,0.00,9.38,1059.94,'2022-03-14 18:10:59','',''),(869,'1','219','1',1,'Retail Sale Id 942',499.20,0.00,0.00,0.78,88.14,'2022-03-14 18:16:10','',''),(870,'1','219','1',1,'Retail Sale Id 943',4537.60,0.00,0.00,7.09,801.17,'2022-03-14 19:53:45','',''),(871,'1','219','1',1,'Retail Sale Id 945',503.20,0.00,0.00,0.74,113.22,'2022-03-15 08:31:14','',''),(872,'1','219','1',1,'Retail Sale Id 946',999.60,0.00,0.00,1.47,224.91,'2022-03-15 08:37:48','',''),(873,'1','219','1',1,'Retail Sale Id 947',2040.00,0.00,0.00,3.00,459.00,'2022-03-15 09:30:22','',''),(874,'1','219','1',1,'Retail Sale Id 948',4080.00,0.00,0.00,6.00,918.00,'2022-03-15 09:31:33','',''),(875,'1','219','1',1,'Retail Sale Id 949',700.40,0.00,0.00,1.03,157.59,'2022-03-15 09:39:40','',''),(876,'1','219','1',1,'Retail Sale Id 950',6800.00,0.00,0.00,10.00,1530.00,'2022-03-15 09:56:45','',''),(877,'1','219','1',1,'Retail Sale Id 952',1999.20,0.00,0.00,2.94,449.82,'2022-03-15 10:13:41','',''),(878,'1','219','1',1,'Retail Sale Id 953',1999.20,0.00,0.00,2.94,449.82,'2022-03-15 10:19:06','',''),(879,'1','219','1',1,'Retail Sale Id 955',1999.20,0.00,0.00,2.94,449.82,'2022-03-15 10:50:27','',''),(880,'1','219','1',1,'Retail Sale Id 956',2998.80,0.00,0.00,4.41,674.73,'2022-03-15 10:55:28','',''),(881,'1','219','1',1,'Retail Sale Id 957',4080.00,0.00,0.00,6.00,918.00,'2022-03-15 10:59:16','',''),(882,'1','219','1',1,'Retail Sale Id 958',2040.00,0.00,0.00,3.00,459.00,'2022-03-15 11:01:37','',''),(883,'1','219','1',1,'Retail Sale Id 959',2998.80,0.00,0.00,4.41,674.73,'2022-03-15 11:07:48','',''),(884,'1','219','1',1,'Retail Sale Id 960',1999.20,0.00,0.00,2.94,449.82,'2022-03-15 11:19:24','',''),(885,'1','219','1',1,'Retail Sale Id 961',4080.00,0.00,0.00,6.00,918.00,'2022-03-15 11:21:18','',''),(886,'1','219','1',1,'Retail Sale Id 962',1999.20,0.00,0.00,2.94,449.82,'2022-03-15 11:49:40','',''),(887,'1','219','1',1,'Retail Sale Id 963',1999.20,0.00,0.00,2.94,449.82,'2022-03-15 12:07:57','',''),(888,'1','219','1',1,'Retail Sale Id 964',802.40,0.00,0.00,1.18,180.54,'2022-03-15 12:12:15','',''),(889,'1','219','1',1,'Retail Sale Id 965',3502.00,0.00,0.00,5.15,787.95,'2022-03-15 12:26:33','',''),(890,'1','219','1',1,'Retail Sale Id 966',4080.00,0.00,0.00,6.00,918.00,'2022-03-15 12:49:41','',''),(891,'1','219','1',1,'Retail Sale Id 967',2998.80,0.00,0.00,4.41,674.73,'2022-03-15 14:08:32','',''),(892,'1','219','1',1,'Retail Sale Id 967',2998.80,0.00,0.00,4.41,674.73,'2022-03-15 14:08:32','',''),(893,'1','219','1',1,'Retail Sale Id 968',7996.80,0.00,0.00,11.76,1799.28,'2022-03-15 14:26:37','',''),(894,'1','219','1',1,'Retail Sale Id 969',503.20,0.00,0.00,0.74,113.22,'2022-03-15 14:30:38','',''),(895,'1','219','1',1,'Retail Sale Id 970',802.40,0.00,0.00,1.18,180.54,'2022-03-15 14:38:11','',''),(896,'1','219','1',1,'Retail Sale Id 971',2720.00,0.00,0.00,4.00,612.00,'2022-03-15 15:05:48','',''),(897,'1','219','1',1,'Retail Sale Id 972',8500.00,0.00,0.00,12.50,1912.50,'2022-03-15 15:47:53','',''),(898,'1','219','1',1,'Retail Sale Id 973',999.60,0.00,0.00,1.47,224.91,'2022-03-15 15:50:08','',''),(899,'1','219','1',1,'Retail Sale Id 974',4080.00,0.00,0.00,6.00,918.00,'2022-03-15 15:53:56','',''),(900,'1','219','1',1,'Retail Sale Id 975',6800.00,0.00,0.00,10.00,1530.00,'2022-03-15 16:35:30','',''),(901,'1','219','1',1,'Retail Sale Id 976',3400.00,0.00,0.00,5.00,765.00,'2022-03-15 16:37:20','',''),(902,'1','219','1',1,'Retail Sale Id 977',2502.40,0.00,0.00,3.68,563.04,'2022-03-15 17:09:17','',''),(903,'1','219','1',1,'Retail Sale Id 978',1360.00,0.00,0.00,2.00,306.00,'2022-03-15 17:12:41','',''),(904,'1','219','1',1,'Retail Sale Id 979',680.00,0.00,0.00,1.00,153.00,'2022-03-15 17:14:19','',''),(905,'1','219','1',1,'Retail Sale Id 980',999.60,0.00,0.00,1.47,224.91,'2022-03-15 17:15:43','',''),(906,'1','219','1',1,'Retail Sale Id 981',4080.00,0.00,0.00,6.00,918.00,'2022-03-15 17:36:26','',''),(907,'1','219','1',1,'Retail Sale Id 982',3699.20,0.00,0.00,5.44,832.32,'2022-03-15 17:38:19','',''),(908,'1','219','1',1,'Retail Sale Id 983',1999.20,0.00,0.00,2.94,449.82,'2022-03-15 17:39:13','',''),(909,'1','219','1',1,'Retail Sale Id 985',503.20,0.00,0.00,0.74,113.22,'2022-03-15 18:33:39','',''),(910,'1','219','1',1,'Retail Sale Id 986',503.20,0.00,0.00,0.74,113.22,'2022-03-15 18:34:35','',''),(911,'1','219','1',1,'Retail Sale Id 987',1298.80,0.00,0.00,1.91,292.23,'2022-03-15 18:35:33','',''),(912,'1','219','1',1,'Retail Sale Id 988',1196.80,0.00,0.00,1.76,269.28,'2022-03-15 18:43:56','',''),(913,'1','219','1',1,'Retail Sale Id 989',299.20,0.00,0.00,0.44,67.32,'2022-03-15 18:48:41','',''),(914,'1','219','1',1,'Retail Sale Id 990',2998.80,0.00,0.00,4.41,674.73,'2022-03-16 09:45:59','',''),(915,'1','219','1',1,'Retail Sale Id 991',3400.00,0.00,0.00,5.00,765.00,'2022-03-16 09:47:31','',''),(916,'1','219','1',1,'Retail Sale Id 992',999.60,0.00,0.00,1.47,224.91,'2022-03-16 09:48:33','',''),(917,'1','219','1',1,'Retail Sale Id 993',4080.00,0.00,0.00,6.00,918.00,'2022-03-16 09:49:31','',''),(918,'1','219','1',1,'Retail Sale Id 994',8500.00,0.00,0.00,12.50,1912.50,'2022-03-16 09:52:59','',''),(919,'1','219','1',1,'Retail Sale Id 995',3840.00,0.00,0.00,6.00,678.00,'2022-03-16 09:56:51','',''),(920,'1','219','1',1,'Retail Sale Id 997',1502.80,0.00,0.00,2.21,338.13,'2022-03-16 10:36:36','',''),(921,'1','219','1',1,'Retail Sale Id 998',3400.00,0.00,0.00,5.00,765.00,'2022-03-16 10:38:49','',''),(922,'1','219','1',1,'Retail Sale Id 999',6800.00,0.00,0.00,10.00,1530.00,'2022-03-16 10:50:54','',''),(923,'1','219','1',1,'Retail Sale Id 1000',1196.80,0.00,0.00,1.76,269.28,'2022-03-16 10:52:18','',''),(924,'1','219','1',1,'Retail Sale Id 1001',3001.60,0.00,0.00,4.69,529.97,'2022-03-16 11:05:32','',''),(925,'1','219','1',1,'Retail Sale Id 1002',4080.00,0.00,0.00,6.00,918.00,'2022-03-16 11:11:36','',''),(926,'1','219','1',1,'Retail Sale Id 1003',3998.40,0.00,0.00,5.88,899.64,'2022-03-16 11:16:51','',''),(927,'1','219','1',1,'Retail Sale Id 1004',8500.00,0.00,0.00,12.50,1912.50,'2022-03-16 11:21:09','',''),(928,'1','219','1',1,'Retail Sale Id 1005',1999.20,0.00,0.00,2.94,449.82,'2022-03-16 11:26:16','',''),(929,'1','219','1',1,'Retail Sale Id 1006',1502.80,0.00,0.00,2.21,338.13,'2022-03-16 11:41:26','',''),(930,'1','219','1',1,'Retail Sale Id 1007',1999.20,0.00,0.00,2.94,449.82,'2022-03-16 11:42:07','',''),(931,'1','219','1',1,'Retail Sale Id 1008',4080.00,0.00,0.00,6.00,918.00,'2022-03-16 11:44:50','',''),(932,'1','219','1',1,'Retail Sale Id 1009',8500.00,0.00,0.00,12.50,1912.50,'2022-03-16 11:45:59','',''),(933,'1','219','1',1,'Retail Sale Id 1010',503.20,0.00,0.00,0.74,113.22,'2022-03-16 11:56:14','',''),(934,'1','219','1',1,'Retail Sale Id 1011',2046.80,0.00,0.00,3.01,460.53,'2022-03-16 12:01:20','',''),(935,'1','219','1',1,'Retail Sale Id 1012',3840.00,0.00,0.00,6.00,678.00,'2022-03-16 12:23:53','',''),(936,'1','219','1',1,'Retail Sale Id 1013',8500.00,0.00,0.00,12.50,1912.50,'2022-03-16 12:41:54','',''),(937,'1','219','1',1,'Retail Sale Id 1014',5997.60,0.00,0.00,8.82,1349.46,'2022-03-16 13:15:56','',''),(938,'1','219','1',1,'Retail Sale Id 1015',2998.80,0.00,0.00,4.41,674.73,'2022-03-16 13:27:14','',''),(939,'1','219','1',1,'Retail Sale Id 1016',2040.00,0.00,0.00,3.00,459.00,'2022-03-16 14:47:02','',''),(940,'1','219','1',1,'Retail Sale Id 1016',3502.00,0.00,0.00,5.15,787.95,'2022-03-16 14:47:02','',''),(941,'1','219','1',1,'Retail Sale Id 1017',1502.80,0.00,0.00,2.21,338.13,'2022-03-16 14:48:16','',''),(942,'1','219','1',1,'Retail Sale Id 1018',8500.00,0.00,0.00,12.50,1912.50,'2022-03-16 14:49:44','',''),(943,'1','219','1',1,'Retail Sale Id 1020',5079.60,0.00,0.00,7.47,1142.91,'2022-03-16 15:12:50','',''),(944,'1','219','1',1,'Retail Sale Id 1023',2896.80,0.00,0.00,4.26,651.78,'2022-03-16 15:39:04','',''),(945,'1','219','1',1,'Retail Sale Id 1024',4080.00,0.00,0.00,6.00,918.00,'2022-03-16 16:02:18','',''),(946,'1','219','1',1,'Retail Sale Id 1024',4080.00,0.00,0.00,6.00,918.00,'2022-03-16 16:02:18','',''),(947,'1','219','1',1,'Retail Sale Id 1025',999.60,0.00,0.00,1.47,224.91,'2022-03-16 16:04:03','',''),(948,'1','219','1',1,'Retail Sale Id 1026',2040.00,0.00,0.00,3.00,459.00,'2022-03-16 16:23:12','',''),(949,'1','219','1',1,'Retail Sale Id 1027',652.80,0.00,0.00,0.96,146.88,'2022-03-16 16:54:16','',''),(950,'1','219','1',1,'Retail Sale Id 1028',2040.00,0.00,0.00,3.00,459.00,'2022-03-16 17:11:03','',''),(951,'1','219','1',1,'Retail Sale Id 1028',4080.00,0.00,0.00,6.00,918.00,'2022-03-16 17:11:03','',''),(952,'1','219','1',1,'Retail Sale Id 1029',2998.80,0.00,0.00,4.41,674.73,'2022-03-16 17:12:14','',''),(953,'1','219','1',1,'Retail Sale Id 1030',4080.00,0.00,0.00,6.00,918.00,'2022-03-16 17:20:38','',''),(954,'1','219','1',1,'Retail Sale Id 1031',999.60,0.00,0.00,1.47,224.91,'2022-03-16 17:21:41','',''),(955,'1','219','1',1,'Retail Sale Id 1032',1502.80,0.00,0.00,2.21,338.13,'2022-03-16 17:36:45','',''),(956,'1','219','1',1,'Retail Sale Id 1033',4080.00,0.00,0.00,6.00,918.00,'2022-03-16 18:11:26','',''),(957,'1','219','1',1,'Retail Sale Id 1034',503.20,0.00,0.00,0.74,113.22,'2022-03-16 18:21:20','',''),(958,'1','219','1',1,'Retail Sale Id 1035',4080.00,0.00,0.00,6.00,918.00,'2022-03-16 18:26:47','',''),(959,'1','219','1',1,'Retail Sale Id 1036',4080.00,0.00,0.00,6.00,918.00,'2022-03-16 18:29:42','',''),(960,'1','219','1',1,'Return of Retail Sale Id 1012',0.00,3840.00,6.00,0.00,-678.00,'2022-03-16 22:01:01','',''),(961,'1','219','1',1,'Retail Sale Id 1037',3712.00,0.00,0.00,5.80,655.40,'2022-03-16 22:01:59','',''),(962,'1','219','1',1,'Retail Sale Id 1038',102.00,0.00,0.00,0.15,22.95,'2022-03-16 22:03:54','',''),(963,'1','219','1',1,'Retail Sale Id 1039',4080.00,0.00,0.00,6.00,918.00,'2022-03-17 07:47:16','',''),(964,'1','219','1',1,'Retail Sale Id 1041',4080.00,0.00,0.00,6.00,918.00,'2022-03-17 08:24:38','',''),(965,'1','219','1',1,'Retail Sale Id 1042',299.20,0.00,0.00,0.44,67.32,'2022-03-17 08:35:55','',''),(966,'1','219','1',1,'Retail Sale Id 1043',3400.00,0.00,0.00,5.00,765.00,'2022-03-17 09:11:35','',''),(967,'1','219','1',1,'Retail Sale Id 1043',4080.00,0.00,0.00,6.00,918.00,'2022-03-17 09:11:35','',''),(968,'1','219','1',1,'Retail Sale Id 1045',2720.00,0.00,0.00,4.00,612.00,'2022-03-17 09:15:58','',''),(969,'1','219','1',1,'Retail Sale Id 1045',3400.00,0.00,0.00,5.00,765.00,'2022-03-17 09:15:58','',''),(970,'1','219','1',1,'Retail Sale Id 1046',680.00,0.00,0.00,1.00,153.00,'2022-03-17 09:25:05','',''),(971,'1','219','1',1,'Retail Sale Id 1047',3400.00,0.00,0.00,5.00,765.00,'2022-03-17 09:34:23','',''),(972,'1','219','1',1,'Retail Sale Id 1048',503.20,0.00,0.00,0.74,113.22,'2022-03-17 09:45:56','',''),(973,'1','219','1',1,'Retail Sale Id 1049',802.40,0.00,0.00,1.18,180.54,'2022-03-17 10:15:51','',''),(974,'1','219','1',1,'Retail Sale Id 1050',1502.80,0.00,0.00,2.21,338.13,'2022-03-17 10:19:13','',''),(975,'1','219','1',1,'Retail Sale Id 1051',598.40,0.00,0.00,0.88,134.64,'2022-03-17 10:34:34','',''),(976,'1','219','1',1,'Retail Sale Id 1052',4080.00,0.00,0.00,6.00,918.00,'2022-03-17 10:49:56','',''),(977,'1','219','1',1,'Retail Sale Id 1053',4080.00,0.00,0.00,6.00,918.00,'2022-03-17 10:52:41','',''),(978,'1','219','1',1,'Retail Sale Id 1054',2040.00,0.00,0.00,3.00,459.00,'2022-03-17 11:02:07','',''),(979,'1','219','1',1,'Retail Sale Id 1055',503.20,0.00,0.00,0.74,113.22,'2022-03-17 11:23:30','',''),(980,'1','219','1',1,'Retail Sale Id 1057',6997.20,0.00,0.00,10.29,1574.37,'2022-03-17 11:35:17','',''),(981,'1','219','1',1,'Retail Sale Id 1058',999.60,0.00,0.00,1.47,224.91,'2022-03-17 11:46:34','',''),(982,'1','219','1',1,'Retail Sale Id 1059',8160.00,0.00,0.00,12.00,1836.00,'2022-03-17 12:32:20','',''),(983,'1','219','1',1,'Retail Sale Id 1060',2040.00,0.00,0.00,3.00,459.00,'2022-03-17 12:43:31','',''),(984,'1','219','1',1,'Retail Sale Id 1061',1920.00,0.00,0.00,3.00,339.00,'2022-03-17 13:08:05','',''),(985,'1','219','1',1,'Retail Sale Id 1062',802.40,0.00,0.00,1.18,180.54,'2022-03-17 13:34:09','',''),(986,'1','219','1',1,'Retail Sale Id 1063',4080.00,0.00,0.00,6.00,918.00,'2022-03-17 13:41:12','',''),(987,'1','219','1',1,'Retail Sale Id 1064',2998.80,0.00,0.00,4.41,674.73,'2022-03-17 13:43:50','',''),(988,'1','219','1',1,'Retail Sale Id 1065',4080.00,0.00,0.00,6.00,918.00,'2022-03-17 13:47:32','',''),(989,'1','219','1',1,'Retail Sale Id 1067',2040.00,0.00,0.00,3.00,459.00,'2022-03-17 14:17:48','',''),(990,'1','219','1',1,'Retail Sale Id 1067',2040.00,0.00,0.00,3.00,459.00,'2022-03-17 14:17:48','',''),(991,'1','219','1',1,'Retail Sale Id 1068',1502.80,0.00,0.00,2.21,338.13,'2022-03-17 14:20:58','',''),(992,'1','219','1',1,'Retail Sale Id 1068',2040.00,0.00,0.00,3.00,459.00,'2022-03-17 14:20:58','',''),(993,'1','219','1',1,'Retail Sale Id 1069',999.60,0.00,0.00,1.47,224.91,'2022-03-17 14:22:14','',''),(994,'1','219','1',1,'Retail Sale Id 1070',8160.00,0.00,0.00,12.00,1836.00,'2022-03-17 14:43:42','',''),(995,'1','219','1',1,'Retail Sale Id 1071',1502.80,0.00,0.00,2.21,338.13,'2022-03-17 15:22:18','',''),(996,'1','219','1',1,'Retail Sale Id 1072',3840.00,0.00,0.00,6.00,678.00,'2022-03-17 15:31:02','',''),(997,'1','219','1',1,'Retail Sale Id 1073',2502.40,0.00,0.00,3.68,563.04,'2022-03-17 15:46:58','',''),(998,'1','219','1',1,'Retail Sale Id 1074',3400.00,0.00,0.00,5.00,765.00,'2022-03-17 15:50:57','',''),(999,'1','219','1',1,'Retail Sale Id 1075',401.20,0.00,0.00,0.59,90.27,'2022-03-17 15:55:39','',''),(1000,'1','219','1',1,'Retail Sale Id 1076',2040.00,0.00,0.00,3.00,459.00,'2022-03-17 16:34:46','',''),(1001,'1','219','1',1,'Distributed to OPERATIONAL LOST for sales id:3',59614.24,0.00,0.00,113.12,0.00,'2022-03-17 17:54:11','',''),(1002,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,3610188.00,5899.00,0.00,0.00,'2022-03-17 18:09:07','',''),(1003,'1','219',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,5899.00,0.00,'2022-03-17 18:11:33','',''),(1004,'1','219','1',1,'Received from bridging 3',0.00,0.00,5899.00,0.00,0.00,'2022-03-17 18:11:33','',''),(1005,'1','219','1',1,'Retail Sale Id 1077',5440.00,0.00,0.00,8.00,544.00,'2022-03-17 18:14:37','',''),(1006,'1','219','1',1,'Retail Sale Id 1078',1502.80,0.00,0.00,2.21,150.28,'2022-03-17 18:22:14','',''),(1007,'1','219','1',1,'Retail Sale Id 1079',3502.00,0.00,0.00,5.15,350.20,'2022-03-17 18:23:32','',''),(1008,'1','219','1',1,'Retail Sale Id 1080',3080.40,0.00,0.00,4.53,308.04,'2022-03-17 18:25:18','',''),(1009,'1','219','1',1,'Retail Sale Id 1081',1999.20,0.00,0.00,2.94,199.92,'2022-03-17 18:26:38','',''),(1010,'1','219','1',1,'Retail Sale Id 1082',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 18:34:50','',''),(1011,'1','219','1',1,'Retail Sale Id 1083',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 18:37:12','',''),(1012,'1','219','1',1,'Retail Sale Id 1084',1101.60,0.00,0.00,1.62,110.16,'2022-03-17 19:02:06','',''),(1013,'1','219','1',1,'Retail Sale Id 1086',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 19:11:57','',''),(1014,'1','219','1',1,'Retail Sale Id 1086',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 19:11:57','',''),(1015,'1','219','1',1,'Retail Sale Id 1086',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 19:11:57','',''),(1016,'1','219','1',1,'Retail Sale Id 1087',2046.80,0.00,0.00,3.01,204.68,'2022-03-17 19:13:49','',''),(1017,'1','219','1',1,'Retail Sale Id 1088',8500.00,0.00,0.00,12.50,850.00,'2022-03-17 19:15:46','',''),(1018,'1','219','1',1,'Retail Sale Id 1089',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 19:16:50','',''),(1019,'1','219','1',1,'Retail Sale Id 1090',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 19:17:41','',''),(1020,'1','219','1',1,'Retail Sale Id 1091',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 19:18:37','',''),(1021,'1','219','1',1,'Retail Sale Id 1093',1502.80,0.00,0.00,2.21,150.28,'2022-03-17 19:24:17','',''),(1022,'1','219','1',1,'Retail Sale Id 1094',6800.00,0.00,0.00,10.00,680.00,'2022-03-17 19:25:19','',''),(1023,'1','219','1',1,'Retail Sale Id 1096',2003.20,0.00,0.00,3.13,87.64,'2022-03-18 08:57:02','',''),(1024,'1','219','1',1,'Retail Sale Id 1097',3200.00,0.00,0.00,5.00,140.00,'2022-03-18 09:06:20','',''),(1025,'1','219','1',1,'Retail Sale Id 1098',1920.00,0.00,0.00,3.00,84.00,'2022-03-18 09:22:31','',''),(1026,'1','219','1',1,'Retail Sale Id 1099',1900.80,0.00,0.00,2.97,83.16,'2022-03-18 09:27:04','',''),(1027,'1','219','1',1,'Retail Sale Id 1100',3840.00,0.00,0.00,6.00,168.00,'2022-03-18 11:06:23','',''),(1028,'1','219','1',1,'Retail Sale Id 1102',2003.20,0.00,0.00,3.13,87.64,'2022-03-18 11:32:39','',''),(1029,'1','219','1',1,'Retail Sale Id 1103',8000.00,0.00,0.00,12.50,350.00,'2022-03-18 11:44:49','',''),(1030,'1','219','1',1,'Retail Sale Id 1104',6400.00,0.00,0.00,10.00,280.00,'2022-03-18 11:50:42','',''),(1031,'1','219','1',1,'Retail Sale Id 1106',1848.00,0.00,0.00,3.00,12.00,'2022-03-18 12:00:02','',''),(1032,'1','219','1',1,'Retail Sale Id 1107',3696.00,0.00,0.00,6.00,24.00,'2022-03-18 12:14:25','',''),(1033,'1','219','1',1,'Retail Sale Id 1108',5760.00,0.00,0.00,9.00,252.00,'2022-03-18 12:17:36','',''),(1034,'1','219','1',1,'Retail Sale Id 1109',1920.00,0.00,0.00,3.00,84.00,'2022-03-18 12:25:05','',''),(1035,'1','219','1',1,'Retail Sale Id 1110',3840.00,0.00,0.00,6.00,168.00,'2022-03-18 12:28:38','',''),(1036,'1','219','1',1,'Retail Sale Id 1111',4000.00,0.00,0.00,6.25,175.00,'2022-03-18 13:34:43','',''),(1037,'1','219','1',1,'Retail Sale Id 1112',3840.00,0.00,0.00,6.00,168.00,'2022-03-18 14:32:01','',''),(1038,'1','219','1',1,'Retail Sale Id 1113',2003.20,0.00,0.00,3.13,87.64,'2022-03-18 14:36:19','',''),(1039,'1','219','1',1,'Retail Sale Id 1114',3840.00,0.00,0.00,6.00,168.00,'2022-03-18 14:47:44','',''),(1040,'1','219','1',1,'Retail Sale Id 1115',1920.00,0.00,0.00,3.00,84.00,'2022-03-18 15:17:45','',''),(1041,'1','219','1',1,'Retail Sale Id 1116',998.40,0.00,0.00,1.56,43.68,'2022-03-18 15:18:49','',''),(1042,'1','219','1',1,'Retail Sale Id 1117',640.00,0.00,0.00,1.00,28.00,'2022-03-18 15:20:00','',''),(1043,'1','219','1',1,'Retail Sale Id 1119',499.20,0.00,0.00,0.78,21.84,'2022-03-18 15:51:05','',''),(1044,'1','219','1',1,'Retail Sale Id 1120',4499.20,0.00,0.00,7.03,196.84,'2022-03-18 16:08:45','',''),(1045,'1','219','1',1,'Retail Sale Id 1121',960.00,0.00,0.00,1.50,42.00,'2022-03-18 16:59:00','',''),(1046,'1','219','1',1,'Retail Sale Id 1122',2003.20,0.00,0.00,3.13,87.64,'2022-03-18 17:01:00','',''),(1047,'1','219','1',1,'Retail Sale Id 1123',1920.00,0.00,0.00,3.00,84.00,'2022-03-18 17:02:48','',''),(1048,'1','219','1',1,'Retail Sale Id 1124',61600.00,0.00,0.00,100.00,400.00,'2022-03-18 17:08:56','',''),(1049,'1','219','1',1,'Retail Sale Id 1125',30800.00,0.00,0.00,50.00,200.00,'2022-03-18 17:12:29','',''),(1050,'1','219','1',1,'Retail Sale Id 1126',652.80,0.00,0.00,1.02,28.56,'2022-03-18 17:17:50','',''),(1051,'1','219','1',1,'Retail Sale Id 1127',3840.00,0.00,0.00,6.00,168.00,'2022-03-18 17:38:47','',''),(1052,'1','219','1',1,'Retail Sale Id 1128',1920.00,0.00,0.00,3.00,84.00,'2022-03-18 17:42:38','',''),(1053,'1','219','1',1,'Retail Sale Id 1129',998.40,0.00,0.00,1.56,43.68,'2022-03-18 17:50:22','',''),(1054,'1','219','1',1,'Retail Sale Id 1130',1497.60,0.00,0.00,2.34,65.52,'2022-03-18 17:54:42','',''),(1055,'1','219','1',1,'Retail Sale Id 1131',640.00,0.00,0.00,1.00,28.00,'2022-03-18 17:55:52','',''),(1056,'1','219','1',1,'Retail Sale Id 1132',499.20,0.00,0.00,0.78,21.84,'2022-03-18 17:57:47','',''),(1057,'1','219','1',1,'Retail Sale Id 1133',403.20,0.00,0.00,0.63,17.64,'2022-03-18 17:58:47','',''),(1058,'1','219','1',1,'Retail Sale Id 1134',1280.00,0.00,0.00,2.00,56.00,'2022-03-18 18:06:16','',''),(1059,'1','219','1',1,'Retail Sale Id 1135',601.60,0.00,0.00,0.94,26.32,'2022-03-18 18:09:54','',''),(1060,'1','219','1',1,'Retail Sale Id 1136',1920.00,0.00,0.00,3.00,84.00,'2022-03-18 18:11:22','',''),(1061,'1','219','1',1,'Retail Sale Id 1137',403.20,0.00,0.00,0.63,17.64,'2022-03-18 18:57:53','',''),(1062,'1','219','1',1,'Retail Sale Id 1138',5760.00,0.00,0.00,9.00,252.00,'2022-03-19 08:00:38','',''),(1063,'1','219','1',1,'Retail Sale Id 1139',1702.40,0.00,0.00,2.66,74.48,'2022-03-19 08:06:20','',''),(1064,'1','219','1',1,'Retail Sale Id 1140',3840.00,0.00,0.00,6.00,168.00,'2022-03-19 08:31:15','',''),(1065,'1','219','1',1,'Retail Sale Id 1141',30800.00,0.00,0.00,50.00,200.00,'2022-03-19 08:36:34','',''),(1066,'1','219','1',1,'Retail Sale Id 1142',30800.00,0.00,0.00,50.00,200.00,'2022-03-19 08:38:55','',''),(1067,'1','219','1',1,'Retail Sale Id 1143',3840.00,0.00,0.00,6.00,168.00,'2022-03-19 08:42:09','',''),(1068,'1','219','1',1,'Retail Sale Id 1144',9856.00,0.00,0.00,16.00,64.00,'2022-03-19 09:19:47','',''),(1069,'1','219','1',1,'Retail Sale Id 1145',499.20,0.00,0.00,0.78,21.84,'2022-03-19 09:26:49','',''),(1070,'1','219','1',1,'Retail Sale Id 1146',300.80,0.00,0.00,0.47,13.16,'2022-03-19 09:40:51','',''),(1071,'1','219','1',1,'Retail Sale Id 1147',7097.60,0.00,0.00,11.09,310.52,'2022-03-19 09:42:07','',''),(1072,'1','219','1',1,'Retail Sale Id 1148',902.40,0.00,0.00,1.41,39.48,'2022-03-19 09:55:13','',''),(1073,'1','219','1',1,'Retail Sale Id 1149',1920.00,0.00,0.00,3.00,84.00,'2022-03-19 10:02:11','',''),(1074,'1','219','1',1,'Retail Sale Id 1149',3840.00,0.00,0.00,6.00,168.00,'2022-03-19 10:02:11','',''),(1075,'1','219','1',1,'Retail Sale Id 1150',2003.20,0.00,0.00,3.13,87.64,'2022-03-19 10:28:43','',''),(1076,'1','219','1',1,'Retail Sale Id 1151',4998.40,0.00,0.00,7.81,218.68,'2022-03-19 10:46:57','',''),(1077,'1','219','1',1,'Retail Sale Id 1152',998.40,0.00,0.00,1.56,43.68,'2022-03-19 10:48:09','',''),(1078,'1','219','1',1,'Retail Sale Id 1153',2003.20,0.00,0.00,3.13,87.64,'2022-03-19 11:23:23','',''),(1079,'1','219','1',1,'Retail Sale Id 1153',2003.20,0.00,0.00,3.13,87.64,'2022-03-19 11:23:23','',''),(1080,'1','219','1',1,'Retail Sale Id 1154',1299.20,0.00,0.00,2.03,56.84,'2022-03-19 11:29:09','',''),(1081,'1','219','1',1,'Retail Sale Id 1156',5544.00,0.00,0.00,9.00,36.00,'2022-03-19 11:48:38','',''),(1082,'1','219','1',1,'Retail Sale Id 1157',800.00,0.00,0.00,1.25,35.00,'2022-03-19 12:05:44','',''),(1083,'1','219','1',1,'Retail Sale Id 1160',1920.00,0.00,0.00,3.00,84.00,'2022-03-19 12:10:09','',''),(1084,'1','219','1',1,'Retail Sale Id 1160',3200.00,0.00,0.00,5.00,140.00,'2022-03-19 12:10:09','',''),(1085,'1','219','1',1,'Retail Sale Id 1162',1100.80,0.00,0.00,1.72,48.16,'2022-03-19 12:16:25','',''),(1086,'1','219','1',1,'Retail Sale Id 1163',6400.00,0.00,0.00,10.00,280.00,'2022-03-19 13:18:55','',''),(1087,'1','219','1',1,'Retail Sale Id 1164',7360.00,0.00,0.00,11.50,322.00,'2022-03-19 13:32:01','',''),(1088,'1','219','1',1,'Retail Sale Id 1164',7360.00,0.00,0.00,11.50,322.00,'2022-03-19 13:32:01','',''),(1089,'1','219','1',1,'Retail Sale Id 1164',7360.00,0.00,0.00,11.50,322.00,'2022-03-19 13:32:01','',''),(1090,'1','219','1',1,'Retail Sale Id 1165',1920.00,0.00,0.00,3.00,84.00,'2022-03-19 13:39:35','',''),(1091,'1','219','1',1,'Retail Sale Id 1167',1920.00,0.00,0.00,3.00,84.00,'2022-03-19 13:43:50','',''),(1092,'1','219','1',1,'Retail Sale Id 1169',1932.80,0.00,0.00,3.02,84.56,'2022-03-19 13:46:25','',''),(1093,'1','219','1',1,'Retail Sale Id 1170',4000.00,0.00,0.00,6.25,175.00,'2022-03-19 14:37:26','',''),(1094,'1','219','1',1,'Retail Sale Id 1171',1920.00,0.00,0.00,3.00,84.00,'2022-03-19 15:04:28','',''),(1095,'1','219','1',1,'Retail Sale Id 1172',3840.00,0.00,0.00,6.00,168.00,'2022-03-19 15:27:31','',''),(1096,'1','219','1',1,'Retail Sale Id 1173',1920.00,0.00,0.00,3.00,84.00,'2022-03-19 15:36:13','',''),(1097,'1','219','1',1,'Retail Sale Id 1174',3696.00,0.00,0.00,6.00,24.00,'2022-03-19 15:48:04','',''),(1098,'1','219','1',1,'Retail Sale Id 1175',2502.40,0.00,0.00,3.91,109.48,'2022-03-19 16:35:25','',''),(1099,'1','219','1',1,'Retail Sale Id 1176',960.00,0.00,0.00,1.50,42.00,'2022-03-19 17:28:04','',''),(1100,'1','219','1',1,'Retail Sale Id 1177',697.60,0.00,0.00,1.09,30.52,'2022-03-19 17:34:26','',''),(1101,'1','219','1',1,'Retail Sale Id 1178',2003.20,0.00,0.00,3.13,87.64,'2022-03-19 17:47:29','',''),(1102,'1','219','1',1,'Retail Sale Id 1179',2003.20,0.00,0.00,3.13,87.64,'2022-03-19 17:48:37','',''),(1103,'1','219','1',1,'Retail Sale Id 1180',1497.60,0.00,0.00,2.34,65.52,'2022-03-19 17:50:20','',''),(1104,'1','219','1',1,'Retail Sale Id 1181',1952.00,0.00,0.00,3.05,85.40,'2022-03-19 18:00:14','',''),(1105,'1','219','1',1,'Retail Sale Id 1182',3840.00,0.00,0.00,6.00,168.00,'2022-03-19 18:01:20','',''),(1106,'1','219','1',1,'Retail Sale Id 1183',640.00,0.00,0.00,1.00,28.00,'2022-03-19 18:02:40','',''),(1107,'1','219','1',1,'Retail Sale Id 1184',3500.80,0.00,0.00,5.47,153.16,'2022-03-19 18:07:49','',''),(1108,'1','219','1',1,'Retail Sale Id 1185',1203.20,0.00,0.00,1.88,52.64,'2022-03-19 18:17:41','',''),(1109,'1','219','1',1,'Retail Sale Id 1186',499.20,0.00,0.00,0.78,21.84,'2022-03-19 18:18:45','',''),(1110,'1','219','1',1,'Retail Sale Id 1187',499.20,0.00,0.00,0.78,21.84,'2022-03-19 18:28:54','',''),(1111,'1','219','1',1,'Retail Sale Id 1188',499.20,0.00,0.00,0.78,21.84,'2022-03-19 18:29:46','',''),(1112,'1','219','1',1,'Retail Sale Id 1189',3696.00,0.00,0.00,6.00,24.00,'2022-03-19 18:45:36','',''),(1113,'1','219','1',1,'Retail Sale Id 1190',8000.00,0.00,0.00,12.50,350.00,'2022-03-19 18:51:19','',''),(1114,'1','219','1',1,'Retail Sale Id 1191',6400.00,0.00,0.00,10.00,280.00,'2022-03-19 18:57:51','',''),(1115,'1','219','1',1,'Retail Sale Id 1192',1203.20,0.00,0.00,1.88,52.64,'2022-03-19 19:09:07','',''),(1116,'1','219','1',1,'Retail Sale Id 1193',697.60,0.00,0.00,1.09,30.52,'2022-03-20 07:33:12','',''),(1117,'1','219','1',1,'Retail Sale Id 1194',2003.20,0.00,0.00,3.13,87.64,'2022-03-20 07:44:08','',''),(1118,'1','219','1',1,'Retail Sale Id 1195',998.40,0.00,0.00,1.56,43.68,'2022-03-20 08:01:57','',''),(1119,'1','219','1',1,'Retail Sale Id 1197',499.20,0.00,0.00,0.78,21.84,'2022-03-20 08:05:39','',''),(1120,'1','219','1',1,'Retail Sale Id 1198',8000.00,0.00,0.00,12.50,350.00,'2022-03-20 08:11:03','',''),(1121,'1','219','1',1,'Retail Sale Id 1199',3200.00,0.00,0.00,5.00,140.00,'2022-03-20 08:45:49','',''),(1122,'1','219','1',1,'Retail Sale Id 1202',8000.00,0.00,0.00,12.50,350.00,'2022-03-20 08:49:00','',''),(1123,'1','219','1',1,'Retail Sale Id 1203',2003.20,0.00,0.00,3.13,87.64,'2022-03-20 09:24:22','',''),(1124,'1','219','1',1,'Retail Sale Id 1204',7700.00,0.00,0.00,12.50,50.00,'2022-03-20 09:26:17','',''),(1125,'1','219','1',1,'Retail Sale Id 1205',1702.40,0.00,0.00,2.66,74.48,'2022-03-20 10:11:15','',''),(1126,'1','219','1',1,'Retail Sale Id 1206',3840.00,0.00,0.00,6.00,168.00,'2022-03-20 10:12:57','',''),(1127,'1','219','1',1,'Retail Sale Id 1207',8000.00,0.00,0.00,12.50,350.00,'2022-03-20 10:14:13','',''),(1128,'1','219','1',1,'Retail Sale Id 1208',2003.20,0.00,0.00,3.13,87.64,'2022-03-20 10:15:27','',''),(1129,'1','219','1',1,'Retail Sale Id 1209',499.20,0.00,0.00,0.78,21.84,'2022-03-20 10:59:03','',''),(1130,'1','219','1',1,'Retail Sale Id 1210',4000.00,0.00,0.00,6.25,175.00,'2022-03-20 11:00:21','',''),(1131,'1','219','1',1,'Retail Sale Id 1211',1920.00,0.00,0.00,3.00,84.00,'2022-03-20 11:12:46','',''),(1132,'1','219','1',1,'Retail Sale Id 1212',30800.00,0.00,0.00,50.00,200.00,'2022-03-20 11:16:13','',''),(1133,'1','219','1',1,'Retail Sale Id 1213',1920.00,0.00,0.00,3.00,84.00,'2022-03-20 11:33:38','',''),(1134,'1','219','1',1,'Retail Sale Id 1214',1920.00,0.00,0.00,3.00,84.00,'2022-03-20 11:53:02','',''),(1135,'1','219','1',1,'Retail Sale Id 1215',2502.40,0.00,0.00,3.91,109.48,'2022-03-20 11:55:34','',''),(1136,'1','219','1',1,'Retail Sale Id 1217',6400.00,0.00,0.00,10.00,280.00,'2022-03-20 12:08:49','',''),(1137,'1','219','1',1,'Retail Sale Id 1218',1920.00,0.00,0.00,3.00,84.00,'2022-03-20 12:11:13','',''),(1138,'1','219','1',1,'Retail Sale Id 1219',2003.20,0.00,0.00,3.13,87.64,'2022-03-20 12:18:27','',''),(1139,'1','219','1',1,'Retail Sale Id 1220',3840.00,0.00,0.00,6.00,168.00,'2022-03-20 12:21:03','',''),(1140,'1','219','1',1,'Retail Sale Id 1221',3840.00,0.00,0.00,6.00,168.00,'2022-03-20 12:32:32','',''),(1141,'1','219','1',1,'Retail Sale Id 1222',800.00,0.00,0.00,1.25,35.00,'2022-03-20 12:37:26','',''),(1142,'1','219','1',1,'Retail Sale Id 1223',1497.60,0.00,0.00,2.34,65.52,'2022-03-20 12:39:04','',''),(1143,'1','219','1',1,'Retail Sale Id 1224',8000.00,0.00,0.00,12.50,350.00,'2022-03-20 12:56:37','',''),(1144,'1','219','1',1,'Retail Sale Id 1225',3840.00,0.00,0.00,6.00,168.00,'2022-03-20 13:10:12','',''),(1145,'1','219','1',1,'Retail Sale Id 1226',2003.20,0.00,0.00,3.13,87.64,'2022-03-20 13:40:18','',''),(1146,'1','219','1',1,'Retail Sale Id 1227',3200.00,0.00,0.00,5.00,140.00,'2022-03-20 14:23:13','',''),(1147,'1','219','1',1,'Retail Sale Id 1228',1497.60,0.00,0.00,2.34,65.52,'2022-03-20 14:35:34','',''),(1148,'1','219','1',1,'Retail Sale Id 1229',1920.00,0.00,0.00,3.00,84.00,'2022-03-20 14:42:21','',''),(1149,'1','219','1',1,'Retail Sale Id 1229',1920.00,0.00,0.00,3.00,84.00,'2022-03-20 14:42:21','',''),(1150,'1','219','1',1,'Retail Sale Id 1230',4499.20,0.00,0.00,7.03,196.84,'2022-03-20 15:11:14','',''),(1151,'1','219','1',1,'Retail Sale Id 1231',1920.00,0.00,0.00,3.00,84.00,'2022-03-20 15:28:47','',''),(1152,'1','219','1',1,'Retail Sale Id 1232',3500.80,0.00,0.00,5.47,153.16,'2022-03-20 16:04:33','',''),(1153,'1','219','1',1,'Retail Sale Id 1234',499.20,0.00,0.00,0.78,21.84,'2022-03-20 16:20:51','',''),(1154,'1','219','1',1,'Retail Sale Id 1235',1497.60,0.00,0.00,2.34,65.52,'2022-03-20 16:25:47','',''),(1155,'1','219','1',1,'Retail Sale Id 1236',2560.00,0.00,0.00,4.00,112.00,'2022-03-20 16:50:04','',''),(1156,'1','219','1',1,'Retail Sale Id 1237',1920.00,0.00,0.00,3.00,84.00,'2022-03-20 16:51:29','',''),(1157,'1','219','1',1,'Retail Sale Id 1238',3840.00,0.00,0.00,6.00,168.00,'2022-03-20 17:02:32','',''),(1158,'1','219','1',1,'Retail Sale Id 1239',4000.00,0.00,0.00,6.25,175.00,'2022-03-20 17:13:39','',''),(1159,'1','219','1',1,'Retail Sale Id 1240',2003.20,0.00,0.00,3.13,87.64,'2022-03-20 17:19:43','',''),(1160,'1','219','1',1,'Retail Sale Id 1241',8000.00,0.00,0.00,12.50,350.00,'2022-03-20 17:26:02','',''),(1161,'1','219','1',1,'Retail Sale Id 1242',1497.60,0.00,0.00,2.34,65.52,'2022-03-20 17:29:49','',''),(1162,'1','219','1',1,'Retail Sale Id 1243',1798.40,0.00,0.00,2.81,78.68,'2022-03-20 17:51:50','',''),(1163,'1','219','1',1,'Retail Sale Id 1244',2003.20,0.00,0.00,3.13,87.64,'2022-03-20 17:53:39','',''),(1164,'1','219','1',1,'Retail Sale Id 1245',3840.00,0.00,0.00,6.00,168.00,'2022-03-20 17:56:52','',''),(1165,'1','219','1',1,'Retail Sale Id 1245',3840.00,0.00,0.00,6.00,168.00,'2022-03-20 17:56:52','',''),(1166,'1','219','1',1,'Retail Sale Id 1246',3840.00,0.00,0.00,6.00,168.00,'2022-03-20 18:23:20','',''),(1167,'1','219','1',1,'Retail Sale Id 1247',3001.60,0.00,0.00,4.69,131.32,'2022-03-20 18:24:21','',''),(1168,'1','219','1',1,'Retail Sale Id 1248',998.40,0.00,0.00,1.56,43.68,'2022-03-20 18:25:26','',''),(1169,'1','219','1',1,'Retail Sale Id 1249',403.20,0.00,0.00,0.63,17.64,'2022-03-20 18:33:38','',''),(1170,'1','219','1',1,'Retail Sale Id 1250',697.60,0.00,0.00,1.09,30.52,'2022-03-20 18:40:14','',''),(1171,'1','219','1',1,'Retail Sale Id 1251',2099.20,0.00,0.00,3.28,91.84,'2022-03-20 18:57:30','',''),(1172,'1','219','1',1,'Return of Retail Sale Id 1249',0.00,403.20,0.63,0.00,-17.64,'2022-03-20 21:57:45','',''),(1173,'1','219','1',1,'Retail Sale Id 1252',0.00,0.00,0.00,0.00,0.00,'2022-03-20 21:58:51','',''),(1174,'1','219','1',1,'Return of Retail Sale Id 1252',0.00,0.00,0.00,0.00,0.00,'2022-03-20 22:00:20','',''),(1175,'1','219','1',1,'Retail Sale Id 1253',390.40,0.00,0.00,0.61,17.08,'2022-03-20 22:01:02','',''),(1176,'1','219','1',1,'Return of Retail Sale Id 1250',0.00,697.60,1.09,0.00,-30.52,'2022-03-20 22:02:40','',''),(1177,'1','219','1',1,'Retail Sale Id 1254',390.40,0.00,0.00,0.61,17.08,'2022-03-20 22:04:12','',''),(1178,'1','219','1',1,'Retail Sale Id 1255',3840.00,0.00,0.00,6.00,168.00,'2022-03-21 09:15:29','',''),(1179,'1','219','1',1,'Retail Sale Id 1256',2003.20,0.00,0.00,3.13,87.64,'2022-03-21 09:24:27','',''),(1180,'1','219','1',1,'Retail Sale Id 1257',998.40,0.00,0.00,1.56,43.68,'2022-03-21 09:42:20','',''),(1181,'1','219','1',1,'Retail Sale Id 1258',35001.12,0.00,0.00,56.82,227.28,'2022-03-21 09:55:05','',''),(1182,'1','219','1',1,'Retail Sale Id 1259',3200.00,0.00,0.00,5.00,140.00,'2022-03-21 09:57:04','',''),(1183,'1','219','1',1,'Retail Sale Id 1260',499.20,0.00,0.00,0.78,21.84,'2022-03-21 09:57:58','',''),(1184,'1','219','1',1,'Retail Sale Id 1262',7392.00,0.00,0.00,12.00,48.00,'2022-03-21 10:01:03','',''),(1185,'1','219','1',1,'Retail Sale Id 1263',1299.20,0.00,0.00,2.03,56.84,'2022-03-21 10:03:58','',''),(1186,'1','219','1',1,'Retail Sale Id 1264',3200.00,0.00,0.00,5.00,140.00,'2022-03-21 10:20:41','',''),(1187,'1','219','1',1,'Retail Sale Id 1265',3200.00,0.00,0.00,5.00,140.00,'2022-03-21 10:36:09','',''),(1188,'1','219','1',1,'Retail Sale Id 1266',8000.00,0.00,0.00,12.50,350.00,'2022-03-21 10:37:47','',''),(1189,'1','219','1',1,'Retail Sale Id 1267',8000.00,0.00,0.00,12.50,350.00,'2022-03-21 10:42:40','',''),(1190,'1','219','1',1,'Retail Sale Id 1268',1299.20,0.00,0.00,2.03,56.84,'2022-03-21 11:09:08','',''),(1191,'1','219','1',1,'Retail Sale Id 1269',3200.00,0.00,0.00,5.00,140.00,'2022-03-21 11:20:37','',''),(1192,'1','219','1',1,'Retail Sale Id 1270',1497.60,0.00,0.00,2.34,65.52,'2022-03-21 11:36:37','',''),(1193,'1','219','1',1,'Retail Sale Id 1272',3840.00,0.00,0.00,6.00,168.00,'2022-03-21 12:29:37','',''),(1194,'1','219','1',1,'Retail Sale Id 1272',8000.00,0.00,0.00,12.50,350.00,'2022-03-21 12:29:37','',''),(1195,'1','219','1',1,'Retail Sale Id 1275',3897.60,0.00,0.00,6.09,170.52,'2022-03-21 12:32:43','',''),(1196,'1','219','1',1,'Retail Sale Id 1276',1900.80,0.00,0.00,2.97,83.16,'2022-03-21 12:34:45','',''),(1197,'1','219','1',1,'Retail Sale Id 1277',4998.40,0.00,0.00,7.81,218.68,'2022-03-21 12:52:55','',''),(1198,'1','219','1',1,'Retail Sale Id 1278',3200.00,0.00,0.00,5.00,140.00,'2022-03-21 13:04:15','',''),(1199,'1','219','1',1,'Retail Sale Id 1279',800.00,0.00,0.00,1.25,35.00,'2022-03-21 13:18:52','',''),(1200,'1','219','1',1,'Retail Sale Id 1280',998.40,0.00,0.00,1.56,43.68,'2022-03-21 13:33:03','',''),(1201,'1','219','1',1,'Retail Sale Id 1280',1702.40,0.00,0.00,2.66,74.48,'2022-03-21 13:33:03','',''),(1202,'1','219','1',1,'Retail Sale Id 1281',4000.00,0.00,0.00,6.25,175.00,'2022-03-21 13:35:11','',''),(1203,'1','219','1',1,'Retail Sale Id 1282',3840.00,0.00,0.00,6.00,168.00,'2022-03-21 13:57:45','',''),(1204,'1','219','1',1,'Retail Sale Id 1283',3200.00,0.00,0.00,5.00,140.00,'2022-03-21 14:25:36','',''),(1205,'1','219','1',1,'Retail Sale Id 1284',1920.00,0.00,0.00,3.00,84.00,'2022-03-21 14:27:47','',''),(1206,'1','219','1',1,'Retail Sale Id 1286',2003.20,0.00,0.00,3.13,87.64,'2022-03-21 14:35:10','',''),(1207,'1','219','1',1,'Retail Sale Id 1287',8000.00,0.00,0.00,12.50,350.00,'2022-03-21 14:57:40','',''),(1208,'1','219','1',1,'Retail Sale Id 1288',3840.00,0.00,0.00,6.00,168.00,'2022-03-21 15:10:45','',''),(1209,'1','219','1',1,'Retail Sale Id 1289',998.40,0.00,0.00,1.56,43.68,'2022-03-21 15:13:51','',''),(1210,'1','219','1',1,'Retail Sale Id 1290',3840.00,0.00,0.00,6.00,168.00,'2022-03-21 15:41:53','',''),(1211,'1','219','1',1,'Retail Sale Id 1291',601.60,0.00,0.00,0.94,26.32,'2022-03-21 15:45:11','',''),(1212,'1','219','1',1,'Retail Sale Id 1292',3840.00,0.00,0.00,6.00,168.00,'2022-03-21 15:52:15','',''),(1213,'1','219','1',1,'Retail Sale Id 1293',2003.20,0.00,0.00,3.13,87.64,'2022-03-21 16:22:54','',''),(1214,'1','219','1',1,'Retail Sale Id 1294',10780.00,0.00,0.00,17.50,70.00,'2022-03-21 16:26:19','',''),(1215,'1','219','1',1,'Retail Sale Id 1295',2502.40,0.00,0.00,3.91,109.48,'2022-03-21 16:35:50','',''),(1216,'1','219','1',1,'Retail Sale Id 1297',3840.00,0.00,0.00,6.00,168.00,'2022-03-21 16:41:39','',''),(1217,'1','219','1',1,'Retail Sale Id 1298',8000.00,0.00,0.00,12.50,350.00,'2022-03-21 16:45:44','',''),(1218,'1','219','1',1,'Retail Sale Id 1299',12800.00,0.00,0.00,20.00,560.00,'2022-03-21 16:51:45','',''),(1219,'1','219','1',1,'Retail Sale Id 1300',3200.00,0.00,0.00,5.00,140.00,'2022-03-21 16:53:48','',''),(1220,'1','219','1',1,'Retail Sale Id 1301',403.20,0.00,0.00,0.63,17.64,'2022-03-21 16:56:39','',''),(1221,'1','219','1',1,'Retail Sale Id 1302',998.40,0.00,0.00,1.56,43.68,'2022-03-21 17:01:14','',''),(1222,'1','219','1',1,'Retail Sale Id 1304',3840.00,0.00,0.00,6.00,168.00,'2022-03-21 17:10:14','',''),(1223,'1','219','1',1,'Retail Sale Id 1305',998.40,0.00,0.00,1.56,43.68,'2022-03-21 17:13:28','',''),(1224,'1','219','1',1,'Retail Sale Id 1306',998.40,0.00,0.00,1.56,43.68,'2022-03-21 17:26:07','',''),(1225,'1','219','1',1,'Retail Sale Id 1307',3500.80,0.00,0.00,5.47,153.16,'2022-03-21 17:35:13','',''),(1226,'1','219','1',1,'Retail Sale Id 1308',1280.00,0.00,0.00,2.00,56.00,'2022-03-21 18:02:06','',''),(1227,'1','219','1',1,'Retail Sale Id 1309',652.80,0.00,0.00,1.02,28.56,'2022-03-21 18:28:47','',''),(1228,'1','219','1',1,'Retail Sale Id 1310',2003.20,0.00,0.00,3.13,87.64,'2022-03-21 18:33:16','',''),(1229,'1','219','1',1,'Retail Sale Id 1311',300.80,0.00,0.00,0.47,13.16,'2022-03-21 18:34:22','',''),(1230,'1','219','1',1,'Retail Sale Id 1312',7700.00,0.00,0.00,12.50,50.00,'2022-03-21 18:52:20','',''),(1231,'1','219','1',1,'Retail Sale Id 1313',1280.00,0.00,0.00,2.00,56.00,'2022-03-21 18:58:47','',''),(1232,'1','219','1',1,'Retail Sale Id 1314',3161.60,0.00,0.00,4.94,138.32,'2022-03-21 19:12:56','',''),(1233,'1','219','1',1,'Retail Sale Id 1315',1318.40,0.00,0.00,2.06,57.68,'2022-03-21 19:14:09','',''),(1234,'1','219','1',1,'Return of Retail Sale Id 1314',0.00,3161.60,4.94,0.00,-138.32,'2022-03-21 22:49:38','',''),(1235,'1','219','1',1,'Retail Sale Id 1316',1222.40,0.00,0.00,1.91,53.48,'2022-03-21 22:51:23','',''),(1236,'1','219','1',1,'Retail Sale Id 1317',2304.00,0.00,0.00,3.60,100.80,'2022-03-21 22:52:52','',''),(1237,'1','219','1',1,'Retail Sale Id 1318',3200.00,0.00,0.00,5.00,140.00,'2022-03-22 08:30:29','',''),(1238,'1','219','1',1,'Retail Sale Id 1318',6400.00,0.00,0.00,10.00,280.00,'2022-03-22 08:30:29','',''),(1239,'1','219','1',1,'Retail Sale Id 1319',2003.20,0.00,0.00,3.13,87.64,'2022-03-22 08:31:48','',''),(1240,'1','219','1',1,'Retail Sale Id 1320',8000.00,0.00,0.00,12.50,350.00,'2022-03-22 08:55:04','',''),(1241,'1','219','1',1,'Retail Sale Id 1321',16819.20,0.00,0.00,26.28,735.84,'2022-03-22 11:11:09','',''),(1242,'1','219','1',1,'Retail Sale Id 1322',21702.40,0.00,0.00,33.91,949.48,'2022-03-22 11:13:24','',''),(1243,'1','219','1',1,'Retail Sale Id 1323',2003.20,0.00,0.00,3.13,87.64,'2022-03-22 11:17:45','',''),(1244,'1','219','1',1,'Retail Sale Id 1324',3801.60,0.00,0.00,5.94,166.32,'2022-03-22 11:23:36','',''),(1245,'1','219','1',1,'Retail Sale Id 1325',640.00,0.00,0.00,1.00,28.00,'2022-03-22 11:26:13','',''),(1246,'1','219','1',1,'Retail Sale Id 1326',7392.00,0.00,0.00,12.00,48.00,'2022-03-22 11:29:56','',''),(1247,'1','219','1',1,'Retail Sale Id 1327',499.20,0.00,0.00,0.78,21.84,'2022-03-22 11:39:09','',''),(1248,'1','219','1',1,'Retail Sale Id 1328',3840.00,0.00,0.00,6.00,168.00,'2022-03-22 11:48:26','',''),(1249,'1','219','1',1,'Retail Sale Id 1329',7680.00,0.00,0.00,12.00,336.00,'2022-03-22 11:59:39','',''),(1250,'1','219','1',1,'Retail Sale Id 1330',3200.00,0.00,0.00,5.00,140.00,'2022-03-22 12:01:00','',''),(1251,'1','219','1',1,'Retail Sale Id 1331',1900.80,0.00,0.00,2.97,83.16,'2022-03-22 12:11:22','',''),(1252,'1','219','1',1,'Retail Sale Id 1332',627.20,0.00,0.00,0.98,27.44,'2022-03-22 12:12:53','',''),(1253,'1','219','1',1,'Retail Sale Id 1333',1497.60,0.00,0.00,2.34,65.52,'2022-03-22 12:15:01','',''),(1254,'1','219','1',1,'Retail Sale Id 1334',800.00,0.00,0.00,1.25,35.00,'2022-03-22 12:38:32','',''),(1255,'1','219','1',1,'Retail Sale Id 1335',1497.60,0.00,0.00,2.34,65.52,'2022-03-22 12:55:22','',''),(1256,'1','219','1',1,'Retail Sale Id 1336',3200.00,0.00,0.00,5.00,140.00,'2022-03-22 13:20:38','',''),(1257,'1','219','1',1,'Retail Sale Id 1337',3080.00,0.00,0.00,5.00,20.00,'2022-03-22 14:08:59','',''),(1258,'1','219','1',1,'Retail Sale Id 1338',7700.00,0.00,0.00,12.50,50.00,'2022-03-22 14:12:42','',''),(1259,'1','219','1',1,'Retail Sale Id 1339',3001.60,0.00,0.00,4.69,131.32,'2022-03-22 14:16:19','',''),(1260,'1','219','1',1,'Retail Sale Id 1340',1497.60,0.00,0.00,2.34,65.52,'2022-03-22 14:32:05','',''),(1261,'1','219','1',1,'Retail Sale Id 1341',1100.80,0.00,0.00,1.72,48.16,'2022-03-22 14:41:34','',''),(1262,'1','219','1',1,'Retail Sale Id 1343',3852.80,0.00,0.00,6.02,168.56,'2022-03-22 14:54:30','',''),(1263,'1','219','1',1,'Retail Sale Id 1344',1203.20,0.00,0.00,1.88,52.64,'2022-03-22 14:58:17','',''),(1264,'1','219','1',1,'Retail Sale Id 1345',2880.00,0.00,0.00,4.50,126.00,'2022-03-22 15:00:43','',''),(1265,'1','219','1',1,'Retail Sale Id 1346',1920.00,0.00,0.00,3.00,84.00,'2022-03-22 15:02:03','',''),(1266,'1','219','1',1,'Retail Sale Id 1347',3840.00,0.00,0.00,6.00,168.00,'2022-03-22 15:53:26','',''),(1267,'1','219','1',1,'Retail Sale Id 1347',3840.00,0.00,0.00,6.00,168.00,'2022-03-22 15:53:26','',''),(1268,'1','219','1',1,'Retail Sale Id 1348',2003.20,0.00,0.00,3.13,87.64,'2022-03-22 16:08:37','',''),(1269,'1','219','1',1,'Retail Sale Id 1350',1952.00,0.00,0.00,3.05,85.40,'2022-03-22 16:29:45','',''),(1270,'1','219','1',1,'Retail Sale Id 1351',2003.20,0.00,0.00,3.13,87.64,'2022-03-22 16:42:58','',''),(1271,'1','219','1',1,'Retail Sale Id 1353',1920.00,0.00,0.00,3.00,84.00,'2022-03-22 16:45:43','',''),(1272,'1','219','1',1,'Retail Sale Id 1354',403.20,0.00,0.00,0.63,17.64,'2022-03-22 16:56:25','',''),(1273,'1','219','1',1,'Retail Sale Id 1359',2502.40,0.00,0.00,3.91,109.48,'2022-03-22 17:04:56','',''),(1274,'1','219','1',1,'Retail Sale Id 1362',6400.00,0.00,0.00,10.00,280.00,'2022-03-22 17:09:34','',''),(1275,'1','219','1',1,'Retail Sale Id 1363',4000.00,0.00,0.00,6.25,175.00,'2022-03-22 17:30:30','',''),(1276,'1','219','1',1,'Retail Sale Id 1365',1280.00,0.00,0.00,2.00,56.00,'2022-03-22 18:04:25','',''),(1277,'1','219','1',1,'Retail Sale Id 1366',1497.60,0.00,0.00,2.34,65.52,'2022-03-22 18:12:03','',''),(1278,'1','219','1',1,'Retail Sale Id 1367',1920.00,0.00,0.00,3.00,84.00,'2022-03-22 18:14:14','',''),(1279,'1','219','1',1,'Retail Sale Id 1368',499.20,0.00,0.00,0.78,21.84,'2022-03-22 18:21:24','',''),(1280,'1','219','1',1,'Retail Sale Id 1369',3001.60,0.00,0.00,4.69,131.32,'2022-03-22 18:26:09','',''),(1281,'1','219','1',1,'Retail Sale Id 1370',1497.60,0.00,0.00,2.34,65.52,'2022-03-22 18:39:26','',''),(1282,'1','219','1',1,'Retail Sale Id 1371',3200.00,0.00,0.00,5.00,140.00,'2022-03-22 19:18:09','',''),(1283,'1','219','1',1,'Retail Sale Id 1372',179.20,0.00,0.00,0.28,7.84,'2022-03-22 22:23:38','',''),(1284,'1','219','1',1,'Retail Sale Id 1373',992.00,0.00,0.00,1.55,43.40,'2022-03-22 22:24:30','',''),(1285,'1','219','1',1,'Retail Sale Id 1374',6400.00,0.00,0.00,10.00,280.00,'2022-03-23 08:56:50','',''),(1286,'1','219','1',1,'Retail Sale Id 1375',3840.00,0.00,0.00,6.00,168.00,'2022-03-23 09:45:04','',''),(1287,'1','219','1',1,'Retail Sale Id 1376',8000.00,0.00,0.00,12.50,350.00,'2022-03-23 10:38:13','',''),(1288,'1','219','1',1,'Retail Sale Id 1377',3840.00,0.00,0.00,6.00,168.00,'2022-03-23 11:28:16','',''),(1289,'1','219','1',1,'Retail Sale Id 1378',2502.40,0.00,0.00,3.91,109.48,'2022-03-23 11:58:05','',''),(1290,'1','219','1',1,'Retail Sale Id 1379',2502.40,0.00,0.00,3.91,109.48,'2022-03-23 12:01:33','',''),(1291,'1','219','1',1,'Retail Sale Id 1380',7500.80,0.00,0.00,11.72,328.16,'2022-03-23 12:21:35','',''),(1292,'1','219','1',1,'Retail Sale Id 1382',499.20,0.00,0.00,0.78,21.84,'2022-03-23 13:19:36','',''),(1293,'1','219','1',1,'Retail Sale Id 1383',6400.00,0.00,0.00,10.00,280.00,'2022-03-23 13:47:32','',''),(1294,'1','219','1',1,'Retail Sale Id 1384',1401.60,0.00,0.00,2.19,61.32,'2022-03-23 13:59:29','',''),(1295,'1','219','1',1,'Retail Sale Id 1385',2003.20,0.00,0.00,3.13,87.64,'2022-03-23 14:11:26','',''),(1296,'1','219','1',1,'Retail Sale Id 1386',3852.80,0.00,0.00,6.02,168.56,'2022-03-23 14:18:45','',''),(1297,'1','219','1',1,'Retail Sale Id 1387',902.40,0.00,0.00,1.41,39.48,'2022-03-23 14:43:43','',''),(1298,'1','219','1',1,'Retail Sale Id 1388',1920.00,0.00,0.00,3.00,84.00,'2022-03-23 15:36:59','',''),(1299,'1','219','1',1,'Retail Sale Id 1389',3840.00,0.00,0.00,6.00,168.00,'2022-03-23 15:47:10','',''),(1300,'1','219','1',1,'Retail Sale Id 1390',2003.20,0.00,0.00,3.13,87.64,'2022-03-23 15:48:41','',''),(1301,'1','219','1',1,'Retail Sale Id 1391',3840.00,0.00,0.00,6.00,168.00,'2022-03-23 15:50:00','',''),(1302,'1','219','1',1,'Retail Sale Id 1392',3840.00,0.00,0.00,6.00,168.00,'2022-03-23 15:56:51','',''),(1303,'1','219','1',1,'Retail Sale Id 1394',2003.20,0.00,0.00,3.13,87.64,'2022-03-23 16:05:06','',''),(1304,'1','219','1',1,'Retail Sale Id 1395',3840.00,0.00,0.00,6.00,168.00,'2022-03-23 16:06:32','',''),(1305,'1','219','1',1,'Retail Sale Id 1396',3200.00,0.00,0.00,5.00,140.00,'2022-03-23 16:19:03','',''),(1306,'1','219','1',1,'Retail Sale Id 1397',1920.00,0.00,0.00,3.00,84.00,'2022-03-23 16:20:35','',''),(1307,'1','219','1',1,'Retail Sale Id 1398',3840.00,0.00,0.00,6.00,168.00,'2022-03-23 16:26:30','',''),(1308,'1','219','1',1,'Retail Sale Id 1399',33880.00,0.00,0.00,55.00,220.00,'2022-03-23 17:12:03','',''),(1309,'1','219','1',1,'Retail Sale Id 1400',33880.00,0.00,0.00,55.00,220.00,'2022-03-23 17:13:46','',''),(1310,'1','219','1',1,'Retail Sale Id 1402',8000.00,0.00,0.00,12.50,350.00,'2022-03-23 17:32:07','',''),(1311,'1','219','1',1,'Retail Sale Id 1403',499.20,0.00,0.00,0.78,21.84,'2022-03-23 18:11:12','',''),(1312,'1','219','1',1,'Retail Sale Id 1404',3840.00,0.00,0.00,6.00,168.00,'2022-03-23 18:28:21','',''),(1313,'1','219','1',1,'Retail Sale Id 1405',1203.20,0.00,0.00,1.88,52.64,'2022-03-23 18:37:03','',''),(1314,'1','219','1',1,'Retail Sale Id 1406',998.40,0.00,0.00,1.56,43.68,'2022-03-23 18:46:01','',''),(1315,'1','219','1',1,'Retail Sale Id 1407',499.20,0.00,0.00,0.78,21.84,'2022-03-23 19:19:03','',''),(1316,'1','219','1',1,'Return of Retail Sale Id 1395',0.00,3840.00,6.00,0.00,-168.00,'2022-03-23 23:27:21','',''),(1317,'1','219','1',1,'Retail Sale Id 1408',3840.00,0.00,0.00,6.00,168.00,'2022-03-23 23:28:49','',''),(1318,'1','219','1',1,'Return of Retail Sale Id 1389',0.00,3840.00,6.00,0.00,-168.00,'2022-03-23 23:30:53','',''),(1319,'1','219','1',1,'Retail Sale Id 1409',3840.00,0.00,0.00,6.00,168.00,'2022-03-23 23:31:29','',''),(1320,'1','219','1',1,'Retail Sale Id 1410',3001.60,0.00,0.00,4.69,131.32,'2022-03-24 08:07:17','',''),(1321,'1','219','1',1,'Retail Sale Id 1411',2003.20,0.00,0.00,3.13,87.64,'2022-03-24 08:27:01','',''),(1322,'1','219','1',1,'Retail Sale Id 1412',998.40,0.00,0.00,1.56,43.68,'2022-03-24 09:07:27','',''),(1323,'1','219','1',1,'Retail Sale Id 1413',1702.40,0.00,0.00,2.66,74.48,'2022-03-24 09:17:04','',''),(1324,'1','219','1',1,'Retail Sale Id 1414',3840.00,0.00,0.00,6.00,168.00,'2022-03-24 09:48:33','',''),(1325,'1','219','1',1,'Retail Sale Id 1415',3852.80,0.00,0.00,6.02,168.56,'2022-03-24 09:57:29','',''),(1326,'1','219','1',1,'Retail Sale Id 1416',998.40,0.00,0.00,1.56,43.68,'2022-03-24 10:08:26','',''),(1327,'1','219','1',1,'Retail Sale Id 1417',6160.00,0.00,0.00,10.00,40.00,'2022-03-24 10:18:56','',''),(1328,'1','219','1',1,'Retail Sale Id 1418',1952.00,0.00,0.00,3.05,85.40,'2022-03-24 10:24:31','',''),(1329,'1','219','1',1,'Retail Sale Id 1419',1920.00,0.00,0.00,3.00,84.00,'2022-03-24 10:32:06','',''),(1330,'1','219','1',1,'Retail Sale Id 1419',3840.00,0.00,0.00,6.00,168.00,'2022-03-24 10:32:06','',''),(1331,'1','219','1',1,'Retail Sale Id 1421',3897.60,0.00,0.00,6.09,170.52,'2022-03-24 10:54:31','',''),(1332,'1','219','1',1,'Retail Sale Id 1422',3840.00,0.00,0.00,6.00,168.00,'2022-03-24 10:56:23','',''),(1333,'1','219','1',1,'Retail Sale Id 1423',7680.00,0.00,0.00,12.00,336.00,'2022-03-24 11:01:24','',''),(1334,'1','219','1',1,'Retail Sale Id 1424',2003.20,0.00,0.00,3.13,87.64,'2022-03-24 11:02:36','',''),(1335,'1','219','1',1,'Retail Sale Id 1425',8000.00,0.00,0.00,12.50,350.00,'2022-03-24 11:03:35','',''),(1336,'1','219','1',1,'Retail Sale Id 1426',8000.00,0.00,0.00,12.50,350.00,'2022-03-24 11:09:27','',''),(1337,'1','219','1',1,'Retail Sale Id 1427',2700.80,0.00,0.00,4.22,118.16,'2022-03-24 11:14:15','',''),(1338,'1','219','1',1,'Retail Sale Id 1428',300.80,0.00,0.00,0.47,13.16,'2022-03-24 11:17:00','',''),(1339,'1','219','1',1,'Retail Sale Id 1429',499.20,0.00,0.00,0.78,21.84,'2022-03-24 11:22:10','',''),(1340,'1','219','1',1,'Retail Sale Id 1430',2560.00,0.00,0.00,4.00,112.00,'2022-03-24 11:25:42','',''),(1341,'1','219','1',1,'Retail Sale Id 1431',3001.60,0.00,0.00,4.69,131.32,'2022-03-24 11:43:14','',''),(1342,'1','219','1',1,'Retail Sale Id 1432',1920.00,0.00,0.00,3.00,84.00,'2022-03-24 11:58:07','',''),(1343,'1','219','1',1,'Retail Sale Id 1432',3200.00,0.00,0.00,5.00,140.00,'2022-03-24 11:58:07','',''),(1344,'1','219','1',1,'Retail Sale Id 1433',6400.00,0.00,0.00,10.00,280.00,'2022-03-24 12:18:59','',''),(1345,'1','219','1',1,'Retail Sale Id 1433',8000.00,0.00,0.00,12.50,350.00,'2022-03-24 12:18:59','',''),(1346,'1','219','1',1,'Retail Sale Id 1434',1600.00,0.00,0.00,2.50,70.00,'2022-03-24 12:23:44','',''),(1347,'1','219','1',1,'Retail Sale Id 1435',1920.00,0.00,0.00,3.00,84.00,'2022-03-24 12:26:24','',''),(1348,'1','219','1',1,'Retail Sale Id 1435',1920.00,0.00,0.00,3.00,84.00,'2022-03-24 12:26:24','',''),(1349,'1','219','1',1,'Retail Sale Id 1436',1920.00,0.00,0.00,3.00,84.00,'2022-03-24 12:27:50','',''),(1350,'1','219','1',1,'Retail Sale Id 1437',6400.00,0.00,0.00,10.00,280.00,'2022-03-24 12:52:08','',''),(1351,'1','219','1',1,'Retail Sale Id 1438',499.20,0.00,0.00,0.78,21.84,'2022-03-24 13:16:45','',''),(1352,'1','219','1',1,'Retail Sale Id 1439',1299.20,0.00,0.00,2.03,56.84,'2022-03-24 13:46:41','',''),(1353,'1','219','1',1,'Retail Sale Id 1440',1920.00,0.00,0.00,3.00,84.00,'2022-03-24 14:10:05','',''),(1354,'1','219','1',1,'Retail Sale Id 1441',9600.00,0.00,0.00,15.00,420.00,'2022-03-24 14:24:48','',''),(1355,'1','219','1',1,'Retail Sale Id 1444',601.60,0.00,0.00,0.94,26.32,'2022-03-24 14:49:35','',''),(1356,'1','219','1',1,'Retail Sale Id 1445',3520.00,0.00,0.00,5.50,154.00,'2022-03-24 14:56:19','',''),(1357,'1','219','1',1,'Retail Sale Id 1446',8000.00,0.00,0.00,12.50,350.00,'2022-03-24 15:12:13','',''),(1358,'1','219','1',1,'Retail Sale Id 1447',1920.00,0.00,0.00,3.00,84.00,'2022-03-24 15:56:11','',''),(1359,'1','219','1',1,'Retail Sale Id 1448',4000.00,0.00,0.00,6.25,175.00,'2022-03-24 16:09:26','',''),(1360,'1','219','1',1,'Retail Sale Id 1449',499.20,0.00,0.00,0.78,21.84,'2022-03-24 16:24:57','',''),(1361,'1','219','1',1,'Retail Sale Id 1451',2003.20,0.00,0.00,3.13,87.64,'2022-03-24 16:28:53','',''),(1362,'1','219','1',1,'Retail Sale Id 1452',3840.00,0.00,0.00,6.00,168.00,'2022-03-24 16:38:09','',''),(1363,'1','219','1',1,'Retail Sale Id 1453',8000.00,0.00,0.00,12.50,350.00,'2022-03-24 16:40:07','',''),(1364,'1','219','1',1,'Retail Sale Id 1454',998.40,0.00,0.00,1.56,43.68,'2022-03-24 16:42:00','',''),(1365,'1','219','1',1,'Retail Sale Id 1455',998.40,0.00,0.00,1.56,43.68,'2022-03-24 16:43:36','',''),(1366,'1','219','1',1,'Retail Sale Id 1456',998.40,0.00,0.00,1.56,43.68,'2022-03-24 16:49:10','',''),(1367,'1','219','1',1,'Retail Sale Id 1457',2003.20,0.00,0.00,3.13,87.64,'2022-03-24 16:50:26','',''),(1368,'1','219','1',1,'Retail Sale Id 1458',1280.00,0.00,0.00,2.00,56.00,'2022-03-24 17:07:32','',''),(1369,'1','219','1',1,'Retail Sale Id 1459',998.40,0.00,0.00,1.56,43.68,'2022-03-24 17:23:51','',''),(1370,'1','219','1',1,'Retail Sale Id 1460',2003.20,0.00,0.00,3.13,87.64,'2022-03-24 17:42:17','',''),(1371,'1','219','1',1,'Retail Sale Id 1461',3200.00,0.00,0.00,5.00,140.00,'2022-03-24 17:46:01','',''),(1372,'1','219','1',1,'Retail Sale Id 1462',403.20,0.00,0.00,0.63,17.64,'2022-03-24 17:58:42','',''),(1373,'1','219','1',1,'Retail Sale Id 1463',998.40,0.00,0.00,1.56,43.68,'2022-03-24 17:59:44','',''),(1374,'1','219','1',1,'Retail Sale Id 1464',1702.40,0.00,0.00,2.66,74.48,'2022-03-24 18:05:51','',''),(1375,'1','219','1',1,'Retail Sale Id 1465',3840.00,0.00,0.00,6.00,168.00,'2022-03-24 18:07:45','',''),(1376,'1','219','1',1,'Retail Sale Id 1466',15001.60,0.00,0.00,23.44,656.32,'2022-03-24 18:11:39','',''),(1377,'1','219','1',1,'Retail Sale Id 1467',4000.00,0.00,0.00,6.25,175.00,'2022-03-24 18:12:43','',''),(1378,'1','219','1',1,'Retail Sale Id 1468',6400.00,0.00,0.00,10.00,280.00,'2022-03-24 18:14:13','',''),(1379,'1','219','1',1,'Retail Sale Id 1469',8000.00,0.00,0.00,12.50,350.00,'2022-03-24 18:15:17','',''),(1380,'1','219','1',1,'Retail Sale Id 1470',1401.60,0.00,0.00,2.19,61.32,'2022-03-24 18:18:17','',''),(1381,'1','219','1',1,'Retail Sale Id 1471',499.20,0.00,0.00,0.78,21.84,'2022-03-24 18:19:16','',''),(1382,'1','219','1',1,'Retail Sale Id 1472',601.60,0.00,0.00,0.94,26.32,'2022-03-24 18:20:42','',''),(1383,'1','219','1',1,'Retail Sale Id 1473',998.40,0.00,0.00,1.56,43.68,'2022-03-24 18:21:39','',''),(1384,'1','219','1',1,'Retail Sale Id 1474',3200.00,0.00,0.00,5.00,140.00,'2022-03-24 18:25:16','',''),(1385,'1','219','1',1,'Retail Sale Id 1475',3840.00,0.00,0.00,6.00,168.00,'2022-03-24 18:26:23','',''),(1386,'1','219','1',1,'Retail Sale Id 1476',8000.00,0.00,0.00,12.50,350.00,'2022-03-24 18:36:10','',''),(1387,'1','219','1',1,'Retail Sale Id 1477',8000.00,0.00,0.00,12.50,350.00,'2022-03-24 18:37:53','',''),(1388,'1','219','1',1,'Retail Sale Id 1480',998.40,0.00,0.00,1.56,43.68,'2022-03-24 19:05:04','',''),(1389,'1','219','1',1,'Retail Sale Id 1481',998.40,0.00,0.00,1.56,43.68,'2022-03-25 07:52:43','',''),(1390,'1','219','1',1,'Retail Sale Id 1482',6400.00,0.00,0.00,10.00,280.00,'2022-03-25 07:58:28','',''),(1391,'1','219','1',1,'Retail Sale Id 1483',3840.00,0.00,0.00,6.00,168.00,'2022-03-25 08:38:49','',''),(1392,'1','219','1',1,'Retail Sale Id 1484',998.40,0.00,0.00,1.56,43.68,'2022-03-25 08:56:56','',''),(1393,'1','219','1',1,'Retail Sale Id 1485',3001.60,0.00,0.00,4.69,131.32,'2022-03-25 09:03:06','',''),(1394,'1','219','1',1,'Retail Sale Id 1486',697.60,0.00,0.00,1.09,30.52,'2022-03-25 09:27:23','',''),(1395,'1','219','1',1,'Retail Sale Id 1487',2003.20,0.00,0.00,3.13,87.64,'2022-03-25 09:28:59','',''),(1396,'1','219','1',1,'Retail Sale Id 1488',3840.00,0.00,0.00,6.00,168.00,'2022-03-25 09:38:11','',''),(1397,'1','219','1',1,'Retail Sale Id 1489',2003.20,0.00,0.00,3.13,87.64,'2022-03-25 09:41:24','',''),(1398,'1','219','1',1,'Retail Sale Id 1490',3840.00,0.00,0.00,6.00,168.00,'2022-03-25 09:55:30','',''),(1399,'1','219','1',1,'Retail Sale Id 1491',640.00,0.00,0.00,1.00,28.00,'2022-03-25 10:31:54','',''),(1400,'1','219','1',1,'Retail Sale Id 1492',1920.00,0.00,0.00,3.00,84.00,'2022-03-25 10:52:37','',''),(1401,'1','219','1',1,'Retail Sale Id 1492',8000.00,0.00,0.00,12.50,350.00,'2022-03-25 10:52:37','',''),(1402,'1','219','1',1,'Retail Sale Id 1493',998.40,0.00,0.00,1.56,43.68,'2022-03-25 11:27:17','',''),(1403,'1','219','1',1,'Retail Sale Id 1494',2201.60,0.00,0.00,3.44,96.32,'2022-03-25 11:40:42','',''),(1404,'1','219','1',1,'Retail Sale Id 1495',2560.00,0.00,0.00,4.00,112.00,'2022-03-25 11:45:37','',''),(1405,'1','219','1',1,'Retail Sale Id 1496',3840.00,0.00,0.00,6.00,168.00,'2022-03-25 12:00:24','',''),(1406,'1','219','1',1,'Retail Sale Id 1497',2003.20,0.00,0.00,3.13,87.64,'2022-03-25 12:05:13','',''),(1407,'1','219','1',1,'Retail Sale Id 1498',4998.40,0.00,0.00,7.81,218.68,'2022-03-25 13:08:01','',''),(1408,'1','219','1',1,'Retail Sale Id 1499',3840.00,0.00,0.00,6.00,168.00,'2022-03-25 14:26:41','',''),(1409,'1','219','1',1,'Retail Sale Id 1500',2502.40,0.00,0.00,3.91,109.48,'2022-03-25 14:41:34','',''),(1410,'1','219','1',1,'Retail Sale Id 1501',601.60,0.00,0.00,0.94,26.32,'2022-03-25 14:42:47','',''),(1411,'1','219','1',1,'Retail Sale Id 1502',3200.00,0.00,0.00,5.00,140.00,'2022-03-25 14:56:07','',''),(1412,'1','219','1',1,'Retail Sale Id 1503',2502.40,0.00,0.00,3.91,109.48,'2022-03-25 15:02:54','',''),(1413,'1','219','1',1,'Retail Sale Id 1504',3200.00,0.00,0.00,5.00,140.00,'2022-03-25 15:21:26','',''),(1414,'1','219','1',1,'Retail Sale Id 1505',33997.04,0.00,0.00,55.19,220.76,'2022-03-25 15:37:25','',''),(1415,'1','219','1',1,'Retail Sale Id 1506',2003.20,0.00,0.00,3.13,87.64,'2022-03-25 15:54:11','',''),(1416,'1','219','1',1,'Retail Sale Id 1507',3840.00,0.00,0.00,6.00,168.00,'2022-03-25 16:09:21','',''),(1417,'1','219','1',1,'Retail Sale Id 1508',3840.00,0.00,0.00,6.00,168.00,'2022-03-25 16:22:29','',''),(1418,'1','219','1',1,'Retail Sale Id 1509',998.40,0.00,0.00,1.56,43.68,'2022-03-25 16:34:05','',''),(1419,'1','219','1',1,'Retail Sale Id 1510',8000.00,0.00,0.00,12.50,350.00,'2022-03-25 16:43:27','',''),(1420,'1','219','1',1,'Retail Sale Id 1511',998.40,0.00,0.00,1.56,43.68,'2022-03-25 16:47:58','',''),(1421,'1','219','1',1,'Retail Sale Id 1512',2003.20,0.00,0.00,3.13,87.64,'2022-03-25 17:25:59','',''),(1422,'1','219','1',1,'Retail Sale Id 1513',2003.20,0.00,0.00,3.13,87.64,'2022-03-25 17:30:28','',''),(1423,'1','219','1',1,'Retail Sale Id 1514',1747.20,0.00,0.00,2.73,76.44,'2022-03-25 17:38:46','',''),(1424,'1','219','1',1,'Retail Sale Id 1515',403.20,0.00,0.00,0.63,17.64,'2022-03-25 17:45:07','',''),(1425,'1','219','1',1,'Retail Sale Id 1516',1920.00,0.00,0.00,3.00,84.00,'2022-03-25 17:48:57','',''),(1426,'1','219','1',1,'Retail Sale Id 1517',300.80,0.00,0.00,0.47,13.16,'2022-03-25 17:50:48','',''),(1427,'1','219','1',1,'Retail Sale Id 1518',352.00,0.00,0.00,0.55,15.40,'2022-03-25 18:03:01','',''),(1428,'1','219','1',1,'Retail Sale Id 1518',352.00,0.00,0.00,0.55,15.40,'2022-03-25 18:03:01','',''),(1429,'1','219','1',1,'Retail Sale Id 1519',3840.00,0.00,0.00,6.00,168.00,'2022-03-25 18:05:29','',''),(1430,'1','219','1',1,'Retail Sale Id 1520',6003.20,0.00,0.00,9.38,262.64,'2022-03-25 18:06:59','',''),(1431,'1','219','1',1,'Retail Sale Id 1521',1497.60,0.00,0.00,2.34,65.52,'2022-03-25 18:08:33','',''),(1432,'1','219','1',1,'Retail Sale Id 1522',499.20,0.00,0.00,0.78,21.84,'2022-03-25 18:09:23','',''),(1433,'1','219','1',1,'Retail Sale Id 1523',1497.60,0.00,0.00,2.34,65.52,'2022-03-25 18:40:04','',''),(1434,'1','219','1',1,'Retail Sale Id 1524',1843.20,0.00,0.00,2.88,80.64,'2022-03-25 18:59:31','',''),(1435,'1','219','1',1,'Return of Retail Sale Id 1514',0.00,1747.20,2.73,0.00,-76.44,'2022-03-25 19:41:01','',''),(1436,'1','219','1',1,'Retail Sale Id 1525',1331.20,0.00,0.00,2.08,58.24,'2022-03-25 19:42:22','',''),(1437,'1','219','1',1,'Retail Sale Id 1526',403.20,0.00,0.00,0.63,17.64,'2022-03-25 19:43:35','',''),(1438,'1','219','1',1,'Retail Sale Id 1527',710.40,0.00,0.00,1.11,31.08,'2022-03-26 10:40:36','',''),(1439,'1','219','1',1,'Retail Sale Id 1528',3852.80,0.00,0.00,6.02,168.56,'2022-03-26 10:42:08','',''),(1440,'1','219','1',1,'Retail Sale Id 1529',3200.00,0.00,0.00,5.00,140.00,'2022-03-26 10:43:29','',''),(1441,'1','219','1',1,'Retail Sale Id 1530',1702.40,0.00,0.00,2.66,74.48,'2022-03-26 10:44:38','',''),(1442,'1','219','1',1,'Retail Sale Id 1531',1920.00,0.00,0.00,3.00,84.00,'2022-03-26 10:45:55','',''),(1443,'1','219','1',1,'Retail Sale Id 1532',1280.00,0.00,0.00,2.00,56.00,'2022-03-26 10:56:50','',''),(1444,'1','219','1',1,'Retail Sale Id 1533',1920.00,0.00,0.00,3.00,84.00,'2022-03-26 11:01:42','',''),(1445,'1','219','1',1,'Retail Sale Id 1534',1920.00,0.00,0.00,3.00,84.00,'2022-03-26 11:53:11','',''),(1446,'1','219','1',1,'Retail Sale Id 1535',3897.60,0.00,0.00,6.09,170.52,'2022-03-26 11:54:37','',''),(1447,'1','219','1',1,'Retail Sale Id 1536',3840.00,0.00,0.00,6.00,168.00,'2022-03-26 12:00:54','',''),(1448,'1','219','1',1,'Retail Sale Id 1537',2803.20,0.00,0.00,4.38,122.64,'2022-03-26 12:04:53','',''),(1449,'1','219','1',1,'Retail Sale Id 1538',652.80,0.00,0.00,1.02,28.56,'2022-03-26 12:18:12','',''),(1450,'1','219','1',1,'Retail Sale Id 1539',697.60,0.00,0.00,1.09,30.52,'2022-03-26 12:19:48','',''),(1451,'1','219','1',1,'Retail Sale Id 1540',1497.60,0.00,0.00,2.34,65.52,'2022-03-26 12:21:03','',''),(1452,'1','219','1',1,'Retail Sale Id 1541',3200.00,0.00,0.00,5.00,140.00,'2022-03-26 12:22:04','',''),(1453,'1','219','1',1,'Retail Sale Id 1542',300.80,0.00,0.00,0.47,13.16,'2022-03-26 13:08:05','',''),(1454,'1','219','1',1,'Retail Sale Id 1543',8000.00,0.00,0.00,12.50,350.00,'2022-03-26 13:29:11','',''),(1455,'1','219','1',1,'Retail Sale Id 1544',3200.00,0.00,0.00,5.00,140.00,'2022-03-26 13:31:44','',''),(1456,'1','219','1',1,'Retail Sale Id 1546',3840.00,0.00,0.00,6.00,168.00,'2022-03-26 13:48:51','',''),(1457,'1','219','1',1,'Retail Sale Id 1547',800.00,0.00,0.00,1.25,35.00,'2022-03-26 13:50:10','',''),(1458,'1','219','1',1,'Retail Sale Id 1548',3840.00,0.00,0.00,6.00,168.00,'2022-03-26 13:51:52','',''),(1459,'1','219','1',1,'Retail Sale Id 1549',998.40,0.00,0.00,1.56,43.68,'2022-03-26 14:21:01','',''),(1460,'1','219','1',1,'Retail Sale Id 1550',998.40,0.00,0.00,1.56,43.68,'2022-03-26 14:23:06','',''),(1461,'1','219','1',1,'Retail Sale Id 1551',998.40,0.00,0.00,1.56,43.68,'2022-03-26 14:24:24','',''),(1462,'1','219','1',1,'Retail Sale Id 1552',1920.00,0.00,0.00,3.00,84.00,'2022-03-26 14:50:31','',''),(1463,'1','219','1',1,'Retail Sale Id 1553',1900.80,0.00,0.00,2.97,83.16,'2022-03-26 14:57:17','',''),(1464,'1','219','1',1,'Retail Sale Id 1554',2201.60,0.00,0.00,3.44,96.32,'2022-03-26 15:02:33','',''),(1465,'1','219','1',1,'Retail Sale Id 1555',4000.00,0.00,0.00,6.25,175.00,'2022-03-26 15:53:33','',''),(1466,'1','219','1',1,'Retail Sale Id 1555',4000.00,0.00,0.00,6.25,175.00,'2022-03-26 15:53:33','',''),(1467,'1','219','1',1,'Retail Sale Id 1556',3696.00,0.00,0.00,6.00,24.00,'2022-03-26 16:03:07','',''),(1468,'1','219','1',1,'Retail Sale Id 1557',3200.00,0.00,0.00,5.00,140.00,'2022-03-26 16:40:26','',''),(1469,'1','219','1',1,'Retail Sale Id 1558',30800.00,0.00,0.00,50.00,200.00,'2022-03-26 16:49:50','',''),(1470,'1','219','1',1,'Retail Sale Id 1559',1497.60,0.00,0.00,2.34,65.52,'2022-03-26 16:52:16','',''),(1471,'1','219','1',1,'Retail Sale Id 1560',8000.00,0.00,0.00,12.50,350.00,'2022-03-26 17:00:28','',''),(1472,'1','219','1',1,'Retail Sale Id 1561',3001.60,0.00,0.00,4.69,131.32,'2022-03-26 17:02:55','',''),(1473,'1','219','1',1,'Retail Sale Id 1562',3001.60,0.00,0.00,4.69,131.32,'2022-03-26 17:26:02','',''),(1474,'1','219','1',1,'Retail Sale Id 1563',1280.00,0.00,0.00,2.00,56.00,'2022-03-26 17:28:27','',''),(1475,'1','219','1',1,'Retail Sale Id 1564',2502.40,0.00,0.00,3.91,109.48,'2022-03-26 17:29:27','',''),(1476,'1','219','1',1,'Retail Sale Id 1565',1203.20,0.00,0.00,1.88,52.64,'2022-03-26 17:35:23','',''),(1477,'1','219','1',1,'Retail Sale Id 1566',998.40,0.00,0.00,1.56,43.68,'2022-03-26 18:00:52','',''),(1478,'1','219','1',1,'Retail Sale Id 1567',1203.20,0.00,0.00,1.88,52.64,'2022-03-26 18:04:17','',''),(1479,'1','219','1',1,'Retail Sale Id 1568',697.60,0.00,0.00,1.09,30.52,'2022-03-26 18:23:33','',''),(1480,'1','219','1',1,'Retail Sale Id 1569',697.60,0.00,0.00,1.09,30.52,'2022-03-26 18:25:30','',''),(1481,'1','219','1',1,'Retail Sale Id 1570',3840.00,0.00,0.00,6.00,168.00,'2022-03-26 18:27:34','',''),(1482,'1','219','1',1,'Retail Sale Id 1570',8000.00,0.00,0.00,12.50,350.00,'2022-03-26 18:27:34','',''),(1483,'1','219','1',1,'Retail Sale Id 1571',3001.60,0.00,0.00,4.69,131.32,'2022-03-26 18:28:43','',''),(1484,'1','219','1',1,'Retail Sale Id 1572',3001.60,0.00,0.00,4.69,131.32,'2022-03-26 18:34:54','',''),(1485,'1','219','1',1,'Retail Sale Id 1573',300.80,0.00,0.00,0.47,13.16,'2022-03-26 18:40:51','',''),(1486,'1','219','1',1,'Retail Sale Id 1574',640.00,0.00,0.00,1.00,28.00,'2022-03-26 19:00:01','',''),(1487,'1','219','1',1,'Retail Sale Id 1575',3001.60,0.00,0.00,4.69,131.32,'2022-03-26 19:01:18','',''),(1488,'1','219','1',1,'Retail Sale Id 1576',998.40,0.00,0.00,1.56,43.68,'2022-03-26 19:13:30','',''),(1489,'1','219','1',1,'Retail Sale Id 1577',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 08:59:06','',''),(1490,'1','219','1',1,'Retail Sale Id 1579',4100.40,0.00,0.00,6.03,410.04,'2022-03-27 09:14:28','',''),(1491,'1','219','1',1,'Retail Sale Id 1580',6398.80,0.00,0.00,9.41,639.88,'2022-03-27 09:16:39','',''),(1492,'1','219','1',1,'Retail Sale Id 1581',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 09:26:13','',''),(1493,'1','219','1',1,'Retail Sale Id 1581',8160.00,0.00,0.00,12.00,816.00,'2022-03-27 09:26:13','',''),(1494,'1','219','1',1,'Retail Sale Id 1582',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 09:29:52','',''),(1495,'1','219','1',1,'Retail Sale Id 1583',299.20,0.00,0.00,0.44,29.92,'2022-03-27 09:42:01','',''),(1496,'1','219','1',1,'Retail Sale Id 1584',3852.00,0.00,0.00,6.00,180.00,'2022-03-27 10:07:00','',''),(1497,'1','219','1',1,'Retail Sale Id 1585',3998.40,0.00,0.00,5.88,399.84,'2022-03-27 10:20:12','',''),(1498,'1','219','1',1,'Retail Sale Id 1586',1999.20,0.00,0.00,2.94,199.92,'2022-03-27 10:21:47','',''),(1499,'1','219','1',1,'Retail Sale Id 1587',64200.00,0.00,0.00,100.00,3000.00,'2022-03-27 10:24:14','',''),(1500,'1','219','1',1,'Retail Sale Id 1588',48150.00,0.00,0.00,75.00,2250.00,'2022-03-27 10:26:14','',''),(1501,'1','219','1',1,'Retail Sale Id 1589',3852.00,0.00,0.00,6.00,180.00,'2022-03-27 10:52:19','',''),(1502,'1','219','1',1,'Retail Sale Id 1590',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 10:54:59','',''),(1503,'1','219','1',1,'Retail Sale Id 1591',1502.80,0.00,0.00,2.21,150.28,'2022-03-27 11:01:10','',''),(1504,'1','219','1',1,'Retail Sale Id 1592',1700.00,0.00,0.00,2.50,170.00,'2022-03-27 11:10:52','',''),(1505,'1','219','1',1,'Retail Sale Id 1593',999.60,0.00,0.00,1.47,99.96,'2022-03-27 11:13:19','',''),(1506,'1','219','1',1,'Retail Sale Id 1594',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 11:17:21','',''),(1507,'1','219','1',1,'Retail Sale Id 1595',802.40,0.00,0.00,1.18,80.24,'2022-03-27 11:18:29','',''),(1508,'1','219','1',1,'Retail Sale Id 1596',598.40,0.00,0.00,0.88,59.84,'2022-03-27 11:19:28','',''),(1509,'1','219','1',1,'Retail Sale Id 1597',2720.00,0.00,0.00,4.00,272.00,'2022-03-27 11:21:21','',''),(1510,'1','219','1',1,'Retail Sale Id 1598',8160.00,0.00,0.00,12.00,816.00,'2022-03-27 11:23:13','',''),(1511,'1','219','1',1,'Retail Sale Id 1599',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 11:28:00','',''),(1512,'1','219','1',1,'Retail Sale Id 1600',2720.00,0.00,0.00,4.00,272.00,'2022-03-27 11:42:41','',''),(1513,'1','219','1',1,'Retail Sale Id 1601',2502.40,0.00,0.00,3.68,250.24,'2022-03-27 11:48:13','',''),(1514,'1','219','1',1,'Retail Sale Id 1602',2998.80,0.00,0.00,4.41,299.88,'2022-03-27 11:54:08','',''),(1515,'1','219','1',1,'Retail Sale Id 1603',2003.04,0.00,0.00,3.12,93.60,'2022-03-27 12:02:26','',''),(1516,'1','219','1',1,'Retail Sale Id 1604',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 12:07:10','',''),(1517,'1','219','1',1,'Retail Sale Id 1605',1999.20,0.00,0.00,2.94,199.92,'2022-03-27 12:10:31','',''),(1518,'1','219','1',1,'Retail Sale Id 1606',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 12:14:18','',''),(1519,'1','219','1',1,'Retail Sale Id 1607',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 12:25:08','',''),(1520,'1','219','1',1,'Retail Sale Id 1608',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 12:26:26','',''),(1521,'1','219','1',1,'Retail Sale Id 1609',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 12:28:31','',''),(1522,'1','219','1',1,'Retail Sale Id 1609',8160.00,0.00,0.00,12.00,816.00,'2022-03-27 12:28:31','',''),(1523,'1','219','1',1,'Retail Sale Id 1610',1502.80,0.00,0.00,2.21,150.28,'2022-03-27 12:31:13','',''),(1524,'1','219','1',1,'Retail Sale Id 1611',999.60,0.00,0.00,1.47,99.96,'2022-03-27 12:33:07','',''),(1525,'1','219','1',1,'Retail Sale Id 1611',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 12:33:07','',''),(1526,'1','219','1',1,'Retail Sale Id 1612',1999.20,0.00,0.00,2.94,199.92,'2022-03-27 12:37:41','',''),(1527,'1','219','1',1,'Retail Sale Id 1613',3597.20,0.00,0.00,5.29,359.72,'2022-03-27 12:38:52','',''),(1528,'1','219','1',1,'Retail Sale Id 1615',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 13:00:39','',''),(1529,'1','219','1',1,'Retail Sale Id 1615',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 13:00:39','',''),(1530,'1','219','1',1,'Retail Sale Id 1616',1926.00,0.00,0.00,3.00,90.00,'2022-03-27 13:04:09','',''),(1531,'1','219','1',1,'Retail Sale Id 1617',6800.00,0.00,0.00,10.00,680.00,'2022-03-27 13:05:11','',''),(1532,'1','219','1',1,'Retail Sale Id 1618',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 13:18:31','',''),(1533,'1','219','1',1,'Retail Sale Id 1619',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 13:36:19','',''),(1534,'1','219','1',1,'Retail Sale Id 1620',503.20,0.00,0.00,0.74,50.32,'2022-03-27 13:59:06','',''),(1535,'1','219','1',1,'Retail Sale Id 1621',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 14:06:27','',''),(1536,'1','219','1',1,'Retail Sale Id 1622',2998.80,0.00,0.00,4.41,299.88,'2022-03-27 14:29:34','',''),(1537,'1','219','1',1,'Retail Sale Id 1623',3998.40,0.00,0.00,5.88,399.84,'2022-03-27 14:30:46','',''),(1538,'1','219','1',1,'Retail Sale Id 1624',999.60,0.00,0.00,1.47,99.96,'2022-03-27 15:00:59','',''),(1539,'1','219','1',1,'Retail Sale Id 1626',33499.56,0.00,0.00,52.18,1565.40,'2022-03-27 15:08:15','',''),(1540,'1','219','1',1,'Retail Sale Id 1627',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 15:14:35','',''),(1541,'1','219','1',1,'Retail Sale Id 1628',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 15:16:27','',''),(1542,'1','219','1',1,'Retail Sale Id 1628',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 15:16:27','',''),(1543,'1','219','1',1,'Retail Sale Id 1629',1999.20,0.00,0.00,2.94,199.92,'2022-03-27 15:41:56','',''),(1544,'1','219','1',1,'Retail Sale Id 1630',1196.80,0.00,0.00,1.76,119.68,'2022-03-27 15:43:15','',''),(1545,'1','219','1',1,'Retail Sale Id 1631',1502.80,0.00,0.00,2.21,150.28,'2022-03-27 15:45:55','',''),(1546,'1','219','1',1,'Retail Sale Id 1632',3852.00,0.00,0.00,6.00,180.00,'2022-03-27 15:58:10','',''),(1547,'1','219','1',1,'Retail Sale Id 1633',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 16:34:50','',''),(1548,'1','219','1',1,'Retail Sale Id 1634',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 16:36:27','',''),(1549,'1','219','1',1,'Retail Sale Id 1635',1502.80,0.00,0.00,2.21,150.28,'2022-03-27 16:37:46','',''),(1550,'1','219','1',1,'Retail Sale Id 1636',999.60,0.00,0.00,1.47,99.96,'2022-03-27 16:56:29','',''),(1551,'1','219','1',1,'Retail Sale Id 1637',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 17:10:06','',''),(1552,'1','219','1',1,'Retail Sale Id 1638',1999.20,0.00,0.00,2.94,199.92,'2022-03-27 17:25:12','',''),(1553,'1','219','1',1,'Retail Sale Id 1639',1502.80,0.00,0.00,2.21,150.28,'2022-03-27 17:26:38','',''),(1554,'1','219','1',1,'Retail Sale Id 1640',299.20,0.00,0.00,0.44,29.92,'2022-03-27 17:28:48','',''),(1555,'1','219','1',1,'Retail Sale Id 1641',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 17:30:03','',''),(1556,'1','219','1',1,'Retail Sale Id 1642',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 17:33:27','',''),(1557,'1','219','1',1,'Retail Sale Id 1643',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 18:05:39','',''),(1558,'1','219','1',1,'Retail Sale Id 1644',999.60,0.00,0.00,1.47,99.96,'2022-03-27 18:06:30','',''),(1559,'1','219','1',1,'Retail Sale Id 1645',6997.20,0.00,0.00,10.29,699.72,'2022-03-27 18:08:37','',''),(1560,'1','219','1',1,'Retail Sale Id 1646',680.00,0.00,0.00,1.00,68.00,'2022-03-27 18:10:22','',''),(1561,'1','219','1',1,'Retail Sale Id 1647',503.20,0.00,0.00,0.74,50.32,'2022-03-27 18:28:56','',''),(1562,'1','219','1',1,'Retail Sale Id 1648',1502.80,0.00,0.00,2.21,150.28,'2022-03-27 18:35:28','',''),(1563,'1','219','1',1,'Retail Sale Id 1649',1298.80,0.00,0.00,1.91,129.88,'2022-03-27 18:39:17','',''),(1564,'1','219','1',1,'Retail Sale Id 1650',6800.00,0.00,0.00,10.00,680.00,'2022-03-28 08:02:04','',''),(1565,'1','219','1',1,'Retail Sale Id 1651',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 08:41:53','',''),(1566,'1','219','1',1,'Retail Sale Id 1652',1502.80,0.00,0.00,2.21,150.28,'2022-03-28 08:53:04','',''),(1567,'1','219','1',1,'Retail Sale Id 1653',4100.40,0.00,0.00,6.03,410.04,'2022-03-28 09:03:54','',''),(1568,'1','219','1',1,'Retail Sale Id 1654',6800.00,0.00,0.00,10.00,680.00,'2022-03-28 09:10:01','',''),(1569,'1','219','1',1,'Retail Sale Id 1655',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 09:26:27','',''),(1570,'1','219','1',1,'Retail Sale Id 1657',999.60,0.00,0.00,1.47,99.96,'2022-03-28 10:16:06','',''),(1571,'1','219','1',1,'Retail Sale Id 1658',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 10:23:43','',''),(1572,'1','219','1',1,'Retail Sale Id 1659',2720.00,0.00,0.00,4.00,272.00,'2022-03-28 10:25:03','',''),(1573,'1','219','1',1,'Retail Sale Id 1660',11560.00,0.00,0.00,17.00,1156.00,'2022-03-28 10:26:31','',''),(1574,'1','219','1',1,'Retail Sale Id 1661',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 10:28:30','',''),(1575,'1','219','1',1,'Retail Sale Id 1662',700.40,0.00,0.00,1.03,70.04,'2022-03-28 10:30:20','',''),(1576,'1','219','1',1,'Retail Sale Id 1663',503.20,0.00,0.00,0.74,50.32,'2022-03-28 10:46:40','',''),(1577,'1','219','1',1,'Retail Sale Id 1664',1999.20,0.00,0.00,2.94,199.92,'2022-03-28 10:53:08','',''),(1578,'1','219','1',1,'Retail Sale Id 1665',6099.60,0.00,0.00,8.97,609.96,'2022-03-28 11:36:34','',''),(1579,'1','219','1',1,'Retail Sale Id 1666',32100.00,0.00,0.00,50.00,1500.00,'2022-03-28 12:09:10','',''),(1580,'1','219','1',1,'Retail Sale Id 1667',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 12:10:36','',''),(1581,'1','219','1',1,'Retail Sale Id 1668',1400.80,0.00,0.00,2.06,140.08,'2022-03-28 12:19:13','',''),(1582,'1','219','1',1,'Retail Sale Id 1669',6120.00,0.00,0.00,9.00,612.00,'2022-03-28 12:24:17','',''),(1583,'1','219','1',1,'Retail Sale Id 1670',1999.20,0.00,0.00,2.94,199.92,'2022-03-28 12:29:58','',''),(1584,'1','219','1',1,'Retail Sale Id 1671',7480.00,0.00,0.00,11.00,748.00,'2022-03-28 12:49:41','',''),(1585,'1','219','1',1,'Retail Sale Id 1672',897.60,0.00,0.00,1.32,89.76,'2022-03-28 13:10:10','',''),(1586,'1','219','1',1,'Retail Sale Id 1673',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 13:19:44','',''),(1587,'1','219','1',1,'Retail Sale Id 1674',503.20,0.00,0.00,0.74,50.32,'2022-03-28 13:27:26','',''),(1588,'1','219','1',1,'Retail Sale Id 1675',2998.80,0.00,0.00,4.41,299.88,'2022-03-28 13:28:27','',''),(1589,'1','219','1',1,'Retail Sale Id 1676',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 13:57:00','',''),(1590,'1','219','1',1,'Retail Sale Id 1677',802.40,0.00,0.00,1.18,80.24,'2022-03-28 14:21:00','',''),(1591,'1','219','1',1,'Retail Sale Id 1678',4760.00,0.00,0.00,7.00,476.00,'2022-03-28 14:26:52','',''),(1592,'1','219','1',1,'Retail Sale Id 1679',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 14:46:06','',''),(1593,'1','219','1',1,'Retail Sale Id 1680',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 14:51:31','',''),(1594,'1','219','1',1,'Retail Sale Id 1681',680.00,0.00,0.00,1.00,68.00,'2022-03-28 14:52:16','',''),(1595,'1','219','1',1,'Retail Sale Id 1682',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 14:55:58','',''),(1596,'1','219','1',1,'Retail Sale Id 1683',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 15:49:48','',''),(1597,'1','219','1',1,'Retail Sale Id 1684',1101.60,0.00,0.00,1.62,110.16,'2022-03-28 16:02:40','',''),(1598,'1','219','1',1,'Retail Sale Id 1686',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 16:07:33','',''),(1599,'1','219','1',1,'Retail Sale Id 1687',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 16:27:25','',''),(1600,'1','219','1',1,'Retail Sale Id 1688',2101.20,0.00,0.00,3.09,210.12,'2022-03-28 16:29:22','',''),(1601,'1','219','1',1,'Retail Sale Id 1689',1502.80,0.00,0.00,2.21,150.28,'2022-03-28 16:34:48','',''),(1602,'1','219','1',1,'Retail Sale Id 1690',6800.00,0.00,0.00,10.00,680.00,'2022-03-28 16:41:42','',''),(1603,'1','219','1',1,'Retail Sale Id 1691',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 17:03:32','',''),(1604,'1','219','1',1,'Retail Sale Id 1692',6800.00,0.00,0.00,10.00,680.00,'2022-03-28 17:04:41','',''),(1605,'1','219','1',1,'Retail Sale Id 1693',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 17:12:25','',''),(1606,'1','219','1',1,'Retail Sale Id 1694',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 17:39:10','',''),(1607,'1','219','1',1,'Retail Sale Id 1694',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 17:39:10','',''),(1608,'1','219','1',1,'Retail Sale Id 1696',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 17:42:08','',''),(1609,'1','219','1',1,'Retail Sale Id 1697',999.60,0.00,0.00,1.47,99.96,'2022-03-28 17:45:55','',''),(1610,'1','219','1',1,'Retail Sale Id 1698',2080.80,0.00,0.00,3.06,208.08,'2022-03-28 18:06:02','',''),(1611,'1','219','1',1,'Retail Sale Id 1699',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 18:08:18','',''),(1612,'1','219','1',1,'Retail Sale Id 1700',700.40,0.00,0.00,1.03,70.04,'2022-03-28 18:22:23','',''),(1613,'1','219','1',1,'Retail Sale Id 1701',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 18:26:17','',''),(1614,'1','219','1',1,'Retail Sale Id 1702',999.60,0.00,0.00,1.47,99.96,'2022-03-28 18:31:40','',''),(1615,'1','219','1',1,'Retail Sale Id 1703',251.60,0.00,0.00,0.37,25.16,'2022-03-28 18:32:56','',''),(1616,'1','219','1',1,'Retail Sale Id 1705',4039.20,0.00,0.00,5.94,403.92,'2022-03-28 18:42:59','',''),(1617,'1','219','1',1,'Retail Sale Id 1708',1400.80,0.00,0.00,2.06,140.08,'2022-03-28 19:00:01','',''),(1618,'1','219','1',1,'Retail Sale Id 1709',2502.40,0.00,0.00,3.68,250.24,'2022-03-28 19:00:54','',''),(1619,'1','219','1',1,'Return of Retail Sale Id 1702',0.00,999.60,1.47,0.00,-99.96,'2022-03-28 19:26:41','',''),(1620,'1','219','1',1,'Retail Sale Id 1710',632.40,0.00,0.00,0.93,63.24,'2022-03-28 19:27:53','',''),(1621,'1','219','1',1,'Retail Sale Id 1711',503.20,0.00,0.00,0.74,50.32,'2022-03-28 19:29:33','',''),(1622,'1','219','1',1,'Retail Sale Id 1712',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 07:54:08','',''),(1623,'1','219','1',1,'Retail Sale Id 1713',6800.00,0.00,0.00,10.00,680.00,'2022-03-29 07:55:50','',''),(1624,'1','219','1',1,'Retail Sale Id 1714',639.20,0.00,0.00,0.94,63.92,'2022-03-29 08:13:01','',''),(1625,'1','219','1',1,'Retail Sale Id 1715',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 09:01:56','',''),(1626,'1','219','1',1,'Retail Sale Id 1716',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 09:04:26','',''),(1627,'1','219','1',1,'Retail Sale Id 1718',2699.60,0.00,0.00,3.97,269.96,'2022-03-29 09:21:08','',''),(1628,'1','219','1',1,'Retail Sale Id 1719',32100.00,0.00,0.00,50.00,1500.00,'2022-03-29 09:52:14','',''),(1629,'1','219','1',1,'Retail Sale Id 1720',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 09:55:58','',''),(1630,'1','219','1',1,'Retail Sale Id 1720',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 09:55:58','',''),(1631,'1','219','1',1,'Retail Sale Id 1721',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 10:02:18','',''),(1632,'1','219','1',1,'Retail Sale Id 1722',2502.40,0.00,0.00,3.68,250.24,'2022-03-29 10:09:08','',''),(1633,'1','219','1',1,'Retail Sale Id 1723',2998.80,0.00,0.00,4.41,299.88,'2022-03-29 10:21:11','',''),(1634,'1','219','1',1,'Retail Sale Id 1724',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 10:34:15','',''),(1635,'1','219','1',1,'Retail Sale Id 1725',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 10:38:53','',''),(1636,'1','219','1',1,'Retail Sale Id 1726',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 11:04:48','',''),(1637,'1','219','1',1,'Retail Sale Id 1726',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 11:04:48','',''),(1638,'1','219','1',1,'Retail Sale Id 1727',1999.20,0.00,0.00,2.94,199.92,'2022-03-29 11:20:10','',''),(1639,'1','219','1',1,'Retail Sale Id 1728',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 11:22:27','',''),(1640,'1','219','1',1,'Retail Sale Id 1729',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 11:38:37','',''),(1641,'1','219','1',1,'Retail Sale Id 1730',802.40,0.00,0.00,1.18,80.24,'2022-03-29 11:47:07','',''),(1642,'1','219','1',1,'Retail Sale Id 1731',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 11:55:10','',''),(1643,'1','219','1',1,'Retail Sale Id 1732',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 12:07:32','',''),(1644,'1','219','1',1,'Retail Sale Id 1733',1502.80,0.00,0.00,2.21,150.28,'2022-03-29 12:29:39','',''),(1645,'1','219','1',1,'Retail Sale Id 1734',1999.20,0.00,0.00,2.94,199.92,'2022-03-29 12:34:26','',''),(1646,'1','219','1',1,'Retail Sale Id 1735',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 12:36:15','',''),(1647,'1','219','1',1,'Retail Sale Id 1736',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 13:22:54','',''),(1648,'1','219','1',1,'Retail Sale Id 1736',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 13:22:54','',''),(1649,'1','219','1',1,'Retail Sale Id 1737',598.40,0.00,0.00,0.88,59.84,'2022-03-29 13:24:26','',''),(1650,'1','219','1',1,'Retail Sale Id 1738',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 13:27:49','',''),(1651,'1','219','1',1,'Retail Sale Id 1739',802.40,0.00,0.00,1.18,80.24,'2022-03-29 13:38:51','',''),(1652,'1','219','1',1,'Retail Sale Id 1740',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 13:58:12','',''),(1653,'1','219','1',1,'Retail Sale Id 1741',4173.00,0.00,0.00,6.50,195.00,'2022-03-29 14:13:18','',''),(1654,'1','219','1',1,'Retail Sale Id 1742',1700.00,0.00,0.00,2.50,170.00,'2022-03-29 14:21:08','',''),(1655,'1','219','1',1,'Retail Sale Id 1743',10880.00,0.00,0.00,16.00,1088.00,'2022-03-29 14:34:45','',''),(1656,'1','219','1',1,'Retail Sale Id 1744',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 14:45:25','',''),(1657,'1','219','1',1,'Retail Sale Id 1745',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 14:49:38','',''),(1658,'1','219','1',1,'Retail Sale Id 1746',999.60,0.00,0.00,1.47,99.96,'2022-03-29 14:51:08','',''),(1659,'1','219','1',1,'Retail Sale Id 1747',2998.80,0.00,0.00,4.41,299.88,'2022-03-29 14:59:00','',''),(1660,'1','219','1',1,'Retail Sale Id 1748',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 15:19:28','',''),(1661,'1','219','1',1,'Retail Sale Id 1749',1502.80,0.00,0.00,2.21,150.28,'2022-03-29 15:20:44','',''),(1662,'1','219','1',1,'Retail Sale Id 1750',503.20,0.00,0.00,0.74,50.32,'2022-03-29 16:33:45','',''),(1663,'1','219','1',1,'Retail Sale Id 1751',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 16:44:31','',''),(1664,'1','219','1',1,'Retail Sale Id 1752',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 16:54:03','',''),(1665,'1','219','1',1,'Retail Sale Id 1753',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 17:09:05','',''),(1666,'1','219','1',1,'Retail Sale Id 1754',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 17:12:44','',''),(1667,'1','219','1',1,'Retail Sale Id 1755',401.20,0.00,0.00,0.59,40.12,'2022-03-29 17:16:21','',''),(1668,'1','219','1',1,'Retail Sale Id 1755',401.20,0.00,0.00,0.59,40.12,'2022-03-29 17:16:21','',''),(1669,'1','219','1',1,'Retail Sale Id 1756',6800.00,0.00,0.00,10.00,680.00,'2022-03-29 17:43:16','',''),(1670,'1','219','1',1,'Retail Sale Id 1757',6800.00,0.00,0.00,10.00,680.00,'2022-03-29 17:45:59','',''),(1671,'1','219','1',1,'Retail Sale Id 1758',1999.20,0.00,0.00,2.94,199.92,'2022-03-29 17:47:22','',''),(1672,'1','219','1',1,'Retail Sale Id 1759',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 17:49:25','',''),(1673,'1','219','1',1,'Retail Sale Id 1760',6120.00,0.00,0.00,9.00,612.00,'2022-03-29 17:58:50','',''),(1674,'1','219','1',1,'Retail Sale Id 1761',1999.20,0.00,0.00,2.94,199.92,'2022-03-29 18:03:16','',''),(1675,'1','219','1',1,'Retail Sale Id 1762',598.40,0.00,0.00,0.88,59.84,'2022-03-29 18:08:01','',''),(1676,'1','219','1',1,'Retail Sale Id 1763',401.20,0.00,0.00,0.59,40.12,'2022-03-29 18:10:09','',''),(1677,'1','219','1',1,'Retail Sale Id 1764',401.20,0.00,0.00,0.59,40.12,'2022-03-29 18:11:15','',''),(1678,'1','219','1',1,'Retail Sale Id 1765',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 18:12:44','',''),(1679,'1','219','1',1,'Retail Sale Id 1766',2998.80,0.00,0.00,4.41,299.88,'2022-03-29 18:27:42','',''),(1680,'1','219','1',1,'Retail Sale Id 1768',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 18:34:06','',''),(1681,'1','219','1',1,'Retail Sale Id 1769',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 18:35:49','',''),(1682,'1','219','1',1,'Retail Sale Id 1770',700.40,0.00,0.00,1.03,70.04,'2022-03-29 18:38:52','',''),(1683,'1','219','1',1,'Return of Retail Sale Id 1756',0.00,6800.00,10.00,0.00,-680.00,'2022-03-29 23:18:07','',''),(1684,'1','219','1',1,'Retail Sale Id 1771',95.20,0.00,0.00,0.14,9.52,'2022-03-29 23:20:40','',''),(1685,'1','219','1',1,'Return of Retail Sale Id 1764',0.00,401.20,0.59,0.00,-40.12,'2022-03-29 23:24:23','',''),(1686,'1','219','1',1,'Retail Sale Id 1772',265.20,0.00,0.00,0.39,26.52,'2022-03-29 23:25:45','',''),(1687,'1','219','1',1,'Retail Sale Id 1773',5100.00,0.00,0.00,7.50,510.00,'2022-03-30 08:27:36','',''),(1688,'1','219','1',1,'Retail Sale Id 1774',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 08:47:14','',''),(1689,'1','219','1',1,'Retail Sale Id 1775',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 08:48:51','',''),(1690,'1','219','1',1,'Retail Sale Id 1776',2998.80,0.00,0.00,4.41,299.88,'2022-03-30 09:38:05','',''),(1691,'1','219','1',1,'Retail Sale Id 1778',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 09:53:30','',''),(1692,'1','219','1',1,'Retail Sale Id 1778',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 09:53:30','',''),(1693,'1','219','1',1,'Retail Sale Id 1779',4086.80,0.00,0.00,6.01,408.68,'2022-03-30 10:04:48','',''),(1694,'1','219','1',1,'Retail Sale Id 1780',503.20,0.00,0.00,0.74,50.32,'2022-03-30 10:25:59','',''),(1695,'1','219','1',1,'Retail Sale Id 1781',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 10:38:48','',''),(1696,'1','219','1',1,'Retail Sale Id 1782',3502.00,0.00,0.00,5.15,350.20,'2022-03-30 10:51:49','',''),(1697,'1','219','1',1,'Retail Sale Id 1783',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 10:55:06','',''),(1698,'1','219','1',1,'Retail Sale Id 1784',4753.20,0.00,0.00,6.99,475.32,'2022-03-30 10:57:22','',''),(1699,'1','219','1',1,'Retail Sale Id 1785',4998.00,0.00,0.00,7.35,499.80,'2022-03-30 11:02:28','',''),(1700,'1','219','1',1,'Retail Sale Id 1786',32100.00,0.00,0.00,50.00,1500.00,'2022-03-30 11:08:13','',''),(1701,'1','219','1',1,'Retail Sale Id 1787',6997.20,0.00,0.00,10.29,699.72,'2022-03-30 11:12:25','',''),(1702,'1','219','1',1,'Retail Sale Id 1788',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 11:15:09','',''),(1703,'1','219','1',1,'Retail Sale Id 1789',6800.00,0.00,0.00,10.00,680.00,'2022-03-30 11:20:03','',''),(1704,'1','219','1',1,'Retail Sale Id 1790',2448.00,0.00,0.00,3.60,244.80,'2022-03-30 11:21:28','',''),(1705,'1','219','1',1,'Retail Sale Id 1791',1196.80,0.00,0.00,1.76,119.68,'2022-03-30 11:28:15','',''),(1706,'1','219','1',1,'Retail Sale Id 1792',1999.20,0.00,0.00,2.94,199.92,'2022-03-30 11:39:14','',''),(1707,'1','219','1',1,'Retail Sale Id 1793',1999.20,0.00,0.00,2.94,199.92,'2022-03-30 11:48:36','',''),(1708,'1','219','1',1,'Retail Sale Id 1799',32100.00,0.00,0.00,50.00,1500.00,'2022-03-30 12:06:54','',''),(1709,'1','219','1',1,'Retail Sale Id 1800',2998.80,0.00,0.00,4.41,299.88,'2022-03-30 12:36:29','',''),(1710,'1','219','1',1,'Retail Sale Id 1801',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 12:48:04','',''),(1711,'1','219','1',1,'Retail Sale Id 1804',2298.40,0.00,0.00,3.38,229.84,'2022-03-30 13:31:34','',''),(1712,'1','219','1',1,'Retail Sale Id 1806',503.20,0.00,0.00,0.74,50.32,'2022-03-30 13:53:19','',''),(1713,'1','219','1',1,'Retail Sale Id 1807',6800.00,0.00,0.00,10.00,680.00,'2022-03-30 13:55:04','',''),(1714,'1','219','1',1,'Retail Sale Id 1808',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 14:02:20','',''),(1715,'1','219','1',1,'Retail Sale Id 1809',2046.80,0.00,0.00,3.01,204.68,'2022-03-30 14:04:10','',''),(1716,'1','219','1',1,'Retail Sale Id 1810',1999.20,0.00,0.00,2.94,199.92,'2022-03-30 14:17:00','',''),(1717,'1','219','1',1,'Retail Sale Id 1812',1502.80,0.00,0.00,2.21,150.28,'2022-03-30 14:48:27','',''),(1718,'1','219','1',1,'Retail Sale Id 1813',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 14:52:25','',''),(1719,'1','219','1',1,'Retail Sale Id 1814',4073.20,0.00,0.00,5.99,407.32,'2022-03-30 14:53:52','',''),(1720,'1','219','1',1,'Retail Sale Id 1815',5446.80,0.00,0.00,8.01,544.68,'2022-03-30 14:55:02','',''),(1721,'1','219','1',1,'Retail Sale Id 1816',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 15:01:39','',''),(1722,'1','219','1',1,'Retail Sale Id 1817',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 15:10:07','',''),(1723,'1','219','1',1,'Retail Sale Id 1818',2720.00,0.00,0.00,4.00,272.00,'2022-03-30 15:14:43','',''),(1724,'1','219','1',1,'Retail Sale Id 1819',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 15:15:29','',''),(1725,'1','219','1',1,'Retail Sale Id 1820',503.20,0.00,0.00,0.74,50.32,'2022-03-30 15:26:48','',''),(1726,'1','219','1',1,'Retail Sale Id 1821',1999.20,0.00,0.00,2.94,199.92,'2022-03-30 15:36:00','',''),(1727,'1','219','1',1,'Retail Sale Id 1822',3502.00,0.00,0.00,5.15,350.20,'2022-03-30 15:57:33','',''),(1728,'1','219','1',1,'Retail Sale Id 1823',6800.00,0.00,0.00,10.00,680.00,'2022-03-30 15:59:20','',''),(1729,'1','219','1',1,'Retail Sale Id 1824',6800.00,0.00,0.00,10.00,680.00,'2022-03-30 16:17:20','',''),(1730,'1','219','1',1,'Retail Sale Id 1825',1999.20,0.00,0.00,2.94,199.92,'2022-03-30 16:18:17','',''),(1731,'1','219','1',1,'Retail Sale Id 1826',1999.20,0.00,0.00,2.94,199.92,'2022-03-30 16:32:50','',''),(1732,'1','219','1',1,'Retail Sale Id 1827',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 16:37:19','',''),(1733,'1','219','1',1,'Retail Sale Id 1828',999.60,0.00,0.00,1.47,99.96,'2022-03-30 16:53:14','',''),(1734,'1','219','1',1,'Retail Sale Id 1829',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 16:54:57','',''),(1735,'1','219','1',1,'Retail Sale Id 1830',2720.00,0.00,0.00,4.00,272.00,'2022-03-30 16:56:40','',''),(1736,'1','219','1',1,'Retail Sale Id 1831',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 16:57:43','',''),(1737,'1','219','1',1,'Retail Sale Id 1832',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 17:19:36','',''),(1738,'1','219','1',1,'Retail Sale Id 1833',999.60,0.00,0.00,1.47,99.96,'2022-03-30 17:32:18','',''),(1739,'1','219','1',1,'Retail Sale Id 1834',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 17:46:39','',''),(1740,'1','219','1',1,'Retail Sale Id 1835',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 17:47:47','',''),(1741,'1','219','1',1,'Retail Sale Id 1836',2502.40,0.00,0.00,3.68,250.24,'2022-03-30 17:48:53','',''),(1742,'1','219','1',1,'Retail Sale Id 1837',1462.00,0.00,0.00,2.15,146.20,'2022-03-30 18:12:13','',''),(1743,'1','219','1',1,'Retail Sale Id 1838',503.20,0.00,0.00,0.74,50.32,'2022-03-30 18:15:02','',''),(1744,'1','219','1',1,'Retail Sale Id 1839',6420.00,0.00,0.00,10.00,300.00,'2022-03-30 18:18:50','',''),(1745,'1','219','1',1,'Retail Sale Id 1840',999.60,0.00,0.00,1.47,99.96,'2022-03-30 18:19:55','',''),(1746,'1','219','1',1,'Retail Sale Id 1841',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 18:24:32','',''),(1747,'1','219','1',1,'Retail Sale Id 1842',999.60,0.00,0.00,1.47,99.96,'2022-03-30 18:33:21','',''),(1748,'1','219','1',1,'Retail Sale Id 1843',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 18:42:35','',''),(1749,'1','219','1',1,'Retail Sale Id 1844',299.20,0.00,0.00,0.44,29.92,'2022-03-30 18:49:18','',''),(1750,'1','219','1',1,'Retail Sale Id 1845',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 19:02:36','',''),(1751,'1','219','1',1,'Retail Sale Id 1846',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 19:07:59','',''),(1752,'1','219','1',1,'Return of Retail Sale Id 1845',0.00,2040.00,3.00,0.00,-204.00,'2022-03-30 19:19:25','',''),(1753,'1','219','1',1,'Retail Sale Id 1847',1992.40,0.00,0.00,2.93,199.24,'2022-03-30 19:28:17','',''),(1754,'1','219','1',1,'Retail Sale Id 1848',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 19:38:46','',''),(1755,'1','219','1',1,'Return of Retail Sale Id 1846',0.00,3400.00,5.00,0.00,-340.00,'2022-03-30 19:40:04','',''),(1756,'1','219','1',1,'Retail Sale Id 1849',1400.80,0.00,0.00,2.06,140.08,'2022-03-30 19:41:09','',''),(1757,'1','219','1',1,'Retail Sale Id 1850',3200.00,0.00,0.00,5.00,100.00,'2022-03-31 07:46:52','',''),(1758,'1','219','1',1,'Retail Sale Id 1851',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 08:21:42','',''),(1759,'1','219','1',1,'Retail Sale Id 1852',2003.20,0.00,0.00,3.13,62.60,'2022-03-31 08:37:03','',''),(1760,'1','219','1',1,'Retail Sale Id 1853',1920.00,0.00,0.00,3.00,60.00,'2022-03-31 08:44:41','',''),(1761,'1','219','1',1,'Retail Sale Id 1854',7750.00,0.00,0.00,12.50,0.00,'2022-03-31 08:56:06','',''),(1762,'1','219','1',1,'Retail Sale Id 1855',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 08:57:14','',''),(1763,'1','219','1',1,'Retail Sale Id 1856',6400.00,0.00,0.00,10.00,200.00,'2022-03-31 08:59:37','',''),(1764,'1','219','1',1,'Retail Sale Id 1857',8000.00,0.00,0.00,12.50,250.00,'2022-03-31 09:02:24','',''),(1765,'1','219','1',1,'Retail Sale Id 1859',2003.20,0.00,0.00,3.13,62.60,'2022-03-31 09:13:02','',''),(1766,'1','219','1',1,'Retail Sale Id 1860',1920.00,0.00,0.00,3.00,60.00,'2022-03-31 09:19:29','',''),(1767,'1','219','1',1,'Retail Sale Id 1861',2297.60,0.00,0.00,3.59,71.80,'2022-03-31 09:24:52','',''),(1768,'1','219','1',1,'Retail Sale Id 1862',5120.00,0.00,0.00,8.00,160.00,'2022-03-31 09:35:01','',''),(1769,'1','219','1',1,'Retail Sale Id 1863',1920.00,0.00,0.00,3.00,60.00,'2022-03-31 09:38:42','',''),(1770,'1','219','1',1,'Retail Sale Id 1864',1920.00,0.00,0.00,3.00,60.00,'2022-03-31 09:40:13','',''),(1771,'1','219','1',1,'Retail Sale Id 1865',18600.00,0.00,0.00,30.00,0.00,'2022-03-31 09:45:59','',''),(1772,'1','219','1',1,'Retail Sale Id 1866',1920.00,0.00,0.00,3.00,60.00,'2022-03-31 09:47:47','',''),(1773,'1','219','1',1,'Retail Sale Id 1868',1920.00,0.00,0.00,3.00,60.00,'2022-03-31 10:00:48','',''),(1774,'1','219','1',1,'Retail Sale Id 1869',8000.00,0.00,0.00,12.50,250.00,'2022-03-31 10:11:34','',''),(1775,'1','219','1',1,'Retail Sale Id 1870',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 10:19:48','',''),(1776,'1','219','1',1,'Retail Sale Id 1871',2003.20,0.00,0.00,3.13,62.60,'2022-03-31 10:22:00','',''),(1777,'1','219','1',1,'Retail Sale Id 1872',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 10:51:08','',''),(1778,'1','219','1',1,'Retail Sale Id 1873',2003.20,0.00,0.00,3.13,62.60,'2022-03-31 10:55:04','',''),(1779,'1','219','1',1,'Retail Sale Id 1874',7440.00,0.00,0.00,12.00,0.00,'2022-03-31 11:03:21','',''),(1780,'1','219','1',1,'Retail Sale Id 1875',998.40,0.00,0.00,1.56,31.20,'2022-03-31 11:22:08','',''),(1781,'1','219','1',1,'Retail Sale Id 1876',4000.00,0.00,0.00,6.25,125.00,'2022-03-31 11:45:27','',''),(1782,'1','219','1',1,'Retail Sale Id 1877',3200.00,0.00,0.00,5.00,100.00,'2022-03-31 11:57:33','',''),(1783,'1','219','1',1,'Retail Sale Id 1877',8000.00,0.00,0.00,12.50,250.00,'2022-03-31 11:57:33','',''),(1784,'1','219','1',1,'Retail Sale Id 1878',998.40,0.00,0.00,1.56,31.20,'2022-03-31 12:00:31','',''),(1785,'1','219','1',1,'Retail Sale Id 1879',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 12:05:17','',''),(1786,'1','219','1',1,'Retail Sale Id 1879',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 12:05:17','',''),(1787,'1','219','1',1,'Retail Sale Id 1879',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 12:05:17','',''),(1788,'1','219','1',1,'Retail Sale Id 1880',6400.00,0.00,0.00,10.00,200.00,'2022-03-31 12:07:54','',''),(1789,'1','219','1',1,'Retail Sale Id 1881',2003.20,0.00,0.00,3.13,62.60,'2022-03-31 12:10:44','',''),(1790,'1','219','1',1,'Retail Sale Id 1882',2003.20,0.00,0.00,3.13,62.60,'2022-03-31 12:11:56','',''),(1791,'1','219','1',1,'Retail Sale Id 1883',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 12:13:24','',''),(1792,'1','219','1',1,'Retail Sale Id 1884',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 12:19:57','',''),(1793,'1','219','1',1,'Retail Sale Id 1885',6400.00,0.00,0.00,10.00,200.00,'2022-03-31 12:25:46','',''),(1794,'1','219','1',1,'Retail Sale Id 1887',3200.00,0.00,0.00,5.00,100.00,'2022-03-31 12:44:05','',''),(1795,'1','219','1',1,'Retail Sale Id 1888',8000.00,0.00,0.00,12.50,250.00,'2022-03-31 12:54:02','',''),(1796,'1','219','1',1,'Retail Sale Id 1889',2899.20,0.00,0.00,4.53,90.60,'2022-03-31 12:55:21','',''),(1797,'1','219','1',1,'Retail Sale Id 1891',8000.00,0.00,0.00,12.50,250.00,'2022-03-31 13:39:57','',''),(1798,'1','219','1',1,'Retail Sale Id 1892',4000.00,0.00,0.00,6.25,125.00,'2022-03-31 14:10:24','',''),(1799,'1','219','1',1,'Retail Sale Id 1893',1203.20,0.00,0.00,1.88,37.60,'2022-03-31 14:21:31','',''),(1800,'1','219','1',1,'Retail Sale Id 1894',403.20,0.00,0.00,0.63,12.60,'2022-03-31 14:28:03','',''),(1801,'1','219','1',1,'Retail Sale Id 1895',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 14:39:28','',''),(1802,'1','219','1',1,'Retail Sale Id 1896',3200.00,0.00,0.00,5.00,100.00,'2022-03-31 14:51:45','',''),(1803,'1','219','1',1,'Retail Sale Id 1897',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 14:54:24','',''),(1804,'1','219','1',1,'Retail Sale Id 1898',31000.00,0.00,0.00,50.00,0.00,'2022-03-31 14:59:13','',''),(1805,'1','219','1',1,'Retail Sale Id 1899',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 15:24:47','',''),(1806,'1','219','1',1,'Retail Sale Id 1900',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 15:25:37','',''),(1807,'1','219','1',1,'Retail Sale Id 1901',2598.40,0.00,0.00,4.06,81.20,'2022-03-31 15:40:30','',''),(1808,'1','219','1',1,'Retail Sale Id 1902',31000.00,0.00,0.00,50.00,0.00,'2022-03-31 15:43:10','',''),(1809,'1','219','1',1,'Retail Sale Id 1903',3200.00,0.00,0.00,5.00,100.00,'2022-03-31 15:49:27','',''),(1810,'1','219','1',1,'Retail Sale Id 1904',2003.20,0.00,0.00,3.13,62.60,'2022-03-31 15:56:35','',''),(1811,'1','219','1',1,'Retail Sale Id 1905',70680.00,0.00,0.00,114.00,0.00,'2022-03-31 16:04:27','',''),(1812,'1','219','1',1,'Retail Sale Id 1906',6400.00,0.00,0.00,10.00,200.00,'2022-03-31 16:07:26','',''),(1813,'1','219','1',1,'Retail Sale Id 1907',1497.60,0.00,0.00,2.34,46.80,'2022-03-31 16:08:56','',''),(1814,'1','219','1',1,'Retail Sale Id 1908',3200.00,0.00,0.00,5.00,100.00,'2022-03-31 16:14:25','',''),(1815,'1','219','1',1,'Retail Sale Id 1909',1497.60,0.00,0.00,2.34,46.80,'2022-03-31 16:17:20','',''),(1816,'1','219','1',1,'Retail Sale Id 1909',1497.60,0.00,0.00,2.34,46.80,'2022-03-31 16:17:20','',''),(1817,'1','219','1',1,'Retail Sale Id 1910',2003.20,0.00,0.00,3.13,62.60,'2022-03-31 16:19:23','',''),(1818,'1','219','1',1,'Retail Sale Id 1911',1203.20,0.00,0.00,1.88,37.60,'2022-03-31 16:24:38','',''),(1819,'1','219','1',1,'Retail Sale Id 1912',62000.00,0.00,0.00,100.00,0.00,'2022-03-31 16:27:11','',''),(1820,'1','219','1',1,'Retail Sale Id 1913',2502.40,0.00,0.00,3.91,78.20,'2022-03-31 16:30:31','',''),(1821,'1','219','1',1,'Retail Sale Id 1914',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 16:35:07','',''),(1822,'1','219','1',1,'Retail Sale Id 1914',8000.00,0.00,0.00,12.50,250.00,'2022-03-31 16:35:07','',''),(1823,'1','219','1',1,'Retail Sale Id 1915',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 16:37:55','',''),(1824,'1','219','1',1,'Retail Sale Id 1917',4000.00,0.00,0.00,6.25,125.00,'2022-03-31 16:40:54','',''),(1825,'1','219','1',1,'Retail Sale Id 1918',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 16:53:42','',''),(1826,'1','219','1',1,'Retail Sale Id 1919',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 16:55:57','',''),(1827,'1','219','1',1,'Retail Sale Id 1920',8000.00,0.00,0.00,12.50,250.00,'2022-03-31 16:58:38','',''),(1828,'1','219','1',1,'Retail Sale Id 1921',1920.00,0.00,0.00,3.00,60.00,'2022-03-31 17:01:22','',''),(1829,'1','219','1',1,'Retail Sale Id 1922',998.40,0.00,0.00,1.56,31.20,'2022-03-31 17:04:23','',''),(1830,'1','219','1',1,'Retail Sale Id 1923',7001.60,0.00,0.00,10.94,218.80,'2022-03-31 17:05:36','',''),(1831,'1','219','1',1,'Retail Sale Id 1924',6400.00,0.00,0.00,10.00,200.00,'2022-03-31 17:12:04','',''),(1832,'1','219','1',1,'Retail Sale Id 1925',1900.80,0.00,0.00,2.97,59.40,'2022-03-31 17:13:24','',''),(1833,'1','219','1',1,'Retail Sale Id 1926',403.20,0.00,0.00,0.63,12.60,'2022-03-31 17:29:54','',''),(1834,'1','219','1',1,'Retail Sale Id 1927',1920.00,0.00,0.00,3.00,60.00,'2022-03-31 17:34:04','',''),(1835,'1','219','1',1,'Retail Sale Id 1928',3001.60,0.00,0.00,4.69,93.80,'2022-03-31 17:35:16','',''),(1836,'1','219','1',1,'Retail Sale Id 1929',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 17:36:22','',''),(1837,'1','219','1',1,'Retail Sale Id 1930',3001.60,0.00,0.00,4.69,93.80,'2022-03-31 17:37:26','',''),(1838,'1','219','1',1,'Retail Sale Id 1931',2560.00,0.00,0.00,4.00,80.00,'2022-03-31 17:42:48','',''),(1839,'1','219','1',1,'Retail Sale Id 1932',998.40,0.00,0.00,1.56,31.20,'2022-03-31 17:44:00','',''),(1840,'1','219','1',1,'Retail Sale Id 1933',1920.00,0.00,0.00,3.00,60.00,'2022-03-31 18:00:06','',''),(1841,'1','219','1',1,'Retail Sale Id 1934',1203.20,0.00,0.00,1.88,37.60,'2022-03-31 18:06:20','',''),(1842,'1','219','1',1,'Retail Sale Id 1935',1497.60,0.00,0.00,2.34,46.80,'2022-03-31 18:11:32','',''),(1843,'1','219','1',1,'Retail Sale Id 1936',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 18:16:36','',''),(1844,'1','219','1',1,'Retail Sale Id 1937',3200.00,0.00,0.00,5.00,100.00,'2022-03-31 18:24:07','',''),(1845,'1','219','1',1,'Retail Sale Id 1938',800.00,0.00,0.00,1.25,25.00,'2022-03-31 18:27:46','',''),(1846,'1','219','1',1,'Retail Sale Id 1939',1497.60,0.00,0.00,2.34,46.80,'2022-03-31 18:28:55','',''),(1847,'1','219','1',1,'Retail Sale Id 1940',3200.00,0.00,0.00,5.00,100.00,'2022-03-31 18:32:24','',''),(1848,'1','219','1',1,'Retail Sale Id 1941',998.40,0.00,0.00,1.56,31.20,'2022-03-31 18:36:43','',''),(1849,'1','219','1',1,'Retail Sale Id 1942',300.80,0.00,0.00,0.47,9.40,'2022-03-31 18:39:16','',''),(1850,'1','219','1',1,'Retail Sale Id 1943',3840.00,0.00,0.00,6.00,120.00,'2022-03-31 18:46:47','',''),(1851,'1','219','1',1,'Retail Sale Id 1944',697.60,0.00,0.00,1.09,21.80,'2022-03-31 18:50:57','',''),(1852,'1','219','1',1,'Retail Sale Id 1945',1401.60,0.00,0.00,2.19,43.80,'2022-03-31 18:53:23','',''),(1853,'1','219','1',1,'Retail Sale Id 1946',1497.60,0.00,0.00,2.34,46.80,'2022-03-31 18:54:47','',''),(1854,'1','219','1',1,'Retail Sale Id 1947',1299.20,0.00,0.00,2.03,40.60,'2022-03-31 19:01:45','',''),(1855,'1','219','1',1,'Retail Sale Id 1948',83.20,0.00,0.00,0.13,2.60,'2022-03-31 22:02:49','',''),(1856,'1','219','1',1,'Return of Retail Sale Id 1942',0.00,300.80,0.47,0.00,-9.40,'2022-03-31 22:04:13','',''),(1857,'1','219','1',1,'Retail Sale Id 1949',96.00,0.00,0.00,0.15,3.00,'2022-03-31 22:05:41','',''),(1858,'1','219','1',1,'Retail Sale Id 1950',1798.40,0.00,0.00,2.81,56.20,'2022-04-01 08:01:57','',''),(1859,'1','219','1',1,'Retail Sale Id 1951',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 08:03:49','',''),(1860,'1','219','1',1,'Retail Sale Id 1952',8000.00,0.00,0.00,12.50,250.00,'2022-04-01 08:23:06','',''),(1861,'1','219','1',1,'Retail Sale Id 1953',8000.00,0.00,0.00,12.50,250.00,'2022-04-01 08:40:45','',''),(1862,'1','219','1',1,'Retail Sale Id 1954',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 08:45:10','',''),(1863,'1','219','1',1,'Retail Sale Id 1955',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 08:48:17','',''),(1864,'1','219','1',1,'Retail Sale Id 1956',3200.00,0.00,0.00,5.00,100.00,'2022-04-01 08:50:29','',''),(1865,'1','219','1',1,'Retail Sale Id 1957',3200.00,0.00,0.00,5.00,100.00,'2022-04-01 08:58:05','',''),(1866,'1','219','1',1,'Retail Sale Id 1957',3200.00,0.00,0.00,5.00,100.00,'2022-04-01 08:58:05','',''),(1867,'1','219','1',1,'Retail Sale Id 1957',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 08:58:05','',''),(1868,'1','219','1',1,'Retail Sale Id 1958',1920.00,0.00,0.00,3.00,60.00,'2022-04-01 08:59:52','',''),(1869,'1','219','1',1,'Retail Sale Id 1959',1497.60,0.00,0.00,2.34,46.80,'2022-04-01 09:18:08','',''),(1870,'1','219','1',1,'Retail Sale Id 1960',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 09:25:26','',''),(1871,'1','219','1',1,'Retail Sale Id 1962',6400.00,0.00,0.00,10.00,200.00,'2022-04-01 09:28:52','',''),(1872,'1','219','1',1,'Retail Sale Id 1963',8000.00,0.00,0.00,12.50,250.00,'2022-04-01 09:35:15','',''),(1873,'1','219','1',1,'Retail Sale Id 1967',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 09:39:12','',''),(1874,'1','219','1',1,'Retail Sale Id 1968',3200.00,0.00,0.00,5.00,100.00,'2022-04-01 09:43:19','',''),(1875,'1','219','1',1,'Retail Sale Id 1968',6400.00,0.00,0.00,10.00,200.00,'2022-04-01 09:43:19','',''),(1876,'1','219','1',1,'Retail Sale Id 1969',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 09:57:48','',''),(1877,'1','219','1',1,'Retail Sale Id 1970',5760.00,0.00,0.00,9.00,180.00,'2022-04-01 10:00:40','',''),(1878,'1','219','1',1,'Retail Sale Id 1971',31000.00,0.00,0.00,50.00,0.00,'2022-04-01 10:06:43','',''),(1879,'1','219','1',1,'Retail Sale Id 1972',31000.00,0.00,0.00,50.00,0.00,'2022-04-01 10:09:45','',''),(1880,'1','219','1',1,'Retail Sale Id 1973',8060.00,0.00,0.00,13.00,0.00,'2022-04-01 10:12:37','',''),(1881,'1','219','1',1,'Retail Sale Id 1974',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 10:22:45','',''),(1882,'1','219','1',1,'Retail Sale Id 1975',1920.00,0.00,0.00,3.00,60.00,'2022-04-01 10:25:31','',''),(1883,'1','219','1',1,'Retail Sale Id 1976',8000.00,0.00,0.00,12.50,250.00,'2022-04-01 10:35:38','',''),(1884,'1','219','1',1,'Retail Sale Id 1977',8000.00,0.00,0.00,12.50,250.00,'2022-04-01 10:36:31','',''),(1885,'1','219','1',1,'Retail Sale Id 1978',3852.80,0.00,0.00,6.02,120.40,'2022-04-01 10:43:12','',''),(1886,'1','219','1',1,'Retail Sale Id 1979',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 10:45:17','',''),(1887,'1','219','1',1,'Retail Sale Id 1980',6003.20,0.00,0.00,9.38,187.60,'2022-04-01 10:48:29','',''),(1888,'1','219','1',1,'Retail Sale Id 1981',10540.00,0.00,0.00,17.00,0.00,'2022-04-01 10:51:34','',''),(1889,'1','219','1',1,'Retail Sale Id 1982',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 10:57:06','',''),(1890,'1','219','1',1,'Retail Sale Id 1985',6400.00,0.00,0.00,10.00,200.00,'2022-04-01 11:26:36','',''),(1891,'1','219','1',1,'Retail Sale Id 1987',998.40,0.00,0.00,1.56,31.20,'2022-04-01 11:27:58','',''),(1892,'1','219','1',1,'Retail Sale Id 1988',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 11:32:01','',''),(1893,'1','219','1',1,'Retail Sale Id 1989',93000.00,0.00,0.00,150.00,0.00,'2022-04-01 11:38:16','',''),(1894,'1','219','1',1,'Retail Sale Id 1990',3500.80,0.00,0.00,5.47,109.40,'2022-04-01 11:39:54','',''),(1895,'1','219','1',1,'Retail Sale Id 1993',11520.00,0.00,0.00,18.00,360.00,'2022-04-01 11:41:32','',''),(1896,'1','219','1',1,'Retail Sale Id 1992',31000.00,0.00,0.00,50.00,0.00,'2022-04-01 11:41:33','',''),(1897,'1','219','1',1,'Retail Sale Id 1994',3200.00,0.00,0.00,5.00,100.00,'2022-04-01 11:42:03','',''),(1898,'1','219','1',1,'Retail Sale Id 1995',998.40,0.00,0.00,1.56,31.20,'2022-04-01 11:42:36','',''),(1899,'1','219','1',1,'Retail Sale Id 1996',1497.60,0.00,0.00,2.34,46.80,'2022-04-01 11:43:09','',''),(1900,'1','219','1',1,'Retail Sale Id 1997',4000.00,0.00,0.00,6.25,125.00,'2022-04-01 11:43:49','',''),(1901,'1','219','1',1,'Retail Sale Id 1998',3001.60,0.00,0.00,4.69,93.80,'2022-04-01 11:44:20','',''),(1902,'1','219','1',1,'Retail Sale Id 1999',2003.20,0.00,0.00,3.13,62.60,'2022-04-01 11:44:55','',''),(1903,'1','219','1',1,'Retail Sale Id 2000',4998.40,0.00,0.00,7.81,156.20,'2022-04-01 11:45:45','',''),(1904,'1','219','1',1,'Retail Sale Id 2001',2003.20,0.00,0.00,3.13,62.60,'2022-04-01 11:46:12','',''),(1905,'1','219','1',1,'Retail Sale Id 2002',3897.60,0.00,0.00,6.09,121.80,'2022-04-01 11:47:00','',''),(1906,'1','219','1',1,'Retail Sale Id 2003',3801.60,0.00,0.00,5.94,118.80,'2022-04-01 11:48:12','',''),(1907,'1','219','1',1,'Retail Sale Id 2004',1920.00,0.00,0.00,3.00,60.00,'2022-04-01 11:48:39','',''),(1908,'1','219','1',1,'Retail Sale Id 2005',1497.60,0.00,0.00,2.34,46.80,'2022-04-01 11:48:59','',''),(1909,'1','219','1',1,'Retail Sale Id 2006',2700.80,0.00,0.00,4.22,84.40,'2022-04-01 11:49:47','',''),(1910,'1','219','1',1,'Retail Sale Id 2007',3200.00,0.00,0.00,5.00,100.00,'2022-04-01 11:50:32','',''),(1911,'1','219','1',1,'Retail Sale Id 2008',3801.60,0.00,0.00,5.94,118.80,'2022-04-01 11:51:41','',''),(1912,'1','219','1',1,'Retail Sale Id 2009',2560.00,0.00,0.00,4.00,80.00,'2022-04-01 11:52:21','',''),(1913,'1','219','1',1,'Retail Sale Id 2010',3001.60,0.00,0.00,4.69,93.80,'2022-04-01 11:53:02','',''),(1914,'1','219','1',1,'Retail Sale Id 2011',8000.00,0.00,0.00,12.50,250.00,'2022-04-01 11:53:31','',''),(1915,'1','219','1',1,'Retail Sale Id 2013',4000.00,0.00,0.00,6.25,125.00,'2022-04-01 11:55:31','',''),(1916,'1','219','1',1,'Retail Sale Id 2012',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 11:55:35','',''),(1917,'1','219','1',1,'Retail Sale Id 2012',3840.00,0.00,0.00,6.00,120.00,'2022-04-01 11:55:35','',''),(1918,'1','219','1',1,'Retail Sale Id 2014',3200.00,0.00,0.00,5.00,100.00,'2022-04-01 11:56:55','',''),(1919,'1','219','1',1,'Retail Sale Id 2014',3200.00,0.00,0.00,5.00,100.00,'2022-04-01 11:56:55','',''),(1920,'1','219','1',1,'Retail Sale Id 2015',1920.00,0.00,0.00,3.00,60.00,'2022-04-01 11:57:59','',''),(1921,'1','219','1',1,'Retail Sale Id 2016',3200.00,0.00,0.00,5.00,100.00,'2022-04-01 11:59:04','',''),(1922,'1','219','1',1,'Retail Sale Id 2018',1299.20,0.00,0.00,2.03,40.60,'2022-04-01 12:00:25','',''),(1923,'1','219','1',1,'Return of Retail Sale Id 2018',0.00,1299.20,2.03,0.00,-40.60,'2022-04-01 13:52:14','',''),(1924,'1','219','1',1,'Return of Retail Sale Id 2016',0.00,3200.00,5.00,0.00,-100.00,'2022-04-01 13:52:55','',''),(1925,'1','219','1',1,'Return of Retail Sale Id 2015',0.00,1920.00,3.00,0.00,-60.00,'2022-04-01 13:53:27','',''),(1926,'1','219','1',1,'Return of Retail Sale Id 2014',0.00,3200.00,5.00,0.00,-100.00,'2022-04-01 13:54:11','',''),(1927,'1','219','1',1,'Return of Retail Sale Id 2014',0.00,3200.00,5.00,0.00,-100.00,'2022-04-01 13:54:11','',''),(1928,'1','219','1',1,'Return of Retail Sale Id 2013',0.00,4000.00,6.25,0.00,-125.00,'2022-04-01 13:55:10','',''),(1929,'1','219','1',1,'Return of Retail Sale Id 2011',0.00,8000.00,12.50,0.00,-250.00,'2022-04-01 13:56:35','',''),(1930,'1','219','1',1,'Return of Retail Sale Id 2010',0.00,3001.60,4.69,0.00,-93.80,'2022-04-01 13:57:12','',''),(1931,'1','219','1',1,'Return of Retail Sale Id 2008',0.00,3801.60,5.94,0.00,-118.80,'2022-04-01 13:57:55','',''),(1932,'1','219','1',1,'Return of Retail Sale Id 2007',0.00,3200.00,5.00,0.00,-100.00,'2022-04-01 13:59:00','',''),(1933,'1','219','1',1,'Return of Retail Sale Id 2006',0.00,2700.80,4.22,0.00,-84.40,'2022-04-01 13:59:31','',''),(1934,'1','219','1',1,'Return of Retail Sale Id 2005',0.00,1497.60,2.34,0.00,-46.80,'2022-04-01 14:00:04','',''),(1935,'1','219','1',1,'Return of Retail Sale Id 2003',0.00,3801.60,5.94,0.00,-118.80,'2022-04-01 14:00:53','',''),(1936,'1','219','1',1,'Return of Retail Sale Id 2002',0.00,3897.60,6.09,0.00,-121.80,'2022-04-01 14:01:33','',''),(1937,'1','219','1',1,'Return of Retail Sale Id 2001',0.00,2003.20,3.13,0.00,-62.60,'2022-04-01 14:23:18','',''),(1938,'1','219','1',1,'Return of Retail Sale Id 2000',0.00,4998.40,7.81,0.00,-156.20,'2022-04-01 14:25:52','',''),(1939,'1','219','1',1,'Return of Retail Sale Id 1998',0.00,3001.60,4.69,0.00,-93.80,'2022-04-01 14:26:42','',''),(1940,'1','219','1',1,'Return of Retail Sale Id 1999',0.00,2003.20,3.13,0.00,-62.60,'2022-04-01 14:27:56','',''),(1941,'1','219','1',1,'Return of Retail Sale Id 2012',0.00,3840.00,6.00,0.00,-120.00,'2022-04-01 14:29:56','',''),(1942,'1','219','1',1,'Return of Retail Sale Id 2012',0.00,3840.00,6.00,0.00,-120.00,'2022-04-01 14:29:56','',''),(1943,'1','219','1',1,'Return of Retail Sale Id 1970',0.00,5760.00,9.00,0.00,-180.00,'2022-04-01 14:31:06','',''),(1944,'1','219','1',1,'Return of Retail Sale Id 1968',0.00,3200.00,5.00,0.00,-100.00,'2022-04-01 14:31:50','',''),(1945,'1','219','1',1,'Return of Retail Sale Id 1968',0.00,6400.00,10.00,0.00,-200.00,'2022-04-01 14:31:50','',''),(1946,'1','219','1',1,'Retail Sale Id 2019',23040.00,0.00,0.00,36.00,720.00,'2022-04-01 14:33:43','',''),(1947,'1','219','1',1,'Retail Sale Id 2020',1337.60,0.00,0.00,2.09,41.80,'2022-04-01 14:35:19','',''),(1948,'1','219','1',1,'Return of Retail Sale Id 1993',0.00,11520.00,18.00,0.00,-360.00,'2022-04-01 14:37:21','',''),(1949,'1','219','1',1,'Return of Retail Sale Id 1990',0.00,3500.80,5.47,0.00,-109.40,'2022-04-01 14:39:28','',''),(1950,'1','219','1',1,'Return of Retail Sale Id 1994',0.00,3200.00,5.00,0.00,-100.00,'2022-04-01 14:40:30','',''),(1951,'1','219','1',1,'Return of Retail Sale Id 1997',0.00,4000.00,6.25,0.00,-125.00,'2022-04-01 14:41:36','',''),(1952,'1','219','1',1,'Return of Retail Sale Id 1996',0.00,1497.60,2.34,0.00,-46.80,'2022-04-01 14:42:52','',''),(1953,'1','219','1',1,'Return of Retail Sale Id 1995',0.00,998.40,1.56,0.00,-31.20,'2022-04-01 14:43:44','',''),(1954,'1','219','1',1,'Return of Retail Sale Id 1981',0.00,10540.00,17.00,0.00,0.00,'2022-04-01 14:45:10','',''),(1955,'1','219','1',1,'Retail Sale Id 2021',9969.60,0.00,0.00,16.08,0.00,'2022-04-01 14:46:36','',''),(1956,'1','219','1',1,'Distributed to OPERATIONAL LOST for sales id:4',81313.00,0.00,0.00,131.15,0.00,'2022-04-01 15:45:42','',''),(1957,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,3610188.00,5899.00,0.00,0.00,'2022-04-01 16:38:22','',''),(1958,'1','219',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,5899.00,0.00,'2022-04-01 16:40:39','',''),(1959,'1','219','1',1,'Received from bridging 4',0.00,0.00,5899.00,0.00,0.00,'2022-04-01 16:40:39','',''),(1960,'1','219','1',1,'Retail Sale Id 2022',2003.20,0.00,0.00,3.13,87.64,'2022-04-01 16:43:04','',''),(1961,'1','219','1',1,'Retail Sale Id 2023',1920.00,0.00,0.00,3.00,84.00,'2022-04-01 16:44:26','',''),(1962,'1','219','1',1,'Retail Sale Id 2023',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 16:44:26','',''),(1963,'1','219','1',1,'Retail Sale Id 2024',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 16:45:18','',''),(1964,'1','219','1',1,'Retail Sale Id 2025',499.20,0.00,0.00,0.78,21.84,'2022-04-01 16:46:04','',''),(1965,'1','219','1',1,'Retail Sale Id 2026',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 16:46:48','',''),(1966,'1','219','1',1,'Retail Sale Id 2027',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 16:48:26','',''),(1967,'1','219','1',1,'Retail Sale Id 2027',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 16:48:26','',''),(1968,'1','219','1',1,'Retail Sale Id 2028',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 16:49:27','',''),(1969,'1','219','1',1,'Retail Sale Id 2029',2003.20,0.00,0.00,3.13,87.64,'2022-04-01 16:50:09','',''),(1970,'1','219','1',1,'Retail Sale Id 2030',499.20,0.00,0.00,0.78,21.84,'2022-04-01 16:50:47','',''),(1971,'1','219','1',1,'Retail Sale Id 2031',3500.80,0.00,0.00,5.47,153.16,'2022-04-01 16:51:33','',''),(1972,'1','219','1',1,'Retail Sale Id 2032',1203.20,0.00,0.00,1.88,52.64,'2022-04-01 16:52:35','',''),(1973,'1','219','1',1,'Retail Sale Id 2032',8000.00,0.00,0.00,12.50,350.00,'2022-04-01 16:52:35','',''),(1974,'1','219','1',1,'Retail Sale Id 2033',1497.60,0.00,0.00,2.34,65.52,'2022-04-01 16:53:24','',''),(1975,'1','219','1',1,'Retail Sale Id 2034',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 16:55:59','',''),(1976,'1','219','1',1,'Retail Sale Id 2035',2560.00,0.00,0.00,4.00,112.00,'2022-04-01 16:56:43','',''),(1977,'1','219','1',1,'Retail Sale Id 2036',499.20,0.00,0.00,0.78,21.84,'2022-04-01 16:58:01','',''),(1978,'1','219','1',1,'Retail Sale Id 2037',8000.00,0.00,0.00,12.50,350.00,'2022-04-01 16:58:44','',''),(1979,'1','219','1',1,'Retail Sale Id 2039',2003.20,0.00,0.00,3.13,87.64,'2022-04-01 16:59:41','',''),(1980,'1','219','1',1,'Retail Sale Id 2040',5120.00,0.00,0.00,8.00,224.00,'2022-04-01 17:00:15','',''),(1981,'1','219','1',1,'Retail Sale Id 2041',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 17:00:50','',''),(1982,'1','219','1',1,'Retail Sale Id 2042',1920.00,0.00,0.00,3.00,84.00,'2022-04-01 17:01:26','',''),(1983,'1','219','1',1,'Retail Sale Id 2043',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 17:02:15','',''),(1984,'1','219','1',1,'Retail Sale Id 2044',31000.00,0.00,0.00,50.00,400.00,'2022-04-01 17:03:09','',''),(1985,'1','219','1',1,'Retail Sale Id 2045',8000.00,0.00,0.00,12.50,350.00,'2022-04-01 17:03:44','',''),(1986,'1','219','1',1,'Retail Sale Id 2046',8000.00,0.00,0.00,12.50,350.00,'2022-04-01 17:04:21','',''),(1987,'1','219','1',1,'Retail Sale Id 2047',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 17:07:01','',''),(1988,'1','219','1',1,'Retail Sale Id 2048',34100.00,0.00,0.00,55.00,440.00,'2022-04-01 17:15:28','',''),(1989,'1','219','1',1,'Retail Sale Id 2049',3852.80,0.00,0.00,6.02,168.56,'2022-04-01 17:17:00','',''),(1990,'1','219','1',1,'Retail Sale Id 2050',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 17:19:15','',''),(1991,'1','219','1',1,'Retail Sale Id 2051',1299.20,0.00,0.00,2.03,56.84,'2022-04-01 17:20:15','',''),(1992,'1','219','1',1,'Retail Sale Id 2052',31000.00,0.00,0.00,50.00,400.00,'2022-04-01 17:22:10','',''),(1993,'1','219','1',1,'Retail Sale Id 2053',4480.00,0.00,0.00,7.00,196.00,'2022-04-01 17:24:31','',''),(1994,'1','219','1',1,'Retail Sale Id 2054',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 17:25:35','',''),(1995,'1','219','1',1,'Retail Sale Id 2055',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 17:26:31','',''),(1996,'1','219','1',1,'Retail Sale Id 2056',998.40,0.00,0.00,1.56,43.68,'2022-04-01 17:27:30','',''),(1997,'1','219','1',1,'Retail Sale Id 2057',31000.00,0.00,0.00,50.00,400.00,'2022-04-01 17:38:50','',''),(1998,'1','219','1',1,'Retail Sale Id 2058',1920.00,0.00,0.00,3.00,84.00,'2022-04-01 17:47:40','',''),(1999,'1','219','1',1,'Retail Sale Id 2058',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 17:47:40','',''),(2000,'1','219','1',1,'Retail Sale Id 2059',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 17:49:16','',''),(2001,'1','219','1',1,'Retail Sale Id 2060',1280.00,0.00,0.00,2.00,56.00,'2022-04-01 17:56:16','',''),(2002,'1','219','1',1,'Retail Sale Id 2060',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 17:56:16','',''),(2003,'1','219','1',1,'Retail Sale Id 2061',19840.00,0.00,0.00,32.00,256.00,'2022-04-01 17:57:36','',''),(2004,'1','219','1',1,'Retail Sale Id 2062',998.40,0.00,0.00,1.56,43.68,'2022-04-01 17:59:46','',''),(2005,'1','219','1',1,'Retail Sale Id 2063',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 18:01:16','',''),(2006,'1','219','1',1,'Retail Sale Id 2064',2700.80,0.00,0.00,4.22,118.16,'2022-04-01 18:02:23','',''),(2007,'1','219','1',1,'Retail Sale Id 2065',1932.80,0.00,0.00,3.02,84.56,'2022-04-01 18:03:35','',''),(2008,'1','219','1',1,'Retail Sale Id 2066',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 18:07:26','',''),(2009,'1','219','1',1,'Retail Sale Id 2067',1497.60,0.00,0.00,2.34,65.52,'2022-04-01 18:08:25','',''),(2010,'1','219','1',1,'Retail Sale Id 2068',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 18:10:00','',''),(2011,'1','219','1',1,'Retail Sale Id 2069',4000.00,0.00,0.00,6.25,175.00,'2022-04-01 18:13:26','',''),(2012,'1','219','1',1,'Retail Sale Id 2070',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 18:14:38','',''),(2013,'1','219','1',1,'Retail Sale Id 2071',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 18:15:57','',''),(2014,'1','219','1',1,'Retail Sale Id 2072',998.40,0.00,0.00,1.56,43.68,'2022-04-01 18:16:53','',''),(2015,'1','219','1',1,'Retail Sale Id 2073',38440.00,0.00,0.00,62.00,496.00,'2022-04-01 18:18:15','',''),(2016,'1','219','1',1,'Retail Sale Id 2074',3001.60,0.00,0.00,4.69,131.32,'2022-04-01 18:19:10','',''),(2017,'1','219','1',1,'Retail Sale Id 2075',499.20,0.00,0.00,0.78,21.84,'2022-04-01 18:19:59','',''),(2018,'1','219','1',1,'Retail Sale Id 2076',697.60,0.00,0.00,1.09,30.52,'2022-04-01 18:20:56','',''),(2019,'1','219','1',1,'Retail Sale Id 2077',3001.60,0.00,0.00,4.69,131.32,'2022-04-01 18:23:15','',''),(2020,'1','219','1',1,'Retail Sale Id 2078',697.60,0.00,0.00,1.09,30.52,'2022-04-01 18:32:33','',''),(2021,'1','219','1',1,'Retail Sale Id 2079',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 18:33:42','',''),(2022,'1','219','1',1,'Retail Sale Id 2080',998.40,0.00,0.00,1.56,43.68,'2022-04-01 18:35:00','',''),(2023,'1','219','1',1,'Retail Sale Id 2080',3001.60,0.00,0.00,4.69,131.32,'2022-04-01 18:35:00','',''),(2024,'1','219','1',1,'Retail Sale Id 2081',17360.00,0.00,0.00,28.00,224.00,'2022-04-01 18:37:31','',''),(2025,'1','219','1',1,'Retail Sale Id 2082',124000.00,0.00,0.00,200.00,1600.00,'2022-04-01 18:41:01','',''),(2026,'1','219','1',1,'Retail Sale Id 2083',697.60,0.00,0.00,1.09,30.52,'2022-04-01 18:42:01','',''),(2027,'1','219','1',1,'Retail Sale Id 2084',3001.60,0.00,0.00,4.69,131.32,'2022-04-01 18:42:54','',''),(2028,'1','219','1',1,'Retail Sale Id 2085',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 18:43:46','',''),(2029,'1','219','1',1,'Retail Sale Id 2086',7440.00,0.00,0.00,12.00,96.00,'2022-04-01 18:45:41','',''),(2030,'1','219','1',1,'Retail Sale Id 2087',5120.00,0.00,0.00,8.00,224.00,'2022-04-01 18:47:13','',''),(2031,'1','219','1',1,'Retail Sale Id 2088',63860.00,0.00,0.00,103.00,824.00,'2022-04-01 18:48:55','',''),(2032,'1','219','1',1,'Retail Sale Id 2089',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 18:50:01','',''),(2033,'1','219','1',1,'Retail Sale Id 2090',11470.00,0.00,0.00,18.50,148.00,'2022-04-01 18:52:55','',''),(2034,'1','219','1',1,'Retail Sale Id 2091',300.80,0.00,0.00,0.47,13.16,'2022-04-01 18:57:08','',''),(2035,'1','219','1',1,'Retail Sale Id 2092',62000.00,0.00,0.00,100.00,800.00,'2022-04-01 18:59:59','',''),(2036,'1','219','1',1,'Retail Sale Id 2093',62000.00,0.00,0.00,100.00,800.00,'2022-04-01 19:00:54','',''),(2037,'1','219','1',1,'Retail Sale Id 2094',1900.80,0.00,0.00,2.97,83.16,'2022-04-01 19:01:39','',''),(2038,'1','219','1',1,'Retail Sale Id 2095',3200.00,0.00,0.00,5.00,140.00,'2022-04-01 19:07:18','',''),(2039,'1','219','1',1,'Retail Sale Id 2096',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 19:18:17','',''),(2040,'1','219','1',1,'Retail Sale Id 2097',1920.00,0.00,0.00,3.00,84.00,'2022-04-01 19:20:15','',''),(2041,'1','219','1',1,'Retail Sale Id 2098',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 19:21:13','',''),(2042,'1','219','1',1,'Retail Sale Id 2099',1280.00,0.00,0.00,2.00,56.00,'2022-04-01 19:26:58','',''),(2043,'1','219','1',1,'Retail Sale Id 2100',499.20,0.00,0.00,0.78,21.84,'2022-04-01 19:28:00','',''),(2044,'1','219','1',1,'Retail Sale Id 2101',3840.00,0.00,0.00,6.00,168.00,'2022-04-01 19:31:34','',''),(2045,'1','219','1',1,'Retail Sale Id 2102',2003.20,0.00,0.00,3.13,87.64,'2022-04-01 19:33:45','',''),(2046,'1','219','1',1,'Retail Sale Id 2103',1920.00,0.00,0.00,3.00,84.00,'2022-04-01 19:34:56','',''),(2047,'1','219','1',1,'Retail Sale Id 2104',2003.20,0.00,0.00,3.13,87.64,'2022-04-01 19:41:48','',''),(2048,'1','219','1',1,'Return of Retail Sale Id 2046',0.00,8000.00,12.50,0.00,-350.00,'2022-04-01 21:31:49','',''),(2049,'1','219','1',1,'Retail Sale Id 2105',499.20,0.00,0.00,0.78,21.84,'2022-04-01 21:33:12','',''),(2050,'1','219','1',1,'Retail Sale Id 2106',7494.40,0.00,0.00,11.71,327.88,'2022-04-01 21:34:24','',''),(2051,'1','219','1',1,'Return of Retail Sale Id 2082',0.00,124000.00,200.00,0.00,-1600.00,'2022-04-01 21:36:36','',''),(2052,'1','219','1',1,'Retail Sale Id 2107',44330.00,0.00,0.00,71.50,572.00,'2022-04-01 21:38:01','',''),(2053,'1','219','1',1,'Retail Sale Id 2108',35247.00,0.00,0.00,56.85,454.80,'2022-04-01 21:39:23','',''),(2054,'1','219','1',1,'Retail Sale Id 2109',44330.00,0.00,0.00,71.50,572.00,'2022-04-01 21:40:46','',''),(2055,'1','219','1',1,'Retail Sale Id 2110',31000.00,0.00,0.00,50.00,400.00,'2022-04-02 07:30:59','',''),(2056,'1','219','1',1,'Retail Sale Id 2111',4000.00,0.00,0.00,6.25,175.00,'2022-04-02 07:33:46','',''),(2057,'1','219','1',1,'Retail Sale Id 2112',31000.00,0.00,0.00,50.00,400.00,'2022-04-02 07:35:10','',''),(2058,'1','219','1',1,'Retail Sale Id 2113',93000.00,0.00,0.00,150.00,1200.00,'2022-04-02 07:39:33','',''),(2059,'1','219','1',1,'Retail Sale Id 2114',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 07:50:05','',''),(2060,'1','219','1',1,'Retail Sale Id 2115',4000.00,0.00,0.00,6.25,175.00,'2022-04-02 07:52:42','',''),(2061,'1','219','1',1,'Retail Sale Id 2116',3001.60,0.00,0.00,4.69,131.32,'2022-04-02 07:54:19','',''),(2062,'1','219','1',1,'Retail Sale Id 2117',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 07:55:32','',''),(2063,'1','219','1',1,'Retail Sale Id 2118',31000.00,0.00,0.00,50.00,400.00,'2022-04-02 07:57:12','',''),(2064,'1','219','1',1,'Retail Sale Id 2119',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 07:59:34','',''),(2065,'1','219','1',1,'Retail Sale Id 2120',70680.00,0.00,0.00,114.00,912.00,'2022-04-02 08:09:26','',''),(2066,'1','219','1',1,'Retail Sale Id 2121',217000.00,0.00,0.00,350.00,2800.00,'2022-04-02 08:16:46','',''),(2067,'1','219','1',1,'Retail Sale Id 2122',17484.00,0.00,0.00,28.20,225.60,'2022-04-02 08:21:26','',''),(2068,'1','219','1',1,'Retail Sale Id 2125',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 08:24:09','',''),(2069,'1','219','1',1,'Retail Sale Id 2126',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 08:25:08','',''),(2070,'1','219','1',1,'Retail Sale Id 2127',998.40,0.00,0.00,1.56,43.68,'2022-04-02 08:32:35','',''),(2071,'1','219','1',1,'Retail Sale Id 2128',1497.60,0.00,0.00,2.34,65.52,'2022-04-02 08:37:08','',''),(2072,'1','219','1',1,'Retail Sale Id 2129',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 08:38:33','',''),(2073,'1','219','1',1,'Retail Sale Id 2130',4998.40,0.00,0.00,7.81,218.68,'2022-04-02 08:53:37','',''),(2074,'1','219','1',1,'Retail Sale Id 2131',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 08:58:08','',''),(2075,'1','219','1',1,'Retail Sale Id 2132',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 08:59:19','',''),(2076,'1','219','1',1,'Retail Sale Id 2133',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 09:13:07','',''),(2077,'1','219','1',1,'Retail Sale Id 2134',3398.40,0.00,0.00,5.31,148.68,'2022-04-02 09:15:45','',''),(2078,'1','219','1',1,'Retail Sale Id 2135',8000.00,0.00,0.00,12.50,350.00,'2022-04-02 09:17:20','',''),(2079,'1','219','1',1,'Retail Sale Id 2136',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 09:19:34','',''),(2080,'1','219','1',1,'Retail Sale Id 2137',93000.00,0.00,0.00,150.00,1200.00,'2022-04-02 09:23:39','',''),(2081,'1','219','1',1,'Retail Sale Id 2138',7750.00,0.00,0.00,12.50,100.00,'2022-04-02 09:26:38','',''),(2082,'1','219','1',1,'Retail Sale Id 2139',29760.00,0.00,0.00,48.00,384.00,'2022-04-02 09:29:25','',''),(2083,'1','219','1',1,'Retail Sale Id 2140',1860.00,0.00,0.00,3.00,24.00,'2022-04-02 09:31:01','',''),(2084,'1','219','1',1,'Retail Sale Id 2141',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 09:32:34','',''),(2085,'1','219','1',1,'Retail Sale Id 2142',3001.60,0.00,0.00,4.69,131.32,'2022-04-02 09:33:43','',''),(2086,'1','219','1',1,'Retail Sale Id 2143',6720.00,0.00,0.00,10.50,294.00,'2022-04-02 09:34:42','',''),(2087,'1','219','1',1,'Retail Sale Id 2144',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 09:35:57','',''),(2088,'1','219','1',1,'Retail Sale Id 2145',5120.00,0.00,0.00,8.00,224.00,'2022-04-02 09:38:15','',''),(2089,'1','219','1',1,'Retail Sale Id 2146',1920.00,0.00,0.00,3.00,84.00,'2022-04-02 09:39:50','',''),(2090,'1','219','1',1,'Retail Sale Id 2147',6400.00,0.00,0.00,10.00,280.00,'2022-04-02 09:40:56','',''),(2091,'1','219','1',1,'Retail Sale Id 2148',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 09:43:42','',''),(2092,'1','219','1',1,'Retail Sale Id 2149',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 09:45:26','',''),(2093,'1','219','1',1,'Retail Sale Id 2150',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 09:46:54','',''),(2094,'1','219','1',1,'Retail Sale Id 2151',3001.60,0.00,0.00,4.69,131.32,'2022-04-02 09:47:58','',''),(2095,'1','219','1',1,'Retail Sale Id 2152',1500.40,0.00,0.00,2.42,19.36,'2022-04-02 09:50:09','',''),(2096,'1','219','1',1,'Retail Sale Id 2153',6400.00,0.00,0.00,10.00,280.00,'2022-04-02 09:51:16','',''),(2097,'1','219','1',1,'Retail Sale Id 2154',93000.00,0.00,0.00,150.00,1200.00,'2022-04-02 09:53:26','',''),(2098,'1','219','1',1,'Retail Sale Id 2155',124000.00,0.00,0.00,200.00,1600.00,'2022-04-02 09:55:26','',''),(2099,'1','219','1',1,'Retail Sale Id 2156',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 09:56:59','',''),(2100,'1','219','1',1,'Retail Sale Id 2157',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 09:57:54','',''),(2101,'1','219','1',1,'Retail Sale Id 2158',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 09:59:03','',''),(2102,'1','219','1',1,'Retail Sale Id 2159',7001.60,0.00,0.00,10.94,306.32,'2022-04-02 10:00:16','',''),(2103,'1','219','1',1,'Retail Sale Id 2160',3500.80,0.00,0.00,5.47,153.16,'2022-04-02 10:01:08','',''),(2104,'1','219','1',1,'Retail Sale Id 2161',1920.00,0.00,0.00,3.00,84.00,'2022-04-02 10:02:02','',''),(2105,'1','219','1',1,'Retail Sale Id 2162',1920.00,0.00,0.00,3.00,84.00,'2022-04-02 10:02:47','',''),(2106,'1','219','1',1,'Retail Sale Id 2163',8000.00,0.00,0.00,12.50,350.00,'2022-04-02 10:07:49','',''),(2107,'1','219','1',1,'Retail Sale Id 2164',1952.00,0.00,0.00,3.05,85.40,'2022-04-02 10:09:32','',''),(2108,'1','219','1',1,'Retail Sale Id 2165',1497.60,0.00,0.00,2.34,65.52,'2022-04-02 10:10:50','',''),(2109,'1','219','1',1,'Retail Sale Id 2165',1497.60,0.00,0.00,2.34,65.52,'2022-04-02 10:10:50','',''),(2110,'1','219','1',1,'Retail Sale Id 2166',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 10:11:54','',''),(2111,'1','219','1',1,'Retail Sale Id 2167',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 10:13:08','',''),(2112,'1','219','1',1,'Retail Sale Id 2168',62000.00,0.00,0.00,100.00,800.00,'2022-04-02 10:17:08','',''),(2113,'1','219','1',1,'Retail Sale Id 2169',69750.00,0.00,0.00,112.50,900.00,'2022-04-02 10:19:12','',''),(2114,'1','219','1',1,'Retail Sale Id 2170',31000.00,0.00,0.00,50.00,400.00,'2022-04-02 10:23:25','',''),(2115,'1','219','1',1,'Retail Sale Id 2171',40300.00,0.00,0.00,65.00,520.00,'2022-04-02 10:26:43','',''),(2116,'1','219','1',1,'Retail Sale Id 2172',27999.20,0.00,0.00,45.16,361.28,'2022-04-02 10:28:27','',''),(2117,'1','219','1',1,'Retail Sale Id 2173',4480.00,0.00,0.00,7.00,196.00,'2022-04-02 10:29:48','',''),(2118,'1','219','1',1,'Retail Sale Id 2174',2502.40,0.00,0.00,3.91,109.48,'2022-04-02 10:30:37','',''),(2119,'1','219','1',1,'Retail Sale Id 2175',2502.40,0.00,0.00,3.91,109.48,'2022-04-02 10:31:37','',''),(2120,'1','219','1',1,'Retail Sale Id 2176',1497.60,0.00,0.00,2.34,65.52,'2022-04-02 10:33:48','',''),(2121,'1','219','1',1,'Retail Sale Id 2176',1798.40,0.00,0.00,2.81,78.68,'2022-04-02 10:33:48','',''),(2122,'1','219','1',1,'Retail Sale Id 2176',2502.40,0.00,0.00,3.91,109.48,'2022-04-02 10:33:48','',''),(2123,'1','219','1',1,'Retail Sale Id 2177',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 10:35:19','',''),(2124,'1','219','1',1,'Retail Sale Id 2178',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 10:36:00','',''),(2125,'1','219','1',1,'Retail Sale Id 2179',7750.00,0.00,0.00,12.50,100.00,'2022-04-02 10:40:16','',''),(2126,'1','219','1',1,'Retail Sale Id 2180',54560.00,0.00,0.00,88.00,704.00,'2022-04-02 10:41:14','',''),(2127,'1','219','1',1,'Retail Sale Id 2181',31000.00,0.00,0.00,50.00,400.00,'2022-04-02 10:42:42','',''),(2128,'1','219','1',1,'Retail Sale Id 2182',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 10:43:46','',''),(2129,'1','219','1',1,'Retail Sale Id 2184',4998.40,0.00,0.00,7.81,218.68,'2022-04-02 10:46:17','',''),(2130,'1','219','1',1,'Retail Sale Id 2186',4030.00,0.00,0.00,6.50,52.00,'2022-04-02 10:48:01','',''),(2131,'1','219','1',1,'Retail Sale Id 2187',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 10:48:35','',''),(2132,'1','219','1',1,'Retail Sale Id 2191',1920.00,0.00,0.00,3.00,84.00,'2022-04-02 11:01:16','',''),(2133,'1','219','1',1,'Retail Sale Id 2191',8000.00,0.00,0.00,12.50,350.00,'2022-04-02 11:01:16','',''),(2134,'1','219','1',1,'Retail Sale Id 2192',1920.00,0.00,0.00,3.00,84.00,'2022-04-02 11:05:23','',''),(2135,'1','219','1',1,'Retail Sale Id 2192',1920.00,0.00,0.00,3.00,84.00,'2022-04-02 11:05:23','',''),(2136,'1','219','1',1,'Retail Sale Id 2193',1497.60,0.00,0.00,2.34,65.52,'2022-04-02 11:06:53','',''),(2137,'1','219','1',1,'Retail Sale Id 2194',8000.00,0.00,0.00,12.50,350.00,'2022-04-02 11:08:44','',''),(2138,'1','219','1',1,'Retail Sale Id 2195',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 11:09:58','',''),(2139,'1','219','1',1,'Retail Sale Id 2196',9300.00,0.00,0.00,15.00,120.00,'2022-04-02 11:12:01','',''),(2140,'1','219','1',1,'Retail Sale Id 2197',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 11:13:09','',''),(2141,'1','219','1',1,'Retail Sale Id 2198',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 11:14:22','',''),(2142,'1','219','1',1,'Retail Sale Id 2199',124000.00,0.00,0.00,200.00,1600.00,'2022-04-02 11:16:51','',''),(2143,'1','219','1',1,'Retail Sale Id 2200',1860.00,0.00,0.00,3.00,24.00,'2022-04-02 11:19:36','',''),(2144,'1','219','1',1,'Retail Sale Id 2201',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 11:22:33','',''),(2145,'1','219','1',1,'Retail Sale Id 2202',3852.80,0.00,0.00,6.02,168.56,'2022-04-02 11:25:28','',''),(2146,'1','219','1',1,'Retail Sale Id 2203',1920.00,0.00,0.00,3.00,84.00,'2022-04-02 11:27:43','',''),(2147,'1','219','1',1,'Retail Sale Id 2204',7040.00,0.00,0.00,11.00,308.00,'2022-04-02 11:28:45','',''),(2148,'1','219','1',1,'Retail Sale Id 2205',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 11:30:51','',''),(2149,'1','219','1',1,'Retail Sale Id 2206',31000.00,0.00,0.00,50.00,400.00,'2022-04-02 11:34:15','',''),(2150,'1','219','1',1,'Retail Sale Id 2207',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 11:42:38','',''),(2151,'1','219','1',1,'Retail Sale Id 2208',8000.00,0.00,0.00,12.50,350.00,'2022-04-02 11:46:34','',''),(2152,'1','219','1',1,'Retail Sale Id 2209',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 11:47:36','',''),(2153,'1','219','1',1,'Retail Sale Id 2210',13640.00,0.00,0.00,22.00,176.00,'2022-04-02 11:50:22','',''),(2154,'1','219','1',1,'Retail Sale Id 2211',262570.00,0.00,0.00,423.50,3388.00,'2022-04-02 11:52:45','',''),(2155,'1','219','1',1,'Retail Sale Id 2212',248000.00,0.00,0.00,400.00,3200.00,'2022-04-02 11:54:01','',''),(2156,'1','219','1',1,'Retail Sale Id 2213',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 11:56:40','',''),(2157,'1','219','1',1,'Retail Sale Id 2214',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 11:58:15','',''),(2158,'1','219','1',1,'Retail Sale Id 2215',1702.40,0.00,0.00,2.66,74.48,'2022-04-02 11:59:52','',''),(2159,'1','219','1',1,'Retail Sale Id 2216',93000.00,0.00,0.00,150.00,1200.00,'2022-04-02 12:00:55','',''),(2160,'1','219','1',1,'Retail Sale Id 2217',4998.40,0.00,0.00,7.81,218.68,'2022-04-02 12:02:21','',''),(2161,'1','219','1',1,'Retail Sale Id 2218',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 12:03:46','',''),(2162,'1','219','1',1,'Retail Sale Id 2219',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 12:08:08','',''),(2163,'1','219','1',1,'Retail Sale Id 2220',6400.00,0.00,0.00,10.00,280.00,'2022-04-02 12:09:23','',''),(2164,'1','219','1',1,'Retail Sale Id 2221',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 12:10:44','',''),(2165,'1','219','1',1,'Retail Sale Id 2222',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 12:15:00','',''),(2166,'1','219','1',1,'Retail Sale Id 2222',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 12:15:00','',''),(2167,'1','219','1',1,'Retail Sale Id 2223',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 12:16:37','',''),(2168,'1','219','1',1,'Retail Sale Id 2224',1900.80,0.00,0.00,2.97,83.16,'2022-04-02 12:18:29','',''),(2169,'1','219','1',1,'Retail Sale Id 2225',1497.60,0.00,0.00,2.34,65.52,'2022-04-02 12:19:24','',''),(2170,'1','219','1',1,'Retail Sale Id 2226',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 12:20:08','',''),(2171,'1','219','1',1,'Retail Sale Id 2227',93000.00,0.00,0.00,150.00,1200.00,'2022-04-02 12:21:34','',''),(2172,'1','219','1',1,'Retail Sale Id 2228',62000.00,0.00,0.00,100.00,800.00,'2022-04-02 12:22:35','',''),(2173,'1','219','1',1,'Retail Sale Id 2230',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 12:24:22','',''),(2174,'1','219','1',1,'Retail Sale Id 2231',6.40,0.00,0.00,0.01,0.28,'2022-04-02 12:32:34','',''),(2175,'1','219','1',1,'Retail Sale Id 2232',1920.00,0.00,0.00,3.00,84.00,'2022-04-02 12:34:16','',''),(2176,'1','219','1',1,'Retail Sale Id 2233',3001.60,0.00,0.00,4.69,131.32,'2022-04-02 12:36:45','',''),(2177,'1','219','1',1,'Retail Sale Id 2234',998.40,0.00,0.00,1.56,43.68,'2022-04-02 12:38:00','',''),(2178,'1','219','1',1,'Retail Sale Id 2234',7001.60,0.00,0.00,10.94,306.32,'2022-04-02 12:38:00','',''),(2179,'1','219','1',1,'Retail Sale Id 2235',93000.00,0.00,0.00,150.00,1200.00,'2022-04-02 12:39:53','',''),(2180,'1','219','1',1,'Retail Sale Id 2236',2880.00,0.00,0.00,4.50,126.00,'2022-04-02 12:40:48','',''),(2181,'1','219','1',1,'Retail Sale Id 2237',499.20,0.00,0.00,0.78,21.84,'2022-04-02 12:41:47','',''),(2182,'1','219','1',1,'Retail Sale Id 2238',31000.00,0.00,0.00,50.00,400.00,'2022-04-02 12:42:56','',''),(2183,'1','219','1',1,'Retail Sale Id 2239',50220.00,0.00,0.00,81.00,648.00,'2022-04-02 12:46:05','',''),(2184,'1','219','1',1,'Retail Sale Id 2240',31998.20,0.00,0.00,51.61,412.88,'2022-04-02 12:47:47','',''),(2185,'1','219','1',1,'Retail Sale Id 2241',3100.00,0.00,0.00,5.00,40.00,'2022-04-02 12:49:16','',''),(2186,'1','219','1',1,'Retail Sale Id 2242',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 12:50:19','',''),(2187,'1','219','1',1,'Retail Sale Id 2243',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 12:51:32','',''),(2188,'1','219','1',1,'Retail Sale Id 2244',31000.00,0.00,0.00,50.00,400.00,'2022-04-02 12:54:11','',''),(2189,'1','219','1',1,'Return of Retail Sale Id 2240',0.00,31998.20,51.61,0.00,-412.88,'2022-04-02 13:04:36','',''),(2190,'1','219','1',1,'Retail Sale Id 2245',4000.00,0.00,0.00,6.25,175.00,'2022-04-02 13:06:25','',''),(2191,'1','219','1',1,'Retail Sale Id 2246',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 13:07:52','',''),(2192,'1','219','1',1,'Retail Sale Id 2247',2502.40,0.00,0.00,3.91,109.48,'2022-04-02 13:14:37','',''),(2193,'1','219','1',1,'Retail Sale Id 2248',601.60,0.00,0.00,0.94,26.32,'2022-04-02 13:17:02','',''),(2194,'1','219','1',1,'Retail Sale Id 2250',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 13:18:37','',''),(2195,'1','219','1',1,'Retail Sale Id 2251',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 13:19:24','',''),(2196,'1','219','1',1,'Retail Sale Id 2252',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 13:20:42','',''),(2197,'1','219','1',1,'Retail Sale Id 2253',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 13:21:54','',''),(2198,'1','219','1',1,'Retail Sale Id 2253',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 13:21:54','',''),(2199,'1','219','1',1,'Retail Sale Id 2254',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 13:26:58','',''),(2200,'1','219','1',1,'Retail Sale Id 2255',3840.00,0.00,0.00,6.00,168.00,'2022-04-02 13:31:31','',''),(2201,'1','219','1',1,'Retail Sale Id 2256',2598.40,0.00,0.00,4.06,113.68,'2022-04-02 13:33:16','',''),(2202,'1','219','1',1,'Retail Sale Id 2257',1920.00,0.00,0.00,3.00,84.00,'2022-04-02 13:34:52','',''),(2203,'1','219','1',1,'Retail Sale Id 2258',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 13:36:07','',''),(2204,'1','219','1',1,'Retail Sale Id 2259',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 13:37:43','',''),(2205,'1','219','1',1,'Retail Sale Id 2260',8000.00,0.00,0.00,12.50,350.00,'2022-04-02 13:42:33','',''),(2206,'1','219','1',1,'Retail Sale Id 2261',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 13:46:47','',''),(2207,'1','219','1',1,'Retail Sale Id 2262',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 13:50:48','',''),(2208,'1','219','1',1,'Retail Sale Id 2263',8000.00,0.00,0.00,12.50,350.00,'2022-04-02 13:54:32','',''),(2209,'1','219','1',1,'Retail Sale Id 2264',4480.00,0.00,0.00,7.00,196.00,'2022-04-02 13:57:04','',''),(2210,'1','219','1',1,'Retail Sale Id 2265',1299.20,0.00,0.00,2.03,56.84,'2022-04-02 13:58:37','',''),(2211,'1','219','1',1,'Retail Sale Id 2266',8000.00,0.00,0.00,12.50,350.00,'2022-04-02 13:59:54','',''),(2212,'1','219','1',1,'Retail Sale Id 2267',998.40,0.00,0.00,1.56,43.68,'2022-04-02 14:03:19','',''),(2213,'1','219','1',1,'Retail Sale Id 2268',3200.00,0.00,0.00,5.00,140.00,'2022-04-02 14:04:39','',''),(2214,'1','219','1',1,'Retail Sale Id 2269',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 14:13:25','',''),(2215,'1','219','1',1,'Retail Sale Id 2270',1497.60,0.00,0.00,2.34,65.52,'2022-04-02 14:15:20','',''),(2216,'1','219','1',1,'Retail Sale Id 2270',1497.60,0.00,0.00,2.34,65.52,'2022-04-02 14:15:20','',''),(2217,'1','219','1',1,'Retail Sale Id 2271',32000.00,0.00,0.00,50.00,1400.00,'2022-04-02 14:17:10','',''),(2218,'1','219','1',1,'Retail Sale Id 2272',2003.20,0.00,0.00,3.13,87.64,'2022-04-02 14:19:50','',''),(2219,'1','219','1',1,'Retail Sale Id 2273',2560.00,0.00,0.00,4.00,112.00,'2022-04-02 14:21:44','',''),(2220,'1','219','1',1,'Retail Sale Id 2274',6400.00,0.00,0.00,10.00,280.00,'2022-04-02 14:23:46','',''),(2221,'1','219','1',1,'Retail Sale Id 2275',93000.00,0.00,0.00,150.00,1200.00,'2022-04-02 14:29:45','',''),(2222,'1','219','1',1,'Retail Sale Id 2276',22208.40,0.00,0.00,35.82,286.56,'2022-04-02 14:34:30','',''),(2223,'1','219','1',1,'Return of Retail Sale Id 2275',0.00,93000.00,150.00,0.00,-1200.00,'2022-04-02 14:41:02','',''),(2224,'1','219','1',1,'Retail Sale Id 2277',68131.80,0.00,0.00,109.89,879.12,'2022-04-02 14:42:04','',''),(2225,'1','219','1',1,'Return of Retail Sale Id 2271',0.00,32000.00,50.00,0.00,-1400.00,'2022-04-02 15:38:51','',''),(2226,'1','219','1',1,'Return of Retail Sale Id 2235',0.00,93000.00,150.00,0.00,-1200.00,'2022-04-02 15:46:24','',''),(2227,'1','219','1',1,'Retail Sale Id 2278',93000.00,0.00,0.00,150.00,1200.00,'2022-04-02 15:49:22','',''),(2228,'1','219','1',1,'Return of Retail Sale Id 2273',0.00,2560.00,4.00,0.00,-112.00,'2022-04-02 16:20:12','',''),(2229,'1','219','1',1,'Distributed to OPERATIONAL LOST for sales id:5',90606.60,0.00,0.00,148.05,0.00,'2022-04-02 17:57:30','',''),(2230,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,374544.00,612.00,0.00,0.00,'2022-04-02 18:06:04','',''),(2231,'1','219',NULL,1,'Returned purchase #6 to AA RANO NIG. LTD',374544.00,0.00,0.00,612.00,0.00,'2022-04-02 21:59:58','',''),(2232,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,3610188.00,5899.00,0.00,0.00,'2022-04-02 22:00:20','',''),(2233,'1','219',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,5899.00,0.00,'2022-04-02 22:02:13','',''),(2234,'1','219','1',1,'Received from bridging 7',0.00,0.00,5899.00,0.00,0.00,'2022-04-02 22:02:13','',''),(2235,'1','219','1',1,'Retail Sale Id 2279',185171.20,0.00,0.00,289.33,8101.24,'2022-04-02 22:19:15','',''),(2236,'1','219','1',1,'Retail Sale Id 2280',217223.20,0.00,0.00,350.36,2802.88,'2022-04-02 22:22:32','',''),(2237,'1','219','1',1,'Retail Sale Id 2281',132599.40,0.00,0.00,213.87,1710.96,'2022-04-02 22:40:42','',''),(2238,'1','219','1',1,'Retail Sale Id 2282',204618.60,0.00,0.00,330.03,2640.24,'2022-04-02 22:42:21','',''),(2239,'1','219','1',1,'Retail Sale Id 2283',31000.00,0.00,0.00,50.00,400.00,'2022-04-03 07:30:38','',''),(2240,'1','219','1',1,'Retail Sale Id 2284',1860.00,0.00,0.00,3.00,24.00,'2022-04-03 07:32:43','',''),(2241,'1','219','1',1,'Retail Sale Id 2285',31000.00,0.00,0.00,50.00,400.00,'2022-04-03 07:36:38','',''),(2242,'1','219','1',1,'Retail Sale Id 2286',32860.00,0.00,0.00,53.00,424.00,'2022-04-03 07:39:41','',''),(2243,'1','219','1',1,'Retail Sale Id 2287',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 07:40:53','',''),(2244,'1','219','1',1,'Retail Sale Id 2288',124000.00,0.00,0.00,200.00,1600.00,'2022-04-03 08:00:07','',''),(2245,'1','219','1',1,'Retail Sale Id 2289',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 08:18:04','',''),(2246,'1','219','1',1,'Retail Sale Id 2290',124000.00,0.00,0.00,200.00,1600.00,'2022-04-03 08:40:18','',''),(2247,'1','219','1',1,'Retail Sale Id 2291',139500.00,0.00,0.00,225.00,1800.00,'2022-04-03 08:42:38','',''),(2248,'1','219','1',1,'Retail Sale Id 2292',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 08:44:25','',''),(2249,'1','219','1',1,'Retail Sale Id 2293',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 08:45:42','',''),(2250,'1','219','1',1,'Retail Sale Id 2294',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 08:46:18','',''),(2251,'1','219','1',1,'Retail Sale Id 2295',1860.00,0.00,0.00,3.00,24.00,'2022-04-03 09:00:10','',''),(2252,'1','219','1',1,'Retail Sale Id 2296',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 09:09:58','',''),(2253,'1','219','1',1,'Retail Sale Id 2297',62000.00,0.00,0.00,100.00,800.00,'2022-04-03 09:11:50','',''),(2254,'1','219','1',1,'Retail Sale Id 2298',998.40,0.00,0.00,1.56,43.68,'2022-04-03 09:14:20','',''),(2255,'1','219','1',1,'Retail Sale Id 2299',62000.00,0.00,0.00,100.00,800.00,'2022-04-03 09:16:22','',''),(2256,'1','219','1',1,'Retail Sale Id 2300',124000.00,0.00,0.00,200.00,1600.00,'2022-04-03 09:18:35','',''),(2257,'1','219','1',1,'Retail Sale Id 2302',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 09:19:53','',''),(2258,'1','219','1',1,'Retail Sale Id 2303',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 09:25:04','',''),(2259,'1','219','1',1,'Retail Sale Id 2304',38440.00,0.00,0.00,62.00,496.00,'2022-04-03 09:29:17','',''),(2260,'1','219','1',1,'Retail Sale Id 2306',4000.00,0.00,0.00,6.25,175.00,'2022-04-03 09:33:45','',''),(2261,'1','219','1',1,'Retail Sale Id 2307',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 09:45:25','',''),(2262,'1','219','1',1,'Retail Sale Id 2308',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 09:46:00','',''),(2263,'1','219','1',1,'Retail Sale Id 2309',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 09:46:34','',''),(2264,'1','219','1',1,'Retail Sale Id 2310',1280.00,0.00,0.00,2.00,56.00,'2022-04-03 09:47:04','',''),(2265,'1','219','1',1,'Retail Sale Id 2311',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 09:47:37','',''),(2266,'1','219','1',1,'Retail Sale Id 2312',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 09:48:31','',''),(2267,'1','219','1',1,'Retail Sale Id 2313',93000.00,0.00,0.00,150.00,1200.00,'2022-04-03 09:49:17','',''),(2268,'1','219','1',1,'Retail Sale Id 2314',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 09:49:59','',''),(2269,'1','219','1',1,'Retail Sale Id 2315',1497.60,0.00,0.00,2.34,65.52,'2022-04-03 09:50:54','',''),(2270,'1','219','1',1,'Retail Sale Id 2316',1497.60,0.00,0.00,2.34,65.52,'2022-04-03 09:51:53','',''),(2271,'1','219','1',1,'Retail Sale Id 2318',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 09:56:26','',''),(2272,'1','219','1',1,'Retail Sale Id 2318',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 09:56:26','',''),(2273,'1','219','1',1,'Retail Sale Id 2319',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 10:03:39','',''),(2274,'1','219','1',1,'Retail Sale Id 2320',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 10:07:50','',''),(2275,'1','219','1',1,'Retail Sale Id 2321',62000.00,0.00,0.00,100.00,800.00,'2022-04-03 10:17:53','',''),(2276,'1','219','1',1,'Retail Sale Id 2322',7040.00,0.00,0.00,11.00,308.00,'2022-04-03 10:19:56','',''),(2277,'1','219','1',1,'Retail Sale Id 2323',7040.00,0.00,0.00,11.00,308.00,'2022-04-03 10:21:20','',''),(2278,'1','219','1',1,'Retail Sale Id 2324',3500.80,0.00,0.00,5.47,153.16,'2022-04-03 10:22:52','',''),(2279,'1','219','1',1,'Retail Sale Id 2325',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 10:24:08','',''),(2280,'1','219','1',1,'Retail Sale Id 2326',3001.60,0.00,0.00,4.69,131.32,'2022-04-03 10:25:02','',''),(2281,'1','219','1',1,'Retail Sale Id 2327',3852.80,0.00,0.00,6.02,168.56,'2022-04-03 10:29:19','',''),(2282,'1','219','1',1,'Retail Sale Id 2328',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 10:30:15','',''),(2283,'1','219','1',1,'Retail Sale Id 2329',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 10:32:44','',''),(2284,'1','219','1',1,'Retail Sale Id 2330',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 10:37:18','',''),(2285,'1','219','1',1,'Retail Sale Id 2330',7680.00,0.00,0.00,12.00,336.00,'2022-04-03 10:37:18','',''),(2286,'1','219','1',1,'Retail Sale Id 2331',1299.20,0.00,0.00,2.03,56.84,'2022-04-03 10:40:01','',''),(2287,'1','219','1',1,'Retail Sale Id 2331',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 10:40:01','',''),(2288,'1','219','1',1,'Retail Sale Id 2332',1900.80,0.00,0.00,2.97,83.16,'2022-04-03 10:41:34','',''),(2289,'1','219','1',1,'Retail Sale Id 2333',2502.40,0.00,0.00,3.91,109.48,'2022-04-03 10:53:17','',''),(2290,'1','219','1',1,'Retail Sale Id 2335',4000.00,0.00,0.00,6.25,175.00,'2022-04-03 11:01:02','',''),(2291,'1','219','1',1,'Retail Sale Id 2336',31000.00,0.00,0.00,50.00,400.00,'2022-04-03 11:03:09','',''),(2292,'1','219','1',1,'Retail Sale Id 2337',2003.20,0.00,0.00,3.13,87.64,'2022-04-03 11:04:23','',''),(2293,'1','219','1',1,'Retail Sale Id 2338',499.20,0.00,0.00,0.78,21.84,'2022-04-03 11:05:07','',''),(2294,'1','219','1',1,'Retail Sale Id 2339',3852.80,0.00,0.00,6.02,168.56,'2022-04-03 11:22:32','',''),(2295,'1','219','1',1,'Retail Sale Id 2340',998.40,0.00,0.00,1.56,43.68,'2022-04-03 11:24:16','',''),(2296,'1','219','1',1,'Retail Sale Id 2340',2003.20,0.00,0.00,3.13,87.64,'2022-04-03 11:24:16','',''),(2297,'1','219','1',1,'Retail Sale Id 2341',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 11:27:25','',''),(2298,'1','219','1',1,'Retail Sale Id 2342',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 11:28:33','',''),(2299,'1','219','1',1,'Retail Sale Id 2343',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 11:31:16','',''),(2300,'1','219','1',1,'Retail Sale Id 2344',5499.40,0.00,0.00,8.87,70.96,'2022-04-03 11:35:48','',''),(2301,'1','219','1',1,'Retail Sale Id 2345',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 11:40:12','',''),(2302,'1','219','1',1,'Retail Sale Id 2346',998.40,0.00,0.00,1.56,43.68,'2022-04-03 11:43:31','',''),(2303,'1','219','1',1,'Retail Sale Id 2347',5120.00,0.00,0.00,8.00,224.00,'2022-04-03 11:45:37','',''),(2304,'1','219','1',1,'Retail Sale Id 2348',2003.20,0.00,0.00,3.13,87.64,'2022-04-03 11:53:26','',''),(2305,'1','219','1',1,'Retail Sale Id 2349',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 11:57:51','',''),(2306,'1','219','1',1,'Retail Sale Id 2350',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 12:00:36','',''),(2307,'1','219','1',1,'Retail Sale Id 2351',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 12:04:10','',''),(2308,'1','219','1',1,'Retail Sale Id 2353',3852.80,0.00,0.00,6.02,168.56,'2022-04-03 12:08:24','',''),(2309,'1','219','1',1,'Retail Sale Id 2354',9920.00,0.00,0.00,16.00,128.00,'2022-04-03 12:10:14','',''),(2310,'1','219','1',1,'Retail Sale Id 2356',1299.20,0.00,0.00,2.03,56.84,'2022-04-03 12:15:05','',''),(2311,'1','219','1',1,'Retail Sale Id 2357',17050.00,0.00,0.00,27.50,220.00,'2022-04-03 12:16:22','',''),(2312,'1','219','1',1,'Retail Sale Id 2358',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 12:24:30','',''),(2313,'1','219','1',1,'Retail Sale Id 2358',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 12:24:30','',''),(2314,'1','219','1',1,'Retail Sale Id 2358',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 12:24:30','',''),(2315,'1','219','1',1,'Retail Sale Id 2359',998.40,0.00,0.00,1.56,43.68,'2022-04-03 12:25:51','',''),(2316,'1','219','1',1,'Retail Sale Id 2360',62000.00,0.00,0.00,100.00,800.00,'2022-04-03 12:29:23','',''),(2317,'1','219','1',1,'Retail Sale Id 2361',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 12:30:26','',''),(2318,'1','219','1',1,'Retail Sale Id 2362',3852.80,0.00,0.00,6.02,168.56,'2022-04-03 12:31:56','',''),(2319,'1','219','1',1,'Retail Sale Id 2363',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 12:35:43','',''),(2320,'1','219','1',1,'Retail Sale Id 2364',998.40,0.00,0.00,1.56,43.68,'2022-04-03 12:38:13','',''),(2321,'1','219','1',1,'Retail Sale Id 2365',186000.00,0.00,0.00,300.00,2400.00,'2022-04-03 12:43:55','',''),(2322,'1','219','1',1,'Retail Sale Id 2367',220720.00,0.00,0.00,356.00,2848.00,'2022-04-03 12:45:38','',''),(2323,'1','219','1',1,'Retail Sale Id 2368',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 12:53:04','',''),(2324,'1','219','1',1,'Retail Sale Id 2369',93000.00,0.00,0.00,150.00,1200.00,'2022-04-03 12:59:15','',''),(2325,'1','219','1',1,'Retail Sale Id 2370',3852.80,0.00,0.00,6.02,168.56,'2022-04-03 13:02:33','',''),(2326,'1','219','1',1,'Retail Sale Id 2372',102.40,0.00,0.00,0.16,4.48,'2022-04-03 13:13:15','',''),(2327,'1','219','1',1,'Retail Sale Id 2373',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 13:18:12','',''),(2328,'1','219','1',1,'Retail Sale Id 2373',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 13:18:12','',''),(2329,'1','219','1',1,'Retail Sale Id 2373',6400.00,0.00,0.00,10.00,280.00,'2022-04-03 13:18:12','',''),(2330,'1','219','1',1,'Retail Sale Id 2373',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 13:18:12','',''),(2331,'1','219','1',1,'Retail Sale Id 2374',998.40,0.00,0.00,1.56,43.68,'2022-04-03 13:19:46','',''),(2332,'1','219','1',1,'Retail Sale Id 2375',3001.60,0.00,0.00,4.69,131.32,'2022-04-03 13:29:53','',''),(2333,'1','219','1',1,'Retail Sale Id 2375',4998.40,0.00,0.00,7.81,218.68,'2022-04-03 13:29:53','',''),(2334,'1','219','1',1,'Retail Sale Id 2376',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 13:33:52','',''),(2335,'1','219','1',1,'Retail Sale Id 2376',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 13:33:52','',''),(2336,'1','219','1',1,'Retail Sale Id 2377',3100.00,0.00,0.00,5.00,40.00,'2022-04-03 13:53:52','',''),(2337,'1','219','1',1,'Retail Sale Id 2378',1860.00,0.00,0.00,3.00,24.00,'2022-04-03 13:56:57','',''),(2338,'1','219','1',1,'Retail Sale Id 2379',2099.20,0.00,0.00,3.28,91.84,'2022-04-03 14:00:36','',''),(2339,'1','219','1',1,'Retail Sale Id 2380',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 14:01:34','',''),(2340,'1','219','1',1,'Retail Sale Id 2381',3001.60,0.00,0.00,4.69,131.32,'2022-04-03 14:02:23','',''),(2341,'1','219','1',1,'Retail Sale Id 2382',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 14:03:32','',''),(2342,'1','219','1',1,'Retail Sale Id 2383',1497.60,0.00,0.00,2.34,65.52,'2022-04-03 14:18:53','',''),(2343,'1','219','1',1,'Retail Sale Id 2384',7440.00,0.00,0.00,12.00,96.00,'2022-04-03 14:24:58','',''),(2344,'1','219','1',1,'Retail Sale Id 2385',31000.00,0.00,0.00,50.00,400.00,'2022-04-03 14:28:13','',''),(2345,'1','219','1',1,'Retail Sale Id 2386',134850.00,0.00,0.00,217.50,1740.00,'2022-04-03 14:31:05','',''),(2346,'1','219','1',1,'Retail Sale Id 2387',13640.00,0.00,0.00,22.00,176.00,'2022-04-03 14:39:28','',''),(2347,'1','219','1',1,'Retail Sale Id 2388',3100.00,0.00,0.00,5.00,40.00,'2022-04-03 14:41:36','',''),(2348,'1','219','1',1,'Retail Sale Id 2389',3001.60,0.00,0.00,4.69,131.32,'2022-04-03 14:43:52','',''),(2349,'1','219','1',1,'Retail Sale Id 2390',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 14:46:38','',''),(2350,'1','219','1',1,'Retail Sale Id 2391',998.40,0.00,0.00,1.56,43.68,'2022-04-03 14:48:01','',''),(2351,'1','219','1',1,'Retail Sale Id 2392',3801.60,0.00,0.00,5.94,166.32,'2022-04-03 14:59:59','',''),(2352,'1','219','1',1,'Retail Sale Id 2393',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 15:06:24','',''),(2353,'1','219','1',1,'Retail Sale Id 2394',2003.20,0.00,0.00,3.13,87.64,'2022-04-03 15:14:45','',''),(2354,'1','219','1',1,'Retail Sale Id 2397',1299.20,0.00,0.00,2.03,56.84,'2022-04-03 15:48:16','',''),(2355,'1','219','1',1,'Retail Sale Id 2398',3852.80,0.00,0.00,6.02,168.56,'2022-04-03 15:49:29','',''),(2356,'1','219','1',1,'Retail Sale Id 2399',499.20,0.00,0.00,0.78,21.84,'2022-04-03 15:50:22','',''),(2357,'1','219','1',1,'Retail Sale Id 2400',998.40,0.00,0.00,1.56,43.68,'2022-04-03 16:17:22','',''),(2358,'1','219','1',1,'Retail Sale Id 2401',2003.20,0.00,0.00,3.13,87.64,'2022-04-03 16:36:22','',''),(2359,'1','219','1',1,'Retail Sale Id 2402',4000.00,0.00,0.00,6.25,175.00,'2022-04-03 16:47:22','',''),(2360,'1','219','1',1,'Retail Sale Id 2403',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 16:56:04','',''),(2361,'1','219','1',1,'Retail Sale Id 2404',7680.00,0.00,0.00,12.00,336.00,'2022-04-03 17:07:49','',''),(2362,'1','219','1',1,'Retail Sale Id 2405',1497.60,0.00,0.00,2.34,65.52,'2022-04-03 17:09:04','',''),(2363,'1','219','1',1,'Retail Sale Id 2406',499.20,0.00,0.00,0.78,21.84,'2022-04-03 17:12:15','',''),(2364,'1','219','1',1,'Retail Sale Id 2407',800.00,0.00,0.00,1.25,35.00,'2022-04-03 17:13:22','',''),(2365,'1','219','1',1,'Retail Sale Id 2409',1280.00,0.00,0.00,2.00,56.00,'2022-04-03 17:16:56','',''),(2366,'1','219','1',1,'Retail Sale Id 2410',902.40,0.00,0.00,1.41,39.48,'2022-04-03 17:18:06','',''),(2367,'1','219','1',1,'Retail Sale Id 2411',1497.60,0.00,0.00,2.34,65.52,'2022-04-03 17:19:01','',''),(2368,'1','219','1',1,'Retail Sale Id 2412',4000.00,0.00,0.00,6.25,175.00,'2022-04-03 17:19:56','',''),(2369,'1','219','1',1,'Retail Sale Id 2413',3500.80,0.00,0.00,5.47,153.16,'2022-04-03 17:20:57','',''),(2370,'1','219','1',1,'Retail Sale Id 2414',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 17:26:29','',''),(2371,'1','219','1',1,'Retail Sale Id 2415',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 17:31:07','',''),(2372,'1','219','1',1,'Retail Sale Id 2416',7440.00,0.00,0.00,12.00,96.00,'2022-04-03 17:35:48','',''),(2373,'1','219','1',1,'Retail Sale Id 2417',3840.00,0.00,0.00,6.00,168.00,'2022-04-03 17:38:22','',''),(2374,'1','219','1',1,'Retail Sale Id 2418',697.60,0.00,0.00,1.09,30.52,'2022-04-03 17:39:14','',''),(2375,'1','219','1',1,'Retail Sale Id 2419',3200.00,0.00,0.00,5.00,140.00,'2022-04-03 17:41:49','',''),(2376,'1','219','1',1,'Retail Sale Id 2420',3603.20,0.00,0.00,5.63,157.64,'2022-04-03 17:44:08','',''),(2377,'1','219','1',1,'Retail Sale Id 2421',2560.00,0.00,0.00,4.00,112.00,'2022-04-03 17:46:37','',''),(2378,'1','219','1',1,'Retail Sale Id 2422',2560.00,0.00,0.00,4.00,112.00,'2022-04-03 17:47:52','',''),(2379,'1','219','1',1,'Retail Sale Id 2423',6400.00,0.00,0.00,10.00,280.00,'2022-04-03 17:51:49','',''),(2380,'1','219','1',1,'Retail Sale Id 2424',998.40,0.00,0.00,1.56,43.68,'2022-04-03 18:01:42','',''),(2381,'1','219','1',1,'Retail Sale Id 2425',31000.00,0.00,0.00,50.00,400.00,'2022-04-03 18:07:19','',''),(2382,'1','219','1',1,'Retail Sale Id 2426',8000.00,0.00,0.00,12.50,350.00,'2022-04-03 18:08:26','',''),(2383,'1','219','1',1,'Retail Sale Id 2427',998.40,0.00,0.00,1.56,43.68,'2022-04-03 18:09:50','',''),(2384,'1','219','1',1,'Retail Sale Id 2428',1920.00,0.00,0.00,3.00,84.00,'2022-04-03 18:10:36','',''),(2385,'1','219','1',1,'Retail Sale Id 2429',31000.00,0.00,0.00,50.00,400.00,'2022-04-03 18:14:47','',''),(2386,'1','219','1',1,'Retail Sale Id 2432',403.20,0.00,0.00,0.63,17.64,'2022-04-03 18:24:12','',''),(2387,'1','219','1',1,'Return of Retail Sale Id 2373',0.00,3840.00,6.00,0.00,-168.00,'2022-04-03 20:57:00','',''),(2388,'1','219','1',1,'Return of Retail Sale Id 2373',0.00,3840.00,6.00,0.00,-168.00,'2022-04-03 20:57:00','',''),(2389,'1','219','1',1,'Return of Retail Sale Id 2373',0.00,6400.00,10.00,0.00,-280.00,'2022-04-03 20:57:00','',''),(2390,'1','219','1',1,'Return of Retail Sale Id 2373',0.00,8000.00,12.50,0.00,-350.00,'2022-04-03 20:57:00','',''),(2391,'1','219','1',1,'Return of Retail Sale Id 2417',0.00,3840.00,6.00,0.00,-168.00,'2022-04-03 21:04:04','',''),(2392,'1','219','1',1,'Return of Retail Sale Id 2409',0.00,1280.00,2.00,0.00,-56.00,'2022-04-03 21:05:28','',''),(2393,'1','219','1',1,'Return of Retail Sale Id 2421',0.00,2560.00,4.00,0.00,-112.00,'2022-04-03 21:06:47','',''),(2394,'1','219','1',1,'Return of Retail Sale Id 2419',0.00,3200.00,5.00,0.00,-140.00,'2022-04-03 21:09:47','',''),(2395,'1','219','1',1,'Return of Retail Sale Id 2382',0.00,3840.00,6.00,0.00,-168.00,'2022-04-03 21:14:12','',''),(2396,'1','219','1',1,'Return of Retail Sale Id 2380',0.00,3200.00,5.00,0.00,-140.00,'2022-04-03 21:15:01','',''),(2397,'1','219','1',1,'Return of Retail Sale Id 2376',0.00,3840.00,6.00,0.00,-168.00,'2022-04-03 21:16:06','',''),(2398,'1','219','1',1,'Return of Retail Sale Id 2376',0.00,3840.00,6.00,0.00,-168.00,'2022-04-03 21:16:06','',''),(2399,'1','219','1',1,'Return of Retail Sale Id 2351',0.00,3840.00,6.00,0.00,-168.00,'2022-04-03 21:17:28','',''),(2400,'1','219','1',1,'Return of Retail Sale Id 2350',0.00,3840.00,6.00,0.00,-168.00,'2022-04-03 21:24:55','',''),(2401,'1','219','1',1,'Return of Retail Sale Id 2330',0.00,1920.00,3.00,0.00,-84.00,'2022-04-03 21:26:36','',''),(2402,'1','219','1',1,'Return of Retail Sale Id 2330',0.00,7680.00,12.00,0.00,-336.00,'2022-04-03 21:26:36','',''),(2403,'1','219','1',1,'Retail Sale Id 2433',5094.40,0.00,0.00,7.96,222.88,'2022-04-03 21:28:20','',''),(2404,'1','219','1',1,'Retail Sale Id 2434',1792.00,0.00,0.00,2.80,78.40,'2022-04-03 21:29:57','',''),(2405,'1','219','1',1,'Return of Retail Sale Id 2386',0.00,134850.00,217.50,0.00,-1740.00,'2022-04-03 21:33:29','',''),(2406,'1','219','1',1,'Retail Sale Id 2435',134850.00,0.00,0.00,217.50,1740.00,'2022-04-03 21:34:07','',''),(2407,'1','219','1',1,'Return of Retail Sale Id 2365',0.00,186000.00,300.00,0.00,-2400.00,'2022-04-03 21:35:41','',''),(2408,'1','219','1',1,'Retail Sale Id 2436',186000.00,0.00,0.00,300.00,2400.00,'2022-04-03 21:36:20','',''),(2409,'1','219','1',1,'Return of Retail Sale Id 2369',0.00,93000.00,150.00,0.00,-1200.00,'2022-04-03 21:38:39','',''),(2410,'1','219','1',1,'Retail Sale Id 2437',93000.00,0.00,0.00,150.00,1200.00,'2022-04-03 21:39:37','',''),(2411,'1','219','1',1,'Return of Retail Sale Id 2425',0.00,31000.00,50.00,0.00,-400.00,'2022-04-03 21:41:34','',''),(2412,'1','219','1',1,'Retail Sale Id 2438',31000.00,0.00,0.00,50.00,400.00,'2022-04-03 21:44:15','',''),(2413,'1','219','1',1,'Return of Retail Sale Id 2429',0.00,31000.00,50.00,0.00,-400.00,'2022-04-03 21:45:25','',''),(2414,'1','219','1',1,'Retail Sale Id 2439',31000.00,0.00,0.00,50.00,400.00,'2022-04-03 21:46:52','',''),(2415,'1','219','1',1,'Retail Sale Id 2440',30088.60,0.00,0.00,48.53,388.24,'2022-04-03 21:48:39','',''),(2416,'1','219','1',1,'Retail Sale Id 2441',47312.20,0.00,0.00,76.31,610.48,'2022-04-03 21:50:29','',''),(2417,'1','219','1',1,'Return of Retail Sale Id 2441',0.00,47312.20,76.31,0.00,-610.48,'2022-04-03 21:51:05','',''),(2418,'1','219','1',1,'Retail Sale Id 2442',27980.60,0.00,0.00,45.13,361.04,'2022-04-03 21:53:22','',''),(2419,'1','219','1',1,'Retail Sale Id 2443',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 08:24:53','',''),(2420,'1','219','1',1,'Retail Sale Id 2444',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 08:28:45','',''),(2421,'1','219','1',1,'Retail Sale Id 2445',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 08:57:42','',''),(2422,'1','219','1',1,'Retail Sale Id 2446',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 09:19:53','',''),(2423,'1','219','1',1,'Retail Sale Id 2447',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 09:24:16','',''),(2424,'1','219','1',1,'Retail Sale Id 2448',4960.00,0.00,0.00,8.00,64.00,'2022-04-04 09:29:25','',''),(2425,'1','219','1',1,'Retail Sale Id 2449',8000.00,0.00,0.00,12.50,350.00,'2022-04-04 09:34:37','',''),(2426,'1','219','1',1,'Retail Sale Id 2450',3200.00,0.00,0.00,5.00,140.00,'2022-04-04 09:43:27','',''),(2427,'1','219','1',1,'Retail Sale Id 2451',155000.00,0.00,0.00,250.00,2000.00,'2022-04-04 09:46:16','',''),(2428,'1','219','1',1,'Retail Sale Id 2452',1860.00,0.00,0.00,3.00,24.00,'2022-04-04 09:51:05','',''),(2429,'1','219','1',1,'Retail Sale Id 2453',3200.00,0.00,0.00,5.00,140.00,'2022-04-04 09:53:50','',''),(2430,'1','219','1',1,'Retail Sale Id 2453',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 09:53:50','',''),(2431,'1','219','1',1,'Retail Sale Id 2454',2502.40,0.00,0.00,3.91,109.48,'2022-04-04 09:57:46','',''),(2432,'1','219','1',1,'Retail Sale Id 2455',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 09:59:14','',''),(2433,'1','219','1',1,'Retail Sale Id 2456',2003.20,0.00,0.00,3.13,87.64,'2022-04-04 10:00:55','',''),(2434,'1','219','1',1,'Retail Sale Id 2457',35960.00,0.00,0.00,58.00,464.00,'2022-04-04 10:02:28','',''),(2435,'1','219','1',1,'Retail Sale Id 2458',3852.80,0.00,0.00,6.02,168.56,'2022-04-04 10:05:02','',''),(2436,'1','219','1',1,'Retail Sale Id 2459',93000.00,0.00,0.00,150.00,1200.00,'2022-04-04 10:09:52','',''),(2437,'1','219','1',1,'Retail Sale Id 2460',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 10:20:17','',''),(2438,'1','219','1',1,'Retail Sale Id 2460',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 10:20:17','',''),(2439,'1','219','1',1,'Retail Sale Id 2461',62000.00,0.00,0.00,100.00,800.00,'2022-04-04 10:35:24','',''),(2440,'1','219','1',1,'Retail Sale Id 2462',34100.00,0.00,0.00,55.00,440.00,'2022-04-04 10:40:12','',''),(2441,'1','219','1',1,'Retail Sale Id 2463',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 10:51:04','',''),(2442,'1','219','1',1,'Retail Sale Id 2464',3200.00,0.00,0.00,5.00,140.00,'2022-04-04 10:53:59','',''),(2443,'1','219','1',1,'Retail Sale Id 2465',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 10:56:39','',''),(2444,'1','219','1',1,'Retail Sale Id 2466',8000.00,0.00,0.00,12.50,350.00,'2022-04-04 10:58:27','',''),(2445,'1','219','1',1,'Retail Sale Id 2467',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 11:01:19','',''),(2446,'1','219','1',1,'Retail Sale Id 2468',6200.00,0.00,0.00,10.00,80.00,'2022-04-04 11:06:25','',''),(2447,'1','219','1',1,'Retail Sale Id 2469',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 11:08:06','',''),(2448,'1','219','1',1,'Retail Sale Id 2470',31000.00,0.00,0.00,50.00,400.00,'2022-04-04 11:32:55','',''),(2449,'1','219','1',1,'Retail Sale Id 2471',998.40,0.00,0.00,1.56,43.68,'2022-04-04 11:34:05','',''),(2450,'1','219','1',1,'Retail Sale Id 2472',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 11:35:35','',''),(2451,'1','219','1',1,'Retail Sale Id 2472',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 11:35:35','',''),(2452,'1','219','1',1,'Retail Sale Id 2473',998.40,0.00,0.00,1.56,43.68,'2022-04-04 11:38:21','',''),(2453,'1','219','1',1,'Retail Sale Id 2474',4000.00,0.00,0.00,6.25,175.00,'2022-04-04 11:39:10','',''),(2454,'1','219','1',1,'Retail Sale Id 2475',8000.00,0.00,0.00,12.50,350.00,'2022-04-04 12:00:18','',''),(2455,'1','219','1',1,'Retail Sale Id 2476',8320.00,0.00,0.00,13.00,364.00,'2022-04-04 12:01:57','',''),(2456,'1','219','1',1,'Retail Sale Id 2477',2003.20,0.00,0.00,3.13,87.64,'2022-04-04 12:03:12','',''),(2457,'1','219','1',1,'Retail Sale Id 2478',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 12:04:09','',''),(2458,'1','219','1',1,'Retail Sale Id 2479',3200.00,0.00,0.00,5.00,140.00,'2022-04-04 12:05:51','',''),(2459,'1','219','1',1,'Retail Sale Id 2481',4160.00,0.00,0.00,6.50,182.00,'2022-04-04 12:17:23','',''),(2460,'1','219','1',1,'Retail Sale Id 2482',1292.80,0.00,0.00,2.02,56.56,'2022-04-04 12:19:26','',''),(2461,'1','219','1',1,'Retail Sale Id 2483',1497.60,0.00,0.00,2.34,65.52,'2022-04-04 12:21:33','',''),(2462,'1','219','1',1,'Retail Sale Id 2485',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 12:24:33','',''),(2463,'1','219','1',1,'Retail Sale Id 2486',62000.00,0.00,0.00,100.00,800.00,'2022-04-04 12:31:22','',''),(2464,'1','219','1',1,'Retail Sale Id 2487',5580.00,0.00,0.00,9.00,72.00,'2022-04-04 12:33:42','',''),(2465,'1','219','1',1,'Retail Sale Id 2488',3200.00,0.00,0.00,5.00,140.00,'2022-04-04 12:47:06','',''),(2466,'1','219','1',1,'Retail Sale Id 2489',4000.00,0.00,0.00,6.25,175.00,'2022-04-04 12:48:48','',''),(2467,'1','219','1',1,'Retail Sale Id 2490',2003.20,0.00,0.00,3.13,87.64,'2022-04-04 12:49:55','',''),(2468,'1','219','1',1,'Retail Sale Id 2491',6400.00,0.00,0.00,10.00,280.00,'2022-04-04 13:02:41','',''),(2469,'1','219','1',1,'Retail Sale Id 2492',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 13:06:18','',''),(2470,'1','219','1',1,'Retail Sale Id 2493',3200.00,0.00,0.00,5.00,140.00,'2022-04-04 13:11:05','',''),(2471,'1','219','1',1,'Retail Sale Id 2494',998.40,0.00,0.00,1.56,43.68,'2022-04-04 13:12:20','',''),(2472,'1','219','1',1,'Retail Sale Id 2495',3200.00,0.00,0.00,5.00,140.00,'2022-04-04 13:25:39','',''),(2473,'1','219','1',1,'Retail Sale Id 2497',31000.00,0.00,0.00,50.00,400.00,'2022-04-04 13:31:01','',''),(2474,'1','219','1',1,'Retail Sale Id 2498',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 13:32:39','',''),(2475,'1','219','1',1,'Retail Sale Id 2499',3200.00,0.00,0.00,5.00,140.00,'2022-04-04 13:35:09','',''),(2476,'1','219','1',1,'Retail Sale Id 2500',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 13:39:17','',''),(2477,'1','219','1',1,'Retail Sale Id 2501',998.40,0.00,0.00,1.56,43.68,'2022-04-04 13:40:26','',''),(2478,'1','219','1',1,'Retail Sale Id 2504',31000.00,0.00,0.00,50.00,400.00,'2022-04-04 13:51:16','',''),(2479,'1','219','1',1,'Retail Sale Id 2506',0.00,0.00,0.00,0.00,0.00,'2022-04-04 15:33:29','',''),(2480,'1','219','1',1,'Return of Retail Sale Id 2486',0.00,62000.00,100.00,0.00,-800.00,'2022-04-04 15:46:59','',''),(2481,'1','219','1',1,'Retail Sale Id 2507',62000.00,0.00,0.00,100.00,800.00,'2022-04-04 15:47:37','',''),(2482,'1','219','1',1,'Return of Retail Sale Id 2500',0.00,1920.00,3.00,0.00,-84.00,'2022-04-04 15:49:33','',''),(2483,'1','219','1',1,'Retail Sale Id 2508',256.00,0.00,0.00,0.40,11.20,'2022-04-04 15:50:34','',''),(2484,'1','219','1',1,'Retail Sale Id 2509',384.00,0.00,0.00,0.60,16.80,'2022-04-04 15:51:58','',''),(2485,'1','219','1',1,'Retail Sale Id 2510',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 15:53:08','',''),(2486,'1','219','1',1,'Return of Retail Sale Id 2507',0.00,62000.00,100.00,0.00,-800.00,'2022-04-04 15:56:23','',''),(2487,'1','219','1',1,'Retail Sale Id 2511',6200.00,0.00,0.00,10.00,80.00,'2022-04-04 15:57:45','',''),(2488,'1','219','1',1,'Retail Sale Id 2512',55800.00,0.00,0.00,90.00,720.00,'2022-04-04 15:58:14','',''),(2489,'1','219','1',1,'Retail Sale Id 2513',18600.00,0.00,0.00,30.00,240.00,'2022-04-04 16:10:24','',''),(2490,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,3607788.96,5895.08,0.00,0.00,'2022-04-04 16:33:44','',''),(2491,'1','219',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,5895.08,0.00,'2022-04-04 16:34:43','',''),(2492,'1','219','1',1,'Received from bridging 8',0.00,0.00,5895.08,0.00,0.00,'2022-04-04 16:34:43','',''),(2493,'1','219','1',1,'Retail Sale Id 2514',12400.00,0.00,0.00,20.00,160.00,'2022-04-04 16:44:54','',''),(2494,'1','219','1',1,'Retail Sale Id 2515',998.40,0.00,0.00,1.56,43.68,'2022-04-04 16:49:48','',''),(2495,'1','219','1',1,'Retail Sale Id 2516',3897.60,0.00,0.00,6.09,170.52,'2022-04-04 17:00:22','',''),(2496,'1','219','1',1,'Retail Sale Id 2517',31000.00,0.00,0.00,50.00,400.00,'2022-04-04 17:07:30','',''),(2497,'1','219','1',1,'Retail Sale Id 2518',31000.00,0.00,0.00,50.00,400.00,'2022-04-04 17:11:22','',''),(2498,'1','219','1',1,'Retail Sale Id 2519',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 17:17:35','',''),(2499,'1','219','1',1,'Retail Sale Id 2520',12400.00,0.00,0.00,20.00,160.00,'2022-04-04 17:19:56','',''),(2500,'1','219','1',1,'Retail Sale Id 2521',1497.60,0.00,0.00,2.34,65.52,'2022-04-04 17:21:26','',''),(2501,'1','219','1',1,'Retail Sale Id 2522',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 17:23:04','',''),(2502,'1','219','1',1,'Retail Sale Id 2523',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 17:25:30','',''),(2503,'1','219','1',1,'Retail Sale Id 2523',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 17:25:30','',''),(2504,'1','219','1',1,'Retail Sale Id 2524',499.20,0.00,0.00,0.78,21.84,'2022-04-04 17:26:37','',''),(2505,'1','219','1',1,'Retail Sale Id 2525',2003.20,0.00,0.00,3.13,87.64,'2022-04-04 17:28:42','',''),(2506,'1','219','1',1,'Retail Sale Id 2526',3200.00,0.00,0.00,5.00,140.00,'2022-04-04 17:29:45','',''),(2507,'1','219','1',1,'Retail Sale Id 2527',499.20,0.00,0.00,0.78,21.84,'2022-04-04 17:32:40','',''),(2508,'1','219','1',1,'Retail Sale Id 2528',2502.40,0.00,0.00,3.91,109.48,'2022-04-04 17:33:34','',''),(2509,'1','219','1',1,'Retail Sale Id 2529',34720.00,0.00,0.00,56.00,448.00,'2022-04-04 17:35:03','',''),(2510,'1','219','1',1,'Retail Sale Id 2530',31000.00,0.00,0.00,50.00,400.00,'2022-04-04 17:37:17','',''),(2511,'1','219','1',1,'Retail Sale Id 2532',1203.20,0.00,0.00,1.88,52.64,'2022-04-04 17:44:42','',''),(2512,'1','219','1',1,'Retail Sale Id 2533',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 17:45:49','',''),(2513,'1','219','1',1,'Retail Sale Id 2534',4000.00,0.00,0.00,6.25,175.00,'2022-04-04 17:46:57','',''),(2514,'1','219','1',1,'Retail Sale Id 2535',499.20,0.00,0.00,0.78,21.84,'2022-04-04 17:47:44','',''),(2515,'1','219','1',1,'Retail Sale Id 2536',2003.20,0.00,0.00,3.13,87.64,'2022-04-04 17:54:33','',''),(2516,'1','219','1',1,'Retail Sale Id 2537',998.40,0.00,0.00,1.56,43.68,'2022-04-04 17:57:52','',''),(2517,'1','219','1',1,'Retail Sale Id 2538',2003.20,0.00,0.00,3.13,87.64,'2022-04-04 18:08:11','',''),(2518,'1','219','1',1,'Retail Sale Id 2539',1920.00,0.00,0.00,3.00,84.00,'2022-04-04 18:16:14','',''),(2519,'1','219','1',1,'Retail Sale Id 2540',3720.00,0.00,0.00,6.00,48.00,'2022-04-04 18:17:36','',''),(2520,'1','219','1',1,'Retail Sale Id 2542',998.40,0.00,0.00,1.56,43.68,'2022-04-04 18:19:47','',''),(2521,'1','219','1',1,'Retail Sale Id 2543',300.80,0.00,0.00,0.47,13.16,'2022-04-04 18:21:16','',''),(2522,'1','219','1',1,'Retail Sale Id 2544',4998.40,0.00,0.00,7.81,218.68,'2022-04-04 18:31:56','',''),(2523,'1','219','1',1,'Retail Sale Id 2545',1203.20,0.00,0.00,1.88,52.64,'2022-04-04 18:32:49','',''),(2524,'1','219','1',1,'Retail Sale Id 2546',3840.00,0.00,0.00,6.00,168.00,'2022-04-04 18:34:20','',''),(2525,'1','219','1',1,'Retail Sale Id 2547',46566.40,0.00,0.00,72.76,2037.28,'2022-04-04 21:49:33','',''),(2526,'1','219','1',1,'Retail Sale Id 2548',73388.80,0.00,0.00,114.67,3210.76,'2022-04-04 21:50:47','',''),(2527,'1','219','1',1,'Retail Sale Id 2549',92634.20,0.00,0.00,149.41,1195.28,'2022-04-04 21:52:29','',''),(2528,'1','219','1',1,'Retail Sale Id 2550',97302.80,0.00,0.00,156.94,1255.52,'2022-04-04 21:54:27','',''),(2529,'1','219','1',1,'Retail Sale Id 2551',7500.00,0.00,0.00,50.00,-23100.00,'2022-04-04 22:17:51','',''),(2530,'1','219','1',1,'Return of Retail Sale Id 2551',0.00,7500.00,50.00,0.00,23100.00,'2022-04-04 22:18:49','',''),(2531,'1','219','1',1,'Retail Sale Id 2552',5104.00,0.00,0.00,51.04,-26132.48,'2022-04-04 22:21:13','',''),(2532,'1','219','1',1,'Return of Retail Sale Id 2552',0.00,5104.00,51.04,0.00,26132.48,'2022-04-04 22:23:41','',''),(2533,'1','219','1',1,'Retail Sale Id 2553',3200.00,0.00,0.00,5.00,140.00,'2022-04-05 08:17:03','',''),(2534,'1','219','1',1,'Retail Sale Id 2554',3840.00,0.00,0.00,6.00,168.00,'2022-04-05 08:18:15','',''),(2535,'1','219','1',1,'Retail Sale Id 2557',3001.60,0.00,0.00,4.69,131.32,'2022-04-05 09:01:08','',''),(2536,'1','219','1',1,'Retail Sale Id 2558',2003.20,0.00,0.00,3.13,87.64,'2022-04-05 09:38:15','',''),(2537,'1','219','1',1,'Retail Sale Id 2559',998.40,0.00,0.00,1.56,43.68,'2022-04-05 09:39:31','',''),(2538,'1','219','1',1,'Retail Sale Id 2560',1958.40,0.00,0.00,3.06,85.68,'2022-04-05 09:46:14','',''),(2539,'1','219','1',1,'Retail Sale Id 2561',8000.00,0.00,0.00,12.50,350.00,'2022-04-05 10:05:22','',''),(2540,'1','219','1',1,'Retail Sale Id 2562',4000.00,0.00,0.00,6.25,175.00,'2022-04-05 10:25:32','',''),(2541,'1','219','1',1,'Retail Sale Id 2563',3200.00,0.00,0.00,5.00,140.00,'2022-04-05 10:34:01','',''),(2542,'1','219','1',1,'Retail Sale Id 2565',2003.20,0.00,0.00,3.13,87.64,'2022-04-05 11:01:04','',''),(2543,'1','219','1',1,'Retail Sale Id 2566',1920.00,0.00,0.00,3.00,84.00,'2022-04-05 11:04:03','',''),(2544,'1','219','1',1,'Retail Sale Id 2567',1280.00,0.00,0.00,2.00,56.00,'2022-04-05 11:24:43','',''),(2545,'1','219','1',1,'Retail Sale Id 2568',2502.40,0.00,0.00,3.91,109.48,'2022-04-05 11:27:14','',''),(2546,'1','219','1',1,'Retail Sale Id 2569',8000.00,0.00,0.00,12.50,350.00,'2022-04-05 11:33:21','',''),(2547,'1','219','1',1,'Retail Sale Id 2570',86800.00,0.00,0.00,140.00,1120.00,'2022-04-05 11:34:56','',''),(2548,'1','219','1',1,'Retail Sale Id 2571',3100.00,0.00,0.00,5.00,40.00,'2022-04-05 11:57:55','',''),(2549,'1','219','1',1,'Retail Sale Id 2572',8000.00,0.00,0.00,12.50,350.00,'2022-04-05 12:08:22','',''),(2550,'1','219','1',1,'Retail Sale Id 2573',1497.60,0.00,0.00,2.34,65.52,'2022-04-05 12:09:28','',''),(2551,'1','219','1',1,'Retail Sale Id 2574',3840.00,0.00,0.00,6.00,168.00,'2022-04-05 12:14:06','',''),(2552,'1','219','1',1,'Retail Sale Id 2575',1920.00,0.00,0.00,3.00,84.00,'2022-04-05 12:24:07','',''),(2553,'1','219','1',1,'Retail Sale Id 2576',3852.80,0.00,0.00,6.02,168.56,'2022-04-05 12:59:12','',''),(2554,'1','219','1',1,'Retail Sale Id 2577',1920.00,0.00,0.00,3.00,84.00,'2022-04-05 13:16:53','',''),(2555,'1','219','1',1,'Retail Sale Id 2578',1900.80,0.00,0.00,2.97,83.16,'2022-04-05 13:36:13','',''),(2556,'1','219','1',1,'Retail Sale Id 2579',7001.60,0.00,0.00,10.94,306.32,'2022-04-05 14:10:07','',''),(2557,'1','219','1',1,'Retail Sale Id 2580',2003.20,0.00,0.00,3.13,87.64,'2022-04-05 14:18:43','',''),(2558,'1','219','1',1,'Retail Sale Id 2581',3840.00,0.00,0.00,6.00,168.00,'2022-04-05 14:20:26','',''),(2559,'1','219','1',1,'Retail Sale Id 2582',8000.00,0.00,0.00,12.50,350.00,'2022-04-05 14:58:22','',''),(2560,'1','219','1',1,'Retail Sale Id 2583',2560.00,0.00,0.00,4.00,112.00,'2022-04-05 15:07:10','',''),(2561,'1','219','1',1,'Retail Sale Id 2584',1920.00,0.00,0.00,3.00,84.00,'2022-04-05 15:08:31','',''),(2562,'1','219','1',1,'Retail Sale Id 2585',4198.40,0.00,0.00,6.56,183.68,'2022-04-05 15:09:29','',''),(2563,'1','219','1',1,'Retail Sale Id 2586',3200.00,0.00,0.00,5.00,140.00,'2022-04-05 15:19:28','',''),(2564,'1','219','1',1,'Retail Sale Id 2587',7130.00,0.00,0.00,11.50,92.00,'2022-04-05 15:31:23','',''),(2565,'1','219','1',1,'Retail Sale Id 2588',4000.00,0.00,0.00,6.25,175.00,'2022-04-05 15:42:03','',''),(2566,'1','219','1',1,'Retail Sale Id 2589',8000.00,0.00,0.00,12.50,350.00,'2022-04-05 15:45:23','',''),(2567,'1','219','1',1,'Retail Sale Id 2589',8000.00,0.00,0.00,12.50,350.00,'2022-04-05 15:45:23','',''),(2568,'1','219','1',1,'Retail Sale Id 2590',1401.60,0.00,0.00,2.19,61.32,'2022-04-05 16:14:59','',''),(2569,'1','219','1',1,'Retail Sale Id 2591',640.00,0.00,0.00,1.00,28.00,'2022-04-05 16:19:37','',''),(2570,'1','219','1',1,'Retail Sale Id 2592',2003.20,0.00,0.00,3.13,87.64,'2022-04-05 16:44:33','',''),(2571,'1','219','1',1,'Retail Sale Id 2593',2560.00,0.00,0.00,4.00,112.00,'2022-04-05 16:48:01','',''),(2572,'1','219','1',1,'Retail Sale Id 2594',3200.00,0.00,0.00,5.00,140.00,'2022-04-05 16:50:29','',''),(2573,'1','219','1',1,'Retail Sale Id 2595',1860.00,0.00,0.00,3.00,24.00,'2022-04-05 16:51:40','',''),(2574,'1','219','1',1,'Retail Sale Id 2596',3840.00,0.00,0.00,6.00,168.00,'2022-04-05 16:53:17','',''),(2575,'1','219','1',1,'Retail Sale Id 2597',6419.20,0.00,0.00,10.03,280.84,'2022-04-05 16:56:08','',''),(2576,'1','219','1',1,'Retail Sale Id 2598',1920.00,0.00,0.00,3.00,84.00,'2022-04-05 16:57:44','',''),(2577,'1','219','1',1,'Retail Sale Id 2599',4000.00,0.00,0.00,6.25,175.00,'2022-04-05 17:11:22','',''),(2578,'1','219','1',1,'Retail Sale Id 2600',6400.00,0.00,0.00,10.00,280.00,'2022-04-05 17:12:39','',''),(2579,'1','219','1',1,'Retail Sale Id 2601',7750.00,0.00,0.00,12.50,100.00,'2022-04-05 17:14:44','',''),(2580,'1','219','1',1,'Retail Sale Id 2602',31000.00,0.00,0.00,50.00,400.00,'2022-04-05 17:27:07','',''),(2581,'1','219','1',1,'Retail Sale Id 2603',3840.00,0.00,0.00,6.00,168.00,'2022-04-05 17:33:07','',''),(2582,'1','219','1',1,'Retail Sale Id 2604',2003.20,0.00,0.00,3.13,87.64,'2022-04-05 17:36:13','',''),(2583,'1','219','1',1,'Retail Sale Id 2605',499.20,0.00,0.00,0.78,21.84,'2022-04-05 17:37:46','',''),(2584,'1','219','1',1,'Retail Sale Id 2606',4000.00,0.00,0.00,6.25,175.00,'2022-04-05 17:39:06','',''),(2585,'1','219','1',1,'Retail Sale Id 2607',1100.80,0.00,0.00,1.72,48.16,'2022-04-05 17:45:18','',''),(2586,'1','219','1',1,'Retail Sale Id 2608',3840.00,0.00,0.00,6.00,168.00,'2022-04-05 17:51:58','',''),(2587,'1','219','1',1,'Retail Sale Id 2609',3001.60,0.00,0.00,4.69,131.32,'2022-04-05 17:56:53','',''),(2588,'1','219','1',1,'Retail Sale Id 2610',8000.00,0.00,0.00,12.50,350.00,'2022-04-05 17:58:28','',''),(2589,'1','219','1',1,'Retail Sale Id 2611',499.20,0.00,0.00,0.78,21.84,'2022-04-05 17:59:32','',''),(2590,'1','219','1',1,'Retail Sale Id 2612',2003.20,0.00,0.00,3.13,87.64,'2022-04-05 18:02:45','',''),(2591,'1','219','1',1,'Retail Sale Id 2613',6400.00,0.00,0.00,10.00,280.00,'2022-04-05 18:04:51','',''),(2592,'1','219','1',1,'Retail Sale Id 2614',7440.00,0.00,0.00,12.00,96.00,'2022-04-05 18:08:49','',''),(2593,'1','219','1',1,'Retail Sale Id 2615',499.20,0.00,0.00,0.78,21.84,'2022-04-05 18:43:25','',''),(2594,'1','219','1',1,'Retail Sale Id 2616',20999.40,0.00,0.00,33.87,270.96,'2022-04-05 22:43:11','',''),(2595,'1','219','1',1,'Return of Retail Sale Id 2611',0.00,499.20,0.78,0.00,-21.84,'2022-04-05 22:45:08','',''),(2596,'1','219','1',1,'Retail Sale Id 2617',281.60,0.00,0.00,0.44,12.32,'2022-04-05 22:46:19','',''),(2597,'1','219','1',1,'Retail Sale Id 2618',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 07:27:21','',''),(2598,'1','219','1',1,'Retail Sale Id 2619',3200.00,0.00,0.00,5.00,140.00,'2022-04-06 08:03:04','',''),(2599,'1','219','1',1,'Retail Sale Id 2620',8000.00,0.00,0.00,12.50,350.00,'2022-04-06 08:04:27','',''),(2600,'1','219','1',1,'Retail Sale Id 2621',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 08:06:05','',''),(2601,'1','219','1',1,'Retail Sale Id 2622',3001.60,0.00,0.00,4.69,131.32,'2022-04-06 09:26:07','',''),(2602,'1','219','1',1,'Retail Sale Id 2623',2502.40,0.00,0.00,3.91,109.48,'2022-04-06 09:33:36','',''),(2603,'1','219','1',1,'Retail Sale Id 2624',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 10:02:13','',''),(2604,'1','219','1',1,'Retail Sale Id 2626',31000.00,0.00,0.00,50.00,400.00,'2022-04-06 10:04:13','',''),(2605,'1','219','1',1,'Retail Sale Id 2627',2598.40,0.00,0.00,4.06,113.68,'2022-04-06 10:07:03','',''),(2606,'1','219','1',1,'Retail Sale Id 2628',6400.00,0.00,0.00,10.00,280.00,'2022-04-06 10:09:00','',''),(2607,'1','219','1',1,'Retail Sale Id 2629',38750.00,0.00,0.00,62.50,500.00,'2022-04-06 10:17:34','',''),(2608,'1','219','1',1,'Retail Sale Id 2631',31000.00,0.00,0.00,50.00,400.00,'2022-04-06 10:21:30','',''),(2609,'1','219','1',1,'Retail Sale Id 2632',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 10:28:31','',''),(2610,'1','219','1',1,'Retail Sale Id 2633',3200.00,0.00,0.00,5.00,140.00,'2022-04-06 10:32:24','',''),(2611,'1','219','1',1,'Retail Sale Id 2634',2700.80,0.00,0.00,4.22,118.16,'2022-04-06 10:46:41','',''),(2612,'1','219','1',1,'Retail Sale Id 2635',62000.00,0.00,0.00,100.00,800.00,'2022-04-06 10:48:26','',''),(2613,'1','219','1',1,'Retail Sale Id 2636',1920.00,0.00,0.00,3.00,84.00,'2022-04-06 10:49:47','',''),(2614,'1','219','1',1,'Retail Sale Id 2637',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 10:50:45','',''),(2615,'1','219','1',1,'Retail Sale Id 2638',3200.00,0.00,0.00,5.00,140.00,'2022-04-06 11:03:04','',''),(2616,'1','219','1',1,'Retail Sale Id 2639',55800.00,0.00,0.00,90.00,720.00,'2022-04-06 11:11:04','',''),(2617,'1','219','1',1,'Retail Sale Id 2640',1497.60,0.00,0.00,2.34,65.52,'2022-04-06 11:19:32','',''),(2618,'1','219','1',1,'Retail Sale Id 2641',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 11:20:20','',''),(2619,'1','219','1',1,'Retail Sale Id 2642',3200.00,0.00,0.00,5.00,140.00,'2022-04-06 11:49:54','',''),(2620,'1','219','1',1,'Retail Sale Id 2643',3200.00,0.00,0.00,5.00,140.00,'2022-04-06 12:12:32','',''),(2621,'1','219','1',1,'Retail Sale Id 2644',6400.00,0.00,0.00,10.00,280.00,'2022-04-06 12:16:05','',''),(2622,'1','219','1',1,'Retail Sale Id 2645',1299.20,0.00,0.00,2.03,56.84,'2022-04-06 12:18:37','',''),(2623,'1','219','1',1,'Retail Sale Id 2646',3001.60,0.00,0.00,4.69,131.32,'2022-04-06 12:20:20','',''),(2624,'1','219','1',1,'Retail Sale Id 2647',1798.40,0.00,0.00,2.81,78.68,'2022-04-06 12:25:24','',''),(2625,'1','219','1',1,'Retail Sale Id 2648',2547.20,0.00,0.00,3.98,111.44,'2022-04-06 12:28:19','',''),(2626,'1','219','1',1,'Retail Sale Id 2649',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 12:34:47','',''),(2627,'1','219','1',1,'Retail Sale Id 2650',1497.60,0.00,0.00,2.34,65.52,'2022-04-06 13:13:53','',''),(2628,'1','219','1',1,'Retail Sale Id 2651',15500.00,0.00,0.00,25.00,200.00,'2022-04-06 13:27:16','',''),(2629,'1','219','1',1,'Retail Sale Id 2652',62000.00,0.00,0.00,100.00,800.00,'2022-04-06 14:03:10','',''),(2630,'1','219','1',1,'Retail Sale Id 2653',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 14:04:06','',''),(2631,'1','219','1',1,'Retail Sale Id 2654',4499.20,0.00,0.00,7.03,196.84,'2022-04-06 14:13:42','',''),(2632,'1','219','1',1,'Retail Sale Id 2655',7001.60,0.00,0.00,10.94,306.32,'2022-04-06 14:15:02','',''),(2633,'1','219','1',1,'Retail Sale Id 2656',8000.00,0.00,0.00,12.50,350.00,'2022-04-06 14:16:08','',''),(2634,'1','219','1',1,'Retail Sale Id 2657',3200.00,0.00,0.00,5.00,140.00,'2022-04-06 14:42:35','',''),(2635,'1','219','1',1,'Retail Sale Id 2658',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 14:43:53','',''),(2636,'1','219','1',1,'Retail Sale Id 2659',8060.00,0.00,0.00,13.00,104.00,'2022-04-06 14:54:49','',''),(2637,'1','219','1',1,'Retail Sale Id 2660',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 15:19:27','',''),(2638,'1','219','1',1,'Retail Sale Id 2661',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 15:21:53','',''),(2639,'1','219','1',1,'Retail Sale Id 2662',3200.00,0.00,0.00,5.00,140.00,'2022-04-06 15:46:09','',''),(2640,'1','219','1',1,'Retail Sale Id 2664',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 15:49:57','',''),(2641,'1','219','1',1,'Retail Sale Id 2665',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 16:06:38','',''),(2642,'1','219','1',1,'Retail Sale Id 2666',3200.00,0.00,0.00,5.00,140.00,'2022-04-06 16:20:41','',''),(2643,'1','219','1',1,'Retail Sale Id 2667',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 16:22:06','',''),(2644,'1','219','1',1,'Retail Sale Id 2669',1497.60,0.00,0.00,2.34,65.52,'2022-04-06 16:34:17','',''),(2645,'1','219','1',1,'Retail Sale Id 2670',2560.00,0.00,0.00,4.00,112.00,'2022-04-06 16:48:18','',''),(2646,'1','219','1',1,'Retail Sale Id 2671',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 16:52:30','',''),(2647,'1','219','1',1,'Retail Sale Id 2672',2560.00,0.00,0.00,4.00,112.00,'2022-04-06 16:53:48','',''),(2648,'1','219','1',1,'Retail Sale Id 2673',9600.00,0.00,0.00,15.00,420.00,'2022-04-06 17:02:16','',''),(2649,'1','219','1',1,'Retail Sale Id 2674',499.20,0.00,0.00,0.78,21.84,'2022-04-06 17:03:56','',''),(2650,'1','219','1',1,'Retail Sale Id 2676',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 17:14:41','',''),(2651,'1','219','1',1,'Retail Sale Id 2677',31000.00,0.00,0.00,50.00,400.00,'2022-04-06 17:28:13','',''),(2652,'1','219','1',1,'Retail Sale Id 2678',998.40,0.00,0.00,1.56,43.68,'2022-04-06 17:34:03','',''),(2653,'1','219','1',1,'Retail Sale Id 2680',31000.00,0.00,0.00,50.00,400.00,'2022-04-06 17:35:42','',''),(2654,'1','219','1',1,'Retail Sale Id 2681',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 17:38:12','',''),(2655,'1','219','1',1,'Retail Sale Id 2682',499.20,0.00,0.00,0.78,21.84,'2022-04-06 17:39:43','',''),(2656,'1','219','1',1,'Retail Sale Id 2683',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 17:40:42','',''),(2657,'1','219','1',1,'Retail Sale Id 2684',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 17:41:34','',''),(2658,'1','219','1',1,'Retail Sale Id 2685',3840.00,0.00,0.00,6.00,168.00,'2022-04-06 17:44:29','',''),(2659,'1','219','1',1,'Retail Sale Id 2686',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 17:45:39','',''),(2660,'1','219','1',1,'Retail Sale Id 2687',8000.00,0.00,0.00,12.50,350.00,'2022-04-06 17:47:59','',''),(2661,'1','219','1',1,'Retail Sale Id 2688',1952.00,0.00,0.00,3.05,85.40,'2022-04-06 17:51:07','',''),(2662,'1','219','1',1,'Retail Sale Id 2689',499.20,0.00,0.00,0.78,21.84,'2022-04-06 17:55:17','',''),(2663,'1','219','1',1,'Retail Sale Id 2690',4000.00,0.00,0.00,6.25,175.00,'2022-04-06 18:11:34','',''),(2664,'1','219','1',1,'Retail Sale Id 2691',1497.60,0.00,0.00,2.34,65.52,'2022-04-06 18:18:16','',''),(2665,'1','219','1',1,'Retail Sale Id 2692',403.20,0.00,0.00,0.63,17.64,'2022-04-06 18:26:01','',''),(2666,'1','219','1',1,'Retail Sale Id 2694',2003.20,0.00,0.00,3.13,87.64,'2022-04-06 18:51:31','',''),(2667,'1','219','1',1,'Return of Retail Sale Id 2659',0.00,8060.00,13.00,0.00,-104.00,'2022-04-06 22:38:14','',''),(2668,'1','219','1',1,'Retail Sale Id 2695',7694.20,0.00,0.00,12.41,99.28,'2022-04-06 22:39:30','',''),(2669,'1','219','1',1,'Retail Sale Id 2696',492.80,0.00,0.00,0.77,21.56,'2022-04-06 22:41:40','',''),(2670,'1','219','1',1,'Return of Retail Sale Id 2674',0.00,499.20,0.78,0.00,-21.84,'2022-04-06 22:43:47','',''),(2671,'1','219','1',1,'Retail Sale Id 2697',326.40,0.00,0.00,0.51,14.28,'2022-04-06 22:44:54','',''),(2672,'1','219','1',1,'Retail Sale Id 2698',3200.00,0.00,0.00,5.00,140.00,'2022-04-07 08:18:35','',''),(2673,'1','219','1',1,'Retail Sale Id 2700',7750.00,0.00,0.00,12.50,100.00,'2022-04-07 08:22:08','',''),(2674,'1','219','1',1,'Retail Sale Id 2702',3897.60,0.00,0.00,6.09,170.52,'2022-04-07 08:46:19','',''),(2675,'1','219','1',1,'Retail Sale Id 2703',998.40,0.00,0.00,1.56,43.68,'2022-04-07 08:51:42','',''),(2676,'1','219','1',1,'Retail Sale Id 2704',4000.00,0.00,0.00,6.25,175.00,'2022-04-07 09:18:00','',''),(2677,'1','219','1',1,'Retail Sale Id 2705',499.20,0.00,0.00,0.78,21.84,'2022-04-07 09:40:06','',''),(2678,'1','219','1',1,'Retail Sale Id 2706',2003.20,0.00,0.00,3.13,87.64,'2022-04-07 09:46:22','',''),(2679,'1','219','1',1,'Retail Sale Id 2707',6820.00,0.00,0.00,11.00,88.00,'2022-04-07 09:48:23','',''),(2680,'1','219','1',1,'Retail Sale Id 2708',3001.60,0.00,0.00,4.69,131.32,'2022-04-07 09:59:49','',''),(2681,'1','219','1',1,'Retail Sale Id 2709',3001.60,0.00,0.00,4.69,131.32,'2022-04-07 10:02:31','',''),(2682,'1','219','1',1,'Retail Sale Id 2710',4000.00,0.00,0.00,6.25,175.00,'2022-04-07 10:20:16','',''),(2683,'1','219','1',1,'Retail Sale Id 2711',2003.20,0.00,0.00,3.13,87.64,'2022-04-07 10:21:52','',''),(2684,'1','219','1',1,'Retail Sale Id 2712',4480.00,0.00,0.00,7.00,196.00,'2022-04-07 10:22:52','',''),(2685,'1','219','1',1,'Retail Sale Id 2713',8000.00,0.00,0.00,12.50,350.00,'2022-04-07 10:36:19','',''),(2686,'1','219','1',1,'Retail Sale Id 2714',4000.00,0.00,0.00,6.25,175.00,'2022-04-07 10:41:26','',''),(2687,'1','219','1',1,'Retail Sale Id 2715',8000.00,0.00,0.00,12.50,350.00,'2022-04-07 10:42:20','',''),(2688,'1','219','1',1,'Retail Sale Id 2716',4000.00,0.00,0.00,6.25,175.00,'2022-04-07 10:53:15','',''),(2689,'1','219','1',1,'Retail Sale Id 2717',6200.00,0.00,0.00,10.00,80.00,'2022-04-07 10:55:38','',''),(2690,'1','219','1',1,'Retail Sale Id 2718',3897.60,0.00,0.00,6.09,170.52,'2022-04-07 10:58:37','',''),(2691,'1','219','1',1,'Retail Sale Id 2719',3720.00,0.00,0.00,6.00,48.00,'2022-04-07 11:01:11','',''),(2692,'1','219','1',1,'Retail Sale Id 2720',3840.00,0.00,0.00,6.00,168.00,'2022-04-07 11:25:59','',''),(2693,'1','219','1',1,'Retail Sale Id 2721',2003.20,0.00,0.00,3.13,87.64,'2022-04-07 11:28:19','',''),(2694,'1','219','1',1,'Retail Sale Id 2722',8000.00,0.00,0.00,12.50,350.00,'2022-04-07 11:51:29','',''),(2695,'1','219','1',1,'Retail Sale Id 2723',8000.00,0.00,0.00,12.50,350.00,'2022-04-07 12:11:36','',''),(2696,'1','219','1',1,'Retail Sale Id 2724',2003.20,0.00,0.00,3.13,87.64,'2022-04-07 12:31:49','',''),(2697,'1','219','1',1,'Retail Sale Id 2728',8000.00,0.00,0.00,12.50,350.00,'2022-04-07 12:57:55','',''),(2698,'1','219','1',1,'Retail Sale Id 2729',3852.80,0.00,0.00,6.02,168.56,'2022-04-07 13:37:57','',''),(2699,'1','219','1',1,'Retail Sale Id 2730',1497.60,0.00,0.00,2.34,65.52,'2022-04-07 14:05:42','',''),(2700,'1','219','1',1,'Retail Sale Id 2731',93000.00,0.00,0.00,150.00,1200.00,'2022-04-07 14:34:40','',''),(2701,'1','219','1',1,'Retail Sale Id 2732',300.80,0.00,0.00,0.47,13.16,'2022-04-07 14:42:33','',''),(2702,'1','219','1',1,'Retail Sale Id 2733',2003.20,0.00,0.00,3.13,87.64,'2022-04-07 14:43:20','',''),(2703,'1','219','1',1,'Retail Sale Id 2734',93000.00,0.00,0.00,150.00,1200.00,'2022-04-07 14:47:16','',''),(2704,'1','219','1',1,'Retail Sale Id 2735',640.00,0.00,0.00,1.00,28.00,'2022-04-07 15:01:11','',''),(2705,'1','219','1',1,'Retail Sale Id 2736',3200.00,0.00,0.00,5.00,140.00,'2022-04-07 15:15:26','',''),(2706,'1','219','1',1,'Retail Sale Id 2737',3200.00,0.00,0.00,5.00,140.00,'2022-04-07 15:41:02','',''),(2707,'1','219','1',1,'Retail Sale Id 2738',3200.00,0.00,0.00,5.00,140.00,'2022-04-07 15:42:06','',''),(2708,'1','219','1',1,'Retail Sale Id 2740',15500.00,0.00,0.00,25.00,200.00,'2022-04-07 15:53:00','',''),(2709,'1','219','1',1,'Retail Sale Id 2741',3840.00,0.00,0.00,6.00,168.00,'2022-04-07 16:28:17','',''),(2710,'1','219','1',1,'Retail Sale Id 2742',1497.60,0.00,0.00,2.34,65.52,'2022-04-07 16:40:55','',''),(2711,'1','219','1',1,'Retail Sale Id 2743',998.40,0.00,0.00,1.56,43.68,'2022-04-07 16:55:00','',''),(2712,'1','219','1',1,'Retail Sale Id 2744',1280.00,0.00,0.00,2.00,56.00,'2022-04-07 16:56:10','',''),(2713,'1','219','1',1,'Retail Sale Id 2745',1920.00,0.00,0.00,3.00,84.00,'2022-04-07 16:57:28','',''),(2714,'1','219','1',1,'Retail Sale Id 2746',998.40,0.00,0.00,1.56,43.68,'2022-04-07 16:59:23','',''),(2715,'1','219','1',1,'Retail Sale Id 2747',3200.00,0.00,0.00,5.00,140.00,'2022-04-07 17:01:41','',''),(2716,'1','219','1',1,'Retail Sale Id 2749',3840.00,0.00,0.00,6.00,168.00,'2022-04-07 17:04:38','',''),(2717,'1','219','1',1,'Retail Sale Id 2750',1939.20,0.00,0.00,3.03,84.84,'2022-04-07 17:09:37','',''),(2718,'1','219','1',1,'Retail Sale Id 2751',1299.20,0.00,0.00,2.03,56.84,'2022-04-07 17:13:03','',''),(2719,'1','219','1',1,'Retail Sale Id 2752',3840.00,0.00,0.00,6.00,168.00,'2022-04-07 17:14:42','',''),(2720,'1','219','1',1,'Retail Sale Id 2753',3001.60,0.00,0.00,4.69,131.32,'2022-04-07 17:22:51','',''),(2721,'1','219','1',1,'Retail Sale Id 2754',998.40,0.00,0.00,1.56,43.68,'2022-04-07 17:32:13','',''),(2722,'1','219','1',1,'Retail Sale Id 2756',3852.80,0.00,0.00,6.02,168.56,'2022-04-07 17:34:53','',''),(2723,'1','219','1',1,'Retail Sale Id 2757',697.60,0.00,0.00,1.09,30.52,'2022-04-07 17:40:30','',''),(2724,'1','219','1',1,'Retail Sale Id 2758',601.60,0.00,0.00,0.94,26.32,'2022-04-07 17:42:35','',''),(2725,'1','219','1',1,'Retail Sale Id 2761',300.80,0.00,0.00,0.47,13.16,'2022-04-07 18:08:48','',''),(2726,'1','219','1',1,'Retail Sale Id 2762',3840.00,0.00,0.00,6.00,168.00,'2022-04-07 18:10:01','',''),(2727,'1','219','1',1,'Retail Sale Id 2763',2502.40,0.00,0.00,3.91,109.48,'2022-04-07 18:10:56','',''),(2728,'1','219','1',1,'Retail Sale Id 2764',1401.60,0.00,0.00,2.19,61.32,'2022-04-07 18:11:50','',''),(2729,'1','219','1',1,'Retail Sale Id 2765',499.20,0.00,0.00,0.78,21.84,'2022-04-07 18:24:04','',''),(2730,'1','219','1',1,'Retail Sale Id 2766',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 09:59:56','',''),(2731,'1','219','1',1,'Retail Sale Id 2767',1497.60,0.00,0.00,2.34,65.52,'2022-04-08 10:03:16','',''),(2732,'1','219','1',1,'Retail Sale Id 2768',3200.00,0.00,0.00,5.00,140.00,'2022-04-08 10:35:55','',''),(2733,'1','219','1',1,'Retail Sale Id 2771',1600.00,0.00,0.00,2.50,70.00,'2022-04-08 10:42:55','',''),(2734,'1','219','1',1,'Retail Sale Id 2772',6400.00,0.00,0.00,10.00,280.00,'2022-04-08 11:03:01','',''),(2735,'1','219','1',1,'Retail Sale Id 2773',62000.00,0.00,0.00,100.00,800.00,'2022-04-08 11:06:01','',''),(2736,'1','219','1',1,'Retail Sale Id 2774',8000.00,0.00,0.00,12.50,350.00,'2022-04-08 11:10:00','',''),(2737,'1','219','1',1,'Retail Sale Id 2775',8000.00,0.00,0.00,12.50,350.00,'2022-04-08 11:26:42','',''),(2738,'1','219','1',1,'Retail Sale Id 2776',6400.00,0.00,0.00,10.00,280.00,'2022-04-08 11:28:00','',''),(2739,'1','219','1',1,'Retail Sale Id 2777',499.20,0.00,0.00,0.78,21.84,'2022-04-08 11:38:21','',''),(2740,'1','219','1',1,'Retail Sale Id 2778',3001.60,0.00,0.00,4.69,131.32,'2022-04-08 11:53:55','',''),(2741,'1','219','1',1,'Retail Sale Id 2779',8000.00,0.00,0.00,12.50,350.00,'2022-04-08 11:55:53','',''),(2742,'1','219','1',1,'Retail Sale Id 2780',8000.00,0.00,0.00,12.50,350.00,'2022-04-08 11:57:10','',''),(2743,'1','219','1',1,'Retail Sale Id 2781',2003.20,0.00,0.00,3.13,87.64,'2022-04-08 11:57:57','',''),(2744,'1','219','1',1,'Retail Sale Id 2783',2003.20,0.00,0.00,3.13,87.64,'2022-04-08 12:07:53','',''),(2745,'1','219','1',1,'Retail Sale Id 2783',2003.20,0.00,0.00,3.13,87.64,'2022-04-08 12:07:53','',''),(2746,'1','219','1',1,'Retail Sale Id 2784',4960.00,0.00,0.00,8.00,64.00,'2022-04-08 12:41:01','',''),(2747,'1','219','1',1,'Retail Sale Id 2785',6200.00,0.00,0.00,10.00,80.00,'2022-04-08 12:52:51','',''),(2748,'1','219','1',1,'Retail Sale Id 2786',8000.00,0.00,0.00,12.50,350.00,'2022-04-08 13:36:18','',''),(2749,'1','219','1',1,'Retail Sale Id 2788',3720.00,0.00,0.00,6.00,48.00,'2022-04-08 13:42:41','',''),(2750,'1','219','1',1,'Retail Sale Id 2789',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 14:00:44','',''),(2751,'1','219','1',1,'Retail Sale Id 2790',998.40,0.00,0.00,1.56,43.68,'2022-04-08 14:34:32','',''),(2752,'1','219','1',1,'Retail Sale Id 2791',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 14:52:47','',''),(2753,'1','219','1',1,'Retail Sale Id 2792',8000.00,0.00,0.00,12.50,350.00,'2022-04-08 15:24:50','',''),(2754,'1','219','1',1,'Retail Sale Id 2793',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 15:26:42','',''),(2755,'1','219','1',1,'Retail Sale Id 2794',1920.00,0.00,0.00,3.00,84.00,'2022-04-08 15:27:31','',''),(2756,'1','219','1',1,'Retail Sale Id 2795',8000.00,0.00,0.00,12.50,350.00,'2022-04-08 15:30:05','',''),(2757,'1','219','1',1,'Retail Sale Id 2796',1920.00,0.00,0.00,3.00,84.00,'2022-04-08 15:36:46','',''),(2758,'1','219','1',1,'Retail Sale Id 2797',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 15:40:57','',''),(2759,'1','219','1',1,'Retail Sale Id 2798',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 15:45:18','',''),(2760,'1','219','1',1,'Retail Sale Id 2799',4000.00,0.00,0.00,6.25,175.00,'2022-04-08 16:00:29','',''),(2761,'1','219','1',1,'Retail Sale Id 2800',499.20,0.00,0.00,0.78,21.84,'2022-04-08 16:01:32','',''),(2762,'1','219','1',1,'Retail Sale Id 2801',3200.00,0.00,0.00,5.00,140.00,'2022-04-08 16:03:35','',''),(2763,'1','219','1',1,'Retail Sale Id 2802',3500.80,0.00,0.00,5.47,153.16,'2022-04-08 16:07:14','',''),(2764,'1','219','1',1,'Retail Sale Id 2803',2560.00,0.00,0.00,4.00,112.00,'2022-04-08 16:22:15','',''),(2765,'1','219','1',1,'Retail Sale Id 2804',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 16:27:19','',''),(2766,'1','219','1',1,'Retail Sale Id 2805',1920.00,0.00,0.00,3.00,84.00,'2022-04-08 16:30:04','',''),(2767,'1','219','1',1,'Retail Sale Id 2806',998.40,0.00,0.00,1.56,43.68,'2022-04-08 16:31:46','',''),(2768,'1','219','1',1,'Retail Sale Id 2807',697.60,0.00,0.00,1.09,30.52,'2022-04-08 16:39:03','',''),(2769,'1','219','1',1,'Retail Sale Id 2808',1299.20,0.00,0.00,2.03,56.84,'2022-04-08 16:40:11','',''),(2770,'1','219','1',1,'Retail Sale Id 2809',3100.00,0.00,0.00,5.00,40.00,'2022-04-08 16:51:20','',''),(2771,'1','219','1',1,'Retail Sale Id 2811',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 16:55:55','',''),(2772,'1','219','1',1,'Retail Sale Id 2812',27900.00,0.00,0.00,45.00,360.00,'2022-04-08 16:57:32','',''),(2773,'1','219','1',1,'Retail Sale Id 2813',1497.60,0.00,0.00,2.34,65.52,'2022-04-08 16:59:36','',''),(2774,'1','219','1',1,'Retail Sale Id 2814',1497.60,0.00,0.00,2.34,65.52,'2022-04-08 17:13:42','',''),(2775,'1','219','1',1,'Retail Sale Id 2815',499.20,0.00,0.00,0.78,21.84,'2022-04-08 17:18:26','',''),(2776,'1','219','1',1,'Retail Sale Id 2816',1299.20,0.00,0.00,2.03,56.84,'2022-04-08 17:29:18','',''),(2777,'1','219','1',1,'Retail Sale Id 2817',1920.00,0.00,0.00,3.00,84.00,'2022-04-08 17:30:53','',''),(2778,'1','219','1',1,'Retail Sale Id 2818',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 17:38:52','',''),(2779,'1','219','1',1,'Retail Sale Id 2819',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 17:42:20','',''),(2780,'1','219','1',1,'Retail Sale Id 2820',499.20,0.00,0.00,0.78,21.84,'2022-04-08 17:49:26','',''),(2781,'1','219','1',1,'Retail Sale Id 2821',1280.00,0.00,0.00,2.00,56.00,'2022-04-08 17:53:49','',''),(2782,'1','219','1',1,'Retail Sale Id 2822',8000.00,0.00,0.00,12.50,350.00,'2022-04-08 17:59:14','',''),(2783,'1','219','1',1,'Retail Sale Id 2823',3840.00,0.00,0.00,6.00,168.00,'2022-04-08 18:02:45','',''),(2784,'1','219','1',1,'Retail Sale Id 2824',1299.20,0.00,0.00,2.03,56.84,'2022-04-08 18:33:55','',''),(2785,'1','219','1',1,'Retail Sale Id 2825',8000.00,0.00,0.00,12.50,350.00,'2022-04-09 07:45:54','',''),(2786,'1','219','1',1,'Retail Sale Id 2826',3852.80,0.00,0.00,6.02,168.56,'2022-04-09 08:50:25','',''),(2787,'1','219','1',1,'Retail Sale Id 2828',3897.60,0.00,0.00,6.09,170.52,'2022-04-09 09:03:23','',''),(2788,'1','219','1',1,'Retail Sale Id 2829',1920.00,0.00,0.00,3.00,84.00,'2022-04-09 09:05:18','',''),(2789,'1','219','1',1,'Retail Sale Id 2831',4000.00,0.00,0.00,6.25,175.00,'2022-04-09 09:46:52','',''),(2790,'1','219','1',1,'Retail Sale Id 2832',6200.00,0.00,0.00,10.00,80.00,'2022-04-09 10:19:59','',''),(2791,'1','219','1',1,'Retail Sale Id 2833',1920.00,0.00,0.00,3.00,84.00,'2022-04-09 10:23:50','',''),(2792,'1','219','1',1,'Retail Sale Id 2833',6400.00,0.00,0.00,10.00,280.00,'2022-04-09 10:23:50','',''),(2793,'1','219','1',1,'Retail Sale Id 2834',8000.00,0.00,0.00,12.50,350.00,'2022-04-09 10:42:53','',''),(2794,'1','219','1',1,'Retail Sale Id 2835',1280.00,0.00,0.00,2.00,56.00,'2022-04-09 10:48:20','',''),(2795,'1','219','1',1,'Retail Sale Id 2839',3603.20,0.00,0.00,5.63,157.64,'2022-04-09 11:16:14','',''),(2796,'1','219','1',1,'Retail Sale Id 2840',31000.00,0.00,0.00,50.00,400.00,'2022-04-09 11:22:30','',''),(2797,'1','219','1',1,'Retail Sale Id 2841',8000.00,0.00,0.00,12.50,350.00,'2022-04-09 11:47:55','',''),(2798,'1','219','1',1,'Retail Sale Id 2842',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 11:53:55','',''),(2799,'1','219','1',1,'Retail Sale Id 2844',1267.20,0.00,0.00,1.98,55.44,'2022-04-09 11:58:22','',''),(2800,'1','219','1',1,'Retail Sale Id 2845',8000.00,0.00,0.00,12.50,350.00,'2022-04-09 12:03:20','',''),(2801,'1','219','1',1,'Retail Sale Id 2846',3200.00,0.00,0.00,5.00,140.00,'2022-04-09 12:17:16','',''),(2802,'1','219','1',1,'Retail Sale Id 2848',4000.00,0.00,0.00,6.25,175.00,'2022-04-09 12:28:27','',''),(2803,'1','219','1',1,'Retail Sale Id 2849',1860.00,0.00,0.00,3.00,24.00,'2022-04-09 12:37:49','',''),(2804,'1','219','1',1,'Retail Sale Id 2850',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 13:05:26','',''),(2805,'1','219','1',1,'Retail Sale Id 2851',1920.00,0.00,0.00,3.00,84.00,'2022-04-09 13:29:11','',''),(2806,'1','219','1',1,'Retail Sale Id 2852',8000.00,0.00,0.00,12.50,350.00,'2022-04-09 13:32:22','',''),(2807,'1','219','1',1,'Retail Sale Id 2853',3500.80,0.00,0.00,5.47,153.16,'2022-04-09 13:45:28','',''),(2808,'1','219','1',1,'Retail Sale Id 2854',3840.00,0.00,0.00,6.00,168.00,'2022-04-09 13:49:14','',''),(2809,'1','219','1',1,'Retail Sale Id 2855',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 13:50:15','',''),(2810,'1','219','1',1,'Retail Sale Id 2856',1932.80,0.00,0.00,3.02,84.56,'2022-04-09 14:00:48','',''),(2811,'1','219','1',1,'Retail Sale Id 2857',3001.60,0.00,0.00,4.69,131.32,'2022-04-09 14:10:04','',''),(2812,'1','219','1',1,'Retail Sale Id 2858',1932.80,0.00,0.00,3.02,84.56,'2022-04-09 14:18:05','',''),(2813,'1','219','1',1,'Retail Sale Id 2859',3840.00,0.00,0.00,6.00,168.00,'2022-04-09 14:24:54','',''),(2814,'1','219','1',1,'Retail Sale Id 2860',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 14:51:13','',''),(2815,'1','219','1',1,'Retail Sale Id 2863',3001.60,0.00,0.00,4.69,131.32,'2022-04-09 15:09:52','',''),(2816,'1','219','1',1,'Retail Sale Id 2864',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 15:15:37','',''),(2817,'1','219','1',1,'Retail Sale Id 2865',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 15:40:32','',''),(2818,'1','219','1',1,'Retail Sale Id 2866',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 15:55:47','',''),(2819,'1','219','1',1,'Retail Sale Id 2867',640.00,0.00,0.00,1.00,28.00,'2022-04-09 16:27:38','',''),(2820,'1','219','1',1,'Retail Sale Id 2868',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 16:30:06','',''),(2821,'1','219','1',1,'Retail Sale Id 2869',300.80,0.00,0.00,0.47,13.16,'2022-04-09 16:39:23','',''),(2822,'1','219','1',1,'Retail Sale Id 2870',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 16:41:55','',''),(2823,'1','219','1',1,'Retail Sale Id 2871',3720.00,0.00,0.00,6.00,48.00,'2022-04-09 16:47:21','',''),(2824,'1','219','1',1,'Retail Sale Id 2872',4000.00,0.00,0.00,6.25,175.00,'2022-04-09 16:49:08','',''),(2825,'1','219','1',1,'Retail Sale Id 2873',3720.00,0.00,0.00,6.00,48.00,'2022-04-09 16:59:05','',''),(2826,'1','219','1',1,'Retail Sale Id 2874',1920.00,0.00,0.00,3.00,84.00,'2022-04-09 17:02:07','',''),(2827,'1','219','1',1,'Retail Sale Id 2875',8000.00,0.00,0.00,12.50,350.00,'2022-04-09 17:04:14','',''),(2828,'1','219','1',1,'Retail Sale Id 2876',998.40,0.00,0.00,1.56,43.68,'2022-04-09 17:05:10','',''),(2829,'1','219','1',1,'Retail Sale Id 2877',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 17:08:04','',''),(2830,'1','219','1',1,'Retail Sale Id 2878',6400.00,0.00,0.00,10.00,280.00,'2022-04-09 17:16:03','',''),(2831,'1','219','1',1,'Retail Sale Id 2879',2003.20,0.00,0.00,3.13,87.64,'2022-04-09 17:21:40','',''),(2832,'1','219','1',1,'Retail Sale Id 2880',1497.60,0.00,0.00,2.34,65.52,'2022-04-09 17:41:19','',''),(2833,'1','219','1',1,'Retail Sale Id 2882',499.20,0.00,0.00,0.78,21.84,'2022-04-09 17:55:47','',''),(2834,'1','219','1',1,'Retail Sale Id 2883',3100.00,0.00,0.00,5.00,40.00,'2022-04-09 18:01:42','',''),(2835,'1','219','1',1,'Retail Sale Id 2884',652.80,0.00,0.00,1.02,28.56,'2022-04-09 18:04:28','',''),(2836,'1','219','1',1,'Retail Sale Id 2885',8000.00,0.00,0.00,12.50,350.00,'2022-04-09 18:12:08','',''),(2837,'1','219','1',1,'Retail Sale Id 2886',499.20,0.00,0.00,0.78,21.84,'2022-04-09 18:13:55','',''),(2838,'1','219','1',1,'Retail Sale Id 2887',8000.00,0.00,0.00,12.50,350.00,'2022-04-09 18:18:12','',''),(2839,'1','219','1',1,'Retail Sale Id 2888',998.40,0.00,0.00,1.56,43.68,'2022-04-09 18:27:53','',''),(2840,'1','219','1',1,'Retail Sale Id 2890',6400.00,0.00,0.00,10.00,280.00,'2022-04-10 08:43:02','',''),(2841,'1','219','1',1,'Retail Sale Id 2891',300.80,0.00,0.00,0.47,13.16,'2022-04-10 09:02:29','',''),(2842,'1','219','1',1,'Retail Sale Id 2892',3200.00,0.00,0.00,5.00,140.00,'2022-04-10 09:29:48','',''),(2843,'1','219','1',1,'Retail Sale Id 2893',62000.00,0.00,0.00,100.00,800.00,'2022-04-10 10:02:44','',''),(2844,'1','219','1',1,'Retail Sale Id 2894',8000.00,0.00,0.00,12.50,350.00,'2022-04-10 10:12:40','',''),(2845,'1','219','1',1,'Retail Sale Id 2895',3840.00,0.00,0.00,6.00,168.00,'2022-04-10 10:14:31','',''),(2846,'1','219','1',1,'Retail Sale Id 2897',6400.00,0.00,0.00,10.00,280.00,'2022-04-10 10:20:00','',''),(2847,'1','219','1',1,'Retail Sale Id 2898',3200.00,0.00,0.00,5.00,140.00,'2022-04-10 10:28:51','',''),(2848,'1','219','1',1,'Retail Sale Id 2901',2003.20,0.00,0.00,3.13,87.64,'2022-04-10 11:00:40','',''),(2849,'1','219','1',1,'Retail Sale Id 2902',10003.20,0.00,0.00,15.63,437.64,'2022-04-10 11:04:26','',''),(2850,'1','219','1',1,'Retail Sale Id 2904',8300.80,0.00,0.00,12.97,363.16,'2022-04-10 11:08:24','',''),(2851,'1','219','1',1,'Retail Sale Id 2905',3720.00,0.00,0.00,6.00,48.00,'2022-04-10 11:09:25','',''),(2852,'1','219','1',1,'Retail Sale Id 2906',1203.20,0.00,0.00,1.88,52.64,'2022-04-10 11:18:22','',''),(2853,'1','219','1',1,'Retail Sale Id 2908',3200.00,0.00,0.00,5.00,140.00,'2022-04-10 11:29:19','',''),(2854,'1','219','1',1,'Retail Sale Id 2909',1497.60,0.00,0.00,2.34,65.52,'2022-04-10 11:33:12','',''),(2855,'1','219','1',1,'Retail Sale Id 2910',1299.20,0.00,0.00,2.03,56.84,'2022-04-10 11:35:20','',''),(2856,'1','219','1',1,'Retail Sale Id 2911',8000.00,0.00,0.00,12.50,350.00,'2022-04-10 11:36:52','',''),(2857,'1','219','1',1,'Retail Sale Id 2912',4000.00,0.00,0.00,6.25,175.00,'2022-04-10 11:37:55','',''),(2858,'1','219','1',1,'Retail Sale Id 2913',4000.00,0.00,0.00,6.25,175.00,'2022-04-10 11:38:48','',''),(2859,'1','219','1',1,'Retail Sale Id 2914',3840.00,0.00,0.00,6.00,168.00,'2022-04-10 11:40:27','',''),(2860,'1','219','1',1,'Retail Sale Id 2915',6400.00,0.00,0.00,10.00,280.00,'2022-04-10 11:46:28','',''),(2861,'1','219','1',1,'Retail Sale Id 2916',8000.00,0.00,0.00,12.50,350.00,'2022-04-10 11:48:50','',''),(2862,'1','219','1',1,'Retail Sale Id 2917',8000.00,0.00,0.00,12.50,350.00,'2022-04-10 11:57:58','',''),(2863,'1','219','1',1,'Retail Sale Id 2918',3840.00,0.00,0.00,6.00,168.00,'2022-04-10 12:09:11','',''),(2864,'1','219','1',1,'Retail Sale Id 2919',1920.00,0.00,0.00,3.00,84.00,'2022-04-10 12:19:05','',''),(2865,'1','219','1',1,'Retail Sale Id 2920',8000.00,0.00,0.00,12.50,350.00,'2022-04-10 12:22:46','',''),(2866,'1','219','1',1,'Retail Sale Id 2921',2502.40,0.00,0.00,3.91,109.48,'2022-04-10 12:45:42','',''),(2867,'1','219','1',1,'Retail Sale Id 2922',998.40,0.00,0.00,1.56,43.68,'2022-04-10 12:52:56','',''),(2868,'1','219','1',1,'Retail Sale Id 2923',3200.00,0.00,0.00,5.00,140.00,'2022-04-10 12:59:00','',''),(2869,'1','219','1',1,'Retail Sale Id 2924',300.80,0.00,0.00,0.47,13.16,'2022-04-10 13:01:12','',''),(2870,'1','219','1',1,'Retail Sale Id 2925',3200.00,0.00,0.00,5.00,140.00,'2022-04-10 13:10:26','',''),(2871,'1','219','1',1,'Retail Sale Id 2926',1497.60,0.00,0.00,2.34,65.52,'2022-04-10 13:16:23','',''),(2872,'1','219','1',1,'Retail Sale Id 2927',8000.00,0.00,0.00,12.50,350.00,'2022-04-10 13:21:23','',''),(2873,'1','219','1',1,'Retail Sale Id 2928',3001.60,0.00,0.00,4.69,131.32,'2022-04-10 14:27:15','',''),(2874,'1','219','1',1,'Retail Sale Id 2930',3840.00,0.00,0.00,6.00,168.00,'2022-04-10 14:33:29','',''),(2875,'1','219','1',1,'Retail Sale Id 2931',3840.00,0.00,0.00,6.00,168.00,'2022-04-10 14:48:42','',''),(2876,'1','219','1',1,'Retail Sale Id 2932',1920.00,0.00,0.00,3.00,84.00,'2022-04-10 15:01:18','',''),(2877,'1','219','1',1,'Retail Sale Id 2933',2003.20,0.00,0.00,3.13,87.64,'2022-04-10 15:15:56','',''),(2878,'1','219','1',1,'Retail Sale Id 2934',499.20,0.00,0.00,0.78,21.84,'2022-04-10 15:21:53','',''),(2879,'1','219','1',1,'Retail Sale Id 2935',3840.00,0.00,0.00,6.00,168.00,'2022-04-10 15:40:19','',''),(2880,'1','219','1',1,'Retail Sale Id 2936',1920.00,0.00,0.00,3.00,84.00,'2022-04-10 16:04:14','',''),(2881,'1','219','1',1,'Retail Sale Id 2937',2003.20,0.00,0.00,3.13,87.64,'2022-04-10 16:12:54','',''),(2882,'1','219','1',1,'Retail Sale Id 2938',998.40,0.00,0.00,1.56,43.68,'2022-04-10 16:14:13','',''),(2883,'1','219','1',1,'Retail Sale Id 2939',2003.20,0.00,0.00,3.13,87.64,'2022-04-10 16:18:20','',''),(2884,'1','219','1',1,'Retail Sale Id 2940',499.20,0.00,0.00,0.78,21.84,'2022-04-10 16:19:16','',''),(2885,'1','219','1',1,'Retail Sale Id 2941',4998.40,0.00,0.00,7.81,218.68,'2022-04-10 16:29:50','',''),(2886,'1','219','1',1,'Retail Sale Id 2942',499.20,0.00,0.00,0.78,21.84,'2022-04-10 16:40:04','',''),(2887,'1','219','1',1,'Retail Sale Id 2943',1920.00,0.00,0.00,3.00,84.00,'2022-04-10 16:56:07','',''),(2888,'1','219','1',1,'Retail Sale Id 2944',998.40,0.00,0.00,1.56,43.68,'2022-04-10 16:57:12','',''),(2889,'1','219','1',1,'Retail Sale Id 2945',1280.00,0.00,0.00,2.00,56.00,'2022-04-10 16:57:53','',''),(2890,'1','219','1',1,'Retail Sale Id 2946',902.40,0.00,0.00,1.41,39.48,'2022-04-10 17:10:12','',''),(2891,'1','219','1',1,'Retail Sale Id 2947',697.60,0.00,0.00,1.09,30.52,'2022-04-10 17:11:24','',''),(2892,'1','219','1',1,'Retail Sale Id 2948',2003.20,0.00,0.00,3.13,87.64,'2022-04-10 17:21:58','',''),(2893,'1','219','1',1,'Retail Sale Id 2949',697.60,0.00,0.00,1.09,30.52,'2022-04-10 17:27:11','',''),(2894,'1','219','1',1,'Retail Sale Id 2950',960.00,0.00,0.00,1.50,42.00,'2022-04-10 17:32:27','',''),(2895,'1','219','1',1,'Retail Sale Id 2951',2560.00,0.00,0.00,4.00,112.00,'2022-04-10 17:50:17','',''),(2896,'1','219','1',1,'Retail Sale Id 2952',1920.00,0.00,0.00,3.00,84.00,'2022-04-10 17:54:00','',''),(2897,'1','219','1',1,'Retail Sale Id 2953',3840.00,0.00,0.00,6.00,168.00,'2022-04-10 17:55:22','',''),(2898,'1','219','1',1,'Retail Sale Id 2954',1299.20,0.00,0.00,2.03,56.84,'2022-04-10 18:03:43','',''),(2899,'1','219','1',1,'Retail Sale Id 2955',1299.20,0.00,0.00,2.03,56.84,'2022-04-10 18:11:56','',''),(2900,'1','219','1',1,'Retail Sale Id 2956',499.20,0.00,0.00,0.78,21.84,'2022-04-10 18:18:37','',''),(2901,'1','219','1',1,'Retail Sale Id 2957',2003.20,0.00,0.00,3.13,87.64,'2022-04-11 07:43:09','',''),(2902,'1','219','1',1,'Retail Sale Id 2958',4000.00,0.00,0.00,6.25,175.00,'2022-04-11 07:55:17','',''),(2903,'1','219','1',1,'Retail Sale Id 2959',8000.00,0.00,0.00,12.50,350.00,'2022-04-11 08:19:56','',''),(2904,'1','219','1',1,'Retail Sale Id 2960',4000.00,0.00,0.00,6.25,175.00,'2022-04-11 08:21:25','',''),(2905,'1','219','1',1,'Retail Sale Id 2961',3500.80,0.00,0.00,5.47,153.16,'2022-04-11 08:50:02','',''),(2906,'1','219','1',1,'Retail Sale Id 2963',1939.20,0.00,0.00,3.03,84.84,'2022-04-11 09:10:08','',''),(2907,'1','219','1',1,'Retail Sale Id 2963',2560.00,0.00,0.00,4.00,112.00,'2022-04-11 09:10:08','',''),(2908,'1','219','1',1,'Retail Sale Id 2964',4000.00,0.00,0.00,6.25,175.00,'2022-04-11 09:20:58','',''),(2909,'1','219','1',1,'Retail Sale Id 2966',2502.40,0.00,0.00,3.91,109.48,'2022-04-11 09:56:29','',''),(2910,'1','219','1',1,'Retail Sale Id 2967',4000.00,0.00,0.00,6.25,175.00,'2022-04-11 10:09:00','',''),(2911,'1','219','1',1,'Retail Sale Id 2968',3001.60,0.00,0.00,4.69,131.32,'2022-04-11 10:10:33','',''),(2912,'1','219','1',1,'Retail Sale Id 2969',697.60,0.00,0.00,1.09,30.52,'2022-04-11 10:16:07','',''),(2913,'1','219','1',1,'Retail Sale Id 2970',3001.60,0.00,0.00,4.69,131.32,'2022-04-11 10:33:56','',''),(2914,'1','219','1',1,'Retail Sale Id 2971',6200.00,0.00,0.00,10.00,80.00,'2022-04-11 10:40:42','',''),(2915,'1','219','1',1,'Retail Sale Id 2972',0.00,0.00,0.00,0.00,0.00,'2022-04-11 10:41:52','',''),(2916,'1','219','1',1,'Retail Sale Id 2973',7440.00,0.00,0.00,12.00,96.00,'2022-04-11 10:51:34','',''),(2917,'1','219','1',1,'Retail Sale Id 2974',3200.00,0.00,0.00,5.00,140.00,'2022-04-11 11:01:52','',''),(2918,'1','219','1',1,'Retail Sale Id 2975',2700.80,0.00,0.00,4.22,118.16,'2022-04-11 11:06:00','',''),(2919,'1','219','1',1,'Retail Sale Id 2976',8320.00,0.00,0.00,13.00,364.00,'2022-04-11 11:09:21','',''),(2920,'1','219','1',1,'Retail Sale Id 2977',31000.00,0.00,0.00,50.00,400.00,'2022-04-11 12:22:54','',''),(2921,'1','219','1',1,'Retail Sale Id 2978',3840.00,0.00,0.00,6.00,168.00,'2022-04-11 12:25:51','',''),(2922,'1','219','1',1,'Retail Sale Id 2979',4000.00,0.00,0.00,6.25,175.00,'2022-04-11 12:27:32','',''),(2923,'1','219','1',1,'Retail Sale Id 2980',3500.80,0.00,0.00,5.47,153.16,'2022-04-11 12:41:27','',''),(2924,'1','219','1',1,'Retail Sale Id 2982',1702.40,0.00,0.00,2.66,74.48,'2022-04-11 12:45:23','',''),(2925,'1','219','1',1,'Retail Sale Id 2983',2560.00,0.00,0.00,4.00,112.00,'2022-04-11 13:30:41','',''),(2926,'1','219','1',1,'Retail Sale Id 2984',1920.00,0.00,0.00,3.00,84.00,'2022-04-11 13:48:43','',''),(2927,'1','219','1',1,'Retail Sale Id 2985',2400.00,0.00,0.00,3.75,105.00,'2022-04-11 14:45:59','',''),(2928,'1','219','1',1,'Retail Sale Id 2986',8000.00,0.00,0.00,12.50,350.00,'2022-04-11 14:48:14','',''),(2929,'1','219','1',1,'Retail Sale Id 2987',3801.60,0.00,0.00,5.94,166.32,'2022-04-11 15:31:22','',''),(2930,'1','219','1',1,'Retail Sale Id 2988',998.40,0.00,0.00,1.56,43.68,'2022-04-11 15:32:46','',''),(2931,'1','219','1',1,'Retail Sale Id 2989',998.40,0.00,0.00,1.56,43.68,'2022-04-11 15:34:04','',''),(2932,'1','219','1',1,'Retail Sale Id 2990',3840.00,0.00,0.00,6.00,168.00,'2022-04-11 15:37:55','',''),(2933,'1','219','1',1,'Retail Sale Id 2991',1702.40,0.00,0.00,2.66,74.48,'2022-04-11 15:42:01','',''),(2934,'1','219','1',1,'Retail Sale Id 2993',300.80,0.00,0.00,0.47,13.16,'2022-04-11 16:56:10','',''),(2935,'1','219','1',1,'Retail Sale Id 2994',300.80,0.00,0.00,0.47,13.16,'2022-04-11 16:56:54','',''),(2936,'1','219','1',1,'Retail Sale Id 2995',8000.00,0.00,0.00,12.50,350.00,'2022-04-11 16:59:37','',''),(2937,'1','219','1',1,'Retail Sale Id 2996',3200.00,0.00,0.00,5.00,140.00,'2022-04-11 17:10:34','',''),(2938,'1','219','1',1,'Retail Sale Id 2997',6400.00,0.00,0.00,10.00,280.00,'2022-04-11 17:12:31','',''),(2939,'1','219','1',1,'Retail Sale Id 2999',3840.00,0.00,0.00,6.00,168.00,'2022-04-11 17:15:45','',''),(2940,'1','219','1',1,'Retail Sale Id 3000',499.20,0.00,0.00,0.78,21.84,'2022-04-11 17:16:42','',''),(2941,'1','219','1',1,'Retail Sale Id 3001',2003.20,0.00,0.00,3.13,87.64,'2022-04-11 17:36:12','',''),(2942,'1','219','1',1,'Retail Sale Id 3002',6400.00,0.00,0.00,10.00,280.00,'2022-04-11 17:37:01','',''),(2943,'1','219','1',1,'Retail Sale Id 3003',1939.20,0.00,0.00,3.03,84.84,'2022-04-11 17:39:59','',''),(2944,'1','219','1',1,'Retail Sale Id 3004',2003.20,0.00,0.00,3.13,87.64,'2022-04-11 17:45:57','',''),(2945,'1','219','1',1,'Retail Sale Id 3005',1497.60,0.00,0.00,2.34,65.52,'2022-04-11 17:46:46','',''),(2946,'1','219','1',1,'Retail Sale Id 3006',800.00,0.00,0.00,1.25,35.00,'2022-04-11 18:11:40','',''),(2947,'1','219','1',1,'Retail Sale Id 3007',1401.60,0.00,0.00,2.19,61.32,'2022-04-11 18:23:40','',''),(2948,'1','219','1',1,'Retail Sale Id 3009',6118.40,0.00,0.00,9.56,267.68,'2022-04-11 18:51:25','',''),(2949,'1','219','1',1,'Retail Sale Id 3010',31000.00,0.00,0.00,50.00,400.00,'2022-04-12 08:05:13','',''),(2950,'1','219','1',1,'Retail Sale Id 3011',3840.00,0.00,0.00,6.00,168.00,'2022-04-12 10:15:58','',''),(2951,'1','219','1',1,'Retail Sale Id 3015',3840.00,0.00,0.00,6.00,168.00,'2022-04-12 10:49:17','',''),(2952,'1','219','1',1,'Retail Sale Id 3016',7680.00,0.00,0.00,12.00,336.00,'2022-04-12 10:50:54','',''),(2953,'1','219','1',1,'Retail Sale Id 3018',7040.00,0.00,0.00,11.00,308.00,'2022-04-12 10:53:41','',''),(2954,'1','219','1',1,'Retail Sale Id 3019',1920.00,0.00,0.00,3.00,84.00,'2022-04-12 10:57:30','',''),(2955,'1','219','1',1,'Retail Sale Id 3019',1920.00,0.00,0.00,3.00,84.00,'2022-04-12 10:57:30','',''),(2956,'1','219','1',1,'Retail Sale Id 3020',3840.00,0.00,0.00,6.00,168.00,'2022-04-12 11:18:58','',''),(2957,'1','219','1',1,'Retail Sale Id 3021',4000.00,0.00,0.00,6.25,175.00,'2022-04-12 11:27:07','',''),(2958,'1','219','1',1,'Retail Sale Id 3022',6400.00,0.00,0.00,10.00,280.00,'2022-04-12 11:49:37','',''),(2959,'1','219','1',1,'Retail Sale Id 3023',1920.00,0.00,0.00,3.00,84.00,'2022-04-12 12:23:27','',''),(2960,'1','219','1',1,'Retail Sale Id 3024',1920.00,0.00,0.00,3.00,84.00,'2022-04-12 13:00:15','',''),(2961,'1','219','1',1,'Retail Sale Id 3025',3001.60,0.00,0.00,4.69,131.32,'2022-04-12 13:31:46','',''),(2962,'1','219','1',1,'Retail Sale Id 3026',3001.60,0.00,0.00,4.69,131.32,'2022-04-12 13:32:50','',''),(2963,'1','219','1',1,'Retail Sale Id 3027',4998.40,0.00,0.00,7.81,218.68,'2022-04-12 13:36:30','',''),(2964,'1','219','1',1,'Retail Sale Id 3028',1920.00,0.00,0.00,3.00,84.00,'2022-04-12 13:59:50','',''),(2965,'1','219','1',1,'Retail Sale Id 3028',3840.00,0.00,0.00,6.00,168.00,'2022-04-12 13:59:50','',''),(2966,'1','219','1',1,'Retail Sale Id 3029',499.20,0.00,0.00,0.78,21.84,'2022-04-12 14:13:04','',''),(2967,'1','219','1',1,'Retail Sale Id 3030',3200.00,0.00,0.00,5.00,140.00,'2022-04-12 14:30:47','',''),(2968,'1','219','1',1,'Retail Sale Id 3031',3100.00,0.00,0.00,5.00,40.00,'2022-04-12 14:38:18','',''),(2969,'1','219','1',1,'Retail Sale Id 3032',3801.60,0.00,0.00,5.94,166.32,'2022-04-12 14:41:03','',''),(2970,'1','219','1',1,'Retail Sale Id 3033',6400.00,0.00,0.00,10.00,280.00,'2022-04-12 14:52:53','',''),(2971,'1','219','1',1,'Retail Sale Id 3034',2003.20,0.00,0.00,3.13,87.64,'2022-04-12 15:12:26','',''),(2972,'1','219','1',1,'Retail Sale Id 3035',2560.00,0.00,0.00,4.00,112.00,'2022-04-12 15:18:22','',''),(2973,'1','219','1',1,'Retail Sale Id 3037',31000.00,0.00,0.00,50.00,400.00,'2022-04-12 15:34:49','',''),(2974,'1','219','1',1,'Retail Sale Id 3038',3200.00,0.00,0.00,5.00,140.00,'2022-04-12 15:46:07','',''),(2975,'1','219','1',1,'Retail Sale Id 3039',2003.20,0.00,0.00,3.13,87.64,'2022-04-12 16:07:01','',''),(2976,'1','219','1',1,'Retail Sale Id 3040',3200.00,0.00,0.00,5.00,140.00,'2022-04-12 16:22:31','',''),(2977,'1','219','1',1,'Retail Sale Id 3041',2003.20,0.00,0.00,3.13,87.64,'2022-04-12 16:23:46','',''),(2978,'1','219','1',1,'Retail Sale Id 3042',3852.80,0.00,0.00,6.02,168.56,'2022-04-12 16:37:18','',''),(2979,'1','219','1',1,'Retail Sale Id 3043',8000.00,0.00,0.00,12.50,350.00,'2022-04-12 16:38:16','',''),(2980,'1','219','1',1,'Retail Sale Id 3044',3840.00,0.00,0.00,6.00,168.00,'2022-04-12 16:39:37','',''),(2981,'1','219','1',1,'Retail Sale Id 3045',4998.40,0.00,0.00,7.81,218.68,'2022-04-12 16:42:20','',''),(2982,'1','219','1',1,'Retail Sale Id 3046',3840.00,0.00,0.00,6.00,168.00,'2022-04-12 16:49:05','',''),(2983,'1','219','1',1,'Retail Sale Id 3047',2003.20,0.00,0.00,3.13,87.64,'2022-04-12 17:04:59','',''),(2984,'1','219','1',1,'Retail Sale Id 3048',3840.00,0.00,0.00,6.00,168.00,'2022-04-12 17:09:34','',''),(2985,'1','219','1',1,'Retail Sale Id 3049',499.20,0.00,0.00,0.78,21.84,'2022-04-12 17:15:01','',''),(2986,'1','219','1',1,'Retail Sale Id 3050',1497.60,0.00,0.00,2.34,65.52,'2022-04-12 17:16:06','',''),(2987,'1','219','1',1,'Retail Sale Id 3051',6820.00,0.00,0.00,11.00,88.00,'2022-04-12 17:17:36','',''),(2988,'1','219','1',1,'Retail Sale Id 3052',3200.00,0.00,0.00,5.00,140.00,'2022-04-12 17:24:41','',''),(2989,'1','219','1',1,'Retail Sale Id 3053',300.80,0.00,0.00,0.47,13.16,'2022-04-12 17:28:28','',''),(2990,'1','219','1',1,'Retail Sale Id 3054',3840.00,0.00,0.00,6.00,168.00,'2022-04-12 17:38:57','',''),(2991,'1','219','1',1,'Retail Sale Id 3055',2598.40,0.00,0.00,4.06,113.68,'2022-04-12 17:47:54','',''),(2992,'1','219','1',1,'Retail Sale Id 3056',998.40,0.00,0.00,1.56,43.68,'2022-04-12 17:54:41','',''),(2993,'1','219','1',1,'Retail Sale Id 3057',499.20,0.00,0.00,0.78,21.84,'2022-04-12 18:10:25','',''),(2994,'1','219','1',1,'Retail Sale Id 3058',300.80,0.00,0.00,0.47,13.16,'2022-04-12 18:14:44','',''),(2995,'1','219','1',1,'Retail Sale Id 3059',4480.00,0.00,0.00,7.00,196.00,'2022-04-13 07:18:11','',''),(2996,'1','219','1',1,'Retail Sale Id 3060',2003.20,0.00,0.00,3.13,87.64,'2022-04-13 07:41:34','',''),(2997,'1','219','1',1,'Retail Sale Id 3061',2560.00,0.00,0.00,4.00,112.00,'2022-04-13 08:35:22','',''),(2998,'1','219','1',1,'Retail Sale Id 3062',998.40,0.00,0.00,1.56,43.68,'2022-04-13 08:58:53','',''),(2999,'1','219','1',1,'Retail Sale Id 3063',62000.00,0.00,0.00,100.00,800.00,'2022-04-13 09:06:50','',''),(3000,'1','219','1',1,'Retail Sale Id 3064',8000.00,0.00,0.00,12.50,350.00,'2022-04-13 09:21:42','',''),(3001,'1','219','1',1,'Retail Sale Id 3065',6400.00,0.00,0.00,10.00,280.00,'2022-04-13 09:32:07','',''),(3002,'1','219','1',1,'Retail Sale Id 3066',1497.60,0.00,0.00,2.34,65.52,'2022-04-13 09:39:59','',''),(3003,'1','219','1',1,'Retail Sale Id 3067',5760.00,0.00,0.00,9.00,252.00,'2022-04-13 09:47:46','',''),(3004,'1','219','1',1,'Retail Sale Id 3068',1203.20,0.00,0.00,1.88,52.64,'2022-04-13 10:30:13','',''),(3005,'1','219','1',1,'Retail Sale Id 3069',3840.00,0.00,0.00,6.00,168.00,'2022-04-13 10:40:12','',''),(3006,'1','219','1',1,'Retail Sale Id 3070',3840.00,0.00,0.00,6.00,168.00,'2022-04-13 10:43:55','',''),(3007,'1','219','1',1,'Retail Sale Id 3071',499.20,0.00,0.00,0.78,21.84,'2022-04-13 10:45:04','',''),(3008,'1','219','1',1,'Retail Sale Id 3072',1497.60,0.00,0.00,2.34,65.52,'2022-04-13 10:51:56','',''),(3009,'1','219','1',1,'Retail Sale Id 3073',6400.00,0.00,0.00,10.00,280.00,'2022-04-13 10:57:31','',''),(3010,'1','219','1',1,'Retail Sale Id 3074',3200.00,0.00,0.00,5.00,140.00,'2022-04-13 11:42:45','',''),(3011,'1','219','1',1,'Retail Sale Id 3075',3840.00,0.00,0.00,6.00,168.00,'2022-04-13 11:47:58','',''),(3012,'1','219','1',1,'Retail Sale Id 3076',3500.80,0.00,0.00,5.47,153.16,'2022-04-13 11:49:25','',''),(3013,'1','219','1',1,'Retail Sale Id 3077',499.20,0.00,0.00,0.78,21.84,'2022-04-13 11:50:18','',''),(3014,'1','219','1',1,'Retail Sale Id 3078',3200.00,0.00,0.00,5.00,140.00,'2022-04-13 11:56:17','',''),(3015,'1','219','1',1,'Retail Sale Id 3079',2803.20,0.00,0.00,4.38,122.64,'2022-04-13 12:03:11','',''),(3016,'1','219','1',1,'Retail Sale Id 3081',2003.20,0.00,0.00,3.13,87.64,'2022-04-13 12:14:37','',''),(3017,'1','219','1',1,'Retail Sale Id 3084',1299.20,0.00,0.00,2.03,56.84,'2022-04-13 12:16:12','',''),(3018,'1','219','1',1,'Retail Sale Id 3085',1299.20,0.00,0.00,2.03,56.84,'2022-04-13 12:20:01','',''),(3019,'1','219','1',1,'Retail Sale Id 3086',3200.00,0.00,0.00,5.00,140.00,'2022-04-13 12:20:58','',''),(3020,'1','219','1',1,'Retail Sale Id 3087',8000.00,0.00,0.00,12.50,350.00,'2022-04-13 12:25:42','',''),(3021,'1','219','1',1,'Retail Sale Id 3088',8000.00,0.00,0.00,12.50,350.00,'2022-04-13 12:48:22','',''),(3022,'1','219','1',1,'Retail Sale Id 3089',3200.00,0.00,0.00,5.00,140.00,'2022-04-13 13:22:51','',''),(3023,'1','219','1',1,'Retail Sale Id 3090',3001.60,0.00,0.00,4.69,131.32,'2022-04-13 13:26:09','',''),(3024,'1','219','1',1,'Retail Sale Id 3091',8000.00,0.00,0.00,12.50,350.00,'2022-04-13 13:44:35','',''),(3025,'1','219','1',1,'Retail Sale Id 3092',998.40,0.00,0.00,1.56,43.68,'2022-04-13 14:10:39','',''),(3026,'1','219','1',1,'Retail Sale Id 3093',3200.00,0.00,0.00,5.00,140.00,'2022-04-13 14:24:43','',''),(3027,'1','219','1',1,'Retail Sale Id 3094',1920.00,0.00,0.00,3.00,84.00,'2022-04-13 14:35:04','',''),(3028,'1','219','1',1,'Retail Sale Id 3095',2003.20,0.00,0.00,3.13,87.64,'2022-04-13 14:53:41','',''),(3029,'1','219','1',1,'Retail Sale Id 3096',4480.00,0.00,0.00,7.00,196.00,'2022-04-13 14:56:21','',''),(3030,'1','219','1',1,'Retail Sale Id 3097',998.40,0.00,0.00,1.56,43.68,'2022-04-13 15:00:40','',''),(3031,'1','219','1',1,'Retail Sale Id 3098',499.20,0.00,0.00,0.78,21.84,'2022-04-13 15:07:30','',''),(3032,'1','219','1',1,'Retail Sale Id 3099',1299.20,0.00,0.00,2.03,56.84,'2022-04-13 15:08:27','',''),(3033,'1','219','1',1,'Retail Sale Id 3100',998.40,0.00,0.00,1.56,43.68,'2022-04-13 15:17:09','',''),(3034,'1','219','1',1,'Retail Sale Id 3101',2003.20,0.00,0.00,3.13,87.64,'2022-04-13 15:45:44','',''),(3035,'1','219','1',1,'Retail Sale Id 3102',2480.00,0.00,0.00,4.00,32.00,'2022-04-13 16:26:34','',''),(3036,'1','219','1',1,'Retail Sale Id 3103',5120.00,0.00,0.00,8.00,224.00,'2022-04-13 16:28:34','',''),(3037,'1','219','1',1,'Retail Sale Id 3104',1100.80,0.00,0.00,1.72,48.16,'2022-04-13 17:03:14','',''),(3038,'1','219','1',1,'Retail Sale Id 3105',1798.40,0.00,0.00,2.81,78.68,'2022-04-13 17:18:35','',''),(3039,'1','219','1',1,'Retail Sale Id 3106',1299.20,0.00,0.00,2.03,56.84,'2022-04-13 17:21:05','',''),(3040,'1','219','1',1,'Retail Sale Id 3107',2003.20,0.00,0.00,3.13,87.64,'2022-04-13 17:36:13','',''),(3041,'1','219','1',1,'Retail Sale Id 3108',499.20,0.00,0.00,0.78,21.84,'2022-04-13 17:38:44','',''),(3042,'1','219','1',1,'Retail Sale Id 3109',2003.20,0.00,0.00,3.13,87.64,'2022-04-13 17:40:23','',''),(3043,'1','219','1',1,'Retail Sale Id 3110',998.40,0.00,0.00,1.56,43.68,'2022-04-13 17:43:30','',''),(3044,'1','219','1',1,'Retail Sale Id 3111',3840.00,0.00,0.00,6.00,168.00,'2022-04-13 17:53:44','',''),(3045,'1','219','1',1,'Retail Sale Id 3112',300.80,0.00,0.00,0.47,13.16,'2022-04-13 18:04:36','',''),(3046,'1','219','1',1,'Retail Sale Id 3113',697.60,0.00,0.00,1.09,30.52,'2022-04-13 18:09:40','',''),(3047,'1','219','1',1,'Retail Sale Id 3114',8000.00,0.00,0.00,12.50,350.00,'2022-04-13 18:13:31','',''),(3048,'1','219','1',1,'Retail Sale Id 3115',3001.60,0.00,0.00,4.69,131.32,'2022-04-13 18:19:39','',''),(3049,'1','219','1',1,'Return of Retail Sale Id 3114',0.00,8000.00,12.50,0.00,-350.00,'2022-04-13 23:32:01','',''),(3050,'1','219','1',1,'Retail Sale Id 3116',11193.60,0.00,0.00,17.49,489.72,'2022-04-13 23:33:52','',''),(3051,'1','219','1',1,'Return of Retail Sale Id 3103',0.00,5120.00,8.00,0.00,-224.00,'2022-04-13 23:35:06','',''),(3052,'1','219','1',1,'Retail Sale Id 3117',998.40,0.00,0.00,1.56,43.68,'2022-04-13 23:36:48','',''),(3053,'1','219','1',1,'Return of Retail Sale Id 3102',0.00,2480.00,4.00,0.00,-32.00,'2022-04-13 23:39:32','',''),(3054,'1','219','1',1,'Retail Sale Id 3118',2529.60,0.00,0.00,4.08,32.64,'2022-04-13 23:41:36','',''),(3055,'1','219','1',1,'Retail Sale Id 3119',3840.00,0.00,0.00,6.00,168.00,'2022-04-14 08:23:28','',''),(3056,'1','219','1',1,'Retail Sale Id 3120',3840.00,0.00,0.00,6.00,168.00,'2022-04-14 08:26:01','',''),(3057,'1','219','1',1,'Retail Sale Id 3122',18600.00,0.00,0.00,30.00,240.00,'2022-04-14 08:29:59','',''),(3058,'1','219','1',1,'Retail Sale Id 3125',12147.20,0.00,0.00,18.98,531.44,'2022-04-14 10:38:04','',''),(3059,'1','219','1',1,'Retail Sale Id 3127',3852.80,0.00,0.00,6.02,168.56,'2022-04-14 10:39:25','',''),(3060,'1','219','1',1,'Retail Sale Id 3128',3001.60,0.00,0.00,4.69,131.32,'2022-04-14 10:52:53','',''),(3061,'1','219','1',1,'Retail Sale Id 3129',8000.00,0.00,0.00,12.50,350.00,'2022-04-14 10:56:49','',''),(3062,'1','219','1',1,'Retail Sale Id 3130',3840.00,0.00,0.00,6.00,168.00,'2022-04-14 11:26:31','',''),(3063,'1','219','1',1,'Retail Sale Id 3131',3852.80,0.00,0.00,6.02,168.56,'2022-04-14 11:27:29','',''),(3064,'1','219','1',1,'Retail Sale Id 3132',3840.00,0.00,0.00,6.00,168.00,'2022-04-14 11:28:13','',''),(3065,'1','219','1',1,'Retail Sale Id 3133',1203.20,0.00,0.00,1.88,52.64,'2022-04-14 11:31:05','',''),(3066,'1','219','1',1,'Retail Sale Id 3134',1299.20,0.00,0.00,2.03,56.84,'2022-04-14 11:34:53','',''),(3067,'1','219','1',1,'Retail Sale Id 3135',3840.00,0.00,0.00,6.00,168.00,'2022-04-14 11:41:08','',''),(3068,'1','219','1',1,'Retail Sale Id 3136',697.60,0.00,0.00,1.09,30.52,'2022-04-14 11:49:59','',''),(3069,'1','219','1',1,'Retail Sale Id 3137',8000.00,0.00,0.00,12.50,350.00,'2022-04-14 12:06:41','',''),(3070,'1','219','1',1,'Retail Sale Id 3138',8000.00,0.00,0.00,12.50,350.00,'2022-04-14 12:09:17','',''),(3071,'1','219','1',1,'Return of Retail Sale Id 3137',0.00,8000.00,12.50,0.00,-350.00,'2022-04-14 12:19:32','',''),(3072,'1','219','1',1,'Retail Sale Id 3139',1860.00,0.00,0.00,3.00,24.00,'2022-04-14 12:41:15','',''),(3073,'1','219','1',1,'Retail Sale Id 3140',3840.00,0.00,0.00,6.00,168.00,'2022-04-14 13:03:06','',''),(3074,'1','219','1',1,'Retail Sale Id 3141',3875.00,0.00,0.00,6.25,50.00,'2022-04-14 13:06:33','',''),(3075,'1','219','1',1,'Retail Sale Id 3142',2003.20,0.00,0.00,3.13,87.64,'2022-04-14 13:08:47','',''),(3076,'1','219','1',1,'Retail Sale Id 3143',1920.00,0.00,0.00,3.00,84.00,'2022-04-14 13:10:09','',''),(3077,'1','219','1',1,'Retail Sale Id 3144',4998.40,0.00,0.00,7.81,218.68,'2022-04-14 13:18:58','',''),(3078,'1','219','1',1,'Retail Sale Id 3145',8000.00,0.00,0.00,12.50,350.00,'2022-04-14 13:20:11','',''),(3079,'1','219','1',1,'Retail Sale Id 3146',2003.20,0.00,0.00,3.13,87.64,'2022-04-14 13:24:50','',''),(3080,'1','219','1',1,'Retail Sale Id 3148',3801.60,0.00,0.00,5.94,166.32,'2022-04-14 13:36:32','',''),(3081,'1','219','1',1,'Retail Sale Id 3151',499.20,0.00,0.00,0.78,21.84,'2022-04-14 14:55:17','',''),(3082,'1','219','1',1,'Retail Sale Id 3153',1401.60,0.00,0.00,2.19,61.32,'2022-04-14 15:02:31','',''),(3083,'1','219','1',1,'Retail Sale Id 3154',2598.40,0.00,0.00,4.06,113.68,'2022-04-14 15:08:23','',''),(3084,'1','219','1',1,'Retail Sale Id 3155',2003.20,0.00,0.00,3.13,87.64,'2022-04-14 15:36:51','',''),(3085,'1','219','1',1,'Retail Sale Id 3156',1497.60,0.00,0.00,2.34,65.52,'2022-04-14 15:47:06','',''),(3086,'1','219','1',1,'Retail Sale Id 3157',2003.20,0.00,0.00,3.13,87.64,'2022-04-14 15:51:55','',''),(3087,'1','219','1',1,'Retail Sale Id 3158',998.40,0.00,0.00,1.56,43.68,'2022-04-14 16:23:17','',''),(3088,'1','219','1',1,'Retail Sale Id 3159',3840.00,0.00,0.00,6.00,168.00,'2022-04-14 16:27:29','',''),(3089,'1','219','1',1,'Retail Sale Id 3161',8000.00,0.00,0.00,12.50,350.00,'2022-04-14 16:31:10','',''),(3090,'1','219','1',1,'Retail Sale Id 3162',3840.00,0.00,0.00,6.00,168.00,'2022-04-14 16:35:14','',''),(3091,'1','219','1',1,'Retail Sale Id 3163',998.40,0.00,0.00,1.56,43.68,'2022-04-14 16:41:22','',''),(3092,'1','219','1',1,'Retail Sale Id 3164',640.00,0.00,0.00,1.00,28.00,'2022-04-14 16:49:34','',''),(3093,'1','219','1',1,'Retail Sale Id 3165',499.20,0.00,0.00,0.78,21.84,'2022-04-14 17:00:44','',''),(3094,'1','219','1',1,'Retail Sale Id 3166',1958.40,0.00,0.00,3.06,85.68,'2022-04-14 17:09:54','',''),(3095,'1','219','1',1,'Retail Sale Id 3167',499.20,0.00,0.00,0.78,21.84,'2022-04-14 17:11:01','',''),(3096,'1','219','1',1,'Retail Sale Id 3168',1203.20,0.00,0.00,1.88,52.64,'2022-04-14 17:19:37','',''),(3097,'1','219','1',1,'Retail Sale Id 3169',38.40,0.00,0.00,0.06,1.68,'2022-04-14 17:22:43','',''),(3098,'1','219','1',1,'Retail Sale Id 3170',499.20,0.00,0.00,0.78,21.84,'2022-04-14 17:31:59','',''),(3099,'1','219','1',1,'Retail Sale Id 3170',499.20,0.00,0.00,0.78,21.84,'2022-04-14 17:31:59','',''),(3100,'1','219','1',1,'Retail Sale Id 3171',3500.80,0.00,0.00,5.47,153.16,'2022-04-14 17:36:27','',''),(3101,'1','219','1',1,'Retail Sale Id 3172',1497.60,0.00,0.00,2.34,65.52,'2022-04-14 17:40:31','',''),(3102,'1','219','1',1,'Retail Sale Id 3173',2003.20,0.00,0.00,3.13,87.64,'2022-04-14 17:41:17','',''),(3103,'1','219','1',1,'Retail Sale Id 3174',697.60,0.00,0.00,1.09,30.52,'2022-04-14 17:58:58','',''),(3104,'1','219','1',1,'Retail Sale Id 3176',998.40,0.00,0.00,1.56,43.68,'2022-04-14 18:02:04','',''),(3105,'1','219','1',1,'Retail Sale Id 3177',499.20,0.00,0.00,0.78,21.84,'2022-04-14 18:04:39','',''),(3106,'1','219','1',1,'Retail Sale Id 3178',1920.00,0.00,0.00,3.00,84.00,'2022-04-14 18:10:20','',''),(3107,'1','219','1',1,'Retail Sale Id 3179',640.00,0.00,0.00,1.00,28.00,'2022-04-14 18:11:58','',''),(3108,'1','219','1',1,'Retail Sale Id 3180',300.80,0.00,0.00,0.47,13.16,'2022-04-14 18:16:07','',''),(3109,'1','219','1',1,'Retail Sale Id 3181',2003.20,0.00,0.00,3.13,87.64,'2022-04-14 19:06:11','',''),(3110,'1','219','1',1,'Retail Sale Id 3182',2003.20,0.00,0.00,3.13,87.64,'2022-04-15 10:23:47','',''),(3111,'1','219','1',1,'Retail Sale Id 3183',3001.60,0.00,0.00,4.69,131.32,'2022-04-15 10:34:42','',''),(3112,'1','219','1',1,'Retail Sale Id 3184',3840.00,0.00,0.00,6.00,168.00,'2022-04-15 10:35:57','',''),(3113,'1','219','1',1,'Retail Sale Id 3185',2048.00,0.00,0.00,3.20,89.60,'2022-04-15 10:39:39','',''),(3114,'1','219','1',1,'Retail Sale Id 3186',38440.00,0.00,0.00,62.00,496.00,'2022-04-15 10:43:05','',''),(3115,'1','219','1',1,'Retail Sale Id 3187',2003.20,0.00,0.00,3.13,87.64,'2022-04-15 10:52:01','',''),(3116,'1','219','1',1,'Retail Sale Id 3188',1920.00,0.00,0.00,3.00,84.00,'2022-04-15 10:56:09','',''),(3117,'1','219','1',1,'Retail Sale Id 3189',15500.00,0.00,0.00,25.00,200.00,'2022-04-15 11:11:59','',''),(3118,'1','219','1',1,'Retail Sale Id 3190',1920.00,0.00,0.00,3.00,84.00,'2022-04-15 11:21:00','',''),(3119,'1','219','1',1,'Retail Sale Id 3190',3200.00,0.00,0.00,5.00,140.00,'2022-04-15 11:21:00','',''),(3120,'1','219','1',1,'Retail Sale Id 3191',3840.00,0.00,0.00,6.00,168.00,'2022-04-15 11:34:24','',''),(3121,'1','219','1',1,'Retail Sale Id 3192',2003.20,0.00,0.00,3.13,87.64,'2022-04-15 11:36:24','',''),(3122,'1','219','1',1,'Retail Sale Id 3193',1497.60,0.00,0.00,2.34,65.52,'2022-04-15 11:39:28','',''),(3123,'1','219','1',1,'Retail Sale Id 3194',2003.20,0.00,0.00,3.13,87.64,'2022-04-15 11:46:03','',''),(3124,'1','219','1',1,'Retail Sale Id 3195',1920.00,0.00,0.00,3.00,84.00,'2022-04-15 12:23:15','',''),(3125,'1','219','1',1,'Retail Sale Id 3196',998.40,0.00,0.00,1.56,43.68,'2022-04-15 14:27:08','',''),(3126,'1','219','1',1,'Retail Sale Id 3198',2003.20,0.00,0.00,3.13,87.64,'2022-04-15 14:29:49','',''),(3127,'1','219','1',1,'Retail Sale Id 3199',2003.20,0.00,0.00,3.13,87.64,'2022-04-15 14:37:18','',''),(3128,'1','219','1',1,'Retail Sale Id 3200',2003.20,0.00,0.00,3.13,87.64,'2022-04-15 14:38:55','',''),(3129,'1','219','1',1,'Retail Sale Id 3201',3840.00,0.00,0.00,6.00,168.00,'2022-04-15 14:43:46','',''),(3130,'1','219','1',1,'Retail Sale Id 3202',3720.00,0.00,0.00,6.00,48.00,'2022-04-15 14:44:58','',''),(3131,'1','219','1',1,'Retail Sale Id 3203',800.00,0.00,0.00,1.25,35.00,'2022-04-15 14:46:32','',''),(3132,'1','219','1',1,'Retail Sale Id 3204',1497.60,0.00,0.00,2.34,65.52,'2022-04-15 14:48:18','',''),(3133,'1','219','1',1,'Retail Sale Id 3205',8000.00,0.00,0.00,12.50,350.00,'2022-04-15 14:52:47','',''),(3134,'1','219','1',1,'Retail Sale Id 3206',1299.20,0.00,0.00,2.03,56.84,'2022-04-15 15:08:41','',''),(3135,'1','219','1',1,'Retail Sale Id 3207',1299.20,0.00,0.00,2.03,56.84,'2022-04-15 15:23:14','',''),(3136,'1','219','1',1,'Retail Sale Id 3209',2560.00,0.00,0.00,4.00,112.00,'2022-04-15 15:24:51','',''),(3137,'1','219','1',1,'Retail Sale Id 3210',3840.00,0.00,0.00,6.00,168.00,'2022-04-15 15:39:03','',''),(3138,'1','219','1',1,'Retail Sale Id 3212',2003.20,0.00,0.00,3.13,87.64,'2022-04-15 15:42:53','',''),(3139,'1','219','1',1,'Retail Sale Id 3213',499.20,0.00,0.00,0.78,21.84,'2022-04-15 15:45:09','',''),(3140,'1','219','1',1,'Retail Sale Id 3214',3840.00,0.00,0.00,6.00,168.00,'2022-04-15 16:18:47','',''),(3141,'1','219','1',1,'Retail Sale Id 3215',2003.20,0.00,0.00,3.13,87.64,'2022-04-15 16:20:56','',''),(3142,'1','219','1',1,'Retail Sale Id 3217',3840.00,0.00,0.00,6.00,168.00,'2022-04-15 16:37:37','',''),(3143,'1','219','1',1,'Retail Sale Id 3218',697.60,0.00,0.00,1.09,30.52,'2022-04-15 16:52:48','',''),(3144,'1','219','1',1,'Retail Sale Id 3219',2003.20,0.00,0.00,3.13,87.64,'2022-04-15 16:57:02','',''),(3145,'1','219','1',1,'Retail Sale Id 3220',1632.00,0.00,0.00,2.55,71.40,'2022-04-15 17:04:36','',''),(3146,'1','219','1',1,'Retail Sale Id 3221',499.20,0.00,0.00,0.78,21.84,'2022-04-15 17:15:24','',''),(3147,'1','219','1',1,'Retail Sale Id 3222',300.80,0.00,0.00,0.47,13.16,'2022-04-15 17:19:51','',''),(3148,'1','219','1',1,'Retail Sale Id 3223',499.20,0.00,0.00,0.78,21.84,'2022-04-15 17:29:16','',''),(3149,'1','219','1',1,'Retail Sale Id 3224',1497.60,0.00,0.00,2.34,65.52,'2022-04-15 17:31:57','',''),(3150,'1','219','1',1,'Retail Sale Id 3225',1920.00,0.00,0.00,3.00,84.00,'2022-04-15 17:39:26','',''),(3151,'1','219','1',1,'Retail Sale Id 3226',3840.00,0.00,0.00,6.00,168.00,'2022-04-15 17:40:47','',''),(3152,'1','219','1',1,'Retail Sale Id 3227',8000.00,0.00,0.00,12.50,350.00,'2022-04-15 17:47:45','',''),(3153,'1','219','1',1,'Retail Sale Id 3228',3840.00,0.00,0.00,6.00,168.00,'2022-04-15 18:00:54','',''),(3154,'1','219','1',1,'Retail Sale Id 3230',1203.20,0.00,0.00,1.88,52.64,'2022-04-15 18:25:58','',''),(3155,'1','219','1',1,'Retail Sale Id 3232',998.40,0.00,0.00,1.56,43.68,'2022-04-15 18:36:41','',''),(3156,'1','219','1',1,'Retail Sale Id 3233',4800.00,0.00,0.00,7.50,210.00,'2022-04-16 07:25:53','',''),(3157,'1','219','1',1,'Retail Sale Id 3234',2003.20,0.00,0.00,3.13,87.64,'2022-04-16 08:00:55','',''),(3158,'1','219','1',1,'Retail Sale Id 3234',3001.60,0.00,0.00,4.69,131.32,'2022-04-16 08:00:55','',''),(3159,'1','219','1',1,'Retail Sale Id 3235',8000.00,0.00,0.00,12.50,350.00,'2022-04-16 09:34:17','',''),(3160,'1','219','1',1,'Retail Sale Id 3236',3200.00,0.00,0.00,5.00,140.00,'2022-04-16 09:35:13','',''),(3161,'1','219','1',1,'Retail Sale Id 3237',2003.20,0.00,0.00,3.13,87.64,'2022-04-16 09:36:15','',''),(3162,'1','219','1',1,'Retail Sale Id 3238',3852.80,0.00,0.00,6.02,168.56,'2022-04-16 09:37:29','',''),(3163,'1','219','1',1,'Retail Sale Id 3239',3852.80,0.00,0.00,6.02,168.56,'2022-04-16 09:39:22','',''),(3164,'1','219','1',1,'Retail Sale Id 3240',998.40,0.00,0.00,1.56,43.68,'2022-04-16 09:54:27','',''),(3165,'1','219','1',1,'Retail Sale Id 3242',3200.00,0.00,0.00,5.00,140.00,'2022-04-16 09:57:15','',''),(3166,'1','219','1',1,'Retail Sale Id 3243',3200.00,0.00,0.00,5.00,140.00,'2022-04-16 10:05:29','',''),(3167,'1','219','1',1,'Retail Sale Id 3244',3840.00,0.00,0.00,6.00,168.00,'2022-04-16 10:23:44','',''),(3168,'1','219','1',1,'Retail Sale Id 3245',3200.00,0.00,0.00,5.00,140.00,'2022-04-16 11:08:15','',''),(3169,'1','219','1',1,'Retail Sale Id 3246',1280.00,0.00,0.00,2.00,56.00,'2022-04-16 11:31:33','',''),(3170,'1','219','1',1,'Retail Sale Id 3247',3720.00,0.00,0.00,6.00,48.00,'2022-04-16 11:35:17','',''),(3171,'1','219','1',1,'Retail Sale Id 3248',3840.00,0.00,0.00,6.00,168.00,'2022-04-16 11:45:07','',''),(3172,'1','219','1',1,'Retail Sale Id 3249',1920.00,0.00,0.00,3.00,84.00,'2022-04-16 11:47:49','',''),(3173,'1','219','1',1,'Retail Sale Id 3250',1920.00,0.00,0.00,3.00,84.00,'2022-04-16 12:44:33','',''),(3174,'1','219','1',1,'Retail Sale Id 3250',3840.00,0.00,0.00,6.00,168.00,'2022-04-16 12:44:33','',''),(3175,'1','219','1',1,'Retail Sale Id 3251',1932.80,0.00,0.00,3.02,84.56,'2022-04-16 13:00:04','',''),(3176,'1','219','1',1,'Retail Sale Id 3252',998.40,0.00,0.00,1.56,43.68,'2022-04-16 13:09:45','',''),(3177,'1','219','1',1,'Retail Sale Id 3253',2003.20,0.00,0.00,3.13,87.64,'2022-04-16 13:11:20','',''),(3178,'1','219','1',1,'Retail Sale Id 3254',3148.80,0.00,0.00,4.92,137.76,'2022-04-16 13:20:13','',''),(3179,'1','219','1',1,'Retail Sale Id 3254',6400.00,0.00,0.00,10.00,280.00,'2022-04-16 13:20:13','',''),(3180,'1','219','1',1,'Retail Sale Id 3255',4000.00,0.00,0.00,6.25,175.00,'2022-04-16 13:46:08','',''),(3181,'1','219','1',1,'Retail Sale Id 3256',3001.60,0.00,0.00,4.69,131.32,'2022-04-16 13:47:01','',''),(3182,'1','219','1',1,'Retail Sale Id 3257',1497.60,0.00,0.00,2.34,65.52,'2022-04-16 13:51:32','',''),(3183,'1','219','1',1,'Retail Sale Id 3258',3840.00,0.00,0.00,6.00,168.00,'2022-04-16 14:02:12','',''),(3184,'1','219','1',1,'Retail Sale Id 3259',7750.00,0.00,0.00,12.50,100.00,'2022-04-16 14:20:53','',''),(3185,'1','219','1',1,'Retail Sale Id 3260',7440.00,0.00,0.00,12.00,96.00,'2022-04-16 14:22:09','',''),(3186,'1','219','1',1,'Retail Sale Id 3261',1600.00,0.00,0.00,2.50,70.00,'2022-04-16 14:27:02','',''),(3187,'1','219','1',1,'Return of Retail Sale Id 3259',0.00,7750.00,12.50,0.00,-100.00,'2022-04-16 14:27:42','',''),(3188,'1','219','1',1,'Retail Sale Id 3262',3852.80,0.00,0.00,6.02,168.56,'2022-04-16 14:32:14','',''),(3189,'1','219','1',1,'Retail Sale Id 3264',3840.00,0.00,0.00,6.00,168.00,'2022-04-16 14:55:45','',''),(3190,'1','219','1',1,'Retail Sale Id 3265',1860.00,0.00,0.00,3.00,24.00,'2022-04-16 15:03:16','',''),(3191,'1','219','1',1,'Retail Sale Id 3266',3410.00,0.00,0.00,5.50,44.00,'2022-04-16 15:18:38','',''),(3192,'1','219','1',1,'Retail Sale Id 3267',3840.00,0.00,0.00,6.00,168.00,'2022-04-16 15:45:36','',''),(3193,'1','219','1',1,'Retail Sale Id 3268',3500.80,0.00,0.00,5.47,153.16,'2022-04-16 15:46:48','',''),(3194,'1','219','1',1,'Retail Sale Id 3269',2003.20,0.00,0.00,3.13,87.64,'2022-04-16 15:48:12','',''),(3195,'1','219','1',1,'Retail Sale Id 3269',2003.20,0.00,0.00,3.13,87.64,'2022-04-16 15:48:12','',''),(3196,'1','219','1',1,'Retail Sale Id 3270',3200.00,0.00,0.00,5.00,140.00,'2022-04-16 15:58:13','',''),(3197,'1','219','1',1,'Retail Sale Id 3271',3840.00,0.00,0.00,6.00,168.00,'2022-04-16 16:03:11','',''),(3198,'1','219','1',1,'Retail Sale Id 3272',3200.00,0.00,0.00,5.00,140.00,'2022-04-16 16:20:31','',''),(3199,'1','219','1',1,'Retail Sale Id 3273',499.20,0.00,0.00,0.78,21.84,'2022-04-16 16:30:34','',''),(3200,'1','219','1',1,'Retail Sale Id 3274',998.40,0.00,0.00,1.56,43.68,'2022-04-16 16:43:05','',''),(3201,'1','219','1',1,'Retail Sale Id 3275',499.20,0.00,0.00,0.78,21.84,'2022-04-16 16:50:45','',''),(3202,'1','219','1',1,'Retail Sale Id 3276',800.00,0.00,0.00,1.25,35.00,'2022-04-16 16:56:45','',''),(3203,'1','219','1',1,'Retail Sale Id 3277',3852.80,0.00,0.00,6.02,168.56,'2022-04-16 17:00:46','',''),(3204,'1','219','1',1,'Retail Sale Id 3278',1497.60,0.00,0.00,2.34,65.52,'2022-04-16 17:05:16','',''),(3205,'1','219','1',1,'Retail Sale Id 3279',998.40,0.00,0.00,1.56,43.68,'2022-04-16 17:11:30','',''),(3206,'1','219','1',1,'Retail Sale Id 3280',697.60,0.00,0.00,1.09,30.52,'2022-04-16 17:23:44','',''),(3207,'1','219','1',1,'Retail Sale Id 3281',1497.60,0.00,0.00,2.34,65.52,'2022-04-16 17:32:27','',''),(3208,'1','219','1',1,'Retail Sale Id 3282',1920.00,0.00,0.00,3.00,84.00,'2022-04-16 17:36:15','',''),(3209,'1','219','1',1,'Retail Sale Id 3283',998.40,0.00,0.00,1.56,43.68,'2022-04-16 18:04:27','',''),(3210,'1','219','1',1,'Retail Sale Id 3284',3200.00,0.00,0.00,5.00,140.00,'2022-04-16 18:26:11','',''),(3211,'1','219','1',1,'Retail Sale Id 3286',7006.00,0.00,0.00,11.30,90.40,'2022-04-16 18:31:12','',''),(3212,'1','219','1',1,'Return of Retail Sale Id 3284',0.00,3200.00,5.00,0.00,-140.00,'2022-04-16 22:53:13','',''),(3213,'1','219','1',1,'Retail Sale Id 3287',569.60,0.00,0.00,0.89,24.92,'2022-04-16 22:54:43','',''),(3214,'1','219','1',1,'Retail Sale Id 3288',2585.60,0.00,0.00,4.04,113.12,'2022-04-16 22:56:22','',''),(3215,'1','219','1',1,'Return of Retail Sale Id 3286',0.00,7006.00,11.30,0.00,-90.40,'2022-04-16 22:57:27','',''),(3216,'1','219','1',1,'Retail Sale Id 3289',6634.00,0.00,0.00,10.70,85.60,'2022-04-16 22:58:44','',''),(3217,'1','219','1',1,'Retail Sale Id 3291',8000.00,0.00,0.00,12.50,350.00,'2022-04-17 08:23:18','',''),(3218,'1','219','1',1,'Retail Sale Id 3292',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 08:31:14','',''),(3219,'1','219','1',1,'Retail Sale Id 3293',2003.20,0.00,0.00,3.13,87.64,'2022-04-17 08:34:48','',''),(3220,'1','219','1',1,'Retail Sale Id 3294',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 08:44:20','',''),(3221,'1','219','1',1,'Retail Sale Id 3295',2003.20,0.00,0.00,3.13,87.64,'2022-04-17 09:22:32','',''),(3222,'1','219','1',1,'Retail Sale Id 3296',3897.60,0.00,0.00,6.09,170.52,'2022-04-17 09:46:23','',''),(3223,'1','219','1',1,'Retail Sale Id 3297',2003.20,0.00,0.00,3.13,87.64,'2022-04-17 09:47:20','',''),(3224,'1','219','1',1,'Retail Sale Id 3298',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 10:17:02','',''),(3225,'1','219','1',1,'Retail Sale Id 3301',3720.00,0.00,0.00,6.00,48.00,'2022-04-17 10:23:46','',''),(3226,'1','219','1',1,'Retail Sale Id 3303',31000.00,0.00,0.00,50.00,400.00,'2022-04-17 11:05:36','',''),(3227,'1','219','1',1,'Retail Sale Id 3304',2003.20,0.00,0.00,3.13,87.64,'2022-04-17 11:40:11','',''),(3228,'1','219','1',1,'Retail Sale Id 3305',1747.20,0.00,0.00,2.73,76.44,'2022-04-17 11:47:53','',''),(3229,'1','219','1',1,'Retail Sale Id 3306',4000.00,0.00,0.00,6.25,175.00,'2022-04-17 11:58:09','',''),(3230,'1','219','1',1,'Retail Sale Id 3307',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 12:05:56','',''),(3231,'1','219','1',1,'Retail Sale Id 3308',3720.00,0.00,0.00,6.00,48.00,'2022-04-17 13:00:09','',''),(3232,'1','219','1',1,'Retail Sale Id 3309',998.40,0.00,0.00,1.56,43.68,'2022-04-17 13:29:57','',''),(3233,'1','219','1',1,'Retail Sale Id 3310',3001.60,0.00,0.00,4.69,131.32,'2022-04-17 13:42:21','',''),(3234,'1','219','1',1,'Retail Sale Id 3311',6246.40,0.00,0.00,9.76,273.28,'2022-04-17 13:50:42','',''),(3235,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,2758541.04,4507.42,0.00,0.00,'2022-04-17 13:55:56','',''),(3236,'1','219',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,4507.42,0.00,'2022-04-17 13:57:45','',''),(3237,'1','219','1',1,'Received from bridging 9',0.00,0.00,4507.42,0.00,0.00,'2022-04-17 13:57:45','',''),(3238,'1','219','1',1,'Retail Sale Id 3312',1753.60,0.00,0.00,2.74,76.72,'2022-04-17 14:03:37','',''),(3239,'1','219','1',1,'Retail Sale Id 3313',1920.00,0.00,0.00,3.00,84.00,'2022-04-17 14:05:36','',''),(3240,'1','219','1',1,'Retail Sale Id 3314',1497.60,0.00,0.00,2.34,65.52,'2022-04-17 14:17:33','',''),(3241,'1','219','1',1,'Retail Sale Id 3315',1920.00,0.00,0.00,3.00,84.00,'2022-04-17 14:18:56','',''),(3242,'1','219','1',1,'Retail Sale Id 3316',697.60,0.00,0.00,1.09,30.52,'2022-04-17 14:23:19','',''),(3243,'1','219','1',1,'Retail Sale Id 3317',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 14:46:25','',''),(3244,'1','219','1',1,'Retail Sale Id 3321',3200.00,0.00,0.00,5.00,140.00,'2022-04-17 15:13:53','',''),(3245,'1','219','1',1,'Retail Sale Id 3322',1497.60,0.00,0.00,2.34,65.52,'2022-04-17 15:22:14','',''),(3246,'1','219','1',1,'Retail Sale Id 3323',8000.00,0.00,0.00,12.50,350.00,'2022-04-17 15:27:04','',''),(3247,'1','219','1',1,'Retail Sale Id 3324',2003.20,0.00,0.00,3.13,87.64,'2022-04-17 15:36:33','',''),(3248,'1','219','1',1,'Retail Sale Id 3325',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 15:39:10','',''),(3249,'1','219','1',1,'Retail Sale Id 3326',3500.80,0.00,0.00,5.47,153.16,'2022-04-17 15:46:16','',''),(3250,'1','219','1',1,'Retail Sale Id 3327',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 15:49:03','',''),(3251,'1','219','1',1,'Retail Sale Id 3329',2003.20,0.00,0.00,3.13,87.64,'2022-04-17 15:58:55','',''),(3252,'1','219','1',1,'Retail Sale Id 3330',300.80,0.00,0.00,0.47,13.16,'2022-04-17 16:12:25','',''),(3253,'1','219','1',1,'Retail Sale Id 3331',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 16:24:02','',''),(3254,'1','219','1',1,'Retail Sale Id 3332',2003.20,0.00,0.00,3.13,87.64,'2022-04-17 16:25:51','',''),(3255,'1','219','1',1,'Retail Sale Id 3333',640.00,0.00,0.00,1.00,28.00,'2022-04-17 16:27:42','',''),(3256,'1','219','1',1,'Retail Sale Id 3334',1280.00,0.00,0.00,2.00,56.00,'2022-04-17 16:29:27','',''),(3257,'1','219','1',1,'Retail Sale Id 3335',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 16:33:01','',''),(3258,'1','219','1',1,'Retail Sale Id 3336',1952.00,0.00,0.00,3.05,85.40,'2022-04-17 16:35:13','',''),(3259,'1','219','1',1,'Retail Sale Id 3337',3001.60,0.00,0.00,4.69,131.32,'2022-04-17 16:40:13','',''),(3260,'1','219','1',1,'Retail Sale Id 3338',3001.60,0.00,0.00,4.69,131.32,'2022-04-17 16:40:58','',''),(3261,'1','219','1',1,'Retail Sale Id 3339',300.80,0.00,0.00,0.47,13.16,'2022-04-17 16:57:40','',''),(3262,'1','219','1',1,'Retail Sale Id 3340',2003.20,0.00,0.00,3.13,87.64,'2022-04-17 17:00:23','',''),(3263,'1','219','1',1,'Retail Sale Id 3341',1798.40,0.00,0.00,2.81,78.68,'2022-04-17 17:07:33','',''),(3264,'1','219','1',1,'Retail Sale Id 3342',1952.00,0.00,0.00,3.05,85.40,'2022-04-17 17:10:51','',''),(3265,'1','219','1',1,'Retail Sale Id 3343',1299.20,0.00,0.00,2.03,56.84,'2022-04-17 17:11:57','',''),(3266,'1','219','1',1,'Retail Sale Id 3344',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 17:12:58','',''),(3267,'1','219','1',1,'Retail Sale Id 3345',3200.00,0.00,0.00,5.00,140.00,'2022-04-17 17:18:22','',''),(3268,'1','219','1',1,'Retail Sale Id 3346',499.20,0.00,0.00,0.78,21.84,'2022-04-17 17:22:23','',''),(3269,'1','219','1',1,'Retail Sale Id 3347',2003.20,0.00,0.00,3.13,87.64,'2022-04-17 17:24:57','',''),(3270,'1','219','1',1,'Retail Sale Id 3347',3840.00,0.00,0.00,6.00,168.00,'2022-04-17 17:24:57','',''),(3271,'1','219','1',1,'Retail Sale Id 3348',499.20,0.00,0.00,0.78,21.84,'2022-04-17 17:38:49','',''),(3272,'1','219','1',1,'Retail Sale Id 3349',499.20,0.00,0.00,0.78,21.84,'2022-04-17 17:45:19','',''),(3273,'1','219','1',1,'Retail Sale Id 3350',3001.60,0.00,0.00,4.69,131.32,'2022-04-17 17:48:05','',''),(3274,'1','219','1',1,'Retail Sale Id 3351',2003.20,0.00,0.00,3.13,87.64,'2022-04-17 17:55:45','',''),(3275,'1','219','1',1,'Retail Sale Id 3352',1280.00,0.00,0.00,2.00,56.00,'2022-04-17 18:16:44','',''),(3276,'1','219','1',1,'Retail Sale Id 3353',960.00,0.00,0.00,1.50,42.00,'2022-04-17 18:30:44','',''),(3277,'1','219','1',1,'Retail Sale Id 3354',499.20,0.00,0.00,0.78,21.84,'2022-04-17 18:33:52','',''),(3278,'1','219','1',1,'Retail Sale Id 3355',6400.00,0.00,0.00,10.00,280.00,'2022-04-18 07:42:15','',''),(3279,'1','219','1',1,'Retail Sale Id 3356',4998.40,0.00,0.00,7.81,218.68,'2022-04-18 07:55:12','',''),(3280,'1','219','1',1,'Retail Sale Id 3358',3796.92,0.00,0.00,5.97,143.28,'2022-04-18 08:51:27','',''),(3281,'1','219','1',1,'Retail Sale Id 3359',61400.00,0.00,0.00,100.00,200.00,'2022-04-18 08:58:06','',''),(3282,'1','219','1',1,'Retail Sale Id 3360',2550.36,0.00,0.00,4.01,96.24,'2022-04-18 09:06:18','',''),(3283,'1','219','1',1,'Retail Sale Id 3362',3822.36,0.00,0.00,6.01,144.24,'2022-04-18 09:13:35','',''),(3284,'1','219','1',1,'Retail Sale Id 3363',3180.00,0.00,0.00,5.00,120.00,'2022-04-18 09:23:38','',''),(3285,'1','219','1',1,'Retail Sale Id 3364',2499.48,0.00,0.00,3.93,94.32,'2022-04-18 09:54:31','',''),(3286,'1','219','1',1,'Retail Sale Id 3366',1908.00,0.00,0.00,3.00,72.00,'2022-04-18 09:56:39','',''),(3287,'1','219','1',1,'Retail Sale Id 3368',6360.00,0.00,0.00,10.00,240.00,'2022-04-18 10:01:49','',''),(3288,'1','219','1',1,'Retail Sale Id 3369',7950.00,0.00,0.00,12.50,300.00,'2022-04-18 10:14:05','',''),(3289,'1','219','1',1,'Retail Sale Id 3370',3001.92,0.00,0.00,4.72,113.28,'2022-04-18 10:20:33','',''),(3290,'1','219','1',1,'Retail Sale Id 3371',1272.00,0.00,0.00,2.00,48.00,'2022-04-18 10:48:15','',''),(3291,'1','219','1',1,'Retail Sale Id 3372',1272.00,0.00,0.00,2.00,48.00,'2022-04-18 10:49:04','',''),(3292,'1','219','1',1,'Retail Sale Id 3373',3822.36,0.00,0.00,6.01,144.24,'2022-04-18 10:54:08','',''),(3293,'1','219','1',1,'Retail Sale Id 3374',998.52,0.00,0.00,1.57,37.68,'2022-04-18 11:07:53','',''),(3294,'1','219','1',1,'Retail Sale Id 3375',998.52,0.00,0.00,1.57,37.68,'2022-04-18 11:20:33','',''),(3295,'1','219','1',1,'Retail Sale Id 3376',3847.80,0.00,0.00,6.05,145.20,'2022-04-18 11:35:03','',''),(3296,'1','219','1',1,'Retail Sale Id 3377',1908.00,0.00,0.00,3.00,72.00,'2022-04-18 11:36:50','',''),(3297,'1','219','1',1,'Retail Sale Id 3378',3180.00,0.00,0.00,5.00,120.00,'2022-04-18 11:38:20','',''),(3298,'1','219','1',1,'Retail Sale Id 3379',2499.48,0.00,0.00,3.93,94.32,'2022-04-18 11:49:31','',''),(3299,'1','219','1',1,'Retail Sale Id 3380',3001.92,0.00,0.00,4.72,113.28,'2022-04-18 11:50:24','',''),(3300,'1','219','1',1,'Retail Sale Id 3381',3822.36,0.00,0.00,6.01,144.24,'2022-04-18 11:57:32','',''),(3301,'1','219','1',1,'Retail Sale Id 3382',3001.92,0.00,0.00,4.72,113.28,'2022-04-18 12:16:56','',''),(3302,'1','219','1',1,'Retail Sale Id 3383',1927.08,0.00,0.00,3.03,72.72,'2022-04-18 12:24:39','',''),(3303,'1','219','1',1,'Retail Sale Id 3384',7950.00,0.00,0.00,12.50,300.00,'2022-04-18 12:32:20','',''),(3304,'1','219','1',1,'Retail Sale Id 3385',1908.00,0.00,0.00,3.00,72.00,'2022-04-18 12:37:07','',''),(3305,'1','219','1',1,'Retail Sale Id 3385',3809.64,0.00,0.00,5.99,143.76,'2022-04-18 12:37:07','',''),(3306,'1','219','1',1,'Retail Sale Id 3386',7950.00,0.00,0.00,12.50,300.00,'2022-04-18 12:59:48','',''),(3307,'1','219','1',1,'Retail Sale Id 3387',3822.36,0.00,0.00,6.01,144.24,'2022-04-18 13:20:07','',''),(3308,'1','219','1',1,'Retail Sale Id 3388',7950.00,0.00,0.00,12.50,300.00,'2022-04-18 13:36:08','',''),(3309,'1','219','1',1,'Retail Sale Id 3389',3001.92,0.00,0.00,4.72,113.28,'2022-04-18 13:37:17','',''),(3310,'1','219','1',1,'Retail Sale Id 3390',1901.64,0.00,0.00,2.99,71.76,'2022-04-18 13:56:06','',''),(3311,'1','219','1',1,'Retail Sale Id 3391',3822.36,0.00,0.00,6.01,144.24,'2022-04-18 14:04:32','',''),(3312,'1','219','1',1,'Retail Sale Id 3394',7950.00,0.00,0.00,12.50,300.00,'2022-04-18 14:09:42','',''),(3313,'1','219','1',1,'Retail Sale Id 3395',1908.00,0.00,0.00,3.00,72.00,'2022-04-18 14:14:09','',''),(3314,'1','219','1',1,'Retail Sale Id 3396',3498.00,0.00,0.00,5.50,132.00,'2022-04-18 14:15:02','',''),(3315,'1','219','1',1,'Retail Sale Id 3397',4000.44,0.00,0.00,6.29,150.96,'2022-04-18 14:22:17','',''),(3316,'1','219','1',1,'Retail Sale Id 3398',1997.04,0.00,0.00,3.14,75.36,'2022-04-18 14:23:48','',''),(3317,'1','219','1',1,'Retail Sale Id 3399',1500.96,0.00,0.00,2.36,56.64,'2022-04-18 14:30:50','',''),(3318,'1','219','1',1,'Retail Sale Id 3400',4000.44,0.00,0.00,6.29,150.96,'2022-04-18 14:54:49','',''),(3319,'1','219','1',1,'Retail Sale Id 3401',1908.00,0.00,0.00,3.00,72.00,'2022-04-18 15:02:39','',''),(3320,'1','219','1',1,'Retail Sale Id 3402',1997.04,0.00,0.00,3.14,75.36,'2022-04-18 15:05:38','',''),(3321,'1','219','1',1,'Retail Sale Id 3403',4998.96,0.00,0.00,7.86,188.64,'2022-04-18 15:21:23','',''),(3322,'1','219','1',1,'Retail Sale Id 3404',3777.84,0.00,0.00,5.94,142.56,'2022-04-18 15:30:42','',''),(3323,'1','219','1',1,'Retail Sale Id 3405',3180.00,0.00,0.00,5.00,120.00,'2022-04-18 15:37:53','',''),(3324,'1','219','1',1,'Retail Sale Id 3406',3822.36,0.00,0.00,6.01,144.24,'2022-04-18 15:39:09','',''),(3325,'1','219','1',1,'Retail Sale Id 3408',3684.00,0.00,0.00,6.00,12.00,'2022-04-18 16:10:29','',''),(3326,'1','219','1',1,'Retail Sale Id 3409',3684.00,0.00,0.00,6.00,12.00,'2022-04-18 16:11:14','',''),(3327,'1','219','1',1,'Retail Sale Id 3410',998.52,0.00,0.00,1.57,37.68,'2022-04-18 16:26:01','',''),(3328,'1','219','1',1,'Retail Sale Id 3411',1997.04,0.00,0.00,3.14,75.36,'2022-04-18 16:27:05','',''),(3329,'1','219','1',1,'Retail Sale Id 3412',648.72,0.00,0.00,1.02,24.48,'2022-04-18 16:28:16','',''),(3330,'1','219','1',1,'Retail Sale Id 3413',3180.00,0.00,0.00,5.00,120.00,'2022-04-18 16:41:27','',''),(3331,'1','219','1',1,'Retail Sale Id 3414',7950.00,0.00,0.00,12.50,300.00,'2022-04-18 16:42:30','',''),(3332,'1','219','1',1,'Retail Sale Id 3415',298.92,0.00,0.00,0.47,11.28,'2022-04-18 16:51:07','',''),(3333,'1','219','1',1,'Retail Sale Id 3416',3001.92,0.00,0.00,4.72,113.28,'2022-04-18 16:56:36','',''),(3334,'1','219','1',1,'Retail Sale Id 3417',3180.00,0.00,0.00,5.00,120.00,'2022-04-18 17:31:23','',''),(3335,'1','219','1',1,'Retail Sale Id 3418',3822.36,0.00,0.00,6.01,144.24,'2022-04-18 17:33:42','',''),(3336,'1','219','1',1,'Retail Sale Id 3419',1500.96,0.00,0.00,2.36,56.64,'2022-04-18 17:40:21','',''),(3337,'1','219','1',1,'Retail Sale Id 3421',1997.04,0.00,0.00,3.14,75.36,'2022-04-18 17:54:43','',''),(3338,'1','219','1',1,'Retail Sale Id 3422',3822.36,0.00,0.00,6.01,144.24,'2022-04-18 18:06:40','',''),(3339,'1','219','1',1,'Retail Sale Id 3424',400.68,0.00,0.00,0.63,15.12,'2022-04-18 18:11:22','',''),(3340,'1','219','1',1,'Retail Sale Id 3425',1500.96,0.00,0.00,2.36,56.64,'2022-04-18 18:13:08','',''),(3341,'1','219','1',1,'Retail Sale Id 3426',1297.44,0.00,0.00,2.04,48.96,'2022-04-18 18:14:50','',''),(3342,'1','219','1',1,'Retail Sale Id 3427',1500.96,0.00,0.00,2.36,56.64,'2022-04-18 18:17:08','',''),(3343,'1','219','1',1,'Retail Sale Id 3428',7950.00,0.00,0.00,12.50,300.00,'2022-04-18 18:41:04','',''),(3344,'1','219','1',1,'Return of Retail Sale Id 3422',0.00,3822.36,6.01,0.00,-144.24,'2022-04-18 19:18:31','',''),(3345,'1','219','1',1,'Return of Retail Sale Id 3418',0.00,3822.36,6.01,0.00,-144.24,'2022-04-18 23:36:18','',''),(3346,'1','219','1',1,'Retail Sale Id 3429',3822.36,0.00,0.00,6.01,144.24,'2022-04-18 23:39:08','',''),(3347,'1','219','1',1,'Retail Sale Id 3430',1908.00,0.00,0.00,3.00,72.00,'2022-04-19 07:22:36','',''),(3348,'1','219','1',1,'Retail Sale Id 3430',1908.00,0.00,0.00,3.00,72.00,'2022-04-19 07:22:36','',''),(3349,'1','219','1',1,'Retail Sale Id 3431',184200.00,0.00,0.00,300.00,600.00,'2022-04-19 07:36:44','',''),(3350,'1','219','1',1,'Retail Sale Id 3432',8903.00,0.00,0.00,14.50,29.00,'2022-04-19 07:43:09','',''),(3351,'1','219','1',1,'Retail Sale Id 3433',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 08:14:14','',''),(3352,'1','219','1',1,'Retail Sale Id 3434',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 08:17:17','',''),(3353,'1','219','1',1,'Retail Sale Id 3435',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 08:26:58','',''),(3354,'1','219','1',1,'Retail Sale Id 3436',801.36,0.00,0.00,1.26,30.24,'2022-04-19 08:28:50','',''),(3355,'1','219','1',1,'Retail Sale Id 3437',998.52,0.00,0.00,1.57,37.68,'2022-04-19 08:29:47','',''),(3356,'1','219','1',1,'Retail Sale Id 3438',197.16,0.00,0.00,0.31,7.44,'2022-04-19 08:32:59','',''),(3357,'1','219','1',1,'Retail Sale Id 3439',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 08:43:17','',''),(3358,'1','219','1',1,'Retail Sale Id 3440',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 08:52:50','',''),(3359,'1','219','1',1,'Retail Sale Id 3441',998.52,0.00,0.00,1.57,37.68,'2022-04-19 08:55:27','',''),(3360,'1','219','1',1,'Retail Sale Id 3442',1997.04,0.00,0.00,3.14,75.36,'2022-04-19 09:48:42','',''),(3361,'1','219','1',1,'Retail Sale Id 3443',1997.04,0.00,0.00,3.14,75.36,'2022-04-19 09:54:34','',''),(3362,'1','219','1',1,'Retail Sale Id 3444',998.52,0.00,0.00,1.57,37.68,'2022-04-19 09:56:05','',''),(3363,'1','219','1',1,'Retail Sale Id 3445',1997.04,0.00,0.00,3.14,75.36,'2022-04-19 10:17:43','',''),(3364,'1','219','1',1,'Retail Sale Id 3446',1908.00,0.00,0.00,3.00,72.00,'2022-04-19 10:39:16','',''),(3365,'1','219','1',1,'Retail Sale Id 3447',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 10:47:21','',''),(3366,'1','219','1',1,'Retail Sale Id 3448',7638.36,0.00,0.00,12.01,288.24,'2022-04-19 10:54:23','',''),(3367,'1','219','1',1,'Retail Sale Id 3449',4000.44,0.00,0.00,6.29,150.96,'2022-04-19 11:00:27','',''),(3368,'1','219','1',1,'Retail Sale Id 3450',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 11:41:05','',''),(3369,'1','219','1',1,'Retail Sale Id 3451',7950.00,0.00,0.00,12.50,300.00,'2022-04-19 11:52:25','',''),(3370,'1','219','1',1,'Retail Sale Id 3452',1997.04,0.00,0.00,3.14,75.36,'2022-04-19 11:54:08','',''),(3371,'1','219','1',1,'Retail Sale Id 3453',7950.00,0.00,0.00,12.50,300.00,'2022-04-19 12:03:31','',''),(3372,'1','219','1',1,'Retail Sale Id 3454',1997.04,0.00,0.00,3.14,75.36,'2022-04-19 12:05:54','',''),(3373,'1','219','1',1,'Retail Sale Id 3455',7950.00,0.00,0.00,12.50,300.00,'2022-04-19 12:11:04','',''),(3374,'1','219','1',1,'Retail Sale Id 3456',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 12:15:05','',''),(3375,'1','219','1',1,'Retail Sale Id 3457',7950.00,0.00,0.00,12.50,300.00,'2022-04-19 12:16:41','',''),(3376,'1','219','1',1,'Retail Sale Id 3458',1297.44,0.00,0.00,2.04,48.96,'2022-04-19 12:18:03','',''),(3377,'1','219','1',1,'Retail Sale Id 3459',502.44,0.00,0.00,0.79,18.96,'2022-04-19 12:25:50','',''),(3378,'1','219','1',1,'Retail Sale Id 3460',7950.00,0.00,0.00,12.50,300.00,'2022-04-19 12:29:21','',''),(3379,'1','219','1',1,'Retail Sale Id 3461',3180.00,0.00,0.00,5.00,120.00,'2022-04-19 12:53:38','',''),(3380,'1','219','1',1,'Retail Sale Id 3462',998.52,0.00,0.00,1.57,37.68,'2022-04-19 13:53:02','',''),(3381,'1','219','1',1,'Retail Sale Id 3463',3180.00,0.00,0.00,5.00,120.00,'2022-04-19 14:00:13','',''),(3382,'1','219','1',1,'Retail Sale Id 3464',1278.36,0.00,0.00,2.01,48.24,'2022-04-19 14:20:55','',''),(3383,'1','219','1',1,'Retail Sale Id 3465',298.92,0.00,0.00,0.47,11.28,'2022-04-19 14:27:00','',''),(3384,'1','219','1',1,'Retail Sale Id 3467',1908.00,0.00,0.00,3.00,72.00,'2022-04-19 15:08:52','',''),(3385,'1','219','1',1,'Retail Sale Id 3468',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 15:34:06','',''),(3386,'1','219','1',1,'Retail Sale Id 3469',3822.36,0.00,0.00,6.01,144.24,'2022-04-19 16:14:16','',''),(3387,'1','219','1',1,'Retail Sale Id 3470',998.52,0.00,0.00,1.57,37.68,'2022-04-19 16:18:45','',''),(3388,'1','219','1',1,'Retail Sale Id 3471',801.36,0.00,0.00,1.26,30.24,'2022-04-19 16:54:17','',''),(3389,'1','219','1',1,'Retail Sale Id 3472',3001.92,0.00,0.00,4.72,113.28,'2022-04-19 16:58:21','',''),(3390,'1','219','1',1,'Retail Sale Id 3473',1908.00,0.00,0.00,3.00,72.00,'2022-04-19 17:09:38','',''),(3391,'1','219','1',1,'Retail Sale Id 3474',5749.44,0.00,0.00,9.04,216.96,'2022-04-19 17:12:18','',''),(3392,'1','219','1',1,'Retail Sale Id 3475',7950.00,0.00,0.00,12.50,300.00,'2022-04-19 17:13:45','',''),(3393,'1','219','1',1,'Retail Sale Id 3476',1698.12,0.00,0.00,2.67,64.08,'2022-04-19 17:15:23','',''),(3394,'1','219','1',1,'Retail Sale Id 3478',998.52,0.00,0.00,1.57,37.68,'2022-04-19 17:25:56','',''),(3395,'1','219','1',1,'Retail Sale Id 3479',597.84,0.00,0.00,0.94,22.56,'2022-04-19 17:28:27','',''),(3396,'1','219','1',1,'Retail Sale Id 3480',502.44,0.00,0.00,0.79,18.96,'2022-04-19 17:38:06','',''),(3397,'1','219','1',1,'Retail Sale Id 3481',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 17:44:27','',''),(3398,'1','219','1',1,'Retail Sale Id 3482',1500.96,0.00,0.00,2.36,56.64,'2022-04-19 17:47:01','',''),(3399,'1','219','1',1,'Retail Sale Id 3483',699.60,0.00,0.00,1.10,26.40,'2022-04-19 17:49:14','',''),(3400,'1','219','1',1,'Retail Sale Id 3484',1908.00,0.00,0.00,3.00,72.00,'2022-04-19 18:01:55','',''),(3401,'1','219','1',1,'Retail Sale Id 3485',1500.96,0.00,0.00,2.36,56.64,'2022-04-19 18:05:23','',''),(3402,'1','219','1',1,'Retail Sale Id 3486',502.44,0.00,0.00,0.79,18.96,'2022-04-19 18:08:57','',''),(3403,'1','219','1',1,'Retail Sale Id 3487',3816.00,0.00,0.00,6.00,144.00,'2022-04-19 18:10:34','',''),(3404,'1','219','1',1,'Retail Sale Id 3488',7632.00,0.00,0.00,12.00,288.00,'2022-04-19 18:12:56','',''),(3405,'1','219','1',1,'Retail Sale Id 3489',7950.00,0.00,0.00,12.50,300.00,'2022-04-19 18:14:01','',''),(3406,'1','219','1',1,'Retail Sale Id 3490',7950.00,0.00,0.00,12.50,300.00,'2022-04-19 18:22:06','',''),(3407,'1','219','1',1,'Retail Sale Id 3491',298.92,0.00,0.00,0.47,11.28,'2022-04-19 18:22:54','',''),(3408,'1','219','1',1,'Retail Sale Id 3492',2302.32,0.00,0.00,3.62,86.88,'2022-04-19 18:32:22','',''),(3409,'1','219','1',1,'Retail Sale Id 3493',502.44,0.00,0.00,0.79,18.96,'2022-04-20 08:49:31','',''),(3410,'1','219','1',1,'Retail Sale Id 3494',2001.64,0.00,0.00,3.26,6.52,'2022-04-20 08:56:28','',''),(3411,'1','219','1',1,'Retail Sale Id 3495',3001.92,0.00,0.00,4.72,113.28,'2022-04-20 09:11:55','',''),(3412,'1','219','1',1,'Retail Sale Id 3496',4000.44,0.00,0.00,6.29,150.96,'2022-04-20 09:15:20','',''),(3413,'1','219','1',1,'Retail Sale Id 3497',2544.00,0.00,0.00,4.00,96.00,'2022-04-20 09:54:42','',''),(3414,'1','219','1',1,'Retail Sale Id 3498',7950.00,0.00,0.00,12.50,300.00,'2022-04-20 09:56:32','',''),(3415,'1','219','1',1,'Retail Sale Id 3499',1997.04,0.00,0.00,3.14,75.36,'2022-04-20 10:24:41','',''),(3416,'1','219','1',1,'Retail Sale Id 3500',2970.12,0.00,0.00,4.67,112.08,'2022-04-20 11:14:17','',''),(3417,'1','219','1',1,'Retail Sale Id 3501',1908.00,0.00,0.00,3.00,72.00,'2022-04-20 11:16:37','',''),(3418,'1','219','1',1,'Retail Sale Id 3501',1908.00,0.00,0.00,3.00,72.00,'2022-04-20 11:16:37','',''),(3419,'1','219','1',1,'Retail Sale Id 3502',34500.66,0.00,0.00,56.19,112.38,'2022-04-20 11:30:34','',''),(3420,'1','219','1',1,'Retail Sale Id 3503',3498.00,0.00,0.00,5.50,132.00,'2022-04-20 11:31:58','',''),(3421,'1','219','1',1,'Retail Sale Id 3504',3822.36,0.00,0.00,6.01,144.24,'2022-04-20 11:33:18','',''),(3422,'1','219','1',1,'Retail Sale Id 3505',7950.00,0.00,0.00,12.50,300.00,'2022-04-20 11:55:55','',''),(3423,'1','219','1',1,'Retail Sale Id 3506',2703.00,0.00,0.00,4.25,102.00,'2022-04-20 12:52:09','',''),(3424,'1','219','1',1,'Retail Sale Id 3507',3180.00,0.00,0.00,5.00,120.00,'2022-04-20 13:13:06','',''),(3425,'1','219','1',1,'Retail Sale Id 3509',1997.04,0.00,0.00,3.14,75.36,'2022-04-20 13:24:11','',''),(3426,'1','219','1',1,'Retail Sale Id 3509',1997.04,0.00,0.00,3.14,75.36,'2022-04-20 13:24:11','',''),(3427,'1','219','1',1,'Retail Sale Id 3510',3796.92,0.00,0.00,5.97,143.28,'2022-04-20 13:26:29','',''),(3428,'1','219','1',1,'Retail Sale Id 3511',1908.00,0.00,0.00,3.00,72.00,'2022-04-20 14:20:20','',''),(3429,'1','219','1',1,'Retail Sale Id 3512',7950.00,0.00,0.00,12.50,300.00,'2022-04-20 16:19:16','',''),(3430,'1','219','1',1,'Retail Sale Id 3513',298.92,0.00,0.00,0.47,11.28,'2022-04-20 16:20:25','',''),(3431,'1','219','1',1,'Retail Sale Id 3514',998.52,0.00,0.00,1.57,37.68,'2022-04-20 16:21:21','',''),(3432,'1','219','1',1,'Retail Sale Id 3515',7950.00,0.00,0.00,12.50,300.00,'2022-04-20 16:22:35','',''),(3433,'1','219','1',1,'Retail Sale Id 3516',1500.96,0.00,0.00,2.36,56.64,'2022-04-20 16:27:49','',''),(3434,'1','219','1',1,'Retail Sale Id 3516',1500.96,0.00,0.00,2.36,56.64,'2022-04-20 16:27:49','',''),(3435,'1','219','1',1,'Retail Sale Id 3517',7950.00,0.00,0.00,12.50,300.00,'2022-04-20 16:29:04','',''),(3436,'1','219','1',1,'Retail Sale Id 3518',1908.00,0.00,0.00,3.00,72.00,'2022-04-20 16:39:16','',''),(3437,'1','219','1',1,'Retail Sale Id 3518',7950.00,0.00,0.00,12.50,300.00,'2022-04-20 16:39:16','',''),(3438,'1','219','1',1,'Retail Sale Id 3519',3498.00,0.00,0.00,5.50,132.00,'2022-04-20 16:45:22','',''),(3439,'1','219','1',1,'Retail Sale Id 3520',3822.36,0.00,0.00,6.01,144.24,'2022-04-20 16:48:59','',''),(3440,'1','219','1',1,'Retail Sale Id 3521',642.36,0.00,0.00,1.01,24.24,'2022-04-20 16:50:07','',''),(3441,'1','219','1',1,'Retail Sale Id 3522',1500.96,0.00,0.00,2.36,56.64,'2022-04-20 16:55:28','',''),(3442,'1','219','1',1,'Retail Sale Id 3523',648.72,0.00,0.00,1.02,24.48,'2022-04-20 16:56:55','',''),(3443,'1','219','1',1,'Retail Sale Id 3524',7950.00,0.00,0.00,12.50,300.00,'2022-04-20 17:00:40','',''),(3444,'1','219','1',1,'Retail Sale Id 3524',7950.00,0.00,0.00,12.50,300.00,'2022-04-20 17:00:40','',''),(3445,'1','219','1',1,'Retail Sale Id 3525',1952.52,0.00,0.00,3.07,73.68,'2022-04-20 17:11:11','',''),(3446,'1','219','1',1,'Retail Sale Id 3526',4912.00,0.00,0.00,8.00,16.00,'2022-04-20 17:19:18','',''),(3447,'1','219','1',1,'Retail Sale Id 3527',1908.00,0.00,0.00,3.00,72.00,'2022-04-20 17:20:27','',''),(3448,'1','219','1',1,'Retail Sale Id 3528',1997.04,0.00,0.00,3.14,75.36,'2022-04-20 17:27:47','',''),(3449,'1','219','1',1,'Retail Sale Id 3529',3822.36,0.00,0.00,6.01,144.24,'2022-04-20 17:30:57','',''),(3450,'1','219','1',1,'Retail Sale Id 3530',3822.36,0.00,0.00,6.01,144.24,'2022-04-20 17:33:39','',''),(3451,'1','219','1',1,'Retail Sale Id 3531',1908.00,0.00,0.00,3.00,72.00,'2022-04-20 17:35:55','',''),(3452,'1','219','1',1,'Retail Sale Id 3532',1297.44,0.00,0.00,2.04,48.96,'2022-04-20 17:49:35','',''),(3453,'1','219','1',1,'Retail Sale Id 3533',502.44,0.00,0.00,0.79,18.96,'2022-04-20 17:53:42','',''),(3454,'1','219','1',1,'Retail Sale Id 3534',1399.20,0.00,0.00,2.20,52.80,'2022-04-20 17:58:19','',''),(3455,'1','219','1',1,'Retail Sale Id 3535',3822.36,0.00,0.00,6.01,144.24,'2022-04-20 18:12:27','',''),(3456,'1','219','1',1,'Retail Sale Id 3536',3822.36,0.00,0.00,6.01,144.24,'2022-04-20 18:20:09','',''),(3457,'1','219','1',1,'Retail Sale Id 3537',1202.04,0.00,0.00,1.89,45.36,'2022-04-20 18:27:07','',''),(3458,'1','219','1',1,'Retail Sale Id 3538',3847.80,0.00,0.00,6.05,145.20,'2022-04-20 18:33:34','',''),(3459,'1','219','1',1,'Retail Sale Id 3539',1297.44,0.00,0.00,2.04,48.96,'2022-04-21 08:04:31','',''),(3460,'1','219','1',1,'Retail Sale Id 3540',1997.04,0.00,0.00,3.14,75.36,'2022-04-21 09:24:55','',''),(3461,'1','219','1',1,'Retail Sale Id 3541',3816.00,0.00,0.00,6.00,144.00,'2022-04-21 09:39:42','',''),(3462,'1','219','1',1,'Retail Sale Id 3541',3816.00,0.00,0.00,6.00,144.00,'2022-04-21 09:39:42','',''),(3463,'1','219','1',1,'Retail Sale Id 3542',4000.44,0.00,0.00,6.29,150.96,'2022-04-21 09:48:38','',''),(3464,'1','219','1',1,'Retail Sale Id 3543',3816.00,0.00,0.00,6.00,144.00,'2022-04-21 10:05:49','',''),(3465,'1','219','1',1,'Retail Sale Id 3544',3001.92,0.00,0.00,4.72,113.28,'2022-04-21 10:36:06','',''),(3466,'1','219','1',1,'Retail Sale Id 3545',2544.00,0.00,0.00,4.00,96.00,'2022-04-21 10:54:21','',''),(3467,'1','219','1',1,'Retail Sale Id 3546',1297.44,0.00,0.00,2.04,48.96,'2022-04-21 11:02:44','',''),(3468,'1','219','1',1,'Retail Sale Id 3547',998.52,0.00,0.00,1.57,37.68,'2022-04-21 11:16:10','',''),(3469,'1','219','1',1,'Retail Sale Id 3548',1997.04,0.00,0.00,3.14,75.36,'2022-04-21 12:07:59','',''),(3470,'1','219','1',1,'Retail Sale Id 3549',1997.04,0.00,0.00,3.14,75.36,'2022-04-21 12:09:58','',''),(3471,'1','219','1',1,'Retail Sale Id 3550',1997.04,0.00,0.00,3.14,75.36,'2022-04-21 12:25:21','',''),(3472,'1','219','1',1,'Retail Sale Id 3551',7950.00,0.00,0.00,12.50,300.00,'2022-04-21 13:12:19','',''),(3473,'1','219','1',1,'Retail Sale Id 3552',6140.00,0.00,0.00,10.00,20.00,'2022-04-21 13:14:41','',''),(3474,'1','219','1',1,'Retail Sale Id 3553',7950.00,0.00,0.00,12.50,300.00,'2022-04-21 13:17:47','',''),(3475,'1','219','1',1,'Retail Sale Id 3554',1908.00,0.00,0.00,3.00,72.00,'2022-04-21 13:22:22','',''),(3476,'1','219','1',1,'Retail Sale Id 3555',6360.00,0.00,0.00,10.00,240.00,'2022-04-21 13:27:35','',''),(3477,'1','219','1',1,'Retail Sale Id 3556',1997.04,0.00,0.00,3.14,75.36,'2022-04-21 14:09:45','',''),(3478,'1','219','1',1,'Retail Sale Id 3557',1997.04,0.00,0.00,3.14,75.36,'2022-04-21 14:38:08','',''),(3479,'1','219','1',1,'Retail Sale Id 3558',2499.48,0.00,0.00,3.93,94.32,'2022-04-21 14:43:13','',''),(3480,'1','219','1',1,'Retail Sale Id 3559',1997.04,0.00,0.00,3.14,75.36,'2022-04-21 14:45:55','',''),(3481,'1','219','1',1,'Retail Sale Id 3560',1901.64,0.00,0.00,2.99,71.76,'2022-04-21 14:58:06','',''),(3482,'1','219','1',1,'Retail Sale Id 3561',4000.44,0.00,0.00,6.29,150.96,'2022-04-21 15:38:54','',''),(3483,'1','219','1',1,'Retail Sale Id 3562',3816.00,0.00,0.00,6.00,144.00,'2022-04-21 16:02:48','',''),(3484,'1','219','1',1,'Retail Sale Id 3563',1997.04,0.00,0.00,3.14,75.36,'2022-04-21 16:21:22','',''),(3485,'1','219','1',1,'Retail Sale Id 3564',1908.00,0.00,0.00,3.00,72.00,'2022-04-21 16:22:28','',''),(3486,'1','219','1',1,'Retail Sale Id 3565',1908.00,0.00,0.00,3.00,72.00,'2022-04-21 16:31:11','',''),(3487,'1','219','1',1,'Retail Sale Id 3566',3816.00,0.00,0.00,6.00,144.00,'2022-04-21 16:32:43','',''),(3488,'1','219','1',1,'Retail Sale Id 3567',3001.92,0.00,0.00,4.72,113.28,'2022-04-21 16:48:14','',''),(3489,'1','219','1',1,'Retail Sale Id 3568',3498.00,0.00,0.00,5.50,132.00,'2022-04-21 16:51:43','',''),(3490,'1','219','1',1,'Retail Sale Id 3569',3816.00,0.00,0.00,6.00,144.00,'2022-04-21 16:57:22','',''),(3491,'1','219','1',1,'Retail Sale Id 3570',298.92,0.00,0.00,0.47,11.28,'2022-04-21 16:58:44','',''),(3492,'1','219','1',1,'Retail Sale Id 3571',502.44,0.00,0.00,0.79,18.96,'2022-04-21 17:10:52','',''),(3493,'1','219','1',1,'Retail Sale Id 3572',502.44,0.00,0.00,0.79,18.96,'2022-04-21 17:33:36','',''),(3494,'1','219','1',1,'Retail Sale Id 3573',998.52,0.00,0.00,1.57,37.68,'2022-04-21 17:44:52','',''),(3495,'1','219','1',1,'Retail Sale Id 3574',648.72,0.00,0.00,1.02,24.48,'2022-04-21 17:47:34','',''),(3496,'1','219','1',1,'Retail Sale Id 3575',1049.40,0.00,0.00,1.65,39.60,'2022-04-21 17:56:27','',''),(3497,'1','219','1',1,'Retail Sale Id 3576',4000.44,0.00,0.00,6.29,150.96,'2022-04-21 18:01:24','',''),(3498,'1','219','1',1,'Retail Sale Id 3577',1997.04,0.00,0.00,3.14,75.36,'2022-04-21 18:06:33','',''),(3499,'1','219','1',1,'Retail Sale Id 3578',298.92,0.00,0.00,0.47,11.28,'2022-04-21 18:15:20','',''),(3500,'1','219','1',1,'Retail Sale Id 3579',400.68,0.00,0.00,0.63,15.12,'2022-04-21 18:22:39','',''),(3501,'1','219','1',1,'Retail Sale Id 3580',2601.24,0.00,0.00,4.09,98.16,'2022-04-21 18:28:41','',''),(3502,'1','219','1',1,'Retail Sale Id 3581',801.36,0.00,0.00,1.26,30.24,'2022-04-21 18:44:47','',''),(3503,'1','219','1',1,'Retail Sale Id 3582',1997.04,0.00,0.00,3.14,75.36,'2022-04-22 08:52:42','',''),(3504,'1','219','1',1,'Retail Sale Id 3583',1842.00,0.00,0.00,3.00,6.00,'2022-04-22 09:08:08','',''),(3505,'1','219','1',1,'Retail Sale Id 3584',18420.00,0.00,0.00,30.00,60.00,'2022-04-22 09:18:16','',''),(3506,'1','219','1',1,'Retail Sale Id 3585',15900.00,0.00,0.00,25.00,600.00,'2022-04-22 10:03:00','',''),(3507,'1','219','1',1,'Retail Sale Id 3586',3822.36,0.00,0.00,6.01,144.24,'2022-04-22 10:13:59','',''),(3508,'1','219','1',1,'Retail Sale Id 3587',3822.36,0.00,0.00,6.01,144.24,'2022-04-22 10:27:48','',''),(3509,'1','219','1',1,'Retail Sale Id 3588',1799.88,0.00,0.00,2.83,67.92,'2022-04-22 10:32:42','',''),(3510,'1','219','1',1,'Retail Sale Id 3588',1799.88,0.00,0.00,2.83,67.92,'2022-04-22 10:32:42','',''),(3511,'1','219','1',1,'Retail Sale Id 3588',4998.96,0.00,0.00,7.86,188.64,'2022-04-22 10:32:42','',''),(3512,'1','219','1',1,'Retail Sale Id 3589',7675.00,0.00,0.00,12.50,25.00,'2022-04-22 10:42:44','',''),(3513,'1','219','1',1,'Retail Sale Id 3590',1500.96,0.00,0.00,2.36,56.64,'2022-04-22 10:50:17','',''),(3514,'1','219','1',1,'Retail Sale Id 3591',7950.00,0.00,0.00,12.50,300.00,'2022-04-22 11:10:34','',''),(3515,'1','219','1',1,'Retail Sale Id 3592',3001.92,0.00,0.00,4.72,113.28,'2022-04-22 11:15:34','',''),(3516,'1','219','1',1,'Retail Sale Id 3593',1500.96,0.00,0.00,2.36,56.64,'2022-04-22 11:29:53','',''),(3517,'1','219','1',1,'Retail Sale Id 3594',998.52,0.00,0.00,1.57,37.68,'2022-04-22 11:59:54','',''),(3518,'1','219','1',1,'Retail Sale Id 3595',4801.80,0.00,0.00,7.55,181.20,'2022-04-22 12:24:38','',''),(3519,'1','219','1',1,'Retail Sale Id 3596',1927.08,0.00,0.00,3.03,72.72,'2022-04-22 13:28:24','',''),(3520,'1','219','1',1,'Retail Sale Id 3597',1297.44,0.00,0.00,2.04,48.96,'2022-04-22 13:47:23','',''),(3521,'1','219','1',1,'Retail Sale Id 3598',3180.00,0.00,0.00,5.00,120.00,'2022-04-22 14:23:11','',''),(3522,'1','219','1',1,'Retail Sale Id 3599',6360.00,0.00,0.00,10.00,240.00,'2022-04-22 14:35:08','',''),(3523,'1','219','1',1,'Retail Sale Id 3600',1908.00,0.00,0.00,3.00,72.00,'2022-04-22 14:44:39','',''),(3524,'1','219','1',1,'Retail Sale Id 3601',1500.96,0.00,0.00,2.36,56.64,'2022-04-22 15:04:32','',''),(3525,'1','219','1',1,'Retail Sale Id 3602',298.92,0.00,0.00,0.47,11.28,'2022-04-22 15:06:11','',''),(3526,'1','219','1',1,'Retail Sale Id 3603',998.52,0.00,0.00,1.57,37.68,'2022-04-22 15:19:57','',''),(3527,'1','219','1',1,'Retail Sale Id 3604',7950.00,0.00,0.00,12.50,300.00,'2022-04-22 15:20:55','',''),(3528,'1','219','1',1,'Retail Sale Id 3605',998.52,0.00,0.00,1.57,37.68,'2022-04-22 16:20:43','',''),(3529,'1','219','1',1,'Retail Sale Id 3606',1908.00,0.00,0.00,3.00,72.00,'2022-04-22 16:22:19','',''),(3530,'1','219','1',1,'Retail Sale Id 3607',1908.00,0.00,0.00,3.00,72.00,'2022-04-22 16:24:00','',''),(3531,'1','219','1',1,'Retail Sale Id 3608',648.72,0.00,0.00,1.02,24.48,'2022-04-22 16:25:45','',''),(3532,'1','219','1',1,'Retail Sale Id 3609',3822.36,0.00,0.00,6.01,144.24,'2022-04-22 16:29:13','',''),(3533,'1','219','1',1,'Retail Sale Id 3610',699.60,0.00,0.00,1.10,26.40,'2022-04-22 16:49:20','',''),(3534,'1','219','1',1,'Retail Sale Id 3611',1908.00,0.00,0.00,3.00,72.00,'2022-04-22 17:01:12','',''),(3535,'1','219','1',1,'Retail Sale Id 3612',4502.88,0.00,0.00,7.08,169.92,'2022-04-22 17:03:14','',''),(3536,'1','219','1',1,'Retail Sale Id 3613',960.36,0.00,0.00,1.51,36.24,'2022-04-22 17:10:22','',''),(3537,'1','219','1',1,'Retail Sale Id 3614',801.36,0.00,0.00,1.26,30.24,'2022-04-22 17:13:48','',''),(3538,'1','219','1',1,'Retail Sale Id 3615',1297.44,0.00,0.00,2.04,48.96,'2022-04-22 17:30:37','',''),(3539,'1','219','1',1,'Retail Sale Id 3616',502.44,0.00,0.00,0.79,18.96,'2022-04-22 17:37:19','',''),(3540,'1','219','1',1,'Retail Sale Id 3617',3809.64,0.00,0.00,5.99,143.76,'2022-04-22 17:42:27','',''),(3541,'1','219','1',1,'Retail Sale Id 3618',1500.96,0.00,0.00,2.36,56.64,'2022-04-22 17:44:47','',''),(3542,'1','219','1',1,'Retail Sale Id 3619',1799.88,0.00,0.00,2.83,67.92,'2022-04-22 17:52:05','',''),(3543,'1','219','1',1,'Retail Sale Id 3620',33770.00,0.00,0.00,55.00,110.00,'2022-04-22 18:03:48','',''),(3544,'1','219','1',1,'Retail Sale Id 3621',1297.44,0.00,0.00,2.04,48.96,'2022-04-22 18:05:50','',''),(3545,'1','219','1',1,'Retail Sale Id 3622',298.92,0.00,0.00,0.47,11.28,'2022-04-22 18:26:57','',''),(3546,'1','219','1',1,'Return of Retail Sale Id 3616',0.00,502.44,0.79,0.00,-18.96,'2022-04-22 23:50:41','',''),(3547,'1','219','1',1,'Retail Sale Id 3624',419.76,0.00,0.00,0.66,15.84,'2022-04-22 23:52:55','',''),(3548,'1','219','1',1,'Retail Sale Id 3625',101.76,0.00,0.00,0.16,3.84,'2022-04-22 23:54:11','',''),(3549,'1','219','1',1,'Retail Sale Id 3626',6360.00,0.00,0.00,10.00,240.00,'2022-04-23 07:12:44','',''),(3550,'1','219','1',1,'Retail Sale Id 3627',3199.08,0.00,0.00,5.03,120.72,'2022-04-23 08:07:08','',''),(3551,'1','219','1',1,'Retail Sale Id 3628',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 08:12:55','',''),(3552,'1','219','1',1,'Retail Sale Id 3629',30700.00,0.00,0.00,50.00,100.00,'2022-04-23 08:43:24','',''),(3553,'1','219','1',1,'Retail Sale Id 3630',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 08:58:46','',''),(3554,'1','219','1',1,'Retail Sale Id 3631',502.44,0.00,0.00,0.79,18.96,'2022-04-23 09:17:40','',''),(3555,'1','219','1',1,'Retail Sale Id 3632',7950.00,0.00,0.00,12.50,300.00,'2022-04-23 09:19:17','',''),(3556,'1','219','1',1,'Retail Sale Id 3633',7950.00,0.00,0.00,12.50,300.00,'2022-04-23 09:21:12','',''),(3557,'1','219','1',1,'Retail Sale Id 3634',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 09:22:24','',''),(3558,'1','219','1',1,'Retail Sale Id 3635',1997.04,0.00,0.00,3.14,75.36,'2022-04-23 09:39:22','',''),(3559,'1','219','1',1,'Retail Sale Id 3636',636.00,0.00,0.00,1.00,24.00,'2022-04-23 09:42:58','',''),(3560,'1','219','1',1,'Retail Sale Id 3637',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 09:45:05','',''),(3561,'1','219','1',1,'Retail Sale Id 3638',6360.00,0.00,0.00,10.00,240.00,'2022-04-23 09:48:38','',''),(3562,'1','219','1',1,'Retail Sale Id 3639',7950.00,0.00,0.00,12.50,300.00,'2022-04-23 09:53:07','',''),(3563,'1','219','1',1,'Retail Sale Id 3640',1908.00,0.00,0.00,3.00,72.00,'2022-04-23 11:13:11','',''),(3564,'1','219','1',1,'Retail Sale Id 3640',1908.00,0.00,0.00,3.00,72.00,'2022-04-23 11:13:11','',''),(3565,'1','219','1',1,'Retail Sale Id 3640',3180.00,0.00,0.00,5.00,120.00,'2022-04-23 11:13:11','',''),(3566,'1','219','1',1,'Retail Sale Id 3641',1228.00,0.00,0.00,2.00,4.00,'2022-04-23 11:27:06','',''),(3567,'1','219','1',1,'Retail Sale Id 3642',3001.92,0.00,0.00,4.72,113.28,'2022-04-23 11:32:46','',''),(3568,'1','219','1',1,'Retail Sale Id 3643',4000.44,0.00,0.00,6.29,150.96,'2022-04-23 11:37:21','',''),(3569,'1','219','1',1,'Retail Sale Id 3644',1297.44,0.00,0.00,2.04,48.96,'2022-04-23 11:50:09','',''),(3570,'1','219','1',1,'Retail Sale Id 3645',7002.36,0.00,0.00,11.01,264.24,'2022-04-23 11:56:26','',''),(3571,'1','219','1',1,'Retail Sale Id 3647',7950.00,0.00,0.00,12.50,300.00,'2022-04-23 11:57:57','',''),(3572,'1','219','1',1,'Retail Sale Id 3648',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 12:00:16','',''),(3573,'1','219','1',1,'Retail Sale Id 3649',7950.00,0.00,0.00,12.50,300.00,'2022-04-23 12:05:18','',''),(3574,'1','219','1',1,'Retail Sale Id 3650',30700.00,0.00,0.00,50.00,100.00,'2022-04-23 12:08:47','',''),(3575,'1','219','1',1,'Retail Sale Id 3651',9540.00,0.00,0.00,15.00,360.00,'2022-04-23 13:15:48','',''),(3576,'1','219','1',1,'Retail Sale Id 3652',903.12,0.00,0.00,1.42,34.08,'2022-04-23 13:18:51','',''),(3577,'1','219','1',1,'Retail Sale Id 3653',6360.00,0.00,0.00,10.00,240.00,'2022-04-23 13:43:18','',''),(3578,'1','219','1',1,'Retail Sale Id 3653',6360.00,0.00,0.00,10.00,240.00,'2022-04-23 13:43:18','',''),(3579,'1','219','1',1,'Retail Sale Id 3654',3001.92,0.00,0.00,4.72,113.28,'2022-04-23 14:14:35','',''),(3580,'1','219','1',1,'Retail Sale Id 3655',1500.96,0.00,0.00,2.36,56.64,'2022-04-23 14:23:31','',''),(3581,'1','219','1',1,'Retail Sale Id 3656',1908.00,0.00,0.00,3.00,72.00,'2022-04-23 14:36:43','',''),(3582,'1','219','1',1,'Retail Sale Id 3657',1908.00,0.00,0.00,3.00,72.00,'2022-04-23 14:41:17','',''),(3583,'1','219','1',1,'Retail Sale Id 3658',998.52,0.00,0.00,1.57,37.68,'2022-04-23 15:16:59','',''),(3584,'1','219','1',1,'Retail Sale Id 3659',7950.00,0.00,0.00,12.50,300.00,'2022-04-23 15:20:19','',''),(3585,'1','219','1',1,'Retail Sale Id 3660',7950.00,0.00,0.00,12.50,300.00,'2022-04-23 15:39:03','',''),(3586,'1','219','1',1,'Retail Sale Id 3661',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 15:55:20','',''),(3587,'1','219','1',1,'Retail Sale Id 3662',801.36,0.00,0.00,1.26,30.24,'2022-04-23 16:14:57','',''),(3588,'1','219','1',1,'Retail Sale Id 3663',3001.92,0.00,0.00,4.72,113.28,'2022-04-23 16:17:20','',''),(3589,'1','219','1',1,'Retail Sale Id 3664',7675.00,0.00,0.00,12.50,25.00,'2022-04-23 16:32:40','',''),(3590,'1','219','1',1,'Retail Sale Id 3665',7950.00,0.00,0.00,12.50,300.00,'2022-04-23 16:57:14','',''),(3591,'1','219','1',1,'Retail Sale Id 3666',50998.84,0.00,0.00,83.06,166.12,'2022-04-23 17:03:08','',''),(3592,'1','219','1',1,'Retail Sale Id 3667',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 17:04:28','',''),(3593,'1','219','1',1,'Retail Sale Id 3668',801.36,0.00,0.00,1.26,30.24,'2022-04-23 17:06:51','',''),(3594,'1','219','1',1,'Retail Sale Id 3669',1997.04,0.00,0.00,3.14,75.36,'2022-04-23 17:11:41','',''),(3595,'1','219','1',1,'Retail Sale Id 3670',1500.96,0.00,0.00,2.36,56.64,'2022-04-23 17:31:22','',''),(3596,'1','219','1',1,'Retail Sale Id 3671',502.44,0.00,0.00,0.79,18.96,'2022-04-23 17:33:41','',''),(3597,'1','219','1',1,'Retail Sale Id 3672',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 17:34:48','',''),(3598,'1','219','1',1,'Retail Sale Id 3673',1908.00,0.00,0.00,3.00,72.00,'2022-04-23 17:37:29','',''),(3599,'1','219','1',1,'Retail Sale Id 3674',3199.08,0.00,0.00,5.03,120.72,'2022-04-23 17:49:50','',''),(3600,'1','219','1',1,'Retail Sale Id 3675',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 17:58:10','',''),(3601,'1','219','1',1,'Retail Sale Id 3676',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 17:59:38','',''),(3602,'1','219','1',1,'Retail Sale Id 3677',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 18:26:19','',''),(3603,'1','219','1',1,'Retail Sale Id 3678',1500.96,0.00,0.00,2.36,56.64,'2022-04-23 18:27:44','',''),(3604,'1','219','1',1,'Retail Sale Id 3679',3816.00,0.00,0.00,6.00,144.00,'2022-04-23 18:46:18','',''),(3605,'1','219','1',1,'Return of Retail Sale Id 3678',0.00,1500.96,2.36,0.00,-56.64,'2022-04-23 23:57:07','',''),(3606,'1','219','1',1,'Retail Sale Id 3680',1500.96,0.00,0.00,2.36,56.64,'2022-04-23 23:58:53','',''),(3607,'1','219','1',1,'Retail Sale Id 3681',502.44,0.00,0.00,0.79,18.96,'2022-04-24 08:56:25','',''),(3608,'1','219','1',1,'Retail Sale Id 3682',3822.36,0.00,0.00,6.01,144.24,'2022-04-24 09:12:29','',''),(3609,'1','219','1',1,'Retail Sale Id 3683',3822.36,0.00,0.00,6.01,144.24,'2022-04-24 09:21:27','',''),(3610,'1','219','1',1,'Retail Sale Id 3684',61400.00,0.00,0.00,100.00,200.00,'2022-04-24 09:24:17','',''),(3611,'1','219','1',1,'Retail Sale Id 3685',998.52,0.00,0.00,1.57,37.68,'2022-04-24 09:29:37','',''),(3612,'1','219','1',1,'Retail Sale Id 3686',998.52,0.00,0.00,1.57,37.68,'2022-04-24 09:34:06','',''),(3613,'1','219','1',1,'Retail Sale Id 3687',18420.00,0.00,0.00,30.00,60.00,'2022-04-24 09:48:27','',''),(3614,'1','219','1',1,'Retail Sale Id 3688',30700.00,0.00,0.00,50.00,100.00,'2022-04-24 09:50:26','',''),(3615,'1','219','1',1,'Retail Sale Id 3689',3822.36,0.00,0.00,6.01,144.24,'2022-04-24 09:54:04','',''),(3616,'1','219','1',1,'Retail Sale Id 3690',1202.04,0.00,0.00,1.89,45.36,'2022-04-24 09:55:44','',''),(3617,'1','219','1',1,'Retail Sale Id 3691',2550.36,0.00,0.00,4.01,96.24,'2022-04-24 10:02:54','',''),(3618,'1','219','1',1,'Retail Sale Id 3692',86574.00,0.00,0.00,141.00,282.00,'2022-04-24 10:09:17','',''),(3619,'1','219','1',1,'Retail Sale Id 3693',35612.00,0.00,0.00,58.00,116.00,'2022-04-24 10:11:52','',''),(3620,'1','219','1',1,'Retail Sale Id 3695',614.00,0.00,0.00,1.00,2.00,'2022-04-24 10:13:15','',''),(3621,'1','219','1',1,'Retail Sale Id 3696',6360.00,0.00,0.00,10.00,240.00,'2022-04-24 10:16:06','',''),(3622,'1','219','1',1,'Retail Sale Id 3697',6360.00,0.00,0.00,10.00,240.00,'2022-04-24 10:48:10','',''),(3623,'1','219','1',1,'Retail Sale Id 3698',4000.44,0.00,0.00,6.29,150.96,'2022-04-24 10:49:09','',''),(3624,'1','219','1',1,'Retail Sale Id 3699',1997.04,0.00,0.00,3.14,75.36,'2022-04-24 10:50:23','',''),(3625,'1','219','1',1,'Retail Sale Id 3700',1500.96,0.00,0.00,2.36,56.64,'2022-04-24 10:56:31','',''),(3626,'1','219','1',1,'Retail Sale Id 3701',1997.04,0.00,0.00,3.14,75.36,'2022-04-24 11:26:27','',''),(3627,'1','219','1',1,'Retail Sale Id 3702',46050.00,0.00,0.00,75.00,150.00,'2022-04-24 11:32:23','',''),(3628,'1','219','1',1,'Retail Sale Id 3703',3822.36,0.00,0.00,6.01,144.24,'2022-04-24 11:35:28','',''),(3629,'1','219','1',1,'Retail Sale Id 3704',3180.00,0.00,0.00,5.00,120.00,'2022-04-24 11:45:34','',''),(3630,'1','219','1',1,'Retail Sale Id 3706',3180.00,0.00,0.00,5.00,120.00,'2022-04-24 11:56:47','',''),(3631,'1','219','1',1,'Retail Sale Id 3707',998.52,0.00,0.00,1.57,37.68,'2022-04-24 12:03:21','',''),(3632,'1','219','1',1,'Retail Sale Id 3707',7950.00,0.00,0.00,12.50,300.00,'2022-04-24 12:03:21','',''),(3633,'1','219','1',1,'Retail Sale Id 3708',1799.88,0.00,0.00,2.83,67.92,'2022-04-24 12:38:01','',''),(3634,'1','219','1',1,'Retail Sale Id 3709',7950.00,0.00,0.00,12.50,300.00,'2022-04-24 12:46:33','',''),(3635,'1','219','1',1,'Retail Sale Id 3710',1908.00,0.00,0.00,3.00,72.00,'2022-04-24 12:56:20','',''),(3636,'1','219','1',1,'Retail Sale Id 3711',3822.36,0.00,0.00,6.01,144.24,'2022-04-24 13:08:37','',''),(3637,'1','219','1',1,'Retail Sale Id 3712',1997.04,0.00,0.00,3.14,75.36,'2022-04-24 13:09:55','',''),(3638,'1','219','1',1,'Retail Sale Id 3713',30700.00,0.00,0.00,50.00,100.00,'2022-04-24 13:17:03','',''),(3639,'1','219','1',1,'Retail Sale Id 3714',1908.00,0.00,0.00,3.00,72.00,'2022-04-24 13:24:19','',''),(3640,'1','219','1',1,'Retail Sale Id 3715',1908.00,0.00,0.00,3.00,72.00,'2022-04-24 13:28:42','',''),(3641,'1','219','1',1,'Retail Sale Id 3716',1500.96,0.00,0.00,2.36,56.64,'2022-04-24 13:32:35','',''),(3642,'1','219','1',1,'Retail Sale Id 3717',3498.00,0.00,0.00,5.50,132.00,'2022-04-24 13:56:19','',''),(3643,'1','219','1',1,'Retail Sale Id 3718',1202.04,0.00,0.00,1.89,45.36,'2022-04-24 14:04:06','',''),(3644,'1','219','1',1,'Retail Sale Id 3719',998.52,0.00,0.00,1.57,37.68,'2022-04-24 14:34:54','',''),(3645,'1','219','1',1,'Retail Sale Id 3720',998.52,0.00,0.00,1.57,37.68,'2022-04-24 15:09:17','',''),(3646,'1','219','1',1,'Retail Sale Id 3722',3180.00,0.00,0.00,5.00,120.00,'2022-04-24 15:11:00','',''),(3647,'1','219','1',1,'Retail Sale Id 3723',1908.00,0.00,0.00,3.00,72.00,'2022-04-24 15:13:05','',''),(3648,'1','219','1',1,'Retail Sale Id 3724',1908.00,0.00,0.00,3.00,72.00,'2022-04-24 15:18:24','',''),(3649,'1','219','1',1,'Retail Sale Id 3725',1908.00,0.00,0.00,3.00,72.00,'2022-04-24 15:20:12','',''),(3650,'1','219','1',1,'Retail Sale Id 3726',3822.36,0.00,0.00,6.01,144.24,'2022-04-24 15:28:32','',''),(3651,'1','219','1',1,'Retail Sale Id 3727',1297.44,0.00,0.00,2.04,48.96,'2022-04-24 15:30:24','',''),(3652,'1','219','1',1,'Retail Sale Id 3728',3847.80,0.00,0.00,6.05,145.20,'2022-04-24 15:32:14','',''),(3653,'1','219','1',1,'Retail Sale Id 3729',3822.36,0.00,0.00,6.01,144.24,'2022-04-24 15:34:29','',''),(3654,'1','219','1',1,'Retail Sale Id 3730',1927.08,0.00,0.00,3.03,72.72,'2022-04-24 15:35:58','',''),(3655,'1','219','1',1,'Retail Sale Id 3731',2047.92,0.00,0.00,3.22,77.28,'2022-04-24 15:37:49','',''),(3656,'1','219','1',1,'Retail Sale Id 3732',648.72,0.00,0.00,1.02,24.48,'2022-04-24 16:39:38','',''),(3657,'1','219','1',1,'Retail Sale Id 3733',3822.36,0.00,0.00,6.01,144.24,'2022-04-24 16:41:34','',''),(3658,'1','219','1',1,'Retail Sale Id 3734',998.52,0.00,0.00,1.57,37.68,'2022-04-24 16:45:21','',''),(3659,'1','219','1',1,'Retail Sale Id 3735',502.44,0.00,0.00,0.79,18.96,'2022-04-24 17:20:21','',''),(3660,'1','219','1',1,'Retail Sale Id 3736',1997.04,0.00,0.00,3.14,75.36,'2022-04-24 17:25:13','',''),(3661,'1','219','1',1,'Retail Sale Id 3737',1500.96,0.00,0.00,2.36,56.64,'2022-04-24 17:51:35','',''),(3662,'1','219','1',1,'Retail Sale Id 3738',4000.44,0.00,0.00,6.29,150.96,'2022-04-24 17:53:04','',''),(3663,'1','219','1',1,'Retail Sale Id 3739',998.52,0.00,0.00,1.57,37.68,'2022-04-24 18:10:29','',''),(3664,'1','219','1',1,'Retail Sale Id 3740',1297.44,0.00,0.00,2.04,48.96,'2022-04-24 18:13:00','',''),(3665,'1','219','1',1,'Retail Sale Id 3741',1322.88,0.00,0.00,2.08,49.92,'2022-04-24 18:16:28','',''),(3666,'1','219','1',1,'Retail Sale Id 3741',3180.00,0.00,0.00,5.00,120.00,'2022-04-24 18:16:28','',''),(3667,'1','219','1',1,'Retail Sale Id 3742',502.44,0.00,0.00,0.79,18.96,'2022-04-24 18:17:45','',''),(3668,'1','219','1',1,'Retail Sale Id 3743',400.68,0.00,0.00,0.63,15.12,'2022-04-24 18:19:02','',''),(3669,'1','219','1',1,'Retail Sale Id 3745',998.52,0.00,0.00,1.57,37.68,'2022-04-24 18:23:51','',''),(3670,'1','219','1',1,'Retail Sale Id 3746',1997.04,0.00,0.00,3.14,75.36,'2022-04-24 18:37:26','',''),(3671,'1','219','1',1,'Return of Retail Sale Id 3745',0.00,998.52,1.57,0.00,-37.68,'2022-04-24 23:13:42','',''),(3672,'1','219','1',1,'Retail Sale Id 3747',661.44,0.00,0.00,1.04,24.96,'2022-04-24 23:15:24','',''),(3673,'1','219','1',1,'Return of Retail Sale Id 3695',0.00,614.00,1.00,0.00,-2.00,'2022-04-24 23:17:16','',''),(3674,'1','219','1',1,'Retail Sale Id 3748',86.15,0.00,0.00,17.23,-10458.61,'2022-04-24 23:20:28','',''),(3675,'1','219','1',1,'Retail Sale Id 3749',18420.00,0.00,0.00,30.00,60.00,'2022-04-25 07:26:12','',''),(3676,'1','219','1',1,'Retail Sale Id 3750',16578.00,0.00,0.00,27.00,54.00,'2022-04-25 08:43:16','',''),(3677,'1','219','1',1,'Retail Sale Id 3752',7950.00,0.00,0.00,12.50,300.00,'2022-04-25 08:55:40','',''),(3678,'1','219','1',1,'Retail Sale Id 3753',6499.92,0.00,0.00,10.22,245.28,'2022-04-25 09:04:38','',''),(3679,'1','219','1',1,'Retail Sale Id 3754',1908.00,0.00,0.00,3.00,72.00,'2022-04-25 09:11:50','',''),(3680,'1','219','1',1,'Retail Sale Id 3755',3199.08,0.00,0.00,5.03,120.72,'2022-04-25 09:34:20','',''),(3681,'1','219','1',1,'Retail Sale Id 3756',1997.04,0.00,0.00,3.14,75.36,'2022-04-25 10:04:02','',''),(3682,'1','219','1',1,'Retail Sale Id 3757',2544.00,0.00,0.00,4.00,96.00,'2022-04-25 10:15:16','',''),(3683,'1','219','1',1,'Retail Sale Id 3758',2544.00,0.00,0.00,4.00,96.00,'2022-04-25 10:16:55','',''),(3684,'1','219','1',1,'Retail Sale Id 3759',1997.04,0.00,0.00,3.14,75.36,'2022-04-25 10:28:59','',''),(3685,'1','219','1',1,'Retail Sale Id 3760',3816.00,0.00,0.00,6.00,144.00,'2022-04-25 10:33:43','',''),(3686,'1','219','1',1,'Retail Sale Id 3761',3199.08,0.00,0.00,5.03,120.72,'2022-04-25 10:37:21','',''),(3687,'1','219','1',1,'Retail Sale Id 3762',3816.00,0.00,0.00,6.00,144.00,'2022-04-25 11:06:26','',''),(3688,'1','219','1',1,'Retail Sale Id 3763',1997.04,0.00,0.00,3.14,75.36,'2022-04-25 11:07:29','',''),(3689,'1','219','1',1,'Retail Sale Id 3764',2499.48,0.00,0.00,3.93,94.32,'2022-04-25 11:19:28','',''),(3690,'1','219','1',1,'Retail Sale Id 3765',1997.04,0.00,0.00,3.14,75.36,'2022-04-25 11:25:12','',''),(3691,'1','219','1',1,'Retail Sale Id 3766',3001.92,0.00,0.00,4.72,113.28,'2022-04-25 11:55:38','',''),(3692,'1','219','1',1,'Retail Sale Id 3767',3816.00,0.00,0.00,6.00,144.00,'2022-04-25 12:34:22','',''),(3693,'1','219','1',1,'Retail Sale Id 3768',502.44,0.00,0.00,0.79,18.96,'2022-04-25 12:41:51','',''),(3694,'1','219','1',1,'Retail Sale Id 3769',298.92,0.00,0.00,0.47,11.28,'2022-04-25 12:45:02','',''),(3695,'1','219','1',1,'Retail Sale Id 3770',4299.36,0.00,0.00,6.76,162.24,'2022-04-25 12:57:29','',''),(3696,'1','219','1',1,'Retail Sale Id 3771',998.52,0.00,0.00,1.57,37.68,'2022-04-25 13:01:57','',''),(3697,'1','219','1',1,'Retail Sale Id 3772',7950.00,0.00,0.00,12.50,300.00,'2022-04-25 13:12:21','',''),(3698,'1','219','1',1,'Retail Sale Id 3773',7950.00,0.00,0.00,12.50,300.00,'2022-04-25 13:14:32','',''),(3699,'1','219','1',1,'Retail Sale Id 3774',1500.96,0.00,0.00,2.36,56.64,'2022-04-25 13:17:37','',''),(3700,'1','219','1',1,'Retail Sale Id 3775',3199.08,0.00,0.00,5.03,120.72,'2022-04-25 13:24:16','',''),(3701,'1','219','1',1,'Retail Sale Id 3776',7950.00,0.00,0.00,12.50,300.00,'2022-04-25 13:39:10','',''),(3702,'1','219','1',1,'Retail Sale Id 3777',1997.04,0.00,0.00,3.14,75.36,'2022-04-25 13:50:11','',''),(3703,'1','219','1',1,'Retail Sale Id 3778',298.92,0.00,0.00,0.47,11.28,'2022-04-25 13:51:29','',''),(3704,'1','219','1',1,'Retail Sale Id 3779',3816.00,0.00,0.00,6.00,144.00,'2022-04-25 13:59:54','',''),(3705,'1','219','1',1,'Retail Sale Id 3780',3816.00,0.00,0.00,6.00,144.00,'2022-04-25 14:02:43','',''),(3706,'1','219','1',1,'Retail Sale Id 3781',2226.00,0.00,0.00,3.50,84.00,'2022-04-25 15:02:38','',''),(3707,'1','219','1',1,'Retail Sale Id 3782',3816.00,0.00,0.00,6.00,144.00,'2022-04-25 15:10:05','',''),(3708,'1','219','1',1,'Retail Sale Id 3783',502.44,0.00,0.00,0.79,18.96,'2022-04-25 15:13:51','',''),(3709,'1','219','1',1,'Retail Sale Id 3784',1997.04,0.00,0.00,3.14,75.36,'2022-04-25 15:27:52','',''),(3710,'1','219','1',1,'Retail Sale Id 3785',3816.00,0.00,0.00,6.00,144.00,'2022-04-25 15:37:38','',''),(3711,'1','219','1',1,'Retail Sale Id 3786',1297.44,0.00,0.00,2.04,48.96,'2022-04-25 15:43:38','',''),(3712,'1','219','1',1,'Retail Sale Id 3787',7950.00,0.00,0.00,12.50,300.00,'2022-04-25 15:46:08','',''),(3713,'1','219','1',1,'Retail Sale Id 3788',1997.04,0.00,0.00,3.14,75.36,'2022-04-25 16:49:02','',''),(3714,'1','219','1',1,'Retail Sale Id 3789',1908.00,0.00,0.00,3.00,72.00,'2022-04-25 17:05:40','',''),(3715,'1','219','1',1,'Retail Sale Id 3790',2900.16,0.00,0.00,4.56,109.44,'2022-04-25 17:17:43','',''),(3716,'1','219','1',1,'Retail Sale Id 3791',502.44,0.00,0.00,0.79,18.96,'2022-04-25 17:32:20','',''),(3717,'1','219','1',1,'Retail Sale Id 3792',4000.44,0.00,0.00,6.29,150.96,'2022-04-25 17:41:08','',''),(3718,'1','219','1',1,'Retail Sale Id 3793',1278.36,0.00,0.00,2.01,48.24,'2022-04-25 17:54:49','',''),(3719,'1','219','1',1,'Retail Sale Id 3794',1698.12,0.00,0.00,2.67,64.08,'2022-04-25 17:56:31','',''),(3720,'1','219','1',1,'Retail Sale Id 3795',298.92,0.00,0.00,0.47,11.28,'2022-04-25 18:06:48','',''),(3721,'1','219','1',1,'Retail Sale Id 3796',1997.04,0.00,0.00,3.14,75.36,'2022-04-25 18:30:46','',''),(3722,'1','219','1',1,'Retail Sale Id 3797',1500.96,0.00,0.00,2.36,56.64,'2022-04-25 18:40:59','',''),(3723,'1','219','1',1,'Retail Sale Id 3798',998.52,0.00,0.00,1.57,37.68,'2022-04-26 07:22:50','',''),(3724,'1','219','1',1,'Retail Sale Id 3799',30700.00,0.00,0.00,50.00,100.00,'2022-04-26 08:03:23','',''),(3725,'1','219','1',1,'Retail Sale Id 3800',1908.00,0.00,0.00,3.00,72.00,'2022-04-26 08:11:22','',''),(3726,'1','219','1',1,'Retail Sale Id 3800',1908.00,0.00,0.00,3.00,72.00,'2022-04-26 08:11:22','',''),(3727,'1','219','1',1,'Retail Sale Id 3800',1908.00,0.00,0.00,3.00,72.00,'2022-04-26 08:11:22','',''),(3728,'1','219','1',1,'Retail Sale Id 3801',4000.44,0.00,0.00,6.29,150.96,'2022-04-26 09:11:19','',''),(3729,'1','219','1',1,'Retail Sale Id 3803',1297.44,0.00,0.00,2.04,48.96,'2022-04-26 09:23:04','',''),(3730,'1','219','1',1,'Retail Sale Id 3803',3180.00,0.00,0.00,5.00,120.00,'2022-04-26 09:23:04','',''),(3731,'1','219','1',1,'Retail Sale Id 3804',6360.00,0.00,0.00,10.00,240.00,'2022-04-26 09:52:11','',''),(3732,'1','219','1',1,'Retail Sale Id 3805',3180.00,0.00,0.00,5.00,120.00,'2022-04-26 09:54:05','',''),(3733,'1','219','1',1,'Retail Sale Id 3806',1997.04,0.00,0.00,3.14,75.36,'2022-04-26 10:07:18','',''),(3734,'1','219','1',1,'Retail Sale Id 3807',998.52,0.00,0.00,1.57,37.68,'2022-04-26 10:30:31','',''),(3735,'1','219','1',1,'Retail Sale Id 3808',3377.00,0.00,0.00,5.50,11.00,'2022-04-26 10:38:02','',''),(3736,'1','219','1',1,'Retail Sale Id 3809',3822.36,0.00,0.00,6.01,144.24,'2022-04-26 11:27:05','',''),(3737,'1','219','1',1,'Retail Sale Id 3811',1920.72,0.00,0.00,3.02,72.48,'2022-04-26 11:29:25','',''),(3738,'1','219','1',1,'Retail Sale Id 3813',7950.00,0.00,0.00,12.50,300.00,'2022-04-26 11:31:15','',''),(3739,'1','219','1',1,'Retail Sale Id 3814',3917.32,0.00,0.00,6.38,12.76,'2022-04-26 11:39:28','',''),(3740,'1','219','1',1,'Retail Sale Id 3815',3757.68,0.00,0.00,6.12,12.24,'2022-04-26 11:43:22','',''),(3741,'1','219','1',1,'Retail Sale Id 3816',6398.16,0.00,0.00,10.06,241.44,'2022-04-26 11:49:26','',''),(3742,'1','219','1',1,'Retail Sale Id 3817',3822.36,0.00,0.00,6.01,144.24,'2022-04-26 12:09:12','',''),(3743,'1','219','1',1,'Retail Sale Id 3818',3684.00,0.00,0.00,6.00,12.00,'2022-04-26 12:17:17','',''),(3744,'1','219','1',1,'Retail Sale Id 3819',0.00,0.00,0.00,0.00,0.00,'2022-04-26 12:19:23','',''),(3745,'1','219','1',1,'Retail Sale Id 3820',3822.36,0.00,0.00,6.01,144.24,'2022-04-26 12:36:57','',''),(3746,'1','219','1',1,'Retail Sale Id 3821',7950.00,0.00,0.00,12.50,300.00,'2022-04-26 13:01:20','',''),(3747,'1','219','1',1,'Retail Sale Id 3822',3822.36,0.00,0.00,6.01,144.24,'2022-04-26 13:06:09','',''),(3748,'1','219','1',1,'Retail Sale Id 3822',7950.00,0.00,0.00,12.50,300.00,'2022-04-26 13:06:09','',''),(3749,'1','219','1',1,'Retail Sale Id 3823',801.36,0.00,0.00,1.26,30.24,'2022-04-26 13:24:34','',''),(3750,'1','219','1',1,'Retail Sale Id 3824',6360.00,0.00,0.00,10.00,240.00,'2022-04-26 13:36:51','',''),(3751,'1','219','1',1,'Retail Sale Id 3825',1908.00,0.00,0.00,3.00,72.00,'2022-04-26 13:51:54','',''),(3752,'1','219','1',1,'Retail Sale Id 3826',3796.92,0.00,0.00,5.97,143.28,'2022-04-26 14:12:33','',''),(3753,'1','219','1',1,'Retail Sale Id 3827',1997.04,0.00,0.00,3.14,75.36,'2022-04-26 14:20:29','',''),(3754,'1','219','1',1,'Retail Sale Id 3828',3822.36,0.00,0.00,6.01,144.24,'2022-04-26 14:30:19','',''),(3755,'1','219','1',1,'Retail Sale Id 3830',6360.00,0.00,0.00,10.00,240.00,'2022-04-26 15:04:11','',''),(3756,'1','219','1',1,'Retail Sale Id 3832',7950.00,0.00,0.00,12.50,300.00,'2022-04-26 15:51:43','',''),(3757,'1','219','1',1,'Retail Sale Id 3835',1202.04,0.00,0.00,1.89,45.36,'2022-04-26 15:52:54','',''),(3758,'1','219','1',1,'Retail Sale Id 3836',1297.44,0.00,0.00,2.04,48.96,'2022-04-26 15:54:57','',''),(3759,'1','219','1',1,'Retail Sale Id 3837',998.52,0.00,0.00,1.57,37.68,'2022-04-26 15:59:40','',''),(3760,'1','219','1',1,'Retail Sale Id 3838',37202.26,0.00,0.00,60.59,121.18,'2022-04-26 16:17:06','',''),(3761,'1','219','1',1,'Retail Sale Id 3839',1500.96,0.00,0.00,2.36,56.64,'2022-04-26 16:18:22','',''),(3762,'1','219','1',1,'Retail Sale Id 3840',1997.04,0.00,0.00,3.14,75.36,'2022-04-26 16:19:55','',''),(3763,'1','219','1',1,'Retail Sale Id 3841',960.36,0.00,0.00,1.51,36.24,'2022-04-26 16:24:54','',''),(3764,'1','219','1',1,'Retail Sale Id 3842',1997.04,0.00,0.00,3.14,75.36,'2022-04-26 16:37:36','',''),(3765,'1','219','1',1,'Retail Sale Id 3843',7950.00,0.00,0.00,12.50,300.00,'2022-04-26 16:47:16','',''),(3766,'1','219','1',1,'Retail Sale Id 3844',1997.04,0.00,0.00,3.14,75.36,'2022-04-26 16:48:17','',''),(3767,'1','219','1',1,'Retail Sale Id 3845',298.92,0.00,0.00,0.47,11.28,'2022-04-26 16:51:57','',''),(3768,'1','219','1',1,'Retail Sale Id 3847',699.60,0.00,0.00,1.10,26.40,'2022-04-26 17:05:27','',''),(3769,'1','219','1',1,'Retail Sale Id 3848',1297.44,0.00,0.00,2.04,48.96,'2022-04-26 17:21:13','',''),(3770,'1','219','1',1,'Retail Sale Id 3849',3180.00,0.00,0.00,5.00,120.00,'2022-04-26 17:23:31','',''),(3771,'1','219','1',1,'Retail Sale Id 3850',3822.36,0.00,0.00,6.01,144.24,'2022-04-26 17:33:26','',''),(3772,'1','219','1',1,'Retail Sale Id 3851',3498.00,0.00,0.00,5.50,132.00,'2022-04-26 17:39:58','',''),(3773,'1','219','1',1,'Retail Sale Id 3852',642.36,0.00,0.00,1.01,24.24,'2022-04-26 17:47:02','',''),(3774,'1','219','1',1,'Retail Sale Id 3852',3822.36,0.00,0.00,6.01,144.24,'2022-04-26 17:47:02','',''),(3775,'1','219','1',1,'Retail Sale Id 3853',502.44,0.00,0.00,0.79,18.96,'2022-04-26 17:48:36','',''),(3776,'1','219','1',1,'Retail Sale Id 3854',1997.04,0.00,0.00,3.14,75.36,'2022-04-26 17:51:29','',''),(3777,'1','219','1',1,'Retail Sale Id 3855',2499.48,0.00,0.00,3.93,94.32,'2022-04-26 17:53:03','',''),(3778,'1','219','1',1,'Retail Sale Id 3856',3822.36,0.00,0.00,6.01,144.24,'2022-04-26 18:08:13','',''),(3779,'1','219','1',1,'Retail Sale Id 3857',1997.04,0.00,0.00,3.14,75.36,'2022-04-26 18:14:35','',''),(3780,'1','219','1',1,'Retail Sale Id 3858',3001.92,0.00,0.00,4.72,113.28,'2022-04-26 18:15:57','',''),(3781,'1','219','1',1,'Retail Sale Id 3859',1500.96,0.00,0.00,2.36,56.64,'2022-04-26 18:20:39','',''),(3782,'1','219','1',1,'Retail Sale Id 3860',597.84,0.00,0.00,0.94,22.56,'2022-04-26 18:22:01','',''),(3783,'1','219','1',1,'Retail Sale Id 3861',998.52,0.00,0.00,1.57,37.68,'2022-04-26 18:23:52','',''),(3784,'1','219','1',1,'Retail Sale Id 3862',1202.04,0.00,0.00,1.89,45.36,'2022-04-26 18:25:33','',''),(3785,'1','219','1',1,'Retail Sale Id 3863',3001.92,0.00,0.00,4.72,113.28,'2022-04-26 18:39:54','',''),(3786,'1','219','1',1,'Retail Sale Id 3864',3199.08,0.00,0.00,5.03,120.72,'2022-04-27 08:23:15','',''),(3787,'1','219','1',1,'Retail Sale Id 3865',1997.04,0.00,0.00,3.14,75.36,'2022-04-27 08:27:48','',''),(3788,'1','219','1',1,'Retail Sale Id 3866',3001.92,0.00,0.00,4.72,113.28,'2022-04-27 08:53:04','',''),(3789,'1','219','1',1,'Retail Sale Id 3867',1908.00,0.00,0.00,3.00,72.00,'2022-04-27 09:01:28','',''),(3790,'1','219','1',1,'Retail Sale Id 3868',4000.44,0.00,0.00,6.29,150.96,'2022-04-27 09:42:48','',''),(3791,'1','219','1',1,'Retail Sale Id 3869',3199.08,0.00,0.00,5.03,120.72,'2022-04-27 10:03:17','',''),(3792,'1','219','1',1,'Retail Sale Id 3870',1997.04,0.00,0.00,3.14,75.36,'2022-04-27 10:15:57','',''),(3793,'1','219','1',1,'Retail Sale Id 3871',4000.44,0.00,0.00,6.29,150.96,'2022-04-27 10:43:15','',''),(3794,'1','219','1',1,'Retail Sale Id 3872',1997.04,0.00,0.00,3.14,75.36,'2022-04-27 10:45:15','',''),(3795,'1','219','1',1,'Retail Sale Id 3873',3816.00,0.00,0.00,6.00,144.00,'2022-04-27 10:53:42','',''),(3796,'1','219','1',1,'Retail Sale Id 3874',1908.00,0.00,0.00,3.00,72.00,'2022-04-27 10:58:30','',''),(3797,'1','219','1',1,'Retail Sale Id 3875',2499.48,0.00,0.00,3.93,94.32,'2022-04-27 11:26:34','',''),(3798,'1','219','1',1,'Retail Sale Id 3876',998.52,0.00,0.00,1.57,37.68,'2022-04-27 11:59:35','',''),(3799,'1','219','1',1,'Retail Sale Id 3877',1997.04,0.00,0.00,3.14,75.36,'2022-04-27 12:26:18','',''),(3800,'1','219','1',1,'Retail Sale Id 3879',3816.00,0.00,0.00,6.00,144.00,'2022-04-27 12:34:26','',''),(3801,'1','219','1',1,'Retail Sale Id 3880',3816.00,0.00,0.00,6.00,144.00,'2022-04-27 12:54:34','',''),(3802,'1','219','1',1,'Retail Sale Id 3881',3816.00,0.00,0.00,6.00,144.00,'2022-04-27 12:56:49','',''),(3803,'1','219','1',1,'Retail Sale Id 3882',3199.08,0.00,0.00,5.03,120.72,'2022-04-27 12:58:33','',''),(3804,'1','219','1',1,'Retail Sale Id 3883',1842.00,0.00,0.00,3.00,6.00,'2022-04-27 13:12:13','',''),(3805,'1','219','1',1,'Retail Sale Id 3884',1997.04,0.00,0.00,3.14,75.36,'2022-04-27 13:16:07','',''),(3806,'1','219','1',1,'Retail Sale Id 3885',2544.00,0.00,0.00,4.00,96.00,'2022-04-27 13:20:08','',''),(3807,'1','219','1',1,'Retail Sale Id 3886',4998.96,0.00,0.00,7.86,188.64,'2022-04-27 13:22:19','',''),(3808,'1','219','1',1,'Retail Sale Id 3887',7950.00,0.00,0.00,12.50,300.00,'2022-04-27 13:24:45','',''),(3809,'1','219','1',1,'Retail Sale Id 3888',648.72,0.00,0.00,1.02,24.48,'2022-04-27 13:33:46','',''),(3810,'1','219','1',1,'Retail Sale Id 3889',3199.08,0.00,0.00,5.03,120.72,'2022-04-27 13:38:24','',''),(3811,'1','219','1',1,'Retail Sale Id 3890',1908.00,0.00,0.00,3.00,72.00,'2022-04-27 13:54:21','',''),(3812,'1','219','1',1,'Retail Sale Id 3891',699.60,0.00,0.00,1.10,26.40,'2022-04-27 14:02:41','',''),(3813,'1','219','1',1,'Retail Sale Id 3892',4502.88,0.00,0.00,7.08,169.92,'2022-04-27 14:39:00','',''),(3814,'1','219','1',1,'Retail Sale Id 3893',14628.00,0.00,0.00,23.00,552.00,'2022-04-27 14:40:51','',''),(3815,'1','219','1',1,'Retail Sale Id 3894',3816.00,0.00,0.00,6.00,144.00,'2022-04-27 14:57:53','',''),(3816,'1','219','1',1,'Retail Sale Id 3895',3684.00,0.00,0.00,6.00,12.00,'2022-04-27 15:15:53','',''),(3817,'1','219','1',1,'Retail Sale Id 3896',3816.00,0.00,0.00,6.00,144.00,'2022-04-27 15:17:25','',''),(3818,'1','219','1',1,'Retail Sale Id 3897',3199.08,0.00,0.00,5.03,120.72,'2022-04-27 15:25:02','',''),(3819,'1','219','1',1,'Retail Sale Id 3898',3816.00,0.00,0.00,6.00,144.00,'2022-04-27 15:26:29','',''),(3820,'1','219','1',1,'Retail Sale Id 3899',3498.00,0.00,0.00,5.50,132.00,'2022-04-27 16:03:06','',''),(3821,'1','219','1',1,'Retail Sale Id 3900',2703.00,0.00,0.00,4.25,102.00,'2022-04-27 16:04:42','',''),(3822,'1','219','1',1,'Retail Sale Id 3901',1500.96,0.00,0.00,2.36,56.64,'2022-04-27 16:07:16','',''),(3823,'1','219','1',1,'Retail Sale Id 3902',1799.88,0.00,0.00,2.83,67.92,'2022-04-27 16:25:19','',''),(3824,'1','219','1',1,'Retail Sale Id 3903',1997.04,0.00,0.00,3.14,75.36,'2022-04-27 16:37:21','',''),(3825,'1','219','1',1,'Retail Sale Id 3904',7950.00,0.00,0.00,12.50,300.00,'2022-04-27 16:39:52','',''),(3826,'1','219','1',1,'Retail Sale Id 3905',3816.00,0.00,0.00,6.00,144.00,'2022-04-27 16:43:22','',''),(3827,'1','219','1',1,'Retail Sale Id 3906',502.44,0.00,0.00,0.79,18.96,'2022-04-27 16:52:12','',''),(3828,'1','219','1',1,'Retail Sale Id 3907',6360.00,0.00,0.00,10.00,240.00,'2022-04-27 17:00:44','',''),(3829,'1','219','1',1,'Retail Sale Id 3908',1997.04,0.00,0.00,3.14,75.36,'2022-04-27 17:03:50','',''),(3830,'1','219','1',1,'Retail Sale Id 3909',648.72,0.00,0.00,1.02,24.48,'2022-04-27 17:27:51','',''),(3831,'1','219','1',1,'Retail Sale Id 3910',5100.72,0.00,0.00,8.02,192.48,'2022-04-27 18:01:32','',''),(3832,'1','219','1',1,'Retail Sale Id 3911',2499.48,0.00,0.00,3.93,94.32,'2022-04-27 18:02:31','',''),(3833,'1','219','1',1,'Retail Sale Id 3912',502.44,0.00,0.00,0.79,18.96,'2022-04-27 18:04:56','',''),(3834,'1','219','1',1,'Retail Sale Id 3913',502.44,0.00,0.00,0.79,18.96,'2022-04-27 18:09:58','',''),(3835,'1','219','1',1,'Retail Sale Id 3914',998.52,0.00,0.00,1.57,37.68,'2022-04-27 18:11:00','',''),(3836,'1','219','1',1,'Retail Sale Id 3915',502.44,0.00,0.00,0.79,18.96,'2022-04-27 18:25:49','',''),(3837,'1','219','1',1,'Retail Sale Id 3916',1997.04,0.00,0.00,3.14,75.36,'2022-04-27 18:31:47','',''),(3838,'1','219','1',1,'Return of Retail Sale Id 3914',0.00,998.52,1.57,0.00,-37.68,'2022-04-27 22:57:09','',''),(3839,'1','219','1',1,'Retail Sale Id 3917',890.40,0.00,0.00,1.40,33.60,'2022-04-27 22:59:02','',''),(3840,'1','219','1',1,'Retail Sale Id 3918',7675.00,0.00,0.00,12.50,25.00,'2022-04-28 07:30:24','',''),(3841,'1','219','1',1,'Retail Sale Id 3919',1997.04,0.00,0.00,3.14,75.36,'2022-04-28 07:32:08','',''),(3842,'1','219','1',1,'Retail Sale Id 3920',3822.36,0.00,0.00,6.01,144.24,'2022-04-28 08:01:09','',''),(3843,'1','219','1',1,'Retail Sale Id 3921',648.72,0.00,0.00,1.02,24.48,'2022-04-28 08:18:05','',''),(3844,'1','219','1',1,'Retail Sale Id 3922',3822.36,0.00,0.00,6.01,144.24,'2022-04-28 08:59:27','',''),(3845,'1','219','1',1,'Retail Sale Id 3923',6360.00,0.00,0.00,10.00,240.00,'2022-04-28 09:08:52','',''),(3846,'1','219','1',1,'Retail Sale Id 3924',3822.36,0.00,0.00,6.01,144.24,'2022-04-28 09:25:36','',''),(3847,'1','219','1',1,'Retail Sale Id 3924',3822.36,0.00,0.00,6.01,144.24,'2022-04-28 09:25:36','',''),(3848,'1','219','1',1,'Retail Sale Id 3927',3822.36,0.00,0.00,6.01,144.24,'2022-04-28 09:28:24','',''),(3849,'1','219','1',1,'Retail Sale Id 3928',3822.36,0.00,0.00,6.01,144.24,'2022-04-28 09:52:41','',''),(3850,'1','219','1',1,'Retail Sale Id 3929',3822.36,0.00,0.00,6.01,144.24,'2022-04-28 09:53:49','',''),(3851,'1','219','1',1,'Retail Sale Id 3929',6360.00,0.00,0.00,10.00,240.00,'2022-04-28 09:53:49','',''),(3852,'1','219','1',1,'Retail Sale Id 3930',6360.00,0.00,0.00,10.00,240.00,'2022-04-28 09:55:59','',''),(3853,'1','219','1',1,'Retail Sale Id 3931',3180.00,0.00,0.00,5.00,120.00,'2022-04-28 09:59:28','',''),(3854,'1','219','1',1,'Retail Sale Id 3932',1927.08,0.00,0.00,3.03,72.72,'2022-04-28 10:24:31','',''),(3855,'1','219','1',1,'Retail Sale Id 3933',502.44,0.00,0.00,0.79,18.96,'2022-04-28 14:38:33','',''),(3856,'1','219','1',1,'Retail Sale Id 3934',3822.36,0.00,0.00,6.01,144.24,'2022-04-28 14:39:55','',''),(3857,'1','219','1',1,'Retail Sale Id 3935',1997.04,0.00,0.00,3.14,75.36,'2022-04-28 14:40:54','',''),(3858,'1','219','1',1,'Retail Sale Id 3936',3822.36,0.00,0.00,6.01,144.24,'2022-04-28 14:41:57','',''),(3859,'1','219','1',1,'Retail Sale Id 3937',1399.20,0.00,0.00,2.20,52.80,'2022-04-28 14:43:03','',''),(3860,'1','219','1',1,'Retail Sale Id 3938',1908.00,0.00,0.00,3.00,72.00,'2022-04-28 14:45:06','',''),(3861,'1','219','1',1,'Retail Sale Id 3940',4502.88,0.00,0.00,7.08,169.92,'2022-04-28 14:47:20','',''),(3862,'1','219','1',1,'Distributed to OPERATIONAL LOST for sales id:6',167755.32,0.00,0.00,274.11,0.00,'2022-04-28 14:56:25','',''),(3863,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,3551198.00,5899.00,0.00,0.00,'2022-04-28 15:03:37','',''),(3864,'1','219',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,5899.00,0.00,'2022-04-28 15:05:05','',''),(3865,'1','219','1',1,'Received from bridging 10',0.00,0.00,5899.00,0.00,0.00,'2022-04-28 15:05:05','',''),(3866,'1','219','1',1,'Retail Sale Id 3941',7950.00,0.00,0.00,12.50,425.00,'2022-04-28 15:07:17','',''),(3867,'1','219','1',1,'Retail Sale Id 3941',7950.00,0.00,0.00,12.50,425.00,'2022-04-28 15:07:17','',''),(3868,'1','219','1',1,'Retail Sale Id 3943',998.52,0.00,0.00,1.57,53.38,'2022-04-28 15:15:38','',''),(3869,'1','219','1',1,'Retail Sale Id 3944',7950.00,0.00,0.00,12.50,425.00,'2022-04-28 15:18:42','',''),(3870,'1','219','1',1,'Retail Sale Id 3945',998.52,0.00,0.00,1.57,53.38,'2022-04-28 15:19:37','',''),(3871,'1','219','1',1,'Retail Sale Id 3946',197.16,0.00,0.00,0.31,10.54,'2022-04-28 15:23:05','',''),(3872,'1','219','1',1,'Retail Sale Id 3947',1500.96,0.00,0.00,2.36,80.24,'2022-04-28 15:30:35','',''),(3873,'1','219','1',1,'Retail Sale Id 3948',1297.44,0.00,0.00,2.04,69.36,'2022-04-28 15:31:56','',''),(3874,'1','219','1',1,'Retail Sale Id 3949',3180.00,0.00,0.00,5.00,170.00,'2022-04-28 15:35:16','',''),(3875,'1','219','1',1,'Retail Sale Id 3950',1908.00,0.00,0.00,3.00,102.00,'2022-04-28 15:39:21','',''),(3876,'1','219','1',1,'Retail Sale Id 3951',6360.00,0.00,0.00,10.00,340.00,'2022-04-28 15:42:05','',''),(3877,'1','219','1',1,'Retail Sale Id 3951',7950.00,0.00,0.00,12.50,425.00,'2022-04-28 15:42:05','',''),(3878,'1','219','1',1,'Retail Sale Id 3952',3001.92,0.00,0.00,4.72,160.48,'2022-04-28 15:50:21','',''),(3879,'1','219','1',1,'Retail Sale Id 3953',1500.96,0.00,0.00,2.36,80.24,'2022-04-28 16:41:22','',''),(3880,'1','219','1',1,'Retail Sale Id 3954',2410.44,0.00,0.00,3.79,128.86,'2022-04-28 16:42:50','',''),(3881,'1','219','1',1,'Retail Sale Id 3955',998.52,0.00,0.00,1.57,53.38,'2022-04-28 16:46:16','',''),(3882,'1','219','1',1,'Retail Sale Id 3956',2499.48,0.00,0.00,3.93,133.62,'2022-04-28 16:53:59','',''),(3883,'1','219','1',1,'Retail Sale Id 3958',1997.04,0.00,0.00,3.14,106.76,'2022-04-28 17:00:26','',''),(3884,'1','219','1',1,'Retail Sale Id 3959',1997.04,0.00,0.00,3.14,106.76,'2022-04-28 17:21:31','',''),(3885,'1','219','1',1,'Retail Sale Id 3960',7675.00,0.00,0.00,12.50,150.00,'2022-04-28 17:23:12','',''),(3886,'1','219','1',1,'Retail Sale Id 3961',0.00,0.00,0.00,0.00,0.00,'2022-04-28 17:24:08','',''),(3887,'1','219','1',1,'Retail Sale Id 3962',1500.96,0.00,0.00,2.36,80.24,'2022-04-28 17:25:53','',''),(3888,'1','219','1',1,'Retail Sale Id 3963',1997.04,0.00,0.00,3.14,106.76,'2022-04-28 17:26:57','',''),(3889,'1','219','1',1,'Retail Sale Id 3964',3822.36,0.00,0.00,6.01,204.34,'2022-04-28 17:28:07','',''),(3890,'1','219','1',1,'Retail Sale Id 3965',1997.04,0.00,0.00,3.14,106.76,'2022-04-28 17:29:20','',''),(3891,'1','219','1',1,'Retail Sale Id 3966',998.52,0.00,0.00,1.57,53.38,'2022-04-28 17:30:22','',''),(3892,'1','219','1',1,'Retail Sale Id 3967',1908.00,0.00,0.00,3.00,102.00,'2022-04-28 17:31:15','',''),(3893,'1','219','1',1,'Retail Sale Id 3968',1799.88,0.00,0.00,2.83,96.22,'2022-04-28 17:42:35','',''),(3894,'1','219','1',1,'Retail Sale Id 3969',3822.36,0.00,0.00,6.01,204.34,'2022-04-28 17:56:31','',''),(3895,'1','219','1',1,'Retail Sale Id 3970',1278.36,0.00,0.00,2.01,68.34,'2022-04-28 17:59:06','',''),(3896,'1','219','1',1,'Retail Sale Id 3971',1500.96,0.00,0.00,2.36,80.24,'2022-04-28 18:01:50','',''),(3897,'1','219','1',1,'Retail Sale Id 3972',1399.20,0.00,0.00,2.20,74.80,'2022-04-28 18:03:36','',''),(3898,'1','219','1',1,'Retail Sale Id 3973',502.44,0.00,0.00,0.79,26.86,'2022-04-28 18:25:36','',''),(3899,'1','219','1',1,'Retail Sale Id 3974',1500.96,0.00,0.00,2.36,80.24,'2022-04-28 18:26:26','',''),(3900,'1','219','1',1,'Retail Sale Id 3975',6360.00,0.00,0.00,10.00,340.00,'2022-04-29 09:04:27','',''),(3901,'1','219','1',1,'Retail Sale Id 3976',1997.04,0.00,0.00,3.14,106.76,'2022-04-29 09:09:23','',''),(3902,'1','219','1',1,'Retail Sale Id 3978',3847.80,0.00,0.00,6.05,205.70,'2022-04-29 09:15:40','',''),(3903,'1','219','1',1,'Retail Sale Id 3979',3199.08,0.00,0.00,5.03,171.02,'2022-04-29 09:37:00','',''),(3904,'1','219','1',1,'Retail Sale Id 3980',998.52,0.00,0.00,1.57,53.38,'2022-04-29 09:48:52','',''),(3905,'1','219','1',1,'Retail Sale Id 3981',1500.96,0.00,0.00,2.36,80.24,'2022-04-29 09:55:08','',''),(3906,'1','219','1',1,'Retail Sale Id 3982',7675.00,0.00,0.00,12.50,150.00,'2022-04-29 10:22:56','',''),(3907,'1','219','1',1,'Retail Sale Id 3983',30700.00,0.00,0.00,50.00,600.00,'2022-04-29 10:34:49','',''),(3908,'1','219','1',1,'Retail Sale Id 3984',3816.00,0.00,0.00,6.00,204.00,'2022-04-29 10:57:07','',''),(3909,'1','219','1',1,'Retail Sale Id 3985',9540.00,0.00,0.00,15.00,510.00,'2022-04-29 12:15:45','',''),(3910,'1','219','1',1,'Retail Sale Id 3986',2550.36,0.00,0.00,4.01,136.34,'2022-04-29 12:25:06','',''),(3911,'1','219','1',1,'Retail Sale Id 3988',3199.08,0.00,0.00,5.03,171.02,'2022-04-29 12:41:45','',''),(3912,'1','219','1',1,'Retail Sale Id 3989',1908.00,0.00,0.00,3.00,102.00,'2022-04-29 13:27:20','',''),(3913,'1','219','1',1,'Retail Sale Id 3990',3001.92,0.00,0.00,4.72,160.48,'2022-04-29 13:46:47','',''),(3914,'1','219','1',1,'Retail Sale Id 3991',7950.00,0.00,0.00,12.50,425.00,'2022-04-29 14:08:59','',''),(3915,'1','219','1',1,'Retail Sale Id 3992',1997.04,0.00,0.00,3.14,106.76,'2022-04-29 14:35:01','',''),(3916,'1','219','1',1,'Retail Sale Id 3993',3816.00,0.00,0.00,6.00,204.00,'2022-04-29 14:51:16','',''),(3917,'1','219','1',1,'Retail Sale Id 3994',7632.00,0.00,0.00,12.00,408.00,'2022-04-29 14:52:57','',''),(3918,'1','219','1',1,'Retail Sale Id 3996',1997.04,0.00,0.00,3.14,106.76,'2022-04-29 14:55:44','',''),(3919,'1','219','1',1,'Retail Sale Id 3997',502.44,0.00,0.00,0.79,26.86,'2022-04-29 15:02:20','',''),(3920,'1','219','1',1,'Retail Sale Id 3998',3816.00,0.00,0.00,6.00,204.00,'2022-04-29 15:07:15','',''),(3921,'1','219','1',1,'Retail Sale Id 3999',1272.00,0.00,0.00,2.00,68.00,'2022-04-29 15:12:52','',''),(3922,'1','219','1',1,'Retail Sale Id 4000',1997.04,0.00,0.00,3.14,106.76,'2022-04-29 15:13:48','',''),(3923,'1','219','1',1,'Retail Sale Id 4001',7002.36,0.00,0.00,11.01,374.34,'2022-04-29 15:19:17','',''),(3924,'1','219','1',1,'Retail Sale Id 4002',648.72,0.00,0.00,1.02,34.68,'2022-04-29 15:23:30','',''),(3925,'1','219','1',1,'Retail Sale Id 4003',3816.00,0.00,0.00,6.00,204.00,'2022-04-29 15:33:24','',''),(3926,'1','219','1',1,'Retail Sale Id 4004',3816.00,0.00,0.00,6.00,204.00,'2022-04-29 15:42:49','',''),(3927,'1','219','1',1,'Retail Sale Id 4005',1997.04,0.00,0.00,3.14,106.76,'2022-04-29 15:45:46','',''),(3928,'1','219','1',1,'Retail Sale Id 4006',6302.76,0.00,0.00,9.91,336.94,'2022-04-29 15:50:00','',''),(3929,'1','219','1',1,'Retail Sale Id 4007',998.52,0.00,0.00,1.57,53.38,'2022-04-29 16:01:51','',''),(3930,'1','219','1',1,'Retail Sale Id 4008',3199.08,0.00,0.00,5.03,171.02,'2022-04-29 16:05:23','',''),(3931,'1','219','1',1,'Retail Sale Id 4009',3816.00,0.00,0.00,6.00,204.00,'2022-04-29 16:29:39','',''),(3932,'1','219','1',1,'Retail Sale Id 4011',3816.00,0.00,0.00,6.00,204.00,'2022-04-29 16:34:48','',''),(3933,'1','219','1',1,'Retail Sale Id 4012',1500.96,0.00,0.00,2.36,80.24,'2022-04-29 16:36:39','',''),(3934,'1','219','1',1,'Retail Sale Id 4013',3001.92,0.00,0.00,4.72,160.48,'2022-04-29 16:55:31','',''),(3935,'1','219','1',1,'Retail Sale Id 4014',4000.44,0.00,0.00,6.29,213.86,'2022-04-29 17:01:47','',''),(3936,'1','219','1',1,'Retail Sale Id 4015',2499.48,0.00,0.00,3.93,133.62,'2022-04-29 17:11:53','',''),(3937,'1','219','1',1,'Retail Sale Id 4016',1297.44,0.00,0.00,2.04,69.36,'2022-04-29 17:19:52','',''),(3938,'1','219','1',1,'Retail Sale Id 4017',3816.00,0.00,0.00,6.00,204.00,'2022-04-29 17:22:24','',''),(3939,'1','219','1',1,'Retail Sale Id 4018',3816.00,0.00,0.00,6.00,204.00,'2022-04-29 17:24:51','',''),(3940,'1','219','1',1,'Retail Sale Id 4019',998.52,0.00,0.00,1.57,53.38,'2022-04-29 18:02:47','',''),(3941,'1','219','1',1,'Retail Sale Id 4020',4000.44,0.00,0.00,6.29,213.86,'2022-04-29 18:04:02','',''),(3942,'1','219','1',1,'Retail Sale Id 4021',1049.40,0.00,0.00,1.65,56.10,'2022-04-29 18:10:28','',''),(3943,'1','219','1',1,'Retail Sale Id 4022',1500.96,0.00,0.00,2.36,80.24,'2022-04-29 18:16:36','',''),(3944,'1','219','1',1,'Retail Sale Id 4023',998.52,0.00,0.00,1.57,53.38,'2022-04-29 18:26:33','',''),(3945,'1','219','1',1,'Retail Sale Id 4024',502.44,0.00,0.00,0.79,26.86,'2022-04-29 18:29:32','',''),(3946,'1','219','1',1,'Retail Sale Id 4025',1997.04,0.00,0.00,3.14,106.76,'2022-04-29 18:34:19','',''),(3947,'1','219','1',1,'Retail Sale Id 4027',648.72,0.00,0.00,1.02,34.68,'2022-04-29 18:36:54','',''),(3948,'1','219','1',1,'Return of Retail Sale Id 4018',0.00,3816.00,6.00,0.00,-204.00,'2022-04-30 00:22:45','',''),(3949,'1','219','1',1,'Return of Retail Sale Id 4025',0.00,1997.04,3.14,0.00,-106.76,'2022-04-30 00:23:23','',''),(3950,'1','219','1',1,'Return of Retail Sale Id 4022',0.00,1500.96,2.36,0.00,-80.24,'2022-04-30 00:24:10','',''),(3951,'1','219','1',1,'Return of Retail Sale Id 4020',0.00,4000.44,6.29,0.00,-213.86,'2022-04-30 00:24:54','',''),(3952,'1','219','1',1,'Return of Retail Sale Id 4014',0.00,4000.44,6.29,0.00,-213.86,'2022-04-30 00:25:26','',''),(3953,'1','219','1',1,'Return of Retail Sale Id 4017',0.00,3816.00,6.00,0.00,-204.00,'2022-04-30 00:26:18','',''),(3954,'1','219','1',1,'Retail Sale Id 4028',16758.60,0.00,0.00,26.35,895.90,'2022-04-30 00:27:30','',''),(3955,'1','219','1',1,'Retail Sale Id 4029',413.40,0.00,0.00,0.65,22.10,'2022-04-30 00:29:34','',''),(3956,'1','219','1',1,'Retail Sale Id 4030',1272.00,0.00,0.00,2.00,68.00,'2022-04-30 00:31:31','',''),(3957,'1','219','1',1,'Retail Sale Id 4031',4998.96,0.00,0.00,7.86,267.24,'2022-04-30 10:07:39','',''),(3958,'1','219','1',1,'Retail Sale Id 4032',1908.00,0.00,0.00,3.00,102.00,'2022-04-30 10:09:58','',''),(3959,'1','219','1',1,'Retail Sale Id 4032',3822.36,0.00,0.00,6.01,204.34,'2022-04-30 10:09:58','',''),(3960,'1','219','1',1,'Retail Sale Id 4032',3822.36,0.00,0.00,6.01,204.34,'2022-04-30 10:09:58','',''),(3961,'1','219','1',1,'Retail Sale Id 4033',6360.00,0.00,0.00,10.00,340.00,'2022-04-30 10:12:39','',''),(3962,'1','219','1',1,'Retail Sale Id 4034',7950.00,0.00,0.00,12.50,425.00,'2022-04-30 10:14:56','',''),(3963,'1','219','1',1,'Retail Sale Id 4035',4502.88,0.00,0.00,7.08,240.72,'2022-04-30 10:16:12','',''),(3964,'1','219','1',1,'Retail Sale Id 4036',699.60,0.00,0.00,1.10,37.40,'2022-04-30 10:17:45','',''),(3965,'1','219','1',1,'Retail Sale Id 4037',6678.00,0.00,0.00,10.50,357.00,'2022-04-30 10:18:50','',''),(3966,'1','219','1',1,'Retail Sale Id 4038',1901.64,0.00,0.00,2.99,101.66,'2022-04-30 10:20:07','',''),(3967,'1','219','1',1,'Retail Sale Id 4039',1500.96,0.00,0.00,2.36,80.24,'2022-04-30 10:26:54','',''),(3968,'1','219','1',1,'Retail Sale Id 4040',3822.36,0.00,0.00,6.01,204.34,'2022-04-30 10:29:30','',''),(3969,'1','219','1',1,'Retail Sale Id 4041',6140.00,0.00,0.00,10.00,120.00,'2022-04-30 10:32:43','',''),(3970,'1','219','1',1,'Retail Sale Id 4043',0.00,0.00,0.00,0.00,0.00,'2022-04-30 10:34:12','',''),(3971,'1','219','1',1,'Retail Sale Id 4044',3822.36,0.00,0.00,6.01,204.34,'2022-04-30 10:43:33','',''),(3972,'1','219','1',1,'Retail Sale Id 4045',1297.44,0.00,0.00,2.04,69.36,'2022-04-30 10:44:52','',''),(3973,'1','219','1',1,'Retail Sale Id 4046',30700.00,0.00,0.00,50.00,600.00,'2022-04-30 10:46:20','',''),(3974,'1','219','1',1,'Retail Sale Id 4048',37454.00,0.00,0.00,61.00,732.00,'2022-04-30 10:48:45','',''),(3975,'1','219','1',1,'Retail Sale Id 4049',4998.96,0.00,0.00,7.86,267.24,'2022-04-30 10:54:53','',''),(3976,'1','219','1',1,'Retail Sale Id 4050',3690.14,0.00,0.00,6.01,72.12,'2022-04-30 10:57:44','',''),(3977,'1','219','1',1,'Retail Sale Id 4051',636.00,0.00,0.00,1.00,34.00,'2022-04-30 10:59:51','',''),(3978,'1','219','1',1,'Retail Sale Id 4052',3180.00,0.00,0.00,5.00,170.00,'2022-04-30 11:03:12','',''),(3979,'1','219','1',1,'Retail Sale Id 4053',1908.00,0.00,0.00,3.00,102.00,'2022-04-30 11:05:07','',''),(3980,'1','219','1',1,'Retail Sale Id 4054',502.44,0.00,0.00,0.79,26.86,'2022-04-30 11:11:27','',''),(3981,'1','219','1',1,'Retail Sale Id 4055',30700.00,0.00,0.00,50.00,600.00,'2022-04-30 11:13:34','',''),(3982,'1','219','1',1,'Retail Sale Id 4056',3180.00,0.00,0.00,5.00,170.00,'2022-04-30 11:16:19','',''),(3983,'1','219','1',1,'Retail Sale Id 4058',1908.00,0.00,0.00,3.00,102.00,'2022-04-30 11:18:12','',''),(3984,'1','219','1',1,'Retail Sale Id 4059',3001.92,0.00,0.00,4.72,160.48,'2022-04-30 11:31:57','',''),(3985,'1','219','1',1,'Retail Sale Id 4060',2544.00,0.00,0.00,4.00,136.00,'2022-04-30 11:35:18','',''),(3986,'1','219','1',1,'Retail Sale Id 4061',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 11:45:45','',''),(3987,'1','219','1',1,'Retail Sale Id 4062',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 11:53:45','',''),(3988,'1','219','1',1,'Retail Sale Id 4063',2544.00,0.00,0.00,4.00,136.00,'2022-04-30 12:10:03','',''),(3989,'1','219','1',1,'Retail Sale Id 4064',3816.00,0.00,0.00,6.00,204.00,'2022-04-30 12:14:28','',''),(3990,'1','219','1',1,'Retail Sale Id 4065',3180.00,0.00,0.00,5.00,170.00,'2022-04-30 12:17:43','',''),(3991,'1','219','1',1,'Retail Sale Id 4066',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 12:27:16','',''),(3992,'1','219','1',1,'Retail Sale Id 4067',6398.16,0.00,0.00,10.06,342.04,'2022-04-30 12:29:00','',''),(3993,'1','219','1',1,'Retail Sale Id 4068',998.52,0.00,0.00,1.57,53.38,'2022-04-30 12:31:03','',''),(3994,'1','219','1',1,'Retail Sale Id 4068',998.52,0.00,0.00,1.57,53.38,'2022-04-30 12:31:03','',''),(3995,'1','219','1',1,'Retail Sale Id 4069',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 12:36:17','',''),(3996,'1','219','1',1,'Retail Sale Id 4070',6360.00,0.00,0.00,10.00,340.00,'2022-04-30 13:07:43','',''),(3997,'1','219','1',1,'Retail Sale Id 4071',6360.00,0.00,0.00,10.00,340.00,'2022-04-30 13:15:52','',''),(3998,'1','219','1',1,'Retail Sale Id 4072',7950.00,0.00,0.00,12.50,425.00,'2022-04-30 13:25:21','',''),(3999,'1','219','1',1,'Retail Sale Id 4073',7950.00,0.00,0.00,12.50,425.00,'2022-04-30 13:32:01','',''),(4000,'1','219','1',1,'Retail Sale Id 4074',1297.44,0.00,0.00,2.04,69.36,'2022-04-30 13:57:42','',''),(4001,'1','219','1',1,'Retail Sale Id 4075',3001.92,0.00,0.00,4.72,160.48,'2022-04-30 14:02:50','',''),(4002,'1','219','1',1,'Retail Sale Id 4076',6360.00,0.00,0.00,10.00,340.00,'2022-04-30 14:05:07','',''),(4003,'1','219','1',1,'Retail Sale Id 4077',7950.00,0.00,0.00,12.50,425.00,'2022-04-30 14:14:04','',''),(4004,'1','219','1',1,'Retail Sale Id 4078',3816.00,0.00,0.00,6.00,204.00,'2022-04-30 14:19:25','',''),(4005,'1','219','1',1,'Retail Sale Id 4079',3816.00,0.00,0.00,6.00,204.00,'2022-04-30 14:24:55','',''),(4006,'1','219','1',1,'Retail Sale Id 4080',3816.00,0.00,0.00,6.00,204.00,'2022-04-30 14:40:44','',''),(4007,'1','219','1',1,'Retail Sale Id 4081',998.52,0.00,0.00,1.57,53.38,'2022-04-30 14:42:39','',''),(4008,'1','219','1',1,'Retail Sale Id 4082',3816.00,0.00,0.00,6.00,204.00,'2022-04-30 14:48:05','',''),(4009,'1','219','1',1,'Retail Sale Id 4083',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 14:55:37','',''),(4010,'1','219','1',1,'Retail Sale Id 4084',3816.00,0.00,0.00,6.00,204.00,'2022-04-30 15:01:15','',''),(4011,'1','219','1',1,'Retail Sale Id 4085',3816.00,0.00,0.00,6.00,204.00,'2022-04-30 15:10:14','',''),(4012,'1','219','1',1,'Retail Sale Id 4086',3498.00,0.00,0.00,5.50,187.00,'2022-04-30 15:17:06','',''),(4013,'1','219','1',1,'Retail Sale Id 4087',998.52,0.00,0.00,1.57,53.38,'2022-04-30 15:19:10','',''),(4014,'1','219','1',1,'Retail Sale Id 4088',502.44,0.00,0.00,0.79,26.86,'2022-04-30 15:20:44','',''),(4015,'1','219','1',1,'Retail Sale Id 4089',1297.44,0.00,0.00,2.04,69.36,'2022-04-30 15:22:48','',''),(4016,'1','219','1',1,'Retail Sale Id 4090',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 15:25:10','',''),(4017,'1','219','1',1,'Retail Sale Id 4091',642.36,0.00,0.00,1.01,34.34,'2022-04-30 15:29:05','',''),(4018,'1','219','1',1,'Retail Sale Id 4092',7950.00,0.00,0.00,12.50,425.00,'2022-04-30 15:29:54','',''),(4019,'1','219','1',1,'Retail Sale Id 4093',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 15:43:23','',''),(4020,'1','219','1',1,'Retail Sale Id 4094',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 15:52:50','',''),(4021,'1','219','1',1,'Retail Sale Id 4096',4000.44,0.00,0.00,6.29,213.86,'2022-04-30 15:59:12','',''),(4022,'1','219','1',1,'Retail Sale Id 4097',3822.36,0.00,0.00,6.01,204.34,'2022-04-30 16:00:48','',''),(4023,'1','219','1',1,'Retail Sale Id 4098',1908.00,0.00,0.00,3.00,102.00,'2022-04-30 16:04:46','',''),(4024,'1','219','1',1,'Retail Sale Id 4099',998.52,0.00,0.00,1.57,53.38,'2022-04-30 16:13:25','',''),(4025,'1','219','1',1,'Retail Sale Id 4100',4998.96,0.00,0.00,7.86,267.24,'2022-04-30 16:24:26','',''),(4026,'1','219','1',1,'Retail Sale Id 4101',1500.96,0.00,0.00,2.36,80.24,'2022-04-30 16:25:51','',''),(4027,'1','219','1',1,'Retail Sale Id 4102',3822.36,0.00,0.00,6.01,204.34,'2022-04-30 16:26:59','',''),(4028,'1','219','1',1,'Retail Sale Id 4103',3822.36,0.00,0.00,6.01,204.34,'2022-04-30 16:35:52','',''),(4029,'1','219','1',1,'Retail Sale Id 4104',1698.12,0.00,0.00,2.67,90.78,'2022-04-30 16:37:16','',''),(4030,'1','219','1',1,'Retail Sale Id 4105',3001.92,0.00,0.00,4.72,160.48,'2022-04-30 16:41:18','',''),(4031,'1','219','1',1,'Retail Sale Id 4106',998.52,0.00,0.00,1.57,53.38,'2022-04-30 16:46:26','',''),(4032,'1','219','1',1,'Retail Sale Id 4107',3816.00,0.00,0.00,6.00,204.00,'2022-04-30 16:52:03','',''),(4033,'1','219','1',1,'Retail Sale Id 4108',636.00,0.00,0.00,1.00,34.00,'2022-04-30 16:54:42','',''),(4034,'1','219','1',1,'Retail Sale Id 4109',3199.08,0.00,0.00,5.03,171.02,'2022-04-30 16:58:12','',''),(4035,'1','219','1',1,'Retail Sale Id 4110',2544.00,0.00,0.00,4.00,136.00,'2022-04-30 17:05:20','',''),(4036,'1','219','1',1,'Retail Sale Id 4111',699.60,0.00,0.00,1.10,37.40,'2022-04-30 17:07:13','',''),(4037,'1','219','1',1,'Retail Sale Id 4112',7950.00,0.00,0.00,12.50,425.00,'2022-04-30 17:08:52','',''),(4038,'1','219','1',1,'Retail Sale Id 4113',1908.00,0.00,0.00,3.00,102.00,'2022-04-30 17:18:39','',''),(4039,'1','219','1',1,'Retail Sale Id 4114',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 17:19:59','',''),(4040,'1','219','1',1,'Retail Sale Id 4115',3199.08,0.00,0.00,5.03,171.02,'2022-04-30 17:28:54','',''),(4041,'1','219','1',1,'Retail Sale Id 4116',3816.00,0.00,0.00,6.00,204.00,'2022-04-30 17:30:25','',''),(4042,'1','219','1',1,'Retail Sale Id 4117',4000.44,0.00,0.00,6.29,213.86,'2022-04-30 17:34:59','',''),(4043,'1','219','1',1,'Retail Sale Id 4118',1500.96,0.00,0.00,2.36,80.24,'2022-04-30 17:39:46','',''),(4044,'1','219','1',1,'Retail Sale Id 4119',1500.96,0.00,0.00,2.36,80.24,'2022-04-30 17:40:37','',''),(4045,'1','219','1',1,'Retail Sale Id 4120',1500.96,0.00,0.00,2.36,80.24,'2022-04-30 17:41:23','',''),(4046,'1','219','1',1,'Retail Sale Id 4121',642.36,0.00,0.00,1.01,34.34,'2022-04-30 17:42:59','',''),(4047,'1','219','1',1,'Retail Sale Id 4121',1297.44,0.00,0.00,2.04,69.36,'2022-04-30 17:42:59','',''),(4048,'1','219','1',1,'Retail Sale Id 4123',3822.36,0.00,0.00,6.01,204.34,'2022-04-30 17:47:41','',''),(4049,'1','219','1',1,'Retail Sale Id 4123',3822.36,0.00,0.00,6.01,204.34,'2022-04-30 17:47:41','',''),(4050,'1','219','1',1,'Retail Sale Id 4123',7950.00,0.00,0.00,12.50,425.00,'2022-04-30 17:47:41','',''),(4051,'1','219','1',1,'Retail Sale Id 4124',960.36,0.00,0.00,1.51,51.34,'2022-04-30 17:49:16','',''),(4052,'1','219','1',1,'Retail Sale Id 4125',298.92,0.00,0.00,0.47,15.98,'2022-04-30 17:51:09','',''),(4053,'1','219','1',1,'Retail Sale Id 4126',3180.00,0.00,0.00,5.00,170.00,'2022-04-30 17:55:45','',''),(4054,'1','219','1',1,'Retail Sale Id 4128',3816.00,0.00,0.00,6.00,204.00,'2022-04-30 17:56:50','',''),(4055,'1','219','1',1,'Retail Sale Id 4129',1500.96,0.00,0.00,2.36,80.24,'2022-04-30 18:00:33','',''),(4056,'1','219','1',1,'Retail Sale Id 4130',1297.44,0.00,0.00,2.04,69.36,'2022-04-30 18:02:11','',''),(4057,'1','219','1',1,'Retail Sale Id 4131',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 18:03:23','',''),(4058,'1','219','1',1,'Retail Sale Id 4132',699.60,0.00,0.00,1.10,37.40,'2022-04-30 18:16:30','',''),(4059,'1','219','1',1,'Retail Sale Id 4133',1500.96,0.00,0.00,2.36,80.24,'2022-04-30 18:24:42','',''),(4060,'1','219','1',1,'Retail Sale Id 4134',1202.04,0.00,0.00,1.89,64.26,'2022-04-30 18:26:32','',''),(4061,'1','219','1',1,'Retail Sale Id 4135',3180.00,0.00,0.00,5.00,170.00,'2022-04-30 18:35:07','',''),(4062,'1','219','1',1,'Retail Sale Id 4136',642.36,0.00,0.00,1.01,34.34,'2022-04-30 18:55:18','',''),(4063,'1','219','1',1,'Retail Sale Id 4137',1997.04,0.00,0.00,3.14,106.76,'2022-04-30 19:07:12','',''),(4064,'1','219','1',1,'Retail Sale Id 4138',998.52,0.00,0.00,1.57,53.38,'2022-05-01 08:25:09','',''),(4065,'1','219','1',1,'Retail Sale Id 4139',1297.44,0.00,0.00,2.04,69.36,'2022-05-01 08:27:00','',''),(4066,'1','219','1',1,'Retail Sale Id 4140',7950.00,0.00,0.00,12.50,425.00,'2022-05-01 08:33:24','',''),(4067,'1','219','1',1,'Retail Sale Id 4141',3816.00,0.00,0.00,6.00,204.00,'2022-05-01 09:12:53','',''),(4068,'1','219','1',1,'Retail Sale Id 4142',3822.36,0.00,0.00,6.01,204.34,'2022-05-01 09:17:51','',''),(4069,'1','219','1',1,'Retail Sale Id 4143',3822.36,0.00,0.00,6.01,204.34,'2022-05-01 09:30:28','',''),(4070,'1','219','1',1,'Retail Sale Id 4144',9540.00,0.00,0.00,15.00,510.00,'2022-05-01 09:36:22','',''),(4071,'1','219','1',1,'Retail Sale Id 4145',1297.44,0.00,0.00,2.04,69.36,'2022-05-01 09:52:42','',''),(4072,'1','219','1',1,'Retail Sale Id 4146',3001.92,0.00,0.00,4.72,160.48,'2022-05-01 09:59:21','',''),(4073,'1','219','1',1,'Retail Sale Id 4148',3796.92,0.00,0.00,5.97,202.98,'2022-05-01 10:02:12','',''),(4074,'1','219','1',1,'Retail Sale Id 4149',3684.00,0.00,0.00,6.00,72.00,'2022-05-01 10:06:36','',''),(4075,'1','219','1',1,'Retail Sale Id 4150',3816.00,0.00,0.00,6.00,204.00,'2022-05-01 10:17:31','',''),(4076,'1','219','1',1,'Retail Sale Id 4151',58330.00,0.00,0.00,95.00,1140.00,'2022-05-01 10:29:10','',''),(4077,'1','219','1',1,'Retail Sale Id 4153',3822.36,0.00,0.00,6.01,204.34,'2022-05-01 10:30:33','',''),(4078,'1','219','1',1,'Retail Sale Id 4154',3180.00,0.00,0.00,5.00,170.00,'2022-05-01 10:32:03','',''),(4079,'1','219','1',1,'Retail Sale Id 4155',1297.44,0.00,0.00,2.04,69.36,'2022-05-01 10:33:33','',''),(4080,'1','219','1',1,'Retail Sale Id 4156',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 10:39:36','',''),(4081,'1','219','1',1,'Retail Sale Id 4156',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 10:39:36','',''),(4082,'1','219','1',1,'Retail Sale Id 4157',3822.36,0.00,0.00,6.01,204.34,'2022-05-01 10:41:13','',''),(4083,'1','219','1',1,'Retail Sale Id 4158',3001.92,0.00,0.00,4.72,160.48,'2022-05-01 10:51:14','',''),(4084,'1','219','1',1,'Retail Sale Id 4159',6360.00,0.00,0.00,10.00,340.00,'2022-05-01 10:52:18','',''),(4085,'1','219','1',1,'Retail Sale Id 4160',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 10:55:06','',''),(4086,'1','219','1',1,'Retail Sale Id 4161',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 10:56:10','',''),(4087,'1','219','1',1,'Retail Sale Id 4162',3498.00,0.00,0.00,5.50,187.00,'2022-05-01 11:03:10','',''),(4088,'1','219','1',1,'Retail Sale Id 4163',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 11:09:23','',''),(4089,'1','219','1',1,'Retail Sale Id 4164',1500.96,0.00,0.00,2.36,80.24,'2022-05-01 11:17:06','',''),(4090,'1','219','1',1,'Retail Sale Id 4165',3180.00,0.00,0.00,5.00,170.00,'2022-05-01 11:21:45','',''),(4091,'1','219','1',1,'Retail Sale Id 4165',3822.36,0.00,0.00,6.01,204.34,'2022-05-01 11:21:45','',''),(4092,'1','219','1',1,'Retail Sale Id 4166',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 11:23:27','',''),(4093,'1','219','1',1,'Retail Sale Id 4167',1500.96,0.00,0.00,2.36,80.24,'2022-05-01 11:26:11','',''),(4094,'1','219','1',1,'Retail Sale Id 4168',1297.44,0.00,0.00,2.04,69.36,'2022-05-01 11:29:02','',''),(4095,'1','219','1',1,'Retail Sale Id 4169',138150.00,0.00,0.00,225.00,2700.00,'2022-05-01 11:34:31','',''),(4096,'1','219','1',1,'Retail Sale Id 4170',998.52,0.00,0.00,1.57,53.38,'2022-05-01 11:37:21','',''),(4097,'1','219','1',1,'Retail Sale Id 4171',3199.08,0.00,0.00,5.03,171.02,'2022-05-01 11:38:37','',''),(4098,'1','219','1',1,'Retail Sale Id 4172',1842.00,0.00,0.00,3.00,36.00,'2022-05-01 11:51:50','',''),(4099,'1','219','1',1,'Retail Sale Id 4173',7950.00,0.00,0.00,12.50,425.00,'2022-05-01 12:03:33','',''),(4100,'1','219','1',1,'Retail Sale Id 4174',1500.96,0.00,0.00,2.36,80.24,'2022-05-01 12:07:50','',''),(4101,'1','219','1',1,'Retail Sale Id 4175',1500.96,0.00,0.00,2.36,80.24,'2022-05-01 12:12:45','',''),(4102,'1','219','1',1,'Retail Sale Id 4176',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 12:16:33','',''),(4103,'1','219','1',1,'Retail Sale Id 4177',6360.00,0.00,0.00,10.00,340.00,'2022-05-01 12:17:52','',''),(4104,'1','219','1',1,'Retail Sale Id 4178',3199.08,0.00,0.00,5.03,171.02,'2022-05-01 12:24:20','',''),(4105,'1','219','1',1,'Retail Sale Id 4179',7950.00,0.00,0.00,12.50,425.00,'2022-05-01 12:25:28','',''),(4106,'1','219','1',1,'Retail Sale Id 4180',998.52,0.00,0.00,1.57,53.38,'2022-05-01 12:27:27','',''),(4107,'1','219','1',1,'Retail Sale Id 4181',6360.00,0.00,0.00,10.00,340.00,'2022-05-01 12:29:25','',''),(4108,'1','219','1',1,'Retail Sale Id 4182',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 12:30:55','',''),(4109,'1','219','1',1,'Retail Sale Id 4183',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 12:47:50','',''),(4110,'1','219','1',1,'Retail Sale Id 4184',7950.00,0.00,0.00,12.50,425.00,'2022-05-01 13:03:01','',''),(4111,'1','219','1',1,'Retail Sale Id 4185',998.52,0.00,0.00,1.57,53.38,'2022-05-01 13:09:11','',''),(4112,'1','219','1',1,'Retail Sale Id 4186',4912.00,0.00,0.00,8.00,96.00,'2022-05-01 13:13:20','',''),(4113,'1','219','1',1,'Retail Sale Id 4187',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 13:15:00','',''),(4114,'1','219','1',1,'Retail Sale Id 4188',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 13:40:45','',''),(4115,'1','219','1',1,'Retail Sale Id 4188',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 13:40:45','',''),(4116,'1','219','1',1,'Retail Sale Id 4190',3199.08,0.00,0.00,5.03,171.02,'2022-05-01 13:44:29','',''),(4117,'1','219','1',1,'Retail Sale Id 4191',1500.96,0.00,0.00,2.36,80.24,'2022-05-01 14:19:58','',''),(4118,'1','219','1',1,'Retail Sale Id 4192',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 14:25:17','',''),(4119,'1','219','1',1,'Retail Sale Id 4192',7950.00,0.00,0.00,12.50,425.00,'2022-05-01 14:25:17','',''),(4120,'1','219','1',1,'Retail Sale Id 4193',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 14:38:17','',''),(4121,'1','219','1',1,'Retail Sale Id 4193',3180.00,0.00,0.00,5.00,170.00,'2022-05-01 14:38:17','',''),(4122,'1','219','1',1,'Retail Sale Id 4194',3822.36,0.00,0.00,6.01,204.34,'2022-05-01 14:47:00','',''),(4123,'1','219','1',1,'Retail Sale Id 4195',4000.44,0.00,0.00,6.29,213.86,'2022-05-01 14:47:54','',''),(4124,'1','219','1',1,'Retail Sale Id 4196',801.36,0.00,0.00,1.26,42.84,'2022-05-01 15:01:18','',''),(4125,'1','219','1',1,'Retail Sale Id 4197',311.64,0.00,0.00,0.49,16.66,'2022-05-01 15:02:51','',''),(4126,'1','219','1',1,'Retail Sale Id 4198',1500.96,0.00,0.00,2.36,80.24,'2022-05-01 15:03:57','',''),(4127,'1','219','1',1,'Retail Sale Id 4199',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 15:19:27','',''),(4128,'1','219','1',1,'Retail Sale Id 4199',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 15:19:27','',''),(4129,'1','219','1',1,'Retail Sale Id 4200',3199.08,0.00,0.00,5.03,171.02,'2022-05-01 15:21:51','',''),(4130,'1','219','1',1,'Retail Sale Id 4201',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 15:23:58','',''),(4131,'1','219','1',1,'Retail Sale Id 4202',1500.96,0.00,0.00,2.36,80.24,'2022-05-01 15:30:53','',''),(4132,'1','219','1',1,'Retail Sale Id 4203',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 15:35:43','',''),(4133,'1','219','1',1,'Retail Sale Id 4204',3199.08,0.00,0.00,5.03,171.02,'2022-05-01 15:37:55','',''),(4134,'1','219','1',1,'Retail Sale Id 4206',3816.00,0.00,0.00,6.00,204.00,'2022-05-01 15:39:10','',''),(4135,'1','219','1',1,'Retail Sale Id 4207',2703.00,0.00,0.00,4.25,144.50,'2022-05-01 15:47:34','',''),(4136,'1','219','1',1,'Retail Sale Id 4208',3001.92,0.00,0.00,4.72,160.48,'2022-05-01 15:48:58','',''),(4137,'1','219','1',1,'Retail Sale Id 4209',1698.12,0.00,0.00,2.67,90.78,'2022-05-01 16:00:37','',''),(4138,'1','219','1',1,'Retail Sale Id 4210',3816.00,0.00,0.00,6.00,204.00,'2022-05-01 16:12:09','',''),(4139,'1','219','1',1,'Retail Sale Id 4211',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 16:16:41','',''),(4140,'1','219','1',1,'Retail Sale Id 4212',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 16:22:22','',''),(4141,'1','219','1',1,'Retail Sale Id 4213',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 16:30:29','',''),(4142,'1','219','1',1,'Retail Sale Id 4214',5088.00,0.00,0.00,8.00,272.00,'2022-05-01 16:33:47','',''),(4143,'1','219','1',1,'Retail Sale Id 4215',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 16:36:20','',''),(4144,'1','219','1',1,'Retail Sale Id 4216',3001.92,0.00,0.00,4.72,160.48,'2022-05-01 16:38:17','',''),(4145,'1','219','1',1,'Retail Sale Id 4217',801.36,0.00,0.00,1.26,42.84,'2022-05-01 16:39:34','',''),(4146,'1','219','1',1,'Retail Sale Id 4218',3816.00,0.00,0.00,6.00,204.00,'2022-05-01 16:40:59','',''),(4147,'1','219','1',1,'Retail Sale Id 4219',998.52,0.00,0.00,1.57,53.38,'2022-05-01 16:42:11','',''),(4148,'1','219','1',1,'Retail Sale Id 4220',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 16:54:36','',''),(4149,'1','219','1',1,'Retail Sale Id 4221',6360.00,0.00,0.00,10.00,340.00,'2022-05-01 17:01:17','',''),(4150,'1','219','1',1,'Retail Sale Id 4222',1297.44,0.00,0.00,2.04,69.36,'2022-05-01 17:03:39','',''),(4151,'1','219','1',1,'Retail Sale Id 4223',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 17:07:33','',''),(4152,'1','219','1',1,'Retail Sale Id 4224',2550.36,0.00,0.00,4.01,136.34,'2022-05-01 17:09:40','',''),(4153,'1','219','1',1,'Retail Sale Id 4225',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 17:14:51','',''),(4154,'1','219','1',1,'Retail Sale Id 4227',3199.08,0.00,0.00,5.03,171.02,'2022-05-01 17:20:49','',''),(4155,'1','219','1',1,'Retail Sale Id 4228',7950.00,0.00,0.00,12.50,425.00,'2022-05-01 17:22:30','',''),(4156,'1','219','1',1,'Retail Sale Id 4229',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 17:23:28','',''),(4157,'1','219','1',1,'Retail Sale Id 4230',1500.96,0.00,0.00,2.36,80.24,'2022-05-01 17:24:21','',''),(4158,'1','219','1',1,'Retail Sale Id 4231',3822.36,0.00,0.00,6.01,204.34,'2022-05-01 17:26:34','',''),(4159,'1','219','1',1,'Retail Sale Id 4232',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 17:33:55','',''),(4160,'1','219','1',1,'Retail Sale Id 4233',3822.36,0.00,0.00,6.01,204.34,'2022-05-01 17:36:15','',''),(4161,'1','219','1',1,'Retail Sale Id 4234',4000.44,0.00,0.00,6.29,213.86,'2022-05-01 17:37:55','',''),(4162,'1','219','1',1,'Retail Sale Id 4235',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 17:39:52','',''),(4163,'1','219','1',1,'Retail Sale Id 4236',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 17:41:26','',''),(4164,'1','219','1',1,'Retail Sale Id 4237',21490.00,0.00,0.00,35.00,420.00,'2022-05-01 17:43:38','',''),(4165,'1','219','1',1,'Retail Sale Id 4238',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 17:44:34','',''),(4166,'1','219','1',1,'Retail Sale Id 4239',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 17:46:20','',''),(4167,'1','219','1',1,'Retail Sale Id 4240',1908.00,0.00,0.00,3.00,102.00,'2022-05-01 17:47:45','',''),(4168,'1','219','1',1,'Retail Sale Id 4240',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 17:47:45','',''),(4169,'1','219','1',1,'Retail Sale Id 4241',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 17:50:00','',''),(4170,'1','219','1',1,'Retail Sale Id 4242',2499.48,0.00,0.00,3.93,133.62,'2022-05-01 17:51:30','',''),(4171,'1','219','1',1,'Retail Sale Id 4243',1297.44,0.00,0.00,2.04,69.36,'2022-05-01 17:52:15','',''),(4172,'1','219','1',1,'Retail Sale Id 4244',1297.44,0.00,0.00,2.04,69.36,'2022-05-01 17:53:29','',''),(4173,'1','219','1',1,'Retail Sale Id 4245',7950.00,0.00,0.00,12.50,425.00,'2022-05-01 17:55:49','',''),(4174,'1','219','1',1,'Retail Sale Id 4246',3001.92,0.00,0.00,4.72,160.48,'2022-05-01 18:04:27','',''),(4175,'1','219','1',1,'Retail Sale Id 4247',3822.36,0.00,0.00,6.01,204.34,'2022-05-01 18:12:48','',''),(4176,'1','219','1',1,'Retail Sale Id 4248',998.52,0.00,0.00,1.57,53.38,'2022-05-01 18:14:47','',''),(4177,'1','219','1',1,'Retail Sale Id 4249',502.44,0.00,0.00,0.79,26.86,'2022-05-01 18:18:44','',''),(4178,'1','219','1',1,'Retail Sale Id 4250',2448.60,0.00,0.00,3.85,130.90,'2022-05-01 18:21:45','',''),(4179,'1','219','1',1,'Retail Sale Id 4251',998.52,0.00,0.00,1.57,53.38,'2022-05-01 18:24:27','',''),(4180,'1','219','1',1,'Retail Sale Id 4252',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 18:26:25','',''),(4181,'1','219','1',1,'Retail Sale Id 4254',1997.04,0.00,0.00,3.14,106.76,'2022-05-01 18:39:08','',''),(4182,'1','219','1',1,'Retail Sale Id 4255',1997.04,0.00,0.00,3.14,106.76,'2022-05-02 09:54:26','',''),(4183,'1','219','1',1,'Retail Sale Id 4256',1997.04,0.00,0.00,3.14,106.76,'2022-05-02 09:55:15','',''),(4184,'1','219','1',1,'Retail Sale Id 4257',1399.20,0.00,0.00,2.20,74.80,'2022-05-02 09:56:05','',''),(4185,'1','219','1',1,'Retail Sale Id 4258',7950.00,0.00,0.00,12.50,425.00,'2022-05-02 09:57:22','',''),(4186,'1','219','1',1,'Retail Sale Id 4259',115432.00,0.00,0.00,188.00,2256.00,'2022-05-02 10:13:26','',''),(4187,'1','219','1',1,'Retail Sale Id 4260',115432.00,0.00,0.00,188.00,2256.00,'2022-05-02 10:14:32','',''),(4188,'1','219','1',1,'Retail Sale Id 4261',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 10:27:51','',''),(4189,'1','219','1',1,'Retail Sale Id 4262',648.72,0.00,0.00,1.02,34.68,'2022-05-02 10:34:46','',''),(4190,'1','219','1',1,'Retail Sale Id 4263',3180.00,0.00,0.00,5.00,170.00,'2022-05-02 10:36:38','',''),(4191,'1','219','1',1,'Retail Sale Id 4264',3001.92,0.00,0.00,4.72,160.48,'2022-05-02 10:40:25','',''),(4192,'1','219','1',1,'Retail Sale Id 4266',1908.00,0.00,0.00,3.00,102.00,'2022-05-02 10:48:47','',''),(4193,'1','219','1',1,'Retail Sale Id 4266',3001.92,0.00,0.00,4.72,160.48,'2022-05-02 10:48:47','',''),(4194,'1','219','1',1,'Retail Sale Id 4266',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 10:48:47','',''),(4195,'1','219','1',1,'Retail Sale Id 4267',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 10:50:50','',''),(4196,'1','219','1',1,'Retail Sale Id 4268',1952.52,0.00,0.00,3.07,104.38,'2022-05-02 11:00:52','',''),(4197,'1','219','1',1,'Retail Sale Id 4269',7950.00,0.00,0.00,12.50,425.00,'2022-05-02 11:04:22','',''),(4198,'1','219','1',1,'Retail Sale Id 4270',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 11:05:58','',''),(4199,'1','219','1',1,'Retail Sale Id 4271',998.52,0.00,0.00,1.57,53.38,'2022-05-02 11:08:07','',''),(4200,'1','219','1',1,'Retail Sale Id 4272',1997.04,0.00,0.00,3.14,106.76,'2022-05-02 11:09:01','',''),(4201,'1','219','1',1,'Retail Sale Id 4273',502.44,0.00,0.00,0.79,26.86,'2022-05-02 11:09:52','',''),(4202,'1','219','1',1,'Retail Sale Id 4274',1908.00,0.00,0.00,3.00,102.00,'2022-05-02 11:10:54','',''),(4203,'1','219','1',1,'Retail Sale Id 4276',3796.92,0.00,0.00,5.97,202.98,'2022-05-02 11:14:40','',''),(4204,'1','219','1',1,'Retail Sale Id 4277',998.52,0.00,0.00,1.57,53.38,'2022-05-02 11:44:59','',''),(4205,'1','219','1',1,'Retail Sale Id 4278',1997.04,0.00,0.00,3.14,106.76,'2022-05-02 11:52:23','',''),(4206,'1','219','1',1,'Retail Sale Id 4279',3002.46,0.00,0.00,4.89,58.68,'2022-05-02 11:56:34','',''),(4207,'1','219','1',1,'Retail Sale Id 4280',642.36,0.00,0.00,1.01,34.34,'2022-05-02 12:03:32','',''),(4208,'1','219','1',1,'Retail Sale Id 4281',1500.96,0.00,0.00,2.36,80.24,'2022-05-02 12:09:57','',''),(4209,'1','219','1',1,'Retail Sale Id 4282',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 12:11:18','',''),(4210,'1','219','1',1,'Retail Sale Id 4283',3828.72,0.00,0.00,6.02,204.68,'2022-05-02 12:18:36','',''),(4211,'1','219','1',1,'Retail Sale Id 4284',3001.92,0.00,0.00,4.72,160.48,'2022-05-02 12:30:57','',''),(4212,'1','219','1',1,'Retail Sale Id 4285',7950.00,0.00,0.00,12.50,425.00,'2022-05-02 12:32:02','',''),(4213,'1','219','1',1,'Retail Sale Id 4286',1297.44,0.00,0.00,2.04,69.36,'2022-05-02 12:47:48','',''),(4214,'1','219','1',1,'Retail Sale Id 4287',298.92,0.00,0.00,0.47,15.98,'2022-05-02 13:31:52','',''),(4215,'1','219','1',1,'Retail Sale Id 4288',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 14:02:58','',''),(4216,'1','219','1',1,'Retail Sale Id 4289',998.52,0.00,0.00,1.57,53.38,'2022-05-02 14:03:59','',''),(4217,'1','219','1',1,'Retail Sale Id 4290',998.52,0.00,0.00,1.57,53.38,'2022-05-02 14:16:32','',''),(4218,'1','219','1',1,'Retail Sale Id 4293',1500.96,0.00,0.00,2.36,80.24,'2022-05-02 14:57:12','',''),(4219,'1','219','1',1,'Retail Sale Id 4295',1297.44,0.00,0.00,2.04,69.36,'2022-05-02 15:13:28','',''),(4220,'1','219','1',1,'Retail Sale Id 4296',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 15:15:49','',''),(4221,'1','219','1',1,'Retail Sale Id 4297',3684.00,0.00,0.00,6.00,72.00,'2022-05-02 15:35:48','',''),(4222,'1','219','1',1,'Retail Sale Id 4298',0.00,0.00,0.00,0.00,0.00,'2022-05-02 15:38:03','',''),(4223,'1','219','1',1,'Retail Sale Id 4299',1500.96,0.00,0.00,2.36,80.24,'2022-05-02 15:40:09','',''),(4224,'1','219','1',1,'Retail Sale Id 4299',1500.96,0.00,0.00,2.36,80.24,'2022-05-02 15:40:09','',''),(4225,'1','219','1',1,'Retail Sale Id 4300',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 15:46:18','',''),(4226,'1','219','1',1,'Retail Sale Id 4301',998.52,0.00,0.00,1.57,53.38,'2022-05-02 16:06:58','',''),(4227,'1','219','1',1,'Retail Sale Id 4302',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 16:14:33','',''),(4228,'1','219','1',1,'Retail Sale Id 4303',801.36,0.00,0.00,1.26,42.84,'2022-05-02 16:15:53','',''),(4229,'1','219','1',1,'Retail Sale Id 4304',1500.96,0.00,0.00,2.36,80.24,'2022-05-02 16:20:37','',''),(4230,'1','219','1',1,'Retail Sale Id 4305',1908.00,0.00,0.00,3.00,102.00,'2022-05-02 16:32:34','',''),(4231,'1','219','1',1,'Retail Sale Id 4306',998.52,0.00,0.00,1.57,53.38,'2022-05-02 16:33:46','',''),(4232,'1','219','1',1,'Retail Sale Id 4307',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 16:35:08','',''),(4233,'1','219','1',1,'Retail Sale Id 4308',502.44,0.00,0.00,0.79,26.86,'2022-05-02 16:40:34','',''),(4234,'1','219','1',1,'Retail Sale Id 4310',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 17:02:55','',''),(4235,'1','219','1',1,'Retail Sale Id 4312',960.36,0.00,0.00,1.51,51.34,'2022-05-02 17:06:52','',''),(4236,'1','219','1',1,'Retail Sale Id 4313',648.72,0.00,0.00,1.02,34.68,'2022-05-02 17:10:49','',''),(4237,'1','219','1',1,'Retail Sale Id 4314',1997.04,0.00,0.00,3.14,106.76,'2022-05-02 17:28:13','',''),(4238,'1','219','1',1,'Retail Sale Id 4315',1997.04,0.00,0.00,3.14,106.76,'2022-05-02 17:35:12','',''),(4239,'1','219','1',1,'Retail Sale Id 4316',1997.04,0.00,0.00,3.14,106.76,'2022-05-02 17:39:09','',''),(4240,'1','219','1',1,'Retail Sale Id 4317',7498.44,0.00,0.00,11.79,400.86,'2022-05-02 17:40:12','',''),(4241,'1','219','1',1,'Retail Sale Id 4318',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 17:40:57','',''),(4242,'1','219','1',1,'Retail Sale Id 4319',1297.44,0.00,0.00,2.04,69.36,'2022-05-02 17:45:56','',''),(4243,'1','219','1',1,'Retail Sale Id 4320',3822.36,0.00,0.00,6.01,204.34,'2022-05-02 17:51:16','',''),(4244,'1','219','1',1,'Retail Sale Id 4321',3249.96,0.00,0.00,5.11,173.74,'2022-05-02 17:58:01','',''),(4245,'1','219','1',1,'Retail Sale Id 4322',648.72,0.00,0.00,1.02,34.68,'2022-05-02 17:58:57','',''),(4246,'1','219','1',1,'Retail Sale Id 4323',699.60,0.00,0.00,1.10,37.40,'2022-05-02 18:00:56','',''),(4247,'1','219','1',1,'Retail Sale Id 4324',64470.00,0.00,0.00,105.00,1260.00,'2022-05-03 08:11:22','',''),(4248,'1','219','1',1,'Retail Sale Id 4326',6360.00,0.00,0.00,10.00,340.00,'2022-05-03 08:13:48','',''),(4249,'1','219','1',1,'Retail Sale Id 4327',998.52,0.00,0.00,1.57,53.38,'2022-05-03 08:14:56','',''),(4250,'1','219','1',1,'Retail Sale Id 4328',998.52,0.00,0.00,1.57,53.38,'2022-05-03 08:15:59','',''),(4251,'1','219','1',1,'Retail Sale Id 4329',3816.00,0.00,0.00,6.00,204.00,'2022-05-03 08:45:22','',''),(4252,'1','219','1',1,'Retail Sale Id 4330',2499.48,0.00,0.00,3.93,133.62,'2022-05-03 08:50:59','',''),(4253,'1','219','1',1,'Retail Sale Id 4331',3796.92,0.00,0.00,5.97,202.98,'2022-05-03 09:00:31','',''),(4254,'1','219','1',1,'Retail Sale Id 4332',502.44,0.00,0.00,0.79,26.86,'2022-05-03 09:02:50','',''),(4255,'1','219','1',1,'Retail Sale Id 4333',39910.00,0.00,0.00,65.00,780.00,'2022-05-03 09:05:44','',''),(4256,'1','219','1',1,'Retail Sale Id 4334',3001.92,0.00,0.00,4.72,160.48,'2022-05-03 09:09:38','',''),(4257,'1','219','1',1,'Retail Sale Id 4335',1997.04,0.00,0.00,3.14,106.76,'2022-05-03 09:13:35','',''),(4258,'1','219','1',1,'Retail Sale Id 4336',3001.92,0.00,0.00,4.72,160.48,'2022-05-03 09:24:00','',''),(4259,'1','219','1',1,'Retail Sale Id 4337',3816.00,0.00,0.00,6.00,204.00,'2022-05-03 09:39:45','',''),(4260,'1','219','1',1,'Retail Sale Id 4338',3199.08,0.00,0.00,5.03,171.02,'2022-05-03 09:41:53','',''),(4261,'1','219','1',1,'Retail Sale Id 4339',3816.00,0.00,0.00,6.00,204.00,'2022-05-03 09:42:39','',''),(4262,'1','219','1',1,'Retail Sale Id 4340',1908.00,0.00,0.00,3.00,102.00,'2022-05-03 09:44:47','',''),(4263,'1','219','1',1,'Retail Sale Id 4342',3847.80,0.00,0.00,6.05,205.70,'2022-05-03 10:11:03','',''),(4264,'1','219','1',1,'Retail Sale Id 4344',3822.36,0.00,0.00,6.01,204.34,'2022-05-03 10:16:39','',''),(4265,'1','219','1',1,'Retail Sale Id 4344',3822.36,0.00,0.00,6.01,204.34,'2022-05-03 10:16:39','',''),(4266,'1','219','1',1,'Retail Sale Id 4345',998.52,0.00,0.00,1.57,53.38,'2022-05-03 10:18:20','',''),(4267,'1','219','1',1,'Retail Sale Id 4346',998.52,0.00,0.00,1.57,53.38,'2022-05-03 10:47:09','',''),(4268,'1','219','1',1,'Retail Sale Id 4347',7950.00,0.00,0.00,12.50,425.00,'2022-05-03 10:48:36','',''),(4269,'1','219','1',1,'Retail Sale Id 4348',6499.92,0.00,0.00,10.22,347.48,'2022-05-03 10:50:18','',''),(4270,'1','219','1',1,'Retail Sale Id 4349',3498.00,0.00,0.00,5.50,187.00,'2022-05-03 10:52:46','',''),(4271,'1','219','1',1,'Retail Sale Id 4350',502.44,0.00,0.00,0.79,26.86,'2022-05-03 10:55:02','',''),(4272,'1','219','1',1,'Retail Sale Id 4351',648.72,0.00,0.00,1.02,34.68,'2022-05-03 10:58:38','',''),(4273,'1','219','1',1,'Retail Sale Id 4352',3199.08,0.00,0.00,5.03,171.02,'2022-05-03 11:02:45','',''),(4274,'1','219','1',1,'Retail Sale Id 4353',2900.16,0.00,0.00,4.56,155.04,'2022-05-03 11:10:03','',''),(4275,'1','219','1',1,'Retail Sale Id 4354',4000.44,0.00,0.00,6.29,213.86,'2022-05-03 11:40:27','',''),(4276,'1','219','1',1,'Retail Sale Id 4355',1450.08,0.00,0.00,2.28,77.52,'2022-05-03 11:50:03','',''),(4277,'1','219','1',1,'Retail Sale Id 4356',2550.36,0.00,0.00,4.01,136.34,'2022-05-03 11:54:01','',''),(4278,'1','219','1',1,'Retail Sale Id 4357',998.52,0.00,0.00,1.57,53.38,'2022-05-03 12:29:39','',''),(4279,'1','219','1',1,'Retail Sale Id 4358',3498.00,0.00,0.00,5.50,187.00,'2022-05-03 12:43:48','',''),(4280,'1','219','1',1,'Retail Sale Id 4360',3402.60,0.00,0.00,5.35,181.90,'2022-05-03 13:06:17','',''),(4281,'1','219','1',1,'Retail Sale Id 4361',998.52,0.00,0.00,1.57,53.38,'2022-05-03 13:48:01','',''),(4282,'1','219','1',1,'Retail Sale Id 4362',2499.48,0.00,0.00,3.93,133.62,'2022-05-03 14:00:38','',''),(4283,'1','219','1',1,'Retail Sale Id 4363',1297.44,0.00,0.00,2.04,69.36,'2022-05-03 14:02:40','',''),(4284,'1','219','1',1,'Retail Sale Id 4364',1908.00,0.00,0.00,3.00,102.00,'2022-05-03 14:28:24','',''),(4285,'1','219','1',1,'Retail Sale Id 4365',3001.92,0.00,0.00,4.72,160.48,'2022-05-03 14:30:04','',''),(4286,'1','219','1',1,'Retail Sale Id 4366',3199.08,0.00,0.00,5.03,171.02,'2022-05-03 14:37:45','',''),(4287,'1','219','1',1,'Retail Sale Id 4367',1908.00,0.00,0.00,3.00,102.00,'2022-05-03 14:39:04','',''),(4288,'1','219','1',1,'Retail Sale Id 4368',3822.36,0.00,0.00,6.01,204.34,'2022-05-03 14:45:26','',''),(4289,'1','219','1',1,'Retail Sale Id 4369',3816.00,0.00,0.00,6.00,204.00,'2022-05-03 15:19:41','',''),(4290,'1','219','1',1,'Retail Sale Id 4369',7950.00,0.00,0.00,12.50,425.00,'2022-05-03 15:19:41','',''),(4291,'1','219','1',1,'Retail Sale Id 4369',7950.00,0.00,0.00,12.50,425.00,'2022-05-03 15:19:41','',''),(4292,'1','219','1',1,'Retail Sale Id 4370',998.52,0.00,0.00,1.57,53.38,'2022-05-03 15:24:33','',''),(4293,'1','219','1',1,'Retail Sale Id 4371',1500.96,0.00,0.00,2.36,80.24,'2022-05-03 16:30:38','',''),(4294,'1','219','1',1,'Retail Sale Id 4372',1997.04,0.00,0.00,3.14,106.76,'2022-05-03 16:31:58','',''),(4295,'1','219','1',1,'Retail Sale Id 4373',3684.00,0.00,0.00,6.00,72.00,'2022-05-03 16:39:50','',''),(4296,'1','219','1',1,'Retail Sale Id 4374',1500.96,0.00,0.00,2.36,80.24,'2022-05-03 16:42:44','',''),(4297,'1','219','1',1,'Retail Sale Id 4375',3822.36,0.00,0.00,6.01,204.34,'2022-05-03 16:49:59','',''),(4298,'1','219','1',1,'Retail Sale Id 4376',636.00,0.00,0.00,1.00,34.00,'2022-05-03 16:52:16','',''),(4299,'1','219','1',1,'Retail Sale Id 4377',3822.36,0.00,0.00,6.01,204.34,'2022-05-03 17:04:51','',''),(4300,'1','219','1',1,'Retail Sale Id 4378',699.60,0.00,0.00,1.10,37.40,'2022-05-03 17:07:01','',''),(4301,'1','219','1',1,'Retail Sale Id 4379',4998.96,0.00,0.00,7.86,267.24,'2022-05-03 17:08:04','',''),(4302,'1','219','1',1,'Retail Sale Id 4380',1297.44,0.00,0.00,2.04,69.36,'2022-05-03 17:12:57','',''),(4303,'1','219','1',1,'Retail Sale Id 4381',699.60,0.00,0.00,1.10,37.40,'2022-05-03 17:14:11','',''),(4304,'1','219','1',1,'Retail Sale Id 4382',998.52,0.00,0.00,1.57,53.38,'2022-05-03 17:20:07','',''),(4305,'1','219','1',1,'Retail Sale Id 4383',1997.04,0.00,0.00,3.14,106.76,'2022-05-03 17:22:44','',''),(4306,'1','219','1',1,'Retail Sale Id 4384',1500.96,0.00,0.00,2.36,80.24,'2022-05-03 17:27:02','',''),(4307,'1','219','1',1,'Retail Sale Id 4385',3822.36,0.00,0.00,6.01,204.34,'2022-05-03 17:37:21','',''),(4308,'1','219','1',1,'Retail Sale Id 4386',1297.44,0.00,0.00,2.04,69.36,'2022-05-03 17:43:58','',''),(4309,'1','219','1',1,'Retail Sale Id 4387',502.44,0.00,0.00,0.79,26.86,'2022-05-03 17:58:22','',''),(4310,'1','219','1',1,'Retail Sale Id 4388',133.56,0.00,0.00,0.21,7.14,'2022-05-03 18:00:33','',''),(4311,'1','219','1',1,'Retail Sale Id 4389',1908.00,0.00,0.00,3.00,102.00,'2022-05-03 18:02:32','',''),(4312,'1','219','1',1,'Retail Sale Id 4390',998.52,0.00,0.00,1.57,53.38,'2022-05-03 18:17:26','',''),(4313,'1','219','1',1,'Retail Sale Id 4391',3822.36,0.00,0.00,6.01,204.34,'2022-05-03 18:22:22','',''),(4314,'1','219','1',1,'Retail Sale Id 4392',3822.36,0.00,0.00,6.01,204.34,'2022-05-03 18:28:16','',''),(4315,'1','219','1',1,'Retail Sale Id 4393',502.44,0.00,0.00,0.79,26.86,'2022-05-03 18:34:52','',''),(4316,'1','219','1',1,'Retail Sale Id 4394',3822.36,0.00,0.00,6.01,204.34,'2022-05-03 19:03:06','',''),(4317,'1','219','1',1,'Retail Sale Id 4395',1500.96,0.00,0.00,2.36,80.24,'2022-05-04 07:38:22','',''),(4318,'1','219','1',1,'Retail Sale Id 4396',648.72,0.00,0.00,1.02,34.68,'2022-05-04 07:46:29','',''),(4319,'1','219','1',1,'Retail Sale Id 4397',1500.96,0.00,0.00,2.36,80.24,'2022-05-04 08:02:16','',''),(4320,'1','219','1',1,'Retail Sale Id 4398',1297.44,0.00,0.00,2.04,69.36,'2022-05-04 08:15:53','',''),(4321,'1','219','1',1,'Retail Sale Id 4399',1908.00,0.00,0.00,3.00,102.00,'2022-05-04 08:45:48','',''),(4322,'1','219','1',1,'Retail Sale Id 4399',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 08:45:48','',''),(4323,'1','219','1',1,'Retail Sale Id 4400',7950.00,0.00,0.00,12.50,425.00,'2022-05-04 09:00:12','',''),(4324,'1','219','1',1,'Retail Sale Id 4401',3199.08,0.00,0.00,5.03,171.02,'2022-05-04 09:09:56','',''),(4325,'1','219','1',1,'Retail Sale Id 4402',1997.04,0.00,0.00,3.14,106.76,'2022-05-04 09:12:36','',''),(4326,'1','219','1',1,'Retail Sale Id 4403',1500.96,0.00,0.00,2.36,80.24,'2022-05-04 09:26:59','',''),(4327,'1','219','1',1,'Retail Sale Id 4404',3199.08,0.00,0.00,5.03,171.02,'2022-05-04 09:28:44','',''),(4328,'1','219','1',1,'Retail Sale Id 4405',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 09:38:39','',''),(4329,'1','219','1',1,'Retail Sale Id 4406',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 10:00:32','',''),(4330,'1','219','1',1,'Retail Sale Id 4407',3180.00,0.00,0.00,5.00,170.00,'2022-05-04 10:07:34','',''),(4331,'1','219','1',1,'Retail Sale Id 4408',3001.92,0.00,0.00,4.72,160.48,'2022-05-04 10:18:47','',''),(4332,'1','219','1',1,'Retail Sale Id 4409',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 10:27:41','',''),(4333,'1','219','1',1,'Retail Sale Id 4409',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 10:27:41','',''),(4334,'1','219','1',1,'Retail Sale Id 4411',1908.00,0.00,0.00,3.00,102.00,'2022-05-04 11:06:19','',''),(4335,'1','219','1',1,'Retail Sale Id 4412',1297.44,0.00,0.00,2.04,69.36,'2022-05-04 11:09:53','',''),(4336,'1','219','1',1,'Retail Sale Id 4413',298.92,0.00,0.00,0.47,15.98,'2022-05-04 11:13:24','',''),(4337,'1','219','1',1,'Retail Sale Id 4414',4000.44,0.00,0.00,6.29,213.86,'2022-05-04 11:14:39','',''),(4338,'1','219','1',1,'Retail Sale Id 4415',30700.00,0.00,0.00,50.00,600.00,'2022-05-04 11:29:37','',''),(4339,'1','219','1',1,'Retail Sale Id 4416',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 11:44:31','',''),(4340,'1','219','1',1,'Retail Sale Id 4417',3180.00,0.00,0.00,5.00,170.00,'2022-05-04 11:56:04','',''),(4341,'1','219','1',1,'Retail Sale Id 4418',1908.00,0.00,0.00,3.00,102.00,'2022-05-04 12:20:00','',''),(4342,'1','219','1',1,'Retail Sale Id 4419',1908.00,0.00,0.00,3.00,102.00,'2022-05-04 12:33:59','',''),(4343,'1','219','1',1,'Retail Sale Id 4420',998.52,0.00,0.00,1.57,53.38,'2022-05-04 12:35:00','',''),(4344,'1','219','1',1,'Retail Sale Id 4421',3001.92,0.00,0.00,4.72,160.48,'2022-05-04 12:35:59','',''),(4345,'1','219','1',1,'Retail Sale Id 4422',1202.04,0.00,0.00,1.89,64.26,'2022-05-04 12:37:34','',''),(4346,'1','219','1',1,'Retail Sale Id 4423',1500.96,0.00,0.00,2.36,80.24,'2022-05-04 12:43:25','',''),(4347,'1','219','1',1,'Retail Sale Id 4424',1908.00,0.00,0.00,3.00,102.00,'2022-05-04 12:47:03','',''),(4348,'1','219','1',1,'Retail Sale Id 4425',2550.36,0.00,0.00,4.01,136.34,'2022-05-04 12:54:48','',''),(4349,'1','219','1',1,'Retail Sale Id 4426',1908.00,0.00,0.00,3.00,102.00,'2022-05-04 13:02:10','',''),(4350,'1','219','1',1,'Retail Sale Id 4427',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 13:21:14','',''),(4351,'1','219','1',1,'Retail Sale Id 4428',502.44,0.00,0.00,0.79,26.86,'2022-05-04 14:01:17','',''),(4352,'1','219','1',1,'Retail Sale Id 4429',30700.00,0.00,0.00,50.00,600.00,'2022-05-04 14:30:09','',''),(4353,'1','219','1',1,'Retail Sale Id 4430',642.36,0.00,0.00,1.01,34.34,'2022-05-04 14:32:18','',''),(4354,'1','219','1',1,'Retail Sale Id 4432',1997.04,0.00,0.00,3.14,106.76,'2022-05-04 14:50:42','',''),(4355,'1','219','1',1,'Retail Sale Id 4433',2499.48,0.00,0.00,3.93,133.62,'2022-05-04 14:54:20','',''),(4356,'1','219','1',1,'Retail Sale Id 4434',998.52,0.00,0.00,1.57,53.38,'2022-05-04 14:57:17','',''),(4357,'1','219','1',1,'Retail Sale Id 4435',7950.00,0.00,0.00,12.50,425.00,'2022-05-04 15:02:15','',''),(4358,'1','219','1',1,'Retail Sale Id 4436',1997.04,0.00,0.00,3.14,106.76,'2022-05-04 15:03:46','',''),(4359,'1','219','1',1,'Retail Sale Id 4437',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 15:11:23','',''),(4360,'1','219','1',1,'Retail Sale Id 4438',1500.96,0.00,0.00,2.36,80.24,'2022-05-04 15:21:10','',''),(4361,'1','219','1',1,'Retail Sale Id 4439',7950.00,0.00,0.00,12.50,425.00,'2022-05-04 15:37:24','',''),(4362,'1','219','1',1,'Retail Sale Id 4440',1997.04,0.00,0.00,3.14,106.76,'2022-05-04 15:55:55','',''),(4363,'1','219','1',1,'Retail Sale Id 4441',2499.48,0.00,0.00,3.93,133.62,'2022-05-04 15:58:55','',''),(4364,'1','219','1',1,'Retail Sale Id 4442',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 16:06:46','',''),(4365,'1','219','1',1,'Retail Sale Id 4443',1100.28,0.00,0.00,1.73,58.82,'2022-05-04 16:08:00','',''),(4366,'1','219','1',1,'Retail Sale Id 4444',1908.00,0.00,0.00,3.00,102.00,'2022-05-04 16:32:53','',''),(4367,'1','219','1',1,'Retail Sale Id 4445',1997.04,0.00,0.00,3.14,106.76,'2022-05-04 16:33:53','',''),(4368,'1','219','1',1,'Retail Sale Id 4446',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 16:35:07','',''),(4369,'1','219','1',1,'Retail Sale Id 4447',1297.44,0.00,0.00,2.04,69.36,'2022-05-04 16:40:55','',''),(4370,'1','219','1',1,'Retail Sale Id 4448',1908.00,0.00,0.00,3.00,102.00,'2022-05-04 16:44:16','',''),(4371,'1','219','1',1,'Retail Sale Id 4449',3180.00,0.00,0.00,5.00,170.00,'2022-05-04 16:54:38','',''),(4372,'1','219','1',1,'Retail Sale Id 4450',3684.00,0.00,0.00,6.00,72.00,'2022-05-04 17:00:28','',''),(4373,'1','219','1',1,'Retail Sale Id 4452',1997.04,0.00,0.00,3.14,106.76,'2022-05-04 17:01:47','',''),(4374,'1','219','1',1,'Retail Sale Id 4453',4452.00,0.00,0.00,7.00,238.00,'2022-05-04 17:03:21','',''),(4375,'1','219','1',1,'Retail Sale Id 4454',3498.00,0.00,0.00,5.50,187.00,'2022-05-04 17:05:35','',''),(4376,'1','219','1',1,'Retail Sale Id 4455',1997.04,0.00,0.00,3.14,106.76,'2022-05-04 17:10:17','',''),(4377,'1','219','1',1,'Retail Sale Id 4456',7950.00,0.00,0.00,12.50,425.00,'2022-05-04 17:17:37','',''),(4378,'1','219','1',1,'Retail Sale Id 4457',998.52,0.00,0.00,1.57,53.38,'2022-05-04 17:30:06','',''),(4379,'1','219','1',1,'Retail Sale Id 4459',1997.04,0.00,0.00,3.14,106.76,'2022-05-04 17:46:31','',''),(4380,'1','219','1',1,'Retail Sale Id 4460',502.44,0.00,0.00,0.79,26.86,'2022-05-04 17:57:47','',''),(4381,'1','219','1',1,'Retail Sale Id 4461',6360.00,0.00,0.00,10.00,340.00,'2022-05-04 18:08:49','',''),(4382,'1','219','1',1,'Retail Sale Id 4462',1399.20,0.00,0.00,2.20,74.80,'2022-05-04 18:59:12','',''),(4383,'1','219','1',1,'Retail Sale Id 4463',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 19:13:53','',''),(4384,'1','219','1',1,'Retail Sale Id 4464',3822.36,0.00,0.00,6.01,204.34,'2022-05-04 19:30:30','',''),(4385,'1','219','1',1,'Retail Sale Id 4465',65084.00,0.00,0.00,106.00,1272.00,'2022-05-04 21:01:21','',''),(4386,'1','219','1',1,'Return of Retail Sale Id 4450',0.00,3684.00,6.00,0.00,-72.00,'2022-05-04 21:02:09','',''),(4387,'1','219','1',1,'Return of Retail Sale Id 4429',0.00,30700.00,50.00,0.00,-600.00,'2022-05-04 21:02:47','',''),(4388,'1','219','1',1,'Return of Retail Sale Id 4415',0.00,30700.00,50.00,0.00,-600.00,'2022-05-04 21:03:22','',''),(4389,'1','219','1',1,'Retail Sale Id 4466',7950.00,0.00,0.00,12.50,425.00,'2022-05-05 07:19:23','',''),(4390,'1','219','1',1,'Retail Sale Id 4467',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 08:13:50','',''),(4391,'1','219','1',1,'Retail Sale Id 4468',2544.00,0.00,0.00,4.00,136.00,'2022-05-05 08:39:02','',''),(4392,'1','219','1',1,'Retail Sale Id 4469',7950.00,0.00,0.00,12.50,425.00,'2022-05-05 08:47:25','',''),(4393,'1','219','1',1,'Retail Sale Id 4470',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 08:58:17','',''),(4394,'1','219','1',1,'Retail Sale Id 4473',45436.00,0.00,0.00,74.00,888.00,'2022-05-05 09:10:33','',''),(4395,'1','219','1',1,'Retail Sale Id 4474',648.72,0.00,0.00,1.02,34.68,'2022-05-05 09:12:13','',''),(4396,'1','219','1',1,'Retail Sale Id 4475',5800.32,0.00,0.00,9.12,310.08,'2022-05-05 09:23:12','',''),(4397,'1','219','1',1,'Retail Sale Id 4476',699.60,0.00,0.00,1.10,37.40,'2022-05-05 09:29:21','',''),(4398,'1','219','1',1,'Retail Sale Id 4477',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 09:33:52','',''),(4399,'1','219','1',1,'Retail Sale Id 4478',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 09:42:24','',''),(4400,'1','219','1',1,'Retail Sale Id 4479',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 09:49:08','',''),(4401,'1','219','1',1,'Retail Sale Id 4480',1500.96,0.00,0.00,2.36,80.24,'2022-05-05 09:50:12','',''),(4402,'1','219','1',1,'Retail Sale Id 4481',7675.00,0.00,0.00,12.50,150.00,'2022-05-05 09:57:03','',''),(4403,'1','219','1',1,'Retail Sale Id 4482',998.52,0.00,0.00,1.57,53.38,'2022-05-05 10:00:15','',''),(4404,'1','219','1',1,'Retail Sale Id 4483',1182.96,0.00,0.00,1.86,63.24,'2022-05-05 10:02:29','',''),(4405,'1','219','1',1,'Retail Sale Id 4484',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 10:07:59','',''),(4406,'1','219','1',1,'Retail Sale Id 4485',1908.00,0.00,0.00,3.00,102.00,'2022-05-05 10:12:33','',''),(4407,'1','219','1',1,'Retail Sale Id 4486',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 10:14:54','',''),(4408,'1','219','1',1,'Retail Sale Id 4487',1202.04,0.00,0.00,1.89,64.26,'2022-05-05 10:26:54','',''),(4409,'1','219','1',1,'Retail Sale Id 4488',400.68,0.00,0.00,0.63,21.42,'2022-05-05 10:38:03','',''),(4410,'1','219','1',1,'Retail Sale Id 4489',699.60,0.00,0.00,1.10,37.40,'2022-05-05 10:48:52','',''),(4411,'1','219','1',1,'Retail Sale Id 4489',801.36,0.00,0.00,1.26,42.84,'2022-05-05 10:48:52','',''),(4412,'1','219','1',1,'Retail Sale Id 4490',3498.00,0.00,0.00,5.50,187.00,'2022-05-05 10:50:48','',''),(4413,'1','219','1',1,'Retail Sale Id 4491',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 11:20:47','',''),(4414,'1','219','1',1,'Retail Sale Id 4492',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 11:22:13','',''),(4415,'1','219','1',1,'Retail Sale Id 4493',1500.96,0.00,0.00,2.36,80.24,'2022-05-05 11:40:09','',''),(4416,'1','219','1',1,'Retail Sale Id 4494',61400.00,0.00,0.00,100.00,1200.00,'2022-05-05 11:47:56','',''),(4417,'1','219','1',1,'Retail Sale Id 4495',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 11:48:52','',''),(4418,'1','219','1',1,'Retail Sale Id 4496',1908.00,0.00,0.00,3.00,102.00,'2022-05-05 11:53:30','',''),(4419,'1','219','1',1,'Retail Sale Id 4496',1908.00,0.00,0.00,3.00,102.00,'2022-05-05 11:53:30','',''),(4420,'1','219','1',1,'Retail Sale Id 4497',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 11:55:15','',''),(4421,'1','219','1',1,'Retail Sale Id 4498',1272.00,0.00,0.00,2.00,68.00,'2022-05-05 11:58:31','',''),(4422,'1','219','1',1,'Retail Sale Id 4498',1272.00,0.00,0.00,2.00,68.00,'2022-05-05 11:58:31','',''),(4423,'1','219','1',1,'Retail Sale Id 4499',5100.72,0.00,0.00,8.02,272.68,'2022-05-05 12:03:10','',''),(4424,'1','219','1',1,'Retail Sale Id 4500',1842.00,0.00,0.00,3.00,36.00,'2022-05-05 12:05:34','',''),(4425,'1','219','1',1,'Retail Sale Id 4501',502.44,0.00,0.00,0.79,26.86,'2022-05-05 12:08:00','',''),(4426,'1','219','1',1,'Retail Sale Id 4502',1908.00,0.00,0.00,3.00,102.00,'2022-05-05 12:25:53','',''),(4427,'1','219','1',1,'Retail Sale Id 4503',1500.96,0.00,0.00,2.36,80.24,'2022-05-05 12:29:09','',''),(4428,'1','219','1',1,'Retail Sale Id 4504',3180.00,0.00,0.00,5.00,170.00,'2022-05-05 12:49:01','',''),(4429,'1','219','1',1,'Retail Sale Id 4505',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 12:50:02','',''),(4430,'1','219','1',1,'Retail Sale Id 4507',1908.00,0.00,0.00,3.00,102.00,'2022-05-05 12:57:30','',''),(4431,'1','219','1',1,'Retail Sale Id 4507',1908.00,0.00,0.00,3.00,102.00,'2022-05-05 12:57:30','',''),(4432,'1','219','1',1,'Retail Sale Id 4508',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 13:12:46','',''),(4433,'1','219','1',1,'Retail Sale Id 4509',998.52,0.00,0.00,1.57,53.38,'2022-05-05 13:18:57','',''),(4434,'1','219','1',1,'Retail Sale Id 4510',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 13:25:49','',''),(4435,'1','219','1',1,'Retail Sale Id 4511',502.44,0.00,0.00,0.79,26.86,'2022-05-05 13:38:14','',''),(4436,'1','219','1',1,'Retail Sale Id 4512',6360.00,0.00,0.00,10.00,340.00,'2022-05-05 13:46:31','',''),(4437,'1','219','1',1,'Retail Sale Id 4513',7950.00,0.00,0.00,12.50,425.00,'2022-05-05 13:48:54','',''),(4438,'1','219','1',1,'Retail Sale Id 4514',1698.12,0.00,0.00,2.67,90.78,'2022-05-05 14:09:30','',''),(4439,'1','219','1',1,'Retail Sale Id 4515',3001.92,0.00,0.00,4.72,160.48,'2022-05-05 14:20:19','',''),(4440,'1','219','1',1,'Retail Sale Id 4516',7950.00,0.00,0.00,12.50,425.00,'2022-05-05 14:37:03','',''),(4441,'1','219','1',1,'Retail Sale Id 4517',7002.36,0.00,0.00,11.01,374.34,'2022-05-05 14:40:11','',''),(4442,'1','219','1',1,'Retail Sale Id 4518',30700.00,0.00,0.00,50.00,600.00,'2022-05-05 14:44:47','',''),(4443,'1','219','1',1,'Retail Sale Id 4519',3199.08,0.00,0.00,5.03,171.02,'2022-05-05 14:46:25','',''),(4444,'1','219','1',1,'Retail Sale Id 4520',998.52,0.00,0.00,1.57,53.38,'2022-05-05 15:10:26','',''),(4445,'1','219','1',1,'Retail Sale Id 4521',5730.36,0.00,0.00,9.01,306.34,'2022-05-05 15:15:53','',''),(4446,'1','219','1',1,'Retail Sale Id 4522',699.60,0.00,0.00,1.10,37.40,'2022-05-05 15:17:26','',''),(4447,'1','219','1',1,'Retail Sale Id 4523',64470.00,0.00,0.00,105.00,1260.00,'2022-05-05 15:19:33','',''),(4448,'1','219','1',1,'Retail Sale Id 4524',1698.12,0.00,0.00,2.67,90.78,'2022-05-05 15:23:28','',''),(4449,'1','219','1',1,'Retail Sale Id 4525',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 15:46:18','',''),(4450,'1','219','1',1,'Retail Sale Id 4526',3199.08,0.00,0.00,5.03,171.02,'2022-05-05 15:51:08','',''),(4451,'1','219','1',1,'Retail Sale Id 4527',998.52,0.00,0.00,1.57,53.38,'2022-05-05 15:52:25','',''),(4452,'1','219','1',1,'Retail Sale Id 4529',7950.00,0.00,0.00,12.50,425.00,'2022-05-05 15:53:28','',''),(4453,'1','219','1',1,'Retail Sale Id 4530',6360.00,0.00,0.00,10.00,340.00,'2022-05-05 16:03:59','',''),(4454,'1','219','1',1,'Retail Sale Id 4531',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 16:06:37','',''),(4455,'1','219','1',1,'Retail Sale Id 4532',7675.00,0.00,0.00,12.50,150.00,'2022-05-05 16:09:34','',''),(4456,'1','219','1',1,'Retail Sale Id 4533',7368.00,0.00,0.00,12.00,144.00,'2022-05-05 16:10:41','',''),(4457,'1','219','1',1,'Return of Retail Sale Id 4532',0.00,7675.00,12.50,0.00,-150.00,'2022-05-05 16:11:13','',''),(4458,'1','219','1',1,'Retail Sale Id 4535',6140.00,0.00,0.00,10.00,120.00,'2022-05-05 16:12:14','',''),(4459,'1','219','1',1,'Retail Sale Id 4536',298.92,0.00,0.00,0.47,15.98,'2022-05-05 16:16:30','',''),(4460,'1','219','1',1,'Retail Sale Id 4537',1500.96,0.00,0.00,2.36,80.24,'2022-05-05 16:17:34','',''),(4461,'1','219','1',1,'Retail Sale Id 4538',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 16:33:34','',''),(4462,'1','219','1',1,'Retail Sale Id 4539',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 16:34:49','',''),(4463,'1','219','1',1,'Retail Sale Id 4540',3199.08,0.00,0.00,5.03,171.02,'2022-05-05 16:45:02','',''),(4464,'1','219','1',1,'Retail Sale Id 4541',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 16:46:36','',''),(4465,'1','219','1',1,'Retail Sale Id 4542',30700.00,0.00,0.00,50.00,600.00,'2022-05-05 16:48:01','',''),(4466,'1','219','1',1,'Retail Sale Id 4543',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 16:56:02','',''),(4467,'1','219','1',1,'Retail Sale Id 4544',998.52,0.00,0.00,1.57,53.38,'2022-05-05 16:59:10','',''),(4468,'1','219','1',1,'Retail Sale Id 4545',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 17:00:32','',''),(4469,'1','219','1',1,'Retail Sale Id 4548',7950.00,0.00,0.00,12.50,425.00,'2022-05-05 17:01:58','',''),(4470,'1','219','1',1,'Retail Sale Id 4549',1500.96,0.00,0.00,2.36,80.24,'2022-05-05 17:06:34','',''),(4471,'1','219','1',1,'Retail Sale Id 4550',1908.00,0.00,0.00,3.00,102.00,'2022-05-05 17:10:01','',''),(4472,'1','219','1',1,'Retail Sale Id 4550',7002.36,0.00,0.00,11.01,374.34,'2022-05-05 17:10:01','',''),(4473,'1','219','1',1,'Retail Sale Id 4550',7950.00,0.00,0.00,12.50,425.00,'2022-05-05 17:10:01','',''),(4474,'1','219','1',1,'Retail Sale Id 4551',998.52,0.00,0.00,1.57,53.38,'2022-05-05 17:14:39','',''),(4475,'1','219','1',1,'Retail Sale Id 4552',4998.96,0.00,0.00,7.86,267.24,'2022-05-05 17:15:31','',''),(4476,'1','219','1',1,'Retail Sale Id 4553',1901.64,0.00,0.00,2.99,101.66,'2022-05-05 17:19:49','',''),(4477,'1','219','1',1,'Retail Sale Id 4554',502.44,0.00,0.00,0.79,26.86,'2022-05-05 17:20:44','',''),(4478,'1','219','1',1,'Retail Sale Id 4555',502.44,0.00,0.00,0.79,26.86,'2022-05-05 17:21:33','',''),(4479,'1','219','1',1,'Retail Sale Id 4556',3180.00,0.00,0.00,5.00,170.00,'2022-05-05 17:25:21','',''),(4480,'1','219','1',1,'Retail Sale Id 4557',3199.08,0.00,0.00,5.03,171.02,'2022-05-05 17:29:58','',''),(4481,'1','219','1',1,'Retail Sale Id 4558',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 17:31:24','',''),(4482,'1','219','1',1,'Retail Sale Id 4559',3199.08,0.00,0.00,5.03,171.02,'2022-05-05 17:36:23','',''),(4483,'1','219','1',1,'Retail Sale Id 4560',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 17:38:01','',''),(4484,'1','219','1',1,'Retail Sale Id 4561',1799.88,0.00,0.00,2.83,96.22,'2022-05-05 17:39:05','',''),(4485,'1','219','1',1,'Retail Sale Id 4562',1297.44,0.00,0.00,2.04,69.36,'2022-05-05 17:42:34','',''),(4486,'1','219','1',1,'Retail Sale Id 4563',998.52,0.00,0.00,1.57,53.38,'2022-05-05 17:55:50','',''),(4487,'1','219','1',1,'Retail Sale Id 4564',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 18:05:23','',''),(4488,'1','219','1',1,'Retail Sale Id 4565',3822.36,0.00,0.00,6.01,204.34,'2022-05-05 18:15:15','',''),(4489,'1','219','1',1,'Retail Sale Id 4566',8000.88,0.00,0.00,12.58,427.72,'2022-05-05 18:16:47','',''),(4490,'1','219','1',1,'Retail Sale Id 4567',3070.00,0.00,0.00,5.00,60.00,'2022-05-05 18:18:43','',''),(4491,'1','219','1',1,'Retail Sale Id 4568',1908.00,0.00,0.00,3.00,102.00,'2022-05-05 18:22:10','',''),(4492,'1','219','1',1,'Retail Sale Id 4569',1297.44,0.00,0.00,2.04,69.36,'2022-05-05 18:33:50','',''),(4493,'1','219','1',1,'Retail Sale Id 4569',5088.00,0.00,0.00,8.00,272.00,'2022-05-05 18:33:50','',''),(4494,'1','219','1',1,'Retail Sale Id 4570',1997.04,0.00,0.00,3.14,106.76,'2022-05-05 18:44:56','',''),(4495,'1','219','1',1,'Retail Sale Id 4571',642.36,0.00,0.00,1.01,34.34,'2022-05-05 18:46:01','',''),(4496,'1','219','1',1,'Retail Sale Id 4572',1908.00,0.00,0.00,3.00,102.00,'2022-05-05 18:47:01','',''),(4497,'1','219','1',1,'Retail Sale Id 4573',502.44,0.00,0.00,0.79,26.86,'2022-05-05 18:49:27','',''),(4498,'1','219','1',1,'Retail Sale Id 4574',998.52,0.00,0.00,1.57,53.38,'2022-05-05 18:50:55','',''),(4499,'1','219','1',1,'Retail Sale Id 4575',597.84,0.00,0.00,0.94,31.96,'2022-05-05 19:06:51','',''),(4500,'1','219','1',1,'Retail Sale Id 4576',1500.96,0.00,0.00,2.36,80.24,'2022-05-05 19:07:41','',''),(4501,'1','219','1',1,'Retail Sale Id 4577',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 07:23:11','',''),(4502,'1','219','1',1,'Retail Sale Id 4578',629.64,0.00,0.00,0.99,33.66,'2022-05-06 07:24:31','',''),(4503,'1','219','1',1,'Retail Sale Id 4579',3001.92,0.00,0.00,4.72,160.48,'2022-05-06 07:51:44','',''),(4504,'1','219','1',1,'Retail Sale Id 4580',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 08:00:35','',''),(4505,'1','219','1',1,'Retail Sale Id 4581',1500.96,0.00,0.00,2.36,80.24,'2022-05-06 08:20:18','',''),(4506,'1','219','1',1,'Retail Sale Id 4582',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 08:34:33','',''),(4507,'1','219','1',1,'Retail Sale Id 4583',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 08:44:52','',''),(4508,'1','219','1',1,'Retail Sale Id 4585',3199.08,0.00,0.00,5.03,171.02,'2022-05-06 08:48:44','',''),(4509,'1','219','1',1,'Retail Sale Id 4586',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 09:00:59','',''),(4510,'1','219','1',1,'Retail Sale Id 4587',18420.00,0.00,0.00,30.00,360.00,'2022-05-06 09:08:09','',''),(4511,'1','219','1',1,'Retail Sale Id 4589',6360.00,0.00,0.00,10.00,340.00,'2022-05-06 09:16:31','',''),(4512,'1','219','1',1,'Retail Sale Id 4589',6360.00,0.00,0.00,10.00,340.00,'2022-05-06 09:16:31','',''),(4513,'1','219','1',1,'Retail Sale Id 4591',998.52,0.00,0.00,1.57,53.38,'2022-05-06 09:18:32','',''),(4514,'1','219','1',1,'Retail Sale Id 4592',1297.44,0.00,0.00,2.04,69.36,'2022-05-06 09:25:36','',''),(4515,'1','219','1',1,'Retail Sale Id 4592',3898.68,0.00,0.00,6.13,208.42,'2022-05-06 09:25:36','',''),(4516,'1','219','1',1,'Retail Sale Id 4593',3001.92,0.00,0.00,4.72,160.48,'2022-05-06 09:53:16','',''),(4517,'1','219','1',1,'Retail Sale Id 4594',298.92,0.00,0.00,0.47,15.98,'2022-05-06 09:57:02','',''),(4518,'1','219','1',1,'Retail Sale Id 4595',7950.00,0.00,0.00,12.50,425.00,'2022-05-06 10:04:01','',''),(4519,'1','219','1',1,'Retail Sale Id 4596',3180.00,0.00,0.00,5.00,170.00,'2022-05-06 10:14:35','',''),(4520,'1','219','1',1,'Retail Sale Id 4597',4000.44,0.00,0.00,6.29,213.86,'2022-05-06 10:20:14','',''),(4521,'1','219','1',1,'Retail Sale Id 4598',1901.64,0.00,0.00,2.99,101.66,'2022-05-06 10:32:28','',''),(4522,'1','219','1',1,'Retail Sale Id 4599',3180.00,0.00,0.00,5.00,170.00,'2022-05-06 10:38:46','',''),(4523,'1','219','1',1,'Retail Sale Id 4600',7950.00,0.00,0.00,12.50,425.00,'2022-05-06 10:46:39','',''),(4524,'1','219','1',1,'Retail Sale Id 4601',3180.00,0.00,0.00,5.00,170.00,'2022-05-06 10:49:46','',''),(4525,'1','219','1',1,'Retail Sale Id 4602',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 11:27:06','',''),(4526,'1','219','1',1,'Retail Sale Id 4603',9540.00,0.00,0.00,15.00,510.00,'2022-05-06 11:29:40','',''),(4527,'1','219','1',1,'Retail Sale Id 4604',4153.08,0.00,0.00,6.53,222.02,'2022-05-06 11:34:01','',''),(4528,'1','219','1',1,'Retail Sale Id 4605',7950.00,0.00,0.00,12.50,425.00,'2022-05-06 11:35:14','',''),(4529,'1','219','1',1,'Retail Sale Id 4606',1908.00,0.00,0.00,3.00,102.00,'2022-05-06 11:56:10','',''),(4530,'1','219','1',1,'Retail Sale Id 4607',3180.00,0.00,0.00,5.00,170.00,'2022-05-06 12:05:23','',''),(4531,'1','219','1',1,'Retail Sale Id 4608',7950.00,0.00,0.00,12.50,425.00,'2022-05-06 12:11:05','',''),(4532,'1','219','1',1,'Retail Sale Id 4609',1901.64,0.00,0.00,2.99,101.66,'2022-05-06 12:12:00','',''),(4533,'1','219','1',1,'Retail Sale Id 4610',3070.00,0.00,0.00,5.00,60.00,'2022-05-06 12:18:20','',''),(4534,'1','219','1',1,'Retail Sale Id 4611',2456.00,0.00,0.00,4.00,48.00,'2022-05-06 12:19:18','',''),(4535,'1','219','1',1,'Retail Sale Id 4612',1842.00,0.00,0.00,3.00,36.00,'2022-05-06 12:22:58','',''),(4536,'1','219','1',1,'Retail Sale Id 4613',998.52,0.00,0.00,1.57,53.38,'2022-05-06 12:25:26','',''),(4537,'1','219','1',1,'Retail Sale Id 4614',3001.92,0.00,0.00,4.72,160.48,'2022-05-06 12:27:14','',''),(4538,'1','219','1',1,'Retail Sale Id 4615',1997.04,0.00,0.00,3.14,106.76,'2022-05-06 12:28:08','',''),(4539,'1','219','1',1,'Retail Sale Id 4616',998.52,0.00,0.00,1.57,53.38,'2022-05-06 12:31:55','',''),(4540,'1','219','1',1,'Retail Sale Id 4617',8000.88,0.00,0.00,12.58,427.72,'2022-05-06 12:33:20','',''),(4541,'1','219','1',1,'Retail Sale Id 4619',7002.36,0.00,0.00,11.01,374.34,'2022-05-06 12:37:40','',''),(4542,'1','219','1',1,'Retail Sale Id 4620',14502.68,0.00,0.00,23.62,283.44,'2022-05-06 12:40:33','',''),(4543,'1','219','1',1,'Retail Sale Id 4621',1997.04,0.00,0.00,3.14,106.76,'2022-05-06 12:44:39','',''),(4544,'1','219','1',1,'Retail Sale Id 4621',1997.04,0.00,0.00,3.14,106.76,'2022-05-06 12:44:39','',''),(4545,'1','219','1',1,'Retail Sale Id 4622',998.52,0.00,0.00,1.57,53.38,'2022-05-06 12:45:37','',''),(4546,'1','219','1',1,'Retail Sale Id 4623',2550.36,0.00,0.00,4.01,136.34,'2022-05-06 12:47:27','',''),(4547,'1','219','1',1,'Retail Sale Id 4624',2550.36,0.00,0.00,4.01,136.34,'2022-05-06 12:59:11','',''),(4548,'1','219','1',1,'Retail Sale Id 4625',1297.44,0.00,0.00,2.04,69.36,'2022-05-06 13:00:46','',''),(4549,'1','219','1',1,'Retail Sale Id 4626',7950.00,0.00,0.00,12.50,425.00,'2022-05-06 13:18:35','',''),(4550,'1','219','1',1,'Retail Sale Id 4627',3001.92,0.00,0.00,4.72,160.48,'2022-05-06 13:41:42','',''),(4551,'1','219','1',1,'Retail Sale Id 4628',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 13:48:03','',''),(4552,'1','219','1',1,'Retail Sale Id 4629',1997.04,0.00,0.00,3.14,106.76,'2022-05-06 13:56:13','',''),(4553,'1','219','1',1,'Retail Sale Id 4630',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 14:21:56','',''),(4554,'1','219','1',1,'Retail Sale Id 4631',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 14:30:14','',''),(4555,'1','219','1',1,'Retail Sale Id 4632',1602.72,0.00,0.00,2.52,85.68,'2022-05-06 14:38:54','',''),(4556,'1','219','1',1,'Retail Sale Id 4633',3180.00,0.00,0.00,5.00,170.00,'2022-05-06 14:41:24','',''),(4557,'1','219','1',1,'Retail Sale Id 4634',3684.00,0.00,0.00,6.00,72.00,'2022-05-06 14:52:35','',''),(4558,'1','219','1',1,'Retail Sale Id 4635',1908.00,0.00,0.00,3.00,102.00,'2022-05-06 14:56:57','',''),(4559,'1','219','1',1,'Retail Sale Id 4636',1997.04,0.00,0.00,3.14,106.76,'2022-05-06 15:01:49','',''),(4560,'1','219','1',1,'Retail Sale Id 4637',3001.92,0.00,0.00,4.72,160.48,'2022-05-06 15:13:41','',''),(4561,'1','219','1',1,'Retail Sale Id 4638',7002.36,0.00,0.00,11.01,374.34,'2022-05-06 15:21:57','',''),(4562,'1','219','1',1,'Retail Sale Id 4639',2346.84,0.00,0.00,3.69,125.46,'2022-05-06 15:28:16','',''),(4563,'1','219','1',1,'Retail Sale Id 4640',998.52,0.00,0.00,1.57,53.38,'2022-05-06 15:33:08','',''),(4564,'1','219','1',1,'Retail Sale Id 4641',2550.36,0.00,0.00,4.01,136.34,'2022-05-06 15:44:07','',''),(4565,'1','219','1',1,'Retail Sale Id 4642',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 15:54:12','',''),(4566,'1','219','1',1,'Retail Sale Id 4643',1202.04,0.00,0.00,1.89,64.26,'2022-05-06 15:55:48','',''),(4567,'1','219','1',1,'Retail Sale Id 4644',1297.44,0.00,0.00,2.04,69.36,'2022-05-06 16:05:18','',''),(4568,'1','219','1',1,'Retail Sale Id 4644',3180.00,0.00,0.00,5.00,170.00,'2022-05-06 16:05:18','',''),(4569,'1','219','1',1,'Retail Sale Id 4645',3498.00,0.00,0.00,5.50,187.00,'2022-05-06 16:07:38','',''),(4570,'1','219','1',1,'Retail Sale Id 4646',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 16:10:51','',''),(4571,'1','219','1',1,'Retail Sale Id 4646',7950.00,0.00,0.00,12.50,425.00,'2022-05-06 16:10:51','',''),(4572,'1','219','1',1,'Retail Sale Id 4647',3199.08,0.00,0.00,5.03,171.02,'2022-05-06 16:33:11','',''),(4573,'1','219','1',1,'Retail Sale Id 4648',1297.44,0.00,0.00,2.04,69.36,'2022-05-06 16:34:03','',''),(4574,'1','219','1',1,'Retail Sale Id 4649',1500.96,0.00,0.00,2.36,80.24,'2022-05-06 16:35:25','',''),(4575,'1','219','1',1,'Retail Sale Id 4649',1500.96,0.00,0.00,2.36,80.24,'2022-05-06 16:35:25','',''),(4576,'1','219','1',1,'Retail Sale Id 4650',2499.48,0.00,0.00,3.93,133.62,'2022-05-06 16:43:31','',''),(4577,'1','219','1',1,'Retail Sale Id 4651',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 16:45:30','',''),(4578,'1','219','1',1,'Retail Sale Id 4652',3199.08,0.00,0.00,5.03,171.02,'2022-05-06 16:48:07','',''),(4579,'1','219','1',1,'Retail Sale Id 4653',5997.48,0.00,0.00,9.43,320.62,'2022-05-06 16:53:32','',''),(4580,'1','219','1',1,'Retail Sale Id 4654',3199.08,0.00,0.00,5.03,171.02,'2022-05-06 16:58:19','',''),(4581,'1','219','1',1,'Retail Sale Id 4655',502.44,0.00,0.00,0.79,26.86,'2022-05-06 17:12:44','',''),(4582,'1','219','1',1,'Retail Sale Id 4656',1901.64,0.00,0.00,2.99,101.66,'2022-05-06 17:17:12','',''),(4583,'1','219','1',1,'Retail Sale Id 4657',3199.08,0.00,0.00,5.03,171.02,'2022-05-06 17:30:17','',''),(4584,'1','219','1',1,'Retail Sale Id 4658',2550.36,0.00,0.00,4.01,136.34,'2022-05-06 17:31:08','',''),(4585,'1','219','1',1,'Retail Sale Id 4659',502.44,0.00,0.00,0.79,26.86,'2022-05-06 17:32:17','',''),(4586,'1','219','1',1,'Retail Sale Id 4660',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 17:34:18','',''),(4587,'1','219','1',1,'Retail Sale Id 4661',597.84,0.00,0.00,0.94,31.96,'2022-05-06 17:41:04','',''),(4588,'1','219','1',1,'Retail Sale Id 4662',1997.04,0.00,0.00,3.14,106.76,'2022-05-06 17:45:37','',''),(4589,'1','219','1',1,'Retail Sale Id 4663',30700.00,0.00,0.00,50.00,600.00,'2022-05-06 18:00:20','',''),(4590,'1','219','1',1,'Retail Sale Id 4664',1500.96,0.00,0.00,2.36,80.24,'2022-05-06 18:01:22','',''),(4591,'1','219','1',1,'Retail Sale Id 4665',648.72,0.00,0.00,1.02,34.68,'2022-05-06 18:02:41','',''),(4592,'1','219','1',1,'Retail Sale Id 4666',3822.36,0.00,0.00,6.01,204.34,'2022-05-06 18:06:34','',''),(4593,'1','219','1',1,'Retail Sale Id 4667',6499.92,0.00,0.00,10.22,347.48,'2022-05-06 18:07:50','',''),(4594,'1','219','1',1,'Retail Sale Id 4668',699.60,0.00,0.00,1.10,37.40,'2022-05-06 18:09:00','',''),(4595,'1','219','1',1,'Retail Sale Id 4669',502.44,0.00,0.00,0.79,26.86,'2022-05-06 18:12:15','',''),(4596,'1','219','1',1,'Retail Sale Id 4670',998.52,0.00,0.00,1.57,53.38,'2022-05-06 18:14:59','',''),(4597,'1','219','1',1,'Retail Sale Id 4671',4611.00,0.00,0.00,7.25,246.50,'2022-05-06 19:04:12','',''),(4598,'1','219','1',1,'Retail Sale Id 4672',597.84,0.00,0.00,0.94,31.96,'2022-05-07 07:36:12','',''),(4599,'1','219','1',1,'Retail Sale Id 4673',7950.00,0.00,0.00,12.50,425.00,'2022-05-07 08:14:14','',''),(4600,'1','219','1',1,'Retail Sale Id 4674',3001.92,0.00,0.00,4.72,160.48,'2022-05-07 08:27:38','',''),(4601,'1','219','1',1,'Retail Sale Id 4675',642.36,0.00,0.00,1.01,34.34,'2022-05-07 08:46:14','',''),(4602,'1','219','1',1,'Retail Sale Id 4676',1500.96,0.00,0.00,2.36,80.24,'2022-05-07 09:39:48','',''),(4603,'1','219','1',1,'Retail Sale Id 4677',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 09:57:37','',''),(4604,'1','219','1',1,'Retail Sale Id 4678',1297.44,0.00,0.00,2.04,69.36,'2022-05-07 10:00:50','',''),(4605,'1','219','1',1,'Retail Sale Id 4679',1500.96,0.00,0.00,2.36,80.24,'2022-05-07 10:03:05','',''),(4606,'1','219','1',1,'Retail Sale Id 4680',2550.36,0.00,0.00,4.01,136.34,'2022-05-07 10:11:37','',''),(4607,'1','219','1',1,'Retail Sale Id 4681',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 10:13:21','',''),(4608,'1','219','1',1,'Retail Sale Id 4682',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 10:32:24','',''),(4609,'1','219','1',1,'Retail Sale Id 4683',1500.96,0.00,0.00,2.36,80.24,'2022-05-07 10:36:52','',''),(4610,'1','219','1',1,'Retail Sale Id 4685',3199.08,0.00,0.00,5.03,171.02,'2022-05-07 10:47:58','',''),(4611,'1','219','1',1,'Retail Sale Id 4686',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 10:49:40','',''),(4612,'1','219','1',1,'Retail Sale Id 4687',137536.00,0.00,0.00,224.00,2688.00,'2022-05-07 11:00:37','',''),(4613,'1','219','1',1,'Retail Sale Id 4688',1297.44,0.00,0.00,2.04,69.36,'2022-05-07 11:03:35','',''),(4614,'1','219','1',1,'Retail Sale Id 4688',1908.00,0.00,0.00,3.00,102.00,'2022-05-07 11:03:35','',''),(4615,'1','219','1',1,'Retail Sale Id 4688',1908.00,0.00,0.00,3.00,102.00,'2022-05-07 11:03:35','',''),(4616,'1','219','1',1,'Retail Sale Id 4689',132624.00,0.00,0.00,216.00,2592.00,'2022-05-07 11:12:29','',''),(4617,'1','219','1',1,'Retail Sale Id 4690',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 11:14:22','',''),(4618,'1','219','1',1,'Retail Sale Id 4691',1799.88,0.00,0.00,2.83,96.22,'2022-05-07 11:27:22','',''),(4619,'1','219','1',1,'Retail Sale Id 4692',6360.00,0.00,0.00,10.00,340.00,'2022-05-07 11:34:15','',''),(4620,'1','219','1',1,'Retail Sale Id 4693',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 11:44:34','',''),(4621,'1','219','1',1,'Retail Sale Id 4694',3180.00,0.00,0.00,5.00,170.00,'2022-05-07 11:45:39','',''),(4622,'1','219','1',1,'Return of Retail Sale Id 4687',0.00,137536.00,224.00,0.00,-2688.00,'2022-05-07 11:45:46','',''),(4623,'1','219','1',1,'Retail Sale Id 4695',7950.00,0.00,0.00,12.50,425.00,'2022-05-07 11:47:20','',''),(4624,'1','219','1',1,'Retail Sale Id 4696',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 11:48:15','',''),(4625,'1','219','1',1,'Retail Sale Id 4697',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 11:49:05','',''),(4626,'1','219','1',1,'Retail Sale Id 4698',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 11:49:57','',''),(4627,'1','219','1',1,'Retail Sale Id 4699',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 11:50:42','',''),(4628,'1','219','1',1,'Retail Sale Id 4700',3199.08,0.00,0.00,5.03,171.02,'2022-05-07 11:52:03','',''),(4629,'1','219','1',1,'Retail Sale Id 4701',3199.08,0.00,0.00,5.03,171.02,'2022-05-07 11:52:53','',''),(4630,'1','219','1',1,'Retail Sale Id 4702',1908.00,0.00,0.00,3.00,102.00,'2022-05-07 11:59:44','',''),(4631,'1','219','1',1,'Retail Sale Id 4703',1297.44,0.00,0.00,2.04,69.36,'2022-05-07 12:08:19','',''),(4632,'1','219','1',1,'Retail Sale Id 4704',6360.00,0.00,0.00,10.00,340.00,'2022-05-07 12:18:01','',''),(4633,'1','219','1',1,'Retail Sale Id 4705',1908.00,0.00,0.00,3.00,102.00,'2022-05-07 12:22:24','',''),(4634,'1','219','1',1,'Retail Sale Id 4706',1908.00,0.00,0.00,3.00,102.00,'2022-05-07 12:23:45','',''),(4635,'1','219','1',1,'Retail Sale Id 4707',1500.96,0.00,0.00,2.36,80.24,'2022-05-07 12:30:07','',''),(4636,'1','219','1',1,'Retail Sale Id 4708',7950.00,0.00,0.00,12.50,425.00,'2022-05-07 12:41:05','',''),(4637,'1','219','1',1,'Retail Sale Id 4710',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 13:08:06','',''),(4638,'1','219','1',1,'Retail Sale Id 4711',502.44,0.00,0.00,0.79,26.86,'2022-05-07 13:08:52','',''),(4639,'1','219','1',1,'Retail Sale Id 4712',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 13:11:15','',''),(4640,'1','219','1',1,'Retail Sale Id 4713',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 13:28:24','',''),(4641,'1','219','1',1,'Retail Sale Id 4714',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 13:44:47','',''),(4642,'1','219','1',1,'Retail Sale Id 4715',998.52,0.00,0.00,1.57,53.38,'2022-05-07 13:58:40','',''),(4643,'1','219','1',1,'Retail Sale Id 4716',6360.00,0.00,0.00,10.00,340.00,'2022-05-07 14:07:49','',''),(4644,'1','219','1',1,'Retail Sale Id 4717',6360.00,0.00,0.00,10.00,340.00,'2022-05-07 14:09:57','',''),(4645,'1','219','1',1,'Retail Sale Id 4718',2550.36,0.00,0.00,4.01,136.34,'2022-05-07 14:22:50','',''),(4646,'1','219','1',1,'Retail Sale Id 4719',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 14:38:09','',''),(4647,'1','219','1',1,'Retail Sale Id 4720',2499.48,0.00,0.00,3.93,133.62,'2022-05-07 14:39:13','',''),(4648,'1','219','1',1,'Retail Sale Id 4721',1500.96,0.00,0.00,2.36,80.24,'2022-05-07 14:48:09','',''),(4649,'1','219','1',1,'Retail Sale Id 4722',801.36,0.00,0.00,1.26,42.84,'2022-05-07 14:52:41','',''),(4650,'1','219','1',1,'Retail Sale Id 4723',4998.96,0.00,0.00,7.86,267.24,'2022-05-07 15:02:30','',''),(4651,'1','219','1',1,'Retail Sale Id 4724',1901.64,0.00,0.00,2.99,101.66,'2022-05-07 15:06:57','',''),(4652,'1','219','1',1,'Retail Sale Id 4724',1901.64,0.00,0.00,2.99,101.66,'2022-05-07 15:06:57','',''),(4653,'1','219','1',1,'Retail Sale Id 4725',3199.08,0.00,0.00,5.03,171.02,'2022-05-07 15:08:22','',''),(4654,'1','219','1',1,'Retail Sale Id 4726',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 15:17:39','',''),(4655,'1','219','1',1,'Retail Sale Id 4727',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 15:25:50','',''),(4656,'1','219','1',1,'Retail Sale Id 4728',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 15:27:14','',''),(4657,'1','219','1',1,'Retail Sale Id 4730',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 15:38:50','',''),(4658,'1','219','1',1,'Retail Sale Id 4731',1202.04,0.00,0.00,1.89,64.26,'2022-05-07 15:40:58','',''),(4659,'1','219','1',1,'Retail Sale Id 4732',3180.00,0.00,0.00,5.00,170.00,'2022-05-07 15:41:54','',''),(4660,'1','219','1',1,'Retail Sale Id 4733',3498.00,0.00,0.00,5.50,187.00,'2022-05-07 15:45:13','',''),(4661,'1','219','1',1,'Retail Sale Id 4734',1500.96,0.00,0.00,2.36,80.24,'2022-05-07 15:50:20','',''),(4662,'1','219','1',1,'Retail Sale Id 4735',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 15:58:46','',''),(4663,'1','219','1',1,'Retail Sale Id 4736',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 16:18:47','',''),(4664,'1','219','1',1,'Retail Sale Id 4737',49120.00,0.00,0.00,80.00,960.00,'2022-05-07 16:25:53','',''),(4665,'1','219','1',1,'Retail Sale Id 4738',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 16:33:08','',''),(4666,'1','219','1',1,'Retail Sale Id 4739',7950.00,0.00,0.00,12.50,425.00,'2022-05-07 16:35:01','',''),(4667,'1','219','1',1,'Retail Sale Id 4740',4998.96,0.00,0.00,7.86,267.24,'2022-05-07 16:40:34','',''),(4668,'1','219','1',1,'Retail Sale Id 4741',7950.00,0.00,0.00,12.50,425.00,'2022-05-07 16:53:48','',''),(4669,'1','219','1',1,'Retail Sale Id 4742',1908.00,0.00,0.00,3.00,102.00,'2022-05-07 16:58:02','',''),(4670,'1','219','1',1,'Retail Sale Id 4743',1297.44,0.00,0.00,2.04,69.36,'2022-05-07 17:00:44','',''),(4671,'1','219','1',1,'Retail Sale Id 4744',1297.44,0.00,0.00,2.04,69.36,'2022-05-07 17:07:20','',''),(4672,'1','219','1',1,'Retail Sale Id 4745',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 17:19:46','',''),(4673,'1','219','1',1,'Retail Sale Id 4746',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 17:25:11','',''),(4674,'1','219','1',1,'Retail Sale Id 4747',1997.04,0.00,0.00,3.14,106.76,'2022-05-07 17:26:42','',''),(4675,'1','219','1',1,'Retail Sale Id 4748',642.36,0.00,0.00,1.01,34.34,'2022-05-07 17:30:46','',''),(4676,'1','219','1',1,'Retail Sale Id 4749',1297.44,0.00,0.00,2.04,69.36,'2022-05-07 17:47:12','',''),(4677,'1','219','1',1,'Retail Sale Id 4750',699.60,0.00,0.00,1.10,37.40,'2022-05-07 17:53:24','',''),(4678,'1','219','1',1,'Retail Sale Id 4751',3822.36,0.00,0.00,6.01,204.34,'2022-05-07 17:58:41','',''),(4679,'1','219','1',1,'Retail Sale Id 4752',38682.00,0.00,0.00,63.00,756.00,'2022-05-07 18:02:46','',''),(4680,'1','219','1',1,'Retail Sale Id 4753',998.52,0.00,0.00,1.57,53.38,'2022-05-07 18:14:32','',''),(4681,'1','219','1',1,'Retail Sale Id 4754',1500.96,0.00,0.00,2.36,80.24,'2022-05-07 18:15:34','',''),(4682,'1','219','1',1,'Retail Sale Id 4755',2499.48,0.00,0.00,3.93,133.62,'2022-05-07 18:20:53','',''),(4683,'1','219','1',1,'Retail Sale Id 4756',1500.96,0.00,0.00,2.36,80.24,'2022-05-07 18:33:04','',''),(4684,'1','219','1',1,'Retail Sale Id 4757',1500.96,0.00,0.00,2.36,80.24,'2022-05-07 18:46:57','',''),(4685,'1','219','1',1,'Retail Sale Id 4758',1602.72,0.00,0.00,2.52,85.68,'2022-05-07 18:55:59','',''),(4686,'1','219','1',1,'Retail Sale Id 4759',400.68,0.00,0.00,0.63,21.42,'2022-05-08 07:33:31','',''),(4687,'1','219','1',1,'Distributed to OPERATIONAL LOST for sales id:7',90300.00,0.00,0.00,150.00,0.00,'2022-05-08 07:36:09','',''),(4688,'1','219','1',1,'Retail Sale Id 4760',1500.96,0.00,0.00,2.36,80.24,'2022-05-08 07:53:24','',''),(4689,'1','219','1',1,'Retail Sale Id 4762',3822.36,0.00,0.00,6.01,204.34,'2022-05-08 07:55:39','',''),(4690,'1','219','1',1,'Retail Sale Id 4763',3180.00,0.00,0.00,5.00,170.00,'2022-05-08 08:08:11','',''),(4691,'1','219','1',1,'Retail Sale Id 4764',3822.36,0.00,0.00,6.01,204.34,'2022-05-08 08:53:41','',''),(4692,'1','219','1',1,'Retail Sale Id 4765',7950.00,0.00,0.00,12.50,425.00,'2022-05-08 08:54:35','',''),(4693,'1','219','1',1,'Retail Sale Id 4766',3796.92,0.00,0.00,5.97,202.98,'2022-05-08 09:22:56','',''),(4694,'1','219','1',1,'Retail Sale Id 4767',4452.00,0.00,0.00,7.00,238.00,'2022-05-08 09:36:31','',''),(4695,'1','219','1',1,'Retail Sale Id 4768',1901.64,0.00,0.00,2.99,101.66,'2022-05-08 09:40:28','',''),(4696,'1','219','1',1,'Retail Sale Id 4769',3822.36,0.00,0.00,6.01,204.34,'2022-05-08 09:45:19','',''),(4697,'1','219','1',1,'Retail Sale Id 4770',2498.98,0.00,0.00,4.07,48.84,'2022-05-08 09:47:24','',''),(4698,'1','219','1',1,'Retail Sale Id 4771',1500.96,0.00,0.00,2.36,80.24,'2022-05-08 15:08:26','',''),(4699,'1','219','1',1,'Retail Sale Id 4772',3001.92,0.00,0.00,4.72,160.48,'2022-05-08 15:09:08','',''),(4700,'1','219','1',1,'Retail Sale Id 4773',1297.44,0.00,0.00,2.04,69.36,'2022-05-08 15:10:29','',''),(4701,'1','219','1',1,'Retail Sale Id 4774',3898.68,0.00,0.00,6.13,208.42,'2022-05-08 15:11:10','',''),(4702,'1','219','1',1,'Retail Sale Id 4775',3180.00,0.00,0.00,5.00,170.00,'2022-05-08 15:13:15','',''),(4703,'1','219','1',1,'Retail Sale Id 4777',502.44,0.00,0.00,0.79,26.86,'2022-05-08 15:14:32','',''),(4704,'1','219','1',1,'Retail Sale Id 4778',2448.60,0.00,0.00,3.85,130.90,'2022-05-08 15:16:18','',''),(4705,'1','219','1',1,'Retail Sale Id 4779',3180.00,0.00,0.00,5.00,170.00,'2022-05-08 15:17:38','',''),(4706,'1','219','1',1,'Retail Sale Id 4780',3822.36,0.00,0.00,6.01,204.34,'2022-05-08 15:18:35','',''),(4707,'1','219','1',1,'Retail Sale Id 4781',1920.72,0.00,0.00,3.02,102.68,'2022-05-08 15:19:36','',''),(4708,'1','219','1',1,'Retail Sale Id 4782',3822.36,0.00,0.00,6.01,204.34,'2022-05-08 15:20:42','',''),(4709,'1','219','1',1,'Retail Sale Id 4783',2448.60,0.00,0.00,3.85,130.90,'2022-05-08 15:32:16','',''),(4710,'1','219','1',1,'Retail Sale Id 4784',1100.28,0.00,0.00,1.73,58.82,'2022-05-08 15:37:30','',''),(4711,'1','219','1',1,'Retail Sale Id 4785',1202.04,0.00,0.00,1.89,64.26,'2022-05-08 15:39:49','',''),(4712,'1','219','1',1,'Retail Sale Id 4786',1908.00,0.00,0.00,3.00,102.00,'2022-05-08 15:50:01','',''),(4713,'1','219','1',1,'Retail Sale Id 4787',8000.88,0.00,0.00,12.58,427.72,'2022-05-08 15:54:11','',''),(4714,'1','219','1',1,'Retail Sale Id 4788',998.52,0.00,0.00,1.57,53.38,'2022-05-08 15:58:54','',''),(4715,'1','219','1',1,'Retail Sale Id 4789',3180.00,0.00,0.00,5.00,170.00,'2022-05-08 16:02:00','',''),(4716,'1','219','1',1,'Retail Sale Id 4790',1500.96,0.00,0.00,2.36,80.24,'2022-05-08 16:03:05','',''),(4717,'1','219','1',1,'Retail Sale Id 4791',998.52,0.00,0.00,1.57,53.38,'2022-05-08 16:07:49','',''),(4718,'1','219','1',1,'Retail Sale Id 4792',597.84,0.00,0.00,0.94,31.96,'2022-05-08 16:09:40','',''),(4719,'1','219','1',1,'Retail Sale Id 4793',4298.00,0.00,0.00,7.00,84.00,'2022-05-08 16:18:30','',''),(4720,'1','219','1',1,'Retail Sale Id 4794',527.88,0.00,0.00,0.83,28.22,'2022-05-08 16:21:40','',''),(4721,'1','219','1',1,'Retail Sale Id 4795',0.00,0.00,0.00,0.00,0.00,'2022-05-08 16:23:36','',''),(4722,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,3551198.00,5899.00,0.00,0.00,'2022-05-08 16:24:39','',''),(4723,'1','219',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,5899.00,0.00,'2022-05-08 16:25:56','',''),(4724,'1','219','1',1,'Received from bridging 11',0.00,0.00,5899.00,0.00,0.00,'2022-05-08 16:25:56','',''),(4725,'1','219','1',1,'Retail Sale Id 4796',144290.00,0.00,0.00,235.00,2820.00,'2022-05-08 16:27:11','',''),(4726,'1','219','1',1,'Return of Retail Sale Id 4796',0.00,144290.00,235.00,0.00,-2820.00,'2022-05-08 16:28:16','',''),(4727,'1','219','1',1,'Retail Sale Id 4797',1908.00,0.00,0.00,3.00,102.00,'2022-05-08 16:30:40','',''),(4728,'1','219','1',1,'Retail Sale Id 4798',1908.00,0.00,0.00,3.00,102.00,'2022-05-08 16:31:33','',''),(4729,'1','219','1',1,'Retail Sale Id 4799',4912.00,0.00,0.00,8.00,96.00,'2022-05-08 16:33:44','',''),(4730,'1','219','1',1,'Retail Sale Id 4800',1920.72,0.00,0.00,3.02,102.68,'2022-05-08 16:39:59','',''),(4731,'1','219','1',1,'Retail Sale Id 4801',801.36,0.00,0.00,1.26,42.84,'2022-05-08 16:41:02','',''),(4732,'1','219','1',1,'Retail Sale Id 4802',1228.00,0.00,0.00,2.00,24.00,'2022-05-08 16:42:11','',''),(4733,'1','219','1',1,'Retail Sale Id 4803',3822.36,0.00,0.00,6.01,204.34,'2022-05-08 16:45:10','',''),(4734,'1','219','1',1,'Retail Sale Id 4804',3822.36,0.00,0.00,6.01,204.34,'2022-05-08 16:46:23','',''),(4735,'1','219','1',1,'Retail Sale Id 4805',3682.44,0.00,0.00,5.79,196.86,'2022-05-08 16:47:44','',''),(4736,'1','219','1',1,'Retail Sale Id 4806',144290.00,0.00,0.00,235.00,2820.00,'2022-05-08 16:50:30','',''),(4737,'1','219','1',1,'Retail Sale Id 4808',1500.96,0.00,0.00,2.36,80.24,'2022-05-08 16:51:53','',''),(4738,'1','219','1',1,'Retail Sale Id 4809',1602.72,0.00,0.00,2.52,85.68,'2022-05-08 16:52:56','',''),(4739,'1','219','1',1,'Retail Sale Id 4810',2232.36,0.00,0.00,3.51,119.34,'2022-05-08 16:54:38','',''),(4740,'1','219','1',1,'Retail Sale Id 4813',5526.00,0.00,0.00,9.00,108.00,'2022-05-08 17:00:58','',''),(4741,'1','219','1',1,'Retail Sale Id 4814',998.52,0.00,0.00,1.57,53.38,'2022-05-08 17:03:57','',''),(4742,'1','219','1',1,'Retail Sale Id 4815',298.92,0.00,0.00,0.47,15.98,'2022-05-08 17:04:59','',''),(4743,'1','219','1',1,'Retail Sale Id 4816',3822.36,0.00,0.00,6.01,204.34,'2022-05-08 17:06:22','',''),(4744,'1','219','1',1,'Retail Sale Id 4817',1997.04,0.00,0.00,3.14,106.76,'2022-05-08 17:07:09','',''),(4745,'1','219','1',1,'Retail Sale Id 4818',6360.00,0.00,0.00,10.00,340.00,'2022-05-08 17:21:22','',''),(4746,'1','219','1',1,'Retail Sale Id 4819',3180.00,0.00,0.00,5.00,170.00,'2022-05-08 17:25:32','',''),(4747,'1','219','1',1,'Retail Sale Id 4820',7724.12,0.00,0.00,12.58,150.96,'2022-05-08 17:30:09','',''),(4748,'1','219','1',1,'Retail Sale Id 4821',2550.36,0.00,0.00,4.01,136.34,'2022-05-08 17:36:15','',''),(4749,'1','219','1',1,'Retail Sale Id 4822',699.60,0.00,0.00,1.10,37.40,'2022-05-08 17:37:28','',''),(4750,'1','219','1',1,'Retail Sale Id 4823',30700.00,0.00,0.00,50.00,600.00,'2022-05-08 17:41:38','',''),(4751,'1','219','1',1,'Retail Sale Id 4824',642.36,0.00,0.00,1.01,34.34,'2022-05-08 17:43:38','',''),(4752,'1','219','1',1,'Retail Sale Id 4825',699.60,0.00,0.00,1.10,37.40,'2022-05-08 17:45:05','',''),(4753,'1','219','1',1,'Retail Sale Id 4826',1500.96,0.00,0.00,2.36,80.24,'2022-05-08 17:46:08','',''),(4754,'1','219','1',1,'Retail Sale Id 4827',1997.04,0.00,0.00,3.14,106.76,'2022-05-08 17:47:48','',''),(4755,'1','219','1',1,'Retail Sale Id 4828',998.52,0.00,0.00,1.57,53.38,'2022-05-08 17:48:37','',''),(4756,'1','219','1',1,'Retail Sale Id 4829',1908.00,0.00,0.00,3.00,102.00,'2022-05-08 18:01:19','',''),(4757,'1','219','1',1,'Retail Sale Id 4830',400.68,0.00,0.00,0.63,21.42,'2022-05-08 18:02:13','',''),(4758,'1','219','1',1,'Retail Sale Id 4831',1908.00,0.00,0.00,3.00,102.00,'2022-05-08 18:08:13','',''),(4759,'1','219','1',1,'Retail Sale Id 4832',3180.00,0.00,0.00,5.00,170.00,'2022-05-08 18:17:32','',''),(4760,'1','219','1',1,'Retail Sale Id 4833',998.52,0.00,0.00,1.57,53.38,'2022-05-08 18:30:33','',''),(4761,'1','219','1',1,'Retail Sale Id 4834',1908.00,0.00,0.00,3.00,102.00,'2022-05-08 18:37:28','',''),(4762,'1','219','1',1,'Retail Sale Id 4835',3701.52,0.00,0.00,5.82,197.88,'2022-05-08 18:38:41','',''),(4763,'1','219','1',1,'Retail Sale Id 4836',3180.00,0.00,0.00,5.00,170.00,'2022-05-08 19:12:54','',''),(4764,'1','219','1',1,'Retail Sale Id 4837',998.52,0.00,0.00,1.57,53.38,'2022-05-08 19:13:53','',''),(4765,'1','219','1',1,'Retail Sale Id 4838',998.52,0.00,0.00,1.57,53.38,'2022-05-08 19:14:39','',''),(4766,'1','219','1',1,'Retail Sale Id 4839',699.60,0.00,0.00,1.10,37.40,'2022-05-08 19:22:14','',''),(4767,'1','219','1',1,'Retail Sale Id 4840',1500.96,0.00,0.00,2.36,80.24,'2022-05-08 19:23:12','',''),(4768,'1','219','1',1,'Retail Sale Id 4841',7950.00,0.00,0.00,12.50,425.00,'2022-05-09 07:23:06','',''),(4769,'1','219','1',1,'Retail Sale Id 4842',4153.08,0.00,0.00,6.53,222.02,'2022-05-09 07:40:41','',''),(4770,'1','219','1',1,'Retail Sale Id 4843',699.60,0.00,0.00,1.10,37.40,'2022-05-09 07:51:29','',''),(4771,'1','219','1',1,'Retail Sale Id 4844',3498.00,0.00,0.00,5.50,187.00,'2022-05-09 07:52:42','',''),(4772,'1','219','1',1,'Retail Sale Id 4846',3847.80,0.00,0.00,6.05,205.70,'2022-05-09 08:00:03','',''),(4773,'1','219','1',1,'Retail Sale Id 4847',1768.08,0.00,0.00,2.78,94.52,'2022-05-09 08:14:40','',''),(4774,'1','219','1',1,'Retail Sale Id 4848',1590.00,0.00,0.00,2.50,85.00,'2022-05-09 08:51:58','',''),(4775,'1','219','1',1,'Retail Sale Id 4848',1590.00,0.00,0.00,2.50,85.00,'2022-05-09 08:51:58','',''),(4776,'1','219','1',1,'Retail Sale Id 4849',648.72,0.00,0.00,1.02,34.68,'2022-05-09 08:54:02','',''),(4777,'1','219','1',1,'Retail Sale Id 4850',3199.08,0.00,0.00,5.03,171.02,'2022-05-09 09:24:03','',''),(4778,'1','219','1',1,'Retail Sale Id 4851',1297.44,0.00,0.00,2.04,69.36,'2022-05-09 09:27:13','',''),(4779,'1','219','1',1,'Retail Sale Id 4852',998.52,0.00,0.00,1.57,53.38,'2022-05-09 09:29:38','',''),(4780,'1','219','1',1,'Retail Sale Id 4853',1997.04,0.00,0.00,3.14,106.76,'2022-05-09 09:33:34','',''),(4781,'1','219','1',1,'Retail Sale Id 4854',3822.36,0.00,0.00,6.01,204.34,'2022-05-09 09:37:11','',''),(4782,'1','219','1',1,'Retail Sale Id 4855',3199.08,0.00,0.00,5.03,171.02,'2022-05-09 09:38:03','',''),(4783,'1','219','1',1,'Retail Sale Id 4856',1997.04,0.00,0.00,3.14,106.76,'2022-05-09 09:48:23','',''),(4784,'1','219','1',1,'Retail Sale Id 4857',2550.36,0.00,0.00,4.01,136.34,'2022-05-09 10:23:41','',''),(4785,'1','219','1',1,'Retail Sale Id 4858',3822.36,0.00,0.00,6.01,204.34,'2022-05-09 10:45:47','',''),(4786,'1','219','1',1,'Retail Sale Id 4859',3001.92,0.00,0.00,4.72,160.48,'2022-05-09 11:13:30','',''),(4787,'1','219','1',1,'Retail Sale Id 4860',92100.00,0.00,0.00,150.00,1800.00,'2022-05-09 11:14:59','',''),(4788,'1','219','1',1,'Retail Sale Id 4861',998.52,0.00,0.00,1.57,53.38,'2022-05-09 11:24:16','',''),(4789,'1','219','1',1,'Retail Sale Id 4862',3822.36,0.00,0.00,6.01,204.34,'2022-05-09 11:39:03','',''),(4790,'1','219','1',1,'Retail Sale Id 4863',4458.36,0.00,0.00,7.01,238.34,'2022-05-09 11:44:48','',''),(4791,'1','219','1',1,'Retail Sale Id 4864',5743.08,0.00,0.00,9.03,307.02,'2022-05-09 11:49:20','',''),(4792,'1','219','1',1,'Retail Sale Id 4865',6140.00,0.00,0.00,10.00,120.00,'2022-05-09 11:52:08','',''),(4793,'1','219','1',1,'Retail Sale Id 4866',4912.00,0.00,0.00,8.00,96.00,'2022-05-09 11:54:27','',''),(4794,'1','219','1',1,'Retail Sale Id 4867',1997.04,0.00,0.00,3.14,106.76,'2022-05-09 12:34:21','',''),(4795,'1','219','1',1,'Retail Sale Id 4867',1997.04,0.00,0.00,3.14,106.76,'2022-05-09 12:34:21','',''),(4796,'1','219','1',1,'Retail Sale Id 4868',41138.00,0.00,0.00,67.00,804.00,'2022-05-09 12:55:37','',''),(4797,'1','219','1',1,'Retail Sale Id 4869',2550.36,0.00,0.00,4.01,136.34,'2022-05-09 13:03:04','',''),(4798,'1','219','1',1,'Retail Sale Id 4870',3199.08,0.00,0.00,5.03,171.02,'2022-05-09 13:04:36','',''),(4799,'1','219','1',1,'Retail Sale Id 4871',3822.36,0.00,0.00,6.01,204.34,'2022-05-09 13:09:34','',''),(4800,'1','219','1',1,'Retail Sale Id 4872',3199.08,0.00,0.00,5.03,171.02,'2022-05-09 13:15:39','',''),(4801,'1','219','1',1,'Retail Sale Id 4873',1908.00,0.00,0.00,3.00,102.00,'2022-05-09 13:17:05','',''),(4802,'1','219','1',1,'Retail Sale Id 4874',699.60,0.00,0.00,1.10,37.40,'2022-05-09 13:46:24','',''),(4803,'1','219','1',1,'Retail Sale Id 4875',7950.00,0.00,0.00,12.50,425.00,'2022-05-09 13:51:15','',''),(4804,'1','219','1',1,'Retail Sale Id 4876',3199.08,0.00,0.00,5.03,171.02,'2022-05-09 13:57:06','',''),(4805,'1','219','1',1,'Retail Sale Id 4877',3001.92,0.00,0.00,4.72,160.48,'2022-05-09 14:30:54','',''),(4806,'1','219','1',1,'Retail Sale Id 4878',1278.36,0.00,0.00,2.01,68.34,'2022-05-09 14:38:13','',''),(4807,'1','219','1',1,'Retail Sale Id 4879',3199.08,0.00,0.00,5.03,171.02,'2022-05-09 14:52:27','',''),(4808,'1','219','1',1,'Retail Sale Id 4880',3199.08,0.00,0.00,5.03,171.02,'2022-05-09 15:00:39','',''),(4809,'1','219','1',1,'Retail Sale Id 4881',3822.36,0.00,0.00,6.01,204.34,'2022-05-09 15:15:16','',''),(4810,'1','219','1',1,'Retail Sale Id 4882',998.52,0.00,0.00,1.57,53.38,'2022-05-09 15:18:29','',''),(4811,'1','219','1',1,'Retail Sale Id 4883',7950.00,0.00,0.00,12.50,425.00,'2022-05-09 15:26:29','',''),(4812,'1','219','1',1,'Retail Sale Id 4884',648.72,0.00,0.00,1.02,34.68,'2022-05-09 15:43:02','',''),(4813,'1','219','1',1,'Retail Sale Id 4885',8000.88,0.00,0.00,12.58,427.72,'2022-05-09 15:50:07','',''),(4814,'1','219','1',1,'Retail Sale Id 4886',3822.36,0.00,0.00,6.01,204.34,'2022-05-09 15:55:18','',''),(4815,'1','219','1',1,'Retail Sale Id 4886',7950.00,0.00,0.00,12.50,425.00,'2022-05-09 15:55:18','',''),(4816,'1','219','1',1,'Retail Sale Id 4887',1500.96,0.00,0.00,2.36,80.24,'2022-05-09 15:56:48','',''),(4817,'1','219','1',1,'Retail Sale Id 4888',7675.00,0.00,0.00,12.50,150.00,'2022-05-09 15:59:44','',''),(4818,'1','219','1',1,'Retail Sale Id 4889',3822.36,0.00,0.00,6.01,204.34,'2022-05-09 16:03:37','',''),(4819,'1','219','1',1,'Retail Sale Id 4890',2550.36,0.00,0.00,4.01,136.34,'2022-05-09 16:24:35','',''),(4820,'1','219','1',1,'Retail Sale Id 4891',7950.00,0.00,0.00,12.50,425.00,'2022-05-09 16:28:51','',''),(4821,'1','219','1',1,'Retail Sale Id 4894',3001.92,0.00,0.00,4.72,160.48,'2022-05-09 16:39:11','',''),(4822,'1','219','1',1,'Retail Sale Id 4895',2499.48,0.00,0.00,3.93,133.62,'2022-05-09 16:41:10','',''),(4823,'1','219','1',1,'Retail Sale Id 4896',3822.36,0.00,0.00,6.01,204.34,'2022-05-09 16:42:19','',''),(4824,'1','219','1',1,'Retail Sale Id 4897',3199.08,0.00,0.00,5.03,171.02,'2022-05-09 16:43:39','',''),(4825,'1','219','1',1,'Retail Sale Id 4898',7950.00,0.00,0.00,12.50,425.00,'2022-05-09 16:46:45','',''),(4826,'1','219','1',1,'Retail Sale Id 4900',23000.44,0.00,0.00,37.46,449.52,'2022-05-09 16:50:38','',''),(4827,'1','219','1',1,'Retail Sale Id 4901',3822.36,0.00,0.00,6.01,204.34,'2022-05-09 16:53:36','',''),(4828,'1','219','1',1,'Retail Sale Id 4902',3816.00,0.00,0.00,6.00,204.00,'2022-05-09 16:56:27','',''),(4829,'1','219','1',1,'Retail Sale Id 4903',6360.00,0.00,0.00,10.00,340.00,'2022-05-09 16:59:20','',''),(4830,'1','219','1',1,'Retail Sale Id 4904',801.36,0.00,0.00,1.26,42.84,'2022-05-09 17:00:56','',''),(4831,'1','219','1',1,'Retail Sale Id 4905',1602.72,0.00,0.00,2.52,85.68,'2022-05-09 17:02:14','',''),(4832,'1','219','1',1,'Retail Sale Id 4906',1500.96,0.00,0.00,2.36,80.24,'2022-05-09 17:03:49','',''),(4833,'1','219','1',1,'Retail Sale Id 4907',998.52,0.00,0.00,1.57,53.38,'2022-05-09 17:05:18','',''),(4834,'1','219','1',1,'Retail Sale Id 4908',4000.44,0.00,0.00,6.29,213.86,'2022-05-09 17:06:50','',''),(4835,'1','219','1',1,'Retail Sale Id 4909',502.44,0.00,0.00,0.79,26.86,'2022-05-09 17:08:15','',''),(4836,'1','219','1',1,'Retail Sale Id 4910',1908.00,0.00,0.00,3.00,102.00,'2022-05-09 17:09:58','',''),(4837,'1','219','1',1,'Retail Sale Id 4911',3199.08,0.00,0.00,5.03,171.02,'2022-05-09 17:20:04','',''),(4838,'1','219','1',1,'Retail Sale Id 4912',3199.08,0.00,0.00,5.03,171.02,'2022-05-09 17:21:34','',''),(4839,'1','219','1',1,'Retail Sale Id 4913',1500.96,0.00,0.00,2.36,80.24,'2022-05-09 17:26:31','',''),(4840,'1','219','1',1,'Retail Sale Id 4914',1297.44,0.00,0.00,2.04,69.36,'2022-05-09 17:27:28','',''),(4841,'1','219','1',1,'Retail Sale Id 4915',3822.36,0.00,0.00,6.01,204.34,'2022-05-09 17:32:36','',''),(4842,'1','219','1',1,'Retail Sale Id 4916',6398.16,0.00,0.00,10.06,342.04,'2022-05-09 17:35:19','',''),(4843,'1','219','1',1,'Retail Sale Id 4917',1997.04,0.00,0.00,3.14,106.76,'2022-05-09 17:36:15','',''),(4844,'1','219','1',1,'Retail Sale Id 4918',998.52,0.00,0.00,1.57,53.38,'2022-05-09 17:37:13','',''),(4845,'1','219','1',1,'Retail Sale Id 4919',7950.00,0.00,0.00,12.50,425.00,'2022-05-09 17:38:08','',''),(4846,'1','219','1',1,'Retail Sale Id 4920',1997.04,0.00,0.00,3.14,106.76,'2022-05-09 17:39:08','',''),(4847,'1','219','1',1,'Retail Sale Id 4921',1997.04,0.00,0.00,3.14,106.76,'2022-05-09 17:40:04','',''),(4848,'1','219','1',1,'Retail Sale Id 4922',699.60,0.00,0.00,1.10,37.40,'2022-05-09 17:50:55','',''),(4849,'1','219','1',1,'Retail Sale Id 4923',597.84,0.00,0.00,0.94,31.96,'2022-05-09 17:54:49','',''),(4850,'1','219','1',1,'Retail Sale Id 4925',7950.00,0.00,0.00,12.50,425.00,'2022-05-09 18:01:33','',''),(4851,'1','219','1',1,'Retail Sale Id 4926',1997.04,0.00,0.00,3.14,106.76,'2022-05-10 07:45:49','',''),(4852,'1','219','1',1,'Retail Sale Id 4927',1500.96,0.00,0.00,2.36,80.24,'2022-05-10 08:16:17','',''),(4853,'1','219','1',1,'Retail Sale Id 4928',33770.00,0.00,0.00,55.00,660.00,'2022-05-10 08:20:34','',''),(4854,'1','219','1',1,'Retail Sale Id 4929',3498.00,0.00,0.00,5.50,187.00,'2022-05-10 08:24:46','',''),(4855,'1','219','1',1,'Retail Sale Id 4930',1997.04,0.00,0.00,3.14,106.76,'2022-05-10 08:56:02','',''),(4856,'1','219','1',1,'Retail Sale Id 4930',1997.04,0.00,0.00,3.14,106.76,'2022-05-10 08:56:02','',''),(4857,'1','219','1',1,'Retail Sale Id 4931',1297.44,0.00,0.00,2.04,69.36,'2022-05-10 08:59:01','',''),(4858,'1','219','1',1,'Retail Sale Id 4931',1698.12,0.00,0.00,2.67,90.78,'2022-05-10 08:59:01','',''),(4859,'1','219','1',1,'Retail Sale Id 4932',1202.04,0.00,0.00,1.89,64.26,'2022-05-10 09:19:26','',''),(4860,'1','219','1',1,'Retail Sale Id 4933',3001.92,0.00,0.00,4.72,160.48,'2022-05-10 09:21:59','',''),(4861,'1','219','1',1,'Retail Sale Id 4934',1202.04,0.00,0.00,1.89,64.26,'2022-05-10 09:32:12','',''),(4862,'1','219','1',1,'Retail Sale Id 4935',6360.00,0.00,0.00,10.00,340.00,'2022-05-10 09:47:05','',''),(4863,'1','219','1',1,'Retail Sale Id 4936',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 09:54:27','',''),(4864,'1','219','1',1,'Retail Sale Id 4937',7199.52,0.00,0.00,11.32,384.88,'2022-05-10 09:59:32','',''),(4865,'1','219','1',1,'Retail Sale Id 4938',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 10:22:29','',''),(4866,'1','219','1',1,'Retail Sale Id 4939',502.44,0.00,0.00,0.79,26.86,'2022-05-10 10:26:29','',''),(4867,'1','219','1',1,'Retail Sale Id 4940',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 10:36:01','',''),(4868,'1','219','1',1,'Retail Sale Id 4941',998.52,0.00,0.00,1.57,53.38,'2022-05-10 10:48:32','',''),(4869,'1','219','1',1,'Retail Sale Id 4942',1297.44,0.00,0.00,2.04,69.36,'2022-05-10 10:56:02','',''),(4870,'1','219','1',1,'Retail Sale Id 4943',998.52,0.00,0.00,1.57,53.38,'2022-05-10 10:57:03','',''),(4871,'1','219','1',1,'Retail Sale Id 4944',3180.00,0.00,0.00,5.00,170.00,'2022-05-10 10:59:14','',''),(4872,'1','219','1',1,'Retail Sale Id 4944',3180.00,0.00,0.00,5.00,170.00,'2022-05-10 10:59:14','',''),(4873,'1','219','1',1,'Retail Sale Id 4944',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 10:59:14','',''),(4874,'1','219','1',1,'Retail Sale Id 4945',3001.92,0.00,0.00,4.72,160.48,'2022-05-10 11:08:38','',''),(4875,'1','219','1',1,'Retail Sale Id 4946',1997.04,0.00,0.00,3.14,106.76,'2022-05-10 11:09:50','',''),(4876,'1','219','1',1,'Retail Sale Id 4947',998.52,0.00,0.00,1.57,53.38,'2022-05-10 11:21:59','',''),(4877,'1','219','1',1,'Retail Sale Id 4948',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 11:33:53','',''),(4878,'1','219','1',1,'Retail Sale Id 4949',400.68,0.00,0.00,0.63,21.42,'2022-05-10 11:40:29','',''),(4879,'1','219','1',1,'Retail Sale Id 4950',3001.92,0.00,0.00,4.72,160.48,'2022-05-10 12:02:09','',''),(4880,'1','219','1',1,'Retail Sale Id 4951',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 12:03:27','',''),(4881,'1','219','1',1,'Retail Sale Id 4953',61400.00,0.00,0.00,100.00,1200.00,'2022-05-10 12:06:06','',''),(4882,'1','219','1',1,'Retail Sale Id 4954',7950.00,0.00,0.00,12.50,425.00,'2022-05-10 12:09:24','',''),(4883,'1','219','1',1,'Retail Sale Id 4955',7950.00,0.00,0.00,12.50,425.00,'2022-05-10 12:26:05','',''),(4884,'1','219','1',1,'Retail Sale Id 4956',699.60,0.00,0.00,1.10,37.40,'2022-05-10 12:35:45','',''),(4885,'1','219','1',1,'Retail Sale Id 4957',960.36,0.00,0.00,1.51,51.34,'2022-05-10 12:39:49','',''),(4886,'1','219','1',1,'Retail Sale Id 4957',960.36,0.00,0.00,1.51,51.34,'2022-05-10 12:39:49','',''),(4887,'1','219','1',1,'Retail Sale Id 4958',1297.44,0.00,0.00,2.04,69.36,'2022-05-10 13:01:29','',''),(4888,'1','219','1',1,'Retail Sale Id 4959',3180.00,0.00,0.00,5.00,170.00,'2022-05-10 13:21:18','',''),(4889,'1','219','1',1,'Retail Sale Id 4960',3180.00,0.00,0.00,5.00,170.00,'2022-05-10 13:39:46','',''),(4890,'1','219','1',1,'Retail Sale Id 4961',4000.44,0.00,0.00,6.29,213.86,'2022-05-10 13:51:21','',''),(4891,'1','219','1',1,'Retail Sale Id 4962',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 14:16:46','',''),(4892,'1','219','1',1,'Retail Sale Id 4963',1297.44,0.00,0.00,2.04,69.36,'2022-05-10 14:25:02','',''),(4893,'1','219','1',1,'Retail Sale Id 4964',1997.04,0.00,0.00,3.14,106.76,'2022-05-10 14:26:00','',''),(4894,'1','219','1',1,'Retail Sale Id 4965',3199.08,0.00,0.00,5.03,171.02,'2022-05-10 14:28:53','',''),(4895,'1','219','1',1,'Retail Sale Id 4966',1500.96,0.00,0.00,2.36,80.24,'2022-05-10 14:42:43','',''),(4896,'1','219','1',1,'Retail Sale Id 4967',998.52,0.00,0.00,1.57,53.38,'2022-05-10 14:43:29','',''),(4897,'1','219','1',1,'Retail Sale Id 4968',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 14:53:56','',''),(4898,'1','219','1',1,'Retail Sale Id 4969',4000.44,0.00,0.00,6.29,213.86,'2022-05-10 15:07:12','',''),(4899,'1','219','1',1,'Retail Sale Id 4970',3097.32,0.00,0.00,4.87,165.58,'2022-05-10 15:16:08','',''),(4900,'1','219','1',1,'Retail Sale Id 4971',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 15:29:18','',''),(4901,'1','219','1',1,'Retail Sale Id 4972',3180.00,0.00,0.00,5.00,170.00,'2022-05-10 15:36:13','',''),(4902,'1','219','1',1,'Retail Sale Id 4973',6201.00,0.00,0.00,9.75,331.50,'2022-05-10 15:50:51','',''),(4903,'1','219','1',1,'Retail Sale Id 4974',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 15:52:34','',''),(4904,'1','219','1',1,'Retail Sale Id 4975',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 15:54:09','',''),(4905,'1','219','1',1,'Retail Sale Id 4976',6360.00,0.00,0.00,10.00,340.00,'2022-05-10 16:02:38','',''),(4906,'1','219','1',1,'Retail Sale Id 4977',502.44,0.00,0.00,0.79,26.86,'2022-05-10 16:16:25','',''),(4907,'1','219','1',1,'Retail Sale Id 4978',2499.48,0.00,0.00,3.93,133.62,'2022-05-10 16:18:02','',''),(4908,'1','219','1',1,'Retail Sale Id 4979',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 16:25:11','',''),(4909,'1','219','1',1,'Retail Sale Id 4980',1202.04,0.00,0.00,1.89,64.26,'2022-05-10 16:42:42','',''),(4910,'1','219','1',1,'Retail Sale Id 4981',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 16:46:31','',''),(4911,'1','219','1',1,'Retail Sale Id 4982',998.52,0.00,0.00,1.57,53.38,'2022-05-10 16:47:57','',''),(4912,'1','219','1',1,'Retail Sale Id 4983',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 16:50:06','',''),(4913,'1','219','1',1,'Retail Sale Id 4985',50097.72,0.00,0.00,78.77,2678.18,'2022-05-10 17:00:42','',''),(4914,'1','219','1',1,'Retail Sale Id 4986',3180.00,0.00,0.00,5.00,170.00,'2022-05-10 17:01:56','',''),(4915,'1','219','1',1,'Retail Sale Id 4987',6360.00,0.00,0.00,10.00,340.00,'2022-05-10 17:03:14','',''),(4916,'1','219','1',1,'Retail Sale Id 4988',5100.72,0.00,0.00,8.02,272.68,'2022-05-10 17:04:39','',''),(4917,'1','219','1',1,'Retail Sale Id 4989',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 17:07:54','',''),(4918,'1','219','1',1,'Retail Sale Id 4991',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 17:11:02','',''),(4919,'1','219','1',1,'Retail Sale Id 4992',4452.00,0.00,0.00,7.00,238.00,'2022-05-10 17:15:31','',''),(4920,'1','219','1',1,'Retail Sale Id 4993',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 17:16:40','',''),(4921,'1','219','1',1,'Retail Sale Id 4994',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 17:21:10','',''),(4922,'1','219','1',1,'Retail Sale Id 4995',1202.04,0.00,0.00,1.89,64.26,'2022-05-10 17:22:33','',''),(4923,'1','219','1',1,'Retail Sale Id 4996',1297.44,0.00,0.00,2.04,69.36,'2022-05-10 17:23:53','',''),(4924,'1','219','1',1,'Retail Sale Id 4997',3180.00,0.00,0.00,5.00,170.00,'2022-05-10 17:36:03','',''),(4925,'1','219','1',1,'Retail Sale Id 4998',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 17:37:02','',''),(4926,'1','219','1',1,'Retail Sale Id 4999',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 17:39:50','',''),(4927,'1','219','1',1,'Retail Sale Id 5000',1500.96,0.00,0.00,2.36,80.24,'2022-05-10 17:43:00','',''),(4928,'1','219','1',1,'Retail Sale Id 5001',2499.48,0.00,0.00,3.93,133.62,'2022-05-10 17:43:43','',''),(4929,'1','219','1',1,'Retail Sale Id 5002',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 17:45:20','',''),(4930,'1','219','1',1,'Retail Sale Id 5002',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 17:45:20','',''),(4931,'1','219','1',1,'Retail Sale Id 5003',1297.44,0.00,0.00,2.04,69.36,'2022-05-10 17:48:24','',''),(4932,'1','219','1',1,'Retail Sale Id 5004',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 17:51:18','',''),(4933,'1','219','1',1,'Retail Sale Id 5005',1997.04,0.00,0.00,3.14,106.76,'2022-05-10 17:58:22','',''),(4934,'1','219','1',1,'Retail Sale Id 5006',3822.36,0.00,0.00,6.01,204.34,'2022-05-10 18:01:52','',''),(4935,'1','219','1',1,'Retail Sale Id 5007',1202.04,0.00,0.00,1.89,64.26,'2022-05-10 18:07:32','',''),(4936,'1','219','1',1,'Return of Retail Sale Id 4985',0.00,50097.72,78.77,0.00,-2678.18,'2022-05-10 18:08:09','',''),(4937,'1','219','1',1,'Retail Sale Id 5008',7950.00,0.00,0.00,12.50,425.00,'2022-05-10 18:08:46','',''),(4938,'1','219','1',1,'Retail Sale Id 5009',998.52,0.00,0.00,1.57,53.38,'2022-05-10 18:09:32','',''),(4939,'1','219','1',1,'Retail Sale Id 5010',502.44,0.00,0.00,0.79,26.86,'2022-05-10 18:16:33','',''),(4940,'1','219','1',1,'Retail Sale Id 5010',502.44,0.00,0.00,0.79,26.86,'2022-05-10 18:16:33','',''),(4941,'1','219','1',1,'Retail Sale Id 5011',400.68,0.00,0.00,0.63,21.42,'2022-05-10 18:18:19','',''),(4942,'1','219','1',1,'Retail Sale Id 5012',3180.00,0.00,0.00,5.00,170.00,'2022-05-10 18:19:38','',''),(4943,'1','219','1',1,'Retail Sale Id 5013',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 18:23:23','',''),(4944,'1','219','1',1,'Retail Sale Id 5014',1908.00,0.00,0.00,3.00,102.00,'2022-05-10 18:32:23','',''),(4945,'1','219','1',1,'Retail Sale Id 5015',1500.96,0.00,0.00,2.36,80.24,'2022-05-10 18:33:18','',''),(4946,'1','219','1',1,'Retail Sale Id 5016',1500.96,0.00,0.00,2.36,80.24,'2022-05-10 18:35:14','',''),(4947,'1','219','1',1,'Retail Sale Id 5017',37454.00,0.00,0.00,61.00,732.00,'2022-05-10 18:36:21','',''),(4948,'1','219','1',1,'Retail Sale Id 5019',1297.44,0.00,0.00,2.04,69.36,'2022-05-10 18:39:07','',''),(4949,'1','219','1',1,'Retail Sale Id 5020',3001.92,0.00,0.00,4.72,160.48,'2022-05-10 18:40:00','',''),(4950,'1','219','1',1,'Retail Sale Id 5021',3898.68,0.00,0.00,6.13,208.42,'2022-05-10 18:41:14','',''),(4951,'1','219','1',1,'Retail Sale Id 5022',699.60,0.00,0.00,1.10,37.40,'2022-05-10 18:51:52','',''),(4952,'1','219','1',1,'Retail Sale Id 5023',3822.36,0.00,0.00,6.01,204.34,'2022-05-11 07:16:38','',''),(4953,'1','219','1',1,'Retail Sale Id 5024',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 08:12:46','',''),(4954,'1','219','1',1,'Retail Sale Id 5025',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 08:19:49','',''),(4955,'1','219','1',1,'Retail Sale Id 5027',998.52,0.00,0.00,1.57,53.38,'2022-05-11 08:25:04','',''),(4956,'1','219','1',1,'Retail Sale Id 5028',7950.00,0.00,0.00,12.50,425.00,'2022-05-11 08:29:11','',''),(4957,'1','219','1',1,'Retail Sale Id 5029',7950.00,0.00,0.00,12.50,425.00,'2022-05-11 08:30:49','',''),(4958,'1','219','1',1,'Retail Sale Id 5030',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 08:38:38','',''),(4959,'1','219','1',1,'Retail Sale Id 5031',143676.00,0.00,0.00,234.00,2808.00,'2022-05-11 08:41:15','',''),(4960,'1','219','1',1,'Retail Sale Id 5032',1500.96,0.00,0.00,2.36,80.24,'2022-05-11 08:58:51','',''),(4961,'1','219','1',1,'Retail Sale Id 5033',3822.36,0.00,0.00,6.01,204.34,'2022-05-11 09:22:48','',''),(4962,'1','219','1',1,'Retail Sale Id 5034',3822.36,0.00,0.00,6.01,204.34,'2022-05-11 09:33:44','',''),(4963,'1','219','1',1,'Retail Sale Id 5035',1908.00,0.00,0.00,3.00,102.00,'2022-05-11 10:03:17','',''),(4964,'1','219','1',1,'Retail Sale Id 5036',298.92,0.00,0.00,0.47,15.98,'2022-05-11 10:11:23','',''),(4965,'1','219','1',1,'Retail Sale Id 5037',6398.16,0.00,0.00,10.06,342.04,'2022-05-11 10:13:56','',''),(4966,'1','219','1',1,'Retail Sale Id 5038',3001.92,0.00,0.00,4.72,160.48,'2022-05-11 10:29:44','',''),(4967,'1','219','1',1,'Retail Sale Id 5039',6140.00,0.00,0.00,10.00,120.00,'2022-05-11 10:37:20','',''),(4968,'1','219','1',1,'Retail Sale Id 5040',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 10:39:39','',''),(4969,'1','219','1',1,'Retail Sale Id 5041',1799.88,0.00,0.00,2.83,96.22,'2022-05-11 10:45:06','',''),(4970,'1','219','1',1,'Retail Sale Id 5042',3822.36,0.00,0.00,6.01,204.34,'2022-05-11 11:00:58','',''),(4971,'1','219','1',1,'Retail Sale Id 5043',3498.00,0.00,0.00,5.50,187.00,'2022-05-11 11:04:44','',''),(4972,'1','219','1',1,'Retail Sale Id 5044',3199.08,0.00,0.00,5.03,171.02,'2022-05-11 11:06:14','',''),(4973,'1','219','1',1,'Retail Sale Id 5045',6360.00,0.00,0.00,10.00,340.00,'2022-05-11 11:07:51','',''),(4974,'1','219','1',1,'Retail Sale Id 5046',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 11:16:25','',''),(4975,'1','219','1',1,'Retail Sale Id 5047',3822.36,0.00,0.00,6.01,204.34,'2022-05-11 11:20:11','',''),(4976,'1','219','1',1,'Retail Sale Id 5049',6360.00,0.00,0.00,10.00,340.00,'2022-05-11 11:32:07','',''),(4977,'1','219','1',1,'Retail Sale Id 5050',3199.08,0.00,0.00,5.03,171.02,'2022-05-11 11:33:17','',''),(4978,'1','219','1',1,'Retail Sale Id 5051',998.52,0.00,0.00,1.57,53.38,'2022-05-11 11:42:56','',''),(4979,'1','219','1',1,'Retail Sale Id 5052',648.72,0.00,0.00,1.02,34.68,'2022-05-11 11:46:47','',''),(4980,'1','219','1',1,'Retail Sale Id 5053',1901.64,0.00,0.00,2.99,101.66,'2022-05-11 11:49:30','',''),(4981,'1','219','1',1,'Retail Sale Id 5054',3199.08,0.00,0.00,5.03,171.02,'2022-05-11 11:57:23','',''),(4982,'1','219','1',1,'Retail Sale Id 5056',3796.92,0.00,0.00,5.97,202.98,'2022-05-11 11:59:58','',''),(4983,'1','219','1',1,'Retail Sale Id 5057',1908.00,0.00,0.00,3.00,102.00,'2022-05-11 12:02:57','',''),(4984,'1','219','1',1,'Retail Sale Id 5058',3199.08,0.00,0.00,5.03,171.02,'2022-05-11 12:20:27','',''),(4985,'1','219','1',1,'Retail Sale Id 5059',5997.48,0.00,0.00,9.43,320.62,'2022-05-11 12:30:06','',''),(4986,'1','219','1',1,'Retail Sale Id 5060',7950.00,0.00,0.00,12.50,425.00,'2022-05-11 12:36:53','',''),(4987,'1','219','1',1,'Retail Sale Id 5061',3684.00,0.00,0.00,6.00,72.00,'2022-05-11 12:40:41','',''),(4988,'1','219','1',1,'Retail Sale Id 5062',3684.00,0.00,0.00,6.00,72.00,'2022-05-11 12:42:16','',''),(4989,'1','219','1',1,'Retail Sale Id 5063',3822.36,0.00,0.00,6.01,204.34,'2022-05-11 13:05:25','',''),(4990,'1','219','1',1,'Retail Sale Id 5064',597.84,0.00,0.00,0.94,31.96,'2022-05-11 13:15:01','',''),(4991,'1','219','1',1,'Retail Sale Id 5065',1842.00,0.00,0.00,3.00,36.00,'2022-05-11 13:21:21','',''),(4992,'1','219','1',1,'Retail Sale Id 5066',3684.00,0.00,0.00,6.00,72.00,'2022-05-11 13:24:21','',''),(4993,'1','219','1',1,'Retail Sale Id 5067',7675.00,0.00,0.00,12.50,150.00,'2022-05-11 13:27:28','',''),(4994,'1','219','1',1,'Retail Sale Id 5068',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 13:29:29','',''),(4995,'1','219','1',1,'Retail Sale Id 5069',4000.44,0.00,0.00,6.29,213.86,'2022-05-11 13:30:28','',''),(4996,'1','219','1',1,'Retail Sale Id 5070',3199.08,0.00,0.00,5.03,171.02,'2022-05-11 13:31:45','',''),(4997,'1','219','1',1,'Retail Sale Id 5070',3199.08,0.00,0.00,5.03,171.02,'2022-05-11 13:31:45','',''),(4998,'1','219','1',1,'Retail Sale Id 5071',998.52,0.00,0.00,1.57,53.38,'2022-05-11 13:33:12','',''),(4999,'1','219','1',1,'Retail Sale Id 5072',4452.00,0.00,0.00,7.00,238.00,'2022-05-11 13:38:49','',''),(5000,'1','219','1',1,'Retail Sale Id 5073',3847.80,0.00,0.00,6.05,205.70,'2022-05-11 13:57:05','',''),(5001,'1','219','1',1,'Retail Sale Id 5074',3822.36,0.00,0.00,6.01,204.34,'2022-05-11 13:58:54','',''),(5002,'1','219','1',1,'Retail Sale Id 5076',3822.36,0.00,0.00,6.01,204.34,'2022-05-11 14:05:21','',''),(5003,'1','219','1',1,'Retail Sale Id 5077',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 14:08:41','',''),(5004,'1','219','1',1,'Retail Sale Id 5078',2550.36,0.00,0.00,4.01,136.34,'2022-05-11 14:29:05','',''),(5005,'1','219','1',1,'Retail Sale Id 5079',998.52,0.00,0.00,1.57,53.38,'2022-05-11 14:47:45','',''),(5006,'1','219','1',1,'Retail Sale Id 5080',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 14:54:29','',''),(5007,'1','219','1',1,'Retail Sale Id 5081',2544.00,0.00,0.00,4.00,136.00,'2022-05-11 15:12:18','',''),(5008,'1','219','1',1,'Retail Sale Id 5082',3847.80,0.00,0.00,6.05,205.70,'2022-05-11 15:15:01','',''),(5009,'1','219','1',1,'Retail Sale Id 5083',1842.00,0.00,0.00,3.00,36.00,'2022-05-11 15:25:53','',''),(5010,'1','219','1',1,'Retail Sale Id 5085',2550.36,0.00,0.00,4.01,136.34,'2022-05-11 15:33:32','',''),(5011,'1','219','1',1,'Retail Sale Id 5087',1901.64,0.00,0.00,2.99,101.66,'2022-05-11 15:35:58','',''),(5012,'1','219','1',1,'Retail Sale Id 5088',1901.64,0.00,0.00,2.99,101.66,'2022-05-11 15:37:17','',''),(5013,'1','219','1',1,'Retail Sale Id 5089',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 15:44:23','',''),(5014,'1','219','1',1,'Retail Sale Id 5090',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 15:49:17','',''),(5015,'1','219','1',1,'Retail Sale Id 5091',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 15:50:16','',''),(5016,'1','219','1',1,'Retail Sale Id 5092',1500.96,0.00,0.00,2.36,80.24,'2022-05-11 15:52:44','',''),(5017,'1','219','1',1,'Retail Sale Id 5092',1500.96,0.00,0.00,2.36,80.24,'2022-05-11 15:52:44','',''),(5018,'1','219','1',1,'Retail Sale Id 5093',502.44,0.00,0.00,0.79,26.86,'2022-05-11 16:11:20','',''),(5019,'1','219','1',1,'Retail Sale Id 5094',998.52,0.00,0.00,1.57,53.38,'2022-05-11 16:21:29','',''),(5020,'1','219','1',1,'Retail Sale Id 5095',648.72,0.00,0.00,1.02,34.68,'2022-05-11 16:22:38','',''),(5021,'1','219','1',1,'Retail Sale Id 5096',3498.00,0.00,0.00,5.50,187.00,'2022-05-11 16:32:35','',''),(5022,'1','219','1',1,'Retail Sale Id 5097',2550.36,0.00,0.00,4.01,136.34,'2022-05-11 16:45:08','',''),(5023,'1','219','1',1,'Retail Sale Id 5098',1500.96,0.00,0.00,2.36,80.24,'2022-05-11 16:58:45','',''),(5024,'1','219','1',1,'Retail Sale Id 5099',1500.96,0.00,0.00,2.36,80.24,'2022-05-11 17:00:06','',''),(5025,'1','219','1',1,'Retail Sale Id 5100',15350.00,0.00,0.00,25.00,300.00,'2022-05-11 17:02:06','',''),(5026,'1','219','1',1,'Retail Sale Id 5101',1500.96,0.00,0.00,2.36,80.24,'2022-05-11 17:10:00','',''),(5027,'1','219','1',1,'Retail Sale Id 5102',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 17:14:20','',''),(5028,'1','219','1',1,'Retail Sale Id 5103',31800.00,0.00,0.00,50.00,1700.00,'2022-05-11 17:15:43','',''),(5029,'1','219','1',1,'Retail Sale Id 5104',1908.00,0.00,0.00,3.00,102.00,'2022-05-11 17:26:16','',''),(5030,'1','219','1',1,'Retail Sale Id 5105',3180.00,0.00,0.00,5.00,170.00,'2022-05-11 17:31:31','',''),(5031,'1','219','1',1,'Retail Sale Id 5106',998.52,0.00,0.00,1.57,53.38,'2022-05-11 17:32:51','',''),(5032,'1','219','1',1,'Retail Sale Id 5107',3001.92,0.00,0.00,4.72,160.48,'2022-05-11 17:37:18','',''),(5033,'1','219','1',1,'Retail Sale Id 5108',3822.36,0.00,0.00,6.01,204.34,'2022-05-11 17:45:04','',''),(5034,'1','219','1',1,'Retail Sale Id 5109',3001.92,0.00,0.00,4.72,160.48,'2022-05-11 17:52:53','',''),(5035,'1','219','1',1,'Retail Sale Id 5110',3199.08,0.00,0.00,5.03,171.02,'2022-05-11 17:54:08','',''),(5036,'1','219','1',1,'Retail Sale Id 5111',998.52,0.00,0.00,1.57,53.38,'2022-05-11 17:56:34','',''),(5037,'1','219','1',1,'Retail Sale Id 5112',33770.00,0.00,0.00,55.00,660.00,'2022-05-11 18:08:43','',''),(5038,'1','219','1',1,'Retail Sale Id 5113',7950.00,0.00,0.00,12.50,425.00,'2022-05-11 18:11:21','',''),(5039,'1','219','1',1,'Retail Sale Id 5114',1297.44,0.00,0.00,2.04,69.36,'2022-05-11 18:12:44','',''),(5040,'1','219','1',1,'Retail Sale Id 5115',1908.00,0.00,0.00,3.00,102.00,'2022-05-11 18:14:15','',''),(5041,'1','219','1',1,'Retail Sale Id 5116',1500.96,0.00,0.00,2.36,80.24,'2022-05-11 18:18:59','',''),(5042,'1','219','1',1,'Retail Sale Id 5118',1908.00,0.00,0.00,3.00,102.00,'2022-05-11 18:23:12','',''),(5043,'1','219','1',1,'Retail Sale Id 5119',1698.12,0.00,0.00,2.67,90.78,'2022-05-11 18:24:17','',''),(5044,'1','219','1',1,'Retail Sale Id 5120',998.52,0.00,0.00,1.57,53.38,'2022-05-11 18:25:48','',''),(5045,'1','219','1',1,'Retail Sale Id 5122',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 18:38:29','',''),(5046,'1','219','1',1,'Retail Sale Id 5123',1799.88,0.00,0.00,2.83,96.22,'2022-05-11 18:42:47','',''),(5047,'1','219','1',1,'Retail Sale Id 5124',4000.44,0.00,0.00,6.29,213.86,'2022-05-11 18:43:47','',''),(5048,'1','219','1',1,'Retail Sale Id 5125',1997.04,0.00,0.00,3.14,106.76,'2022-05-11 18:47:06','',''),(5049,'1','219','1',1,'Retail Sale Id 5126',400.68,0.00,0.00,0.63,21.42,'2022-05-11 18:53:21','',''),(5050,'1','219','1',1,'Retail Sale Id 5127',502.44,0.00,0.00,0.79,26.86,'2022-05-11 18:54:28','',''),(5051,'1','219','1',1,'Retail Sale Id 5128',3199.08,0.00,0.00,5.03,171.02,'2022-05-12 08:10:10','',''),(5052,'1','219','1',1,'Retail Sale Id 5129',7950.00,0.00,0.00,12.50,425.00,'2022-05-12 08:50:30','',''),(5053,'1','219','1',1,'Retail Sale Id 5130',1500.96,0.00,0.00,2.36,80.24,'2022-05-12 08:55:57','',''),(5054,'1','219','1',1,'Retail Sale Id 5131',5100.72,0.00,0.00,8.02,272.68,'2022-05-12 08:57:26','',''),(5055,'1','219','1',1,'Retail Sale Id 5132',4452.00,0.00,0.00,7.00,238.00,'2022-05-12 08:58:56','',''),(5056,'1','219','1',1,'Retail Sale Id 5133',3498.00,0.00,0.00,5.50,187.00,'2022-05-12 09:20:25','',''),(5057,'1','219','1',1,'Retail Sale Id 5134',3822.36,0.00,0.00,6.01,204.34,'2022-05-12 09:36:46','',''),(5058,'1','219','1',1,'Retail Sale Id 5135',3070.00,0.00,0.00,5.00,60.00,'2022-05-12 09:39:33','',''),(5059,'1','219','1',1,'Retail Sale Id 5136',298.92,0.00,0.00,0.47,15.98,'2022-05-12 09:53:43','',''),(5060,'1','219','1',1,'Retail Sale Id 5137',3199.08,0.00,0.00,5.03,171.02,'2022-05-12 09:56:04','',''),(5061,'1','219','1',1,'Retail Sale Id 5138',3822.36,0.00,0.00,6.01,204.34,'2022-05-12 10:02:30','',''),(5062,'1','219','1',1,'Retail Sale Id 5139',7950.00,0.00,0.00,12.50,425.00,'2022-05-12 10:28:53','',''),(5063,'1','219','1',1,'Retail Sale Id 5140',1901.64,0.00,0.00,2.99,101.66,'2022-05-12 10:47:36','',''),(5064,'1','219','1',1,'Retail Sale Id 5141',6360.00,0.00,0.00,10.00,340.00,'2022-05-12 10:50:39','',''),(5065,'1','219','1',1,'Retail Sale Id 5142',3847.80,0.00,0.00,6.05,205.70,'2022-05-12 10:52:37','',''),(5066,'1','219','1',1,'Retail Sale Id 5143',30700.00,0.00,0.00,50.00,600.00,'2022-05-12 10:55:45','',''),(5067,'1','219','1',1,'Retail Sale Id 5144',3847.80,0.00,0.00,6.05,205.70,'2022-05-12 11:03:05','',''),(5068,'1','219','1',1,'Retail Sale Id 5145',1997.04,0.00,0.00,3.14,106.76,'2022-05-12 11:16:49','',''),(5069,'1','219','1',1,'Retail Sale Id 5146',648.72,0.00,0.00,1.02,34.68,'2022-05-12 11:19:06','',''),(5070,'1','219','1',1,'Retail Sale Id 5147',7950.00,0.00,0.00,12.50,425.00,'2022-05-12 11:35:28','',''),(5071,'1','219','1',1,'Retail Sale Id 5148',998.52,0.00,0.00,1.57,53.38,'2022-05-12 11:54:32','',''),(5072,'1','219','1',1,'Retail Sale Id 5149',298.92,0.00,0.00,0.47,15.98,'2022-05-12 11:56:15','',''),(5073,'1','219','1',1,'Retail Sale Id 5150',1997.04,0.00,0.00,3.14,106.76,'2022-05-12 12:06:23','',''),(5074,'1','219','1',1,'Retail Sale Id 5151',998.52,0.00,0.00,1.57,53.38,'2022-05-12 12:21:28','',''),(5075,'1','219','1',1,'Retail Sale Id 5152',4000.44,0.00,0.00,6.29,213.86,'2022-05-12 12:56:58','',''),(5076,'1','219','1',1,'Retail Sale Id 5153',1297.44,0.00,0.00,2.04,69.36,'2022-05-12 13:17:48','',''),(5077,'1','219','1',1,'Retail Sale Id 5154',6360.00,0.00,0.00,10.00,340.00,'2022-05-12 13:20:17','',''),(5078,'1','219','1',1,'Retail Sale Id 5155',597.84,0.00,0.00,0.94,31.96,'2022-05-12 13:38:47','',''),(5079,'1','219','1',1,'Retail Sale Id 5156',1297.44,0.00,0.00,2.04,69.36,'2022-05-12 13:40:08','',''),(5080,'1','219','1',1,'Retail Sale Id 5157',1297.44,0.00,0.00,2.04,69.36,'2022-05-12 13:40:54','',''),(5081,'1','219','1',1,'Retail Sale Id 5158',1997.04,0.00,0.00,3.14,106.76,'2022-05-12 14:05:58','',''),(5082,'1','219','1',1,'Retail Sale Id 5159',998.52,0.00,0.00,1.57,53.38,'2022-05-12 14:40:36','',''),(5083,'1','219','1',1,'Retail Sale Id 5160',1997.04,0.00,0.00,3.14,106.76,'2022-05-12 14:46:25','',''),(5084,'1','219','1',1,'Retail Sale Id 5161',7950.00,0.00,0.00,12.50,425.00,'2022-05-12 14:47:51','',''),(5085,'1','219','1',1,'Retail Sale Id 5162',1698.12,0.00,0.00,2.67,90.78,'2022-05-12 14:54:22','',''),(5086,'1','219','1',1,'Retail Sale Id 5163',298.92,0.00,0.00,0.47,15.98,'2022-05-12 14:56:01','',''),(5087,'1','219','1',1,'Retail Sale Id 5164',998.52,0.00,0.00,1.57,53.38,'2022-05-12 15:03:53','',''),(5088,'1','219','1',1,'Retail Sale Id 5165',998.52,0.00,0.00,1.57,53.38,'2022-05-12 15:05:20','',''),(5089,'1','219','1',1,'Retail Sale Id 5166',3822.36,0.00,0.00,6.01,204.34,'2022-05-12 15:15:45','',''),(5090,'1','219','1',1,'Retail Sale Id 5167',1908.00,0.00,0.00,3.00,102.00,'2022-05-12 15:25:48','',''),(5091,'1','219','1',1,'Retail Sale Id 5168',1952.52,0.00,0.00,3.07,104.38,'2022-05-12 15:31:34','',''),(5092,'1','219','1',1,'Retail Sale Id 5169',3822.36,0.00,0.00,6.01,204.34,'2022-05-12 15:56:14','',''),(5093,'1','219','1',1,'Retail Sale Id 5170',1500.96,0.00,0.00,2.36,80.24,'2022-05-12 16:01:04','',''),(5094,'1','219','1',1,'Retail Sale Id 5171',502.44,0.00,0.00,0.79,26.86,'2022-05-12 16:03:11','',''),(5095,'1','219','1',1,'Retail Sale Id 5172',1908.00,0.00,0.00,3.00,102.00,'2022-05-12 16:22:07','',''),(5096,'1','219','1',1,'Retail Sale Id 5173',1500.96,0.00,0.00,2.36,80.24,'2022-05-12 16:29:04','',''),(5097,'1','219','1',1,'Retail Sale Id 5174',3180.00,0.00,0.00,5.00,170.00,'2022-05-12 16:35:39','',''),(5098,'1','219','1',1,'Retail Sale Id 5176',4452.00,0.00,0.00,7.00,238.00,'2022-05-12 16:48:03','',''),(5099,'1','219','1',1,'Retail Sale Id 5177',3822.36,0.00,0.00,6.01,204.34,'2022-05-12 16:49:05','',''),(5100,'1','219','1',1,'Retail Sale Id 5178',998.52,0.00,0.00,1.57,53.38,'2022-05-12 16:51:19','',''),(5101,'1','219','1',1,'Retail Sale Id 5179',3180.00,0.00,0.00,5.00,170.00,'2022-05-12 16:52:11','',''),(5102,'1','219','1',1,'Retail Sale Id 5180',648.72,0.00,0.00,1.02,34.68,'2022-05-12 17:00:54','',''),(5103,'1','219','1',1,'Retail Sale Id 5181',1920.72,0.00,0.00,3.02,102.68,'2022-05-12 17:04:52','',''),(5104,'1','219','1',1,'Retail Sale Id 5181',3180.00,0.00,0.00,5.00,170.00,'2022-05-12 17:04:52','',''),(5105,'1','219','1',1,'Retail Sale Id 5182',3180.00,0.00,0.00,5.00,170.00,'2022-05-12 17:06:37','',''),(5106,'1','219','1',1,'Retail Sale Id 5183',998.52,0.00,0.00,1.57,53.38,'2022-05-12 17:07:35','',''),(5107,'1','219','1',1,'Retail Sale Id 5184',998.52,0.00,0.00,1.57,53.38,'2022-05-12 17:08:23','',''),(5108,'1','219','1',1,'Retail Sale Id 5185',2499.48,0.00,0.00,3.93,133.62,'2022-05-12 17:09:12','',''),(5109,'1','219','1',1,'Retail Sale Id 5186',3498.00,0.00,0.00,5.50,187.00,'2022-05-12 17:21:49','',''),(5110,'1','219','1',1,'Retail Sale Id 5187',3001.92,0.00,0.00,4.72,160.48,'2022-05-12 17:26:57','',''),(5111,'1','219','1',1,'Retail Sale Id 5188',3001.92,0.00,0.00,4.72,160.48,'2022-05-12 17:27:53','',''),(5112,'1','219','1',1,'Retail Sale Id 5189',3001.92,0.00,0.00,4.72,160.48,'2022-05-12 17:30:39','',''),(5113,'1','219','1',1,'Retail Sale Id 5190',502.44,0.00,0.00,0.79,26.86,'2022-05-12 17:35:37','',''),(5114,'1','219','1',1,'Retail Sale Id 5191',3180.00,0.00,0.00,5.00,170.00,'2022-05-12 17:39:24','',''),(5115,'1','219','1',1,'Retail Sale Id 5192',3822.36,0.00,0.00,6.01,204.34,'2022-05-12 17:43:45','',''),(5116,'1','219','1',1,'Retail Sale Id 5193',1297.44,0.00,0.00,2.04,69.36,'2022-05-12 17:45:17','',''),(5117,'1','219','1',1,'Retail Sale Id 5194',1908.00,0.00,0.00,3.00,102.00,'2022-05-12 18:01:33','',''),(5118,'1','219','1',1,'Retail Sale Id 5195',3822.36,0.00,0.00,6.01,204.34,'2022-05-12 18:12:05','',''),(5119,'1','219','1',1,'Retail Sale Id 5196',1500.96,0.00,0.00,2.36,80.24,'2022-05-12 18:16:21','',''),(5120,'1','219','1',1,'Retail Sale Id 5197',1997.04,0.00,0.00,3.14,106.76,'2022-05-12 18:26:41','',''),(5121,'1','219','1',1,'Retail Sale Id 5198',998.52,0.00,0.00,1.57,53.38,'2022-05-12 18:28:40','',''),(5122,'1','219','1',1,'Retail Sale Id 5199',298.92,0.00,0.00,0.47,15.98,'2022-05-12 18:29:46','',''),(5123,'1','219','1',1,'Retail Sale Id 5200',3822.36,0.00,0.00,6.01,204.34,'2022-05-12 18:42:42','',''),(5124,'1','219','1',1,'Retail Sale Id 5201',4998.96,0.00,0.00,7.86,267.24,'2022-05-12 18:49:25','',''),(5125,'1','219','1',1,'Retail Sale Id 5202',1297.44,0.00,0.00,2.04,69.36,'2022-05-12 18:52:25','',''),(5126,'1','219','1',1,'Retail Sale Id 5203',1920.72,0.00,0.00,3.02,102.68,'2022-05-12 18:53:45','',''),(5127,'1','219','1',1,'Retail Sale Id 5204',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 07:53:29','',''),(5128,'1','219','1',1,'Retail Sale Id 5205',699.60,0.00,0.00,1.10,37.40,'2022-05-13 08:40:12','',''),(5129,'1','219','1',1,'Retail Sale Id 5206',7675.00,0.00,0.00,12.50,150.00,'2022-05-13 08:57:22','',''),(5130,'1','219','1',1,'Retail Sale Id 5207',1997.04,0.00,0.00,3.14,106.76,'2022-05-13 09:03:28','',''),(5131,'1','219','1',1,'Retail Sale Id 5208',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 09:17:21','',''),(5132,'1','219','1',1,'Retail Sale Id 5209',1997.04,0.00,0.00,3.14,106.76,'2022-05-13 09:39:30','',''),(5133,'1','219','1',1,'Retail Sale Id 5210',1399.20,0.00,0.00,2.20,74.80,'2022-05-13 09:41:52','',''),(5134,'1','219','1',1,'Retail Sale Id 5211',502.44,0.00,0.00,0.79,26.86,'2022-05-13 09:42:36','',''),(5135,'1','219','1',1,'Retail Sale Id 5212',2550.36,0.00,0.00,4.01,136.34,'2022-05-13 09:43:38','',''),(5136,'1','219','1',1,'Retail Sale Id 5213',3199.08,0.00,0.00,5.03,171.02,'2022-05-13 09:48:41','',''),(5137,'1','219','1',1,'Retail Sale Id 5214',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 10:00:30','',''),(5138,'1','219','1',1,'Retail Sale Id 5215',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 10:21:35','',''),(5139,'1','219','1',1,'Retail Sale Id 5216',1908.00,0.00,0.00,3.00,102.00,'2022-05-13 10:29:50','',''),(5140,'1','219','1',1,'Retail Sale Id 5216',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 10:29:50','',''),(5141,'1','219','1',1,'Retail Sale Id 5217',1500.96,0.00,0.00,2.36,80.24,'2022-05-13 10:49:33','',''),(5142,'1','219','1',1,'Retail Sale Id 5218',7002.36,0.00,0.00,11.01,374.34,'2022-05-13 11:00:24','',''),(5143,'1','219','1',1,'Retail Sale Id 5219',1908.00,0.00,0.00,3.00,102.00,'2022-05-13 11:10:17','',''),(5144,'1','219','1',1,'Retail Sale Id 5220',3001.92,0.00,0.00,4.72,160.48,'2022-05-13 11:12:00','',''),(5145,'1','219','1',1,'Retail Sale Id 5221',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 11:14:01','',''),(5146,'1','219','1',1,'Retail Sale Id 5222',1500.96,0.00,0.00,2.36,80.24,'2022-05-13 11:27:28','',''),(5147,'1','219','1',1,'Retail Sale Id 5223',2499.48,0.00,0.00,3.93,133.62,'2022-05-13 11:39:57','',''),(5148,'1','219','1',1,'Retail Sale Id 5224',998.52,0.00,0.00,1.57,53.38,'2022-05-13 11:52:18','',''),(5149,'1','219','1',1,'Retail Sale Id 5225',998.52,0.00,0.00,1.57,53.38,'2022-05-13 11:57:02','',''),(5150,'1','219','1',1,'Retail Sale Id 5226',4998.96,0.00,0.00,7.86,267.24,'2022-05-13 12:09:39','',''),(5151,'1','219','1',1,'Retail Sale Id 5227',7002.36,0.00,0.00,11.01,374.34,'2022-05-13 12:22:43','',''),(5152,'1','219','1',1,'Retail Sale Id 5228',3001.92,0.00,0.00,4.72,160.48,'2022-05-13 12:26:33','',''),(5153,'1','219','1',1,'Retail Sale Id 5229',6360.00,0.00,0.00,10.00,340.00,'2022-05-13 12:59:41','',''),(5154,'1','219','1',1,'Retail Sale Id 5230',1908.00,0.00,0.00,3.00,102.00,'2022-05-13 13:02:34','',''),(5155,'1','219','1',1,'Retail Sale Id 5231',998.52,0.00,0.00,1.57,53.38,'2022-05-13 13:03:57','',''),(5156,'1','219','1',1,'Retail Sale Id 5232',1297.44,0.00,0.00,2.04,69.36,'2022-05-13 13:28:10','',''),(5157,'1','219','1',1,'Retail Sale Id 5233',7403.04,0.00,0.00,11.64,395.76,'2022-05-13 13:36:43','',''),(5158,'1','219','1',1,'Retail Sale Id 5234',2499.48,0.00,0.00,3.93,133.62,'2022-05-13 13:58:31','',''),(5159,'1','219','1',1,'Retail Sale Id 5235',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 14:22:42','',''),(5160,'1','219','1',1,'Retail Sale Id 5236',998.52,0.00,0.00,1.57,53.38,'2022-05-13 14:32:23','',''),(5161,'1','219','1',1,'Retail Sale Id 5237',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 15:06:30','',''),(5162,'1','219','1',1,'Retail Sale Id 5238',3199.08,0.00,0.00,5.03,171.02,'2022-05-13 15:24:14','',''),(5163,'1','219','1',1,'Retail Sale Id 5238',7950.00,0.00,0.00,12.50,425.00,'2022-05-13 15:24:14','',''),(5164,'1','219','1',1,'Retail Sale Id 5239',648.72,0.00,0.00,1.02,34.68,'2022-05-13 15:41:57','',''),(5165,'1','219','1',1,'Retail Sale Id 5240',998.52,0.00,0.00,1.57,53.38,'2022-05-13 15:43:30','',''),(5166,'1','219','1',1,'Retail Sale Id 5241',6360.00,0.00,0.00,10.00,340.00,'2022-05-13 15:44:52','',''),(5167,'1','219','1',1,'Retail Sale Id 5242',1997.04,0.00,0.00,3.14,106.76,'2022-05-13 16:05:48','',''),(5168,'1','219','1',1,'Retail Sale Id 5243',998.52,0.00,0.00,1.57,53.38,'2022-05-13 16:09:28','',''),(5169,'1','219','1',1,'Retail Sale Id 5244',3796.92,0.00,0.00,5.97,202.98,'2022-05-13 16:23:04','',''),(5170,'1','219','1',1,'Retail Sale Id 5245',4000.44,0.00,0.00,6.29,213.86,'2022-05-13 16:34:29','',''),(5171,'1','219','1',1,'Retail Sale Id 5246',3199.08,0.00,0.00,5.03,171.02,'2022-05-13 16:35:32','',''),(5172,'1','219','1',1,'Retail Sale Id 5247',3684.00,0.00,0.00,6.00,72.00,'2022-05-13 16:39:05','',''),(5173,'1','219','1',1,'Retail Sale Id 5248',6360.00,0.00,0.00,10.00,340.00,'2022-05-13 16:47:28','',''),(5174,'1','219','1',1,'Retail Sale Id 5249',1997.04,0.00,0.00,3.14,106.76,'2022-05-13 16:49:14','',''),(5175,'1','219','1',1,'Retail Sale Id 5250',1997.04,0.00,0.00,3.14,106.76,'2022-05-13 16:51:10','',''),(5176,'1','219','1',1,'Retail Sale Id 5251',1500.96,0.00,0.00,2.36,80.24,'2022-05-13 16:52:46','',''),(5177,'1','219','1',1,'Retail Sale Id 5252',1908.00,0.00,0.00,3.00,102.00,'2022-05-13 16:54:24','',''),(5178,'1','219','1',1,'Retail Sale Id 5253',3498.00,0.00,0.00,5.50,187.00,'2022-05-13 16:55:45','',''),(5179,'1','219','1',1,'Retail Sale Id 5254',998.52,0.00,0.00,1.57,53.38,'2022-05-13 16:56:44','',''),(5180,'1','219','1',1,'Retail Sale Id 5255',1997.04,0.00,0.00,3.14,106.76,'2022-05-13 17:20:28','',''),(5181,'1','219','1',1,'Retail Sale Id 5256',1297.44,0.00,0.00,2.04,69.36,'2022-05-13 17:22:10','',''),(5182,'1','219','1',1,'Retail Sale Id 5256',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 17:22:10','',''),(5183,'1','219','1',1,'Retail Sale Id 5257',3199.08,0.00,0.00,5.03,171.02,'2022-05-13 17:24:31','',''),(5184,'1','219','1',1,'Retail Sale Id 5258',998.52,0.00,0.00,1.57,53.38,'2022-05-13 17:26:42','',''),(5185,'1','219','1',1,'Retail Sale Id 5259',1997.04,0.00,0.00,3.14,106.76,'2022-05-13 17:30:37','',''),(5186,'1','219','1',1,'Retail Sale Id 5260',1908.00,0.00,0.00,3.00,102.00,'2022-05-13 17:32:57','',''),(5187,'1','219','1',1,'Retail Sale Id 5262',1297.44,0.00,0.00,2.04,69.36,'2022-05-13 17:37:07','',''),(5188,'1','219','1',1,'Retail Sale Id 5263',400.68,0.00,0.00,0.63,21.42,'2022-05-13 17:41:02','',''),(5189,'1','219','1',1,'Retail Sale Id 5264',502.44,0.00,0.00,0.79,26.86,'2022-05-13 18:01:32','',''),(5190,'1','219','1',1,'Retail Sale Id 5265',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 18:02:32','',''),(5191,'1','219','1',1,'Retail Sale Id 5266',1997.04,0.00,0.00,3.14,106.76,'2022-05-13 18:08:52','',''),(5192,'1','219','1',1,'Retail Sale Id 5267',502.44,0.00,0.00,0.79,26.86,'2022-05-13 18:09:46','',''),(5193,'1','219','1',1,'Retail Sale Id 5268',998.52,0.00,0.00,1.57,53.38,'2022-05-13 18:10:38','',''),(5194,'1','219','1',1,'Retail Sale Id 5269',1997.04,0.00,0.00,3.14,106.76,'2022-05-13 18:13:15','',''),(5195,'1','219','1',1,'Retail Sale Id 5270',3822.36,0.00,0.00,6.01,204.34,'2022-05-13 18:16:53','',''),(5196,'1','219','1',1,'Retail Sale Id 5271',1997.04,0.00,0.00,3.14,106.76,'2022-05-13 18:18:26','',''),(5197,'1','219','1',1,'Retail Sale Id 5272',7950.00,0.00,0.00,12.50,425.00,'2022-05-14 07:28:20','',''),(5198,'1','219','1',1,'Retail Sale Id 5273',2537.64,0.00,0.00,3.99,135.66,'2022-05-14 07:53:14','',''),(5199,'1','219','1',1,'Retail Sale Id 5274',998.52,0.00,0.00,1.57,53.38,'2022-05-14 08:06:47','',''),(5200,'1','219','1',1,'Retail Sale Id 5275',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 09:01:12','',''),(5201,'1','219','1',1,'Retail Sale Id 5275',7950.00,0.00,0.00,12.50,425.00,'2022-05-14 09:01:12','',''),(5202,'1','219','1',1,'Retail Sale Id 5276',1297.44,0.00,0.00,2.04,69.36,'2022-05-14 09:02:08','',''),(5203,'1','219','1',1,'Retail Sale Id 5277',3070.00,0.00,0.00,5.00,60.00,'2022-05-14 09:03:44','',''),(5204,'1','219','1',1,'Retail Sale Id 5278',3070.00,0.00,0.00,5.00,60.00,'2022-05-14 09:04:39','',''),(5205,'1','219','1',1,'Retail Sale Id 5279',2550.36,0.00,0.00,4.01,136.34,'2022-05-14 09:11:34','',''),(5206,'1','219','1',1,'Retail Sale Id 5280',648.72,0.00,0.00,1.02,34.68,'2022-05-14 09:14:11','',''),(5207,'1','219','1',1,'Retail Sale Id 5281',998.52,0.00,0.00,1.57,53.38,'2022-05-14 09:18:35','',''),(5208,'1','219','1',1,'Retail Sale Id 5282',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 09:38:02','',''),(5209,'1','219','1',1,'Retail Sale Id 5283',1901.64,0.00,0.00,2.99,101.66,'2022-05-14 09:48:42','',''),(5210,'1','219','1',1,'Retail Sale Id 5284',3001.92,0.00,0.00,4.72,160.48,'2022-05-14 09:53:49','',''),(5211,'1','219','1',1,'Retail Sale Id 5285',502.44,0.00,0.00,0.79,26.86,'2022-05-14 10:00:24','',''),(5212,'1','219','1',1,'Retail Sale Id 5286',7950.00,0.00,0.00,12.50,425.00,'2022-05-14 10:09:25','',''),(5213,'1','219','1',1,'Retail Sale Id 5287',3070.00,0.00,0.00,5.00,60.00,'2022-05-14 10:10:52','',''),(5214,'1','219','1',1,'Retail Sale Id 5288',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 10:15:41','',''),(5215,'1','219','1',1,'Retail Sale Id 5289',3001.92,0.00,0.00,4.72,160.48,'2022-05-14 10:18:39','',''),(5216,'1','219','1',1,'Retail Sale Id 5290',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 10:19:48','',''),(5217,'1','219','1',1,'Retail Sale Id 5291',502.44,0.00,0.00,0.79,26.86,'2022-05-14 10:20:35','',''),(5218,'1','219','1',1,'Retail Sale Id 5292',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 10:46:23','',''),(5219,'1','219','1',1,'Retail Sale Id 5293',998.52,0.00,0.00,1.57,53.38,'2022-05-14 10:51:20','',''),(5220,'1','219','1',1,'Retail Sale Id 5294',1500.96,0.00,0.00,2.36,80.24,'2022-05-14 11:10:35','',''),(5221,'1','219','1',1,'Retail Sale Id 5295',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 11:24:38','',''),(5222,'1','219','1',1,'Retail Sale Id 5296',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 11:25:16','',''),(5223,'1','219','1',1,'Retail Sale Id 5297',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 11:33:30','',''),(5224,'1','219','1',1,'Retail Sale Id 5298',7675.00,0.00,0.00,12.50,150.00,'2022-05-14 11:40:30','',''),(5225,'1','219','1',1,'Retail Sale Id 5299',3070.00,0.00,0.00,5.00,60.00,'2022-05-14 11:41:52','',''),(5226,'1','219','1',1,'Retail Sale Id 5301',5997.48,0.00,0.00,9.43,320.62,'2022-05-14 11:45:15','',''),(5227,'1','219','1',1,'Retail Sale Id 5302',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 11:52:58','',''),(5228,'1','219','1',1,'Retail Sale Id 5303',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 11:58:25','',''),(5229,'1','219','1',1,'Retail Sale Id 5304',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 12:02:42','',''),(5230,'1','219','1',1,'Retail Sale Id 5305',3180.00,0.00,0.00,5.00,170.00,'2022-05-14 12:10:31','',''),(5231,'1','219','1',1,'Retail Sale Id 5306',298.92,0.00,0.00,0.47,15.98,'2022-05-14 12:22:11','',''),(5232,'1','219','1',1,'Retail Sale Id 5307',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 12:36:28','',''),(5233,'1','219','1',1,'Retail Sale Id 5309',1500.96,0.00,0.00,2.36,80.24,'2022-05-14 12:53:22','',''),(5234,'1','219','1',1,'Retail Sale Id 5309',3498.00,0.00,0.00,5.50,187.00,'2022-05-14 12:53:22','',''),(5235,'1','219','1',1,'Retail Sale Id 5310',1997.04,0.00,0.00,3.14,106.76,'2022-05-14 13:05:18','',''),(5236,'1','219','1',1,'Retail Sale Id 5311',998.52,0.00,0.00,1.57,53.38,'2022-05-14 13:11:49','',''),(5237,'1','219','1',1,'Retail Sale Id 5312',7950.00,0.00,0.00,12.50,425.00,'2022-05-14 13:13:30','',''),(5238,'1','219','1',1,'Retail Sale Id 5312',7950.00,0.00,0.00,12.50,425.00,'2022-05-14 13:13:30','',''),(5239,'1','219','1',1,'Retail Sale Id 5313',6360.00,0.00,0.00,10.00,340.00,'2022-05-14 13:14:28','',''),(5240,'1','219','1',1,'Retail Sale Id 5314',998.52,0.00,0.00,1.57,53.38,'2022-05-14 13:17:23','',''),(5241,'1','219','1',1,'Retail Sale Id 5315',998.52,0.00,0.00,1.57,53.38,'2022-05-14 13:23:17','',''),(5242,'1','219','1',1,'Retail Sale Id 5316',7002.36,0.00,0.00,11.01,374.34,'2022-05-14 13:41:28','',''),(5243,'1','219','1',1,'Retail Sale Id 5317',699.60,0.00,0.00,1.10,37.40,'2022-05-14 13:45:56','',''),(5244,'1','219','1',1,'Retail Sale Id 5318',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 13:47:16','',''),(5245,'1','219','1',1,'Retail Sale Id 5319',502.44,0.00,0.00,0.79,26.86,'2022-05-14 14:13:23','',''),(5246,'1','219','1',1,'Retail Sale Id 5320',1399.20,0.00,0.00,2.20,74.80,'2022-05-14 14:14:13','',''),(5247,'1','219','1',1,'Retail Sale Id 5321',1997.04,0.00,0.00,3.14,106.76,'2022-05-14 14:16:51','',''),(5248,'1','219','1',1,'Retail Sale Id 5322',1997.04,0.00,0.00,3.14,106.76,'2022-05-14 14:34:18','',''),(5249,'1','219','1',1,'Retail Sale Id 5323',2251.44,0.00,0.00,3.54,120.36,'2022-05-14 14:57:14','',''),(5250,'1','219','1',1,'Retail Sale Id 5324',3828.72,0.00,0.00,6.02,204.68,'2022-05-14 15:17:59','',''),(5251,'1','219','1',1,'Retail Sale Id 5326',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 15:33:15','',''),(5252,'1','219','1',1,'Retail Sale Id 5326',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 15:33:15','',''),(5253,'1','219','1',1,'Retail Sale Id 5327',3180.00,0.00,0.00,5.00,170.00,'2022-05-14 15:40:27','',''),(5254,'1','219','1',1,'Retail Sale Id 5328',36840.00,0.00,0.00,60.00,720.00,'2022-05-14 15:56:55','',''),(5255,'1','219','1',1,'Retail Sale Id 5329',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 16:01:28','',''),(5256,'1','219','1',1,'Retail Sale Id 5329',3180.00,0.00,0.00,5.00,170.00,'2022-05-14 16:01:28','',''),(5257,'1','219','1',1,'Retail Sale Id 5330',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 16:02:14','',''),(5258,'1','219','1',1,'Retail Sale Id 5331',998.52,0.00,0.00,1.57,53.38,'2022-05-14 16:03:13','',''),(5259,'1','219','1',1,'Retail Sale Id 5332',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 16:11:40','',''),(5260,'1','219','1',1,'Retail Sale Id 5333',1997.04,0.00,0.00,3.14,106.76,'2022-05-14 16:23:40','',''),(5261,'1','219','1',1,'Retail Sale Id 5334',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 16:42:41','',''),(5262,'1','219','1',1,'Retail Sale Id 5335',3001.92,0.00,0.00,4.72,160.48,'2022-05-14 16:47:26','',''),(5263,'1','219','1',1,'Retail Sale Id 5336',6360.00,0.00,0.00,10.00,340.00,'2022-05-14 16:49:35','',''),(5264,'1','219','1',1,'Retail Sale Id 5337',1842.00,0.00,0.00,3.00,36.00,'2022-05-14 16:53:41','',''),(5265,'1','219','1',1,'Retail Sale Id 5338',7950.00,0.00,0.00,12.50,425.00,'2022-05-14 16:56:26','',''),(5266,'1','219','1',1,'Retail Sale Id 5339',1698.12,0.00,0.00,2.67,90.78,'2022-05-14 17:01:02','',''),(5267,'1','219','1',1,'Retail Sale Id 5340',1297.44,0.00,0.00,2.04,69.36,'2022-05-14 17:05:22','',''),(5268,'1','219','1',1,'Retail Sale Id 5341',1901.64,0.00,0.00,2.99,101.66,'2022-05-14 17:11:36','',''),(5269,'1','219','1',1,'Retail Sale Id 5342',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 17:15:42','',''),(5270,'1','219','1',1,'Retail Sale Id 5343',1590.00,0.00,0.00,2.50,85.00,'2022-05-14 17:23:31','',''),(5271,'1','219','1',1,'Retail Sale Id 5343',1590.00,0.00,0.00,2.50,85.00,'2022-05-14 17:23:31','',''),(5272,'1','219','1',1,'Retail Sale Id 5344',298.92,0.00,0.00,0.47,15.98,'2022-05-14 17:27:03','',''),(5273,'1','219','1',1,'Retail Sale Id 5346',6398.16,0.00,0.00,10.06,342.04,'2022-05-14 17:31:30','',''),(5274,'1','219','1',1,'Retail Sale Id 5347',998.52,0.00,0.00,1.57,53.38,'2022-05-14 17:32:43','',''),(5275,'1','219','1',1,'Retail Sale Id 5348',1997.04,0.00,0.00,3.14,106.76,'2022-05-14 17:38:52','',''),(5276,'1','219','1',1,'Retail Sale Id 5349',1500.96,0.00,0.00,2.36,80.24,'2022-05-14 17:54:52','',''),(5277,'1','219','1',1,'Retail Sale Id 5350',502.44,0.00,0.00,0.79,26.86,'2022-05-14 17:58:33','',''),(5278,'1','219','1',1,'Retail Sale Id 5351',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 18:01:55','',''),(5279,'1','219','1',1,'Retail Sale Id 5352',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 18:07:26','',''),(5280,'1','219','1',1,'Retail Sale Id 5353',4000.44,0.00,0.00,6.29,213.86,'2022-05-14 18:16:26','',''),(5281,'1','219','1',1,'Retail Sale Id 5354',3822.36,0.00,0.00,6.01,204.34,'2022-05-14 18:18:31','',''),(5282,'1','219','1',1,'Retail Sale Id 5355',1908.00,0.00,0.00,3.00,102.00,'2022-05-14 18:25:23','',''),(5283,'1','219','1',1,'Retail Sale Id 5357',4502.88,0.00,0.00,7.08,240.72,'2022-05-14 18:38:10','',''),(5284,'1','219','1',1,'Retail Sale Id 5358',3180.00,0.00,0.00,5.00,170.00,'2022-05-14 18:48:00','',''),(5285,'1','219','1',1,'Retail Sale Id 5359',2101.92,0.00,0.00,3.02,283.88,'2022-05-15 07:29:12','',''),(5286,'1','219','1',1,'Retail Sale Id 5359',2101.92,0.00,0.00,3.02,283.88,'2022-05-15 07:29:12','',''),(5287,'1','219','1',1,'Retail Sale Id 5360',2101.92,0.00,0.00,3.02,283.88,'2022-05-15 07:30:31','',''),(5288,'1','219','1',1,'Retail Sale Id 5361',1698.24,0.00,0.00,2.44,229.36,'2022-05-15 07:41:05','',''),(5289,'1','219','1',1,'Retail Sale Id 5362',1503.36,0.00,0.00,2.16,203.04,'2022-05-15 08:17:16','',''),(5290,'1','219','1',1,'Retail Sale Id 5364',4002.00,0.00,0.00,5.75,540.50,'2022-05-15 08:22:28','',''),(5291,'1','219','1',1,'Retail Sale Id 5365',2101.92,0.00,0.00,3.02,283.88,'2022-05-15 08:55:38','',''),(5292,'1','219','1',1,'Retail Sale Id 5366',8700.00,0.00,0.00,12.50,1175.00,'2022-05-15 09:00:46','',''),(5293,'1','219','1',1,'Retail Sale Id 5367',4002.00,0.00,0.00,5.75,540.50,'2022-05-15 09:06:30','',''),(5294,'1','219','1',1,'Retail Sale Id 5368',3250.32,0.00,0.00,4.67,438.98,'2022-05-15 09:08:06','',''),(5295,'1','219','1',1,'Retail Sale Id 5369',1398.96,0.00,0.00,2.01,188.94,'2022-05-15 09:09:45','',''),(5296,'1','219','1',1,'Retail Sale Id 5370',8498.16,0.00,0.00,12.21,1147.74,'2022-05-15 09:22:36','',''),(5297,'1','219','1',1,'Retail Sale Id 5371',2101.92,0.00,0.00,3.02,283.88,'2022-05-15 09:25:46','',''),(5298,'1','219','1',1,'Retail Sale Id 5372',8700.00,0.00,0.00,12.50,1175.00,'2022-05-15 09:40:36','',''),(5299,'1','219','1',1,'Retail Sale Id 5373',897.84,0.00,0.00,1.29,121.26,'2022-05-15 10:04:20','',''),(5300,'1','219','1',1,'Retail Sale Id 5375',6960.00,0.00,0.00,10.00,940.00,'2022-05-15 10:11:54','',''),(5301,'1','219','1',1,'Retail Sale Id 5376',2101.92,0.00,0.00,3.02,283.88,'2022-05-15 10:15:58','',''),(5302,'1','219','1',1,'Retail Sale Id 5377',8700.00,0.00,0.00,12.50,1175.00,'2022-05-15 10:24:58','',''),(5303,'1','219','1',1,'Retail Sale Id 5378',3260.00,0.00,0.00,5.00,250.00,'2022-05-15 10:27:46','',''),(5304,'1','219','1',1,'Retail Sale Id 5380',501.12,0.00,0.00,0.72,67.68,'2022-05-15 10:31:11','',''),(5305,'1','219','1',1,'Retail Sale Id 5381',1956.00,0.00,0.00,3.00,150.00,'2022-05-15 10:35:10','',''),(5306,'1','219','1',1,'Retail Sale Id 5382',2999.76,0.00,0.00,4.31,405.14,'2022-05-15 10:40:58','',''),(5307,'1','219','1',1,'Retail Sale Id 5383',8700.00,0.00,0.00,12.50,1175.00,'2022-05-15 10:48:13','',''),(5308,'1','219','1',1,'Retail Sale Id 5383',8700.00,0.00,0.00,12.50,1175.00,'2022-05-15 10:48:13','',''),(5309,'1','219','1',1,'Retail Sale Id 5384',702.96,0.00,0.00,1.01,94.94,'2022-05-15 10:50:15','',''),(5310,'1','219','1',1,'Retail Sale Id 5386',1398.96,0.00,0.00,2.01,188.94,'2022-05-15 11:20:20','',''),(5311,'1','219','1',1,'Retail Sale Id 5387',2797.92,0.00,0.00,4.02,377.88,'2022-05-15 11:26:07','',''),(5312,'1','219','1',1,'Retail Sale Id 5388',1802.64,0.00,0.00,2.59,243.46,'2022-05-15 11:27:28','',''),(5313,'1','219','1',1,'Retail Sale Id 5389',1002.24,0.00,0.00,1.44,135.36,'2022-05-15 11:38:18','',''),(5314,'1','219','1',1,'Retail Sale Id 5390',4176.00,0.00,0.00,6.00,564.00,'2022-05-15 11:46:37','',''),(5315,'1','219','1',1,'Retail Sale Id 5391',4878.96,0.00,0.00,7.01,658.94,'2022-05-15 11:51:10','',''),(5316,'1','219','1',1,'Retail Sale Id 5393',4182.96,0.00,0.00,6.01,564.94,'2022-05-15 11:59:24','',''),(5317,'1','219','1',1,'Retail Sale Id 5394',1997.52,0.00,0.00,2.87,269.78,'2022-05-15 12:11:24','',''),(5318,'1','219','1',1,'Retail Sale Id 5395',2101.92,0.00,0.00,3.02,283.88,'2022-05-15 12:27:46','',''),(5319,'1','219','1',1,'Retail Sale Id 5396',800.40,0.00,0.00,1.15,108.10,'2022-05-15 12:35:44','',''),(5320,'1','219','1',1,'Retail Sale Id 5397',1997.52,0.00,0.00,2.87,269.78,'2022-05-15 13:09:53','',''),(5321,'1','219','1',1,'Retail Sale Id 5398',2999.76,0.00,0.00,4.31,405.14,'2022-05-15 13:30:27','',''),(5322,'1','219','1',1,'Retail Sale Id 5399',1997.52,0.00,0.00,2.87,269.78,'2022-05-15 13:41:19','',''),(5323,'1','219','1',1,'Retail Sale Id 5400',1802.64,0.00,0.00,2.59,243.46,'2022-05-15 13:43:09','',''),(5324,'1','219','1',1,'Retail Sale Id 5401',4196.88,0.00,0.00,6.03,566.82,'2022-05-15 13:45:34','',''),(5325,'1','219','1',1,'Retail Sale Id 5402',4196.88,0.00,0.00,6.03,566.82,'2022-05-15 13:59:18','',''),(5326,'1','219','1',1,'Retail Sale Id 5404',1050.96,0.00,0.00,1.51,141.94,'2022-05-15 14:01:11','',''),(5327,'1','219','1',1,'Retail Sale Id 5405',7172.00,0.00,0.00,11.00,550.00,'2022-05-15 14:13:04','',''),(5328,'1','219','1',1,'Retail Sale Id 5406',4196.88,0.00,0.00,6.03,566.82,'2022-05-15 14:14:17','',''),(5329,'1','219','1',1,'Retail Sale Id 5407',3260.00,0.00,0.00,5.00,250.00,'2022-05-15 14:20:58','',''),(5330,'1','219','1',1,'Retail Sale Id 5408',6960.00,0.00,0.00,10.00,940.00,'2022-05-15 14:23:19','',''),(5331,'1','219','1',1,'Retail Sale Id 5409',2999.76,0.00,0.00,4.31,405.14,'2022-05-15 14:26:27','',''),(5332,'1','219','1',1,'Retail Sale Id 5410',2101.92,0.00,0.00,3.02,283.88,'2022-05-15 14:33:02','',''),(5333,'1','219','1',1,'Retail Sale Id 5411',4196.88,0.00,0.00,6.03,566.82,'2022-05-15 14:45:26','',''),(5334,'1','219','1',1,'Retail Sale Id 5412',1398.96,0.00,0.00,2.01,188.94,'2022-05-15 14:47:32','',''),(5335,'1','219','1',1,'Retail Sale Id 5413',702.96,0.00,0.00,1.01,94.94,'2022-05-15 14:53:00','',''),(5336,'1','219','1',1,'Retail Sale Id 5414',4182.96,0.00,0.00,6.01,564.94,'2022-05-15 15:16:18','',''),(5337,'1','219','1',1,'Retail Sale Id 5415',4997.28,0.00,0.00,7.18,674.92,'2022-05-15 15:21:49','',''),(5338,'1','219','1',1,'Retail Sale Id 5416',7997.04,0.00,0.00,11.49,1080.06,'2022-05-15 15:24:46','',''),(5339,'1','219','1',1,'Retail Sale Id 5417',3480.00,0.00,0.00,5.00,470.00,'2022-05-15 15:37:18','',''),(5340,'1','219','1',1,'Retail Sale Id 5418',8700.00,0.00,0.00,12.50,1175.00,'2022-05-15 15:43:15','',''),(5341,'1','219','1',1,'Retail Sale Id 5420',702.96,0.00,0.00,1.01,94.94,'2022-05-15 15:45:08','',''),(5342,'1','219','1',1,'Retail Sale Id 5421',4997.28,0.00,0.00,7.18,674.92,'2022-05-15 15:47:28','',''),(5343,'1','219','1',1,'Retail Sale Id 5422',8700.00,0.00,0.00,12.50,1175.00,'2022-05-15 15:52:30','',''),(5344,'1','219','1',1,'Retail Sale Id 5423',3500.88,0.00,0.00,5.03,472.82,'2022-05-15 16:08:45','',''),(5345,'1','219','1',1,'Retail Sale Id 5424',4182.96,0.00,0.00,6.01,564.94,'2022-05-15 16:21:54','',''),(5346,'1','219','1',1,'Retail Sale Id 5425',1002.24,0.00,0.00,1.44,135.36,'2022-05-15 16:30:23','',''),(5347,'1','219','1',1,'Retail Sale Id 5426',8700.00,0.00,0.00,12.50,1175.00,'2022-05-15 16:46:08','',''),(5348,'1','219','1',1,'Retail Sale Id 5427',1997.52,0.00,0.00,2.87,269.78,'2022-05-15 16:53:01','',''),(5349,'1','219','1',1,'Retail Sale Id 5428',1002.24,0.00,0.00,1.44,135.36,'2022-05-15 16:55:20','',''),(5350,'1','219','1',1,'Retail Sale Id 5429',1997.52,0.00,0.00,2.87,269.78,'2022-05-15 17:03:02','',''),(5351,'1','219','1',1,'Retail Sale Id 5430',8700.00,0.00,0.00,12.50,1175.00,'2022-05-15 17:20:52','',''),(5352,'1','219','1',1,'Retail Sale Id 5431',1002.24,0.00,0.00,1.44,135.36,'2022-05-15 17:32:18','',''),(5353,'1','219','1',1,'Retail Sale Id 5432',8700.00,0.00,0.00,12.50,1175.00,'2022-05-15 17:39:11','',''),(5354,'1','219','1',1,'Retail Sale Id 5433',1997.52,0.00,0.00,2.87,269.78,'2022-05-15 17:48:01','',''),(5355,'1','219','1',1,'Retail Sale Id 5433',1997.52,0.00,0.00,2.87,269.78,'2022-05-15 17:48:01','',''),(5356,'1','219','1',1,'Retail Sale Id 5434',2101.92,0.00,0.00,3.02,283.88,'2022-05-15 17:51:40','',''),(5357,'1','219','1',1,'Retail Sale Id 5435',1997.52,0.00,0.00,2.87,269.78,'2022-05-15 18:02:02','',''),(5358,'1','219','1',1,'Retail Sale Id 5436',1997.52,0.00,0.00,2.87,269.78,'2022-05-15 18:25:45','',''),(5359,'1','219','1',1,'Retail Sale Id 5437',1197.12,0.00,0.00,1.72,161.68,'2022-05-15 18:29:46','',''),(5360,'1','219','1',1,'Retail Sale Id 5438',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 07:47:32','',''),(5361,'1','219','1',1,'Retail Sale Id 5439',1997.52,0.00,0.00,2.87,269.78,'2022-05-16 07:56:01','',''),(5362,'1','219','1',1,'Retail Sale Id 5440',702.96,0.00,0.00,1.01,94.94,'2022-05-16 07:56:55','',''),(5363,'1','219','1',1,'Retail Sale Id 5441',8700.00,0.00,0.00,12.50,1175.00,'2022-05-16 07:58:13','',''),(5364,'1','219','1',1,'Retail Sale Id 5442',167564.00,0.00,0.00,257.00,12850.00,'2022-05-16 08:05:29','',''),(5365,'1','219','1',1,'Retail Sale Id 5443',1802.64,0.00,0.00,2.59,243.46,'2022-05-16 08:38:34','',''),(5366,'1','219','1',1,'Retail Sale Id 5444',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 09:17:57','',''),(5367,'1','219','1',1,'Retail Sale Id 5445',501.12,0.00,0.00,0.72,67.68,'2022-05-16 09:21:22','',''),(5368,'1','219','1',1,'Retail Sale Id 5446',702.96,0.00,0.00,1.01,94.94,'2022-05-16 09:22:14','',''),(5369,'1','219','1',1,'Retail Sale Id 5447',6096.96,0.00,0.00,8.76,823.44,'2022-05-16 09:23:17','',''),(5370,'1','219','1',1,'Retail Sale Id 5448',7997.04,0.00,0.00,11.49,1080.06,'2022-05-16 09:44:42','',''),(5371,'1','219','1',1,'Retail Sale Id 5449',3480.00,0.00,0.00,5.00,470.00,'2022-05-16 09:50:48','',''),(5372,'1','219','1',1,'Retail Sale Id 5450',1503.36,0.00,0.00,2.16,203.04,'2022-05-16 09:53:15','',''),(5373,'1','219','1',1,'Retail Sale Id 5451',2199.36,0.00,0.00,3.16,297.04,'2022-05-16 10:04:09','',''),(5374,'1','219','1',1,'Retail Sale Id 5452',8700.00,0.00,0.00,12.50,1175.00,'2022-05-16 10:16:54','',''),(5375,'1','219','1',1,'Retail Sale Id 5453',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 10:30:29','',''),(5376,'1','219','1',1,'Retail Sale Id 5454',2101.92,0.00,0.00,3.02,283.88,'2022-05-16 10:37:37','',''),(5377,'1','219','1',1,'Retail Sale Id 5455',2101.92,0.00,0.00,3.02,283.88,'2022-05-16 10:38:45','',''),(5378,'1','219','1',1,'Retail Sale Id 5456',1503.36,0.00,0.00,2.16,203.04,'2022-05-16 10:43:25','',''),(5379,'1','219','1',1,'Retail Sale Id 5457',8700.00,0.00,0.00,12.50,1175.00,'2022-05-16 10:55:12','',''),(5380,'1','219','1',1,'Retail Sale Id 5458',299.28,0.00,0.00,0.43,40.42,'2022-05-16 11:07:27','',''),(5381,'1','219','1',1,'Retail Sale Id 5459',6960.00,0.00,0.00,10.00,940.00,'2022-05-16 11:10:56','',''),(5382,'1','219','1',1,'Retail Sale Id 5460',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 11:12:09','',''),(5383,'1','219','1',1,'Retail Sale Id 5461',6960.00,0.00,0.00,10.00,940.00,'2022-05-16 11:13:57','',''),(5384,'1','219','1',1,'Retail Sale Id 5462',2101.92,0.00,0.00,3.02,283.88,'2022-05-16 11:28:38','',''),(5385,'1','219','1',1,'Retail Sale Id 5463',5999.52,0.00,0.00,8.62,810.28,'2022-05-16 11:34:20','',''),(5386,'1','219','1',1,'Retail Sale Id 5464',1197.12,0.00,0.00,1.72,161.68,'2022-05-16 11:38:26','',''),(5387,'1','219','1',1,'Retail Sale Id 5465',1398.96,0.00,0.00,2.01,188.94,'2022-05-16 11:41:45','',''),(5388,'1','219','1',1,'Retail Sale Id 5465',1398.96,0.00,0.00,2.01,188.94,'2022-05-16 11:41:45','',''),(5389,'1','219','1',1,'Retail Sale Id 5466',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 11:46:52','',''),(5390,'1','219','1',1,'Retail Sale Id 5467',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 12:20:22','',''),(5391,'1','219','1',1,'Retail Sale Id 5468',702.96,0.00,0.00,1.01,94.94,'2022-05-16 12:34:43','',''),(5392,'1','219','1',1,'Retail Sale Id 5470',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 12:48:10','',''),(5393,'1','219','1',1,'Retail Sale Id 5471',4002.00,0.00,0.00,5.75,540.50,'2022-05-16 12:55:20','',''),(5394,'1','219','1',1,'Retail Sale Id 5471',4997.28,0.00,0.00,7.18,674.92,'2022-05-16 12:55:20','',''),(5395,'1','219','1',1,'Retail Sale Id 5472',800.40,0.00,0.00,1.15,108.10,'2022-05-16 13:14:26','',''),(5396,'1','219','1',1,'Retail Sale Id 5473',2797.92,0.00,0.00,4.02,377.88,'2022-05-16 13:18:56','',''),(5397,'1','219','1',1,'Retail Sale Id 5474',1698.24,0.00,0.00,2.44,229.36,'2022-05-16 13:32:37','',''),(5398,'1','219','1',1,'Retail Sale Id 5475',4002.00,0.00,0.00,5.75,540.50,'2022-05-16 13:34:50','',''),(5399,'1','219','1',1,'Retail Sale Id 5476',1503.36,0.00,0.00,2.16,203.04,'2022-05-16 13:39:04','',''),(5400,'1','219','1',1,'Retail Sale Id 5477',396.72,0.00,0.00,0.57,53.58,'2022-05-16 13:57:53','',''),(5401,'1','219','1',1,'Retail Sale Id 5478',2797.92,0.00,0.00,4.02,377.88,'2022-05-16 14:22:43','',''),(5402,'1','219','1',1,'Retail Sale Id 5479',1956.00,0.00,0.00,3.00,150.00,'2022-05-16 14:58:54','',''),(5403,'1','219','1',1,'Retail Sale Id 5480',501.12,0.00,0.00,0.72,67.68,'2022-05-16 15:09:52','',''),(5404,'1','219','1',1,'Retail Sale Id 5481',4002.00,0.00,0.00,5.75,540.50,'2022-05-16 15:38:54','',''),(5405,'1','219','1',1,'Retail Sale Id 5483',3480.00,0.00,0.00,5.00,470.00,'2022-05-16 15:48:48','',''),(5406,'1','219','1',1,'Retail Sale Id 5484',1997.52,0.00,0.00,2.87,269.78,'2022-05-16 15:50:12','',''),(5407,'1','219','1',1,'Retail Sale Id 5485',501.12,0.00,0.00,0.72,67.68,'2022-05-16 16:14:23','',''),(5408,'1','219','1',1,'Retail Sale Id 5486',2101.92,0.00,0.00,3.02,283.88,'2022-05-16 16:16:21','',''),(5409,'1','219','1',1,'Retail Sale Id 5487',2101.92,0.00,0.00,3.02,283.88,'2022-05-16 16:17:28','',''),(5410,'1','219','1',1,'Retail Sale Id 5488',8700.00,0.00,0.00,12.50,1175.00,'2022-05-16 16:22:05','',''),(5411,'1','219','1',1,'Retail Sale Id 5489',1503.36,0.00,0.00,2.16,203.04,'2022-05-16 16:26:24','',''),(5412,'1','219','1',1,'Retail Sale Id 5490',1002.24,0.00,0.00,1.44,135.36,'2022-05-16 16:27:20','',''),(5413,'1','219','1',1,'Retail Sale Id 5492',3500.88,0.00,0.00,5.03,472.82,'2022-05-16 16:28:47','',''),(5414,'1','219','1',1,'Retail Sale Id 5494',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 16:32:40','',''),(5415,'1','219','1',1,'Retail Sale Id 5496',3500.88,0.00,0.00,5.03,472.82,'2022-05-16 16:34:50','',''),(5416,'1','219','1',1,'Retail Sale Id 5497',647.28,0.00,0.00,0.93,87.42,'2022-05-16 16:35:55','',''),(5417,'1','219','1',1,'Retail Sale Id 5499',1002.24,0.00,0.00,1.44,135.36,'2022-05-16 16:37:48','',''),(5418,'1','219','1',1,'Retail Sale Id 5499',7001.76,0.00,0.00,10.06,945.64,'2022-05-16 16:37:48','',''),(5419,'1','219','1',1,'Retail Sale Id 5500',4002.00,0.00,0.00,5.75,540.50,'2022-05-16 16:39:47','',''),(5420,'1','219','1',1,'Retail Sale Id 5501',3912.00,0.00,0.00,6.00,300.00,'2022-05-16 16:41:36','',''),(5421,'1','219','1',1,'Retail Sale Id 5502',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 16:51:22','',''),(5422,'1','219','1',1,'Retail Sale Id 5503',2101.92,0.00,0.00,3.02,283.88,'2022-05-16 16:52:44','',''),(5423,'1','219','1',1,'Retail Sale Id 5504',1350.24,0.00,0.00,1.94,182.36,'2022-05-16 16:58:19','',''),(5424,'1','219','1',1,'Retail Sale Id 5505',3480.00,0.00,0.00,5.00,470.00,'2022-05-16 17:03:08','',''),(5425,'1','219','1',1,'Retail Sale Id 5506',3480.00,0.00,0.00,5.00,470.00,'2022-05-16 17:27:38','',''),(5426,'1','219','1',1,'Retail Sale Id 5507',1301.52,0.00,0.00,1.87,175.78,'2022-05-16 17:32:02','',''),(5427,'1','219','1',1,'Retail Sale Id 5508',8700.00,0.00,0.00,12.50,1175.00,'2022-05-16 17:44:11','',''),(5428,'1','219','1',1,'Retail Sale Id 5509',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 17:46:20','',''),(5429,'1','219','1',1,'Retail Sale Id 5509',8700.00,0.00,0.00,12.50,1175.00,'2022-05-16 17:46:20','',''),(5430,'1','219','1',1,'Retail Sale Id 5509',8700.00,0.00,0.00,12.50,1175.00,'2022-05-16 17:46:20','',''),(5431,'1','219','1',1,'Retail Sale Id 5510',32600.00,0.00,0.00,50.00,2500.00,'2022-05-16 17:52:47','',''),(5432,'1','219','1',1,'Retail Sale Id 5511',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 17:53:46','',''),(5433,'1','219','1',1,'Retail Sale Id 5512',1600.80,0.00,0.00,2.30,216.20,'2022-05-16 17:59:18','',''),(5434,'1','219','1',1,'Retail Sale Id 5513',4196.88,0.00,0.00,6.03,566.82,'2022-05-16 18:02:43','',''),(5435,'1','219','1',1,'Retail Sale Id 5514',2101.92,0.00,0.00,3.02,283.88,'2022-05-16 18:04:43','',''),(5436,'1','219','1',1,'Retail Sale Id 5515',702.96,0.00,0.00,1.01,94.94,'2022-05-16 18:05:43','',''),(5437,'1','219','1',1,'Retail Sale Id 5516',1002.24,0.00,0.00,1.44,135.36,'2022-05-16 18:20:37','',''),(5438,'1','219','1',1,'Retail Sale Id 5517',4182.96,0.00,0.00,6.01,564.94,'2022-05-16 18:31:46','',''),(5439,'1','219','1',1,'Retail Sale Id 5518',1197.12,0.00,0.00,1.72,161.68,'2022-05-16 18:32:36','',''),(5440,'1','219','1',1,'Retail Sale Id 5519',2101.92,0.00,0.00,3.02,283.88,'2022-05-17 08:11:08','',''),(5441,'1','219','1',1,'Retail Sale Id 5520',6960.00,0.00,0.00,10.00,940.00,'2022-05-17 08:13:15','',''),(5442,'1','219','1',1,'Retail Sale Id 5521',6960.00,0.00,0.00,10.00,940.00,'2022-05-17 08:15:13','',''),(5443,'1','219','1',1,'Retail Sale Id 5522',702.96,0.00,0.00,1.01,94.94,'2022-05-17 08:22:24','',''),(5444,'1','219','1',1,'Retail Sale Id 5523',8303.28,0.00,0.00,11.93,1121.42,'2022-05-17 08:24:08','',''),(5445,'1','219','1',1,'Retail Sale Id 5524',2101.92,0.00,0.00,3.02,283.88,'2022-05-17 08:45:18','',''),(5446,'1','219','1',1,'Retail Sale Id 5525',4196.88,0.00,0.00,6.03,566.82,'2022-05-17 08:46:48','',''),(5447,'1','219','1',1,'Retail Sale Id 5526',702.96,0.00,0.00,1.01,94.94,'2022-05-17 08:49:21','',''),(5448,'1','219','1',1,'Retail Sale Id 5528',3500.88,0.00,0.00,5.03,472.82,'2022-05-17 08:53:10','',''),(5449,'1','219','1',1,'Retail Sale Id 5529',4196.88,0.00,0.00,6.03,566.82,'2022-05-17 08:58:01','',''),(5450,'1','219','1',1,'Retail Sale Id 5530',702.96,0.00,0.00,1.01,94.94,'2022-05-17 09:40:24','',''),(5451,'1','219','1',1,'Retail Sale Id 5531',1398.96,0.00,0.00,2.01,188.94,'2022-05-17 09:43:52','',''),(5452,'1','219','1',1,'Retail Sale Id 5532',2101.92,0.00,0.00,3.02,283.88,'2022-05-17 10:05:24','',''),(5453,'1','219','1',1,'Retail Sale Id 5533',1997.52,0.00,0.00,2.87,269.78,'2022-05-17 10:10:40','',''),(5454,'1','219','1',1,'Retail Sale Id 5534',2101.92,0.00,0.00,3.02,283.88,'2022-05-17 10:27:12','',''),(5455,'1','219','1',1,'Retail Sale Id 5535',3500.88,0.00,0.00,5.03,472.82,'2022-05-17 10:40:26','',''),(5456,'1','219','1',1,'Retail Sale Id 5536',2999.76,0.00,0.00,4.31,405.14,'2022-05-17 10:45:24','',''),(5457,'1','219','1',1,'Retail Sale Id 5537',4196.88,0.00,0.00,6.03,566.82,'2022-05-17 10:58:34','',''),(5458,'1','219','1',1,'Retail Sale Id 5538',3480.00,0.00,0.00,5.00,470.00,'2022-05-17 11:01:55','',''),(5459,'1','219','1',1,'Retail Sale Id 5539',1997.52,0.00,0.00,2.87,269.78,'2022-05-17 11:13:44','',''),(5460,'1','219','1',1,'Retail Sale Id 5540',702.96,0.00,0.00,1.01,94.94,'2022-05-17 11:14:53','',''),(5461,'1','219','1',1,'Retail Sale Id 5541',1002.24,0.00,0.00,1.44,135.36,'2022-05-17 11:21:22','',''),(5462,'1','219','1',1,'Retail Sale Id 5542',1398.96,0.00,0.00,2.01,188.94,'2022-05-17 11:24:23','',''),(5463,'1','219','1',1,'Retail Sale Id 5543',3702.72,0.00,0.00,5.32,500.08,'2022-05-17 11:25:53','',''),(5464,'1','219','1',1,'Retail Sale Id 5545',1997.52,0.00,0.00,2.87,269.78,'2022-05-17 11:28:03','',''),(5465,'1','219','1',1,'Retail Sale Id 5546',7001.76,0.00,0.00,10.06,945.64,'2022-05-17 11:30:23','',''),(5466,'1','219','1',1,'Retail Sale Id 5547',2498.64,0.00,0.00,3.59,337.46,'2022-05-17 11:46:46','',''),(5467,'1','219','1',1,'Retail Sale Id 5548',8700.00,0.00,0.00,12.50,1175.00,'2022-05-17 11:56:17','',''),(5468,'1','219','1',1,'Retail Sale Id 5548',8700.00,0.00,0.00,12.50,1175.00,'2022-05-17 11:56:17','',''),(5469,'1','219','1',1,'Retail Sale Id 5549',30702.68,0.00,0.00,47.09,2354.50,'2022-05-17 12:19:01','',''),(5470,'1','219','1',1,'Retail Sale Id 5551',4524.00,0.00,0.00,6.50,611.00,'2022-05-17 12:30:30','',''),(5471,'1','219','1',1,'Retail Sale Id 5552',1997.52,0.00,0.00,2.87,269.78,'2022-05-17 12:45:47','',''),(5472,'1','219','1',1,'Retail Sale Id 5553',8700.00,0.00,0.00,12.50,1175.00,'2022-05-17 12:48:28','',''),(5473,'1','219','1',1,'Retail Sale Id 5554',2101.92,0.00,0.00,3.02,283.88,'2022-05-17 13:06:17','',''),(5474,'1','219','1',1,'Retail Sale Id 5555',501.12,0.00,0.00,0.72,67.68,'2022-05-17 13:21:37','',''),(5475,'1','219','1',1,'Retail Sale Id 5556',4182.96,0.00,0.00,6.01,564.94,'2022-05-17 13:38:59','',''),(5476,'1','219','1',1,'Retail Sale Id 5558',4002.00,0.00,0.00,5.75,540.50,'2022-05-17 13:48:12','',''),(5477,'1','219','1',1,'Retail Sale Id 5559',4182.96,0.00,0.00,6.01,564.94,'2022-05-17 14:06:08','',''),(5478,'1','219','1',1,'Retail Sale Id 5560',8700.00,0.00,0.00,12.50,1175.00,'2022-05-17 14:10:27','',''),(5479,'1','219','1',1,'Retail Sale Id 5561',3500.88,0.00,0.00,5.03,472.82,'2022-05-17 14:40:05','',''),(5480,'1','219','1',1,'Retail Sale Id 5562',1997.52,0.00,0.00,2.87,269.78,'2022-05-17 15:12:17','',''),(5481,'1','219','1',1,'Retail Sale Id 5563',2101.92,0.00,0.00,3.02,283.88,'2022-05-17 15:26:27','',''),(5482,'1','219','1',1,'Retail Sale Id 5564',8700.00,0.00,0.00,12.50,1175.00,'2022-05-17 15:29:02','',''),(5483,'1','219','1',1,'Retail Sale Id 5565',4196.88,0.00,0.00,6.03,566.82,'2022-05-17 15:31:00','',''),(5484,'1','219','1',1,'Retail Sale Id 5566',4196.88,0.00,0.00,6.03,566.82,'2022-05-17 15:33:26','',''),(5485,'1','219','1',1,'Retail Sale Id 5567',3500.88,0.00,0.00,5.03,472.82,'2022-05-17 15:35:38','',''),(5486,'1','219','1',1,'Retail Sale Id 5568',1997.52,0.00,0.00,2.87,269.78,'2022-05-17 15:37:56','',''),(5487,'1','219','1',1,'Retail Sale Id 5568',1997.52,0.00,0.00,2.87,269.78,'2022-05-17 15:37:56','',''),(5488,'1','219','1',1,'Retail Sale Id 5569',4196.88,0.00,0.00,6.03,566.82,'2022-05-17 15:40:14','',''),(5489,'1','219','1',1,'Retail Sale Id 5570',702.96,0.00,0.00,1.01,94.94,'2022-05-17 16:12:11','',''),(5490,'1','219','1',1,'Retail Sale Id 5570',702.96,0.00,0.00,1.01,94.94,'2022-05-17 16:12:11','',''),(5491,'1','219','1',1,'Retail Sale Id 5571',1002.24,0.00,0.00,1.44,135.36,'2022-05-17 16:25:53','',''),(5492,'1','219','1',1,'Retail Sale Id 5572',4997.28,0.00,0.00,7.18,674.92,'2022-05-17 16:29:00','',''),(5493,'1','219','1',1,'Retail Sale Id 5573',1503.36,0.00,0.00,2.16,203.04,'2022-05-17 16:32:19','',''),(5494,'1','219','1',1,'Retail Sale Id 5574',396.72,0.00,0.00,0.57,53.58,'2022-05-17 16:45:33','',''),(5495,'1','219','1',1,'Retail Sale Id 5575',501.12,0.00,0.00,0.72,67.68,'2022-05-17 16:48:12','',''),(5496,'1','219','1',1,'Retail Sale Id 5575',501.12,0.00,0.00,0.72,67.68,'2022-05-17 16:48:12','',''),(5497,'1','219','1',1,'Retail Sale Id 5576',1002.24,0.00,0.00,1.44,135.36,'2022-05-17 16:51:20','',''),(5498,'1','219','1',1,'Retail Sale Id 5577',800.40,0.00,0.00,1.15,108.10,'2022-05-17 16:56:57','',''),(5499,'1','219','1',1,'Retail Sale Id 5578',1503.36,0.00,0.00,2.16,203.04,'2022-05-17 17:04:14','',''),(5500,'1','219','1',1,'Retail Sale Id 5580',2797.92,0.00,0.00,4.02,377.88,'2022-05-17 17:07:40','',''),(5501,'1','219','1',1,'Retail Sale Id 5581',2498.64,0.00,0.00,3.59,337.46,'2022-05-17 17:16:49','',''),(5502,'1','219','1',1,'Retail Sale Id 5582',1503.36,0.00,0.00,2.16,203.04,'2022-05-17 17:18:22','',''),(5503,'1','219','1',1,'Retail Sale Id 5583',1002.24,0.00,0.00,1.44,135.36,'2022-05-17 17:20:18','',''),(5504,'1','219','1',1,'Retail Sale Id 5584',1002.24,0.00,0.00,1.44,135.36,'2022-05-17 17:30:42','',''),(5505,'1','219','1',1,'Retail Sale Id 5585',1997.52,0.00,0.00,2.87,269.78,'2022-05-17 17:37:25','',''),(5506,'1','219','1',1,'Retail Sale Id 5586',8700.00,0.00,0.00,12.50,1175.00,'2022-05-17 17:46:54','',''),(5507,'1','219','1',1,'Retail Sale Id 5587',1997.52,0.00,0.00,2.87,269.78,'2022-05-17 17:48:05','',''),(5508,'1','219','1',1,'Retail Sale Id 5588',2999.76,0.00,0.00,4.31,405.14,'2022-05-17 17:57:21','',''),(5509,'1','219','1',1,'Retail Sale Id 5589',800.40,0.00,0.00,1.15,108.10,'2022-05-17 18:07:27','',''),(5510,'1','219','1',1,'Retail Sale Id 5590',4182.96,0.00,0.00,6.01,564.94,'2022-05-17 18:15:57','',''),(5511,'1','219','1',1,'Retail Sale Id 5591',501.12,0.00,0.00,0.72,67.68,'2022-05-17 18:29:46','',''),(5512,'1','219','1',1,'Retail Sale Id 5592',45240.00,0.00,0.00,65.00,6110.00,'2022-05-17 18:46:39','',''),(5513,'1','219','1',1,'Retail Sale Id 5593',4196.88,0.00,0.00,6.03,566.82,'2022-05-17 18:49:11','',''),(5514,'1','219','1',1,'Return of Retail Sale Id 5560',0.00,8700.00,12.50,0.00,-1175.00,'2022-05-17 23:21:22','',''),(5515,'1','219','1',1,'Retail Sale Id 5594',2199.36,0.00,0.00,3.16,297.04,'2022-05-18 07:31:00','',''),(5516,'1','219','1',1,'Retail Sale Id 5595',1997.52,0.00,0.00,2.87,269.78,'2022-05-18 07:42:56','',''),(5517,'1','219','1',1,'Retail Sale Id 5596',501.12,0.00,0.00,0.72,67.68,'2022-05-18 08:32:52','',''),(5518,'1','219','1',1,'Retail Sale Id 5597',4182.96,0.00,0.00,6.01,564.94,'2022-05-18 08:57:41','',''),(5519,'1','219','1',1,'Retail Sale Id 5597',4182.96,0.00,0.00,6.01,564.94,'2022-05-18 08:57:41','',''),(5520,'1','219','1',1,'Retail Sale Id 5598',4196.88,0.00,0.00,6.03,566.82,'2022-05-18 09:14:28','',''),(5521,'1','219','1',1,'Retail Sale Id 5599',2101.92,0.00,0.00,3.02,283.88,'2022-05-18 09:37:28','',''),(5522,'1','219','1',1,'Retail Sale Id 5600',7502.88,0.00,0.00,10.78,1013.32,'2022-05-18 09:57:46','',''),(5523,'1','219','1',1,'Retail Sale Id 5601',1002.24,0.00,0.00,1.44,135.36,'2022-05-18 10:02:54','',''),(5524,'1','219','1',1,'Retail Sale Id 5602',5216.00,0.00,0.00,8.00,400.00,'2022-05-18 10:13:46','',''),(5525,'1','219','1',1,'Retail Sale Id 5603',6960.00,0.00,0.00,10.00,940.00,'2022-05-18 10:25:10','',''),(5526,'1','219','1',1,'Retail Sale Id 5604',1398.96,0.00,0.00,2.01,188.94,'2022-05-18 10:51:17','',''),(5527,'1','219','1',1,'Retail Sale Id 5605',1503.36,0.00,0.00,2.16,203.04,'2022-05-18 11:19:17','',''),(5528,'1','219','1',1,'Retail Sale Id 5607',2797.92,0.00,0.00,4.02,377.88,'2022-05-18 11:24:56','',''),(5529,'1','219','1',1,'Retail Sale Id 5608',4182.96,0.00,0.00,6.01,564.94,'2022-05-18 11:44:21','',''),(5530,'1','219','1',1,'Retail Sale Id 5608',4182.96,0.00,0.00,6.01,564.94,'2022-05-18 11:44:21','',''),(5531,'1','219','1',1,'Retail Sale Id 5609',4182.96,0.00,0.00,6.01,564.94,'2022-05-18 11:55:15','',''),(5532,'1','219','1',1,'Retail Sale Id 5610',2101.92,0.00,0.00,3.02,283.88,'2022-05-18 11:59:44','',''),(5533,'1','219','1',1,'Retail Sale Id 5611',4182.96,0.00,0.00,6.01,564.94,'2022-05-18 12:07:51','',''),(5534,'1','219','1',1,'Retail Sale Id 5611',6960.00,0.00,0.00,10.00,940.00,'2022-05-18 12:07:51','',''),(5535,'1','219','1',1,'Retail Sale Id 5612',2101.92,0.00,0.00,3.02,283.88,'2022-05-18 12:26:53','',''),(5536,'1','219','1',1,'Retail Sale Id 5613',1503.36,0.00,0.00,2.16,203.04,'2022-05-18 12:35:01','',''),(5537,'1','219','1',1,'Retail Sale Id 5615',1997.52,0.00,0.00,2.87,269.78,'2022-05-18 12:41:19','',''),(5538,'1','219','1',1,'Retail Sale Id 5616',4182.96,0.00,0.00,6.01,564.94,'2022-05-18 13:02:08','',''),(5539,'1','219','1',1,'Retail Sale Id 5617',2999.76,0.00,0.00,4.31,405.14,'2022-05-18 13:12:55','',''),(5540,'1','219','1',1,'Retail Sale Id 5618',501.12,0.00,0.00,0.72,67.68,'2022-05-18 13:17:35','',''),(5541,'1','219','1',1,'Retail Sale Id 5619',1503.36,0.00,0.00,2.16,203.04,'2022-05-18 13:37:37','',''),(5542,'1','219','1',1,'Retail Sale Id 5620',2700.48,0.00,0.00,3.88,364.72,'2022-05-18 13:39:33','',''),(5543,'1','219','1',1,'Retail Sale Id 5621',2001.64,0.00,0.00,3.07,153.50,'2022-05-18 13:54:30','',''),(5544,'1','219','1',1,'Retail Sale Id 5622',1997.52,0.00,0.00,2.87,269.78,'2022-05-18 14:28:16','',''),(5545,'1','219','1',1,'Retail Sale Id 5623',2797.92,0.00,0.00,4.02,377.88,'2022-05-18 14:51:50','',''),(5546,'1','219','1',1,'Retail Sale Id 5624',1997.52,0.00,0.00,2.87,269.78,'2022-05-18 15:04:49','',''),(5547,'1','219','1',1,'Retail Sale Id 5626',34800.00,0.00,0.00,50.00,4700.00,'2022-05-18 15:12:27','',''),(5548,'1','219','1',1,'Retail Sale Id 5626',34800.00,0.00,0.00,50.00,4700.00,'2022-05-18 15:12:27','',''),(5549,'1','219','1',1,'Retail Sale Id 5628',6960.00,0.00,0.00,10.00,940.00,'2022-05-18 15:21:57','',''),(5550,'1','219','1',1,'Retail Sale Id 5629',299.28,0.00,0.00,0.43,40.42,'2022-05-18 15:37:33','',''),(5551,'1','219','1',1,'Retail Sale Id 5630',4196.88,0.00,0.00,6.03,566.82,'2022-05-18 16:02:17','',''),(5552,'1','219','1',1,'Retail Sale Id 5631',1956.00,0.00,0.00,3.00,150.00,'2022-05-18 16:08:01','',''),(5553,'1','219','1',1,'Retail Sale Id 5632',1503.36,0.00,0.00,2.16,203.04,'2022-05-18 16:09:46','',''),(5554,'1','219','1',1,'Retail Sale Id 5633',4196.88,0.00,0.00,6.03,566.82,'2022-05-18 16:26:17','',''),(5555,'1','219','1',1,'Retail Sale Id 5634',1398.96,0.00,0.00,2.01,188.94,'2022-05-18 16:28:41','',''),(5556,'1','219','1',1,'Retail Sale Id 5636',2101.92,0.00,0.00,3.02,283.88,'2022-05-18 16:35:05','',''),(5557,'1','219','1',1,'Retail Sale Id 5636',2101.92,0.00,0.00,3.02,283.88,'2022-05-18 16:35:05','',''),(5558,'1','219','1',1,'Retail Sale Id 5637',1802.64,0.00,0.00,2.59,243.46,'2022-05-18 16:38:22','',''),(5559,'1','219','1',1,'Retail Sale Id 5638',1398.96,0.00,0.00,2.01,188.94,'2022-05-18 16:40:10','',''),(5560,'1','219','1',1,'Retail Sale Id 5639',1398.96,0.00,0.00,2.01,188.94,'2022-05-18 16:49:57','',''),(5561,'1','219','1',1,'Retail Sale Id 5640',2101.92,0.00,0.00,3.02,283.88,'2022-05-18 17:04:47','',''),(5562,'1','219','1',1,'Retail Sale Id 5641',1002.24,0.00,0.00,1.44,135.36,'2022-05-18 17:05:49','',''),(5563,'1','219','1',1,'Retail Sale Id 5642',4002.00,0.00,0.00,5.75,540.50,'2022-05-18 17:08:59','',''),(5564,'1','219','1',1,'Retail Sale Id 5643',1002.24,0.00,0.00,1.44,135.36,'2022-05-18 17:17:11','',''),(5565,'1','219','1',1,'Retail Sale Id 5645',1997.52,0.00,0.00,2.87,269.78,'2022-05-18 17:18:09','',''),(5566,'1','219','1',1,'Retail Sale Id 5646',7697.76,0.00,0.00,11.06,1039.64,'2022-05-18 17:24:37','',''),(5567,'1','219','1',1,'Retail Sale Id 5647',8700.00,0.00,0.00,12.50,1175.00,'2022-05-18 17:27:19','',''),(5568,'1','219','1',1,'Retail Sale Id 5648',1997.52,0.00,0.00,2.87,269.78,'2022-05-18 17:28:55','',''),(5569,'1','219','1',1,'Retail Sale Id 5649',1900.08,0.00,0.00,2.73,256.62,'2022-05-18 17:39:38','',''),(5570,'1','219','1',1,'Retail Sale Id 5650',4872.00,0.00,0.00,7.00,658.00,'2022-05-18 17:44:49','',''),(5571,'1','219','1',1,'Retail Sale Id 5651',4182.96,0.00,0.00,6.01,564.94,'2022-05-18 17:49:07','',''),(5572,'1','219','1',1,'Retail Sale Id 5652',3500.88,0.00,0.00,5.03,472.82,'2022-05-18 17:53:55','',''),(5573,'1','219','1',1,'Retail Sale Id 5653',702.96,0.00,0.00,1.01,94.94,'2022-05-18 18:01:23','',''),(5574,'1','219','1',1,'Retail Sale Id 5654',2797.92,0.00,0.00,4.02,377.88,'2022-05-18 18:04:39','',''),(5575,'1','219','1',1,'Retail Sale Id 5655',1002.24,0.00,0.00,1.44,135.36,'2022-05-18 18:05:27','',''),(5576,'1','219','1',1,'Retail Sale Id 5656',1301.52,0.00,0.00,1.87,175.78,'2022-05-18 18:06:28','',''),(5577,'1','219','1',1,'Retail Sale Id 5657',8700.00,0.00,0.00,12.50,1175.00,'2022-05-18 18:10:18','',''),(5578,'1','219','1',1,'Retail Sale Id 5659',299.28,0.00,0.00,0.43,40.42,'2022-05-18 18:11:38','',''),(5579,'1','219','1',1,'Retail Sale Id 5660',1002.24,0.00,0.00,1.44,135.36,'2022-05-18 18:12:55','',''),(5580,'1','219','1',1,'Retail Sale Id 5661',4196.88,0.00,0.00,6.03,566.82,'2022-05-18 18:25:17','',''),(5581,'1','219','1',1,'Retail Sale Id 5662',8700.00,0.00,0.00,12.50,1175.00,'2022-05-18 18:27:22','',''),(5582,'1','219','1',1,'Retail Sale Id 5663',2101.92,0.00,0.00,3.02,283.88,'2022-05-18 18:44:32','',''),(5583,'1','219','1',1,'Retail Sale Id 5664',1503.36,0.00,0.00,2.16,203.04,'2022-05-18 19:11:25','',''),(5584,'1','219','1',1,'Retail Sale Id 5665',702.96,0.00,0.00,1.01,94.94,'2022-05-19 07:30:55','',''),(5585,'1','219','1',1,'Retail Sale Id 5666',2101.92,0.00,0.00,3.02,283.88,'2022-05-19 08:10:18','',''),(5586,'1','219','1',1,'Retail Sale Id 5666',4196.88,0.00,0.00,6.03,566.82,'2022-05-19 08:10:18','',''),(5587,'1','219','1',1,'Retail Sale Id 5667',4997.28,0.00,0.00,7.18,674.92,'2022-05-19 08:26:23','',''),(5588,'1','219','1',1,'Retail Sale Id 5668',3500.88,0.00,0.00,5.03,472.82,'2022-05-19 08:36:06','',''),(5589,'1','219','1',1,'Retail Sale Id 5669',2101.92,0.00,0.00,3.02,283.88,'2022-05-19 08:37:11','',''),(5590,'1','219','1',1,'Retail Sale Id 5670',1503.36,0.00,0.00,2.16,203.04,'2022-05-19 08:42:24','',''),(5591,'1','219','1',1,'Retail Sale Id 5671',8700.00,0.00,0.00,12.50,1175.00,'2022-05-19 09:17:06','',''),(5592,'1','219','1',1,'Retail Sale Id 5672',4503.12,0.00,0.00,6.47,608.18,'2022-05-19 09:20:48','',''),(5593,'1','219','1',1,'Retail Sale Id 5673',4196.88,0.00,0.00,6.03,566.82,'2022-05-19 10:00:51','',''),(5594,'1','219','1',1,'Retail Sale Id 5674',8700.00,0.00,0.00,12.50,1175.00,'2022-05-19 10:18:24','',''),(5595,'1','219','1',1,'Retail Sale Id 5675',3848.88,0.00,0.00,5.53,519.82,'2022-05-19 10:26:49','',''),(5596,'1','219','1',1,'Retail Sale Id 5677',1503.36,0.00,0.00,2.16,203.04,'2022-05-19 10:32:37','',''),(5597,'1','219','1',1,'Retail Sale Id 5678',2999.76,0.00,0.00,4.31,405.14,'2022-05-19 10:34:36','',''),(5598,'1','219','1',1,'Retail Sale Id 5679',702.96,0.00,0.00,1.01,94.94,'2022-05-19 10:53:05','',''),(5599,'1','219','1',1,'Retail Sale Id 5680',501.12,0.00,0.00,0.72,67.68,'2022-05-19 11:10:08','',''),(5600,'1','219','1',1,'Retail Sale Id 5682',2999.76,0.00,0.00,4.31,405.14,'2022-05-19 11:20:35','',''),(5601,'1','219','1',1,'Retail Sale Id 5683',702.96,0.00,0.00,1.01,94.94,'2022-05-19 11:28:15','',''),(5602,'1','219','1',1,'Retail Sale Id 5684',1997.52,0.00,0.00,2.87,269.78,'2022-05-19 11:40:17','',''),(5603,'1','219','1',1,'Retail Sale Id 5685',4002.00,0.00,0.00,5.75,540.50,'2022-05-19 12:05:30','',''),(5604,'1','219','1',1,'Retail Sale Id 5686',1956.00,0.00,0.00,3.00,150.00,'2022-05-19 12:09:43','',''),(5605,'1','219','1',1,'Retail Sale Id 5687',1503.36,0.00,0.00,2.16,203.04,'2022-05-19 12:49:07','',''),(5606,'1','219','1',1,'Retail Sale Id 5688',4176.00,0.00,0.00,6.00,564.00,'2022-05-19 13:27:54','',''),(5607,'1','219','1',1,'Retail Sale Id 5689',4002.00,0.00,0.00,5.75,540.50,'2022-05-19 14:11:55','',''),(5608,'1','219','1',1,'Retail Sale Id 5690',1997.52,0.00,0.00,2.87,269.78,'2022-05-19 14:19:21','',''),(5609,'1','219','1',1,'Retail Sale Id 5691',4196.88,0.00,0.00,6.03,566.82,'2022-05-19 14:32:47','',''),(5610,'1','219','1',1,'Retail Sale Id 5692',250.56,0.00,0.00,0.36,33.84,'2022-05-19 14:52:11','',''),(5611,'1','219','1',1,'Retail Sale Id 5693',2101.92,0.00,0.00,3.02,283.88,'2022-05-19 14:55:07','',''),(5612,'1','219','1',1,'Retail Sale Id 5693',2101.92,0.00,0.00,3.02,283.88,'2022-05-19 14:55:07','',''),(5613,'1','219','1',1,'Retail Sale Id 5694',4196.88,0.00,0.00,6.03,566.82,'2022-05-19 15:06:24','',''),(5614,'1','219','1',1,'Retail Sale Id 5695',4196.88,0.00,0.00,6.03,566.82,'2022-05-19 15:11:13','',''),(5615,'1','219','1',1,'Retail Sale Id 5696',8498.16,0.00,0.00,12.21,1147.74,'2022-05-19 15:15:40','',''),(5616,'1','219','1',1,'Retail Sale Id 5697',4503.12,0.00,0.00,6.47,608.18,'2022-05-19 15:43:44','',''),(5617,'1','219','1',1,'Retail Sale Id 5698',501.12,0.00,0.00,0.72,67.68,'2022-05-19 15:48:40','',''),(5618,'1','219','1',1,'Retail Sale Id 5699',2101.92,0.00,0.00,3.02,283.88,'2022-05-19 15:52:01','',''),(5619,'1','219','1',1,'Retail Sale Id 5700',1997.52,0.00,0.00,2.87,269.78,'2022-05-19 16:02:47','',''),(5620,'1','219','1',1,'Retail Sale Id 5701',4196.88,0.00,0.00,6.03,566.82,'2022-05-19 16:17:33','',''),(5621,'1','219','1',1,'Retail Sale Id 5702',2101.92,0.00,0.00,3.02,283.88,'2022-05-19 16:21:42','',''),(5622,'1','219','1',1,'Retail Sale Id 5703',1503.36,0.00,0.00,2.16,203.04,'2022-05-19 16:23:01','',''),(5623,'1','219','1',1,'Retail Sale Id 5704',2999.76,0.00,0.00,4.31,405.14,'2022-05-19 16:24:28','',''),(5624,'1','219','1',1,'Retail Sale Id 5705',1997.52,0.00,0.00,2.87,269.78,'2022-05-19 16:34:11','',''),(5625,'1','219','1',1,'Retail Sale Id 5706',4196.88,0.00,0.00,6.03,566.82,'2022-05-19 16:36:10','',''),(5626,'1','219','1',1,'Retail Sale Id 5707',8700.00,0.00,0.00,12.50,1175.00,'2022-05-19 16:40:40','',''),(5627,'1','219','1',1,'Retail Sale Id 5707',8700.00,0.00,0.00,12.50,1175.00,'2022-05-19 16:40:40','',''),(5628,'1','219','1',1,'Retail Sale Id 5707',8700.00,0.00,0.00,12.50,1175.00,'2022-05-19 16:40:40','',''),(5629,'1','219','1',1,'Retail Sale Id 5707',8700.00,0.00,0.00,12.50,1175.00,'2022-05-19 16:40:40','',''),(5630,'1','219','1',1,'Retail Sale Id 5708',3828.00,0.00,0.00,5.50,517.00,'2022-05-19 16:41:42','',''),(5631,'1','219','1',1,'Retail Sale Id 5709',396.72,0.00,0.00,0.57,53.58,'2022-05-19 16:49:05','',''),(5632,'1','219','1',1,'Retail Sale Id 5710',1997.52,0.00,0.00,2.87,269.78,'2022-05-19 16:56:21','',''),(5633,'1','219','1',1,'Retail Sale Id 5711',1002.24,0.00,0.00,1.44,135.36,'2022-05-19 17:00:25','',''),(5634,'1','219','1',1,'Retail Sale Id 5712',4002.00,0.00,0.00,5.75,540.50,'2022-05-19 17:01:54','',''),(5635,'1','219','1',1,'Retail Sale Id 5712',4997.28,0.00,0.00,7.18,674.92,'2022-05-19 17:01:54','',''),(5636,'1','219','1',1,'Retail Sale Id 5713',2101.92,0.00,0.00,3.02,283.88,'2022-05-19 17:19:34','',''),(5637,'1','219','1',1,'Retail Sale Id 5713',2101.92,0.00,0.00,3.02,283.88,'2022-05-19 17:19:34','',''),(5638,'1','219','1',1,'Retail Sale Id 5713',3500.88,0.00,0.00,5.03,472.82,'2022-05-19 17:19:34','',''),(5639,'1','219','1',1,'Retail Sale Id 5714',4002.00,0.00,0.00,5.75,540.50,'2022-05-19 17:26:44','',''),(5640,'1','219','1',1,'Retail Sale Id 5715',702.96,0.00,0.00,1.01,94.94,'2022-05-19 17:28:01','',''),(5641,'1','219','1',1,'Retail Sale Id 5716',1503.36,0.00,0.00,2.16,203.04,'2022-05-19 17:28:50','',''),(5642,'1','219','1',1,'Retail Sale Id 5717',2101.92,0.00,0.00,3.02,283.88,'2022-05-19 17:30:02','',''),(5643,'1','219','1',1,'Retail Sale Id 5718',1997.52,0.00,0.00,2.87,269.78,'2022-05-19 17:30:50','',''),(5644,'1','219','1',1,'Retail Sale Id 5719',2797.92,0.00,0.00,4.02,377.88,'2022-05-19 17:31:59','',''),(5645,'1','219','1',1,'Retail Sale Id 5721',5199.12,0.00,0.00,7.47,702.18,'2022-05-19 17:34:47','',''),(5646,'1','219','1',1,'Retail Sale Id 5722',2101.92,0.00,0.00,3.02,283.88,'2022-05-19 17:47:36','',''),(5647,'1','219','1',1,'Retail Sale Id 5723',299.28,0.00,0.00,0.43,40.42,'2022-05-19 17:57:13','',''),(5648,'1','219','1',1,'Retail Sale Id 5724',1503.36,0.00,0.00,2.16,203.04,'2022-05-19 18:10:38','',''),(5649,'1','219','1',1,'Retail Sale Id 5725',8700.00,0.00,0.00,12.50,1175.00,'2022-05-19 18:25:02','',''),(5650,'1','219','1',1,'Retail Sale Id 5726',3500.88,0.00,0.00,5.03,472.82,'2022-05-19 18:26:50','',''),(5651,'1','219','1',1,'Retail Sale Id 5727',501.12,0.00,0.00,0.72,67.68,'2022-05-19 18:30:22','',''),(5652,'1','219','1',1,'Retail Sale Id 5728',8700.00,0.00,0.00,12.50,1175.00,'2022-05-19 18:31:37','',''),(5653,'1','219','1',1,'Retail Sale Id 5729',1503.36,0.00,0.00,2.16,203.04,'2022-05-19 18:35:41','',''),(5654,'1','219','1',1,'Retail Sale Id 5730',1197.12,0.00,0.00,1.72,161.68,'2022-05-19 19:10:05','',''),(5655,'1','219','1',1,'Retail Sale Id 5731',4176.00,0.00,0.00,6.00,564.00,'2022-05-19 19:26:05','',''),(5656,'1','219','1',1,'Retail Sale Id 5732',1002.24,0.00,0.00,1.44,135.36,'2022-05-20 08:26:29','',''),(5657,'1','219','1',1,'Retail Sale Id 5733',1398.96,0.00,0.00,2.01,188.94,'2022-05-20 08:27:22','',''),(5658,'1','219','1',1,'Retail Sale Id 5734',7997.04,0.00,0.00,11.49,1080.06,'2022-05-20 10:44:19','',''),(5659,'1','219','1',1,'Retail Sale Id 5735',0.00,0.00,0.00,0.00,0.00,'2022-05-20 10:46:04','',''),(5660,'1','219','1',1,'Distributed to OPERATIONAL LOST for sales id:8',13388.48,0.00,0.00,22.24,0.00,'2022-05-20 12:02:51','',''),(5661,'1','219','1',1,'Retail Sale Id 5736',69.60,0.00,0.00,0.10,9.40,'2022-05-20 12:05:46','',''),(5662,'1','219','1',1,'Retail Sale Id 5737',0.00,0.00,0.00,0.00,0.00,'2022-05-20 13:24:27','',''),(5663,'1','219',NULL,1,'Purchased from AA RANO NIG. LTD',0.00,3669178.00,5899.00,0.00,0.00,'2022-05-20 15:45:37','',''),(5664,'1','219',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,5899.00,0.00,'2022-05-20 15:48:17','',''),(5665,'1','219','1',1,'Received from bridging 12',0.00,0.00,5899.00,0.00,0.00,'2022-05-20 15:48:17','',''),(5666,'1','219','1',1,'Retail Sale Id 5739',1997.52,0.00,0.00,2.87,212.38,'2022-05-20 16:06:30','',''),(5667,'1','219','1',1,'Retail Sale Id 5740',1398.96,0.00,0.00,2.01,148.74,'2022-05-20 16:08:06','',''),(5668,'1','219','1',1,'Retail Sale Id 5741',3500.88,0.00,0.00,5.03,372.22,'2022-05-20 16:15:34','',''),(5669,'1','219','1',1,'Retail Sale Id 5741',3500.88,0.00,0.00,5.03,372.22,'2022-05-20 16:15:34','',''),(5670,'1','219','1',1,'Retail Sale Id 5742',702.96,0.00,0.00,1.01,74.74,'2022-05-20 16:20:54','',''),(5671,'1','219','1',1,'Retail Sale Id 5743',1398.96,0.00,0.00,2.01,148.74,'2022-05-20 16:28:29','',''),(5672,'1','219','1',1,'Retail Sale Id 5744',2101.92,0.00,0.00,3.02,223.48,'2022-05-20 16:30:44','',''),(5673,'1','219','1',1,'Retail Sale Id 5745',2101.92,0.00,0.00,3.02,223.48,'2022-05-20 16:41:13','',''),(5674,'1','219','1',1,'Retail Sale Id 5746',1002.24,0.00,0.00,1.44,106.56,'2022-05-20 16:42:08','',''),(5675,'1','219','1',1,'Retail Sale Id 5747',1002.24,0.00,0.00,1.44,106.56,'2022-05-20 16:42:54','',''),(5676,'1','219','1',1,'Retail Sale Id 5748',2101.92,0.00,0.00,3.02,223.48,'2022-05-20 16:46:14','',''),(5677,'1','219','1',1,'Retail Sale Id 5749',2101.92,0.00,0.00,3.02,223.48,'2022-05-20 16:56:42','',''),(5678,'1','219','1',1,'Retail Sale Id 5750',2101.92,0.00,0.00,3.02,223.48,'2022-05-20 16:57:45','',''),(5679,'1','219','1',1,'Retail Sale Id 5751',1398.96,0.00,0.00,2.01,148.74,'2022-05-20 17:05:26','',''),(5680,'1','219','1',1,'Retail Sale Id 5752',3500.88,0.00,0.00,5.03,372.22,'2022-05-20 17:07:07','',''),(5681,'1','219','1',1,'Retail Sale Id 5753',35860.00,0.00,0.00,55.00,1650.00,'2022-05-20 17:09:10','',''),(5682,'1','219','1',1,'Retail Sale Id 5754',1398.96,0.00,0.00,2.01,148.74,'2022-05-20 17:16:04','',''),(5683,'1','219','1',1,'Retail Sale Id 5755',501.12,0.00,0.00,0.72,53.28,'2022-05-20 17:18:46','',''),(5684,'1','219','1',1,'Retail Sale Id 5756',702.96,0.00,0.00,1.01,74.74,'2022-05-20 17:24:29','',''),(5685,'1','219','1',1,'Retail Sale Id 5758',1503.36,0.00,0.00,2.16,159.84,'2022-05-20 17:33:15','',''),(5686,'1','219','1',1,'Retail Sale Id 5759',702.96,0.00,0.00,1.01,74.74,'2022-05-20 17:34:29','',''),(5687,'1','219','1',1,'Retail Sale Id 5759',2101.92,0.00,0.00,3.02,223.48,'2022-05-20 17:34:29','',''),(5688,'1','219','1',1,'Retail Sale Id 5760',1503.36,0.00,0.00,2.16,159.84,'2022-05-20 17:42:22','',''),(5689,'1','219','1',1,'Retail Sale Id 5761',8700.00,0.00,0.00,12.50,925.00,'2022-05-20 17:48:31','',''),(5690,'1','219','1',1,'Retail Sale Id 5762',1503.36,0.00,0.00,2.16,159.84,'2022-05-20 17:51:14','',''),(5691,'1','219','1',1,'Retail Sale Id 5763',8150.00,0.00,0.00,12.50,375.00,'2022-05-20 17:53:27','',''),(5692,'1','219','1',1,'Retail Sale Id 5764',1002.24,0.00,0.00,1.44,106.56,'2022-05-20 17:54:44','',''),(5693,'1','219','1',1,'Retail Sale Id 5765',1503.36,0.00,0.00,2.16,159.84,'2022-05-20 17:55:40','',''),(5694,'1','219','1',1,'Retail Sale Id 5766',2999.76,0.00,0.00,4.31,318.94,'2022-05-20 18:10:11','',''),(5695,'1','219','1',1,'Retail Sale Id 5767',800.40,0.00,0.00,1.15,85.10,'2022-05-20 18:21:44','',''),(5696,'1','219','1',1,'Retail Sale Id 5768',1002.24,0.00,0.00,1.44,106.56,'2022-05-20 18:29:36','',''),(5697,'1','219','1',1,'Retail Sale Id 5769',1301.52,0.00,0.00,1.87,138.38,'2022-05-20 18:30:50','',''),(5698,'1','219','1',1,'Retail Sale Id 5770',4002.00,0.00,0.00,5.75,425.50,'2022-05-20 18:34:06','',''),(5699,'1','219','1',1,'Retail Sale Id 5771',501.12,0.00,0.00,0.72,53.28,'2022-05-20 18:44:05','',''),(5700,'1','219','1',1,'Retail Sale Id 5772',2101.92,0.00,0.00,3.02,223.48,'2022-05-20 18:50:18','',''),(5701,'1','219','1',1,'Retail Sale Id 5773',100001.28,0.00,0.00,143.68,10632.32,'2022-05-20 23:56:23','',''),(5702,'1','219','1',1,'Retail Sale Id 5774',4196.88,0.00,0.00,6.03,446.22,'2022-05-21 08:04:02','',''),(5703,'1','219','1',1,'Retail Sale Id 5775',2797.92,0.00,0.00,4.02,297.48,'2022-05-21 08:05:30','',''),(5704,'1','219','1',1,'Retail Sale Id 5776',4196.88,0.00,0.00,6.03,446.22,'2022-05-21 08:08:23','',''),(5705,'1','219','1',1,'Retail Sale Id 5777',1002.24,0.00,0.00,1.44,106.56,'2022-05-21 08:14:50','',''),(5706,'1','219','1',1,'Retail Sale Id 5778',501.12,0.00,0.00,0.72,53.28,'2022-05-21 08:16:26','',''),(5707,'1','219','1',1,'Retail Sale Id 5779',7001.76,0.00,0.00,10.06,744.44,'2022-05-21 08:24:18','',''),(5708,'1','219','1',1,'Retail Sale Id 5780',1698.24,0.00,0.00,2.44,180.56,'2022-05-21 08:29:46','',''),(5709,'1','219','1',1,'Retail Sale Id 5781',8150.00,0.00,0.00,12.50,375.00,'2022-05-21 08:54:34','',''),(5710,'1','219','1',1,'Retail Sale Id 5782',1398.96,0.00,0.00,2.01,148.74,'2022-05-21 08:56:39','',''),(5711,'1','219','1',1,'Retail Sale Id 5783',1997.52,0.00,0.00,2.87,212.38,'2022-05-21 09:01:20','',''),(5712,'1','219','1',1,'Retail Sale Id 5784',4196.88,0.00,0.00,6.03,446.22,'2022-05-21 09:08:45','',''),(5713,'1','219','1',1,'Retail Sale Id 5785',8700.00,0.00,0.00,12.50,925.00,'2022-05-21 09:25:19','',''),(5714,'1','219','1',1,'Retail Sale Id 5786',4196.88,0.00,0.00,6.03,446.22,'2022-05-21 09:27:40','',''),(5715,'1','219','1',1,'Retail Sale Id 5787',1997.52,0.00,0.00,2.87,212.38,'2022-05-21 09:38:28','',''),(5716,'1','219','1',1,'Retail Sale Id 5790',8352.00,0.00,0.00,12.00,888.00,'2022-05-21 09:51:09','',''),(5717,'1','219','1',1,'Retail Sale Id 5791',2797.92,0.00,0.00,4.02,297.48,'2022-05-21 10:11:56','',''),(5718,'1','219','1',1,'Retail Sale Id 5792',2040.00,0.00,0.00,3.00,174.00,'2022-05-21 10:24:34','',''),(5719,'1','219','1',1,'Retail Sale Id 5793',4100.40,0.00,0.00,6.03,349.74,'2022-05-21 10:27:24','',''),(5720,'1','219','1',1,'Retail Sale Id 5794',299.20,0.00,0.00,0.44,25.52,'2022-05-21 10:28:58','',''),(5721,'1','219','1',1,'Retail Sale Id 5795',2040.00,0.00,0.00,3.00,174.00,'2022-05-21 10:44:40','',''),(5722,'1','219','1',1,'Retail Sale Id 5795',4080.00,0.00,0.00,6.00,348.00,'2022-05-21 10:44:40','',''),(5723,'1','219','1',1,'Retail Sale Id 5796',2040.00,0.00,0.00,3.00,174.00,'2022-05-21 10:46:09','',''),(5724,'1','219','1',1,'Retail Sale Id 5797',1502.80,0.00,0.00,2.21,128.18,'2022-05-21 10:59:59','',''),(5725,'1','219','1',1,'Retail Sale Id 5799',4080.00,0.00,0.00,6.00,348.00,'2022-05-21 11:05:27','',''),(5726,'1','219','1',1,'Retail Sale Id 5800',8500.00,0.00,0.00,12.50,725.00,'2022-05-21 11:06:59','',''),(5727,'1','219','1',1,'Retail Sale Id 5801',8500.00,0.00,0.00,12.50,725.00,'2022-05-21 11:14:56','',''),(5728,'1','219','1',1,'Retail Sale Id 5802',8500.00,0.00,0.00,12.50,725.00,'2022-05-21 11:25:00','',''),(5729,'1','219','1',1,'Retail Sale Id 5803',700.40,0.00,0.00,1.03,59.74,'2022-05-21 11:39:57','',''),(5730,'1','219','1',1,'Retail Sale Id 5804',8500.00,0.00,0.00,12.50,725.00,'2022-05-21 12:09:14','',''),(5731,'1','219','1',1,'Retail Sale Id 5805',4080.00,0.00,0.00,6.00,348.00,'2022-05-21 12:30:04','',''),(5732,'1','219','1',1,'Retail Sale Id 5807',1502.80,0.00,0.00,2.21,128.18,'2022-05-21 12:46:19','',''),(5733,'1','219','1',1,'Retail Sale Id 5808',4080.00,0.00,0.00,6.00,348.00,'2022-05-21 12:55:24','',''),(5734,'1','219','1',1,'Retail Sale Id 5809',1502.80,0.00,0.00,2.21,128.18,'2022-05-21 13:00:28','',''),(5735,'1','219','1',1,'Retail Sale Id 5810',1999.20,0.00,0.00,2.94,170.52,'2022-05-21 13:23:34','',''),(5736,'1','219','1',1,'Retail Sale Id 5810',3400.00,0.00,0.00,5.00,290.00,'2022-05-21 13:23:34','',''),(5737,'1','219','1',1,'Retail Sale Id 5811',8500.00,0.00,0.00,12.50,725.00,'2022-05-21 13:25:43','',''),(5738,'1','219','1',1,'Retail Sale Id 5812',2040.00,0.00,0.00,3.00,174.00,'2022-05-21 13:32:27','',''),(5739,'1','219','1',1,'Retail Sale Id 5813',4080.00,0.00,0.00,6.00,348.00,'2022-05-21 13:37:56','',''),(5740,'1','219','1',1,'Retail Sale Id 5814',3840.00,0.00,0.00,6.00,108.00,'2022-05-21 13:39:38','',''),(5741,'1','219','1',1,'Retail Sale Id 5815',1502.80,0.00,0.00,2.21,128.18,'2022-05-21 13:41:48','',''),(5742,'1','219','1',1,'Retail Sale Id 5816',700.40,0.00,0.00,1.03,59.74,'2022-05-21 13:56:49','',''),(5743,'1','219','1',1,'Retail Sale Id 5817',680.00,0.00,0.00,1.00,58.00,'2022-05-21 14:07:35','',''),(5744,'1','219','1',1,'Retail Sale Id 5818',6120.00,0.00,0.00,9.00,522.00,'2022-05-21 14:13:54','',''),(5745,'1','219','1',1,'Retail Sale Id 5819',4080.00,0.00,0.00,6.00,348.00,'2022-05-21 14:24:52','',''),(5746,'1','219','1',1,'Retail Sale Id 5820',3400.00,0.00,0.00,5.00,290.00,'2022-05-21 14:30:08','',''),(5747,'1','219','1',1,'Retail Sale Id 5821',2040.00,0.00,0.00,3.00,174.00,'2022-05-21 14:32:17','',''),(5748,'1','219','1',1,'Retail Sale Id 5822',299.20,0.00,0.00,0.44,25.52,'2022-05-21 15:09:35','',''),(5749,'1','219','1',1,'Retail Sale Id 5823',3699.20,0.00,0.00,5.44,315.52,'2022-05-21 15:32:09','',''),(5750,'1','219','1',1,'Retail Sale Id 5824',1999.20,0.00,0.00,2.94,170.52,'2022-05-21 15:35:04','',''),(5751,'1','219','1',1,'Retail Sale Id 5825',4080.00,0.00,0.00,6.00,348.00,'2022-05-21 15:36:53','',''),(5752,'1','219','1',1,'Retail Sale Id 5826',4080.00,0.00,0.00,6.00,348.00,'2022-05-21 15:48:43','',''),(5753,'1','219','1',1,'Retail Sale Id 5827',47858.40,0.00,0.00,70.38,4082.04,'2022-05-21 18:33:13','',''),(5754,'1','219','1',1,'Retail Sale Id 5828',3998.40,0.00,0.00,5.88,341.04,'2022-05-21 19:29:43','',''),(5755,'1','219','1',1,'Retail Sale Id 5829',189440.00,0.00,0.00,296.00,5328.00,'2022-05-22 11:17:24','',''),(5756,'1','219','1',1,'Retail Sale Id 5830',50000.40,0.00,0.00,73.53,4264.74,'2022-05-22 11:34:17','',''),(5757,'1','219','1',1,'Retail Sale Id 5831',32123.20,0.00,0.00,47.24,2739.92,'2022-05-22 11:35:57','',''),(5758,'1','219','1',1,'Retail Sale Id 5832',2240.00,0.00,0.00,3.50,63.00,'2022-05-22 12:01:49','',''),(5759,'1','219','1',1,'Retail Sale Id 5833',22100.00,0.00,0.00,32.50,1885.00,'2022-05-22 12:06:29','',''),(5760,'1','219','1',1,'Retail Sale Id 5834',1360.00,0.00,0.00,2.00,116.00,'2022-05-22 12:27:02','',''),(5761,'1','219','1',1,'Retail Sale Id 5834',2040.00,0.00,0.00,3.00,174.00,'2022-05-22 12:27:02','',''),(5762,'1','219','1',1,'Retail Sale Id 5835',802.40,0.00,0.00,1.18,68.44,'2022-05-22 12:37:08','',''),(5763,'1','219','1',1,'Retail Sale Id 5836',7758.80,0.00,0.00,11.41,661.78,'2022-05-22 12:59:38','',''),(5764,'1','219','1',1,'Retail Sale Id 5837',1999.20,0.00,0.00,2.94,170.52,'2022-05-22 13:05:23','',''),(5765,'1','219','1',1,'Retail Sale Id 5838',2040.00,0.00,0.00,3.00,174.00,'2022-05-22 13:10:20','',''),(5766,'1','219','1',1,'Retail Sale Id 5839',2998.80,0.00,0.00,4.41,255.78,'2022-05-22 13:38:49','',''),(5767,'1','219','1',1,'Retail Sale Id 5840',2040.00,0.00,0.00,3.00,174.00,'2022-05-22 13:39:46','',''),(5768,'1','219','1',1,'Retail Sale Id 5841',4080.00,0.00,0.00,6.00,348.00,'2022-05-22 14:12:36','',''),(5769,'1','219','1',1,'Retail Sale Id 5842',1999.20,0.00,0.00,2.94,170.52,'2022-05-22 14:16:48','',''),(5770,'1','219','1',1,'Retail Sale Id 5843',1360.00,0.00,0.00,2.00,116.00,'2022-05-22 14:36:10','',''),(5771,'1','219','1',1,'Retail Sale Id 5844',1999.20,0.00,0.00,2.94,170.52,'2022-05-22 14:46:39','',''),(5772,'1','219','1',1,'Retail Sale Id 5845',6997.20,0.00,0.00,10.29,596.82,'2022-05-22 14:47:54','',''),(5773,'1','219','1',1,'Retail Sale Id 5846',999.60,0.00,0.00,1.47,85.26,'2022-05-22 14:55:33','',''),(5774,'1','219','1',1,'Retail Sale Id 5846',1999.20,0.00,0.00,2.94,170.52,'2022-05-22 14:55:33','',''),(5775,'1','219','1',1,'Retail Sale Id 5847',2502.40,0.00,0.00,3.68,213.44,'2022-05-22 15:11:51','',''),(5776,'1','219','1',1,'Retail Sale Id 5848',700.40,0.00,0.00,1.03,59.74,'2022-05-22 15:12:46','',''),(5777,'1','219','1',1,'Retail Sale Id 5849',1920.00,0.00,0.00,3.00,54.00,'2022-05-22 15:21:09','',''),(5778,'1','219','1',1,'Retail Sale Id 5850',1298.80,0.00,0.00,1.91,110.78,'2022-05-22 15:31:14','',''),(5779,'1','219','1',1,'Retail Sale Id 5851',2720.00,0.00,0.00,4.00,232.00,'2022-05-22 16:04:56','',''),(5780,'1','219','1',1,'Retail Sale Id 5852',2998.80,0.00,0.00,4.41,255.78,'2022-05-22 16:07:30','',''),(5781,'1','219','1',1,'Retail Sale Id 5853',197.20,0.00,0.00,0.29,16.82,'2022-05-22 16:16:14','',''),(5782,'1','219','1',1,'Retail Sale Id 5854',2046.80,0.00,0.00,3.01,174.58,'2022-05-22 16:20:04','',''),(5783,'1','219','1',1,'Retail Sale Id 5856',2699.60,0.00,0.00,3.97,230.26,'2022-05-22 16:43:13','',''),(5784,'1','219','1',1,'Retail Sale Id 5857',2046.80,0.00,0.00,3.01,174.58,'2022-05-22 16:44:28','',''),(5785,'1','219','1',1,'Retail Sale Id 5858',1999.20,0.00,0.00,2.94,170.52,'2022-05-22 16:50:15','',''),(5786,'1','219','1',1,'Retail Sale Id 5859',1502.80,0.00,0.00,2.21,128.18,'2022-05-22 16:53:13','',''),(5787,'1','219','1',1,'Retail Sale Id 5860',999.60,0.00,0.00,1.47,85.26,'2022-05-22 16:59:15','',''),(5788,'1','219','1',1,'Retail Sale Id 5861',2046.80,0.00,0.00,3.01,174.58,'2022-05-22 17:01:02','',''),(5789,'1','219','1',1,'Retail Sale Id 5862',2040.00,0.00,0.00,3.00,174.00,'2022-05-22 17:04:40','',''),(5790,'1','219','1',1,'Retail Sale Id 5863',1999.20,0.00,0.00,2.94,170.52,'2022-05-22 17:10:46','',''),(5791,'1','219','1',1,'Retail Sale Id 5864',1999.20,0.00,0.00,2.94,170.52,'2022-05-22 17:11:43','',''),(5792,'1','219','1',1,'Retail Sale Id 5865',3998.40,0.00,0.00,5.88,341.04,'2022-05-22 17:19:31','',''),(5793,'1','219','1',1,'Retail Sale Id 5866',3699.20,0.00,0.00,5.44,315.52,'2022-05-22 17:23:08','',''),(5794,'1','219','1',1,'Retail Sale Id 5867',999.60,0.00,0.00,1.47,85.26,'2022-05-22 17:33:19','',''),(5795,'1','219','1',1,'Retail Sale Id 5867',1999.20,0.00,0.00,2.94,170.52,'2022-05-22 17:33:19','',''),(5796,'1','219','1',1,'Retail Sale Id 5869',3840.00,0.00,0.00,6.00,108.00,'2022-05-22 17:37:40','',''),(5797,'1','219','1',1,'Retail Sale Id 5870',1196.80,0.00,0.00,1.76,102.08,'2022-05-22 17:52:18','',''),(5798,'1','219','1',1,'Retail Sale Id 5871',1196.80,0.00,0.00,1.76,102.08,'2022-05-22 18:02:53','',''),(5799,'1','219','1',1,'Retail Sale Id 5872',3400.00,0.00,0.00,5.00,290.00,'2022-05-22 18:03:52','',''),(5800,'1','219','1',1,'Retail Sale Id 5874',2760.80,0.00,0.00,4.06,235.48,'2022-05-22 18:10:23','',''),(5801,'1','219','1',1,'Retail Sale Id 5875',3840.00,0.00,0.00,6.00,108.00,'2022-05-22 18:11:45','',''),(5802,'1','219','1',1,'Retail Sale Id 5876',3400.00,0.00,0.00,5.00,290.00,'2022-05-22 18:21:31','',''),(5803,'1','219','1',1,'Retail Sale Id 5877',999.60,0.00,0.00,1.47,85.26,'2022-05-22 18:22:14','',''),(5804,'1','219','1',1,'Retail Sale Id 5878',299.20,0.00,0.00,0.44,25.52,'2022-05-22 18:24:15','',''),(5805,'1','219','1',1,'Retail Sale Id 5879',503.20,0.00,0.00,0.74,42.92,'2022-05-22 18:25:27','',''),(5806,'1','219','1',1,'Retail Sale Id 5880',700.40,0.00,0.00,1.03,59.74,'2022-05-22 18:26:44','',''),(5807,'1','219','1',1,'Retail Sale Id 5881',3400.00,0.00,0.00,5.00,290.00,'2022-05-22 18:29:28','',''),(5808,'1','219','1',1,'Retail Sale Id 5882',700.40,0.00,0.00,1.03,59.74,'2022-05-22 18:43:39','',''),(5809,'1','219','1',1,'Retail Sale Id 5883',198400.00,0.00,0.00,310.00,5580.00,'2022-05-23 07:46:11','',''),(5810,'1','219','1',1,'Retail Sale Id 5884',4080.00,0.00,0.00,6.00,348.00,'2022-05-23 09:11:10','',''),(5811,'1','219','1',1,'Retail Sale Id 5885',4080.00,0.00,0.00,6.00,348.00,'2022-05-23 09:14:07','',''),(5812,'1','219','1',1,'Retail Sale Id 5886',700.40,0.00,0.00,1.03,59.74,'2022-05-23 09:35:17','',''),(5813,'1','219','1',1,'Retail Sale Id 5887',1999.20,0.00,0.00,2.94,170.52,'2022-05-23 09:39:20','',''),(5814,'1','219','1',1,'Retail Sale Id 5888',3400.00,0.00,0.00,5.00,290.00,'2022-05-23 09:56:04','',''),(5815,'1','219','1',1,'Retail Sale Id 5889',3998.40,0.00,0.00,5.88,341.04,'2022-05-23 09:57:08','',''),(5816,'1','219','1',1,'Retail Sale Id 5890',2998.80,0.00,0.00,4.41,255.78,'2022-05-23 10:12:01','',''),(5817,'1','219','1',1,'Retail Sale Id 5891',1400.80,0.00,0.00,2.06,119.48,'2022-05-23 10:13:40','',''),(5818,'1','219','1',1,'Retail Sale Id 5892',3400.00,0.00,0.00,5.00,290.00,'2022-05-23 10:33:25','',''),(5819,'1','219','1',1,'Retail Sale Id 5893',4080.00,0.00,0.00,6.00,348.00,'2022-05-23 10:57:51','',''),(5820,'1','219','1',1,'Retail Sale Id 5894',999.60,0.00,0.00,1.47,85.26,'2022-05-23 11:03:51','',''),(5821,'1','219','1',1,'Retail Sale Id 5895',700.40,0.00,0.00,1.03,59.74,'2022-05-23 11:09:48','',''),(5822,'1','219','1',1,'Retail Sale Id 5896',4080.00,0.00,0.00,6.00,348.00,'2022-05-23 11:32:00','',''),(5823,'1','219','1',1,'Retail Sale Id 5897',4080.00,0.00,0.00,6.00,348.00,'2022-05-23 11:34:54','',''),(5824,'1','219','1',1,'Retail Sale Id 5898',1400.80,0.00,0.00,2.06,119.48,'2022-05-23 11:46:30','',''),(5825,'1','219','1',1,'Retail Sale Id 5899',4080.00,0.00,0.00,6.00,348.00,'2022-05-23 12:01:07','',''),(5826,'1','219','1',1,'Retail Sale Id 5900',1999.20,0.00,0.00,2.94,170.52,'2022-05-23 12:10:04','',''),(5827,'1','219','1',1,'Retail Sale Id 5901',1400.80,0.00,0.00,2.06,119.48,'2022-05-23 12:22:45','',''),(5828,'1','219','1',1,'Retail Sale Id 5902',503.20,0.00,0.00,0.74,42.92,'2022-05-23 12:37:43','',''),(5829,'1','219','1',1,'Retail Sale Id 5903',2040.00,0.00,0.00,3.00,174.00,'2022-05-23 12:45:18','',''),(5830,'1','219','1',1,'Retail Sale Id 5904',3400.00,0.00,0.00,5.00,290.00,'2022-05-23 13:10:11','',''),(5831,'1','219','1',1,'Retail Sale Id 5905',3400.00,0.00,0.00,5.00,290.00,'2022-05-23 13:15:37','',''),(5832,'1','219','1',1,'Retail Sale Id 5906',1400.80,0.00,0.00,2.06,119.48,'2022-05-23 13:25:25','',''),(5833,'1','219','1',1,'Retail Sale Id 5907',700.40,0.00,0.00,1.03,59.74,'2022-05-23 13:42:31','',''),(5834,'1','219','1',1,'Retail Sale Id 5908',2040.00,0.00,0.00,3.00,174.00,'2022-05-23 13:52:18','',''),(5835,'1','219','1',1,'Retail Sale Id 5909',8160.00,0.00,0.00,12.00,696.00,'2022-05-23 13:56:26','',''),(5836,'1','219','1',1,'Retail Sale Id 5910',197.20,0.00,0.00,0.29,16.82,'2022-05-23 14:24:28','',''),(5837,'1','219','1',1,'Retail Sale Id 5911',1999.20,0.00,0.00,2.94,170.52,'2022-05-23 14:25:06','',''),(5838,'1','219','1',1,'Retail Sale Id 5912',802.40,0.00,0.00,1.18,68.44,'2022-05-23 14:51:25','',''),(5839,'1','219','1',1,'Retail Sale Id 5913',4080.00,0.00,0.00,6.00,348.00,'2022-05-23 15:04:58','',''),(5840,'1','219','1',1,'Retail Sale Id 5914',8500.00,0.00,0.00,12.50,725.00,'2022-05-23 15:35:13','',''),(5841,'1','219','1',1,'Retail Sale Id 5915',4250.00,0.00,0.00,6.25,362.50,'2022-05-23 15:37:29','',''),(5842,'1','219','1',1,'Retail Sale Id 5916',1502.80,0.00,0.00,2.21,128.18,'2022-05-23 15:43:01','',''),(5843,'1','219','1',1,'Retail Sale Id 5917',598.40,0.00,0.00,0.88,51.04,'2022-05-23 16:12:23','',''),(5844,'1','219','1',1,'Retail Sale Id 5918',6997.20,0.00,0.00,10.29,596.82,'2022-05-23 16:16:25','',''),(5845,'1','219','1',1,'Retail Sale Id 5919',3400.00,0.00,0.00,5.00,290.00,'2022-05-23 16:26:49','',''),(5846,'1','219','1',1,'Retail Sale Id 5920',999.60,0.00,0.00,1.47,85.26,'2022-05-23 16:28:30','',''),(5847,'1','219','1',1,'Retail Sale Id 5922',2040.00,0.00,0.00,3.00,174.00,'2022-05-23 16:36:41','',''),(5848,'1','219','1',1,'Retail Sale Id 5922',2720.00,0.00,0.00,4.00,232.00,'2022-05-23 16:36:41','',''),(5849,'1','219','1',1,'Retail Sale Id 5923',999.60,0.00,0.00,1.47,85.26,'2022-05-23 16:37:25','',''),(5850,'1','219','1',1,'Retail Sale Id 5924',1802.00,0.00,0.00,2.65,153.70,'2022-05-23 16:45:47','',''),(5851,'1','219','1',1,'Retail Sale Id 5925',8500.00,0.00,0.00,12.50,725.00,'2022-05-23 16:46:59','',''),(5852,'1','219','1',1,'Retail Sale Id 5926',2998.80,0.00,0.00,4.41,255.78,'2022-05-23 16:50:31','',''),(5853,'1','219','1',1,'Retail Sale Id 5927',2502.40,0.00,0.00,3.68,213.44,'2022-05-23 16:54:58','',''),(5854,'1','219','1',1,'Retail Sale Id 5928',2040.00,0.00,0.00,3.00,174.00,'2022-05-23 17:11:10','',''),(5855,'1','219','1',1,'Retail Sale Id 5929',299.20,0.00,0.00,0.44,25.52,'2022-05-23 17:12:04','',''),(5856,'1','219','1',1,'Retail Sale Id 5930',1999.20,0.00,0.00,2.94,170.52,'2022-05-23 17:13:09','',''),(5857,'1','219','1',1,'Retail Sale Id 5931',503.20,0.00,0.00,0.74,42.92,'2022-05-23 17:14:14','',''),(5858,'1','219','1',1,'Retail Sale Id 5932',2998.80,0.00,0.00,4.41,255.78,'2022-05-23 17:16:29','',''),(5859,'1','219','1',1,'Retail Sale Id 5932',3998.40,0.00,0.00,5.88,341.04,'2022-05-23 17:16:29','',''),(5860,'1','219','1',1,'Retail Sale Id 5933',8500.00,0.00,0.00,12.50,725.00,'2022-05-23 17:19:45','',''),(5861,'1','219','1',1,'Retail Sale Id 5935',1020.00,0.00,0.00,1.50,87.00,'2022-05-23 17:22:17','',''),(5862,'1','219','1',1,'Retail Sale Id 5936',3400.00,0.00,0.00,5.00,290.00,'2022-05-23 17:23:39','',''),(5863,'1','219','1',1,'Retail Sale Id 5937',1502.80,0.00,0.00,2.21,128.18,'2022-05-23 17:24:54','',''),(5864,'1','219','1',1,'Retail Sale Id 5938',999.60,0.00,0.00,1.47,85.26,'2022-05-23 17:26:02','',''),(5865,'1','219','1',1,'Retail Sale Id 5939',2040.00,0.00,0.00,3.00,174.00,'2022-05-23 17:27:20','',''),(5866,'1','219','1',1,'Retail Sale Id 5940',700.40,0.00,0.00,1.03,59.74,'2022-05-23 17:45:04','',''),(5867,'1','219','1',1,'Retail Sale Id 5941',6120.00,0.00,0.00,9.00,522.00,'2022-05-23 17:48:31','',''),(5868,'1','219','1',1,'Retail Sale Id 5943',1999.20,0.00,0.00,2.94,170.52,'2022-05-23 18:08:15','',''),(5869,'1','219','1',1,'Retail Sale Id 5943',10200.00,0.00,0.00,15.00,870.00,'2022-05-23 18:08:15','',''),(5870,'1','219','1',1,'Retail Sale Id 5944',4800.80,0.00,0.00,7.06,409.48,'2022-05-23 18:10:42','',''),(5871,'1','219','1',1,'Retail Sale Id 5945',1502.80,0.00,0.00,2.21,128.18,'2022-05-23 18:11:51','',''),(5872,'1','219','1',1,'Retail Sale Id 5946',999.60,0.00,0.00,1.47,85.26,'2022-05-23 18:15:27','',''),(5873,'1','219','1',1,'Retail Sale Id 5947',1400.80,0.00,0.00,2.06,119.48,'2022-05-23 18:36:21','',''),(5874,'1','219','1',1,'Retail Sale Id 5948',4760.00,0.00,0.00,7.00,406.00,'2022-05-23 18:42:37','',''),(5875,'1','219','1',1,'Retail Sale Id 5949',999.60,0.00,0.00,1.47,85.26,'2022-05-23 18:45:46','',''),(5876,'1','219','1',1,'Retail Sale Id 5950',4080.00,0.00,0.00,6.00,348.00,'2022-05-23 18:46:47','',''),(5877,'1','219','1',1,'Retail Sale Id 5951',1999.20,0.00,0.00,2.94,170.52,'2022-05-24 08:09:34','',''),(5878,'1','219','1',1,'Retail Sale Id 5952',1999.20,0.00,0.00,2.94,170.52,'2022-05-24 09:10:51','',''),(5879,'1','219','1',1,'Retail Sale Id 5953',8500.00,0.00,0.00,12.50,725.00,'2022-05-24 09:14:48','',''),(5880,'1','219','1',1,'Retail Sale Id 5954',32000.00,0.00,0.00,50.00,900.00,'2022-05-24 09:17:03','',''),(5881,'1','219','1',1,'Retail Sale Id 5955',3998.40,0.00,0.00,5.88,341.04,'2022-05-24 10:28:52','',''),(5882,'1','219','1',1,'Retail Sale Id 5956',1502.80,0.00,0.00,2.21,128.18,'2022-05-24 10:39:45','',''),(5883,'1','219','1',1,'Retail Sale Id 5957',2040.00,0.00,0.00,3.00,174.00,'2022-05-24 10:43:37','',''),(5884,'1','219','1',1,'Retail Sale Id 5957',4080.00,0.00,0.00,6.00,348.00,'2022-05-24 10:43:37','',''),(5885,'1','219','1',1,'Retail Sale Id 5958',2046.80,0.00,0.00,3.01,174.58,'2022-05-24 10:47:09','',''),(5886,'1','219','1',1,'Retail Sale Id 5959',503.20,0.00,0.00,0.74,42.92,'2022-05-24 11:03:06','',''),(5887,'1','219','1',1,'Retail Sale Id 5960',2040.00,0.00,0.00,3.00,174.00,'2022-05-24 11:06:28','',''),(5888,'1','219','1',1,'Retail Sale Id 5961',503.20,0.00,0.00,0.74,42.92,'2022-05-24 11:07:14','',''),(5889,'1','219','1',1,'Retail Sale Id 5962',5440.00,0.00,0.00,8.00,464.00,'2022-05-24 11:09:45','',''),(5890,'1','219','1',1,'Retail Sale Id 5963',2040.00,0.00,0.00,3.00,174.00,'2022-05-24 11:11:00','',''),(5891,'1','219','1',1,'Retail Sale Id 5964',2998.80,0.00,0.00,4.41,255.78,'2022-05-24 11:40:37','',''),(5892,'1','219','1',1,'Retail Sale Id 5965',4080.00,0.00,0.00,6.00,348.00,'2022-05-24 12:13:34','',''),(5893,'1','219','1',1,'Retail Sale Id 5966',2040.00,0.00,0.00,3.00,174.00,'2022-05-24 12:16:13','',''),(5894,'1','219','1',1,'Retail Sale Id 5967',999.60,0.00,0.00,1.47,85.26,'2022-05-24 12:24:51','',''),(5895,'1','219','1',1,'Retail Sale Id 5968',8000.00,0.00,0.00,12.50,225.00,'2022-05-24 12:26:04','',''),(5896,'1','219','1',1,'Retail Sale Id 5969',3400.00,0.00,0.00,5.00,290.00,'2022-05-24 12:30:03','',''),(5897,'1','219','1',1,'Retail Sale Id 5970',503.20,0.00,0.00,0.74,42.92,'2022-05-24 12:34:59','',''),(5898,'1','219','1',1,'Retail Sale Id 5971',10002.80,0.00,0.00,14.71,853.18,'2022-05-24 12:49:46','',''),(5899,'1','219','1',1,'Retail Sale Id 5972',700.40,0.00,0.00,1.03,59.74,'2022-05-24 12:59:39','',''),(5900,'1','219','1',1,'Retail Sale Id 5973',897.60,0.00,0.00,1.32,76.56,'2022-05-24 13:03:26','',''),(5901,'1','219','1',1,'Retail Sale Id 5974',1999.20,0.00,0.00,2.94,170.52,'2022-05-24 14:00:12','',''),(5902,'1','219','1',1,'Retail Sale Id 5975',1999.20,0.00,0.00,2.94,170.52,'2022-05-24 14:53:56','',''),(5903,'1','219','1',1,'Retail Sale Id 5976',1999.20,0.00,0.00,2.94,170.52,'2022-05-24 15:02:15','',''),(5904,'1','219','1',1,'Retail Sale Id 5977',4672.00,0.00,0.00,7.30,131.40,'2022-05-24 15:03:55','',''),(5905,'1','219','1',1,'Retail Sale Id 5978',4080.00,0.00,0.00,6.00,348.00,'2022-05-24 15:06:02','',''),(5906,'1','219','1',1,'Retail Sale Id 5979',1502.80,0.00,0.00,2.21,128.18,'2022-05-24 15:31:38','',''),(5907,'1','219','1',1,'Retail Sale Id 5980',1502.80,0.00,0.00,2.21,128.18,'2022-05-24 15:52:37','',''),(5908,'1','219','1',1,'Retail Sale Id 5981',999.60,0.00,0.00,1.47,85.26,'2022-05-24 16:06:15','',''),(5909,'1','219','1',1,'Retail Sale Id 5982',4000.00,0.00,0.00,6.25,112.50,'2022-05-24 16:21:59','',''),(5910,'1','219','1',1,'Retail Sale Id 5983',4080.00,0.00,0.00,6.00,348.00,'2022-05-24 16:34:11','',''),(5911,'1','219','1',1,'Retail Sale Id 5984',3400.00,0.00,0.00,5.00,290.00,'2022-05-24 16:35:45','',''),(5912,'1','219','1',1,'Retail Sale Id 5985',8500.00,0.00,0.00,12.50,725.00,'2022-05-24 16:54:29','',''),(5913,'1','219','1',1,'Retail Sale Id 5986',999.60,0.00,0.00,1.47,85.26,'2022-05-24 16:57:43','',''),(5914,'1','219','1',1,'Retail Sale Id 5987',8500.00,0.00,0.00,12.50,725.00,'2022-05-24 17:04:07','',''),(5915,'1','219','1',1,'Retail Sale Id 5988',1502.80,0.00,0.00,2.21,128.18,'2022-05-24 17:05:22','',''),(5916,'1','219','1',1,'Retail Sale Id 5988',1502.80,0.00,0.00,2.21,128.18,'2022-05-24 17:05:22','',''),(5917,'1','219','1',1,'Retail Sale Id 5989',4080.00,0.00,0.00,6.00,348.00,'2022-05-24 17:14:30','',''),(5918,'1','219','1',1,'Retail Sale Id 5990',1999.20,0.00,0.00,2.94,170.52,'2022-05-24 17:20:15','',''),(5919,'1','219','1',1,'Retail Sale Id 5991',999.60,0.00,0.00,1.47,85.26,'2022-05-24 17:31:40','',''),(5920,'1','219','1',1,'Retail Sale Id 5992',3998.40,0.00,0.00,5.88,341.04,'2022-05-24 17:32:30','',''),(5921,'1','219','1',1,'Retail Sale Id 5993',8500.00,0.00,0.00,12.50,725.00,'2022-05-24 17:34:31','',''),(5922,'1','219','1',1,'Retail Sale Id 5994',4080.00,0.00,0.00,6.00,348.00,'2022-05-24 17:39:35','',''),(5923,'1','219','1',1,'Retail Sale Id 5994',4080.00,0.00,0.00,6.00,348.00,'2022-05-24 17:39:35','',''),(5924,'1','219','1',1,'Retail Sale Id 5994',8500.00,0.00,0.00,12.50,725.00,'2022-05-24 17:39:35','',''),(5925,'1','219','1',1,'Retail Sale Id 5995',251.60,0.00,0.00,0.37,21.46,'2022-05-24 17:44:16','',''),(5926,'1','219','1',1,'Retail Sale Id 5996',8500.00,0.00,0.00,12.50,725.00,'2022-05-24 17:46:23','',''),(5927,'1','219','1',1,'Retail Sale Id 5997',700.40,0.00,0.00,1.03,59.74,'2022-05-24 17:50:11','',''),(5928,'1','219','1',1,'Retail Sale Id 5998',897.60,0.00,0.00,1.32,76.56,'2022-05-24 17:57:29','',''),(5929,'1','219','1',1,'Retail Sale Id 5999',999.60,0.00,0.00,1.47,85.26,'2022-05-24 18:01:16','',''),(5930,'1','219','1',1,'Retail Sale Id 6000',1999.20,0.00,0.00,2.94,170.52,'2022-05-24 18:07:36','',''),(5931,'1','219','1',1,'Retail Sale Id 6001',999.60,0.00,0.00,1.47,85.26,'2022-05-24 18:11:46','',''),(5932,'1','219','1',1,'Retail Sale Id 6002',3502.00,0.00,0.00,5.15,298.70,'2022-05-24 18:17:42','',''),(5933,'1','219','1',1,'Retail Sale Id 6003',3400.00,0.00,0.00,5.00,290.00,'2022-05-24 19:04:13','',''),(5934,'1','219','1',1,'Retail Sale Id 6004',700.40,0.00,0.00,1.03,59.74,'2022-05-24 19:23:15','',''),(5935,'1','219','1',1,'Retail Sale Id 6005',4440.00,0.00,0.00,6.00,708.00,'2022-05-25 08:24:47','',''),(5936,'1','219','1',1,'Retail Sale Id 6006',999.00,0.00,0.00,1.35,159.30,'2022-05-25 08:28:29','',''),(5937,'1','219','1',1,'Retail Sale Id 6007',4440.00,0.00,0.00,6.00,708.00,'2022-05-25 08:36:41','',''),(5938,'1','219','1',1,'Retail Sale Id 6007',9250.00,0.00,0.00,12.50,1475.00,'2022-05-25 08:36:41','',''),(5939,'1','219','1',1,'Retail Sale Id 6008',2249.60,0.00,0.00,3.04,358.72,'2022-05-25 09:35:34','',''),(5940,'1','219','1',1,'Retail Sale Id 6009',747.40,0.00,0.00,1.01,119.18,'2022-05-25 09:44:33','',''),(5941,'1','219','1',1,'Retail Sale Id 6010',1998.00,0.00,0.00,2.70,318.60,'2022-05-25 10:00:41','',''),(5942,'1','219','1',1,'Retail Sale Id 6011',999.00,0.00,0.00,1.35,159.30,'2022-05-25 10:22:42','',''),(5943,'1','219','1',1,'Retail Sale Id 6012',2088.00,0.00,0.00,3.00,222.00,'2022-05-25 10:24:32','',''),(5944,'1','219','1',1,'Retail Sale Id 6013',4447.40,0.00,0.00,6.01,709.18,'2022-05-25 10:26:11','',''),(5945,'1','219','1',1,'Retail Sale Id 6014',2220.00,0.00,0.00,3.00,354.00,'2022-05-25 10:27:48','',''),(5946,'1','219','1',1,'Retail Sale Id 6015',7400.00,0.00,0.00,10.00,1180.00,'2022-05-25 10:29:51','',''),(5947,'1','219','1',1,'Retail Sale Id 6016',5920.00,0.00,0.00,8.00,944.00,'2022-05-25 10:47:13','',''),(5948,'1','219','1',1,'Retail Sale Id 6017',2701.00,0.00,0.00,3.65,430.70,'2022-05-25 11:03:16','',''),(5949,'1','219','1',1,'Retail Sale Id 6018',3700.00,0.00,0.00,5.00,590.00,'2022-05-25 11:16:23','',''),(5950,'1','219','1',1,'Retail Sale Id 6019',2220.00,0.00,0.00,3.00,354.00,'2022-05-25 11:19:54','',''),(5951,'1','219','1',1,'Retail Sale Id 6020',4440.00,0.00,0.00,6.00,708.00,'2022-05-25 11:23:47','',''),(5952,'1','219','1',1,'Retail Sale Id 6022',4003.40,0.00,0.00,5.41,638.38,'2022-05-25 11:26:54','',''),(5953,'1','219','1',1,'Retail Sale Id 6023',9250.00,0.00,0.00,12.50,1475.00,'2022-05-25 11:28:35','',''),(5954,'1','219','1',1,'Retail Sale Id 6024',4440.00,0.00,0.00,6.00,708.00,'2022-05-25 11:44:37','',''),(5955,'1','219','1',1,'Retail Sale Id 6025',4440.00,0.00,0.00,6.00,708.00,'2022-05-25 12:06:32','',''),(5956,'1','219','1',1,'Retail Sale Id 6025',4440.00,0.00,0.00,6.00,708.00,'2022-05-25 12:06:32','',''),(5957,'1','219','1',1,'Retail Sale Id 6026',1998.00,0.00,0.00,2.70,318.60,'2022-05-25 12:08:24','',''),(5958,'1','219','1',1,'Retail Sale Id 6027',2220.00,0.00,0.00,3.00,354.00,'2022-05-25 12:16:52','',''),(5959,'1','219','1',1,'Retail Sale Id 6028',1598.40,0.00,0.00,2.16,254.88,'2022-05-25 12:22:45','',''),(5960,'1','219','1',1,'Retail Sale Id 6029',7400.00,0.00,0.00,10.00,1180.00,'2022-05-25 12:58:30','',''),(5961,'1','219','1',1,'Retail Sale Id 6030',1997.52,0.00,0.00,2.87,212.38,'2022-05-25 13:00:16','',''),(5962,'1','219','1',1,'Retail Sale Id 6031',4440.00,0.00,0.00,6.00,708.00,'2022-05-25 13:01:34','',''),(5963,'1','219','1',1,'Retail Sale Id 6031',9250.00,0.00,0.00,12.50,1475.00,'2022-05-25 13:01:34','',''),(5964,'1','219','1',1,'Retail Sale Id 6033',703.00,0.00,0.00,0.95,112.10,'2022-05-25 13:20:55','',''),(5965,'1','219','1',1,'Retail Sale Id 6034',1998.00,0.00,0.00,2.70,318.60,'2022-05-25 13:22:01','',''),(5966,'1','219','1',1,'Retail Sale Id 6035',1198.80,0.00,0.00,1.62,191.16,'2022-05-25 13:22:58','',''),(5967,'1','219','1',1,'Retail Sale Id 6036',1998.00,0.00,0.00,2.70,318.60,'2022-05-25 13:23:46','',''),(5968,'1','219','1',1,'Retail Sale Id 6037',2088.00,0.00,0.00,3.00,222.00,'2022-05-25 13:39:34','',''),(5969,'1','219','1',1,'Retail Sale Id 6038',4440.00,0.00,0.00,6.00,708.00,'2022-05-25 13:47:37','',''),(5970,'1','219','1',1,'Retail Sale Id 6039',2997.00,0.00,0.00,4.05,477.90,'2022-05-25 14:29:58','',''),(5971,'1','219','1',1,'Retail Sale Id 6040',4440.00,0.00,0.00,6.00,708.00,'2022-05-25 14:32:51','',''),(5972,'1','219','1',1,'Retail Sale Id 6041',1302.40,0.00,0.00,1.76,207.68,'2022-05-25 14:49:00','',''),(5973,'1','219','1',1,'Retail Sale Id 6041',1302.40,0.00,0.00,1.76,207.68,'2022-05-25 14:49:00','',''),(5974,'1','219','1',1,'Retail Sale Id 6042',3700.00,0.00,0.00,5.00,590.00,'2022-05-25 14:53:11','',''),(5975,'1','219','1',1,'Retail Sale Id 6043',1998.00,0.00,0.00,2.70,318.60,'2022-05-25 14:55:33','',''),(5976,'1','219','1',1,'Retail Sale Id 6044',999.00,0.00,0.00,1.35,159.30,'2022-05-25 15:07:18','',''),(5977,'1','219','1',1,'Retail Sale Id 6044',999.00,0.00,0.00,1.35,159.30,'2022-05-25 15:07:18','',''),(5978,'1','219','1',1,'Retail Sale Id 6045',999.00,0.00,0.00,1.35,159.30,'2022-05-25 15:08:33','',''),(5979,'1','219','1',1,'Retail Sale Id 6046',1998.00,0.00,0.00,2.70,318.60,'2022-05-25 15:44:56','',''),(5980,'1','219','1',1,'Retail Sale Id 6047',4499.20,0.00,0.00,6.08,717.44,'2022-05-25 15:46:49','',''),(5981,'1','219','1',1,'Retail Sale Id 6048',1598.40,0.00,0.00,2.16,254.88,'2022-05-25 16:03:27','',''),(5982,'1','219','1',1,'Retail Sale Id 6049',7000.40,0.00,0.00,9.46,1116.28,'2022-05-25 16:22:41','',''),(5983,'1','219','1',1,'Retail Sale Id 6050',3700.00,0.00,0.00,5.00,590.00,'2022-05-25 16:23:55','',''),(5984,'1','219','1',1,'Retail Sale Id 6051',2501.20,0.00,0.00,3.38,398.84,'2022-05-25 16:43:57','',''),(5985,'1','219','1',1,'Retail Sale Id 6052',999.00,0.00,0.00,1.35,159.30,'2022-05-25 16:48:09','',''),(5986,'1','219','1',1,'Retail Sale Id 6053',3500.20,0.00,0.00,4.73,558.14,'2022-05-25 17:04:34','',''),(5987,'1','219','1',1,'Retail Sale Id 6054',999.00,0.00,0.00,1.35,159.30,'2022-05-25 17:13:21','',''),(5988,'1','219','1',1,'Retail Sale Id 6055',503.20,0.00,0.00,0.68,80.24,'2022-05-25 18:00:42','',''),(5989,'1','219','1',1,'Retail Sale Id 6056',1998.00,0.00,0.00,2.70,318.60,'2022-05-25 18:09:37','',''),(5990,'1','219','1',1,'Retail Sale Id 6057',9250.00,0.00,0.00,12.50,1475.00,'2022-05-25 18:15:29','',''),(5991,'1','219','1',1,'Retail Sale Id 6058',4440.00,0.00,0.00,6.00,708.00,'2022-05-25 18:17:34','',''),(5992,'1','219','1',1,'Retail Sale Id 6059',1998.00,0.00,0.00,2.70,318.60,'2022-05-25 18:21:32','',''),(5993,'1','219','1',1,'Retail Sale Id 6060',2220.00,0.00,0.00,3.00,354.00,'2022-05-25 18:22:41','',''),(5994,'1','219','1',1,'Retail Sale Id 6061',9250.00,0.00,0.00,12.50,1475.00,'2022-05-25 18:40:59','',''),(5995,'1','219','1',1,'Retail Sale Id 6062',999.00,0.00,0.00,1.35,159.30,'2022-05-25 18:46:21','',''),(5996,'1','219','1',1,'Retail Sale Id 6063',703.00,0.00,0.00,0.95,112.10,'2022-05-25 18:50:28','',''),(5997,'1','219','1',1,'Retail Sale Id 6064',2220.00,0.00,0.00,3.00,354.00,'2022-05-25 19:04:06','',''),(5998,'1','219','1',1,'Retail Sale Id 6065',2220.00,0.00,0.00,3.00,354.00,'2022-05-26 07:51:48','',''),(5999,'1','219','1',1,'Retail Sale Id 6066',2997.00,0.00,0.00,4.05,477.90,'2022-05-26 08:01:13','',''),(6000,'1','219','1',1,'Retail Sale Id 6067',4499.20,0.00,0.00,6.08,717.44,'2022-05-26 08:14:33','',''),(6001,'1','219','1',1,'Retail Sale Id 6068',4440.00,0.00,0.00,6.00,708.00,'2022-05-26 09:28:04','',''),(6002,'1','219','1',1,'Retail Sale Id 6068',9250.00,0.00,0.00,12.50,1475.00,'2022-05-26 09:28:04','',''),(6003,'1','219','1',1,'Retail Sale Id 6068',9250.00,0.00,0.00,12.50,1475.00,'2022-05-26 09:28:04','',''),(6004,'1','219','1',1,'Retail Sale Id 6069',4440.00,0.00,0.00,6.00,708.00,'2022-05-26 09:52:46','',''),(6005,'1','219','1',1,'Retail Sale Id 6070',1998.00,0.00,0.00,2.70,318.60,'2022-05-26 09:53:33','',''),(6006,'1','219','1',1,'Retail Sale Id 6071',8700.00,0.00,0.00,12.50,925.00,'2022-05-26 09:55:55','',''),(6007,'1','219','1',1,'Retail Sale Id 6073',9250.00,0.00,0.00,12.50,1475.00,'2022-05-26 09:58:24','',''),(6008,'1','219','1',1,'Retail Sale Id 6074',5568.00,0.00,0.00,8.00,592.00,'2022-05-26 10:01:14','',''),(6009,'1','219','1',1,'Retail Sale Id 6075',2220.00,0.00,0.00,3.00,354.00,'2022-05-26 10:25:08','',''),(6010,'1','219','1',1,'Retail Sale Id 6076',2220.00,0.00,0.00,3.00,354.00,'2022-05-26 10:35:01','',''),(6011,'1','219','1',1,'Retail Sale Id 6077',4440.00,0.00,0.00,6.00,708.00,'2022-05-26 10:35:49','',''),(6012,'1','219','1',1,'Retail Sale Id 6078',2220.00,0.00,0.00,3.00,354.00,'2022-05-26 10:41:28','',''),(6013,'1','219','1',1,'Retail Sale Id 6079',1998.00,0.00,0.00,2.70,318.60,'2022-05-26 10:46:10','',''),(6014,'1','219','1',1,'Retail Sale Id 6080',1480.00,0.00,0.00,2.00,236.00,'2022-05-26 10:48:27','',''),(6015,'1','219','1',1,'Retail Sale Id 6080',3700.00,0.00,0.00,5.00,590.00,'2022-05-26 10:48:27','',''),(6016,'1','219','1',1,'Retail Sale Id 6082',2997.00,0.00,0.00,4.05,477.90,'2022-05-26 10:58:50','',''),(6017,'1','219','1',1,'Retail Sale Id 6083',4440.00,0.00,0.00,6.00,708.00,'2022-05-26 11:20:40','',''),(6018,'1','219','1',1,'Retail Sale Id 6084',503.20,0.00,0.00,0.68,80.24,'2022-05-26 11:43:38','',''),(6019,'1','219','1',1,'Retail Sale Id 6086',1502.20,0.00,0.00,2.03,239.54,'2022-05-26 12:05:08','',''),(6020,'1','219','1',1,'Retail Sale Id 6087',1998.00,0.00,0.00,2.70,318.60,'2022-05-26 12:06:16','',''),(6021,'1','219','1',1,'Retail Sale Id 6088',2220.00,0.00,0.00,3.00,354.00,'2022-05-26 12:26:33','',''),(6022,'1','219','1',1,'Retail Sale Id 6089',1998.00,0.00,0.00,2.70,318.60,'2022-05-26 12:31:22','',''),(6023,'1','219','1',1,'Retail Sale Id 6090',3700.00,0.00,0.00,5.00,590.00,'2022-05-26 12:35:15','',''),(6024,'1','219','1',1,'Retail Sale Id 6091',4440.00,0.00,0.00,6.00,708.00,'2022-05-26 13:01:35','',''),(6025,'1','219','1',1,'Retail Sale Id 6092',4440.00,0.00,0.00,6.00,708.00,'2022-05-26 13:05:39','',''),(6026,'1','219','1',1,'Retail Sale Id 6093',703.00,0.00,0.00,0.95,112.10,'2022-05-26 13:26:20','',''),(6027,'1','219','1',1,'Retail Sale Id 6094',2997.00,0.00,0.00,4.05,477.90,'2022-05-26 14:04:15','',''),(6028,'1','219','1',1,'Retail Sale Id 6095',4499.20,0.00,0.00,6.08,717.44,'2022-05-26 14:08:51','',''),(6029,'1','219','1',1,'Retail Sale Id 6096',7400.00,0.00,0.00,10.00,1180.00,'2022-05-26 14:19:14','',''),(6030,'1','219','1',1,'Retail Sale Id 6097',3480.00,0.00,0.00,5.00,370.00,'2022-05-26 14:26:20','',''),(6031,'1','219','1',1,'Retail Sale Id 6098',7400.00,0.00,0.00,10.00,1180.00,'2022-05-26 14:29:07','',''),(6032,'1','219','1',1,'Retail Sale Id 6099',2501.20,0.00,0.00,3.38,398.84,'2022-05-26 14:45:53','',''),(6033,'1','219','1',1,'Retail Sale Id 6100',1110.00,0.00,0.00,1.50,177.00,'2022-05-26 15:34:36','',''),(6034,'1','219','1',1,'Retail Sale Id 6101',8700.00,0.00,0.00,12.50,925.00,'2022-05-26 15:56:13','',''),(6035,'1','219','1',1,'Retail Sale Id 6102',1998.00,0.00,0.00,2.70,318.60,'2022-05-26 16:16:25','',''),(6036,'1','219','1',1,'Retail Sale Id 6104',1502.20,0.00,0.00,2.03,239.54,'2022-05-26 17:01:45','',''),(6037,'1','219','1',1,'Retail Sale Id 6105',4440.00,0.00,0.00,6.00,708.00,'2022-05-26 17:11:05','',''),(6038,'1','219','1',1,'Retail Sale Id 6106',2220.00,0.00,0.00,3.00,354.00,'2022-05-26 17:16:37','',''),(6039,'1','219','1',1,'Retail Sale Id 6107',1998.00,0.00,0.00,2.70,318.60,'2022-05-26 17:17:51','',''),(6040,'1','219','1',1,'Retail Sale Id 6108',1798.20,0.00,0.00,2.43,286.74,'2022-05-26 17:18:50','',''),(6041,'1','219','1',1,'Retail Sale Id 6109',1302.40,0.00,0.00,1.76,207.68,'2022-05-26 17:19:35','',''),(6042,'1','219','1',1,'Retail Sale Id 6110',6001.40,0.00,0.00,8.11,956.98,'2022-05-26 17:20:40','',''),(6043,'1','219','1',1,'Retail Sale Id 6111',503.20,0.00,0.00,0.68,80.24,'2022-05-26 17:27:43','',''),(6044,'1','219','1',1,'Retail Sale Id 6112',1502.20,0.00,0.00,2.03,239.54,'2022-05-26 17:30:32','',''),(6045,'1','219','1',1,'Retail Sale Id 6113',999.00,0.00,0.00,1.35,159.30,'2022-05-26 17:36:05','',''),(6046,'1','219','1',1,'Retail Sale Id 6114',1998.00,0.00,0.00,2.70,318.60,'2022-05-26 17:46:46','',''),(6047,'1','219','1',1,'Retail Sale Id 6115',599.40,0.00,0.00,0.81,95.58,'2022-05-26 17:55:10','',''),(6048,'1','219','1',1,'Retail Sale Id 6116',1502.20,0.00,0.00,2.03,239.54,'2022-05-26 17:56:11','',''),(6049,'1','219','1',1,'Retail Sale Id 6117',902.80,0.00,0.00,1.22,143.96,'2022-05-26 17:57:20','',''),(6050,'1','219','1',1,'Retail Sale Id 6118',1502.20,0.00,0.00,2.03,239.54,'2022-05-26 18:17:14','',''),(6051,'1','219','1',1,'Retail Sale Id 6119',999.00,0.00,0.00,1.35,159.30,'2022-05-26 18:20:58','',''),(6052,'1','219','1',1,'Retail Sale Id 6120',27840.00,0.00,0.00,40.00,2960.00,'2022-05-26 18:25:17','',''),(6053,'1','219','1',1,'Retail Sale Id 6121',9250.00,0.00,0.00,12.50,1475.00,'2022-05-26 18:27:41','',''),(6054,'1','219','1',1,'Retail Sale Id 6122',2501.20,0.00,0.00,3.38,398.84,'2022-05-26 18:28:51','',''),(6055,'1','219','1',1,'Retail Sale Id 6123',703.00,0.00,0.00,0.95,112.10,'2022-05-26 18:29:54','',''),(6056,'1','219','1',1,'Retail Sale Id 6124',999.00,0.00,0.00,1.35,159.30,'2022-05-26 18:30:42','',''),(6057,'1','219','1',1,'Retail Sale Id 6125',1502.20,0.00,0.00,2.03,239.54,'2022-05-26 18:42:54','',''),(6058,'1','219','1',1,'Retail Sale Id 6126',703.00,0.00,0.00,0.95,112.10,'2022-05-26 18:44:57','',''),(6059,'1','219','1',1,'Retail Sale Id 6127',9250.00,0.00,0.00,12.50,1475.00,'2022-05-27 07:51:56','',''),(6060,'1','219','1',1,'Retail Sale Id 6128',0.00,0.00,0.00,0.00,0.00,'2022-05-27 07:57:14','',''),(6061,'1','219','1',1,'Retail Sale Id 6129',9250.00,0.00,0.00,12.50,1475.00,'2022-05-27 08:15:05','',''),(6062,'1','219','1',1,'Retail Sale Id 6130',4440.00,0.00,0.00,6.00,708.00,'2022-05-27 08:16:41','',''),(6063,'1','219','1',1,'Retail Sale Id 6131',1502.20,0.00,0.00,2.03,239.54,'2022-05-27 08:21:00','',''),(6064,'1','219','1',1,'Retail Sale Id 6132',999.00,0.00,0.00,1.35,159.30,'2022-05-27 08:25:41','',''),(6065,'1','219','1',1,'Retail Sale Id 6133',9250.00,0.00,0.00,12.50,1475.00,'2022-05-27 09:20:03','',''),(6066,'1','219','1',1,'Retail Sale Id 6134',9250.00,0.00,0.00,12.50,1475.00,'2022-05-27 09:23:20','',''),(6067,'1','219','1',1,'Retail Sale Id 6135',6960.00,0.00,0.00,10.00,740.00,'2022-05-27 09:33:08','',''),(6068,'1','219','1',1,'Retail Sale Id 6136',1850.00,0.00,0.00,2.50,295.00,'2022-05-27 09:35:57','',''),(6069,'1','219','1',1,'Retail Sale Id 6137',303.40,0.00,0.00,0.41,48.38,'2022-05-27 09:38:13','',''),(6070,'1','219','1',1,'Retail Sale Id 6138',4447.40,0.00,0.00,6.01,709.18,'2022-05-27 09:39:43','',''),(6071,'1','219','1',1,'Retail Sale Id 6139',1502.20,0.00,0.00,2.03,239.54,'2022-05-27 09:40:37','',''),(6072,'1','219','1',1,'Retail Sale Id 6140',999.00,0.00,0.00,1.35,159.30,'2022-05-27 09:48:10','',''),(6073,'1','219','1',1,'Retail Sale Id 6141',4440.00,0.00,0.00,6.00,708.00,'2022-05-27 09:49:30','',''),(6074,'1','219','1',1,'Retail Sale Id 6142',3700.00,0.00,0.00,5.00,590.00,'2022-05-27 09:51:00','',''),(6075,'1','219','1',1,'Retail Sale Id 6143',4447.40,0.00,0.00,6.01,709.18,'2022-05-27 10:01:06','',''),(6076,'1','219','1',1,'Retail Sale Id 6145',7000.40,0.00,0.00,9.46,1116.28,'2022-05-27 10:07:08','',''),(6077,'1','219','1',1,'Retail Sale Id 6146',303.40,0.00,0.00,0.41,48.38,'2022-05-27 10:08:27','',''),(6078,'1','219','1',1,'Retail Sale Id 6147',3700.00,0.00,0.00,5.00,590.00,'2022-05-27 10:14:46','',''),(6079,'1','219','1',1,'Retail Sale Id 6148',1998.00,0.00,0.00,2.70,318.60,'2022-05-27 10:15:52','',''),(6080,'1','219','1',1,'Retail Sale Id 6150',4447.40,0.00,0.00,6.01,709.18,'2022-05-27 10:17:00','',''),(6081,'1','219','1',1,'Retail Sale Id 6151',69600.00,0.00,0.00,100.00,7400.00,'2022-05-27 10:25:01','',''),(6082,'1','219','1',1,'Retail Sale Id 6152',4440.00,0.00,0.00,6.00,708.00,'2022-05-27 10:26:40','',''),(6083,'1','219','1',1,'Retail Sale Id 6153',2220.00,0.00,0.00,3.00,354.00,'2022-05-27 10:53:27','',''),(6084,'1','219','1',1,'Retail Sale Id 6153',4440.00,0.00,0.00,6.00,708.00,'2022-05-27 10:53:27','',''),(6085,'1','219','1',1,'Retail Sale Id 6154',2220.00,0.00,0.00,3.00,354.00,'2022-05-27 10:56:23','',''),(6086,'1','219','1',1,'Retail Sale Id 6155',2997.00,0.00,0.00,4.05,477.90,'2022-05-27 11:03:45','',''),(6087,'1','219','1',1,'Retail Sale Id 6156',2997.00,0.00,0.00,4.05,477.90,'2022-05-27 11:11:17','',''),(6088,'1','219','1',1,'Retail Sale Id 6157',2997.00,0.00,0.00,4.05,477.90,'2022-05-27 11:12:57','',''),(6089,'1','219','1',1,'Retail Sale Id 6158',4003.40,0.00,0.00,5.41,638.38,'2022-05-27 11:21:16','',''),(6090,'1','219','1',1,'Retail Sale Id 6159',999.00,0.00,0.00,1.35,159.30,'2022-05-27 11:34:52','',''),(6091,'1','219','1',1,'Retail Sale Id 6160',7400.00,0.00,0.00,10.00,1180.00,'2022-05-27 12:04:35','',''),(6092,'1','219','1',1,'Retail Sale Id 6161',9250.00,0.00,0.00,12.50,1475.00,'2022-05-27 12:09:26','',''),(6093,'1','219','1',1,'Retail Sale Id 6162',1502.20,0.00,0.00,2.03,239.54,'2022-05-27 12:12:11','',''),(6094,'1','219','1',1,'Retail Sale Id 6163',503.20,0.00,0.00,0.68,80.24,'2022-05-27 12:23:17','',''),(6095,'1','219','1',1,'Retail Sale Id 6164',1502.20,0.00,0.00,2.03,239.54,'2022-05-27 12:42:48','',''),(6096,'1','219','1',1,'Retail Sale Id 6165',1502.20,0.00,0.00,2.03,239.54,'2022-05-27 13:06:30','',''),(6097,'1','219','1',1,'Retail Sale Id 6166',1502.20,0.00,0.00,2.03,239.54,'2022-05-27 13:24:08','',''),(6098,'1','219','1',1,'Retail Sale Id 6167',2220.00,0.00,0.00,3.00,354.00,'2022-05-27 13:55:20','',''),(6099,'1','219','1',1,'Retail Sale Id 6168',999.00,0.00,0.00,1.35,159.30,'2022-05-27 14:02:49','',''),(6100,'1','219','1',1,'Retail Sale Id 6168',1502.20,0.00,0.00,2.03,239.54,'2022-05-27 14:02:49','',''),(6101,'1','219','1',1,'Retail Sale Id 6169',9250.00,0.00,0.00,12.50,1475.00,'2022-05-27 14:19:44','',''),(6102,'1','219','1',1,'Retail Sale Id 6170',999.00,0.00,0.00,1.35,159.30,'2022-05-27 14:26:21','',''),(6103,'1','219','1',1,'Retail Sale Id 6172',7001.76,0.00,0.00,10.06,744.44,'2022-05-27 14:43:03','',''),(6104,'1','219','1',1,'Retail Sale Id 6173',703.00,0.00,0.00,0.95,112.10,'2022-05-27 14:45:29','',''),(6105,'1','219','1',1,'Retail Sale Id 6174',2960.00,0.00,0.00,4.00,472.00,'2022-05-27 14:53:38','',''),(6106,'1','219','1',1,'Retail Sale Id 6174',2960.00,0.00,0.00,4.00,472.00,'2022-05-27 14:53:38','',''),(6107,'1','219','1',1,'Retail Sale Id 6175',5180.00,0.00,0.00,7.00,826.00,'2022-05-27 14:59:19','',''),(6108,'1','219','1',1,'Retail Sale Id 6176',399.60,0.00,0.00,0.54,63.72,'2022-05-27 15:01:54','',''),(6109,'1','219','1',1,'Retail Sale Id 6177',1998.00,0.00,0.00,2.70,318.60,'2022-05-27 15:39:26','',''),(6110,'1','219','1',1,'Retail Sale Id 6177',1998.00,0.00,0.00,2.70,318.60,'2022-05-27 15:39:26','',''),(6111,'1','219','1',1,'Retail Sale Id 6178',9250.00,0.00,0.00,12.50,1475.00,'2022-05-27 15:56:08','',''),(6112,'1','219','1',1,'Retail Sale Id 6179',7400.00,0.00,0.00,10.00,1180.00,'2022-05-27 16:04:28','',''),(6113,'1','219','1',1,'Retail Sale Id 6181',999.00,0.00,0.00,1.35,159.30,'2022-05-27 16:24:29','',''),(6114,'1','219','1',1,'Retail Sale Id 6182',4003.40,0.00,0.00,5.41,638.38,'2022-05-27 16:31:57','',''),(6115,'1','219','1',1,'Retail Sale Id 6183',1998.00,0.00,0.00,2.70,318.60,'2022-05-27 16:35:44','',''),(6116,'1','219','1',1,'Retail Sale Id 6184',1102.60,0.00,0.00,1.49,175.82,'2022-05-27 16:40:54','',''),(6117,'1','219','1',1,'Retail Sale Id 6185',4440.00,0.00,0.00,6.00,708.00,'2022-05-27 16:44:50','',''),(6118,'1','219','1',1,'Retail Sale Id 6186',999.00,0.00,0.00,1.35,159.30,'2022-05-27 16:46:03','',''),(6119,'1','219','1',1,'Retail Sale Id 6187',1998.00,0.00,0.00,2.70,318.60,'2022-05-27 16:49:04','',''),(6120,'1','219','1',1,'Retail Sale Id 6188',399.60,0.00,0.00,0.54,63.72,'2022-05-27 17:02:58','',''),(6121,'1','219','1',1,'Retail Sale Id 6189',4440.00,0.00,0.00,6.00,708.00,'2022-05-27 17:19:13','',''),(6122,'1','219','1',1,'Retail Sale Id 6190',703.00,0.00,0.00,0.95,112.10,'2022-05-27 17:20:15','',''),(6123,'1','219','1',1,'Retail Sale Id 6191',740.00,0.00,0.00,1.00,118.00,'2022-05-27 17:21:40','',''),(6124,'1','219','1',1,'Retail Sale Id 6192',399.60,0.00,0.00,0.54,63.72,'2022-05-27 17:28:33','',''),(6125,'1','219','1',1,'Retail Sale Id 6193',4440.00,0.00,0.00,6.00,708.00,'2022-05-27 17:40:53','',''),(6126,'1','219','1',1,'Retail Sale Id 6194',999.00,0.00,0.00,1.35,159.30,'2022-05-27 17:45:17','',''),(6127,'1','219','1',1,'Retail Sale Id 6195',999.00,0.00,0.00,1.35,159.30,'2022-05-27 17:57:08','',''),(6128,'1','219','1',1,'Retail Sale Id 6196',1198.80,0.00,0.00,1.62,191.16,'2022-05-27 18:15:47','',''),(6129,'1','219','1',1,'Retail Sale Id 6197',703.00,0.00,0.00,0.95,112.10,'2022-05-27 18:17:20','',''),(6130,'1','219','1',1,'Retail Sale Id 6198',1502.20,0.00,0.00,2.03,239.54,'2022-05-27 18:18:37','',''),(6131,'1','219','1',1,'Retail Sale Id 6199',1502.20,0.00,0.00,2.03,239.54,'2022-05-27 18:19:47','',''),(6132,'1','219','1',1,'Retail Sale Id 6200',1502.20,0.00,0.00,2.03,239.54,'2022-05-27 18:23:28','',''),(6133,'1','219','1',1,'Retail Sale Id 6201',4440.00,0.00,0.00,6.00,708.00,'2022-05-27 18:26:27','',''),(6134,'1','219','1',1,'Retail Sale Id 6202',1502.20,0.00,0.00,2.03,239.54,'2022-05-28 07:30:20','',''),(6135,'1','219','1',1,'Retail Sale Id 6202',1502.20,0.00,0.00,2.03,239.54,'2022-05-28 07:30:20','',''),(6136,'1','219','1',1,'Retail Sale Id 6203',3700.00,0.00,0.00,5.00,590.00,'2022-05-28 07:31:33','',''),(6137,'1','219','1',1,'Retail Sale Id 6204',1502.20,0.00,0.00,2.03,239.54,'2022-05-28 07:53:57','',''),(6138,'1','219','1',1,'Retail Sale Id 6205',4440.00,0.00,0.00,6.00,708.00,'2022-05-28 08:04:47','',''),(6139,'1','219','1',1,'Retail Sale Id 6206',999.00,0.00,0.00,1.35,159.30,'2022-05-28 08:21:51','',''),(6140,'1','219','1',1,'Retail Sale Id 6207',999.00,0.00,0.00,1.35,159.30,'2022-05-28 08:26:19','',''),(6141,'1','219','1',1,'Retail Sale Id 6208',999.00,0.00,0.00,1.35,159.30,'2022-05-28 08:38:55','',''),(6142,'1','219','1',1,'Retail Sale Id 6209',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 09:40:27','',''),(6143,'1','219','1',1,'Retail Sale Id 6210',999.00,0.00,0.00,1.35,159.30,'2022-05-28 09:45:47','',''),(6144,'1','219','1',1,'Retail Sale Id 6211',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 09:52:29','',''),(6145,'1','219','1',1,'Retail Sale Id 6212',2088.00,0.00,0.00,3.00,222.00,'2022-05-28 10:00:13','',''),(6146,'1','219','1',1,'Retail Sale Id 6213',5002.40,0.00,0.00,6.76,797.68,'2022-05-28 10:02:59','',''),(6147,'1','219','1',1,'Retail Sale Id 6214',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 10:05:21','',''),(6148,'1','219','1',1,'Retail Sale Id 6215',9250.00,0.00,0.00,12.50,1475.00,'2022-05-28 10:07:22','',''),(6149,'1','219','1',1,'Retail Sale Id 6216',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 10:09:02','',''),(6150,'1','219','1',1,'Retail Sale Id 6216',7000.40,0.00,0.00,9.46,1116.28,'2022-05-28 10:09:02','',''),(6151,'1','219','1',1,'Retail Sale Id 6217',8700.00,0.00,0.00,12.50,925.00,'2022-05-28 10:20:16','',''),(6152,'1','219','1',1,'Retail Sale Id 6218',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 10:42:53','',''),(6153,'1','219','1',1,'Retail Sale Id 6219',7400.00,0.00,0.00,10.00,1180.00,'2022-05-28 10:50:22','',''),(6154,'1','219','1',1,'Retail Sale Id 6220',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 10:58:18','',''),(6155,'1','219','1',1,'Retail Sale Id 6221',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 10:59:31','',''),(6156,'1','219','1',1,'Retail Sale Id 6222',503.20,0.00,0.00,0.68,80.24,'2022-05-28 11:03:11','',''),(6157,'1','219','1',1,'Retail Sale Id 6223',703.00,0.00,0.00,0.95,112.10,'2022-05-28 11:04:15','',''),(6158,'1','219','1',1,'Retail Sale Id 6224',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 11:17:11','',''),(6159,'1','219','1',1,'Retail Sale Id 6225',3700.00,0.00,0.00,5.00,590.00,'2022-05-28 11:23:47','',''),(6160,'1','219','1',1,'Retail Sale Id 6226',1502.20,0.00,0.00,2.03,239.54,'2022-05-28 11:43:57','',''),(6161,'1','219','1',1,'Retail Sale Id 6227',4003.40,0.00,0.00,5.41,638.38,'2022-05-28 11:51:44','',''),(6162,'1','219','1',1,'Retail Sale Id 6228',3700.00,0.00,0.00,5.00,590.00,'2022-05-28 11:57:16','',''),(6163,'1','219','1',1,'Retail Sale Id 6229',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 12:04:31','',''),(6164,'1','219','1',1,'Retail Sale Id 6230',2997.00,0.00,0.00,4.05,477.90,'2022-05-28 12:06:21','',''),(6165,'1','219','1',1,'Retail Sale Id 6231',7000.40,0.00,0.00,9.46,1116.28,'2022-05-28 12:07:30','',''),(6166,'1','219','1',1,'Retail Sale Id 6232',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 12:08:18','',''),(6167,'1','219','1',1,'Retail Sale Id 6233',2997.00,0.00,0.00,4.05,477.90,'2022-05-28 12:16:00','',''),(6168,'1','219','1',1,'Retail Sale Id 6234',2997.00,0.00,0.00,4.05,477.90,'2022-05-28 12:18:35','',''),(6169,'1','219','1',1,'Retail Sale Id 6235',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 12:30:03','',''),(6170,'1','219','1',1,'Retail Sale Id 6236',3700.00,0.00,0.00,5.00,590.00,'2022-05-28 12:35:04','',''),(6171,'1','219','1',1,'Retail Sale Id 6237',4176.00,0.00,0.00,6.00,444.00,'2022-05-28 12:36:33','',''),(6172,'1','219','1',1,'Retail Sale Id 6238',8700.00,0.00,0.00,12.50,925.00,'2022-05-28 12:37:56','',''),(6173,'1','219','1',1,'Retail Sale Id 6239',4440.00,0.00,0.00,6.00,708.00,'2022-05-28 12:39:22','',''),(6174,'1','219','1',1,'Retail Sale Id 6240',4003.40,0.00,0.00,5.41,638.38,'2022-05-28 12:51:19','',''),(6175,'1','219','1',1,'Retail Sale Id 6242',747.40,0.00,0.00,1.01,119.18,'2022-05-28 12:56:38','',''),(6176,'1','219','1',1,'Retail Sale Id 6243',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 13:05:14','',''),(6177,'1','219','1',1,'Retail Sale Id 6244',3700.00,0.00,0.00,5.00,590.00,'2022-05-28 13:34:05','',''),(6178,'1','219','1',1,'Retail Sale Id 6245',2501.20,0.00,0.00,3.38,398.84,'2022-05-28 13:36:37','',''),(6179,'1','219','1',1,'Retail Sale Id 6246',5002.40,0.00,0.00,6.76,797.68,'2022-05-28 13:55:12','',''),(6180,'1','219','1',1,'Retail Sale Id 6247',1110.00,0.00,0.00,1.50,177.00,'2022-05-28 14:06:11','',''),(6181,'1','219','1',1,'Retail Sale Id 6249',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 14:21:36','',''),(6182,'1','219','1',1,'Retail Sale Id 6251',4003.40,0.00,0.00,5.41,638.38,'2022-05-28 14:22:31','',''),(6183,'1','219','1',1,'Retail Sale Id 6252',4176.00,0.00,0.00,6.00,444.00,'2022-05-28 14:28:03','',''),(6184,'1','219','1',1,'Retail Sale Id 6254',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 14:54:27','',''),(6185,'1','219','1',1,'Retail Sale Id 6255',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 14:55:46','',''),(6186,'1','219','1',1,'Retail Sale Id 6256',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 14:56:56','',''),(6187,'1','219','1',1,'Retail Sale Id 6257',3500.20,0.00,0.00,4.73,558.14,'2022-05-28 15:02:59','',''),(6188,'1','219','1',1,'Retail Sale Id 6258',4176.00,0.00,0.00,6.00,444.00,'2022-05-28 15:15:33','',''),(6189,'1','219','1',1,'Retail Sale Id 6259',1502.20,0.00,0.00,2.03,239.54,'2022-05-28 15:22:56','',''),(6190,'1','219','1',1,'Retail Sale Id 6260',7400.00,0.00,0.00,10.00,1180.00,'2022-05-28 15:27:51','',''),(6191,'1','219','1',1,'Retail Sale Id 6261',3803.60,0.00,0.00,5.14,606.52,'2022-05-28 15:34:21','',''),(6192,'1','219','1',1,'Retail Sale Id 6262',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 15:36:10','',''),(6193,'1','219','1',1,'Retail Sale Id 6263',9250.00,0.00,0.00,12.50,1475.00,'2022-05-28 16:05:44','',''),(6194,'1','219','1',1,'Retail Sale Id 6264',9250.00,0.00,0.00,12.50,1475.00,'2022-05-28 16:13:36','',''),(6195,'1','219','1',1,'Retail Sale Id 6264',9250.00,0.00,0.00,12.50,1475.00,'2022-05-28 16:13:36','',''),(6196,'1','219','1',1,'Retail Sale Id 6265',1502.20,0.00,0.00,2.03,239.54,'2022-05-28 16:15:48','',''),(6197,'1','219','1',1,'Retail Sale Id 6266',4440.00,0.00,0.00,6.00,708.00,'2022-05-28 16:19:17','',''),(6198,'1','219','1',1,'Retail Sale Id 6267',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 16:20:23','',''),(6199,'1','219','1',1,'Retail Sale Id 6268',703.00,0.00,0.00,0.95,112.10,'2022-05-28 16:24:34','',''),(6200,'1','219','1',1,'Retail Sale Id 6269',999.00,0.00,0.00,1.35,159.30,'2022-05-28 16:29:08','',''),(6201,'1','219','1',1,'Retail Sale Id 6270',999.00,0.00,0.00,1.35,159.30,'2022-05-28 16:34:48','',''),(6202,'1','219','1',1,'Retail Sale Id 6271',4176.00,0.00,0.00,6.00,444.00,'2022-05-28 16:37:18','',''),(6203,'1','219','1',1,'Retail Sale Id 6272',5002.40,0.00,0.00,6.76,797.68,'2022-05-28 16:40:57','',''),(6204,'1','219','1',1,'Retail Sale Id 6274',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 16:47:34','',''),(6205,'1','219','1',1,'Retail Sale Id 6275',2997.00,0.00,0.00,4.05,477.90,'2022-05-28 17:13:23','',''),(6206,'1','219','1',1,'Retail Sale Id 6276',1198.80,0.00,0.00,1.62,191.16,'2022-05-28 17:19:07','',''),(6207,'1','219','1',1,'Retail Sale Id 6277',1480.00,0.00,0.00,2.00,236.00,'2022-05-28 17:23:17','',''),(6208,'1','219','1',1,'Retail Sale Id 6278',999.00,0.00,0.00,1.35,159.30,'2022-05-28 17:31:25','',''),(6209,'1','219','1',1,'Retail Sale Id 6279',703.00,0.00,0.00,0.95,112.10,'2022-05-28 17:34:42','',''),(6210,'1','219','1',1,'Retail Sale Id 6280',2501.20,0.00,0.00,3.38,398.84,'2022-05-28 17:38:03','',''),(6211,'1','219','1',1,'Retail Sale Id 6281',4440.00,0.00,0.00,6.00,708.00,'2022-05-28 17:49:01','',''),(6212,'1','219','1',1,'Retail Sale Id 6282',636.40,0.00,0.00,0.86,101.48,'2022-05-28 18:02:17','',''),(6213,'1','219','1',1,'Retail Sale Id 6283',999.00,0.00,0.00,1.35,159.30,'2022-05-28 18:09:16','',''),(6214,'1','219','1',1,'Retail Sale Id 6285',2197.80,0.00,0.00,2.97,350.46,'2022-05-28 18:12:19','',''),(6215,'1','219','1',1,'Retail Sale Id 6286',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 18:20:32','',''),(6216,'1','219','1',1,'Retail Sale Id 6287',2220.00,0.00,0.00,3.00,354.00,'2022-05-28 18:24:44','',''),(6217,'1','219','1',1,'Retail Sale Id 6288',1998.00,0.00,0.00,2.70,318.60,'2022-05-28 18:33:22','',''),(6218,'1','219','1',1,'Retail Sale Id 6289',999.00,0.00,0.00,1.35,159.30,'2022-05-28 18:34:16','',''),(6219,'1','219','1',1,'Retail Sale Id 6290',9250.00,0.00,0.00,12.50,1475.00,'2022-05-28 18:44:52','',''),(6220,'1','219','1',1,'Retail Sale Id 6291',2997.00,0.00,0.00,4.05,477.90,'2022-05-28 19:00:49','',''),(6221,'1','219','1',1,'Retail Sale Id 6292',799.20,0.00,0.00,1.08,127.44,'2022-05-28 19:04:53','',''),(6222,'1','219','1',1,'Retail Sale Id 6293',700.00,0.00,0.00,1.00,78.00,'2022-05-29 07:54:25','',''),(6223,'1','219','1',1,'Retail Sale Id 6294',2100.00,0.00,0.00,3.00,234.00,'2022-05-29 08:01:54','',''),(6224,'1','219','1',1,'Retail Sale Id 6295',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 08:18:29','',''),(6225,'1','219','1',1,'Retail Sale Id 6296',2100.00,0.00,0.00,3.00,234.00,'2022-05-29 08:48:01','',''),(6226,'1','219','1',1,'Retail Sale Id 6297',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 08:54:24','',''),(6227,'1','219','1',1,'Retail Sale Id 6298',8750.00,0.00,0.00,12.50,975.00,'2022-05-29 08:56:13','',''),(6228,'1','219','1',1,'Retail Sale Id 6299',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 08:58:54','',''),(6229,'1','219','1',1,'Retail Sale Id 6300',2800.00,0.00,0.00,4.00,312.00,'2022-05-29 09:06:17','',''),(6230,'1','219','1',1,'Retail Sale Id 6301',2002.00,0.00,0.00,2.86,223.08,'2022-05-29 09:07:06','',''),(6231,'1','219','1',1,'Retail Sale Id 6302',70992.00,0.00,0.00,102.00,7548.00,'2022-05-29 09:46:08','',''),(6232,'1','219','1',1,'Retail Sale Id 6303',4998.00,0.00,0.00,7.14,556.92,'2022-05-29 09:54:15','',''),(6233,'1','219','1',1,'Retail Sale Id 6304',6960.00,0.00,0.00,10.00,740.00,'2022-05-29 10:13:44','',''),(6234,'1','219','1',1,'Retail Sale Id 6305',1400.00,0.00,0.00,2.00,156.00,'2022-05-29 10:17:01','',''),(6235,'1','219','1',1,'Retail Sale Id 6306',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 10:26:22','',''),(6236,'1','219','1',1,'Retail Sale Id 6307',2002.00,0.00,0.00,2.86,223.08,'2022-05-29 10:38:07','',''),(6237,'1','219','1',1,'Retail Sale Id 6308',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 10:51:24','',''),(6238,'1','219','1',1,'Retail Sale Id 6309',8001.00,0.00,0.00,11.43,891.54,'2022-05-29 10:56:41','',''),(6239,'1','219','1',1,'Retail Sale Id 6310',3997.00,0.00,0.00,5.71,445.38,'2022-05-29 10:57:55','',''),(6240,'1','219','1',1,'Retail Sale Id 6311',700.00,0.00,0.00,1.00,78.00,'2022-05-29 10:58:36','',''),(6241,'1','219','1',1,'Retail Sale Id 6312',6300.00,0.00,0.00,9.00,702.00,'2022-05-29 11:01:15','',''),(6242,'1','219','1',1,'Retail Sale Id 6313',1498.00,0.00,0.00,2.14,166.92,'2022-05-29 11:21:31','',''),(6243,'1','219','1',1,'Retail Sale Id 6314',1750.00,0.00,0.00,2.50,195.00,'2022-05-29 11:31:07','',''),(6244,'1','219','1',1,'Retail Sale Id 6315',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 11:34:24','',''),(6245,'1','219','1',1,'Retail Sale Id 6316',3500.00,0.00,0.00,5.00,390.00,'2022-05-29 11:35:27','',''),(6246,'1','219','1',1,'Retail Sale Id 6317',2100.00,0.00,0.00,3.00,234.00,'2022-05-29 11:42:00','',''),(6247,'1','219','1',1,'Retail Sale Id 6318',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 11:48:51','',''),(6248,'1','219','1',1,'Retail Sale Id 6320',1400.00,0.00,0.00,2.00,156.00,'2022-05-29 11:58:16','',''),(6249,'1','219','1',1,'Retail Sale Id 6320',1400.00,0.00,0.00,2.00,156.00,'2022-05-29 11:58:16','',''),(6250,'1','219','1',1,'Retail Sale Id 6321',700.00,0.00,0.00,1.00,78.00,'2022-05-29 12:00:53','',''),(6251,'1','219','1',1,'Retail Sale Id 6321',700.00,0.00,0.00,1.00,78.00,'2022-05-29 12:00:53','',''),(6252,'1','219','1',1,'Retail Sale Id 6322',1498.00,0.00,0.00,2.14,166.92,'2022-05-29 12:05:16','',''),(6253,'1','219','1',1,'Retail Sale Id 6323',1197.00,0.00,0.00,1.71,133.38,'2022-05-29 12:07:09','',''),(6254,'1','219','1',1,'Retail Sale Id 6324',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 12:45:37','',''),(6255,'1','219','1',1,'Retail Sale Id 6325',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 12:51:25','',''),(6256,'1','219','1',1,'Retail Sale Id 6326',5600.00,0.00,0.00,8.00,624.00,'2022-05-29 12:55:21','',''),(6257,'1','219','1',1,'Retail Sale Id 6327',3500.00,0.00,0.00,5.00,390.00,'2022-05-29 13:03:19','',''),(6258,'1','219','1',1,'Retail Sale Id 6328',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 13:04:18','',''),(6259,'1','219','1',1,'Retail Sale Id 6329',3997.00,0.00,0.00,5.71,445.38,'2022-05-29 13:05:22','',''),(6260,'1','219','1',1,'Retail Sale Id 6330',7000.00,0.00,0.00,10.00,780.00,'2022-05-29 13:10:59','',''),(6261,'1','219','1',1,'Retail Sale Id 6331',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 13:11:53','',''),(6262,'1','219','1',1,'Retail Sale Id 6332',3003.00,0.00,0.00,4.29,334.62,'2022-05-29 13:14:18','',''),(6263,'1','219','1',1,'Retail Sale Id 6333',399.00,0.00,0.00,0.57,44.46,'2022-05-29 13:16:52','',''),(6264,'1','219','1',1,'Retail Sale Id 6334',4081.00,0.00,0.00,5.83,454.74,'2022-05-29 13:18:44','',''),(6265,'1','219','1',1,'Retail Sale Id 6335',8750.00,0.00,0.00,12.50,975.00,'2022-05-29 13:22:18','',''),(6266,'1','219','1',1,'Retail Sale Id 6337',2100.00,0.00,0.00,3.00,234.00,'2022-05-29 13:46:19','',''),(6267,'1','219','1',1,'Retail Sale Id 6338',700.00,0.00,0.00,1.00,78.00,'2022-05-29 13:49:29','',''),(6268,'1','219','1',1,'Retail Sale Id 6339',7000.00,0.00,0.00,10.00,780.00,'2022-05-29 14:00:01','',''),(6269,'1','219','1',1,'Retail Sale Id 6340',6300.00,0.00,0.00,9.00,702.00,'2022-05-29 14:01:32','',''),(6270,'1','219','1',1,'Retail Sale Id 6341',2002.00,0.00,0.00,2.86,223.08,'2022-05-29 14:08:47','',''),(6271,'1','219','1',1,'Retail Sale Id 6342',1001.00,0.00,0.00,1.43,111.54,'2022-05-29 14:09:36','',''),(6272,'1','219','1',1,'Retail Sale Id 6343',2002.00,0.00,0.00,2.86,223.08,'2022-05-29 14:10:32','',''),(6273,'1','219','1',1,'Retail Sale Id 6344',1001.00,0.00,0.00,1.43,111.54,'2022-05-29 14:11:21','',''),(6274,'1','219','1',1,'Retail Sale Id 6345',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 14:19:41','',''),(6275,'1','219','1',1,'Retail Sale Id 6346',8750.00,0.00,0.00,12.50,975.00,'2022-05-29 14:29:41','',''),(6276,'1','219','1',1,'Retail Sale Id 6347',1001.00,0.00,0.00,1.43,111.54,'2022-05-29 14:30:43','',''),(6277,'1','219','1',1,'Retail Sale Id 6348',2499.00,0.00,0.00,3.57,278.46,'2022-05-29 14:38:36','',''),(6278,'1','219','1',1,'Retail Sale Id 6349',8750.00,0.00,0.00,12.50,975.00,'2022-05-29 15:00:55','',''),(6279,'1','219','1',1,'Retail Sale Id 6350',2002.00,0.00,0.00,2.86,223.08,'2022-05-29 15:03:16','',''),(6280,'1','219','1',1,'Retail Sale Id 6351',1897.00,0.00,0.00,2.71,211.38,'2022-05-29 15:23:24','',''),(6281,'1','219','1',1,'Retail Sale Id 6352',4176.00,0.00,0.00,6.00,444.00,'2022-05-29 15:34:48','',''),(6282,'1','219','1',1,'Retail Sale Id 6353',2100.00,0.00,0.00,3.00,234.00,'2022-05-29 15:39:35','',''),(6283,'1','219','1',1,'Retail Sale Id 6354',8750.00,0.00,0.00,12.50,975.00,'2022-05-29 15:40:27','',''),(6284,'1','219','1',1,'Retail Sale Id 6355',1400.00,0.00,0.00,2.00,156.00,'2022-05-29 15:46:28','',''),(6285,'1','219','1',1,'Retail Sale Id 6356',1400.00,0.00,0.00,2.00,156.00,'2022-05-29 15:47:04','',''),(6286,'1','219','1',1,'Retail Sale Id 6357',3500.00,0.00,0.00,5.00,390.00,'2022-05-29 16:11:32','',''),(6287,'1','219','1',1,'Retail Sale Id 6358',3997.00,0.00,0.00,5.71,445.38,'2022-05-29 16:13:59','',''),(6288,'1','219','1',1,'Retail Sale Id 6359',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 16:18:29','',''),(6289,'1','219','1',1,'Retail Sale Id 6359',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 16:18:29','',''),(6290,'1','219','1',1,'Retail Sale Id 6360',1400.00,0.00,0.00,2.00,156.00,'2022-05-29 16:47:32','',''),(6291,'1','219','1',1,'Retail Sale Id 6361',2100.00,0.00,0.00,3.00,234.00,'2022-05-29 16:52:43','',''),(6292,'1','219','1',1,'Retail Sale Id 6362',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 17:07:26','',''),(6293,'1','219','1',1,'Retail Sale Id 6363',1498.00,0.00,0.00,2.14,166.92,'2022-05-29 17:09:51','',''),(6294,'1','219','1',1,'Retail Sale Id 6364',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 17:11:14','',''),(6295,'1','219','1',1,'Retail Sale Id 6365',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 17:15:31','',''),(6296,'1','219','1',1,'Retail Sale Id 6366',497.00,0.00,0.00,0.71,55.38,'2022-05-29 17:32:36','',''),(6297,'1','219','1',1,'Retail Sale Id 6367',2499.00,0.00,0.00,3.57,278.46,'2022-05-29 17:34:06','',''),(6298,'1','219','1',1,'Retail Sale Id 6368',301.00,0.00,0.00,0.43,33.54,'2022-05-29 17:52:30','',''),(6299,'1','219','1',1,'Retail Sale Id 6369',7000.00,0.00,0.00,10.00,780.00,'2022-05-29 18:01:28','',''),(6300,'1','219','1',1,'Retail Sale Id 6370',497.00,0.00,0.00,0.71,55.38,'2022-05-29 18:02:20','',''),(6301,'1','219','1',1,'Retail Sale Id 6371',4200.00,0.00,0.00,6.00,468.00,'2022-05-29 18:03:08','',''),(6302,'1','219','1',1,'Retail Sale Id 6372',4900.00,0.00,0.00,7.00,546.00,'2022-05-29 18:05:10','',''),(6303,'1','219','1',1,'Retail Sale Id 6373',7000.00,0.00,0.00,10.00,780.00,'2022-05-29 18:08:27','',''),(6304,'1','219','1',1,'Retail Sale Id 6374',2002.00,0.00,0.00,2.86,223.08,'2022-05-29 18:12:26','',''),(6305,'1','219','1',1,'Retail Sale Id 6375',4998.00,0.00,0.00,7.14,556.92,'2022-05-29 18:13:19','',''),(6306,'1','219','1',1,'Retail Sale Id 6376',497.00,0.00,0.00,0.71,55.38,'2022-05-29 18:16:26','',''),(6307,'1','219','1',1,'Retail Sale Id 6377',3500.00,0.00,0.00,5.00,390.00,'2022-05-29 18:22:56','',''),(6308,'1','219','1',1,'Retail Sale Id 6378',1001.00,0.00,0.00,1.43,111.54,'2022-05-29 18:31:30','',''),(6309,'1','219','1',1,'Retail Sale Id 6379',3500.00,0.00,0.00,5.00,390.00,'2022-05-29 18:42:44','',''),(6310,'1','219','1',1,'Retail Sale Id 6380',1302.00,0.00,0.00,1.86,145.08,'2022-05-29 18:45:41','',''),(6311,'1','219','1',1,'Retail Sale Id 6381',700.00,0.00,0.00,1.00,78.00,'2022-05-29 19:02:28','',''),(6312,'1','219','1',1,'Return of Retail Sale Id 6377',0.00,3500.00,5.00,0.00,-390.00,'2022-05-29 23:31:07','',''),(6313,'1','219','1',1,'Retail Sale Id 6382',2800.00,0.00,0.00,4.00,312.00,'2022-05-30 07:49:11','',''),(6314,'1','219','1',1,'Retail Sale Id 6383',4200.00,0.00,0.00,6.00,468.00,'2022-05-30 07:50:48','',''),(6315,'1','219','1',1,'Retail Sale Id 6384',3003.00,0.00,0.00,4.29,334.62,'2022-05-30 08:18:28','',''),(6316,'1','219','1',1,'Retail Sale Id 6385',3003.00,0.00,0.00,4.29,334.62,'2022-05-30 08:19:11','',''),(6317,'1','219','1',1,'Retail Sale Id 6386',1001.00,0.00,0.00,1.43,111.54,'2022-05-30 08:28:15','',''),(6318,'1','219','1',1,'Retail Sale Id 6387',3500.00,0.00,0.00,5.00,390.00,'2022-05-30 08:30:16','',''),(6319,'1','219','1',1,'Retail Sale Id 6387',4200.00,0.00,0.00,6.00,468.00,'2022-05-30 08:30:16','',''),(6320,'1','219','1',1,'Retail Sale Id 6388',3003.00,0.00,0.00,4.29,334.62,'2022-05-30 08:31:30','',''),(6321,'1','219','1',1,'Retail Sale Id 6389',2100.00,0.00,0.00,3.00,234.00,'2022-05-30 08:58:39','',''),(6322,'1','219','1',1,'Retail Sale Id 6390',7000.00,0.00,0.00,10.00,780.00,'2022-05-30 09:15:20','',''),(6323,'1','219','1',1,'Retail Sale Id 6391',35000.00,0.00,0.00,50.00,3900.00,'2022-05-30 09:37:44','',''),(6324,'1','219','1',1,'Retail Sale Id 6393',4900.00,0.00,0.00,7.00,546.00,'2022-05-30 10:00:30','',''),(6325,'1','219','1',1,'Retail Sale Id 6394',3003.00,0.00,0.00,4.29,334.62,'2022-05-30 10:05:23','',''),(6326,'1','219','1',1,'Retail Sale Id 6396',1750.00,0.00,0.00,2.50,195.00,'2022-05-30 10:06:48','',''),(6327,'1','219','1',1,'Retail Sale Id 6397',1001.00,0.00,0.00,1.43,111.54,'2022-05-30 10:23:37','',''),(6328,'1','219','1',1,'Retail Sale Id 6398',3500.00,0.00,0.00,5.00,390.00,'2022-05-30 10:24:49','',''),(6329,'1','219','1',1,'Retail Sale Id 6399',4200.00,0.00,0.00,6.00,468.00,'2022-05-30 10:42:26','',''),(6330,'1','219','1',1,'Retail Sale Id 6400',700.00,0.00,0.00,1.00,78.00,'2022-05-30 11:01:08','',''),(6331,'1','219','1',1,'Retail Sale Id 6401',497.00,0.00,0.00,0.71,55.38,'2022-05-30 11:02:30','',''),(6332,'1','219','1',1,'Retail Sale Id 6402',2002.00,0.00,0.00,2.86,223.08,'2022-05-30 11:03:21','',''),(6333,'1','219','1',1,'Retail Sale Id 6403',2100.00,0.00,0.00,3.00,234.00,'2022-05-30 11:28:57','',''),(6334,'1','219','1',1,'Retail Sale Id 6403',2100.00,0.00,0.00,3.00,234.00,'2022-05-30 11:28:57','',''),(6335,'1','219','1',1,'Retail Sale Id 6404',3997.00,0.00,0.00,5.71,445.38,'2022-05-30 11:30:09','',''),(6336,'1','219','1',1,'Retail Sale Id 6405',4200.00,0.00,0.00,6.00,468.00,'2022-05-30 11:31:04','',''),(6337,'1','219','1',1,'Retail Sale Id 6406',10500.00,0.00,0.00,15.00,1170.00,'2022-05-30 11:33:33','',''),(6338,'1','219','1',1,'Retail Sale Id 6407',8750.00,0.00,0.00,12.50,975.00,'2022-05-30 11:36:33','',''),(6339,'1','219','1',1,'Retail Sale Id 6408',3500.00,0.00,0.00,5.00,390.00,'2022-05-30 11:57:42','',''),(6340,'1','219','1',1,'Retail Sale Id 6409',8750.00,0.00,0.00,12.50,975.00,'2022-05-30 12:32:07','',''),(6341,'1','219','1',1,'Retail Sale Id 6410',1001.00,0.00,0.00,1.43,111.54,'2022-05-30 12:34:48','',''),(6342,'1','219','1',1,'Retail Sale Id 6411',1498.00,0.00,0.00,2.14,166.92,'2022-05-30 12:35:38','',''),(6343,'1','219','1',1,'Retail Sale Id 6412',2100.00,0.00,0.00,3.00,234.00,'2022-05-30 13:13:52','',''),(6344,'1','219','1',1,'Retail Sale Id 6413',1498.00,0.00,0.00,2.14,166.92,'2022-05-30 13:27:09','',''),(6345,'1','219','1',1,'Retail Sale Id 6414',700.00,0.00,0.00,1.00,78.00,'2022-05-30 13:28:30','',''),(6346,'1','219','1',1,'Retail Sale Id 6415',1498.00,0.00,0.00,2.14,166.92,'2022-05-30 13:30:19','',''),(6347,'1','219','1',1,'Retail Sale Id 6416',3500.00,0.00,0.00,5.00,390.00,'2022-05-30 13:50:40','',''),(6348,'1','219','1',1,'Retail Sale Id 6417',2100.00,0.00,0.00,3.00,234.00,'2022-05-30 14:25:45','',''),(6349,'1','219','1',1,'Retail Sale Id 6418',3500.00,0.00,0.00,5.00,390.00,'2022-05-30 14:44:28','',''),(6350,'1','219','1',1,'Retail Sale Id 6419',3500.00,0.00,0.00,5.00,390.00,'2022-05-30 14:48:55','',''),(6351,'1','219','1',1,'Retail Sale Id 6420',8750.00,0.00,0.00,12.50,975.00,'2022-05-30 14:54:09','',''),(6352,'1','219','1',1,'Retail Sale Id 6422',3367.00,0.00,0.00,4.81,375.18,'2022-05-30 15:02:53','',''),(6353,'1','219','1',1,'Retail Sale Id 6423',4200.00,0.00,0.00,6.00,468.00,'2022-05-30 15:07:50','',''),(6354,'1','219','1',1,'Retail Sale Id 6424',1750.00,0.00,0.00,2.50,195.00,'2022-05-30 15:12:30','',''),(6355,'1','219','1',1,'Retail Sale Id 6425',3801.00,0.00,0.00,5.43,423.54,'2022-05-30 15:15:26','',''),(6356,'1','219','1',1,'Retail Sale Id 6427',1750.00,0.00,0.00,2.50,195.00,'2022-05-30 15:19:12','',''),(6357,'1','219','1',1,'Retail Sale Id 6427',1750.00,0.00,0.00,2.50,195.00,'2022-05-30 15:19:12','',''),(6358,'1','219','1',1,'Retail Sale Id 6428',8750.00,0.00,0.00,12.50,975.00,'2022-05-30 16:01:45','',''),(6359,'1','219','1',1,'Retail Sale Id 6429',2002.00,0.00,0.00,2.86,223.08,'2022-05-30 16:20:44','',''),(6360,'1','219','1',1,'Retail Sale Id 6430',4200.00,0.00,0.00,6.00,468.00,'2022-05-30 16:21:55','',''),(6361,'1','219','1',1,'Retail Sale Id 6431',1400.00,0.00,0.00,2.00,156.00,'2022-05-30 16:22:40','',''),(6362,'1','219','1',1,'Retail Sale Id 6432',3997.00,0.00,0.00,5.71,445.38,'2022-05-30 16:41:06','',''),(6363,'1','219','1',1,'Retail Sale Id 6434',7.00,0.00,0.00,0.01,0.78,'2022-05-30 16:56:29','',''),(6364,'1','219','1',1,'Retail Sale Id 6435',4200.00,0.00,0.00,6.00,468.00,'2022-05-30 16:57:36','',''),(6365,'1','219','1',1,'Retail Sale Id 6436',4200.00,0.00,0.00,6.00,468.00,'2022-05-30 17:00:10','',''),(6366,'1','219','1',1,'Retail Sale Id 6437',2100.00,0.00,0.00,3.00,234.00,'2022-05-30 17:06:58','',''),(6367,'1','219','1',1,'Retail Sale Id 6438',1498.00,0.00,0.00,2.14,166.92,'2022-05-30 17:09:39','',''),(6368,'1','219','1',1,'Retail Sale Id 6439',1197.00,0.00,0.00,1.71,133.38,'2022-05-30 17:25:11','',''),(6369,'1','219','1',1,'Retail Sale Id 6440',4200.00,0.00,0.00,6.00,468.00,'2022-05-30 17:28:54','',''),(6370,'1','219','1',1,'Retail Sale Id 6441',2100.00,0.00,0.00,3.00,234.00,'2022-05-30 17:33:57','',''),(6371,'1','219','1',1,'Retail Sale Id 6442',1498.00,0.00,0.00,2.14,166.92,'2022-05-30 17:37:04','',''),(6372,'1','219','1',1,'Retail Sale Id 6443',1799.00,0.00,0.00,2.57,200.46,'2022-05-30 17:44:50','',''),(6373,'1','219','1',1,'Retail Sale Id 6444',700.00,0.00,0.00,1.00,78.00,'2022-05-30 17:46:32','',''),(6374,'1','219','1',1,'Retail Sale Id 6445',1400.00,0.00,0.00,2.00,156.00,'2022-05-30 17:47:40','',''),(6375,'1','219','1',1,'Retail Sale Id 6446',1400.00,0.00,0.00,2.00,156.00,'2022-05-30 17:49:37','',''),(6376,'1','219','1',1,'Retail Sale Id 6447',2100.00,0.00,0.00,3.00,234.00,'2022-05-30 18:03:01','',''),(6377,'1','219','1',1,'Retail Sale Id 6447',2800.00,0.00,0.00,4.00,312.00,'2022-05-30 18:03:01','',''),(6378,'1','219','1',1,'Retail Sale Id 6447',6300.00,0.00,0.00,9.00,702.00,'2022-05-30 18:03:01','',''),(6379,'1','219','1',1,'Retail Sale Id 6448',3997.00,0.00,0.00,5.71,445.38,'2022-05-30 18:06:27','',''),(6380,'1','219','1',1,'Retail Sale Id 6449',497.00,0.00,0.00,0.71,55.38,'2022-05-30 18:08:44','',''),(6381,'1','219','1',1,'Retail Sale Id 6450',2898.00,0.00,0.00,4.14,322.92,'2022-05-30 18:14:32','',''),(6382,'1','219','1',1,'Retail Sale Id 6451',2100.00,0.00,0.00,3.00,234.00,'2022-05-30 18:18:29','',''),(6383,'1','219','1',1,'Retail Sale Id 6452',651.00,0.00,0.00,0.93,72.54,'2022-05-30 18:19:36','',''),(6384,'1','219','1',1,'Retail Sale Id 6453',2100.00,0.00,0.00,3.00,234.00,'2022-05-30 18:28:22','',''),(6385,'1','219','1',1,'Retail Sale Id 6454',4200.00,0.00,0.00,6.00,468.00,'2022-05-30 18:43:20','',''),(6386,'1','219','1',1,'Retail Sale Id 6455',700.00,0.00,0.00,1.00,78.00,'2022-05-30 18:44:45','',''),(6387,'1','219','1',1,'Retail Sale Id 6456',1498.00,0.00,0.00,2.14,166.92,'2022-05-30 18:56:18','',''),(6388,'1','219','1',1,'Retail Sale Id 6457',2998.80,0.00,0.00,4.41,255.78,'2022-05-31 07:56:10','',''),(6389,'1','219','1',1,'Retail Sale Id 6457',4998.00,0.00,0.00,7.35,426.30,'2022-05-31 07:56:10','',''),(6390,'1','219','1',1,'Retail Sale Id 6458',2040.00,0.00,0.00,3.00,174.00,'2022-05-31 08:08:01','',''),(6391,'1','219','1',1,'Retail Sale Id 6458',3400.00,0.00,0.00,5.00,290.00,'2022-05-31 08:08:01','',''),(6392,'1','219','1',1,'Retail Sale Id 6459',1999.20,0.00,0.00,2.94,170.52,'2022-05-31 08:34:53','',''),(6393,'1','219','1',1,'Retail Sale Id 6459',1999.20,0.00,0.00,2.94,170.52,'2022-05-31 08:34:53','',''),(6394,'1','219','1',1,'Retail Sale Id 6460',700.40,0.00,0.00,1.03,59.74,'2022-05-31 08:39:06','',''),(6395,'1','219','1',1,'Retail Sale Id 6461',4080.00,0.00,0.00,6.00,348.00,'2022-05-31 08:46:40','',''),(6396,'1','219','1',1,'Retail Sale Id 6461',4080.00,0.00,0.00,6.00,348.00,'2022-05-31 08:46:40','',''),(6397,'1','219','1',1,'Retail Sale Id 6462',4080.00,0.00,0.00,6.00,348.00,'2022-05-31 09:17:48','',''),(6398,'1','219','1',1,'Retail Sale Id 6463',2801.60,0.00,0.00,4.12,238.96,'2022-05-31 09:32:51','',''),(6399,'1','219','1',1,'Retail Sale Id 6464',3400.00,0.00,0.00,5.00,290.00,'2022-05-31 09:56:19','',''),(6400,'1','219','1',1,'Retail Sale Id 6465',503.20,0.00,0.00,0.74,42.92,'2022-05-31 10:04:03','',''),(6401,'1','219','1',1,'Retail Sale Id 6466',1999.20,0.00,0.00,2.94,170.52,'2022-05-31 10:16:10','',''),(6402,'1','219','1',1,'Retail Sale Id 6467',4080.00,0.00,0.00,6.00,348.00,'2022-05-31 10:21:03','',''),(6403,'1','219','1',1,'Retail Sale Id 6468',3998.40,0.00,0.00,5.88,341.04,'2022-05-31 10:33:34','',''),(6404,'1','219','1',1,'Retail Sale Id 6469',700.40,0.00,0.00,1.03,59.74,'2022-05-31 10:37:52','',''),(6405,'1','219','1',1,'Retail Sale Id 6470',1502.80,0.00,0.00,2.21,128.18,'2022-05-31 10:50:57','',''),(6406,'1','219','1',1,'Retail Sale Id 6471',2046.80,0.00,0.00,3.01,174.58,'2022-05-31 11:29:34','',''),(6407,'1','219','1',1,'Retail Sale Id 6472',2998.80,0.00,0.00,4.41,255.78,'2022-05-31 11:31:13','',''),(6408,'1','219','1',1,'Retail Sale Id 6473',3400.00,0.00,0.00,5.00,290.00,'2022-05-31 11:35:44','',''),(6409,'1','219','1',1,'Retail Sale Id 6474',999.60,0.00,0.00,1.47,85.26,'2022-05-31 11:40:15','',''),(6410,'1','219','1',1,'Retail Sale Id 6475',8500.00,0.00,0.00,12.50,725.00,'2022-05-31 11:43:13','',''),(6411,'1','219','1',1,'Retail Sale Id 6476',4100.40,0.00,0.00,6.03,349.74,'2022-05-31 11:49:11','',''),(6412,'1','219','1',1,'Retail Sale Id 6477',2046.80,0.00,0.00,3.01,174.58,'2022-05-31 11:53:42','',''),(6413,'1','219','1',1,'Retail Sale Id 6478',680.00,0.00,0.00,1.00,58.00,'2022-05-31 12:10:56','',''),(6414,'1','219','1',1,'Retail Sale Id 6479',6800.00,0.00,0.00,10.00,580.00,'2022-05-31 12:12:30','',''),(6415,'1','219','1',1,'Retail Sale Id 6480',2040.00,0.00,0.00,3.00,174.00,'2022-05-31 12:28:52','',''),(6416,'1','219','1',1,'Retail Sale Id 6480',3400.00,0.00,0.00,5.00,290.00,'2022-05-31 12:28:52','',''),(6417,'1','219','1',1,'Retail Sale Id 6481',1802.00,0.00,0.00,2.65,153.70,'2022-05-31 13:03:48','',''),(6418,'1','219','1',1,'Retail Sale Id 6482',8500.00,0.00,0.00,12.50,725.00,'2022-05-31 13:16:59','',''),(6419,'1','219','1',1,'Retail Sale Id 6483',2046.80,0.00,0.00,3.01,174.58,'2022-05-31 13:28:04','',''),(6420,'1','219','1',1,'Retail Sale Id 6484',2040.00,0.00,0.00,3.00,174.00,'2022-05-31 13:33:51','',''),(6421,'1','219','1',1,'Retail Sale Id 6484',3400.00,0.00,0.00,5.00,290.00,'2022-05-31 13:33:51','',''),(6422,'1','219','1',1,'Retail Sale Id 6485',2998.80,0.00,0.00,4.41,255.78,'2022-05-31 13:44:40','',''),(6423,'1','219','1',1,'Retail Sale Id 6486',2101.20,0.00,0.00,3.09,179.22,'2022-05-31 13:52:32','',''),(6424,'1','219','1',1,'Retail Sale Id 6487',6800.00,0.00,0.00,10.00,580.00,'2022-05-31 13:54:11','',''),(6425,'1','219','1',1,'Retail Sale Id 6488',3502.00,0.00,0.00,5.15,298.70,'2022-05-31 13:56:14','',''),(6426,'1','219','1',1,'Retail Sale Id 6489',4100.40,0.00,0.00,6.03,349.74,'2022-05-31 13:57:37','',''),(6427,'1','219','1',1,'Retail Sale Id 6490',6800.00,0.00,0.00,10.00,580.00,'2022-05-31 14:00:02','',''),(6428,'1','219','1',1,'Retail Sale Id 6491',598.40,0.00,0.00,0.88,51.04,'2022-05-31 14:02:31','',''),(6429,'1','219','1',1,'Retail Sale Id 6492',1502.80,0.00,0.00,2.21,128.18,'2022-05-31 14:03:30','',''),(6430,'1','219','1',1,'Retail Sale Id 6493',4100.40,0.00,0.00,6.03,349.74,'2022-05-31 14:31:02','',''),(6431,'1','219','1',1,'Retail Sale Id 6494',999.60,0.00,0.00,1.47,85.26,'2022-05-31 14:45:08','',''),(6432,'1','219','1',1,'Retail Sale Id 6496',4998.00,0.00,0.00,7.35,426.30,'2022-05-31 14:50:34','',''),(6433,'1','219','1',1,'Retail Sale Id 6497',6800.00,0.00,0.00,10.00,580.00,'2022-05-31 14:51:44','',''),(6434,'1','219','1',1,'Retail Sale Id 6498',3502.00,0.00,0.00,5.15,298.70,'2022-05-31 14:55:33','',''),(6435,'1','219','1',1,'Retail Sale Id 6499',999.60,0.00,0.00,1.47,85.26,'2022-05-31 14:58:32','',''),(6436,'1','219','1',1,'Retail Sale Id 6499',1999.20,0.00,0.00,2.94,170.52,'2022-05-31 14:58:32','',''),(6437,'1','219','1',1,'Retail Sale Id 6500',2747.20,0.00,0.00,4.04,234.32,'2022-05-31 15:02:33','',''),(6438,'1','219','1',1,'Retail Sale Id 6501',1999.20,0.00,0.00,2.94,170.52,'2022-05-31 15:03:32','',''),(6439,'1','219','1',1,'Retail Sale Id 6502',3998.40,0.00,0.00,5.88,341.04,'2022-05-31 15:04:41','',''),(6440,'1','219','1',1,'Retail Sale Id 6503',2040.00,0.00,0.00,3.00,174.00,'2022-05-31 15:09:23','',''),(6441,'1','219','1',1,'Retail Sale Id 6504',8500.00,0.00,0.00,12.50,725.00,'2022-05-31 15:22:08','',''),(6442,'1','219','1',1,'Retail Sale Id 6505',8500.00,0.00,0.00,12.50,725.00,'2022-05-31 15:44:09','',''),(6443,'1','219','1',1,'Retail Sale Id 6505',8500.00,0.00,0.00,12.50,725.00,'2022-05-31 15:44:09','',''),(6444,'1','219','1',1,'Retail Sale Id 6506',1598.00,0.00,0.00,2.35,136.30,'2022-05-31 16:23:14','',''),(6445,'1','219','1',1,'Retail Sale Id 6507',299.20,0.00,0.00,0.44,25.52,'2022-05-31 16:42:25','',''),(6446,'1','219','1',1,'Retail Sale Id 6508',2998.80,0.00,0.00,4.41,255.78,'2022-05-31 16:45:14','',''),(6447,'1','219','1',1,'Retail Sale Id 6509',999.60,0.00,0.00,1.47,85.26,'2022-05-31 16:53:31','',''),(6448,'1','219','1',1,'Retail Sale Id 6510',680.00,0.00,0.00,1.00,58.00,'2022-05-31 17:14:37','',''),(6449,'1','219','1',1,'Retail Sale Id 6511',700.40,0.00,0.00,1.03,59.74,'2022-05-31 17:29:44','',''),(6450,'1','219','1',1,'Retail Sale Id 6512',2998.80,0.00,0.00,4.41,255.78,'2022-05-31 17:38:10','',''),(6451,'1','219','1',1,'Retail Sale Id 6513',4501.60,0.00,0.00,6.62,383.96,'2022-05-31 17:41:23','',''),(6452,'1','219','1',1,'Retail Sale Id 6514',2040.00,0.00,0.00,3.00,174.00,'2022-05-31 17:49:57','',''),(6453,'1','219','1',1,'Retail Sale Id 6514',4080.00,0.00,0.00,6.00,348.00,'2022-05-31 17:49:57','',''),(6454,'1','219','1',1,'Retail Sale Id 6516',1999.20,0.00,0.00,2.94,170.52,'2022-05-31 17:52:00','',''),(6455,'1','219','1',1,'Retail Sale Id 6517',1502.80,0.00,0.00,2.21,128.18,'2022-05-31 18:00:35','',''),(6456,'1','219','1',1,'Retail Sale Id 6520',4080.00,0.00,0.00,6.00,348.00,'2022-05-31 18:23:41','',''),(6457,'1','219','1',1,'Retail Sale Id 6521',999.60,0.00,0.00,1.47,85.26,'2022-05-31 18:27:10','',''),(6458,'1','219','1',1,'Retail Sale Id 6522',700.40,0.00,0.00,1.03,59.74,'2022-05-31 18:28:01','',''),(6459,'1','219','1',1,'Retail Sale Id 6523',999.60,0.00,0.00,1.47,85.26,'2022-05-31 18:36:04','',''),(6460,'1','219','1',1,'Retail Sale Id 6525',4100.40,0.00,0.00,6.03,349.74,'2022-05-31 18:37:44','',''),(6461,'1','219','1',1,'Retail Sale Id 6526',3903.20,0.00,0.00,5.74,332.92,'2022-05-31 18:38:54','',''),(6462,'1','219','1',1,'Retail Sale Id 6527',1502.80,0.00,0.00,2.21,128.18,'2022-05-31 18:43:01','',''),(6463,'1','219','1',1,'Retail Sale Id 6528',1502.80,0.00,0.00,2.21,128.18,'2022-05-31 18:52:44','',''),(6464,'1','219','1',1,'Retail Sale Id 6529',4080.00,0.00,0.00,6.00,348.00,'2022-05-31 18:56:24','',''),(6465,'1','219','1',1,'Retail Sale Id 6530',2046.80,0.00,0.00,3.01,174.58,'2022-05-31 18:59:10','',''),(6466,'1','219','1',1,'Retail Sale Id 6532',1298.80,0.00,0.00,1.91,110.78,'2022-05-31 19:10:22','',''),(6467,'1','219','1',1,'Retail Sale Id 6533',2040.00,0.00,0.00,3.00,174.00,'2022-06-01 07:10:31','',''),(6468,'1','219','1',1,'Retail Sale Id 6534',1360.00,0.00,0.00,2.00,116.00,'2022-06-01 07:15:32','',''),(6469,'1','219','1',1,'Retail Sale Id 6534',1360.00,0.00,0.00,2.00,116.00,'2022-06-01 07:15:32','',''),(6470,'1','219','1',1,'Retail Sale Id 6535',2046.80,0.00,0.00,3.01,174.58,'2022-06-01 07:35:15','',''),(6471,'1','219','1',1,'Retail Sale Id 6536',2720.00,0.00,0.00,4.00,232.00,'2022-06-01 08:12:40','',''),(6472,'1','219','1',1,'Retail Sale Id 6536',2720.00,0.00,0.00,4.00,232.00,'2022-06-01 08:12:40','',''),(6473,'1','219','1',1,'Retail Sale Id 6537',4202.40,0.00,0.00,6.18,358.44,'2022-06-01 08:19:32','',''),(6474,'1','219','1',1,'Retail Sale Id 6538',6800.00,0.00,0.00,10.00,580.00,'2022-06-01 08:32:19','',''),(6475,'1','219','1',1,'Retail Sale Id 6539',999.60,0.00,0.00,1.47,85.26,'2022-06-01 08:35:06','',''),(6476,'1','219','1',1,'Retail Sale Id 6540',503.20,0.00,0.00,0.74,42.92,'2022-06-01 08:36:28','',''),(6477,'1','219','1',1,'Retail Sale Id 6541',2998.80,0.00,0.00,4.41,255.78,'2022-06-01 08:42:08','',''),(6478,'1','219','1',1,'Retail Sale Id 6542',4760.00,0.00,0.00,7.00,406.00,'2022-06-01 08:48:39','',''),(6479,'1','219','1',1,'Retail Sale Id 6543',1020.00,0.00,0.00,1.50,87.00,'2022-06-01 09:03:08','',''),(6480,'1','219','1',1,'Retail Sale Id 6544',4100.40,0.00,0.00,6.03,349.74,'2022-06-01 09:04:20','',''),(6481,'1','219','1',1,'Retail Sale Id 6545',3746.80,0.00,0.00,5.51,319.58,'2022-06-01 09:10:48','',''),(6482,'1','219','1',1,'Retail Sale Id 6546',2040.00,0.00,0.00,3.00,174.00,'2022-06-01 09:13:18','',''),(6483,'1','219','1',1,'Retail Sale Id 6546',2040.00,0.00,0.00,3.00,174.00,'2022-06-01 09:13:18','',''),(6484,'1','219','1',1,'Retail Sale Id 6546',8500.00,0.00,0.00,12.50,725.00,'2022-06-01 09:13:18','',''),(6485,'1','219','1',1,'Retail Sale Id 6547',999.60,0.00,0.00,1.47,85.26,'2022-06-01 09:43:57','',''),(6486,'1','219','1',1,'Retail Sale Id 6548',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 09:48:43','',''),(6487,'1','219','1',1,'Retail Sale Id 6548',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 09:48:43','',''),(6488,'1','219','1',1,'Retail Sale Id 6549',8500.00,0.00,0.00,12.50,725.00,'2022-06-01 09:51:18','',''),(6489,'1','219','1',1,'Retail Sale Id 6550',6800.00,0.00,0.00,10.00,580.00,'2022-06-01 09:57:01','',''),(6490,'1','219','1',1,'Retail Sale Id 6551',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 09:58:37','',''),(6491,'1','219','1',1,'Retail Sale Id 6552',999.60,0.00,0.00,1.47,85.26,'2022-06-01 10:07:45','',''),(6492,'1','219','1',1,'Retail Sale Id 6553',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 10:19:04','',''),(6493,'1','219','1',1,'Retail Sale Id 6554',3998.40,0.00,0.00,5.88,341.04,'2022-06-01 10:20:03','',''),(6494,'1','219','1',1,'Retail Sale Id 6555',3998.40,0.00,0.00,5.88,341.04,'2022-06-01 10:21:23','',''),(6495,'1','219','1',1,'Retail Sale Id 6556',652.80,0.00,0.00,0.96,55.68,'2022-06-01 10:33:11','',''),(6496,'1','219','1',1,'Retail Sale Id 6557',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 10:51:41','',''),(6497,'1','219','1',1,'Retail Sale Id 6558',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 10:56:55','',''),(6498,'1','219','1',1,'Retail Sale Id 6559',1360.00,0.00,0.00,2.00,116.00,'2022-06-01 10:58:59','',''),(6499,'1','219','1',1,'Retail Sale Id 6560',2040.00,0.00,0.00,3.00,174.00,'2022-06-01 11:14:22','',''),(6500,'1','219','1',1,'Retail Sale Id 6562',1360.00,0.00,0.00,2.00,116.00,'2022-06-01 11:27:14','',''),(6501,'1','219','1',1,'Retail Sale Id 6563',299.20,0.00,0.00,0.44,25.52,'2022-06-01 11:29:10','',''),(6502,'1','219','1',1,'Retail Sale Id 6564',2400.40,0.00,0.00,3.53,204.74,'2022-06-01 11:30:12','',''),(6503,'1','219','1',1,'Retail Sale Id 6565',1999.20,0.00,0.00,2.94,170.52,'2022-06-01 11:31:32','',''),(6504,'1','219','1',1,'Retail Sale Id 6566',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 11:35:06','',''),(6505,'1','219','1',1,'Retail Sale Id 6567',7480.00,0.00,0.00,11.00,638.00,'2022-06-01 11:41:24','',''),(6506,'1','219','1',1,'Retail Sale Id 6568',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 11:45:13','',''),(6507,'1','219','1',1,'Retail Sale Id 6569',8500.00,0.00,0.00,12.50,725.00,'2022-06-01 12:12:03','',''),(6508,'1','219','1',1,'Retail Sale Id 6570',700.40,0.00,0.00,1.03,59.74,'2022-06-01 12:29:20','',''),(6509,'1','219','1',1,'Retail Sale Id 6571',2040.00,0.00,0.00,3.00,174.00,'2022-06-01 12:32:41','',''),(6510,'1','219','1',1,'Retail Sale Id 6572',3400.00,0.00,0.00,5.00,290.00,'2022-06-01 13:09:05','',''),(6511,'1','219','1',1,'Retail Sale Id 6573',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 13:12:45','',''),(6512,'1','219','1',1,'Retail Sale Id 6573',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 13:12:45','',''),(6513,'1','219','1',1,'Retail Sale Id 6574',1986.00,0.00,0.00,3.00,120.00,'2022-06-01 13:17:04','',''),(6514,'1','219','1',1,'Retail Sale Id 6575',598.40,0.00,0.00,0.88,51.04,'2022-06-01 13:21:39','',''),(6515,'1','219','1',1,'Retail Sale Id 6576',999.60,0.00,0.00,1.47,85.26,'2022-06-01 13:27:36','',''),(6516,'1','219','1',1,'Retail Sale Id 6576',1502.80,0.00,0.00,2.21,128.18,'2022-06-01 13:27:36','',''),(6517,'1','219','1',1,'Retail Sale Id 6577',2400.40,0.00,0.00,3.53,204.74,'2022-06-01 14:09:42','',''),(6518,'1','219','1',1,'Retail Sale Id 6578',3998.40,0.00,0.00,5.88,341.04,'2022-06-01 14:15:28','',''),(6519,'1','219','1',1,'Retail Sale Id 6579',1400.80,0.00,0.00,2.06,119.48,'2022-06-01 14:21:54','',''),(6520,'1','219','1',1,'Retail Sale Id 6581',3998.40,0.00,0.00,5.88,341.04,'2022-06-01 14:47:16','',''),(6521,'1','219','1',1,'Retail Sale Id 6583',999.60,0.00,0.00,1.47,85.26,'2022-06-01 15:22:53','',''),(6522,'1','219','1',1,'Retail Sale Id 6584',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 15:31:15','',''),(6523,'1','219','1',1,'Retail Sale Id 6585',700.40,0.00,0.00,1.03,59.74,'2022-06-01 15:34:56','',''),(6524,'1','219','1',1,'Retail Sale Id 6586',8500.00,0.00,0.00,12.50,725.00,'2022-06-01 15:42:05','',''),(6525,'1','219','1',1,'Retail Sale Id 6587',1360.00,0.00,0.00,2.00,116.00,'2022-06-01 15:46:33','',''),(6526,'1','219','1',1,'Retail Sale Id 6587',3400.00,0.00,0.00,5.00,290.00,'2022-06-01 15:46:33','',''),(6527,'1','219','1',1,'Retail Sale Id 6588',3400.00,0.00,0.00,5.00,290.00,'2022-06-01 15:48:41','',''),(6528,'1','219','1',1,'Retail Sale Id 6589',3400.00,0.00,0.00,5.00,290.00,'2022-06-01 15:50:41','',''),(6529,'1','219','1',1,'Retail Sale Id 6590',2040.00,0.00,0.00,3.00,174.00,'2022-06-01 16:03:59','',''),(6530,'1','219','1',1,'Retail Sale Id 6591',2040.00,0.00,0.00,3.00,174.00,'2022-06-01 16:08:59','',''),(6531,'1','219','1',1,'Retail Sale Id 6592',6800.00,0.00,0.00,10.00,580.00,'2022-06-01 16:36:53','',''),(6532,'1','219','1',1,'Retail Sale Id 6593',6800.00,0.00,0.00,10.00,580.00,'2022-06-01 16:43:53','',''),(6533,'1','219','1',1,'Retail Sale Id 6594',1400.80,0.00,0.00,2.06,119.48,'2022-06-01 16:45:56','',''),(6534,'1','219','1',1,'Retail Sale Id 6595',4998.00,0.00,0.00,7.35,426.30,'2022-06-01 16:48:26','',''),(6535,'1','219','1',1,'Retail Sale Id 6596',4080.00,0.00,0.00,6.00,348.00,'2022-06-01 16:54:11','',''),(6536,'1','219','1',1,'Retail Sale Id 6597',999.60,0.00,0.00,1.47,85.26,'2022-06-01 16:55:46','',''),(6537,'1','219','1',1,'Retail Sale Id 6598',3972.00,0.00,0.00,6.00,240.00,'2022-06-01 17:00:58','',''),(6538,'1','219','1',1,'Retail Sale Id 6599',2040.00,0.00,0.00,3.00,174.00,'2022-06-01 