-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_208
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_208`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_208` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_208`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4066 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (4050,400128,'',0,'22','1','208','PURCHASES','','2021-12-25 18:29:51',5,0.00,0.00,'','479','2021-12-25 18:29:51','479',0,0),(4051,400371,'',0,'24','1','208','PURCHASES','','2021-12-25 18:30:09',5,0.00,0.00,'','479','2021-12-25 18:30:09','479',0,0),(4052,20065,'',0,'20','1','208','SALES','','2021-12-25 18:30:24',5,0.00,0.00,'','479','2021-12-25 18:30:24','479',0,0),(4053,40067,'',0,'6.1','1','208','CASH','','2021-12-25 18:30:38',5,0.00,0.00,'','479','2021-12-25 18:30:38','479',0,0),(4054,400730,'',0,'2','1','208','ZB(LPG)1014471475','','2021-12-25 18:31:05',5,0.00,0.00,'','479','2021-12-25 18:31:05','479',0,0),(4055,400731,'',0,'2','1','208','UNITY BANK-0024061656','','2021-12-25 18:31:18',5,0.00,0.00,'','479','2021-12-25 18:31:18','479',0,0),(4056,400732,'',0,'2','1','208','UBA YOLA-1021398099','','2021-12-25 18:32:05',5,0.00,0.00,'','479','2021-12-25 18:32:05','479',0,0),(4057,400733,'',0,'2','1','208','FB(IBAL)2023855223','','2021-12-25 18:32:21',5,0.00,0.00,'','479','2021-12-25 18:32:21','479',0,0),(4058,400734,'',0,'2','1','208','FID POS COLLECTION-5620141491','','2021-12-25 18:32:33',5,0.00,0.00,'','479','2021-12-25 18:32:33','479',0,0),(4059,400735,'',0,'2','1','208','E-BILLS 1015372548','','2021-12-25 18:32:55',5,0.00,0.00,'','479','2021-12-25 18:32:55','479',0,0),(4060,400736,'',0,'2','1','208','E-BILLS  IBAL 1015372548','','2021-12-25 18:33:07',5,0.00,0.00,'','479','2021-12-25 18:33:07','479',0,0),(4061,400372,'',0,'24','1','208','SALARIES & WAGES','','2021-12-25 18:37:17',5,0.00,0.00,'','479','2021-12-25 18:37:17','479',0,0),(4062,400737,'',0,'2','1','208','DANKANO-EBILLS:ZNB1014717618','','2021-12-25 18:37:38',5,0.00,0.00,'','479','2021-12-25 18:37:38','479',0,0),(4063,400738,'',0,'2','1','208','ZNB POS COLLECTION: 1015965368','','2022-03-06 16:24:59',5,0.00,0.00,'','487','2022-03-06 16:24:59','487',0,0),(4064,400739,'',0,'2','1','208','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:30:16',5,0.00,0.00,'','792','2023-02-20 14:30:16','792',0,0),(4065,400740,'',0,'2','1','208','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:34:12',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:48:22','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','208','Dankano lpg','Dankano lpg','08065027535','nidrisabdullahi@gmail.com','Gwale','Kano','Dankano lpg','Nigeria',2000.00,0.00,0.00,'0000-00-00','2022-02-08 07:44:02',5,'738','2022-02-08 07:44:02','738');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3079 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','208','1038',3072,'5','LPG NOZZLE ',220787.65,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-01-20 06:45:43','483'),('1','208','1038',3076,'5','LPG NOZZLE 2',241913.52,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-01-20 06:46:22','483'),('1','208','1038',3077,'5','LPG NOZZLE 3',183994.21,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-01-20 06:47:12','483'),('1','208','1038',3078,'5','LPG NOZZLE 4',113221.52,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-01-20 06:47:59','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258001 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','208',253435,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-14 23:07:41','738','2022-01-14 23:08:09',10,0),('1','208',253699,'DAILY SHIFTS','2022-01-15','2022-01-15 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-16 06:31:43','738','2022-01-16 06:32:23',10,0),('1','208',253947,'DAILY SHIFTS','2022-01-16','2022-01-16 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-16 21:43:39','738','2022-01-16 21:47:32',10,0),('1','208',254280,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-17 10:28:01','738','2022-01-17 10:28:49',10,0),('1','208',254283,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-18 06:59:17','738','2022-01-18 06:59:46',10,0),('1','208',254446,'DAILY SHIFTS','2022-01-18','2022-01-18 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-19 09:04:12','738','2022-01-19 09:04:37',10,0),('1','208',254759,'DAILY SHIFTS','2022-01-19','2022-01-19 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-19 21:16:08','738','2022-01-19 21:17:55',10,0),('1','208',254990,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-20 20:42:25','738','2022-01-20 20:44:38',10,0),('1','208',255195,'Daily shift','2022-01-21','2022-01-21 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-22 07:57:29','738','2022-01-22 08:04:35',10,0),('1','208',255487,'Daily shift','2022-01-22','2022-01-22 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-23 07:58:58','738','2022-01-23 08:00:34',10,0),('1','208',255729,'Daily shift','2022-01-23','2022-01-23 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-24 08:10:30','738','2022-01-24 08:11:37',10,0),('1','208',255987,'DAILY SHIFTS','2022-01-24','2022-01-24 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-24 21:18:24','738','2022-01-24 21:18:54',10,0),('1','208',256238,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-26 09:28:51','738','2022-01-26 09:32:55',10,0),('1','208',256546,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-26 19:59:53','738','2022-01-26 20:01:38',10,0),('1','208',256737,'Daily shift','2022-01-27','2022-01-27 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-28 08:40:29','738','2022-01-28 08:42:54',10,0),('1','208',257008,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-28 20:32:12','738','2022-01-28 20:32:49',10,0),('1','208',257296,'Daily shift','2022-01-29','2022-01-29 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-30 00:08:36','738','2022-01-30 00:11:17',10,0),('1','208',257507,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'738',0.00,0.00,'738','2022-01-31 09:35:22','738','2022-01-31 09:36:05',10,0),('1','208',257508,'DAILY SHIFTS','2022-01-31','2022-01-31 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-01 00:35:48','738','2022-02-01 00:37:07',10,0),('1','208',257509,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-01 20:45:14','738','2022-02-01 20:45:43',10,0),('1','208',257510,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-02 22:54:42','738','2022-02-02 22:55:37',10,0),('1','208',257511,'Daily shift','2022-02-03','2022-02-03 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-03 20:37:06','738','2022-02-03 20:37:31',10,0),('1','208',257512,'Daily shift','2022-02-04','2022-02-04 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-04 23:23:19','738','2022-02-04 23:23:54',10,0),('1','208',257513,'Daily shift','2022-02-05','2022-02-05 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-05 20:33:59','738','2022-02-05 20:34:57',10,0),('1','208',257514,'Daily shift','2022-02-06','2022-02-06 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-06 20:18:40','738','2022-02-06 20:19:07',10,0),('1','208',257515,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-07 15:53:25','738','2022-02-07 15:53:55',10,0),('1','208',257516,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-08 08:38:08','738','2022-02-08 08:38:48',10,0),('1','208',257517,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-09 00:12:19','738','2022-02-09 00:12:54',10,0),('1','208',257518,'Daily shift','2022-02-09','2022-02-09 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-10 06:46:15','738','2022-02-10 06:47:06',10,0),('1','208',257519,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-10 19:41:32','738','2022-02-10 19:42:26',10,0),('1','208',257520,'Daily shift','2022-02-11','2022-02-11 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-12 10:14:03','738','2022-02-12 10:14:27',10,0),('1','208',257521,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-12 19:16:05','738','2022-02-12 19:16:30',10,0),('1','208',257522,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-13 23:05:39','738','2022-02-13 23:06:22',10,0),('1','208',257523,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-14 20:53:02','738','2022-02-14 20:53:40',10,0),('1','208',257524,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-15 19:33:10','738','2022-02-15 19:33:42',10,0),('1','208',257525,'DAILY SHIFTS','2022-02-16','2022-02-16 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-16 22:19:29','738','2022-02-16 22:19:55',10,0),('1','208',257526,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-17 20:27:28','738','2022-02-17 20:27:48',10,0),('1','208',257527,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-18 22:07:27','738','2022-02-18 22:08:10',10,0),('1','208',257528,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-19 21:48:22','738','2022-02-19 21:48:49',10,0),('1','208',257529,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-20 21:05:45','738','2022-02-20 21:06:09',10,0),('1','208',257530,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'738',0.00,0.00,'738','2022-02-21 22:31:55','738','2022-02-21 22:32:19',10,0),('1','208',257531,'DAILY SHIFT','2022-02-22','2022-02-22 07:37:51','2022-02-23 07:37:51','738',0.00,0.00,'738','2022-02-22 19:53:38','738','2022-02-22 19:53:57',10,0),('1','208',257532,'DAILY SHIFT','2022-02-23','2022-02-23 07:36:09','2022-02-24 07:36:09','738',0.00,0.00,'738','2022-02-23 23:32:17','738','2022-02-23 23:33:00',10,0),('1','208',257533,'DAILY SHIFT','2022-02-24','2022-02-24 07:30:34','2022-02-25 07:30:34','738',0.00,0.00,'738','2022-02-24 21:48:47','738','2022-02-24 21:49:08',10,0),('1','208',257534,'DAILY SHIFT','2022-02-25','2022-02-25 07:52:18','2022-02-26 07:52:18','738',0.00,0.00,'738','2022-02-25 23:12:34','738','2022-02-25 23:12:52',10,0),('1','208',257535,'DAILY SHIFT','2022-02-26','2022-02-26 10:30:25','2022-02-27 10:30:25','738',0.00,0.00,'738','2022-02-26 22:33:47','738','2022-02-26 22:34:09',10,0),('1','208',257536,'DAILY SHIFT','2022-02-27','2022-02-27 08:07:48','2022-02-28 08:07:48','738',0.00,0.00,'738','2022-02-27 22:34:27','738','2022-02-27 22:34:45',10,0),('1','208',257537,'DAILY SHIFT','2022-02-28','2022-02-28 07:24:33','2022-03-01 07:24:33','738',0.00,0.00,'738','2022-02-28 23:23:08','738','2022-02-28 23:23:31',10,0),('1','208',257538,'DAILY SHIFT','2022-03-01','2022-03-01 11:55:17','2022-03-02 11:55:17','738',0.00,0.00,'738','2022-03-01 20:39:02','738','2022-03-01 20:39:29',10,0),('1','208',257539,'DAILY SHIFT','2022-03-02','2022-03-02 07:24:53','2022-03-03 07:24:53','738',0.00,0.00,'738','2022-03-02 22:08:24','738','2022-03-02 22:09:35',10,0),('1','208',257540,'DAILY SHIFT','2022-03-03','2022-03-03 07:43:41','2022-03-04 07:43:41','738',0.00,0.00,'738','2022-03-03 22:23:55','738','2022-03-03 22:24:16',10,0),('1','208',257541,'DAILY SHIFT','2022-03-04','2022-03-04 07:19:17','2022-03-05 07:19:17','738',0.00,0.00,'738','2022-03-04 20:24:20','738','2022-03-04 20:24:39',10,0),('1','208',257542,'DAILY SHIFT','2022-03-05','2022-03-05 07:39:29','2022-03-06 07:39:29','738',0.00,0.00,'738','2022-03-05 23:17:39','738','2022-03-05 23:18:03',10,0),('1','208',257543,'DAILY SHIFT','2022-03-06','2022-03-06 07:30:22','2022-03-07 07:30:22','738',0.00,0.00,'738','2022-03-06 22:08:22','738','2022-03-06 22:08:40',10,0),('1','208',257544,'Daily shift','2022-03-07','2022-03-07 07:41:38','2022-03-08 07:41:38','738',0.00,0.00,'738','2022-03-07 23:13:15','738','2022-03-07 23:13:39',10,0),('1','208',257545,'DAILY SHIFT','2022-03-08','2022-03-08 07:50:06','2022-03-09 07:50:06','738',0.00,0.00,'738','2022-03-08 22:53:46','738','2022-03-08 22:54:00',10,0),('1','208',257546,'DAILY SHIFT','2022-03-09','2022-03-09 09:30:46','2022-03-10 09:30:46','738',0.00,0.00,'738','2022-03-10 00:10:06','738','2022-03-10 00:10:30',10,0),('1','208',257547,'DAILY SHIFT','2022-03-10','2022-03-10 08:43:28','2022-03-11 08:43:28','738',0.00,0.00,'738','2022-03-10 21:46:42','738','2022-03-10 21:47:04',10,0),('1','208',257548,'DAILY SHIFT','2022-03-11','2022-03-11 06:44:38','2022-03-12 06:44:38','738',0.00,0.00,'738','2022-03-11 22:38:07','738','2022-03-11 22:38:34',10,0),('1','208',257549,'DAILY SHIFT','2022-03-12','2022-03-12 09:12:40','2022-03-13 09:12:40','738',0.00,0.00,'738','2022-03-12 22:26:17','738','2022-03-12 22:26:36',10,0),('1','208',257550,'DAILY SHIFT','2022-03-13','2022-03-13 07:13:58','2022-03-14 07:13:58','738',0.00,0.00,'738','2022-03-13 22:57:48','738','2022-03-13 22:58:13',10,0),('1','208',257551,'DAILY SHIFT','2022-03-14','2022-03-14 07:12:44','2022-03-15 07:12:44','738',0.00,0.00,'738','2022-03-14 21:37:05','738','2022-03-14 21:37:32',10,0),('1','208',257552,'DAILY SHIFT','2022-03-15','2022-03-15 07:30:42','2022-03-16 07:30:42','738',0.00,0.00,'738','2022-03-15 22:19:00','738','2022-03-15 22:19:29',10,0),('1','208',257553,'DAILY SHIFT','2022-03-16','2022-03-16 07:44:56','2022-03-17 07:44:56','738',0.00,0.00,'738','2022-03-16 22:16:47','738','2022-03-16 22:17:06',10,0),('1','208',257554,'DAILY SHIFT','2022-03-17','2022-03-17 07:57:07','2022-03-18 07:57:07','738',0.00,0.00,'738','2022-03-17 23:04:08','738','2022-03-17 23:04:26',10,0),('1','208',257555,'Daily shift','2022-03-18','2022-03-18 06:49:44','2022-03-19 06:49:44','738',0.00,0.00,'738','2022-03-18 22:51:11','738','2022-03-18 22:51:35',10,0),('1','208',257556,'DAILY SHIFT','2022-03-19','2022-03-19 07:47:35','2022-03-20 07:47:35','738',0.00,0.00,'738','2022-03-19 18:44:52','738','2022-03-19 18:45:33',10,0),('1','208',257557,'DAILY SHIFT','2022-03-19','2022-03-19 20:00:23','2022-03-20 20:00:23','738',0.00,0.00,'738','2022-03-19 22:16:09','738','2022-03-19 22:16:27',10,0),('1','208',257558,'DAILY SHIFT','2022-03-20','2022-03-20 07:49:11','2022-03-21 07:49:11','738',0.00,0.00,'738','2022-03-20 22:18:21','738','2022-03-20 22:18:41',10,0),('1','208',257559,'DAILY SHIFT','2022-03-21','2022-03-21 07:22:33','2022-03-22 07:22:33','738',0.00,0.00,'738','2022-03-21 22:34:46','738','2022-03-21 22:35:07',10,0),('1','208',257560,'DAILY SHIFT','2022-03-22','2022-03-22 07:23:00','2022-03-23 07:23:00','738',0.00,0.00,'738','2022-03-22 23:06:47','738','2022-03-22 23:07:09',10,0),('1','208',257561,'DAILY SHIFT','2022-03-23','2022-03-23 06:47:52','2022-03-24 06:47:52','738',0.00,0.00,'738','2022-03-23 23:50:22','738','2022-03-23 23:50:52',10,0),('1','208',257562,'DAILY SHIFT','2022-03-24','2022-03-24 07:11:07','2022-03-25 07:11:07','738',0.00,0.00,'738','2022-03-24 21:31:33','738','2022-03-24 21:36:17',10,0),('1','208',257563,'DAILY SHIFT','2022-03-25','2022-03-25 07:42:27','2022-03-26 07:42:27','738',0.00,0.00,'738','2022-03-25 19:41:29','738','2022-03-25 19:41:50',10,0),('1','208',257564,'DAILY SHIFT','2022-03-26','2022-03-26 10:07:25','2022-03-27 10:07:25','738',0.00,0.00,'738','2022-03-26 22:23:49','738','2022-03-26 22:24:15',10,0),('1','208',257565,'Daily shift','2022-03-27','2022-03-27 06:26:07','2022-03-28 06:26:07','738',0.00,0.00,'738','2022-03-27 22:42:50','738','2022-03-27 22:43:08',10,0),('1','208',257566,'DAILY SHIFT','2022-03-28','2022-03-28 07:31:17','2022-03-29 07:31:17','738',0.00,0.00,'738','2022-03-28 23:28:13','738','2022-03-28 23:28:31',10,0),('1','208',257567,'DAILY SHIFT','2022-03-29','2022-03-29 06:53:03','2022-03-30 06:53:03','738',0.00,0.00,'738','2022-03-29 22:29:23','738','2022-03-29 22:29:50',10,0),('1','208',257568,'DAILY SHIFT','2022-03-30','2022-03-30 07:58:26','2022-03-31 07:58:26','738',0.00,0.00,'738','2022-03-30 22:03:47','738','2022-03-30 22:04:10',10,0),('1','208',257569,'Daily shift','2022-03-31','2022-03-31 06:07:05','2022-04-01 06:07:05','738',0.00,0.00,'738','2022-03-31 21:27:33','738','2022-03-31 21:28:09',10,0),('1','208',257570,'DAILY SHIFT','2022-04-01','2022-04-01 08:00:43','2022-04-02 08:00:43','738',0.00,0.00,'738','2022-04-01 21:31:55','738','2022-04-01 21:32:19',10,0),('1','208',257571,'DAILY SHIFT','2022-04-02','2022-04-02 07:52:01','2022-04-03 07:52:01','738',0.00,0.00,'738','2022-04-03 07:08:47','738','2022-04-03 07:09:09',10,0),('1','208',257572,'DAILY SHIFT','2022-04-03','2022-04-03 08:06:58','2022-04-04 08:06:58','738',0.00,0.00,'738','2022-04-03 14:19:06','738','2022-04-03 14:20:14',10,0),('1','208',257573,'DAILY SHIFT','2022-04-03','2022-04-03 14:27:32','2022-04-04 14:27:32','738',0.00,0.00,'738','2022-04-03 21:35:11','738','2022-04-03 21:35:37',10,0),('1','208',257574,'DAILY SHIFT','2022-04-04','2022-04-04 08:18:48','2022-04-05 08:18:48','738',0.00,0.00,'738','2022-04-04 19:11:20','738','2022-04-04 19:11:41',10,0),('1','208',257575,'DAILY SHIFT','2022-04-05','2022-04-05 07:03:01','2022-04-06 07:03:01','738',0.00,0.00,'738','2022-04-05 21:39:04','738','2022-04-05 21:39:23',10,0),('1','208',257576,'DAILY SHIFT','2022-04-06','2022-04-06 06:37:43','2022-04-07 06:37:43','738',0.00,0.00,'738','2022-04-06 21:05:30','738','2022-04-06 21:05:48',10,0),('1','208',257577,'DAILY SHIFT','2022-04-07','2022-04-07 07:26:48','2022-04-08 07:26:48','738',0.00,0.00,'738','2022-04-07 21:39:56','738','2022-04-07 21:40:15',10,0),('1','208',257578,'DAILY SHIFT','2022-04-08','2022-04-08 06:37:38','2022-04-09 06:37:38','738',0.00,0.00,'738','2022-04-08 22:41:02','738','2022-04-08 22:41:22',10,0),('1','208',257579,'DAILY SHIFT','2022-04-09','2022-04-09 07:19:36','2022-04-10 07:19:36','738',0.00,0.00,'738','2022-04-09 21:07:55','738','2022-04-09 21:08:14',10,0),('1','208',257580,'DAILY SHIFT','2022-04-10','2022-04-10 06:38:03','2022-04-11 06:38:03','738',0.00,0.00,'738','2022-04-10 21:01:06','738','2022-04-10 21:01:22',10,0),('1','208',257581,'DAILY SHIFT','2022-04-11','2022-04-11 07:29:14','2022-04-12 07:29:14','738',0.00,0.00,'738','2022-04-11 21:04:01','738','2022-04-11 21:04:22',10,0),('1','208',257582,'DAILY SHIFT','2022-04-12','2022-04-12 07:19:42','2022-04-13 07:19:42','738',0.00,0.00,'738','2022-04-12 16:36:20','738','2022-04-12 16:36:54',10,0),('1','208',257583,'Daily shift','2022-04-12','2022-04-12 16:38:49','2022-04-13 16:38:49','738',0.00,0.00,'738','2022-04-12 20:47:14','738','2022-04-12 20:47:36',10,0),('1','208',257584,'DAILY SHIFT','2022-04-13','2022-04-13 07:14:06','2022-04-14 07:14:06','738',0.00,0.00,'738','2022-04-13 21:11:49','738','2022-04-13 21:12:10',10,0),('1','208',257585,'DAILY SHIFT','2022-04-14','2022-04-14 07:37:58','2022-04-15 07:37:58','738',0.00,0.00,'738','2022-04-14 22:07:14','738','2022-04-14 22:07:35',10,0),('1','208',257586,'Daily shift','2022-04-15','2022-04-15 05:34:55','2022-04-16 05:34:55','738',0.00,0.00,'738','2022-04-15 21:42:32','738','2022-04-15 21:42:50',10,0),('1','208',257587,'DAILY SHIFT','2022-04-16','2022-04-16 07:48:39','2022-04-17 07:48:39','738',0.00,0.00,'738','2022-04-16 21:43:46','738','2022-04-16 21:44:05',10,0),('1','208',257588,'DAILY SHIFT','2022-04-17','2022-04-17 07:14:22','2022-04-18 07:14:22','738',0.00,0.00,'738','2022-04-17 18:05:13','738','2022-04-17 18:05:41',10,0),('1','208',257589,'Daily shift','2022-04-17','2022-04-17 20:15:53','2022-04-18 20:15:53','738',0.00,0.00,'738','2022-04-17 20:20:37','738','2022-04-17 20:20:54',10,0),('1','208',257590,'DAILY SHIFT','2022-04-18','2022-04-18 07:29:09','2022-04-19 07:29:09','738',0.00,0.00,'738','2022-04-19 01:07:43','738','2022-04-19 01:08:03',10,0),('1','208',257591,'DAILY SHIFT','2022-04-19','2022-04-19 07:16:46','2022-04-20 07:16:46','738',0.00,0.00,'738','2022-04-20 07:08:18','738','2022-04-20 07:08:36',10,0),('1','208',257592,'Daily shift','2022-04-20','2022-04-20 07:15:47','2022-04-21 07:15:47','738',0.00,0.00,'738','2022-04-20 22:18:44','738','2022-04-20 22:19:28',10,0),('1','208',257593,'DAILY SHIFT','2022-04-21','2022-04-21 07:46:46','2022-04-22 07:46:46','738',0.00,0.00,'738','2022-04-21 21:51:41','738','2022-04-21 21:52:02',10,0),('1','208',257594,'DAILY SHIFT','2022-04-22','2022-04-22 06:36:42','2022-04-23 06:36:42','738',0.00,0.00,'738','2022-04-22 21:14:01','738','2022-04-22 21:14:21',10,0),('1','208',257595,'DAILY SHIFT','2022-04-23','2022-04-23 07:21:02','2022-04-24 07:21:02','738',0.00,0.00,'738','2022-04-23 20:52:31','738','2022-04-23 20:52:50',10,0),('1','208',257596,'DAILY SHIFT','2022-04-24','2022-04-24 06:53:29','2022-04-25 06:53:29','738',0.00,0.00,'738','2022-04-24 14:45:10','738','2022-04-24 14:47:51',10,0),('1','208',257597,'Daily shift','2022-04-24','2022-04-24 14:48:36','2022-04-25 14:48:36','738',0.00,0.00,'738','2022-04-24 22:38:25','738','2022-04-24 22:38:54',10,0),('1','208',257598,'DAILY SHIFT','2022-04-25','2022-04-25 07:33:26','2022-04-26 07:33:26','738',0.00,0.00,'738','2022-04-25 20:24:28','738','2022-04-25 20:24:49',10,0),('1','208',257599,'Daily shift','2022-04-26','2022-04-26 09:30:16','2022-04-27 09:30:16','738',0.00,0.00,'738','2022-04-26 15:19:26','738','2022-04-26 15:19:54',10,0),('1','208',257600,'Daily shift','2022-04-26','2022-04-26 15:47:44','2022-04-27 15:47:44','738',0.00,0.00,'738','2022-04-26 20:26:42','738','2022-04-26 20:27:03',10,0),('1','208',257601,'DAILY SHIFT','2022-04-27','2022-04-27 07:13:12','2022-04-28 07:13:12','738',0.00,0.00,'738','2022-04-27 22:07:20','738','2022-04-27 22:07:44',10,0),('1','208',257602,'Daily shift','2022-04-28','2022-04-28 09:44:10','2022-04-29 09:44:10','738',0.00,0.00,'738','2022-04-28 21:58:37','738','2022-04-28 21:58:57',10,0),('1','208',257603,'DAILY SHIFT','2022-04-29','2022-04-29 07:35:01','2022-04-30 07:35:01','738',0.00,0.00,'738','2022-04-29 16:11:20','738','2022-04-29 16:11:45',10,0),('1','208',257604,'DAILY SHIFT','2022-04-29','2022-04-29 16:35:28','2022-04-30 16:35:28','738',0.00,0.00,'738','2022-04-29 22:16:22','738','2022-04-29 22:16:46',10,0),('1','208',257605,'DAILY SHIFT','2022-04-30','2022-04-30 09:45:42','2022-05-01 09:45:42','738',0.00,0.00,'738','2022-04-30 23:54:25','738','2022-04-30 23:54:45',10,0),('1','208',257606,'DAILY SHIFT','2022-05-01','2022-05-01 07:08:18','2022-05-02 07:08:18','738',0.00,0.00,'738','2022-05-02 03:34:52','738','2022-05-02 03:35:12',10,0),('1','208',257607,'DAILY SHIFT','2022-05-02','2022-05-02 09:34:37','2022-05-03 09:34:37','738',0.00,0.00,'738','2022-05-02 21:16:44','738','2022-05-02 21:17:09',10,0),('1','208',257608,'Daily shift','2022-05-03','2022-05-03 12:55:04','2022-05-04 12:55:04','738',0.00,0.00,'738','2022-05-03 21:44:57','738','2022-05-03 21:45:15',10,0),('1','208',257609,'DAILY SHIFT','2022-05-04','2022-05-04 06:57:07','2022-05-05 06:57:07','738',0.00,0.00,'738','2022-05-04 20:50:42','738','2022-05-04 20:51:32',10,0),('1','208',257610,'DAILY SHIFT','2022-05-05','2022-05-05 09:53:17','2022-05-06 09:53:17','738',0.00,0.00,'738','2022-05-05 21:30:44','738','2022-05-05 21:31:04',10,0),('1','208',257611,'DAILY SHIFT','2022-05-06','2022-05-06 06:57:48','2022-05-07 06:57:48','738',0.00,0.00,'738','2022-05-06 21:11:03','738','2022-05-06 21:11:23',10,0),('1','208',257612,'Daily shift','2022-05-07','2022-05-07 14:35:34','2022-05-08 14:35:34','738',0.00,0.00,'738','2022-05-07 14:44:04','738','2022-05-07 14:45:08',10,0),('1','208',257613,'Daily shift','2022-05-07','2022-05-07 14:45:55','2022-05-08 14:45:55','738',0.00,0.00,'738','2022-05-07 22:32:58','738','2022-05-07 22:33:19',10,0),('1','208',257614,'DAILY SHIFT','2022-05-08','2022-05-08 09:36:00','2022-05-09 09:36:00','738',0.00,0.00,'738','2022-05-08 21:29:01','738','2022-05-08 21:29:25',10,0),('1','208',257615,'DAILY SHIFT','2022-05-09','2022-05-09 07:07:47','2022-05-10 07:07:47','738',0.00,0.00,'738','2022-05-09 22:43:21','738','2022-05-09 22:43:44',10,0),('1','208',257616,'DAILY SHIFT','2022-05-10','2022-05-10 07:29:58','2022-05-11 07:29:58','738',0.00,0.00,'738','2022-05-10 21:30:45','738','2022-05-10 21:31:07',10,0),('1','208',257617,'DAILY SHIFT','2022-05-11','2022-05-11 07:19:06','2022-05-12 07:19:06','738',0.00,0.00,'738','2022-05-11 22:37:37','738','2022-05-11 22:38:02',10,0),('1','208',257618,'DAILY SHIFT','2022-05-12','2022-05-12 06:49:30','2022-05-13 06:49:30','738',0.00,0.00,'738','2022-05-12 22:37:15','738','2022-05-12 22:37:35',10,0),('1','208',257619,'DAILY SHIFT','2022-05-13','2022-05-13 07:10:09','2022-05-14 07:10:09','738',0.00,0.00,'738','2022-05-13 23:31:34','738','2022-05-13 23:32:00',10,0),('1','208',257620,'DAILY SHIFT','2022-05-14','2022-05-14 07:18:50','2022-05-15 07:18:50','738',0.00,0.00,'738','2022-05-14 22:49:11','738','2022-05-14 22:49:36',10,0),('1','208',257621,'DAILY SHIFT','2022-05-15','2022-05-15 07:23:02','2022-05-16 07:23:02','738',0.00,0.00,'738','2022-05-15 21:50:42','738','2022-05-15 21:51:01',10,0),('1','208',257622,'DAILY SHIFT','2022-05-16','2022-05-16 12:29:00','2022-05-17 12:29:00','738',0.00,0.00,'738','2022-05-17 06:45:30','738','2022-05-17 06:45:53',10,0),('1','208',257623,'DAILY SHIFT','2022-05-17','2022-05-17 07:51:21','2022-05-18 07:51:21','738',0.00,0.00,'738','2022-05-17 17:28:21','738','2022-05-17 17:28:39',10,0),('1','208',257624,'Daily shift','2022-05-17','2022-05-17 17:29:19','2022-05-18 17:29:19','738',0.00,0.00,'738','2022-05-17 22:27:32','738','2022-05-17 22:27:56',10,0),('1','208',257625,'DAILY SHIFT','2022-05-18','2022-05-18 07:00:38','2022-05-19 07:00:38','738',0.00,0.00,'738','2022-05-18 19:23:12','738','2022-05-18 19:23:59',10,0),('1','208',257626,'DAILY SHIFT','2022-05-19','2022-05-19 07:14:03','2022-05-20 07:14:03','738',0.00,0.00,'738','2022-05-19 10:22:28','738','2022-05-19 10:23:20',10,0),('1','208',257627,'Daily shift','2022-05-19','2022-05-19 10:24:50','2022-05-20 10:24:50','738',0.00,0.00,'738','2022-05-19 21:10:22','738','2022-05-19 21:10:47',10,0),('1','208',257628,'DAILY SHIFT','2022-05-20','2022-05-20 08:32:44','2022-05-21 08:32:44','738',0.00,0.00,'738','2022-05-20 21:34:19','738','2022-05-20 21:34:37',10,0),('1','208',257629,'Daily shift','2022-05-21','2022-05-21 08:55:59','2022-05-22 08:55:59','738',0.00,0.00,'738','2022-05-21 12:09:05','738','2022-05-21 12:09:57',10,0),('1','208',257630,'Daily shift','2022-05-21','2022-05-21 12:11:59','2022-05-22 12:11:59','738',0.00,0.00,'738','2022-05-21 21:27:44','738','2022-05-21 21:28:08',10,0),('1','208',257631,'DAILY SHIFT','2022-05-22','2022-05-22 07:23:47','2022-05-23 07:23:47','738',0.00,0.00,'738','2022-05-22 12:41:53','738','2022-05-22 12:42:14',10,0),('1','208',257632,'Daily shift','2022-05-22','2022-05-22 12:42:50','2022-05-23 12:42:50','738',0.00,0.00,'738','2022-05-22 21:15:55','738','2022-05-22 21:16:19',10,0),('1','208',257633,'DAILY SHIFT','2022-05-23','2022-05-23 07:29:02','2022-05-24 07:29:02','738',0.00,0.00,'738','2022-05-23 21:54:51','738','2022-05-23 21:55:14',10,0),('1','208',257634,'DAILY SHIFT','2022-05-24','2022-05-24 07:20:48','2022-05-25 07:20:48','738',0.00,0.00,'738','2022-05-24 22:19:46','738','2022-05-24 22:20:06',10,0),('1','208',257635,'Daily shift','2022-05-25','2022-05-25 06:02:03','2022-05-26 06:02:03','738',0.00,0.00,'738','2022-05-25 11:32:13','738','2022-05-25 11:32:56',10,0),('1','208',257636,'Daily shift','2022-05-25','2022-05-25 11:33:46','2022-05-26 11:33:46','738',0.00,0.00,'738','2022-05-25 22:42:04','738','2022-05-25 22:42:24',10,0),('1','208',257637,'Daily shift','2022-05-26','2022-05-26 08:00:47','2022-05-27 08:00:47','738',0.00,0.00,'738','2022-05-26 21:24:16','738','2022-05-26 21:24:42',10,0),('1','208',257638,'DAILY SHIFT','2022-05-27','2022-05-27 07:28:45','2022-05-28 07:28:45','738',0.00,0.00,'738','2022-05-28 10:50:47','738','2022-05-28 10:51:29',10,0),('1','208',257639,'DAILY SHIFT','2022-05-28','2022-05-28 10:52:06','2022-05-29 10:52:06','738',0.00,0.00,'738','2022-05-28 17:18:31','738','2022-05-28 17:18:56',10,0),('1','208',257640,'Daily shift','2022-05-28','2022-05-28 17:19:25','2022-05-29 17:19:25','738',0.00,0.00,'738','2022-05-28 19:09:17','738','2022-05-28 19:09:41',10,0),('1','208',257641,'Daily shift','2022-05-29','2022-05-29 06:01:26','2022-05-30 06:01:26','738',0.00,0.00,'738','2022-05-29 22:17:31','738','2022-05-29 22:17:59',10,0),('1','208',257642,'DAILY SHIFT','2022-05-30','2022-05-30 07:44:42','2022-05-31 07:44:42','738',0.00,0.00,'738','2022-05-30 11:28:54','738','2022-05-30 11:30:22',10,0),('1','208',257643,'Daily shift','2022-05-30','2022-05-30 13:34:21','2022-05-31 13:34:21','738',0.00,0.00,'738','2022-05-30 19:29:37','738','2022-05-30 19:31:01',10,0),('1','208',257644,'DAILY SHIFT','2022-05-31','2022-05-31 07:24:30','2022-06-01 07:24:30','738',0.00,0.00,'738','2022-05-31 22:10:44','738','2022-05-31 22:11:04',10,0),('1','208',257645,'DAILY SHIFT','2022-06-01','2022-06-01 06:44:57','2022-06-02 06:44:57','738',0.00,0.00,'738','2022-06-01 21:56:03','738','2022-06-01 21:56:25',10,0),('1','208',257646,'DAILY SHIFT','2022-06-02','2022-06-02 07:16:28','2022-06-03 07:16:28','738',0.00,0.00,'738','2022-06-02 11:34:09','738','2022-06-02 11:34:33',10,0),('1','208',257647,'Daily shift','2022-06-02','2022-06-02 11:35:07','2022-06-03 11:35:07','738',0.00,0.00,'738','2022-06-02 23:00:14','738','2022-06-02 23:00:47',10,0),('1','208',257648,'DAILY SHIFT','2022-06-03','2022-06-03 06:58:14','2022-06-04 06:58:14','738',0.00,0.00,'738','2022-06-03 22:14:03','738','2022-06-03 22:14:35',10,0),('1','208',257649,'DAILY SHIFT','2022-06-04','2022-06-04 07:21:44','2022-06-05 07:21:44','738',0.00,0.00,'738','2022-06-05 08:14:46','738','2022-06-05 08:15:13',10,0),('1','208',257650,'Daily shift','2022-06-05','2022-06-05 08:15:42','2022-06-06 08:15:42','738',0.00,0.00,'738','2022-06-05 20:11:28','738','2022-06-05 20:11:56',10,0),('1','208',257651,'Daily shift','2022-06-06','2022-06-06 07:09:00','2022-06-07 07:09:00','738',0.00,0.00,'738','2022-06-06 21:18:25','738','2022-06-06 21:18:50',10,0),('1','208',257652,'DAILY SHIFT','2022-06-07','2022-06-07 07:32:08','2022-06-08 07:32:08','738',0.00,0.00,'738','2022-06-07 22:52:55','738','2022-06-07 22:53:22',10,0),('1','208',257653,'DAILY SHIFT','2022-06-08','2022-06-08 07:28:18','2022-06-09 07:28:18','738',0.00,0.00,'738','2022-06-08 13:53:03','738','2022-06-08 13:53:21',10,0),('1','208',257654,'Daily shift','2022-06-08','2022-06-08 13:53:55','2022-06-09 13:53:55','738',0.00,0.00,'738','2022-06-08 21:59:06','738','2022-06-08 21:59:37',10,0),('1','208',257655,'DAILY SHIFT','2022-06-09','2022-06-09 07:37:44','2022-06-10 07:37:44','738',0.00,0.00,'738','2022-06-09 22:04:10','738','2022-06-09 22:04:40',10,0),('1','208',257656,'DAILY SHIFT','2022-06-10','2022-06-10 07:36:10','2022-06-11 07:36:10','738',0.00,0.00,'738','2022-06-10 22:20:00','738','2022-06-10 22:20:28',10,0),('1','208',257657,'DAILY SHIFT','2022-06-11','2022-06-11 06:53:08','2022-06-12 06:53:08','738',0.00,0.00,'738','2022-06-11 13:34:48','738','2022-06-11 13:35:23',10,0),('1','208',257658,'Daily shift','2022-06-11','2022-06-11 13:37:31','2022-06-12 13:37:31','738',0.00,0.00,'738','2022-06-11 22:45:13','738','2022-06-11 22:45:36',10,0),('1','208',257659,'Daily shift','2022-06-12','2022-06-12 11:07:07','2022-06-13 11:07:07','738',0.00,0.00,'738','2022-06-12 22:44:22','738','2022-06-12 22:44:44',10,0),('1','208',257660,'Daily shift','2022-06-13','2022-06-13 08:09:09','2022-06-14 08:09:09','738',0.00,0.00,'738','2022-06-13 22:05:28','738','2022-06-13 22:09:19',10,0),('1','208',257661,'DAILY SHIFT','2022-06-14','2022-06-14 08:51:46','2022-06-15 08:51:46','738',0.00,0.00,'738','2022-06-14 22:09:42','738','2022-06-14 22:10:02',10,0),('1','208',257662,'DAILY SHIFT','2022-06-15','2022-06-15 09:10:02','2022-06-16 09:10:02','738',0.00,0.00,'738','2022-06-15 19:08:00','738','2022-06-15 19:08:29',10,0),('1','208',257663,'DAILY SHIFT','2022-06-16','2022-06-16 07:46:41','2022-06-17 07:46:41','738',0.00,0.00,'738','2022-06-16 19:53:32','738','2022-06-16 19:54:05',10,0),('1','208',257664,'DAILY SHIFT','2022-06-17','2022-06-17 08:38:25','2022-06-18 08:38:25','738',0.00,0.00,'738','2022-06-17 19:44:51','738','2022-06-17 19:45:28',10,0),('1','208',257665,'DAILY SHIFT','2022-06-18','2022-06-18 07:32:59','2022-06-19 07:32:59','738',0.00,0.00,'738','2022-06-18 19:22:52','738','2022-06-18 19:23:13',10,0),('1','208',257666,'DAILY SHIFT','2022-06-19','2022-06-19 07:33:01','2022-06-20 07:33:01','738',0.00,0.00,'738','2022-06-19 22:27:28','738','2022-06-19 22:30:31',10,0),('1','208',257667,'Daily shift','2022-06-20','2022-06-20 10:52:03','2022-06-21 10:52:03','738',0.00,0.00,'738','2022-06-20 20:58:52','738','2022-06-20 20:59:21',10,0),('1','208',257668,'DAILY SHIFT','2022-06-21','2022-06-21 09:11:40','2022-06-22 09:11:40','738',0.00,0.00,'738','2022-06-21 22:52:55','738','2022-06-21 22:53:19',10,0),('1','208',257669,'DAILY SHIFT','2022-06-22','2022-06-22 08:20:58','2022-06-23 08:20:58','738',0.00,0.00,'738','2022-06-22 11:28:02','738','2022-06-22 11:28:24',10,0),('1','208',257670,'Daily shift','2022-06-22','2022-06-22 11:29:01','2022-06-23 11:29:01','738',0.00,0.00,'738','2022-06-22 21:40:25','738','2022-06-22 21:40:54',10,0),('1','208',257671,'DAILY SHIFT','2022-06-23','2022-06-23 06:50:42','2022-06-24 06:50:42','738',0.00,0.00,'738','2022-06-23 21:24:39','738','2022-06-23 21:25:08',10,0),('1','208',257672,'DAILY SHIFT','2022-06-24','2022-06-24 07:37:31','2022-06-25 07:37:31','738',0.00,0.00,'738','2022-06-24 21:37:06','738','2022-06-24 21:37:30',10,0),('1','208',257673,'DAILY SHIFT','2022-06-25','2022-06-25 10:02:29','2022-06-26 10:02:29','738',0.00,0.00,'738','2022-06-25 16:15:53','738','2022-06-25 16:16:36',10,0),('1','208',257674,'DAILY SHIFT','2022-06-25','2022-06-25 16:18:04','2022-06-26 16:18:04','738',0.00,0.00,'738','2022-06-25 21:21:07','738','2022-06-25 21:21:27',10,0),('1','208',257675,'DAILY SHIFT','2022-06-26','2022-06-26 11:34:45','2022-06-27 11:34:45','738',0.00,0.00,'738','2022-06-26 19:12:05','738','2022-06-26 19:12:34',10,0),('1','208',257676,'DAILY SHIFT','2022-06-27','2022-06-27 07:53:01','2022-06-28 07:53:01','738',0.00,0.00,'738','2022-06-27 21:52:22','738','2022-06-27 21:52:51',10,0),('1','208',257677,'DAILY SHIFT','2022-06-28','2022-06-28 08:10:05','2022-06-29 08:10:05','738',0.00,0.00,'738','2022-06-28 13:28:02','738','2022-06-28 13:28:25',10,0),('1','208',257678,'DAILY SHIFT','2022-06-28','2022-06-28 13:28:56','2022-06-29 13:28:56','738',0.00,0.00,'738','2022-06-28 20:53:42','738','2022-06-28 20:54:02',10,0),('1','208',257679,'DAILY SHIFT','2022-06-29','2022-06-29 07:20:24','2022-06-30 07:20:24','738',0.00,0.00,'738','2022-06-29 23:06:58','738','2022-06-29 23:07:24',10,0),('1','208',257680,'Daily shift','2022-06-30','2022-06-30 08:30:07','2022-07-01 08:30:07','738',0.00,0.00,'738','2022-06-30 21:10:22','738','2022-06-30 21:12:34',10,0),('1','208',257681,'Daily shift','2022-07-01','2022-07-01 07:20:32','2022-07-02 07:20:32','738',0.00,0.00,'738','2022-07-01 21:11:29','738','2022-07-01 21:11:53',10,0),('1','208',257682,'Daily shift','2022-07-02','2022-07-02 07:26:05','2022-07-03 07:26:05','738',0.00,0.00,'738','2022-07-02 12:33:12','738','2022-07-02 12:43:02',10,0),('1','208',257683,'Daily shift','2022-07-02','2022-07-02 12:44:00','2022-07-03 12:44:00','738',0.00,0.00,'738','2022-07-02 23:11:23','738','2022-07-02 23:11:48',10,0),('1','208',257684,'Daily shift','2022-07-03','2022-07-03 07:13:42','2022-07-04 07:13:42','738',0.00,0.00,'738','2022-07-03 21:17:17','738','2022-07-03 21:17:47',10,0),('1','208',257685,'Daily shift','2022-07-04','2022-07-04 07:37:10','2022-07-05 07:37:10','738',0.00,0.00,'738','2022-07-04 21:45:25','738','2022-07-04 21:45:51',10,0),('1','208',257686,'Daily shift','2022-07-05','2022-07-05 07:06:25','2022-07-06 07:06:25','738',0.00,0.00,'738','2022-07-05 22:24:28','738','2022-07-05 22:24:57',10,0),('1','208',257687,'Daily shift','2022-07-06','2022-07-06 07:27:18','2022-07-07 07:27:18','738',0.00,0.00,'738','2022-07-06 11:11:05','738','2022-07-06 11:11:27',10,0),('1','208',257688,'Daily shift','2022-07-06','2022-07-06 11:11:52','2022-07-07 11:11:52','738',0.00,0.00,'738','2022-07-06 22:11:00','738','2022-07-06 22:11:28',10,0),('1','208',257689,'Daily shift','2022-07-07','2022-07-07 07:07:09','2022-07-08 07:07:09','738',0.00,0.00,'738','2022-07-07 21:07:57','738','2022-07-07 21:09:12',10,0),('1','208',257690,'Daily shift','2022-07-08','2022-07-08 06:49:58','2022-07-09 06:49:58','738',0.00,0.00,'738','2022-07-08 14:16:38','738','2022-07-08 14:16:59',10,0),('1','208',257691,'Daily shift','2022-07-08','2022-07-08 14:17:31','2022-07-09 14:17:31','738',0.00,0.00,'738','2022-07-08 23:12:19','738','2022-07-08 23:12:42',10,0),('1','208',257692,'Daily shift','2022-07-09','2022-07-09 09:09:43','2022-07-10 09:09:43','738',0.00,0.00,'738','2022-07-09 22:54:54','738','2022-07-09 22:55:17',10,0),('1','208',257693,'Daily shift','2022-07-10','2022-07-10 08:39:40','2022-07-11 08:39:40','738',0.00,0.00,'738','2022-07-10 22:54:48','738','2022-07-10 22:55:12',10,0),('1','208',257694,'Daily shift','2022-07-11','2022-07-11 08:37:42','2022-07-12 08:37:42','738',0.00,0.00,'738','2022-07-11 12:36:22','738','2022-07-11 12:36:43',10,0),('1','208',257695,'Daily shift','2022-07-11','2022-07-11 12:37:11','2022-07-12 12:37:11','738',0.00,0.00,'738','2022-07-11 23:25:27','738','2022-07-11 23:25:54',10,0),('1','208',257696,'DAILY SHIFTS','2022-07-12','2022-07-12 07:45:59','2022-07-13 07:45:59','738',0.00,0.00,'738','2022-07-12 23:16:58','738','2022-07-12 23:18:32',10,0),('1','208',257697,'DAILY SHIFTS','2022-07-13','2022-07-13 07:30:09','2022-07-14 07:30:09','738',0.00,0.00,'738','2022-07-13 23:01:35','738','2022-07-13 23:01:57',10,0),('1','208',257698,'DAILY SHIFTS','2022-07-14','2022-07-14 07:33:41','2022-07-15 07:33:41','738',0.00,0.00,'738','2022-07-14 15:46:28','738','2022-07-14 15:46:49',10,0),('1','208',257699,'Daily shift','2022-07-14','2022-07-14 15:48:09','2022-07-15 15:48:09','738',0.00,0.00,'738','2022-07-14 21:19:07','738','2022-07-14 21:19:29',10,0),('1','208',257700,'DAILY SHIFTS','2022-07-15','2022-07-15 08:13:48','2022-07-16 08:13:48','738',0.00,0.00,'738','2022-07-15 22:36:37','738','2022-07-15 22:36:55',10,0),('1','208',257701,'DAILY SHIFTS','2022-07-16','2022-07-16 07:31:21','2022-07-17 07:31:21','738',0.00,0.00,'738','2022-07-16 22:39:00','738','2022-07-16 22:39:32',10,0),('1','208',257702,'Daily shift','2022-07-17','2022-07-17 08:22:50','2022-07-18 08:22:50','738',0.00,0.00,'738','2022-07-17 14:34:48','738','2022-07-17 14:35:12',10,0),('1','208',257703,'Daily shift','2022-07-17','2022-07-17 14:35:43','2022-07-18 14:35:43','738',0.00,0.00,'738','2022-07-17 22:02:05','738','2022-07-17 22:02:30',10,0),('1','208',257704,'Daily shift','2022-07-18','2022-07-18 07:47:33','2022-07-19 07:47:33','738',0.00,0.00,'738','2022-07-18 21:22:44','738','2022-07-18 21:23:09',10,0),('1','208',257705,'Daily shift','2022-07-19','2022-07-19 09:41:51','2022-07-20 09:41:51','738',0.00,0.00,'738','2022-07-19 19:03:41','738','2022-07-19 19:04:01',10,0),('1','208',257706,'DAILY SHIFTS','2022-07-20','2022-07-20 06:54:32','2022-07-21 06:54:32','738',0.00,0.00,'738','2022-07-20 13:50:35','738','2022-07-20 14:45:06',10,0),('1','208',257707,'Daily shift','2022-07-20','2022-07-20 16:49:11','2022-07-21 16:49:11','738',0.00,0.00,'738','2022-07-20 16:55:44','738','2022-07-20 16:56:41',10,0),('1','208',257708,'Daily shift','2022-07-20','2022-07-20 16:57:07','2022-07-21 16:57:07','738',0.00,0.00,'738','2022-07-20 23:34:51','738','2022-07-20 23:35:17',10,0),('1','208',257709,'DAILY SHIFTS','2022-07-21','2022-07-21 07:38:48','2022-07-22 07:38:48','738',0.00,0.00,'738','2022-07-21 20:11:52','738','2022-07-21 20:12:14',10,0),('1','208',257710,'DAILY SHIFTS','2022-07-22','2022-07-22 07:12:56','2022-07-23 07:12:56','738',0.00,0.00,'738','2022-07-22 21:50:32','738','2022-07-22 21:51:05',10,0),('1','208',257711,'DAILY SHIFTS','2022-07-23','2022-07-23 07:25:57','2022-07-24 07:25:57','738',0.00,0.00,'738','2022-07-23 14:23:46','738','2022-07-23 14:24:06',10,0),('1','208',257712,'DAILY SHIFTS','2022-07-23','2022-07-23 14:24:30','2022-07-24 14:24:30','738',0.00,0.00,'738','2022-07-23 20:59:41','738','2022-07-23 21:00:01',10,0),('1','208',257713,'DAILY SHIFTS','2022-07-24','2022-07-24 07:19:40','2022-07-25 07:19:40','738',0.00,0.00,'738','2022-07-24 20:57:40','738','2022-07-24 20:58:03',10,0),('1','208',257714,'DAILY SHIFTS','2022-07-25','2022-07-25 07:16:28','2022-07-26 07:16:28','738',0.00,0.00,'738','2022-07-25 21:11:48','738','2022-07-25 21:12:16',10,0),('1','208',257715,'DAILY SHIFTS','2022-07-26','2022-07-26 06:53:36','2022-07-27 06:53:36','738',0.00,0.00,'738','2022-07-26 17:32:45','738','2022-07-26 17:33:29',10,0),('1','208',257716,'Daily shift','2022-07-26','2022-07-26 17:34:31','2022-07-27 17:34:31','738',0.00,0.00,'738','2022-07-26 21:21:21','738','2022-07-26 21:21:48',10,0),('1','208',257717,'DAILY SHIFTS','2022-07-27','2022-07-27 07:20:02','2022-07-28 07:20:02','738',0.00,0.00,'738','2022-07-27 16:55:11','738','2022-07-27 16:55:32',10,0),('1','208',257718,'Daily shift','2022-07-27','2022-07-27 16:55:58','2022-07-28 16:55:58','738',0.00,0.00,'738','2022-07-27 22:10:36','738','2022-07-27 22:11:41',10,0),('1','208',257719,'DAILY SHIFTS','2022-07-28','2022-07-28 07:01:10','2022-07-29 07:01:10','738',0.00,0.00,'738','2022-07-28 22:04:57','738','2022-07-28 22:07:52',10,0),('1','208',257720,'DAILY SHIFTS','2022-07-29','2022-07-29 07:04:02','2022-07-30 07:04:02','738',0.00,0.00,'738','2022-07-29 22:54:53','738','2022-07-29 22:55:19',10,0),('1','208',257721,'DAILY SHIFTS','2022-07-30','2022-07-30 10:10:09','2022-07-31 10:10:09','738',0.00,0.00,'738','2022-07-30 15:25:35','738','2022-07-30 15:25:59',10,0),('1','208',257722,'Daily shift','2022-07-30','2022-07-30 15:26:37','2022-07-31 15:26:37','738',0.00,0.00,'738','2022-07-30 22:30:25','738','2022-07-30 22:30:55',10,0),('1','208',257723,'DAILY SHIFTS','2022-07-31','2022-07-31 07:11:15','2022-08-01 07:11:15','738',0.00,0.00,'738','2022-07-31 22:17:34','738','2022-07-31 22:17:59',10,0),('1','208',257724,'DAILY SHIFTS','2022-08-01','2022-08-01 07:03:17','2022-08-02 07:03:17','738',0.00,0.00,'738','2022-08-01 18:31:56','738','2022-08-01 18:32:20',10,0),('1','208',257725,'Daily shift','2022-08-01','2022-08-01 18:32:58','2022-08-02 18:32:58','738',0.00,0.00,'738','2022-08-01 19:31:16','738','2022-08-01 19:31:35',10,0),('1','208',257726,'DAILY SHIFTS','2022-08-02','2022-08-02 07:16:07','2022-08-03 07:16:07','738',0.00,0.00,'738','2022-08-02 21:05:22','738','2022-08-02 21:05:59',10,0),('1','208',257727,'DAILY SHIFTS','2022-08-03','2022-08-03 07:05:21','2022-08-04 07:05:21','738',0.00,0.00,'738','2022-08-03 21:33:09','738','2022-08-03 21:33:33',10,0),('1','208',257728,'DAILY SHIFTS','2022-08-04','2022-08-04 07:07:15','2022-08-05 07:07:15','738',0.00,0.00,'738','2022-08-04 19:39:08','738','2022-08-04 19:39:31',10,0),('1','208',257729,'DAILY SHIFTS','2022-08-05','2022-08-05 07:56:36','2022-08-06 07:56:36','738',0.00,0.00,'738','2022-08-05 14:06:54','738','2022-08-05 14:07:15',10,0),('1','208',257730,'Daily shift','2022-08-05','2022-08-05 14:07:41','2022-08-06 14:07:41','738',0.00,0.00,'738','2022-08-05 19:32:09','738','2022-08-05 19:32:38',10,0),('1','208',257731,'DAILY SHIFTS','2022-08-06','2022-08-06 07:05:22','2022-08-07 07:05:22','738',0.00,0.00,'738','2022-08-06 19:25:01','738','2022-08-06 19:25:27',10,0),('1','208',257732,'DAILY SHIFTS','2022-08-07','2022-08-07 07:10:27','2022-08-08 07:10:27','738',0.00,0.00,'738','2022-08-07 15:47:54','738','2022-08-07 15:48:16',10,0),('1','208',257733,'Daily shift','2022-08-07','2022-08-07 15:49:08','2022-08-08 15:49:08','738',0.00,0.00,'738','2022-08-07 19:08:56','738','2022-08-07 19:09:17',10,0),('1','208',257734,'DAILY SHIFTS','2022-08-08','2022-08-08 07:29:10','2022-08-09 07:29:10','738',0.00,0.00,'738','2022-08-08 17:03:05','738','2022-08-08 17:03:26',10,0),('1','208',257735,'Daily shift','2022-08-08','2022-08-08 17:07:12','2022-08-09 17:07:12','738',0.00,0.00,'738','2022-08-08 21:40:29','738','2022-08-08 21:40:58',10,0),('1','208',257736,'DAILY SHIFTS','2022-08-09','2022-08-09 06:57:52','2022-08-10 06:57:52','738',0.00,0.00,'738','2022-08-09 21:48:38','738','2022-08-09 22:28:33',10,0),('1','208',257737,'DAILY SHIFTS','2022-08-10','2022-08-10 06:50:01','2022-08-11 06:50:01','738',0.00,0.00,'738','2022-08-10 21:00:12','738','2022-08-10 21:00:36',10,0),('1','208',257738,'DAILY SHIFTS','2022-08-11','2022-08-11 07:55:04','2022-08-12 07:55:04','738',0.00,0.00,'738','2022-08-11 16:37:03','738','2022-08-11 16:38:00',10,0),('1','208',257739,'DAILY SHIFTS','2022-08-11','2022-08-11 16:45:33','2022-08-12 16:45:33','738',0.00,0.00,'738','2022-08-11 19:40:44','738','2022-08-11 19:41:03',10,0),('1','208',257740,'DAILY SHIFT','2022-08-12','2022-08-12 06:56:40','2022-08-13 06:56:40','738',0.00,0.00,'738','2022-08-12 19:34:32','738','2022-08-12 19:35:14',10,0),('1','208',257741,'DAILY SHIFTS','2022-08-13','2022-08-13 06:45:23','2022-08-14 06:45:23','738',0.00,0.00,'738','2022-08-13 19:37:04','738','2022-08-13 19:38:16',10,0),('1','208',257742,'DAILY SHIFT','2022-08-14','2022-08-14 06:54:46','2022-08-15 06:54:46','738',0.00,0.00,'738','2022-08-14 11:53:17','738','2022-08-14 11:53:43',10,0),('1','208',257743,'DAILY SHIFTS','2022-08-14','2022-08-14 11:57:28','2022-08-15 11:57:28','738',0.00,0.00,'738','2022-08-14 19:58:38','738','2022-08-14 19:59:01',10,0),('1','208',257744,'DAILY SHIFTS','2022-08-15','2022-08-15 06:38:15','2022-08-16 06:38:15','738',0.00,0.00,'738','2022-08-15 19:57:38','738','2022-08-15 19:58:39',10,0),('1','208',257745,'DAILY SHIFTS','2022-08-16','2022-08-16 06:36:49','2022-08-17 06:36:49','738',0.00,0.00,'738','2022-08-16 19:38:06','738','2022-08-16 19:39:41',10,0),('1','208',257746,'DAILY SHIFTS','2022-08-17','2022-08-17 06:00:31','2022-08-18 06:00:31','738',0.00,0.00,'738','2022-08-17 09:44:58','738','2022-08-17 09:45:33',10,0),('1','208',257747,'DAILY SHIFTS','2022-08-17','2022-08-17 09:52:15','2022-08-18 09:52:15','738',0.00,0.00,'738','2022-08-17 20:56:26','738','2022-08-17 20:56:46',10,0),('1','208',257748,'DAILY SHIFTS','2022-08-18','2022-08-18 06:41:29','2022-08-19 06:41:29','738',0.00,0.00,'738','2022-08-18 19:06:28','738','2022-08-18 19:06:49',10,0),('1','208',257749,'DAILY SHIFTS','2022-08-19','2022-08-19 06:17:56','2022-08-20 06:17:56','738',0.00,0.00,'738','2022-08-19 17:02:22','738','2022-08-19 17:02:53',10,0),('1','208',257750,'DAILY SHIFTS','2022-08-19','2022-08-19 17:21:08','2022-08-20 17:21:08','738',0.00,0.00,'738','2022-08-19 19:36:41','738','2022-08-19 19:37:33',10,0),('1','208',257751,'DAILY SHIFTS','2022-08-20','2022-08-20 06:33:52','2022-08-21 06:33:52','738',0.00,0.00,'738','2022-08-20 19:28:44','738','2022-08-20 19:29:35',10,0),('1','208',257752,'DAILY SHIFTS','2022-08-21','2022-08-21 05:51:18','2022-08-22 05:51:18','738',0.00,0.00,'738','2022-08-21 20:25:23','738','2022-08-21 20:25:43',10,0),('1','208',257753,'DAILY SHIFTS','2022-08-22','2022-08-22 06:45:40','2022-08-23 06:45:40','738',0.00,0.00,'738','2022-08-22 12:45:28','738','2022-08-22 12:45:53',10,0),('1','208',257754,'DAILY SHIFTS','2022-08-22','2022-08-22 12:54:34','2022-08-23 12:54:34','738',0.00,0.00,'738','2022-08-22 21:01:59','738','2022-08-22 21:02:21',10,0),('1','208',257755,'DAILY SHIFTS','2022-08-23','2022-08-23 06:38:07','2022-08-24 06:38:07','738',0.00,0.00,'738','2022-08-23 19:37:46','738','2022-08-23 19:38:26',10,0),('1','208',257756,'DAILY SHIFTS','2022-08-24','2022-08-24 05:56:47','2022-08-25 05:56:47','738',0.00,0.00,'738','2022-08-24 19:30:02','738','2022-08-24 19:30:27',10,0),('1','208',257757,'DAILY SHIFTS','2022-08-25','2022-08-25 08:05:34','2022-08-26 08:05:34','738',0.00,0.00,'738','2022-08-25 13:36:07','738','2022-08-25 13:36:34',10,0),('1','208',257758,'DAILY SHIFTS','2022-08-25','2022-08-25 13:40:21','2022-08-26 13:40:21','738',0.00,0.00,'738','2022-08-25 19:25:13','738','2022-08-25 19:25:31',10,0),('1','208',257759,'DAILY SHIFTS','2022-08-26','2022-08-26 06:53:56','2022-08-27 06:53:56','738',0.00,0.00,'738','2022-08-26 20:58:48','738','2022-08-26 21:00:09',10,0),('1','208',257760,'DAILY SHIFTS','2022-08-27','2022-08-27 06:49:37','2022-08-28 06:49:37','738',0.00,0.00,'738','2022-08-27 20:35:27','738','2022-08-27 20:36:36',10,0),('1','208',257761,'DAILY SHIFTS','2022-08-28','2022-08-28 06:12:50','2022-08-29 06:12:50','738',0.00,0.00,'738','2022-08-28 12:04:16','738','2022-08-28 12:04:51',10,0),('1','208',257762,'DAILY SHIFTS','2022-08-28','2022-08-28 12:34:32','2022-08-29 12:34:32','738',0.00,0.00,'738','2022-08-28 21:12:53','738','2022-08-28 21:13:31',10,0),('1','208',257763,'DAILY SHIFTS','2022-08-29','2022-08-29 06:32:04','2022-08-30 06:32:04','738',0.00,0.00,'738','2022-08-29 17:33:34','738','2022-08-29 17:34:12',10,0),('1','208',257764,'DAILY SHIFTS','2022-08-29','2022-08-29 17:34:38','2022-08-30 17:34:38','738',0.00,0.00,'738','2022-08-29 21:30:32','738','2022-08-29 21:31:18',10,0),('1','208',257765,'DAILY SHIFTS','2022-08-30','2022-08-30 07:00:31','2022-08-31 07:00:31','738',0.00,0.00,'738','2022-08-30 21:02:59','738','2022-08-30 21:03:34',10,0),('1','208',257766,'DAILY SHIFTS','2022-08-31','2022-08-31 06:50:41','2022-09-01 06:50:41','738',0.00,0.00,'738','2022-08-31 18:01:35','738','2022-08-31 18:02:36',10,0),('1','208',257767,'DAILY SHIFTS','2022-08-31','2022-08-31 18:03:31','2022-09-01 18:03:31','738',0.00,0.00,'738','2022-08-31 19:45:17','738','2022-08-31 19:45:40',10,0),('1','208',257768,'DAILY SHIFTS','2022-09-01','2022-09-01 06:53:48','2022-09-02 06:53:48','738',0.00,0.00,'738','2022-09-01 21:37:16','738','2022-09-01 21:37:35',10,0),('1','208',257769,'DAILY SHIFTS','2022-09-02','2022-09-02 07:00:10','2022-09-03 07:00:10','738',0.00,0.00,'738','2022-09-02 19:48:14','738','2022-09-02 19:49:25',10,0),('1','208',257770,'DAILY SHIFTS','2022-09-03','2022-09-03 07:07:11','2022-09-04 07:07:11','738',0.00,0.00,'738','2022-09-03 21:07:35','738','2022-09-03 21:08:04',10,0),('1','208',257771,'DAILY SHIFTS','2022-09-04','2022-09-04 06:42:46','2022-09-05 06:42:46','738',0.00,0.00,'738','2022-09-04 21:11:11','738','2022-09-04 21:11:32',10,0),('1','208',257772,'DAILY SHIFTS','2022-09-05','2022-09-05 09:24:37','2022-09-06 09:24:37','738',0.00,0.00,'738','2022-09-05 19:39:14','738','2022-09-05 19:39:34',10,0),('1','208',257773,'DAILY SHIFTS','2022-09-06','2022-09-06 07:03:32','2022-09-07 07:03:32','738',0.00,0.00,'738','2022-09-06 19:56:02','738','2022-09-06 19:56:42',10,0),('1','208',257774,'DAILY SHIFT','2022-09-07','2022-09-07 06:52:52','2022-09-08 06:52:52','738',0.00,0.00,'738','2022-09-07 11:06:52','738','2022-09-07 11:07:18',10,0),('1','208',257775,'DAILY SHIFTS','2022-09-07','2022-09-07 11:12:28','2022-09-08 11:12:28','738',0.00,0.00,'738','2022-09-07 19:27:29','738','2022-09-07 19:27:56',10,0),('1','208',257776,'DAILY SHIFTS','2022-09-08','2022-09-08 06:37:13','2022-09-09 06:37:13','738',0.00,0.00,'738','2022-09-08 19:35:54','738','2022-09-08 19:36:28',10,0),('1','208',257777,'DAILY SHIFTS','2022-09-09','2022-09-09 06:50:40','2022-09-10 06:50:40','738',0.00,0.00,'738','2022-09-09 13:55:13','738','2022-09-09 16:59:41',10,0),('1','208',257778,'DAILY SHIFTS','2022-09-10','2022-09-10 12:04:43','2022-09-11 12:04:43','738',0.00,0.00,'738','2022-09-10 22:35:10','738','2022-09-10 22:38:05',10,0),('1','208',257779,'DAILY SHIFTS','2022-09-11','2022-09-11 06:48:08','2022-09-12 06:48:08','738',0.00,0.00,'738','2022-09-11 21:01:32','738','2022-09-11 21:02:20',10,0),('1','208',257780,'DAILY SHIFTS','2022-09-12','2022-09-12 07:09:42','2022-09-13 07:09:42','738',0.00,0.00,'738','2022-09-12 18:39:37','738','2022-09-12 18:39:58',10,0),('1','208',257781,'DAILY SHIFTS','2022-09-13','2022-09-13 13:42:35','2022-09-14 13:42:35','738',0.00,0.00,'738','2022-09-13 19:58:26','738','2022-09-13 19:59:05',10,0),('1','208',257782,'DAILY SHIFTS','2022-09-14','2022-09-14 06:48:04','2022-09-15 06:48:04','738',0.00,0.00,'738','2022-09-14 20:01:53','738','2022-09-14 20:03:30',10,0),('1','208',257783,'DAILY SHIFTS','2022-09-15','2022-09-15 06:48:02','2022-09-16 06:48:02','738',0.00,0.00,'738','2022-09-15 19:11:19','738','2022-09-15 19:11:40',10,0),('1','208',257784,'DAILY SHIFTS','2022-09-16','2022-09-16 06:40:10','2022-09-17 06:40:10','738',0.00,0.00,'738','2022-09-16 21:06:22','738','2022-09-16 21:07:01',10,0),('1','208',257785,'DAILY SHIFTS','2022-09-17','2022-09-17 06:39:41','2022-09-18 06:39:41','738',0.00,0.00,'738','2022-09-17 21:12:27','738','2022-09-17 21:12:50',10,0),('1','208',257786,'DAILY SHIFTS','2022-09-18','2022-09-18 06:50:10','2022-09-19 06:50:10','738',0.00,0.00,'738','2022-09-18 13:28:09','738','2022-09-18 13:28:38',10,0),('1','208',257787,'DAILY SHIFTS','2022-09-18','2022-09-18 13:29:16','2022-09-19 13:29:16','738',0.00,0.00,'738','2022-09-18 22:36:04','738','2022-09-18 22:36:24',10,0),('1','208',257788,'DAILY SHIFTS','2022-09-20','2022-09-20 12:08:29','2022-09-21 12:08:29','738',0.00,0.00,'738','2022-09-20 19:17:42','738','2022-09-20 19:18:14',10,0),('1','208',257789,'DAILY SHIFTS','2022-09-21','2022-09-21 06:42:30','2022-09-22 06:42:30','738',0.00,0.00,'738','2022-09-21 19:14:09','738','2022-09-21 19:15:12',10,0),('1','208',257790,'DAILY SHIFTS','2022-09-22','2022-09-22 06:49:11','2022-09-23 06:49:11','738',0.00,0.00,'738','2022-09-22 16:13:23','738','2022-09-22 16:13:54',10,0),('1','208',257791,'DAILY SHIFTS','2022-09-22','2022-09-22 16:14:26','2022-09-23 16:14:26','738',0.00,0.00,'738','2022-09-22 19:40:18','738','2022-09-22 19:40:52',10,0),('1','208',257792,'DAILY SHIFTS','2022-09-23','2022-09-23 06:03:50','2022-09-24 06:03:50','738',0.00,0.00,'738','2022-09-23 19:18:45','738','2022-09-23 19:19:16',10,0),('1','208',257793,'DAILY SHIFTS','2022-09-24','2022-09-24 07:49:49','2022-09-25 07:49:49','738',0.00,0.00,'738','2022-09-24 22:27:04','738','2022-09-24 22:27:28',10,0),('1','208',257794,'DAILY SHIFTS','2022-09-25','2022-09-25 06:50:32','2022-09-26 06:50:32','738',0.00,0.00,'738','2022-09-25 12:42:11','738','2022-09-25 12:46:43',10,0),('1','208',257795,'DAILY SHIFT','2022-09-25','2022-09-25 15:03:23','2022-09-26 15:03:23','738',0.00,0.00,'738','2022-09-25 20:53:47','738','2022-09-25 20:54:58',10,0),('1','208',257796,'DAILY SHIFTS','2022-09-26','2022-09-26 06:44:19','2022-09-27 06:44:19','738',0.00,0.00,'738','2022-09-26 19:45:28','738','2022-09-26 19:46:45',10,0),('1','208',257797,'DAILY SHIFTS','2022-09-27','2022-09-27 06:41:31','2022-09-28 06:41:31','738',0.00,0.00,'738','2022-09-27 19:31:30','738','2022-09-27 19:32:04',10,0),('1','208',257798,'DAILY SHIFTS','2022-09-28','2022-09-28 07:19:11','2022-09-29 07:19:11','738',0.00,0.00,'738','2022-09-28 20:02:47','738','2022-09-28 20:03:17',10,0),('1','208',257799,'DAILY SHIFTS','2022-09-29','2022-09-29 06:45:18','2022-09-30 06:45:18','738',0.00,0.00,'738','2022-09-29 19:18:01','738','2022-09-29 19:18:22',10,0),('1','208',257800,'DAILY SHIFTS','2022-09-30','2022-09-30 06:49:47','2022-10-01 06:49:47','738',0.00,0.00,'738','2022-09-30 10:49:07','738','2022-09-30 10:49:32',10,0),('1','208',257801,'DAILY SHIFTS','2022-09-30','2022-09-30 10:53:19','2022-10-01 10:53:19','738',0.00,0.00,'738','2022-09-30 19:51:41','738','2022-09-30 19:52:35',10,0),('1','208',257802,'DAILY SHIFTS','2022-10-01','2022-10-01 06:26:16','2022-10-02 06:26:16','738',0.00,0.00,'738','2022-10-01 22:12:23','738','2022-10-01 22:12:44',10,0),('1','208',257803,'DAILY SHIFTS','2022-10-02','2022-10-02 11:33:26','2022-10-03 11:33:26','738',0.00,0.00,'738','2022-10-02 19:02:05','738','2022-10-02 19:02:28',10,0),('1','208',257804,'DAILY SHIFTS','2022-10-03','2022-10-03 06:45:42','2022-10-04 06:45:42','738',0.00,0.00,'738','2022-10-03 20:25:02','738','2022-10-03 20:25:26',10,0),('1','208',257805,'DAILY SHIFTS','2022-10-04','2022-10-04 06:49:31','2022-10-05 06:49:31','738',0.00,0.00,'738','2022-10-04 16:34:08','738','2022-10-04 16:34:38',10,0),('1','208',257806,'DAILY SHIFTS','2022-10-04','2022-10-04 16:36:29','2022-10-05 16:36:29','738',0.00,0.00,'738','2022-10-04 19:45:34','738','2022-10-04 19:46:08',10,0),('1','208',257807,'DAILY SHIFT','2022-10-05','2022-10-05 06:46:54','2022-10-06 06:46:54','738',0.00,0.00,'738','2022-10-05 19:30:59','738','2022-10-05 19:31:22',10,0),('1','208',257808,'DAILY SHIFTS','2022-10-06','2022-10-06 06:51:16','2022-10-07 06:51:16','738',0.00,0.00,'738','2022-10-06 18:17:06','738','2022-10-06 18:17:46',10,0),('1','208',257809,'DAILY SHIFTS','2022-10-07','2022-10-07 06:54:57','2022-10-08 06:54:57','738',0.00,0.00,'738','2022-10-07 19:13:24','738','2022-10-07 19:13:47',10,0),('1','208',257810,'DAILY SHIFTS','2022-10-08','2022-10-08 06:40:02','2022-10-09 06:40:02','738',0.00,0.00,'738','2022-10-08 18:45:53','738','2022-10-08 18:46:41',10,0),('1','208',257811,'DAILY SHIFTS','2022-10-12','2022-10-12 06:37:21','2022-10-13 06:37:21','738',0.00,0.00,'738','2022-10-12 19:09:52','738','2022-10-12 19:10:31',10,0),('1','208',257812,'DAILY SHIFTS','2022-10-13','2022-10-13 06:59:24','2022-10-14 06:59:24','738',0.00,0.00,'738','2022-10-13 18:53:42','738','2022-10-13 18:54:55',10,0),('1','208',257813,'DAILY SHIFTS','2022-10-14','2022-10-14 06:43:13','2022-10-15 06:43:13','738',0.00,0.00,'738','2022-10-14 20:01:11','738','2022-10-14 20:03:45',10,0),('1','208',257814,'DAILY SHIFTS','2022-10-15','2022-10-15 06:52:01','2022-10-16 06:52:01','738',0.00,0.00,'738','2022-10-15 20:27:34','738','2022-10-15 20:27:51',10,0),('1','208',257815,'DAILY SHIFTS','2022-10-16','2022-10-16 06:53:52','2022-10-17 06:53:52','738',0.00,0.00,'738','2022-10-16 15:47:16','738','2022-10-16 15:47:50',10,0),('1','208',257816,'DAILY SHIFTS','2022-10-17','2022-10-17 06:38:23','2022-10-18 06:38:23','738',0.00,0.00,'738','2022-10-17 19:23:58','738','2022-10-17 19:24:21',10,0),('1','208',257817,'DAILY SHIFTS','2022-10-18','2022-10-18 06:45:37','2022-10-19 06:45:37','738',0.00,0.00,'738','2022-10-18 20:22:40','738','2022-10-18 20:27:00',10,0),('1','208',257818,'DAILY SHIFTS','2022-10-19','2022-10-19 06:33:02','2022-10-20 06:33:02','738',0.00,0.00,'738','2022-10-19 14:03:03','738','2022-10-19 14:03:28',10,0),('1','208',257819,'DAILY SHIFTS','2022-10-19','2022-10-19 14:04:04','2022-10-20 14:04:04','738',0.00,0.00,'738','2022-10-19 18:55:46','738','2022-10-19 18:56:56',10,0),('1','208',257820,'DAILY SHIFTS','2022-10-20','2022-10-20 06:51:28','2022-10-21 06:51:28','738',0.00,0.00,'738','2022-10-20 20:47:55','738','2022-10-20 20:48:23',10,0),('1','208',257821,'DAILY SHIFTS','2022-10-21','2022-10-21 06:38:09','2022-10-22 06:38:09','738',0.00,0.00,'738','2022-10-21 19:09:01','738','2022-10-21 19:09:57',10,0),('1','208',257822,'DAILY SHIFTS','2022-10-22','2022-10-22 06:50:01','2022-10-23 06:50:01','738',0.00,0.00,'738','2022-10-22 18:03:23','738','2022-10-22 18:03:46',10,0),('1','208',257823,'DAILY SHIFTS','2022-10-23','2022-10-23 06:41:34','2022-10-24 06:41:34','738',0.00,0.00,'738','2022-10-23 19:24:56','738','2022-10-23 19:25:17',10,0),('1','208',257824,'DAILY SHIFTS','2022-10-24','2022-10-24 06:45:33','2022-10-25 06:45:33','738',0.00,0.00,'738','2022-10-24 18:56:01','738','2022-10-24 18:56:27',10,0),('1','208',257825,'DAILY SHIFTS','2022-10-25','2022-10-25 06:45:15','2022-10-26 06:45:15','738',0.00,0.00,'738','2022-10-25 16:01:53','738','2022-10-25 16:02:19',10,0),('1','208',257826,'DAILY SHIFTS','2022-10-25','2022-10-25 16:02:46','2022-10-26 16:02:46','738',0.00,0.00,'738','2022-10-25 19:26:13','738','2022-10-25 19:26:33',10,0),('1','208',257827,'DAILY SHIFTS','2022-10-26','2022-10-26 07:03:19','2022-10-27 07:03:19','738',0.00,0.00,'738','2022-10-26 20:30:18','738','2022-10-26 20:30:38',10,0),('1','208',257828,'DAILY SHIFTS','2022-10-27','2022-10-27 07:02:43','2022-10-28 07:02:43','738',0.00,0.00,'738','2022-10-27 19:39:44','738','2022-10-27 19:40:07',10,0),('1','208',257829,'DAILY SHIFTS','2022-10-28','2022-10-28 06:49:11','2022-10-29 06:49:11','738',0.00,0.00,'738','2022-10-28 17:07:46','738','2022-10-28 17:08:14',10,0),('1','208',257830,'DAILY SHIFTS','2022-10-31','2022-10-31 13:51:28','2022-11-01 13:51:28','738',0.00,0.00,'738','2022-10-31 19:44:31','738','2022-10-31 19:45:12',10,0),('1','208',257831,'DAILY SHIFTS','2022-11-01','2022-11-01 06:47:14','2022-11-02 06:47:14','738',0.00,0.00,'738','2022-11-01 19:09:52','738','2022-11-01 19:10:17',10,0),('1','208',257832,'DAILY SHIFTS','2022-11-02','2022-11-02 06:48:52','2022-11-03 06:48:52','738',0.00,0.00,'738','2022-11-02 13:14:22','738','2022-11-02 13:14:43',10,0),('1','208',257833,'DAILY SHIFTS','2022-11-05','2022-11-05 13:32:32','2022-11-06 13:32:32','738',0.00,0.00,'738','2022-11-05 18:59:33','738','2022-11-05 19:01:28',10,0),('1','208',257834,'DAILY SHIFTS','2022-11-06','2022-11-06 07:47:26','2022-11-07 07:47:26','738',0.00,0.00,'738','2022-11-06 19:26:56','738','2022-11-06 19:27:37',10,0),('1','208',257835,'DAILY SHIFT','2022-11-07','2022-11-07 06:40:29','2022-11-08 06:40:29','738',0.00,0.00,'738','2022-11-07 09:37:00','738','2022-11-07 09:37:28',10,0),('1','208',257836,'DAILY SHIFTS','2022-11-07','2022-11-07 11:30:54','2022-11-08 11:30:54','738',0.00,0.00,'738','2022-11-07 21:38:00','738','2022-11-07 21:38:19',10,0),('1','208',257837,'DAILY SHIFTS','2022-11-08','2022-11-08 06:19:15','2022-11-09 06:19:15','738',0.00,0.00,'738','2022-11-08 20:33:35','738','2022-11-08 20:33:56',10,0),('1','208',257838,'DAILY SHIFTS','2022-11-09','2022-11-09 06:04:50','2022-11-10 06:04:50','738',0.00,0.00,'738','2022-11-09 12:56:47','738','2022-11-09 15:54:05',10,0),('1','208',257839,'DAILY SHIFTS','2022-11-09','2022-11-09 16:25:16','2022-11-10 16:25:16','738',0.00,0.00,'738','2022-11-09 18:45:02','738','2022-11-09 20:20:14',10,0),('1','208',257840,'DAILY SHIFTS','2022-11-10','2022-11-10 06:27:56','2022-11-11 06:27:56','738',0.00,0.00,'738','2022-11-10 21:09:31','738','2022-11-10 21:10:00',10,0),('1','208',257841,'DAILY SHIFTS','2022-11-11','2022-11-11 06:24:58','2022-11-12 06:24:58','738',0.00,0.00,'738','2022-11-11 20:32:14','738','2022-11-11 20:33:48',10,0),('1','208',257842,'DAILY SHIFTS','2022-11-12','2022-11-12 06:43:38','2022-11-13 06:43:38','738',0.00,0.00,'738','2022-11-12 10:31:45','738','2022-11-12 10:32:09',10,0),('1','208',257843,'DAILY SHIFTS','2022-11-12','2022-11-12 12:20:39','2022-11-13 12:20:39','738',0.00,0.00,'738','2022-11-12 21:28:21','738','2022-11-12 21:28:44',10,0),('1','208',257844,'DAILY SHIFTS','2022-11-13','2022-11-13 06:50:48','2022-11-14 06:50:48','738',0.00,0.00,'738','2022-11-13 19:10:44','738','2022-11-13 19:11:09',10,0),('1','208',257845,'DAILY SHIFTS','2022-11-14','2022-11-14 05:45:56','2022-11-15 05:45:56','738',0.00,0.00,'738','2022-11-14 20:26:38','738','2022-11-14 20:26:57',10,0),('1','208',257846,'DAILY SHIFTS','2022-11-15','2022-11-15 07:11:45','2022-11-16 07:11:45','738',0.00,0.00,'738','2022-11-15 09:43:27','738','2022-11-15 09:43:56',10,0),('1','208',257847,'DAILY SHIFTS','2022-11-15','2022-11-15 09:46:42','2022-11-16 09:46:42','738',0.00,0.00,'738','2022-11-15 20:26:49','738','2022-11-15 20:27:45',10,0),('1','208',257848,'DAILY SHIFTS','2022-11-16','2022-11-16 06:53:32','2022-11-17 06:53:32','738',0.00,0.00,'738','2022-11-16 20:35:47','738','2022-11-16 20:36:11',10,0),('1','208',257849,'DAILY SHIFTS','2022-11-17','2022-11-17 07:03:34','2022-11-18 07:03:34','738',0.00,0.00,'738','2022-11-17 18:54:59','738','2022-11-17 18:55:20',10,0),('1','208',257850,'DAILY SHIFTS','2022-11-18','2022-11-18 06:42:06','2022-11-19 06:42:06','738',0.00,0.00,'738','2022-11-18 21:12:54','738','2022-11-18 21:13:21',10,0),('1','208',257851,'DAILY SHIFTS','2022-11-19','2022-11-19 07:15:43','2022-11-20 07:15:43','738',0.00,0.00,'738','2022-11-19 15:17:29','738','2022-11-19 16:25:07',10,0),('1','208',257852,'DAILY SHIFTS','2022-11-19','2022-11-19 16:40:58','2022-11-20 16:40:58','738',0.00,0.00,'738','2022-11-19 19:21:54','738','2022-11-19 19:22:33',10,0),('1','208',257853,'DAILY SHIFTS','2022-11-20','2022-11-20 06:43:26','2022-11-21 06:43:26','738',0.00,0.00,'738','2022-11-20 20:34:19','738','2022-11-20 20:34:49',10,0),('1','208',257854,'DAILY SHIFTS','2022-11-21','2022-11-21 06:59:32','2022-11-22 06:59:32','738',0.00,0.00,'738','2022-11-21 18:56:48','738','2022-11-21 18:57:48',10,0),('1','208',257855,'DAILY SHIFTS','2022-11-22','2022-11-22 06:54:46','2022-11-23 06:54:46','738',0.00,0.00,'738','2022-11-22 18:43:30','738','2022-11-22 18:43:57',10,0),('1','208',257856,'DAILY SHIFTS','2022-11-23','2022-11-23 06:44:35','2022-11-24 06:44:35','738',0.00,0.00,'738','2022-11-23 18:28:05','738','2022-11-23 18:28:56',10,0),('1','208',257857,'DAILY SHIFTS','2022-11-24','2022-11-24 06:50:32','2022-11-25 06:50:32','738',0.00,0.00,'738','2022-11-24 15:17:13','738','2022-11-24 15:17:35',10,0),('1','208',257858,'DAILY SHIFTS','2022-11-24','2022-11-24 15:18:01','2022-11-25 15:18:01','738',0.00,0.00,'738','2022-11-24 18:37:40','738','2022-11-24 18:38:10',10,0),('1','208',257859,'DAILY SHIFTS','2022-11-25','2022-11-25 06:59:35','2022-11-26 06:59:35','738',0.00,0.00,'738','2022-11-25 20:48:20','738','2022-11-25 20:48:48',10,0),('1','208',257860,'DAILY SHIFTS','2022-11-26','2022-11-26 07:43:44','2022-11-27 07:43:44','738',0.00,0.00,'738','2022-11-26 21:53:50','738','2022-11-26 21:54:18',10,0),('1','208',257861,'DAILY SHIFTS','2022-11-27','2022-11-27 07:20:49','2022-11-28 07:20:49','738',0.00,0.00,'738','2022-11-27 20:59:13','738','2022-11-27 20:59:34',10,0),('1','208',257862,'DAILY SHIFTS','2022-11-28','2022-11-28 06:59:59','2022-11-29 06:59:59','738',0.00,0.00,'738','2022-11-28 10:12:49','738','2022-11-28 10:13:14',10,0),('1','208',257863,'DAILY SHIFTS','2022-11-28','2022-11-28 10:15:05','2022-11-29 10:15:05','738',0.00,0.00,'738','2022-11-28 21:02:29','738','2022-11-28 21:03:32',10,0),('1','208',257864,'DAILY SHIFTS','2022-11-29','2022-11-29 14:48:08','2022-11-30 14:48:08','738',0.00,0.00,'738','2022-11-29 20:33:29','738','2022-11-29 20:33:53',10,0),('1','208',257865,'DAILY SHIFTS','2022-11-30','2022-11-30 07:29:16','2022-12-01 07:29:16','738',0.00,0.00,'738','2022-11-30 18:48:20','738','2022-11-30 18:48:51',10,0),('1','208',257866,'DAILY SHIFTS','2022-12-01','2022-12-01 07:11:07','2022-12-02 07:11:07','738',0.00,0.00,'738','2022-12-01 11:20:53','738','2022-12-01 11:21:15',10,0),('1','208',257867,'DAILY SHIFTS','2022-12-01','2022-12-01 11:27:36','2022-12-02 11:27:36','738',0.00,0.00,'738','2022-12-01 20:22:59','738','2022-12-01 20:23:42',10,0),('1','208',257868,'DAILY SHIFTS','2022-12-02','2022-12-02 07:07:34','2022-12-03 07:07:34','738',0.00,0.00,'738','2022-12-02 19:46:48','738','2022-12-02 19:47:12',10,0),('1','208',257869,'DAILY SHIFTS','2022-12-03','2022-12-03 07:06:55','2022-12-04 07:06:55','738',0.00,0.00,'738','2022-12-03 14:33:46','738','2022-12-03 14:34:11',10,0),('1','208',257870,'DAILY SHIFTS','2022-12-04','2022-12-04 07:02:42','2022-12-05 07:02:42','738',0.00,0.00,'738','2022-12-04 21:51:34','738','2022-12-04 21:52:11',10,0),('1','208',257871,'DAILY SHIFTS','2022-12-05','2022-12-05 06:57:07','2022-12-06 06:57:07','738',0.00,0.00,'738','2022-12-05 20:58:18','738','2022-12-05 20:58:46',10,0),('1','208',257872,'DAILY SHIFTS','2022-12-06','2022-12-06 07:22:55','2022-12-07 07:22:55','738',0.00,0.00,'738','2022-12-06 11:40:51','738','2022-12-06 11:41:21',10,0),('1','208',257873,'DAILY SHIFTS','2022-12-06','2022-12-06 12:20:15','2022-12-07 12:20:15','738',0.00,0.00,'738','2022-12-06 20:35:57','738','2022-12-06 20:36:24',10,0),('1','208',257874,'DAILY SHIFTS','2022-12-07','2022-12-07 07:01:29','2022-12-08 07:01:29','738',0.00,0.00,'738','2022-12-07 18:56:09','738','2022-12-07 18:56:45',10,0),('1','208',257875,'DAILY SHIFTS','2022-12-08','2022-12-08 07:00:28','2022-12-09 07:00:28','738',0.00,0.00,'738','2022-12-08 11:50:55','738','2022-12-08 18:34:07',10,0),('1','208',257876,'DAILY SHIFTS','2022-12-10','2022-12-10 15:42:21','2022-12-11 15:42:21','738',0.00,0.00,'738','2022-12-10 19:30:36','738','2022-12-10 19:30:57',10,0),('1','208',257877,'DAILY SHIFTS','2022-12-11','2022-12-11 07:09:02','2022-12-12 07:09:02','738',0.00,0.00,'738','2022-12-11 18:49:12','738','2022-12-11 18:49:42',10,0),('1','208',257878,'DAILY SHIFTS','2022-12-12','2022-12-12 07:11:06','2022-12-13 07:11:06','738',0.00,0.00,'738','2022-12-12 19:23:12','738','2022-12-12 19:23:42',10,0),('1','208',257879,'DAILY SHIFTS','2022-12-13','2022-12-13 07:02:21','2022-12-14 07:02:21','738',0.00,0.00,'738','2022-12-13 15:05:55','738','2022-12-13 15:06:28',10,0),('1','208',257880,'DAILY SHIFTS','2022-12-14','2022-12-14 06:22:25','2022-12-15 06:22:25','738',0.00,0.00,'738','2022-12-14 18:48:20','738','2022-12-14 18:48:41',10,0),('1','208',257881,'DAILY SHIFTS','2022-12-15','2022-12-15 07:02:48','2022-12-16 07:02:48','738',0.00,0.00,'738','2022-12-15 20:32:03','738','2022-12-15 20:32:26',10,0),('1','208',257882,'DAILY SHIFTS','2022-12-16','2022-12-16 07:00:46','2022-12-17 07:00:46','738',0.00,0.00,'738','2022-12-16 13:15:15','738','2022-12-16 13:15:38',10,0),('1','208',257883,'DAILY SHIFTS','2022-12-16','2022-12-16 17:53:59','2022-12-17 17:53:59','738',0.00,0.00,'738','2022-12-16 18:45:47','738','2022-12-16 18:46:10',10,0),('1','208',257884,'DAILY SHIFTS','2022-12-17','2022-12-17 07:01:53','2022-12-18 07:01:53','738',0.00,0.00,'738','2022-12-17 13:29:56','738','2022-12-17 13:30:22',10,0),('1','208',257885,'DAILY SHIFTS','2022-12-17','2022-12-17 13:59:30','2022-12-18 13:59:30','738',0.00,0.00,'738','2022-12-17 18:47:30','738','2022-12-17 18:48:09',10,0),('1','208',257886,'DAILY SHIFTS','2022-12-18','2022-12-18 06:42:10','2022-12-19 06:42:10','738',0.00,0.00,'738','2022-12-18 20:09:23','738','2022-12-18 20:09:46',10,0),('1','208',257887,'DAILY SHIFTS','2022-12-19','2022-12-19 07:06:02','2022-12-20 07:06:02','738',0.00,0.00,'738','2022-12-19 19:04:33','738','2022-12-19 19:04:57',10,0),('1','208',257888,'DAILY SHIFTS','2022-12-20','2022-12-20 06:14:17','2022-12-21 06:14:17','738',0.00,0.00,'738','2022-12-20 18:23:48','738','2022-12-20 18:24:10',10,0),('1','208',257889,'DAILY SHIFTS','2022-12-21','2022-12-21 07:12:22','2022-12-22 07:12:22','738',0.00,0.00,'738','2022-12-21 20:36:59','738','2022-12-21 20:38:00',10,0),('1','208',257890,'DAILY SHIFTS','2022-12-22','2022-12-22 07:11:55','2022-12-23 07:11:55','738',0.00,0.00,'738','2022-12-22 18:47:58','738','2022-12-22 18:48:52',10,0),('1','208',257891,'DAILY SHIFTS','2022-12-23','2022-12-23 07:13:34','2022-12-24 07:13:34','738',0.00,0.00,'738','2022-12-23 12:53:37','738','2022-12-23 12:54:44',10,0),('1','208',257892,'DAILY SHIFTS','2022-12-23','2022-12-23 13:13:05','2022-12-24 13:13:05','738',0.00,0.00,'738','2022-12-23 19:06:42','738','2022-12-23 19:07:05',10,0),('1','208',257893,'DAILY SHIFTS','2022-12-24','2022-12-24 07:03:33','2022-12-25 07:03:33','738',0.00,0.00,'738','2022-12-24 20:39:07','738','2022-12-24 20:40:19',10,0),('1','208',257894,'DAILY SHIFTS','2022-12-25','2022-12-25 06:27:50','2022-12-26 06:27:50','738',0.00,0.00,'738','2022-12-25 21:29:15','738','2022-12-25 21:34:37',10,0),('1','208',257895,'DAILY SHIFTS','2022-12-26','2022-12-26 07:46:52','2022-12-27 07:46:52','738',0.00,0.00,'738','2022-12-26 12:42:54','738','2022-12-26 12:44:15',10,0),('1','208',257896,'DAILY SHIFTS','2022-12-26','2022-12-26 14:12:38','2022-12-27 14:12:38','738',0.00,0.00,'738','2022-12-26 19:21:04','738','2022-12-26 19:21:28',10,0),('1','208',257897,'DAILY SHIFTS','2022-12-27','2022-12-27 06:52:07','2022-12-28 06:52:07','738',0.00,0.00,'738','2022-12-27 19:39:30','738','2022-12-27 19:39:53',10,0),('1','208',257898,'DAILY SHIFTS','2022-12-28','2022-12-28 07:33:12','2022-12-29 07:33:12','738',0.00,0.00,'738','2022-12-28 13:51:41','738','2022-12-28 13:52:09',10,0),('1','208',257899,'DAILY SHIFTS','2022-12-28','2022-12-28 14:03:16','2022-12-29 14:03:16','738',0.00,0.00,'738','2022-12-28 18:53:36','738','2022-12-28 18:53:53',10,0),('1','208',257900,'DAILY SHIFTS','2022-12-29','2022-12-29 07:30:03','2022-12-30 07:30:03','738',0.00,0.00,'738','2022-12-29 20:53:19','738','2022-12-29 20:53:42',10,0),('1','208',257901,'DAILY SHIFTS','2022-12-30','2022-12-30 07:28:50','2022-12-31 07:28:50','738',0.00,0.00,'738','2022-12-30 15:09:51','738','2022-12-30 15:12:39',10,0),('1','208',257902,'DAILY SHIFTS','2022-12-30','2022-12-30 18:09:43','2022-12-31 18:09:43','738',0.00,0.00,'738','2022-12-30 19:19:44','738','2022-12-30 19:20:06',10,0),('1','208',257903,'DAILY SHIFTS','2022-12-31','2022-12-31 10:56:22','2023-01-01 10:56:22','738',0.00,0.00,'738','2022-12-31 21:08:26','738','2022-12-31 21:08:47',10,0),('1','208',257904,'DAILY SHIFTS','2023-01-01','2023-01-01 08:07:57','2023-01-02 08:07:57','738',0.00,0.00,'738','2023-01-01 12:22:10','738','2023-01-01 12:24:16',10,0),('1','208',257905,'DAILY SHIFTS','2023-01-01','2023-01-01 14:05:52','2023-01-02 14:05:52','738',0.00,0.00,'738','2023-01-01 21:19:24','738','2023-01-01 21:19:44',10,0),('1','208',257906,'DAILY SHIFTS','2023-01-02','2023-01-02 07:25:30','2023-01-03 07:25:30','738',0.00,0.00,'738','2023-01-02 20:04:20','738','2023-01-02 20:05:02',10,0),('1','208',257907,'DAILY SHIFTS','2023-01-03','2023-01-03 07:25:41','2023-01-04 07:25:41','738',0.00,0.00,'738','2023-01-03 17:28:20','738','2023-01-03 17:28:50',10,0),('1','208',257908,'DAILY SHIFTS','2023-01-03','2023-01-03 17:29:18','2023-01-04 17:29:18','738',0.00,0.00,'738','2023-01-03 19:18:39','738','2023-01-03 19:19:01',10,0),('1','208',257909,'DAILY SHIFTS','2023-01-04','2023-01-04 06:33:38','2023-01-05 06:33:38','738',0.00,0.00,'738','2023-01-04 20:24:03','738','2023-01-04 20:24:23',10,0),('1','208',257910,'DAILY SHIFTS','2023-01-05','2023-01-05 06:44:42','2023-01-06 06:44:42','738',0.00,0.00,'738','2023-01-05 18:22:17','738','2023-01-05 18:23:00',10,0),('1','208',257911,'DAILY SHIFTS','2023-01-06','2023-01-06 07:06:29','2023-01-07 07:06:29','738',0.00,0.00,'738','2023-01-06 19:29:22','738','2023-01-06 19:29:46',10,0),('1','208',257912,'DAILY SHIFTS','2023-01-07','2023-01-07 07:17:12','2023-01-08 07:17:12','738',0.00,0.00,'738','2023-01-07 17:52:32','738','2023-01-07 17:53:07',10,0),('1','208',257913,'DAILY SHIFTS','2023-01-08','2023-01-08 07:12:59','2023-01-09 07:12:59','738',0.00,0.00,'738','2023-01-08 19:22:28','738','2023-01-08 19:22:51',10,0),('1','208',257914,'DAILY SHIFTS','2023-01-09','2023-01-09 07:33:26','2023-01-10 07:33:26','738',0.00,0.00,'738','2023-01-09 19:45:39','738','2023-01-09 19:46:04',10,0),('1','208',257915,'DAILY SHIFTS','2023-01-10','2023-01-10 06:39:00','2023-01-11 06:39:00','738',0.00,0.00,'738','2023-01-10 13:47:32','738','2023-01-10 13:57:53',10,0),('1','208',257916,'DAILY SHIFTS','2023-01-10','2023-01-10 14:02:43','2023-01-11 14:02:43','738',0.00,0.00,'738','2023-01-10 18:57:09','738','2023-01-10 18:57:48',10,0),('1','208',257917,'DAILY SHIFTS','2023-01-11','2023-01-11 06:33:06','2023-01-12 06:33:06','738',0.00,0.00,'738','2023-01-11 19:04:34','738','2023-01-11 19:04:55',10,0),('1','208',257918,'DAILY SHIFTS','2023-01-12','2023-01-12 06:23:19','2023-01-13 06:23:19','738',0.00,0.00,'738','2023-01-12 16:06:14','738','2023-01-12 16:06:41',10,0),('1','208',257919,'DAILY SHIFTS','2023-01-12','2023-01-12 16:35:49','2023-01-13 16:35:49','738',0.00,0.00,'738','2023-01-12 19:34:09','738','2023-01-12 19:34:30',10,0),('1','208',257920,'DAILY SHIFTS','2023-01-13','2023-01-13 06:58:13','2023-01-14 06:58:13','738',0.00,0.00,'738','2023-01-13 10:49:36','738','2023-01-13 10:50:04',10,0),('1','208',257921,'DAILY SHIFTS','2023-01-13','2023-01-13 11:57:51','2023-01-14 11:57:51','738',0.00,0.00,'738','2023-01-13 19:37:27','738','2023-01-13 19:37:54',10,0),('1','208',257922,'DAILY SHIFTS','2023-01-14','2023-01-14 06:21:34','2023-01-15 06:21:34','738',0.00,0.00,'738','2023-01-15 06:26:04','738','2023-01-15 06:26:30',10,0),('1','208',257923,'DAILY SHIFTS','2023-01-15','2023-01-15 06:29:27','2023-01-16 06:29:27','738',0.00,0.00,'738','2023-01-15 11:11:23','738','2023-01-15 11:12:19',10,0),('1','208',257924,'DAILY SHIFTS','2023-01-15','2023-01-15 11:12:56','2023-01-16 11:12:56','738',0.00,0.00,'738','2023-01-15 20:10:06','738','2023-01-15 20:10:27',10,0),('1','208',257925,'DAILY SHIFTS','2023-01-16','2023-01-16 06:30:21','2023-01-17 06:30:21','738',0.00,0.00,'738','2023-01-16 14:39:28','738','2023-01-16 14:39:53',10,0),('1','208',257926,'DAILY SHIFTS','2023-01-16','2023-01-16 14:40:32','2023-01-17 14:40:32','738',0.00,0.00,'738','2023-01-16 20:56:05','738','2023-01-16 20:56:37',10,0),('1','208',257927,'DAILY SHIFTS','2023-01-17','2023-01-17 07:59:42','2023-01-18 07:59:42','738',0.00,0.00,'738','2023-01-17 19:23:22','738','2023-01-17 19:24:11',10,0),('1','208',257928,'DAILY SHIFTS','2023-01-18','2023-01-18 06:16:11','2023-01-19 06:16:11','738',0.00,0.00,'738','2023-01-18 16:57:21','738','2023-01-18 16:58:19',10,0),('1','208',257929,'DAILY SHIFTS','2023-01-19','2023-01-19 08:28:44','2023-01-20 08:28:44','738',0.00,0.00,'738','2023-01-19 12:14:40','738','2023-01-19 12:15:07',10,0),('1','208',257930,'DAILY SHIFTS','2023-01-19','2023-01-19 12:15:48','2023-01-20 12:15:48','738',0.00,0.00,'738','2023-01-19 19:10:33','738','2023-01-19 19:11:34',10,0),('1','208',257931,'DAILY SHIFTS','2023-01-20','2023-01-20 07:06:05','2023-01-21 07:06:05','738',0.00,0.00,'738','2023-01-20 19:29:46','738','2023-01-20 19:30:26',10,0),('1','208',257932,'DAILY SHIFTS','2023-01-21','2023-01-21 07:08:19','2023-01-22 07:08:19','738',0.00,0.00,'738','2023-01-21 11:53:04','738','2023-01-21 11:54:08',10,0),('1','208',257933,'DAILY SHIFTS','2023-01-21','2023-01-21 14:30:08','2023-01-22 14:30:08','738',0.00,0.00,'738','2023-01-21 21:46:17','738','2023-01-21 21:46:40',10,0),('1','208',257934,'DAILY SHIFTS','2023-01-22','2023-01-22 07:00:18','2023-01-23 07:00:18','738',0.00,0.00,'738','2023-01-22 10:23:42','738','2023-01-22 10:25:40',10,0),('1','208',257935,'DAILY SHIFTS','2023-01-22','2023-01-22 13:08:58','2023-01-23 13:08:58','738',0.00,0.00,'738','2023-01-22 20:46:51','738','2023-01-22 20:47:20',10,0),('1','208',257936,'DAILY SHIFTS','2023-01-23','2023-01-23 07:36:48','2023-01-24 07:36:48','738',0.00,0.00,'738','2023-01-23 19:42:35','738','2023-01-23 19:43:03',10,0),('1','208',257937,'DAILY SHIFTS','2023-01-24','2023-01-24 07:01:06','2023-01-25 07:01:06','738',0.00,0.00,'738','2023-01-24 15:04:56','738','2023-01-24 15:06:28',10,0),('1','208',257938,'DAILY SHIFTS','2023-01-24','2023-01-24 15:11:44','2023-01-25 15:11:44','738',0.00,0.00,'738','2023-01-24 19:25:06','738','2023-01-24 19:25:41',10,0),('1','208',257939,'DAILY SHIFTS','2023-01-25','2023-01-25 07:45:05','2023-01-26 07:45:05','738',0.00,0.00,'738','2023-01-25 20:08:38','738','2023-01-25 20:09:02',10,0),('1','208',257940,'DAILY SHIFTS','2023-01-26','2023-01-26 07:11:09','2023-01-27 07:11:09','738',0.00,0.00,'738','2023-01-26 11:34:49','738','2023-01-26 11:37:11',10,0),('1','208',257941,'DAILY SHIFTS','2023-01-26','2023-01-26 12:18:47','2023-01-27 12:18:47','738',0.00,0.00,'738','2023-01-26 19:37:02','738','2023-01-26 19:37:59',10,0),('1','208',257942,'DAILY SHIFTS','2023-01-27','2023-01-27 06:53:18','2023-01-28 06:53:18','738',0.00,0.00,'738','2023-01-27 19:30:47','738','2023-01-27 19:31:48',10,0),('1','208',257943,'DAILY SHIFTS','2023-01-28','2023-01-28 12:12:21','2023-01-29 12:12:21','738',0.00,0.00,'738','2023-01-29 06:17:59','738','2023-01-29 06:18:24',10,0),('1','208',257944,'DAILY SHIFTS','2023-01-29','2023-01-29 10:13:57','2023-01-30 10:13:57','738',0.00,0.00,'738','2023-01-29 21:47:21','738','2023-01-29 21:48:18',10,0),('1','208',257945,'DAILY SHIFTS','2023-01-30','2023-01-30 06:59:36','2023-01-31 06:59:36','738',0.00,0.00,'738','2023-01-30 20:48:47','738','2023-01-30 20:49:39',10,0),('1','208',257946,'DAILY SHIFTS','2023-01-31','2023-01-31 06:38:12','2023-02-01 06:38:12','738',0.00,0.00,'738','2023-01-31 22:02:35','738','2023-01-31 22:03:02',10,0),('1','208',257947,'DAILY SHIFTS','2023-02-01','2023-02-01 06:53:43','2023-02-02 06:53:43','738',0.00,0.00,'738','2023-02-01 19:51:35','738','2023-02-01 19:52:46',10,0),('1','208',257948,'DAILY SHIFTS','2023-02-02','2023-02-02 07:32:08','2023-02-03 07:32:08','738',0.00,0.00,'738','2023-02-02 20:03:34','738','2023-02-02 20:04:01',10,0),('1','208',257949,'DAILY SHIFTS','2023-02-03','2023-02-03 06:37:00','2023-02-04 06:37:00','738',0.00,0.00,'738','2023-02-03 22:02:47','738','2023-02-03 22:03:11',10,0),('1','208',257950,'DAILY SHIFTS','2023-02-04','2023-02-04 07:13:11','2023-02-05 07:13:11','738',0.00,0.00,'738','2023-02-04 22:02:04','738','2023-02-04 22:02:35',10,0),('1','208',257951,'DAILY SHIFTS','2023-02-05','2023-02-05 06:40:44','2023-02-06 06:40:44','738',0.00,0.00,'738','2023-02-05 22:02:15','738','2023-02-05 22:02:38',10,0),('1','208',257952,'DAILY SHIFTS','2023-02-05','2023-02-05 22:07:06','2023-02-06 22:07:06','738',0.00,0.00,'738','2023-02-05 22:11:52','738','2023-02-05 22:12:25',10,0),('1','208',257953,'DAILY SHIFTS','2023-02-06','2023-02-06 07:12:42','2023-02-07 07:12:42','738',0.00,0.00,'738','2023-02-06 20:33:05','738','2023-02-06 20:33:30',10,0),('1','208',257954,'DAILY SHIFTS','2023-02-07','2023-02-07 07:25:04','2023-02-08 07:25:04','738',0.00,0.00,'738','2023-02-07 22:03:02','738','2023-02-07 22:03:47',10,0),('1','208',257955,'DAILY SHIFTS','2023-02-07','2023-02-07 22:07:56','2023-02-08 22:07:56','738',0.00,0.00,'738','2023-02-07 22:13:42','738','2023-02-07 22:14:13',10,0),('1','208',257956,'DAILY SHIFTS','2023-02-08','2023-02-08 07:10:09','2023-02-09 07:10:09','738',0.00,0.00,'738','2023-02-08 21:38:50','738','2023-02-08 21:39:30',10,0),('1','208',257957,'DAILY SHIFTS','2023-02-11','2023-02-11 16:36:06','2023-02-12 16:36:06','738',0.00,0.00,'738','2023-02-11 19:11:13','738','2023-02-11 19:11:37',10,0),('1','208',257958,'DAILY SHIFTS','2023-02-12','2023-02-12 07:14:17','2023-02-13 07:14:17','738',0.00,0.00,'738','2023-02-12 21:50:16','738','2023-02-12 21:50:57',10,0),('1','208',257959,'DAILY SHIFTS','2023-02-13','2023-02-13 07:00:47','2023-02-14 07:00:47','738',0.00,0.00,'738','2023-02-13 15:51:00','738','2023-02-13 15:51:25',10,0),('1','208',257960,'DAILY SHIFTS','2023-02-14','2023-02-14 06:51:25','2023-02-15 06:51:25','738',0.00,0.00,'738','2023-02-14 22:12:59','738','2023-02-14 22:13:30',10,0),('1','208',257961,'DAILY SHIFTS','2023-02-15','2023-02-15 06:32:32','2023-02-16 06:32:32','738',0.00,0.00,'738','2023-02-15 21:20:24','738','2023-02-15 21:20:53',10,0),('1','208',257962,'DAILY SHIFTS','2023-02-16','2023-02-16 06:57:06','2023-02-17 06:57:06','738',0.00,0.00,'738','2023-02-16 17:12:05','738','2023-02-16 17:12:35',10,0),('1','208',257963,'DAILY SHIFTS','2023-02-16','2023-02-16 17:16:28','2023-02-17 17:16:28','738',0.00,0.00,'738','2023-02-16 22:01:47','738','2023-02-16 22:02:09',10,0),('1','208',257964,'DAILY SHIFTS','2023-02-17','2023-02-17 07:17:41','2023-02-18 07:17:41','738',0.00,0.00,'738','2023-02-17 21:38:01','738','2023-02-17 21:38:25',10,0),('1','208',257965,'DAILY SHIFTS','2023-02-18','2023-02-18 07:52:11','2023-02-19 07:52:11','738',0.00,0.00,'738','2023-02-18 19:54:33','738','2023-02-18 19:55:11',10,0),('1','208',257966,'DAILY SHIFTS','2023-02-19','2023-02-19 10:13:12','2023-02-20 10:13:12','738',0.00,0.00,'738','2023-02-19 21:32:41','738','2023-02-19 21:33:17',10,0),('1','208',257967,'DAILY SHIFTS','2023-02-20','2023-02-20 08:11:48','2023-02-21 08:11:48','738',0.00,0.00,'738','2023-02-20 21:32:36','738','2023-02-20 21:33:44',10,0),('1','208',257968,'DAILY SHIFTS','2023-02-21','2023-02-21 06:56:02','2023-02-22 06:56:02','738',0.00,0.00,'738','2023-02-21 22:01:18','738','2023-02-21 22:01:40',10,0),('1','208',257969,'DAILY SHIFTS','2023-02-22','2023-02-22 08:03:12','2023-02-23 08:03:12','738',0.00,0.00,'738','2023-02-22 12:26:29','738','2023-02-22 13:17:58',10,0),('1','208',257970,'DAILY SHIFTS','2023-02-22','2023-02-22 13:22:03','2023-02-23 13:22:03','738',0.00,0.00,'738','2023-02-22 20:58:52','738','2023-02-22 20:59:14',10,0),('1','208',257971,'DAILY SHIFTS','2023-02-23','2023-02-23 06:26:48','2023-02-24 06:26:48','738',0.00,0.00,'738','2023-02-23 21:27:24','738','2023-02-23 21:27:45',10,0),('1','208',257972,'DAILY SHIFTS','2023-02-24','2023-02-24 07:01:19','2023-02-25 07:01:19','738',0.00,0.00,'738','2023-02-24 13:26:00','738','2023-02-24 13:26:29',10,0),('1','208',257973,'DAILY SHIFTS','2023-02-24','2023-02-24 14:21:46','2023-02-25 14:21:46','738',0.00,0.00,'738','2023-02-24 22:38:52','738','2023-02-24 22:39:18',10,0),('1','208',257974,'DAILY SHIFTS','2023-02-26','2023-02-26 10:23:57','2023-02-27 10:23:57','738',0.00,0.00,'738','2023-02-26 21:01:39','738','2023-02-26 21:02:34',10,0),('1','208',257975,'DAILY SHIFTS','2023-02-27','2023-02-27 06:18:27','2023-02-28 06:18:27','738',0.00,0.00,'738','2023-02-27 19:16:14','738','2023-02-27 19:16:39',10,0),('1','208',257976,'DAILY SHIFTS','2023-02-28','2023-02-28 06:40:09','2023-03-01 06:40:09','738',0.00,0.00,'738','2023-02-28 21:49:39','738','2023-02-28 21:50:13',10,0),('1','208',257977,'DAILY SHIFTS','2023-03-01','2023-03-01 07:10:45','2023-03-02 07:10:45','738',0.00,0.00,'738','2023-03-01 21:18:21','738','2023-03-01 21:18:44',10,0),('1','208',257978,'DAILY SHIFTS','2023-03-02','2023-03-02 06:31:50','2023-03-03 06:31:50','738',0.00,0.00,'738','2023-03-02 19:00:22','738','2023-03-02 19:00:46',10,0),('1','208',257979,'DAILY SHIFTS','2023-03-03','2023-03-03 00:06:13','2023-03-04 00:06:13','738',0.00,0.00,'738','2023-03-03 00:07:07','738','2023-03-03 00:07:45',10,0),('1','208',257980,'DAILY SHIFTS','2023-03-02','2023-03-03 00:08:43','2023-03-04 00:08:43','738',0.00,0.00,'738','2023-03-03 00:12:38','738','2023-03-03 00:12:55',10,0),('1','208',257981,'DAILY SHIFTS','2023-03-03','2023-03-03 06:12:36','2023-03-04 06:12:36','738',0.00,0.00,'738','2023-03-03 19:39:16','738','2023-03-03 19:39:39',10,0),('1','208',257982,'DAILY SHIFT','2023-03-04','2023-03-04 07:41:01','2023-03-05 07:41:01','738',0.00,0.00,'738','2023-03-04 22:57:23','738','2023-03-04 22:58:23',10,0),('1','208',257983,'DAILY SHIFTS','2023-03-05','2023-03-05 06:25:33','2023-03-06 06:25:33','738',0.00,0.00,'738','2023-03-05 12:33:08','738','2023-03-05 12:33:28',10,0),('1','208',257984,'DAILY SHIFTS','2023-03-05','2023-03-05 12:33:50','2023-03-06 12:33:50','738',0.00,0.00,'738','2023-03-05 22:14:05','738','2023-03-05 22:14:42',10,0),('1','208',257985,'DAILY SHIFTS','2023-03-06','2023-03-06 07:35:28','2023-03-07 07:35:28','738',0.00,0.00,'738','2023-03-06 21:22:18','738','2023-03-06 21:22:59',10,0),('1','208',257986,'DAILY SHIFTS','2023-03-07','2023-03-07 06:21:53','2023-03-08 06:21:53','738',0.00,0.00,'738','2023-03-08 08:20:59','738','2023-03-08 08:21:30',10,0),('1','208',257987,'DAILY SHIFTS','2023-03-08','2023-03-08 11:59:58','2023-03-09 11:59:58','738',0.00,0.00,'738','2023-03-09 06:57:44','738','2023-03-09 06:58:11',10,0),('1','208',257988,'DAILY SHIFTS','2023-03-09','2023-03-09 06:59:01','2023-03-10 06:59:01','738',0.00,0.00,'738','2023-03-09 23:07:08','738','2023-03-09 23:07:54',10,0),('1','208',257989,'DAILY SHIFTS','2023-03-10','2023-03-10 05:56:45','2023-03-11 05:56:45','738',0.00,0.00,'738','2023-03-10 12:33:12','738','2023-03-10 12:33:38',10,0),('1','208',257990,'DAILY SHIFTS','2023-03-10','2023-03-10 12:34:11','2023-03-11 12:34:11','738',0.00,0.00,'738','2023-03-10 21:07:28','738','2023-03-10 21:09:11',10,0),('1','208',257991,'DAILY SHIFTS','2023-03-11','2023-03-11 06:12:02','2023-03-12 06:12:02','738',0.00,0.00,'738','2023-03-11 21:19:00','738','2023-03-11 21:19:54',10,0),('1','208',257992,'DAILY SHIFTS','2023-03-12','2023-03-12 07:38:43','2023-03-13 07:38:43','738',0.00,0.00,'738','2023-03-12 16:31:35','738','2023-03-12 17:28:58',10,0),('1','208',257993,'DAILY SHIFTS','2023-03-12','2023-03-12 17:29:21','2023-03-13 17:29:21','738',0.00,0.00,'738','2023-03-12 20:21:15','738','2023-03-12 21:51:35',10,0),('1','208',257994,'DAILY SHIFTS','2023-03-13','2023-03-13 07:32:29','2023-03-14 07:32:29','738',0.00,0.00,'738','2023-03-13 20:55:35','738','2023-03-13 20:56:11',10,0),('1','208',257995,'DAILY SHIFTS','2023-03-14','2023-03-14 07:28:53','2023-03-15 07:28:53','738',0.00,0.00,'738','2023-03-14 21:43:56','738','2023-03-14 21:44:29',10,0),('1','208',257996,'DAILY SHIFTS','2023-03-15','2023-03-15 07:33:15','2023-03-16 07:33:15','738',0.00,0.00,'738','2023-03-15 15:33:44','738','2023-03-15 15:34:05',10,0),('1','208',257997,'DAILY SHIFTS','2023-03-15','2023-03-15 22:14:47','2023-03-16 22:14:47','738',0.00,0.00,'738','2023-03-15 22:19:11','738','2023-03-15 22:19:30',10,0),('1','208',257998,'DAILY SHIFTS','2023-03-16','2023-03-16 06:06:00','2023-03-17 06:06:00','738',0.00,0.00,'738','2023-03-16 19:39:14','738','2023-03-16 19:41:13',10,0),('1','208',257999,'DAILY SHIFTS','2023-03-17','2023-03-17 06:49:59','2023-03-18 06:49:59','738',0.00,0.00,'738','2023-03-17 19:45:50','738','2023-03-17 19:46:18',10,0),('1','208',258000,'DAILY SHIFTS','2023-03-19','2023-03-19 06:23:07','2023-03-20 06:23:07','738',0.00,0.00,'738','2023-03-19 18:37:43','738','2023-03-19 18:38:19',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905645 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','208','1038','253435',4834144,'3072','479',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','253699',4838647,'3072','479',0.00,150.09,0.00,0.00,150.09,85251.12,0.00,0.00,0.00),('1','208','1038','253699',4838648,'3076','479',0.00,225.20,0.00,0.00,225.20,127913.60,0.00,0.00,0.00),('1','208','1038','253699',4838649,'3077','479',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','253699',4838650,'3078','479',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','253947',4843006,'3072','479',150.09,150.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','253947',4843007,'3076','479',225.20,225.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','253947',4843008,'3077','479',0.00,361.75,0.00,0.00,361.75,205474.00,0.00,0.00,0.00),('1','208','1038','253947',4843009,'3078','479',0.00,208.18,0.00,0.00,208.18,118246.24,0.00,0.00,0.00),('1','208','1038','254280',4848735,'3072','479',150.09,150.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','254280',4848736,'3076','479',225.20,225.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','254280',4848737,'3077','479',361.75,361.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','254280',4848738,'3078','479',208.18,208.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','254283',4848753,'3072','479',150.09,150.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','254283',4848754,'3076','479',225.20,230.48,0.00,0.00,5.28,2999.04,0.00,0.00,0.00),('1','208','1038','254283',4848755,'3077','479',361.75,651.54,0.00,0.00,289.79,164600.72,0.00,0.00,0.00),('1','208','1038','254283',4848756,'3078','479',208.18,351.35,0.00,0.00,143.17,81320.56,0.00,0.00,0.00),('1','208','1038','254446',4851721,'3072','479',150.09,458.08,0.00,0.00,307.99,174938.32,0.00,0.00,0.00),('1','208','1038','254446',4851722,'3076','479',230.48,553.17,0.00,0.00,322.69,183287.92,0.00,0.00,0.00),('1','208','1038','254446',4851723,'3077','479',651.54,651.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','254446',4851724,'3078','479',351.35,351.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','254759',4856805,'3072','479',458.08,458.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','254759',4856806,'3076','479',553.17,553.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','254759',4856807,'3077','479',651.54,1068.41,0.00,0.00,416.87,236782.16,0.00,0.00,0.00),('1','208','1038','254759',4856808,'3078','479',351.35,710.79,0.00,0.00,359.44,204161.92,0.00,0.00,0.00),('1','208','1038','254990',4860815,'3072','479',457.21,905.97,0.00,0.00,448.76,254895.68,0.00,0.00,0.00),('1','208','1038','254990',4860816,'3076','479',701.33,978.44,0.00,0.00,277.11,157398.48,0.00,0.00,0.00),('1','208','1038','254990',4860817,'3077','479',1195.96,1195.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','254990',4860818,'3078','479',1228.25,1228.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','255195',4864539,'3072','479',905.97,905.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','255195',4864540,'3076','479',978.44,988.83,0.00,0.00,10.39,5901.52,0.00,0.00,0.00),('1','208','1038','255195',4864541,'3077','479',1195.96,1573.80,0.00,0.00,377.84,214613.12,0.00,0.00,0.00),('1','208','1038','255195',4864542,'3078','479',1228.25,1506.59,0.00,0.00,278.34,158097.12,0.00,0.00,0.00),('1','208','1038','255487',4869403,'3072','479',905.97,1443.89,0.00,0.00,537.92,305538.56,0.00,0.00,0.00),('1','208','1038','255487',4869404,'3076','479',988.83,1333.32,0.00,0.00,344.49,195670.32,0.00,0.00,0.00),('1','208','1038','255487',4869405,'3077','479',1573.80,1573.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','255487',4869406,'3078','479',1506.59,1506.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','255729',4873444,'3072','479',1443.89,1449.18,0.00,0.00,5.29,3004.72,0.00,0.00,0.00),('1','208','1038','255729',4873445,'3076','479',1333.32,1333.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','255729',4873446,'3077','479',1573.80,2123.32,0.00,0.00,549.52,312127.36,0.00,0.00,0.00),('1','208','1038','255729',4873447,'3078','479',1506.59,1817.71,0.00,0.00,311.12,176716.16,0.00,0.00,0.00),('1','208','1038','255987',4877603,'3072','479',1449.18,1867.71,0.00,0.00,418.53,237725.04,0.00,0.00,0.00),('1','208','1038','255987',4877604,'3076','479',1333.32,1752.79,0.00,0.00,419.47,238258.96,0.00,0.00,0.00),('1','208','1038','255987',4877605,'3077','479',2123.32,2123.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','255987',4877606,'3078','479',1817.71,1817.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','256238',4881520,'3072','479',1867.71,1867.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','256238',4881521,'3076','479',1752.79,1758.79,0.00,0.00,6.00,3408.00,0.00,0.00,0.00),('1','208','1038','256238',4881522,'3077','479',2123.32,2470.81,0.00,0.00,347.49,197374.32,0.00,0.00,0.00),('1','208','1038','256238',4881523,'3078','479',1817.71,2175.54,0.00,0.00,357.83,203247.44,0.00,0.00,0.00),('1','208','1038','256546',4886856,'3072','479',1867.71,2222.43,0.00,0.00,354.72,201480.96,0.00,0.00,0.00),('1','208','1038','256546',4886857,'3076','479',1758.79,2039.87,0.00,0.00,281.08,159653.44,0.00,0.00,0.00),('1','208','1038','256546',4886858,'3077','479',2470.81,2470.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','256546',4886859,'3078','479',2175.54,2175.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','256737',4890079,'3072','479',2222.43,2222.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','256737',4890080,'3076','479',2039.87,2050.17,0.00,0.00,10.30,5850.40,0.00,0.00,0.00),('1','208','1038','256737',4890081,'3077','479',2470.81,2986.39,0.00,0.00,515.58,292849.44,0.00,0.00,0.00),('1','208','1038','256737',4890082,'3078','479',2175.54,2669.17,0.00,0.00,493.63,280381.84,0.00,0.00,0.00),('1','208','1038','257008',4894713,'3072','479',2222.43,2598.58,0.00,0.00,376.15,213653.20,0.00,0.00,0.00),('1','208','1038','257008',4894714,'3076','479',2050.17,2415.94,0.00,0.00,365.77,207757.36,0.00,0.00,0.00),('1','208','1038','257008',4894715,'3077','479',2986.39,3051.90,0.00,0.00,65.51,37209.68,0.00,0.00,0.00),('1','208','1038','257008',4894716,'3078','479',2669.17,2716.90,0.00,0.00,47.73,27110.64,0.00,0.00,0.00),('1','208','1038','257296',4900094,'3072','479',2598.58,2722.74,0.00,0.00,124.16,70522.88,0.00,0.00,0.00),('1','208','1038','257296',4900095,'3076','479',2415.94,2535.93,0.00,0.00,119.99,68154.32,0.00,0.00,0.00),('1','208','1038','257296',4900096,'3077','479',3051.90,3422.65,0.00,0.00,370.75,210586.00,0.00,0.00,0.00),('1','208','1038','257296',4900097,'3078','479',2716.90,3066.98,0.00,0.00,350.08,198845.44,0.00,0.00,0.00),('1','208','1038','257507',4903669,'3072','479',2722.74,3283.28,0.00,0.00,560.54,318386.72,0.00,0.00,0.00),('1','208','1038','257507',4903670,'3076','479',2535.93,3061.13,0.00,0.00,525.20,298313.60,0.00,0.00,0.00),('1','208','1038','257507',4903671,'3077','479',3422.65,3709.71,0.00,0.00,287.06,163050.08,0.00,0.00,0.00),('1','208','1038','257507',4903672,'3078','479',3066.98,3302.18,0.00,0.00,235.20,133593.60,0.00,0.00,0.00),('1','208','1038','257508',4903673,'3072','479',3283.28,3468.72,0.00,0.00,185.44,105329.92,0.00,0.00,0.00),('1','208','1038','257508',4903674,'3076','479',3061.13,3214.68,0.00,0.00,153.55,87216.40,0.00,0.00,0.00),('1','208','1038','257508',4903675,'3077','479',3709.71,4095.48,0.00,0.00,385.77,219117.36,0.00,0.00,0.00),('1','208','1038','257508',4903676,'3078','479',3302.18,3644.87,0.00,0.00,342.69,194647.92,0.00,0.00,0.00),('1','208','1038','257509',4903677,'3072','479',3468.72,4232.55,0.00,0.00,763.83,433855.44,0.00,0.00,0.00),('1','208','1038','257509',4903678,'3076','479',3214.68,3932.92,0.00,0.00,718.24,407960.32,0.00,0.00,0.00),('1','208','1038','257509',4903679,'3077','479',4095.48,4205.39,0.00,0.00,109.91,62428.88,0.00,0.00,0.00),('1','208','1038','257509',4903680,'3078','479',3644.87,3775.63,0.00,0.00,130.76,74271.68,0.00,0.00,0.00),('1','208','1038','257510',4903681,'3072','479',4232.55,4329.75,0.00,0.00,97.20,55209.60,0.00,0.00,0.00),('1','208','1038','257510',4903682,'3076','479',3932.92,4040.00,0.00,0.00,107.08,60821.44,0.00,0.00,0.00),('1','208','1038','257510',4903683,'3077','479',4205.39,4870.39,0.00,0.00,665.00,377720.00,0.00,0.00,0.00),('1','208','1038','257510',4903684,'3078','479',3775.63,4289.70,0.00,0.00,514.07,291991.76,0.00,0.00,0.00),('1','208','1038','257511',4903685,'3072','479',4329.75,4674.98,0.00,0.00,345.23,196090.64,0.00,0.00,0.00),('1','208','1038','257511',4903686,'3076','479',4040.00,4552.10,0.00,0.00,512.10,290872.80,0.00,0.00,0.00),('1','208','1038','257511',4903687,'3077','479',4870.39,5134.71,0.00,0.00,264.32,150133.76,0.00,0.00,0.00),('1','208','1038','257511',4903688,'3078','479',4289.70,4483.62,0.00,0.00,193.92,110146.56,0.00,0.00,0.00),('1','208','1038','257512',4903689,'3072','479',4674.98,4773.52,0.00,0.00,98.54,55970.72,0.00,0.00,0.00),('1','208','1038','257512',4903690,'3076','479',4552.10,4668.17,0.00,0.00,116.07,65927.76,0.00,0.00,0.00),('1','208','1038','257512',4903691,'3077','479',5134.71,5779.75,0.00,0.00,645.04,366382.72,0.00,0.00,0.00),('1','208','1038','257512',4903692,'3078','479',4483.62,4984.19,0.00,0.00,500.57,284323.76,0.00,0.00,0.00),('1','208','1038','257513',4903693,'3072','479',4773.52,5349.13,0.00,0.00,575.61,326946.48,0.00,0.00,0.00),('1','208','1038','257513',4903694,'3076','479',4668.17,5181.50,0.00,0.00,513.33,291571.44,0.00,0.00,0.00),('1','208','1038','257513',4903695,'3077','479',5779.75,5941.78,0.00,0.00,162.03,92033.04,0.00,0.00,0.00),('1','208','1038','257513',4903696,'3078','479',4984.19,5183.91,0.00,0.00,199.72,113440.96,0.00,0.00,0.00),('1','208','1038','257514',4903697,'3072','479',5349.13,5456.67,0.00,0.00,107.54,61082.72,0.00,0.00,0.00),('1','208','1038','257514',4903698,'3076','479',5181.50,5336.22,0.00,0.00,154.72,87880.96,0.00,0.00,0.00),('1','208','1038','257514',4903699,'3077','479',5941.78,6688.64,0.00,0.00,746.86,424216.48,0.00,0.00,0.00),('1','208','1038','257514',4903700,'3078','479',5183.91,6038.57,0.00,0.00,854.66,485446.88,0.00,0.00,0.00),('1','208','1038','257515',4903701,'3072','479',5456.67,5640.46,0.00,0.00,183.79,104392.72,0.00,0.00,0.00),('1','208','1038','257515',4903702,'3076','479',5336.22,5462.44,0.00,0.00,126.22,71692.96,0.00,0.00,0.00),('1','208','1038','257515',4903703,'3077','479',6688.64,6688.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257515',4903704,'3078','479',6038.57,6038.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257516',4903705,'3072','479',5640.46,5640.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257516',4903706,'3076','479',5462.44,5462.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257516',4903707,'3077','479',6688.64,6688.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257516',4903708,'3078','479',6038.57,6038.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257517',4903709,'3072','479',5640.46,5775.82,0.00,0.00,135.36,76884.48,0.00,0.00,0.00),('1','208','1038','257517',4903710,'3076','479',5462.44,5571.29,0.00,0.00,108.85,61826.80,0.00,0.00,0.00),('1','208','1038','257517',4903711,'3077','479',6688.64,7538.12,0.00,0.00,849.48,482504.64,0.00,0.00,0.00),('1','208','1038','257517',4903712,'3078','479',6038.57,6585.90,0.00,0.00,547.33,310883.44,0.00,0.00,0.00),('1','208','1038','257518',4903713,'3072','479',5775.82,6240.40,0.00,0.00,464.58,263881.44,0.00,0.00,0.00),('1','208','1038','257518',4903714,'3076','479',5571.29,6183.38,0.00,0.00,612.09,347667.12,0.00,0.00,0.00),('1','208','1038','257518',4903715,'3077','479',7538.12,7623.18,0.00,0.00,85.06,48314.08,0.00,0.00,0.00),('1','208','1038','257518',4903716,'3078','479',6585.90,6662.29,0.00,0.00,76.39,43389.52,0.00,0.00,0.00),('1','208','1038','257519',4903717,'3072','479',6240.40,6304.09,0.00,0.00,63.69,36175.92,0.00,0.00,0.00),('1','208','1038','257519',4903718,'3076','479',6183.38,6229.69,0.00,0.00,46.31,26304.08,0.00,0.00,0.00),('1','208','1038','257519',4903719,'3077','479',7623.18,8076.53,0.00,0.00,453.35,257502.80,0.00,0.00,0.00),('1','208','1038','257519',4903720,'3078','479',6662.29,7122.29,0.00,0.00,460.00,261280.00,0.00,0.00,0.00),('1','208','1038','257520',4903721,'3072','479',6304.09,6726.57,0.00,0.00,422.48,239968.64,0.00,0.00,0.00),('1','208','1038','257520',4903722,'3076','479',6229.69,6610.22,0.00,0.00,380.53,216141.04,0.00,0.00,0.00),('1','208','1038','257520',4903723,'3077','479',8076.53,8202.18,0.00,0.00,125.65,71369.20,0.00,0.00,0.00),('1','208','1038','257520',4903724,'3078','479',7122.29,7296.81,0.00,0.00,174.52,99127.36,0.00,0.00,0.00),('1','208','1038','257521',4903725,'3072','479',6726.57,6781.23,0.00,0.00,54.66,31046.88,0.00,0.00,0.00),('1','208','1038','257521',4903726,'3076','479',6610.22,6681.71,0.00,0.00,71.49,40606.32,0.00,0.00,0.00),('1','208','1038','257521',4903727,'3077','479',8202.18,8662.42,0.00,0.00,460.24,261416.32,0.00,0.00,0.00),('1','208','1038','257521',4903728,'3078','479',7296.81,7808.24,0.00,0.00,511.43,290492.24,0.00,0.00,0.00),('1','208','1038','257522',4903729,'3072','479',6781.23,7153.25,0.00,0.00,372.02,211307.36,0.00,0.00,0.00),('1','208','1038','257522',4903730,'3076','479',6681.71,7117.90,0.00,0.00,436.19,247755.92,0.00,0.00,0.00),('1','208','1038','257522',4903731,'3077','479',8662.42,8771.48,0.00,0.00,109.06,61946.08,0.00,0.00,0.00),('1','208','1038','257522',4903732,'3078','479',7808.24,7940.57,0.00,0.00,132.33,75163.44,0.00,0.00,0.00),('1','208','1038','257523',4903733,'3072','479',7153.25,7587.62,0.00,0.00,434.37,246722.16,0.00,0.00,0.00),('1','208','1038','257523',4903734,'3076','479',7117.90,7449.41,0.00,0.00,331.51,188297.68,0.00,0.00,0.00),('1','208','1038','257523',4903735,'3077','479',8771.48,8887.57,0.00,0.00,116.09,65939.12,0.00,0.00,0.00),('1','208','1038','257523',4903736,'3078','479',7940.57,8025.69,0.00,0.00,85.12,48348.16,0.00,0.00,0.00),('1','208','1038','257524',4903737,'3072','479',7587.62,7896.27,0.00,0.00,308.65,175313.20,0.00,0.00,0.00),('1','208','1038','257524',4903738,'3076','479',7449.41,7998.91,0.00,0.00,549.50,312116.00,0.00,0.00,0.00),('1','208','1038','257524',4903739,'3077','479',8887.57,8961.81,0.00,0.00,74.24,42168.32,0.00,0.00,0.00),('1','208','1038','257524',4903740,'3078','479',8025.69,8111.15,0.00,0.00,85.46,48541.28,0.00,0.00,0.00),('1','208','1038','257525',4903741,'3072','479',7896.27,8357.21,0.00,0.00,460.94,261813.92,0.00,0.00,0.00),('1','208','1038','257525',4903742,'3076','479',7998.91,8314.94,0.00,0.00,316.03,179505.04,0.00,0.00,0.00),('1','208','1038','257525',4903743,'3077','479',8961.81,9078.98,0.00,0.00,117.17,66552.56,0.00,0.00,0.00),('1','208','1038','257525',4903744,'3078','479',8111.15,8198.79,0.00,0.00,87.64,49779.52,0.00,0.00,0.00),('1','208','1038','257526',4903745,'3072','479',8357.21,8684.74,0.00,0.00,327.53,186037.04,0.00,0.00,0.00),('1','208','1038','257526',4903746,'3076','479',8314.94,8641.33,0.00,0.00,326.39,185389.52,0.00,0.00,0.00),('1','208','1038','257526',4903747,'3077','479',9078.98,9228.69,0.00,0.00,149.71,85035.28,0.00,0.00,0.00),('1','208','1038','257526',4903748,'3078','479',8198.79,8299.66,0.00,0.00,100.87,57294.16,0.00,0.00,0.00),('1','208','1038','257527',4903749,'3072','479',8684.74,9179.94,0.00,0.00,495.20,281273.60,0.00,0.00,0.00),('1','208','1038','257527',4903750,'3076','479',8641.33,9014.07,0.00,0.00,372.74,211716.32,0.00,0.00,0.00),('1','208','1038','257527',4903751,'3077','479',9228.69,9311.82,0.00,0.00,83.13,47217.84,0.00,0.00,0.00),('1','208','1038','257527',4903752,'3078','479',8299.66,8412.62,0.00,0.00,112.96,64161.28,0.00,0.00,0.00),('1','208','1038','257528',4903753,'3072','479',9179.94,9644.79,0.00,0.00,464.85,264034.80,0.00,0.00,0.00),('1','208','1038','257528',4903754,'3076','479',9014.07,9531.44,0.00,0.00,517.37,293866.16,0.00,0.00,0.00),('1','208','1038','257528',4903755,'3077','479',9311.82,9419.59,0.00,0.00,107.77,61213.36,0.00,0.00,0.00),('1','208','1038','257528',4903756,'3078','479',8412.62,8520.29,0.00,0.00,107.67,61156.56,0.00,0.00,0.00),('1','208','1038','257529',4903757,'3072','479',9644.79,10097.96,0.00,0.00,453.17,257400.56,0.00,0.00,0.00),('1','208','1038','257529',4903758,'3076','479',9531.44,9922.21,0.00,0.00,390.77,221957.36,0.00,0.00,0.00),('1','208','1038','257529',4903759,'3077','479',9419.59,9562.99,0.00,0.00,143.40,81451.20,0.00,0.00,0.00),('1','208','1038','257529',4903760,'3078','479',8520.29,8632.14,0.00,0.00,111.85,63530.80,0.00,0.00,0.00),('1','208','1038','257530',4903761,'3072','479',10097.96,10481.38,0.00,0.00,383.42,217782.56,0.00,0.00,0.00),('1','208','1038','257530',4903762,'3076','479',9922.21,10222.16,0.00,0.00,299.95,170371.60,0.00,0.00,0.00),('1','208','1038','257530',4903763,'3077','479',9562.99,9807.07,0.00,0.00,244.08,138637.44,0.00,0.00,0.00),('1','208','1038','257530',4903764,'3078','479',8632.14,8934.98,0.00,0.00,302.84,172013.12,0.00,0.00,0.00),('1','208','1038','257531',4903765,'3072','479',10481.38,10544.79,0.00,0.00,63.41,36016.88,0.00,0.00,0.00),('1','208','1038','257531',4903766,'3076','479',10222.16,10319.32,0.00,0.00,97.16,55186.88,0.00,0.00,0.00),('1','208','1038','257531',4903767,'3077','479',9807.07,10371.57,0.00,0.00,564.50,320636.00,0.00,0.00,0.00),('1','208','1038','257531',4903768,'3078','479',8934.98,9407.99,0.00,0.00,473.01,268669.68,0.00,0.00,0.00),('1','208','1038','257532',4903769,'3072','479',10544.79,11125.65,0.00,0.00,580.86,329928.48,0.00,0.00,0.00),('1','208','1038','257532',4903770,'3076','479',10319.32,10589.60,0.00,0.00,270.28,153519.04,0.00,0.00,0.00),('1','208','1038','257532',4903771,'3077','479',10371.57,10609.30,0.00,0.00,237.73,135030.64,0.00,0.00,0.00),('1','208','1038','257532',4903772,'3078','479',9407.99,9613.07,0.00,0.00,205.08,116485.44,0.00,0.00,0.00),('1','208','1038','257533',4903773,'3072','479',11125.65,11214.83,0.00,0.00,89.18,50654.24,0.00,0.00,0.00),('1','208','1038','257533',4903774,'3076','479',10589.60,10657.29,0.00,0.00,67.69,38447.92,0.00,0.00,0.00),('1','208','1038','257533',4903775,'3077','479',10609.30,11086.97,0.00,0.00,477.67,271316.56,0.00,0.00,0.00),('1','208','1038','257533',4903776,'3078','479',9613.07,10077.51,0.00,0.00,464.44,263801.92,0.00,0.00,0.00),('1','208','1038','257534',4903777,'3072','479',11214.83,11727.59,0.00,0.00,512.76,291247.68,0.00,0.00,0.00),('1','208','1038','257534',4903778,'3076','479',10657.29,11028.06,0.00,0.00,370.77,210597.36,0.00,0.00,0.00),('1','208','1038','257534',4903779,'3077','479',11086.97,11147.11,0.00,0.00,60.14,34159.52,0.00,0.00,0.00),('1','208','1038','257534',4903780,'3078','479',10077.51,10225.37,0.00,0.00,147.86,83984.48,0.00,0.00,0.00),('1','208','1038','257535',4903781,'3072','479',11727.59,12055.33,0.00,0.00,327.74,186156.32,0.00,0.00,0.00),('1','208','1038','257535',4903782,'3076','479',11028.06,11456.91,0.00,0.00,428.85,243586.80,0.00,0.00,0.00),('1','208','1038','257535',4903783,'3077','479',11147.11,11298.34,0.00,0.00,151.23,85898.64,0.00,0.00,0.00),('1','208','1038','257535',4903784,'3078','479',10225.37,10377.36,0.00,0.00,151.99,86330.32,0.00,0.00,0.00),('1','208','1038','257536',4903785,'3072','479',12055.33,12708.40,0.00,0.00,653.07,370943.76,0.00,0.00,0.00),('1','208','1038','257536',4903786,'3076','479',11456.91,12142.70,0.00,0.00,685.79,389528.72,0.00,0.00,0.00),('1','208','1038','257536',4903787,'3077','479',11298.34,11461.71,0.00,0.00,163.37,92794.16,0.00,0.00,0.00),('1','208','1038','257536',4903788,'3078','479',10377.36,10524.38,0.00,0.00,147.02,83507.36,0.00,0.00,0.00),('1','208','1038','257537',4903789,'3072','479',12708.40,13172.54,0.00,0.00,464.14,263631.52,0.00,0.00,0.00),('1','208','1038','257537',4903790,'3076','479',12142.70,12477.55,0.00,0.00,334.85,190194.80,0.00,0.00,0.00),('1','208','1038','257537',4903791,'3077','479',11461.71,11620.74,0.00,0.00,159.03,90329.04,0.00,0.00,0.00),('1','208','1038','257537',4903792,'3078','479',10524.38,10610.98,0.00,0.00,86.60,49188.80,0.00,0.00,0.00),('1','208','1038','257538',4903793,'3072','479',13172.54,13621.41,0.00,0.00,448.87,254958.16,0.00,0.00,0.00),('1','208','1038','257538',4903794,'3076','479',12477.55,12952.54,0.00,0.00,474.99,269794.32,0.00,0.00,0.00),('1','208','1038','257538',4903795,'3077','479',11620.74,11802.44,0.00,0.00,181.70,103205.60,0.00,0.00,0.00),('1','208','1038','257538',4903796,'3078','479',10610.98,10827.28,0.00,0.00,216.30,122858.40,0.00,0.00,0.00),('1','208','1038','257539',4903797,'3072','479',13621.41,13966.43,0.00,0.00,345.02,195971.36,0.00,0.00,0.00),('1','208','1038','257539',4903798,'3076','479',12952.54,13430.78,0.00,0.00,478.24,271640.32,0.00,0.00,0.00),('1','208','1038','257539',4903799,'3077','479',11802.44,12080.49,0.00,0.00,278.05,157932.40,0.00,0.00,0.00),('1','208','1038','257539',4903800,'3078','479',10827.28,11053.86,0.00,0.00,226.58,128697.44,0.00,0.00,0.00),('1','208','1038','257540',4903801,'3072','479',13966.43,14519.47,0.00,0.00,553.04,314126.72,0.00,0.00,0.00),('1','208','1038','257540',4903802,'3076','479',13430.78,13930.18,0.00,0.00,499.40,283659.20,0.00,0.00,0.00),('1','208','1038','257540',4903803,'3077','479',12080.49,12207.28,0.00,0.00,126.79,72016.72,0.00,0.00,0.00),('1','208','1038','257540',4903804,'3078','479',11053.86,11217.49,0.00,0.00,163.63,92941.84,0.00,0.00,0.00),('1','208','1038','257541',4903805,'3072','479',14519.47,15102.90,0.00,0.00,583.43,331388.24,0.00,0.00,0.00),('1','208','1038','257541',4903806,'3076','479',13930.18,14406.69,0.00,0.00,476.51,270657.68,0.00,0.00,0.00),('1','208','1038','257541',4903807,'3077','479',12207.28,12369.75,0.00,0.00,162.47,92282.96,0.00,0.00,0.00),('1','208','1038','257541',4903808,'3078','479',11217.49,11304.60,0.00,0.00,87.11,49478.48,0.00,0.00,0.00),('1','208','1038','257542',4903809,'3072','479',15102.90,15723.51,0.00,0.00,620.61,352506.48,0.00,0.00,0.00),('1','208','1038','257542',4903810,'3076','479',14406.69,15061.59,0.00,0.00,654.90,371983.20,0.00,0.00,0.00),('1','208','1038','257542',4903811,'3077','479',12369.75,12456.08,0.00,0.00,86.33,49035.44,0.00,0.00,0.00),('1','208','1038','257542',4903812,'3078','479',11304.60,11462.91,0.00,0.00,158.31,89920.08,0.00,0.00,0.00),('1','208','1038','257543',4903813,'3072','479',15723.51,16355.10,0.00,0.00,631.59,358743.12,0.00,0.00,0.00),('1','208','1038','257543',4903814,'3076','479',15061.59,15490.45,0.00,0.00,428.86,243592.48,0.00,0.00,0.00),('1','208','1038','257543',4903815,'3077','479',12456.08,12609.25,0.00,0.00,153.17,87000.56,0.00,0.00,0.00),('1','208','1038','257543',4903816,'3078','479',11462.91,11606.40,0.00,0.00,143.49,81502.32,0.00,0.00,0.00),('1','208','1038','257544',4903817,'3072','479',16355.10,17022.39,0.00,0.00,667.29,379020.72,0.00,0.00,0.00),('1','208','1038','257544',4903818,'3076','479',15490.45,16042.61,0.00,0.00,552.16,313626.88,0.00,0.00,0.00),('1','208','1038','257544',4903819,'3077','479',12609.25,12735.60,0.00,0.00,126.35,71766.80,0.00,0.00,0.00),('1','208','1038','257544',4903820,'3078','479',11606.40,11770.74,0.00,0.00,164.34,93345.12,0.00,0.00,0.00),('1','208','1038','257545',4903821,'3072','479',17022.39,17489.78,0.00,0.00,467.39,265477.52,0.00,0.00,0.00),('1','208','1038','257545',4903822,'3076','479',16042.61,16508.60,0.00,0.00,465.99,264682.32,0.00,0.00,0.00),('1','208','1038','257545',4903823,'3077','479',12735.60,12838.99,0.00,0.00,103.39,58725.52,0.00,0.00,0.00),('1','208','1038','257545',4903824,'3078','479',11770.74,11862.89,0.00,0.00,92.15,52341.20,0.00,0.00,0.00),('1','208','1038','257546',4903825,'3072','479',17489.78,17826.55,0.00,0.00,336.77,215532.80,0.00,0.00,0.00),('1','208','1038','257546',4903826,'3076','479',16508.60,17050.64,0.00,0.00,542.04,346905.60,0.00,0.00,0.00),('1','208','1038','257546',4903827,'3077','479',12838.99,12961.47,0.00,0.00,122.48,78387.20,0.00,0.00,0.00),('1','208','1038','257546',4903828,'3078','479',11862.89,12024.83,0.00,0.00,161.94,103641.60,0.00,0.00,0.00),('1','208','1038','257547',4903829,'3072','479',17826.55,18154.00,0.00,0.00,327.45,209568.00,0.00,0.00,0.00),('1','208','1038','257547',4903830,'3076','479',17050.64,17434.51,0.00,0.00,383.87,245676.80,0.00,0.00,0.00),('1','208','1038','257547',4903831,'3077','479',12961.47,13067.85,0.00,0.00,106.38,68083.20,0.00,0.00,0.00),('1','208','1038','257547',4903832,'3078','479',12024.83,12190.54,0.00,0.00,165.71,106054.40,0.00,0.00,0.00),('1','208','1038','257548',4903833,'3072','479',18154.00,18577.24,0.00,0.00,423.24,270873.60,0.00,0.00,0.00),('1','208','1038','257548',4903834,'3076','479',17434.51,17915.96,0.00,0.00,481.45,308128.00,0.00,0.00,0.00),('1','208','1038','257548',4903835,'3077','479',13067.85,13120.11,0.00,0.00,52.26,33446.40,0.00,0.00,0.00),('1','208','1038','257548',4903836,'3078','479',12190.54,12255.13,0.00,0.00,64.59,41337.60,0.00,0.00,0.00),('1','208','1038','257549',4903837,'3072','479',18577.24,19006.88,0.00,0.00,429.64,274969.60,0.00,0.00,0.00),('1','208','1038','257549',4903838,'3076','479',17915.96,18375.04,0.00,0.00,459.08,293811.20,0.00,0.00,0.00),('1','208','1038','257549',4903839,'3077','479',13120.11,13209.78,0.00,0.00,89.67,57388.80,0.00,0.00,0.00),('1','208','1038','257549',4903840,'3078','479',12255.13,12362.39,0.00,0.00,107.26,68646.40,0.00,0.00,0.00),('1','208','1038','257550',4903841,'3072','479',19006.88,19497.25,0.00,0.00,490.37,313836.80,0.00,0.00,0.00),('1','208','1038','257550',4903842,'3076','479',18375.04,18829.15,0.00,0.00,454.11,290630.40,0.00,0.00,0.00),('1','208','1038','257550',4903843,'3077','479',13209.78,13362.62,0.00,0.00,152.84,97817.60,0.00,0.00,0.00),('1','208','1038','257550',4903844,'3078','479',12362.39,12527.89,0.00,0.00,165.50,105920.00,0.00,0.00,0.00),('1','208','1038','257551',4903845,'3072','479',19497.25,19841.47,0.00,0.00,344.22,220300.80,0.00,0.00,0.00),('1','208','1038','257551',4903846,'3076','479',18829.15,19264.28,0.00,0.00,435.13,278483.20,0.00,0.00,0.00),('1','208','1038','257551',4903847,'3077','479',13362.62,13525.23,0.00,0.00,162.61,104070.40,0.00,0.00,0.00),('1','208','1038','257551',4903848,'3078','479',12527.89,12631.23,0.00,0.00,103.34,66137.60,0.00,0.00,0.00),('1','208','1038','257552',4903849,'3072','479',19841.47,20306.49,0.00,0.00,465.02,316213.60,0.00,0.00,0.00),('1','208','1038','257552',4903850,'3076','479',19264.28,19691.79,0.00,0.00,427.51,290706.80,0.00,0.00,0.00),('1','208','1038','257552',4903851,'3077','479',13525.23,13705.56,0.00,0.00,180.33,122624.40,0.00,0.00,0.00),('1','208','1038','257552',4903852,'3078','479',12631.23,12777.48,0.00,0.00,146.25,99450.00,0.00,0.00,0.00),('1','208','1038','257553',4903853,'3072','479',20306.49,20763.47,0.00,0.00,456.98,310746.40,0.00,0.00,0.00),('1','208','1038','257553',4903854,'3076','479',19691.79,20228.21,0.00,0.00,536.42,364765.60,0.00,0.00,0.00),('1','208','1038','257553',4903855,'3077','479',13705.56,14181.39,0.00,0.00,475.83,323564.40,0.00,0.00,0.00),('1','208','1038','257553',4903856,'3078','479',12777.48,13013.41,0.00,0.00,235.93,160432.40,0.00,0.00,0.00),('1','208','1038','257554',4903857,'3072','479',20763.47,21196.67,0.00,0.00,433.20,294576.00,0.00,0.00,0.00),('1','208','1038','257554',4903858,'3076','479',20228.21,20696.68,0.00,0.00,468.47,318559.60,0.00,0.00,0.00),('1','208','1038','257554',4903859,'3077','479',14181.39,14349.23,0.00,0.00,167.84,114131.20,0.00,0.00,0.00),('1','208','1038','257554',4903860,'3078','479',13013.41,13201.91,0.00,0.00,188.50,128180.00,0.00,0.00,0.00),('1','208','1038','257555',4903861,'3072','479',21196.67,21452.26,0.00,0.00,255.59,163577.60,0.00,0.00,0.00),('1','208','1038','257555',4903862,'3076','479',20696.68,21058.91,0.00,0.00,362.23,231827.20,0.00,0.00,0.00),('1','208','1038','257555',4903863,'3077','479',14349.23,14764.45,0.00,0.00,415.22,265740.80,0.00,0.00,0.00),('1','208','1038','257555',4903864,'3078','479',13201.91,13484.09,0.00,0.00,282.18,180595.20,0.00,0.00,0.00),('1','208','1038','257556',4903865,'3072','479',21452.26,21865.21,0.00,0.00,412.95,264288.00,0.00,0.00,0.00),('1','208','1038','257556',4903866,'3076','479',21058.91,21436.95,0.00,0.00,378.04,241945.60,0.00,0.00,0.00),('1','208','1038','257556',4903867,'3077','479',14764.45,14820.59,0.00,0.00,56.14,35929.60,0.00,0.00,0.00),('1','208','1038','257556',4903868,'3078','479',13484.09,13587.80,0.00,0.00,103.71,66374.40,0.00,0.00,0.00),('1','208','1038','257557',4903869,'3072','479',21865.21,21865.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257557',4903870,'3076','479',21436.95,21438.51,0.00,0.00,1.56,998.40,0.00,0.00,0.00),('1','208','1038','257557',4903871,'3077','479',14820.59,14875.37,0.00,0.00,54.78,35059.20,0.00,0.00,0.00),('1','208','1038','257557',4903872,'3078','479',13587.80,13648.27,0.00,0.00,60.47,38700.80,0.00,0.00,0.00),('1','208','1038','257558',4903873,'3072','479',21865.21,22232.11,0.00,0.00,366.90,234816.00,0.00,0.00,0.00),('1','208','1038','257558',4903874,'3076','479',21438.51,21722.68,0.00,0.00,284.17,181868.80,0.00,0.00,0.00),('1','208','1038','257558',4903875,'3077','479',14875.37,15240.54,0.00,0.00,365.17,233708.80,0.00,0.00,0.00),('1','208','1038','257558',4903876,'3078','479',13648.27,13854.56,0.00,0.00,206.29,132025.60,0.00,0.00,0.00),('1','208','1038','257559',4903877,'3072','479',22232.11,22638.63,0.00,0.00,406.52,260172.80,0.00,0.00,0.00),('1','208','1038','257559',4903878,'3076','479',21722.68,22212.61,0.00,0.00,489.93,313555.20,0.00,0.00,0.00),('1','208','1038','257559',4903879,'3077','479',15240.54,15382.93,0.00,0.00,142.39,91129.60,0.00,0.00,0.00),('1','208','1038','257559',4903880,'3078','479',13854.56,14121.30,0.00,0.00,266.74,170713.60,0.00,0.00,0.00),('1','208','1038','257560',4903881,'3072','479',22638.63,23002.62,0.00,0.00,363.99,232953.60,0.00,0.00,0.00),('1','208','1038','257560',4903882,'3076','479',22212.61,22681.98,0.00,0.00,469.37,300396.80,0.00,0.00,0.00),('1','208','1038','257560',4903883,'3077','479',15382.93,15656.78,0.00,0.00,273.85,175264.00,0.00,0.00,0.00),('1','208','1038','257560',4903884,'3078','479',14121.30,14271.75,0.00,0.00,150.45,96288.00,0.00,0.00,0.00),('1','208','1038','257561',4903885,'3072','479',23002.62,23612.11,0.00,0.00,609.49,390073.60,0.00,0.00,0.00),('1','208','1038','257561',4903886,'3076','479',22681.98,23216.60,0.00,0.00,534.62,342156.80,0.00,0.00,0.00),('1','208','1038','257561',4903887,'3077','479',15656.78,15804.83,0.00,0.00,148.05,94752.00,0.00,0.00,0.00),('1','208','1038','257561',4903888,'3078','479',14271.75,14398.06,0.00,0.00,126.31,80838.40,0.00,0.00,0.00),('1','208','1038','257562',4903889,'3072','479',23612.11,23885.44,0.00,0.00,273.33,174931.20,0.00,0.00,0.00),('1','208','1038','257562',4903890,'3076','479',23216.60,23441.92,0.00,0.00,225.32,144204.80,0.00,0.00,0.00),('1','208','1038','257562',4903891,'3077','479',15804.83,16126.64,0.00,0.00,321.81,205958.40,0.00,0.00,0.00),('1','208','1038','257562',4903892,'3078','479',14398.06,14867.40,0.00,0.00,469.34,300377.60,0.00,0.00,0.00),('1','208','1038','257563',4903893,'3072','479',23885.44,24419.02,0.00,0.00,533.58,341491.20,0.00,0.00,0.00),('1','208','1038','257563',4903894,'3076','479',23441.92,23962.80,0.00,0.00,520.88,333363.20,0.00,0.00,0.00),('1','208','1038','257563',4903895,'3077','479',16126.64,16238.13,0.00,0.00,111.49,71353.60,0.00,0.00,0.00),('1','208','1038','257563',4903896,'3078','479',14867.40,14969.50,0.00,0.00,102.10,65344.00,0.00,0.00,0.00),('1','208','1038','257564',4903897,'3072','479',24419.02,24684.79,0.00,0.00,265.77,170092.80,0.00,0.00,0.00),('1','208','1038','257564',4903898,'3076','479',23962.80,24250.58,0.00,0.00,287.78,184179.20,0.00,0.00,0.00),('1','208','1038','257564',4903899,'3077','479',16238.13,16601.76,0.00,0.00,363.63,232723.20,0.00,0.00,0.00),('1','208','1038','257564',4903900,'3078','479',14969.50,15356.74,0.00,0.00,387.24,247833.60,0.00,0.00,0.00),('1','208','1038','257565',4903901,'3072','479',24684.79,25320.36,0.00,0.00,635.57,432187.60,0.00,0.00,0.00),('1','208','1038','257565',4903902,'3076','479',24250.58,24865.41,0.00,0.00,614.83,418084.40,0.00,0.00,0.00),('1','208','1038','257565',4903903,'3077','479',16601.76,16770.94,0.00,0.00,169.18,115042.40,0.00,0.00,0.00),('1','208','1038','257565',4903904,'3078','479',15356.74,15573.76,0.00,0.00,217.02,147573.60,0.00,0.00,0.00),('1','208','1038','257566',4903905,'3072','479',25320.36,25556.21,0.00,0.00,235.85,160378.00,0.00,0.00,0.00),('1','208','1038','257566',4903906,'3076','479',24865.41,25117.70,0.00,0.00,252.29,171557.20,0.00,0.00,0.00),('1','208','1038','257566',4903907,'3077','479',16770.94,17083.91,0.00,0.00,312.97,212819.60,0.00,0.00,0.00),('1','208','1038','257566',4903908,'3078','479',15573.76,15924.95,0.00,0.00,351.19,238809.20,0.00,0.00,0.00),('1','208','1038','257567',4903909,'3072','479',25556.21,26025.91,0.00,0.00,469.70,319396.00,0.00,0.00,0.00),('1','208','1038','257567',4903910,'3076','479',25117.70,25547.41,0.00,0.00,429.71,292202.80,0.00,0.00,0.00),('1','208','1038','257567',4903911,'3077','479',17083.91,17314.18,0.00,0.00,230.27,156583.60,0.00,0.00,0.00),('1','208','1038','257567',4903912,'3078','479',15924.95,16185.86,0.00,0.00,260.91,177418.80,0.00,0.00,0.00),('1','208','1038','257568',4903913,'3072','479',26025.91,26431.04,0.00,0.00,405.13,275488.40,0.00,0.00,0.00),('1','208','1038','257568',4903914,'3076','479',25547.41,25888.83,0.00,0.00,341.42,232165.60,0.00,0.00,0.00),('1','208','1038','257568',4903915,'3077','479',17314.18,17724.06,0.00,0.00,409.88,278718.40,0.00,0.00,0.00),('1','208','1038','257568',4903916,'3078','479',16185.86,16656.87,0.00,0.00,471.01,320286.80,0.00,0.00,0.00),('1','208','1038','257569',4903917,'3072','479',26431.04,26959.85,0.00,0.00,528.81,338438.40,0.00,0.00,0.00),('1','208','1038','257569',4903918,'3076','479',25888.83,26505.23,0.00,0.00,616.40,394496.00,0.00,0.00,0.00),('1','208','1038','257569',4903919,'3077','479',17724.06,18032.08,0.00,0.00,308.02,197132.80,0.00,0.00,0.00),('1','208','1038','257569',4903920,'3078','479',16656.87,17028.70,0.00,0.00,371.83,237971.20,0.00,0.00,0.00),('1','208','1038','257570',4903921,'3072','479',26959.85,27674.43,0.00,0.00,714.58,457331.20,0.00,0.00,0.00),('1','208','1038','257570',4903922,'3076','479',26505.23,26973.92,0.00,0.00,468.69,299961.60,0.00,0.00,0.00),('1','208','1038','257570',4903923,'3077','479',18032.08,18617.03,0.00,0.00,584.95,374368.00,0.00,0.00,0.00),('1','208','1038','257570',4903924,'3078','479',17028.70,17818.80,0.00,0.00,790.10,505664.00,0.00,0.00,0.00),('1','208','1038','257571',4903925,'3072','479',27674.43,28550.69,0.00,0.00,876.26,560806.40,0.00,0.00,0.00),('1','208','1038','257571',4903926,'3076','479',26973.92,27986.72,0.00,0.00,1012.80,648192.00,0.00,0.00,0.00),('1','208','1038','257571',4903927,'3077','479',18617.03,19641.02,0.00,0.00,1023.99,655353.60,0.00,0.00,0.00),('1','208','1038','257571',4903928,'3078','479',17818.80,18815.47,0.00,0.00,996.67,637868.80,0.00,0.00,0.00),('1','208','1038','257572',4903929,'3072','479',28550.69,28901.70,0.00,0.00,351.01,224646.40,0.00,0.00,0.00),('1','208','1038','257572',4903930,'3076','479',27986.72,28269.38,0.00,0.00,282.66,180902.40,0.00,0.00,0.00),('1','208','1038','257572',4903931,'3077','479',19641.02,19985.50,0.00,0.00,344.48,220467.20,0.00,0.00,0.00),('1','208','1038','257572',4903932,'3078','479',18815.47,19219.07,0.00,0.00,403.60,258304.00,0.00,0.00,0.00),('1','208','1038','257573',4903933,'3072','479',28901.70,29414.01,0.00,0.00,512.31,327878.40,0.00,0.00,0.00),('1','208','1038','257573',4903934,'3076','479',28269.38,28588.50,0.00,0.00,319.12,204236.80,0.00,0.00,0.00),('1','208','1038','257573',4903935,'3077','479',19985.50,20353.29,0.00,0.00,367.79,235385.60,0.00,0.00,0.00),('1','208','1038','257573',4903936,'3078','479',19219.07,19666.14,0.00,0.00,447.07,286124.80,0.00,0.00,0.00),('1','208','1038','257574',4903937,'3072','479',29414.01,29552.14,0.00,0.00,138.13,88403.20,0.00,0.00,0.00),('1','208','1038','257574',4903938,'3076','479',28588.50,28835.04,0.00,0.00,246.54,157785.60,0.00,0.00,0.00),('1','208','1038','257574',4903939,'3077','479',20353.29,20874.29,0.00,0.00,521.00,333440.00,0.00,0.00,0.00),('1','208','1038','257574',4903940,'3078','479',19666.14,20584.05,0.00,0.00,917.91,587462.40,0.00,0.00,0.00),('1','208','1038','257575',4903941,'3072','479',29552.14,30056.69,0.00,0.00,504.55,322912.00,0.00,0.00,0.00),('1','208','1038','257575',4903942,'3076','479',28835.04,29150.68,0.00,0.00,315.64,202009.60,0.00,0.00,0.00),('1','208','1038','257575',4903943,'3077','479',20874.29,21171.83,0.00,0.00,297.54,190425.60,0.00,0.00,0.00),('1','208','1038','257575',4903944,'3078','479',20584.05,21094.63,0.00,0.00,510.58,326771.20,0.00,0.00,0.00),('1','208','1038','257576',4903945,'3072','479',30056.69,30242.51,0.00,0.00,185.82,118924.80,0.00,0.00,0.00),('1','208','1038','257576',4903946,'3076','479',29150.68,29605.66,0.00,0.00,454.98,291187.20,0.00,0.00,0.00),('1','208','1038','257576',4903947,'3077','479',21171.83,21578.38,0.00,0.00,406.55,260192.00,0.00,0.00,0.00),('1','208','1038','257576',4903948,'3078','479',21094.63,21672.39,0.00,0.00,577.76,369766.40,0.00,0.00,0.00),('1','208','1038','257577',4903949,'3072','479',30242.51,30796.88,0.00,0.00,554.37,354796.80,0.00,0.00,0.00),('1','208','1038','257577',4903950,'3076','479',29605.66,29992.46,0.00,0.00,386.80,247552.00,0.00,0.00,0.00),('1','208','1038','257577',4903951,'3077','479',21578.38,21959.49,0.00,0.00,381.11,243910.40,0.00,0.00,0.00),('1','208','1038','257577',4903952,'3078','479',21672.39,22148.50,0.00,0.00,476.11,304710.40,0.00,0.00,0.00),('1','208','1038','257578',4903953,'3072','479',30796.88,31048.96,0.00,0.00,252.08,161331.20,0.00,0.00,0.00),('1','208','1038','257578',4903954,'3076','479',29992.46,30304.81,0.00,0.00,312.35,199904.00,0.00,0.00,0.00),('1','208','1038','257578',4903955,'3077','479',21959.49,22365.33,0.00,0.00,405.84,259737.60,0.00,0.00,0.00),('1','208','1038','257578',4903956,'3078','479',22148.50,22771.53,0.00,0.00,623.03,398739.20,0.00,0.00,0.00),('1','208','1038','257579',4903957,'3072','479',31048.96,31711.11,0.00,0.00,662.15,423776.00,0.00,0.00,0.00),('1','208','1038','257579',4903958,'3076','479',30304.81,30692.86,0.00,0.00,388.05,248352.00,0.00,0.00,0.00),('1','208','1038','257579',4903959,'3077','479',22365.33,22733.90,0.00,0.00,368.57,235884.80,0.00,0.00,0.00),('1','208','1038','257579',4903960,'3078','479',22771.53,23137.65,0.00,0.00,366.12,234316.80,0.00,0.00,0.00),('1','208','1038','257580',4903961,'3072','479',31711.11,32142.64,0.00,0.00,431.53,276179.20,0.00,0.00,0.00),('1','208','1038','257580',4903962,'3076','479',30692.86,31112.55,0.00,0.00,419.69,268601.60,0.00,0.00,0.00),('1','208','1038','257580',4903963,'3077','479',22733.90,23284.24,0.00,0.00,550.34,352217.60,0.00,0.00,0.00),('1','208','1038','257580',4903964,'3078','479',23137.65,23688.16,0.00,0.00,550.51,352326.40,0.00,0.00,0.00),('1','208','1038','257581',4903965,'3072','479',32142.64,32516.79,0.00,0.00,374.15,239456.00,0.00,0.00,0.00),('1','208','1038','257581',4903966,'3076','479',31112.55,31429.51,0.00,0.00,316.96,202854.40,0.00,0.00,0.00),('1','208','1038','257581',4903967,'3077','479',23284.24,23602.99,0.00,0.00,318.75,204000.00,0.00,0.00,0.00),('1','208','1038','257581',4903968,'3078','479',23688.16,24026.32,0.00,0.00,338.16,216422.40,0.00,0.00,0.00),('1','208','1038','257582',4903969,'3072','479',32516.79,32769.72,0.00,0.00,252.93,161875.20,0.00,0.00,0.00),('1','208','1038','257582',4903970,'3076','479',31429.51,31671.23,0.00,0.00,241.72,154700.80,0.00,0.00,0.00),('1','208','1038','257582',4903971,'3077','479',23602.99,23810.01,0.00,0.00,207.02,132492.80,0.00,0.00,0.00),('1','208','1038','257582',4903972,'3078','479',24026.32,24264.83,0.00,0.00,238.51,152646.40,0.00,0.00,0.00),('1','208','1038','257583',4903973,'3072','479',32769.72,32853.06,0.00,0.00,83.34,53337.60,0.00,0.00,0.00),('1','208','1038','257583',4903974,'3076','479',31671.23,31771.79,0.00,0.00,100.56,64358.40,0.00,0.00,0.00),('1','208','1038','257583',4903975,'3077','479',23810.01,23887.27,0.00,0.00,77.26,49446.40,0.00,0.00,0.00),('1','208','1038','257583',4903976,'3078','479',24264.83,24337.97,0.00,0.00,73.14,46809.60,0.00,0.00,0.00),('1','208','1038','257584',4903977,'3072','479',32853.06,33315.00,0.00,0.00,461.94,295641.60,0.00,0.00,0.00),('1','208','1038','257584',4903978,'3076','479',31771.79,32070.00,0.00,0.00,298.21,190854.40,0.00,0.00,0.00),('1','208','1038','257584',4903979,'3077','479',23887.27,24204.24,0.00,0.00,316.97,202860.80,0.00,0.00,0.00),('1','208','1038','257584',4903980,'3078','479',24337.97,24699.95,0.00,0.00,361.98,231667.20,0.00,0.00,0.00),('1','208','1038','257585',4903981,'3072','479',33315.00,33629.38,0.00,0.00,314.38,201203.20,0.00,0.00,0.00),('1','208','1038','257585',4903982,'3076','479',32070.00,32437.43,0.00,0.00,367.43,235155.20,0.00,0.00,0.00),('1','208','1038','257585',4903983,'3077','479',24204.24,24661.02,0.00,0.00,456.78,292339.20,0.00,0.00,0.00),('1','208','1038','257585',4903984,'3078','479',24699.95,25126.82,0.00,0.00,426.87,273196.80,0.00,0.00,0.00),('1','208','1038','257586',4903985,'3072','479',33629.38,34187.27,0.00,0.00,557.89,357049.60,0.00,0.00,0.00),('1','208','1038','257586',4903986,'3076','479',32437.43,32805.41,0.00,0.00,367.98,235507.20,0.00,0.00,0.00),('1','208','1038','257586',4903987,'3077','479',24661.02,25115.41,0.00,0.00,454.39,290809.60,0.00,0.00,0.00),('1','208','1038','257586',4903988,'3078','479',25126.82,25530.01,0.00,0.00,403.19,258041.60,0.00,0.00,0.00),('1','208','1038','257587',4903989,'3072','479',34187.27,34617.69,0.00,0.00,430.42,275468.80,0.00,0.00,0.00),('1','208','1038','257587',4903990,'3076','479',32805.41,33155.00,0.00,0.00,349.59,223737.60,0.00,0.00,0.00),('1','208','1038','257587',4903991,'3077','479',25115.41,25531.69,0.00,0.00,416.28,266419.20,0.00,0.00,0.00),('1','208','1038','257587',4903992,'3078','479',25530.01,25997.12,0.00,0.00,467.11,298950.40,0.00,0.00,0.00),('1','208','1038','257588',4903993,'3072','479',34617.69,34975.99,0.00,0.00,358.30,229312.00,0.00,0.00,0.00),('1','208','1038','257588',4903994,'3076','479',33155.00,33524.52,0.00,0.00,369.52,236492.80,0.00,0.00,0.00),('1','208','1038','257588',4903995,'3077','479',25531.69,25895.36,0.00,0.00,363.67,232748.80,0.00,0.00,0.00),('1','208','1038','257588',4903996,'3078','479',25997.12,26256.66,0.00,0.00,259.54,166105.60,0.00,0.00,0.00),('1','208','1038','257589',4903997,'3072','479',34975.99,35013.18,0.00,0.00,37.19,23801.60,0.00,0.00,0.00),('1','208','1038','257589',4903998,'3076','479',33524.52,33568.90,0.00,0.00,44.38,28403.20,0.00,0.00,0.00),('1','208','1038','257589',4903999,'3077','479',25895.36,25943.27,0.00,0.00,47.91,30662.40,0.00,0.00,0.00),('1','208','1038','257589',4904000,'3078','479',26256.66,26291.10,0.00,0.00,34.44,22041.60,0.00,0.00,0.00),('1','208','1038','257590',4904001,'3072','479',35013.18,35449.73,0.00,0.00,436.55,277728.32,0.00,0.00,0.00),('1','208','1038','257590',4904002,'3076','479',33568.90,34039.94,0.00,0.00,471.04,299668.32,0.00,0.00,0.00),('1','208','1038','257590',4904003,'3077','479',25943.27,26314.44,0.00,0.00,371.17,236170.40,0.00,0.00,0.00),('1','208','1038','257590',4904004,'3078','479',26291.10,26779.42,0.00,0.00,488.32,310678.52,0.00,0.00,0.00),('1','208','1038','257591',4904005,'3072','479',35449.73,35492.11,0.00,0.00,42.38,26953.68,0.00,0.00,0.00),('1','208','1038','257591',4904006,'3076','479',34039.94,34571.84,0.00,0.00,531.90,338288.40,0.00,0.00,0.00),('1','208','1038','257591',4904007,'3077','479',26314.44,26708.14,0.00,0.00,393.70,250393.20,0.00,0.00,0.00),('1','208','1038','257591',4904008,'3078','479',26779.42,27117.28,0.00,0.00,337.86,214878.96,0.00,0.00,0.00),('1','208','1038','257592',4904009,'3072','479',35492.11,35871.86,0.00,0.00,379.75,241521.00,0.00,0.00,0.00),('1','208','1038','257592',4904010,'3076','479',34571.84,34967.18,0.00,0.00,395.34,251436.24,0.00,0.00,0.00),('1','208','1038','257592',4904011,'3077','479',26708.14,27172.16,0.00,0.00,464.02,295116.72,0.00,0.00,0.00),('1','208','1038','257592',4904012,'3078','479',27117.28,27515.79,0.00,0.00,398.51,253452.36,0.00,0.00,0.00),('1','208','1038','257593',4904013,'3072','479',35871.86,36351.24,0.00,0.00,479.38,304885.68,0.00,0.00,0.00),('1','208','1038','257593',4904014,'3076','479',34967.18,35346.00,0.00,0.00,378.82,240929.52,0.00,0.00,0.00),('1','208','1038','257593',4904015,'3077','479',27172.16,27488.45,0.00,0.00,316.29,201160.44,0.00,0.00,0.00),('1','208','1038','257593',4904016,'3078','479',27515.79,27625.66,0.00,0.00,109.87,69877.32,0.00,0.00,0.00),('1','208','1038','257594',4904017,'3072','479',36351.24,36657.97,0.00,0.00,306.73,195080.28,0.00,0.00,0.00),('1','208','1038','257594',4904018,'3076','479',35346.00,35647.76,0.00,0.00,301.76,191919.36,0.00,0.00,0.00),('1','208','1038','257594',4904019,'3077','479',27488.45,27793.32,0.00,0.00,304.87,193897.32,0.00,0.00,0.00),('1','208','1038','257594',4904020,'3078','479',27625.66,28023.77,0.00,0.00,398.11,253197.96,0.00,0.00,0.00),('1','208','1038','257595',4904021,'3072','479',36657.97,37235.35,0.00,0.00,577.38,367213.68,0.00,0.00,0.00),('1','208','1038','257595',4904022,'3076','479',35647.76,35975.61,0.00,0.00,327.85,208512.60,0.00,0.00,0.00),('1','208','1038','257595',4904023,'3077','479',27793.32,28147.69,0.00,0.00,354.37,225379.32,0.00,0.00,0.00),('1','208','1038','257595',4904024,'3078','479',28023.77,28388.22,0.00,0.00,364.45,231790.20,0.00,0.00,0.00),('1','208','1038','257596',4904025,'3072','479',37235.35,37420.44,0.00,0.00,185.09,117717.24,0.00,0.00,0.00),('1','208','1038','257596',4904026,'3076','479',35975.61,36172.71,0.00,0.00,197.10,125355.60,0.00,0.00,0.00),('1','208','1038','257596',4904027,'3077','479',28147.69,28382.19,0.00,0.00,234.50,149142.00,0.00,0.00,0.00),('1','208','1038','257596',4904028,'3078','479',28388.22,28553.04,0.00,0.00,164.82,104825.52,0.00,0.00,0.00),('1','208','1038','257597',4904029,'3072','479',37420.44,37548.74,0.00,0.00,128.30,81598.80,0.00,0.00,0.00),('1','208','1038','257597',4904030,'3076','479',36172.71,36352.19,0.00,0.00,179.48,114149.28,0.00,0.00,0.00),('1','208','1038','257597',4904031,'3077','479',28382.19,28591.86,0.00,0.00,209.67,133350.12,0.00,0.00,0.00),('1','208','1038','257597',4904032,'3078','479',28553.04,28833.86,0.00,0.00,280.82,178601.52,0.00,0.00,0.00),('1','208','1038','257598',4904033,'3072','479',37548.74,37770.86,0.00,0.00,222.12,141268.32,0.00,0.00,0.00),('1','208','1038','257598',4904034,'3076','479',36352.19,36656.95,0.00,0.00,304.76,193827.36,0.00,0.00,0.00),('1','208','1038','257598',4904035,'3077','479',28591.86,28920.61,0.00,0.00,328.75,209085.00,0.00,0.00,0.00),('1','208','1038','257598',4904036,'3078','479',28833.86,29178.71,0.00,0.00,344.85,219324.60,0.00,0.00,0.00),('1','208','1038','257599',4904037,'3072','479',37770.86,37955.59,0.00,0.00,184.73,117488.28,0.00,0.00,0.00),('1','208','1038','257599',4904038,'3076','479',36656.95,36864.23,0.00,0.00,207.28,131830.08,0.00,0.00,0.00),('1','208','1038','257599',4904039,'3077','479',28920.61,29118.34,0.00,0.00,197.73,125756.28,0.00,0.00,0.00),('1','208','1038','257599',4904040,'3078','479',29178.71,29425.40,0.00,0.00,246.69,156894.84,0.00,0.00,0.00),('1','208','1038','257600',4904041,'3072','479',37955.59,38115.64,0.00,0.00,160.05,101791.80,0.00,0.00,0.00),('1','208','1038','257600',4904042,'3076','479',36864.23,36990.74,0.00,0.00,126.51,80460.36,0.00,0.00,0.00),('1','208','1038','257600',4904043,'3077','479',29118.34,29256.11,0.00,0.00,137.77,87621.72,0.00,0.00,0.00),('1','208','1038','257600',4904044,'3078','479',29425.40,29585.59,0.00,0.00,160.19,101880.84,0.00,0.00,0.00),('1','208','1038','257601',4904045,'3072','479',38115.64,38579.18,0.00,0.00,463.54,294811.44,0.00,0.00,0.00),('1','208','1038','257601',4904046,'3076','479',36990.74,37276.27,0.00,0.00,285.53,181597.08,0.00,0.00,0.00),('1','208','1038','257601',4904047,'3077','479',29256.11,29642.86,0.00,0.00,386.75,245973.00,0.00,0.00,0.00),('1','208','1038','257601',4904048,'3078','479',29585.59,30006.50,0.00,0.00,420.91,267698.76,0.00,0.00,0.00),('1','208','1038','257602',4904049,'3072','479',38579.18,38858.70,0.00,0.00,279.52,177774.72,0.00,0.00,0.00),('1','208','1038','257602',4904050,'3076','479',37276.27,37540.40,0.00,0.00,264.13,167986.68,0.00,0.00,0.00),('1','208','1038','257602',4904051,'3077','479',29642.86,30160.43,0.00,0.00,517.57,329174.52,0.00,0.00,0.00),('1','208','1038','257602',4904052,'3078','479',30006.50,30604.78,0.00,0.00,598.28,380506.08,0.00,0.00,0.00),('1','208','1038','257603',4904053,'3072','479',38858.70,39204.73,0.00,0.00,346.03,220075.08,0.00,0.00,0.00),('1','208','1038','257603',4904054,'3076','479',37540.40,37857.85,0.00,0.00,317.45,201898.20,0.00,0.00,0.00),('1','208','1038','257603',4904055,'3077','479',30160.43,30386.13,0.00,0.00,225.70,143545.20,0.00,0.00,0.00),('1','208','1038','257603',4904056,'3078','479',30604.78,30828.77,0.00,0.00,223.99,142457.64,0.00,0.00,0.00),('1','208','1038','257604',4904057,'3072','479',39204.73,39328.03,0.00,0.00,123.30,78418.80,0.00,0.00,0.00),('1','208','1038','257604',4904058,'3076','479',37857.85,37967.81,0.00,0.00,109.96,69934.56,0.00,0.00,0.00),('1','208','1038','257604',4904059,'3077','479',30386.13,30523.46,0.00,0.00,137.33,87341.88,0.00,0.00,0.00),('1','208','1038','257604',4904060,'3078','479',30828.77,30941.95,0.00,0.00,113.18,71982.48,0.00,0.00,0.00),('1','208','1038','257605',4904061,'3072','479',39328.03,39868.61,0.00,0.00,540.58,343808.88,0.00,0.00,0.00),('1','208','1038','257605',4904062,'3076','479',37967.81,38384.83,0.00,0.00,417.02,265224.72,0.00,0.00,0.00),('1','208','1038','257605',4904063,'3077','479',30523.46,31162.14,0.00,0.00,638.68,406200.48,0.00,0.00,0.00),('1','208','1038','257605',4904064,'3078','479',30941.95,31690.02,0.00,0.00,748.07,475772.52,0.00,0.00,0.00),('1','208','1038','257606',4904065,'3072','479',39868.61,40392.96,0.00,0.00,524.35,333486.60,0.00,0.00,0.00),('1','208','1038','257606',4904066,'3076','479',38384.83,38906.53,0.00,0.00,521.70,331801.20,0.00,0.00,0.00),('1','208','1038','257606',4904067,'3077','479',31162.14,31763.80,0.00,0.00,601.66,382655.76,0.00,0.00,0.00),('1','208','1038','257606',4904068,'3078','479',31690.02,32283.76,0.00,0.00,593.74,377618.64,0.00,0.00,0.00),('1','208','1038','257607',4904069,'3072','479',40392.96,40569.78,0.00,0.00,176.82,112457.52,0.00,0.00,0.00),('1','208','1038','257607',4904070,'3076','479',38906.53,39102.79,0.00,0.00,196.26,124821.36,0.00,0.00,0.00),('1','208','1038','257607',4904071,'3077','479',31763.80,32056.80,0.00,0.00,293.00,186348.00,0.00,0.00,0.00),('1','208','1038','257607',4904072,'3078','479',32283.76,32556.46,0.00,0.00,272.70,173437.20,0.00,0.00,0.00),('1','208','1038','257608',4904073,'3072','479',40569.78,40767.91,0.00,0.00,198.13,126010.68,0.00,0.00,0.00),('1','208','1038','257608',4904074,'3076','479',39102.79,39423.61,0.00,0.00,320.82,204041.52,0.00,0.00,0.00),('1','208','1038','257608',4904075,'3077','479',32056.80,32446.19,0.00,0.00,389.39,247652.04,0.00,0.00,0.00),('1','208','1038','257608',4904076,'3078','479',32556.46,32885.99,0.00,0.00,329.53,209581.08,0.00,0.00,0.00),('1','208','1038','257609',4904077,'3072','479',40767.91,41028.32,0.00,0.00,260.41,165620.76,0.00,0.00,0.00),('1','208','1038','257609',4904078,'3076','479',39423.61,39643.99,0.00,0.00,220.38,140161.68,0.00,0.00,0.00),('1','208','1038','257609',4904079,'3077','479',32446.19,32760.38,0.00,0.00,314.19,199824.84,0.00,0.00,0.00),('1','208','1038','257609',4904080,'3078','479',32885.99,33238.29,0.00,0.00,352.30,224062.80,0.00,0.00,0.00),('1','208','1038','257610',4904081,'3072','479',41028.32,41182.18,0.00,0.00,153.86,97854.96,0.00,0.00,0.00),('1','208','1038','257610',4904082,'3076','479',39643.99,40023.36,0.00,0.00,379.37,241279.32,0.00,0.00,0.00),('1','208','1038','257610',4904083,'3077','479',32760.38,33145.38,0.00,0.00,385.00,244860.00,0.00,0.00,0.00),('1','208','1038','257610',4904084,'3078','479',33238.29,33813.50,0.00,0.00,575.21,365833.56,0.00,0.00,0.00),('1','208','1038','257611',4904085,'3072','479',41182.18,41546.61,0.00,0.00,364.43,231777.48,0.00,0.00,0.00),('1','208','1038','257611',4904086,'3076','479',40023.36,40283.10,0.00,0.00,259.74,165194.64,0.00,0.00,0.00),('1','208','1038','257611',4904087,'3077','479',33145.38,33575.71,0.00,0.00,430.33,273689.88,0.00,0.00,0.00),('1','208','1038','257611',4904088,'3078','479',33813.50,34335.83,0.00,0.00,522.33,332201.88,0.00,0.00,0.00),('1','208','1038','257612',4904089,'3072','479',41546.61,41675.43,0.00,0.00,128.82,81929.52,0.00,0.00,0.00),('1','208','1038','257612',4904090,'3076','479',40283.10,40394.14,0.00,0.00,111.04,70621.44,0.00,0.00,0.00),('1','208','1038','257612',4904091,'3077','479',33575.71,33839.20,0.00,0.00,263.49,167579.64,0.00,0.00,0.00),('1','208','1038','257612',4904092,'3078','479',34335.83,34610.15,0.00,0.00,274.32,174467.52,0.00,0.00,0.00),('1','208','1038','257613',4904093,'3072','479',41675.43,41821.30,0.00,0.00,145.87,92773.32,0.00,0.00,0.00),('1','208','1038','257613',4904094,'3076','479',40394.14,40496.16,0.00,0.00,102.02,64884.72,0.00,0.00,0.00),('1','208','1038','257613',4904095,'3077','479',33839.20,34151.78,0.00,0.00,312.58,198800.88,0.00,0.00,0.00),('1','208','1038','257613',4904096,'3078','479',34610.15,35009.37,0.00,0.00,399.22,253903.92,0.00,0.00,0.00),('1','208','1038','257614',4904097,'3072','479',41821.30,42252.66,0.00,0.00,431.36,274344.96,0.00,0.00,0.00),('1','208','1038','257614',4904098,'3076','479',40496.16,40956.95,0.00,0.00,460.79,293062.44,0.00,0.00,0.00),('1','208','1038','257614',4904099,'3077','479',34151.78,34688.86,0.00,0.00,537.08,341582.88,0.00,0.00,0.00),('1','208','1038','257614',4904100,'3078','479',35009.37,35816.18,0.00,0.00,806.81,513131.16,0.00,0.00,0.00),('1','208','1038','257615',4904101,'3072','479',42252.66,42543.57,0.00,0.00,290.91,185018.76,0.00,0.00,0.00),('1','208','1038','257615',4904102,'3076','479',40956.95,41285.17,0.00,0.00,328.22,208747.92,0.00,0.00,0.00),('1','208','1038','257615',4904103,'3077','479',34688.86,35254.57,0.00,0.00,565.71,359791.56,0.00,0.00,0.00),('1','208','1038','257615',4904104,'3078','479',35816.18,36415.55,0.00,0.00,599.37,381199.32,0.00,0.00,0.00),('1','208','1038','257616',4904105,'3072','479',42543.57,42900.51,0.00,0.00,356.94,227013.84,0.00,0.00,0.00),('1','208','1038','257616',4904106,'3076','479',41285.17,41659.59,0.00,0.00,374.42,238131.12,0.00,0.00,0.00),('1','208','1038','257616',4904107,'3077','479',35254.57,35720.12,0.00,0.00,465.55,296089.80,0.00,0.00,0.00),('1','208','1038','257616',4904108,'3078','479',36415.55,36922.52,0.00,0.00,506.97,322432.92,0.00,0.00,0.00),('1','208','1038','257617',4904109,'3072','479',42900.51,43301.32,0.00,0.00,400.81,254915.16,0.00,0.00,0.00),('1','208','1038','257617',4904110,'3076','479',41659.59,41931.33,0.00,0.00,271.74,172826.64,0.00,0.00,0.00),('1','208','1038','257617',4904111,'3077','479',35720.12,36171.73,0.00,0.00,451.61,287223.96,0.00,0.00,0.00),('1','208','1038','257617',4904112,'3078','479',36922.52,37391.61,0.00,0.00,469.09,298341.24,0.00,0.00,0.00),('1','208','1038','257618',4904113,'3072','479',43301.32,43769.77,0.00,0.00,468.45,297934.20,0.00,0.00,0.00),('1','208','1038','257618',4904114,'3076','479',41931.33,42286.84,0.00,0.00,355.51,226104.36,0.00,0.00,0.00),('1','208','1038','257618',4904115,'3077','479',36171.73,36634.15,0.00,0.00,462.42,294099.12,0.00,0.00,0.00),('1','208','1038','257618',4904116,'3078','479',37391.61,37825.17,0.00,0.00,433.56,275744.16,0.00,0.00,0.00),('1','208','1038','257619',4904117,'3072','479',43769.77,44157.48,0.00,0.00,387.71,246583.56,0.00,0.00,0.00),('1','208','1038','257619',4904118,'3076','479',42286.84,42688.76,0.00,0.00,401.92,255621.12,0.00,0.00,0.00),('1','208','1038','257619',4904119,'3077','479',36634.15,36954.44,0.00,0.00,320.29,203704.44,0.00,0.00,0.00),('1','208','1038','257619',4904120,'3078','479',37825.17,38197.48,0.00,0.00,372.31,236789.16,0.00,0.00,0.00),('1','208','1038','257620',4904121,'3072','479',44157.48,44595.07,0.00,0.00,437.59,278307.24,0.00,0.00,0.00),('1','208','1038','257620',4904122,'3076','479',42688.76,42989.98,0.00,0.00,301.22,191575.92,0.00,0.00,0.00),('1','208','1038','257620',4904123,'3077','479',36954.44,37381.24,0.00,0.00,426.80,271444.80,0.00,0.00,0.00),('1','208','1038','257620',4904124,'3078','479',38197.48,38631.95,0.00,0.00,434.47,276322.92,0.00,0.00,0.00),('1','208','1038','257621',4904125,'3072','479',44595.07,44955.99,0.00,0.00,360.92,251200.32,0.00,0.00,0.00),('1','208','1038','257621',4904126,'3076','479',42989.98,43366.75,0.00,0.00,376.77,262231.92,0.00,0.00,0.00),('1','208','1038','257621',4904127,'3077','479',37381.24,37753.15,0.00,0.00,371.91,258849.36,0.00,0.00,0.00),('1','208','1038','257621',4904128,'3078','479',38631.95,39168.61,0.00,0.00,536.66,373515.36,0.00,0.00,0.00),('1','208','1038','257622',4904129,'3072','479',44955.99,45278.02,0.00,0.00,322.03,224132.88,0.00,0.00,0.00),('1','208','1038','257622',4904130,'3076','479',43366.75,43674.44,0.00,0.00,307.69,214152.24,0.00,0.00,0.00),('1','208','1038','257622',4904131,'3077','479',37753.15,38147.66,0.00,0.00,394.51,274578.96,0.00,0.00,0.00),('1','208','1038','257622',4904132,'3078','479',39168.61,39588.67,0.00,0.00,420.06,292361.76,0.00,0.00,0.00),('1','208','1038','257623',4904133,'3072','479',45278.02,45568.57,0.00,0.00,290.55,202222.80,0.00,0.00,0.00),('1','208','1038','257623',4904134,'3076','479',43674.44,43952.21,0.00,0.00,277.77,193327.92,0.00,0.00,0.00),('1','208','1038','257623',4904135,'3077','479',38147.66,38377.12,0.00,0.00,229.46,159704.16,0.00,0.00,0.00),('1','208','1038','257623',4904136,'3078','479',39588.67,39796.92,0.00,0.00,208.25,144942.00,0.00,0.00,0.00),('1','208','1038','257624',4904137,'3072','479',45568.57,45656.69,0.00,0.00,88.12,61331.52,0.00,0.00,0.00),('1','208','1038','257624',4904138,'3076','479',43952.21,43985.94,0.00,0.00,33.73,23476.08,0.00,0.00,0.00),('1','208','1038','257624',4904139,'3077','479',38377.12,38426.54,0.00,0.00,49.42,34396.32,0.00,0.00,0.00),('1','208','1038','257624',4904140,'3078','479',39796.92,39891.21,0.00,0.00,94.29,65625.84,0.00,0.00,0.00),('1','208','1038','257625',4904141,'3072','479',45656.69,46009.90,0.00,0.00,353.21,245834.16,0.00,0.00,0.00),('1','208','1038','257625',4904142,'3076','479',43985.94,44287.96,0.00,0.00,302.02,210205.92,0.00,0.00,0.00),('1','208','1038','257625',4904143,'3077','479',38426.54,38720.24,0.00,0.00,293.70,204415.20,0.00,0.00,0.00),('1','208','1038','257625',4904144,'3078','479',39891.21,40247.95,0.00,0.00,356.74,248291.04,0.00,0.00,0.00),('1','208','1038','257626',4904145,'3072','479',46009.90,46033.18,0.00,0.00,23.28,16202.88,0.00,0.00,0.00),('1','208','1038','257626',4904146,'3076','479',44287.96,44307.91,0.00,0.00,19.95,13885.20,0.00,0.00,0.00),('1','208','1038','257626',4904147,'3077','479',38720.24,38742.05,0.00,0.00,21.81,15179.76,0.00,0.00,0.00),('1','208','1038','257626',4904148,'3078','479',40247.95,40263.75,0.00,0.00,15.80,10996.80,0.00,0.00,0.00),('1','208','1038','257627',4904149,'3072','479',46033.18,46298.50,0.00,0.00,265.32,184662.72,0.00,0.00,0.00),('1','208','1038','257627',4904150,'3076','479',44307.91,44490.76,0.00,0.00,182.85,127263.60,0.00,0.00,0.00),('1','208','1038','257627',4904151,'3077','479',38742.05,39067.88,0.00,0.00,325.83,226777.68,0.00,0.00,0.00),('1','208','1038','257627',4904152,'3078','479',40263.75,40686.92,0.00,0.00,423.17,294526.32,0.00,0.00,0.00),('1','208','1038','257628',4904153,'3072','479',46298.50,46721.63,0.00,0.00,423.13,294498.48,0.00,0.00,0.00),('1','208','1038','257628',4904154,'3076','479',44490.76,44784.85,0.00,0.00,294.09,204686.64,0.00,0.00,0.00),('1','208','1038','257628',4904155,'3077','479',39067.88,39430.85,0.00,0.00,362.97,252627.12,0.00,0.00,0.00),('1','208','1038','257628',4904156,'3078','479',40686.92,41066.32,0.00,0.00,379.40,264062.40,0.00,0.00,0.00),('1','208','1038','257629',4904157,'3072','479',46721.63,46795.59,0.00,0.00,73.96,51476.16,0.00,0.00,0.00),('1','208','1038','257629',4904158,'3076','479',44784.85,44839.55,0.00,0.00,54.70,38071.20,0.00,0.00,0.00),('1','208','1038','257629',4904159,'3077','479',39430.85,39514.75,0.00,0.00,83.90,58394.40,0.00,0.00,0.00),('1','208','1038','257629',4904160,'3078','479',41066.32,41166.01,0.00,0.00,99.69,69384.24,0.00,0.00,0.00),('1','208','1038','257630',4904161,'3072','479',46795.59,47083.75,0.00,0.00,288.16,195948.80,0.00,0.00,0.00),('1','208','1038','257630',4904162,'3076','479',44839.55,45094.31,0.00,0.00,254.76,173236.80,0.00,0.00,0.00),('1','208','1038','257630',4904163,'3077','479',39514.75,39838.71,0.00,0.00,323.96,220292.80,0.00,0.00,0.00),('1','208','1038','257630',4904164,'3078','479',41166.01,41687.88,0.00,0.00,521.87,354871.60,0.00,0.00,0.00),('1','208','1038','257631',4904165,'3072','479',47083.75,47208.83,0.00,0.00,125.08,85054.40,0.00,0.00,0.00),('1','208','1038','257631',4904166,'3076','479',45094.31,45199.82,0.00,0.00,105.51,71746.80,0.00,0.00,0.00),('1','208','1038','257631',4904167,'3077','479',39838.71,39979.41,0.00,0.00,140.70,95676.00,0.00,0.00,0.00),('1','208','1038','257631',4904168,'3078','479',41687.88,41947.23,0.00,0.00,259.35,176358.00,0.00,0.00,0.00),('1','208','1038','257632',4904169,'3072','479',47208.83,47505.24,0.00,0.00,296.41,201558.80,0.00,0.00,0.00),('1','208','1038','257632',4904170,'3076','479',45199.82,45422.31,0.00,0.00,222.49,151293.20,0.00,0.00,0.00),('1','208','1038','257632',4904171,'3077','479',39979.41,40267.35,0.00,0.00,287.94,195799.20,0.00,0.00,0.00),('1','208','1038','257632',4904172,'3078','479',41947.23,42222.49,0.00,0.00,275.26,187176.80,0.00,0.00,0.00),('1','208','1038','257633',4904173,'3072','479',47505.24,47875.85,0.00,0.00,370.61,252014.80,0.00,0.00,0.00),('1','208','1038','257633',4904174,'3076','479',45422.31,45820.20,0.00,0.00,397.89,270565.20,0.00,0.00,0.00),('1','208','1038','257633',4904175,'3077','479',40267.35,40700.93,0.00,0.00,433.58,294834.40,0.00,0.00,0.00),('1','208','1038','257633',4904176,'3078','479',42222.49,42663.12,0.00,0.00,440.63,299628.40,0.00,0.00,0.00),('1','208','1038','257634',4904177,'3072','479',47875.85,48288.02,0.00,0.00,412.17,280275.60,0.00,0.00,0.00),('1','208','1038','257634',4904178,'3076','479',45820.20,46215.44,0.00,0.00,395.24,268763.20,0.00,0.00,0.00),('1','208','1038','257634',4904179,'3077','479',40700.93,41170.81,0.00,0.00,469.88,319518.40,0.00,0.00,0.00),('1','208','1038','257634',4904180,'3078','479',42663.12,43101.85,0.00,0.00,438.73,298336.40,0.00,0.00,0.00),('1','208','1038','257635',4904181,'3072','479',48288.02,48355.05,0.00,0.00,67.03,49602.20,0.00,0.00,0.00),('1','208','1038','257635',4904182,'3076','479',46215.44,46296.79,0.00,0.00,81.35,60199.00,0.00,0.00,0.00),('1','208','1038','257635',4904183,'3077','479',41170.81,41302.33,0.00,0.00,131.52,97324.80,0.00,0.00,0.00),('1','208','1038','257635',4904184,'3078','479',43101.85,43263.53,0.00,0.00,161.68,119643.20,0.00,0.00,0.00),('1','208','1038','257636',4904185,'3072','479',48355.05,48401.29,0.00,0.00,46.24,34217.60,0.00,0.00,0.00),('1','208','1038','257636',4904186,'3076','479',46296.79,46443.15,0.00,0.00,146.36,108306.40,0.00,0.00,0.00),('1','208','1038','257636',4904187,'3077','479',41302.33,41605.72,0.00,0.00,303.39,224508.60,0.00,0.00,0.00),('1','208','1038','257636',4904188,'3078','479',43263.53,43669.14,0.00,0.00,405.61,300151.40,0.00,0.00,0.00),('1','208','1038','257637',4904189,'3072','479',48401.29,48763.25,0.00,0.00,361.96,267850.40,0.00,0.00,0.00),('1','208','1038','257637',4904190,'3076','479',46443.15,46736.93,0.00,0.00,293.78,217397.20,0.00,0.00,0.00),('1','208','1038','257637',4904191,'3077','479',41605.72,42005.38,0.00,0.00,399.66,295748.40,0.00,0.00,0.00),('1','208','1038','257637',4904192,'3078','479',43669.14,44175.34,0.00,0.00,506.20,374588.00,0.00,0.00,0.00),('1','208','1038','257638',4904193,'3072','479',48763.25,49002.13,0.00,0.00,238.88,176771.20,0.00,0.00,0.00),('1','208','1038','257638',4904194,'3076','479',46736.93,46930.23,0.00,0.00,193.30,143042.00,0.00,0.00,0.00),('1','208','1038','257638',4904195,'3077','479',42005.38,42255.70,0.00,0.00,250.32,185236.80,0.00,0.00,0.00),('1','208','1038','257638',4904196,'3078','479',44175.34,44190.54,0.00,0.00,15.20,11248.00,0.00,0.00,0.00),('1','208','1038','257639',4904197,'3072','479',49002.13,49233.81,0.00,0.00,231.68,171443.20,0.00,0.00,0.00),('1','208','1038','257639',4904198,'3076','479',46930.23,47297.63,0.00,0.00,367.40,271876.00,0.00,0.00,0.00),('1','208','1038','257639',4904199,'3077','479',42255.70,42674.55,0.00,0.00,418.85,309949.00,0.00,0.00,0.00),('1','208','1038','257639',4904200,'3078','479',44190.54,44973.73,0.00,0.00,783.19,579560.60,0.00,0.00,0.00),('1','208','1038','257640',4904201,'3072','479',49233.81,49303.38,0.00,0.00,69.57,51481.80,0.00,0.00,0.00),('1','208','1038','257640',4904202,'3076','479',47297.63,47403.25,0.00,0.00,105.62,78158.80,0.00,0.00,0.00),('1','208','1038','257640',4904203,'3077','479',42674.55,42773.35,0.00,0.00,98.80,73112.00,0.00,0.00,0.00),('1','208','1038','257640',4904204,'3078','479',44973.73,45115.48,0.00,0.00,141.75,104895.00,0.00,0.00,0.00),('1','208','1038','257641',4904205,'3072','479',49303.38,49659.42,0.00,0.00,356.04,249228.00,0.00,0.00,0.00),('1','208','1038','257641',4904206,'3076','479',47403.25,47645.41,0.00,0.00,242.16,169512.00,0.00,0.00,0.00),('1','208','1038','257641',4904207,'3077','479',42773.35,43237.94,0.00,0.00,464.59,325213.00,0.00,0.00,0.00),('1','208','1038','257641',4904208,'3078','479',45115.48,45494.59,0.00,0.00,379.11,265377.00,0.00,0.00,0.00),('1','208','1038','257642',4904209,'3072','479',49659.42,49768.51,0.00,0.00,109.09,76363.00,0.00,0.00,0.00),('1','208','1038','257642',4904210,'3076','479',47645.41,47721.12,0.00,0.00,75.71,52997.00,0.00,0.00,0.00),('1','208','1038','257642',4904211,'3077','479',43237.94,43350.98,0.00,0.00,113.04,79128.00,0.00,0.00,0.00),('1','208','1038','257642',4904212,'3078','479',45494.59,45644.03,0.00,0.00,149.44,104608.00,0.00,0.00,0.00),('1','208','1038','257643',4904213,'3072','479',49768.51,49990.99,0.00,0.00,222.48,155736.00,0.00,0.00,0.00),('1','208','1038','257643',4904214,'3076','479',47721.12,47933.75,0.00,0.00,212.63,148841.00,0.00,0.00,0.00),('1','208','1038','257643',4904215,'3077','479',43350.98,43542.21,0.00,0.00,191.23,133861.00,0.00,0.00,0.00),('1','208','1038','257643',4904216,'3078','479',45644.03,46027.11,0.00,0.00,383.08,268156.00,0.00,0.00,0.00),('1','208','1038','257644',4904217,'3072','479',49990.99,50324.10,0.00,0.00,333.11,226514.80,0.00,0.00,0.00),('1','208','1038','257644',4904218,'3076','479',47933.75,48312.32,0.00,0.00,378.57,257427.60,0.00,0.00,0.00),('1','208','1038','257644',4904219,'3077','479',43542.21,44170.31,0.00,0.00,628.10,427108.00,0.00,0.00,0.00),('1','208','1038','257644',4904220,'3078','479',46027.11,46520.13,0.00,0.00,493.02,335253.60,0.00,0.00,0.00),('1','208','1038','257645',4904221,'3072','479',50324.10,50787.85,0.00,0.00,463.75,315350.00,0.00,0.00,0.00),('1','208','1038','257645',4904222,'3076','479',48312.32,48653.50,0.00,0.00,341.18,232002.40,0.00,0.00,0.00),('1','208','1038','257645',4904223,'3077','479',44170.31,44593.63,0.00,0.00,423.32,287857.60,0.00,0.00,0.00),('1','208','1038','257645',4904224,'3078','479',46520.13,46909.74,0.00,0.00,389.61,264934.80,0.00,0.00,0.00),('1','208','1038','257646',4904225,'3072','479',50787.85,50872.01,0.00,0.00,84.16,57228.80,0.00,0.00,0.00),('1','208','1038','257646',4904226,'3076','479',48653.50,48863.23,0.00,0.00,209.73,142616.40,0.00,0.00,0.00),('1','208','1038','257646',4904227,'3077','479',44593.63,44679.32,0.00,0.00,85.69,58269.20,0.00,0.00,0.00),('1','208','1038','257646',4904228,'3078','479',46909.74,47028.10,0.00,0.00,118.36,80484.80,0.00,0.00,0.00),('1','208','1038','257647',4904229,'3072','479',50872.01,51077.06,0.00,0.00,205.05,139434.00,0.00,0.00,0.00),('1','208','1038','257647',4904230,'3076','479',48863.23,49294.14,0.00,0.00,430.91,293018.80,0.00,0.00,0.00),('1','208','1038','257647',4904231,'3077','479',44679.32,44985.79,0.00,0.00,306.47,208399.60,0.00,0.00,0.00),('1','208','1038','257647',4904232,'3078','479',47028.10,47360.12,0.00,0.00,332.02,225773.60,0.00,0.00,0.00),('1','208','1038','257648',4904233,'3072','479',51077.06,51400.33,0.00,0.00,323.27,219823.60,0.00,0.00,0.00),('1','208','1038','257648',4904234,'3076','479',49294.14,49674.23,0.00,0.00,380.09,258461.20,0.00,0.00,0.00),('1','208','1038','257648',4904235,'3077','479',44985.79,45515.58,0.00,0.00,529.79,360257.20,0.00,0.00,0.00),('1','208','1038','257648',4904236,'3078','479',47360.12,47886.37,0.00,0.00,526.25,357850.00,0.00,0.00,0.00),('1','208','1038','257649',4904237,'3072','479',51400.33,51939.36,0.00,0.00,539.03,366540.40,0.00,0.00,0.00),('1','208','1038','257649',4904238,'3076','479',49674.23,50085.06,0.00,0.00,410.83,279364.40,0.00,0.00,0.00),('1','208','1038','257649',4904239,'3077','479',45515.58,45945.51,0.00,0.00,429.93,292352.40,0.00,0.00,0.00),('1','208','1038','257649',4904240,'3078','479',47886.37,48091.05,0.00,0.00,204.68,139182.40,0.00,0.00,0.00),('1','208','1038','257650',4904241,'3072','479',51939.36,52533.77,0.00,0.00,594.41,404198.80,0.00,0.00,0.00),('1','208','1038','257650',4904242,'3076','479',50085.06,50638.10,0.00,0.00,553.04,376067.20,0.00,0.00,0.00),('1','208','1038','257650',4904243,'3077','479',45945.51,46472.66,0.00,0.00,527.15,358462.00,0.00,0.00,0.00),('1','208','1038','257650',4904244,'3078','479',48091.05,48690.84,0.00,0.00,599.79,407857.20,0.00,0.00,0.00),('1','208','1038','257651',4904245,'3072','479',52533.77,53051.62,0.00,0.00,517.85,352138.00,0.00,0.00,0.00),('1','208','1038','257651',4904246,'3076','479',50638.10,51027.54,0.00,0.00,389.44,264819.20,0.00,0.00,0.00),('1','208','1038','257651',4904247,'3077','479',46472.66,46766.80,0.00,0.00,294.14,200015.20,0.00,0.00,0.00),('1','208','1038','257651',4904248,'3078','479',48690.84,48971.63,0.00,0.00,280.79,190937.20,0.00,0.00,0.00),('1','208','1038','257652',4904249,'3072','479',53051.62,53684.69,0.00,0.00,633.07,430487.60,0.00,0.00,0.00),('1','208','1038','257652',4904250,'3076','479',51027.54,51517.40,0.00,0.00,489.86,333104.80,0.00,0.00,0.00),('1','208','1038','257652',4904251,'3077','479',46766.80,47307.93,0.00,0.00,541.13,367968.40,0.00,0.00,0.00),('1','208','1038','257652',4904252,'3078','479',48971.63,49584.96,0.00,0.00,613.33,417064.40,0.00,0.00,0.00),('1','208','1038','257653',4904253,'3072','479',53684.69,53999.83,0.00,0.00,315.14,214295.20,0.00,0.00,0.00),('1','208','1038','257653',4904254,'3076','479',51517.40,51837.39,0.00,0.00,319.99,217593.20,0.00,0.00,0.00),('1','208','1038','257653',4904255,'3077','479',47307.93,47610.56,0.00,0.00,302.63,205788.40,0.00,0.00,0.00),('1','208','1038','257653',4904256,'3078','479',49584.96,49879.90,0.00,0.00,294.94,200559.20,0.00,0.00,0.00),('1','208','1038','257654',4904257,'3072','479',53999.83,54196.25,0.00,0.00,196.42,133565.60,0.00,0.00,0.00),('1','208','1038','257654',4904258,'3076','479',51837.39,52075.21,0.00,0.00,237.82,161717.60,0.00,0.00,0.00),('1','208','1038','257654',4904259,'3077','479',47610.56,47758.20,0.00,0.00,147.64,100395.20,0.00,0.00,0.00),('1','208','1038','257654',4904260,'3078','479',49879.90,50078.86,0.00,0.00,198.96,135292.80,0.00,0.00,0.00),('1','208','1038','257655',4904261,'3072','479',54196.25,54579.60,0.00,0.00,383.35,260678.00,0.00,0.00,0.00),('1','208','1038','257655',4904262,'3076','479',52075.21,52498.90,0.00,0.00,423.69,288109.20,0.00,0.00,0.00),('1','208','1038','257655',4904263,'3077','479',47758.20,48174.19,0.00,0.00,415.99,282873.20,0.00,0.00,0.00),('1','208','1038','257655',4904264,'3078','479',50078.86,50762.70,0.00,0.00,683.84,465011.20,0.00,0.00,0.00),('1','208','1038','257656',4904265,'3072','479',54579.60,54999.13,0.00,0.00,419.53,314647.50,0.00,0.00,0.00),('1','208','1038','257656',4904266,'3076','479',52498.90,52902.26,0.00,0.00,403.36,302520.00,0.00,0.00,0.00),('1','208','1038','257656',4904267,'3077','479',48174.19,48550.75,0.00,0.00,376.56,282420.00,0.00,0.00,0.00),('1','208','1038','257656',4904268,'3078','479',50762.70,51244.56,0.00,0.00,481.86,361395.00,0.00,0.00,0.00),('1','208','1038','257657',4904269,'3072','479',54999.13,55135.57,0.00,0.00,136.44,102330.00,0.00,0.00,0.00),('1','208','1038','257657',4904270,'3076','479',52902.26,53064.86,0.00,0.00,162.60,121950.00,0.00,0.00,0.00),('1','208','1038','257657',4904271,'3077','479',48550.75,48748.46,0.00,0.00,197.71,148282.50,0.00,0.00,0.00),('1','208','1038','257657',4904272,'3078','479',51244.56,51446.39,0.00,0.00,201.83,151372.50,0.00,0.00,0.00),('1','208','1038','257658',4904273,'3072','479',55135.57,55493.03,0.00,0.00,357.46,268095.00,0.00,0.00,0.00),('1','208','1038','257658',4904274,'3076','479',53064.86,53365.73,0.00,0.00,300.87,225652.50,0.00,0.00,0.00),('1','208','1038','257658',4904275,'3077','479',48748.46,49179.23,0.00,0.00,430.77,323077.50,0.00,0.00,0.00),('1','208','1038','257658',4904276,'3078','479',51446.39,51918.73,0.00,0.00,472.34,354255.00,0.00,0.00,0.00),('1','208','1038','257659',4904277,'3072','479',55493.03,56074.99,0.00,0.00,581.96,436470.00,0.00,0.00,0.00),('1','208','1038','257659',4904278,'3076','479',53365.73,53896.85,0.00,0.00,531.12,398340.00,0.00,0.00,0.00),('1','208','1038','257659',4904279,'3077','479',49179.23,49699.31,0.00,0.00,520.08,390060.00,0.00,0.00,0.00),('1','208','1038','257659',4904280,'3078','479',51918.73,52501.50,0.00,0.00,582.77,437077.50,0.00,0.00,0.00),('1','208','1038','257660',4904281,'3072','479',56074.99,56751.58,0.00,0.00,676.59,507442.50,0.00,0.00,0.00),('1','208','1038','257660',4904282,'3076','479',53896.85,54541.55,0.00,0.00,644.70,483525.00,0.00,0.00,0.00),('1','208','1038','257660',4904283,'3077','479',49699.31,50355.27,0.00,0.00,655.96,491970.00,0.00,0.00,0.00),('1','208','1038','257660',4904284,'3078','479',52501.50,53307.53,0.00,0.00,806.03,604522.50,0.00,0.00,0.00),('1','208','1038','257661',4904285,'3072','479',56751.58,57200.70,0.00,0.00,449.12,336840.00,0.00,0.00,0.00),('1','208','1038','257661',4904286,'3076','479',54541.55,54923.47,0.00,0.00,381.92,286440.00,0.00,0.00,0.00),('1','208','1038','257661',4904287,'3077','479',50355.27,50759.16,0.00,0.00,403.89,302917.50,0.00,0.00,0.00),('1','208','1038','257661',4904288,'3078','479',53307.53,53773.19,0.00,0.00,465.66,349245.00,0.00,0.00,0.00),('1','208','1038','257662',4904289,'3072','479',57200.70,57489.69,0.00,0.00,288.99,216742.50,0.00,0.00,0.00),('1','208','1038','257662',4904290,'3076','479',54923.47,55304.86,0.00,0.00,381.39,286042.50,0.00,0.00,0.00),('1','208','1038','257662',4904291,'3077','479',50759.16,51069.82,0.00,0.00,310.66,232995.00,0.00,0.00,0.00),('1','208','1038','257662',4904292,'3078','479',53773.19,54197.83,0.00,0.00,424.64,318480.00,0.00,0.00,0.00),('1','208','1038','257663',4904293,'3072','479',57489.69,57929.66,0.00,0.00,439.97,329977.50,0.00,0.00,0.00),('1','208','1038','257663',4904294,'3076','479',55304.86,55802.39,0.00,0.00,497.53,373147.50,0.00,0.00,0.00),('1','208','1038','257663',4904295,'3077','479',51069.82,51537.83,0.00,0.00,468.01,351007.50,0.00,0.00,0.00),('1','208','1038','257663',4904296,'3078','479',54197.83,54598.28,0.00,0.00,400.45,300337.50,0.00,0.00,0.00),('1','208','1038','257664',4904297,'3072','479',57929.66,58315.15,0.00,0.00,385.49,289117.50,0.00,0.00,0.00),('1','208','1038','257664',4904298,'3076','479',55802.39,56191.21,0.00,0.00,388.82,291615.00,0.00,0.00,0.00),('1','208','1038','257664',4904299,'3077','479',51537.83,51935.51,0.00,0.00,397.68,298260.00,0.00,0.00,0.00),('1','208','1038','257664',4904300,'3078','479',54598.28,55098.32,0.00,0.00,500.04,375030.00,0.00,0.00,0.00),('1','208','1038','257665',4904301,'3072','479',58315.15,58732.43,0.00,0.00,417.28,312960.00,0.00,0.00,0.00),('1','208','1038','257665',4904302,'3076','479',56191.21,56542.04,0.00,0.00,350.83,263122.50,0.00,0.00,0.00),('1','208','1038','257665',4904303,'3077','479',51935.51,52361.79,0.00,0.00,426.28,319710.00,0.00,0.00,0.00),('1','208','1038','257665',4904304,'3078','479',55098.32,55503.06,0.00,0.00,404.74,303555.00,0.00,0.00,0.00),('1','208','1038','257666',4904305,'3072','479',58732.43,59169.45,0.00,0.00,437.02,327765.00,0.00,0.00,0.00),('1','208','1038','257666',4904306,'3076','479',56542.04,56886.65,0.00,0.00,344.61,258457.50,0.00,0.00,0.00),('1','208','1038','257666',4904307,'3077','479',52361.79,52762.07,0.00,0.00,400.28,300210.00,0.00,0.00,0.00),('1','208','1038','257666',4904308,'3078','479',55503.06,56093.58,0.00,0.00,590.52,442890.00,0.00,0.00,0.00),('1','208','1038','257667',4904309,'3072','479',59169.45,59600.35,0.00,0.00,430.90,323175.00,0.00,0.00,0.00),('1','208','1038','257667',4904310,'3076','479',56886.65,57182.69,0.00,0.00,296.04,222030.00,0.00,0.00,0.00),('1','208','1038','257667',4904311,'3077','479',52762.07,53167.46,0.00,0.00,405.39,304042.50,0.00,0.00,0.00),('1','208','1038','257667',4904312,'3078','479',56093.58,56541.18,0.00,0.00,447.60,335700.00,0.00,0.00,0.00),('1','208','1038','257668',4904313,'3072','479',59600.35,59981.40,0.00,0.00,381.05,285787.50,0.00,0.00,0.00),('1','208','1038','257668',4904314,'3076','479',57182.69,57475.91,0.00,0.00,293.22,219915.00,0.00,0.00,0.00),('1','208','1038','257668',4904315,'3077','479',53167.46,53655.82,0.00,0.00,488.36,366270.00,0.00,0.00,0.00),('1','208','1038','257668',4904316,'3078','479',56541.18,56922.03,0.00,0.00,380.85,285637.50,0.00,0.00,0.00),('1','208','1038','257669',4904317,'3072','479',59981.40,60110.71,0.00,0.00,129.31,96982.50,0.00,0.00,0.00),('1','208','1038','257669',4904318,'3076','479',57475.91,57596.84,0.00,0.00,120.93,90697.50,0.00,0.00,0.00),('1','208','1038','257669',4904319,'3077','479',53655.82,53753.66,0.00,0.00,97.84,73380.00,0.00,0.00,0.00),('1','208','1038','257669',4904320,'3078','479',56922.03,57022.79,0.00,0.00,100.76,75570.00,0.00,0.00,0.00),('1','208','1038','257670',4904321,'3072','479',60110.71,60349.63,0.00,0.00,238.92,179190.00,0.00,0.00,0.00),('1','208','1038','257670',4904322,'3076','479',57596.84,57920.84,0.00,0.00,324.00,243000.00,0.00,0.00,0.00),('1','208','1038','257670',4904323,'3077','479',53753.66,54097.06,0.00,0.00,343.40,257550.00,0.00,0.00,0.00),('1','208','1038','257670',4904324,'3078','479',57022.79,57341.59,0.00,0.00,318.80,239100.00,0.00,0.00,0.00),('1','208','1038','257671',4904325,'3072','479',60349.63,60644.81,0.00,0.00,295.18,221385.00,0.00,0.00,0.00),('1','208','1038','257671',4904326,'3076','479',57920.84,58249.69,0.00,0.00,328.85,246637.50,0.00,0.00,0.00),('1','208','1038','257671',4904327,'3077','479',54097.06,54404.86,0.00,0.00,307.80,230850.00,0.00,0.00,0.00),('1','208','1038','257671',4904328,'3078','479',57341.59,57698.62,0.00,0.00,357.03,267772.50,0.00,0.00,0.00),('1','208','1038','257672',4904329,'3072','479',60644.81,61006.06,0.00,0.00,361.25,270937.50,0.00,0.00,0.00),('1','208','1038','257672',4904330,'3076','479',58249.69,58681.96,0.00,0.00,432.27,324202.50,0.00,0.00,0.00),('1','208','1038','257672',4904331,'3077','479',54404.86,54825.84,0.00,0.00,420.98,315735.00,0.00,0.00,0.00),('1','208','1038','257672',4904332,'3078','479',57698.62,58029.97,0.00,0.00,331.35,248512.50,0.00,0.00,0.00),('1','208','1038','257673',4904333,'3072','479',61006.06,61271.94,0.00,0.00,265.88,199410.00,0.00,0.00,0.00),('1','208','1038','257673',4904334,'3076','479',58681.96,58974.28,0.00,0.00,292.32,219240.00,0.00,0.00,0.00),('1','208','1038','257673',4904335,'3077','479',54825.84,55008.36,0.00,0.00,182.52,136890.00,0.00,0.00,0.00),('1','208','1038','257673',4904336,'3078','479',58029.97,58272.39,0.00,0.00,242.42,181815.00,0.00,0.00,0.00),('1','208','1038','257674',4904337,'3072','479',61271.94,61338.35,0.00,0.00,66.41,49807.50,0.00,0.00,0.00),('1','208','1038','257674',4904338,'3076','479',58974.28,59038.95,0.00,0.00,64.67,48502.50,0.00,0.00,0.00),('1','208','1038','257674',4904339,'3077','479',55008.36,55106.92,0.00,0.00,98.56,73920.00,0.00,0.00,0.00),('1','208','1038','257674',4904340,'3078','479',58272.39,58423.21,0.00,0.00,150.82,113115.00,0.00,0.00,0.00),('1','208','1038','257675',4904341,'3072','479',61338.35,61831.22,0.00,0.00,492.87,369652.50,0.00,0.00,0.00),('1','208','1038','257675',4904342,'3076','479',59038.95,59562.29,0.00,0.00,523.34,392505.00,0.00,0.00,0.00),('1','208','1038','257675',4904343,'3077','479',55106.92,55599.71,0.00,0.00,492.79,369592.50,0.00,0.00,0.00),('1','208','1038','257675',4904344,'3078','479',58423.21,59016.73,0.00,0.00,593.52,445140.00,0.00,0.00,0.00),('1','208','1038','257676',4904345,'3072','479',61831.22,62215.67,0.00,0.00,384.45,288337.50,0.00,0.00,0.00),('1','208','1038','257676',4904346,'3076','479',59562.29,59968.79,0.00,0.00,406.50,304875.00,0.00,0.00,0.00),('1','208','1038','257676',4904347,'3077','479',55599.71,56090.16,0.00,0.00,490.45,367837.50,0.00,0.00,0.00),('1','208','1038','257676',4904348,'3078','479',59016.73,59568.04,0.00,0.00,551.31,413482.50,0.00,0.00,0.00),('1','208','1038','257677',4904349,'3072','479',62215.67,62411.75,0.00,0.00,196.08,147060.00,0.00,0.00,0.00),('1','208','1038','257677',4904350,'3076','479',59968.79,60139.43,0.00,0.00,170.64,127980.00,0.00,0.00,0.00),('1','208','1038','257677',4904351,'3077','479',56090.16,56235.43,0.00,0.00,145.27,108952.50,0.00,0.00,0.00),('1','208','1038','257677',4904352,'3078','479',59568.04,59779.00,0.00,0.00,210.96,158220.00,0.00,0.00,0.00),('1','208','1038','257678',4904353,'3072','479',62411.75,62743.96,0.00,0.00,332.21,249157.50,0.00,0.00,0.00),('1','208','1038','257678',4904354,'3076','479',60139.43,60409.91,0.00,0.00,270.48,202860.00,0.00,0.00,0.00),('1','208','1038','257678',4904355,'3077','479',56235.43,56521.47,0.00,0.00,286.04,214530.00,0.00,0.00,0.00),('1','208','1038','257678',4904356,'3078','479',59779.00,60044.98,0.00,0.00,265.98,199485.00,0.00,0.00,0.00),('1','208','1038','257679',4904357,'3072','479',62743.96,62995.20,0.00,0.00,251.24,188430.00,0.00,0.00,0.00),('1','208','1038','257679',4904358,'3076','479',60409.91,60704.49,0.00,0.00,294.58,220935.00,0.00,0.00,0.00),('1','208','1038','257679',4904359,'3077','479',56521.47,56763.37,0.00,0.00,241.90,181425.00,0.00,0.00,0.00),('1','208','1038','257679',4904360,'3078','479',60044.98,60338.55,0.00,0.00,293.57,220177.50,0.00,0.00,0.00),('1','208','1038','257680',4904361,'3072','479',62995.20,63308.24,0.00,0.00,313.04,234780.00,0.00,0.00,0.00),('1','208','1038','257680',4904362,'3076','479',60704.49,61062.44,0.00,0.00,357.95,268462.50,0.00,0.00,0.00),('1','208','1038','257680',4904363,'3077','479',56763.37,57271.86,0.00,0.00,508.49,381367.50,0.00,0.00,0.00),('1','208','1038','257680',4904364,'3078','479',60338.55,60900.58,0.00,0.00,562.03,421522.50,0.00,0.00,0.00),('1','208','1038','257681',4904365,'3072','479',63308.24,63772.06,0.00,0.00,463.82,347865.00,0.00,0.00,0.00),('1','208','1038','257681',4904366,'3076','479',61062.44,61540.59,0.00,0.00,478.15,358612.50,0.00,0.00,0.00),('1','208','1038','257681',4904367,'3077','479',57271.86,57776.99,0.00,0.00,505.13,378847.50,0.00,0.00,0.00),('1','208','1038','257681',4904368,'3078','479',60900.58,61575.72,0.00,0.00,675.14,506355.00,0.00,0.00,0.00),('1','208','1038','257682',4904369,'3072','479',63772.06,63999.52,0.00,0.00,227.46,170595.00,0.00,0.00,0.00),('1','208','1038','257682',4904370,'3076','479',61540.59,61824.00,0.00,0.00,283.41,212557.50,0.00,0.00,0.00),('1','208','1038','257682',4904371,'3077','479',57776.99,58066.06,0.00,0.00,289.07,216802.50,0.00,0.00,0.00),('1','208','1038','257682',4904372,'3078','479',61575.72,61826.49,0.00,0.00,250.77,188077.50,0.00,0.00,0.00),('1','208','1038','257683',4904373,'3072','479',63999.52,64239.07,0.00,0.00,239.55,179662.50,0.00,0.00,0.00),('1','208','1038','257683',4904374,'3076','479',61824.00,62007.71,0.00,0.00,183.71,137782.50,0.00,0.00,0.00),('1','208','1038','257683',4904375,'3077','479',58066.06,58340.03,0.00,0.00,273.97,205477.50,0.00,0.00,0.00),('1','208','1038','257683',4904376,'3078','479',61826.49,62162.48,0.00,0.00,335.99,251992.50,0.00,0.00,0.00),('1','208','1038','257684',4904377,'3072','479',64239.07,64795.16,0.00,0.00,556.09,417067.50,0.00,0.00,0.00),('1','208','1038','257684',4904378,'3076','479',62007.71,62533.15,0.00,0.00,525.44,394080.00,0.00,0.00,0.00),('1','208','1038','257684',4904379,'3077','479',58340.03,58858.45,0.00,0.00,518.42,388815.00,0.00,0.00,0.00),('1','208','1038','257684',4904380,'3078','479',62162.48,62876.82,0.00,0.00,714.34,535755.00,0.00,0.00,0.00),('1','208','1038','257685',4904381,'3072','479',64795.16,65137.24,0.00,0.00,342.08,256560.00,0.00,0.00,0.00),('1','208','1038','257685',4904382,'3076','479',62533.15,62994.64,0.00,0.00,461.49,346117.50,0.00,0.00,0.00),('1','208','1038','257685',4904383,'3077','479',58858.45,59333.40,0.00,0.00,474.95,356212.50,0.00,0.00,0.00),('1','208','1038','257685',4904384,'3078','479',62876.82,63327.02,0.00,0.00,450.20,337650.00,0.00,0.00,0.00),('1','208','1038','257686',4904385,'3072','479',65137.24,65734.64,0.00,0.00,597.40,448050.00,0.00,0.00,0.00),('1','208','1038','257686',4904386,'3076','479',62994.64,63614.70,0.00,0.00,620.06,465045.00,0.00,0.00,0.00),('1','208','1038','257686',4904387,'3077','479',59333.40,59902.50,0.00,0.00,569.10,426825.00,0.00,0.00,0.00),('1','208','1038','257686',4904388,'3078','479',63327.02,63904.78,0.00,0.00,577.76,433320.00,0.00,0.00,0.00),('1','208','1038','257687',4904389,'3072','479',65734.64,65777.68,0.00,0.00,43.04,32280.00,0.00,0.00,0.00),('1','208','1038','257687',4904390,'3076','479',63614.70,63655.21,0.00,0.00,40.51,30382.50,0.00,0.00,0.00),('1','208','1038','257687',4904391,'3077','479',59902.50,59936.15,0.00,0.00,33.65,25237.50,0.00,0.00,0.00),('1','208','1038','257687',4904392,'3078','479',63904.78,63978.96,0.00,0.00,74.18,55635.00,0.00,0.00,0.00),('1','208','1038','257688',4904393,'3072','479',65777.68,66145.12,0.00,0.00,367.44,275580.00,0.00,0.00,0.00),('1','208','1038','257688',4904394,'3076','479',63655.21,63996.46,0.00,0.00,341.25,255937.50,0.00,0.00,0.00),('1','208','1038','257688',4904395,'3077','479',59936.15,60351.42,0.00,0.00,415.27,311452.50,0.00,0.00,0.00),('1','208','1038','257688',4904396,'3078','479',63978.96,64529.28,0.00,0.00,550.32,412740.00,0.00,0.00,0.00),('1','208','1038','257689',4904397,'3072','479',66145.12,66618.23,0.00,0.00,473.11,354832.50,0.00,0.00,0.00),('1','208','1038','257689',4904398,'3076','479',63996.46,64615.51,0.00,0.00,619.05,464287.50,0.00,0.00,0.00),('1','208','1038','257689',4904399,'3077','479',60351.42,61128.03,0.00,0.00,776.61,582457.50,0.00,0.00,0.00),('1','208','1038','257689',4904400,'3078','479',64529.28,65368.92,0.00,0.00,839.64,629730.00,0.00,0.00,0.00),('1','208','1038','257690',4904401,'3072','479',66618.23,66784.03,0.00,0.00,165.80,124350.00,0.00,0.00,0.00),('1','208','1038','257690',4904402,'3076','479',64615.51,64783.52,0.00,0.00,168.01,126007.50,0.00,0.00,0.00),('1','208','1038','257690',4904403,'3077','479',61128.03,61304.71,0.00,0.00,176.68,132510.00,0.00,0.00,0.00),('1','208','1038','257690',4904404,'3078','479',65368.92,65600.18,0.00,0.00,231.26,173445.00,0.00,0.00,0.00),('1','208','1038','257691',4904405,'3072','479',66784.03,67424.03,0.00,0.00,640.00,480000.00,0.00,0.00,0.00),('1','208','1038','257691',4904406,'3076','479',64783.52,65478.90,0.00,0.00,695.38,521535.00,0.00,0.00,0.00),('1','208','1038','257691',4904407,'3077','479',61304.71,62019.03,0.00,0.00,714.32,535740.00,0.00,0.00,0.00),('1','208','1038','257691',4904408,'3078','479',65600.18,66646.95,0.00,0.00,1046.77,785077.50,0.00,0.00,0.00),('1','208','1038','257692',4904409,'3072','479',67424.03,67818.19,0.00,0.00,394.16,295620.00,0.00,0.00,0.00),('1','208','1038','257692',4904410,'3076','479',65478.90,65939.10,0.00,0.00,460.20,345150.00,0.00,0.00,0.00),('1','208','1038','257692',4904411,'3077','479',62019.03,62505.09,0.00,0.00,486.06,364545.00,0.00,0.00,0.00),('1','208','1038','257692',4904412,'3078','479',66646.95,67276.86,0.00,0.00,629.91,472432.50,0.00,0.00,0.00),('1','208','1038','257693',4904413,'3072','479',67818.19,68114.26,0.00,0.00,296.07,222052.50,0.00,0.00,0.00),('1','208','1038','257693',4904414,'3076','479',65939.10,66277.33,0.00,0.00,338.23,253672.50,0.00,0.00,0.00),('1','208','1038','257693',4904415,'3077','479',62505.09,62997.14,0.00,0.00,492.05,369037.50,0.00,0.00,0.00),('1','208','1038','257693',4904416,'3078','479',67276.86,67796.84,0.00,0.00,519.98,389985.00,0.00,0.00,0.00),('1','208','1038','257694',4904417,'3072','479',68114.26,68163.85,0.00,0.00,49.59,37192.50,0.00,0.00,0.00),('1','208','1038','257694',4904418,'3076','479',66277.33,66319.32,0.00,0.00,41.99,31492.50,0.00,0.00,0.00),('1','208','1038','257694',4904419,'3077','479',62997.14,63059.67,0.00,0.00,62.53,46897.50,0.00,0.00,0.00),('1','208','1038','257694',4904420,'3078','479',67796.84,67889.86,0.00,0.00,93.02,69765.00,0.00,0.00,0.00),('1','208','1038','257695',4904421,'3072','479',68163.85,68384.45,0.00,0.00,220.60,165450.00,0.00,0.00,0.00),('1','208','1038','257695',4904422,'3076','479',66319.32,66540.14,0.00,0.00,220.82,165615.00,0.00,0.00,0.00),('1','208','1038','257695',4904423,'3077','479',63059.67,63353.45,0.00,0.00,293.78,220335.00,0.00,0.00,0.00),('1','208','1038','257695',4904424,'3078','479',67889.86,68354.06,0.00,0.00,464.20,348150.00,0.00,0.00,0.00),('1','208','1038','257696',4904425,'3072','479',68384.45,68717.87,0.00,0.00,333.42,250065.00,0.00,0.00,0.00),('1','208','1038','257696',4904426,'3076','479',66540.14,66838.56,0.00,0.00,298.42,223815.00,0.00,0.00,0.00),('1','208','1038','257696',4904427,'3077','479',63353.45,63658.34,0.00,0.00,304.89,228667.50,0.00,0.00,0.00),('1','208','1038','257696',4904428,'3078','479',68354.06,68680.28,0.00,0.00,326.22,244665.00,0.00,0.00,0.00),('1','208','1038','257697',4904429,'3072','479',68717.87,69080.36,0.00,0.00,362.49,271867.50,0.00,0.00,0.00),('1','208','1038','257697',4904430,'3076','479',66838.56,67212.77,0.00,0.00,374.21,280657.50,0.00,0.00,0.00),('1','208','1038','257697',4904431,'3077','479',63658.34,64080.19,0.00,0.00,421.85,316387.50,0.00,0.00,0.00),('1','208','1038','257697',4904432,'3078','479',68680.28,69211.57,0.00,0.00,531.29,398467.50,0.00,0.00,0.00),('1','208','1038','257698',4904433,'3072','479',69080.36,69248.88,0.00,0.00,168.52,126390.00,0.00,0.00,0.00),('1','208','1038','257698',4904434,'3076','479',67212.77,67442.18,0.00,0.00,229.41,172057.50,0.00,0.00,0.00),('1','208','1038','257698',4904435,'3077','479',64080.19,64325.86,0.00,0.00,245.67,184252.50,0.00,0.00,0.00),('1','208','1038','257698',4904436,'3078','479',69211.57,69562.09,0.00,0.00,350.52,262890.00,0.00,0.00,0.00),('1','208','1038','257699',4904437,'3072','479',69248.88,69415.68,0.00,0.00,166.80,125100.00,0.00,0.00,0.00),('1','208','1038','257699',4904438,'3076','479',67442.18,67590.82,0.00,0.00,148.64,111480.00,0.00,0.00,0.00),('1','208','1038','257699',4904439,'3077','479',64325.86,64468.17,0.00,0.00,142.31,106732.50,0.00,0.00,0.00),('1','208','1038','257699',4904440,'3078','479',69562.09,69778.82,0.00,0.00,216.73,162547.50,0.00,0.00,0.00),('1','208','1038','257700',4904441,'3072','479',69415.68,69750.71,0.00,0.00,335.03,251272.50,0.00,0.00,0.00),('1','208','1038','257700',4904442,'3076','479',67590.82,67959.16,0.00,0.00,368.34,276255.00,0.00,0.00,0.00),('1','208','1038','257700',4904443,'3077','479',64468.17,64844.41,0.00,0.00,376.24,282180.00,0.00,0.00,0.00),('1','208','1038','257700',4904444,'3078','479',69778.82,70180.83,0.00,0.00,402.01,301507.50,0.00,0.00,0.00),('1','208','1038','257701',4904445,'3072','479',69750.71,70134.77,0.00,0.00,384.06,288045.00,0.00,0.00,0.00),('1','208','1038','257701',4904446,'3076','479',67959.16,68361.34,0.00,0.00,402.18,301635.00,0.00,0.00,0.00),('1','208','1038','257701',4904447,'3077','479',64844.41,65308.87,0.00,0.00,464.46,348345.00,0.00,0.00,0.00),('1','208','1038','257701',4904448,'3078','479',70180.83,70833.95,0.00,0.00,653.12,489840.00,0.00,0.00,0.00),('1','208','1038','257702',4904449,'3072','479',70134.77,70374.71,0.00,0.00,239.94,179955.00,0.00,0.00,0.00),('1','208','1038','257702',4904450,'3076','479',68361.34,68622.02,0.00,0.00,260.68,195510.00,0.00,0.00,0.00),('1','208','1038','257702',4904451,'3077','479',65308.87,65509.46,0.00,0.00,200.59,150442.50,0.00,0.00,0.00),('1','208','1038','257702',4904452,'3078','479',70833.95,71183.58,0.00,0.00,349.63,262222.50,0.00,0.00,0.00),('1','208','1038','257703',4904453,'3072','479',70374.71,70442.30,0.00,0.00,67.59,50692.50,0.00,0.00,0.00),('1','208','1038','257703',4904454,'3076','479',68622.02,68674.19,0.00,0.00,52.17,39127.50,0.00,0.00,0.00),('1','208','1038','257703',4904455,'3077','479',65509.46,65599.54,0.00,0.00,90.08,67560.00,0.00,0.00,0.00),('1','208','1038','257703',4904456,'3078','479',71183.58,71280.96,0.00,0.00,97.38,73035.00,0.00,0.00,0.00),('1','208','1038','257704',4904457,'3072','479',70442.30,71073.52,0.00,0.00,631.22,473415.00,0.00,0.00,0.00),('1','208','1038','257704',4904458,'3076','479',68674.19,69307.94,0.00,0.00,633.75,475312.50,0.00,0.00,0.00),('1','208','1038','257704',4904459,'3077','479',65599.54,66214.84,0.00,0.00,615.30,461475.00,0.00,0.00,0.00),('1','208','1038','257704',4904460,'3078','479',71280.96,71992.49,0.00,0.00,711.53,533647.50,0.00,0.00,0.00),('1','208','1038','257705',4904461,'3072','479',71073.52,71317.97,0.00,0.00,244.45,183337.50,0.00,0.00,0.00),('1','208','1038','257705',4904462,'3076','479',69307.94,69535.99,0.00,0.00,228.05,171037.50,0.00,0.00,0.00),('1','208','1038','257705',4904463,'3077','479',66214.84,66656.65,0.00,0.00,441.81,331357.50,0.00,0.00,0.00),('1','208','1038','257705',4904464,'3078','479',71992.49,72612.37,0.00,0.00,619.88,464910.00,0.00,0.00,0.00),('1','208','1038','257706',4904465,'3072','479',71317.97,71416.48,0.00,0.00,98.51,73882.50,0.00,0.00,0.00),('1','208','1038','257706',4904466,'3076','479',69535.99,69642.37,0.00,0.00,106.38,79785.00,0.00,0.00,0.00),('1','208','1038','257706',4904467,'3077','479',66656.65,66780.42,0.00,0.00,123.77,92827.50,0.00,0.00,0.00),('1','208','1038','257706',4904468,'3078','479',72612.37,72716.24,0.00,0.00,103.87,77902.50,0.00,0.00,0.00),('1','208','1038','257707',4904469,'3072','479',71416.48,71466.48,0.00,0.00,50.00,37500.00,0.00,0.00,0.00),('1','208','1038','257707',4904470,'3076','479',69642.37,69712.37,0.00,0.00,70.00,52500.00,0.00,0.00,0.00),('1','208','1038','257707',4904471,'3077','479',66780.42,66842.42,0.00,0.00,62.00,46500.00,0.00,0.00,0.00),('1','208','1038','257707',4904472,'3078','479',72716.24,72766.60,0.00,0.00,50.36,37770.00,0.00,0.00,0.00),('1','208','1038','257708',4904473,'3072','479',71466.48,71544.86,0.00,0.00,78.38,58785.00,0.00,0.00,0.00),('1','208','1038','257708',4904474,'3076','479',69712.37,69855.78,0.00,0.00,143.41,107557.50,0.00,0.00,0.00),('1','208','1038','257708',4904475,'3077','479',66842.42,67009.29,0.00,0.00,166.87,125152.50,0.00,0.00,0.00),('1','208','1038','257708',4904476,'3078','479',72766.60,73050.17,0.00,0.00,283.57,212677.50,0.00,0.00,0.00),('1','208','1038','257709',4904477,'3072','479',71544.86,71988.01,0.00,0.00,443.15,332362.50,0.00,0.00,0.00),('1','208','1038','257709',4904478,'3076','479',69855.78,70280.43,0.00,0.00,424.65,318487.50,0.00,0.00,0.00),('1','208','1038','257709',4904479,'3077','479',67009.29,67507.83,0.00,0.00,498.54,373905.00,0.00,0.00,0.00),('1','208','1038','257709',4904480,'3078','479',73050.17,73433.23,0.00,0.00,383.06,287295.00,0.00,0.00,0.00),('1','208','1038','257710',4904481,'3072','479',71988.01,72369.82,0.00,0.00,381.81,286357.50,0.00,0.00,0.00),('1','208','1038','257710',4904482,'3076','479',70280.43,70681.19,0.00,0.00,400.76,300570.00,0.00,0.00,0.00),('1','208','1038','257710',4904483,'3077','479',67507.83,67961.32,0.00,0.00,453.49,340117.50,0.00,0.00,0.00),('1','208','1038','257710',4904484,'3078','479',73433.23,73860.59,0.00,0.00,427.36,320520.00,0.00,0.00,0.00),('1','208','1038','257711',4904485,'3072','479',72369.82,72591.38,0.00,0.00,221.56,166170.00,0.00,0.00,0.00),('1','208','1038','257711',4904486,'3076','479',70681.19,70859.88,0.00,0.00,178.69,134017.50,0.00,0.00,0.00),('1','208','1038','257711',4904487,'3077','479',67961.32,68220.37,0.00,0.00,259.05,194287.50,0.00,0.00,0.00),('1','208','1038','257711',4904488,'3078','479',73860.59,74202.51,0.00,0.00,341.92,256440.00,0.00,0.00,0.00),('1','208','1038','257712',4904489,'3072','479',72591.38,72805.24,0.00,0.00,213.86,160395.00,0.00,0.00,0.00),('1','208','1038','257712',4904490,'3076','479',70859.88,71092.33,0.00,0.00,232.45,174337.50,0.00,0.00,0.00),('1','208','1038','257712',4904491,'3077','479',68220.37,68434.53,0.00,0.00,214.16,160620.00,0.00,0.00,0.00),('1','208','1038','257712',4904492,'3078','479',74202.51,74410.94,0.00,0.00,208.43,156322.50,0.00,0.00,0.00),('1','208','1038','257713',4904493,'3072','479',72805.24,73164.54,0.00,0.00,359.30,269475.00,0.00,0.00,0.00),('1','208','1038','257713',4904494,'3076','479',71092.33,71520.42,0.00,0.00,428.09,321067.50,0.00,0.00,0.00),('1','208','1038','257713',4904495,'3077','479',68434.53,68952.38,0.00,0.00,517.85,388387.50,0.00,0.00,0.00),('1','208','1038','257713',4904496,'3078','479',74410.94,74915.94,0.00,0.00,505.00,378750.00,0.00,0.00,0.00),('1','208','1038','257714',4904497,'3072','479',73164.54,73467.32,0.00,0.00,302.78,227085.00,0.00,0.00,0.00),('1','208','1038','257714',4904498,'3076','479',71520.42,71913.56,0.00,0.00,393.14,294855.00,0.00,0.00,0.00),('1','208','1038','257714',4904499,'3077','479',68952.38,69320.87,0.00,0.00,368.49,276367.50,0.00,0.00,0.00),('1','208','1038','257714',4904500,'3078','479',74915.94,75300.14,0.00,0.00,384.20,288150.00,0.00,0.00,0.00),('1','208','1038','257715',4904501,'3072','479',73467.32,73656.99,0.00,0.00,189.67,142252.50,0.00,0.00,0.00),('1','208','1038','257715',4904502,'3076','479',71913.56,72163.61,0.00,0.00,250.05,187537.50,0.00,0.00,0.00),('1','208','1038','257715',4904503,'3077','479',69320.87,69541.88,0.00,0.00,221.01,165757.50,0.00,0.00,0.00),('1','208','1038','257715',4904504,'3078','479',75300.14,75605.18,0.00,0.00,305.04,228780.00,0.00,0.00,0.00),('1','208','1038','257716',4904505,'3072','479',73656.99,73749.89,0.00,0.00,92.90,69675.00,0.00,0.00,0.00),('1','208','1038','257716',4904506,'3076','479',72163.61,72266.77,0.00,0.00,103.16,77370.00,0.00,0.00,0.00),('1','208','1038','257716',4904507,'3077','479',69541.88,69646.72,0.00,0.00,104.84,78630.00,0.00,0.00,0.00),('1','208','1038','257716',4904508,'3078','479',75605.18,75817.96,0.00,0.00,212.78,159585.00,0.00,0.00,0.00),('1','208','1038','257717',4904509,'3072','479',73749.89,73881.56,0.00,0.00,131.67,98752.50,0.00,0.00,0.00),('1','208','1038','257717',4904510,'3076','479',72266.77,72469.84,0.00,0.00,203.07,152302.50,0.00,0.00,0.00),('1','208','1038','257717',4904511,'3077','479',69646.72,69972.31,0.00,0.00,325.59,244192.50,0.00,0.00,0.00),('1','208','1038','257717',4904512,'3078','479',75817.96,76181.12,0.00,0.00,363.16,272370.00,0.00,0.00,0.00),('1','208','1038','257718',4904513,'3072','479',73881.56,73960.63,0.00,0.00,79.07,59302.50,0.00,0.00,0.00),('1','208','1038','257718',4904514,'3076','479',72469.84,72577.65,0.00,0.00,107.81,80857.50,0.00,0.00,0.00),('1','208','1038','257718',4904515,'3077','479',69972.31,70101.38,0.00,0.00,129.07,96802.50,0.00,0.00,0.00),('1','208','1038','257718',4904516,'3078','479',76181.12,76323.87,0.00,0.00,142.75,107062.50,0.00,0.00,0.00),('1','208','1038','257719',4904517,'3072','479',73960.63,74365.15,0.00,0.00,404.52,303390.00,0.00,0.00,0.00),('1','208','1038','257719',4904518,'3076','479',72577.65,73074.59,0.00,0.00,496.94,372705.00,0.00,0.00,0.00),('1','208','1038','257719',4904519,'3077','479',70101.38,70566.03,0.00,0.00,464.65,348487.50,0.00,0.00,0.00),('1','208','1038','257719',4904520,'3078','479',76323.87,76798.90,0.00,0.00,475.03,356272.50,0.00,0.00,0.00),('1','208','1038','257720',4904521,'3072','479',74365.15,74781.33,0.00,0.00,416.18,312135.00,0.00,0.00,0.00),('1','208','1038','257720',4904522,'3076','479',73074.59,73544.55,0.00,0.00,469.96,352470.00,0.00,0.00,0.00),('1','208','1038','257720',4904523,'3077','479',70566.03,71069.16,0.00,0.00,503.13,377347.50,0.00,0.00,0.00),('1','208','1038','257720',4904524,'3078','479',76798.90,77273.34,0.00,0.00,474.44,355830.00,0.00,0.00,0.00),('1','208','1038','257721',4904525,'3072','479',74781.33,74972.96,0.00,0.00,191.63,143722.50,0.00,0.00,0.00),('1','208','1038','257721',4904526,'3076','479',73544.55,73752.30,0.00,0.00,207.75,155812.50,0.00,0.00,0.00),('1','208','1038','257721',4904527,'3077','479',71069.16,71310.53,0.00,0.00,241.37,181027.50,0.00,0.00,0.00),('1','208','1038','257721',4904528,'3078','479',77273.34,77568.44,0.00,0.00,295.10,221325.00,0.00,0.00,0.00),('1','208','1038','257722',4904529,'3072','479',74972.96,75181.89,0.00,0.00,208.93,156697.50,0.00,0.00,0.00),('1','208','1038','257722',4904530,'3076','479',73752.30,73922.27,0.00,0.00,169.97,127477.50,0.00,0.00,0.00),('1','208','1038','257722',4904531,'3077','479',71310.53,71531.67,0.00,0.00,221.14,165855.00,0.00,0.00,0.00),('1','208','1038','257722',4904532,'3078','479',77568.44,77790.83,0.00,0.00,222.39,166792.50,0.00,0.00,0.00),('1','208','1038','257723',4904533,'3072','479',75181.89,75691.89,0.00,0.00,510.00,382500.00,0.00,0.00,0.00),('1','208','1038','257723',4904534,'3076','479',73922.27,74585.71,0.00,0.00,663.44,497580.00,0.00,0.00,0.00),('1','208','1038','257723',4904535,'3077','479',71531.67,72074.03,0.00,0.00,542.36,406770.00,0.00,0.00,0.00),('1','208','1038','257723',4904536,'3078','479',77790.83,78458.96,0.00,0.00,668.13,501097.50,0.00,0.00,0.00),('1','208','1038','257724',4904537,'3072','479',75691.89,76072.28,0.00,0.00,380.39,285292.50,0.00,0.00,0.00),('1','208','1038','257724',4904538,'3076','479',74585.71,75011.87,0.00,0.00,426.16,319620.00,0.00,0.00,0.00),('1','208','1038','257724',4904539,'3077','479',72074.03,72568.38,0.00,0.00,494.35,370762.50,0.00,0.00,0.00),('1','208','1038','257724',4904540,'3078','479',78458.96,79089.52,0.00,0.00,630.56,472920.00,0.00,0.00,0.00),('1','208','1038','257725',4904541,'3072','479',76072.28,76089.29,0.00,0.00,17.01,12757.50,0.00,0.00,0.00),('1','208','1038','257725',4904542,'3076','479',75011.87,75061.04,0.00,0.00,49.17,36877.50,0.00,0.00,0.00),('1','208','1038','257725',4904543,'3077','479',72568.38,72589.71,0.00,0.00,21.33,15997.50,0.00,0.00,0.00),('1','208','1038','257725',4904544,'3078','479',79089.52,79129.89,0.00,0.00,40.37,30277.50,0.00,0.00,0.00),('1','208','1038','257726',4904545,'3072','479',76089.29,76408.97,0.00,0.00,319.68,239760.00,0.00,0.00,0.00),('1','208','1038','257726',4904546,'3076','479',75061.04,75516.13,0.00,0.00,455.09,341317.50,0.00,0.00,0.00),('1','208','1038','257726',4904547,'3077','479',72589.71,73070.68,0.00,0.00,480.97,360727.50,0.00,0.00,0.00),('1','208','1038','257726',4904548,'3078','479',79129.89,79608.03,0.00,0.00,478.14,358605.00,0.00,0.00,0.00),('1','208','1038','257727',4904549,'3072','479',76408.97,76760.54,0.00,0.00,351.57,263677.50,0.00,0.00,0.00),('1','208','1038','257727',4904550,'3076','479',75516.13,75964.90,0.00,0.00,448.77,336577.50,0.00,0.00,0.00),('1','208','1038','257727',4904551,'3077','479',73070.68,73647.82,0.00,0.00,577.14,432855.00,0.00,0.00,0.00),('1','208','1038','257727',4904552,'3078','479',79608.03,80085.06,0.00,0.00,477.03,357772.50,0.00,0.00,0.00),('1','208','1038','257728',4904553,'3072','479',76760.54,77456.02,0.00,0.00,695.48,521610.00,0.00,0.00,0.00),('1','208','1038','257728',4904554,'3076','479',75964.90,76552.69,0.00,0.00,587.79,440842.50,0.00,0.00,0.00),('1','208','1038','257728',4904555,'3077','479',73647.82,74284.89,0.00,0.00,637.07,477802.50,0.00,0.00,0.00),('1','208','1038','257728',4904556,'3078','479',80085.06,80711.54,0.00,0.00,626.48,469860.00,0.00,0.00,0.00),('1','208','1038','257729',4904557,'3072','479',77456.02,77703.17,0.00,0.00,247.15,185362.50,0.00,0.00,0.00),('1','208','1038','257729',4904558,'3076','479',76552.69,76730.71,0.00,0.00,178.02,133515.00,0.00,0.00,0.00),('1','208','1038','257729',4904559,'3077','479',74284.89,74485.90,0.00,0.00,201.01,150757.50,0.00,0.00,0.00),('1','208','1038','257729',4904560,'3078','479',80711.54,80925.05,0.00,0.00,213.51,160132.50,0.00,0.00,0.00),('1','208','1038','257730',4904561,'3072','479',77703.17,77916.56,0.00,0.00,213.39,160042.50,0.00,0.00,0.00),('1','208','1038','257730',4904562,'3076','479',76730.71,76905.86,0.00,0.00,175.15,131362.50,0.00,0.00,0.00),('1','208','1038','257730',4904563,'3077','479',74485.90,74702.18,0.00,0.00,216.28,162210.00,0.00,0.00,0.00),('1','208','1038','257730',4904564,'3078','479',80925.05,81198.19,0.00,0.00,273.14,204855.00,0.00,0.00,0.00),('1','208','1038','257731',4904565,'3072','479',77916.56,78555.11,0.00,0.00,638.55,478912.50,0.00,0.00,0.00),('1','208','1038','257731',4904566,'3076','479',76905.86,77538.60,0.00,0.00,632.74,474555.00,0.00,0.00,0.00),('1','208','1038','257731',4904567,'3077','479',74702.18,75434.53,0.00,0.00,732.35,549262.50,0.00,0.00,0.00),('1','208','1038','257731',4904568,'3078','479',81198.19,81871.27,0.00,0.00,673.08,504810.00,0.00,0.00,0.00),('1','208','1038','257732',4904569,'3072','479',78555.11,78851.54,0.00,0.00,296.43,222322.50,0.00,0.00,0.00),('1','208','1038','257732',4904570,'3076','479',77538.60,77998.53,0.00,0.00,459.93,344947.50,0.00,0.00,0.00),('1','208','1038','257732',4904571,'3077','479',75434.53,75727.85,0.00,0.00,293.32,219990.00,0.00,0.00,0.00),('1','208','1038','257732',4904572,'3078','479',81871.27,82369.85,0.00,0.00,498.58,373935.00,0.00,0.00,0.00),('1','208','1038','257733',4904573,'3072','479',78851.54,79023.57,0.00,0.00,172.03,129022.50,0.00,0.00,0.00),('1','208','1038','257733',4904574,'3076','479',77998.53,78205.85,0.00,0.00,207.32,155490.00,0.00,0.00,0.00),('1','208','1038','257733',4904575,'3077','479',75727.85,75951.18,0.00,0.00,223.33,167497.50,0.00,0.00,0.00),('1','208','1038','257733',4904576,'3078','479',82369.85,82590.24,0.00,0.00,220.39,165292.50,0.00,0.00,0.00),('1','208','1038','257734',4904577,'3072','479',79023.57,79486.55,0.00,0.00,462.98,347235.00,0.00,0.00,0.00),('1','208','1038','257734',4904578,'3076','479',78205.85,78565.99,0.00,0.00,360.14,270105.00,0.00,0.00,0.00),('1','208','1038','257734',4904579,'3077','479',75951.18,76271.35,0.00,0.00,320.17,240127.50,0.00,0.00,0.00),('1','208','1038','257734',4904580,'3078','479',82590.24,82986.29,0.00,0.00,396.05,297037.50,0.00,0.00,0.00),('1','208','1038','257735',4904581,'3072','479',79486.55,79691.79,0.00,0.00,205.24,153930.00,0.00,0.00,0.00),('1','208','1038','257735',4904582,'3076','479',78565.99,78701.51,0.00,0.00,135.52,101640.00,0.00,0.00,0.00),('1','208','1038','257735',4904583,'3077','479',76271.35,76367.60,0.00,0.00,96.25,72187.50,0.00,0.00,0.00),('1','208','1038','257735',4904584,'3078','479',82986.29,83108.33,0.00,0.00,122.04,91530.00,0.00,0.00,0.00),('1','208','1038','257736',4904585,'3072','479',79691.79,80113.30,0.00,0.00,421.51,316132.50,0.00,0.00,0.00),('1','208','1038','257736',4904586,'3076','479',78701.51,79086.41,0.00,0.00,384.90,288675.00,0.00,0.00,0.00),('1','208','1038','257736',4904587,'3077','479',76367.60,76755.45,0.00,0.00,387.85,290887.50,0.00,0.00,0.00),('1','208','1038','257736',4904588,'3078','479',83108.33,83510.16,0.00,0.00,401.83,301372.50,0.00,0.00,0.00),('1','208','1038','257737',4904589,'3072','479',80113.30,80701.61,0.00,0.00,588.31,441232.50,0.00,0.00,0.00),('1','208','1038','257737',4904590,'3076','479',79086.41,79470.67,0.00,0.00,384.26,288195.00,0.00,0.00,0.00),('1','208','1038','257737',4904591,'3077','479',76755.45,77198.09,0.00,0.00,442.64,331980.00,0.00,0.00,0.00),('1','208','1038','257737',4904592,'3078','479',83510.16,84009.63,0.00,0.00,499.47,374602.50,0.00,0.00,0.00),('1','208','1038','257738',4904593,'3072','479',80701.61,80919.42,0.00,0.00,217.81,163357.50,0.00,0.00,0.00),('1','208','1038','257738',4904594,'3076','479',79470.67,79758.32,0.00,0.00,287.65,215737.50,0.00,0.00,0.00),('1','208','1038','257738',4904595,'3077','479',77198.09,77454.63,0.00,0.00,256.54,192405.00,0.00,0.00,0.00),('1','208','1038','257738',4904596,'3078','479',84009.63,84343.34,0.00,0.00,333.71,250282.50,0.00,0.00,0.00),('1','208','1038','257739',4904597,'3072','479',80919.42,81093.25,0.00,0.00,173.83,130372.50,0.00,0.00,0.00),('1','208','1038','257739',4904598,'3076','479',79758.32,79883.27,0.00,0.00,124.95,93712.50,0.00,0.00,0.00),('1','208','1038','257739',4904599,'3077','479',77454.63,77597.71,0.00,0.00,143.08,107310.00,0.00,0.00,0.00),('1','208','1038','257739',4904600,'3078','479',84343.34,84595.95,0.00,0.00,252.61,189457.50,0.00,0.00,0.00),('1','208','1038','257740',4904601,'3072','479',81093.25,81555.19,0.00,0.00,461.94,346455.00,0.00,0.00,0.00),('1','208','1038','257740',4904602,'3076','479',79883.27,80376.35,0.00,0.00,493.08,369810.00,0.00,0.00,0.00),('1','208','1038','257740',4904603,'3077','479',77597.71,78199.32,0.00,0.00,601.61,451207.50,0.00,0.00,0.00),('1','208','1038','257740',4904604,'3078','479',84595.95,85054.65,0.00,0.00,458.70,344025.00,0.00,0.00,0.00),('1','208','1038','257741',4904605,'3072','479',81555.19,82101.79,0.00,0.00,546.60,409950.00,0.00,0.00,0.00),('1','208','1038','257741',4904606,'3076','479',80376.35,80795.72,0.00,0.00,419.37,314527.50,0.00,0.00,0.00),('1','208','1038','257741',4904607,'3077','479',78199.32,78645.08,0.00,0.00,445.76,334320.00,0.00,0.00,0.00),('1','208','1038','257741',4904608,'3078','479',85054.65,85578.58,0.00,0.00,523.93,392947.50,0.00,0.00,0.00),('1','208','1038','257742',4904609,'3072','479',82101.79,82210.65,0.00,0.00,108.86,81645.00,0.00,0.00,0.00),('1','208','1038','257742',4904610,'3076','479',80795.72,80938.65,0.00,0.00,142.93,107197.50,0.00,0.00,0.00),('1','208','1038','257742',4904611,'3077','479',78645.08,78821.62,0.00,0.00,176.54,132405.00,0.00,0.00,0.00),('1','208','1038','257742',4904612,'3078','479',85578.58,85761.99,0.00,0.00,183.41,137557.50,0.00,0.00,0.00),('1','208','1038','257743',4904613,'3072','479',82210.65,82487.63,0.00,0.00,276.98,207735.00,0.00,0.00,0.00),('1','208','1038','257743',4904614,'3076','479',80938.65,81293.77,0.00,0.00,355.12,266340.00,0.00,0.00,0.00),('1','208','1038','257743',4904615,'3077','479',78821.62,79101.29,0.00,0.00,279.67,209752.50,0.00,0.00,0.00),('1','208','1038','257743',4904616,'3078','479',85761.99,86193.36,0.00,0.00,431.37,323527.50,0.00,0.00,0.00),('1','208','1038','257744',4904617,'3072','479',82487.63,82896.00,0.00,0.00,408.37,306277.50,0.00,0.00,0.00),('1','208','1038','257744',4904618,'3076','479',81293.77,81639.17,0.00,0.00,345.40,259050.00,0.00,0.00,0.00),('1','208','1038','257744',4904619,'3077','479',79101.29,79552.54,0.00,0.00,451.25,338437.50,0.00,0.00,0.00),('1','208','1038','257744',4904620,'3078','479',86193.36,86654.63,0.00,0.00,461.27,345952.50,0.00,0.00,0.00),('1','208','1038','257745',4904621,'3072','479',82896.00,83391.94,0.00,0.00,495.94,371955.00,0.00,0.00,0.00),('1','208','1038','257745',4904622,'3076','479',81639.17,82098.42,0.00,0.00,459.25,344437.50,0.00,0.00,0.00),('1','208','1038','257745',4904623,'3077','479',79552.54,79949.84,0.00,0.00,397.30,297975.00,0.00,0.00,0.00),('1','208','1038','257745',4904624,'3078','479',86654.63,87241.28,0.00,0.00,586.65,439987.50,0.00,0.00,0.00),('1','208','1038','257746',4904625,'3072','479',83391.94,83458.95,0.00,0.00,67.01,50257.50,0.00,0.00,0.00),('1','208','1038','257746',4904626,'3076','479',82098.42,82134.41,0.00,0.00,35.99,26992.50,0.00,0.00,0.00),('1','208','1038','257746',4904627,'3077','479',79949.84,79991.49,0.00,0.00,41.65,31237.50,0.00,0.00,0.00),('1','208','1038','257746',4904628,'3078','479',87241.28,87297.80,0.00,0.00,56.52,42390.00,0.00,0.00,0.00),('1','208','1038','257747',4904629,'3072','479',83458.95,84028.87,0.00,0.00,569.92,427440.00,0.00,0.00,0.00),('1','208','1038','257747',4904630,'3076','479',82134.41,82570.72,0.00,0.00,436.31,327232.50,0.00,0.00,0.00),('1','208','1038','257747',4904631,'3077','479',79991.49,80428.72,0.00,0.00,437.23,327922.50,0.00,0.00,0.00),('1','208','1038','257747',4904632,'3078','479',87297.80,87804.65,0.00,0.00,506.85,380137.50,0.00,0.00,0.00),('1','208','1038','257748',4904633,'3072','479',84028.87,84470.39,0.00,0.00,441.52,331140.00,0.00,0.00,0.00),('1','208','1038','257748',4904634,'3076','479',82570.72,83087.92,0.00,0.00,517.20,387900.00,0.00,0.00,0.00),('1','208','1038','257748',4904635,'3077','479',80428.72,80804.52,0.00,0.00,375.80,281850.00,0.00,0.00,0.00),('1','208','1038','257748',4904636,'3078','479',87804.65,88305.58,0.00,0.00,500.93,375697.50,0.00,0.00,0.00),('1','208','1038','257749',4904637,'3072','479',84470.39,84844.84,0.00,0.00,374.45,280837.50,0.00,0.00,0.00),('1','208','1038','257749',4904638,'3076','479',83087.92,83399.01,0.00,0.00,311.09,233317.50,0.00,0.00,0.00),('1','208','1038','257749',4904639,'3077','479',80804.52,81088.69,0.00,0.00,284.17,213127.50,0.00,0.00,0.00),('1','208','1038','257749',4904640,'3078','479',88305.58,88692.27,0.00,0.00,386.69,290017.50,0.00,0.00,0.00),('1','208','1038','257750',4904641,'3072','479',84844.84,84923.65,0.00,0.00,78.81,59107.50,0.00,0.00,0.00),('1','208','1038','257750',4904642,'3076','479',83399.01,83475.78,0.00,0.00,76.77,57577.50,0.00,0.00,0.00),('1','208','1038','257750',4904643,'3077','479',81088.69,81149.77,0.00,0.00,61.08,45810.00,0.00,0.00,0.00),('1','208','1038','257750',4904644,'3078','479',88692.27,88823.07,0.00,0.00,130.80,98100.00,0.00,0.00,0.00),('1','208','1038','257751',4904645,'3072','479',84923.65,85357.15,0.00,0.00,433.50,325125.00,0.00,0.00,0.00),('1','208','1038','257751',4904646,'3076','479',83475.78,84015.94,0.00,0.00,540.16,405120.00,0.00,0.00,0.00),('1','208','1038','257751',4904647,'3077','479',81149.77,81574.67,0.00,0.00,424.90,318675.00,0.00,0.00,0.00),('1','208','1038','257751',4904648,'3078','479',88823.07,89362.79,0.00,0.00,539.72,404790.00,0.00,0.00,0.00),('1','208','1038','257752',4904649,'3072','479',85357.15,85937.24,0.00,0.00,580.09,435067.50,0.00,0.00,0.00),('1','208','1038','257752',4904650,'3076','479',84015.94,84462.92,0.00,0.00,446.98,335235.00,0.00,0.00,0.00),('1','208','1038','257752',4904651,'3077','479',81574.67,82204.02,0.00,0.00,629.35,472012.50,0.00,0.00,0.00),('1','208','1038','257752',4904652,'3078','479',89362.79,90036.99,0.00,0.00,674.20,505650.00,0.00,0.00,0.00),('1','208','1038','257753',4904653,'3072','479',85937.24,86070.18,0.00,0.00,132.94,99705.00,0.00,0.00,0.00),('1','208','1038','257753',4904654,'3076','479',84462.92,84577.31,0.00,0.00,114.39,85792.50,0.00,0.00,0.00),('1','208','1038','257753',4904655,'3077','479',82204.02,82377.62,0.00,0.00,173.60,130200.00,0.00,0.00,0.00),('1','208','1038','257753',4904656,'3078','479',90036.99,90162.18,0.00,0.00,125.19,93892.50,0.00,0.00,0.00),('1','208','1038','257754',4904657,'3072','479',86070.18,86336.40,0.00,0.00,266.22,199665.00,0.00,0.00,0.00),('1','208','1038','257754',4904658,'3076','479',84577.31,84823.20,0.00,0.00,245.89,184417.50,0.00,0.00,0.00),('1','208','1038','257754',4904659,'3077','479',82377.62,82608.64,0.00,0.00,231.02,173265.00,0.00,0.00,0.00),('1','208','1038','257754',4904660,'3078','479',90162.18,90515.23,0.00,0.00,353.05,264787.50,0.00,0.00,0.00),('1','208','1038','257755',4904661,'3072','479',86336.40,86754.65,0.00,0.00,418.25,313687.50,0.00,0.00,0.00),('1','208','1038','257755',4904662,'3076','479',84823.20,85257.85,0.00,0.00,434.65,325987.50,0.00,0.00,0.00),('1','208','1038','257755',4904663,'3077','479',82608.64,83103.91,0.00,0.00,495.27,371452.50,0.00,0.00,0.00),('1','208','1038','257755',4904664,'3078','479',90515.23,90980.69,0.00,0.00,465.46,349095.00,0.00,0.00,0.00),('1','208','1038','257756',4904665,'3072','479',86754.65,87338.28,0.00,0.00,583.63,437722.50,0.00,0.00,0.00),('1','208','1038','257756',4904666,'3076','479',85257.85,85769.28,0.00,0.00,511.43,383572.50,0.00,0.00,0.00),('1','208','1038','257756',4904667,'3077','479',83103.91,83691.78,0.00,0.00,587.87,440902.50,0.00,0.00,0.00),('1','208','1038','257756',4904668,'3078','479',90980.69,91472.99,0.00,0.00,492.30,369225.00,0.00,0.00,0.00),('1','208','1038','257757',4904669,'3072','479',87338.28,87366.62,0.00,0.00,28.34,21255.00,0.00,0.00,0.00),('1','208','1038','257757',4904670,'3076','479',85769.28,85778.28,0.00,0.00,9.00,6750.00,0.00,0.00,0.00),('1','208','1038','257757',4904671,'3077','479',83691.78,83707.12,0.00,0.00,15.34,11505.00,0.00,0.00,0.00),('1','208','1038','257757',4904672,'3078','479',91472.99,91489.39,0.00,0.00,16.40,12300.00,0.00,0.00,0.00),('1','208','1038','257758',4904673,'3072','479',87366.62,87645.37,0.00,0.00,278.75,209062.50,0.00,0.00,0.00),('1','208','1038','257758',4904674,'3076','479',85778.28,86009.25,0.00,0.00,230.97,173227.50,0.00,0.00,0.00),('1','208','1038','257758',4904675,'3077','479',83707.12,83874.70,0.00,0.00,167.58,125685.00,0.00,0.00,0.00),('1','208','1038','257758',4904676,'3078','479',91489.39,91738.97,0.00,0.00,249.58,187185.00,0.00,0.00,0.00),('1','208','1038','257759',4904677,'3072','479',87645.37,88102.55,0.00,0.00,457.18,342885.00,0.00,0.00,0.00),('1','208','1038','257759',4904678,'3076','479',86009.25,86384.59,0.00,0.00,375.34,281505.00,0.00,0.00,0.00),('1','208','1038','257759',4904679,'3077','479',83874.70,84363.24,0.00,0.00,488.54,366405.00,0.00,0.00,0.00),('1','208','1038','257759',4904680,'3078','479',91738.97,92174.11,0.00,0.00,435.14,326355.00,0.00,0.00,0.00),('1','208','1038','257760',4904681,'3072','479',88102.55,88584.24,0.00,0.00,481.69,361267.50,0.00,0.00,0.00),('1','208','1038','257760',4904682,'3076','479',86384.59,86823.14,0.00,0.00,438.55,328912.50,0.00,0.00,0.00),('1','208','1038','257760',4904683,'3077','479',84363.24,84808.66,0.00,0.00,445.42,334065.00,0.00,0.00,0.00),('1','208','1038','257760',4904684,'3078','479',92174.11,92744.91,0.00,0.00,570.80,428100.00,0.00,0.00,0.00),('1','208','1038','257761',4904685,'3072','479',88584.24,88718.30,0.00,0.00,134.06,100545.00,0.00,0.00,0.00),('1','208','1038','257761',4904686,'3076','479',86823.14,86971.14,0.00,0.00,148.00,111000.00,0.00,0.00,0.00),('1','208','1038','257761',4904687,'3077','479',84808.66,84957.58,0.00,0.00,148.92,111690.00,0.00,0.00,0.00),('1','208','1038','257761',4904688,'3078','479',92744.91,92865.06,0.00,0.00,120.15,90112.50,0.00,0.00,0.00),('1','208','1038','257762',4904689,'3072','479',88718.30,89175.05,0.00,0.00,456.75,342562.50,0.00,0.00,0.00),('1','208','1038','257762',4904690,'3076','479',86971.14,87414.87,0.00,0.00,443.73,332797.50,0.00,0.00,0.00),('1','208','1038','257762',4904691,'3077','479',84957.58,85502.04,0.00,0.00,544.46,408345.00,0.00,0.00,0.00),('1','208','1038','257762',4904692,'3078','479',92865.06,93316.98,0.00,0.00,451.92,338940.00,0.00,0.00,0.00),('1','208','1038','257763',4904693,'3072','479',89175.05,89713.08,0.00,0.00,538.03,403522.50,0.00,0.00,0.00),('1','208','1038','257763',4904694,'3076','479',87414.87,87906.42,0.00,0.00,491.55,368662.50,0.00,0.00,0.00),('1','208','1038','257763',4904695,'3077','479',85502.04,86012.22,0.00,0.00,510.18,382635.00,0.00,0.00,0.00),('1','208','1038','257763',4904696,'3078','479',93316.98,93942.03,0.00,0.00,625.05,468787.50,0.00,0.00,0.00),('1','208','1038','257764',4904697,'3072','479',89713.08,89886.39,0.00,0.00,173.31,129982.50,0.00,0.00,0.00),('1','208','1038','257764',4904698,'3076','479',87906.42,88099.82,0.00,0.00,193.40,145050.00,0.00,0.00,0.00),('1','208','1038','257764',4904699,'3077','479',86012.22,86185.79,0.00,0.00,173.57,130177.50,0.00,0.00,0.00),('1','208','1038','257764',4904700,'3078','479',93942.03,94133.52,0.00,0.00,191.49,143617.50,0.00,0.00,0.00),('1','208','1038','257765',4904701,'3072','479',89886.39,90576.76,0.00,0.00,690.37,517777.50,0.00,0.00,0.00),('1','208','1038','257765',4904702,'3076','479',88099.82,88601.66,0.00,0.00,501.84,376380.00,0.00,0.00,0.00),('1','208','1038','257765',4904703,'3077','479',86185.79,86723.56,0.00,0.00,537.77,403327.50,0.00,0.00,0.00),('1','208','1038','257765',4904704,'3078','479',94133.52,94854.05,0.00,0.00,720.53,540397.50,0.00,0.00,0.00),('1','208','1038','257766',4904705,'3072','479',90576.76,91004.54,0.00,0.00,427.78,320835.00,0.00,0.00,0.00),('1','208','1038','257766',4904706,'3076','479',88601.66,89104.51,0.00,0.00,502.85,377137.50,0.00,0.00,0.00),('1','208','1038','257766',4904707,'3077','479',86723.56,87177.28,0.00,0.00,453.72,340290.00,0.00,0.00,0.00),('1','208','1038','257766',4904708,'3078','479',94854.05,95376.71,0.00,0.00,522.66,391995.00,0.00,0.00,0.00),('1','208','1038','257767',4904709,'3072','479',91004.54,91078.74,0.00,0.00,74.20,55650.00,0.00,0.00,0.00),('1','208','1038','257767',4904710,'3076','479',89104.51,89190.69,0.00,0.00,86.18,64635.00,0.00,0.00,0.00),('1','208','1038','257767',4904711,'3077','479',87177.28,87251.26,0.00,0.00,73.98,55485.00,0.00,0.00,0.00),('1','208','1038','257767',4904712,'3078','479',95376.71,95479.57,0.00,0.00,102.86,77145.00,0.00,0.00,0.00),('1','208','1038','257768',4904713,'3072','479',91078.74,91709.72,0.00,0.00,630.98,473235.00,0.00,0.00,0.00),('1','208','1038','257768',4904714,'3076','479',89190.69,89770.35,0.00,0.00,579.66,434745.00,0.00,0.00,0.00),('1','208','1038','257768',4904715,'3077','479',87251.26,87887.48,0.00,0.00,636.22,477165.00,0.00,0.00,0.00),('1','208','1038','257768',4904716,'3078','479',95479.57,96094.01,0.00,0.00,614.44,460830.00,0.00,0.00,0.00),('1','208','1038','257769',4904717,'3072','479',91709.72,92211.68,0.00,0.00,501.96,376470.00,0.00,0.00,0.00),('1','208','1038','257769',4904718,'3076','479',89770.35,90237.80,0.00,0.00,467.45,350587.50,0.00,0.00,0.00),('1','208','1038','257769',4904719,'3077','479',87887.48,88419.92,0.00,0.00,532.44,399330.00,0.00,0.00,0.00),('1','208','1038','257769',4904720,'3078','479',96094.01,96742.97,0.00,0.00,648.96,486720.00,0.00,0.00,0.00),('1','208','1038','257770',4904721,'3072','479',92211.68,92720.16,0.00,0.00,508.48,381360.00,0.00,0.00,0.00),('1','208','1038','257770',4904722,'3076','479',90237.80,90795.69,0.00,0.00,557.89,418417.50,0.00,0.00,0.00),('1','208','1038','257770',4904723,'3077','479',88419.92,89039.34,0.00,0.00,619.42,464565.00,0.00,0.00,0.00),('1','208','1038','257770',4904724,'3078','479',96742.97,97405.74,0.00,0.00,662.77,497077.50,0.00,0.00,0.00),('1','208','1038','257771',4904725,'3072','479',92720.16,93418.39,0.00,0.00,698.23,523672.50,0.00,0.00,0.00),('1','208','1038','257771',4904726,'3076','479',90795.69,91532.27,0.00,0.00,736.58,552435.00,0.00,0.00,0.00),('1','208','1038','257771',4904727,'3077','479',89039.34,89701.56,0.00,0.00,662.22,496665.00,0.00,0.00,0.00),('1','208','1038','257771',4904728,'3078','479',97405.74,98082.26,0.00,0.00,676.52,507390.00,0.00,0.00,0.00),('1','208','1038','257772',4904729,'3072','479',93418.39,93891.76,0.00,0.00,473.37,355027.50,0.00,0.00,0.00),('1','208','1038','257772',4904730,'3076','479',91532.27,91958.34,0.00,0.00,426.07,319552.50,0.00,0.00,0.00),('1','208','1038','257772',4904731,'3077','479',89701.56,90278.07,0.00,0.00,576.51,432382.50,0.00,0.00,0.00),('1','208','1038','257772',4904732,'3078','479',98082.26,98790.63,0.00,0.00,708.37,531277.50,0.00,0.00,0.00),('1','208','1038','257773',4904733,'3072','479',93891.76,94483.75,0.00,0.00,591.99,443992.50,0.00,0.00,0.00),('1','208','1038','257773',4904734,'3076','479',91958.34,92434.67,0.00,0.00,476.33,357247.50,0.00,0.00,0.00),('1','208','1038','257773',4904735,'3077','479',90278.07,90987.74,0.00,0.00,709.67,532252.50,0.00,0.00,0.00),('1','208','1038','257773',4904736,'3078','479',98790.63,99558.40,0.00,0.00,767.77,575827.50,0.00,0.00,0.00),('1','208','1038','257774',4904737,'3072','479',94483.75,94628.74,0.00,0.00,144.99,108742.50,0.00,0.00,0.00),('1','208','1038','257774',4904738,'3076','479',92434.67,92547.19,0.00,0.00,112.52,84390.00,0.00,0.00,0.00),('1','208','1038','257774',4904739,'3077','479',90987.74,91111.62,0.00,0.00,123.88,92910.00,0.00,0.00,0.00),('1','208','1038','257774',4904740,'3078','479',99558.40,99682.80,0.00,0.00,124.40,93300.00,0.00,0.00,0.00),('1','208','1038','257775',4904741,'3072','479',94628.74,95060.73,0.00,0.00,431.99,323992.50,0.00,0.00,0.00),('1','208','1038','257775',4904742,'3076','479',92547.19,93039.24,0.00,0.00,492.05,369037.50,0.00,0.00,0.00),('1','208','1038','257775',4904743,'3077','479',91111.62,91583.84,0.00,0.00,472.22,354165.00,0.00,0.00,0.00),('1','208','1038','257775',4904744,'3078','479',99682.80,100200.28,0.00,0.00,517.48,388110.00,0.00,0.00,0.00),('1','208','1038','257776',4904745,'3072','479',95060.73,95686.84,0.00,0.00,626.11,469582.50,0.00,0.00,0.00),('1','208','1038','257776',4904746,'3076','479',93039.24,93519.75,0.00,0.00,480.51,360382.50,0.00,0.00,0.00),('1','208','1038','257776',4904747,'3077','479',91583.84,92191.92,0.00,0.00,608.08,456060.00,0.00,0.00,0.00),('1','208','1038','257776',4904748,'3078','479',100200.28,100819.81,0.00,0.00,619.53,464647.50,0.00,0.00,0.00),('1','208','1038','257777',4904749,'3072','479',95686.84,95967.91,0.00,0.00,281.07,210802.50,0.00,0.00,0.00),('1','208','1038','257777',4904750,'3076','479',93519.75,93712.15,0.00,0.00,192.40,144300.00,0.00,0.00,0.00),('1','208','1038','257777',4904751,'3077','479',92191.92,92404.14,0.00,0.00,212.22,159165.00,0.00,0.00,0.00),('1','208','1038','257777',4904752,'3078','479',100819.81,101049.50,0.00,0.00,229.69,172267.50,0.00,0.00,0.00),('1','208','1038','257778',4904753,'3072','479',95967.91,96362.47,0.00,0.00,394.56,295920.00,0.00,0.00,0.00),('1','208','1038','257778',4904754,'3076','479',93712.15,94204.01,0.00,0.00,491.86,368895.00,0.00,0.00,0.00),('1','208','1038','257778',4904755,'3077','479',92404.14,92857.72,0.00,0.00,453.58,340185.00,0.00,0.00,0.00),('1','208','1038','257778',4904756,'3078','479',101049.50,101532.86,0.00,0.00,483.36,362520.00,0.00,0.00,0.00),('1','208','1038','257779',4904757,'3072','479',96362.47,97110.24,0.00,0.00,747.77,560827.50,0.00,0.00,0.00),('1','208','1038','257779',4904758,'3076','479',94204.01,94915.96,0.00,0.00,711.95,533962.50,0.00,0.00,0.00),('1','208','1038','257779',4904759,'3077','479',92857.72,93584.60,0.00,0.00,726.88,545160.00,0.00,0.00,0.00),('1','208','1038','257779',4904760,'3078','479',101532.86,102209.32,0.00,0.00,676.46,507345.00,0.00,0.00,0.00),('1','208','1038','257780',4904761,'3072','479',97110.24,97233.15,0.00,0.00,122.91,92182.50,0.00,0.00,0.00),('1','208','1038','257780',4904762,'3076','479',94915.96,95026.87,0.00,0.00,110.91,83182.50,0.00,0.00,0.00),('1','208','1038','257780',4904763,'3077','479',93584.60,93688.03,0.00,0.00,103.43,77572.50,0.00,0.00,0.00),('1','208','1038','257780',4904764,'3078','479',102209.32,102319.27,0.00,0.00,109.95,82462.50,0.00,0.00,0.00),('1','208','1038','257781',4904765,'3072','479',97233.15,97517.55,0.00,0.00,284.40,213300.00,0.00,0.00,0.00),('1','208','1038','257781',4904766,'3076','479',95026.87,95261.76,0.00,0.00,234.89,176167.50,0.00,0.00,0.00),('1','208','1038','257781',4904767,'3077','479',93688.03,94000.16,0.00,0.00,312.13,234097.50,0.00,0.00,0.00),('1','208','1038','257781',4904768,'3078','479',102319.27,102570.52,0.00,0.00,251.25,188437.50,0.00,0.00,0.00),('1','208','1038','257782',4904769,'3072','479',97517.55,98054.81,0.00,0.00,537.26,402945.00,0.00,0.00,0.00),('1','208','1038','257782',4904770,'3076','479',95261.76,95906.04,0.00,0.00,644.28,483210.00,0.00,0.00,0.00),('1','208','1038','257782',4904771,'3077','479',94000.16,94639.07,0.00,0.00,638.91,479182.50,0.00,0.00,0.00),('1','208','1038','257782',4904772,'3078','479',102570.52,103110.06,0.00,0.00,539.54,404655.00,0.00,0.00,0.00),('1','208','1038','257783',4904773,'3072','479',98054.81,98376.98,0.00,0.00,322.17,241627.50,0.00,0.00,0.00),('1','208','1038','257783',4904774,'3076','479',95906.04,96258.62,0.00,0.00,352.58,264435.00,0.00,0.00,0.00),('1','208','1038','257783',4904775,'3077','479',94639.07,95174.48,0.00,0.00,535.41,401557.50,0.00,0.00,0.00),('1','208','1038','257783',4904776,'3078','479',103110.06,103580.95,0.00,0.00,470.89,353167.50,0.00,0.00,0.00),('1','208','1038','257784',4904777,'3072','479',98376.98,98748.99,0.00,0.00,372.01,279007.50,0.00,0.00,0.00),('1','208','1038','257784',4904778,'3076','479',96258.62,96733.77,0.00,0.00,475.15,356362.50,0.00,0.00,0.00),('1','208','1038','257784',4904779,'3077','479',95174.48,95749.80,0.00,0.00,575.32,431490.00,0.00,0.00,0.00),('1','208','1038','257784',4904780,'3078','479',103580.95,104348.81,0.00,0.00,767.86,575895.00,0.00,0.00,0.00),('1','208','1038','257785',4904781,'3072','479',98748.99,99300.44,0.00,0.00,551.45,413587.50,0.00,0.00,0.00),('1','208','1038','257785',4904782,'3076','479',96733.77,97182.96,0.00,0.00,449.19,336892.50,0.00,0.00,0.00),('1','208','1038','257785',4904783,'3077','479',95749.80,96362.92,0.00,0.00,613.12,459840.00,0.00,0.00,0.00),('1','208','1038','257785',4904784,'3078','479',104348.81,105066.50,0.00,0.00,717.69,538267.50,0.00,0.00,0.00),('1','208','1038','257786',4904785,'3072','479',99300.44,99442.65,0.00,0.00,142.21,106657.50,0.00,0.00,0.00),('1','208','1038','257786',4904786,'3076','479',97182.96,97329.69,0.00,0.00,146.73,110047.50,0.00,0.00,0.00),('1','208','1038','257786',4904787,'3077','479',96362.92,96539.34,0.00,0.00,176.42,132315.00,0.00,0.00,0.00),('1','208','1038','257786',4904788,'3078','479',105066.50,105326.84,0.00,0.00,260.34,195255.00,0.00,0.00,0.00),('1','208','1038','257787',4904789,'3072','479',99442.65,99628.27,0.00,0.00,185.62,139215.00,0.00,0.00,0.00),('1','208','1038','257787',4904790,'3076','479',97329.69,97574.01,0.00,0.00,244.32,183240.00,0.00,0.00,0.00),('1','208','1038','257787',4904791,'3077','479',96539.34,96849.27,0.00,0.00,309.93,232447.50,0.00,0.00,0.00),('1','208','1038','257787',4904792,'3078','479',105326.84,105778.88,0.00,0.00,452.04,339030.00,0.00,0.00,0.00),('1','208','1038','257788',4904793,'3072','479',99628.27,99971.91,0.00,0.00,343.64,257730.00,0.00,0.00,0.00),('1','208','1038','257788',4904794,'3076','479',97574.01,97935.71,0.00,0.00,361.70,271275.00,0.00,0.00,0.00),('1','208','1038','257788',4904795,'3077','479',96849.27,97189.96,0.00,0.00,340.69,255517.50,0.00,0.00,0.00),('1','208','1038','257788',4904796,'3078','479',105778.88,106248.35,0.00,0.00,469.47,352102.50,0.00,0.00,0.00),('1','208','1038','257789',4904797,'3072','479',99971.91,100468.61,0.00,0.00,496.70,372525.00,0.00,0.00,0.00),('1','208','1038','257789',4904798,'3076','479',97935.71,98462.57,0.00,0.00,526.86,395145.00,0.00,0.00,0.00),('1','208','1038','257789',4904799,'3077','479',97189.96,97799.07,0.00,0.00,609.11,456832.50,0.00,0.00,0.00),('1','208','1038','257789',4904800,'3078','479',106248.35,106848.22,0.00,0.00,599.87,449902.50,0.00,0.00,0.00),('1','208','1038','257790',4904801,'3072','479',100468.61,100738.47,0.00,0.00,269.86,202395.00,0.00,0.00,0.00),('1','208','1038','257790',4904802,'3076','479',98462.57,98817.79,0.00,0.00,355.22,266415.00,0.00,0.00,0.00),('1','208','1038','257790',4904803,'3077','479',97799.07,98161.40,0.00,0.00,362.33,271747.50,0.00,0.00,0.00),('1','208','1038','257790',4904804,'3078','479',106848.22,107226.84,0.00,0.00,378.62,283965.00,0.00,0.00,0.00),('1','208','1038','257791',4904805,'3072','479',100738.47,100873.38,0.00,0.00,134.91,101182.50,0.00,0.00,0.00),('1','208','1038','257791',4904806,'3076','479',98817.79,98992.31,0.00,0.00,174.52,130890.00,0.00,0.00,0.00),('1','208','1038','257791',4904807,'3077','479',98161.40,98316.74,0.00,0.00,155.34,116505.00,0.00,0.00,0.00),('1','208','1038','257791',4904808,'3078','479',107226.84,107465.40,0.00,0.00,238.56,178920.00,0.00,0.00,0.00),('1','208','1038','257792',4904809,'3072','479',100873.38,101381.52,0.00,0.00,508.14,381105.00,0.00,0.00,0.00),('1','208','1038','257792',4904810,'3076','479',98992.31,99542.57,0.00,0.00,550.26,412695.00,0.00,0.00,0.00),('1','208','1038','257792',4904811,'3077','479',98316.74,98889.74,0.00,0.00,573.00,429750.00,0.00,0.00,0.00),('1','208','1038','257792',4904812,'3078','479',107465.40,107842.57,0.00,0.00,377.17,282877.50,0.00,0.00,0.00),('1','208','1038','257793',4904813,'3072','479',101381.52,101730.68,0.00,0.00,349.16,261870.00,0.00,0.00,0.00),('1','208','1038','257793',4904814,'3076','479',99542.57,99982.57,0.00,0.00,440.00,330000.00,0.00,0.00,0.00),('1','208','1038','257793',4904815,'3077','479',98889.74,99425.18,0.00,0.00,535.44,401580.00,0.00,0.00,0.00),('1','208','1038','257793',4904816,'3078','479',107842.57,108529.12,0.00,0.00,686.55,514912.50,0.00,0.00,0.00),('1','208','1038','257794',4904817,'3072','479',101730.68,101816.12,0.00,0.00,85.44,64080.00,0.00,0.00,0.00),('1','208','1038','257794',4904818,'3076','479',99982.57,100042.73,0.00,0.00,60.16,45120.00,0.00,0.00,0.00),('1','208','1038','257794',4904819,'3077','479',99425.18,99511.35,0.00,0.00,86.17,64627.50,0.00,0.00,0.00),('1','208','1038','257794',4904820,'3078','479',108529.12,108595.96,0.00,0.00,66.84,50130.00,0.00,0.00,0.00),('1','208','1038','257795',4904821,'3072','479',101816.12,102022.87,0.00,0.00,206.75,155062.50,0.00,0.00,0.00),('1','208','1038','257795',4904822,'3076','479',100042.73,100270.14,0.00,0.00,227.41,170557.50,0.00,0.00,0.00),('1','208','1038','257795',4904823,'3077','479',99511.35,99829.49,0.00,0.00,318.14,238605.00,0.00,0.00,0.00),('1','208','1038','257795',4904824,'3078','479',108595.96,108826.09,0.00,0.00,230.13,172597.50,0.00,0.00,0.00),('1','208','1038','257796',4904825,'3072','479',102022.87,102230.20,0.00,0.00,207.33,155497.50,0.00,0.00,0.00),('1','208','1038','257796',4904826,'3076','479',100270.14,100777.06,0.00,0.00,506.92,380190.00,0.00,0.00,0.00),('1','208','1038','257796',4904827,'3077','479',99829.49,100447.23,0.00,0.00,617.74,463305.00,0.00,0.00,0.00),('1','208','1038','257796',4904828,'3078','479',108826.09,109549.67,0.00,0.00,723.58,542685.00,0.00,0.00,0.00),('1','208','1038','257797',4904829,'3072','479',102230.20,103022.87,0.00,0.00,792.67,594502.50,0.00,0.00,0.00),('1','208','1038','257797',4904830,'3076','479',100777.06,101778.68,0.00,0.00,1001.62,751215.00,0.00,0.00,0.00),('1','208','1038','257797',4904831,'3077','479',100447.23,100594.49,0.00,0.00,147.26,110445.00,0.00,0.00,0.00),('1','208','1038','257797',4904832,'3078','479',109549.67,109651.58,0.00,0.00,101.91,76432.50,0.00,0.00,0.00),('1','208','1038','257798',4904833,'3072','479',103022.87,103924.50,0.00,0.00,901.63,676222.50,0.00,0.00,0.00),('1','208','1038','257798',4904834,'3076','479',101778.68,102964.90,0.00,0.00,1186.22,889665.00,0.00,0.00,0.00),('1','208','1038','257798',4904835,'3077','479',100594.49,100815.27,0.00,0.00,220.78,165585.00,0.00,0.00,0.00),('1','208','1038','257798',4904836,'3078','479',109651.58,109838.75,0.00,0.00,187.17,140377.50,0.00,0.00,0.00),('1','208','1038','257799',4904837,'3072','479',103924.50,104547.97,0.00,0.00,623.47,467602.50,0.00,0.00,0.00),('1','208','1038','257799',4904838,'3076','479',102964.90,103520.94,0.00,0.00,556.04,417030.00,0.00,0.00,0.00),('1','208','1038','257799',4904839,'3077','479',100815.27,101350.46,0.00,0.00,535.19,401392.50,0.00,0.00,0.00),('1','208','1038','257799',4904840,'3078','479',109838.75,110355.06,0.00,0.00,516.31,387232.50,0.00,0.00,0.00),('1','208','1038','257800',4904841,'3072','479',104547.97,104641.37,0.00,0.00,93.40,70050.00,0.00,0.00,0.00),('1','208','1038','257800',4904842,'3076','479',103520.94,103632.11,0.00,0.00,111.17,83377.50,0.00,0.00,0.00),('1','208','1038','257800',4904843,'3077','479',101350.46,101480.73,0.00,0.00,130.27,97702.50,0.00,0.00,0.00),('1','208','1038','257800',4904844,'3078','479',110355.06,110455.03,0.00,0.00,99.97,74977.50,0.00,0.00,0.00),('1','208','1038','257801',4904845,'3072','479',104641.37,104983.58,0.00,0.00,342.21,256657.50,0.00,0.00,0.00),('1','208','1038','257801',4904846,'3076','479',103632.11,104131.02,0.00,0.00,498.91,374182.50,0.00,0.00,0.00),('1','208','1038','257801',4904847,'3077','479',101480.73,102147.61,0.00,0.00,666.88,500160.00,0.00,0.00,0.00),('1','208','1038','257801',4904848,'3078','479',110455.03,111298.93,0.00,0.00,843.90,632925.00,0.00,0.00,0.00),('1','208','1038','257802',4904849,'3072','479',104983.58,105680.07,0.00,0.00,696.49,522367.50,0.00,0.00,0.00),('1','208','1038','257802',4904850,'3076','479',104131.02,104723.83,0.00,0.00,592.81,444607.50,0.00,0.00,0.00),('1','208','1038','257802',4904851,'3077','479',102147.61,102855.55,0.00,0.00,707.94,530955.00,0.00,0.00,0.00),('1','208','1038','257802',4904852,'3078','479',111298.93,112070.18,0.00,0.00,771.25,578437.50,0.00,0.00,0.00),('1','208','1038','257803',4904853,'3072','479',105680.07,106170.09,0.00,0.00,490.02,367515.00,0.00,0.00,0.00),('1','208','1038','257803',4904854,'3076','479',104723.83,105188.38,0.00,0.00,464.55,348412.50,0.00,0.00,0.00),('1','208','1038','257803',4904855,'3077','479',102855.55,103284.96,0.00,0.00,429.41,322057.50,0.00,0.00,0.00),('1','208','1038','257803',4904856,'3078','479',112070.18,112557.82,0.00,0.00,487.64,365730.00,0.00,0.00,0.00),('1','208','1038','257804',4904857,'3072','479',106170.09,106620.09,0.00,0.00,450.00,337500.00,0.00,0.00,0.00),('1','208','1038','257804',4904858,'3076','479',105188.38,105661.66,0.00,0.00,473.28,354960.00,0.00,0.00,0.00),('1','208','1038','257804',4904859,'3077','479',103284.96,103781.49,0.00,0.00,496.53,372397.50,0.00,0.00,0.00),('1','208','1038','257804',4904860,'3078','479',112557.82,113221.52,0.00,0.00,663.70,497775.00,0.00,0.00,0.00),('1','208','1038','257805',4904861,'3072','479',106620.09,106916.38,0.00,0.00,296.29,222217.50,0.00,0.00,0.00),('1','208','1038','257805',4904862,'3076','479',105661.66,106164.18,0.00,0.00,502.52,376890.00,0.00,0.00,0.00),('1','208','1038','257805',4904863,'3077','479',103781.49,104160.61,0.00,0.00,379.12,284340.00,0.00,0.00,0.00),('1','208','1038','257805',4904864,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257806',4904865,'3072','479',106916.38,107128.46,0.00,0.00,212.08,159060.00,0.00,0.00,0.00),('1','208','1038','257806',4904866,'3076','479',106164.18,106369.07,0.00,0.00,204.89,153667.50,0.00,0.00,0.00),('1','208','1038','257806',4904867,'3077','479',104160.61,104367.64,0.00,0.00,207.03,155272.50,0.00,0.00,0.00),('1','208','1038','257806',4904868,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257807',4904869,'3072','479',107128.46,107857.42,0.00,0.00,728.96,546720.00,0.00,0.00,0.00),('1','208','1038','257807',4904870,'3076','479',106369.07,107434.37,0.00,0.00,1065.30,798975.00,0.00,0.00,0.00),('1','208','1038','257807',4904871,'3077','479',104367.64,105255.50,0.00,0.00,887.86,665895.00,0.00,0.00,0.00),('1','208','1038','257807',4904872,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257808',4904873,'3072','479',107857.42,108269.79,0.00,0.00,412.37,309277.50,0.00,0.00,0.00),('1','208','1038','257808',4904874,'3076','479',107434.37,108202.19,0.00,0.00,767.82,575865.00,0.00,0.00,0.00),('1','208','1038','257808',4904875,'3077','479',105255.50,105930.89,0.00,0.00,675.39,506542.50,0.00,0.00,0.00),('1','208','1038','257808',4904876,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257809',4904877,'3072','479',108269.79,109012.37,0.00,0.00,742.58,556935.00,0.00,0.00,0.00),('1','208','1038','257809',4904878,'3076','479',108202.19,109223.97,0.00,0.00,1021.78,766335.00,0.00,0.00,0.00),('1','208','1038','257809',4904879,'3077','479',105930.89,106907.61,0.00,0.00,976.72,732540.00,0.00,0.00,0.00),('1','208','1038','257809',4904880,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257810',4904881,'3072','479',109012.37,109674.36,0.00,0.00,661.99,496492.50,0.00,0.00,0.00),('1','208','1038','257810',4904882,'3076','479',109223.97,110170.35,0.00,0.00,946.38,709785.00,0.00,0.00,0.00),('1','208','1038','257810',4904883,'3077','479',106907.61,107677.08,0.00,0.00,769.47,577102.50,0.00,0.00,0.00),('1','208','1038','257810',4904884,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257811',4904885,'3072','479',109674.36,110431.86,0.00,0.00,757.50,568125.00,0.00,0.00,0.00),('1','208','1038','257811',4904886,'3076','479',110170.35,111427.02,0.00,0.00,1256.67,942502.50,0.00,0.00,0.00),('1','208','1038','257811',4904887,'3077','479',107677.08,108685.82,0.00,0.00,1008.74,756555.00,0.00,0.00,0.00),('1','208','1038','257811',4904888,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257812',4904889,'3072','479',110431.86,110874.59,0.00,0.00,442.73,332047.50,0.00,0.00,0.00),('1','208','1038','257812',4904890,'3076','479',111427.02,112205.84,0.00,0.00,778.82,584115.00,0.00,0.00,0.00),('1','208','1038','257812',4904891,'3077','479',108685.82,109388.37,0.00,0.00,702.55,526912.50,0.00,0.00,0.00),('1','208','1038','257812',4904892,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257813',4904893,'3072','479',110874.59,111225.94,0.00,0.00,351.35,263512.50,0.00,0.00,0.00),('1','208','1038','257813',4904894,'3076','479',112205.84,113020.98,0.00,0.00,815.14,611355.00,0.00,0.00,0.00),('1','208','1038','257813',4904895,'3077','479',109388.37,110386.51,0.00,0.00,998.14,748605.00,0.00,0.00,0.00),('1','208','1038','257813',4904896,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257814',4904897,'3072','479',111225.94,111621.31,0.00,0.00,395.37,296527.50,0.00,0.00,0.00),('1','208','1038','257814',4904898,'3076','479',113020.98,113893.90,0.00,0.00,872.92,654690.00,0.00,0.00,0.00),('1','208','1038','257814',4904899,'3077','479',110386.51,111181.89,0.00,0.00,795.38,596535.00,0.00,0.00,0.00),('1','208','1038','257814',4904900,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257815',4904901,'3072','479',111621.31,111849.61,0.00,0.00,228.30,171225.00,0.00,0.00,0.00),('1','208','1038','257815',4904902,'3076','479',113893.90,114281.32,0.00,0.00,387.42,290565.00,0.00,0.00,0.00),('1','208','1038','257815',4904903,'3077','479',111181.89,111496.93,0.00,0.00,315.04,236280.00,0.00,0.00,0.00),('1','208','1038','257815',4904904,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257816',4904905,'3072','479',111849.61,112431.16,0.00,0.00,581.55,436162.50,0.00,0.00,0.00),('1','208','1038','257816',4904906,'3076','479',114281.32,115125.21,0.00,0.00,843.89,632917.50,0.00,0.00,0.00),('1','208','1038','257816',4904907,'3077','479',111496.93,112123.53,0.00,0.00,626.60,469950.00,0.00,0.00,0.00),('1','208','1038','257816',4904908,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257817',4904909,'3072','479',112431.16,113251.21,0.00,0.00,820.05,615037.50,0.00,0.00,0.00),('1','208','1038','257817',4904910,'3076','479',115125.21,116116.20,0.00,0.00,990.99,743242.50,0.00,0.00,0.00),('1','208','1038','257817',4904911,'3077','479',112123.53,112145.56,0.00,0.00,22.03,16522.50,0.00,0.00,0.00),('1','208','1038','257817',4904912,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257818',4904913,'3072','479',113251.21,113755.58,0.00,0.00,504.37,378277.50,0.00,0.00,0.00),('1','208','1038','257818',4904914,'3076','479',116116.20,116817.93,0.00,0.00,701.73,526297.50,0.00,0.00,0.00),('1','208','1038','257818',4904915,'3077','479',112145.56,112145.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257818',4904916,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257819',4904917,'3072','479',113755.58,114120.79,0.00,0.00,365.21,273907.50,0.00,0.00,0.00),('1','208','1038','257819',4904918,'3076','479',116817.93,117222.14,0.00,0.00,404.21,303157.50,0.00,0.00,0.00),('1','208','1038','257819',4904919,'3077','479',112145.56,112145.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257819',4904920,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257820',4904921,'3072','479',114120.79,114853.10,0.00,0.00,732.31,549232.50,0.00,0.00,0.00),('1','208','1038','257820',4904922,'3076','479',117222.14,118168.65,0.00,0.00,946.51,709882.50,0.00,0.00,0.00),('1','208','1038','257820',4904923,'3077','479',112145.56,112419.23,0.00,0.00,273.67,205252.50,0.00,0.00,0.00),('1','208','1038','257820',4904924,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257821',4904925,'3072','479',114853.10,115581.26,0.00,0.00,728.16,546120.00,0.00,0.00,0.00),('1','208','1038','257821',4904926,'3076','479',118168.65,118993.50,0.00,0.00,824.85,618637.50,0.00,0.00,0.00),('1','208','1038','257821',4904927,'3077','479',112419.23,113149.31,0.00,0.00,730.08,547560.00,0.00,0.00,0.00),('1','208','1038','257821',4904928,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257822',4904929,'3072','479',115581.26,115673.85,0.00,0.00,92.59,69442.50,0.00,0.00,0.00),('1','208','1038','257822',4904930,'3076','479',118993.50,119184.63,0.00,0.00,191.13,143347.50,0.00,0.00,0.00),('1','208','1038','257822',4904931,'3077','479',113149.31,113334.40,0.00,0.00,185.09,138817.50,0.00,0.00,0.00),('1','208','1038','257822',4904932,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257823',4904933,'3072','479',115673.85,116298.84,0.00,0.00,624.99,468742.50,0.00,0.00,0.00),('1','208','1038','257823',4904934,'3076','479',119184.63,120011.42,0.00,0.00,826.79,620092.50,0.00,0.00,0.00),('1','208','1038','257823',4904935,'3077','479',113334.40,114077.27,0.00,0.00,742.87,557152.50,0.00,0.00,0.00),('1','208','1038','257823',4904936,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257824',4904937,'3072','479',116298.84,116942.77,0.00,0.00,643.93,482947.50,0.00,0.00,0.00),('1','208','1038','257824',4904938,'3076','479',120011.42,120697.42,0.00,0.00,686.00,514500.00,0.00,0.00,0.00),('1','208','1038','257824',4904939,'3077','479',114077.27,114607.10,0.00,0.00,529.83,397372.50,0.00,0.00,0.00),('1','208','1038','257824',4904940,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257825',4904941,'3072','479',116942.77,117176.45,0.00,0.00,233.68,175260.00,0.00,0.00,0.00),('1','208','1038','257825',4904942,'3076','479',120697.42,121175.63,0.00,0.00,478.21,358657.50,0.00,0.00,0.00),('1','208','1038','257825',4904943,'3077','479',114607.10,114957.23,0.00,0.00,350.13,262597.50,0.00,0.00,0.00),('1','208','1038','257825',4904944,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257826',4904945,'3072','479',117176.45,117340.57,0.00,0.00,164.12,123090.00,0.00,0.00,0.00),('1','208','1038','257826',4904946,'3076','479',121175.63,121341.14,0.00,0.00,165.51,124132.50,0.00,0.00,0.00),('1','208','1038','257826',4904947,'3077','479',114957.23,115118.59,0.00,0.00,161.36,121020.00,0.00,0.00,0.00),('1','208','1038','257826',4904948,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257827',4904949,'3072','479',117340.57,117958.71,0.00,0.00,618.14,463605.00,0.00,0.00,0.00),('1','208','1038','257827',4904950,'3076','479',121341.14,122296.27,0.00,0.00,955.13,716347.50,0.00,0.00,0.00),('1','208','1038','257827',4904951,'3077','479',115118.59,115859.06,0.00,0.00,740.47,555352.50,0.00,0.00,0.00),('1','208','1038','257827',4904952,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257828',4904953,'3072','479',117958.71,118684.91,0.00,0.00,726.20,566436.00,0.00,0.00,0.00),('1','208','1038','257828',4904954,'3076','479',122296.27,123304.90,0.00,0.00,1008.63,786731.40,0.00,0.00,0.00),('1','208','1038','257828',4904955,'3077','479',115859.06,116755.32,0.00,0.00,896.26,699082.80,0.00,0.00,0.00),('1','208','1038','257828',4904956,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257829',4904957,'3072','479',118684.91,119040.94,0.00,0.00,356.03,277703.40,0.00,0.00,0.00),('1','208','1038','257829',4904958,'3076','479',123304.90,123811.61,0.00,0.00,506.71,395233.80,0.00,0.00,0.00),('1','208','1038','257829',4904959,'3077','479',116755.32,117189.28,0.00,0.00,433.96,338488.80,0.00,0.00,0.00),('1','208','1038','257829',4904960,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257830',4904961,'3072','479',119040.94,119565.22,0.00,0.00,524.28,408938.40,0.00,0.00,0.00),('1','208','1038','257830',4904962,'3076','479',123811.61,124295.24,0.00,0.00,483.63,377231.40,0.00,0.00,0.00),('1','208','1038','257830',4904963,'3077','479',117189.28,117693.47,0.00,0.00,504.19,393268.20,0.00,0.00,0.00),('1','208','1038','257830',4904964,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257831',4904965,'3072','479',119565.22,120398.00,0.00,0.00,832.78,649568.40,0.00,0.00,0.00),('1','208','1038','257831',4904966,'3076','479',124295.24,125467.14,0.00,0.00,1171.90,914082.00,0.00,0.00,0.00),('1','208','1038','257831',4904967,'3077','479',117693.47,118965.11,0.00,0.00,1271.64,991879.20,0.00,0.00,0.00),('1','208','1038','257831',4904968,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257832',4904969,'3072','479',120398.00,120573.65,0.00,0.00,175.65,137007.00,0.00,0.00,0.00),('1','208','1038','257832',4904970,'3076','479',125467.14,125689.06,0.00,0.00,221.92,173097.60,0.00,0.00,0.00),('1','208','1038','257832',4904971,'3077','479',118965.11,119176.46,0.00,0.00,211.35,164853.00,0.00,0.00,0.00),('1','208','1038','257832',4904972,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257833',4904973,'3072','479',120573.65,121084.90,0.00,0.00,511.25,398775.00,0.00,0.00,0.00),('1','208','1038','257833',4904974,'3076','479',125689.06,126249.87,0.00,0.00,560.81,437431.80,0.00,0.00,0.00),('1','208','1038','257833',4904975,'3077','479',119176.46,119697.59,0.00,0.00,521.13,406481.40,0.00,0.00,0.00),('1','208','1038','257833',4904976,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257834',4904977,'3072','479',121084.90,122007.80,0.00,0.00,922.90,719862.00,0.00,0.00,0.00),('1','208','1038','257834',4904978,'3076','479',126249.87,127389.67,0.00,0.00,1139.80,889044.00,0.00,0.00,0.00),('1','208','1038','257834',4904979,'3077','479',119697.59,120761.16,0.00,0.00,1063.57,829584.60,0.00,0.00,0.00),('1','208','1038','257834',4904980,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257835',4904981,'3072','479',122007.80,122115.07,0.00,0.00,107.27,83670.60,0.00,0.00,0.00),('1','208','1038','257835',4904982,'3076','479',127389.67,127558.47,0.00,0.00,168.80,131664.00,0.00,0.00,0.00),('1','208','1038','257835',4904983,'3077','479',120761.16,120928.87,0.00,0.00,167.71,130813.80,0.00,0.00,0.00),('1','208','1038','257835',4904984,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257836',4904985,'3072','479',122115.07,122663.69,0.00,0.00,548.62,427923.60,0.00,0.00,0.00),('1','208','1038','257836',4904986,'3076','479',127558.47,128253.34,0.00,0.00,694.87,541998.60,0.00,0.00,0.00),('1','208','1038','257836',4904987,'3077','479',120928.87,121539.55,0.00,0.00,610.68,476330.40,0.00,0.00,0.00),('1','208','1038','257836',4904988,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257837',4904989,'3072','479',122663.69,123425.02,0.00,0.00,761.33,593837.40,0.00,0.00,0.00),('1','208','1038','257837',4904990,'3076','479',128253.34,129263.66,0.00,0.00,1010.32,788049.60,0.00,0.00,0.00),('1','208','1038','257837',4904991,'3077','479',121539.55,122485.18,0.00,0.00,945.63,737591.40,0.00,0.00,0.00),('1','208','1038','257837',4904992,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257838',4904993,'3072','479',123425.02,123661.07,0.00,0.00,236.05,184119.00,0.00,0.00,0.00),('1','208','1038','257838',4904994,'3076','479',129263.66,129585.47,0.00,0.00,321.81,251011.80,0.00,0.00,0.00),('1','208','1038','257838',4904995,'3077','479',122485.18,122780.44,0.00,0.00,295.26,230302.80,0.00,0.00,0.00),('1','208','1038','257838',4904996,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257839',4904997,'3072','479',123661.07,123850.44,0.00,0.00,189.37,147708.60,0.00,0.00,0.00),('1','208','1038','257839',4904998,'3076','479',129585.47,129844.44,0.00,0.00,258.97,201996.60,0.00,0.00,0.00),('1','208','1038','257839',4904999,'3077','479',122780.44,123005.97,0.00,0.00,225.53,175913.40,0.00,0.00,0.00),('1','208','1038','257839',4905000,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257840',4905001,'3072','479',123850.44,124464.61,0.00,0.00,614.17,479052.60,0.00,0.00,0.00),('1','208','1038','257840',4905002,'3076','479',129844.44,130815.55,0.00,0.00,971.11,757465.80,0.00,0.00,0.00),('1','208','1038','257840',4905003,'3077','479',123005.97,123909.15,0.00,0.00,903.18,704480.40,0.00,0.00,0.00),('1','208','1038','257840',4905004,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257841',4905005,'3072','479',124464.61,124961.06,0.00,0.00,496.45,387231.00,0.00,0.00,0.00),('1','208','1038','257841',4905006,'3076','479',130815.55,131558.99,0.00,0.00,743.44,579883.20,0.00,0.00,0.00),('1','208','1038','257841',4905007,'3077','479',123909.15,124625.26,0.00,0.00,716.11,558565.80,0.00,0.00,0.00),('1','208','1038','257841',4905008,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257842',4905009,'3072','479',124961.06,125038.24,0.00,0.00,77.18,60200.40,0.00,0.00,0.00),('1','208','1038','257842',4905010,'3076','479',131558.99,131676.41,0.00,0.00,117.42,91587.60,0.00,0.00,0.00),('1','208','1038','257842',4905011,'3077','479',124625.26,124729.34,0.00,0.00,104.08,81182.40,0.00,0.00,0.00),('1','208','1038','257842',4905012,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257843',4905013,'3072','479',125038.24,125468.54,0.00,0.00,430.30,335634.00,0.00,0.00,0.00),('1','208','1038','257843',4905014,'3076','479',131676.41,132211.21,0.00,0.00,534.80,417144.00,0.00,0.00,0.00),('1','208','1038','257843',4905015,'3077','479',124729.34,125144.34,0.00,0.00,415.00,323700.00,0.00,0.00,0.00),('1','208','1038','257843',4905016,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257844',4905017,'3072','479',125468.54,125967.68,0.00,0.00,499.14,389329.20,0.00,0.00,0.00),('1','208','1038','257844',4905018,'3076','479',132211.21,133023.69,0.00,0.00,812.48,633734.40,0.00,0.00,0.00),('1','208','1038','257844',4905019,'3077','479',125144.34,125976.76,0.00,0.00,832.42,649287.60,0.00,0.00,0.00),('1','208','1038','257844',4905020,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257845',4905021,'3072','479',125967.68,126309.38,0.00,0.00,341.70,266526.00,0.00,0.00,0.00),('1','208','1038','257845',4905022,'3076','479',133023.69,133715.37,0.00,0.00,691.68,539510.40,0.00,0.00,0.00),('1','208','1038','257845',4905023,'3077','479',125976.76,126643.38,0.00,0.00,666.62,519963.60,0.00,0.00,0.00),('1','208','1038','257845',4905024,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257846',4905025,'3072','479',126309.38,126334.38,0.00,0.00,25.00,19500.00,0.00,0.00,0.00),('1','208','1038','257846',4905026,'3076','479',133715.37,133755.77,0.00,0.00,40.40,31512.00,0.00,0.00,0.00),('1','208','1038','257846',4905027,'3077','479',126643.38,126664.65,0.00,0.00,21.27,16590.60,0.00,0.00,0.00),('1','208','1038','257846',4905028,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257847',4905029,'3072','479',126334.38,126679.19,0.00,0.00,344.81,268951.80,0.00,0.00,0.00),('1','208','1038','257847',4905030,'3076','479',133755.77,134316.30,0.00,0.00,560.53,437213.40,0.00,0.00,0.00),('1','208','1038','257847',4905031,'3077','479',126664.65,127257.78,0.00,0.00,593.13,462641.40,0.00,0.00,0.00),('1','208','1038','257847',4905032,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257848',4905033,'3072','479',126679.19,127053.24,0.00,0.00,374.05,291759.00,0.00,0.00,0.00),('1','208','1038','257848',4905034,'3076','479',134316.30,135050.74,0.00,0.00,734.44,572863.20,0.00,0.00,0.00),('1','208','1038','257848',4905035,'3077','479',127257.78,127918.58,0.00,0.00,660.80,515424.00,0.00,0.00,0.00),('1','208','1038','257848',4905036,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257849',4905037,'3072','479',127053.24,127466.23,0.00,0.00,412.99,322132.20,0.00,0.00,0.00),('1','208','1038','257849',4905038,'3076','479',135050.74,135886.73,0.00,0.00,835.99,652072.20,0.00,0.00,0.00),('1','208','1038','257849',4905039,'3077','479',127918.58,128786.96,0.00,0.00,868.38,677336.40,0.00,0.00,0.00),('1','208','1038','257849',4905040,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257850',4905041,'3072','479',127466.23,127894.71,0.00,0.00,428.48,334214.40,0.00,0.00,0.00),('1','208','1038','257850',4905042,'3076','479',135886.73,136594.34,0.00,0.00,707.61,551935.80,0.00,0.00,0.00),('1','208','1038','257850',4905043,'3077','479',128786.96,129519.73,0.00,0.00,732.77,571560.60,0.00,0.00,0.00),('1','208','1038','257850',4905044,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257851',4905045,'3072','479',127894.71,128251.11,0.00,0.00,356.40,277992.00,0.00,0.00,0.00),('1','208','1038','257851',4905046,'3076','479',136594.34,137080.12,0.00,0.00,485.78,378908.40,0.00,0.00,0.00),('1','208','1038','257851',4905047,'3077','479',129519.73,130005.41,0.00,0.00,485.68,378830.40,0.00,0.00,0.00),('1','208','1038','257851',4905048,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257852',4905049,'3072','479',128251.11,128418.00,0.00,0.00,166.89,130174.20,0.00,0.00,0.00),('1','208','1038','257852',4905050,'3076','479',137080.12,137221.24,0.00,0.00,141.12,110073.60,0.00,0.00,0.00),('1','208','1038','257852',4905051,'3077','479',130005.41,130132.67,0.00,0.00,127.26,99262.80,0.00,0.00,0.00),('1','208','1038','257852',4905052,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257853',4905053,'3072','479',128418.00,129573.45,0.00,0.00,1155.45,901251.00,0.00,0.00,0.00),('1','208','1038','257853',4905054,'3076','479',137221.24,138617.32,0.00,0.00,1396.08,1088942.40,0.00,0.00,0.00),('1','208','1038','257853',4905055,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257853',4905056,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257854',4905057,'3072','479',129573.45,130454.75,0.00,0.00,881.30,687414.00,0.00,0.00,0.00),('1','208','1038','257854',4905058,'3076','479',138617.32,139670.39,0.00,0.00,1053.07,821394.60,0.00,0.00,0.00),('1','208','1038','257854',4905059,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257854',4905060,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257855',4905061,'3072','479',130454.75,131312.59,0.00,0.00,857.84,669115.20,0.00,0.00,0.00),('1','208','1038','257855',4905062,'3076','479',139670.39,140849.17,0.00,0.00,1178.78,919448.40,0.00,0.00,0.00),('1','208','1038','257855',4905063,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257855',4905064,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257856',4905065,'3072','479',131312.59,132048.43,0.00,0.00,735.84,573955.20,0.00,0.00,0.00),('1','208','1038','257856',4905066,'3076','479',140849.17,141954.09,0.00,0.00,1104.92,861837.60,0.00,0.00,0.00),('1','208','1038','257856',4905067,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257856',4905068,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257857',4905069,'3072','479',132048.43,132651.43,0.00,0.00,603.00,470340.00,0.00,0.00,0.00),('1','208','1038','257857',4905070,'3076','479',141954.09,142632.70,0.00,0.00,678.61,529315.80,0.00,0.00,0.00),('1','208','1038','257857',4905071,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257857',4905072,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257858',4905073,'3072','479',132651.43,132928.04,0.00,0.00,276.61,215755.80,0.00,0.00,0.00),('1','208','1038','257858',4905074,'3076','479',142632.70,142962.28,0.00,0.00,329.58,257072.40,0.00,0.00,0.00),('1','208','1038','257858',4905075,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257858',4905076,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257859',4905077,'3072','479',132928.04,133999.56,0.00,0.00,1071.52,835785.60,0.00,0.00,0.00),('1','208','1038','257859',4905078,'3076','479',142962.28,144110.14,0.00,0.00,1147.86,895330.80,0.00,0.00,0.00),('1','208','1038','257859',4905079,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257859',4905080,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257860',4905081,'3072','479',133999.56,135059.00,0.00,0.00,1059.44,826363.20,0.00,0.00,0.00),('1','208','1038','257860',4905082,'3076','479',144110.14,145352.83,0.00,0.00,1242.69,969298.20,0.00,0.00,0.00),('1','208','1038','257860',4905083,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257860',4905084,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257861',4905085,'3072','479',135059.00,136379.86,0.00,0.00,1320.86,1023875.21,0.00,0.00,0.00),('1','208','1038','257861',4905086,'3076','479',145352.83,146754.23,0.00,0.00,1401.40,1099453.00,0.00,0.00,0.00),('1','208','1038','257861',4905087,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257861',4905088,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257862',4905089,'3072','479',136379.86,136582.05,0.00,0.00,202.19,157708.20,0.00,0.00,0.00),('1','208','1038','257862',4905090,'3076','479',146754.23,147030.03,0.00,0.00,275.80,215124.00,0.00,0.00,0.00),('1','208','1038','257862',4905091,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257862',4905092,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257863',4905093,'3072','479',136582.05,137580.61,0.00,0.00,998.56,734940.16,0.00,0.00,0.00),('1','208','1038','257863',4905094,'3076','479',147030.03,148060.95,0.00,0.00,1030.92,758757.12,0.00,0.00,0.00),('1','208','1038','257863',4905095,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257863',4905096,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257864',4905097,'3072','479',137580.61,138372.75,0.00,0.00,792.14,583015.04,0.00,0.00,0.00),('1','208','1038','257864',4905098,'3076','479',148060.95,148766.30,0.00,0.00,705.35,519137.60,0.00,0.00,0.00),('1','208','1038','257864',4905099,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257864',4905100,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257865',4905101,'3072','479',138372.75,139578.20,0.00,0.00,1205.45,887211.20,0.00,0.00,0.00),('1','208','1038','257865',4905102,'3076','479',148766.30,150165.34,0.00,0.00,1399.04,1029693.44,0.00,0.00,0.00),('1','208','1038','257865',4905103,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257865',4905104,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257866',4905105,'3072','479',139578.20,139845.35,0.00,0.00,267.15,196622.40,0.00,0.00,0.00),('1','208','1038','257866',4905106,'3076','479',150165.34,150535.14,0.00,0.00,369.80,272172.80,0.00,0.00,0.00),('1','208','1038','257866',4905107,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257866',4905108,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257867',4905109,'3072','479',139845.35,140753.78,0.00,0.00,908.43,668604.48,0.00,0.00,0.00),('1','208','1038','257867',4905110,'3076','479',150535.14,151642.65,0.00,0.00,1107.51,815127.36,0.00,0.00,0.00),('1','208','1038','257867',4905111,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257867',4905112,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257868',4905113,'3072','479',140753.78,142241.84,0.00,0.00,1488.06,1095212.16,0.00,0.00,0.00),('1','208','1038','257868',4905114,'3076','479',151642.65,153338.23,0.00,0.00,1695.58,1247912.28,0.00,0.00,0.00),('1','208','1038','257868',4905115,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257868',4905116,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257869',4905117,'3072','479',142241.84,142974.29,0.00,0.00,732.45,539083.20,0.00,0.00,0.00),('1','208','1038','257869',4905118,'3076','479',153338.23,153998.39,0.00,0.00,660.16,485877.76,0.00,0.00,0.00),('1','208','1038','257869',4905119,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257869',4905120,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257870',4905121,'3072','479',142974.29,144277.69,0.00,0.00,1303.40,959302.40,0.00,0.00,0.00),('1','208','1038','257870',4905122,'3076','479',153998.39,155580.36,0.00,0.00,1581.97,1164329.92,0.00,0.00,0.00),('1','208','1038','257870',4905123,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257870',4905124,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257871',4905125,'3072','479',144277.69,145224.46,0.00,0.00,946.77,696822.72,0.00,0.00,0.00),('1','208','1038','257871',4905126,'3076','479',155580.36,156718.19,0.00,0.00,1137.83,837442.88,0.00,0.00,0.00),('1','208','1038','257871',4905127,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257871',4905128,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257872',4905129,'3072','479',145224.46,145422.74,0.00,0.00,198.28,145934.08,0.00,0.00,0.00),('1','208','1038','257872',4905130,'3076','479',156718.19,156949.81,0.00,0.00,231.62,170472.32,0.00,0.00,0.00),('1','208','1038','257872',4905131,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257872',4905132,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257873',4905133,'3072','479',145422.74,145970.22,0.00,0.00,547.48,402945.28,0.00,0.00,0.00),('1','208','1038','257873',4905134,'3076','479',156949.81,157795.90,0.00,0.00,846.09,622722.24,0.00,0.00,0.00),('1','208','1038','257873',4905135,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257873',4905136,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257874',4905137,'3072','479',145970.22,147146.35,0.00,0.00,1176.13,865631.68,0.00,0.00,0.00),('1','208','1038','257874',4905138,'3076','479',157795.90,159062.05,0.00,0.00,1266.15,931886.40,0.00,0.00,0.00),('1','208','1038','257874',4905139,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257874',4905140,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257875',4905141,'3072','479',147146.35,147567.47,0.00,0.00,421.12,309944.32,0.00,0.00,0.00),('1','208','1038','257875',4905142,'3076','479',159062.05,159503.15,0.00,0.00,441.10,324649.60,0.00,0.00,0.00),('1','208','1038','257875',4905143,'3077','479',130132.67,130132.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257875',4905144,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257876',4905145,'3072','479',147567.47,147783.52,0.00,0.00,216.05,159012.80,0.00,0.00,0.00),('1','208','1038','257876',4905146,'3076','479',159503.15,159791.59,0.00,0.00,288.44,212291.84,0.00,0.00,0.00),('1','208','1038','257876',4905147,'3077','479',130132.67,130267.32,0.00,0.00,134.65,99102.40,0.00,0.00,0.00),('1','208','1038','257876',4905148,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257877',4905149,'3072','479',147783.52,149080.15,0.00,0.00,1296.63,954319.68,0.00,0.00,0.00),('1','208','1038','257877',4905150,'3076','479',159791.59,161048.99,0.00,0.00,1257.40,925446.40,0.00,0.00,0.00),('1','208','1038','257877',4905151,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257877',4905152,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257878',4905153,'3072','479',149080.15,149906.32,0.00,0.00,826.17,608061.12,0.00,0.00,0.00),('1','208','1038','257878',4905154,'3076','479',161048.99,162239.67,0.00,0.00,1190.68,876340.48,0.00,0.00,0.00),('1','208','1038','257878',4905155,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257878',4905156,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257879',4905157,'3072','479',149906.32,150688.80,0.00,0.00,782.48,575905.28,0.00,0.00,0.00),('1','208','1038','257879',4905158,'3076','479',162239.67,163106.48,0.00,0.00,866.81,637972.16,0.00,0.00,0.00),('1','208','1038','257879',4905159,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257879',4905160,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257880',4905161,'3072','479',150688.80,151642.42,0.00,0.00,953.62,701864.32,0.00,0.00,0.00),('1','208','1038','257880',4905162,'3076','479',163106.48,164243.84,0.00,0.00,1137.36,837096.96,0.00,0.00,0.00),('1','208','1038','257880',4905163,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257880',4905164,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257881',4905165,'3072','479',151642.42,152544.70,0.00,0.00,902.28,664078.08,0.00,0.00,0.00),('1','208','1038','257881',4905166,'3076','479',164243.84,165307.40,0.00,0.00,1063.56,782780.16,0.00,0.00,0.00),('1','208','1038','257881',4905167,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257881',4905168,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257882',4905169,'3072','479',152544.70,153049.88,0.00,0.00,505.18,371812.48,0.00,0.00,0.00),('1','208','1038','257882',4905170,'3076','479',165307.40,165849.67,0.00,0.00,542.27,399110.72,0.00,0.00,0.00),('1','208','1038','257882',4905171,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257882',4905172,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257883',4905173,'3072','479',153049.88,153308.66,0.00,0.00,258.78,190462.08,0.00,0.00,0.00),('1','208','1038','257883',4905174,'3076','479',165849.67,166164.95,0.00,0.00,315.28,232046.08,0.00,0.00,0.00),('1','208','1038','257883',4905175,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257883',4905176,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257884',4905177,'3072','479',153308.66,153789.94,0.00,0.00,481.28,354222.08,0.00,0.00,0.00),('1','208','1038','257884',4905178,'3076','479',166164.95,166660.66,0.00,0.00,495.71,364842.56,0.00,0.00,0.00),('1','208','1038','257884',4905179,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257884',4905180,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257885',4905181,'3072','479',153789.94,154164.06,0.00,0.00,374.12,275352.32,0.00,0.00,0.00),('1','208','1038','257885',4905182,'3076','479',166660.66,167103.46,0.00,0.00,442.80,325900.80,0.00,0.00,0.00),('1','208','1038','257885',4905183,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257885',4905184,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257886',4905185,'3072','479',154164.06,155080.89,0.00,0.00,916.83,674786.88,0.00,0.00,0.00),('1','208','1038','257886',4905186,'3076','479',167103.46,168293.69,0.00,0.00,1190.23,876009.28,0.00,0.00,0.00),('1','208','1038','257886',4905187,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257886',4905188,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257887',4905189,'3072','479',155080.89,155971.44,0.00,0.00,890.55,655444.80,0.00,0.00,0.00),('1','208','1038','257887',4905190,'3076','479',168293.69,169302.21,0.00,0.00,1008.52,742270.72,0.00,0.00,0.00),('1','208','1038','257887',4905191,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257887',4905192,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257888',4905193,'3072','479',155971.44,156705.35,0.00,0.00,733.91,540157.76,0.00,0.00,0.00),('1','208','1038','257888',4905194,'3076','479',169302.21,170151.49,0.00,0.00,849.28,625070.08,0.00,0.00,0.00),('1','208','1038','257888',4905195,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257888',4905196,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257889',4905197,'3072','479',156705.35,157751.67,0.00,0.00,1046.32,770091.52,0.00,0.00,0.00),('1','208','1038','257889',4905198,'3076','479',170151.49,171357.03,0.00,0.00,1205.54,887277.44,0.00,0.00,0.00),('1','208','1038','257889',4905199,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257889',4905200,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257890',4905201,'3072','479',157751.67,158807.03,0.00,0.00,1055.36,776744.96,0.00,0.00,0.00),('1','208','1038','257890',4905202,'3076','479',171357.03,172525.84,0.00,0.00,1168.81,860244.16,0.00,0.00,0.00),('1','208','1038','257890',4905203,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257890',4905204,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257891',4905205,'3072','479',158807.03,159183.19,0.00,0.00,376.16,276853.76,0.00,0.00,0.00),('1','208','1038','257891',4905206,'3076','479',172525.84,173029.41,0.00,0.00,503.57,370627.52,0.00,0.00,0.00),('1','208','1038','257891',4905207,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257891',4905208,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257892',4905209,'3072','479',159183.19,159828.42,0.00,0.00,645.23,474889.28,0.00,0.00,0.00),('1','208','1038','257892',4905210,'3076','479',173029.41,173644.97,0.00,0.00,615.56,453052.16,0.00,0.00,0.00),('1','208','1038','257892',4905211,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257892',4905212,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257893',4905213,'3072','479',159828.42,160746.01,0.00,0.00,917.59,675346.24,0.00,0.00,0.00),('1','208','1038','257893',4905214,'3076','479',173644.97,174803.20,0.00,0.00,1158.23,852457.28,0.00,0.00,0.00),('1','208','1038','257893',4905215,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257893',4905216,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257894',4905217,'3072','479',160746.01,161563.89,0.00,0.00,817.88,601959.68,0.00,0.00,0.00),('1','208','1038','257894',4905218,'3076','479',174803.20,175818.53,0.00,0.00,1015.33,747282.88,0.00,0.00,0.00),('1','208','1038','257894',4905219,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257894',4905220,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257895',4905221,'3072','479',161563.89,161975.08,0.00,0.00,411.19,302635.84,0.00,0.00,0.00),('1','208','1038','257895',4905222,'3076','479',175818.53,176260.75,0.00,0.00,442.22,325473.92,0.00,0.00,0.00),('1','208','1038','257895',4905223,'3077','479',130267.32,130267.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257895',4905224,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257896',4905225,'3072','479',161975.08,162331.17,0.00,0.00,356.09,262082.24,0.00,0.00,0.00),('1','208','1038','257896',4905226,'3076','479',176260.75,176818.20,0.00,0.00,557.45,410283.20,0.00,0.00,0.00),('1','208','1038','257896',4905227,'3077','479',130267.32,130732.40,0.00,0.00,465.08,342298.88,0.00,0.00,0.00),('1','208','1038','257896',4905228,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257897',4905229,'3072','479',162331.17,163204.99,0.00,0.00,873.82,643131.52,0.00,0.00,0.00),('1','208','1038','257897',4905230,'3076','479',176818.20,177968.45,0.00,0.00,1150.25,846584.00,0.00,0.00,0.00),('1','208','1038','257897',4905231,'3077','479',130732.40,131367.31,0.00,0.00,634.91,467293.76,0.00,0.00,0.00),('1','208','1038','257897',4905232,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257898',4905233,'3072','479',163204.99,163506.40,0.00,0.00,301.41,221837.76,0.00,0.00,0.00),('1','208','1038','257898',4905234,'3076','479',177968.45,178369.90,0.00,0.00,401.45,295467.20,0.00,0.00,0.00),('1','208','1038','257898',4905235,'3077','479',131367.31,131787.96,0.00,0.00,420.65,309598.40,0.00,0.00,0.00),('1','208','1038','257898',4905236,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257899',4905237,'3072','479',163506.40,163875.77,0.00,0.00,369.37,271856.32,0.00,0.00,0.00),('1','208','1038','257899',4905238,'3076','479',178369.90,178771.98,0.00,0.00,402.08,295930.88,0.00,0.00,0.00),('1','208','1038','257899',4905239,'3077','479',131787.96,132122.99,0.00,0.00,335.03,246582.08,0.00,0.00,0.00),('1','208','1038','257899',4905240,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257900',4905241,'3072','479',163875.77,164833.92,0.00,0.00,958.15,705198.40,0.00,0.00,0.00),('1','208','1038','257900',4905242,'3076','479',178771.98,179764.25,0.00,0.00,992.27,730310.72,0.00,0.00,0.00),('1','208','1038','257900',4905243,'3077','479',132122.99,132773.01,0.00,0.00,650.02,478414.72,0.00,0.00,0.00),('1','208','1038','257900',4905244,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257901',4905245,'3072','479',164833.92,165531.27,0.00,0.00,697.35,513249.60,0.00,0.00,0.00),('1','208','1038','257901',4905246,'3076','479',179764.25,180533.73,0.00,0.00,769.48,566337.28,0.00,0.00,0.00),('1','208','1038','257901',4905247,'3077','479',132773.01,132773.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257901',4905248,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257902',4905249,'3072','479',165531.27,165702.87,0.00,0.00,171.60,126297.60,0.00,0.00,0.00),('1','208','1038','257902',4905250,'3076','479',180533.73,180745.72,0.00,0.00,211.99,156024.64,0.00,0.00,0.00),('1','208','1038','257902',4905251,'3077','479',132773.01,132773.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257902',4905252,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257903',4905253,'3072','479',165702.87,166646.42,0.00,0.00,943.55,694452.80,0.00,0.00,0.00),('1','208','1038','257903',4905254,'3076','479',180745.72,181701.02,0.00,0.00,955.30,702948.48,0.00,0.00,0.00),('1','208','1038','257903',4905255,'3077','479',132773.01,132773.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257903',4905256,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257904',4905257,'3072','479',166646.42,166857.36,0.00,0.00,210.94,155251.84,0.00,0.00,0.00),('1','208','1038','257904',4905258,'3076','479',181701.02,182015.45,0.00,0.00,314.43,231420.48,0.00,0.00,0.00),('1','208','1038','257904',4905259,'3077','479',132773.01,132773.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257904',4905260,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257905',4905261,'3072','479',166857.36,167367.74,0.00,0.00,510.38,375639.68,0.00,0.00,0.00),('1','208','1038','257905',4905262,'3076','479',182015.45,182657.03,0.00,0.00,641.58,472202.88,0.00,0.00,0.00),('1','208','1038','257905',4905263,'3077','479',132773.01,132773.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257905',4905264,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257906',4905265,'3072','479',167367.74,168564.43,0.00,0.00,1196.69,880763.84,0.00,0.00,0.00),('1','208','1038','257906',4905266,'3076','479',182657.03,183996.95,0.00,0.00,1339.92,986181.12,0.00,0.00,0.00),('1','208','1038','257906',4905267,'3077','479',132773.01,132940.98,0.00,0.00,167.97,123625.92,0.00,0.00,0.00),('1','208','1038','257906',4905268,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257907',4905269,'3072','479',168564.43,169178.54,0.00,0.00,614.11,451984.96,0.00,0.00,0.00),('1','208','1038','257907',4905270,'3076','479',183996.95,184985.77,0.00,0.00,988.82,727771.52,0.00,0.00,0.00),('1','208','1038','257907',4905271,'3077','479',132940.98,132940.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257907',4905272,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257908',4905273,'3072','479',169178.54,169415.91,0.00,0.00,237.37,174704.32,0.00,0.00,0.00),('1','208','1038','257908',4905274,'3076','479',184985.77,185231.07,0.00,0.00,245.30,180540.80,0.00,0.00,0.00),('1','208','1038','257908',4905275,'3077','479',132940.98,133188.83,0.00,0.00,247.85,182417.60,0.00,0.00,0.00),('1','208','1038','257908',4905276,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257909',4905277,'3072','479',169415.91,170154.44,0.00,0.00,738.53,543558.08,0.00,0.00,0.00),('1','208','1038','257909',4905278,'3076','479',185231.07,186212.57,0.00,0.00,981.50,722384.00,0.00,0.00,0.00),('1','208','1038','257909',4905279,'3077','479',133188.83,134092.47,0.00,0.00,903.64,665079.04,0.00,0.00,0.00),('1','208','1038','257909',4905280,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257910',4905281,'3072','479',170154.44,170750.09,0.00,0.00,595.65,438398.40,0.00,0.00,0.00),('1','208','1038','257910',4905282,'3076','479',186212.57,187050.41,0.00,0.00,837.84,616650.24,0.00,0.00,0.00),('1','208','1038','257910',4905283,'3077','479',134092.47,134712.10,0.00,0.00,619.63,456047.68,0.00,0.00,0.00),('1','208','1038','257910',4905284,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257911',4905285,'3072','479',170750.09,171513.95,0.00,0.00,763.86,562200.96,0.00,0.00,0.00),('1','208','1038','257911',4905286,'3076','479',187050.41,188052.50,0.00,0.00,1002.09,737538.24,0.00,0.00,0.00),('1','208','1038','257911',4905287,'3077','479',134712.10,135633.88,0.00,0.00,921.78,678430.08,0.00,0.00,0.00),('1','208','1038','257911',4905288,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257912',4905289,'3072','479',171513.95,172342.92,0.00,0.00,828.97,610121.92,0.00,0.00,0.00),('1','208','1038','257912',4905290,'3076','479',188052.50,189068.42,0.00,0.00,1015.92,747717.12,0.00,0.00,0.00),('1','208','1038','257912',4905291,'3077','479',135633.88,136562.05,0.00,0.00,928.17,683133.12,0.00,0.00,0.00),('1','208','1038','257912',4905292,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257913',4905293,'3072','479',172342.92,173329.76,0.00,0.00,986.84,726314.24,0.00,0.00,0.00),('1','208','1038','257913',4905294,'3076','479',189068.42,189804.53,0.00,0.00,736.11,541776.96,0.00,0.00,0.00),('1','208','1038','257913',4905295,'3077','479',136562.05,137411.66,0.00,0.00,849.61,625312.96,0.00,0.00,0.00),('1','208','1038','257913',4905296,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257914',4905297,'3072','479',173329.76,173870.50,0.00,0.00,540.74,397984.64,0.00,0.00,0.00),('1','208','1038','257914',4905298,'3076','479',189804.53,190569.30,0.00,0.00,764.77,562870.72,0.00,0.00,0.00),('1','208','1038','257914',4905299,'3077','479',137411.66,138094.47,0.00,0.00,682.81,502548.16,0.00,0.00,0.00),('1','208','1038','257914',4905300,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257915',4905301,'3072','479',173870.50,174224.07,0.00,0.00,353.57,260227.52,0.00,0.00,0.00),('1','208','1038','257915',4905302,'3076','479',190569.30,190938.86,0.00,0.00,369.56,271996.16,0.00,0.00,0.00),('1','208','1038','257915',4905303,'3077','479',138094.47,138326.24,0.00,0.00,231.77,170582.72,0.00,0.00,0.00),('1','208','1038','257915',4905304,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257916',4905305,'3072','479',174224.07,174636.75,0.00,0.00,412.68,303732.48,0.00,0.00,0.00),('1','208','1038','257916',4905306,'3076','479',190938.86,191338.62,0.00,0.00,399.76,294223.36,0.00,0.00,0.00),('1','208','1038','257916',4905307,'3077','479',138326.24,138742.35,0.00,0.00,416.11,306256.96,0.00,0.00,0.00),('1','208','1038','257916',4905308,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257917',4905309,'3072','479',174636.75,175413.75,0.00,0.00,777.00,571872.00,0.00,0.00,0.00),('1','208','1038','257917',4905310,'3076','479',191338.62,192283.13,0.00,0.00,944.51,695159.36,0.00,0.00,0.00),('1','208','1038','257917',4905311,'3077','479',138742.35,139462.24,0.00,0.00,719.89,529839.04,0.00,0.00,0.00),('1','208','1038','257917',4905312,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257918',4905313,'3072','479',175413.75,175849.18,0.00,0.00,435.43,320476.48,0.00,0.00,0.00),('1','208','1038','257918',4905314,'3076','479',192283.13,192981.32,0.00,0.00,698.19,513867.84,0.00,0.00,0.00),('1','208','1038','257918',4905315,'3077','479',139462.24,139898.80,0.00,0.00,436.56,321308.16,0.00,0.00,0.00),('1','208','1038','257918',4905316,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257919',4905317,'3072','479',175849.18,176126.51,0.00,0.00,277.33,204114.88,0.00,0.00,0.00),('1','208','1038','257919',4905318,'3076','479',192981.32,193298.30,0.00,0.00,316.98,233297.28,0.00,0.00,0.00),('1','208','1038','257919',4905319,'3077','479',139898.80,140124.36,0.00,0.00,225.56,166012.16,0.00,0.00,0.00),('1','208','1038','257919',4905320,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257920',4905321,'3072','479',176126.51,176325.85,0.00,0.00,199.34,146714.24,0.00,0.00,0.00),('1','208','1038','257920',4905322,'3076','479',193298.30,193490.32,0.00,0.00,192.02,141326.72,0.00,0.00,0.00),('1','208','1038','257920',4905323,'3077','479',140124.36,140298.62,0.00,0.00,174.26,128255.36,0.00,0.00,0.00),('1','208','1038','257920',4905324,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257921',4905325,'3072','479',176325.85,177025.83,0.00,0.00,699.98,515185.28,0.00,0.00,0.00),('1','208','1038','257921',4905326,'3076','479',193490.32,194254.45,0.00,0.00,764.13,562399.68,0.00,0.00,0.00),('1','208','1038','257921',4905327,'3077','479',140298.62,141032.70,0.00,0.00,734.08,540282.88,0.00,0.00,0.00),('1','208','1038','257921',4905328,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257922',4905329,'3072','479',177025.83,177847.50,0.00,0.00,821.67,604014.12,0.00,0.00,0.00),('1','208','1038','257922',4905330,'3076','479',194254.45,195187.87,0.00,0.00,933.42,686997.12,0.00,0.00,0.00),('1','208','1038','257922',4905331,'3077','479',141032.70,141689.36,0.00,0.00,656.66,483301.76,0.00,0.00,0.00),('1','208','1038','257922',4905332,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257923',4905333,'3072','479',177847.50,178043.63,0.00,0.00,196.13,144351.68,0.00,0.00,0.00),('1','208','1038','257923',4905334,'3076','479',195187.87,195392.02,0.00,0.00,204.15,150254.40,0.00,0.00,0.00),('1','208','1038','257923',4905335,'3077','479',141689.36,141915.31,0.00,0.00,225.95,166299.20,0.00,0.00,0.00),('1','208','1038','257923',4905336,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257924',4905337,'3072','479',178043.63,178912.22,0.00,0.00,868.59,639282.24,0.00,0.00,0.00),('1','208','1038','257924',4905338,'3076','479',195392.02,196195.60,0.00,0.00,803.58,591434.88,0.00,0.00,0.00),('1','208','1038','257924',4905339,'3077','479',141915.31,142737.83,0.00,0.00,822.52,605374.72,0.00,0.00,0.00),('1','208','1038','257924',4905340,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257925',4905341,'3072','479',178912.22,179318.15,0.00,0.00,405.93,298764.48,0.00,0.00,0.00),('1','208','1038','257925',4905342,'3076','479',196195.60,196499.42,0.00,0.00,303.82,223611.52,0.00,0.00,0.00),('1','208','1038','257925',4905343,'3077','479',142737.83,143107.14,0.00,0.00,369.31,271812.16,0.00,0.00,0.00),('1','208','1038','257925',4905344,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257926',4905345,'3072','479',179318.15,179860.77,0.00,0.00,542.62,399368.32,0.00,0.00,0.00),('1','208','1038','257926',4905346,'3076','479',196499.42,197059.03,0.00,0.00,559.61,411872.96,0.00,0.00,0.00),('1','208','1038','257926',4905347,'3077','479',143107.14,143502.37,0.00,0.00,395.23,290889.28,0.00,0.00,0.00),('1','208','1038','257926',4905348,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257927',4905349,'3072','479',179860.77,180529.24,0.00,0.00,668.47,491993.92,0.00,0.00,0.00),('1','208','1038','257927',4905350,'3076','479',197059.03,197978.22,0.00,0.00,919.19,676523.84,0.00,0.00,0.00),('1','208','1038','257927',4905351,'3077','479',143502.37,144532.75,0.00,0.00,1030.38,758359.68,0.00,0.00,0.00),('1','208','1038','257927',4905352,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257928',4905353,'3072','479',180529.24,180997.35,0.00,0.00,468.11,344528.96,0.00,0.00,0.00),('1','208','1038','257928',4905354,'3076','479',197978.22,198469.70,0.00,0.00,491.48,361729.28,0.00,0.00,0.00),('1','208','1038','257928',4905355,'3077','479',144532.75,144990.10,0.00,0.00,457.35,336609.60,0.00,0.00,0.00),('1','208','1038','257928',4905356,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257929',4905357,'3072','479',180997.35,181269.29,0.00,0.00,271.94,200147.84,0.00,0.00,0.00),('1','208','1038','257929',4905358,'3076','479',198469.70,198778.25,0.00,0.00,308.55,227092.80,0.00,0.00,0.00),('1','208','1038','257929',4905359,'3077','479',144990.10,145307.09,0.00,0.00,316.99,233304.64,0.00,0.00,0.00),('1','208','1038','257929',4905360,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257930',4905361,'3072','479',181269.29,181786.53,0.00,0.00,517.24,380688.64,0.00,0.00,0.00),('1','208','1038','257930',4905362,'3076','479',198778.25,199395.62,0.00,0.00,617.37,454384.32,0.00,0.00,0.00),('1','208','1038','257930',4905363,'3077','479',145307.09,145885.72,0.00,0.00,578.63,425871.68,0.00,0.00,0.00),('1','208','1038','257930',4905364,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257931',4905365,'3072','479',181786.53,182940.28,0.00,0.00,1153.75,849160.00,0.00,0.00,0.00),('1','208','1038','257931',4905366,'3076','479',199395.62,200448.52,0.00,0.00,1052.90,774934.40,0.00,0.00,0.00),('1','208','1038','257931',4905367,'3077','479',145885.72,146715.70,0.00,0.00,829.98,610865.28,0.00,0.00,0.00),('1','208','1038','257931',4905368,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257932',4905369,'3072','479',182940.28,183044.49,0.00,0.00,104.21,76698.56,0.00,0.00,0.00),('1','208','1038','257932',4905370,'3076','479',200448.52,200603.31,0.00,0.00,154.79,113925.44,0.00,0.00,0.00),('1','208','1038','257932',4905371,'3077','479',146715.70,146846.83,0.00,0.00,131.13,96511.68,0.00,0.00,0.00),('1','208','1038','257932',4905372,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257933',4905373,'3072','479',183044.49,183619.42,0.00,0.00,574.93,423148.48,0.00,0.00,0.00),('1','208','1038','257933',4905374,'3076','479',200603.31,201438.18,0.00,0.00,834.87,614464.32,0.00,0.00,0.00),('1','208','1038','257933',4905375,'3077','479',146846.83,147519.68,0.00,0.00,672.85,495217.60,0.00,0.00,0.00),('1','208','1038','257933',4905376,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257934',4905377,'3072','479',183619.42,183726.38,0.00,0.00,106.96,78722.56,0.00,0.00,0.00),('1','208','1038','257934',4905378,'3076','479',201438.18,201568.88,0.00,0.00,130.70,96195.20,0.00,0.00,0.00),('1','208','1038','257934',4905379,'3077','479',147519.68,147634.86,0.00,0.00,115.18,84772.48,0.00,0.00,0.00),('1','208','1038','257934',4905380,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257935',4905381,'3072','479',183726.38,184313.24,0.00,0.00,586.86,431928.96,0.00,0.00,0.00),('1','208','1038','257935',4905382,'3076','479',201568.88,202130.54,0.00,0.00,561.66,413381.76,0.00,0.00,0.00),('1','208','1038','257935',4905383,'3077','479',147634.86,148220.44,0.00,0.00,585.58,430986.88,0.00,0.00,0.00),('1','208','1038','257935',4905384,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257936',4905385,'3072','479',184313.24,185107.48,0.00,0.00,794.24,584560.64,0.00,0.00,0.00),('1','208','1038','257936',4905386,'3076','479',202130.54,202996.74,0.00,0.00,866.20,637523.20,0.00,0.00,0.00),('1','208','1038','257936',4905387,'3077','479',148220.44,149124.35,0.00,0.00,903.91,665277.76,0.00,0.00,0.00),('1','208','1038','257936',4905388,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257937',4905389,'3072','479',185107.48,185304.49,0.00,0.00,197.01,144999.36,0.00,0.00,0.00),('1','208','1038','257937',4905390,'3076','479',202996.74,203260.89,0.00,0.00,264.15,194414.40,0.00,0.00,0.00),('1','208','1038','257937',4905391,'3077','479',149124.35,149349.55,0.00,0.00,225.20,165747.20,0.00,0.00,0.00),('1','208','1038','257937',4905392,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257938',4905393,'3072','479',185304.49,185824.76,0.00,0.00,520.27,382918.72,0.00,0.00,0.00),('1','208','1038','257938',4905394,'3076','479',203260.89,203828.10,0.00,0.00,567.21,417466.56,0.00,0.00,0.00),('1','208','1038','257938',4905395,'3077','479',149349.55,149771.22,0.00,0.00,421.67,310349.12,0.00,0.00,0.00),('1','208','1038','257938',4905396,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257939',4905397,'3072','479',185824.76,186686.79,0.00,0.00,862.03,634454.08,0.00,0.00,0.00),('1','208','1038','257939',4905398,'3076','479',203828.10,204940.36,0.00,0.00,1112.26,818623.36,0.00,0.00,0.00),('1','208','1038','257939',4905399,'3077','479',149771.22,150789.74,0.00,0.00,1018.52,749630.72,0.00,0.00,0.00),('1','208','1038','257939',4905400,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257940',4905401,'3072','479',186686.79,186871.28,0.00,0.00,184.49,135784.64,0.00,0.00,0.00),('1','208','1038','257940',4905402,'3076','479',204940.36,205177.40,0.00,0.00,237.04,174461.44,0.00,0.00,0.00),('1','208','1038','257940',4905403,'3077','479',150789.74,150999.54,0.00,0.00,209.80,154412.80,0.00,0.00,0.00),('1','208','1038','257940',4905404,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257941',4905405,'3072','479',186871.28,187362.02,0.00,0.00,490.74,361184.64,0.00,0.00,0.00),('1','208','1038','257941',4905406,'3076','479',205177.40,205778.66,0.00,0.00,601.26,442527.36,0.00,0.00,0.00),('1','208','1038','257941',4905407,'3077','479',150999.54,151648.50,0.00,0.00,648.96,477634.56,0.00,0.00,0.00),('1','208','1038','257941',4905408,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257942',4905409,'3072','479',187362.02,187885.21,0.00,0.00,523.19,385067.84,0.00,0.00,0.00),('1','208','1038','257942',4905410,'3076','479',205778.66,206592.69,0.00,0.00,814.03,599126.08,0.00,0.00,0.00),('1','208','1038','257942',4905411,'3077','479',151648.50,152487.55,0.00,0.00,839.05,617540.80,0.00,0.00,0.00),('1','208','1038','257942',4905412,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257943',4905413,'3072','479',187885.21,188420.20,0.00,0.00,534.99,393752.64,0.00,0.00,0.00),('1','208','1038','257943',4905414,'3076','479',206592.69,207063.94,0.00,0.00,471.25,346840.00,0.00,0.00,0.00),('1','208','1038','257943',4905415,'3077','479',152487.55,153018.79,0.00,0.00,531.24,390992.64,0.00,0.00,0.00),('1','208','1038','257943',4905416,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257944',4905417,'3072','479',188420.20,189780.88,0.00,0.00,1360.68,1001460.48,0.00,0.00,0.00),('1','208','1038','257944',4905418,'3076','479',207063.94,208323.95,0.00,0.00,1260.01,927367.36,0.00,0.00,0.00),('1','208','1038','257944',4905419,'3077','479',153018.79,154485.12,0.00,0.00,1466.33,1079218.88,0.00,0.00,0.00),('1','208','1038','257944',4905420,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257945',4905421,'3072','479',189780.88,190094.52,0.00,0.00,313.64,230839.04,0.00,0.00,0.00),('1','208','1038','257945',4905422,'3076','479',208323.95,208656.31,0.00,0.00,332.36,244616.96,0.00,0.00,0.00),('1','208','1038','257945',4905423,'3077','479',154485.12,154855.01,0.00,0.00,369.89,272239.04,0.00,0.00,0.00),('1','208','1038','257945',4905424,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257946',4905425,'3072','479',190094.52,190948.19,0.00,0.00,853.67,628301.12,0.00,0.00,0.00),('1','208','1038','257946',4905426,'3076','479',208656.31,209715.25,0.00,0.00,1058.94,779379.84,0.00,0.00,0.00),('1','208','1038','257946',4905427,'3077','479',154855.01,155892.95,0.00,0.00,1037.94,763923.84,0.00,0.00,0.00),('1','208','1038','257946',4905428,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257947',4905429,'3072','479',190948.19,191538.69,0.00,0.00,590.50,434608.00,0.00,0.00,0.00),('1','208','1038','257947',4905430,'3076','479',209715.25,210401.25,0.00,0.00,686.00,504896.00,0.00,0.00,0.00),('1','208','1038','257947',4905431,'3077','479',155892.95,156767.23,0.00,0.00,874.28,643470.08,0.00,0.00,0.00),('1','208','1038','257947',4905432,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257948',4905433,'3072','479',191538.69,192355.27,0.00,0.00,816.58,601002.88,0.00,0.00,0.00),('1','208','1038','257948',4905434,'3076','479',210401.25,211516.83,0.00,0.00,1115.58,821066.88,0.00,0.00,0.00),('1','208','1038','257948',4905435,'3077','479',156767.23,157699.34,0.00,0.00,932.11,686032.96,0.00,0.00,0.00),('1','208','1038','257948',4905436,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257949',4905437,'3072','479',192355.27,193104.96,0.00,0.00,749.69,551771.84,0.00,0.00,0.00),('1','208','1038','257949',4905438,'3076','479',211516.83,212295.07,0.00,0.00,778.24,572784.64,0.00,0.00,0.00),('1','208','1038','257949',4905439,'3077','479',157699.34,158468.85,0.00,0.00,769.51,566359.36,0.00,0.00,0.00),('1','208','1038','257949',4905440,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257950',4905441,'3072','479',193104.96,194255.07,0.00,0.00,1150.11,846480.96,0.00,0.00,0.00),('1','208','1038','257950',4905442,'3076','479',212295.07,213413.38,0.00,0.00,1118.31,823076.16,0.00,0.00,0.00),('1','208','1038','257950',4905443,'3077','479',158468.85,159438.70,0.00,0.00,969.85,713809.60,0.00,0.00,0.00),('1','208','1038','257950',4905444,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257951',4905445,'3072','479',194255.07,194812.75,0.00,0.00,557.68,410452.48,0.00,0.00,0.00),('1','208','1038','257951',4905446,'3076','479',213413.38,213989.57,0.00,0.00,576.19,424075.84,0.00,0.00,0.00),('1','208','1038','257951',4905447,'3077','479',159438.70,160123.29,0.00,0.00,684.59,503858.24,0.00,0.00,0.00),('1','208','1038','257951',4905448,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257952',4905449,'3072','479',194812.75,195037.76,0.00,0.00,225.01,165607.36,0.00,0.00,0.00),('1','208','1038','257952',4905450,'3076','479',213989.57,214229.67,0.00,0.00,240.10,176713.60,0.00,0.00,0.00),('1','208','1038','257952',4905451,'3077','479',160123.29,160433.00,0.00,0.00,309.71,227946.56,0.00,0.00,0.00),('1','208','1038','257952',4905452,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257953',4905453,'3072','479',195037.76,195849.79,0.00,0.00,812.03,597654.08,0.00,0.00,0.00),('1','208','1038','257953',4905454,'3076','479',214229.67,215174.39,0.00,0.00,944.72,695313.92,0.00,0.00,0.00),('1','208','1038','257953',4905455,'3077','479',160433.00,161191.68,0.00,0.00,758.68,558388.48,0.00,0.00,0.00),('1','208','1038','257953',4905456,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257954',4905457,'3072','479',195849.79,196406.49,0.00,0.00,556.70,409731.20,0.00,0.00,0.00),('1','208','1038','257954',4905458,'3076','479',215174.39,215787.15,0.00,0.00,612.76,450991.36,0.00,0.00,0.00),('1','208','1038','257954',4905459,'3077','479',161191.68,161806.54,0.00,0.00,614.86,452536.96,0.00,0.00,0.00),('1','208','1038','257954',4905460,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257955',4905461,'3072','479',196406.49,196557.82,0.00,0.00,151.33,111378.88,0.00,0.00,0.00),('1','208','1038','257955',4905462,'3076','479',215787.15,215970.87,0.00,0.00,183.72,135217.92,0.00,0.00,0.00),('1','208','1038','257955',4905463,'3077','479',161806.54,161980.57,0.00,0.00,174.03,128086.08,0.00,0.00,0.00),('1','208','1038','257955',4905464,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257956',4905465,'3072','479',196557.82,196882.07,0.00,0.00,324.25,238648.00,0.00,0.00,0.00),('1','208','1038','257956',4905466,'3076','479',215970.87,216332.73,0.00,0.00,361.86,266328.96,0.00,0.00,0.00),('1','208','1038','257956',4905467,'3077','479',161980.57,162248.93,0.00,0.00,268.36,197512.96,0.00,0.00,0.00),('1','208','1038','257956',4905468,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257957',4905469,'3072','479',196882.07,197188.84,0.00,0.00,306.77,225782.72,0.00,0.00,0.00),('1','208','1038','257957',4905470,'3076','479',216332.73,216703.88,0.00,0.00,371.15,273166.40,0.00,0.00,0.00),('1','208','1038','257957',4905471,'3077','479',162248.93,162277.66,0.00,0.00,28.73,21145.28,0.00,0.00,0.00),('1','208','1038','257957',4905472,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257958',4905473,'3072','479',197188.84,198231.71,0.00,0.00,1042.87,767552.32,0.00,0.00,0.00),('1','208','1038','257958',4905474,'3076','479',216703.88,217715.35,0.00,0.00,1011.47,744441.92,0.00,0.00,0.00),('1','208','1038','257958',4905475,'3077','479',162277.66,163118.29,0.00,0.00,840.63,618703.68,0.00,0.00,0.00),('1','208','1038','257958',4905476,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257959',4905477,'3072','479',198231.71,198459.72,0.00,0.00,228.01,167815.36,0.00,0.00,0.00),('1','208','1038','257959',4905478,'3076','479',217715.35,217988.90,0.00,0.00,273.55,201332.80,0.00,0.00,0.00),('1','208','1038','257959',4905479,'3077','479',163118.29,163378.22,0.00,0.00,259.93,191308.48,0.00,0.00,0.00),('1','208','1038','257959',4905480,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257960',4905481,'3072','479',198459.72,199009.17,0.00,0.00,549.45,404395.20,0.00,0.00,0.00),('1','208','1038','257960',4905482,'3076','479',217988.90,218871.68,0.00,0.00,882.78,649726.08,0.00,0.00,0.00),('1','208','1038','257960',4905483,'3077','479',163378.22,163839.17,0.00,0.00,460.95,339259.20,0.00,0.00,0.00),('1','208','1038','257960',4905484,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257961',4905485,'3072','479',199009.17,199736.41,0.00,0.00,727.24,535248.64,0.00,0.00,0.00),('1','208','1038','257961',4905486,'3076','479',218871.68,219715.91,0.00,0.00,844.23,621353.28,0.00,0.00,0.00),('1','208','1038','257961',4905487,'3077','479',163839.17,164238.67,0.00,0.00,399.50,294032.00,0.00,0.00,0.00),('1','208','1038','257961',4905488,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257962',4905489,'3072','479',199736.41,199970.56,0.00,0.00,234.15,172334.40,0.00,0.00,0.00),('1','208','1038','257962',4905490,'3076','479',219715.91,220096.86,0.00,0.00,380.95,280379.20,0.00,0.00,0.00),('1','208','1038','257962',4905491,'3077','479',164238.67,164555.76,0.00,0.00,317.09,233378.24,0.00,0.00,0.00),('1','208','1038','257962',4905492,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257963',4905493,'3072','479',199970.56,200402.68,0.00,0.00,432.12,318040.32,0.00,0.00,0.00),('1','208','1038','257963',4905494,'3076','479',220096.86,220469.54,0.00,0.00,372.68,274292.48,0.00,0.00,0.00),('1','208','1038','257963',4905495,'3077','479',164555.76,164887.35,0.00,0.00,331.59,244050.24,0.00,0.00,0.00),('1','208','1038','257963',4905496,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257964',4905497,'3072','479',200402.68,201085.03,0.00,0.00,682.35,502209.60,0.00,0.00,0.00),('1','208','1038','257964',4905498,'3076','479',220469.54,221617.54,0.00,0.00,1148.00,844928.00,0.00,0.00,0.00),('1','208','1038','257964',4905499,'3077','479',164887.35,165500.92,0.00,0.00,613.57,451587.52,0.00,0.00,0.00),('1','208','1038','257964',4905500,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257965',4905501,'3072','479',201085.03,201562.05,0.00,0.00,477.02,351086.72,0.00,0.00,0.00),('1','208','1038','257965',4905502,'3076','479',221617.54,222280.04,0.00,0.00,662.50,487600.00,0.00,0.00,0.00),('1','208','1038','257965',4905503,'3077','479',165500.92,165988.27,0.00,0.00,487.35,358689.60,0.00,0.00,0.00),('1','208','1038','257965',4905504,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257966',4905505,'3072','479',201562.05,202163.12,0.00,0.00,601.07,442387.52,0.00,0.00,0.00),('1','208','1038','257966',4905506,'3076','479',222280.04,222999.91,0.00,0.00,719.87,529824.32,0.00,0.00,0.00),('1','208','1038','257966',4905507,'3077','479',165988.27,166770.06,0.00,0.00,781.79,575397.44,0.00,0.00,0.00),('1','208','1038','257966',4905508,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257967',4905509,'3072','479',202163.12,202892.63,0.00,0.00,729.51,536919.36,0.00,0.00,0.00),('1','208','1038','257967',4905510,'3076','479',222999.91,223903.49,0.00,0.00,903.58,665034.88,0.00,0.00,0.00),('1','208','1038','257967',4905511,'3077','479',166770.06,167443.55,0.00,0.00,673.49,495688.64,0.00,0.00,0.00),('1','208','1038','257967',4905512,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257968',4905513,'3072','479',202892.63,203420.51,0.00,0.00,527.88,388519.68,0.00,0.00,0.00),('1','208','1038','257968',4905514,'3076','479',223903.49,224735.28,0.00,0.00,831.79,612197.44,0.00,0.00,0.00),('1','208','1038','257968',4905515,'3077','479',167443.55,168153.44,0.00,0.00,709.89,522479.04,0.00,0.00,0.00),('1','208','1038','257968',4905516,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257969',4905517,'3072','479',203420.51,203680.14,0.00,0.00,259.63,191087.68,0.00,0.00,0.00),('1','208','1038','257969',4905518,'3076','479',224735.28,225039.93,0.00,0.00,304.65,224222.40,0.00,0.00,0.00),('1','208','1038','257969',4905519,'3077','479',168153.44,168373.58,0.00,0.00,220.14,162023.04,0.00,0.00,0.00),('1','208','1038','257969',4905520,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257970',4905521,'3072','479',203680.14,204165.35,0.00,0.00,485.21,357114.56,0.00,0.00,0.00),('1','208','1038','257970',4905522,'3076','479',225039.93,225640.51,0.00,0.00,600.58,442026.88,0.00,0.00,0.00),('1','208','1038','257970',4905523,'3077','479',168373.58,168796.88,0.00,0.00,423.30,311548.80,0.00,0.00,0.00),('1','208','1038','257970',4905524,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257971',4905525,'3072','479',204165.35,204955.15,0.00,0.00,789.80,581292.80,0.00,0.00,0.00),('1','208','1038','257971',4905526,'3076','479',225640.51,226652.53,0.00,0.00,1012.02,744846.72,0.00,0.00,0.00),('1','208','1038','257971',4905527,'3077','479',168796.88,169885.19,0.00,0.00,1088.31,800996.16,0.00,0.00,0.00),('1','208','1038','257971',4905528,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257972',4905529,'3072','479',204955.15,205295.34,0.00,0.00,340.19,250379.84,0.00,0.00,0.00),('1','208','1038','257972',4905530,'3076','479',226652.53,227016.24,0.00,0.00,363.71,267690.56,0.00,0.00,0.00),('1','208','1038','257972',4905531,'3077','479',169885.19,170178.54,0.00,0.00,293.35,215905.60,0.00,0.00,0.00),('1','208','1038','257972',4905532,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257973',4905533,'3072','479',205295.34,205846.25,0.00,0.00,550.91,405469.76,0.00,0.00,0.00),('1','208','1038','257973',4905534,'3076','479',227016.24,227650.10,0.00,0.00,633.86,466520.96,0.00,0.00,0.00),('1','208','1038','257973',4905535,'3077','479',170178.54,170743.39,0.00,0.00,564.85,415729.60,0.00,0.00,0.00),('1','208','1038','257973',4905536,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257974',4905537,'3072','479',205846.25,206711.79,0.00,0.00,865.54,637037.44,0.00,0.00,0.00),('1','208','1038','257974',4905538,'3076','479',227650.10,228523.16,0.00,0.00,873.06,642572.16,0.00,0.00,0.00),('1','208','1038','257974',4905539,'3077','479',170743.39,171377.08,0.00,0.00,633.69,466395.84,0.00,0.00,0.00),('1','208','1038','257974',4905540,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257975',4905541,'3072','479',206711.79,206922.89,0.00,0.00,211.10,155369.60,0.00,0.00,0.00),('1','208','1038','257975',4905542,'3076','479',228523.16,228820.65,0.00,0.00,297.49,218952.64,0.00,0.00,0.00),('1','208','1038','257975',4905543,'3077','479',171377.08,171740.89,0.00,0.00,363.81,267764.16,0.00,0.00,0.00),('1','208','1038','257975',4905544,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257976',4905545,'3072','479',206922.89,207585.74,0.00,0.00,662.85,487857.60,0.00,0.00,0.00),('1','208','1038','257976',4905546,'3076','479',228820.65,229558.22,0.00,0.00,737.57,542851.52,0.00,0.00,0.00),('1','208','1038','257976',4905547,'3077','479',171740.89,172541.14,0.00,0.00,800.25,588984.00,0.00,0.00,0.00),('1','208','1038','257976',4905548,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257977',4905549,'3072','479',207585.74,208163.66,0.00,0.00,577.92,425349.12,0.00,0.00,0.00),('1','208','1038','257977',4905550,'3076','479',229558.22,230329.75,0.00,0.00,771.53,567846.08,0.00,0.00,0.00),('1','208','1038','257977',4905551,'3077','479',172541.14,173442.46,0.00,0.00,901.32,663371.52,0.00,0.00,0.00),('1','208','1038','257977',4905552,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257978',4905553,'3072','479',208163.66,208342.54,0.00,0.00,178.88,131655.68,0.00,0.00,0.00),('1','208','1038','257978',4905554,'3076','479',230329.75,230478.62,0.00,0.00,148.87,109568.32,0.00,0.00,0.00),('1','208','1038','257978',4905555,'3077','479',173442.46,173687.20,0.00,0.00,244.74,180128.64,0.00,0.00,0.00),('1','208','1038','257978',4905556,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257979',4905557,'3072','479',208342.54,208342.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257979',4905558,'3076','479',230478.62,230478.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257979',4905559,'3077','479',173687.20,173687.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257979',4905560,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257980',4905561,'3072','479',208342.54,208448.14,0.00,0.00,105.60,77721.60,0.00,0.00,0.00),('1','208','1038','257980',4905562,'3076','479',230478.62,230553.13,0.00,0.00,74.51,54839.36,0.00,0.00,0.00),('1','208','1038','257980',4905563,'3077','479',173687.20,173703.08,0.00,0.00,15.88,11687.68,0.00,0.00,0.00),('1','208','1038','257980',4905564,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257981',4905565,'3072','479',208448.14,209050.56,0.00,0.00,602.42,443381.12,0.00,0.00,0.00),('1','208','1038','257981',4905566,'3076','479',230553.13,231304.66,0.00,0.00,751.53,553126.08,0.00,0.00,0.00),('1','208','1038','257981',4905567,'3077','479',173703.08,174597.70,0.00,0.00,894.62,658440.32,0.00,0.00,0.00),('1','208','1038','257981',4905568,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257982',4905569,'3072','479',209050.56,209988.23,0.00,0.00,937.67,690125.12,0.00,0.00,0.00),('1','208','1038','257982',4905570,'3076','479',231304.66,232043.23,0.00,0.00,738.57,543587.52,0.00,0.00,0.00),('1','208','1038','257982',4905571,'3077','479',174597.70,175337.70,0.00,0.00,740.00,544640.00,0.00,0.00,0.00),('1','208','1038','257982',4905572,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257983',4905573,'3072','479',209988.23,210176.50,0.00,0.00,188.27,138566.72,0.00,0.00,0.00),('1','208','1038','257983',4905574,'3076','479',232043.23,232278.15,0.00,0.00,234.92,172901.12,0.00,0.00,0.00),('1','208','1038','257983',4905575,'3077','479',175337.70,175619.82,0.00,0.00,282.12,207640.32,0.00,0.00,0.00),('1','208','1038','257983',4905576,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257984',4905577,'3072','479',210176.50,210647.96,0.00,0.00,471.46,346994.56,0.00,0.00,0.00),('1','208','1038','257984',4905578,'3076','479',232278.15,232848.28,0.00,0.00,570.13,419615.68,0.00,0.00,0.00),('1','208','1038','257984',4905579,'3077','479',175619.82,176227.43,0.00,0.00,607.61,447200.96,0.00,0.00,0.00),('1','208','1038','257984',4905580,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257985',4905581,'3072','479',210647.96,211458.36,0.00,0.00,810.40,596454.40,0.00,0.00,0.00),('1','208','1038','257985',4905582,'3076','479',232848.28,233475.15,0.00,0.00,626.87,461376.32,0.00,0.00,0.00),('1','208','1038','257985',4905583,'3077','479',176227.43,176913.43,0.00,0.00,686.00,504896.00,0.00,0.00,0.00),('1','208','1038','257985',4905584,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257986',4905585,'3072','479',211458.36,211848.53,0.00,0.00,390.17,287165.12,0.00,0.00,0.00),('1','208','1038','257986',4905586,'3076','479',233475.15,233992.77,0.00,0.00,517.62,380968.32,0.00,0.00,0.00),('1','208','1038','257986',4905587,'3077','479',176913.43,177491.95,0.00,0.00,578.52,425790.72,0.00,0.00,0.00),('1','208','1038','257986',4905588,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257987',4905589,'3072','479',211848.53,212725.31,0.00,0.00,876.78,636542.28,0.00,0.00,0.00),('1','208','1038','257987',4905590,'3076','479',233992.77,234658.15,0.00,0.00,665.38,483065.88,0.00,0.00,0.00),('1','208','1038','257987',4905591,'3077','479',177491.95,178073.01,0.00,0.00,581.06,421849.56,0.00,0.00,0.00),('1','208','1038','257987',4905592,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257988',4905593,'3072','479',212725.31,213672.33,0.00,0.00,947.02,687534.52,0.00,0.00,0.00),('1','208','1038','257988',4905594,'3076','479',234658.15,235711.94,0.00,0.00,1053.79,765019.54,0.00,0.00,0.00),('1','208','1038','257988',4905595,'3077','479',178073.01,178673.64,0.00,0.00,600.63,436057.38,0.00,0.00,0.00),('1','208','1038','257988',4905596,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257989',4905597,'3072','479',213672.33,213888.16,0.00,0.00,215.83,156692.58,0.00,0.00,0.00),('1','208','1038','257989',4905598,'3076','479',235711.94,235809.63,0.00,0.00,97.69,70922.94,0.00,0.00,0.00),('1','208','1038','257989',4905599,'3077','479',178673.64,178953.64,0.00,0.00,280.00,203280.00,0.00,0.00,0.00),('1','208','1038','257989',4905600,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257990',4905601,'3072','479',213888.16,214445.18,0.00,0.00,557.02,404396.52,0.00,0.00,0.00),('1','208','1038','257990',4905602,'3076','479',235809.63,236296.33,0.00,0.00,486.70,353328.20,0.00,0.00,0.00),('1','208','1038','257990',4905603,'3077','479',178953.64,179396.28,0.00,0.00,442.64,321354.44,0.00,0.00,0.00),('1','208','1038','257990',4905604,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257991',4905605,'3072','479',214445.18,215320.92,0.00,0.00,875.74,635787.24,0.00,0.00,0.00),('1','208','1038','257991',4905606,'3076','479',236296.33,237189.37,0.00,0.00,893.04,648347.04,0.00,0.00,0.00),('1','208','1038','257991',4905607,'3077','479',179396.28,180004.63,0.00,0.00,608.35,441662.10,0.00,0.00,0.00),('1','208','1038','257991',4905608,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257992',4905609,'3072','479',215320.92,216262.04,0.00,0.00,941.12,683253.12,0.00,0.00,0.00),('1','208','1038','257992',4905610,'3076','479',237189.37,237366.34,0.00,0.00,176.97,128480.22,0.00,0.00,0.00),('1','208','1038','257992',4905611,'3077','479',180004.63,180373.22,0.00,0.00,368.59,267596.34,0.00,0.00,0.00),('1','208','1038','257992',4905612,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257993',4905613,'3072','479',216262.04,216432.09,0.00,0.00,170.05,123456.30,0.00,0.00,0.00),('1','208','1038','257993',4905614,'3076','479',237366.34,237522.65,0.00,0.00,156.31,113481.06,0.00,0.00,0.00),('1','208','1038','257993',4905615,'3077','479',180373.22,180519.83,0.00,0.00,146.61,106438.86,0.00,0.00,0.00),('1','208','1038','257993',4905616,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257994',4905617,'3072','479',216432.09,217270.42,0.00,0.00,838.33,608627.58,0.00,0.00,0.00),('1','208','1038','257994',4905618,'3076','479',237522.65,238232.95,0.00,0.00,710.30,515661.80,0.00,0.00,0.00),('1','208','1038','257994',4905619,'3077','479',180519.83,180987.88,0.00,0.00,468.05,339804.30,0.00,0.00,0.00),('1','208','1038','257994',4905620,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257995',4905621,'3072','479',217270.42,218374.71,0.00,0.00,1104.29,801714.54,0.00,0.00,0.00),('1','208','1038','257995',4905622,'3076','479',238232.95,238970.59,0.00,0.00,737.64,535526.64,0.00,0.00,0.00),('1','208','1038','257995',4905623,'3077','479',180987.88,181687.95,0.00,0.00,700.07,508192.82,0.00,0.00,0.00),('1','208','1038','257995',4905624,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257996',4905625,'3072','479',218374.71,218476.48,0.00,0.00,101.77,73885.02,0.00,0.00,0.00),('1','208','1038','257996',4905626,'3076','479',238970.59,239076.99,0.00,0.00,106.40,77246.40,0.00,0.00,0.00),('1','208','1038','257996',4905627,'3077','479',181687.95,181774.30,0.00,0.00,86.35,62690.10,0.00,0.00,0.00),('1','208','1038','257996',4905628,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257997',4905629,'3072','479',218476.48,218624.43,0.00,0.00,147.95,107411.70,0.00,0.00,0.00),('1','208','1038','257997',4905630,'3076','479',239076.99,239342.17,0.00,0.00,265.18,192520.68,0.00,0.00,0.00),('1','208','1038','257997',4905631,'3077','479',181774.30,182002.62,0.00,0.00,228.32,165760.32,0.00,0.00,0.00),('1','208','1038','257997',4905632,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257998',4905633,'3072','479',218624.43,219712.13,0.00,0.00,1087.70,789670.20,0.00,0.00,0.00),('1','208','1038','257998',4905634,'3076','479',239342.17,240140.27,0.00,0.00,798.10,579318.60,0.00,0.00,0.00),('1','208','1038','257998',4905635,'3077','479',182002.62,182571.83,0.00,0.00,569.21,413246.46,0.00,0.00,0.00),('1','208','1038','257998',4905636,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','257999',4905637,'3072','479',219712.13,220247.95,0.00,0.00,535.82,388924.59,0.00,0.00,0.00),('1','208','1038','257999',4905638,'3076','479',240140.27,241227.07,0.00,0.00,1086.80,789016.80,0.00,0.00,0.00),('1','208','1038','257999',4905639,'3077','479',182571.83,183226.56,0.00,0.00,654.73,475333.98,0.00,0.00,0.00),('1','208','1038','257999',4905640,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','208','1038','258000',4905641,'3072','479',220247.95,220787.65,0.00,0.00,539.70,391822.20,0.00,0.00,0.00),('1','208','1038','258000',4905642,'3076','479',241227.07,241913.52,0.00,0.00,686.45,498362.70,0.00,0.00,0.00),('1','208','1038','258000',4905643,'3077','479',183226.56,183994.21,0.00,0.00,767.65,557256.90,0.00,0.00,0.00),('1','208','1038','258000',4905644,'3078','479',113221.52,113221.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730153 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','208','253435','479',527.00,568.00,0.00,529.08,278825.16,300517.44,21692.28,719234),('1','208','253699','479',527.00,568.00,0.00,375.29,197777.83,213164.72,15386.89,719922),('1','208','253947','479',527.00,568.00,0.00,569.93,300353.11,323720.24,23367.13,720561),('1','208','254280','479',527.00,568.00,0.00,0.00,0.00,0.00,0.00,721408),('1','208','254283','479',527.00,568.00,0.00,438.24,230952.48,248920.32,17967.84,721415),('1','208','254446','479',527.00,568.00,0.00,630.68,332368.36,358226.24,25857.88,721856),('1','208','254759','479',527.00,568.00,0.00,776.31,409115.37,440944.08,31828.71,722615),('1','208','254990','479',527.00,568.00,0.00,725.87,382533.49,412294.16,29760.67,723211),('1','208','255195','479',527.00,568.00,0.00,666.57,351282.39,378611.76,27329.37,723762),('1','208','255487','479',527.00,568.00,0.00,882.41,465030.07,501208.88,36178.81,724470),('1','208','255729','479',527.00,568.00,0.00,865.93,456345.11,491848.24,35503.13,725082),('1','208','255987','479',527.00,568.00,0.00,838.00,441626.00,475984.00,34358.00,725734),('1','208','256238','479',527.00,568.00,0.00,711.32,374865.64,404029.76,29164.12,726342),('1','208','256546','479',527.00,568.00,0.00,635.80,335066.60,361134.40,26067.80,727148),('1','208','256737','479',527.00,568.00,0.00,1019.51,537281.77,579081.68,41799.91,727645),('1','208','257008','479',527.00,568.00,0.00,855.16,450669.32,485730.88,35061.56,728341),('1','208','257296','479',527.00,568.00,0.00,964.98,508544.46,548108.64,39564.18,729103),('1','208','257507','479',527.00,568.00,0.00,1608.00,847416.00,913344.00,65928.00,729659),('1','208','257508','479',527.00,568.00,0.00,1067.45,562546.15,606311.60,43765.45,729660),('1','208','257509','479',527.00,568.00,0.00,1722.74,907883.98,978516.32,70632.34,729661),('1','208','257510','479',527.00,568.00,0.00,1383.35,729025.45,785742.80,56717.35,729662),('1','208','257511','479',527.00,568.00,0.00,1315.57,693305.39,747243.76,53938.37,729663),('1','208','257512','479',527.00,568.00,0.00,1360.22,716835.94,772604.96,55769.02,729664),('1','208','257513','479',527.00,568.00,0.00,1450.69,764513.63,823991.92,59478.29,729665),('1','208','257514','479',527.00,568.00,0.00,1863.78,982212.06,1058627.04,76414.98,729666),('1','208','257515','479',527.00,568.00,0.00,310.01,163375.27,176085.68,12710.41,729667),('1','208','257516','479',527.00,568.00,0.00,0.00,0.00,0.00,0.00,729668),('1','208','257517','479',517.00,568.00,0.00,1641.02,848407.34,932099.36,83692.02,729669),('1','208','257518','479',517.00,568.00,0.00,1238.12,640108.04,703252.16,63144.12,729670),('1','208','257519','479',517.00,568.00,0.00,1023.35,529071.95,581262.80,52190.85,729671),('1','208','257520','479',517.00,568.00,0.00,1103.18,570344.06,626606.24,56262.18,729672),('1','208','257521','479',517.00,568.00,0.00,1097.82,567572.94,623561.76,55988.82,729673),('1','208','257522','479',517.00,568.00,0.00,1049.60,542643.20,596172.80,53529.60,729674),('1','208','257523','479',517.00,568.00,0.00,967.09,499985.53,549307.12,49321.59,729675),('1','208','257524','479',517.00,568.00,0.00,1017.85,526228.45,578138.80,51910.35,729676),('1','208','257525','479',517.00,568.00,0.00,981.78,507580.26,557651.04,50070.78,729677),('1','208','257526','479',517.00,568.00,0.00,904.50,467626.50,513756.00,46129.50,729678),('1','208','257527','479',517.00,568.00,0.00,1064.03,550103.51,604369.04,54265.53,729679),('1','208','257528','479',517.00,568.00,0.00,1197.66,619190.22,680270.88,61080.66,729680),('1','208','257529','479',517.00,568.00,0.00,1099.19,568281.23,624339.92,56058.69,729681),('1','208','257530','479',517.00,568.00,0.00,1230.29,636059.93,698804.72,62744.79,729682),('1','208','257531','479',517.00,568.00,0.00,1198.08,619407.36,680509.44,61102.08,729683),('1','208','257532','479',517.00,568.00,0.00,1293.95,668972.15,734963.60,65991.45,729684),('1','208','257533','479',517.00,568.00,0.00,1098.98,568172.66,624220.64,56047.98,729685),('1','208','257534','479',517.00,568.00,0.00,1091.53,564321.01,619989.04,55668.03,729686),('1','208','257535','479',517.00,568.00,0.00,1059.81,547921.77,601972.08,54050.31,729687),('1','208','257536','479',517.00,568.00,0.00,1649.25,852662.25,936774.00,84111.75,729688),('1','208','257537','479',517.00,568.00,0.00,1044.62,540068.54,593344.16,53275.62,729689),('1','208','257538','479',517.00,568.00,0.00,1321.86,683401.62,750816.48,67414.86,729690),('1','208','257539','479',517.00,568.00,0.00,1327.89,686519.13,754241.52,67722.39,729691),('1','208','257540','479',517.00,568.00,0.00,1342.86,694258.62,762744.48,68485.86,729692),('1','208','257541','479',517.00,568.00,0.00,1309.52,677021.84,743807.36,66785.52,729693),('1','208','257542','479',517.00,568.00,0.00,1520.15,785917.55,863445.20,77527.65,729694),('1','208','257543','479',517.00,568.00,0.00,1357.11,701625.87,770838.48,69212.61,729695),('1','208','257544','479',517.00,568.00,0.00,1510.14,780742.38,857759.52,77017.14,729696),('1','208','257545','479',517.00,568.00,0.00,1128.92,583651.64,641226.56,57574.92,729697),('1','208','257546','479',517.00,640.00,0.00,1163.23,601389.91,744467.20,143077.29,729698),('1','208','257547','479',517.00,640.00,0.00,983.41,508422.97,629382.40,120959.43,729699),('1','208','257548','479',517.00,640.00,0.00,1021.54,528136.18,653785.60,125649.42,729700),('1','208','257549','479',517.00,640.00,0.00,1085.65,561281.05,694816.00,133534.95,729701),('1','208','257550','479',517.00,640.00,0.00,1262.82,652877.94,808204.80,155326.86,729702),('1','208','257551','479',517.00,640.00,0.00,1045.30,540420.10,668992.00,128571.90,729703),('1','208','257552','479',517.00,680.00,0.00,1219.11,630279.87,828994.80,198714.93,729704),('1','208','257553','479',517.00,680.00,0.00,1705.16,881567.72,1159508.80,277941.08,729705),('1','208','257554','479',517.00,680.00,0.00,1258.01,650391.17,855446.80,205055.63,729706),('1','208','257555','479',517.00,640.00,0.00,1315.22,679968.74,841740.80,161772.06,729707),('1','208','257556','479',517.00,640.00,0.00,950.84,491584.28,608537.60,116953.32,729708),('1','208','257557','479',517.00,640.00,0.00,116.81,71487.72,74758.40,3270.68,729709),('1','208','257558','479',612.00,640.00,0.00,1222.53,748188.36,782419.20,34230.84,729710),('1','208','257559','479',612.00,640.00,0.00,1305.58,799014.96,835571.20,36556.24,729711),('1','208','257560','479',612.00,640.00,0.00,1257.66,769687.92,804902.40,35214.48,729712),('1','208','257561','479',612.00,640.00,0.00,1418.47,868103.64,907820.80,39717.16,729713),('1','208','257562','479',612.00,640.00,0.00,1289.80,789357.60,825472.00,36114.40,729714),('1','208','257563','479',612.00,640.00,0.00,1268.05,776046.60,811552.00,35505.40,729715),('1','208','257564','479',612.00,640.00,0.00,1304.42,798305.04,834828.80,36523.76,729716),('1','208','257565','479',612.00,680.00,0.00,1636.60,1001599.20,1112888.00,111288.80,729717),('1','208','257566','479',612.00,680.00,0.00,1152.30,705207.60,783564.00,78356.40,729718),('1','208','257567','479',612.00,680.00,0.00,1390.59,851041.08,945601.20,94560.12,729719),('1','208','257568','479',612.00,680.00,0.00,1627.44,995993.28,1106659.20,110665.92,729720),('1','208','257569','479',612.00,640.00,0.00,1825.06,1116936.72,1168038.40,51101.68,729721),('1','208','257570','479',612.00,640.00,0.00,2558.32,1565691.84,1637324.80,71632.96,729722),('1','208','257571','479',612.00,640.00,0.00,3909.72,2392748.64,2502220.80,109472.16,729723),('1','208','257572','479',612.00,640.00,0.00,1381.75,845631.00,884320.00,38689.00,729724),('1','208','257573','479',612.00,640.00,0.00,1646.29,1007529.48,1053625.60,46096.12,729725),('1','208','257574','479',612.00,640.00,0.00,1823.58,1116030.96,1167091.20,51060.24,729726),('1','208','257575','479',612.00,640.00,0.00,1628.31,996525.72,1042118.40,45592.68,729727),('1','208','257576','479',612.00,640.00,0.00,1625.11,994567.32,1040070.40,45503.08,729728),('1','208','257577','479',612.00,640.00,0.00,1798.39,1100614.68,1150969.60,50354.92,729729),('1','208','257578','479',612.00,640.00,0.00,1593.30,975099.60,1019712.00,44612.40,729730),('1','208','257579','479',612.00,640.00,0.00,1784.89,1092352.68,1142329.60,49976.92,729731),('1','208','257580','479',612.00,640.00,0.00,1952.07,1194666.84,1249324.80,54657.96,729732),('1','208','257581','479',612.00,640.00,0.00,1348.02,824988.24,862732.80,37744.56,729733),('1','208','257582','479',612.00,640.00,0.00,940.18,575390.16,601715.20,26325.04,729734),('1','208','257583','479',612.00,640.00,0.00,334.30,204591.60,213952.00,9360.40,729735),('1','208','257584','479',612.00,640.00,0.00,1439.10,880729.20,921024.00,40294.80,729736),('1','208','257585','479',612.00,640.00,0.00,1565.46,958061.52,1001894.40,43832.88,729737),('1','208','257586','479',612.00,640.00,0.00,1783.45,1091471.40,1141408.00,49936.60,729738),('1','208','257587','479',612.00,640.00,0.00,1663.40,1018000.80,1064576.00,46575.20,729739),('1','208','257588','479',612.00,640.00,0.00,1351.03,826289.66,864659.20,38369.54,729740),('1','208','257589','479',602.00,640.00,0.00,163.92,98679.84,104908.80,6228.96,729741),('1','208','257590','479',602.00,640.00,0.00,1767.08,1063782.16,1124245.56,60463.40,729742),('1','208','257591','479',602.00,636.00,0.00,1305.84,786115.68,830514.24,44398.56,729743),('1','208','257592','479',602.00,636.00,0.00,1637.62,985847.24,1041526.32,55679.08,729744),('1','208','257593','479',602.00,636.00,0.00,1284.36,773184.72,816852.96,43668.24,729745),('1','208','257594','479',602.00,636.00,0.00,1311.47,789504.94,834094.92,44589.98,729746),('1','208','257595','479',602.00,636.00,0.00,1624.05,977678.10,1032895.80,55217.70,729747),('1','208','257596','479',602.00,636.00,0.00,781.51,470469.02,497040.36,26571.34,729748),('1','208','257597','479',602.00,636.00,0.00,798.27,480558.54,507699.72,27141.18,729749),('1','208','257598','479',602.00,636.00,0.00,1200.48,722688.96,763505.28,40816.32,729750),('1','208','257599','479',602.00,636.00,0.00,836.43,503530.86,531969.48,28438.62,729751),('1','208','257600','479',602.00,636.00,0.00,584.52,351881.04,371754.72,19873.68,729752),('1','208','257601','479',602.00,636.00,0.00,1556.73,937151.46,990080.28,52928.82,729753),('1','208','257602','479',602.00,636.00,0.00,1659.50,999019.00,1055442.00,56423.00,729754),('1','208','257603','479',602.00,636.00,0.00,1113.17,670128.34,707976.12,37847.78,729755),('1','208','257604','479',602.00,636.00,0.00,483.77,291229.54,307677.72,16448.18,729756),('1','208','257605','479',602.00,636.00,0.00,2344.35,1411298.70,1491006.60,79707.90,729757),('1','208','257606','479',602.00,636.00,0.00,2241.45,1349352.90,1425562.20,76209.30,729758),('1','208','257607','479',602.00,636.00,0.00,938.78,565145.56,597064.08,31918.52,729759),('1','208','257608','479',602.00,636.00,0.00,1237.87,745197.74,787285.32,42087.58,729760),('1','208','257609','479',602.00,636.00,0.00,1147.28,690662.56,729670.08,39007.52,729761),('1','208','257610','479',602.00,636.00,0.00,1493.44,899050.88,949827.84,50776.96,729762),('1','208','257611','479',602.00,636.00,0.00,1576.83,949251.66,1002863.88,53612.22,729763),('1','208','257612','479',602.00,636.00,0.00,777.67,468157.34,494598.12,26440.78,729764),('1','208','257613','479',602.00,636.00,0.00,959.69,577733.38,610362.84,32629.46,729765),('1','208','257614','479',602.00,636.00,0.00,2236.04,1346096.08,1422121.44,76025.36,729766),('1','208','257615','479',602.00,636.00,0.00,1784.21,1074094.42,1134757.56,60663.14,729767),('1','208','257616','479',602.00,636.00,0.00,1703.88,1025735.76,1083667.68,57931.92,729768),('1','208','257617','479',602.00,636.00,0.00,1593.25,959136.50,1013307.00,54170.50,729769),('1','208','257618','479',602.00,636.00,0.00,1719.94,1035403.88,1093881.84,58477.96,729770),('1','208','257619','479',602.00,636.00,0.00,1482.23,892302.46,942698.28,50395.82,729771),('1','208','257620','479',602.00,636.00,0.00,1600.08,963248.16,1017650.88,54402.72,729772),('1','208','257621','479',602.00,696.00,0.00,1646.26,991048.52,1145796.96,154748.44,729773),('1','208','257622','479',602.00,696.00,0.00,1444.29,869462.58,1005225.84,135763.26,729774),('1','208','257623','479',602.00,696.00,0.00,1006.03,605630.06,700196.88,94566.82,729775),('1','208','257624','479',602.00,696.00,0.00,265.56,159867.12,184829.76,24962.64,729776),('1','208','257625','479',602.00,696.00,0.00,1305.67,786013.34,908746.32,122732.98,729777),('1','208','257626','479',602.00,696.00,0.00,80.84,48665.68,56264.64,7598.96,729778),('1','208','257627','479',602.00,696.00,0.00,1197.17,732668.04,833230.32,100562.28,729779),('1','208','257628','479',612.00,696.00,0.00,1459.59,893269.08,1015874.64,122605.56,729780),('1','208','257629','479',612.00,696.00,0.00,312.25,191097.00,217326.00,26229.00,729781),('1','208','257630','479',612.00,680.00,0.00,1388.75,849915.00,944350.00,94435.00,729782),('1','208','257631','479',612.00,680.00,0.00,630.64,391194.43,428835.20,37640.77,729783),('1','208','257632','479',637.00,680.00,0.00,1082.10,689297.70,735828.00,46530.30,729784),('1','208','257633','479',637.00,680.00,0.00,1642.71,1046406.27,1117042.80,70636.53,729785),('1','208','257634','479',637.00,680.00,0.00,1716.02,1093104.74,1166893.60,73788.86,729786),('1','208','257635','479',637.00,740.00,0.00,441.58,281286.46,326769.20,45482.74,729787),('1','208','257636','479',637.00,740.00,0.00,901.60,574319.20,667184.00,92864.80,729788),('1','208','257637','479',637.00,740.00,0.00,1561.60,994739.20,1155584.00,160844.80,729789),('1','208','257638','479',637.00,740.00,0.00,697.70,444434.90,516298.00,71863.10,729790),('1','208','257639','479',637.00,740.00,0.00,1801.12,1147313.44,1332828.80,185515.36,729791),('1','208','257640','479',637.00,740.00,0.00,415.74,264826.38,307647.60,42821.22,729792),('1','208','257641','479',637.00,700.00,0.00,1441.90,918490.30,1009330.00,90839.70,729793),('1','208','257642','479',637.00,700.00,0.00,447.28,284917.36,313096.00,28178.64,729794),('1','208','257643','479',637.00,700.00,0.00,1009.42,668236.04,706594.00,38357.96,729795),('1','208','257644','479',662.00,680.00,0.00,1832.80,1213313.60,1246304.00,32990.40,729796),('1','208','257645','479',662.00,680.00,0.00,1617.86,1071023.32,1100144.80,29121.48,729797),('1','208','257646','479',662.00,680.00,0.00,497.94,329636.28,338599.20,8962.92,729798),('1','208','257647','479',662.00,680.00,0.00,1274.45,843685.90,866626.00,22940.10,729799),('1','208','257648','479',662.00,680.00,0.00,1759.40,1164722.80,1196392.00,31669.20,729800),('1','208','257649','479',662.00,680.00,0.00,1584.47,1048919.14,1077439.60,28520.46,729801),('1','208','257650','479',662.00,680.00,0.00,2274.39,1505646.18,1546585.20,40939.02,729802),('1','208','257651','479',662.00,680.00,0.00,1482.22,1025696.24,1007909.60,-17786.64,729803),('1','208','257652','479',692.00,680.00,0.00,2277.39,1575953.88,1548625.20,-27328.68,729804),('1','208','257653','479',692.00,680.00,0.00,1232.70,853028.40,838236.00,-14792.40,729805),('1','208','257654','479',692.00,680.00,0.00,780.84,540341.28,530971.20,-9370.08,729806),('1','208','257655','479',692.00,680.00,0.00,1906.87,1319554.04,1296671.60,-22882.44,729807),('1','208','257656','479',692.00,750.00,0.00,1681.31,1163466.52,1260982.50,97515.98,729808),('1','208','257657','479',692.00,750.00,0.00,698.58,483417.36,523935.00,40517.64,729809),('1','208','257658','479',692.00,750.00,0.00,1561.44,1080516.48,1171080.00,90563.52,729810),('1','208','257659','479',692.00,750.00,0.00,2215.93,1511264.26,1661947.50,150683.24,729811),('1','208','257660','479',682.00,750.00,0.00,2783.28,1898196.96,2087460.00,189263.04,729812),('1','208','257661','479',682.00,750.00,0.00,1700.59,1159802.38,1275442.50,115640.12,729813),('1','208','257662','479',682.00,750.00,0.00,1405.68,958673.76,1054260.00,95586.24,729814),('1','208','257663','479',682.00,750.00,0.00,1805.96,1231664.72,1354470.00,122805.28,729815),('1','208','257664','479',682.00,750.00,0.00,1672.03,1140324.46,1254022.50,113698.04,729816),('1','208','257665','479',682.00,750.00,0.00,1599.13,1090606.66,1199347.50,108740.84,729817),('1','208','257666','479',682.00,750.00,0.00,1772.43,1208797.26,1329322.50,120525.24,729818),('1','208','257667','479',682.00,750.00,0.00,1579.93,1077512.26,1184947.50,107435.24,729819),('1','208','257668','479',682.00,750.00,0.00,1543.48,1052653.36,1157610.00,104956.64,729820),('1','208','257669','479',682.00,750.00,0.00,448.84,307578.18,336630.00,29051.82,729821),('1','208','257670','479',692.00,750.00,0.00,1225.12,847783.04,918840.00,71056.96,729822),('1','208','257671','479',692.00,750.00,0.00,1288.86,891891.12,966645.00,74753.88,729823),('1','208','257672','479',692.00,750.00,0.00,1545.85,1069728.20,1159387.50,89659.30,729824),('1','208','257673','479',692.00,750.00,0.00,983.14,680332.88,737355.00,57022.12,729825),('1','208','257674','479',692.00,750.00,0.00,380.46,263278.32,285345.00,22066.68,729826),('1','208','257675','479',692.00,750.00,0.00,2102.52,1454943.84,1576890.00,121946.16,729827),('1','208','257676','479',692.00,750.00,0.00,1832.71,1268235.32,1374532.50,106297.18,729828),('1','208','257677','479',692.00,750.00,0.00,722.95,500281.40,542212.50,41931.10,729829),('1','208','257678','479',692.00,750.00,0.00,1154.71,799059.32,866032.50,66973.18,729830),('1','208','257679','479',692.00,750.00,0.00,1081.29,748252.68,810967.50,62714.82,729831),('1','208','257680','479',692.00,750.00,0.00,1741.51,1205124.92,1306132.50,101007.58,729832),('1','208','257681','479',692.00,750.00,0.00,2122.24,1468590.08,1591680.00,123089.92,729833),('1','208','257682','479',692.00,750.00,0.00,1050.71,727091.32,788032.50,60941.18,729834),('1','208','257683','479',692.00,750.00,0.00,1033.22,714988.24,774915.00,59926.76,729835),('1','208','257684','479',692.00,750.00,0.00,2314.29,1601488.68,1735717.50,134228.82,729836),('1','208','257685','479',692.00,750.00,0.00,1728.72,1196274.24,1296540.00,100265.76,729837),('1','208','257686','479',692.00,750.00,0.00,2364.32,1636109.44,1773240.00,137130.56,729838),('1','208','257687','479',692.00,750.00,0.00,191.38,132434.96,143535.00,11100.04,729839),('1','208','257688','479',692.00,750.00,0.00,1674.28,1158601.76,1255710.00,97108.24,729840),('1','208','257689','479',692.00,750.00,0.00,2708.41,1874219.72,2031307.50,157087.78,729841),('1','208','257690','479',692.00,750.00,0.00,741.75,513291.00,556312.50,43021.50,729842),('1','208','257691','479',692.00,750.00,0.00,3096.47,2142757.24,2322352.50,179595.26,729843),('1','208','257692','479',692.00,750.00,0.00,1970.33,1363468.36,1477747.50,114279.14,729844),('1','208','257693','479',692.00,750.00,0.00,1646.33,1139260.36,1234747.50,95487.14,729845),('1','208','257694','479',692.00,750.00,0.00,247.13,171013.96,185347.50,14333.54,729846),('1','208','257695','479',692.00,750.00,0.00,1199.40,829984.80,899550.00,69565.20,729847),('1','208','257696','479',692.00,750.00,0.00,1262.95,873961.40,947212.50,73251.10,729848),('1','208','257697','479',692.00,750.00,0.00,1689.84,1169369.28,1267380.00,98010.72,729849),('1','208','257698','479',692.00,750.00,0.00,994.12,687931.04,745590.00,57658.96,729850),('1','208','257699','479',692.00,750.00,0.00,674.48,466740.16,505860.00,39119.84,729851),('1','208','257700','479',692.00,750.00,0.00,1481.62,1025281.04,1111215.00,85933.96,729852),('1','208','257701','479',692.00,750.00,0.00,1903.82,1317443.44,1427865.00,110421.56,729853),('1','208','257702','479',692.00,750.00,0.00,1050.84,727181.28,788130.00,60948.72,729854),('1','208','257703','479',692.00,750.00,0.00,307.22,212596.24,230415.00,17818.76,729855),('1','208','257704','479',692.00,750.00,0.00,2591.80,1793525.60,1943850.00,150324.40,729856),('1','208','257705','479',692.00,750.00,0.00,1534.19,1061659.48,1150642.50,88983.02,729857),('1','208','257706','479',692.00,750.00,0.00,432.53,299310.76,324397.50,25086.74,729858),('1','208','257707','479',692.00,750.00,0.00,232.36,160793.12,174270.00,13476.88,729859),('1','208','257708','479',692.00,750.00,0.00,672.23,465183.16,504172.50,38989.34,729860),('1','208','257709','479',692.00,750.00,0.00,1749.40,1210584.80,1312050.00,101465.20,729861),('1','208','257710','479',692.00,750.00,0.00,1663.42,1151086.64,1247565.00,96478.36,729862),('1','208','257711','479',692.00,750.00,0.00,1001.22,692844.24,750915.00,58070.76,729863),('1','208','257712','479',692.00,750.00,0.00,868.90,601278.80,651675.00,50396.20,729864),('1','208','257713','479',692.00,750.00,0.00,1810.24,1252686.08,1357680.00,104993.92,729865),('1','208','257714','479',692.00,750.00,0.00,1448.61,1002438.12,1086457.50,84019.38,729866),('1','208','257715','479',692.00,750.00,0.00,965.77,668312.84,724327.50,56014.66,729867),('1','208','257716','479',692.00,750.00,0.00,513.68,355466.56,385260.00,29793.44,729868),('1','208','257717','479',692.00,750.00,0.00,1023.49,706024.20,767617.50,61593.30,729869),('1','208','257718','479',684.00,750.00,0.00,458.70,313750.80,344025.00,30274.20,729870),('1','208','257719','479',684.00,750.00,0.00,1841.14,1259339.76,1380855.00,121515.24,729871),('1','208','257720','479',684.00,750.00,0.00,1863.71,1274777.64,1397782.50,123004.86,729872),('1','208','257721','479',684.00,750.00,0.00,935.85,640121.40,701887.50,61766.10,729873),('1','208','257722','479',684.00,750.00,0.00,822.43,562542.12,616822.50,54280.38,729874),('1','208','257723','479',684.00,750.00,0.00,2383.93,1630608.12,1787947.50,157339.38,729875),('1','208','257724','479',684.00,750.00,0.00,1931.46,1321118.64,1448595.00,127476.36,729876),('1','208','257725','479',684.00,750.00,0.00,127.88,87469.92,95910.00,8440.08,729877),('1','208','257726','479',684.00,750.00,0.00,1733.88,1186054.92,1300410.00,114355.08,729878),('1','208','257727','479',685.00,750.00,0.00,1854.51,1270339.35,1390882.50,120543.15,729879),('1','208','257728','479',685.00,750.00,0.00,2546.82,1744571.70,1910115.00,165543.30,729880),('1','208','257729','479',685.00,750.00,0.00,839.69,575187.65,629767.50,54579.85,729881),('1','208','257730','479',685.00,750.00,0.00,877.96,601402.60,658470.00,57067.40,729882),('1','208','257731','479',685.00,750.00,0.00,2676.72,1833553.20,2007540.00,173986.80,729883),('1','208','257732','479',685.00,750.00,0.00,1548.26,1060558.10,1161195.00,100636.90,729884),('1','208','257733','479',685.00,750.00,0.00,823.07,563802.95,617302.50,53499.55,729885),('1','208','257734','479',685.00,750.00,0.00,1539.34,1054447.90,1154505.00,100057.10,729886),('1','208','257735','479',685.00,750.00,0.00,559.05,382949.25,419287.50,36338.25,729887),('1','208','257736','479',685.00,750.00,0.00,1596.09,1093321.65,1197067.50,103745.85,729888),('1','208','257737','479',685.00,750.00,0.00,1914.68,1311555.80,1436010.00,124454.20,729889),('1','208','257738','479',685.00,750.00,0.00,1095.71,750561.35,821782.50,71221.15,729890),('1','208','257739','479',685.00,750.00,0.00,694.47,475711.95,520852.50,45140.55,729891),('1','208','257740','479',685.00,750.00,0.00,2015.33,1380501.05,1511497.50,130996.45,729892),('1','208','257741','479',685.00,750.00,0.00,1935.66,1325927.10,1451745.00,125817.90,729893),('1','208','257742','479',685.00,750.00,0.00,611.74,423722.86,458805.00,35082.14,729894),('1','208','257743','479',697.00,750.00,0.00,1343.14,936168.58,1007355.00,71186.42,729895),('1','208','257744','479',697.00,750.00,0.00,1666.29,1161404.13,1249717.50,88313.37,729896),('1','208','257745','479',697.00,750.00,0.00,1939.14,1351580.58,1454355.00,102774.42,729897),('1','208','257746','479',697.00,750.00,0.00,201.17,140215.49,150877.50,10662.01,729898),('1','208','257747','479',697.00,750.00,0.00,1950.31,1359366.07,1462732.50,103366.43,729899),('1','208','257748','479',697.00,750.00,0.00,1835.45,1279308.65,1376587.50,97278.85,729900),('1','208','257749','479',697.00,750.00,0.00,1356.40,945410.80,1017300.00,71889.20,729901),('1','208','257750','479',697.00,750.00,0.00,347.46,242179.62,260595.00,18415.38,729902),('1','208','257751','479',697.00,750.00,0.00,1938.28,1350981.16,1453710.00,102728.84,729903),('1','208','257752','479',697.00,750.00,0.00,2330.62,1624442.14,1747965.00,123522.86,729904),('1','208','257753','479',697.00,750.00,0.00,546.12,380645.64,409590.00,28944.36,729905),('1','208','257754','479',685.00,750.00,0.00,1096.18,750883.30,822135.00,71251.70,729906),('1','208','257755','479',685.00,750.00,0.00,1813.63,1242336.55,1360222.50,117885.95,729907),('1','208','257756','479',685.00,750.00,0.00,2175.23,1490032.55,1631422.50,141389.95,729908),('1','208','257757','479',685.00,750.00,0.00,69.08,47319.80,51810.00,4490.20,729909),('1','208','257758','479',685.00,750.00,0.00,926.88,634912.80,695160.00,60247.20,729910),('1','208','257759','479',685.00,750.00,0.00,1756.20,1202997.00,1317150.00,114153.00,729911),('1','208','257760','479',685.00,750.00,0.00,1936.46,1326475.10,1452345.00,125869.90,729912),('1','208','257761','479',685.00,750.00,0.00,551.13,377524.05,413347.50,35823.45,729913),('1','208','257762','479',685.00,750.00,0.00,1896.86,1299349.10,1422645.00,123295.90,729914),('1','208','257763','479',685.00,750.00,0.00,2164.81,1482894.85,1623607.50,140712.65,729915),('1','208','257764','479',685.00,750.00,0.00,731.77,501262.45,548827.50,47565.05,729916),('1','208','257765','479',685.00,750.00,0.00,2450.51,1678599.35,1837882.50,159283.15,729917),('1','208','257766','479',685.00,750.00,0.00,1907.01,1306301.85,1430257.50,123955.65,729918),('1','208','257767','479',685.00,750.00,0.00,337.22,230995.70,252915.00,21919.30,729919),('1','208','257768','479',685.00,750.00,0.00,2461.30,1685990.50,1845975.00,159984.50,729920),('1','208','257769','479',685.00,750.00,0.00,2150.81,1473304.85,1613107.50,139802.65,729921),('1','208','257770','479',685.00,750.00,0.00,2348.56,1608763.60,1761420.00,152656.40,729922),('1','208','257771','479',685.00,750.00,0.00,2773.55,1899881.75,2080162.50,180280.75,729923),('1','208','257772','479',685.00,750.00,0.00,2184.32,1496259.20,1638240.00,141980.80,729924),('1','208','257773','479',685.00,750.00,0.00,2545.76,1743845.60,1909320.00,165474.40,729925),('1','208','257774','479',685.00,750.00,0.00,505.79,346466.15,379342.50,32876.35,729926),('1','208','257775','479',685.00,750.00,0.00,1913.74,1310911.90,1435305.00,124393.10,729927),('1','208','257776','479',685.00,750.00,0.00,2334.23,1598947.55,1750672.50,151724.95,729928),('1','208','257777','479',685.00,750.00,0.00,915.38,627035.30,686535.00,59499.70,729929),('1','208','257778','479',685.00,750.00,0.00,1823.36,1249001.60,1367520.00,118518.40,729930),('1','208','257779','479',685.00,750.00,0.00,2863.06,1961196.10,2147295.00,186098.90,729931),('1','208','257780','479',685.00,750.00,0.00,447.20,306332.00,335400.00,29068.00,729932),('1','208','257781','479',685.00,750.00,0.00,1082.67,741628.95,812002.50,70373.55,729933),('1','208','257782','479',685.00,750.00,0.00,2359.99,1616593.15,1769992.50,153399.35,729934),('1','208','257783','479',685.00,750.00,0.00,1681.05,1151519.25,1260787.50,109268.25,729935),('1','208','257784','479',685.00,750.00,0.00,2190.34,1500382.90,1642755.00,142372.10,729936),('1','208','257785','479',685.00,750.00,0.00,2331.45,1597043.25,1748587.50,151544.25,729937),('1','208','257786','479',685.00,750.00,0.00,725.70,497104.50,544275.00,47170.50,729938),('1','208','257787','479',685.00,750.00,0.00,1191.91,816458.35,893932.50,77474.15,729939),('1','208','257788','479',685.00,750.00,0.00,1515.50,1038117.50,1136625.00,98507.50,729940),('1','208','257789','479',685.00,750.00,0.00,2232.54,1529289.90,1674405.00,145115.10,729941),('1','208','257790','479',685.00,750.00,0.00,1366.03,935730.55,1024522.50,88791.95,729942),('1','208','257791','479',685.00,750.00,0.00,703.33,476154.41,527497.50,51343.09,729943),('1','208','257792','479',677.00,750.00,0.00,2008.57,1359801.89,1506427.50,146625.61,729944),('1','208','257793','479',677.00,750.00,0.00,2011.15,1361548.55,1508362.50,146813.95,729945),('1','208','257794','479',677.00,750.00,0.00,298.61,202158.97,223957.50,21798.53,729946),('1','208','257795','479',677.00,750.00,0.00,982.43,665105.11,736822.50,71717.39,729947),('1','208','257796','479',677.00,750.00,0.00,2055.57,1391620.89,1541677.50,150056.61,729948),('1','208','257797','479',677.00,750.00,0.00,2043.46,1383422.42,1532595.00,149172.58,729949),('1','208','257798','479',677.00,750.00,0.00,2495.80,1689656.60,1871850.00,182193.40,729950),('1','208','257799','479',677.00,750.00,0.00,2231.01,1510393.77,1673257.50,162863.73,729951),('1','208','257800','479',677.00,750.00,0.00,434.81,294366.37,326107.50,31741.13,729952),('1','208','257801','479',677.00,750.00,0.00,2351.90,1592236.30,1763925.00,171688.70,729953),('1','208','257802','479',677.00,750.00,0.00,2768.49,1874267.73,2076367.50,202099.77,729954),('1','208','257803','479',677.00,750.00,0.00,1871.62,1267086.74,1403715.00,136628.26,729955),('1','208','257804','479',677.00,750.00,0.00,2083.51,1410536.27,1562632.50,152096.23,729956),('1','208','257805','479',677.00,750.00,0.00,1177.93,797458.61,883447.50,85988.89,729957),('1','208','257806','479',677.00,750.00,0.00,624.00,422448.00,468000.00,45552.00,729958),('1','208','257807','479',677.00,750.00,0.00,2682.12,1815795.24,2011590.00,195794.76,729959),('1','208','257808','479',677.00,750.00,0.00,1855.58,1256227.66,1391685.00,135457.34,729960),('1','208','257809','479',677.00,750.00,0.00,2741.08,1855711.16,2055810.00,200098.84,729961),('1','208','257810','479',677.00,750.00,0.00,2377.84,1609797.68,1783380.00,173582.32,729962),('1','208','257811','479',677.00,750.00,0.00,3022.91,2046510.07,2267182.50,220672.43,729963),('1','208','257812','479',677.00,750.00,0.00,1924.10,1302615.70,1443075.00,140459.30,729964),('1','208','257813','479',677.00,750.00,0.00,2164.63,1465454.51,1623472.50,158017.99,729965),('1','208','257814','479',677.00,750.00,0.00,2063.67,1397104.59,1547752.50,150647.91,729966),('1','208','257815','479',677.00,750.00,0.00,930.76,630124.52,698070.00,67945.48,729967),('1','208','257816','479',677.00,750.00,0.00,2052.04,1389231.08,1539030.00,149798.92,729968),('1','208','257817','479',677.00,750.00,0.00,1833.07,1240988.39,1374802.50,133814.11,729969),('1','208','257818','479',677.00,750.00,0.00,1206.10,816529.70,904575.00,88045.30,729970),('1','208','257819','479',677.00,750.00,0.00,769.42,520897.34,577065.00,56167.66,729971),('1','208','257820','479',677.00,750.00,0.00,1952.49,1321835.73,1464367.50,142531.77,729972),('1','208','257821','479',677.00,750.00,0.00,2283.09,1545651.93,1712317.50,166665.57,729973),('1','208','257822','479',677.00,750.00,0.00,468.81,317384.37,351607.50,34223.13,729974),('1','208','257823','479',677.00,750.00,0.00,2194.65,1485778.05,1645987.50,160209.45,729975),('1','208','257824','479',677.00,750.00,0.00,1859.76,1259057.52,1394820.00,135762.48,729976),('1','208','257825','479',677.00,750.00,0.00,1062.02,718987.54,796515.00,77527.46,729977),('1','208','257826','479',677.00,750.00,0.00,490.99,332400.23,368242.50,35842.27,729978),('1','208','257827','479',677.00,750.00,0.00,2313.74,1566401.98,1735305.00,168903.02,729979),('1','208','257828','479',780.00,780.00,0.00,2631.09,2012922.74,2052250.20,39327.46,729980),('1','208','257829','479',677.00,780.00,0.00,1296.70,877865.90,1011426.00,133560.10,729981),('1','208','257830','479',677.00,780.00,0.00,1512.10,1035788.50,1179438.00,143649.50,729982),('1','208','257831','479',685.00,780.00,0.00,3276.32,2244279.20,2555529.60,311250.40,729983),('1','208','257832','479',685.00,780.00,0.00,608.92,417110.20,474957.60,57847.40,729984),('1','208','257833','479',685.00,780.00,0.00,1593.19,1091335.15,1242688.20,151353.05,729985),('1','208','257834','479',685.00,780.00,0.00,3126.27,2141494.95,2438490.60,296995.65,729986),('1','208','257835','479',685.00,780.00,0.00,443.78,303989.30,346148.40,42159.10,729987),('1','208','257836','479',685.00,780.00,0.00,1854.17,1270106.45,1446252.60,176146.15,729988),('1','208','257837','479',685.00,780.00,0.00,2717.28,1861336.80,2119478.40,258141.60,729989),('1','208','257838','479',685.00,780.00,0.00,853.12,584387.20,665433.60,81046.40,729990),('1','208','257839','479',685.00,780.00,0.00,673.87,461600.95,525618.60,64017.65,729991),('1','208','257840','479',685.00,780.00,0.00,2488.46,1704595.10,1940998.80,236403.70,729992),('1','208','257841','479',685.00,780.00,0.00,1956.00,1339860.00,1525680.00,185820.00,729993),('1','208','257842','479',685.00,780.00,0.00,298.68,204595.80,232970.40,28374.60,729994),('1','208','257843','479',685.00,780.00,0.00,1380.10,945368.50,1076478.00,131109.50,729995),('1','208','257844','479',685.00,780.00,0.00,2144.04,1468667.40,1672351.20,203683.80,729996),('1','208','257845','479',685.00,780.00,0.00,1700.00,1164500.00,1326000.00,161500.00,729997),('1','208','257846','479',685.00,780.00,0.00,86.67,59368.95,67602.60,8233.65,729998),('1','208','257847','479',685.00,780.00,0.00,1498.47,1026451.95,1168806.60,142354.65,729999),('1','208','257848','479',685.00,780.00,0.00,1769.29,1211963.65,1380046.20,168082.55,730000),('1','208','257849','479',685.00,780.00,0.00,2117.36,1450391.60,1651540.80,201149.20,730001),('1','208','257850','479',685.00,780.00,0.00,1868.86,1280169.10,1457710.80,177541.70,730002),('1','208','257851','479',685.00,780.00,0.00,1327.86,909584.10,1035730.80,126146.70,730003),('1','208','257852','479',685.00,780.00,0.00,435.27,298159.95,339510.60,41350.65,730004),('1','208','257853','479',685.00,780.00,0.00,2551.53,1747798.05,1990193.40,242395.35,730005),('1','208','257854','479',685.00,780.00,0.00,1934.37,1325043.45,1508808.60,183765.15,730006),('1','208','257855','479',685.00,780.00,0.00,2036.62,1395084.70,1588563.60,193478.90,730007),('1','208','257856','479',685.00,780.00,0.00,1840.76,1260920.60,1435792.80,174872.20,730008),('1','208','257857','479',685.00,780.00,0.00,1281.61,877902.85,999655.80,121752.95,730009),('1','208','257858','479',685.00,780.00,0.00,606.19,415240.15,472828.20,57588.05,730010),('1','208','257859','479',685.00,780.00,0.00,2219.38,1520275.30,1731116.40,210841.10,730011),('1','208','257860','479',685.00,780.00,0.00,2302.13,1576959.05,1795661.40,218702.35,730012),('1','208','257861','479',685.00,780.00,0.00,2722.26,1864748.10,2123328.21,258580.11,730013),('1','208','257862','479',685.00,780.00,0.00,477.99,327423.15,372832.20,45409.05,730014),('1','208','257863','479',685.00,736.00,0.00,2029.48,1390193.80,1493697.28,103503.48,730015),('1','208','257864','479',685.00,736.00,0.00,1497.49,1025780.65,1102152.64,76371.99,730016),('1','208','257865','479',685.00,736.00,0.00,2604.49,1784075.65,1916904.64,132828.99,730017),('1','208','257866','479',685.00,736.00,0.00,636.95,436310.75,468795.20,32484.45,730018),('1','208','257867','479',685.00,736.00,0.00,2015.94,1380918.90,1483731.84,102812.94,730019),('1','208','257868','479',685.00,736.00,0.00,3183.64,2180793.40,2343124.44,162331.04,730020),('1','208','257869','479',685.00,736.00,0.00,1392.61,953937.85,1024960.96,71023.11,730021),('1','208','257870','479',685.00,736.00,0.00,2885.37,1976478.45,2123632.32,147153.87,730022),('1','208','257871','479',685.00,736.00,0.00,2084.60,1427951.00,1534265.60,106314.60,730023),('1','208','257872','479',685.00,736.00,0.00,429.90,294481.50,316406.40,21924.90,730024),('1','208','257873','479',685.00,736.00,0.00,1393.57,954595.45,1025667.52,71072.07,730025),('1','208','257874','479',685.00,736.00,0.00,2442.28,1672961.80,1797518.08,124556.28,730026),('1','208','257875','479',685.00,736.00,0.00,862.22,590620.70,634593.92,43973.22,730027),('1','208','257876','479',685.00,736.00,0.00,639.14,437810.90,470407.04,32596.14,730028),('1','208','257877','479',685.00,736.00,0.00,2554.03,1749510.55,1879766.08,130255.53,730029),('1','208','257878','479',685.00,736.00,0.00,2016.85,1381542.25,1484401.60,102859.35,730030),('1','208','257879','479',685.00,736.00,0.00,1649.29,1129763.65,1213877.44,84113.79,730031),('1','208','257880','479',685.00,736.00,0.00,2090.98,1432321.30,1538961.28,106639.98,730032),('1','208','257881','479',685.00,736.00,0.00,1965.84,1346600.40,1446858.24,100257.84,730033),('1','208','257882','479',685.00,736.00,0.00,1047.45,717503.25,770923.20,53419.95,730034),('1','208','257883','479',685.00,736.00,0.00,574.06,393231.10,422508.16,29277.06,730035),('1','208','257884','479',685.00,736.00,0.00,976.99,669238.15,719064.64,49826.49,730036),('1','208','257885','479',685.00,736.00,0.00,816.92,559590.20,601253.12,41662.92,730037),('1','208','257886','479',685.00,736.00,0.00,2107.06,1443336.10,1550796.16,107460.06,730038),('1','208','257887','479',685.00,736.00,0.00,1899.07,1300862.95,1397715.52,96852.57,730039),('1','208','257888','479',685.00,736.00,0.00,1583.19,1084485.15,1165227.84,80742.69,730040),('1','208','257889','479',685.00,736.00,0.00,2251.86,1542524.10,1657368.96,114844.86,730041),('1','208','257890','479',685.00,736.00,0.00,2224.17,1523556.45,1636989.12,113432.67,730042),('1','208','257891','479',685.00,736.00,0.00,879.73,602615.05,647481.28,44866.23,730043),('1','208','257892','479',685.00,736.00,0.00,1260.79,863641.15,927941.44,64300.29,730044),('1','208','257893','479',685.00,736.00,0.00,2075.82,1421936.70,1527803.52,105866.82,730045),('1','208','257894','479',685.00,736.00,0.00,1833.21,1255748.85,1349242.56,93493.71,730046),('1','208','257895','479',685.00,736.00,0.00,853.41,584585.85,628109.76,43523.91,730047),('1','208','257896','479',685.00,736.00,0.00,1378.62,944354.70,1014664.32,70309.62,730048),('1','208','257897','479',685.00,736.00,0.00,2658.98,1821401.30,1957009.28,135607.98,730049),('1','208','257898','479',685.00,736.00,0.00,1123.51,769604.35,826903.36,57299.01,730050),('1','208','257899','479',685.00,736.00,0.00,1106.48,757938.80,814369.28,56430.48,730051),('1','208','257900','479',685.00,736.00,0.00,2600.44,1781301.40,1913923.84,132622.44,730052),('1','208','257901','479',685.00,736.00,0.00,1466.83,1004778.55,1079586.88,74808.33,730053),('1','208','257902','479',676.00,736.00,0.00,383.59,259306.84,282322.24,23015.40,730054),('1','208','257903','479',676.00,736.00,0.00,1898.85,1283622.60,1397401.28,113778.68,730055),('1','208','257904','479',676.00,736.00,0.00,525.37,355150.12,386672.32,31522.20,730056),('1','208','257905','479',676.00,736.00,0.00,1151.96,778724.96,847842.56,69117.60,730057),('1','208','257906','479',676.00,736.00,0.00,2704.58,1828296.08,1990570.88,162274.80,730058),('1','208','257907','479',676.00,736.00,0.00,1602.93,1083580.68,1179756.48,96175.80,730059),('1','208','257908','479',676.00,736.00,0.00,730.52,493831.52,537662.72,43831.20,730060),('1','208','257909','479',676.00,736.00,0.00,2623.67,1773600.92,1931021.12,157420.20,730061),('1','208','257910','479',676.00,736.00,0.00,2053.12,1387909.12,1511096.32,123187.20,730062),('1','208','257911','479',676.00,736.00,0.00,2687.73,1816905.48,1978169.28,161263.80,730063),('1','208','257912','479',676.00,736.00,0.00,2773.06,1874588.56,2040972.16,166383.60,730064),('1','208','257913','479',676.00,736.00,0.00,2572.56,1739050.56,1893404.16,154353.60,730065),('1','208','257914','479',676.00,736.00,0.00,1988.32,1344104.32,1463403.52,119299.20,730066),('1','208','257915','479',676.00,736.00,0.00,954.90,645512.40,702806.40,57294.00,730067),('1','208','257916','479',676.00,736.00,0.00,1228.55,830499.80,904212.80,73713.00,730068),('1','208','257917','479',676.00,736.00,0.00,2441.40,1650386.40,1796870.40,146484.00,730069),('1','208','257918','479',676.00,736.00,0.00,1570.18,1061441.68,1155652.48,94210.80,730070),('1','208','257919','479',676.00,736.00,0.00,819.87,554232.12,603424.32,49192.20,730071),('1','208','257920','479',676.00,736.00,0.00,565.62,382359.12,416296.32,33937.20,730072),('1','208','257921','479',676.00,736.00,0.00,2198.19,1485976.44,1617867.84,131891.40,730073),('1','208','257922','479',676.00,736.00,0.00,2411.75,1630343.00,1774313.00,143970.00,730074),('1','208','257923','479',676.00,736.00,0.00,626.23,423331.48,460905.28,37573.80,730075),('1','208','257924','479',676.00,736.00,0.00,2494.69,1686410.44,1836091.84,149681.40,730076),('1','208','257925','479',676.00,736.00,0.00,1079.06,729444.56,794188.16,64743.60,730077),('1','208','257926','479',676.00,736.00,0.00,1497.46,1012282.96,1102130.56,89847.60,730078),('1','208','257927','479',676.00,736.00,0.00,2618.04,1769795.04,1926877.44,157082.40,730079),('1','208','257928','479',676.00,736.00,0.00,1416.94,957851.44,1042867.84,85016.40,730080),('1','208','257929','479',676.00,736.00,0.00,897.48,606696.48,660545.28,53848.80,730081),('1','208','257930','479',676.00,736.00,0.00,1713.24,1158150.24,1260944.64,102794.40,730082),('1','208','257931','479',676.00,736.00,0.00,3036.63,2052761.88,2234959.68,182197.80,730083),('1','208','257932','479',676.00,736.00,0.00,390.13,263727.88,287135.68,23407.80,730084),('1','208','257933','479',676.00,736.00,0.00,2082.65,1407871.40,1532830.40,124959.00,730085),('1','208','257934','479',676.00,736.00,0.00,352.84,238519.84,259690.24,21170.40,730086),('1','208','257935','479',651.00,736.00,0.00,1734.10,1128899.10,1276297.60,147398.50,730087),('1','208','257936','479',651.00,736.00,0.00,2564.35,1669391.85,1887361.60,217969.75,730088),('1','208','257937','479',651.00,736.00,0.00,686.36,446820.36,505160.96,58340.60,730089),('1','208','257938','479',651.00,736.00,0.00,1509.15,982456.65,1110734.40,128277.75,730090),('1','208','257939','479',651.00,736.00,0.00,2992.81,1948319.31,2202708.16,254388.85,730091),('1','208','257940','479',651.00,736.00,0.00,631.33,410995.83,464658.88,53663.05,730092),('1','208','257941','479',651.00,736.00,0.00,1740.96,1133364.96,1281346.56,147981.60,730093),('1','208','257942','479',651.00,736.00,0.00,2176.27,1416751.77,1601734.72,184982.95,730094),('1','208','257943','479',651.00,736.00,0.00,1537.48,1000899.48,1131585.28,130685.80,730095),('1','208','257944','479',651.00,736.00,0.00,4087.02,2660650.02,3008046.72,347396.70,730096),('1','208','257945','479',651.00,736.00,0.00,1015.89,661344.39,747695.04,86350.65,730097),('1','208','257946','479',651.00,736.00,0.00,2950.55,1920808.05,2171604.80,250796.75,730098),('1','208','257947','479',651.00,736.00,0.00,2150.78,1400157.78,1582974.08,182816.30,730099),('1','208','257948','479',651.00,736.00,0.00,2864.27,1864639.77,2108102.72,243462.95,730100),('1','208','257949','479',651.00,736.00,0.00,2297.44,1495633.44,1690915.84,195282.40,730101),('1','208','257950','479',651.00,736.00,0.00,3238.27,2108113.77,2383366.72,275252.95,730102),('1','208','257951','479',651.00,736.00,0.00,1818.46,1183817.46,1338386.56,154569.10,730103),('1','208','257952','479',651.00,736.00,0.00,774.82,504407.82,570267.52,65859.70,730104),('1','208','257953','479',651.00,736.00,0.00,2515.43,1637544.93,1851356.48,213811.55,730105),('1','208','257954','479',651.00,736.00,0.00,1784.32,1161592.32,1313259.52,151667.20,730106),('1','208','257955','479',651.00,736.00,0.00,509.08,331411.08,374682.88,43271.80,730107),('1','208','257956','479',651.00,736.00,0.00,954.47,621359.97,702489.92,81129.95,730108),('1','208','257957','479',651.00,736.00,0.00,706.65,460029.15,520094.40,60065.25,730109),('1','208','257958','479',651.00,736.00,0.00,2894.97,1884625.47,2130697.92,246072.45,730110),('1','208','257959','479',651.00,736.00,0.00,761.49,495729.99,560456.64,64726.65,730111),('1','208','257960','479',651.00,736.00,0.00,1893.18,1232460.18,1393380.48,160920.30,730112),('1','208','257961','479',651.00,736.00,0.00,1970.97,1283101.47,1450633.92,167532.45,730113),('1','208','257962','479',651.00,736.00,0.00,932.19,606855.69,686091.84,79236.15,730114),('1','208','257963','479',651.00,736.00,0.00,1136.39,739789.89,836383.04,96593.15,730115),('1','208','257964','479',651.00,736.00,0.00,2443.92,1590991.92,1798725.12,207733.20,730116),('1','208','257965','479',651.00,736.00,0.00,1626.87,1059092.37,1197376.32,138283.95,730117),('1','208','257966','479',651.00,736.00,0.00,2102.73,1368877.23,1547609.28,178732.05,730118),('1','208','257967','479',651.00,736.00,0.00,2306.58,1501583.58,1697642.88,196059.30,730119),('1','208','257968','479',651.00,736.00,0.00,2069.56,1347283.56,1523196.16,175912.60,730120),('1','208','257969','479',651.00,736.00,0.00,784.42,510657.42,577333.12,66675.70,730121),('1','208','257970','479',651.00,736.00,0.00,1509.09,982417.59,1110690.24,128272.65,730122),('1','208','257971','479',651.00,736.00,0.00,2890.13,1881474.63,2127135.68,245661.05,730123),('1','208','257972','479',651.00,736.00,0.00,997.25,649209.75,733976.00,84766.25,730124),('1','208','257973','479',651.00,736.00,0.00,1749.62,1139002.62,1287720.32,148717.70,730125),('1','208','257974','479',651.00,736.00,0.00,2372.29,1544360.79,1746005.44,201644.65,730126),('1','208','257975','479',651.00,736.00,0.00,872.40,567932.40,642086.40,74154.00,730127),('1','208','257976','479',651.00,736.00,0.00,2200.67,1432636.17,1619693.12,187056.95,730128),('1','208','257977','479',651.00,736.00,0.00,2250.77,1465251.27,1656566.72,191315.45,730129),('1','208','257978','479',651.00,736.00,0.00,572.49,372690.99,421352.64,48661.65,730130),('1','208','257979','479',651.00,736.00,0.00,0.00,0.00,0.00,0.00,730131),('1','208','257980','479',651.00,736.00,0.00,195.99,127589.49,144248.64,16659.15,730132),('1','208','257981','479',651.00,736.00,0.00,2248.57,1463819.07,1654947.52,191128.45,730133),('1','208','257982','479',651.00,736.00,0.00,2416.24,1572972.24,1778352.64,205380.40,730134),('1','208','257983','479',651.00,736.00,0.00,705.31,459156.81,519108.16,59951.35,730135),('1','208','257984','479',651.00,736.00,0.00,1649.20,1073629.20,1213811.20,140182.00,730136),('1','208','257985','479',651.00,736.00,0.00,2123.27,1382248.77,1562726.72,180477.95,730137),('1','208','257986','479',651.00,736.00,0.00,1486.31,967587.81,1093924.16,126336.35,730138),('1','208','257987','479',651.00,726.00,0.00,2123.22,1382216.22,1541457.72,159241.50,730139),('1','208','257988','479',651.00,726.00,0.00,2601.44,1693537.44,1888611.44,195074.00,730140),('1','208','257989','479',651.00,726.00,0.00,593.52,386381.52,430895.52,44514.00,730141),('1','208','257990','479',651.00,726.00,0.00,1486.36,967620.36,1079079.16,111458.80,730142),('1','208','257991','479',651.00,726.00,0.00,2377.13,1547511.63,1725796.38,178284.75,730143),('1','208','257992','479',651.00,726.00,0.00,1486.68,967828.68,1079329.68,111501.00,730144),('1','208','257993','479',651.00,726.00,0.00,472.97,307903.47,343376.22,35472.75,730145),('1','208','257994','479',651.00,726.00,0.00,2016.68,1312858.68,1464093.68,151235.00,730146),('1','208','257995','479',651.00,726.00,0.00,2542.00,1654842.00,1845434.00,190592.00,730147),('1','208','257996','479',651.00,726.00,0.00,294.52,191732.52,213821.52,22089.00,730148),('1','208','257997','479',651.00,726.00,0.00,641.45,417583.95,465692.70,48108.75,730149),('1','208','257998','479',651.00,726.00,0.00,2455.01,1598211.51,1782235.26,184023.75,730150),('1','208','257999','479',651.00,726.00,0.00,2277.35,1482554.85,1653275.37,170720.52,730151),('1','208','258000','479',651.00,726.00,0.00,1993.80,1297963.80,1447441.80,149478.00,730152);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=439 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',438,'208','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=1039 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','208','438',1038,1,'479','LPG TANK ',6000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2021-12-25 18:29:09','2021-12-25 18:29:09','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','208',1038,2872.20,'2023-03-19 18:35:41');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2743052 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2508891,'1','208',NULL,479,'Purchased from AA RANO NIGERIA LIMITED',0.00,13185540.00,25020.00,0.00,0.00,'2022-01-13 19:59:25','',''),(2508950,'1','208',NULL,479,'Reception corrector for bridging 130774',0.00,0.00,0.00,5000.00,0.00,'2022-01-13 20:08:57','',''),(2508951,'1','208','1038',479,'Received from bridging 130774',0.00,0.00,5000.00,0.00,0.00,'2022-01-13 20:08:57','',''),(2509512,'1','208','1038',479,'Retail Sale Id 1517513',7100.00,0.00,0.00,12.50,512.50,'2022-01-14 07:42:50','',''),(2509571,'1','208','1038',479,'Return of Retail Sale Id 1517513',0.00,7100.00,12.50,0.00,-512.50,'2022-01-14 07:47:23','',''),(2509676,'1','208','1038',479,'Retail Sale Id 1517634',3498.88,0.00,0.00,6.16,252.56,'2022-01-14 07:59:15','',''),(2509695,'1','208','1038',479,'Retail Sale Id 1517655',2999.04,0.00,0.00,5.28,216.48,'2022-01-14 08:01:05','',''),(2509725,'1','208','1038',479,'Retail Sale Id 1517683',3408.00,0.00,0.00,6.00,246.00,'2022-01-14 08:05:08','',''),(2509758,'1','208','1038',479,'Retail Sale Id 1517718',1999.36,0.00,0.00,3.52,144.32,'2022-01-14 08:09:08','',''),(2509999,'1','208','1038',479,'Retail Sale Id 1517927',7100.00,0.00,0.00,12.50,512.50,'2022-01-14 08:32:30','',''),(2510291,'1','208','1038',479,'Retail Sale Id 1518154',999.68,0.00,0.00,1.76,72.16,'2022-01-14 08:57:36','',''),(2511113,'1','208','1038',479,'Retail Sale Id 1518852',1749.44,0.00,0.00,3.08,126.28,'2022-01-14 09:58:44','',''),(2511149,'1','208','1038',479,'Retail Sale Id 1518903',7100.00,0.00,0.00,12.50,512.50,'2022-01-14 10:02:39','',''),(2511449,'1','208','1038',479,'Retail Sale Id 1519260',2840.00,0.00,0.00,5.00,205.00,'2022-01-14 10:35:13','',''),(2511450,'1','208','1038',479,'Retail Sale Id 1519260',3408.00,0.00,0.00,6.00,246.00,'2022-01-14 10:35:13','',''),(2511577,'1','208','1038',479,'Retail Sale Id 1519427',3498.88,0.00,0.00,6.16,252.56,'2022-01-14 10:51:08','',''),(2511597,'1','208','1038',479,'Retail Sale Id 1519442',7100.00,0.00,0.00,12.50,512.50,'2022-01-14 10:53:55','',''),(2511606,'1','208','1038',479,'Retail Sale Id 1519457',1499.52,0.00,0.00,2.64,108.24,'2022-01-14 10:55:25','',''),(2511792,'1','208','1038',479,'Retail Sale Id 1519601',1749.44,0.00,0.00,3.08,126.28,'2022-01-14 11:12:28','',''),(2511955,'1','208','1038',479,'Retail Sale Id 1519728',1999.36,0.00,0.00,3.52,144.32,'2022-01-14 11:25:40','',''),(2511988,'1','208','1038',479,'Retail Sale Id 1519752',698.64,0.00,0.00,1.23,50.43,'2022-01-14 11:29:00','',''),(2512023,'1','208','1038',479,'Retail Sale Id 1519801',2101.60,0.00,0.00,3.70,151.70,'2022-01-14 11:33:31','',''),(2512210,'1','208','1038',479,'Retail Sale Id 1519989',2851.36,0.00,0.00,5.02,205.82,'2022-01-14 11:56:42','',''),(2512340,'1','208','1038',479,'Retail Sale Id 1520114',999.68,0.00,0.00,1.76,72.16,'2022-01-14 12:15:52','',''),(2512417,'1','208','1038',479,'Retail Sale Id 1520179',698.64,0.00,0.00,1.23,50.43,'2022-01-14 12:23:02','',''),(2512438,'1','208','1038',479,'Retail Sale Id 1520192',568.00,0.00,0.00,1.00,41.00,'2022-01-14 12:24:37','',''),(2512473,'1','208','1038',479,'Retail Sale Id 1520215',3408.00,0.00,0.00,6.00,246.00,'2022-01-14 12:27:18','',''),(2512728,'1','208','1038',479,'Retail Sale Id 1520435',7100.00,0.00,0.00,12.50,512.50,'2022-01-14 13:01:31','',''),(2512758,'1','208','1038',479,'Retail Sale Id 1520470',3408.00,0.00,0.00,6.00,246.00,'2022-01-14 13:06:56','',''),(2512764,'1','208','1038',479,'Retail Sale Id 1520476',7100.00,0.00,0.00,12.50,512.50,'2022-01-14 13:08:17','',''),(2512829,'1','208','1038',479,'Retail Sale Id 1520533',999.68,0.00,0.00,1.76,72.16,'2022-01-14 13:20:49','',''),(2513048,'1','208','1038',479,'Retail Sale Id 1520711',3498.88,0.00,0.00,6.16,252.56,'2022-01-14 13:55:29','',''),(2513142,'1','208','1038',479,'Retail Sale Id 1520784',1999.36,0.00,0.00,3.52,144.32,'2022-01-14 14:08:03','',''),(2513183,'1','208','1038',479,'Retail Sale Id 1520830',7100.00,0.00,0.00,12.50,512.50,'2022-01-14 14:13:52','',''),(2513184,'1','208','1038',479,'Retail Sale Id 1520830',7100.00,0.00,0.00,12.50,512.50,'2022-01-14 14:13:52','',''),(2513782,'1','208','1038',479,'Retail Sale Id 1521405',3408.00,0.00,0.00,6.00,246.00,'2022-01-14 15:10:43','',''),(2514033,'1','208','1038',479,'Retail Sale Id 1521614',3498.88,0.00,0.00,6.16,252.56,'2022-01-14 15:33:50','',''),(2514861,'1','208','1038',479,'Retail Sale Id 1522468',5998.08,0.00,0.00,10.56,432.96,'2022-01-14 16:53:36','',''),(2514914,'1','208','1038',479,'Retail Sale Id 1522549',1499.52,0.00,0.00,2.64,108.24,'2022-01-14 16:58:43','',''),(2516396,'1','208','1038',479,'Retail Sale Id 1523910',42179.68,0.00,0.00,74.26,3044.66,'2022-01-14 20:35:15','',''),(2516568,'1','208','1038',479,'Retail Sale Id 1523952',143351.84,0.00,0.00,252.38,10347.58,'2022-01-14 23:06:50','',''),(2517961,'1','208','1038',479,'Retail Sale Id 1524959',1749.44,0.00,0.00,3.08,126.28,'2022-01-15 09:14:04','',''),(2517962,'1','208','1038',479,'Retail Sale Id 1524959',7100.00,0.00,0.00,12.50,512.50,'2022-01-15 09:14:04','',''),(2517989,'1','208','1038',479,'Retail Sale Id 1524983',22299.68,0.00,0.00,39.26,1609.66,'2022-01-15 09:15:53','',''),(2518114,'1','208','1038',479,'Retail Sale Id 1525094',7100.00,0.00,0.00,12.50,512.50,'2022-01-15 09:24:33','',''),(2518195,'1','208','1038',479,'Retail Sale Id 1525138',1499.52,0.00,0.00,2.64,108.24,'2022-01-15 09:28:40','',''),(2518407,'1','208','1038',479,'Retail Sale Id 1525289',7100.00,0.00,0.00,12.50,512.50,'2022-01-15 09:40:18','',''),(2519563,'1','208','1038',479,'Retail Sale Id 1526364',3447.76,0.00,0.00,6.07,248.87,'2022-01-15 11:13:09','',''),(2519577,'1','208','1038',479,'Retail Sale Id 1526377',2999.04,0.00,0.00,5.28,216.48,'2022-01-15 11:13:53','',''),(2519597,'1','208','1038',479,'Retail Sale Id 1526385',1198.48,0.00,0.00,2.11,86.51,'2022-01-15 11:14:48','',''),(2519604,'1','208','1038',479,'Retail Sale Id 1526392',3447.76,0.00,0.00,6.07,248.87,'2022-01-15 11:15:44','',''),(2519621,'1','208','1038',479,'Retail Sale Id 1526406',1749.44,0.00,0.00,3.08,126.28,'2022-01-15 11:16:52','',''),(2519628,'1','208','1038',479,'Retail Sale Id 1526415',1999.36,0.00,0.00,3.52,144.32,'2022-01-15 11:17:36','',''),(2519646,'1','208','1038',479,'Retail Sale Id 1526429',2851.36,0.00,0.00,5.02,205.82,'2022-01-15 11:18:41','',''),(2519894,'1','208','1038',479,'Retail Sale Id 1526651',7100.00,0.00,0.00,12.50,512.50,'2022-01-15 11:37:55','',''),(2519903,'1','208','1038',479,'Retail Sale Id 1526664',1749.44,0.00,0.00,3.08,126.28,'2022-01-15 11:39:17','',''),(2519904,'1','208','1038',479,'Retail Sale Id 1526664',1749.44,0.00,0.00,3.08,126.28,'2022-01-15 11:39:17','',''),(2520220,'1','208','1038',479,'Retail Sale Id 1526979',2851.36,0.00,0.00,5.02,205.82,'2022-01-15 12:06:03','',''),(2520276,'1','208','1038',479,'Retail Sale Id 1527045',7100.00,0.00,0.00,12.50,512.50,'2022-01-15 12:10:27','',''),(2520395,'1','208','1038',479,'Retail Sale Id 1527178',2851.36,0.00,0.00,5.02,205.82,'2022-01-15 12:21:28','',''),(2520488,'1','208','1038',479,'Retail Sale Id 1527272',7100.00,0.00,0.00,12.50,512.50,'2022-01-15 12:30:26','',''),(2520528,'1','208','1038',479,'Retail Sale Id 1527309',1704.00,0.00,0.00,3.00,123.00,'2022-01-15 12:33:43','',''),(2520542,'1','208','1038',479,'Retail Sale Id 1527326',2499.20,0.00,0.00,4.40,180.40,'2022-01-15 12:35:04','',''),(2520709,'1','208','1038',479,'Retail Sale Id 1527449',1999.36,0.00,0.00,3.52,144.32,'2022-01-15 12:47:23','',''),(2520841,'1','208','1038',479,'Retail Sale Id 1527576',2499.20,0.00,0.00,4.40,180.40,'2022-01-15 13:00:34','',''),(2521176,'1','208','1038',479,'Retail Sale Id 1527807',1749.44,0.00,0.00,3.08,126.28,'2022-01-15 13:23:47','',''),(2521496,'1','208','1038',479,'Retail Sale Id 1528131',2851.36,0.00,0.00,5.02,205.82,'2022-01-15 13:55:36','',''),(2521903,'1','208','1038',479,'Retail Sale Id 1528495',5702.72,0.00,0.00,10.04,411.64,'2022-01-15 14:32:47','',''),(2522181,'1','208','1038',479,'Retail Sale Id 1528733',7100.00,0.00,0.00,12.50,512.50,'2022-01-15 14:55:49','',''),(2522757,'1','208','1038',479,'Retail Sale Id 1529178',1749.44,0.00,0.00,3.08,126.28,'2022-01-15 15:36:56','',''),(2523010,'1','208','1038',479,'Retail Sale Id 1529412',28400.00,0.00,0.00,50.00,2050.00,'2022-01-15 16:01:50','',''),(2523192,'1','208','1038',479,'Retail Sale Id 1529618',5998.08,0.00,0.00,10.56,432.96,'2022-01-15 16:21:48','',''),(2523326,'1','208','1038',479,'Retail Sale Id 1529734',3998.72,0.00,0.00,7.04,288.64,'2022-01-15 16:32:03','',''),(2523439,'1','208','1038',479,'Retail Sale Id 1529815',3408.00,0.00,0.00,6.00,246.00,'2022-01-15 16:37:52','',''),(2523615,'1','208','1038',479,'Retail Sale Id 1529979',6497.92,0.00,0.00,11.44,469.04,'2022-01-15 16:50:02','',''),(2523760,'1','208','1038',479,'Retail Sale Id 1530090',1999.36,0.00,0.00,3.52,144.32,'2022-01-15 16:58:11','',''),(2523923,'1','208','1038',479,'Retail Sale Id 1530195',3748.80,0.00,0.00,6.60,270.60,'2022-01-15 17:06:20','',''),(2524047,'1','208','1038',479,'Retail Sale Id 1530299',3408.00,0.00,0.00,6.00,246.00,'2022-01-15 17:15:42','',''),(2524086,'1','208','1038',479,'Retail Sale Id 1530339',1999.36,0.00,0.00,3.52,144.32,'2022-01-15 17:18:52','',''),(2524208,'1','208','1038',479,'Retail Sale Id 1530461',3498.88,0.00,0.00,6.16,252.56,'2022-01-15 17:27:54','',''),(2524290,'1','208','1038',479,'Retail Sale Id 1530554',3408.00,0.00,0.00,6.00,246.00,'2022-01-15 17:33:58','',''),(2524323,'1','208','1038',479,'Retail Sale Id 1530591',3402.32,0.00,0.00,5.99,245.59,'2022-01-15 17:36:37','',''),(2524693,'1','208','1038',479,'Retail Sale Id 1530916',698.64,0.00,0.00,1.23,50.43,'2022-01-15 18:03:25','',''),(2524713,'1','208','1038',479,'Retail Sale Id 1530935',7100.00,0.00,0.00,12.50,512.50,'2022-01-15 18:05:06','',''),(2524980,'1','208','1038',479,'Retail Sale Id 1531186',7100.00,0.00,0.00,12.50,512.50,'2022-01-15 18:39:24','',''),(2525259,'1','208','1038',479,'Retail Sale Id 1531416',602.08,0.00,0.00,1.06,43.46,'2022-01-15 19:22:45','',''),(2525260,'1','208','1038',479,'Retail Sale Id 1531416',1999.36,0.00,0.00,3.52,144.32,'2022-01-15 19:22:45','',''),(2525292,'1','208','1038',479,'Retail Sale Id 1531430',2999.04,0.00,0.00,5.28,216.48,'2022-01-15 19:30:19','',''),(2526651,'1','208','1038',479,'Retail Sale Id 1532243',3402.32,0.00,0.00,5.99,245.59,'2022-01-16 08:45:41','',''),(2526699,'1','208','1038',479,'Retail Sale Id 1532297',999.68,0.00,0.00,1.76,72.16,'2022-01-16 08:50:31','',''),(2526713,'1','208','1038',479,'Retail Sale Id 1532311',5680.00,0.00,0.00,10.00,410.00,'2022-01-16 08:51:53','',''),(2526878,'1','208','1038',479,'Retail Sale Id 1532467',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 09:07:26','',''),(2526929,'1','208','1038',479,'Retail Sale Id 1532515',999.68,0.00,0.00,1.76,72.16,'2022-01-16 09:12:19','',''),(2526964,'1','208','1038',479,'Retail Sale Id 1532562',5680.00,0.00,0.00,10.00,410.00,'2022-01-16 09:15:41','',''),(2526992,'1','208','1038',479,'Retail Sale Id 1532583',2800.24,0.00,0.00,4.93,202.13,'2022-01-16 09:17:10','',''),(2527008,'1','208','1038',479,'Retail Sale Id 1532601',3402.32,0.00,0.00,5.99,245.59,'2022-01-16 09:18:40','',''),(2527091,'1','208','1038',479,'Retail Sale Id 1532650',999.68,0.00,0.00,1.76,72.16,'2022-01-16 09:23:25','',''),(2527299,'1','208','1038',479,'Retail Sale Id 1532856',3998.72,0.00,0.00,7.04,288.64,'2022-01-16 09:41:56','',''),(2527367,'1','208','1038',479,'Retail Sale Id 1532917',3408.00,0.00,0.00,6.00,246.00,'2022-01-16 09:46:03','',''),(2527488,'1','208','1038',479,'Retail Sale Id 1533050',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 09:56:53','',''),(2527503,'1','208','1038',479,'Retail Sale Id 1533079',3498.88,0.00,0.00,6.16,252.56,'2022-01-16 09:58:00','',''),(2527504,'1','208','1038',479,'Retail Sale Id 1533079',3498.88,0.00,0.00,6.16,252.56,'2022-01-16 09:58:00','',''),(2527516,'1','208','1038',479,'Retail Sale Id 1533093',1800.56,0.00,0.00,3.17,129.97,'2022-01-16 09:59:02','',''),(2527700,'1','208','1038',479,'Retail Sale Id 1533215',2999.04,0.00,0.00,5.28,216.48,'2022-01-16 10:09:10','',''),(2527870,'1','208','1038',479,'Retail Sale Id 1533383',4998.40,0.00,0.00,8.80,360.80,'2022-01-16 10:23:23','',''),(2527891,'1','208','1038',479,'Retail Sale Id 1533405',3408.00,0.00,0.00,6.00,246.00,'2022-01-16 10:25:19','',''),(2528014,'1','208','1038',479,'Retail Sale Id 1533501',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 10:34:01','',''),(2528015,'1','208','1038',479,'Retail Sale Id 1533501',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 10:34:01','',''),(2528025,'1','208','1038',479,'Retail Sale Id 1533509',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 10:34:54','',''),(2528182,'1','208','1038',479,'Retail Sale Id 1533664',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 10:47:14','',''),(2528359,'1','208','1038',479,'Retail Sale Id 1533850',3498.88,0.00,0.00,6.16,252.56,'2022-01-16 11:02:49','',''),(2528458,'1','208','1038',479,'Retail Sale Id 1533942',2840.00,0.00,0.00,5.00,205.00,'2022-01-16 11:10:15','',''),(2528481,'1','208','1038',479,'Retail Sale Id 1533962',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 11:11:47','',''),(2528533,'1','208','1038',479,'Retail Sale Id 1534020',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 11:15:34','',''),(2528900,'1','208','1038',479,'Retail Sale Id 1534409',6816.00,0.00,0.00,12.00,492.00,'2022-01-16 11:48:14','',''),(2529065,'1','208','1038',479,'Retail Sale Id 1534593',2999.04,0.00,0.00,5.28,216.48,'2022-01-16 12:04:33','',''),(2529139,'1','208','1038',479,'Retail Sale Id 1534659',999.68,0.00,0.00,1.76,72.16,'2022-01-16 12:10:14','',''),(2529151,'1','208','1038',479,'Retail Sale Id 1534672',1499.52,0.00,0.00,2.64,108.24,'2022-01-16 12:11:12','',''),(2529156,'1','208','1038',479,'Retail Sale Id 1534679',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 12:12:06','',''),(2529203,'1','208','1038',479,'Retail Sale Id 1534727',3408.00,0.00,0.00,6.00,246.00,'2022-01-16 12:16:54','',''),(2529214,'1','208','1038',479,'Retail Sale Id 1534739',2840.00,0.00,0.00,5.00,205.00,'2022-01-16 12:17:56','',''),(2529313,'1','208','1038',479,'Retail Sale Id 1534844',800.88,0.00,0.00,1.41,57.81,'2022-01-16 12:27:04','',''),(2529646,'1','208','1038',479,'Retail Sale Id 1535175',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 12:59:05','',''),(2529652,'1','208','1038',479,'Retail Sale Id 1535182',1709.68,0.00,0.00,3.01,123.41,'2022-01-16 12:59:49','',''),(2529951,'1','208','1038',479,'Retail Sale Id 1535465',1141.68,0.00,0.00,2.01,82.41,'2022-01-16 13:27:02','',''),(2529989,'1','208','1038',479,'Retail Sale Id 1535548',2840.00,0.00,0.00,5.00,205.00,'2022-01-16 13:32:39','',''),(2530143,'1','208','1038',479,'Retail Sale Id 1535788',1999.36,0.00,0.00,3.52,144.32,'2022-01-16 13:49:18','',''),(2530502,'1','208','1038',479,'Retail Sale Id 1536108',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 14:23:28','',''),(2530586,'1','208','1038',479,'Retail Sale Id 1536168',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 14:29:12','',''),(2530672,'1','208','1038',479,'Retail Sale Id 1536242',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 14:38:10','',''),(2530679,'1','208','1038',479,'Retail Sale Id 1536253',2840.00,0.00,0.00,5.00,205.00,'2022-01-16 14:39:02','',''),(2530696,'1','208','1038',479,'Retail Sale Id 1536270',2840.00,0.00,0.00,5.00,205.00,'2022-01-16 14:40:27','',''),(2530712,'1','208','1038',479,'Retail Sale Id 1536280',3498.88,0.00,0.00,6.16,252.56,'2022-01-16 14:41:17','',''),(2530838,'1','208','1038',479,'Retail Sale Id 1536401',5998.08,0.00,0.00,10.56,432.96,'2022-01-16 14:53:07','',''),(2530896,'1','208','1038',479,'Retail Sale Id 1536429',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 14:56:35','',''),(2530935,'1','208','1038',479,'Retail Sale Id 1536438',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 14:57:46','',''),(2530951,'1','208','1038',479,'Retail Sale Id 1536445',2999.04,0.00,0.00,5.28,216.48,'2022-01-16 14:58:44','',''),(2530970,'1','208','1038',479,'Retail Sale Id 1536455',5998.08,0.00,0.00,10.56,432.96,'2022-01-16 14:59:48','',''),(2531008,'1','208','1038',479,'Retail Sale Id 1536493',4998.40,0.00,0.00,8.80,360.80,'2022-01-16 15:05:02','',''),(2531177,'1','208','1038',479,'Retail Sale Id 1536587',1999.36,0.00,0.00,3.52,144.32,'2022-01-16 15:15:42','',''),(2531178,'1','208','1038',479,'Retail Sale Id 1536587',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 15:15:42','',''),(2531266,'1','208','1038',479,'Retail Sale Id 1536662',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 15:24:31','',''),(2531318,'1','208','1038',479,'Retail Sale Id 1536699',2840.00,0.00,0.00,5.00,205.00,'2022-01-16 15:29:39','',''),(2531403,'1','208','1038',479,'Retail Sale Id 1536787',3498.88,0.00,0.00,6.16,252.56,'2022-01-16 15:39:28','',''),(2531419,'1','208','1038',479,'Retail Sale Id 1536804',2499.20,0.00,0.00,4.40,180.40,'2022-01-16 15:41:45','',''),(2531480,'1','208','1038',479,'Retail Sale Id 1536833',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 15:46:05','',''),(2531929,'1','208','1038',479,'Retail Sale Id 1537235',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 16:31:05','',''),(2531943,'1','208','1038',479,'Retail Sale Id 1537245',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 16:32:12','',''),(2532261,'1','208','1038',479,'Retail Sale Id 1537517',1999.36,0.00,0.00,3.52,144.32,'2022-01-16 16:55:39','',''),(2532391,'1','208','1038',479,'Retail Sale Id 1537634',4998.40,0.00,0.00,8.80,360.80,'2022-01-16 17:05:37','',''),(2532459,'1','208','1038',479,'Retail Sale Id 1537705',3408.00,0.00,0.00,6.00,246.00,'2022-01-16 17:11:23','',''),(2532498,'1','208','1038',479,'Retail Sale Id 1537744',3498.88,0.00,0.00,6.16,252.56,'2022-01-16 17:13:51','',''),(2532549,'1','208','1038',479,'Retail Sale Id 1537794',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 17:18:07','',''),(2532569,'1','208','1038',479,'Retail Sale Id 1537879',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 17:21:26','',''),(2532580,'1','208','1038',479,'Retail Sale Id 1537901',4998.40,0.00,0.00,8.80,360.80,'2022-01-16 17:23:06','',''),(2532685,'1','208','1038',479,'Retail Sale Id 1538014',2840.00,0.00,0.00,5.00,205.00,'2022-01-16 17:30:47','',''),(2532698,'1','208','1038',479,'Retail Sale Id 1538029',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 17:31:56','',''),(2532715,'1','208','1038',479,'Retail Sale Id 1538046',2499.20,0.00,0.00,4.40,180.40,'2022-01-16 17:32:54','',''),(2532724,'1','208','1038',479,'Retail Sale Id 1538056',2101.60,0.00,0.00,3.70,151.70,'2022-01-16 17:33:43','',''),(2532835,'1','208','1038',479,'Retail Sale Id 1538171',7100.00,0.00,0.00,12.50,512.50,'2022-01-16 17:42:21','',''),(2532924,'1','208','1038',479,'Retail Sale Id 1538231',1999.36,0.00,0.00,3.52,144.32,'2022-01-16 17:47:56','',''),(2535865,'1','208','1038',479,'Retail Sale Id 1540353',3447.76,0.00,0.00,6.07,248.87,'2022-01-17 10:35:39','',''),(2535866,'1','208','1038',479,'Retail Sale Id 1540353',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 10:35:39','',''),(2535884,'1','208','1038',479,'Retail Sale Id 1540364',3402.32,0.00,0.00,5.99,245.59,'2022-01-17 10:37:32','',''),(2535927,'1','208','1038',479,'Retail Sale Id 1540404',3402.32,0.00,0.00,5.99,245.59,'2022-01-17 10:41:43','',''),(2535958,'1','208','1038',479,'Retail Sale Id 1540425',1704.00,0.00,0.00,3.00,123.00,'2022-01-17 10:44:18','',''),(2535984,'1','208','1038',479,'Retail Sale Id 1540432',1704.00,0.00,0.00,3.00,123.00,'2022-01-17 10:45:20','',''),(2535985,'1','208','1038',479,'Retail Sale Id 1540432',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 10:45:20','',''),(2536027,'1','208','1038',479,'Retail Sale Id 1540447',60310.24,0.00,0.00,106.18,4353.38,'2022-01-17 10:48:19','',''),(2536052,'1','208','1038',479,'Retail Sale Id 1540462',21720.32,0.00,0.00,38.24,1567.84,'2022-01-17 10:51:56','',''),(2536074,'1','208','1038',479,'Retail Sale Id 1540479',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 10:54:22','',''),(2536156,'1','208','1038',479,'Retail Sale Id 1540569',1749.44,0.00,0.00,3.08,126.28,'2022-01-17 11:05:37','',''),(2536157,'1','208','1038',479,'Retail Sale Id 1540569',1749.44,0.00,0.00,3.08,126.28,'2022-01-17 11:05:37','',''),(2536257,'1','208','1038',479,'Retail Sale Id 1540677',3447.76,0.00,0.00,6.07,248.87,'2022-01-17 11:19:17','',''),(2536393,'1','208','1038',479,'Retail Sale Id 1540772',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 11:34:38','',''),(2536430,'1','208','1038',479,'Retail Sale Id 1540801',1999.36,0.00,0.00,3.52,144.32,'2022-01-17 11:37:04','',''),(2536440,'1','208','1038',479,'Retail Sale Id 1540816',999.68,0.00,0.00,1.76,72.16,'2022-01-17 11:38:29','',''),(2536727,'1','208','1038',479,'Retail Sale Id 1541135',1499.52,0.00,0.00,2.64,108.24,'2022-01-17 12:17:21','',''),(2536779,'1','208','1038',479,'Retail Sale Id 1541188',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 12:25:20','',''),(2536978,'1','208','1038',479,'Retail Sale Id 1541376',2902.48,0.00,0.00,5.11,209.51,'2022-01-17 12:52:23','',''),(2537018,'1','208','1038',479,'Retail Sale Id 1541403',2499.20,0.00,0.00,4.40,180.40,'2022-01-17 12:56:07','',''),(2537047,'1','208','1038',479,'Retail Sale Id 1541432',3447.76,0.00,0.00,6.07,248.87,'2022-01-17 13:00:51','',''),(2537048,'1','208','1038',479,'Retail Sale Id 1541432',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 13:00:51','',''),(2537131,'1','208','1038',479,'Retail Sale Id 1541519',2999.04,0.00,0.00,5.28,216.48,'2022-01-17 13:15:09','',''),(2537274,'1','208','1038',479,'Retail Sale Id 1541656',3447.76,0.00,0.00,6.07,248.87,'2022-01-17 13:34:19','',''),(2537472,'1','208','1038',479,'Retail Sale Id 1541840',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 13:57:29','',''),(2537580,'1','208','1038',479,'Retail Sale Id 1541930',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 14:07:15','',''),(2537822,'1','208','1038',479,'Retail Sale Id 1542105',2499.20,0.00,0.00,4.40,180.40,'2022-01-17 14:32:01','',''),(2537963,'1','208','1038',479,'Retail Sale Id 1542209',499.84,0.00,0.00,0.88,36.08,'2022-01-17 14:45:40','',''),(2537978,'1','208','1038',479,'Retail Sale Id 1542225',1749.44,0.00,0.00,3.08,126.28,'2022-01-17 14:48:02','',''),(2537979,'1','208','1038',479,'Retail Sale Id 1542225',1749.44,0.00,0.00,3.08,126.28,'2022-01-17 14:48:02','',''),(2538042,'1','208','1038',479,'Retail Sale Id 1542286',3402.32,0.00,0.00,5.99,245.59,'2022-01-17 14:54:41','',''),(2538079,'1','208','1038',479,'Retail Sale Id 1542327',2800.24,0.00,0.00,4.93,202.13,'2022-01-17 14:59:07','',''),(2538101,'1','208','1038',479,'Retail Sale Id 1542348',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 15:01:03','',''),(2538113,'1','208','1038',479,'Retail Sale Id 1542358',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 15:01:43','',''),(2538330,'1','208','1038',479,'Retail Sale Id 1542470',2999.04,0.00,0.00,5.28,216.48,'2022-01-17 15:15:12','',''),(2538706,'1','208','1038',479,'Retail Sale Id 1542806',1749.44,0.00,0.00,3.08,126.28,'2022-01-17 15:53:47','',''),(2538718,'1','208','1038',479,'Retail Sale Id 1542821',1499.52,0.00,0.00,2.64,108.24,'2022-01-17 15:54:53','',''),(2538854,'1','208','1038',479,'Retail Sale Id 1542924',499.84,0.00,0.00,0.88,36.08,'2022-01-17 16:07:47','',''),(2538888,'1','208','1038',479,'Retail Sale Id 1542960',1749.44,0.00,0.00,3.08,126.28,'2022-01-17 16:11:25','',''),(2538897,'1','208','1038',479,'Retail Sale Id 1542969',1698.32,0.00,0.00,2.99,122.59,'2022-01-17 16:12:24','',''),(2538908,'1','208','1038',479,'Retail Sale Id 1542985',1698.32,0.00,0.00,2.99,122.59,'2022-01-17 16:13:12','',''),(2538919,'1','208','1038',479,'Retail Sale Id 1542996',3447.76,0.00,0.00,6.07,248.87,'2022-01-17 16:14:20','',''),(2539548,'1','208','1038',479,'Retail Sale Id 1543630',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 17:08:57','',''),(2539620,'1','208','1038',479,'Retail Sale Id 1543718',3447.76,0.00,0.00,6.07,248.87,'2022-01-17 17:14:08','',''),(2539896,'1','208','1038',479,'Retail Sale Id 1543895',6497.92,0.00,0.00,11.44,469.04,'2022-01-17 17:34:48','',''),(2540019,'1','208','1038',479,'Retail Sale Id 1544117',1300.72,0.00,0.00,2.29,93.89,'2022-01-17 17:43:29','',''),(2540036,'1','208','1038',479,'Retail Sale Id 1544142',7100.00,0.00,0.00,12.50,512.50,'2022-01-17 17:45:00','',''),(2540091,'1','208','1038',479,'Retail Sale Id 1544186',1999.36,0.00,0.00,3.52,144.32,'2022-01-17 17:49:53','',''),(2541441,'1','208','1038',479,'Retail Sale Id 1545283',5396.00,0.00,0.00,9.50,389.50,'2022-01-18 08:24:08','',''),(2541442,'1','208','1038',479,'Retail Sale Id 1545283',7100.00,0.00,0.00,12.50,512.50,'2022-01-18 08:24:08','',''),(2541465,'1','208','1038',479,'Retail Sale Id 1545304',3402.32,0.00,0.00,5.99,245.59,'2022-01-18 08:27:14','',''),(2541477,'1','208','1038',479,'Retail Sale Id 1545315',3998.72,0.00,0.00,7.04,288.64,'2022-01-18 08:28:18','',''),(2541487,'1','208','1038',479,'Retail Sale Id 1545325',2999.04,0.00,0.00,5.28,216.48,'2022-01-18 08:29:23','',''),(2541495,'1','208','1038',479,'Retail Sale Id 1545332',7100.00,0.00,0.00,12.50,512.50,'2022-01-18 08:30:04','',''),(2541501,'1','208','1038',479,'Retail Sale Id 1545339',6497.92,0.00,0.00,11.44,469.04,'2022-01-18 08:30:44','',''),(2541531,'1','208','1038',479,'Retail Sale Id 1545367',7100.00,0.00,0.00,12.50,512.50,'2022-01-18 08:34:26','',''),(2541568,'1','208','1038',479,'Retail Sale Id 1545396',1999.36,0.00,0.00,3.52,144.32,'2022-01-18 08:37:48','',''),(2541649,'1','208','1038',479,'Retail Sale Id 1545454',3402.32,0.00,0.00,5.99,245.59,'2022-01-18 08:46:41','',''),(2541730,'1','208','1038',479,'Retail Sale Id 1545529',1704.00,0.00,0.00,3.00,123.00,'2022-01-18 08:56:00','',''),(2541792,'1','208','1038',479,'Retail Sale Id 1545570',2800.24,0.00,0.00,4.93,202.13,'2022-01-18 09:01:46','',''),(2541891,'1','208','1038',479,'Retail Sale Id 1545648',1198.48,0.00,0.00,2.11,86.51,'2022-01-18 09:12:18','',''),(2541892,'1','208','1038',479,'Retail Sale Id 1545648',2999.04,0.00,0.00,5.28,216.48,'2022-01-18 09:12:18','',''),(2542034,'1','208','1038',479,'Retail Sale Id 1545715',7100.00,0.00,0.00,12.50,512.50,'2022-01-18 09:23:54','',''),(2542121,'1','208','1038',479,'Retail Sale Id 1545774',999.68,0.00,0.00,1.76,72.16,'2022-01-18 09:31:38','',''),(2542122,'1','208','1038',479,'Retail Sale Id 1545774',999.68,0.00,0.00,1.76,72.16,'2022-01-18 09:31:38','',''),(2542290,'1','208','1038',479,'Retail Sale Id 1545894',4998.40,0.00,0.00,8.80,360.80,'2022-01-18 09:46:43','',''),(2542353,'1','208','1038',479,'Retail Sale Id 1545944',2840.00,0.00,0.00,5.00,205.00,'2022-01-18 09:54:06','',''),(2542379,'1','208','1038',479,'Retail Sale Id 1545969',1147.36,0.00,0.00,2.02,82.82,'2022-01-18 09:57:16','',''),(2547672,'1','208','1038',479,'Retail Sale Id 1550721',28400.00,0.00,0.00,50.00,2050.00,'2022-01-18 18:33:52','',''),(2547681,'1','208','1038',479,'Retail Sale Id 1550726',14200.00,0.00,0.00,25.00,1025.00,'2022-01-18 18:34:52','',''),(2547683,'1','208','1038',479,'Retail Sale Id 1550733',7100.00,0.00,0.00,12.50,512.50,'2022-01-18 18:35:37','',''),(2547694,'1','208','1038',479,'Retail Sale Id 1550740',14200.00,0.00,0.00,25.00,1025.00,'2022-01-18 18:36:36','',''),(2547698,'1','208','1038',479,'Retail Sale Id 1550744',3408.00,0.00,0.00,6.00,246.00,'2022-01-18 18:37:19','',''),(2547702,'1','208','1038',479,'Retail Sale Id 1550747',28400.00,0.00,0.00,50.00,2050.00,'2022-01-18 18:38:15','',''),(2547706,'1','208','1038',479,'Retail Sale Id 1550751',5680.00,0.00,0.00,10.00,410.00,'2022-01-18 18:39:04','',''),(2547711,'1','208','1038',479,'Retail Sale Id 1550757',18704.24,0.00,0.00,32.93,1350.13,'2022-01-18 18:40:07','',''),(2547731,'1','208','1038',479,'Retail Sale Id 1550778',3498.88,0.00,0.00,6.16,252.56,'2022-01-18 18:46:07','',''),(2547749,'1','208','1038',479,'Retail Sale Id 1550800',602.08,0.00,0.00,1.06,43.46,'2022-01-18 18:50:13','',''),(2547810,'1','208','1038',479,'Retail Sale Id 1550897',42600.00,0.00,0.00,75.00,3075.00,'2022-01-18 19:03:23','',''),(2547815,'1','208','1038',479,'Retail Sale Id 1550937',28400.00,0.00,0.00,50.00,2050.00,'2022-01-18 19:05:03','',''),(2547829,'1','208','1038',479,'Retail Sale Id 1550941',14200.00,0.00,0.00,25.00,1025.00,'2022-01-18 19:06:14','',''),(2547836,'1','208','1038',479,'Retail Sale Id 1550944',21300.00,0.00,0.00,37.50,1537.50,'2022-01-18 19:07:33','',''),(2547852,'1','208','1038',479,'Retail Sale Id 1550953',1198.48,0.00,0.00,2.11,86.51,'2022-01-18 19:11:09','',''),(2547858,'1','208','1038',479,'Retail Sale Id 1550955',7100.00,0.00,0.00,12.50,512.50,'2022-01-18 19:12:06','',''),(2547860,'1','208','1038',479,'Retail Sale Id 1550957',3408.00,0.00,0.00,6.00,246.00,'2022-01-18 19:12:57','',''),(2547866,'1','208','1038',479,'Retail Sale Id 1550964',1704.00,0.00,0.00,3.00,123.00,'2022-01-18 19:14:37','',''),(2547872,'1','208','1038',479,'Retail Sale Id 1550970',3998.72,0.00,0.00,7.04,288.64,'2022-01-18 19:16:57','',''),(2547873,'1','208','1038',479,'Retail Sale Id 1550971',999.68,0.00,0.00,1.76,72.16,'2022-01-18 19:17:56','',''),(2547876,'1','208','1038',479,'Retail Sale Id 1550974',3402.32,0.00,0.00,5.99,245.59,'2022-01-18 19:19:28','',''),(2547878,'1','208','1038',479,'Retail Sale Id 1550976',3447.76,0.00,0.00,6.07,248.87,'2022-01-18 19:20:31','',''),(2547887,'1','208','1038',479,'Retail Sale Id 1550984',7100.00,0.00,0.00,12.50,512.50,'2022-01-18 19:27:52','',''),(2547902,'1','208','1038',479,'Retail Sale Id 1551001',3408.00,0.00,0.00,6.00,246.00,'2022-01-18 19:33:05','',''),(2547915,'1','208','1038',479,'Retail Sale Id 1551014',7100.00,0.00,0.00,12.50,512.50,'2022-01-18 19:38:24','',''),(2547943,'1','208','1038',479,'Retail Sale Id 1551034',2499.20,0.00,0.00,4.40,180.40,'2022-01-18 19:52:17','',''),(2547951,'1','208','1038',479,'Retail Sale Id 1551039',3408.00,0.00,0.00,6.00,246.00,'2022-01-18 20:00:11','',''),(2549487,'1','208','1038',479,'Retail Sale Id 1551996',2976.32,0.00,0.00,5.24,214.84,'2022-01-19 09:02:21','',''),(2549638,'1','208','1038',479,'Retail Sale Id 1552138',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 09:14:54','',''),(2549668,'1','208','1038',479,'Retail Sale Id 1552157',1499.52,0.00,0.00,2.64,108.24,'2022-01-19 09:16:36','',''),(2549701,'1','208','1038',479,'Retail Sale Id 1552180',60560.16,0.00,0.00,106.62,4371.42,'2022-01-19 09:19:02','',''),(2549727,'1','208','1038',479,'Retail Sale Id 1552193',21197.76,0.00,0.00,37.32,1530.12,'2022-01-19 09:20:19','',''),(2549782,'1','208','1038',479,'Retail Sale Id 1552244',2499.20,0.00,0.00,4.40,180.40,'2022-01-19 09:25:44','',''),(2549783,'1','208','1038',479,'Retail Sale Id 1552244',3498.88,0.00,0.00,6.16,252.56,'2022-01-19 09:25:44','',''),(2549904,'1','208','1038',479,'Retail Sale Id 1552358',2851.36,0.00,0.00,5.02,205.82,'2022-01-19 09:35:10','',''),(2549917,'1','208','1038',479,'Retail Sale Id 1552373',2300.40,0.00,0.00,4.05,166.05,'2022-01-19 09:36:16','',''),(2549956,'1','208','1038',479,'Retail Sale Id 1552420',4998.40,0.00,0.00,8.80,360.80,'2022-01-19 09:40:24','',''),(2549972,'1','208','1038',479,'Retail Sale Id 1552435',3408.00,0.00,0.00,6.00,246.00,'2022-01-19 09:42:03','',''),(2550070,'1','208','1038',479,'Retail Sale Id 1552529',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 09:51:47','',''),(2550071,'1','208','1038',479,'Retail Sale Id 1552529',3447.76,0.00,0.00,6.07,248.87,'2022-01-19 09:51:47','',''),(2550072,'1','208','1038',479,'Retail Sale Id 1552529',5702.72,0.00,0.00,10.04,411.64,'2022-01-19 09:51:47','',''),(2550086,'1','208','1038',479,'Retail Sale Id 1552540',2851.36,0.00,0.00,5.02,205.82,'2022-01-19 09:53:08','',''),(2550103,'1','208','1038',479,'Retail Sale Id 1552558',2902.48,0.00,0.00,5.11,209.51,'2022-01-19 09:54:58','',''),(2550114,'1','208','1038',479,'Retail Sale Id 1552571',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 09:56:20','',''),(2550211,'1','208','1038',479,'Retail Sale Id 1552664',1999.36,0.00,0.00,3.52,144.32,'2022-01-19 10:06:53','',''),(2550298,'1','208','1038',479,'Retail Sale Id 1552763',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 10:14:46','',''),(2550388,'1','208','1038',479,'Retail Sale Id 1552847',6997.76,0.00,0.00,12.32,505.12,'2022-01-19 10:23:46','',''),(2550389,'1','208','1038',479,'Retail Sale Id 1552847',20998.96,0.00,0.00,36.97,1515.77,'2022-01-19 10:23:46','',''),(2550429,'1','208','1038',479,'Retail Sale Id 1552895',3447.76,0.00,0.00,6.07,248.87,'2022-01-19 10:29:46','',''),(2550430,'1','208','1038',479,'Retail Sale Id 1552895',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 10:29:46','',''),(2550441,'1','208','1038',479,'Retail Sale Id 1552911',3447.76,0.00,0.00,6.07,248.87,'2022-01-19 10:31:04','',''),(2550467,'1','208','1038',479,'Retail Sale Id 1552932',2851.36,0.00,0.00,5.02,205.82,'2022-01-19 10:32:44','',''),(2550499,'1','208','1038',479,'Retail Sale Id 1552969',8497.28,0.00,0.00,14.96,613.36,'2022-01-19 10:35:46','',''),(2550535,'1','208','1038',479,'Retail Sale Id 1553009',1499.52,0.00,0.00,2.64,108.24,'2022-01-19 10:39:51','',''),(2550882,'1','208','1038',479,'Retail Sale Id 1553314',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 11:12:34','',''),(2550900,'1','208','1038',479,'Retail Sale Id 1553334',6997.76,0.00,0.00,12.32,505.12,'2022-01-19 11:15:03','',''),(2550910,'1','208','1038',479,'Retail Sale Id 1553345',1300.72,0.00,0.00,2.29,93.89,'2022-01-19 11:16:05','',''),(2550984,'1','208','1038',479,'Retail Sale Id 1553421',1999.36,0.00,0.00,3.52,144.32,'2022-01-19 11:23:40','',''),(2550996,'1','208','1038',479,'Retail Sale Id 1553434',2999.04,0.00,0.00,5.28,216.48,'2022-01-19 11:25:37','',''),(2550997,'1','208','1038',479,'Retail Sale Id 1553434',4998.40,0.00,0.00,8.80,360.80,'2022-01-19 11:25:37','',''),(2551011,'1','208','1038',479,'Retail Sale Id 1553454',3447.76,0.00,0.00,6.07,248.87,'2022-01-19 11:27:13','',''),(2551022,'1','208','1038',479,'Retail Sale Id 1553466',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 11:28:42','',''),(2551035,'1','208','1038',479,'Retail Sale Id 1553480',2851.36,0.00,0.00,5.02,205.82,'2022-01-19 11:30:22','',''),(2551060,'1','208','1038',479,'Retail Sale Id 1553506',1800.56,0.00,0.00,3.17,129.97,'2022-01-19 11:32:31','',''),(2551156,'1','208','1038',479,'Retail Sale Id 1553600',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 11:42:51','',''),(2551165,'1','208','1038',479,'Retail Sale Id 1553610',1999.36,0.00,0.00,3.52,144.32,'2022-01-19 11:43:45','',''),(2551206,'1','208','1038',479,'Retail Sale Id 1553668',3447.76,0.00,0.00,6.07,248.87,'2022-01-19 11:48:06','',''),(2551351,'1','208','1038',479,'Retail Sale Id 1553781',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 12:02:29','',''),(2551585,'1','208','1038',479,'Retail Sale Id 1554045',3447.76,0.00,0.00,6.07,248.87,'2022-01-19 12:30:43','',''),(2551601,'1','208','1038',479,'Retail Sale Id 1554055',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 12:32:19','',''),(2551608,'1','208','1038',479,'Retail Sale Id 1554064',999.68,0.00,0.00,1.76,72.16,'2022-01-19 12:33:08','',''),(2551664,'1','208','1038',479,'Retail Sale Id 1554124',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 12:39:31','',''),(2551722,'1','208','1038',479,'Retail Sale Id 1554186',2198.16,0.00,0.00,3.87,158.67,'2022-01-19 12:48:33','',''),(2551778,'1','208','1038',479,'Retail Sale Id 1554242',3447.76,0.00,0.00,6.07,248.87,'2022-01-19 12:56:16','',''),(2551877,'1','208','1038',479,'Retail Sale Id 1554317',1300.72,0.00,0.00,2.29,93.89,'2022-01-19 13:08:02','',''),(2551963,'1','208','1038',479,'Retail Sale Id 1554412',999.68,0.00,0.00,1.76,72.16,'2022-01-19 13:21:02','',''),(2552173,'1','208','1038',479,'Retail Sale Id 1554604',2152.72,0.00,0.00,3.79,155.39,'2022-01-19 13:46:01','',''),(2552246,'1','208','1038',479,'Retail Sale Id 1554677',10002.48,0.00,0.00,17.61,722.01,'2022-01-19 13:52:57','',''),(2552286,'1','208','1038',479,'Retail Sale Id 1554711',1704.00,0.00,0.00,3.00,123.00,'2022-01-19 13:56:33','',''),(2552409,'1','208','1038',479,'Retail Sale Id 1554836',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 14:10:58','',''),(2552469,'1','208','1038',479,'Retail Sale Id 1554902',2999.04,0.00,0.00,5.28,216.48,'2022-01-19 14:19:07','',''),(2552627,'1','208','1038',479,'Retail Sale Id 1555022',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 14:33:01','',''),(2553013,'1','208','1038',479,'Retail Sale Id 1555366',3447.76,0.00,0.00,6.07,248.87,'2022-01-19 15:09:46','',''),(2553038,'1','208','1038',479,'Retail Sale Id 1555393',2499.20,0.00,0.00,4.40,180.40,'2022-01-19 15:12:50','',''),(2553051,'1','208','1038',479,'Retail Sale Id 1555405',2999.04,0.00,0.00,5.28,216.48,'2022-01-19 15:14:21','',''),(2553112,'1','208','1038',479,'Retail Sale Id 1555467',5668.64,0.00,0.00,9.98,409.18,'2022-01-19 15:19:55','',''),(2553178,'1','208','1038',479,'Retail Sale Id 1555529',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 15:26:20','',''),(2553586,'1','208','1038',479,'Retail Sale Id 1555779',999.68,0.00,0.00,1.76,72.16,'2022-01-19 15:52:22','',''),(2553617,'1','208','1038',479,'Retail Sale Id 1555791',2999.04,0.00,0.00,5.28,216.48,'2022-01-19 15:53:34','',''),(2553629,'1','208','1038',479,'Retail Sale Id 1555801',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 15:54:33','',''),(2553664,'1','208','1038',479,'Retail Sale Id 1555828',1198.48,0.00,0.00,2.11,86.51,'2022-01-19 15:58:01','',''),(2553669,'1','208','1038',479,'Retail Sale Id 1555836',1499.52,0.00,0.00,2.64,108.24,'2022-01-19 15:58:55','',''),(2553794,'1','208','1038',479,'Retail Sale Id 1555952',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 16:12:05','',''),(2553868,'1','208','1038',479,'Retail Sale Id 1556019',1698.32,0.00,0.00,2.99,122.59,'2022-01-19 16:19:23','',''),(2554016,'1','208','1038',479,'Retail Sale Id 1556147',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 16:30:15','',''),(2554056,'1','208','1038',479,'Retail Sale Id 1556170',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 16:32:23','',''),(2554155,'1','208','1038',479,'Retail Sale Id 1556254',4998.40,0.00,0.00,8.80,360.80,'2022-01-19 16:39:17','',''),(2554386,'1','208','1038',479,'Retail Sale Id 1556509',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 16:57:22','',''),(2554387,'1','208','1038',479,'Retail Sale Id 1556509',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 16:57:22','',''),(2554442,'1','208','1038',479,'Retail Sale Id 1556562',602.08,0.00,0.00,1.06,43.46,'2022-01-19 17:00:39','',''),(2554477,'1','208','1038',479,'Retail Sale Id 1556602',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 17:03:11','',''),(2554578,'1','208','1038',479,'Retail Sale Id 1556713',1704.00,0.00,0.00,3.00,123.00,'2022-01-19 17:10:39','',''),(2554611,'1','208','1038',479,'Retail Sale Id 1556749',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 17:12:57','',''),(2554671,'1','208','1038',479,'Retail Sale Id 1556767',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 17:17:43','',''),(2554805,'1','208','1038',479,'Retail Sale Id 1556935',3447.76,0.00,0.00,6.07,248.87,'2022-01-19 17:27:25','',''),(2554912,'1','208','1038',479,'Retail Sale Id 1557045',1999.36,0.00,0.00,3.52,144.32,'2022-01-19 17:36:59','',''),(2555113,'1','208','1038',479,'Retail Sale Id 1557246',999.68,0.00,0.00,1.76,72.16,'2022-01-19 17:53:21','',''),(2555232,'1','208','1038',479,'Retail Sale Id 1557352',999.68,0.00,0.00,1.76,72.16,'2022-01-19 18:03:22','',''),(2555282,'1','208','1038',479,'Retail Sale Id 1557400',5498.24,0.00,0.00,9.68,396.88,'2022-01-19 18:09:41','',''),(2555307,'1','208','1038',479,'Retail Sale Id 1557427',198.80,0.00,0.00,0.35,14.35,'2022-01-19 18:12:24','',''),(2555312,'1','208','1038',479,'Retail Sale Id 1557434',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 18:13:26','',''),(2555373,'1','208','1038',479,'Retail Sale Id 1557483',1499.52,0.00,0.00,2.64,108.24,'2022-01-19 18:21:53','',''),(2555419,'1','208','1038',479,'Retail Sale Id 1557524',3447.76,0.00,0.00,6.07,248.87,'2022-01-19 18:28:48','',''),(2555464,'1','208','1038',479,'Retail Sale Id 1557569',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 18:35:29','',''),(2555519,'1','208','1038',479,'Retail Sale Id 1557618',1749.44,0.00,0.00,3.08,126.28,'2022-01-19 18:46:21','',''),(2555520,'1','208','1038',479,'Retail Sale Id 1557618',2851.36,0.00,0.00,5.02,205.82,'2022-01-19 18:46:21','',''),(2555554,'1','208','1038',479,'Retail Sale Id 1557655',7497.60,0.00,0.00,13.20,541.20,'2022-01-19 18:54:18','',''),(2555561,'1','208','1038',479,'Retail Sale Id 1557661',3498.88,0.00,0.00,6.16,252.56,'2022-01-19 18:55:29','',''),(2555584,'1','208','1038',479,'Retail Sale Id 1557685',4600.80,0.00,0.00,8.10,332.10,'2022-01-19 19:00:20','',''),(2555625,'1','208','1038',479,'Retail Sale Id 1557699',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 19:04:01','',''),(2555682,'1','208','1038',479,'Retail Sale Id 1557785',1800.56,0.00,0.00,3.17,129.97,'2022-01-19 19:23:43','',''),(2555730,'1','208','1038',479,'Retail Sale Id 1557821',1999.36,0.00,0.00,3.52,144.32,'2022-01-19 19:43:45','',''),(2555732,'1','208','1038',479,'Retail Sale Id 1557824',7100.00,0.00,0.00,12.50,512.50,'2022-01-19 19:46:29','',''),(2555845,'1','208','1038',479,'Retail Sale Id 1557837',1794.88,0.00,0.00,3.16,129.56,'2022-01-19 21:11:13','',''),(2556788,'1','208','1038',479,'Retail Sale Id 1558431',1999.36,0.00,0.00,3.52,144.32,'2022-01-20 08:33:16','',''),(2556800,'1','208','1038',479,'Retail Sale Id 1558443',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 08:34:27','',''),(2556809,'1','208','1038',479,'Retail Sale Id 1558452',1999.36,0.00,0.00,3.52,144.32,'2022-01-20 08:35:38','',''),(2556823,'1','208','1038',479,'Retail Sale Id 1558467',999.68,0.00,0.00,1.76,72.16,'2022-01-20 08:36:39','',''),(2556874,'1','208','1038',479,'Retail Sale Id 1558513',3408.00,0.00,0.00,6.00,246.00,'2022-01-20 08:42:16','',''),(2556932,'1','208','1038',479,'Retail Sale Id 1558545',1198.48,0.00,0.00,2.11,86.51,'2022-01-20 08:46:17','',''),(2556933,'1','208','1038',479,'Retail Sale Id 1558545',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 08:46:17','',''),(2557046,'1','208','1038',479,'Retail Sale Id 1558634',31149.12,0.00,0.00,54.84,2248.44,'2022-01-20 08:54:10','',''),(2557064,'1','208','1038',479,'Retail Sale Id 1558651',10508.00,0.00,0.00,18.50,758.50,'2022-01-20 08:55:29','',''),(2557160,'1','208','1038',479,'Retail Sale Id 1558724',3998.72,0.00,0.00,7.04,288.64,'2022-01-20 09:01:19','',''),(2557178,'1','208','1038',479,'Retail Sale Id 1558737',1198.48,0.00,0.00,2.11,86.51,'2022-01-20 09:02:27','',''),(2557179,'1','208','1038',479,'Retail Sale Id 1558737',1198.48,0.00,0.00,2.11,86.51,'2022-01-20 09:02:27','',''),(2557308,'1','208','1038',479,'Retail Sale Id 1558814',2300.40,0.00,0.00,4.05,166.05,'2022-01-20 09:09:18','',''),(2557371,'1','208','1038',479,'Retail Sale Id 1558865',2999.04,0.00,0.00,5.28,216.48,'2022-01-20 09:13:43','',''),(2557601,'1','208','1038',479,'Retail Sale Id 1559097',2999.04,0.00,0.00,5.28,216.48,'2022-01-20 09:35:28','',''),(2557770,'1','208','1038',479,'Retail Sale Id 1559285',3402.32,0.00,0.00,5.99,245.59,'2022-01-20 09:53:02','',''),(2557934,'1','208','1038',479,'Retail Sale Id 1559440',1999.36,0.00,0.00,3.52,144.32,'2022-01-20 10:07:43','',''),(2557997,'1','208','1038',479,'Retail Sale Id 1559490',1698.32,0.00,0.00,2.99,122.59,'2022-01-20 10:12:31','',''),(2558063,'1','208','1038',479,'Retail Sale Id 1559543',3402.32,0.00,0.00,5.99,245.59,'2022-01-20 10:18:03','',''),(2558082,'1','208','1038',479,'Retail Sale Id 1559555',999.68,0.00,0.00,1.76,72.16,'2022-01-20 10:18:48','',''),(2558087,'1','208','1038',479,'Retail Sale Id 1559559',499.84,0.00,0.00,0.88,36.08,'2022-01-20 10:19:41','',''),(2558197,'1','208','1038',479,'Retail Sale Id 1559633',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 10:25:42','',''),(2558212,'1','208','1038',479,'Retail Sale Id 1559644',3498.88,0.00,0.00,6.16,252.56,'2022-01-20 10:27:19','',''),(2558419,'1','208','1038',479,'Retail Sale Id 1559789',1698.32,0.00,0.00,2.99,122.59,'2022-01-20 10:37:26','',''),(2558466,'1','208','1038',479,'Retail Sale Id 1559819',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 10:40:27','',''),(2558579,'1','208','1038',479,'Retail Sale Id 1559933',3998.72,0.00,0.00,7.04,288.64,'2022-01-20 10:50:43','',''),(2558759,'1','208','1038',479,'Retail Sale Id 1560145',999.68,0.00,0.00,1.76,72.16,'2022-01-20 11:08:41','',''),(2558795,'1','208','1038',479,'Retail Sale Id 1560179',3998.72,0.00,0.00,7.04,288.64,'2022-01-20 11:12:29','',''),(2558920,'1','208','1038',479,'Retail Sale Id 1560319',1999.36,0.00,0.00,3.52,144.32,'2022-01-20 11:25:41','',''),(2558936,'1','208','1038',479,'Retail Sale Id 1560336',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 11:27:22','',''),(2558950,'1','208','1038',479,'Retail Sale Id 1560357',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 11:28:41','',''),(2559105,'1','208','1038',479,'Retail Sale Id 1560501',1749.44,0.00,0.00,3.08,126.28,'2022-01-20 11:43:27','',''),(2559106,'1','208','1038',479,'Retail Sale Id 1560501',1749.44,0.00,0.00,3.08,126.28,'2022-01-20 11:43:27','',''),(2559144,'1','208','1038',479,'Retail Sale Id 1560542',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 11:47:28','',''),(2559320,'1','208','1038',479,'Retail Sale Id 1560732',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 12:04:10','',''),(2559346,'1','208','1038',479,'Retail Sale Id 1560762',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 12:07:04','',''),(2559446,'1','208','1038',479,'Retail Sale Id 1560878',2840.00,0.00,0.00,5.00,205.00,'2022-01-20 12:19:37','',''),(2559447,'1','208','1038',479,'Retail Sale Id 1560878',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 12:19:37','',''),(2559448,'1','208','1038',479,'Retail Sale Id 1560878',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 12:19:37','',''),(2559863,'1','208','1038',479,'Retail Sale Id 1561353',3402.32,0.00,0.00,5.99,245.59,'2022-01-20 13:03:10','',''),(2559876,'1','208','1038',479,'Retail Sale Id 1561364',4998.40,0.00,0.00,8.80,360.80,'2022-01-20 13:04:31','',''),(2560012,'1','208','1038',479,'Retail Sale Id 1561510',1999.36,0.00,0.00,3.52,144.32,'2022-01-20 13:18:09','',''),(2560013,'1','208','1038',479,'Retail Sale Id 1561510',1999.36,0.00,0.00,3.52,144.32,'2022-01-20 13:18:09','',''),(2560231,'1','208','1038',479,'Retail Sale Id 1561745',499.84,0.00,0.00,0.88,36.08,'2022-01-20 13:42:09','',''),(2560244,'1','208','1038',479,'Retail Sale Id 1561757',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 13:43:23','',''),(2560294,'1','208','1038',479,'Retail Sale Id 1561801',1999.36,0.00,0.00,3.52,144.32,'2022-01-20 13:47:54','',''),(2560295,'1','208','1038',479,'Retail Sale Id 1561801',1999.36,0.00,0.00,3.52,144.32,'2022-01-20 13:47:54','',''),(2560400,'1','208','1038',479,'Retail Sale Id 1561898',3998.72,0.00,0.00,7.04,288.64,'2022-01-20 13:57:15','',''),(2560445,'1','208','1038',479,'Retail Sale Id 1561943',5998.08,0.00,0.00,10.56,432.96,'2022-01-20 14:01:11','',''),(2560541,'1','208','1038',479,'Retail Sale Id 1562013',2840.00,0.00,0.00,5.00,205.00,'2022-01-20 14:11:15','',''),(2560646,'1','208','1038',479,'Retail Sale Id 1562167',1136.00,0.00,0.00,2.00,82.00,'2022-01-20 14:23:11','',''),(2560647,'1','208','1038',479,'Retail Sale Id 1562167',5680.00,0.00,0.00,10.00,410.00,'2022-01-20 14:23:11','',''),(2560740,'1','208','1038',479,'Retail Sale Id 1562244',698.64,0.00,0.00,1.23,50.43,'2022-01-20 14:31:19','',''),(2560794,'1','208','1038',479,'Retail Sale Id 1562295',2999.04,0.00,0.00,5.28,216.48,'2022-01-20 14:36:47','',''),(2560917,'1','208','1038',479,'Retail Sale Id 1562411',3402.32,0.00,0.00,5.99,245.59,'2022-01-20 14:46:08','',''),(2561101,'1','208','1038',479,'Retail Sale Id 1562573',1749.44,0.00,0.00,3.08,126.28,'2022-01-20 15:00:11','',''),(2561111,'1','208','1038',479,'Retail Sale Id 1562582',2999.04,0.00,0.00,5.28,216.48,'2022-01-20 15:00:58','',''),(2561125,'1','208','1038',479,'Retail Sale Id 1562593',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 15:01:45','',''),(2561142,'1','208','1038',479,'Retail Sale Id 1562604',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 15:02:42','',''),(2561226,'1','208','1038',479,'Retail Sale Id 1562696',3498.88,0.00,0.00,6.16,252.56,'2022-01-20 15:10:11','',''),(2561546,'1','208','1038',479,'Retail Sale Id 1563131',2999.04,0.00,0.00,5.28,216.48,'2022-01-20 15:41:51','',''),(2561818,'1','208','1038',479,'Retail Sale Id 1563468',3498.88,0.00,0.00,6.16,252.56,'2022-01-20 16:08:31','',''),(2562558,'1','208','1038',479,'Retail Sale Id 1564053',28400.00,0.00,0.00,50.00,2050.00,'2022-01-20 16:53:44','',''),(2562671,'1','208','1038',479,'Retail Sale Id 1564218',28400.00,0.00,0.00,50.00,2050.00,'2022-01-20 17:02:29','',''),(2562684,'1','208','1038',479,'Retail Sale Id 1564233',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 17:03:27','',''),(2562887,'1','208','1038',479,'Retail Sale Id 1564451',1999.36,0.00,0.00,3.52,144.32,'2022-01-20 17:16:03','',''),(2563245,'1','208','1038',479,'Retail Sale Id 1564879',999.68,0.00,0.00,1.76,72.16,'2022-01-20 17:44:50','',''),(2563246,'1','208','1038',479,'Retail Sale Id 1564879',1499.52,0.00,0.00,2.64,108.24,'2022-01-20 17:44:50','',''),(2563271,'1','208','1038',479,'Retail Sale Id 1564912',1698.32,0.00,0.00,2.99,122.59,'2022-01-20 17:46:57','',''),(2563284,'1','208','1038',479,'Retail Sale Id 1564925',1999.36,0.00,0.00,3.52,144.32,'2022-01-20 17:47:59','',''),(2563331,'1','208','1038',479,'Retail Sale Id 1564986',1499.52,0.00,0.00,2.64,108.24,'2022-01-20 17:51:46','',''),(2563524,'1','208','1038',479,'Retail Sale Id 1565258',3408.00,0.00,0.00,6.00,246.00,'2022-01-20 18:05:55','',''),(2563553,'1','208','1038',479,'Retail Sale Id 1565295',4998.40,0.00,0.00,8.80,360.80,'2022-01-20 18:08:19','',''),(2563564,'1','208','1038',479,'Retail Sale Id 1565305',1988.00,0.00,0.00,3.50,143.50,'2022-01-20 18:09:07','',''),(2563624,'1','208','1038',479,'Retail Sale Id 1565358',999.68,0.00,0.00,1.76,72.16,'2022-01-20 18:14:12','',''),(2563640,'1','208','1038',479,'Retail Sale Id 1565375',2999.04,0.00,0.00,5.28,216.48,'2022-01-20 18:15:42','',''),(2563675,'1','208','1038',479,'Retail Sale Id 1565424',3408.00,0.00,0.00,6.00,246.00,'2022-01-20 18:18:54','',''),(2563676,'1','208','1038',479,'Retail Sale Id 1565424',3408.00,0.00,0.00,6.00,246.00,'2022-01-20 18:18:54','',''),(2563692,'1','208','1038',479,'Retail Sale Id 1565440',1698.32,0.00,0.00,2.99,122.59,'2022-01-20 18:20:46','',''),(2563777,'1','208','1038',479,'Retail Sale Id 1565525',1499.52,0.00,0.00,2.64,108.24,'2022-01-20 18:31:50','',''),(2563778,'1','208','1038',479,'Retail Sale Id 1565525',6497.92,0.00,0.00,11.44,469.04,'2022-01-20 18:31:50','',''),(2563843,'1','208','1038',479,'Retail Sale Id 1565601',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 18:46:52','',''),(2563868,'1','208','1038',479,'Retail Sale Id 1565721',3408.00,0.00,0.00,6.00,246.00,'2022-01-20 18:54:47','',''),(2563968,'1','208','1038',479,'Retail Sale Id 1565793',4998.40,0.00,0.00,8.80,360.80,'2022-01-20 19:15:51','',''),(2563982,'1','208','1038',479,'Retail Sale Id 1565799',7100.00,0.00,0.00,12.50,512.50,'2022-01-20 19:17:37','',''),(2564053,'1','208','1038',479,'Retail Sale Id 1565827',3402.32,0.00,0.00,5.99,245.59,'2022-01-20 19:35:56','',''),(2564081,'1','208','1038',479,'Retail Sale Id 1565857',2527.60,0.00,0.00,4.45,182.45,'2022-01-20 20:12:35','',''),(2564152,'1','208','1038',479,'Return of Retail Sale Id 1565793',0.00,4998.40,8.80,0.00,-360.80,'2022-01-20 20:17:03','',''),(2564165,'1','208','1038',479,'Retail Sale Id 1565864',25968.96,0.00,0.00,45.72,1874.52,'2022-01-20 20:25:38','',''),(2564182,'1','208','1038',479,'Return of Retail Sale Id 1565295',0.00,4998.40,8.80,0.00,-360.80,'2022-01-20 20:30:43','',''),(2564186,'1','208','1038',479,'Retail Sale Id 1565871',4998.40,0.00,0.00,8.80,360.80,'2022-01-20 20:40:31','',''),(2564790,'1','208','1038',479,'Retail Sale Id 1566102',1749.44,0.00,0.00,3.08,126.28,'2022-01-21 07:46:43','',''),(2564825,'1','208','1038',479,'Retail Sale Id 1566137',1902.80,0.00,0.00,3.35,137.35,'2022-01-21 07:51:53','',''),(2564826,'1','208','1038',479,'Retail Sale Id 1566137',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 07:51:53','',''),(2564840,'1','208','1038',479,'Retail Sale Id 1566153',7497.60,0.00,0.00,13.20,541.20,'2022-01-21 07:54:03','',''),(2564911,'1','208','1038',479,'Retail Sale Id 1566217',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 08:03:12','',''),(2564983,'1','208','1038',479,'Retail Sale Id 1566263',1749.44,0.00,0.00,3.08,126.28,'2022-01-21 08:08:47','',''),(2565030,'1','208','1038',479,'Retail Sale Id 1566304',1601.76,0.00,0.00,2.82,115.62,'2022-01-21 08:14:06','',''),(2565086,'1','208','1038',479,'Retail Sale Id 1566366',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 08:17:39','',''),(2565129,'1','208','1038',479,'Retail Sale Id 1566415',999.68,0.00,0.00,1.76,72.16,'2022-01-21 08:21:43','',''),(2565382,'1','208','1038',479,'Retail Sale Id 1566652',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 08:43:24','',''),(2565417,'1','208','1038',479,'Retail Sale Id 1566686',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 08:46:35','',''),(2565430,'1','208','1038',479,'Retail Sale Id 1566699',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 08:48:04','',''),(2565543,'1','208','1038',479,'Retail Sale Id 1566829',2999.04,0.00,0.00,5.28,216.48,'2022-01-21 08:59:13','',''),(2565596,'1','208','1038',479,'Retail Sale Id 1566868',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 09:03:23','',''),(2565597,'1','208','1038',479,'Retail Sale Id 1566868',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 09:03:23','',''),(2565654,'1','208','1038',479,'Retail Sale Id 1566931',3998.72,0.00,0.00,7.04,288.64,'2022-01-21 09:09:18','',''),(2565666,'1','208','1038',479,'Retail Sale Id 1566946',1499.52,0.00,0.00,2.64,108.24,'2022-01-21 09:10:49','',''),(2565726,'1','208','1038',479,'Retail Sale Id 1567014',2300.40,0.00,0.00,4.05,166.05,'2022-01-21 09:16:30','',''),(2565822,'1','208','1038',479,'Retail Sale Id 1567082',2402.64,0.00,0.00,4.23,173.43,'2022-01-21 09:22:57','',''),(2565833,'1','208','1038',479,'Retail Sale Id 1567098',2402.64,0.00,0.00,4.23,173.43,'2022-01-21 09:24:00','',''),(2565885,'1','208','1038',479,'Retail Sale Id 1567135',3402.32,0.00,0.00,5.99,245.59,'2022-01-21 09:27:35','',''),(2565886,'1','208','1038',479,'Retail Sale Id 1567135',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 09:27:35','',''),(2566291,'1','208','1038',479,'Retail Sale Id 1567475',1749.44,0.00,0.00,3.08,126.28,'2022-01-21 10:03:24','',''),(2566292,'1','208','1038',479,'Retail Sale Id 1567475',1749.44,0.00,0.00,3.08,126.28,'2022-01-21 10:03:24','',''),(2566293,'1','208','1038',479,'Retail Sale Id 1567475',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 10:03:24','',''),(2566386,'1','208','1038',479,'Retail Sale Id 1567560',1749.44,0.00,0.00,3.08,126.28,'2022-01-21 10:11:27','',''),(2566387,'1','208','1038',479,'Retail Sale Id 1567560',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 10:11:27','',''),(2566395,'1','208','1038',479,'Retail Sale Id 1567566',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 10:12:20','',''),(2566601,'1','208','1038',479,'Retail Sale Id 1567720',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 10:31:36','',''),(2566646,'1','208','1038',479,'Retail Sale Id 1567748',2999.04,0.00,0.00,5.28,216.48,'2022-01-21 10:35:16','',''),(2567021,'1','208','1038',479,'Retail Sale Id 1568075',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 11:10:37','',''),(2567044,'1','208','1038',479,'Retail Sale Id 1568096',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 11:13:31','',''),(2567100,'1','208','1038',479,'Retail Sale Id 1568149',1704.00,0.00,0.00,3.00,123.00,'2022-01-21 11:19:43','',''),(2567142,'1','208','1038',479,'Retail Sale Id 1568189',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 11:24:44','',''),(2567152,'1','208','1038',479,'Retail Sale Id 1568201',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 11:25:48','',''),(2567265,'1','208','1038',479,'Retail Sale Id 1568291',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 11:35:47','',''),(2567306,'1','208','1038',479,'Retail Sale Id 1568336',1499.52,0.00,0.00,2.64,108.24,'2022-01-21 11:39:29','',''),(2567488,'1','208','1038',479,'Retail Sale Id 1568460',1999.36,0.00,0.00,3.52,144.32,'2022-01-21 11:51:27','',''),(2567567,'1','208','1038',479,'Retail Sale Id 1568505',1999.36,0.00,0.00,3.52,144.32,'2022-01-21 11:56:57','',''),(2567583,'1','208','1038',479,'Retail Sale Id 1568523',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 11:58:17','',''),(2567652,'1','208','1038',479,'Retail Sale Id 1568585',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 12:05:19','',''),(2567737,'1','208','1038',479,'Retail Sale Id 1568654',3998.72,0.00,0.00,7.04,288.64,'2022-01-21 12:11:06','',''),(2567804,'1','208','1038',479,'Retail Sale Id 1568722',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 12:19:51','',''),(2567805,'1','208','1038',479,'Retail Sale Id 1568722',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 12:19:51','',''),(2567830,'1','208','1038',479,'Retail Sale Id 1568748',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 12:22:36','',''),(2567831,'1','208','1038',479,'Retail Sale Id 1568748',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 12:22:36','',''),(2567847,'1','208','1038',479,'Retail Sale Id 1568769',1420.00,0.00,0.00,2.50,102.50,'2022-01-21 12:24:33','',''),(2567848,'1','208','1038',479,'Retail Sale Id 1568769',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 12:24:33','',''),(2567996,'1','208','1038',479,'Retail Sale Id 1568911',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 12:40:12','',''),(2568012,'1','208','1038',479,'Retail Sale Id 1568928',1999.36,0.00,0.00,3.52,144.32,'2022-01-21 12:41:59','',''),(2568020,'1','208','1038',479,'Retail Sale Id 1568934',2999.04,0.00,0.00,5.28,216.48,'2022-01-21 12:42:38','',''),(2568259,'1','208','1038',479,'Retail Sale Id 1569162',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 13:08:02','',''),(2568346,'1','208','1038',479,'Retail Sale Id 1569242',1749.44,0.00,0.00,3.08,126.28,'2022-01-21 13:19:35','',''),(2568601,'1','208','1038',479,'Retail Sale Id 1569474',1499.52,0.00,0.00,2.64,108.24,'2022-01-21 13:53:20','',''),(2568618,'1','208','1038',479,'Retail Sale Id 1569488',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 13:54:34','',''),(2568631,'1','208','1038',479,'Retail Sale Id 1569494',999.68,0.00,0.00,1.76,72.16,'2022-01-21 13:55:38','',''),(2568639,'1','208','1038',479,'Retail Sale Id 1569503',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 13:56:51','',''),(2568644,'1','208','1038',479,'Retail Sale Id 1569513',2840.00,0.00,0.00,5.00,205.00,'2022-01-21 13:57:54','',''),(2568728,'1','208','1038',479,'Retail Sale Id 1569620',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 14:06:54','',''),(2568812,'1','208','1038',479,'Retail Sale Id 1569702',1499.52,0.00,0.00,2.64,108.24,'2022-01-21 14:16:46','',''),(2568824,'1','208','1038',479,'Retail Sale Id 1569715',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 14:17:47','',''),(2568849,'1','208','1038',479,'Retail Sale Id 1569744',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 14:21:45','',''),(2568964,'1','208','1038',479,'Retail Sale Id 1569858',1698.32,0.00,0.00,2.99,122.59,'2022-01-21 14:31:44','',''),(2568982,'1','208','1038',479,'Retail Sale Id 1569882',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 14:32:46','',''),(2569023,'1','208','1038',479,'Retail Sale Id 1569924',5702.72,0.00,0.00,10.04,411.64,'2022-01-21 14:36:41','',''),(2569089,'1','208','1038',479,'Retail Sale Id 1569994',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 14:43:40','',''),(2569115,'1','208','1038',479,'Retail Sale Id 1570021',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 14:46:14','',''),(2569254,'1','208','1038',479,'Retail Sale Id 1570164',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 14:59:28','',''),(2569315,'1','208','1038',479,'Retail Sale Id 1570215',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 15:05:45','',''),(2569574,'1','208','1038',479,'Retail Sale Id 1570479',6997.76,0.00,0.00,12.32,505.12,'2022-01-21 15:26:38','',''),(2569586,'1','208','1038',479,'Retail Sale Id 1570564',1647.20,0.00,0.00,2.90,118.90,'2022-01-21 15:27:49','',''),(2569596,'1','208','1038',479,'Retail Sale Id 1570591',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 15:28:54','',''),(2569670,'1','208','1038',479,'Retail Sale Id 1570652',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 15:33:53','',''),(2569818,'1','208','1038',479,'Retail Sale Id 1570788',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 15:46:19','',''),(2569913,'1','208','1038',479,'Retail Sale Id 1570884',8520.00,0.00,0.00,15.00,615.00,'2022-01-21 15:54:08','',''),(2569936,'1','208','1038',479,'Retail Sale Id 1570910',2999.04,0.00,0.00,5.28,216.48,'2022-01-21 15:55:47','',''),(2569961,'1','208','1038',479,'Retail Sale Id 1570926',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 15:57:26','',''),(2570123,'1','208','1038',479,'Retail Sale Id 1571092',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 16:11:43','',''),(2570331,'1','208','1038',479,'Retail Sale Id 1571263',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 16:25:05','',''),(2570413,'1','208','1038',479,'Retail Sale Id 1571340',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 16:31:45','',''),(2570513,'1','208','1038',479,'Retail Sale Id 1571419',2851.36,0.00,0.00,5.02,205.82,'2022-01-21 16:38:13','',''),(2570535,'1','208','1038',479,'Retail Sale Id 1571428',602.08,0.00,0.00,1.06,43.46,'2022-01-21 16:38:59','',''),(2570686,'1','208','1038',479,'Retail Sale Id 1571555',1749.44,0.00,0.00,3.08,126.28,'2022-01-21 16:47:41','',''),(2570688,'1','208','1038',479,'Retail Sale Id 1571555',1749.44,0.00,0.00,3.08,126.28,'2022-01-21 16:47:41','',''),(2570934,'1','208','1038',479,'Retail Sale Id 1571839',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 17:03:18','',''),(2571049,'1','208','1038',479,'Retail Sale Id 1571944',2999.04,0.00,0.00,5.28,216.48,'2022-01-21 17:11:10','',''),(2571132,'1','208','1038',479,'Retail Sale Id 1572035',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 17:16:48','',''),(2571155,'1','208','1038',479,'Retail Sale Id 1572056',1999.36,0.00,0.00,3.52,144.32,'2022-01-21 17:18:07','',''),(2571276,'1','208','1038',479,'Retail Sale Id 1572170',999.68,0.00,0.00,1.76,72.16,'2022-01-21 17:26:02','',''),(2571366,'1','208','1038',479,'Retail Sale Id 1572253',2499.20,0.00,0.00,4.40,180.40,'2022-01-21 17:31:59','',''),(2571435,'1','208','1038',479,'Retail Sale Id 1572312',3498.88,0.00,0.00,6.16,252.56,'2022-01-21 17:35:34','',''),(2571500,'1','208','1038',479,'Retail Sale Id 1572396',698.64,0.00,0.00,1.23,50.43,'2022-01-21 17:41:26','',''),(2571534,'1','208','1038',479,'Retail Sale Id 1572428',1749.44,0.00,0.00,3.08,126.28,'2022-01-21 17:43:31','',''),(2571919,'1','208','1038',479,'Retail Sale Id 1572824',1749.44,0.00,0.00,3.08,126.28,'2022-01-21 18:19:11','',''),(2571920,'1','208','1038',479,'Retail Sale Id 1572824',2851.36,0.00,0.00,5.02,205.82,'2022-01-21 18:19:11','',''),(2571975,'1','208','1038',479,'Retail Sale Id 1572882',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 18:25:24','',''),(2572049,'1','208','1038',479,'Retail Sale Id 1572956',7100.00,0.00,0.00,12.50,512.50,'2022-01-21 18:34:51','',''),(2572387,'1','208','1038',479,'Return of Retail Sale Id 1572035',0.00,7100.00,12.50,0.00,-512.50,'2022-01-21 19:32:23','',''),(2572402,'1','208','1038',479,'Return of Retail Sale Id 1572170',0.00,999.68,1.76,0.00,-72.16,'2022-01-21 19:37:57','',''),(2572411,'1','208','1038',479,'Retail Sale Id 1573305',11496.32,0.00,0.00,20.24,829.84,'2022-01-21 19:41:54','',''),(2572423,'1','208','1038',479,'Return of Retail Sale Id 1572882',0.00,7100.00,12.50,0.00,-512.50,'2022-01-21 19:46:33','',''),(2572424,'1','208','1038',479,'Return of Retail Sale Id 1571839',0.00,7100.00,12.50,0.00,-512.50,'2022-01-21 19:48:26','',''),(2572428,'1','208','1038',479,'Return of Retail Sale Id 1572056',0.00,1999.36,3.52,0.00,-144.32,'2022-01-21 19:50:21','',''),(2572519,'1','208','1038',479,'Retail Sale Id 1573329',113.60,0.00,0.00,0.20,8.20,'2022-01-21 19:57:37','',''),(2573303,'1','208','1038',479,'Retail Sale Id 1573769',6702.40,0.00,0.00,11.80,483.80,'2022-01-22 08:07:36','',''),(2573368,'1','208','1038',479,'Retail Sale Id 1573833',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 08:13:36','',''),(2573390,'1','208','1038',479,'Retail Sale Id 1573858',1698.32,0.00,0.00,2.99,122.59,'2022-01-22 08:15:22','',''),(2573391,'1','208','1038',479,'Retail Sale Id 1573858',3402.32,0.00,0.00,5.99,245.59,'2022-01-22 08:15:22','',''),(2573434,'1','208','1038',479,'Retail Sale Id 1573890',3498.88,0.00,0.00,6.16,252.56,'2022-01-22 08:20:41','',''),(2573465,'1','208','1038',479,'Retail Sale Id 1573907',5998.08,0.00,0.00,10.56,432.96,'2022-01-22 08:22:44','',''),(2573643,'1','208','1038',479,'Retail Sale Id 1574083',3408.00,0.00,0.00,6.00,246.00,'2022-01-22 08:42:33','',''),(2573644,'1','208','1038',479,'Retail Sale Id 1574083',3589.76,0.00,0.00,6.32,259.12,'2022-01-22 08:42:33','',''),(2573716,'1','208','1038',479,'Retail Sale Id 1574170',14200.00,0.00,0.00,25.00,1025.00,'2022-01-22 08:49:53','',''),(2573731,'1','208','1038',479,'Retail Sale Id 1574186',1698.32,0.00,0.00,2.99,122.59,'2022-01-22 08:52:02','',''),(2573741,'1','208','1038',479,'Retail Sale Id 1574207',2851.36,0.00,0.00,5.02,205.82,'2022-01-22 08:53:19','',''),(2573761,'1','208','1038',479,'Retail Sale Id 1574231',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 08:55:25','',''),(2573815,'1','208','1038',479,'Retail Sale Id 1574294',1198.48,0.00,0.00,2.11,86.51,'2022-01-22 09:01:46','',''),(2573850,'1','208','1038',479,'Retail Sale Id 1574327',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 09:05:18','',''),(2573920,'1','208','1038',479,'Retail Sale Id 1574389',2999.04,0.00,0.00,5.28,216.48,'2022-01-22 09:11:05','',''),(2573932,'1','208','1038',479,'Retail Sale Id 1574403',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 09:12:14','',''),(2574024,'1','208','1038',479,'Retail Sale Id 1574492',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 09:20:13','',''),(2574150,'1','208','1038',479,'Retail Sale Id 1574620',3408.00,0.00,0.00,6.00,246.00,'2022-01-22 09:32:27','',''),(2574205,'1','208','1038',479,'Retail Sale Id 1574671',2300.40,0.00,0.00,4.05,166.05,'2022-01-22 09:37:56','',''),(2574217,'1','208','1038',479,'Retail Sale Id 1574681',2999.04,0.00,0.00,5.28,216.48,'2022-01-22 09:39:00','',''),(2574285,'1','208','1038',479,'Retail Sale Id 1574725',1999.36,0.00,0.00,3.52,144.32,'2022-01-22 09:44:06','',''),(2574338,'1','208','1038',479,'Retail Sale Id 1574768',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 09:48:33','',''),(2574414,'1','208','1038',479,'Retail Sale Id 1574815',1999.36,0.00,0.00,3.52,144.32,'2022-01-22 09:52:44','',''),(2574717,'1','208','1038',479,'Retail Sale Id 1575078',3408.00,0.00,0.00,6.00,246.00,'2022-01-22 10:15:25','',''),(2574739,'1','208','1038',479,'Retail Sale Id 1575097',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 10:17:32','',''),(2574780,'1','208','1038',479,'Retail Sale Id 1575138',999.68,0.00,0.00,1.76,72.16,'2022-01-22 10:21:17','',''),(2574795,'1','208','1038',479,'Retail Sale Id 1575156',6997.76,0.00,0.00,12.32,505.12,'2022-01-22 10:22:44','',''),(2574807,'1','208','1038',479,'Retail Sale Id 1575173',15801.76,0.00,0.00,27.82,1140.62,'2022-01-22 10:23:57','',''),(2575140,'1','208','1038',479,'Retail Sale Id 1575494',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 10:50:31','',''),(2575239,'1','208','1038',479,'Retail Sale Id 1575714',3408.00,0.00,0.00,6.00,246.00,'2022-01-22 11:00:26','',''),(2575268,'1','208','1038',479,'Retail Sale Id 1575740',3402.32,0.00,0.00,5.99,245.59,'2022-01-22 11:02:31','',''),(2575294,'1','208','1038',479,'Retail Sale Id 1575768',1698.32,0.00,0.00,2.99,122.59,'2022-01-22 11:04:24','',''),(2575497,'1','208','1038',479,'Retail Sale Id 1575923',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 11:16:59','',''),(2575683,'1','208',NULL,479,'Reception corrector for bridging 131717',0.00,0.00,0.00,5000.00,0.00,'2022-01-22 11:31:38','',''),(2575684,'1','208','1038',479,'Received from bridging 131717',0.00,0.00,5000.00,0.00,0.00,'2022-01-22 11:31:38','',''),(2575735,'1','208','1038',479,'Retail Sale Id 1576171',2851.36,0.00,0.00,5.02,205.82,'2022-01-22 11:35:11','',''),(2575930,'1','208','1038',479,'Retail Sale Id 1576318',6997.76,0.00,0.00,12.32,505.12,'2022-01-22 11:46:23','',''),(2576016,'1','208','1038',479,'Retail Sale Id 1576395',1698.32,0.00,0.00,2.99,122.59,'2022-01-22 11:53:07','',''),(2576036,'1','208','1038',479,'Retail Sale Id 1576413',1698.32,0.00,0.00,2.99,122.59,'2022-01-22 11:55:08','',''),(2576055,'1','208','1038',479,'Retail Sale Id 1576435',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 11:56:34','',''),(2576074,'1','208','1038',479,'Retail Sale Id 1576460',5998.08,0.00,0.00,10.56,432.96,'2022-01-22 11:58:07','',''),(2576130,'1','208','1038',479,'Retail Sale Id 1576500',3697.68,0.00,0.00,6.51,266.91,'2022-01-22 12:01:18','',''),(2576646,'1','208','1038',479,'Retail Sale Id 1576976',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 12:37:41','',''),(2576675,'1','208','1038',479,'Retail Sale Id 1577008',3447.76,0.00,0.00,6.07,248.87,'2022-01-22 12:39:37','',''),(2576695,'1','208','1038',479,'Retail Sale Id 1577030',2152.72,0.00,0.00,3.79,155.39,'2022-01-22 12:41:04','',''),(2576712,'1','208','1038',479,'Retail Sale Id 1577045',2499.20,0.00,0.00,4.40,180.40,'2022-01-22 12:42:45','',''),(2576713,'1','208','1038',479,'Retail Sale Id 1577045',3408.00,0.00,0.00,6.00,246.00,'2022-01-22 12:42:45','',''),(2576825,'1','208','1038',479,'Retail Sale Id 1577138',1999.36,0.00,0.00,3.52,144.32,'2022-01-22 12:49:34','',''),(2576898,'1','208','1038',479,'Retail Sale Id 1577210',3447.76,0.00,0.00,6.07,248.87,'2022-01-22 12:55:29','',''),(2576914,'1','208','1038',479,'Retail Sale Id 1577287',10508.00,0.00,0.00,18.50,758.50,'2022-01-22 12:56:48','',''),(2576940,'1','208','1038',479,'Retail Sale Id 1577307',19107.52,0.00,0.00,33.64,1379.24,'2022-01-22 12:58:08','',''),(2576988,'1','208','1038',479,'Retail Sale Id 1577354',1420.00,0.00,0.00,2.50,102.50,'2022-01-22 13:01:49','',''),(2577012,'1','208','1038',479,'Retail Sale Id 1577376',1999.36,0.00,0.00,3.52,144.32,'2022-01-22 13:03:36','',''),(2577076,'1','208','1038',479,'Retail Sale Id 1577432',999.68,0.00,0.00,1.76,72.16,'2022-01-22 13:09:24','',''),(2577131,'1','208','1038',479,'Retail Sale Id 1577480',3498.88,0.00,0.00,6.16,252.56,'2022-01-22 13:14:29','',''),(2577146,'1','208','1038',479,'Retail Sale Id 1577497',6248.00,0.00,0.00,11.00,451.00,'2022-01-22 13:16:31','',''),(2577197,'1','208','1038',479,'Retail Sale Id 1577545',1999.36,0.00,0.00,3.52,144.32,'2022-01-22 13:22:38','',''),(2577263,'1','208','1038',479,'Retail Sale Id 1577593',3998.72,0.00,0.00,7.04,288.64,'2022-01-22 13:27:58','',''),(2577274,'1','208','1038',479,'Retail Sale Id 1577607',2999.04,0.00,0.00,5.28,216.48,'2022-01-22 13:29:03','',''),(2577380,'1','208','1038',479,'Retail Sale Id 1577699',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 13:38:44','',''),(2577423,'1','208','1038',479,'Retail Sale Id 1577738',4998.40,0.00,0.00,8.80,360.80,'2022-01-22 13:42:57','',''),(2577522,'1','208','1038',479,'Retail Sale Id 1577826',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 13:52:32','',''),(2577550,'1','208','1038',479,'Retail Sale Id 1577857',3498.88,0.00,0.00,6.16,252.56,'2022-01-22 13:56:18','',''),(2577578,'1','208','1038',479,'Retail Sale Id 1577888',1704.00,0.00,0.00,3.00,123.00,'2022-01-22 13:59:10','',''),(2577598,'1','208','1038',479,'Retail Sale Id 1577909',2499.20,0.00,0.00,4.40,180.40,'2022-01-22 14:00:34','',''),(2577613,'1','208','1038',479,'Retail Sale Id 1577925',999.68,0.00,0.00,1.76,72.16,'2022-01-22 14:01:39','',''),(2577624,'1','208','1038',479,'Retail Sale Id 1577935',1749.44,0.00,0.00,3.08,126.28,'2022-01-22 14:02:43','',''),(2577844,'1','208','1038',479,'Retail Sale Id 1578127',3408.00,0.00,0.00,6.00,246.00,'2022-01-22 14:16:38','',''),(2578315,'1','208','1038',479,'Retail Sale Id 1578554',6816.00,0.00,0.00,12.00,492.00,'2022-01-22 15:00:06','',''),(2578316,'1','208','1038',479,'Retail Sale Id 1578554',27832.00,0.00,0.00,49.00,2009.00,'2022-01-22 15:00:06','',''),(2578513,'1','208','1038',479,'Retail Sale Id 1578681',28400.00,0.00,0.00,50.00,2050.00,'2022-01-22 15:11:06','',''),(2578583,'1','208','1038',479,'Retail Sale Id 1578756',1704.00,0.00,0.00,3.00,123.00,'2022-01-22 15:17:53','',''),(2578596,'1','208','1038',479,'Retail Sale Id 1578766',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 15:19:42','',''),(2578918,'1','208','1038',479,'Retail Sale Id 1579018',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 15:44:43','',''),(2578919,'1','208','1038',479,'Retail Sale Id 1579018',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 15:44:43','',''),(2578939,'1','208','1038',479,'Retail Sale Id 1579049',1601.76,0.00,0.00,2.82,115.62,'2022-01-22 15:46:54','',''),(2578970,'1','208','1038',479,'Retail Sale Id 1579079',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 15:49:46','',''),(2579309,'1','208','1038',479,'Retail Sale Id 1579435',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 16:20:59','',''),(2579334,'1','208','1038',479,'Retail Sale Id 1579456',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 16:22:34','',''),(2579367,'1','208','1038',479,'Retail Sale Id 1579477',1198.48,0.00,0.00,2.11,86.51,'2022-01-22 16:24:09','',''),(2579426,'1','208','1038',479,'Retail Sale Id 1579536',3408.00,0.00,0.00,6.00,246.00,'2022-01-22 16:30:20','',''),(2579445,'1','208','1038',479,'Retail Sale Id 1579547',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 16:31:53','',''),(2579477,'1','208','1038',479,'Retail Sale Id 1579582',999.68,0.00,0.00,1.76,72.16,'2022-01-22 16:35:36','',''),(2579501,'1','208','1038',479,'Retail Sale Id 1579607',2999.04,0.00,0.00,5.28,216.48,'2022-01-22 16:37:48','',''),(2579512,'1','208','1038',479,'Retail Sale Id 1579618',1999.36,0.00,0.00,3.52,144.32,'2022-01-22 16:38:47','',''),(2579581,'1','208','1038',479,'Retail Sale Id 1579727',3402.32,0.00,0.00,5.99,245.59,'2022-01-22 16:45:28','',''),(2579582,'1','208','1038',479,'Retail Sale Id 1579727',3402.32,0.00,0.00,5.99,245.59,'2022-01-22 16:45:28','',''),(2579733,'1','208','1038',479,'Retail Sale Id 1579831',1698.32,0.00,0.00,2.99,122.59,'2022-01-22 16:53:50','',''),(2579908,'1','208','1038',479,'Retail Sale Id 1580008',3408.00,0.00,0.00,6.00,246.00,'2022-01-22 17:06:38','',''),(2580067,'1','208','1038',479,'Retail Sale Id 1580101',1499.52,0.00,0.00,2.64,108.24,'2022-01-22 17:13:31','',''),(2580083,'1','208','1038',479,'Retail Sale Id 1580115',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 17:14:34','',''),(2580115,'1','208','1038',479,'Retail Sale Id 1580140',6997.76,0.00,0.00,12.32,505.12,'2022-01-22 17:16:53','',''),(2580331,'1','208','1038',479,'Retail Sale Id 1580355',1999.36,0.00,0.00,3.52,144.32,'2022-01-22 17:35:47','',''),(2580357,'1','208','1038',479,'Retail Sale Id 1580380',1704.00,0.00,0.00,3.00,123.00,'2022-01-22 17:37:24','',''),(2580375,'1','208','1038',479,'Retail Sale Id 1580400',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 17:38:29','',''),(2580405,'1','208','1038',479,'Retail Sale Id 1580433',3498.88,0.00,0.00,6.16,252.56,'2022-01-22 17:40:47','',''),(2580447,'1','208','1038',479,'Retail Sale Id 1580474',1698.32,0.00,0.00,2.99,122.59,'2022-01-22 17:43:56','',''),(2580644,'1','208','1038',479,'Retail Sale Id 1580673',3408.00,0.00,0.00,6.00,246.00,'2022-01-22 17:58:45','',''),(2580680,'1','208','1038',479,'Retail Sale Id 1580688',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 18:00:07','',''),(2580712,'1','208','1038',479,'Retail Sale Id 1580898',1198.48,0.00,0.00,2.11,86.51,'2022-01-22 18:04:49','',''),(2580726,'1','208','1038',479,'Retail Sale Id 1580922',7100.00,0.00,0.00,12.50,512.50,'2022-01-22 18:06:13','',''),(2580770,'1','208','1038',479,'Retail Sale Id 1580983',3498.88,0.00,0.00,6.16,252.56,'2022-01-22 18:12:59','',''),(2580776,'1','208','1038',479,'Retail Sale Id 1580988',999.68,0.00,0.00,1.76,72.16,'2022-01-22 18:13:56','',''),(2580851,'1','208','1038',479,'Retail Sale Id 1581058',3498.88,0.00,0.00,6.16,252.56,'2022-01-22 18:22:59','',''),(2581150,'1','208','1038',479,'Retail Sale Id 1581447',738.40,0.00,0.00,1.30,53.30,'2022-01-22 19:09:19','',''),(2582260,'1','208','1038',479,'Retail Sale Id 1582134',5702.72,0.00,0.00,10.04,411.64,'2022-01-23 08:14:43','',''),(2582283,'1','208','1038',479,'Retail Sale Id 1582148',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 08:16:34','',''),(2582320,'1','208','1038',479,'Retail Sale Id 1582158',2902.48,0.00,0.00,5.11,209.51,'2022-01-23 08:18:44','',''),(2582354,'1','208','1038',479,'Retail Sale Id 1582186',698.64,0.00,0.00,1.23,50.43,'2022-01-23 08:22:43','',''),(2582419,'1','208','1038',479,'Retail Sale Id 1582236',999.68,0.00,0.00,1.76,72.16,'2022-01-23 08:29:05','',''),(2582456,'1','208','1038',479,'Retail Sale Id 1582272',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 08:33:17','',''),(2582737,'1','208','1038',479,'Retail Sale Id 1582453',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 08:53:58','',''),(2582753,'1','208','1038',479,'Retail Sale Id 1582468',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 08:55:14','',''),(2582775,'1','208','1038',479,'Retail Sale Id 1582485',999.68,0.00,0.00,1.76,72.16,'2022-01-23 08:57:09','',''),(2582845,'1','208','1038',479,'Retail Sale Id 1582545',5998.08,0.00,0.00,10.56,432.96,'2022-01-23 09:03:22','',''),(2582865,'1','208','1038',479,'Retail Sale Id 1582560',999.68,0.00,0.00,1.76,72.16,'2022-01-23 09:04:29','',''),(2583073,'1','208','1038',479,'Retail Sale Id 1582733',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 09:20:48','',''),(2583096,'1','208','1038',479,'Retail Sale Id 1582750',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 09:22:37','',''),(2583459,'1','208','1038',479,'Retail Sale Id 1583142',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 09:56:05','',''),(2583563,'1','208','1038',479,'Retail Sale Id 1583245',1999.36,0.00,0.00,3.52,144.32,'2022-01-23 10:06:52','',''),(2583709,'1','208','1038',479,'Retail Sale Id 1583399',1499.52,0.00,0.00,2.64,108.24,'2022-01-23 10:19:43','',''),(2583710,'1','208','1038',479,'Retail Sale Id 1583399',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 10:19:43','',''),(2583804,'1','208','1038',479,'Retail Sale Id 1583493',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 10:27:38','',''),(2583836,'1','208','1038',479,'Retail Sale Id 1583524',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 10:30:33','',''),(2583845,'1','208','1038',479,'Retail Sale Id 1583533',1999.36,0.00,0.00,3.52,144.32,'2022-01-23 10:31:38','',''),(2583853,'1','208','1038',479,'Retail Sale Id 1583540',999.68,0.00,0.00,1.76,72.16,'2022-01-23 10:32:29','',''),(2583862,'1','208','1038',479,'Retail Sale Id 1583549',2851.36,0.00,0.00,5.02,205.82,'2022-01-23 10:33:47','',''),(2584031,'1','208','1038',479,'Retail Sale Id 1583674',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 10:46:54','',''),(2584054,'1','208','1038',479,'Retail Sale Id 1583695',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 10:48:58','',''),(2584055,'1','208','1038',479,'Retail Sale Id 1583695',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 10:48:58','',''),(2584056,'1','208','1038',479,'Retail Sale Id 1583695',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 10:48:58','',''),(2584239,'1','208','1038',479,'Retail Sale Id 1583873',1999.36,0.00,0.00,3.52,144.32,'2022-01-23 11:04:26','',''),(2584353,'1','208','1038',479,'Retail Sale Id 1583992',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 11:14:35','',''),(2584410,'1','208','1038',479,'Retail Sale Id 1584045',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 11:19:53','',''),(2584453,'1','208','1038',479,'Retail Sale Id 1584097',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 11:24:17','',''),(2584454,'1','208','1038',479,'Retail Sale Id 1584097',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 11:24:17','',''),(2584477,'1','208','1038',479,'Retail Sale Id 1584120',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 11:26:51','',''),(2584493,'1','208','1038',479,'Retail Sale Id 1584135',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 11:27:57','',''),(2584534,'1','208','1038',479,'Retail Sale Id 1584177',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 11:33:02','',''),(2584582,'1','208','1038',479,'Retail Sale Id 1584230',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 11:38:04','',''),(2584635,'1','208','1038',479,'Retail Sale Id 1584292',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 11:43:19','',''),(2584650,'1','208','1038',479,'Retail Sale Id 1584309',4998.40,0.00,0.00,8.80,360.80,'2022-01-23 11:45:24','',''),(2584717,'1','208','1038',479,'Retail Sale Id 1584373',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 11:51:51','',''),(2584734,'1','208','1038',479,'Retail Sale Id 1584383',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 11:53:01','',''),(2584811,'1','208','1038',479,'Retail Sale Id 1584480',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 12:00:36','',''),(2584825,'1','208','1038',479,'Retail Sale Id 1584498',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 12:02:21','',''),(2584826,'1','208','1038',479,'Retail Sale Id 1584498',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 12:02:21','',''),(2584864,'1','208','1038',479,'Retail Sale Id 1584536',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 12:05:40','',''),(2584937,'1','208','1038',479,'Retail Sale Id 1584621',3447.76,0.00,0.00,6.07,248.87,'2022-01-23 12:15:25','',''),(2584938,'1','208','1038',479,'Retail Sale Id 1584621',4850.72,0.00,0.00,8.54,350.14,'2022-01-23 12:15:25','',''),(2584958,'1','208','1038',479,'Retail Sale Id 1584645',2300.40,0.00,0.00,4.05,166.05,'2022-01-23 12:17:29','',''),(2584959,'1','208','1038',479,'Retail Sale Id 1584645',2851.36,0.00,0.00,5.02,205.82,'2022-01-23 12:17:29','',''),(2584979,'1','208','1038',479,'Retail Sale Id 1584670',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 12:19:57','',''),(2585097,'1','208','1038',479,'Retail Sale Id 1584784',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 12:30:56','',''),(2585148,'1','208','1038',479,'Retail Sale Id 1584843',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 12:36:03','',''),(2585163,'1','208','1038',479,'Retail Sale Id 1584861',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 12:37:41','',''),(2585232,'1','208','1038',479,'Retail Sale Id 1584921',2300.40,0.00,0.00,4.05,166.05,'2022-01-23 12:42:52','',''),(2585233,'1','208','1038',479,'Retail Sale Id 1584921',2851.36,0.00,0.00,5.02,205.82,'2022-01-23 12:42:52','',''),(2585305,'1','208','1038',479,'Retail Sale Id 1584986',3408.00,0.00,0.00,6.00,246.00,'2022-01-23 12:47:53','',''),(2585306,'1','208','1038',479,'Retail Sale Id 1584986',3408.00,0.00,0.00,6.00,246.00,'2022-01-23 12:47:53','',''),(2585339,'1','208','1038',479,'Retail Sale Id 1585020',499.84,0.00,0.00,0.88,36.08,'2022-01-23 12:50:21','',''),(2585418,'1','208','1038',479,'Retail Sale Id 1585102',1198.48,0.00,0.00,2.11,86.51,'2022-01-23 12:56:48','',''),(2585521,'1','208','1038',479,'Retail Sale Id 1585209',698.64,0.00,0.00,1.23,50.43,'2022-01-23 13:07:24','',''),(2585573,'1','208','1038',479,'Retail Sale Id 1585264',6997.76,0.00,0.00,12.32,505.12,'2022-01-23 13:11:49','',''),(2585712,'1','208','1038',479,'Retail Sale Id 1585405',1499.52,0.00,0.00,2.64,108.24,'2022-01-23 13:22:58','',''),(2585777,'1','208','1038',479,'Retail Sale Id 1585466',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 13:27:00','',''),(2585778,'1','208','1038',479,'Retail Sale Id 1585466',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 13:27:00','',''),(2585795,'1','208','1038',479,'Retail Sale Id 1585481',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 13:28:15','',''),(2585899,'1','208','1038',479,'Retail Sale Id 1585588',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 13:37:14','',''),(2585972,'1','208','1038',479,'Retail Sale Id 1585659',897.44,0.00,0.00,1.58,64.78,'2022-01-23 13:42:49','',''),(2586037,'1','208','1038',479,'Retail Sale Id 1585715',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 13:46:34','',''),(2586058,'1','208','1038',479,'Retail Sale Id 1585734',2851.36,0.00,0.00,5.02,205.82,'2022-01-23 13:47:47','',''),(2586134,'1','208','1038',479,'Retail Sale Id 1585803',1499.52,0.00,0.00,2.64,108.24,'2022-01-23 13:53:12','',''),(2586154,'1','208','1038',479,'Retail Sale Id 1585814',1499.52,0.00,0.00,2.64,108.24,'2022-01-23 13:54:01','',''),(2586430,'1','208','1038',479,'Retail Sale Id 1585998',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 14:12:17','',''),(2586431,'1','208','1038',479,'Retail Sale Id 1585998',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 14:12:17','',''),(2586436,'1','208','1038',479,'Retail Sale Id 1586002',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 14:12:47','',''),(2586442,'1','208','1038',479,'Retail Sale Id 1586008',1499.52,0.00,0.00,2.64,108.24,'2022-01-23 14:13:29','',''),(2586595,'1','208','1038',479,'Retail Sale Id 1586184',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 14:28:32','',''),(2586606,'1','208','1038',479,'Retail Sale Id 1586199',2999.04,0.00,0.00,5.28,216.48,'2022-01-23 14:29:44','',''),(2586615,'1','208','1038',479,'Retail Sale Id 1586245',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 14:30:47','',''),(2586677,'1','208','1038',479,'Retail Sale Id 1586320',602.08,0.00,0.00,1.06,43.46,'2022-01-23 14:36:11','',''),(2586678,'1','208','1038',479,'Retail Sale Id 1586320',602.08,0.00,0.00,1.06,43.46,'2022-01-23 14:36:11','',''),(2586763,'1','208','1038',479,'Retail Sale Id 1586387',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 14:42:22','',''),(2586764,'1','208','1038',479,'Retail Sale Id 1586387',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 14:42:22','',''),(2587002,'1','208','1038',479,'Retail Sale Id 1586534',3998.72,0.00,0.00,7.04,288.64,'2022-01-23 14:56:38','',''),(2587024,'1','208','1038',479,'Retail Sale Id 1586561',2300.40,0.00,0.00,4.05,166.05,'2022-01-23 14:59:02','',''),(2587302,'1','208','1038',479,'Retail Sale Id 1586767',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 15:19:31','',''),(2587303,'1','208','1038',479,'Retail Sale Id 1586767',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 15:19:31','',''),(2587322,'1','208','1038',479,'Retail Sale Id 1586786',3447.76,0.00,0.00,6.07,248.87,'2022-01-23 15:21:46','',''),(2587351,'1','208','1038',479,'Retail Sale Id 1586820',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 15:24:49','',''),(2587395,'1','208','1038',479,'Retail Sale Id 1586856',1999.36,0.00,0.00,3.52,144.32,'2022-01-23 15:29:16','',''),(2587434,'1','208','1038',479,'Retail Sale Id 1586889',1999.36,0.00,0.00,3.52,144.32,'2022-01-23 15:33:49','',''),(2587446,'1','208','1038',479,'Retail Sale Id 1586899',1198.48,0.00,0.00,2.11,86.51,'2022-01-23 15:35:00','',''),(2587472,'1','208','1038',479,'Retail Sale Id 1586944',1999.36,0.00,0.00,3.52,144.32,'2022-01-23 15:39:41','',''),(2587620,'1','208','1038',479,'Retail Sale Id 1587074',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 15:52:18','',''),(2587775,'1','208','1038',479,'Retail Sale Id 1587150',4498.56,0.00,0.00,7.92,324.72,'2022-01-23 16:02:02','',''),(2587905,'1','208','1038',479,'Retail Sale Id 1587264',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 16:22:07','',''),(2587916,'1','208','1038',479,'Retail Sale Id 1587272',2851.36,0.00,0.00,5.02,205.82,'2022-01-23 16:23:00','',''),(2588089,'1','208','1038',479,'Retail Sale Id 1587383',2999.04,0.00,0.00,5.28,216.48,'2022-01-23 16:37:28','',''),(2588102,'1','208','1038',479,'Retail Sale Id 1587393',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 16:38:34','',''),(2588149,'1','208','1038',479,'Retail Sale Id 1587429',5680.00,0.00,0.00,10.00,410.00,'2022-01-23 16:43:14','',''),(2588178,'1','208','1038',479,'Retail Sale Id 1587456',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 16:45:35','',''),(2588179,'1','208','1038',479,'Retail Sale Id 1587456',2999.04,0.00,0.00,5.28,216.48,'2022-01-23 16:45:35','',''),(2588217,'1','208','1038',479,'Retail Sale Id 1587485',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 16:50:19','',''),(2588239,'1','208','1038',479,'Retail Sale Id 1587511',1698.32,0.00,0.00,2.99,122.59,'2022-01-23 16:52:50','',''),(2588277,'1','208','1038',479,'Retail Sale Id 1587544',1999.36,0.00,0.00,3.52,144.32,'2022-01-23 16:56:53','',''),(2588314,'1','208','1038',479,'Retail Sale Id 1587576',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 17:00:53','',''),(2588326,'1','208','1038',479,'Retail Sale Id 1587585',3498.88,0.00,0.00,6.16,252.56,'2022-01-23 17:02:06','',''),(2588334,'1','208','1038',479,'Retail Sale Id 1587594',1999.36,0.00,0.00,3.52,144.32,'2022-01-23 17:03:21','',''),(2588340,'1','208','1038',479,'Retail Sale Id 1587602',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 17:04:13','',''),(2588384,'1','208','1038',479,'Retail Sale Id 1587647',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 17:09:14','',''),(2588385,'1','208','1038',479,'Retail Sale Id 1587647',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 17:09:14','',''),(2588529,'1','208','1038',479,'Retail Sale Id 1587787',2851.36,0.00,0.00,5.02,205.82,'2022-01-23 17:19:54','',''),(2588631,'1','208','1038',479,'Retail Sale Id 1587856',1499.52,0.00,0.00,2.64,108.24,'2022-01-23 17:25:48','',''),(2588705,'1','208','1038',479,'Retail Sale Id 1587888',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 17:28:30','',''),(2588706,'1','208','1038',479,'Retail Sale Id 1587888',1749.44,0.00,0.00,3.08,126.28,'2022-01-23 17:28:30','',''),(2588785,'1','208','1038',479,'Retail Sale Id 1587942',3408.00,0.00,0.00,6.00,246.00,'2022-01-23 17:34:49','',''),(2588793,'1','208','1038',479,'Retail Sale Id 1587952',7100.00,0.00,0.00,12.50,512.50,'2022-01-23 17:35:42','',''),(2588804,'1','208','1038',479,'Retail Sale Id 1587964',5998.08,0.00,0.00,10.56,432.96,'2022-01-23 17:36:43','',''),(2590327,'1','208','1038',479,'Retail Sale Id 1589009',3004.72,0.00,0.00,5.29,216.89,'2022-01-24 08:06:56','',''),(2590331,'1','208','1038',479,'Retail Sale Id 1589015',47030.40,0.00,0.00,82.80,3394.80,'2022-01-24 08:07:41','',''),(2590340,'1','208','1038',479,'Retail Sale Id 1589021',9604.88,0.00,0.00,16.91,693.31,'2022-01-24 08:08:23','',''),(2590582,'1','208','1038',479,'Retail Sale Id 1589195',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 08:33:12','',''),(2590620,'1','208','1038',479,'Retail Sale Id 1589227',2300.40,0.00,0.00,4.05,166.05,'2022-01-24 08:35:52','',''),(2590726,'1','208','1038',479,'Retail Sale Id 1589348',3402.32,0.00,0.00,5.99,245.59,'2022-01-24 08:52:01','',''),(2590741,'1','208','1038',479,'Retail Sale Id 1589368',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 08:53:52','',''),(2590785,'1','208','1038',479,'Retail Sale Id 1589418',6997.76,0.00,0.00,12.32,505.12,'2022-01-24 09:00:12','',''),(2590800,'1','208','1038',479,'Retail Sale Id 1589429',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 09:01:40','',''),(2590821,'1','208','1038',479,'Retail Sale Id 1589443',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 09:04:54','',''),(2590881,'1','208','1038',479,'Retail Sale Id 1589517',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 09:14:11','',''),(2590898,'1','208','1038',479,'Retail Sale Id 1589538',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 09:16:47','',''),(2591034,'1','208','1038',479,'Retail Sale Id 1589627',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 09:30:16','',''),(2591089,'1','208','1038',479,'Retail Sale Id 1589631',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 09:31:12','',''),(2591110,'1','208','1038',479,'Retail Sale Id 1589639',2499.20,0.00,0.00,4.40,180.40,'2022-01-24 09:32:12','',''),(2591120,'1','208','1038',479,'Retail Sale Id 1589649',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 09:33:45','',''),(2591225,'1','208','1038',479,'Retail Sale Id 1589681',3550.00,0.00,0.00,6.25,256.25,'2022-01-24 09:39:30','',''),(2591277,'1','208','1038',479,'Retail Sale Id 1589720',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 09:45:05','',''),(2591324,'1','208','1038',479,'Retail Sale Id 1589756',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 09:49:12','',''),(2591335,'1','208','1038',479,'Retail Sale Id 1589772',3408.00,0.00,0.00,6.00,246.00,'2022-01-24 09:50:56','',''),(2591412,'1','208','1038',479,'Retail Sale Id 1589842',999.68,0.00,0.00,1.76,72.16,'2022-01-24 09:59:51','',''),(2591455,'1','208','1038',479,'Retail Sale Id 1589876',999.68,0.00,0.00,1.76,72.16,'2022-01-24 10:03:06','',''),(2591468,'1','208','1038',479,'Retail Sale Id 1589890',3799.92,0.00,0.00,6.69,274.29,'2022-01-24 10:03:57','',''),(2591520,'1','208','1038',479,'Retail Sale Id 1589942',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 10:13:25','',''),(2591624,'1','208','1038',479,'Retail Sale Id 1590039',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 10:26:57','',''),(2591638,'1','208','1038',479,'Retail Sale Id 1590064',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 10:28:31','',''),(2591721,'1','208','1038',479,'Retail Sale Id 1590162',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 10:40:26','',''),(2591757,'1','208','1038',479,'Retail Sale Id 1590185',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 10:42:59','',''),(2591781,'1','208','1038',479,'Retail Sale Id 1590202',1749.44,0.00,0.00,3.08,126.28,'2022-01-24 10:44:45','',''),(2591782,'1','208','1038',479,'Retail Sale Id 1590202',1749.44,0.00,0.00,3.08,126.28,'2022-01-24 10:44:45','',''),(2591792,'1','208','1038',479,'Retail Sale Id 1590212',499.84,0.00,0.00,0.88,36.08,'2022-01-24 10:45:54','',''),(2591819,'1','208','1038',479,'Retail Sale Id 1590236',999.68,0.00,0.00,1.76,72.16,'2022-01-24 10:48:39','',''),(2591834,'1','208','1038',479,'Retail Sale Id 1590251',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 10:50:12','',''),(2591855,'1','208','1038',479,'Retail Sale Id 1590269',1698.32,0.00,0.00,2.99,122.59,'2022-01-24 10:52:05','',''),(2591868,'1','208','1038',479,'Retail Sale Id 1590282',999.68,0.00,0.00,1.76,72.16,'2022-01-24 10:53:37','',''),(2591869,'1','208','1038',479,'Retail Sale Id 1590282',3402.32,0.00,0.00,5.99,245.59,'2022-01-24 10:53:37','',''),(2591918,'1','208','1038',479,'Retail Sale Id 1590330',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 10:59:28','',''),(2591958,'1','208','1038',479,'Retail Sale Id 1590364',1709.68,0.00,0.00,3.01,123.41,'2022-01-24 11:05:05','',''),(2592029,'1','208','1038',479,'Retail Sale Id 1590422',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 11:12:21','',''),(2592101,'1','208','1038',479,'Retail Sale Id 1590443',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 11:15:29','',''),(2592115,'1','208','1038',479,'Retail Sale Id 1590464',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 11:17:03','',''),(2592218,'1','208','1038',479,'Retail Sale Id 1590552',3408.00,0.00,0.00,6.00,246.00,'2022-01-24 11:27:18','',''),(2592272,'1','208','1038',479,'Retail Sale Id 1590597',3498.88,0.00,0.00,6.16,252.56,'2022-01-24 11:32:26','',''),(2592303,'1','208','1038',479,'Retail Sale Id 1590629',5498.24,0.00,0.00,9.68,396.88,'2022-01-24 11:36:01','',''),(2592323,'1','208','1038',479,'Retail Sale Id 1590653',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 11:37:56','',''),(2592546,'1','208','1038',479,'Retail Sale Id 1590871',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 12:02:04','',''),(2592575,'1','208','1038',479,'Retail Sale Id 1590893',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 12:06:22','',''),(2592657,'1','208','1038',479,'Retail Sale Id 1590977',1704.00,0.00,0.00,3.00,123.00,'2022-01-24 12:16:29','',''),(2592670,'1','208','1038',479,'Retail Sale Id 1590992',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 12:17:55','',''),(2592709,'1','208','1038',479,'Retail Sale Id 1591029',5998.08,0.00,0.00,10.56,432.96,'2022-01-24 12:22:44','',''),(2592783,'1','208','1038',479,'Retail Sale Id 1591086',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 12:31:04','',''),(2592888,'1','208','1038',479,'Retail Sale Id 1591186',9088.00,0.00,0.00,16.00,656.00,'2022-01-24 12:44:51','',''),(2593005,'1','208','1038',479,'Retail Sale Id 1591296',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 12:59:55','',''),(2593087,'1','208','1038',479,'Retail Sale Id 1591313',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 13:05:24','',''),(2593131,'1','208','1038',479,'Retail Sale Id 1591387',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 13:10:41','',''),(2593156,'1','208','1038',479,'Retail Sale Id 1591410',3498.88,0.00,0.00,6.16,252.56,'2022-01-24 13:13:50','',''),(2593218,'1','208','1038',479,'Retail Sale Id 1591481',1198.48,0.00,0.00,2.11,86.51,'2022-01-24 13:21:09','',''),(2593370,'1','208','1038',479,'Retail Sale Id 1591617',5998.08,0.00,0.00,10.56,432.96,'2022-01-24 13:39:33','',''),(2593477,'1','208','1038',479,'Retail Sale Id 1591706',1698.32,0.00,0.00,2.99,122.59,'2022-01-24 13:52:33','',''),(2593715,'1','208','1038',479,'Retail Sale Id 1591967',698.64,0.00,0.00,1.23,50.43,'2022-01-24 14:18:37','',''),(2593727,'1','208','1038',479,'Retail Sale Id 1591977',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 14:20:29','',''),(2593728,'1','208','1038',479,'Retail Sale Id 1591977',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 14:20:29','',''),(2593892,'1','208','1038',479,'Retail Sale Id 1592155',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 14:38:26','',''),(2593976,'1','208','1038',479,'Retail Sale Id 1592227',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 14:45:40','',''),(2594005,'1','208','1038',479,'Retail Sale Id 1592253',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 14:48:52','',''),(2594101,'1','208','1038',479,'Retail Sale Id 1592297',3408.00,0.00,0.00,6.00,246.00,'2022-01-24 14:55:20','',''),(2594127,'1','208','1038',479,'Retail Sale Id 1592306',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 14:56:44','',''),(2594353,'1','208','1038',479,'Retail Sale Id 1592474',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 15:14:55','',''),(2594764,'1','208','1038',479,'Retail Sale Id 1592839',1698.32,0.00,0.00,2.99,122.59,'2022-01-24 15:49:03','',''),(2595011,'1','208','1038',479,'Retail Sale Id 1593122',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 16:16:30','',''),(2595059,'1','208','1038',479,'Retail Sale Id 1593166',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 16:21:23','',''),(2595079,'1','208','1038',479,'Retail Sale Id 1593181',3498.88,0.00,0.00,6.16,252.56,'2022-01-24 16:22:33','',''),(2595089,'1','208','1038',479,'Retail Sale Id 1593197',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 16:24:05','',''),(2595101,'1','208','1038',479,'Retail Sale Id 1593211',3998.72,0.00,0.00,7.04,288.64,'2022-01-24 16:25:14','',''),(2595177,'1','208','1038',479,'Retail Sale Id 1593363',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 16:34:52','',''),(2595192,'1','208','1038',479,'Retail Sale Id 1593397',1499.52,0.00,0.00,2.64,108.24,'2022-01-24 16:36:29','',''),(2595213,'1','208','1038',479,'Retail Sale Id 1593433',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 16:39:00','',''),(2595271,'1','208','1038',479,'Retail Sale Id 1593581',2851.36,0.00,0.00,5.02,205.82,'2022-01-24 16:49:52','',''),(2595286,'1','208','1038',479,'Retail Sale Id 1593637',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 16:52:14','',''),(2595293,'1','208','1038',479,'Retail Sale Id 1593670',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 16:53:56','',''),(2595301,'1','208','1038',479,'Retail Sale Id 1593693',1499.52,0.00,0.00,2.64,108.24,'2022-01-24 16:55:25','',''),(2595330,'1','208','1038',479,'Retail Sale Id 1593740',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 16:59:52','',''),(2595342,'1','208','1038',479,'Retail Sale Id 1593784',999.68,0.00,0.00,1.76,72.16,'2022-01-24 17:01:10','',''),(2595365,'1','208','1038',479,'Retail Sale Id 1593850',1499.52,0.00,0.00,2.64,108.24,'2022-01-24 17:05:33','',''),(2595379,'1','208','1038',479,'Retail Sale Id 1593866',999.68,0.00,0.00,1.76,72.16,'2022-01-24 17:06:59','',''),(2595388,'1','208','1038',479,'Retail Sale Id 1593878',5498.24,0.00,0.00,9.68,396.88,'2022-01-24 17:08:09','',''),(2595398,'1','208','1038',479,'Retail Sale Id 1593894',602.08,0.00,0.00,1.06,43.46,'2022-01-24 17:09:10','',''),(2595461,'1','208','1038',479,'Retail Sale Id 1593953',3408.00,0.00,0.00,6.00,246.00,'2022-01-24 17:15:06','',''),(2595685,'1','208','1038',479,'Retail Sale Id 1594176',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 17:33:44','',''),(2595759,'1','208','1038',479,'Retail Sale Id 1594222',1499.52,0.00,0.00,2.64,108.24,'2022-01-24 17:38:21','',''),(2595769,'1','208','1038',479,'Retail Sale Id 1594234',6997.76,0.00,0.00,12.32,505.12,'2022-01-24 17:39:32','',''),(2595778,'1','208','1038',479,'Retail Sale Id 1594242',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 17:40:32','',''),(2595915,'1','208','1038',479,'Retail Sale Id 1594383',3402.32,0.00,0.00,5.99,245.59,'2022-01-24 17:52:58','',''),(2596042,'1','208','1038',479,'Retail Sale Id 1594538',3408.00,0.00,0.00,6.00,246.00,'2022-01-24 18:03:12','',''),(2596043,'1','208','1038',479,'Retail Sale Id 1594538',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 18:03:12','',''),(2596067,'1','208','1038',479,'Retail Sale Id 1594584',3408.00,0.00,0.00,6.00,246.00,'2022-01-24 18:04:15','',''),(2596167,'1','208','1038',479,'Retail Sale Id 1594669',4998.40,0.00,0.00,8.80,360.80,'2022-01-24 18:16:08','',''),(2596185,'1','208','1038',479,'Retail Sale Id 1594686',1698.32,0.00,0.00,2.99,122.59,'2022-01-24 18:18:48','',''),(2596196,'1','208','1038',479,'Retail Sale Id 1594703',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 18:20:56','',''),(2596225,'1','208','1038',479,'Retail Sale Id 1594767',3408.00,0.00,0.00,6.00,246.00,'2022-01-24 18:24:50','',''),(2596238,'1','208','1038',479,'Retail Sale Id 1594784',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 18:26:03','',''),(2596245,'1','208','1038',479,'Retail Sale Id 1594790',3408.00,0.00,0.00,6.00,246.00,'2022-01-24 18:26:58','',''),(2596253,'1','208','1038',479,'Retail Sale Id 1594798',3408.00,0.00,0.00,6.00,246.00,'2022-01-24 18:28:15','',''),(2596274,'1','208','1038',479,'Retail Sale Id 1594822',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 18:32:26','',''),(2596278,'1','208','1038',479,'Retail Sale Id 1594826',2499.20,0.00,0.00,4.40,180.40,'2022-01-24 18:33:10','',''),(2596374,'1','208','1038',479,'Retail Sale Id 1594866',999.68,0.00,0.00,1.76,72.16,'2022-01-24 18:43:28','',''),(2596420,'1','208','1038',479,'Retail Sale Id 1594892',1704.00,0.00,0.00,3.00,123.00,'2022-01-24 18:49:32','',''),(2596527,'1','208','1038',479,'Retail Sale Id 1594941',14200.00,0.00,0.00,25.00,1025.00,'2022-01-24 19:04:38','',''),(2596535,'1','208','1038',479,'Retail Sale Id 1594949',2999.04,0.00,0.00,5.28,216.48,'2022-01-24 19:06:15','',''),(2596545,'1','208','1038',479,'Retail Sale Id 1594973',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 19:12:10','',''),(2596546,'1','208','1038',479,'Retail Sale Id 1594973',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 19:12:10','',''),(2596570,'1','208','1038',479,'Retail Sale Id 1595019',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 19:17:22','',''),(2596604,'1','208','1038',479,'Retail Sale Id 1595039',3998.72,0.00,0.00,7.04,288.64,'2022-01-24 19:24:40','',''),(2596613,'1','208','1038',479,'Retail Sale Id 1595046',1999.36,0.00,0.00,3.52,144.32,'2022-01-24 19:26:12','',''),(2596619,'1','208','1038',479,'Retail Sale Id 1595052',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 19:27:22','',''),(2596626,'1','208','1038',479,'Retail Sale Id 1595059',2300.40,0.00,0.00,4.05,166.05,'2022-01-24 19:28:52','',''),(2596633,'1','208','1038',479,'Retail Sale Id 1595064',7100.00,0.00,0.00,12.50,512.50,'2022-01-24 19:33:08','',''),(2596749,'1','208','1038',479,'Return of Retail Sale Id 1595052',0.00,7100.00,12.50,0.00,-512.50,'2022-01-24 20:49:25','',''),(2596750,'1','208','1038',479,'Return of Retail Sale Id 1594941',0.00,14200.00,25.00,0.00,-1025.00,'2022-01-24 20:50:20','',''),(2596752,'1','208','1038',479,'Return of Retail Sale Id 1594784',0.00,7100.00,12.50,0.00,-512.50,'2022-01-24 20:51:34','',''),(2596753,'1','208','1038',479,'Return of Retail Sale Id 1594703',0.00,7100.00,12.50,0.00,-512.50,'2022-01-24 20:52:38','',''),(2596754,'1','208','1038',479,'Retail Sale Id 1595114',0.00,0.00,0.00,0.00,0.00,'2022-01-24 21:00:15','',''),(2596755,'1','208','1038',479,'Retail Sale Id 1595114',11.36,0.00,0.00,0.02,0.82,'2022-01-24 21:00:15','',''),(2596756,'1','208','1038',479,'Retail Sale Id 1595114',3873.76,0.00,0.00,6.82,279.62,'2022-01-24 21:00:15','',''),(2596757,'1','208','1038',479,'Retail Sale Id 1595114',48677.60,0.00,0.00,85.70,3513.70,'2022-01-24 21:00:15','',''),(2596775,'1','208','1038',479,'Return of Retail Sale Id 1595114',0.00,0.00,0.00,0.00,0.00,'2022-01-24 21:12:31','',''),(2596776,'1','208','1038',479,'Return of Retail Sale Id 1595114',0.00,11.36,0.02,0.00,-0.82,'2022-01-24 21:12:31','',''),(2596777,'1','208','1038',479,'Return of Retail Sale Id 1595114',0.00,3873.76,6.82,0.00,-279.62,'2022-01-24 21:12:31','',''),(2596778,'1','208','1038',479,'Return of Retail Sale Id 1595114',0.00,48677.60,85.70,0.00,-3513.70,'2022-01-24 21:12:31','',''),(2596792,'1','208','1038',479,'Retail Sale Id 1595116',3873.76,0.00,0.00,6.82,279.62,'2022-01-24 21:16:35','',''),(2596793,'1','208','1038',479,'Retail Sale Id 1595117',48677.60,0.00,0.00,85.70,3513.70,'2022-01-24 21:17:23','',''),(2597412,'1','208','1038',479,'Retail Sale Id 1595506',4998.40,0.00,0.00,8.80,360.80,'2022-01-25 08:04:36','',''),(2597460,'1','208','1038',479,'Retail Sale Id 1595560',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 08:10:49','',''),(2597523,'1','208','1038',479,'Retail Sale Id 1595597',999.68,0.00,0.00,1.76,72.16,'2022-01-25 08:14:57','',''),(2597560,'1','208','1038',479,'Retail Sale Id 1595631',2999.04,0.00,0.00,5.28,216.48,'2022-01-25 08:19:05','',''),(2597653,'1','208','1038',479,'Retail Sale Id 1595714',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 08:26:52','',''),(2597778,'1','208','1038',479,'Retail Sale Id 1595811',2999.04,0.00,0.00,5.28,216.48,'2022-01-25 08:36:09','',''),(2598124,'1','208','1038',479,'Retail Sale Id 1596190',1704.00,0.00,0.00,3.00,123.00,'2022-01-25 09:09:29','',''),(2598160,'1','208','1038',479,'Retail Sale Id 1596235',1698.32,0.00,0.00,2.99,122.59,'2022-01-25 09:12:04','',''),(2598376,'1','208','1038',479,'Retail Sale Id 1596428',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 09:29:02','',''),(2598453,'1','208','1038',479,'Retail Sale Id 1596501',1499.52,0.00,0.00,2.64,108.24,'2022-01-25 09:36:06','',''),(2598617,'1','208','1038',479,'Retail Sale Id 1596681',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 09:51:22','',''),(2598662,'1','208','1038',479,'Retail Sale Id 1596698',13898.96,0.00,0.00,24.47,1003.27,'2022-01-25 09:53:26','',''),(2598741,'1','208','1038',479,'Retail Sale Id 1596767',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 10:00:34','',''),(2598761,'1','208','1038',479,'Retail Sale Id 1596784',1499.52,0.00,0.00,2.64,108.24,'2022-01-25 10:02:08','',''),(2598780,'1','208','1038',479,'Retail Sale Id 1596801',2851.36,0.00,0.00,5.02,205.82,'2022-01-25 10:04:05','',''),(2598881,'1','208','1038',479,'Retail Sale Id 1596900',1709.68,0.00,0.00,3.01,123.41,'2022-01-25 10:15:35','',''),(2598950,'1','208','1038',479,'Retail Sale Id 1596974',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 10:23:17','',''),(2598960,'1','208','1038',479,'Retail Sale Id 1596986',1999.36,0.00,0.00,3.52,144.32,'2022-01-25 10:24:23','',''),(2599198,'1','208','1038',479,'Retail Sale Id 1597209',999.68,0.00,0.00,1.76,72.16,'2022-01-25 10:47:52','',''),(2599229,'1','208','1038',479,'Retail Sale Id 1597242',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 10:50:30','',''),(2599232,'1','208','1038',479,'Retail Sale Id 1597264',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 10:51:10','',''),(2599252,'1','208','1038',479,'Retail Sale Id 1597283',2851.36,0.00,0.00,5.02,205.82,'2022-01-25 10:52:28','',''),(2599473,'1','208','1038',479,'Retail Sale Id 1597474',4998.40,0.00,0.00,8.80,360.80,'2022-01-25 11:10:58','',''),(2599565,'1','208','1038',479,'Retail Sale Id 1597561',499.84,0.00,0.00,0.88,36.08,'2022-01-25 11:19:59','',''),(2599582,'1','208','1038',479,'Retail Sale Id 1597577',1999.36,0.00,0.00,3.52,144.32,'2022-01-25 11:22:00','',''),(2599958,'1','208','1038',479,'Retail Sale Id 1597891',5702.72,0.00,0.00,10.04,411.64,'2022-01-25 11:52:38','',''),(2599968,'1','208','1038',479,'Retail Sale Id 1597904',2999.04,0.00,0.00,5.28,216.48,'2022-01-25 11:53:52','',''),(2600028,'1','208','1038',479,'Retail Sale Id 1597970',1999.36,0.00,0.00,3.52,144.32,'2022-01-25 12:00:49','',''),(2600089,'1','208','1038',479,'Retail Sale Id 1598030',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 12:06:08','',''),(2600100,'1','208','1038',479,'Retail Sale Id 1598049',6997.76,0.00,0.00,12.32,505.12,'2022-01-25 12:07:41','',''),(2600113,'1','208','1038',479,'Retail Sale Id 1598067',1198.48,0.00,0.00,2.11,86.51,'2022-01-25 12:08:52','',''),(2600128,'1','208','1038',479,'Retail Sale Id 1598083',1749.44,0.00,0.00,3.08,126.28,'2022-01-25 12:10:28','',''),(2600175,'1','208','1038',479,'Retail Sale Id 1598132',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 12:17:45','',''),(2600239,'1','208','1038',479,'Retail Sale Id 1598203',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 12:26:28','',''),(2600286,'1','208','1038',479,'Retail Sale Id 1598258',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 12:31:21','',''),(2600314,'1','208','1038',479,'Retail Sale Id 1598292',2840.00,0.00,0.00,5.00,205.00,'2022-01-25 12:34:33','',''),(2600358,'1','208','1038',479,'Retail Sale Id 1598341',1749.44,0.00,0.00,3.08,126.28,'2022-01-25 12:41:09','',''),(2600359,'1','208','1038',479,'Retail Sale Id 1598341',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 12:41:09','',''),(2600379,'1','208','1038',479,'Retail Sale Id 1598362',2999.04,0.00,0.00,5.28,216.48,'2022-01-25 12:43:16','',''),(2600388,'1','208','1038',479,'Retail Sale Id 1598375',2999.04,0.00,0.00,5.28,216.48,'2022-01-25 12:44:31','',''),(2600481,'1','208','1038',479,'Retail Sale Id 1598479',999.68,0.00,0.00,1.76,72.16,'2022-01-25 12:52:37','',''),(2600670,'1','208','1038',479,'Retail Sale Id 1598673',1749.44,0.00,0.00,3.08,126.28,'2022-01-25 13:13:11','',''),(2600976,'1','208','1038',479,'Retail Sale Id 1598920',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 13:40:35','',''),(2601179,'1','208','1038',479,'Retail Sale Id 1599119',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 14:04:46','',''),(2601190,'1','208','1038',479,'Retail Sale Id 1599131',999.68,0.00,0.00,1.76,72.16,'2022-01-25 14:06:01','',''),(2601201,'1','208','1038',479,'Retail Sale Id 1599143',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 14:07:03','',''),(2601241,'1','208','1038',479,'Retail Sale Id 1599182',3197.84,0.00,0.00,5.63,230.83,'2022-01-25 14:11:56','',''),(2601246,'1','208','1038',479,'Retail Sale Id 1599189',2999.04,0.00,0.00,5.28,216.48,'2022-01-25 14:12:47','',''),(2601329,'1','208','1038',479,'Retail Sale Id 1599273',602.08,0.00,0.00,1.06,43.46,'2022-01-25 14:22:26','',''),(2601477,'1','208','1038',479,'Retail Sale Id 1599427',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 14:37:57','',''),(2601553,'1','208','1038',479,'Retail Sale Id 1599557',1749.44,0.00,0.00,3.08,126.28,'2022-01-25 14:44:49','',''),(2601579,'1','208','1038',479,'Retail Sale Id 1599596',602.08,0.00,0.00,1.06,43.46,'2022-01-25 14:47:07','',''),(2601598,'1','208','1038',479,'Retail Sale Id 1599636',999.68,0.00,0.00,1.76,72.16,'2022-01-25 14:48:18','',''),(2601610,'1','208','1038',479,'Retail Sale Id 1599645',698.64,0.00,0.00,1.23,50.43,'2022-01-25 14:49:10','',''),(2601626,'1','208','1038',479,'Retail Sale Id 1599659',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 14:50:39','',''),(2601627,'1','208','1038',479,'Retail Sale Id 1599659',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 14:50:39','',''),(2601710,'1','208','1038',479,'Retail Sale Id 1599729',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 14:57:03','',''),(2601753,'1','208','1038',479,'Retail Sale Id 1599784',1749.44,0.00,0.00,3.08,126.28,'2022-01-25 15:02:02','',''),(2601754,'1','208','1038',479,'Retail Sale Id 1599784',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 15:02:02','',''),(2601805,'1','208','1038',479,'Retail Sale Id 1599850',1749.44,0.00,0.00,3.08,126.28,'2022-01-25 15:07:30','',''),(2601886,'1','208','1038',479,'Retail Sale Id 1599917',1499.52,0.00,0.00,2.64,108.24,'2022-01-25 15:15:41','',''),(2602023,'1','208','1038',479,'Retail Sale Id 1599992',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 15:24:07','',''),(2602081,'1','208','1038',479,'Retail Sale Id 1600049',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 15:29:59','',''),(2602099,'1','208','1038',479,'Retail Sale Id 1600066',1198.48,0.00,0.00,2.11,86.51,'2022-01-25 15:31:06','',''),(2602258,'1','208','1038',479,'Retail Sale Id 1600164',5702.72,0.00,0.00,10.04,411.64,'2022-01-25 15:40:59','',''),(2602318,'1','208','1038',479,'Retail Sale Id 1600210',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 15:44:42','',''),(2602335,'1','208','1038',479,'Retail Sale Id 1600225',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 15:45:45','',''),(2602387,'1','208','1038',479,'Retail Sale Id 1600243',5702.72,0.00,0.00,10.04,411.64,'2022-01-25 15:47:20','',''),(2602523,'1','208','1038',479,'Retail Sale Id 1600337',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 15:55:46','',''),(2602539,'1','208','1038',479,'Retail Sale Id 1600355',1749.44,0.00,0.00,3.08,126.28,'2022-01-25 15:56:49','',''),(2602564,'1','208','1038',479,'Retail Sale Id 1600406',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 15:59:38','',''),(2602720,'1','208','1038',479,'Retail Sale Id 1600579',999.68,0.00,0.00,1.76,72.16,'2022-01-25 16:13:27','',''),(2602925,'1','208','1038',479,'Retail Sale Id 1600733',4498.56,0.00,0.00,7.92,324.72,'2022-01-25 16:28:19','',''),(2602970,'1','208','1038',479,'Retail Sale Id 1600777',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 16:31:30','',''),(2603012,'1','208','1038',479,'Retail Sale Id 1600831',5702.72,0.00,0.00,10.04,411.64,'2022-01-25 16:35:05','',''),(2603518,'1','208','1038',479,'Retail Sale Id 1601277',2999.04,0.00,0.00,5.28,216.48,'2022-01-25 17:06:43','',''),(2603586,'1','208','1038',479,'Retail Sale Id 1601354',16449.28,0.00,0.00,28.96,1187.36,'2022-01-25 17:12:03','',''),(2603673,'1','208','1038',479,'Retail Sale Id 1601451',2851.36,0.00,0.00,5.02,205.82,'2022-01-25 17:19:50','',''),(2603715,'1','208','1038',479,'Retail Sale Id 1601512',1800.56,0.00,0.00,3.17,129.97,'2022-01-25 17:23:57','',''),(2603768,'1','208','1038',479,'Retail Sale Id 1601582',1198.48,0.00,0.00,2.11,86.51,'2022-01-25 17:29:30','',''),(2603788,'1','208','1038',479,'Retail Sale Id 1601605',1198.48,0.00,0.00,2.11,86.51,'2022-01-25 17:31:00','',''),(2603838,'1','208','1038',479,'Retail Sale Id 1601651',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 17:34:17','',''),(2603858,'1','208','1038',479,'Retail Sale Id 1601674',1698.32,0.00,0.00,2.99,122.59,'2022-01-25 17:35:43','',''),(2603999,'1','208','1038',479,'Retail Sale Id 1601820',1800.56,0.00,0.00,3.17,129.97,'2022-01-25 17:44:56','',''),(2604058,'1','208','1038',479,'Retail Sale Id 1601883',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 17:49:31','',''),(2604089,'1','208','1038',479,'Retail Sale Id 1601910',2999.04,0.00,0.00,5.28,216.48,'2022-01-25 17:52:04','',''),(2604099,'1','208','1038',479,'Retail Sale Id 1601924',3498.88,0.00,0.00,6.16,252.56,'2022-01-25 17:52:42','',''),(2604170,'1','208','1038',479,'Retail Sale Id 1601982',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 17:57:26','',''),(2604260,'1','208','1038',479,'Retail Sale Id 1602065',6997.76,0.00,0.00,12.32,505.12,'2022-01-25 18:05:01','',''),(2604282,'1','208','1038',479,'Retail Sale Id 1602088',7100.00,0.00,0.00,12.50,512.50,'2022-01-25 18:07:03','',''),(2604289,'1','208','1038',479,'Retail Sale Id 1602096',2499.20,0.00,0.00,4.40,180.40,'2022-01-25 18:07:31','',''),(2604829,'1','208','1038',479,'Retail Sale Id 1602630',1749.44,0.00,0.00,3.08,126.28,'2022-01-25 19:12:12','',''),(2605460,'1','208','1038',479,'Retail Sale Id 1602916',1704.00,0.00,0.00,3.00,123.00,'2022-01-25 23:12:38','',''),(2605461,'1','208','1038',479,'Retail Sale Id 1602917',5083.60,0.00,0.00,8.95,366.95,'2022-01-25 23:15:33','',''),(2605478,'1','208','1038',479,'Retail Sale Id 1602918',46008.00,0.00,0.00,81.00,3321.00,'2022-01-25 23:23:35','',''),(2605525,'1','208','1038',479,'Return of Retail Sale Id 1601651',0.00,3498.88,6.16,0.00,-252.56,'2022-01-25 23:34:17','',''),(2605526,'1','208','1038',479,'Retail Sale Id 1602919',170.40,0.00,0.00,0.30,12.30,'2022-01-25 23:46:04','',''),(2605542,'1','208','1038',479,'Retail Sale Id 1602920',90.88,0.00,0.00,0.16,6.56,'2022-01-25 23:51:29','',''),(2606641,'1','208','1038',479,'Return of Retail Sale Id 1598203',0.00,3498.88,6.16,0.00,-252.56,'2022-01-26 08:56:31','',''),(2606681,'1','208','1038',479,'Retail Sale Id 1603873',6248.00,0.00,0.00,11.00,451.00,'2022-01-26 09:01:15','',''),(2606714,'1','208','1038',479,'Retail Sale Id 1603903',482.80,0.00,0.00,0.85,34.85,'2022-01-26 09:03:53','',''),(2606784,'1','208','1038',479,'Retail Sale Id 1603932',5.68,0.00,0.00,0.01,0.41,'2022-01-26 09:07:53','',''),(2606806,'1','208','1038',479,'Retail Sale Id 1603960',119.28,0.00,0.00,0.21,8.61,'2022-01-26 09:10:18','',''),(2607154,'1','208','1038',479,'Retail Sale Id 1604316',1709.68,0.00,0.00,3.01,123.41,'2022-01-26 09:41:48','',''),(2607181,'1','208','1038',479,'Retail Sale Id 1604341',1999.36,0.00,0.00,3.52,144.32,'2022-01-26 09:44:55','',''),(2607194,'1','208','1038',479,'Retail Sale Id 1604357',1999.36,0.00,0.00,3.52,144.32,'2022-01-26 09:46:06','',''),(2607209,'1','208','1038',479,'Retail Sale Id 1604371',2499.20,0.00,0.00,4.40,180.40,'2022-01-26 09:47:21','',''),(2607337,'1','208','1038',479,'Retail Sale Id 1604475',35670.40,0.00,0.00,62.80,2574.80,'2022-01-26 09:58:52','',''),(2607390,'1','208','1038',479,'Retail Sale Id 1604509',6145.76,0.00,0.00,10.82,443.62,'2022-01-26 10:03:00','',''),(2607396,'1','208','1038',479,'Retail Sale Id 1604515',1999.36,0.00,0.00,3.52,144.32,'2022-01-26 10:03:46','',''),(2607413,'1','208','1038',479,'Retail Sale Id 1604535',32256.72,0.00,0.00,56.79,2328.39,'2022-01-26 10:05:46','',''),(2607478,'1','208','1038',479,'Retail Sale Id 1604621',3413.68,0.00,0.00,6.01,246.41,'2022-01-26 10:13:11','',''),(2607498,'1','208','1038',479,'Retail Sale Id 1604653',5680.00,0.00,0.00,10.00,410.00,'2022-01-26 10:15:21','',''),(2607575,'1','208','1038',479,'Retail Sale Id 1604706',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 10:21:45','',''),(2607686,'1','208','1038',479,'Retail Sale Id 1604795',999.68,0.00,0.00,1.76,72.16,'2022-01-26 10:31:34','',''),(2607725,'1','208','1038',479,'Retail Sale Id 1604812',3998.72,0.00,0.00,7.04,288.64,'2022-01-26 10:33:47','',''),(2607934,'1','208','1038',479,'Retail Sale Id 1605000',2499.20,0.00,0.00,4.40,180.40,'2022-01-26 10:59:49','',''),(2607981,'1','208','1038',479,'Retail Sale Id 1605049',999.68,0.00,0.00,1.76,72.16,'2022-01-26 11:05:00','',''),(2608130,'1','208','1038',479,'Retail Sale Id 1605243',1698.32,0.00,0.00,2.99,122.59,'2022-01-26 11:21:41','',''),(2608154,'1','208','1038',479,'Retail Sale Id 1605264',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 11:23:26','',''),(2608338,'1','208','1038',479,'Retail Sale Id 1605463',999.68,0.00,0.00,1.76,72.16,'2022-01-26 11:42:30','',''),(2608373,'1','208','1038',479,'Retail Sale Id 1605511',1499.52,0.00,0.00,2.64,108.24,'2022-01-26 11:48:14','',''),(2608456,'1','208','1038',479,'Retail Sale Id 1605617',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 11:55:50','',''),(2608489,'1','208','1038',479,'Retail Sale Id 1605673',1198.48,0.00,0.00,2.11,86.51,'2022-01-26 11:59:24','',''),(2608503,'1','208','1038',479,'Retail Sale Id 1605679',1999.36,0.00,0.00,3.52,144.32,'2022-01-26 12:00:34','',''),(2608612,'1','208','1038',479,'Retail Sale Id 1605925',2840.00,0.00,0.00,5.00,205.00,'2022-01-26 12:16:38','',''),(2608619,'1','208','1038',479,'Retail Sale Id 1605958',1698.32,0.00,0.00,2.99,122.59,'2022-01-26 12:18:14','',''),(2608638,'1','208','1038',479,'Retail Sale Id 1606024',3498.88,0.00,0.00,6.16,252.56,'2022-01-26 12:20:45','',''),(2608652,'1','208','1038',479,'Retail Sale Id 1606041',1698.32,0.00,0.00,2.99,122.59,'2022-01-26 12:23:08','',''),(2608667,'1','208','1038',479,'Retail Sale Id 1606055',1704.00,0.00,0.00,3.00,123.00,'2022-01-26 12:24:30','',''),(2608668,'1','208','1038',479,'Retail Sale Id 1606055',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 12:24:30','',''),(2608734,'1','208','1038',479,'Retail Sale Id 1606110',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 12:30:57','',''),(2608752,'1','208','1038',479,'Retail Sale Id 1606128',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 12:32:36','',''),(2608876,'1','208','1038',479,'Retail Sale Id 1606267',698.64,0.00,0.00,1.23,50.43,'2022-01-26 12:47:19','',''),(2608902,'1','208','1038',479,'Retail Sale Id 1606300',3498.88,0.00,0.00,6.16,252.56,'2022-01-26 12:51:11','',''),(2608976,'1','208','1038',479,'Retail Sale Id 1606447',1698.32,0.00,0.00,2.99,122.59,'2022-01-26 13:02:59','',''),(2609115,'1','208','1038',479,'Retail Sale Id 1606595',1999.36,0.00,0.00,3.52,144.32,'2022-01-26 13:18:49','',''),(2609178,'1','208','1038',479,'Retail Sale Id 1606662',1698.32,0.00,0.00,2.99,122.59,'2022-01-26 13:27:35','',''),(2609288,'1','208','1038',479,'Retail Sale Id 1606749',602.08,0.00,0.00,1.06,43.46,'2022-01-26 13:42:17','',''),(2609293,'1','208','1038',479,'Retail Sale Id 1606755',5998.08,0.00,0.00,10.56,432.96,'2022-01-26 13:43:03','',''),(2609336,'1','208','1038',479,'Retail Sale Id 1606801',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 13:47:01','',''),(2609380,'1','208','1038',479,'Retail Sale Id 1606839',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 13:52:02','',''),(2609496,'1','208','1038',479,'Retail Sale Id 1606904',1397.28,0.00,0.00,2.46,100.86,'2022-01-26 14:06:35','',''),(2609556,'1','208','1038',479,'Retail Sale Id 1607026',2840.00,0.00,0.00,5.00,205.00,'2022-01-26 14:11:44','',''),(2609557,'1','208','1038',479,'Retail Sale Id 1607026',5157.44,0.00,0.00,9.08,372.28,'2022-01-26 14:11:44','',''),(2609601,'1','208','1038',479,'Retail Sale Id 1607088',698.64,0.00,0.00,1.23,50.43,'2022-01-26 14:16:58','',''),(2609628,'1','208','1038',479,'Retail Sale Id 1607115',999.68,0.00,0.00,1.76,72.16,'2022-01-26 14:19:45','',''),(2609647,'1','208','1038',479,'Retail Sale Id 1607140',1704.00,0.00,0.00,3.00,123.00,'2022-01-26 14:21:16','',''),(2609648,'1','208','1038',479,'Retail Sale Id 1607140',3408.00,0.00,0.00,6.00,246.00,'2022-01-26 14:21:16','',''),(2609673,'1','208','1038',479,'Retail Sale Id 1607239',3402.32,0.00,0.00,5.99,245.59,'2022-01-26 14:30:49','',''),(2609705,'1','208','1038',479,'Retail Sale Id 1607352',2300.40,0.00,0.00,4.05,166.05,'2022-01-26 14:39:59','',''),(2609725,'1','208','1038',479,'Retail Sale Id 1607398',1698.32,0.00,0.00,2.99,122.59,'2022-01-26 14:44:28','',''),(2609726,'1','208','1038',479,'Retail Sale Id 1607398',1698.32,0.00,0.00,2.99,122.59,'2022-01-26 14:44:28','',''),(2610165,'1','208','1038',479,'Retail Sale Id 1607931',8520.00,0.00,0.00,15.00,615.00,'2022-01-26 15:44:17','',''),(2610348,'1','208','1038',479,'Retail Sale Id 1608104',1999.36,0.00,0.00,3.52,144.32,'2022-01-26 15:59:36','',''),(2610370,'1','208','1038',479,'Retail Sale Id 1608125',1198.48,0.00,0.00,2.11,86.51,'2022-01-26 16:02:07','',''),(2610381,'1','208','1038',479,'Retail Sale Id 1608138',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 16:03:18','',''),(2610584,'1','208','1038',479,'Retail Sale Id 1608350',1499.52,0.00,0.00,2.64,108.24,'2022-01-26 16:26:16','',''),(2610869,'1','208','1038',479,'Retail Sale Id 1608642',1999.36,0.00,0.00,3.52,144.32,'2022-01-26 16:51:18','',''),(2610939,'1','208','1038',479,'Retail Sale Id 1608713',4998.40,0.00,0.00,8.80,360.80,'2022-01-26 16:56:21','',''),(2611087,'1','208','1038',479,'Retail Sale Id 1608874',3402.32,0.00,0.00,5.99,245.59,'2022-01-26 17:06:58','',''),(2611561,'1','208','1038',479,'Retail Sale Id 1609395',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 17:42:00','',''),(2611615,'1','208','1038',479,'Retail Sale Id 1609444',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 17:45:35','',''),(2611642,'1','208','1038',479,'Retail Sale Id 1609472',3402.32,0.00,0.00,5.99,245.59,'2022-01-26 17:47:43','',''),(2611664,'1','208','1038',479,'Retail Sale Id 1609484',999.68,0.00,0.00,1.76,72.16,'2022-01-26 17:49:38','',''),(2611721,'1','208','1038',479,'Retail Sale Id 1609543',1999.36,0.00,0.00,3.52,144.32,'2022-01-26 17:54:22','',''),(2611911,'1','208','1038',479,'Retail Sale Id 1609804',1499.52,0.00,0.00,2.64,108.24,'2022-01-26 18:21:17','',''),(2611946,'1','208','1038',479,'Retail Sale Id 1609909',3402.32,0.00,0.00,5.99,245.59,'2022-01-26 18:33:29','',''),(2611947,'1','208','1038',479,'Retail Sale Id 1609909',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 18:33:29','',''),(2611953,'1','208','1038',479,'Retail Sale Id 1609913',7100.00,0.00,0.00,12.50,512.50,'2022-01-26 18:35:18','',''),(2612037,'1','208','1038',479,'Retail Sale Id 1610025',2840.00,0.00,0.00,5.00,205.00,'2022-01-26 18:55:43','',''),(2612322,'1','208','1038',479,'Retail Sale Id 1610259',39084.08,0.00,0.00,68.81,2821.21,'2022-01-26 19:37:02','',''),(2612333,'1','208','1038',479,'Retail Sale Id 1610269',29785.92,0.00,0.00,52.44,2150.04,'2022-01-26 19:41:59','',''),(2612840,'1','208',NULL,479,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613512,'1','208','1038',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2614245,'1','208','1038',479,'Retail Sale Id 1610501',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 07:35:31','',''),(2614317,'1','208','1038',479,'Retail Sale Id 1610563',2851.36,0.00,0.00,5.02,205.82,'2022-01-27 07:47:26','',''),(2614340,'1','208','1038',479,'Retail Sale Id 1610587',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 07:51:49','',''),(2614602,'1','208','1038',479,'Retail Sale Id 1610799',6248.00,0.00,0.00,11.00,451.00,'2022-01-27 08:16:59','',''),(2614694,'1','208','1038',479,'Retail Sale Id 1610854',6816.00,0.00,0.00,12.00,492.00,'2022-01-27 08:22:33','',''),(2614723,'1','208','1038',479,'Retail Sale Id 1610887',3998.72,0.00,0.00,7.04,288.64,'2022-01-27 08:25:43','',''),(2614792,'1','208','1038',479,'Retail Sale Id 1610924',1704.00,0.00,0.00,3.00,123.00,'2022-01-27 08:30:01','',''),(2614851,'1','208','1038',479,'Retail Sale Id 1610978',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 08:35:28','',''),(2614852,'1','208','1038',479,'Retail Sale Id 1610978',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 08:35:28','',''),(2615001,'1','208','1038',479,'Retail Sale Id 1611062',999.68,0.00,0.00,1.76,72.16,'2022-01-27 08:43:27','',''),(2615163,'1','208','1038',479,'Retail Sale Id 1611179',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 08:54:19','',''),(2615210,'1','208','1038',479,'Retail Sale Id 1611229',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 09:00:53','',''),(2615239,'1','208','1038',479,'Retail Sale Id 1611260',28400.00,0.00,0.00,50.00,2050.00,'2022-01-27 09:03:55','',''),(2615397,'1','208','1038',479,'Retail Sale Id 1611395',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 09:18:13','',''),(2615460,'1','208','1038',479,'Retail Sale Id 1611449',2800.24,0.00,0.00,4.93,202.13,'2022-01-27 09:23:43','',''),(2615586,'1','208','1038',479,'Retail Sale Id 1611579',3351.20,0.00,0.00,5.90,241.90,'2022-01-27 09:35:21','',''),(2615617,'1','208','1038',479,'Retail Sale Id 1611607',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 09:38:03','',''),(2615637,'1','208','1038',479,'Retail Sale Id 1611621',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 09:39:11','',''),(2615709,'1','208','1038',479,'Retail Sale Id 1611646',2499.20,0.00,0.00,4.40,180.40,'2022-01-27 09:41:51','',''),(2615745,'1','208','1038',479,'Retail Sale Id 1611683',4998.40,0.00,0.00,8.80,360.80,'2022-01-27 09:45:27','',''),(2615776,'1','208','1038',479,'Retail Sale Id 1611707',2300.40,0.00,0.00,4.05,166.05,'2022-01-27 09:47:37','',''),(2615788,'1','208','1038',479,'Retail Sale Id 1611719',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 09:48:47','',''),(2615821,'1','208','1038',479,'Retail Sale Id 1611751',1698.32,0.00,0.00,2.99,122.59,'2022-01-27 09:52:23','',''),(2615883,'1','208','1038',479,'Retail Sale Id 1611804',2300.40,0.00,0.00,4.05,166.05,'2022-01-27 09:57:48','',''),(2615884,'1','208','1038',479,'Retail Sale Id 1611804',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 09:57:48','',''),(2616077,'1','208','1038',479,'Retail Sale Id 1611951',2499.20,0.00,0.00,4.40,180.40,'2022-01-27 10:12:38','',''),(2616078,'1','208','1038',479,'Retail Sale Id 1611951',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 10:12:38','',''),(2616100,'1','208','1038',479,'Retail Sale Id 1611969',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 10:14:15','',''),(2616163,'1','208','1038',479,'Retail Sale Id 1612019',2851.36,0.00,0.00,5.02,205.82,'2022-01-27 10:18:27','',''),(2616314,'1','208','1038',479,'Retail Sale Id 1612137',1698.32,0.00,0.00,2.99,122.59,'2022-01-27 10:29:49','',''),(2616330,'1','208','1038',479,'Retail Sale Id 1612155',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 10:31:29','',''),(2616331,'1','208','1038',479,'Retail Sale Id 1612155',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 10:31:29','',''),(2616573,'1','208','1038',479,'Retail Sale Id 1612327',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 10:46:40','',''),(2616574,'1','208','1038',479,'Retail Sale Id 1612327',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 10:46:40','',''),(2616595,'1','208','1038',479,'Retail Sale Id 1612346',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 10:48:57','',''),(2616631,'1','208','1038',479,'Retail Sale Id 1612393',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 10:53:41','',''),(2616716,'1','208','1038',479,'Retail Sale Id 1612466',1749.44,0.00,0.00,3.08,126.28,'2022-01-27 11:02:24','',''),(2616734,'1','208','1038',479,'Retail Sale Id 1612489',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 11:03:53','',''),(2616795,'1','208','1038',479,'Retail Sale Id 1612549',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 11:09:36','',''),(2616805,'1','208','1038',479,'Retail Sale Id 1612558',2851.36,0.00,0.00,5.02,205.82,'2022-01-27 11:10:40','',''),(2616820,'1','208','1038',479,'Retail Sale Id 1612572',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 11:11:47','',''),(2617034,'1','208','1038',479,'Retail Sale Id 1612773',2851.36,0.00,0.00,5.02,205.82,'2022-01-27 11:32:46','',''),(2617054,'1','208','1038',479,'Retail Sale Id 1612797',2851.36,0.00,0.00,5.02,205.82,'2022-01-27 11:34:32','',''),(2617055,'1','208','1038',479,'Retail Sale Id 1612797',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 11:34:32','',''),(2617094,'1','208','1038',479,'Retail Sale Id 1612818',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 11:36:45','',''),(2617123,'1','208','1038',479,'Retail Sale Id 1612843',2851.36,0.00,0.00,5.02,205.82,'2022-01-27 11:39:31','',''),(2617180,'1','208','1038',479,'Retail Sale Id 1612892',1749.44,0.00,0.00,3.08,126.28,'2022-01-27 11:44:29','',''),(2617215,'1','208','1038',479,'Retail Sale Id 1612929',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 11:48:46','',''),(2617229,'1','208','1038',479,'Retail Sale Id 1612947',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 11:50:12','',''),(2617230,'1','208','1038',479,'Retail Sale Id 1612947',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 11:50:12','',''),(2617249,'1','208','1038',479,'Retail Sale Id 1612966',1499.52,0.00,0.00,2.64,108.24,'2022-01-27 11:51:55','',''),(2617257,'1','208','1038',479,'Retail Sale Id 1612974',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 11:52:51','',''),(2617316,'1','208','1038',479,'Retail Sale Id 1613027',1499.52,0.00,0.00,2.64,108.24,'2022-01-27 11:59:04','',''),(2617374,'1','208','1038',479,'Retail Sale Id 1613085',1709.68,0.00,0.00,3.01,123.41,'2022-01-27 12:05:33','',''),(2617398,'1','208','1038',479,'Retail Sale Id 1613105',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 12:09:01','',''),(2617422,'1','208','1038',479,'Retail Sale Id 1613123',3402.32,0.00,0.00,5.99,245.59,'2022-01-27 12:11:38','',''),(2617546,'1','208','1038',479,'Retail Sale Id 1613252',999.68,0.00,0.00,1.76,72.16,'2022-01-27 12:23:06','',''),(2617585,'1','208','1038',479,'Retail Sale Id 1613288',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 12:28:10','',''),(2617687,'1','208','1038',479,'Retail Sale Id 1613378',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 12:36:49','',''),(2617807,'1','208','1038',479,'Retail Sale Id 1613491',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 12:48:18','',''),(2617845,'1','208','1038',479,'Retail Sale Id 1613537',999.68,0.00,0.00,1.76,72.16,'2022-01-27 12:53:15','',''),(2617869,'1','208','1038',479,'Retail Sale Id 1613561',8520.00,0.00,0.00,15.00,615.00,'2022-01-27 12:55:50','',''),(2617883,'1','208','1038',479,'Retail Sale Id 1613580',698.64,0.00,0.00,1.23,50.43,'2022-01-27 12:57:54','',''),(2617935,'1','208','1038',479,'Retail Sale Id 1613634',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 13:04:48','',''),(2617979,'1','208','1038',479,'Retail Sale Id 1613671',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 13:10:45','',''),(2618070,'1','208','1038',479,'Retail Sale Id 1613766',499.84,0.00,0.00,0.88,36.08,'2022-01-27 13:22:21','',''),(2618083,'1','208','1038',479,'Retail Sale Id 1613784',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 13:24:19','',''),(2618115,'1','208','1038',479,'Retail Sale Id 1613791',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 13:25:00','',''),(2618129,'1','208','1038',479,'Retail Sale Id 1613805',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 13:26:41','',''),(2618149,'1','208','1038',479,'Retail Sale Id 1613827',2499.20,0.00,0.00,4.40,180.40,'2022-01-27 13:28:38','',''),(2618195,'1','208','1038',479,'Retail Sale Id 1613873',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 13:34:00','',''),(2618209,'1','208','1038',479,'Retail Sale Id 1613889',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 13:35:27','',''),(2618231,'1','208','1038',479,'Retail Sale Id 1613915',999.68,0.00,0.00,1.76,72.16,'2022-01-27 13:38:57','',''),(2618372,'1','208','1038',479,'Retail Sale Id 1614037',2300.40,0.00,0.00,4.05,166.05,'2022-01-27 13:53:07','',''),(2618392,'1','208','1038',479,'Retail Sale Id 1614062',3998.72,0.00,0.00,7.04,288.64,'2022-01-27 13:54:32','',''),(2618428,'1','208','1038',479,'Retail Sale Id 1614106',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 13:58:20','',''),(2618429,'1','208','1038',479,'Retail Sale Id 1614106',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 13:58:20','',''),(2618441,'1','208','1038',479,'Retail Sale Id 1614118',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 13:59:29','',''),(2618482,'1','208','1038',479,'Retail Sale Id 1614159',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 14:04:45','',''),(2618502,'1','208','1038',479,'Retail Sale Id 1614174',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 14:06:19','',''),(2618531,'1','208','1038',479,'Retail Sale Id 1614202',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 14:08:37','',''),(2618590,'1','208','1038',479,'Retail Sale Id 1614257',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 14:16:03','',''),(2618635,'1','208','1038',479,'Retail Sale Id 1614302',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 14:23:09','',''),(2618660,'1','208','1038',479,'Retail Sale Id 1614316',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 14:25:23','',''),(2618731,'1','208','1038',479,'Retail Sale Id 1614384',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 14:34:45','',''),(2618784,'1','208','1038',479,'Retail Sale Id 1614424',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 14:38:40','',''),(2618805,'1','208','1038',479,'Retail Sale Id 1614439',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 14:39:56','',''),(2618867,'1','208','1038',479,'Retail Sale Id 1614471',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 14:44:19','',''),(2618907,'1','208','1038',479,'Retail Sale Id 1614483',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 14:45:57','',''),(2618935,'1','208','1038',479,'Retail Sale Id 1614492',2851.36,0.00,0.00,5.02,205.82,'2022-01-27 14:47:01','',''),(2619103,'1','208','1038',479,'Retail Sale Id 1614646',3998.72,0.00,0.00,7.04,288.64,'2022-01-27 15:05:28','',''),(2619125,'1','208','1038',479,'Retail Sale Id 1614680',1749.44,0.00,0.00,3.08,126.28,'2022-01-27 15:08:07','',''),(2619168,'1','208','1038',479,'Retail Sale Id 1614740',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 15:13:01','',''),(2619276,'1','208','1038',479,'Retail Sale Id 1614836',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 15:23:43','',''),(2619321,'1','208','1038',479,'Retail Sale Id 1614878',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 15:27:33','',''),(2619365,'1','208','1038',479,'Retail Sale Id 1614925',3998.72,0.00,0.00,7.04,288.64,'2022-01-27 15:30:28','',''),(2619422,'1','208','1038',479,'Retail Sale Id 1614974',999.68,0.00,0.00,1.76,72.16,'2022-01-27 15:35:23','',''),(2619438,'1','208','1038',479,'Retail Sale Id 1614987',3447.76,0.00,0.00,6.07,248.87,'2022-01-27 15:36:51','',''),(2619479,'1','208','1038',479,'Retail Sale Id 1615028',2300.40,0.00,0.00,4.05,166.05,'2022-01-27 15:40:42','',''),(2619498,'1','208','1038',479,'Retail Sale Id 1615049',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 15:42:17','',''),(2619600,'1','208','1038',479,'Retail Sale Id 1615126',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 15:48:38','',''),(2619674,'1','208','1038',479,'Retail Sale Id 1615168',1499.52,0.00,0.00,2.64,108.24,'2022-01-27 15:52:18','',''),(2619758,'1','208','1038',479,'Retail Sale Id 1615259',1749.44,0.00,0.00,3.08,126.28,'2022-01-27 16:00:35','',''),(2619843,'1','208','1038',479,'Retail Sale Id 1615333',6997.76,0.00,0.00,12.32,505.12,'2022-01-27 16:08:45','',''),(2619858,'1','208','1038',479,'Retail Sale Id 1615354',1749.44,0.00,0.00,3.08,126.28,'2022-01-27 16:10:21','',''),(2619859,'1','208','1038',479,'Retail Sale Id 1615354',1749.44,0.00,0.00,3.08,126.28,'2022-01-27 16:10:21','',''),(2619892,'1','208','1038',479,'Retail Sale Id 1615390',550.96,0.00,0.00,0.97,39.77,'2022-01-27 16:12:53','',''),(2620197,'1','208','1038',479,'Retail Sale Id 1615606',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 16:33:11','',''),(2620513,'1','208','1038',479,'Retail Sale Id 1615885',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 16:53:46','',''),(2620572,'1','208','1038',479,'Retail Sale Id 1615939',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 16:58:08','',''),(2620605,'1','208','1038',479,'Retail Sale Id 1615960',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 16:59:27','',''),(2620621,'1','208','1038',479,'Retail Sale Id 1615975',5702.72,0.00,0.00,10.04,411.64,'2022-01-27 17:00:38','',''),(2620726,'1','208','1038',479,'Retail Sale Id 1616081',999.68,0.00,0.00,1.76,72.16,'2022-01-27 17:08:20','',''),(2620771,'1','208','1038',479,'Retail Sale Id 1616119',2851.36,0.00,0.00,5.02,205.82,'2022-01-27 17:10:52','',''),(2620772,'1','208','1038',479,'Retail Sale Id 1616119',2851.36,0.00,0.00,5.02,205.82,'2022-01-27 17:10:52','',''),(2620798,'1','208','1038',479,'Retail Sale Id 1616148',999.68,0.00,0.00,1.76,72.16,'2022-01-27 17:12:33','',''),(2620830,'1','208','1038',479,'Retail Sale Id 1616179',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 17:14:44','',''),(2620959,'1','208','1038',479,'Retail Sale Id 1616306',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 17:24:00','',''),(2620991,'1','208','1038',479,'Retail Sale Id 1616332',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 17:26:06','',''),(2621011,'1','208','1038',479,'Retail Sale Id 1616356',1999.36,0.00,0.00,3.52,144.32,'2022-01-27 17:27:30','',''),(2621032,'1','208','1038',479,'Retail Sale Id 1616374',6997.76,0.00,0.00,12.32,505.12,'2022-01-27 17:28:40','',''),(2621112,'1','208','1038',479,'Retail Sale Id 1616434',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 17:33:16','',''),(2621123,'1','208','1038',479,'Retail Sale Id 1616451',999.68,0.00,0.00,1.76,72.16,'2022-01-27 17:34:08','',''),(2621137,'1','208','1038',479,'Retail Sale Id 1616465',1749.44,0.00,0.00,3.08,126.28,'2022-01-27 17:35:10','',''),(2621147,'1','208','1038',479,'Retail Sale Id 1616475',1698.32,0.00,0.00,2.99,122.59,'2022-01-27 17:35:58','',''),(2621176,'1','208','1038',479,'Retail Sale Id 1616500',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 17:37:37','',''),(2621177,'1','208','1038',479,'Retail Sale Id 1616500',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 17:37:37','',''),(2621178,'1','208','1038',479,'Retail Sale Id 1616500',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 17:37:37','',''),(2621200,'1','208','1038',479,'Retail Sale Id 1616520',1499.52,0.00,0.00,2.64,108.24,'2022-01-27 17:39:22','',''),(2621216,'1','208','1038',479,'Retail Sale Id 1616537',1499.52,0.00,0.00,2.64,108.24,'2022-01-27 17:40:46','',''),(2621228,'1','208','1038',479,'Retail Sale Id 1616545',1704.00,0.00,0.00,3.00,123.00,'2022-01-27 17:42:01','',''),(2621238,'1','208','1038',479,'Retail Sale Id 1616556',999.68,0.00,0.00,1.76,72.16,'2022-01-27 17:42:53','',''),(2621266,'1','208','1038',479,'Retail Sale Id 1616585',3998.72,0.00,0.00,7.04,288.64,'2022-01-27 17:45:11','',''),(2621314,'1','208','1038',479,'Retail Sale Id 1616606',2499.20,0.00,0.00,4.40,180.40,'2022-01-27 17:47:14','',''),(2621447,'1','208','1038',479,'Retail Sale Id 1616721',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 17:57:15','',''),(2621487,'1','208','1038',479,'Retail Sale Id 1616756',999.68,0.00,0.00,1.76,72.16,'2022-01-27 18:00:47','',''),(2621496,'1','208','1038',479,'Retail Sale Id 1616765',2851.36,0.00,0.00,5.02,205.82,'2022-01-27 18:01:36','',''),(2621567,'1','208','1038',479,'Retail Sale Id 1616819',2101.60,0.00,0.00,3.70,151.70,'2022-01-27 18:08:12','',''),(2621645,'1','208','1038',479,'Retail Sale Id 1616879',1499.52,0.00,0.00,2.64,108.24,'2022-01-27 18:16:20','',''),(2621701,'1','208','1038',479,'Retail Sale Id 1616942',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 18:22:06','',''),(2621750,'1','208','1038',479,'Retail Sale Id 1616986',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 18:27:15','',''),(2621756,'1','208','1038',479,'Retail Sale Id 1616993',1749.44,0.00,0.00,3.08,126.28,'2022-01-27 18:28:26','',''),(2621780,'1','208','1038',479,'Retail Sale Id 1617015',1698.32,0.00,0.00,2.99,122.59,'2022-01-27 18:31:20','',''),(2621795,'1','208','1038',479,'Retail Sale Id 1617028',10002.48,0.00,0.00,17.61,722.01,'2022-01-27 18:32:59','',''),(2621841,'1','208','1038',479,'Retail Sale Id 1617065',4998.40,0.00,0.00,8.80,360.80,'2022-01-27 18:38:42','',''),(2621868,'1','208','1038',479,'Retail Sale Id 1617091',2499.20,0.00,0.00,4.40,180.40,'2022-01-27 18:41:29','',''),(2622034,'1','208','1038',479,'Retail Sale Id 1617216',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 19:00:58','',''),(2622128,'1','208','1038',479,'Retail Sale Id 1617245',1499.52,0.00,0.00,2.64,108.24,'2022-01-27 19:10:16','',''),(2622181,'1','208','1038',479,'Retail Sale Id 1617264',999.68,0.00,0.00,1.76,72.16,'2022-01-27 19:15:58','',''),(2622242,'1','208','1038',479,'Retail Sale Id 1617315',2999.04,0.00,0.00,5.28,216.48,'2022-01-27 19:30:45','',''),(2622255,'1','208','1038',479,'Retail Sale Id 1617327',7100.00,0.00,0.00,12.50,512.50,'2022-01-27 19:33:10','',''),(2622317,'1','208','1038',479,'Retail Sale Id 1617361',3498.88,0.00,0.00,6.16,252.56,'2022-01-27 19:41:43','',''),(2622332,'1','208','1038',479,'Retail Sale Id 1617375',3799.92,0.00,0.00,6.69,274.29,'2022-01-27 19:47:05','',''),(2622679,'1','208','1038',479,'Return of Retail Sale Id 1616756',0.00,999.68,1.76,0.00,-72.16,'2022-01-27 22:31:51','',''),(2622683,'1','208','1038',479,'Retail Sale Id 1617469',789.52,0.00,0.00,1.39,56.99,'2022-01-27 22:37:03','',''),(2623728,'1','208','1038',479,'Retail Sale Id 1618327',2499.20,0.00,0.00,4.40,180.40,'2022-01-28 08:45:24','',''),(2623775,'1','208','1038',479,'Retail Sale Id 1618376',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 08:49:34','',''),(2623807,'1','208','1038',479,'Retail Sale Id 1618394',1499.52,0.00,0.00,2.64,108.24,'2022-01-28 08:51:04','',''),(2623855,'1','208','1038',479,'Retail Sale Id 1618446',3402.32,0.00,0.00,5.99,245.59,'2022-01-28 08:55:00','',''),(2623911,'1','208','1038',479,'Retail Sale Id 1618496',4998.40,0.00,0.00,8.80,360.80,'2022-01-28 09:00:34','',''),(2624100,'1','208','1038',479,'Retail Sale Id 1618613',3498.88,0.00,0.00,6.16,252.56,'2022-01-28 09:11:10','',''),(2624137,'1','208','1038',479,'Retail Sale Id 1618641',3408.00,0.00,0.00,6.00,246.00,'2022-01-28 09:13:28','',''),(2624239,'1','208','1038',479,'Retail Sale Id 1618726',1499.52,0.00,0.00,2.64,108.24,'2022-01-28 09:21:23','',''),(2624257,'1','208','1038',479,'Retail Sale Id 1618744',2158.40,0.00,0.00,3.80,155.80,'2022-01-28 09:23:12','',''),(2624258,'1','208','1038',479,'Retail Sale Id 1618744',2840.00,0.00,0.00,5.00,205.00,'2022-01-28 09:23:12','',''),(2624363,'1','208','1038',479,'Retail Sale Id 1618845',1698.32,0.00,0.00,2.99,122.59,'2022-01-28 09:33:27','',''),(2624412,'1','208','1038',479,'Retail Sale Id 1618893',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 09:37:11','',''),(2624433,'1','208','1038',479,'Retail Sale Id 1618914',2840.00,0.00,0.00,5.00,205.00,'2022-01-28 09:39:35','',''),(2624452,'1','208','1038',479,'Retail Sale Id 1618938',1499.52,0.00,0.00,2.64,108.24,'2022-01-28 09:41:41','',''),(2624453,'1','208','1038',479,'Retail Sale Id 1618938',1999.36,0.00,0.00,3.52,144.32,'2022-01-28 09:41:41','',''),(2624454,'1','208','1038',479,'Retail Sale Id 1618938',4998.40,0.00,0.00,8.80,360.80,'2022-01-28 09:41:41','',''),(2624467,'1','208','1038',479,'Retail Sale Id 1618952',6997.76,0.00,0.00,12.32,505.12,'2022-01-28 09:43:39','',''),(2624578,'1','208','1038',479,'Retail Sale Id 1619072',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 09:56:20','',''),(2624597,'1','208','1038',479,'Retail Sale Id 1619092',1198.48,0.00,0.00,2.11,86.51,'2022-01-28 09:57:48','',''),(2624603,'1','208','1038',479,'Retail Sale Id 1619102',3408.00,0.00,0.00,6.00,246.00,'2022-01-28 09:58:53','',''),(2624632,'1','208','1038',479,'Retail Sale Id 1619129',2800.24,0.00,0.00,4.93,202.13,'2022-01-28 10:01:29','',''),(2624640,'1','208','1038',479,'Retail Sale Id 1619136',2999.04,0.00,0.00,5.28,216.48,'2022-01-28 10:02:19','',''),(2624787,'1','208','1038',479,'Retail Sale Id 1619239',2300.40,0.00,0.00,4.05,166.05,'2022-01-28 10:11:51','',''),(2624795,'1','208','1038',479,'Retail Sale Id 1619254',999.68,0.00,0.00,1.76,72.16,'2022-01-28 10:13:18','',''),(2624886,'1','208','1038',479,'Retail Sale Id 1619335',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 10:19:26','',''),(2624909,'1','208','1038',479,'Retail Sale Id 1619353',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 10:21:18','',''),(2624961,'1','208','1038',479,'Retail Sale Id 1619412',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 10:26:03','',''),(2625031,'1','208','1038',479,'Retail Sale Id 1619488',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 10:33:05','',''),(2625073,'1','208','1038',479,'Retail Sale Id 1619518',3408.00,0.00,0.00,6.00,246.00,'2022-01-28 10:36:20','',''),(2625138,'1','208','1038',479,'Retail Sale Id 1619594',6997.76,0.00,0.00,12.32,505.12,'2022-01-28 10:43:13','',''),(2625245,'1','208','1038',479,'Retail Sale Id 1619667',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 10:50:00','',''),(2625280,'1','208','1038',479,'Retail Sale Id 1619709',3408.00,0.00,0.00,6.00,246.00,'2022-01-28 10:53:24','',''),(2625437,'1','208','1038',479,'Retail Sale Id 1619818',2840.00,0.00,0.00,5.00,205.00,'2022-01-28 11:04:12','',''),(2625438,'1','208','1038',479,'Retail Sale Id 1619818',2840.00,0.00,0.00,5.00,205.00,'2022-01-28 11:04:12','',''),(2625595,'1','208','1038',479,'Retail Sale Id 1619979',3498.88,0.00,0.00,6.16,252.56,'2022-01-28 11:18:32','',''),(2625636,'1','208','1038',479,'Return of Retail Sale Id 1619518',0.00,3408.00,6.00,0.00,-246.00,'2022-01-28 11:22:27','',''),(2625672,'1','208','1038',479,'Retail Sale Id 1620067',897.44,0.00,0.00,1.58,64.78,'2022-01-28 11:26:08','',''),(2625673,'1','208','1038',479,'Retail Sale Id 1620067',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 11:26:08','',''),(2625681,'1','208','1038',479,'Retail Sale Id 1620074',3498.88,0.00,0.00,6.16,252.56,'2022-01-28 11:27:03','',''),(2625700,'1','208','1038',479,'Retail Sale Id 1620092',999.68,0.00,0.00,1.76,72.16,'2022-01-28 11:28:37','',''),(2625723,'1','208','1038',479,'Retail Sale Id 1620115',3408.00,0.00,0.00,6.00,246.00,'2022-01-28 11:30:16','',''),(2625776,'1','208','1038',479,'Retail Sale Id 1620172',2999.04,0.00,0.00,5.28,216.48,'2022-01-28 11:34:01','',''),(2625908,'1','208','1038',479,'Retail Sale Id 1620297',3498.88,0.00,0.00,6.16,252.56,'2022-01-28 11:44:25','',''),(2626123,'1','208','1038',479,'Retail Sale Id 1620519',3402.32,0.00,0.00,5.99,245.59,'2022-01-28 12:05:50','',''),(2626124,'1','208','1038',479,'Retail Sale Id 1620519',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 12:05:50','',''),(2626194,'1','208','1038',479,'Retail Sale Id 1620597',2800.24,0.00,0.00,4.93,202.13,'2022-01-28 12:13:55','',''),(2626204,'1','208','1038',479,'Retail Sale Id 1620606',1800.56,0.00,0.00,3.17,129.97,'2022-01-28 12:15:30','',''),(2627156,'1','208','1038',479,'Retail Sale Id 1621481',3408.00,0.00,0.00,6.00,246.00,'2022-01-28 14:04:22','',''),(2627179,'1','208','1038',479,'Retail Sale Id 1621501',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 14:06:22','',''),(2627256,'1','208',NULL,479,'Reception corrector for bridging 132387',0.00,0.00,0.00,5000.00,0.00,'2022-01-28 14:16:28','',''),(2627257,'1','208','1038',479,'Received from bridging 132387',0.00,0.00,5000.00,0.00,0.00,'2022-01-28 14:16:28','',''),(2627285,'1','208','1038',479,'Retail Sale Id 1621602',2300.40,0.00,0.00,4.05,166.05,'2022-01-28 14:18:30','',''),(2627316,'1','208','1038',479,'Retail Sale Id 1621630',602.08,0.00,0.00,1.06,43.46,'2022-01-28 14:21:42','',''),(2627426,'1','208','1038',479,'Retail Sale Id 1621744',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 14:35:23','',''),(2627572,'1','208','1038',479,'Retail Sale Id 1621840',2999.04,0.00,0.00,5.28,216.48,'2022-01-28 14:45:07','',''),(2627613,'1','208','1038',479,'Retail Sale Id 1621866',999.68,0.00,0.00,1.76,72.16,'2022-01-28 14:47:52','',''),(2627627,'1','208','1038',479,'Retail Sale Id 1621876',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 14:48:46','',''),(2627641,'1','208','1038',479,'Retail Sale Id 1621886',2851.36,0.00,0.00,5.02,205.82,'2022-01-28 14:50:32','',''),(2627807,'1','208','1038',479,'Retail Sale Id 1622028',3498.88,0.00,0.00,6.16,252.56,'2022-01-28 15:03:03','',''),(2627898,'1','208','1038',479,'Retail Sale Id 1622109',1999.36,0.00,0.00,3.52,144.32,'2022-01-28 15:09:04','',''),(2628141,'1','208','1038',479,'Retail Sale Id 1622331',2999.04,0.00,0.00,5.28,216.48,'2022-01-28 15:26:27','',''),(2628188,'1','208','1038',479,'Retail Sale Id 1622372',1499.52,0.00,0.00,2.64,108.24,'2022-01-28 15:30:13','',''),(2628264,'1','208','1038',479,'Retail Sale Id 1622446',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 15:36:41','',''),(2628359,'1','208','1038',479,'Retail Sale Id 1622512',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 15:43:42','',''),(2628721,'1','208','1038',479,'Retail Sale Id 1622872',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 16:14:14','',''),(2628766,'1','208','1038',479,'Retail Sale Id 1622917',2999.04,0.00,0.00,5.28,216.48,'2022-01-28 16:18:21','',''),(2628783,'1','208','1038',479,'Retail Sale Id 1622938',6248.00,0.00,0.00,11.00,451.00,'2022-01-28 16:20:21','',''),(2628838,'1','208','1038',479,'Retail Sale Id 1622995',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 16:26:14','',''),(2628850,'1','208','1038',479,'Retail Sale Id 1623010',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 16:27:25','',''),(2628860,'1','208','1038',479,'Retail Sale Id 1623021',1499.52,0.00,0.00,2.64,108.24,'2022-01-28 16:28:45','',''),(2628985,'1','208','1038',479,'Retail Sale Id 1623146',1698.32,0.00,0.00,2.99,122.59,'2022-01-28 16:39:33','',''),(2629010,'1','208','1038',479,'Retail Sale Id 1623162',2101.60,0.00,0.00,3.70,151.70,'2022-01-28 16:40:48','',''),(2629026,'1','208','1038',479,'Retail Sale Id 1623179',2499.20,0.00,0.00,4.40,180.40,'2022-01-28 16:42:00','',''),(2629191,'1','208','1038',479,'Retail Sale Id 1623350',999.68,0.00,0.00,1.76,72.16,'2022-01-28 16:56:00','',''),(2629259,'1','208','1038',479,'Retail Sale Id 1623412',3408.00,0.00,0.00,6.00,246.00,'2022-01-28 17:01:42','',''),(2629284,'1','208','1038',479,'Retail Sale Id 1623434',999.68,0.00,0.00,1.76,72.16,'2022-01-28 17:03:56','',''),(2629325,'1','208','1038',479,'Retail Sale Id 1623473',3498.88,0.00,0.00,6.16,252.56,'2022-01-28 17:07:04','',''),(2629357,'1','208','1038',479,'Retail Sale Id 1623515',3402.32,0.00,0.00,5.99,245.59,'2022-01-28 17:09:32','',''),(2629517,'1','208','1038',479,'Retail Sale Id 1623671',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 17:22:33','',''),(2629544,'1','208','1038',479,'Retail Sale Id 1623695',1999.36,0.00,0.00,3.52,144.32,'2022-01-28 17:24:53','',''),(2629580,'1','208','1038',479,'Retail Sale Id 1623741',3402.32,0.00,0.00,5.99,245.59,'2022-01-28 17:27:44','',''),(2629675,'1','208','1038',479,'Retail Sale Id 1623819',3498.88,0.00,0.00,6.16,252.56,'2022-01-28 17:36:02','',''),(2629701,'1','208','1038',479,'Retail Sale Id 1623851',3498.88,0.00,0.00,6.16,252.56,'2022-01-28 17:38:09','',''),(2629785,'1','208','1038',479,'Retail Sale Id 1623912',3402.32,0.00,0.00,5.99,245.59,'2022-01-28 17:44:10','',''),(2630059,'1','208','1038',479,'Retail Sale Id 1624165',1999.36,0.00,0.00,3.52,144.32,'2022-01-28 17:59:28','',''),(2630100,'1','208','1038',479,'Retail Sale Id 1624175',2198.16,0.00,0.00,3.87,158.67,'2022-01-28 18:00:25','',''),(2630142,'1','208','1038',479,'Retail Sale Id 1624188',1999.36,0.00,0.00,3.52,144.32,'2022-01-28 18:01:34','',''),(2630170,'1','208','1038',479,'Retail Sale Id 1624216',1999.36,0.00,0.00,3.52,144.32,'2022-01-28 18:04:31','',''),(2630717,'1','208','1038',479,'Retail Sale Id 1624682',602.08,0.00,0.00,1.06,43.46,'2022-01-28 19:06:48','',''),(2630787,'1','208','1038',479,'Retail Sale Id 1624753',1698.32,0.00,0.00,2.99,122.59,'2022-01-28 19:20:37','',''),(2630806,'1','208','1038',479,'Retail Sale Id 1624766',3408.00,0.00,0.00,6.00,246.00,'2022-01-28 19:24:13','',''),(2630973,'1','208','1038',479,'Retail Sale Id 1624823',63400.16,0.00,0.00,111.62,4576.42,'2022-01-28 19:51:57','',''),(2630978,'1','208','1038',479,'Retail Sale Id 1624830',17005.92,0.00,0.00,29.94,1227.54,'2022-01-28 19:55:35','',''),(2630983,'1','208','1038',479,'Retail Sale Id 1624834',3408.00,0.00,0.00,6.00,246.00,'2022-01-28 19:57:55','',''),(2630990,'1','208','1038',479,'Retail Sale Id 1624836',7100.00,0.00,0.00,12.50,512.50,'2022-01-28 20:01:27','',''),(2631035,'1','208','1038',479,'Retail Sale Id 1624863',75265.68,0.00,0.00,132.51,5432.91,'2022-01-28 20:12:47','',''),(2633072,'1','208','1038',479,'Retail Sale Id 1626388',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 10:34:27','',''),(2633097,'1','208','1038',479,'Retail Sale Id 1626416',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 10:36:16','',''),(2633098,'1','208','1038',479,'Retail Sale Id 1626416',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 10:36:16','',''),(2633110,'1','208','1038',479,'Retail Sale Id 1626425',2499.20,0.00,0.00,4.40,180.40,'2022-01-29 10:37:24','',''),(2633124,'1','208','1038',479,'Retail Sale Id 1626440',1902.80,0.00,0.00,3.35,137.35,'2022-01-29 10:38:25','',''),(2633140,'1','208','1038',479,'Retail Sale Id 1626457',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 10:39:23','',''),(2633152,'1','208','1038',479,'Retail Sale Id 1626469',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 10:40:23','',''),(2633234,'1','208','1038',479,'Retail Sale Id 1626517',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 10:44:08','',''),(2633257,'1','208','1038',479,'Retail Sale Id 1626542',1698.32,0.00,0.00,2.99,122.59,'2022-01-29 10:45:47','',''),(2633268,'1','208','1038',479,'Retail Sale Id 1626555',1198.48,0.00,0.00,2.11,86.51,'2022-01-29 10:46:39','',''),(2633277,'1','208','1038',479,'Retail Sale Id 1626560',1198.48,0.00,0.00,2.11,86.51,'2022-01-29 10:47:11','',''),(2633300,'1','208','1038',479,'Retail Sale Id 1626584',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 10:49:04','',''),(2633321,'1','208','1038',479,'Retail Sale Id 1626605',499.84,0.00,0.00,0.88,36.08,'2022-01-29 10:50:07','',''),(2633400,'1','208','1038',479,'Retail Sale Id 1626660',5998.08,0.00,0.00,10.56,432.96,'2022-01-29 10:53:14','',''),(2633430,'1','208','1038',479,'Retail Sale Id 1626691',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 10:55:22','',''),(2633452,'1','208','1038',479,'Retail Sale Id 1626712',4998.40,0.00,0.00,8.80,360.80,'2022-01-29 10:56:34','',''),(2633465,'1','208','1038',479,'Retail Sale Id 1626725',2300.40,0.00,0.00,4.05,166.05,'2022-01-29 10:57:38','',''),(2633483,'1','208','1038',479,'Retail Sale Id 1626743',3601.12,0.00,0.00,6.34,259.94,'2022-01-29 10:58:54','',''),(2633512,'1','208','1038',479,'Retail Sale Id 1626777',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 11:00:51','',''),(2633588,'1','208','1038',479,'Retail Sale Id 1626824',999.68,0.00,0.00,1.76,72.16,'2022-01-29 11:04:02','',''),(2633599,'1','208','1038',479,'Retail Sale Id 1626840',2999.04,0.00,0.00,5.28,216.48,'2022-01-29 11:04:50','',''),(2633642,'1','208','1038',479,'Retail Sale Id 1626862',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 11:06:11','',''),(2633669,'1','208','1038',479,'Retail Sale Id 1626876',3402.32,0.00,0.00,5.99,245.59,'2022-01-29 11:07:10','',''),(2633689,'1','208','1038',479,'Retail Sale Id 1626898',2300.40,0.00,0.00,4.05,166.05,'2022-01-29 11:08:12','',''),(2633700,'1','208','1038',479,'Retail Sale Id 1626908',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 11:09:01','',''),(2633715,'1','208','1038',479,'Retail Sale Id 1626930',2851.36,0.00,0.00,5.02,205.82,'2022-01-29 11:09:48','',''),(2633743,'1','208','1038',479,'Retail Sale Id 1626961',2902.48,0.00,0.00,5.11,209.51,'2022-01-29 11:11:39','',''),(2633744,'1','208','1038',479,'Retail Sale Id 1626961',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 11:11:39','',''),(2633795,'1','208','1038',479,'Retail Sale Id 1626988',800.88,0.00,0.00,1.41,57.81,'2022-01-29 11:13:25','',''),(2633813,'1','208','1038',479,'Retail Sale Id 1627008',2999.04,0.00,0.00,5.28,216.48,'2022-01-29 11:14:28','',''),(2633835,'1','208','1038',479,'Retail Sale Id 1627034',6997.76,0.00,0.00,12.32,505.12,'2022-01-29 11:15:59','',''),(2633851,'1','208','1038',479,'Retail Sale Id 1627049',999.68,0.00,0.00,1.76,72.16,'2022-01-29 11:16:57','',''),(2633879,'1','208','1038',479,'Retail Sale Id 1627061',1999.36,0.00,0.00,3.52,144.32,'2022-01-29 11:17:56','',''),(2633894,'1','208','1038',479,'Retail Sale Id 1627071',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 11:18:54','',''),(2633908,'1','208','1038',479,'Retail Sale Id 1627094',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 11:19:55','',''),(2633965,'1','208','1038',479,'Retail Sale Id 1627153',1698.32,0.00,0.00,2.99,122.59,'2022-01-29 11:24:18','',''),(2634013,'1','208','1038',479,'Retail Sale Id 1627197',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 11:27:42','',''),(2634035,'1','208','1038',479,'Retail Sale Id 1627230',2999.04,0.00,0.00,5.28,216.48,'2022-01-29 11:29:42','',''),(2634118,'1','208','1038',479,'Retail Sale Id 1627311',1698.32,0.00,0.00,2.99,122.59,'2022-01-29 11:35:55','',''),(2634162,'1','208','1038',479,'Retail Sale Id 1627358',6997.76,0.00,0.00,12.32,505.12,'2022-01-29 11:39:18','',''),(2634177,'1','208','1038',479,'Retail Sale Id 1627375',5702.72,0.00,0.00,10.04,411.64,'2022-01-29 11:40:18','',''),(2634194,'1','208','1038',479,'Retail Sale Id 1627393',2999.04,0.00,0.00,5.28,216.48,'2022-01-29 11:41:38','',''),(2634230,'1','208','1038',479,'Retail Sale Id 1627431',999.68,0.00,0.00,1.76,72.16,'2022-01-29 11:43:43','',''),(2634310,'1','208','1038',479,'Retail Sale Id 1627519',1999.36,0.00,0.00,3.52,144.32,'2022-01-29 11:49:18','',''),(2634327,'1','208','1038',479,'Retail Sale Id 1627538',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 11:50:20','',''),(2634363,'1','208','1038',479,'Retail Sale Id 1627554',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 11:51:21','',''),(2634380,'1','208','1038',479,'Retail Sale Id 1627573',999.68,0.00,0.00,1.76,72.16,'2022-01-29 11:52:18','',''),(2634443,'1','208','1038',479,'Retail Sale Id 1627651',2851.36,0.00,0.00,5.02,205.82,'2022-01-29 11:57:18','',''),(2634444,'1','208','1038',479,'Retail Sale Id 1627651',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 11:57:18','',''),(2634497,'1','208','1038',479,'Retail Sale Id 1627704',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 12:01:26','',''),(2634522,'1','208','1038',479,'Retail Sale Id 1627731',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 12:03:14','',''),(2634743,'1','208','1038',479,'Retail Sale Id 1628012',1749.44,0.00,0.00,3.08,126.28,'2022-01-29 12:19:38','',''),(2634744,'1','208','1038',479,'Retail Sale Id 1628012',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 12:19:38','',''),(2634784,'1','208','1038',479,'Retail Sale Id 1628048',1136.00,0.00,0.00,2.00,82.00,'2022-01-29 12:22:06','',''),(2634785,'1','208','1038',479,'Retail Sale Id 1628048',2851.36,0.00,0.00,5.02,205.82,'2022-01-29 12:22:06','',''),(2634806,'1','208','1038',479,'Retail Sale Id 1628076',2999.04,0.00,0.00,5.28,216.48,'2022-01-29 12:23:49','',''),(2634953,'1','208','1038',479,'Retail Sale Id 1628214',1198.48,0.00,0.00,2.11,86.51,'2022-01-29 12:34:20','',''),(2635046,'1','208','1038',479,'Retail Sale Id 1628290',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 12:39:32','',''),(2635126,'1','208','1038',479,'Retail Sale Id 1628368',1198.48,0.00,0.00,2.11,86.51,'2022-01-29 12:45:10','',''),(2635165,'1','208','1038',479,'Retail Sale Id 1628400',698.64,0.00,0.00,1.23,50.43,'2022-01-29 12:48:02','',''),(2635171,'1','208','1038',479,'Retail Sale Id 1628407',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 12:49:00','',''),(2635353,'1','208','1038',479,'Retail Sale Id 1628569',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 13:01:31','',''),(2635472,'1','208','1038',479,'Retail Sale Id 1628701',5998.08,0.00,0.00,10.56,432.96,'2022-01-29 13:13:44','',''),(2635473,'1','208','1038',479,'Retail Sale Id 1628701',5998.08,0.00,0.00,10.56,432.96,'2022-01-29 13:13:44','',''),(2635761,'1','208','1038',479,'Retail Sale Id 1628955',499.84,0.00,0.00,0.88,36.08,'2022-01-29 13:35:30','',''),(2635787,'1','208','1038',479,'Retail Sale Id 1629009',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 13:37:42','',''),(2635805,'1','208','1038',479,'Retail Sale Id 1629034',999.68,0.00,0.00,1.76,72.16,'2022-01-29 13:38:55','',''),(2635822,'1','208','1038',479,'Retail Sale Id 1629058',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 13:40:05','',''),(2635858,'1','208','1038',479,'Retail Sale Id 1629103',4998.40,0.00,0.00,8.80,360.80,'2022-01-29 13:42:41','',''),(2635922,'1','208','1038',479,'Retail Sale Id 1629172',1147.36,0.00,0.00,2.02,82.82,'2022-01-29 13:48:39','',''),(2635938,'1','208','1038',479,'Retail Sale Id 1629195',568.00,0.00,0.00,1.00,41.00,'2022-01-29 13:50:56','',''),(2635945,'1','208','1038',479,'Retail Sale Id 1629201',5702.72,0.00,0.00,10.04,411.64,'2022-01-29 13:51:22','',''),(2636020,'1','208','1038',479,'Retail Sale Id 1629278',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 13:58:48','',''),(2636122,'1','208','1038',479,'Retail Sale Id 1629345',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 14:04:56','',''),(2636148,'1','208','1038',479,'Retail Sale Id 1629360',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 14:06:24','',''),(2636186,'1','208','1038',479,'Retail Sale Id 1629381',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 14:08:52','',''),(2636202,'1','208','1038',479,'Retail Sale Id 1629403',698.64,0.00,0.00,1.23,50.43,'2022-01-29 14:10:28','',''),(2636240,'1','208','1038',479,'Retail Sale Id 1629441',1698.32,0.00,0.00,2.99,122.59,'2022-01-29 14:13:33','',''),(2636241,'1','208','1038',479,'Retail Sale Id 1629441',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 14:13:33','',''),(2636295,'1','208','1038',479,'Retail Sale Id 1629472',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 14:16:10','',''),(2636418,'1','208','1038',479,'Retail Sale Id 1629581',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 14:25:14','',''),(2636452,'1','208','1038',479,'Retail Sale Id 1629615',2999.04,0.00,0.00,5.28,216.48,'2022-01-29 14:27:53','',''),(2636470,'1','208','1038',479,'Retail Sale Id 1629632',1698.32,0.00,0.00,2.99,122.59,'2022-01-29 14:29:13','',''),(2636482,'1','208','1038',479,'Retail Sale Id 1629644',4998.40,0.00,0.00,8.80,360.80,'2022-01-29 14:30:30','',''),(2636796,'1','208','1038',479,'Retail Sale Id 1629871',2840.00,0.00,0.00,5.00,205.00,'2022-01-29 14:48:00','',''),(2636831,'1','208','1038',479,'Retail Sale Id 1629880',1147.36,0.00,0.00,2.02,82.82,'2022-01-29 14:49:02','',''),(2636854,'1','208','1038',479,'Retail Sale Id 1629896',2840.00,0.00,0.00,5.00,205.00,'2022-01-29 14:50:38','',''),(2637193,'1','208','1038',479,'Retail Sale Id 1630151',1749.44,0.00,0.00,3.08,126.28,'2022-01-29 15:13:05','',''),(2637194,'1','208','1038',479,'Retail Sale Id 1630151',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 15:13:05','',''),(2637377,'1','208','1038',479,'Retail Sale Id 1630306',7497.60,0.00,0.00,13.20,541.20,'2022-01-29 15:24:40','',''),(2637518,'1','208','1038',479,'Retail Sale Id 1630449',1999.36,0.00,0.00,3.52,144.32,'2022-01-29 15:35:37','',''),(2637543,'1','208','1038',479,'Retail Sale Id 1630474',3408.00,0.00,0.00,6.00,246.00,'2022-01-29 15:37:40','',''),(2637584,'1','208','1038',479,'Retail Sale Id 1630507',5702.72,0.00,0.00,10.04,411.64,'2022-01-29 15:40:48','',''),(2637669,'1','208','1038',479,'Retail Sale Id 1630595',1999.36,0.00,0.00,3.52,144.32,'2022-01-29 15:49:06','',''),(2637703,'1','208','1038',479,'Retail Sale Id 1630626',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 15:51:39','',''),(2637766,'1','208','1038',479,'Retail Sale Id 1630697',1749.44,0.00,0.00,3.08,126.28,'2022-01-29 15:57:24','',''),(2637785,'1','208','1038',479,'Retail Sale Id 1630720',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 15:59:34','',''),(2637875,'1','208','1038',479,'Retail Sale Id 1630805',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 16:07:49','',''),(2637959,'1','208','1038',479,'Retail Sale Id 1630883',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 16:16:57','',''),(2638069,'1','208','1038',479,'Retail Sale Id 1630978',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 16:26:14','',''),(2638205,'1','208','1038',479,'Retail Sale Id 1631091',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 16:35:53','',''),(2638223,'1','208','1038',479,'Retail Sale Id 1631108',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 16:37:16','',''),(2638238,'1','208','1038',479,'Retail Sale Id 1631136',3408.00,0.00,0.00,6.00,246.00,'2022-01-29 16:38:38','',''),(2638251,'1','208','1038',479,'Retail Sale Id 1631149',2300.40,0.00,0.00,4.05,166.05,'2022-01-29 16:39:54','',''),(2638347,'1','208','1038',479,'Retail Sale Id 1631229',5998.08,0.00,0.00,10.56,432.96,'2022-01-29 16:46:30','',''),(2638432,'1','208','1038',479,'Retail Sale Id 1631269',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 16:50:46','',''),(2638660,'1','208','1038',479,'Retail Sale Id 1631517',2999.04,0.00,0.00,5.28,216.48,'2022-01-29 17:07:57','',''),(2638715,'1','208','1038',479,'Retail Sale Id 1631573',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 17:12:46','',''),(2638736,'1','208','1038',479,'Retail Sale Id 1631594',3408.00,0.00,0.00,6.00,246.00,'2022-01-29 17:14:22','',''),(2638863,'1','208','1038',479,'Retail Sale Id 1631673',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 17:21:50','',''),(2639165,'1','208','1038',479,'Retail Sale Id 1631949',2499.20,0.00,0.00,4.40,180.40,'2022-01-29 17:47:23','',''),(2639224,'1','208','1038',479,'Retail Sale Id 1632003',4498.56,0.00,0.00,7.92,324.72,'2022-01-29 17:51:19','',''),(2639238,'1','208','1038',479,'Retail Sale Id 1632016',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 17:52:33','',''),(2639247,'1','208','1038',479,'Retail Sale Id 1632029',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 17:53:32','',''),(2639248,'1','208','1038',479,'Retail Sale Id 1632029',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 17:53:32','',''),(2639257,'1','208','1038',479,'Retail Sale Id 1632039',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 17:54:15','',''),(2639264,'1','208','1038',479,'Retail Sale Id 1632051',999.68,0.00,0.00,1.76,72.16,'2022-01-29 17:55:03','',''),(2639279,'1','208','1038',479,'Retail Sale Id 1632064',1499.52,0.00,0.00,2.64,108.24,'2022-01-29 17:55:45','',''),(2639288,'1','208','1038',479,'Retail Sale Id 1632074',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 17:56:32','',''),(2639301,'1','208','1038',479,'Retail Sale Id 1632085',2300.40,0.00,0.00,4.05,166.05,'2022-01-29 17:57:35','',''),(2639548,'1','208','1038',479,'Retail Sale Id 1632310',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 18:19:55','',''),(2639569,'1','208','1038',479,'Retail Sale Id 1632337',1499.52,0.00,0.00,2.64,108.24,'2022-01-29 18:23:12','',''),(2639594,'1','208','1038',479,'Retail Sale Id 1632370',1749.44,0.00,0.00,3.08,126.28,'2022-01-29 18:27:36','',''),(2639617,'1','208','1038',479,'Retail Sale Id 1632386',2851.36,0.00,0.00,5.02,205.82,'2022-01-29 18:28:49','',''),(2639656,'1','208','1038',479,'Retail Sale Id 1632416',499.84,0.00,0.00,0.88,36.08,'2022-01-29 18:32:01','',''),(2639664,'1','208','1038',479,'Retail Sale Id 1632425',7100.00,0.00,0.00,12.50,512.50,'2022-01-29 18:32:59','',''),(2639683,'1','208','1038',479,'Retail Sale Id 1632442',1749.44,0.00,0.00,3.08,126.28,'2022-01-29 18:35:37','',''),(2639898,'1','208','1038',479,'Retail Sale Id 1632569',3408.00,0.00,0.00,6.00,246.00,'2022-01-29 18:55:35','',''),(2639924,'1','208','1038',479,'Retail Sale Id 1632586',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 18:56:57','',''),(2639994,'1','208','1038',479,'Retail Sale Id 1632666',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 19:05:20','',''),(2640064,'1','208','1038',479,'Retail Sale Id 1632731',2999.04,0.00,0.00,5.28,216.48,'2022-01-29 19:14:42','',''),(2640120,'1','208','1038',479,'Retail Sale Id 1632780',1999.36,0.00,0.00,3.52,144.32,'2022-01-29 19:22:41','',''),(2640184,'1','208','1038',479,'Retail Sale Id 1632817',3498.88,0.00,0.00,6.16,252.56,'2022-01-29 19:31:46','',''),(2640207,'1','208','1038',479,'Retail Sale Id 1632839',5702.72,0.00,0.00,10.04,411.64,'2022-01-29 19:36:23','',''),(2640271,'1','208','1038',479,'Retail Sale Id 1632865',2851.36,0.00,0.00,5.02,205.82,'2022-01-29 19:45:44','',''),(2640275,'1','208','1038',479,'Retail Sale Id 1632870',9479.92,0.00,0.00,16.69,684.29,'2022-01-29 19:47:35','',''),(2640279,'1','208','1038',479,'Retail Sale Id 1632874',14097.76,0.00,0.00,24.82,1017.62,'2022-01-29 19:48:52','',''),(2640282,'1','208','1038',479,'Retail Sale Id 1632878',11899.60,0.00,0.00,20.95,858.95,'2022-01-29 19:49:57','',''),(2640415,'1','208','1038',479,'Return of Retail Sale Id 1632051',0.00,999.68,1.76,0.00,-72.16,'2022-01-29 21:00:28','',''),(2640425,'1','208','1038',479,'Retail Sale Id 1633010',999.68,0.00,0.00,1.76,72.16,'2022-01-29 21:05:16','',''),(2640438,'1','208','1038',479,'Return of Retail Sale Id 1632780',0.00,1999.36,3.52,0.00,-144.32,'2022-01-29 21:10:31','',''),(2640617,'1','208','1038',479,'Retail Sale Id 1633026',1999.36,0.00,0.00,3.52,144.32,'2022-01-29 22:55:12','',''),(2640620,'1','208','1038',479,'Return of Retail Sale Id 1632870',0.00,9479.92,16.69,0.00,-684.29,'2022-01-29 23:02:18','',''),(2640622,'1','208','1038',479,'Return of Retail Sale Id 1631594',0.00,3408.00,6.00,0.00,-246.00,'2022-01-29 23:05:35','',''),(2640655,'1','208','1038',479,'Return of Retail Sale Id 1633010',0.00,999.68,1.76,0.00,-72.16,'2022-01-29 23:43:06','',''),(2640656,'1','208','1038',479,'Return of Retail Sale Id 1633026',0.00,1999.36,3.52,0.00,-144.32,'2022-01-29 23:45:32','',''),(2640667,'1','208','1038',479,'Return of Retail Sale Id 1631136',0.00,3408.00,6.00,0.00,-246.00,'2022-01-29 23:48:15','',''),(2640670,'1','208','1038',479,'Return of Retail Sale Id 1632416',0.00,499.84,0.88,0.00,-36.08,'2022-01-29 23:51:42','',''),(2640671,'1','208','1038',479,'Return of Retail Sale Id 1629871',0.00,2840.00,5.00,0.00,-205.00,'2022-01-29 23:52:55','',''),(2640672,'1','208','1038',479,'Return of Retail Sale Id 1627538',0.00,7100.00,12.50,0.00,-512.50,'2022-01-29 23:54:39','',''),(2640673,'1','208','1038',479,'Retail Sale Id 1633033',11979.12,0.00,0.00,21.09,864.69,'2022-01-30 00:00:52','',''),(2640674,'1','208','1038',479,'Retail Sale Id 1633034',6554.72,0.00,0.00,11.54,473.14,'2022-01-30 00:02:50','',''),(2640675,'1','208','1038',479,'Retail Sale Id 1633035',6537.68,0.00,0.00,11.51,471.91,'2022-01-30 00:04:34','',''),(2640676,'1','208','1038',479,'Retail Sale Id 1633036',3839.68,0.00,0.00,6.76,277.16,'2022-01-30 00:06:01','',''),(2640899,'1','208','1038',479,'Retail Sale Id 1633146',5998.08,0.00,0.00,10.56,432.96,'2022-01-30 07:47:05','',''),(2640932,'1','208','1038',479,'Retail Sale Id 1633164',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 07:49:51','',''),(2640944,'1','208','1038',479,'Retail Sale Id 1633172',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 07:50:48','',''),(2641574,'1','208','1038',479,'Retail Sale Id 1633773',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 08:45:08','',''),(2641660,'1','208','1038',479,'Retail Sale Id 1633851',3402.32,0.00,0.00,5.99,245.59,'2022-01-30 08:51:03','',''),(2641691,'1','208','1038',479,'Retail Sale Id 1633881',3402.32,0.00,0.00,5.99,245.59,'2022-01-30 08:53:03','',''),(2641692,'1','208','1038',479,'Retail Sale Id 1633881',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 08:53:03','',''),(2641721,'1','208','1038',479,'Retail Sale Id 1633909',4998.40,0.00,0.00,8.80,360.80,'2022-01-30 08:55:14','',''),(2641732,'1','208','1038',479,'Retail Sale Id 1633923',4998.40,0.00,0.00,8.80,360.80,'2022-01-30 08:56:27','',''),(2641867,'1','208','1038',479,'Retail Sale Id 1634046',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 09:10:03','',''),(2641868,'1','208','1038',479,'Retail Sale Id 1634046',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 09:10:03','',''),(2641869,'1','208','1038',479,'Retail Sale Id 1634046',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 09:10:03','',''),(2641994,'1','208','1038',479,'Retail Sale Id 1634162',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 09:19:21','',''),(2642056,'1','208','1038',479,'Retail Sale Id 1634225',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 09:23:48','',''),(2642282,'1','208','1038',479,'Retail Sale Id 1634433',1198.48,0.00,0.00,2.11,86.51,'2022-01-30 09:37:19','',''),(2642313,'1','208','1038',479,'Retail Sale Id 1634461',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 09:38:39','',''),(2642369,'1','208','1038',479,'Retail Sale Id 1634521',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 09:43:17','',''),(2642451,'1','208','1038',479,'Retail Sale Id 1634597',2840.00,0.00,0.00,5.00,205.00,'2022-01-30 09:50:54','',''),(2642841,'1','208','1038',479,'Retail Sale Id 1634966',1999.36,0.00,0.00,3.52,144.32,'2022-01-30 10:17:51','',''),(2642855,'1','208','1038',479,'Retail Sale Id 1634979',999.68,0.00,0.00,1.76,72.16,'2022-01-30 10:18:48','',''),(2642868,'1','208','1038',479,'Retail Sale Id 1634996',698.64,0.00,0.00,1.23,50.43,'2022-01-30 10:19:30','',''),(2642887,'1','208','1038',479,'Retail Sale Id 1635017',1698.32,0.00,0.00,2.99,122.59,'2022-01-30 10:20:34','',''),(2642963,'1','208','1038',479,'Retail Sale Id 1635077',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 10:24:44','',''),(2643046,'1','208','1038',479,'Retail Sale Id 1635160',2800.24,0.00,0.00,4.93,202.13,'2022-01-30 10:30:09','',''),(2643161,'1','208','1038',479,'Retail Sale Id 1635272',1999.36,0.00,0.00,3.52,144.32,'2022-01-30 10:36:55','',''),(2643286,'1','208','1038',479,'Retail Sale Id 1635360',1999.36,0.00,0.00,3.52,144.32,'2022-01-30 10:42:20','',''),(2643306,'1','208','1038',479,'Retail Sale Id 1635378',5680.00,0.00,0.00,10.00,410.00,'2022-01-30 10:43:43','',''),(2643449,'1','208','1038',479,'Retail Sale Id 1635480',28400.00,0.00,0.00,50.00,2050.00,'2022-01-30 10:49:48','',''),(2643473,'1','208','1038',479,'Retail Sale Id 1635502',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 10:50:51','',''),(2643554,'1','208','1038',479,'Retail Sale Id 1635587',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 10:56:39','',''),(2643860,'1','208','1038',479,'Retail Sale Id 1635883',2851.36,0.00,0.00,5.02,205.82,'2022-01-30 11:18:34','',''),(2643919,'1','208','1038',479,'Retail Sale Id 1635921',999.68,0.00,0.00,1.76,72.16,'2022-01-30 11:21:21','',''),(2643967,'1','208','1038',479,'Retail Sale Id 1635961',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 11:24:07','',''),(2643996,'1','208','1038',479,'Retail Sale Id 1635976',499.84,0.00,0.00,0.88,36.08,'2022-01-30 11:25:08','',''),(2644048,'1','208','1038',479,'Retail Sale Id 1635999',2902.48,0.00,0.00,5.11,209.51,'2022-01-30 11:26:37','',''),(2644065,'1','208','1038',479,'Retail Sale Id 1636015',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 11:27:54','',''),(2644083,'1','208','1038',479,'Retail Sale Id 1636027',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 11:28:50','',''),(2644156,'1','208','1038',479,'Retail Sale Id 1636081',28400.00,0.00,0.00,50.00,2050.00,'2022-01-30 11:33:12','',''),(2644211,'1','208','1038',479,'Retail Sale Id 1636145',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 11:37:04','',''),(2644329,'1','208','1038',479,'Retail Sale Id 1636263',999.68,0.00,0.00,1.76,72.16,'2022-01-30 11:43:00','',''),(2644530,'1','208','1038',479,'Retail Sale Id 1636448',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 11:55:44','',''),(2644531,'1','208','1038',479,'Retail Sale Id 1636448',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 11:55:44','',''),(2644532,'1','208','1038',479,'Retail Sale Id 1636448',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 11:55:44','',''),(2644533,'1','208','1038',479,'Retail Sale Id 1636448',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 11:55:44','',''),(2644552,'1','208','1038',479,'Retail Sale Id 1636461',5998.08,0.00,0.00,10.56,432.96,'2022-01-30 11:56:56','',''),(2644569,'1','208','1038',479,'Retail Sale Id 1636485',999.68,0.00,0.00,1.76,72.16,'2022-01-30 11:57:56','',''),(2644619,'1','208','1038',479,'Retail Sale Id 1636539',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 12:00:54','',''),(2644638,'1','208','1038',479,'Retail Sale Id 1636559',3998.72,0.00,0.00,7.04,288.64,'2022-01-30 12:02:01','',''),(2644740,'1','208','1038',479,'Retail Sale Id 1636629',397.60,0.00,0.00,0.70,28.70,'2022-01-30 12:07:15','',''),(2644821,'1','208','1038',479,'Retail Sale Id 1636715',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 12:11:19','',''),(2644841,'1','208','1038',479,'Retail Sale Id 1636731',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 12:12:21','',''),(2644863,'1','208','1038',479,'Retail Sale Id 1636753',1704.00,0.00,0.00,3.00,123.00,'2022-01-30 12:13:39','',''),(2644893,'1','208','1038',479,'Retail Sale Id 1636787',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 12:16:06','',''),(2644907,'1','208','1038',479,'Retail Sale Id 1636801',1397.28,0.00,0.00,2.46,100.86,'2022-01-30 12:17:08','',''),(2644926,'1','208','1038',479,'Retail Sale Id 1636821',2499.20,0.00,0.00,4.40,180.40,'2022-01-30 12:18:26','',''),(2645015,'1','208','1038',479,'Retail Sale Id 1636887',1704.00,0.00,0.00,3.00,123.00,'2022-01-30 12:23:08','',''),(2645089,'1','208','1038',479,'Retail Sale Id 1636955',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 12:27:07','',''),(2645241,'1','208','1038',479,'Retail Sale Id 1637107',2851.36,0.00,0.00,5.02,205.82,'2022-01-30 12:36:01','',''),(2645299,'1','208','1038',479,'Retail Sale Id 1637163',2499.20,0.00,0.00,4.40,180.40,'2022-01-30 12:39:48','',''),(2645300,'1','208','1038',479,'Retail Sale Id 1637163',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 12:39:48','',''),(2645301,'1','208','1038',479,'Retail Sale Id 1637163',3998.72,0.00,0.00,7.04,288.64,'2022-01-30 12:39:48','',''),(2645302,'1','208','1038',479,'Retail Sale Id 1637163',3998.72,0.00,0.00,7.04,288.64,'2022-01-30 12:39:48','',''),(2645303,'1','208','1038',479,'Retail Sale Id 1637163',3998.72,0.00,0.00,7.04,288.64,'2022-01-30 12:39:48','',''),(2645314,'1','208','1038',479,'Retail Sale Id 1637181',698.64,0.00,0.00,1.23,50.43,'2022-01-30 12:40:38','',''),(2645332,'1','208','1038',479,'Retail Sale Id 1637198',1704.00,0.00,0.00,3.00,123.00,'2022-01-30 12:41:53','',''),(2645378,'1','208','1038',479,'Retail Sale Id 1637217',999.68,0.00,0.00,1.76,72.16,'2022-01-30 12:43:01','',''),(2645379,'1','208','1038',479,'Retail Sale Id 1637217',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 12:43:01','',''),(2645688,'1','208','1038',479,'Retail Sale Id 1637419',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 12:55:30','',''),(2645689,'1','208','1038',479,'Retail Sale Id 1637419',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 12:55:30','',''),(2645727,'1','208','1038',479,'Retail Sale Id 1637460',800.88,0.00,0.00,1.41,57.81,'2022-01-30 12:58:47','',''),(2645811,'1','208','1038',479,'Retail Sale Id 1637545',1698.32,0.00,0.00,2.99,122.59,'2022-01-30 13:04:24','',''),(2645833,'1','208','1038',479,'Retail Sale Id 1637565',6997.76,0.00,0.00,12.32,505.12,'2022-01-30 13:05:34','',''),(2645848,'1','208','1038',479,'Retail Sale Id 1637580',1198.48,0.00,0.00,2.11,86.51,'2022-01-30 13:06:32','',''),(2645861,'1','208','1038',479,'Retail Sale Id 1637589',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 13:07:26','',''),(2645940,'1','208','1038',479,'Retail Sale Id 1637656',1198.48,0.00,0.00,2.11,86.51,'2022-01-30 13:13:05','',''),(2646065,'1','208','1038',479,'Retail Sale Id 1637768',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 13:19:51','',''),(2646104,'1','208','1038',479,'Retail Sale Id 1637806',1704.00,0.00,0.00,3.00,123.00,'2022-01-30 13:22:37','',''),(2646197,'1','208','1038',479,'Retail Sale Id 1637899',1499.52,0.00,0.00,2.64,108.24,'2022-01-30 13:28:23','',''),(2646234,'1','208','1038',479,'Retail Sale Id 1637935',999.68,0.00,0.00,1.76,72.16,'2022-01-30 13:30:17','',''),(2646281,'1','208','1038',479,'Retail Sale Id 1637971',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 13:32:39','',''),(2646357,'1','208','1038',479,'Retail Sale Id 1638043',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 13:37:23','',''),(2646367,'1','208','1038',479,'Retail Sale Id 1638051',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 13:38:16','',''),(2646380,'1','208','1038',479,'Retail Sale Id 1638065',6997.76,0.00,0.00,12.32,505.12,'2022-01-30 13:39:13','',''),(2646401,'1','208','1038',479,'Retail Sale Id 1638077',2272.00,0.00,0.00,4.00,164.00,'2022-01-30 13:40:36','',''),(2646402,'1','208','1038',479,'Retail Sale Id 1638077',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 13:40:36','',''),(2646417,'1','208','1038',479,'Retail Sale Id 1638098',999.68,0.00,0.00,1.76,72.16,'2022-01-30 13:41:30','',''),(2646439,'1','208','1038',479,'Retail Sale Id 1638119',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 13:43:08','',''),(2646468,'1','208','1038',479,'Retail Sale Id 1638158',3402.32,0.00,0.00,5.99,245.59,'2022-01-30 13:45:23','',''),(2646622,'1','208','1038',479,'Retail Sale Id 1638327',1499.52,0.00,0.00,2.64,108.24,'2022-01-30 13:57:16','',''),(2646645,'1','208','1038',479,'Retail Sale Id 1638350',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 13:59:26','',''),(2646656,'1','208','1038',479,'Retail Sale Id 1638363',4998.40,0.00,0.00,8.80,360.80,'2022-01-30 14:00:40','',''),(2646657,'1','208','1038',479,'Retail Sale Id 1638363',4998.40,0.00,0.00,8.80,360.80,'2022-01-30 14:00:40','',''),(2646791,'1','208','1038',479,'Retail Sale Id 1638483',4544.00,0.00,0.00,8.00,328.00,'2022-01-30 14:10:51','',''),(2646792,'1','208','1038',479,'Retail Sale Id 1638483',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 14:10:51','',''),(2646913,'1','208','1038',479,'Retail Sale Id 1638589',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 14:20:32','',''),(2646951,'1','208','1038',479,'Retail Sale Id 1638628',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 14:23:36','',''),(2646971,'1','208','1038',479,'Retail Sale Id 1638641',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 14:24:43','',''),(2646989,'1','208','1038',479,'Retail Sale Id 1638659',1999.36,0.00,0.00,3.52,144.32,'2022-01-30 14:26:32','',''),(2647023,'1','208','1038',479,'Retail Sale Id 1638686',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 14:28:56','',''),(2647149,'1','208','1038',479,'Retail Sale Id 1638810',23998.00,0.00,0.00,42.25,1732.25,'2022-01-30 14:38:57','',''),(2647163,'1','208','1038',479,'Retail Sale Id 1638823',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 14:39:51','',''),(2647192,'1','208','1038',479,'Retail Sale Id 1638853',2840.00,0.00,0.00,5.00,205.00,'2022-01-30 14:42:22','',''),(2647227,'1','208','1038',479,'Retail Sale Id 1638877',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 14:44:32','',''),(2647259,'1','208','1038',479,'Retail Sale Id 1638896',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 14:46:03','',''),(2647312,'1','208','1038',479,'Retail Sale Id 1638922',4998.40,0.00,0.00,8.80,360.80,'2022-01-30 14:48:32','',''),(2647324,'1','208','1038',479,'Retail Sale Id 1638937',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 14:49:22','',''),(2647345,'1','208','1038',479,'Retail Sale Id 1638953',1704.00,0.00,0.00,3.00,123.00,'2022-01-30 14:51:22','',''),(2647360,'1','208','1038',479,'Retail Sale Id 1638970',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 14:53:01','',''),(2647372,'1','208','1038',479,'Retail Sale Id 1638982',999.68,0.00,0.00,1.76,72.16,'2022-01-30 14:53:57','',''),(2647573,'1','208','1038',479,'Retail Sale Id 1639173',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 15:08:05','',''),(2647729,'1','208','1038',479,'Retail Sale Id 1639290',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 15:17:48','',''),(2647738,'1','208','1038',479,'Retail Sale Id 1639304',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 15:18:41','',''),(2647750,'1','208','1038',479,'Retail Sale Id 1639316',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 15:19:52','',''),(2647787,'1','208','1038',479,'Retail Sale Id 1639351',1698.32,0.00,0.00,2.99,122.59,'2022-01-30 15:23:15','',''),(2647801,'1','208','1038',479,'Retail Sale Id 1639363',2840.00,0.00,0.00,5.00,205.00,'2022-01-30 15:24:23','',''),(2647834,'1','208','1038',479,'Retail Sale Id 1639383',1499.52,0.00,0.00,2.64,108.24,'2022-01-30 15:25:42','',''),(2648195,'1','208','1038',479,'Retail Sale Id 1639611',1704.00,0.00,0.00,3.00,123.00,'2022-01-30 15:40:39','',''),(2648307,'1','208','1038',479,'Retail Sale Id 1639720',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 15:50:09','',''),(2648330,'1','208','1038',479,'Retail Sale Id 1639744',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 15:52:14','',''),(2648380,'1','208','1038',479,'Retail Sale Id 1639797',1499.52,0.00,0.00,2.64,108.24,'2022-01-30 15:56:50','',''),(2648575,'1','208','1038',479,'Retail Sale Id 1639985',4998.40,0.00,0.00,8.80,360.80,'2022-01-30 16:13:19','',''),(2648588,'1','208','1038',479,'Retail Sale Id 1640004',2840.00,0.00,0.00,5.00,205.00,'2022-01-30 16:14:51','',''),(2648692,'1','208','1038',479,'Retail Sale Id 1640092',999.68,0.00,0.00,1.76,72.16,'2022-01-30 16:22:32','',''),(2648823,'1','208','1038',479,'Retail Sale Id 1640219',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 16:34:56','',''),(2648838,'1','208','1038',479,'Retail Sale Id 1640233',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 16:35:44','',''),(2648943,'1','208','1038',479,'Retail Sale Id 1640370',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 16:44:11','',''),(2649127,'1','208','1038',479,'Retail Sale Id 1640531',7384.00,0.00,0.00,13.00,533.00,'2022-01-30 16:55:35','',''),(2649140,'1','208','1038',479,'Retail Sale Id 1640551',6997.76,0.00,0.00,12.32,505.12,'2022-01-30 16:56:39','',''),(2649158,'1','208','1038',479,'Retail Sale Id 1640567',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 16:57:45','',''),(2649192,'1','208','1038',479,'Retail Sale Id 1640601',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 17:00:12','',''),(2649213,'1','208','1038',479,'Retail Sale Id 1640623',5680.00,0.00,0.00,10.00,410.00,'2022-01-30 17:02:08','',''),(2649257,'1','208','1038',479,'Retail Sale Id 1640651',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 17:03:55','',''),(2649291,'1','208','1038',479,'Retail Sale Id 1640687',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 17:06:25','',''),(2649342,'1','208','1038',479,'Retail Sale Id 1640741',1749.44,0.00,0.00,3.08,126.28,'2022-01-30 17:10:15','',''),(2649356,'1','208','1038',479,'Retail Sale Id 1640757',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 17:11:15','',''),(2649369,'1','208','1038',479,'Retail Sale Id 1640770',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 17:12:26','',''),(2649386,'1','208','1038',479,'Retail Sale Id 1640779',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 17:13:37','',''),(2649402,'1','208','1038',479,'Retail Sale Id 1640798',1999.36,0.00,0.00,3.52,144.32,'2022-01-30 17:15:02','',''),(2649443,'1','208','1038',479,'Retail Sale Id 1640840',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 17:18:21','',''),(2649490,'1','208','1038',479,'Retail Sale Id 1640886',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 17:22:22','',''),(2649505,'1','208','1038',479,'Retail Sale Id 1640898',1698.32,0.00,0.00,2.99,122.59,'2022-01-30 17:23:28','',''),(2649598,'1','208','1038',479,'Retail Sale Id 1640987',3402.32,0.00,0.00,5.99,245.59,'2022-01-30 17:33:17','',''),(2649606,'1','208','1038',479,'Retail Sale Id 1640999',1198.48,0.00,0.00,2.11,86.51,'2022-01-30 17:34:21','',''),(2649614,'1','208','1038',479,'Retail Sale Id 1641005',5498.24,0.00,0.00,9.68,396.88,'2022-01-30 17:35:13','',''),(2649668,'1','208','1038',479,'Retail Sale Id 1641067',999.68,0.00,0.00,1.76,72.16,'2022-01-30 17:40:26','',''),(2649713,'1','208','1038',479,'Retail Sale Id 1641085',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 17:42:06','',''),(2649745,'1','208','1038',479,'Retail Sale Id 1641102',999.68,0.00,0.00,1.76,72.16,'2022-01-30 17:43:36','',''),(2649845,'1','208','1038',479,'Retail Sale Id 1641177',5600.48,0.00,0.00,9.86,404.26,'2022-01-30 17:51:29','',''),(2649856,'1','208','1038',479,'Retail Sale Id 1641199',3447.76,0.00,0.00,6.07,248.87,'2022-01-30 17:52:51','',''),(2649869,'1','208','1038',479,'Retail Sale Id 1641209',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 17:54:19','',''),(2649894,'1','208','1038',479,'Retail Sale Id 1641236',3402.32,0.00,0.00,5.99,245.59,'2022-01-30 17:56:37','',''),(2649915,'1','208','1038',479,'Retail Sale Id 1641255',1499.52,0.00,0.00,2.64,108.24,'2022-01-30 17:58:08','',''),(2649944,'1','208','1038',479,'Retail Sale Id 1641289',5680.00,0.00,0.00,10.00,410.00,'2022-01-30 18:01:08','',''),(2649978,'1','208','1038',479,'Retail Sale Id 1641320',1698.32,0.00,0.00,2.99,122.59,'2022-01-30 18:03:41','',''),(2650010,'1','208','1038',479,'Retail Sale Id 1641357',3402.32,0.00,0.00,5.99,245.59,'2022-01-30 18:06:21','',''),(2650011,'1','208','1038',479,'Retail Sale Id 1641357',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 18:06:21','',''),(2650045,'1','208','1038',479,'Retail Sale Id 1641441',3408.00,0.00,0.00,6.00,246.00,'2022-01-30 18:09:13','',''),(2650059,'1','208','1038',479,'Retail Sale Id 1641457',852.00,0.00,0.00,1.50,61.50,'2022-01-30 18:11:00','',''),(2650060,'1','208','1038',479,'Retail Sale Id 1641457',1704.00,0.00,0.00,3.00,123.00,'2022-01-30 18:11:00','',''),(2650084,'1','208','1038',479,'Retail Sale Id 1641485',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 18:13:45','',''),(2650098,'1','208','1038',479,'Retail Sale Id 1641502',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 18:15:41','',''),(2650113,'1','208','1038',479,'Retail Sale Id 1641517',1704.00,0.00,0.00,3.00,123.00,'2022-01-30 18:17:03','',''),(2650146,'1','208','1038',479,'Retail Sale Id 1641545',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 18:22:41','',''),(2650147,'1','208','1038',479,'Retail Sale Id 1641545',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 18:22:41','',''),(2650160,'1','208','1038',479,'Retail Sale Id 1641561',999.68,0.00,0.00,1.76,72.16,'2022-01-30 18:23:40','',''),(2650179,'1','208','1038',479,'Retail Sale Id 1641578',3402.32,0.00,0.00,5.99,245.59,'2022-01-30 18:25:06','',''),(2650188,'1','208','1038',479,'Retail Sale Id 1641587',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 18:26:06','',''),(2650226,'1','208','1038',479,'Retail Sale Id 1641619',1704.00,0.00,0.00,3.00,123.00,'2022-01-30 18:32:09','',''),(2650227,'1','208','1038',479,'Retail Sale Id 1641619',2840.00,0.00,0.00,5.00,205.00,'2022-01-30 18:32:09','',''),(2650239,'1','208','1038',479,'Retail Sale Id 1641630',2851.36,0.00,0.00,5.02,205.82,'2022-01-30 18:34:40','',''),(2650244,'1','208','1038',479,'Retail Sale Id 1641634',1300.72,0.00,0.00,2.29,93.89,'2022-01-30 18:35:31','',''),(2650251,'1','208','1038',479,'Retail Sale Id 1641644',2851.36,0.00,0.00,5.02,205.82,'2022-01-30 18:37:08','',''),(2650255,'1','208','1038',479,'Retail Sale Id 1641649',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 18:37:53','',''),(2650263,'1','208','1038',479,'Retail Sale Id 1641654',999.68,0.00,0.00,1.76,72.16,'2022-01-30 18:38:49','',''),(2650277,'1','208','1038',479,'Retail Sale Id 1641664',1198.48,0.00,0.00,2.11,86.51,'2022-01-30 18:39:34','',''),(2650282,'1','208','1038',479,'Retail Sale Id 1641669',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 18:40:24','',''),(2650286,'1','208','1038',479,'Retail Sale Id 1641674',1499.52,0.00,0.00,2.64,108.24,'2022-01-30 18:41:21','',''),(2650287,'1','208','1038',479,'Retail Sale Id 1641674',1499.52,0.00,0.00,2.64,108.24,'2022-01-30 18:41:21','',''),(2650294,'1','208','1038',479,'Retail Sale Id 1641675',1698.32,0.00,0.00,2.99,122.59,'2022-01-30 18:42:22','',''),(2650297,'1','208','1038',479,'Retail Sale Id 1641678',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 18:43:06','',''),(2650359,'1','208','1038',479,'Retail Sale Id 1641696',3402.32,0.00,0.00,5.99,245.59,'2022-01-30 18:50:13','',''),(2650425,'1','208','1038',479,'Retail Sale Id 1641709',7100.00,0.00,0.00,12.50,512.50,'2022-01-30 18:57:47','',''),(2650434,'1','208','1038',479,'Retail Sale Id 1641716',999.68,0.00,0.00,1.76,72.16,'2022-01-30 18:58:41','',''),(2650442,'1','208','1038',479,'Retail Sale Id 1641719',2499.20,0.00,0.00,4.40,180.40,'2022-01-30 18:59:49','',''),(2650443,'1','208','1038',479,'Retail Sale Id 1641719',2499.20,0.00,0.00,4.40,180.40,'2022-01-30 18:59:49','',''),(2650445,'1','208','1038',479,'Retail Sale Id 1641721',4998.40,0.00,0.00,8.80,360.80,'2022-01-30 19:01:00','',''),(2650447,'1','208','1038',479,'Retail Sale Id 1641723',999.68,0.00,0.00,1.76,72.16,'2022-01-30 19:02:27','',''),(2650448,'1','208','1038',479,'Retail Sale Id 1641724',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 19:03:15','',''),(2650449,'1','208','1038',479,'Retail Sale Id 1641725',3998.72,0.00,0.00,7.04,288.64,'2022-01-30 19:04:09','',''),(2650465,'1','208','1038',479,'Retail Sale Id 1641728',2499.20,0.00,0.00,4.40,180.40,'2022-01-30 19:10:46','',''),(2650466,'1','208','1038',479,'Retail Sale Id 1641728',2499.20,0.00,0.00,4.40,180.40,'2022-01-30 19:10:46','',''),(2650469,'1','208','1038',479,'Retail Sale Id 1641729',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 19:12:23','',''),(2650470,'1','208','1038',479,'Retail Sale Id 1641729',3498.88,0.00,0.00,6.16,252.56,'2022-01-30 19:12:23','',''),(2650478,'1','208','1038',479,'Retail Sale Id 1641733',1999.36,0.00,0.00,3.52,144.32,'2022-01-30 19:14:46','',''),(2650482,'1','208','1038',479,'Retail Sale Id 1641736',2800.24,0.00,0.00,4.93,202.13,'2022-01-30 19:16:43','',''),(2650488,'1','208','1038',479,'Retail Sale Id 1641751',3998.72,0.00,0.00,7.04,288.64,'2022-01-30 19:23:52','',''),(2650506,'1','208','1038',479,'Retail Sale Id 1641758',2999.04,0.00,0.00,5.28,216.48,'2022-01-30 19:24:57','',''),(2650527,'1','208','1038',479,'Retail Sale Id 1641765',2300.40,0.00,0.00,4.05,166.05,'2022-01-30 19:30:45','',''),(2650534,'1','208','1038',479,'Retail Sale Id 1641768',1999.36,0.00,0.00,3.52,144.32,'2022-01-30 19:31:31','',''),(2650535,'1','208','1038',479,'Retail Sale Id 1641770',42043.36,0.00,0.00,74.02,3034.82,'2022-01-31 09:21:12','',''),(2650536,'1','208','1038',479,'Retail Sale Id 1641771',34846.80,0.00,0.00,61.35,2515.35,'2022-01-31 09:22:25','',''),(2650537,'1','208','1038',479,'Retail Sale Id 1641772',12098.40,0.00,0.00,21.30,873.30,'2022-01-31 09:24:12','',''),(2650538,'1','208','1038',479,'Retail Sale Id 1641773',10189.92,0.00,0.00,17.94,735.54,'2022-01-31 09:25:41','',''),(2650539,'1','208','1038',479,'Retail Sale Id 1641774',1704.00,0.00,0.00,3.00,123.00,'2022-01-31 09:30:03','',''),(2650540,'1','208','1038',479,'Retail Sale Id 1641775',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 09:40:02','',''),(2650541,'1','208','1038',479,'Retail Sale Id 1641776',2851.36,0.00,0.00,5.02,205.82,'2022-01-31 09:42:03','',''),(2650542,'1','208','1038',479,'Retail Sale Id 1641777',36300.88,0.00,0.00,63.91,2620.31,'2022-01-31 10:04:47','',''),(2650543,'1','208','1038',479,'Retail Sale Id 1641778',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 10:05:17','',''),(2650544,'1','208','1038',479,'Retail Sale Id 1641780',44400.56,0.00,0.00,78.17,3204.97,'2022-01-31 10:11:53','',''),(2650545,'1','208','1038',479,'Retail Sale Id 1641781',2999.04,0.00,0.00,5.28,216.48,'2022-01-31 10:16:38','',''),(2650546,'1','208','1038',479,'Retail Sale Id 1641782',2999.04,0.00,0.00,5.28,216.48,'2022-01-31 10:22:25','',''),(2650547,'1','208','1038',479,'Retail Sale Id 1641783',1749.44,0.00,0.00,3.08,126.28,'2022-01-31 10:23:42','',''),(2650548,'1','208','1038',479,'Retail Sale Id 1641785',2851.36,0.00,0.00,5.02,205.82,'2022-01-31 10:28:35','',''),(2650549,'1','208','1038',479,'Retail Sale Id 1641786',4998.40,0.00,0.00,8.80,360.80,'2022-01-31 10:34:03','',''),(2650550,'1','208','1038',479,'Retail Sale Id 1641787',2851.36,0.00,0.00,5.02,205.82,'2022-01-31 10:35:24','',''),(2650551,'1','208','1038',479,'Retail Sale Id 1641788',3402.32,0.00,0.00,5.99,245.59,'2022-01-31 10:36:40','',''),(2650552,'1','208','1038',479,'Retail Sale Id 1641790',2999.04,0.00,0.00,5.28,216.48,'2022-01-31 10:41:06','',''),(2650553,'1','208','1038',479,'Retail Sale Id 1641791',499.84,0.00,0.00,0.88,36.08,'2022-01-31 10:45:02','',''),(2650554,'1','208','1038',479,'Retail Sale Id 1641792',2999.04,0.00,0.00,5.28,216.48,'2022-01-31 10:46:08','',''),(2650555,'1','208','1038',479,'Retail Sale Id 1641793',6997.76,0.00,0.00,12.32,505.12,'2022-01-31 10:52:26','',''),(2650556,'1','208','1038',479,'Retail Sale Id 1641794',2851.36,0.00,0.00,5.02,205.82,'2022-01-31 10:56:49','',''),(2650557,'1','208','1038',479,'Retail Sale Id 1641794',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 10:56:49','',''),(2650558,'1','208','1038',479,'Retail Sale Id 1641795',999.68,0.00,0.00,1.76,72.16,'2022-01-31 10:58:40','',''),(2650559,'1','208','1038',479,'Retail Sale Id 1641796',2851.36,0.00,0.00,5.02,205.82,'2022-01-31 11:06:07','',''),(2650560,'1','208','1038',479,'Retail Sale Id 1641797',3998.72,0.00,0.00,7.04,288.64,'2022-01-31 11:07:33','',''),(2650561,'1','208','1038',479,'Retail Sale Id 1641799',999.68,0.00,0.00,1.76,72.16,'2022-01-31 11:15:23','',''),(2650562,'1','208','1038',479,'Retail Sale Id 1641800',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 11:17:08','',''),(2650563,'1','208','1038',479,'Retail Sale Id 1641802',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 11:25:45','',''),(2650564,'1','208','1038',479,'Retail Sale Id 1641804',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 11:26:45','',''),(2650565,'1','208','1038',479,'Retail Sale Id 1641806',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 11:29:49','',''),(2650566,'1','208','1038',479,'Retail Sale Id 1641807',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 11:32:49','',''),(2650567,'1','208','1038',479,'Retail Sale Id 1641808',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 11:45:56','',''),(2650568,'1','208','1038',479,'Retail Sale Id 1641808',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 11:45:56','',''),(2650569,'1','208','1038',479,'Retail Sale Id 1641809',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 11:47:25','',''),(2650570,'1','208','1038',479,'Retail Sale Id 1641810',1499.52,0.00,0.00,2.64,108.24,'2022-01-31 11:48:32','',''),(2650571,'1','208','1038',479,'Retail Sale Id 1641811',1749.44,0.00,0.00,3.08,126.28,'2022-01-31 11:53:35','',''),(2650572,'1','208','1038',479,'Retail Sale Id 1641812',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 11:56:59','',''),(2650573,'1','208','1038',479,'Retail Sale Id 1641813',1698.32,0.00,0.00,2.99,122.59,'2022-01-31 12:10:54','',''),(2650574,'1','208','1038',479,'Retail Sale Id 1641815',1499.52,0.00,0.00,2.64,108.24,'2022-01-31 12:12:23','',''),(2650575,'1','208','1038',479,'Retail Sale Id 1641816',1749.44,0.00,0.00,3.08,126.28,'2022-01-31 12:27:31','',''),(2650576,'1','208','1038',479,'Retail Sale Id 1641817',2499.20,0.00,0.00,4.40,180.40,'2022-01-31 12:34:52','',''),(2650577,'1','208','1038',479,'Retail Sale Id 1641818',8520.00,0.00,0.00,15.00,615.00,'2022-01-31 12:36:05','',''),(2650578,'1','208','1038',479,'Retail Sale Id 1641819',2999.04,0.00,0.00,5.28,216.48,'2022-01-31 12:45:00','',''),(2650579,'1','208','1038',479,'Retail Sale Id 1641821',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 12:54:36','',''),(2650580,'1','208','1038',479,'Retail Sale Id 1641822',1698.32,0.00,0.00,2.99,122.59,'2022-01-31 13:06:36','',''),(2650581,'1','208','1038',479,'Retail Sale Id 1641823',4498.56,0.00,0.00,7.92,324.72,'2022-01-31 13:11:27','',''),(2650582,'1','208','1038',479,'Retail Sale Id 1641824',2851.36,0.00,0.00,5.02,205.82,'2022-01-31 13:15:54','',''),(2650583,'1','208','1038',479,'Retail Sale Id 1641826',3998.72,0.00,0.00,7.04,288.64,'2022-01-31 13:17:33','',''),(2650584,'1','208','1038',479,'Retail Sale Id 1641827',999.68,0.00,0.00,1.76,72.16,'2022-01-31 13:18:54','',''),(2650585,'1','208','1038',479,'Retail Sale Id 1641828',6997.76,0.00,0.00,12.32,505.12,'2022-01-31 13:25:59','',''),(2650586,'1','208','1038',479,'Retail Sale Id 1641829',1721.04,0.00,0.00,3.03,124.23,'2022-01-31 13:29:43','',''),(2650587,'1','208','1038',479,'Retail Sale Id 1641830',3998.72,0.00,0.00,7.04,288.64,'2022-01-31 13:30:51','',''),(2650588,'1','208','1038',479,'Retail Sale Id 1641831',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 13:32:08','',''),(2650589,'1','208','1038',479,'Retail Sale Id 1641832',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 13:34:03','',''),(2650590,'1','208','1038',479,'Retail Sale Id 1641832',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 13:34:03','',''),(2650591,'1','208','1038',479,'Retail Sale Id 1641833',2499.20,0.00,0.00,4.40,180.40,'2022-01-31 13:39:02','',''),(2650592,'1','208','1038',479,'Retail Sale Id 1641835',2999.04,0.00,0.00,5.28,216.48,'2022-01-31 13:49:10','',''),(2650593,'1','208','1038',479,'Retail Sale Id 1641836',3408.00,0.00,0.00,6.00,246.00,'2022-01-31 14:15:18','',''),(2650594,'1','208','1038',479,'Retail Sale Id 1641837',698.64,0.00,0.00,1.23,50.43,'2022-01-31 14:46:19','',''),(2650595,'1','208','1038',479,'Retail Sale Id 1641839',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 15:02:32','',''),(2650596,'1','208','1038',479,'Retail Sale Id 1641841',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 15:09:32','',''),(2650597,'1','208','1038',479,'Retail Sale Id 1641843',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 15:13:40','',''),(2650598,'1','208','1038',479,'Retail Sale Id 1641845',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 15:15:14','',''),(2650599,'1','208','1038',479,'Retail Sale Id 1641847',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 15:16:05','',''),(2650600,'1','208','1038',479,'Retail Sale Id 1641850',6997.76,0.00,0.00,12.32,505.12,'2022-01-31 15:26:54','',''),(2650601,'1','208','1038',479,'Retail Sale Id 1641851',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 15:27:33','',''),(2650602,'1','208','1038',479,'Retail Sale Id 1641854',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 15:28:27','',''),(2650603,'1','208','1038',479,'Retail Sale Id 1641855',5702.72,0.00,0.00,10.04,411.64,'2022-01-31 15:32:52','',''),(2650604,'1','208','1038',479,'Retail Sale Id 1641856',1749.44,0.00,0.00,3.08,126.28,'2022-01-31 15:42:03','',''),(2650605,'1','208','1038',479,'Retail Sale Id 1641856',1749.44,0.00,0.00,3.08,126.28,'2022-01-31 15:42:03','',''),(2650606,'1','208','1038',479,'Retail Sale Id 1641858',6248.00,0.00,0.00,11.00,451.00,'2022-01-31 15:43:50','',''),(2650607,'1','208','1038',479,'Retail Sale Id 1641860',9002.80,0.00,0.00,15.85,649.85,'2022-01-31 15:54:00','',''),(2650608,'1','208','1038',479,'Retail Sale Id 1641864',2300.40,0.00,0.00,4.05,166.05,'2022-01-31 15:58:04','',''),(2650609,'1','208','1038',479,'Retail Sale Id 1641865',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 16:02:00','',''),(2650610,'1','208','1038',479,'Retail Sale Id 1641866',999.68,0.00,0.00,1.76,72.16,'2022-01-31 16:15:54','',''),(2650611,'1','208','1038',479,'Retail Sale Id 1641867',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 16:16:38','',''),(2650612,'1','208','1038',479,'Retail Sale Id 1641869',2999.04,0.00,0.00,5.28,216.48,'2022-01-31 16:17:33','',''),(2650613,'1','208','1038',479,'Retail Sale Id 1641871',1499.52,0.00,0.00,2.64,108.24,'2022-01-31 16:18:12','',''),(2650614,'1','208','1038',479,'Retail Sale Id 1641872',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 16:18:55','',''),(2650615,'1','208','1038',479,'Retail Sale Id 1641873',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 16:20:00','',''),(2650616,'1','208','1038',479,'Retail Sale Id 1641874',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 16:25:41','',''),(2650617,'1','208','1038',479,'Retail Sale Id 1641875',1704.00,0.00,0.00,3.00,123.00,'2022-01-31 16:27:55','',''),(2650618,'1','208','1038',479,'Retail Sale Id 1641876',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 16:36:48','',''),(2650619,'1','208','1038',479,'Retail Sale Id 1641877',897.44,0.00,0.00,1.58,64.78,'2022-01-31 16:44:08','',''),(2650620,'1','208','1038',479,'Retail Sale Id 1641878',3197.84,0.00,0.00,5.63,230.83,'2022-01-31 16:55:13','',''),(2650621,'1','208','1038',479,'Retail Sale Id 1641880',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 17:13:53','',''),(2650622,'1','208','1038',479,'Retail Sale Id 1641881',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 17:19:13','',''),(2650623,'1','208','1038',479,'Retail Sale Id 1641882',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 17:19:55','',''),(2650624,'1','208','1038',479,'Retail Sale Id 1641883',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 17:21:46','',''),(2650625,'1','208','1038',479,'Retail Sale Id 1641883',2300.40,0.00,0.00,4.05,166.05,'2022-01-31 17:21:46','',''),(2650626,'1','208','1038',479,'Retail Sale Id 1641884',2999.04,0.00,0.00,5.28,216.48,'2022-01-31 17:30:30','',''),(2650627,'1','208','1038',479,'Retail Sale Id 1641885',2800.24,0.00,0.00,4.93,202.13,'2022-01-31 17:32:49','',''),(2650628,'1','208','1038',479,'Retail Sale Id 1641886',2851.36,0.00,0.00,5.02,205.82,'2022-01-31 17:33:45','',''),(2650629,'1','208','1038',479,'Retail Sale Id 1641887',1749.44,0.00,0.00,3.08,126.28,'2022-01-31 17:36:48','',''),(2650630,'1','208','1038',479,'Retail Sale Id 1641887',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 17:36:48','',''),(2650631,'1','208','1038',479,'Retail Sale Id 1641889',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 17:38:21','',''),(2650632,'1','208','1038',479,'Retail Sale Id 1641890',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 17:43:12','',''),(2650633,'1','208','1038',479,'Retail Sale Id 1641891',4998.40,0.00,0.00,8.80,360.80,'2022-01-31 17:48:17','',''),(2650634,'1','208','1038',479,'Retail Sale Id 1641892',999.68,0.00,0.00,1.76,72.16,'2022-01-31 17:49:58','',''),(2650635,'1','208','1038',479,'Retail Sale Id 1641893',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 17:53:54','',''),(2650636,'1','208','1038',479,'Retail Sale Id 1641895',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 17:55:00','',''),(2650637,'1','208','1038',479,'Retail Sale Id 1641896',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 17:57:43','',''),(2650638,'1','208','1038',479,'Retail Sale Id 1641896',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 17:57:43','',''),(2650639,'1','208','1038',479,'Retail Sale Id 1641897',2851.36,0.00,0.00,5.02,205.82,'2022-01-31 18:06:32','',''),(2650640,'1','208','1038',479,'Retail Sale Id 1641899',1800.56,0.00,0.00,3.17,129.97,'2022-01-31 18:08:11','',''),(2650641,'1','208','1038',479,'Retail Sale Id 1641900',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 18:13:29','',''),(2650642,'1','208','1038',479,'Retail Sale Id 1641900',8520.00,0.00,0.00,15.00,615.00,'2022-01-31 18:13:29','',''),(2650643,'1','208','1038',479,'Retail Sale Id 1641901',1749.44,0.00,0.00,3.08,126.28,'2022-01-31 18:15:30','',''),(2650644,'1','208','1038',479,'Retail Sale Id 1641902',1198.48,0.00,0.00,2.11,86.51,'2022-01-31 18:16:17','',''),(2650645,'1','208','1038',479,'Retail Sale Id 1641903',3550.00,0.00,0.00,6.25,256.25,'2022-01-31 18:17:13','',''),(2650646,'1','208','1038',479,'Retail Sale Id 1641905',4998.40,0.00,0.00,8.80,360.80,'2022-01-31 18:20:10','',''),(2650647,'1','208','1038',479,'Retail Sale Id 1641906',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 18:24:55','',''),(2650648,'1','208','1038',479,'Retail Sale Id 1641907',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 18:26:07','',''),(2650649,'1','208','1038',479,'Retail Sale Id 1641908',1704.00,0.00,0.00,3.00,123.00,'2022-01-31 18:27:14','',''),(2650650,'1','208','1038',479,'Retail Sale Id 1641909',897.44,0.00,0.00,1.58,64.78,'2022-01-31 18:28:14','',''),(2650651,'1','208','1038',479,'Retail Sale Id 1641910',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 18:29:35','',''),(2650652,'1','208','1038',479,'Retail Sale Id 1641911',602.08,0.00,0.00,1.06,43.46,'2022-01-31 18:30:16','',''),(2650653,'1','208','1038',479,'Retail Sale Id 1641912',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 18:30:59','',''),(2650654,'1','208','1038',479,'Retail Sale Id 1641913',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 18:31:44','',''),(2650655,'1','208','1038',479,'Retail Sale Id 1641914',1704.00,0.00,0.00,3.00,123.00,'2022-01-31 18:33:21','',''),(2650656,'1','208','1038',479,'Retail Sale Id 1641915',1749.44,0.00,0.00,3.08,126.28,'2022-01-31 18:34:14','',''),(2650657,'1','208','1038',479,'Retail Sale Id 1641916',1749.44,0.00,0.00,3.08,126.28,'2022-01-31 18:35:28','',''),(2650658,'1','208','1038',479,'Retail Sale Id 1641917',4998.40,0.00,0.00,8.80,360.80,'2022-01-31 18:36:13','',''),(2650659,'1','208','1038',479,'Retail Sale Id 1641918',6997.76,0.00,0.00,12.32,505.12,'2022-01-31 18:37:47','',''),(2650660,'1','208','1038',479,'Retail Sale Id 1641919',1698.32,0.00,0.00,2.99,122.59,'2022-01-31 18:39:07','',''),(2650661,'1','208','1038',479,'Retail Sale Id 1641920',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 18:42:31','',''),(2650662,'1','208','1038',479,'Retail Sale Id 1641921',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 18:54:52','',''),(2650663,'1','208','1038',479,'Retail Sale Id 1641922',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 18:57:12','',''),(2650664,'1','208','1038',479,'Retail Sale Id 1641922',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 18:57:12','',''),(2650665,'1','208','1038',479,'Retail Sale Id 1641923',1499.52,0.00,0.00,2.64,108.24,'2022-01-31 18:58:45','',''),(2650666,'1','208','1038',479,'Retail Sale Id 1641924',2851.36,0.00,0.00,5.02,205.82,'2022-01-31 18:59:30','',''),(2650667,'1','208','1038',479,'Retail Sale Id 1641925',7100.00,0.00,0.00,12.50,512.50,'2022-01-31 19:00:44','',''),(2650668,'1','208','1038',479,'Retail Sale Id 1641926',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 19:02:11','',''),(2650669,'1','208','1038',479,'Retail Sale Id 1641927',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 19:05:15','',''),(2650670,'1','208','1038',479,'Retail Sale Id 1641928',102.24,0.00,0.00,0.18,7.38,'2022-01-31 19:06:40','',''),(2650671,'1','208','1038',479,'Retail Sale Id 1641929',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 19:08:01','',''),(2650672,'1','208','1038',479,'Retail Sale Id 1641930',2999.04,0.00,0.00,5.28,216.48,'2022-01-31 19:08:29','',''),(2650673,'1','208','1038',479,'Retail Sale Id 1641931',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 19:12:20','',''),(2650674,'1','208','1038',479,'Retail Sale Id 1641932',3697.68,0.00,0.00,6.51,266.91,'2022-01-31 19:18:19','',''),(2650675,'1','208','1038',479,'Retail Sale Id 1641933',1704.00,0.00,0.00,3.00,123.00,'2022-01-31 19:23:39','',''),(2650676,'1','208','1038',479,'Retail Sale Id 1641933',2840.00,0.00,0.00,5.00,205.00,'2022-01-31 19:23:39','',''),(2650677,'1','208','1038',479,'Retail Sale Id 1641934',2851.36,0.00,0.00,5.02,205.82,'2022-01-31 19:26:23','',''),(2650678,'1','208','1038',479,'Retail Sale Id 1641935',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 19:28:24','',''),(2650679,'1','208','1038',479,'Retail Sale Id 1641936',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 19:36:40','',''),(2650680,'1','208','1038',479,'Retail Sale Id 1641936',3498.88,0.00,0.00,6.16,252.56,'2022-01-31 19:36:40','',''),(2650681,'1','208','1038',479,'Retail Sale Id 1641937',1999.36,0.00,0.00,3.52,144.32,'2022-01-31 19:53:36','',''),(2650682,'1','208','1038',479,'Retail Sale Id 1641938',999.68,0.00,0.00,1.76,72.16,'2022-01-31 19:54:29','',''),(2650683,'1','208','1038',479,'Return of Retail Sale Id 1641921',0.00,7100.00,12.50,0.00,-512.50,'2022-01-31 23:10:31','',''),(2650684,'1','208','1038',479,'Return of Retail Sale Id 1641925',0.00,7100.00,12.50,0.00,-512.50,'2022-01-31 23:12:07','',''),(2650685,'1','208','1038',479,'Return of Retail Sale Id 1641900',0.00,7100.00,12.50,0.00,-512.50,'2022-01-31 23:13:37','',''),(2650686,'1','208','1038',479,'Return of Retail Sale Id 1641900',0.00,8520.00,15.00,0.00,-615.00,'2022-01-31 23:13:37','',''),(2650687,'1','208','1038',479,'Return of Retail Sale Id 1641906',0.00,7100.00,12.50,0.00,-512.50,'2022-01-31 23:48:42','',''),(2650688,'1','208','1038',479,'Return of Retail Sale Id 1641865',0.00,7100.00,12.50,0.00,-512.50,'2022-01-31 23:49:58','',''),(2650689,'1','208','1038',479,'Return of Retail Sale Id 1641822',0.00,1698.32,2.99,0.00,-122.59,'2022-01-31 23:51:33','',''),(2650690,'1','208','1038',479,'Return of Retail Sale Id 1641922',0.00,3498.88,6.16,0.00,-252.56,'2022-02-01 00:02:18','',''),(2650691,'1','208','1038',479,'Return of Retail Sale Id 1641922',0.00,7100.00,12.50,0.00,-512.50,'2022-02-01 00:02:18','',''),(2650692,'1','208','1038',479,'Return of Retail Sale Id 1641841',0.00,7100.00,12.50,0.00,-512.50,'2022-02-01 00:04:00','',''),(2650693,'1','208','1038',479,'Return of Retail Sale Id 1641780',0.00,44400.56,78.17,0.00,-3204.97,'2022-02-01 00:06:30','',''),(2650694,'1','208','1038',479,'Retail Sale Id 1641939',14200.00,0.00,0.00,25.00,1025.00,'2022-02-01 00:18:45','',''),(2650695,'1','208','1038',479,'Retail Sale Id 1641940',29916.56,0.00,0.00,52.67,2159.47,'2022-02-01 00:20:59','',''),(2650696,'1','208','1038',479,'Retail Sale Id 1641941',41208.40,0.00,0.00,72.55,2974.55,'2022-02-01 00:22:33','',''),(2650697,'1','208','1038',479,'Retail Sale Id 1641942',19880.00,0.00,0.00,35.00,1435.00,'2022-02-01 00:24:43','',''),(2650698,'1','208','1038',479,'Retail Sale Id 1641943',102.24,0.00,0.00,0.18,7.38,'2022-02-01 00:31:51','',''),(2650699,'1','208','1038',479,'Retail Sale Id 1641944',306.72,0.00,0.00,0.54,22.14,'2022-02-01 00:34:01','',''),(2650700,'1','208','1038',479,'Retail Sale Id 1641945',2749.12,0.00,0.00,4.84,198.44,'2022-02-01 07:51:45','',''),(2650701,'1','208','1038',479,'Retail Sale Id 1641946',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 07:54:52','',''),(2650702,'1','208','1038',479,'Retail Sale Id 1641947',2499.20,0.00,0.00,4.40,180.40,'2022-02-01 07:56:05','',''),(2650703,'1','208','1038',479,'Retail Sale Id 1641948',5998.08,0.00,0.00,10.56,432.96,'2022-02-01 07:57:02','',''),(2650704,'1','208','1038',479,'Retail Sale Id 1641949',3498.88,0.00,0.00,6.16,252.56,'2022-02-01 07:57:46','',''),(2650705,'1','208','1038',479,'Retail Sale Id 1641950',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 08:01:24','',''),(2650706,'1','208','1038',479,'Retail Sale Id 1641951',2840.00,0.00,0.00,5.00,205.00,'2022-02-01 08:02:47','',''),(2650707,'1','208','1038',479,'Retail Sale Id 1641952',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:03:51','',''),(2650708,'1','208','1038',479,'Retail Sale Id 1641953',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 08:07:31','',''),(2650709,'1','208','1038',479,'Retail Sale Id 1641954',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 08:08:35','',''),(2650710,'1','208','1038',479,'Retail Sale Id 1641955',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:09:43','',''),(2650711,'1','208','1038',479,'Retail Sale Id 1641956',1704.00,0.00,0.00,3.00,123.00,'2022-02-01 08:10:43','',''),(2650712,'1','208','1038',479,'Retail Sale Id 1641957',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:12:20','',''),(2650713,'1','208','1038',479,'Retail Sale Id 1641958',5998.08,0.00,0.00,10.56,432.96,'2022-02-01 08:15:41','',''),(2650714,'1','208','1038',479,'Retail Sale Id 1641959',2840.00,0.00,0.00,5.00,205.00,'2022-02-01 08:19:19','',''),(2650715,'1','208','1038',479,'Retail Sale Id 1641959',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:19:19','',''),(2650716,'1','208','1038',479,'Retail Sale Id 1641960',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 08:20:25','',''),(2650717,'1','208','1038',479,'Retail Sale Id 1641961',3498.88,0.00,0.00,6.16,252.56,'2022-02-01 08:21:10','',''),(2650718,'1','208','1038',479,'Retail Sale Id 1641962',4998.40,0.00,0.00,8.80,360.80,'2022-02-01 08:22:15','',''),(2650719,'1','208','1038',479,'Retail Sale Id 1641962',4998.40,0.00,0.00,8.80,360.80,'2022-02-01 08:22:15','',''),(2650720,'1','208','1038',479,'Retail Sale Id 1641963',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 08:22:54','',''),(2650721,'1','208','1038',479,'Retail Sale Id 1641964',3498.88,0.00,0.00,6.16,252.56,'2022-02-01 08:23:55','',''),(2650722,'1','208','1038',479,'Retail Sale Id 1641965',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 08:24:41','',''),(2650723,'1','208','1038',479,'Retail Sale Id 1641966',2300.40,0.00,0.00,4.05,166.05,'2022-02-01 08:26:21','',''),(2650724,'1','208','1038',479,'Retail Sale Id 1641967',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:27:37','',''),(2650725,'1','208','1038',479,'Retail Sale Id 1641968',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:28:26','',''),(2650726,'1','208','1038',479,'Retail Sale Id 1641969',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:29:10','',''),(2650727,'1','208','1038',479,'Retail Sale Id 1641970',999.68,0.00,0.00,1.76,72.16,'2022-02-01 08:29:56','',''),(2650728,'1','208','1038',479,'Retail Sale Id 1641971',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 08:30:44','',''),(2650729,'1','208','1038',479,'Retail Sale Id 1641972',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:31:19','',''),(2650730,'1','208','1038',479,'Retail Sale Id 1641973',3998.72,0.00,0.00,7.04,288.64,'2022-02-01 08:32:02','',''),(2650731,'1','208','1038',479,'Retail Sale Id 1641974',1198.48,0.00,0.00,2.11,86.51,'2022-02-01 08:32:56','',''),(2650732,'1','208','1038',479,'Retail Sale Id 1641975',602.08,0.00,0.00,1.06,43.46,'2022-02-01 08:34:12','',''),(2650733,'1','208','1038',479,'Retail Sale Id 1641976',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 08:34:58','',''),(2650734,'1','208','1038',479,'Retail Sale Id 1641977',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:35:45','',''),(2650735,'1','208','1038',479,'Retail Sale Id 1641978',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 08:37:01','',''),(2650736,'1','208','1038',479,'Retail Sale Id 1641979',2840.00,0.00,0.00,5.00,205.00,'2022-02-01 08:38:26','',''),(2650737,'1','208','1038',479,'Retail Sale Id 1641979',5680.00,0.00,0.00,10.00,410.00,'2022-02-01 08:38:26','',''),(2650738,'1','208','1038',479,'Retail Sale Id 1641980',4998.40,0.00,0.00,8.80,360.80,'2022-02-01 08:41:39','',''),(2650739,'1','208','1038',479,'Retail Sale Id 1641981',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 08:44:50','',''),(2650740,'1','208','1038',479,'Retail Sale Id 1641982',3998.72,0.00,0.00,7.04,288.64,'2022-02-01 08:45:49','',''),(2650741,'1','208','1038',479,'Retail Sale Id 1641983',3498.88,0.00,0.00,6.16,252.56,'2022-02-01 08:46:40','',''),(2650742,'1','208','1038',479,'Retail Sale Id 1641984',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:47:35','',''),(2650743,'1','208','1038',479,'Retail Sale Id 1641985',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 08:48:41','',''),(2650744,'1','208','1038',479,'Retail Sale Id 1641985',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:48:41','',''),(2650745,'1','208','1038',479,'Retail Sale Id 1641986',1198.48,0.00,0.00,2.11,86.51,'2022-02-01 08:49:55','',''),(2650746,'1','208','1038',479,'Retail Sale Id 1641987',2499.20,0.00,0.00,4.40,180.40,'2022-02-01 08:50:53','',''),(2650747,'1','208','1038',479,'Retail Sale Id 1641988',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 08:52:15','',''),(2650748,'1','208','1038',479,'Retail Sale Id 1641989',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 08:54:53','',''),(2650749,'1','208','1038',479,'Retail Sale Id 1641990',4998.40,0.00,0.00,8.80,360.80,'2022-02-01 09:00:21','',''),(2650750,'1','208','1038',479,'Retail Sale Id 1641991',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 09:02:30','',''),(2650751,'1','208','1038',479,'Retail Sale Id 1641991',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 09:02:30','',''),(2650752,'1','208','1038',479,'Retail Sale Id 1641992',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 09:04:30','',''),(2650753,'1','208','1038',479,'Retail Sale Id 1641993',1499.52,0.00,0.00,2.64,108.24,'2022-02-01 09:06:28','',''),(2650754,'1','208','1038',479,'Retail Sale Id 1641994',1704.00,0.00,0.00,3.00,123.00,'2022-02-01 09:12:49','',''),(2650755,'1','208','1038',479,'Retail Sale Id 1641994',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 09:12:49','',''),(2650756,'1','208','1038',479,'Retail Sale Id 1641994',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 09:12:49','',''),(2650757,'1','208','1038',479,'Retail Sale Id 1641995',999.68,0.00,0.00,1.76,72.16,'2022-02-01 09:13:41','',''),(2650758,'1','208','1038',479,'Retail Sale Id 1641996',1101.92,0.00,0.00,1.94,79.54,'2022-02-01 09:16:45','',''),(2650759,'1','208','1038',479,'Retail Sale Id 1641997',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 09:18:31','',''),(2650760,'1','208','1038',479,'Retail Sale Id 1641998',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 09:25:16','',''),(2650761,'1','208','1038',479,'Retail Sale Id 1641999',2499.20,0.00,0.00,4.40,180.40,'2022-02-01 09:27:20','',''),(2650762,'1','208','1038',479,'Retail Sale Id 1642000',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 09:29:39','',''),(2650763,'1','208','1038',479,'Retail Sale Id 1642001',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 09:30:44','',''),(2650764,'1','208','1038',479,'Retail Sale Id 1642002',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 09:31:45','',''),(2650765,'1','208','1038',479,'Retail Sale Id 1642003',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 09:32:37','',''),(2650766,'1','208','1038',479,'Retail Sale Id 1642004',3402.32,0.00,0.00,5.99,245.59,'2022-02-01 09:33:57','',''),(2650767,'1','208','1038',479,'Retail Sale Id 1642005',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 09:34:49','',''),(2650768,'1','208','1038',479,'Retail Sale Id 1642006',5680.00,0.00,0.00,10.00,410.00,'2022-02-01 09:36:18','',''),(2650769,'1','208','1038',479,'Retail Sale Id 1642007',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 09:40:13','',''),(2650770,'1','208','1038',479,'Retail Sale Id 1642008',1704.00,0.00,0.00,3.00,123.00,'2022-02-01 09:42:22','',''),(2650771,'1','208','1038',479,'Retail Sale Id 1642009',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 09:44:52','',''),(2650772,'1','208','1038',479,'Retail Sale Id 1642010',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 09:48:20','',''),(2650773,'1','208','1038',479,'Retail Sale Id 1642011',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 09:50:42','',''),(2650774,'1','208','1038',479,'Retail Sale Id 1642011',28400.00,0.00,0.00,50.00,2050.00,'2022-02-01 09:50:42','',''),(2650775,'1','208','1038',479,'Retail Sale Id 1642012',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 09:52:40','',''),(2650776,'1','208','1038',479,'Retail Sale Id 1642013',1704.00,0.00,0.00,3.00,123.00,'2022-02-01 09:53:49','',''),(2650777,'1','208','1038',479,'Retail Sale Id 1642013',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 09:53:49','',''),(2650778,'1','208','1038',479,'Retail Sale Id 1642014',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 09:54:47','',''),(2650779,'1','208','1038',479,'Retail Sale Id 1642015',1704.00,0.00,0.00,3.00,123.00,'2022-02-01 09:55:54','',''),(2650780,'1','208','1038',479,'Retail Sale Id 1642016',3498.88,0.00,0.00,6.16,252.56,'2022-02-01 09:56:56','',''),(2650781,'1','208','1038',479,'Retail Sale Id 1642017',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 09:57:56','',''),(2650782,'1','208','1038',479,'Retail Sale Id 1642017',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 09:57:56','',''),(2650783,'1','208','1038',479,'Retail Sale Id 1642018',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 09:59:08','',''),(2650784,'1','208','1038',479,'Retail Sale Id 1642019',999.68,0.00,0.00,1.76,72.16,'2022-02-01 09:59:57','',''),(2650785,'1','208','1038',479,'Retail Sale Id 1642020',4998.40,0.00,0.00,8.80,360.80,'2022-02-01 10:01:29','',''),(2650786,'1','208','1038',479,'Retail Sale Id 1642021',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 10:04:07','',''),(2650787,'1','208','1038',479,'Retail Sale Id 1642022',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 10:05:42','',''),(2650788,'1','208','1038',479,'Retail Sale Id 1642022',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 10:05:42','',''),(2650789,'1','208','1038',479,'Retail Sale Id 1642023',3498.88,0.00,0.00,6.16,252.56,'2022-02-01 10:09:35','',''),(2650790,'1','208','1038',479,'Retail Sale Id 1642024',1704.00,0.00,0.00,3.00,123.00,'2022-02-01 10:14:25','',''),(2650791,'1','208','1038',479,'Retail Sale Id 1642024',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 10:14:25','',''),(2650792,'1','208','1038',479,'Retail Sale Id 1642025',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 10:39:03','',''),(2650793,'1','208','1038',479,'Retail Sale Id 1642026',1709.68,0.00,0.00,3.01,123.41,'2022-02-01 10:40:18','',''),(2650794,'1','208','1038',479,'Retail Sale Id 1642027',1709.68,0.00,0.00,3.01,123.41,'2022-02-01 10:42:24','',''),(2650795,'1','208','1038',479,'Retail Sale Id 1642027',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 10:42:24','',''),(2650796,'1','208','1038',479,'Retail Sale Id 1642028',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 10:44:21','',''),(2650797,'1','208','1038',479,'Retail Sale Id 1642029',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 10:45:55','',''),(2650798,'1','208','1038',479,'Retail Sale Id 1642030',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 10:46:51','',''),(2650799,'1','208','1038',479,'Retail Sale Id 1642031',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 10:53:17','',''),(2650800,'1','208','1038',479,'Retail Sale Id 1642032',5998.08,0.00,0.00,10.56,432.96,'2022-02-01 10:55:14','',''),(2650801,'1','208','1038',479,'Retail Sale Id 1642033',2840.00,0.00,0.00,5.00,205.00,'2022-02-01 11:22:04','',''),(2650802,'1','208','1038',479,'Retail Sale Id 1642034',999.68,0.00,0.00,1.76,72.16,'2022-02-01 11:22:55','',''),(2650803,'1','208','1038',479,'Retail Sale Id 1642035',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 11:23:54','',''),(2650804,'1','208','1038',479,'Retail Sale Id 1642036',1499.52,0.00,0.00,2.64,108.24,'2022-02-01 11:25:26','',''),(2650805,'1','208','1038',479,'Retail Sale Id 1642037',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 11:29:38','',''),(2650806,'1','208','1038',479,'Retail Sale Id 1642038',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 11:30:37','',''),(2650807,'1','208','1038',479,'Retail Sale Id 1642039',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 11:33:48','',''),(2650808,'1','208','1038',479,'Retail Sale Id 1642040',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 11:36:24','',''),(2650809,'1','208','1038',479,'Retail Sale Id 1642041',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 11:44:45','',''),(2650810,'1','208','1038',479,'Retail Sale Id 1642042',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 11:47:24','',''),(2650811,'1','208','1038',479,'Retail Sale Id 1642043',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 11:49:08','',''),(2650812,'1','208','1038',479,'Retail Sale Id 1642044',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 11:53:02','',''),(2650813,'1','208','1038',479,'Retail Sale Id 1642045',999.68,0.00,0.00,1.76,72.16,'2022-02-01 12:10:36','',''),(2650814,'1','208','1038',479,'Retail Sale Id 1642046',999.68,0.00,0.00,1.76,72.16,'2022-02-01 12:16:07','',''),(2650815,'1','208','1038',479,'Retail Sale Id 1642047',1709.68,0.00,0.00,3.01,123.41,'2022-02-01 12:21:22','',''),(2650816,'1','208',NULL,479,'Reception corrector for bridging 132388',0.00,0.00,0.00,5000.00,0.00,'2022-02-01 12:26:26','',''),(2650817,'1','208','1038',479,'Received from bridging 132388',0.00,0.00,5000.00,0.00,0.00,'2022-02-01 12:26:26','',''),(2650818,'1','208','1038',479,'Retail Sale Id 1642049',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 12:56:08','',''),(2650819,'1','208','1038',479,'Retail Sale Id 1642049',3998.72,0.00,0.00,7.04,288.64,'2022-02-01 12:56:08','',''),(2650820,'1','208','1038',479,'Retail Sale Id 1642050',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 12:57:03','',''),(2650821,'1','208','1038',479,'Retail Sale Id 1642051',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 12:58:49','',''),(2650822,'1','208','1038',479,'Retail Sale Id 1642052',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 13:28:39','',''),(2650823,'1','208','1038',479,'Retail Sale Id 1642053',3402.32,0.00,0.00,5.99,245.59,'2022-02-01 13:29:48','',''),(2650824,'1','208','1038',479,'Retail Sale Id 1642054',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 13:30:30','',''),(2650825,'1','208','1038',479,'Retail Sale Id 1642055',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 13:34:19','',''),(2650826,'1','208','1038',479,'Retail Sale Id 1642056',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 13:38:49','',''),(2650827,'1','208','1038',479,'Retail Sale Id 1642057',602.08,0.00,0.00,1.06,43.46,'2022-02-01 13:43:39','',''),(2650828,'1','208','1038',479,'Retail Sale Id 1642058',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 13:44:34','',''),(2650829,'1','208','1038',479,'Retail Sale Id 1642059',2800.24,0.00,0.00,4.93,202.13,'2022-02-01 13:47:41','',''),(2650830,'1','208','1038',479,'Retail Sale Id 1642060',3998.72,0.00,0.00,7.04,288.64,'2022-02-01 13:48:36','',''),(2650831,'1','208','1038',479,'Retail Sale Id 1642061',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 13:53:44','',''),(2650832,'1','208','1038',479,'Retail Sale Id 1642062',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 14:03:05','',''),(2650833,'1','208','1038',479,'Retail Sale Id 1642063',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 14:10:58','',''),(2650834,'1','208','1038',479,'Retail Sale Id 1642064',5680.00,0.00,0.00,10.00,410.00,'2022-02-01 14:27:04','',''),(2650835,'1','208','1038',479,'Retail Sale Id 1642065',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 14:34:50','',''),(2650836,'1','208','1038',479,'Retail Sale Id 1642067',3498.88,0.00,0.00,6.16,252.56,'2022-02-01 14:47:33','',''),(2650837,'1','208','1038',479,'Retail Sale Id 1642068',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 14:51:55','',''),(2650838,'1','208','1038',479,'Retail Sale Id 1642069',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 15:05:36','',''),(2650839,'1','208','1038',479,'Retail Sale Id 1642070',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 15:06:33','',''),(2650840,'1','208','1038',479,'Retail Sale Id 1642071',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 15:07:07','',''),(2650841,'1','208','1038',479,'Retail Sale Id 1642072',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 15:11:38','',''),(2650842,'1','208','1038',479,'Retail Sale Id 1642073',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 15:14:46','',''),(2650843,'1','208','1038',479,'Retail Sale Id 1642074',2499.20,0.00,0.00,4.40,180.40,'2022-02-01 15:18:31','',''),(2650844,'1','208','1038',479,'Retail Sale Id 1642075',12001.84,0.00,0.00,21.13,866.33,'2022-02-01 15:19:26','',''),(2650845,'1','208','1038',479,'Retail Sale Id 1642076',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 15:21:20','',''),(2650846,'1','208','1038',479,'Retail Sale Id 1642077',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 15:26:23','',''),(2650847,'1','208','1038',479,'Retail Sale Id 1642078',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 15:30:02','',''),(2650848,'1','208','1038',479,'Retail Sale Id 1642079',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 15:38:47','',''),(2650849,'1','208','1038',479,'Retail Sale Id 1642080',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 15:44:39','',''),(2650850,'1','208','1038',479,'Retail Sale Id 1642081',5680.00,0.00,0.00,10.00,410.00,'2022-02-01 15:47:33','',''),(2650851,'1','208','1038',479,'Retail Sale Id 1642082',1704.00,0.00,0.00,3.00,123.00,'2022-02-01 15:49:05','',''),(2650852,'1','208','1038',479,'Retail Sale Id 1642083',1800.56,0.00,0.00,3.17,129.97,'2022-02-01 16:10:18','',''),(2650853,'1','208','1038',479,'Retail Sale Id 1642084',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 16:16:12','',''),(2650854,'1','208','1038',479,'Retail Sale Id 1642085',999.68,0.00,0.00,1.76,72.16,'2022-02-01 16:29:43','',''),(2650855,'1','208','1038',479,'Retail Sale Id 1642086',1709.68,0.00,0.00,3.01,123.41,'2022-02-01 16:32:34','',''),(2650856,'1','208','1038',479,'Retail Sale Id 1642087',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 16:35:31','',''),(2650857,'1','208','1038',479,'Retail Sale Id 1642088',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 16:40:34','',''),(2650858,'1','208','1038',479,'Retail Sale Id 1642089',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 16:41:42','',''),(2650859,'1','208','1038',479,'Retail Sale Id 1642090',3402.32,0.00,0.00,5.99,245.59,'2022-02-01 16:47:10','',''),(2650860,'1','208','1038',479,'Retail Sale Id 1642091',1147.36,0.00,0.00,2.02,82.82,'2022-02-01 16:48:17','',''),(2650861,'1','208','1038',479,'Retail Sale Id 1642092',1709.68,0.00,0.00,3.01,123.41,'2022-02-01 16:49:44','',''),(2650862,'1','208','1038',479,'Retail Sale Id 1642093',602.08,0.00,0.00,1.06,43.46,'2022-02-01 16:50:19','',''),(2650863,'1','208','1038',479,'Retail Sale Id 1642094',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 16:51:05','',''),(2650864,'1','208','1038',479,'Retail Sale Id 1642095',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 16:52:08','',''),(2650865,'1','208','1038',479,'Retail Sale Id 1642096',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 16:53:11','',''),(2650866,'1','208','1038',479,'Retail Sale Id 1642097',2840.00,0.00,0.00,5.00,205.00,'2022-02-01 16:54:07','',''),(2650867,'1','208','1038',479,'Retail Sale Id 1642097',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 16:54:07','',''),(2650868,'1','208','1038',479,'Retail Sale Id 1642098',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 16:55:04','',''),(2650869,'1','208','1038',479,'Retail Sale Id 1642099',5680.00,0.00,0.00,10.00,410.00,'2022-02-01 17:00:10','',''),(2650870,'1','208','1038',479,'Retail Sale Id 1642100',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 17:02:35','',''),(2650871,'1','208','1038',479,'Retail Sale Id 1642101',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 17:06:48','',''),(2650872,'1','208','1038',479,'Retail Sale Id 1642102',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 17:08:27','',''),(2650873,'1','208','1038',479,'Retail Sale Id 1642103',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 17:09:18','',''),(2650874,'1','208','1038',479,'Retail Sale Id 1642104',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 17:10:24','',''),(2650875,'1','208','1038',479,'Retail Sale Id 1642105',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 17:11:22','',''),(2650876,'1','208','1038',479,'Retail Sale Id 1642106',6997.76,0.00,0.00,12.32,505.12,'2022-02-01 17:12:18','',''),(2650877,'1','208','1038',479,'Retail Sale Id 1642107',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 17:13:10','',''),(2650878,'1','208','1038',479,'Retail Sale Id 1642108',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 17:14:05','',''),(2650879,'1','208','1038',479,'Retail Sale Id 1642109',3601.12,0.00,0.00,6.34,259.94,'2022-02-01 17:15:23','',''),(2650880,'1','208','1038',479,'Retail Sale Id 1642110',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 17:16:32','',''),(2650881,'1','208','1038',479,'Retail Sale Id 1642111',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 17:19:56','',''),(2650882,'1','208','1038',479,'Retail Sale Id 1642112',1499.52,0.00,0.00,2.64,108.24,'2022-02-01 17:21:12','',''),(2650883,'1','208','1038',479,'Retail Sale Id 1642113',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 17:23:54','',''),(2650884,'1','208','1038',479,'Retail Sale Id 1642114',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 17:24:41','',''),(2650885,'1','208','1038',479,'Retail Sale Id 1642115',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 17:26:07','',''),(2650886,'1','208','1038',479,'Retail Sale Id 1642116',999.68,0.00,0.00,1.76,72.16,'2022-02-01 17:27:20','',''),(2650887,'1','208','1038',479,'Retail Sale Id 1642117',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 17:27:54','',''),(2650888,'1','208','1038',479,'Retail Sale Id 1642118',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 17:30:53','',''),(2650889,'1','208','1038',479,'Retail Sale Id 1642119',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 17:37:07','',''),(2650890,'1','208','1038',479,'Retail Sale Id 1642120',3498.88,0.00,0.00,6.16,252.56,'2022-02-01 17:42:00','',''),(2650891,'1','208','1038',479,'Retail Sale Id 1642121',4998.40,0.00,0.00,8.80,360.80,'2022-02-01 17:42:54','',''),(2650892,'1','208','1038',479,'Retail Sale Id 1642122',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 17:49:16','',''),(2650893,'1','208','1038',479,'Retail Sale Id 1642123',2999.04,0.00,0.00,5.28,216.48,'2022-02-01 17:50:24','',''),(2650894,'1','208','1038',479,'Retail Sale Id 1642124',2840.00,0.00,0.00,5.00,205.00,'2022-02-01 17:52:48','',''),(2650895,'1','208','1038',479,'Retail Sale Id 1642125',1709.68,0.00,0.00,3.01,123.41,'2022-02-01 17:54:12','',''),(2650896,'1','208','1038',479,'Retail Sale Id 1642125',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 17:54:12','',''),(2650897,'1','208','1038',479,'Retail Sale Id 1642126',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 18:01:17','',''),(2650898,'1','208','1038',479,'Retail Sale Id 1642127',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 18:02:36','',''),(2650899,'1','208','1038',479,'Retail Sale Id 1642128',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 18:06:46','',''),(2650900,'1','208','1038',479,'Retail Sale Id 1642129',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 18:10:47','',''),(2650901,'1','208','1038',479,'Retail Sale Id 1642130',1698.32,0.00,0.00,2.99,122.59,'2022-02-01 18:13:06','',''),(2650902,'1','208','1038',479,'Retail Sale Id 1642131',1499.52,0.00,0.00,2.64,108.24,'2022-02-01 18:15:43','',''),(2650903,'1','208','1038',479,'Retail Sale Id 1642132',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 18:24:32','',''),(2650904,'1','208','1038',479,'Retail Sale Id 1642133',2851.36,0.00,0.00,5.02,205.82,'2022-02-01 18:30:10','',''),(2650905,'1','208','1038',479,'Retail Sale Id 1642134',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 18:31:25','',''),(2650906,'1','208','1038',479,'Retail Sale Id 1642135',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 18:37:32','',''),(2650907,'1','208','1038',479,'Retail Sale Id 1642135',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 18:37:32','',''),(2650908,'1','208','1038',479,'Retail Sale Id 1642136',5998.08,0.00,0.00,10.56,432.96,'2022-02-01 18:38:31','',''),(2650909,'1','208','1038',479,'Retail Sale Id 1642137',3498.88,0.00,0.00,6.16,252.56,'2022-02-01 18:39:37','',''),(2650910,'1','208','1038',479,'Retail Sale Id 1642138',5702.72,0.00,0.00,10.04,411.64,'2022-02-01 18:40:48','',''),(2650911,'1','208','1038',479,'Retail Sale Id 1642139',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 18:43:04','',''),(2650912,'1','208','1038',479,'Retail Sale Id 1642140',3408.00,0.00,0.00,6.00,246.00,'2022-02-01 18:45:16','',''),(2650913,'1','208','1038',479,'Retail Sale Id 1642141',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 19:02:34','',''),(2650914,'1','208','1038',479,'Retail Sale Id 1642142',2840.00,0.00,0.00,5.00,205.00,'2022-02-01 19:05:17','',''),(2650915,'1','208','1038',479,'Retail Sale Id 1642143',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 19:06:24','',''),(2650916,'1','208','1038',479,'Retail Sale Id 1642143',7100.00,0.00,0.00,12.50,512.50,'2022-02-01 19:06:24','',''),(2650917,'1','208','1038',479,'Retail Sale Id 1642144',3402.32,0.00,0.00,5.99,245.59,'2022-02-01 19:10:40','',''),(2650918,'1','208','1038',479,'Retail Sale Id 1642145',6497.92,0.00,0.00,11.44,469.04,'2022-02-01 19:12:56','',''),(2650919,'1','208','1038',479,'Retail Sale Id 1642146',3998.72,0.00,0.00,7.04,288.64,'2022-02-01 19:17:42','',''),(2650920,'1','208','1038',479,'Retail Sale Id 1642147',1999.36,0.00,0.00,3.52,144.32,'2022-02-01 19:28:56','',''),(2650921,'1','208','1038',479,'Return of Retail Sale Id 1642132',0.00,7100.00,12.50,0.00,-512.50,'2022-02-01 20:31:33','',''),(2650922,'1','208','1038',479,'Return of Retail Sale Id 1642128',0.00,7100.00,12.50,0.00,-512.50,'2022-02-01 20:32:16','',''),(2650923,'1','208','1038',479,'Return of Retail Sale Id 1642125',0.00,1709.68,3.01,0.00,-123.41,'2022-02-01 20:33:05','',''),(2650924,'1','208','1038',479,'Return of Retail Sale Id 1642125',0.00,3408.00,6.00,0.00,-246.00,'2022-02-01 20:33:05','',''),(2650925,'1','208','1038',479,'Return of Retail Sale Id 1642129',0.00,1698.32,2.99,0.00,-122.59,'2022-02-01 20:34:40','',''),(2650926,'1','208','1038',479,'Retail Sale Id 1642148',56067.28,0.00,0.00,98.71,4047.11,'2022-02-01 20:40:13','',''),(2650927,'1','208','1038',479,'Retail Sale Id 1642149',9502.64,0.00,0.00,16.73,685.93,'2022-02-01 20:41:10','',''),(2650928,'1','208','1038',479,'Retail Sale Id 1642150',6821.68,0.00,0.00,12.01,492.41,'2022-02-01 20:42:03','',''),(2650929,'1','208','1038',479,'Retail Sale Id 1642151',14200.00,0.00,0.00,25.00,1025.00,'2022-02-01 20:42:52','',''),(2650930,'1','208','1038',479,'Retail Sale Id 1642152',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 07:26:37','',''),(2650931,'1','208','1038',479,'Retail Sale Id 1642153',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 07:27:47','',''),(2650932,'1','208','1038',479,'Retail Sale Id 1642154',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 07:28:32','',''),(2650933,'1','208','1038',479,'Retail Sale Id 1642155',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 07:36:41','',''),(2650934,'1','208','1038',479,'Retail Sale Id 1642157',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 07:38:22','',''),(2650935,'1','208','1038',479,'Retail Sale Id 1642158',14200.00,0.00,0.00,25.00,1025.00,'2022-02-02 07:56:31','',''),(2650936,'1','208','1038',479,'Retail Sale Id 1642159',3998.72,0.00,0.00,7.04,288.64,'2022-02-02 07:57:29','',''),(2650937,'1','208','1038',479,'Retail Sale Id 1642160',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 08:03:45','',''),(2650938,'1','208','1038',479,'Retail Sale Id 1642161',2851.36,0.00,0.00,5.02,205.82,'2022-02-02 08:04:28','',''),(2650939,'1','208','1038',479,'Retail Sale Id 1642162',7497.60,0.00,0.00,13.20,541.20,'2022-02-02 08:10:01','',''),(2650940,'1','208','1038',479,'Retail Sale Id 1642163',2851.36,0.00,0.00,5.02,205.82,'2022-02-02 08:11:34','',''),(2650941,'1','208','1038',479,'Retail Sale Id 1642164',2999.04,0.00,0.00,5.28,216.48,'2022-02-02 08:12:33','',''),(2650942,'1','208','1038',479,'Retail Sale Id 1642165',5998.08,0.00,0.00,10.56,432.96,'2022-02-02 08:16:01','',''),(2650943,'1','208','1038',479,'Retail Sale Id 1642166',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 08:17:15','',''),(2650944,'1','208','1038',479,'Retail Sale Id 1642167',2800.24,0.00,0.00,4.93,202.13,'2022-02-02 08:24:29','',''),(2650945,'1','208','1038',479,'Retail Sale Id 1642168',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 08:25:51','',''),(2650946,'1','208','1038',479,'Retail Sale Id 1642169',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 08:26:52','',''),(2650947,'1','208','1038',479,'Retail Sale Id 1642170',6997.76,0.00,0.00,12.32,505.12,'2022-02-02 08:30:13','',''),(2650948,'1','208','1038',479,'Retail Sale Id 1642171',4544.00,0.00,0.00,8.00,328.00,'2022-02-02 08:32:01','',''),(2650949,'1','208','1038',479,'Retail Sale Id 1642172',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 08:36:30','',''),(2650950,'1','208','1038',479,'Retail Sale Id 1642175',1749.44,0.00,0.00,3.08,126.28,'2022-02-02 08:43:20','',''),(2650951,'1','208','1038',479,'Retail Sale Id 1642176',3998.72,0.00,0.00,7.04,288.64,'2022-02-02 08:46:15','',''),(2650952,'1','208','1038',479,'Retail Sale Id 1642179',1749.44,0.00,0.00,3.08,126.28,'2022-02-02 08:49:20','',''),(2650953,'1','208','1038',479,'Retail Sale Id 1642181',3402.32,0.00,0.00,5.99,245.59,'2022-02-02 08:50:20','',''),(2650954,'1','208','1038',479,'Retail Sale Id 1642184',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 08:51:35','',''),(2650955,'1','208','1038',479,'Retail Sale Id 1642185',999.68,0.00,0.00,1.76,72.16,'2022-02-02 09:00:18','',''),(2650956,'1','208','1038',479,'Retail Sale Id 1642187',1749.44,0.00,0.00,3.08,126.28,'2022-02-02 09:07:07','',''),(2650957,'1','208','1038',479,'Retail Sale Id 1642188',4998.40,0.00,0.00,8.80,360.80,'2022-02-02 09:09:02','',''),(2650958,'1','208','1038',479,'Retail Sale Id 1642190',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 09:11:17','',''),(2650959,'1','208','1038',479,'Retail Sale Id 1642190',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 09:11:17','',''),(2650960,'1','208','1038',479,'Retail Sale Id 1642191',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 09:13:22','',''),(2650961,'1','208','1038',479,'Retail Sale Id 1642192',2800.24,0.00,0.00,4.93,202.13,'2022-02-02 09:21:13','',''),(2650962,'1','208','1038',479,'Retail Sale Id 1642194',1499.52,0.00,0.00,2.64,108.24,'2022-02-02 09:21:59','',''),(2650963,'1','208','1038',479,'Retail Sale Id 1642195',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 09:24:20','',''),(2650964,'1','208','1038',479,'Retail Sale Id 1642195',5680.00,0.00,0.00,10.00,410.00,'2022-02-02 09:24:20','',''),(2650965,'1','208','1038',479,'Retail Sale Id 1642196',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 09:28:09','',''),(2650966,'1','208','1038',479,'Retail Sale Id 1642197',3998.72,0.00,0.00,7.04,288.64,'2022-02-02 09:34:09','',''),(2650967,'1','208','1038',479,'Retail Sale Id 1642198',999.68,0.00,0.00,1.76,72.16,'2022-02-02 09:37:08','',''),(2650968,'1','208','1038',479,'Retail Sale Id 1642199',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 09:40:27','',''),(2650969,'1','208','1038',479,'Retail Sale Id 1642201',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 09:52:49','',''),(2650970,'1','208','1038',479,'Retail Sale Id 1642202',3402.32,0.00,0.00,5.99,245.59,'2022-02-02 09:56:56','',''),(2650971,'1','208','1038',479,'Retail Sale Id 1642203',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 09:57:54','',''),(2650972,'1','208','1038',479,'Retail Sale Id 1642204',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 10:03:16','',''),(2650973,'1','208','1038',479,'Retail Sale Id 1642205',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 10:04:28','',''),(2650974,'1','208','1038',479,'Retail Sale Id 1642206',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 10:10:33','',''),(2650975,'1','208','1038',479,'Retail Sale Id 1642206',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 10:10:33','',''),(2650976,'1','208','1038',479,'Retail Sale Id 1642208',1749.44,0.00,0.00,3.08,126.28,'2022-02-02 10:18:17','',''),(2650977,'1','208','1038',479,'Retail Sale Id 1642210',2851.36,0.00,0.00,5.02,205.82,'2022-02-02 10:22:57','',''),(2650978,'1','208','1038',479,'Retail Sale Id 1642211',5498.24,0.00,0.00,9.68,396.88,'2022-02-02 10:54:38','',''),(2650979,'1','208','1038',479,'Retail Sale Id 1642212',999.68,0.00,0.00,1.76,72.16,'2022-02-02 10:55:50','',''),(2650980,'1','208','1038',479,'Retail Sale Id 1642213',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 10:56:38','',''),(2650981,'1','208','1038',479,'Retail Sale Id 1642214',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 11:01:57','',''),(2650982,'1','208','1038',479,'Retail Sale Id 1642215',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 11:04:20','',''),(2650983,'1','208','1038',479,'Retail Sale Id 1642216',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 11:07:51','',''),(2650984,'1','208','1038',479,'Retail Sale Id 1642217',6997.76,0.00,0.00,12.32,505.12,'2022-02-02 11:09:29','',''),(2650985,'1','208','1038',479,'Retail Sale Id 1642218',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 11:10:50','',''),(2650986,'1','208','1038',479,'Retail Sale Id 1642219',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 11:14:05','',''),(2650987,'1','208','1038',479,'Retail Sale Id 1642220',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 11:15:12','',''),(2650988,'1','208','1038',479,'Retail Sale Id 1642221',1698.32,0.00,0.00,2.99,122.59,'2022-02-02 11:17:16','',''),(2650989,'1','208','1038',479,'Retail Sale Id 1642222',2300.40,0.00,0.00,4.05,166.05,'2022-02-02 11:18:42','',''),(2650990,'1','208','1038',479,'Retail Sale Id 1642223',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 11:25:21','',''),(2650991,'1','208','1038',479,'Retail Sale Id 1642224',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 11:34:35','',''),(2650992,'1','208','1038',479,'Retail Sale Id 1642225',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 11:42:22','',''),(2650993,'1','208','1038',479,'Retail Sale Id 1642226',2851.36,0.00,0.00,5.02,205.82,'2022-02-02 11:44:28','',''),(2650994,'1','208','1038',479,'Retail Sale Id 1642227',1499.52,0.00,0.00,2.64,108.24,'2022-02-02 11:46:06','',''),(2650995,'1','208','1038',479,'Retail Sale Id 1642228',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 11:53:27','',''),(2650996,'1','208','1038',479,'Retail Sale Id 1642229',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 11:59:32','',''),(2650997,'1','208','1038',479,'Retail Sale Id 1642230',3998.72,0.00,0.00,7.04,288.64,'2022-02-02 12:02:17','',''),(2650998,'1','208','1038',479,'Retail Sale Id 1642231',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 12:05:45','',''),(2650999,'1','208','1038',479,'Retail Sale Id 1642232',2851.36,0.00,0.00,5.02,205.82,'2022-02-02 12:16:15','',''),(2651000,'1','208','1038',479,'Retail Sale Id 1642233',1147.36,0.00,0.00,2.02,82.82,'2022-02-02 12:29:35','',''),(2651001,'1','208','1038',479,'Retail Sale Id 1642234',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 12:46:04','',''),(2651002,'1','208','1038',479,'Retail Sale Id 1642235',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 12:52:12','',''),(2651003,'1','208','1038',479,'Retail Sale Id 1642236',3419.36,0.00,0.00,6.02,246.82,'2022-02-02 12:56:08','',''),(2651004,'1','208','1038',479,'Retail Sale Id 1642237',698.64,0.00,0.00,1.23,50.43,'2022-02-02 12:57:49','',''),(2651005,'1','208','1038',479,'Retail Sale Id 1642238',1704.00,0.00,0.00,3.00,123.00,'2022-02-02 12:59:50','',''),(2651006,'1','208','1038',479,'Retail Sale Id 1642238',5680.00,0.00,0.00,10.00,410.00,'2022-02-02 12:59:50','',''),(2651007,'1','208','1038',479,'Retail Sale Id 1642239',8497.28,0.00,0.00,14.96,613.36,'2022-02-02 13:06:51','',''),(2651008,'1','208','1038',479,'Retail Sale Id 1642240',2840.00,0.00,0.00,5.00,205.00,'2022-02-02 13:08:02','',''),(2651009,'1','208','1038',479,'Retail Sale Id 1642240',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 13:08:02','',''),(2651010,'1','208','1038',479,'Retail Sale Id 1642241',2851.36,0.00,0.00,5.02,205.82,'2022-02-02 13:16:28','',''),(2651011,'1','208','1038',479,'Retail Sale Id 1642242',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 13:21:55','',''),(2651012,'1','208','1038',479,'Retail Sale Id 1642243',2851.36,0.00,0.00,5.02,205.82,'2022-02-02 13:22:56','',''),(2651013,'1','208','1038',479,'Retail Sale Id 1642244',6997.76,0.00,0.00,12.32,505.12,'2022-02-02 13:24:24','',''),(2651014,'1','208','1038',479,'Retail Sale Id 1642245',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 13:25:30','',''),(2651015,'1','208','1038',479,'Retail Sale Id 1642246',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 13:30:53','',''),(2651016,'1','208','1038',479,'Retail Sale Id 1642246',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 13:30:53','',''),(2651017,'1','208','1038',479,'Retail Sale Id 1642247',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 13:33:29','',''),(2651018,'1','208','1038',479,'Retail Sale Id 1642248',3998.72,0.00,0.00,7.04,288.64,'2022-02-02 13:36:33','',''),(2651019,'1','208','1038',479,'Retail Sale Id 1642249',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 13:40:01','',''),(2651020,'1','208','1038',479,'Retail Sale Id 1642250',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 13:41:11','',''),(2651021,'1','208','1038',479,'Retail Sale Id 1642251',1749.44,0.00,0.00,3.08,126.28,'2022-02-02 13:41:58','',''),(2651022,'1','208','1038',479,'Retail Sale Id 1642252',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 13:43:13','',''),(2651023,'1','208','1038',479,'Retail Sale Id 1642253',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 13:44:45','',''),(2651024,'1','208','1038',479,'Retail Sale Id 1642254',1698.32,0.00,0.00,2.99,122.59,'2022-02-02 13:46:11','',''),(2651025,'1','208','1038',479,'Retail Sale Id 1642255',1499.52,0.00,0.00,2.64,108.24,'2022-02-02 13:47:36','',''),(2651026,'1','208','1038',479,'Retail Sale Id 1642255',2999.04,0.00,0.00,5.28,216.48,'2022-02-02 13:47:36','',''),(2651027,'1','208','1038',479,'Retail Sale Id 1642256',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 13:54:30','',''),(2651028,'1','208','1038',479,'Retail Sale Id 1642260',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 14:00:05','',''),(2651029,'1','208','1038',479,'Retail Sale Id 1642261',2851.36,0.00,0.00,5.02,205.82,'2022-02-02 14:04:19','',''),(2651030,'1','208','1038',479,'Retail Sale Id 1642262',1698.32,0.00,0.00,2.99,122.59,'2022-02-02 14:05:26','',''),(2651031,'1','208','1038',479,'Retail Sale Id 1642263',1749.44,0.00,0.00,3.08,126.28,'2022-02-02 14:10:33','',''),(2651032,'1','208','1038',479,'Retail Sale Id 1642264',2999.04,0.00,0.00,5.28,216.48,'2022-02-02 14:11:28','',''),(2651033,'1','208','1038',479,'Retail Sale Id 1642265',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 14:16:56','',''),(2651034,'1','208','1038',479,'Retail Sale Id 1642266',2800.24,0.00,0.00,4.93,202.13,'2022-02-02 14:17:50','',''),(2651035,'1','208','1038',479,'Retail Sale Id 1642267',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 14:23:56','',''),(2651036,'1','208','1038',479,'Retail Sale Id 1642269',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 14:48:17','',''),(2651037,'1','208','1038',479,'Retail Sale Id 1642270',1749.44,0.00,0.00,3.08,126.28,'2022-02-02 14:49:21','',''),(2651038,'1','208','1038',479,'Retail Sale Id 1642271',5680.00,0.00,0.00,10.00,410.00,'2022-02-02 14:55:36','',''),(2651039,'1','208','1038',479,'Retail Sale Id 1642272',1147.36,0.00,0.00,2.02,82.82,'2022-02-02 14:56:51','',''),(2651040,'1','208','1038',479,'Retail Sale Id 1642278',2499.20,0.00,0.00,4.40,180.40,'2022-02-02 15:07:46','',''),(2651041,'1','208','1038',479,'Retail Sale Id 1642279',2851.36,0.00,0.00,5.02,205.82,'2022-02-02 15:08:43','',''),(2651042,'1','208','1038',479,'Retail Sale Id 1642280',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 15:09:26','',''),(2651043,'1','208','1038',479,'Retail Sale Id 1642281',3998.72,0.00,0.00,7.04,288.64,'2022-02-02 15:10:21','',''),(2651044,'1','208','1038',479,'Retail Sale Id 1642282',1420.00,0.00,0.00,2.50,102.50,'2022-02-02 15:11:38','',''),(2651045,'1','208','1038',479,'Retail Sale Id 1642283',999.68,0.00,0.00,1.76,72.16,'2022-02-02 15:26:50','',''),(2651046,'1','208','1038',479,'Retail Sale Id 1642284',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 15:27:38','',''),(2651047,'1','208','1038',479,'Retail Sale Id 1642285',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 15:28:58','',''),(2651048,'1','208','1038',479,'Retail Sale Id 1642286',1499.52,0.00,0.00,2.64,108.24,'2022-02-02 15:31:31','',''),(2651049,'1','208','1038',479,'Retail Sale Id 1642287',3402.32,0.00,0.00,5.99,245.59,'2022-02-02 15:50:23','',''),(2651050,'1','208','1038',479,'Retail Sale Id 1642288',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 15:51:59','',''),(2651051,'1','208','1038',479,'Retail Sale Id 1642289',1749.44,0.00,0.00,3.08,126.28,'2022-02-02 15:53:12','',''),(2651052,'1','208','1038',479,'Retail Sale Id 1642289',1749.44,0.00,0.00,3.08,126.28,'2022-02-02 15:53:12','',''),(2651053,'1','208','1038',479,'Retail Sale Id 1642290',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 15:54:10','',''),(2651054,'1','208','1038',479,'Retail Sale Id 1642291',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 15:55:10','',''),(2651055,'1','208','1038',479,'Retail Sale Id 1642292',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 15:56:00','',''),(2651056,'1','208','1038',479,'Retail Sale Id 1642293',5680.00,0.00,0.00,10.00,410.00,'2022-02-02 15:56:44','',''),(2651057,'1','208','1038',479,'Retail Sale Id 1642294',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 15:58:03','',''),(2651058,'1','208','1038',479,'Retail Sale Id 1642294',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 15:58:03','',''),(2651059,'1','208','1038',479,'Retail Sale Id 1642295',1408.64,0.00,0.00,2.48,101.68,'2022-02-02 15:59:20','',''),(2651060,'1','208','1038',479,'Retail Sale Id 1642296',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 16:01:14','',''),(2651061,'1','208','1038',479,'Retail Sale Id 1642298',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 16:02:27','',''),(2651062,'1','208','1038',479,'Retail Sale Id 1642300',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 16:03:56','',''),(2651063,'1','208','1038',479,'Retail Sale Id 1642301',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 16:04:41','',''),(2651064,'1','208','1038',479,'Retail Sale Id 1642305',28400.00,0.00,0.00,50.00,2050.00,'2022-02-02 16:16:55','',''),(2651065,'1','208','1038',479,'Retail Sale Id 1642306',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 16:18:07','',''),(2651066,'1','208','1038',479,'Retail Sale Id 1642307',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 16:19:41','',''),(2651067,'1','208','1038',479,'Retail Sale Id 1642308',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 16:21:20','',''),(2651068,'1','208','1038',479,'Retail Sale Id 1642308',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 16:21:20','',''),(2651069,'1','208','1038',479,'Retail Sale Id 1642309',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 16:22:08','',''),(2651070,'1','208','1038',479,'Retail Sale Id 1642310',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 16:23:05','',''),(2651071,'1','208','1038',479,'Retail Sale Id 1642311',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 16:24:13','',''),(2651072,'1','208','1038',479,'Retail Sale Id 1642312',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 16:27:03','',''),(2651073,'1','208','1038',479,'Retail Sale Id 1642313',999.68,0.00,0.00,1.76,72.16,'2022-02-02 16:31:30','',''),(2651074,'1','208','1038',479,'Retail Sale Id 1642314',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 16:34:51','',''),(2651075,'1','208','1038',479,'Retail Sale Id 1642314',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 16:34:51','',''),(2651076,'1','208','1038',479,'Retail Sale Id 1642315',1709.68,0.00,0.00,3.01,123.41,'2022-02-02 16:36:18','',''),(2651077,'1','208','1038',479,'Retail Sale Id 1642316',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 16:37:47','',''),(2651078,'1','208','1038',479,'Retail Sale Id 1642317',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 16:38:38','',''),(2651079,'1','208','1038',479,'Retail Sale Id 1642318',2999.04,0.00,0.00,5.28,216.48,'2022-02-02 16:39:32','',''),(2651080,'1','208','1038',479,'Retail Sale Id 1642319',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 16:43:57','',''),(2651081,'1','208','1038',479,'Retail Sale Id 1642320',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 16:45:40','',''),(2651082,'1','208','1038',479,'Retail Sale Id 1642321',1499.52,0.00,0.00,2.64,108.24,'2022-02-02 16:50:14','',''),(2651083,'1','208','1038',479,'Retail Sale Id 1642322',1902.80,0.00,0.00,3.35,137.35,'2022-02-02 16:51:48','',''),(2651084,'1','208','1038',479,'Retail Sale Id 1642323',3498.88,0.00,0.00,6.16,252.56,'2022-02-02 16:53:04','',''),(2651085,'1','208','1038',479,'Retail Sale Id 1642324',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 17:01:50','',''),(2651086,'1','208','1038',479,'Retail Sale Id 1642325',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 17:06:00','',''),(2651087,'1','208','1038',479,'Retail Sale Id 1642326',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 17:08:51','',''),(2651088,'1','208','1038',479,'Retail Sale Id 1642327',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 17:11:15','',''),(2651089,'1','208','1038',479,'Retail Sale Id 1642328',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 17:12:41','',''),(2651090,'1','208','1038',479,'Retail Sale Id 1642329',2999.04,0.00,0.00,5.28,216.48,'2022-02-02 17:15:38','',''),(2651091,'1','208','1038',479,'Retail Sale Id 1642330',2999.04,0.00,0.00,5.28,216.48,'2022-02-02 17:21:50','',''),(2651092,'1','208','1038',479,'Retail Sale Id 1642331',2840.00,0.00,0.00,5.00,205.00,'2022-02-02 17:24:01','',''),(2651093,'1','208','1038',479,'Retail Sale Id 1642332',499.84,0.00,0.00,0.88,36.08,'2022-02-02 17:28:53','',''),(2651094,'1','208','1038',479,'Retail Sale Id 1642333',7100.00,0.00,0.00,12.50,512.50,'2022-02-02 17:39:20','',''),(2651095,'1','208','1038',479,'Retail Sale Id 1642334',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 17:40:31','',''),(2651096,'1','208','1038',479,'Retail Sale Id 1642335',2840.00,0.00,0.00,5.00,205.00,'2022-02-02 17:45:14','',''),(2651097,'1','208','1038',479,'Retail Sale Id 1642336',2999.04,0.00,0.00,5.28,216.48,'2022-02-02 17:48:14','',''),(2651098,'1','208','1038',479,'Retail Sale Id 1642338',4998.40,0.00,0.00,8.80,360.80,'2022-02-02 17:49:03','',''),(2651099,'1','208','1038',479,'Retail Sale Id 1642339',2840.00,0.00,0.00,5.00,205.00,'2022-02-02 17:56:08','',''),(2651100,'1','208','1038',479,'Retail Sale Id 1642340',602.08,0.00,0.00,1.06,43.46,'2022-02-02 17:57:44','',''),(2651101,'1','208','1038',479,'Retail Sale Id 1642341',999.68,0.00,0.00,1.76,72.16,'2022-02-02 18:00:24','',''),(2651102,'1','208','1038',479,'Retail Sale Id 1642343',2999.04,0.00,0.00,5.28,216.48,'2022-02-02 18:01:41','',''),(2651103,'1','208','1038',479,'Retail Sale Id 1642344',1198.48,0.00,0.00,2.11,86.51,'2022-02-02 18:02:48','',''),(2651104,'1','208','1038',479,'Retail Sale Id 1642345',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 18:06:20','',''),(2651105,'1','208','1038',479,'Retail Sale Id 1642346',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 18:09:32','',''),(2651106,'1','208','1038',479,'Retail Sale Id 1642347',5998.08,0.00,0.00,10.56,432.96,'2022-02-02 18:12:04','',''),(2651107,'1','208','1038',479,'Retail Sale Id 1642348',5680.00,0.00,0.00,10.00,410.00,'2022-02-02 18:13:15','',''),(2651108,'1','208','1038',479,'Retail Sale Id 1642349',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 18:16:52','',''),(2651109,'1','208','1038',479,'Retail Sale Id 1642350',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 18:19:47','',''),(2651110,'1','208','1038',479,'Retail Sale Id 1642351',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 18:21:21','',''),(2651111,'1','208','1038',479,'Retail Sale Id 1642352',2499.20,0.00,0.00,4.40,180.40,'2022-02-02 18:28:42','',''),(2651112,'1','208','1038',479,'Retail Sale Id 1642353',3408.00,0.00,0.00,6.00,246.00,'2022-02-02 18:31:03','',''),(2651113,'1','208','1038',479,'Retail Sale Id 1642354',2800.24,0.00,0.00,4.93,202.13,'2022-02-02 18:33:19','',''),(2651114,'1','208','1038',479,'Retail Sale Id 1642355',2800.24,0.00,0.00,4.93,202.13,'2022-02-02 18:59:29','',''),(2651115,'1','208','1038',479,'Retail Sale Id 1642357',3402.32,0.00,0.00,5.99,245.59,'2022-02-02 19:09:03','',''),(2651116,'1','208','1038',479,'Retail Sale Id 1642358',3998.72,0.00,0.00,7.04,288.64,'2022-02-02 19:13:09','',''),(2651117,'1','208','1038',479,'Retail Sale Id 1642359',1999.36,0.00,0.00,3.52,144.32,'2022-02-02 19:22:10','',''),(2651118,'1','208','1038',479,'Retail Sale Id 1642360',4998.40,0.00,0.00,8.80,360.80,'2022-02-02 19:40:49','',''),(2651119,'1','208','1038',479,'Retail Sale Id 1642361',999.68,0.00,0.00,1.76,72.16,'2022-02-02 19:51:37','',''),(2651120,'1','208','1038',479,'Retail Sale Id 1642362',602.08,0.00,0.00,1.06,43.46,'2022-02-02 19:54:03','',''),(2651121,'1','208','1038',479,'Retail Sale Id 1642363',27104.96,0.00,0.00,47.72,1956.52,'2022-02-02 22:50:14','',''),(2651122,'1','208','1038',479,'Retail Sale Id 1642364',13461.60,0.00,0.00,23.70,971.70,'2022-02-02 22:52:17','',''),(2651123,'1','208','1038',479,'Retail Sale Id 1642365',5680.00,0.00,0.00,10.00,410.00,'2022-02-03 08:30:37','',''),(2651124,'1','208','1038',479,'Retail Sale Id 1642366',1698.32,0.00,0.00,2.99,122.59,'2022-02-03 08:31:57','',''),(2651125,'1','208','1038',479,'Retail Sale Id 1642367',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 08:33:13','',''),(2651126,'1','208','1038',479,'Retail Sale Id 1642368',2840.00,0.00,0.00,5.00,205.00,'2022-02-03 08:36:34','',''),(2651127,'1','208','1038',479,'Retail Sale Id 1642369',5112.00,0.00,0.00,9.00,369.00,'2022-02-03 08:39:42','',''),(2651128,'1','208','1038',479,'Retail Sale Id 1642370',18499.76,0.00,0.00,32.57,1335.37,'2022-02-03 08:42:08','',''),(2651129,'1','208','1038',479,'Retail Sale Id 1642371',999.68,0.00,0.00,1.76,72.16,'2022-02-03 08:42:52','',''),(2651130,'1','208','1038',479,'Retail Sale Id 1642372',3498.88,0.00,0.00,6.16,252.56,'2022-02-03 08:48:43','',''),(2651131,'1','208','1038',479,'Retail Sale Id 1642373',2999.04,0.00,0.00,5.28,216.48,'2022-02-03 08:54:38','',''),(2651132,'1','208','1038',479,'Retail Sale Id 1642374',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 08:58:59','',''),(2651133,'1','208','1038',479,'Retail Sale Id 1642375',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 09:03:06','',''),(2651134,'1','208','1038',479,'Retail Sale Id 1642376',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 09:07:05','',''),(2651135,'1','208','1038',479,'Retail Sale Id 1642377',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 09:14:48','',''),(2651136,'1','208','1038',479,'Retail Sale Id 1642378',1499.52,0.00,0.00,2.64,108.24,'2022-02-03 09:16:11','',''),(2651137,'1','208','1038',479,'Retail Sale Id 1642379',3402.32,0.00,0.00,5.99,245.59,'2022-02-03 09:18:32','',''),(2651138,'1','208','1038',479,'Retail Sale Id 1642380',1709.68,0.00,0.00,3.01,123.41,'2022-02-03 09:26:36','',''),(2651139,'1','208','1038',479,'Retail Sale Id 1642381',4998.40,0.00,0.00,8.80,360.80,'2022-02-03 09:30:41','',''),(2651140,'1','208','1038',479,'Retail Sale Id 1642382',1499.52,0.00,0.00,2.64,108.24,'2022-02-03 09:32:20','',''),(2651141,'1','208','1038',479,'Retail Sale Id 1642383',3697.68,0.00,0.00,6.51,266.91,'2022-02-03 09:34:18','',''),(2651142,'1','208','1038',479,'Retail Sale Id 1642384',1800.56,0.00,0.00,3.17,129.97,'2022-02-03 09:35:21','',''),(2651143,'1','208','1038',479,'Retail Sale Id 1642385',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 09:36:03','',''),(2651144,'1','208','1038',479,'Retail Sale Id 1642386',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 09:40:07','',''),(2651145,'1','208','1038',479,'Retail Sale Id 1642387',3402.32,0.00,0.00,5.99,245.59,'2022-02-03 09:41:41','',''),(2651146,'1','208','1038',479,'Retail Sale Id 1642388',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 09:47:29','',''),(2651147,'1','208','1038',479,'Retail Sale Id 1642389',5498.24,0.00,0.00,9.68,396.88,'2022-02-03 09:48:56','',''),(2651148,'1','208','1038',479,'Retail Sale Id 1642390',1709.68,0.00,0.00,3.01,123.41,'2022-02-03 09:50:27','',''),(2651149,'1','208','1038',479,'Retail Sale Id 1642391',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 09:53:49','',''),(2651150,'1','208','1038',479,'Retail Sale Id 1642392',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 09:55:50','',''),(2651151,'1','208','1038',479,'Retail Sale Id 1642393',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 10:00:14','',''),(2651152,'1','208','1038',479,'Retail Sale Id 1642393',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 10:00:14','',''),(2651153,'1','208','1038',479,'Retail Sale Id 1642394',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 10:01:31','',''),(2651154,'1','208','1038',479,'Retail Sale Id 1642395',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 10:11:36','',''),(2651155,'1','208','1038',479,'Retail Sale Id 1642396',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 10:14:08','',''),(2651156,'1','208','1038',479,'Retail Sale Id 1642397',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 10:23:05','',''),(2651157,'1','208','1038',479,'Retail Sale Id 1642398',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 10:24:51','',''),(2651158,'1','208','1038',479,'Retail Sale Id 1642399',2800.24,0.00,0.00,4.93,202.13,'2022-02-03 10:47:14','',''),(2651159,'1','208','1038',479,'Retail Sale Id 1642400',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 10:48:05','',''),(2651160,'1','208','1038',479,'Retail Sale Id 1642401',1709.68,0.00,0.00,3.01,123.41,'2022-02-03 10:49:12','',''),(2651161,'1','208','1038',479,'Retail Sale Id 1642402',5680.00,0.00,0.00,10.00,410.00,'2022-02-03 10:50:25','',''),(2651162,'1','208','1038',479,'Retail Sale Id 1642403',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 10:51:29','',''),(2651163,'1','208','1038',479,'Retail Sale Id 1642404',5680.00,0.00,0.00,10.00,410.00,'2022-02-03 10:53:22','',''),(2651164,'1','208','1038',479,'Retail Sale Id 1642405',3998.72,0.00,0.00,7.04,288.64,'2022-02-03 10:57:23','',''),(2651165,'1','208','1038',479,'Retail Sale Id 1642406',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 10:58:40','',''),(2651166,'1','208','1038',479,'Retail Sale Id 1642407',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 11:01:14','',''),(2651167,'1','208','1038',479,'Retail Sale Id 1642408',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 11:02:15','',''),(2651168,'1','208','1038',479,'Retail Sale Id 1642409',2840.00,0.00,0.00,5.00,205.00,'2022-02-03 11:03:17','',''),(2651169,'1','208','1038',479,'Retail Sale Id 1642410',6997.76,0.00,0.00,12.32,505.12,'2022-02-03 11:04:44','',''),(2651170,'1','208','1038',479,'Retail Sale Id 1642411',6997.76,0.00,0.00,12.32,505.12,'2022-02-03 11:05:48','',''),(2651171,'1','208','1038',479,'Retail Sale Id 1642412',5680.00,0.00,0.00,10.00,410.00,'2022-02-03 11:06:36','',''),(2651172,'1','208','1038',479,'Retail Sale Id 1642413',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 11:23:27','',''),(2651173,'1','208','1038',479,'Retail Sale Id 1642414',2999.04,0.00,0.00,5.28,216.48,'2022-02-03 11:25:54','',''),(2651174,'1','208','1038',479,'Retail Sale Id 1642415',4998.40,0.00,0.00,8.80,360.80,'2022-02-03 11:26:48','',''),(2651175,'1','208','1038',479,'Retail Sale Id 1642416',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 11:33:54','',''),(2651176,'1','208','1038',479,'Retail Sale Id 1642417',1499.52,0.00,0.00,2.64,108.24,'2022-02-03 11:36:26','',''),(2651177,'1','208','1038',479,'Retail Sale Id 1642417',3498.88,0.00,0.00,6.16,252.56,'2022-02-03 11:36:26','',''),(2651178,'1','208','1038',479,'Retail Sale Id 1642418',12280.16,0.00,0.00,21.62,886.42,'2022-02-03 11:39:22','',''),(2651179,'1','208','1038',479,'Retail Sale Id 1642419',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 11:41:21','',''),(2651180,'1','208','1038',479,'Retail Sale Id 1642420',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 11:44:35','',''),(2651181,'1','208','1038',479,'Retail Sale Id 1642421',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 11:53:19','',''),(2651182,'1','208','1038',479,'Retail Sale Id 1642422',5998.08,0.00,0.00,10.56,432.96,'2022-02-03 12:15:26','',''),(2651183,'1','208','1038',479,'Retail Sale Id 1642423',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 12:19:31','',''),(2651184,'1','208','1038',479,'Retail Sale Id 1642424',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 12:34:12','',''),(2651185,'1','208','1038',479,'Retail Sale Id 1642425',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 12:37:54','',''),(2651186,'1','208','1038',479,'Retail Sale Id 1642426',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 12:40:43','',''),(2651187,'1','208','1038',479,'Retail Sale Id 1642427',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 12:54:47','',''),(2651188,'1','208','1038',479,'Retail Sale Id 1642428',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 13:07:42','',''),(2651189,'1','208','1038',479,'Retail Sale Id 1642428',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 13:07:42','',''),(2651190,'1','208','1038',479,'Retail Sale Id 1642429',3402.32,0.00,0.00,5.99,245.59,'2022-02-03 13:10:04','',''),(2651191,'1','208','1038',479,'Retail Sale Id 1642430',698.64,0.00,0.00,1.23,50.43,'2022-02-03 13:14:30','',''),(2651192,'1','208','1038',479,'Retail Sale Id 1642431',1130.32,0.00,0.00,1.99,81.59,'2022-02-03 13:26:36','',''),(2651193,'1','208','1038',479,'Retail Sale Id 1642432',2999.04,0.00,0.00,5.28,216.48,'2022-02-03 13:31:07','',''),(2651194,'1','208','1038',479,'Retail Sale Id 1642433',1709.68,0.00,0.00,3.01,123.41,'2022-02-03 13:38:38','',''),(2651195,'1','208','1038',479,'Retail Sale Id 1642434',1709.68,0.00,0.00,3.01,123.41,'2022-02-03 13:45:57','',''),(2651196,'1','208','1038',479,'Retail Sale Id 1642435',2999.04,0.00,0.00,5.28,216.48,'2022-02-03 13:47:38','',''),(2651197,'1','208','1038',479,'Retail Sale Id 1642436',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 13:52:19','',''),(2651198,'1','208','1038',479,'Retail Sale Id 1642437',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 13:56:59','',''),(2651199,'1','208','1038',479,'Retail Sale Id 1642438',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 14:05:57','',''),(2651200,'1','208','1038',479,'Retail Sale Id 1642439',5498.24,0.00,0.00,9.68,396.88,'2022-02-03 14:08:31','',''),(2651201,'1','208','1038',479,'Retail Sale Id 1642440',2999.04,0.00,0.00,5.28,216.48,'2022-02-03 14:20:22','',''),(2651202,'1','208','1038',479,'Retail Sale Id 1642441',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 14:23:16','',''),(2651203,'1','208','1038',479,'Retail Sale Id 1642442',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 14:27:49','',''),(2651204,'1','208','1038',479,'Retail Sale Id 1642443',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 14:29:18','',''),(2651205,'1','208','1038',479,'Retail Sale Id 1642444',1704.00,0.00,0.00,3.00,123.00,'2022-02-03 14:34:50','',''),(2651206,'1','208','1038',479,'Retail Sale Id 1642444',2840.00,0.00,0.00,5.00,205.00,'2022-02-03 14:34:50','',''),(2651207,'1','208','1038',479,'Retail Sale Id 1642445',5998.08,0.00,0.00,10.56,432.96,'2022-02-03 14:36:19','',''),(2651208,'1','208','1038',479,'Retail Sale Id 1642446',1709.68,0.00,0.00,3.01,123.41,'2022-02-03 14:48:27','',''),(2651209,'1','208','1038',479,'Retail Sale Id 1642447',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 14:51:48','',''),(2651210,'1','208','1038',479,'Retail Sale Id 1642448',1198.48,0.00,0.00,2.11,86.51,'2022-02-03 15:07:20','',''),(2651211,'1','208','1038',479,'Retail Sale Id 1642449',5998.08,0.00,0.00,10.56,432.96,'2022-02-03 15:15:29','',''),(2651212,'1','208','1038',479,'Retail Sale Id 1642450',1709.68,0.00,0.00,3.01,123.41,'2022-02-03 15:24:52','',''),(2651213,'1','208','1038',479,'Retail Sale Id 1642451',2999.04,0.00,0.00,5.28,216.48,'2022-02-03 15:29:59','',''),(2651214,'1','208','1038',479,'Retail Sale Id 1642452',1698.32,0.00,0.00,2.99,122.59,'2022-02-03 15:34:57','',''),(2651215,'1','208','1038',479,'Retail Sale Id 1642453',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 15:37:40','',''),(2651216,'1','208','1038',479,'Retail Sale Id 1642454',2840.00,0.00,0.00,5.00,205.00,'2022-02-03 15:39:15','',''),(2651217,'1','208','1038',479,'Retail Sale Id 1642454',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 15:39:15','',''),(2651218,'1','208','1038',479,'Retail Sale Id 1642455',2999.04,0.00,0.00,5.28,216.48,'2022-02-03 15:41:22','',''),(2651219,'1','208','1038',479,'Retail Sale Id 1642456',6997.76,0.00,0.00,12.32,505.12,'2022-02-03 15:42:06','',''),(2651220,'1','208','1038',479,'Retail Sale Id 1642457',2840.00,0.00,0.00,5.00,205.00,'2022-02-03 15:46:59','',''),(2651221,'1','208','1038',479,'Retail Sale Id 1642458',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 15:48:11','',''),(2651222,'1','208','1038',479,'Retail Sale Id 1642459',800.88,0.00,0.00,1.41,57.81,'2022-02-03 15:50:33','',''),(2651223,'1','208','1038',479,'Retail Sale Id 1642460',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 15:52:50','',''),(2651224,'1','208','1038',479,'Retail Sale Id 1642461',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 15:54:30','',''),(2651225,'1','208','1038',479,'Retail Sale Id 1642462',3402.32,0.00,0.00,5.99,245.59,'2022-02-03 15:55:53','',''),(2651226,'1','208','1038',479,'Retail Sale Id 1642463',2840.00,0.00,0.00,5.00,205.00,'2022-02-03 16:13:13','',''),(2651227,'1','208','1038',479,'Retail Sale Id 1642464',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 16:49:53','',''),(2651228,'1','208','1038',479,'Retail Sale Id 1642465',499.84,0.00,0.00,0.88,36.08,'2022-02-03 16:51:27','',''),(2651229,'1','208','1038',479,'Retail Sale Id 1642466',3998.72,0.00,0.00,7.04,288.64,'2022-02-03 16:52:32','',''),(2651230,'1','208','1038',479,'Retail Sale Id 1642467',5680.00,0.00,0.00,10.00,410.00,'2022-02-03 16:53:44','',''),(2651231,'1','208','1038',479,'Retail Sale Id 1642468',3402.32,0.00,0.00,5.99,245.59,'2022-02-03 16:55:07','',''),(2651232,'1','208','1038',479,'Retail Sale Id 1642469',1499.52,0.00,0.00,2.64,108.24,'2022-02-03 16:56:19','',''),(2651233,'1','208','1038',479,'Retail Sale Id 1642469',1499.52,0.00,0.00,2.64,108.24,'2022-02-03 16:56:19','',''),(2651234,'1','208','1038',479,'Retail Sale Id 1642470',4998.40,0.00,0.00,8.80,360.80,'2022-02-03 16:57:06','',''),(2651235,'1','208','1038',479,'Retail Sale Id 1642471',2840.00,0.00,0.00,5.00,205.00,'2022-02-03 17:07:12','',''),(2651236,'1','208','1038',479,'Retail Sale Id 1642472',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 17:08:05','',''),(2651237,'1','208','1038',479,'Retail Sale Id 1642473',2499.20,0.00,0.00,4.40,180.40,'2022-02-03 17:09:13','',''),(2651238,'1','208','1038',479,'Retail Sale Id 1642474',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 17:12:09','',''),(2651239,'1','208','1038',479,'Retail Sale Id 1642475',3498.88,0.00,0.00,6.16,252.56,'2022-02-03 17:13:17','',''),(2651240,'1','208','1038',479,'Retail Sale Id 1642476',2840.00,0.00,0.00,5.00,205.00,'2022-02-03 17:14:20','',''),(2651241,'1','208','1038',479,'Retail Sale Id 1642477',3998.72,0.00,0.00,7.04,288.64,'2022-02-03 17:17:44','',''),(2651242,'1','208','1038',479,'Retail Sale Id 1642478',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 17:23:04','',''),(2651243,'1','208','1038',479,'Retail Sale Id 1642479',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 17:24:48','',''),(2651244,'1','208','1038',479,'Retail Sale Id 1642480',2800.24,0.00,0.00,4.93,202.13,'2022-02-03 17:25:52','',''),(2651245,'1','208','1038',479,'Retail Sale Id 1642481',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 17:28:28','',''),(2651246,'1','208','1038',479,'Retail Sale Id 1642482',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 17:29:23','',''),(2651247,'1','208','1038',479,'Retail Sale Id 1642483',61792.72,0.00,0.00,108.79,4460.39,'2022-02-03 17:31:20','',''),(2651248,'1','208','1038',479,'Retail Sale Id 1642484',41026.64,0.00,0.00,72.23,2961.43,'2022-02-03 17:32:21','',''),(2651249,'1','208','1038',479,'Retail Sale Id 1642485',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 17:35:03','',''),(2651250,'1','208','1038',479,'Retail Sale Id 1642486',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 17:35:48','',''),(2651251,'1','208','1038',479,'Retail Sale Id 1642487',2840.00,0.00,0.00,5.00,205.00,'2022-02-03 17:37:04','',''),(2651252,'1','208','1038',479,'Retail Sale Id 1642488',1704.00,0.00,0.00,3.00,123.00,'2022-02-03 17:40:39','',''),(2651253,'1','208','1038',479,'Retail Sale Id 1642489',1704.00,0.00,0.00,3.00,123.00,'2022-02-03 17:42:13','',''),(2651254,'1','208','1038',479,'Retail Sale Id 1642489',1704.00,0.00,0.00,3.00,123.00,'2022-02-03 17:42:13','',''),(2651255,'1','208','1038',479,'Retail Sale Id 1642490',3998.72,0.00,0.00,7.04,288.64,'2022-02-03 17:43:47','',''),(2651256,'1','208','1038',479,'Retail Sale Id 1642491',1499.52,0.00,0.00,2.64,108.24,'2022-02-03 17:45:09','',''),(2651257,'1','208','1038',479,'Retail Sale Id 1642491',6497.92,0.00,0.00,11.44,469.04,'2022-02-03 17:45:09','',''),(2651258,'1','208','1038',479,'Retail Sale Id 1642492',999.68,0.00,0.00,1.76,72.16,'2022-02-03 17:49:15','',''),(2651259,'1','208','1038',479,'Retail Sale Id 1642493',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 17:51:17','',''),(2651260,'1','208','1038',479,'Retail Sale Id 1642494',10792.00,0.00,0.00,19.00,779.00,'2022-02-03 17:55:05','',''),(2651261,'1','208','1038',479,'Retail Sale Id 1642495',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 17:56:06','',''),(2651262,'1','208','1038',479,'Retail Sale Id 1642496',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 18:07:51','',''),(2651263,'1','208','1038',479,'Retail Sale Id 1642497',3408.00,0.00,0.00,6.00,246.00,'2022-02-03 18:09:09','',''),(2651264,'1','208','1038',479,'Return of Retail Sale Id 1642483',0.00,61792.72,108.79,0.00,-4460.39,'2022-02-03 18:11:08','',''),(2651265,'1','208','1038',479,'Retail Sale Id 1642498',2800.24,0.00,0.00,4.93,202.13,'2022-02-03 18:16:49','',''),(2651266,'1','208','1038',479,'Retail Sale Id 1642499',1499.52,0.00,0.00,2.64,108.24,'2022-02-03 18:18:00','',''),(2651267,'1','208','1038',479,'Retail Sale Id 1642500',5680.00,0.00,0.00,10.00,410.00,'2022-02-03 18:20:07','',''),(2651268,'1','208','1038',479,'Retail Sale Id 1642501',1999.36,0.00,0.00,3.52,144.32,'2022-02-03 18:25:46','',''),(2651269,'1','208','1038',479,'Retail Sale Id 1642502',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 18:27:09','',''),(2651270,'1','208','1038',479,'Retail Sale Id 1642503',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 18:32:13','',''),(2651271,'1','208','1038',479,'Retail Sale Id 1642504',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 18:34:30','',''),(2651272,'1','208','1038',479,'Retail Sale Id 1642505',4998.40,0.00,0.00,8.80,360.80,'2022-02-03 18:39:02','',''),(2651273,'1','208','1038',479,'Retail Sale Id 1642506',3998.72,0.00,0.00,7.04,288.64,'2022-02-03 19:53:38','',''),(2651274,'1','208','1038',479,'Retail Sale Id 1642507',7100.00,0.00,0.00,12.50,512.50,'2022-02-03 19:59:10','',''),(2651275,'1','208','1038',479,'Retail Sale Id 1642508',10672.72,0.00,0.00,18.79,770.39,'2022-02-03 20:22:41','',''),(2651276,'1','208','1038',479,'Retail Sale Id 1642509',43605.36,0.00,0.00,76.77,3147.57,'2022-02-03 20:24:32','',''),(2651277,'1','208','1038',479,'Retail Sale Id 1642510',25889.44,0.00,0.00,45.58,1868.78,'2022-02-03 20:26:27','',''),(2651278,'1','208','1038',479,'Retail Sale Id 1642511',6997.76,0.00,0.00,12.32,505.12,'2022-02-04 07:35:55','',''),(2651279,'1','208','1038',479,'Retail Sale Id 1642512',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 07:48:58','',''),(2651280,'1','208','1038',479,'Retail Sale Id 1642513',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 07:51:21','',''),(2651281,'1','208','1038',479,'Retail Sale Id 1642514',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 07:52:33','',''),(2651282,'1','208','1038',479,'Retail Sale Id 1642516',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 07:53:51','',''),(2651283,'1','208','1038',479,'Retail Sale Id 1642517',3998.72,0.00,0.00,7.04,288.64,'2022-02-04 07:54:56','',''),(2651284,'1','208','1038',479,'Retail Sale Id 1642518',1698.32,0.00,0.00,2.99,122.59,'2022-02-04 07:56:07','',''),(2651285,'1','208','1038',479,'Retail Sale Id 1642519',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 07:57:05','',''),(2651286,'1','208','1038',479,'Retail Sale Id 1642520',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 08:05:49','',''),(2651287,'1','208','1038',479,'Retail Sale Id 1642521',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 08:08:50','',''),(2651288,'1','208','1038',479,'Retail Sale Id 1642523',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 08:10:29','',''),(2651289,'1','208','1038',479,'Retail Sale Id 1642524',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 08:11:29','',''),(2651290,'1','208','1038',479,'Retail Sale Id 1642525',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 08:16:34','',''),(2651291,'1','208','1038',479,'Retail Sale Id 1642526',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 08:17:47','',''),(2651292,'1','208','1038',479,'Retail Sale Id 1642526',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 08:17:47','',''),(2651293,'1','208','1038',479,'Retail Sale Id 1642527',2851.36,0.00,0.00,5.02,205.82,'2022-02-04 08:20:15','',''),(2651294,'1','208','1038',479,'Retail Sale Id 1642528',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 08:21:11','',''),(2651295,'1','208','1038',479,'Retail Sale Id 1642529',6997.76,0.00,0.00,12.32,505.12,'2022-02-04 08:22:09','',''),(2651296,'1','208','1038',479,'Retail Sale Id 1642530',1721.04,0.00,0.00,3.03,124.23,'2022-02-04 08:23:09','',''),(2651297,'1','208','1038',479,'Retail Sale Id 1642531',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 08:24:15','',''),(2651298,'1','208','1038',479,'Retail Sale Id 1642532',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 08:25:02','',''),(2651299,'1','208','1038',479,'Retail Sale Id 1642533',2851.36,0.00,0.00,5.02,205.82,'2022-02-04 08:29:46','',''),(2651300,'1','208','1038',479,'Retail Sale Id 1642534',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 08:37:55','',''),(2651301,'1','208','1038',479,'Retail Sale Id 1642535',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 08:39:26','',''),(2651302,'1','208','1038',479,'Retail Sale Id 1642536',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 08:41:20','',''),(2651303,'1','208','1038',479,'Retail Sale Id 1642537',1499.52,0.00,0.00,2.64,108.24,'2022-02-04 08:42:28','',''),(2651304,'1','208','1038',479,'Retail Sale Id 1642538',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 08:48:08','',''),(2651305,'1','208','1038',479,'Retail Sale Id 1642539',999.68,0.00,0.00,1.76,72.16,'2022-02-04 08:54:27','',''),(2651306,'1','208','1038',479,'Retail Sale Id 1642540',6997.76,0.00,0.00,12.32,505.12,'2022-02-04 08:56:17','',''),(2651307,'1','208','1038',479,'Retail Sale Id 1642541',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 08:57:04','',''),(2651308,'1','208','1038',479,'Retail Sale Id 1642542',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 08:58:33','',''),(2651309,'1','208','1038',479,'Retail Sale Id 1642543',2851.36,0.00,0.00,5.02,205.82,'2022-02-04 08:59:39','',''),(2651310,'1','208','1038',479,'Retail Sale Id 1642544',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 09:06:51','',''),(2651311,'1','208','1038',479,'Retail Sale Id 1642545',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 09:15:24','',''),(2651312,'1','208','1038',479,'Retail Sale Id 1642546',5702.72,0.00,0.00,10.04,411.64,'2022-02-04 09:16:45','',''),(2651313,'1','208','1038',479,'Retail Sale Id 1642547',2851.36,0.00,0.00,5.02,205.82,'2022-02-04 09:18:01','',''),(2651314,'1','208','1038',479,'Retail Sale Id 1642548',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 09:19:12','',''),(2651315,'1','208','1038',479,'Retail Sale Id 1642549',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 09:20:43','',''),(2651316,'1','208','1038',479,'Retail Sale Id 1642550',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 09:22:31','',''),(2651317,'1','208','1038',479,'Retail Sale Id 1642551',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 09:23:25','',''),(2651318,'1','208','1038',479,'Retail Sale Id 1642552',2300.40,0.00,0.00,4.05,166.05,'2022-02-04 09:24:21','',''),(2651319,'1','208','1038',479,'Retail Sale Id 1642553',4998.40,0.00,0.00,8.80,360.80,'2022-02-04 09:30:10','',''),(2651320,'1','208','1038',479,'Retail Sale Id 1642554',3998.72,0.00,0.00,7.04,288.64,'2022-02-04 09:36:15','',''),(2651321,'1','208','1038',479,'Retail Sale Id 1642555',999.68,0.00,0.00,1.76,72.16,'2022-02-04 09:40:16','',''),(2651322,'1','208','1038',479,'Retail Sale Id 1642556',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 09:41:12','',''),(2651323,'1','208','1038',479,'Retail Sale Id 1642557',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 09:42:29','',''),(2651324,'1','208','1038',479,'Retail Sale Id 1642558',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 09:50:59','',''),(2651325,'1','208','1038',479,'Retail Sale Id 1642559',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 09:52:54','',''),(2651326,'1','208','1038',479,'Retail Sale Id 1642561',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 10:00:33','',''),(2651327,'1','208','1038',479,'Retail Sale Id 1642563',602.08,0.00,0.00,1.06,43.46,'2022-02-04 10:12:40','',''),(2651328,'1','208','1038',479,'Retail Sale Id 1642564',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 10:13:46','',''),(2651329,'1','208','1038',479,'Retail Sale Id 1642565',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 10:14:52','',''),(2651330,'1','208','1038',479,'Retail Sale Id 1642566',2499.20,0.00,0.00,4.40,180.40,'2022-02-04 10:15:56','',''),(2651331,'1','208','1038',479,'Retail Sale Id 1642567',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 10:18:28','',''),(2651332,'1','208','1038',479,'Retail Sale Id 1642568',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 10:19:32','',''),(2651333,'1','208','1038',479,'Retail Sale Id 1642569',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 10:21:11','',''),(2651334,'1','208','1038',479,'Retail Sale Id 1642570',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 10:25:04','',''),(2651335,'1','208','1038',479,'Retail Sale Id 1642571',568.00,0.00,0.00,1.00,41.00,'2022-02-04 10:27:46','',''),(2651336,'1','208','1038',479,'Retail Sale Id 1642572',4430.40,0.00,0.00,7.80,319.80,'2022-02-04 10:28:32','',''),(2651337,'1','208','1038',479,'Retail Sale Id 1642573',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 10:30:44','',''),(2651338,'1','208','1038',479,'Retail Sale Id 1642574',5998.08,0.00,0.00,10.56,432.96,'2022-02-04 10:32:40','',''),(2651339,'1','208','1038',479,'Retail Sale Id 1642575',1499.52,0.00,0.00,2.64,108.24,'2022-02-04 10:39:25','',''),(2651340,'1','208','1038',479,'Retail Sale Id 1642576',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 10:41:19','',''),(2651341,'1','208','1038',479,'Retail Sale Id 1642576',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 10:41:19','',''),(2651342,'1','208','1038',479,'Retail Sale Id 1642577',1499.52,0.00,0.00,2.64,108.24,'2022-02-04 10:42:43','',''),(2651343,'1','208','1038',479,'Retail Sale Id 1642578',999.68,0.00,0.00,1.76,72.16,'2022-02-04 10:43:21','',''),(2651344,'1','208','1038',479,'Retail Sale Id 1642579',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 10:44:27','',''),(2651345,'1','208','1038',479,'Retail Sale Id 1642580',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 10:45:57','',''),(2651346,'1','208','1038',479,'Retail Sale Id 1642581',2840.00,0.00,0.00,5.00,205.00,'2022-02-04 10:47:01','',''),(2651347,'1','208','1038',479,'Retail Sale Id 1642582',1698.32,0.00,0.00,2.99,122.59,'2022-02-04 11:02:11','',''),(2651348,'1','208','1038',479,'Retail Sale Id 1642583',5680.00,0.00,0.00,10.00,410.00,'2022-02-04 11:03:23','',''),(2651349,'1','208','1038',479,'Retail Sale Id 1642584',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 11:05:44','',''),(2651350,'1','208','1038',479,'Retail Sale Id 1642585',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 11:08:54','',''),(2651351,'1','208','1038',479,'Retail Sale Id 1642586',999.68,0.00,0.00,1.76,72.16,'2022-02-04 11:11:28','',''),(2651352,'1','208','1038',479,'Retail Sale Id 1642587',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 11:12:06','',''),(2651353,'1','208','1038',479,'Retail Sale Id 1642588',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 11:13:21','',''),(2651354,'1','208','1038',479,'Retail Sale Id 1642589',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 11:18:00','',''),(2651355,'1','208','1038',479,'Retail Sale Id 1642590',1698.32,0.00,0.00,2.99,122.59,'2022-02-04 11:27:27','',''),(2651356,'1','208','1038',479,'Retail Sale Id 1642592',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 11:48:56','',''),(2651357,'1','208','1038',479,'Retail Sale Id 1642593',5998.08,0.00,0.00,10.56,432.96,'2022-02-04 11:55:03','',''),(2651358,'1','208','1038',479,'Retail Sale Id 1642594',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 11:58:03','',''),(2651359,'1','208','1038',479,'Retail Sale Id 1642595',602.08,0.00,0.00,1.06,43.46,'2022-02-04 11:59:43','',''),(2651360,'1','208','1038',479,'Retail Sale Id 1642596',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 12:01:00','',''),(2651361,'1','208','1038',479,'Retail Sale Id 1642598',5100.64,0.00,0.00,8.98,368.18,'2022-02-04 12:11:24','',''),(2651362,'1','208','1038',479,'Retail Sale Id 1642599',5112.00,0.00,0.00,9.00,369.00,'2022-02-04 12:15:43','',''),(2651363,'1','208','1038',479,'Retail Sale Id 1642599',5112.00,0.00,0.00,9.00,369.00,'2022-02-04 12:15:43','',''),(2651364,'1','208','1038',479,'Retail Sale Id 1642600',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 12:17:46','',''),(2651365,'1','208','1038',479,'Retail Sale Id 1642601',2499.20,0.00,0.00,4.40,180.40,'2022-02-04 12:20:09','',''),(2651366,'1','208','1038',479,'Retail Sale Id 1642602',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 12:22:48','',''),(2651367,'1','208','1038',479,'Retail Sale Id 1642602',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 12:22:48','',''),(2651368,'1','208','1038',479,'Retail Sale Id 1642602',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 12:22:48','',''),(2651369,'1','208','1038',479,'Retail Sale Id 1642603',4998.40,0.00,0.00,8.80,360.80,'2022-02-04 12:24:01','',''),(2651370,'1','208','1038',479,'Retail Sale Id 1642604',1800.56,0.00,0.00,3.17,129.97,'2022-02-04 12:25:07','',''),(2651371,'1','208','1038',479,'Retail Sale Id 1642605',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 12:26:39','',''),(2651372,'1','208','1038',479,'Retail Sale Id 1642606',2300.40,0.00,0.00,4.05,166.05,'2022-02-04 12:32:09','',''),(2651373,'1','208','1038',479,'Retail Sale Id 1642607',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 12:33:56','',''),(2651374,'1','208','1038',479,'Retail Sale Id 1642608',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 12:41:56','',''),(2651375,'1','208','1038',479,'Retail Sale Id 1642609',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 12:47:05','',''),(2651376,'1','208','1038',479,'Retail Sale Id 1642610',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 12:52:59','',''),(2651377,'1','208','1038',479,'Retail Sale Id 1642611',698.64,0.00,0.00,1.23,50.43,'2022-02-04 12:56:35','',''),(2651378,'1','208','1038',479,'Retail Sale Id 1642612',5640.24,0.00,0.00,9.93,407.13,'2022-02-04 13:07:31','',''),(2651379,'1','208','1038',479,'Retail Sale Id 1642613',1499.52,0.00,0.00,2.64,108.24,'2022-02-04 13:13:55','',''),(2651380,'1','208','1038',479,'Retail Sale Id 1642615',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 13:20:10','',''),(2651381,'1','208','1038',479,'Retail Sale Id 1642616',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 14:01:35','',''),(2651382,'1','208','1038',479,'Retail Sale Id 1642617',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 14:02:23','',''),(2651383,'1','208','1038',479,'Retail Sale Id 1642618',6997.76,0.00,0.00,12.32,505.12,'2022-02-04 14:03:24','',''),(2651384,'1','208','1038',479,'Retail Sale Id 1642619',2300.40,0.00,0.00,4.05,166.05,'2022-02-04 14:08:16','',''),(2651385,'1','208','1038',479,'Retail Sale Id 1642620',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 14:13:20','',''),(2651386,'1','208','1038',479,'Retail Sale Id 1642622',1749.44,0.00,0.00,3.08,126.28,'2022-02-04 14:31:48','',''),(2651387,'1','208','1038',479,'Retail Sale Id 1642623',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 14:34:45','',''),(2651388,'1','208','1038',479,'Retail Sale Id 1642624',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 14:35:47','',''),(2651389,'1','208','1038',479,'Retail Sale Id 1642625',5998.08,0.00,0.00,10.56,432.96,'2022-02-04 14:37:37','',''),(2651390,'1','208','1038',479,'Retail Sale Id 1642626',4998.40,0.00,0.00,8.80,360.80,'2022-02-04 14:38:42','',''),(2651391,'1','208','1038',479,'Retail Sale Id 1642627',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 14:39:54','',''),(2651392,'1','208','1038',479,'Retail Sale Id 1642628',4998.40,0.00,0.00,8.80,360.80,'2022-02-04 14:40:37','',''),(2651393,'1','208','1038',479,'Retail Sale Id 1642629',1198.48,0.00,0.00,2.11,86.51,'2022-02-04 14:46:26','',''),(2651394,'1','208','1038',479,'Retail Sale Id 1642631',511.20,0.00,0.00,0.90,36.90,'2022-02-04 14:50:40','',''),(2651395,'1','208','1038',479,'Retail Sale Id 1642632',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 14:59:03','',''),(2651396,'1','208','1038',479,'Retail Sale Id 1642633',2840.00,0.00,0.00,5.00,205.00,'2022-02-04 15:00:51','',''),(2651397,'1','208','1038',479,'Retail Sale Id 1642634',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 15:02:27','',''),(2651398,'1','208','1038',479,'Retail Sale Id 1642635',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 15:21:16','',''),(2651399,'1','208','1038',479,'Retail Sale Id 1642636',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 15:22:59','',''),(2651400,'1','208','1038',479,'Retail Sale Id 1642637',2499.20,0.00,0.00,4.40,180.40,'2022-02-04 15:33:19','',''),(2651401,'1','208','1038',479,'Retail Sale Id 1642638',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 15:34:34','',''),(2651402,'1','208','1038',479,'Retail Sale Id 1642639',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 15:44:08','',''),(2651403,'1','208','1038',479,'Retail Sale Id 1642639',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 15:44:08','',''),(2651404,'1','208','1038',479,'Retail Sale Id 1642640',1499.52,0.00,0.00,2.64,108.24,'2022-02-04 15:48:59','',''),(2651405,'1','208','1038',479,'Retail Sale Id 1642641',5401.68,0.00,0.00,9.51,389.91,'2022-02-04 15:53:33','',''),(2651406,'1','208','1038',479,'Retail Sale Id 1642641',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 15:53:33','',''),(2651407,'1','208','1038',479,'Retail Sale Id 1642642',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 15:54:51','',''),(2651408,'1','208','1038',479,'Retail Sale Id 1642643',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 16:04:58','',''),(2651409,'1','208','1038',479,'Retail Sale Id 1642644',1499.52,0.00,0.00,2.64,108.24,'2022-02-04 16:06:00','',''),(2651410,'1','208','1038',479,'Retail Sale Id 1642645',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 16:15:55','',''),(2651411,'1','208','1038',479,'Retail Sale Id 1642646',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 16:23:00','',''),(2651412,'1','208','1038',479,'Retail Sale Id 1642646',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 16:23:00','',''),(2651413,'1','208','1038',479,'Retail Sale Id 1642647',6997.76,0.00,0.00,12.32,505.12,'2022-02-04 16:25:10','',''),(2651414,'1','208','1038',479,'Retail Sale Id 1642648',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 16:25:54','',''),(2651415,'1','208','1038',479,'Retail Sale Id 1642649',999.68,0.00,0.00,1.76,72.16,'2022-02-04 16:26:28','',''),(2651416,'1','208','1038',479,'Retail Sale Id 1642650',1300.72,0.00,0.00,2.29,93.89,'2022-02-04 16:27:14','',''),(2651417,'1','208','1038',479,'Retail Sale Id 1642651',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 16:30:10','',''),(2651418,'1','208','1038',479,'Retail Sale Id 1642652',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 16:31:29','',''),(2651419,'1','208','1038',479,'Retail Sale Id 1642653',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 16:35:32','',''),(2651420,'1','208','1038',479,'Retail Sale Id 1642654',2840.00,0.00,0.00,5.00,205.00,'2022-02-04 16:40:48','',''),(2651421,'1','208','1038',479,'Retail Sale Id 1642655',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 16:41:31','',''),(2651422,'1','208','1038',479,'Retail Sale Id 1642656',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 16:43:52','',''),(2651423,'1','208','1038',479,'Retail Sale Id 1642657',6997.76,0.00,0.00,12.32,505.12,'2022-02-04 16:44:51','',''),(2651424,'1','208','1038',479,'Retail Sale Id 1642658',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 16:45:40','',''),(2651425,'1','208','1038',479,'Retail Sale Id 1642659',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 16:52:41','',''),(2651426,'1','208','1038',479,'Retail Sale Id 1642660',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 17:01:29','',''),(2651427,'1','208','1038',479,'Retail Sale Id 1642661',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 17:04:21','',''),(2651428,'1','208','1038',479,'Retail Sale Id 1642662',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 17:06:21','',''),(2651429,'1','208','1038',479,'Retail Sale Id 1642663',5998.08,0.00,0.00,10.56,432.96,'2022-02-04 17:12:38','',''),(2651430,'1','208','1038',479,'Retail Sale Id 1642665',1999.36,0.00,0.00,3.52,144.32,'2022-02-04 17:13:37','',''),(2651431,'1','208','1038',479,'Retail Sale Id 1642666',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 17:19:41','',''),(2651432,'1','208','1038',479,'Retail Sale Id 1642667',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 17:22:04','',''),(2651433,'1','208','1038',479,'Retail Sale Id 1642669',3402.32,0.00,0.00,5.99,245.59,'2022-02-04 17:23:21','',''),(2651434,'1','208','1038',479,'Retail Sale Id 1642669',3402.32,0.00,0.00,5.99,245.59,'2022-02-04 17:23:21','',''),(2651435,'1','208','1038',479,'Retail Sale Id 1642671',5680.00,0.00,0.00,10.00,410.00,'2022-02-04 17:25:48','',''),(2651436,'1','208','1038',479,'Retail Sale Id 1642672',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 17:55:30','',''),(2651437,'1','208','1038',479,'Retail Sale Id 1642673',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 17:58:02','',''),(2651438,'1','208','1038',479,'Retail Sale Id 1642674',2840.00,0.00,0.00,5.00,205.00,'2022-02-04 17:59:10','',''),(2651439,'1','208','1038',479,'Retail Sale Id 1642675',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 18:00:13','',''),(2651440,'1','208','1038',479,'Retail Sale Id 1642676',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 18:01:14','',''),(2651441,'1','208','1038',479,'Retail Sale Id 1642677',499.84,0.00,0.00,0.88,36.08,'2022-02-04 18:02:13','',''),(2651442,'1','208','1038',479,'Retail Sale Id 1642678',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 18:03:49','',''),(2651443,'1','208','1038',479,'Retail Sale Id 1642680',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 18:06:51','',''),(2651444,'1','208','1038',479,'Retail Sale Id 1642682',3998.72,0.00,0.00,7.04,288.64,'2022-02-04 18:08:04','',''),(2651445,'1','208','1038',479,'Retail Sale Id 1642683',1499.52,0.00,0.00,2.64,108.24,'2022-02-04 18:11:04','',''),(2651446,'1','208','1038',479,'Retail Sale Id 1642683',2499.20,0.00,0.00,4.40,180.40,'2022-02-04 18:11:04','',''),(2651447,'1','208','1038',479,'Retail Sale Id 1642684',3402.32,0.00,0.00,5.99,245.59,'2022-02-04 18:12:26','',''),(2651448,'1','208','1038',479,'Retail Sale Id 1642685',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 18:13:56','',''),(2651449,'1','208','1038',479,'Retail Sale Id 1642686',3408.00,0.00,0.00,6.00,246.00,'2022-02-04 18:16:27','',''),(2651450,'1','208','1038',479,'Retail Sale Id 1642687',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 18:19:09','',''),(2651451,'1','208','1038',479,'Retail Sale Id 1642687',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 18:19:09','',''),(2651452,'1','208','1038',479,'Retail Sale Id 1642688',1601.76,0.00,0.00,2.82,115.62,'2022-02-04 18:20:10','',''),(2651453,'1','208','1038',479,'Retail Sale Id 1642689',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 18:21:28','',''),(2651454,'1','208','1038',479,'Retail Sale Id 1642690',499.84,0.00,0.00,0.88,36.08,'2022-02-04 18:23:31','',''),(2651455,'1','208','1038',479,'Retail Sale Id 1642691',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 18:24:40','',''),(2651456,'1','208','1038',479,'Retail Sale Id 1642692',499.84,0.00,0.00,0.88,36.08,'2022-02-04 18:28:48','',''),(2651457,'1','208','1038',479,'Retail Sale Id 1642692',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 18:28:48','',''),(2651458,'1','208','1038',479,'Retail Sale Id 1642693',2300.40,0.00,0.00,4.05,166.05,'2022-02-04 18:29:33','',''),(2651459,'1','208','1038',479,'Retail Sale Id 1642694',2800.24,0.00,0.00,4.93,202.13,'2022-02-04 18:48:51','',''),(2651460,'1','208','1038',479,'Retail Sale Id 1642695',2999.04,0.00,0.00,5.28,216.48,'2022-02-04 18:49:46','',''),(2651461,'1','208','1038',479,'Retail Sale Id 1642696',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 18:51:20','',''),(2651462,'1','208','1038',479,'Retail Sale Id 1642696',1709.68,0.00,0.00,3.01,123.41,'2022-02-04 18:51:20','',''),(2651463,'1','208','1038',479,'Retail Sale Id 1642697',7100.00,0.00,0.00,12.50,512.50,'2022-02-04 19:00:01','',''),(2651464,'1','208','1038',479,'Retail Sale Id 1642698',1198.48,0.00,0.00,2.11,86.51,'2022-02-04 19:10:34','',''),(2651465,'1','208','1038',479,'Retail Sale Id 1642699',5680.00,0.00,0.00,10.00,410.00,'2022-02-04 19:11:27','',''),(2651466,'1','208','1038',479,'Retail Sale Id 1642703',1749.44,0.00,0.00,3.08,126.28,'2022-02-04 19:26:40','',''),(2651467,'1','208','1038',479,'Retail Sale Id 1642704',3998.72,0.00,0.00,7.04,288.64,'2022-02-04 19:37:28','',''),(2651468,'1','208','1038',479,'Retail Sale Id 1642705',3498.88,0.00,0.00,6.16,252.56,'2022-02-04 19:40:06','',''),(2651469,'1','208','1038',479,'Retail Sale Id 1642706',28400.00,0.00,0.00,50.00,2050.00,'2022-02-04 19:59:01','',''),(2651470,'1','208','1038',479,'Retail Sale Id 1642709',1698.32,0.00,0.00,2.99,122.59,'2022-02-04 20:04:59','',''),(2651471,'1','208','1038',479,'Retail Sale Id 1642710',124.96,0.00,0.00,0.22,9.02,'2022-02-04 23:01:42','',''),(2651472,'1','208','1038',479,'Retail Sale Id 1642711',1306.40,0.00,0.00,2.30,94.30,'2022-02-04 23:03:07','',''),(2651473,'1','208','1038',479,'Return of Retail Sale Id 1642587',0.00,7100.00,12.50,0.00,-512.50,'2022-02-04 23:06:05','',''),(2651474,'1','208','1038',479,'Return of Retail Sale Id 1642589',0.00,7100.00,12.50,0.00,-512.50,'2022-02-04 23:08:09','',''),(2651475,'1','208','1038',479,'Return of Retail Sale Id 1642623',0.00,7100.00,12.50,0.00,-512.50,'2022-02-04 23:10:24','',''),(2651476,'1','208','1038',479,'Retail Sale Id 1642712',6816.00,0.00,0.00,12.00,492.00,'2022-02-04 23:14:44','',''),(2651477,'1','208','1038',479,'Retail Sale Id 1642713',11587.20,0.00,0.00,20.40,836.40,'2022-02-04 23:16:47','',''),(2651478,'1','208','1038',479,'Retail Sale Id 1642714',34.08,0.00,0.00,0.06,2.46,'2022-02-04 23:21:07','',''),(2651479,'1','208','1038',479,'Retail Sale Id 1642715',3402.32,0.00,0.00,5.99,245.59,'2022-02-05 07:39:21','',''),(2651480,'1','208','1038',479,'Retail Sale Id 1642716',1999.36,0.00,0.00,3.52,144.32,'2022-02-05 07:40:09','',''),(2651481,'1','208','1038',479,'Retail Sale Id 1642717',4998.40,0.00,0.00,8.80,360.80,'2022-02-05 07:40:57','',''),(2651482,'1','208','1038',479,'Retail Sale Id 1642718',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 07:42:08','',''),(2651483,'1','208','1038',479,'Retail Sale Id 1642719',602.08,0.00,0.00,1.06,43.46,'2022-02-05 07:43:09','',''),(2651484,'1','208','1038',479,'Retail Sale Id 1642720',1709.68,0.00,0.00,3.01,123.41,'2022-02-05 07:44:50','',''),(2651485,'1','208','1038',479,'Retail Sale Id 1642721',1698.32,0.00,0.00,2.99,122.59,'2022-02-05 07:52:54','',''),(2651486,'1','208','1038',479,'Retail Sale Id 1642722',5680.00,0.00,0.00,10.00,410.00,'2022-02-05 07:54:28','',''),(2651487,'1','208','1038',479,'Retail Sale Id 1642723',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 08:10:46','',''),(2651488,'1','208','1038',479,'Retail Sale Id 1642724',1698.32,0.00,0.00,2.99,122.59,'2022-02-05 08:15:41','',''),(2651489,'1','208','1038',479,'Retail Sale Id 1642725',999.68,0.00,0.00,1.76,72.16,'2022-02-05 08:16:24','',''),(2651490,'1','208',NULL,479,'Reception corrector for bridging 132389',0.00,0.00,0.00,5000.00,0.00,'2022-02-05 09:52:41','',''),(2651491,'1','208','1038',479,'Received from bridging 132389',0.00,0.00,5000.00,0.00,0.00,'2022-02-05 09:52:41','',''),(2651492,'1','208','1038',479,'Retail Sale Id 1642727',3402.32,0.00,0.00,5.99,245.59,'2022-02-05 09:58:20','',''),(2651493,'1','208','1038',479,'Retail Sale Id 1642728',1999.36,0.00,0.00,3.52,144.32,'2022-02-05 10:06:08','',''),(2651494,'1','208','1038',479,'Retail Sale Id 1642729',2999.04,0.00,0.00,5.28,216.48,'2022-02-05 10:07:16','',''),(2651495,'1','208','1038',479,'Retail Sale Id 1642730',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 10:08:44','',''),(2651496,'1','208','1038',479,'Retail Sale Id 1642731',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 10:10:52','',''),(2651497,'1','208','1038',479,'Retail Sale Id 1642732',61497.36,0.00,0.00,108.27,4439.07,'2022-02-05 10:11:47','',''),(2651498,'1','208','1038',479,'Retail Sale Id 1642733',999.68,0.00,0.00,1.76,72.16,'2022-02-05 10:13:22','',''),(2651499,'1','208','1038',479,'Retail Sale Id 1642734',3498.88,0.00,0.00,6.16,252.56,'2022-02-05 10:14:16','',''),(2651500,'1','208','1038',479,'Retail Sale Id 1642735',3129.68,0.00,0.00,5.51,225.91,'2022-02-05 10:21:04','',''),(2651501,'1','208','1038',479,'Retail Sale Id 1642736',1999.36,0.00,0.00,3.52,144.32,'2022-02-05 10:22:08','',''),(2651502,'1','208','1038',479,'Retail Sale Id 1642737',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 10:26:01','',''),(2651503,'1','208','1038',479,'Retail Sale Id 1642738',2999.04,0.00,0.00,5.28,216.48,'2022-02-05 10:27:51','',''),(2651504,'1','208','1038',479,'Retail Sale Id 1642739',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 10:39:07','',''),(2651505,'1','208','1038',479,'Retail Sale Id 1642739',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 10:39:07','',''),(2651506,'1','208','1038',479,'Retail Sale Id 1642740',1999.36,0.00,0.00,3.52,144.32,'2022-02-05 10:43:19','',''),(2651507,'1','208','1038',479,'Retail Sale Id 1642741',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 10:45:41','',''),(2651508,'1','208','1038',479,'Retail Sale Id 1642742',2840.00,0.00,0.00,5.00,205.00,'2022-02-05 10:48:54','',''),(2651509,'1','208','1038',479,'Retail Sale Id 1642743',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 10:52:36','',''),(2651510,'1','208','1038',479,'Retail Sale Id 1642743',5680.00,0.00,0.00,10.00,410.00,'2022-02-05 10:52:36','',''),(2651511,'1','208','1038',479,'Retail Sale Id 1642744',5839.04,0.00,0.00,10.28,421.48,'2022-02-05 10:54:12','',''),(2651512,'1','208','1038',479,'Retail Sale Id 1642745',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 10:56:23','',''),(2651513,'1','208','1038',479,'Retail Sale Id 1642746',2851.36,0.00,0.00,5.02,205.82,'2022-02-05 10:58:29','',''),(2651514,'1','208','1038',479,'Retail Sale Id 1642747',1147.36,0.00,0.00,2.02,82.82,'2022-02-05 11:00:08','',''),(2651515,'1','208','1038',479,'Retail Sale Id 1642748',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 11:01:33','',''),(2651516,'1','208','1038',479,'Retail Sale Id 1642749',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 11:04:23','',''),(2651517,'1','208','1038',479,'Retail Sale Id 1642750',602.08,0.00,0.00,1.06,43.46,'2022-02-05 11:15:28','',''),(2651518,'1','208','1038',479,'Retail Sale Id 1642751',1499.52,0.00,0.00,2.64,108.24,'2022-02-05 11:23:44','',''),(2651519,'1','208','1038',479,'Retail Sale Id 1642752',999.68,0.00,0.00,1.76,72.16,'2022-02-05 11:25:09','',''),(2651520,'1','208','1038',479,'Retail Sale Id 1642753',3709.04,0.00,0.00,6.53,267.73,'2022-02-05 11:28:20','',''),(2651521,'1','208','1038',479,'Retail Sale Id 1642754',28400.00,0.00,0.00,50.00,2050.00,'2022-02-05 11:32:17','',''),(2651522,'1','208','1038',479,'Retail Sale Id 1642755',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 11:40:18','',''),(2651523,'1','208','1038',479,'Retail Sale Id 1642756',800.88,0.00,0.00,1.41,57.81,'2022-02-05 11:45:40','',''),(2651524,'1','208','1038',479,'Retail Sale Id 1642757',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 11:49:06','',''),(2651525,'1','208','1038',479,'Retail Sale Id 1642758',2840.00,0.00,0.00,5.00,205.00,'2022-02-05 11:50:36','',''),(2651526,'1','208','1038',479,'Retail Sale Id 1642759',6798.96,0.00,0.00,11.97,490.77,'2022-02-05 11:52:45','',''),(2651527,'1','208','1038',479,'Retail Sale Id 1642760',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 12:06:34','',''),(2651528,'1','208','1038',479,'Retail Sale Id 1642761',3402.32,0.00,0.00,5.99,245.59,'2022-02-05 12:08:09','',''),(2651529,'1','208','1038',479,'Retail Sale Id 1642762',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 12:15:56','',''),(2651530,'1','208','1038',479,'Retail Sale Id 1642763',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 12:20:13','',''),(2651531,'1','208','1038',479,'Retail Sale Id 1642764',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 12:26:07','',''),(2651532,'1','208','1038',479,'Retail Sale Id 1642764',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 12:26:07','',''),(2651533,'1','208','1038',479,'Retail Sale Id 1642765',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 12:27:47','',''),(2651534,'1','208','1038',479,'Retail Sale Id 1642766',698.64,0.00,0.00,1.23,50.43,'2022-02-05 12:29:24','',''),(2651535,'1','208','1038',479,'Retail Sale Id 1642767',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 12:35:19','',''),(2651536,'1','208','1038',479,'Retail Sale Id 1642768',1709.68,0.00,0.00,3.01,123.41,'2022-02-05 12:38:06','',''),(2651537,'1','208','1038',479,'Retail Sale Id 1642769',2999.04,0.00,0.00,5.28,216.48,'2022-02-05 12:39:58','',''),(2651538,'1','208','1038',479,'Retail Sale Id 1642770',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 12:42:00','',''),(2651539,'1','208','1038',479,'Retail Sale Id 1642771',2300.40,0.00,0.00,4.05,166.05,'2022-02-05 12:43:30','',''),(2651540,'1','208','1038',479,'Retail Sale Id 1642772',3998.72,0.00,0.00,7.04,288.64,'2022-02-05 12:44:29','',''),(2651541,'1','208','1038',479,'Retail Sale Id 1642773',1300.72,0.00,0.00,2.29,93.89,'2022-02-05 12:48:22','',''),(2651542,'1','208','1038',479,'Retail Sale Id 1642774',2840.00,0.00,0.00,5.00,205.00,'2022-02-05 12:56:33','',''),(2651543,'1','208','1038',479,'Retail Sale Id 1642775',4998.40,0.00,0.00,8.80,360.80,'2022-02-05 13:01:16','',''),(2651544,'1','208','1038',479,'Retail Sale Id 1642776',2999.04,0.00,0.00,5.28,216.48,'2022-02-05 13:03:43','',''),(2651545,'1','208','1038',479,'Retail Sale Id 1642777',1709.68,0.00,0.00,3.01,123.41,'2022-02-05 13:05:35','',''),(2651546,'1','208','1038',479,'Retail Sale Id 1642777',1709.68,0.00,0.00,3.01,123.41,'2022-02-05 13:05:35','',''),(2651547,'1','208','1038',479,'Retail Sale Id 1642781',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 13:12:13','',''),(2651548,'1','208','1038',479,'Retail Sale Id 1642782',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 13:13:13','',''),(2651549,'1','208','1038',479,'Retail Sale Id 1642783',1698.32,0.00,0.00,2.99,122.59,'2022-02-05 13:18:32','',''),(2651550,'1','208','1038',479,'Retail Sale Id 1642784',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 13:19:38','',''),(2651551,'1','208','1038',479,'Retail Sale Id 1642785',5680.00,0.00,0.00,10.00,410.00,'2022-02-05 13:21:37','',''),(2651552,'1','208','1038',479,'Retail Sale Id 1642786',5998.08,0.00,0.00,10.56,432.96,'2022-02-05 13:26:16','',''),(2651553,'1','208','1038',479,'Retail Sale Id 1642787',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 13:36:32','',''),(2651554,'1','208','1038',479,'Retail Sale Id 1642787',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 13:36:32','',''),(2651555,'1','208','1038',479,'Retail Sale Id 1642788',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 13:39:12','',''),(2651556,'1','208','1038',479,'Retail Sale Id 1642789',1999.36,0.00,0.00,3.52,144.32,'2022-02-05 13:40:18','',''),(2651557,'1','208','1038',479,'Retail Sale Id 1642790',1499.52,0.00,0.00,2.64,108.24,'2022-02-05 13:43:04','',''),(2651558,'1','208','1038',479,'Retail Sale Id 1642790',12001.84,0.00,0.00,21.13,866.33,'2022-02-05 13:43:04','',''),(2651559,'1','208','1038',479,'Retail Sale Id 1642791',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 13:44:46','',''),(2651560,'1','208','1038',479,'Retail Sale Id 1642792',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 13:47:01','',''),(2651561,'1','208','1038',479,'Retail Sale Id 1642793',3402.32,0.00,0.00,5.99,245.59,'2022-02-05 13:51:03','',''),(2651562,'1','208','1038',479,'Retail Sale Id 1642794',3998.72,0.00,0.00,7.04,288.64,'2022-02-05 14:03:19','',''),(2651563,'1','208','1038',479,'Retail Sale Id 1642795',2999.04,0.00,0.00,5.28,216.48,'2022-02-05 14:06:58','',''),(2651564,'1','208','1038',479,'Retail Sale Id 1642796',602.08,0.00,0.00,1.06,43.46,'2022-02-05 14:08:12','',''),(2651565,'1','208','1038',479,'Retail Sale Id 1642797',1499.52,0.00,0.00,2.64,108.24,'2022-02-05 14:11:58','',''),(2651566,'1','208','1038',479,'Retail Sale Id 1642798',1999.36,0.00,0.00,3.52,144.32,'2022-02-05 14:14:17','',''),(2651567,'1','208','1038',479,'Retail Sale Id 1642799',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 14:15:27','',''),(2651568,'1','208','1038',479,'Retail Sale Id 1642799',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 14:15:27','',''),(2651569,'1','208','1038',479,'Retail Sale Id 1642800',1709.68,0.00,0.00,3.01,123.41,'2022-02-05 14:16:39','',''),(2651570,'1','208','1038',479,'Retail Sale Id 1642801',1698.32,0.00,0.00,2.99,122.59,'2022-02-05 14:17:40','',''),(2651571,'1','208','1038',479,'Retail Sale Id 1642802',1698.32,0.00,0.00,2.99,122.59,'2022-02-05 14:18:26','',''),(2651572,'1','208','1038',479,'Retail Sale Id 1642803',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 14:23:12','',''),(2651573,'1','208','1038',479,'Retail Sale Id 1642804',2999.04,0.00,0.00,5.28,216.48,'2022-02-05 14:24:20','',''),(2651574,'1','208','1038',479,'Retail Sale Id 1642805',999.68,0.00,0.00,1.76,72.16,'2022-02-05 14:25:12','',''),(2651575,'1','208','1038',479,'Retail Sale Id 1642806',999.68,0.00,0.00,1.76,72.16,'2022-02-05 14:25:53','',''),(2651576,'1','208','1038',479,'Retail Sale Id 1642807',2800.24,0.00,0.00,4.93,202.13,'2022-02-05 14:27:59','',''),(2651577,'1','208','1038',479,'Retail Sale Id 1642808',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 14:36:52','',''),(2651578,'1','208','1038',479,'Retail Sale Id 1642809',1800.56,0.00,0.00,3.17,129.97,'2022-02-05 14:47:08','',''),(2651579,'1','208','1038',479,'Retail Sale Id 1642809',5998.08,0.00,0.00,10.56,432.96,'2022-02-05 14:47:08','',''),(2651580,'1','208','1038',479,'Retail Sale Id 1642810',2851.36,0.00,0.00,5.02,205.82,'2022-02-05 14:49:14','',''),(2651581,'1','208','1038',479,'Retail Sale Id 1642811',1698.32,0.00,0.00,2.99,122.59,'2022-02-05 14:55:48','',''),(2651582,'1','208','1038',479,'Retail Sale Id 1642812',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 14:58:44','',''),(2651583,'1','208','1038',479,'Retail Sale Id 1642813',1709.68,0.00,0.00,3.01,123.41,'2022-02-05 15:04:38','',''),(2651584,'1','208','1038',479,'Retail Sale Id 1642813',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 15:04:38','',''),(2651585,'1','208','1038',479,'Retail Sale Id 1642814',1698.32,0.00,0.00,2.99,122.59,'2022-02-05 15:06:14','',''),(2651586,'1','208','1038',479,'Retail Sale Id 1642815',2158.40,0.00,0.00,3.80,155.80,'2022-02-05 15:09:18','',''),(2651587,'1','208','1038',479,'Retail Sale Id 1642816',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 15:10:35','',''),(2651588,'1','208','1038',479,'Retail Sale Id 1642817',2999.04,0.00,0.00,5.28,216.48,'2022-02-05 15:20:23','',''),(2651589,'1','208','1038',479,'Retail Sale Id 1642818',2499.20,0.00,0.00,4.40,180.40,'2022-02-05 15:21:33','',''),(2651590,'1','208','1038',479,'Retail Sale Id 1642819',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 15:23:02','',''),(2651591,'1','208','1038',479,'Retail Sale Id 1642820',4998.40,0.00,0.00,8.80,360.80,'2022-02-05 15:24:47','',''),(2651592,'1','208','1038',479,'Retail Sale Id 1642821',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 15:29:52','',''),(2651593,'1','208','1038',479,'Retail Sale Id 1642822',1709.68,0.00,0.00,3.01,123.41,'2022-02-05 15:31:25','',''),(2651594,'1','208','1038',479,'Retail Sale Id 1642823',2851.36,0.00,0.00,5.02,205.82,'2022-02-05 15:32:49','',''),(2651595,'1','208','1038',479,'Retail Sale Id 1642825',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 15:36:56','',''),(2651596,'1','208','1038',479,'Retail Sale Id 1642826',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 15:39:38','',''),(2651597,'1','208','1038',479,'Retail Sale Id 1642827',999.68,0.00,0.00,1.76,72.16,'2022-02-05 15:44:33','',''),(2651598,'1','208','1038',479,'Retail Sale Id 1642828',698.64,0.00,0.00,1.23,50.43,'2022-02-05 15:50:57','',''),(2651599,'1','208','1038',479,'Retail Sale Id 1642829',3998.72,0.00,0.00,7.04,288.64,'2022-02-05 16:02:24','',''),(2651600,'1','208','1038',479,'Retail Sale Id 1642830',999.68,0.00,0.00,1.76,72.16,'2022-02-05 16:04:43','',''),(2651601,'1','208','1038',479,'Retail Sale Id 1642831',1999.36,0.00,0.00,3.52,144.32,'2022-02-05 16:13:18','',''),(2651602,'1','208','1038',479,'Retail Sale Id 1642831',1999.36,0.00,0.00,3.52,144.32,'2022-02-05 16:13:18','',''),(2651603,'1','208','1038',479,'Retail Sale Id 1642832',6997.76,0.00,0.00,12.32,505.12,'2022-02-05 16:14:36','',''),(2651604,'1','208','1038',479,'Retail Sale Id 1642833',2902.48,0.00,0.00,5.11,209.51,'2022-02-05 16:15:35','',''),(2651605,'1','208','1038',479,'Retail Sale Id 1642834',2840.00,0.00,0.00,5.00,205.00,'2022-02-05 16:17:07','',''),(2651606,'1','208','1038',479,'Retail Sale Id 1642835',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 16:23:04','',''),(2651607,'1','208','1038',479,'Retail Sale Id 1642836',3402.32,0.00,0.00,5.99,245.59,'2022-02-05 16:24:48','',''),(2651608,'1','208','1038',479,'Retail Sale Id 1642837',568.00,0.00,0.00,1.00,41.00,'2022-02-05 16:26:07','',''),(2651609,'1','208','1038',479,'Retail Sale Id 1642838',999.68,0.00,0.00,1.76,72.16,'2022-02-05 16:30:57','',''),(2651610,'1','208','1038',479,'Retail Sale Id 1642839',4998.40,0.00,0.00,8.80,360.80,'2022-02-05 16:39:32','',''),(2651611,'1','208','1038',479,'Retail Sale Id 1642840',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 16:41:54','',''),(2651612,'1','208','1038',479,'Retail Sale Id 1642841',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 16:43:26','',''),(2651613,'1','208','1038',479,'Retail Sale Id 1642842',1709.68,0.00,0.00,3.01,123.41,'2022-02-05 16:44:45','',''),(2651614,'1','208','1038',479,'Retail Sale Id 1642843',1999.36,0.00,0.00,3.52,144.32,'2022-02-05 16:46:09','',''),(2651615,'1','208','1038',479,'Retail Sale Id 1642844',9002.80,0.00,0.00,15.85,649.85,'2022-02-05 16:55:57','',''),(2651616,'1','208','1038',479,'Retail Sale Id 1642845',2851.36,0.00,0.00,5.02,205.82,'2022-02-05 16:57:17','',''),(2651617,'1','208','1038',479,'Retail Sale Id 1642846',1698.32,0.00,0.00,2.99,122.59,'2022-02-05 17:11:00','',''),(2651618,'1','208','1038',479,'Retail Sale Id 1642847',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 17:12:32','',''),(2651619,'1','208','1038',479,'Retail Sale Id 1642848',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 17:14:25','',''),(2651620,'1','208','1038',479,'Retail Sale Id 1642848',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 17:14:25','',''),(2651621,'1','208','1038',479,'Retail Sale Id 1642848',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 17:14:25','',''),(2651622,'1','208','1038',479,'Retail Sale Id 1642849',1704.00,0.00,0.00,3.00,123.00,'2022-02-05 17:15:55','',''),(2651623,'1','208','1038',479,'Retail Sale Id 1642850',3998.72,0.00,0.00,7.04,288.64,'2022-02-05 17:17:06','',''),(2651624,'1','208','1038',479,'Retail Sale Id 1642851',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 17:23:20','',''),(2651625,'1','208','1038',479,'Retail Sale Id 1642851',5680.00,0.00,0.00,10.00,410.00,'2022-02-05 17:23:20','',''),(2651626,'1','208','1038',479,'Retail Sale Id 1642852',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 17:25:39','',''),(2651627,'1','208','1038',479,'Retail Sale Id 1642853',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 17:27:03','',''),(2651628,'1','208','1038',479,'Retail Sale Id 1642854',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 17:32:14','',''),(2651629,'1','208','1038',479,'Retail Sale Id 1642855',2198.16,0.00,0.00,3.87,158.67,'2022-02-05 17:33:36','',''),(2651630,'1','208','1038',479,'Retail Sale Id 1642856',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 17:34:47','',''),(2651631,'1','208','1038',479,'Retail Sale Id 1642857',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 17:37:30','',''),(2651632,'1','208','1038',479,'Retail Sale Id 1642858',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 17:39:58','',''),(2651633,'1','208','1038',479,'Retail Sale Id 1642859',2999.04,0.00,0.00,5.28,216.48,'2022-02-05 17:43:47','',''),(2651634,'1','208','1038',479,'Retail Sale Id 1642860',1499.52,0.00,0.00,2.64,108.24,'2022-02-05 17:48:55','',''),(2651635,'1','208','1038',479,'Retail Sale Id 1642861',2499.20,0.00,0.00,4.40,180.40,'2022-02-05 17:50:02','',''),(2651636,'1','208','1038',479,'Retail Sale Id 1642861',2499.20,0.00,0.00,4.40,180.40,'2022-02-05 17:50:02','',''),(2651637,'1','208','1038',479,'Retail Sale Id 1642862',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 17:51:08','',''),(2651638,'1','208','1038',479,'Retail Sale Id 1642862',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 17:51:08','',''),(2651639,'1','208','1038',479,'Retail Sale Id 1642863',7997.44,0.00,0.00,14.08,577.28,'2022-02-05 17:57:17','',''),(2651640,'1','208','1038',479,'Retail Sale Id 1642864',4544.00,0.00,0.00,8.00,328.00,'2022-02-05 17:58:15','',''),(2651641,'1','208','1038',479,'Retail Sale Id 1642865',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 17:59:12','',''),(2651642,'1','208','1038',479,'Retail Sale Id 1642866',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 18:09:02','',''),(2651643,'1','208','1038',479,'Retail Sale Id 1642867',7100.00,0.00,0.00,12.50,512.50,'2022-02-05 18:17:43','',''),(2651644,'1','208','1038',479,'Retail Sale Id 1642868',53505.60,0.00,0.00,94.20,3862.20,'2022-02-05 18:19:15','',''),(2651645,'1','208','1038',479,'Retail Sale Id 1642869',10922.64,0.00,0.00,19.23,788.43,'2022-02-05 18:19:52','',''),(2651646,'1','208','1038',479,'Retail Sale Id 1642870',1709.68,0.00,0.00,3.01,123.41,'2022-02-05 19:12:15','',''),(2651647,'1','208','1038',479,'Retail Sale Id 1642870',6287.76,0.00,0.00,11.07,453.87,'2022-02-05 19:12:15','',''),(2651648,'1','208','1038',479,'Retail Sale Id 1642871',11.36,0.00,0.00,0.02,0.82,'2022-02-05 19:13:21','',''),(2651649,'1','208','1038',479,'Retail Sale Id 1642872',5680.00,0.00,0.00,10.00,410.00,'2022-02-05 19:16:59','',''),(2651650,'1','208','1038',479,'Retail Sale Id 1642873',3408.00,0.00,0.00,6.00,246.00,'2022-02-05 19:20:45','',''),(2651651,'1','208','1038',479,'Retail Sale Id 1642874',1499.52,0.00,0.00,2.64,108.24,'2022-02-05 19:34:55','',''),(2651652,'1','208','1038',479,'Retail Sale Id 1642875',1709.68,0.00,0.00,3.01,123.41,'2022-02-05 19:37:42','',''),(2651653,'1','208','1038',479,'Retail Sale Id 1642876',1698.32,0.00,0.00,2.99,122.59,'2022-02-05 19:48:08','',''),(2651654,'1','208','1038',479,'Retail Sale Id 1642877',1999.36,0.00,0.00,3.52,144.32,'2022-02-05 19:48:59','',''),(2651655,'1','208','1038',479,'Retail Sale Id 1642878',7696.40,0.00,0.00,13.55,555.55,'2022-02-05 20:03:33','',''),(2651656,'1','208','1038',479,'Retail Sale Id 1642879',12944.72,0.00,0.00,22.79,934.39,'2022-02-05 20:04:40','',''),(2651657,'1','208','1038',479,'Retail Sale Id 1642880',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 07:36:00','',''),(2651658,'1','208','1038',479,'Retail Sale Id 1642881',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 07:40:55','',''),(2651659,'1','208','1038',479,'Retail Sale Id 1642882',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 07:48:50','',''),(2651660,'1','208','1038',479,'Retail Sale Id 1642883',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 07:50:50','',''),(2651661,'1','208','1038',479,'Retail Sale Id 1642884',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 07:56:50','',''),(2651662,'1','208','1038',479,'Retail Sale Id 1642885',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 07:58:34','',''),(2651663,'1','208','1038',479,'Retail Sale Id 1642886',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 07:59:22','',''),(2651664,'1','208','1038',479,'Retail Sale Id 1642887',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 08:01:56','',''),(2651665,'1','208','1038',479,'Retail Sale Id 1642889',6997.76,0.00,0.00,12.32,505.12,'2022-02-06 08:08:13','',''),(2651666,'1','208','1038',479,'Retail Sale Id 1642890',4998.40,0.00,0.00,8.80,360.80,'2022-02-06 08:13:15','',''),(2651667,'1','208','1038',479,'Retail Sale Id 1642891',3998.72,0.00,0.00,7.04,288.64,'2022-02-06 08:24:32','',''),(2651668,'1','208','1038',479,'Retail Sale Id 1642893',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 08:30:40','',''),(2651669,'1','208','1038',479,'Retail Sale Id 1642894',999.68,0.00,0.00,1.76,72.16,'2022-02-06 08:34:07','',''),(2651670,'1','208','1038',479,'Retail Sale Id 1642895',3998.72,0.00,0.00,7.04,288.64,'2022-02-06 08:34:51','',''),(2651671,'1','208','1038',479,'Retail Sale Id 1642896',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 08:35:41','',''),(2651672,'1','208','1038',479,'Retail Sale Id 1642898',5680.00,0.00,0.00,10.00,410.00,'2022-02-06 08:36:51','',''),(2651673,'1','208','1038',479,'Retail Sale Id 1642899',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 08:38:33','',''),(2651674,'1','208','1038',479,'Retail Sale Id 1642900',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 08:39:21','',''),(2651675,'1','208','1038',479,'Retail Sale Id 1642901',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 08:40:34','',''),(2651676,'1','208','1038',479,'Retail Sale Id 1642902',999.68,0.00,0.00,1.76,72.16,'2022-02-06 08:42:48','',''),(2651677,'1','208','1038',479,'Retail Sale Id 1642903',2499.20,0.00,0.00,4.40,180.40,'2022-02-06 08:43:36','',''),(2651678,'1','208','1038',479,'Retail Sale Id 1642904',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 08:44:39','',''),(2651679,'1','208','1038',479,'Retail Sale Id 1642905',1698.32,0.00,0.00,2.99,122.59,'2022-02-06 08:45:43','',''),(2651680,'1','208','1038',479,'Retail Sale Id 1642906',5680.00,0.00,0.00,10.00,410.00,'2022-02-06 08:47:04','',''),(2651681,'1','208','1038',479,'Retail Sale Id 1642907',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 08:48:54','',''),(2651682,'1','208','1038',479,'Retail Sale Id 1642907',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 08:48:54','',''),(2651683,'1','208','1038',479,'Retail Sale Id 1642908',2499.20,0.00,0.00,4.40,180.40,'2022-02-06 08:50:12','',''),(2651684,'1','208','1038',479,'Retail Sale Id 1642909',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 08:51:02','',''),(2651685,'1','208','1038',479,'Retail Sale Id 1642910',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 08:56:40','',''),(2651686,'1','208','1038',479,'Retail Sale Id 1642910',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 08:56:40','',''),(2651687,'1','208','1038',479,'Retail Sale Id 1642911',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 08:59:50','',''),(2651688,'1','208','1038',479,'Retail Sale Id 1642911',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 08:59:50','',''),(2651689,'1','208','1038',479,'Retail Sale Id 1642912',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 09:00:38','',''),(2651690,'1','208','1038',479,'Retail Sale Id 1642913',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 09:02:17','',''),(2651691,'1','208','1038',479,'Retail Sale Id 1642914',5702.72,0.00,0.00,10.04,411.64,'2022-02-06 09:10:57','',''),(2651692,'1','208','1038',479,'Retail Sale Id 1642915',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 09:12:00','',''),(2651693,'1','208','1038',479,'Retail Sale Id 1642916',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 09:12:56','',''),(2651694,'1','208','1038',479,'Retail Sale Id 1642917',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 09:14:21','',''),(2651695,'1','208','1038',479,'Retail Sale Id 1642917',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 09:14:21','',''),(2651696,'1','208','1038',479,'Retail Sale Id 1642918',1499.52,0.00,0.00,2.64,108.24,'2022-02-06 09:15:30','',''),(2651697,'1','208','1038',479,'Retail Sale Id 1642919',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 09:28:47','',''),(2651698,'1','208','1038',479,'Retail Sale Id 1642920',999.68,0.00,0.00,1.76,72.16,'2022-02-06 09:33:21','',''),(2651699,'1','208','1038',479,'Retail Sale Id 1642921',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 09:35:24','',''),(2651700,'1','208','1038',479,'Retail Sale Id 1642922',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 09:36:40','',''),(2651701,'1','208','1038',479,'Retail Sale Id 1642923',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 09:42:00','',''),(2651702,'1','208','1038',479,'Retail Sale Id 1642923',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 09:42:00','',''),(2651703,'1','208','1038',479,'Retail Sale Id 1642924',1698.32,0.00,0.00,2.99,122.59,'2022-02-06 09:42:28','',''),(2651704,'1','208','1038',479,'Retail Sale Id 1642925',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 09:46:29','',''),(2651705,'1','208','1038',479,'Retail Sale Id 1642926',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 09:52:30','',''),(2651706,'1','208','1038',479,'Retail Sale Id 1642927',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 09:55:05','',''),(2651707,'1','208','1038',479,'Retail Sale Id 1642928',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 09:56:19','',''),(2651708,'1','208','1038',479,'Retail Sale Id 1642929',999.68,0.00,0.00,1.76,72.16,'2022-02-06 09:57:23','',''),(2651709,'1','208','1038',479,'Retail Sale Id 1642930',1499.52,0.00,0.00,2.64,108.24,'2022-02-06 10:04:04','',''),(2651710,'1','208','1038',479,'Retail Sale Id 1642931',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 10:08:30','',''),(2651711,'1','208','1038',479,'Retail Sale Id 1642932',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 10:10:10','',''),(2651712,'1','208','1038',479,'Retail Sale Id 1642933',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 10:11:53','',''),(2651713,'1','208','1038',479,'Retail Sale Id 1642935',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 10:12:46','',''),(2651714,'1','208','1038',479,'Retail Sale Id 1642936',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 10:14:31','',''),(2651715,'1','208','1038',479,'Retail Sale Id 1642937',2300.40,0.00,0.00,4.05,166.05,'2022-02-06 10:15:22','',''),(2651716,'1','208','1038',479,'Retail Sale Id 1642938',1141.68,0.00,0.00,2.01,82.41,'2022-02-06 10:16:32','',''),(2651717,'1','208','1038',479,'Retail Sale Id 1642938',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 10:16:32','',''),(2651718,'1','208','1038',479,'Retail Sale Id 1642939',1902.80,0.00,0.00,3.35,137.35,'2022-02-06 10:18:45','',''),(2651719,'1','208','1038',479,'Retail Sale Id 1642940',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 10:19:36','',''),(2651720,'1','208','1038',479,'Retail Sale Id 1642941',5680.00,0.00,0.00,10.00,410.00,'2022-02-06 10:21:17','',''),(2651721,'1','208','1038',479,'Retail Sale Id 1642942',999.68,0.00,0.00,1.76,72.16,'2022-02-06 10:22:14','',''),(2651722,'1','208','1038',479,'Retail Sale Id 1642943',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 10:22:55','',''),(2651723,'1','208','1038',479,'Retail Sale Id 1642944',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 10:24:40','',''),(2651724,'1','208','1038',479,'Retail Sale Id 1642945',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 10:25:43','',''),(2651725,'1','208','1038',479,'Retail Sale Id 1642946',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 10:27:53','',''),(2651726,'1','208','1038',479,'Retail Sale Id 1642947',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 10:35:24','',''),(2651727,'1','208','1038',479,'Retail Sale Id 1642948',999.68,0.00,0.00,1.76,72.16,'2022-02-06 10:38:05','',''),(2651728,'1','208','1038',479,'Retail Sale Id 1642949',28400.00,0.00,0.00,50.00,2050.00,'2022-02-06 10:44:34','',''),(2651729,'1','208','1038',479,'Retail Sale Id 1642950',5998.08,0.00,0.00,10.56,432.96,'2022-02-06 10:46:26','',''),(2651730,'1','208','1038',479,'Retail Sale Id 1642951',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 10:50:09','',''),(2651731,'1','208','1038',479,'Retail Sale Id 1642952',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 10:54:04','',''),(2651732,'1','208','1038',479,'Retail Sale Id 1642952',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 10:54:04','',''),(2651733,'1','208','1038',479,'Retail Sale Id 1642953',2300.40,0.00,0.00,4.05,166.05,'2022-02-06 10:56:27','',''),(2651734,'1','208','1038',479,'Retail Sale Id 1642954',2902.48,0.00,0.00,5.11,209.51,'2022-02-06 10:58:18','',''),(2651735,'1','208','1038',479,'Retail Sale Id 1642955',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 10:59:35','',''),(2651736,'1','208','1038',479,'Retail Sale Id 1642956',3402.32,0.00,0.00,5.99,245.59,'2022-02-06 11:02:14','',''),(2651737,'1','208','1038',479,'Retail Sale Id 1642958',1698.32,0.00,0.00,2.99,122.59,'2022-02-06 11:03:18','',''),(2651738,'1','208','1038',479,'Retail Sale Id 1642959',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 11:05:19','',''),(2651739,'1','208','1038',479,'Retail Sale Id 1642960',3402.32,0.00,0.00,5.99,245.59,'2022-02-06 11:07:36','',''),(2651740,'1','208','1038',479,'Retail Sale Id 1642961',5680.00,0.00,0.00,10.00,410.00,'2022-02-06 11:18:42','',''),(2651741,'1','208','1038',479,'Retail Sale Id 1642962',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 11:20:32','',''),(2651742,'1','208','1038',479,'Retail Sale Id 1642963',5998.08,0.00,0.00,10.56,432.96,'2022-02-06 11:22:00','',''),(2651743,'1','208','1038',479,'Retail Sale Id 1642964',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 11:23:29','',''),(2651744,'1','208','1038',479,'Retail Sale Id 1642965',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 11:27:24','',''),(2651745,'1','208','1038',479,'Retail Sale Id 1642966',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 11:30:53','',''),(2651746,'1','208','1038',479,'Retail Sale Id 1642967',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 11:39:40','',''),(2651747,'1','208','1038',479,'Retail Sale Id 1642968',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 11:53:30','',''),(2651748,'1','208','1038',479,'Retail Sale Id 1642969',698.64,0.00,0.00,1.23,50.43,'2022-02-06 11:55:28','',''),(2651749,'1','208','1038',479,'Retail Sale Id 1642970',999.68,0.00,0.00,1.76,72.16,'2022-02-06 11:59:12','',''),(2651750,'1','208','1038',479,'Retail Sale Id 1642970',999.68,0.00,0.00,1.76,72.16,'2022-02-06 11:59:12','',''),(2651751,'1','208','1038',479,'Retail Sale Id 1642971',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:01:07','',''),(2651752,'1','208','1038',479,'Retail Sale Id 1642972',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 12:02:22','',''),(2651753,'1','208','1038',479,'Retail Sale Id 1642973',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 12:03:17','',''),(2651754,'1','208','1038',479,'Retail Sale Id 1642974',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:04:22','',''),(2651755,'1','208','1038',479,'Retail Sale Id 1642976',1704.00,0.00,0.00,3.00,123.00,'2022-02-06 12:11:45','',''),(2651756,'1','208','1038',479,'Retail Sale Id 1642977',4998.40,0.00,0.00,8.80,360.80,'2022-02-06 12:16:14','',''),(2651757,'1','208','1038',479,'Retail Sale Id 1642978',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 12:17:35','',''),(2651758,'1','208','1038',479,'Retail Sale Id 1642979',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:18:25','',''),(2651759,'1','208','1038',479,'Retail Sale Id 1642980',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 12:19:24','',''),(2651760,'1','208','1038',479,'Retail Sale Id 1642981',1698.32,0.00,0.00,2.99,122.59,'2022-02-06 12:20:15','',''),(2651761,'1','208','1038',479,'Retail Sale Id 1642982',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 12:28:48','',''),(2651762,'1','208','1038',479,'Retail Sale Id 1642983',6997.76,0.00,0.00,12.32,505.12,'2022-02-06 12:33:57','',''),(2651763,'1','208','1038',479,'Retail Sale Id 1642985',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 12:37:14','',''),(2651764,'1','208','1038',479,'Retail Sale Id 1642985',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 12:37:14','',''),(2651765,'1','208','1038',479,'Retail Sale Id 1642985',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 12:37:14','',''),(2651766,'1','208','1038',479,'Retail Sale Id 1642986',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 12:39:32','',''),(2651767,'1','208','1038',479,'Retail Sale Id 1642987',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 12:41:35','',''),(2651768,'1','208','1038',479,'Retail Sale Id 1642987',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 12:41:35','',''),(2651769,'1','208','1038',479,'Retail Sale Id 1642988',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:42:09','',''),(2651770,'1','208','1038',479,'Retail Sale Id 1642989',5680.00,0.00,0.00,10.00,410.00,'2022-02-06 12:43:54','',''),(2651771,'1','208','1038',479,'Retail Sale Id 1642990',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 12:44:47','',''),(2651772,'1','208','1038',479,'Retail Sale Id 1642991',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 12:45:41','',''),(2651773,'1','208','1038',479,'Retail Sale Id 1642993',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:47:24','',''),(2651774,'1','208','1038',479,'Retail Sale Id 1642993',28400.00,0.00,0.00,50.00,2050.00,'2022-02-06 12:47:24','',''),(2651775,'1','208','1038',479,'Retail Sale Id 1642994',4998.40,0.00,0.00,8.80,360.80,'2022-02-06 12:49:19','',''),(2651776,'1','208','1038',479,'Retail Sale Id 1642995',6816.00,0.00,0.00,12.00,492.00,'2022-02-06 12:51:10','',''),(2651777,'1','208','1038',479,'Retail Sale Id 1642996',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:52:01','',''),(2651778,'1','208','1038',479,'Retail Sale Id 1642997',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:52:39','',''),(2651779,'1','208','1038',479,'Retail Sale Id 1642998',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:53:22','',''),(2651780,'1','208','1038',479,'Retail Sale Id 1642999',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 12:54:12','',''),(2651781,'1','208','1038',479,'Retail Sale Id 1642999',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:54:12','',''),(2651782,'1','208','1038',479,'Retail Sale Id 1643000',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:55:23','',''),(2651783,'1','208','1038',479,'Retail Sale Id 1643001',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 12:56:31','',''),(2651784,'1','208','1038',479,'Retail Sale Id 1643002',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 12:58:13','',''),(2651785,'1','208','1038',479,'Retail Sale Id 1643003',5702.72,0.00,0.00,10.04,411.64,'2022-02-06 13:00:59','',''),(2651786,'1','208','1038',479,'Retail Sale Id 1643004',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 13:09:59','',''),(2651787,'1','208','1038',479,'Retail Sale Id 1643005',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 13:13:48','',''),(2651788,'1','208','1038',479,'Retail Sale Id 1643005',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 13:13:48','',''),(2651789,'1','208','1038',479,'Retail Sale Id 1643006',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 13:18:34','',''),(2651790,'1','208','1038',479,'Retail Sale Id 1643007',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 13:19:23','',''),(2651791,'1','208','1038',479,'Retail Sale Id 1643008',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 13:20:03','',''),(2651792,'1','208','1038',479,'Retail Sale Id 1643009',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 13:25:07','',''),(2651793,'1','208','1038',479,'Retail Sale Id 1643010',3402.32,0.00,0.00,5.99,245.59,'2022-02-06 13:26:35','',''),(2651794,'1','208','1038',479,'Retail Sale Id 1643011',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 13:27:41','',''),(2651795,'1','208','1038',479,'Retail Sale Id 1643012',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 13:28:40','',''),(2651796,'1','208','1038',479,'Retail Sale Id 1643013',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 13:33:38','',''),(2651797,'1','208','1038',479,'Retail Sale Id 1643014',2499.20,0.00,0.00,4.40,180.40,'2022-02-06 13:38:05','',''),(2651798,'1','208','1038',479,'Retail Sale Id 1643015',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 13:39:52','',''),(2651799,'1','208','1038',479,'Retail Sale Id 1643016',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 13:44:11','',''),(2651800,'1','208','1038',479,'Retail Sale Id 1643017',1499.52,0.00,0.00,2.64,108.24,'2022-02-06 13:49:35','',''),(2651801,'1','208','1038',479,'Retail Sale Id 1643018',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 13:56:51','',''),(2651802,'1','208','1038',479,'Retail Sale Id 1643018',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 13:56:51','',''),(2651803,'1','208','1038',479,'Retail Sale Id 1643019',1698.32,0.00,0.00,2.99,122.59,'2022-02-06 13:58:14','',''),(2651804,'1','208','1038',479,'Retail Sale Id 1643020',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 13:58:52','',''),(2651805,'1','208','1038',479,'Retail Sale Id 1643021',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 14:00:52','',''),(2651806,'1','208','1038',479,'Retail Sale Id 1643021',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 14:00:52','',''),(2651807,'1','208','1038',479,'Retail Sale Id 1643021',28400.00,0.00,0.00,50.00,2050.00,'2022-02-06 14:00:52','',''),(2651808,'1','208','1038',479,'Retail Sale Id 1643022',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 14:02:08','',''),(2651809,'1','208','1038',479,'Retail Sale Id 1643023',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 14:03:11','',''),(2651810,'1','208','1038',479,'Retail Sale Id 1643024',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 14:05:58','',''),(2651811,'1','208','1038',479,'Retail Sale Id 1643025',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 14:15:33','',''),(2651812,'1','208','1038',479,'Retail Sale Id 1643026',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 14:18:40','',''),(2651813,'1','208','1038',479,'Retail Sale Id 1643027',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 14:22:41','',''),(2651814,'1','208','1038',479,'Retail Sale Id 1643028',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 14:24:25','',''),(2651815,'1','208','1038',479,'Retail Sale Id 1643029',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 14:25:56','',''),(2651816,'1','208','1038',479,'Retail Sale Id 1643029',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 14:25:56','',''),(2651817,'1','208','1038',479,'Retail Sale Id 1643030',4498.56,0.00,0.00,7.92,324.72,'2022-02-06 14:28:34','',''),(2651818,'1','208','1038',479,'Retail Sale Id 1643031',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 14:30:22','',''),(2651819,'1','208','1038',479,'Retail Sale Id 1643032',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 14:31:10','',''),(2651820,'1','208','1038',479,'Retail Sale Id 1643033',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 14:32:41','',''),(2651821,'1','208','1038',479,'Retail Sale Id 1643034',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 14:40:22','',''),(2651822,'1','208','1038',479,'Retail Sale Id 1643035',28400.00,0.00,0.00,50.00,2050.00,'2022-02-06 14:42:17','',''),(2651823,'1','208','1038',479,'Retail Sale Id 1643036',28002.40,0.00,0.00,49.30,2021.30,'2022-02-06 14:44:33','',''),(2651824,'1','208','1038',479,'Retail Sale Id 1643037',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 14:45:15','',''),(2651825,'1','208','1038',479,'Retail Sale Id 1643038',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 14:52:43','',''),(2651826,'1','208','1038',479,'Retail Sale Id 1643039',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 14:56:15','',''),(2651827,'1','208','1038',479,'Retail Sale Id 1643040',1147.36,0.00,0.00,2.02,82.82,'2022-02-06 14:57:39','',''),(2651828,'1','208','1038',479,'Retail Sale Id 1643041',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 15:02:51','',''),(2651829,'1','208','1038',479,'Retail Sale Id 1643041',5691.36,0.00,0.00,10.02,410.82,'2022-02-06 15:02:51','',''),(2651830,'1','208','1038',479,'Retail Sale Id 1643042',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 15:03:34','',''),(2651831,'1','208','1038',479,'Retail Sale Id 1643043',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 15:04:17','',''),(2651832,'1','208','1038',479,'Retail Sale Id 1643044',2499.20,0.00,0.00,4.40,180.40,'2022-02-06 15:06:58','',''),(2651833,'1','208','1038',479,'Retail Sale Id 1643045',999.68,0.00,0.00,1.76,72.16,'2022-02-06 15:09:50','',''),(2651834,'1','208','1038',479,'Retail Sale Id 1643046',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 15:11:57','',''),(2651835,'1','208','1038',479,'Retail Sale Id 1643047',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 15:12:40','',''),(2651836,'1','208','1038',479,'Retail Sale Id 1643048',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 15:16:22','',''),(2651837,'1','208','1038',479,'Retail Sale Id 1643049',3998.72,0.00,0.00,7.04,288.64,'2022-02-06 15:17:52','',''),(2651838,'1','208','1038',479,'Retail Sale Id 1643050',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 15:25:00','',''),(2651839,'1','208','1038',479,'Retail Sale Id 1643051',499.84,0.00,0.00,0.88,36.08,'2022-02-06 15:40:39','',''),(2651840,'1','208','1038',479,'Retail Sale Id 1643052',999.68,0.00,0.00,1.76,72.16,'2022-02-06 15:41:21','',''),(2651841,'1','208','1038',479,'Retail Sale Id 1643053',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 15:48:13','',''),(2651842,'1','208','1038',479,'Retail Sale Id 1643054',999.68,0.00,0.00,1.76,72.16,'2022-02-06 16:07:30','',''),(2651843,'1','208','1038',479,'Retail Sale Id 1643055',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 16:19:15','',''),(2651844,'1','208','1038',479,'Retail Sale Id 1643056',1499.52,0.00,0.00,2.64,108.24,'2022-02-06 16:20:34','',''),(2651845,'1','208','1038',479,'Retail Sale Id 1643057',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 16:21:26','',''),(2651846,'1','208','1038',479,'Retail Sale Id 1643058',5998.08,0.00,0.00,10.56,432.96,'2022-02-06 16:23:35','',''),(2651847,'1','208','1038',479,'Retail Sale Id 1643059',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 16:24:37','',''),(2651848,'1','208','1038',479,'Retail Sale Id 1643060',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 16:27:38','',''),(2651849,'1','208','1038',479,'Retail Sale Id 1643061',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 16:31:35','',''),(2651850,'1','208','1038',479,'Retail Sale Id 1643062',999.68,0.00,0.00,1.76,72.16,'2022-02-06 16:35:23','',''),(2651851,'1','208','1038',479,'Retail Sale Id 1643063',999.68,0.00,0.00,1.76,72.16,'2022-02-06 16:39:53','',''),(2651852,'1','208','1038',479,'Retail Sale Id 1643064',2902.48,0.00,0.00,5.11,209.51,'2022-02-06 16:42:46','',''),(2651853,'1','208','1038',479,'Retail Sale Id 1643067',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 16:45:30','',''),(2651854,'1','208','1038',479,'Retail Sale Id 1643068',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 16:46:27','',''),(2651855,'1','208','1038',479,'Retail Sale Id 1643069',5998.08,0.00,0.00,10.56,432.96,'2022-02-06 16:55:00','',''),(2651856,'1','208','1038',479,'Retail Sale Id 1643070',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 17:00:52','',''),(2651857,'1','208','1038',479,'Retail Sale Id 1643071',5998.08,0.00,0.00,10.56,432.96,'2022-02-06 17:03:21','',''),(2651858,'1','208','1038',479,'Retail Sale Id 1643072',1499.52,0.00,0.00,2.64,108.24,'2022-02-06 17:05:08','',''),(2651859,'1','208','1038',479,'Retail Sale Id 1643072',1499.52,0.00,0.00,2.64,108.24,'2022-02-06 17:05:08','',''),(2651860,'1','208','1038',479,'Retail Sale Id 1643074',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 17:06:59','',''),(2651861,'1','208','1038',479,'Retail Sale Id 1643074',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 17:06:59','',''),(2651862,'1','208','1038',479,'Retail Sale Id 1643074',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 17:06:59','',''),(2651863,'1','208','1038',479,'Retail Sale Id 1643076',499.84,0.00,0.00,0.88,36.08,'2022-02-06 17:08:15','',''),(2651864,'1','208','1038',479,'Retail Sale Id 1643077',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 17:27:19','',''),(2651865,'1','208','1038',479,'Retail Sale Id 1643078',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 17:33:27','',''),(2651866,'1','208','1038',479,'Retail Sale Id 1643078',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 17:33:27','',''),(2651867,'1','208','1038',479,'Retail Sale Id 1643079',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 17:37:05','',''),(2651868,'1','208','1038',479,'Retail Sale Id 1643080',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 17:40:38','',''),(2651869,'1','208','1038',479,'Retail Sale Id 1643081',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 17:49:27','',''),(2651870,'1','208','1038',479,'Retail Sale Id 1643082',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 17:55:10','',''),(2651871,'1','208','1038',479,'Retail Sale Id 1643083',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 18:04:52','',''),(2651872,'1','208','1038',479,'Retail Sale Id 1643086',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 18:07:50','',''),(2651873,'1','208','1038',479,'Retail Sale Id 1643087',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 18:09:37','',''),(2651874,'1','208','1038',479,'Retail Sale Id 1643088',3408.00,0.00,0.00,6.00,246.00,'2022-02-06 18:11:36','',''),(2651875,'1','208','1038',479,'Retail Sale Id 1643089',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 18:31:35','',''),(2651876,'1','208','1038',479,'Retail Sale Id 1643090',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 18:35:23','',''),(2651877,'1','208','1038',479,'Retail Sale Id 1643091',6997.76,0.00,0.00,12.32,505.12,'2022-02-06 18:36:30','',''),(2651878,'1','208','1038',479,'Retail Sale Id 1643092',1999.36,0.00,0.00,3.52,144.32,'2022-02-06 18:37:45','',''),(2651879,'1','208','1038',479,'Retail Sale Id 1643093',1499.52,0.00,0.00,2.64,108.24,'2022-02-06 18:38:31','',''),(2651880,'1','208','1038',479,'Retail Sale Id 1643094',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 18:39:07','',''),(2651881,'1','208','1038',479,'Retail Sale Id 1643095',2999.04,0.00,0.00,5.28,216.48,'2022-02-06 18:40:37','',''),(2651882,'1','208','1038',479,'Retail Sale Id 1643096',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 18:43:52','',''),(2651883,'1','208','1038',479,'Retail Sale Id 1643098',3447.76,0.00,0.00,6.07,248.87,'2022-02-06 18:48:27','',''),(2651884,'1','208','1038',479,'Retail Sale Id 1643099',1198.48,0.00,0.00,2.11,86.51,'2022-02-06 18:50:18','',''),(2651885,'1','208','1038',479,'Retail Sale Id 1643100',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 19:05:09','',''),(2651886,'1','208','1038',479,'Retail Sale Id 1643100',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 19:05:09','',''),(2651887,'1','208','1038',479,'Retail Sale Id 1643102',2840.00,0.00,0.00,5.00,205.00,'2022-02-06 19:06:47','',''),(2651888,'1','208','1038',479,'Retail Sale Id 1643103',2851.36,0.00,0.00,5.02,205.82,'2022-02-06 19:08:17','',''),(2651889,'1','208','1038',479,'Return of Retail Sale Id 1643035',0.00,28400.00,50.00,0.00,-2050.00,'2022-02-06 19:22:45','',''),(2651890,'1','208','1038',479,'Retail Sale Id 1643104',999.68,0.00,0.00,1.76,72.16,'2022-02-06 19:29:27','',''),(2651891,'1','208','1038',479,'Retail Sale Id 1643105',2851.36,0.00,0.00,5.02,205.82,'2022-02-06 19:30:38','',''),(2651892,'1','208','1038',479,'Retail Sale Id 1643106',14200.00,0.00,0.00,25.00,1025.00,'2022-02-06 19:33:05','',''),(2651893,'1','208','1038',479,'Retail Sale Id 1643107',3498.88,0.00,0.00,6.16,252.56,'2022-02-06 19:40:50','',''),(2651894,'1','208','1038',479,'Retail Sale Id 1643108',2851.36,0.00,0.00,5.02,205.82,'2022-02-06 19:44:08','',''),(2651895,'1','208','1038',479,'Retail Sale Id 1643109',1709.68,0.00,0.00,3.01,123.41,'2022-02-06 19:50:06','',''),(2651896,'1','208','1038',479,'Retail Sale Id 1643110',7100.00,0.00,0.00,12.50,512.50,'2022-02-06 19:52:07','',''),(2651897,'1','208','1038',479,'Retail Sale Id 1643111',12899.28,0.00,0.00,22.71,931.11,'2022-02-06 20:15:06','',''),(2651898,'1','208','1038',479,'Retail Sale Id 1643112',7088.64,0.00,0.00,12.48,511.68,'2022-02-06 20:15:34','',''),(2651899,'1','208','1038',479,'Retail Sale Id 1643113',14932.72,0.00,0.00,26.29,1077.89,'2022-02-06 20:16:09','',''),(2651900,'1','208','1038',479,'Retail Sale Id 1643115',21589.68,0.00,0.00,38.01,1558.41,'2022-02-06 20:16:36','',''),(2651901,'1','208','1038',479,'Retail Sale Id 1643116',999.68,0.00,0.00,1.76,72.16,'2022-02-07 07:52:00','',''),(2651902,'1','208','1038',479,'Retail Sale Id 1643117',3402.32,0.00,0.00,5.99,245.59,'2022-02-07 07:53:00','',''),(2651903,'1','208','1038',479,'Retail Sale Id 1643118',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 07:54:33','',''),(2651904,'1','208','1038',479,'Retail Sale Id 1643119',3402.32,0.00,0.00,5.99,245.59,'2022-02-07 07:59:40','',''),(2651905,'1','208','1038',479,'Retail Sale Id 1643120',1999.36,0.00,0.00,3.52,144.32,'2022-02-07 08:06:00','',''),(2651906,'1','208','1038',479,'Retail Sale Id 1643121',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 08:07:51','',''),(2651907,'1','208','1038',479,'Retail Sale Id 1643121',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 08:07:51','',''),(2651908,'1','208','1038',479,'Retail Sale Id 1643122',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 08:15:47','',''),(2651909,'1','208','1038',479,'Retail Sale Id 1643123',3998.72,0.00,0.00,7.04,288.64,'2022-02-07 08:16:43','',''),(2651910,'1','208','1038',479,'Retail Sale Id 1643124',3498.88,0.00,0.00,6.16,252.56,'2022-02-07 08:17:44','',''),(2651911,'1','208','1038',479,'Retail Sale Id 1643125',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 08:18:21','',''),(2651912,'1','208','1038',479,'Retail Sale Id 1643126',602.08,0.00,0.00,1.06,43.46,'2022-02-07 08:19:38','',''),(2651913,'1','208','1038',479,'Retail Sale Id 1643127',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 08:20:58','',''),(2651914,'1','208','1038',479,'Retail Sale Id 1643128',2999.04,0.00,0.00,5.28,216.48,'2022-02-07 08:21:58','',''),(2651915,'1','208','1038',479,'Retail Sale Id 1643129',499.84,0.00,0.00,0.88,36.08,'2022-02-07 08:24:52','',''),(2651916,'1','208','1038',479,'Retail Sale Id 1643130',5998.08,0.00,0.00,10.56,432.96,'2022-02-07 08:26:05','',''),(2651917,'1','208','1038',479,'Retail Sale Id 1643131',1698.32,0.00,0.00,2.99,122.59,'2022-02-07 08:49:52','',''),(2651918,'1','208','1038',479,'Retail Sale Id 1643132',5680.00,0.00,0.00,10.00,410.00,'2022-02-07 08:51:14','',''),(2651919,'1','208','1038',479,'Retail Sale Id 1643133',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 08:53:48','',''),(2651920,'1','208','1038',479,'Retail Sale Id 1643134',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 08:56:12','',''),(2651921,'1','208','1038',479,'Retail Sale Id 1643135',1499.52,0.00,0.00,2.64,108.24,'2022-02-07 08:58:16','',''),(2651922,'1','208','1038',479,'Retail Sale Id 1643136',999.68,0.00,0.00,1.76,72.16,'2022-02-07 09:06:46','',''),(2651923,'1','208','1038',479,'Retail Sale Id 1643137',1709.68,0.00,0.00,3.01,123.41,'2022-02-07 09:07:34','',''),(2651924,'1','208','1038',479,'Retail Sale Id 1643138',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 09:18:32','',''),(2651925,'1','208','1038',479,'Retail Sale Id 1643139',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 09:23:04','',''),(2651926,'1','208','1038',479,'Retail Sale Id 1643140',4998.40,0.00,0.00,8.80,360.80,'2022-02-07 09:40:42','',''),(2651927,'1','208','1038',479,'Retail Sale Id 1643141',3498.88,0.00,0.00,6.16,252.56,'2022-02-07 09:48:25','',''),(2651928,'1','208','1038',479,'Retail Sale Id 1643142',28400.00,0.00,0.00,50.00,2050.00,'2022-02-07 09:51:17','',''),(2651929,'1','208','1038',479,'Retail Sale Id 1643143',2851.36,0.00,0.00,5.02,205.82,'2022-02-07 09:54:21','',''),(2651930,'1','208','1038',479,'Retail Sale Id 1643144',1999.36,0.00,0.00,3.52,144.32,'2022-02-07 09:55:09','',''),(2651931,'1','208','1038',479,'Retail Sale Id 1643145',3402.32,0.00,0.00,5.99,245.59,'2022-02-07 09:56:00','',''),(2651932,'1','208','1038',479,'Retail Sale Id 1643146',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 10:04:20','',''),(2651933,'1','208','1038',479,'Retail Sale Id 1643147',4038.48,0.00,0.00,7.11,291.51,'2022-02-07 11:09:33','',''),(2651934,'1','208','1038',479,'Retail Sale Id 1643148',9809.36,0.00,0.00,17.27,708.07,'2022-02-07 11:10:49','',''),(2651935,'1','208','1038',479,'Retail Sale Id 1643149',1709.68,0.00,0.00,3.01,123.41,'2022-02-07 16:37:43','',''),(2651936,'1','208','1038',479,'Retail Sale Id 1643150',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 16:39:26','',''),(2651937,'1','208','1038',479,'Retail Sale Id 1643151',1698.32,0.00,0.00,2.99,122.59,'2022-02-07 16:40:18','',''),(2651938,'1','208','1038',479,'Retail Sale Id 1643152',1698.32,0.00,0.00,2.99,122.59,'2022-02-07 16:41:08','',''),(2651939,'1','208','1038',479,'Retail Sale Id 1643153',1698.32,0.00,0.00,2.99,122.59,'2022-02-07 16:42:02','',''),(2651940,'1','208','1038',479,'Retail Sale Id 1643154',6997.76,0.00,0.00,12.32,505.12,'2022-02-07 16:42:46','',''),(2651941,'1','208','1038',479,'Retail Sale Id 1643155',999.68,0.00,0.00,1.76,72.16,'2022-02-07 16:43:53','',''),(2651942,'1','208','1038',479,'Retail Sale Id 1643156',2999.04,0.00,0.00,5.28,216.48,'2022-02-07 16:44:38','',''),(2651943,'1','208','1038',479,'Retail Sale Id 1643157',1698.32,0.00,0.00,2.99,122.59,'2022-02-07 16:45:44','',''),(2651944,'1','208','1038',479,'Retail Sale Id 1643158',800.88,0.00,0.00,1.41,57.81,'2022-02-07 16:46:36','',''),(2651945,'1','208','1038',479,'Retail Sale Id 1643159',7100.00,0.00,0.00,12.50,512.50,'2022-02-07 16:47:28','',''),(2651946,'1','208','1038',479,'Retail Sale Id 1643160',2999.04,0.00,0.00,5.28,216.48,'2022-02-07 16:48:46','',''),(2651947,'1','208','1038',479,'Return of Retail Sale Id 1643160',0.00,2999.04,5.28,0.00,-216.48,'2022-02-07 18:16:25','',''),(2651948,'1','208','1038',479,'Return of Retail Sale Id 1643159',0.00,7100.00,12.50,0.00,-512.50,'2022-02-07 18:17:10','',''),(2651949,'1','208','1038',479,'Return of Retail Sale Id 1643158',0.00,800.88,1.41,0.00,-57.81,'2022-02-07 18:18:02','',''),(2651950,'1','208','1038',479,'Return of Retail Sale Id 1643157',0.00,1698.32,2.99,0.00,-122.59,'2022-02-07 18:18:59','',''),(2651951,'1','208','1038',479,'Return of Retail Sale Id 1643156',0.00,2999.04,5.28,0.00,-216.48,'2022-02-07 18:20:04','',''),(2651952,'1','208','1038',479,'Return of Retail Sale Id 1643155',0.00,999.68,1.76,0.00,-72.16,'2022-02-07 18:22:52','',''),(2651953,'1','208','1038',479,'Return of Retail Sale Id 1643154',0.00,6997.76,12.32,0.00,-505.12,'2022-02-07 18:23:43','',''),(2651954,'1','208','1038',479,'Return of Retail Sale Id 1643153',0.00,1698.32,2.99,0.00,-122.59,'2022-02-07 18:24:58','',''),(2651955,'1','208','1038',479,'Return of Retail Sale Id 1643152',0.00,1698.32,2.99,0.00,-122.59,'2022-02-07 18:26:26','',''),(2651956,'1','208','1038',479,'Return of Retail Sale Id 1643151',0.00,1698.32,2.99,0.00,-122.59,'2022-02-07 18:28:01','',''),(2651957,'1','208','1038',479,'Return of Retail Sale Id 1643150',0.00,7100.00,12.50,0.00,-512.50,'2022-02-07 18:39:33','',''),(2651958,'1','208','1038',479,'Return of Retail Sale Id 1643149',0.00,1709.68,3.01,0.00,-123.41,'2022-02-07 18:40:37','',''),(2651959,'1','208','1038',479,'Distributed to Dankano lpg for sales id:1',765788.97,0.00,0.00,1453.11,0.00,'2022-02-08 08:02:30','',''),(2651960,'1','208',NULL,479,'Purchased from AA RANO NIGERIA LIMITED',0.00,12925000.00,25000.00,0.00,0.00,'2022-02-08 09:15:20','',''),(2651961,'1','208',NULL,479,'Reception corrector for bridging 132390',0.00,0.00,0.00,5000.00,0.00,'2022-02-08 09:20:02','',''),(2651962,'1','208','1038',479,'Received from bridging 132390',0.00,0.00,5000.00,0.00,0.00,'2022-02-08 09:20:02','',''),(2651963,'1','208','1038',479,'Retail Sale Id 1643161',49347.84,0.00,0.00,86.88,4430.88,'2022-02-08 09:29:17','',''),(2651964,'1','208','1038',479,'Retail Sale Id 1643162',3402.32,0.00,0.00,5.99,305.49,'2022-02-08 09:31:04','',''),(2651965,'1','208','1038',479,'Retail Sale Id 1643163',2999.04,0.00,0.00,5.28,269.28,'2022-02-08 09:32:14','',''),(2651966,'1','208','1038',479,'Retail Sale Id 1643164',89511.12,0.00,0.00,157.59,8037.09,'2022-02-08 09:35:27','',''),(2651967,'1','208','1038',479,'Retail Sale Id 1643165',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 09:46:13','',''),(2651968,'1','208','1038',479,'Retail Sale Id 1643166',3408.00,0.00,0.00,6.00,306.00,'2022-02-08 09:50:06','',''),(2651969,'1','208','1038',479,'Retail Sale Id 1643166',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 09:50:06','',''),(2651970,'1','208','1038',479,'Retail Sale Id 1643167',1800.56,0.00,0.00,3.17,161.67,'2022-02-08 09:51:07','',''),(2651971,'1','208','1038',479,'Retail Sale Id 1643168',999.68,0.00,0.00,1.76,89.76,'2022-02-08 09:51:41','',''),(2651972,'1','208','1038',479,'Retail Sale Id 1643169',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 09:54:53','',''),(2651973,'1','208','1038',479,'Retail Sale Id 1643170',2300.40,0.00,0.00,4.05,206.55,'2022-02-08 09:57:05','',''),(2651974,'1','208','1038',479,'Retail Sale Id 1643171',710.00,0.00,0.00,1.25,63.75,'2022-02-08 10:05:25','',''),(2651975,'1','208','1038',479,'Retail Sale Id 1643172',1499.52,0.00,0.00,2.64,134.64,'2022-02-08 10:07:00','',''),(2651976,'1','208','1038',479,'Retail Sale Id 1643173',698.64,0.00,0.00,1.23,62.73,'2022-02-08 10:07:45','',''),(2651977,'1','208','1038',479,'Retail Sale Id 1643174',999.68,0.00,0.00,1.76,89.76,'2022-02-08 10:09:26','',''),(2651978,'1','208','1038',479,'Retail Sale Id 1643175',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 10:10:46','',''),(2651979,'1','208','1038',479,'Retail Sale Id 1643176',999.68,0.00,0.00,1.76,89.76,'2022-02-08 10:12:02','',''),(2651980,'1','208','1038',479,'Retail Sale Id 1643177',999.68,0.00,0.00,1.76,89.76,'2022-02-08 10:25:20','',''),(2651981,'1','208','1038',479,'Retail Sale Id 1643178',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 10:32:48','',''),(2651982,'1','208','1038',479,'Retail Sale Id 1643180',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 10:34:38','',''),(2651983,'1','208','1038',479,'Retail Sale Id 1643180',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 10:34:38','',''),(2651984,'1','208','1038',479,'Retail Sale Id 1643180',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 10:34:38','',''),(2651985,'1','208','1038',479,'Retail Sale Id 1643181',1147.36,0.00,0.00,2.02,103.02,'2022-02-08 10:36:29','',''),(2651986,'1','208','1038',479,'Retail Sale Id 1643182',999.68,0.00,0.00,1.76,89.76,'2022-02-08 10:39:01','',''),(2651987,'1','208','1038',479,'Retail Sale Id 1643183',3408.00,0.00,0.00,6.00,306.00,'2022-02-08 10:41:06','',''),(2651988,'1','208','1038',479,'Retail Sale Id 1643184',3998.72,0.00,0.00,7.04,359.04,'2022-02-08 10:47:11','',''),(2651989,'1','208','1038',479,'Retail Sale Id 1643185',6497.92,0.00,0.00,11.44,583.44,'2022-02-08 10:54:13','',''),(2651990,'1','208','1038',479,'Retail Sale Id 1643186',3447.76,0.00,0.00,6.07,309.57,'2022-02-08 10:56:04','',''),(2651991,'1','208','1038',479,'Retail Sale Id 1643187',2840.00,0.00,0.00,5.00,255.00,'2022-02-08 10:56:51','',''),(2651992,'1','208','1038',479,'Retail Sale Id 1643188',4998.40,0.00,0.00,8.80,448.80,'2022-02-08 10:57:40','',''),(2651993,'1','208','1038',479,'Retail Sale Id 1643189',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 10:58:23','',''),(2651994,'1','208','1038',479,'Retail Sale Id 1643191',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 11:02:21','',''),(2651995,'1','208','1038',479,'Retail Sale Id 1643191',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 11:02:21','',''),(2651996,'1','208','1038',479,'Retail Sale Id 1643192',3498.88,0.00,0.00,6.16,314.16,'2022-02-08 11:07:50','',''),(2651997,'1','208','1038',479,'Retail Sale Id 1643193',2499.20,0.00,0.00,4.40,224.40,'2022-02-08 11:12:26','',''),(2651998,'1','208','1038',479,'Retail Sale Id 1643193',2499.20,0.00,0.00,4.40,224.40,'2022-02-08 11:12:26','',''),(2651999,'1','208','1038',479,'Retail Sale Id 1643194',999.68,0.00,0.00,1.76,89.76,'2022-02-08 11:21:42','',''),(2652000,'1','208','1038',479,'Retail Sale Id 1643195',2840.00,0.00,0.00,5.00,255.00,'2022-02-08 11:23:39','',''),(2652001,'1','208','1038',479,'Retail Sale Id 1643196',2851.36,0.00,0.00,5.02,256.02,'2022-02-08 11:26:15','',''),(2652002,'1','208','1038',479,'Retail Sale Id 1643197',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 11:37:53','',''),(2652003,'1','208','1038',479,'Retail Sale Id 1643198',999.68,0.00,0.00,1.76,89.76,'2022-02-08 11:40:24','',''),(2652004,'1','208','1038',479,'Retail Sale Id 1643199',3408.00,0.00,0.00,6.00,306.00,'2022-02-08 11:42:39','',''),(2652005,'1','208','1038',479,'Retail Sale Id 1643200',1198.48,0.00,0.00,2.11,107.61,'2022-02-08 11:44:12','',''),(2652006,'1','208','1038',479,'Retail Sale Id 1643201',999.68,0.00,0.00,1.76,89.76,'2022-02-08 11:46:44','',''),(2652007,'1','208','1038',479,'Retail Sale Id 1643202',1749.44,0.00,0.00,3.08,157.08,'2022-02-08 11:52:04','',''),(2652008,'1','208','1038',479,'Retail Sale Id 1643203',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 11:54:21','',''),(2652009,'1','208','1038',479,'Retail Sale Id 1643204',1709.68,0.00,0.00,3.01,153.51,'2022-02-08 11:55:17','',''),(2652010,'1','208','1038',479,'Retail Sale Id 1643205',1749.44,0.00,0.00,3.08,157.08,'2022-02-08 12:21:03','',''),(2652011,'1','208','1038',479,'Retail Sale Id 1643206',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 12:28:06','',''),(2652012,'1','208','1038',479,'Retail Sale Id 1643207',3408.00,0.00,0.00,6.00,306.00,'2022-02-08 12:33:45','',''),(2652013,'1','208','1038',479,'Retail Sale Id 1643208',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 12:34:31','',''),(2652014,'1','208','1038',479,'Retail Sale Id 1643209',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 12:35:27','',''),(2652015,'1','208','1038',479,'Retail Sale Id 1643210',8520.00,0.00,0.00,15.00,765.00,'2022-02-08 12:50:15','',''),(2652016,'1','208','1038',479,'Retail Sale Id 1643211',4998.40,0.00,0.00,8.80,448.80,'2022-02-08 12:56:14','',''),(2652017,'1','208','1038',479,'Retail Sale Id 1643213',999.68,0.00,0.00,1.76,89.76,'2022-02-08 13:24:35','',''),(2652018,'1','208','1038',479,'Retail Sale Id 1643214',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 13:25:12','',''),(2652019,'1','208','1038',479,'Retail Sale Id 1643215',499.84,0.00,0.00,0.88,44.88,'2022-02-08 13:27:48','',''),(2652020,'1','208','1038',479,'Retail Sale Id 1643216',999.68,0.00,0.00,1.76,89.76,'2022-02-08 13:36:14','',''),(2652021,'1','208','1038',479,'Retail Sale Id 1643217',2840.00,0.00,0.00,5.00,255.00,'2022-02-08 13:40:51','',''),(2652022,'1','208','1038',479,'Retail Sale Id 1643217',3408.00,0.00,0.00,6.00,306.00,'2022-02-08 13:40:51','',''),(2652023,'1','208','1038',479,'Retail Sale Id 1643218',3408.00,0.00,0.00,6.00,306.00,'2022-02-08 13:42:43','',''),(2652024,'1','208','1038',479,'Retail Sale Id 1643219',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 13:45:25','',''),(2652025,'1','208','1038',479,'Retail Sale Id 1643220',1499.52,0.00,0.00,2.64,134.64,'2022-02-08 13:48:42','',''),(2652026,'1','208','1038',479,'Retail Sale Id 1643224',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 14:05:54','',''),(2652027,'1','208','1038',479,'Retail Sale Id 1643225',2999.04,0.00,0.00,5.28,269.28,'2022-02-08 14:09:18','',''),(2652028,'1','208','1038',479,'Retail Sale Id 1643226',568.00,0.00,0.00,1.00,51.00,'2022-02-08 14:18:43','',''),(2652029,'1','208','1038',479,'Retail Sale Id 1643227',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 14:21:10','',''),(2652030,'1','208','1038',479,'Retail Sale Id 1643228',3498.88,0.00,0.00,6.16,314.16,'2022-02-08 14:22:10','',''),(2652031,'1','208','1038',479,'Retail Sale Id 1643229',1698.32,0.00,0.00,2.99,152.49,'2022-02-08 14:24:57','',''),(2652032,'1','208','1038',479,'Retail Sale Id 1643230',3498.88,0.00,0.00,6.16,314.16,'2022-02-08 14:27:18','',''),(2652033,'1','208','1038',479,'Retail Sale Id 1643231',2999.04,0.00,0.00,5.28,269.28,'2022-02-08 14:32:56','',''),(2652034,'1','208','1038',479,'Retail Sale Id 1643232',3498.88,0.00,0.00,6.16,314.16,'2022-02-08 14:34:07','',''),(2652035,'1','208','1038',479,'Retail Sale Id 1643233',2999.04,0.00,0.00,5.28,269.28,'2022-02-08 14:38:16','',''),(2652036,'1','208','1038',479,'Retail Sale Id 1643234',1749.44,0.00,0.00,3.08,157.08,'2022-02-08 14:54:16','',''),(2652037,'1','208','1038',479,'Retail Sale Id 1643234',1749.44,0.00,0.00,3.08,157.08,'2022-02-08 14:54:16','',''),(2652038,'1','208','1038',479,'Retail Sale Id 1643235',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 14:58:25','',''),(2652039,'1','208','1038',479,'Retail Sale Id 1643237',602.08,0.00,0.00,1.06,54.06,'2022-02-08 14:59:54','',''),(2652040,'1','208','1038',479,'Retail Sale Id 1643237',2300.40,0.00,0.00,4.05,206.55,'2022-02-08 14:59:54','',''),(2652041,'1','208','1038',479,'Retail Sale Id 1643238',1698.32,0.00,0.00,2.99,152.49,'2022-02-08 15:06:23','',''),(2652042,'1','208','1038',479,'Retail Sale Id 1643239',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 15:18:05','',''),(2652043,'1','208','1038',479,'Retail Sale Id 1643240',1499.52,0.00,0.00,2.64,134.64,'2022-02-08 15:19:54','',''),(2652044,'1','208','1038',479,'Retail Sale Id 1643241',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 15:21:13','',''),(2652045,'1','208','1038',479,'Retail Sale Id 1643242',602.08,0.00,0.00,1.06,54.06,'2022-02-08 15:31:03','',''),(2652046,'1','208','1038',479,'Retail Sale Id 1643243',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 15:34:58','',''),(2652047,'1','208','1038',479,'Retail Sale Id 1643244',1709.68,0.00,0.00,3.01,153.51,'2022-02-08 15:41:00','',''),(2652048,'1','208','1038',479,'Retail Sale Id 1643245',5702.72,0.00,0.00,10.04,512.04,'2022-02-08 15:46:02','',''),(2652049,'1','208','1038',479,'Retail Sale Id 1643246',2840.00,0.00,0.00,5.00,255.00,'2022-02-08 15:50:21','',''),(2652050,'1','208','1038',479,'Retail Sale Id 1643247',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 15:52:27','',''),(2652051,'1','208','1038',479,'Retail Sale Id 1643248',6997.76,0.00,0.00,12.32,628.32,'2022-02-08 15:54:25','',''),(2652052,'1','208','1038',479,'Retail Sale Id 1643249',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 16:04:22','',''),(2652053,'1','208','1038',479,'Retail Sale Id 1643249',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 16:04:22','',''),(2652054,'1','208','1038',479,'Retail Sale Id 1643249',3998.72,0.00,0.00,7.04,359.04,'2022-02-08 16:04:22','',''),(2652055,'1','208','1038',479,'Retail Sale Id 1643250',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 16:05:59','',''),(2652056,'1','208','1038',479,'Retail Sale Id 1643251',1709.68,0.00,0.00,3.01,153.51,'2022-02-08 16:07:05','',''),(2652057,'1','208','1038',479,'Retail Sale Id 1643252',2499.20,0.00,0.00,4.40,224.40,'2022-02-08 16:08:12','',''),(2652058,'1','208','1038',479,'Retail Sale Id 1643253',2999.04,0.00,0.00,5.28,269.28,'2022-02-08 16:14:32','',''),(2652059,'1','208','1038',479,'Retail Sale Id 1643254',4544.00,0.00,0.00,8.00,408.00,'2022-02-08 16:25:53','',''),(2652060,'1','208','1038',479,'Retail Sale Id 1643255',3408.00,0.00,0.00,6.00,306.00,'2022-02-08 16:39:07','',''),(2652061,'1','208','1038',479,'Retail Sale Id 1643256',499.84,0.00,0.00,0.88,44.88,'2022-02-08 16:42:10','',''),(2652062,'1','208','1038',479,'Retail Sale Id 1643257',4010.08,0.00,0.00,7.06,360.06,'2022-02-08 16:45:16','',''),(2652063,'1','208','1038',479,'Retail Sale Id 1643258',13308.24,0.00,0.00,23.43,1194.93,'2022-02-08 16:46:44','',''),(2652064,'1','208','1038',479,'Retail Sale Id 1643259',5680.00,0.00,0.00,10.00,510.00,'2022-02-08 16:48:36','',''),(2652065,'1','208','1038',479,'Retail Sale Id 1643260',1709.68,0.00,0.00,3.01,153.51,'2022-02-08 16:50:35','',''),(2652066,'1','208','1038',479,'Retail Sale Id 1643261',2999.04,0.00,0.00,5.28,269.28,'2022-02-08 16:52:53','',''),(2652067,'1','208','1038',479,'Retail Sale Id 1643262',1499.52,0.00,0.00,2.64,134.64,'2022-02-08 16:53:47','',''),(2652068,'1','208','1038',479,'Retail Sale Id 1643263',999.68,0.00,0.00,1.76,89.76,'2022-02-08 16:54:36','',''),(2652069,'1','208','1038',479,'Retail Sale Id 1643264',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 16:55:45','',''),(2652070,'1','208','1038',479,'Retail Sale Id 1643265',999.68,0.00,0.00,1.76,89.76,'2022-02-08 16:56:55','',''),(2652071,'1','208','1038',479,'Retail Sale Id 1643266',1499.52,0.00,0.00,2.64,134.64,'2022-02-08 16:57:49','',''),(2652072,'1','208','1038',479,'Retail Sale Id 1643267',1198.48,0.00,0.00,2.11,107.61,'2022-02-08 16:58:38','',''),(2652073,'1','208','1038',479,'Retail Sale Id 1643268',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 17:01:16','',''),(2652074,'1','208','1038',479,'Retail Sale Id 1643269',2999.04,0.00,0.00,5.28,269.28,'2022-02-08 17:03:42','',''),(2652075,'1','208','1038',479,'Retail Sale Id 1643270',3498.88,0.00,0.00,6.16,314.16,'2022-02-08 17:05:25','',''),(2652076,'1','208','1038',479,'Retail Sale Id 1643271',3447.76,0.00,0.00,6.07,309.57,'2022-02-08 17:06:18','',''),(2652077,'1','208','1038',479,'Retail Sale Id 1643272',3498.88,0.00,0.00,6.16,314.16,'2022-02-08 17:08:02','',''),(2652078,'1','208','1038',479,'Retail Sale Id 1643273',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 17:09:56','',''),(2652079,'1','208','1038',479,'Retail Sale Id 1643274',3402.32,0.00,0.00,5.99,305.49,'2022-02-08 17:11:52','',''),(2652080,'1','208','1038',479,'Retail Sale Id 1643275',3408.00,0.00,0.00,6.00,306.00,'2022-02-08 17:17:58','',''),(2652081,'1','208','1038',479,'Retail Sale Id 1643276',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 17:23:04','',''),(2652082,'1','208','1038',479,'Retail Sale Id 1643277',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 17:24:36','',''),(2652083,'1','208','1038',479,'Retail Sale Id 1643278',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 17:29:59','',''),(2652084,'1','208','1038',479,'Retail Sale Id 1643279',6100.32,0.00,0.00,10.74,547.74,'2022-02-08 17:31:45','',''),(2652085,'1','208','1038',479,'Retail Sale Id 1643280',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 17:32:46','',''),(2652086,'1','208','1038',479,'Retail Sale Id 1643281',2851.36,0.00,0.00,5.02,256.02,'2022-02-08 17:34:12','',''),(2652087,'1','208','1038',479,'Retail Sale Id 1643282',602.08,0.00,0.00,1.06,54.06,'2022-02-08 17:39:07','',''),(2652088,'1','208','1038',479,'Retail Sale Id 1643284',999.68,0.00,0.00,1.76,89.76,'2022-02-08 17:45:02','',''),(2652089,'1','208','1038',479,'Retail Sale Id 1643285',2851.36,0.00,0.00,5.02,256.02,'2022-02-08 17:49:29','',''),(2652090,'1','208','1038',479,'Retail Sale Id 1643286',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 18:06:04','',''),(2652091,'1','208','1038',479,'Retail Sale Id 1643287',10297.84,0.00,0.00,18.13,924.63,'2022-02-08 18:07:26','',''),(2652092,'1','208','1038',479,'Retail Sale Id 1643288',1999.36,0.00,0.00,3.52,179.52,'2022-02-08 18:08:21','',''),(2652093,'1','208','1038',479,'Retail Sale Id 1643289',2851.36,0.00,0.00,5.02,256.02,'2022-02-08 18:09:07','',''),(2652094,'1','208','1038',479,'Retail Sale Id 1643290',2499.20,0.00,0.00,4.40,224.40,'2022-02-08 18:09:56','',''),(2652095,'1','208','1038',479,'Retail Sale Id 1643291',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 18:13:33','',''),(2652096,'1','208','1038',479,'Retail Sale Id 1643292',397.60,0.00,0.00,0.70,35.70,'2022-02-08 18:19:14','',''),(2652097,'1','208','1038',479,'Retail Sale Id 1643293',2999.04,0.00,0.00,5.28,269.28,'2022-02-08 18:25:11','',''),(2652098,'1','208','1038',479,'Retail Sale Id 1643294',999.68,0.00,0.00,1.76,89.76,'2022-02-08 18:35:36','',''),(2652099,'1','208','1038',479,'Retail Sale Id 1643295',2851.36,0.00,0.00,5.02,256.02,'2022-02-08 18:38:56','',''),(2652100,'1','208','1038',479,'Retail Sale Id 1643297',2999.04,0.00,0.00,5.28,269.28,'2022-02-08 18:39:40','',''),(2652101,'1','208','1038',479,'Retail Sale Id 1643298',1709.68,0.00,0.00,3.01,153.51,'2022-02-08 18:40:25','',''),(2652102,'1','208','1038',479,'Retail Sale Id 1643299',5680.00,0.00,0.00,10.00,510.00,'2022-02-08 18:43:42','',''),(2652103,'1','208','1038',479,'Retail Sale Id 1643300',7100.00,0.00,0.00,12.50,637.50,'2022-02-08 18:50:09','',''),(2652104,'1','208','1038',479,'Retail Sale Id 1643301',1698.32,0.00,0.00,2.99,152.49,'2022-02-08 18:51:23','',''),(2652105,'1','208','1038',479,'Retail Sale Id 1643302',2840.00,0.00,0.00,5.00,255.00,'2022-02-08 18:58:57','',''),(2652106,'1','208','1038',479,'Retail Sale Id 1643303',5998.08,0.00,0.00,10.56,538.56,'2022-02-08 19:02:39','',''),(2652107,'1','208','1038',479,'Retail Sale Id 1643304',3408.00,0.00,0.00,6.00,306.00,'2022-02-08 19:04:08','',''),(2652108,'1','208','1038',479,'Retail Sale Id 1643305',3498.88,0.00,0.00,6.16,314.16,'2022-02-08 19:05:26','',''),(2652109,'1','208','1038',479,'Retail Sale Id 1643306',2999.04,0.00,0.00,5.28,269.28,'2022-02-08 19:08:28','',''),(2652110,'1','208','1038',479,'Retail Sale Id 1643307',999.68,0.00,0.00,1.76,89.76,'2022-02-08 19:11:50','',''),(2652111,'1','208','1038',479,'Retail Sale Id 1643308',1709.68,0.00,0.00,3.01,153.51,'2022-02-08 19:15:18','',''),(2652112,'1','208','1038',479,'Retail Sale Id 1643309',33335.92,0.00,0.00,58.69,2993.19,'2022-02-08 23:21:21','',''),(2652113,'1','208','1038',479,'Retail Sale Id 1643310',44127.92,0.00,0.00,77.69,3962.19,'2022-02-08 23:23:27','',''),(2652114,'1','208','1038',479,'Retail Sale Id 1643311',115616.40,0.00,0.00,203.55,10381.05,'2022-02-08 23:25:01','',''),(2652115,'1','208','1038',479,'Retail Sale Id 1643312',80656.00,0.00,0.00,142.00,7242.00,'2022-02-08 23:26:29','',''),(2652116,'1','208','1038',479,'Retail Sale Id 1643313',113.60,0.00,0.00,0.20,10.20,'2022-02-08 23:34:19','',''),(2652117,'1','208','1038',479,'Return of Retail Sale Id 1643300',0.00,7100.00,12.50,0.00,-637.50,'2022-02-08 23:37:41','',''),(2652118,'1','208','1038',479,'Return of Retail Sale Id 1643299',0.00,5680.00,10.00,0.00,-510.00,'2022-02-08 23:40:33','',''),(2652119,'1','208','1038',479,'Return of Retail Sale Id 1643250',0.00,7100.00,12.50,0.00,-637.50,'2022-02-08 23:43:45','',''),(2652120,'1','208','1038',479,'Return of Retail Sale Id 1643171',0.00,710.00,1.25,0.00,-63.75,'2022-02-08 23:45:14','',''),(2652121,'1','208','1038',479,'Return of Retail Sale Id 1643208',0.00,7100.00,12.50,0.00,-637.50,'2022-02-08 23:47:20','',''),(2652122,'1','208','1038',479,'Return of Retail Sale Id 1643249',0.00,1999.36,3.52,0.00,-179.52,'2022-02-08 23:49:27','',''),(2652123,'1','208','1038',479,'Return of Retail Sale Id 1643249',0.00,1999.36,3.52,0.00,-179.52,'2022-02-08 23:49:27','',''),(2652124,'1','208','1038',479,'Return of Retail Sale Id 1643249',0.00,3998.72,7.04,0.00,-359.04,'2022-02-08 23:49:27','',''),(2652125,'1','208','1038',479,'Return of Retail Sale Id 1643224',0.00,7100.00,12.50,0.00,-637.50,'2022-02-08 23:51:00','',''),(2652126,'1','208','1038',479,'Return of Retail Sale Id 1643210',0.00,8520.00,15.00,0.00,-765.00,'2022-02-08 23:52:49','',''),(2652127,'1','208','1038',479,'Return of Retail Sale Id 1643308',0.00,1709.68,3.01,0.00,-153.51,'2022-02-08 23:54:45','',''),(2652128,'1','208','1038',479,'Return of Retail Sale Id 1643309',0.00,33335.92,58.69,0.00,-2993.19,'2022-02-08 23:56:26','',''),(2652129,'1','208','1038',479,'Return of Retail Sale Id 1643310',0.00,44127.92,77.69,0.00,-3962.19,'2022-02-09 00:01:15','',''),(2652130,'1','208','1038',479,'Retail Sale Id 1643314',40435.92,0.00,0.00,71.19,3630.69,'2022-02-09 00:06:41','',''),(2652131,'1','208','1038',479,'Retail Sale Id 1643315',45826.24,0.00,0.00,80.68,4114.68,'2022-02-09 00:08:06','',''),(2652132,'1','208','1038',479,'Retail Sale Id 1643316',24327.44,0.00,0.00,42.83,2184.33,'2022-02-09 00:09:24','',''),(2652133,'1','208','1038',479,'Retail Sale Id 1643317',19880.00,0.00,0.00,35.00,1785.00,'2022-02-09 00:10:41','',''),(2652134,'1','208','1038',479,'Retail Sale Id 1643318',2499.20,0.00,0.00,4.40,224.40,'2022-02-09 07:29:11','',''),(2652135,'1','208','1038',479,'Retail Sale Id 1643319',1999.36,0.00,0.00,3.52,179.52,'2022-02-09 07:35:23','',''),(2652136,'1','208','1038',479,'Retail Sale Id 1643320',3408.00,0.00,0.00,6.00,306.00,'2022-02-09 07:42:01','',''),(2652137,'1','208','1038',479,'Retail Sale Id 1643321',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 07:55:59','',''),(2652138,'1','208','1038',479,'Retail Sale Id 1643322',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 07:57:57','',''),(2652139,'1','208','1038',479,'Retail Sale Id 1643323',6997.76,0.00,0.00,12.32,628.32,'2022-02-09 08:00:07','',''),(2652140,'1','208','1038',479,'Retail Sale Id 1643324',2499.20,0.00,0.00,4.40,224.40,'2022-02-09 08:01:43','',''),(2652141,'1','208','1038',479,'Retail Sale Id 1643325',999.68,0.00,0.00,1.76,89.76,'2022-02-09 08:08:49','',''),(2652142,'1','208','1038',479,'Retail Sale Id 1643326',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 08:09:44','',''),(2652143,'1','208','1038',479,'Retail Sale Id 1643327',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 08:14:45','',''),(2652144,'1','208','1038',479,'Retail Sale Id 1643328',1499.52,0.00,0.00,2.64,134.64,'2022-02-09 08:15:37','',''),(2652145,'1','208','1038',479,'Retail Sale Id 1643329',3408.00,0.00,0.00,6.00,306.00,'2022-02-09 08:20:32','',''),(2652146,'1','208','1038',479,'Retail Sale Id 1643329',5680.00,0.00,0.00,10.00,510.00,'2022-02-09 08:20:32','',''),(2652147,'1','208','1038',479,'Retail Sale Id 1643330',3408.00,0.00,0.00,6.00,306.00,'2022-02-09 08:23:52','',''),(2652148,'1','208','1038',479,'Retail Sale Id 1643331',1709.68,0.00,0.00,3.01,153.51,'2022-02-09 08:25:46','',''),(2652149,'1','208','1038',479,'Retail Sale Id 1643332',28400.00,0.00,0.00,50.00,2550.00,'2022-02-09 08:30:02','',''),(2652150,'1','208','1038',479,'Retail Sale Id 1643333',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 08:31:45','',''),(2652151,'1','208','1038',479,'Retail Sale Id 1643334',1709.68,0.00,0.00,3.01,153.51,'2022-02-09 08:33:14','',''),(2652152,'1','208','1038',479,'Retail Sale Id 1643335',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 08:35:19','',''),(2652153,'1','208','1038',479,'Retail Sale Id 1643336',3692.00,0.00,0.00,6.50,331.50,'2022-02-09 08:38:05','',''),(2652154,'1','208','1038',479,'Retail Sale Id 1643337',3498.88,0.00,0.00,6.16,314.16,'2022-02-09 08:38:49','',''),(2652155,'1','208','1038',479,'Retail Sale Id 1643338',999.68,0.00,0.00,1.76,89.76,'2022-02-09 08:47:56','',''),(2652156,'1','208','1038',479,'Retail Sale Id 1643339',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 08:49:25','',''),(2652157,'1','208','1038',479,'Retail Sale Id 1643339',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 08:49:25','',''),(2652158,'1','208','1038',479,'Retail Sale Id 1643340',1709.68,0.00,0.00,3.01,153.51,'2022-02-09 08:57:03','',''),(2652159,'1','208','1038',479,'Retail Sale Id 1643341',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 09:04:51','',''),(2652160,'1','208','1038',479,'Retail Sale Id 1643341',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 09:04:51','',''),(2652161,'1','208','1038',479,'Retail Sale Id 1643342',1800.56,0.00,0.00,3.17,161.67,'2022-02-09 09:08:44','',''),(2652162,'1','208','1038',479,'Retail Sale Id 1643343',698.64,0.00,0.00,1.23,62.73,'2022-02-09 09:09:32','',''),(2652163,'1','208','1038',479,'Retail Sale Id 1643344',3408.00,0.00,0.00,6.00,306.00,'2022-02-09 09:11:41','',''),(2652164,'1','208','1038',479,'Retail Sale Id 1643345',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 09:14:12','',''),(2652165,'1','208','1038',479,'Retail Sale Id 1643346',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 09:21:21','',''),(2652166,'1','208','1038',479,'Retail Sale Id 1643347',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 09:36:43','',''),(2652167,'1','208','1038',479,'Retail Sale Id 1643348',3498.88,0.00,0.00,6.16,314.16,'2022-02-09 09:42:21','',''),(2652168,'1','208','1038',479,'Retail Sale Id 1643349',999.68,0.00,0.00,1.76,89.76,'2022-02-09 10:00:28','',''),(2652169,'1','208','1038',479,'Retail Sale Id 1643350',1698.32,0.00,0.00,2.99,152.49,'2022-02-09 10:03:24','',''),(2652170,'1','208','1038',479,'Retail Sale Id 1643352',1902.80,0.00,0.00,3.35,170.85,'2022-02-09 10:12:43','',''),(2652171,'1','208','1038',479,'Retail Sale Id 1643353',4498.56,0.00,0.00,7.92,403.92,'2022-02-09 10:13:37','',''),(2652172,'1','208','1038',479,'Retail Sale Id 1643354',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 10:18:36','',''),(2652173,'1','208','1038',479,'Retail Sale Id 1643355',3408.00,0.00,0.00,6.00,306.00,'2022-02-09 10:21:09','',''),(2652174,'1','208','1038',479,'Retail Sale Id 1643358',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 10:22:01','',''),(2652175,'1','208','1038',479,'Retail Sale Id 1643359',3408.00,0.00,0.00,6.00,306.00,'2022-02-09 10:24:04','',''),(2652176,'1','208','1038',479,'Retail Sale Id 1643359',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 10:24:04','',''),(2652177,'1','208','1038',479,'Retail Sale Id 1643360',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 10:34:55','',''),(2652178,'1','208','1038',479,'Retail Sale Id 1643360',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 10:34:55','',''),(2652179,'1','208','1038',479,'Retail Sale Id 1643361',5680.00,0.00,0.00,10.00,510.00,'2022-02-09 10:36:50','',''),(2652180,'1','208','1038',479,'Retail Sale Id 1643362',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 10:37:59','',''),(2652181,'1','208','1038',479,'Retail Sale Id 1643363',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 10:44:10','',''),(2652182,'1','208','1038',479,'Retail Sale Id 1643364',698.64,0.00,0.00,1.23,62.73,'2022-02-09 10:47:12','',''),(2652183,'1','208','1038',479,'Retail Sale Id 1643365',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 10:50:09','',''),(2652184,'1','208','1038',479,'Retail Sale Id 1643366',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 10:51:45','',''),(2652185,'1','208','1038',479,'Retail Sale Id 1643367',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 10:54:37','',''),(2652186,'1','208','1038',479,'Retail Sale Id 1643368',1198.48,0.00,0.00,2.11,107.61,'2022-02-09 10:55:34','',''),(2652187,'1','208','1038',479,'Retail Sale Id 1643369',28400.00,0.00,0.00,50.00,2550.00,'2022-02-09 11:10:26','',''),(2652188,'1','208','1038',479,'Retail Sale Id 1643370',3998.72,0.00,0.00,7.04,359.04,'2022-02-09 11:11:50','',''),(2652189,'1','208','1038',479,'Retail Sale Id 1643371',5680.00,0.00,0.00,10.00,510.00,'2022-02-09 11:12:54','',''),(2652190,'1','208','1038',479,'Retail Sale Id 1643372',5680.00,0.00,0.00,10.00,510.00,'2022-02-09 11:14:19','',''),(2652191,'1','208','1038',479,'Retail Sale Id 1643374',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 11:15:54','',''),(2652192,'1','208','1038',479,'Retail Sale Id 1643375',1698.32,0.00,0.00,2.99,152.49,'2022-02-09 11:20:39','',''),(2652193,'1','208','1038',479,'Retail Sale Id 1643377',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 11:23:59','',''),(2652194,'1','208','1038',479,'Retail Sale Id 1643378',999.68,0.00,0.00,1.76,89.76,'2022-02-09 11:24:59','',''),(2652195,'1','208','1038',479,'Retail Sale Id 1643379',5680.00,0.00,0.00,10.00,510.00,'2022-02-09 11:27:02','',''),(2652196,'1','208','1038',479,'Retail Sale Id 1643380',3998.72,0.00,0.00,7.04,359.04,'2022-02-09 11:29:13','',''),(2652197,'1','208','1038',479,'Retail Sale Id 1643381',1698.32,0.00,0.00,2.99,152.49,'2022-02-09 11:40:37','',''),(2652198,'1','208','1038',479,'Retail Sale Id 1643382',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 11:42:00','',''),(2652199,'1','208','1038',479,'Retail Sale Id 1643383',999.68,0.00,0.00,1.76,89.76,'2022-02-09 11:44:34','',''),(2652200,'1','208','1038',479,'Retail Sale Id 1643384',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 11:46:49','',''),(2652201,'1','208','1038',479,'Retail Sale Id 1643384',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 11:46:49','',''),(2652202,'1','208','1038',479,'Retail Sale Id 1643385',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 11:47:50','',''),(2652203,'1','208','1038',479,'Retail Sale Id 1643387',3998.72,0.00,0.00,7.04,359.04,'2022-02-09 11:56:59','',''),(2652204,'1','208','1038',479,'Retail Sale Id 1643387',3998.72,0.00,0.00,7.04,359.04,'2022-02-09 11:56:59','',''),(2652205,'1','208','1038',479,'Retail Sale Id 1643388',1999.36,0.00,0.00,3.52,179.52,'2022-02-09 11:57:58','',''),(2652206,'1','208','1038',479,'Retail Sale Id 1643389',1698.32,0.00,0.00,2.99,152.49,'2022-02-09 11:59:00','',''),(2652207,'1','208','1038',479,'Retail Sale Id 1643390',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 12:03:47','',''),(2652208,'1','208','1038',479,'Retail Sale Id 1643391',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 12:04:33','',''),(2652209,'1','208','1038',479,'Retail Sale Id 1643392',1698.32,0.00,0.00,2.99,152.49,'2022-02-09 12:08:39','',''),(2652210,'1','208','1038',479,'Retail Sale Id 1643393',897.44,0.00,0.00,1.58,80.58,'2022-02-09 12:09:37','',''),(2652211,'1','208','1038',479,'Retail Sale Id 1643394',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 12:10:47','',''),(2652212,'1','208','1038',479,'Retail Sale Id 1643395',1704.00,0.00,0.00,3.00,153.00,'2022-02-09 12:14:15','',''),(2652213,'1','208','1038',479,'Retail Sale Id 1643396',3408.00,0.00,0.00,6.00,306.00,'2022-02-09 12:15:32','',''),(2652214,'1','208','1038',479,'Retail Sale Id 1643397',1698.32,0.00,0.00,2.99,152.49,'2022-02-09 12:16:17','',''),(2652215,'1','208','1038',479,'Retail Sale Id 1643398',5680.00,0.00,0.00,10.00,510.00,'2022-02-09 12:16:56','',''),(2652216,'1','208','1038',479,'Retail Sale Id 1643399',1999.36,0.00,0.00,3.52,179.52,'2022-02-09 12:17:46','',''),(2652217,'1','208','1038',479,'Retail Sale Id 1643400',3498.88,0.00,0.00,6.16,314.16,'2022-02-09 12:20:18','',''),(2652218,'1','208','1038',479,'Retail Sale Id 1643401',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 12:21:11','',''),(2652219,'1','208','1038',479,'Retail Sale Id 1643402',1709.68,0.00,0.00,3.01,153.51,'2022-02-09 12:22:39','',''),(2652220,'1','208','1038',479,'Retail Sale Id 1643402',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 12:22:39','',''),(2652221,'1','208','1038',479,'Retail Sale Id 1643403',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 12:23:58','',''),(2652222,'1','208','1038',479,'Retail Sale Id 1643404',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 12:29:20','',''),(2652223,'1','208','1038',479,'Retail Sale Id 1643405',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 12:45:27','',''),(2652224,'1','208','1038',479,'Retail Sale Id 1643406',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 12:56:54','',''),(2652225,'1','208','1038',479,'Retail Sale Id 1643407',999.68,0.00,0.00,1.76,89.76,'2022-02-09 13:35:38','',''),(2652226,'1','208','1038',479,'Retail Sale Id 1643408',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 14:23:03','',''),(2652227,'1','208','1038',479,'Retail Sale Id 1643409',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 14:25:20','',''),(2652228,'1','208','1038',479,'Retail Sale Id 1643410',1999.36,0.00,0.00,3.52,179.52,'2022-02-09 14:27:46','',''),(2652229,'1','208','1038',479,'Retail Sale Id 1643411',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 15:14:02','',''),(2652230,'1','208','1038',479,'Retail Sale Id 1643412',4998.40,0.00,0.00,8.80,448.80,'2022-02-09 15:14:37','',''),(2652231,'1','208','1038',479,'Retail Sale Id 1643413',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 15:17:21','',''),(2652232,'1','208','1038',479,'Retail Sale Id 1643414',3408.00,0.00,0.00,6.00,306.00,'2022-02-09 15:19:40','',''),(2652233,'1','208','1038',479,'Retail Sale Id 1643415',3402.32,0.00,0.00,5.99,305.49,'2022-02-09 15:20:24','',''),(2652234,'1','208','1038',479,'Retail Sale Id 1643416',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 15:21:00','',''),(2652235,'1','208','1038',479,'Retail Sale Id 1643417',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 15:21:58','',''),(2652236,'1','208','1038',479,'Retail Sale Id 1643418',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 15:22:32','',''),(2652237,'1','208','1038',479,'Retail Sale Id 1643419',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 15:23:05','',''),(2652238,'1','208','1038',479,'Retail Sale Id 1643420',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 15:23:44','',''),(2652239,'1','208','1038',479,'Retail Sale Id 1643421',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 15:24:44','',''),(2652240,'1','208','1038',479,'Retail Sale Id 1643422',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 15:25:44','',''),(2652241,'1','208','1038',479,'Retail Sale Id 1643423',4998.40,0.00,0.00,8.80,448.80,'2022-02-09 15:26:28','',''),(2652242,'1','208','1038',479,'Retail Sale Id 1643424',4998.40,0.00,0.00,8.80,448.80,'2022-02-09 15:28:51','',''),(2652243,'1','208','1038',479,'Retail Sale Id 1643425',1709.68,0.00,0.00,3.01,153.51,'2022-02-09 15:29:43','',''),(2652244,'1','208','1038',479,'Retail Sale Id 1643426',1698.32,0.00,0.00,2.99,152.49,'2022-02-09 15:30:19','',''),(2652245,'1','208','1038',479,'Retail Sale Id 1643427',999.68,0.00,0.00,1.76,89.76,'2022-02-09 15:30:56','',''),(2652246,'1','208','1038',479,'Retail Sale Id 1643428',3402.32,0.00,0.00,5.99,305.49,'2022-02-09 15:31:33','',''),(2652247,'1','208','1038',479,'Retail Sale Id 1643429',3498.88,0.00,0.00,6.16,314.16,'2022-02-09 15:32:48','',''),(2652248,'1','208','1038',479,'Retail Sale Id 1643430',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 15:41:27','',''),(2652249,'1','208','1038',479,'Retail Sale Id 1643431',2999.04,0.00,0.00,5.28,269.28,'2022-02-09 15:43:27','',''),(2652250,'1','208','1038',479,'Retail Sale Id 1643432',1999.36,0.00,0.00,3.52,179.52,'2022-02-09 15:44:17','',''),(2652251,'1','208','1038',479,'Retail Sale Id 1643433',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 15:54:04','',''),(2652252,'1','208','1038',479,'Retail Sale Id 1643433',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 15:54:04','',''),(2652253,'1','208','1038',479,'Retail Sale Id 1643434',5998.08,0.00,0.00,10.56,538.56,'2022-02-09 15:56:33','',''),(2652254,'1','208','1038',479,'Retail Sale Id 1643435',3498.88,0.00,0.00,6.16,314.16,'2022-02-09 16:07:39','',''),(2652255,'1','208','1038',479,'Retail Sale Id 1643436',2499.20,0.00,0.00,4.40,224.40,'2022-02-09 16:24:11','',''),(2652256,'1','208','1038',479,'Retail Sale Id 1643437',2851.36,0.00,0.00,5.02,256.02,'2022-02-09 16:32:31','',''),(2652257,'1','208','1038',479,'Retail Sale Id 1643438',1499.52,0.00,0.00,2.64,134.64,'2022-02-09 16:42:58','',''),(2652258,'1','208','1038',479,'Retail Sale Id 1643439',999.68,0.00,0.00,1.76,89.76,'2022-02-09 16:58:44','',''),(2652259,'1','208','1038',479,'Retail Sale Id 1643440',1147.36,0.00,0.00,2.02,103.02,'2022-02-09 17:08:41','',''),(2652260,'1','208','1038',479,'Retail Sale Id 1643441',1709.68,0.00,0.00,3.01,153.51,'2022-02-09 17:16:15','',''),(2652261,'1','208','1038',479,'Retail Sale Id 1643442',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 17:21:15','',''),(2652262,'1','208','1038',479,'Retail Sale Id 1643443',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 17:32:16','',''),(2652263,'1','208','1038',479,'Retail Sale Id 1643444',999.68,0.00,0.00,1.76,89.76,'2022-02-09 17:44:53','',''),(2652264,'1','208','1038',479,'Retail Sale Id 1643445',1499.52,0.00,0.00,2.64,134.64,'2022-02-09 17:45:53','',''),(2652265,'1','208','1038',479,'Retail Sale Id 1643446',23765.12,0.00,0.00,41.84,2133.84,'2022-02-09 17:52:04','',''),(2652266,'1','208','1038',479,'Retail Sale Id 1643447',39618.00,0.00,0.00,69.75,3557.25,'2022-02-09 17:52:45','',''),(2652267,'1','208','1038',479,'Retail Sale Id 1643448',1999.36,0.00,0.00,3.52,179.52,'2022-02-09 17:54:22','',''),(2652268,'1','208','1038',479,'Retail Sale Id 1643449',1999.36,0.00,0.00,3.52,179.52,'2022-02-09 18:00:18','',''),(2652269,'1','208','1038',479,'Retail Sale Id 1643450',999.68,0.00,0.00,1.76,89.76,'2022-02-09 18:01:13','',''),(2652270,'1','208','1038',479,'Retail Sale Id 1643451',3408.00,0.00,0.00,6.00,306.00,'2022-02-09 18:02:12','',''),(2652271,'1','208','1038',479,'Retail Sale Id 1643452',5998.08,0.00,0.00,10.56,538.56,'2022-02-09 18:04:53','',''),(2652272,'1','208','1038',479,'Retail Sale Id 1643453',1709.68,0.00,0.00,3.01,153.51,'2022-02-09 18:12:48','',''),(2652273,'1','208','1038',479,'Retail Sale Id 1643454',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 18:14:02','',''),(2652274,'1','208','1038',479,'Retail Sale Id 1643455',2840.00,0.00,0.00,5.00,255.00,'2022-02-09 18:15:59','',''),(2652275,'1','208','1038',479,'Retail Sale Id 1643455',6816.00,0.00,0.00,12.00,612.00,'2022-02-09 18:15:59','',''),(2652276,'1','208','1038',479,'Retail Sale Id 1643456',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 18:17:18','',''),(2652277,'1','208','1038',479,'Retail Sale Id 1643458',3402.32,0.00,0.00,5.99,305.49,'2022-02-09 18:21:02','',''),(2652278,'1','208','1038',479,'Retail Sale Id 1643459',3998.72,0.00,0.00,7.04,359.04,'2022-02-09 18:22:06','',''),(2652279,'1','208','1038',479,'Retail Sale Id 1643460',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 18:23:26','',''),(2652280,'1','208','1038',479,'Retail Sale Id 1643461',1999.36,0.00,0.00,3.52,179.52,'2022-02-09 18:25:12','',''),(2652281,'1','208','1038',479,'Retail Sale Id 1643462',1999.36,0.00,0.00,3.52,179.52,'2022-02-09 18:26:28','',''),(2652282,'1','208','1038',479,'Retail Sale Id 1643463',1709.68,0.00,0.00,3.01,153.51,'2022-02-09 18:32:57','',''),(2652283,'1','208','1038',479,'Retail Sale Id 1643464',3408.00,0.00,0.00,6.00,306.00,'2022-02-09 18:35:49','',''),(2652284,'1','208','1038',479,'Retail Sale Id 1643464',7100.00,0.00,0.00,12.50,637.50,'2022-02-09 18:35:49','',''),(2652285,'1','208','1038',479,'Retail Sale Id 1643465',1709.68,0.00,0.00,3.01,153.51,'2022-02-09 18:40:41','',''),(2652286,'1','208','1038',479,'Retail Sale Id 1643466',2851.36,0.00,0.00,5.02,256.02,'2022-02-09 18:41:53','',''),(2652287,'1','208','1038',479,'Retail Sale Id 1643467',1999.36,0.00,0.00,3.52,179.52,'2022-02-09 19:03:33','',''),(2652288,'1','208','1038',479,'Retail Sale Id 1643468',1499.52,0.00,0.00,2.64,134.64,'2022-02-09 19:05:29','',''),(2652289,'1','208','1038',479,'Retail Sale Id 1643469',800.88,0.00,0.00,1.41,71.91,'2022-02-09 22:54:36','',''),(2652290,'1','208','1038',479,'Retail Sale Id 1643470',9656.00,0.00,0.00,17.00,867.00,'2022-02-09 22:56:34','',''),(2652291,'1','208','1038',479,'Retail Sale Id 1643471',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 08:14:07','',''),(2652292,'1','208','1038',479,'Retail Sale Id 1643472',1698.32,0.00,0.00,2.99,152.49,'2022-02-10 08:15:34','',''),(2652293,'1','208','1038',479,'Retail Sale Id 1643473',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 08:20:38','',''),(2652294,'1','208','1038',479,'Retail Sale Id 1643474',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 08:22:41','',''),(2652295,'1','208','1038',479,'Retail Sale Id 1643475',2999.04,0.00,0.00,5.28,269.28,'2022-02-10 08:23:34','',''),(2652296,'1','208','1038',479,'Retail Sale Id 1643476',14461.28,0.00,0.00,25.46,1298.46,'2022-02-10 08:25:03','',''),(2652297,'1','208','1038',479,'Retail Sale Id 1643477',19260.88,0.00,0.00,33.91,1729.41,'2022-02-10 08:26:53','',''),(2652298,'1','208','1038',479,'Return of Retail Sale Id 1643477',0.00,19260.88,33.91,0.00,-1729.41,'2022-02-10 08:28:03','',''),(2652299,'1','208','1038',479,'Retail Sale Id 1643478',19260.88,0.00,0.00,33.91,1729.41,'2022-02-10 08:28:47','',''),(2652300,'1','208','1038',479,'Retail Sale Id 1643479',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 08:34:38','',''),(2652301,'1','208','1038',479,'Retail Sale Id 1643480',4998.40,0.00,0.00,8.80,448.80,'2022-02-10 08:36:27','',''),(2652302,'1','208','1038',479,'Retail Sale Id 1643481',5680.00,0.00,0.00,10.00,510.00,'2022-02-10 08:45:41','',''),(2652303,'1','208','1038',479,'Retail Sale Id 1643482',4998.40,0.00,0.00,8.80,448.80,'2022-02-10 08:49:39','',''),(2652304,'1','208','1038',479,'Retail Sale Id 1643483',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 08:52:16','',''),(2652305,'1','208','1038',479,'Retail Sale Id 1643484',1698.32,0.00,0.00,2.99,152.49,'2022-02-10 08:57:21','',''),(2652306,'1','208','1038',479,'Retail Sale Id 1643485',3498.88,0.00,0.00,6.16,314.16,'2022-02-10 08:59:42','',''),(2652307,'1','208','1038',479,'Retail Sale Id 1643485',3498.88,0.00,0.00,6.16,314.16,'2022-02-10 08:59:42','',''),(2652308,'1','208','1038',479,'Retail Sale Id 1643486',1999.36,0.00,0.00,3.52,179.52,'2022-02-10 09:02:28','',''),(2652309,'1','208','1038',479,'Retail Sale Id 1643487',1499.52,0.00,0.00,2.64,134.64,'2022-02-10 09:03:15','',''),(2652310,'1','208','1038',479,'Retail Sale Id 1643488',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 09:11:33','',''),(2652311,'1','208','1038',479,'Retail Sale Id 1643489',2999.04,0.00,0.00,5.28,269.28,'2022-02-10 09:20:20','',''),(2652312,'1','208','1038',479,'Retail Sale Id 1643490',5998.08,0.00,0.00,10.56,538.56,'2022-02-10 09:21:06','',''),(2652313,'1','208','1038',479,'Retail Sale Id 1643491',2800.24,0.00,0.00,4.93,251.43,'2022-02-10 09:22:14','',''),(2652314,'1','208','1038',479,'Retail Sale Id 1643492',1800.56,0.00,0.00,3.17,161.67,'2022-02-10 09:23:31','',''),(2652315,'1','208','1038',479,'Retail Sale Id 1643493',999.68,0.00,0.00,1.76,89.76,'2022-02-10 09:26:34','',''),(2652316,'1','208','1038',479,'Retail Sale Id 1643494',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 09:35:48','',''),(2652317,'1','208','1038',479,'Retail Sale Id 1643498',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 09:37:22','',''),(2652318,'1','208','1038',479,'Retail Sale Id 1643499',999.68,0.00,0.00,1.76,89.76,'2022-02-10 09:44:23','',''),(2652319,'1','208','1038',479,'Retail Sale Id 1643502',3498.88,0.00,0.00,6.16,314.16,'2022-02-10 09:46:01','',''),(2652320,'1','208','1038',479,'Retail Sale Id 1643504',3498.88,0.00,0.00,6.16,314.16,'2022-02-10 09:48:09','',''),(2652321,'1','208','1038',479,'Retail Sale Id 1643505',3498.88,0.00,0.00,6.16,314.16,'2022-02-10 10:10:25','',''),(2652322,'1','208','1038',479,'Retail Sale Id 1643506',1749.44,0.00,0.00,3.08,157.08,'2022-02-10 10:14:07','',''),(2652323,'1','208','1038',479,'Retail Sale Id 1643507',2851.36,0.00,0.00,5.02,256.02,'2022-02-10 10:22:33','',''),(2652324,'1','208','1038',479,'Retail Sale Id 1643508',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 10:26:04','',''),(2652325,'1','208','1038',479,'Retail Sale Id 1643509',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 10:30:09','',''),(2652326,'1','208','1038',479,'Retail Sale Id 1643510',698.64,0.00,0.00,1.23,62.73,'2022-02-10 10:47:08','',''),(2652327,'1','208','1038',479,'Retail Sale Id 1643512',1999.36,0.00,0.00,3.52,179.52,'2022-02-10 10:50:01','',''),(2652328,'1','208','1038',479,'Retail Sale Id 1643513',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 10:56:40','',''),(2652329,'1','208','1038',479,'Retail Sale Id 1643514',2999.04,0.00,0.00,5.28,269.28,'2022-02-10 11:03:43','',''),(2652330,'1','208','1038',479,'Retail Sale Id 1643515',1698.32,0.00,0.00,2.99,152.49,'2022-02-10 11:04:56','',''),(2652331,'1','208','1038',479,'Retail Sale Id 1643515',5702.72,0.00,0.00,10.04,512.04,'2022-02-10 11:04:56','',''),(2652332,'1','208','1038',479,'Retail Sale Id 1643516',3498.88,0.00,0.00,6.16,314.16,'2022-02-10 11:06:51','',''),(2652333,'1','208','1038',479,'Retail Sale Id 1643517',1749.44,0.00,0.00,3.08,157.08,'2022-02-10 11:18:57','',''),(2652334,'1','208','1038',479,'Retail Sale Id 1643518',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 11:40:24','',''),(2652335,'1','208','1038',479,'Retail Sale Id 1643519',3998.72,0.00,0.00,7.04,359.04,'2022-02-10 11:47:53','',''),(2652336,'1','208','1038',479,'Retail Sale Id 1643520',2851.36,0.00,0.00,5.02,256.02,'2022-02-10 11:52:46','',''),(2652337,'1','208','1038',479,'Retail Sale Id 1643521',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 11:55:24','',''),(2652338,'1','208','1038',479,'Retail Sale Id 1643522',5702.72,0.00,0.00,10.04,512.04,'2022-02-10 11:56:41','',''),(2652339,'1','208','1038',479,'Retail Sale Id 1643523',2999.04,0.00,0.00,5.28,269.28,'2022-02-10 11:57:39','',''),(2652340,'1','208','1038',479,'Retail Sale Id 1643524',3998.72,0.00,0.00,7.04,359.04,'2022-02-10 12:00:52','',''),(2652341,'1','208','1038',479,'Retail Sale Id 1643525',2999.04,0.00,0.00,5.28,269.28,'2022-02-10 12:18:46','',''),(2652342,'1','208','1038',479,'Retail Sale Id 1643526',1999.36,0.00,0.00,3.52,179.52,'2022-02-10 12:21:27','',''),(2652343,'1','208','1038',479,'Retail Sale Id 1643527',1999.36,0.00,0.00,3.52,179.52,'2022-02-10 12:26:29','',''),(2652344,'1','208','1038',479,'Retail Sale Id 1643528',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 12:31:35','',''),(2652345,'1','208','1038',479,'Retail Sale Id 1643528',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 12:31:35','',''),(2652346,'1','208','1038',479,'Retail Sale Id 1643529',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 12:32:47','',''),(2652347,'1','208','1038',479,'Retail Sale Id 1643530',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 12:33:44','',''),(2652348,'1','208','1038',479,'Retail Sale Id 1643531',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 12:36:42','',''),(2652349,'1','208','1038',479,'Retail Sale Id 1643532',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 12:49:02','',''),(2652350,'1','208','1038',479,'Retail Sale Id 1643533',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 12:52:14','',''),(2652351,'1','208','1038',479,'Retail Sale Id 1643534',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 12:57:22','',''),(2652352,'1','208','1038',479,'Retail Sale Id 1643535',5998.08,0.00,0.00,10.56,538.56,'2022-02-10 13:00:35','',''),(2652353,'1','208','1038',479,'Retail Sale Id 1643537',602.08,0.00,0.00,1.06,54.06,'2022-02-10 13:17:39','',''),(2652354,'1','208','1038',479,'Retail Sale Id 1643544',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 14:07:36','',''),(2652355,'1','208','1038',479,'Retail Sale Id 1643545',1147.36,0.00,0.00,2.02,103.02,'2022-02-10 14:15:14','',''),(2652356,'1','208','1038',479,'Retail Sale Id 1643546',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 14:18:59','',''),(2652357,'1','208','1038',479,'Retail Sale Id 1643547',1999.36,0.00,0.00,3.52,179.52,'2022-02-10 14:21:38','',''),(2652358,'1','208','1038',479,'Retail Sale Id 1643548',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 14:44:26','',''),(2652359,'1','208','1038',479,'Retail Sale Id 1643549',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 14:47:40','',''),(2652360,'1','208','1038',479,'Retail Sale Id 1643550',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 15:00:09','',''),(2652361,'1','208','1038',479,'Retail Sale Id 1643551',1999.36,0.00,0.00,3.52,179.52,'2022-02-10 15:12:53','',''),(2652362,'1','208','1038',479,'Retail Sale Id 1643552',1499.52,0.00,0.00,2.64,134.64,'2022-02-10 15:18:43','',''),(2652363,'1','208','1038',479,'Retail Sale Id 1643553',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 15:22:11','',''),(2652364,'1','208','1038',479,'Retail Sale Id 1643554',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 15:27:12','',''),(2652365,'1','208','1038',479,'Retail Sale Id 1643554',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 15:27:12','',''),(2652366,'1','208','1038',479,'Retail Sale Id 1643555',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 15:28:19','',''),(2652367,'1','208','1038',479,'Retail Sale Id 1643556',1999.36,0.00,0.00,3.52,179.52,'2022-02-10 15:30:00','',''),(2652368,'1','208','1038',479,'Retail Sale Id 1643557',1999.36,0.00,0.00,3.52,179.52,'2022-02-10 15:36:39','',''),(2652369,'1','208','1038',479,'Retail Sale Id 1643558',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 15:38:00','',''),(2652370,'1','208','1038',479,'Retail Sale Id 1643559',1999.36,0.00,0.00,3.52,179.52,'2022-02-10 15:43:52','',''),(2652371,'1','208','1038',479,'Retail Sale Id 1643560',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 15:47:21','',''),(2652372,'1','208','1038',479,'Retail Sale Id 1643561',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 15:53:03','',''),(2652373,'1','208','1038',479,'Retail Sale Id 1643562',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 16:01:57','',''),(2652374,'1','208','1038',479,'Retail Sale Id 1643563',1499.52,0.00,0.00,2.64,134.64,'2022-02-10 16:09:07','',''),(2652375,'1','208','1038',479,'Retail Sale Id 1643564',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 16:11:08','',''),(2652376,'1','208','1038',479,'Retail Sale Id 1643564',5680.00,0.00,0.00,10.00,510.00,'2022-02-10 16:11:08','',''),(2652377,'1','208','1038',479,'Retail Sale Id 1643565',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 16:14:59','',''),(2652378,'1','208','1038',479,'Retail Sale Id 1643565',3998.72,0.00,0.00,7.04,359.04,'2022-02-10 16:14:59','',''),(2652379,'1','208','1038',479,'Retail Sale Id 1643566',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 16:31:44','',''),(2652380,'1','208','1038',479,'Retail Sale Id 1643567',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 16:32:47','',''),(2652381,'1','208','1038',479,'Retail Sale Id 1643568',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 16:33:40','',''),(2652382,'1','208','1038',479,'Retail Sale Id 1643569',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 16:34:58','',''),(2652383,'1','208','1038',479,'Retail Sale Id 1643570',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 16:35:57','',''),(2652384,'1','208','1038',479,'Retail Sale Id 1643574',2999.04,0.00,0.00,5.28,269.28,'2022-02-10 16:45:18','',''),(2652385,'1','208','1038',479,'Retail Sale Id 1643575',5998.08,0.00,0.00,10.56,538.56,'2022-02-10 16:46:04','',''),(2652386,'1','208','1038',479,'Retail Sale Id 1643576',698.64,0.00,0.00,1.23,62.73,'2022-02-10 16:46:46','',''),(2652387,'1','208','1038',479,'Retail Sale Id 1643577',999.68,0.00,0.00,1.76,89.76,'2022-02-10 16:48:33','',''),(2652388,'1','208','1038',479,'Retail Sale Id 1643578',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 16:52:55','',''),(2652389,'1','208','1038',479,'Retail Sale Id 1643580',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 16:56:46','',''),(2652390,'1','208','1038',479,'Retail Sale Id 1643581',999.68,0.00,0.00,1.76,89.76,'2022-02-10 16:58:51','',''),(2652391,'1','208','1038',479,'Retail Sale Id 1643582',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 17:01:25','',''),(2652392,'1','208','1038',479,'Retail Sale Id 1643583',2840.00,0.00,0.00,5.00,255.00,'2022-02-10 17:05:31','',''),(2652393,'1','208','1038',479,'Retail Sale Id 1643584',1397.28,0.00,0.00,2.46,125.46,'2022-02-10 17:16:38','',''),(2652394,'1','208','1038',479,'Retail Sale Id 1643585',1397.28,0.00,0.00,2.46,125.46,'2022-02-10 17:18:40','',''),(2652395,'1','208','1038',479,'Retail Sale Id 1643586',4561.04,0.00,0.00,8.03,409.53,'2022-02-10 17:20:05','',''),(2652396,'1','208','1038',479,'Retail Sale Id 1643587',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 17:23:37','',''),(2652397,'1','208','1038',479,'Retail Sale Id 1643588',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 17:34:32','',''),(2652398,'1','208','1038',479,'Retail Sale Id 1643589',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 17:37:11','',''),(2652399,'1','208','1038',479,'Retail Sale Id 1643591',3902.16,0.00,0.00,6.87,350.37,'2022-02-10 17:38:27','',''),(2652400,'1','208','1038',479,'Retail Sale Id 1643592',5680.00,0.00,0.00,10.00,510.00,'2022-02-10 17:39:36','',''),(2652401,'1','208','1038',479,'Retail Sale Id 1643593',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 17:40:41','',''),(2652402,'1','208','1038',479,'Retail Sale Id 1643594',1800.56,0.00,0.00,3.17,161.67,'2022-02-10 17:41:19','',''),(2652403,'1','208','1038',479,'Retail Sale Id 1643595',2999.04,0.00,0.00,5.28,269.28,'2022-02-10 17:42:30','',''),(2652404,'1','208','1038',479,'Retail Sale Id 1643596',2999.04,0.00,0.00,5.28,269.28,'2022-02-10 17:43:29','',''),(2652405,'1','208','1038',479,'Retail Sale Id 1643597',2840.00,0.00,0.00,5.00,255.00,'2022-02-10 17:45:31','',''),(2652406,'1','208','1038',479,'Retail Sale Id 1643598',36352.00,0.00,0.00,64.00,3264.00,'2022-02-10 17:47:47','',''),(2652407,'1','208','1038',479,'Retail Sale Id 1643599',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 17:49:28','',''),(2652408,'1','208','1038',479,'Retail Sale Id 1643599',5680.00,0.00,0.00,10.00,510.00,'2022-02-10 17:49:28','',''),(2652409,'1','208','1038',479,'Retail Sale Id 1643599',5680.00,0.00,0.00,10.00,510.00,'2022-02-10 17:49:28','',''),(2652410,'1','208','1038',479,'Retail Sale Id 1643600',999.68,0.00,0.00,1.76,89.76,'2022-02-10 17:51:13','',''),(2652411,'1','208','1038',479,'Retail Sale Id 1643601',2840.00,0.00,0.00,5.00,255.00,'2022-02-10 17:54:47','',''),(2652412,'1','208','1038',479,'Retail Sale Id 1643603',2999.04,0.00,0.00,5.28,269.28,'2022-02-10 18:00:33','',''),(2652413,'1','208','1038',479,'Retail Sale Id 1643604',3498.88,0.00,0.00,6.16,314.16,'2022-02-10 18:07:23','',''),(2652414,'1','208','1038',479,'Retail Sale Id 1643605',3498.88,0.00,0.00,6.16,314.16,'2022-02-10 18:08:24','',''),(2652415,'1','208','1038',479,'Retail Sale Id 1643606',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 18:09:45','',''),(2652416,'1','208','1038',479,'Retail Sale Id 1643608',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 18:11:52','',''),(2652417,'1','208','1038',479,'Retail Sale Id 1643608',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 18:11:52','',''),(2652418,'1','208','1038',479,'Retail Sale Id 1643610',8679.04,0.00,0.00,15.28,779.28,'2022-02-10 18:13:52','',''),(2652419,'1','208','1038',479,'Return of Retail Sale Id 1643610',0.00,8679.04,15.28,0.00,-779.28,'2022-02-10 18:14:25','',''),(2652420,'1','208','1038',479,'Retail Sale Id 1643611',4697.36,0.00,0.00,8.27,421.77,'2022-02-10 18:15:30','',''),(2652421,'1','208','1038',479,'Retail Sale Id 1643612',8679.04,0.00,0.00,15.28,779.28,'2022-02-10 18:20:42','',''),(2652422,'1','208','1038',479,'Retail Sale Id 1643613',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 18:21:36','',''),(2652423,'1','208','1038',479,'Retail Sale Id 1643614',1709.68,0.00,0.00,3.01,153.51,'2022-02-10 18:25:12','',''),(2652424,'1','208','1038',479,'Retail Sale Id 1643615',4998.40,0.00,0.00,8.80,448.80,'2022-02-10 18:26:52','',''),(2652425,'1','208','1038',479,'Retail Sale Id 1643616',2499.20,0.00,0.00,4.40,224.40,'2022-02-10 18:28:37','',''),(2652426,'1','208','1038',479,'Retail Sale Id 1643616',2499.20,0.00,0.00,4.40,224.40,'2022-02-10 18:28:37','',''),(2652427,'1','208','1038',479,'Retail Sale Id 1643617',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 18:30:11','',''),(2652428,'1','208','1038',479,'Retail Sale Id 1643620',3408.00,0.00,0.00,6.00,306.00,'2022-02-10 18:35:50','',''),(2652429,'1','208','1038',479,'Retail Sale Id 1643621',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 18:39:36','',''),(2652430,'1','208','1038',479,'Retail Sale Id 1643622',499.84,0.00,0.00,0.88,44.88,'2022-02-10 18:47:23','',''),(2652431,'1','208','1038',479,'Retail Sale Id 1643623',3402.32,0.00,0.00,5.99,305.49,'2022-02-10 18:50:52','',''),(2652432,'1','208','1038',479,'Retail Sale Id 1643624',7100.00,0.00,0.00,12.50,637.50,'2022-02-10 18:51:36','',''),(2652433,'1','208','1038',479,'Retail Sale Id 1643625',7997.44,0.00,0.00,14.08,718.08,'2022-02-10 19:12:16','',''),(2652434,'1','208','1038',479,'Return of Retail Sale Id 1643625',0.00,7997.44,14.08,0.00,-718.08,'2022-02-10 19:15:14','',''),(2652435,'1','208','1038',479,'Retail Sale Id 1643626',7997.44,0.00,0.00,14.08,718.08,'2022-02-10 19:15:54','',''),(2652436,'1','208','1038',479,'Return of Retail Sale Id 1643587',0.00,7100.00,12.50,0.00,-637.50,'2022-02-10 19:28:38','',''),(2652437,'1','208','1038',479,'Return of Retail Sale Id 1643617',0.00,7100.00,12.50,0.00,-637.50,'2022-02-10 19:29:14','',''),(2652438,'1','208','1038',479,'Return of Retail Sale Id 1643621',0.00,7100.00,12.50,0.00,-637.50,'2022-02-10 19:29:57','',''),(2652439,'1','208','1038',479,'Return of Retail Sale Id 1643612',0.00,8679.04,15.28,0.00,-779.28,'2022-02-10 19:32:16','',''),(2652440,'1','208','1038',479,'Retail Sale Id 1643627',14200.00,0.00,0.00,25.00,1275.00,'2022-02-10 19:37:07','',''),(2652441,'1','208','1038',479,'Retail Sale Id 1643628',1965.28,0.00,0.00,3.46,176.46,'2022-02-10 19:37:54','',''),(2652442,'1','208','1038',479,'Retail Sale Id 1643629',9974.08,0.00,0.00,17.56,895.56,'2022-02-10 19:38:42','',''),(2652443,'1','208','1038',479,'Retail Sale Id 1643630',3498.88,0.00,0.00,6.16,314.16,'2022-02-11 08:25:46','',''),(2652444,'1','208','1038',479,'Retail Sale Id 1643631',3408.00,0.00,0.00,6.00,306.00,'2022-02-11 08:31:50','',''),(2652445,'1','208','1038',479,'Retail Sale Id 1643632',3998.72,0.00,0.00,7.04,359.04,'2022-02-11 08:56:52','',''),(2652446,'1','208','1038',479,'Retail Sale Id 1643633',2499.20,0.00,0.00,4.40,224.40,'2022-02-11 08:57:50','',''),(2652447,'1','208','1038',479,'Retail Sale Id 1643634',6588.80,0.00,0.00,11.60,591.60,'2022-02-11 09:04:14','',''),(2652448,'1','208','1038',479,'Retail Sale Id 1643635',1709.68,0.00,0.00,3.01,153.51,'2022-02-11 09:26:50','',''),(2652449,'1','208','1038',479,'Retail Sale Id 1643636',5680.00,0.00,0.00,10.00,510.00,'2022-02-11 09:33:02','',''),(2652450,'1','208','1038',479,'Retail Sale Id 1643637',3402.32,0.00,0.00,5.99,305.49,'2022-02-11 10:08:05','',''),(2652451,'1','208','1038',479,'Retail Sale Id 1643638',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 10:11:52','',''),(2652452,'1','208','1038',479,'Retail Sale Id 1643639',1709.68,0.00,0.00,3.01,153.51,'2022-02-11 10:25:36','',''),(2652453,'1','208','1038',479,'Retail Sale Id 1643640',2999.04,0.00,0.00,5.28,269.28,'2022-02-11 10:32:26','',''),(2652454,'1','208','1038',479,'Retail Sale Id 1643641',1698.32,0.00,0.00,2.99,152.49,'2022-02-11 10:34:14','',''),(2652455,'1','208','1038',479,'Retail Sale Id 1643642',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 10:52:05','',''),(2652456,'1','208','1038',479,'Retail Sale Id 1643643',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 11:04:11','',''),(2652457,'1','208','1038',479,'Retail Sale Id 1643644',17000.24,0.00,0.00,29.93,1526.43,'2022-02-11 11:07:35','',''),(2652458,'1','208','1038',479,'Retail Sale Id 1643645',1698.32,0.00,0.00,2.99,152.49,'2022-02-11 11:08:56','',''),(2652459,'1','208','1038',479,'Retail Sale Id 1643646',4998.40,0.00,0.00,8.80,448.80,'2022-02-11 11:12:03','',''),(2652460,'1','208','1038',479,'Retail Sale Id 1643647',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 11:14:14','',''),(2652461,'1','208','1038',479,'Retail Sale Id 1643648',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 11:14:59','',''),(2652462,'1','208','1038',479,'Retail Sale Id 1643649',2800.24,0.00,0.00,4.93,251.43,'2022-02-11 11:23:45','',''),(2652463,'1','208','1038',479,'Retail Sale Id 1643650',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 11:24:52','',''),(2652464,'1','208','1038',479,'Retail Sale Id 1643651',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 11:31:06','',''),(2652465,'1','208','1038',479,'Retail Sale Id 1643652',4998.40,0.00,0.00,8.80,448.80,'2022-02-11 11:33:41','',''),(2652466,'1','208','1038',479,'Retail Sale Id 1643653',3998.72,0.00,0.00,7.04,359.04,'2022-02-11 11:35:44','',''),(2652467,'1','208','1038',479,'Retail Sale Id 1643654',1709.68,0.00,0.00,3.01,153.51,'2022-02-11 11:37:18','',''),(2652468,'1','208','1038',479,'Retail Sale Id 1643655',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 11:38:24','',''),(2652469,'1','208','1038',479,'Retail Sale Id 1643656',3498.88,0.00,0.00,6.16,314.16,'2022-02-11 11:42:05','',''),(2652470,'1','208','1038',479,'Retail Sale Id 1643657',499.84,0.00,0.00,0.88,44.88,'2022-02-11 11:42:51','',''),(2652471,'1','208','1038',479,'Retail Sale Id 1643658',602.08,0.00,0.00,1.06,54.06,'2022-02-11 11:45:13','',''),(2652472,'1','208','1038',479,'Retail Sale Id 1643659',1499.52,0.00,0.00,2.64,134.64,'2022-02-11 11:48:31','',''),(2652473,'1','208','1038',479,'Retail Sale Id 1643660',1601.76,0.00,0.00,2.82,143.82,'2022-02-11 11:49:21','',''),(2652474,'1','208','1038',479,'Retail Sale Id 1643661',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 11:50:27','',''),(2652475,'1','208','1038',479,'Retail Sale Id 1643662',602.08,0.00,0.00,1.06,54.06,'2022-02-11 11:52:38','',''),(2652476,'1','208','1038',479,'Retail Sale Id 1643663',1499.52,0.00,0.00,2.64,134.64,'2022-02-11 11:54:42','',''),(2652477,'1','208','1038',479,'Retail Sale Id 1643664',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 12:00:28','',''),(2652478,'1','208','1038',479,'Retail Sale Id 1643665',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 12:05:05','',''),(2652479,'1','208','1038',479,'Retail Sale Id 1643666',5680.00,0.00,0.00,10.00,510.00,'2022-02-11 12:06:10','',''),(2652480,'1','208','1038',479,'Retail Sale Id 1643667',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 12:07:23','',''),(2652481,'1','208','1038',479,'Retail Sale Id 1643668',6997.76,0.00,0.00,12.32,628.32,'2022-02-11 12:08:50','',''),(2652482,'1','208','1038',479,'Retail Sale Id 1643669',2999.04,0.00,0.00,5.28,269.28,'2022-02-11 12:16:28','',''),(2652483,'1','208','1038',479,'Retail Sale Id 1643670',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 12:18:55','',''),(2652484,'1','208','1038',479,'Retail Sale Id 1643671',3408.00,0.00,0.00,6.00,306.00,'2022-02-11 12:20:25','',''),(2652485,'1','208','1038',479,'Retail Sale Id 1643671',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 12:20:25','',''),(2652486,'1','208','1038',479,'Retail Sale Id 1643673',2999.04,0.00,0.00,5.28,269.28,'2022-02-11 12:26:34','',''),(2652487,'1','208','1038',479,'Retail Sale Id 1643674',1709.68,0.00,0.00,3.01,153.51,'2022-02-11 12:28:07','',''),(2652488,'1','208','1038',479,'Retail Sale Id 1643674',1709.68,0.00,0.00,3.01,153.51,'2022-02-11 12:28:07','',''),(2652489,'1','208','1038',479,'Retail Sale Id 1643675',1698.32,0.00,0.00,2.99,152.49,'2022-02-11 12:29:19','',''),(2652490,'1','208','1038',479,'Retail Sale Id 1643676',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 12:30:20','',''),(2652491,'1','208','1038',479,'Retail Sale Id 1643677',2840.00,0.00,0.00,5.00,255.00,'2022-02-11 12:39:22','',''),(2652492,'1','208','1038',479,'Retail Sale Id 1643678',1698.32,0.00,0.00,2.99,152.49,'2022-02-11 12:44:53','',''),(2652493,'1','208','1038',479,'Retail Sale Id 1643679',2499.20,0.00,0.00,4.40,224.40,'2022-02-11 12:48:29','',''),(2652494,'1','208','1038',479,'Retail Sale Id 1643680',5680.00,0.00,0.00,10.00,510.00,'2022-02-11 12:51:33','',''),(2652495,'1','208','1038',479,'Retail Sale Id 1643681',3408.00,0.00,0.00,6.00,306.00,'2022-02-11 12:54:47','',''),(2652496,'1','208','1038',479,'Retail Sale Id 1643682',1141.68,0.00,0.00,2.01,102.51,'2022-02-11 13:02:31','',''),(2652497,'1','208','1038',479,'Retail Sale Id 1643682',3408.00,0.00,0.00,6.00,306.00,'2022-02-11 13:02:31','',''),(2652498,'1','208','1038',479,'Retail Sale Id 1643683',1749.44,0.00,0.00,3.08,157.08,'2022-02-11 13:04:40','',''),(2652499,'1','208','1038',479,'Retail Sale Id 1643684',6997.76,0.00,0.00,12.32,628.32,'2022-02-11 13:13:45','',''),(2652500,'1','208','1038',479,'Retail Sale Id 1643685',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 13:14:53','',''),(2652501,'1','208','1038',479,'Retail Sale Id 1643686',2499.20,0.00,0.00,4.40,224.40,'2022-02-11 13:25:16','',''),(2652502,'1','208','1038',479,'Retail Sale Id 1643687',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 13:30:29','',''),(2652503,'1','208','1038',479,'Retail Sale Id 1643689',1704.00,0.00,0.00,3.00,153.00,'2022-02-11 13:33:04','',''),(2652504,'1','208','1038',479,'Retail Sale Id 1643689',2840.00,0.00,0.00,5.00,255.00,'2022-02-11 13:33:04','',''),(2652505,'1','208','1038',479,'Retail Sale Id 1643690',2840.00,0.00,0.00,5.00,255.00,'2022-02-11 13:35:59','',''),(2652506,'1','208','1038',479,'Retail Sale Id 1643691',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 13:37:07','',''),(2652507,'1','208','1038',479,'Retail Sale Id 1643692',3408.00,0.00,0.00,6.00,306.00,'2022-02-11 13:38:42','',''),(2652508,'1','208','1038',479,'Retail Sale Id 1643693',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 13:40:39','',''),(2652509,'1','208','1038',479,'Retail Sale Id 1643694',499.84,0.00,0.00,0.88,44.88,'2022-02-11 13:42:31','',''),(2652510,'1','208','1038',479,'Retail Sale Id 1643695',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 13:43:20','',''),(2652511,'1','208','1038',479,'Retail Sale Id 1643696',3976.00,0.00,0.00,7.00,357.00,'2022-02-11 13:47:09','',''),(2652512,'1','208','1038',479,'Retail Sale Id 1643697',1499.52,0.00,0.00,2.64,134.64,'2022-02-11 13:49:33','',''),(2652513,'1','208','1038',479,'Retail Sale Id 1643698',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 13:56:26','',''),(2652514,'1','208','1038',479,'Retail Sale Id 1643699',1800.56,0.00,0.00,3.17,161.67,'2022-02-11 13:57:38','',''),(2652515,'1','208','1038',479,'Retail Sale Id 1643700',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 14:08:24','',''),(2652516,'1','208','1038',479,'Retail Sale Id 1643701',1499.52,0.00,0.00,2.64,134.64,'2022-02-11 14:13:41','',''),(2652517,'1','208','1038',479,'Retail Sale Id 1643702',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 14:18:13','',''),(2652518,'1','208','1038',479,'Retail Sale Id 1643703',1698.32,0.00,0.00,2.99,152.49,'2022-02-11 14:29:55','',''),(2652519,'1','208','1038',479,'Retail Sale Id 1643704',1136.00,0.00,0.00,2.00,102.00,'2022-02-11 14:31:16','',''),(2652520,'1','208','1038',479,'Retail Sale Id 1643704',6248.00,0.00,0.00,11.00,561.00,'2022-02-11 14:31:16','',''),(2652521,'1','208','1038',479,'Retail Sale Id 1643705',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 14:33:48','',''),(2652522,'1','208','1038',479,'Retail Sale Id 1643706',1709.68,0.00,0.00,3.01,153.51,'2022-02-11 14:38:42','',''),(2652523,'1','208','1038',479,'Retail Sale Id 1643706',2840.00,0.00,0.00,5.00,255.00,'2022-02-11 14:38:42','',''),(2652524,'1','208','1038',479,'Retail Sale Id 1643707',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 14:39:26','',''),(2652525,'1','208','1038',479,'Retail Sale Id 1643708',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 14:41:19','',''),(2652526,'1','208','1038',479,'Retail Sale Id 1643709',3419.36,0.00,0.00,6.02,307.02,'2022-02-11 14:46:38','',''),(2652527,'1','208','1038',479,'Retail Sale Id 1643710',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 14:49:58','',''),(2652528,'1','208','1038',479,'Retail Sale Id 1643711',1800.56,0.00,0.00,3.17,161.67,'2022-02-11 15:24:06','',''),(2652529,'1','208','1038',479,'Retail Sale Id 1643712',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 15:25:21','',''),(2652530,'1','208','1038',479,'Retail Sale Id 1643713',3408.00,0.00,0.00,6.00,306.00,'2022-02-11 15:39:39','',''),(2652531,'1','208','1038',479,'Retail Sale Id 1643714',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 15:58:40','',''),(2652532,'1','208','1038',479,'Retail Sale Id 1643715',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 16:00:13','',''),(2652533,'1','208','1038',479,'Retail Sale Id 1643716',3498.88,0.00,0.00,6.16,314.16,'2022-02-11 16:02:06','',''),(2652534,'1','208','1038',479,'Retail Sale Id 1643716',3498.88,0.00,0.00,6.16,314.16,'2022-02-11 16:02:06','',''),(2652535,'1','208','1038',479,'Retail Sale Id 1643717',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 16:03:17','',''),(2652536,'1','208','1038',479,'Retail Sale Id 1643718',3498.88,0.00,0.00,6.16,314.16,'2022-02-11 16:07:14','',''),(2652537,'1','208','1038',479,'Retail Sale Id 1643720',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 16:19:49','',''),(2652538,'1','208','1038',479,'Retail Sale Id 1643721',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 16:23:22','',''),(2652539,'1','208','1038',479,'Retail Sale Id 1643722',2999.04,0.00,0.00,5.28,269.28,'2022-02-11 16:24:13','',''),(2652540,'1','208','1038',479,'Retail Sale Id 1643723',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 16:27:01','',''),(2652541,'1','208','1038',479,'Retail Sale Id 1643724',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 16:35:18','',''),(2652542,'1','208','1038',479,'Retail Sale Id 1643725',6997.76,0.00,0.00,12.32,628.32,'2022-02-11 16:39:09','',''),(2652543,'1','208','1038',479,'Retail Sale Id 1643726',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 16:40:20','',''),(2652544,'1','208','1038',479,'Retail Sale Id 1643727',1141.68,0.00,0.00,2.01,102.51,'2022-02-11 16:46:09','',''),(2652545,'1','208','1038',479,'Retail Sale Id 1643728',3498.88,0.00,0.00,6.16,314.16,'2022-02-11 16:48:38','',''),(2652546,'1','208','1038',479,'Retail Sale Id 1643728',3498.88,0.00,0.00,6.16,314.16,'2022-02-11 16:48:38','',''),(2652547,'1','208','1038',479,'Retail Sale Id 1643729',999.68,0.00,0.00,1.76,89.76,'2022-02-11 16:52:25','',''),(2652548,'1','208','1038',479,'Retail Sale Id 1643731',1902.80,0.00,0.00,3.35,170.85,'2022-02-11 16:54:49','',''),(2652549,'1','208','1038',479,'Retail Sale Id 1643731',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 16:54:49','',''),(2652550,'1','208','1038',479,'Retail Sale Id 1643732',2840.00,0.00,0.00,5.00,255.00,'2022-02-11 16:56:30','',''),(2652551,'1','208','1038',479,'Retail Sale Id 1643733',999.68,0.00,0.00,1.76,89.76,'2022-02-11 16:57:52','',''),(2652552,'1','208','1038',479,'Retail Sale Id 1643734',1709.68,0.00,0.00,3.01,153.51,'2022-02-11 17:09:38','',''),(2652553,'1','208','1038',479,'Retail Sale Id 1643735',1999.36,0.00,0.00,3.52,179.52,'2022-02-11 17:11:12','',''),(2652554,'1','208','1038',479,'Retail Sale Id 1643736',2840.00,0.00,0.00,5.00,255.00,'2022-02-11 17:14:40','',''),(2652555,'1','208','1038',479,'Retail Sale Id 1643737',3408.00,0.00,0.00,6.00,306.00,'2022-02-11 17:16:00','',''),(2652556,'1','208','1038',479,'Retail Sale Id 1643738',6997.76,0.00,0.00,12.32,628.32,'2022-02-11 17:16:49','',''),(2652557,'1','208','1038',479,'Retail Sale Id 1643739',2840.00,0.00,0.00,5.00,255.00,'2022-02-11 17:20:07','',''),(2652558,'1','208','1038',479,'Retail Sale Id 1643740',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 17:22:51','',''),(2652559,'1','208','1038',479,'Retail Sale Id 1643741',999.68,0.00,0.00,1.76,89.76,'2022-02-11 17:26:09','',''),(2652560,'1','208','1038',479,'Retail Sale Id 1643742',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 17:27:01','',''),(2652561,'1','208','1038',479,'Retail Sale Id 1643743',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 17:32:17','',''),(2652562,'1','208','1038',479,'Retail Sale Id 1643745',3408.00,0.00,0.00,6.00,306.00,'2022-02-11 17:34:06','',''),(2652563,'1','208','1038',479,'Retail Sale Id 1643746',999.68,0.00,0.00,1.76,89.76,'2022-02-11 17:36:00','',''),(2652564,'1','208','1038',479,'Retail Sale Id 1643747',3408.00,0.00,0.00,6.00,306.00,'2022-02-11 17:42:05','',''),(2652565,'1','208','1038',479,'Retail Sale Id 1643748',1800.56,0.00,0.00,3.17,161.67,'2022-02-11 17:43:26','',''),(2652566,'1','208','1038',479,'Retail Sale Id 1643749',3442.08,0.00,0.00,6.06,309.06,'2022-02-11 17:44:52','',''),(2652567,'1','208','1038',479,'Retail Sale Id 1643750',3498.88,0.00,0.00,6.16,314.16,'2022-02-11 17:46:05','',''),(2652568,'1','208','1038',479,'Retail Sale Id 1643751',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 17:46:57','',''),(2652569,'1','208','1038',479,'Retail Sale Id 1643752',2499.20,0.00,0.00,4.40,224.40,'2022-02-11 17:51:29','',''),(2652570,'1','208','1038',479,'Retail Sale Id 1643753',3998.72,0.00,0.00,7.04,359.04,'2022-02-11 17:56:36','',''),(2652571,'1','208','1038',479,'Retail Sale Id 1643754',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 18:04:44','',''),(2652572,'1','208','1038',479,'Retail Sale Id 1643755',5998.08,0.00,0.00,10.56,538.56,'2022-02-11 18:06:33','',''),(2652573,'1','208','1038',479,'Retail Sale Id 1643756',7100.00,0.00,0.00,12.50,637.50,'2022-02-11 18:28:34','',''),(2652574,'1','208','1038',479,'Retail Sale Id 1643756',14200.00,0.00,0.00,25.00,1275.00,'2022-02-11 18:28:34','',''),(2652575,'1','208','1038',479,'Retail Sale Id 1643757',1499.52,0.00,0.00,2.64,134.64,'2022-02-11 18:30:59','',''),(2652576,'1','208','1038',479,'Retail Sale Id 1643758',5680.00,0.00,0.00,10.00,510.00,'2022-02-11 18:31:56','',''),(2652577,'1','208','1038',479,'Retail Sale Id 1643759',1698.32,0.00,0.00,2.99,152.49,'2022-02-11 18:33:29','',''),(2652578,'1','208','1038',479,'Retail Sale Id 1643760',2800.24,0.00,0.00,4.93,251.43,'2022-02-11 18:44:43','',''),(2652579,'1','208','1038',479,'Return of Retail Sale Id 1643754',0.00,7100.00,12.50,0.00,-637.50,'2022-02-11 19:30:06','',''),(2652580,'1','208','1038',479,'Return of Retail Sale Id 1643751',0.00,7100.00,12.50,0.00,-637.50,'2022-02-11 19:30:37','',''),(2652581,'1','208','1038',479,'Return of Retail Sale Id 1643742',0.00,7100.00,12.50,0.00,-637.50,'2022-02-11 19:32:47','',''),(2652582,'1','208','1038',479,'Return of Retail Sale Id 1643743',0.00,7100.00,12.50,0.00,-637.50,'2022-02-11 19:33:37','',''),(2652583,'1','208','1038',479,'Retail Sale Id 1643761',19130.24,0.00,0.00,33.68,1717.68,'2022-02-11 19:38:53','',''),(2652584,'1','208','1038',479,'Retail Sale Id 1643764',71738.40,0.00,0.00,126.30,6441.30,'2022-02-11 19:40:00','',''),(2652585,'1','208','1038',479,'Retail Sale Id 1643765',5077.92,0.00,0.00,8.94,455.94,'2022-02-11 19:42:04','',''),(2652586,'1','208',NULL,479,'Reception corrector for bridging 132391',0.00,0.00,0.00,5000.00,0.00,'2022-02-12 10:10:32','',''),(2652587,'1','208','1038',479,'Received from bridging 132391',0.00,0.00,5000.00,0.00,0.00,'2022-02-12 10:10:32','',''),(2652588,'1','208','1038',479,'Retail Sale Id 1643767',23316.40,0.00,0.00,41.05,2093.55,'2022-02-12 10:12:43','',''),(2652589,'1','208','1038',479,'Retail Sale Id 1643768',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 10:18:10','',''),(2652590,'1','208','1038',479,'Retail Sale Id 1643769',1136.00,0.00,0.00,2.00,102.00,'2022-02-12 10:25:46','',''),(2652591,'1','208','1038',479,'Retail Sale Id 1643769',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 10:25:46','',''),(2652592,'1','208','1038',479,'Retail Sale Id 1643770',2851.36,0.00,0.00,5.02,256.02,'2022-02-12 10:31:11','',''),(2652593,'1','208','1038',479,'Retail Sale Id 1643771',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 10:35:01','',''),(2652594,'1','208','1038',479,'Retail Sale Id 1643773',3402.32,0.00,0.00,5.99,305.49,'2022-02-12 10:39:20','',''),(2652595,'1','208','1038',479,'Retail Sale Id 1643773',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 10:39:20','',''),(2652596,'1','208','1038',479,'Retail Sale Id 1643774',2999.04,0.00,0.00,5.28,269.28,'2022-02-12 10:45:40','',''),(2652597,'1','208','1038',479,'Retail Sale Id 1643774',5998.08,0.00,0.00,10.56,538.56,'2022-02-12 10:45:40','',''),(2652598,'1','208','1038',479,'Retail Sale Id 1643775',2999.04,0.00,0.00,5.28,269.28,'2022-02-12 10:52:48','',''),(2652599,'1','208','1038',479,'Retail Sale Id 1643776',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 10:55:29','',''),(2652600,'1','208','1038',479,'Retail Sale Id 1643777',6997.76,0.00,0.00,12.32,628.32,'2022-02-12 10:56:45','',''),(2652601,'1','208','1038',479,'Retail Sale Id 1643778',3998.72,0.00,0.00,7.04,359.04,'2022-02-12 10:59:57','',''),(2652602,'1','208','1038',479,'Retail Sale Id 1643779',999.68,0.00,0.00,1.76,89.76,'2022-02-12 11:00:24','',''),(2652603,'1','208','1038',479,'Retail Sale Id 1643780',999.68,0.00,0.00,1.76,89.76,'2022-02-12 11:07:49','',''),(2652604,'1','208','1038',479,'Retail Sale Id 1643781',3408.00,0.00,0.00,6.00,306.00,'2022-02-12 11:13:49','',''),(2652605,'1','208','1038',479,'Retail Sale Id 1643781',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 11:13:49','',''),(2652606,'1','208','1038',479,'Retail Sale Id 1643782',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 11:19:04','',''),(2652607,'1','208','1038',479,'Retail Sale Id 1643784',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 11:32:07','',''),(2652608,'1','208','1038',479,'Retail Sale Id 1643785',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 11:35:25','',''),(2652609,'1','208','1038',479,'Retail Sale Id 1643786',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 11:38:38','',''),(2652610,'1','208','1038',479,'Retail Sale Id 1643787',28400.00,0.00,0.00,50.00,2550.00,'2022-02-12 11:42:44','',''),(2652611,'1','208','1038',479,'Retail Sale Id 1643788',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 11:46:13','',''),(2652612,'1','208','1038',479,'Retail Sale Id 1643789',1698.32,0.00,0.00,2.99,152.49,'2022-02-12 11:47:08','',''),(2652613,'1','208','1038',479,'Retail Sale Id 1643790',2499.20,0.00,0.00,4.40,224.40,'2022-02-12 11:49:10','',''),(2652614,'1','208','1038',479,'Retail Sale Id 1643790',2499.20,0.00,0.00,4.40,224.40,'2022-02-12 11:49:10','',''),(2652615,'1','208','1038',479,'Retail Sale Id 1643790',3408.00,0.00,0.00,6.00,306.00,'2022-02-12 11:49:10','',''),(2652616,'1','208','1038',479,'Retail Sale Id 1643791',2999.04,0.00,0.00,5.28,269.28,'2022-02-12 11:55:33','',''),(2652617,'1','208','1038',479,'Retail Sale Id 1643792',2999.04,0.00,0.00,5.28,269.28,'2022-02-12 11:56:36','',''),(2652618,'1','208','1038',479,'Retail Sale Id 1643793',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 12:00:02','',''),(2652619,'1','208','1038',479,'Retail Sale Id 1643794',3601.12,0.00,0.00,6.34,323.34,'2022-02-12 12:01:50','',''),(2652620,'1','208','1038',479,'Retail Sale Id 1643795',2999.04,0.00,0.00,5.28,269.28,'2022-02-12 12:09:23','',''),(2652621,'1','208','1038',479,'Retail Sale Id 1643796',999.68,0.00,0.00,1.76,89.76,'2022-02-12 12:10:28','',''),(2652622,'1','208','1038',479,'Retail Sale Id 1643797',1709.68,0.00,0.00,3.01,153.51,'2022-02-12 12:10:59','',''),(2652623,'1','208','1038',479,'Retail Sale Id 1643798',4498.56,0.00,0.00,7.92,403.92,'2022-02-12 12:12:54','',''),(2652624,'1','208','1038',479,'Retail Sale Id 1643799',5680.00,0.00,0.00,10.00,510.00,'2022-02-12 12:14:36','',''),(2652625,'1','208','1038',479,'Retail Sale Id 1643800',3498.88,0.00,0.00,6.16,314.16,'2022-02-12 12:15:52','',''),(2652626,'1','208','1038',479,'Retail Sale Id 1643801',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 12:16:43','',''),(2652627,'1','208','1038',479,'Retail Sale Id 1643802',3447.76,0.00,0.00,6.07,309.57,'2022-02-12 12:17:41','',''),(2652628,'1','208','1038',479,'Retail Sale Id 1643803',2300.40,0.00,0.00,4.05,206.55,'2022-02-12 12:18:22','',''),(2652629,'1','208','1038',479,'Retail Sale Id 1643804',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 12:23:52','',''),(2652630,'1','208','1038',479,'Retail Sale Id 1643805',3408.00,0.00,0.00,6.00,306.00,'2022-02-12 12:37:04','',''),(2652631,'1','208','1038',479,'Retail Sale Id 1643806',4544.00,0.00,0.00,8.00,408.00,'2022-02-12 12:41:23','',''),(2652632,'1','208','1038',479,'Retail Sale Id 1643807',6497.92,0.00,0.00,11.44,583.44,'2022-02-12 12:59:51','',''),(2652633,'1','208','1038',479,'Retail Sale Id 1643809',2999.04,0.00,0.00,5.28,269.28,'2022-02-12 13:00:50','',''),(2652634,'1','208','1038',479,'Retail Sale Id 1643810',14200.00,0.00,0.00,25.00,1275.00,'2022-02-12 13:01:53','',''),(2652635,'1','208','1038',479,'Retail Sale Id 1643811',2851.36,0.00,0.00,5.02,256.02,'2022-02-12 13:06:54','',''),(2652636,'1','208','1038',479,'Retail Sale Id 1643812',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 13:19:28','',''),(2652637,'1','208','1038',479,'Retail Sale Id 1643813',2840.00,0.00,0.00,5.00,255.00,'2022-02-12 13:22:21','',''),(2652638,'1','208','1038',479,'Retail Sale Id 1643814',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 13:24:49','',''),(2652639,'1','208','1038',479,'Retail Sale Id 1643814',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 13:24:49','',''),(2652640,'1','208','1038',479,'Retail Sale Id 1643816',6997.76,0.00,0.00,12.32,628.32,'2022-02-12 13:26:08','',''),(2652641,'1','208','1038',479,'Retail Sale Id 1643817',1709.68,0.00,0.00,3.01,153.51,'2022-02-12 13:29:27','',''),(2652642,'1','208','1038',479,'Retail Sale Id 1643817',3408.00,0.00,0.00,6.00,306.00,'2022-02-12 13:29:27','',''),(2652643,'1','208','1038',479,'Retail Sale Id 1643818',6997.76,0.00,0.00,12.32,628.32,'2022-02-12 13:30:44','',''),(2652644,'1','208','1038',479,'Retail Sale Id 1643819',3998.72,0.00,0.00,7.04,359.04,'2022-02-12 13:34:57','',''),(2652645,'1','208','1038',479,'Retail Sale Id 1643820',4998.40,0.00,0.00,8.80,448.80,'2022-02-12 13:47:57','',''),(2652646,'1','208','1038',479,'Retail Sale Id 1643821',2999.04,0.00,0.00,5.28,269.28,'2022-02-12 13:53:00','',''),(2652647,'1','208','1038',479,'Retail Sale Id 1643822',3447.76,0.00,0.00,6.07,309.57,'2022-02-12 13:56:49','',''),(2652648,'1','208','1038',479,'Retail Sale Id 1643823',2851.36,0.00,0.00,5.02,256.02,'2022-02-12 13:58:42','',''),(2652649,'1','208','1038',479,'Retail Sale Id 1643825',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 14:05:30','',''),(2652650,'1','208','1038',479,'Retail Sale Id 1643826',14200.00,0.00,0.00,25.00,1275.00,'2022-02-12 14:07:17','',''),(2652651,'1','208','1038',479,'Retail Sale Id 1643827',3998.72,0.00,0.00,7.04,359.04,'2022-02-12 14:10:39','',''),(2652652,'1','208','1038',479,'Retail Sale Id 1643828',3498.88,0.00,0.00,6.16,314.16,'2022-02-12 14:21:40','',''),(2652653,'1','208','1038',479,'Retail Sale Id 1643828',7497.60,0.00,0.00,13.20,673.20,'2022-02-12 14:21:40','',''),(2652654,'1','208','1038',479,'Retail Sale Id 1643829',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 14:22:41','',''),(2652655,'1','208','1038',479,'Retail Sale Id 1643830',3498.88,0.00,0.00,6.16,314.16,'2022-02-12 14:25:58','',''),(2652656,'1','208','1038',479,'Retail Sale Id 1643831',2999.04,0.00,0.00,5.28,269.28,'2022-02-12 14:26:45','',''),(2652657,'1','208','1038',479,'Retail Sale Id 1643832',3300.08,0.00,0.00,5.81,296.31,'2022-02-12 14:30:39','',''),(2652658,'1','208','1038',479,'Retail Sale Id 1643833',5680.00,0.00,0.00,10.00,510.00,'2022-02-12 14:33:44','',''),(2652659,'1','208','1038',479,'Retail Sale Id 1643834',3498.88,0.00,0.00,6.16,314.16,'2022-02-12 14:35:36','',''),(2652660,'1','208','1038',479,'Retail Sale Id 1643835',2800.24,0.00,0.00,4.93,251.43,'2022-02-12 14:42:17','',''),(2652661,'1','208','1038',479,'Retail Sale Id 1643836',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 14:44:22','',''),(2652662,'1','208','1038',479,'Retail Sale Id 1643837',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 14:46:04','',''),(2652663,'1','208','1038',479,'Retail Sale Id 1643840',1749.44,0.00,0.00,3.08,157.08,'2022-02-12 14:52:33','',''),(2652664,'1','208','1038',479,'Retail Sale Id 1643841',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 14:53:49','',''),(2652665,'1','208','1038',479,'Retail Sale Id 1643842',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 14:55:04','',''),(2652666,'1','208','1038',479,'Retail Sale Id 1643843',499.84,0.00,0.00,0.88,44.88,'2022-02-12 15:00:31','',''),(2652667,'1','208','1038',479,'Retail Sale Id 1643844',3408.00,0.00,0.00,6.00,306.00,'2022-02-12 15:02:43','',''),(2652668,'1','208','1038',479,'Retail Sale Id 1643845',3498.88,0.00,0.00,6.16,314.16,'2022-02-12 15:06:17','',''),(2652669,'1','208','1038',479,'Retail Sale Id 1643846',1749.44,0.00,0.00,3.08,157.08,'2022-02-12 15:09:30','',''),(2652670,'1','208','1038',479,'Retail Sale Id 1643847',999.68,0.00,0.00,1.76,89.76,'2022-02-12 15:11:32','',''),(2652671,'1','208','1038',479,'Retail Sale Id 1643848',2499.20,0.00,0.00,4.40,224.40,'2022-02-12 15:13:47','',''),(2652672,'1','208','1038',479,'Retail Sale Id 1643849',3408.00,0.00,0.00,6.00,306.00,'2022-02-12 15:14:53','',''),(2652673,'1','208','1038',479,'Retail Sale Id 1643850',7202.24,0.00,0.00,12.68,646.68,'2022-02-12 15:16:51','',''),(2652674,'1','208','1038',479,'Retail Sale Id 1643852',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 15:20:54','',''),(2652675,'1','208','1038',479,'Retail Sale Id 1643853',800.88,0.00,0.00,1.41,71.91,'2022-02-12 15:24:24','',''),(2652676,'1','208','1038',479,'Retail Sale Id 1643854',3498.88,0.00,0.00,6.16,314.16,'2022-02-12 15:27:49','',''),(2652677,'1','208','1038',479,'Retail Sale Id 1643855',3498.88,0.00,0.00,6.16,314.16,'2022-02-12 15:33:47','',''),(2652678,'1','208','1038',479,'Retail Sale Id 1643856',2999.04,0.00,0.00,5.28,269.28,'2022-02-12 15:43:08','',''),(2652679,'1','208','1038',479,'Retail Sale Id 1643857',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 15:46:53','',''),(2652680,'1','208','1038',479,'Retail Sale Id 1643858',1709.68,0.00,0.00,3.01,153.51,'2022-02-12 16:03:26','',''),(2652681,'1','208','1038',479,'Retail Sale Id 1643859',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 16:04:51','',''),(2652682,'1','208','1038',479,'Retail Sale Id 1643860',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 16:16:28','',''),(2652683,'1','208','1038',479,'Retail Sale Id 1643861',1709.68,0.00,0.00,3.01,153.51,'2022-02-12 16:21:59','',''),(2652684,'1','208','1038',479,'Retail Sale Id 1643862',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 16:25:03','',''),(2652685,'1','208','1038',479,'Retail Sale Id 1643863',2851.36,0.00,0.00,5.02,256.02,'2022-02-12 16:26:49','',''),(2652686,'1','208','1038',479,'Retail Sale Id 1643865',3498.88,0.00,0.00,6.16,314.16,'2022-02-12 16:28:49','',''),(2652687,'1','208','1038',479,'Retail Sale Id 1643866',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 16:30:24','',''),(2652688,'1','208','1038',479,'Retail Sale Id 1643868',1499.52,0.00,0.00,2.64,134.64,'2022-02-12 16:38:22','',''),(2652689,'1','208','1038',479,'Retail Sale Id 1643868',3998.72,0.00,0.00,7.04,359.04,'2022-02-12 16:38:22','',''),(2652690,'1','208','1038',479,'Retail Sale Id 1643869',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 16:40:57','',''),(2652691,'1','208','1038',479,'Retail Sale Id 1643870',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 16:45:14','',''),(2652692,'1','208','1038',479,'Retail Sale Id 1643871',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 17:04:16','',''),(2652693,'1','208','1038',479,'Retail Sale Id 1643872',2851.36,0.00,0.00,5.02,256.02,'2022-02-12 17:04:54','',''),(2652694,'1','208','1038',479,'Retail Sale Id 1643873',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 17:20:03','',''),(2652695,'1','208','1038',479,'Retail Sale Id 1643874',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 17:45:24','',''),(2652696,'1','208','1038',479,'Retail Sale Id 1643876',12001.84,0.00,0.00,21.13,1077.63,'2022-02-12 18:07:46','',''),(2652697,'1','208','1038',479,'Retail Sale Id 1643877',1397.28,0.00,0.00,2.46,125.46,'2022-02-12 18:13:29','',''),(2652698,'1','208','1038',479,'Retail Sale Id 1643878',4998.40,0.00,0.00,8.80,448.80,'2022-02-12 18:21:08','',''),(2652699,'1','208','1038',479,'Retail Sale Id 1643879',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 18:22:25','',''),(2652700,'1','208','1038',479,'Retail Sale Id 1643881',7100.00,0.00,0.00,12.50,637.50,'2022-02-12 18:26:05','',''),(2652701,'1','208','1038',479,'Retail Sale Id 1643883',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 18:28:39','',''),(2652702,'1','208','1038',479,'Retail Sale Id 1643884',1999.36,0.00,0.00,3.52,179.52,'2022-02-12 18:38:26','',''),(2652703,'1','208','1038',479,'Retail Sale Id 1643885',3408.00,0.00,0.00,6.00,306.00,'2022-02-12 18:53:33','',''),(2652704,'1','208','1038',479,'Retail Sale Id 1643886',42776.08,0.00,0.00,75.31,3840.81,'2022-02-12 19:13:32','',''),(2652705,'1','208','1038',479,'Retail Sale Id 1643887',56606.88,0.00,0.00,99.66,5082.66,'2022-02-12 19:14:26','',''),(2652706,'1','208','1038',479,'Retail Sale Id 1643888',1709.68,0.00,0.00,3.01,153.51,'2022-02-13 09:06:37','',''),(2652707,'1','208','1038',479,'Retail Sale Id 1643889',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 09:08:05','',''),(2652708,'1','208','1038',479,'Retail Sale Id 1643890',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 09:09:02','',''),(2652709,'1','208','1038',479,'Retail Sale Id 1643891',2999.04,0.00,0.00,5.28,269.28,'2022-02-13 09:09:34','',''),(2652710,'1','208','1038',479,'Retail Sale Id 1643892',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 09:10:56','',''),(2652711,'1','208','1038',479,'Retail Sale Id 1643892',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 09:10:56','',''),(2652712,'1','208','1038',479,'Retail Sale Id 1643893',3498.88,0.00,0.00,6.16,314.16,'2022-02-13 09:11:56','',''),(2652713,'1','208','1038',479,'Retail Sale Id 1643894',2851.36,0.00,0.00,5.02,256.02,'2022-02-13 09:13:02','',''),(2652714,'1','208','1038',479,'Retail Sale Id 1643895',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 09:15:46','',''),(2652715,'1','208','1038',479,'Retail Sale Id 1643896',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 09:16:42','',''),(2652716,'1','208','1038',479,'Retail Sale Id 1643897',1698.32,0.00,0.00,2.99,152.49,'2022-02-13 09:17:49','',''),(2652717,'1','208','1038',479,'Retail Sale Id 1643898',2840.00,0.00,0.00,5.00,255.00,'2022-02-13 09:18:42','',''),(2652718,'1','208','1038',479,'Retail Sale Id 1643899',2840.00,0.00,0.00,5.00,255.00,'2022-02-13 09:20:08','',''),(2652719,'1','208','1038',479,'Retail Sale Id 1643900',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 09:21:14','',''),(2652720,'1','208','1038',479,'Retail Sale Id 1643901',2800.24,0.00,0.00,4.93,251.43,'2022-02-13 09:22:11','',''),(2652721,'1','208','1038',479,'Retail Sale Id 1643902',2840.00,0.00,0.00,5.00,255.00,'2022-02-13 09:23:12','',''),(2652722,'1','208','1038',479,'Retail Sale Id 1643903',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 09:23:52','',''),(2652723,'1','208','1038',479,'Retail Sale Id 1643904',1698.32,0.00,0.00,2.99,152.49,'2022-02-13 09:24:36','',''),(2652724,'1','208','1038',479,'Retail Sale Id 1643905',3498.88,0.00,0.00,6.16,314.16,'2022-02-13 09:26:16','',''),(2652725,'1','208','1038',479,'Retail Sale Id 1643906',2499.20,0.00,0.00,4.40,224.40,'2022-02-13 09:28:14','',''),(2652726,'1','208','1038',479,'Retail Sale Id 1643907',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 09:28:52','',''),(2652727,'1','208','1038',479,'Retail Sale Id 1643908',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 09:29:28','',''),(2652728,'1','208','1038',479,'Retail Sale Id 1643909',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 09:31:23','',''),(2652729,'1','208','1038',479,'Retail Sale Id 1643910',840.64,0.00,0.00,1.48,75.48,'2022-02-13 09:32:57','',''),(2652730,'1','208','1038',479,'Retail Sale Id 1643911',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 09:34:37','',''),(2652731,'1','208','1038',479,'Retail Sale Id 1643912',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 09:35:47','',''),(2652732,'1','208','1038',479,'Retail Sale Id 1643913',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 09:37:42','',''),(2652733,'1','208','1038',479,'Retail Sale Id 1643914',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 09:51:19','',''),(2652734,'1','208','1038',479,'Retail Sale Id 1643915',2999.04,0.00,0.00,5.28,269.28,'2022-02-13 09:53:19','',''),(2652735,'1','208','1038',479,'Retail Sale Id 1643916',3550.00,0.00,0.00,6.25,318.75,'2022-02-13 10:01:14','',''),(2652736,'1','208','1038',479,'Retail Sale Id 1643917',499.84,0.00,0.00,0.88,44.88,'2022-02-13 10:02:22','',''),(2652737,'1','208','1038',479,'Retail Sale Id 1643918',5998.08,0.00,0.00,10.56,538.56,'2022-02-13 10:09:53','',''),(2652738,'1','208','1038',479,'Retail Sale Id 1643919',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 10:16:48','',''),(2652739,'1','208','1038',479,'Retail Sale Id 1643920',2999.04,0.00,0.00,5.28,269.28,'2022-02-13 10:30:10','',''),(2652740,'1','208','1038',479,'Retail Sale Id 1643921',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 10:32:16','',''),(2652741,'1','208','1038',479,'Retail Sale Id 1643922',2840.00,0.00,0.00,5.00,255.00,'2022-02-13 10:37:45','',''),(2652742,'1','208','1038',479,'Retail Sale Id 1643923',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 10:43:30','',''),(2652743,'1','208','1038',479,'Retail Sale Id 1643924',6997.76,0.00,0.00,12.32,628.32,'2022-02-13 10:55:02','',''),(2652744,'1','208','1038',479,'Retail Sale Id 1643925',1709.68,0.00,0.00,3.01,153.51,'2022-02-13 11:12:19','',''),(2652745,'1','208','1038',479,'Retail Sale Id 1643926',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 11:23:53','',''),(2652746,'1','208','1038',479,'Retail Sale Id 1643927',5702.72,0.00,0.00,10.04,512.04,'2022-02-13 11:33:28','',''),(2652747,'1','208','1038',479,'Retail Sale Id 1643928',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 11:36:13','',''),(2652748,'1','208','1038',479,'Retail Sale Id 1643929',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 11:38:49','',''),(2652749,'1','208','1038',479,'Retail Sale Id 1643930',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 11:40:00','',''),(2652750,'1','208','1038',479,'Retail Sale Id 1643930',5680.00,0.00,0.00,10.00,510.00,'2022-02-13 11:40:00','',''),(2652751,'1','208','1038',479,'Retail Sale Id 1643930',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 11:40:00','',''),(2652752,'1','208','1038',479,'Retail Sale Id 1643931',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 11:49:11','',''),(2652753,'1','208','1038',479,'Retail Sale Id 1643932',3447.76,0.00,0.00,6.07,309.57,'2022-02-13 12:23:14','',''),(2652754,'1','208','1038',479,'Retail Sale Id 1643933',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 12:25:48','',''),(2652755,'1','208','1038',479,'Retail Sale Id 1643934',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 12:40:01','',''),(2652756,'1','208','1038',479,'Retail Sale Id 1643935',602.08,0.00,0.00,1.06,54.06,'2022-02-13 12:49:06','',''),(2652757,'1','208','1038',479,'Retail Sale Id 1643936',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 12:50:52','',''),(2652758,'1','208','1038',479,'Retail Sale Id 1643937',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 12:56:01','',''),(2652759,'1','208','1038',479,'Retail Sale Id 1643938',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 13:00:41','',''),(2652760,'1','208','1038',479,'Retail Sale Id 1643939',999.68,0.00,0.00,1.76,89.76,'2022-02-13 13:05:33','',''),(2652761,'1','208','1038',479,'Retail Sale Id 1643939',2999.04,0.00,0.00,5.28,269.28,'2022-02-13 13:05:33','',''),(2652762,'1','208','1038',479,'Retail Sale Id 1643940',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 13:06:36','',''),(2652763,'1','208','1038',479,'Retail Sale Id 1643941',1499.52,0.00,0.00,2.64,134.64,'2022-02-13 13:08:36','',''),(2652764,'1','208','1038',479,'Retail Sale Id 1643942',2840.00,0.00,0.00,5.00,255.00,'2022-02-13 13:12:03','',''),(2652765,'1','208','1038',479,'Retail Sale Id 1643943',1709.68,0.00,0.00,3.01,153.51,'2022-02-13 13:19:21','',''),(2652766,'1','208','1038',479,'Retail Sale Id 1643943',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 13:19:21','',''),(2652767,'1','208','1038',479,'Retail Sale Id 1643944',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 13:21:28','',''),(2652768,'1','208','1038',479,'Retail Sale Id 1643945',4998.40,0.00,0.00,8.80,448.80,'2022-02-13 13:25:44','',''),(2652769,'1','208','1038',479,'Retail Sale Id 1643946',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 13:26:54','',''),(2652770,'1','208','1038',479,'Retail Sale Id 1643947',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 13:29:46','',''),(2652771,'1','208','1038',479,'Retail Sale Id 1643948',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 13:32:00','',''),(2652772,'1','208','1038',479,'Retail Sale Id 1643950',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 13:33:58','',''),(2652773,'1','208','1038',479,'Retail Sale Id 1643951',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 13:37:41','',''),(2652774,'1','208','1038',479,'Retail Sale Id 1643952',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 13:39:57','',''),(2652775,'1','208','1038',479,'Retail Sale Id 1643953',2840.00,0.00,0.00,5.00,255.00,'2022-02-13 13:44:53','',''),(2652776,'1','208','1038',479,'Retail Sale Id 1643954',1198.48,0.00,0.00,2.11,107.61,'2022-02-13 13:46:15','',''),(2652777,'1','208','1038',479,'Retail Sale Id 1643955',2999.04,0.00,0.00,5.28,269.28,'2022-02-13 13:57:47','',''),(2652778,'1','208','1038',479,'Retail Sale Id 1643956',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 14:16:16','',''),(2652779,'1','208','1038',479,'Retail Sale Id 1643957',1800.56,0.00,0.00,3.17,161.67,'2022-02-13 14:16:47','',''),(2652780,'1','208','1038',479,'Retail Sale Id 1643958',1709.68,0.00,0.00,3.01,153.51,'2022-02-13 14:18:19','',''),(2652781,'1','208','1038',479,'Retail Sale Id 1643958',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 14:18:19','',''),(2652782,'1','208','1038',479,'Retail Sale Id 1643959',11360.00,0.00,0.00,20.00,1020.00,'2022-02-13 14:19:31','',''),(2652783,'1','208','1038',479,'Retail Sale Id 1643960',2999.04,0.00,0.00,5.28,269.28,'2022-02-13 14:20:37','',''),(2652784,'1','208','1038',479,'Retail Sale Id 1643961',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 14:21:37','',''),(2652785,'1','208','1038',479,'Retail Sale Id 1643962',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 14:25:37','',''),(2652786,'1','208','1038',479,'Retail Sale Id 1643962',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 14:25:37','',''),(2652787,'1','208','1038',479,'Retail Sale Id 1643963',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 14:30:33','',''),(2652788,'1','208','1038',479,'Retail Sale Id 1643964',1698.32,0.00,0.00,2.99,152.49,'2022-02-13 14:31:19','',''),(2652789,'1','208','1038',479,'Retail Sale Id 1643965',2999.04,0.00,0.00,5.28,269.28,'2022-02-13 14:44:48','',''),(2652790,'1','208','1038',479,'Retail Sale Id 1643965',6997.76,0.00,0.00,12.32,628.32,'2022-02-13 14:44:48','',''),(2652791,'1','208','1038',479,'Retail Sale Id 1643966',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 14:48:18','',''),(2652792,'1','208','1038',479,'Retail Sale Id 1643967',2840.00,0.00,0.00,5.00,255.00,'2022-02-13 14:50:05','',''),(2652793,'1','208','1038',479,'Retail Sale Id 1643967',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 14:50:05','',''),(2652794,'1','208','1038',479,'Retail Sale Id 1643968',6497.92,0.00,0.00,11.44,583.44,'2022-02-13 14:51:33','',''),(2652795,'1','208','1038',479,'Retail Sale Id 1643969',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 15:00:32','',''),(2652796,'1','208','1038',479,'Retail Sale Id 1643970',1698.32,0.00,0.00,2.99,152.49,'2022-02-13 15:27:46','',''),(2652797,'1','208','1038',479,'Retail Sale Id 1643971',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 15:28:27','',''),(2652798,'1','208','1038',479,'Retail Sale Id 1643972',1698.32,0.00,0.00,2.99,152.49,'2022-02-13 15:30:26','',''),(2652799,'1','208','1038',479,'Retail Sale Id 1643973',1397.28,0.00,0.00,2.46,125.46,'2022-02-13 15:32:05','',''),(2652800,'1','208','1038',479,'Retail Sale Id 1643974',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 15:43:47','',''),(2652801,'1','208','1038',479,'Retail Sale Id 1643975',7997.44,0.00,0.00,14.08,718.08,'2022-02-13 15:49:14','',''),(2652802,'1','208','1038',479,'Retail Sale Id 1643976',2840.00,0.00,0.00,5.00,255.00,'2022-02-13 15:50:30','',''),(2652803,'1','208','1038',479,'Retail Sale Id 1643977',5998.08,0.00,0.00,10.56,538.56,'2022-02-13 15:54:48','',''),(2652804,'1','208','1038',479,'Retail Sale Id 1643978',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 15:57:12','',''),(2652805,'1','208','1038',479,'Retail Sale Id 1643979',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 16:11:32','',''),(2652806,'1','208','1038',479,'Retail Sale Id 1643980',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 16:39:23','',''),(2652807,'1','208','1038',479,'Retail Sale Id 1643981',602.08,0.00,0.00,1.06,54.06,'2022-02-13 16:52:31','',''),(2652808,'1','208','1038',479,'Retail Sale Id 1643982',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 16:53:53','',''),(2652809,'1','208','1038',479,'Retail Sale Id 1643983',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 17:01:09','',''),(2652810,'1','208','1038',479,'Retail Sale Id 1643984',499.84,0.00,0.00,0.88,44.88,'2022-02-13 17:02:34','',''),(2652811,'1','208','1038',479,'Retail Sale Id 1643985',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 17:04:46','',''),(2652812,'1','208','1038',479,'Retail Sale Id 1643986',2840.00,0.00,0.00,5.00,255.00,'2022-02-13 17:06:16','',''),(2652813,'1','208','1038',479,'Retail Sale Id 1643987',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 17:11:48','',''),(2652814,'1','208','1038',479,'Retail Sale Id 1643988',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 17:12:47','',''),(2652815,'1','208','1038',479,'Retail Sale Id 1643989',2840.00,0.00,0.00,5.00,255.00,'2022-02-13 17:13:40','',''),(2652816,'1','208','1038',479,'Retail Sale Id 1643990',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 17:14:39','',''),(2652817,'1','208','1038',479,'Retail Sale Id 1643991',1709.68,0.00,0.00,3.01,153.51,'2022-02-13 17:16:26','',''),(2652818,'1','208','1038',479,'Retail Sale Id 1643992',1499.52,0.00,0.00,2.64,134.64,'2022-02-13 17:18:05','',''),(2652819,'1','208','1038',479,'Retail Sale Id 1643993',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 17:27:14','',''),(2652820,'1','208','1038',479,'Retail Sale Id 1643994',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 17:32:14','',''),(2652821,'1','208','1038',479,'Retail Sale Id 1643995',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 17:33:37','',''),(2652822,'1','208','1038',479,'Retail Sale Id 1643996',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 17:38:04','',''),(2652823,'1','208','1038',479,'Retail Sale Id 1643997',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 17:41:05','',''),(2652824,'1','208','1038',479,'Retail Sale Id 1643998',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 17:51:06','',''),(2652825,'1','208','1038',479,'Retail Sale Id 1643999',999.68,0.00,0.00,1.76,89.76,'2022-02-13 17:53:22','',''),(2652826,'1','208','1038',479,'Retail Sale Id 1644000',1709.68,0.00,0.00,3.01,153.51,'2022-02-13 18:04:53','',''),(2652827,'1','208','1038',479,'Retail Sale Id 1644000',1709.68,0.00,0.00,3.01,153.51,'2022-02-13 18:04:53','',''),(2652828,'1','208','1038',479,'Retail Sale Id 1644001',2999.04,0.00,0.00,5.28,269.28,'2022-02-13 18:06:31','',''),(2652829,'1','208','1038',479,'Retail Sale Id 1644002',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 18:07:19','',''),(2652830,'1','208','1038',479,'Retail Sale Id 1644003',3498.88,0.00,0.00,6.16,314.16,'2022-02-13 18:08:54','',''),(2652831,'1','208','1038',479,'Retail Sale Id 1644004',698.64,0.00,0.00,1.23,62.73,'2022-02-13 18:09:45','',''),(2652832,'1','208','1038',479,'Retail Sale Id 1644005',6816.00,0.00,0.00,12.00,612.00,'2022-02-13 18:11:09','',''),(2652833,'1','208','1038',479,'Retail Sale Id 1644006',3402.32,0.00,0.00,5.99,305.49,'2022-02-13 18:12:54','',''),(2652834,'1','208','1038',479,'Retail Sale Id 1644007',3447.76,0.00,0.00,6.07,309.57,'2022-02-13 18:13:43','',''),(2652835,'1','208','1038',479,'Retail Sale Id 1644008',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 18:16:34','',''),(2652836,'1','208','1038',479,'Retail Sale Id 1644009',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 18:18:33','',''),(2652837,'1','208','1038',479,'Retail Sale Id 1644010',698.64,0.00,0.00,1.23,62.73,'2022-02-13 18:20:57','',''),(2652838,'1','208','1038',479,'Retail Sale Id 1644011',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 18:22:47','',''),(2652839,'1','208','1038',479,'Retail Sale Id 1644012',7100.00,0.00,0.00,12.50,637.50,'2022-02-13 18:23:42','',''),(2652840,'1','208','1038',479,'Retail Sale Id 1644013',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 19:07:21','',''),(2652841,'1','208','1038',479,'Retail Sale Id 1644013',1999.36,0.00,0.00,3.52,179.52,'2022-02-13 19:07:21','',''),(2652842,'1','208','1038',479,'Retail Sale Id 1644014',1499.52,0.00,0.00,2.64,134.64,'2022-02-13 19:24:30','',''),(2652843,'1','208','1038',479,'Retail Sale Id 1644015',3408.00,0.00,0.00,6.00,306.00,'2022-02-13 19:26:14','',''),(2652844,'1','208','1038',479,'Retail Sale Id 1644016',6100.32,0.00,0.00,10.74,547.74,'2022-02-13 22:44:50','',''),(2652845,'1','208','1038',479,'Retail Sale Id 1644017',14949.76,0.00,0.00,26.32,1342.32,'2022-02-13 22:46:13','',''),(2652846,'1','208','1038',479,'Retail Sale Id 1644019',7134.08,0.00,0.00,12.56,640.56,'2022-02-13 22:47:41','',''),(2652847,'1','208','1038',479,'Retail Sale Id 1644020',17698.88,0.00,0.00,31.16,1589.16,'2022-02-13 22:48:54','',''),(2652848,'1','208','1038',479,'Retail Sale Id 1644021',613.44,0.00,0.00,1.08,55.08,'2022-02-13 22:53:31','',''),(2652849,'1','208','1038',479,'Retail Sale Id 1644022',5.68,0.00,0.00,0.01,0.51,'2022-02-13 23:00:55','',''),(2652850,'1','208','1038',479,'Retail Sale Id 1644023',2840.00,0.00,0.00,5.00,255.00,'2022-02-14 08:00:14','',''),(2652851,'1','208','1038',479,'Retail Sale Id 1644024',6997.76,0.00,0.00,12.32,628.32,'2022-02-14 08:02:01','',''),(2652852,'1','208','1038',479,'Retail Sale Id 1644026',1709.68,0.00,0.00,3.01,153.51,'2022-02-14 08:04:23','',''),(2652853,'1','208','1038',479,'Retail Sale Id 1644027',999.68,0.00,0.00,1.76,89.76,'2022-02-14 08:07:41','',''),(2652854,'1','208','1038',479,'Retail Sale Id 1644027',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 08:07:41','',''),(2652855,'1','208','1038',479,'Retail Sale Id 1644028',3498.88,0.00,0.00,6.16,314.16,'2022-02-14 08:08:29','',''),(2652856,'1','208','1038',479,'Retail Sale Id 1644029',12501.68,0.00,0.00,22.01,1122.51,'2022-02-14 08:12:50','',''),(2652857,'1','208','1038',479,'Retail Sale Id 1644030',6997.76,0.00,0.00,12.32,628.32,'2022-02-14 08:13:44','',''),(2652858,'1','208','1038',479,'Retail Sale Id 1644031',2999.04,0.00,0.00,5.28,269.28,'2022-02-14 08:14:48','',''),(2652859,'1','208','1038',479,'Retail Sale Id 1644032',2999.04,0.00,0.00,5.28,269.28,'2022-02-14 08:15:53','',''),(2652860,'1','208','1038',479,'Retail Sale Id 1644032',2999.04,0.00,0.00,5.28,269.28,'2022-02-14 08:15:53','',''),(2652861,'1','208','1038',479,'Retail Sale Id 1644033',3498.88,0.00,0.00,6.16,314.16,'2022-02-14 08:16:55','',''),(2652862,'1','208','1038',479,'Retail Sale Id 1644034',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 08:17:38','',''),(2652863,'1','208','1038',479,'Retail Sale Id 1644035',3498.88,0.00,0.00,6.16,314.16,'2022-02-14 08:21:30','',''),(2652864,'1','208','1038',479,'Retail Sale Id 1644036',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 08:22:30','',''),(2652865,'1','208','1038',479,'Retail Sale Id 1644037',7497.60,0.00,0.00,13.20,673.20,'2022-02-14 08:28:01','',''),(2652866,'1','208','1038',479,'Retail Sale Id 1644038',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 08:42:54','',''),(2652867,'1','208','1038',479,'Retail Sale Id 1644039',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 08:49:55','',''),(2652868,'1','208','1038',479,'Retail Sale Id 1644040',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 08:58:27','',''),(2652869,'1','208','1038',479,'Retail Sale Id 1644041',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 09:02:02','',''),(2652870,'1','208','1038',479,'Retail Sale Id 1644042',1698.32,0.00,0.00,2.99,152.49,'2022-02-14 09:12:31','',''),(2652871,'1','208','1038',479,'Retail Sale Id 1644043',3998.72,0.00,0.00,7.04,359.04,'2022-02-14 09:25:00','',''),(2652872,'1','208','1038',479,'Retail Sale Id 1644044',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 09:40:08','',''),(2652873,'1','208','1038',479,'Retail Sale Id 1644045',2999.04,0.00,0.00,5.28,269.28,'2022-02-14 09:53:51','',''),(2652874,'1','208','1038',479,'Retail Sale Id 1644046',499.84,0.00,0.00,0.88,44.88,'2022-02-14 09:56:36','',''),(2652875,'1','208','1038',479,'Retail Sale Id 1644047',2800.24,0.00,0.00,4.93,251.43,'2022-02-14 09:59:03','',''),(2652876,'1','208','1038',479,'Retail Sale Id 1644048',1499.52,0.00,0.00,2.64,134.64,'2022-02-14 10:00:14','',''),(2652877,'1','208','1038',479,'Retail Sale Id 1644049',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 10:02:35','',''),(2652878,'1','208','1038',479,'Retail Sale Id 1644050',1800.56,0.00,0.00,3.17,161.67,'2022-02-14 10:03:37','',''),(2652879,'1','208','1038',479,'Retail Sale Id 1644051',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 10:04:22','',''),(2652880,'1','208','1038',479,'Retail Sale Id 1644052',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 10:06:57','',''),(2652881,'1','208','1038',479,'Retail Sale Id 1644052',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 10:06:57','',''),(2652882,'1','208','1038',479,'Retail Sale Id 1644053',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 10:08:35','',''),(2652883,'1','208','1038',479,'Retail Sale Id 1644053',8520.00,0.00,0.00,15.00,765.00,'2022-02-14 10:08:35','',''),(2652884,'1','208','1038',479,'Retail Sale Id 1644054',3498.88,0.00,0.00,6.16,314.16,'2022-02-14 10:20:42','',''),(2652885,'1','208','1038',479,'Retail Sale Id 1644055',2840.00,0.00,0.00,5.00,255.00,'2022-02-14 10:21:54','',''),(2652886,'1','208','1038',479,'Retail Sale Id 1644056',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 10:25:55','',''),(2652887,'1','208','1038',479,'Retail Sale Id 1644057',28400.00,0.00,0.00,50.00,2550.00,'2022-02-14 10:29:29','',''),(2652888,'1','208','1038',479,'Retail Sale Id 1644058',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 10:30:14','',''),(2652889,'1','208','1038',479,'Retail Sale Id 1644059',3498.88,0.00,0.00,6.16,314.16,'2022-02-14 10:32:44','',''),(2652890,'1','208','1038',479,'Retail Sale Id 1644060',2999.04,0.00,0.00,5.28,269.28,'2022-02-14 10:40:24','',''),(2652891,'1','208','1038',479,'Retail Sale Id 1644061',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 10:47:10','',''),(2652892,'1','208','1038',479,'Retail Sale Id 1644062',602.08,0.00,0.00,1.06,54.06,'2022-02-14 10:48:25','',''),(2652893,'1','208','1038',479,'Retail Sale Id 1644063',1709.68,0.00,0.00,3.01,153.51,'2022-02-14 10:50:44','',''),(2652894,'1','208','1038',479,'Retail Sale Id 1644063',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 10:50:44','',''),(2652895,'1','208','1038',479,'Retail Sale Id 1644064',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 10:51:50','',''),(2652896,'1','208','1038',479,'Retail Sale Id 1644065',2999.04,0.00,0.00,5.28,269.28,'2022-02-14 10:54:06','',''),(2652897,'1','208','1038',479,'Retail Sale Id 1644066',499.84,0.00,0.00,0.88,44.88,'2022-02-14 10:55:24','',''),(2652898,'1','208','1038',479,'Retail Sale Id 1644067',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 10:58:53','',''),(2652899,'1','208','1038',479,'Retail Sale Id 1644068',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 11:07:02','',''),(2652900,'1','208','1038',479,'Retail Sale Id 1644069',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 11:07:55','',''),(2652901,'1','208','1038',479,'Retail Sale Id 1644070',2840.00,0.00,0.00,5.00,255.00,'2022-02-14 13:04:53','',''),(2652902,'1','208','1038',479,'Retail Sale Id 1644071',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 13:07:24','',''),(2652903,'1','208','1038',479,'Retail Sale Id 1644072',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 13:12:16','',''),(2652904,'1','208','1038',479,'Retail Sale Id 1644073',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 13:13:03','',''),(2652905,'1','208','1038',479,'Retail Sale Id 1644075',1709.68,0.00,0.00,3.01,153.51,'2022-02-14 13:17:27','',''),(2652906,'1','208','1038',479,'Retail Sale Id 1644076',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 13:18:29','',''),(2652907,'1','208','1038',479,'Retail Sale Id 1644077',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 13:24:34','',''),(2652908,'1','208','1038',479,'Retail Sale Id 1644078',1698.32,0.00,0.00,2.99,152.49,'2022-02-14 13:28:31','',''),(2652909,'1','208','1038',479,'Retail Sale Id 1644079',6997.76,0.00,0.00,12.32,628.32,'2022-02-14 13:54:47','',''),(2652910,'1','208','1038',479,'Retail Sale Id 1644079',6997.76,0.00,0.00,12.32,628.32,'2022-02-14 13:54:47','',''),(2652911,'1','208','1038',479,'Retail Sale Id 1644080',3998.72,0.00,0.00,7.04,359.04,'2022-02-14 14:06:00','',''),(2652912,'1','208','1038',479,'Retail Sale Id 1644081',3498.88,0.00,0.00,6.16,314.16,'2022-02-14 14:12:53','',''),(2652913,'1','208','1038',479,'Retail Sale Id 1644083',3998.72,0.00,0.00,7.04,359.04,'2022-02-14 14:13:35','',''),(2652914,'1','208','1038',479,'Retail Sale Id 1644084',999.68,0.00,0.00,1.76,89.76,'2022-02-14 14:14:11','',''),(2652915,'1','208','1038',479,'Retail Sale Id 1644085',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 14:15:12','',''),(2652916,'1','208','1038',479,'Retail Sale Id 1644086',3498.88,0.00,0.00,6.16,314.16,'2022-02-14 14:16:02','',''),(2652917,'1','208','1038',479,'Retail Sale Id 1644087',3498.88,0.00,0.00,6.16,314.16,'2022-02-14 14:21:16','',''),(2652918,'1','208','1038',479,'Retail Sale Id 1644088',3998.72,0.00,0.00,7.04,359.04,'2022-02-14 14:27:42','',''),(2652919,'1','208','1038',479,'Retail Sale Id 1644089',1721.04,0.00,0.00,3.03,154.53,'2022-02-14 14:42:51','',''),(2652920,'1','208','1038',479,'Retail Sale Id 1644090',1709.68,0.00,0.00,3.01,153.51,'2022-02-14 14:47:26','',''),(2652921,'1','208','1038',479,'Retail Sale Id 1644091',3998.72,0.00,0.00,7.04,359.04,'2022-02-14 14:51:12','',''),(2652922,'1','208','1038',479,'Retail Sale Id 1644092',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 15:08:59','',''),(2652923,'1','208','1038',479,'Retail Sale Id 1644093',3300.08,0.00,0.00,5.81,296.31,'2022-02-14 15:19:04','',''),(2652924,'1','208','1038',479,'Retail Sale Id 1644094',602.08,0.00,0.00,1.06,54.06,'2022-02-14 15:25:46','',''),(2652925,'1','208','1038',479,'Retail Sale Id 1644095',6997.76,0.00,0.00,12.32,628.32,'2022-02-14 15:26:53','',''),(2652926,'1','208','1038',479,'Retail Sale Id 1644096',1499.52,0.00,0.00,2.64,134.64,'2022-02-14 15:29:27','',''),(2652927,'1','208','1038',479,'Retail Sale Id 1644097',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 15:34:32','',''),(2652928,'1','208','1038',479,'Retail Sale Id 1644098',1709.68,0.00,0.00,3.01,153.51,'2022-02-14 15:35:43','',''),(2652929,'1','208','1038',479,'Retail Sale Id 1644099',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 15:54:49','',''),(2652930,'1','208','1038',479,'Retail Sale Id 1644100',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 15:56:20','',''),(2652931,'1','208','1038',479,'Retail Sale Id 1644101',1709.68,0.00,0.00,3.01,153.51,'2022-02-14 16:07:08','',''),(2652932,'1','208','1038',479,'Retail Sale Id 1644102',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 16:08:09','',''),(2652933,'1','208','1038',479,'Retail Sale Id 1644103',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 16:10:38','',''),(2652934,'1','208','1038',479,'Retail Sale Id 1644104',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 16:31:48','',''),(2652935,'1','208','1038',479,'Retail Sale Id 1644105',1499.52,0.00,0.00,2.64,134.64,'2022-02-14 16:45:31','',''),(2652936,'1','208','1038',479,'Retail Sale Id 1644106',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 16:48:54','',''),(2652937,'1','208','1038',479,'Retail Sale Id 1644107',6997.76,0.00,0.00,12.32,628.32,'2022-02-14 16:50:07','',''),(2652938,'1','208','1038',479,'Retail Sale Id 1644108',3447.76,0.00,0.00,6.07,309.57,'2022-02-14 16:54:33','',''),(2652939,'1','208','1038',479,'Retail Sale Id 1644109',999.68,0.00,0.00,1.76,89.76,'2022-02-14 17:00:53','',''),(2652940,'1','208','1038',479,'Retail Sale Id 1644110',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 17:02:15','',''),(2652941,'1','208','1038',479,'Retail Sale Id 1644111',999.68,0.00,0.00,1.76,89.76,'2022-02-14 17:13:01','',''),(2652942,'1','208','1038',479,'Retail Sale Id 1644112',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 17:13:53','',''),(2652943,'1','208','1038',479,'Retail Sale Id 1644113',4498.56,0.00,0.00,7.92,403.92,'2022-02-14 17:14:33','',''),(2652944,'1','208','1038',479,'Retail Sale Id 1644114',999.68,0.00,0.00,1.76,89.76,'2022-02-14 17:20:14','',''),(2652945,'1','208','1038',479,'Retail Sale Id 1644115',499.84,0.00,0.00,0.88,44.88,'2022-02-14 17:23:37','',''),(2652946,'1','208','1038',479,'Retail Sale Id 1644116',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 17:31:03','',''),(2652947,'1','208','1038',479,'Retail Sale Id 1644117',1499.52,0.00,0.00,2.64,134.64,'2022-02-14 17:32:41','',''),(2652948,'1','208','1038',479,'Retail Sale Id 1644118',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 17:33:41','',''),(2652949,'1','208','1038',479,'Retail Sale Id 1644119',1499.52,0.00,0.00,2.64,134.64,'2022-02-14 17:34:43','',''),(2652950,'1','208','1038',479,'Retail Sale Id 1644120',999.68,0.00,0.00,1.76,89.76,'2022-02-14 17:36:00','',''),(2652951,'1','208','1038',479,'Retail Sale Id 1644121',7497.60,0.00,0.00,13.20,673.20,'2022-02-14 17:40:03','',''),(2652952,'1','208','1038',479,'Retail Sale Id 1644122',1709.68,0.00,0.00,3.01,153.51,'2022-02-14 17:52:11','',''),(2652953,'1','208','1038',479,'Retail Sale Id 1644123',14200.00,0.00,0.00,25.00,1275.00,'2022-02-14 18:02:10','',''),(2652954,'1','208','1038',479,'Retail Sale Id 1644124',5702.72,0.00,0.00,10.04,512.04,'2022-02-14 18:27:53','',''),(2652955,'1','208','1038',479,'Retail Sale Id 1644125',2499.20,0.00,0.00,4.40,224.40,'2022-02-14 18:28:57','',''),(2652956,'1','208','1038',479,'Retail Sale Id 1644126',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 18:30:04','',''),(2652957,'1','208','1038',479,'Retail Sale Id 1644127',999.68,0.00,0.00,1.76,89.76,'2022-02-14 18:34:34','',''),(2652958,'1','208','1038',479,'Retail Sale Id 1644128',7100.00,0.00,0.00,12.50,637.50,'2022-02-14 18:35:53','',''),(2652959,'1','208','1038',479,'Retail Sale Id 1644129',3498.88,0.00,0.00,6.16,314.16,'2022-02-14 18:47:43','',''),(2652960,'1','208','1038',479,'Retail Sale Id 1644130',3402.32,0.00,0.00,5.99,305.49,'2022-02-14 18:52:25','',''),(2652961,'1','208','1038',479,'Retail Sale Id 1644131',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 19:19:39','',''),(2652962,'1','208','1038',479,'Retail Sale Id 1644132',3498.88,0.00,0.00,6.16,314.16,'2022-02-14 19:21:49','',''),(2652963,'1','208','1038',479,'Retail Sale Id 1644133',2499.20,0.00,0.00,4.40,224.40,'2022-02-14 19:33:11','',''),(2652964,'1','208','1038',479,'Return of Retail Sale Id 1644128',0.00,7100.00,12.50,0.00,-637.50,'2022-02-14 20:39:08','',''),(2652965,'1','208','1038',479,'Return of Retail Sale Id 1644116',0.00,7100.00,12.50,0.00,-637.50,'2022-02-14 20:40:12','',''),(2652966,'1','208','1038',479,'Retail Sale Id 1644134',47706.32,0.00,0.00,83.99,4283.49,'2022-02-14 20:46:37','',''),(2652967,'1','208','1038',479,'Retail Sale Id 1644135',29962.00,0.00,0.00,52.75,2690.25,'2022-02-14 20:47:48','',''),(2652968,'1','208','1038',479,'Retail Sale Id 1644136',5197.20,0.00,0.00,9.15,466.65,'2022-02-14 20:49:04','',''),(2652969,'1','208','1038',479,'Retail Sale Id 1644137',18800.80,0.00,0.00,33.10,1688.10,'2022-02-14 20:50:12','',''),(2652970,'1','208','1038',479,'Retail Sale Id 1644138',3498.88,0.00,0.00,6.16,314.16,'2022-02-15 07:44:27','',''),(2652971,'1','208','1038',479,'Retail Sale Id 1644139',5998.08,0.00,0.00,10.56,538.56,'2022-02-15 07:47:30','',''),(2652972,'1','208','1038',479,'Retail Sale Id 1644140',3998.72,0.00,0.00,7.04,359.04,'2022-02-15 07:49:36','',''),(2652973,'1','208','1038',479,'Retail Sale Id 1644141',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 07:56:34','',''),(2652974,'1','208','1038',479,'Retail Sale Id 1644142',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 07:59:03','',''),(2652975,'1','208','1038',479,'Retail Sale Id 1644143',1698.32,0.00,0.00,2.99,152.49,'2022-02-15 08:01:05','',''),(2652976,'1','208','1038',479,'Retail Sale Id 1644144',2840.00,0.00,0.00,5.00,255.00,'2022-02-15 08:03:22','',''),(2652977,'1','208','1038',479,'Retail Sale Id 1644144',3408.00,0.00,0.00,6.00,306.00,'2022-02-15 08:03:22','',''),(2652978,'1','208','1038',479,'Retail Sale Id 1644145',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 08:05:01','',''),(2652979,'1','208','1038',479,'Retail Sale Id 1644147',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 08:10:47','',''),(2652980,'1','208','1038',479,'Retail Sale Id 1644148',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 08:24:44','',''),(2652981,'1','208','1038',479,'Retail Sale Id 1644149',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 08:26:13','',''),(2652982,'1','208','1038',479,'Retail Sale Id 1644150',3447.76,0.00,0.00,6.07,309.57,'2022-02-15 08:29:35','',''),(2652983,'1','208','1038',479,'Retail Sale Id 1644151',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 08:31:03','',''),(2652984,'1','208','1038',479,'Retail Sale Id 1644152',3498.88,0.00,0.00,6.16,314.16,'2022-02-15 08:34:02','',''),(2652985,'1','208','1038',479,'Retail Sale Id 1644153',3408.00,0.00,0.00,6.00,306.00,'2022-02-15 08:36:00','',''),(2652986,'1','208','1038',479,'Retail Sale Id 1644154',1601.76,0.00,0.00,2.82,143.82,'2022-02-15 08:37:40','',''),(2652987,'1','208','1038',479,'Retail Sale Id 1644155',1499.52,0.00,0.00,2.64,134.64,'2022-02-15 08:40:01','',''),(2652988,'1','208','1038',479,'Retail Sale Id 1644155',2499.20,0.00,0.00,4.40,224.40,'2022-02-15 08:40:01','',''),(2652989,'1','208','1038',479,'Retail Sale Id 1644156',3408.00,0.00,0.00,6.00,306.00,'2022-02-15 08:50:01','',''),(2652990,'1','208','1038',479,'Retail Sale Id 1644157',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 08:51:21','',''),(2652991,'1','208','1038',479,'Retail Sale Id 1644158',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 08:54:03','',''),(2652992,'1','208','1038',479,'Retail Sale Id 1644159',3408.00,0.00,0.00,6.00,306.00,'2022-02-15 08:57:16','',''),(2652993,'1','208','1038',479,'Retail Sale Id 1644160',1198.48,0.00,0.00,2.11,107.61,'2022-02-15 09:05:03','',''),(2652994,'1','208','1038',479,'Retail Sale Id 1644161',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 09:11:45','',''),(2652995,'1','208','1038',479,'Retail Sale Id 1644162',1999.36,0.00,0.00,3.52,179.52,'2022-02-15 09:19:37','',''),(2652996,'1','208','1038',479,'Retail Sale Id 1644163',5998.08,0.00,0.00,10.56,538.56,'2022-02-15 09:32:07','',''),(2652997,'1','208','1038',479,'Retail Sale Id 1644164',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 09:33:17','',''),(2652998,'1','208','1038',479,'Retail Sale Id 1644165',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 09:40:27','',''),(2652999,'1','208','1038',479,'Retail Sale Id 1644166',2828.64,0.00,0.00,4.98,253.98,'2022-02-15 09:46:46','',''),(2653000,'1','208','1038',479,'Retail Sale Id 1644167',3408.00,0.00,0.00,6.00,306.00,'2022-02-15 09:56:54','',''),(2653001,'1','208','1038',479,'Retail Sale Id 1644168',3498.88,0.00,0.00,6.16,314.16,'2022-02-15 10:07:25','',''),(2653002,'1','208','1038',479,'Retail Sale Id 1644169',1499.52,0.00,0.00,2.64,134.64,'2022-02-15 10:14:14','',''),(2653003,'1','208','1038',479,'Retail Sale Id 1644170',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 10:15:11','',''),(2653004,'1','208','1038',479,'Retail Sale Id 1644171',5702.72,0.00,0.00,10.04,512.04,'2022-02-15 10:16:31','',''),(2653005,'1','208','1038',479,'Retail Sale Id 1644172',2840.00,0.00,0.00,5.00,255.00,'2022-02-15 10:17:34','',''),(2653006,'1','208','1038',479,'Retail Sale Id 1644173',1704.00,0.00,0.00,3.00,153.00,'2022-02-15 10:19:14','',''),(2653007,'1','208','1038',479,'Retail Sale Id 1644174',1999.36,0.00,0.00,3.52,179.52,'2022-02-15 10:21:37','',''),(2653008,'1','208','1038',479,'Retail Sale Id 1644175',499.84,0.00,0.00,0.88,44.88,'2022-02-15 10:24:36','',''),(2653009,'1','208','1038',479,'Retail Sale Id 1644176',1499.52,0.00,0.00,2.64,134.64,'2022-02-15 10:40:45','',''),(2653010,'1','208','1038',479,'Retail Sale Id 1644177',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 10:45:10','',''),(2653011,'1','208','1038',479,'Retail Sale Id 1644178',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 10:49:01','',''),(2653012,'1','208','1038',479,'Retail Sale Id 1644179',2499.20,0.00,0.00,4.40,224.40,'2022-02-15 10:54:42','',''),(2653013,'1','208','1038',479,'Retail Sale Id 1644180',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 10:55:47','',''),(2653014,'1','208','1038',479,'Retail Sale Id 1644181',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 11:01:08','',''),(2653015,'1','208','1038',479,'Retail Sale Id 1644182',1709.68,0.00,0.00,3.01,153.51,'2022-02-15 11:05:17','',''),(2653016,'1','208','1038',479,'Retail Sale Id 1644183',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 11:07:18','',''),(2653017,'1','208','1038',479,'Retail Sale Id 1644184',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 12:43:14','',''),(2653018,'1','208','1038',479,'Retail Sale Id 1644184',4998.40,0.00,0.00,8.80,448.80,'2022-02-15 12:43:14','',''),(2653019,'1','208','1038',479,'Retail Sale Id 1644185',2851.36,0.00,0.00,5.02,256.02,'2022-02-15 12:45:31','',''),(2653020,'1','208','1038',479,'Retail Sale Id 1644186',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 12:46:29','',''),(2653021,'1','208','1038',479,'Retail Sale Id 1644187',2851.36,0.00,0.00,5.02,256.02,'2022-02-15 12:57:08','',''),(2653022,'1','208','1038',479,'Retail Sale Id 1644188',3408.00,0.00,0.00,6.00,306.00,'2022-02-15 13:05:47','',''),(2653023,'1','208','1038',479,'Retail Sale Id 1644188',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 13:05:47','',''),(2653024,'1','208','1038',479,'Retail Sale Id 1644188',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 13:05:47','',''),(2653025,'1','208','1038',479,'Retail Sale Id 1644189',1709.68,0.00,0.00,3.01,153.51,'2022-02-15 13:17:13','',''),(2653026,'1','208','1038',479,'Retail Sale Id 1644190',1709.68,0.00,0.00,3.01,153.51,'2022-02-15 13:18:10','',''),(2653027,'1','208','1038',479,'Retail Sale Id 1644191',3998.72,0.00,0.00,7.04,359.04,'2022-02-15 13:28:48','',''),(2653028,'1','208','1038',479,'Retail Sale Id 1644192',3498.88,0.00,0.00,6.16,314.16,'2022-02-15 13:31:28','',''),(2653029,'1','208','1038',479,'Retail Sale Id 1644193',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 13:32:59','',''),(2653030,'1','208','1038',479,'Retail Sale Id 1644194',999.68,0.00,0.00,1.76,89.76,'2022-02-15 13:41:38','',''),(2653031,'1','208','1038',479,'Retail Sale Id 1644195',1721.04,0.00,0.00,3.03,154.53,'2022-02-15 13:50:01','',''),(2653032,'1','208','1038',479,'Retail Sale Id 1644196',4998.40,0.00,0.00,8.80,448.80,'2022-02-15 13:56:46','',''),(2653033,'1','208','1038',479,'Retail Sale Id 1644197',1999.36,0.00,0.00,3.52,179.52,'2022-02-15 14:03:26','',''),(2653034,'1','208','1038',479,'Retail Sale Id 1644198',2840.00,0.00,0.00,5.00,255.00,'2022-02-15 14:35:45','',''),(2653035,'1','208','1038',479,'Retail Sale Id 1644199',1999.36,0.00,0.00,3.52,179.52,'2022-02-15 14:36:33','',''),(2653036,'1','208','1038',479,'Retail Sale Id 1644200',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 14:43:38','',''),(2653037,'1','208','1038',479,'Retail Sale Id 1644201',1499.52,0.00,0.00,2.64,134.64,'2022-02-15 14:45:38','',''),(2653038,'1','208','1038',479,'Retail Sale Id 1644202',1999.36,0.00,0.00,3.52,179.52,'2022-02-15 14:48:28','',''),(2653039,'1','208','1038',479,'Retail Sale Id 1644202',1999.36,0.00,0.00,3.52,179.52,'2022-02-15 14:48:28','',''),(2653040,'1','208','1038',479,'Retail Sale Id 1644203',1709.68,0.00,0.00,3.01,153.51,'2022-02-15 14:57:55','',''),(2653041,'1','208','1038',479,'Retail Sale Id 1644204',1198.48,0.00,0.00,2.11,107.61,'2022-02-15 14:58:45','',''),(2653042,'1','208','1038',479,'Retail Sale Id 1644205',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 15:35:31','',''),(2653043,'1','208','1038',479,'Retail Sale Id 1644206',6997.76,0.00,0.00,12.32,628.32,'2022-02-15 15:49:27','',''),(2653044,'1','208','1038',479,'Retail Sale Id 1644207',499.84,0.00,0.00,0.88,44.88,'2022-02-15 15:51:26','',''),(2653045,'1','208','1038',479,'Retail Sale Id 1644208',1499.52,0.00,0.00,2.64,134.64,'2022-02-15 16:00:05','',''),(2653046,'1','208','1038',479,'Retail Sale Id 1644209',999.68,0.00,0.00,1.76,89.76,'2022-02-15 16:00:55','',''),(2653047,'1','208','1038',479,'Retail Sale Id 1644210',1136.00,0.00,0.00,2.00,102.00,'2022-02-15 16:06:38','',''),(2653048,'1','208','1038',479,'Retail Sale Id 1644211',999.68,0.00,0.00,1.76,89.76,'2022-02-15 16:09:16','',''),(2653049,'1','208','1038',479,'Retail Sale Id 1644212',3402.32,0.00,0.00,5.99,305.49,'2022-02-15 16:15:30','',''),(2653050,'1','208','1038',479,'Retail Sale Id 1644213',2272.00,0.00,0.00,4.00,204.00,'2022-02-15 16:18:59','',''),(2653051,'1','208','1038',479,'Retail Sale Id 1644215',568.00,0.00,0.00,1.00,51.00,'2022-02-15 16:24:12','',''),(2653052,'1','208','1038',479,'Retail Sale Id 1644215',1704.00,0.00,0.00,3.00,153.00,'2022-02-15 16:24:12','',''),(2653053,'1','208','1038',479,'Retail Sale Id 1644216',1136.00,0.00,0.00,2.00,102.00,'2022-02-15 16:25:35','',''),(2653054,'1','208','1038',479,'Retail Sale Id 1644217',3402.32,0.00,0.00,5.99,305.49,'2022-02-15 16:28:34','',''),(2653055,'1','208','1038',479,'Retail Sale Id 1644218',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 16:34:57','',''),(2653056,'1','208','1038',479,'Retail Sale Id 1644218',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 16:34:57','',''),(2653057,'1','208','1038',479,'Retail Sale Id 1644219',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 16:36:31','',''),(2653058,'1','208','1038',479,'Retail Sale Id 1644220',2999.04,0.00,0.00,5.28,269.28,'2022-02-15 16:38:39','',''),(2653059,'1','208','1038',479,'Retail Sale Id 1644221',6997.76,0.00,0.00,12.32,628.32,'2022-02-15 16:41:20','',''),(2653060,'1','208','1038',479,'Retail Sale Id 1644222',3697.68,0.00,0.00,6.51,332.01,'2022-02-15 16:45:02','',''),(2653061,'1','208','1038',479,'Retail Sale Id 1644223',6997.76,0.00,0.00,12.32,628.32,'2022-02-15 16:46:16','',''),(2653062,'1','208','1038',479,'Retail Sale Id 1644224',27002.72,0.00,0.00,47.54,2424.54,'2022-02-15 16:49:41','',''),(2653063,'1','208','1038',479,'Retail Sale Id 1644225',1198.48,0.00,0.00,2.11,107.61,'2022-02-15 16:50:51','',''),(2653064,'1','208','1038',479,'Retail Sale Id 1644226',1499.52,0.00,0.00,2.64,134.64,'2022-02-15 16:53:30','',''),(2653065,'1','208','1038',479,'Retail Sale Id 1644227',1147.36,0.00,0.00,2.02,103.02,'2022-02-15 16:54:51','',''),(2653066,'1','208','1038',479,'Retail Sale Id 1644228',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 17:02:39','',''),(2653067,'1','208','1038',479,'Retail Sale Id 1644229',2851.36,0.00,0.00,5.02,256.02,'2022-02-15 17:06:51','',''),(2653068,'1','208','1038',479,'Retail Sale Id 1644230',3402.32,0.00,0.00,5.99,305.49,'2022-02-15 17:09:17','',''),(2653069,'1','208','1038',479,'Retail Sale Id 1644230',3402.32,0.00,0.00,5.99,305.49,'2022-02-15 17:09:17','',''),(2653070,'1','208','1038',479,'Retail Sale Id 1644230',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 17:09:17','',''),(2653071,'1','208','1038',479,'Retail Sale Id 1644231',1698.32,0.00,0.00,2.99,152.49,'2022-02-15 17:10:23','',''),(2653072,'1','208','1038',479,'Retail Sale Id 1644232',999.68,0.00,0.00,1.76,89.76,'2022-02-15 17:11:24','',''),(2653073,'1','208','1038',479,'Retail Sale Id 1644233',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 17:12:24','',''),(2653074,'1','208','1038',479,'Retail Sale Id 1644236',1499.52,0.00,0.00,2.64,134.64,'2022-02-15 17:15:49','',''),(2653075,'1','208','1038',479,'Retail Sale Id 1644238',2840.00,0.00,0.00,5.00,255.00,'2022-02-15 17:19:56','',''),(2653076,'1','208','1038',479,'Retail Sale Id 1644240',602.08,0.00,0.00,1.06,54.06,'2022-02-15 17:21:06','',''),(2653077,'1','208','1038',479,'Retail Sale Id 1644241',6997.76,0.00,0.00,12.32,628.32,'2022-02-15 17:22:12','',''),(2653078,'1','208','1038',479,'Retail Sale Id 1644242',999.68,0.00,0.00,1.76,89.76,'2022-02-15 17:23:26','',''),(2653079,'1','208','1038',479,'Retail Sale Id 1644243',3408.00,0.00,0.00,6.00,306.00,'2022-02-15 17:28:14','',''),(2653080,'1','208','1038',479,'Retail Sale Id 1644243',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 17:28:14','',''),(2653081,'1','208','1038',479,'Retail Sale Id 1644244',1198.48,0.00,0.00,2.11,107.61,'2022-02-15 17:30:08','',''),(2653082,'1','208','1038',479,'Retail Sale Id 1644245',602.08,0.00,0.00,1.06,54.06,'2022-02-15 17:31:46','',''),(2653083,'1','208','1038',479,'Retail Sale Id 1644245',602.08,0.00,0.00,1.06,54.06,'2022-02-15 17:31:46','',''),(2653084,'1','208','1038',479,'Retail Sale Id 1644246',1499.52,0.00,0.00,2.64,134.64,'2022-02-15 17:42:28','',''),(2653085,'1','208','1038',479,'Retail Sale Id 1644247',2840.00,0.00,0.00,5.00,255.00,'2022-02-15 17:45:45','',''),(2653086,'1','208','1038',479,'Retail Sale Id 1644247',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 17:45:45','',''),(2653087,'1','208','1038',479,'Retail Sale Id 1644248',3408.00,0.00,0.00,6.00,306.00,'2022-02-15 17:51:18','',''),(2653088,'1','208','1038',479,'Retail Sale Id 1644249',1999.36,0.00,0.00,3.52,179.52,'2022-02-15 17:53:41','',''),(2653089,'1','208','1038',479,'Retail Sale Id 1644250',3408.00,0.00,0.00,6.00,306.00,'2022-02-15 17:59:11','',''),(2653090,'1','208','1038',479,'Retail Sale Id 1644251',1709.68,0.00,0.00,3.01,153.51,'2022-02-15 18:00:51','',''),(2653091,'1','208','1038',479,'Retail Sale Id 1644252',1999.36,0.00,0.00,3.52,179.52,'2022-02-15 18:06:03','',''),(2653092,'1','208','1038',479,'Retail Sale Id 1644254',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 18:14:23','',''),(2653093,'1','208','1038',479,'Retail Sale Id 1644255',1709.68,0.00,0.00,3.01,153.51,'2022-02-15 18:21:14','',''),(2653094,'1','208','1038',479,'Retail Sale Id 1644255',1709.68,0.00,0.00,3.01,153.51,'2022-02-15 18:21:14','',''),(2653095,'1','208','1038',479,'Retail Sale Id 1644255',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 18:21:14','',''),(2653096,'1','208','1038',479,'Retail Sale Id 1644256',3498.88,0.00,0.00,6.16,314.16,'2022-02-15 18:22:37','',''),(2653097,'1','208','1038',479,'Retail Sale Id 1644257',1709.68,0.00,0.00,3.01,153.51,'2022-02-15 18:26:42','',''),(2653098,'1','208','1038',479,'Retail Sale Id 1644258',1709.68,0.00,0.00,3.01,153.51,'2022-02-15 18:28:25','',''),(2653099,'1','208','1038',479,'Retail Sale Id 1644259',999.68,0.00,0.00,1.76,89.76,'2022-02-15 18:29:32','',''),(2653100,'1','208','1038',479,'Retail Sale Id 1644260',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 18:34:54','',''),(2653101,'1','208','1038',479,'Retail Sale Id 1644263',999.68,0.00,0.00,1.76,89.76,'2022-02-15 18:39:03','',''),(2653102,'1','208','1038',479,'Retail Sale Id 1644264',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 18:43:12','',''),(2653103,'1','208','1038',479,'Retail Sale Id 1644265',1999.36,0.00,0.00,3.52,179.52,'2022-02-15 18:52:09','',''),(2653104,'1','208','1038',479,'Return of Retail Sale Id 1644247',0.00,2840.00,5.00,0.00,-255.00,'2022-02-15 19:18:48','',''),(2653105,'1','208','1038',479,'Return of Retail Sale Id 1644247',0.00,7100.00,12.50,0.00,-637.50,'2022-02-15 19:18:48','',''),(2653106,'1','208','1038',479,'Return of Retail Sale Id 1644243',0.00,3408.00,6.00,0.00,-306.00,'2022-02-15 19:20:08','',''),(2653107,'1','208','1038',479,'Return of Retail Sale Id 1644243',0.00,7100.00,12.50,0.00,-637.50,'2022-02-15 19:20:08','',''),(2653108,'1','208','1038',479,'Return of Retail Sale Id 1644196',0.00,4998.40,8.80,0.00,-448.80,'2022-02-15 19:20:59','',''),(2653109,'1','208','1038',479,'Return of Retail Sale Id 1644184',0.00,2999.04,5.28,0.00,-269.28,'2022-02-15 19:22:45','',''),(2653110,'1','208','1038',479,'Return of Retail Sale Id 1644184',0.00,4998.40,8.80,0.00,-448.80,'2022-02-15 19:22:45','',''),(2653111,'1','208','1038',479,'Retail Sale Id 1644266',47865.36,0.00,0.00,84.27,4297.77,'2022-02-15 19:26:47','',''),(2653112,'1','208','1038',479,'Retail Sale Id 1644267',56470.56,0.00,0.00,99.42,5070.42,'2022-02-15 19:27:36','',''),(2653113,'1','208','1038',479,'Retail Sale Id 1644269',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 19:28:19','',''),(2653114,'1','208','1038',479,'Retail Sale Id 1644270',13007.20,0.00,0.00,22.90,1167.90,'2022-02-15 19:29:17','',''),(2653115,'1','208','1038',479,'Retail Sale Id 1644271',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 08:02:28','',''),(2653116,'1','208','1038',479,'Retail Sale Id 1644272',999.68,0.00,0.00,1.76,89.76,'2022-02-16 08:03:45','',''),(2653117,'1','208','1038',479,'Retail Sale Id 1644274',1101.92,0.00,0.00,1.94,98.94,'2022-02-16 08:05:55','',''),(2653118,'1','208','1038',479,'Retail Sale Id 1644275',397.60,0.00,0.00,0.70,35.70,'2022-02-16 08:09:24','',''),(2653119,'1','208','1038',479,'Retail Sale Id 1644276',999.68,0.00,0.00,1.76,89.76,'2022-02-16 08:12:17','',''),(2653120,'1','208','1038',479,'Retail Sale Id 1644277',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 08:15:57','',''),(2653121,'1','208','1038',479,'Retail Sale Id 1644278',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 08:16:50','',''),(2653122,'1','208','1038',479,'Retail Sale Id 1644279',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 08:20:51','',''),(2653123,'1','208','1038',479,'Retail Sale Id 1644280',1749.44,0.00,0.00,3.08,157.08,'2022-02-16 08:21:58','',''),(2653124,'1','208','1038',479,'Retail Sale Id 1644281',749.76,0.00,0.00,1.32,67.32,'2022-02-16 08:22:38','',''),(2653125,'1','208','1038',479,'Retail Sale Id 1644282',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 08:24:05','',''),(2653126,'1','208','1038',479,'Retail Sale Id 1644283',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 08:25:24','',''),(2653127,'1','208','1038',479,'Retail Sale Id 1644285',1499.52,0.00,0.00,2.64,134.64,'2022-02-16 08:26:24','',''),(2653128,'1','208','1038',479,'Retail Sale Id 1644286',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 08:27:19','',''),(2653129,'1','208','1038',479,'Retail Sale Id 1644287',2999.04,0.00,0.00,5.28,269.28,'2022-02-16 08:32:09','',''),(2653130,'1','208','1038',479,'Retail Sale Id 1644288',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 08:35:15','',''),(2653131,'1','208','1038',479,'Retail Sale Id 1644289',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 08:36:14','',''),(2653132,'1','208','1038',479,'Retail Sale Id 1644290',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 08:40:49','',''),(2653133,'1','208','1038',479,'Retail Sale Id 1644291',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 08:41:52','',''),(2653134,'1','208','1038',479,'Retail Sale Id 1644292',2840.00,0.00,0.00,5.00,255.00,'2022-02-16 08:43:28','',''),(2653135,'1','208','1038',479,'Retail Sale Id 1644293',2840.00,0.00,0.00,5.00,255.00,'2022-02-16 08:45:49','',''),(2653136,'1','208','1038',479,'Retail Sale Id 1644294',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 08:50:58','',''),(2653137,'1','208','1038',479,'Retail Sale Id 1644294',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 08:50:58','',''),(2653138,'1','208','1038',479,'Retail Sale Id 1644295',6821.68,0.00,0.00,12.01,612.51,'2022-02-16 08:53:51','',''),(2653139,'1','208','1038',479,'Retail Sale Id 1644296',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 08:54:46','',''),(2653140,'1','208','1038',479,'Retail Sale Id 1644297',1499.52,0.00,0.00,2.64,134.64,'2022-02-16 08:56:58','',''),(2653141,'1','208','1038',479,'Retail Sale Id 1644298',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 09:00:23','',''),(2653142,'1','208','1038',479,'Retail Sale Id 1644299',499.84,0.00,0.00,0.88,44.88,'2022-02-16 09:02:39','',''),(2653143,'1','208','1038',479,'Retail Sale Id 1644300',698.64,0.00,0.00,1.23,62.73,'2022-02-16 09:03:17','',''),(2653144,'1','208','1038',479,'Retail Sale Id 1644301',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 09:14:52','',''),(2653145,'1','208','1038',479,'Retail Sale Id 1644302',7497.60,0.00,0.00,13.20,673.20,'2022-02-16 09:26:57','',''),(2653146,'1','208','1038',479,'Retail Sale Id 1644303',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 09:29:31','',''),(2653147,'1','208','1038',479,'Retail Sale Id 1644303',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 09:29:31','',''),(2653148,'1','208','1038',479,'Retail Sale Id 1644304',999.68,0.00,0.00,1.76,89.76,'2022-02-16 09:30:22','',''),(2653149,'1','208','1038',479,'Retail Sale Id 1644306',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 09:33:13','',''),(2653150,'1','208','1038',479,'Retail Sale Id 1644307',2851.36,0.00,0.00,5.02,256.02,'2022-02-16 09:34:21','',''),(2653151,'1','208','1038',479,'Retail Sale Id 1644308',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 09:35:51','',''),(2653152,'1','208','1038',479,'Retail Sale Id 1644309',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 09:51:48','',''),(2653153,'1','208','1038',479,'Retail Sale Id 1644311',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 10:00:50','',''),(2653154,'1','208','1038',479,'Retail Sale Id 1644312',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 10:04:33','',''),(2653155,'1','208','1038',479,'Retail Sale Id 1644313',999.68,0.00,0.00,1.76,89.76,'2022-02-16 10:07:56','',''),(2653156,'1','208','1038',479,'Retail Sale Id 1644315',1721.04,0.00,0.00,3.03,154.53,'2022-02-16 10:25:35','',''),(2653157,'1','208','1038',479,'Retail Sale Id 1644316',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 10:33:12','',''),(2653158,'1','208','1038',479,'Retail Sale Id 1644317',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 10:34:04','',''),(2653159,'1','208','1038',479,'Retail Sale Id 1644318',2840.00,0.00,0.00,5.00,255.00,'2022-02-16 10:37:53','',''),(2653160,'1','208','1038',479,'Retail Sale Id 1644319',1300.72,0.00,0.00,2.29,116.79,'2022-02-16 10:39:50','',''),(2653161,'1','208','1038',479,'Retail Sale Id 1644320',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 10:48:23','',''),(2653162,'1','208','1038',479,'Retail Sale Id 1644320',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 10:48:23','',''),(2653163,'1','208','1038',479,'Retail Sale Id 1644321',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 10:50:14','',''),(2653164,'1','208','1038',479,'Retail Sale Id 1644322',1698.32,0.00,0.00,2.99,152.49,'2022-02-16 10:56:27','',''),(2653165,'1','208','1038',479,'Retail Sale Id 1644323',499.84,0.00,0.00,0.88,44.88,'2022-02-16 10:57:37','',''),(2653166,'1','208','1038',479,'Retail Sale Id 1644324',2999.04,0.00,0.00,5.28,269.28,'2022-02-16 10:59:05','',''),(2653167,'1','208','1038',479,'Retail Sale Id 1644325',2698.00,0.00,0.00,4.75,242.25,'2022-02-16 11:01:49','',''),(2653168,'1','208','1038',479,'Retail Sale Id 1644326',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 11:17:52','',''),(2653169,'1','208','1038',479,'Retail Sale Id 1644327',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 11:27:47','',''),(2653170,'1','208','1038',479,'Retail Sale Id 1644327',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 11:27:47','',''),(2653171,'1','208','1038',479,'Retail Sale Id 1644327',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 11:27:47','',''),(2653172,'1','208','1038',479,'Retail Sale Id 1644328',5998.08,0.00,0.00,10.56,538.56,'2022-02-16 11:36:52','',''),(2653173,'1','208','1038',479,'Retail Sale Id 1644329',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 11:43:33','',''),(2653174,'1','208','1038',479,'Retail Sale Id 1644330',999.68,0.00,0.00,1.76,89.76,'2022-02-16 11:51:59','',''),(2653175,'1','208','1038',479,'Retail Sale Id 1644331',3998.72,0.00,0.00,7.04,359.04,'2022-02-16 11:55:24','',''),(2653176,'1','208','1038',479,'Retail Sale Id 1644332',2840.00,0.00,0.00,5.00,255.00,'2022-02-16 11:57:09','',''),(2653177,'1','208','1038',479,'Retail Sale Id 1644333',2499.20,0.00,0.00,4.40,224.40,'2022-02-16 11:58:13','',''),(2653178,'1','208','1038',479,'Retail Sale Id 1644334',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 12:06:49','',''),(2653179,'1','208','1038',479,'Retail Sale Id 1644336',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 12:07:31','',''),(2653180,'1','208','1038',479,'Retail Sale Id 1644337',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 12:09:56','',''),(2653181,'1','208','1038',479,'Retail Sale Id 1644338',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 12:19:05','',''),(2653182,'1','208','1038',479,'Retail Sale Id 1644340',6248.00,0.00,0.00,11.00,561.00,'2022-02-16 12:21:13','',''),(2653183,'1','208','1038',479,'Retail Sale Id 1644341',1698.32,0.00,0.00,2.99,152.49,'2022-02-16 12:23:17','',''),(2653184,'1','208','1038',479,'Retail Sale Id 1644342',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 12:24:23','',''),(2653185,'1','208','1038',479,'Retail Sale Id 1644347',1721.04,0.00,0.00,3.03,154.53,'2022-02-16 12:27:23','',''),(2653186,'1','208','1038',479,'Retail Sale Id 1644348',602.08,0.00,0.00,1.06,54.06,'2022-02-16 12:30:46','',''),(2653187,'1','208','1038',479,'Retail Sale Id 1644349',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 12:31:41','',''),(2653188,'1','208','1038',479,'Retail Sale Id 1644350',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 12:32:50','',''),(2653189,'1','208','1038',479,'Retail Sale Id 1644351',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 12:36:00','',''),(2653190,'1','208','1038',479,'Retail Sale Id 1644352',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 12:57:11','',''),(2653191,'1','208','1038',479,'Retail Sale Id 1644353',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 13:09:38','',''),(2653192,'1','208','1038',479,'Retail Sale Id 1644354',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 13:24:40','',''),(2653193,'1','208','1038',479,'Retail Sale Id 1644355',5680.00,0.00,0.00,10.00,510.00,'2022-02-16 13:35:42','',''),(2653194,'1','208','1038',479,'Retail Sale Id 1644355',5680.00,0.00,0.00,10.00,510.00,'2022-02-16 13:35:42','',''),(2653195,'1','208','1038',479,'Retail Sale Id 1644356',999.68,0.00,0.00,1.76,89.76,'2022-02-16 13:46:30','',''),(2653196,'1','208','1038',479,'Retail Sale Id 1644357',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 13:51:59','',''),(2653197,'1','208','1038',479,'Retail Sale Id 1644358',999.68,0.00,0.00,1.76,89.76,'2022-02-16 13:54:35','',''),(2653198,'1','208','1038',479,'Retail Sale Id 1644359',2840.00,0.00,0.00,5.00,255.00,'2022-02-16 13:56:14','',''),(2653199,'1','208','1038',479,'Retail Sale Id 1644360',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 13:57:30','',''),(2653200,'1','208','1038',479,'Retail Sale Id 1644361',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 13:58:25','',''),(2653201,'1','208','1038',479,'Retail Sale Id 1644362',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 14:01:01','',''),(2653202,'1','208','1038',479,'Retail Sale Id 1644362',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 14:01:01','',''),(2653203,'1','208','1038',479,'Retail Sale Id 1644363',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 14:02:04','',''),(2653204,'1','208','1038',479,'Retail Sale Id 1644364',2499.20,0.00,0.00,4.40,224.40,'2022-02-16 14:11:32','',''),(2653205,'1','208','1038',479,'Retail Sale Id 1644365',2800.24,0.00,0.00,4.93,251.43,'2022-02-16 14:15:56','',''),(2653206,'1','208','1038',479,'Retail Sale Id 1644366',2999.04,0.00,0.00,5.28,269.28,'2022-02-16 14:32:56','',''),(2653207,'1','208','1038',479,'Retail Sale Id 1644367',602.08,0.00,0.00,1.06,54.06,'2022-02-16 14:37:20','',''),(2653208,'1','208','1038',479,'Retail Sale Id 1644368',2840.00,0.00,0.00,5.00,255.00,'2022-02-16 15:10:31','',''),(2653209,'1','208','1038',479,'Retail Sale Id 1644369',2902.48,0.00,0.00,5.11,260.61,'2022-02-16 15:11:10','',''),(2653210,'1','208','1038',479,'Retail Sale Id 1644370',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 15:13:38','',''),(2653211,'1','208','1038',479,'Retail Sale Id 1644371',999.68,0.00,0.00,1.76,89.76,'2022-02-16 15:15:55','',''),(2653212,'1','208','1038',479,'Retail Sale Id 1644372',499.84,0.00,0.00,0.88,44.88,'2022-02-16 15:19:32','',''),(2653213,'1','208','1038',479,'Retail Sale Id 1644373',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 15:31:47','',''),(2653214,'1','208','1038',479,'Retail Sale Id 1644374',1499.52,0.00,0.00,2.64,134.64,'2022-02-16 15:34:46','',''),(2653215,'1','208','1038',479,'Retail Sale Id 1644375',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 15:40:59','',''),(2653216,'1','208','1038',479,'Retail Sale Id 1644376',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 15:54:22','',''),(2653217,'1','208','1038',479,'Retail Sale Id 1644377',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 15:56:20','',''),(2653218,'1','208','1038',479,'Retail Sale Id 1644378',1601.76,0.00,0.00,2.82,143.82,'2022-02-16 16:02:50','',''),(2653219,'1','208','1038',479,'Retail Sale Id 1644380',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 16:08:31','',''),(2653220,'1','208','1038',479,'Retail Sale Id 1644384',2840.00,0.00,0.00,5.00,255.00,'2022-02-16 16:09:59','',''),(2653221,'1','208','1038',479,'Retail Sale Id 1644385',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 16:21:15','',''),(2653222,'1','208','1038',479,'Retail Sale Id 1644386',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 16:29:49','',''),(2653223,'1','208','1038',479,'Retail Sale Id 1644386',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 16:29:49','',''),(2653224,'1','208','1038',479,'Retail Sale Id 1644387',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 16:58:11','',''),(2653225,'1','208','1038',479,'Retail Sale Id 1644388',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 16:59:30','',''),(2653226,'1','208','1038',479,'Retail Sale Id 1644389',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 17:00:32','',''),(2653227,'1','208','1038',479,'Retail Sale Id 1644390',6248.00,0.00,0.00,11.00,561.00,'2022-02-16 17:02:19','',''),(2653228,'1','208','1038',479,'Retail Sale Id 1644391',6997.76,0.00,0.00,12.32,628.32,'2022-02-16 17:10:37','',''),(2653229,'1','208','1038',479,'Retail Sale Id 1644392',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 17:12:04','',''),(2653230,'1','208','1038',479,'Retail Sale Id 1644393',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 17:13:59','',''),(2653231,'1','208','1038',479,'Retail Sale Id 1644394',999.68,0.00,0.00,1.76,89.76,'2022-02-16 17:16:14','',''),(2653232,'1','208','1038',479,'Retail Sale Id 1644395',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 17:18:56','',''),(2653233,'1','208','1038',479,'Retail Sale Id 1644395',5680.00,0.00,0.00,10.00,510.00,'2022-02-16 17:18:56','',''),(2653234,'1','208','1038',479,'Retail Sale Id 1644396',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 17:20:18','',''),(2653235,'1','208','1038',479,'Retail Sale Id 1644397',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 17:22:06','',''),(2653236,'1','208','1038',479,'Retail Sale Id 1644397',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 17:22:06','',''),(2653237,'1','208','1038',479,'Retail Sale Id 1644398',3498.88,0.00,0.00,6.16,314.16,'2022-02-16 17:34:27','',''),(2653238,'1','208','1038',479,'Retail Sale Id 1644398',10002.48,0.00,0.00,17.61,898.11,'2022-02-16 17:34:27','',''),(2653239,'1','208','1038',479,'Retail Sale Id 1644399',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 17:48:40','',''),(2653240,'1','208','1038',479,'Retail Sale Id 1644400',2999.04,0.00,0.00,5.28,269.28,'2022-02-16 17:53:16','',''),(2653241,'1','208','1038',479,'Retail Sale Id 1644401',1499.52,0.00,0.00,2.64,134.64,'2022-02-16 18:04:08','',''),(2653242,'1','208','1038',479,'Retail Sale Id 1644402',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 18:11:32','',''),(2653243,'1','208','1038',479,'Retail Sale Id 1644403',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 18:15:19','',''),(2653244,'1','208','1038',479,'Retail Sale Id 1644404',1101.92,0.00,0.00,1.94,98.94,'2022-02-16 18:19:43','',''),(2653245,'1','208','1038',479,'Retail Sale Id 1644405',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 18:21:15','',''),(2653246,'1','208','1038',479,'Retail Sale Id 1644406',1499.52,0.00,0.00,2.64,134.64,'2022-02-16 18:22:09','',''),(2653247,'1','208','1038',479,'Retail Sale Id 1644407',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 18:25:17','',''),(2653248,'1','208','1038',479,'Retail Sale Id 1644408',1709.68,0.00,0.00,3.01,153.51,'2022-02-16 18:30:35','',''),(2653249,'1','208','1038',479,'Retail Sale Id 1644408',5680.00,0.00,0.00,10.00,510.00,'2022-02-16 18:30:35','',''),(2653250,'1','208','1038',479,'Retail Sale Id 1644409',2999.04,0.00,0.00,5.28,269.28,'2022-02-16 18:31:46','',''),(2653251,'1','208','1038',479,'Retail Sale Id 1644410',2999.04,0.00,0.00,5.28,269.28,'2022-02-16 18:33:36','',''),(2653252,'1','208','1038',479,'Retail Sale Id 1644411',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 18:43:03','',''),(2653253,'1','208',NULL,479,'Reception corrector for bridging 132392',0.00,0.00,0.00,5000.00,0.00,'2022-02-16 18:59:51','',''),(2653254,'1','208','1038',479,'Received from bridging 132392',0.00,0.00,5000.00,0.00,0.00,'2022-02-16 18:59:51','',''),(2653255,'1','208','1038',479,'Retail Sale Id 1644413',6997.76,0.00,0.00,12.32,628.32,'2022-02-16 19:04:36','',''),(2653256,'1','208','1038',479,'Retail Sale Id 1644414',7100.00,0.00,0.00,12.50,637.50,'2022-02-16 19:06:36','',''),(2653257,'1','208','1038',479,'Retail Sale Id 1644415',233198.08,0.00,0.00,410.56,20938.56,'2022-02-16 21:34:31','',''),(2653258,'1','208','1038',479,'Retail Sale Id 1644416',162675.20,0.00,0.00,286.40,14606.40,'2022-02-16 21:35:55','',''),(2653259,'1','208','1038',479,'Retail Sale Id 1644417',54102.00,0.00,0.00,95.25,4857.75,'2022-02-16 21:37:40','',''),(2653260,'1','208','1038',479,'Retail Sale Id 1644418',41821.84,0.00,0.00,73.63,3755.13,'2022-02-16 21:38:45','',''),(2653261,'1','208','1038',479,'Return of Retail Sale Id 1644418',0.00,41821.84,73.63,0.00,-3755.13,'2022-02-16 21:40:48','',''),(2653262,'1','208','1038',479,'Return of Retail Sale Id 1644417',0.00,54102.00,95.25,0.00,-4857.75,'2022-02-16 21:41:26','',''),(2653263,'1','208','1038',479,'Return of Retail Sale Id 1644416',0.00,162675.20,286.40,0.00,-14606.40,'2022-02-16 21:42:20','',''),(2653264,'1','208','1038',479,'Return of Retail Sale Id 1644415',0.00,233198.08,410.56,0.00,-20938.56,'2022-02-16 21:43:57','',''),(2653265,'1','208','1038',479,'Return of Retail Sale Id 1644405',0.00,7100.00,12.50,0.00,-637.50,'2022-02-16 21:45:04','',''),(2653266,'1','208','1038',479,'Retail Sale Id 1644419',28615.84,0.00,0.00,50.38,2569.38,'2022-02-16 21:52:38','',''),(2653267,'1','208','1038',479,'Retail Sale Id 1644420',16835.52,0.00,0.00,29.64,1511.64,'2022-02-16 21:54:15','',''),(2653268,'1','208','1038',479,'Retail Sale Id 1644421',19550.56,0.00,0.00,34.42,1755.42,'2022-02-16 21:55:51','',''),(2653269,'1','208','1038',479,'Retail Sale Id 1644422',7957.68,0.00,0.00,14.01,714.51,'2022-02-16 21:56:56','',''),(2653270,'1','208','1038',479,'Return of Retail Sale Id 1644419',0.00,28615.84,50.38,0.00,-2569.38,'2022-02-16 22:02:40','',''),(2653271,'1','208','1038',479,'Return of Retail Sale Id 1644278',0.00,7100.00,12.50,0.00,-637.50,'2022-02-16 22:04:50','',''),(2653272,'1','208','1038',479,'Return of Retail Sale Id 1644294',0.00,3408.00,6.00,0.00,-306.00,'2022-02-16 22:06:13','',''),(2653273,'1','208','1038',479,'Return of Retail Sale Id 1644294',0.00,7100.00,12.50,0.00,-637.50,'2022-02-16 22:06:13','',''),(2653274,'1','208','1038',479,'Return of Retail Sale Id 1644320',0.00,1709.68,3.01,0.00,-153.51,'2022-02-16 22:08:29','',''),(2653275,'1','208','1038',479,'Return of Retail Sale Id 1644320',0.00,7100.00,12.50,0.00,-637.50,'2022-02-16 22:08:29','',''),(2653276,'1','208','1038',479,'Return of Retail Sale Id 1644334',0.00,7100.00,12.50,0.00,-637.50,'2022-02-16 22:09:51','',''),(2653277,'1','208','1038',479,'Return of Retail Sale Id 1644422',0.00,7957.68,14.01,0.00,-714.51,'2022-02-16 22:11:16','',''),(2653278,'1','208','1038',479,'Retail Sale Id 1644423',53323.84,0.00,0.00,93.88,4787.88,'2022-02-16 22:15:35','',''),(2653279,'1','208','1038',479,'Retail Sale Id 1644424',8804.00,0.00,0.00,15.50,790.50,'2022-02-16 22:16:54','',''),(2653280,'1','208','1038',479,'Retail Sale Id 1644425',7957.68,0.00,0.00,14.01,714.51,'2022-02-16 22:18:02','',''),(2653281,'1','208','1038',479,'Retail Sale Id 1644426',7298.80,0.00,0.00,12.85,655.35,'2022-02-17 07:35:19','',''),(2653282,'1','208','1038',479,'Retail Sale Id 1644427',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 07:44:17','',''),(2653283,'1','208','1038',479,'Retail Sale Id 1644428',4998.40,0.00,0.00,8.80,448.80,'2022-02-17 07:59:50','',''),(2653284,'1','208','1038',479,'Retail Sale Id 1644429',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 08:01:31','',''),(2653285,'1','208','1038',479,'Retail Sale Id 1644430',5680.00,0.00,0.00,10.00,510.00,'2022-02-17 08:02:33','',''),(2653286,'1','208','1038',479,'Retail Sale Id 1644431',6997.76,0.00,0.00,12.32,628.32,'2022-02-17 08:08:42','',''),(2653287,'1','208','1038',479,'Retail Sale Id 1644432',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 08:10:28','',''),(2653288,'1','208','1038',479,'Retail Sale Id 1644433',1999.36,0.00,0.00,3.52,179.52,'2022-02-17 08:11:28','',''),(2653289,'1','208','1038',479,'Retail Sale Id 1644434',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 08:20:33','',''),(2653290,'1','208','1038',479,'Retail Sale Id 1644435',1709.68,0.00,0.00,3.01,153.51,'2022-02-17 08:22:12','',''),(2653291,'1','208','1038',479,'Retail Sale Id 1644436',2902.48,0.00,0.00,5.11,260.61,'2022-02-17 08:23:51','',''),(2653292,'1','208','1038',479,'Retail Sale Id 1644436',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 08:23:51','',''),(2653293,'1','208','1038',479,'Retail Sale Id 1644437',3402.32,0.00,0.00,5.99,305.49,'2022-02-17 08:24:49','',''),(2653294,'1','208','1038',479,'Retail Sale Id 1644438',1999.36,0.00,0.00,3.52,179.52,'2022-02-17 08:32:31','',''),(2653295,'1','208','1038',479,'Retail Sale Id 1644439',3498.88,0.00,0.00,6.16,314.16,'2022-02-17 08:33:26','',''),(2653296,'1','208','1038',479,'Retail Sale Id 1644440',1499.52,0.00,0.00,2.64,134.64,'2022-02-17 08:34:06','',''),(2653297,'1','208','1038',479,'Retail Sale Id 1644441',1698.32,0.00,0.00,2.99,152.49,'2022-02-17 08:44:26','',''),(2653298,'1','208','1038',479,'Retail Sale Id 1644442',3498.88,0.00,0.00,6.16,314.16,'2022-02-17 08:53:10','',''),(2653299,'1','208','1038',479,'Retail Sale Id 1644443',999.68,0.00,0.00,1.76,89.76,'2022-02-17 09:07:47','',''),(2653300,'1','208','1038',479,'Retail Sale Id 1644444',3402.32,0.00,0.00,5.99,305.49,'2022-02-17 09:21:08','',''),(2653301,'1','208','1038',479,'Retail Sale Id 1644445',3498.88,0.00,0.00,6.16,314.16,'2022-02-17 09:22:41','',''),(2653302,'1','208','1038',479,'Retail Sale Id 1644446',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 09:30:45','',''),(2653303,'1','208','1038',479,'Retail Sale Id 1644447',1999.36,0.00,0.00,3.52,179.52,'2022-02-17 09:36:00','',''),(2653304,'1','208','1038',479,'Retail Sale Id 1644448',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 09:40:58','',''),(2653305,'1','208','1038',479,'Retail Sale Id 1644449',3799.92,0.00,0.00,6.69,341.19,'2022-02-17 09:42:03','',''),(2653306,'1','208','1038',479,'Retail Sale Id 1644450',1698.32,0.00,0.00,2.99,152.49,'2022-02-17 09:44:20','',''),(2653307,'1','208','1038',479,'Retail Sale Id 1644451',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 09:47:26','',''),(2653308,'1','208','1038',479,'Retail Sale Id 1644453',1590.40,0.00,0.00,2.80,142.80,'2022-02-17 09:53:59','',''),(2653309,'1','208','1038',479,'Retail Sale Id 1644453',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 09:53:59','',''),(2653310,'1','208','1038',479,'Retail Sale Id 1644454',2840.00,0.00,0.00,5.00,255.00,'2022-02-17 10:07:08','',''),(2653311,'1','208','1038',479,'Retail Sale Id 1644455',3402.32,0.00,0.00,5.99,305.49,'2022-02-17 10:09:58','',''),(2653312,'1','208','1038',479,'Retail Sale Id 1644456',2999.04,0.00,0.00,5.28,269.28,'2022-02-17 10:13:14','',''),(2653313,'1','208','1038',479,'Retail Sale Id 1644457',1499.52,0.00,0.00,2.64,134.64,'2022-02-17 10:23:06','',''),(2653314,'1','208','1038',479,'Retail Sale Id 1644458',3998.72,0.00,0.00,7.04,359.04,'2022-02-17 10:29:26','',''),(2653315,'1','208','1038',479,'Retail Sale Id 1644459',1698.32,0.00,0.00,2.99,152.49,'2022-02-17 10:30:29','',''),(2653316,'1','208','1038',479,'Retail Sale Id 1644460',6497.92,0.00,0.00,11.44,583.44,'2022-02-17 10:31:14','',''),(2653317,'1','208','1038',479,'Retail Sale Id 1644461',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 10:32:20','',''),(2653318,'1','208','1038',479,'Retail Sale Id 1644462',1147.36,0.00,0.00,2.02,103.02,'2022-02-17 10:45:30','',''),(2653319,'1','208','1038',479,'Retail Sale Id 1644463',2851.36,0.00,0.00,5.02,256.02,'2022-02-17 10:50:38','',''),(2653320,'1','208','1038',479,'Retail Sale Id 1644464',2800.24,0.00,0.00,4.93,251.43,'2022-02-17 10:56:09','',''),(2653321,'1','208','1038',479,'Retail Sale Id 1644465',2851.36,0.00,0.00,5.02,256.02,'2022-02-17 10:57:16','',''),(2653322,'1','208','1038',479,'Retail Sale Id 1644466',1709.68,0.00,0.00,3.01,153.51,'2022-02-17 11:20:04','',''),(2653323,'1','208','1038',479,'Retail Sale Id 1644466',5680.00,0.00,0.00,10.00,510.00,'2022-02-17 11:20:04','',''),(2653324,'1','208','1038',479,'Retail Sale Id 1644467',1698.32,0.00,0.00,2.99,152.49,'2022-02-17 11:21:09','',''),(2653325,'1','208','1038',479,'Retail Sale Id 1644468',2499.20,0.00,0.00,4.40,224.40,'2022-02-17 11:26:06','',''),(2653326,'1','208','1038',479,'Retail Sale Id 1644469',3402.32,0.00,0.00,5.99,305.49,'2022-02-17 11:34:26','',''),(2653327,'1','208','1038',479,'Retail Sale Id 1644470',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 11:38:35','',''),(2653328,'1','208','1038',479,'Retail Sale Id 1644470',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 11:38:35','',''),(2653329,'1','208','1038',479,'Retail Sale Id 1644471',3998.72,0.00,0.00,7.04,359.04,'2022-02-17 11:43:28','',''),(2653330,'1','208','1038',479,'Retail Sale Id 1644472',2840.00,0.00,0.00,5.00,255.00,'2022-02-17 11:59:48','',''),(2653331,'1','208','1038',479,'Retail Sale Id 1644473',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 12:06:45','',''),(2653332,'1','208','1038',479,'Retail Sale Id 1644474',6798.96,0.00,0.00,11.97,610.47,'2022-02-17 12:10:38','',''),(2653333,'1','208','1038',479,'Retail Sale Id 1644475',4998.40,0.00,0.00,8.80,448.80,'2022-02-17 12:11:28','',''),(2653334,'1','208','1038',479,'Retail Sale Id 1644476',3430.72,0.00,0.00,6.04,308.04,'2022-02-17 12:13:22','',''),(2653335,'1','208','1038',479,'Retail Sale Id 1644477',1101.92,0.00,0.00,1.94,98.94,'2022-02-17 12:16:36','',''),(2653336,'1','208','1038',479,'Retail Sale Id 1644478',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 12:20:49','',''),(2653337,'1','208','1038',479,'Retail Sale Id 1644479',2499.20,0.00,0.00,4.40,224.40,'2022-02-17 12:24:17','',''),(2653338,'1','208','1038',479,'Retail Sale Id 1644480',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 12:46:54','',''),(2653339,'1','208','1038',479,'Retail Sale Id 1644481',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 12:47:57','',''),(2653340,'1','208','1038',479,'Retail Sale Id 1644482',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 12:48:50','',''),(2653341,'1','208','1038',479,'Retail Sale Id 1644483',2902.48,0.00,0.00,5.11,260.61,'2022-02-17 12:52:13','',''),(2653342,'1','208','1038',479,'Retail Sale Id 1644483',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 12:52:13','',''),(2653343,'1','208','1038',479,'Retail Sale Id 1644484',4998.40,0.00,0.00,8.80,448.80,'2022-02-17 12:53:02','',''),(2653344,'1','208','1038',479,'Retail Sale Id 1644485',999.68,0.00,0.00,1.76,89.76,'2022-02-17 12:59:05','',''),(2653345,'1','208','1038',479,'Retail Sale Id 1644486',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 13:00:26','',''),(2653346,'1','208','1038',479,'Retail Sale Id 1644486',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 13:00:26','',''),(2653347,'1','208','1038',479,'Retail Sale Id 1644487',999.68,0.00,0.00,1.76,89.76,'2022-02-17 13:01:13','',''),(2653348,'1','208','1038',479,'Retail Sale Id 1644488',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 13:06:45','',''),(2653349,'1','208','1038',479,'Retail Sale Id 1644489',1698.32,0.00,0.00,2.99,152.49,'2022-02-17 13:08:05','',''),(2653350,'1','208','1038',479,'Retail Sale Id 1644490',1709.68,0.00,0.00,3.01,153.51,'2022-02-17 13:14:01','',''),(2653351,'1','208','1038',479,'Retail Sale Id 1644491',4998.40,0.00,0.00,8.80,448.80,'2022-02-17 13:27:50','',''),(2653352,'1','208','1038',479,'Retail Sale Id 1644492',999.68,0.00,0.00,1.76,89.76,'2022-02-17 13:37:59','',''),(2653353,'1','208','1038',479,'Retail Sale Id 1644492',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 13:37:59','',''),(2653354,'1','208','1038',479,'Retail Sale Id 1644493',4998.40,0.00,0.00,8.80,448.80,'2022-02-17 13:46:34','',''),(2653355,'1','208','1038',479,'Retail Sale Id 1644494',2840.00,0.00,0.00,5.00,255.00,'2022-02-17 14:17:41','',''),(2653356,'1','208','1038',479,'Retail Sale Id 1644495',1698.32,0.00,0.00,2.99,152.49,'2022-02-17 14:18:42','',''),(2653357,'1','208','1038',479,'Retail Sale Id 1644496',3402.32,0.00,0.00,5.99,305.49,'2022-02-17 14:25:33','',''),(2653358,'1','208','1038',479,'Retail Sale Id 1644497',602.08,0.00,0.00,1.06,54.06,'2022-02-17 14:30:09','',''),(2653359,'1','208','1038',479,'Retail Sale Id 1644498',1999.36,0.00,0.00,3.52,179.52,'2022-02-17 14:34:26','',''),(2653360,'1','208','1038',479,'Retail Sale Id 1644499',499.84,0.00,0.00,0.88,44.88,'2022-02-17 14:35:32','',''),(2653361,'1','208','1038',479,'Retail Sale Id 1644500',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 14:36:25','',''),(2653362,'1','208','1038',479,'Retail Sale Id 1644501',5680.00,0.00,0.00,10.00,510.00,'2022-02-17 14:38:32','',''),(2653363,'1','208','1038',479,'Retail Sale Id 1644502',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 14:39:45','',''),(2653364,'1','208','1038',479,'Retail Sale Id 1644503',999.68,0.00,0.00,1.76,89.76,'2022-02-17 15:33:04','',''),(2653365,'1','208','1038',479,'Retail Sale Id 1644504',2999.04,0.00,0.00,5.28,269.28,'2022-02-17 15:33:57','',''),(2653366,'1','208','1038',479,'Retail Sale Id 1644505',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 15:35:55','',''),(2653367,'1','208','1038',479,'Retail Sale Id 1644506',1198.48,0.00,0.00,2.11,107.61,'2022-02-17 15:38:21','',''),(2653368,'1','208','1038',479,'Retail Sale Id 1644507',1300.72,0.00,0.00,2.29,116.79,'2022-02-17 15:40:05','',''),(2653369,'1','208','1038',479,'Retail Sale Id 1644508',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 15:41:27','',''),(2653370,'1','208','1038',479,'Retail Sale Id 1644509',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 15:42:20','',''),(2653371,'1','208','1038',479,'Retail Sale Id 1644510',999.68,0.00,0.00,1.76,89.76,'2022-02-17 15:43:27','',''),(2653372,'1','208','1038',479,'Retail Sale Id 1644511',1698.32,0.00,0.00,2.99,152.49,'2022-02-17 15:49:22','',''),(2653373,'1','208','1038',479,'Retail Sale Id 1644512',2840.00,0.00,0.00,5.00,255.00,'2022-02-17 15:55:59','',''),(2653374,'1','208','1038',479,'Retail Sale Id 1644513',2840.00,0.00,0.00,5.00,255.00,'2022-02-17 16:21:52','',''),(2653375,'1','208','1038',479,'Retail Sale Id 1644514',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 16:29:33','',''),(2653376,'1','208','1038',479,'Retail Sale Id 1644515',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 16:30:46','',''),(2653377,'1','208','1038',479,'Retail Sale Id 1644516',1709.68,0.00,0.00,3.01,153.51,'2022-02-17 16:34:19','',''),(2653378,'1','208','1038',479,'Retail Sale Id 1644516',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 16:34:19','',''),(2653379,'1','208','1038',479,'Retail Sale Id 1644516',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 16:34:19','',''),(2653380,'1','208','1038',479,'Retail Sale Id 1644517',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 16:39:21','',''),(2653381,'1','208','1038',479,'Retail Sale Id 1644518',2999.04,0.00,0.00,5.28,269.28,'2022-02-17 16:41:00','',''),(2653382,'1','208','1038',479,'Retail Sale Id 1644519',1999.36,0.00,0.00,3.52,179.52,'2022-02-17 16:46:21','',''),(2653383,'1','208','1038',479,'Retail Sale Id 1644521',999.68,0.00,0.00,1.76,89.76,'2022-02-17 17:00:35','',''),(2653384,'1','208','1038',479,'Retail Sale Id 1644522',14200.00,0.00,0.00,25.00,1275.00,'2022-02-17 17:05:02','',''),(2653385,'1','208','1038',479,'Retail Sale Id 1644523',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 17:18:50','',''),(2653386,'1','208','1038',479,'Retail Sale Id 1644525',1698.32,0.00,0.00,2.99,152.49,'2022-02-17 17:22:34','',''),(2653387,'1','208','1038',479,'Retail Sale Id 1644525',4998.40,0.00,0.00,8.80,448.80,'2022-02-17 17:22:34','',''),(2653388,'1','208','1038',479,'Retail Sale Id 1644526',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 17:38:36','',''),(2653389,'1','208','1038',479,'Retail Sale Id 1644527',1709.68,0.00,0.00,3.01,153.51,'2022-02-17 17:49:36','',''),(2653390,'1','208','1038',479,'Retail Sale Id 1644527',1709.68,0.00,0.00,3.01,153.51,'2022-02-17 17:49:36','',''),(2653391,'1','208','1038',479,'Retail Sale Id 1644528',3402.32,0.00,0.00,5.99,305.49,'2022-02-17 18:01:44','',''),(2653392,'1','208','1038',479,'Retail Sale Id 1644529',5702.72,0.00,0.00,10.04,512.04,'2022-02-17 18:12:39','',''),(2653393,'1','208','1038',479,'Retail Sale Id 1644530',1709.68,0.00,0.00,3.01,153.51,'2022-02-17 18:14:09','',''),(2653394,'1','208','1038',479,'Retail Sale Id 1644531',1601.76,0.00,0.00,2.82,143.82,'2022-02-17 18:16:29','',''),(2653395,'1','208','1038',479,'Retail Sale Id 1644538',568.00,0.00,0.00,1.00,51.00,'2022-02-17 18:23:20','',''),(2653396,'1','208','1038',479,'Retail Sale Id 1644539',1709.68,0.00,0.00,3.01,153.51,'2022-02-17 18:27:30','',''),(2653397,'1','208','1038',479,'Retail Sale Id 1644540',602.08,0.00,0.00,1.06,54.06,'2022-02-17 18:31:26','',''),(2653398,'1','208','1038',479,'Retail Sale Id 1644541',1499.52,0.00,0.00,2.64,134.64,'2022-02-17 18:33:27','',''),(2653399,'1','208','1038',479,'Retail Sale Id 1644542',1499.52,0.00,0.00,2.64,134.64,'2022-02-17 18:37:29','',''),(2653400,'1','208','1038',479,'Retail Sale Id 1644543',999.68,0.00,0.00,1.76,89.76,'2022-02-17 18:43:42','',''),(2653401,'1','208','1038',479,'Retail Sale Id 1644544',1999.36,0.00,0.00,3.52,179.52,'2022-02-17 18:58:23','',''),(2653402,'1','208','1038',479,'Retail Sale Id 1644544',2499.20,0.00,0.00,4.40,224.40,'2022-02-17 18:58:23','',''),(2653403,'1','208','1038',479,'Retail Sale Id 1644545',1999.36,0.00,0.00,3.52,179.52,'2022-02-17 19:00:28','',''),(2653404,'1','208','1038',479,'Retail Sale Id 1644546',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 19:10:03','',''),(2653405,'1','208','1038',479,'Retail Sale Id 1644547',1999.36,0.00,0.00,3.52,179.52,'2022-02-17 19:17:50','',''),(2653406,'1','208','1038',479,'Retail Sale Id 1644548',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 19:24:07','',''),(2653407,'1','208','1038',479,'Retail Sale Id 1644548',7100.00,0.00,0.00,12.50,637.50,'2022-02-17 19:24:07','',''),(2653408,'1','208','1038',479,'Retail Sale Id 1644549',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 19:26:45','',''),(2653409,'1','208','1038',479,'Retail Sale Id 1644550',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 19:28:56','',''),(2653410,'1','208','1038',479,'Return of Retail Sale Id 1644483',0.00,2902.48,5.11,0.00,-260.61,'2022-02-17 20:16:24','',''),(2653411,'1','208','1038',479,'Return of Retail Sale Id 1644483',0.00,7100.00,12.50,0.00,-637.50,'2022-02-17 20:16:24','',''),(2653412,'1','208','1038',479,'Return of Retail Sale Id 1644486',0.00,3408.00,6.00,0.00,-306.00,'2022-02-17 20:17:20','',''),(2653413,'1','208','1038',479,'Return of Retail Sale Id 1644486',0.00,7100.00,12.50,0.00,-637.50,'2022-02-17 20:17:20','',''),(2653414,'1','208','1038',479,'Return of Retail Sale Id 1644470',0.00,7100.00,12.50,0.00,-637.50,'2022-02-17 20:19:08','',''),(2653415,'1','208','1038',479,'Return of Retail Sale Id 1644470',0.00,7100.00,12.50,0.00,-637.50,'2022-02-17 20:19:08','',''),(2653416,'1','208','1038',479,'Retail Sale Id 1644551',9627.60,0.00,0.00,16.95,864.45,'2022-02-17 20:23:37','',''),(2653417,'1','208','1038',479,'Retail Sale Id 1644552',34210.64,0.00,0.00,60.23,3071.73,'2022-02-17 20:24:23','',''),(2653418,'1','208','1038',479,'Retail Sale Id 1644553',16903.68,0.00,0.00,29.76,1517.76,'2022-02-17 20:25:17','',''),(2653419,'1','208','1038',479,'Retail Sale Id 1644554',16761.68,0.00,0.00,29.51,1505.01,'2022-02-17 20:26:04','',''),(2653420,'1','208','1038',479,'Retail Sale Id 1644555',2999.04,0.00,0.00,5.28,269.28,'2022-02-18 07:16:50','',''),(2653421,'1','208','1038',479,'Retail Sale Id 1644556',2840.00,0.00,0.00,5.00,255.00,'2022-02-18 07:25:49','',''),(2653422,'1','208','1038',479,'Retail Sale Id 1644557',1499.52,0.00,0.00,2.64,134.64,'2022-02-18 07:27:09','',''),(2653423,'1','208','1038',479,'Retail Sale Id 1644558',1499.52,0.00,0.00,2.64,134.64,'2022-02-18 07:39:28','',''),(2653424,'1','208','1038',479,'Retail Sale Id 1644559',6997.76,0.00,0.00,12.32,628.32,'2022-02-18 07:44:30','',''),(2653425,'1','208','1038',479,'Retail Sale Id 1644560',3498.88,0.00,0.00,6.16,314.16,'2022-02-18 07:55:32','',''),(2653426,'1','208','1038',479,'Retail Sale Id 1644562',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 07:56:24','',''),(2653427,'1','208','1038',479,'Retail Sale Id 1644563',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 07:58:18','',''),(2653428,'1','208','1038',479,'Retail Sale Id 1644565',3498.88,0.00,0.00,6.16,314.16,'2022-02-18 08:08:43','',''),(2653429,'1','208','1038',479,'Retail Sale Id 1644566',3498.88,0.00,0.00,6.16,314.16,'2022-02-18 08:09:26','',''),(2653430,'1','208','1038',479,'Retail Sale Id 1644567',1749.44,0.00,0.00,3.08,157.08,'2022-02-18 08:15:19','',''),(2653431,'1','208','1038',479,'Retail Sale Id 1644567',1749.44,0.00,0.00,3.08,157.08,'2022-02-18 08:15:19','',''),(2653432,'1','208','1038',479,'Retail Sale Id 1644567',3498.88,0.00,0.00,6.16,314.16,'2022-02-18 08:15:19','',''),(2653433,'1','208','1038',479,'Retail Sale Id 1644568',4998.40,0.00,0.00,8.80,448.80,'2022-02-18 08:20:40','',''),(2653434,'1','208','1038',479,'Retail Sale Id 1644569',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 08:29:47','',''),(2653435,'1','208','1038',479,'Retail Sale Id 1644570',3408.00,0.00,0.00,6.00,306.00,'2022-02-18 08:33:57','',''),(2653436,'1','208','1038',479,'Retail Sale Id 1644571',3408.00,0.00,0.00,6.00,306.00,'2022-02-18 08:35:43','',''),(2653437,'1','208','1038',479,'Retail Sale Id 1644572',1198.48,0.00,0.00,2.11,107.61,'2022-02-18 08:36:42','',''),(2653438,'1','208','1038',479,'Retail Sale Id 1644573',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 08:46:01','',''),(2653439,'1','208','1038',479,'Retail Sale Id 1644574',1499.52,0.00,0.00,2.64,134.64,'2022-02-18 08:50:34','',''),(2653440,'1','208','1038',479,'Retail Sale Id 1644575',3408.00,0.00,0.00,6.00,306.00,'2022-02-18 08:58:25','',''),(2653441,'1','208','1038',479,'Retail Sale Id 1644576',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 09:03:31','',''),(2653442,'1','208','1038',479,'Retail Sale Id 1644577',5498.24,0.00,0.00,9.68,493.68,'2022-02-18 09:05:13','',''),(2653443,'1','208','1038',479,'Retail Sale Id 1644578',3498.88,0.00,0.00,6.16,314.16,'2022-02-18 09:06:14','',''),(2653444,'1','208','1038',479,'Retail Sale Id 1644578',3498.88,0.00,0.00,6.16,314.16,'2022-02-18 09:06:14','',''),(2653445,'1','208','1038',479,'Retail Sale Id 1644579',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 09:07:46','',''),(2653446,'1','208','1038',479,'Retail Sale Id 1644580',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 09:10:54','',''),(2653447,'1','208','1038',479,'Retail Sale Id 1644581',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 09:11:52','',''),(2653448,'1','208','1038',479,'Retail Sale Id 1644582',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 09:15:46','',''),(2653449,'1','208','1038',479,'Retail Sale Id 1644583',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 09:21:45','',''),(2653450,'1','208','1038',479,'Retail Sale Id 1644584',1749.44,0.00,0.00,3.08,157.08,'2022-02-18 09:24:13','',''),(2653451,'1','208','1038',479,'Retail Sale Id 1644585',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 09:25:30','',''),(2653452,'1','208','1038',479,'Retail Sale Id 1644586',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 09:26:36','',''),(2653453,'1','208','1038',479,'Retail Sale Id 1644587',1499.52,0.00,0.00,2.64,134.64,'2022-02-18 09:28:28','',''),(2653454,'1','208','1038',479,'Retail Sale Id 1644588',3447.76,0.00,0.00,6.07,309.57,'2022-02-18 09:33:10','',''),(2653455,'1','208','1038',479,'Retail Sale Id 1644589',1101.92,0.00,0.00,1.94,98.94,'2022-02-18 09:33:58','',''),(2653456,'1','208','1038',479,'Retail Sale Id 1644590',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 09:37:28','',''),(2653457,'1','208','1038',479,'Retail Sale Id 1644590',2499.20,0.00,0.00,4.40,224.40,'2022-02-18 09:37:28','',''),(2653458,'1','208','1038',479,'Retail Sale Id 1644591',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 09:50:54','',''),(2653459,'1','208','1038',479,'Retail Sale Id 1644592',999.68,0.00,0.00,1.76,89.76,'2022-02-18 09:53:40','',''),(2653460,'1','208','1038',479,'Retail Sale Id 1644593',2840.00,0.00,0.00,5.00,255.00,'2022-02-18 10:00:39','',''),(2653461,'1','208','1038',479,'Retail Sale Id 1644593',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 10:00:39','',''),(2653462,'1','208','1038',479,'Retail Sale Id 1644594',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 10:03:42','',''),(2653463,'1','208','1038',479,'Retail Sale Id 1644595',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 10:11:47','',''),(2653464,'1','208','1038',479,'Retail Sale Id 1644596',3408.00,0.00,0.00,6.00,306.00,'2022-02-18 10:14:12','',''),(2653465,'1','208','1038',479,'Retail Sale Id 1644597',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 10:14:58','',''),(2653466,'1','208','1038',479,'Retail Sale Id 1644598',6997.76,0.00,0.00,12.32,628.32,'2022-02-18 10:15:38','',''),(2653467,'1','208','1038',479,'Retail Sale Id 1644599',999.68,0.00,0.00,1.76,89.76,'2022-02-18 10:19:06','',''),(2653468,'1','208','1038',479,'Retail Sale Id 1644600',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 10:23:40','',''),(2653469,'1','208','1038',479,'Retail Sale Id 1644601',2840.00,0.00,0.00,5.00,255.00,'2022-02-18 10:28:21','',''),(2653470,'1','208','1038',479,'Retail Sale Id 1644605',28400.00,0.00,0.00,50.00,2550.00,'2022-02-18 11:00:48','',''),(2653471,'1','208','1038',479,'Retail Sale Id 1644607',6997.76,0.00,0.00,12.32,628.32,'2022-02-18 11:11:28','',''),(2653472,'1','208','1038',479,'Retail Sale Id 1644608',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 11:14:07','',''),(2653473,'1','208','1038',479,'Retail Sale Id 1644609',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 11:18:04','',''),(2653474,'1','208','1038',479,'Retail Sale Id 1644610',999.68,0.00,0.00,1.76,89.76,'2022-02-18 11:21:44','',''),(2653475,'1','208','1038',479,'Retail Sale Id 1644611',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 11:44:40','',''),(2653476,'1','208','1038',479,'Retail Sale Id 1644612',3498.88,0.00,0.00,6.16,314.16,'2022-02-18 11:49:58','',''),(2653477,'1','208','1038',479,'Retail Sale Id 1644613',2817.28,0.00,0.00,4.96,252.96,'2022-02-18 11:51:06','',''),(2653478,'1','208','1038',479,'Retail Sale Id 1644614',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 11:52:00','',''),(2653479,'1','208','1038',479,'Retail Sale Id 1644615',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 11:53:06','',''),(2653480,'1','208','1038',479,'Retail Sale Id 1644616',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 11:57:29','',''),(2653481,'1','208','1038',479,'Retail Sale Id 1644617',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 11:58:28','',''),(2653482,'1','208','1038',479,'Retail Sale Id 1644618',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 12:02:39','',''),(2653483,'1','208','1038',479,'Retail Sale Id 1644619',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 12:11:56','',''),(2653484,'1','208','1038',479,'Retail Sale Id 1644620',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 12:25:35','',''),(2653485,'1','208','1038',479,'Retail Sale Id 1644621',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 12:27:01','',''),(2653486,'1','208','1038',479,'Retail Sale Id 1644622',999.68,0.00,0.00,1.76,89.76,'2022-02-18 12:29:36','',''),(2653487,'1','208','1038',479,'Retail Sale Id 1644623',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 12:35:13','',''),(2653488,'1','208','1038',479,'Retail Sale Id 1644624',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 12:36:44','',''),(2653489,'1','208','1038',479,'Retail Sale Id 1644625',10002.48,0.00,0.00,17.61,898.11,'2022-02-18 12:41:25','',''),(2653490,'1','208','1038',479,'Retail Sale Id 1644626',2999.04,0.00,0.00,5.28,269.28,'2022-02-18 12:43:07','',''),(2653491,'1','208','1038',479,'Retail Sale Id 1644627',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 12:44:45','',''),(2653492,'1','208','1038',479,'Retail Sale Id 1644628',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 12:54:53','',''),(2653493,'1','208','1038',479,'Retail Sale Id 1644629',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 12:57:45','',''),(2653494,'1','208','1038',479,'Retail Sale Id 1644630',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 13:03:24','',''),(2653495,'1','208','1038',479,'Retail Sale Id 1644631',999.68,0.00,0.00,1.76,89.76,'2022-02-18 13:12:41','',''),(2653496,'1','208','1038',479,'Retail Sale Id 1644632',2499.20,0.00,0.00,4.40,224.40,'2022-02-18 13:19:01','',''),(2653497,'1','208','1038',479,'Retail Sale Id 1644633',4998.40,0.00,0.00,8.80,448.80,'2022-02-18 13:26:01','',''),(2653498,'1','208','1038',479,'Retail Sale Id 1644634',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 13:48:39','',''),(2653499,'1','208','1038',479,'Retail Sale Id 1644635',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 13:58:46','',''),(2653500,'1','208','1038',479,'Retail Sale Id 1644636',3408.00,0.00,0.00,6.00,306.00,'2022-02-18 14:00:00','',''),(2653501,'1','208','1038',479,'Retail Sale Id 1644637',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 14:02:32','',''),(2653502,'1','208','1038',479,'Retail Sale Id 1644638',2840.00,0.00,0.00,5.00,255.00,'2022-02-18 14:06:18','',''),(2653503,'1','208','1038',479,'Retail Sale Id 1644638',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 14:06:18','',''),(2653504,'1','208','1038',479,'Retail Sale Id 1644639',2999.04,0.00,0.00,5.28,269.28,'2022-02-18 14:08:07','',''),(2653505,'1','208','1038',479,'Retail Sale Id 1644640',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 15:09:19','',''),(2653506,'1','208','1038',479,'Retail Sale Id 1644641',999.68,0.00,0.00,1.76,89.76,'2022-02-18 15:33:56','',''),(2653507,'1','208','1038',479,'Retail Sale Id 1644642',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 15:39:57','',''),(2653508,'1','208','1038',479,'Retail Sale Id 1644643',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 15:47:05','',''),(2653509,'1','208','1038',479,'Retail Sale Id 1644644',2999.04,0.00,0.00,5.28,269.28,'2022-02-18 15:48:26','',''),(2653510,'1','208','1038',479,'Retail Sale Id 1644645',4498.56,0.00,0.00,7.92,403.92,'2022-02-18 15:52:10','',''),(2653511,'1','208','1038',479,'Retail Sale Id 1644646',3300.08,0.00,0.00,5.81,296.31,'2022-02-18 15:54:18','',''),(2653512,'1','208','1038',479,'Retail Sale Id 1644647',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 16:01:03','',''),(2653513,'1','208','1038',479,'Retail Sale Id 1644648',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 16:15:27','',''),(2653514,'1','208','1038',479,'Retail Sale Id 1644649',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 16:18:56','',''),(2653515,'1','208','1038',479,'Retail Sale Id 1644650',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 16:24:39','',''),(2653516,'1','208','1038',479,'Retail Sale Id 1644651',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 16:25:38','',''),(2653517,'1','208','1038',479,'Retail Sale Id 1644652',999.68,0.00,0.00,1.76,89.76,'2022-02-18 16:28:02','',''),(2653518,'1','208','1038',479,'Retail Sale Id 1644652',999.68,0.00,0.00,1.76,89.76,'2022-02-18 16:28:02','',''),(2653519,'1','208','1038',479,'Retail Sale Id 1644652',2999.04,0.00,0.00,5.28,269.28,'2022-02-18 16:28:02','',''),(2653520,'1','208','1038',479,'Retail Sale Id 1644653',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 17:00:01','',''),(2653521,'1','208','1038',479,'Retail Sale Id 1644654',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 17:02:02','',''),(2653522,'1','208','1038',479,'Retail Sale Id 1644654',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 17:02:02','',''),(2653523,'1','208','1038',479,'Retail Sale Id 1644655',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 17:09:53','',''),(2653524,'1','208','1038',479,'Retail Sale Id 1644656',1499.52,0.00,0.00,2.64,134.64,'2022-02-18 17:14:13','',''),(2653525,'1','208','1038',479,'Retail Sale Id 1644657',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 17:24:56','',''),(2653526,'1','208','1038',479,'Retail Sale Id 1644658',999.68,0.00,0.00,1.76,89.76,'2022-02-18 17:27:40','',''),(2653527,'1','208','1038',479,'Retail Sale Id 1644659',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 17:33:02','',''),(2653528,'1','208','1038',479,'Retail Sale Id 1644660',2499.20,0.00,0.00,4.40,224.40,'2022-02-18 17:34:45','',''),(2653529,'1','208','1038',479,'Retail Sale Id 1644661',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 17:38:57','',''),(2653530,'1','208','1038',479,'Retail Sale Id 1644662',5680.00,0.00,0.00,10.00,510.00,'2022-02-18 17:40:31','',''),(2653531,'1','208','1038',479,'Retail Sale Id 1644664',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 17:52:22','',''),(2653532,'1','208','1038',479,'Retail Sale Id 1644665',2499.20,0.00,0.00,4.40,224.40,'2022-02-18 17:55:59','',''),(2653533,'1','208','1038',479,'Retail Sale Id 1644666',1147.36,0.00,0.00,2.02,103.02,'2022-02-18 17:57:01','',''),(2653534,'1','208','1038',479,'Retail Sale Id 1644667',3998.72,0.00,0.00,7.04,359.04,'2022-02-18 18:01:23','',''),(2653535,'1','208','1038',479,'Retail Sale Id 1644668',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 18:02:33','',''),(2653536,'1','208','1038',479,'Retail Sale Id 1644669',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 18:04:01','',''),(2653537,'1','208','1038',479,'Retail Sale Id 1644670',3402.32,0.00,0.00,5.99,305.49,'2022-02-18 18:08:26','',''),(2653538,'1','208','1038',479,'Retail Sale Id 1644673',1698.32,0.00,0.00,2.99,152.49,'2022-02-18 18:12:44','',''),(2653539,'1','208','1038',479,'Retail Sale Id 1644674',999.68,0.00,0.00,1.76,89.76,'2022-02-18 18:22:54','',''),(2653540,'1','208','1038',479,'Retail Sale Id 1644675',3408.00,0.00,0.00,6.00,306.00,'2022-02-18 18:27:51','',''),(2653541,'1','208','1038',479,'Retail Sale Id 1644676',2999.04,0.00,0.00,5.28,269.28,'2022-02-18 18:29:35','',''),(2653542,'1','208','1038',479,'Retail Sale Id 1644677',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 18:38:03','',''),(2653543,'1','208','1038',479,'Retail Sale Id 1644678',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 18:40:55','',''),(2653544,'1','208','1038',479,'Retail Sale Id 1644679',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 18:50:05','',''),(2653545,'1','208','1038',479,'Retail Sale Id 1644680',2999.04,0.00,0.00,5.28,269.28,'2022-02-18 18:57:33','',''),(2653546,'1','208','1038',479,'Retail Sale Id 1644681',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 18:59:58','',''),(2653547,'1','208','1038',479,'Retail Sale Id 1644684',5702.72,0.00,0.00,10.04,512.04,'2022-02-18 19:02:20','',''),(2653548,'1','208','1038',479,'Retail Sale Id 1644689',999.68,0.00,0.00,1.76,89.76,'2022-02-18 19:03:48','',''),(2653549,'1','208','1038',479,'Retail Sale Id 1644690',1999.36,0.00,0.00,3.52,179.52,'2022-02-18 19:16:53','',''),(2653550,'1','208','1038',479,'Retail Sale Id 1644692',8520.00,0.00,0.00,15.00,765.00,'2022-02-18 19:21:07','',''),(2653551,'1','208','1038',479,'Retail Sale Id 1644693',1709.68,0.00,0.00,3.01,153.51,'2022-02-18 19:23:11','',''),(2653552,'1','208','1038',479,'Retail Sale Id 1644694',3408.00,0.00,0.00,6.00,306.00,'2022-02-18 19:24:39','',''),(2653553,'1','208','1038',479,'Retail Sale Id 1644694',5680.00,0.00,0.00,10.00,510.00,'2022-02-18 19:24:39','',''),(2653554,'1','208','1038',479,'Retail Sale Id 1644695',3408.00,0.00,0.00,6.00,306.00,'2022-02-18 19:31:52','',''),(2653555,'1','208','1038',479,'Retail Sale Id 1644696',29700.72,0.00,0.00,52.29,2666.79,'2022-02-18 22:00:53','',''),(2653556,'1','208','1038',479,'Retail Sale Id 1644697',44644.80,0.00,0.00,78.60,4008.60,'2022-02-18 22:01:57','',''),(2653557,'1','208','1038',479,'Retail Sale Id 1644698',3498.88,0.00,0.00,6.16,314.16,'2022-02-18 22:03:01','',''),(2653558,'1','208','1038',479,'Retail Sale Id 1644699',7100.00,0.00,0.00,12.50,637.50,'2022-02-18 22:04:30','',''),(2653559,'1','208','1038',479,'Retail Sale Id 1644700',1198.48,0.00,0.00,2.11,107.61,'2022-02-19 07:37:21','',''),(2653560,'1','208','1038',479,'Retail Sale Id 1644701',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 07:38:43','',''),(2653561,'1','208','1038',479,'Retail Sale Id 1644702',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 07:40:22','',''),(2653562,'1','208','1038',479,'Retail Sale Id 1644705',2999.04,0.00,0.00,5.28,269.28,'2022-02-19 07:42:30','',''),(2653563,'1','208','1038',479,'Retail Sale Id 1644706',3498.88,0.00,0.00,6.16,314.16,'2022-02-19 07:46:24','',''),(2653564,'1','208','1038',479,'Retail Sale Id 1644707',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 07:48:13','',''),(2653565,'1','208','1038',479,'Retail Sale Id 1644709',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 07:49:42','',''),(2653566,'1','208','1038',479,'Retail Sale Id 1644709',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 07:49:42','',''),(2653567,'1','208','1038',479,'Retail Sale Id 1644710',999.68,0.00,0.00,1.76,89.76,'2022-02-19 07:51:30','',''),(2653568,'1','208','1038',479,'Retail Sale Id 1644715',1147.36,0.00,0.00,2.02,103.02,'2022-02-19 07:55:31','',''),(2653569,'1','208','1038',479,'Retail Sale Id 1644716',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 08:01:56','',''),(2653570,'1','208','1038',479,'Retail Sale Id 1644717',2840.00,0.00,0.00,5.00,255.00,'2022-02-19 08:16:50','',''),(2653571,'1','208','1038',479,'Retail Sale Id 1644718',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 08:19:25','',''),(2653572,'1','208','1038',479,'Retail Sale Id 1644719',2999.04,0.00,0.00,5.28,269.28,'2022-02-19 08:20:39','',''),(2653573,'1','208','1038',479,'Retail Sale Id 1644720',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 08:22:52','',''),(2653574,'1','208','1038',479,'Retail Sale Id 1644723',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 08:33:29','',''),(2653575,'1','208','1038',479,'Retail Sale Id 1644725',2300.40,0.00,0.00,4.05,206.55,'2022-02-19 08:37:40','',''),(2653576,'1','208','1038',479,'Retail Sale Id 1644726',2840.00,0.00,0.00,5.00,255.00,'2022-02-19 08:44:50','',''),(2653577,'1','208','1038',479,'Retail Sale Id 1644727',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 08:50:40','',''),(2653578,'1','208','1038',479,'Retail Sale Id 1644729',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 09:00:40','',''),(2653579,'1','208','1038',479,'Retail Sale Id 1644729',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 09:00:40','',''),(2653580,'1','208','1038',479,'Retail Sale Id 1644730',1147.36,0.00,0.00,2.02,103.02,'2022-02-19 09:07:52','',''),(2653581,'1','208','1038',479,'Retail Sale Id 1644731',2999.04,0.00,0.00,5.28,269.28,'2022-02-19 09:09:40','',''),(2653582,'1','208','1038',479,'Retail Sale Id 1644732',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 09:12:34','',''),(2653583,'1','208','1038',479,'Retail Sale Id 1644732',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 09:12:34','',''),(2653584,'1','208','1038',479,'Retail Sale Id 1644733',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 09:14:22','',''),(2653585,'1','208','1038',479,'Retail Sale Id 1644735',499.84,0.00,0.00,0.88,44.88,'2022-02-19 09:21:14','',''),(2653586,'1','208','1038',479,'Retail Sale Id 1644736',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 09:23:24','',''),(2653587,'1','208','1038',479,'Retail Sale Id 1644737',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 09:37:19','',''),(2653588,'1','208','1038',479,'Retail Sale Id 1644738',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 09:39:42','',''),(2653589,'1','208','1038',479,'Retail Sale Id 1644738',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 09:39:42','',''),(2653590,'1','208','1038',479,'Retail Sale Id 1644739',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 09:43:22','',''),(2653591,'1','208','1038',479,'Retail Sale Id 1644741',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 09:47:02','',''),(2653592,'1','208','1038',479,'Retail Sale Id 1644742',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 09:48:52','',''),(2653593,'1','208','1038',479,'Retail Sale Id 1644743',4498.56,0.00,0.00,7.92,403.92,'2022-02-19 09:50:55','',''),(2653594,'1','208','1038',479,'Retail Sale Id 1644744',1698.32,0.00,0.00,2.99,152.49,'2022-02-19 09:53:19','',''),(2653595,'1','208','1038',479,'Retail Sale Id 1644744',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 09:53:19','',''),(2653596,'1','208','1038',479,'Retail Sale Id 1644745',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 09:55:32','',''),(2653597,'1','208','1038',479,'Retail Sale Id 1644747',1999.36,0.00,0.00,3.52,179.52,'2022-02-19 09:56:47','',''),(2653598,'1','208','1038',479,'Retail Sale Id 1644748',1999.36,0.00,0.00,3.52,179.52,'2022-02-19 09:58:12','',''),(2653599,'1','208','1038',479,'Retail Sale Id 1644750',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 10:03:23','',''),(2653600,'1','208','1038',479,'Retail Sale Id 1644751',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 10:10:30','',''),(2653601,'1','208','1038',479,'Retail Sale Id 1644752',3447.76,0.00,0.00,6.07,309.57,'2022-02-19 10:12:24','',''),(2653602,'1','208','1038',479,'Retail Sale Id 1644753',2800.24,0.00,0.00,4.93,251.43,'2022-02-19 10:14:11','',''),(2653603,'1','208','1038',479,'Retail Sale Id 1644754',999.68,0.00,0.00,1.76,89.76,'2022-02-19 10:15:12','',''),(2653604,'1','208','1038',479,'Retail Sale Id 1644755',2851.36,0.00,0.00,5.02,256.02,'2022-02-19 10:17:44','',''),(2653605,'1','208','1038',479,'Retail Sale Id 1644756',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 10:19:24','',''),(2653606,'1','208','1038',479,'Retail Sale Id 1644757',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 10:20:57','',''),(2653607,'1','208','1038',479,'Retail Sale Id 1644758',999.68,0.00,0.00,1.76,89.76,'2022-02-19 10:22:48','',''),(2653608,'1','208','1038',479,'Retail Sale Id 1644759',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 10:28:11','',''),(2653609,'1','208','1038',479,'Retail Sale Id 1644760',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 10:32:59','',''),(2653610,'1','208','1038',479,'Retail Sale Id 1644765',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 10:35:08','',''),(2653611,'1','208','1038',479,'Retail Sale Id 1644767',1800.56,0.00,0.00,3.17,161.67,'2022-02-19 10:40:36','',''),(2653612,'1','208','1038',479,'Retail Sale Id 1644768',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 10:42:19','',''),(2653613,'1','208','1038',479,'Retail Sale Id 1644769',2800.24,0.00,0.00,4.93,251.43,'2022-02-19 10:46:37','',''),(2653614,'1','208','1038',479,'Retail Sale Id 1644770',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 10:53:27','',''),(2653615,'1','208','1038',479,'Retail Sale Id 1644771',1698.32,0.00,0.00,2.99,152.49,'2022-02-19 10:56:02','',''),(2653616,'1','208','1038',479,'Retail Sale Id 1644772',1999.36,0.00,0.00,3.52,179.52,'2022-02-19 11:02:41','',''),(2653617,'1','208','1038',479,'Retail Sale Id 1644773',999.68,0.00,0.00,1.76,89.76,'2022-02-19 11:07:56','',''),(2653618,'1','208','1038',479,'Retail Sale Id 1644774',499.84,0.00,0.00,0.88,44.88,'2022-02-19 11:20:58','',''),(2653619,'1','208','1038',479,'Retail Sale Id 1644775',1999.36,0.00,0.00,3.52,179.52,'2022-02-19 11:30:32','',''),(2653620,'1','208','1038',479,'Retail Sale Id 1644776',4998.40,0.00,0.00,8.80,448.80,'2022-02-19 11:35:09','',''),(2653621,'1','208','1038',479,'Retail Sale Id 1644777',1999.36,0.00,0.00,3.52,179.52,'2022-02-19 11:36:36','',''),(2653622,'1','208','1038',479,'Retail Sale Id 1644778',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 11:39:33','',''),(2653623,'1','208','1038',479,'Retail Sale Id 1644778',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 11:39:33','',''),(2653624,'1','208','1038',479,'Retail Sale Id 1644778',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 11:39:33','',''),(2653625,'1','208','1038',479,'Retail Sale Id 1644778',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 11:39:33','',''),(2653626,'1','208','1038',479,'Retail Sale Id 1644779',28400.00,0.00,0.00,50.00,2550.00,'2022-02-19 11:43:09','',''),(2653627,'1','208','1038',479,'Retail Sale Id 1644780',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 11:45:03','',''),(2653628,'1','208','1038',479,'Retail Sale Id 1644781',1698.32,0.00,0.00,2.99,152.49,'2022-02-19 11:46:21','',''),(2653629,'1','208','1038',479,'Retail Sale Id 1644782',2999.04,0.00,0.00,5.28,269.28,'2022-02-19 11:48:42','',''),(2653630,'1','208','1038',479,'Retail Sale Id 1644783',568.00,0.00,0.00,1.00,51.00,'2022-02-19 11:55:01','',''),(2653631,'1','208','1038',479,'Retail Sale Id 1644784',533.92,0.00,0.00,0.94,47.94,'2022-02-19 11:56:25','',''),(2653632,'1','208','1038',479,'Retail Sale Id 1644787',1698.32,0.00,0.00,2.99,152.49,'2022-02-19 12:02:01','',''),(2653633,'1','208','1038',479,'Retail Sale Id 1644788',1698.32,0.00,0.00,2.99,152.49,'2022-02-19 12:05:25','',''),(2653634,'1','208','1038',479,'Retail Sale Id 1644789',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 12:12:34','',''),(2653635,'1','208','1038',479,'Retail Sale Id 1644790',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 12:15:38','',''),(2653636,'1','208','1038',479,'Retail Sale Id 1644790',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 12:15:38','',''),(2653637,'1','208','1038',479,'Retail Sale Id 1644791',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 12:20:32','',''),(2653638,'1','208','1038',479,'Retail Sale Id 1644791',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 12:20:32','',''),(2653639,'1','208','1038',479,'Retail Sale Id 1644791',3419.36,0.00,0.00,6.02,307.02,'2022-02-19 12:20:32','',''),(2653640,'1','208','1038',479,'Retail Sale Id 1644792',1698.32,0.00,0.00,2.99,152.49,'2022-02-19 12:21:35','',''),(2653641,'1','208','1038',479,'Retail Sale Id 1644793',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 12:23:09','',''),(2653642,'1','208','1038',479,'Retail Sale Id 1644794',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 12:24:47','',''),(2653643,'1','208','1038',479,'Retail Sale Id 1644795',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 12:26:40','',''),(2653644,'1','208','1038',479,'Retail Sale Id 1644795',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 12:26:40','',''),(2653645,'1','208','1038',479,'Retail Sale Id 1644796',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 12:28:37','',''),(2653646,'1','208','1038',479,'Retail Sale Id 1644797',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 12:30:46','',''),(2653647,'1','208','1038',479,'Retail Sale Id 1644798',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 12:32:10','',''),(2653648,'1','208','1038',479,'Retail Sale Id 1644799',1999.36,0.00,0.00,3.52,179.52,'2022-02-19 12:33:14','',''),(2653649,'1','208','1038',479,'Retail Sale Id 1644800',14200.00,0.00,0.00,25.00,1275.00,'2022-02-19 12:38:39','',''),(2653650,'1','208','1038',479,'Retail Sale Id 1644801',2999.04,0.00,0.00,5.28,269.28,'2022-02-19 12:41:08','',''),(2653651,'1','208','1038',479,'Retail Sale Id 1644802',1499.52,0.00,0.00,2.64,134.64,'2022-02-19 12:42:23','',''),(2653652,'1','208','1038',479,'Retail Sale Id 1644803',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 12:58:58','',''),(2653653,'1','208','1038',479,'Retail Sale Id 1644804',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 13:01:14','',''),(2653654,'1','208','1038',479,'Retail Sale Id 1644805',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 13:15:16','',''),(2653655,'1','208','1038',479,'Retail Sale Id 1644806',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 13:17:28','',''),(2653656,'1','208','1038',479,'Retail Sale Id 1644807',1709.68,0.00,0.00,3.01,153.51,'2022-02-19 13:21:52','',''),(2653657,'1','208','1038',479,'Retail Sale Id 1644808',5680.00,0.00,0.00,10.00,510.00,'2022-02-19 13:26:36','',''),(2653658,'1','208','1038',479,'Retail Sale Id 1644809',999.68,0.00,0.00,1.76,89.76,'2022-02-19 13:27:41','',''),(2653659,'1','208','1038',479,'Retail Sale Id 1644810',2999.04,0.00,0.00,5.28,269.28,'2022-02-19 13:28:43','',''),(2653660,'1','208','1038',479,'Retail Sale Id 1644811',6997.76,0.00,0.00,12.32,628.32,'2022-02-19 13:30:25','',''),(2653661,'1','208','1038',479,'Retail Sale Id 1644812',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 13:32:11','',''),(2653662,'1','208','1038',479,'Retail Sale Id 1644813',3998.72,0.00,0.00,7.04,359.04,'2022-02-19 13:34:45','',''),(2653663,'1','208','1038',479,'Retail Sale Id 1644814',14200.00,0.00,0.00,25.00,1275.00,'2022-02-19 13:45:11','',''),(2653664,'1','208','1038',479,'Retail Sale Id 1644815',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 13:54:22','',''),(2653665,'1','208','1038',479,'Retail Sale Id 1644816',1698.32,0.00,0.00,2.99,152.49,'2022-02-19 14:05:52','',''),(2653666,'1','208','1038',479,'Retail Sale Id 1644819',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 14:15:06','',''),(2653667,'1','208','1038',479,'Retail Sale Id 1644820',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 14:16:41','',''),(2653668,'1','208','1038',479,'Retail Sale Id 1644822',3419.36,0.00,0.00,6.02,307.02,'2022-02-19 14:21:09','',''),(2653669,'1','208','1038',479,'Retail Sale Id 1644823',2800.24,0.00,0.00,4.93,251.43,'2022-02-19 14:23:19','',''),(2653670,'1','208','1038',479,'Retail Sale Id 1644824',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 14:24:33','',''),(2653671,'1','208','1038',479,'Retail Sale Id 1644825',6798.96,0.00,0.00,11.97,610.47,'2022-02-19 14:26:30','',''),(2653672,'1','208','1038',479,'Retail Sale Id 1644826',1499.52,0.00,0.00,2.64,134.64,'2022-02-19 14:28:00','',''),(2653673,'1','208','1038',479,'Retail Sale Id 1644828',1999.36,0.00,0.00,3.52,179.52,'2022-02-19 14:36:49','',''),(2653674,'1','208','1038',479,'Retail Sale Id 1644829',1698.32,0.00,0.00,2.99,152.49,'2022-02-19 14:44:12','',''),(2653675,'1','208','1038',479,'Retail Sale Id 1644830',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 14:51:03','',''),(2653676,'1','208','1038',479,'Retail Sale Id 1644831',2840.00,0.00,0.00,5.00,255.00,'2022-02-19 14:59:50','',''),(2653677,'1','208','1038',479,'Retail Sale Id 1644832',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 15:05:04','',''),(2653678,'1','208','1038',479,'Retail Sale Id 1644833',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 15:07:33','',''),(2653679,'1','208','1038',479,'Retail Sale Id 1644834',4998.40,0.00,0.00,8.80,448.80,'2022-02-19 15:21:34','',''),(2653680,'1','208','1038',479,'Retail Sale Id 1644835',1999.36,0.00,0.00,3.52,179.52,'2022-02-19 15:27:09','',''),(2653681,'1','208','1038',479,'Retail Sale Id 1644836',3998.72,0.00,0.00,7.04,359.04,'2022-02-19 15:38:01','',''),(2653682,'1','208','1038',479,'Retail Sale Id 1644837',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 15:39:31','',''),(2653683,'1','208','1038',479,'Retail Sale Id 1644838',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 15:46:51','',''),(2653684,'1','208','1038',479,'Retail Sale Id 1644839',897.44,0.00,0.00,1.58,80.58,'2022-02-19 15:50:47','',''),(2653685,'1','208','1038',479,'Retail Sale Id 1644840',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 16:18:14','',''),(2653686,'1','208','1038',479,'Retail Sale Id 1644841',1499.52,0.00,0.00,2.64,134.64,'2022-02-19 16:19:52','',''),(2653687,'1','208','1038',479,'Retail Sale Id 1644842',2999.04,0.00,0.00,5.28,269.28,'2022-02-19 16:23:58','',''),(2653688,'1','208','1038',479,'Retail Sale Id 1644843',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 16:27:47','',''),(2653689,'1','208','1038',479,'Retail Sale Id 1644844',6997.76,0.00,0.00,12.32,628.32,'2022-02-19 16:28:43','',''),(2653690,'1','208','1038',479,'Retail Sale Id 1644845',1499.52,0.00,0.00,2.64,134.64,'2022-02-19 16:29:41','',''),(2653691,'1','208','1038',479,'Retail Sale Id 1644846',2999.04,0.00,0.00,5.28,269.28,'2022-02-19 16:33:34','',''),(2653692,'1','208','1038',479,'Retail Sale Id 1644847',2482.16,0.00,0.00,4.37,222.87,'2022-02-19 16:44:23','',''),(2653693,'1','208','1038',479,'Retail Sale Id 1644848',2300.40,0.00,0.00,4.05,206.55,'2022-02-19 16:50:18','',''),(2653694,'1','208','1038',479,'Retail Sale Id 1644849',3998.72,0.00,0.00,7.04,359.04,'2022-02-19 16:51:49','',''),(2653695,'1','208','1038',479,'Retail Sale Id 1644850',1198.48,0.00,0.00,2.11,107.61,'2022-02-19 17:02:27','',''),(2653696,'1','208','1038',479,'Retail Sale Id 1644851',999.68,0.00,0.00,1.76,89.76,'2022-02-19 17:04:06','',''),(2653697,'1','208','1038',479,'Retail Sale Id 1644852',1698.32,0.00,0.00,2.99,152.49,'2022-02-19 17:11:06','',''),(2653698,'1','208','1038',479,'Retail Sale Id 1644853',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 17:13:15','',''),(2653699,'1','208','1038',479,'Retail Sale Id 1644854',2851.36,0.00,0.00,5.02,256.02,'2022-02-19 17:20:45','',''),(2653700,'1','208','1038',479,'Retail Sale Id 1644855',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 17:21:48','',''),(2653701,'1','208','1038',479,'Retail Sale Id 1644856',1999.36,0.00,0.00,3.52,179.52,'2022-02-19 17:31:27','',''),(2653702,'1','208','1038',479,'Retail Sale Id 1644857',7100.00,0.00,0.00,12.50,637.50,'2022-02-19 17:32:57','',''),(2653703,'1','208','1038',479,'Retail Sale Id 1644858',6997.76,0.00,0.00,12.32,628.32,'2022-02-19 17:43:30','',''),(2653704,'1','208','1038',479,'Retail Sale Id 1644859',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 17:45:17','',''),(2653705,'1','208','1038',479,'Retail Sale Id 1644860',2402.64,0.00,0.00,4.23,215.73,'2022-02-19 17:49:47','',''),(2653706,'1','208','1038',479,'Retail Sale Id 1644861',999.68,0.00,0.00,1.76,89.76,'2022-02-19 17:52:13','',''),(2653707,'1','208','1038',479,'Retail Sale Id 1644862',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 17:59:17','',''),(2653708,'1','208','1038',479,'Retail Sale Id 1644863',5702.72,0.00,0.00,10.04,512.04,'2022-02-19 18:08:36','',''),(2653709,'1','208','1038',479,'Retail Sale Id 1644864',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 18:11:03','',''),(2653710,'1','208','1038',479,'Retail Sale Id 1644865',6997.76,0.00,0.00,12.32,628.32,'2022-02-19 18:13:21','',''),(2653711,'1','208','1038',479,'Retail Sale Id 1644866',2999.04,0.00,0.00,5.28,269.28,'2022-02-19 18:14:29','',''),(2653712,'1','208','1038',479,'Retail Sale Id 1644867',3402.32,0.00,0.00,5.99,305.49,'2022-02-19 18:18:00','',''),(2653713,'1','208','1038',479,'Retail Sale Id 1644868',658.88,0.00,0.00,1.16,59.16,'2022-02-19 18:24:47','',''),(2653714,'1','208','1038',479,'Retail Sale Id 1644869',3498.88,0.00,0.00,6.16,314.16,'2022-02-19 18:47:52','',''),(2653715,'1','208','1038',479,'Retail Sale Id 1644870',3998.72,0.00,0.00,7.04,359.04,'2022-02-19 19:09:39','',''),(2653716,'1','208','1038',479,'Retail Sale Id 1644875',2840.00,0.00,0.00,5.00,255.00,'2022-02-19 19:15:35','',''),(2653717,'1','208','1038',479,'Retail Sale Id 1644875',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 19:15:35','',''),(2653718,'1','208','1038',479,'Retail Sale Id 1644876',999.68,0.00,0.00,1.76,89.76,'2022-02-19 19:16:37','',''),(2653719,'1','208','1038',479,'Retail Sale Id 1644877',602.08,0.00,0.00,1.06,54.06,'2022-02-19 19:18:20','',''),(2653720,'1','208','1038',479,'Retail Sale Id 1644877',999.68,0.00,0.00,1.76,89.76,'2022-02-19 19:18:20','',''),(2653721,'1','208','1038',479,'Retail Sale Id 1644878',28400.00,0.00,0.00,50.00,2550.00,'2022-02-19 19:21:30','',''),(2653722,'1','208','1038',479,'Return of Retail Sale Id 1644778',0.00,1709.68,3.01,0.00,-153.51,'2022-02-19 21:35:31','',''),(2653723,'1','208','1038',479,'Return of Retail Sale Id 1644778',0.00,1709.68,3.01,0.00,-153.51,'2022-02-19 21:35:31','',''),(2653724,'1','208','1038',479,'Return of Retail Sale Id 1644778',0.00,3408.00,6.00,0.00,-306.00,'2022-02-19 21:35:31','',''),(2653725,'1','208','1038',479,'Return of Retail Sale Id 1644778',0.00,3408.00,6.00,0.00,-306.00,'2022-02-19 21:35:31','',''),(2653726,'1','208','1038',479,'Return of Retail Sale Id 1644751',0.00,7100.00,12.50,0.00,-637.50,'2022-02-19 21:37:16','',''),(2653727,'1','208','1038',479,'Return of Retail Sale Id 1644732',0.00,3402.32,5.99,0.00,-305.49,'2022-02-19 21:39:13','',''),(2653728,'1','208','1038',479,'Return of Retail Sale Id 1644732',0.00,7100.00,12.50,0.00,-637.50,'2022-02-19 21:39:13','',''),(2653729,'1','208','1038',479,'Retail Sale Id 1644880',7491.92,0.00,0.00,13.19,672.69,'2022-02-19 21:44:08','',''),(2653730,'1','208','1038',479,'Retail Sale Id 1644881',30933.28,0.00,0.00,54.46,2777.46,'2022-02-19 21:45:17','',''),(2653731,'1','208','1038',479,'Retail Sale Id 1644882',14591.92,0.00,0.00,25.69,1310.19,'2022-02-19 21:46:22','',''),(2653732,'1','208','1038',479,'Retail Sale Id 1644883',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 07:31:42','',''),(2653733,'1','208','1038',479,'Retail Sale Id 1644884',999.68,0.00,0.00,1.76,89.76,'2022-02-20 07:36:37','',''),(2653734,'1','208','1038',479,'Retail Sale Id 1644885',1698.32,0.00,0.00,2.99,152.49,'2022-02-20 07:39:40','',''),(2653735,'1','208','1038',479,'Retail Sale Id 1644886',999.68,0.00,0.00,1.76,89.76,'2022-02-20 07:59:42','',''),(2653736,'1','208','1038',479,'Retail Sale Id 1644887',3498.88,0.00,0.00,6.16,314.16,'2022-02-20 08:01:35','',''),(2653737,'1','208','1038',479,'Retail Sale Id 1644888',1800.56,0.00,0.00,3.17,161.67,'2022-02-20 08:10:36','',''),(2653738,'1','208','1038',479,'Retail Sale Id 1644889',999.68,0.00,0.00,1.76,89.76,'2022-02-20 08:17:19','',''),(2653739,'1','208','1038',479,'Retail Sale Id 1644890',2999.04,0.00,0.00,5.28,269.28,'2022-02-20 08:30:46','',''),(2653740,'1','208','1038',479,'Retail Sale Id 1644891',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 08:34:13','',''),(2653741,'1','208','1038',479,'Retail Sale Id 1644892',3998.72,0.00,0.00,7.04,359.04,'2022-02-20 08:43:04','',''),(2653742,'1','208','1038',479,'Retail Sale Id 1644893',3498.88,0.00,0.00,6.16,314.16,'2022-02-20 08:57:18','',''),(2653743,'1','208','1038',479,'Retail Sale Id 1644893',6997.76,0.00,0.00,12.32,628.32,'2022-02-20 08:57:18','',''),(2653744,'1','208','1038',479,'Retail Sale Id 1644894',3498.88,0.00,0.00,6.16,314.16,'2022-02-20 08:58:16','',''),(2653745,'1','208','1038',479,'Retail Sale Id 1644894',3498.88,0.00,0.00,6.16,314.16,'2022-02-20 08:58:16','',''),(2653746,'1','208','1038',479,'Retail Sale Id 1644895',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 08:59:28','',''),(2653747,'1','208','1038',479,'Retail Sale Id 1644896',7497.60,0.00,0.00,13.20,673.20,'2022-02-20 09:01:01','',''),(2653748,'1','208','1038',479,'Return of Retail Sale Id 1644893',0.00,3498.88,6.16,0.00,-314.16,'2022-02-20 09:02:00','',''),(2653749,'1','208','1038',479,'Return of Retail Sale Id 1644893',0.00,6997.76,12.32,0.00,-628.32,'2022-02-20 09:02:00','',''),(2653750,'1','208','1038',479,'Retail Sale Id 1644897',1499.52,0.00,0.00,2.64,134.64,'2022-02-20 09:06:02','',''),(2653751,'1','208','1038',479,'Retail Sale Id 1644898',4998.40,0.00,0.00,8.80,448.80,'2022-02-20 09:21:06','',''),(2653752,'1','208','1038',479,'Retail Sale Id 1644899',999.68,0.00,0.00,1.76,89.76,'2022-02-20 09:21:54','',''),(2653753,'1','208','1038',479,'Retail Sale Id 1644900',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 09:22:55','',''),(2653754,'1','208','1038',479,'Retail Sale Id 1644901',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 09:24:02','',''),(2653755,'1','208','1038',479,'Retail Sale Id 1644902',2851.36,0.00,0.00,5.02,256.02,'2022-02-20 09:27:01','',''),(2653756,'1','208','1038',479,'Retail Sale Id 1644904',3601.12,0.00,0.00,6.34,323.34,'2022-02-20 09:29:05','',''),(2653757,'1','208','1038',479,'Retail Sale Id 1644905',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 09:35:34','',''),(2653758,'1','208','1038',479,'Retail Sale Id 1644906',3498.88,0.00,0.00,6.16,314.16,'2022-02-20 09:37:14','',''),(2653759,'1','208','1038',479,'Retail Sale Id 1644907',3498.88,0.00,0.00,6.16,314.16,'2022-02-20 09:41:07','',''),(2653760,'1','208','1038',479,'Retail Sale Id 1644908',1499.52,0.00,0.00,2.64,134.64,'2022-02-20 09:41:46','',''),(2653761,'1','208','1038',479,'Retail Sale Id 1644909',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 09:43:28','',''),(2653762,'1','208','1038',479,'Retail Sale Id 1644910',4544.00,0.00,0.00,8.00,408.00,'2022-02-20 09:45:00','',''),(2653763,'1','208','1038',479,'Retail Sale Id 1644910',4544.00,0.00,0.00,8.00,408.00,'2022-02-20 09:45:00','',''),(2653764,'1','208','1038',479,'Retail Sale Id 1644911',1499.52,0.00,0.00,2.64,134.64,'2022-02-20 09:46:14','',''),(2653765,'1','208','1038',479,'Retail Sale Id 1644912',3998.72,0.00,0.00,7.04,359.04,'2022-02-20 09:47:55','',''),(2653766,'1','208','1038',479,'Retail Sale Id 1644913',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 09:48:59','',''),(2653767,'1','208','1038',479,'Retail Sale Id 1644914',999.68,0.00,0.00,1.76,89.76,'2022-02-20 09:50:23','',''),(2653768,'1','208','1038',479,'Retail Sale Id 1644915',999.68,0.00,0.00,1.76,89.76,'2022-02-20 09:55:46','',''),(2653769,'1','208','1038',479,'Retail Sale Id 1644916',3419.36,0.00,0.00,6.02,307.02,'2022-02-20 09:59:40','',''),(2653770,'1','208','1038',479,'Retail Sale Id 1644917',999.68,0.00,0.00,1.76,89.76,'2022-02-20 10:03:01','',''),(2653771,'1','208','1038',479,'Retail Sale Id 1644918',3998.72,0.00,0.00,7.04,359.04,'2022-02-20 10:04:35','',''),(2653772,'1','208','1038',479,'Retail Sale Id 1644919',3498.88,0.00,0.00,6.16,314.16,'2022-02-20 10:08:32','',''),(2653773,'1','208','1038',479,'Retail Sale Id 1644921',1499.52,0.00,0.00,2.64,134.64,'2022-02-20 10:11:39','',''),(2653774,'1','208','1038',479,'Retail Sale Id 1644922',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 10:13:13','',''),(2653775,'1','208','1038',479,'Retail Sale Id 1644923',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 10:15:20','',''),(2653776,'1','208','1038',479,'Retail Sale Id 1644924',1698.32,0.00,0.00,2.99,152.49,'2022-02-20 10:17:27','',''),(2653777,'1','208','1038',479,'Retail Sale Id 1644925',999.68,0.00,0.00,1.76,89.76,'2022-02-20 10:18:10','',''),(2653778,'1','208','1038',479,'Retail Sale Id 1644926',2999.04,0.00,0.00,5.28,269.28,'2022-02-20 10:24:57','',''),(2653779,'1','208','1038',479,'Retail Sale Id 1644927',999.68,0.00,0.00,1.76,89.76,'2022-02-20 10:29:42','',''),(2653780,'1','208','1038',479,'Retail Sale Id 1644929',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 10:36:42','',''),(2653781,'1','208','1038',479,'Retail Sale Id 1644930',499.84,0.00,0.00,0.88,44.88,'2022-02-20 10:51:54','',''),(2653782,'1','208','1038',479,'Retail Sale Id 1644931',2999.04,0.00,0.00,5.28,269.28,'2022-02-20 10:54:25','',''),(2653783,'1','208','1038',479,'Retail Sale Id 1644932',1709.68,0.00,0.00,3.01,153.51,'2022-02-20 11:02:54','',''),(2653784,'1','208','1038',479,'Retail Sale Id 1644934',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 11:05:38','',''),(2653785,'1','208','1038',479,'Retail Sale Id 1644935',3447.76,0.00,0.00,6.07,309.57,'2022-02-20 11:07:06','',''),(2653786,'1','208','1038',479,'Retail Sale Id 1644936',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 11:08:45','',''),(2653787,'1','208','1038',479,'Retail Sale Id 1644937',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 11:16:19','',''),(2653788,'1','208','1038',479,'Retail Sale Id 1644938',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 11:27:17','',''),(2653789,'1','208','1038',479,'Retail Sale Id 1644939',1198.48,0.00,0.00,2.11,107.61,'2022-02-20 11:30:33','',''),(2653790,'1','208','1038',479,'Retail Sale Id 1644940',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 11:32:06','',''),(2653791,'1','208','1038',479,'Retail Sale Id 1644941',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 11:35:01','',''),(2653792,'1','208','1038',479,'Retail Sale Id 1644942',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 11:37:54','',''),(2653793,'1','208','1038',479,'Retail Sale Id 1644943',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 11:41:22','',''),(2653794,'1','208','1038',479,'Retail Sale Id 1644944',3498.88,0.00,0.00,6.16,314.16,'2022-02-20 11:54:10','',''),(2653795,'1','208','1038',479,'Retail Sale Id 1644945',999.68,0.00,0.00,1.76,89.76,'2022-02-20 11:55:13','',''),(2653796,'1','208','1038',479,'Retail Sale Id 1644946',1198.48,0.00,0.00,2.11,107.61,'2022-02-20 11:57:13','',''),(2653797,'1','208','1038',479,'Retail Sale Id 1644947',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 12:04:27','',''),(2653798,'1','208','1038',479,'Retail Sale Id 1644948',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 12:07:22','',''),(2653799,'1','208','1038',479,'Retail Sale Id 1644949',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 12:14:21','',''),(2653800,'1','208','1038',479,'Retail Sale Id 1644950',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 12:15:30','',''),(2653801,'1','208','1038',479,'Retail Sale Id 1644951',1800.56,0.00,0.00,3.17,161.67,'2022-02-20 12:16:13','',''),(2653802,'1','208','1038',479,'Retail Sale Id 1644952',2999.04,0.00,0.00,5.28,269.28,'2022-02-20 12:19:32','',''),(2653803,'1','208','1038',479,'Retail Sale Id 1644953',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 12:21:03','',''),(2653804,'1','208','1038',479,'Retail Sale Id 1644954',999.68,0.00,0.00,1.76,89.76,'2022-02-20 12:23:54','',''),(2653805,'1','208','1038',479,'Retail Sale Id 1644956',1698.32,0.00,0.00,2.99,152.49,'2022-02-20 12:25:15','',''),(2653806,'1','208','1038',479,'Retail Sale Id 1644957',2999.04,0.00,0.00,5.28,269.28,'2022-02-20 12:29:42','',''),(2653807,'1','208','1038',479,'Retail Sale Id 1644958',1499.52,0.00,0.00,2.64,134.64,'2022-02-20 12:35:06','',''),(2653808,'1','208','1038',479,'Retail Sale Id 1644959',2499.20,0.00,0.00,4.40,224.40,'2022-02-20 12:37:11','',''),(2653809,'1','208','1038',479,'Retail Sale Id 1644960',2999.04,0.00,0.00,5.28,269.28,'2022-02-20 12:40:48','',''),(2653810,'1','208','1038',479,'Retail Sale Id 1644961',499.84,0.00,0.00,0.88,44.88,'2022-02-20 12:41:32','',''),(2653811,'1','208','1038',479,'Retail Sale Id 1644962',3498.88,0.00,0.00,6.16,314.16,'2022-02-20 12:46:36','',''),(2653812,'1','208','1038',479,'Retail Sale Id 1644963',2999.04,0.00,0.00,5.28,269.28,'2022-02-20 12:47:27','',''),(2653813,'1','208','1038',479,'Retail Sale Id 1644964',1198.48,0.00,0.00,2.11,107.61,'2022-02-20 12:48:04','',''),(2653814,'1','208','1038',479,'Retail Sale Id 1644965',5702.72,0.00,0.00,10.04,512.04,'2022-02-20 12:51:37','',''),(2653815,'1','208','1038',479,'Retail Sale Id 1644966',800.88,0.00,0.00,1.41,71.91,'2022-02-20 12:55:58','',''),(2653816,'1','208','1038',479,'Retail Sale Id 1644967',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 13:05:15','',''),(2653817,'1','208','1038',479,'Retail Sale Id 1644968',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 13:09:16','',''),(2653818,'1','208','1038',479,'Retail Sale Id 1644969',3402.32,0.00,0.00,5.99,305.49,'2022-02-20 13:14:35','',''),(2653819,'1','208','1038',479,'Retail Sale Id 1644970',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 13:16:07','',''),(2653820,'1','208','1038',479,'Retail Sale Id 1644971',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 13:17:55','',''),(2653821,'1','208','1038',479,'Retail Sale Id 1644972',1709.68,0.00,0.00,3.01,153.51,'2022-02-20 13:27:13','',''),(2653822,'1','208','1038',479,'Retail Sale Id 1644973',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 13:28:01','',''),(2653823,'1','208','1038',479,'Retail Sale Id 1644975',2499.20,0.00,0.00,4.40,224.40,'2022-02-20 13:30:51','',''),(2653824,'1','208','1038',479,'Retail Sale Id 1644974',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 13:31:11','',''),(2653825,'1','208','1038',479,'Retail Sale Id 1644976',2851.36,0.00,0.00,5.02,256.02,'2022-02-20 13:32:10','',''),(2653826,'1','208','1038',479,'Retail Sale Id 1644977',999.68,0.00,0.00,1.76,89.76,'2022-02-20 13:37:37','',''),(2653827,'1','208','1038',479,'Retail Sale Id 1644978',2999.04,0.00,0.00,5.28,269.28,'2022-02-20 13:44:50','',''),(2653828,'1','208','1038',479,'Retail Sale Id 1644979',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 13:45:37','',''),(2653829,'1','208','1038',479,'Retail Sale Id 1644980',6997.76,0.00,0.00,12.32,628.32,'2022-02-20 13:54:29','',''),(2653830,'1','208','1038',479,'Retail Sale Id 1644981',2999.04,0.00,0.00,5.28,269.28,'2022-02-20 13:59:31','',''),(2653831,'1','208','1038',479,'Retail Sale Id 1644982',1147.36,0.00,0.00,2.02,103.02,'2022-02-20 14:00:17','',''),(2653832,'1','208','1038',479,'Retail Sale Id 1644983',999.68,0.00,0.00,1.76,89.76,'2022-02-20 14:04:52','',''),(2653833,'1','208','1038',479,'Retail Sale Id 1644984',5998.08,0.00,0.00,10.56,538.56,'2022-02-20 14:08:40','',''),(2653834,'1','208','1038',479,'Retail Sale Id 1644985',1300.72,0.00,0.00,2.29,116.79,'2022-02-20 14:10:28','',''),(2653835,'1','208','1038',479,'Retail Sale Id 1644985',2499.20,0.00,0.00,4.40,224.40,'2022-02-20 14:10:28','',''),(2653836,'1','208','1038',479,'Retail Sale Id 1644986',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 14:13:31','',''),(2653837,'1','208','1038',479,'Retail Sale Id 1644987',1709.68,0.00,0.00,3.01,153.51,'2022-02-20 14:14:33','',''),(2653838,'1','208','1038',479,'Retail Sale Id 1644988',5702.72,0.00,0.00,10.04,512.04,'2022-02-20 14:18:34','',''),(2653839,'1','208','1038',479,'Retail Sale Id 1644989',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 14:19:31','',''),(2653840,'1','208','1038',479,'Retail Sale Id 1644990',1198.48,0.00,0.00,2.11,107.61,'2022-02-20 14:20:08','',''),(2653841,'1','208','1038',479,'Retail Sale Id 1644991',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 14:33:06','',''),(2653842,'1','208','1038',479,'Retail Sale Id 1644992',999.68,0.00,0.00,1.76,89.76,'2022-02-20 14:39:38','',''),(2653843,'1','208','1038',479,'Retail Sale Id 1644993',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 14:40:42','',''),(2653844,'1','208','1038',479,'Retail Sale Id 1644994',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 14:44:52','',''),(2653845,'1','208','1038',479,'Retail Sale Id 1644995',5680.00,0.00,0.00,10.00,510.00,'2022-02-20 15:04:01','',''),(2653846,'1','208','1038',479,'Retail Sale Id 1644996',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 15:27:18','',''),(2653847,'1','208','1038',479,'Retail Sale Id 1644997',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 15:29:04','',''),(2653848,'1','208','1038',479,'Retail Sale Id 1644998',1499.52,0.00,0.00,2.64,134.64,'2022-02-20 15:30:26','',''),(2653849,'1','208','1038',479,'Retail Sale Id 1644999',1709.68,0.00,0.00,3.01,153.51,'2022-02-20 15:31:12','',''),(2653850,'1','208','1038',479,'Retail Sale Id 1645000',2999.04,0.00,0.00,5.28,269.28,'2022-02-20 15:31:56','',''),(2653851,'1','208','1038',479,'Retail Sale Id 1645001',6248.00,0.00,0.00,11.00,561.00,'2022-02-20 15:33:41','',''),(2653852,'1','208','1038',479,'Retail Sale Id 1645002',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 16:02:21','',''),(2653853,'1','208','1038',479,'Retail Sale Id 1645003',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 16:06:48','',''),(2653854,'1','208','1038',479,'Retail Sale Id 1645004',28400.00,0.00,0.00,50.00,2550.00,'2022-02-20 16:10:36','',''),(2653855,'1','208','1038',479,'Retail Sale Id 1645005',999.68,0.00,0.00,1.76,89.76,'2022-02-20 16:12:27','',''),(2653856,'1','208','1038',479,'Retail Sale Id 1645006',5680.00,0.00,0.00,10.00,510.00,'2022-02-20 16:37:00','',''),(2653857,'1','208','1038',479,'Retail Sale Id 1645007',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 16:38:27','',''),(2653858,'1','208','1038',479,'Retail Sale Id 1645008',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 16:39:32','',''),(2653859,'1','208','1038',479,'Retail Sale Id 1645009',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 16:41:01','',''),(2653860,'1','208','1038',479,'Retail Sale Id 1645010',3998.72,0.00,0.00,7.04,359.04,'2022-02-20 16:41:48','',''),(2653861,'1','208','1038',479,'Retail Sale Id 1645011',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 16:45:13','',''),(2653862,'1','208','1038',479,'Retail Sale Id 1645013',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 16:47:57','',''),(2653863,'1','208','1038',479,'Retail Sale Id 1645014',1709.68,0.00,0.00,3.01,153.51,'2022-02-20 16:50:55','',''),(2653864,'1','208','1038',479,'Retail Sale Id 1645014',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 16:50:55','',''),(2653865,'1','208','1038',479,'Retail Sale Id 1645015',1709.68,0.00,0.00,3.01,153.51,'2022-02-20 16:52:07','',''),(2653866,'1','208','1038',479,'Retail Sale Id 1645016',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 16:57:46','',''),(2653867,'1','208','1038',479,'Retail Sale Id 1645017',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 17:01:43','',''),(2653868,'1','208','1038',479,'Retail Sale Id 1645017',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 17:01:43','',''),(2653869,'1','208','1038',479,'Retail Sale Id 1645017',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 17:01:43','',''),(2653870,'1','208','1038',479,'Retail Sale Id 1645018',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 17:03:57','',''),(2653871,'1','208','1038',479,'Retail Sale Id 1645019',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 17:05:33','',''),(2653872,'1','208','1038',479,'Retail Sale Id 1645020',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 17:09:55','',''),(2653873,'1','208','1038',479,'Retail Sale Id 1645020',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 17:09:55','',''),(2653874,'1','208','1038',479,'Retail Sale Id 1645021',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 17:11:22','',''),(2653875,'1','208','1038',479,'Retail Sale Id 1645021',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 17:11:22','',''),(2653876,'1','208','1038',479,'Retail Sale Id 1645022',2300.40,0.00,0.00,4.05,206.55,'2022-02-20 17:14:06','',''),(2653877,'1','208','1038',479,'Retail Sale Id 1645023',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 17:17:23','',''),(2653878,'1','208','1038',479,'Retail Sale Id 1645024',1709.68,0.00,0.00,3.01,153.51,'2022-02-20 17:20:23','',''),(2653879,'1','208','1038',479,'Retail Sale Id 1645025',1709.68,0.00,0.00,3.01,153.51,'2022-02-20 17:25:16','',''),(2653880,'1','208','1038',479,'Retail Sale Id 1645026',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 17:28:33','',''),(2653881,'1','208','1038',479,'Retail Sale Id 1645027',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 17:30:05','',''),(2653882,'1','208','1038',479,'Retail Sale Id 1645029',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 17:31:26','',''),(2653883,'1','208','1038',479,'Retail Sale Id 1645030',1499.52,0.00,0.00,2.64,134.64,'2022-02-20 17:32:34','',''),(2653884,'1','208','1038',479,'Retail Sale Id 1645031',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 17:37:59','',''),(2653885,'1','208','1038',479,'Retail Sale Id 1645031',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 17:37:59','',''),(2653886,'1','208','1038',479,'Retail Sale Id 1645032',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 17:47:37','',''),(2653887,'1','208','1038',479,'Retail Sale Id 1645033',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 17:48:37','',''),(2653888,'1','208','1038',479,'Retail Sale Id 1645034',999.68,0.00,0.00,1.76,89.76,'2022-02-20 17:49:48','',''),(2653889,'1','208','1038',479,'Retail Sale Id 1645035',999.68,0.00,0.00,1.76,89.76,'2022-02-20 17:51:16','',''),(2653890,'1','208','1038',479,'Retail Sale Id 1645036',1709.68,0.00,0.00,3.01,153.51,'2022-02-20 17:52:34','',''),(2653891,'1','208','1038',479,'Retail Sale Id 1645037',2499.20,0.00,0.00,4.40,224.40,'2022-02-20 18:03:03','',''),(2653892,'1','208','1038',479,'Retail Sale Id 1645039',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 18:06:18','',''),(2653893,'1','208','1038',479,'Retail Sale Id 1645040',1709.68,0.00,0.00,3.01,153.51,'2022-02-20 18:08:04','',''),(2653894,'1','208','1038',479,'Retail Sale Id 1645040',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 18:08:04','',''),(2653895,'1','208','1038',479,'Retail Sale Id 1645040',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 18:08:04','',''),(2653896,'1','208','1038',479,'Retail Sale Id 1645042',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 18:31:52','',''),(2653897,'1','208','1038',479,'Retail Sale Id 1645043',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 18:38:42','',''),(2653898,'1','208','1038',479,'Retail Sale Id 1645044',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 18:42:55','',''),(2653899,'1','208','1038',479,'Retail Sale Id 1645046',6997.76,0.00,0.00,12.32,628.32,'2022-02-20 18:45:26','',''),(2653900,'1','208','1038',479,'Retail Sale Id 1645047',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 18:46:49','',''),(2653901,'1','208','1038',479,'Retail Sale Id 1645048',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 19:03:14','',''),(2653902,'1','208','1038',479,'Retail Sale Id 1645049',1999.36,0.00,0.00,3.52,179.52,'2022-02-20 19:07:04','',''),(2653903,'1','208','1038',479,'Retail Sale Id 1645051',2300.40,0.00,0.00,4.05,206.55,'2022-02-20 19:13:03','',''),(2653904,'1','208','1038',479,'Retail Sale Id 1645052',698.64,0.00,0.00,1.23,62.73,'2022-02-20 20:57:47','',''),(2653905,'1','208','1038',479,'Retail Sale Id 1645053',12501.68,0.00,0.00,22.01,1122.51,'2022-02-20 20:58:42','',''),(2653906,'1','208','1038',479,'Retail Sale Id 1645054',4402.00,0.00,0.00,7.75,395.25,'2022-02-20 20:59:42','',''),(2653907,'1','208','1038',479,'Retail Sale Id 1645055',5.68,0.00,0.00,0.01,0.51,'2022-02-20 21:04:39','',''),(2653908,'1','208','1038',479,'Retail Sale Id 1645056',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 07:32:57','',''),(2653909,'1','208','1038',479,'Retail Sale Id 1645057',1698.32,0.00,0.00,2.99,152.49,'2022-02-21 07:38:18','',''),(2653910,'1','208','1038',479,'Retail Sale Id 1645057',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 07:38:18','',''),(2653911,'1','208','1038',479,'Retail Sale Id 1645058',1709.68,0.00,0.00,3.01,153.51,'2022-02-21 07:39:58','',''),(2653912,'1','208','1038',479,'Retail Sale Id 1645059',3402.32,0.00,0.00,5.99,305.49,'2022-02-21 07:48:41','',''),(2653913,'1','208','1038',479,'Retail Sale Id 1645059',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 07:48:41','',''),(2653914,'1','208','1038',479,'Retail Sale Id 1645060',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 08:02:44','',''),(2653915,'1','208','1038',479,'Retail Sale Id 1645061',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 08:03:42','',''),(2653916,'1','208','1038',479,'Retail Sale Id 1645062',698.64,0.00,0.00,1.23,62.73,'2022-02-21 08:06:15','',''),(2653917,'1','208','1038',479,'Retail Sale Id 1645063',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 08:07:12','',''),(2653918,'1','208','1038',479,'Retail Sale Id 1645064',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 08:08:19','',''),(2653919,'1','208','1038',479,'Retail Sale Id 1645065',3498.88,0.00,0.00,6.16,314.16,'2022-02-21 08:09:19','',''),(2653920,'1','208','1038',479,'Retail Sale Id 1645066',2800.24,0.00,0.00,4.93,251.43,'2022-02-21 08:10:58','',''),(2653921,'1','208','1038',479,'Retail Sale Id 1645067',3998.72,0.00,0.00,7.04,359.04,'2022-02-21 08:11:34','',''),(2653922,'1','208','1038',479,'Retail Sale Id 1645068',2999.04,0.00,0.00,5.28,269.28,'2022-02-21 08:12:42','',''),(2653923,'1','208','1038',479,'Retail Sale Id 1645068',2999.04,0.00,0.00,5.28,269.28,'2022-02-21 08:12:42','',''),(2653924,'1','208','1038',479,'Retail Sale Id 1645069',2999.04,0.00,0.00,5.28,269.28,'2022-02-21 08:13:19','',''),(2653925,'1','208','1038',479,'Retail Sale Id 1645070',3402.32,0.00,0.00,5.99,305.49,'2022-02-21 08:17:56','',''),(2653926,'1','208','1038',479,'Retail Sale Id 1645071',2999.04,0.00,0.00,5.28,269.28,'2022-02-21 08:21:37','',''),(2653927,'1','208','1038',479,'Retail Sale Id 1645072',2800.24,0.00,0.00,4.93,251.43,'2022-02-21 08:26:25','',''),(2653928,'1','208','1038',479,'Retail Sale Id 1645073',2902.48,0.00,0.00,5.11,260.61,'2022-02-21 08:36:26','',''),(2653929,'1','208','1038',479,'Retail Sale Id 1645074',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 08:40:55','',''),(2653930,'1','208','1038',479,'Retail Sale Id 1645075',6997.76,0.00,0.00,12.32,628.32,'2022-02-21 09:10:11','',''),(2653931,'1','208','1038',479,'Retail Sale Id 1645076',2499.20,0.00,0.00,4.40,224.40,'2022-02-21 09:10:55','',''),(2653932,'1','208','1038',479,'Retail Sale Id 1645077',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 09:12:23','',''),(2653933,'1','208','1038',479,'Retail Sale Id 1645077',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 09:12:23','',''),(2653934,'1','208','1038',479,'Retail Sale Id 1645078',3498.88,0.00,0.00,6.16,314.16,'2022-02-21 09:14:30','',''),(2653935,'1','208','1038',479,'Retail Sale Id 1645079',4998.40,0.00,0.00,8.80,448.80,'2022-02-21 09:19:09','',''),(2653936,'1','208','1038',479,'Retail Sale Id 1645081',499.84,0.00,0.00,0.88,44.88,'2022-02-21 09:31:59','',''),(2653937,'1','208','1038',479,'Retail Sale Id 1645082',499.84,0.00,0.00,0.88,44.88,'2022-02-21 09:32:33','',''),(2653938,'1','208','1038',479,'Retail Sale Id 1645083',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 09:33:33','',''),(2653939,'1','208','1038',479,'Retail Sale Id 1645084',1198.48,0.00,0.00,2.11,107.61,'2022-02-21 09:38:10','',''),(2653940,'1','208','1038',479,'Retail Sale Id 1645085',5498.24,0.00,0.00,9.68,493.68,'2022-02-21 10:01:35','',''),(2653941,'1','208','1038',479,'Retail Sale Id 1645086',3498.88,0.00,0.00,6.16,314.16,'2022-02-21 10:08:22','',''),(2653942,'1','208','1038',479,'Retail Sale Id 1645087',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 10:20:23','',''),(2653943,'1','208','1038',479,'Retail Sale Id 1645088',1999.36,0.00,0.00,3.52,179.52,'2022-02-21 10:23:00','',''),(2653944,'1','208','1038',479,'Retail Sale Id 1645089',1999.36,0.00,0.00,3.52,179.52,'2022-02-21 10:27:48','',''),(2653945,'1','208','1038',479,'Retail Sale Id 1645090',3402.32,0.00,0.00,5.99,305.49,'2022-02-21 10:32:37','',''),(2653946,'1','208','1038',479,'Retail Sale Id 1645091',2499.20,0.00,0.00,4.40,224.40,'2022-02-21 10:35:00','',''),(2653947,'1','208','1038',479,'Retail Sale Id 1645092',499.84,0.00,0.00,0.88,44.88,'2022-02-21 10:36:20','',''),(2653948,'1','208','1038',479,'Retail Sale Id 1645093',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 10:40:56','',''),(2653949,'1','208','1038',479,'Retail Sale Id 1645094',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 10:46:41','',''),(2653950,'1','208','1038',479,'Retail Sale Id 1645095',3498.88,0.00,0.00,6.16,314.16,'2022-02-21 10:47:55','',''),(2653951,'1','208','1038',479,'Retail Sale Id 1645096',3498.88,0.00,0.00,6.16,314.16,'2022-02-21 10:53:30','',''),(2653952,'1','208','1038',479,'Retail Sale Id 1645097',2840.00,0.00,0.00,5.00,255.00,'2022-02-21 11:07:31','',''),(2653953,'1','208','1038',479,'Retail Sale Id 1645098',4998.40,0.00,0.00,8.80,448.80,'2022-02-21 11:08:09','',''),(2653954,'1','208','1038',479,'Retail Sale Id 1645099',1499.52,0.00,0.00,2.64,134.64,'2022-02-21 11:11:53','',''),(2653955,'1','208','1038',479,'Retail Sale Id 1645100',2999.04,0.00,0.00,5.28,269.28,'2022-02-21 11:18:11','',''),(2653956,'1','208','1038',479,'Retail Sale Id 1645101',1999.36,0.00,0.00,3.52,179.52,'2022-02-21 11:26:43','',''),(2653957,'1','208','1038',479,'Retail Sale Id 1645102',999.68,0.00,0.00,1.76,89.76,'2022-02-21 11:33:27','',''),(2653958,'1','208','1038',479,'Retail Sale Id 1645103',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 11:37:27','',''),(2653959,'1','208','1038',479,'Retail Sale Id 1645105',3498.88,0.00,0.00,6.16,314.16,'2022-02-21 11:57:57','',''),(2653960,'1','208','1038',479,'Retail Sale Id 1645106',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 12:02:14','',''),(2653961,'1','208','1038',479,'Retail Sale Id 1645107',1136.00,0.00,0.00,2.00,102.00,'2022-02-21 12:04:24','',''),(2653962,'1','208','1038',479,'Retail Sale Id 1645107',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 12:04:24','',''),(2653963,'1','208','1038',479,'Retail Sale Id 1645108',1999.36,0.00,0.00,3.52,179.52,'2022-02-21 12:14:08','',''),(2653964,'1','208','1038',479,'Retail Sale Id 1645109',1999.36,0.00,0.00,3.52,179.52,'2022-02-21 12:19:24','',''),(2653965,'1','208','1038',479,'Retail Sale Id 1645111',13064.00,0.00,0.00,23.00,1173.00,'2022-02-21 12:21:51','',''),(2653966,'1','208','1038',479,'Retail Sale Id 1645112',1800.56,0.00,0.00,3.17,161.67,'2022-02-21 12:23:41','',''),(2653967,'1','208','1038',479,'Retail Sale Id 1645113',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 12:24:25','',''),(2653968,'1','208','1038',479,'Retail Sale Id 1645114',1999.36,0.00,0.00,3.52,179.52,'2022-02-21 12:25:12','',''),(2653969,'1','208','1038',479,'Retail Sale Id 1645115',999.68,0.00,0.00,1.76,89.76,'2022-02-21 12:25:54','',''),(2653970,'1','208','1038',479,'Retail Sale Id 1645116',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 12:26:34','',''),(2653971,'1','208','1038',479,'Retail Sale Id 1645117',999.68,0.00,0.00,1.76,89.76,'2022-02-21 12:47:04','',''),(2653972,'1','208','1038',479,'Retail Sale Id 1645118',2499.20,0.00,0.00,4.40,224.40,'2022-02-21 12:48:15','',''),(2653973,'1','208','1038',479,'Retail Sale Id 1645119',2300.40,0.00,0.00,4.05,206.55,'2022-02-21 12:52:47','',''),(2653974,'1','208','1038',479,'Retail Sale Id 1645120',1999.36,0.00,0.00,3.52,179.52,'2022-02-21 12:57:40','',''),(2653975,'1','208','1038',479,'Retail Sale Id 1645121',1499.52,0.00,0.00,2.64,134.64,'2022-02-21 13:01:32','',''),(2653976,'1','208','1038',479,'Retail Sale Id 1645122',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 13:09:12','',''),(2653977,'1','208','1038',479,'Retail Sale Id 1645123',1499.52,0.00,0.00,2.64,134.64,'2022-02-21 13:14:00','',''),(2653978,'1','208','1038',479,'Retail Sale Id 1645124',2840.00,0.00,0.00,5.00,255.00,'2022-02-21 13:21:21','',''),(2653979,'1','208','1038',479,'Retail Sale Id 1645124',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 13:21:21','',''),(2653980,'1','208','1038',479,'Retail Sale Id 1645125',1800.56,0.00,0.00,3.17,161.67,'2022-02-21 13:22:45','',''),(2653981,'1','208','1038',479,'Retail Sale Id 1645126',6997.76,0.00,0.00,12.32,628.32,'2022-02-21 13:24:14','',''),(2653982,'1','208','1038',479,'Retail Sale Id 1645127',6997.76,0.00,0.00,12.32,628.32,'2022-02-21 13:25:28','',''),(2653983,'1','208','1038',479,'Retail Sale Id 1645128',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 13:29:01','',''),(2653984,'1','208','1038',479,'Retail Sale Id 1645128',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 13:29:01','',''),(2653985,'1','208','1038',479,'Retail Sale Id 1645129',3998.72,0.00,0.00,7.04,359.04,'2022-02-21 13:30:05','',''),(2653986,'1','208','1038',479,'Retail Sale Id 1645130',3402.32,0.00,0.00,5.99,305.49,'2022-02-21 13:31:34','',''),(2653987,'1','208','1038',479,'Retail Sale Id 1645130',3402.32,0.00,0.00,5.99,305.49,'2022-02-21 13:31:34','',''),(2653988,'1','208','1038',479,'Retail Sale Id 1645131',3498.88,0.00,0.00,6.16,314.16,'2022-02-21 13:32:44','',''),(2653989,'1','208','1038',479,'Retail Sale Id 1645132',1698.32,0.00,0.00,2.99,152.49,'2022-02-21 13:33:46','',''),(2653990,'1','208','1038',479,'Retail Sale Id 1645133',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 13:35:31','',''),(2653991,'1','208','1038',479,'Retail Sale Id 1645134',2999.04,0.00,0.00,5.28,269.28,'2022-02-21 13:38:34','',''),(2653992,'1','208','1038',479,'Retail Sale Id 1645135',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 13:41:48','',''),(2653993,'1','208','1038',479,'Retail Sale Id 1645136',2800.24,0.00,0.00,4.93,251.43,'2022-02-21 13:52:36','',''),(2653994,'1','208','1038',479,'Retail Sale Id 1645137',2402.64,0.00,0.00,4.23,215.73,'2022-02-21 13:53:24','',''),(2653995,'1','208','1038',479,'Retail Sale Id 1645138',999.68,0.00,0.00,1.76,89.76,'2022-02-21 14:08:18','',''),(2653996,'1','208',NULL,479,'Reception corrector for bridging 132393',0.00,0.00,0.00,5000.00,0.00,'2022-02-21 14:15:24','',''),(2653997,'1','208','1038',479,'Received from bridging 132393',0.00,0.00,5000.00,0.00,0.00,'2022-02-21 14:15:24','',''),(2653998,'1','208','1038',479,'Retail Sale Id 1645140',4998.40,0.00,0.00,8.80,448.80,'2022-02-21 14:18:24','',''),(2653999,'1','208','1038',479,'Retail Sale Id 1645141',2499.20,0.00,0.00,4.40,224.40,'2022-02-21 14:23:42','',''),(2654000,'1','208','1038',479,'Retail Sale Id 1645142',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 14:25:44','',''),(2654001,'1','208','1038',479,'Retail Sale Id 1645143',1709.68,0.00,0.00,3.01,153.51,'2022-02-21 14:29:17','',''),(2654002,'1','208','1038',479,'Retail Sale Id 1645144',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 14:31:34','',''),(2654003,'1','208','1038',479,'Retail Sale Id 1645145',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 14:34:56','',''),(2654004,'1','208','1038',479,'Retail Sale Id 1645146',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 14:36:19','',''),(2654005,'1','208','1038',479,'Retail Sale Id 1645147',6997.76,0.00,0.00,12.32,628.32,'2022-02-21 14:37:01','',''),(2654006,'1','208','1038',479,'Retail Sale Id 1645148',1999.36,0.00,0.00,3.52,179.52,'2022-02-21 14:40:09','',''),(2654007,'1','208','1038',479,'Retail Sale Id 1645149',999.68,0.00,0.00,1.76,89.76,'2022-02-21 14:41:45','',''),(2654008,'1','208',