-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_206
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_206`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_206` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_206`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4069 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3992,400363,'',0,'24','1','206','SALARIES','','2021-12-10 11:41:43',5,0.00,0.00,'','178','2021-12-10 11:41:43','178',0,0),(3993,400364,'',0,'24','1','206','PURCHASES','','2021-12-10 11:41:56',5,0.00,0.00,'','178','2021-12-10 11:41:56','178',0,0),(3994,20062,'',0,'20','1','206','SALES','','2021-12-10 11:42:07',5,0.00,0.00,'','178','2021-12-10 11:42:07','178',0,0),(3995,40064,'',0,'6.1','1','206','CASH','','2021-12-10 11:42:15',5,0.00,0.00,'','178','2021-12-10 11:42:15','178',0,0),(3996,40037,'',0,'14','1','206','CASH IMPREST','','2021-12-10 11:42:27',5,0.00,0.00,'','178','2021-12-10 11:42:27','178',0,0),(3997,400365,'',0,'24','1','206','FUELING AND REPAIRS OF OFFICIA','','2021-12-10 11:42:36',5,0.00,0.00,'','178','2021-12-10 11:42:36','178',0,0),(3998,400366,'',0,'24','1','206','COMPUTER & INTERNET SUBSCRIPTI','','2021-12-10 11:43:00',5,0.00,0.00,'','178','2021-12-10 11:43:00','178',0,0),(4009,400707,'',0,'2','1','206','ZNB EBILLS COLLECTION ACCOUNT','','2021-12-13 13:47:02',5,0.00,0.00,'','178','2021-12-13 13:47:02','178',0,0),(4023,400713,'',0,'2','1','206','FIDELITY POS','','2021-12-24 09:04:17',5,0.00,0.00,'','454','2021-12-24 09:04:17','454',0,0),(4063,400738,'',0,'2','1','206','STANBIC IBTC','','2021-12-29 12:36:07',5,0.00,0.00,'','454','2021-12-29 12:36:07','454',0,0),(4065,2000,'',0,'6','1','206','Inventory Value Adjustment','','2022-02-08 19:42:04',5,0.00,0.00,'','454','2022-02-08 19:42:04','454',0,0),(4066,400739,'',0,'2','1','206','ZENITH BANK TRANSFER 122162006','','2022-03-14 13:31:06',5,0.00,0.00,'','761','2022-03-14 13:31:06','761',0,0),(4067,400740,'',0,'2','1','206','KEYSTONE SURPLUS ACCOUNT','','2022-03-18 14:12:29',5,0.00,0.00,'','761','2022-03-18 14:12:29','761',0,0),(4068,400741,'',0,'2','1','206','MONIE POINT POS ACCOUNT','','2023-03-10 10:10:52',5,0.00,0.00,'','761','2023-03-10 10:10:52','761',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'1','206','0000-00-00','2022-02-08 19:49:58',10,'728','','0000-00-00 00:00:00','454','2022-02-09 12:01:50'),(2,'1','206','0000-00-00','2022-02-12 17:37:05',10,'728','','0000-00-00 00:00:00','454','2022-02-14 11:34:56'),(3,'1','206','0000-00-00','2022-02-15 21:17:30',10,'728','','0000-00-00 00:00:00','454','2022-02-16 11:22:00'),(4,'1','206','0000-00-00','2022-02-26 12:01:31',10,'728','','0000-00-00 00:00:00','454','2022-02-26 17:09:34'),(5,'1','206','0000-00-00','2022-02-26 12:03:31',10,'728','','0000-00-00 00:00:00','454','2022-02-26 17:09:23'),(6,'1','206','0000-00-00','2022-03-09 11:45:20',10,'728','','0000-00-00 00:00:00','761','2022-03-09 12:26:05'),(7,'1','206','0000-00-00','2022-03-14 18:59:32',10,'728','','0000-00-00 00:00:00','761','2022-04-19 07:52:07'),(8,'1','206','0000-00-00','2022-03-17 15:20:34',10,'728','','0000-00-00 00:00:00','761','2022-04-19 07:52:16'),(9,'1','206','0000-00-00','2022-03-19 19:04:19',10,'728','','0000-00-00 00:00:00','761','2022-04-19 07:52:27'),(10,'1','206','0000-00-00','2022-03-23 21:49:07',10,'728','','0000-00-00 00:00:00','761','2022-04-19 07:52:35'),(11,'1','206','0000-00-00','2022-04-19 17:56:20',10,'728','','0000-00-00 00:00:00','761','2022-09-23 15:01:41'),(12,'1','206','0000-00-00','2022-05-25 21:47:13',10,'728','','0000-00-00 00:00:00','761','2022-09-23 15:03:34'),(13,'1','206','0000-00-00','2022-06-03 13:17:40',10,'728','','0000-00-00 00:00:00','761','2022-09-23 15:03:46'),(14,'1','206','0000-00-00','2022-06-07 18:51:32',10,'728','','0000-00-00 00:00:00','761','2022-09-23 15:04:22'),(15,'1','206','0000-00-00','2022-06-11 17:06:42',10,'728','','0000-00-00 00:00:00','761','2022-09-23 15:05:31'),(16,'1','206','0000-00-00','2022-06-15 15:17:46',10,'728','','0000-00-00 00:00:00','761','2022-09-23 15:05:40'),(17,'1','206','0000-00-00','2022-07-11 15:55:46',10,'728','','0000-00-00 00:00:00','761','2022-09-23 15:05:53'),(18,'1','206','0000-00-00','2022-08-17 19:33:03',10,'728','','0000-00-00 00:00:00','761','2022-09-23 15:01:10'),(19,'1','206','0000-00-00','2022-09-29 15:25:12',10,'728','','0000-00-00 00:00:00','761','2022-10-13 14:50:30'),(20,'1','206','0000-00-00','2022-10-09 13:38:47',10,'728','','0000-00-00 00:00:00','761','2022-10-13 14:50:15'),(21,'1','206','0000-00-00','2022-10-16 15:15:11',5,'728','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(22,'1','206','0000-00-00','2022-10-31 15:11:01',5,'728','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(23,'1','206','0000-00-00','2022-11-10 21:26:37',5,'728','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(24,'1','206','0000-00-00','2022-11-19 20:53:45',5,'728','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(25,'1','206','0000-00-00','2022-11-29 10:57:59',5,'728','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26,'1','206','0000-00-00','2022-12-08 14:10:02',5,'728','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(27,'1','206','0000-00-00','2023-01-29 20:34:38',5,'728','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(28,'1','206','0000-00-00','2023-02-03 19:57:52',5,'728','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(29,'1','206','0000-00-00','2023-02-10 22:30:28',5,'728','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'1','206','1','4065','6',0.00,'AGO CHANGE OF PRICE 345-350',121500.00,'2022-01-18'),(2,'1','206','1','356','supplier',121500.00,'AGO CHANGE OF PRICE 345-350',0.00,'2022-01-18'),(3,'1','206','1','4065','6',0.00,'AGO CHANGE OF PRICE 350-355',115750.00,'2022-01-20'),(4,'1','206','1','356','supplier',115750.00,'AGO CHANGE OF PRICE 350-355',0.00,'2022-01-20'),(5,'1','206','1','4065','6',0.00,'AGO CHANGE OF PRICE 355-360',106250.00,'2022-01-28'),(6,'1','206','1','356','supplier',106250.00,'AGO CHANGE OF PRICE 355-360',0.00,'2022-01-28'),(7,'1','206','1','4065','6',0.00,'AGO CHANGE OF PRICE 360-380',282000.00,'2022-02-04'),(8,'1','206','1','356','supplier',282000.00,'AGO CHANGE OF PRICE 360-380',0.00,'2022-02-04'),(9,'1','206','1','4065','6',0.00,'AGO CHANGE OF PRICE 380-390',117500.00,'2022-02-08'),(10,'1','206','1','356','supplier',117500.00,'AGO CHANGE OF PRICE 380-390',0.00,'2022-02-08'),(11,'1','206','2','4065','6',0.00,'AGO CHANGE OF PRICE 390-400',91500.00,'2022-02-12'),(12,'1','206','2','356','supplier',91500.00,'AGO CHANGE OF PRICE 390-400',0.00,'2022-02-12'),(13,'1','206','3','4065','6',0.00,'AGO CHANGE OF PRICE 400-410(2,800)',28000.00,'2022-02-15'),(14,'1','206','3','356','supplier',28000.00,'AGO CHANGE OF PRICE 400-410(2,800)',0.00,'2022-02-15'),(15,'1','206','4','4065','6',0.00,'AGO CHANGE OF PRICE 410-415(150)',750.00,'2022-02-22'),(16,'1','206','4','356','supplier',750.00,'AGO CHANGE OF PRICE 410-415(150)',0.00,'2022-02-22'),(17,'1','206','5','4065','6',0.00,'AGO CHANGE OF PRICE 415-420(150)',750.00,'2022-02-25'),(18,'1','206','5','356','supplier',750.00,'AGO CHANGE OF PRICE 410-415(150)',0.00,'2022-02-25'),(19,'1','206','6','4065','6',0.00,'AGO CHANGE OF PRICE 500-600(150)',15000.00,'2022-03-08'),(20,'1','206','6','356','supplier',15000.00,'AGO CHANGE OF PRICE 500-600(150)',0.00,'2022-03-08'),(21,'1','206','7','4065','6',0.00,'AGO CHANGE OF PRICE 600-650(150)',7500.00,'2022-03-14'),(22,'1','206','7','356','supplier',7500.00,'AGO CHANGE OF PRICE 600-650(150)',0.00,'2022-03-14'),(23,'1','206','8','4065','6',0.00,'AGO CHANGE OF PRICE 650-660(150)',1500.00,'2022-03-17'),(24,'1','206','8','356','supplier',1500.00,'AGO CHANGE OF PRICE 650-660(150)',0.00,'2022-03-17'),(25,'1','206','9','4065','6',0.00,'AGO CHANGE OF PRICE 660-680(150)',3000.00,'2022-03-19'),(26,'1','206','9','356','supplier',3000.00,'AGO CHANGE OF PRICE 660-680(150)',0.00,'2022-03-19'),(27,'1','206','10','4065','6',0.00,'AGO CHANGE OF PRICE 680-700(150)',3000.00,'2022-03-23'),(28,'1','206','10','356','supplier',3000.00,'AGO CHANGE OF PRICE 680-700(150)',0.00,'2022-03-23'),(29,'1','206','11','356','supplier',0.00,'AGO CHANGE OF PRICE 700-660(15,150)',606000.00,'2022-04-19'),(30,'1','206','11','4065','6',606000.00,'AGO CHANGE OF PRICE 700-660(15,150)',0.00,'2022-04-19'),(31,'1','206','12','4065','6',0.00,'AGO CHANGE OF PRICE 74-760(150)',3000.00,'2022-05-25'),(32,'1','206','12','356','supplier',3000.00,'AGO CHANGE OF PRICE 74-760(150)',0.00,'2022-05-25'),(33,'1','206','13','4065','6',0.00,'AGO CHANGE OF PRICE 760-770(150)',1500.00,'2022-06-03'),(34,'1','206','13','356','supplier',1500.00,'AGO CHANGE OF PRICE 760-770(150)',0.00,'2022-06-03'),(35,'1','206','14','4065','6',0.00,'AGO CHANGE OF PRICE 770-800(18,750)',562500.00,'2022-06-07'),(36,'1','206','14','356','supplier',562500.00,'AGO CHANGE OF PRICE 770-800(18,750)',0.00,'2022-06-07'),(37,'1','206','15','4065','6',0.00,'AGO CHANGE OF PRICE 800-820(17,300)',346000.00,'2022-06-11'),(38,'1','206','15','356','supplier',346000.00,'AGO CHANGE OF PRICE 800-820(17,300)',0.00,'2022-06-11'),(39,'1','206','16','4065','6',0.00,'AGO CHANGE OF PRICE 820-830(16,250)',162500.00,'2022-06-15'),(40,'1','206','16','356','supplier',162500.00,'AGO CHANGE OF PRICE 820-830(16,250)',0.00,'2022-06-15'),(41,'1','206','17','4065','6',0.00,'Change of price from 165-185(4600)',851000.00,'2022-07-09'),(42,'1','206','17','356','supplier',851000.00,'Change of price from 165-185(4600)',0.00,'2022-07-09'),(43,'1','206','18','356','supplier',0.00,'AGO CHANGE OF PRICE 810-800(13,500)',135000.00,'2022-08-17'),(44,'1','206','18','4065','6',135000.00,'AGO CHANGE OF PRICE 810-800(13,500)',0.00,'2022-08-17'),(45,'1','206','19','356','supplier',130000.00,'AGO CHANGE OF PRICE 800-810(13000)',0.00,'2022-09-29'),(46,'1','206','19','4065','6',0.00,'AGO CHANGE OF PRICE 800-810(13000)',130000.00,'2022-09-29'),(49,'1','206','20','4065','6',0.00,'AGO CHANGE OF PRICE 810-820(6450)',64500.00,'2022-10-09'),(50,'1','206','20','356','supplier',64500.00,'AGO CHANGE OF PRICE 810-820(6450)',0.00,'2022-10-09'),(51,'1','206','21','4065','6',0.00,'AGO CHANGE OF PRICE 820-830(4550)',45500.00,'2022-10-16'),(52,'1','206','21','356','supplier',45500.00,'AGO CHANGE OF PRICE 820-830(4550)',0.00,'2022-10-16'),(54,'1','206','22','4065','6',0.00,'PMS CHANGE OF PRICE 185-195(4400)',44000.00,'2022-10-31'),(55,'1','206','22','356','supplier',44000.00,'PMS CHANGE OF PRICE 185-195(4400)',0.00,'2022-10-31'),(56,'1','206','23','4065','6',0.00,'Change of price from 830-860(150)',4500.00,'2022-11-10'),(57,'1','206','23','356','supplier',4500.00,'Change of price from 830-860(150)',0.00,'2022-11-10'),(58,'1','206','24','4065','6',0.00,'Change of price from 860-880(150)',3000.00,'2022-11-18'),(59,'1','206','24','356','supplier',3000.00,'Change of price from 860-880(150)',0.00,'2022-11-18'),(60,'1','206','25','4065','6',0.00,'Change of price from 880-890(150)',1500.00,'2022-11-29'),(61,'1','206','25','356','supplier',1500.00,'Change of price from 880-890(150)',0.00,'2022-11-29'),(62,'1','206','26','4065','6',0.00,'AGO CHANGE OF PRICE 890-900(150)',1500.00,'2022-12-03'),(63,'1','206','26','356','supplier',1500.00,'AGO CHANGE OF PRICE 890-900(150)',0.00,'2022-12-03'),(64,'1','206','26','4065','6',3000.00,'AGO CHANGE OF PRICE 900-880(150)',0.00,'2022-12-06'),(65,'1','206','26','356','supplier',0.00,'AGO CHANGE OF PRICE 900-880(150)',3000.00,'2022-12-06'),(66,'1','206','26','4065','6',0.00,'PMS CHANGE OF PRICE 195-210(1700)',25500.00,'2022-12-08'),(67,'1','206','26','356','supplier',25500.00,'PMS CHANGE OF PRICE 195-210(1700)',0.00,'2022-12-08'),(68,'1','206','27','356','supplier',0.00,'AGO CHANGE OF PRICE 870-850(9300)',186000.00,'2023-01-29'),(69,'1','206','27','4065','6',186000.00,'AGO CHANGE OF PRICE 870-850(9300)',0.00,'2023-01-29'),(70,'1','206','28','356','supplier',0.00,'PMS CHANGE OF PRICE 220-200 (12,050)',241000.00,'2023-02-03'),(71,'1','206','28','4065','6',241000.00,'PMS CHANGE OF PRICE 220-200 (12,050)',0.00,'2023-02-03'),(72,'1','206','29','4065','6',0.00,'CHANGE OF PRICE 200-210(56250)',562500.00,'2023-02-10'),(73,'1','206','29','356','supplier',562500.00,'CHANGE OF PRICE 200-210(56250)',0.00,'2023-02-10');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4129 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (4124,'','1','206','DRIVER SHORTAGE ','DRIVER','08030647174','driver200@gmail.com','Kano','Kano','Head Office','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-31 11:07:17',5,'454','2021-12-31 11:07:17','454'),(4125,'','1','206','DSS','PAUL GABRIEL','08030618641','paulgabriel91983@gmail.com','LOKOJA ','KOGI','HASSAN KATSINA ROAD, ZONE 8 LOKOJA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-01 16:42:37',5,'761','2022-03-01 16:42:37','761'),(4126,'','1','206','MCPL MULTIPRO CONSUMER PRODUCT','MR. DAVIS','08053076616','davis.eromosele@gmail.com','LOKOJA ','KOGI','SHOP 24 KABAN PLAZA, NUT ROAD, LOKOJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-06 12:25:45',5,'761','2022-04-06 12:25:45','761'),(4127,'','1','206','CONFLUENCE INTERNATIONAL ACADE','DR JIGAH','07064805766','reulenjigah97@gmail.com','LOKOJA','KOGI','CONFLUENCE AVENUE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-20 11:23:24',5,'761','2023-01-20 11:23:24','761'),(4128,'','1','206','NIGERIA POLICE FORCE(ELECTION)','CP YUSUF C. USMAN','08071785115','dopstransport@gmail.com','FCT','ABUJA','NPF HEADQURTER ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 11:12:55',5,'761','2023-02-21 11:12:55','761');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18364 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','206',18349,'1030',28700.82,73701.00,'2022-01-04','','2022-01-04 10:18:41','454','454',2022,'454','2022-01-04 10:18:41',5),('1','206',18350,'1030',48109.67,1700.00,'2022-02-10','','2022-02-10 15:48:19','454','454',2022,'454','2022-02-10 15:48:19',5),('1','206',18351,'1030',621.02,2900.00,'2022-04-29','','2022-04-29 17:02:37','533','533',2022,'533','2022-04-29 17:02:37',5),('1','206',18352,'1030',17012.54,18000.00,'2022-06-08','','2022-06-08 13:15:41','761','761',2022,'761','2022-06-08 13:15:41',5),('1','206',18353,'1031',18971.93,18800.00,'2022-06-08','','2022-06-08 13:16:00','761','761',2022,'761','2022-06-08 13:16:00',5),('1','206',18354,'1031',221.68,778.00,'2022-09-16','','2022-09-16 11:22:28','761','761',2022,'761','2022-09-16 11:22:28',5),('1','206',18355,'1031',778.00,1000.00,'2022-09-16','','2022-09-16 11:24:28','761','761',2022,'761','2022-09-16 11:24:28',5),('1','206',18356,'1030',72.39,2735.00,'2022-10-09','','2022-10-09 13:28:50','913','913',2022,'913','2022-10-09 13:28:50',5),('1','206',18357,'1030',987.32,1250.00,'2022-12-03','','2022-12-03 20:23:09','913','913',2022,'913','2022-12-03 20:23:09',5),('1','206',18358,'1030',1250.00,1450.00,'2022-12-03','','2022-12-03 20:23:27','913','913',2022,'913','2022-12-03 20:23:27',5),('1','206',18359,'1030',1450.00,1655.00,'2022-12-04','','2022-12-04 19:51:50','913','913',2022,'913','2022-12-04 19:51:50',5),('1','206',18360,'1030',16998.18,17600.00,'2022-12-18','','2022-12-18 15:20:55','913','913',2022,'913','2022-12-18 15:20:55',5),('1','206',18361,'1030',8647.75,8893.00,'2023-01-13','TANK RECONCILIATION','2023-01-13 15:26:55','761','761',2023,'761','2023-01-13 15:26:55',5),('1','206',18362,'1030',17398.35,20050.00,'2023-01-22','','2023-01-22 17:53:14','913','913',2023,'913','2023-01-22 17:53:14',5),('1','206',18363,'1030',17485.79,19800.00,'2023-01-24','','2023-01-24 17:55:54','913','913',2023,'913','2023-01-24 17:55:54',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3065 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','206','1030',3056,'5','PUMP 1',362629.21,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-10 12:40:02','178'),('1','206','1030',3057,'5','PUMP 2',717533.96,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-11 09:48:34','178'),('1','206','1030',3058,'5','PUMP 3',735251.81,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-10 12:41:11','178'),('1','206','1030',3059,'5','PUMP 4',320523.72,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-11 09:49:07','178'),('1','206','1030',3060,'5','PUMP 5',163924.56,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-11 09:50:46','178'),('1','206','1030',3061,'5','PUMP 6',246006.99,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-11 09:51:07','178'),('1','206','1030',3062,'5','PUMP 7',1036916.01,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-10 12:43:14','178'),('1','206','1030',3063,'5','PUMP 8',381649.37,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-10 12:43:33','178'),('1','206','1031',3064,'5','AGO PUMP 1',226508.93,'DISPENSING AGO','',NULL,NULL,'',5,'2021-12-10 12:43:59','178');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258149 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','206',245375,'MORNING & AFTERNOON SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'728',347829.90,347829.90,'728','2021-12-11 17:55:47','533','2021-12-12 08:44:09',10,0),('1','206',245500,'MORNING & AFTERNOON SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'728',1022955.30,1022955.30,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','206',245508,'MORNING & AFTERNOON SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'728',1022955.30,1022955.30,'728','2021-12-12 09:04:14','533','2021-12-12 14:03:32',10,0),('1','206',245604,'MORNING & AFTERNOON SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'728',898000.20,898000.20,'728','2021-12-12 20:16:50','533','2021-12-13 00:11:01',10,0),('1','206',248093,'MORNING & AFTERNOON SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'728',511443.90,511443.90,'728','2021-12-22 21:07:10','533','2021-12-23 09:59:28',10,0),('1','206',248301,'MORNING SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'728',677451.00,677451.00,'728','2021-12-23 16:32:05','533','2021-12-23 18:56:02',10,0),('1','206',248360,'AFTERNOON SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'728',1156617.75,1156617.75,'728','2021-12-24 08:59:00','533','2021-12-24 09:47:37',10,0),('1','206',248492,'MORNING SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'728',965519.85,965519.85,'728','2021-12-24 14:50:32','533','2021-12-24 16:07:22',10,0),('1','206',248599,'AFTERNOON SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'728',1506043.20,1506043.20,'728','2021-12-25 15:28:17','533','2021-12-25 15:59:25',10,0),('1','206',248793,'MORNING SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'728',1169359.95,1169359.95,'728','2021-12-25 16:07:11','533','2021-12-26 09:16:47',10,0),('1','206',248993,'AFTERNOON SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'728',1275909.00,1275909.00,'728','2021-12-26 13:41:07','533','2021-12-26 14:52:45',10,0),('1','206',249017,'MORNING SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'728',1705911.00,1705911.00,'728','2021-12-26 14:56:18','533','2021-12-26 19:10:08',10,0),('1','206',249064,'AFTERNOON SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'728',1057146.90,1057146.90,'728','2021-12-26 20:40:10','533','2021-12-27 10:05:25',10,0),('1','206',249210,'MORNING SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'728',869762.85,869762.85,'728','2021-12-27 13:30:49','533','2021-12-28 08:39:14',10,0),('1','206',249436,'AFTERNOON SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'728',939328.65,939328.65,'728','2021-12-28 10:29:39','533','2021-12-28 12:05:36',10,0),('1','206',249465,'MORNING SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'728',805001.85,805001.85,'728','2021-12-28 14:25:17','533','2021-12-28 16:27:37',10,0),('1','206',249522,'AFTERNOON SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'728',623937.60,623937.60,'728','2021-12-29 07:38:05','533','2021-12-29 09:15:08',10,0),('1','206',249723,'MORNING SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'728',626300.25,626300.25,'728','2021-12-29 16:31:08','533','2021-12-30 10:51:44',10,0),('1','206',249955,'AFTERNOON SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'728',885321.75,885321.75,'728','2021-12-30 11:26:41','533','2021-12-30 13:16:33',10,0),('1','206',249989,'MORNING SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'728',1004288.10,1004288.10,'728','2021-12-30 13:23:46','533','2021-12-31 07:29:38',10,0),('1','206',250186,'AFTERNOON SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'728',948344.25,948344.25,'728','2021-12-31 10:23:17','533','2021-12-31 10:28:56',10,0),('1','206',250235,'MORNING SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'728',570345.00,570345.00,'728','2021-12-31 15:34:32','533','2021-12-31 17:55:10',10,0),('1','206',250408,'AFTERNOON SHIFT','2021-01-31','2021-01-31 00:00:00',NULL,'728',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','206',250409,'AFTERNOON SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'728',1274098.80,1274098.80,'728','2022-01-01 13:03:20','533','2022-01-01 16:30:33',10,0),('1','206',250506,'MORNING SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'728',394314.90,394314.90,'728','2022-01-01 18:26:13','533','2022-01-02 08:10:18',10,0),('1','206',250646,'AFTERNOON SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'728',449473.95,449473.95,'728','2022-01-02 10:30:12','533','2022-01-02 14:59:56',10,0),('1','206',250747,'MORNING SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'728',472053.60,472053.60,'728','2022-01-02 18:44:58','533','2022-01-03 07:59:05',10,0),('1','206',250876,'AFTERNOON SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'728',530050.50,530050.50,'728','2022-01-03 10:25:48','533','2022-01-03 15:21:29',10,0),('1','206',250971,'MORNING SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'728',674836.95,674836.95,'728','2022-01-03 19:00:50','533','2022-01-04 09:34:19',10,0),('1','206',251106,'AFTERNOON SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'454',1225567.65,1225567.65,'728','2022-01-04 10:34:31','533','2022-01-04 19:29:13',10,0),('1','206',251228,'MORNING SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'728',714847.95,714847.95,'728','2022-01-04 19:34:39','533','2022-01-04 19:35:38',10,0),('1','206',251229,'AFTERNOON SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'728',810725.85,810725.85,'728','2022-01-05 08:15:20','533','2022-01-05 11:05:47',10,0),('1','206',251376,'MORNING SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'728',532106.25,532106.25,'728','2022-01-05 14:23:16','533','2022-01-05 15:18:58',10,0),('1','206',251461,'AFTERNOON SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'728',699124.05,699124.05,'728','2022-01-05 22:05:50','533','2022-01-06 10:27:10',10,0),('1','206',251615,'MORNING SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'728',781520.70,781520.70,'728','2022-01-06 14:04:02','533','2022-01-06 15:01:22',10,0),('1','206',251679,'AFTERNOON SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'728',1415129.55,1415129.55,'728','2022-01-06 22:51:58','533','2022-01-07 11:07:18',10,0),('1','206',251842,'MORNING SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'728',526753.80,526753.80,'728','2022-01-07 13:53:43','533','2022-01-07 15:19:44',10,0),('1','206',251958,'AFTERNOON SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'728',755962.50,755962.50,'728','2022-01-08 09:50:16','533','2022-01-08 11:58:37',10,0),('1','206',252109,'MORNING SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'728',574950.60,574950.60,'728','2022-01-08 13:59:28','533','2022-01-09 10:51:38',10,0),('1','206',252309,'AFTERNOON SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'728',753538.50,753538.50,'728','2022-01-09 11:29:25','533','2022-01-09 18:22:26',10,0),('1','206',252416,'MORNING SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'728',438217.20,438217.20,'728','2022-01-09 19:51:35','533','2022-01-09 21:13:44',10,0),('1','206',252432,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'728',656855.10,656855.10,'728','2022-01-09 21:33:09','533','2022-01-10 12:20:40',10,0),('1','206',252601,'MORNING SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'728',465299.85,465299.85,'728','2022-01-10 13:54:27','533','2022-01-10 16:45:39',10,0),('1','206',252666,'AFTERNOON SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'728',513456.75,513456.75,'728','2022-01-10 20:49:47','533','2022-01-11 11:43:30',10,0),('1','206',252917,'AFTERNOON SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'728',860479.65,860479.65,'728','2022-01-12 08:56:48','533','2022-01-12 11:42:27',10,0),('1','206',253080,'MORNING SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'728',378146.40,378146.40,'728','2022-01-12 14:11:35','454','2022-01-13 11:39:49',10,0),('1','206',253331,'AFTERNOON SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'728',899953.80,899953.80,'728','2022-01-13 12:14:48','533','2022-01-13 13:01:08',10,0),('1','206',253351,'MORNING SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'728',605457.75,605457.75,'728','2022-01-13 14:33:29','533','2022-01-13 16:22:01',10,0),('1','206',253397,'AFTERNOON SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'728',945929.55,945929.55,'728','2022-01-13 23:18:00','533','2022-01-14 11:14:03',10,0),('1','206',253570,'MORNING SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'728',683954.10,683954.10,'728','2022-01-14 14:10:26','533','2022-01-14 19:15:41',10,0),('1','206',253662,'AFTERNOON SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'728',1030208.10,1030208.10,'728','2022-01-15 10:24:17','533','2022-01-15 13:18:12',10,0),('1','206',253826,'MORNING SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'728',530419.50,530419.50,'728','2022-01-15 14:16:53','533','2022-01-15 15:06:44',10,0),('1','206',253908,'AFTERNOON SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'728',1362942.15,1362942.15,'728','2022-01-16 09:25:02','533','2022-01-16 10:11:51',10,0),('1','206',254063,'MORNING SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'728',555736.50,555736.50,'728','2022-01-16 18:46:59','533','2022-01-17 10:46:44',10,0),('1','206',254386,'AFTERNOON SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'728',93851.55,93851.55,'728','2022-01-17 18:27:38','533','2022-01-17 22:57:41',10,0),('1','206',255121,'MORNING SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'728',372750.00,372750.00,'728','2022-01-20 17:12:10','533','2022-01-20 20:16:26',10,0),('1','206',255528,'MORNING SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'728',331696.20,331696.20,'728','2022-01-22 13:53:43','533','2022-01-23 08:07:49',10,0),('1','206',255792,'AFTERNOON SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'728',735154.55,735154.55,'728','2022-01-23 11:22:58','533','2022-01-23 14:09:58',10,0),('1','206',255829,'MORNING SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'728',260691.75,260691.75,'728','2022-01-23 14:21:52','533','2022-01-24 09:33:48',10,0),('1','206',256026,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'728',440456.40,440456.40,'728','2022-01-24 10:03:07','533','2022-01-24 11:19:06',10,0),('1','206',256059,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'728',272834.05,272834.05,'728','2022-01-24 14:08:39','533','2022-01-24 18:39:11',10,0),('1','206',256146,'AFTERNOON SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'728',703445.10,703445.10,'728','2022-01-24 22:01:17','454','2022-01-25 13:13:48',10,0),('1','206',256346,'MORNING SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'728',477656.35,477656.35,'728','2022-01-25 14:11:51','533','2022-01-25 21:23:25',10,0),('1','206',256527,'AFTERNOON SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'728',796651.05,796651.05,'728','2022-01-26 08:45:48','454','2022-01-26 11:35:30',10,0),('1','206',256588,'MORNING SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'728',283534.85,283534.85,'728','2022-01-26 13:47:46','533','2022-01-26 19:13:16',10,0),('1','206',256670,'AFTERNOON SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'728',787266.60,787266.60,'728','2022-01-26 22:00:22','533','2022-01-27 10:36:34',10,0),('1','206',256813,'MORNING SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'728',618536.05,618536.05,'728','2022-01-27 13:41:20','533','2022-01-28 07:13:22',10,0),('1','206',257017,'AFTERNOON SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'728',675948.10,675948.10,'728','2022-01-28 09:23:52','533','2022-01-28 12:27:46',10,0),('1','206',257096,'MORNING SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'728',447689.25,447689.25,'728','2022-01-28 14:10:06','533','2022-01-28 17:46:47',10,0),('1','206',257183,'AFTERNOON SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'728',817317.60,817317.60,'728','2022-01-28 22:14:53','533','2022-01-29 11:06:43',10,0),('1','206',257403,'MORNING SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'728',502112.40,502112.40,'728','2022-01-29 21:00:50','533','2022-01-30 12:54:26',10,0),('1','206',257624,'MORNING SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'728',1026178.05,1026178.05,'728','2022-01-30 14:51:29','533','2022-01-30 15:35:52',10,0),('1','206',257625,'AFTERNOON SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'728',1016289.45,1016289.45,'728','2022-01-31 14:24:17','454','2022-01-31 14:41:13',10,0),('1','206',257626,'MORNING SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'728',737417.55,737417.55,'728','2022-01-31 17:07:47','454','2022-01-31 20:55:42',10,0),('1','206',257627,'AFTERNOON SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'728',119149.80,119149.80,'728','2022-02-01 09:55:15','454','2022-02-01 10:38:48',10,0),('1','206',257628,'MORNING SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'728',547985.40,547985.40,'728','2022-02-01 14:19:27','533','2022-02-01 22:00:05',10,0),('1','206',257629,'AFTERNOON SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'728',1087909.35,1087909.35,'728','2022-02-02 09:50:18','533','2022-02-02 15:54:16',10,0),('1','206',257630,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'728',365581.20,365581.20,'728','2022-02-02 20:00:55','533','2022-02-03 10:35:57',10,0),('1','206',257631,'AFTERNOON SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'728',701311.05,701311.05,'728','2022-02-03 10:42:16','533','2022-02-03 14:21:00',10,0),('1','206',257632,'MORNING SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'728',565082.40,565082.40,'728','2022-02-03 14:28:03','454','2022-02-04 16:21:33',10,0),('1','206',257633,'AFTERNOON SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'728',915295.65,915295.65,'728','2022-02-04 19:03:51','533','2022-02-04 19:08:00',10,0),('1','206',257634,'MORNING SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'728',1642602.15,1642602.15,'728','2022-02-04 20:28:28','533','2022-02-05 12:38:01',10,0),('1','206',257635,'AFTERNOON SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'728',1430509.55,1430509.55,'728','2022-02-05 22:27:59','533','2022-02-06 12:16:17',10,0),('1','206',257636,'MORNING SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'728',495138.05,495138.05,'728','2022-02-06 13:54:17','533','2022-02-06 14:56:29',10,0),('1','206',257637,'AFTERNOON SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'728',582833.00,582833.00,'728','2022-02-06 21:45:43','533','2022-02-07 07:06:48',10,0),('1','206',257638,'MORNING SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'728',490728.15,490728.15,'728','2022-02-07 14:55:25','533','2022-02-07 21:44:05',10,0),('1','206',257639,'AFTERNOON SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'728',1778220.90,1778220.90,'728','2022-02-08 11:14:30','533','2022-02-08 11:49:30',10,0),('1','206',257640,'MORNING SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'728',1159313.65,1159313.65,'728','2022-02-08 14:14:49','454','2022-02-08 19:38:10',10,0),('1','206',257641,'AFTERNOON SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'728',1998.80,1998.80,'728','2022-02-08 19:41:18','533','2022-02-08 19:44:46',10,0),('1','206',257642,'AFTERNOON SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'728',906937.20,906937.20,'728','2022-02-09 19:23:12','533','2022-02-10 14:12:14',10,0),('1','206',257643,'AFTERNOON SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'728',127206.30,127206.30,'728','2022-02-12 17:33:56','533','2022-02-13 10:10:16',10,0),('1','206',257644,'MORNING SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'728',2136694.65,2136694.65,'728','2022-02-13 14:33:12','533','2022-02-13 15:40:06',10,0),('1','206',257645,'AFTERNOON SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'728',174120.30,174120.30,'728','2022-02-13 19:25:20','533','2022-02-14 10:02:16',10,0),('1','206',257646,'MORNING SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'728',1048469.15,1048469.15,'728','2022-02-14 15:34:45','533','2022-02-15 10:44:53',10,0),('1','206',257647,'MORNING SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'728',1830728.75,1830728.75,'728','2022-02-15 15:44:40','454','2022-02-15 21:02:08',10,0),('1','206',257648,'AFTERNOON SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'728',218135.75,218135.75,'728','2022-02-15 21:11:26','454','2022-02-15 21:13:49',10,0),('1','206',257649,'AFTERNOON SHIFT 2','2022-02-15','2022-02-15 00:00:00',NULL,'728',533000.00,533000.00,'728','2022-02-15 22:48:05','533','2022-02-16 07:19:35',10,0),('1','206',257650,'MORNING SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'728',1455905.45,1455905.45,'728','2022-02-16 20:20:05','533','2022-02-16 20:26:57',10,0),('1','206',257651,'AFTERNOON SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'728',1097042.25,1097042.25,'728','2022-02-16 20:52:22','454','2022-02-17 10:47:22',10,0),('1','206',257652,'MORNING SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'728',272471.10,272471.10,'728','2022-02-17 20:52:53','533','2022-02-18 08:45:12',10,0),('1','206',257653,'MORNING SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'728',339961.05,339961.05,'728','2022-02-18 19:53:33','454','2022-02-18 20:05:35',10,0),('1','206',257654,'AFTERNOON SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'728',160536.75,160536.75,'728','2022-02-18 20:16:26','533','2022-02-18 21:46:51',10,0),('1','206',257655,'MORNING SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'728',2058364.40,2058364.40,'728','2022-02-21 09:48:44','454','2022-02-21 11:35:54',10,0),('1','206',257656,'AFTERNOON SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'728',958163.25,958163.25,'728','2022-02-21 11:39:31','454','2022-02-21 11:45:11',10,0),('1','206',257657,'MORNING SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'728',827664.75,827664.75,'728','2022-02-21 11:52:33','454','2022-02-21 12:09:33',10,0),('1','206',257658,'AFTERNOON SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'728',925503.15,925503.15,'728','2022-02-21 12:14:40','454','2022-02-21 12:20:01',10,0),('1','206',257659,'AFTERNOON SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'728',118111.95,118111.95,'728','2022-02-21 18:54:19','454','2022-02-22 11:34:03',10,0),('1','206',257660,'MORNING SHIFT','2022-02-22','2022-02-28 11:22:07','2022-03-01 11:22:07','728',108060.15,108060.15,'728','2022-02-28 11:23:15','454','2022-02-28 15:51:26',10,0),('1','206',257661,'MORNING SHIFT','2022-03-01','2022-03-01 13:03:18','2022-03-02 13:03:18','728',499336.20,499336.20,'728','2022-03-02 13:32:28','533','2022-03-02 13:42:18',10,0),('1','206',257662,'AFTERNOON SHIFT','2022-03-01','2022-03-02 13:43:16','2022-03-03 13:43:16','728',1220838.30,1220838.30,'728','2022-03-02 13:50:46','761','2022-03-02 13:52:14',10,0),('1','206',257663,'MORNING SHIFT','2022-03-02','2022-03-02 13:54:34','2022-03-03 13:54:34','728',809308.50,809308.50,'728','2022-03-02 14:17:08','761','2022-03-02 15:48:07',10,0),('1','206',257664,'AFTERNOON SHIFT','2022-03-02','2022-03-02 20:19:05','2022-03-03 20:19:05','728',732675.90,732675.90,'728','2022-03-02 20:31:47','761','2022-03-03 16:28:24',10,0),('1','206',257665,'MORNING SHIFT','2022-03-03','2022-03-03 17:46:37','2022-03-04 17:46:37','728',607746.15,607746.15,'728','2022-03-03 18:44:03','761','2022-03-05 17:06:21',10,0),('1','206',257666,'AFTERNOON SHIFT','2022-03-03','2022-03-05 17:10:43','2022-03-06 17:10:43','728',676082.55,676082.55,'728','2022-03-05 17:13:55','761','2022-03-05 17:19:05',10,0),('1','206',257667,'MORNING SHIFT','2022-03-05','2022-03-05 17:24:03','2022-03-06 17:24:03','728',831771.60,831771.60,'728','2022-03-05 17:26:23','761','2022-03-05 18:20:25',10,0),('1','206',257668,'AFTERNOON SHIFT','2022-03-05','2022-03-05 18:22:09','2022-03-06 18:22:09','728',1334866.50,1334866.50,'728','2022-03-05 21:06:24','533','2022-03-06 10:04:20',10,0),('1','206',257669,'MORNING SHIFT','2022-03-06','2022-03-06 14:01:21','2022-03-07 14:01:21','728',1031707.05,1031707.05,'728','2022-03-06 17:49:40','533','2022-03-07 09:05:40',10,0),('1','206',257670,'AFTERNOON SHIFT','2022-03-06','2022-03-07 09:11:40','2022-03-08 09:11:40','728',782972.85,782972.85,'728','2022-03-07 09:20:55','761','2022-03-07 17:10:26',10,0),('1','206',257671,'MORNING SHIFT','2022-03-07','2022-03-07 20:02:03','2022-03-08 20:02:03','728',1442207.25,1442207.25,'728','2022-03-07 20:04:30','533','2022-03-08 12:11:37',10,0),('1','206',257672,'AFTERNOON SHIFT','2022-03-07','2022-03-08 12:16:20','2022-03-09 12:16:20','728',945044.10,945044.10,'728','2022-03-08 12:18:30','761','2022-03-08 15:22:47',10,0),('1','206',257673,'MORNING SHIFT','2022-03-08','2022-03-08 15:27:12','2022-03-09 15:27:12','728',572644.05,572644.05,'728','2022-03-08 15:31:58','533','2022-03-09 06:20:48',10,0),('1','206',257674,'AFTERNOON SHIFT','2022-03-08','2022-03-09 11:46:47','2022-03-10 11:46:47','728',2232692.55,2232692.55,'728','2022-03-09 11:54:44','761','2022-03-09 12:26:25',10,0),('1','206',257675,'MORNING SHIFT','2022-03-09','2022-03-09 13:43:37','2022-03-10 13:43:37','728',2338213.35,2338213.35,'728','2022-03-09 15:03:35','533','2022-03-10 07:35:58',10,0),('1','206',257676,'AFTERNOON SHIFT','2022-03-09','2022-03-10 10:03:39','2022-03-11 10:03:39','728',1908691.95,1908691.95,'728','2022-03-10 10:11:07','533','2022-03-10 14:34:13',10,0),('1','206',257677,'MORNING SHIFT','2022-03-10','2022-03-10 15:11:02','2022-03-11 15:11:02','728',1662804.00,1662804.00,'728','2022-03-10 15:13:17','761','2022-03-11 11:20:17',10,0),('1','206',257678,'AFTERNOON SHIFT','2022-03-10','2022-03-11 12:00:24','2022-03-12 12:00:24','728',1133475.75,1133475.75,'728','2022-03-11 12:04:37','533','2022-03-12 16:39:21',10,0),('1','206',257679,'MORNING SHIFT','2022-03-11','2022-03-12 16:39:47','2022-03-13 16:39:47','728',387094.95,387094.95,'728','2022-03-12 16:40:45','533','2022-03-12 16:44:34',10,0),('1','206',257680,'AFTERNOON SHIFT','2022-03-11','2022-03-12 16:46:23','2022-03-13 16:46:23','728',442584.45,442584.45,'728','2022-03-12 16:50:49','761','2022-03-12 17:15:44',10,0),('1','206',257681,'MORNING SHIFT','2022-03-12','2022-03-12 17:21:23','2022-03-13 17:21:23','728',611509.80,611509.80,'728','2022-03-12 17:25:59','533','2022-03-13 11:11:24',10,0),('1','206',257682,'AFTERNOON SHIFT','2022-03-12','2022-03-13 14:57:22','2022-03-14 14:57:22','728',1835233.95,1835233.95,'728','2022-03-13 15:16:06','761','2022-03-13 15:25:23',10,0),('1','206',257683,'MORNING SHIFT','2022-03-13','2022-03-13 15:29:15','2022-03-14 15:29:15','728',1096743.45,1096743.45,'728','2022-03-13 15:58:05','533','2022-03-14 11:56:55',10,0),('1','206',257684,'AFTERNOON SHIFT','2022-03-13','2022-03-14 14:15:53','2022-03-15 14:15:53','728',1272315.00,1272315.00,'728','2022-03-14 14:17:55','761','2022-03-14 15:12:03',10,0),('1','206',257685,'MORNING SHIFT','2022-03-14','2022-03-14 15:13:30','2022-03-15 15:13:30','728',915948.00,915948.00,'728','2022-03-14 15:17:38','533','2022-03-14 15:39:38',10,0),('1','206',257686,'AFTERNOON SHIFT','2022-03-14','2022-03-14 15:40:43','2022-03-15 15:40:43','728',1003440.90,1003440.90,'728','2022-03-14 19:38:03','533','2022-03-15 11:45:01',10,0),('1','206',257687,'MORNING SHIFT','2022-03-15','2022-03-16 20:20:54','2022-03-17 20:20:54','728',322268.10,322268.10,'728','2022-03-16 20:22:09','533','2022-03-17 10:05:52',10,0),('1','206',257688,'AFTERNOON SHIFT','2022-03-16','2022-03-17 12:32:37','2022-03-18 12:32:37','728',735959.40,735959.40,'728','2022-03-17 12:35:34','533','2022-03-17 13:26:16',10,0),('1','206',257689,'MORNING SHIFT','2022-03-17','2022-03-17 14:23:11','2022-03-18 14:23:11','728',1265805.75,1265805.75,'728','2022-03-17 15:16:06','533','2022-03-17 20:33:18',10,0),('1','206',257690,'AFTERNOON SHIFT','2022-03-17','2022-03-18 07:48:34','2022-03-19 07:48:34','728',2022226.80,2022226.80,'728','2022-03-18 08:01:23','533','2022-03-18 08:46:46',10,0),('1','206',257691,'MORNING SHIFT','2022-03-18','2022-03-18 13:21:10','2022-03-19 13:21:10','728',2307228.00,2307228.00,'728','2022-03-18 14:50:17','533','2022-03-18 16:48:23',10,0),('1','206',257692,'AFTERNOON SHIFT','2022-03-18','2022-03-18 20:36:13','2022-03-19 20:36:13','728',1421138.40,1421138.40,'728','2022-03-18 21:04:26','533','2022-03-19 09:36:20',10,0),('1','206',257693,'MORNING SHIFT','2022-03-19','2022-03-19 13:21:41','2022-03-20 13:21:41','728',825303.60,825303.60,'728','2022-03-19 14:30:05','533','2022-03-19 17:50:34',10,0),('1','206',257694,'AFTERNOON SHIFT','2022-03-19','2022-03-19 19:05:43','2022-03-20 19:05:43','728',359508.60,359508.60,'728','2022-03-19 19:23:30','533','2022-03-20 09:45:39',10,0),('1','206',257695,'MORNING SHIFT','2022-03-21','2022-03-21 14:51:04','2022-03-22 14:51:04','728',588159.00,588159.00,'728','2022-03-21 14:52:29','533','2022-03-22 07:56:18',10,0),('1','206',257696,'MORNING SHIFT','2022-03-23','2022-03-23 13:58:20','2022-03-24 13:58:20','728',1563068.10,1563068.10,'728','2022-03-23 21:08:06','533','2022-03-24 10:11:30',10,0),('1','206',257697,'AFTERNOON SHIFT','2022-03-23','2022-03-24 15:01:31','2022-03-25 15:01:31','728',1779409.50,1779409.50,'728','2022-03-24 15:03:41','533','2022-03-24 15:04:41',10,0),('1','206',257698,'MORNING SHIFT','2022-03-24','2022-03-24 15:09:14','2022-03-25 15:09:14','728',2427409.05,2427409.05,'728','2022-03-24 15:14:10','533','2022-03-25 08:56:36',10,0),('1','206',257699,'AFTERNOON SHIFT','2022-03-24','2022-03-25 13:19:11','2022-03-26 13:19:11','728',836337.15,836337.15,'728','2022-03-25 13:22:37','533','2022-03-25 15:46:19',10,0),('1','206',257700,'MORNING SHIFT','2022-03-25','2022-03-26 12:25:32','2022-03-27 12:25:32','728',852281.10,852281.10,'728','2022-03-26 12:33:21','533','2022-03-26 12:39:08',10,0),('1','206',257701,'MORNING SHIFT','2022-03-26','2022-03-26 14:11:51','2022-03-27 14:11:51','728',535538.85,535538.85,'728','2022-03-27 17:19:23','533','2022-03-27 17:47:36',10,0),('1','206',257702,'AFTERNOON SHIFT','2022-03-27','2022-03-28 10:00:49','2022-03-29 10:00:49','728',380343.15,380343.15,'728','2022-03-28 10:19:31','533','2022-03-28 11:34:02',10,0),('1','206',257703,'MORNING SHIFT','2022-03-28','2022-03-28 14:33:41','2022-03-29 14:33:41','728',1888481.10,1888481.10,'728','2022-03-28 17:23:06','533','2022-03-28 19:20:01',10,0),('1','206',257704,'AFTERNOON SHIFT','2022-03-28','2022-03-28 19:24:56','2022-03-29 19:24:56','728',1258027.65,1258027.65,'728','2022-03-28 19:27:49','533','2022-03-29 04:32:37',10,0),('1','206',257705,'MORNING SHIFT','2022-03-29','2022-03-30 12:22:01','2022-03-31 12:22:01','728',533847.60,533847.60,'728','2022-03-30 12:23:24','533','2022-03-30 17:19:22',10,0),('1','206',257706,'AFTERNOON SHIFT','2022-03-29','2022-03-30 18:39:38','2022-03-31 18:39:38','728',1011923.55,1011923.55,'728','2022-03-30 18:43:46','533','2022-03-30 18:48:32',10,0),('1','206',257707,'MORNING SHIFT','2022-03-30','2022-03-30 18:49:29','2022-03-31 18:49:29','728',1326565.35,1326565.35,'728','2022-03-30 18:56:21','533','2022-03-30 19:07:07',10,0),('1','206',257708,'AFTERNOON SHIFT','2022-03-30','2022-03-31 10:38:38','2022-04-01 10:38:38','728',1523428.50,1523428.50,'728','2022-03-31 12:29:05','533','2022-03-31 14:17:14',10,0),('1','206',257709,'MORNING SHIFT','2022-03-31','2022-03-31 14:24:22','2022-04-01 14:24:22','728',1417023.30,1417023.30,'728','2022-03-31 14:46:02','533','2022-04-01 16:17:06',10,0),('1','206',257710,'AFTERNOON SHIFT','2022-03-31','2022-04-01 16:20:09','2022-04-02 16:20:09','728',2169682.35,2169682.35,'728','2022-04-01 16:23:36','533','2022-04-01 16:46:49',10,0),('1','206',257711,'MORNING SHIFT','2022-04-01','2022-04-01 16:48:25','2022-04-02 16:48:25','728',1911059.70,1911059.70,'728','2022-04-01 16:50:48','533','2022-04-02 11:49:14',10,0),('1','206',257712,'AFTERNOON SHIFT','2022-04-01','2022-04-02 12:38:22','2022-04-03 12:38:22','728',2063485.05,2063485.05,'728','2022-04-02 12:39:48','533','2022-04-02 12:49:42',10,0),('1','206',257713,'MORNING SHIFT','2022-04-02','2022-04-02 14:11:46','2022-04-03 14:11:46','728',2222442.75,2222442.75,'728','2022-04-02 14:44:51','533','2022-04-03 11:36:07',10,0),('1','206',257714,'AFTERNOON SHIFT','2022-04-02','2022-04-03 12:19:55','2022-04-04 12:19:55','728',1434468.75,1434468.75,'728','2022-04-03 12:22:45','533','2022-04-03 14:08:31',10,0),('1','206',257715,'MORNING SHIFT','2022-04-03','2022-04-03 14:18:05','2022-04-04 14:18:05','728',1175981.40,1175981.40,'728','2022-04-03 14:19:29','533','2022-04-03 19:24:38',10,0),('1','206',257716,'AFTERNOON SHIFT','2022-04-03','2022-04-03 21:30:25','2022-04-04 21:30:25','728',1002937.65,1002937.65,'728','2022-04-03 21:43:46','533','2022-04-04 11:04:43',10,0),('1','206',257717,'MORNING SHIFT','2022-04-04','2022-04-04 12:52:50','2022-04-05 12:52:50','728',996855.75,996855.75,'728','2022-04-04 15:49:45','533','2022-04-04 18:09:28',10,0),('1','206',257718,'AFTERNOON SHIFT','2022-04-04','2022-04-04 20:58:22','2022-04-05 20:58:22','728',987937.50,987937.50,'728','2022-04-04 21:20:02','533','2022-04-05 10:53:30',10,0),('1','206',257719,'MORNING SHIFT','2022-04-05','2022-04-05 14:19:43','2022-04-06 14:19:43','728',1027743.75,1027743.75,'728','2022-04-05 14:23:49','533','2022-04-06 09:53:36',10,0),('1','206',257720,'AFTERNOON SHIFT','2022-04-05','2022-04-06 10:42:03','2022-04-07 10:42:03','728',1438522.80,1438522.80,'728','2022-04-06 12:35:54','533','2022-04-06 13:52:03',10,0),('1','206',257721,'MORNING SHIFT','2022-04-06','2022-04-06 14:10:56','2022-04-07 14:10:56','728',1326623.10,1326623.10,'728','2022-04-06 14:25:43','533','2022-04-07 09:31:49',10,0),('1','206',257722,'AFTERNOON SHIFT','2022-04-06','2022-04-07 11:56:08','2022-04-08 11:56:08','728',1603087.20,1603087.20,'728','2022-04-07 11:58:26','533','2022-04-07 12:18:15',10,0),('1','206',257723,'MORNING SHIFT','2022-04-07','2022-04-07 14:54:31','2022-04-08 14:54:31','728',1547242.95,1547242.95,'728','2022-04-07 14:57:55','533','2022-04-07 15:59:14',10,0),('1','206',257724,'AFTERNOON SHIFT','2022-04-07','2022-04-08 08:21:04','2022-04-09 08:21:04','728',1687200.90,1687200.90,'728','2022-04-08 08:43:22','533','2022-04-08 11:59:42',10,0),('1','206',257725,'MORNING SHIFT','2022-04-08','2022-04-08 13:14:44','2022-04-09 13:14:44','728',906912.60,906912.60,'728','2022-04-08 14:01:21','533','2022-04-09 11:30:59',10,0),('1','206',257726,'AFTERNOON SHIFT','2022-04-08','2022-04-09 11:43:07','2022-04-10 11:43:07','728',1156856.25,1156856.25,'728','2022-04-09 11:48:17','761','2022-04-09 12:24:57',10,0),('1','206',257727,'MORNING SHIFT','2022-04-09','2022-04-09 13:56:47','2022-04-10 13:56:47','728',1192281.75,1192281.75,'728','2022-04-09 14:04:01','533','2022-04-09 16:11:45',10,0),('1','206',257728,'AFTERNOON SHIFT','2022-04-09','2022-04-10 12:59:25','2022-04-11 12:59:25','728',1058719.20,1058719.20,'728','2022-04-10 14:24:33','533','2022-04-10 18:53:36',10,0),('1','206',257729,'MORNING SHIFT','2022-04-10','2022-04-11 15:43:52','2022-04-12 15:43:52','728',678818.25,678818.25,'728','2022-04-11 15:56:30','533','2022-04-12 07:50:52',10,0),('1','206',257730,'AFTERNOON SHIFT','2022-04-11','2022-04-12 11:11:18','2022-04-13 11:11:18','728',754878.30,754878.30,'728','2022-04-12 11:15:13','533','2022-04-12 14:00:35',10,0),('1','206',257731,'MORNING SHIFT','2022-04-12','2022-04-12 14:06:14','2022-04-13 14:06:14','728',973795.35,973795.35,'728','2022-04-12 14:08:22','533','2022-04-12 18:47:44',10,0),('1','206',257732,'AFTERNOON SHIFT','2022-04-12','2022-04-12 20:00:02','2022-04-13 20:00:02','728',1074123.60,1074123.60,'728','2022-04-12 21:17:59','533','2022-04-13 09:58:35',10,0),('1','206',257733,'AFTERNOON SHIFT','2022-04-14','2022-04-15 10:16:56','2022-04-16 10:16:56','728',1807070.10,1807070.10,'728','2022-04-15 10:32:51','761','2022-04-15 10:47:57',10,0),('1','206',257734,'MORNING SHIFT','2022-04-15','2022-04-15 13:52:24','2022-04-16 13:52:24','728',1364680.35,1364680.35,'728','2022-04-15 14:00:56','533','2022-04-15 16:11:37',10,0),('1','206',257735,'AFTERNOON SHIFT','2022-04-15','2022-04-15 21:05:47','2022-04-16 21:05:47','728',1909000.50,1909000.50,'728','2022-04-15 21:47:12','533','2022-04-16 17:54:28',10,0),('1','206',257736,'MORNING SHIFT','2022-04-16','2022-04-16 19:20:32','2022-04-17 19:20:32','728',1134177.00,1134177.00,'728','2022-04-16 19:23:22','533','2022-04-17 06:19:15',10,0),('1','206',257737,'AFTERNOON SHIFT','2022-04-16','2022-04-17 09:57:49','2022-04-18 09:57:49','728',941052.75,941052.75,'728','2022-04-17 10:00:18','761','2022-04-17 11:59:38',10,0),('1','206',257738,'MORNING SHIFT','2022-04-17','2022-04-17 13:14:42','2022-04-18 13:14:42','728',901881.75,901881.75,'728','2022-04-17 13:20:23','533','2022-04-17 16:17:25',10,0),('1','206',257739,'AFTERNOON SHIFT','2022-04-22','2022-04-22 20:21:31','2022-04-23 20:21:31','728',3535814.70,3535814.70,'728','2022-04-22 21:48:40','533','2022-04-23 12:46:17',10,0),('1','206',257740,'MORNING SHIFT','2022-04-23','2022-04-23 13:30:37','2022-04-24 13:30:37','728',1033167.30,1033167.30,'728','2022-04-23 14:07:27','533','2022-04-24 12:37:29',10,0),('1','206',257741,'AFTERNOON SHIFT','2022-04-26','2022-04-26 20:11:26','2022-04-27 20:11:26','728',0.00,0.00,'728','2022-04-26 20:24:59','533','2022-04-26 20:30:34',10,0),('1','206',257742,'AFTERNOON SHIFT','2022-04-23','2022-04-26 20:33:15','2022-04-27 20:33:15','728',1554778.50,1554778.50,'728','2022-04-26 20:35:01','533','2022-04-26 20:37:05',10,0),('1','206',257743,'AFTERNOON SHIFT','2022-04-26','2022-04-26 20:37:54','2022-04-27 20:37:54','728',2113653.30,2113653.30,'728','2022-04-26 20:44:12','533','2022-04-27 08:28:13',10,0),('1','206',257744,'AFTERNOON SHIFT','2022-04-28','2022-04-29 18:00:46','2022-04-30 18:00:46','728',3539817.60,3539817.60,'728','2022-04-29 18:04:44','533','2022-04-30 08:10:41',10,0),('1','206',257745,'AFTERNOON SHIFT','2022-04-30','2022-04-30 15:59:46','2022-05-01 15:59:46','728',834405.00,834405.00,'728','2022-04-30 16:00:37','533','2022-04-30 21:46:58',10,0),('1','206',257746,'MORNING SHIFT','2022-05-01','2022-05-01 11:59:24','2022-05-02 11:59:24','728',1829432.55,1829432.55,'728','2022-05-01 13:57:02','533','2022-05-02 13:29:30',10,0),('1','206',257747,'AFTERNOON SHIFT','2022-05-01','2022-05-02 14:31:27','2022-05-03 14:31:27','728',1302364.80,1302364.80,'728','2022-05-02 14:33:50','533','2022-05-02 14:49:08',10,0),('1','206',257748,'MORNING SHIFT','2022-05-02','2022-05-02 14:49:33','2022-05-03 14:49:33','728',843390.90,843390.90,'728','2022-05-02 14:58:57','533','2022-05-03 07:55:28',10,0),('1','206',257749,'AFTERNOON SHIFT','2022-05-02','2022-05-03 10:19:34','2022-05-04 10:19:34','728',274848.75,274848.75,'728','2022-05-03 10:20:50','533','2022-05-03 15:44:26',10,0),('1','206',257750,'MORNING SHIFT','2022-05-03','2022-05-03 16:50:19','2022-05-04 16:50:19','728',1109359.35,1109359.35,'728','2022-05-03 16:57:08','533','2022-05-03 19:44:40',10,0),('1','206',257751,'MORNING SHIFT','2022-05-04','2022-05-04 13:38:43','2022-05-05 13:38:43','728',2031054.30,2031054.30,'728','2022-05-04 13:45:52','533','2022-05-04 16:57:49',10,0),('1','206',257752,'AFTERNOON SHIFT','2022-05-04','2022-05-05 12:29:31','2022-05-06 12:29:31','728',489621.00,489621.00,'728','2022-05-05 12:47:30','533','2022-05-05 12:55:17',10,0),('1','206',257753,'MORNING SHIFT','2022-05-05','2022-05-05 17:39:42','2022-05-06 17:39:42','728',1282749.60,1282749.60,'728','2022-05-05 17:59:35','533','2022-05-06 07:17:23',10,0),('1','206',257754,'MORNING SHIFT','2022-05-06','2022-05-06 16:46:47','2022-05-07 16:46:47','728',1176885.60,1176885.60,'728','2022-05-06 16:49:49','533','2022-05-07 08:14:48',10,0),('1','206',257755,'MORNING SHIFT','2022-05-12','2022-05-12 13:39:20','2022-05-13 13:39:20','728',2147391.51,2147391.51,'728','2022-05-12 14:58:37','761','2022-05-12 20:54:11',10,0),('1','206',257756,'AFTERNOON SHIFT','2022-05-12','2022-05-13 11:53:56','2022-05-14 11:53:56','728',987170.25,987170.25,'728','2022-05-13 11:58:00','761','2022-05-13 12:24:21',10,0),('1','206',257757,'MORNING SHIFT','2022-05-13','2022-05-13 12:26:58','2022-05-14 12:26:58','728',872724.60,872724.60,'728','2022-05-13 14:49:13','761','2022-05-13 15:15:19',10,0),('1','206',257758,'AFTERNOON SHIFT','2022-05-15','2022-05-15 20:03:59','2022-05-16 20:03:59','728',1748320.20,1748320.20,'728','2022-05-16 13:12:13','533','2022-05-16 14:29:32',10,0),('1','206',257759,'MORNING SHIFT','2022-05-16','2022-05-16 15:03:38','2022-05-17 15:03:38','728',851863.65,851863.65,'728','2022-05-16 15:07:09','533','2022-05-16 18:18:08',10,0),('1','206',257760,'AFTERNOON SHIFT','2022-05-16','2022-05-16 20:05:01','2022-05-17 20:05:01','728',1031413.35,1031413.35,'728','2022-05-16 20:45:04','761','2022-05-16 20:46:25',10,0),('1','206',257761,'MORNING SHIFT','2022-05-17','2022-05-17 15:57:24','2022-05-18 15:57:24','728',894090.45,894090.45,'728','2022-05-17 17:20:42','761','2022-05-17 17:29:13',10,0),('1','206',257762,'MORNING SHIFT','2022-05-19','2022-05-19 15:52:36','2022-05-20 15:52:36','728',711255.60,711255.60,'728','2022-05-19 15:55:32','533','2022-05-19 17:43:38',10,0),('1','206',257763,'AFTERNOON SHIFT','2022-05-19','2022-05-19 20:29:14','2022-05-20 20:29:14','728',778608.60,778608.60,'728','2022-05-19 20:31:57','533','2022-05-20 08:24:26',10,0),('1','206',257764,'MORNING SHIFT','2022-05-20','2022-05-20 13:35:51','2022-05-21 13:35:51','728',753677.10,753677.10,'728','2022-05-20 14:02:01','761','2022-05-20 16:18:01',10,0),('1','206',257765,'AFTERNOON SHIFT','2022-05-20','2022-05-20 20:53:14','2022-05-21 20:53:14','728',1041293.55,1041293.55,'728','2022-05-20 21:06:34','761','2022-05-21 11:25:51',10,0),('1','206',257766,'MORNING SHIFT','2022-05-21','2022-05-21 13:19:48','2022-05-22 13:19:48','728',911210.85,911210.85,'728','2022-05-21 14:10:12','533','2022-05-21 15:18:53',10,0),('1','206',257767,'AFTERNOON SHIFT','2022-05-21','2022-05-21 16:22:18','2022-05-22 16:22:18','728',1324509.45,1324509.45,'728','2022-05-21 20:30:47','761','2022-05-22 14:25:49',10,0),('1','206',257768,'AFTERNOON SHIFT','2022-05-22','2022-05-22 18:47:51','2022-05-23 18:47:51','728',1495320.75,1495320.75,'728','2022-05-22 19:35:40','761','2022-05-23 08:35:06',10,0),('1','206',257769,'MORNING SHIFT','2022-05-23','2022-05-23 13:13:17','2022-05-24 13:13:17','728',759356.40,759356.40,'728','2022-05-23 13:45:27','761','2022-05-23 16:07:38',10,0),('1','206',257770,'AFTERNOON SHIFT','2022-05-23','2022-05-23 18:47:48','2022-05-24 18:47:48','728',747854.25,747854.25,'728','2022-05-23 20:07:20','533','2022-05-24 11:01:34',10,0),('1','206',257771,'MORNING SHIFT','2022-05-24','2022-05-24 13:28:32','2022-05-25 13:28:32','728',748654.50,748654.50,'728','2022-05-24 13:35:11','761','2022-05-24 16:17:09',10,0),('1','206',257772,'AFTERNOON SHIFT','2022-05-24','2022-05-24 19:26:30','2022-05-25 19:26:30','728',1499751.00,1499751.00,'728','2022-05-24 19:39:36','533','2022-05-24 20:30:59',10,0),('1','206',257773,'AFTERNOON SHIFT','2022-05-29','2022-05-29 18:28:36','2022-05-30 18:28:36','728',1385813.55,1385813.55,'728','2022-05-30 10:11:25','761','2022-05-30 10:12:54',10,0),('1','206',257774,'MORNING SHIFT','2022-05-30','2022-05-30 10:18:16','2022-05-31 10:18:16','728',2168644.50,2168644.50,'728','2022-05-30 14:08:16','533','2022-05-30 15:45:12',10,0),('1','206',257775,'AFTERNOON SHIFT','2022-05-30','2022-05-30 20:02:01','2022-05-31 20:02:01','728',2299570.35,2299570.35,'728','2022-05-30 20:23:10','761','2022-05-31 08:44:39',10,0),('1','206',257776,'MORNING SHIFT','2022-05-31','2022-05-31 12:41:50','2022-06-01 12:41:50','728',1294708.80,1294708.80,'728','2022-06-01 08:49:18','533','2022-06-01 08:57:58',10,0),('1','206',257777,'AFTERNOON SHIFT','2022-05-31','2022-06-01 08:58:54','2022-06-02 08:58:54','728',1361172.45,1361172.45,'728','2022-06-01 09:01:27','761','2022-06-01 09:15:17',10,0),('1','206',257778,'MORNING SHIFT','2022-06-01','2022-06-01 17:54:47','2022-06-02 17:54:47','728',980415.15,980415.15,'728','2022-06-01 17:56:45','533','2022-06-02 06:51:46',10,0),('1','206',257779,'AFTERNOON SHIFT','2022-06-01','2022-06-02 07:17:10','2022-06-03 07:17:10','728',431664.75,431664.75,'728','2022-06-02 07:21:08','761','2022-06-02 13:41:02',10,0),('1','206',257780,'AFTERNOON SHIFT','2022-06-02','2022-06-02 20:06:27','2022-06-03 20:06:27','728',878476.50,878476.50,'728','2022-06-02 20:08:05','533','2022-06-02 22:43:45',10,0),('1','206',257781,'MORNING SHIFT','2022-06-03','2022-06-03 13:18:27','2022-06-04 13:18:27','728',1263614.55,1263614.55,'728','2022-06-03 14:24:42','533','2022-06-03 15:11:45',10,0),('1','206',257782,'AFTERNOON SHIFT','2022-06-03','2022-06-03 17:52:18','2022-06-04 17:52:18','728',919323.90,919323.90,'728','2022-06-03 18:12:42','533','2022-06-03 21:57:04',10,0),('1','206',257783,'MORNING SHIFT','2022-06-07','2022-06-07 11:46:14','2022-06-08 11:46:14','728',2577696.55,2577696.55,'728','2022-06-07 15:45:07','533','2022-06-07 19:19:23',10,0),('1','206',257784,'AFTERNOON SHIFT','2022-06-07','2022-06-07 20:14:05','2022-06-08 20:14:05','728',1223321.40,1223321.40,'728','2022-06-07 21:09:49','533','2022-06-08 06:43:12',10,0),('1','206',257785,'MORNING SHIFT','2022-06-08','2022-06-08 13:19:43','2022-06-09 13:19:43','728',1409926.05,1409926.05,'728','2022-06-08 15:37:29','761','2022-06-08 16:58:57',10,0),('1','206',257786,'AFTERNOON SHIFT','2022-06-08','2022-06-08 17:44:15','2022-06-09 17:44:15','728',649435.05,649435.05,'728','2022-06-08 18:27:33','761','2022-06-08 21:58:38',10,0),('1','206',257787,'AFTERNOON SHIFT','2022-06-09','2022-06-09 17:02:41','2022-06-10 17:02:41','728',1392660.95,1392660.95,'728','2022-06-09 21:15:35','761','2022-06-10 09:36:03',10,0),('1','206',257788,'MORNING SHIFT','2022-06-10','2022-06-10 12:09:41','2022-06-11 12:09:41','728',1797779.95,1797779.95,'728','2022-06-10 14:09:19','761','2022-06-10 15:07:57',10,0),('1','206',257789,'AFTERNOON SHIFT','2022-06-10','2022-06-10 23:26:06','2022-06-11 23:26:06','728',499841.05,499841.05,'728','2022-06-10 23:29:37','761','2022-06-11 06:13:29',10,0),('1','206',257790,'MORNING SHIFT','2022-06-11','2022-06-11 16:57:00','2022-06-12 16:57:00','728',471355.70,471355.70,'728','2022-06-11 16:59:11','533','2022-06-12 15:02:54',10,0),('1','206',257791,'MORNING SHIFT','2022-06-12','2022-06-12 16:36:44','2022-06-13 16:36:44','728',713065.65,713065.65,'728','2022-06-12 16:39:14','533','2022-06-13 06:20:52',10,0),('1','206',257792,'AFTERNOON SHIFT','2022-06-12','2022-06-13 14:02:51','2022-06-14 14:02:51','728',2552732.45,2552732.45,'728','2022-06-13 14:06:53','761','2022-06-13 15:37:52',10,0),('1','206',257793,'MORNING SHIFT','2022-06-13','2022-06-13 17:04:37','2022-06-14 17:04:37','728',807711.85,807711.85,'728','2022-06-13 17:10:03','533','2022-06-13 19:58:50',10,0),('1','206',257794,'AFTERNOON SHIFT','2022-06-13','2022-06-14 08:48:58','2022-06-15 08:48:58','728',714920.40,714920.40,'728','2022-06-14 08:50:40','761','2022-06-14 10:00:05',10,0),('1','206',257795,'AFTERNOON SHIFT','2022-06-14','2022-06-14 18:56:51','2022-06-15 18:56:51','728',997872.20,997872.20,'728','2022-06-14 19:49:21','533','2022-06-15 07:14:42',10,0),('1','206',257796,'AFTERNOON SHIFT','2022-06-15','2022-06-15 19:05:54','2022-06-16 19:05:54','728',1575725.55,1575725.55,'728','2022-06-15 20:49:00','761','2022-06-16 09:21:10',10,0),('1','206',257797,'MORNING SHIFT','2022-06-16','2022-06-16 13:52:59','2022-06-17 13:52:59','728',723170.65,723170.65,'728','2022-06-16 13:58:30','533','2022-06-17 09:22:13',10,0),('1','206',257798,'AFTERNOON SHIFT','2022-06-16','2022-06-17 10:13:32','2022-06-18 10:13:32','728',1522063.80,1522063.80,'728','2022-06-17 10:16:53','761','2022-06-17 14:24:13',10,0),('1','206',257799,'MORNING SHIFT','2022-06-17','2022-06-17 17:06:33','2022-06-18 17:06:33','728',622862.50,622862.50,'728','2022-06-17 18:40:26','761','2022-06-17 22:42:23',10,0),('1','206',257800,'AFTERNOON SHIFT','2022-06-18','2022-06-18 17:55:18','2022-06-19 17:55:18','728',546800.15,546800.15,'728','2022-06-18 19:05:31','533','2022-06-19 09:25:52',10,0),('1','206',257801,'MORNING SHIFT','2022-06-21','2022-06-21 11:42:51','2022-06-22 11:42:51','728',4130987.85,4130987.85,'728','2022-06-21 14:27:54','533','2022-06-21 19:51:51',10,0),('1','206',257802,'AFTERNOON SHIFT','2022-06-21','2022-06-22 08:03:18','2022-06-23 08:03:18','728',143449.85,143449.85,'728','2022-06-22 08:07:02','533','2022-06-22 14:41:57',10,0),('1','206',257803,'MORNING SHIFT','2022-06-23','2022-06-23 13:43:10','2022-06-24 13:43:10','728',709629.05,709629.05,'728','2022-06-23 14:13:36','533','2022-06-23 21:41:03',10,0),('1','206',257804,'AFTERNOON SHIFT','2022-06-25','2022-06-25 19:12:59','2022-06-26 19:12:59','728',315027.90,315027.90,'728','2022-06-25 19:22:39','533','2022-06-26 11:44:11',10,0),('1','206',257805,'MORNING SHIFT','2022-06-26','2022-06-26 14:10:40','2022-06-27 14:10:40','728',2041770.70,2041770.70,'728','2022-06-27 09:14:34','761','2022-06-27 09:51:41',10,0),('1','206',257806,'AFTERNOON SHIFT','2022-06-26','2022-06-27 10:16:03','2022-06-28 10:16:03','728',1744927.20,1744927.20,'728','2022-06-27 10:19:04','761','2022-06-27 16:24:35',10,0),('1','206',257807,'AFTERNOON SHIFT','2022-06-30','2022-06-30 18:03:14','2022-07-01 18:03:14','728',526546.35,526546.35,'728','2022-06-30 19:04:01','533','2022-06-30 21:25:55',10,0),('1','206',257808,'AFTERNOON SHIFT','2022-07-04','2022-07-05 09:38:30','2022-07-06 09:38:30','728',959644.10,959644.10,'728','2022-07-05 10:23:45','761','2022-07-05 14:06:01',10,0),('1','206',257809,'MORNING SHIFT','2022-07-05','2022-07-05 17:02:13','2022-07-06 17:02:13','728',2549503.10,2549503.10,'728','2022-07-05 17:17:00','533','2022-07-06 08:35:23',10,0),('1','206',257810,'MORNING SHIFT','2022-07-06','2022-07-06 14:08:57','2022-07-07 14:08:57','728',1267385.85,1267385.85,'728','2022-07-06 14:12:45','533','2022-07-06 19:43:24',10,0),('1','206',257811,'AFTERNOON SHIFT','2022-07-06','2022-07-06 22:30:37','2022-07-07 22:30:37','728',855022.45,855022.45,'728','2022-07-06 22:35:02','533','2022-07-07 12:34:43',10,0),('1','206',257812,'AFTERNOON SHIFT','2022-07-07','2022-07-08 11:03:01','2022-07-09 11:03:01','728',635470.15,635470.15,'728','2022-07-08 12:19:39','533','2022-07-09 08:08:48',10,0),('1','206',257813,'AFTERNOON SHIFT','2022-07-08','2022-07-09 15:43:51','2022-07-10 15:43:51','728',880986.75,880986.75,'728','2022-07-09 15:48:25','533','2022-07-09 16:32:22',10,0),('1','206',257814,'AFTERNOON SHIFT','2022-07-17','2022-07-17 17:36:17','2022-07-18 17:36:17','728',1645289.30,1645289.30,'728','2022-07-17 17:42:22','533','2022-07-17 19:34:43',10,0),('1','206',257815,'MORNING SHIFT','2022-07-25','2022-07-25 20:30:21','2022-07-26 20:30:21','728',1454213.10,1454213.10,'728','2022-07-25 20:42:51','913','2022-07-25 20:52:06',10,0),('1','206',257816,'AFTERNOON SHIFT','2022-07-25','2022-07-26 11:35:27','2022-07-27 11:35:27','728',827831.30,827831.30,'728','2022-07-26 11:47:33','913','2022-07-26 12:18:22',10,0),('1','206',257817,'MORNING SHIFT','2022-07-26','2022-07-26 13:32:03','2022-07-27 13:32:03','728',1559038.00,1559038.00,'728','2022-07-26 19:54:46','913','2022-07-27 10:03:24',10,0),('1','206',257818,'AFTERNOON SHIFT','2022-07-26','2022-07-27 12:15:47','2022-07-28 12:15:47','728',1162870.20,1162870.20,'728','2022-07-27 12:20:37','913','2022-07-27 17:18:00',10,0),('1','206',257819,'MORNING SHIFT','2022-07-27','2022-07-27 18:29:46','2022-07-28 18:29:46','728',685506.05,685506.05,'728','2022-07-27 18:31:03','913','2022-07-27 18:59:04',10,0),('1','206',257820,'AFTERNOON SHIFT','2022-07-27','2022-07-27 20:36:01','2022-07-28 20:36:01','728',874570.65,874570.65,'728','2022-07-28 09:47:00','913','2022-07-28 10:11:13',10,0),('1','206',257821,'MORNING SHIFT','2022-07-28','2022-07-28 13:35:07','2022-07-29 13:35:07','728',1094643.15,1094643.15,'728','2022-07-28 14:32:07','913','2022-07-28 15:52:27',10,0),('1','206',257822,'AFTERNOON SHIFT','2022-07-28','2022-07-28 19:47:32','2022-07-29 19:47:32','728',784519.20,784519.20,'728','2022-07-28 19:52:22','913','2022-07-28 20:03:42',10,0),('1','206',257823,'MORNING SHIFT','2022-07-29','2022-07-29 13:27:05','2022-07-30 13:27:05','728',2010485.50,2010485.50,'728','2022-07-29 14:24:39','913','2022-07-29 17:10:46',10,0),('1','206',257824,'AFTERNOON SHIFT','2022-07-29','2022-07-29 20:12:09','2022-07-30 20:12:09','728',1227758.05,1227758.05,'728','2022-07-29 20:30:36','913','2022-07-29 21:00:31',10,0),('1','206',257825,'MORNING SHIFT','2022-07-30','2022-07-30 14:15:43','2022-07-31 14:15:43','728',1219407.15,1219407.15,'728','2022-07-30 14:20:21','913','2022-07-30 16:19:05',10,0),('1','206',257826,'AFTERNOON SHIFT','2022-07-30','2022-07-30 17:19:52','2022-07-31 17:19:52','728',773220.45,773220.45,'728','2022-07-30 17:35:16','913','2022-07-30 22:08:27',10,0),('1','206',257827,'MORNING SHIFT','2022-07-31','2022-07-31 12:41:03','2022-08-01 12:41:03','728',349827.60,349827.60,'728','2022-07-31 13:14:56','913','2022-07-31 20:00:26',10,0),('1','206',257828,'MORNING SHIFT','2022-08-01','2022-08-01 17:59:18','2022-08-02 17:59:18','728',0.00,0.00,'728','2022-08-01 18:11:14','913','2022-08-01 18:18:19',10,0),('1','206',257829,'AFTERNOON SHIFT','2022-07-31','2022-08-01 18:19:17','2022-08-02 18:19:17','728',1315074.35,1315074.35,'728','2022-08-01 18:21:05','913','2022-08-01 18:22:14',10,0),('1','206',257830,'MORNING SHIFT','2022-08-01','2022-08-01 18:23:28','2022-08-02 18:23:28','728',2629326.75,2629326.75,'728','2022-08-01 18:29:43','913','2022-08-01 18:39:21',10,0),('1','206',257831,'AFTERNOON SHIFT','2022-08-01','2022-08-01 18:39:40','2022-08-02 18:39:40','728',593764.60,593764.60,'728','2022-08-01 18:54:38','913','2022-08-01 20:30:57',10,0),('1','206',257832,'MORNING SHIFT','2022-08-02','2022-08-02 14:02:57','2022-08-03 14:02:57','728',893329.85,893329.85,'728','2022-08-02 14:05:41','913','2022-08-02 16:10:19',10,0),('1','206',257833,'AFTERNOON SHIFT','2022-08-02','2022-08-02 18:05:47','2022-08-03 18:05:47','728',844932.00,844932.00,'728','2022-08-02 21:11:13','913','2022-08-02 21:50:43',10,0),('1','206',257834,'MORNING SHIFT','2022-08-03','2022-08-03 12:01:30','2022-08-04 12:01:30','728',2036607.45,2036607.45,'728','2022-08-03 14:24:25','913','2022-08-03 14:36:58',10,0),('1','206',257835,'AFTERNOON SHIFT','2022-08-03','2022-08-03 20:26:20','2022-08-04 20:26:20','728',1228339.95,1228339.95,'728','2022-08-03 20:46:46','913','2022-08-03 21:29:58',10,0),('1','206',257836,'MORNING SHIFT','2022-08-04','2022-08-04 14:07:33','2022-08-05 14:07:33','728',1105583.05,1105583.05,'728','2022-08-04 14:10:14','913','2022-08-04 15:31:55',10,0),('1','206',257837,'AFTERNOON SHIFT','2022-08-04','2022-08-04 20:45:22','2022-08-05 20:45:22','728',1566473.95,1566473.95,'728','2022-08-04 20:51:54','913','2022-08-05 11:12:03',10,0),('1','206',257838,'MORNING SHIFT','2022-08-05','2022-08-05 18:25:52','2022-08-06 18:25:52','728',1278029.95,1278029.95,'728','2022-08-05 18:30:12','913','2022-08-05 23:26:55',10,0),('1','206',257839,'AFTERNOON SHIFT','2022-08-05','2022-08-06 00:33:19','2022-08-07 00:33:19','728',585217.90,585217.90,'728','2022-08-06 00:37:35','913','2022-08-06 14:21:46',10,0),('1','206',257840,'MORNING SHIFT','2022-08-06','2022-08-06 14:54:30','2022-08-07 14:54:30','728',2315882.15,2315882.15,'728','2022-08-06 14:57:49','913','2022-08-06 16:29:12',10,0),('1','206',257841,'AFTERNOON SHIFT','2022-08-06','2022-08-06 19:45:54','2022-08-07 19:45:54','728',1023442.20,1023442.20,'728','2022-08-06 20:19:07','913','2022-08-06 20:27:34',10,0),('1','206',257842,'MORNING SHIFT','2022-08-07','2022-08-07 18:01:53','2022-08-08 18:01:53','728',1402608.95,1402608.95,'728','2022-08-07 18:36:15','913','2022-08-07 23:08:07',10,0),('1','206',257843,'AFTERNOON SHIFT','2022-08-07','2022-08-08 10:51:26','2022-08-09 10:51:26','728',1573447.20,1573447.20,'728','2022-08-08 10:53:24','913','2022-08-08 11:25:49',10,0),('1','206',257844,'MORNING SHIFT','2022-08-08','2022-08-08 12:14:44','2022-08-09 12:14:44','728',1817475.15,1817475.15,'728','2022-08-08 18:19:46','913','2022-08-08 18:54:01',10,0),('1','206',257845,'AFTERNOON SHIFT','2022-08-08','2022-08-08 19:28:09','2022-08-09 19:28:09','728',1408168.20,1408168.20,'728','2022-08-08 19:32:10','913','2022-08-08 22:44:17',10,0),('1','206',257846,'MORNING SHIFT','2022-08-09','2022-08-09 09:06:24','2022-08-10 09:06:24','728',1665340.05,1665340.05,'728','2022-08-09 14:47:10','913','2022-08-09 14:55:58',10,0),('1','206',257847,'AFTERNOON SHIFT','2022-08-09','2022-08-09 16:43:33','2022-08-10 16:43:33','728',1633732.30,1633732.30,'728','2022-08-09 20:28:03','913','2022-08-09 21:14:39',10,0),('1','206',257848,'MORNING SHIFT','2022-08-10','2022-08-10 14:09:35','2022-08-11 14:09:35','728',690712.30,690712.30,'728','2022-08-10 14:31:23','913','2022-08-10 14:34:49',10,0),('1','206',257849,'AFTERNOON SHIFT','2022-08-10','2022-08-10 17:39:34','2022-08-11 17:39:34','728',693365.05,693365.05,'728','2022-08-10 18:46:37','913','2022-08-10 19:00:11',10,0),('1','206',257850,'AFTERNOON SHIFT','2022-08-11','2022-08-11 11:47:20','2022-08-12 11:47:20','728',1783781.10,1783781.10,'728','2022-08-11 14:24:59','913','2022-08-11 14:57:43',10,0),('1','206',257851,'AFTERNOON SHIFT','2022-08-11','2022-08-11 19:58:40','2022-08-12 19:58:40','728',1890639.10,1890639.10,'728','2022-08-11 20:35:54','913','2022-08-11 21:00:23',10,0),('1','206',257852,'MORNING SHIFT','2022-08-12','2022-08-12 16:18:29','2022-08-13 16:18:29','728',1089410.00,1089410.00,'728','2022-08-12 16:25:42','913','2022-08-12 16:30:39',10,0),('1','206',257853,'AFTERNOON SHIFT','2022-08-12','2022-08-12 16:32:24','2022-08-13 16:32:24','728',836692.10,836692.10,'728','2022-08-13 11:38:05','913','2022-08-13 14:31:03',10,0),('1','206',257854,'MORNING SHIFT','2022-08-13','2022-08-13 15:27:33','2022-08-14 15:27:33','728',931891.25,931891.25,'728','2022-08-13 15:30:36','913','2022-08-13 20:20:24',10,0),('1','206',257855,'AFTERNOON SHIFT','2022-08-15','2022-08-16 10:59:09','2022-08-17 10:59:09','728',1204863.85,1204863.85,'728','2022-08-16 12:19:50','913','2022-08-16 14:15:52',10,0),('1','206',257856,'AFTERNOON SHIFT','2022-08-17','2022-08-17 19:16:08','2022-08-18 19:16:08','728',928830.55,928830.55,'728','2022-08-17 19:23:12','913','2022-08-17 22:43:59',10,0),('1','206',257857,'MORNING SHIFT','2022-08-18','2022-08-18 14:06:11','2022-08-19 14:06:11','728',689785.45,689785.45,'728','2022-08-18 14:56:32','913','2022-08-18 16:41:06',10,0),('1','206',257858,'AFTERNOON SHIFT','2022-08-18','2022-08-18 21:10:21','2022-08-19 21:10:21','728',1150827.85,1150827.85,'728','2022-08-18 21:13:54','913','2022-08-19 10:02:09',10,0),('1','206',257859,'MORNING SHIFT','2022-08-19','2022-08-19 17:42:34','2022-08-20 17:42:34','728',762402.95,762402.95,'728','2022-08-19 17:47:44','913','2022-08-19 18:48:33',10,0),('1','206',257860,'AFTERNOON SHIFT','2022-08-19','2022-08-19 21:14:46','2022-08-20 21:14:46','728',994434.55,994434.55,'728','2022-08-19 21:39:51','913','2022-08-19 21:48:34',10,0),('1','206',257861,'MORNING SHIFT','2022-08-20','2022-08-20 16:10:46','2022-08-21 16:10:46','728',665777.30,665777.30,'728','2022-08-20 16:13:50','913','2022-08-20 16:30:17',10,0),('1','206',257862,'AFTERNOON SHIFT','2022-08-20','2022-08-20 17:18:35','2022-08-21 17:18:35','728',1649221.10,1649221.10,'728','2022-08-20 21:46:06','913','2022-08-21 08:26:00',10,0),('1','206',257863,'MORNING SHIFT','2022-08-21','2022-08-21 11:58:37','2022-08-22 11:58:37','728',672257.65,672257.65,'728','2022-08-21 14:11:45','913','2022-08-21 14:36:40',10,0),('1','206',257864,'AFTERNOON SHIFT','2022-08-21','2022-08-22 10:33:14','2022-08-23 10:33:14','728',1318851.75,1318851.75,'728','2022-08-22 10:43:14','913','2022-08-22 11:27:17',10,0),('1','206',257865,'MORNING SHIFT','2022-08-22','2022-08-22 13:10:44','2022-08-23 13:10:44','728',612161.30,612161.30,'728','2022-08-22 17:33:23','913','2022-08-22 17:43:49',10,0),('1','206',257866,'AFTERNOON SHIFT','2022-08-22','2022-08-22 19:04:01','2022-08-23 19:04:01','728',788266.95,788266.95,'728','2022-08-22 20:28:47','913','2022-08-22 22:12:46',10,0),('1','206',257867,'MORNING SHIFT','2022-08-23','2022-08-23 13:54:55','2022-08-24 13:54:55','728',645255.95,645255.95,'728','2022-08-23 13:58:29','913','2022-08-23 15:18:35',10,0),('1','206',257868,'AFTERNOON SHIFT','2022-08-23','2022-08-23 20:47:39','2022-08-24 20:47:39','728',770303.00,770303.00,'728','2022-08-23 21:26:16','913','2022-08-24 09:11:46',10,0),('1','206',257869,'MORNING SHIFT','2022-08-24','2022-08-24 14:32:23','2022-08-25 14:32:23','728',1344646.00,1344646.00,'728','2022-08-24 14:34:25','913','2022-08-24 15:04:31',10,0),('1','206',257870,'AFTERNOON SHIFT','2022-08-24','2022-08-24 19:58:56','2022-08-25 19:58:56','728',767400.40,767400.40,'728','2022-08-24 22:47:57','761','2022-08-25 11:18:25',10,0),('1','206',257871,'MORNING SHIFT','2022-08-25','2022-08-25 14:03:35','2022-08-26 14:03:35','728',678203.80,678203.80,'728','2022-08-25 14:08:14','913','2022-08-25 14:29:27',10,0),('1','206',257872,'AFTERNOON SHIFT','2022-08-25','2022-08-25 20:49:39','2022-08-26 20:49:39','728',742108.90,742108.90,'728','2022-08-25 20:52:41','913','2022-08-25 21:30:46',10,0),('1','206',257873,'MORNING SHIFT','2022-08-26','2022-08-26 15:59:24','2022-08-27 15:59:24','728',672314.05,672314.05,'728','2022-08-26 16:01:41','913','2022-08-26 16:31:07',10,0),('1','206',257874,'AFTERNOON SHIFT','2022-08-26','2022-08-26 19:35:22','2022-08-27 19:35:22','728',1032436.55,1032436.55,'728','2022-08-26 21:45:59','913','2022-08-26 22:19:07',10,0),('1','206',257875,'MORNING SHIFT','2022-08-27','2022-08-27 13:06:45','2022-08-28 13:06:45','728',978091.30,978091.30,'728','2022-08-27 13:37:22','913','2022-08-27 16:43:24',10,0),('1','206',257876,'AFTERNOON SHIFT','2022-08-27','2022-08-27 17:56:07','2022-08-28 17:56:07','728',852433.80,852433.80,'728','2022-08-27 20:46:46','913','2022-08-27 21:34:05',10,0),('1','206',257877,'MORNING SHIFT','2022-08-28','2022-08-28 17:13:14','2022-08-29 17:13:14','728',1357699.10,1357699.10,'728','2022-08-28 17:15:54','913','2022-08-28 18:14:13',10,0),('1','206',257878,'AFTERNOON SHIFT','2022-08-28','2022-08-28 21:03:23','2022-08-29 21:03:23','728',1311809.60,1311809.60,'728','2022-08-28 21:16:05','761','2022-08-29 09:31:12',10,0),('1','206',257879,'MORNING SHIFT','2022-08-29','2022-08-29 14:50:29','2022-08-30 14:50:29','728',1508730.70,1508730.70,'728','2022-08-29 14:56:54','913','2022-08-29 16:58:56',10,0),('1','206',257880,'AFTERNOON SHIFT','2022-08-29','2022-08-29 18:01:26','2022-08-30 18:01:26','728',217998.45,217998.45,'728','2022-08-29 18:19:11','913','2022-08-29 20:21:32',10,0),('1','206',257881,'MORNING SHIFT','2022-08-31','2022-08-31 14:14:42','2022-09-01 14:14:42','728',596456.65,596456.65,'728','2022-08-31 14:16:51','913','2022-08-31 14:27:27',10,0),('1','206',257882,'MORNING SHIFT','2022-09-02','2022-09-02 13:37:20','2022-09-03 13:37:20','728',2123581.80,2123581.80,'728','2022-09-02 14:44:18','913','2022-09-02 15:14:20',10,0),('1','206',257883,'AFTERNOON SHIFT','2022-09-02','2022-09-02 20:23:07','2022-09-03 20:23:07','728',823250.15,823250.15,'728','2022-09-02 20:50:50','913','2022-09-02 23:41:17',10,0),('1','206',257884,'MORNING SHIFT','2022-09-03','2022-09-03 14:07:32','2022-09-04 14:07:32','728',459134.10,459134.10,'728','2022-09-03 14:31:29','913','2022-09-03 18:10:37',10,0),('1','206',257885,'AFTERNOON SHIFT','2022-09-03','2022-09-03 20:00:06','2022-09-04 20:00:06','728',840923.20,840923.20,'728','2022-09-04 08:45:42','913','2022-09-04 12:07:40',10,0),('1','206',257886,'MORNING SHIFT','2022-09-04','2022-09-04 14:00:35','2022-09-05 14:00:35','728',1652087.15,1652087.15,'728','2022-09-04 14:32:39','913','2022-09-04 14:43:00',10,0),('1','206',257887,'AFTERNOON SHIFT','2022-09-04','2022-09-05 09:10:50','2022-09-06 09:10:50','728',608437.35,608437.35,'728','2022-09-05 14:51:41','913','2022-09-05 15:39:12',10,0),('1','206',257888,'AFTERNOON SHIFT','2022-09-05','2022-09-05 19:00:03','2022-09-06 19:00:03','728',754531.95,754531.95,'728','2022-09-05 21:12:03','913','2022-09-05 23:23:55',10,0),('1','206',257889,'MORNING SHIFT','2022-09-06','2022-09-06 13:21:59','2022-09-07 13:21:59','728',547871.10,547871.10,'728','2022-09-06 14:35:52','913','2022-09-06 14:41:21',10,0),('1','206',257890,'AFTERNOON SHIFT','2022-09-06','2022-09-06 20:43:35','2022-09-07 20:43:35','728',1173476.35,1173476.35,'728','2022-09-06 21:04:27','913','2022-09-07 11:39:08',10,0),('1','206',257891,'MORNING SHIFT','2022-09-07','2022-09-07 13:43:12','2022-09-08 13:43:12','728',574074.50,574074.50,'728','2022-09-07 13:55:50','913','2022-09-07 14:56:54',10,0),('1','206',257892,'AFTERNOON SHIFT','2022-09-08','2022-09-08 07:43:00','2022-09-09 07:43:00','728',964189.05,964189.05,'728','2022-09-08 07:45:23','913','2022-09-08 11:04:56',10,0),('1','206',257893,'MORNING SHIFT','2022-09-08','2022-09-08 14:14:55','2022-09-09 14:14:55','728',1798590.90,1798590.90,'728','2022-09-08 14:19:26','913','2022-09-08 14:59:25',10,0),('1','206',257894,'AFTERNOON SHIFT','2022-09-08','2022-09-08 19:36:57','2022-09-09 19:36:57','728',670447.80,670447.80,'728','2022-09-08 21:13:14','913','2022-09-08 22:22:11',10,0),('1','206',257895,'MORNING SHIFT','2022-09-09','2022-09-09 18:46:19','2022-09-10 18:46:19','728',843216.85,843216.85,'728','2022-09-09 18:50:18','913','2022-09-09 22:55:57',10,0),('1','206',257896,'AFTERNOON SHIFT','2022-09-09','2022-09-10 13:28:26','2022-09-11 13:28:26','728',852083.60,852083.60,'728','2022-09-10 13:31:16','913','2022-09-10 15:45:43',10,0),('1','206',257897,'MORNING SHIFT','2022-09-10','2022-09-10 20:19:28','2022-09-11 20:19:28','728',877140.80,877140.80,'728','2022-09-10 20:50:52','913','2022-09-10 20:54:11',10,0),('1','206',257898,'AFTERNOON SHIFT','2022-09-10','2022-09-10 20:58:56','2022-09-11 20:58:56','728',787771.65,787771.65,'728','2022-09-10 21:00:15','913','2022-09-11 08:46:01',10,0),('1','206',257899,'MORNING SHIFT','2022-09-11','2022-09-11 13:56:48','2022-09-12 13:56:48','728',506171.10,506171.10,'728','2022-09-11 14:12:36','913','2022-09-11 14:44:28',10,0),('1','206',257900,'AFTERNOON SHIFT','2022-09-11','2022-09-11 19:51:07','2022-09-12 19:51:07','728',689937.90,689937.90,'728','2022-09-11 20:10:07','913','2022-09-11 21:58:43',10,0),('1','206',257901,'MORNING SHIFT','2022-09-12','2022-09-12 16:21:49','2022-09-13 16:21:49','728',655079.35,655079.35,'728','2022-09-12 16:23:26','913','2022-09-12 16:27:59',10,0),('1','206',257902,'AFTERNOON SHIFT','2022-09-12','2022-09-12 19:53:05','2022-09-13 19:53:05','728',938437.35,938437.35,'728','2022-09-12 21:25:23','913','2022-09-12 21:39:21',10,0),('1','206',257903,'MORNING SHIFT','2022-09-13','2022-09-13 14:19:58','2022-09-14 14:19:58','728',440342.55,440342.55,'728','2022-09-13 14:33:07','913','2022-09-13 15:35:30',10,0),('1','206',257904,'AFTERNOON SHIFT','2022-09-13','2022-09-13 21:29:57','2022-09-14 21:29:57','728',1433479.10,1433479.10,'728','2022-09-13 21:32:28','913','2022-09-13 21:59:54',10,0),('1','206',257905,'MORNING SHIFT','2022-09-14','2022-09-14 15:05:42','2022-09-15 15:05:42','728',847915.20,847915.20,'728','2022-09-14 15:08:05','913','2022-09-14 15:23:13',10,0),('1','206',257906,'AFTERNOON SHIFT','2022-09-14','2022-09-14 21:05:00','2022-09-15 21:05:00','728',1556600.90,1556600.90,'728','2022-09-14 21:08:17','913','2022-09-14 22:01:57',10,0),('1','206',257907,'MORNING SHIFT','2022-09-15','2022-09-15 13:58:24','2022-09-16 13:58:24','728',713357.60,713357.60,'728','2022-09-15 14:00:53','913','2022-09-15 16:03:01',10,0),('1','206',257908,'AFTERNOON SHIFT','2022-09-15','2022-09-15 17:08:18','2022-09-16 17:08:18','728',1156351.05,1156351.05,'728','2022-09-15 20:52:02','913','2022-09-15 21:28:34',10,0),('1','206',257909,'MORNING SHIFT','2022-09-16','2022-09-16 13:40:43','2022-09-17 13:40:43','728',657419.85,657419.85,'728','2022-09-16 13:50:56','913','2022-09-16 14:38:13',10,0),('1','206',257910,'AFTERNOON SHIFT','2022-09-16','2022-09-16 20:18:45','2022-09-17 20:18:45','728',889460.20,889460.20,'728','2022-09-16 20:39:20','913','2022-09-16 21:09:21',10,0),('1','206',257911,'MORNING SHIFT','2022-09-17','2022-09-17 14:08:50','2022-09-18 14:08:50','728',1042067.30,1042067.30,'728','2022-09-17 14:10:28','913','2022-09-17 17:18:37',10,0),('1','206',257912,'AFTERNOON SHIFT','2022-09-17','2022-09-17 20:55:57','2022-09-18 20:55:57','728',1106357.20,1106357.20,'728','2022-09-17 21:03:30','913','2022-09-17 21:09:07',10,0),('1','206',257913,'MORNING SHIFT','2022-09-18','2022-09-18 13:53:41','2022-09-19 13:53:41','728',698345.40,698345.40,'728','2022-09-18 14:18:22','913','2022-09-18 14:44:37',10,0),('1','206',257914,'AFTERNOON SHIFT','2022-09-18','2022-09-18 19:45:50','2022-09-19 19:45:50','728',892259.35,892259.35,'728','2022-09-18 20:11:54','913','2022-09-19 01:24:26',10,0),('1','206',257915,'MORNING SHIFT','2022-09-19','2022-09-19 10:51:23','2022-09-20 10:51:23','728',648920.80,648920.80,'728','2022-09-19 13:52:13','913','2022-09-19 16:23:42',10,0),('1','206',257916,'AFTERNOON SHIFT','2022-09-19','2022-09-19 19:27:50','2022-09-20 19:27:50','728',857972.65,857972.65,'728','2022-09-19 20:41:34','913','2022-09-19 22:15:26',10,0),('1','206',257917,'MORNING SHIFT','2022-09-20','2022-09-20 14:26:40','2022-09-21 14:26:40','728',831177.25,831177.25,'728','2022-09-20 14:33:33','913','2022-09-20 15:59:30',10,0),('1','206',257918,'AFTERNOON SHIFT','2022-09-20','2022-09-20 21:12:19','2022-09-21 21:12:19','728',1144674.55,1144674.55,'728','2022-09-20 21:18:31','913','2022-09-20 22:30:51',10,0),('1','206',257919,'MORNING SHIFT','2022-09-21','2022-09-21 13:39:51','2022-09-22 13:39:51','728',753220.10,753220.10,'728','2022-09-21 14:14:09','913','2022-09-21 15:56:39',10,0),('1','206',257920,'AFTERNOON SHIFT','2022-09-21','2022-09-21 19:50:33','2022-09-22 19:50:33','728',1007577.70,1007577.70,'728','2022-09-21 21:10:38','913','2022-09-22 00:48:35',10,0),('1','206',257921,'MORNING SHIFT','2022-09-22','2022-09-22 14:22:38','2022-09-23 14:22:38','728',565152.80,565152.80,'728','2022-09-22 14:25:02','913','2022-09-22 15:16:29',10,0),('1','206',257922,'AFTERNOON SHIFT','2022-09-22','2022-09-22 21:38:52','2022-09-23 21:38:52','728',623287.20,623287.20,'728','2022-09-22 21:41:48','913','2022-09-22 21:55:54',10,0),('1','206',257923,'MORNING SHIFT','2022-09-23','2022-09-23 14:13:37','2022-09-24 14:13:37','728',568207.15,568207.15,'728','2022-09-23 14:15:08','913','2022-09-23 15:35:19',10,0),('1','206',257924,'AFTERNOON SHIFT','2022-09-23','2022-09-23 20:23:58','2022-09-24 20:23:58','728',632120.95,632120.95,'728','2022-09-23 20:40:17','913','2022-09-24 02:27:28',10,0),('1','206',257925,'MORNING SHIFT','2022-09-24','2022-09-24 16:39:39','2022-09-25 16:39:39','728',667599.90,667599.90,'728','2022-09-24 16:48:39','913','2022-09-24 22:36:33',10,0),('1','206',257926,'AFTERNOON SHIFT','2022-09-24','2022-09-25 12:40:21','2022-09-26 12:40:21','728',1026421.55,1026421.55,'728','2022-09-25 12:43:13','913','2022-09-25 15:06:07',10,0),('1','206',257927,'MORNING SHIFT','2022-09-25','2022-09-25 16:21:27','2022-09-26 16:21:27','728',1290772.80,1290772.80,'728','2022-09-25 16:24:15','913','2022-09-25 16:56:26',10,0),('1','206',257928,'AFTERNOON SHIFT','2022-09-25','2022-09-25 20:24:28','2022-09-26 20:24:28','728',1495536.25,1495536.25,'728','2022-09-26 09:54:21','761','2022-09-26 10:01:01',10,0),('1','206',257929,'MORNING SHIFT','2022-09-26','2022-09-26 10:04:48','2022-09-27 10:04:48','728',577403.65,577403.65,'728','2022-09-26 14:27:48','913','2022-09-26 15:35:56',10,0),('1','206',257930,'AFTERNOON SHIFT','2022-09-26','2022-09-26 20:41:43','2022-09-27 20:41:43','728',891338.40,891338.40,'728','2022-09-26 21:13:28','913','2022-09-26 22:16:48',10,0),('1','206',257931,'MORNING SHIFT','2022-09-27','2022-09-27 13:18:57','2022-09-28 13:18:57','728',877220.05,877220.05,'728','2022-09-27 14:21:29','913','2022-09-27 15:05:41',10,0),('1','206',257932,'AFTERNOON SHIFT','2022-09-27','2022-09-27 17:54:44','2022-09-28 17:54:44','728',1750840.00,1750840.00,'728','2022-09-27 20:22:11','913','2022-09-27 22:50:18',10,0),('1','206',257933,'MORNING SHIFT','2022-09-28','2022-09-28 14:29:09','2022-09-29 14:29:09','728',762531.15,762531.15,'728','2022-09-28 14:31:02','913','2022-09-28 16:16:34',10,0),('1','206',257934,'AFTERNOON SHIFT','2022-10-02','2022-10-02 19:44:05','2022-10-03 19:44:05','728',2593288.60,2593288.60,'728','2022-10-04 12:11:48','913','2022-10-04 17:04:59',10,0),('1','206',257935,'MORNING SHIFT','2022-10-06','2022-10-06 15:15:58','2022-10-07 15:15:58','728',1371475.85,1371475.85,'728','2022-10-06 15:18:58','913','2022-10-07 05:17:10',10,0),('1','206',257936,'AFTERNOON SHIFT','2022-10-06','2022-10-07 17:23:25','2022-10-08 17:23:25','728',182394.45,182394.45,'728','2022-10-07 17:26:52','913','2022-10-08 06:24:22',10,0),('1','206',257937,'MORNING SHIFT','2022-10-08','2022-10-08 17:22:30','2022-10-09 17:22:30','728',1079799.40,1079799.40,'728','2022-10-08 17:24:44','913','2022-10-08 17:33:47',10,0),('1','206',257938,'MORNING SHIFT','2022-10-08','2022-10-08 17:43:38','2022-10-09 17:43:38','728',508044.70,508044.70,'728','2022-10-08 18:47:28','913','2022-10-08 19:45:05',10,0),('1','206',257939,'AFTERNOON SHIFT','2022-10-08','2022-10-08 19:46:24','2022-10-09 19:46:24','728',502527.90,502527.90,'728','2022-10-09 13:32:35','913','2022-10-09 13:33:55',10,0),('1','206',257940,'MORNING SHIFT','2022-10-11','2022-10-11 15:53:08','2022-10-12 15:53:08','728',1520844.50,1520844.50,'728','2022-10-11 15:54:30','913','2022-10-11 18:42:14',10,0),('1','206',257941,'AFTERNOON SHIFT','2022-10-12','2022-10-12 18:25:48','2022-10-13 18:25:48','728',178206.45,178206.45,'728','2022-10-12 18:27:53','913','2022-10-12 23:49:46',10,0),('1','206',257942,'MORNING SHIFT','2022-10-16','2022-10-16 14:15:42','2022-10-17 14:15:42','728',0.00,0.00,'728','2022-10-16 15:11:49','913','2022-10-16 15:13:14',10,0),('1','206',257943,'MORNING SHIFT','2022-10-16','2022-10-16 15:16:17','2022-10-17 15:16:17','728',1815902.10,1815902.10,'728','2022-10-16 15:19:49','913','2022-10-16 15:33:46',10,0),('1','206',257944,'AFTERNOON SHIFT','2022-10-16','2022-10-16 17:47:30','2022-10-17 17:47:30','728',1567779.15,1567779.15,'728','2022-10-16 22:51:59','913','2022-10-17 08:30:32',10,0),('1','206',257945,'MORNING SHIFT','2022-10-17','2022-10-17 13:49:49','2022-10-18 13:49:49','728',929465.90,929465.90,'728','2022-10-17 14:04:04','913','2022-10-17 15:43:39',10,0),('1','206',257946,'AFTERNOON SHIFT','2022-10-17','2022-10-18 12:29:43','2022-10-19 12:29:43','728',487550.30,487550.30,'728','2022-10-18 12:34:59','913','2022-10-18 14:29:20',10,0),('1','206',257947,'MORNING SHIFT','2022-10-20','2022-10-20 12:32:24','2022-10-21 12:32:24','728',3770673.30,3770673.30,'728','2022-10-20 17:44:07','913','2022-10-20 20:04:56',10,0),('1','206',257948,'AFTERNOON SHIFT','2022-10-20','2022-10-21 14:35:10','2022-10-22 14:35:10','728',1109810.15,1109810.15,'728','2022-10-21 14:37:57','913','2022-10-21 15:40:27',10,0),('1','206',257949,'MORNING SHIFT','2022-10-21','2022-10-21 16:27:51','2022-10-22 16:27:51','728',603059.60,603059.60,'728','2022-10-21 19:39:16','913','2022-10-21 20:19:11',10,0),('1','206',257950,'AFTERNOON SHIFT','2022-10-21','2022-10-22 07:56:09','2022-10-23 07:56:09','728',411915.45,411915.45,'728','2022-10-22 08:55:22','913','2022-10-22 09:18:12',10,0),('1','206',257951,'MORNING SHIFT','2022-10-22','2022-10-23 18:58:13','2022-10-24 18:58:13','728',1026426.70,1026426.70,'728','2022-10-23 19:02:01','913','2022-10-23 21:27:20',10,0),('1','206',257952,'AFTERNOON SHIFT','2022-10-22','2022-10-24 11:36:52','2022-10-25 11:36:52','728',841965.70,841965.70,'728','2022-10-24 11:39:40','913','2022-10-24 11:44:48',10,0),('1','206',257953,'AFTERNOON SHIFT','2022-10-23','2022-10-24 12:02:54','2022-10-25 12:02:54','728',1689216.05,1689216.05,'728','2022-10-24 12:07:42','761','2022-10-24 12:41:04',10,0),('1','206',257954,'MORNING SHIFT','2022-10-24','2022-10-24 19:02:30','2022-10-25 19:02:30','728',673770.00,673770.00,'728','2022-10-24 19:11:33','913','2022-10-24 22:02:15',10,0),('1','206',257955,'MORNING SHIFT','2022-10-25','2022-10-25 15:02:57','2022-10-26 15:02:57','728',836314.70,836314.70,'728','2022-10-25 15:06:02','913','2022-10-25 15:25:39',10,0),('1','206',257956,'AFTERNOON SHIFT','2022-10-25','2022-10-25 16:28:42','2022-10-26 16:28:42','728',364980.95,364980.95,'728','2022-10-25 18:32:30','913','2022-10-25 22:22:54',10,0),('1','206',257957,'AFTERNOON SHIFT','2022-10-27','2022-10-27 19:23:16','2022-10-28 19:23:16','728',2569661.85,2569661.85,'728','2022-10-28 10:14:18','913','2022-10-28 10:16:12',10,0),('1','206',257958,'MORNING SHIFT','2022-10-31','2022-10-31 15:00:58','2022-11-01 15:00:58','728',840714.00,840714.00,'728','2022-10-31 15:03:09','913','2022-10-31 16:46:47',10,0),('1','206',257959,'MORNING SHIFT','2022-11-01','2022-11-01 13:56:30','2022-11-02 13:56:30','728',3183727.95,3183727.95,'728','2022-11-01 13:59:01','913','2022-11-01 16:28:54',10,0),('1','206',257960,'AFTERNOON SHIFT','2022-11-01','2022-11-01 19:48:09','2022-11-02 19:48:09','728',641524.65,641524.65,'728','2022-11-01 20:01:08','913','2022-11-01 21:49:13',10,0),('1','206',257961,'MORNING SHIFT','2022-11-02','2022-11-02 14:07:13','2022-11-03 14:07:13','728',2270275.80,2270275.80,'728','2022-11-02 14:14:47','913','2022-11-02 17:05:09',10,0),('1','206',257962,'AFTERNOON SHIFT','2022-11-02','2022-11-03 08:42:56','2022-11-04 08:42:56','728',399572.55,399572.55,'728','2022-11-03 08:44:54','913','2022-11-03 10:53:19',10,0),('1','206',257963,'MORNING SHIFT','2022-11-03','2022-11-03 18:24:40','2022-11-04 18:24:40','728',530563.80,530563.80,'728','2022-11-03 18:27:00','913','2022-11-03 19:08:38',10,0),('1','206',257964,'MORNING SHIFT','2022-11-05','2022-11-05 19:42:12','2022-11-06 19:42:12','728',1363923.60,1363923.60,'728','2022-11-05 20:05:36','913','2022-11-05 20:12:51',10,0),('1','206',257965,'AFTERNOON SHIFT','2022-11-05','2022-11-05 21:33:03','2022-11-06 21:33:03','728',2057259.75,2057259.75,'728','2022-11-05 21:36:03','913','2022-11-05 23:28:13',10,0),('1','206',257966,'MORNING SHIFT','2022-11-06','2022-11-06 20:25:05','2022-11-07 20:25:05','728',942440.85,942440.85,'728','2022-11-06 20:29:14','913','2022-11-06 20:38:01',10,0),('1','206',257967,'AFTERNOON SHIFT','2022-11-06','2022-11-07 13:13:14','2022-11-08 13:13:14','728',1048850.40,1048850.40,'728','2022-11-07 13:17:41','913','2022-11-07 13:54:19',10,0),('1','206',257968,'MORNING SHIFT','2022-11-07','2022-11-07 14:12:32','2022-11-08 14:12:32','728',2175878.25,2175878.25,'728','2022-11-07 15:18:34','913','2022-11-07 17:41:41',10,0),('1','206',257969,'AFTERNOON SHIFT','2022-11-07','2022-11-08 08:00:22','2022-11-09 08:00:22','728',2237796.60,2237796.60,'728','2022-11-08 08:05:35','913','2022-11-08 10:05:47',10,0),('1','206',257970,'MORNING SHIFT','2022-11-08','2022-11-08 20:26:50','2022-11-09 20:26:50','728',2380751.10,2380751.10,'728','2022-11-08 20:31:09','913','2022-11-08 20:40:42',10,0),('1','206',257971,'AFTERNOON SHIFT','2022-11-08','2022-11-08 22:03:57','2022-11-09 22:03:57','728',1581409.05,1581409.05,'728','2022-11-08 22:10:49','913','2022-11-09 10:32:15',10,0),('1','206',257972,'AFTERNOON SHIFT','2022-11-09','2022-11-10 19:39:20','2022-11-11 19:39:20','728',486837.00,486837.00,'728','2022-11-10 19:45:14','913','2022-11-11 04:21:14',10,0),('1','206',257973,'AFTERNOON SHIFT','2022-11-10','2022-11-11 08:00:35','2022-11-12 08:00:35','728',573060.15,573060.15,'728','2022-11-11 08:13:03','913','2022-11-11 09:37:13',10,0),('1','206',257974,'MORNING SHIFT','2022-11-11','2022-11-11 14:12:55','2022-11-12 14:12:55','728',2038001.55,2038001.55,'728','2022-11-11 14:55:41','913','2022-11-11 16:24:35',10,0),('1','206',257975,'AFTERNOON SHIFT','2022-11-11','2022-11-11 21:22:35','2022-11-12 21:22:35','728',1891823.70,1891823.70,'728','2022-11-11 21:26:15','913','2022-11-11 22:37:34',10,0),('1','206',257976,'MORNING SHIFT','2022-11-13','2022-11-13 15:37:42','2022-11-14 15:37:42','728',2574900.90,2574900.90,'728','2022-11-13 15:41:01','913','2022-11-13 16:17:27',10,0),('1','206',257977,'AFTERNOON SHIFT','2022-11-13','2022-11-13 23:18:28','2022-11-14 23:18:28','728',2801147.70,2801147.70,'728','2022-11-13 23:21:44','913','2022-11-14 01:58:30',10,0),('1','206',257978,'MORNING SHIFT','2022-11-14','2022-11-14 17:36:18','2022-11-15 17:36:18','728',2338590.15,2338590.15,'728','2022-11-14 17:40:58','913','2022-11-14 19:50:43',10,0),('1','206',257979,'AFTERNOON SHIFT','2022-11-14','2022-11-14 20:59:32','2022-11-15 20:59:32','728',1696032.00,1696032.00,'728','2022-11-14 21:06:46','913','2022-11-14 22:35:15',10,0),('1','206',257980,'MORNING SHIFT','2022-11-15','2022-11-15 13:58:37','2022-11-16 13:58:37','728',1522019.85,1522019.85,'728','2022-11-15 14:00:37','913','2022-11-15 16:52:05',10,0),('1','206',257981,'AFTERNOON SHIFT','2022-11-15','2022-11-15 22:49:22','2022-11-16 22:49:22','728',1538261.40,1538261.40,'728','2022-11-15 22:50:38','913','2022-11-16 03:40:16',10,0),('1','206',257982,'MORNING SHIFT','2022-11-16','2022-11-16 09:43:25','2022-11-17 09:43:25','728',1988678.25,1988678.25,'728','2022-11-16 14:38:52','913','2022-11-16 16:09:00',10,0),('1','206',257983,'AFTERNOON SHIFT','2022-11-16','2022-11-17 10:34:29','2022-11-18 10:34:29','728',1229765.55,1229765.55,'728','2022-11-17 10:35:48','913','2022-11-17 11:44:02',10,0),('1','206',257984,'AFTERNOON SHIFT','2022-11-17','2022-11-17 22:18:26','2022-11-18 22:18:26','728',521999.40,521999.40,'728','2022-11-17 22:20:22','913','2022-11-17 23:16:51',10,0),('1','206',257985,'AFTERNOON SHIFT','2022-11-21','2022-11-21 14:27:58','2022-11-22 14:27:58','728',2641485.60,2641485.60,'728','2022-11-22 11:05:53','913','2022-11-22 12:15:11',10,0),('1','206',257986,'MORNING SHIFT','2022-11-22','2022-11-22 12:18:58','2022-11-23 12:18:58','728',1981744.05,1981744.05,'728','2022-11-22 14:40:39','913','2022-11-22 15:57:48',10,0),('1','206',257987,'AFTERNOON SHIFT','2022-11-22','2022-11-22 17:23:13','2022-11-23 17:23:13','728',2626702.65,2626702.65,'728','2022-11-22 20:15:05','913','2022-11-23 05:09:52',10,0),('1','206',257988,'MORNING SHIFT','2022-11-23','2022-11-23 11:56:07','2022-11-24 11:56:07','728',1697617.35,1697617.35,'728','2022-11-23 15:47:14','913','2022-11-23 16:44:18',10,0),('1','206',257989,'AFTERNOON SHIFT','2022-11-23','2022-11-23 17:04:00','2022-11-24 17:04:00','728',1226154.15,1226154.15,'728','2022-11-23 21:15:07','913','2022-11-23 22:49:58',10,0),('1','206',257990,'MORNING SHIFT','2022-11-24','2022-11-24 12:51:41','2022-11-25 12:51:41','728',986341.20,986341.20,'728','2022-11-24 15:12:23','913','2022-11-24 15:32:58',10,0),('1','206',257991,'AFTERNOON SHIFT','2022-11-24','2022-11-24 16:40:59','2022-11-25 16:40:59','728',2152928.70,2152928.70,'728','2022-11-24 21:20:16','913','2022-11-25 04:13:52',10,0),('1','206',257992,'MORNING SHIFT','2022-11-25','2022-11-25 11:05:50','2022-11-26 11:05:50','728',2047527.30,2047527.30,'728','2022-11-25 17:34:42','913','2022-11-25 18:00:39',10,0),('1','206',257993,'AFTERNOON SHIFT','2022-11-25','2022-11-25 18:59:39','2022-11-26 18:59:39','728',1405045.20,1405045.20,'728','2022-11-25 22:08:40','913','2022-11-26 03:55:52',10,0),('1','206',257994,'MORNING SHIFT','2022-11-26','2022-11-26 14:34:20','2022-11-27 14:34:20','728',935296.05,935296.05,'728','2022-11-26 14:36:30','913','2022-11-26 16:59:05',10,0),('1','206',257995,'MORNING SHIFT','2022-11-28','2022-11-28 18:47:32','2022-11-29 18:47:32','728',311923.95,311923.95,'728','2022-11-28 19:00:59','913','2022-11-28 19:03:20',10,0),('1','206',257996,'AFTERNOON SHIFT','2022-12-02','2022-12-03 10:27:39','2022-12-04 10:27:39','728',310129.95,310129.95,'728','2022-12-04 20:32:53','913','2022-12-04 21:04:02',10,0),('1','206',257997,'MORNING SHIFT','2022-12-10','2022-12-10 08:29:54','2022-12-11 08:29:54','728',3832468.50,3832468.50,'728','2022-12-10 14:28:51','913','2022-12-10 14:49:10',10,0),('1','206',257998,'AFTERNOON SHIFT','2022-12-10','2022-12-10 20:56:51','2022-12-11 20:56:51','728',2827286.70,2827286.70,'728','2022-12-10 20:59:47','913','2022-12-10 22:21:44',10,0),('1','206',257999,'MORNING SHIFT','2022-12-11','2022-12-11 15:46:11','2022-12-12 15:46:11','728',3085145.70,3085145.70,'728','2022-12-11 15:50:30','913','2022-12-11 18:05:35',10,0),('1','206',258000,'AFTERNOON SHIFT','2022-12-11','2022-12-11 18:56:48','2022-12-12 18:56:48','728',790849.50,790849.50,'728','2022-12-11 18:58:30','913','2022-12-11 20:55:11',10,0),('1','206',258001,'AFTERNOON SHIFT','2022-12-12','2022-12-12 19:31:58','2022-12-13 19:31:58','728',1819036.80,1819036.80,'728','2022-12-12 19:39:09','913','2022-12-12 21:36:34',10,0),('1','206',258002,'MORNING SHIFT','2022-12-13','2022-12-13 12:04:53','2022-12-14 12:04:53','728',1291124.10,1291124.10,'728','2022-12-13 13:45:40','913','2022-12-13 14:29:17',10,0),('1','206',258003,'AFTERNOON SHIFT','2022-12-13','2022-12-13 16:03:37','2022-12-14 16:03:37','728',1968869.70,1968869.70,'728','2022-12-13 18:48:34','913','2022-12-13 23:40:58',10,0),('1','206',258004,'MORNING SHIFT','2022-12-17','2022-12-17 13:39:33','2022-12-18 13:39:33','728',779165.10,779165.10,'728','2022-12-17 14:09:55','913','2022-12-17 15:46:40',10,0),('1','206',258005,'AFTERNOON SHIFT','2022-12-17','2022-12-18 14:51:46','2022-12-19 14:51:46','728',3686541.60,3686541.60,'728','2022-12-18 15:21:10','913','2022-12-18 16:04:14',10,0),('1','206',258006,'MORNING SHIFT','2022-12-20','2022-12-20 10:56:23','2022-12-21 10:56:23','728',1933539.30,1933539.30,'728','2022-12-20 14:35:18','913','2022-12-20 14:44:26',10,0),('1','206',258007,'AFTERNOON SHIFT','2022-12-20','2022-12-20 15:30:44','2022-12-21 15:30:44','728',2197351.80,2197351.80,'728','2022-12-20 20:01:11','913','2022-12-21 07:41:54',10,0),('1','206',258008,'MORNING SHIFT','2022-12-21','2022-12-21 11:11:00','2022-12-22 11:11:00','728',4174422.00,4174422.00,'728','2022-12-21 14:26:39','913','2022-12-21 15:31:55',10,0),('1','206',258009,'AFTERNOON SHIFT','2022-12-21','2022-12-21 15:43:56','2022-12-22 15:43:56','728',1956735.90,1956735.90,'728','2022-12-21 20:33:01','913','2022-12-21 23:23:33',10,0),('1','206',258010,'MORNING SHIFT','2022-12-22','2022-12-22 12:03:56','2022-12-23 12:03:56','728',3142223.70,3142223.70,'728','2022-12-22 14:49:07','913','2022-12-22 16:10:49',10,0),('1','206',258011,'AFTERNOON SHIFT','2022-12-22','2022-12-22 20:08:01','2022-12-23 20:08:01','728',2955697.50,2955697.50,'728','2022-12-22 20:10:46','913','2022-12-22 23:07:18',10,0),('1','206',258012,'MORNING SHIFT','2022-12-23','2022-12-23 16:08:59','2022-12-24 16:08:59','728',1890556.50,1890556.50,'728','2022-12-23 16:25:27','913','2022-12-23 16:59:39',10,0),('1','206',258013,'AFTERNOON SHIFT','2022-12-23','2022-12-24 22:04:36','2022-12-25 22:04:36','728',2729422.50,2729422.50,'728','2022-12-24 22:07:02','913','2022-12-24 23:00:30',10,0),('1','206',258014,'MORNING SHIFT','2022-12-25','2022-12-25 11:19:00','2022-12-26 11:19:00','728',2702834.20,2702834.20,'728','2022-12-25 15:56:55','913','2022-12-25 22:42:11',10,0),('1','206',258015,'AFTERNOON SHIFT','2022-12-25','2022-12-26 15:47:19','2022-12-27 15:47:19','728',1211771.00,1211771.00,'728','2022-12-26 15:49:50','913','2022-12-26 17:27:04',10,0),('1','206',258016,'MORNING SHIFT','2022-12-26','2022-12-26 17:42:28','2022-12-27 17:42:28','728',1341245.40,1341245.40,'728','2022-12-26 18:52:35','913','2022-12-26 23:39:20',10,0),('1','206',258017,'AFTERNOON SHIFT','2022-12-26','2022-12-27 11:53:53','2022-12-28 11:53:53','728',1564574.00,1564574.00,'728','2022-12-27 11:55:56','913','2022-12-27 14:55:38',10,0),('1','206',258018,'MORNING SHIFT','2022-12-27','2022-12-27 15:14:00','2022-12-28 15:14:00','728',2200327.80,2200327.80,'728','2022-12-27 15:15:29','913','2022-12-27 16:05:12',10,0),('1','206',258019,'AFTERNOON SHIFT','2022-12-27','2022-12-27 16:32:43','2022-12-28 16:32:43','728',2021626.20,2021626.20,'728','2022-12-28 12:59:53','913','2022-12-28 13:24:43',10,0),('1','206',258020,'MORNING SHIFT','2022-12-28','2022-12-28 14:12:05','2022-12-29 14:12:05','728',3369306.60,3369306.60,'728','2022-12-28 14:21:24','913','2022-12-28 15:59:50',10,0),('1','206',258021,'AFTERNOON SHIFT','2022-12-28','2022-12-28 18:48:01','2022-12-29 18:48:01','728',1836252.00,1836252.00,'728','2022-12-28 18:50:09','913','2022-12-28 21:55:25',10,0),('1','206',258022,'MORNING SHIFT','2022-12-29','2022-12-29 12:57:50','2022-12-30 12:57:50','728',2932085.20,2932085.20,'728','2022-12-29 15:22:48','913','2022-12-29 16:29:47',10,0),('1','206',258023,'AFTERNOON SHIFT','2022-12-29','2022-12-29 17:52:53','2022-12-30 17:52:53','728',1666636.40,1666636.40,'728','2022-12-30 13:03:08','913','2022-12-30 13:14:13',10,0),('1','206',258024,'MORNING SHIFT','2022-12-30','2022-12-30 14:50:20','2022-12-31 14:50:20','728',3600480.40,3600480.40,'728','2022-12-30 15:02:36','913','2022-12-30 15:21:41',10,0),('1','206',258025,'AFTERNOON SHIFT','2022-12-30','2022-12-30 15:31:20','2022-12-31 15:31:20','728',2644206.40,2644206.40,'728','2022-12-30 20:09:19','913','2022-12-30 22:35:05',10,0),('1','206',258026,'MORNING SHIFT','2022-12-31','2022-12-31 13:53:26','2023-01-01 13:53:26','728',2109676.80,2109676.80,'728','2022-12-31 13:58:31','913','2022-12-31 15:24:22',10,0),('1','206',258027,'AFTERNOON SHIFT','2022-12-31','2022-12-31 17:54:01','2023-01-01 17:54:01','728',2757400.80,2757400.80,'728','2022-12-31 19:24:00','913','2022-12-31 21:24:09',10,0),('1','206',258028,'MORNING SHIFT','2023-01-01','2023-01-01 10:39:31','2023-01-02 10:39:31','728',2170289.00,2170289.00,'728','2023-01-01 17:20:10','913','2023-01-01 17:54:05',10,0),('1','206',258029,'AFTERNOON SHIFT','2023-01-01','2023-01-01 20:13:42','2023-01-02 20:13:42','728',1938692.80,1938692.80,'728','2023-01-01 20:54:41','913','2023-01-01 22:42:07',10,0),('1','206',258030,'MORNING SHIFT','2023-01-02','2023-01-02 16:32:00','2023-01-03 16:32:00','728',2932633.00,2932633.00,'728','2023-01-02 16:34:45','913','2023-01-03 06:30:31',10,0),('1','206',258031,'AFTERNOON SHIFT','2023-01-02','2023-01-03 09:59:46','2023-01-04 09:59:46','728',1995943.40,1995943.40,'728','2023-01-03 10:02:14','913','2023-01-03 12:05:00',10,0),('1','206',258032,'MORNING SHIFT','2023-01-03','2023-01-03 12:53:00','2023-01-04 12:53:00','728',2394869.40,2394869.40,'728','2023-01-03 14:15:12','913','2023-01-03 16:43:51',10,0),('1','206',258033,'AFTERNOON SHIFT','2023-01-03','2023-01-03 20:20:32','2023-01-04 20:20:32','728',2481802.40,2481802.40,'728','2023-01-04 05:28:00','913','2023-01-04 10:45:27',10,0),('1','206',258034,'MORNING SHIFT','2023-01-04','2023-01-04 14:44:47','2023-01-05 14:44:47','728',2369382.40,2369382.40,'728','2023-01-04 14:49:55','913','2023-01-04 15:30:15',10,0),('1','206',258035,'AFTERNOON SHIFT','2023-01-04','2023-01-04 15:31:55','2023-01-05 15:31:55','728',2414018.20,2414018.20,'728','2023-01-05 10:12:32','913','2023-01-05 10:38:24',10,0),('1','206',258036,'MORNING SHIFT','2023-01-05','2023-01-05 14:39:22','2023-01-06 14:39:22','728',3086560.40,3086560.40,'728','2023-01-05 14:41:52','913','2023-01-05 19:28:42',10,0),('1','206',258037,'AFTERNOON SHIFT','2023-01-05','2023-01-05 20:02:35','2023-01-06 20:02:35','728',2587492.60,2587492.60,'728','2023-01-05 20:43:23','913','2023-01-05 21:34:52',10,0),('1','206',258038,'MORNING SHIFT','2023-01-06','2023-01-06 13:49:36','2023-01-07 13:49:36','728',2543191.20,2543191.20,'728','2023-01-06 13:52:43','913','2023-01-06 16:08:48',10,0),('1','206',258039,'AFTERNOON SHIFT','2023-01-06','2023-01-06 16:35:36','2023-01-07 16:35:36','728',3685715.00,3685715.00,'728','2023-01-06 21:20:41','913','2023-01-06 21:22:38',10,0),('1','206',258040,'MORNING SHIFT','2023-01-07','2023-01-07 09:43:03','2023-01-08 09:43:03','728',2948789.80,2948789.80,'728','2023-01-07 13:50:01','913','2023-01-07 16:10:34',10,0),('1','206',258041,'AFTERNOON SHIFT','2023-01-07','2023-01-07 19:44:42','2023-01-08 19:44:42','728',3200353.20,3200353.20,'728','2023-01-07 20:25:21','913','2023-01-07 21:09:13',10,0),('1','206',258042,'MORNING SHIFT','2023-01-08','2023-01-08 13:38:31','2023-01-09 13:38:31','728',3176177.40,3176177.40,'728','2023-01-08 14:34:10','913','2023-01-08 15:17:54',10,0),('1','206',258043,'AFTERNOON SHIFT','2023-01-08','2023-01-08 20:10:34','2023-01-09 20:10:34','728',2703058.60,2703058.60,'728','2023-01-08 20:16:18','913','2023-01-08 20:21:47',10,0),('1','206',258044,'AFTERNOON SHIFT','2023-01-09','2023-01-10 13:06:26','2023-01-11 13:06:26','728',2824364.40,2824364.40,'728','2023-01-10 13:08:49','761','2023-01-10 14:56:02',10,0),('1','206',258045,'MORNING SHIFT','2023-01-10','2023-01-10 15:00:39','2023-01-11 15:00:39','728',2386984.60,2386984.60,'728','2023-01-10 17:42:08','913','2023-01-10 21:59:52',10,0),('1','206',258046,'MORNING SHIFT','2023-01-12','2023-01-12 12:55:15','2023-01-13 12:55:15','728',1555668.40,1555668.40,'728','2023-01-12 14:51:37','913','2023-01-12 15:14:10',10,0),('1','206',258047,'AFTERNOON SHIFT','2023-01-12','2023-01-12 18:37:50','2023-01-13 18:37:50','728',1955043.20,1955043.20,'728','2023-01-13 15:44:35','913','2023-01-13 17:18:51',10,0),('1','206',258048,'MORNING SHIFT','2023-01-14','2023-01-14 17:22:52','2023-01-15 17:22:52','728',4226494.80,4226494.80,'728','2023-01-14 17:42:00','913','2023-01-14 20:48:04',10,0),('1','206',258049,'AFTERNOON SHIFT','2023-01-14','2023-01-14 22:41:37','2023-01-15 22:41:37','728',2281441.80,2281441.80,'728','2023-01-14 22:49:30','913','2023-01-15 07:03:21',10,0),('1','206',258050,'MORNING SHIFT','2023-01-16','2023-01-16 13:55:05','2023-01-17 13:55:05','728',3801718.80,3801718.80,'728','2023-01-16 16:55:03','913','2023-01-16 21:36:55',10,0),('1','206',258051,'AFTERNOON SHIFT','2023-01-16','2023-01-16 22:04:37','2023-01-17 22:04:37','728',2831422.00,2831422.00,'728','2023-01-16 22:09:49','913','2023-01-16 23:18:02',10,0),('1','206',258052,'MORNING SHIFT','2023-01-17','2023-01-17 14:06:12','2023-01-18 14:06:12','728',2220785.60,2220785.60,'728','2023-01-17 14:08:44','913','2023-01-17 16:05:23',10,0),('1','206',258053,'AFTERNOON SHIFT','2023-01-17','2023-01-17 20:18:14','2023-01-18 20:18:14','728',1382354.80,1382354.80,'728','2023-01-18 12:31:44','913','2023-01-18 13:00:44',10,0),('1','206',258054,'MORNING SHIFT','2023-01-19','2023-01-19 16:20:57','2023-01-20 16:20:57','728',1256622.40,1256622.40,'728','2023-01-19 16:24:04','913','2023-01-19 17:08:41',10,0),('1','206',258055,'AFTERNOON SHIFT','2023-01-21','2023-01-21 20:41:27','2023-01-22 20:41:27','728',2302830.10,2302830.10,'728','2023-01-22 12:16:25','913','2023-01-22 12:23:09',10,0),('1','206',258056,'MORNING SHIFT','2023-01-22','2023-01-22 12:25:08','2023-01-23 12:25:08','728',4497006.00,4497006.00,'728','2023-01-22 17:55:50','913','2023-01-22 17:58:16',10,0),('1','206',258057,'MORNING SHIFT','2023-01-23','2023-01-23 16:33:32','2023-01-24 16:33:32','728',4328130.70,4328130.70,'728','2023-01-23 16:53:24','913','2023-01-23 20:18:51',10,0),('1','206',258058,'MORNING SHIFT','2023-01-24','2023-01-24 17:20:25','2023-01-25 17:20:25','728',3975109.60,3975109.60,'728','2023-01-24 17:59:33','913','2023-01-24 20:28:12',10,0),('1','206',258059,'AFTERNOON SHIFT','2023-01-25','2023-01-25 21:05:52','2023-01-26 21:05:52','728',4465289.40,4465289.40,'728','2023-01-25 22:53:51','761','2023-01-26 11:55:14',10,0),('1','206',258060,'MORNING SHIFT','2023-01-26','2023-01-26 18:32:46','2023-01-27 18:32:46','728',4451530.50,4451530.50,'728','2023-01-26 18:44:49','913','2023-01-26 20:06:34',10,0),('1','206',258061,'AFTERNOON SHIFT','2023-01-27','2023-01-27 18:10:06','2023-01-28 18:10:06','728',635650.70,635650.70,'728','2023-01-27 18:12:16','913','2023-01-27 22:55:14',10,0),('1','206',258062,'MORNING SHIFT','2023-01-29','2023-01-29 20:03:01','2023-01-30 20:03:01','728',3411385.60,3411385.60,'728','2023-01-29 20:05:27','913','2023-01-29 20:39:59',10,0),('1','206',258063,'AFTERNOON SHIFT','2023-01-29','2023-01-29 21:56:19','2023-01-30 21:56:19','728',2925718.40,2925718.40,'728','2023-01-29 21:57:42','913','2023-01-30 11:20:22',10,0),('1','206',258064,'MORNING SHIFT','2023-01-30','2023-01-30 14:44:50','2023-01-31 14:44:50','728',3473797.00,3473797.00,'728','2023-01-30 16:10:09','913','2023-01-30 16:53:10',10,0),('1','206',258065,'AFTERNOON SHIFT','2023-01-30','2023-01-30 21:03:42','2023-01-31 21:03:42','728',2680752.80,2680752.80,'728','2023-01-30 21:29:33','913','2023-01-30 23:30:03',10,0),('1','206',258066,'AFTERNOON SHIFT','2023-01-31','2023-01-31 19:57:27','2023-02-01 19:57:27','728',5806301.70,5806301.70,'728','2023-01-31 23:20:24','913','2023-02-01 01:38:03',10,0),('1','206',258067,'MORNING SHIFT','2023-02-01','2023-02-01 13:01:53','2023-02-02 13:01:53','728',2186352.70,2186352.70,'728','2023-02-01 19:29:12','913','2023-02-01 20:51:01',10,0),('1','206',258068,'AFTERNOON SHIFT','2023-02-01','2023-02-01 22:17:49','2023-02-02 22:17:49','728',2862794.30,2862794.30,'728','2023-02-01 22:20:26','913','2023-02-02 00:46:01',10,0),('1','206',258069,'MORNING SHIFT','2023-02-02','2023-02-02 19:23:24','2023-02-03 19:23:24','728',3803409.90,3803409.90,'728','2023-02-02 20:29:44','761','2023-02-02 23:53:26',10,0),('1','206',258070,'AFTERNOON SHIFT','2023-02-02','2023-02-03 04:14:11','2023-02-04 04:14:11','728',3506855.30,3506855.30,'728','2023-02-03 04:22:21','913','2023-02-03 08:27:20',10,0),('1','206',258071,'MORNING SHIFT','2023-02-03','2023-02-03 19:46:13','2023-02-04 19:46:13','728',2503135.80,2503135.80,'728','2023-02-03 19:50:56','913','2023-02-03 22:55:31',10,0),('1','206',258072,'AFTERNOON SHIFT','2023-02-03','2023-02-04 10:38:09','2023-02-05 10:38:09','728',2085369.00,2085369.00,'728','2023-02-04 11:00:22','913','2023-02-04 11:06:15',10,0),('1','206',258073,'MORNING SHIFT','2023-02-04','2023-02-04 18:19:54','2023-02-05 18:19:54','728',2046924.00,2046924.00,'728','2023-02-04 18:23:36','913','2023-02-04 20:14:24',10,0),('1','206',258074,'AFTERNOON SHIFT','2023-02-04','2023-02-05 11:09:32','2023-02-06 11:09:32','728',1759271.00,1759271.00,'728','2023-02-05 11:14:21','913','2023-02-05 11:36:46',10,0),('1','206',258075,'MORNING SHIFT','2023-02-05','2023-02-05 15:57:45','2023-02-06 15:57:45','728',2186250.00,2186250.00,'728','2023-02-05 16:00:20','913','2023-02-05 16:52:48',10,0),('1','206',258076,'AFTERNOON SHIFT','2023-02-05','2023-02-06 10:15:59','2023-02-07 10:15:59','728',3412486.00,3412486.00,'728','2023-02-06 10:22:13','913','2023-02-06 11:55:32',10,0),('1','206',258077,'MORNING SHIFT','2023-02-06','2023-02-06 20:53:19','2023-02-07 20:53:19','728',1614246.00,1614246.00,'728','2023-02-06 20:55:20','913','2023-02-06 22:06:54',10,0),('1','206',258078,'AFTERNOON SHIFT','2023-02-06','2023-02-07 12:56:27','2023-02-08 12:56:27','728',2309024.00,2309024.00,'728','2023-02-07 12:58:32','913','2023-02-07 15:18:20',10,0),('1','206',258079,'MORNING SHIFT','2023-02-07','2023-02-07 21:09:19','2023-02-08 21:09:19','728',2280818.00,2280818.00,'728','2023-02-07 21:12:46','761','2023-02-08 07:18:33',10,0),('1','206',258080,'AFTERNOON SHIFT','2023-02-07','2023-02-08 19:22:14','2023-02-09 19:22:14','728',2320302.00,2320302.00,'728','2023-02-08 19:38:48','913','2023-02-08 19:50:13',10,0),('1','206',258081,'MORNING SHIFT','2023-02-08','2023-02-08 19:50:45','2023-02-09 19:50:45','728',2611898.00,2611898.00,'728','2023-02-08 20:54:47','913','2023-02-08 22:20:59',10,0),('1','206',258082,'AFTERNOON SHIFT','2023-02-08','2023-02-09 10:08:25','2023-02-10 10:08:25','728',2292356.00,2292356.00,'728','2023-02-09 10:14:49','913','2023-02-09 12:03:13',10,0),('1','206',258083,'MORNING SHIFT','2023-02-09','2023-02-09 13:29:24','2023-02-10 13:29:24','728',1755568.00,1755568.00,'728','2023-02-09 14:51:29','913','2023-02-09 15:30:30',10,0),('1','206',258084,'AFTERNOON SHIFT','2023-02-09','2023-02-10 09:26:36','2023-02-11 09:26:36','728',3183598.00,3183598.00,'728','2023-02-10 10:50:18','761','2023-02-10 11:21:14',10,0),('1','206',258085,'MORNING SHIFT','2023-02-10','2023-02-10 17:00:05','2023-02-11 17:00:05','728',1793000.00,1793000.00,'728','2023-02-10 17:03:51','913','2023-02-10 18:02:54',10,0),('1','206',258086,'AFTERNOON SHIFT','2023-02-10','2023-02-10 22:28:36','2023-02-11 22:28:36','728',2280939.60,2280939.60,'728','2023-02-10 22:49:23','913','2023-02-11 00:43:42',10,0),('1','206',258087,'MORNING SHIFT','2023-02-11','2023-02-11 19:19:48','2023-02-12 19:19:48','728',1757340.90,1757340.90,'728','2023-02-11 21:13:36','913','2023-02-11 23:15:31',10,0),('1','206',258088,'AFTERNOON SHIFT','2023-02-11','2023-02-12 11:13:30','2023-02-13 11:13:30','728',1848468.30,1848468.30,'728','2023-02-12 11:37:39','913','2023-02-12 15:24:47',10,0),('1','206',258089,'MORNING SHIFT','2023-02-12','2023-02-12 16:27:04','2023-02-13 16:27:04','728',1862977.20,1862977.20,'728','2023-02-12 17:28:19','913','2023-02-12 23:29:11',10,0),('1','206',258090,'AFTERNOON SHIFT','2023-02-12','2023-02-13 15:32:09','2023-02-14 15:32:09','728',2699959.40,2699959.40,'728','2023-02-13 15:55:18','913','2023-02-13 17:19:10',10,0),('1','206',258091,'MORNING SHIFT','2023-02-13','2023-02-13 18:44:56','2023-02-14 18:44:56','728',2030828.10,2030828.10,'728','2023-02-13 22:54:05','913','2023-02-14 05:47:10',10,0),('1','206',258092,'AFTERNOON SHIFT','2023-02-13','2023-02-14 09:20:09','2023-02-15 09:20:09','728',3218605.00,3218605.00,'728','2023-02-14 09:27:42','761','2023-02-14 17:30:56',10,0),('1','206',258093,'MORNING SHIFT','2023-02-14','2023-02-14 21:23:54','2023-02-15 21:23:54','728',1668235.80,1668235.80,'728','2023-02-14 21:50:08','913','2023-02-14 23:43:00',10,0),('1','206',258094,'AFTERNOON SHIFT','2023-02-14','2023-02-15 12:53:26','2023-02-16 12:53:26','728',2374341.90,2374341.90,'728','2023-02-15 12:56:59','913','2023-02-15 17:02:51',10,0),('1','206',258095,'MORNING SHIFT','2023-02-15','2023-02-15 18:06:38','2023-02-16 18:06:38','728',1949123.40,1949123.40,'728','2023-02-15 18:08:53','913','2023-02-16 01:16:30',10,0),('1','206',258096,'AFTERNOON SHIFT','2023-02-15','2023-02-16 10:07:16','2023-02-17 10:07:16','728',2097146.10,2097146.10,'728','2023-02-16 11:41:16','761','2023-02-16 14:41:33',10,0),('1','206',258097,'MORNING SHIFT','2023-02-16','2023-02-16 15:30:23','2023-02-17 15:30:23','728',2225216.70,2225216.70,'728','2023-02-16 22:07:23','913','2023-02-17 04:53:33',10,0),('1','206',258098,'AFTERNOON SHIFT','2023-02-16','2023-02-17 11:14:03','2023-02-18 11:14:03','728',1827322.20,1827322.20,'728','2023-02-17 11:18:56','913','2023-02-17 11:44:29',10,0),('1','206',258099,'MORNING SHIFT','2023-02-17','2023-02-17 22:31:21','2023-02-18 22:31:21','728',1749505.00,1749505.00,'728','2023-02-17 22:36:37','913','2023-02-18 01:50:50',10,0),('1','206',258100,'AFTERNOON SHIFT','2023-02-17','2023-02-18 11:31:16','2023-02-19 11:31:16','728',2733005.00,2733005.00,'728','2023-02-18 11:42:57','913','2023-02-18 14:11:41',10,0),('1','206',258101,'MORNING SHIFT','2023-02-18','2023-02-18 18:05:14','2023-02-19 18:05:14','728',1884432.90,1884432.90,'728','2023-02-18 19:04:59','913','2023-02-19 07:52:45',10,0),('1','206',258102,'AFTERNOON SHIFT','2023-02-18','2023-02-19 12:05:59','2023-02-20 12:05:59','728',1594471.20,1594471.20,'728','2023-02-19 12:19:29','913','2023-02-19 12:57:26',10,0),('1','206',258103,'MORNING SHIFT','2023-02-19','2023-02-19 14:12:02','2023-02-20 14:12:02','728',2121180.60,2121180.60,'728','2023-02-19 16:44:29','913','2023-02-19 17:18:45',10,0),('1','206',258104,'AFTERNOON SHIFT','2023-02-19','2023-02-19 17:48:50','2023-02-20 17:48:50','728',2832889.20,2832889.20,'728','2023-02-19 22:13:42','913','2023-02-20 06:01:15',10,0),('1','206',258105,'MORNING SHIFT','2023-02-20','2023-02-20 14:32:47','2023-02-21 14:32:47','728',1780102.80,1780102.80,'728','2023-02-20 19:45:16','913','2023-02-21 01:26:00',10,0),('1','206',258106,'AFTERNOON SHIFT','2023-02-20','2023-02-21 12:25:42','2023-02-22 12:25:42','728',1726035.10,1726035.10,'728','2023-02-21 12:30:04','913','2023-02-21 15:32:21',10,0),('1','206',258107,'MORNING SHIFT','2023-02-21','2023-02-21 15:41:29','2023-02-22 15:41:29','728',1962507.10,1962507.10,'728','2023-02-21 15:55:39','913','2023-02-22 07:10:37',10,0),('1','206',258108,'AFTERNOON SHIFT','2023-02-21','2023-02-22 10:48:59','2023-02-23 10:48:59','728',2458123.00,2458123.00,'728','2023-02-22 12:38:10','913','2023-02-22 13:39:29',10,0),('1','206',258109,'MORNING SHIFT','2023-02-22','2023-02-22 15:27:31','2023-02-23 15:27:31','728',1188037.20,1188037.20,'728','2023-02-22 22:40:37','913','2023-02-22 23:19:54',10,0),('1','206',258110,'AFTERNOON SHIFT','2023-02-22','2023-02-23 10:23:10','2023-02-24 10:23:10','728',2799320.50,2799320.50,'728','2023-02-23 10:34:20','913','2023-02-23 12:31:08',10,0),('1','206',258111,'MORNING SHIFT','2023-02-23','2023-02-23 17:25:14','2023-02-24 17:25:14','728',2551464.70,2551464.70,'728','2023-02-23 17:29:28','913','2023-02-23 23:00:37',10,0),('1','206',258112,'AFTERNOON SHIFT','2023-02-23','2023-02-24 10:53:22','2023-02-25 10:53:22','728',2232064.80,2232064.80,'728','2023-02-24 11:00:04','913','2023-02-24 11:46:54',10,0),('1','206',258113,'MORNING SHIFT','2023-02-24','2023-02-24 17:23:50','2023-02-25 17:23:50','728',2490757.00,2490757.00,'728','2023-02-24 18:36:37','913','2023-02-24 23:06:03',10,0),('1','206',258114,'AFTERNOON SHIFT','2023-02-24','2023-02-25 00:01:41','2023-02-26 00:01:41','728',1927839.90,1927839.90,'728','2023-02-25 00:03:48','913','2023-02-25 09:23:57',10,0),('1','206',258115,'MORNING SHIFT','2023-02-26','2023-02-26 16:24:10','2023-02-27 16:24:10','728',2063004.30,2063004.30,'728','2023-02-26 17:03:44','913','2023-02-26 17:43:18',10,0),('1','206',258116,'AFTERNOON SHIFT','2023-02-26','2023-02-26 19:06:56','2023-02-27 19:06:56','728',1526786.10,1526786.10,'728','2023-02-26 21:20:55','913','2023-02-27 00:49:18',10,0),('1','206',258117,'MORNING SHIFT','2023-02-27','2023-02-27 14:32:43','2023-02-28 14:32:43','728',1724134.40,1724134.40,'728','2023-02-27 16:32:28','913','2023-02-27 17:45:06',10,0),('1','206',258118,'AFTERNOON SHIFT','2023-02-27','2023-02-27 21:06:54','2023-02-28 21:06:54','728',2052338.60,2052338.60,'728','2023-02-27 21:09:49','913','2023-02-28 08:43:00',10,0),('1','206',258119,'MORNING SHIFT','2023-02-28','2023-02-28 18:13:19','2023-03-01 18:13:19','728',1990821.70,1990821.70,'728','2023-02-28 18:15:08','913','2023-02-28 19:57:38',10,0),('1','206',258120,'AFTERNOON SHIFT','2023-02-28','2023-02-28 20:57:52','2023-03-01 20:57:52','728',1640874.90,1640874.90,'728','2023-02-28 22:48:08','913','2023-03-01 00:50:26',10,0),('1','206',258121,'MORNING SHIFT','2023-03-01','2023-03-01 15:13:13','2023-03-02 15:13:13','728',2007839.40,2007839.40,'728','2023-03-01 16:00:45','913','2023-03-01 20:19:52',10,0),('1','206',258122,'AFTERNOON SHIFT','2023-03-01','2023-03-01 20:25:48','2023-03-02 20:25:48','728',1184085.00,1184085.00,'728','2023-03-01 20:39:41','913','2023-03-02 11:35:17',10,0),('1','206',258123,'MORNING SHIFT','2023-03-02','2023-03-02 19:29:24','2023-03-03 19:29:24','728',1810517.10,1810517.10,'728','2023-03-02 19:55:05','913','2023-03-02 20:09:31',10,0),('1','206',258124,'AFTERNOON SHIFT','2023-03-02','2023-03-02 20:13:32','2023-03-03 20:13:32','728',576523.50,576523.50,'728','2023-03-02 20:21:18','913','2023-03-03 00:57:13',10,0),('1','206',258125,'MORNING SHIFT','2023-03-03','2023-03-03 15:52:13','2023-03-04 15:52:13','728',1109486.70,1109486.70,'728','2023-03-03 20:41:04','913','2023-03-04 06:24:48',10,0),('1','206',258126,'AFTERNOON SHIFT','2023-03-03','2023-03-04 10:56:28','2023-03-05 10:56:28','728',1599259.20,1599259.20,'728','2023-03-04 11:00:31','913','2023-03-04 13:07:35',10,0),('1','206',258127,'MORNING SHIFT','2023-03-04','2023-03-05 13:44:35','2023-03-06 13:44:35','728',695963.10,695963.10,'728','2023-03-05 13:46:37','913','2023-03-05 16:10:41',10,0),('1','206',258128,'MORNING SHIFT','2023-03-07','2023-03-07 19:57:37','2023-03-08 19:57:37','728',2129471.40,2129471.40,'728','2023-03-07 21:04:12','913','2023-03-07 23:05:00',10,0),('1','206',258129,'AFTERNOON SHIFT','2023-03-07','2023-03-08 11:54:26','2023-03-09 11:54:26','728',2118822.60,2118822.60,'728','2023-03-08 12:04:11','913','2023-03-08 13:32:45',10,0),('1','206',258130,'AFTERNOON SHIFT','2023-03-08','2023-03-09 11:47:54','2023-03-10 11:47:54','728',654880.80,654880.80,'728','2023-03-09 12:57:29','913','2023-03-09 13:14:28',10,0),('1','206',258131,'MORNING SHIFT','2023-03-09','2023-03-09 16:58:31','2023-03-10 16:58:31','728',2601861.40,2601861.40,'728','2023-03-09 17:45:29','913','2023-03-09 20:53:29',10,0),('1','206',258132,'AFTERNOON SHIFT','2023-03-09','2023-03-09 22:25:23','2023-03-10 22:25:23','728',3195135.10,3195135.10,'728','2023-03-09 22:32:14','913','2023-03-10 09:53:32',10,0),('1','206',258133,'MORNING SHIFT','2023-03-11','2023-03-11 21:18:40','2023-03-12 21:18:40','728',2773316.70,2773316.70,'728','2023-03-11 21:25:22','913','2023-03-12 09:15:08',10,0),('1','206',258134,'AFTERNOON SHIFT','2023-03-11','2023-03-12 13:50:45','2023-03-13 13:50:45','728',1809030.30,1809030.30,'728','2023-03-12 13:52:47','913','2023-03-12 14:06:24',10,0),('1','206',258135,'MORNING SHIFT','2023-03-12','2023-03-12 14:24:39','2023-03-13 14:24:39','728',3258661.00,3258661.00,'728','2023-03-12 22:56:19','913','2023-03-13 12:27:56',10,0),('1','206',258136,'AFTERNOON SHIFT','2023-03-12','2023-03-13 15:02:40','2023-03-14 15:02:40','728',1718700.90,1718700.90,'728','2023-03-13 15:04:58','913','2023-03-13 16:30:00',10,0),('1','206',258137,'MORNING SHIFT','2023-03-13','2023-03-13 17:08:10','2023-03-14 17:08:10','728',2264737.90,2264737.90,'728','2023-03-14 10:09:21','913','2023-03-14 10:57:23',10,0),('1','206',258138,'AFTERNOON SHIFT','2023-03-13','2023-03-14 12:08:41','2023-03-15 12:08:41','728',1490382.60,1490382.60,'728','2023-03-14 12:13:57','913','2023-03-14 14:54:22',10,0),('1','206',258139,'MORNING SHIFT','2023-03-15','2023-03-15 20:47:24','2023-03-16 20:47:24','728',2952971.70,2952971.70,'728','2023-03-15 21:04:51','913','2023-03-15 22:26:09',10,0),('1','206',258140,'AFTERNOON SHIFT','2023-03-15','2023-03-16 10:43:39','2023-03-17 10:43:39','728',1411853.10,1411853.10,'728','2023-03-16 11:10:43','913','2023-03-16 11:49:29',10,0),('1','206',258141,'MORNING SHIFT','2023-03-16','2023-03-16 21:58:46','2023-03-17 21:58:46','728',2385169.50,2385169.50,'728','2023-03-16 22:04:58','913','2023-03-16 22:53:54',10,0),('1','206',258142,'AFTERNOON SHIFT','2023-03-16','2023-03-17 10:37:20','2023-03-18 10:37:20','728',1527134.70,1527134.70,'728','2023-03-17 10:40:07','913','2023-03-17 13:01:52',10,0),('1','206',258143,'MORNING SHIFT','2023-03-17','2023-03-17 17:25:47','2023-03-18 17:25:47','728',2018448.60,2018448.60,'728','2023-03-17 18:12:03','913','2023-03-17 21:30:17',10,0),('1','206',258144,'AFTERNOON SHIFT','2023-03-17','2023-03-17 22:47:04','2023-03-18 22:47:04','728',2114250.60,2114250.60,'728','2023-03-17 22:49:01','913','2023-03-18 05:24:43',10,0),('1','206',258145,'MORNING SHIFT','2023-03-19','2023-03-19 16:08:33','2023-03-20 16:08:33','728',2599988.58,2599988.58,'728','2023-03-19 17:33:29','913','2023-03-20 00:15:01',10,0),('1','206',258146,'AFTERNOON SHIFT','2023-03-19','2023-03-20 12:16:18','2023-03-21 12:16:18','728',1991713.50,1991713.50,'728','2023-03-20 12:20:05','913','2023-03-20 13:33:58',10,0),('1','206',258147,'MORNING SHIFT','2023-03-20','2023-03-20 17:42:41','2023-03-21 17:42:41','728',1725868.20,1725868.20,'728','2023-03-20 18:32:40','913','2023-03-20 21:19:58',10,0),('1','206',258148,'AFTERNOON SHIFT','2023-03-20','2023-03-20 22:18:51','2023-03-21 22:18:51','728',2346340.50,2346340.50,'728','2023-03-20 22:41:17','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4910696 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','206','1030','245375',4696780,'3056','472',630.90,630.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245375',4696781,'3057','472',702.15,1280.30,578.15,95394.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245375',4696782,'3058','472',666.42,666.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245375',4696783,'3059','472',782.75,1491.84,709.09,116999.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245375',4696784,'3060','472',734.54,734.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245375',4696785,'3061','472',752.65,1219.48,466.83,77026.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245375',4696786,'3062','472',639.41,980.29,340.88,56245.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245375',4696787,'3063','472',667.15,667.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','245375',4696788,'3064','473',103188.78,103216.32,6.27,2163.15,0.00,0.00,21.27,0.00,0.00),('1','206','1030','245500',4698687,'3056','472',630.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245500',4698688,'3057','472',1280.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245500',4698689,'3058','472',666.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245500',4698690,'3059','472',1491.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245500',4698691,'3060','472',734.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245500',4698692,'3061','472',1219.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245500',4698693,'3062','472',980.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245500',4698694,'3063','472',667.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','245500',4698695,'3064','473',103216.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245508',4698791,'3056','472',630.90,630.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245508',4698792,'3057','472',1280.30,3684.26,2375.78,392003.70,0.00,0.00,28.18,0.00,0.00),('1','206','1030','245508',4698793,'3058','472',666.42,666.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245508',4698794,'3059','472',1491.84,2949.99,1458.15,240594.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245508',4698795,'3060','472',734.54,734.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245508',4698796,'3061','472',1219.48,2318.14,1098.66,181278.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245508',4698797,'3062','472',980.29,980.57,0.28,46.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245508',4698798,'3063','472',667.15,1390.31,723.16,119321.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','245508',4698799,'3064','473',103216.32,103476.35,260.03,89710.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245604',4700770,'3056','472',630.90,2626.71,1995.81,329308.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245604',4700771,'3057','472',3684.26,3684.90,0.64,105.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245604',4700772,'3058','472',666.42,1789.86,1123.44,185367.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245604',4700773,'3059','472',2949.99,2949.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245604',4700774,'3060','472',734.54,2033.01,1298.47,214247.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245604',4700775,'3061','472',2318.14,2318.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245604',4700776,'3062','472',980.57,1535.54,554.97,91570.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','245604',4700777,'3063','472',1390.31,1390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','245604',4700778,'3064','473',103476.35,103700.70,224.35,77400.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248093',4742802,'3056','472',2626.71,3515.56,878.85,145010.25,0.00,0.00,10.00,0.00,0.00),('1','206','1030','248093',4742803,'3057','472',3684.90,3685.83,0.93,153.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248093',4742804,'3058','472',1789.86,2435.54,645.68,106537.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248093',4742805,'3059','472',2949.99,3136.48,186.49,30770.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248093',4742806,'3060','472',2033.01,2033.36,0.35,57.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248093',4742807,'3061','472',2318.14,3207.89,889.75,146808.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248093',4742808,'3062','472',1535.54,2032.78,497.24,82044.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248093',4742809,'3063','472',1390.31,1390.68,0.37,61.05,0.00,0.00,0.00,0.00,0.00),('1','206','1031','248093',4742810,'3064','473',103700.70,103700.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248301',4746381,'3056','472',3515.56,4558.43,1042.87,172073.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248301',4746382,'3057','472',3685.83,4342.37,656.54,108329.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248301',4746383,'3058','472',2435.54,3661.94,1226.40,202356.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248301',4746384,'3059','472',3136.48,3163.75,27.27,4499.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248301',4746385,'3060','472',2033.36,2033.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248301',4746386,'3061','472',3207.89,3207.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248301',4746387,'3062','472',2032.78,2910.30,877.52,144790.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248301',4746388,'3063','472',1390.68,1390.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','248301',4746389,'3064','473',103700.70,103832.30,131.60,45402.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248360',4747443,'3056','472',4558.43,4997.34,418.66,69078.90,0.00,0.00,20.25,0.00,0.00),('1','206','1030','248360',4747444,'3057','472',4342.37,6491.63,2128.98,351281.70,0.00,0.00,20.28,0.00,0.00),('1','206','1030','248360',4747445,'3058','472',3661.94,5317.94,1635.64,269880.60,0.00,0.00,20.36,0.00,0.00),('1','206','1030','248360',4747446,'3059','472',3163.75,3649.40,465.32,76777.80,0.00,0.00,20.33,0.00,0.00),('1','206','1030','248360',4747447,'3060','472',2033.36,2164.85,110.68,18262.20,0.00,0.00,20.81,0.00,0.00),('1','206','1030','248360',4747448,'3061','472',3207.89,3925.17,696.93,114993.45,0.00,0.00,20.35,0.00,0.00),('1','206','1030','248360',4747449,'3062','472',2910.30,4083.11,1152.44,190152.60,0.00,0.00,20.37,0.00,0.00),('1','206','1030','248360',4747450,'3063','472',1390.68,1539.47,128.50,21202.50,0.00,0.00,20.29,0.00,0.00),('1','206','1031','248360',4747451,'3064','473',103832.30,103962.70,130.40,44988.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248492',4749539,'3056','472',4997.34,5711.42,714.08,117823.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248492',4749540,'3057','472',6491.63,7806.02,1314.39,216874.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248492',4749541,'3058','472',5317.94,6685.38,1367.44,225627.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248492',4749542,'3059','472',3649.40,4032.86,383.46,63270.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248492',4749543,'3060','472',2164.85,2485.35,320.50,52882.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248492',4749544,'3061','472',3925.17,4625.00,699.83,115471.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248492',4749545,'3062','472',4083.11,4814.80,731.69,120728.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248492',4749546,'3063','472',1539.47,1830.61,291.14,48038.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','248492',4749547,'3064','473',103962.70,103976.62,13.92,4802.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248599',4751399,'3056','472',5711.42,6829.85,1118.43,184540.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248599',4751400,'3057','472',7806.02,10146.84,2340.82,386235.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248599',4751401,'3058','472',6685.38,9135.91,2450.53,404337.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248599',4751402,'3059','472',4032.86,4339.86,307.00,50655.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248599',4751403,'3060','472',2485.35,2485.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248599',4751404,'3061','472',4625.00,4940.21,315.21,52009.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248599',4751405,'3062','472',4814.80,7366.08,2551.28,420961.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248599',4751406,'3063','472',1830.61,1830.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','248599',4751407,'3064','473',103976.62,103997.79,21.17,7303.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248793',4754658,'3056','472',6829.85,9344.65,2514.80,414942.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248793',4754659,'3057','472',10146.84,10306.12,159.28,26281.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248793',4754660,'3058','472',9135.91,10723.98,1588.07,262031.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248793',4754661,'3059','472',4339.86,4780.73,440.87,72743.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248793',4754662,'3060','472',2485.35,3568.49,1083.14,178718.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248793',4754663,'3061','472',4940.21,6023.14,1082.93,178683.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248793',4754664,'3062','472',7366.08,7605.23,217.94,35960.10,0.00,0.00,21.21,0.00,0.00),('1','206','1030','248793',4754665,'3063','472',1830.61,1851.82,0.00,0.00,0.00,0.00,21.21,0.00,0.00),('1','206','1031','248793',4754666,'3064','473',103997.79,103997.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248993',4757977,'3056','472',9344.65,10588.66,1244.01,205261.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248993',4757978,'3057','472',10306.12,11680.56,1374.44,226782.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248993',4757979,'3058','472',10723.98,12914.68,2190.70,361465.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248993',4757980,'3059','472',4780.73,5071.98,291.25,48056.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248993',4757981,'3060','472',3568.49,3568.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248993',4757982,'3061','472',6023.14,6794.93,771.79,127345.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248993',4757983,'3062','472',7605.23,9154.13,1548.90,255568.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','248993',4757984,'3063','472',1851.82,1851.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','248993',4757985,'3064','473',103997.79,104146.86,149.07,51429.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249017',4758448,'3056','472',10588.66,12390.65,1801.99,297328.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249017',4758449,'3057','472',11680.56,13477.19,1796.63,296443.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249017',4758450,'3058','472',12914.68,14788.44,1873.76,309170.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249017',4758451,'3059','472',5071.98,5707.40,635.42,104844.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249017',4758452,'3060','472',3568.49,4244.14,675.65,111482.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249017',4758453,'3061','472',6794.93,8496.69,1701.76,280790.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249017',4758454,'3062','472',9154.13,10352.28,1198.15,197694.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249017',4758455,'3063','472',1851.82,2496.40,644.58,106355.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','249017',4758456,'3064','473',104146.86,104152.08,5.22,1800.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249064',4759275,'3056','472',12390.65,13325.29,934.64,154215.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249064',4759276,'3057','472',13477.19,14668.58,1191.39,196579.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249064',4759277,'3058','472',14788.44,16860.59,2072.15,341904.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249064',4759278,'3059','472',5707.40,5707.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249064',4759279,'3060','472',4244.14,4265.36,21.22,3501.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249064',4759280,'3061','472',8496.69,8765.56,268.87,44363.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249064',4759281,'3062','472',10352.28,11798.31,1446.03,238594.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249064',4759282,'3063','472',2496.40,2621.96,125.56,20717.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','249064',4759283,'3064','473',104152.08,104318.08,166.00,57270.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249210',4761482,'3056','472',13325.29,13700.38,375.09,61889.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249210',4761483,'3057','472',14668.58,16079.30,1410.72,232768.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249210',4761484,'3058','472',16860.59,18171.89,1311.30,216364.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249210',4761485,'3059','472',5707.40,5854.65,147.25,24296.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249210',4761486,'3060','472',4265.36,4265.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249210',4761487,'3061','472',8765.56,8765.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249210',4761488,'3062','472',11798.31,13323.17,1524.86,251601.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249210',4761489,'3063','472',2621.96,2722.91,100.95,16656.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','249210',4761490,'3064','473',104318.08,104529.92,191.84,66184.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','249436',4765404,'3056','472',13700.38,15077.28,1376.90,227188.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249436',4765405,'3057','472',16079.30,17113.96,1034.66,170718.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249436',4765406,'3058','472',18171.89,19633.74,1461.85,241205.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249436',4765407,'3059','472',5854.65,6295.93,441.28,72811.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249436',4765408,'3060','472',4265.36,4265.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249436',4765409,'3061','472',8765.56,8765.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249436',4765410,'3062','472',13323.17,14354.68,1031.51,170199.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249436',4765411,'3063','472',2722.91,2983.80,260.89,43046.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','249436',4765412,'3064','473',104529.92,104570.96,41.04,14158.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249465',4765965,'3056','472',15077.28,16288.99,1211.71,199932.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249465',4765966,'3057','472',17113.96,17698.32,584.36,96419.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249465',4765967,'3058','472',19633.74,20997.75,1364.01,225061.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249465',4765968,'3059','472',6295.93,6525.04,229.11,37803.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249465',4765969,'3060','472',4265.36,4265.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249465',4765970,'3061','472',8765.56,8933.44,167.88,27700.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249465',4765971,'3062','472',14354.68,15641.24,1286.56,212282.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249465',4765972,'3063','472',2983.80,2983.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','249465',4765973,'3064','473',104570.96,104587.78,16.82,5802.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249522',4766897,'3056','472',16288.99,17110.44,821.45,135539.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249522',4766898,'3057','472',17698.32,18204.02,505.70,83440.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249522',4766899,'3058','472',20997.75,22013.54,1015.79,167605.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249522',4766900,'3059','472',6525.04,6653.82,108.78,17948.70,0.00,0.00,20.00,0.00,0.00),('1','206','1030','249522',4766901,'3060','472',4265.36,4268.39,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249522',4766902,'3061','472',8933.44,9795.69,862.25,142271.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249522',4766903,'3062','472',15641.24,16007.23,365.99,60388.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249522',4766904,'3063','472',2983.80,3082.25,98.45,16244.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','249522',4766905,'3064','473',104587.78,104587.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249723',4770215,'3056','472',17110.44,18000.42,869.98,143546.70,0.00,0.00,20.00,0.00,0.00),('1','206','1030','249723',4770216,'3057','472',18204.02,19372.20,1128.18,186149.70,0.00,0.00,40.00,0.00,0.00),('1','206','1030','249723',4770217,'3058','472',22013.54,22305.50,261.96,43223.40,0.00,0.00,30.00,0.00,0.00),('1','206','1030','249723',4770218,'3059','472',6653.82,6696.12,30.30,4999.50,0.00,0.00,12.00,0.00,0.00),('1','206','1030','249723',4770219,'3060','472',4268.39,4280.39,0.00,0.00,0.00,0.00,12.00,0.00,0.00),('1','206','1030','249723',4770220,'3061','472',9795.69,9807.69,0.00,0.00,0.00,0.00,12.00,0.00,0.00),('1','206','1030','249723',4770221,'3062','472',16007.23,17145.68,1118.45,184544.25,0.00,0.00,20.00,0.00,0.00),('1','206','1030','249723',4770222,'3063','472',3082.25,3447.81,353.56,58337.40,0.00,0.00,12.00,0.00,0.00),('1','206','1031','249723',4770223,'3064','473',104587.78,104603.72,15.94,5499.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249955',4774220,'3056','472',18000.42,19571.78,1571.36,259274.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249955',4774221,'3057','472',19372.20,19853.75,481.55,79455.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249955',4774222,'3058','472',22305.50,23814.80,1509.30,249034.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249955',4774223,'3059','472',6696.12,6696.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249955',4774224,'3060','472',4280.39,4280.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249955',4774225,'3061','472',9807.69,9859.36,51.67,8525.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249955',4774226,'3062','472',17145.68,18215.60,1069.92,176536.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249955',4774227,'3063','472',3447.81,3692.22,244.41,40327.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','249955',4774228,'3064','473',104603.72,104812.90,209.18,72167.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249989',4774897,'3056','472',19571.78,20879.21,1307.43,215725.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249989',4774898,'3057','472',19853.75,20501.00,647.25,106796.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249989',4774899,'3058','472',23814.80,25347.68,1532.88,252925.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249989',4774900,'3059','472',6696.12,6936.97,240.85,39740.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249989',4774901,'3060','472',4280.39,4287.33,6.94,1145.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249989',4774902,'3061','472',9859.36,10339.74,480.38,79262.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249989',4774903,'3062','472',18215.60,19871.31,1655.71,273192.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','249989',4774904,'3063','472',3692.22,3692.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','249989',4774905,'3064','473',104812.90,104915.80,102.90,35500.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250186',4778031,'3056','472',20879.21,22033.29,1154.08,190423.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250186',4778032,'3057','472',20501.00,21630.88,1129.88,186430.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250186',4778033,'3058','472',25347.68,26953.57,1605.89,264971.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250186',4778034,'3059','472',6936.97,7187.38,250.41,41317.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250186',4778035,'3060','472',4287.33,4305.28,6.44,1062.60,0.00,0.00,11.51,0.00,0.00),('1','206','1030','250186',4778036,'3061','472',10339.74,10898.83,541.14,89288.10,0.00,0.00,17.95,0.00,0.00),('1','206','1030','250186',4778037,'3062','472',19871.31,20329.14,457.83,75541.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250186',4778038,'3063','472',3692.22,3948.03,245.81,40558.65,0.00,0.00,10.00,0.00,0.00),('1','206','1031','250186',4778039,'3064','473',104915.80,105086.09,170.29,58750.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250235',4778959,'3056','472',22033.29,23031.52,998.23,164707.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250235',4778960,'3057','472',21630.88,22276.29,645.41,106492.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250235',4778961,'3058','472',26953.57,27716.51,762.94,125885.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250235',4778962,'3059','472',7187.38,7245.77,58.39,9634.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250235',4778963,'3060','472',4305.28,4305.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250235',4778964,'3061','472',10898.83,10898.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250235',4778965,'3062','472',20329.14,20994.75,665.61,109825.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250235',4778966,'3063','472',3948.03,3948.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','250235',4778967,'3064','473',105086.09,105242.03,155.94,53799.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250408',4781606,'3056','472',23031.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250408',4781607,'3057','472',22276.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250408',4781608,'3058','472',27716.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250408',4781609,'3059','472',7245.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250408',4781610,'3060','472',4305.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250408',4781611,'3061','472',10898.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250408',4781612,'3062','472',20994.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250408',4781613,'3063','472',3948.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','250408',4781614,'3064','473',105242.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250409',4781615,'3056','472',23031.52,23901.27,849.53,140172.45,0.00,0.00,20.22,0.00,0.00),('1','206','1030','250409',4781616,'3057','472',22276.29,23453.25,1156.96,190898.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','250409',4781617,'3058','472',27716.51,29842.88,2116.37,349201.05,0.00,0.00,10.00,0.00,0.00),('1','206','1030','250409',4781618,'3059','472',7245.77,7551.28,295.51,48759.15,0.00,0.00,10.00,0.00,0.00),('1','206','1030','250409',4781619,'3060','472',4305.28,4784.16,458.43,75640.95,0.00,0.00,20.45,0.00,0.00),('1','206','1030','250409',4781620,'3061','472',10898.83,12791.74,1882.91,310680.15,0.00,0.00,10.00,0.00,0.00),('1','206','1030','250409',4781621,'3062','472',20994.75,21530.72,525.97,86785.05,0.00,0.00,10.00,0.00,0.00),('1','206','1030','250409',4781622,'3063','472',3948.03,4180.81,212.78,35108.70,0.00,0.00,20.00,0.00,0.00),('1','206','1031','250409',4781623,'3064','473',105242.03,105348.85,106.82,36852.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250506',4783359,'3056','472',23901.27,24267.40,366.13,60411.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250506',4783360,'3057','472',23453.25,24262.45,809.20,133518.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250506',4783361,'3058','472',29842.88,30418.62,575.74,94997.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250506',4783362,'3059','472',7551.28,7640.74,89.46,14760.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250506',4783363,'3060','472',4784.16,4784.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250506',4783364,'3061','472',12791.74,12791.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250506',4783365,'3062','472',21530.72,22049.68,518.96,85628.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250506',4783366,'3063','472',4180.81,4180.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','250506',4783367,'3064','473',105348.85,105363.34,14.49,4999.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250646',4785604,'3056','472',24267.40,24697.48,430.08,70963.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250646',4785605,'3057','472',24262.45,24850.35,587.90,97003.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250646',4785606,'3058','472',30418.62,30978.82,560.20,92433.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250646',4785607,'3059','472',7640.74,7928.79,288.05,47528.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250646',4785608,'3060','472',4784.16,4784.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250646',4785609,'3061','472',12791.74,12791.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250646',4785610,'3062','472',22049.68,22763.35,713.67,117755.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250646',4785611,'3063','472',4180.81,4264.40,83.59,13792.35,0.00,0.00,0.00,0.00,0.00),('1','206','1031','250646',4785612,'3064','473',105363.34,105392.32,28.98,9998.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250747',4787682,'3056','472',24697.48,25227.14,529.66,87393.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250747',4787683,'3057','472',24850.35,25398.19,547.84,90393.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250747',4787684,'3058','472',30978.82,31745.30,766.48,126469.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250747',4787685,'3059','472',7928.79,8064.30,135.51,22359.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250747',4787686,'3060','472',4784.16,4784.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250747',4787687,'3061','472',12791.74,13147.25,355.51,58659.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250747',4787688,'3062','472',22763.35,23201.40,438.05,72278.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250747',4787689,'3063','472',4264.40,4264.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','250747',4787690,'3064','473',105392.32,105434.35,42.03,14500.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250876',4789851,'3056','472',25227.14,25919.75,692.61,114280.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250876',4789852,'3057','472',25398.19,25926.21,528.02,87123.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250876',4789853,'3058','472',31745.30,32426.84,681.54,112454.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250876',4789854,'3059','472',8064.30,8367.71,303.41,50062.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250876',4789855,'3060','472',4784.16,4784.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250876',4789856,'3061','472',13147.25,13229.63,82.38,13592.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250876',4789857,'3062','472',23201.40,23877.99,676.59,111637.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250876',4789858,'3063','472',4264.40,4264.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','250876',4789859,'3064','473',105434.35,105552.90,118.55,40899.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250971',4791722,'3056','472',25919.75,26449.78,530.03,87454.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250971',4791723,'3057','472',25926.21,26814.08,887.87,146498.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250971',4791724,'3058','472',32426.84,33631.13,1204.29,198707.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250971',4791725,'3059','472',8367.71,8367.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250971',4791726,'3060','472',4784.16,4819.19,35.03,5779.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250971',4791727,'3061','472',13229.63,14614.46,1384.83,228496.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250971',4791728,'3062','472',23877.99,23896.17,18.18,2999.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','250971',4791729,'3063','472',4264.40,4264.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','250971',4791730,'3064','473',105552.90,105567.10,14.20,4899.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251106',4793814,'3056','472',26449.78,27466.27,1016.49,167720.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251106',4793815,'3057','472',26814.08,28472.50,1658.42,273639.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251106',4793816,'3058','472',33631.13,35441.81,1810.68,298762.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251106',4793817,'3059','472',8367.71,8367.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251106',4793818,'3060','472',4819.19,4825.25,6.06,999.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251106',4793819,'3061','472',14614.46,15288.04,673.58,111140.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251106',4793820,'3062','472',23896.17,25548.16,1651.99,272578.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251106',4793821,'3063','472',4264.40,4733.35,468.95,77376.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','251106',4793822,'3064','473',105567.10,105634.78,67.68,23349.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251228',4796129,'3056','472',27466.27,28131.54,665.27,109769.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251228',4796130,'3057','472',28472.50,29602.98,1130.48,186529.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251228',4796131,'3058','472',35441.81,36413.10,971.29,160262.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251228',4796132,'3059','472',8367.71,8507.08,139.37,22996.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251228',4796133,'3060','472',4825.25,4825.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251228',4796134,'3061','472',15288.04,15288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251228',4796135,'3062','472',25548.16,26760.22,1212.06,199989.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251228',4796136,'3063','472',4733.35,4733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','251228',4796137,'3064','473',105634.78,105737.10,102.32,35300.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251229',4796138,'3056','472',28131.54,28696.41,564.87,93203.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251229',4796139,'3057','472',29602.98,30881.30,1278.32,210922.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251229',4796140,'3058','472',36413.10,37713.52,1300.42,214569.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251229',4796141,'3059','472',8507.08,8705.50,198.42,32739.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251229',4796142,'3060','472',4825.25,4825.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251229',4796143,'3061','472',15288.04,15340.75,52.71,8697.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251229',4796144,'3062','472',26760.22,27924.54,1164.32,192112.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251229',4796145,'3063','472',4733.35,4733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','251229',4796146,'3064','473',105737.10,105906.61,169.51,58480.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251376',4798519,'3056','472',28696.41,29045.78,349.37,57646.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251376',4798520,'3057','472',30881.30,31975.58,1094.28,180556.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251376',4798521,'3058','472',37713.52,38592.23,878.71,144987.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251376',4798522,'3059','472',8705.50,8920.94,215.44,35547.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251376',4798523,'3060','472',4825.25,4889.77,64.52,10645.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251376',4798524,'3061','472',15340.75,15446.90,106.15,17514.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251376',4798525,'3062','472',27924.54,28402.17,477.63,78808.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251376',4798526,'3063','472',4733.35,4733.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','251376',4798527,'3064','473',105906.61,105925.16,18.55,6399.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251461',4800127,'3056','472',29045.78,29808.37,762.59,125827.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251461',4800128,'3057','472',31975.58,32873.39,897.81,148138.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251461',4800129,'3058','472',38592.23,39694.58,1102.35,181887.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251461',4800130,'3059','472',8920.94,9256.65,335.71,55392.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251461',4800131,'3060','472',4889.77,4889.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251461',4800132,'3061','472',15446.90,15523.86,56.96,9398.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','251461',4800133,'3062','472',28402.17,29302.19,900.02,148503.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251461',4800134,'3063','472',4733.35,4905.93,172.58,28475.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','251461',4800135,'3064','473',105925.16,105929.51,4.35,1500.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251615',4802662,'3056','472',29808.37,30602.76,794.39,131074.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251615',4802663,'3057','472',32873.39,33531.55,658.16,108596.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251615',4802664,'3058','472',39694.58,40964.78,1270.20,209583.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251615',4802665,'3059','472',9256.65,9392.71,126.06,20799.90,0.00,0.00,10.00,0.00,0.00),('1','206','1030','251615',4802666,'3060','472',4889.77,4993.70,103.93,17148.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251615',4802667,'3061','472',15523.86,16469.30,945.44,155997.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251615',4802668,'3062','472',29302.19,29781.49,479.30,79084.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251615',4802669,'3063','472',4905.93,4905.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','251615',4802670,'3064','473',105929.51,106101.21,171.70,59236.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251679',4804001,'3056','472',30602.76,31461.54,858.78,141698.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251679',4804002,'3057','472',33531.55,35296.39,1764.84,291198.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251679',4804003,'3058','472',40964.78,43066.93,2102.15,346854.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251679',4804004,'3059','472',9392.71,9734.75,342.04,56436.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251679',4804005,'3060','472',4993.70,5061.67,67.97,11215.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251679',4804006,'3061','472',16469.30,17082.52,613.22,101181.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251679',4804007,'3062','472',29781.49,31614.45,1832.96,302438.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251679',4804008,'3063','472',4905.93,4905.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','251679',4804009,'3064','473',106101.21,106576.88,475.67,164106.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251842',4806648,'3056','472',31461.54,31841.46,379.92,62686.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251842',4806649,'3057','472',35296.39,36070.46,774.07,127721.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251842',4806650,'3058','472',43066.93,43832.46,765.53,126312.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251842',4806651,'3059','472',9734.75,9989.61,254.86,42051.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251842',4806652,'3060','472',5061.67,5940.03,878.36,144929.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251842',4806653,'3061','472',17082.52,17094.64,12.12,1999.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251842',4806654,'3062','472',31614.45,31614.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251842',4806655,'3063','472',4905.93,4905.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','251842',4806656,'3064','473',106576.88,106637.90,61.02,21051.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251958',4808809,'3056','472',31841.46,33118.96,1277.50,210787.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251958',4808810,'3057','472',36070.46,36797.99,707.53,116742.45,0.00,0.00,20.00,0.00,0.00),('1','206','1030','251958',4808811,'3058','472',43832.46,44990.44,1157.98,191066.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251958',4808812,'3059','472',9989.61,10117.72,128.11,21138.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251958',4808813,'3060','472',5940.03,5940.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251958',4808814,'3061','472',17094.64,17113.54,18.90,3118.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251958',4808815,'3062','472',31614.45,32543.73,929.28,153331.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','251958',4808816,'3063','472',4905.93,5095.47,189.54,31274.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','251958',4808817,'3064','473',106637.90,106720.52,82.62,28503.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252109',4811265,'3056','472',33118.96,33903.87,784.91,129510.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252109',4811266,'3057','472',36797.99,37338.50,540.51,89184.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252109',4811267,'3058','472',44990.44,45729.91,739.47,122012.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252109',4811268,'3059','472',10117.72,10343.49,225.77,37252.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252109',4811269,'3060','472',5940.03,6624.42,684.39,112924.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252109',4811270,'3061','472',17113.54,17589.71,476.17,78568.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252109',4811271,'3062','472',32543.73,32543.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252109',4811272,'3063','472',5095.47,5095.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','252109',4811273,'3064','473',106720.52,106736.46,15.94,5499.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252309',4814610,'3056','472',33903.87,34388.82,484.95,80016.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252309',4814611,'3057','472',37338.50,38483.80,1145.30,188974.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252309',4814612,'3058','472',45729.91,46723.99,994.08,164023.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252309',4814613,'3059','472',10343.49,10626.32,282.83,46666.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252309',4814614,'3060','472',6624.42,6624.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252309',4814615,'3061','472',17589.71,18058.02,468.31,77271.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252309',4814616,'3062','472',32543.73,33265.96,722.23,119167.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252309',4814617,'3063','472',5095.47,5351.92,256.45,42314.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','252309',4814618,'3064','473',106736.46,106838.21,101.75,35103.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252416',4816864,'3056','472',34388.82,35088.77,699.95,115491.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252416',4816865,'3057','472',38483.80,38932.00,448.20,73953.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252416',4816866,'3058','472',46723.99,47366.10,642.11,105948.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252416',4816867,'3059','472',10626.32,10626.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252416',4816868,'3060','472',6624.42,6718.64,94.22,15546.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252416',4816869,'3061','472',18058.02,18774.85,716.83,118276.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252416',4816870,'3062','472',33265.96,33265.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252416',4816871,'3063','472',5351.92,5351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','252416',4816872,'3064','473',106838.21,106864.30,26.09,9001.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252432',4817203,'3056','472',35088.77,35750.66,661.89,109211.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252432',4817204,'3057','472',38932.00,39813.13,881.13,145386.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252432',4817205,'3058','472',47366.10,48252.92,886.82,146325.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252432',4817206,'3059','472',10626.32,10830.32,204.00,33660.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252432',4817207,'3060','472',6718.64,6795.60,76.96,12698.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252432',4817208,'3061','472',18774.85,19995.31,1220.46,201375.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252432',4817209,'3062','472',33265.96,33265.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252432',4817210,'3063','472',5351.92,5351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','252432',4817211,'3064','473',106864.30,106888.06,23.76,8197.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252601',4820058,'3056','472',35750.66,36132.34,381.68,62977.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252601',4820059,'3057','472',39813.13,40451.84,638.71,105387.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252601',4820060,'3058','472',48252.92,48949.45,696.53,114927.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252601',4820061,'3059','472',10830.32,10860.62,30.30,4999.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252601',4820062,'3060','472',6795.60,6795.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252601',4820063,'3061','472',19995.31,20917.79,922.48,152209.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252601',4820064,'3062','472',33265.96,33299.90,33.94,5600.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252601',4820065,'3063','472',5351.92,5351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','252601',4820066,'3064','473',106888.06,106943.71,55.65,19199.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252666',4821257,'3056','472',36132.34,36664.26,531.92,87766.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252666',4821258,'3057','472',40451.84,41170.39,718.55,118560.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252666',4821259,'3058','472',48949.45,49802.99,853.54,140834.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252666',4821260,'3059','472',10860.62,10874.86,14.24,2349.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252666',4821261,'3060','472',6795.60,7262.91,467.31,77106.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252666',4821262,'3061','472',20917.79,21442.27,524.48,86539.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252666',4821263,'3062','472',33299.90,33299.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252666',4821264,'3063','472',5351.92,5351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','252666',4821265,'3064','473',106943.71,106944.58,0.87,300.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252917',4825322,'3056','472',36664.26,37365.53,701.27,115709.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252917',4825323,'3057','472',41170.39,42405.80,1235.41,203842.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252917',4825324,'3058','472',49802.99,51184.28,1381.29,227912.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252917',4825325,'3059','472',10874.86,11206.27,331.41,54682.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252917',4825326,'3060','472',7262.91,7829.20,566.29,93437.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252917',4825327,'3061','472',21442.27,22039.04,596.77,98467.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252917',4825328,'3062','472',33299.90,33333.84,33.94,5600.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','252917',4825329,'3063','472',5351.92,5351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','252917',4825330,'3064','473',106944.58,107120.89,176.31,60826.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253080',4828042,'3056','472',37365.53,37745.92,380.39,62764.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253080',4828043,'3057','472',42405.80,42949.04,543.24,89634.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253080',4828044,'3058','472',51184.28,51765.64,581.36,95924.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253080',4828045,'3059','472',11206.27,11254.14,47.87,7898.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253080',4828046,'3060','472',7829.20,7878.89,49.69,8198.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253080',4828047,'3061','472',22039.04,22669.07,630.03,103954.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253080',4828048,'3062','472',33333.84,33340.93,7.09,1169.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253080',4828049,'3063','472',5351.92,5351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','253080',4828050,'3064','473',107120.89,107145.82,24.93,8600.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253331',4832151,'3056','472',37745.92,38598.45,852.53,140667.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253331',4832152,'3057','472',42949.04,43992.06,1043.02,172098.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253331',4832153,'3058','472',51765.64,53095.03,1329.39,219349.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253331',4832154,'3059','472',11254.14,11399.04,144.90,23908.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253331',4832155,'3060','472',7878.89,8103.42,224.53,37047.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253331',4832156,'3061','472',22669.07,24210.89,1541.82,254400.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253331',4832157,'3062','472',33340.93,33359.42,18.49,3050.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253331',4832158,'3063','472',5351.92,5351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','253331',4832159,'3064','473',107145.82,107289.10,143.28,49431.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253351',4832469,'3056','472',38598.45,38813.45,215.00,35475.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253351',4832470,'3057','472',43992.06,44796.58,804.52,132745.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253351',4832471,'3058','472',53095.03,54020.45,925.42,152694.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253351',4832472,'3059','472',11399.04,11555.29,156.25,25781.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253351',4832473,'3060','472',8103.42,8103.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253351',4832474,'3061','472',24210.89,25380.53,1169.64,192990.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253351',4832475,'3062','472',33359.42,33359.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253351',4832476,'3063','472',5351.92,5351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','253351',4832477,'3064','473',107289.10,107479.74,190.64,65770.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253397',4833381,'3056','472',38813.45,39574.88,761.43,125635.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253397',4833382,'3057','472',44796.58,46043.48,1246.90,205738.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253397',4833383,'3058','472',54020.45,55346.96,1326.51,218874.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253397',4833384,'3059','472',11555.29,11852.66,297.37,49066.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253397',4833385,'3060','472',8103.42,8103.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253397',4833386,'3061','472',25380.53,25850.74,470.21,77584.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253397',4833387,'3062','472',33359.42,34771.72,1412.30,233029.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253397',4833388,'3063','472',5351.92,5351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','253397',4833389,'3064','473',107479.74,107584.09,104.35,36000.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253570',4836333,'3056','472',39574.88,39574.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253570',4836334,'3057','472',46043.48,47310.75,1267.27,209099.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253570',4836335,'3058','472',55346.96,56402.56,1055.60,174174.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253570',4836336,'3059','472',11852.66,11893.52,40.86,6741.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253570',4836337,'3060','472',8103.42,8103.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253570',4836338,'3061','472',25850.74,27050.55,1199.81,197968.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253570',4836339,'3062','472',34771.72,35198.19,426.47,70367.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253570',4836340,'3063','472',5351.92,5351.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','253570',4836341,'3064','473',107584.09,107658.30,74.21,25602.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253662',4838049,'3056','472',39574.88,39574.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253662',4838050,'3057','472',47310.75,48837.52,1526.77,251917.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253662',4838051,'3058','472',56402.56,57780.03,1377.47,227282.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253662',4838052,'3059','472',11893.52,12101.90,208.38,34382.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253662',4838053,'3060','472',8103.42,9103.61,1000.19,165031.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253662',4838054,'3061','472',27050.55,28050.55,1000.00,165000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253662',4838055,'3062','472',35198.19,36067.11,868.92,143371.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253662',4838056,'3063','472',5351.92,5604.78,252.86,41721.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','253662',4838057,'3064','473',107658.30,107662.65,4.35,1500.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253826',4840871,'3056','472',39574.88,40139.96,565.08,93238.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253826',4840872,'3057','472',48837.52,49406.97,569.45,93959.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253826',4840873,'3058','472',57780.03,58793.17,1013.14,167168.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253826',4840874,'3059','472',12101.90,12101.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253826',4840875,'3060','472',9103.61,9103.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253826',4840876,'3061','472',28050.55,28050.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253826',4840877,'3062','472',36067.11,36913.51,846.40,139656.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253826',4840878,'3063','472',5604.78,5749.62,144.84,23898.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','253826',4840879,'3064','473',107662.65,107698.88,36.23,12499.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253908',4842475,'3056','472',40139.96,40595.27,455.31,75126.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253908',4842476,'3057','472',49406.97,50721.49,1314.52,216895.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253908',4842477,'3058','472',58793.17,60015.56,1222.39,201694.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253908',4842478,'3059','472',12101.90,12499.92,398.02,65673.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253908',4842479,'3060','472',9103.61,10213.61,1100.00,181500.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','253908',4842480,'3061','472',28050.55,29160.55,1100.00,181500.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','253908',4842481,'3062','472',36913.51,38147.52,1234.01,203611.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','253908',4842482,'3063','472',5749.62,6199.03,449.41,74152.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','253908',4842483,'3064','473',107698.88,108170.73,471.85,162788.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254063',4844930,'3056','472',40595.27,40595.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254063',4844931,'3057','472',50721.49,50721.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254063',4844932,'3058','472',60015.56,60015.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254063',4844933,'3059','472',12499.92,12499.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254063',4844934,'3060','472',10213.61,10213.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254063',4844935,'3061','472',29160.55,29160.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254063',4844936,'3062','472',38147.52,41515.62,3368.10,555736.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254063',4844937,'3063','472',6199.03,6199.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','254063',4844938,'3064','473',108170.73,108170.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254386',4850698,'3056','472',40595.27,40595.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254386',4850699,'3057','472',50721.49,50721.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254386',4850700,'3058','472',60015.56,60015.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254386',4850701,'3059','472',12499.92,12499.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254386',4850702,'3060','472',10213.61,10213.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254386',4850703,'3061','472',29160.55,29160.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254386',4850704,'3062','472',41515.62,41605.62,90.00,14850.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','254386',4850705,'3063','472',6199.03,6199.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','254386',4850706,'3064','473',108170.73,108399.72,228.99,79001.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255121',4863343,'3056','472',40595.27,40595.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255121',4863344,'3057','472',50721.49,50721.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255121',4863345,'3058','472',60015.56,60015.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255121',4863346,'3059','472',12499.92,12499.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255121',4863347,'3060','472',10213.61,10213.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255121',4863348,'3061','472',29160.55,29160.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255121',4863349,'3062','472',41605.62,41605.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255121',4863350,'3063','472',6199.03,6199.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','255121',4863351,'3064','473',108399.72,109464.72,1065.00,372750.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255528',4870001,'3056','472',40595.27,41084.32,489.05,80693.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255528',4870002,'3057','472',50721.49,51276.72,555.23,91612.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255528',4870003,'3058','472',60015.56,60222.46,206.90,34138.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255528',4870004,'3059','472',12499.92,12512.34,12.42,2049.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255528',4870005,'3060','472',10213.61,10274.22,60.61,10000.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255528',4870006,'3061','472',29160.55,29199.06,38.51,6354.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255528',4870007,'3062','472',41605.62,42142.23,536.61,88540.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255528',4870008,'3063','472',6199.03,6309.98,110.95,18306.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','255528',4870009,'3064','473',109464.72,109464.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255792',4874411,'3056','472',41084.32,41084.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255792',4874412,'3057','472',51276.72,52190.67,913.95,150801.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255792',4874413,'3058','472',60222.46,60988.02,765.56,126317.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255792',4874414,'3059','472',12512.34,12512.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255792',4874415,'3060','472',10274.22,10274.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255792',4874416,'3061','472',29199.06,29199.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255792',4874417,'3062','472',42142.23,42807.23,665.00,109725.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255792',4874418,'3063','472',6309.98,6388.05,78.07,12881.55,0.00,0.00,0.00,0.00,0.00),('1','206','1031','255792',4874419,'3064','473',109464.72,110409.59,944.87,335428.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255829',4875058,'3056','472',41084.32,41084.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255829',4875059,'3057','472',52190.67,52190.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255829',4875060,'3058','472',60988.02,61684.68,686.66,113298.90,0.00,0.00,10.00,0.00,0.00),('1','206','1030','255829',4875061,'3059','472',12512.34,12512.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255829',4875062,'3060','472',10274.22,10274.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255829',4875063,'3061','472',29199.06,29199.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','255829',4875064,'3062','472',42807.23,43537.70,710.47,117227.55,0.00,0.00,20.00,0.00,0.00),('1','206','1030','255829',4875065,'3063','472',6388.05,6580.87,182.82,30165.30,0.00,0.00,10.00,0.00,0.00),('1','206','1031','255829',4875066,'3064','473',110409.59,110419.59,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','256026',4878385,'3056','472',41084.32,41477.30,392.98,64841.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256026',4878386,'3057','472',52190.67,52837.26,646.59,106687.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256026',4878387,'3058','472',61684.68,62171.26,486.58,80285.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256026',4878388,'3059','472',12512.34,12775.33,262.99,43393.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256026',4878389,'3060','472',10274.22,10274.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256026',4878390,'3061','472',29199.06,29435.38,236.32,38992.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256026',4878391,'3062','472',43537.70,43873.92,336.22,55476.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256026',4878392,'3063','472',6580.87,6580.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','256026',4878393,'3064','473',110419.59,110562.63,143.04,50779.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256059',4879052,'3056','472',41477.30,41477.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256059',4879053,'3057','472',52837.26,53613.24,775.98,128036.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256059',4879054,'3058','472',62171.26,62566.88,395.62,65277.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256059',4879055,'3059','472',12775.33,12832.89,57.56,9497.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256059',4879056,'3060','472',10274.22,10274.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256059',4879057,'3061','472',29435.38,29521.14,85.76,14150.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256059',4879058,'3062','472',43873.92,44176.76,302.84,49968.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256059',4879059,'3063','472',6580.87,6580.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','256059',4879060,'3064','473',110562.63,110579.26,16.63,5903.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256146',4880452,'3056','472',41477.30,41477.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256146',4880453,'3057','472',53613.24,55231.86,1618.62,267072.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256146',4880454,'3058','472',62566.88,63293.70,726.82,119925.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256146',4880455,'3059','472',12832.89,13072.49,239.60,39534.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256146',4880456,'3060','472',10274.22,10274.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256146',4880457,'3061','472',29521.14,29521.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256146',4880458,'3062','472',44176.76,45022.71,845.95,139581.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256146',4880459,'3063','472',6580.87,6580.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','256146',4880460,'3064','473',110579.26,110966.11,386.85,137331.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256346',4883498,'3056','472',41477.30,42035.33,558.03,92074.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256346',4883499,'3057','472',55231.86,55800.16,568.30,93769.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256346',4883500,'3058','472',63293.70,63927.36,633.66,104553.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256346',4883501,'3059','472',13072.49,13133.10,60.61,10000.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256346',4883502,'3060','472',10274.22,10316.75,42.53,7017.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256346',4883503,'3061','472',29521.14,29609.01,87.87,14498.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256346',4883504,'3062','472',45022.71,45808.43,785.72,129643.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256346',4883505,'3063','472',6580.87,6730.56,149.69,24698.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','256346',4883506,'3064','473',110966.11,110970.05,3.94,1398.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256527',4886586,'3056','472',42035.33,42485.46,450.13,74271.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256527',4886587,'3057','472',55800.16,56874.59,1074.43,177280.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256527',4886588,'3058','472',63927.36,65295.25,1367.89,225701.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256527',4886589,'3059','472',13133.10,13357.83,224.73,37080.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256527',4886590,'3060','472',10316.75,10316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256527',4886591,'3061','472',29609.01,29609.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256527',4886592,'3062','472',45808.43,46910.85,1102.42,181899.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256527',4886593,'3063','472',6730.56,6988.86,258.30,42619.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','256527',4886594,'3064','473',110970.05,111132.86,162.81,57797.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256588',4887753,'3056','472',42485.46,42935.67,450.21,74284.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256588',4887754,'3057','472',56874.59,56976.10,101.51,16749.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256588',4887755,'3058','472',65295.25,65922.70,627.45,103529.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256588',4887756,'3059','472',13357.83,13357.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256588',4887757,'3060','472',10316.75,10316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256588',4887758,'3061','472',29609.01,30022.63,413.62,68247.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256588',4887759,'3062','472',46910.85,46970.38,59.53,9822.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256588',4887760,'3063','472',6988.86,6988.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','256588',4887761,'3064','473',111132.86,111163.57,30.71,10902.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256670',4889223,'3056','472',42935.67,44289.24,1353.57,223339.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256670',4889224,'3057','472',56976.10,57240.16,264.06,43569.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256670',4889225,'3058','472',65922.70,67075.24,1152.54,190169.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256670',4889226,'3059','472',13357.83,13579.31,221.48,36544.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256670',4889227,'3060','472',10316.75,10316.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256670',4889228,'3061','472',30022.63,31396.02,1373.39,226609.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256670',4889229,'3062','472',46970.38,47033.40,63.02,10398.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256670',4889230,'3063','472',6988.86,6988.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','256670',4889231,'3064','473',111163.57,111323.11,159.54,56636.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256813',4891450,'3056','472',44289.24,45688.81,1399.57,230929.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256813',4891451,'3057','472',57240.16,57246.97,6.81,1123.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256813',4891452,'3058','472',67075.24,68105.77,1000.53,165087.45,0.00,0.00,30.00,0.00,0.00),('1','206','1030','256813',4891453,'3059','472',13579.31,13614.45,35.14,5798.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256813',4891454,'3060','472',10316.75,10332.04,15.29,2522.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256813',4891455,'3061','472',31396.02,31963.26,567.24,93594.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256813',4891456,'3062','472',47033.40,47727.23,693.83,114481.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','256813',4891457,'3063','472',6988.86,6988.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','256813',4891458,'3064','473',111323.11,111337.19,14.08,4998.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257017',4894839,'3056','472',45688.81,47209.74,1520.93,250953.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257017',4894840,'3057','472',57246.97,57250.39,3.42,564.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257017',4894841,'3058','472',68105.77,68951.38,812.19,134011.35,0.00,0.00,33.42,0.00,0.00),('1','206','1030','257017',4894842,'3059','472',13614.45,14028.50,414.05,68318.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257017',4894843,'3060','472',10332.04,10332.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257017',4894844,'3061','472',31963.26,31963.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257017',4894845,'3062','472',47727.23,48681.35,954.12,157429.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257017',4894846,'3063','472',6988.86,7092.33,103.47,17072.55,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257017',4894847,'3064','473',111337.19,111471.27,134.08,47598.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257096',4896553,'3056','472',47209.74,48275.99,1066.25,175931.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257096',4896554,'3057','472',57250.39,57250.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257096',4896555,'3058','472',68951.38,69762.04,810.66,133758.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257096',4896556,'3059','472',14028.50,14028.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257096',4896557,'3060','472',10332.04,10332.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257096',4896558,'3061','472',31963.26,31964.17,0.91,150.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257096',4896559,'3062','472',48681.35,49482.56,801.21,132199.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257096',4896560,'3063','472',7092.33,7116.27,23.94,3950.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257096',4896561,'3064','473',111471.27,111475.99,4.72,1699.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257183',4898306,'3056','472',48275.99,48627.47,351.48,57994.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257183',4898307,'3057','472',57250.39,58706.40,1456.01,240241.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257183',4898308,'3058','472',69762.04,70506.36,744.32,122812.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257183',4898309,'3059','472',14028.50,14660.87,632.37,104341.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257183',4898310,'3060','472',10332.04,10376.28,24.24,3999.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257183',4898311,'3061','472',31964.17,32074.78,100.61,16600.65,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257183',4898312,'3062','472',49482.56,50566.64,1084.08,178873.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257183',4898313,'3063','472',7116.27,7641.64,505.37,83386.05,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257183',4898314,'3064','473',111475.99,111501.18,25.19,9068.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257403',4902174,'3056','472',48627.47,49592.98,965.51,159309.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257403',4902175,'3057','472',58706.40,58733.17,26.77,4417.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257403',4902176,'3058','472',70506.36,71248.14,741.78,122393.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257403',4902177,'3059','472',14660.87,14660.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257403',4902178,'3060','472',10376.28,10376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257403',4902179,'3061','472',32074.78,32738.06,663.28,109441.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257403',4902180,'3062','472',50566.64,50878.74,312.10,51496.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257403',4902181,'3063','472',7641.64,7641.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257403',4902182,'3064','473',111501.18,111654.11,152.93,55054.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257624',4905971,'3056','472',49592.98,51335.67,1742.69,287543.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257624',4905972,'3057','472',58733.17,58733.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257624',4905973,'3058','472',71248.14,72679.64,1431.50,236197.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257624',4905974,'3059','472',14660.87,14861.61,200.74,33122.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257624',4905975,'3060','472',10376.28,10376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257624',4905976,'3061','472',32738.06,33563.10,825.04,136131.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257624',4905977,'3062','472',50878.74,51782.86,904.12,149179.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257624',4905978,'3063','472',7641.64,7641.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257624',4905979,'3064','473',111654.11,112165.23,511.12,184003.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257625',4905980,'3056','472',51335.67,52431.36,1085.69,179138.85,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257625',4905981,'3057','472',58733.17,59736.90,1003.73,165615.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257625',4905982,'3058','472',72679.64,74116.41,1436.77,237067.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257625',4905983,'3059','472',14861.61,14963.73,102.12,16849.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257625',4905984,'3060','472',10376.28,10376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257625',4905985,'3061','472',33563.10,34144.44,581.34,95921.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257625',4905986,'3062','472',51782.86,53048.76,1265.90,208873.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257625',4905987,'3063','472',7641.64,8102.94,461.30,76114.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257625',4905988,'3064','473',112165.23,112267.20,101.97,36709.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257626',4905989,'3056','472',52431.36,52431.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257626',4905990,'3057','472',59736.90,59736.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257626',4905991,'3058','472',74116.41,76031.70,1915.29,316022.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257626',4905992,'3059','472',14963.73,14963.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257626',4905993,'3060','472',10376.28,10376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257626',4905994,'3061','472',34144.44,34144.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257626',4905995,'3062','472',53048.76,54429.94,1381.18,227894.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257626',4905996,'3063','472',8102.94,8102.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257626',4905997,'3064','473',112267.20,112804.70,537.50,193500.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257627',4905998,'3056','472',52431.36,52431.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257627',4905999,'3057','472',59736.90,59736.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257627',4906000,'3058','472',76031.70,76479.86,448.16,73946.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257627',4906001,'3059','472',14963.73,14964.07,0.34,56.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257627',4906002,'3060','472',10376.28,10376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257627',4906003,'3061','472',34144.44,34144.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257627',4906004,'3062','472',54429.94,54703.56,273.62,45147.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257627',4906005,'3063','472',8102.94,8102.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257627',4906006,'3064','473',112804.70,112804.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257628',4906007,'3056','472',52431.36,52677.72,246.36,40649.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257628',4906008,'3057','472',59736.90,60094.84,357.94,59060.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257628',4906009,'3058','472',76479.86,76757.49,277.63,45808.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257628',4906010,'3059','472',14964.07,14964.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257628',4906011,'3060','472',10376.28,10376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257628',4906012,'3061','472',34144.44,34144.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257628',4906013,'3062','472',54703.56,54904.99,201.43,33235.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257628',4906014,'3063','472',8102.94,8201.30,98.36,16229.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257628',4906015,'3064','473',112804.70,113785.26,980.56,353001.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257629',4906016,'3056','472',52677.72,53360.43,682.71,112647.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257629',4906017,'3057','472',60094.84,60737.23,642.39,105994.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257629',4906018,'3058','472',76757.49,78138.93,1381.44,227937.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257629',4906019,'3059','472',14964.07,14964.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257629',4906020,'3060','472',10376.28,10376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257629',4906021,'3061','472',34144.44,34513.25,368.81,60853.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257629',4906022,'3062','472',54904.99,55825.75,920.76,151925.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257629',4906023,'3063','472',8201.30,8201.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257629',4906024,'3064','473',113785.26,114975.68,1190.42,428551.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257630',4906025,'3056','472',53360.43,53920.43,560.00,92400.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257630',4906026,'3057','472',60737.23,61122.49,385.26,63567.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257630',4906027,'3058','472',78138.93,78775.94,637.01,105106.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257630',4906028,'3059','472',14964.07,14964.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257630',4906029,'3060','472',10376.28,10376.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257630',4906030,'3061','472',34513.25,34513.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257630',4906031,'3062','472',55825.75,56396.68,570.93,94203.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257630',4906032,'3063','472',8201.30,8201.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257630',4906033,'3064','473',114975.68,115004.30,28.62,10303.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257631',4906034,'3056','472',53920.43,54801.01,860.58,141995.70,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257631',4906035,'3057','472',61122.49,61960.77,818.28,135016.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257631',4906036,'3058','472',78775.94,79349.56,553.62,91347.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257631',4906037,'3059','472',14964.07,15308.59,324.52,53545.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257631',4906038,'3060','472',10376.28,10409.99,13.71,2262.15,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257631',4906039,'3061','472',34513.25,34810.39,277.14,45728.10,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257631',4906040,'3062','472',56396.68,57132.99,716.31,118191.15,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257631',4906041,'3063','472',8201.30,8334.63,113.33,18699.45,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257631',4906042,'3064','473',115004.30,115276.87,262.57,94525.20,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257632',4906043,'3056','472',54801.01,55237.58,436.57,72034.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257632',4906044,'3057','472',61960.77,62611.32,650.55,107340.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257632',4906045,'3058','472',79349.56,80035.90,686.34,113246.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257632',4906046,'3059','472',15308.59,15703.20,394.61,65110.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257632',4906047,'3060','472',10409.99,10409.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257632',4906048,'3061','472',34810.39,34810.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257632',4906049,'3062','472',57132.99,58163.56,1030.57,170044.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257632',4906050,'3063','472',8334.63,8334.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257632',4906051,'3064','473',115276.87,115380.50,103.63,37306.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257633',4906052,'3056','472',55237.58,56054.01,816.43,134710.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257633',4906053,'3057','472',62611.32,63637.14,1025.82,169260.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257633',4906054,'3058','472',80035.90,81178.98,1143.08,188608.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257633',4906055,'3059','472',15703.20,16119.31,416.11,68658.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257633',4906056,'3060','472',10409.99,10409.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257633',4906057,'3061','472',34810.39,34861.90,51.51,8499.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257633',4906058,'3062','472',58163.56,59431.58,1268.02,209223.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257633',4906059,'3063','472',8334.63,8370.39,35.76,5900.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257633',4906060,'3064','473',115380.50,115742.82,362.32,130435.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257634',4906061,'3056','472',56054.01,57207.63,1153.62,190347.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257634',4906062,'3057','472',63637.14,63637.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257634',4906063,'3058','472',81178.98,81889.42,710.44,117222.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257634',4906064,'3059','472',16119.31,16390.62,271.31,44766.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257634',4906065,'3060','472',10409.99,10409.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257634',4906066,'3061','472',34861.90,34861.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257634',4906067,'3062','472',59431.58,60400.64,969.06,159894.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257634',4906068,'3063','472',8370.39,8370.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257634',4906069,'3064','473',115742.82,118882.74,3139.92,1130371.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257635',4906070,'3056','472',57207.63,58301.19,1093.56,180437.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257635',4906071,'3057','472',63637.14,64581.69,944.55,155850.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257635',4906072,'3058','472',81889.42,83195.39,1305.97,215485.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257635',4906073,'3059','472',16390.62,16551.35,160.73,26520.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257635',4906074,'3060','472',10409.99,10409.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257635',4906075,'3061','472',34861.90,35427.34,565.44,93297.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257635',4906076,'3062','472',60400.64,61245.79,845.15,139449.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257635',4906077,'3063','472',8370.39,8421.38,50.99,8413.35,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257635',4906078,'3064','473',118882.74,120490.78,1608.04,611055.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257636',4906079,'3056','472',58301.19,58670.60,369.41,60952.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257636',4906080,'3057','472',64581.69,65141.59,559.90,92383.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257636',4906081,'3058','472',83195.39,83796.33,600.94,99155.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257636',4906082,'3059','472',16551.35,16735.31,183.96,30353.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257636',4906083,'3060','472',10409.99,10409.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257636',4906084,'3061','472',35427.34,35427.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257636',4906085,'3062','472',61245.79,61878.31,632.52,104365.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257636',4906086,'3063','472',8421.38,8421.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257636',4906087,'3064','473',120490.78,120774.80,284.02,107927.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257637',4906088,'3056','472',58670.60,59045.51,374.91,61860.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257637',4906089,'3057','472',65141.59,66071.42,929.83,153421.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257637',4906090,'3058','472',83796.33,84628.88,832.55,137370.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257637',4906091,'3059','472',16735.31,17009.76,274.45,45284.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257637',4906092,'3060','472',10409.99,10409.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257637',4906093,'3061','472',35427.34,35427.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257637',4906094,'3062','472',61878.31,62811.66,933.35,154002.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257637',4906095,'3063','472',8421.38,8457.97,36.59,6037.35,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257637',4906096,'3064','473',120774.80,120840.21,65.41,24855.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257638',4906097,'3056','472',59045.51,59787.48,741.97,122425.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257638',4906098,'3057','472',66071.42,66647.03,575.61,94975.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257638',4906099,'3058','472',84628.88,85588.28,959.40,158301.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257638',4906100,'3059','472',17009.76,17009.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257638',4906101,'3060','472',10409.99,10409.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257638',4906102,'3061','472',35427.34,36102.03,674.69,111323.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257638',4906103,'3062','472',62811.66,62831.06,19.40,3201.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257638',4906104,'3063','472',8457.97,8457.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257638',4906105,'3064','473',120840.21,120841.53,1.32,501.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257639',4906106,'3056','472',59787.48,61260.06,1472.58,242975.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257639',4906107,'3057','472',66647.03,68782.47,2135.44,352347.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257639',4906108,'3058','472',85588.28,87470.16,1881.88,310510.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257639',4906109,'3059','472',17009.76,18263.59,1253.83,206881.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257639',4906110,'3060','472',10409.99,10835.39,425.40,70191.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257639',4906111,'3061','472',36102.03,37505.52,1403.49,231575.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257639',4906112,'3062','472',62831.06,64727.33,1896.27,312884.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257639',4906113,'3063','472',8457.97,8733.46,255.49,42155.85,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257639',4906114,'3064','473',120841.53,120874.42,22.89,8698.20,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257640',4906115,'3056','472',61260.06,61865.40,605.34,99881.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257640',4906116,'3057','472',68782.47,70571.07,1788.60,295119.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257640',4906117,'3058','472',87470.16,89211.28,1741.12,287284.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257640',4906118,'3059','472',18263.59,18292.64,29.05,4793.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257640',4906119,'3060','472',10835.39,10835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257640',4906120,'3061','472',37505.52,38350.16,844.64,139365.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257640',4906121,'3062','472',64727.33,66102.27,1374.94,226865.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257640',4906122,'3063','472',8733.46,8733.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257640',4906123,'3064','473',120874.42,121153.38,278.96,106004.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257641',4906124,'3056','472',61865.40,61865.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257641',4906125,'3057','472',70571.07,70571.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257641',4906126,'3058','472',89211.28,89211.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257641',4906127,'3059','472',18292.64,18292.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257641',4906128,'3060','472',10835.39,10835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257641',4906129,'3061','472',38350.16,38350.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257641',4906130,'3062','472',66102.27,66102.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257641',4906131,'3063','472',8733.46,8733.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257641',4906132,'3064','473',121153.38,121158.64,5.26,1998.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257642',4906133,'3056','472',61865.40,61865.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257642',4906134,'3057','472',70571.07,70571.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257642',4906135,'3058','472',89211.28,89211.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257642',4906136,'3059','472',18292.64,18292.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257642',4906137,'3060','472',10835.39,10835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257642',4906138,'3061','472',38350.16,38350.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257642',4906139,'3062','472',66102.27,66102.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257642',4906140,'3063','472',8733.46,8733.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257642',4906141,'3064','473',121158.64,123484.12,2325.48,906937.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257643',4906142,'3056','472',61865.40,61865.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257643',4906143,'3057','472',70571.07,70571.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257643',4906144,'3058','472',89211.28,89211.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257643',4906145,'3059','472',18292.64,18292.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257643',4906146,'3060','472',10835.39,10835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257643',4906147,'3061','472',38350.16,38350.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257643',4906148,'3062','472',66102.27,66102.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257643',4906149,'3063','472',8733.46,8733.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257643',4906150,'3064','473',123484.12,123810.29,326.17,127206.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257644',4906151,'3056','472',61865.40,61865.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257644',4906152,'3057','472',70571.07,72557.21,1986.14,327713.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257644',4906153,'3058','472',89211.28,92051.61,2840.33,468654.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257644',4906154,'3059','472',18292.64,18292.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257644',4906155,'3060','472',10835.39,10835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257644',4906156,'3061','472',38350.16,38777.30,407.14,67178.10,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257644',4906157,'3062','472',66102.27,71072.87,4970.60,820149.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257644',4906158,'3063','472',8733.46,8733.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257644',4906159,'3064','473',123810.29,124942.79,1132.50,453000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257645',4906160,'3056','472',61865.40,61865.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257645',4906161,'3057','472',72557.21,72557.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257645',4906162,'3058','472',92051.61,92051.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257645',4906163,'3059','472',18292.64,18292.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257645',4906164,'3060','472',10835.39,10835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257645',4906165,'3061','472',38777.30,38819.72,42.42,6999.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257645',4906166,'3062','472',71072.87,71540.27,467.40,77121.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257645',4906167,'3063','472',8733.46,8733.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257645',4906168,'3064','473',124942.79,125167.79,225.00,90000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257646',4906169,'3056','472',61865.40,61865.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257646',4906170,'3057','472',72557.21,72557.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257646',4906171,'3058','472',92051.61,93741.62,1690.01,278851.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257646',4906172,'3059','472',18292.64,18292.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257646',4906173,'3060','472',10835.39,10835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257646',4906174,'3061','472',38819.72,38843.97,24.25,4001.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257646',4906175,'3062','472',71540.27,75195.52,3655.25,603116.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257646',4906176,'3063','472',8733.46,8733.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257646',4906177,'3064','473',125167.79,125574.04,406.25,162500.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257647',4906178,'3056','472',61865.40,61865.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257647',4906179,'3057','472',72557.21,72557.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257647',4906180,'3058','472',93741.62,93741.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257647',4906181,'3059','472',18292.64,18292.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257647',4906182,'3060','472',10835.39,10835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257647',4906183,'3061','472',38843.97,38843.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257647',4906184,'3062','472',75195.52,75692.47,496.95,81996.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257647',4906185,'3063','472',8733.46,8733.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257647',4906186,'3064','473',125574.04,129945.87,4371.83,1748732.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257648',4906187,'3056','472',61865.40,61865.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257648',4906188,'3057','472',72557.21,72557.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257648',4906189,'3058','472',93741.62,93741.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257648',4906190,'3059','472',18292.64,18292.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257648',4906191,'3060','472',10835.39,10835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257648',4906192,'3061','472',38843.97,38843.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257648',4906193,'3062','472',75692.47,76166.02,473.55,78135.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257648',4906194,'3063','472',8733.46,8733.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257648',4906195,'3064','473',129945.87,130295.87,350.00,140000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257649',4906196,'3056','472',61865.40,61865.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257649',4906197,'3057','472',72557.21,72557.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257649',4906198,'3058','472',93741.62,93741.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257649',4906199,'3059','472',18292.64,18292.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257649',4906200,'3060','472',10835.39,10835.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257649',4906201,'3061','472',38843.97,38843.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257649',4906202,'3062','472',76166.02,76166.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257649',4906203,'3063','472',8733.46,8733.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257649',4906204,'3064','473',130295.87,131595.87,1300.00,533000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257650',4906205,'3056','472',61865.40,61875.87,10.47,1727.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257650',4906206,'3057','472',72557.21,72567.33,10.12,1669.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257650',4906207,'3058','472',93741.62,94195.03,453.41,74812.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257650',4906208,'3059','472',18292.64,18309.25,16.61,2740.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257650',4906209,'3060','472',10835.39,10845.93,10.54,1739.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257650',4906210,'3061','472',38843.97,38854.11,10.14,1673.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257650',4906211,'3062','472',76166.02,80622.93,4456.91,735390.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257650',4906212,'3063','472',8733.46,12217.37,3483.91,574845.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257650',4906213,'3064','473',131595.87,131745.40,149.53,61307.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257651',4906214,'3056','472',61875.87,61875.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257651',4906215,'3057','472',72567.33,72567.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257651',4906216,'3058','472',94195.03,94195.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257651',4906217,'3059','472',18309.25,20373.61,2064.36,340619.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257651',4906218,'3060','472',10845.93,10845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257651',4906219,'3061','472',38854.11,40090.32,1236.21,203974.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257651',4906220,'3062','472',80622.93,80659.29,36.36,5999.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257651',4906221,'3063','472',12217.37,12724.93,507.56,83747.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257651',4906222,'3064','473',131745.40,132893.94,1128.54,462701.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257652',4906223,'3056','472',61875.87,61875.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257652',4906224,'3057','472',72567.33,72567.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257652',4906225,'3058','472',94195.03,94195.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257652',4906226,'3059','472',20373.61,20503.91,130.30,21499.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257652',4906227,'3060','472',10845.93,10845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257652',4906228,'3061','472',40090.32,40242.42,152.10,25096.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257652',4906229,'3062','472',80659.29,80659.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257652',4906230,'3063','472',12724.93,14093.87,1368.94,225875.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257652',4906231,'3064','473',132893.94,132893.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257653',4906232,'3056','472',61875.87,61917.37,20.60,3399.00,0.00,0.00,20.90,0.00,0.00),('1','206','1030','257653',4906233,'3057','472',72567.33,72727.32,149.99,24748.35,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257653',4906234,'3058','472',94195.03,94345.69,140.66,23208.90,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257653',4906235,'3059','472',20503.91,20513.91,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257653',4906236,'3060','472',10845.93,10956.90,100.97,16660.05,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257653',4906237,'3061','472',40242.42,40943.31,690.89,113996.85,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257653',4906238,'3062','472',80659.29,80963.38,294.09,48524.85,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257653',4906239,'3063','472',14093.87,14767.04,663.17,109423.05,0.00,0.00,10.00,0.00,0.00),('1','206','1031','257653',4906240,'3064','473',132893.94,132893.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257654',4906241,'3056','472',61917.37,61917.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257654',4906242,'3057','472',72727.32,72892.89,165.57,27319.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257654',4906243,'3058','472',94345.69,94610.06,264.37,43621.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257654',4906244,'3059','472',20513.91,20513.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257654',4906245,'3060','472',10956.90,10956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257654',4906246,'3061','472',40943.31,41095.59,152.28,25126.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257654',4906247,'3062','472',80963.38,80963.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257654',4906248,'3063','472',14767.04,15157.77,390.73,64470.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257654',4906249,'3064','473',132893.94,132893.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257655',4906250,'3056','472',61917.37,61917.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257655',4906251,'3057','472',72892.89,76032.93,3140.04,518106.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257655',4906252,'3058','472',94610.06,96538.84,1928.78,318248.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257655',4906253,'3059','472',20513.91,23340.68,2826.77,466417.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257655',4906254,'3060','472',10956.90,10956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257655',4906255,'3061','472',41095.59,41095.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257655',4906256,'3062','472',80963.38,80963.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257655',4906257,'3063','472',15157.77,19502.72,4344.95,716916.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257655',4906258,'3064','473',132893.94,132988.27,94.33,38675.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257656',4906259,'3056','472',61917.37,61917.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257656',4906260,'3057','472',76032.93,76032.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257656',4906261,'3058','472',96538.84,98332.41,1793.57,295939.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257656',4906262,'3059','472',23340.68,23340.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257656',4906263,'3060','472',10956.90,10956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257656',4906264,'3061','472',41095.59,41095.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257656',4906265,'3062','472',80963.38,84081.17,3117.79,514435.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257656',4906266,'3063','472',19502.72,20398.41,895.69,147788.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257656',4906267,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257657',4906268,'3056','472',61917.37,61917.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257657',4906269,'3057','472',76032.93,76032.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257657',4906270,'3058','472',98332.41,99646.48,1294.07,213521.55,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257657',4906271,'3059','472',23340.68,23340.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257657',4906272,'3060','472',10956.90,11217.70,240.80,39732.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257657',4906273,'3061','472',41095.59,41236.92,121.33,20019.45,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257657',4906274,'3062','472',84081.17,85450.69,1369.52,225970.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257657',4906275,'3063','472',20398.41,22388.84,1990.43,328420.95,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257657',4906276,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257658',4906277,'3056','472',61917.37,61917.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257658',4906278,'3057','472',76032.93,76032.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257658',4906279,'3058','472',99646.48,101739.27,2092.79,345310.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257658',4906280,'3059','472',23340.68,23821.66,480.98,79361.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257658',4906281,'3060','472',11217.70,11217.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257658',4906282,'3061','472',41236.92,41305.86,68.94,11375.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257658',4906283,'3062','472',85450.69,87299.38,1848.69,305033.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257658',4906284,'3063','472',22388.84,23506.55,1117.71,184422.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257658',4906285,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257659',4906286,'3056','472',61917.37,61917.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257659',4906287,'3057','472',76032.93,76032.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257659',4906288,'3058','472',101739.27,101739.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257659',4906289,'3059','472',23821.66,23821.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257659',4906290,'3060','472',11217.70,11217.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257659',4906291,'3061','472',41305.86,41305.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257659',4906292,'3062','472',87299.38,88015.21,715.83,118111.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257659',4906293,'3063','472',23506.55,23506.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257659',4906294,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257660',4906295,'3056','472',61917.37,61917.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257660',4906296,'3057','472',76032.93,76032.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257660',4906297,'3058','472',101739.27,101739.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257660',4906298,'3059','472',23821.66,23821.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257660',4906299,'3060','472',11217.70,11217.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257660',4906300,'3061','472',41305.86,41305.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257660',4906301,'3062','472',88015.21,88690.12,654.91,108060.15,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257660',4906302,'3063','472',23506.55,23506.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257660',4906303,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257661',4906304,'3056','472',61917.37,62076.92,139.55,23025.75,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257661',4906305,'3057','472',76032.93,76279.35,226.42,37359.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257661',4906306,'3058','472',101739.27,102107.80,348.53,57507.45,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257661',4906307,'3059','472',23821.66,24266.01,424.35,70017.75,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257661',4906308,'3060','472',11217.70,11271.80,34.10,5626.50,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257661',4906309,'3061','472',41305.86,41953.66,627.80,103587.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257661',4906310,'3062','472',88690.12,89540.62,830.50,137032.50,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257661',4906311,'3063','472',23506.55,23921.58,395.03,65179.95,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257661',4906312,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257662',4906313,'3056','472',62076.92,62286.57,209.65,34592.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257662',4906314,'3057','472',76279.35,77960.75,1661.40,274131.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257662',4906315,'3058','472',102107.80,103185.24,1077.44,177777.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257662',4906316,'3059','472',24266.01,24477.62,211.61,34915.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257662',4906317,'3060','472',11271.80,11422.36,150.56,24842.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257662',4906318,'3061','472',41953.66,43973.98,2020.32,333352.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257662',4906319,'3062','472',89540.62,91119.39,1578.77,260497.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257662',4906320,'3063','472',23921.58,24410.85,489.27,80729.55,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257662',4906321,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257663',4906322,'3056','472',62286.57,62370.57,84.00,13860.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257663',4906323,'3057','472',77960.75,77960.76,0.01,1.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257663',4906324,'3058','472',103185.24,103865.01,679.77,112162.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257663',4906325,'3059','472',24477.62,24477.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257663',4906326,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257663',4906327,'3061','472',43973.98,44911.45,937.47,154682.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257663',4906328,'3062','472',91119.39,91522.31,402.92,66481.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257663',4906329,'3063','472',24410.85,27211.58,2800.73,462120.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257663',4906330,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257664',4906331,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257664',4906332,'3057','472',77960.76,77960.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257664',4906333,'3058','472',103865.01,103865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257664',4906334,'3059','472',24477.62,24477.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257664',4906335,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257664',4906336,'3061','472',44911.45,45175.20,263.75,43518.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257664',4906337,'3062','472',91522.31,94906.72,3384.41,558427.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257664',4906338,'3063','472',27211.58,28003.88,792.30,130729.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257664',4906339,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257665',4906340,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257665',4906341,'3057','472',77960.76,77960.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257665',4906342,'3058','472',103865.01,104399.14,534.13,88131.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257665',4906343,'3059','472',24477.62,24477.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257665',4906344,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257665',4906345,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257665',4906346,'3062','472',94906.72,98055.90,3149.18,519614.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257665',4906347,'3063','472',28003.88,28003.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257665',4906348,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257666',4906349,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257666',4906350,'3057','472',77960.76,77960.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257666',4906351,'3058','472',104399.14,104882.93,483.79,79825.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257666',4906352,'3059','472',24477.62,24960.20,482.58,79625.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257666',4906353,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257666',4906354,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257666',4906355,'3062','472',98055.90,100084.44,2008.54,331409.10,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257666',4906356,'3063','472',28003.88,29126.44,1122.56,185222.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257666',4906357,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257667',4906358,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257667',4906359,'3057','472',77960.76,77960.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257667',4906360,'3058','472',104882.93,104882.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257667',4906361,'3059','472',24960.20,26545.36,1585.16,261551.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257667',4906362,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257667',4906363,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257667',4906364,'3062','472',100084.44,103425.31,3340.87,551243.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257667',4906365,'3063','472',29126.44,29241.45,115.01,18976.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257667',4906366,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257668',4906367,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257668',4906368,'3057','472',77960.76,77960.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257668',4906369,'3058','472',104882.93,106125.03,1222.10,201646.50,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257668',4906370,'3059','472',26545.36,29480.47,2935.11,484293.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257668',4906371,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257668',4906372,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257668',4906373,'3062','472',103425.31,107358.20,3932.89,648926.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257668',4906374,'3063','472',29241.45,29241.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257668',4906375,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257669',4906376,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257669',4906377,'3057','472',77960.76,80113.57,2152.81,355213.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257669',4906378,'3058','472',106125.03,106125.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257669',4906379,'3059','472',29480.47,31205.54,1725.07,284636.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257669',4906380,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257669',4906381,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257669',4906382,'3062','472',107358.20,109733.09,2374.89,391856.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257669',4906383,'3063','472',29241.45,29241.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257669',4906384,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257670',4906385,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257670',4906386,'3057','472',80113.57,81676.64,1563.07,257906.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257670',4906387,'3058','472',106125.03,106393.81,268.78,44348.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257670',4906388,'3059','472',31205.54,31205.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257670',4906389,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257670',4906390,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257670',4906391,'3062','472',109733.09,112646.53,2913.44,480717.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257670',4906392,'3063','472',29241.45,29241.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257670',4906393,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257671',4906394,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257671',4906395,'3057','472',81676.64,82193.04,516.40,85206.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257671',4906396,'3058','472',106393.81,110610.63,4216.82,695775.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257671',4906397,'3059','472',31205.54,31205.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257671',4906398,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257671',4906399,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257671',4906400,'3062','472',112646.53,116653.96,4007.43,661225.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257671',4906401,'3063','472',29241.45,29241.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257671',4906402,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257672',4906403,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257672',4906404,'3057','472',82193.04,82193.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257672',4906405,'3058','472',110610.63,112776.88,2166.25,357431.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257672',4906406,'3059','472',31205.54,31260.35,54.81,9043.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257672',4906407,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257672',4906408,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257672',4906409,'3062','472',116653.96,119935.03,3281.07,541376.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257672',4906410,'3063','472',29241.45,29466.86,225.41,37192.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257672',4906411,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257673',4906412,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257673',4906413,'3057','472',82193.04,82193.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257673',4906414,'3058','472',112776.88,113711.86,934.98,154271.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257673',4906415,'3059','472',31260.35,31260.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257673',4906416,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257673',4906417,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257673',4906418,'3062','472',119935.03,122470.62,2535.59,418372.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257673',4906419,'3063','472',29466.86,29466.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257673',4906420,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257674',4906421,'3056','472',62370.57,62370.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257674',4906422,'3057','472',82193.04,85699.22,3496.18,576869.70,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257674',4906423,'3058','472',113711.86,115524.73,1812.87,299123.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257674',4906424,'3059','472',31260.35,34571.24,3310.89,546296.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257674',4906425,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257674',4906426,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257674',4906427,'3062','472',122470.62,126065.65,3595.03,593179.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257674',4906428,'3063','472',29466.86,30783.36,1316.50,217222.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257674',4906429,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257675',4906430,'3056','472',62370.57,62700.00,329.43,54355.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257675',4906431,'3057','472',85699.22,87728.37,2029.15,334809.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257675',4906432,'3058','472',115524.73,121214.62,5689.89,938831.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257675',4906433,'3059','472',34571.24,34687.40,116.16,19166.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257675',4906434,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257675',4906435,'3061','472',45175.20,45175.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257675',4906436,'3062','472',126065.65,132014.54,5948.89,981566.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257675',4906437,'3063','472',30783.36,30840.83,57.47,9482.55,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257675',4906438,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257676',4906439,'3056','472',62700.00,62700.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257676',4906440,'3057','472',87728.37,91259.99,3531.62,582717.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257676',4906441,'3058','472',121214.62,124471.79,3257.17,537433.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257676',4906442,'3059','472',34687.40,35094.36,406.96,67148.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257676',4906443,'3060','472',11422.36,11422.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257676',4906444,'3061','472',45175.20,45333.63,158.43,26140.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257676',4906445,'3062','472',132014.54,136020.65,4006.11,661008.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257676',4906446,'3063','472',30840.83,31048.37,207.54,34244.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257676',4906447,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257677',4906448,'3056','472',62700.00,62700.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257677',4906449,'3057','472',91259.99,91259.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257677',4906450,'3058','472',124471.79,128829.67,4357.88,719050.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257677',4906451,'3059','472',35094.36,35336.66,242.30,39979.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257677',4906452,'3060','472',11422.36,11422.50,0.14,23.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257677',4906453,'3061','472',45333.63,45333.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257677',4906454,'3062','472',136020.65,140665.77,4645.12,766444.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257677',4906455,'3063','472',31048.37,31880.53,832.16,137306.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257677',4906456,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257678',4906457,'3056','472',62700.00,62700.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257678',4906458,'3057','472',91259.99,91259.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257678',4906459,'3058','472',128829.67,131512.46,2682.79,442660.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257678',4906460,'3059','472',35336.66,35594.70,258.04,42576.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257678',4906461,'3060','472',11422.50,11422.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257678',4906462,'3061','472',45333.63,45333.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257678',4906463,'3062','472',140665.77,143928.60,3262.83,538366.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257678',4906464,'3063','472',31880.53,32546.42,665.89,109871.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257678',4906465,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257679',4906466,'3056','472',62700.00,62700.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257679',4906467,'3057','472',91259.99,91259.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257679',4906468,'3058','472',131512.46,131780.40,267.94,44210.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257679',4906469,'3059','472',35594.70,35594.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257679',4906470,'3060','472',11422.50,11422.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257679',4906471,'3061','472',45333.63,45333.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257679',4906472,'3062','472',143928.60,146006.69,2078.09,342884.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257679',4906473,'3063','472',32546.42,32546.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257679',4906474,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257680',4906475,'3056','472',62700.00,62700.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257680',4906476,'3057','472',91259.99,91259.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257680',4906477,'3058','472',131780.40,132144.87,364.47,60137.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257680',4906478,'3059','472',35594.70,35594.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257680',4906479,'3060','472',11422.50,11422.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257680',4906480,'3061','472',45333.63,45333.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257680',4906481,'3062','472',146006.69,146213.37,206.68,34102.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257680',4906482,'3063','472',32546.42,34657.60,2111.18,348344.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257680',4906483,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257681',4906484,'3056','472',62700.00,62700.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257681',4906485,'3057','472',91259.99,92237.92,967.93,159708.45,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257681',4906486,'3058','472',132144.87,133264.54,1099.67,181445.55,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257681',4906487,'3059','472',35594.70,35594.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257681',4906488,'3060','472',11422.50,11422.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257681',4906489,'3061','472',45333.63,45333.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257681',4906490,'3062','472',146213.37,147851.89,1638.52,270355.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257681',4906491,'3063','472',34657.60,34657.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257681',4906492,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257682',4906493,'3056','472',62700.00,62700.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257682',4906494,'3057','472',92237.92,95569.03,3331.11,549633.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257682',4906495,'3058','472',133264.54,136778.92,3514.38,579872.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257682',4906496,'3059','472',35594.70,35693.80,99.10,16351.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257682',4906497,'3060','472',11422.50,11422.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257682',4906498,'3061','472',45333.63,45563.61,229.98,37946.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257682',4906499,'3062','472',147851.89,151799.95,3948.06,651429.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257682',4906500,'3063','472',34657.60,34657.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257682',4906501,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257683',4906502,'3056','472',62700.00,65282.32,2582.32,426082.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257683',4906503,'3057','472',95569.03,95569.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257683',4906504,'3058','472',136778.92,137911.93,1133.01,186946.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257683',4906505,'3059','472',35693.80,35693.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257683',4906506,'3060','472',11422.50,11422.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257683',4906507,'3061','472',45563.61,45563.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257683',4906508,'3062','472',151799.95,154731.55,2931.60,483714.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257683',4906509,'3063','472',34657.60,34657.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257683',4906510,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257684',4906511,'3056','472',65282.32,65282.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257684',4906512,'3057','472',95569.03,99000.06,3431.03,566119.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257684',4906513,'3058','472',137911.93,137911.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257684',4906514,'3059','472',35693.80,36406.17,712.37,117541.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257684',4906515,'3060','472',11422.50,11422.61,0.11,18.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257684',4906516,'3061','472',45563.61,45563.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257684',4906517,'3062','472',154731.55,158299.04,3567.49,588635.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257684',4906518,'3063','472',34657.60,34657.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257684',4906519,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257685',4906520,'3056','472',65282.32,65282.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257685',4906521,'3057','472',99000.06,101137.23,2137.17,352633.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257685',4906522,'3058','472',137911.93,138490.72,578.79,95500.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257685',4906523,'3059','472',36406.17,36406.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257685',4906524,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257685',4906525,'3061','472',45563.61,45563.71,0.10,16.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257685',4906526,'3062','472',158299.04,161134.18,2835.14,467798.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257685',4906527,'3063','472',34657.60,34657.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257685',4906528,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257686',4906529,'3056','472',65282.32,65282.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257686',4906530,'3057','472',101137.23,101137.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257686',4906531,'3058','472',138490.72,141593.25,3102.53,511917.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257686',4906532,'3059','472',36406.17,36406.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257686',4906533,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257686',4906534,'3061','472',45563.71,45563.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257686',4906535,'3062','472',161134.18,164073.11,2938.93,484923.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257686',4906536,'3063','472',34657.60,34697.60,40.00,6600.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257686',4906537,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257687',4906538,'3056','472',65282.32,65282.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257687',4906539,'3057','472',101137.23,101137.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257687',4906540,'3058','472',141593.25,141593.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257687',4906541,'3059','472',36406.17,36406.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257687',4906542,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257687',4906543,'3061','472',45563.71,45563.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257687',4906544,'3062','472',164073.11,166026.25,1953.14,322268.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257687',4906545,'3063','472',34697.60,34697.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257687',4906546,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257688',4906547,'3056','472',65282.32,65282.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257688',4906548,'3057','472',101137.23,101137.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257688',4906549,'3058','472',141593.25,142107.54,514.29,84857.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257688',4906550,'3059','472',36406.17,36406.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257688',4906551,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257688',4906552,'3061','472',45563.71,45563.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257688',4906553,'3062','472',166026.25,169386.35,3360.10,554416.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257688',4906554,'3063','472',34697.60,35283.57,585.97,96685.05,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257688',4906555,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257689',4906556,'3056','472',65282.32,65282.44,0.12,19.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257689',4906557,'3057','472',101137.23,103550.04,2412.81,398113.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257689',4906558,'3058','472',142107.54,144978.32,2870.78,473678.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257689',4906559,'3059','472',36406.17,36472.19,66.02,10893.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257689',4906560,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257689',4906561,'3061','472',45563.71,45563.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257689',4906562,'3062','472',169386.35,171708.17,2321.82,383100.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257689',4906563,'3063','472',35283.57,35283.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257689',4906564,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257690',4906565,'3056','472',65282.44,65282.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257690',4906566,'3057','472',103550.04,106743.03,3192.99,526843.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257690',4906567,'3058','472',144978.32,148297.17,3318.85,547610.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257690',4906568,'3059','472',36472.19,37118.47,646.28,106636.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257690',4906569,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257690',4906570,'3061','472',45563.71,45897.82,334.11,55128.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257690',4906571,'3062','472',171708.17,176387.01,4678.84,772008.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257690',4906572,'3063','472',35283.57,35368.42,84.85,14000.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257690',4906573,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257691',4906574,'3056','472',65282.44,68916.70,3634.26,599652.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257691',4906575,'3057','472',106743.03,106743.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257691',4906576,'3058','472',148297.17,151685.29,3388.12,559039.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257691',4906577,'3059','472',37118.47,38479.41,1360.94,224555.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257691',4906578,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257691',4906579,'3061','472',45897.82,45897.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257691',4906580,'3062','472',176387.01,181152.89,4765.88,786370.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257691',4906581,'3063','472',35368.42,36202.42,834.00,137610.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257691',4906582,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257692',4906583,'3056','472',68916.70,71457.33,2520.63,415903.95,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257692',4906584,'3057','472',106743.03,106743.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257692',4906585,'3058','472',151685.29,154016.47,2306.35,380547.75,0.00,0.00,24.83,0.00,0.00),('1','206','1030','257692',4906586,'3059','472',38479.41,38869.59,370.18,61079.70,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257692',4906587,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257692',4906588,'3061','472',45897.82,45897.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257692',4906589,'3062','472',181152.89,183917.82,2764.93,456213.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257692',4906590,'3063','472',36202.42,36853.29,650.87,107393.55,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257692',4906591,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257693',4906592,'3056','472',71457.33,71457.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257693',4906593,'3057','472',106743.03,108954.03,2211.00,364815.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257693',4906594,'3058','472',154016.47,154576.70,560.23,92437.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257693',4906595,'3059','472',38869.59,38869.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257693',4906596,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257693',4906597,'3061','472',45897.82,45897.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257693',4906598,'3062','472',183917.82,186148.43,2230.61,368050.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257693',4906599,'3063','472',36853.29,36853.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257693',4906600,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257694',4906601,'3056','472',71457.33,71457.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257694',4906602,'3057','472',108954.03,108954.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257694',4906603,'3058','472',154576.70,154776.24,199.54,32924.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257694',4906604,'3059','472',38869.59,38869.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257694',4906605,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257694',4906606,'3061','472',45897.82,45897.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257694',4906607,'3062','472',186148.43,188127.73,1979.30,326584.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257694',4906608,'3063','472',36853.29,36853.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257694',4906609,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257695',4906610,'3056','472',71457.33,71457.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257695',4906611,'3057','472',108954.03,108954.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257695',4906612,'3058','472',154776.24,154776.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257695',4906613,'3059','472',38869.59,38869.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257695',4906614,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257695',4906615,'3061','472',45897.82,45897.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257695',4906616,'3062','472',188127.73,191692.33,3564.60,588159.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257695',4906617,'3063','472',36853.29,36853.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257695',4906618,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257696',4906619,'3056','472',71457.33,71457.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257696',4906620,'3057','472',108954.03,112141.39,3165.24,522264.60,0.00,0.00,22.12,0.00,0.00),('1','206','1030','257696',4906621,'3058','472',154776.24,155578.77,782.53,129117.45,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257696',4906622,'3059','472',38869.59,38869.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257696',4906623,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257696',4906624,'3061','472',45897.82,45897.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257696',4906625,'3062','472',191692.33,197237.70,5525.37,911686.05,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257696',4906626,'3063','472',36853.29,36853.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257696',4906627,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257697',4906628,'3056','472',71457.33,71457.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257697',4906629,'3057','472',112141.39,116726.40,4585.01,756526.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257697',4906630,'3058','472',155578.77,157238.81,1660.04,273906.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257697',4906631,'3059','472',38869.59,38869.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257697',4906632,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257697',4906633,'3061','472',45897.82,45897.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257697',4906634,'3062','472',197237.70,201776.95,4539.25,748976.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257697',4906635,'3063','472',36853.29,36853.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257697',4906636,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257698',4906637,'3056','472',71457.33,71457.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257698',4906638,'3057','472',116726.40,120909.46,4183.06,690204.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257698',4906639,'3058','472',157238.81,161608.47,4369.66,720993.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257698',4906640,'3059','472',38869.59,39149.05,279.46,46110.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257698',4906641,'3060','472',11422.61,11422.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257698',4906642,'3061','472',45897.82,45897.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257698',4906643,'3062','472',201776.95,207656.15,5879.20,970068.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257698',4906644,'3063','472',36853.29,36853.48,0.19,31.35,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257698',4906645,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257699',4906646,'3056','472',71457.33,71457.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257699',4906647,'3057','472',120909.46,122066.44,1156.98,190901.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257699',4906648,'3058','472',161608.47,163003.21,1394.74,230132.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257699',4906649,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257699',4906650,'3060','472',11422.61,11451.70,29.09,4799.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257699',4906651,'3061','472',45897.82,46948.05,1050.23,173287.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257699',4906652,'3062','472',207656.15,209093.82,1437.67,237215.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257699',4906653,'3063','472',36853.48,36853.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257699',4906654,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257700',4906655,'3056','472',71457.33,71457.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257700',4906656,'3057','472',122066.44,122066.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257700',4906657,'3058','472',163003.21,163601.60,598.39,98734.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257700',4906658,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257700',4906659,'3060','472',11451.70,11451.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257700',4906660,'3061','472',46948.05,49405.54,2457.49,405485.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257700',4906661,'3062','472',209093.82,211221.46,2109.46,348060.90,0.00,0.00,18.18,0.00,0.00),('1','206','1030','257700',4906662,'3063','472',36853.48,36853.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257700',4906663,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257701',4906664,'3056','472',71457.33,71487.64,30.31,5001.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257701',4906665,'3057','472',122066.44,122066.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257701',4906666,'3058','472',163601.60,163601.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257701',4906667,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257701',4906668,'3060','472',11451.70,11481.70,30.00,4950.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257701',4906669,'3061','472',49405.54,51995.10,2589.56,427277.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257701',4906670,'3062','472',211221.46,211807.29,585.83,96661.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257701',4906671,'3063','472',36853.48,36863.47,9.99,1648.35,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257701',4906672,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257702',4906673,'3056','472',71487.64,71487.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257702',4906674,'3057','472',122066.44,122066.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257702',4906675,'3058','472',163601.60,163601.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257702',4906676,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257702',4906677,'3060','472',11481.70,11481.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257702',4906678,'3061','472',51995.10,54300.21,2305.11,380343.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257702',4906679,'3062','472',211807.29,211807.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257702',4906680,'3063','472',36863.47,36863.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257702',4906681,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257703',4906682,'3056','472',71487.64,71487.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257703',4906683,'3057','472',122066.44,125749.84,3683.40,607761.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257703',4906684,'3058','472',163601.60,167065.16,3463.56,571487.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257703',4906685,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257703',4906686,'3060','472',11481.70,11481.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257703',4906687,'3061','472',54300.21,58374.20,4073.99,672208.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257703',4906688,'3062','472',211807.29,212031.68,224.39,37024.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257703',4906689,'3063','472',36863.47,36863.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257703',4906690,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257704',4906691,'3056','472',71487.64,71487.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257704',4906692,'3057','472',125749.84,128433.01,2663.17,439423.05,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257704',4906693,'3058','472',167065.16,169362.88,2277.72,375823.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257704',4906694,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257704',4906695,'3060','472',11481.70,11481.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257704',4906696,'3061','472',58374.20,58374.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257704',4906697,'3062','472',212031.68,214735.20,2683.52,442780.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257704',4906698,'3063','472',36863.47,36863.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257704',4906699,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257705',4906700,'3056','472',71487.64,71487.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257705',4906701,'3057','472',128433.01,128433.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257705',4906702,'3058','472',169362.88,170802.04,1439.16,237461.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257705',4906703,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257705',4906704,'3060','472',11481.70,11481.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257705',4906705,'3061','472',58374.20,58374.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257705',4906706,'3062','472',214735.20,216531.48,1796.28,296386.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257705',4906707,'3063','472',36863.47,36863.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257705',4906708,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257706',4906709,'3056','472',71487.64,71487.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257706',4906710,'3057','472',128433.01,130535.26,2102.25,346871.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257706',4906711,'3058','472',170802.04,172673.34,1871.30,308764.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257706',4906712,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257706',4906713,'3060','472',11481.70,11481.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257706',4906714,'3061','472',58374.20,58374.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257706',4906715,'3062','472',216531.48,218690.80,2159.32,356287.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257706',4906716,'3063','472',36863.47,36863.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257706',4906717,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257707',4906718,'3056','472',71487.64,71487.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257707',4906719,'3057','472',130535.26,132865.15,2329.89,384431.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257707',4906720,'3058','472',172673.34,175166.49,2493.15,411369.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257707',4906721,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257707',4906722,'3060','472',11481.70,11481.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257707',4906723,'3061','472',58374.20,58374.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257707',4906724,'3062','472',218690.80,221907.55,3216.75,530763.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257707',4906725,'3063','472',36863.47,36863.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257707',4906726,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257708',4906727,'3056','472',71487.64,71487.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257708',4906728,'3057','472',132865.15,135645.01,2779.86,458676.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257708',4906729,'3058','472',175166.49,178440.50,3274.01,540211.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257708',4906730,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257708',4906731,'3060','472',11481.70,11481.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257708',4906732,'3061','472',58374.20,58374.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257708',4906733,'3062','472',221907.55,225086.58,3179.03,524539.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257708',4906734,'3063','472',36863.47,36863.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257708',4906735,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257709',4906736,'3056','472',71487.64,71487.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257709',4906737,'3057','472',135645.01,138518.33,2873.32,474097.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257709',4906738,'3058','472',178440.50,181053.20,2612.70,431095.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257709',4906739,'3059','472',39149.05,39149.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257709',4906740,'3060','472',11481.70,11481.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257709',4906741,'3061','472',58374.20,58374.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257709',4906742,'3062','472',225086.58,228188.58,3102.00,511830.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257709',4906743,'3063','472',36863.47,36863.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257709',4906744,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257710',4906745,'3056','472',71487.64,71519.15,11.51,1899.15,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257710',4906746,'3057','472',138518.33,142564.95,4026.62,664392.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257710',4906747,'3058','472',181053.20,183706.11,2632.91,434430.15,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257710',4906748,'3059','472',39149.05,39328.68,159.63,26338.95,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257710',4906749,'3060','472',11481.70,11906.90,405.20,66858.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257710',4906750,'3061','472',58374.20,60158.01,1763.81,291028.65,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257710',4906751,'3062','472',228188.58,232243.36,4034.78,665738.70,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257710',4906752,'3063','472',36863.47,36998.60,115.13,18996.45,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257710',4906753,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257711',4906754,'3056','472',71519.15,72533.65,1014.50,167392.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257711',4906755,'3057','472',142564.95,145329.61,2764.66,456168.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257711',4906756,'3058','472',183706.11,186910.89,3204.78,528788.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257711',4906757,'3059','472',39328.68,39662.49,333.81,55078.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257711',4906758,'3060','472',11906.90,11906.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257711',4906759,'3061','472',60158.01,60158.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257711',4906760,'3062','472',232243.36,235915.51,3672.15,605904.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257711',4906761,'3063','472',36998.60,37590.88,592.28,97726.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257711',4906762,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257712',4906763,'3056','472',72533.65,72533.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257712',4906764,'3057','472',145329.61,149531.52,4201.91,693315.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257712',4906765,'3058','472',186910.89,190641.56,3730.67,615560.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257712',4906766,'3059','472',39662.49,39918.00,255.51,42159.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257712',4906767,'3060','472',11906.90,11906.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257712',4906768,'3061','472',60158.01,60158.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257712',4906769,'3062','472',235915.51,240233.39,4317.88,712450.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257712',4906770,'3063','472',37590.88,37590.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257712',4906771,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257713',4906772,'3056','472',72533.65,72533.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257713',4906773,'3057','472',149531.52,153537.26,4005.74,660947.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257713',4906774,'3058','472',190641.56,195118.02,4476.46,738615.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257713',4906775,'3059','472',39918.00,40047.53,129.53,21372.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257713',4906776,'3060','472',11906.90,11906.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257713',4906777,'3061','472',60158.01,60158.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257713',4906778,'3062','472',240233.39,244940.75,4707.36,776714.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257713',4906779,'3063','472',37590.88,37741.14,150.26,24792.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257713',4906780,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257714',4906781,'3056','472',72533.65,72533.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257714',4906782,'3057','472',153537.26,156664.92,3127.66,516063.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257714',4906783,'3058','472',195118.02,197718.77,2600.75,429123.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257714',4906784,'3059','472',40047.53,40071.77,24.24,3999.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257714',4906785,'3060','472',11906.90,11906.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257714',4906786,'3061','472',60158.01,60209.57,51.56,8507.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257714',4906787,'3062','472',244940.75,247830.29,2889.54,476774.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257714',4906788,'3063','472',37741.14,37741.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257714',4906789,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257715',4906790,'3056','472',72533.65,72533.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257715',4906791,'3057','472',156664.92,159308.10,2643.18,436124.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257715',4906792,'3058','472',197718.77,199871.52,2152.75,355203.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257715',4906793,'3059','472',40071.77,40071.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257715',4906794,'3060','472',11906.90,11906.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257715',4906795,'3061','472',60209.57,60209.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257715',4906796,'3062','472',247830.29,250161.52,2331.23,384652.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257715',4906797,'3063','472',37741.14,37741.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257715',4906798,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257716',4906799,'3056','472',72533.65,72553.65,20.00,3300.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257716',4906800,'3057','472',159308.10,161191.20,1883.10,310711.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257716',4906801,'3058','472',199871.52,201963.98,2092.46,345255.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257716',4906802,'3059','472',40071.77,40091.77,20.00,3300.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257716',4906803,'3060','472',11906.90,12132.68,225.78,37253.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257716',4906804,'3061','472',60209.57,60462.45,252.88,41725.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257716',4906805,'3062','472',250161.52,251725.71,1564.19,258091.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257716',4906806,'3063','472',37741.14,37761.14,20.00,3300.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257716',4906807,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257717',4906808,'3056','472',72553.65,72553.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257717',4906809,'3057','472',161191.20,162981.70,1790.50,295432.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257717',4906810,'3058','472',201963.98,203529.87,1545.32,254977.80,0.00,0.00,20.57,0.00,0.00),('1','206','1030','257717',4906811,'3059','472',40091.77,40106.83,15.06,2484.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257717',4906812,'3060','472',12132.68,12220.30,67.05,11063.25,0.00,0.00,20.57,0.00,0.00),('1','206','1030','257717',4906813,'3061','472',60462.45,61774.53,1291.51,213099.15,0.00,0.00,20.57,0.00,0.00),('1','206','1030','257717',4906814,'3062','472',251725.71,253036.52,1290.24,212889.60,0.00,0.00,20.57,0.00,0.00),('1','206','1030','257717',4906815,'3063','472',37761.14,37821.90,41.87,6908.55,0.00,0.00,18.89,0.00,0.00),('1','206','1031','257717',4906816,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257718',4906817,'3056','472',72553.65,72553.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257718',4906818,'3057','472',162981.70,165456.99,2475.29,408422.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257718',4906819,'3058','472',203529.87,205047.28,1517.41,250372.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257718',4906820,'3059','472',40106.83,40106.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257718',4906821,'3060','472',12220.30,12220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257718',4906822,'3061','472',61774.53,61774.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257718',4906823,'3062','472',253036.52,255031.32,1994.80,329142.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257718',4906824,'3063','472',37821.90,37821.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257718',4906825,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257719',4906826,'3056','472',72553.65,72553.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257719',4906827,'3057','472',165456.99,167556.23,2099.24,346374.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257719',4906828,'3058','472',205047.28,207172.05,2124.77,350587.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257719',4906829,'3059','472',40106.83,40106.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257719',4906830,'3060','472',12220.30,12220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257719',4906831,'3061','472',61774.53,61839.37,64.84,10698.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257719',4906832,'3062','472',255031.32,256971.22,1939.90,320083.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257719',4906833,'3063','472',37821.90,37821.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257719',4906834,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257720',4906835,'3056','472',72553.65,72553.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257720',4906836,'3057','472',167556.23,170183.13,2626.90,433438.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257720',4906837,'3058','472',207172.05,209432.06,2260.01,372901.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257720',4906838,'3059','472',40106.83,40106.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257720',4906839,'3060','472',12220.30,12220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257720',4906840,'3061','472',61839.37,63988.18,2148.81,354553.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257720',4906841,'3062','472',256971.22,258653.82,1682.60,277629.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257720',4906842,'3063','472',37821.90,37821.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257720',4906843,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257721',4906844,'3056','472',72553.65,72553.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257721',4906845,'3057','472',170183.13,172722.64,2539.51,419019.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257721',4906846,'3058','472',209432.06,211999.50,2567.44,423627.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257721',4906847,'3059','472',40106.83,40106.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257721',4906848,'3060','472',12220.30,12220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257721',4906849,'3061','472',63988.18,64331.77,343.59,56692.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257721',4906850,'3062','472',258653.82,261243.42,2589.60,427284.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257721',4906851,'3063','472',37821.90,37821.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257721',4906852,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257722',4906853,'3056','472',72553.65,72553.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257722',4906854,'3057','472',172722.64,175374.61,2651.97,437575.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257722',4906855,'3058','472',211999.50,214146.70,2147.20,354288.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257722',4906856,'3059','472',40106.83,40559.59,452.76,74705.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257722',4906857,'3060','472',12220.30,12220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257722',4906858,'3061','472',64331.77,66758.58,2426.81,400423.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257722',4906859,'3062','472',261243.42,263280.36,2036.94,336095.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257722',4906860,'3063','472',37821.90,37821.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257722',4906861,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257723',4906862,'3056','472',72553.65,72553.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257723',4906863,'3057','472',175374.61,178558.06,3183.45,525269.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257723',4906864,'3058','472',214146.70,216989.11,2842.41,468997.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257723',4906865,'3059','472',40559.59,40741.98,182.39,30094.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257723',4906866,'3060','472',12220.30,12220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257723',4906867,'3061','472',66758.58,66758.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257723',4906868,'3062','472',263280.36,266449.34,3168.98,522881.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257723',4906869,'3063','472',37821.90,37821.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257723',4906870,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257724',4906871,'3056','472',72553.65,72553.78,0.13,21.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257724',4906872,'3057','472',178558.06,181315.33,2757.27,454949.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257724',4906873,'3058','472',216989.11,219653.92,2664.81,439693.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257724',4906874,'3059','472',40741.98,40741.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257724',4906875,'3060','472',12220.30,12220.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257724',4906876,'3061','472',66758.58,69097.76,2339.18,385964.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257724',4906877,'3062','472',266449.34,268913.41,2464.07,406571.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257724',4906878,'3063','472',37821.90,37821.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257724',4906879,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257725',4906880,'3056','472',72553.78,73236.66,682.88,112675.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257725',4906881,'3057','472',181315.33,182536.58,1221.25,201506.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257725',4906882,'3058','472',219653.92,221278.45,1624.53,268047.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257725',4906883,'3059','472',40741.98,40741.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257725',4906884,'3060','472',12220.30,12428.19,207.89,34301.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257725',4906885,'3061','472',69097.76,69097.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257725',4906886,'3062','472',268913.41,270673.30,1759.89,290381.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257725',4906887,'3063','472',37821.90,37821.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257725',4906888,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257726',4906889,'3056','472',73236.66,73342.53,105.87,17468.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257726',4906890,'3057','472',182536.58,184354.75,1818.17,299998.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257726',4906891,'3058','472',221278.45,222917.87,1639.42,270504.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257726',4906892,'3059','472',40741.98,40741.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257726',4906893,'3060','472',12428.19,12524.38,96.19,15871.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257726',4906894,'3061','472',69097.76,71237.25,2139.49,353015.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257726',4906895,'3062','472',270673.30,271885.41,1212.11,199998.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257726',4906896,'3063','472',37821.90,37821.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257726',4906897,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257727',4906898,'3056','472',73342.53,73369.80,0.00,0.00,0.00,0.00,27.27,0.00,0.00),('1','206','1030','257727',4906899,'3057','472',184354.75,186661.76,2287.01,377356.65,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257727',4906900,'3058','472',222917.87,225179.83,2241.96,369923.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257727',4906901,'3059','472',40741.98,40788.05,26.07,4301.55,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257727',4906902,'3060','472',12524.38,12548.62,0.00,0.00,0.00,0.00,24.24,0.00,0.00),('1','206','1030','257727',4906903,'3061','472',71237.25,71291.71,34.46,5685.90,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257727',4906904,'3062','472',271885.41,274402.00,2496.59,411937.35,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257727',4906905,'3063','472',37821.90,37981.76,139.86,23076.90,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257727',4906906,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257728',4906907,'3056','472',73369.80,73369.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257728',4906908,'3057','472',186661.76,187266.08,604.32,99712.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257728',4906909,'3058','472',225179.83,225592.32,412.49,68060.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257728',4906910,'3059','472',40788.05,40788.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257728',4906911,'3060','472',12548.62,12548.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257728',4906912,'3061','472',71291.71,76286.14,4994.43,824080.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257728',4906913,'3062','472',274402.00,274807.24,405.24,66864.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257728',4906914,'3063','472',37981.76,37981.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257728',4906915,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257729',4906916,'3056','472',73369.80,73369.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257729',4906917,'3057','472',187266.08,187266.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257729',4906918,'3058','472',225592.32,226035.02,442.70,73045.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257729',4906919,'3059','472',40788.05,40788.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257729',4906920,'3060','472',12548.62,12548.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257729',4906921,'3061','472',76286.14,78585.51,2299.37,379396.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257729',4906922,'3062','472',274807.24,276179.22,1371.98,226376.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257729',4906923,'3063','472',37981.76,37981.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257729',4906924,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257730',4906925,'3056','472',73369.80,73835.76,445.96,73583.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257730',4906926,'3057','472',187266.08,188163.76,877.68,144817.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257730',4906927,'3058','472',226035.02,227290.18,1235.16,203801.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257730',4906928,'3059','472',40788.05,40910.67,102.62,16932.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257730',4906929,'3060','472',12548.62,13115.52,546.90,90238.50,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257730',4906930,'3061','472',78585.51,79747.60,1142.09,188444.85,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257730',4906931,'3062','472',276179.22,276199.22,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257730',4906932,'3063','472',37981.76,38226.37,224.61,37060.65,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257730',4906933,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257731',4906934,'3056','472',73835.76,73835.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257731',4906935,'3057','472',188163.76,190357.74,2193.98,362006.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257731',4906936,'3058','472',227290.18,229100.98,1800.80,297132.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257731',4906937,'3059','472',40910.67,40910.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257731',4906938,'3060','472',13115.52,13322.14,206.62,34092.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257731',4906939,'3061','472',79747.60,81447.99,1700.39,280564.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257731',4906940,'3062','472',276199.22,276199.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257731',4906941,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257731',4906942,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257732',4906943,'3056','472',73835.76,73835.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257732',4906944,'3057','472',190357.74,192679.91,2322.17,383158.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257732',4906945,'3058','472',229100.98,230956.46,1855.48,306154.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257732',4906946,'3059','472',40910.67,40910.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257732',4906947,'3060','472',13322.14,13322.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257732',4906948,'3061','472',81447.99,83780.18,2332.19,384811.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257732',4906949,'3062','472',276199.22,276199.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257732',4906950,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257732',4906951,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257733',4906952,'3056','472',73835.76,73835.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257733',4906953,'3057','472',192679.91,194889.04,2209.13,364506.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257733',4906954,'3058','472',230956.46,233123.79,2167.33,357609.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257733',4906955,'3059','472',40910.67,40910.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257733',4906956,'3060','472',13322.14,13322.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257733',4906957,'3061','472',83780.18,88029.60,4249.42,701154.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257733',4906958,'3062','472',276199.22,278525.28,2326.06,383799.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257733',4906959,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257733',4906960,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257734',4906961,'3056','472',73835.76,73835.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257734',4906962,'3057','472',194889.04,197581.53,2692.49,444260.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257734',4906963,'3058','472',233123.79,235568.32,2444.53,403347.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257734',4906964,'3059','472',40910.67,41109.99,199.32,32887.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257734',4906965,'3060','472',13322.14,13452.11,129.97,21445.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257734',4906966,'3061','472',88029.60,90834.08,2804.48,462739.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257734',4906967,'3062','472',278525.28,278525.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257734',4906968,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257734',4906969,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257735',4906970,'3056','472',73835.76,75273.23,1437.47,237182.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257735',4906971,'3057','472',197581.53,200003.91,2422.38,399692.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257735',4906972,'3058','472',235568.32,239269.97,3701.65,610772.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257735',4906973,'3059','472',41109.99,41109.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257735',4906974,'3060','472',13452.11,13452.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257735',4906975,'3061','472',90834.08,90952.04,117.96,19463.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257735',4906976,'3062','472',278525.28,282415.52,3890.24,641889.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257735',4906977,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257735',4906978,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257736',4906979,'3056','472',75273.23,75854.20,560.97,92560.05,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257736',4906980,'3057','472',200003.91,201798.45,1774.54,292799.10,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257736',4906981,'3058','472',239269.97,241410.84,2120.87,349943.55,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257736',4906982,'3059','472',41109.99,41283.59,153.60,25344.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257736',4906983,'3060','472',13452.11,13525.16,53.05,8753.25,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257736',4906984,'3061','472',90952.04,93182.81,2210.77,364777.05,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257736',4906985,'3062','472',282415.52,282415.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257736',4906986,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257736',4906987,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257737',4906988,'3056','472',75854.20,75854.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257737',4906989,'3057','472',201798.45,203907.03,2108.58,347915.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257737',4906990,'3058','472',241410.84,243170.33,1759.49,290315.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257737',4906991,'3059','472',41283.59,41283.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257737',4906992,'3060','472',13525.16,13525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257737',4906993,'3061','472',93182.81,93182.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257737',4906994,'3062','472',282415.52,284250.80,1835.28,302821.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257737',4906995,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257737',4906996,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257738',4906997,'3056','472',75854.20,75854.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257738',4906998,'3057','472',203907.03,203907.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257738',4906999,'3058','472',243170.33,244174.78,1004.45,165734.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257738',4907000,'3059','472',41283.59,41450.40,166.81,27523.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257738',4907001,'3060','472',13525.16,13525.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257738',4907002,'3061','472',93182.81,97436.36,4253.55,701835.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257738',4907003,'3062','472',284250.80,284291.94,41.14,6788.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257738',4907004,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257738',4907005,'3064','473',132988.27,132988.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257739',4907006,'3056','472',75854.20,75854.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257739',4907007,'3057','472',203907.03,206576.71,2669.68,440497.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257739',4907008,'3058','472',244174.78,246346.39,2171.61,358315.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257739',4907009,'3059','472',41450.40,41492.72,42.32,6982.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257739',4907010,'3060','472',13525.16,13737.70,212.54,35069.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257739',4907011,'3061','472',97436.36,99870.04,2433.68,401557.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257739',4907012,'3062','472',284291.94,288258.65,3966.71,654507.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257739',4907013,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257739',4907014,'3064','473',132988.27,135491.43,2483.16,1638885.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257740',4907015,'3056','472',75854.20,75854.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257740',4907016,'3057','472',206576.71,209172.90,2596.19,428371.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257740',4907017,'3058','472',246346.39,248517.89,2171.50,358297.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257740',4907018,'3059','472',41492.72,41492.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257740',4907019,'3060','472',13737.70,13737.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257740',4907020,'3061','472',99870.04,99870.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257740',4907021,'3062','472',288258.65,289751.38,1492.73,246300.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257740',4907022,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257740',4907023,'3064','473',135491.43,135491.73,0.30,198.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257741',4907024,'3056','472',75854.20,75854.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257741',4907025,'3057','472',209172.90,209172.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257741',4907026,'3058','472',248517.89,248517.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257741',4907027,'3059','472',41492.72,41492.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257741',4907028,'3060','472',13737.70,13737.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257741',4907029,'3061','472',99870.04,99870.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257741',4907030,'3062','472',289751.38,289751.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257741',4907031,'3063','472',38226.37,38226.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257741',4907032,'3064','473',135491.73,135491.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257742',4907033,'3056','472',75854.20,75900.31,46.11,7608.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257742',4907034,'3057','472',209172.90,212033.38,2860.48,471979.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257742',4907035,'3058','472',248517.89,251316.22,2798.33,461724.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257742',4907036,'3059','472',41492.72,41492.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257742',4907037,'3060','472',13737.70,13737.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257742',4907038,'3061','472',99870.04,99870.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257742',4907039,'3062','472',289751.38,292094.67,2343.29,386642.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257742',4907040,'3063','472',38226.37,39065.30,838.93,138423.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257742',4907041,'3064','473',135491.73,135625.67,133.94,88400.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257743',4907042,'3056','472',75900.31,76085.33,163.00,26895.00,0.00,0.00,22.02,0.00,0.00),('1','206','1030','257743',4907043,'3057','472',212033.38,212073.86,17.46,2880.90,0.00,0.00,23.02,0.00,0.00),('1','206','1030','257743',4907044,'3058','472',251316.22,252075.04,736.30,121489.50,0.00,0.00,22.52,0.00,0.00),('1','206','1030','257743',4907045,'3059','472',41492.72,41657.17,141.95,23421.75,0.00,0.00,22.50,0.00,0.00),('1','206','1030','257743',4907046,'3060','472',13737.70,14030.86,270.00,44550.00,0.00,0.00,23.16,0.00,0.00),('1','206','1030','257743',4907047,'3061','472',99870.04,101962.05,2070.01,341551.65,0.00,0.00,22.00,0.00,0.00),('1','206','1030','257743',4907048,'3062','472',292094.67,293643.48,1526.30,251839.50,0.00,0.00,22.51,0.00,0.00),('1','206','1030','257743',4907049,'3063','472',39065.30,39321.57,234.00,38610.00,0.00,0.00,22.27,0.00,0.00),('1','206','1031','257743',4907050,'3064','473',135625.67,137558.42,1912.75,1262415.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257744',4907051,'3056','472',76085.33,76085.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257744',4907052,'3057','472',212073.86,212073.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257744',4907053,'3058','472',252075.04,252133.63,58.59,9667.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257744',4907054,'3059','472',41657.17,41657.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257744',4907055,'3060','472',14030.86,14432.84,401.98,66326.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257744',4907056,'3061','472',101962.05,103485.56,1523.51,251379.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257744',4907057,'3062','472',293643.48,293772.77,129.29,21332.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257744',4907058,'3063','472',39321.57,39481.12,159.55,26325.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257744',4907059,'3064','473',137558.42,142373.55,4795.13,3164785.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257745',4907060,'3056','472',76085.33,76085.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257745',4907061,'3057','472',212073.86,212073.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257745',4907062,'3058','472',252133.63,252133.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257745',4907063,'3059','472',41657.17,41657.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257745',4907064,'3060','472',14432.84,14432.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257745',4907065,'3061','472',103485.56,103485.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257745',4907066,'3062','472',293772.77,293772.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257745',4907067,'3063','472',39481.12,39481.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257745',4907068,'3064','473',142373.55,143657.80,1264.25,834405.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257746',4907069,'3056','472',76085.33,76388.97,283.64,46800.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257746',4907070,'3057','472',212073.86,212619.72,525.86,86766.90,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257746',4907071,'3058','472',252133.63,252608.43,454.80,75042.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257746',4907072,'3059','472',41657.17,41962.60,285.43,47095.95,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257746',4907073,'3060','472',14432.84,14499.09,46.25,7631.25,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257746',4907074,'3061','472',103485.56,103604.25,98.69,16283.85,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257746',4907075,'3062','472',293772.77,294190.27,397.50,65587.50,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257746',4907076,'3063','472',39481.12,39698.06,196.94,32495.10,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257746',4907077,'3064','473',143657.80,145877.39,2199.59,1451729.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257747',4907078,'3056','472',76388.97,76388.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257747',4907079,'3057','472',212619.72,215212.53,2592.81,427813.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257747',4907080,'3058','472',252608.43,254674.71,2066.28,340936.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257747',4907081,'3059','472',41962.60,41962.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257747',4907082,'3060','472',14499.09,14499.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257747',4907083,'3061','472',103604.25,103604.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257747',4907084,'3062','472',294190.27,296869.74,2679.47,442112.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257747',4907085,'3063','472',39698.06,39698.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257747',4907086,'3064','473',145877.39,146016.03,138.64,91502.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257748',4907087,'3056','472',76388.97,76388.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257748',4907088,'3057','472',215212.53,215212.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257748',4907089,'3058','472',254674.71,256694.82,2020.11,333318.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257748',4907090,'3059','472',41962.60,41962.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257748',4907091,'3060','472',14499.09,14499.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257748',4907092,'3061','472',103604.25,103604.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257748',4907093,'3062','472',296869.74,298860.52,1990.78,328478.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257748',4907094,'3063','472',39698.06,39892.43,194.37,32071.05,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257748',4907095,'3064','473',146016.03,146242.58,226.55,149523.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257749',4907096,'3056','472',76388.97,76388.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257749',4907097,'3057','472',215212.53,215761.34,548.81,90553.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257749',4907098,'3058','472',256694.82,257147.91,453.09,74759.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257749',4907099,'3059','472',41962.60,41962.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257749',4907100,'3060','472',14499.09,14499.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257749',4907101,'3061','472',103604.25,103604.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257749',4907102,'3062','472',298860.52,299524.37,663.85,109535.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257749',4907103,'3063','472',39892.43,39892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257749',4907104,'3064','473',146242.58,146242.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257750',4907105,'3056','472',76388.97,76388.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257750',4907106,'3057','472',215761.34,216406.54,645.20,106458.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257750',4907107,'3058','472',257147.91,257690.48,542.57,89524.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257750',4907108,'3059','472',41962.60,44622.57,2659.97,438895.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257750',4907109,'3060','472',14499.09,14499.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257750',4907110,'3061','472',103604.25,103604.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257750',4907111,'3062','472',299524.37,302400.02,2875.65,474482.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257750',4907112,'3063','472',39892.43,39892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257750',4907113,'3064','473',146242.58,146242.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257751',4907114,'3056','472',76388.97,76388.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257751',4907115,'3057','472',216406.54,218219.75,1813.21,299179.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257751',4907116,'3058','472',257690.48,257690.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257751',4907117,'3059','472',44622.57,46094.42,1471.85,242855.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257751',4907118,'3060','472',14499.09,14499.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257751',4907119,'3061','472',103604.25,103604.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257751',4907120,'3062','472',302400.02,303840.46,1440.44,237672.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257751',4907121,'3063','472',39892.43,39892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257751',4907122,'3064','473',146242.58,148358.56,1895.98,1251346.80,0.00,0.00,220.00,0.00,0.00),('1','206','1030','257752',4907123,'3056','472',76388.97,76388.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257752',4907124,'3057','472',218219.75,218511.86,292.11,48198.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257752',4907125,'3058','472',257690.48,257831.93,141.45,23339.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257752',4907126,'3059','472',46094.42,47345.70,1251.28,206461.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257752',4907127,'3060','472',14499.09,14499.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257752',4907128,'3061','472',103604.25,103604.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257752',4907129,'3062','472',303840.46,305123.02,1282.56,211622.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257752',4907130,'3063','472',39892.43,39892.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257752',4907131,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257753',4907132,'3056','472',76388.97,78139.60,1730.63,285553.95,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257753',4907133,'3057','472',218511.86,218511.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257753',4907134,'3058','472',257831.93,258218.14,366.21,60424.65,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257753',4907135,'3059','472',47345.70,49942.35,2576.65,425147.25,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257753',4907136,'3060','472',14499.09,14499.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257753',4907137,'3061','472',103604.25,103604.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257753',4907138,'3062','472',305123.02,307771.51,2628.49,433700.85,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257753',4907139,'3063','472',39892.43,40384.69,472.26,77922.90,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257753',4907140,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257754',4907141,'3056','472',78139.60,78650.51,510.91,84300.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257754',4907142,'3057','472',218511.86,218657.32,145.46,24000.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257754',4907143,'3058','472',258218.14,260201.87,1983.73,327315.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257754',4907144,'3059','472',49942.35,50663.53,721.18,118994.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257754',4907145,'3060','472',14499.09,14499.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257754',4907146,'3061','472',103604.25,103604.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257754',4907147,'3062','472',307771.51,310911.58,3140.07,518111.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257754',4907148,'3063','472',40384.69,41015.98,631.29,104162.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257754',4907149,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257755',4907150,'3056','472',78650.51,78711.12,40.61,6700.65,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257755',4907151,'3057','472',218657.32,221278.04,2600.72,429118.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257755',4907152,'3058','472',260201.87,261937.48,1715.61,283075.65,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257755',4907153,'3059','472',50663.53,50797.23,113.70,18760.50,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257755',4907154,'3060','472',14499.09,14559.70,40.61,6700.65,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257755',4907155,'3061','472',103604.25,103643.00,18.75,3094.41,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257755',4907156,'3062','472',310911.58,319392.20,8460.62,1396002.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257755',4907157,'3063','472',41015.98,41059.85,23.87,3938.55,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257755',4907158,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257756',4907159,'3056','472',78711.12,78711.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257756',4907160,'3057','472',221278.04,222827.33,1549.29,255632.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257756',4907161,'3058','472',261937.48,263379.40,1441.92,237916.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257756',4907162,'3059','472',50797.23,51266.53,469.30,77434.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257756',4907163,'3060','472',14559.70,14559.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257756',4907164,'3061','472',103643.00,103643.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257756',4907165,'3062','472',319392.20,321914.54,2522.34,416186.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257756',4907166,'3063','472',41059.85,41059.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257756',4907167,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257757',4907168,'3056','472',78711.12,78711.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257757',4907169,'3057','472',222827.33,222827.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257757',4907170,'3058','472',263379.40,263487.59,98.19,16201.35,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257757',4907171,'3059','472',51266.53,52405.20,1128.67,186230.55,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257757',4907172,'3060','472',14559.70,14795.83,216.13,35661.45,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257757',4907173,'3061','472',103643.00,107509.25,3846.25,634631.25,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257757',4907174,'3062','472',321914.54,321914.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257757',4907175,'3063','472',41059.85,41059.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257757',4907176,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257758',4907177,'3056','472',78711.12,78711.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257758',4907178,'3057','472',222827.33,222827.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257758',4907179,'3058','472',263487.59,266442.52,2935.54,484364.10,0.00,0.00,19.39,0.00,0.00),('1','206','1030','257758',4907180,'3059','472',52405.20,52405.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257758',4907181,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257758',4907182,'3061','472',107509.25,110512.62,2983.37,492256.05,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257758',4907183,'3062','472',321914.54,326591.51,4676.97,771700.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257758',4907184,'3063','472',41059.85,41059.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257758',4907185,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257759',4907186,'3056','472',78711.12,78711.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257759',4907187,'3057','472',222827.33,222827.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257759',4907188,'3058','472',266442.52,269065.83,2623.31,432846.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257759',4907189,'3059','472',52405.20,52405.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257759',4907190,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257759',4907191,'3061','472',110512.62,110678.36,165.74,27347.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257759',4907192,'3062','472',326591.51,328965.27,2373.76,391670.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257759',4907193,'3063','472',41059.85,41059.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257759',4907194,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257760',4907195,'3056','472',78711.12,78711.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257760',4907196,'3057','472',222827.33,225067.15,2239.82,369570.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257760',4907197,'3058','472',269065.83,271051.22,1985.39,327589.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257760',4907198,'3059','472',52405.20,52405.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257760',4907199,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257760',4907200,'3061','472',110678.36,110678.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257760',4907201,'3062','472',328965.27,330991.05,2025.78,334253.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257760',4907202,'3063','472',41059.85,41059.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257760',4907203,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257761',4907204,'3056','472',78711.12,78711.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257761',4907205,'3057','472',225067.15,225067.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257761',4907206,'3058','472',271051.22,273855.66,2804.44,462732.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257761',4907207,'3059','472',52405.20,52405.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257761',4907208,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257761',4907209,'3061','472',110678.36,110678.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257761',4907210,'3062','472',330991.05,333556.85,2565.80,423357.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257761',4907211,'3063','472',41059.85,41108.34,48.49,8000.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257761',4907212,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257762',4907213,'3056','472',78711.12,78711.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257762',4907214,'3057','472',225067.15,225067.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257762',4907215,'3058','472',273855.66,275577.36,1721.70,284080.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257762',4907216,'3059','472',52405.20,52405.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257762',4907217,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257762',4907218,'3061','472',110678.36,110678.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257762',4907219,'3062','472',333556.85,335825.59,2248.74,371042.10,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257762',4907220,'3063','472',41108.34,41448.54,340.20,56133.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257762',4907221,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257763',4907222,'3056','472',78711.12,78711.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257763',4907223,'3057','472',225067.15,226820.14,1752.99,289243.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257763',4907224,'3058','472',275577.36,277095.82,1518.46,250545.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257763',4907225,'3059','472',52405.20,52405.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257763',4907226,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257763',4907227,'3061','472',110678.36,110678.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257763',4907228,'3062','472',335825.59,337272.98,1447.39,238819.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257763',4907229,'3063','472',41448.54,41448.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257763',4907230,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257764',4907231,'3056','472',78711.12,78711.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257764',4907232,'3057','472',226820.14,226820.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257764',4907233,'3058','472',277095.82,279505.86,2410.04,397656.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257764',4907234,'3059','472',52405.20,52405.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257764',4907235,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257764',4907236,'3061','472',110678.36,110678.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257764',4907237,'3062','472',337272.98,339430.68,2157.70,356020.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257764',4907238,'3063','472',41448.54,41448.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257764',4907239,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257765',4907240,'3056','472',78711.12,78741.42,30.30,4999.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257765',4907241,'3057','472',226820.14,229217.93,2397.79,395635.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257765',4907242,'3058','472',279505.86,281484.54,1978.68,326482.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257765',4907243,'3059','472',52405.20,52405.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257765',4907244,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257765',4907245,'3061','472',110678.36,111200.18,521.82,86100.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257765',4907246,'3062','472',339430.68,340812.96,1382.28,228076.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257765',4907247,'3063','472',41448.54,41448.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257765',4907248,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257766',4907249,'3056','472',78741.42,78741.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257766',4907250,'3057','472',229217.93,229217.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257766',4907251,'3058','472',281484.54,284159.90,2675.36,441434.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257766',4907252,'3059','472',52405.20,52405.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257766',4907253,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257766',4907254,'3061','472',111200.18,111200.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257766',4907255,'3062','472',340812.96,343547.80,2734.84,451248.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257766',4907256,'3063','472',41448.54,41560.83,112.29,18527.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257766',4907257,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257767',4907258,'3056','472',78741.42,78741.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257767',4907259,'3057','472',229217.93,232163.32,2945.39,485989.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257767',4907260,'3058','472',284159.90,286788.97,2629.07,433796.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257767',4907261,'3059','472',52405.20,52405.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257767',4907262,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257767',4907263,'3061','472',111200.18,111277.07,76.89,12686.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257767',4907264,'3062','472',343547.80,345744.41,2196.61,362440.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257767',4907265,'3063','472',41560.83,41740.20,179.37,29596.05,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257767',4907266,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257768',4907267,'3056','472',78741.42,78741.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257768',4907268,'3057','472',232163.32,232808.32,645.00,106425.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257768',4907269,'3058','472',286788.97,290324.59,3515.62,580077.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257768',4907270,'3059','472',52405.20,52747.16,321.96,53123.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257768',4907271,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257768',4907272,'3061','472',111277.07,111277.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257768',4907273,'3062','472',345744.41,350344.98,4579.97,755695.05,0.00,0.00,20.60,0.00,0.00),('1','206','1030','257768',4907274,'3063','472',41740.20,41740.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257768',4907275,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257769',4907276,'3056','472',78741.42,78741.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257769',4907277,'3057','472',232808.32,232808.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257769',4907278,'3058','472',290324.59,290324.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257769',4907279,'3059','472',52747.16,55237.44,2490.28,410896.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257769',4907280,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257769',4907281,'3061','472',111277.07,111277.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257769',4907282,'3062','472',350344.98,350344.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257769',4907283,'3063','472',41740.20,43852.08,2111.88,348460.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257769',4907284,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257770',4907285,'3056','472',78741.42,78741.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257770',4907286,'3057','472',232808.32,234320.42,1512.10,249496.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257770',4907287,'3058','472',290324.59,291331.31,1006.72,166108.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257770',4907288,'3059','472',55237.44,55664.54,427.10,70471.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257770',4907289,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257770',4907290,'3061','472',111277.07,111277.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257770',4907291,'3062','472',350344.98,351931.51,1586.53,261777.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257770',4907292,'3063','472',43852.08,43852.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257770',4907293,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257771',4907294,'3056','472',78741.42,78741.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257771',4907295,'3057','472',234320.42,234320.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257771',4907296,'3058','472',291331.31,293468.02,2136.71,352557.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257771',4907297,'3059','472',55664.54,55664.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257771',4907298,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257771',4907299,'3061','472',111277.07,111277.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257771',4907300,'3062','472',351931.51,354332.10,2400.59,396097.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257771',4907301,'3063','472',43852.08,43852.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257771',4907302,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257772',4907303,'3056','472',78741.42,78933.12,191.70,31630.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257772',4907304,'3057','472',234320.42,237175.17,2834.75,467733.75,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257772',4907305,'3058','472',293468.02,296658.17,3190.15,526374.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257772',4907306,'3059','472',55664.54,55664.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257772',4907307,'3060','472',14795.83,14795.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257772',4907308,'3061','472',111277.07,111277.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257772',4907309,'3062','472',354332.10,357024.96,2692.86,444321.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257772',4907310,'3063','472',43852.08,44032.02,179.94,29690.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257772',4907311,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257773',4907312,'3056','472',78933.12,79101.89,146.27,24134.55,0.00,0.00,22.50,0.00,0.00),('1','206','1030','257773',4907313,'3057','472',237175.17,238318.50,1120.83,184936.95,0.00,0.00,22.50,0.00,0.00),('1','206','1030','257773',4907314,'3058','472',296658.17,297629.25,948.58,156515.70,0.00,0.00,22.50,0.00,0.00),('1','206','1030','257773',4907315,'3059','472',55664.54,55723.95,36.91,6090.15,0.00,0.00,22.50,0.00,0.00),('1','206','1030','257773',4907316,'3060','472',14795.83,14942.03,123.70,20410.50,0.00,0.00,22.50,0.00,0.00),('1','206','1030','257773',4907317,'3061','472',111277.07,111337.79,38.22,6306.30,0.00,0.00,22.50,0.00,0.00),('1','206','1030','257773',4907318,'3062','472',357024.96,362833.03,5785.57,954619.05,0.00,0.00,22.50,0.00,0.00),('1','206','1030','257773',4907319,'3063','472',44032.02,44253.31,198.79,32800.35,0.00,0.00,22.50,0.00,0.00),('1','206','1031','257773',4907320,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257774',4907321,'3056','472',79101.89,79101.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257774',4907322,'3057','472',238318.50,240375.97,2057.47,339482.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257774',4907323,'3058','472',297629.25,303025.31,5396.06,890349.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257774',4907324,'3059','472',55723.95,55723.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257774',4907325,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257774',4907326,'3061','472',111337.79,111836.92,499.13,82356.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257774',4907327,'3062','472',362833.03,368023.67,5190.64,856455.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257774',4907328,'3063','472',44253.31,44253.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257774',4907329,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257775',4907330,'3056','472',79101.89,80027.64,925.75,152748.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257775',4907331,'3057','472',240375.97,244128.20,3752.23,619117.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257775',4907332,'3058','472',303025.31,306767.99,3742.68,617542.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257775',4907333,'3059','472',55723.95,56742.18,1018.23,168007.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257775',4907334,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257775',4907335,'3061','472',111836.92,112424.85,587.93,97008.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257775',4907336,'3062','472',368023.67,371933.64,3909.97,645145.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257775',4907337,'3063','472',44253.31,44253.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257775',4907338,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257776',4907339,'3056','472',80027.64,80027.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257776',4907340,'3057','472',244128.20,244128.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257776',4907341,'3058','472',306767.99,310742.56,3974.57,655804.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257776',4907342,'3059','472',56742.18,56742.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257776',4907343,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257776',4907344,'3061','472',112424.85,112424.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257776',4907345,'3062','472',371933.64,375805.79,3872.15,638904.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257776',4907346,'3063','472',44253.31,44253.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257776',4907347,'3064','473',148358.56,148358.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257777',4907348,'3056','472',80027.64,80027.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257777',4907349,'3057','472',244128.20,246684.83,2556.63,421843.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257777',4907350,'3058','472',310742.56,313236.83,2494.27,411554.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257777',4907351,'3059','472',56742.18,57185.00,442.82,73065.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257777',4907352,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257777',4907353,'3061','472',112424.85,112424.98,0.13,21.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257777',4907354,'3062','472',375805.79,378416.24,2610.45,430724.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257777',4907355,'3063','472',44253.31,44398.54,145.23,23962.95,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257777',4907356,'3064','473',148358.56,148360.32,0.00,0.00,0.00,0.00,1.76,0.00,0.00),('1','206','1030','257778',4907357,'3056','472',80027.64,80027.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257778',4907358,'3057','472',246684.83,247207.96,523.13,86316.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257778',4907359,'3058','472',313236.83,316355.65,3118.82,514605.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257778',4907360,'3059','472',57185.00,57185.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257778',4907361,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257778',4907362,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257778',4907363,'3062','472',378416.24,380649.83,2233.59,368542.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257778',4907364,'3063','472',44398.54,44464.91,66.37,10951.05,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257778',4907365,'3064','473',148360.32,148360.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257779',4907366,'3056','472',80027.64,80651.92,624.28,103006.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257779',4907367,'3057','472',247207.96,247857.26,649.30,107134.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257779',4907368,'3058','472',316355.65,317316.64,960.99,158563.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257779',4907369,'3059','472',57185.00,57566.58,381.58,62960.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257779',4907370,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257779',4907371,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257779',4907372,'3062','472',380649.83,380649.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257779',4907373,'3063','472',44464.91,44464.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257779',4907374,'3064','473',148360.32,148360.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257780',4907375,'3056','472',80651.92,81695.03,1043.11,172113.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257780',4907376,'3057','472',247857.26,249216.70,1359.44,224307.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257780',4907377,'3058','472',317316.64,319722.56,2405.92,396976.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257780',4907378,'3059','472',57566.58,58082.21,515.63,85078.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257780',4907379,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257780',4907380,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257780',4907381,'3062','472',380649.83,380649.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257780',4907382,'3063','472',44464.91,44464.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257780',4907383,'3064','473',148360.32,148360.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257781',4907384,'3056','472',81695.03,81695.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257781',4907385,'3057','472',249216.70,253351.19,4134.49,682190.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257781',4907386,'3058','472',319722.56,319722.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257781',4907387,'3059','472',58082.21,61605.99,3523.78,581423.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257781',4907388,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257781',4907389,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257781',4907390,'3062','472',380649.83,380649.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257781',4907391,'3063','472',44464.91,44464.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257781',4907392,'3064','473',148360.32,148360.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257782',4907393,'3056','472',81695.03,81695.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257782',4907394,'3057','472',253351.19,255569.87,2218.68,366082.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257782',4907395,'3058','472',319722.56,319833.49,90.93,15003.45,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257782',4907396,'3059','472',61605.99,62602.76,996.77,164467.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257782',4907397,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257782',4907398,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257782',4907399,'3062','472',380649.83,382915.11,2265.28,373771.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257782',4907400,'3063','472',44464.91,44464.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257782',4907401,'3064','473',148360.32,148360.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257783',4907402,'3056','472',81695.03,82090.71,395.68,65287.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257783',4907403,'3057','472',255569.87,258604.69,3034.82,500745.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257783',4907404,'3058','472',319833.49,319833.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257783',4907405,'3059','472',62602.76,62602.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257783',4907406,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257783',4907407,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257783',4907408,'3062','472',382915.11,389215.92,6300.81,1039633.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257783',4907409,'3063','472',44464.91,44514.27,49.36,8144.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257783',4907410,'3064','473',148360.32,149636.28,1251.80,963886.00,0.00,0.00,24.16,0.00,0.00),('1','206','1030','257784',4907411,'3056','472',82090.71,82573.28,482.57,79624.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257784',4907412,'3057','472',258604.69,262354.04,3729.35,615342.75,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257784',4907413,'3058','472',319833.49,319833.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257784',4907414,'3059','472',62602.76,62602.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257784',4907415,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257784',4907416,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257784',4907417,'3062','472',389215.92,392036.40,2820.48,465379.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257784',4907418,'3063','472',44514.27,44809.83,295.56,48767.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257784',4907419,'3064','473',149636.28,149654.04,17.76,14208.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257785',4907420,'3056','472',82573.28,82626.18,52.90,8728.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257785',4907421,'3057','472',262354.04,265670.84,3316.80,547272.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257785',4907422,'3058','472',319833.49,319833.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257785',4907423,'3059','472',62602.76,62602.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257785',4907424,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257785',4907425,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257785',4907426,'3062','472',392036.40,395372.09,3335.69,550388.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257785',4907427,'3063','472',44809.83,46073.01,1263.18,208424.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257785',4907428,'3064','473',149654.04,149772.93,118.89,95112.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257786',4907429,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257786',4907430,'3057','472',265670.84,265670.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257786',4907431,'3058','472',319833.49,321805.87,1972.38,325442.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257786',4907432,'3059','472',62602.76,62602.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257786',4907433,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257786',4907434,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257786',4907435,'3062','472',395372.09,397041.39,1669.30,275434.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257786',4907436,'3063','472',46073.01,46367.30,294.29,48557.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257786',4907437,'3064','473',149772.93,149772.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257787',4907438,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257787',4907439,'3057','472',265670.84,265807.69,136.85,22580.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257787',4907440,'3058','472',321805.87,321805.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257787',4907441,'3059','472',62602.76,62637.35,14.59,2407.35,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257787',4907442,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257787',4907443,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257787',4907444,'3062','472',397041.39,400354.72,3294.55,543600.75,0.00,0.00,18.78,0.00,0.00),('1','206','1030','257787',4907445,'3063','472',46367.30,47377.34,1010.04,166656.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257787',4907446,'3064','473',149772.93,150594.70,821.77,657416.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257788',4907447,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257788',4907448,'3057','472',265807.69,266257.09,449.40,74151.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257788',4907449,'3058','472',321805.87,321805.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257788',4907450,'3059','472',62637.35,66954.11,4316.76,712265.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257788',4907451,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257788',4907452,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257788',4907453,'3062','472',400354.72,404218.16,3863.44,637467.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257788',4907454,'3063','472',47377.34,48605.17,1227.83,202591.95,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257788',4907455,'3064','473',150594.70,150808.83,214.13,171304.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257789',4907456,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257789',4907457,'3057','472',266257.09,266257.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257789',4907458,'3058','472',321805.87,322946.10,1140.23,188137.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257789',4907459,'3059','472',66954.11,66954.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257789',4907460,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257789',4907461,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257789',4907462,'3062','472',404218.16,405577.82,1359.66,224343.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257789',4907463,'3063','472',48605.17,48780.05,174.88,28855.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257789',4907464,'3064','473',150808.83,150881.96,73.13,58504.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257790',4907465,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257790',4907466,'3057','472',266257.09,266257.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257790',4907467,'3058','472',322946.10,322946.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257790',4907468,'3059','472',66954.11,66954.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257790',4907469,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257790',4907470,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257790',4907471,'3062','472',405577.82,406622.40,1044.58,172355.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257790',4907472,'3063','472',48780.05,48780.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257790',4907473,'3064','473',150881.96,151255.71,373.75,299000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257791',4907474,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257791',4907475,'3057','472',266257.09,266257.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257791',4907476,'3058','472',322946.10,323578.09,631.99,104278.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257791',4907477,'3059','472',66954.11,66985.05,30.94,5105.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257791',4907478,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257791',4907479,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257791',4907480,'3062','472',406622.40,410016.29,3373.89,556691.85,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257791',4907481,'3063','472',48780.05,49064.84,284.79,46990.35,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257791',4907482,'3064','473',151255.71,151255.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257792',4907483,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257792',4907484,'3057','472',266257.09,266257.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257792',4907485,'3058','472',323578.09,326938.31,3360.22,554436.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257792',4907486,'3059','472',66985.05,68859.03,1873.98,309206.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257792',4907487,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257792',4907488,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257792',4907489,'3062','472',410016.29,413409.84,3393.55,559935.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257792',4907490,'3063','472',49064.84,50423.34,1358.50,224152.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257792',4907491,'3064','473',151255.71,152369.37,1103.66,905001.20,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257793',4907492,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257793',4907493,'3057','472',266257.09,266257.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257793',4907494,'3058','472',326938.31,329219.34,2281.03,376369.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257793',4907495,'3059','472',68859.03,68859.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257793',4907496,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257793',4907497,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257793',4907498,'3062','472',413409.84,415371.31,1961.47,323642.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257793',4907499,'3063','472',50423.34,51037.25,613.91,101295.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257793',4907500,'3064','473',152369.37,152377.18,7.81,6404.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257794',4907501,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257794',4907502,'3057','472',266257.09,266257.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257794',4907503,'3058','472',329219.34,331300.77,2081.43,343435.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257794',4907504,'3059','472',68859.03,68859.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257794',4907505,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257794',4907506,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257794',4907507,'3062','472',415371.31,417480.20,2108.89,347966.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257794',4907508,'3063','472',51037.25,51037.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257794',4907509,'3064','473',152377.18,152405.86,28.68,23517.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257795',4907510,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257795',4907511,'3057','472',266257.09,266257.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257795',4907512,'3058','472',331300.77,333035.96,1715.19,283006.35,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257795',4907513,'3059','472',68859.03,70264.50,1388.51,229104.15,0.00,0.00,16.96,0.00,0.00),('1','206','1030','257795',4907514,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257795',4907515,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257795',4907516,'3062','472',417480.20,419463.72,1983.52,327280.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257795',4907517,'3063','472',51037.25,51981.39,944.14,155783.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257795',4907518,'3064','473',152405.86,152409.15,3.29,2697.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257796',4907519,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257796',4907520,'3057','472',266257.09,266257.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257796',4907521,'3058','472',333035.96,335232.96,2197.00,362505.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257796',4907522,'3059','472',70264.50,70420.86,156.36,25799.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257796',4907523,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257796',4907524,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257796',4907525,'3062','472',419463.72,422655.99,3192.27,526724.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257796',4907526,'3063','472',51981.39,51981.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257796',4907527,'3064','473',152409.15,153215.17,796.02,660696.60,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257797',4907528,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257797',4907529,'3057','472',266257.09,266398.89,141.80,23397.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257797',4907530,'3058','472',335232.96,337041.09,1808.13,298341.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257797',4907531,'3059','472',70420.86,70579.39,158.53,26157.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257797',4907532,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257797',4907533,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257797',4907534,'3062','472',422655.99,424031.71,1375.72,226993.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257797',4907535,'3063','472',51981.39,52849.78,868.39,143284.35,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257797',4907536,'3064','473',153215.17,153221.19,6.02,4996.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257798',4907537,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257798',4907538,'3057','472',266398.89,266555.26,156.37,25801.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257798',4907539,'3058','472',337041.09,339701.25,2660.16,438926.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257798',4907540,'3059','472',70579.39,71732.29,1152.90,190228.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257798',4907541,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257798',4907542,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257798',4907543,'3062','472',424031.71,426678.68,2646.97,436750.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257798',4907544,'3063','472',52849.78,53406.40,556.62,91842.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257798',4907545,'3064','473',153221.19,153649.04,407.85,338515.50,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257799',4907546,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257799',4907547,'3057','472',266555.26,266555.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257799',4907548,'3058','472',339701.25,339782.51,81.26,13407.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257799',4907549,'3059','472',71732.29,71732.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257799',4907550,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257799',4907551,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257799',4907552,'3062','472',426678.68,429072.63,2393.95,395001.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257799',4907553,'3063','472',53406.40,54678.85,1272.45,209954.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257799',4907554,'3064','473',153649.04,153654.46,5.42,4498.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257800',4907555,'3056','472',82626.18,82626.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257800',4907556,'3057','472',266555.26,266555.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257800',4907557,'3058','472',339782.51,339782.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257800',4907558,'3059','472',71732.29,71732.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257800',4907559,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257800',4907560,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257800',4907561,'3062','472',429072.63,431145.13,2072.50,341962.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257800',4907562,'3063','472',54678.85,54768.20,89.35,14742.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257800',4907563,'3064','473',153654.46,153913.49,229.03,190094.90,0.00,0.00,30.00,0.00,0.00),('1','206','1030','257801',4907564,'3056','472',82626.18,83145.44,499.26,82377.90,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257801',4907565,'3057','472',266555.26,269341.11,2765.85,456365.25,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257801',4907566,'3058','472',339782.51,342368.60,2566.09,423404.85,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257801',4907567,'3059','472',71732.29,73169.00,1416.71,233757.15,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257801',4907568,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257801',4907569,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257801',4907570,'3062','472',431145.13,435333.81,4168.68,687832.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257801',4907571,'3063','472',54768.20,57353.96,2565.76,423350.40,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257801',4907572,'3064','473',153913.49,156110.96,2197.47,1823900.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257802',4907573,'3056','472',83145.44,83145.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257802',4907574,'3057','472',269341.11,269341.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257802',4907575,'3058','472',342368.60,342368.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257802',4907576,'3059','472',73169.00,73169.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257802',4907577,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257802',4907578,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257802',4907579,'3062','472',435333.81,436011.68,677.87,111848.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257802',4907580,'3063','472',57353.96,57533.36,179.40,29601.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257802',4907581,'3064','473',156110.96,156113.37,2.41,2000.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257803',4907582,'3056','472',83145.44,83145.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257803',4907583,'3057','472',269341.11,269820.36,459.25,75776.25,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257803',4907584,'3058','472',342368.60,343481.45,1092.85,180320.25,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257803',4907585,'3059','472',73169.00,73497.39,308.39,50884.35,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257803',4907586,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257803',4907587,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257803',4907588,'3062','472',436011.68,437745.70,1714.02,282813.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257803',4907589,'3063','472',57533.36,58224.50,671.14,110738.10,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257803',4907590,'3064','473',156113.37,156134.33,10.96,9096.80,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257804',4907591,'3056','472',83145.44,83145.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257804',4907592,'3057','472',269820.36,269820.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257804',4907593,'3058','472',343481.45,343481.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257804',4907594,'3059','472',73497.39,73497.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257804',4907595,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257804',4907596,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257804',4907597,'3062','472',437745.70,439472.17,1706.47,281567.55,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257804',4907598,'3063','472',58224.50,58445.47,202.79,33460.35,0.00,0.00,18.18,0.00,0.00),('1','206','1031','257804',4907599,'3064','473',156134.33,156134.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257805',4907600,'3056','472',83145.44,83145.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257805',4907601,'3057','472',269820.36,269913.07,92.71,15297.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257805',4907602,'3058','472',343481.45,344946.37,1464.92,241711.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257805',4907603,'3059','472',73497.39,73695.96,198.57,32764.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257805',4907604,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257805',4907605,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257805',4907606,'3062','472',439472.17,440927.57,1455.40,240141.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257805',4907607,'3063','472',58445.47,59042.99,597.52,98590.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257805',4907608,'3064','473',156134.33,157857.06,1702.73,1413265.90,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257806',4907609,'3056','472',83145.44,85395.79,2250.35,371307.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257806',4907610,'3057','472',269913.07,272932.02,3018.95,498126.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257806',4907611,'3058','472',344946.37,345525.07,578.70,95485.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257806',4907612,'3059','472',73695.96,73755.96,60.00,9900.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257806',4907613,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257806',4907614,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257806',4907615,'3062','472',440927.57,443456.56,2528.99,417283.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257806',4907616,'3063','472',59042.99,61175.28,2132.29,351827.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257806',4907617,'3064','473',157857.06,157858.26,1.20,996.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257807',4907618,'3056','472',85395.79,85395.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257807',4907619,'3057','472',272932.02,272981.41,25.80,4257.00,0.00,0.00,23.59,0.00,0.00),('1','206','1030','257807',4907620,'3058','472',345525.07,345555.07,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','206','1030','257807',4907621,'3059','472',73755.96,73778.97,0.00,0.00,0.00,0.00,23.01,0.00,0.00),('1','206','1030','257807',4907622,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257807',4907623,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257807',4907624,'3062','472',443456.56,446616.00,3136.94,517595.10,0.00,0.00,22.50,0.00,0.00),('1','206','1030','257807',4907625,'3063','472',61175.28,61203.73,28.45,4694.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257807',4907626,'3064','473',157858.26,157858.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257808',4907627,'3056','472',85395.79,85395.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257808',4907628,'3057','472',272981.41,272981.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257808',4907629,'3058','472',345555.07,345555.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257808',4907630,'3059','472',73778.97,73778.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257808',4907631,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257808',4907632,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257808',4907633,'3062','472',446616.00,447134.43,518.43,85540.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257808',4907634,'3063','472',61203.73,61391.04,187.31,30906.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257808',4907635,'3064','473',157858.26,158885.96,1015.90,843197.00,0.00,0.00,11.80,0.00,0.00),('1','206','1030','257809',4907636,'3056','472',85395.79,86483.24,1063.83,175531.95,0.00,0.00,23.62,0.00,0.00),('1','206','1030','257809',4907637,'3057','472',272981.41,275758.16,2753.13,454266.45,0.00,0.00,23.62,0.00,0.00),('1','206','1030','257809',4907638,'3058','472',345555.07,346405.76,827.07,136466.55,0.00,0.00,23.62,0.00,0.00),('1','206','1030','257809',4907639,'3059','472',73778.97,74302.07,499.48,82414.20,0.00,0.00,23.62,0.00,0.00),('1','206','1030','257809',4907640,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257809',4907641,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257809',4907642,'3062','472',447134.43,450261.31,3103.26,512037.90,0.00,0.00,23.62,0.00,0.00),('1','206','1030','257809',4907643,'3063','472',61391.04,63740.03,2325.37,383686.05,0.00,0.00,23.62,0.00,0.00),('1','206','1031','257809',4907644,'3064','473',158885.96,159855.96,970.00,805100.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257810',4907645,'3056','472',86483.24,86562.02,58.78,9698.70,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257810',4907646,'3057','472',275758.16,275806.64,28.48,4699.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257810',4907647,'3058','472',346405.76,347197.36,771.60,127314.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257810',4907648,'3059','472',74302.07,74495.10,173.03,28549.95,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257810',4907649,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257810',4907650,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257810',4907651,'3062','472',450261.31,453830.13,3548.82,585555.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257810',4907652,'3063','472',63740.03,63974.31,214.28,35356.20,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257810',4907653,'3064','473',159855.96,160449.71,573.75,476212.50,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257811',4907654,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257811',4907655,'3057','472',275806.64,275806.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257811',4907656,'3058','472',347197.36,347349.29,151.93,25068.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257811',4907657,'3059','472',74495.10,75516.07,1020.97,168460.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257811',4907658,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257811',4907659,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257811',4907660,'3062','472',453830.13,457080.43,3250.30,536299.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257811',4907661,'3063','472',63974.31,64249.30,274.99,45373.35,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257811',4907662,'3064','473',160449.71,160545.88,96.17,79821.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257812',4907663,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257812',4907664,'3057','472',275806.64,275806.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257812',4907665,'3058','472',347349.29,347590.02,240.73,39720.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257812',4907666,'3059','472',75516.07,75516.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257812',4907667,'3060','472',14942.03,14942.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257812',4907668,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257812',4907669,'3062','472',457080.43,459741.90,2661.47,439142.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257812',4907670,'3063','472',64249.30,64314.61,65.31,10776.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257812',4907671,'3064','473',160545.88,160721.58,175.70,145831.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257813',4907672,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257813',4907673,'3057','472',275806.64,275806.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257813',4907674,'3058','472',347590.02,348499.82,909.80,150117.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257813',4907675,'3059','472',75516.07,75580.27,64.20,10593.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257813',4907676,'3060','472',14942.03,14942.80,0.77,127.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257813',4907677,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257813',4907678,'3062','472',459741.90,461811.15,2069.25,341426.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257813',4907679,'3063','472',64314.61,65246.44,931.83,153751.95,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257813',4907680,'3064','473',160721.58,160992.63,271.05,224971.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257814',4907681,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257814',4907682,'3057','472',275806.64,275806.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257814',4907683,'3058','472',348499.82,348499.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257814',4907684,'3059','472',75580.27,75580.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257814',4907685,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257814',4907686,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257814',4907687,'3062','472',461811.15,464142.98,2311.83,427688.55,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257814',4907688,'3063','472',65246.44,65888.89,622.45,115153.25,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257814',4907689,'3064','473',160992.63,162350.88,1328.25,1102447.50,0.00,0.00,30.00,0.00,0.00),('1','206','1030','257815',4907690,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257815',4907691,'3057','472',275806.64,275806.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257815',4907692,'3058','472',348499.82,348601.91,102.09,18886.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257815',4907693,'3059','472',75580.27,75900.04,319.77,59157.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257815',4907694,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257815',4907695,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257815',4907696,'3062','472',464142.98,466913.97,2770.99,512633.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257815',4907697,'3063','472',65888.89,66159.84,270.95,50125.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257815',4907698,'3064','473',162350.88,163355.09,1004.21,813410.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257816',4907699,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257816',4907700,'3057','472',275806.64,275806.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257816',4907701,'3058','472',348601.91,348698.79,96.88,17922.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257816',4907702,'3059','472',75900.04,77910.70,2010.66,371972.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257816',4907703,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257816',4907704,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257816',4907705,'3062','472',466913.97,469271.43,2357.46,436130.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257816',4907706,'3063','472',66159.84,66159.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257816',4907707,'3064','473',163355.09,163357.32,2.23,1806.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257817',4907708,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257817',4907709,'3057','472',275806.64,275806.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257817',4907710,'3058','472',348698.79,351504.31,2805.52,519021.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257817',4907711,'3059','472',77910.70,78101.48,190.78,35294.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257817',4907712,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257817',4907713,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257817',4907714,'3062','472',469271.43,471875.10,2603.67,481678.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257817',4907715,'3063','472',66159.84,66354.69,194.85,36047.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257817',4907716,'3064','473',163357.32,163958.55,601.23,486996.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257818',4907717,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257818',4907718,'3057','472',275806.64,276977.48,1170.84,216605.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257818',4907719,'3058','472',351504.31,352760.72,1256.41,232435.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257818',4907720,'3059','472',78101.48,78101.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257818',4907721,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257818',4907722,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257818',4907723,'3062','472',471875.10,472468.85,593.75,109843.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257818',4907724,'3063','472',66354.69,66554.61,199.92,36985.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257818',4907725,'3064','473',163958.55,164658.55,700.00,567000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257819',4907726,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257819',4907727,'3057','472',276977.48,276977.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257819',4907728,'3058','472',352760.72,354047.64,1286.92,238080.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257819',4907729,'3059','472',78101.48,78596.44,494.96,91567.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257819',4907730,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257819',4907731,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257819',4907732,'3062','472',472468.85,474151.86,1683.01,311356.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257819',4907733,'3063','472',66554.61,66554.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257819',4907734,'3064','473',164658.55,164713.49,54.94,44501.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257820',4907735,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257820',4907736,'3057','472',276977.48,276977.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257820',4907737,'3058','472',354047.64,356233.47,2185.83,404378.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257820',4907738,'3059','472',78596.44,78713.58,117.14,21670.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257820',4907739,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257820',4907740,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257820',4907741,'3062','472',474151.86,475527.12,1375.26,254423.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257820',4907742,'3063','472',66554.61,67060.87,506.26,93658.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257820',4907743,'3064','473',164713.49,164857.49,124.00,100440.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257821',4907744,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257821',4907745,'3057','472',276977.48,276977.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257821',4907746,'3058','472',356233.47,357807.65,1574.18,291223.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257821',4907747,'3059','472',78713.58,79861.33,1147.75,212333.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257821',4907748,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257821',4907749,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257821',4907750,'3062','472',475527.12,478218.69,2691.57,497940.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257821',4907751,'3063','472',67060.87,67564.36,503.49,93145.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257821',4907752,'3064','473',164857.49,164857.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257822',4907753,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257822',4907754,'3057','472',276977.48,276977.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257822',4907755,'3058','472',357807.65,358883.49,1075.84,199030.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257822',4907756,'3059','472',79861.33,81008.63,1147.30,212250.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257822',4907757,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257822',4907758,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257822',4907759,'3062','472',478218.69,479710.61,1491.92,276005.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257822',4907760,'3063','472',67564.36,67933.68,369.32,68324.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257822',4907761,'3064','473',164857.49,164893.18,35.69,28908.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257823',4907762,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257823',4907763,'3057','472',276977.48,276977.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257823',4907764,'3058','472',358883.49,361995.97,3112.48,575808.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257823',4907765,'3059','472',81008.63,83270.09,2261.46,418370.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257823',4907766,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257823',4907767,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257823',4907768,'3062','472',479710.61,483582.72,3872.11,716340.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257823',4907769,'3063','472',67933.68,69207.87,1274.19,235725.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257823',4907770,'3064','473',164893.18,164992.49,79.31,64241.10,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257824',4907771,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257824',4907772,'3057','472',276977.48,276977.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257824',4907773,'3058','472',361995.97,364297.37,2301.40,425759.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257824',4907774,'3059','472',83270.09,84289.35,1019.26,188563.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257824',4907775,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257824',4907776,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257824',4907777,'3062','472',483582.72,485771.82,2189.10,404983.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257824',4907778,'3063','472',69207.87,70334.64,1126.77,208452.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257824',4907779,'3064','473',164992.49,164992.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257825',4907780,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257825',4907781,'3057','472',276977.48,276977.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257825',4907782,'3058','472',364297.37,366249.16,1951.79,361081.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257825',4907783,'3059','472',84289.35,85740.68,1451.33,268496.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257825',4907784,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257825',4907785,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257825',4907786,'3062','472',485771.82,487945.52,2173.70,402134.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257825',4907787,'3063','472',70334.64,71349.21,1014.57,187695.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257825',4907788,'3064','473',164992.49,164992.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257826',4907789,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257826',4907790,'3057','472',276977.48,277203.57,226.09,41826.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257826',4907791,'3058','472',366249.16,367149.15,879.99,162798.15,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257826',4907792,'3059','472',85740.68,87029.89,1289.21,238503.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257826',4907793,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257826',4907794,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257826',4907795,'3062','472',487945.52,489312.79,1367.27,252944.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257826',4907796,'3063','472',71349.21,71766.22,417.01,77146.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257826',4907797,'3064','473',164992.49,164992.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257827',4907798,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257827',4907799,'3057','472',277203.57,277203.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257827',4907800,'3058','472',367149.15,368156.76,1007.61,186407.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257827',4907801,'3059','472',87029.89,87101.48,71.59,13244.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257827',4907802,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257827',4907803,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257827',4907804,'3062','472',489312.79,490072.90,760.11,140620.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257827',4907805,'3063','472',71766.22,71817.87,51.65,9555.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257827',4907806,'3064','473',164992.49,164992.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257828',4907807,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257828',4907808,'3057','472',277203.57,277203.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257828',4907809,'3058','472',368156.76,368156.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257828',4907810,'3059','472',87101.48,87101.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257828',4907811,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257828',4907812,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257828',4907813,'3062','472',490072.90,490072.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257828',4907814,'3063','472',71817.87,71817.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257828',4907815,'3064','473',164992.49,164992.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257829',4907816,'3056','472',86562.02,86562.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257829',4907817,'3057','472',277203.57,277203.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257829',4907818,'3058','472',368156.76,371932.95,3776.19,698595.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257829',4907819,'3059','472',87101.48,87154.41,52.93,9792.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257829',4907820,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257829',4907821,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257829',4907822,'3062','472',490072.90,493352.29,3279.39,606687.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257829',4907823,'3063','472',71817.87,71817.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257829',4907824,'3064','473',164992.49,164992.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257830',4907825,'3056','472',86562.02,86599.18,37.16,6874.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257830',4907826,'3057','472',277203.57,277481.97,278.40,51504.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257830',4907827,'3058','472',371932.95,374997.26,3064.31,566897.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257830',4907828,'3059','472',87154.41,88160.13,1005.72,186058.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257830',4907829,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257830',4907830,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257830',4907831,'3062','472',493352.29,496323.05,2970.76,549590.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257830',4907832,'3063','472',71817.87,73570.09,1752.22,324160.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257830',4907833,'3064','473',164992.49,166158.22,1165.73,944241.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257831',4907834,'3056','472',86599.18,86599.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257831',4907835,'3057','472',277481.97,277481.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257831',4907836,'3058','472',374997.26,376338.90,1322.99,244753.15,0.00,0.00,18.65,0.00,0.00),('1','206','1030','257831',4907837,'3059','472',88160.13,88286.50,107.72,19928.20,0.00,0.00,18.65,0.00,0.00),('1','206','1030','257831',4907838,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257831',4907839,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257831',4907840,'3062','472',496323.05,497996.46,1654.76,306130.60,0.00,0.00,18.65,0.00,0.00),('1','206','1030','257831',4907841,'3063','472',73570.09,73659.83,71.09,13151.65,0.00,0.00,18.65,0.00,0.00),('1','206','1031','257831',4907842,'3064','473',166158.22,166170.32,12.10,9801.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257832',4907843,'3056','472',86599.18,86599.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257832',4907844,'3057','472',277481.97,278694.08,1212.11,224240.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257832',4907845,'3058','472',376338.90,376338.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257832',4907846,'3059','472',88286.50,88286.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257832',4907847,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257832',4907848,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257832',4907849,'3062','472',497996.46,501613.16,3616.70,669089.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257832',4907850,'3063','472',73659.83,73659.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257832',4907851,'3064','473',166170.32,166170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257833',4907852,'3056','472',86599.18,86599.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257833',4907853,'3057','472',278694.08,278694.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257833',4907854,'3058','472',376338.90,378563.56,2224.66,411562.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257833',4907855,'3059','472',88286.50,88286.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257833',4907856,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257833',4907857,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257833',4907858,'3062','472',501613.16,503955.70,2342.54,433369.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257833',4907859,'3063','472',73659.83,73659.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257833',4907860,'3064','473',166170.32,166170.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257834',4907861,'3056','472',86599.18,86599.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257834',4907862,'3057','472',278694.08,278694.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257834',4907863,'3058','472',378563.56,381616.15,3039.08,562229.80,0.00,0.00,13.51,0.00,0.00),('1','206','1030','257834',4907864,'3059','472',88286.50,88662.50,376.00,69560.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257834',4907865,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257834',4907866,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257834',4907867,'3062','472',503955.70,506303.92,2348.22,434420.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257834',4907868,'3063','472',73659.83,74889.02,1229.19,227400.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257834',4907869,'3064','473',166170.32,167087.60,917.28,742996.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257835',4907870,'3056','472',86599.18,86599.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257835',4907871,'3057','472',278694.08,278694.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257835',4907872,'3058','472',381616.15,385213.77,3597.62,665559.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257835',4907873,'3059','472',88662.50,88717.09,43.78,8099.30,0.00,0.00,10.81,0.00,0.00),('1','206','1030','257835',4907874,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257835',4907875,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257835',4907876,'3062','472',506303.92,509296.81,2992.89,553684.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257835',4907877,'3063','472',74889.02,74889.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257835',4907878,'3064','473',167087.60,167088.83,1.23,996.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257836',4907879,'3056','472',86599.18,86742.96,143.78,26599.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257836',4907880,'3057','472',278694.08,278939.38,245.30,45380.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257836',4907881,'3058','472',385213.77,387668.74,2454.97,454169.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257836',4907882,'3059','472',88717.09,89277.06,559.97,103594.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257836',4907883,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257836',4907884,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257836',4907885,'3062','472',509296.81,511369.44,2072.63,383436.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257836',4907886,'3063','472',74889.02,75364.72,475.70,88004.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257836',4907887,'3064','473',167088.83,167094.26,5.43,4398.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257837',4907888,'3056','472',86742.96,86887.09,144.13,26664.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257837',4907889,'3057','472',278939.38,280276.12,1336.74,247296.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257837',4907890,'3058','472',387668.74,390261.59,2592.85,479677.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257837',4907891,'3059','472',89277.06,89870.30,593.24,109749.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257837',4907892,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257837',4907893,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257837',4907894,'3062','472',511369.44,513109.10,1739.66,321837.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257837',4907895,'3063','472',75364.72,77274.21,1909.49,353255.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257837',4907896,'3064','473',167094.26,167128.82,34.56,27993.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257838',4907897,'3056','472',86887.09,86887.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257838',4907898,'3057','472',280276.12,280395.04,118.92,22000.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257838',4907899,'3058','472',390261.59,392769.30,2507.71,463926.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257838',4907900,'3059','472',89870.30,90412.60,542.30,100325.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257838',4907901,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257838',4907902,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257838',4907903,'3062','472',513109.10,514898.34,1789.24,331009.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257838',4907904,'3063','472',77274.21,78678.37,1404.16,259769.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257838',4907905,'3064','473',167128.82,167253.51,124.69,100998.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257839',4907906,'3056','472',86887.09,86941.86,54.77,10132.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257839',4907907,'3057','472',280395.04,280818.00,422.96,78247.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257839',4907908,'3058','472',392769.30,394154.84,1385.54,256324.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257839',4907909,'3059','472',90412.60,90528.97,116.37,21528.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257839',4907910,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257839',4907911,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257839',4907912,'3062','472',514898.34,515994.14,1095.80,202723.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257839',4907913,'3063','472',78678.37,78763.03,84.66,15662.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257839',4907914,'3064','473',167253.51,167254.25,0.74,599.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257840',4907915,'3056','472',86941.86,87461.78,519.92,96185.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257840',4907916,'3057','472',280818.00,282600.20,1782.20,329707.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257840',4907917,'3058','472',394154.84,395826.54,1671.70,309264.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257840',4907918,'3059','472',90528.97,90636.71,107.74,19931.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257840',4907919,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257840',4907920,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257840',4907921,'3062','472',515994.14,518495.25,2501.11,462705.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257840',4907922,'3063','472',78763.03,79000.27,237.24,43889.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257840',4907923,'3064','473',167254.25,168555.73,1301.48,1054198.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257841',4907924,'3056','472',87461.78,87874.44,412.66,76342.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257841',4907925,'3057','472',282600.20,284502.95,1902.75,352008.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257841',4907926,'3058','472',395826.54,396895.60,1069.06,197776.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257841',4907927,'3059','472',90636.71,90789.93,153.22,28345.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257841',4907928,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257841',4907929,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257841',4907930,'3062','472',518495.25,520489.68,1994.43,368969.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257841',4907931,'3063','472',79000.27,79000.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257841',4907932,'3064','473',168555.73,168555.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257842',4907933,'3056','472',87874.44,88409.32,534.88,98952.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257842',4907934,'3057','472',284502.95,286808.06,2305.11,426445.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257842',4907935,'3058','472',396895.60,398958.60,2063.00,381655.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257842',4907936,'3059','472',90789.93,91176.40,386.47,71496.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257842',4907937,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257842',4907938,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257842',4907939,'3062','472',520489.68,521939.26,1449.58,268172.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257842',4907940,'3063','472',79000.27,79842.90,842.63,155886.55,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257842',4907941,'3064','473',168555.73,168555.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257843',4907942,'3056','472',88409.32,88428.24,18.92,3500.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257843',4907943,'3057','472',286808.06,289669.29,2861.23,529327.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257843',4907944,'3058','472',398958.60,399378.88,420.28,77751.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257843',4907945,'3059','472',91176.40,92605.31,1428.91,264348.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257843',4907946,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257843',4907947,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257843',4907948,'3062','472',521939.26,524793.25,2853.99,527988.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257843',4907949,'3063','472',79842.90,80764.69,921.79,170531.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257843',4907950,'3064','473',168555.73,168555.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257844',4907951,'3056','472',88428.24,88428.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257844',4907952,'3057','472',289669.29,289824.91,155.62,28789.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257844',4907953,'3058','472',399378.88,403112.29,3733.41,690680.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257844',4907954,'3059','472',92605.31,94029.72,1424.41,263515.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257844',4907955,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257844',4907956,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257844',4907957,'3062','472',524793.25,528891.52,4098.27,758179.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257844',4907958,'3063','472',80764.69,81177.17,412.48,76308.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257844',4907959,'3064','473',168555.73,168555.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257845',4907960,'3056','472',88428.24,88506.33,56.47,10446.95,0.00,0.00,21.62,0.00,0.00),('1','206','1030','257845',4907961,'3057','472',289824.91,292009.62,2184.71,404171.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257845',4907962,'3058','472',403112.29,405720.06,2607.77,482437.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257845',4907963,'3059','472',94029.72,94030.80,1.08,199.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257845',4907964,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257845',4907965,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257845',4907966,'3062','472',528891.52,531306.02,2414.50,446682.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257845',4907967,'3063','472',81177.17,81524.36,347.19,64230.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257845',4907968,'3064','473',168555.73,168555.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257846',4907969,'3056','472',88506.33,88509.03,2.70,499.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257846',4907970,'3057','472',292009.62,294531.78,2522.16,466599.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257846',4907971,'3058','472',405720.06,407736.74,2016.68,373085.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257846',4907972,'3059','472',94030.80,94121.07,90.27,16699.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257846',4907973,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257846',4907974,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257846',4907975,'3062','472',531306.02,534718.46,3412.44,631301.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257846',4907976,'3063','472',81524.36,81893.10,368.74,68216.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257846',4907977,'3064','473',168555.73,168720.46,134.49,108936.90,0.00,0.00,30.24,0.00,0.00),('1','206','1030','257847',4907978,'3056','472',88509.03,88509.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257847',4907979,'3057','472',294531.78,298213.41,3661.63,677401.55,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257847',4907980,'3058','472',407736.74,408793.70,1036.96,191837.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257847',4907981,'3059','472',94121.07,94121.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257847',4907982,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257847',4907983,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257847',4907984,'3062','472',534718.46,538599.16,3860.70,714229.50,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257847',4907985,'3063','472',81893.10,82036.85,123.75,22893.75,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257847',4907986,'3064','473',168720.46,168754.25,33.79,27369.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257848',4907987,'3056','472',88509.03,88509.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257848',4907988,'3057','472',298213.41,298213.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257848',4907989,'3058','472',408793.70,409184.56,390.86,72309.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257848',4907990,'3059','472',94121.07,94121.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257848',4907991,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257848',4907992,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257848',4907993,'3062','472',538599.16,541660.82,3061.66,566407.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257848',4907994,'3063','472',82036.85,82317.91,281.06,51996.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257848',4907995,'3064','473',168754.25,168754.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257849',4907996,'3056','472',88509.03,88509.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257849',4907997,'3057','472',298213.41,298213.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257849',4907998,'3058','472',409184.56,409732.14,547.58,101302.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257849',4907999,'3059','472',94121.07,94195.13,74.06,13701.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257849',4908000,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257849',4908001,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257849',4908002,'3062','472',541660.82,543869.92,2209.10,408683.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257849',4908003,'3063','472',82317.91,82393.74,75.83,14028.55,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257849',4908004,'3064','473',168754.25,168967.83,192.16,155649.60,0.00,0.00,21.42,0.00,0.00),('1','206','1030','257850',4908005,'3056','472',88509.03,88970.35,461.32,85344.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257850',4908006,'3057','472',298213.41,301585.85,3372.44,623901.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257850',4908007,'3058','472',409732.14,412300.56,2568.42,475157.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257850',4908008,'3059','472',94195.13,94195.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257850',4908009,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257850',4908010,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257850',4908011,'3062','472',543869.92,547055.75,3185.83,589378.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257850',4908012,'3063','472',82393.74,82447.79,54.05,9999.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257850',4908013,'3064','473',168967.83,168967.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257851',4908014,'3056','472',88970.35,89336.49,366.14,67735.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257851',4908015,'3057','472',301585.85,304134.83,2548.98,471561.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257851',4908016,'3058','472',412300.56,414378.37,2077.81,384394.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257851',4908017,'3059','472',94195.13,94713.62,518.49,95920.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257851',4908018,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257851',4908019,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257851',4908020,'3062','472',547055.75,548902.66,1846.91,341678.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257851',4908021,'3063','472',82447.79,83725.34,1277.55,236346.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257851',4908022,'3064','473',168967.83,169329.56,361.73,293001.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257852',4908023,'3056','472',89336.49,89336.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257852',4908024,'3057','472',304134.83,304134.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257852',4908025,'3058','472',414378.37,416757.04,2378.67,440053.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257852',4908026,'3059','472',94713.62,95195.54,481.92,89155.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257852',4908027,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257852',4908028,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257852',4908029,'3062','472',548902.66,551702.09,2799.43,517894.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257852',4908030,'3063','472',83725.34,83725.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257852',4908031,'3064','473',169329.56,169381.79,52.23,42306.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257853',4908032,'3056','472',89336.49,89583.34,246.85,45667.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257853',4908033,'3057','472',304134.83,305792.98,1658.15,306757.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257853',4908034,'3058','472',416757.04,418147.83,1390.79,257296.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257853',4908035,'3059','472',95195.54,95195.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257853',4908036,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257853',4908037,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257853',4908038,'3062','472',551702.09,552846.81,1144.72,211773.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257853',4908039,'3063','472',83725.34,83807.49,82.15,15197.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257853',4908040,'3064','473',169381.79,169381.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257854',4908041,'3056','472',89583.34,89583.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257854',4908042,'3057','472',305792.98,305792.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257854',4908043,'3058','472',418147.83,420662.80,2514.97,465269.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257854',4908044,'3059','472',95195.54,95277.22,81.68,15110.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257854',4908045,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257854',4908046,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257854',4908047,'3062','472',552846.81,555287.41,2440.60,451511.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257854',4908048,'3063','472',83807.49,83807.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257854',4908049,'3064','473',169381.79,169381.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257855',4908050,'3056','472',89583.34,89642.02,48.68,9005.80,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257855',4908051,'3057','472',305792.98,305969.72,156.74,28996.90,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257855',4908052,'3058','472',420662.80,420942.51,279.71,51746.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257855',4908053,'3059','472',95277.22,95277.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257855',4908054,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257855',4908055,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257855',4908056,'3062','472',555287.41,557422.11,2134.70,394919.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257855',4908057,'3063','472',83807.49,83807.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257855',4908058,'3064','473',169381.79,170270.92,889.13,720195.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257856',4908059,'3056','472',89642.02,89642.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257856',4908060,'3057','472',305969.72,305969.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257856',4908061,'3058','472',420942.51,420942.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257856',4908062,'3059','472',95277.22,95277.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257856',4908063,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257856',4908064,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257856',4908065,'3062','472',557422.11,559713.86,2291.75,423973.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257856',4908066,'3063','472',83807.49,83807.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257856',4908067,'3064','473',170270.92,170924.20,623.28,504856.80,0.00,0.00,30.00,0.00,0.00),('1','206','1030','257857',4908068,'3056','472',89642.02,89954.88,312.86,57879.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257857',4908069,'3057','472',305969.72,307447.75,1478.03,273435.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257857',4908070,'3058','472',420942.51,421147.06,204.55,37841.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257857',4908071,'3059','472',95277.22,95519.43,242.21,44808.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257857',4908072,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257857',4908073,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257857',4908074,'3062','472',559713.86,560764.32,1050.46,194335.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257857',4908075,'3063','472',83807.49,84247.95,440.46,81485.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257857',4908076,'3064','473',170924.20,170924.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257858',4908077,'3056','472',89954.88,89954.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257858',4908078,'3057','472',307447.75,309378.42,1930.67,357173.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257858',4908079,'3058','472',421147.06,422774.68,1627.62,301109.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257858',4908080,'3059','472',95519.43,95519.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257858',4908081,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257858',4908082,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257858',4908083,'3062','472',560764.32,562387.24,1622.92,300240.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257858',4908084,'3063','472',84247.95,84247.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257858',4908085,'3064','473',170924.20,171164.58,240.38,192304.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257859',4908086,'3056','472',89954.88,90384.20,429.32,79424.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257859',4908087,'3057','472',309378.42,311124.34,1745.92,322995.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257859',4908088,'3058','472',422774.68,423251.89,477.21,88283.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257859',4908089,'3059','472',95519.43,95519.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257859',4908090,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257859',4908091,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257859',4908092,'3062','472',562387.24,563675.72,1288.48,238368.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257859',4908093,'3063','472',84247.95,84362.69,114.74,21226.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257859',4908094,'3064','473',171164.58,171179.71,15.13,12104.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257860',4908095,'3056','472',90384.20,90384.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257860',4908096,'3057','472',311124.34,313130.49,2006.15,371137.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257860',4908097,'3058','472',423251.89,424848.98,1597.09,295461.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257860',4908098,'3059','472',95519.43,95539.43,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257860',4908099,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257860',4908100,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257860',4908101,'3062','472',563675.72,565320.73,1645.01,304326.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257860',4908102,'3063','472',84362.69,84441.07,78.38,14500.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257860',4908103,'3064','473',171179.71,171190.97,11.26,9008.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257861',4908104,'3056','472',90384.20,90384.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257861',4908105,'3057','472',313130.49,313923.58,793.09,146721.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257861',4908106,'3058','472',424848.98,425917.63,1068.65,197700.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257861',4908107,'3059','472',95539.43,95574.56,35.13,6499.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257861',4908108,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257861',4908109,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257861',4908110,'3062','472',565320.73,566366.44,1045.71,193456.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257861',4908111,'3063','472',84441.07,84441.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257861',4908112,'3064','473',171190.97,171342.72,151.75,121400.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257862',4908113,'3056','472',90384.20,90656.27,272.07,50332.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257862',4908114,'3057','472',313923.58,315253.27,1329.69,245992.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257862',4908115,'3058','472',425917.63,427439.44,1521.81,281534.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257862',4908116,'3059','472',95574.56,95574.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257862',4908117,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257862',4908118,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257862',4908119,'3062','472',566366.44,567460.28,1093.84,202360.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257862',4908120,'3063','472',84441.07,84489.72,48.65,9000.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257862',4908121,'3064','473',171342.72,172417.72,1075.00,860000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257863',4908122,'3056','472',90656.27,91003.63,347.36,64261.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257863',4908123,'3057','472',315253.27,316634.50,1381.23,255527.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257863',4908124,'3058','472',427439.44,427439.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257863',4908125,'3059','472',95574.56,95574.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257863',4908126,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257863',4908127,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257863',4908128,'3062','472',567460.28,568769.37,1275.04,235882.40,0.00,0.00,34.05,0.00,0.00),('1','206','1030','257863',4908129,'3063','472',84489.72,85104.78,615.06,113786.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257863',4908130,'3064','473',172417.72,172421.22,3.50,2800.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257864',4908131,'3056','472',91003.63,91166.71,163.08,30169.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257864',4908132,'3057','472',316634.50,319064.64,2430.14,449575.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257864',4908133,'3058','472',427439.44,429452.92,2013.48,372493.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257864',4908134,'3059','472',95574.56,95713.43,138.87,25690.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257864',4908135,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257864',4908136,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257864',4908137,'3062','472',568769.37,570573.36,1803.99,333738.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257864',4908138,'3063','472',85104.78,85392.17,287.39,53167.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257864',4908139,'3064','473',172421.22,172508.74,67.52,54016.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257865',4908140,'3056','472',91166.71,91166.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257865',4908141,'3057','472',319064.64,320378.26,1313.62,243019.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257865',4908142,'3058','472',429452.92,430259.60,806.68,149235.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257865',4908143,'3059','472',95713.43,95713.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257865',4908144,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257865',4908145,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257865',4908146,'3062','472',570573.36,571762.04,1188.68,219905.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257865',4908147,'3063','472',85392.17,85392.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257865',4908148,'3064','473',172508.74,172508.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257866',4908149,'3056','472',91166.71,91740.75,574.04,106197.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257866',4908150,'3057','472',320378.26,320982.46,604.20,111777.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257866',4908151,'3058','472',430259.60,431201.98,942.38,174340.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257866',4908152,'3059','472',95713.43,95760.56,47.13,8719.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257866',4908153,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257866',4908154,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257866',4908155,'3062','472',571762.04,572505.96,743.92,137625.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257866',4908156,'3063','472',85392.17,85392.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257866',4908157,'3064','473',172508.74,172830.75,312.01,249608.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257867',4908158,'3056','472',91740.75,92540.31,799.56,147918.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257867',4908159,'3057','472',320982.46,321469.60,487.14,90120.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257867',4908160,'3058','472',431201.98,432098.65,896.67,165883.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257867',4908161,'3059','472',95760.56,95943.85,183.29,33908.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257867',4908162,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257867',4908163,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257867',4908164,'3062','472',572505.96,573335.43,829.47,153451.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257867',4908165,'3063','472',85392.17,85683.91,291.74,53971.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257867',4908166,'3064','473',172830.75,172830.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257868',4908167,'3056','472',92540.31,92732.85,192.54,35619.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257868',4908168,'3057','472',321469.60,322844.95,1375.35,254439.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257868',4908169,'3058','472',432098.65,433404.56,1305.91,241593.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257868',4908170,'3059','472',95943.85,96140.33,196.48,36348.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257868',4908171,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257868',4908172,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257868',4908173,'3062','472',573335.43,574201.46,866.03,160215.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257868',4908174,'3063','472',85683.91,85911.40,227.49,42085.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257868',4908175,'3064','473',172830.75,172830.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257869',4908176,'3056','472',92732.85,93177.31,444.46,82225.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257869',4908177,'3057','472',322844.95,324269.66,1424.71,263571.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257869',4908178,'3058','472',433404.56,433737.92,333.36,61671.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257869',4908179,'3059','472',96140.33,96494.39,354.06,65501.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257869',4908180,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257869',4908181,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257869',4908182,'3062','472',574201.46,574985.31,783.85,145012.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257869',4908183,'3063','472',85911.40,86162.56,251.16,46464.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257869',4908184,'3064','473',172830.75,173681.00,850.25,680200.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257870',4908185,'3056','472',93177.31,93574.76,397.45,73528.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257870',4908186,'3057','472',324269.66,324808.63,538.97,99709.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257870',4908187,'3058','472',433737.92,434545.74,807.82,149446.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257870',4908188,'3059','472',96494.39,96494.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257870',4908189,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257870',4908190,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257870',4908191,'3062','472',574985.31,575782.14,796.83,147413.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257870',4908192,'3063','472',86162.56,86220.93,58.37,10798.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257870',4908193,'3064','473',173681.00,174059.13,358.13,286504.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257871',4908194,'3056','472',93574.76,94127.28,552.52,102216.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257871',4908195,'3057','472',324808.63,325830.22,1021.59,188994.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257871',4908196,'3058','472',434545.74,435502.96,957.22,177085.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257871',4908197,'3059','472',96494.39,96714.64,220.25,40746.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257871',4908198,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257871',4908199,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257871',4908200,'3062','472',575782.14,576062.03,279.89,51779.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257871',4908201,'3063','472',86220.93,86648.94,428.01,79181.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257871',4908202,'3064','473',174059.13,174106.88,47.75,38200.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257872',4908203,'3056','472',94127.28,94596.04,468.76,86720.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257872',4908204,'3057','472',325830.22,326714.50,884.28,163591.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257872',4908205,'3058','472',435502.96,436463.29,960.33,177661.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257872',4908206,'3059','472',96714.64,96835.57,120.93,22372.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257872',4908207,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257872',4908208,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257872',4908209,'3062','472',576062.03,576759.02,696.99,128943.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257872',4908210,'3063','472',86648.94,86991.19,342.25,63316.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257872',4908211,'3064','473',174106.88,174231.26,124.38,99504.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257873',4908212,'3056','472',94596.04,95145.09,549.05,101574.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257873',4908213,'3057','472',326714.50,327569.02,854.52,158086.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257873',4908214,'3058','472',436463.29,437593.13,1129.84,209020.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257873',4908215,'3059','472',96835.57,97009.79,174.22,32230.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257873',4908216,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257873',4908217,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257873',4908218,'3062','472',576759.02,577315.79,556.77,103002.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257873',4908219,'3063','472',86991.19,87360.92,369.73,68400.05,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257873',4908220,'3064','473',174231.26,174231.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257874',4908221,'3056','472',95145.09,95994.74,849.65,157185.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257874',4908222,'3057','472',327569.02,328937.99,1368.97,253259.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257874',4908223,'3058','472',437593.13,438806.67,1213.54,224504.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257874',4908224,'3059','472',97009.79,97367.01,357.22,66085.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257874',4908225,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257874',4908226,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257874',4908227,'3062','472',577315.79,578870.96,1555.17,287706.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257874',4908228,'3063','472',87360.92,87489.00,128.08,23694.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257874',4908229,'3064','473',174231.26,174256.26,25.00,20000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257875',4908230,'3056','472',95994.74,97245.79,1251.05,231444.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257875',4908231,'3057','472',328937.99,329790.64,852.65,157740.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257875',4908232,'3058','472',438806.67,439610.81,804.14,148765.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257875',4908233,'3059','472',97367.01,98059.82,692.81,128169.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257875',4908234,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257875',4908235,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257875',4908236,'3062','472',578870.96,579934.17,1063.21,196693.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257875',4908237,'3063','472',87489.00,88033.72,544.72,100773.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257875',4908238,'3064','473',174256.26,174274.39,18.13,14504.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257876',4908239,'3056','472',97245.79,98226.34,960.55,177701.75,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257876',4908240,'3057','472',329790.64,330501.97,691.33,127896.05,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257876',4908241,'3058','472',439610.81,440712.19,1081.38,200055.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257876',4908242,'3059','472',98059.82,98450.54,370.72,68583.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257876',4908243,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257876',4908244,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257876',4908245,'3062','472',579934.17,580933.16,978.99,181113.15,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257876',4908246,'3063','472',88033.72,88508.23,454.51,84084.35,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257876',4908247,'3064','473',174274.39,174290.64,16.25,13000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257877',4908248,'3056','472',98226.34,99110.02,883.68,163480.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257877',4908249,'3057','472',330501.97,332196.97,1695.00,313575.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257877',4908250,'3058','472',440712.19,442187.05,1474.86,272849.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257877',4908251,'3059','472',98450.54,98974.34,523.80,96903.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257877',4908252,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257877',4908253,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257877',4908254,'3062','472',580933.16,581929.38,996.22,184300.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257877',4908255,'3063','472',88508.23,89859.53,1351.30,249990.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257877',4908256,'3064','473',174290.64,174386.39,95.75,76600.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257878',4908257,'3056','472',99110.02,99870.39,760.37,140668.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257878',4908258,'3057','472',332196.97,333528.94,1331.97,246414.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257878',4908259,'3058','472',442187.05,443339.72,1152.67,213243.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257878',4908260,'3059','472',98974.34,99407.48,433.14,80130.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257878',4908261,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257878',4908262,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257878',4908263,'3062','472',581929.38,583221.01,1291.63,238951.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257878',4908264,'3063','472',89859.53,90477.91,618.38,114400.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257878',4908265,'3064','473',174386.39,174768.89,347.50,278000.00,0.00,0.00,35.00,0.00,0.00),('1','206','1030','257879',4908266,'3056','472',99870.39,100982.35,1111.96,205712.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257879',4908267,'3057','472',333528.94,335418.20,1889.26,349513.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257879',4908268,'3058','472',443339.72,445202.99,1863.27,344704.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257879',4908269,'3059','472',99407.48,99822.99,415.51,76869.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257879',4908270,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257879',4908271,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257879',4908272,'3062','472',583221.01,584959.85,1738.84,321685.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257879',4908273,'3063','472',90477.91,91534.89,1056.98,195541.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257879',4908274,'3064','473',174768.89,174787.27,18.38,14704.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257880',4908275,'3056','472',100982.35,101296.94,314.59,58199.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257880',4908276,'3057','472',335418.20,335701.31,283.11,52375.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257880',4908277,'3058','472',445202.99,445202.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257880',4908278,'3059','472',99822.99,99822.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257880',4908279,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257880',4908280,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257880',4908281,'3062','472',584959.85,585370.53,410.68,75975.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257880',4908282,'3063','472',91534.89,91704.88,169.99,31448.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257880',4908283,'3064','473',174787.27,174787.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257881',4908284,'3056','472',101296.94,101296.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257881',4908285,'3057','472',335701.31,335701.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257881',4908286,'3058','472',445202.99,445681.03,478.04,88437.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257881',4908287,'3059','472',99822.99,99822.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257881',4908288,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257881',4908289,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257881',4908290,'3062','472',585370.53,588030.91,2660.38,492170.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257881',4908291,'3063','472',91704.88,91790.55,85.67,15848.95,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257881',4908292,'3064','473',174787.27,174787.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257882',4908293,'3056','472',101296.94,101614.06,297.12,54967.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257882',4908294,'3057','472',335701.31,336457.43,736.12,136182.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257882',4908295,'3058','472',445681.03,445965.12,264.09,48856.65,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257882',4908296,'3059','472',99822.99,100129.01,286.02,52913.70,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257882',4908297,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257882',4908298,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257882',4908299,'3062','472',588030.91,589630.84,1579.93,292287.05,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257882',4908300,'3063','472',91790.55,92044.75,234.20,43327.00,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257882',4908301,'3064','473',174787.27,176676.08,1868.81,1495048.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257883',4908302,'3056','472',101614.06,102161.22,547.16,101224.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257883',4908303,'3057','472',336457.43,337283.07,825.64,152743.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257883',4908304,'3058','472',445965.12,446884.29,919.17,170046.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257883',4908305,'3059','472',100129.01,100422.07,293.06,54216.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257883',4908306,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257883',4908307,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257883',4908308,'3062','472',589630.84,590025.65,394.81,73039.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257883',4908309,'3063','472',92044.75,92304.10,259.35,47979.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257883',4908310,'3064','473',176676.08,176956.08,280.00,224000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257884',4908311,'3056','472',102161.22,102685.03,523.81,96904.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257884',4908312,'3057','472',337283.07,338044.15,761.08,140799.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257884',4908313,'3058','472',446884.29,446884.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257884',4908314,'3059','472',100422.07,100422.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257884',4908315,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257884',4908316,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257884',4908317,'3062','472',590025.65,590764.26,738.61,136642.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257884',4908318,'3063','472',92304.10,92538.06,233.96,43282.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257884',4908319,'3064','473',176956.08,177007.96,51.88,41504.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257885',4908320,'3056','472',102685.03,103289.70,604.67,111863.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257885',4908321,'3057','472',338044.15,339164.93,1120.78,207344.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257885',4908322,'3058','472',446884.29,447892.45,1008.16,186509.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257885',4908323,'3059','472',100422.07,100819.63,397.56,73548.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257885',4908324,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257885',4908325,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257885',4908326,'3062','472',590764.26,591716.95,952.69,176247.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257885',4908327,'3063','472',92538.06,92988.92,450.86,83409.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257885',4908328,'3064','473',177007.96,177010.46,2.50,2000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257886',4908329,'3056','472',103289.70,104686.61,1396.91,258428.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257886',4908330,'3057','472',339164.93,341044.90,1879.97,347794.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257886',4908331,'3058','472',447892.45,449434.37,1541.92,285255.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257886',4908332,'3059','472',100819.63,101539.61,719.98,133196.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257886',4908333,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257886',4908334,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257886',4908335,'3062','472',591716.95,593258.96,1542.01,285271.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257886',4908336,'3063','472',92988.92,94387.52,1398.60,258741.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257886',4908337,'3064','473',177010.46,177134.71,104.25,83400.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257887',4908338,'3056','472',104686.61,105361.65,675.04,124882.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257887',4908339,'3057','472',341044.90,341543.75,498.85,92287.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257887',4908340,'3058','472',449434.37,449868.00,433.63,80221.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257887',4908341,'3059','472',101539.61,101715.94,156.33,28921.05,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257887',4908342,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257887',4908343,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257887',4908344,'3062','472',593258.96,593736.62,477.66,88367.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257887',4908345,'3063','472',94387.52,94894.32,506.80,93758.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257887',4908346,'3064','473',177134.71,177259.71,125.00,100000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257888',4908347,'3056','472',105361.65,105744.40,382.75,70808.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257888',4908348,'3057','472',341543.75,342409.44,865.69,160152.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257888',4908349,'3058','472',449868.00,450766.48,898.48,166218.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257888',4908350,'3059','472',101715.94,101715.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257888',4908351,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257888',4908352,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257888',4908353,'3062','472',593736.62,594517.49,780.87,144460.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257888',4908354,'3063','472',94894.32,95404.00,509.68,94290.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257888',4908355,'3064','473',177259.71,177407.96,148.25,118600.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257889',4908356,'3056','472',105744.40,106316.45,572.05,105829.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257889',4908357,'3057','472',342409.44,342996.21,586.77,108552.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257889',4908358,'3058','472',450766.48,451558.14,791.66,146457.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257889',4908359,'3059','472',101715.94,102012.56,270.22,49990.70,0.00,0.00,26.40,0.00,0.00),('1','206','1030','257889',4908360,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257889',4908361,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257889',4908362,'3062','472',594517.49,595004.44,486.95,90085.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257889',4908363,'3063','472',95404.00,95652.41,248.41,45955.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257889',4908364,'3064','473',177407.96,177409.21,1.25,1000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257890',4908365,'3056','472',106316.45,107215.23,898.78,166274.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257890',4908366,'3057','472',342996.21,344236.37,1240.16,229429.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257890',4908367,'3058','472',451558.14,452781.77,1223.63,226371.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257890',4908368,'3059','472',102012.56,102443.88,431.32,79794.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257890',4908369,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257890',4908370,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257890',4908371,'3062','472',595004.44,596957.17,1952.73,361255.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257890',4908372,'3063','472',95652.41,96243.50,591.09,109351.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257890',4908373,'3064','473',177409.21,177410.46,1.25,1000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257891',4908374,'3056','472',107215.23,107763.25,548.02,101383.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257891',4908375,'3057','472',344236.37,344880.93,644.56,119243.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257891',4908376,'3058','472',452781.77,453422.99,641.22,118625.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257891',4908377,'3059','472',102443.88,102740.54,296.66,54882.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257891',4908378,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257891',4908379,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257891',4908380,'3062','472',596957.17,597639.84,682.67,126293.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257891',4908381,'3063','472',96243.50,96528.07,284.57,52645.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257891',4908382,'3064','473',177410.46,177411.71,1.25,1000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257892',4908383,'3056','472',107763.25,108421.26,658.01,121731.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257892',4908384,'3057','472',344880.93,346097.86,1216.93,225132.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257892',4908385,'3058','472',453422.99,454307.73,884.74,163676.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257892',4908386,'3059','472',102740.54,103018.91,278.37,51498.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257892',4908387,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257892',4908388,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257892',4908389,'3062','472',597639.84,598665.25,1025.41,189700.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257892',4908390,'3063','472',96528.07,96973.74,445.67,82448.95,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257892',4908391,'3064','473',177411.71,177574.21,162.50,130000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257893',4908392,'3056','472',108421.26,109052.13,618.44,114411.40,0.00,0.00,12.43,0.00,0.00),('1','206','1030','257893',4908393,'3057','472',346097.86,346796.64,686.35,126974.75,0.00,0.00,12.43,0.00,0.00),('1','206','1030','257893',4908394,'3058','472',454307.73,455156.96,836.80,154808.00,0.00,0.00,12.43,0.00,0.00),('1','206','1030','257893',4908395,'3059','472',103018.91,103271.97,240.63,44516.55,0.00,0.00,12.43,0.00,0.00),('1','206','1030','257893',4908396,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257893',4908397,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257893',4908398,'3062','472',598665.25,599216.31,538.63,99646.55,0.00,0.00,12.43,0.00,0.00),('1','206','1030','257893',4908399,'3063','472',96973.74,97214.46,228.29,42233.65,0.00,0.00,12.43,0.00,0.00),('1','206','1031','257893',4908400,'3064','473',177574.21,179094.21,1520.00,1216000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257894',4908401,'3056','472',109052.13,109424.93,372.80,68968.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257894',4908402,'3057','472',346796.64,347750.52,953.88,176467.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257894',4908403,'3058','472',455156.96,456242.30,1085.34,200787.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257894',4908404,'3059','472',103271.97,103529.32,257.35,47609.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257894',4908405,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257894',4908406,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257894',4908407,'3062','472',599216.31,599843.28,626.97,115989.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257894',4908408,'3063','472',97214.46,97540.00,325.54,60224.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257894',4908409,'3064','473',179094.21,179094.71,0.50,400.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257895',4908410,'3056','472',109424.93,109869.40,444.47,82226.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257895',4908411,'3057','472',347750.52,348554.03,803.51,148649.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257895',4908412,'3058','472',456242.30,456914.38,672.08,124334.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257895',4908413,'3059','472',103529.32,103999.77,470.45,87033.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257895',4908414,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257895',4908415,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257895',4908416,'3062','472',599843.28,600353.93,510.65,94470.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257895',4908417,'3063','472',97540.00,97893.85,353.85,65462.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257895',4908418,'3064','473',179094.71,179396.01,301.30,241040.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257896',4908419,'3056','472',109869.40,110581.55,712.15,131747.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257896',4908420,'3057','472',348554.03,349286.96,732.93,135592.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257896',4908421,'3058','472',456914.38,457750.81,836.43,154739.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257896',4908422,'3059','472',103999.77,104219.73,219.96,40692.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257896',4908423,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257896',4908424,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257896',4908425,'3062','472',600353.93,601600.87,1246.94,230683.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257896',4908426,'3063','472',97893.85,98074.80,180.95,33475.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257896',4908427,'3064','473',179396.01,179552.45,156.44,125152.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257897',4908428,'3056','472',110581.55,111439.17,857.62,158659.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257897',4908429,'3057','472',349286.96,349991.74,704.78,130384.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257897',4908430,'3058','472',457750.81,458285.65,534.84,98945.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257897',4908431,'3059','472',104219.73,104477.39,257.66,47667.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257897',4908432,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257897',4908433,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257897',4908434,'3062','472',601600.87,602144.67,543.80,100603.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257897',4908435,'3063','472',98074.80,98295.78,220.98,40881.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257897',4908436,'3064','473',179552.45,179927.45,375.00,300000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257898',4908437,'3056','472',111439.17,111930.94,491.77,90977.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257898',4908438,'3057','472',349991.74,350935.74,944.00,174640.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257898',4908439,'3058','472',458285.65,459037.89,752.24,139164.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257898',4908440,'3059','472',104477.39,104715.07,237.68,43970.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257898',4908441,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257898',4908442,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257898',4908443,'3062','472',602144.67,602851.54,706.87,130770.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257898',4908444,'3063','472',98295.78,98571.11,275.33,50936.05,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257898',4908445,'3064','473',179927.45,180124.09,196.64,157312.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257899',4908446,'3056','472',111930.94,112082.29,151.35,27999.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257899',4908447,'3057','472',350935.74,351216.22,280.48,51888.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257899',4908448,'3058','472',459037.89,459951.11,913.22,168945.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257899',4908449,'3059','472',104715.07,105145.75,430.68,79675.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257899',4908450,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257899',4908451,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257899',4908452,'3062','472',602851.54,603379.18,527.64,97613.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257899',4908453,'3063','472',98571.11,99003.80,432.69,80047.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257899',4908454,'3064','473',180124.09,180124.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257900',4908455,'3056','472',112082.29,112475.44,393.15,72732.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257900',4908456,'3057','472',351216.22,351979.38,763.16,141184.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257900',4908457,'3058','472',459951.11,460997.40,1046.29,193563.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257900',4908458,'3059','472',105145.75,105267.67,121.92,22555.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257900',4908459,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257900',4908460,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257900',4908461,'3062','472',603379.18,604215.02,835.84,154630.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257900',4908462,'3063','472',99003.80,99478.78,474.98,87871.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257900',4908463,'3064','473',180124.09,180145.84,21.75,17400.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257901',4908464,'3056','472',112475.44,112850.61,375.17,69406.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257901',4908465,'3057','472',351979.38,352631.52,652.14,120645.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257901',4908466,'3058','472',460997.40,461843.98,846.58,156617.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257901',4908467,'3059','472',105267.67,105475.55,187.88,34757.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257901',4908468,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257901',4908469,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257901',4908470,'3062','472',604215.02,605057.32,842.30,155825.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257901',4908471,'3063','472',99478.78,99776.22,297.44,55026.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257901',4908472,'3064','473',180145.84,180224.34,78.50,62800.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257902',4908473,'3056','472',112850.61,113407.20,556.59,102969.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257902',4908474,'3057','472',352631.52,353539.63,908.11,168000.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257902',4908475,'3058','472',461843.98,462657.67,813.69,150532.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257902',4908476,'3059','472',105475.55,105821.74,346.19,64045.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257902',4908477,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257902',4908478,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257902',4908479,'3062','472',605057.32,605897.33,840.01,155401.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257902',4908480,'3063','472',99776.22,99983.14,206.92,38280.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257902',4908481,'3064','473',180224.34,180568.35,324.01,259208.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257903',4908482,'3056','472',113407.20,113771.75,364.55,67441.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257903',4908483,'3057','472',353539.63,354352.49,812.86,150379.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257903',4908484,'3058','472',462657.67,463201.12,543.45,100538.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257903',4908485,'3059','472',105821.74,106013.25,191.51,35429.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257903',4908486,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257903',4908487,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257903',4908488,'3062','472',605897.33,606219.19,311.86,57694.10,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257903',4908489,'3063','472',99983.14,100139.14,156.00,28860.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257903',4908490,'3064','473',180568.35,180568.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257904',4908491,'3056','472',113771.75,113842.83,71.08,13149.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257904',4908492,'3057','472',354352.49,354546.55,194.06,35901.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257904',4908493,'3058','472',463201.12,464212.34,1011.22,187075.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257904',4908494,'3059','472',106013.25,106336.11,322.86,59729.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257904',4908495,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257904',4908496,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257904',4908497,'3062','472',606219.19,607030.18,810.99,150033.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257904',4908498,'3063','472',100139.14,100547.39,408.25,75526.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257904',4908499,'3064','473',180568.35,181708.43,1140.08,912064.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257905',4908500,'3056','472',113842.83,114418.54,575.71,106506.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257905',4908501,'3057','472',354546.55,355506.34,959.79,177561.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257905',4908502,'3058','472',464212.34,465223.45,1011.11,187055.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257905',4908503,'3059','472',106336.11,106763.38,427.27,79044.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257905',4908504,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257905',4908505,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257905',4908506,'3062','472',607030.18,607744.61,714.43,132169.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257905',4908507,'3063','472',100547.39,100837.00,289.61,53577.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257905',4908508,'3064','473',181708.43,181848.43,140.00,112000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257906',4908509,'3056','472',114418.54,115386.34,967.80,179043.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257906',4908510,'3057','472',355506.34,356673.74,1167.40,215969.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257906',4908511,'3058','472',465223.45,465223.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257906',4908512,'3059','472',106763.38,106763.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257906',4908513,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257906',4908514,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257906',4908515,'3062','472',607744.61,608686.78,942.17,174301.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257906',4908516,'3063','472',100837.00,101696.37,859.37,158983.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257906',4908517,'3064','473',181848.43,182903.81,1035.38,828304.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257907',4908518,'3056','472',115386.34,115917.29,530.95,98225.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257907',4908519,'3057','472',356673.74,357132.10,458.36,84796.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257907',4908520,'3058','472',465223.45,465916.86,693.41,128280.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257907',4908521,'3059','472',106763.38,107189.51,426.13,78834.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257907',4908522,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257907',4908523,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257907',4908524,'3062','472',608686.78,609603.33,916.55,169561.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257907',4908525,'3063','472',101696.37,102019.93,323.56,59858.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257907',4908526,'3064','473',182903.81,183021.06,117.25,93800.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257908',4908527,'3056','472',115917.29,116475.91,558.62,103344.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257908',4908528,'3057','472',357132.10,357923.75,791.65,146455.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257908',4908529,'3058','472',465916.86,466802.65,885.79,163871.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257908',4908530,'3059','472',107189.51,107517.68,328.17,60711.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257908',4908531,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257908',4908532,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257908',4908533,'3062','472',609603.33,610273.22,669.89,123929.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257908',4908534,'3063','472',102019.93,102183.34,163.41,30230.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257908',4908535,'3064','473',183021.06,183680.82,659.76,527808.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257909',4908536,'3056','472',116475.91,117043.41,567.50,104987.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257909',4908537,'3057','472',357923.75,358909.25,985.50,182317.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257909',4908538,'3058','472',466802.65,467533.96,731.31,135292.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257909',4908539,'3059','472',107517.68,107818.91,301.23,55727.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257909',4908540,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257909',4908541,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257909',4908542,'3062','472',610273.22,610712.62,439.40,81289.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257909',4908543,'3063','472',102183.34,102542.81,359.47,66501.95,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257909',4908544,'3064','473',183680.82,183719.95,39.13,31304.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257910',4908545,'3056','472',117043.41,117701.21,657.80,121693.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257910',4908546,'3057','472',358909.25,359947.13,1037.88,192007.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257910',4908547,'3058','472',467533.96,468606.51,1072.55,198421.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257910',4908548,'3059','472',107818.91,108261.87,442.96,81947.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257910',4908549,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257910',4908550,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257910',4908551,'3062','472',610712.62,611892.40,1179.78,218259.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257910',4908552,'3063','472',102542.81,102908.36,365.55,67626.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257910',4908553,'3064','473',183719.95,183741.83,11.88,9504.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257911',4908554,'3056','472',117701.21,118389.37,688.16,127309.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257911',4908555,'3057','472',359947.13,361301.33,1354.20,250527.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257911',4908556,'3058','472',468606.51,469956.15,1349.64,249683.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257911',4908557,'3059','472',108261.87,108606.01,344.14,63665.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257911',4908558,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257911',4908559,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257911',4908560,'3062','472',611892.40,612835.14,942.74,174406.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257911',4908561,'3063','472',102908.36,103646.06,737.70,136474.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257911',4908562,'3064','473',183741.83,183791.83,50.00,40000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257912',4908563,'3056','472',118389.37,119645.75,1256.38,232430.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257912',4908564,'3057','472',361301.33,362259.34,958.01,177231.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257912',4908565,'3058','472',469956.15,471310.08,1333.93,246777.05,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257912',4908566,'3059','472',108606.01,109060.01,454.00,83990.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257912',4908567,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257912',4908568,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257912',4908569,'3062','472',612835.14,614163.85,1328.71,245811.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257912',4908570,'3063','472',103646.06,104269.35,623.29,115308.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257912',4908571,'3064','473',183791.83,183797.84,6.01,4808.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257913',4908572,'3056','472',119645.75,120349.58,703.83,130208.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257913',4908573,'3057','472',362259.34,362796.59,537.25,99391.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257913',4908574,'3058','472',471310.08,472125.75,815.67,150898.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257913',4908575,'3059','472',109060.01,109502.29,442.28,81821.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257913',4908576,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257913',4908577,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257913',4908578,'3062','472',614163.85,615158.07,994.22,183930.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257913',4908579,'3063','472',104269.35,104550.94,281.59,52094.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257913',4908580,'3064','473',183797.84,183797.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257914',4908581,'3056','472',120349.58,120690.50,340.92,63070.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257914',4908582,'3057','472',362796.59,363537.12,740.53,136998.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257914',4908583,'3058','472',472125.75,472848.94,723.19,133790.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257914',4908584,'3059','472',109502.29,109854.79,317.37,58713.45,0.00,0.00,35.13,0.00,0.00),('1','206','1030','257914',4908585,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257914',4908586,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257914',4908587,'3062','472',615158.07,615982.92,824.85,152597.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257914',4908588,'3063','472',104550.94,104913.59,362.65,67090.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257914',4908589,'3064','473',183797.84,184160.34,350.00,280000.00,0.00,0.00,12.50,0.00,0.00),('1','206','1030','257915',4908590,'3056','472',120690.50,121426.98,736.48,136248.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257915',4908591,'3057','472',363537.12,363955.21,418.09,77346.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257915',4908592,'3058','472',472848.94,473547.74,698.80,129278.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257915',4908593,'3059','472',109854.79,110306.88,452.09,83636.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257915',4908594,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257915',4908595,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257915',4908596,'3062','472',615982.92,616929.46,946.54,175109.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257915',4908597,'3063','472',104913.59,105169.27,255.68,47300.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257915',4908598,'3064','473',184160.34,184160.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257916',4908599,'3056','472',121426.98,122225.54,798.56,147733.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257916',4908600,'3057','472',363955.21,365170.85,1215.64,224893.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257916',4908601,'3058','472',473547.74,474536.32,988.58,182887.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257916',4908602,'3059','472',110306.88,110568.69,261.81,48434.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257916',4908603,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257916',4908604,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257916',4908605,'3062','472',616929.46,617897.80,968.34,179142.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257916',4908606,'3063','472',105169.27,105574.03,404.76,74880.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257916',4908607,'3064','473',184160.34,184160.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257917',4908608,'3056','472',122225.54,123059.95,834.41,154365.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257917',4908609,'3057','472',365170.85,366046.29,875.44,161956.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257917',4908610,'3058','472',474536.32,475598.57,1062.25,196516.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257917',4908611,'3059','472',110568.69,110904.36,335.67,62098.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257917',4908612,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257917',4908613,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257917',4908614,'3062','472',617897.80,618910.46,1012.66,187342.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257917',4908615,'3063','472',105574.03,105946.45,372.42,68897.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257917',4908616,'3064','473',184160.34,184160.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257918',4908617,'3056','472',123059.95,123059.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257918',4908618,'3057','472',366046.29,366518.47,443.27,82004.95,0.00,0.00,28.91,0.00,0.00),('1','206','1030','257918',4908619,'3058','472',475598.57,478123.54,2524.97,467119.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257918',4908620,'3059','472',110904.36,111656.76,752.40,139194.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257918',4908621,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257918',4908622,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257918',4908623,'3062','472',618910.46,620884.51,1974.05,365199.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257918',4908624,'3063','472',105946.45,106439.19,492.74,91156.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257918',4908625,'3064','473',184160.34,184160.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257919',4908626,'3056','472',123059.95,123635.60,575.65,106495.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257919',4908627,'3057','472',366518.47,367439.95,921.48,170473.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257919',4908628,'3058','472',478123.54,479195.91,1072.37,198388.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257919',4908629,'3059','472',111656.76,112021.53,364.77,67482.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257919',4908630,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257919',4908631,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257919',4908632,'3062','472',620884.51,621657.29,772.78,142964.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257919',4908633,'3063','472',106439.19,106803.60,364.41,67415.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257919',4908634,'3064','473',184160.34,184160.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257920',4908635,'3056','472',123635.60,124276.40,640.80,118548.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257920',4908636,'3057','472',367439.95,368321.88,881.93,163157.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257920',4908637,'3058','472',479195.91,480216.20,1020.29,188753.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257920',4908638,'3059','472',112021.53,112199.83,178.30,32985.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257920',4908639,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257920',4908640,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257920',4908641,'3062','472',621657.29,622864.93,1207.64,223413.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257920',4908642,'3063','472',106803.60,107072.66,269.06,49776.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257920',4908643,'3064','473',184160.34,184454.78,288.68,230944.00,0.00,0.00,5.76,0.00,0.00),('1','206','1030','257921',4908644,'3056','472',124276.40,124864.10,587.70,108724.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257921',4908645,'3057','472',368321.88,368759.45,437.57,80950.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257921',4908646,'3058','472',480216.20,480853.21,637.01,117846.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257921',4908647,'3059','472',112199.83,112509.03,309.20,57202.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257921',4908648,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257921',4908649,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257921',4908650,'3062','472',622864.93,623582.27,717.34,132707.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257921',4908651,'3063','472',107072.66,107438.72,366.06,67721.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257921',4908652,'3064','473',184454.78,184454.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257922',4908653,'3056','472',124864.10,125277.35,413.25,76451.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257922',4908654,'3057','472',368759.45,369949.35,1189.90,220131.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257922',4908655,'3058','472',480853.21,481402.05,548.84,101535.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257922',4908656,'3059','472',112509.03,112671.73,162.70,30099.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257922',4908657,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257922',4908658,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257922',4908659,'3062','472',623582.27,624307.72,725.45,134208.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257922',4908660,'3063','472',107438.72,107767.70,328.98,60861.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257922',4908661,'3064','473',184454.78,184454.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257923',4908662,'3056','472',125277.35,125700.04,422.69,78197.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257923',4908663,'3057','472',369949.35,370827.28,877.93,162417.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257923',4908664,'3058','472',481402.05,482051.74,649.69,120192.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257923',4908665,'3059','472',112671.73,112926.99,255.26,47223.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257923',4908666,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257923',4908667,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257923',4908668,'3062','472',624307.72,624932.45,624.73,115575.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257923',4908669,'3063','472',107767.70,108008.79,241.09,44601.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257923',4908670,'3064','473',184454.78,184454.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257924',4908671,'3056','472',125700.04,126119.82,419.78,77659.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257924',4908672,'3057','472',370827.28,371547.45,720.17,133231.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257924',4908673,'3058','472',482051.74,483238.77,1187.03,219600.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257924',4908674,'3059','472',112926.99,113245.45,318.46,58915.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257924',4908675,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257924',4908676,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257924',4908677,'3062','472',624932.45,625516.63,584.18,108073.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257924',4908678,'3063','472',108008.79,108196.04,187.25,34641.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257924',4908679,'3064','473',184454.78,184454.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257925',4908680,'3056','472',126119.82,126751.73,631.91,116903.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257925',4908681,'3057','472',371547.45,372234.64,687.19,127130.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257925',4908682,'3058','472',483238.77,484130.35,891.58,164942.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257925',4908683,'3059','472',113245.45,113399.57,154.12,28512.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257925',4908684,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257925',4908685,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257925',4908686,'3062','472',625516.63,626269.45,752.82,139271.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257925',4908687,'3063','472',108196.04,108578.96,382.92,70840.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257925',4908688,'3064','473',184454.78,184490.73,25.00,20000.00,0.00,0.00,10.95,0.00,0.00),('1','206','1030','257926',4908689,'3056','472',126751.73,127559.95,808.22,149520.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257926',4908690,'3057','472',372234.64,373080.06,833.72,154238.20,0.00,0.00,11.70,0.00,0.00),('1','206','1030','257926',4908691,'3058','472',484130.35,485382.39,1240.34,229462.90,0.00,0.00,11.70,0.00,0.00),('1','206','1030','257926',4908692,'3059','472',113399.57,113957.60,546.33,101071.05,0.00,0.00,11.70,0.00,0.00),('1','206','1030','257926',4908693,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257926',4908694,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257926',4908695,'3062','472',626269.45,627576.53,1295.38,239645.30,0.00,0.00,11.70,0.00,0.00),('1','206','1030','257926',4908696,'3063','472',108578.96,109040.60,461.64,85403.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257926',4908697,'3064','473',184490.73,184584.58,83.85,67080.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257927',4908698,'3056','472',127559.95,128991.53,1431.58,264842.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257927',4908699,'3057','472',373080.06,374234.41,1154.35,213554.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257927',4908700,'3058','472',485382.39,486275.70,893.31,165262.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257927',4908701,'3059','472',113957.60,114954.69,997.09,184461.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257927',4908702,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257927',4908703,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257927',4908704,'3062','472',627576.53,628985.19,1408.66,260602.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257927',4908705,'3063','472',109040.60,109984.09,943.49,174545.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257927',4908706,'3064','473',184584.58,184618.96,34.38,27504.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257928',4908707,'3056','472',128991.53,129858.49,866.96,160387.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257928',4908708,'3057','472',374234.41,375309.97,1075.56,198978.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257928',4908709,'3058','472',486275.70,487081.61,805.91,149093.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257928',4908710,'3059','472',114954.69,115139.44,184.75,34178.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257928',4908711,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257928',4908712,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257928',4908713,'3062','472',628985.19,630072.94,1087.75,201233.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257928',4908714,'3063','472',109984.09,110587.81,603.72,111688.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257928',4908715,'3064','473',184618.96,185418.93,799.97,639976.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257929',4908716,'3056','472',129858.49,130281.18,422.69,78197.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257929',4908717,'3057','472',375309.97,375775.20,465.23,86067.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257929',4908718,'3058','472',487081.61,488069.26,987.65,182715.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257929',4908719,'3059','472',115139.44,115356.90,217.46,40230.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257929',4908720,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257929',4908721,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257929',4908722,'3062','472',630072.94,630881.93,808.99,149663.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257929',4908723,'3063','472',110587.81,110717.68,129.87,24025.95,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257929',4908724,'3064','473',185418.93,185459.56,20.63,16504.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257930',4908725,'3056','472',130281.18,131350.13,1068.95,197755.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257930',4908726,'3057','472',375775.20,376561.86,786.66,145532.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257930',4908727,'3058','472',488069.26,488875.75,806.49,149200.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257930',4908728,'3059','472',115356.90,115882.66,525.76,97265.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257930',4908729,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257930',4908730,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257930',4908731,'3062','472',630881.93,631714.20,832.27,153969.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257930',4908732,'3063','472',110717.68,110950.19,232.51,43014.35,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257930',4908733,'3064','473',185459.56,185590.31,130.75,104600.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257931',4908734,'3056','472',131350.13,131659.85,309.72,57298.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257931',4908735,'3057','472',376561.86,377368.38,806.52,149206.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257931',4908736,'3058','472',488875.75,489764.57,868.82,160731.70,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257931',4908737,'3059','472',115882.66,116140.60,257.94,47718.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257931',4908738,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257931',4908739,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257931',4908740,'3062','472',631714.20,633436.06,1721.86,318544.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257931',4908741,'3063','472',110950.19,111727.06,776.87,143720.95,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257931',4908742,'3064','473',185590.31,185590.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257932',4908743,'3056','472',131659.85,132775.94,1116.09,206476.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257932',4908744,'3057','472',377368.38,379420.52,2052.14,379645.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257932',4908745,'3058','472',489764.57,491613.27,1848.70,342009.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257932',4908746,'3059','472',116140.60,117217.02,1076.42,199137.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257932',4908747,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257932',4908748,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257932',4908749,'3062','472',633436.06,635431.26,1995.20,369112.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257932',4908750,'3063','472',111727.06,113102.51,1375.45,254458.25,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257932',4908751,'3064','473',185590.31,185590.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257933',4908752,'3056','472',132775.94,133269.06,493.12,91227.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257933',4908753,'3057','472',379420.52,380715.93,1274.87,235850.95,0.00,0.00,20.54,0.00,0.00),('1','206','1030','257933',4908754,'3058','472',491613.27,492417.16,783.35,144919.75,0.00,0.00,20.54,0.00,0.00),('1','206','1030','257933',4908755,'3059','472',117217.02,117517.31,279.75,51753.75,0.00,0.00,20.54,0.00,0.00),('1','206','1030','257933',4908756,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257933',4908757,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257933',4908758,'3062','472',635431.26,636325.31,873.51,161599.35,0.00,0.00,20.54,0.00,0.00),('1','206','1030','257933',4908759,'3063','472',113102.51,113519.70,417.19,77180.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257933',4908760,'3064','473',185590.31,185590.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257934',4908761,'3056','472',133269.06,133269.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257934',4908762,'3057','472',380715.93,380715.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257934',4908763,'3058','472',492417.16,492417.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257934',4908764,'3059','472',117517.31,117517.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257934',4908765,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257934',4908766,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257934',4908767,'3062','472',636325.31,637423.63,1098.32,203189.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257934',4908768,'3063','472',113519.70,113519.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257934',4908769,'3064','473',185590.31,188561.05,2950.74,2390099.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257935',4908770,'3056','472',133269.06,133298.29,29.23,5407.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257935',4908771,'3057','472',380715.93,380750.57,34.64,6408.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257935',4908772,'3058','472',492417.16,492511.27,94.11,17410.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257935',4908773,'3059','472',117517.31,117546.67,29.36,5431.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257935',4908774,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257935',4908775,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257935',4908776,'3062','472',637423.63,638189.01,765.38,141595.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257935',4908777,'3063','472',113519.70,113538.63,18.93,3502.05,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257935',4908778,'3064','473',188561.05,190032.31,1471.26,1191720.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257936',4908779,'3056','472',133298.29,133298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257936',4908780,'3057','472',380750.57,380750.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257936',4908781,'3058','472',492511.27,492511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257936',4908782,'3059','472',117546.67,117546.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257936',4908783,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257936',4908784,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257936',4908785,'3062','472',638189.01,638983.57,794.56,146993.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257936',4908786,'3063','472',113538.63,113594.30,55.67,10298.95,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257936',4908787,'3064','473',190032.31,190063.30,30.99,25101.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257937',4908788,'3056','472',133298.29,133298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257937',4908789,'3057','472',380750.57,380750.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257937',4908790,'3058','472',492511.27,492511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257937',4908791,'3059','472',117546.67,117546.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257937',4908792,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257937',4908793,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257937',4908794,'3062','472',638983.57,639969.24,985.67,182348.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257937',4908795,'3063','472',113594.30,113621.33,27.03,5000.55,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257937',4908796,'3064','473',190063.30,191165.09,1101.79,892449.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257938',4908797,'3056','472',133298.29,133298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257938',4908798,'3057','472',380750.57,380750.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257938',4908799,'3058','472',492511.27,492511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257938',4908800,'3059','472',117546.67,117546.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257938',4908801,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257938',4908802,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257938',4908803,'3062','472',639969.24,640291.82,322.58,59677.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257938',4908804,'3063','472',113621.33,113621.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257938',4908805,'3064','473',191165.09,191731.49,553.54,448367.40,0.00,0.00,12.86,0.00,0.00),('1','206','1030','257939',4908806,'3056','472',133298.29,133298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257939',4908807,'3057','472',380750.57,380750.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257939',4908808,'3058','472',492511.27,492511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257939',4908809,'3059','472',117546.67,117546.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257939',4908810,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257939',4908811,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257939',4908812,'3062','472',640291.82,640477.02,175.20,32412.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257939',4908813,'3063','472',113621.33,113621.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257939',4908814,'3064','473',191731.49,192311.88,580.39,470115.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257940',4908815,'3056','472',133298.29,133298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257940',4908816,'3057','472',380750.57,380750.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257940',4908817,'3058','472',492511.27,492511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257940',4908818,'3059','472',117546.67,117546.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257940',4908819,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257940',4908820,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257940',4908821,'3062','472',640477.02,640877.20,390.18,72183.30,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257940',4908822,'3063','472',113621.33,113621.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257940',4908823,'3064','473',192311.88,194108.54,1766.66,1448661.20,0.00,0.00,30.00,0.00,0.00),('1','206','1030','257941',4908824,'3056','472',133298.29,133298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257941',4908825,'3057','472',380750.57,380750.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257941',4908826,'3058','472',492511.27,492511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257941',4908827,'3059','472',117546.67,117546.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257941',4908828,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257941',4908829,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257941',4908830,'3062','472',640877.20,641155.49,268.29,49633.65,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257941',4908831,'3063','472',113621.33,113631.33,10.00,1850.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257941',4908832,'3064','473',194108.54,194283.08,154.54,126722.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257942',4908833,'3056','472',133298.29,133298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257942',4908834,'3057','472',380750.57,380750.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257942',4908835,'3058','472',492511.27,492511.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257942',4908836,'3059','472',117546.67,117546.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257942',4908837,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257942',4908838,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257942',4908839,'3062','472',641155.49,641155.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257942',4908840,'3063','472',113631.33,113631.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257942',4908841,'3064','473',194283.08,194283.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257943',4908842,'3056','472',133298.29,133903.20,584.91,108208.35,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257943',4908843,'3057','472',380750.57,381680.77,910.20,168387.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257943',4908844,'3058','472',492511.27,494111.23,1579.96,292292.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257943',4908845,'3059','472',117546.67,118171.35,604.68,111865.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257943',4908846,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257943',4908847,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257943',4908848,'3062','472',641155.49,643135.23,1959.74,362551.90,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257943',4908849,'3063','472',113631.33,114549.70,898.37,166198.45,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257943',4908850,'3064','473',194283.08,195023.68,730.60,606398.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257944',4908851,'3056','472',133903.20,134340.17,436.97,80839.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257944',4908852,'3057','472',381680.77,383384.61,1703.84,315210.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257944',4908853,'3058','472',494111.23,495365.46,1254.23,232032.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257944',4908854,'3059','472',118171.35,119021.13,849.78,157209.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257944',4908855,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257944',4908856,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257944',4908857,'3062','472',643135.23,644766.21,1630.98,301731.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257944',4908858,'3063','472',114549.70,115485.69,935.99,173158.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257944',4908859,'3064','473',195023.68,195394.28,370.60,307598.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257945',4908860,'3056','472',134340.17,134708.26,368.09,68096.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257945',4908861,'3057','472',383384.61,384389.25,1004.64,185858.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257945',4908862,'3058','472',495365.46,496264.00,888.54,164379.90,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257945',4908863,'3059','472',119021.13,119208.16,187.03,34600.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257945',4908864,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257945',4908865,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257945',4908866,'3062','472',644766.21,646674.69,1908.48,353068.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257945',4908867,'3063','472',115485.69,116153.05,667.36,123461.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257945',4908868,'3064','473',195394.28,195394.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257946',4908869,'3056','472',134708.26,134708.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257946',4908870,'3057','472',384389.25,384389.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257946',4908871,'3058','472',496264.00,496264.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257946',4908872,'3059','472',119208.16,119208.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257946',4908873,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257946',4908874,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257946',4908875,'3062','472',646674.69,646674.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257946',4908876,'3063','472',116153.05,116153.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257946',4908877,'3064','473',195394.28,195981.69,587.41,487550.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257947',4908878,'3056','472',134708.26,136425.45,1717.19,317680.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257947',4908879,'3057','472',384389.25,387095.15,2705.90,500591.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257947',4908880,'3058','472',496264.00,499204.12,2940.12,543922.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257947',4908881,'3059','472',119208.16,121820.56,2612.40,483294.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257947',4908882,'3060','472',14942.80,14942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257947',4908883,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257947',4908884,'3062','472',646674.69,649491.84,2817.15,521172.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257947',4908885,'3063','472',116153.05,118406.35,2253.30,416860.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257947',4908886,'3064','473',195981.69,197171.03,1189.34,987152.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257948',4908887,'3056','472',136425.45,137269.20,843.75,156093.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257948',4908888,'3057','472',387095.15,387832.74,737.59,136454.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257948',4908889,'3058','472',499204.12,499204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257948',4908890,'3059','472',121820.56,121820.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257948',4908891,'3060','472',14942.80,17800.49,2841.48,525673.80,0.00,0.00,16.21,0.00,0.00),('1','206','1030','257948',4908892,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257948',4908893,'3062','472',649491.84,650366.25,874.41,161765.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257948',4908894,'3063','472',118406.35,118891.89,485.54,89824.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257948',4908895,'3064','473',197171.03,197219.22,48.19,39997.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257949',4908896,'3056','472',137269.20,137269.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257949',4908897,'3057','472',387832.74,388291.47,458.73,84865.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257949',4908898,'3058','472',499204.12,499204.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257949',4908899,'3059','472',121820.56,121820.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257949',4908900,'3060','472',17800.49,18095.83,295.34,54637.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257949',4908901,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257949',4908902,'3062','472',650366.25,650917.64,551.39,102007.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257949',4908903,'3063','472',118891.89,118894.59,2.70,499.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257949',4908904,'3064','473',197219.22,197654.22,435.00,361050.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257950',4908905,'3056','472',137269.20,137269.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257950',4908906,'3057','472',388291.47,388717.32,425.85,78782.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257950',4908907,'3058','472',499204.12,499785.91,581.79,107631.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257950',4908908,'3059','472',121820.56,121987.17,166.61,30822.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257950',4908909,'3060','472',18095.83,18501.12,405.29,74978.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257950',4908910,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257950',4908911,'3062','472',650917.64,651564.67,647.03,119700.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257950',4908912,'3063','472',118894.59,118894.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257950',4908913,'3064','473',197654.22,197654.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257951',4908914,'3056','472',137269.20,137269.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257951',4908915,'3057','472',388717.32,388717.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257951',4908916,'3058','472',499785.91,500190.46,404.55,74841.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257951',4908917,'3059','472',121987.17,121987.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257951',4908918,'3060','472',18501.12,18501.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257951',4908919,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257951',4908920,'3062','472',651564.67,654741.24,3176.57,587665.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257951',4908921,'3063','472',118894.59,119013.29,118.70,21959.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257951',4908922,'3064','473',197654.22,198066.22,412.00,341960.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257952',4908923,'3056','472',137269.20,137269.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257952',4908924,'3057','472',388717.32,388717.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257952',4908925,'3058','472',500190.46,501036.36,845.90,156491.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257952',4908926,'3059','472',121987.17,121987.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257952',4908927,'3060','472',18501.12,18501.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257952',4908928,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257952',4908929,'3062','472',654741.24,657100.56,2359.32,436474.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257952',4908930,'3063','472',119013.29,119013.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257952',4908931,'3064','473',198066.22,198366.22,300.00,249000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257953',4908932,'3056','472',137269.20,137269.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257953',4908933,'3057','472',388717.32,390011.29,1293.97,239384.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257953',4908934,'3058','472',501036.36,502975.78,1939.42,358792.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257953',4908935,'3059','472',121987.17,122092.96,105.79,19571.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257953',4908936,'3060','472',18501.12,20617.07,2115.95,391450.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257953',4908937,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257953',4908938,'3062','472',657100.56,660337.28,3236.72,598793.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257953',4908939,'3063','472',119013.29,119013.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257953',4908940,'3064','473',198366.22,198482.08,97.86,81223.80,0.00,0.00,18.00,0.00,0.00),('1','206','1030','257954',4908941,'3056','472',137269.20,137269.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257954',4908942,'3057','472',390011.29,390011.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257954',4908943,'3058','472',502975.78,504766.86,1791.08,331349.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257954',4908944,'3059','472',122092.96,122092.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257954',4908945,'3060','472',20617.07,20617.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257954',4908946,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257954',4908947,'3062','472',660337.28,662188.20,1850.92,342420.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257954',4908948,'3063','472',119013.29,119013.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257954',4908949,'3064','473',198482.08,198482.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257955',4908950,'3056','472',137269.20,137269.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257955',4908951,'3057','472',390011.29,390011.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257955',4908952,'3058','472',504766.86,505256.00,489.14,90490.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257955',4908953,'3059','472',122092.96,122092.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257955',4908954,'3060','472',20617.07,21018.31,401.24,74229.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257955',4908955,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257955',4908956,'3062','472',662188.20,665644.47,3456.27,639409.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257955',4908957,'3063','472',119013.29,119187.26,173.97,32184.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257955',4908958,'3064','473',198482.08,198482.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257956',4908959,'3056','472',137269.20,137269.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257956',4908960,'3057','472',390011.29,390011.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257956',4908961,'3058','472',505256.00,505473.73,197.73,36580.05,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257956',4908962,'3059','472',122092.96,122092.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257956',4908963,'3060','472',21018.31,21210.51,172.20,31857.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257956',4908964,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257956',4908965,'3062','472',665644.47,667267.41,1602.94,296543.90,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257956',4908966,'3063','472',119187.26,119187.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257956',4908967,'3064','473',198482.08,198482.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257957',4908968,'3056','472',137269.20,138693.28,1424.08,263454.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257957',4908969,'3057','472',390011.29,392310.81,2299.52,425411.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257957',4908970,'3058','472',505473.73,507380.24,1886.51,349004.35,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257957',4908971,'3059','472',122092.96,122634.58,521.62,96499.70,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257957',4908972,'3060','472',21210.51,23398.99,2188.48,404868.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257957',4908973,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257957',4908974,'3062','472',667267.41,671601.91,4334.50,801882.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257957',4908975,'3063','472',119187.26,119187.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257957',4908976,'3064','473',198482.08,198777.43,275.35,228540.50,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257958',4908977,'3056','472',138693.28,138693.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257958',4908978,'3057','472',392310.81,392310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257958',4908979,'3058','472',507380.24,507380.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257958',4908980,'3059','472',122634.58,122634.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257958',4908981,'3060','472',23398.99,23398.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257958',4908982,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257958',4908983,'3062','472',671601.91,676146.31,4544.40,840714.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257958',4908984,'3063','472',119187.26,119187.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257958',4908985,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257959',4908986,'3056','472',138693.28,139506.11,792.83,154601.85,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257959',4908987,'3057','472',392310.81,396741.13,4410.32,860012.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257959',4908988,'3058','472',507380.24,511104.57,3704.33,722344.35,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257959',4908989,'3059','472',122634.58,123725.62,1071.04,208852.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257959',4908990,'3060','472',23398.99,23398.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257959',4908991,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257959',4908992,'3062','472',676146.31,681550.15,5383.84,1049848.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257959',4908993,'3063','472',119187.26,120171.71,964.45,188067.75,0.00,0.00,20.00,0.00,0.00),('1','206','1031','257959',4908994,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257960',4908995,'3056','472',139506.11,139506.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257960',4908996,'3057','472',396741.13,397365.52,624.39,121756.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257960',4908997,'3058','472',511104.57,511104.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257960',4908998,'3059','472',123725.62,123795.43,69.81,13612.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257960',4908999,'3060','472',23398.99,23398.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257960',4909000,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257960',4909001,'3062','472',681550.15,684145.82,2595.67,506155.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257960',4909002,'3063','472',120171.71,120171.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257960',4909003,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257961',4909004,'3056','472',139506.11,140595.41,1068.80,208416.00,0.00,0.00,20.50,0.00,0.00),('1','206','1030','257961',4909005,'3057','472',397365.52,399950.42,2584.90,504055.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257961',4909006,'3058','472',511104.57,513836.68,2732.11,532761.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257961',4909007,'3059','472',123795.43,124532.87,737.44,143800.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257961',4909008,'3060','472',23398.99,23398.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257961',4909009,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257961',4909010,'3062','472',684145.82,685990.51,1844.69,359714.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257961',4909011,'3063','472',120171.71,122846.21,2674.50,521527.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257961',4909012,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257962',4909013,'3056','472',140595.41,140914.48,319.07,62218.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257962',4909014,'3057','472',399950.42,400492.94,542.52,105791.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257962',4909015,'3058','472',513836.68,513836.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257962',4909016,'3059','472',124532.87,124532.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257962',4909017,'3060','472',23398.99,23398.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257962',4909018,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257962',4909019,'3062','472',685990.51,687028.71,1038.20,202449.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257962',4909020,'3063','472',122846.21,122995.51,149.30,29113.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257962',4909021,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257963',4909022,'3056','472',140914.48,140914.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257963',4909023,'3057','472',400492.94,400492.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257963',4909024,'3058','472',513836.68,514393.20,556.52,108521.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257963',4909025,'3059','472',124532.87,124532.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257963',4909026,'3060','472',23398.99,23398.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257963',4909027,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257963',4909028,'3062','472',687028.71,688476.12,1447.41,282244.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257963',4909029,'3063','472',122995.51,123712.42,716.91,139797.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257963',4909030,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257964',4909031,'3056','472',140914.48,141321.91,407.43,79448.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257964',4909032,'3057','472',400492.94,402580.60,2087.66,407093.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257964',4909033,'3058','472',514393.20,514894.23,501.03,97700.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257964',4909034,'3059','472',124532.87,124532.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257964',4909035,'3060','472',23398.99,23706.23,307.24,59911.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257964',4909036,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257964',4909037,'3062','472',688476.12,690890.93,2414.81,470887.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257964',4909038,'3063','472',123712.42,124988.73,1276.31,248880.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257964',4909039,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257965',4909040,'3056','472',141321.91,143270.83,1948.92,380039.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257965',4909041,'3057','472',402580.60,404885.13,2304.53,449383.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257965',4909042,'3058','472',514894.23,514894.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257965',4909043,'3059','472',124532.87,124532.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257965',4909044,'3060','472',23706.23,23929.07,222.84,43453.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257965',4909045,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257965',4909046,'3062','472',690890.93,693875.66,2984.73,582022.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257965',4909047,'3063','472',124988.73,128077.76,3089.03,602360.85,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257965',4909048,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257966',4909049,'3056','472',143270.83,143892.38,621.55,121202.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257966',4909050,'3057','472',404885.13,405742.74,857.61,167233.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257966',4909051,'3058','472',514894.23,515805.50,911.27,177697.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257966',4909052,'3059','472',124532.87,124898.86,365.99,71368.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257966',4909053,'3060','472',23929.07,23929.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257966',4909054,'3061','472',112424.98,112424.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257966',4909055,'3062','472',693875.66,695175.16,1299.50,253402.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257966',4909056,'3063','472',128077.76,128854.87,777.11,151536.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257966',4909057,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257967',4909058,'3056','472',143892.38,144321.12,428.74,83604.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257967',4909059,'3057','472',405742.74,406578.15,835.41,162904.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257967',4909060,'3058','472',515805.50,516700.39,894.89,174503.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257967',4909061,'3059','472',124898.86,125419.21,520.35,101468.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257967',4909062,'3060','472',23929.07,23929.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257967',4909063,'3061','472',112424.98,112425.73,0.75,146.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257967',4909064,'3062','472',695175.16,696902.68,1727.52,336866.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257967',4909065,'3063','472',128854.87,129825.93,971.06,189356.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257967',4909066,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257968',4909067,'3056','472',144321.12,145021.91,700.79,136654.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257968',4909068,'3057','472',406578.15,407696.22,1118.07,218023.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257968',4909069,'3058','472',516700.39,518633.78,1933.39,377011.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257968',4909070,'3059','472',125419.21,127583.99,2164.78,422132.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257968',4909071,'3060','472',23929.07,23929.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257968',4909072,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257968',4909073,'3062','472',696902.68,699344.33,2441.65,476121.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257968',4909074,'3063','472',129825.93,132625.60,2799.67,545935.65,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257968',4909075,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257969',4909076,'3056','472',145021.91,147049.04,2027.13,395290.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257969',4909077,'3057','472',407696.22,409832.63,2136.41,416599.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257969',4909078,'3058','472',518633.78,520855.25,2221.47,433186.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257969',4909079,'3059','472',127583.99,128604.70,1020.71,199038.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257969',4909080,'3060','472',23929.07,23929.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257969',4909081,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257969',4909082,'3062','472',699344.33,702287.39,2943.06,573896.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257969',4909083,'3063','472',132625.60,133752.70,1127.10,219784.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257969',4909084,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257970',4909085,'3056','472',147049.04,148484.35,1435.31,279885.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257970',4909086,'3057','472',409832.63,411634.84,1789.39,348931.05,0.00,0.00,12.82,0.00,0.00),('1','206','1030','257970',4909087,'3058','472',520855.25,523164.66,2309.41,450334.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257970',4909088,'3059','472',128604.70,130702.52,2097.82,409074.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257970',4909089,'3060','472',23929.07,24313.51,384.44,74965.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257970',4909090,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257970',4909091,'3062','472',702287.39,703961.70,1674.31,326490.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257970',4909092,'3063','472',133752.70,136271.00,2518.30,491068.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257970',4909093,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257971',4909094,'3056','472',148484.35,149370.93,886.58,172883.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257971',4909095,'3057','472',411634.84,413017.52,1382.68,269622.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257971',4909096,'3058','472',523164.66,524368.54,1203.88,234756.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257971',4909097,'3059','472',130702.52,131693.81,991.29,193301.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257971',4909098,'3060','472',24313.51,24313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257971',4909099,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257971',4909100,'3062','472',703961.70,705933.84,1972.14,384567.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257971',4909101,'3063','472',136271.00,137944.22,1673.22,326277.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257971',4909102,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257972',4909103,'3056','472',149370.93,149370.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257972',4909104,'3057','472',413017.52,413017.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257972',4909105,'3058','472',524368.54,524368.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257972',4909106,'3059','472',131693.81,131693.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257972',4909107,'3060','472',24313.51,24313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257972',4909108,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257972',4909109,'3062','472',705933.84,707686.53,1752.69,341774.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257972',4909110,'3063','472',137944.22,138688.13,743.91,145062.45,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257972',4909111,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257973',4909112,'3056','472',149370.93,149576.05,205.12,39998.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257973',4909113,'3057','472',413017.52,413121.48,103.96,20272.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257973',4909114,'3058','472',524368.54,524429.90,61.36,11965.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257973',4909115,'3059','472',131693.81,131724.58,30.77,6000.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257973',4909116,'3060','472',24313.51,24313.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257973',4909117,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257973',4909118,'3062','472',707686.53,709163.63,1477.10,288034.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257973',4909119,'3063','472',138688.13,139748.59,1060.46,206789.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257973',4909120,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257974',4909121,'3056','472',149576.05,151487.97,1911.92,372824.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257974',4909122,'3057','472',413121.48,415603.68,2482.20,484029.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257974',4909123,'3058','472',524429.90,525101.91,672.01,131041.95,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257974',4909124,'3059','472',131724.58,132417.09,692.51,135039.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257974',4909125,'3060','472',24313.51,25228.78,915.27,178477.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257974',4909126,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257974',4909127,'3062','472',709163.63,710874.61,1710.98,333641.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257974',4909128,'3063','472',139748.59,141814.99,2066.40,402948.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257974',4909129,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257975',4909130,'3056','472',151487.97,152359.54,871.57,169956.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257975',4909131,'3057','472',415603.68,416793.82,1190.14,232077.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257975',4909132,'3058','472',525101.91,526275.85,1173.94,228918.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257975',4909133,'3059','472',132417.09,133654.38,1237.29,241271.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257975',4909134,'3060','472',25228.78,26956.43,1727.65,336891.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257975',4909135,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257975',4909136,'3062','472',710874.61,712859.79,1985.18,387110.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257975',4909137,'3063','472',141814.99,143330.88,1515.89,295598.55,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257975',4909138,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257976',4909139,'3056','472',152359.54,154608.87,2249.33,438619.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257976',4909140,'3057','472',416793.82,419903.12,3109.30,606313.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257976',4909141,'3058','472',526275.85,526321.89,46.04,8977.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257976',4909142,'3059','472',133654.38,133654.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257976',4909143,'3060','472',26956.43,27700.73,744.30,145138.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257976',4909144,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257976',4909145,'3062','472',712859.79,716201.46,3341.67,651625.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257976',4909146,'3063','472',143330.88,147044.86,3713.98,724226.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257976',4909147,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257977',4909148,'3056','472',154608.87,156564.57,1955.70,381361.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257977',4909149,'3057','472',419903.12,421561.43,1658.31,323370.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257977',4909150,'3058','472',526321.89,528644.52,2322.63,452912.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257977',4909151,'3059','472',133654.38,135486.43,1832.05,357249.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257977',4909152,'3060','472',27700.73,29494.40,1793.67,349765.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257977',4909153,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257977',4909154,'3062','472',716201.46,719255.80,3054.34,595596.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257977',4909155,'3063','472',147044.86,148793.02,1748.16,340891.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257977',4909156,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257978',4909157,'3056','472',156564.57,157770.66,1206.09,235187.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257978',4909158,'3057','472',421561.43,424484.31,2922.88,569961.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257978',4909159,'3058','472',528644.52,530473.45,1828.93,356641.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257978',4909160,'3059','472',135486.43,137135.23,1648.80,321516.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257978',4909161,'3060','472',29494.40,29494.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257978',4909162,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257978',4909163,'3062','472',719255.80,721002.14,1746.34,340536.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257978',4909164,'3063','472',148793.02,151432.75,2639.73,514747.35,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257978',4909165,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257979',4909166,'3056','472',157770.66,160401.88,2631.22,513087.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257979',4909167,'3057','472',424484.31,427699.13,3214.82,626889.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257979',4909168,'3058','472',530473.45,530586.28,112.83,22001.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257979',4909169,'3059','472',137135.23,137290.90,125.67,24505.65,0.00,0.00,30.00,0.00,0.00),('1','206','1030','257979',4909170,'3060','472',29494.40,30809.49,1285.09,250592.55,0.00,0.00,30.00,0.00,0.00),('1','206','1030','257979',4909171,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257979',4909172,'3062','472',721002.14,721477.62,445.48,86868.60,0.00,0.00,30.00,0.00,0.00),('1','206','1030','257979',4909173,'3063','472',151432.75,152315.24,882.49,172085.55,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257979',4909174,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257980',4909175,'3056','472',160401.88,163490.53,3088.65,602286.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257980',4909176,'3057','472',427699.13,431627.32,3928.19,765997.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257980',4909177,'3058','472',530586.28,530586.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257980',4909178,'3059','472',137290.90,137290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257980',4909179,'3060','472',30809.49,31597.88,788.39,153736.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257980',4909180,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257980',4909181,'3062','472',721477.62,721477.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257980',4909182,'3063','472',152315.24,152315.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257980',4909183,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257981',4909184,'3056','472',163490.53,166299.21,2808.68,547692.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257981',4909185,'3057','472',431627.32,433953.28,2325.96,453562.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257981',4909186,'3058','472',530586.28,530586.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257981',4909187,'3059','472',137290.90,137290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257981',4909188,'3060','472',31597.88,34351.76,2753.88,537006.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257981',4909189,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257981',4909190,'3062','472',721477.62,721477.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257981',4909191,'3063','472',152315.24,152315.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257981',4909192,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257982',4909193,'3056','472',166299.21,169166.77,2867.56,559174.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257982',4909194,'3057','472',433953.28,437082.41,3129.13,610180.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257982',4909195,'3058','472',530586.28,530586.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257982',4909196,'3059','472',137290.90,137290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257982',4909197,'3060','472',34351.76,38553.42,4201.66,819323.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257982',4909198,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257982',4909199,'3062','472',721477.62,721477.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257982',4909200,'3063','472',152315.24,152315.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257982',4909201,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257983',4909202,'3056','472',169166.77,170944.29,1777.52,346616.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257983',4909203,'3057','472',437082.41,438907.74,1815.33,353989.35,0.00,0.00,10.00,0.00,0.00),('1','206','1030','257983',4909204,'3058','472',530586.28,530586.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257983',4909205,'3059','472',137290.90,137290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257983',4909206,'3060','472',38553.42,41267.06,2713.64,529159.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257983',4909207,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257983',4909208,'3062','472',721477.62,721477.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257983',4909209,'3063','472',152315.24,152315.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257983',4909210,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257984',4909211,'3056','472',170944.29,171167.04,222.75,43436.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257984',4909212,'3057','472',438907.74,438907.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257984',4909213,'3058','472',530586.28,530586.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257984',4909214,'3059','472',137290.90,137290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257984',4909215,'3060','472',41267.06,43721.23,2454.17,478563.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257984',4909216,'3061','472',112425.73,112425.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257984',4909217,'3062','472',721477.62,721477.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257984',4909218,'3063','472',152315.24,152315.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257984',4909219,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257985',4909220,'3056','472',171167.04,172548.11,1381.07,269308.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257985',4909221,'3057','472',438907.74,441223.81,2300.05,448509.75,0.00,0.00,16.02,0.00,0.00),('1','206','1030','257985',4909222,'3058','472',530586.28,532525.05,1938.77,378060.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257985',4909223,'3059','472',137290.90,137968.23,677.33,132079.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257985',4909224,'3060','472',43721.23,46586.12,2864.89,558653.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257985',4909225,'3061','472',112425.73,114560.80,2135.07,416338.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257985',4909226,'3062','472',721477.62,722633.22,1155.60,225342.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257985',4909227,'3063','472',152315.24,153408.54,1093.30,213193.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257985',4909228,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257986',4909229,'3056','472',172548.11,173590.64,1042.53,203293.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257986',4909230,'3057','472',441223.81,443042.33,1818.52,354611.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257986',4909231,'3058','472',532525.05,534375.18,1850.13,360775.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257986',4909232,'3059','472',137968.23,139507.12,1538.89,300083.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257986',4909233,'3060','472',46586.12,46586.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257986',4909234,'3061','472',114560.80,114560.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257986',4909235,'3062','472',722633.22,724548.37,1915.15,373454.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257986',4909236,'3063','472',153408.54,155406.11,1997.57,389526.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257986',4909237,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257987',4909238,'3056','472',173590.64,175693.82,2103.18,410120.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257987',4909239,'3057','472',443042.33,445418.81,2376.48,463413.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257987',4909240,'3058','472',534375.18,536687.04,2311.86,450812.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257987',4909241,'3059','472',139507.12,141337.03,1829.91,356832.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257987',4909242,'3060','472',46586.12,46586.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257987',4909243,'3061','472',114560.80,114560.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257987',4909244,'3062','472',724548.37,727377.39,2829.02,551658.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257987',4909245,'3063','472',155406.11,157425.93,2019.82,393864.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257987',4909246,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257988',4909247,'3056','472',175693.82,177631.84,1938.02,377913.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257988',4909248,'3057','472',445418.81,447279.86,1861.05,362904.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257988',4909249,'3058','472',536687.04,536687.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257988',4909250,'3059','472',141337.03,141728.01,390.98,76241.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257988',4909251,'3060','472',46586.12,46586.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257988',4909252,'3061','472',114560.80,114560.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257988',4909253,'3062','472',727377.39,729556.77,2179.38,424979.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257988',4909254,'3063','472',157425.93,159762.23,2336.30,455578.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257988',4909255,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257989',4909256,'3056','472',177631.84,178415.43,783.59,152800.05,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257989',4909257,'3057','472',447279.86,448512.77,1232.91,240417.45,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257989',4909258,'3058','472',536687.04,537539.93,852.89,166313.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257989',4909259,'3059','472',141728.01,142650.74,922.73,179932.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257989',4909260,'3060','472',46586.12,46586.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257989',4909261,'3061','472',114560.80,114560.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257989',4909262,'3062','472',729556.77,730711.70,1154.93,225211.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257989',4909263,'3063','472',159762.23,161103.15,1340.92,261479.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257989',4909264,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257990',4909265,'3056','472',178415.43,179292.63,867.02,169068.90,0.00,0.00,10.18,0.00,0.00),('1','206','1030','257990',4909266,'3057','472',448512.77,449364.41,841.46,164084.70,0.00,0.00,10.18,0.00,0.00),('1','206','1030','257990',4909267,'3058','472',537539.93,538271.95,721.83,140756.85,0.00,0.00,10.19,0.00,0.00),('1','206','1030','257990',4909268,'3059','472',142650.74,143492.28,831.35,162113.25,0.00,0.00,10.19,0.00,0.00),('1','206','1030','257990',4909269,'3060','472',46586.12,46586.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257990',4909270,'3061','472',114560.80,114560.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257990',4909271,'3062','472',730711.70,731704.03,982.14,191517.30,0.00,0.00,10.19,0.00,0.00),('1','206','1030','257990',4909272,'3063','472',161103.15,161927.70,814.36,158800.20,0.00,0.00,10.19,0.00,0.00),('1','206','1031','257990',4909273,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257991',4909274,'3056','472',179292.63,180278.61,985.98,192266.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257991',4909275,'3057','472',449364.41,451244.33,1879.92,366584.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257991',4909276,'3058','472',538271.95,539989.29,1717.34,334881.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257991',4909277,'3059','472',143492.28,144770.24,1277.96,249202.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257991',4909278,'3060','472',46586.12,47502.19,916.07,178633.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257991',4909279,'3061','472',114560.80,115670.13,1109.33,216319.35,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257991',4909280,'3062','472',731704.03,733243.92,1539.89,300278.55,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257991',4909281,'3063','472',161927.70,163541.87,1614.17,314763.15,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257991',4909282,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257992',4909283,'3056','472',180278.61,181097.65,819.04,159712.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257992',4909284,'3057','472',451244.33,451929.75,685.42,133656.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257992',4909285,'3058','472',539989.29,542303.05,2313.76,451183.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257992',4909286,'3059','472',144770.24,146918.71,2148.47,418951.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257992',4909287,'3060','472',47502.19,47502.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257992',4909288,'3061','472',115670.13,115670.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257992',4909289,'3062','472',733243.92,735317.99,2074.07,404443.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257992',4909290,'3063','472',163541.87,166001.25,2459.38,479579.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257992',4909291,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257993',4909292,'3056','472',181097.65,181345.87,248.22,48402.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257993',4909293,'3057','472',451929.75,452263.77,334.02,65133.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257993',4909294,'3058','472',542303.05,543959.27,1656.22,322962.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257993',4909295,'3059','472',146918.71,148446.56,1527.85,297930.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257993',4909296,'3060','472',47502.19,47652.42,150.23,29294.85,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257993',4909297,'3061','472',115670.13,115772.68,102.55,19997.25,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257993',4909298,'3062','472',735317.99,736734.87,1416.88,276291.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257993',4909299,'3063','472',166001.25,167770.64,1769.39,345031.05,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257993',4909300,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257994',4909301,'3056','472',181345.87,181371.51,25.64,4999.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257994',4909302,'3057','472',452263.77,452349.41,77.95,15200.25,0.00,0.00,7.69,0.00,0.00),('1','206','1030','257994',4909303,'3058','472',543959.27,544723.14,763.87,148954.65,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257994',4909304,'3059','472',148446.56,148683.40,236.84,46183.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257994',4909305,'3060','472',47652.42,47652.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257994',4909306,'3061','472',115772.68,115772.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257994',4909307,'3062','472',736734.87,740103.04,3368.17,656793.15,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257994',4909308,'3063','472',167770.64,168094.56,323.92,63164.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257994',4909309,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257995',4909310,'3056','472',181371.51,181371.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257995',4909311,'3057','472',452349.41,452349.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257995',4909312,'3058','472',544723.14,544723.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257995',4909313,'3059','472',148683.40,148683.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257995',4909314,'3060','472',47652.42,47652.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257995',4909315,'3061','472',115772.68,115772.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257995',4909316,'3062','472',740103.04,741313.87,1190.83,232211.85,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257995',4909317,'3063','472',168094.56,168503.34,408.78,79712.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257995',4909318,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257996',4909319,'3056','472',181371.51,181381.76,10.25,1998.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257996',4909320,'3057','472',452349.41,452386.29,36.88,7191.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257996',4909321,'3058','472',544723.14,544753.09,9.95,1940.25,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257996',4909322,'3059','472',148683.40,148713.88,10.48,2043.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','257996',4909323,'3060','472',47652.42,47662.67,10.25,1998.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257996',4909324,'3061','472',115772.68,115782.93,10.25,1998.75,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257996',4909325,'3062','472',741313.87,742741.48,1407.10,274384.50,0.00,0.00,20.51,0.00,0.00),('1','206','1030','257996',4909326,'3063','472',168503.34,168598.59,95.25,18573.75,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257996',4909327,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257997',4909328,'3056','472',181381.76,184180.24,2798.48,587680.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257997',4909329,'3057','472',452386.29,454398.50,2012.21,422564.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257997',4909330,'3058','472',544753.09,547239.03,2485.94,522047.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257997',4909331,'3059','472',148713.88,151263.02,2549.14,535319.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257997',4909332,'3060','472',47662.67,50904.81,3242.14,680849.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257997',4909333,'3061','472',115782.93,115782.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257997',4909334,'3062','472',742741.48,745511.56,2770.08,581716.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257997',4909335,'3063','472',168598.59,170990.45,2391.86,502290.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257997',4909336,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257998',4909337,'3056','472',184180.24,185007.99,827.75,173827.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257998',4909338,'3057','472',454398.50,455493.24,1094.74,229895.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257998',4909339,'3058','472',547239.03,550109.55,2870.52,602809.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257998',4909340,'3059','472',151263.02,153667.99,2404.97,505043.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257998',4909341,'3060','472',50904.81,51711.81,807.00,169470.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257998',4909342,'3061','472',115782.93,116867.31,1084.38,227719.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257998',4909343,'3062','472',745511.56,747593.69,2082.13,437247.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257998',4909344,'3063','472',170990.45,173282.23,2291.78,481273.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257998',4909345,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257999',4909346,'3056','472',185007.99,187470.28,2462.29,517080.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257999',4909347,'3057','472',455493.24,457660.96,2167.72,455221.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257999',4909348,'3058','472',550109.55,551455.53,1345.98,282655.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257999',4909349,'3059','472',153667.99,154774.30,1106.31,232325.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257999',4909350,'3060','472',51711.81,53028.21,1316.40,276444.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257999',4909351,'3061','472',116867.31,117795.29,927.98,194875.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257999',4909352,'3062','472',747593.69,750422.13,2828.44,593972.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','257999',4909353,'3063','472',173282.23,175818.28,2536.05,532570.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','257999',4909354,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258000',4909355,'3056','472',187470.28,187470.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258000',4909356,'3057','472',457660.96,457660.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258000',4909357,'3058','472',551455.53,552661.26,1205.73,253203.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258000',4909358,'3059','472',154774.30,155456.89,682.59,143343.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258000',4909359,'3060','472',53028.21,53028.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258000',4909360,'3061','472',117795.29,117795.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258000',4909361,'3062','472',750422.13,751585.16,1163.03,244236.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258000',4909362,'3063','472',175818.28,176532.88,714.60,150066.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258000',4909363,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258001',4909364,'3056','472',187470.28,187470.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258001',4909365,'3057','472',457660.96,458180.47,519.51,109097.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258001',4909366,'3058','472',552661.26,554431.96,1770.70,371847.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258001',4909367,'3059','472',155456.89,156811.23,1354.34,284411.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258001',4909368,'3060','472',53028.21,53028.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258001',4909369,'3061','472',117795.29,117795.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258001',4909370,'3062','472',751585.16,754687.75,3102.59,651543.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258001',4909371,'3063','472',176532.88,178447.82,1914.94,402137.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258001',4909372,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258002',4909373,'3056','472',187470.28,187470.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258002',4909374,'3057','472',458180.47,458180.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258002',4909375,'3058','472',554431.96,555864.98,1433.02,300934.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258002',4909376,'3059','472',156811.23,157800.89,989.66,207828.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258002',4909377,'3060','472',53028.21,53706.27,678.06,142392.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258002',4909378,'3061','472',117795.29,118372.16,576.87,121142.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258002',4909379,'3062','472',754687.75,756000.34,1312.59,275643.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258002',4909380,'3063','472',178447.82,179605.83,1158.01,243182.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258002',4909381,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258003',4909382,'3056','472',187470.28,189391.83,1921.55,403525.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258003',4909383,'3057','472',458180.47,460127.45,1946.98,408865.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258003',4909384,'3058','472',555864.98,556895.73,1030.75,216457.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258003',4909385,'3059','472',157800.89,158494.99,694.10,145761.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258003',4909386,'3060','472',53706.27,54408.59,702.32,147487.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258003',4909387,'3061','472',118372.16,119209.00,836.84,175736.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258003',4909388,'3062','472',756000.34,757331.28,1330.94,279497.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258003',4909389,'3063','472',179605.83,180517.92,912.09,191538.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258003',4909390,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258004',4909391,'3056','472',189391.83,189391.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258004',4909392,'3057','472',460127.45,460127.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258004',4909393,'3058','472',556895.73,556895.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258004',4909394,'3059','472',158494.99,158494.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258004',4909395,'3060','472',54408.59,54408.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258004',4909396,'3061','472',119209.00,119209.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258004',4909397,'3062','472',757331.28,760370.78,3039.50,638295.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258004',4909398,'3063','472',180517.92,181188.73,670.81,140870.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258004',4909399,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258005',4909400,'3056','472',189391.83,191988.82,2596.99,545367.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258005',4909401,'3057','472',460127.45,462900.73,2773.28,582388.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258005',4909402,'3058','472',556895.73,559454.53,2558.80,537348.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258005',4909403,'3059','472',158494.99,160749.74,2254.75,473497.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258005',4909404,'3060','472',54408.59,56028.52,1619.93,340185.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258005',4909405,'3061','472',119209.00,120779.69,1570.69,329844.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258005',4909406,'3062','472',760370.78,762792.04,2421.26,508464.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258005',4909407,'3063','472',181188.73,182947.99,1759.26,369444.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258005',4909408,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258006',4909409,'3056','472',191988.82,193166.83,1178.01,247382.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258006',4909410,'3057','472',462900.73,463973.65,1072.92,225313.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258006',4909411,'3058','472',559454.53,560966.41,1511.88,317494.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258006',4909412,'3059','472',160749.74,162090.03,1340.29,281460.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258006',4909413,'3060','472',56028.52,56844.45,815.93,171345.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258006',4909414,'3061','472',120779.69,121413.05,633.36,133005.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258006',4909415,'3062','472',762792.04,764135.01,1342.97,282023.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258006',4909416,'3063','472',182947.99,184259.96,1311.97,275513.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258006',4909417,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258007',4909418,'3056','472',193166.83,194174.08,986.82,207232.20,0.00,0.00,20.43,0.00,0.00),('1','206','1030','258007',4909419,'3057','472',463973.65,464991.51,997.43,209460.30,0.00,0.00,20.43,0.00,0.00),('1','206','1030','258007',4909420,'3058','472',560966.41,562916.06,1929.22,405136.20,0.00,0.00,20.43,0.00,0.00),('1','206','1030','258007',4909421,'3059','472',162090.03,163756.57,1646.11,345683.10,0.00,0.00,20.43,0.00,0.00),('1','206','1030','258007',4909422,'3060','472',56844.45,58125.01,1260.13,264627.30,0.00,0.00,20.43,0.00,0.00),('1','206','1030','258007',4909423,'3061','472',121413.05,122618.71,1185.23,248898.30,0.00,0.00,20.43,0.00,0.00),('1','206','1030','258007',4909424,'3062','472',764135.01,765684.90,1529.46,321186.60,0.00,0.00,20.43,0.00,0.00),('1','206','1030','258007',4909425,'3063','472',184259.96,185189.14,929.18,195127.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258007',4909426,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258008',4909427,'3056','472',194174.08,196470.23,2296.15,482191.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258008',4909428,'3057','472',464991.51,468213.06,3221.55,676525.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258008',4909429,'3058','472',562916.06,565446.03,2529.97,531293.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258008',4909430,'3059','472',163756.57,165646.87,1890.30,396963.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258008',4909431,'3060','472',58125.01,60195.70,2070.69,434844.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258008',4909432,'3061','472',122618.71,124567.39,1948.68,409222.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258008',4909433,'3062','472',765684.90,769006.18,3321.28,697468.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258008',4909434,'3063','472',185189.14,187788.72,2599.58,545911.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258008',4909435,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258009',4909436,'3056','472',196470.23,197996.06,1525.83,320424.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258009',4909437,'3057','472',468213.06,469934.66,1721.60,361536.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258009',4909438,'3058','472',565446.03,566268.02,821.99,172617.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258009',4909439,'3059','472',165646.87,166575.76,928.89,195066.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258009',4909440,'3060','472',60195.70,61470.37,1274.67,267680.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258009',4909441,'3061','472',124567.39,126174.93,1607.54,337583.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258009',4909442,'3062','472',769006.18,769866.77,860.59,180723.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258009',4909443,'3063','472',187788.72,188365.40,576.68,121102.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258009',4909444,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258010',4909445,'3056','472',197996.06,199931.85,1935.79,406515.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258010',4909446,'3057','472',469934.66,472049.64,2114.98,444145.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258010',4909447,'3058','472',566268.02,568481.95,2213.93,464925.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258010',4909448,'3059','472',166575.76,167996.03,1420.27,298256.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258010',4909449,'3060','472',61470.37,63809.24,2338.87,491162.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258010',4909450,'3061','472',126174.93,127983.24,1808.31,379745.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258010',4909451,'3062','472',769866.77,771422.57,1555.80,326718.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258010',4909452,'3063','472',188365.40,189940.42,1575.02,330754.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258010',4909453,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258011',4909454,'3056','472',199931.85,200363.57,431.72,90661.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258011',4909455,'3057','472',472049.64,473013.40,963.76,202389.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258011',4909456,'3058','472',568481.95,570884.48,2402.53,504531.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258011',4909457,'3059','472',167996.03,170565.29,2569.26,539544.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258011',4909458,'3060','472',63809.24,65112.92,1303.68,273772.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258011',4909459,'3061','472',127983.24,129684.34,1701.10,357231.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258011',4909460,'3062','472',771422.57,773380.92,1958.35,411253.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258011',4909461,'3063','472',189940.42,192684.77,2744.35,576313.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258011',4909462,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258012',4909463,'3056','472',200363.57,201598.95,1235.38,259429.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258012',4909464,'3057','472',473013.40,474413.18,1399.78,293953.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258012',4909465,'3058','472',570884.48,572193.07,1308.59,274803.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258012',4909466,'3059','472',170565.29,172191.12,1625.83,341424.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258012',4909467,'3060','472',65112.92,65963.26,850.34,178571.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258012',4909468,'3061','472',129684.34,130188.94,504.60,105966.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258012',4909469,'3062','472',773380.92,774521.98,1141.06,239622.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258012',4909470,'3063','472',192684.77,193621.84,937.07,196784.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258012',4909471,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258013',4909472,'3056','472',201598.95,202778.16,1179.21,247634.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258013',4909473,'3057','472',474413.18,475302.26,889.08,186706.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258013',4909474,'3058','472',572193.07,574171.65,1978.58,415501.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258013',4909475,'3059','472',172191.12,174018.53,1827.41,383756.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258013',4909476,'3060','472',65963.26,67276.20,1312.94,275717.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258013',4909477,'3061','472',130188.94,131549.79,1360.85,285778.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258013',4909478,'3062','472',774521.98,776922.97,2400.99,504207.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258013',4909479,'3063','472',193621.84,195670.03,2048.19,430119.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258013',4909480,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258014',4909481,'3056','472',202778.16,205066.48,2288.32,503430.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258014',4909482,'3057','472',475302.26,477731.00,2428.74,534322.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258014',4909483,'3058','472',574171.65,575592.83,1401.18,308259.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258014',4909484,'3059','472',174018.53,174774.15,755.62,166236.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258014',4909485,'3060','472',67276.20,67568.74,292.54,64358.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258014',4909486,'3061','472',131549.79,131825.84,276.05,60731.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258014',4909487,'3062','472',776922.97,779260.95,2337.98,514355.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258014',4909488,'3063','472',195670.03,198175.21,2505.18,551139.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258014',4909489,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258015',4909490,'3056','472',205066.48,205150.57,84.09,18499.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258015',4909491,'3057','472',477731.00,478145.47,414.47,91183.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258015',4909492,'3058','472',575592.83,576992.49,1399.66,307925.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258015',4909493,'3059','472',174774.15,175934.73,1160.58,255327.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258015',4909494,'3060','472',67568.74,68647.20,1078.46,237261.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258015',4909495,'3061','472',131825.84,133196.63,1370.79,301573.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258015',4909496,'3062','472',779260.95,779260.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258015',4909497,'3063','472',198175.21,198175.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258015',4909498,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258016',4909499,'3056','472',205150.57,206244.17,1093.60,240592.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258016',4909500,'3057','472',478145.47,480204.78,2049.50,450890.00,0.00,0.00,9.81,0.00,0.00),('1','206','1030','258016',4909501,'3058','472',576992.49,578366.07,1373.58,302187.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258016',4909502,'3059','472',175934.73,177514.62,1579.89,347575.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258016',4909503,'3060','472',68647.20,68647.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258016',4909504,'3061','472',133196.63,133196.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258016',4909505,'3062','472',779260.95,779260.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258016',4909506,'3063','472',198175.21,198175.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258016',4909507,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258017',4909508,'3056','472',206244.17,206244.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258017',4909509,'3057','472',480204.78,480204.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258017',4909510,'3058','472',578366.07,578366.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258017',4909511,'3059','472',177514.62,177514.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258017',4909512,'3060','472',68647.20,70359.23,1712.03,376646.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258017',4909513,'3061','472',133196.63,134804.38,1607.75,353705.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258017',4909514,'3062','472',779260.95,781275.33,2014.38,443163.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258017',4909515,'3063','472',198175.21,199952.75,1777.54,391058.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258017',4909516,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258018',4909517,'3056','472',206244.17,206244.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258018',4909518,'3057','472',480204.78,482006.31,1801.53,396336.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258018',4909519,'3058','472',578366.07,580563.15,2197.08,483357.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258018',4909520,'3059','472',177514.62,179497.16,1982.54,436158.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258018',4909521,'3060','472',70359.23,70359.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258018',4909522,'3061','472',134804.38,134804.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258018',4909523,'3062','472',781275.33,783524.21,2248.88,494753.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258018',4909524,'3063','472',199952.75,201724.21,1771.46,389721.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258018',4909525,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258019',4909526,'3056','472',206244.17,207335.46,1091.29,240083.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258019',4909527,'3057','472',482006.31,482006.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258019',4909528,'3058','472',580563.15,581769.16,1206.01,265322.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258019',4909529,'3059','472',179497.16,180754.80,1257.64,276680.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258019',4909530,'3060','472',70359.23,72106.38,1747.15,384373.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258019',4909531,'3061','472',134804.38,136637.13,1832.75,403205.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258019',4909532,'3062','472',783524.21,784633.52,1109.31,244048.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258019',4909533,'3063','472',201724.21,202669.27,945.06,207913.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258019',4909534,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258020',4909535,'3056','472',207335.46,208841.64,1506.18,331359.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258020',4909536,'3057','472',482006.31,483721.72,1715.41,377390.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258020',4909537,'3058','472',581769.16,584286.94,2517.78,553911.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258020',4909538,'3059','472',180754.80,183031.70,2276.90,500918.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258020',4909539,'3060','472',72106.38,73644.16,1537.78,338311.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258020',4909540,'3061','472',136637.13,138159.91,1522.78,335011.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258020',4909541,'3062','472',784633.52,786446.62,1813.10,398882.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258020',4909542,'3063','472',202669.27,205094.37,2425.10,533522.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258020',4909543,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258021',4909544,'3056','472',208841.64,210328.64,1487.00,327140.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258021',4909545,'3057','472',483721.72,485419.35,1697.63,373478.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258021',4909546,'3058','472',584286.94,585168.88,881.94,194026.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258021',4909547,'3059','472',183031.70,183987.13,955.43,210194.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258021',4909548,'3060','472',73644.16,73937.71,293.55,64581.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258021',4909549,'3061','472',138159.91,138681.83,521.92,114822.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258021',4909550,'3062','472',786446.62,787938.51,1491.89,328215.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258021',4909551,'3063','472',205094.37,206111.61,1017.24,223792.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258021',4909552,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258022',4909553,'3056','472',210328.64,212740.77,2412.13,530668.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258022',4909554,'3057','472',485419.35,487700.68,2281.33,501892.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258022',4909555,'3058','472',585168.88,586520.78,1351.90,297418.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258022',4909556,'3059','472',183987.13,185004.74,1017.61,223874.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258022',4909557,'3060','472',73937.71,75225.34,1287.63,283278.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258022',4909558,'3061','472',138681.83,140060.35,1378.52,303274.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258022',4909559,'3062','472',787938.51,789682.42,1743.91,383660.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258022',4909560,'3063','472',206111.61,207966.24,1854.63,408018.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258022',4909561,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258023',4909562,'3056','472',212740.77,214174.78,1434.01,315482.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258023',4909563,'3057','472',487700.68,489086.97,1386.29,304983.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258023',4909564,'3058','472',586520.78,587756.50,1235.72,271858.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258023',4909565,'3059','472',185004.74,185936.51,931.77,204989.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258023',4909566,'3060','472',75225.34,75972.37,747.03,164346.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258023',4909567,'3061','472',140060.35,140927.87,867.52,190854.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258023',4909568,'3062','472',789682.42,790186.49,504.07,110895.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258023',4909569,'3063','472',207966.24,208435.45,469.21,103226.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258023',4909570,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258024',4909571,'3056','472',214174.78,216200.54,2025.76,445667.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258024',4909572,'3057','472',489086.97,491220.44,2133.47,469363.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258024',4909573,'3058','472',587756.50,590287.88,2531.38,556903.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258024',4909574,'3059','472',185936.51,188220.71,2284.20,502524.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258024',4909575,'3060','472',75972.37,77905.53,1913.16,420895.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258024',4909576,'3061','472',140927.87,143085.59,2157.72,474698.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258024',4909577,'3062','472',790186.49,792314.76,2128.27,468219.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258024',4909578,'3063','472',208435.45,209627.31,1191.86,262209.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258024',4909579,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258025',4909580,'3056','472',216200.54,218168.99,1968.45,433059.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258025',4909581,'3057','472',491220.44,493105.05,1884.61,414614.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258025',4909582,'3058','472',590287.88,591154.06,866.18,190559.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258025',4909583,'3059','472',188220.71,189442.15,1221.44,268716.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258025',4909584,'3060','472',77905.53,78943.37,1037.84,228324.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258025',4909585,'3061','472',143085.59,144371.91,1286.32,282990.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258025',4909586,'3062','472',792314.76,794426.69,2111.93,464624.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258025',4909587,'3063','472',209627.31,211269.66,1642.35,361317.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258025',4909588,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258026',4909589,'3056','472',218168.99,219163.96,994.97,218893.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258026',4909590,'3057','472',493105.05,494955.04,1849.99,406997.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258026',4909591,'3058','472',591154.06,593126.78,1946.69,428271.80,0.00,0.00,26.03,0.00,0.00),('1','206','1030','258026',4909592,'3059','472',189442.15,190775.73,1333.58,293387.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258026',4909593,'3060','472',78943.37,80126.33,1162.96,255851.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258026',4909594,'3061','472',144371.91,146047.06,1675.15,368533.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258026',4909595,'3062','472',794426.69,794721.20,284.51,62592.20,0.00,0.00,10.00,0.00,0.00),('1','206','1030','258026',4909596,'3063','472',211269.66,211611.25,341.59,75149.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258026',4909597,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258027',4909598,'3056','472',219163.96,219966.41,802.45,176539.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258027',4909599,'3057','472',494955.04,496242.61,1287.57,283265.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258027',4909600,'3058','472',593126.78,595131.40,2004.62,441016.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258027',4909601,'3059','472',190775.73,192420.99,1645.26,361957.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258027',4909602,'3060','472',80126.33,80893.90,767.57,168865.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258027',4909603,'3061','472',146047.06,147294.80,1247.74,274502.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258027',4909604,'3062','472',794721.20,797080.88,2359.68,519129.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258027',4909605,'3063','472',211611.25,214030.00,2418.75,532125.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258027',4909606,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258028',4909607,'3056','472',219966.41,221609.34,1642.93,361444.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258028',4909608,'3057','472',496242.61,497615.54,1372.93,302044.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258028',4909609,'3058','472',595131.40,597465.57,2334.17,513517.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258028',4909610,'3059','472',192420.99,193567.72,1146.73,252280.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258028',4909611,'3060','472',80893.90,81238.25,344.35,75757.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258028',4909612,'3061','472',147294.80,148588.60,1293.80,284636.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258028',4909613,'3062','472',797080.88,798070.30,989.42,217672.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258028',4909614,'3063','472',214030.00,214770.62,740.62,162936.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258028',4909615,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258029',4909616,'3056','472',221609.34,221707.57,98.23,21610.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258029',4909617,'3057','472',497615.54,498080.04,464.50,102190.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258029',4909618,'3058','472',597465.57,598993.40,1527.83,336122.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258029',4909619,'3059','472',193567.72,195148.05,1580.33,347672.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258029',4909620,'3060','472',81238.25,83207.05,1968.80,433136.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258029',4909621,'3061','472',148588.60,149961.57,1372.97,302053.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258029',4909622,'3062','472',798070.30,799157.47,1087.17,239177.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258029',4909623,'3063','472',214770.62,215483.03,712.41,156730.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258029',4909624,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258030',4909625,'3056','472',221707.57,223119.89,1412.32,310710.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258030',4909626,'3057','472',498080.04,500818.46,2738.42,602452.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258030',4909627,'3058','472',598993.40,601350.98,2357.58,518667.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258030',4909628,'3059','472',195148.05,197240.51,2092.46,460341.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258030',4909629,'3060','472',83207.05,83207.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258030',4909630,'3061','472',149961.57,149961.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258030',4909631,'3062','472',799157.47,801858.07,2700.60,594132.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258030',4909632,'3063','472',215483.03,217511.80,2028.77,446329.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258030',4909633,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258031',4909634,'3056','472',223119.89,224621.43,1501.54,330338.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258031',4909635,'3057','472',500818.46,502414.03,1595.57,351025.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258031',4909636,'3058','472',601350.98,603228.58,1877.60,413072.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258031',4909637,'3059','472',197240.51,198469.89,1229.38,270463.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258031',4909638,'3060','472',83207.05,83207.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258031',4909639,'3061','472',149961.57,149961.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258031',4909640,'3062','472',801858.07,803217.23,1359.16,299015.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258031',4909641,'3063','472',217511.80,219021.02,1509.22,332028.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258031',4909642,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258032',4909643,'3056','472',224621.43,226406.34,1784.91,392680.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258032',4909644,'3057','472',502414.03,504361.93,1947.90,428538.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258032',4909645,'3058','472',603228.58,606139.54,2910.96,640411.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258032',4909646,'3059','472',198469.89,198957.64,487.75,107305.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258032',4909647,'3060','472',83207.05,83207.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258032',4909648,'3061','472',149961.57,149961.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258032',4909649,'3062','472',803217.23,806135.41,2918.18,641999.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258032',4909650,'3063','472',219021.02,219857.09,836.07,183935.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258032',4909651,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258033',4909652,'3056','472',226406.34,227863.79,1436.94,316126.80,0.00,0.00,20.51,0.00,0.00),('1','206','1030','258033',4909653,'3057','472',504361.93,507208.53,2826.11,621744.20,0.00,0.00,20.49,0.00,0.00),('1','206','1030','258033',4909654,'3058','472',606139.54,607009.18,849.13,186808.60,0.00,0.00,20.51,0.00,0.00),('1','206','1030','258033',4909655,'3059','472',198957.64,199932.35,954.18,209919.60,0.00,0.00,20.53,0.00,0.00),('1','206','1030','258033',4909656,'3060','472',83207.05,83377.02,149.48,32885.60,0.00,0.00,20.49,0.00,0.00),('1','206','1030','258033',4909657,'3061','472',149961.57,150144.38,162.31,35708.20,0.00,0.00,20.50,0.00,0.00),('1','206','1030','258033',4909658,'3062','472',806135.41,809022.12,2866.10,630542.00,0.00,0.00,20.61,0.00,0.00),('1','206','1030','258033',4909659,'3063','472',219857.09,221914.25,2036.67,448067.40,0.00,0.00,20.49,0.00,0.00),('1','206','1031','258033',4909660,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258034',4909661,'3056','472',227863.79,229882.01,2018.22,444008.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258034',4909662,'3057','472',507208.53,509893.05,2684.52,590594.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258034',4909663,'3058','472',607009.18,607833.52,824.34,181354.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258034',4909664,'3059','472',199932.35,200664.59,732.24,161092.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258034',4909665,'3060','472',83377.02,83377.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258034',4909666,'3061','472',150144.38,150144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258034',4909667,'3062','472',809022.12,811976.31,2954.19,649921.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258034',4909668,'3063','472',221914.25,223470.66,1556.41,342410.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258034',4909669,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258035',4909670,'3056','472',229882.01,232031.74,2149.73,472940.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258035',4909671,'3057','472',509893.05,512868.33,2975.28,654561.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258035',4909672,'3058','472',607833.52,608408.30,574.78,126451.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258035',4909673,'3059','472',200664.59,201011.13,346.54,76238.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258035',4909674,'3060','472',83377.02,83377.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258035',4909675,'3061','472',150144.38,150144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258035',4909676,'3062','472',811976.31,814012.43,2036.12,447946.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258035',4909677,'3063','472',223470.66,226361.02,2890.36,635879.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258035',4909678,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258036',4909679,'3056','472',232031.74,233820.47,1788.73,393520.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258036',4909680,'3057','472',512868.33,516600.97,3732.64,821180.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258036',4909681,'3058','472',608408.30,609767.80,1359.50,299090.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258036',4909682,'3059','472',201011.13,202311.61,1300.48,286105.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258036',4909683,'3060','472',83377.02,83377.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258036',4909684,'3061','472',150144.38,150144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258036',4909685,'3062','472',814012.43,817051.71,3039.28,668641.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258036',4909686,'3063','472',226361.02,229170.21,2809.19,618021.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258036',4909687,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258037',4909688,'3056','472',233820.47,235181.50,1361.03,299426.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258037',4909689,'3057','472',516600.97,519640.03,3039.06,668593.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258037',4909690,'3058','472',609767.80,610517.74,749.94,164986.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258037',4909691,'3059','472',202311.61,203357.90,1046.29,230183.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258037',4909692,'3060','472',83377.02,83377.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258037',4909693,'3061','472',150144.38,150144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258037',4909694,'3062','472',817051.71,819748.51,2696.80,593296.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258037',4909695,'3063','472',229170.21,232038.42,2868.21,631006.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258037',4909696,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258038',4909697,'3056','472',235181.50,235702.64,521.14,114650.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258038',4909698,'3057','472',519640.03,523021.92,3381.89,744015.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258038',4909699,'3058','472',610517.74,612537.24,2019.50,444290.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258038',4909700,'3059','472',203357.90,204323.44,965.54,212418.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258038',4909701,'3060','472',83377.02,83635.80,258.78,56931.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258038',4909702,'3061','472',150144.38,150528.96,384.58,84607.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258038',4909703,'3062','472',819748.51,822540.65,2792.14,614270.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258038',4909704,'3063','472',232038.42,233274.81,1236.39,272005.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258038',4909705,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258039',4909706,'3056','472',235702.64,238497.45,2794.81,614858.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258039',4909707,'3057','472',523021.92,525522.97,2501.05,550231.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258039',4909708,'3058','472',612537.24,615335.64,2798.40,615648.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258039',4909709,'3059','472',204323.44,206404.28,2080.84,457784.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258039',4909710,'3060','472',83635.80,84586.87,951.07,209235.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258039',4909711,'3061','472',150528.96,151582.38,1053.42,231752.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258039',4909712,'3062','472',822540.65,825018.22,2477.57,545065.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258039',4909713,'3063','472',233274.81,235370.90,2096.09,461139.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258039',4909714,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258040',4909715,'3056','472',238497.45,239705.56,1208.11,265784.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258040',4909716,'3057','472',525522.97,528164.13,2641.16,581055.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258040',4909717,'3058','472',615335.64,617140.03,1804.39,396965.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258040',4909718,'3059','472',206404.28,208486.90,2082.62,458176.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258040',4909719,'3060','472',84586.87,84586.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258040',4909720,'3061','472',151582.38,151582.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258040',4909721,'3062','472',825018.22,827722.01,2703.79,594833.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258040',4909722,'3063','472',235370.90,238334.42,2963.52,651974.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258040',4909723,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258041',4909724,'3056','472',239705.56,241325.57,1620.01,356402.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258041',4909725,'3057','472',528164.13,531456.84,3292.71,724396.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258041',4909726,'3058','472',617140.03,617769.08,629.05,138391.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258041',4909727,'3059','472',208486.90,208704.20,217.30,47806.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258041',4909728,'3060','472',84586.87,86773.70,2166.83,476702.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258041',4909729,'3061','472',151582.38,153810.08,2227.70,490094.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258041',4909730,'3062','472',827722.01,830551.26,2829.25,622435.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258041',4909731,'3063','472',238334.42,239898.63,1564.21,344126.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258041',4909732,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258042',4909733,'3056','472',241325.57,243788.93,2463.36,541939.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258042',4909734,'3057','472',531456.84,533788.87,2332.03,513046.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258042',4909735,'3058','472',617769.08,619853.39,2084.31,458548.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258042',4909736,'3059','472',208704.20,210973.81,2269.61,499314.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258042',4909737,'3060','472',86773.70,87103.70,330.00,72600.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258042',4909738,'3061','472',153810.08,154041.42,231.34,50894.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258042',4909739,'3062','472',830551.26,833749.40,3198.14,703590.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258042',4909740,'3063','472',239898.63,241427.01,1528.38,336243.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258042',4909741,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258043',4909742,'3056','472',243788.93,245593.24,1804.31,396948.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258043',4909743,'3057','472',533788.87,536682.04,2893.17,636497.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258043',4909744,'3058','472',619853.39,620615.12,741.73,163180.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258043',4909745,'3059','472',210973.81,211665.08,671.27,147679.40,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258043',4909746,'3060','472',87103.70,88512.53,1408.83,309942.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258043',4909747,'3061','472',154041.42,155483.79,1442.37,317321.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258043',4909748,'3062','472',833749.40,835656.53,1907.13,419568.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258043',4909749,'3063','472',241427.01,242844.83,1417.82,311920.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258043',4909750,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258044',4909751,'3056','472',245593.24,247713.84,2120.60,466532.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258044',4909752,'3057','472',536682.04,539242.93,2560.89,563395.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258044',4909753,'3058','472',620615.12,621245.69,630.57,138725.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258044',4909754,'3059','472',211665.08,211763.77,98.69,21711.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258044',4909755,'3060','472',88512.53,89991.53,1479.00,325380.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258044',4909756,'3061','472',155483.79,157061.13,1577.34,347014.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258044',4909757,'3062','472',835656.53,838673.89,3017.36,663819.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258044',4909758,'3063','472',242844.83,244198.40,1353.57,297785.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258044',4909759,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258045',4909760,'3056','472',247713.84,249855.60,2141.76,471187.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258045',4909761,'3057','472',539242.93,539869.58,626.65,137863.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258045',4909762,'3058','472',621245.69,622546.58,1300.89,286195.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258045',4909763,'3059','472',211763.77,212627.12,843.35,185537.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258045',4909764,'3060','472',89991.53,91447.17,1435.64,315840.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258045',4909765,'3061','472',157061.13,158902.86,1841.73,405180.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258045',4909766,'3062','472',838673.89,841133.55,2459.66,541125.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258045',4909767,'3063','472',244198.40,244398.65,200.25,44055.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258045',4909768,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258046',4909769,'3056','472',249855.60,253076.65,3221.05,708631.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258046',4909770,'3057','472',539869.58,539869.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258046',4909771,'3058','472',622546.58,623177.68,608.38,133843.60,0.00,0.00,22.72,0.00,0.00),('1','206','1030','258046',4909772,'3059','472',212627.12,213919.23,1292.11,284264.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258046',4909773,'3060','472',91447.17,91447.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258046',4909774,'3061','472',158902.86,160852.54,1949.68,428929.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258046',4909775,'3062','472',841133.55,841133.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258046',4909776,'3063','472',244398.65,244398.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258046',4909777,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258047',4909778,'3056','472',253076.65,253076.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258047',4909779,'3057','472',539869.58,539869.74,0.16,35.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258047',4909780,'3058','472',623177.68,623475.42,297.74,65502.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258047',4909781,'3059','472',213919.23,214743.28,824.05,181291.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258047',4909782,'3060','472',91447.17,94305.23,2858.06,628773.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258047',4909783,'3061','472',160852.54,160852.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258047',4909784,'3062','472',841133.55,845720.46,4586.91,1009120.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258047',4909785,'3063','472',244398.65,244718.29,319.64,70320.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258047',4909786,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258048',4909787,'3056','472',253076.65,256534.04,3457.39,760625.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258048',4909788,'3057','472',539869.74,542945.83,3076.09,676739.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258048',4909789,'3058','472',623475.42,624092.13,586.71,129076.20,0.00,0.00,30.00,0.00,0.00),('1','206','1030','258048',4909790,'3059','472',214743.28,215632.77,889.49,195687.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258048',4909791,'3060','472',94305.23,96064.67,1759.44,387076.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258048',4909792,'3061','472',160852.54,163080.46,2227.92,490142.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258048',4909793,'3062','472',845720.46,849893.15,4172.69,917991.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258048',4909794,'3063','472',244718.29,247759.90,3041.61,669154.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258048',4909795,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258049',4909796,'3056','472',256534.04,258110.75,1576.71,346876.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258049',4909797,'3057','472',542945.83,542945.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258049',4909798,'3058','472',624092.13,625730.87,1638.74,360522.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258049',4909799,'3059','472',215632.77,216856.17,1223.40,269148.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258049',4909800,'3060','472',96064.67,97896.79,1832.12,403066.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258049',4909801,'3061','472',163080.46,164470.86,1370.40,301488.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258049',4909802,'3062','472',849893.15,851507.78,1614.63,355218.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258049',4909803,'3063','472',247759.90,248874.09,1114.19,245121.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258049',4909804,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258050',4909805,'3056','472',258110.75,261189.93,3079.18,677419.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258050',4909806,'3057','472',542945.83,545685.11,2739.28,602641.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258050',4909807,'3058','472',625730.87,629197.48,3466.61,762654.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258050',4909808,'3059','472',216856.17,217440.88,584.71,128636.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258050',4909809,'3060','472',97896.79,99078.85,1182.06,260053.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258050',4909810,'3061','472',164470.86,165375.22,904.36,198959.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258050',4909811,'3062','472',851507.78,855662.43,4154.65,914023.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258050',4909812,'3063','472',248874.09,250043.78,1169.69,257331.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258050',4909813,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258051',4909814,'3056','472',261189.93,263172.58,1982.65,436183.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258051',4909815,'3057','472',545685.11,547453.52,1768.41,389050.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258051',4909816,'3058','472',629197.48,631460.97,2263.49,497967.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258051',4909817,'3059','472',217440.88,219398.38,1957.50,430650.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258051',4909818,'3060','472',99078.85,99078.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258051',4909819,'3061','472',165375.22,165375.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258051',4909820,'3062','472',855662.43,858189.56,2527.13,555968.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258051',4909821,'3063','472',250043.78,252414.70,2370.92,521602.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258051',4909822,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258052',4909823,'3056','472',263172.58,264671.68,1499.10,329802.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258052',4909824,'3057','472',547453.52,549405.12,1951.60,429352.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258052',4909825,'3058','472',631460.97,631460.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258052',4909826,'3059','472',219398.38,219924.07,495.69,109051.80,0.00,0.00,30.00,0.00,0.00),('1','206','1030','258052',4909827,'3060','472',99078.85,99792.35,691.50,152130.00,0.00,0.00,22.00,0.00,0.00),('1','206','1030','258052',4909828,'3061','472',165375.22,167419.43,2044.21,449726.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258052',4909829,'3062','472',858189.56,859952.51,1762.95,387849.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258052',4909830,'3063','472',252414.70,254064.13,1649.43,362874.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258052',4909831,'3064','473',198777.43,198777.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258053',4909832,'3056','472',264671.68,264671.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258053',4909833,'3057','472',549405.12,549405.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258053',4909834,'3058','472',631460.97,631524.09,63.12,13886.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258053',4909835,'3059','472',219924.07,220444.38,520.31,114468.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258053',4909836,'3060','472',99792.35,99868.75,76.40,16808.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258053',4909837,'3061','472',167419.43,167613.06,193.63,42598.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258053',4909838,'3062','472',859952.51,860366.89,414.38,91163.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258053',4909839,'3063','472',254064.13,254773.30,709.17,156017.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258053',4909840,'3064','473',198777.43,199866.41,1088.98,947412.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258054',4909841,'3056','472',264671.68,264671.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258054',4909842,'3057','472',549405.12,549405.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258054',4909843,'3058','472',631524.09,631524.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258054',4909844,'3059','472',220444.38,220444.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258054',4909845,'3060','472',99868.75,99868.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258054',4909846,'3061','472',167613.06,167613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258054',4909847,'3062','472',860366.89,864382.19,3985.30,876766.00,0.00,0.00,30.00,0.00,0.00),('1','206','1030','258054',4909848,'3063','472',254773.30,256499.92,1726.62,379856.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258054',4909849,'3064','473',199866.41,199866.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258055',4909850,'3056','472',264671.68,264671.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258055',4909851,'3057','472',549405.12,549405.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258055',4909852,'3058','472',631524.09,631524.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258055',4909853,'3059','472',220444.38,220444.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258055',4909854,'3060','472',99868.75,99868.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258055',4909855,'3061','472',167613.06,167613.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258055',4909856,'3062','472',864382.19,867772.31,3380.12,743626.40,0.00,0.00,10.00,0.00,0.00),('1','206','1030','258055',4909857,'3063','472',256499.92,258212.31,1712.39,376725.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258055',4909858,'3064','473',199866.41,201225.58,1359.17,1182477.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258056',4909859,'3056','472',264671.68,267353.58,2681.90,590018.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258056',4909860,'3057','472',549405.12,552269.48,2864.36,630159.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258056',4909861,'3058','472',631524.09,633216.85,1692.76,372407.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258056',4909862,'3059','472',220444.38,221686.97,1242.59,273369.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258056',4909863,'3060','472',99868.75,102732.15,2863.40,629948.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258056',4909864,'3061','472',167613.06,169947.36,2334.30,513546.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258056',4909865,'3062','472',867772.31,870937.18,3164.87,696271.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258056',4909866,'3063','472',258212.31,261377.23,3164.92,696282.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258056',4909867,'3064','473',201225.58,201334.78,109.20,95004.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258057',4909868,'3056','472',267353.58,269824.83,2471.25,543675.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258057',4909869,'3057','472',552269.48,554949.12,2679.64,589520.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258057',4909870,'3058','472',633216.85,634610.97,1394.12,306706.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258057',4909871,'3059','472',221686.97,221882.92,195.95,43109.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258057',4909872,'3060','472',102732.15,105274.39,2542.24,559292.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258057',4909873,'3061','472',169947.36,172692.09,2744.73,603840.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258057',4909874,'3062','472',870937.18,873486.15,2548.97,560773.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258057',4909875,'3063','472',261377.23,262855.44,1478.21,325206.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258057',4909876,'3064','473',201334.78,202249.73,914.95,796006.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258058',4909877,'3056','472',269824.83,272623.39,2798.56,615683.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258058',4909878,'3057','472',554949.12,558276.41,3327.29,732003.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258058',4909879,'3058','472',634610.97,635838.57,1227.60,270072.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258058',4909880,'3059','472',221882.92,222962.04,1079.12,237406.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258058',4909881,'3060','472',105274.39,108315.23,3040.84,668984.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258058',4909882,'3061','472',172692.09,175021.93,2329.84,512564.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258058',4909883,'3062','472',873486.15,875969.59,2483.44,546356.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258058',4909884,'3063','472',262855.44,264637.43,1781.99,392037.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258058',4909885,'3064','473',202249.73,202249.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258059',4909886,'3056','472',272623.39,275554.32,2930.93,644804.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258059',4909887,'3057','472',558276.41,561374.05,3097.64,681480.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258059',4909888,'3058','472',635838.57,638470.87,2632.30,579106.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258059',4909889,'3059','472',222962.04,223952.00,989.96,217791.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258059',4909890,'3060','472',108315.23,111052.43,2737.20,602184.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258059',4909891,'3061','472',175021.93,177657.90,2635.97,579913.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258059',4909892,'3062','472',875969.59,878601.41,2631.82,579000.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258059',4909893,'3063','472',264637.43,267278.38,2640.95,581009.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258059',4909894,'3064','473',202249.73,202249.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258060',4909895,'3056','472',275554.32,277532.67,1978.35,435237.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258060',4909896,'3057','472',561374.05,564016.76,2642.71,581396.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258060',4909897,'3058','472',638470.87,639621.55,1150.68,253149.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258060',4909898,'3059','472',223952.00,225039.72,1087.72,239298.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258060',4909899,'3060','472',111052.43,112272.93,1206.87,265511.40,0.00,0.00,13.63,0.00,0.00),('1','206','1030','258060',4909900,'3061','472',177657.90,180066.90,2409.00,529980.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258060',4909901,'3062','472',878601.41,880763.03,2161.62,475556.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258060',4909902,'3063','472',267278.38,269215.40,1937.02,426144.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258060',4909903,'3064','473',202249.73,203681.06,1431.33,1245257.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258061',4909904,'3056','472',277532.67,277532.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258061',4909905,'3057','472',564016.76,564016.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258061',4909906,'3058','472',639621.55,639698.31,76.76,16887.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258061',4909907,'3059','472',225039.72,225039.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258061',4909908,'3060','472',112272.93,112272.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258061',4909909,'3061','472',180066.90,180066.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258061',4909910,'3062','472',880763.03,882586.85,1823.82,401240.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258061',4909911,'3063','472',269215.40,269971.10,755.70,166254.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258061',4909912,'3064','473',203681.06,203739.99,58.93,51269.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258062',4909913,'3056','472',277532.67,278875.33,1342.66,295385.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258062',4909914,'3057','472',564016.76,566294.91,2278.15,501193.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258062',4909915,'3058','472',639698.31,640484.04,785.73,172860.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258062',4909916,'3059','472',225039.72,225540.86,501.14,110250.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258062',4909917,'3060','472',112272.93,113825.43,1552.50,341550.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258062',4909918,'3061','472',180066.90,181814.78,1747.88,384533.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258062',4909919,'3062','472',882586.85,884957.00,2370.15,521433.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258062',4909920,'3063','472',269971.10,271075.38,1104.28,242941.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258062',4909921,'3064','473',203739.99,204706.93,966.94,841237.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258063',4909922,'3056','472',278875.33,280449.64,1574.31,346348.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258063',4909923,'3057','472',566294.91,568177.87,1882.96,414251.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258063',4909924,'3058','472',640484.04,641961.87,1477.83,325122.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258063',4909925,'3059','472',225540.86,227438.09,1897.23,417390.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258063',4909926,'3060','472',113825.43,113825.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258063',4909927,'3061','472',181814.78,181814.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258063',4909928,'3062','472',884957.00,887204.92,2247.92,494542.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258063',4909929,'3063','472',271075.38,272858.60,1783.22,392308.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258063',4909930,'3064','473',204706.93,205337.23,630.30,535755.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258064',4909931,'3056','472',280449.64,281711.20,1261.56,277543.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258064',4909932,'3057','472',568177.87,570129.66,1951.79,429393.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258064',4909933,'3058','472',641961.87,644401.19,2439.32,536650.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258064',4909934,'3059','472',227438.09,228915.93,1477.84,325124.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258064',4909935,'3060','472',113825.43,113825.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258064',4909936,'3061','472',181814.78,182133.35,318.57,70085.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258064',4909937,'3062','472',887204.92,890115.02,2910.10,640222.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258064',4909938,'3063','472',272858.60,274425.77,1567.17,344777.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258064',4909939,'3064','473',205337.23,206337.23,1000.00,850000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258065',4909940,'3056','472',281711.20,284341.28,2630.08,578617.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258065',4909941,'3057','472',570129.66,572697.80,2568.14,564990.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258065',4909942,'3058','472',644401.19,645570.87,1169.68,257329.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258065',4909943,'3059','472',228915.93,230118.69,1172.76,258007.20,0.00,0.00,30.00,0.00,0.00),('1','206','1030','258065',4909944,'3060','472',113825.43,113825.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258065',4909945,'3061','472',182133.35,182133.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258065',4909946,'3062','472',890115.02,892191.93,2056.91,452520.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258065',4909947,'3063','472',274425.77,277013.44,2587.67,569287.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258065',4909948,'3064','473',206337.23,206337.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258066',4909949,'3056','472',284341.28,286310.58,1969.30,433246.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258066',4909950,'3057','472',572697.80,575464.68,2766.88,608713.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258066',4909951,'3058','472',645570.87,648326.29,2755.42,606192.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258066',4909952,'3059','472',230118.69,232777.67,2658.98,584975.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258066',4909953,'3060','472',113825.43,116149.56,2324.13,511308.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258066',4909954,'3061','472',182133.35,184107.03,1973.68,434209.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258066',4909955,'3062','472',892191.93,894879.75,2687.82,591320.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258066',4909956,'3063','472',277013.44,279079.94,2066.50,454630.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258066',4909957,'3064','473',206337.23,208198.06,1860.83,1581705.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258067',4909958,'3056','472',286310.58,286955.82,645.24,141952.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258067',4909959,'3057','472',575464.68,577075.52,1610.84,354384.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258067',4909960,'3058','472',648326.29,648900.65,574.36,126359.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258067',4909961,'3059','472',232777.67,234004.65,1226.98,269935.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258067',4909962,'3060','472',116149.56,116785.77,636.21,139966.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258067',4909963,'3061','472',184107.03,184866.04,759.01,166982.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258067',4909964,'3062','472',894879.75,896381.86,1502.11,330464.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258067',4909965,'3063','472',279079.94,280069.25,989.31,217648.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258067',4909966,'3064','473',208198.06,208714.13,516.07,438659.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258068',4909967,'3056','472',286955.82,288257.51,1301.69,286371.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258068',4909968,'3057','472',577075.52,578581.00,1505.48,331205.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258068',4909969,'3058','472',648900.65,649491.92,591.27,130079.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258068',4909970,'3059','472',234004.65,234885.34,880.69,193751.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258068',4909971,'3060','472',116785.77,116785.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258068',4909972,'3061','472',184866.04,185256.40,390.36,85879.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258068',4909973,'3062','472',896381.86,898779.26,2397.40,527428.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258068',4909974,'3063','472',280069.25,282099.15,2029.90,446578.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258068',4909975,'3064','473',208714.13,209727.66,1013.53,861500.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258069',4909976,'3056','472',288257.51,288498.59,218.59,48089.80,0.00,0.00,22.49,0.00,0.00),('1','206','1030','258069',4909977,'3057','472',578581.00,581526.70,2923.21,643106.20,0.00,0.00,22.49,0.00,0.00),('1','206','1030','258069',4909978,'3058','472',649491.92,649940.21,425.80,93676.00,0.00,0.00,22.49,0.00,0.00),('1','206','1030','258069',4909979,'3059','472',234885.34,235213.82,305.99,67317.80,0.00,0.00,22.49,0.00,0.00),('1','206','1030','258069',4909980,'3060','472',116785.77,117438.10,629.84,138564.80,0.00,0.00,22.49,0.00,0.00),('1','206','1030','258069',4909981,'3061','472',185256.40,186360.47,1081.58,237947.60,0.00,0.00,22.49,0.00,0.00),('1','206','1030','258069',4909982,'3062','472',898779.26,900132.80,1331.05,292831.00,0.00,0.00,22.49,0.00,0.00),('1','206','1030','258069',4909983,'3063','472',282099.15,283487.40,1365.76,300467.20,0.00,0.00,22.49,0.00,0.00),('1','206','1031','258069',4909984,'3064','473',209727.66,212058.73,2331.07,1981409.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258070',4909985,'3056','472',288498.59,288661.45,162.86,35829.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258070',4909986,'3057','472',581526.70,581837.51,310.81,68378.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258070',4909987,'3058','472',649940.21,652687.20,2746.99,604337.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258070',4909988,'3059','472',235213.82,238126.64,2912.82,640820.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258070',4909989,'3060','472',117438.10,119998.33,2560.23,563250.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258070',4909990,'3061','472',186360.47,188713.92,2353.45,517759.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258070',4909991,'3062','472',900132.80,900141.89,9.09,1999.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258070',4909992,'3063','472',283487.40,283825.64,338.24,74412.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258070',4909993,'3064','473',212058.73,213235.28,1176.55,1000067.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258071',4909994,'3056','472',288661.45,290670.22,2008.77,441929.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258071',4909995,'3057','472',581837.51,584475.16,2637.65,580283.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258071',4909996,'3058','472',652687.20,652878.93,191.73,42180.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258071',4909997,'3059','472',238126.64,238830.93,704.29,154943.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258071',4909998,'3060','472',119998.33,121450.57,1452.24,319492.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258071',4909999,'3061','472',188713.92,189144.05,430.13,94628.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258071',4910000,'3062','472',900141.89,902243.16,2101.27,462279.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258071',4910001,'3063','472',283825.64,285677.45,1851.81,407398.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258071',4910002,'3064','473',213235.28,213235.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258072',4910003,'3056','472',290670.22,292463.26,1793.04,358608.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258072',4910004,'3057','472',584475.16,586018.52,1543.36,308672.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258072',4910005,'3058','472',652878.93,653751.61,872.68,174536.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258072',4910006,'3059','472',238830.93,239767.54,936.61,187322.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258072',4910007,'3060','472',121450.57,121450.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258072',4910008,'3061','472',189144.05,189144.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258072',4910009,'3062','472',902243.16,903846.54,1603.38,320676.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258072',4910010,'3063','472',285677.45,287526.45,1849.00,369800.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258072',4910011,'3064','473',213235.28,213665.58,430.30,365755.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258073',4910012,'3056','472',292463.26,294015.34,1532.08,306416.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258073',4910013,'3057','472',586018.52,588594.49,2555.97,511194.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258073',4910014,'3058','472',653751.61,653794.11,32.50,6500.00,0.00,0.00,10.00,0.00,0.00),('1','206','1030','258073',4910015,'3059','472',239767.54,240154.35,366.81,73362.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258073',4910016,'3060','472',121450.57,122962.98,1512.41,302482.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258073',4910017,'3061','472',189144.05,190111.90,967.85,193570.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258073',4910018,'3062','472',903846.54,905739.24,1892.70,378540.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258073',4910019,'3063','472',287526.45,288900.75,1374.30,274860.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258073',4910020,'3064','473',213665.58,213665.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258074',4910021,'3056','472',294015.34,295494.16,1478.82,295764.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258074',4910022,'3057','472',588594.49,590018.73,1404.24,280848.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258074',4910023,'3058','472',653794.11,654654.66,860.55,172110.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258074',4910024,'3059','472',240154.35,240982.32,827.97,165594.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258074',4910025,'3060','472',122962.98,123701.76,738.78,147756.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258074',4910026,'3061','472',190111.90,192698.79,2586.89,517378.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258074',4910027,'3062','472',905739.24,906530.31,791.07,158214.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258074',4910028,'3063','472',288900.75,288900.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258074',4910029,'3064','473',213665.58,213691.00,25.42,21607.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258075',4910030,'3056','472',295494.16,296689.97,1195.81,239162.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258075',4910031,'3057','472',590018.73,592910.93,2892.20,578440.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258075',4910032,'3058','472',654654.66,655224.82,570.16,114032.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258075',4910033,'3059','472',240982.32,241705.76,723.44,144688.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258075',4910034,'3060','472',123701.76,125318.52,1616.76,323352.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258075',4910035,'3061','472',192698.79,194896.86,2198.07,439614.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258075',4910036,'3062','472',906530.31,907713.67,1183.36,236672.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258075',4910037,'3063','472',288900.75,289452.20,551.45,110290.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258075',4910038,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258076',4910039,'3056','472',296689.97,297986.57,1296.60,259320.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258076',4910040,'3057','472',592910.93,597115.83,4204.90,840980.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258076',4910041,'3058','472',655224.82,657376.29,2151.47,430294.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258076',4910042,'3059','472',241705.76,243074.23,1368.47,273694.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258076',4910043,'3060','472',125318.52,126988.39,1669.87,333974.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258076',4910044,'3061','472',194896.86,197745.98,2849.12,569824.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258076',4910045,'3062','472',907713.67,909717.57,2003.90,400780.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258076',4910046,'3063','472',289452.20,290970.30,1518.10,303620.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258076',4910047,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258077',4910048,'3056','472',297986.57,299027.56,1040.99,208198.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258077',4910049,'3057','472',597115.83,599153.42,2037.59,407518.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258077',4910050,'3058','472',657376.29,658037.38,661.09,132218.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258077',4910051,'3059','472',243074.23,243724.88,650.65,130130.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258077',4910052,'3060','472',126988.39,128097.61,1109.22,221844.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258077',4910053,'3061','472',197745.98,198687.18,941.20,188240.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258077',4910054,'3062','472',909717.57,910739.01,1021.44,204288.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258077',4910055,'3063','472',290970.30,291579.35,609.05,121810.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258077',4910056,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258078',4910057,'3056','472',299027.56,300344.94,1317.38,263476.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258078',4910058,'3057','472',599153.42,601178.33,2024.91,404982.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258078',4910059,'3058','472',658037.38,660669.03,2631.65,526330.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258078',4910060,'3059','472',243724.88,244805.22,1080.34,216068.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258078',4910061,'3060','472',128097.61,128097.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258078',4910062,'3061','472',198687.18,198687.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258078',4910063,'3062','472',910739.01,914495.31,3756.30,751260.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258078',4910064,'3063','472',291579.35,292313.89,734.54,146908.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258078',4910065,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258079',4910066,'3056','472',300344.94,301887.48,1542.54,308508.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258079',4910067,'3057','472',601178.33,603827.86,2649.53,529906.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258079',4910068,'3058','472',660669.03,661188.48,519.45,103890.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258079',4910069,'3059','472',244805.22,245456.36,651.14,130228.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258079',4910070,'3060','472',128097.61,128892.62,795.01,159002.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258079',4910071,'3061','472',198687.18,200382.21,1695.03,339006.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258079',4910072,'3062','472',914495.31,916188.22,1692.91,338582.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258079',4910073,'3063','472',292313.89,294172.37,1858.48,371696.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258079',4910074,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258080',4910075,'3056','472',301887.48,303006.16,1118.68,223736.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258080',4910076,'3057','472',603827.86,606844.58,3016.72,603344.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258080',4910077,'3058','472',661188.48,661649.18,460.70,92140.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258080',4910078,'3059','472',245456.36,247606.97,2150.61,430122.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258080',4910079,'3060','472',128892.62,130113.34,1220.72,244144.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258080',4910080,'3061','472',200382.21,201579.78,1197.57,239514.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258080',4910081,'3062','472',916188.22,917468.54,1280.32,256064.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258080',4910082,'3063','472',294172.37,295328.56,1156.19,231238.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258080',4910083,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258081',4910084,'3056','472',303006.16,304612.81,1606.65,321330.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258081',4910085,'3057','472',606844.58,609742.72,2898.14,579628.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258081',4910086,'3058','472',661649.18,662714.11,1064.93,212986.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258081',4910087,'3059','472',247606.97,248909.43,1302.46,260492.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258081',4910088,'3060','472',130113.34,131442.98,1329.64,265928.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258081',4910089,'3061','472',201579.78,202915.75,1335.97,267194.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258081',4910090,'3062','472',917468.54,919745.45,2276.91,455382.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258081',4910091,'3063','472',295328.56,296573.35,1244.79,248958.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258081',4910092,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258082',4910093,'3056','472',304612.81,306326.23,1713.42,342684.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258082',4910094,'3057','472',609742.72,612271.62,2528.90,505780.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258082',4910095,'3058','472',662714.11,663379.10,664.99,132998.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258082',4910096,'3059','472',248909.43,250408.22,1498.79,299758.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258082',4910097,'3060','472',131442.98,132188.03,745.05,149010.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258082',4910098,'3061','472',202915.75,203471.12,555.37,111074.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258082',4910099,'3062','472',919745.45,922310.99,2565.54,513108.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258082',4910100,'3063','472',296573.35,297763.07,1189.72,237944.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258082',4910101,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258083',4910102,'3056','472',306326.23,307431.42,1105.19,221038.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258083',4910103,'3057','472',612271.62,614246.80,1975.18,395036.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258083',4910104,'3058','472',663379.10,663972.69,593.59,118718.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258083',4910105,'3059','472',250408.22,251189.55,781.33,156266.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258083',4910106,'3060','472',132188.03,133366.49,1178.46,235692.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258083',4910107,'3061','472',203471.12,205029.01,1557.89,311578.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258083',4910108,'3062','472',922310.99,923082.05,771.06,154212.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258083',4910109,'3063','472',297763.07,298578.21,815.14,163028.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258083',4910110,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258084',4910111,'3056','472',307431.42,308263.41,831.99,166398.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258084',4910112,'3057','472',614246.80,617807.94,3561.14,712228.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258084',4910113,'3058','472',663972.69,666380.58,2407.89,481578.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258084',4910114,'3059','472',251189.55,253523.20,2333.65,466730.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258084',4910115,'3060','472',133366.49,134743.46,1376.97,275394.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258084',4910116,'3061','472',205029.01,206614.57,1585.56,317112.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258084',4910117,'3062','472',923082.05,925724.49,2642.44,528488.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258084',4910118,'3063','472',298578.21,299756.56,1178.35,235670.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258084',4910119,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258085',4910120,'3056','472',308263.41,309636.06,1372.65,274530.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258085',4910121,'3057','472',617807.94,619699.73,1891.79,378358.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258085',4910122,'3058','472',666380.58,666674.90,294.32,58864.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258085',4910123,'3059','472',253523.20,254240.72,697.52,139504.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258085',4910124,'3060','472',134743.46,135335.88,592.42,118484.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258085',4910125,'3061','472',206614.57,207619.43,1004.86,200972.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258085',4910126,'3062','472',925724.49,927560.22,1835.73,367146.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258085',4910127,'3063','472',299756.56,301032.27,1275.71,255142.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258085',4910128,'3064','473',213691.00,213691.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258086',4910129,'3056','472',309636.06,310529.62,893.56,187647.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258086',4910130,'3057','472',619699.73,621940.10,2240.37,470477.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258086',4910131,'3058','472',666674.90,667565.07,890.17,186935.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258086',4910132,'3059','472',254240.72,255064.88,804.16,168873.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258086',4910133,'3060','472',135335.88,136678.63,1342.75,281977.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258086',4910134,'3061','472',207619.43,209331.42,1711.99,359517.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258086',4910135,'3062','472',927560.22,929116.09,1555.87,326732.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258086',4910136,'3063','472',301032.27,301770.16,737.89,154956.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258086',4910137,'3064','473',213691.00,213860.20,169.20,143820.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258087',4910138,'3056','472',310529.62,311927.32,1397.70,293517.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258087',4910139,'3057','472',621940.10,623722.30,1782.20,374262.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258087',4910140,'3058','472',667565.07,668135.68,570.61,119828.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258087',4910141,'3059','472',255064.88,255409.86,344.98,72445.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258087',4910142,'3060','472',136678.63,137689.23,990.60,208026.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258087',4910143,'3061','472',209331.42,209993.50,662.08,139036.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258087',4910144,'3062','472',929116.09,931068.22,1952.13,409947.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258087',4910145,'3063','472',301770.16,302438.15,667.99,140277.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258087',4910146,'3064','473',213860.20,213860.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258088',4910147,'3056','472',311927.32,313239.59,1312.27,275576.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258088',4910148,'3057','472',623722.30,625485.44,1763.14,370259.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258088',4910149,'3058','472',668135.68,668658.88,523.20,109872.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258088',4910150,'3059','472',255409.86,255966.28,536.42,112648.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258088',4910151,'3060','472',137689.23,138187.42,498.19,104619.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258088',4910152,'3061','472',209993.50,211393.35,1399.85,293968.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258088',4910153,'3062','472',931068.22,933142.90,2074.68,435682.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258088',4910154,'3063','472',302438.15,303132.63,694.48,145840.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258088',4910155,'3064','473',213860.20,213860.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258089',4910156,'3056','472',313239.59,314995.18,1755.59,368673.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258089',4910157,'3057','472',625485.44,627450.55,1965.11,412673.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258089',4910158,'3058','472',668658.88,669534.19,875.31,183815.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258089',4910159,'3059','472',255966.28,256250.04,283.76,59589.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258089',4910160,'3060','472',138187.42,138849.69,662.27,139076.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258089',4910161,'3061','472',211393.35,212070.72,677.37,142247.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258089',4910162,'3062','472',933142.90,934632.26,1489.36,312765.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258089',4910163,'3063','472',303132.63,304295.18,1162.55,244135.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258089',4910164,'3064','473',213860.20,213860.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258090',4910165,'3056','472',314995.18,316303.65,1308.47,274778.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258090',4910166,'3057','472',627450.55,629615.35,2164.80,454608.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258090',4910167,'3058','472',669534.19,670850.11,1315.92,276343.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258090',4910168,'3059','472',256250.04,257653.43,1403.39,294711.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258090',4910169,'3060','472',138849.69,139280.66,430.97,90503.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258090',4910170,'3061','472',212070.72,212820.66,749.94,157487.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258090',4910171,'3062','472',934632.26,936557.11,1924.85,404218.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258090',4910172,'3063','472',304295.18,304413.03,117.85,24748.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258090',4910173,'3064','473',213860.20,214710.27,850.07,722559.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258091',4910174,'3056','472',316303.65,317061.86,758.21,159224.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258091',4910175,'3057','472',629615.35,631224.26,1608.91,337871.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258091',4910176,'3058','472',670850.11,671645.72,795.61,167078.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258091',4910177,'3059','472',257653.43,258463.17,809.74,170045.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258091',4910178,'3060','472',139280.66,140072.81,792.15,166351.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258091',4910179,'3061','472',212820.66,214056.71,1236.05,259570.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258091',4910180,'3062','472',936557.11,939108.13,2551.02,535714.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258091',4910181,'3063','472',304413.03,305531.95,1118.92,234973.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258091',4910182,'3064','473',214710.27,214710.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258092',4910183,'3056','472',317061.86,317866.59,804.73,168993.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258092',4910184,'3057','472',631224.26,633582.37,2358.11,495203.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258092',4910185,'3058','472',671645.72,672225.91,580.19,121839.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258092',4910186,'3059','472',258463.17,259369.51,906.34,190331.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258092',4910187,'3060','472',140072.81,140928.64,855.83,179724.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258092',4910188,'3061','472',214056.71,214890.00,833.29,174990.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258092',4910189,'3062','472',939108.13,941285.13,2177.00,457170.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258092',4910190,'3063','472',305531.95,306177.21,645.26,135504.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258092',4910191,'3064','473',214710.27,216233.62,1523.35,1294847.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258093',4910192,'3056','472',317866.59,318479.80,613.21,128774.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258093',4910193,'3057','472',633582.37,635671.34,2088.97,438683.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258093',4910194,'3058','472',672225.91,672560.58,334.67,70280.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258093',4910195,'3059','472',259369.51,260787.43,1417.92,297763.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258093',4910196,'3060','472',140928.64,140972.45,43.81,9200.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258093',4910197,'3061','472',214890.00,215406.86,516.86,108540.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258093',4910198,'3062','472',941285.13,942964.59,1679.46,352686.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258093',4910199,'3063','472',306177.21,307426.29,1249.08,262306.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258093',4910200,'3064','473',216233.62,216233.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258094',4910201,'3056','472',318479.80,319497.27,1017.47,213668.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258094',4910202,'3057','472',635671.34,638235.43,2564.09,538458.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258094',4910203,'3058','472',672560.58,672998.51,437.93,91965.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258094',4910204,'3059','472',260787.43,261529.38,741.95,155809.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258094',4910205,'3060','472',140972.45,142644.57,1672.12,351145.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258094',4910206,'3061','472',215406.86,217219.63,1812.77,380681.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258094',4910207,'3062','472',942964.59,944358.02,1393.43,292620.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258094',4910208,'3063','472',307426.29,309092.92,1666.63,349992.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258094',4910209,'3064','473',216233.62,216233.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258095',4910210,'3056','472',319497.27,320337.59,840.32,176467.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258095',4910211,'3057','472',638235.43,640056.73,1821.30,382473.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258095',4910212,'3058','472',672998.51,674360.36,1361.85,285988.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258095',4910213,'3059','472',261529.38,263117.98,1588.60,333606.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258095',4910214,'3060','472',142644.57,143102.00,457.43,96060.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258095',4910215,'3061','472',217219.63,217967.64,748.01,157082.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258095',4910216,'3062','472',944358.02,945930.61,1572.59,330243.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258095',4910217,'3063','472',309092.92,309984.36,891.44,187202.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258095',4910218,'3064','473',216233.62,216233.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258096',4910219,'3056','472',320337.59,320337.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258096',4910220,'3057','472',640056.73,640056.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258096',4910221,'3058','472',674360.36,676373.82,2013.46,422826.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258096',4910222,'3059','472',263117.98,264878.59,1760.61,369728.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258096',4910223,'3060','472',143102.00,143743.52,641.52,134719.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258096',4910224,'3061','472',217967.64,220727.78,2760.14,579629.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258096',4910225,'3062','472',945930.61,945930.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258096',4910226,'3063','472',309984.36,310636.89,652.53,137031.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258096',4910227,'3064','473',216233.62,216766.81,533.19,453211.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258097',4910228,'3056','472',320337.59,321530.84,1193.25,250582.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258097',4910229,'3057','472',640056.73,642713.08,2656.35,557833.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258097',4910230,'3058','472',676373.82,676806.31,432.49,90822.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258097',4910231,'3059','472',264878.59,265852.51,973.92,204523.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258097',4910232,'3060','472',143743.52,144632.20,888.68,186622.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258097',4910233,'3061','472',220727.78,221549.95,822.17,172655.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258097',4910234,'3062','472',945930.61,948017.21,2086.60,438186.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258097',4910235,'3063','472',310636.89,312179.70,1542.81,323990.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258097',4910236,'3064','473',216766.81,216766.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258098',4910237,'3056','472',321530.84,322373.80,842.96,177021.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258098',4910238,'3057','472',642713.08,644701.33,1988.25,417532.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258098',4910239,'3058','472',676806.31,677629.99,823.68,172972.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258098',4910240,'3059','472',265852.51,266659.22,806.71,169409.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258098',4910241,'3060','472',144632.20,145357.09,724.89,152226.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258098',4910242,'3061','472',221549.95,222172.42,622.47,130718.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258098',4910243,'3062','472',948017.21,950122.35,2105.14,442079.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258098',4910244,'3063','472',312179.70,312863.07,683.37,143507.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258098',4910245,'3064','473',216766.81,216792.52,25.71,21853.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258099',4910246,'3056','472',322373.80,322913.42,539.62,113320.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258099',4910247,'3057','472',644701.33,646263.82,1562.49,328122.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258099',4910248,'3058','472',677629.99,679472.50,1842.51,386927.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258099',4910249,'3059','472',266659.22,267957.27,1298.05,272590.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258099',4910250,'3060','472',145357.09,145615.37,258.28,54238.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258099',4910251,'3061','472',222172.42,222303.65,131.23,27558.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258099',4910252,'3062','472',950122.35,951623.65,1501.30,315273.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258099',4910253,'3063','472',312863.07,314043.89,1180.82,247972.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258099',4910254,'3064','473',216792.52,216796.64,4.12,3502.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258100',4910255,'3056','472',322913.42,324248.49,1335.07,280364.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258100',4910256,'3057','472',646263.82,647451.03,1187.21,249314.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258100',4910257,'3058','472',679472.50,680777.33,1304.83,274014.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258100',4910258,'3059','472',267957.27,269416.06,1458.79,306345.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258100',4910259,'3060','472',145615.37,146271.22,655.85,137728.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258100',4910260,'3061','472',222303.65,223620.85,1317.20,276612.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258100',4910261,'3062','472',951623.65,952018.55,394.90,82929.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258100',4910262,'3063','472',314043.89,314663.94,620.05,130210.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258100',4910263,'3064','473',216796.64,217967.80,1171.16,995486.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258101',4910264,'3056','472',324248.49,324788.86,540.37,113477.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258101',4910265,'3057','472',647451.03,649492.44,2041.41,428696.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258101',4910266,'3058','472',680777.33,681540.82,763.49,160332.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258101',4910267,'3059','472',269416.06,270613.68,1197.62,251500.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258101',4910268,'3060','472',146271.22,146351.53,61.27,12866.70,0.00,0.00,19.04,0.00,0.00),('1','206','1030','258101',4910269,'3061','472',223620.85,224740.28,1119.43,235080.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258101',4910270,'3062','472',952018.55,954047.21,2028.66,426018.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258101',4910271,'3063','472',314663.94,315885.18,1221.24,256460.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258101',4910272,'3064','473',217967.80,217967.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258102',4910273,'3056','472',324788.86,325411.20,622.34,130691.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258102',4910274,'3057','472',649492.44,651018.30,1525.86,320430.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258102',4910275,'3058','472',681540.82,682764.60,1223.78,256993.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258102',4910276,'3059','472',270613.68,271504.03,890.35,186973.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258102',4910277,'3060','472',146351.53,147064.91,713.38,149809.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258102',4910278,'3061','472',224740.28,225141.18,400.90,84189.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258102',4910279,'3062','472',954047.21,955558.85,1511.64,317444.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258102',4910280,'3063','472',315885.18,316589.65,704.47,147938.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258102',4910281,'3064','473',217967.80,217967.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258103',4910282,'3056','472',325411.20,326481.55,1070.35,224773.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258103',4910283,'3057','472',651018.30,652517.72,1499.42,314878.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258103',4910284,'3058','472',682764.60,684559.94,1795.34,377021.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258103',4910285,'3059','472',271504.03,272849.05,1345.02,282454.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258103',4910286,'3060','472',147064.91,147498.89,433.98,91135.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258103',4910287,'3061','472',225141.18,225948.40,807.22,169516.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258103',4910288,'3062','472',955558.85,957506.96,1948.11,409103.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258103',4910289,'3063','472',316589.65,317791.07,1201.42,252298.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258103',4910290,'3064','473',217967.80,217967.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258104',4910291,'3056','472',326481.55,327866.18,1384.63,290772.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258104',4910292,'3057','472',652517.72,654061.92,1544.20,324282.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258104',4910293,'3058','472',684559.94,686025.49,1465.55,307765.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258104',4910294,'3059','472',272849.05,273719.85,870.80,182868.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258104',4910295,'3060','472',147498.89,148176.98,678.09,142398.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258104',4910296,'3061','472',225948.40,226962.86,995.42,209038.20,0.00,0.00,19.04,0.00,0.00),('1','206','1030','258104',4910297,'3062','472',957506.96,958792.86,1285.90,270039.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258104',4910298,'3063','472',317791.07,318868.60,1077.53,226281.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258104',4910299,'3064','473',217967.80,219002.44,1034.64,879444.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258105',4910300,'3056','472',327866.18,328680.59,814.41,171026.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258105',4910301,'3057','472',654061.92,655914.88,1852.96,389121.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258105',4910302,'3058','472',686025.49,687302.10,1276.61,268088.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258105',4910303,'3059','472',273719.85,274795.66,1075.81,225920.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258105',4910304,'3060','472',148176.98,148730.09,553.11,116153.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258105',4910305,'3061','472',226962.86,228539.61,1576.75,331117.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258105',4910306,'3062','472',958792.86,960119.89,1327.03,278676.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258105',4910307,'3063','472',318868.60,318868.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258105',4910308,'3064','473',219002.44,219002.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258106',4910309,'3056','472',328680.59,329675.51,994.92,208933.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258106',4910310,'3057','472',655914.88,658023.05,2108.17,442715.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258106',4910311,'3058','472',687302.10,687520.67,218.57,45899.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258106',4910312,'3059','472',274795.66,275444.36,648.70,136227.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258106',4910313,'3060','472',148730.09,149372.33,642.24,134870.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258106',4910314,'3061','472',228539.61,229984.80,1445.19,303489.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258106',4910315,'3062','472',960119.89,961362.38,1242.49,260922.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258106',4910316,'3063','472',318868.60,319732.73,864.13,181467.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258106',4910317,'3064','473',219002.44,219015.98,13.54,11509.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258107',4910318,'3056','472',329675.51,330939.03,1263.52,265339.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258107',4910319,'3057','472',658023.05,659679.53,1656.48,347860.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258107',4910320,'3058','472',687520.67,689015.78,1495.11,313973.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258107',4910321,'3059','472',275444.36,276883.45,1439.09,302208.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258107',4910322,'3060','472',149372.33,150742.04,1369.71,287639.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258107',4910323,'3061','472',229984.80,231150.45,1165.65,244786.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258107',4910324,'3062','472',961362.38,961362.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258107',4910325,'3063','472',319732.73,320521.68,788.95,165679.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258107',4910326,'3064','473',219015.98,219057.18,41.20,35020.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258108',4910327,'3056','472',330939.03,331487.29,528.26,110934.60,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258108',4910328,'3057','472',659679.53,660531.64,832.11,174743.10,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258108',4910329,'3058','472',689015.78,690581.27,1545.49,324552.90,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258108',4910330,'3059','472',276883.45,278556.37,1652.92,347113.20,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258108',4910331,'3060','472',150742.04,151912.57,1150.53,241611.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258108',4910332,'3061','472',231150.45,232286.36,1115.91,234341.10,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258108',4910333,'3062','472',961362.38,961566.05,183.67,38570.70,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258108',4910334,'3063','472',320521.68,321595.24,1053.56,221247.60,0.00,0.00,20.00,0.00,0.00),('1','206','1031','258108',4910335,'3064','473',219057.18,219957.19,900.01,765008.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258109',4910336,'3056','472',331487.29,331847.54,360.25,75652.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258109',4910337,'3057','472',660531.64,661368.96,837.32,175837.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258109',4910338,'3058','472',690581.27,691623.34,1042.07,218834.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258109',4910339,'3059','472',278556.37,279275.30,718.93,150975.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258109',4910340,'3060','472',151912.57,152451.11,538.54,113093.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258109',4910341,'3061','472',232286.36,232947.36,661.00,138810.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258109',4910342,'3062','472',961566.05,962497.03,930.98,195505.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258109',4910343,'3063','472',321595.24,322163.47,568.23,119328.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258109',4910344,'3064','473',219957.19,219957.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258110',4910345,'3056','472',331847.54,331944.20,96.66,20298.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258110',4910346,'3057','472',661368.96,663877.44,2508.48,526780.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258110',4910347,'3058','472',691623.34,691734.35,111.01,23312.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258110',4910348,'3059','472',279275.30,280737.87,1462.57,307139.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258110',4910349,'3060','472',152451.11,153063.82,612.71,128669.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258110',4910350,'3061','472',232947.36,234323.56,1376.20,289002.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258110',4910351,'3062','472',962497.03,963347.48,850.45,178594.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258110',4910352,'3063','472',322163.47,323292.39,1128.92,237073.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258110',4910353,'3064','473',219957.19,221237.72,1280.53,1088450.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258111',4910354,'3056','472',331944.20,332948.58,1004.38,210919.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258111',4910355,'3057','472',663877.44,665114.10,1236.66,259698.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258111',4910356,'3058','472',691734.35,693671.73,1937.38,406849.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258111',4910357,'3059','472',280737.87,282040.23,1302.36,273495.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258111',4910358,'3060','472',153063.82,153270.43,206.61,43388.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258111',4910359,'3061','472',234323.56,234743.15,419.59,88113.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258111',4910360,'3062','472',963347.48,964985.02,1637.54,343883.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258111',4910361,'3063','472',323292.39,324323.89,1031.50,216615.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258111',4910362,'3064','473',221237.72,222071.25,833.53,708500.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258112',4910363,'3056','472',332948.58,334054.03,1105.45,232144.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258112',4910364,'3057','472',665114.10,666746.59,1632.49,342822.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258112',4910365,'3058','472',693671.73,695476.76,1805.03,379056.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258112',4910366,'3059','472',282040.23,283005.86,965.63,202782.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258112',4910367,'3060','472',153270.43,153329.34,58.91,12371.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258112',4910368,'3061','472',234743.15,235800.11,1056.96,221961.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258112',4910369,'3062','472',964985.02,967937.00,2951.98,619915.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258112',4910370,'3063','472',324323.89,325370.37,1046.48,219760.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258112',4910371,'3064','473',222071.25,222072.72,1.47,1249.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258113',4910372,'3056','472',334054.03,334927.60,873.57,183449.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258113',4910373,'3057','472',666746.59,668932.88,2186.29,459120.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258113',4910374,'3058','472',695476.76,696446.33,969.57,203609.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258113',4910375,'3059','472',283005.86,284164.26,1158.40,243264.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258113',4910376,'3060','472',153329.34,154685.89,1356.55,284875.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258113',4910377,'3061','472',235800.11,236904.51,1104.40,231924.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258113',4910378,'3062','472',967937.00,969952.82,2015.82,423322.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258113',4910379,'3063','472',325370.37,326657.47,1287.10,270291.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258113',4910380,'3064','473',222072.72,222302.72,230.00,190900.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258114',4910381,'3056','472',334927.60,335609.15,681.55,143125.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258114',4910382,'3057','472',668932.88,671327.70,2394.82,502912.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258114',4910383,'3058','472',696446.33,697082.99,636.66,133698.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258114',4910384,'3059','472',284164.26,285593.51,1429.25,300142.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258114',4910385,'3060','472',154685.89,154685.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258114',4910386,'3061','472',236904.51,236904.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258114',4910387,'3062','472',969952.82,971839.40,1886.58,396181.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258114',4910388,'3063','472',326657.47,328808.80,2151.33,451779.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258114',4910389,'3064','473',222302.72,222302.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258115',4910390,'3056','472',335609.15,336368.80,759.65,159526.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258115',4910391,'3057','472',671327.70,673695.21,2367.51,497177.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258115',4910392,'3058','472',697082.99,698118.33,1035.34,217421.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258115',4910393,'3059','472',285593.51,287249.74,1656.23,347808.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258115',4910394,'3060','472',154685.89,154685.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258115',4910395,'3061','472',236904.51,236904.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258115',4910396,'3062','472',971839.40,974406.87,2567.47,539168.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258115',4910397,'3063','472',328808.80,330246.43,1437.63,301902.30,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258115',4910398,'3064','473',222302.72,222302.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258116',4910399,'3056','472',336368.80,337064.42,695.62,146080.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258116',4910400,'3057','472',673695.21,674893.66,1198.45,251674.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258116',4910401,'3058','472',698118.33,699580.14,1461.81,306980.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258116',4910402,'3059','472',287249.74,287960.65,710.91,149291.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258116',4910403,'3060','472',154685.89,155668.03,982.14,206249.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258116',4910404,'3061','472',236904.51,237503.70,599.19,125829.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258116',4910405,'3062','472',974406.87,975916.19,1509.32,316957.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258116',4910406,'3063','472',330246.43,330359.40,112.97,23723.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258116',4910407,'3064','473',222302.72,222302.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258117',4910408,'3056','472',337064.42,337206.25,141.83,29784.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258117',4910409,'3057','472',674893.66,676387.89,1494.23,313788.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258117',4910410,'3058','472',699580.14,700959.42,1379.28,289648.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258117',4910411,'3059','472',287960.65,289155.33,1194.68,250882.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258117',4910412,'3060','472',155668.03,156618.10,950.07,199514.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258117',4910413,'3061','472',237503.70,238074.99,571.29,119970.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258117',4910414,'3062','472',975916.19,976893.60,977.41,205256.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258117',4910415,'3063','472',330359.40,331853.62,1494.22,313786.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258117',4910416,'3064','473',222302.72,222304.53,1.81,1502.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258118',4910417,'3056','472',337206.25,338055.43,849.18,178327.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258118',4910418,'3057','472',676387.89,677627.98,1240.09,260418.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258118',4910419,'3058','472',700959.42,701680.76,699.92,146983.20,0.00,0.00,21.42,0.00,0.00),('1','206','1030','258118',4910420,'3059','472',289155.33,291302.94,2126.19,446499.90,0.00,0.00,21.42,0.00,0.00),('1','206','1030','258118',4910421,'3060','472',156618.10,157416.53,777.01,163172.10,0.00,0.00,21.42,0.00,0.00),('1','206','1030','258118',4910422,'3061','472',238074.99,238748.43,652.02,136924.20,0.00,0.00,21.42,0.00,0.00),('1','206','1030','258118',4910423,'3062','472',976893.60,978456.80,1541.78,323773.80,0.00,0.00,21.42,0.00,0.00),('1','206','1030','258118',4910424,'3063','472',331853.62,333621.86,1768.24,371330.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258118',4910425,'3064','473',222304.53,222334.54,30.01,24908.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258119',4910426,'3056','472',338055.43,338597.88,542.45,113914.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258119',4910427,'3057','472',677627.98,679171.45,1543.47,324128.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258119',4910428,'3058','472',701680.76,703631.26,1950.50,409605.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258119',4910429,'3059','472',291302.94,292725.97,1423.03,298836.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258119',4910430,'3060','472',157416.53,157416.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258119',4910431,'3061','472',238748.43,238748.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258119',4910432,'3062','472',978456.80,980732.72,2275.92,477943.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258119',4910433,'3063','472',333621.86,335342.80,1720.94,361397.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258119',4910434,'3064','473',222334.54,222340.56,6.02,4996.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258120',4910435,'3056','472',338597.88,339858.20,1260.32,264667.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258120',4910436,'3057','472',679171.45,679770.63,599.18,125827.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258120',4910437,'3058','472',703631.26,704869.05,1237.79,259935.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258120',4910438,'3059','472',292725.97,294345.75,1619.78,340153.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258120',4910439,'3060','472',157416.53,157905.37,488.84,102656.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258120',4910440,'3061','472',238748.43,239508.46,760.03,159606.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258120',4910441,'3062','472',980732.72,981944.56,1211.84,254486.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258120',4910442,'3063','472',335342.80,335978.71,635.91,133541.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258120',4910443,'3064','473',222340.56,222340.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258121',4910444,'3056','472',339858.20,340663.32,805.12,169075.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258121',4910445,'3057','472',679770.63,681404.41,1633.78,343093.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258121',4910446,'3058','472',704869.05,706090.64,1221.59,256533.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258121',4910447,'3059','472',294345.75,294925.99,580.24,121850.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258121',4910448,'3060','472',157905.37,159170.76,1265.39,265731.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258121',4910449,'3061','472',239508.46,241055.79,1547.33,324939.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258121',4910450,'3062','472',981944.56,982969.40,1024.84,215216.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258121',4910451,'3063','472',335978.71,337461.56,1482.85,311398.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258121',4910452,'3064','473',222340.56,222340.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258122',4910453,'3056','472',340663.32,341502.82,839.50,176295.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258122',4910454,'3057','472',681404.41,682374.89,970.48,203800.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258122',4910455,'3058','472',706090.64,707652.41,1561.77,327971.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258122',4910456,'3059','472',294925.99,295263.91,337.92,70963.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258122',4910457,'3060','472',159170.76,159757.29,586.53,123171.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258122',4910458,'3061','472',241055.79,241724.81,669.02,140494.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258122',4910459,'3062','472',982969.40,983242.70,273.30,57393.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258122',4910460,'3063','472',337461.56,337861.54,399.98,83995.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258122',4910461,'3064','473',222340.56,222340.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258123',4910462,'3056','472',341502.82,342440.66,917.34,192641.40,0.00,0.00,20.50,0.00,0.00),('1','206','1030','258123',4910463,'3057','472',682374.89,683877.94,1482.55,311335.50,0.00,0.00,20.50,0.00,0.00),('1','206','1030','258123',4910464,'3058','472',707652.41,709274.45,1601.54,336323.40,0.00,0.00,20.50,0.00,0.00),('1','206','1030','258123',4910465,'3059','472',295263.91,296512.27,1227.86,257850.60,0.00,0.00,20.50,0.00,0.00),('1','206','1030','258123',4910466,'3060','472',159757.29,159757.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258123',4910467,'3061','472',241724.81,241724.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258123',4910468,'3062','472',983242.70,984905.63,1642.43,344910.30,0.00,0.00,20.50,0.00,0.00),('1','206','1030','258123',4910469,'3063','472',337861.54,339631.83,1749.79,367455.90,0.00,0.00,20.50,0.00,0.00),('1','206','1031','258123',4910470,'3064','473',222340.56,222340.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258124',4910471,'3056','472',342440.66,342952.46,491.80,103278.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258124',4910472,'3057','472',683877.94,684196.53,298.59,62703.90,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258124',4910473,'3058','472',709274.45,709454.53,160.08,33616.80,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258124',4910474,'3059','472',296512.27,297226.37,694.10,145761.00,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258124',4910475,'3060','472',159757.29,160548.92,771.63,162042.30,0.00,0.00,20.00,0.00,0.00),('1','206','1030','258124',4910476,'3061','472',241724.81,242053.96,329.15,69121.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258124',4910477,'3062','472',984905.63,984905.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258124',4910478,'3063','472',339631.83,339631.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258124',4910479,'3064','473',222340.56,222340.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258125',4910480,'3056','472',342952.46,342952.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258125',4910481,'3057','472',684196.53,684296.18,99.65,20926.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258125',4910482,'3058','472',709454.53,710147.07,692.54,145433.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258125',4910483,'3059','472',297226.37,297747.99,511.62,107440.20,0.00,0.00,10.00,0.00,0.00),('1','206','1030','258125',4910484,'3060','472',160548.92,160548.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258125',4910485,'3061','472',242053.96,242053.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258125',4910486,'3062','472',984905.63,986793.18,1887.55,396385.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258125',4910487,'3063','472',339631.83,341723.74,2091.91,439301.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258125',4910488,'3064','473',222340.56,222340.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258126',4910489,'3056','472',342952.46,343214.33,261.87,54992.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258126',4910490,'3057','472',684296.18,685252.24,956.06,200772.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258126',4910491,'3058','472',710147.07,711304.81,1157.74,243125.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258126',4910492,'3059','472',297747.99,299653.27,1905.28,400108.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258126',4910493,'3060','472',160548.92,160548.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258126',4910494,'3061','472',242053.96,242053.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258126',4910495,'3062','472',986793.18,988493.33,1700.15,357031.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258126',4910496,'3063','472',341723.74,343358.16,1634.42,343228.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258126',4910497,'3064','473',222340.56,222340.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258127',4910498,'3056','472',343214.33,343214.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258127',4910499,'3057','472',685252.24,685252.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258127',4910500,'3058','472',711304.81,711400.05,95.24,20000.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258127',4910501,'3059','472',299653.27,299653.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258127',4910502,'3060','472',160548.92,160548.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258127',4910503,'3061','472',242053.96,242053.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258127',4910504,'3062','472',988493.33,990123.12,1629.79,342255.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258127',4910505,'3063','472',343358.16,344947.24,1589.08,333706.80,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258127',4910506,'3064','473',222340.56,222340.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258128',4910507,'3056','472',343214.33,343214.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258128',4910508,'3057','472',685252.24,685252.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258128',4910509,'3058','472',711400.05,712480.42,1080.37,226877.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258128',4910510,'3059','472',299653.27,301965.77,2312.50,485625.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258128',4910511,'3060','472',160548.92,160548.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258128',4910512,'3061','472',242053.96,242053.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258128',4910513,'3062','472',990123.12,994079.27,3956.15,830791.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258128',4910514,'3063','472',344947.24,347738.56,2791.32,586177.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258128',4910515,'3064','473',222340.56,222340.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258129',4910516,'3056','472',343214.33,344048.47,834.14,175169.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258129',4910517,'3057','472',685252.24,687190.56,1938.32,407047.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258129',4910518,'3058','472',712480.42,713058.56,578.14,121409.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258129',4910519,'3059','472',301965.77,302815.05,849.28,178348.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258129',4910520,'3060','472',160548.92,160548.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258129',4910521,'3061','472',242053.96,242053.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258129',4910522,'3062','472',994079.27,996277.18,2197.91,461561.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258129',4910523,'3063','472',347738.56,349514.05,1775.49,372852.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258129',4910524,'3064','473',222340.56,222825.42,484.86,402433.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258130',4910525,'3056','472',344048.47,344048.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258130',4910526,'3057','472',687190.56,687190.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258130',4910527,'3058','472',713058.56,713058.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258130',4910528,'3059','472',302815.05,302815.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258130',4910529,'3060','472',160548.92,160548.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258130',4910530,'3061','472',242053.96,242053.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258130',4910531,'3062','472',996277.18,998780.84,2503.66,525768.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258130',4910532,'3063','472',349514.05,350128.87,614.82,129112.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258130',4910533,'3064','473',222825.42,222825.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258131',4910534,'3056','472',344048.47,345073.34,1024.87,215222.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258131',4910535,'3057','472',687190.56,688769.92,1579.36,331665.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258131',4910536,'3058','472',713058.56,713367.76,309.20,64932.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258131',4910537,'3059','472',302815.05,302843.34,28.29,5940.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258131',4910538,'3060','472',160548.92,160548.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258131',4910539,'3061','472',242053.96,242053.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258131',4910540,'3062','472',998780.84,1001115.85,2335.01,490352.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258131',4910541,'3063','472',350128.87,352301.48,2172.61,456248.10,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258131',4910542,'3064','473',222825.42,224075.42,1250.00,1037500.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258132',4910543,'3056','472',345073.34,345073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258132',4910544,'3057','472',688769.92,688769.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258132',4910545,'3058','472',713367.76,716046.80,2679.04,562598.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258132',4910546,'3059','472',302843.34,306023.09,3161.34,663881.40,0.00,0.00,18.41,0.00,0.00),('1','206','1030','258132',4910547,'3060','472',160548.92,160548.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258132',4910548,'3061','472',242053.96,242053.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258132',4910549,'3062','472',1001115.85,1003765.05,2630.79,552465.90,0.00,0.00,18.41,0.00,0.00),('1','206','1030','258132',4910550,'3063','472',352301.48,354042.90,1723.01,361832.10,0.00,0.00,18.41,0.00,0.00),('1','206','1031','258132',4910551,'3064','473',224075.42,225345.73,1270.31,1054357.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258133',4910552,'3056','472',345073.34,346500.29,1426.95,299659.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258133',4910553,'3057','472',688769.92,691594.77,2809.48,589990.80,0.00,0.00,15.37,0.00,0.00),('1','206','1030','258133',4910554,'3058','472',716046.80,716046.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258133',4910555,'3059','472',306023.09,306023.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258133',4910556,'3060','472',160548.92,160548.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258133',4910557,'3061','472',242053.96,242053.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258133',4910558,'3062','472',1003765.05,1007815.92,4050.87,850682.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258133',4910559,'3063','472',354042.90,358961.87,4918.97,1032983.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258133',4910560,'3064','473',225345.73,225345.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258134',4910561,'3056','472',346500.29,347244.95,744.66,156378.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258134',4910562,'3057','472',691594.77,694516.85,2922.08,613636.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258134',4910563,'3058','472',716046.80,716509.39,462.59,97143.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258134',4910564,'3059','472',306023.09,306023.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258134',4910565,'3060','472',160548.92,161396.69,847.77,178031.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258134',4910566,'3061','472',242053.96,242769.31,715.35,150223.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258134',4910567,'3062','472',1007815.92,1009602.66,1786.74,375215.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258134',4910568,'3063','472',358961.87,360097.11,1135.24,238400.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258134',4910569,'3064','473',225345.73,225345.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258135',4910570,'3056','472',347244.95,348885.10,1640.15,344431.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258135',4910571,'3057','472',694516.85,697097.45,2580.60,541926.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258135',4910572,'3058','472',716509.39,719142.38,2632.99,552927.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258135',4910573,'3059','472',306023.09,307430.81,1407.72,295621.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258135',4910574,'3060','472',161396.69,161631.56,234.87,49322.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258135',4910575,'3061','472',242769.31,243104.23,334.92,70333.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258135',4910576,'3062','472',1009602.66,1010938.25,1335.59,280473.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258135',4910577,'3063','472',360097.11,362055.77,1958.66,411318.60,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258135',4910578,'3064','473',225345.73,226203.93,858.20,712306.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258136',4910579,'3056','472',348885.10,349796.42,911.32,191377.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258136',4910580,'3057','472',697097.45,698414.89,1317.44,276662.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258136',4910581,'3058','472',719142.38,720907.68,1741.30,365673.00,0.00,0.00,24.00,0.00,0.00),('1','206','1030','258136',4910582,'3059','472',307430.81,308698.49,1246.92,261853.20,0.00,0.00,20.76,0.00,0.00),('1','206','1030','258136',4910583,'3060','472',161631.56,161631.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258136',4910584,'3061','472',243104.23,243104.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258136',4910585,'3062','472',1010938.25,1012635.21,1696.96,356361.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258136',4910586,'3063','472',362055.77,363326.12,1270.35,266773.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258136',4910587,'3064','473',226203.93,226203.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258137',4910588,'3056','472',349796.42,350494.43,698.01,146582.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258137',4910589,'3057','472',698414.89,700102.78,1687.89,354456.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258137',4910590,'3058','472',720907.68,722757.99,1850.31,388565.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258137',4910591,'3059','472',308698.49,310555.57,1857.08,389986.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258137',4910592,'3060','472',161631.56,161631.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258137',4910593,'3061','472',243104.23,243214.87,110.64,23234.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258137',4910594,'3062','472',1012635.21,1015599.98,2964.77,622601.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258137',4910595,'3063','472',363326.12,364151.41,825.29,173310.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258137',4910596,'3064','473',226203.93,226403.93,200.00,166000.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258138',4910597,'3056','472',350494.43,351964.22,1469.79,308655.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258138',4910598,'3057','472',700102.78,701096.04,993.26,208584.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258138',4910599,'3058','472',722757.99,723800.11,1042.12,218845.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258138',4910600,'3059','472',310555.57,311722.72,1167.15,245101.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258138',4910601,'3060','472',161631.56,161805.43,173.87,36512.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258138',4910602,'3061','472',243214.87,243429.15,214.28,44998.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258138',4910603,'3062','472',1015599.98,1016570.00,970.02,203704.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258138',4910604,'3063','472',364151.41,365217.98,1066.57,223979.70,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258138',4910605,'3064','473',226403.93,226403.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258139',4910606,'3056','472',351964.22,353530.74,1566.52,328969.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258139',4910607,'3057','472',701096.04,702716.15,1620.11,340223.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258139',4910608,'3058','472',723800.11,725951.08,2150.97,451703.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258139',4910609,'3059','472',311722.72,312621.83,899.11,188813.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258139',4910610,'3060','472',161805.43,162643.80,838.37,176057.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258139',4910611,'3061','472',243429.15,244579.78,1150.63,241632.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258139',4910612,'3062','472',1016570.00,1019205.97,2635.97,553553.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258139',4910613,'3063','472',365217.98,368418.07,3200.09,672018.90,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258139',4910614,'3064','473',226403.93,226403.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258140',4910615,'3056','472',353530.74,354062.21,531.47,111608.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258140',4910616,'3057','472',702716.15,704316.27,1600.12,336025.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258140',4910617,'3058','472',725951.08,727539.56,1588.48,333580.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258140',4910618,'3059','472',312621.83,313530.31,908.48,190780.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258140',4910619,'3060','472',162643.80,162874.42,230.62,48430.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258140',4910620,'3061','472',244579.78,244744.98,165.20,34692.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258140',4910621,'3062','472',1019205.97,1019855.27,649.30,136353.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258140',4910622,'3063','472',368418.07,369467.51,1049.44,220382.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258140',4910623,'3064','473',226403.93,226403.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258141',4910624,'3056','472',354062.21,355041.02,978.81,205550.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258141',4910625,'3057','472',704316.27,705655.96,1339.69,281334.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258141',4910626,'3058','472',727539.56,729254.36,1714.80,360108.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258141',4910627,'3059','472',313530.31,314903.72,1373.41,288416.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258141',4910628,'3060','472',162874.42,163924.56,1050.14,220529.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258141',4910629,'3061','472',244744.98,245582.05,837.07,175784.70,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258141',4910630,'3062','472',1019855.27,1022827.45,2972.18,624157.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258141',4910631,'3063','472',369467.51,370149.36,681.85,143188.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258141',4910632,'3064','473',226403.93,226508.93,105.00,86100.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258142',4910633,'3056','472',355041.02,356809.95,1768.93,371475.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258142',4910634,'3057','472',705655.96,707882.46,2226.50,467565.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258142',4910635,'3058','472',729254.36,729254.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258142',4910636,'3059','472',314903.72,315072.13,168.41,35366.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258142',4910637,'3060','472',163924.56,163924.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258142',4910638,'3061','472',245582.05,245582.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258142',4910639,'3062','472',1022827.45,1024753.63,1926.18,404497.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258142',4910640,'3063','472',370149.36,371331.41,1182.05,248230.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258142',4910641,'3064','473',226508.93,226508.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258143',4910642,'3056','472',356809.95,358592.77,1782.82,374392.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258143',4910643,'3057','472',707882.46,710141.96,2238.87,470162.70,0.00,0.00,20.63,0.00,0.00),('1','206','1030','258143',4910644,'3058','472',729254.36,729254.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258143',4910645,'3059','472',315072.13,315072.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258143',4910646,'3060','472',163924.56,163924.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258143',4910647,'3061','472',245582.05,245582.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258143',4910648,'3062','472',1024753.63,1027399.91,2625.65,551386.50,0.00,0.00,20.63,0.00,0.00),('1','206','1030','258143',4910649,'3063','472',371331.41,374316.36,2964.32,622507.20,0.00,0.00,20.63,0.00,0.00),('1','206','1031','258143',4910650,'3064','473',226508.93,226508.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258144',4910651,'3056','472',358592.77,359602.23,1009.46,211986.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258144',4910652,'3057','472',710141.96,712277.96,2136.00,448560.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258144',4910653,'3058','472',729254.36,730178.11,923.75,193987.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258144',4910654,'3059','472',315072.13,316608.22,1536.09,322578.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258144',4910655,'3060','472',163924.56,163924.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258144',4910656,'3061','472',245582.05,245582.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258144',4910657,'3062','472',1027399.91,1029672.27,2272.36,477195.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258144',4910658,'3063','472',374316.36,376506.56,2190.20,459942.00,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258144',4910659,'3064','473',226508.93,226508.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258145',4910660,'3056','472',359602.23,360757.24,1155.01,242552.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258145',4910661,'3057','472',712277.96,714022.56,1744.60,366365.58,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258145',4910662,'3058','472',730178.11,732602.30,2424.19,509079.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258145',4910663,'3059','472',316608.22,318752.50,2144.28,450298.80,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258145',4910664,'3060','472',163924.56,163924.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258145',4910665,'3061','472',245582.05,246006.99,424.94,89237.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258145',4910666,'3062','472',1029672.27,1032490.23,2817.96,591771.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258145',4910667,'3063','472',376506.56,378176.48,1669.92,350683.20,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258145',4910668,'3064','473',226508.93,226508.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258146',4910669,'3056','472',360757.24,362061.69,1304.45,273934.50,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258146',4910670,'3057','472',714022.56,716542.72,2520.16,529233.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258146',4910671,'3058','472',732602.30,733914.11,1311.81,275480.10,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258146',4910672,'3059','472',318752.50,319388.70,636.20,133602.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258146',4910673,'3060','472',163924.56,163924.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258146',4910674,'3061','472',246006.99,246006.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258146',4910675,'3062','472',1032490.23,1034487.12,1996.89,419346.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258146',4910676,'3063','472',378176.48,379891.32,1714.84,360116.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258146',4910677,'3064','473',226508.93,226508.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258147',4910678,'3056','472',362061.69,362629.21,567.52,119179.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258147',4910679,'3057','472',716542.72,717533.96,991.24,208160.40,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258147',4910680,'3058','472',733914.11,735251.81,1337.70,280917.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258147',4910681,'3059','472',319388.70,320523.72,1135.02,238354.20,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258147',4910682,'3060','472',163924.56,163924.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258147',4910683,'3061','472',246006.99,246006.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258147',4910684,'3062','472',1034487.12,1036916.01,2428.89,510066.90,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258147',4910685,'3063','472',379891.32,381649.37,1758.05,369190.50,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258147',4910686,'3064','473',226508.93,226508.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258148',4910687,'3056','472',362629.21,364184.74,1555.53,326661.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258148',4910688,'3057','472',717533.96,719206.02,1672.06,351132.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258148',4910689,'3058','472',735251.81,738166.74,2914.93,612135.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258148',4910690,'3059','472',320523.72,321861.15,1337.43,280860.30,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258148',4910691,'3060','472',163924.56,163924.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258148',4910692,'3061','472',246006.99,246006.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258148',4910693,'3062','472',1036916.01,1038893.47,1977.46,415266.60,0.00,0.00,0.00,0.00,0.00),('1','206','1030','258148',4910694,'3063','472',381649.37,383365.01,1715.64,360284.40,0.00,0.00,0.00,0.00,0.00),('1','206','1031','258148',4910695,'3064','473',226508.93,226508.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=731018 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','206','245375','472',165.00,165.00,2094.95,0.00,0.00,0.00,0.00,698375),('1','206','245375','473',345.00,345.00,6.27,0.00,0.00,0.00,0.00,698376),('1','206','245500','472',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698683),('1','206','245500','473',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698684),('1','206','245508','472',165.00,165.00,5656.03,0.00,0.00,0.00,0.00,698702),('1','206','245508','473',345.00,345.00,260.03,0.00,0.00,0.00,0.00,698703),('1','206','245604','472',165.00,165.00,4973.33,0.00,0.00,0.00,0.00,698971),('1','206','245604','473',345.00,345.00,224.35,0.00,0.00,0.00,0.00,698972),('1','206','248093','472',165.00,165.00,3099.66,0.00,0.00,0.00,0.00,705425),('1','206','248093','473',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705426),('1','206','248301','472',165.00,165.00,3830.60,0.00,0.00,0.00,0.00,705964),('1','206','248301','473',345.00,345.00,131.60,0.00,0.00,0.00,0.00,705965),('1','206','248360','472',165.00,165.00,6737.15,0.00,0.00,0.00,0.00,706119),('1','206','248360','473',345.00,345.00,130.40,0.00,0.00,0.00,0.00,706120),('1','206','248492','472',165.00,165.00,5822.53,0.00,0.00,0.00,0.00,706432),('1','206','248492','473',345.00,345.00,13.92,0.00,0.00,0.00,0.00,706433),('1','206','248599','472',165.00,165.00,9083.27,0.00,0.00,0.00,0.00,706733),('1','206','248599','473',345.00,345.00,21.17,0.00,0.00,0.00,0.00,706734),('1','206','248793','472',165.00,165.00,7087.03,0.00,0.00,0.00,0.00,707223),('1','206','248793','473',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707224),('1','206','248993','472',165.00,165.00,7421.09,0.00,0.00,0.00,0.00,707738),('1','206','248993','473',345.00,345.00,149.07,0.00,0.00,0.00,0.00,707739),('1','206','249017','472',165.00,165.00,10327.94,0.00,0.00,0.00,0.00,707805),('1','206','249017','473',345.00,345.00,5.22,0.00,0.00,0.00,0.00,707806),('1','206','249064','472',165.00,165.00,6059.86,0.00,0.00,0.00,0.00,707933),('1','206','249064','473',345.00,345.00,166.00,0.00,0.00,0.00,0.00,707934),('1','206','249210','472',165.00,165.00,4870.17,0.00,0.00,0.00,0.00,708284),('1','206','249210','473',345.00,345.00,191.84,0.00,0.00,0.00,0.00,708285),('1','206','249436','472',165.00,165.00,5607.09,0.00,0.00,0.00,0.00,708855),('1','206','249436','473',345.00,345.00,41.04,0.00,0.00,0.00,0.00,708856),('1','206','249465','472',165.00,165.00,4843.63,0.00,0.00,0.00,0.00,708937),('1','206','249465','473',345.00,345.00,16.82,0.00,0.00,0.00,0.00,708938),('1','206','249522','472',165.00,165.00,3781.44,0.00,0.00,0.00,0.00,709092),('1','206','249522','473',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709093),('1','206','249723','472',165.00,165.00,3762.43,0.00,0.00,0.00,0.00,709609),('1','206','249723','473',345.00,345.00,15.94,0.00,0.00,0.00,0.00,709610),('1','206','249955','472',165.00,165.00,4928.21,0.00,0.00,0.00,0.00,710196),('1','206','249955','473',345.00,345.00,209.18,0.00,0.00,0.00,0.00,710197),('1','206','249989','472',165.00,165.00,5871.44,0.00,0.00,0.00,0.00,710289),('1','206','249989','473',345.00,345.00,102.90,0.00,0.00,0.00,0.00,710290),('1','206','250186','472',165.00,165.00,5391.48,0.00,0.00,0.00,0.00,710780),('1','206','250186','473',345.00,345.00,170.29,0.00,0.00,0.00,0.00,710781),('1','206','250235','472',165.00,165.00,3130.58,0.00,0.00,0.00,0.00,710914),('1','206','250235','473',345.00,345.00,155.94,0.00,0.00,0.00,0.00,710915),('1','206','250408','472',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711335),('1','206','250408','473',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711336),('1','206','250409','472',165.00,165.00,7498.46,0.00,0.00,0.00,0.00,711337),('1','206','250409','473',345.00,345.00,106.82,0.00,0.00,0.00,0.00,711338),('1','206','250506','472',165.00,165.00,2359.49,0.00,0.00,0.00,0.00,711604),('1','206','250506','473',345.00,345.00,14.49,0.00,0.00,0.00,0.00,711605),('1','206','250646','472',165.00,165.00,2663.49,0.00,0.00,0.00,0.00,711950),('1','206','250646','473',345.00,345.00,28.98,0.00,0.00,0.00,0.00,711951),('1','206','250747','472',165.00,165.00,2773.05,0.00,0.00,0.00,0.00,712241),('1','206','250747','473',345.00,345.00,42.03,0.00,0.00,0.00,0.00,712242),('1','206','250876','472',165.00,165.00,2964.55,0.00,0.00,0.00,0.00,712545),('1','206','250876','473',345.00,345.00,118.55,0.00,0.00,0.00,0.00,712546),('1','206','250971','472',165.00,165.00,4060.23,0.00,0.00,0.00,0.00,712814),('1','206','250971','473',345.00,345.00,14.20,0.00,0.00,0.00,0.00,712815),('1','206','251106','472',165.00,165.00,7286.17,0.00,0.00,0.00,0.00,713138),('1','206','251106','473',345.00,345.00,67.68,0.00,0.00,0.00,0.00,713139),('1','206','251228','472',165.00,165.00,4118.47,0.00,0.00,0.00,0.00,713481),('1','206','251228','473',345.00,345.00,102.32,0.00,0.00,0.00,0.00,713482),('1','206','251229','472',165.00,165.00,4559.06,0.00,0.00,0.00,0.00,713483),('1','206','251229','473',345.00,345.00,169.51,0.00,0.00,0.00,0.00,713484),('1','206','251376','472',165.00,165.00,3186.10,0.00,0.00,0.00,0.00,713851),('1','206','251376','473',345.00,345.00,18.55,0.00,0.00,0.00,0.00,713852),('1','206','251461','472',165.00,165.00,4228.02,0.00,0.00,0.00,0.00,714089),('1','206','251461','473',345.00,345.00,4.35,0.00,0.00,0.00,0.00,714090),('1','206','251615','472',165.00,165.00,4377.48,0.00,0.00,0.00,0.00,714473),('1','206','251615','473',345.00,345.00,171.70,0.00,0.00,0.00,0.00,714474),('1','206','251679','472',165.00,165.00,7581.96,0.00,0.00,0.00,0.00,714654),('1','206','251679','473',345.00,345.00,475.67,0.00,0.00,0.00,0.00,714655),('1','206','251842','472',165.00,165.00,3064.86,0.00,0.00,0.00,0.00,715071),('1','206','251842','473',345.00,345.00,61.02,0.00,0.00,0.00,0.00,715072),('1','206','251958','472',165.00,165.00,4408.84,0.00,0.00,0.00,0.00,715395),('1','206','251958','473',345.00,345.00,82.62,0.00,0.00,0.00,0.00,715396),('1','206','252109','472',165.00,165.00,3451.22,0.00,0.00,0.00,0.00,715763),('1','206','252109','473',345.00,345.00,15.94,0.00,0.00,0.00,0.00,715764),('1','206','252309','472',165.00,165.00,4354.15,0.00,0.00,0.00,0.00,716286),('1','206','252309','473',345.00,345.00,101.75,0.00,0.00,0.00,0.00,716287),('1','206','252416','472',165.00,165.00,2601.31,0.00,0.00,0.00,0.00,716580),('1','206','252416','473',345.00,345.00,26.09,0.00,0.00,0.00,0.00,716581),('1','206','252432','472',165.00,165.00,3931.26,0.00,0.00,0.00,0.00,716626),('1','206','252432','473',345.00,345.00,23.76,0.00,0.00,0.00,0.00,716627),('1','206','252601','472',165.00,165.00,2703.64,0.00,0.00,0.00,0.00,717053),('1','206','252601','473',345.00,345.00,55.65,0.00,0.00,0.00,0.00,717054),('1','206','252666','472',165.00,165.00,3110.04,0.00,0.00,0.00,0.00,717232),('1','206','252666','473',345.00,345.00,0.87,0.00,0.00,0.00,0.00,717233),('1','206','252917','472',165.00,165.00,4846.38,0.00,0.00,0.00,0.00,717882),('1','206','252917','473',345.00,345.00,176.31,0.00,0.00,0.00,0.00,717883),('1','206','253080','472',165.00,165.00,2239.67,0.00,0.00,0.00,0.00,718290),('1','206','253080','473',345.00,345.00,24.93,0.00,0.00,0.00,0.00,718291),('1','206','253331','472',165.00,165.00,5154.68,0.00,0.00,0.00,0.00,718954),('1','206','253331','473',345.00,345.00,143.28,0.00,0.00,0.00,0.00,718955),('1','206','253351','472',165.00,165.00,3270.83,0.00,0.00,0.00,0.00,719007),('1','206','253351','473',345.00,345.00,190.64,0.00,0.00,0.00,0.00,719008),('1','206','253397','472',165.00,165.00,5514.72,0.00,0.00,0.00,0.00,719128),('1','206','253397','473',345.00,345.00,104.35,0.00,0.00,0.00,0.00,719129),('1','206','253570','472',165.00,165.00,3990.01,0.00,0.00,0.00,0.00,719567),('1','206','253570','473',345.00,345.00,74.21,0.00,0.00,0.00,0.00,719568),('1','206','253662','472',165.00,165.00,6234.59,0.00,0.00,0.00,0.00,719825),('1','206','253662','473',345.00,345.00,4.35,0.00,0.00,0.00,0.00,719826),('1','206','253826','472',165.00,165.00,3138.91,0.00,0.00,0.00,0.00,720231),('1','206','253826','473',345.00,345.00,36.23,0.00,0.00,0.00,0.00,720232),('1','206','253908','472',165.00,165.00,7273.66,0.00,0.00,0.00,0.00,720464),('1','206','253908','473',345.00,345.00,471.85,0.00,0.00,0.00,0.00,720465),('1','206','254063','472',165.00,165.00,3368.10,0.00,0.00,0.00,0.00,720850),('1','206','254063','473',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720851),('1','206','254386','472',165.00,165.00,90.00,0.00,0.00,0.00,0.00,721698),('1','206','254386','473',345.00,345.00,228.99,0.00,0.00,0.00,0.00,721699),('1','206','255121','472',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723568),('1','206','255121','473',350.00,350.00,1065.00,0.00,0.00,0.00,0.00,723569),('1','206','255528','472',165.00,165.00,2010.28,0.00,0.00,0.00,0.00,724565),('1','206','255528','473',355.00,355.00,0.00,0.00,0.00,0.00,0.00,724566),('1','206','255792','472',165.00,165.00,2422.58,0.00,0.00,0.00,0.00,725230),('1','206','255792','473',355.00,355.00,944.87,0.00,0.00,0.00,0.00,725231),('1','206','255829','472',165.00,165.00,1579.95,0.00,0.00,0.00,0.00,725331),('1','206','255829','473',355.00,355.00,0.00,0.00,0.00,0.00,0.00,725332),('1','206','256026','472',165.00,165.00,2361.68,0.00,0.00,0.00,0.00,725830),('1','206','256026','473',355.00,355.00,143.04,0.00,0.00,0.00,0.00,725831),('1','206','256059','472',165.00,165.00,1617.76,0.00,0.00,0.00,0.00,725917),('1','206','256059','473',355.00,355.00,16.63,0.00,0.00,0.00,0.00,725918),('1','206','256146','472',165.00,165.00,3430.99,0.00,0.00,0.00,0.00,726147),('1','206','256146','473',355.00,355.00,386.85,0.00,0.00,0.00,0.00,726148),('1','206','256346','472',165.00,165.00,2886.41,0.00,0.00,0.00,0.00,726627),('1','206','256346','473',355.00,355.00,3.94,0.00,0.00,0.00,0.00,726628),('1','206','256527','472',165.00,165.00,4477.90,0.00,0.00,0.00,0.00,727099),('1','206','256527','473',355.00,355.00,162.81,0.00,0.00,0.00,0.00,727100),('1','206','256588','472',165.00,165.00,1652.32,0.00,0.00,0.00,0.00,727258),('1','206','256588','473',355.00,355.00,30.71,0.00,0.00,0.00,0.00,727259),('1','206','256670','472',165.00,165.00,4428.06,0.00,0.00,0.00,0.00,727484),('1','206','256670','473',355.00,355.00,159.54,0.00,0.00,0.00,0.00,727485),('1','206','256813','472',165.00,165.00,3718.41,0.00,0.00,0.00,0.00,727837),('1','206','256813','473',355.00,355.00,14.08,0.00,0.00,0.00,0.00,727838),('1','206','257017','472',165.00,165.00,3808.18,0.00,0.00,0.00,0.00,728361),('1','206','257017','473',355.00,355.00,134.08,0.00,0.00,0.00,0.00,728362),('1','206','257096','472',165.00,165.00,2702.97,0.00,0.00,0.00,0.00,728586),('1','206','257096','473',360.00,360.00,4.72,0.00,0.00,0.00,0.00,728587),('1','206','257183','472',165.00,165.00,4898.48,0.00,0.00,0.00,0.00,728828),('1','206','257183','473',360.00,360.00,25.19,0.00,0.00,0.00,0.00,728829),('1','206','257403','472',165.00,165.00,2709.44,0.00,0.00,0.00,0.00,729394),('1','206','257403','473',360.00,360.00,152.93,0.00,0.00,0.00,0.00,729395),('1','206','257624','472',165.00,165.00,5104.09,0.00,0.00,0.00,0.00,729968),('1','206','257624','473',360.00,360.00,511.12,0.00,0.00,0.00,0.00,729969),('1','206','257625','473',360.00,360.00,101.97,0.00,0.00,0.00,0.00,729970),('1','206','257625','472',165.00,165.00,5936.85,0.00,0.00,0.00,0.00,729971),('1','206','257626','473',360.00,360.00,537.50,0.00,0.00,0.00,0.00,729972),('1','206','257626','472',165.00,165.00,3296.47,0.00,0.00,0.00,0.00,729973),('1','206','257627','473',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729974),('1','206','257627','472',165.00,165.00,722.12,0.00,0.00,0.00,0.00,729975),('1','206','257628','473',360.00,360.00,980.56,0.00,0.00,0.00,0.00,729976),('1','206','257628','472',165.00,165.00,1181.72,0.00,0.00,0.00,0.00,729977),('1','206','257629','473',360.00,360.00,1190.42,0.00,0.00,0.00,0.00,729978),('1','206','257629','472',165.00,165.00,3996.11,0.00,0.00,0.00,0.00,729979),('1','206','257630','473',360.00,360.00,28.62,0.00,0.00,0.00,0.00,729980),('1','206','257630','472',165.00,165.00,2153.20,0.00,0.00,0.00,0.00,729981),('1','206','257631','473',360.00,360.00,262.57,0.00,0.00,0.00,0.00,729982),('1','206','257631','472',165.00,165.00,3677.49,0.00,0.00,0.00,0.00,729983),('1','206','257632','473',360.00,360.00,103.63,0.00,0.00,0.00,0.00,729984),('1','206','257632','472',165.00,165.00,3198.64,0.00,0.00,0.00,0.00,729985),('1','206','257633','473',360.00,360.00,362.32,0.00,0.00,0.00,0.00,729986),('1','206','257633','472',165.00,165.00,4756.73,0.00,0.00,0.00,0.00,729987),('1','206','257634','473',360.00,360.00,3139.92,0.00,0.00,0.00,0.00,729988),('1','206','257634','472',165.00,165.00,3104.43,0.00,0.00,0.00,0.00,729989),('1','206','257635','473',380.00,380.00,1608.04,0.00,0.00,0.00,0.00,729990),('1','206','257635','472',165.00,165.00,4966.39,0.00,0.00,0.00,0.00,729991),('1','206','257636','473',380.00,380.00,284.02,0.00,0.00,0.00,0.00,729992),('1','206','257636','472',165.00,165.00,2346.73,0.00,0.00,0.00,0.00,729993),('1','206','257637','473',380.00,380.00,65.41,0.00,0.00,0.00,0.00,729994),('1','206','257637','472',165.00,165.00,3381.68,0.00,0.00,0.00,0.00,729995),('1','206','257638','473',380.00,380.00,1.32,0.00,0.00,0.00,0.00,729996),('1','206','257638','472',165.00,165.00,2971.07,0.00,0.00,0.00,0.00,729997),('1','206','257639','473',380.00,380.00,22.89,0.00,0.00,0.00,0.00,729998),('1','206','257639','472',165.00,165.00,10724.38,0.00,0.00,0.00,0.00,729999),('1','206','257640','473',380.00,380.00,278.96,0.00,0.00,0.00,0.00,730000),('1','206','257640','472',165.00,165.00,6383.69,0.00,0.00,0.00,0.00,730001),('1','206','257641','473',380.00,380.00,5.26,0.00,0.00,0.00,0.00,730002),('1','206','257641','472',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730003),('1','206','257642','473',390.00,390.00,2325.48,0.00,0.00,0.00,0.00,730004),('1','206','257642','472',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730005),('1','206','257643','473',390.00,390.00,326.17,0.00,0.00,0.00,0.00,730006),('1','206','257643','472',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730007),('1','206','257644','473',400.00,400.00,1132.50,0.00,0.00,0.00,0.00,730008),('1','206','257644','472',165.00,165.00,10204.21,0.00,0.00,0.00,0.00,730009),('1','206','257645','473',400.00,400.00,225.00,0.00,0.00,0.00,0.00,730010),('1','206','257645','472',165.00,165.00,509.82,0.00,0.00,0.00,0.00,730011),('1','206','257646','473',400.00,400.00,406.25,0.00,0.00,0.00,0.00,730012),('1','206','257646','472',165.00,165.00,5369.51,0.00,0.00,0.00,0.00,730013),('1','206','257647','473',400.00,400.00,4371.83,0.00,0.00,0.00,0.00,730014),('1','206','257647','472',165.00,165.00,496.95,0.00,0.00,0.00,0.00,730015),('1','206','257648','473',400.00,400.00,350.00,0.00,0.00,0.00,0.00,730016),('1','206','257648','472',165.00,165.00,473.55,0.00,0.00,0.00,0.00,730017),('1','206','257649','473',410.00,410.00,1300.00,0.00,0.00,0.00,0.00,730018),('1','206','257649','472',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730019),('1','206','257650','473',410.00,410.00,149.53,0.00,0.00,0.00,0.00,730020),('1','206','257650','472',165.00,165.00,8452.11,0.00,0.00,0.00,0.00,730021),('1','206','257651','473',410.00,410.00,1128.54,0.00,0.00,0.00,0.00,730022),('1','206','257651','472',165.00,165.00,3844.49,0.00,0.00,0.00,0.00,730023),('1','206','257652','473',410.00,410.00,0.00,0.00,0.00,0.00,0.00,730024),('1','206','257652','472',165.00,165.00,1651.34,0.00,0.00,0.00,0.00,730025),('1','206','257653','473',410.00,410.00,0.00,0.00,0.00,0.00,0.00,730026),('1','206','257653','472',165.00,165.00,2060.37,0.00,0.00,0.00,0.00,730027),('1','206','257654','473',410.00,410.00,0.00,0.00,0.00,0.00,0.00,730028),('1','206','257654','472',165.00,165.00,972.95,0.00,0.00,0.00,0.00,730029),('1','206','257655','473',410.00,410.00,94.33,0.00,0.00,0.00,0.00,730030),('1','206','257655','472',165.00,165.00,12240.54,0.00,0.00,0.00,0.00,730031),('1','206','257656','473',410.00,410.00,0.00,0.00,0.00,0.00,0.00,730032),('1','206','257656','472',165.00,165.00,5807.05,0.00,0.00,0.00,0.00,730033),('1','206','257657','473',410.00,410.00,0.00,0.00,0.00,0.00,0.00,730034),('1','206','257657','472',165.00,165.00,5016.15,0.00,0.00,0.00,0.00,730035),('1','206','257658','473',410.00,410.00,0.00,0.00,0.00,0.00,0.00,730036),('1','206','257658','472',165.00,165.00,5609.11,0.00,0.00,0.00,0.00,730037),('1','206','257659','473',410.00,410.00,0.00,0.00,0.00,0.00,0.00,730038),('1','206','257659','472',165.00,165.00,715.83,0.00,0.00,0.00,0.00,730039),('1','206','257660','473',420.00,420.00,0.00,0.00,0.00,0.00,0.00,730040),('1','206','257660','472',165.00,165.00,654.91,0.00,0.00,0.00,0.00,730041),('1','206','257661','473',420.00,420.00,0.00,0.00,0.00,0.00,0.00,730042),('1','206','257661','472',165.00,165.00,3026.28,0.00,0.00,0.00,0.00,730043),('1','206','257662','473',420.00,420.00,0.00,0.00,0.00,0.00,0.00,730044),('1','206','257662','472',165.00,165.00,7399.02,0.00,0.00,0.00,0.00,730045),('1','206','257663','473',420.00,420.00,0.00,0.00,0.00,0.00,0.00,730046),('1','206','257663','472',165.00,165.00,4904.90,0.00,0.00,0.00,0.00,730047),('1','206','257664','473',420.00,420.00,0.00,0.00,0.00,0.00,0.00,730048),('1','206','257664','472',165.00,165.00,4440.46,0.00,0.00,0.00,0.00,730049),('1','206','257665','473',420.00,420.00,0.00,0.00,0.00,0.00,0.00,730050),('1','206','257665','472',165.00,165.00,3683.31,0.00,0.00,0.00,0.00,730051),('1','206','257666','473',420.00,420.00,0.00,0.00,0.00,0.00,0.00,730052),('1','206','257666','472',165.00,165.00,4097.47,0.00,0.00,0.00,0.00,730053),('1','206','257667','473',460.00,460.00,0.00,0.00,0.00,0.00,0.00,730054),('1','206','257667','472',165.00,165.00,5041.04,0.00,0.00,0.00,0.00,730055),('1','206','257668','473',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730056),('1','206','257668','472',165.00,165.00,8090.10,0.00,0.00,0.00,0.00,730057),('1','206','257669','473',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730058),('1','206','257669','472',165.00,165.00,6252.77,0.00,0.00,0.00,0.00,730059),('1','206','257670','473',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730060),('1','206','257670','472',165.00,165.00,4745.29,0.00,0.00,0.00,0.00,730061),('1','206','257671','473',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730062),('1','206','257671','472',165.00,165.00,8740.65,0.00,0.00,0.00,0.00,730063),('1','206','257672','473',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730064),('1','206','257672','472',165.00,165.00,5727.54,0.00,0.00,0.00,0.00,730065),('1','206','257673','473',500.00,500.00,0.00,0.00,0.00,0.00,0.00,730066),('1','206','257673','472',165.00,165.00,3470.57,0.00,0.00,0.00,0.00,730067),('1','206','257674','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730068),('1','206','257674','472',165.00,165.00,13531.47,0.00,0.00,0.00,0.00,730069),('1','206','257675','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730070),('1','206','257675','472',165.00,165.00,14170.99,0.00,0.00,0.00,0.00,730071),('1','206','257676','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730072),('1','206','257676','472',165.00,165.00,11567.83,0.00,0.00,0.00,0.00,730073),('1','206','257677','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730074),('1','206','257677','472',165.00,165.00,10077.60,0.00,0.00,0.00,0.00,730075),('1','206','257678','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730076),('1','206','257678','472',165.00,165.00,6869.55,0.00,0.00,0.00,0.00,730077),('1','206','257679','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730078),('1','206','257679','472',165.00,165.00,2346.03,0.00,0.00,0.00,0.00,730079),('1','206','257680','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730080),('1','206','257680','472',165.00,165.00,2682.33,0.00,0.00,0.00,0.00,730081),('1','206','257681','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730082),('1','206','257681','472',165.00,165.00,3706.12,0.00,0.00,0.00,0.00,730083),('1','206','257682','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730084),('1','206','257682','472',165.00,165.00,11122.63,0.00,0.00,0.00,0.00,730085),('1','206','257683','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730086),('1','206','257683','472',165.00,165.00,6646.93,0.00,0.00,0.00,0.00,730087),('1','206','257684','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730088),('1','206','257684','472',165.00,165.00,7711.00,0.00,0.00,0.00,0.00,730089),('1','206','257685','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730090),('1','206','257685','472',165.00,165.00,5551.20,0.00,0.00,0.00,0.00,730091),('1','206','257686','473',600.00,600.00,0.00,0.00,0.00,0.00,0.00,730092),('1','206','257686','472',165.00,165.00,6081.46,0.00,0.00,0.00,0.00,730093),('1','206','257687','473',650.00,650.00,0.00,0.00,0.00,0.00,0.00,730094),('1','206','257687','472',165.00,165.00,1953.14,0.00,0.00,0.00,0.00,730095),('1','206','257688','473',650.00,650.00,0.00,0.00,0.00,0.00,0.00,730096),('1','206','257688','472',165.00,165.00,4460.36,0.00,0.00,0.00,0.00,730097),('1','206','257689','473',650.00,650.00,0.00,0.00,0.00,0.00,0.00,730098),('1','206','257689','472',165.00,165.00,7671.55,0.00,0.00,0.00,0.00,730099),('1','206','257690','473',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730100),('1','206','257690','472',165.00,165.00,12255.92,0.00,0.00,0.00,0.00,730101),('1','206','257691','473',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730102),('1','206','257691','472',165.00,165.00,13983.20,0.00,0.00,0.00,0.00,730103),('1','206','257692','473',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730104),('1','206','257692','472',165.00,165.00,8612.96,0.00,0.00,0.00,0.00,730105),('1','206','257693','473',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730106),('1','206','257693','472',165.00,165.00,5001.84,0.00,0.00,0.00,0.00,730107),('1','206','257694','473',680.00,680.00,0.00,0.00,0.00,0.00,0.00,730108),('1','206','257694','472',165.00,165.00,2178.84,0.00,0.00,0.00,0.00,730109),('1','206','257695','473',680.00,680.00,0.00,0.00,0.00,0.00,0.00,730110),('1','206','257695','472',165.00,165.00,3564.60,0.00,0.00,0.00,0.00,730111),('1','206','257696','473',680.00,680.00,0.00,0.00,0.00,0.00,0.00,730112),('1','206','257696','472',165.00,165.00,9473.14,0.00,0.00,0.00,0.00,730113),('1','206','257697','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730114),('1','206','257697','472',165.00,165.00,10784.30,0.00,0.00,0.00,0.00,730115),('1','206','257698','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730116),('1','206','257698','472',165.00,165.00,14711.57,0.00,0.00,0.00,0.00,730117),('1','206','257699','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730118),('1','206','257699','472',165.00,165.00,5068.71,0.00,0.00,0.00,0.00,730119),('1','206','257700','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730120),('1','206','257700','472',165.00,165.00,5165.34,0.00,0.00,0.00,0.00,730121),('1','206','257701','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730122),('1','206','257701','472',165.00,165.00,3245.69,0.00,0.00,0.00,0.00,730123),('1','206','257702','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730124),('1','206','257702','472',165.00,165.00,2305.11,0.00,0.00,0.00,0.00,730125),('1','206','257703','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730126),('1','206','257703','472',165.00,165.00,11445.34,0.00,0.00,0.00,0.00,730127),('1','206','257704','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730128),('1','206','257704','472',165.00,165.00,7624.41,0.00,0.00,0.00,0.00,730129),('1','206','257705','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730130),('1','206','257705','472',165.00,165.00,3235.44,0.00,0.00,0.00,0.00,730131),('1','206','257706','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730132),('1','206','257706','472',165.00,165.00,6132.87,0.00,0.00,0.00,0.00,730133),('1','206','257707','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730134),('1','206','257707','472',165.00,165.00,8039.79,0.00,0.00,0.00,0.00,730135),('1','206','257708','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730136),('1','206','257708','472',165.00,165.00,9232.90,0.00,0.00,0.00,0.00,730137),('1','206','257709','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730138),('1','206','257709','472',165.00,165.00,8588.02,0.00,0.00,0.00,0.00,730139),('1','206','257710','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730140),('1','206','257710','472',165.00,165.00,13149.59,0.00,0.00,0.00,0.00,730141),('1','206','257711','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730142),('1','206','257711','472',165.00,165.00,11582.18,0.00,0.00,0.00,0.00,730143),('1','206','257712','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730144),('1','206','257712','472',165.00,165.00,12505.97,0.00,0.00,0.00,0.00,730145),('1','206','257713','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730146),('1','206','257713','472',165.00,165.00,13469.35,0.00,0.00,0.00,0.00,730147),('1','206','257714','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730148),('1','206','257714','472',165.00,165.00,8693.75,0.00,0.00,0.00,0.00,730149),('1','206','257715','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730150),('1','206','257715','472',165.00,165.00,7127.16,0.00,0.00,0.00,0.00,730151),('1','206','257716','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730152),('1','206','257716','472',165.00,165.00,6078.41,0.00,0.00,0.00,0.00,730153),('1','206','257717','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730154),('1','206','257717','472',165.00,165.00,6041.55,0.00,0.00,0.00,0.00,730155),('1','206','257718','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730156),('1','206','257718','472',165.00,165.00,5987.50,0.00,0.00,0.00,0.00,730157),('1','206','257719','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730158),('1','206','257719','472',165.00,165.00,6228.75,0.00,0.00,0.00,0.00,730159),('1','206','257720','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730160),('1','206','257720','472',165.00,165.00,8718.32,0.00,0.00,0.00,0.00,730161),('1','206','257721','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730162),('1','206','257721','472',165.00,165.00,8040.14,0.00,0.00,0.00,0.00,730163),('1','206','257722','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730164),('1','206','257722','472',165.00,165.00,9715.68,0.00,0.00,0.00,0.00,730165),('1','206','257723','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730166),('1','206','257723','472',165.00,165.00,9377.23,0.00,0.00,0.00,0.00,730167),('1','206','257724','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730168),('1','206','257724','472',165.00,165.00,10225.46,0.00,0.00,0.00,0.00,730169),('1','206','257725','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730170),('1','206','257725','472',165.00,165.00,5496.44,0.00,0.00,0.00,0.00,730171),('1','206','257726','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730172),('1','206','257726','472',165.00,165.00,7011.25,0.00,0.00,0.00,0.00,730173),('1','206','257727','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730174),('1','206','257727','472',165.00,165.00,7225.95,0.00,0.00,0.00,0.00,730175),('1','206','257728','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730176),('1','206','257728','472',165.00,165.00,6416.48,0.00,0.00,0.00,0.00,730177),('1','206','257729','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730178),('1','206','257729','472',165.00,165.00,4114.05,0.00,0.00,0.00,0.00,730179),('1','206','257730','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730180),('1','206','257730','472',165.00,165.00,4575.02,0.00,0.00,0.00,0.00,730181),('1','206','257731','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730182),('1','206','257731','472',165.00,165.00,5901.79,0.00,0.00,0.00,0.00,730183),('1','206','257732','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730184),('1','206','257732','472',165.00,165.00,6509.84,0.00,0.00,0.00,0.00,730185),('1','206','257733','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730186),('1','206','257733','472',165.00,165.00,10951.94,0.00,0.00,0.00,0.00,730187),('1','206','257734','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730188),('1','206','257734','472',165.00,165.00,8270.79,0.00,0.00,0.00,0.00,730189),('1','206','257735','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730190),('1','206','257735','472',165.00,165.00,11569.70,0.00,0.00,0.00,0.00,730191),('1','206','257736','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730192),('1','206','257736','472',165.00,165.00,6873.80,0.00,0.00,0.00,0.00,730193),('1','206','257737','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730194),('1','206','257737','472',165.00,165.00,5703.35,0.00,0.00,0.00,0.00,730195),('1','206','257738','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730196),('1','206','257738','472',165.00,165.00,5465.95,0.00,0.00,0.00,0.00,730197),('1','206','257739','473',660.00,660.00,2483.16,0.00,0.00,0.00,0.00,730198),('1','206','257739','472',165.00,165.00,11496.54,0.00,0.00,0.00,0.00,730199),('1','206','257740','473',660.00,660.00,0.30,0.00,0.00,0.00,0.00,730200),('1','206','257740','472',165.00,165.00,6260.42,0.00,0.00,0.00,0.00,730201),('1','206','257741','473',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730202),('1','206','257741','472',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730203),('1','206','257742','473',660.00,660.00,133.94,0.00,0.00,0.00,0.00,730204),('1','206','257742','472',165.00,165.00,8887.14,0.00,0.00,0.00,0.00,730205),('1','206','257743','473',660.00,660.00,1912.75,0.00,0.00,0.00,0.00,730206),('1','206','257743','472',165.00,165.00,5159.02,0.00,0.00,0.00,0.00,730207),('1','206','257744','473',660.00,660.00,4795.13,0.00,0.00,0.00,0.00,730208),('1','206','257744','472',165.00,165.00,2272.92,0.00,0.00,0.00,0.00,730209),('1','206','257745','473',660.00,660.00,1264.25,0.00,0.00,0.00,0.00,730210),('1','206','257745','472',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730211),('1','206','257746','473',660.00,660.00,2199.59,0.00,0.00,0.00,0.00,730212),('1','206','257746','472',165.00,165.00,2289.11,0.00,0.00,0.00,0.00,730213),('1','206','257747','473',660.00,660.00,138.64,0.00,0.00,0.00,0.00,730214),('1','206','257747','472',165.00,165.00,7338.56,0.00,0.00,0.00,0.00,730215),('1','206','257748','473',660.00,660.00,226.55,0.00,0.00,0.00,0.00,730216),('1','206','257748','472',165.00,165.00,4205.26,0.00,0.00,0.00,0.00,730217),('1','206','257749','473',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730218),('1','206','257749','472',165.00,165.00,1665.75,0.00,0.00,0.00,0.00,730219),('1','206','257750','473',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730220),('1','206','257750','472',165.00,165.00,6723.39,0.00,0.00,0.00,0.00,730221),('1','206','257751','473',660.00,660.00,1895.98,0.00,0.00,0.00,0.00,730222),('1','206','257751','472',165.00,165.00,4725.50,0.00,0.00,0.00,0.00,730223),('1','206','257752','473',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730224),('1','206','257752','472',165.00,165.00,2967.40,0.00,0.00,0.00,0.00,730225),('1','206','257753','473',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730226),('1','206','257753','472',165.00,165.00,7774.24,0.00,0.00,0.00,0.00,730227),('1','206','257754','473',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730228),('1','206','257754','472',165.00,165.00,7132.64,0.00,0.00,0.00,0.00,730229),('1','206','257755','473',680.00,680.00,0.00,0.00,0.00,0.00,0.00,730230),('1','206','257755','472',165.00,165.00,13014.49,0.00,0.00,0.00,0.00,730231),('1','206','257756','473',680.00,680.00,0.00,0.00,0.00,0.00,0.00,730232),('1','206','257756','472',165.00,165.00,5982.85,0.00,0.00,0.00,0.00,730233),('1','206','257757','473',680.00,680.00,0.00,0.00,0.00,0.00,0.00,730234),('1','206','257757','472',165.00,165.00,5289.24,0.00,0.00,0.00,0.00,730235),('1','206','257758','473',680.00,680.00,0.00,0.00,0.00,0.00,0.00,730236),('1','206','257758','472',165.00,165.00,10595.88,0.00,0.00,0.00,0.00,730237),('1','206','257759','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730238),('1','206','257759','472',165.00,165.00,5162.81,0.00,0.00,0.00,0.00,730239),('1','206','257760','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730240),('1','206','257760','472',165.00,165.00,6250.99,0.00,0.00,0.00,0.00,730241),('1','206','257761','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730242),('1','206','257761','472',165.00,165.00,5418.73,0.00,0.00,0.00,0.00,730243),('1','206','257762','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730244),('1','206','257762','472',165.00,165.00,4310.64,0.00,0.00,0.00,0.00,730245),('1','206','257763','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730246),('1','206','257763','472',165.00,165.00,4718.84,0.00,0.00,0.00,0.00,730247),('1','206','257764','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730248),('1','206','257764','472',165.00,165.00,4567.74,0.00,0.00,0.00,0.00,730249),('1','206','257765','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730250),('1','206','257765','472',165.00,165.00,6310.87,0.00,0.00,0.00,0.00,730251),('1','206','257766','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730252),('1','206','257766','472',165.00,165.00,5522.49,0.00,0.00,0.00,0.00,730253),('1','206','257767','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730254),('1','206','257767','472',165.00,165.00,8027.33,0.00,0.00,0.00,0.00,730255),('1','206','257768','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730256),('1','206','257768','472',165.00,165.00,9062.55,0.00,0.00,0.00,0.00,730257),('1','206','257769','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730258),('1','206','257769','472',165.00,165.00,4602.16,0.00,0.00,0.00,0.00,730259),('1','206','257770','473',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730260),('1','206','257770','472',165.00,165.00,4532.45,0.00,0.00,0.00,0.00,730261),('1','206','257771','473',740.00,740.00,0.00,0.00,0.00,0.00,0.00,730262),('1','206','257771','472',165.00,165.00,4537.30,0.00,0.00,0.00,0.00,730263),('1','206','257772','473',740.00,740.00,0.00,0.00,0.00,0.00,0.00,730264),('1','206','257772','472',165.00,165.00,9089.40,0.00,0.00,0.00,0.00,730265),('1','206','257773','473',760.00,760.00,0.00,0.00,0.00,0.00,0.00,730266),('1','206','257773','472',165.00,165.00,8398.87,0.00,0.00,0.00,0.00,730267),('1','206','257774','473',760.00,760.00,0.00,0.00,0.00,0.00,0.00,730268),('1','206','257774','472',165.00,165.00,13143.30,0.00,0.00,0.00,0.00,730269),('1','206','257775','473',760.00,760.00,0.00,0.00,0.00,0.00,0.00,730270),('1','206','257775','472',165.00,165.00,13936.79,0.00,0.00,0.00,0.00,730271),('1','206','257776','473',760.00,760.00,0.00,0.00,0.00,0.00,0.00,730272),('1','206','257776','472',165.00,165.00,7846.72,0.00,0.00,0.00,0.00,730273),('1','206','257777','473',760.00,760.00,0.00,0.00,0.00,0.00,0.00,730274),('1','206','257777','472',165.00,165.00,8249.53,0.00,0.00,0.00,0.00,730275),('1','206','257778','473',760.00,760.00,0.00,0.00,0.00,0.00,0.00,730276),('1','206','257778','472',165.00,165.00,5941.91,0.00,0.00,0.00,0.00,730277),('1','206','257779','473',760.00,760.00,0.00,0.00,0.00,0.00,0.00,730278),('1','206','257779','472',165.00,165.00,2616.15,0.00,0.00,0.00,0.00,730279),('1','206','257780','473',760.00,760.00,0.00,0.00,0.00,0.00,0.00,730280),('1','206','257780','472',165.00,165.00,5324.10,0.00,0.00,0.00,0.00,730281),('1','206','257781','473',770.00,770.00,0.00,0.00,0.00,0.00,0.00,730282),('1','206','257781','472',165.00,165.00,7658.27,0.00,0.00,0.00,0.00,730283),('1','206','257782','473',770.00,770.00,0.00,0.00,0.00,0.00,0.00,730284),('1','206','257782','472',165.00,165.00,5571.66,0.00,0.00,0.00,0.00,730285),('1','206','257783','473',770.00,770.00,1251.80,0.00,0.00,0.00,0.00,730286),('1','206','257783','472',165.00,165.00,9780.67,0.00,0.00,0.00,0.00,730287),('1','206','257784','473',800.00,800.00,17.76,0.00,0.00,0.00,0.00,730288),('1','206','257784','472',165.00,165.00,7327.96,0.00,0.00,0.00,0.00,730289),('1','206','257785','473',800.00,800.00,118.89,0.00,0.00,0.00,0.00,730290),('1','206','257785','472',165.00,165.00,7968.57,0.00,0.00,0.00,0.00,730291),('1','206','257786','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730292),('1','206','257786','472',165.00,165.00,3935.97,0.00,0.00,0.00,0.00,730293),('1','206','257787','473',800.00,800.00,821.77,0.00,0.00,0.00,0.00,730294),('1','206','257787','472',165.00,165.00,4456.03,0.00,0.00,0.00,0.00,730295),('1','206','257788','473',800.00,800.00,214.13,0.00,0.00,0.00,0.00,730296),('1','206','257788','472',165.00,165.00,9857.43,0.00,0.00,0.00,0.00,730297),('1','206','257789','473',800.00,800.00,73.13,0.00,0.00,0.00,0.00,730298),('1','206','257789','472',165.00,165.00,2674.77,0.00,0.00,0.00,0.00,730299),('1','206','257790','473',800.00,800.00,373.75,0.00,0.00,0.00,0.00,730300),('1','206','257790','472',165.00,165.00,1044.58,0.00,0.00,0.00,0.00,730301),('1','206','257791','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730302),('1','206','257791','472',165.00,165.00,4321.61,0.00,0.00,0.00,0.00,730303),('1','206','257792','473',820.00,820.00,1103.66,0.00,0.00,0.00,0.00,730304),('1','206','257792','472',165.00,165.00,9986.25,0.00,0.00,0.00,0.00,730305),('1','206','257793','473',820.00,820.00,7.81,0.00,0.00,0.00,0.00,730306),('1','206','257793','472',165.00,165.00,4856.41,0.00,0.00,0.00,0.00,730307),('1','206','257794','473',820.00,820.00,28.68,0.00,0.00,0.00,0.00,730308),('1','206','257794','472',165.00,165.00,4190.32,0.00,0.00,0.00,0.00,730309),('1','206','257795','473',820.00,820.00,3.29,0.00,0.00,0.00,0.00,730310),('1','206','257795','472',165.00,165.00,6031.36,0.00,0.00,0.00,0.00,730311),('1','206','257796','473',830.00,830.00,796.02,0.00,0.00,0.00,0.00,730312),('1','206','257796','472',165.00,165.00,5545.63,0.00,0.00,0.00,0.00,730313),('1','206','257797','473',830.00,830.00,6.02,0.00,0.00,0.00,0.00,730314),('1','206','257797','472',165.00,165.00,4352.57,0.00,0.00,0.00,0.00,730315),('1','206','257798','473',830.00,830.00,407.85,0.00,0.00,0.00,0.00,730316),('1','206','257798','472',165.00,165.00,7173.02,0.00,0.00,0.00,0.00,730317),('1','206','257799','473',830.00,830.00,5.42,0.00,0.00,0.00,0.00,730318),('1','206','257799','472',165.00,165.00,3747.66,0.00,0.00,0.00,0.00,730319),('1','206','257800','473',830.00,830.00,229.03,0.00,0.00,0.00,0.00,730320),('1','206','257800','472',165.00,165.00,2161.85,0.00,0.00,0.00,0.00,730321),('1','206','257801','473',830.00,830.00,2197.47,0.00,0.00,0.00,0.00,730322),('1','206','257801','472',165.00,165.00,13982.35,0.00,0.00,0.00,0.00,730323),('1','206','257802','473',830.00,830.00,2.41,0.00,0.00,0.00,0.00,730324),('1','206','257802','472',165.00,165.00,857.27,0.00,0.00,0.00,0.00,730325),('1','206','257803','473',830.00,830.00,10.96,0.00,0.00,0.00,0.00,730326),('1','206','257803','472',165.00,165.00,4245.65,0.00,0.00,0.00,0.00,730327),('1','206','257804','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730328),('1','206','257804','472',165.00,165.00,1909.26,0.00,0.00,0.00,0.00,730329),('1','206','257805','473',830.00,830.00,1702.73,0.00,0.00,0.00,0.00,730330),('1','206','257805','472',165.00,165.00,3809.12,0.00,0.00,0.00,0.00,730331),('1','206','257806','473',830.00,830.00,1.20,0.00,0.00,0.00,0.00,730332),('1','206','257806','472',165.00,165.00,10569.28,0.00,0.00,0.00,0.00,730333),('1','206','257807','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730334),('1','206','257807','472',165.00,165.00,3191.19,0.00,0.00,0.00,0.00,730335),('1','206','257808','473',830.00,830.00,1015.90,0.00,0.00,0.00,0.00,730336),('1','206','257808','472',165.00,165.00,705.74,0.00,0.00,0.00,0.00,730337),('1','206','257809','473',830.00,830.00,970.00,0.00,0.00,0.00,0.00,730338),('1','206','257809','472',165.00,165.00,10572.14,0.00,0.00,0.00,0.00,730339),('1','206','257810','473',830.00,830.00,573.75,0.00,0.00,0.00,0.00,730340),('1','206','257810','472',165.00,165.00,4794.99,0.00,0.00,0.00,0.00,730341),('1','206','257811','473',830.00,830.00,96.17,0.00,0.00,0.00,0.00,730342),('1','206','257811','472',165.00,165.00,4698.19,0.00,0.00,0.00,0.00,730343),('1','206','257812','473',830.00,830.00,175.70,0.00,0.00,0.00,0.00,730344),('1','206','257812','472',165.00,165.00,2967.51,0.00,0.00,0.00,0.00,730345),('1','206','257813','473',830.00,830.00,271.05,0.00,0.00,0.00,0.00,730346),('1','206','257813','472',165.00,165.00,3975.85,0.00,0.00,0.00,0.00,730347),('1','206','257814','473',830.00,830.00,1328.25,0.00,0.00,0.00,0.00,730348),('1','206','257814','472',185.00,185.00,2934.28,0.00,0.00,0.00,0.00,730349),('1','206','257815','473',810.00,810.00,1004.21,0.00,0.00,0.00,0.00,730350),('1','206','257815','472',185.00,185.00,3463.80,0.00,0.00,0.00,0.00,730351),('1','206','257816','473',810.00,810.00,2.23,0.00,0.00,0.00,0.00,730352),('1','206','257816','472',185.00,185.00,4465.00,0.00,0.00,0.00,0.00,730353),('1','206','257817','473',810.00,810.00,601.23,0.00,0.00,0.00,0.00,730354),('1','206','257817','472',185.00,185.00,5794.82,0.00,0.00,0.00,0.00,730355),('1','206','257818','473',810.00,810.00,700.00,0.00,0.00,0.00,0.00,730356),('1','206','257818','472',185.00,185.00,3220.92,0.00,0.00,0.00,0.00,730357),('1','206','257819','473',810.00,810.00,54.94,0.00,0.00,0.00,0.00,730358),('1','206','257819','472',185.00,185.00,3464.89,0.00,0.00,0.00,0.00,730359),('1','206','257820','473',810.00,810.00,124.00,0.00,0.00,0.00,0.00,730360),('1','206','257820','472',185.00,185.00,4184.49,0.00,0.00,0.00,0.00,730361),('1','206','257821','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730362),('1','206','257821','472',185.00,185.00,5916.99,0.00,0.00,0.00,0.00,730363),('1','206','257822','473',810.00,810.00,35.69,0.00,0.00,0.00,0.00,730364),('1','206','257822','472',185.00,185.00,4084.38,0.00,0.00,0.00,0.00,730365),('1','206','257823','473',810.00,810.00,79.31,0.00,0.00,0.00,0.00,730366),('1','206','257823','472',185.00,185.00,10520.24,0.00,0.00,0.00,0.00,730367),('1','206','257824','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730368),('1','206','257824','472',185.00,185.00,6636.53,0.00,0.00,0.00,0.00,730369),('1','206','257825','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730370),('1','206','257825','472',185.00,185.00,6591.39,0.00,0.00,0.00,0.00,730371),('1','206','257826','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730372),('1','206','257826','472',185.00,185.00,4179.57,0.00,0.00,0.00,0.00,730373),('1','206','257827','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730374),('1','206','257827','472',185.00,185.00,1890.96,0.00,0.00,0.00,0.00,730375),('1','206','257828','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730376),('1','206','257828','472',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730377),('1','206','257829','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730378),('1','206','257829','472',185.00,185.00,7108.51,0.00,0.00,0.00,0.00,730379),('1','206','257830','473',810.00,810.00,1165.73,0.00,0.00,0.00,0.00,730380),('1','206','257830','472',185.00,185.00,9108.57,0.00,0.00,0.00,0.00,730381),('1','206','257831','473',810.00,810.00,12.10,0.00,0.00,0.00,0.00,730382),('1','206','257831','472',185.00,185.00,3156.56,0.00,0.00,0.00,0.00,730383),('1','206','257832','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730384),('1','206','257832','472',185.00,185.00,4828.81,0.00,0.00,0.00,0.00,730385),('1','206','257833','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730386),('1','206','257833','472',185.00,185.00,4567.20,0.00,0.00,0.00,0.00,730387),('1','206','257834','473',810.00,810.00,917.28,0.00,0.00,0.00,0.00,730388),('1','206','257834','472',185.00,185.00,6992.49,0.00,0.00,0.00,0.00,730389),('1','206','257835','473',810.00,810.00,1.23,0.00,0.00,0.00,0.00,730390),('1','206','257835','472',185.00,185.00,6634.29,0.00,0.00,0.00,0.00,730391),('1','206','257836','473',810.00,810.00,5.43,0.00,0.00,0.00,0.00,730392),('1','206','257836','472',185.00,185.00,5952.35,0.00,0.00,0.00,0.00,730393),('1','206','257837','473',810.00,810.00,34.56,0.00,0.00,0.00,0.00,730394),('1','206','257837','472',185.00,185.00,8316.11,0.00,0.00,0.00,0.00,730395),('1','206','257838','473',810.00,810.00,124.69,0.00,0.00,0.00,0.00,730396),('1','206','257838','472',185.00,185.00,6362.33,0.00,0.00,0.00,0.00,730397),('1','206','257839','473',810.00,810.00,0.74,0.00,0.00,0.00,0.00,730398),('1','206','257839','472',185.00,185.00,3160.10,0.00,0.00,0.00,0.00,730399),('1','206','257840','473',810.00,810.00,1301.48,0.00,0.00,0.00,0.00,730400),('1','206','257840','472',185.00,185.00,6819.91,0.00,0.00,0.00,0.00,730401),('1','206','257841','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730402),('1','206','257841','472',185.00,185.00,5532.12,0.00,0.00,0.00,0.00,730403),('1','206','257842','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730404),('1','206','257842','472',185.00,185.00,7581.67,0.00,0.00,0.00,0.00,730405),('1','206','257843','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730406),('1','206','257843','472',185.00,185.00,8505.12,0.00,0.00,0.00,0.00,730407),('1','206','257844','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730408),('1','206','257844','472',185.00,185.00,9824.19,0.00,0.00,0.00,0.00,730409),('1','206','257845','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730410),('1','206','257845','472',185.00,185.00,7611.72,0.00,0.00,0.00,0.00,730411),('1','206','257846','473',810.00,810.00,134.49,0.00,0.00,0.00,0.00,730412),('1','206','257846','472',185.00,185.00,8412.99,0.00,0.00,0.00,0.00,730413),('1','206','257847','473',810.00,810.00,33.79,0.00,0.00,0.00,0.00,730414),('1','206','257847','472',185.00,185.00,8683.04,0.00,0.00,0.00,0.00,730415),('1','206','257848','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730416),('1','206','257848','472',185.00,185.00,3733.58,0.00,0.00,0.00,0.00,730417),('1','206','257849','473',810.00,810.00,192.16,0.00,0.00,0.00,0.00,730418),('1','206','257849','472',185.00,185.00,2906.57,0.00,0.00,0.00,0.00,730419),('1','206','257850','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730420),('1','206','257850','472',185.00,185.00,9642.06,0.00,0.00,0.00,0.00,730421),('1','206','257851','473',810.00,810.00,361.73,0.00,0.00,0.00,0.00,730422),('1','206','257851','472',185.00,185.00,8635.88,0.00,0.00,0.00,0.00,730423),('1','206','257852','473',810.00,810.00,52.23,0.00,0.00,0.00,0.00,730424),('1','206','257852','472',185.00,185.00,5660.02,0.00,0.00,0.00,0.00,730425),('1','206','257853','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730426),('1','206','257853','472',185.00,185.00,4522.66,0.00,0.00,0.00,0.00,730427),('1','206','257854','473',810.00,810.00,0.00,0.00,0.00,0.00,0.00,730428),('1','206','257854','472',185.00,185.00,5037.25,0.00,0.00,0.00,0.00,730429),('1','206','257855','473',810.00,810.00,889.13,0.00,0.00,0.00,0.00,730430),('1','206','257855','472',185.00,185.00,2619.83,0.00,0.00,0.00,0.00,730431),('1','206','257856','473',810.00,810.00,623.28,0.00,0.00,0.00,0.00,730432),('1','206','257856','472',185.00,185.00,2291.75,0.00,0.00,0.00,0.00,730433),('1','206','257857','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730434),('1','206','257857','472',185.00,185.00,3728.57,0.00,0.00,0.00,0.00,730435),('1','206','257858','473',800.00,800.00,240.38,0.00,0.00,0.00,0.00,730436),('1','206','257858','472',185.00,185.00,5181.21,0.00,0.00,0.00,0.00,730437),('1','206','257859','473',800.00,800.00,15.13,0.00,0.00,0.00,0.00,730438),('1','206','257859','472',185.00,185.00,4055.67,0.00,0.00,0.00,0.00,730439),('1','206','257860','473',800.00,800.00,11.26,0.00,0.00,0.00,0.00,730440),('1','206','257860','472',185.00,185.00,5326.63,0.00,0.00,0.00,0.00,730441),('1','206','257861','473',800.00,800.00,151.75,0.00,0.00,0.00,0.00,730442),('1','206','257861','472',185.00,185.00,2942.58,0.00,0.00,0.00,0.00,730443),('1','206','257862','473',800.00,800.00,1075.00,0.00,0.00,0.00,0.00,730444),('1','206','257862','472',185.00,185.00,4266.06,0.00,0.00,0.00,0.00,730445),('1','206','257863','473',800.00,800.00,3.50,0.00,0.00,0.00,0.00,730446),('1','206','257863','472',185.00,185.00,3618.69,0.00,0.00,0.00,0.00,730447),('1','206','257864','473',800.00,800.00,67.52,0.00,0.00,0.00,0.00,730448),('1','206','257864','472',185.00,185.00,6836.95,0.00,0.00,0.00,0.00,730449),('1','206','257865','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730450),('1','206','257865','472',185.00,185.00,3308.98,0.00,0.00,0.00,0.00,730451),('1','206','257866','473',800.00,800.00,312.01,0.00,0.00,0.00,0.00,730452),('1','206','257866','472',185.00,185.00,2911.67,0.00,0.00,0.00,0.00,730453),('1','206','257867','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730454),('1','206','257867','472',185.00,185.00,3487.87,0.00,0.00,0.00,0.00,730455),('1','206','257868','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730456),('1','206','257868','472',185.00,185.00,4163.80,0.00,0.00,0.00,0.00,730457),('1','206','257869','473',800.00,800.00,850.25,0.00,0.00,0.00,0.00,730458),('1','206','257869','472',185.00,185.00,3591.60,0.00,0.00,0.00,0.00,730459),('1','206','257870','473',800.00,800.00,358.13,0.00,0.00,0.00,0.00,730460),('1','206','257870','472',185.00,185.00,2599.44,0.00,0.00,0.00,0.00,730461),('1','206','257871','473',800.00,800.00,47.75,0.00,0.00,0.00,0.00,730462),('1','206','257871','472',185.00,185.00,3459.48,0.00,0.00,0.00,0.00,730463),('1','206','257872','473',800.00,800.00,124.38,0.00,0.00,0.00,0.00,730464),('1','206','257872','472',185.00,185.00,3473.54,0.00,0.00,0.00,0.00,730465),('1','206','257873','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730466),('1','206','257873','472',185.00,185.00,3634.13,0.00,0.00,0.00,0.00,730467),('1','206','257874','473',800.00,800.00,25.00,0.00,0.00,0.00,0.00,730468),('1','206','257874','472',185.00,185.00,5472.63,0.00,0.00,0.00,0.00,730469),('1','206','257875','473',800.00,800.00,18.13,0.00,0.00,0.00,0.00,730470),('1','206','257875','472',185.00,185.00,5208.58,0.00,0.00,0.00,0.00,730471),('1','206','257876','473',800.00,800.00,16.25,0.00,0.00,0.00,0.00,730472),('1','206','257876','472',185.00,185.00,4537.48,0.00,0.00,0.00,0.00,730473),('1','206','257877','473',800.00,800.00,95.75,0.00,0.00,0.00,0.00,730474),('1','206','257877','472',185.00,185.00,6924.86,0.00,0.00,0.00,0.00,730475),('1','206','257878','473',800.00,800.00,347.50,0.00,0.00,0.00,0.00,730476),('1','206','257878','472',185.00,185.00,5588.16,0.00,0.00,0.00,0.00,730477),('1','206','257879','473',800.00,800.00,18.38,0.00,0.00,0.00,0.00,730478),('1','206','257879','472',185.00,185.00,8075.82,0.00,0.00,0.00,0.00,730479),('1','206','257880','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730480),('1','206','257880','472',185.00,185.00,1178.37,0.00,0.00,0.00,0.00,730481),('1','206','257881','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730482),('1','206','257881','472',185.00,185.00,3224.09,0.00,0.00,0.00,0.00,730483),('1','206','257882','473',800.00,800.00,1868.81,0.00,0.00,0.00,0.00,730484),('1','206','257882','472',185.00,185.00,3397.48,0.00,0.00,0.00,0.00,730485),('1','206','257883','473',800.00,800.00,280.00,0.00,0.00,0.00,0.00,730486),('1','206','257883','472',185.00,185.00,3239.19,0.00,0.00,0.00,0.00,730487),('1','206','257884','473',800.00,800.00,51.88,0.00,0.00,0.00,0.00,730488),('1','206','257884','472',185.00,185.00,2257.46,0.00,0.00,0.00,0.00,730489),('1','206','257885','473',800.00,800.00,2.50,0.00,0.00,0.00,0.00,730490),('1','206','257885','472',185.00,185.00,4534.72,0.00,0.00,0.00,0.00,730491),('1','206','257886','473',800.00,800.00,104.25,0.00,0.00,0.00,0.00,730492),('1','206','257886','472',185.00,185.00,8479.39,0.00,0.00,0.00,0.00,730493),('1','206','257887','473',800.00,800.00,125.00,0.00,0.00,0.00,0.00,730494),('1','206','257887','472',185.00,185.00,2748.31,0.00,0.00,0.00,0.00,730495),('1','206','257888','473',800.00,800.00,148.25,0.00,0.00,0.00,0.00,730496),('1','206','257888','472',185.00,185.00,3437.47,0.00,0.00,0.00,0.00,730497),('1','206','257889','473',800.00,800.00,1.25,0.00,0.00,0.00,0.00,730498),('1','206','257889','472',185.00,185.00,2956.06,0.00,0.00,0.00,0.00,730499),('1','206','257890','473',800.00,800.00,1.25,0.00,0.00,0.00,0.00,730500),('1','206','257890','472',185.00,185.00,6337.71,0.00,0.00,0.00,0.00,730501),('1','206','257891','473',800.00,800.00,1.25,0.00,0.00,0.00,0.00,730502),('1','206','257891','472',185.00,185.00,3097.70,0.00,0.00,0.00,0.00,730503),('1','206','257892','473',800.00,800.00,162.50,0.00,0.00,0.00,0.00,730504),('1','206','257892','472',185.00,185.00,4509.13,0.00,0.00,0.00,0.00,730505),('1','206','257893','473',800.00,800.00,1520.00,0.00,0.00,0.00,0.00,730506),('1','206','257893','472',185.00,185.00,3149.14,0.00,0.00,0.00,0.00,730507),('1','206','257894','473',800.00,800.00,0.50,0.00,0.00,0.00,0.00,730508),('1','206','257894','472',185.00,185.00,3621.88,0.00,0.00,0.00,0.00,730509),('1','206','257895','473',800.00,800.00,301.30,0.00,0.00,0.00,0.00,730510),('1','206','257895','472',185.00,185.00,3255.01,0.00,0.00,0.00,0.00,730511),('1','206','257896','473',800.00,800.00,156.44,0.00,0.00,0.00,0.00,730512),('1','206','257896','472',185.00,185.00,3929.36,0.00,0.00,0.00,0.00,730513),('1','206','257897','473',800.00,800.00,375.00,0.00,0.00,0.00,0.00,730514),('1','206','257897','472',185.00,185.00,3119.68,0.00,0.00,0.00,0.00,730515),('1','206','257898','473',800.00,800.00,196.64,0.00,0.00,0.00,0.00,730516),('1','206','257898','472',185.00,185.00,3407.89,0.00,0.00,0.00,0.00,730517),('1','206','257899','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730518),('1','206','257899','472',185.00,185.00,2736.06,0.00,0.00,0.00,0.00,730519),('1','206','257900','473',800.00,800.00,21.75,0.00,0.00,0.00,0.00,730520),('1','206','257900','472',185.00,185.00,3635.34,0.00,0.00,0.00,0.00,730521),('1','206','257901','473',800.00,800.00,78.50,0.00,0.00,0.00,0.00,730522),('1','206','257901','472',185.00,185.00,3201.51,0.00,0.00,0.00,0.00,730523),('1','206','257902','473',800.00,800.00,324.01,0.00,0.00,0.00,0.00,730524),('1','206','257902','472',185.00,185.00,3671.51,0.00,0.00,0.00,0.00,730525),('1','206','257903','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730526),('1','206','257903','472',185.00,185.00,2380.23,0.00,0.00,0.00,0.00,730527),('1','206','257904','473',800.00,800.00,1140.08,0.00,0.00,0.00,0.00,730528),('1','206','257904','472',185.00,185.00,2818.46,0.00,0.00,0.00,0.00,730529),('1','206','257905','473',800.00,800.00,140.00,0.00,0.00,0.00,0.00,730530),('1','206','257905','472',185.00,185.00,3977.92,0.00,0.00,0.00,0.00,730531),('1','206','257906','473',800.00,800.00,1035.38,0.00,0.00,0.00,0.00,730532),('1','206','257906','472',185.00,185.00,3936.74,0.00,0.00,0.00,0.00,730533),('1','206','257907','473',800.00,800.00,117.25,0.00,0.00,0.00,0.00,730534),('1','206','257907','472',185.00,185.00,3348.96,0.00,0.00,0.00,0.00,730535),('1','206','257908','473',800.00,800.00,659.76,0.00,0.00,0.00,0.00,730536),('1','206','257908','472',185.00,185.00,3397.53,0.00,0.00,0.00,0.00,730537),('1','206','257909','473',800.00,800.00,39.13,0.00,0.00,0.00,0.00,730538),('1','206','257909','472',185.00,185.00,3384.41,0.00,0.00,0.00,0.00,730539),('1','206','257910','473',800.00,800.00,11.88,0.00,0.00,0.00,0.00,730540),('1','206','257910','472',185.00,185.00,4756.52,0.00,0.00,0.00,0.00,730541),('1','206','257911','473',800.00,800.00,50.00,0.00,0.00,0.00,0.00,730542),('1','206','257911','472',185.00,185.00,5416.58,0.00,0.00,0.00,0.00,730543),('1','206','257912','473',800.00,800.00,6.01,0.00,0.00,0.00,0.00,730544),('1','206','257912','472',185.00,185.00,5954.32,0.00,0.00,0.00,0.00,730545),('1','206','257913','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730546),('1','206','257913','472',185.00,185.00,3774.84,0.00,0.00,0.00,0.00,730547),('1','206','257914','473',800.00,800.00,350.00,0.00,0.00,0.00,0.00,730548),('1','206','257914','472',185.00,185.00,3309.51,0.00,0.00,0.00,0.00,730549),('1','206','257915','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730550),('1','206','257915','472',185.00,185.00,3507.68,0.00,0.00,0.00,0.00,730551),('1','206','257916','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730552),('1','206','257916','472',185.00,185.00,4637.69,0.00,0.00,0.00,0.00,730553),('1','206','257917','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730554),('1','206','257917','472',185.00,185.00,4492.85,0.00,0.00,0.00,0.00,730555),('1','206','257918','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730556),('1','206','257918','472',185.00,185.00,6187.43,0.00,0.00,0.00,0.00,730557),('1','206','257919','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730558),('1','206','257919','472',185.00,185.00,4071.46,0.00,0.00,0.00,0.00,730559),('1','206','257920','473',800.00,800.00,288.68,0.00,0.00,0.00,0.00,730560),('1','206','257920','472',185.00,185.00,4198.02,0.00,0.00,0.00,0.00,730561),('1','206','257921','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730562),('1','206','257921','472',185.00,185.00,3054.88,0.00,0.00,0.00,0.00,730563),('1','206','257922','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730564),('1','206','257922','472',185.00,185.00,3369.12,0.00,0.00,0.00,0.00,730565),('1','206','257923','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730566),('1','206','257923','472',185.00,185.00,3071.39,0.00,0.00,0.00,0.00,730567),('1','206','257924','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730568),('1','206','257924','472',185.00,185.00,3416.87,0.00,0.00,0.00,0.00,730569),('1','206','257925','473',800.00,800.00,25.00,0.00,0.00,0.00,0.00,730570),('1','206','257925','472',185.00,185.00,3500.54,0.00,0.00,0.00,0.00,730571),('1','206','257926','473',800.00,800.00,83.85,0.00,0.00,0.00,0.00,730572),('1','206','257926','472',185.00,185.00,5185.63,0.00,0.00,0.00,0.00,730573),('1','206','257927','473',800.00,800.00,34.38,0.00,0.00,0.00,0.00,730574),('1','206','257927','472',185.00,185.00,6828.48,0.00,0.00,0.00,0.00,730575),('1','206','257928','473',800.00,800.00,799.97,0.00,0.00,0.00,0.00,730576),('1','206','257928','472',185.00,185.00,4624.65,0.00,0.00,0.00,0.00,730577),('1','206','257929','473',800.00,800.00,20.63,0.00,0.00,0.00,0.00,730578),('1','206','257929','472',185.00,185.00,3031.89,0.00,0.00,0.00,0.00,730579),('1','206','257930','473',800.00,800.00,130.75,0.00,0.00,0.00,0.00,730580),('1','206','257930','472',185.00,185.00,4252.64,0.00,0.00,0.00,0.00,730581),('1','206','257931','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730582),('1','206','257931','472',185.00,185.00,4741.73,0.00,0.00,0.00,0.00,730583),('1','206','257932','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730584),('1','206','257932','472',185.00,185.00,9464.00,0.00,0.00,0.00,0.00,730585),('1','206','257933','473',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730586),('1','206','257933','472',185.00,185.00,4121.79,0.00,0.00,0.00,0.00,730587),('1','206','257934','473',810.00,810.00,2950.74,0.00,0.00,0.00,0.00,730588),('1','206','257934','472',185.00,185.00,1098.32,0.00,0.00,0.00,0.00,730589),('1','206','257935','473',810.00,810.00,1471.26,0.00,0.00,0.00,0.00,730590),('1','206','257935','472',185.00,185.00,971.65,0.00,0.00,0.00,0.00,730591),('1','206','257936','473',810.00,810.00,30.99,0.00,0.00,0.00,0.00,730592),('1','206','257936','472',185.00,185.00,850.23,0.00,0.00,0.00,0.00,730593),('1','206','257937','473',810.00,810.00,1101.79,0.00,0.00,0.00,0.00,730594),('1','206','257937','472',185.00,185.00,1012.70,0.00,0.00,0.00,0.00,730595),('1','206','257938','473',810.00,810.00,553.54,0.00,0.00,0.00,0.00,730596),('1','206','257938','472',185.00,185.00,322.58,0.00,0.00,0.00,0.00,730597),('1','206','257939','473',810.00,810.00,580.39,0.00,0.00,0.00,0.00,730598),('1','206','257939','472',185.00,185.00,175.20,0.00,0.00,0.00,0.00,730599),('1','206','257940','473',820.00,820.00,1766.66,0.00,0.00,0.00,0.00,730600),('1','206','257940','472',185.00,185.00,390.18,0.00,0.00,0.00,0.00,730601),('1','206','257941','473',820.00,820.00,154.54,0.00,0.00,0.00,0.00,730602),('1','206','257941','472',185.00,185.00,278.29,0.00,0.00,0.00,0.00,730603),('1','206','257942','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730604),('1','206','257942','472',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730605),('1','206','257943','473',830.00,830.00,730.60,0.00,0.00,0.00,0.00,730606),('1','206','257943','472',185.00,185.00,6537.86,0.00,0.00,0.00,0.00,730607),('1','206','257944','473',830.00,830.00,370.60,0.00,0.00,0.00,0.00,730608),('1','206','257944','472',185.00,185.00,6811.79,0.00,0.00,0.00,0.00,730609),('1','206','257945','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730610),('1','206','257945','472',185.00,185.00,5024.14,0.00,0.00,0.00,0.00,730611),('1','206','257946','473',830.00,830.00,587.41,0.00,0.00,0.00,0.00,730612),('1','206','257946','472',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730613),('1','206','257947','473',830.00,830.00,1189.34,0.00,0.00,0.00,0.00,730614),('1','206','257947','472',185.00,185.00,15046.06,0.00,0.00,0.00,0.00,730615),('1','206','257948','473',830.00,830.00,48.19,0.00,0.00,0.00,0.00,730616),('1','206','257948','472',185.00,185.00,5782.77,0.00,0.00,0.00,0.00,730617),('1','206','257949','473',830.00,830.00,435.00,0.00,0.00,0.00,0.00,730618),('1','206','257949','472',185.00,185.00,1308.16,0.00,0.00,0.00,0.00,730619),('1','206','257950','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730620),('1','206','257950','472',185.00,185.00,2226.57,0.00,0.00,0.00,0.00,730621),('1','206','257951','473',830.00,830.00,412.00,0.00,0.00,0.00,0.00,730622),('1','206','257951','472',185.00,185.00,3699.82,0.00,0.00,0.00,0.00,730623),('1','206','257952','473',830.00,830.00,300.00,0.00,0.00,0.00,0.00,730624),('1','206','257952','472',185.00,185.00,3205.22,0.00,0.00,0.00,0.00,730625),('1','206','257953','473',830.00,830.00,97.86,0.00,0.00,0.00,0.00,730626),('1','206','257953','472',185.00,185.00,8691.85,0.00,0.00,0.00,0.00,730627),('1','206','257954','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730628),('1','206','257954','472',185.00,185.00,3642.00,0.00,0.00,0.00,0.00,730629),('1','206','257955','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730630),('1','206','257955','472',185.00,185.00,4520.62,0.00,0.00,0.00,0.00,730631),('1','206','257956','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730632),('1','206','257956','472',185.00,185.00,1972.87,0.00,0.00,0.00,0.00,730633),('1','206','257957','473',830.00,830.00,275.35,0.00,0.00,0.00,0.00,730634),('1','206','257957','472',185.00,185.00,12654.71,0.00,0.00,0.00,0.00,730635),('1','206','257958','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730636),('1','206','257958','472',185.00,185.00,4544.40,0.00,0.00,0.00,0.00,730637),('1','206','257959','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730638),('1','206','257959','472',195.00,195.00,16326.81,0.00,0.00,0.00,0.00,730639),('1','206','257960','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730640),('1','206','257960','472',195.00,195.00,3289.87,0.00,0.00,0.00,0.00,730641),('1','206','257961','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730642),('1','206','257961','472',195.00,195.00,11642.44,0.00,0.00,0.00,0.00,730643),('1','206','257962','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730644),('1','206','257962','472',195.00,195.00,2049.09,0.00,0.00,0.00,0.00,730645),('1','206','257963','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730646),('1','206','257963','472',195.00,195.00,2720.84,0.00,0.00,0.00,0.00,730647),('1','206','257964','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730648),('1','206','257964','472',195.00,195.00,6994.48,0.00,0.00,0.00,0.00,730649),('1','206','257965','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730650),('1','206','257965','472',195.00,195.00,10550.05,0.00,0.00,0.00,0.00,730651),('1','206','257966','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730652),('1','206','257966','472',195.00,195.00,4833.03,0.00,0.00,0.00,0.00,730653),('1','206','257967','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730654),('1','206','257967','472',195.00,195.00,5378.72,0.00,0.00,0.00,0.00,730655),('1','206','257968','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730656),('1','206','257968','472',195.00,195.00,11158.35,0.00,0.00,0.00,0.00,730657),('1','206','257969','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730658),('1','206','257969','472',195.00,195.00,11475.88,0.00,0.00,0.00,0.00,730659),('1','206','257970','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730660),('1','206','257970','472',195.00,195.00,12208.98,0.00,0.00,0.00,0.00,730661),('1','206','257971','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730662),('1','206','257971','472',195.00,195.00,8109.79,0.00,0.00,0.00,0.00,730663),('1','206','257972','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730664),('1','206','257972','472',195.00,195.00,2496.60,0.00,0.00,0.00,0.00,730665),('1','206','257973','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730666),('1','206','257973','472',195.00,195.00,2938.77,0.00,0.00,0.00,0.00,730667),('1','206','257974','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730668),('1','206','257974','472',195.00,195.00,10451.29,0.00,0.00,0.00,0.00,730669),('1','206','257975','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730670),('1','206','257975','472',195.00,195.00,9701.66,0.00,0.00,0.00,0.00,730671),('1','206','257976','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730672),('1','206','257976','472',195.00,195.00,13204.62,0.00,0.00,0.00,0.00,730673),('1','206','257977','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730674),('1','206','257977','472',195.00,195.00,14364.86,0.00,0.00,0.00,0.00,730675),('1','206','257978','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730676),('1','206','257978','472',195.00,195.00,11992.77,0.00,0.00,0.00,0.00,730677),('1','206','257979','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730678),('1','206','257979','472',195.00,195.00,8697.60,0.00,0.00,0.00,0.00,730679),('1','206','257980','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730680),('1','206','257980','472',195.00,195.00,7805.23,0.00,0.00,0.00,0.00,730681),('1','206','257981','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730682),('1','206','257981','472',195.00,195.00,7888.52,0.00,0.00,0.00,0.00,730683),('1','206','257982','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730684),('1','206','257982','472',195.00,195.00,10198.35,0.00,0.00,0.00,0.00,730685),('1','206','257983','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730686),('1','206','257983','472',195.00,195.00,6306.49,0.00,0.00,0.00,0.00,730687),('1','206','257984','473',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730688),('1','206','257984','472',195.00,195.00,2676.92,0.00,0.00,0.00,0.00,730689),('1','206','257985','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730690),('1','206','257985','472',195.00,195.00,13546.08,0.00,0.00,0.00,0.00,730691),('1','206','257986','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730692),('1','206','257986','472',195.00,195.00,10162.79,0.00,0.00,0.00,0.00,730693),('1','206','257987','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730694),('1','206','257987','472',195.00,195.00,13470.27,0.00,0.00,0.00,0.00,730695),('1','206','257988','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730696),('1','206','257988','472',195.00,195.00,8705.73,0.00,0.00,0.00,0.00,730697),('1','206','257989','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730698),('1','206','257989','472',195.00,195.00,6287.97,0.00,0.00,0.00,0.00,730699),('1','206','257990','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730700),('1','206','257990','472',195.00,195.00,5058.16,0.00,0.00,0.00,0.00,730701),('1','206','257991','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730702),('1','206','257991','472',195.00,195.00,11040.66,0.00,0.00,0.00,0.00,730703),('1','206','257992','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730704),('1','206','257992','472',195.00,195.00,10500.14,0.00,0.00,0.00,0.00,730705),('1','206','257993','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730706),('1','206','257993','472',195.00,195.00,7205.36,0.00,0.00,0.00,0.00,730707),('1','206','257994','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730708),('1','206','257994','472',195.00,195.00,4796.39,0.00,0.00,0.00,0.00,730709),('1','206','257995','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730710),('1','206','257995','472',195.00,195.00,1599.61,0.00,0.00,0.00,0.00,730711),('1','206','257996','473',890.00,890.00,0.00,0.00,0.00,0.00,0.00,730712),('1','206','257996','472',195.00,195.00,1590.41,0.00,0.00,0.00,0.00,730713),('1','206','257997','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730714),('1','206','257997','472',210.00,210.00,18249.85,0.00,0.00,0.00,0.00,730715),('1','206','257998','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730716),('1','206','257998','472',210.00,210.00,13463.27,0.00,0.00,0.00,0.00,730717),('1','206','257999','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730718),('1','206','257999','472',210.00,210.00,14691.17,0.00,0.00,0.00,0.00,730719),('1','206','258000','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730720),('1','206','258000','472',210.00,210.00,3765.95,0.00,0.00,0.00,0.00,730721),('1','206','258001','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730722),('1','206','258001','472',210.00,210.00,8662.08,0.00,0.00,0.00,0.00,730723),('1','206','258002','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730724),('1','206','258002','472',210.00,210.00,6148.21,0.00,0.00,0.00,0.00,730725),('1','206','258003','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730726),('1','206','258003','472',210.00,210.00,9375.57,0.00,0.00,0.00,0.00,730727),('1','206','258004','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730728),('1','206','258004','472',210.00,210.00,3710.31,0.00,0.00,0.00,0.00,730729),('1','206','258005','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730730),('1','206','258005','472',210.00,210.00,17554.96,0.00,0.00,0.00,0.00,730731),('1','206','258006','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730732),('1','206','258006','472',210.00,210.00,9207.33,0.00,0.00,0.00,0.00,730733),('1','206','258007','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730734),('1','206','258007','472',210.00,210.00,10463.58,0.00,0.00,0.00,0.00,730735),('1','206','258008','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730736),('1','206','258008','472',210.00,210.00,19878.20,0.00,0.00,0.00,0.00,730737),('1','206','258009','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730738),('1','206','258009','472',210.00,210.00,9317.79,0.00,0.00,0.00,0.00,730739),('1','206','258010','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730740),('1','206','258010','472',210.00,210.00,14962.97,0.00,0.00,0.00,0.00,730741),('1','206','258011','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730742),('1','206','258011','472',210.00,210.00,14074.75,0.00,0.00,0.00,0.00,730743),('1','206','258012','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730744),('1','206','258012','472',210.00,210.00,9002.65,0.00,0.00,0.00,0.00,730745),('1','206','258013','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730746),('1','206','258013','472',210.00,210.00,12997.25,0.00,0.00,0.00,0.00,730747),('1','206','258014','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730748),('1','206','258014','472',220.00,220.00,12285.61,0.00,0.00,0.00,0.00,730749),('1','206','258015','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730750),('1','206','258015','472',220.00,220.00,5508.05,0.00,0.00,0.00,0.00,730751),('1','206','258016','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730752),('1','206','258016','472',220.00,220.00,6096.57,0.00,0.00,0.00,0.00,730753),('1','206','258017','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730754),('1','206','258017','472',220.00,220.00,7111.70,0.00,0.00,0.00,0.00,730755),('1','206','258018','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730756),('1','206','258018','472',220.00,220.00,10001.49,0.00,0.00,0.00,0.00,730757),('1','206','258019','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730758),('1','206','258019','472',220.00,220.00,9189.21,0.00,0.00,0.00,0.00,730759),('1','206','258020','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730760),('1','206','258020','472',220.00,220.00,15315.03,0.00,0.00,0.00,0.00,730761),('1','206','258021','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730762),('1','206','258021','472',220.00,220.00,8346.60,0.00,0.00,0.00,0.00,730763),('1','206','258022','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730764),('1','206','258022','472',220.00,220.00,13327.66,0.00,0.00,0.00,0.00,730765),('1','206','258023','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730766),('1','206','258023','472',220.00,220.00,7575.62,0.00,0.00,0.00,0.00,730767),('1','206','258024','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730768),('1','206','258024','472',220.00,220.00,16365.82,0.00,0.00,0.00,0.00,730769),('1','206','258025','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730770),('1','206','258025','472',220.00,220.00,12019.12,0.00,0.00,0.00,0.00,730771),('1','206','258026','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730772),('1','206','258026','472',220.00,220.00,9589.44,0.00,0.00,0.00,0.00,730773),('1','206','258027','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730774),('1','206','258027','472',220.00,220.00,12533.64,0.00,0.00,0.00,0.00,730775),('1','206','258028','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730776),('1','206','258028','472',220.00,220.00,9864.95,0.00,0.00,0.00,0.00,730777),('1','206','258029','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730778),('1','206','258029','472',220.00,220.00,8812.24,0.00,0.00,0.00,0.00,730779),('1','206','258030','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730780),('1','206','258030','472',220.00,220.00,13330.15,0.00,0.00,0.00,0.00,730781),('1','206','258031','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730782),('1','206','258031','472',220.00,220.00,9072.47,0.00,0.00,0.00,0.00,730783),('1','206','258032','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730784),('1','206','258032','472',220.00,220.00,10885.77,0.00,0.00,0.00,0.00,730785),('1','206','258033','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730786),('1','206','258033','472',220.00,220.00,11280.92,0.00,0.00,0.00,0.00,730787),('1','206','258034','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730788),('1','206','258034','472',220.00,220.00,10769.92,0.00,0.00,0.00,0.00,730789),('1','206','258035','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730790),('1','206','258035','472',220.00,220.00,10972.81,0.00,0.00,0.00,0.00,730791),('1','206','258036','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730792),('1','206','258036','472',220.00,220.00,14029.82,0.00,0.00,0.00,0.00,730793),('1','206','258037','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730794),('1','206','258037','472',220.00,220.00,11761.33,0.00,0.00,0.00,0.00,730795),('1','206','258038','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730796),('1','206','258038','472',220.00,220.00,11559.96,0.00,0.00,0.00,0.00,730797),('1','206','258039','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730798),('1','206','258039','472',220.00,220.00,16753.25,0.00,0.00,0.00,0.00,730799),('1','206','258040','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730800),('1','206','258040','472',220.00,220.00,13403.59,0.00,0.00,0.00,0.00,730801),('1','206','258041','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730802),('1','206','258041','472',220.00,220.00,14547.06,0.00,0.00,0.00,0.00,730803),('1','206','258042','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730804),('1','206','258042','472',220.00,220.00,14437.17,0.00,0.00,0.00,0.00,730805),('1','206','258043','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730806),('1','206','258043','472',220.00,220.00,12286.63,0.00,0.00,0.00,0.00,730807),('1','206','258044','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730808),('1','206','258044','472',220.00,220.00,12838.02,0.00,0.00,0.00,0.00,730809),('1','206','258045','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730810),('1','206','258045','472',220.00,220.00,10849.93,0.00,0.00,0.00,0.00,730811),('1','206','258046','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730812),('1','206','258046','472',220.00,220.00,7071.22,0.00,0.00,0.00,0.00,730813),('1','206','258047','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730814),('1','206','258047','472',220.00,220.00,8886.56,0.00,0.00,0.00,0.00,730815),('1','206','258048','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730816),('1','206','258048','472',220.00,220.00,19211.34,0.00,0.00,0.00,0.00,730817),('1','206','258049','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730818),('1','206','258049','472',220.00,220.00,10370.19,0.00,0.00,0.00,0.00,730819),('1','206','258050','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730820),('1','206','258050','472',220.00,220.00,17280.54,0.00,0.00,0.00,0.00,730821),('1','206','258051','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730822),('1','206','258051','472',220.00,220.00,12870.10,0.00,0.00,0.00,0.00,730823),('1','206','258052','473',880.00,880.00,0.00,0.00,0.00,0.00,0.00,730824),('1','206','258052','472',220.00,220.00,10094.48,0.00,0.00,0.00,0.00,730825),('1','206','258053','473',870.00,870.00,1088.98,0.00,0.00,0.00,0.00,730826),('1','206','258053','472',220.00,220.00,1977.01,0.00,0.00,0.00,0.00,730827),('1','206','258054','473',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730828),('1','206','258054','472',220.00,220.00,5711.92,0.00,0.00,0.00,0.00,730829),('1','206','258055','473',870.00,870.00,1359.17,0.00,0.00,0.00,0.00,730830),('1','206','258055','472',220.00,220.00,5092.51,0.00,0.00,0.00,0.00,730831),('1','206','258056','473',870.00,870.00,109.20,0.00,0.00,0.00,0.00,730832),('1','206','258056','472',220.00,220.00,20009.10,0.00,0.00,0.00,0.00,730833),('1','206','258057','473',870.00,870.00,914.95,0.00,0.00,0.00,0.00,730834),('1','206','258057','472',220.00,220.00,16055.11,0.00,0.00,0.00,0.00,730835),('1','206','258058','473',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730836),('1','206','258058','472',220.00,220.00,18068.68,0.00,0.00,0.00,0.00,730837),('1','206','258059','473',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730838),('1','206','258059','472',220.00,220.00,20296.77,0.00,0.00,0.00,0.00,730839),('1','206','258060','473',870.00,870.00,1431.33,0.00,0.00,0.00,0.00,730840),('1','206','258060','472',220.00,220.00,14573.97,0.00,0.00,0.00,0.00,730841),('1','206','258061','473',870.00,870.00,58.93,0.00,0.00,0.00,0.00,730842),('1','206','258061','472',220.00,220.00,2656.28,0.00,0.00,0.00,0.00,730843),('1','206','258062','473',870.00,870.00,966.94,0.00,0.00,0.00,0.00,730844),('1','206','258062','472',220.00,220.00,11682.49,0.00,0.00,0.00,0.00,730845),('1','206','258063','473',850.00,850.00,630.30,0.00,0.00,0.00,0.00,730846),('1','206','258063','472',220.00,220.00,10863.47,0.00,0.00,0.00,0.00,730847),('1','206','258064','473',850.00,850.00,1000.00,0.00,0.00,0.00,0.00,730848),('1','206','258064','472',220.00,220.00,11926.35,0.00,0.00,0.00,0.00,730849),('1','206','258065','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730850),('1','206','258065','472',220.00,220.00,12185.24,0.00,0.00,0.00,0.00,730851),('1','206','258066','473',850.00,850.00,1860.83,0.00,0.00,0.00,0.00,730852),('1','206','258066','472',220.00,220.00,19202.71,0.00,0.00,0.00,0.00,730853),('1','206','258067','473',850.00,850.00,516.07,0.00,0.00,0.00,0.00,730854),('1','206','258067','472',220.00,220.00,7944.06,0.00,0.00,0.00,0.00,730855),('1','206','258068','473',850.00,850.00,1013.53,0.00,0.00,0.00,0.00,730856),('1','206','258068','472',220.00,220.00,9096.79,0.00,0.00,0.00,0.00,730857),('1','206','258069','473',850.00,850.00,2331.07,0.00,0.00,0.00,0.00,730858),('1','206','258069','472',220.00,220.00,8281.82,0.00,0.00,0.00,0.00,730859),('1','206','258070','473',850.00,850.00,1176.55,0.00,0.00,0.00,0.00,730860),('1','206','258070','472',220.00,220.00,11394.49,0.00,0.00,0.00,0.00,730861),('1','206','258071','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730862),('1','206','258071','472',220.00,220.00,11377.89,0.00,0.00,0.00,0.00,730863),('1','206','258072','473',850.00,850.00,430.30,0.00,0.00,0.00,0.00,730864),('1','206','258072','472',200.00,200.00,8598.07,0.00,0.00,0.00,0.00,730865),('1','206','258073','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730866),('1','206','258073','472',200.00,200.00,10234.62,0.00,0.00,0.00,0.00,730867),('1','206','258074','473',850.00,850.00,25.42,0.00,0.00,0.00,0.00,730868),('1','206','258074','472',200.00,200.00,8688.32,0.00,0.00,0.00,0.00,730869),('1','206','258075','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730870),('1','206','258075','472',200.00,200.00,10931.25,0.00,0.00,0.00,0.00,730871),('1','206','258076','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730872),('1','206','258076','472',200.00,200.00,17062.43,0.00,0.00,0.00,0.00,730873),('1','206','258077','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730874),('1','206','258077','472',200.00,200.00,8071.23,0.00,0.00,0.00,0.00,730875),('1','206','258078','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730876),('1','206','258078','472',200.00,200.00,11545.12,0.00,0.00,0.00,0.00,730877),('1','206','258079','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730878),('1','206','258079','472',200.00,200.00,11404.09,0.00,0.00,0.00,0.00,730879),('1','206','258080','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730880),('1','206','258080','472',200.00,200.00,11601.51,0.00,0.00,0.00,0.00,730881),('1','206','258081','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730882),('1','206','258081','472',200.00,200.00,13059.49,0.00,0.00,0.00,0.00,730883),('1','206','258082','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730884),('1','206','258082','472',200.00,200.00,11461.78,0.00,0.00,0.00,0.00,730885),('1','206','258083','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730886),('1','206','258083','472',200.00,200.00,8777.84,0.00,0.00,0.00,0.00,730887),('1','206','258084','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730888),('1','206','258084','472',200.00,200.00,15917.99,0.00,0.00,0.00,0.00,730889),('1','206','258085','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730890),('1','206','258085','472',200.00,200.00,8965.00,0.00,0.00,0.00,0.00,730891),('1','206','258086','472',210.00,210.00,10176.76,0.00,0.00,0.00,0.00,730892),('1','206','258086','473',850.00,850.00,169.20,0.00,0.00,0.00,0.00,730893),('1','206','258087','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730894),('1','206','258087','472',210.00,210.00,8368.29,0.00,0.00,0.00,0.00,730895),('1','206','258088','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730896),('1','206','258088','472',210.00,210.00,8802.23,0.00,0.00,0.00,0.00,730897),('1','206','258089','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730898),('1','206','258089','472',210.00,210.00,8871.32,0.00,0.00,0.00,0.00,730899),('1','206','258090','473',850.00,850.00,850.07,0.00,0.00,0.00,0.00,730900),('1','206','258090','472',210.00,210.00,9416.19,0.00,0.00,0.00,0.00,730901),('1','206','258091','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730902),('1','206','258091','472',210.00,210.00,9670.61,0.00,0.00,0.00,0.00,730903),('1','206','258092','473',850.00,850.00,1523.35,0.00,0.00,0.00,0.00,730904),('1','206','258092','472',210.00,210.00,9160.75,0.00,0.00,0.00,0.00,730905),('1','206','258093','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730906),('1','206','258093','472',210.00,210.00,7943.98,0.00,0.00,0.00,0.00,730907),('1','206','258094','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730908),('1','206','258094','472',210.00,210.00,11306.39,0.00,0.00,0.00,0.00,730909),('1','206','258095','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730910),('1','206','258095','472',210.00,210.00,9281.54,0.00,0.00,0.00,0.00,730911),('1','206','258096','473',850.00,850.00,533.19,0.00,0.00,0.00,0.00,730912),('1','206','258096','472',210.00,210.00,7828.26,0.00,0.00,0.00,0.00,730913),('1','206','258097','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730914),('1','206','258097','472',210.00,210.00,10596.27,0.00,0.00,0.00,0.00,730915),('1','206','258098','473',850.00,850.00,25.71,0.00,0.00,0.00,0.00,730916),('1','206','258098','472',210.00,210.00,8597.47,0.00,0.00,0.00,0.00,730917),('1','206','258099','473',850.00,850.00,4.12,0.00,0.00,0.00,0.00,730918),('1','206','258099','472',210.00,210.00,8314.30,0.00,0.00,0.00,0.00,730919),('1','206','258100','473',850.00,850.00,1171.16,0.00,0.00,0.00,0.00,730920),('1','206','258100','472',210.00,210.00,8273.90,0.00,0.00,0.00,0.00,730921),('1','206','258101','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730922),('1','206','258101','472',210.00,210.00,8973.49,0.00,0.00,0.00,0.00,730923),('1','206','258102','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730924),('1','206','258102','472',210.00,210.00,7592.72,0.00,0.00,0.00,0.00,730925),('1','206','258103','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730926),('1','206','258103','472',210.00,210.00,10100.86,0.00,0.00,0.00,0.00,730927),('1','206','258104','473',850.00,850.00,1034.64,0.00,0.00,0.00,0.00,730928),('1','206','258104','472',210.00,210.00,9302.12,0.00,0.00,0.00,0.00,730929),('1','206','258105','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730930),('1','206','258105','472',210.00,210.00,8476.68,0.00,0.00,0.00,0.00,730931),('1','206','258106','473',850.00,850.00,13.54,0.00,0.00,0.00,0.00,730932),('1','206','258106','472',210.00,210.00,8164.41,0.00,0.00,0.00,0.00,730933),('1','206','258107','473',850.00,850.00,41.20,0.00,0.00,0.00,0.00,730934),('1','206','258107','472',210.00,210.00,9178.51,0.00,0.00,0.00,0.00,730935),('1','206','258108','473',850.00,850.00,900.01,0.00,0.00,0.00,0.00,730936),('1','206','258108','472',210.00,210.00,8062.45,0.00,0.00,0.00,0.00,730937),('1','206','258109','473',850.00,850.00,0.00,0.00,0.00,0.00,0.00,730938),('1','206','258109','472',210.00,210.00,5657.32,0.00,0.00,0.00,0.00,730939),('1','206','258110','473',850.00,850.00,1280.53,0.00,0.00,0.00,0.00,730940),('1','206','258110','472',210.00,210.00,8147.00,0.00,0.00,0.00,0.00,730941),('1','206','258111','473',850.00,850.00,833.53,0.00,0.00,0.00,0.00,730942),('1','206','258111','472',210.00,210.00,8776.02,0.00,0.00,0.00,0.00,730943),('1','206','258112','473',850.00,850.00,1.47,0.00,0.00,0.00,0.00,730944),('1','206','258112','472',210.00,210.00,10622.93,0.00,0.00,0.00,0.00,730945),('1','206','258113','473',830.00,830.00,230.00,0.00,0.00,0.00,0.00,730946),('1','206','258113','472',210.00,210.00,10951.70,0.00,0.00,0.00,0.00,730947),('1','206','258114','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730948),('1','206','258114','472',210.00,210.00,9180.19,0.00,0.00,0.00,0.00,730949),('1','206','258115','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730950),('1','206','258115','472',210.00,210.00,9823.83,0.00,0.00,0.00,0.00,730951),('1','206','258116','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730952),('1','206','258116','472',210.00,210.00,7270.41,0.00,0.00,0.00,0.00,730953),('1','206','258117','473',830.00,830.00,1.81,0.00,0.00,0.00,0.00,730954),('1','206','258117','472',210.00,210.00,8203.01,0.00,0.00,0.00,0.00,730955),('1','206','258118','473',830.00,830.00,30.01,0.00,0.00,0.00,0.00,730956),('1','206','258118','472',210.00,210.00,9654.43,0.00,0.00,0.00,0.00,730957),('1','206','258119','473',830.00,830.00,6.02,0.00,0.00,0.00,0.00,730958),('1','206','258119','472',210.00,210.00,9456.31,0.00,0.00,0.00,0.00,730959),('1','206','258120','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730960),('1','206','258120','472',210.00,210.00,7813.69,0.00,0.00,0.00,0.00,730961),('1','206','258121','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730962),('1','206','258121','472',210.00,210.00,9561.14,0.00,0.00,0.00,0.00,730963),('1','206','258122','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730964),('1','206','258122','472',210.00,210.00,5638.50,0.00,0.00,0.00,0.00,730965),('1','206','258123','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730966),('1','206','258123','472',210.00,210.00,8621.51,0.00,0.00,0.00,0.00,730967),('1','206','258124','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730968),('1','206','258124','472',210.00,210.00,2745.35,0.00,0.00,0.00,0.00,730969),('1','206','258125','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730970),('1','206','258125','472',210.00,210.00,5283.27,0.00,0.00,0.00,0.00,730971),('1','206','258126','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730972),('1','206','258126','472',210.00,210.00,7615.52,0.00,0.00,0.00,0.00,730973),('1','206','258127','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730974),('1','206','258127','472',210.00,210.00,3314.11,0.00,0.00,0.00,0.00,730975),('1','206','258128','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730976),('1','206','258128','472',210.00,210.00,10140.34,0.00,0.00,0.00,0.00,730977),('1','206','258129','473',830.00,830.00,484.86,0.00,0.00,0.00,0.00,730978),('1','206','258129','472',210.00,210.00,8173.28,0.00,0.00,0.00,0.00,730979),('1','206','258130','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730980),('1','206','258130','472',210.00,210.00,3118.48,0.00,0.00,0.00,0.00,730981),('1','206','258131','473',830.00,830.00,1250.00,0.00,0.00,0.00,0.00,730982),('1','206','258131','472',210.00,210.00,7449.34,0.00,0.00,0.00,0.00,730983),('1','206','258132','473',830.00,830.00,1270.31,0.00,0.00,0.00,0.00,730984),('1','206','258132','472',210.00,210.00,10194.18,0.00,0.00,0.00,0.00,730985),('1','206','258133','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730986),('1','206','258133','472',210.00,210.00,13206.27,0.00,0.00,0.00,0.00,730987),('1','206','258134','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730988),('1','206','258134','472',210.00,210.00,8614.43,0.00,0.00,0.00,0.00,730989),('1','206','258135','473',830.00,830.00,858.20,0.00,0.00,0.00,0.00,730990),('1','206','258135','472',210.00,210.00,12125.50,0.00,0.00,0.00,0.00,730991),('1','206','258136','473',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730992),('1','206','258136','472',210.00,210.00,8184.29,0.00,0.00,0.00,0.00,730993),('1','206','258137','473',830.00,830.00,200.00,0.00,0.00,0.00,0.00,730994),('1','206','258137','472',210.00,210.00,9993.99,0.00,0.00,0.00,0.00,730995),('1','206','258138','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730996),('1','206','258138','472',210.00,210.00,7097.06,0.00,0.00,0.00,0.00,730997),('1','206','258139','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730998),('1','206','258139','472',210.00,210.00,14061.77,0.00,0.00,0.00,0.00,730999),('1','206','258140','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,731000),('1','206','258140','472',210.00,210.00,6723.11,0.00,0.00,0.00,0.00,731001),('1','206','258141','473',820.00,820.00,105.00,0.00,0.00,0.00,0.00,731002),('1','206','258141','472',210.00,210.00,10947.95,0.00,0.00,0.00,0.00,731003),('1','206','258142','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,731004),('1','206','258142','472',210.00,210.00,7272.07,0.00,0.00,0.00,0.00,731005),('1','206','258143','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,731006),('1','206','258143','472',210.00,210.00,9611.66,0.00,0.00,0.00,0.00,731007),('1','206','258144','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,731008),('1','206','258144','472',210.00,210.00,10067.86,0.00,0.00,0.00,0.00,731009),('1','206','258145','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,731010),('1','206','258145','472',210.00,210.00,12380.90,0.00,0.00,0.00,0.00,731011),('1','206','258146','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,731012),('1','206','258146','472',210.00,210.00,9484.35,0.00,0.00,0.00,0.00,731013),('1','206','258147','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,731014),('1','206','258147','472',210.00,210.00,8218.42,0.00,0.00,0.00,0.00,731015),('1','206','258148','473',820.00,820.00,0.00,0.00,0.00,0.00,0.00,731016),('1','206','258148','472',210.00,210.00,11173.05,0.00,0.00,0.00,0.00,731017);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=40836 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
INSERT INTO `depots_shifts_stocklevels` VALUES (33506,'1','206','245375','2021-12-11 17:51:03','728','473',345.00,29200.00,10074000.00),(33507,'1','206','245375','2021-12-11 17:51:48','728','473',345.00,29200.00,10074000.00),(33508,'1','206','245375','2021-12-11 17:52:40','728','472',165.00,91300.00,15064500.00),(33565,'1','206','245500','2021-12-12 08:49:14','728','473',345.00,29000.00,10005000.00),(33570,'1','206','245500','2021-12-12 08:50:58','728','472',165.00,85550.00,14115750.00),(33655,'1','206','245604','2021-12-12 19:42:05','728','473',345.00,28600.00,9867000.00),(33656,'1','206','245604','2021-12-12 19:42:33','728','472',165.00,80500.00,13282500.00),(35073,'1','206','248093','2021-12-22 21:02:31','728','473',345.00,28600.00,9867000.00),(35074,'1','206','248093','2021-12-22 21:02:54','728','472',165.00,77500.00,12787500.00),(35211,'1','206','248360','2021-12-23 21:01:40','728','473',345.00,28500.00,9832500.00),(35212,'1','206','248360','2021-12-23 21:05:41','728','472',165.00,66850.00,11030250.00),(35362,'1','206','248599','2021-12-24 21:02:34','728','472',165.00,51950.00,8571750.00),(35363,'1','206','248599','2021-12-24 21:03:27','728','473',345.00,28450.00,9815250.00),(35593,'1','206','248993','2021-12-26 13:27:25','728','472',165.00,37550.00,6195750.00),(35594,'1','206','248993','2021-12-26 13:27:57','728','473',345.00,28250.00,9746250.00),(35625,'1','206','249064','2021-12-26 20:06:55','728','472',165.00,21300.00,3514500.00),(35626,'1','206','249064','2021-12-26 20:07:20','728','473',345.00,28100.00,9694500.00),(35851,'1','206','249436','2021-12-28 10:25:32','728','472',165.00,10850.00,1790250.00),(35852,'1','206','249436','2021-12-28 10:26:07','728','473',345.00,27950.00,9642750.00),(35919,'1','206','249522','2021-12-28 20:20:39','728','473',345.00,27950.00,9642750.00),(35920,'1','206','249522','2021-12-28 20:21:00','728','472',165.00,23150.00,3819750.00),(36194,'1','206','249955','2021-12-30 11:24:30','728','473',345.00,27800.00,9591000.00),(36195,'1','206','249955','2021-12-30 11:24:53','728','472',165.00,14500.00,2392500.00),(36309,'1','206','250186','2021-12-31 10:20:05','728','472',165.00,31650.00,5222250.00),(36310,'1','206','250186','2021-12-31 10:20:39','728','473',345.00,27400.00,9453000.00),(36411,'1','206','250409','2022-01-01 09:56:46','728','472',165.00,41850.00,6905250.00),(36412,'1','206','250409','2022-01-01 09:57:54','728','473',345.00,27250.00,9401250.00),(36540,'1','206','250646','2022-01-02 10:21:45','728','473',345.00,27250.00,9401250.00),(36541,'1','206','250646','2022-01-02 10:22:08','728','472',165.00,36900.00,6088500.00),(36679,'1','206','250876','2022-01-03 10:22:57','728','472',165.00,31150.00,5139750.00),(36680,'1','206','250876','2022-01-03 10:23:24','728','473',345.00,27200.00,9384000.00),(36834,'1','206','251106','2022-01-04 10:27:49','728','472',165.00,20100.00,3316500.00),(36835,'1','206','251106','2022-01-04 10:28:13','728','473',345.00,27000.00,9315000.00),(36875,'1','206','251229','2022-01-04 20:31:33','728','472',165.00,11450.00,1889250.00),(36876,'1','206','251229','2022-01-04 20:31:58','728','473',345.00,26800.00,9246000.00),(37032,'1','206','251461','2022-01-05 22:01:20','728','472',165.00,24000.00,3960000.00),(37033,'1','206','251461','2022-01-05 22:02:18','728','473',345.00,26750.00,9228750.00),(37170,'1','206','251679','2022-01-06 22:44:58','728','472',165.00,12150.00,2004750.00),(37171,'1','206','251679','2022-01-06 22:45:16','728','473',345.00,26100.00,9004500.00),(37331,'1','206','251958','2022-01-07 22:01:19','728','472',165.00,24550.00,4050750.00),(37332,'1','206','251958','2022-01-07 22:01:35','728','473',345.00,25950.00,8952750.00),(37556,'1','206','252309','2022-01-09 11:23:39','728','472',165.00,16750.00,2763750.00),(37557,'1','206','252309','2022-01-09 11:24:23','728','473',345.00,25900.00,8935500.00),(37638,'1','206','252432','2022-01-09 21:19:38','728','472',165.00,10300.00,1699500.00),(37793,'1','206','252601','2022-01-10 13:32:11','728','473',345.00,25750.00,8883750.00),(37811,'1','206','252666','2022-01-10 20:30:51','728','472',165.00,4550.00,750750.00),(37812,'1','206','252666','2022-01-10 20:31:12','728','473',345.00,25650.00,8849250.00),(38037,'1','206','252917','2022-01-12 08:54:11','728','473',345.00,25550.00,8814750.00),(38040,'1','206','252917','2022-01-12 08:54:36','728','472',165.00,19700.00,3250500.00),(38260,'1','206','253331','2022-01-13 12:11:54','728','472',165.00,12400.00,2046000.00),(38261,'1','206','253331','2022-01-13 12:12:17','728','473',345.00,25450.00,8780250.00),(38299,'1','206','253397','2022-01-13 23:15:40','728','473',345.00,25050.00,8642250.00),(38300,'1','206','253397','2022-01-13 23:15:55','728','472',165.00,3700.00,610500.00),(38452,'1','206','253662','2022-01-14 22:16:51','728','472',165.00,15550.00,2565750.00),(38453,'1','206','253662','2022-01-14 22:17:07','728','473',345.00,25000.00,8625000.00),(38646,'1','206','253908','2022-01-16 09:12:04','728','473',345.00,24450.00,8435250.00),(38647,'1','206','253908','2022-01-16 09:12:36','728','472',165.00,5100.00,841500.00),(38730,'1','206','254063','2022-01-16 18:43:36','728','472',165.00,1700.00,280500.00),(38731,'1','206','254063','2022-01-16 18:44:13','728','473',345.00,24450.00,8435250.00),(38877,'1','206','254386','2022-01-17 18:24:39','728','472',165.00,1650.00,272250.00),(38878,'1','206','254386','2022-01-17 18:25:00','728','473',345.00,24300.00,8383500.00),(39332,'1','206','255121','2022-01-20 17:10:38','728','473',350.00,324300.00,113505000.00),(39333,'1','206','255121','2022-01-20 17:10:57','728','472',165.00,1650.00,272250.00),(39334,'1','206','255121','2022-01-20 17:11:14','728','473',350.00,24300.00,8505000.00),(39335,'1','206','255121','2022-01-20 17:11:33','728','472',165.00,1650.00,272250.00),(39540,'1','206','255528','2022-01-22 10:18:26','728','473',355.00,23150.00,8218250.00),(39541,'1','206','255528','2022-01-22 10:19:20','728','472',165.00,1650.00,272250.00),(39542,'1','206','255528','2022-01-22 10:19:51','728','473',355.00,23150.00,8218250.00),(39543,'1','206','255528','2022-01-22 10:20:33','728','472',165.00,31500.00,5197500.00),(39712,'1','206','255829','2022-01-23 14:18:45','728','473',355.00,22300.00,7916500.00),(39713,'1','206','255829','2022-01-23 14:19:08','728','472',165.00,27100.00,4471500.00),(39824,'1','206','256026','2022-01-24 09:59:24','728','472',165.00,23250.00,3836250.00),(39825,'1','206','256026','2022-01-24 10:00:01','728','473',355.00,22150.00,7863250.00),(39912,'1','206','256146','2022-01-24 21:57:09','728','472',165.00,18250.00,3011250.00),(39913,'1','206','256146','2022-01-24 21:57:25','728','473',355.00,21750.00,7721250.00),(40112,'1','206','256527','2022-01-26 08:41:55','728','473',355.00,21550.00,7650250.00),(40113,'1','206','256527','2022-01-26 08:42:30','728','472',165.00,10850.00,1790250.00),(40218,'1','206','256670','2022-01-26 21:44:38','728','472',165.00,4900.00,808500.00),(40219,'1','206','256670','2022-01-26 21:45:54','728','473',355.00,21350.00,7579250.00),(40409,'1','206','257017','2022-01-28 09:14:09','728','473',355.00,21250.00,7543750.00),(40410,'1','206','257017','2022-01-28 09:14:41','728','472',165.00,11750.00,1938750.00),(40604,'1','206','257403','2022-01-29 20:36:18','728','472',165.00,4250.00,701250.00),(40605,'1','206','257403','2022-01-29 20:36:37','728','473',360.00,21200.00,7632000.00),(40607,'1','206','257403','2022-01-29 20:40:51','728','472',165.00,16700.00,2755500.00),(40608,'1','206','257403','2022-01-29 20:41:20','728','473',360.00,21050.00,7578000.00),(40609,'1','206','257625','2022-01-31 14:07:05','728','472',165.00,5650.00,932250.00),(40610,'1','206','257625','2022-01-31 14:07:32','728','473',360.00,20450.00,7362000.00),(40611,'1','206','257627','2022-02-01 09:51:19','728','472',165.00,1650.00,272250.00),(40612,'1','206','257627','2022-02-01 09:51:46','728','473',360.00,19950.00,7182000.00),(40613,'1','206','257629','2022-02-02 09:45:38','728','473',360.00,17800.00,6408000.00),(40614,'1','206','257629','2022-02-02 09:48:08','728','472',165.00,18850.00,3110250.00),(40615,'1','206','257633','2022-02-04 19:01:08','728','472',165.00,5000.00,825000.00),(40616,'1','206','257633','2022-02-04 19:01:35','728','473',360.00,17050.00,6138000.00),(40617,'1','206','257634','2022-02-04 20:25:18','728','472',165.00,1950.00,321750.00),(40618,'1','206','257634','2022-02-04 20:25:34','728','473',360.00,14100.00,5076000.00),(40619,'1','206','257635','2022-02-05 21:46:03','728','473',380.00,12450.00,4731000.00),(40620,'1','206','257635','2022-02-05 21:46:23','728','472',165.00,27050.00,4463250.00),(40621,'1','206','257637','2022-02-06 21:23:03','728','473',380.00,12050.00,4579000.00),(40622,'1','206','257637','2022-02-06 21:27:36','728','472',165.00,21450.00,3539250.00),(40623,'1','206','257639','2022-02-08 11:11:22','728','473',380.00,12000.00,4560000.00),(40624,'1','206','257639','2022-02-08 11:12:11','728','472',165.00,7850.00,1295250.00),(40625,'1','206','257641','2022-02-08 19:39:35','728','473',380.00,11750.00,4465000.00),(40626,'1','206','257641','2022-02-08 19:39:55','728','472',165.00,1700.00,280500.00),(40627,'1','206','257642','2022-02-09 18:52:07','728','472',165.00,1700.00,280500.00),(40628,'1','206','257642','2022-02-09 19:19:05','728','473',390.00,9400.00,3666000.00),(40629,'1','206','257643','2022-02-10 21:20:40','728','472',165.00,1700.00,280500.00),(40630,'1','206','257643','2022-02-10 21:21:13','728','473',390.00,9400.00,3666000.00),(40631,'1','206','257644','2022-02-13 13:24:35','728','472',165.00,18700.00,3085500.00),(40632,'1','206','257644','2022-02-13 13:25:06','728','473',400.00,9150.00,3660000.00),(40633,'1','206','257645','2022-02-13 19:20:29','728','472',165.00,8050.00,1328250.00),(40634,'1','206','257645','2022-02-13 19:20:57','728','473',400.00,7800.00,3120000.00),(40635,'1','206','257645','2022-02-13 19:20:59','728','473',400.00,7800.00,3120000.00),(40636,'1','206','257647','2022-02-15 14:53:22','728','473',400.00,7450.00,2980000.00),(40637,'1','206','257647','2022-02-15 14:53:44','728','472',165.00,2550.00,420750.00),(40638,'1','206','257649','2022-02-15 22:47:11','728','473',410.00,1600.00,656000.00),(40639,'1','206','257649','2022-02-15 22:47:33','728','472',165.00,18650.00,3077250.00),(40640,'1','206','257651','2022-02-16 20:30:34','728','473',410.00,250.00,102500.00),(40641,'1','206','257651','2022-02-16 20:30:59','728','472',165.00,6450.00,1064250.00),(40642,'1','206','257652','2022-02-17 20:41:55','728','472',165.00,4800.00,792000.00),(40643,'1','206','257652','2022-02-17 20:42:15','728','473',410.00,250.00,102500.00),(40644,'1','206','257655','2022-02-19 20:28:42','728','472',165.00,31600.00,5214000.00),(40645,'1','206','257655','2022-02-19 20:29:56','728','473',410.00,250.00,102500.00),(40646,'1','206','257655','2022-02-19 20:47:48','728','472',165.00,13650.00,2252250.00),(40647,'1','206','257655','2022-02-19 20:48:06','728','473',410.00,150.00,61500.00),(40648,'1','206','257655','2022-02-20 20:06:30','728','472',165.00,3100.00,511500.00),(40649,'1','206','257655','2022-02-20 20:06:44','728','473',410.00,150.00,61500.00),(40650,'1','206','257659','2022-02-21 18:52:36','728','472',165.00,2200.00,363000.00),(40651,'1','206','257659','2022-02-21 18:52:54','728','473',410.00,150.00,61500.00),(40652,'1','206','257661','2022-03-02 09:06:10','728','472',165.00,20800.00,3432000.00),(40653,'1','206','257661','2022-03-02 09:06:27','728','473',420.00,150.00,63000.00),(40654,'1','206','257664','2022-03-02 20:19:22','728','472',165.00,11550.00,1905750.00),(40655,'1','206','257664','2022-03-02 20:19:38','728','473',420.00,150.00,63000.00),(40656,'1','206','257668','2022-03-05 20:18:52','728','472',165.00,33450.00,5519250.00),(40657,'1','206','257668','2022-03-05 20:19:08','728','473',500.00,150.00,75000.00),(40658,'1','206','257670','2022-03-07 09:13:11','728','472',165.00,22550.00,3720750.00),(40659,'1','206','257670','2022-03-07 09:13:37','728','473',500.00,150.00,75000.00),(40660,'1','206','257671','2022-03-07 20:02:28','728','473',500.00,150.00,75000.00),(40661,'1','206','257671','2022-03-07 20:02:47','728','472',165.00,8300.00,1369500.00),(40662,'1','206','257675','2022-03-09 15:01:16','728','472',165.00,50600.00,8349000.00),(40663,'1','206','257675','2022-03-09 15:01:33','728','473',600.00,150.00,90000.00),(40664,'1','206','257676','2022-03-10 10:06:35','728','473',600.00,150.00,90000.00),(40665,'1','206','257676','2022-03-10 10:07:04','728','472',165.00,25300.00,4174500.00),(40666,'1','206','257678','2022-03-11 12:01:55','728','472',165.00,8450.00,1394250.00),(40667,'1','206','257678','2022-03-11 12:02:17','728','473',600.00,150.00,90000.00),(40668,'1','206','257680','2022-03-12 16:47:17','728','472',165.00,3600.00,594000.00),(40669,'1','206','257680','2022-03-12 16:47:35','728','473',600.00,150.00,90000.00),(40670,'1','206','257682','2022-03-13 15:13:34','728','472',165.00,33600.00,5544000.00),(40671,'1','206','257682','2022-03-13 15:13:57','728','473',600.00,150.00,90000.00),(40672,'1','206','257685','2022-03-14 15:14:34','728','472',165.00,19400.00,3201000.00),(40673,'1','206','257685','2022-03-14 15:14:53','728','473',600.00,150.00,90000.00),(40674,'1','206','257686','2022-03-14 19:00:36','728','473',650.00,150.00,97500.00),(40675,'1','206','257686','2022-03-14 19:01:08','728','472',165.00,7950.00,1311750.00),(40676,'1','206','257752','2022-05-05 12:33:20','728','473',660.00,150.00,99000.00),(40677,'1','206','257752','2022-05-05 12:34:01','728','472',165.00,21700.00,3580500.00),(40678,'1','206','257773','2022-05-29 19:42:03','728','472',165.00,28300.00,4669500.00),(40679,'1','206','257784','2022-06-07 21:07:32','728','473',800.00,18800.00,15040000.00),(40680,'1','206','257786','2022-06-08 17:57:18','728','473',800.00,18750.00,15000000.00),(40681,'1','206','257786','2022-06-08 17:57:40','728','472',165.00,6150.00,1014750.00),(40682,'1','206','257787','2022-06-09 20:57:37','728','473',800.00,17950.00,14360000.00),(40683,'1','206','257787','2022-06-09 20:57:57','728','472',165.00,18700.00,3085500.00),(40684,'1','206','257789','2022-06-10 23:26:32','728','473',800.00,17650.00,14120000.00),(40685,'1','206','257789','2022-06-10 23:27:20','728','472',165.00,6300.00,1039500.00),(40686,'1','206','257795','2022-06-14 18:57:38','728','473',820.00,17300.00,14186000.00),(40687,'1','206','257795','2022-06-14 18:58:05','728','472',165.00,2950.00,486750.00),(40688,'1','206','257795','2022-06-14 18:58:34','728','473',820.00,16300.00,13366000.00),(40689,'1','206','257795','2022-06-14 18:59:35','728','472',165.00,18850.00,3110250.00),(40690,'1','206','257795','2022-06-14 19:00:01','728','473',820.00,16250.00,13325000.00),(40691,'1','206','257795','2022-06-14 19:00:38','728','472',165.00,9850.00,1625250.00),(40692,'1','206','257795','2022-06-14 19:01:06','728','473',820.00,16250.00,13325000.00),(40693,'1','206','257795','2022-06-14 19:01:23','728','472',165.00,4000.00,660000.00),(40694,'1','206','257796','2022-06-15 20:47:27','728','473',830.00,15400.00,12782000.00),(40695,'1','206','257796','2022-06-15 20:47:46','728','472',165.00,20200.00,3333000.00),(40696,'1','206','257799','2022-06-17 18:38:39','728','472',165.00,8800.00,1452000.00),(40697,'1','206','257799','2022-06-17 18:39:05','728','473',830.00,15000.00,12450000.00),(40698,'1','206','257799','2022-06-17 18:39:24','728','473',830.00,15000.00,12450000.00),(40699,'1','206','257799','2022-06-17 18:39:40','728','472',165.00,4250.00,701250.00),(40700,'1','206','257800','2022-06-18 17:55:42','728','473',830.00,14800.00,12284000.00),(40701,'1','206','257800','2022-06-18 17:56:38','728','472',165.00,2900.00,478500.00),(40702,'1','206','257802','2022-06-22 08:04:07','728','473',830.00,12650.00,10499500.00),(40703,'1','206','257802','2022-06-22 08:04:31','728','472',165.00,8150.00,1344750.00),(40704,'1','206','257804','2022-06-25 19:14:29','728','473',830.00,14800.00,12284000.00),(40705,'1','206','257804','2022-06-25 19:15:21','728','472',165.00,2500.00,412500.00),(40706,'1','206','257804','2022-06-25 19:15:49','728','472',165.00,21700.00,3580500.00),(40707,'1','206','257804','2022-06-25 19:16:10','728','473',830.00,14800.00,12284000.00),(40708,'1','206','257804','2022-06-25 19:16:35','728','473',830.00,12650.00,10499500.00),(40709,'1','206','257804','2022-06-25 19:16:57','728','472',165.00,8450.00,1394250.00),(40710,'1','206','257804','2022-06-25 19:17:35','728','472',165.00,6450.00,1064250.00),(40711,'1','206','257804','2022-06-25 19:17:53','728','473',830.00,12650.00,10499500.00),(40712,'1','206','257804','2022-06-25 19:18:22','728','473',830.00,12650.00,10499500.00),(40713,'1','206','257804','2022-06-25 19:18:44','728','472',165.00,1700.00,280500.00),(40714,'1','206','257804','2022-06-25 19:19:21','728','472',165.00,1700.00,280500.00),(40715,'1','206','257804','2022-06-25 19:19:44','728','472',165.00,1700.00,280500.00),(40716,'1','206','257804','2022-06-25 19:20:01','728','473',830.00,12650.00,10499500.00),(40717,'1','206','257804','2022-06-25 19:20:19','728','472',165.00,1700.00,280500.00),(40718,'1','206','257805','2022-06-26 19:23:08','728','472',165.00,5650.00,932250.00),(40719,'1','206','257805','2022-06-26 19:23:26','728','473',830.00,10900.00,9047000.00),(40720,'1','206','257811','2022-07-06 22:30:58','728','473',830.00,8250.00,6847500.00),(40721,'1','206','257811','2022-07-06 22:31:23','728','472',165.00,11400.00,1881000.00),(40722,'1','206','257820','2022-07-27 20:36:20','728','473',810.00,4150.00,3361500.00),(40723,'1','206','257820','2022-07-27 20:36:36','728','472',185.00,51750.00,9573750.00),(40724,'1','206','257824','2022-07-29 20:13:08','728','473',810.00,4000.00,3240000.00),(40725,'1','206','257824','2022-07-29 20:13:25','728','472',185.00,23000.00,4255000.00),(40726,'1','206','257831','2022-08-01 18:40:24','728','472',185.00,14650.00,2710250.00),(40727,'1','206','257831','2022-08-01 18:40:50','728','473',810.00,17900.00,14499000.00),(40728,'1','206','257833','2022-08-02 18:07:56','728','472',185.00,5350.00,989750.00),(40729,'1','206','257833','2022-08-02 18:08:22','728','473',810.00,17900.00,14499000.00),(40730,'1','206','257835','2022-08-03 20:27:05','728','472',185.00,6650.00,1230250.00),(40731,'1','206','257835','2022-08-03 20:28:12','728','472',185.00,17050.00,3154250.00),(40732,'1','206','257837','2022-08-04 20:45:58','728','472',185.00,11000.00,2035000.00),(40733,'1','206','257837','2022-08-04 20:47:45','728','473',810.00,16950.00,13729500.00),(40734,'1','206','257839','2022-08-06 00:33:51','728','472',185.00,45000.00,8325000.00),(40735,'1','206','257839','2022-08-06 00:34:22','728','473',810.00,16950.00,13729500.00),(40736,'1','206','257845','2022-08-08 19:28:38','728','472',185.00,23500.00,4347500.00),(40737,'1','206','257845','2022-08-08 19:29:27','728','473',810.00,15650.00,12676500.00),(40738,'1','206','257849','2022-08-10 18:42:44','728','472',185.00,18700.00,3459500.00),(40739,'1','206','257849','2022-08-10 18:43:03','728','473',810.00,15300.00,12393000.00),(40740,'1','206','257851','2022-08-11 20:04:48','728','473',810.00,14950.00,12109500.00),(40741,'1','206','257851','2022-08-11 20:05:34','728','472',185.00,22450.00,4153250.00),(40742,'1','206','257853','2022-08-12 20:16:43','728','473',810.00,14900.00,12069000.00),(40743,'1','206','257853','2022-08-12 20:17:04','728','472',185.00,12550.00,2321750.00),(40744,'1','206','257855','2022-08-16 10:59:50','728','472',185.00,3450.00,638250.00),(40745,'1','206','257855','2022-08-16 11:00:15','728','473',810.00,14100.00,11421000.00),(40746,'1','206','257858','2022-08-18 21:11:43','728','473',800.00,13200.00,10560000.00),(40747,'1','206','257858','2022-08-18 21:11:59','728','472',185.00,22400.00,4144000.00),(40748,'1','206','257859','2022-08-19 17:43:18','728','473',800.00,13200.00,10560000.00),(40749,'1','206','257859','2022-08-19 17:43:48','728','472',185.00,22400.00,4144000.00),(40750,'1','206','257860','2022-08-19 21:15:29','728','473',800.00,13150.00,10520000.00),(40751,'1','206','257860','2022-08-19 21:17:17','728','472',185.00,53000.00,9805000.00),(40752,'1','206','257860','2022-08-19 21:17:17','728','472',185.00,53000.00,9805000.00),(40753,'1','206','257862','2022-08-20 20:53:56','728','472',185.00,4600.00,851000.00),(40754,'1','206','257862','2022-08-20 20:54:25','728','472',185.00,46600.00,8621000.00),(40755,'1','206','257862','2022-08-20 20:54:52','728','473',800.00,11900.00,9520000.00),(40756,'1','206','257864','2022-08-22 10:34:01','728','473',800.00,11800.00,9440000.00),(40757,'1','206','257864','2022-08-22 10:34:26','728','472',185.00,54300.00,10045500.00),(40758,'1','206','257867','2022-08-23 13:56:02','728','473',800.00,11500.00,9200000.00),(40759,'1','206','257867','2022-08-23 13:56:26','728','472',185.00,46050.00,8519250.00),(40760,'1','206','257870','2022-08-24 19:59:45','728','473',800.00,10300.00,8240000.00),(40761,'1','206','257870','2022-08-24 20:00:07','728','472',185.00,56200.00,10397000.00),(40762,'1','206','257872','2022-08-25 20:49:57','728','472',185.00,45700.00,8454500.00),(40763,'1','206','257872','2022-08-25 20:50:16','728','473',800.00,10100.00,8080000.00),(40764,'1','206','257874','2022-08-26 21:43:38','728','473',800.00,10100.00,8080000.00),(40765,'1','206','257874','2022-08-26 21:43:55','728','472',185.00,35450.00,6558250.00),(40766,'1','206','257876','2022-08-27 20:11:03','728','473',800.00,10050.00,8040000.00),(40767,'1','206','257876','2022-08-27 20:11:21','728','472',185.00,24750.00,4578750.00),(40768,'1','206','257880','2022-08-29 18:11:16','728','472',185.00,12600.00,2331000.00),(40769,'1','206','257880','2022-08-29 18:11:40','728','473',800.00,9550.00,7640000.00),(40770,'1','206','257880','2022-08-29 18:12:26','728','472',185.00,9300.00,1720500.00),(40771,'1','206','257880','2022-08-29 18:12:56','728','473',800.00,9550.00,7640000.00),(40772,'1','206','257883','2022-09-02 20:24:14','728','473',800.00,7500.00,6000000.00),(40773,'1','206','257883','2022-09-02 20:24:57','728','472',185.00,19500.00,3607500.00),(40774,'1','206','257885','2022-09-03 20:01:12','728','473',800.00,7400.00,5920000.00),(40775,'1','206','257885','2022-09-03 20:01:28','728','472',185.00,11800.00,2183000.00),(40776,'1','206','257888','2022-09-05 19:01:48','728','473',800.00,7100.00,5680000.00),(40777,'1','206','257888','2022-09-05 19:02:15','728','472',185.00,1700.00,314500.00),(40778,'1','206','257888','2022-09-05 20:29:53','728','473',800.00,7050.00,5640000.00),(40779,'1','206','257888','2022-09-05 20:30:31','728','472',185.00,24200.00,4477000.00),(40780,'1','206','257890','2022-09-06 20:44:23','728','473',800.00,7050.00,5640000.00),(40781,'1','206','257890','2022-09-06 20:44:44','728','472',185.00,15000.00,2775000.00),(40782,'1','206','257894','2022-09-08 21:06:52','728','473',800.00,5400.00,4320000.00),(40783,'1','206','257894','2022-09-08 21:07:06','728','472',185.00,30150.00,5577750.00),(40784,'1','206','257897','2022-09-10 20:44:22','728','473',800.00,4450.00,3560000.00),(40785,'1','206','257897','2022-09-10 20:44:43','728','472',185.00,46250.00,8556250.00),(40786,'1','206','257900','2022-09-11 19:51:30','728','473',800.00,4450.00,3560000.00),(40787,'1','206','257900','2022-09-11 19:53:16','728','472',185.00,39900.00,7381500.00),(40788,'1','206','257902','2022-09-12 21:09:34','728','473',800.00,4050.00,3240000.00),(40789,'1','206','257902','2022-09-12 21:17:04','728','472',185.00,33100.00,6123500.00),(40790,'1','206','257904','2022-09-13 21:30:29','728','473',800.00,2850.00,2280000.00),(40791,'1','206','257904','2022-09-13 21:30:48','728','472',185.00,72500.00,13412500.00),(40792,'1','206','257906','2022-09-14 21:06:04','728','473',800.00,1700.00,1360000.00),(40793,'1','206','257906','2022-09-14 21:06:26','728','472',185.00,64650.00,11960250.00),(40794,'1','206','257908','2022-09-15 20:49:14','728','473',800.00,1000.00,800000.00),(40795,'1','206','257908','2022-09-15 20:49:39','728','472',185.00,87750.00,16233750.00),(40796,'1','206','257910','2022-09-16 20:19:20','728','473',800.00,900.00,720000.00),(40797,'1','206','257910','2022-09-16 20:19:39','728','472',185.00,79750.00,14753750.00),(40798,'1','206','257912','2022-09-17 20:56:40','728','472',185.00,68500.00,12672500.00),(40799,'1','206','257912','2022-09-17 20:56:56','728','473',800.00,850.00,680000.00),(40800,'1','206','257914','2022-09-18 19:48:45','728','473',800.00,500.00,400000.00),(40801,'1','206','257914','2022-09-18 19:50:06','728','472',185.00,61600.00,11396000.00),(40802,'1','206','257916','2022-09-19 20:20:41','728','472',185.00,53600.00,9916000.00),(40803,'1','206','257916','2022-09-19 20:20:56','728','473',800.00,500.00,400000.00),(40804,'1','206','257918','2022-09-20 21:12:50','728','473',800.00,500.00,400000.00),(40805,'1','206','257918','2022-09-20 21:13:11','728','472',185.00,43050.00,7964250.00),(40806,'1','206','257920','2022-09-21 20:45:45','728','473',800.00,150.00,120000.00),(40807,'1','206','257920','2022-09-21 20:46:06','728','472',185.00,34900.00,6456500.00),(40808,'1','206','257922','2022-09-22 21:39:13','728','472',185.00,28500.00,5272500.00),(40809,'1','206','257922','2022-09-22 21:39:29','728','473',800.00,200.00,160000.00),(40810,'1','206','257924','2022-09-23 20:25:05','728','473',800.00,14150.00,11320000.00),(40811,'1','206','257924','2022-09-23 20:27:01','728','472',185.00,22200.00,4107000.00),(40812,'1','206','257928','2022-09-26 09:48:22','728','473',800.00,13150.00,10520000.00),(40813,'1','206','257928','2022-09-26 09:48:56','728','472',185.00,32350.00,5984750.00),(40814,'1','206','257930','2022-09-26 20:55:01','728','473',800.00,13000.00,10400000.00),(40815,'1','206','257930','2022-09-26 20:55:21','728','472',185.00,25000.00,4625000.00),(40816,'1','206','257932','2022-09-27 19:40:31','728','473',800.00,13000.00,10400000.00),(40817,'1','206','257932','2022-09-27 19:40:47','728','472',185.00,11000.00,2035000.00),(40818,'1','206','257934','2022-10-02 19:44:42','728','473',810.00,9700.00,7857000.00),(40819,'1','206','257934','2022-10-02 19:46:59','728','472',185.00,5850.00,1082250.00),(40820,'1','206','257982','2022-11-16 09:44:09','728','472',195.00,21700.00,4231500.00),(40821,'1','206','257982','2022-11-16 09:44:36','728','472',195.00,8100.00,1579500.00),(40822,'1','206','257982','2022-11-16 09:45:01','728','472',195.00,5400.00,1053000.00),(40823,'1','206','257982','2022-11-16 09:45:21','728','472',195.00,2950.00,575250.00),(40824,'1','206','257982','2022-11-16 09:46:18','728','472',195.00,7950.00,1550250.00),(40825,'1','206','257982','2022-11-16 09:46:51','728','472',195.00,57750.00,11261250.00),(40826,'1','206','257982','2022-11-16 09:47:23','728','472',195.00,35250.00,6873750.00),(40827,'1','206','257982','2022-11-16 09:47:50','728','472',195.00,15000.00,2925000.00),(40828,'1','206','257982','2022-11-16 09:48:21','728','472',195.00,12600.00,2457000.00),(40829,'1','206','257982','2022-11-16 09:48:50','728','472',195.00,26700.00,5206500.00),(40830,'1','206','257982','2022-11-16 09:49:37','728','472',195.00,6950.00,1355250.00),(40831,'1','206','257982','2022-11-16 09:50:21','728','472',195.00,36950.00,7205250.00),(40832,'1','206','257982','2022-11-16 09:50:46','728','472',195.00,39500.00,7702500.00),(40833,'1','206','257982','2022-11-16 09:51:49','728','472',195.00,38600.00,7527000.00),(40834,'1','206','257982','2022-11-16 09:52:14','728','472',195.00,23100.00,4504500.00),(40835,'1','206','257982','2022-11-16 09:52:32','728','473',860.00,150.00,129000.00);
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=432 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',430,'206','PMS TANKS',''),('1',431,'206','AGO TANK ','');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=1032 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','206','430',1030,0,'472','PMS TANK 1, 2 & 3',99000.00,0.00,NULL,'CONTAINING PMS','178','2021-12-10 11:30:00','2021-12-10 11:30:00','178',5,1),('1','206','431',1031,0,'473','AGO TANK 1',36000.00,0.00,NULL,'CONTAINING AGO','178','2021-12-10 11:41:23','2021-12-10 11:41:23','178',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','206',1031,371.96,'2023-03-20 22:18:51'),(2,'1','206',1030,71669.26,'2023-03-20 22:18:51');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2652163 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2246600,'1','206',NULL,473,'Purchased from AA RANO NIGERIA LTD',0.00,10350000.00,345.00,0.00,0.00,'2021-12-11 13:29:38','',''),(2246611,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,6525000.00,45000.00,0.00,0.00,'2021-12-11 13:30:06','',''),(2246656,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,8250000.00,50000.00,0.00,0.00,'2021-12-11 13:32:50','',''),(2250028,'1','206',NULL,473,'Returned purchase #86909 to AA RANO NIGERIA LTD',10350000.00,0.00,0.00,345.00,0.00,'2021-12-11 16:36:35','',''),(2250105,'1','206',NULL,472,'Reception corrector for bridging 127030',0.00,0.00,0.00,45000.00,0.00,'2021-12-11 16:40:17','',''),(2250106,'1','206','1030',472,'Received from bridging 127030',0.00,0.00,45000.00,0.00,0.00,'2021-12-11 16:40:17','',''),(2250147,'1','206',NULL,473,'Purchased from AA RANO NIGERIA LTD',0.00,10350000.00,30000.00,0.00,0.00,'2021-12-11 16:42:14','',''),(2250190,'1','206',NULL,473,'Reception corrector for bridging 127033',0.00,0.00,0.00,30000.00,0.00,'2021-12-11 16:45:34','',''),(2250191,'1','206','1031',473,'Received from bridging 127033',0.00,0.00,30000.00,0.00,0.00,'2021-12-11 16:45:34','',''),(2250880,'1','206',NULL,472,'Reception corrector for bridging 127031',0.00,0.00,0.00,50000.00,0.00,'2021-12-11 17:33:53','',''),(2250881,'1','206','1030',472,'Received from bridging 127031',0.00,0.00,50000.00,0.00,0.00,'2021-12-11 17:33:53','',''),(2254283,'1','206','1030',472,'Sale Id shift 245375',0.00,0.00,0.00,578.15,0.00,'2021-12-12 08:44:09','',''),(2254284,'1','206','1030',472,'Sale Id shift 245375',0.00,0.00,0.00,709.09,0.00,'2021-12-12 08:44:09','',''),(2254285,'1','206','1030',472,'Sale Id shift 245375',0.00,0.00,0.00,466.83,0.00,'2021-12-12 08:44:09','',''),(2254286,'1','206','1030',472,'Sale Id shift 245375',0.00,0.00,0.00,340.88,0.00,'2021-12-12 08:44:09','',''),(2254287,'1','206','1031',473,'Sale Id shift 245375',0.00,0.00,0.00,6.27,0.00,'2021-12-12 08:44:09','',''),(2254288,'1','206',NULL,472,'Sale Id shift 245375',345666.75,0.00,0.00,0.00,0.00,'2021-12-12 08:44:09','',''),(2254289,'1','206',NULL,473,'Sale Id shift 245375',2163.15,0.00,0.00,0.00,0.00,'2021-12-12 08:44:09','',''),(2260805,'1','206','1030',472,'Sale Id shift 245508',0.00,0.00,0.00,2375.78,0.00,'2021-12-12 14:03:32','',''),(2260806,'1','206','1030',472,'Sale Id shift 245508',0.00,0.00,0.00,1458.15,0.00,'2021-12-12 14:03:32','',''),(2260807,'1','206','1030',472,'Sale Id shift 245508',0.00,0.00,0.00,1098.66,0.00,'2021-12-12 14:03:32','',''),(2260808,'1','206','1030',472,'Sale Id shift 245508',0.00,0.00,0.00,0.28,0.00,'2021-12-12 14:03:32','',''),(2260809,'1','206','1030',472,'Sale Id shift 245508',0.00,0.00,0.00,723.16,0.00,'2021-12-12 14:03:32','',''),(2260810,'1','206','1031',473,'Sale Id shift 245508',0.00,0.00,0.00,260.03,0.00,'2021-12-12 14:03:32','',''),(2260811,'1','206',NULL,472,'Sale Id shift 245508',933244.95,0.00,0.00,0.00,0.00,'2021-12-12 14:03:32','',''),(2260812,'1','206',NULL,473,'Sale Id shift 245508',89710.35,0.00,0.00,0.00,0.00,'2021-12-12 14:03:32','',''),(2265113,'1','206','1030',472,'Sale Id shift 245604',0.00,0.00,0.00,1995.81,0.00,'2021-12-13 00:11:01','',''),(2265114,'1','206','1030',472,'Sale Id shift 245604',0.00,0.00,0.00,0.64,0.00,'2021-12-13 00:11:01','',''),(2265115,'1','206','1030',472,'Sale Id shift 245604',0.00,0.00,0.00,1123.44,0.00,'2021-12-13 00:11:01','',''),(2265116,'1','206','1030',472,'Sale Id shift 245604',0.00,0.00,0.00,1298.47,0.00,'2021-12-13 00:11:01','',''),(2265117,'1','206','1030',472,'Sale Id shift 245604',0.00,0.00,0.00,554.97,0.00,'2021-12-13 00:11:01','',''),(2265118,'1','206','1031',473,'Sale Id shift 245604',0.00,0.00,0.00,224.35,0.00,'2021-12-13 00:11:01','',''),(2265119,'1','206',NULL,472,'Sale Id shift 245604',820599.45,0.00,0.00,0.00,0.00,'2021-12-13 00:11:01','',''),(2265120,'1','206',NULL,473,'Sale Id shift 245604',77400.75,0.00,0.00,0.00,0.00,'2021-12-13 00:11:01','',''),(2352118,'1','206','1030',472,'Sale Id shift 248093',0.00,0.00,0.00,878.85,0.00,'2021-12-23 09:59:28','',''),(2352119,'1','206','1030',472,'Sale Id shift 248093',0.00,0.00,0.00,0.93,0.00,'2021-12-23 09:59:28','',''),(2352120,'1','206','1030',472,'Sale Id shift 248093',0.00,0.00,0.00,645.68,0.00,'2021-12-23 09:59:28','',''),(2352121,'1','206','1030',472,'Sale Id shift 248093',0.00,0.00,0.00,186.49,0.00,'2021-12-23 09:59:28','',''),(2352122,'1','206','1030',472,'Sale Id shift 248093',0.00,0.00,0.00,0.35,0.00,'2021-12-23 09:59:28','',''),(2352123,'1','206','1030',472,'Sale Id shift 248093',0.00,0.00,0.00,889.75,0.00,'2021-12-23 09:59:28','',''),(2352124,'1','206','1030',472,'Sale Id shift 248093',0.00,0.00,0.00,497.24,0.00,'2021-12-23 09:59:28','',''),(2352125,'1','206','1030',472,'Sale Id shift 248093',0.00,0.00,0.00,0.37,0.00,'2021-12-23 09:59:28','',''),(2352126,'1','206',NULL,472,'Sale Id shift 248093',511443.90,0.00,0.00,0.00,0.00,'2021-12-23 09:59:28','',''),(2357830,'1','206','1030',472,'Sale Id shift 248301',0.00,0.00,0.00,1042.87,0.00,'2021-12-23 18:56:02','',''),(2357831,'1','206','1030',472,'Sale Id shift 248301',0.00,0.00,0.00,656.54,0.00,'2021-12-23 18:56:02','',''),(2357832,'1','206','1030',472,'Sale Id shift 248301',0.00,0.00,0.00,1226.40,0.00,'2021-12-23 18:56:02','',''),(2357833,'1','206','1030',472,'Sale Id shift 248301',0.00,0.00,0.00,27.27,0.00,'2021-12-23 18:56:02','',''),(2357834,'1','206','1030',472,'Sale Id shift 248301',0.00,0.00,0.00,877.52,0.00,'2021-12-23 18:56:02','',''),(2357835,'1','206','1031',473,'Sale Id shift 248301',0.00,0.00,0.00,131.60,0.00,'2021-12-23 18:56:02','',''),(2357836,'1','206',NULL,472,'Sale Id shift 248301',632049.00,0.00,0.00,0.00,0.00,'2021-12-23 18:56:02','',''),(2357837,'1','206',NULL,473,'Sale Id shift 248301',45402.00,0.00,0.00,0.00,0.00,'2021-12-23 18:56:02','',''),(2361051,'1','206','1030',472,'Sale Id shift 248360',0.00,0.00,0.00,418.66,0.00,'2021-12-24 09:47:37','',''),(2361052,'1','206','1030',472,'Sale Id shift 248360',0.00,0.00,0.00,2128.98,0.00,'2021-12-24 09:47:37','',''),(2361053,'1','206','1030',472,'Sale Id shift 248360',0.00,0.00,0.00,1635.64,0.00,'2021-12-24 09:47:37','',''),(2361054,'1','206','1030',472,'Sale Id shift 248360',0.00,0.00,0.00,465.32,0.00,'2021-12-24 09:47:37','',''),(2361055,'1','206','1030',472,'Sale Id shift 248360',0.00,0.00,0.00,110.68,0.00,'2021-12-24 09:47:37','',''),(2361056,'1','206','1030',472,'Sale Id shift 248360',0.00,0.00,0.00,696.93,0.00,'2021-12-24 09:47:37','',''),(2361057,'1','206','1030',472,'Sale Id shift 248360',0.00,0.00,0.00,1152.44,0.00,'2021-12-24 09:47:37','',''),(2361058,'1','206','1030',472,'Sale Id shift 248360',0.00,0.00,0.00,128.50,0.00,'2021-12-24 09:47:37','',''),(2361059,'1','206','1031',473,'Sale Id shift 248360',0.00,0.00,0.00,130.40,0.00,'2021-12-24 09:47:37','',''),(2361060,'1','206',NULL,472,'Sale Id shift 248360',1111629.75,0.00,0.00,0.00,0.00,'2021-12-24 09:47:37','',''),(2361061,'1','206',NULL,473,'Sale Id shift 248360',44988.00,0.00,0.00,0.00,0.00,'2021-12-24 09:47:37','',''),(2365697,'1','206','1030',472,'Sale Id shift 248492',0.00,0.00,0.00,714.08,0.00,'2021-12-24 16:07:22','',''),(2365698,'1','206','1030',472,'Sale Id shift 248492',0.00,0.00,0.00,1314.39,0.00,'2021-12-24 16:07:22','',''),(2365699,'1','206','1030',472,'Sale Id shift 248492',0.00,0.00,0.00,1367.44,0.00,'2021-12-24 16:07:22','',''),(2365700,'1','206','1030',472,'Sale Id shift 248492',0.00,0.00,0.00,383.46,0.00,'2021-12-24 16:07:22','',''),(2365701,'1','206','1030',472,'Sale Id shift 248492',0.00,0.00,0.00,320.50,0.00,'2021-12-24 16:07:22','',''),(2365702,'1','206','1030',472,'Sale Id shift 248492',0.00,0.00,0.00,699.83,0.00,'2021-12-24 16:07:22','',''),(2365703,'1','206','1030',472,'Sale Id shift 248492',0.00,0.00,0.00,731.69,0.00,'2021-12-24 16:07:22','',''),(2365704,'1','206','1030',472,'Sale Id shift 248492',0.00,0.00,0.00,291.14,0.00,'2021-12-24 16:07:22','',''),(2365705,'1','206','1031',473,'Sale Id shift 248492',0.00,0.00,0.00,13.92,0.00,'2021-12-24 16:07:22','',''),(2365706,'1','206',NULL,472,'Sale Id shift 248492',960717.45,0.00,0.00,0.00,0.00,'2021-12-24 16:07:22','',''),(2365707,'1','206',NULL,473,'Sale Id shift 248492',4802.40,0.00,0.00,0.00,0.00,'2021-12-24 16:07:22','',''),(2373814,'1','206','1030',472,'Sale Id shift 248599',0.00,0.00,0.00,1118.43,0.00,'2021-12-25 15:59:25','',''),(2373815,'1','206','1030',472,'Sale Id shift 248599',0.00,0.00,0.00,2340.82,0.00,'2021-12-25 15:59:25','',''),(2373816,'1','206','1030',472,'Sale Id shift 248599',0.00,0.00,0.00,2450.53,0.00,'2021-12-25 15:59:25','',''),(2373817,'1','206','1030',472,'Sale Id shift 248599',0.00,0.00,0.00,307.00,0.00,'2021-12-25 15:59:25','',''),(2373818,'1','206','1030',472,'Sale Id shift 248599',0.00,0.00,0.00,315.21,0.00,'2021-12-25 15:59:25','',''),(2373819,'1','206','1030',472,'Sale Id shift 248599',0.00,0.00,0.00,2551.28,0.00,'2021-12-25 15:59:25','',''),(2373820,'1','206','1031',473,'Sale Id shift 248599',0.00,0.00,0.00,21.17,0.00,'2021-12-25 15:59:25','',''),(2373821,'1','206',NULL,472,'Sale Id shift 248599',1498739.55,0.00,0.00,0.00,0.00,'2021-12-25 15:59:25','',''),(2373822,'1','206',NULL,473,'Sale Id shift 248599',7303.65,0.00,0.00,0.00,0.00,'2021-12-25 15:59:25','',''),(2376270,'1','206','1030',472,'Sale Id shift 248793',0.00,0.00,0.00,2514.80,0.00,'2021-12-26 09:16:47','',''),(2376271,'1','206','1030',472,'Sale Id shift 248793',0.00,0.00,0.00,159.28,0.00,'2021-12-26 09:16:47','',''),(2376272,'1','206','1030',472,'Sale Id shift 248793',0.00,0.00,0.00,1588.07,0.00,'2021-12-26 09:16:47','',''),(2376273,'1','206','1030',472,'Sale Id shift 248793',0.00,0.00,0.00,440.87,0.00,'2021-12-26 09:16:47','',''),(2376274,'1','206','1030',472,'Sale Id shift 248793',0.00,0.00,0.00,1083.14,0.00,'2021-12-26 09:16:47','',''),(2376275,'1','206','1030',472,'Sale Id shift 248793',0.00,0.00,0.00,1082.93,0.00,'2021-12-26 09:16:47','',''),(2376276,'1','206','1030',472,'Sale Id shift 248793',0.00,0.00,0.00,217.94,0.00,'2021-12-26 09:16:47','',''),(2376277,'1','206',NULL,472,'Sale Id shift 248793',1169359.95,0.00,0.00,0.00,0.00,'2021-12-26 09:16:47','',''),(2379030,'1','206','1030',472,'Sale Id shift 248993',0.00,0.00,0.00,1244.01,0.00,'2021-12-26 14:52:45','',''),(2379031,'1','206','1030',472,'Sale Id shift 248993',0.00,0.00,0.00,1374.44,0.00,'2021-12-26 14:52:45','',''),(2379032,'1','206','1030',472,'Sale Id shift 248993',0.00,0.00,0.00,2190.70,0.00,'2021-12-26 14:52:45','',''),(2379033,'1','206','1030',472,'Sale Id shift 248993',0.00,0.00,0.00,291.25,0.00,'2021-12-26 14:52:45','',''),(2379034,'1','206','1030',472,'Sale Id shift 248993',0.00,0.00,0.00,771.79,0.00,'2021-12-26 14:52:45','',''),(2379035,'1','206','1030',472,'Sale Id shift 248993',0.00,0.00,0.00,1548.90,0.00,'2021-12-26 14:52:45','',''),(2379036,'1','206','1031',473,'Sale Id shift 248993',0.00,0.00,0.00,149.07,0.00,'2021-12-26 14:52:45','',''),(2379037,'1','206',NULL,472,'Sale Id shift 248993',1224479.85,0.00,0.00,0.00,0.00,'2021-12-26 14:52:45','',''),(2379038,'1','206',NULL,473,'Sale Id shift 248993',51429.15,0.00,0.00,0.00,0.00,'2021-12-26 14:52:45','',''),(2380097,'1','206','1030',472,'Sale Id shift 249017',0.00,0.00,0.00,1801.99,0.00,'2021-12-26 19:10:08','',''),(2380098,'1','206','1030',472,'Sale Id shift 249017',0.00,0.00,0.00,1796.63,0.00,'2021-12-26 19:10:08','',''),(2380099,'1','206','1030',472,'Sale Id shift 249017',0.00,0.00,0.00,1873.76,0.00,'2021-12-26 19:10:08','',''),(2380100,'1','206','1030',472,'Sale Id shift 249017',0.00,0.00,0.00,635.42,0.00,'2021-12-26 19:10:08','',''),(2380101,'1','206','1030',472,'Sale Id shift 249017',0.00,0.00,0.00,675.65,0.00,'2021-12-26 19:10:08','',''),(2380102,'1','206','1030',472,'Sale Id shift 249017',0.00,0.00,0.00,1701.76,0.00,'2021-12-26 19:10:08','',''),(2380103,'1','206','1030',472,'Sale Id shift 249017',0.00,0.00,0.00,1198.15,0.00,'2021-12-26 19:10:08','',''),(2380104,'1','206','1030',472,'Sale Id shift 249017',0.00,0.00,0.00,644.58,0.00,'2021-12-26 19:10:08','',''),(2380105,'1','206','1031',473,'Sale Id shift 249017',0.00,0.00,0.00,5.22,0.00,'2021-12-26 19:10:08','',''),(2380106,'1','206',NULL,472,'Sale Id shift 249017',1704110.10,0.00,0.00,0.00,0.00,'2021-12-26 19:10:08','',''),(2380107,'1','206',NULL,473,'Sale Id shift 249017',1800.90,0.00,0.00,0.00,0.00,'2021-12-26 19:10:08','',''),(2382619,'1','206','1030',472,'Sale Id shift 249064',0.00,0.00,0.00,934.64,0.00,'2021-12-27 10:05:25','',''),(2382620,'1','206','1030',472,'Sale Id shift 249064',0.00,0.00,0.00,1191.39,0.00,'2021-12-27 10:05:25','',''),(2382621,'1','206','1030',472,'Sale Id shift 249064',0.00,0.00,0.00,2072.15,0.00,'2021-12-27 10:05:25','',''),(2382622,'1','206','1030',472,'Sale Id shift 249064',0.00,0.00,0.00,21.22,0.00,'2021-12-27 10:05:25','',''),(2382623,'1','206','1030',472,'Sale Id shift 249064',0.00,0.00,0.00,268.87,0.00,'2021-12-27 10:05:25','',''),(2382624,'1','206','1030',472,'Sale Id shift 249064',0.00,0.00,0.00,1446.03,0.00,'2021-12-27 10:05:25','',''),(2382625,'1','206','1030',472,'Sale Id shift 249064',0.00,0.00,0.00,125.56,0.00,'2021-12-27 10:05:25','',''),(2382626,'1','206','1031',473,'Sale Id shift 249064',0.00,0.00,0.00,166.00,0.00,'2021-12-27 10:05:25','',''),(2382627,'1','206',NULL,472,'Sale Id shift 249064',999876.90,0.00,0.00,0.00,0.00,'2021-12-27 10:05:25','',''),(2382628,'1','206',NULL,473,'Sale Id shift 249064',57270.00,0.00,0.00,0.00,0.00,'2021-12-27 10:05:25','',''),(2387817,'1','206','1030',472,'Sale Id shift 249210',0.00,0.00,0.00,375.09,0.00,'2021-12-28 08:39:14','',''),(2387818,'1','206','1030',472,'Sale Id shift 249210',0.00,0.00,0.00,1410.72,0.00,'2021-12-28 08:39:14','',''),(2387819,'1','206','1030',472,'Sale Id shift 249210',0.00,0.00,0.00,1311.30,0.00,'2021-12-28 08:39:14','',''),(2387820,'1','206','1030',472,'Sale Id shift 249210',0.00,0.00,0.00,147.25,0.00,'2021-12-28 08:39:14','',''),(2387821,'1','206','1030',472,'Sale Id shift 249210',0.00,0.00,0.00,1524.86,0.00,'2021-12-28 08:39:14','',''),(2387822,'1','206','1030',472,'Sale Id shift 249210',0.00,0.00,0.00,100.95,0.00,'2021-12-28 08:39:14','',''),(2387823,'1','206','1031',473,'Sale Id shift 249210',0.00,0.00,0.00,191.84,0.00,'2021-12-28 08:39:14','',''),(2387824,'1','206',NULL,472,'Sale Id shift 249210',803578.05,0.00,0.00,0.00,0.00,'2021-12-28 08:39:14','',''),(2387825,'1','206',NULL,473,'Sale Id shift 249210',66184.80,0.00,0.00,0.00,0.00,'2021-12-28 08:39:14','',''),(2389748,'1','206','1030',472,'Sale Id shift 249436',0.00,0.00,0.00,1376.90,0.00,'2021-12-28 12:05:36','',''),(2389749,'1','206','1030',472,'Sale Id shift 249436',0.00,0.00,0.00,1034.66,0.00,'2021-12-28 12:05:36','',''),(2389750,'1','206','1030',472,'Sale Id shift 249436',0.00,0.00,0.00,1461.85,0.00,'2021-12-28 12:05:36','',''),(2389751,'1','206','1030',472,'Sale Id shift 249436',0.00,0.00,0.00,441.28,0.00,'2021-12-28 12:05:36','',''),(2389752,'1','206','1030',472,'Sale Id shift 249436',0.00,0.00,0.00,1031.51,0.00,'2021-12-28 12:05:36','',''),(2389753,'1','206','1030',472,'Sale Id shift 249436',0.00,0.00,0.00,260.89,0.00,'2021-12-28 12:05:36','',''),(2389754,'1','206','1031',473,'Sale Id shift 249436',0.00,0.00,0.00,41.04,0.00,'2021-12-28 12:05:36','',''),(2389755,'1','206',NULL,472,'Sale Id shift 249436',925169.85,0.00,0.00,0.00,0.00,'2021-12-28 12:05:36','',''),(2389756,'1','206',NULL,473,'Sale Id shift 249436',14158.80,0.00,0.00,0.00,0.00,'2021-12-28 12:05:36','',''),(2392345,'1','206','1030',472,'Sale Id shift 249465',0.00,0.00,0.00,1211.71,0.00,'2021-12-28 16:27:37','',''),(2392346,'1','206','1030',472,'Sale Id shift 249465',0.00,0.00,0.00,584.36,0.00,'2021-12-28 16:27:37','',''),(2392347,'1','206','1030',472,'Sale Id shift 249465',0.00,0.00,0.00,1364.01,0.00,'2021-12-28 16:27:37','',''),(2392348,'1','206','1030',472,'Sale Id shift 249465',0.00,0.00,0.00,229.11,0.00,'2021-12-28 16:27:37','',''),(2392349,'1','206','1030',472,'Sale Id shift 249465',0.00,0.00,0.00,167.88,0.00,'2021-12-28 16:27:37','',''),(2392350,'1','206','1030',472,'Sale Id shift 249465',0.00,0.00,0.00,1286.56,0.00,'2021-12-28 16:27:37','',''),(2392351,'1','206','1031',473,'Sale Id shift 249465',0.00,0.00,0.00,16.82,0.00,'2021-12-28 16:27:37','',''),(2392352,'1','206',NULL,472,'Sale Id shift 249465',799198.95,0.00,0.00,0.00,0.00,'2021-12-28 16:27:37','',''),(2392353,'1','206',NULL,473,'Sale Id shift 249465',5802.90,0.00,0.00,0.00,0.00,'2021-12-28 16:27:37','',''),(2394970,'1','206','1030',472,'Sale Id shift 249522',0.00,0.00,0.00,821.45,0.00,'2021-12-29 09:15:08','',''),(2394971,'1','206','1030',472,'Sale Id shift 249522',0.00,0.00,0.00,505.70,0.00,'2021-12-29 09:15:08','',''),(2394972,'1','206','1030',472,'Sale Id shift 249522',0.00,0.00,0.00,1015.79,0.00,'2021-12-29 09:15:08','',''),(2394973,'1','206','1030',472,'Sale Id shift 249522',0.00,0.00,0.00,108.78,0.00,'2021-12-29 09:15:08','',''),(2394974,'1','206','1030',472,'Sale Id shift 249522',0.00,0.00,0.00,3.03,0.00,'2021-12-29 09:15:08','',''),(2394975,'1','206','1030',472,'Sale Id shift 249522',0.00,0.00,0.00,862.25,0.00,'2021-12-29 09:15:08','',''),(2394976,'1','206','1030',472,'Sale Id shift 249522',0.00,0.00,0.00,365.99,0.00,'2021-12-29 09:15:08','',''),(2394977,'1','206','1030',472,'Sale Id shift 249522',0.00,0.00,0.00,98.45,0.00,'2021-12-29 09:15:08','',''),(2394978,'1','206',NULL,472,'Sale Id shift 249522',623937.60,0.00,0.00,0.00,0.00,'2021-12-29 09:15:08','',''),(2397714,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,3465000.00,21000.00,0.00,0.00,'2021-12-29 14:26:14','',''),(2399106,'1','206',NULL,472,'Reception corrector for bridging 129136',0.00,0.00,0.00,21000.00,0.00,'2021-12-29 16:27:10','',''),(2399107,'1','206','1030',472,'Received from bridging 129136',0.00,0.00,21000.00,0.00,0.00,'2021-12-29 16:27:10','',''),(2402903,'1','206','1030',472,'Sale Id shift 249723',0.00,0.00,0.00,869.98,0.00,'2021-12-30 10:51:44','',''),(2402904,'1','206','1030',472,'Sale Id shift 249723',0.00,0.00,0.00,1128.18,0.00,'2021-12-30 10:51:44','',''),(2402905,'1','206','1030',472,'Sale Id shift 249723',0.00,0.00,0.00,261.96,0.00,'2021-12-30 10:51:44','',''),(2402906,'1','206','1030',472,'Sale Id shift 249723',0.00,0.00,0.00,30.30,0.00,'2021-12-30 10:51:44','',''),(2402907,'1','206','1030',472,'Sale Id shift 249723',0.00,0.00,0.00,1118.45,0.00,'2021-12-30 10:51:44','',''),(2402908,'1','206','1030',472,'Sale Id shift 249723',0.00,0.00,0.00,353.56,0.00,'2021-12-30 10:51:44','',''),(2402909,'1','206','1031',473,'Sale Id shift 249723',0.00,0.00,0.00,15.94,0.00,'2021-12-30 10:51:44','',''),(2402910,'1','206',NULL,472,'Sale Id shift 249723',620800.95,0.00,0.00,0.00,0.00,'2021-12-30 10:51:44','',''),(2402911,'1','206',NULL,473,'Sale Id shift 249723',5499.30,0.00,0.00,0.00,0.00,'2021-12-30 10:51:44','',''),(2404048,'1','206','1030',472,'Sale Id shift 249955',0.00,0.00,0.00,1571.36,0.00,'2021-12-30 13:16:33','',''),(2404049,'1','206','1030',472,'Sale Id shift 249955',0.00,0.00,0.00,481.55,0.00,'2021-12-30 13:16:33','',''),(2404050,'1','206','1030',472,'Sale Id shift 249955',0.00,0.00,0.00,1509.30,0.00,'2021-12-30 13:16:33','',''),(2404051,'1','206','1030',472,'Sale Id shift 249955',0.00,0.00,0.00,51.67,0.00,'2021-12-30 13:16:33','',''),(2404052,'1','206','1030',472,'Sale Id shift 249955',0.00,0.00,0.00,1069.92,0.00,'2021-12-30 13:16:33','',''),(2404053,'1','206','1030',472,'Sale Id shift 249955',0.00,0.00,0.00,244.41,0.00,'2021-12-30 13:16:33','',''),(2404054,'1','206','1031',473,'Sale Id shift 249955',0.00,0.00,0.00,209.18,0.00,'2021-12-30 13:16:33','',''),(2404055,'1','206',NULL,472,'Sale Id shift 249955',813154.65,0.00,0.00,0.00,0.00,'2021-12-30 13:16:33','',''),(2404056,'1','206',NULL,473,'Sale Id shift 249955',72167.10,0.00,0.00,0.00,0.00,'2021-12-30 13:16:33','',''),(2407955,'1','206','1030',472,'Sale Id shift 249989',0.00,0.00,0.00,1307.43,0.00,'2021-12-31 07:29:38','',''),(2407956,'1','206','1030',472,'Sale Id shift 249989',0.00,0.00,0.00,647.25,0.00,'2021-12-31 07:29:38','',''),(2407957,'1','206','1030',472,'Sale Id shift 249989',0.00,0.00,0.00,1532.88,0.00,'2021-12-31 07:29:38','',''),(2407958,'1','206','1030',472,'Sale Id shift 249989',0.00,0.00,0.00,240.85,0.00,'2021-12-31 07:29:38','',''),(2407959,'1','206','1030',472,'Sale Id shift 249989',0.00,0.00,0.00,6.94,0.00,'2021-12-31 07:29:38','',''),(2407960,'1','206','1030',472,'Sale Id shift 249989',0.00,0.00,0.00,480.38,0.00,'2021-12-31 07:29:38','',''),(2407961,'1','206','1030',472,'Sale Id shift 249989',0.00,0.00,0.00,1655.71,0.00,'2021-12-31 07:29:38','',''),(2407962,'1','206','1031',473,'Sale Id shift 249989',0.00,0.00,0.00,102.90,0.00,'2021-12-31 07:29:38','',''),(2407963,'1','206',NULL,472,'Sale Id shift 249989',968787.60,0.00,0.00,0.00,0.00,'2021-12-31 07:29:38','',''),(2407964,'1','206',NULL,473,'Sale Id shift 249989',35500.50,0.00,0.00,0.00,0.00,'2021-12-31 07:29:38','',''),(2409865,'1','206','1030',472,'Sale Id shift 250186',0.00,0.00,0.00,1154.08,0.00,'2021-12-31 10:28:56','',''),(2409866,'1','206','1030',472,'Sale Id shift 250186',0.00,0.00,0.00,1129.88,0.00,'2021-12-31 10:28:56','',''),(2409867,'1','206','1030',472,'Sale Id shift 250186',0.00,0.00,0.00,1605.89,0.00,'2021-12-31 10:28:56','',''),(2409868,'1','206','1030',472,'Sale Id shift 250186',0.00,0.00,0.00,250.41,0.00,'2021-12-31 10:28:56','',''),(2409869,'1','206','1030',472,'Sale Id shift 250186',0.00,0.00,0.00,6.44,0.00,'2021-12-31 10:28:56','',''),(2409870,'1','206','1030',472,'Sale Id shift 250186',0.00,0.00,0.00,541.14,0.00,'2021-12-31 10:28:56','',''),(2409871,'1','206','1030',472,'Sale Id shift 250186',0.00,0.00,0.00,457.83,0.00,'2021-12-31 10:28:56','',''),(2409872,'1','206','1030',472,'Sale Id shift 250186',0.00,0.00,0.00,245.81,0.00,'2021-12-31 10:28:56','',''),(2409873,'1','206','1031',473,'Sale Id shift 250186',0.00,0.00,0.00,170.29,0.00,'2021-12-31 10:28:56','',''),(2409874,'1','206',NULL,472,'Sale Id shift 250186',889594.20,0.00,0.00,0.00,0.00,'2021-12-31 10:28:56','',''),(2409875,'1','206',NULL,473,'Sale Id shift 250186',58750.05,0.00,0.00,0.00,0.00,'2021-12-31 10:28:56','',''),(2411846,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,3465000.00,21000.00,0.00,0.00,'2021-12-31 14:19:11','',''),(2412692,'1','206',NULL,472,'Reception corrector for bridging 129320',0.00,0.00,0.00,21000.00,0.00,'2021-12-31 15:32:27','',''),(2412693,'1','206','1030',472,'Received from bridging 129320',0.00,0.00,21000.00,0.00,0.00,'2021-12-31 15:32:27','',''),(2413987,'1','206','1030',472,'Sale Id shift 250235',0.00,0.00,0.00,998.23,0.00,'2021-12-31 17:55:10','',''),(2413988,'1','206','1030',472,'Sale Id shift 250235',0.00,0.00,0.00,645.41,0.00,'2021-12-31 17:55:10','',''),(2413989,'1','206','1030',472,'Sale Id shift 250235',0.00,0.00,0.00,762.94,0.00,'2021-12-31 17:55:10','',''),(2413990,'1','206','1030',472,'Sale Id shift 250235',0.00,0.00,0.00,58.39,0.00,'2021-12-31 17:55:10','',''),(2413991,'1','206','1030',472,'Sale Id shift 250235',0.00,0.00,0.00,665.61,0.00,'2021-12-31 17:55:10','',''),(2413992,'1','206','1031',473,'Sale Id shift 250235',0.00,0.00,0.00,155.94,0.00,'2021-12-31 17:55:10','',''),(2413993,'1','206',NULL,472,'Sale Id shift 250235',516545.70,0.00,0.00,0.00,0.00,'2021-12-31 17:55:10','',''),(2413994,'1','206',NULL,473,'Sale Id shift 250235',53799.30,0.00,0.00,0.00,0.00,'2021-12-31 17:55:10','',''),(2419540,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,4785000.00,29000.00,0.00,0.00,'2022-01-01 16:00:56','',''),(2419828,'1','206','1030',472,'Sale Id shift 250409',0.00,0.00,0.00,849.53,0.00,'2022-01-01 16:30:33','',''),(2419829,'1','206','1030',472,'Sale Id shift 250409',0.00,0.00,0.00,1156.96,0.00,'2022-01-01 16:30:33','',''),(2419830,'1','206','1030',472,'Sale Id shift 250409',0.00,0.00,0.00,2116.37,0.00,'2022-01-01 16:30:33','',''),(2419831,'1','206','1030',472,'Sale Id shift 250409',0.00,0.00,0.00,295.51,0.00,'2022-01-01 16:30:33','',''),(2419832,'1','206','1030',472,'Sale Id shift 250409',0.00,0.00,0.00,458.43,0.00,'2022-01-01 16:30:33','',''),(2419833,'1','206','1030',472,'Sale Id shift 250409',0.00,0.00,0.00,1882.91,0.00,'2022-01-01 16:30:33','',''),(2419834,'1','206','1030',472,'Sale Id shift 250409',0.00,0.00,0.00,525.97,0.00,'2022-01-01 16:30:33','',''),(2419835,'1','206','1030',472,'Sale Id shift 250409',0.00,0.00,0.00,212.78,0.00,'2022-01-01 16:30:33','',''),(2419836,'1','206','1031',473,'Sale Id shift 250409',0.00,0.00,0.00,106.82,0.00,'2022-01-01 16:30:33','',''),(2419837,'1','206',NULL,472,'Sale Id shift 250409',1237245.90,0.00,0.00,0.00,0.00,'2022-01-01 16:30:33','',''),(2419838,'1','206',NULL,473,'Sale Id shift 250409',36852.90,0.00,0.00,0.00,0.00,'2022-01-01 16:30:33','',''),(2421451,'1','206','1030',472,'Sale Id shift 250506',0.00,0.00,0.00,366.13,0.00,'2022-01-02 08:10:18','',''),(2421452,'1','206','1030',472,'Sale Id shift 250506',0.00,0.00,0.00,809.20,0.00,'2022-01-02 08:10:18','',''),(2421453,'1','206','1030',472,'Sale Id shift 250506',0.00,0.00,0.00,575.74,0.00,'2022-01-02 08:10:18','',''),(2421454,'1','206','1030',472,'Sale Id shift 250506',0.00,0.00,0.00,89.46,0.00,'2022-01-02 08:10:18','',''),(2421455,'1','206','1030',472,'Sale Id shift 250506',0.00,0.00,0.00,518.96,0.00,'2022-01-02 08:10:18','',''),(2421456,'1','206','1031',473,'Sale Id shift 250506',0.00,0.00,0.00,14.49,0.00,'2022-01-02 08:10:18','',''),(2421457,'1','206',NULL,472,'Sale Id shift 250506',389315.85,0.00,0.00,0.00,0.00,'2022-01-02 08:10:18','',''),(2421458,'1','206',NULL,473,'Sale Id shift 250506',4999.05,0.00,0.00,0.00,0.00,'2022-01-02 08:10:18','',''),(2424965,'1','206','1030',472,'Sale Id shift 250646',0.00,0.00,0.00,430.08,0.00,'2022-01-02 14:59:56','',''),(2424966,'1','206','1030',472,'Sale Id shift 250646',0.00,0.00,0.00,587.90,0.00,'2022-01-02 14:59:56','',''),(2424967,'1','206','1030',472,'Sale Id shift 250646',0.00,0.00,0.00,560.20,0.00,'2022-01-02 14:59:56','',''),(2424968,'1','206','1030',472,'Sale Id shift 250646',0.00,0.00,0.00,288.05,0.00,'2022-01-02 14:59:56','',''),(2424969,'1','206','1030',472,'Sale Id shift 250646',0.00,0.00,0.00,713.67,0.00,'2022-01-02 14:59:56','',''),(2424970,'1','206','1030',472,'Sale Id shift 250646',0.00,0.00,0.00,83.59,0.00,'2022-01-02 14:59:56','',''),(2424971,'1','206','1031',473,'Sale Id shift 250646',0.00,0.00,0.00,28.98,0.00,'2022-01-02 14:59:56','',''),(2424972,'1','206',NULL,472,'Sale Id shift 250646',439475.85,0.00,0.00,0.00,0.00,'2022-01-02 14:59:56','',''),(2424973,'1','206',NULL,473,'Sale Id shift 250646',9998.10,0.00,0.00,0.00,0.00,'2022-01-02 14:59:56','',''),(2427027,'1','206','1030',472,'Sale Id shift 250747',0.00,0.00,0.00,529.66,0.00,'2022-01-03 07:59:05','',''),(2427028,'1','206','1030',472,'Sale Id shift 250747',0.00,0.00,0.00,547.84,0.00,'2022-01-03 07:59:05','',''),(2427029,'1','206','1030',472,'Sale Id shift 250747',0.00,0.00,0.00,766.48,0.00,'2022-01-03 07:59:05','',''),(2427030,'1','206','1030',472,'Sale Id shift 250747',0.00,0.00,0.00,135.51,0.00,'2022-01-03 07:59:05','',''),(2427031,'1','206','1030',472,'Sale Id shift 250747',0.00,0.00,0.00,355.51,0.00,'2022-01-03 07:59:05','',''),(2427032,'1','206','1030',472,'Sale Id shift 250747',0.00,0.00,0.00,438.05,0.00,'2022-01-03 07:59:05','',''),(2427033,'1','206','1031',473,'Sale Id shift 250747',0.00,0.00,0.00,42.03,0.00,'2022-01-03 07:59:05','',''),(2427034,'1','206',NULL,472,'Sale Id shift 250747',457553.25,0.00,0.00,0.00,0.00,'2022-01-03 07:59:05','',''),(2427035,'1','206',NULL,473,'Sale Id shift 250747',14500.35,0.00,0.00,0.00,0.00,'2022-01-03 07:59:05','',''),(2428244,'1','206',NULL,472,'Reception corrector for bridging 129531',0.00,0.00,0.00,28400.00,0.00,'2022-01-03 10:20:49','',''),(2428245,'1','206','1030',472,'Received from bridging 129531',0.00,0.00,28400.00,0.00,0.00,'2022-01-03 10:20:49','',''),(2431195,'1','206','1030',472,'Sale Id shift 250876',0.00,0.00,0.00,692.61,0.00,'2022-01-03 15:21:29','',''),(2431196,'1','206','1030',472,'Sale Id shift 250876',0.00,0.00,0.00,528.02,0.00,'2022-01-03 15:21:29','',''),(2431197,'1','206','1030',472,'Sale Id shift 250876',0.00,0.00,0.00,681.54,0.00,'2022-01-03 15:21:29','',''),(2431198,'1','206','1030',472,'Sale Id shift 250876',0.00,0.00,0.00,303.41,0.00,'2022-01-03 15:21:29','',''),(2431199,'1','206','1030',472,'Sale Id shift 250876',0.00,0.00,0.00,82.38,0.00,'2022-01-03 15:21:29','',''),(2431200,'1','206','1030',472,'Sale Id shift 250876',0.00,0.00,0.00,676.59,0.00,'2022-01-03 15:21:29','',''),(2431201,'1','206','1031',473,'Sale Id shift 250876',0.00,0.00,0.00,118.55,0.00,'2022-01-03 15:21:29','',''),(2431202,'1','206',NULL,472,'Sale Id shift 250876',489150.75,0.00,0.00,0.00,0.00,'2022-01-03 15:21:29','',''),(2431203,'1','206',NULL,473,'Sale Id shift 250876',40899.75,0.00,0.00,0.00,0.00,'2022-01-03 15:21:29','',''),(2434773,'1','206','1030',472,'Sale Id shift 250971',0.00,0.00,0.00,530.03,0.00,'2022-01-04 09:34:19','',''),(2434774,'1','206','1030',472,'Sale Id shift 250971',0.00,0.00,0.00,887.87,0.00,'2022-01-04 09:34:19','',''),(2434775,'1','206','1030',472,'Sale Id shift 250971',0.00,0.00,0.00,1204.29,0.00,'2022-01-04 09:34:19','',''),(2434776,'1','206','1030',472,'Sale Id shift 250971',0.00,0.00,0.00,35.03,0.00,'2022-01-04 09:34:19','',''),(2434777,'1','206','1030',472,'Sale Id shift 250971',0.00,0.00,0.00,1384.83,0.00,'2022-01-04 09:34:19','',''),(2434778,'1','206','1030',472,'Sale Id shift 250971',0.00,0.00,0.00,18.18,0.00,'2022-01-04 09:34:19','',''),(2434779,'1','206','1031',473,'Sale Id shift 250971',0.00,0.00,0.00,14.20,0.00,'2022-01-04 09:34:19','',''),(2434780,'1','206',NULL,472,'Sale Id shift 250971',669937.95,0.00,0.00,0.00,0.00,'2022-01-04 09:34:19','',''),(2434781,'1','206',NULL,473,'Sale Id shift 250971',4899.00,0.00,0.00,0.00,0.00,'2022-01-04 09:34:19','',''),(2435233,'1','206','1030',0,'Tank level zero out for dipping',0.00,0.00,0.00,28700.82,0.00,'2022-01-04 10:18:41','',''),(2435234,'1','206','1030',0,'Inventory adjustment from tank dipping to 73701',0.00,0.00,73701.00,0.00,0.00,'2022-01-04 10:18:41','',''),(2435237,'1','206','1030',472,'Returned bridging 127030',0.00,0.00,0.00,45000.00,0.00,'2022-01-04 10:18:56','',''),(2435238,'1','206',NULL,472,'Reception Return corrector for bridging 127030',0.00,0.00,45000.00,0.00,0.00,'2022-01-04 10:18:56','',''),(2435260,'1','206',NULL,472,'Inventory reconciliation by NASIR  ABDULRASHEED',0.00,0.00,45001.00,1.00,0.00,'2022-01-04 10:21:11','',''),(2435263,'1','206',NULL,472,'Returned purchase #86908 to AA RANO NIGERIA LTD',6525000.00,0.00,0.00,45000.00,0.00,'2022-01-04 10:21:24','',''),(2440019,'1','206','1030',472,'Sale Id shift 251106',0.00,0.00,0.00,1016.49,0.00,'2022-01-04 19:29:13','',''),(2440020,'1','206','1030',472,'Sale Id shift 251106',0.00,0.00,0.00,1658.42,0.00,'2022-01-04 19:29:13','',''),(2440021,'1','206','1030',472,'Sale Id shift 251106',0.00,0.00,0.00,1810.68,0.00,'2022-01-04 19:29:13','',''),(2440022,'1','206','1030',472,'Sale Id shift 251106',0.00,0.00,0.00,6.06,0.00,'2022-01-04 19:29:13','',''),(2440023,'1','206','1030',472,'Sale Id shift 251106',0.00,0.00,0.00,673.58,0.00,'2022-01-04 19:29:13','',''),(2440024,'1','206','1030',472,'Sale Id shift 251106',0.00,0.00,0.00,1651.99,0.00,'2022-01-04 19:29:13','',''),(2440025,'1','206','1030',472,'Sale Id shift 251106',0.00,0.00,0.00,468.95,0.00,'2022-01-04 19:29:13','',''),(2440026,'1','206','1031',473,'Sale Id shift 251106',0.00,0.00,0.00,67.68,0.00,'2022-01-04 19:29:13','',''),(2440027,'1','206',NULL,472,'Sale Id shift 251106',1202218.05,0.00,0.00,0.00,0.00,'2022-01-04 19:29:13','',''),(2440028,'1','206',NULL,473,'Sale Id shift 251106',23349.60,0.00,0.00,0.00,0.00,'2022-01-04 19:29:13','',''),(2440030,'1','206','1030',472,'Sale Id shift 251228',0.00,0.00,0.00,665.27,0.00,'2022-01-04 19:35:38','',''),(2440031,'1','206','1030',472,'Sale Id shift 251228',0.00,0.00,0.00,1130.48,0.00,'2022-01-04 19:35:38','',''),(2440032,'1','206','1030',472,'Sale Id shift 251228',0.00,0.00,0.00,971.29,0.00,'2022-01-04 19:35:38','',''),(2440033,'1','206','1030',472,'Sale Id shift 251228',0.00,0.00,0.00,139.37,0.00,'2022-01-04 19:35:38','',''),(2440034,'1','206','1030',472,'Sale Id shift 251228',0.00,0.00,0.00,1212.06,0.00,'2022-01-04 19:35:38','',''),(2440035,'1','206','1031',473,'Sale Id shift 251228',0.00,0.00,0.00,102.32,0.00,'2022-01-04 19:35:38','',''),(2440036,'1','206',NULL,472,'Sale Id shift 251228',679547.55,0.00,0.00,0.00,0.00,'2022-01-04 19:35:38','',''),(2440037,'1','206',NULL,473,'Sale Id shift 251228',35300.40,0.00,0.00,0.00,0.00,'2022-01-04 19:35:38','',''),(2442641,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-01-05 11:02:54','',''),(2442667,'1','206','1030',472,'Sale Id shift 251229',0.00,0.00,0.00,564.87,0.00,'2022-01-05 11:05:47','',''),(2442668,'1','206','1030',472,'Sale Id shift 251229',0.00,0.00,0.00,1278.32,0.00,'2022-01-05 11:05:47','',''),(2442669,'1','206','1030',472,'Sale Id shift 251229',0.00,0.00,0.00,1300.42,0.00,'2022-01-05 11:05:47','',''),(2442670,'1','206','1030',472,'Sale Id shift 251229',0.00,0.00,0.00,198.42,0.00,'2022-01-05 11:05:47','',''),(2442671,'1','206','1030',472,'Sale Id shift 251229',0.00,0.00,0.00,52.71,0.00,'2022-01-05 11:05:47','',''),(2442672,'1','206','1030',472,'Sale Id shift 251229',0.00,0.00,0.00,1164.32,0.00,'2022-01-05 11:05:47','',''),(2442673,'1','206','1031',473,'Sale Id shift 251229',0.00,0.00,0.00,169.51,0.00,'2022-01-05 11:05:47','',''),(2442674,'1','206',NULL,472,'Sale Id shift 251229',752244.90,0.00,0.00,0.00,0.00,'2022-01-05 11:05:47','',''),(2442675,'1','206',NULL,473,'Sale Id shift 251229',58480.95,0.00,0.00,0.00,0.00,'2022-01-05 11:05:47','',''),(2444585,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,3300000.00,20000.00,0.00,0.00,'2022-01-05 14:07:34','',''),(2445002,'1','206',NULL,472,'Reception corrector for bridging 129851',0.00,0.00,0.00,20000.00,0.00,'2022-01-05 14:52:49','',''),(2445003,'1','206','1030',472,'Received from bridging 129851',0.00,0.00,20000.00,0.00,0.00,'2022-01-05 14:52:49','',''),(2445315,'1','206','1030',472,'Sale Id shift 251376',0.00,0.00,0.00,349.37,0.00,'2022-01-05 15:18:58','',''),(2445316,'1','206','1030',472,'Sale Id shift 251376',0.00,0.00,0.00,1094.28,0.00,'2022-01-05 15:18:58','',''),(2445317,'1','206','1030',472,'Sale Id shift 251376',0.00,0.00,0.00,878.71,0.00,'2022-01-05 15:18:58','',''),(2445318,'1','206','1030',472,'Sale Id shift 251376',0.00,0.00,0.00,215.44,0.00,'2022-01-05 15:18:58','',''),(2445319,'1','206','1030',472,'Sale Id shift 251376',0.00,0.00,0.00,64.52,0.00,'2022-01-05 15:18:58','',''),(2445320,'1','206','1030',472,'Sale Id shift 251376',0.00,0.00,0.00,106.15,0.00,'2022-01-05 15:18:58','',''),(2445321,'1','206','1030',472,'Sale Id shift 251376',0.00,0.00,0.00,477.63,0.00,'2022-01-05 15:18:58','',''),(2445322,'1','206','1031',473,'Sale Id shift 251376',0.00,0.00,0.00,18.55,0.00,'2022-01-05 15:18:58','',''),(2445323,'1','206',NULL,472,'Sale Id shift 251376',525706.50,0.00,0.00,0.00,0.00,'2022-01-05 15:18:58','',''),(2445324,'1','206',NULL,473,'Sale Id shift 251376',6399.75,0.00,0.00,0.00,0.00,'2022-01-05 15:18:58','',''),(2450081,'1','206','1030',472,'Sale Id shift 251461',0.00,0.00,0.00,762.59,0.00,'2022-01-06 10:27:10','',''),(2450082,'1','206','1030',472,'Sale Id shift 251461',0.00,0.00,0.00,897.81,0.00,'2022-01-06 10:27:10','',''),(2450083,'1','206','1030',472,'Sale Id shift 251461',0.00,0.00,0.00,1102.35,0.00,'2022-01-06 10:27:10','',''),(2450084,'1','206','1030',472,'Sale Id shift 251461',0.00,0.00,0.00,335.71,0.00,'2022-01-06 10:27:10','',''),(2450085,'1','206','1030',472,'Sale Id shift 251461',0.00,0.00,0.00,56.96,0.00,'2022-01-06 10:27:10','',''),(2450086,'1','206','1030',472,'Sale Id shift 251461',0.00,0.00,0.00,900.02,0.00,'2022-01-06 10:27:10','',''),(2450087,'1','206','1030',472,'Sale Id shift 251461',0.00,0.00,0.00,172.58,0.00,'2022-01-06 10:27:10','',''),(2450088,'1','206','1031',473,'Sale Id shift 251461',0.00,0.00,0.00,4.35,0.00,'2022-01-06 10:27:10','',''),(2450089,'1','206',NULL,472,'Sale Id shift 251461',697623.30,0.00,0.00,0.00,0.00,'2022-01-06 10:27:10','',''),(2450090,'1','206',NULL,473,'Sale Id shift 251461',1500.75,0.00,0.00,0.00,0.00,'2022-01-06 10:27:10','',''),(2452821,'1','206','1030',472,'Sale Id shift 251615',0.00,0.00,0.00,794.39,0.00,'2022-01-06 15:01:22','',''),(2452822,'1','206','1030',472,'Sale Id shift 251615',0.00,0.00,0.00,658.16,0.00,'2022-01-06 15:01:22','',''),(2452823,'1','206','1030',472,'Sale Id shift 251615',0.00,0.00,0.00,1270.20,0.00,'2022-01-06 15:01:22','',''),(2452824,'1','206','1030',472,'Sale Id shift 251615',0.00,0.00,0.00,126.06,0.00,'2022-01-06 15:01:22','',''),(2452825,'1','206','1030',472,'Sale Id shift 251615',0.00,0.00,0.00,103.93,0.00,'2022-01-06 15:01:22','',''),(2452826,'1','206','1030',472,'Sale Id shift 251615',0.00,0.00,0.00,945.44,0.00,'2022-01-06 15:01:22','',''),(2452827,'1','206','1030',472,'Sale Id shift 251615',0.00,0.00,0.00,479.30,0.00,'2022-01-06 15:01:22','',''),(2452828,'1','206','1031',473,'Sale Id shift 251615',0.00,0.00,0.00,171.70,0.00,'2022-01-06 15:01:22','',''),(2452829,'1','206',NULL,472,'Sale Id shift 251615',722284.20,0.00,0.00,0.00,0.00,'2022-01-06 15:01:22','',''),(2452830,'1','206',NULL,473,'Sale Id shift 251615',59236.50,0.00,0.00,0.00,0.00,'2022-01-06 15:01:22','',''),(2455424,'1','206',NULL,472,'Reception corrector for bridging 130029',0.00,0.00,0.00,45000.00,0.00,'2022-01-06 21:13:56','',''),(2455425,'1','206','1030',472,'Received from bridging 130029',0.00,0.00,45000.00,0.00,0.00,'2022-01-06 21:13:56','',''),(2458158,'1','206','1030',472,'Sale Id shift 251679',0.00,0.00,0.00,858.78,0.00,'2022-01-07 11:07:18','',''),(2458159,'1','206','1030',472,'Sale Id shift 251679',0.00,0.00,0.00,1764.84,0.00,'2022-01-07 11:07:18','',''),(2458160,'1','206','1030',472,'Sale Id shift 251679',0.00,0.00,0.00,2102.15,0.00,'2022-01-07 11:07:18','',''),(2458161,'1','206','1030',472,'Sale Id shift 251679',0.00,0.00,0.00,342.04,0.00,'2022-01-07 11:07:18','',''),(2458162,'1','206','1030',472,'Sale Id shift 251679',0.00,0.00,0.00,67.97,0.00,'2022-01-07 11:07:18','',''),(2458163,'1','206','1030',472,'Sale Id shift 251679',0.00,0.00,0.00,613.22,0.00,'2022-01-07 11:07:18','',''),(2458164,'1','206','1030',472,'Sale Id shift 251679',0.00,0.00,0.00,1832.96,0.00,'2022-01-07 11:07:18','',''),(2458165,'1','206','1031',473,'Sale Id shift 251679',0.00,0.00,0.00,475.67,0.00,'2022-01-07 11:07:18','',''),(2458166,'1','206',NULL,472,'Sale Id shift 251679',1251023.40,0.00,0.00,0.00,0.00,'2022-01-07 11:07:18','',''),(2458167,'1','206',NULL,473,'Sale Id shift 251679',164106.15,0.00,0.00,0.00,0.00,'2022-01-07 11:07:18','',''),(2460373,'1','206','1030',472,'Sale Id shift 251842',0.00,0.00,0.00,379.92,0.00,'2022-01-07 15:19:44','',''),(2460374,'1','206','1030',472,'Sale Id shift 251842',0.00,0.00,0.00,774.07,0.00,'2022-01-07 15:19:44','',''),(2460375,'1','206','1030',472,'Sale Id shift 251842',0.00,0.00,0.00,765.53,0.00,'2022-01-07 15:19:44','',''),(2460376,'1','206','1030',472,'Sale Id shift 251842',0.00,0.00,0.00,254.86,0.00,'2022-01-07 15:19:44','',''),(2460377,'1','206','1030',472,'Sale Id shift 251842',0.00,0.00,0.00,878.36,0.00,'2022-01-07 15:19:44','',''),(2460378,'1','206','1030',472,'Sale Id shift 251842',0.00,0.00,0.00,12.12,0.00,'2022-01-07 15:19:44','',''),(2460379,'1','206','1031',473,'Sale Id shift 251842',0.00,0.00,0.00,61.02,0.00,'2022-01-07 15:19:44','',''),(2460380,'1','206',NULL,472,'Sale Id shift 251842',505701.90,0.00,0.00,0.00,0.00,'2022-01-07 15:19:44','',''),(2460381,'1','206',NULL,473,'Sale Id shift 251842',21051.90,0.00,0.00,0.00,0.00,'2022-01-07 15:19:44','',''),(2460382,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,3300000.00,20000.00,0.00,0.00,'2022-01-07 15:19:54','',''),(2466097,'1','206','1030',472,'Sale Id shift 251958',0.00,0.00,0.00,1277.50,0.00,'2022-01-08 11:58:37','',''),(2466098,'1','206','1030',472,'Sale Id shift 251958',0.00,0.00,0.00,707.53,0.00,'2022-01-08 11:58:37','',''),(2466099,'1','206','1030',472,'Sale Id shift 251958',0.00,0.00,0.00,1157.98,0.00,'2022-01-08 11:58:37','',''),(2466100,'1','206','1030',472,'Sale Id shift 251958',0.00,0.00,0.00,128.11,0.00,'2022-01-08 11:58:37','',''),(2466101,'1','206','1030',472,'Sale Id shift 251958',0.00,0.00,0.00,18.90,0.00,'2022-01-08 11:58:37','',''),(2466102,'1','206','1030',472,'Sale Id shift 251958',0.00,0.00,0.00,929.28,0.00,'2022-01-08 11:58:37','',''),(2466103,'1','206','1030',472,'Sale Id shift 251958',0.00,0.00,0.00,189.54,0.00,'2022-01-08 11:58:37','',''),(2466104,'1','206','1031',473,'Sale Id shift 251958',0.00,0.00,0.00,82.62,0.00,'2022-01-08 11:58:37','',''),(2466105,'1','206',NULL,472,'Sale Id shift 251958',727458.60,0.00,0.00,0.00,0.00,'2022-01-08 11:58:37','',''),(2466106,'1','206',NULL,473,'Sale Id shift 251958',28503.90,0.00,0.00,0.00,0.00,'2022-01-08 11:58:37','',''),(2473624,'1','206','1030',472,'Sale Id shift 252109',0.00,0.00,0.00,784.91,0.00,'2022-01-09 10:51:38','',''),(2473625,'1','206','1030',472,'Sale Id shift 252109',0.00,0.00,0.00,540.51,0.00,'2022-01-09 10:51:38','',''),(2473626,'1','206','1030',472,'Sale Id shift 252109',0.00,0.00,0.00,739.47,0.00,'2022-01-09 10:51:38','',''),(2473627,'1','206','1030',472,'Sale Id shift 252109',0.00,0.00,0.00,225.77,0.00,'2022-01-09 10:51:38','',''),(2473628,'1','206','1030',472,'Sale Id shift 252109',0.00,0.00,0.00,684.39,0.00,'2022-01-09 10:51:38','',''),(2473629,'1','206','1030',472,'Sale Id shift 252109',0.00,0.00,0.00,476.17,0.00,'2022-01-09 10:51:38','',''),(2473630,'1','206','1031',473,'Sale Id shift 252109',0.00,0.00,0.00,15.94,0.00,'2022-01-09 10:51:38','',''),(2473631,'1','206',NULL,472,'Sale Id shift 252109',569451.30,0.00,0.00,0.00,0.00,'2022-01-09 10:51:38','',''),(2473632,'1','206',NULL,473,'Sale Id shift 252109',5499.30,0.00,0.00,0.00,0.00,'2022-01-09 10:51:38','',''),(2478607,'1','206','1030',472,'Sale Id shift 252309',0.00,0.00,0.00,484.95,0.00,'2022-01-09 18:22:26','',''),(2478608,'1','206','1030',472,'Sale Id shift 252309',0.00,0.00,0.00,1145.30,0.00,'2022-01-09 18:22:26','',''),(2478609,'1','206','1030',472,'Sale Id shift 252309',0.00,0.00,0.00,994.08,0.00,'2022-01-09 18:22:26','',''),(2478610,'1','206','1030',472,'Sale Id shift 252309',0.00,0.00,0.00,282.83,0.00,'2022-01-09 18:22:26','',''),(2478611,'1','206','1030',472,'Sale Id shift 252309',0.00,0.00,0.00,468.31,0.00,'2022-01-09 18:22:26','',''),(2478612,'1','206','1030',472,'Sale Id shift 252309',0.00,0.00,0.00,722.23,0.00,'2022-01-09 18:22:26','',''),(2478613,'1','206','1030',472,'Sale Id shift 252309',0.00,0.00,0.00,256.45,0.00,'2022-01-09 18:22:26','',''),(2478614,'1','206','1031',473,'Sale Id shift 252309',0.00,0.00,0.00,101.75,0.00,'2022-01-09 18:22:26','',''),(2478615,'1','206',NULL,472,'Sale Id shift 252309',718434.75,0.00,0.00,0.00,0.00,'2022-01-09 18:22:26','',''),(2478616,'1','206',NULL,473,'Sale Id shift 252309',35103.75,0.00,0.00,0.00,0.00,'2022-01-09 18:22:26','',''),(2479088,'1','206','1030',472,'Sale Id shift 252416',0.00,0.00,0.00,699.95,0.00,'2022-01-09 21:13:44','',''),(2479089,'1','206','1030',472,'Sale Id shift 252416',0.00,0.00,0.00,448.20,0.00,'2022-01-09 21:13:44','',''),(2479090,'1','206','1030',472,'Sale Id shift 252416',0.00,0.00,0.00,642.11,0.00,'2022-01-09 21:13:44','',''),(2479091,'1','206','1030',472,'Sale Id shift 252416',0.00,0.00,0.00,94.22,0.00,'2022-01-09 21:13:44','',''),(2479092,'1','206','1030',472,'Sale Id shift 252416',0.00,0.00,0.00,716.83,0.00,'2022-01-09 21:13:44','',''),(2479093,'1','206','1031',473,'Sale Id shift 252416',0.00,0.00,0.00,26.09,0.00,'2022-01-09 21:13:44','',''),(2479094,'1','206',NULL,472,'Sale Id shift 252416',429216.15,0.00,0.00,0.00,0.00,'2022-01-09 21:13:44','',''),(2479095,'1','206',NULL,473,'Sale Id shift 252416',9001.05,0.00,0.00,0.00,0.00,'2022-01-09 21:13:44','',''),(2482187,'1','206','1030',472,'Sale Id shift 252432',0.00,0.00,0.00,661.89,0.00,'2022-01-10 12:20:40','',''),(2482188,'1','206','1030',472,'Sale Id shift 252432',0.00,0.00,0.00,881.13,0.00,'2022-01-10 12:20:40','',''),(2482189,'1','206','1030',472,'Sale Id shift 252432',0.00,0.00,0.00,886.82,0.00,'2022-01-10 12:20:40','',''),(2482190,'1','206','1030',472,'Sale Id shift 252432',0.00,0.00,0.00,204.00,0.00,'2022-01-10 12:20:40','',''),(2482191,'1','206','1030',472,'Sale Id shift 252432',0.00,0.00,0.00,76.96,0.00,'2022-01-10 12:20:40','',''),(2482192,'1','206','1030',472,'Sale Id shift 252432',0.00,0.00,0.00,1220.46,0.00,'2022-01-10 12:20:40','',''),(2482193,'1','206','1031',473,'Sale Id shift 252432',0.00,0.00,0.00,23.76,0.00,'2022-01-10 12:20:40','',''),(2482194,'1','206',NULL,472,'Sale Id shift 252432',648657.90,0.00,0.00,0.00,0.00,'2022-01-10 12:20:40','',''),(2482195,'1','206',NULL,473,'Sale Id shift 252432',8197.20,0.00,0.00,0.00,0.00,'2022-01-10 12:20:40','',''),(2484525,'1','206','1030',472,'Sale Id shift 252601',0.00,0.00,0.00,381.68,0.00,'2022-01-10 16:45:39','',''),(2484526,'1','206','1030',472,'Sale Id shift 252601',0.00,0.00,0.00,638.71,0.00,'2022-01-10 16:45:39','',''),(2484527,'1','206','1030',472,'Sale Id shift 252601',0.00,0.00,0.00,696.53,0.00,'2022-01-10 16:45:39','',''),(2484528,'1','206','1030',472,'Sale Id shift 252601',0.00,0.00,0.00,30.30,0.00,'2022-01-10 16:45:39','',''),(2484529,'1','206','1030',472,'Sale Id shift 252601',0.00,0.00,0.00,922.48,0.00,'2022-01-10 16:45:39','',''),(2484530,'1','206','1030',472,'Sale Id shift 252601',0.00,0.00,0.00,33.94,0.00,'2022-01-10 16:45:39','',''),(2484531,'1','206','1031',473,'Sale Id shift 252601',0.00,0.00,0.00,55.65,0.00,'2022-01-10 16:45:39','',''),(2484532,'1','206',NULL,472,'Sale Id shift 252601',446100.60,0.00,0.00,0.00,0.00,'2022-01-10 16:45:40','',''),(2484533,'1','206',NULL,473,'Sale Id shift 252601',19199.25,0.00,0.00,0.00,0.00,'2022-01-10 16:45:40','',''),(2489110,'1','206','1030',472,'Sale Id shift 252666',0.00,0.00,0.00,531.92,0.00,'2022-01-11 11:43:30','',''),(2489111,'1','206','1030',472,'Sale Id shift 252666',0.00,0.00,0.00,718.55,0.00,'2022-01-11 11:43:30','',''),(2489112,'1','206','1030',472,'Sale Id shift 252666',0.00,0.00,0.00,853.54,0.00,'2022-01-11 11:43:30','',''),(2489113,'1','206','1030',472,'Sale Id shift 252666',0.00,0.00,0.00,14.24,0.00,'2022-01-11 11:43:30','',''),(2489114,'1','206','1030',472,'Sale Id shift 252666',0.00,0.00,0.00,467.31,0.00,'2022-01-11 11:43:30','',''),(2489115,'1','206','1030',472,'Sale Id shift 252666',0.00,0.00,0.00,524.48,0.00,'2022-01-11 11:43:30','',''),(2489116,'1','206','1031',473,'Sale Id shift 252666',0.00,0.00,0.00,0.87,0.00,'2022-01-11 11:43:30','',''),(2489117,'1','206',NULL,472,'Sale Id shift 252666',513156.60,0.00,0.00,0.00,0.00,'2022-01-11 11:43:30','',''),(2489118,'1','206',NULL,473,'Sale Id shift 252666',300.15,0.00,0.00,0.00,0.00,'2022-01-11 11:43:30','',''),(2489764,'1','206',NULL,472,'Reception corrector for bridging 130096',0.00,0.00,0.00,20000.00,0.00,'2022-01-11 13:21:43','',''),(2489765,'1','206','1030',472,'Received from bridging 130096',0.00,0.00,20000.00,0.00,0.00,'2022-01-11 13:21:43','',''),(2489908,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,3300000.00,20000.00,0.00,0.00,'2022-01-11 13:37:13','',''),(2496834,'1','206','1030',472,'Sale Id shift 252917',0.00,0.00,0.00,701.27,0.00,'2022-01-12 11:42:27','',''),(2496835,'1','206','1030',472,'Sale Id shift 252917',0.00,0.00,0.00,1235.41,0.00,'2022-01-12 11:42:27','',''),(2496836,'1','206','1030',472,'Sale Id shift 252917',0.00,0.00,0.00,1381.29,0.00,'2022-01-12 11:42:27','',''),(2496837,'1','206','1030',472,'Sale Id shift 252917',0.00,0.00,0.00,331.41,0.00,'2022-01-12 11:42:27','',''),(2496838,'1','206','1030',472,'Sale Id shift 252917',0.00,0.00,0.00,566.29,0.00,'2022-01-12 11:42:27','',''),(2496839,'1','206','1030',472,'Sale Id shift 252917',0.00,0.00,0.00,596.77,0.00,'2022-01-12 11:42:27','',''),(2496840,'1','206','1030',472,'Sale Id shift 252917',0.00,0.00,0.00,33.94,0.00,'2022-01-12 11:42:27','',''),(2496841,'1','206','1031',473,'Sale Id shift 252917',0.00,0.00,0.00,176.31,0.00,'2022-01-12 11:42:27','',''),(2496842,'1','206',NULL,472,'Sale Id shift 252917',799652.70,0.00,0.00,0.00,0.00,'2022-01-12 11:42:27','',''),(2496843,'1','206',NULL,473,'Sale Id shift 252917',60826.95,0.00,0.00,0.00,0.00,'2022-01-12 11:42:27','',''),(2499675,'1','206',NULL,472,'Reception corrector for bridging 130460',0.00,0.00,0.00,20000.00,0.00,'2022-01-12 16:32:52','',''),(2499676,'1','206','1030',472,'Received from bridging 130460',0.00,0.00,20000.00,0.00,0.00,'2022-01-12 16:32:52','',''),(2504403,'1','206','1030',472,'Sale Id shift 253080',0.00,0.00,0.00,380.39,0.00,'2022-01-13 11:39:49','',''),(2504404,'1','206','1030',472,'Sale Id shift 253080',0.00,0.00,0.00,543.24,0.00,'2022-01-13 11:39:49','',''),(2504405,'1','206','1030',472,'Sale Id shift 253080',0.00,0.00,0.00,581.36,0.00,'2022-01-13 11:39:49','',''),(2504406,'1','206','1030',472,'Sale Id shift 253080',0.00,0.00,0.00,47.87,0.00,'2022-01-13 11:39:49','',''),(2504407,'1','206','1030',472,'Sale Id shift 253080',0.00,0.00,0.00,49.69,0.00,'2022-01-13 11:39:49','',''),(2504408,'1','206','1030',472,'Sale Id shift 253080',0.00,0.00,0.00,630.03,0.00,'2022-01-13 11:39:49','',''),(2504409,'1','206','1030',472,'Sale Id shift 253080',0.00,0.00,0.00,7.09,0.00,'2022-01-13 11:39:49','',''),(2504410,'1','206','1031',473,'Sale Id shift 253080',0.00,0.00,0.00,24.93,0.00,'2022-01-13 11:39:49','',''),(2504411,'1','206',NULL,472,'Sale Id shift 253080',369545.55,0.00,0.00,0.00,0.00,'2022-01-13 11:39:49','',''),(2504412,'1','206',NULL,473,'Sale Id shift 253080',8600.85,0.00,0.00,0.00,0.00,'2022-01-13 11:39:49','',''),(2505167,'1','206','1030',472,'Sale Id shift 253331',0.00,0.00,0.00,852.53,0.00,'2022-01-13 13:01:08','',''),(2505168,'1','206','1030',472,'Sale Id shift 253331',0.00,0.00,0.00,1043.02,0.00,'2022-01-13 13:01:08','',''),(2505169,'1','206','1030',472,'Sale Id shift 253331',0.00,0.00,0.00,1329.39,0.00,'2022-01-13 13:01:08','',''),(2505170,'1','206','1030',472,'Sale Id shift 253331',0.00,0.00,0.00,144.90,0.00,'2022-01-13 13:01:08','',''),(2505171,'1','206','1030',472,'Sale Id shift 253331',0.00,0.00,0.00,224.53,0.00,'2022-01-13 13:01:08','',''),(2505172,'1','206','1030',472,'Sale Id shift 253331',0.00,0.00,0.00,1541.82,0.00,'2022-01-13 13:01:08','',''),(2505173,'1','206','1030',472,'Sale Id shift 253331',0.00,0.00,0.00,18.49,0.00,'2022-01-13 13:01:08','',''),(2505174,'1','206','1031',473,'Sale Id shift 253331',0.00,0.00,0.00,143.28,0.00,'2022-01-13 13:01:08','',''),(2505175,'1','206',NULL,472,'Sale Id shift 253331',850522.20,0.00,0.00,0.00,0.00,'2022-01-13 13:01:08','',''),(2505176,'1','206',NULL,473,'Sale Id shift 253331',49431.60,0.00,0.00,0.00,0.00,'2022-01-13 13:01:08','',''),(2507225,'1','206','1030',472,'Sale Id shift 253351',0.00,0.00,0.00,215.00,0.00,'2022-01-13 16:22:01','',''),(2507226,'1','206','1030',472,'Sale Id shift 253351',0.00,0.00,0.00,804.52,0.00,'2022-01-13 16:22:01','',''),(2507227,'1','206','1030',472,'Sale Id shift 253351',0.00,0.00,0.00,925.42,0.00,'2022-01-13 16:22:01','',''),(2507228,'1','206','1030',472,'Sale Id shift 253351',0.00,0.00,0.00,156.25,0.00,'2022-01-13 16:22:01','',''),(2507229,'1','206','1030',472,'Sale Id shift 253351',0.00,0.00,0.00,1169.64,0.00,'2022-01-13 16:22:01','',''),(2507230,'1','206','1031',473,'Sale Id shift 253351',0.00,0.00,0.00,190.64,0.00,'2022-01-13 16:22:01','',''),(2507231,'1','206',NULL,472,'Sale Id shift 253351',539686.95,0.00,0.00,0.00,0.00,'2022-01-13 16:22:01','',''),(2507232,'1','206',NULL,473,'Sale Id shift 253351',65770.80,0.00,0.00,0.00,0.00,'2022-01-13 16:22:01','',''),(2511834,'1','206','1030',472,'Sale Id shift 253397',0.00,0.00,0.00,761.43,0.00,'2022-01-14 11:14:03','',''),(2511835,'1','206','1030',472,'Sale Id shift 253397',0.00,0.00,0.00,1246.90,0.00,'2022-01-14 11:14:03','',''),(2511836,'1','206','1030',472,'Sale Id shift 253397',0.00,0.00,0.00,1326.51,0.00,'2022-01-14 11:14:03','',''),(2511837,'1','206','1030',472,'Sale Id shift 253397',0.00,0.00,0.00,297.37,0.00,'2022-01-14 11:14:03','',''),(2511838,'1','206','1030',472,'Sale Id shift 253397',0.00,0.00,0.00,470.21,0.00,'2022-01-14 11:14:03','',''),(2511839,'1','206','1030',472,'Sale Id shift 253397',0.00,0.00,0.00,1412.30,0.00,'2022-01-14 11:14:03','',''),(2511840,'1','206','1031',473,'Sale Id shift 253397',0.00,0.00,0.00,104.35,0.00,'2022-01-14 11:14:03','',''),(2511841,'1','206',NULL,472,'Sale Id shift 253397',909928.80,0.00,0.00,0.00,0.00,'2022-01-14 11:14:03','',''),(2511842,'1','206',NULL,473,'Sale Id shift 253397',36000.75,0.00,0.00,0.00,0.00,'2022-01-14 11:14:03','',''),(2511923,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,3630000.00,22000.00,0.00,0.00,'2022-01-14 11:21:50','',''),(2516100,'1','206','1030',472,'Sale Id shift 253570',0.00,0.00,0.00,1267.27,0.00,'2022-01-14 19:15:41','',''),(2516101,'1','206','1030',472,'Sale Id shift 253570',0.00,0.00,0.00,1055.60,0.00,'2022-01-14 19:15:41','',''),(2516102,'1','206','1030',472,'Sale Id shift 253570',0.00,0.00,0.00,40.86,0.00,'2022-01-14 19:15:41','',''),(2516103,'1','206','1030',472,'Sale Id shift 253570',0.00,0.00,0.00,1199.81,0.00,'2022-01-14 19:15:41','',''),(2516104,'1','206','1030',472,'Sale Id shift 253570',0.00,0.00,0.00,426.47,0.00,'2022-01-14 19:15:41','',''),(2516105,'1','206','1031',473,'Sale Id shift 253570',0.00,0.00,0.00,74.21,0.00,'2022-01-14 19:15:41','',''),(2516106,'1','206',NULL,472,'Sale Id shift 253570',658351.65,0.00,0.00,0.00,0.00,'2022-01-14 19:15:41','',''),(2516107,'1','206',NULL,473,'Sale Id shift 253570',25602.45,0.00,0.00,0.00,0.00,'2022-01-14 19:15:41','',''),(2521085,'1','206','1030',472,'Sale Id shift 253662',0.00,0.00,0.00,1526.77,0.00,'2022-01-15 13:18:12','',''),(2521086,'1','206','1030',472,'Sale Id shift 253662',0.00,0.00,0.00,1377.47,0.00,'2022-01-15 13:18:12','',''),(2521087,'1','206','1030',472,'Sale Id shift 253662',0.00,0.00,0.00,208.38,0.00,'2022-01-15 13:18:12','',''),(2521088,'1','206','1030',472,'Sale Id shift 253662',0.00,0.00,0.00,1000.19,0.00,'2022-01-15 13:18:12','',''),(2521089,'1','206','1030',472,'Sale Id shift 253662',0.00,0.00,0.00,1000.00,0.00,'2022-01-15 13:18:12','',''),(2521090,'1','206','1030',472,'Sale Id shift 253662',0.00,0.00,0.00,868.92,0.00,'2022-01-15 13:18:12','',''),(2521091,'1','206','1030',472,'Sale Id shift 253662',0.00,0.00,0.00,252.86,0.00,'2022-01-15 13:18:12','',''),(2521092,'1','206','1031',473,'Sale Id shift 253662',0.00,0.00,0.00,4.35,0.00,'2022-01-15 13:18:12','',''),(2521093,'1','206',NULL,472,'Sale Id shift 253662',1028707.35,0.00,0.00,0.00,0.00,'2022-01-15 13:18:12','',''),(2521094,'1','206',NULL,473,'Sale Id shift 253662',1500.75,0.00,0.00,0.00,0.00,'2022-01-15 13:18:12','',''),(2522411,'1','206','1030',472,'Sale Id shift 253826',0.00,0.00,0.00,565.08,0.00,'2022-01-15 15:06:44','',''),(2522412,'1','206','1030',472,'Sale Id shift 253826',0.00,0.00,0.00,569.45,0.00,'2022-01-15 15:06:44','',''),(2522413,'1','206','1030',472,'Sale Id shift 253826',0.00,0.00,0.00,1013.14,0.00,'2022-01-15 15:06:44','',''),(2522414,'1','206','1030',472,'Sale Id shift 253826',0.00,0.00,0.00,846.40,0.00,'2022-01-15 15:06:44','',''),(2522415,'1','206','1030',472,'Sale Id shift 253826',0.00,0.00,0.00,144.84,0.00,'2022-01-15 15:06:44','',''),(2522416,'1','206','1031',473,'Sale Id shift 253826',0.00,0.00,0.00,36.23,0.00,'2022-01-15 15:06:44','',''),(2522417,'1','206',NULL,472,'Sale Id shift 253826',517920.15,0.00,0.00,0.00,0.00,'2022-01-15 15:06:44','',''),(2522418,'1','206',NULL,473,'Sale Id shift 253826',12499.35,0.00,0.00,0.00,0.00,'2022-01-15 15:06:44','',''),(2527737,'1','206','1030',472,'Sale Id shift 253908',0.00,0.00,0.00,455.31,0.00,'2022-01-16 10:11:51','',''),(2527738,'1','206','1030',472,'Sale Id shift 253908',0.00,0.00,0.00,1314.52,0.00,'2022-01-16 10:11:51','',''),(2527739,'1','206','1030',472,'Sale Id shift 253908',0.00,0.00,0.00,1222.39,0.00,'2022-01-16 10:11:51','',''),(2527740,'1','206','1030',472,'Sale Id shift 253908',0.00,0.00,0.00,398.02,0.00,'2022-01-16 10:11:51','',''),(2527741,'1','206','1030',472,'Sale Id shift 253908',0.00,0.00,0.00,1100.00,0.00,'2022-01-16 10:11:51','',''),(2527742,'1','206','1030',472,'Sale Id shift 253908',0.00,0.00,0.00,1100.00,0.00,'2022-01-16 10:11:51','',''),(2527743,'1','206','1030',472,'Sale Id shift 253908',0.00,0.00,0.00,1234.01,0.00,'2022-01-16 10:11:51','',''),(2527744,'1','206','1030',472,'Sale Id shift 253908',0.00,0.00,0.00,449.41,0.00,'2022-01-16 10:11:51','',''),(2527745,'1','206','1031',473,'Sale Id shift 253908',0.00,0.00,0.00,471.85,0.00,'2022-01-16 10:11:51','',''),(2527746,'1','206',NULL,472,'Sale Id shift 253908',1200153.90,0.00,0.00,0.00,0.00,'2022-01-16 10:11:51','',''),(2527747,'1','206',NULL,473,'Sale Id shift 253908',162788.25,0.00,0.00,0.00,0.00,'2022-01-16 10:11:51','',''),(2533720,'1','206',NULL,472,'Reception corrector for bridging 129532',0.00,0.00,0.00,600.00,0.00,'2022-01-16 19:43:55','',''),(2533721,'1','206','1030',472,'Received from bridging 129532',0.00,0.00,600.00,0.00,0.00,'2022-01-16 19:43:55','',''),(2533722,'1','206',NULL,472,'Reception corrector for bridging 130851',0.00,0.00,0.00,22000.00,0.00,'2022-01-16 19:44:12','',''),(2533723,'1','206','1030',472,'Received from bridging 130851',0.00,0.00,22000.00,0.00,0.00,'2022-01-16 19:44:12','',''),(2536006,'1','206','1030',472,'Sale Id shift 254063',0.00,0.00,0.00,3368.10,0.00,'2022-01-17 10:46:44','',''),(2536007,'1','206',NULL,472,'Sale Id shift 254063',555736.50,0.00,0.00,0.00,0.00,'2022-01-17 10:46:44','',''),(2540914,'1','206','1030',472,'Sale Id shift 254386',0.00,0.00,0.00,90.00,0.00,'2022-01-17 22:57:41','',''),(2540915,'1','206','1031',473,'Sale Id shift 254386',0.00,0.00,0.00,228.99,0.00,'2022-01-17 22:57:41','',''),(2540916,'1','206',NULL,472,'Sale Id shift 254386',14850.00,0.00,0.00,0.00,0.00,'2022-01-17 22:57:41','',''),(2540917,'1','206',NULL,473,'Sale Id shift 254386',79001.55,0.00,0.00,0.00,0.00,'2022-01-17 22:57:41','',''),(2564134,'1','206','1031',473,'Sale Id shift 255121',0.00,0.00,0.00,1065.00,0.00,'2022-01-20 20:16:26','',''),(2564135,'1','206',NULL,473,'Sale Id shift 255121',372750.00,0.00,0.00,0.00,0.00,'2022-01-20 20:16:26','',''),(2576617,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-01-22 12:36:33','',''),(2576752,'1','206',NULL,472,'Reception corrector for bridging 131729',0.00,0.00,0.00,30000.00,0.00,'2022-01-22 12:45:31','',''),(2576753,'1','206','1030',472,'Received from bridging 131729',0.00,0.00,30000.00,0.00,0.00,'2022-01-22 12:45:31','',''),(2582194,'1','206','1030',472,'Sale Id shift 255528',0.00,0.00,0.00,489.05,0.00,'2022-01-23 08:07:49','',''),(2582195,'1','206','1030',472,'Sale Id shift 255528',0.00,0.00,0.00,555.23,0.00,'2022-01-23 08:07:49','',''),(2582196,'1','206','1030',472,'Sale Id shift 255528',0.00,0.00,0.00,206.90,0.00,'2022-01-23 08:07:49','',''),(2582197,'1','206','1030',472,'Sale Id shift 255528',0.00,0.00,0.00,12.42,0.00,'2022-01-23 08:07:49','',''),(2582198,'1','206','1030',472,'Sale Id shift 255528',0.00,0.00,0.00,60.61,0.00,'2022-01-23 08:07:49','',''),(2582199,'1','206','1030',472,'Sale Id shift 255528',0.00,0.00,0.00,38.51,0.00,'2022-01-23 08:07:49','',''),(2582200,'1','206','1030',472,'Sale Id shift 255528',0.00,0.00,0.00,536.61,0.00,'2022-01-23 08:07:49','',''),(2582201,'1','206','1030',472,'Sale Id shift 255528',0.00,0.00,0.00,110.95,0.00,'2022-01-23 08:07:49','',''),(2582202,'1','206',NULL,472,'Sale Id shift 255528',331696.20,0.00,0.00,0.00,0.00,'2022-01-23 08:07:49','',''),(2586389,'1','206','1030',472,'Sale Id shift 255792',0.00,0.00,0.00,913.95,0.00,'2022-01-23 14:09:58','',''),(2586390,'1','206','1030',472,'Sale Id shift 255792',0.00,0.00,0.00,765.56,0.00,'2022-01-23 14:09:58','',''),(2586391,'1','206','1030',472,'Sale Id shift 255792',0.00,0.00,0.00,665.00,0.00,'2022-01-23 14:09:58','',''),(2586392,'1','206','1030',472,'Sale Id shift 255792',0.00,0.00,0.00,78.07,0.00,'2022-01-23 14:09:58','',''),(2586393,'1','206','1031',473,'Sale Id shift 255792',0.00,0.00,0.00,944.87,0.00,'2022-01-23 14:09:58','',''),(2586394,'1','206',NULL,472,'Sale Id shift 255792',399725.70,0.00,0.00,0.00,0.00,'2022-01-23 14:09:58','',''),(2586395,'1','206',NULL,473,'Sale Id shift 255792',335428.85,0.00,0.00,0.00,0.00,'2022-01-23 14:09:58','',''),(2591122,'1','206','1030',472,'Sale Id shift 255829',0.00,0.00,0.00,686.66,0.00,'2022-01-24 09:33:48','',''),(2591123,'1','206','1030',472,'Sale Id shift 255829',0.00,0.00,0.00,710.47,0.00,'2022-01-24 09:33:48','',''),(2591124,'1','206','1030',472,'Sale Id shift 255829',0.00,0.00,0.00,182.82,0.00,'2022-01-24 09:33:48','',''),(2591125,'1','206',NULL,472,'Sale Id shift 255829',260691.75,0.00,0.00,0.00,0.00,'2022-01-24 09:33:48','',''),(2592151,'1','206','1030',472,'Sale Id shift 256026',0.00,0.00,0.00,392.98,0.00,'2022-01-24 11:19:06','',''),(2592152,'1','206','1030',472,'Sale Id shift 256026',0.00,0.00,0.00,646.59,0.00,'2022-01-24 11:19:06','',''),(2592153,'1','206','1030',472,'Sale Id shift 256026',0.00,0.00,0.00,486.58,0.00,'2022-01-24 11:19:06','',''),(2592154,'1','206','1030',472,'Sale Id shift 256026',0.00,0.00,0.00,262.99,0.00,'2022-01-24 11:19:06','',''),(2592155,'1','206','1030',472,'Sale Id shift 256026',0.00,0.00,0.00,236.32,0.00,'2022-01-24 11:19:06','',''),(2592156,'1','206','1030',472,'Sale Id shift 256026',0.00,0.00,0.00,336.22,0.00,'2022-01-24 11:19:06','',''),(2592157,'1','206','1031',473,'Sale Id shift 256026',0.00,0.00,0.00,143.04,0.00,'2022-01-24 11:19:06','',''),(2592158,'1','206',NULL,472,'Sale Id shift 256026',389677.20,0.00,0.00,0.00,0.00,'2022-01-24 11:19:06','',''),(2592159,'1','206',NULL,473,'Sale Id shift 256026',50779.20,0.00,0.00,0.00,0.00,'2022-01-24 11:19:06','',''),(2596334,'1','206','1030',472,'Sale Id shift 256059',0.00,0.00,0.00,775.98,0.00,'2022-01-24 18:39:11','',''),(2596335,'1','206','1030',472,'Sale Id shift 256059',0.00,0.00,0.00,395.62,0.00,'2022-01-24 18:39:11','',''),(2596336,'1','206','1030',472,'Sale Id shift 256059',0.00,0.00,0.00,57.56,0.00,'2022-01-24 18:39:11','',''),(2596337,'1','206','1030',472,'Sale Id shift 256059',0.00,0.00,0.00,85.76,0.00,'2022-01-24 18:39:11','',''),(2596338,'1','206','1030',472,'Sale Id shift 256059',0.00,0.00,0.00,302.84,0.00,'2022-01-24 18:39:11','',''),(2596339,'1','206','1031',473,'Sale Id shift 256059',0.00,0.00,0.00,16.63,0.00,'2022-01-24 18:39:11','',''),(2596340,'1','206',NULL,472,'Sale Id shift 256059',266930.40,0.00,0.00,0.00,0.00,'2022-01-24 18:39:11','',''),(2596341,'1','206',NULL,473,'Sale Id shift 256059',5903.65,0.00,0.00,0.00,0.00,'2022-01-24 18:39:11','',''),(2600677,'1','206','1030',472,'Sale Id shift 256146',0.00,0.00,0.00,1618.62,0.00,'2022-01-25 13:13:48','',''),(2600678,'1','206','1030',472,'Sale Id shift 256146',0.00,0.00,0.00,726.82,0.00,'2022-01-25 13:13:48','',''),(2600679,'1','206','1030',472,'Sale Id shift 256146',0.00,0.00,0.00,239.60,0.00,'2022-01-25 13:13:48','',''),(2600680,'1','206','1030',472,'Sale Id shift 256146',0.00,0.00,0.00,845.95,0.00,'2022-01-25 13:13:48','',''),(2600681,'1','206','1031',473,'Sale Id shift 256146',0.00,0.00,0.00,386.85,0.00,'2022-01-25 13:13:48','',''),(2600682,'1','206',NULL,472,'Sale Id shift 256146',566113.35,0.00,0.00,0.00,0.00,'2022-01-25 13:13:48','',''),(2600683,'1','206',NULL,473,'Sale Id shift 256146',137331.75,0.00,0.00,0.00,0.00,'2022-01-25 13:13:48','',''),(2605317,'1','206','1030',472,'Sale Id shift 256346',0.00,0.00,0.00,558.03,0.00,'2022-01-25 21:23:25','',''),(2605318,'1','206','1030',472,'Sale Id shift 256346',0.00,0.00,0.00,568.30,0.00,'2022-01-25 21:23:25','',''),(2605319,'1','206','1030',472,'Sale Id shift 256346',0.00,0.00,0.00,633.66,0.00,'2022-01-25 21:23:25','',''),(2605320,'1','206','1030',472,'Sale Id shift 256346',0.00,0.00,0.00,60.61,0.00,'2022-01-25 21:23:25','',''),(2605321,'1','206','1030',472,'Sale Id shift 256346',0.00,0.00,0.00,42.53,0.00,'2022-01-25 21:23:25','',''),(2605322,'1','206','1030',472,'Sale Id shift 256346',0.00,0.00,0.00,87.87,0.00,'2022-01-25 21:23:25','',''),(2605323,'1','206','1030',472,'Sale Id shift 256346',0.00,0.00,0.00,785.72,0.00,'2022-01-25 21:23:25','',''),(2605324,'1','206','1030',472,'Sale Id shift 256346',0.00,0.00,0.00,149.69,0.00,'2022-01-25 21:23:25','',''),(2605325,'1','206','1031',473,'Sale Id shift 256346',0.00,0.00,0.00,3.94,0.00,'2022-01-25 21:23:25','',''),(2605326,'1','206',NULL,472,'Sale Id shift 256346',476257.65,0.00,0.00,0.00,0.00,'2022-01-25 21:23:25','',''),(2605327,'1','206',NULL,473,'Sale Id shift 256346',1398.70,0.00,0.00,0.00,0.00,'2022-01-25 21:23:25','',''),(2608262,'1','206','1030',472,'Sale Id shift 256527',0.00,0.00,0.00,450.13,0.00,'2022-01-26 11:35:30','',''),(2608263,'1','206','1030',472,'Sale Id shift 256527',0.00,0.00,0.00,1074.43,0.00,'2022-01-26 11:35:30','',''),(2608264,'1','206','1030',472,'Sale Id shift 256527',0.00,0.00,0.00,1367.89,0.00,'2022-01-26 11:35:30','',''),(2608265,'1','206','1030',472,'Sale Id shift 256527',0.00,0.00,0.00,224.73,0.00,'2022-01-26 11:35:30','',''),(2608266,'1','206','1030',472,'Sale Id shift 256527',0.00,0.00,0.00,1102.42,0.00,'2022-01-26 11:35:30','',''),(2608267,'1','206','1030',472,'Sale Id shift 256527',0.00,0.00,0.00,258.30,0.00,'2022-01-26 11:35:30','',''),(2608268,'1','206','1031',473,'Sale Id shift 256527',0.00,0.00,0.00,162.81,0.00,'2022-01-26 11:35:30','',''),(2608269,'1','206',NULL,472,'Sale Id shift 256527',738853.50,0.00,0.00,0.00,0.00,'2022-01-26 11:35:30','',''),(2608270,'1','206',NULL,473,'Sale Id shift 256527',57797.55,0.00,0.00,0.00,0.00,'2022-01-26 11:35:30','',''),(2612225,'1','206','1030',472,'Sale Id shift 256588',0.00,0.00,0.00,450.21,0.00,'2022-01-26 19:13:16','',''),(2612226,'1','206','1030',472,'Sale Id shift 256588',0.00,0.00,0.00,101.51,0.00,'2022-01-26 19:13:16','',''),(2612227,'1','206','1030',472,'Sale Id shift 256588',0.00,0.00,0.00,627.45,0.00,'2022-01-26 19:13:16','',''),(2612228,'1','206','1030',472,'Sale Id shift 256588',0.00,0.00,0.00,413.62,0.00,'2022-01-26 19:13:16','',''),(2612229,'1','206','1030',472,'Sale Id shift 256588',0.00,0.00,0.00,59.53,0.00,'2022-01-26 19:13:16','',''),(2612230,'1','206','1031',473,'Sale Id shift 256588',0.00,0.00,0.00,30.71,0.00,'2022-01-26 19:13:16','',''),(2612231,'1','206',NULL,472,'Sale Id shift 256588',272632.80,0.00,0.00,0.00,0.00,'2022-01-26 19:13:16','',''),(2612232,'1','206',NULL,473,'Sale Id shift 256588',10902.05,0.00,0.00,0.00,0.00,'2022-01-26 19:13:16','',''),(2612982,'1','206',NULL,472,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613097,'1','206',NULL,473,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613245,'1','206','1030',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613962,'1','206','1031',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2616434,'1','206','1030',472,'Sale Id shift 256670',0.00,0.00,0.00,1353.57,0.00,'2022-01-27 10:36:34','',''),(2616435,'1','206','1030',472,'Sale Id shift 256670',0.00,0.00,0.00,264.06,0.00,'2022-01-27 10:36:34','',''),(2616436,'1','206','1030',472,'Sale Id shift 256670',0.00,0.00,0.00,1152.54,0.00,'2022-01-27 10:36:34','',''),(2616437,'1','206','1030',472,'Sale Id shift 256670',0.00,0.00,0.00,221.48,0.00,'2022-01-27 10:36:34','',''),(2616438,'1','206','1030',472,'Sale Id shift 256670',0.00,0.00,0.00,1373.39,0.00,'2022-01-27 10:36:34','',''),(2616439,'1','206','1030',472,'Sale Id shift 256670',0.00,0.00,0.00,63.02,0.00,'2022-01-27 10:36:34','',''),(2616440,'1','206','1031',473,'Sale Id shift 256670',0.00,0.00,0.00,159.54,0.00,'2022-01-27 10:36:34','',''),(2616441,'1','206',NULL,472,'Sale Id shift 256670',730629.90,0.00,0.00,0.00,0.00,'2022-01-27 10:36:34','',''),(2616442,'1','206',NULL,473,'Sale Id shift 256670',56636.70,0.00,0.00,0.00,0.00,'2022-01-27 10:36:34','',''),(2617753,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-01-27 12:42:50','',''),(2622844,'1','206','1030',472,'Sale Id shift 256813',0.00,0.00,0.00,1399.57,0.00,'2022-01-28 07:13:22','',''),(2622845,'1','206','1030',472,'Sale Id shift 256813',0.00,0.00,0.00,6.81,0.00,'2022-01-28 07:13:22','',''),(2622846,'1','206','1030',472,'Sale Id shift 256813',0.00,0.00,0.00,1000.53,0.00,'2022-01-28 07:13:22','',''),(2622847,'1','206','1030',472,'Sale Id shift 256813',0.00,0.00,0.00,35.14,0.00,'2022-01-28 07:13:22','',''),(2622848,'1','206','1030',472,'Sale Id shift 256813',0.00,0.00,0.00,15.29,0.00,'2022-01-28 07:13:22','',''),(2622849,'1','206','1030',472,'Sale Id shift 256813',0.00,0.00,0.00,567.24,0.00,'2022-01-28 07:13:22','',''),(2622850,'1','206','1030',472,'Sale Id shift 256813',0.00,0.00,0.00,693.83,0.00,'2022-01-28 07:13:22','',''),(2622851,'1','206','1031',473,'Sale Id shift 256813',0.00,0.00,0.00,14.08,0.00,'2022-01-28 07:13:22','',''),(2622852,'1','206',NULL,472,'Sale Id shift 256813',613537.65,0.00,0.00,0.00,0.00,'2022-01-28 07:13:22','',''),(2622853,'1','206',NULL,473,'Sale Id shift 256813',4998.40,0.00,0.00,0.00,0.00,'2022-01-28 07:13:22','',''),(2625765,'1','206',NULL,472,'Reception corrector for bridging 132378',0.00,0.00,0.00,15000.00,0.00,'2022-01-28 11:33:27','',''),(2625766,'1','206','1030',472,'Received from bridging 132378',0.00,0.00,15000.00,0.00,0.00,'2022-01-28 11:33:27','',''),(2626389,'1','206','1030',472,'Sale Id shift 257017',0.00,0.00,0.00,1520.93,0.00,'2022-01-28 12:27:46','',''),(2626390,'1','206','1030',472,'Sale Id shift 257017',0.00,0.00,0.00,3.42,0.00,'2022-01-28 12:27:46','',''),(2626391,'1','206','1030',472,'Sale Id shift 257017',0.00,0.00,0.00,812.19,0.00,'2022-01-28 12:27:46','',''),(2626392,'1','206','1030',472,'Sale Id shift 257017',0.00,0.00,0.00,414.05,0.00,'2022-01-28 12:27:46','',''),(2626393,'1','206','1030',472,'Sale Id shift 257017',0.00,0.00,0.00,954.12,0.00,'2022-01-28 12:27:46','',''),(2626394,'1','206','1030',472,'Sale Id shift 257017',0.00,0.00,0.00,103.47,0.00,'2022-01-28 12:27:46','',''),(2626395,'1','206','1031',473,'Sale Id shift 257017',0.00,0.00,0.00,134.08,0.00,'2022-01-28 12:27:46','',''),(2626396,'1','206',NULL,472,'Sale Id shift 257017',628349.70,0.00,0.00,0.00,0.00,'2022-01-28 12:27:46','',''),(2626397,'1','206',NULL,473,'Sale Id shift 257017',47598.40,0.00,0.00,0.00,0.00,'2022-01-28 12:27:46','',''),(2629838,'1','206','1030',472,'Sale Id shift 257096',0.00,0.00,0.00,1066.25,0.00,'2022-01-28 17:46:47','',''),(2629839,'1','206','1030',472,'Sale Id shift 257096',0.00,0.00,0.00,810.66,0.00,'2022-01-28 17:46:47','',''),(2629840,'1','206','1030',472,'Sale Id shift 257096',0.00,0.00,0.00,0.91,0.00,'2022-01-28 17:46:47','',''),(2629841,'1','206','1030',472,'Sale Id shift 257096',0.00,0.00,0.00,801.21,0.00,'2022-01-28 17:46:47','',''),(2629842,'1','206','1030',472,'Sale Id shift 257096',0.00,0.00,0.00,23.94,0.00,'2022-01-28 17:46:47','',''),(2629843,'1','206','1031',473,'Sale Id shift 257096',0.00,0.00,0.00,4.72,0.00,'2022-01-28 17:46:47','',''),(2629844,'1','206',NULL,472,'Sale Id shift 257096',445990.05,0.00,0.00,0.00,0.00,'2022-01-28 17:46:47','',''),(2629845,'1','206',NULL,473,'Sale Id shift 257096',1699.20,0.00,0.00,0.00,0.00,'2022-01-28 17:46:47','',''),(2633653,'1','206','1030',472,'Sale Id shift 257183',0.00,0.00,0.00,351.48,0.00,'2022-01-29 11:06:43','',''),(2633654,'1','206','1030',472,'Sale Id shift 257183',0.00,0.00,0.00,1456.01,0.00,'2022-01-29 11:06:43','',''),(2633655,'1','206','1030',472,'Sale Id shift 257183',0.00,0.00,0.00,744.32,0.00,'2022-01-29 11:06:43','',''),(2633656,'1','206','1030',472,'Sale Id shift 257183',0.00,0.00,0.00,632.37,0.00,'2022-01-29 11:06:43','',''),(2633657,'1','206','1030',472,'Sale Id shift 257183',0.00,0.00,0.00,24.24,0.00,'2022-01-29 11:06:43','',''),(2633658,'1','206','1030',472,'Sale Id shift 257183',0.00,0.00,0.00,100.61,0.00,'2022-01-29 11:06:43','',''),(2633659,'1','206','1030',472,'Sale Id shift 257183',0.00,0.00,0.00,1084.08,0.00,'2022-01-29 11:06:43','',''),(2633660,'1','206','1030',472,'Sale Id shift 257183',0.00,0.00,0.00,505.37,0.00,'2022-01-29 11:06:43','',''),(2633661,'1','206','1031',473,'Sale Id shift 257183',0.00,0.00,0.00,25.19,0.00,'2022-01-29 11:06:43','',''),(2633662,'1','206',NULL,472,'Sale Id shift 257183',808249.20,0.00,0.00,0.00,0.00,'2022-01-29 11:06:43','',''),(2633663,'1','206',NULL,473,'Sale Id shift 257183',9068.40,0.00,0.00,0.00,0.00,'2022-01-29 11:06:43','',''),(2645666,'1','206','1030',472,'Sale Id shift 257403',0.00,0.00,0.00,965.51,0.00,'2022-01-30 12:54:26','',''),(2645667,'1','206','1030',472,'Sale Id shift 257403',0.00,0.00,0.00,26.77,0.00,'2022-01-30 12:54:26','',''),(2645668,'1','206','1030',472,'Sale Id shift 257403',0.00,0.00,0.00,741.78,0.00,'2022-01-30 12:54:26','',''),(2645669,'1','206','1030',472,'Sale Id shift 257403',0.00,0.00,0.00,663.28,0.00,'2022-01-30 12:54:26','',''),(2645670,'1','206','1030',472,'Sale Id shift 257403',0.00,0.00,0.00,312.10,0.00,'2022-01-30 12:54:26','',''),(2645671,'1','206','1031',473,'Sale Id shift 257403',0.00,0.00,0.00,152.93,0.00,'2022-01-30 12:54:26','',''),(2645672,'1','206',NULL,472,'Sale Id shift 257403',447057.60,0.00,0.00,0.00,0.00,'2022-01-30 12:54:26','',''),(2645673,'1','206',NULL,473,'Sale Id shift 257403',55054.80,0.00,0.00,0.00,0.00,'2022-01-30 12:54:26','',''),(2646191,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-01-30 13:27:56','',''),(2648054,'1','206','1030',472,'Sale Id shift 257624',0.00,0.00,0.00,1742.69,0.00,'2022-01-30 15:35:52','',''),(2648055,'1','206','1030',472,'Sale Id shift 257624',0.00,0.00,0.00,1431.50,0.00,'2022-01-30 15:35:52','',''),(2648056,'1','206','1030',472,'Sale Id shift 257624',0.00,0.00,0.00,200.74,0.00,'2022-01-30 15:35:52','',''),(2648057,'1','206','1030',472,'Sale Id shift 257624',0.00,0.00,0.00,825.04,0.00,'2022-01-30 15:35:52','',''),(2648058,'1','206','1030',472,'Sale Id shift 257624',0.00,0.00,0.00,904.12,0.00,'2022-01-30 15:35:52','',''),(2648059,'1','206','1031',473,'Sale Id shift 257624',0.00,0.00,0.00,511.12,0.00,'2022-01-30 15:35:52','',''),(2648060,'1','206',NULL,472,'Sale Id shift 257624',842174.85,0.00,0.00,0.00,0.00,'2022-01-30 15:35:52','',''),(2648061,'1','206',NULL,473,'Sale Id shift 257624',184003.20,0.00,0.00,0.00,0.00,'2022-01-30 15:35:52','',''),(2648062,'1','206','1030',472,'Sale Id shift 257625',0.00,0.00,0.00,1085.69,0.00,'2022-01-31 14:41:13','',''),(2648063,'1','206','1030',472,'Sale Id shift 257625',0.00,0.00,0.00,1003.73,0.00,'2022-01-31 14:41:13','',''),(2648064,'1','206','1030',472,'Sale Id shift 257625',0.00,0.00,0.00,1436.77,0.00,'2022-01-31 14:41:13','',''),(2648065,'1','206','1030',472,'Sale Id shift 257625',0.00,0.00,0.00,102.12,0.00,'2022-01-31 14:41:13','',''),(2648066,'1','206','1030',472,'Sale Id shift 257625',0.00,0.00,0.00,581.34,0.00,'2022-01-31 14:41:13','',''),(2648067,'1','206','1030',472,'Sale Id shift 257625',0.00,0.00,0.00,1265.90,0.00,'2022-01-31 14:41:13','',''),(2648068,'1','206','1030',472,'Sale Id shift 257625',0.00,0.00,0.00,461.30,0.00,'2022-01-31 14:41:13','',''),(2648069,'1','206','1031',473,'Sale Id shift 257625',0.00,0.00,0.00,101.97,0.00,'2022-01-31 14:41:13','',''),(2648070,'1','206',NULL,473,'Sale Id shift 257625',36709.20,0.00,0.00,0.00,0.00,'2022-01-31 14:41:13','',''),(2648071,'1','206',NULL,472,'Sale Id shift 257625',979580.25,0.00,0.00,0.00,0.00,'2022-01-31 14:41:13','',''),(2648072,'1','206',NULL,472,'Reception corrector for bridging 132379',0.00,0.00,0.00,15000.00,0.00,'2022-01-31 17:17:28','',''),(2648073,'1','206','1030',472,'Received from bridging 132379',0.00,0.00,15000.00,0.00,0.00,'2022-01-31 17:17:28','',''),(2648074,'1','206','1030',472,'Sale Id shift 257626',0.00,0.00,0.00,1915.29,0.00,'2022-01-31 20:55:42','',''),(2648075,'1','206','1030',472,'Sale Id shift 257626',0.00,0.00,0.00,1381.18,0.00,'2022-01-31 20:55:42','',''),(2648076,'1','206','1031',473,'Sale Id shift 257626',0.00,0.00,0.00,537.50,0.00,'2022-01-31 20:55:42','',''),(2648077,'1','206',NULL,473,'Sale Id shift 257626',193500.00,0.00,0.00,0.00,0.00,'2022-01-31 20:55:42','',''),(2648078,'1','206',NULL,472,'Sale Id shift 257626',543917.55,0.00,0.00,0.00,0.00,'2022-01-31 20:55:42','',''),(2648079,'1','206','1030',472,'Sale Id shift 257627',0.00,0.00,0.00,448.16,0.00,'2022-02-01 10:38:48','',''),(2648080,'1','206','1030',472,'Sale Id shift 257627',0.00,0.00,0.00,0.34,0.00,'2022-02-01 10:38:48','',''),(2648081,'1','206','1030',472,'Sale Id shift 257627',0.00,0.00,0.00,273.62,0.00,'2022-02-01 10:38:48','',''),(2648082,'1','206',NULL,472,'Sale Id shift 257627',119149.80,0.00,0.00,0.00,0.00,'2022-02-01 10:38:48','',''),(2648083,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,3712500.00,22500.00,0.00,0.00,'2022-02-01 10:45:11','',''),(2648084,'1','206','1030',472,'Sale Id shift 257628',0.00,0.00,0.00,246.36,0.00,'2022-02-01 22:00:05','',''),(2648085,'1','206','1030',472,'Sale Id shift 257628',0.00,0.00,0.00,357.94,0.00,'2022-02-01 22:00:05','',''),(2648086,'1','206','1030',472,'Sale Id shift 257628',0.00,0.00,0.00,277.63,0.00,'2022-02-01 22:00:05','',''),(2648087,'1','206','1030',472,'Sale Id shift 257628',0.00,0.00,0.00,201.43,0.00,'2022-02-01 22:00:05','',''),(2648088,'1','206','1030',472,'Sale Id shift 257628',0.00,0.00,0.00,98.36,0.00,'2022-02-01 22:00:05','',''),(2648089,'1','206','1031',473,'Sale Id shift 257628',0.00,0.00,0.00,980.56,0.00,'2022-02-01 22:00:05','',''),(2648090,'1','206',NULL,473,'Sale Id shift 257628',353001.60,0.00,0.00,0.00,0.00,'2022-02-01 22:00:05','',''),(2648091,'1','206',NULL,472,'Sale Id shift 257628',194983.80,0.00,0.00,0.00,0.00,'2022-02-01 22:00:05','',''),(2648092,'1','206','1030',472,'Sale Id shift 257629',0.00,0.00,0.00,682.71,0.00,'2022-02-02 15:54:16','',''),(2648093,'1','206','1030',472,'Sale Id shift 257629',0.00,0.00,0.00,642.39,0.00,'2022-02-02 15:54:16','',''),(2648094,'1','206','1030',472,'Sale Id shift 257629',0.00,0.00,0.00,1381.44,0.00,'2022-02-02 15:54:16','',''),(2648095,'1','206','1030',472,'Sale Id shift 257629',0.00,0.00,0.00,368.81,0.00,'2022-02-02 15:54:16','',''),(2648096,'1','206','1030',472,'Sale Id shift 257629',0.00,0.00,0.00,920.76,0.00,'2022-02-02 15:54:16','',''),(2648097,'1','206','1031',473,'Sale Id shift 257629',0.00,0.00,0.00,1190.42,0.00,'2022-02-02 15:54:16','',''),(2648098,'1','206',NULL,473,'Sale Id shift 257629',428551.20,0.00,0.00,0.00,0.00,'2022-02-02 15:54:16','',''),(2648099,'1','206',NULL,472,'Sale Id shift 257629',659358.15,0.00,0.00,0.00,0.00,'2022-02-02 15:54:16','',''),(2648100,'1','206',NULL,472,'Reception corrector for bridging 132380',0.00,0.00,0.00,22500.00,0.00,'2022-02-02 20:08:11','',''),(2648101,'1','206','1030',472,'Received from bridging 132380',0.00,0.00,22500.00,0.00,0.00,'2022-02-02 20:08:11','',''),(2648102,'1','206','1030',472,'Sale Id shift 257630',0.00,0.00,0.00,560.00,0.00,'2022-02-03 10:35:57','',''),(2648103,'1','206','1030',472,'Sale Id shift 257630',0.00,0.00,0.00,385.26,0.00,'2022-02-03 10:35:57','',''),(2648104,'1','206','1030',472,'Sale Id shift 257630',0.00,0.00,0.00,637.01,0.00,'2022-02-03 10:35:57','',''),(2648105,'1','206','1030',472,'Sale Id shift 257630',0.00,0.00,0.00,570.93,0.00,'2022-02-03 10:35:57','',''),(2648106,'1','206','1031',473,'Sale Id shift 257630',0.00,0.00,0.00,28.62,0.00,'2022-02-03 10:35:57','',''),(2648107,'1','206',NULL,473,'Sale Id shift 257630',10303.20,0.00,0.00,0.00,0.00,'2022-02-03 10:35:57','',''),(2648108,'1','206',NULL,472,'Sale Id shift 257630',355278.00,0.00,0.00,0.00,0.00,'2022-02-03 10:35:57','',''),(2648109,'1','206','1030',472,'Sale Id shift 257631',0.00,0.00,0.00,860.58,0.00,'2022-02-03 14:21:00','',''),(2648110,'1','206','1030',472,'Sale Id shift 257631',0.00,0.00,0.00,818.28,0.00,'2022-02-03 14:21:00','',''),(2648111,'1','206','1030',472,'Sale Id shift 257631',0.00,0.00,0.00,553.62,0.00,'2022-02-03 14:21:00','',''),(2648112,'1','206','1030',472,'Sale Id shift 257631',0.00,0.00,0.00,324.52,0.00,'2022-02-03 14:21:00','',''),(2648113,'1','206','1030',472,'Sale Id shift 257631',0.00,0.00,0.00,13.71,0.00,'2022-02-03 14:21:00','',''),(2648114,'1','206','1030',472,'Sale Id shift 257631',0.00,0.00,0.00,277.14,0.00,'2022-02-03 14:21:00','',''),(2648115,'1','206','1030',472,'Sale Id shift 257631',0.00,0.00,0.00,716.31,0.00,'2022-02-03 14:21:00','',''),(2648116,'1','206','1030',472,'Sale Id shift 257631',0.00,0.00,0.00,113.33,0.00,'2022-02-03 14:21:00','',''),(2648117,'1','206','1031',473,'Sale Id shift 257631',0.00,0.00,0.00,262.57,0.00,'2022-02-03 14:21:00','',''),(2648118,'1','206',NULL,473,'Sale Id shift 257631',94525.20,0.00,0.00,0.00,0.00,'2022-02-03 14:21:00','',''),(2648119,'1','206',NULL,472,'Sale Id shift 257631',606785.85,0.00,0.00,0.00,0.00,'2022-02-03 14:21:00','',''),(2648120,'1','206','1030',472,'Sale Id shift 257632',0.00,0.00,0.00,436.57,0.00,'2022-02-04 16:21:33','',''),(2648121,'1','206','1030',472,'Sale Id shift 257632',0.00,0.00,0.00,650.55,0.00,'2022-02-04 16:21:33','',''),(2648122,'1','206','1030',472,'Sale Id shift 257632',0.00,0.00,0.00,686.34,0.00,'2022-02-04 16:21:33','',''),(2648123,'1','206','1030',472,'Sale Id shift 257632',0.00,0.00,0.00,394.61,0.00,'2022-02-04 16:21:33','',''),(2648124,'1','206','1030',472,'Sale Id shift 257632',0.00,0.00,0.00,1030.57,0.00,'2022-02-04 16:21:33','',''),(2648125,'1','206','1031',473,'Sale Id shift 257632',0.00,0.00,0.00,103.63,0.00,'2022-02-04 16:21:33','',''),(2648126,'1','206',NULL,473,'Sale Id shift 257632',37306.80,0.00,0.00,0.00,0.00,'2022-02-04 16:21:33','',''),(2648127,'1','206',NULL,472,'Sale Id shift 257632',527775.60,0.00,0.00,0.00,0.00,'2022-02-04 16:21:33','',''),(2648128,'1','206','1030',472,'Sale Id shift 257633',0.00,0.00,0.00,816.43,0.00,'2022-02-04 19:08:00','',''),(2648129,'1','206','1030',472,'Sale Id shift 257633',0.00,0.00,0.00,1025.82,0.00,'2022-02-04 19:08:00','',''),(2648130,'1','206','1030',472,'Sale Id shift 257633',0.00,0.00,0.00,1143.08,0.00,'2022-02-04 19:08:00','',''),(2648131,'1','206','1030',472,'Sale Id shift 257633',0.00,0.00,0.00,416.11,0.00,'2022-02-04 19:08:00','',''),(2648132,'1','206','1030',472,'Sale Id shift 257633',0.00,0.00,0.00,51.51,0.00,'2022-02-04 19:08:00','',''),(2648133,'1','206','1030',472,'Sale Id shift 257633',0.00,0.00,0.00,1268.02,0.00,'2022-02-04 19:08:00','',''),(2648134,'1','206','1030',472,'Sale Id shift 257633',0.00,0.00,0.00,35.76,0.00,'2022-02-04 19:08:00','',''),(2648135,'1','206','1031',473,'Sale Id shift 257633',0.00,0.00,0.00,362.32,0.00,'2022-02-04 19:08:00','',''),(2648136,'1','206',NULL,473,'Sale Id shift 257633',130435.20,0.00,0.00,0.00,0.00,'2022-02-04 19:08:00','',''),(2648137,'1','206',NULL,472,'Sale Id shift 257633',784860.45,0.00,0.00,0.00,0.00,'2022-02-04 19:08:00','',''),(2648138,'1','206','1030',472,'Sale Id shift 257634',0.00,0.00,0.00,1153.62,0.00,'2022-02-05 12:38:01','',''),(2648139,'1','206','1030',472,'Sale Id shift 257634',0.00,0.00,0.00,710.44,0.00,'2022-02-05 12:38:01','',''),(2648140,'1','206','1030',472,'Sale Id shift 257634',0.00,0.00,0.00,271.31,0.00,'2022-02-05 12:38:01','',''),(2648141,'1','206','1030',472,'Sale Id shift 257634',0.00,0.00,0.00,969.06,0.00,'2022-02-05 12:38:01','',''),(2648142,'1','206','1031',473,'Sale Id shift 257634',0.00,0.00,0.00,3139.92,0.00,'2022-02-05 12:38:01','',''),(2648143,'1','206',NULL,473,'Sale Id shift 257634',1130371.20,0.00,0.00,0.00,0.00,'2022-02-05 12:38:01','',''),(2648144,'1','206',NULL,472,'Sale Id shift 257634',512230.95,0.00,0.00,0.00,0.00,'2022-02-05 12:38:01','',''),(2648145,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-02-05 16:51:43','',''),(2648146,'1','206','1030',472,'Sale Id shift 257635',0.00,0.00,0.00,1093.56,0.00,'2022-02-06 12:16:17','',''),(2648147,'1','206','1030',472,'Sale Id shift 257635',0.00,0.00,0.00,944.55,0.00,'2022-02-06 12:16:17','',''),(2648148,'1','206','1030',472,'Sale Id shift 257635',0.00,0.00,0.00,1305.97,0.00,'2022-02-06 12:16:17','',''),(2648149,'1','206','1030',472,'Sale Id shift 257635',0.00,0.00,0.00,160.73,0.00,'2022-02-06 12:16:17','',''),(2648150,'1','206','1030',472,'Sale Id shift 257635',0.00,0.00,0.00,565.44,0.00,'2022-02-06 12:16:17','',''),(2648151,'1','206','1030',472,'Sale Id shift 257635',0.00,0.00,0.00,845.15,0.00,'2022-02-06 12:16:17','',''),(2648152,'1','206','1030',472,'Sale Id shift 257635',0.00,0.00,0.00,50.99,0.00,'2022-02-06 12:16:17','',''),(2648153,'1','206','1031',473,'Sale Id shift 257635',0.00,0.00,0.00,1608.04,0.00,'2022-02-06 12:16:17','',''),(2648154,'1','206',NULL,473,'Sale Id shift 257635',611055.20,0.00,0.00,0.00,0.00,'2022-02-06 12:16:17','',''),(2648155,'1','206',NULL,472,'Sale Id shift 257635',819454.35,0.00,0.00,0.00,0.00,'2022-02-06 12:16:17','',''),(2648156,'1','206','1030',472,'Sale Id shift 257636',0.00,0.00,0.00,369.41,0.00,'2022-02-06 14:56:29','',''),(2648157,'1','206','1030',472,'Sale Id shift 257636',0.00,0.00,0.00,559.90,0.00,'2022-02-06 14:56:29','',''),(2648158,'1','206','1030',472,'Sale Id shift 257636',0.00,0.00,0.00,600.94,0.00,'2022-02-06 14:56:29','',''),(2648159,'1','206','1030',472,'Sale Id shift 257636',0.00,0.00,0.00,183.96,0.00,'2022-02-06 14:56:29','',''),(2648160,'1','206','1030',472,'Sale Id shift 257636',0.00,0.00,0.00,632.52,0.00,'2022-02-06 14:56:29','',''),(2648161,'1','206','1031',473,'Sale Id shift 257636',0.00,0.00,0.00,284.02,0.00,'2022-02-06 14:56:29','',''),(2648162,'1','206',NULL,473,'Sale Id shift 257636',107927.60,0.00,0.00,0.00,0.00,'2022-02-06 14:56:29','',''),(2648163,'1','206',NULL,472,'Sale Id shift 257636',387210.45,0.00,0.00,0.00,0.00,'2022-02-06 14:56:29','',''),(2648164,'1','206','1030',472,'Sale Id shift 257637',0.00,0.00,0.00,374.91,0.00,'2022-02-07 07:06:48','',''),(2648165,'1','206','1030',472,'Sale Id shift 257637',0.00,0.00,0.00,929.83,0.00,'2022-02-07 07:06:48','',''),(2648166,'1','206','1030',472,'Sale Id shift 257637',0.00,0.00,0.00,832.55,0.00,'2022-02-07 07:06:48','',''),(2648167,'1','206','1030',472,'Sale Id shift 257637',0.00,0.00,0.00,274.45,0.00,'2022-02-07 07:06:48','',''),(2648168,'1','206','1030',472,'Sale Id shift 257637',0.00,0.00,0.00,933.35,0.00,'2022-02-07 07:06:48','',''),(2648169,'1','206','1030',472,'Sale Id shift 257637',0.00,0.00,0.00,36.59,0.00,'2022-02-07 07:06:48','',''),(2648170,'1','206','1031',473,'Sale Id shift 257637',0.00,0.00,0.00,65.41,0.00,'2022-02-07 07:06:48','',''),(2648171,'1','206',NULL,473,'Sale Id shift 257637',24855.80,0.00,0.00,0.00,0.00,'2022-02-07 07:06:48','',''),(2648172,'1','206',NULL,472,'Sale Id shift 257637',557977.20,0.00,0.00,0.00,0.00,'2022-02-07 07:06:48','',''),(2648173,'1','206',NULL,472,'Reception corrector for bridging 132381',0.00,0.00,0.00,30000.00,0.00,'2022-02-07 17:31:10','',''),(2648174,'1','206','1030',472,'Received from bridging 132381',0.00,0.00,30000.00,0.00,0.00,'2022-02-07 17:31:10','',''),(2648175,'1','206','1030',472,'Sale Id shift 257638',0.00,0.00,0.00,741.97,0.00,'2022-02-07 21:44:05','',''),(2648176,'1','206','1030',472,'Sale Id shift 257638',0.00,0.00,0.00,575.61,0.00,'2022-02-07 21:44:05','',''),(2648177,'1','206','1030',472,'Sale Id shift 257638',0.00,0.00,0.00,959.40,0.00,'2022-02-07 21:44:05','',''),(2648178,'1','206','1030',472,'Sale Id shift 257638',0.00,0.00,0.00,674.69,0.00,'2022-02-07 21:44:05','',''),(2648179,'1','206','1030',472,'Sale Id shift 257638',0.00,0.00,0.00,19.40,0.00,'2022-02-07 21:44:05','',''),(2648180,'1','206','1031',473,'Sale Id shift 257638',0.00,0.00,0.00,1.32,0.00,'2022-02-07 21:44:05','',''),(2648181,'1','206',NULL,473,'Sale Id shift 257638',501.60,0.00,0.00,0.00,0.00,'2022-02-07 21:44:05','',''),(2648182,'1','206',NULL,472,'Sale Id shift 257638',490226.55,0.00,0.00,0.00,0.00,'2022-02-07 21:44:05','',''),(2648183,'1','206','1030',472,'Sale Id shift 257639',0.00,0.00,0.00,1472.58,0.00,'2022-02-08 11:49:30','',''),(2648184,'1','206','1030',472,'Sale Id shift 257639',0.00,0.00,0.00,2135.44,0.00,'2022-02-08 11:49:30','',''),(2648185,'1','206','1030',472,'Sale Id shift 257639',0.00,0.00,0.00,1881.88,0.00,'2022-02-08 11:49:30','',''),(2648186,'1','206','1030',472,'Sale Id shift 257639',0.00,0.00,0.00,1253.83,0.00,'2022-02-08 11:49:30','',''),(2648187,'1','206','1030',472,'Sale Id shift 257639',0.00,0.00,0.00,425.40,0.00,'2022-02-08 11:49:30','',''),(2648188,'1','206','1030',472,'Sale Id shift 257639',0.00,0.00,0.00,1403.49,0.00,'2022-02-08 11:49:30','',''),(2648189,'1','206','1030',472,'Sale Id shift 257639',0.00,0.00,0.00,1896.27,0.00,'2022-02-08 11:49:30','',''),(2648190,'1','206','1030',472,'Sale Id shift 257639',0.00,0.00,0.00,255.49,0.00,'2022-02-08 11:49:30','',''),(2648191,'1','206','1031',473,'Sale Id shift 257639',0.00,0.00,0.00,22.89,0.00,'2022-02-08 11:49:30','',''),(2648192,'1','206',NULL,473,'Sale Id shift 257639',8698.20,0.00,0.00,0.00,0.00,'2022-02-08 11:49:30','',''),(2648193,'1','206',NULL,472,'Sale Id shift 257639',1769522.70,0.00,0.00,0.00,0.00,'2022-02-08 11:49:30','',''),(2648194,'1','206','1030',472,'Sale Id shift 257640',0.00,0.00,0.00,605.34,0.00,'2022-02-08 19:38:10','',''),(2648195,'1','206','1030',472,'Sale Id shift 257640',0.00,0.00,0.00,1788.60,0.00,'2022-02-08 19:38:10','',''),(2648196,'1','206','1030',472,'Sale Id shift 257640',0.00,0.00,0.00,1741.12,0.00,'2022-02-08 19:38:10','',''),(2648197,'1','206','1030',472,'Sale Id shift 257640',0.00,0.00,0.00,29.05,0.00,'2022-02-08 19:38:10','',''),(2648198,'1','206','1030',472,'Sale Id shift 257640',0.00,0.00,0.00,844.64,0.00,'2022-02-08 19:38:10','',''),(2648199,'1','206','1030',472,'Sale Id shift 257640',0.00,0.00,0.00,1374.94,0.00,'2022-02-08 19:38:10','',''),(2648200,'1','206','1031',473,'Sale Id shift 257640',0.00,0.00,0.00,278.96,0.00,'2022-02-08 19:38:10','',''),(2648201,'1','206',NULL,473,'Sale Id shift 257640',106004.80,0.00,0.00,0.00,0.00,'2022-02-08 19:38:10','',''),(2648202,'1','206',NULL,472,'Sale Id shift 257640',1053308.85,0.00,0.00,0.00,0.00,'2022-02-08 19:38:10','',''),(2648203,'1','206','1031',473,'Sale Id shift 257641',0.00,0.00,0.00,5.26,0.00,'2022-02-08 19:44:46','',''),(2648204,'1','206',NULL,473,'Sale Id shift 257641',1998.80,0.00,0.00,0.00,0.00,'2022-02-08 19:44:46','',''),(2648205,'1','206','1031',473,'Sale Id shift 257642',0.00,0.00,0.00,2325.48,0.00,'2022-02-10 14:12:14','',''),(2648206,'1','206',NULL,473,'Sale Id shift 257642',906937.20,0.00,0.00,0.00,0.00,'2022-02-10 14:12:14','',''),(2648207,'1','206','1030',0,'Tank level zero out for dipping',0.00,0.00,0.00,48109.67,0.00,'2022-02-10 15:48:19','',''),(2648208,'1','206','1030',0,'Inventory adjustment from tank dipping to 1700',0.00,0.00,1700.00,0.00,0.00,'2022-02-10 15:48:19','',''),(2648209,'1','206',NULL,472,'Inventory reconciliation by NASIR  ABDULRASHEED',0.00,0.00,1.00,46409.49,0.00,'2022-02-12 12:10:45','',''),(2648210,'1','206','1031',473,'Sale Id shift 257643',0.00,0.00,0.00,326.17,0.00,'2022-02-13 10:10:16','',''),(2648211,'1','206',NULL,473,'Sale Id shift 257643',127206.30,0.00,0.00,0.00,0.00,'2022-02-13 10:10:16','',''),(2648212,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,2805000.00,17000.00,0.00,0.00,'2022-02-13 13:26:16','',''),(2648213,'1','206',NULL,472,'Reception corrector for bridging 132382',0.00,0.00,0.00,17000.00,0.00,'2022-02-13 13:30:03','',''),(2648214,'1','206','1030',472,'Received from bridging 132382',0.00,0.00,17000.00,0.00,0.00,'2022-02-13 13:30:03','',''),(2648215,'1','206','1030',472,'Sale Id shift 257644',0.00,0.00,0.00,1986.14,0.00,'2022-02-13 15:40:06','',''),(2648216,'1','206','1030',472,'Sale Id shift 257644',0.00,0.00,0.00,2840.33,0.00,'2022-02-13 15:40:06','',''),(2648217,'1','206','1030',472,'Sale Id shift 257644',0.00,0.00,0.00,407.14,0.00,'2022-02-13 15:40:06','',''),(2648218,'1','206','1030',472,'Sale Id shift 257644',0.00,0.00,0.00,4970.60,0.00,'2022-02-13 15:40:06','',''),(2648219,'1','206','1031',473,'Sale Id shift 257644',0.00,0.00,0.00,1132.50,0.00,'2022-02-13 15:40:06','',''),(2648220,'1','206',NULL,473,'Sale Id shift 257644',453000.00,0.00,0.00,0.00,0.00,'2022-02-13 15:40:06','',''),(2648221,'1','206',NULL,472,'Sale Id shift 257644',1683694.65,0.00,0.00,0.00,0.00,'2022-02-13 15:40:06','',''),(2648222,'1','206','1030',472,'Sale Id shift 257645',0.00,0.00,0.00,42.42,0.00,'2022-02-14 10:02:16','',''),(2648223,'1','206','1030',472,'Sale Id shift 257645',0.00,0.00,0.00,467.40,0.00,'2022-02-14 10:02:16','',''),(2648224,'1','206','1031',473,'Sale Id shift 257645',0.00,0.00,0.00,225.00,0.00,'2022-02-14 10:02:16','',''),(2648225,'1','206',NULL,473,'Sale Id shift 257645',90000.00,0.00,0.00,0.00,0.00,'2022-02-14 10:02:16','',''),(2648226,'1','206',NULL,472,'Sale Id shift 257645',84120.30,0.00,0.00,0.00,0.00,'2022-02-14 10:02:16','',''),(2648227,'1','206','1030',472,'Sale Id shift 257646',0.00,0.00,0.00,1690.01,0.00,'2022-02-15 10:44:53','',''),(2648228,'1','206','1030',472,'Sale Id shift 257646',0.00,0.00,0.00,24.25,0.00,'2022-02-15 10:44:53','',''),(2648229,'1','206','1030',472,'Sale Id shift 257646',0.00,0.00,0.00,3655.25,0.00,'2022-02-15 10:44:53','',''),(2648230,'1','206','1031',473,'Sale Id shift 257646',0.00,0.00,0.00,406.25,0.00,'2022-02-15 10:44:53','',''),(2648231,'1','206',NULL,473,'Sale Id shift 257646',162500.00,0.00,0.00,0.00,0.00,'2022-02-15 10:44:53','',''),(2648232,'1','206',NULL,472,'Sale Id shift 257646',885969.15,0.00,0.00,0.00,0.00,'2022-02-15 10:44:53','',''),(2648233,'1','206','1030',472,'Sale Id shift 257647',0.00,0.00,0.00,496.95,0.00,'2022-02-15 21:02:08','',''),(2648234,'1','206','1031',473,'Sale Id shift 257647',0.00,0.00,0.00,4371.83,0.00,'2022-02-15 21:02:08','',''),(2648235,'1','206',NULL,473,'Sale Id shift 257647',1748732.00,0.00,0.00,0.00,0.00,'2022-02-15 21:02:08','',''),(2648236,'1','206',NULL,472,'Sale Id shift 257647',81996.75,0.00,0.00,0.00,0.00,'2022-02-15 21:02:08','',''),(2648237,'1','206','1030',472,'Sale Id shift 257648',0.00,0.00,0.00,473.55,0.00,'2022-02-15 21:13:49','',''),(2648238,'1','206','1031',473,'Sale Id shift 257648',0.00,0.00,0.00,350.00,0.00,'2022-02-15 21:13:49','',''),(2648239,'1','206',NULL,473,'Sale Id shift 257648',140000.00,0.00,0.00,0.00,0.00,'2022-02-15 21:13:49','',''),(2648240,'1','206',NULL,472,'Sale Id shift 257648',78135.75,0.00,0.00,0.00,0.00,'2022-02-15 21:13:49','',''),(2648241,'1','206','1031',473,'Sale Id shift 257649',0.00,0.00,0.00,1300.00,0.00,'2022-02-16 07:19:35','',''),(2648242,'1','206',NULL,473,'Sale Id shift 257649',533000.00,0.00,0.00,0.00,0.00,'2022-02-16 07:19:35','',''),(2648243,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,2805000.00,17000.00,0.00,0.00,'2022-02-16 18:48:09','',''),(2648244,'1','206',NULL,472,'Reception corrector for bridging 132383',0.00,0.00,0.00,17000.00,0.00,'2022-02-16 20:16:40','',''),(2648245,'1','206','1030',472,'Received from bridging 132383',0.00,0.00,17000.00,0.00,0.00,'2022-02-16 20:16:40','',''),(2648246,'1','206','1030',472,'Sale Id shift 257650',0.00,0.00,0.00,10.47,0.00,'2022-02-16 20:26:57','',''),(2648247,'1','206','1030',472,'Sale Id shift 257650',0.00,0.00,0.00,10.12,0.00,'2022-02-16 20:26:57','',''),(2648248,'1','206','1030',472,'Sale Id shift 257650',0.00,0.00,0.00,453.41,0.00,'2022-02-16 20:26:57','',''),(2648249,'1','206','1030',472,'Sale Id shift 257650',0.00,0.00,0.00,16.61,0.00,'2022-02-16 20:26:57','',''),(2648250,'1','206','1030',472,'Sale Id shift 257650',0.00,0.00,0.00,10.54,0.00,'2022-02-16 20:26:57','',''),(2648251,'1','206','1030',472,'Sale Id shift 257650',0.00,0.00,0.00,10.14,0.00,'2022-02-16 20:26:57','',''),(2648252,'1','206','1030',472,'Sale Id shift 257650',0.00,0.00,0.00,4456.91,0.00,'2022-02-16 20:26:57','',''),(2648253,'1','206','1030',472,'Sale Id shift 257650',0.00,0.00,0.00,3483.91,0.00,'2022-02-16 20:26:57','',''),(2648254,'1','206','1031',473,'Sale Id shift 257650',0.00,0.00,0.00,149.53,0.00,'2022-02-16 20:26:57','',''),(2648255,'1','206',NULL,473,'Sale Id shift 257650',61307.30,0.00,0.00,0.00,0.00,'2022-02-16 20:26:57','',''),(2648256,'1','206',NULL,472,'Sale Id shift 257650',1394598.15,0.00,0.00,0.00,0.00,'2022-02-16 20:26:57','',''),(2648257,'1','206','1030',472,'Sale Id shift 257651',0.00,0.00,0.00,2064.36,0.00,'2022-02-17 10:47:22','',''),(2648258,'1','206','1030',472,'Sale Id shift 257651',0.00,0.00,0.00,1236.21,0.00,'2022-02-17 10:47:22','',''),(2648259,'1','206','1030',472,'Sale Id shift 257651',0.00,0.00,0.00,36.36,0.00,'2022-02-17 10:47:22','',''),(2648260,'1','206','1030',472,'Sale Id shift 257651',0.00,0.00,0.00,507.56,0.00,'2022-02-17 10:47:22','',''),(2648261,'1','206','1031',473,'Sale Id shift 257651',0.00,0.00,0.00,1128.54,0.00,'2022-02-17 10:47:22','',''),(2648262,'1','206',NULL,473,'Sale Id shift 257651',462701.40,0.00,0.00,0.00,0.00,'2022-02-17 10:47:22','',''),(2648263,'1','206',NULL,472,'Sale Id shift 257651',634340.85,0.00,0.00,0.00,0.00,'2022-02-17 10:47:22','',''),(2648264,'1','206','1030',472,'Sale Id shift 257652',0.00,0.00,0.00,130.30,0.00,'2022-02-18 08:45:12','',''),(2648265,'1','206','1030',472,'Sale Id shift 257652',0.00,0.00,0.00,152.10,0.00,'2022-02-18 08:45:12','',''),(2648266,'1','206','1030',472,'Sale Id shift 257652',0.00,0.00,0.00,1368.94,0.00,'2022-02-18 08:45:12','',''),(2648267,'1','206',NULL,472,'Sale Id shift 257652',272471.10,0.00,0.00,0.00,0.00,'2022-02-18 08:45:12','',''),(2648268,'1','206','1030',472,'Sale Id shift 257653',0.00,0.00,0.00,20.60,0.00,'2022-02-18 20:05:35','',''),(2648269,'1','206','1030',472,'Sale Id shift 257653',0.00,0.00,0.00,149.99,0.00,'2022-02-18 20:05:35','',''),(2648270,'1','206','1030',472,'Sale Id shift 257653',0.00,0.00,0.00,140.66,0.00,'2022-02-18 20:05:35','',''),(2648271,'1','206','1030',472,'Sale Id shift 257653',0.00,0.00,0.00,100.97,0.00,'2022-02-18 20:05:35','',''),(2648272,'1','206','1030',472,'Sale Id shift 257653',0.00,0.00,0.00,690.89,0.00,'2022-02-18 20:05:35','',''),(2648273,'1','206','1030',472,'Sale Id shift 257653',0.00,0.00,0.00,294.09,0.00,'2022-02-18 20:05:35','',''),(2648274,'1','206','1030',472,'Sale Id shift 257653',0.00,0.00,0.00,663.17,0.00,'2022-02-18 20:05:35','',''),(2648275,'1','206',NULL,472,'Sale Id shift 257653',339961.05,0.00,0.00,0.00,0.00,'2022-02-18 20:05:35','',''),(2648276,'1','206','1030',472,'Sale Id shift 257654',0.00,0.00,0.00,165.57,0.00,'2022-02-18 21:46:51','',''),(2648277,'1','206','1030',472,'Sale Id shift 257654',0.00,0.00,0.00,264.37,0.00,'2022-02-18 21:46:51','',''),(2648278,'1','206','1030',472,'Sale Id shift 257654',0.00,0.00,0.00,152.28,0.00,'2022-02-18 21:46:51','',''),(2648279,'1','206','1030',472,'Sale Id shift 257654',0.00,0.00,0.00,390.73,0.00,'2022-02-18 21:46:51','',''),(2648280,'1','206',NULL,472,'Sale Id shift 257654',160536.75,0.00,0.00,0.00,0.00,'2022-02-18 21:46:51','',''),(2648281,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-02-20 20:12:37','',''),(2648282,'1','206',NULL,472,'Reception corrector for bridging 132384',0.00,0.00,0.00,30000.00,0.00,'2022-02-21 09:46:23','',''),(2648283,'1','206','1030',472,'Received from bridging 132384',0.00,0.00,30000.00,0.00,0.00,'2022-02-21 09:46:23','',''),(2648284,'1','206','1030',472,'Sale Id shift 257655',0.00,0.00,0.00,3140.04,0.00,'2022-02-21 11:35:54','',''),(2648285,'1','206','1030',472,'Sale Id shift 257655',0.00,0.00,0.00,1928.78,0.00,'2022-02-21 11:35:54','',''),(2648286,'1','206','1030',472,'Sale Id shift 257655',0.00,0.00,0.00,2826.77,0.00,'2022-02-21 11:35:54','',''),(2648287,'1','206','1030',472,'Sale Id shift 257655',0.00,0.00,0.00,4344.95,0.00,'2022-02-21 11:35:54','',''),(2648288,'1','206','1031',473,'Sale Id shift 257655',0.00,0.00,0.00,94.33,0.00,'2022-02-21 11:35:54','',''),(2648289,'1','206',NULL,473,'Sale Id shift 257655',38675.30,0.00,0.00,0.00,0.00,'2022-02-21 11:35:54','',''),(2648290,'1','206',NULL,472,'Sale Id shift 257655',2019689.10,0.00,0.00,0.00,0.00,'2022-02-21 11:35:54','',''),(2648291,'1','206','1030',472,'Sale Id shift 257656',0.00,0.00,0.00,1793.57,0.00,'2022-02-21 11:45:11','',''),(2648292,'1','206','1030',472,'Sale Id shift 257656',0.00,0.00,0.00,3117.79,0.00,'2022-02-21 11:45:11','',''),(2648293,'1','206','1030',472,'Sale Id shift 257656',0.00,0.00,0.00,895.69,0.00,'2022-02-21 11:45:11','',''),(2648294,'1','206',NULL,472,'Sale Id shift 257656',958163.25,0.00,0.00,0.00,0.00,'2022-02-21 11:45:11','',''),(2648295,'1','206','1030',472,'Sale Id shift 257657',0.00,0.00,0.00,1294.07,0.00,'2022-02-21 12:09:33','',''),(2648296,'1','206','1030',472,'Sale Id shift 257657',0.00,0.00,0.00,240.80,0.00,'2022-02-21 12:09:33','',''),(2648297,'1','206','1030',472,'Sale Id shift 257657',0.00,0.00,0.00,121.33,0.00,'2022-02-21 12:09:33','',''),(2648298,'1','206','1030',472,'Sale Id shift 257657',0.00,0.00,0.00,1369.52,0.00,'2022-02-21 12:09:33','',''),(2648299,'1','206','1030',472,'Sale Id shift 257657',0.00,0.00,0.00,1990.43,0.00,'2022-02-21 12:09:33','',''),(2648300,'1','206',NULL,472,'Sale Id shift 257657',827664.75,0.00,0.00,0.00,0.00,'2022-02-21 12:09:33','',''),(2648301,'1','206','1030',472,'Sale Id shift 257658',0.00,0.00,0.00,2092.79,0.00,'2022-02-21 12:20:01','',''),(2648302,'1','206','1030',472,'Sale Id shift 257658',0.00,0.00,0.00,480.98,0.00,'2022-02-21 12:20:01','',''),(2648303,'1','206','1030',472,'Sale Id shift 257658',0.00,0.00,0.00,68.94,0.00,'2022-02-21 12:20:01','',''),(2648304,'1','206','1030',472,'Sale Id shift 257658',0.00,0.00,0.00,1848.69,0.00,'2022-02-21 12:20:01','',''),(2648305,'1','206','1030',472,'Sale Id shift 257658',0.00,0.00,0.00,1117.71,0.00,'2022-02-21 12:20:01','',''),(2648306,'1','206',NULL,472,'Sale Id shift 257658',925503.15,0.00,0.00,0.00,0.00,'2022-02-21 12:20:01','',''),(2648307,'1','206','1030',472,'Sale Id shift 257659',0.00,0.00,0.00,715.83,0.00,'2022-02-22 11:34:03','',''),(2648308,'1','206',NULL,472,'Sale Id shift 257659',118111.95,0.00,0.00,0.00,0.00,'2022-02-22 11:34:03','',''),(2648309,'1','206','1030',472,'Sale Id shift 257660',0.00,0.00,0.00,654.91,0.00,'2022-02-28 15:51:26','',''),(2648310,'1','206',NULL,472,'Sale Id shift 257660',108060.15,0.00,0.00,0.00,0.00,'2022-02-28 15:51:26','',''),(2648311,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-02 11:05:45','',''),(2648312,'1','206',NULL,472,'Reception corrector for bridging 132385',0.00,0.00,0.00,30000.00,0.00,'2022-03-02 13:28:38','',''),(2648313,'1','206','1030',472,'Received from bridging 132385',0.00,0.00,30000.00,0.00,0.00,'2022-03-02 13:28:38','',''),(2648314,'1','206','1030',472,'Sale Id shift 257661',0.00,0.00,0.00,139.55,0.00,'2022-03-02 13:42:18','',''),(2648315,'1','206','1030',472,'Sale Id shift 257661',0.00,0.00,0.00,226.42,0.00,'2022-03-02 13:42:18','',''),(2648316,'1','206','1030',472,'Sale Id shift 257661',0.00,0.00,0.00,348.53,0.00,'2022-03-02 13:42:18','',''),(2648317,'1','206','1030',472,'Sale Id shift 257661',0.00,0.00,0.00,424.35,0.00,'2022-03-02 13:42:18','',''),(2648318,'1','206','1030',472,'Sale Id shift 257661',0.00,0.00,0.00,34.10,0.00,'2022-03-02 13:42:18','',''),(2648319,'1','206','1030',472,'Sale Id shift 257661',0.00,0.00,0.00,627.80,0.00,'2022-03-02 13:42:18','',''),(2648320,'1','206','1030',472,'Sale Id shift 257661',0.00,0.00,0.00,830.50,0.00,'2022-03-02 13:42:18','',''),(2648321,'1','206','1030',472,'Sale Id shift 257661',0.00,0.00,0.00,395.03,0.00,'2022-03-02 13:42:18','',''),(2648322,'1','206',NULL,472,'Sale Id shift 257661',499336.20,0.00,0.00,0.00,0.00,'2022-03-02 13:42:18','',''),(2648323,'1','206','1030',472,'Sale Id shift 257662',0.00,0.00,0.00,209.65,0.00,'2022-03-02 13:52:14','',''),(2648324,'1','206','1030',472,'Sale Id shift 257662',0.00,0.00,0.00,1661.40,0.00,'2022-03-02 13:52:14','',''),(2648325,'1','206','1030',472,'Sale Id shift 257662',0.00,0.00,0.00,1077.44,0.00,'2022-03-02 13:52:14','',''),(2648326,'1','206','1030',472,'Sale Id shift 257662',0.00,0.00,0.00,211.61,0.00,'2022-03-02 13:52:14','',''),(2648327,'1','206','1030',472,'Sale Id shift 257662',0.00,0.00,0.00,150.56,0.00,'2022-03-02 13:52:14','',''),(2648328,'1','206','1030',472,'Sale Id shift 257662',0.00,0.00,0.00,2020.32,0.00,'2022-03-02 13:52:14','',''),(2648329,'1','206','1030',472,'Sale Id shift 257662',0.00,0.00,0.00,1578.77,0.00,'2022-03-02 13:52:14','',''),(2648330,'1','206','1030',472,'Sale Id shift 257662',0.00,0.00,0.00,489.27,0.00,'2022-03-02 13:52:14','',''),(2648331,'1','206',NULL,472,'Sale Id shift 257662',1220838.30,0.00,0.00,0.00,0.00,'2022-03-02 13:52:14','',''),(2648332,'1','206','1030',472,'Sale Id shift 257663',0.00,0.00,0.00,84.00,0.00,'2022-03-02 15:48:07','',''),(2648333,'1','206','1030',472,'Sale Id shift 257663',0.00,0.00,0.00,0.01,0.00,'2022-03-02 15:48:07','',''),(2648334,'1','206','1030',472,'Sale Id shift 257663',0.00,0.00,0.00,679.77,0.00,'2022-03-02 15:48:07','',''),(2648335,'1','206','1030',472,'Sale Id shift 257663',0.00,0.00,0.00,937.47,0.00,'2022-03-02 15:48:07','',''),(2648336,'1','206','1030',472,'Sale Id shift 257663',0.00,0.00,0.00,402.92,0.00,'2022-03-02 15:48:07','',''),(2648337,'1','206','1030',472,'Sale Id shift 257663',0.00,0.00,0.00,2800.73,0.00,'2022-03-02 15:48:07','',''),(2648338,'1','206',NULL,472,'Sale Id shift 257663',809308.50,0.00,0.00,0.00,0.00,'2022-03-02 15:48:07','',''),(2648339,'1','206','1030',472,'Sale Id shift 257664',0.00,0.00,0.00,263.75,0.00,'2022-03-03 16:28:24','',''),(2648340,'1','206','1030',472,'Sale Id shift 257664',0.00,0.00,0.00,3384.41,0.00,'2022-03-03 16:28:24','',''),(2648341,'1','206','1030',472,'Sale Id shift 257664',0.00,0.00,0.00,792.30,0.00,'2022-03-03 16:28:24','',''),(2648342,'1','206',NULL,472,'Sale Id shift 257664',732675.90,0.00,0.00,0.00,0.00,'2022-03-03 16:28:24','',''),(2648343,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,3630000.00,22000.00,0.00,0.00,'2022-03-05 11:28:16','',''),(2648344,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,3465000.00,21000.00,0.00,0.00,'2022-03-05 11:28:31','',''),(2648345,'1','206',NULL,472,'Reception corrector for bridging 132386',0.00,0.00,0.00,22000.00,0.00,'2022-03-05 11:36:47','',''),(2648346,'1','206','1030',472,'Received from bridging 132386',0.00,0.00,22000.00,0.00,0.00,'2022-03-05 11:36:47','',''),(2648347,'1','206',NULL,472,'Reception corrector for bridging 132387',0.00,0.00,0.00,21000.00,0.00,'2022-03-05 11:37:02','',''),(2648348,'1','206','1030',472,'Received from bridging 132387',0.00,0.00,21000.00,0.00,0.00,'2022-03-05 11:37:02','',''),(2648349,'1','206','1030',472,'Sale Id shift 257665',0.00,0.00,0.00,534.13,0.00,'2022-03-05 17:06:21','',''),(2648350,'1','206','1030',472,'Sale Id shift 257665',0.00,0.00,0.00,3149.18,0.00,'2022-03-05 17:06:21','',''),(2648351,'1','206',NULL,472,'Sale Id shift 257665',607746.15,0.00,0.00,0.00,0.00,'2022-03-05 17:06:21','',''),(2648352,'1','206','1030',472,'Sale Id shift 257666',0.00,0.00,0.00,483.79,0.00,'2022-03-05 17:19:05','',''),(2648353,'1','206','1030',472,'Sale Id shift 257666',0.00,0.00,0.00,482.58,0.00,'2022-03-05 17:19:05','',''),(2648354,'1','206','1030',472,'Sale Id shift 257666',0.00,0.00,0.00,2008.54,0.00,'2022-03-05 17:19:05','',''),(2648355,'1','206','1030',472,'Sale Id shift 257666',0.00,0.00,0.00,1122.56,0.00,'2022-03-05 17:19:05','',''),(2648356,'1','206',NULL,472,'Sale Id shift 257666',676082.55,0.00,0.00,0.00,0.00,'2022-03-05 17:19:05','',''),(2648357,'1','206','1030',472,'Sale Id shift 257667',0.00,0.00,0.00,1585.16,0.00,'2022-03-05 18:20:25','',''),(2648358,'1','206','1030',472,'Sale Id shift 257667',0.00,0.00,0.00,3340.87,0.00,'2022-03-05 18:20:25','',''),(2648359,'1','206','1030',472,'Sale Id shift 257667',0.00,0.00,0.00,115.01,0.00,'2022-03-05 18:20:25','',''),(2648360,'1','206',NULL,472,'Sale Id shift 257667',831771.60,0.00,0.00,0.00,0.00,'2022-03-05 18:20:25','',''),(2648361,'1','206','1030',472,'Sale Id shift 257668',0.00,0.00,0.00,1222.10,0.00,'2022-03-06 10:04:20','',''),(2648362,'1','206','1030',472,'Sale Id shift 257668',0.00,0.00,0.00,2935.11,0.00,'2022-03-06 10:04:20','',''),(2648363,'1','206','1030',472,'Sale Id shift 257668',0.00,0.00,0.00,3932.89,0.00,'2022-03-06 10:04:20','',''),(2648364,'1','206',NULL,472,'Sale Id shift 257668',1334866.50,0.00,0.00,0.00,0.00,'2022-03-06 10:04:20','',''),(2648365,'1','206','1030',472,'Sale Id shift 257669',0.00,0.00,0.00,2152.81,0.00,'2022-03-07 09:05:40','',''),(2648366,'1','206','1030',472,'Sale Id shift 257669',0.00,0.00,0.00,1725.07,0.00,'2022-03-07 09:05:40','',''),(2648367,'1','206','1030',472,'Sale Id shift 257669',0.00,0.00,0.00,2374.89,0.00,'2022-03-07 09:05:40','',''),(2648368,'1','206',NULL,472,'Sale Id shift 257669',1031707.05,0.00,0.00,0.00,0.00,'2022-03-07 09:05:40','',''),(2648369,'1','206','1030',472,'Sale Id shift 257670',0.00,0.00,0.00,1563.07,0.00,'2022-03-07 17:10:26','',''),(2648370,'1','206','1030',472,'Sale Id shift 257670',0.00,0.00,0.00,268.78,0.00,'2022-03-07 17:10:26','',''),(2648371,'1','206','1030',472,'Sale Id shift 257670',0.00,0.00,0.00,2913.44,0.00,'2022-03-07 17:10:26','',''),(2648372,'1','206',NULL,472,'Sale Id shift 257670',782972.85,0.00,0.00,0.00,0.00,'2022-03-07 17:10:26','',''),(2648373,'1','206','1030',472,'Sale Id shift 257671',0.00,0.00,0.00,516.40,0.00,'2022-03-08 12:11:37','',''),(2648374,'1','206','1030',472,'Sale Id shift 257671',0.00,0.00,0.00,4216.82,0.00,'2022-03-08 12:11:37','',''),(2648375,'1','206','1030',472,'Sale Id shift 257671',0.00,0.00,0.00,4007.43,0.00,'2022-03-08 12:11:37','',''),(2648376,'1','206',NULL,472,'Sale Id shift 257671',1442207.25,0.00,0.00,0.00,0.00,'2022-03-08 12:11:37','',''),(2648377,'1','206','1030',472,'Sale Id shift 257672',0.00,0.00,0.00,2166.25,0.00,'2022-03-08 15:22:47','',''),(2648378,'1','206','1030',472,'Sale Id shift 257672',0.00,0.00,0.00,54.81,0.00,'2022-03-08 15:22:47','',''),(2648379,'1','206','1030',472,'Sale Id shift 257672',0.00,0.00,0.00,3281.07,0.00,'2022-03-08 15:22:47','',''),(2648380,'1','206','1030',472,'Sale Id shift 257672',0.00,0.00,0.00,225.41,0.00,'2022-03-08 15:22:47','',''),(2648381,'1','206',NULL,472,'Sale Id shift 257672',945044.10,0.00,0.00,0.00,0.00,'2022-03-08 15:22:47','',''),(2648382,'1','206','1030',472,'Sale Id shift 257673',0.00,0.00,0.00,934.98,0.00,'2022-03-09 06:20:48','',''),(2648383,'1','206','1030',472,'Sale Id shift 257673',0.00,0.00,0.00,2535.59,0.00,'2022-03-09 06:20:48','',''),(2648384,'1','206',NULL,472,'Sale Id shift 257673',572644.05,0.00,0.00,0.00,0.00,'2022-03-09 06:20:48','',''),(2648385,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-09 06:21:02','',''),(2648386,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-09 06:21:14','',''),(2648387,'1','206',NULL,472,'Reception corrector for bridging 132389',0.00,0.00,0.00,30000.00,0.00,'2022-03-09 11:53:30','',''),(2648388,'1','206','1030',472,'Received from bridging 132389',0.00,0.00,30000.00,0.00,0.00,'2022-03-09 11:53:30','',''),(2648389,'1','206',NULL,472,'Reception corrector for bridging 132388',0.00,0.00,0.00,30000.00,0.00,'2022-03-09 11:53:46','',''),(2648390,'1','206','1030',472,'Received from bridging 132388',0.00,0.00,30000.00,0.00,0.00,'2022-03-09 11:53:46','',''),(2648391,'1','206','1030',472,'Sale Id shift 257674',0.00,0.00,0.00,3496.18,0.00,'2022-03-09 12:26:25','',''),(2648392,'1','206','1030',472,'Sale Id shift 257674',0.00,0.00,0.00,1812.87,0.00,'2022-03-09 12:26:25','',''),(2648393,'1','206','1030',472,'Sale Id shift 257674',0.00,0.00,0.00,3310.89,0.00,'2022-03-09 12:26:25','',''),(2648394,'1','206','1030',472,'Sale Id shift 257674',0.00,0.00,0.00,3595.03,0.00,'2022-03-09 12:26:26','',''),(2648395,'1','206','1030',472,'Sale Id shift 257674',0.00,0.00,0.00,1316.50,0.00,'2022-03-09 12:26:26','',''),(2648396,'1','206',NULL,472,'Sale Id shift 257674',2232692.55,0.00,0.00,0.00,0.00,'2022-03-09 12:26:26','',''),(2648397,'1','206','1030',472,'Sale Id shift 257675',0.00,0.00,0.00,329.43,0.00,'2022-03-10 07:35:58','',''),(2648398,'1','206','1030',472,'Sale Id shift 257675',0.00,0.00,0.00,2029.15,0.00,'2022-03-10 07:35:58','',''),(2648399,'1','206','1030',472,'Sale Id shift 257675',0.00,0.00,0.00,5689.89,0.00,'2022-03-10 07:35:58','',''),(2648400,'1','206','1030',472,'Sale Id shift 257675',0.00,0.00,0.00,116.16,0.00,'2022-03-10 07:35:58','',''),(2648401,'1','206','1030',472,'Sale Id shift 257675',0.00,0.00,0.00,5948.89,0.00,'2022-03-10 07:35:58','',''),(2648402,'1','206','1030',472,'Sale Id shift 257675',0.00,0.00,0.00,57.47,0.00,'2022-03-10 07:35:58','',''),(2648403,'1','206',NULL,472,'Sale Id shift 257675',2338213.35,0.00,0.00,0.00,0.00,'2022-03-10 07:35:58','',''),(2648404,'1','206','1030',472,'Sale Id shift 257676',0.00,0.00,0.00,3531.62,0.00,'2022-03-10 14:34:13','',''),(2648405,'1','206','1030',472,'Sale Id shift 257676',0.00,0.00,0.00,3257.17,0.00,'2022-03-10 14:34:13','',''),(2648406,'1','206','1030',472,'Sale Id shift 257676',0.00,0.00,0.00,406.96,0.00,'2022-03-10 14:34:13','',''),(2648407,'1','206','1030',472,'Sale Id shift 257676',0.00,0.00,0.00,158.43,0.00,'2022-03-10 14:34:13','',''),(2648408,'1','206','1030',472,'Sale Id shift 257676',0.00,0.00,0.00,4006.11,0.00,'2022-03-10 14:34:13','',''),(2648409,'1','206','1030',472,'Sale Id shift 257676',0.00,0.00,0.00,207.54,0.00,'2022-03-10 14:34:13','',''),(2648410,'1','206',NULL,472,'Sale Id shift 257676',1908691.95,0.00,0.00,0.00,0.00,'2022-03-10 14:34:13','',''),(2648411,'1','206','1030',472,'Sale Id shift 257677',0.00,0.00,0.00,4357.88,0.00,'2022-03-11 11:20:17','',''),(2648412,'1','206','1030',472,'Sale Id shift 257677',0.00,0.00,0.00,242.30,0.00,'2022-03-11 11:20:17','',''),(2648413,'1','206','1030',472,'Sale Id shift 257677',0.00,0.00,0.00,0.14,0.00,'2022-03-11 11:20:17','',''),(2648414,'1','206','1030',472,'Sale Id shift 257677',0.00,0.00,0.00,4645.12,0.00,'2022-03-11 11:20:17','',''),(2648415,'1','206','1030',472,'Sale Id shift 257677',0.00,0.00,0.00,832.16,0.00,'2022-03-11 11:20:17','',''),(2648416,'1','206',NULL,472,'Sale Id shift 257677',1662804.00,0.00,0.00,0.00,0.00,'2022-03-11 11:20:17','',''),(2648417,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-12 16:39:01','',''),(2648418,'1','206','1030',472,'Sale Id shift 257678',0.00,0.00,0.00,2682.79,0.00,'2022-03-12 16:39:21','',''),(2648419,'1','206','1030',472,'Sale Id shift 257678',0.00,0.00,0.00,258.04,0.00,'2022-03-12 16:39:21','',''),(2648420,'1','206','1030',472,'Sale Id shift 257678',0.00,0.00,0.00,3262.83,0.00,'2022-03-12 16:39:21','',''),(2648421,'1','206','1030',472,'Sale Id shift 257678',0.00,0.00,0.00,665.89,0.00,'2022-03-12 16:39:21','',''),(2648422,'1','206',NULL,472,'Sale Id shift 257678',1133475.75,0.00,0.00,0.00,0.00,'2022-03-12 16:39:21','',''),(2648423,'1','206',NULL,472,'Reception corrector for bridging 132390',0.00,0.00,0.00,45000.00,0.00,'2022-03-12 16:42:21','',''),(2648424,'1','206','1030',472,'Received from bridging 132390',0.00,0.00,45000.00,0.00,0.00,'2022-03-12 16:42:21','',''),(2648425,'1','206','1030',472,'Sale Id shift 257679',0.00,0.00,0.00,267.94,0.00,'2022-03-12 16:44:34','',''),(2648426,'1','206','1030',472,'Sale Id shift 257679',0.00,0.00,0.00,2078.09,0.00,'2022-03-12 16:44:34','',''),(2648427,'1','206',NULL,472,'Sale Id shift 257679',387094.95,0.00,0.00,0.00,0.00,'2022-03-12 16:44:34','',''),(2648428,'1','206','1030',472,'Sale Id shift 257680',0.00,0.00,0.00,364.47,0.00,'2022-03-12 17:15:44','',''),(2648429,'1','206','1030',472,'Sale Id shift 257680',0.00,0.00,0.00,206.68,0.00,'2022-03-12 17:15:44','',''),(2648430,'1','206','1030',472,'Sale Id shift 257680',0.00,0.00,0.00,2111.18,0.00,'2022-03-12 17:15:44','',''),(2648431,'1','206',NULL,472,'Sale Id shift 257680',442584.45,0.00,0.00,0.00,0.00,'2022-03-12 17:15:44','',''),(2648432,'1','206','1030',472,'Sale Id shift 257681',0.00,0.00,0.00,967.93,0.00,'2022-03-13 11:11:24','',''),(2648433,'1','206','1030',472,'Sale Id shift 257681',0.00,0.00,0.00,1099.67,0.00,'2022-03-13 11:11:24','',''),(2648434,'1','206','1030',472,'Sale Id shift 257681',0.00,0.00,0.00,1638.52,0.00,'2022-03-13 11:11:24','',''),(2648435,'1','206',NULL,472,'Sale Id shift 257681',611509.80,0.00,0.00,0.00,0.00,'2022-03-13 11:11:24','',''),(2648436,'1','206','1030',472,'Sale Id shift 257682',0.00,0.00,0.00,3331.11,0.00,'2022-03-13 15:25:23','',''),(2648437,'1','206','1030',472,'Sale Id shift 257682',0.00,0.00,0.00,3514.38,0.00,'2022-03-13 15:25:23','',''),(2648438,'1','206','1030',472,'Sale Id shift 257682',0.00,0.00,0.00,99.10,0.00,'2022-03-13 15:25:23','',''),(2648439,'1','206','1030',472,'Sale Id shift 257682',0.00,0.00,0.00,229.98,0.00,'2022-03-13 15:25:23','',''),(2648440,'1','206','1030',472,'Sale Id shift 257682',0.00,0.00,0.00,3948.06,0.00,'2022-03-13 15:25:23','',''),(2648441,'1','206',NULL,472,'Sale Id shift 257682',1835233.95,0.00,0.00,0.00,0.00,'2022-03-13 15:25:23','',''),(2648442,'1','206','1030',472,'Sale Id shift 257683',0.00,0.00,0.00,2582.32,0.00,'2022-03-14 11:56:55','',''),(2648443,'1','206','1030',472,'Sale Id shift 257683',0.00,0.00,0.00,1133.01,0.00,'2022-03-14 11:56:55','',''),(2648444,'1','206','1030',472,'Sale Id shift 257683',0.00,0.00,0.00,2931.60,0.00,'2022-03-14 11:56:55','',''),(2648445,'1','206',NULL,472,'Sale Id shift 257683',1096743.45,0.00,0.00,0.00,0.00,'2022-03-14 11:56:55','',''),(2648446,'1','206','1030',472,'Sale Id shift 257684',0.00,0.00,0.00,3431.03,0.00,'2022-03-14 15:12:03','',''),(2648447,'1','206','1030',472,'Sale Id shift 257684',0.00,0.00,0.00,712.37,0.00,'2022-03-14 15:12:03','',''),(2648448,'1','206','1030',472,'Sale Id shift 257684',0.00,0.00,0.00,0.11,0.00,'2022-03-14 15:12:03','',''),(2648449,'1','206','1030',472,'Sale Id shift 257684',0.00,0.00,0.00,3567.49,0.00,'2022-03-14 15:12:03','',''),(2648450,'1','206',NULL,472,'Sale Id shift 257684',1272315.00,0.00,0.00,0.00,0.00,'2022-03-14 15:12:03','',''),(2648451,'1','206','1030',472,'Sale Id shift 257685',0.00,0.00,0.00,2137.17,0.00,'2022-03-14 15:39:38','',''),(2648452,'1','206','1030',472,'Sale Id shift 257685',0.00,0.00,0.00,578.79,0.00,'2022-03-14 15:39:38','',''),(2648453,'1','206','1030',472,'Sale Id shift 257685',0.00,0.00,0.00,0.10,0.00,'2022-03-14 15:39:38','',''),(2648454,'1','206','1030',472,'Sale Id shift 257685',0.00,0.00,0.00,2835.14,0.00,'2022-03-14 15:39:38','',''),(2648455,'1','206',NULL,472,'Sale Id shift 257685',915948.00,0.00,0.00,0.00,0.00,'2022-03-14 15:39:38','',''),(2648456,'1','206','1030',472,'Sale Id shift 257686',0.00,0.00,0.00,3102.53,0.00,'2022-03-15 11:45:01','',''),(2648457,'1','206','1030',472,'Sale Id shift 257686',0.00,0.00,0.00,2938.93,0.00,'2022-03-15 11:45:01','',''),(2648458,'1','206','1030',472,'Sale Id shift 257686',0.00,0.00,0.00,40.00,0.00,'2022-03-15 11:45:01','',''),(2648459,'1','206',NULL,472,'Sale Id shift 257686',1003440.90,0.00,0.00,0.00,0.00,'2022-03-15 11:45:01','',''),(2648460,'1','206','1030',472,'Sale Id shift 257687',0.00,0.00,0.00,1953.14,0.00,'2022-03-17 10:05:52','',''),(2648461,'1','206',NULL,472,'Sale Id shift 257687',322268.10,0.00,0.00,0.00,0.00,'2022-03-17 10:05:52','',''),(2648462,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-17 10:06:10','',''),(2648463,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-17 10:06:27','',''),(2648464,'1','206',NULL,472,'Reception corrector for bridging 132391',0.00,0.00,0.00,30000.00,0.00,'2022-03-17 12:39:42','',''),(2648465,'1','206','1030',472,'Received from bridging 132391',0.00,0.00,30000.00,0.00,0.00,'2022-03-17 12:39:42','',''),(2648466,'1','206',NULL,472,'Reception corrector for bridging 132392',0.00,0.00,0.00,30000.00,0.00,'2022-03-17 12:39:54','',''),(2648467,'1','206','1030',472,'Received from bridging 132392',0.00,0.00,30000.00,0.00,0.00,'2022-03-17 12:39:54','',''),(2648468,'1','206','1030',472,'Sale Id shift 257688',0.00,0.00,0.00,514.29,0.00,'2022-03-17 13:26:16','',''),(2648469,'1','206','1030',472,'Sale Id shift 257688',0.00,0.00,0.00,3360.10,0.00,'2022-03-17 13:26:16','',''),(2648470,'1','206','1030',472,'Sale Id shift 257688',0.00,0.00,0.00,585.97,0.00,'2022-03-17 13:26:16','',''),(2648471,'1','206',NULL,472,'Sale Id shift 257688',735959.40,0.00,0.00,0.00,0.00,'2022-03-17 13:26:16','',''),(2648472,'1','206','1030',472,'Sale Id shift 257689',0.00,0.00,0.00,0.12,0.00,'2022-03-17 20:33:18','',''),(2648473,'1','206','1030',472,'Sale Id shift 257689',0.00,0.00,0.00,2412.81,0.00,'2022-03-17 20:33:18','',''),(2648474,'1','206','1030',472,'Sale Id shift 257689',0.00,0.00,0.00,2870.78,0.00,'2022-03-17 20:33:18','',''),(2648475,'1','206','1030',472,'Sale Id shift 257689',0.00,0.00,0.00,66.02,0.00,'2022-03-17 20:33:18','',''),(2648476,'1','206','1030',472,'Sale Id shift 257689',0.00,0.00,0.00,2321.82,0.00,'2022-03-17 20:33:18','',''),(2648477,'1','206',NULL,472,'Sale Id shift 257689',1265805.75,0.00,0.00,0.00,0.00,'2022-03-17 20:33:18','',''),(2648478,'1','206','1030',472,'Sale Id shift 257690',0.00,0.00,0.00,3192.99,0.00,'2022-03-18 08:46:46','',''),(2648479,'1','206','1030',472,'Sale Id shift 257690',0.00,0.00,0.00,3318.85,0.00,'2022-03-18 08:46:46','',''),(2648480,'1','206','1030',472,'Sale Id shift 257690',0.00,0.00,0.00,646.28,0.00,'2022-03-18 08:46:46','',''),(2648481,'1','206','1030',472,'Sale Id shift 257690',0.00,0.00,0.00,334.11,0.00,'2022-03-18 08:46:46','',''),(2648482,'1','206','1030',472,'Sale Id shift 257690',0.00,0.00,0.00,4678.84,0.00,'2022-03-18 08:46:46','',''),(2648483,'1','206','1030',472,'Sale Id shift 257690',0.00,0.00,0.00,84.85,0.00,'2022-03-18 08:46:46','',''),(2648484,'1','206',NULL,472,'Sale Id shift 257690',2022226.80,0.00,0.00,0.00,0.00,'2022-03-18 08:46:46','',''),(2648485,'1','206','1030',472,'Sale Id shift 257691',0.00,0.00,0.00,3634.26,0.00,'2022-03-18 16:48:23','',''),(2648486,'1','206','1030',472,'Sale Id shift 257691',0.00,0.00,0.00,3388.12,0.00,'2022-03-18 16:48:23','',''),(2648487,'1','206','1030',472,'Sale Id shift 257691',0.00,0.00,0.00,1360.94,0.00,'2022-03-18 16:48:23','',''),(2648488,'1','206','1030',472,'Sale Id shift 257691',0.00,0.00,0.00,4765.88,0.00,'2022-03-18 16:48:23','',''),(2648489,'1','206','1030',472,'Sale Id shift 257691',0.00,0.00,0.00,834.00,0.00,'2022-03-18 16:48:23','',''),(2648490,'1','206',NULL,472,'Sale Id shift 257691',2307228.00,0.00,0.00,0.00,0.00,'2022-03-18 16:48:23','',''),(2648491,'1','206','1030',472,'Sale Id shift 257692',0.00,0.00,0.00,2520.63,0.00,'2022-03-19 09:36:20','',''),(2648492,'1','206','1030',472,'Sale Id shift 257692',0.00,0.00,0.00,2306.35,0.00,'2022-03-19 09:36:20','',''),(2648493,'1','206','1030',472,'Sale Id shift 257692',0.00,0.00,0.00,370.18,0.00,'2022-03-19 09:36:20','',''),(2648494,'1','206','1030',472,'Sale Id shift 257692',0.00,0.00,0.00,2764.93,0.00,'2022-03-19 09:36:20','',''),(2648495,'1','206','1030',472,'Sale Id shift 257692',0.00,0.00,0.00,650.87,0.00,'2022-03-19 09:36:20','',''),(2648496,'1','206',NULL,472,'Sale Id shift 257692',1421138.40,0.00,0.00,0.00,0.00,'2022-03-19 09:36:20','',''),(2648497,'1','206','1030',472,'Sale Id shift 257693',0.00,0.00,0.00,2211.00,0.00,'2022-03-19 17:50:34','',''),(2648498,'1','206','1030',472,'Sale Id shift 257693',0.00,0.00,0.00,560.23,0.00,'2022-03-19 17:50:34','',''),(2648499,'1','206','1030',472,'Sale Id shift 257693',0.00,0.00,0.00,2230.61,0.00,'2022-03-19 17:50:34','',''),(2648500,'1','206',NULL,472,'Sale Id shift 257693',825303.60,0.00,0.00,0.00,0.00,'2022-03-19 17:50:34','',''),(2648501,'1','206','1030',472,'Sale Id shift 257694',0.00,0.00,0.00,199.54,0.00,'2022-03-20 09:45:39','',''),(2648502,'1','206','1030',472,'Sale Id shift 257694',0.00,0.00,0.00,1979.30,0.00,'2022-03-20 09:45:39','',''),(2648503,'1','206',NULL,472,'Sale Id shift 257694',359508.60,0.00,0.00,0.00,0.00,'2022-03-20 09:45:39','',''),(2648504,'1','206','1030',472,'Sale Id shift 257695',0.00,0.00,0.00,3564.60,0.00,'2022-03-22 07:56:18','',''),(2648505,'1','206',NULL,472,'Sale Id shift 257695',588159.00,0.00,0.00,0.00,0.00,'2022-03-22 07:56:18','',''),(2648506,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,2887500.00,17500.00,0.00,0.00,'2022-03-23 16:37:15','',''),(2648507,'1','206',NULL,472,'Reception corrector for bridging 132393',0.00,0.00,0.00,17500.00,0.00,'2022-03-23 21:05:41','',''),(2648508,'1','206','1030',472,'Received from bridging 132393',0.00,0.00,17500.00,0.00,0.00,'2022-03-23 21:05:41','',''),(2648509,'1','206','1030',472,'Sale Id shift 257696',0.00,0.00,0.00,3165.24,0.00,'2022-03-24 10:11:30','',''),(2648510,'1','206','1030',472,'Sale Id shift 257696',0.00,0.00,0.00,782.53,0.00,'2022-03-24 10:11:30','',''),(2648511,'1','206','1030',472,'Sale Id shift 257696',0.00,0.00,0.00,5525.37,0.00,'2022-03-24 10:11:30','',''),(2648512,'1','206',NULL,472,'Sale Id shift 257696',1563068.10,0.00,0.00,0.00,0.00,'2022-03-24 10:11:30','',''),(2648513,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-24 10:11:57','',''),(2648514,'1','206',NULL,472,'Reception corrector for bridging 132394',0.00,0.00,0.00,30000.00,0.00,'2022-03-24 15:01:05','',''),(2648515,'1','206','1030',472,'Received from bridging 132394',0.00,0.00,30000.00,0.00,0.00,'2022-03-24 15:01:05','',''),(2648516,'1','206','1030',472,'Sale Id shift 257697',0.00,0.00,0.00,4585.01,0.00,'2022-03-24 15:04:41','',''),(2648517,'1','206','1030',472,'Sale Id shift 257697',0.00,0.00,0.00,1660.04,0.00,'2022-03-24 15:04:41','',''),(2648518,'1','206','1030',472,'Sale Id shift 257697',0.00,0.00,0.00,4539.25,0.00,'2022-03-24 15:04:41','',''),(2648519,'1','206',NULL,472,'Sale Id shift 257697',1779409.50,0.00,0.00,0.00,0.00,'2022-03-24 15:04:41','',''),(2648520,'1','206','1030',472,'Sale Id shift 257698',0.00,0.00,0.00,4183.06,0.00,'2022-03-25 08:56:36','',''),(2648521,'1','206','1030',472,'Sale Id shift 257698',0.00,0.00,0.00,4369.66,0.00,'2022-03-25 08:56:36','',''),(2648522,'1','206','1030',472,'Sale Id shift 257698',0.00,0.00,0.00,279.46,0.00,'2022-03-25 08:56:36','',''),(2648523,'1','206','1030',472,'Sale Id shift 257698',0.00,0.00,0.00,5879.20,0.00,'2022-03-25 08:56:36','',''),(2648524,'1','206','1030',472,'Sale Id shift 257698',0.00,0.00,0.00,0.19,0.00,'2022-03-25 08:56:36','',''),(2648525,'1','206',NULL,472,'Sale Id shift 257698',2427409.05,0.00,0.00,0.00,0.00,'2022-03-25 08:56:36','',''),(2648526,'1','206','1030',472,'Sale Id shift 257699',0.00,0.00,0.00,1156.98,0.00,'2022-03-25 15:46:19','',''),(2648527,'1','206','1030',472,'Sale Id shift 257699',0.00,0.00,0.00,1394.74,0.00,'2022-03-25 15:46:19','',''),(2648528,'1','206','1030',472,'Sale Id shift 257699',0.00,0.00,0.00,29.09,0.00,'2022-03-25 15:46:19','',''),(2648529,'1','206','1030',472,'Sale Id shift 257699',0.00,0.00,0.00,1050.23,0.00,'2022-03-25 15:46:19','',''),(2648530,'1','206','1030',472,'Sale Id shift 257699',0.00,0.00,0.00,1437.67,0.00,'2022-03-25 15:46:19','',''),(2648531,'1','206',NULL,472,'Sale Id shift 257699',836337.15,0.00,0.00,0.00,0.00,'2022-03-25 15:46:19','',''),(2648532,'1','206','1030',472,'Sale Id shift 257700',0.00,0.00,0.00,598.39,0.00,'2022-03-26 12:39:08','',''),(2648533,'1','206','1030',472,'Sale Id shift 257700',0.00,0.00,0.00,2457.49,0.00,'2022-03-26 12:39:08','',''),(2648534,'1','206','1030',472,'Sale Id shift 257700',0.00,0.00,0.00,2109.46,0.00,'2022-03-26 12:39:08','',''),(2648535,'1','206',NULL,472,'Sale Id shift 257700',852281.10,0.00,0.00,0.00,0.00,'2022-03-26 12:39:08','',''),(2648536,'1','206','1030',472,'Sale Id shift 257701',0.00,0.00,0.00,30.31,0.00,'2022-03-27 17:47:36','',''),(2648537,'1','206','1030',472,'Sale Id shift 257701',0.00,0.00,0.00,30.00,0.00,'2022-03-27 17:47:36','',''),(2648538,'1','206','1030',472,'Sale Id shift 257701',0.00,0.00,0.00,2589.56,0.00,'2022-03-27 17:47:36','',''),(2648539,'1','206','1030',472,'Sale Id shift 257701',0.00,0.00,0.00,585.83,0.00,'2022-03-27 17:47:36','',''),(2648540,'1','206','1030',472,'Sale Id shift 257701',0.00,0.00,0.00,9.99,0.00,'2022-03-27 17:47:36','',''),(2648541,'1','206',NULL,472,'Sale Id shift 257701',535538.85,0.00,0.00,0.00,0.00,'2022-03-27 17:47:36','',''),(2648542,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,2887500.00,17500.00,0.00,0.00,'2022-03-28 08:56:29','',''),(2648543,'1','206',NULL,472,'Reception corrector for bridging 132395',0.00,0.00,0.00,17500.00,0.00,'2022-03-28 10:00:07','',''),(2648544,'1','206','1030',472,'Received from bridging 132395',0.00,0.00,17500.00,0.00,0.00,'2022-03-28 10:00:07','',''),(2648545,'1','206','1030',472,'Sale Id shift 257702',0.00,0.00,0.00,2305.11,0.00,'2022-03-28 11:34:02','',''),(2648546,'1','206',NULL,472,'Sale Id shift 257702',380343.15,0.00,0.00,0.00,0.00,'2022-03-28 11:34:02','',''),(2648547,'1','206','1030',472,'Sale Id shift 257703',0.00,0.00,0.00,3683.40,0.00,'2022-03-28 19:20:01','',''),(2648548,'1','206','1030',472,'Sale Id shift 257703',0.00,0.00,0.00,3463.56,0.00,'2022-03-28 19:20:01','',''),(2648549,'1','206','1030',472,'Sale Id shift 257703',0.00,0.00,0.00,4073.99,0.00,'2022-03-28 19:20:01','',''),(2648550,'1','206','1030',472,'Sale Id shift 257703',0.00,0.00,0.00,224.39,0.00,'2022-03-28 19:20:01','',''),(2648551,'1','206',NULL,472,'Sale Id shift 257703',1888481.10,0.00,0.00,0.00,0.00,'2022-03-28 19:20:01','',''),(2648552,'1','206','1030',472,'Sale Id shift 257704',0.00,0.00,0.00,2663.17,0.00,'2022-03-29 04:32:37','',''),(2648553,'1','206','1030',472,'Sale Id shift 257704',0.00,0.00,0.00,2277.72,0.00,'2022-03-29 04:32:37','',''),(2648554,'1','206','1030',472,'Sale Id shift 257704',0.00,0.00,0.00,2683.52,0.00,'2022-03-29 04:32:37','',''),(2648555,'1','206',NULL,472,'Sale Id shift 257704',1258027.65,0.00,0.00,0.00,0.00,'2022-03-29 04:32:37','',''),(2648556,'1','206',NULL,472,'Purchased from AA RANO NIGERIA LTD',0.00,3795000.00,23000.00,0.00,0.00,'2022-03-29 12:18:15','',''),(2648557,'1','206','1030',472,'Sale Id shift 257705',0.00,0.00,0.00,1439.16,0.00,'2022-03-30 17:19:22','',''),(2648558,'1','206','1030',472,'Sale 