-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_203
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_203`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_203` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_203`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4105 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3979,40063,'',0,'6.1','1','203','CASH','','2021-12-08 16:43:51',5,0.00,0.00,'','178','2021-12-08 16:43:51','178',0,0),(3980,400357,'',0,'24','1','203','PURCHASES','','2021-12-08 16:44:03',5,0.00,0.00,'','178','2021-12-08 16:44:03','178',0,0),(3981,400358,'',0,'24','1','203','SALARIES','','2021-12-08 16:44:19',5,0.00,0.00,'','178','2021-12-08 16:44:19','178',0,0),(3982,20061,'',0,'20','1','203','SALES','','2021-12-08 16:44:33',5,0.00,0.00,'','178','2021-12-08 16:44:33','178',0,0),(3983,400359,'',0,'24','1','203','AGO CONSUMPTION','','2021-12-08 16:47:42',5,0.00,0.00,'','178','2021-12-08 16:47:42','178',0,0),(3985,400360,'',0,'24','1','203','FUELING AND REPAIRS OF OFFICIA','','2021-12-08 16:48:19',5,0.00,0.00,'','178','2021-12-08 16:48:19','178',0,0),(3986,400361,'',0,'24','1','203','COMPUTER & INTERNET SUBSCRIPTI','','2021-12-08 16:48:35',5,0.00,0.00,'','178','2021-12-08 16:48:35','178',0,0),(3987,400362,'',0,'24','1','203','OTHER OPERATING EXPENSES','','2021-12-08 16:48:52',5,0.00,0.00,'','178','2021-12-08 16:48:52','178',0,0),(4010,400708,'',0,'2','1','203','UBA E-BILLS COLLECTION ACCT','','2021-12-13 13:47:32',5,0.00,0.00,'','178','2021-12-13 13:47:32','178',0,0),(4020,400710,'',0,'2','1','203','ECO E BILLS COLLECTION ACCT','','2021-12-17 10:26:03',5,0.00,0.00,'','178','2021-12-18 14:25:54','178',0,0),(4022,400712,'',0,'2','1','203','FIDELITY POS','','2021-12-18 14:22:26',5,0.00,0.00,'','178','2021-12-18 14:22:26','178',0,0),(4084,4046,'',0,'5','1','203','INVENTORY VALUE ADJUSTMENT','','2022-01-18 12:10:00',5,0.00,0.00,'','178','2022-01-18 12:10:00','178',0,0),(4097,400746,'',0,'2','1','203','UBA  1022237740','','2022-01-21 09:38:25',5,0.00,0.00,'','178','2022-01-21 09:38:25','178',0,0),(4098,400747,'',0,'2','1','203','KEYSTONE SURPLUS ACCOUNT','','2022-03-11 15:36:38',5,0.00,0.00,'','761','2022-03-11 15:36:38','761',0,0),(4099,400748,'',0,'2','1','203','ZENITH BANK TRANSFER 122162001','','2022-03-14 13:28:31',5,0.00,0.00,'','761','2022-03-14 13:28:31','761',0,0),(4100,400749,'',0,'2','1','203','CASH IMPRESS','','2022-04-05 14:09:53',5,0.00,0.00,'','761','2022-04-05 14:09:53','761',0,0),(4101,400363,'',0,'24','1','203','RETAIL OPERATING EXPENSES','','2022-04-05 14:11:25',5,0.00,0.00,'','761','2022-04-05 14:11:25','761',0,0),(4102,400750,'',0,'2','1','203','ECO POS','','2022-07-16 16:42:08',5,0.00,0.00,'','761','2022-07-16 16:42:08','761',0,0),(4103,400751,'',0,'2','1','203','ZENITH BANK 1014717261','','2022-10-21 15:38:22',5,0.00,0.00,'','761','2022-10-21 15:38:22','761',0,0),(4104,400752,'',0,'2','1','203','MONIE POINT POS ACCOUNT','','2023-03-10 10:06:02',5,0.00,0.00,'','761','2023-03-10 10:06:02','761',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=82474 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (82292,'1','203','0000-00-00','2022-01-18 12:12:48',10,'730','','0000-00-00 00:00:00','454','2022-02-04 15:27:50'),(82344,'1','203','0000-00-00','2022-01-21 07:24:48',10,'730','','0000-00-00 00:00:00','454','2022-02-04 15:28:01'),(82454,'1','203','0000-00-00','2022-01-28 10:04:14',10,'730','','0000-00-00 00:00:00','454','2022-02-04 15:28:10'),(82455,'1','203','0000-00-00','2022-02-09 10:04:46',10,'730','','0000-00-00 00:00:00','454','2022-02-09 15:18:32'),(82456,'1','203','0000-00-00','2022-02-13 10:22:09',10,'730','','0000-00-00 00:00:00','454','2022-02-14 13:19:59'),(82457,'1','203','0000-00-00','2022-02-16 10:32:02',10,'730','','0000-00-00 00:00:00','454','2022-02-26 17:02:25'),(82458,'1','203','0000-00-00','2022-03-23 18:04:28',10,'730','','0000-00-00 00:00:00','761','2022-04-19 07:45:56'),(82460,'1','203','0000-00-00','2022-06-03 12:27:05',10,'730','','0000-00-00 00:00:00','761','2022-08-25 17:03:18'),(82461,'1','203','0000-00-00','2022-06-08 12:31:33',10,'730','','0000-00-00 00:00:00','761','2022-08-25 17:02:45'),(82462,'1','203','0000-00-00','2022-06-11 11:08:01',10,'730','','0000-00-00 00:00:00','761','2022-08-25 17:01:43'),(82463,'1','203','0000-00-00','2022-06-15 10:58:47',10,'730','','0000-00-00 00:00:00','761','2022-08-25 17:01:09'),(82464,'1','203','0000-00-00','2022-07-12 11:28:37',10,'730','','0000-00-00 00:00:00','761','2022-08-25 17:00:41'),(82465,'1','203','0000-00-00','2022-07-19 07:17:03',10,'730','','0000-00-00 00:00:00','761','2022-08-25 17:00:04'),(82466,'1','203','0000-00-00','2022-08-17 13:40:37',10,'730','','0000-00-00 00:00:00','761','2022-08-24 17:17:19'),(82467,'1','203','0000-00-00','2022-08-30 13:47:00',10,'761','','0000-00-00 00:00:00','761','2022-08-30 13:48:31'),(82468,'1','203','0000-00-00','2022-11-10 13:19:46',5,'730','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82469,'1','203','0000-00-00','2022-11-11 15:37:57',5,'730','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82470,'1','203','0000-00-00','2022-12-06 13:21:45',5,'730','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82471,'1','203','0000-00-00','2023-01-18 13:20:41',5,'730','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82472,'1','203','0000-00-00','2023-01-19 21:20:08',5,'730','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82473,'1','203','0000-00-00','2023-01-23 17:49:48',5,'730','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=174650 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (173806,'1','203','82292','4084','5',0.00,'CHANGE OF PRICE OF AGO FROM 345 TO 350, DIPPING 29,000',145000.00,'2022-01-18'),(173807,'1','203','82292','355','supplier',145000.00,'CHANGE OF PRICE OF AGO FROM 345 TO 350, DIPPING 29,000',0.00,'2022-01-18'),(174093,'1','203','82344','4084','5',0.00,'CHANGE OF PRICE OF AGO FROM 350 TO 355,  DIPPING 27,500',137500.00,'2022-01-21'),(174094,'1','203','82344','355','supplier',137500.00,'CHANGE OF PRICE OF AGO FROM 350 TO 355.  DIPPING 27,500',0.00,'2022-01-21'),(174609,'1','203','82454','4084','5',0.00,'Change of price of Ago from 355 to 360. Dipping 21,200',106000.00,'2022-01-28'),(174610,'1','203','82454','355','supplier',106000.00,'Change of price of Ago from 355 to 360. Dipping 21,200',0.00,'2022-01-28'),(174611,'1','203','82455','4084','5',0.00,'CHANGE OF PRICE OF AGO FROM 380 TO 390, DIPPING 9,500',95000.00,'2022-02-08'),(174612,'1','203','82455','355','supplier',95000.00,'CHANGE OF PRICE OF AGO FROM 380 TO 390, DIPPING 9,500',0.00,'2022-02-08'),(174613,'1','203','82456','4084','5',0.00,'CHANGE OF PRICE OF AGO FROM 390 TO 400, DIPPING 500',5000.00,'2022-02-12'),(174614,'1','203','82456','355','supplier',5000.00,'CHANGE OF PRICE OF AGO FROM 390 TO 400, DIPPING 500',0.00,'2022-02-12'),(174615,'1','203','82457','4084','5',0.00,'Change of price of AGO from 400 to 410,  dipping 500',5000.00,'2022-02-15'),(174616,'1','203','82457','355','supplier',5000.00,'Change of price of AGO from 400 to 410,   dipping 500',0.00,'2022-02-15'),(174617,'1','203','82458','4084','5',0.00,'CHANGE OF PRICE OF AGO FROM 680 TO 700, DIPPING 14,000',280000.00,'2022-03-23'),(174618,'1','203','82458','355','supplier',280000.00,'CHANGE OF PRICE OF AGO FROM 680 TO 700, DIPPING 14,000',0.00,'2022-03-23'),(174621,'1','203','82460','4084','5',0.00,'Change of price of Ago from 760 to 770. Dipping 7,400',74000.00,'2022-06-03'),(174622,'1','203','82460','355','supplier',74000.00,'Change of price of Ago from 760 to 770. Dipping 7,400',0.00,'2022-06-03'),(174623,'1','203','82461','4084','5',0.00,'Change of price of Ago from 770 to 800. Dipping 500',15000.00,'2022-06-07'),(174624,'1','203','82461','355','supplier',15000.00,'Change of price of Ago from 770 to 800. Dipping 500',0.00,'2022-06-07'),(174625,'1','203','82462','4084','5',0.00,'Change of price of Ago from 800 t0 820. Dipping 13,800',276000.00,'2022-06-11'),(174626,'1','203','82462','355','supplier',276000.00,'Change of price of Ago from 800 to 820. Dipping 13,800',0.00,'2022-06-11'),(174627,'1','203','82463','4084','5',0.00,'Change of price of Ago from 820 to 830. Dipping 8,300',83000.00,'2022-06-15'),(174628,'1','203','82463','355','supplier',83000.00,'Change of price of Ago from 820 to 830. Dipping 8,300',0.00,'2022-06-15'),(174629,'1','203','82464','4084','5',0.00,'CHANGE OF PRICE OF PMS FROM 165 TO 185, DIPPING 31,000',620000.00,'2022-07-11'),(174630,'1','203','82464','355','supplier',620000.00,'CHANGE OF PRICE OF PMS FROM 165 TO 185, DIPPING 31,000',0.00,'2022-07-11'),(174631,'1','203','82465','4084','5',30000.00,'Change of price of Pms from 185 to 175. Dipping 3,000',0.00,'2022-07-18'),(174632,'1','203','82465','355','supplier',0.00,'Change of price of Pms from 185 to 175. Dipping 3,000',30000.00,'2022-07-18'),(174633,'1','203','82466','4084','5',97000.00,'Change of price of Ago from 810 to 800. Dipping 9,700',0.00,'2022-08-17'),(174634,'1','203','82466','355','supplier',0.00,'Change of price of Ago from 810 to 800. Dipping 9,700',97000.00,'2022-08-17'),(174635,'1','203','82467','4084','5',0.00,'INCREMENT OF AGO FROM 700 TO 720 DIPPING 6,400',128000.00,'2022-05-14'),(174636,'1','203','82467','355','supplier',128000.00,'INCREMENT OF AGO FROM 700 TO 720 DIPPING 6,400',0.00,'2022-05-14'),(174637,'1','203','82468','4084','5',0.00,'Change of price of Pms from 17 to 180  dipping 9,700',48500.00,'2022-11-06'),(174638,'1','203','82468','355','supplier',48500.00,'Change of price of Pms from 175 to 180. Dipping 9,700',0.00,'2022-11-06'),(174640,'1','203','82469','4084','5',0.00,'Change of price of Ago from 830 to 860. Dipping 8,000',240000.00,'2022-11-10'),(174641,'1','203','82469','355','supplier',240000.00,'Change of price of Ago from 830 to 860. Dipping 8,000',0.00,'2022-11-10'),(174642,'1','203','82470','4084','5',0.00,'Change of price of Ago from 880 to 900. Dipping 200',4000.00,'2022-12-03'),(174643,'1','203','82470','355','supplier',4000.00,'Change of price of Ago from 880 to 900.  Dipping 200',0.00,'2022-12-03'),(174644,'1','203','82471','4084','5',56000.00,'Change of price of Ago from 880 to 870.  Dipping 5,600',0.00,'2023-01-17'),(174645,'1','203','82471','355','supplier',0.00,'Change of price of Ago from 880 to 870. Dipping 5,600',56000.00,'2023-01-18'),(174646,'1','203','82472','4084','5',0.00,'Change of price of PMS from 180 to 195. Dipping 3000',45000.00,'2023-01-19'),(174647,'1','203','82472','355','supplier',45000.00,'Change of price of pms from 180 to 195. Dipping 3000',0.00,'2023-01-19'),(174648,'1','203','82473','4084','5',0.00,'Change of price of PMS from 195 to 220. Dipping 13,900',347500.00,'2023-01-23'),(174649,'1','203','82473','355','supplier',347500.00,'Change of price of PMS from 195 to 220. Dipping 13,900',0.00,'2023-01-23');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4187 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (4033,'','1','203','DRIVER SHORTAGE','DRIVER','08030647174','@gmail.com','kano','KANO','No 7 Maiduguri Road,Opposite NNPC Depot. Kano Nigeria','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-16 09:08:01',5,'178','2021-12-16 09:08:01','178'),(4185,'','1','203','MIRANAB INVESTMENT LTD','08033016014','08033016014','miranabinvestment@gmail.com','NASSARAWA','NASSARAWA','NO. 8 WITEHOUSE AVENUE, ADO NASARAWWA STATE','Nigeria',100.00,0.00,0.00,'0000-00-00','2022-01-18 12:08:34',5,'178','2022-01-18 12:08:34','178'),(4186,'','1','203','NIGERIA POLICE FORCE(ELECTION)','CP YUSUF C. USMAN','08071785115','dopstransport@gmail.com','FCT','ABUJA','NPF HEADQUARTER LOUIS EDET HOUSE SHEHU SHAGARI WAY, ABUJA.','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 11:01:30',5,'761','2023-02-21 11:01:30','761');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18221 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','203',18125,'1026',8514.31,9735.00,'2021-12-20','','2021-12-20 09:00:24','178','178',2021,'178','2021-12-20 09:00:24',5),('1','203',18191,'1026',34306.94,34900.00,'2021-12-24','','2021-12-25 13:07:20','734','734',2021,'734','2021-12-25 13:07:20',5),('1','203',18192,'1027',8445.44,6300.00,'2021-12-24','','2021-12-25 13:09:06','734','734',2021,'734','2021-12-25 13:09:06',5),('1','203',18193,'1028',14292.99,13400.00,'2021-12-24','','2021-12-25 13:10:30','734','734',2021,'734','2021-12-25 13:10:30',5),('1','203',18194,'1028',4.52,500.00,'2022-02-12','','2022-02-12 15:30:58','454','454',2022,'454','2022-02-12 15:30:58',5),('1','203',18195,'1026',21890.89,22200.00,'2022-05-03','','2022-05-03 15:59:16','735','735',2022,'735','2022-05-03 15:59:16',5),('1','203',18196,'1027',2845.10,2900.00,'2022-05-05','','2022-05-05 15:03:01','735','735',2022,'735','2022-05-05 15:03:01',5),('1','203',18197,'1027',11694.73,11800.00,'2022-05-08','','2022-05-08 14:44:06','735','735',2022,'735','2022-05-08 14:44:06',5),('1','203',18198,'1028',436.64,800.00,'2022-05-19','','2022-05-19 10:58:49','735','735',2022,'735','2022-05-19 10:58:49',5),('1','203',18199,'1027',19954.21,20100.00,'2022-05-23','','2022-05-23 11:05:24','761','761',2022,'761','2022-05-23 11:05:24',5),('1','203',18200,'1026',16335.67,16500.00,'2022-05-30','','2022-05-30 09:23:42','761','761',2022,'761','2022-05-30 09:23:42',5),('1','203',18201,'1028',3.25,200.00,'2022-06-07','','2022-06-07 14:33:52','761','761',2022,'761','2022-06-07 14:33:52',5),('1','203',18202,'1027',1752.06,4100.00,'2022-06-08','TANK RECONCILIATION','2022-06-08 12:27:14','761','761',2022,'761','2022-06-08 12:27:14',5),('1','203',18203,'1026',128.84,500.00,'2022-06-08','TANK RECONCILIATION','2022-06-08 12:27:34','761','761',2022,'761','2022-06-08 12:27:34',5),('1','203',18204,'1028',90.64,500.00,'2022-06-08','TANK RECONCILIATION','2022-06-08 12:28:07','761','761',2022,'761','2022-06-08 12:28:07',5),('1','203',18205,'1028',11775.64,15000.00,'2022-06-27','','2022-06-27 15:33:50','761','761',2022,'761','2022-06-27 15:33:50',5),('1','203',18206,'1028',14312.68,10400.00,'2022-06-28','','2022-06-28 16:46:30','761','761',2022,'761','2022-06-28 16:46:30',5),('1','203',18207,'1028',647.74,1400.00,'2022-07-26','','2022-07-26 10:51:37','761','761',2022,'761','2022-07-26 10:51:37',5),('1','203',18208,'1028',420.16,1000.00,'2022-08-26','','2022-08-26 14:53:01','761','761',2022,'761','2022-08-26 14:53:01',5),('1','203',18209,'1026',12736.62,14000.00,'2022-09-06','','2022-09-06 15:07:36','761','761',2022,'761','2022-09-06 15:07:36',5),('1','203',18210,'1027',16815.28,18300.00,'2022-09-12','','2022-09-12 16:30:51','761','761',2022,'761','2022-09-12 16:30:51',5),('1','203',18211,'1027',1908.62,34400.00,'2022-11-24','','2022-11-24 15:02:33','761','761',2022,'761','2022-11-24 15:02:33',5),('1','203',18212,'1027',1147.27,34400.00,'2022-12-01','','2022-12-01 12:03:49','761','761',2022,'761','2022-12-01 12:03:49',5),('1','203',18213,'1027',34400.00,2500.00,'2022-12-01','TANK RECONCILIATION','2022-12-01 12:07:33','761','761',2022,'761','2022-12-01 12:07:33',5),('1','203',18214,'1026',17966.70,500.00,'2022-12-12','TANK RECONCILIATION','2022-12-12 10:51:25','761','761',2022,'761','2022-12-12 10:51:25',5),('1','203',18215,'1027',37603.97,4900.00,'2022-12-12','TANK RECONCILIATION','2022-12-12 10:53:20','761','761',2022,'761','2022-12-12 10:53:20',5),('1','203',18216,'1026',500.00,15000.00,'2022-12-12','TANK RECONCILITION','2022-12-12 11:55:31','761','761',2022,'761','2022-12-12 11:55:31',5),('1','203',18217,'1027',29604.58,33000.00,'2023-01-26','','2023-01-26 19:55:37','761','761',2023,'761','2023-01-26 19:55:37',5),('1','203',18218,'1027',29806.37,30500.00,'2023-03-01','TANK RECONCILIATION','2023-03-01 10:26:01','761','761',2023,'761','2023-03-01 10:26:01',5),('1','203',18219,'1027',3859.34,5000.00,'2023-03-08','TANK RECONCILITION','2023-03-08 10:27:04','761','761',2023,'761','2023-03-08 10:27:04',5),('1','203',18220,'1026',29594.42,29800.00,'2023-03-08','TANK RECONCILIATION','2023-03-08 12:12:30','761','761',2023,'761','2023-03-08 12:12:30',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3056 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','203','1026',3038,'5','PUMP 1',81291.71,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:31:29','178'),('1','203','1026',3039,'5','PUMP 2',840194.90,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:32:01','178'),('1','203','1026',3040,'5','PUMP 3',171416.66,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:32:45','178'),('1','203','1026',3041,'5','PUMP 4',960145.31,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:33:13','178'),('1','203','1026',3042,'5','PUMP 5',318896.47,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:33:33','178'),('1','203','1026',3043,'5','PUMP 6',796010.54,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:34:12','178'),('1','203','1026',3044,'5','PUMP 7',142360.17,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:34:36','178'),('1','203','1026',3045,'5','PUMP 8',870369.93,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:35:07','178'),('1','203','1027',3046,'5','PUMP 9',231707.28,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:37:27','178'),('1','203','1027',3047,'5','PUMP 10',1217898.79,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:37:54','178'),('1','203','1027',3048,'5','PUMP 11',402775.90,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:38:11','178'),('1','203','1027',3049,'5','PUMP 12',1344397.03,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:38:38','178'),('1','203','1027',3050,'5','PUMP 13',1301013.31,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:38:55','178'),('1','203','1027',3051,'5','PUMP 14',269528.12,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:39:12','178'),('1','203','1027',3052,'5','PUMP 15',1177190.53,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:40:14','178'),('1','203','1027',3053,'5','PUMP 16',161888.19,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-08 16:40:59','178'),('1','203','1028',3054,'5','AGO PUMP 1',63867.12,'DISPENSING AGO','',NULL,NULL,'',5,'2021-12-08 16:46:02','178'),('1','203','1028',3055,'5','AGO PUMP 2',318417.93,'DISPENSING AGO','',NULL,NULL,'',5,'2021-12-08 16:46:22','178');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258181 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','203',246533,'MORNING','2021-12-08','2021-12-08 00:00:00',NULL,'730',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','203',246554,'MORNING SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'730',1737011.67,1737011.67,'730','2021-12-16 10:56:23','734','2021-12-16 11:20:10',10,0),('1','203',246565,'MORNING SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'730',6295200.75,6295200.75,'730','2021-12-16 11:46:09','734','2021-12-16 12:02:19',10,0),('1','203',246568,'MORNING SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'730',6630787.80,6630787.80,'730','2021-12-16 12:40:34','734','2021-12-16 12:54:45',10,0),('1','203',246580,'MORNING SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'730',7192660.65,7192660.65,'730','2021-12-16 13:25:36','734','2021-12-16 13:44:19',10,0),('1','203',246608,'MORNING SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'730',7239203.70,7239203.70,'730','2021-12-16 14:50:10','734','2021-12-16 15:25:24',10,0),('1','203',246620,'MORNING SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'730',6899435.85,6899435.85,'730','2021-12-16 15:37:51','734','2021-12-16 15:42:55',10,0),('1','203',246626,'MORNING SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'730',7713090.45,7713090.45,'730','2021-12-16 18:08:11','734','2021-12-16 19:07:38',10,0),('1','203',246654,'MORNING SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'730',3270729.30,3270729.30,'730','2021-12-16 20:05:49','734','2021-12-16 21:10:40',10,0),('1','203',246712,'AFTERNOON SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'730',3650630.10,3650630.10,'730','2021-12-17 06:44:41','734','2021-12-17 07:15:16',10,0),('1','203',246739,'MORNING SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'730',2644597.80,2644597.80,'730','2021-12-17 07:40:27','734','2021-12-17 07:43:10',10,0),('1','203',246758,'AFTERNOON SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'730',3524514.15,3524514.15,'730','2021-12-17 08:37:16','734','2021-12-17 08:51:25',10,0),('1','203',246857,'MORNING SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'730',3400379.55,3400379.55,'730','2021-12-17 15:28:06','734','2021-12-17 15:30:48',10,0),('1','203',246866,'AFTERNOON SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'730',3393065.85,3393065.85,'730','2021-12-18 07:21:25','734','2021-12-18 07:22:22',10,0),('1','203',247171,'MORNING SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'730',3110938.35,3110938.35,'730','2021-12-19 07:46:41','734','2021-12-19 09:25:55',10,0),('1','203',247247,'AFTERNOON SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'730',2913367.20,2913367.20,'730','2021-12-19 10:03:39','734','2021-12-19 10:10:57',10,0),('1','203',247276,'MORNING SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'730',2895621.45,2895621.45,'730','2021-12-19 12:51:01','734','2021-12-19 12:58:50',10,0),('1','203',247349,'AFTERNOON SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'730',2112767.25,2112767.25,'730','2021-12-20 09:15:47','734','2021-12-20 09:52:31',10,0),('1','203',247508,'MORNING SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'730',2948170.50,2948170.50,'730','2021-12-20 12:50:49','734','2021-12-20 13:48:27',10,0),('1','203',247610,'AFTERNOON SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'730',1039412.55,1039412.55,'730','2021-12-20 19:15:32','734','2021-12-20 19:58:09',10,0),('1','203',247772,'MORNING SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'730',1190882.55,1190882.55,'730','2021-12-21 17:57:00','734','2021-12-21 19:00:44',10,0),('1','203',247957,'AFTERNOON SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'730',2216235.30,2216235.30,'730','2021-12-22 08:11:09','734','2021-12-22 09:27:03',10,0),('1','203',248016,'MORNING SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'730',3263601.15,3263601.15,'730','2021-12-22 13:25:05','734','2021-12-22 13:42:23',10,0),('1','203',248155,'AFTERNOON SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'730',3849249.15,3849249.15,'730','2021-12-23 05:54:40','734','2021-12-23 07:34:03',10,0),('1','203',248294,'MORNING SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'730',3468788.70,3468788.70,'730','2021-12-23 13:31:56','734','2021-12-23 14:01:10',10,0),('1','203',248325,'AFTERNOON SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'730',2171961.30,2171961.30,'730','2021-12-24 06:21:13','734','2021-12-24 06:42:23',10,0),('1','203',248476,'MORNING SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'730',3687310.50,3687310.50,'730','2021-12-24 14:23:18','734','2021-12-24 14:53:55',10,0),('1','203',248664,'AFTERNOON SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'730',4152839.40,4152839.40,'730','2021-12-25 07:01:17','734','2021-12-25 07:16:37',10,0),('1','203',248731,'MORNING SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'730',3704119.65,3704119.65,'730','2021-12-25 14:47:14','734','2021-12-25 15:10:24',10,0),('1','203',248878,'AFTERNOON SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'730',3548221.95,3548221.95,'730','2021-12-26 06:37:03','734','2021-12-26 07:11:15',10,0),('1','203',248938,'MORNING SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'730',2560420.50,2560420.50,'730','2021-12-26 13:33:44','734','2021-12-26 13:59:09',10,0),('1','203',249124,'AFTERNOON SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'730',820580.70,820580.70,'730','2021-12-27 06:36:18','734','2021-12-27 08:00:20',10,0),('1','203',249239,'MORNING SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'730',1596544.20,1596544.20,'730','2021-12-27 13:19:51','734','2021-12-27 13:35:18',10,0),('1','203',249354,'AFTERNOON SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'730',61002.90,61002.90,'730','2021-12-28 06:28:55','734','2021-12-28 06:49:48',10,0),('1','203',249374,'MORNING SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'730',1171572.60,1171572.60,'730','2021-12-28 13:14:44','734','2021-12-28 13:36:56',10,0),('1','203',249598,'AFTERNOON SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'730',2558355.30,2558355.30,'730','2021-12-29 06:20:47','734','2021-12-29 06:27:51',10,0),('1','203',249616,'MORNING SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'730',2312139.75,2312139.75,'730','2021-12-29 14:10:00','734','2021-12-29 15:12:35',10,0),('1','203',249852,'AFTERNOON SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'730',2374561.95,2374561.95,'730','2021-12-30 06:07:05','734','2021-12-30 07:32:02',10,0),('1','203',249913,'MORNING SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'730',2404298.40,2404298.40,'730','2021-12-30 13:25:02','734','2021-12-30 14:04:44',10,0),('1','203',250101,'AFTERNOON SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'730',2307082.50,2307082.50,'730','2021-12-31 06:14:43','734','2021-12-31 06:56:53',10,0),('1','203',250159,'MORNING SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'730',2028509.25,2028509.25,'730','2021-12-31 12:18:17','734','2021-12-31 14:36:51',10,0),('1','203',250285,'AFTERNOON SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'730',1599622.65,1599622.65,'730','2021-12-31 19:03:00','734','2021-12-31 20:57:23',10,0),('1','203',250497,'AFTERNOON SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'730',85601.40,85601.40,'730','2022-01-01 17:12:24','734','2022-01-01 22:32:48',10,0),('1','203',250766,'AFTERNOON SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'730',71208.00,71208.00,'730','2022-01-02 20:35:30','734','2022-01-02 22:25:43',10,0),('1','203',251040,'AFTERNOON SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'730',1796537.10,1796537.10,'730','2022-01-04 06:45:51','735','2022-01-04 08:36:10',10,0),('1','203',251128,'MORNING SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'730',2414932.05,2414932.05,'730','2022-01-04 14:02:12','735','2022-01-04 14:08:48',10,0),('1','203',251185,'AFTERNOON SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'730',3048235.95,3048235.95,'730','2022-01-05 07:33:17','735','2022-01-05 07:56:52',10,0),('1','203',251410,'MORNING SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'730',2110140.00,2110140.00,'730','2022-01-05 15:09:41','735','2022-01-05 18:19:22',10,0),('1','203',251508,'AFTERNOON SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'730',2454672.90,2454672.90,'730','2022-01-06 06:51:54','735','2022-01-06 09:29:54',10,0),('1','203',251632,'MORNING SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'730',1879263.60,1879263.60,'730','2022-01-06 13:39:42','735','2022-01-06 15:03:20',10,0),('1','203',251688,'AFTERNOON SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'730',2847785.40,2847785.40,'730','2022-01-07 06:29:16','735','2022-01-07 07:45:37',10,0),('1','203',251880,'MORNING SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'730',2046279.45,2046279.45,'730','2022-01-07 14:24:04','735','2022-01-07 16:34:54',10,0),('1','203',251925,'AFTERNOON SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'730',3489640.95,3489640.95,'730','2022-01-08 06:38:41','735','2022-01-08 10:52:59',10,0),('1','203',252076,'MORNING SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'730',2914893.60,2914893.60,'730','2022-01-08 13:44:20','735','2022-01-08 13:53:42',10,0),('1','203',252226,'AFTERNOON SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'730',3835399.65,3835399.65,'730','2022-01-09 06:43:37','735','2022-01-09 08:00:50',10,0),('1','203',252331,'MORNING SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'730',2326074.60,2326074.60,'730','2022-01-09 14:25:03','735','2022-01-09 16:01:51',10,0),('1','203',252393,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'730',2910246.90,2910246.90,'730','2022-01-10 07:24:05','735','2022-01-10 07:34:53',10,0),('1','203',252503,'MORNING SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'730',2193402.75,2193402.75,'730','2022-01-10 13:43:55','735','2022-01-10 17:21:05',10,0),('1','203',252710,'AFTERNOON SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'730',3487974.60,3487974.60,'730','2022-01-11 07:31:21','735','2022-01-11 08:35:47',10,0),('1','203',252779,'MORNING SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'730',2250755.10,2250755.10,'730','2022-01-11 13:58:57','735','2022-01-11 14:33:46',10,0),('1','203',252946,'AFTERNOON SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'730',2604041.55,2604041.55,'730','2022-01-12 07:16:16','735','2022-01-12 09:04:45',10,0),('1','203',253038,'MORNING SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'730',1816125.30,1816125.30,'730','2022-01-12 13:54:20','735','2022-01-12 15:31:38',10,0),('1','203',253137,'AFTERNOON SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'730',2972314.95,2972314.95,'730','2022-01-13 07:22:49','735','2022-01-13 07:28:28',10,0),('1','203',253294,'MORNING SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'730',2092775.85,2092775.85,'730','2022-01-13 14:29:39','735','2022-01-13 15:18:42',10,0),('1','203',253410,'AFTERNOON SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'730',2687666.85,2687666.85,'730','2022-01-14 07:39:37','735','2022-01-14 07:51:46',10,0),('1','203',253538,'MORNING SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'730',2039310.90,2039310.90,'730','2022-01-14 14:06:54','735','2022-01-14 14:46:23',10,0),('1','203',253641,'AFTERNOON SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'730',3236928.75,3236928.75,'730','2022-01-15 07:25:46','735','2022-01-15 07:48:46',10,0),('1','203',253756,'MORNING SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'730',2187909.90,2187909.90,'730','2022-01-15 13:43:19','735','2022-01-15 17:03:01',10,0),('1','203',253890,'AFTERNOON SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'730',3091057.20,3091057.20,'730','2022-01-16 07:53:11','735','2022-01-16 07:59:16',10,0),('1','203',253979,'MORNING SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'730',1605390.60,1605390.60,'730','2022-01-16 13:54:48','735','2022-01-16 15:47:38',10,0),('1','203',254210,'AFTERNOON SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'730',2720026.65,2720026.65,'730','2022-01-17 07:35:36','735','2022-01-17 10:08:50',10,0),('1','203',254287,'MORNING SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'730',2460826.35,2460826.35,'730','2022-01-17 16:47:27','735','2022-01-17 17:03:26',10,0),('1','203',254486,'AFTERNOON SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'730',1335390.60,1335390.60,'730','2022-01-18 08:42:09','735','2022-01-18 09:09:05',10,0),('1','203',254508,'MORNING SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'730',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','203',254648,'AFTERNOON SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'730',113533.00,113533.00,'730','2022-01-18 19:18:11','735','2022-01-19 09:22:19',10,0),('1','203',254783,'MORNING SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'730',1320066.70,1320066.70,'730','2022-01-19 14:12:30','735','2022-01-19 23:49:10',10,0),('1','203',254987,'AFTERNOON SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'730',2836745.90,2836745.90,'730','2022-01-20 08:31:08','735','2022-01-20 08:42:29',10,0),('1','203',255002,'MORNING SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'730',1769893.20,1769893.20,'730','2022-01-20 14:02:38','735','2022-01-20 16:12:12',10,0),('1','203',255143,'AFTERNOON SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'730',2797655.70,2797655.70,'730','2022-01-21 07:18:24','735','2022-01-21 09:20:13',10,0),('1','203',255280,'MORNING SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'730',2248599.40,2248599.40,'730','2022-01-21 14:09:40','735','2022-01-21 16:18:46',10,0),('1','203',255386,'AFTERNOON SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'730',3155845.10,3155845.10,'730','2022-01-22 08:19:10','735','2022-01-22 08:21:17',10,0),('1','203',255532,'MORNING SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'730',713491.15,713491.15,'730','2022-01-22 13:41:21','735','2022-01-22 17:11:09',10,0),('1','203',255657,'AFTERNOON SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'730',3393011.80,3393011.80,'730','2022-01-23 08:04:08','735','2022-01-23 14:48:47',10,0),('1','203',255841,'MORNING SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'730',2091096.80,2091096.80,'730','2022-01-23 14:58:31','735','2022-01-23 19:54:42',10,0),('1','203',255941,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'730',2786199.25,2786199.25,'730','2022-01-24 06:58:46','735','2022-01-24 09:30:51',10,0),('1','203',256020,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'730',2468069.00,2468069.00,'730','2022-01-24 14:04:44','735','2022-01-24 15:22:51',10,0),('1','203',256206,'AFTERNOON SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'730',3390644.75,3390644.75,'730','2022-01-25 06:24:36','735','2022-01-25 08:46:46',10,0),('1','203',256268,'MORNING SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'730',2012600.95,2012600.95,'730','2022-01-25 12:23:36','735','2022-01-25 16:22:59',10,0),('1','203',256496,'AFTERNOON SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'730',78082.25,78082.25,'730','2022-01-26 07:32:33','735','2022-01-26 07:55:05',10,0),('1','203',256517,'MORNING SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'730',3404870.90,3404870.90,'730','2022-01-26 14:12:48','735','2022-01-26 19:01:41',10,0),('1','203',256748,'AFTERNOON SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'730',4415522.40,4415522.40,'730','2022-01-27 07:52:10','735','2022-01-27 08:16:43',10,0),('1','203',256784,'MORNING SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'730',3520742.30,3520742.30,'730','2022-01-27 13:44:12','735','2022-01-27 16:58:00',10,0),('1','203',256882,'AFTERNOON SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'730',1744449.55,1744449.55,'730','2022-01-28 07:22:32','735','2022-01-28 09:08:14',10,0),('1','203',257039,'MORNING SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'730',2751815.70,2751815.70,'730','2022-01-29 16:53:55','735','2022-01-29 16:59:19',10,0),('1','203',257407,'MORNING SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'730',3188874.75,3188874.75,'730','2022-01-29 17:08:00','735','2022-01-29 17:16:04',10,0),('1','203',257411,'AFTERNOON SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'730',3410117.85,3410117.85,'730','2022-01-30 11:36:37','735','2022-01-30 11:37:49',10,0),('1','203',257583,'MORNING SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'730',2177306.40,2177306.40,'730','2022-01-31 19:09:55','735','2022-01-31 19:12:40',10,0),('1','203',257584,'AFTERNOON SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'730',2519013.15,2519013.15,'730','2022-01-31 19:31:58','735','2022-01-31 19:34:47',10,0),('1','203',257585,'MORNING SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'730',1941077.40,1941077.40,'730','2022-01-31 20:29:56','735','2022-01-31 20:32:24',10,0),('1','203',257586,'AFTERNOON SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'730',3496177.50,3496177.50,'730','2022-02-01 11:05:49','735','2022-02-01 11:07:03',10,0),('1','203',257587,'MORNING SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'730',2858075.55,2858075.55,'730','2022-02-01 14:49:57','735','2022-02-01 21:38:56',10,0),('1','203',257588,'AFTERNOON SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'730',3473336.55,3473336.55,'730','2022-02-02 10:11:06','735','2022-02-02 15:23:05',10,0),('1','203',257589,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'730',2157992.40,2157992.40,'730','2022-02-02 19:29:11','735','2022-02-03 08:31:10',10,0),('1','203',257590,'AFTERNOON SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'730',3078483.90,3078483.90,'730','2022-02-03 10:55:24','735','2022-02-03 14:45:51',10,0),('1','203',257591,'MORNING SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'730',1876108.80,1876108.80,'730','2022-02-03 14:49:33','735','2022-02-04 00:26:21',10,0),('1','203',257592,'AFTERNOON SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'730',2131279.35,2131279.35,'730','2022-02-04 11:39:12','454','2022-02-04 15:21:59',10,0),('1','203',257593,'MORNING SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'730',2741781.15,2741781.15,'730','2022-02-04 19:47:14','735','2022-02-05 08:15:34',10,0),('1','203',257594,'PRICE CHANGE SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'730',26096.40,26096.40,'730','2022-02-05 16:54:27','735','2022-02-05 17:05:19',10,0),('1','203',257595,'AFTERNOON SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'730',3876283.40,3876283.40,'730','2022-02-05 17:15:55','735','2022-02-05 17:18:00',10,0),('1','203',257596,'MORNING SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'730',3200215.75,3200215.75,'730','2022-02-05 17:24:59','735','2022-02-05 17:27:57',10,0),('1','203',257597,'AFTERNOON SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'730',3630718.25,3630718.25,'730','2022-02-06 12:58:22','735','2022-02-06 14:16:51',10,0),('1','203',257598,'MORNING SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'730',2123150.70,2123150.70,'730','2022-02-06 14:43:33','735','2022-02-06 16:18:09',10,0),('1','203',257599,'AFTERNOON SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'730',40321.80,40321.80,'730','2022-02-07 10:28:02','735','2022-02-07 14:20:20',10,0),('1','203',257600,'AFTERNOON SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'730',1276540.70,1276540.70,'730','2022-02-08 07:26:15','735','2022-02-08 08:40:25',10,0),('1','203',257601,'MORNING SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'730',2523932.95,2523932.95,'730','2022-02-08 13:23:40','735','2022-02-08 18:27:50',10,0),('1','203',257602,'AFTERNOON SHIFT I','2022-02-08','2022-02-08 00:00:00',NULL,'730',96508.60,96508.60,'730','2022-02-08 20:15:45','735','2022-02-09 09:51:20',10,0),('1','203',257603,'AFTERNOON SHIFT II','2022-02-08','2022-02-08 00:00:00',NULL,'730',61206.60,61206.60,'730','2022-02-09 10:07:38','735','2022-02-09 11:01:21',10,0),('1','203',257604,'MORNING SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'730',82098.90,82098.90,'730','2022-02-09 14:29:59','454','2022-02-09 15:18:17',10,0),('1','203',257605,'AFTERNOON SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'730',1421165.40,1421165.40,'730','2022-02-10 06:27:31','735','2022-02-10 13:19:16',10,0),('1','203',257606,'MORNING SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'730',2518615.95,2518615.95,'730','2022-02-10 13:58:41','735','2022-02-10 18:15:27',10,0),('1','203',257607,'AFTERNOON SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'730',2870722.20,2870722.20,'730','2022-02-11 07:41:57','735','2022-02-11 09:17:28',10,0),('1','203',257608,'MORNING SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'730',812701.50,812701.50,'730','2022-02-11 14:45:17','735','2022-02-11 21:11:18',10,0),('1','203',257609,'AFTERNOON SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'730',583221.60,583221.60,'730','2022-02-12 07:26:32','735','2022-02-12 08:03:08',10,0),('1','203',257610,'MORNING SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'730',1228339.20,1228339.20,'730','2022-02-12 14:03:30','735','2022-02-12 15:03:32',10,0),('1','203',257611,'AFTERNOON SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'730',2399764.05,2399764.05,'730','2022-02-13 06:44:43','735','2022-02-13 08:25:59',10,0),('1','203',257612,'MORNING SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'730',4217317.50,4217317.50,'730','2022-02-13 14:05:53','735','2022-02-13 20:47:55',10,0),('1','203',257613,'AFTERNOON SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'730',1516717.95,1516717.95,'730','2022-02-14 06:37:41','735','2022-02-14 08:10:44',10,0),('1','203',257614,'MORNING SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'730',1988659.20,1988659.20,'730','2022-02-14 13:36:47','735','2022-02-14 20:48:33',10,0),('1','203',257615,'AFTERNOON NOON','2022-02-15','2022-02-15 00:00:00',NULL,'730',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','203',257616,'AFTERNOON SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'730',1107730.80,1107730.80,'730','2022-02-15 07:27:05','735','2022-02-15 08:06:57',10,0),('1','203',257617,'MORNING SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'730',1876023.60,1876023.60,'730','2022-02-15 14:21:07','735','2022-02-15 17:16:27',10,0),('1','203',257618,'AFTERNOON SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'730',1997730.90,1997730.90,'730','2022-02-16 07:44:40','735','2022-02-16 08:43:57',10,0),('1','203',257619,'MORNING SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'730',2862550.35,2862550.35,'730','2022-02-16 14:18:38','735','2022-02-16 17:22:00',10,0),('1','203',257620,'MORNING SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'730',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','203',257621,'AFTERNOON SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'730',2343948.75,2343948.75,'730','2022-02-17 07:02:44','735','2022-02-17 07:54:52',10,0),('1','203',257622,'MORNING SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'730',1851667.95,1851667.95,'730','2022-02-17 13:41:49','735','2022-02-17 19:17:41',10,0),('1','203',257623,'AFTERNOON SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'730',1778744.55,1778744.55,'730','2022-02-18 07:44:17','735','2022-02-18 08:28:00',10,0),('1','203',257624,'MORNING SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'730',2113914.00,2113914.00,'730','2022-02-18 16:01:10','735','2022-02-18 18:14:38',10,0),('1','203',257625,'AFTERNOON SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'730',2365093.50,2365093.50,'730','2022-02-18 21:25:13','735','2022-02-18 23:39:01',10,0),('1','203',257626,'MORNING SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'730',1250741.25,1250741.25,'730','2022-02-19 13:21:32','735','2022-02-19 15:27:20',10,0),('1','203',257627,'AFTERNOON SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'730',1278344.10,1278344.10,'730','2022-02-19 18:27:31','735','2022-02-19 23:12:03',10,0),('1','203',257628,'MORNING SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'730',1283206.65,1283206.65,'730','2022-02-20 13:47:39','735','2022-02-20 15:54:00',10,0),('1','203',257629,'AFTERNOON SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'730',3448706.25,3448706.25,'730','2022-02-21 07:52:14','735','2022-02-21 08:51:25',10,0),('1','203',257630,'MORNING SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'730',2243574.30,2243574.30,'730','2022-02-21 13:49:32','454','2022-02-21 21:09:28',10,0),('1','203',257631,'AFTERNOON SHIFT','2022-02-21','2022-02-22 06:04:53','2022-02-23 06:04:53','730',1360080.15,1360080.15,'730','2022-02-22 06:06:44','735','2022-02-22 09:05:27',10,0),('1','203',257632,'MORNING SHIFT','2022-02-22','2022-02-22 10:21:13','2022-02-23 10:21:13','730',2256584.55,2256584.55,'730','2022-02-22 14:46:00','454','2022-02-22 15:41:53',10,0),('1','203',257633,'AFTERNOON SHIFT','2022-02-22','2022-02-22 19:33:26','2022-02-23 19:33:26','730',2470309.05,2470309.05,'730','2022-02-23 06:45:51','735','2022-02-23 08:20:48',10,0),('1','203',257634,'MORNING SHIFT','2022-02-23','2022-02-23 08:44:02','2022-02-24 08:44:02','730',1447888.20,1447888.20,'730','2022-02-23 13:27:19','735','2022-02-23 14:47:33',10,0),('1','203',257635,'AFTERNOON SHIFT','2022-02-23','2022-02-24 06:05:22','2022-02-25 06:05:22','730',1510188.90,1510188.90,'730','2022-02-24 06:07:21','735','2022-02-24 10:20:10',10,0),('1','203',257636,'MORNING SHIFT','2022-02-24','2022-02-24 14:35:20','2022-02-25 14:35:20','730',1244426.70,1244426.70,'730','2022-02-24 14:42:20','735','2022-02-24 21:49:24',10,0),('1','203',257637,'AFTERNOON SHIFT','2022-02-24','2022-02-25 08:05:18','2022-02-26 08:05:18','730',137530.80,137530.80,'730','2022-02-25 08:07:04','454','2022-02-25 11:36:12',10,0),('1','203',257638,'AFTERNOON SHIFT','2022-02-25','2022-02-25 20:51:36','2022-02-26 20:51:36','730',885954.30,885954.30,'730','2022-02-26 09:29:50','735','2022-02-26 09:44:10',10,0),('1','203',257639,'MORNING SHIFT','2022-02-26','2022-02-26 10:00:18','2022-02-27 10:00:18','730',786470.85,786470.85,'730','2022-02-26 14:09:14','454','2022-02-26 14:38:22',10,0),('1','203',257640,'AFTERNOON SHIFT','2022-02-26','2022-02-26 20:25:44','2022-02-27 20:25:44','730',1639312.95,1639312.95,'730','2022-02-26 20:27:52','735','2022-02-27 00:14:14',10,0),('1','203',257641,'MORNING SHIFT','2022-02-27','2022-02-27 14:30:11','2022-02-28 14:30:11','730',769046.85,769046.85,'730','2022-02-27 14:33:29','735','2022-02-27 20:19:22',10,0),('1','203',257642,'AFTERNOON SHIFT','2022-02-27','2022-02-28 06:16:32','2022-03-01 06:16:32','730',1208923.65,1208923.65,'730','2022-02-28 06:21:43','454','2022-02-28 12:08:34',10,0),('1','203',257643,'MORNING SHIFT','2022-02-28','2022-02-28 14:09:38','2022-03-01 14:09:38','730',1696132.35,1696132.35,'730','2022-02-28 14:14:56','735','2022-02-28 14:41:02',10,0),('1','203',257644,'AFTERNOON SHIFT','2022-02-28','2022-02-28 18:58:57','2022-03-01 18:58:57','730',1777183.65,1777183.65,'730','2022-02-28 20:59:24','735','2022-02-28 22:14:12',10,0),('1','203',257645,'MORNING SHIFT','2022-03-01','2022-03-01 07:59:14','2022-03-02 07:59:14','730',3302790.15,3302790.15,'730','2022-03-01 14:22:35','735','2022-03-01 17:00:18',10,0),('1','203',257646,'AFTERNOON SHIFT','2022-03-01','2022-03-01 20:05:13','2022-03-02 20:05:13','730',2328544.35,2328544.35,'730','2022-03-02 07:34:31','735','2022-03-02 08:44:50',10,0),('1','203',257647,'MORNING SHIFT','2022-03-02','2022-03-02 14:00:42','2022-03-03 14:00:42','730',2837714.55,2837714.55,'730','2022-03-02 14:07:30','735','2022-03-02 15:26:47',10,0),('1','203',257648,'AFTERNOON SHIFT','2022-03-02','2022-03-02 17:54:29','2022-03-03 17:54:29','730',2162427.30,2162427.30,'730','2022-03-03 07:43:10','735','2022-03-03 10:41:35',10,0),('1','203',257649,'MORNING SHIFT','2022-03-03','2022-03-03 13:59:43','2022-03-04 13:59:43','730',3061654.20,3061654.20,'730','2022-03-03 14:04:19','761','2022-03-03 17:10:40',10,0),('1','203',257650,'AFTERNOON SHIFT','2022-03-03','2022-03-04 07:34:10','2022-03-05 07:34:10','730',1387592.25,1387592.25,'730','2022-03-04 07:37:34','761','2022-03-04 10:59:04',10,0),('1','203',257651,'MORNING SHIFT','2022-03-04','2022-03-04 14:34:13','2022-03-05 14:34:13','730',1250249.55,1250249.55,'730','2022-03-04 14:36:00','735','2022-03-04 17:31:57',10,0),('1','203',257652,'AFTERNOON SHIFT','2022-03-04','2022-03-05 07:06:03','2022-03-06 07:06:03','730',1815717.75,1815717.75,'730','2022-03-05 07:14:12','735','2022-03-05 16:44:38',10,0),('1','203',257653,'MORNING SHIFT','2022-03-05','2022-03-05 17:44:51','2022-03-06 17:44:51','730',1456587.00,1456587.00,'730','2022-03-05 18:19:58','735','2022-03-05 23:29:57',10,0),('1','203',257654,'AFTERNOON SHIFT','2022-03-05','2022-03-06 07:40:29','2022-03-07 07:40:29','730',2020636.20,2020636.20,'730','2022-03-06 07:52:28','735','2022-03-06 10:02:10',10,0),('1','203',257655,'MORNING SHIFT','2022-03-06','2022-03-06 14:08:47','2022-03-07 14:08:47','730',3102674.85,3102674.85,'730','2022-03-06 14:29:26','735','2022-03-06 20:59:43',10,0),('1','203',257656,'AFTERNOON SHIFT','2022-03-06','2022-03-07 07:17:54','2022-03-08 07:17:54','730',3558687.00,3558687.00,'730','2022-03-07 07:23:57','735','2022-03-07 09:26:25',10,0),('1','203',257657,'MORNING SHIFT','2022-03-07','2022-03-07 13:47:26','2022-03-08 13:47:26','730',4188944.10,4188944.10,'730','2022-03-07 13:57:56','761','2022-03-07 16:48:25',10,0),('1','203',257658,'AFTERNOON SHIFT','2022-03-06','2022-03-07 20:32:25','2022-03-08 20:32:25','730',3132105.90,3132105.90,'730','2022-03-08 07:10:52','735','2022-03-08 09:26:28',10,0),('1','203',257659,'MORNING SHIFT','2022-03-08','2022-03-08 13:23:34','2022-03-09 13:23:34','730',2367250.05,2367250.05,'730','2022-03-08 13:28:16','735','2022-03-08 18:27:24',10,0),('1','203',257660,'AFTERNOON SHIFT','2022-03-08','2022-03-09 07:02:36','2022-03-10 07:02:36','730',2174172.00,2174172.00,'730','2022-03-09 07:04:47','735','2022-03-09 09:51:31',10,0),('1','203',257661,'MORNING SHIFT','2022-03-09','2022-03-09 13:44:59','2022-03-10 13:44:59','730',3774645.60,3774645.60,'730','2022-03-09 13:50:07','735','2022-03-09 18:35:23',10,0),('1','203',257662,'AFTERNOON SHIFT','2022-03-09','2022-03-09 21:12:59','2022-03-10 21:12:59','730',3715615.20,3715615.20,'730','2022-03-10 10:45:30','761','2022-03-10 11:43:37',10,0),('1','203',257663,'MORNING SHIFT','2022-03-10','2022-03-10 13:57:24','2022-03-11 13:57:24','730',3688926.45,3688926.45,'730','2022-03-10 14:00:09','735','2022-03-10 14:26:00',10,0),('1','203',257664,'AFTERNOON SHIFT','2022-03-10','2022-03-11 07:38:11','2022-03-12 07:38:11','730',2717607.75,2717607.75,'730','2022-03-11 07:42:00','735','2022-03-11 08:21:56',10,0),('1','203',257665,'MORNING SHIFT','2022-03-11','2022-03-11 11:29:49','2022-03-12 11:29:49','730',402654.45,402654.45,'730','2022-03-11 15:43:49','735','2022-03-11 18:56:36',10,0),('1','203',257666,'AFTERNOON SHIFT','2022-03-11','2022-03-12 07:16:51','2022-03-13 07:16:51','730',2287436.25,2287436.25,'730','2022-03-12 07:20:04','735','2022-03-12 08:09:01',10,0),('1','203',257667,'MORNING SHIFT','2022-03-12','2022-03-12 09:03:25','2022-03-13 09:03:25','730',3204128.40,3204128.40,'730','2022-03-12 14:01:24','735','2022-03-12 14:36:39',10,0),('1','203',257668,'AFTERNOON SHIFT','2022-03-12','2022-03-13 08:47:05','2022-03-14 08:47:05','730',2244554.40,2244554.40,'730','2022-03-13 08:49:08','735','2022-03-13 10:33:58',10,0),('1','203',257669,'MORNING SHIFT','2022-03-13','2022-03-13 13:39:47','2022-03-14 13:39:47','730',3611369.85,3611369.85,'730','2022-03-13 13:43:11','735','2022-03-13 14:53:30',10,0),('1','203',257670,'AFTERNOON SHIFT','2022-03-13','2022-03-13 18:52:47','2022-03-14 18:52:47','730',2802008.55,2802008.55,'730','2022-03-14 08:26:24','761','2022-03-14 12:39:19',10,0),('1','203',257671,'AFTERNOON SHIFT','2022-03-14','2022-03-14 20:27:27','2022-03-15 20:27:27','730',1608410.10,1608410.10,'730','2022-03-15 08:34:01','761','2022-03-15 10:50:03',10,0),('1','203',257672,'MORNING SHIFT','2022-03-15','2022-03-15 14:07:07','2022-03-16 14:07:07','730',4031580.30,4031580.30,'730','2022-03-15 14:13:11','735','2022-03-15 20:17:06',10,0),('1','203',257673,'AFTERNOON SHIFT','2022-03-15','2022-03-16 07:58:29','2022-03-17 07:58:29','730',3109332.60,3109332.60,'730','2022-03-16 08:07:20','735','2022-03-16 08:46:00',10,0),('1','203',257674,'AFTERNOON SHIFT','2022-03-16','2022-03-16 20:52:39','2022-03-17 20:52:39','730',2088825.75,2088825.75,'730','2022-03-17 07:34:11','735','2022-03-17 08:43:35',10,0),('1','203',257675,'MORNING SHIFT','2022-03-17','2022-03-17 08:58:21','2022-03-18 08:58:21','730',3902099.85,3902099.85,'730','2022-03-17 13:56:30','735','2022-03-17 18:40:20',10,0),('1','203',257676,'AFTERNOON SHIFT','2022-03-17','2022-03-17 21:23:26','2022-03-18 21:23:26','730',1607636.25,1607636.25,'730','2022-03-18 07:37:00','735','2022-03-18 10:11:03',10,0),('1','203',257677,'MORNING SHIFT','2022-03-18','2022-03-18 13:23:24','2022-03-19 13:23:24','730',2542546.05,2542546.05,'730','2022-03-18 13:25:18','735','2022-03-18 20:57:21',10,0),('1','203',257678,'AFTERNOON SHIFT','2022-03-18','2022-03-19 07:07:12','2022-03-20 07:07:12','730',2055954.45,2055954.45,'730','2022-03-19 07:19:44','735','2022-03-19 09:03:31',10,0),('1','203',257679,'AFTERNOON SHIFT','2022-03-20','2022-03-20 19:31:00','2022-03-21 19:31:00','730',2325549.60,2325549.60,'730','2022-03-21 10:05:48','735','2022-03-21 11:42:33',10,0),('1','203',257680,'MORNING SHIFT','2022-03-21','2022-03-21 14:08:34','2022-03-22 14:08:34','730',1945756.80,1945756.80,'730','2022-03-21 14:11:39','735','2022-03-21 16:49:02',10,0),('1','203',257681,'AFTERNOON SHIFT','2022-03-21','2022-03-22 06:43:34','2022-03-23 06:43:34','730',1204617.10,1204617.10,'730','2022-03-22 06:46:13','735','2022-03-22 08:01:15',10,0),('1','203',257682,'AFTERNOON SHIFT','2022-03-22','2022-03-22 14:35:54','2022-03-23 14:35:54','730',3130332.85,3130332.85,'730','2022-03-23 07:13:29','735','2022-03-23 08:12:01',10,0),('1','203',257683,'MORNING SHIFT','2022-03-23','2022-03-23 14:22:29','2022-03-24 14:22:29','730',2814643.15,2814643.15,'730','2022-03-23 14:27:57','735','2022-03-23 15:55:12',10,0),('1','203',257684,'AFTERNOON SHIFT I','2022-03-23','2022-03-23 17:59:07','2022-03-24 17:59:07','730',151007.60,151007.60,'730','2022-03-23 17:59:55','735','2022-03-23 21:10:47',10,0),('1','203',257685,'AFTERNOON SHIFT II6','2022-03-23','2022-03-24 07:09:18','2022-03-25 07:09:18','730',2885026.70,2885026.70,'730','2022-03-24 07:15:25','735','2022-03-24 10:09:42',10,0),('1','203',257686,'MORNING SHIFT','2022-03-24','2022-03-24 13:48:39','2022-03-25 13:48:39','730',5053074.90,5053074.90,'730','2022-03-24 13:55:07','735','2022-03-24 14:48:46',10,0),('1','203',257687,'AFTERNOON SHIFT','2022-03-24','2022-03-24 19:06:00','2022-03-25 19:06:00','730',3973091.60,3973091.60,'730','2022-03-25 07:25:02','735','2022-03-25 16:57:32',10,0),('1','203',257688,'MORNING SHIFT','2022-03-25','2022-03-25 18:02:18','2022-03-26 18:02:18','730',2568135.45,2568135.45,'730','2022-03-25 18:08:36','735','2022-03-25 20:58:41',10,0),('1','203',257689,'AFTERNOON SHIFT','2022-03-25','2022-03-26 09:41:27','2022-03-27 09:41:27','730',3344404.30,3344404.30,'730','2022-03-26 09:52:41','735','2022-03-26 12:04:47',10,0),('1','203',257690,'MORNING SHIFT','2022-03-26','2022-03-26 13:50:04','2022-03-27 13:50:04','730',939027.05,939027.05,'730','2022-03-26 13:58:20','735','2022-03-26 16:37:18',10,0),('1','203',257691,'AFTERNOON SHIFT','2022-03-26','2022-03-27 06:51:11','2022-03-28 06:51:11','730',2100652.05,2100652.05,'730','2022-03-27 10:04:02','735','2022-03-27 10:18:23',10,0),('1','203',257692,'MORNING SHIFT','2022-03-27','2022-03-27 13:42:43','2022-03-28 13:42:43','730',2714805.55,2714805.55,'730','2022-03-27 13:54:05','735','2022-03-27 17:33:46',10,0),('1','203',257693,'AFTERNOON SHIFT','2022-03-27','2022-03-28 06:56:57','2022-03-29 06:56:57','730',3402994.95,3402994.95,'730','2022-03-28 08:21:09','735','2022-03-28 11:19:39',10,0),('1','203',257694,'MORNING SHIFT','2022-03-28','2022-03-28 13:45:52','2022-03-29 13:45:52','730',5059334.50,5059334.50,'730','2022-03-28 13:52:24','735','2022-03-28 17:21:09',10,0),('1','203',257695,'AFTERNOON SHIFT','2022-03-28','2022-03-29 06:40:38','2022-03-30 06:40:38','730',3324080.30,3324080.30,'730','2022-03-29 06:48:34','735','2022-03-29 16:23:34',10,0),('1','203',257696,'MORNING SHIFT','2022-03-29','2022-03-29 19:12:35','2022-03-30 19:12:35','730',2192036.35,2192036.35,'730','2022-03-29 19:31:25','735','2022-03-29 21:40:54',10,0),('1','203',257697,'AFTERNOON SHIFT','2022-03-29','2022-03-30 06:23:21','2022-03-31 06:23:21','730',4219841.25,4219841.25,'730','2022-03-30 06:32:24','735','2022-03-30 13:08:49',10,0),('1','203',257698,'MORNING SHIFT','2022-03-30','2022-03-30 13:38:19','2022-03-31 13:38:19','730',5049156.40,5049156.40,'730','2022-03-30 13:44:04','735','2022-03-30 17:06:25',10,0),('1','203',257699,'AFTERNOON SHIFT','2022-03-30','2022-03-30 19:22:52','2022-03-31 19:22:52','730',4805471.75,4805471.75,'730','2022-03-31 07:22:25','735','2022-03-31 09:18:40',10,0),('1','203',257700,'MORNING SHIFT','2022-03-31','2022-03-31 13:52:07','2022-04-01 13:52:07','730',3775425.70,3775425.70,'730','2022-03-31 13:58:49','735','2022-04-01 09:43:03',10,0),('1','203',257701,'AFTERNOON SHIFT','2022-03-31','2022-04-01 09:52:36','2022-04-02 09:52:36','730',5730563.65,5730563.65,'730','2022-04-01 09:58:46','735','2022-04-01 10:38:38',10,0),('1','203',257702,'MORNING SHIFT','2022-04-01','2022-04-01 11:59:40','2022-04-02 11:59:40','730',2331077.10,2331077.10,'730','2022-04-01 13:56:32','735','2022-04-01 14:48:04',10,0),('1','203',257703,'AFTERNOON SHIFT','2022-04-01','2022-04-01 18:49:27','2022-04-02 18:49:27','730',3938716.65,3938716.65,'730','2022-04-02 09:13:09','735','2022-04-02 09:39:40',10,0),('1','203',257704,'MORNING SHIFT','2022-04-02','2022-04-02 13:55:46','2022-04-03 13:55:46','730',5065644.05,5065644.05,'730','2022-04-02 14:00:50','735','2022-04-02 16:23:01',10,0),('1','203',257705,'AFTERNOON SHIFT','2022-04-02','2022-04-03 06:13:04','2022-04-04 06:13:04','730',4490941.95,4490941.95,'730','2022-04-03 09:31:01','735','2022-04-03 11:23:31',10,0),('1','203',257706,'MORNING SHIFT','2022-04-03','2022-04-03 14:17:53','2022-04-04 14:17:53','730',3246393.15,3246393.15,'730','2022-04-03 14:22:52','735','2022-04-03 18:30:17',10,0),('1','203',257707,'AFTERNOON SHIFT','2022-04-03','2022-04-04 05:55:27','2022-04-05 05:55:27','730',4288422.60,4288422.60,'730','2022-04-04 06:57:22','735','2022-04-04 09:50:15',10,0),('1','203',257708,'MORNING SHIFT','2022-04-04','2022-04-04 10:04:34','2022-04-05 10:04:34','730',3307870.50,3307870.50,'730','2022-04-04 13:46:41','735','2022-04-04 14:18:50',10,0),('1','203',257709,'AFTERNOON SHIFT','2022-04-04','2022-04-04 21:39:34','2022-04-05 21:39:34','730',3825962.25,3825962.25,'730','2022-04-05 09:57:01','735','2022-04-05 15:36:47',10,0),('1','203',257710,'MORNING SHIFT','2022-04-05','2022-04-05 15:45:32','2022-04-06 15:45:32','730',2895185.70,2895185.70,'730','2022-04-05 15:54:01','735','2022-04-06 10:50:07',10,0),('1','203',257711,'MORNING SHIFT','2022-04-06','2022-04-06 11:24:05','2022-04-07 11:24:05','730',0.00,0.00,'730','2022-04-06 12:14:43','761','2022-04-06 12:16:12',10,0),('1','203',257712,'AFTERNOON SHIFT','2022-04-05','2022-04-06 12:18:06','2022-04-07 12:18:06','730',4187511.90,4187511.90,'730','2022-04-06 12:24:52','735','2022-04-06 14:40:16',10,0),('1','203',257713,'MORNING SHIFT','2022-04-06','2022-04-06 14:49:22','2022-04-07 14:49:22','730',3317640.15,3317640.15,'730','2022-04-06 15:08:11','735','2022-04-06 15:19:34',10,0),('1','203',257714,'AFTERNOON SHIFT','2022-04-06','2022-04-07 07:33:29','2022-04-08 07:33:29','730',2082205.95,2082205.95,'730','2022-04-07 07:46:28','735','2022-04-07 09:53:10',10,0),('1','203',257715,'MORNING SHIFT','2022-04-07','2022-04-07 11:28:40','2022-04-08 11:28:40','730',0.00,0.00,'730','2022-04-08 05:06:01','735','2022-04-08 09:13:56',10,0),('1','203',257716,'AFTERNOON SHIFT','2022-04-07','2022-04-08 09:42:43','2022-04-09 09:42:43','730',3259291.20,3259291.20,'730','2022-04-08 09:47:08','735','2022-04-08 13:08:08',10,0),('1','203',257717,'MORNING SHIFT','2022-04-08','2022-04-08 13:49:15','2022-04-09 13:49:15','730',3129919.65,3129919.65,'730','2022-04-08 13:56:00','735','2022-04-08 15:43:38',10,0),('1','203',257718,'AFTERNOON SHIFT','2022-04-08','2022-04-08 16:50:51','2022-04-09 16:50:51','730',3208870.50,3208870.50,'730','2022-04-09 07:10:10','735','2022-04-09 08:37:07',10,0),('1','203',257719,'MORNING SHIFT','2022-04-09','2022-04-09 13:57:11','2022-04-10 13:57:11','730',3462363.30,3462363.30,'730','2022-04-09 14:00:57','735','2022-04-09 17:13:55',10,0),('1','203',257720,'AFTERNOON SHIFT','2022-04-09','2022-04-10 06:13:36','2022-04-11 06:13:36','730',1063365.60,1063365.60,'730','2022-04-10 07:27:42','735','2022-04-10 09:47:12',10,0),('1','203',257721,'MORNING SHIFT','2022-04-10','2022-04-10 12:21:42','2022-04-11 12:21:42','730',1917232.35,1917232.35,'730','2022-04-10 15:20:25','735','2022-04-10 15:50:50',10,0),('1','203',257722,'AFTERNOON SHIFT','2022-04-10','2022-04-10 19:32:11','2022-04-11 19:32:11','730',0.00,0.00,'730','2022-04-10 22:56:32','735','2022-04-11 08:13:08',10,0),('1','203',257723,'MORNING SHIFT','2022-04-11','2022-04-11 12:40:02','2022-04-12 12:40:02','730',3353539.20,3353539.20,'730','2022-04-11 13:47:50','735','2022-04-11 18:39:49',10,0),('1','203',257724,'AFTERNOON SHIFT','2022-04-11','2022-04-12 07:56:34','2022-04-13 07:56:34','730',3102485.10,3102485.10,'730','2022-04-12 10:41:13','735','2022-04-12 15:30:19',10,0),('1','203',257725,'MORNING SHIFT','2022-04-12','2022-04-12 16:42:25','2022-04-13 16:42:25','730',1506177.75,1506177.75,'730','2022-04-12 16:45:03','735','2022-04-12 22:58:59',10,0),('1','203',257726,'AFTERNOON SHIFT','2022-04-12','2022-04-13 06:16:45','2022-04-14 06:16:45','730',2954458.65,2954458.65,'730','2022-04-13 06:22:18','735','2022-04-13 09:07:33',10,0),('1','203',257727,'MORNING SHIFT','2022-04-13','2022-04-13 13:33:31','2022-04-14 13:33:31','730',3532947.00,3532947.00,'730','2022-04-13 13:40:30','735','2022-04-13 16:41:59',10,0),('1','203',257728,'AFTERNOON SHIFT','2022-04-13','2022-04-14 07:35:12','2022-04-15 07:35:12','730',4641096.90,4641096.90,'730','2022-04-14 08:00:39','735','2022-04-14 08:06:46',10,0),('1','203',257729,'MORNING SHIFT','2022-04-14','2022-04-14 15:40:23','2022-04-15 15:40:23','730',2336791.05,2336791.05,'730','2022-04-14 15:47:26','735','2022-04-14 22:57:38',10,0),('1','203',257730,'AFTERNOON SHIFT','2022-04-14','2022-04-15 06:47:35','2022-04-16 06:47:35','730',3334084.05,3334084.05,'730','2022-04-15 06:55:20','761','2022-04-15 11:20:33',10,0),('1','203',257731,'MORNING SHIFT','2022-04-15','2022-04-15 13:49:13','2022-04-16 13:49:13','730',3189098.55,3189098.55,'730','2022-04-15 13:55:15','761','2022-04-15 17:19:13',10,0),('1','203',257732,'AFTERNOON SHIFT','2022-04-15','2022-04-16 06:57:11','2022-04-17 06:57:11','730',3229320.60,3229320.60,'730','2022-04-16 07:03:15','735','2022-04-16 10:35:02',10,0),('1','203',257733,'MORNING SHIFT','2022-04-16','2022-04-16 13:13:58','2022-04-17 13:13:58','730',2996985.75,2996985.75,'730','2022-04-16 13:23:50','735','2022-04-16 15:40:45',10,0),('1','203',257734,'AFTERNOON SHIFT','2022-04-16','2022-04-16 21:38:34','2022-04-17 21:38:34','730',2015942.50,2015942.50,'730','2022-04-17 07:08:10','735','2022-04-17 09:18:21',10,0),('1','203',257735,'MORNING SHIFT','2022-04-17','2022-04-17 14:05:14','2022-04-18 14:05:14','730',3543099.95,3543099.95,'730','2022-04-17 14:14:05','735','2022-04-17 19:46:52',10,0),('1','203',257736,'AFTERNOON SHIFT','2022-04-18','2022-04-18 07:22:50','2022-04-19 07:22:50','730',2900197.05,2900197.05,'730','2022-04-18 07:26:06','735','2022-04-18 12:26:58',10,0),('1','203',257737,'AFTERNOON SHIFT','2022-04-18','2022-04-18 18:08:14','2022-04-19 18:08:14','730',2454787.95,2454787.95,'730','2022-04-19 07:17:12','761','2022-04-19 07:19:16',10,0),('1','203',257738,'MORNING SHIFT','2022-04-19','2022-04-19 14:25:47','2022-04-20 14:25:47','730',3764024.15,3764024.15,'730','2022-04-19 14:32:36','735','2022-04-19 17:34:33',10,0),('1','203',257739,'AFTERNOON SHIFT','2022-04-19','2022-04-20 06:46:43','2022-04-21 06:46:43','730',4107474.80,4107474.80,'730','2022-04-20 06:51:40','735','2022-04-20 08:23:04',10,0),('1','203',257740,'MORNING SHIFT','2022-04-20','2022-04-20 14:31:55','2022-04-21 14:31:55','730',4270953.05,4270953.05,'730','2022-04-20 14:37:50','735','2022-04-20 14:41:58',10,0),('1','203',257741,'AFTERNOON SHIFT','2022-04-20','2022-04-21 05:57:17','2022-04-22 05:57:17','730',608655.75,608655.75,'730','2022-04-21 06:22:55','735','2022-04-21 07:58:19',10,0),('1','203',257742,'AFTERNOON SHIFT','2022-04-21','2022-04-22 06:28:05','2022-04-23 06:28:05','730',2848675.10,2848675.10,'730','2022-04-22 06:59:45','735','2022-04-22 10:20:11',10,0),('1','203',257743,'MORNING SHIFT','2022-04-22','2022-04-22 11:26:20','2022-04-23 11:26:20','730',3995580.80,3995580.80,'730','2022-04-22 13:49:52','735','2022-04-22 17:07:12',10,0),('1','203',257744,'AFTERNOON SHIFT ','2022-04-22','2022-04-23 05:59:03','2022-04-24 05:59:03','730',3482424.95,3482424.95,'730','2022-04-23 06:15:49','735','2022-04-23 13:19:19',10,0),('1','203',257745,'AFTERNOON SHIFT','2022-04-23','2022-04-23 15:50:26','2022-04-24 15:50:26','730',4296735.15,4296735.15,'730','2022-04-24 06:47:02','735','2022-04-24 07:02:35',10,0),('1','203',257746,'MORNING SHIFT','2022-04-24','2022-04-24 14:25:49','2022-04-25 14:25:49','730',3207716.85,3207716.85,'730','2022-04-24 14:32:53','735','2022-04-24 15:06:03',10,0),('1','203',257747,'AFTERNOON SHIFT','2022-04-24','2022-04-24 20:57:19','2022-04-25 20:57:19','730',2131170.80,2131170.80,'730','2022-04-25 06:37:02','735','2022-04-25 12:17:47',10,0),('1','203',257748,'MORNING SHIFT','2022-04-25','2022-04-25 13:48:14','2022-04-26 13:48:14','730',3284609.70,3284609.70,'730','2022-04-25 13:54:01','735','2022-04-25 18:34:43',10,0),('1','203',257749,'AFTERNOON SHIFT','2022-04-25','2022-04-26 06:12:29','2022-04-27 06:12:29','730',848045.65,848045.65,'730','2022-04-26 06:17:42','735','2022-04-26 09:39:13',10,0),('1','203',257750,'AFTERNOON SHIFT','2022-04-26','2022-04-26 15:47:13','2022-04-27 15:47:13','730',2789561.60,2789561.60,'730','2022-04-27 07:00:34','735','2022-04-27 11:56:02',10,0),('1','203',257751,'MORNING SHIFT','2022-04-27','2022-04-27 13:27:37','2022-04-28 13:27:37','730',3148047.10,3148047.10,'730','2022-04-27 13:34:39','735','2022-04-27 15:10:54',10,0),('1','203',257752,'AFTERNOON SHIFT','2022-04-27','2022-04-28 06:08:51','2022-04-29 06:08:51','730',1885333.80,1885333.80,'730','2022-04-28 06:53:23','735','2022-04-28 09:07:52',10,0),('1','203',257753,'MORNING SHIFT','2022-04-28','2022-04-28 16:53:12','2022-04-29 16:53:12','730',2139567.55,2139567.55,'730','2022-04-28 16:58:03','735','2022-04-29 01:12:30',10,0),('1','203',257754,'AFTERNOON SHIFT','2022-04-28','2022-04-29 07:04:50','2022-04-30 07:04:50','730',3561746.50,3561746.50,'730','2022-04-29 07:12:53','735','2022-04-29 09:53:05',10,0),('1','203',257755,'MORNING SHIFT','2022-04-29','2022-04-29 12:33:16','2022-04-30 12:33:16','730',2169517.80,2169517.80,'730','2022-04-29 13:53:36','735','2022-04-29 16:31:26',10,0),('1','203',257756,'AFTERNOON SHIFT','2022-04-29','2022-04-29 22:29:57','2022-04-30 22:29:57','730',1328028.90,1328028.90,'730','2022-04-30 08:53:25','735','2022-04-30 09:51:00',10,0),('1','203',257757,'MORNING SHIFT','2022-04-30','2022-04-30 13:44:44','2022-05-01 13:44:44','730',3461416.20,3461416.20,'730','2022-04-30 13:51:25','735','2022-04-30 16:18:25',10,0),('1','203',257758,'AFTERNOON SHIFT','2022-04-30','2022-05-01 10:47:24','2022-05-02 10:47:24','730',4542177.75,4542177.75,'730','2022-05-01 14:38:42','735','2022-05-01 15:15:39',10,0),('1','203',257759,'MORNING SHIFT','2022-05-01','2022-05-01 15:23:29','2022-05-02 15:23:29','730',4171622.45,4171622.45,'730','2022-05-01 15:30:16','735','2022-05-01 16:26:43',10,0),('1','203',257760,'AFTERNOON SHIFT','2022-05-01','2022-05-01 17:16:30','2022-05-02 17:16:30','730',2637621.65,2637621.65,'730','2022-05-02 11:36:12','735','2022-05-02 12:14:54',10,0),('1','203',257761,'AFTERNOON SHIFT','2022-05-02','2022-05-03 08:13:10','2022-05-04 08:13:10','730',4102270.75,4102270.75,'730','2022-05-03 16:38:07','735','2022-05-03 22:46:45',10,0),('1','203',257762,'AFTERNOON SHIFT','2022-05-03','2022-05-04 07:43:43','2022-05-05 07:43:43','730',2796967.45,2796967.45,'730','2022-05-04 08:17:51','735','2022-05-04 09:05:19',10,0),('1','203',257763,'MORNING SHIFT','2022-05-04','2022-05-05 08:33:21','2022-05-06 08:33:21','730',3293696.25,3293696.25,'730','2022-05-05 08:37:28','735','2022-05-05 14:04:30',10,0),('1','203',257764,'AFTERNOON SHIFT','2022-05-04','2022-05-05 14:43:49','2022-05-06 14:43:49','730',635142.05,635142.05,'730','2022-05-05 15:15:53','735','2022-05-05 17:40:42',10,0),('1','203',257765,'AFTERNOON SHIFT','2022-05-05','2022-05-06 09:51:03','2022-05-07 09:51:03','730',630035.00,630035.00,'730','2022-05-06 09:53:13','735','2022-05-06 12:58:59',10,0),('1','203',257766,'AFTERNOON SHIFT','2022-05-06','2022-05-06 21:30:30','2022-05-07 21:30:30','730',2437753.50,2437753.50,'730','2022-05-07 10:46:39','735','2022-05-07 16:44:08',10,0),('1','203',257767,'MORNING SHIFT','2022-05-07','2022-05-07 17:10:54','2022-05-08 17:10:54','730',2788113.95,2788113.95,'730','2022-05-08 14:48:53','735','2022-05-08 18:38:48',10,0),('1','203',257768,'AFTERNOON SHIFT','2022-05-07','2022-05-09 08:34:02','2022-05-10 08:34:02','730',313915.00,313915.00,'730','2022-05-09 08:36:41','735','2022-05-09 12:18:57',10,0),('1','203',257769,'AFTERNOON SHIFT','2022-05-08','2022-05-09 12:26:43','2022-05-10 12:26:43','730',592452.00,592452.00,'730','2022-05-09 12:28:26','735','2022-05-09 20:43:56',10,0),('1','203',257770,'AFTERNOON SHIFT','2022-05-09','2022-05-09 21:55:05','2022-05-10 21:55:05','730',2632159.40,2632159.40,'730','2022-05-10 10:54:37','735','2022-05-10 21:56:24',10,0),('1','203',257771,'MORNING SHIFT','2022-05-10','2022-05-11 08:18:04','2022-05-12 08:18:04','730',1860274.45,1860274.45,'730','2022-05-11 10:26:55','735','2022-05-11 16:59:20',10,0),('1','203',257772,'AFTERNOON SHIFT','2022-05-10','2022-05-11 17:03:35','2022-05-12 17:03:35','730',2341642.85,2341642.85,'730','2022-05-11 17:07:39','735','2022-05-11 19:17:05',10,0),('1','203',257773,'MORNING SHIFT','2022-05-11','2022-05-11 19:58:28','2022-05-12 19:58:28','730',3101817.15,3101817.15,'730','2022-05-11 20:03:21','735','2022-05-11 22:05:39',10,0),('1','203',257774,'AFTERNOON SHIFT','2022-05-11','2022-05-12 06:52:20','2022-05-13 06:52:20','730',3111048.85,3111048.85,'730','2022-05-12 07:38:24','735','2022-05-12 10:37:42',10,0),('1','203',257775,'MORNING SHIFT','2022-05-12','2022-05-12 13:27:57','2022-05-13 13:27:57','730',1358200.80,1358200.80,'730','2022-05-12 13:33:17','735','2022-05-12 15:26:24',10,0),('1','203',257776,'AFTERNOON SHIFT','2022-05-12','2022-05-12 19:46:39','2022-05-13 19:46:39','730',1549070.30,1549070.30,'730','2022-05-13 06:47:50','735','2022-05-13 07:46:53',10,0),('1','203',257777,'AFTERNOON SHIFT','2022-05-13','2022-05-13 21:53:10','2022-05-14 21:53:10','730',3332418.80,3332418.80,'730','2022-05-14 06:44:29','735','2022-05-14 08:04:36',10,0),('1','203',257778,'MORNING SHIFT','2022-05-14','2022-05-14 12:52:59','2022-05-15 12:52:59','730',1902033.95,1902033.95,'730','2022-05-14 13:01:01','735','2022-05-14 13:06:53',10,0),('1','203',257779,'AFTERNOON SHIFT','2022-05-14','2022-05-14 19:10:32','2022-05-15 19:10:32','730',4990069.50,4990069.50,'730','2022-05-15 09:50:44','761','2022-05-15 14:10:53',10,0),('1','203',257780,'MORNING SHIFT','2022-05-15','2022-05-15 14:51:50','2022-05-16 14:51:50','730',1228101.90,1228101.90,'730','2022-05-15 14:54:25','735','2022-05-15 20:57:37',10,0),('1','203',257781,'AFTERNOON SHIFT','2022-05-15','2022-05-16 07:25:50','2022-05-17 07:25:50','730',3286849.95,3286849.95,'730','2022-05-16 07:31:38','761','2022-05-16 10:20:41',10,0),('1','203',257782,'MORNING SHIFT','2022-05-16','2022-05-16 13:32:48','2022-05-17 13:32:48','730',626641.95,626641.95,'730','2022-05-16 13:34:40','735','2022-05-16 18:17:03',10,0),('1','203',257783,'AFTERNOON SHIFT','2022-05-16','2022-05-16 21:45:17','2022-05-17 21:45:17','730',3181249.20,3181249.20,'730','2022-05-17 06:40:10','761','2022-05-17 11:07:11',10,0),('1','203',257784,'MORNING SHIFT','2022-05-17','2022-05-17 13:40:36','2022-05-18 13:40:36','730',3029588.55,3029588.55,'730','2022-05-17 13:45:45','761','2022-05-17 22:26:14',10,0),('1','203',257785,'AFTERNOON SHIFT','2022-05-17','2022-05-18 07:31:50','2022-05-19 07:31:50','730',695505.60,695505.60,'730','2022-05-18 07:43:11','735','2022-05-18 09:22:25',10,0),('1','203',257786,'MORNING SHIFT','2022-05-18','2022-05-18 13:17:38','2022-05-19 13:17:38','730',3993553.05,3993553.05,'730','2022-05-19 11:33:05','761','2022-05-19 11:47:39',10,0),('1','203',257787,'MORNING SHIFT','2022-05-19','2022-05-19 14:49:29','2022-05-20 14:49:29','730',1181878.50,1181878.50,'730','2022-05-19 15:30:33','735','2022-05-19 19:17:58',10,0),('1','203',257788,'AFTERNOON SHIFT','2022-05-19','2022-05-20 07:13:39','2022-05-21 07:13:39','730',3655276.35,3655276.35,'730','2022-05-20 07:22:29','735','2022-05-20 08:45:02',10,0),('1','203',257789,'MORNING SHIFT','2022-05-20','2022-05-20 12:25:51','2022-05-21 12:25:51','730',1306107.00,1306107.00,'730','2022-05-20 14:10:54','761','2022-05-20 16:24:54',10,0),('1','203',257790,'AFTERNOON SHIFT','2022-05-20','2022-05-20 18:27:06','2022-05-21 18:27:06','730',4406526.30,4406526.30,'730','2022-05-21 09:54:34','735','2022-05-21 11:02:35',10,0),('1','203',257791,'MORNING SHIFT','2022-05-21','2022-05-21 13:07:47','2022-05-22 13:07:47','730',2206488.90,2206488.90,'730','2022-05-21 13:13:26','735','2022-05-21 20:16:08',10,0),('1','203',257792,'AFTERNOON SHIFT','2022-05-21','2022-05-22 08:40:52','2022-05-23 08:40:52','730',2482695.60,2482695.60,'730','2022-05-23 05:55:33','761','2022-05-23 08:32:25',10,0),('1','203',257793,'AFTERNOON SHIFT','2022-05-22','2022-05-23 09:44:58','2022-05-24 09:44:58','730',3305611.65,3305611.65,'730','2022-05-23 11:11:10','761','2022-05-23 11:31:50',10,0),('1','203',257794,'AFTERNOON SHIFT','2022-05-25','2022-05-25 14:01:25','2022-05-26 14:01:25','730',2636351.85,2636351.85,'730','2022-05-26 08:27:38','761','2022-05-26 09:42:44',10,0),('1','203',257795,'MORNING SHIFT','2022-05-26','2022-05-26 14:37:38','2022-05-27 14:37:38','730',2025163.80,2025163.80,'730','2022-05-26 14:42:43','735','2022-05-26 15:15:18',10,0),('1','203',257796,'AFTERNOON SHIFT','2022-05-27','2022-05-27 21:19:02','2022-05-28 21:19:02','730',1582741.05,1582741.05,'730','2022-05-28 09:21:50','761','2022-05-28 11:51:17',10,0),('1','203',257797,'MORNING SHIFT','2022-05-28','2022-05-28 16:36:18','2022-05-29 16:36:18','730',1754908.65,1754908.65,'730','2022-05-28 16:48:47','735','2022-05-28 18:16:14',10,0),('1','203',257798,'AFTERNOON SHIFT','2022-05-28','2022-05-28 21:40:41','2022-05-29 21:40:41','730',3095292.75,3095292.75,'730','2022-05-29 06:42:18','735','2022-05-29 12:49:41',10,0),('1','203',257799,'MORNING SHIFT','2022-05-29','2022-05-29 16:29:58','2022-05-30 16:29:58','730',2714017.35,2714017.35,'730','2022-05-30 09:31:43','761','2022-05-30 09:53:21',10,0),('1','203',257800,'AFTERNOON SHIFT','2022-05-29','2022-05-30 10:10:18','2022-05-31 10:10:18','730',302411.60,302411.60,'730','2022-05-30 10:11:26','761','2022-05-30 10:13:44',10,0),('1','203',257801,'AFTERNOON SHIFT','2022-05-30','2022-05-30 17:46:04','2022-05-31 17:46:04','730',3466604.80,3466604.80,'730','2022-05-30 23:07:59','761','2022-05-31 08:42:33',10,0),('1','203',257802,'AFTERNOON SHIFT','2022-05-30','2022-05-31 09:52:57','2022-06-01 09:52:57','730',6970869.00,6970869.00,'730','2022-05-31 10:02:52','735','2022-05-31 11:16:05',10,0),('1','203',257803,'MORNING SHIFT','2022-05-31','2022-05-31 11:36:50','2022-06-01 11:36:50','730',6561443.35,6561443.35,'730','2022-05-31 16:29:28','735','2022-05-31 22:16:15',10,0),('1','203',257804,'AFTERNOON SHIFT','2022-05-31','2022-06-01 08:09:55','2022-06-02 08:09:55','730',369291.60,369291.60,'730','2022-06-01 08:10:52','761','2022-06-01 08:47:05',10,0),('1','203',257805,'MORNING SHIFT','2022-06-01','2022-06-01 14:19:46','2022-06-02 14:19:46','730',3788489.20,3788489.20,'730','2022-06-01 14:23:49','761','2022-06-01 22:06:59',10,0),('1','203',257806,'AFTERNOON SHIFT','2022-06-01','2022-06-02 05:46:16','2022-06-03 05:46:16','730',7215623.45,7215623.45,'730','2022-06-02 10:58:16','761','2022-06-02 13:37:05',10,0),('1','203',257807,'MORNING SHIFT','2022-06-02','2022-06-02 14:02:21','2022-06-03 14:02:21','730',3833294.10,3833294.10,'730','2022-06-02 14:08:15','735','2022-06-02 18:08:23',10,0),('1','203',257808,'AFTERNOON SHIFT','2022-06-02','2022-06-03 05:59:54','2022-06-04 05:59:54','730',2929787.60,2929787.60,'730','2022-06-03 06:05:59','735','2022-06-03 07:49:31',10,0),('1','203',257809,'MORNING SHIFT','2022-06-03','2022-06-03 08:13:52','2022-06-04 08:13:52','730',246718.80,246718.80,'730','2022-06-03 09:32:02','735','2022-06-03 14:36:41',10,0),('1','203',257810,'MORNING SHIFT II','2022-06-03','2022-06-03 15:39:02','2022-06-04 15:39:02','730',3005124.10,3005124.10,'730','2022-06-03 15:47:28','735','2022-06-03 23:36:12',10,0),('1','203',257811,'AFTERNOON SHIFT','2022-06-04','2022-06-04 07:30:00','2022-06-05 07:30:00','730',826410.20,826410.20,'730','2022-06-04 08:01:52','735','2022-06-04 22:14:07',10,0),('1','203',257812,'MORNING SHIFT','2022-06-04','2022-06-05 08:37:30','2022-06-06 08:37:30','730',4486045.30,4486045.30,'730','2022-06-05 08:56:22','761','2022-06-05 11:22:26',10,0),('1','203',257813,'AFTERNOON SHIFT','2022-06-05','2022-06-05 18:28:51','2022-06-06 18:28:51','730',4032695.70,4032695.70,'730','2022-06-06 07:38:25','761','2022-06-06 10:57:39',10,0),('1','203',257814,'AFTERNOON SHIFT','2022-06-06','2022-06-06 20:22:17','2022-06-07 20:22:17','730',1579716.60,1579716.60,'730','2022-06-07 07:20:25','761','2022-06-07 09:26:58',10,0),('1','203',257815,'MORNING SHIFT','2022-06-07','2022-06-07 20:13:30','2022-06-08 20:13:30','730',84207.20,84207.20,'730','2022-06-07 20:14:17','735','2022-06-07 22:47:27',10,0),('1','203',257816,'AFTERNOON SHIFT','2022-06-08','2022-06-08 12:27:58','2022-06-09 12:27:58','730',3046355.40,3046355.40,'730','2022-06-09 08:17:42','761','2022-06-09 09:20:30',10,0),('1','203',257817,'MORNING SHIFT','2022-06-09','2022-06-09 14:41:37','2022-06-10 14:41:37','730',2759110.20,2759110.20,'730','2022-06-09 14:43:51','735','2022-06-09 16:01:38',10,0),('1','203',257818,'AFTERNOON SHIFT','2022-06-09','2022-06-09 22:20:32','2022-06-10 22:20:32','730',2469960.90,2469960.90,'730','2022-06-10 05:52:22','735','2022-06-10 08:08:50',10,0),('1','203',257819,'MORNING SHIFT','2022-06-10','2022-06-10 12:04:26','2022-06-11 12:04:26','730',2309547.90,2309547.90,'730','2022-06-10 12:09:08','735','2022-06-10 14:35:44',10,0),('1','203',257820,'AFTERNOON SHIFT','2022-06-10','2022-06-11 06:09:50','2022-06-12 06:09:50','730',2945892.25,2945892.25,'730','2022-06-11 06:32:24','735','2022-06-11 08:23:05',10,0),('1','203',257821,'MORNING SHIFT','2022-06-11','2022-06-11 11:00:01','2022-06-12 11:00:01','730',300776.00,300776.00,'730','2022-06-11 11:04:44','735','2022-06-11 11:09:10',10,0),('1','203',257822,'AFTERNOON SHIFT','2022-06-11','2022-06-11 16:31:18','2022-06-12 16:31:18','730',4094516.10,4094516.10,'730','2022-06-12 08:13:06','735','2022-06-12 08:14:37',10,0),('1','203',257823,'MORNING SHIFT','2022-06-12','2022-06-12 13:26:07','2022-06-13 13:26:07','730',975445.30,975445.30,'730','2022-06-12 13:29:58','735','2022-06-12 13:57:17',10,0),('1','203',257824,'AFTERNOON SHIFT','2022-06-12','2022-06-13 07:09:53','2022-06-14 07:09:53','730',351682.65,351682.65,'730','2022-06-13 07:14:06','735','2022-06-13 09:57:52',10,0),('1','203',257825,'AFTERNOON SHIFT','2022-06-13','2022-06-13 13:52:35','2022-06-14 13:52:35','730',846912.40,846912.40,'730','2022-06-14 07:34:31','735','2022-06-14 09:50:25',10,0),('1','203',257826,'AFTERNOON SHIFT','2022-06-14','2022-06-14 13:40:44','2022-06-15 13:40:44','730',3086847.95,3086847.95,'730','2022-06-15 05:54:49','761','2022-06-15 10:29:18',10,0),('1','203',257827,'MORNING SHIFT','2022-06-15','2022-06-15 10:50:25','2022-06-16 10:50:25','730',2103330.00,2103330.00,'730','2022-06-15 10:54:58','735','2022-06-15 18:46:04',10,0),('1','203',257828,'MORNING SHIFT','2022-06-15','2022-06-15 21:51:40','2022-06-16 21:51:40','730',5962250.15,5962250.15,'730','2022-06-16 07:43:33','735','2022-06-16 07:46:01',10,0),('1','203',257829,'MORNING SHIFT','2022-06-16','2022-06-16 10:20:11','2022-06-17 10:20:11','730',1430937.75,1430937.75,'730','2022-06-16 13:15:08','761','2022-06-16 15:53:35',10,0),('1','203',257830,'AFTERNOON SHIFT','2022-06-16','2022-06-17 07:03:16','2022-06-18 07:03:16','730',3476462.65,3476462.65,'730','2022-06-17 07:06:27','761','2022-06-17 10:26:19',10,0),('1','203',257831,'AFTERNOON SHIFT','2022-06-17','2022-06-17 19:21:15','2022-06-18 19:21:15','730',1547980.60,1547980.60,'730','2022-06-18 07:46:42','735','2022-06-18 10:36:52',10,0),('1','203',257832,'MORNING SHIFT','2022-06-18','2022-06-18 13:17:01','2022-06-19 13:17:01','730',2885457.70,2885457.70,'730','2022-06-18 14:00:21','735','2022-06-18 18:19:49',10,0),('1','203',257833,'AFTERNOON SHIFT','2022-06-18','2022-06-19 06:55:12','2022-06-20 06:55:12','730',303912.80,303912.80,'730','2022-06-19 06:57:54','735','2022-06-19 08:01:48',10,0),('1','203',257834,'AFTERNOON SHIFT','2022-06-19','2022-06-20 06:25:40','2022-06-21 06:25:40','730',391120.90,391120.90,'730','2022-06-20 06:46:27','735','2022-06-20 09:18:12',10,0),('1','203',257835,'AFTERNOON SHIFT','2022-06-20','2022-06-20 16:21:09','2022-06-21 16:21:09','730',4642274.10,4642274.10,'730','2022-06-21 09:02:23','735','2022-06-21 09:05:29',10,0),('1','203',257836,'MORNING SHIFT ','2022-06-21','2022-06-21 13:51:25','2022-06-22 13:51:25','730',3329158.30,3329158.30,'730','2022-06-21 13:58:47','735','2022-06-21 14:39:27',10,0),('1','203',257837,'AFTERNOON SHIFT ','2022-06-21','2022-06-21 16:44:50','2022-06-22 16:44:50','730',2058140.05,2058140.05,'730','2022-06-22 07:16:31','735','2022-06-22 08:24:29',10,0),('1','203',257838,'MORNING SHIFT ','2022-06-22','2022-06-22 10:46:24','2022-06-23 10:46:24','730',3191712.15,3191712.15,'730','2022-06-22 13:32:41','735','2022-06-22 15:02:00',10,0),('1','203',257839,'AFTERNOON SHIFT ','2022-06-22','2022-06-23 07:14:58','2022-06-24 07:14:58','730',1287255.30,1287255.30,'730','2022-06-23 07:17:01','761','2022-06-23 09:02:41',10,0),('1','203',257840,'AFTERNOON SHIFT ','2022-06-23','2022-06-23 18:08:14','2022-06-24 18:08:14','730',1260367.75,1260367.75,'730','2022-06-24 07:28:53','735','2022-06-24 08:47:32',10,0),('1','203',257841,'AFTERNOON SHIFT ','2022-06-24','2022-06-24 22:41:26','2022-06-25 22:41:26','730',2255944.85,2255944.85,'730','2022-06-25 09:22:11','735','2022-06-25 10:03:34',10,0),('1','203',257842,'MORNING SHIFT ','2022-06-25','2022-06-25 13:01:18','2022-06-26 13:01:18','730',1971382.90,1971382.90,'730','2022-06-25 13:58:14','735','2022-06-25 22:59:37',10,0),('1','203',257843,'AFTERNOON SHIFT ','2022-06-25','2022-06-26 07:25:44','2022-06-27 07:25:44','730',3988728.10,3988728.10,'730','2022-06-26 07:30:51','735','2022-06-26 09:09:17',10,0),('1','203',257844,'AFTERNOON SHIFT ','2022-06-26','2022-06-26 12:38:11','2022-06-27 12:38:11','730',1497453.60,1497453.60,'730','2022-06-26 13:25:51','735','2022-06-26 13:34:10',10,0),('1','203',257845,'AFTERNOON SHIFT ','2022-06-26','2022-06-27 06:49:43','2022-06-28 06:49:43','730',2664398.80,2664398.80,'730','2022-06-27 06:54:45','735','2022-06-27 08:55:59',10,0),('1','203',257846,'MORNING SHIFT ','2022-06-27','2022-06-27 13:21:21','2022-06-28 13:21:21','730',2410616.65,2410616.65,'730','2022-06-27 13:26:25','761','2022-06-27 15:44:55',10,0),('1','203',257847,'AFTERNOON SHIFT ','2022-06-27','2022-06-27 15:47:04','2022-06-28 15:47:04','730',4313724.25,4313724.25,'730','2022-06-28 10:53:10','735','2022-06-28 18:43:05',10,0),('1','203',257848,'AFTERNOON SHIFT ','2022-06-28','2022-06-28 22:09:23','2022-06-29 22:09:23','730',1288696.00,1337022.10,'730','2022-06-29 08:32:35','761','2022-06-29 14:34:29',10,0),('1','203',257849,'AFTERNOON SHIFT ','2022-06-29','2022-06-29 20:31:57','2022-06-30 20:31:57','730',2613684.90,2613684.90,'730','2022-06-30 05:49:21','735','2022-06-30 11:50:19',10,0),('1','203',257850,'AFTERNOON SHIFT ','2022-06-30','2022-06-30 17:52:15','2022-07-01 17:52:15','730',4035521.85,4035521.85,'730','2022-06-30 22:18:47','735','2022-07-01 09:57:00',10,0),('1','203',257851,'AFTERNOON SHIFT ','2022-07-01','2022-07-01 13:59:31','2022-07-02 13:59:31','730',4952577.80,4952577.80,'730','2022-07-02 07:46:19','735','2022-07-02 13:04:21',10,0),('1','203',257852,'MORNING SHIFT ','2022-07-02','2022-07-02 14:44:07','2022-07-03 14:44:07','730',1103043.65,1103043.65,'730','2022-07-02 14:47:40','735','2022-07-02 21:28:43',10,0),('1','203',257853,'AFTERNOON SHIFT ','2022-07-02','2022-07-03 06:00:02','2022-07-04 06:00:02','730',462084.50,462084.50,'730','2022-07-03 06:02:33','735','2022-07-03 09:51:31',10,0),('1','203',257854,'AFTERNOON SHIFT ','2022-07-03','2022-07-03 20:53:26','2022-07-04 20:53:26','730',5267943.40,5267943.40,'730','2022-07-04 09:40:05','761','2022-07-04 09:53:06',10,0),('1','203',257855,'AFTERNOON SHIFT ','2022-07-04','2022-07-04 21:40:55','2022-07-05 21:40:55','730',1488644.90,1488644.90,'730','2022-07-05 06:16:26','735','2022-07-05 09:20:55',10,0),('1','203',257856,'MORNING SHIFT ','2022-07-05','2022-07-05 10:51:07','2022-07-06 10:51:07','730',4778639.85,4778639.85,'730','2022-07-05 15:14:46','735','2022-07-05 23:45:02',10,0),('1','203',257857,'AFTERNOON SHIFT ','2022-07-05','2022-07-06 08:10:41','2022-07-07 08:10:41','730',1388450.40,1388450.40,'730','2022-07-06 08:12:21','735','2022-07-06 13:12:21',10,0),('1','203',257858,'AFTERNOON SHIFT ','2022-07-06','2022-07-06 20:52:30','2022-07-07 20:52:30','730',2811239.30,2811239.30,'730','2022-07-07 05:51:03','735','2022-07-07 11:56:25',10,0),('1','203',257859,'MORNING SHIFT ','2022-07-07','2022-07-07 13:51:54','2022-07-08 13:51:54','730',3299894.30,3299894.30,'730','2022-07-07 13:56:45','735','2022-07-07 22:37:32',10,0),('1','203',257860,'AFTERNOON SHIFT ','2022-07-07','2022-07-08 04:58:57','2022-07-09 04:58:57','730',1126243.45,1126243.45,'730','2022-07-08 05:25:47','735','2022-07-08 10:22:44',10,0),('1','203',257861,'MORNING SHIFT ','2022-07-08','2022-07-08 11:08:33','2022-07-09 11:08:33','730',41682.35,41682.35,'730','2022-07-08 11:22:09','735','2022-07-09 07:23:37',10,0),('1','203',257862,'AFTERNOON SHIFT ','2022-07-08','2022-07-09 09:53:59','2022-07-10 09:53:59','730',3057390.25,3057390.25,'730','2022-07-09 09:58:49','761','2022-07-09 11:34:04',10,0),('1','203',257863,'AFTERNOON SHIFT ','2022-07-09','2022-07-09 19:31:51','2022-07-10 19:31:51','730',806869.15,806869.15,'730','2022-07-10 07:58:36','735','2022-07-10 13:07:41',10,0),('1','203',257864,'AFTERNOON SHIFT ','2022-07-10','2022-07-11 06:47:32','2022-07-12 06:47:32','730',232760.25,232760.25,'730','2022-07-11 06:51:59','735','2022-07-11 08:00:37',10,0),('1','203',257865,'MORNING SHIFT I ','2022-07-11','2022-07-11 09:02:33','2022-07-12 09:02:33','730',282549.30,282549.30,'730','2022-07-11 10:15:26','735','2022-07-11 14:52:19',10,0),('1','203',257866,'AFTERNOON SHIFT ','2022-07-11','2022-07-11 19:48:52','2022-07-12 19:48:52','730',5918530.75,5918530.75,'730','2022-07-11 19:53:03','735','2022-07-12 00:53:16',10,0),('1','203',257867,'AFTERNOON SHIFT','2022-07-12','2022-07-12 11:18:35','2022-07-13 11:18:35','730',866455.35,866455.35,'730','2022-07-12 20:11:39','735','2022-07-13 08:17:24',10,0),('1','203',257868,'AFTERNOON SHIFT ','2022-07-13','2022-07-13 20:39:16','2022-07-14 20:39:16','730',3246366.85,3246366.85,'730','2022-07-14 07:07:30','735','2022-07-14 09:35:44',10,0),('1','203',257869,'AFTERNOON SHIFT','2022-07-14','2022-07-14 13:16:50','2022-07-15 13:16:50','730',1494151.25,1494151.25,'730','2022-07-14 13:20:08','735','2022-07-15 06:53:54',10,0),('1','203',257870,'AFTERNOON SHIFT ','2022-07-14','2022-07-15 06:58:28','2022-07-16 06:58:28','730',2938882.95,2938882.95,'730','2022-07-15 08:30:50','761','2022-07-15 15:17:50',10,0),('1','203',257871,'MORNING SHIFT','2022-07-15','2022-07-15 16:23:55','2022-07-16 16:23:55','730',1971716.45,1971716.45,'730','2022-07-15 16:32:30','735','2022-07-16 00:19:57',10,0),('1','203',257872,'AFTERNOON SHIFT ','2022-07-15','2022-07-16 07:48:24','2022-07-17 07:48:24','730',171544.40,171544.40,'730','2022-07-16 07:49:22','735','2022-07-16 09:19:03',10,0),('1','203',257873,'AFTERNOON SHIFT ','2022-07-16','2022-07-16 17:09:24','2022-07-17 17:09:24','730',1107767.80,1107767.80,'730','2022-07-17 06:43:44','735','2022-07-17 07:12:31',10,0),('1','203',257874,'AFTERNOON SHIFT','2022-07-17','2022-07-18 07:21:48','2022-07-19 07:21:48','730',413198.90,413198.90,'730','2022-07-18 07:24:13','761','2022-07-18 10:50:25',10,0),('1','203',257875,'AFTERNOON SHIFT ','2022-07-18','2022-07-18 17:19:30','2022-07-19 17:19:30','730',975225.10,975225.10,'730','2022-07-19 07:11:36','735','2022-07-19 09:06:42',10,0),('1','203',257876,'AFTERNOON SHIFT ','2022-07-19','2022-07-20 06:27:27','2022-07-21 06:27:27','730',1211982.60,1211982.60,'730','2022-07-20 06:31:52','735','2022-07-20 09:10:02',10,0),('1','203',257877,'AFTERNOON SHIFT ','2022-07-20','2022-07-20 19:38:54','2022-07-21 19:38:54','730',559079.70,559079.70,'730','2022-07-20 19:41:52','735','2022-07-21 12:03:34',10,0),('1','203',257878,'AFTERNOON SHIFT ','2022-07-21','2022-07-21 23:48:46','2022-07-22 23:48:46','730',707307.40,707307.40,'730','2022-07-22 07:02:07','735','2022-07-22 10:27:18',10,0),('1','203',257879,'MORNING SHIFT ','2022-07-22','2022-07-22 18:12:37','2022-07-23 18:12:37','730',427949.80,427949.80,'730','2022-07-22 20:30:29','735','2022-07-23 00:00:34',10,0),('1','203',257880,'AFTERNOON SHIFT ','2022-07-23','2022-07-23 08:51:14','2022-07-24 08:51:14','730',398884.50,398884.50,'730','2022-07-23 09:08:05','735','2022-07-23 20:26:41',10,0),('1','203',257881,'AFTERNOON SHIFT ','2022-07-23','2022-07-24 07:37:19','2022-07-25 07:37:19','730',3207843.20,3207843.20,'730','2022-07-24 07:44:23','735','2022-07-24 08:36:51',10,0),('1','203',257882,'MORNING SHIFT','2022-07-24','2022-07-24 13:24:34','2022-07-25 13:24:34','730',2624136.05,2624136.05,'730','2022-07-24 13:38:16','735','2022-07-24 20:15:11',10,0),('1','203',257883,'AFTERNOON SHIFT ','2022-07-24','2022-07-25 08:31:04','2022-07-26 08:31:04','730',2598358.70,2598358.70,'730','2022-07-25 13:57:33','735','2022-07-25 22:49:52',10,0),('1','203',257884,'MORNING SHIFT ','2022-07-25','2022-07-26 04:45:40','2022-07-27 04:45:40','730',4550058.55,4550058.55,'730','2022-07-26 04:51:31','735','2022-07-26 10:22:31',10,0),('1','203',257885,'AFTERNOON SHIFT ','2022-07-25','2022-07-26 10:25:04','2022-07-27 10:25:04','730',6149954.50,6149954.50,'730','2022-07-26 11:11:53','761','2022-07-26 13:26:42',10,0),('1','203',257886,'MORNING SHIFT ','2022-07-26','2022-07-26 13:39:31','2022-07-27 13:39:31','730',3974748.75,3974748.75,'730','2022-07-26 13:45:57','735','2022-07-26 17:59:38',10,0),('1','203',257887,'AFTERNOON SHIFT ','2022-07-26','2022-07-27 05:26:19','2022-07-28 05:26:19','730',3901801.75,3901801.75,'730','2022-07-27 06:17:47','735','2022-07-27 08:59:10',10,0),('1','203',257888,'MORNING SHIFT ','2022-07-27','2022-07-27 14:00:33','2022-07-28 14:00:33','730',3406826.50,3406826.50,'730','2022-07-27 14:05:38','735','2022-07-27 16:20:40',10,0),('1','203',257889,'AFTERNOON SHIFT ','2022-07-27','2022-07-27 22:21:35','2022-07-28 22:21:35','730',127216.25,127216.25,'730','2022-07-28 08:20:05','735','2022-07-28 15:45:48',10,0),('1','203',257890,'AFTERNOON SHIFT ','2022-08-01','2022-08-02 09:56:26','2022-08-03 09:56:26','730',578923.20,578923.20,'730','2022-08-02 09:57:42','735','2022-08-02 17:50:56',10,0),('1','203',257891,'AFTERNOON SHIFT ','2022-08-02','2022-08-03 07:16:40','2022-08-04 07:16:40','730',4385743.80,4385743.80,'730','2022-08-03 07:21:28','735','2022-08-03 08:06:53',10,0),('1','203',257892,'AFTERNOON SHIFT ','2022-08-03','2022-08-03 11:34:28','2022-08-04 11:34:28','730',923983.20,923983.20,'730','2022-08-04 08:25:23','735','2022-08-04 10:13:13',10,0),('1','203',257893,'AFTERNOON SHIFT ','2022-08-04','2022-08-04 14:05:18','2022-08-05 14:05:18','730',5784268.35,5784268.35,'730','2022-08-05 06:53:47','735','2022-08-05 15:12:35',10,0),('1','203',257894,'MORNING SHIFT ','2022-08-05','2022-08-05 16:39:17','2022-08-06 16:39:17','730',3324538.20,3324538.20,'730','2022-08-05 16:51:19','735','2022-08-05 18:27:07',10,0),('1','203',257895,'AFTERNOON SHIFT ','2022-08-05','2022-08-06 08:45:44','2022-08-07 08:45:44','730',5895985.65,5895985.65,'730','2022-08-06 08:50:02','735','2022-08-06 19:41:16',10,0),('1','203',257896,'MORNING SHIFT ','2022-08-06','2022-08-06 20:11:54','2022-08-07 20:11:54','730',4747825.05,4747825.05,'730','2022-08-06 20:17:54','735','2022-08-07 07:34:30',10,0),('1','203',257897,'AFTERNOON SHIFT ','2022-08-06','2022-08-07 08:48:31','2022-08-08 08:48:31','730',5206759.25,5206759.25,'730','2022-08-07 08:52:21','735','2022-08-07 11:05:26',10,0),('1','203',257898,'MORNING SHIFT ','2022-08-07','2022-08-07 15:46:51','2022-08-08 15:46:51','730',2034324.55,2034324.55,'730','2022-08-08 05:07:20','735','2022-08-08 12:28:55',10,0),('1','203',257899,'AFTERNOON SHIFT ','2022-08-07','2022-08-08 13:38:27','2022-08-09 13:38:27','730',1981522.70,1981522.70,'730','2022-08-08 13:42:20','761','2022-08-08 17:14:51',10,0),('1','203',257900,'MORNING SHIFT ','2022-08-08','2022-08-08 18:45:31','2022-08-09 18:45:31','730',2241894.80,2241894.80,'730','2022-08-08 19:10:18','735','2022-08-08 23:52:10',10,0),('1','203',257901,'AFTERNOON SHIFT ','2022-08-08','2022-08-09 09:10:47','2022-08-10 09:10:47','730',1882766.45,1882766.45,'730','2022-08-09 09:20:21','735','2022-08-09 10:02:27',10,0),('1','203',257902,'AFTERNOON SHIFT ','2022-08-09','2022-08-09 16:55:58','2022-08-10 16:55:58','730',5509830.90,5509830.90,'730','2022-08-10 07:29:25','735','2022-08-10 09:27:38',10,0),('1','203',257903,'MORNING SHIFT ','2022-08-10','2022-08-10 13:31:57','2022-08-11 13:31:57','730',3834655.05,3834655.05,'730','2022-08-10 13:34:49','735','2022-08-11 01:06:36',10,0),('1','203',257904,'AFTERNOON SHIFT ','2022-08-10','2022-08-11 06:23:52','2022-08-12 06:23:52','730',1927711.00,1927711.00,'730','2022-08-11 07:00:50','761','2022-08-11 10:15:19',10,0),('1','203',257905,'MORNING SHIFT ','2022-08-11','2022-08-11 14:41:10','2022-08-12 14:41:10','730',3606062.70,3606062.70,'730','2022-08-11 14:46:00','735','2022-08-11 19:48:12',10,0),('1','203',257906,'AFTERNOON SHIFT ','2022-08-12','2022-08-12 07:22:11','2022-08-13 07:22:11','730',116089.20,116089.20,'730','2022-08-12 07:36:53','735','2022-08-12 08:22:41',10,0),('1','203',257907,'MORNING SHIFT ','2022-08-12','2022-08-12 12:39:18','2022-08-13 12:39:18','730',2768362.90,2768362.90,'730','2022-08-12 15:33:45','735','2022-08-12 21:57:50',10,0),('1','203',257908,'AFTERNOON SHIFT ','2022-08-12','2022-08-13 07:14:37','2022-08-14 07:14:37','730',255214.80,255214.80,'730','2022-08-13 07:15:33','735','2022-08-14 01:23:12',10,0),('1','203',257909,'AFTERNOON SHIFT ','2022-08-13','2022-08-14 06:29:39','2022-08-15 06:29:39','730',4698949.45,4698949.45,'730','2022-08-14 09:39:43','735','2022-08-14 22:55:27',10,0),('1','203',257910,'AFTERNOON SHIFT ','2022-08-14','2022-08-15 09:08:27','2022-08-16 09:08:27','730',627369.30,627369.30,'730','2022-08-15 09:10:49','735','2022-08-15 19:26:18',10,0),('1','203',257911,'AFTERNOON SHIFT ','2022-08-15','2022-08-16 01:29:41','2022-08-17 01:29:41','730',2270209.75,2270209.75,'730','2022-08-16 14:36:55','761','2022-08-16 15:25:39',10,0),('1','203',257912,'MORNING SHIFT ','2022-08-16','2022-08-16 18:12:56','2022-08-17 18:12:56','730',3022010.00,3022010.00,'730','2022-08-16 20:17:35','735','2022-08-16 22:29:23',10,0),('1','203',257913,'AFTERNOON SHIFT','2022-08-16','2022-08-17 08:17:10','2022-08-18 08:17:10','730',348518.70,348518.70,'730','2022-08-17 11:20:18','735','2022-08-17 13:04:09',10,0),('1','203',257914,'MORNING SHIFT ','2022-08-17','2022-08-17 13:30:17','2022-08-18 13:30:17','730',314498.70,314498.70,'730','2022-08-17 13:33:01','735','2022-08-17 18:40:20',10,0),('1','203',257915,'AFTERNOON SHIFT ','2022-08-17','2022-08-18 07:52:19','2022-08-19 07:52:19','730',317008.00,317008.00,'730','2022-08-18 07:53:40','735','2022-08-18 13:28:42',10,0),('1','203',257916,'MORNING SHIFT','2022-08-18','2022-08-18 20:40:45','2022-08-19 20:40:45','730',2917278.00,2917278.00,'730','2022-08-18 20:53:49','735','2022-08-18 22:47:55',10,0),('1','203',257917,'AFTERNOON SHIFT ','2022-08-18','2022-08-19 10:04:24','2022-08-20 10:04:24','730',3065457.75,3065457.75,'730','2022-08-19 10:14:16','735','2022-08-19 11:11:59',10,0),('1','203',257918,'MORNING SHIFT ','2022-08-19','2022-08-19 15:55:47','2022-08-20 15:55:47','730',3203363.00,3203363.00,'730','2022-08-19 20:15:50','735','2022-08-20 08:27:19',10,0),('1','203',257919,'AFTERNOON SHIFT ','2022-08-19','2022-08-20 08:45:03','2022-08-21 08:45:03','730',3871200.25,3871200.25,'730','2022-08-20 08:54:34','735','2022-08-20 16:48:04',10,0),('1','203',257920,'MORNING SHIFT ','2022-08-20','2022-08-20 16:51:33','2022-08-21 16:51:33','730',4092442.50,4092442.50,'730','2022-08-20 16:56:23','735','2022-08-20 16:59:21',10,0),('1','203',257921,'AFTERNOON SHIFT ','2022-08-20','2022-08-20 19:31:20','2022-08-21 19:31:20','730',4165030.50,4165030.50,'730','2022-08-21 07:45:25','735','2022-08-21 09:12:56',10,0),('1','203',257922,'MORNING SHIFT ','2022-08-21','2022-08-21 13:27:43','2022-08-22 13:27:43','730',957807.75,957807.75,'730','2022-08-21 13:38:38','735','2022-08-21 19:21:20',10,0),('1','203',257923,'AFTERNOON SHIFT ','2022-08-21','2022-08-22 05:34:16','2022-08-23 05:34:16','730',124088.00,124088.00,'730','2022-08-22 05:36:30','735','2022-08-22 13:21:40',10,0),('1','203',257924,'MORNING SHIFT ','2022-08-22','2022-08-22 14:09:32','2022-08-23 14:09:32','730',2969907.75,2969907.75,'730','2022-08-22 15:12:48','735','2022-08-22 18:03:20',10,0),('1','203',257925,'AFTERNOON SHIFT ','2022-08-22','2022-08-23 07:46:25','2022-08-24 07:46:25','730',1864497.00,1864497.00,'730','2022-08-23 08:01:22','735','2022-08-23 08:56:08',10,0),('1','203',257926,'MORNING SHIFT ','2022-08-23','2022-08-23 13:25:47','2022-08-24 13:25:47','730',2935215.75,2935215.75,'730','2022-08-23 15:23:46','735','2022-08-23 17:58:59',10,0),('1','203',257927,'AFTERNOON SHIFT ','2022-08-23','2022-08-24 05:32:45','2022-08-25 05:32:45','730',3406356.00,3406356.00,'730','2022-08-24 08:43:00','735','2022-08-24 09:05:13',10,0),('1','203',257928,'MORNING SHIFT','2022-08-24','2022-08-24 11:50:57','2022-08-25 11:50:57','730',2535404.00,2535404.00,'730','2022-08-24 15:26:53','735','2022-08-24 23:28:11',10,0),('1','203',257929,'AFTERNOON SHIFT ','2022-08-24','2022-08-25 08:48:43','2022-08-26 08:48:43','730',3085460.50,3085460.50,'730','2022-08-25 10:00:29','761','2022-08-25 11:42:38',10,0),('1','203',257930,'MORNING SHIFT ','2022-08-25','2022-08-25 12:30:26','2022-08-26 12:30:26','730',3388391.00,3388391.00,'730','2022-08-25 13:43:59','735','2022-08-25 15:33:38',10,0),('1','203',257931,'AFTERNOON SHIFT ','2022-08-25','2022-08-25 19:20:02','2022-08-26 19:20:02','730',2972430.25,2972430.25,'730','2022-08-26 06:53:28','735','2022-08-26 11:18:15',10,0),('1','203',257932,'MORNING SHIFT ','2022-08-26','2022-08-26 14:02:45','2022-08-27 14:02:45','730',3318194.75,3318194.75,'730','2022-08-26 14:56:10','735','2022-08-26 18:09:45',10,0),('1','203',257933,'AFTERNOON SHIFT ','2022-08-26','2022-08-27 05:56:46','2022-08-28 05:56:46','730',2885961.75,2885961.75,'730','2022-08-27 07:07:09','735','2022-08-27 11:11:18',10,0),('1','203',257934,'AFTERNOON SHIFT ','2022-08-28','2022-08-28 16:40:24','2022-08-29 16:40:24','730',2050747.00,2050747.00,'730','2022-08-29 07:01:50','735','2022-08-29 08:32:55',10,0),('1','203',257935,'MORNING SHIFT ','2022-08-29','2022-08-29 09:05:20','2022-08-30 09:05:20','730',2937796.50,2937796.50,'730','2022-08-29 13:22:10','735','2022-08-29 17:30:04',10,0),('1','203',257936,'AFTERNOON SHIFT ','2022-08-29','2022-08-30 05:59:54','2022-08-31 05:59:54','730',3401105.00,3401105.00,'730','2022-08-30 07:16:25','735','2022-08-30 10:03:36',10,0),('1','203',257937,'MORNING ','2022-08-30','2022-08-30 13:52:17','2022-08-31 13:52:17','730',1077290.00,1077290.00,'730','2022-08-30 13:55:59','735','2022-08-30 20:25:15',10,0),('1','203',257938,'AFTERNOON SHIFT ','2022-08-30','2022-08-31 07:36:50','2022-09-01 07:36:50','730',201416.00,201416.00,'730','2022-08-31 07:38:08','735','2022-08-31 15:16:14',10,0),('1','203',257939,'AFTERNOON SHIFT ','2022-08-31','2022-08-31 18:01:30','2022-09-01 18:01:30','730',5127811.25,5127811.25,'730','2022-09-01 07:41:25','735','2022-09-01 08:58:44',10,0),('1','203',257940,'MORNING SHIFT ','2022-09-01','2022-09-01 13:50:09','2022-09-02 13:50:09','730',2985129.25,2985129.25,'730','2022-09-01 13:55:12','735','2022-09-01 18:10:02',10,0),('1','203',257941,'AFTERNOON SHIFT ','2022-09-01','2022-09-01 21:41:30','2022-09-02 21:41:30','730',2868723.75,2868723.75,'730','2022-09-02 07:46:51','735','2022-09-02 08:07:30',10,0),('1','203',257942,'MORNING SHIFT ','2022-09-02','2022-09-02 11:26:09','2022-09-03 11:26:09','730',2993548.25,2993548.25,'730','2022-09-02 14:05:27','735','2022-09-02 15:47:33',10,0),('1','203',257943,'AFTERNOON SHIFT ','2022-09-02','2022-09-03 06:26:25','2022-09-04 06:26:25','730',2874471.75,2874471.75,'730','2022-09-03 06:48:12','735','2022-09-03 08:42:03',10,0),('1','203',257944,'MORNING SHIFT ','2022-09-03','2022-09-03 13:28:40','2022-09-04 13:28:40','730',3355454.50,3355454.50,'730','2022-09-03 13:33:23','735','2022-09-04 00:50:34',10,0),('1','203',257945,'AFTERNOON SHIFT ','2022-09-03','2022-09-04 06:45:24','2022-09-05 06:45:24','730',3269372.25,3269372.25,'730','2022-09-04 07:05:10','735','2022-09-04 09:57:33',10,0),('1','203',257946,'MORNING SHIFT ','2022-09-04','2022-09-04 15:50:26','2022-09-05 15:50:26','730',4092475.25,4092475.25,'730','2022-09-05 06:29:01','761','2022-09-05 08:08:38',10,0),('1','203',257947,'MORNING SHIFT ','2022-09-05','2022-09-05 11:35:03','2022-09-06 11:35:03','730',2965816.75,2965816.75,'730','2022-09-05 13:51:26','735','2022-09-05 17:38:05',10,0),('1','203',257948,'AFTERNOON SHIFT ','2022-09-05','2022-09-06 06:14:46','2022-09-07 06:14:46','730',3450920.25,3450920.25,'730','2022-09-06 06:52:33','735','2022-09-06 08:28:51',10,0),('1','203',257949,'MORNING SHIFT ','2022-09-06','2022-09-06 13:56:43','2022-09-07 13:56:43','730',5455373.75,5455373.75,'730','2022-09-06 16:44:45','735','2022-09-06 22:31:11',10,0),('1','203',257950,'AFTERNOON SHIFT ','2022-09-06','2022-09-07 06:11:01','2022-09-08 06:11:01','730',2916991.75,2916991.75,'730','2022-09-07 06:13:47','735','2022-09-07 08:20:52',10,0),('1','203',257951,'MORNING SHIFT ','2022-09-07','2022-09-07 13:56:21','2022-09-08 13:56:21','730',3932131.25,3932131.25,'730','2022-09-07 14:01:38','735','2022-09-07 21:11:54',10,0),('1','203',257952,'AFTERNOON SHIFT ','2022-09-07','2022-09-08 07:15:28','2022-09-09 07:15:28','730',3203862.00,3203862.00,'730','2022-09-08 07:21:09','735','2022-09-08 08:52:03',10,0),('1','203',257953,'MORNING SHIFT ','2022-09-08','2022-09-08 13:36:29','2022-09-09 13:36:29','730',3079782.25,3079782.25,'730','2022-09-08 13:45:31','735','2022-09-08 20:31:10',10,0),('1','203',257954,'AFTERNOON SHIFT ','2022-09-08','2022-09-09 06:48:20','2022-09-10 06:48:20','730',3016302.25,3016302.25,'730','2022-09-09 06:51:05','735','2022-09-09 09:34:32',10,0),('1','203',257955,'MORNING SHIFT ','2022-09-09','2022-09-09 13:57:58','2022-09-10 13:57:58','730',2830948.75,2830948.75,'730','2022-09-09 14:02:32','735','2022-09-09 21:05:57',10,0),('1','203',257956,'AFTERNOON SHIFT ','2022-09-09','2022-09-09 21:35:50','2022-09-10 21:35:50','730',2958351.75,2958351.75,'730','2022-09-10 08:20:08','761','2022-09-10 10:36:33',10,0),('1','203',257957,'MORNING SHIFT ','2022-09-10','2022-09-10 13:31:40','2022-09-11 13:31:40','730',3401043.50,3401043.50,'730','2022-09-10 19:23:01','735','2022-09-10 19:44:22',10,0),('1','203',257958,'AFTERNOON SHIFT ','2022-09-10','2022-09-11 06:03:20','2022-09-12 06:03:20','730',728546.00,728546.00,'730','2022-09-11 06:12:34','735','2022-09-11 09:01:51',10,0),('1','203',257959,'MORNING SHIFT ','2022-09-11','2022-09-11 13:15:36','2022-09-12 13:15:36','730',4259607.00,4259607.00,'730','2022-09-12 05:42:51','761','2022-09-12 09:20:38',10,0),('1','203',257960,'MORNING SHIFT ','2022-09-12','2022-09-12 14:00:29','2022-09-13 14:00:29','730',3489149.75,3489149.75,'730','2022-09-12 17:35:18','735','2022-09-12 21:54:28',10,0),('1','203',257961,'AFTERNOON SHIFT ','2022-09-12','2022-09-13 06:14:16','2022-09-14 06:14:16','730',1290790.75,1290790.75,'730','2022-09-13 07:17:36','735','2022-09-13 09:04:48',10,0),('1','203',257962,'MORNING SHIFT ','2022-09-13','2022-09-13 12:24:29','2022-09-14 12:24:29','730',2867587.25,2867587.25,'730','2022-09-13 13:36:28','735','2022-09-13 22:19:15',10,0),('1','203',257963,'AFTERNOON SHIFT ','2022-09-13','2022-09-14 06:14:06','2022-09-15 06:14:06','730',2676198.75,2676198.75,'730','2022-09-14 06:34:13','735','2022-09-14 11:58:24',10,0),('1','203',257964,'MORNING SHIFT ','2022-09-14','2022-09-14 13:29:16','2022-09-15 13:29:16','730',2438668.75,2438668.75,'730','2022-09-14 13:35:17','735','2022-09-15 08:16:01',10,0),('1','203',257965,'AFTERNOON SHIFT ','2022-09-14','2022-09-15 08:44:03','2022-09-16 08:44:03','730',2306097.50,2306097.50,'730','2022-09-15 08:51:45','735','2022-09-15 18:08:19',10,0),('1','203',257966,'MORNING SHIFT ','2022-09-15','2022-09-15 21:13:10','2022-09-16 21:13:10','730',3590508.25,3590508.25,'730','2022-09-15 22:03:27','735','2022-09-16 09:44:45',10,0),('1','203',257967,'AFTERNOON SHIFT ','2022-09-17','2022-09-17 19:01:45','2022-09-18 19:01:45','730',3584175.00,3584175.00,'730','2022-09-18 08:26:29','735','2022-09-18 10:38:10',10,0),('1','203',257968,'MORNING SHIFT ','2022-09-18','2022-09-18 14:52:17','2022-09-19 14:52:17','730',2963500.75,2963500.75,'730','2022-09-18 16:13:40','761','2022-09-18 17:14:55',10,0),('1','203',257969,'AFTERNOON SHIFT ','2022-09-20','2022-09-20 13:44:37','2022-09-21 13:44:37','730',1284454.50,1284454.50,'730','2022-09-20 16:56:14','735','2022-09-20 20:51:33',10,0),('1','203',257970,'AFTERNOON SHIFT ','2022-09-20','2022-09-21 06:37:22','2022-09-22 06:37:22','730',2837789.50,2837789.50,'730','2022-09-21 07:10:31','735','2022-09-21 10:36:47',10,0),('1','203',257971,'MORNING SHIFT ','2022-09-21','2022-09-21 14:07:30','2022-09-22 14:07:30','730',2071597.50,2071597.50,'730','2022-09-21 14:12:43','735','2022-09-21 20:42:26',10,0),('1','203',257972,'AFTERNOON SHIFT ','2022-09-21','2022-09-22 06:56:17','2022-09-23 06:56:17','730',2626722.00,2626722.00,'730','2022-09-22 06:59:49','735','2022-09-22 11:03:07',10,0),('1','203',257973,'MORNING SHIFT ','2022-09-22','2022-09-22 13:45:31','2022-09-23 13:45:31','730',2551071.25,2551071.25,'730','2022-09-22 13:55:53','735','2022-09-22 22:16:33',10,0),('1','203',257974,'MORNING SHIFT ','2022-09-22','2022-09-23 08:10:33','2022-09-24 08:10:33','730',2590640.50,2590640.50,'730','2022-09-23 08:14:40','761','2022-09-23 09:52:25',10,0),('1','203',257975,'MORNING SHIFT ','2022-09-23','2022-09-23 11:40:01','2022-09-24 11:40:01','730',1964943.75,1964943.75,'730','2022-09-23 14:16:55','735','2022-09-23 17:29:33',10,0),('1','203',257976,'AFTERNOON SHIFT ','2022-09-23','2022-09-24 08:47:25','2022-09-25 08:47:25','730',2766247.75,2766247.75,'730','2022-09-24 08:55:23','761','2022-09-24 13:25:28',10,0),('1','203',257977,'MORNING SHIFT ','2022-09-24','2022-09-24 13:34:46','2022-09-25 13:34:46','730',1687600.25,1687600.25,'730','2022-09-24 13:39:37','735','2022-09-24 14:39:54',10,0),('1','203',257978,'AFTERNOON SHIFT ','2022-09-24','2022-09-25 06:03:26','2022-09-26 06:03:26','730',3251372.25,3251372.25,'730','2022-09-25 06:06:43','735','2022-09-25 07:40:23',10,0),('1','203',257979,'MORNING SHIFT ','2022-09-25','2022-09-25 10:27:13','2022-09-26 10:27:13','730',2779213.50,2779213.50,'730','2022-09-25 13:29:30','735','2022-09-25 23:09:25',10,0),('1','203',257980,'AFTERNOON SHIFT ','2022-09-25','2022-09-26 05:58:45','2022-09-27 05:58:45','730',3367882.00,3367882.00,'730','2022-09-26 06:41:14','735','2022-09-26 10:12:28',10,0),('1','203',257981,'MORNING SHIFT ','2022-09-26','2022-09-26 14:25:26','2022-09-27 14:25:26','730',1354713.50,1354713.50,'730','2022-09-26 14:29:47','735','2022-09-26 22:31:39',10,0),('1','203',257982,'MORNING SHIFT ','2022-09-28','2022-09-28 13:40:48','2022-09-29 13:40:48','730',2330135.50,2330135.50,'730','2022-09-28 13:44:42','735','2022-09-28 23:15:31',10,0),('1','203',257983,'AFTERNOON ','2022-09-28','2022-09-29 06:18:35','2022-09-30 06:18:35','730',3003808.50,3003808.50,'730','2022-09-29 07:07:36','761','2022-09-29 09:57:33',10,0),('1','203',257984,'MORNING SHIFT ','2022-09-29','2022-09-29 11:52:43','2022-09-30 11:52:43','730',2451060.50,2451060.50,'730','2022-09-29 13:24:26','735','2022-09-29 16:24:31',10,0),('1','203',257985,'AFTERNOON SHIFT ','2022-09-29','2022-09-30 06:15:00','2022-10-01 06:15:00','730',2560031.25,2560031.25,'730','2022-09-30 07:59:35','735','2022-09-30 09:55:27',10,0),('1','203',257986,'MORNING SHIFT ','2022-09-30','2022-09-30 11:45:16','2022-10-01 11:45:16','730',1051921.50,1051921.50,'730','2022-09-30 11:48:20','735','2022-10-01 00:15:10',10,0),('1','203',257987,'MORNING SHIFT ','2022-10-07','2022-10-07 14:13:24','2022-10-08 14:13:24','730',2268668.50,2268668.50,'730','2022-10-08 06:13:25','735','2022-10-08 11:08:04',10,0),('1','203',257988,'MORNING SHIFT ','2022-10-12','2022-10-12 09:32:20','2022-10-13 09:32:20','730',6263281.50,6263281.50,'730','2022-10-13 10:25:39','735','2022-10-13 11:18:15',10,0),('1','203',257989,'MORNING SHIFT ','2022-10-13','2022-10-13 13:43:23','2022-10-14 13:43:23','730',3100018.25,3100018.25,'730','2022-10-13 13:46:07','735','2022-10-14 11:45:54',10,0),('1','203',257990,'AFTERNOON SHIFT ','2022-10-13','2022-10-14 11:58:17','2022-10-15 11:58:17','730',2352785.75,2352785.75,'730','2022-10-14 12:00:30','735','2022-10-15 00:09:54',10,0),('1','203',257991,'MORNING SHIFT ','2022-10-16','2022-10-16 10:39:26','2022-10-17 10:39:26','730',3348182.25,3348182.25,'730','2022-10-16 10:44:15','735','2022-10-17 08:44:38',10,0),('1','203',257992,'AFTERNOON SHIFT ','2022-10-19','2022-10-19 19:06:47','2022-10-20 19:06:47','730',1092245.00,1092245.00,'730','2022-10-20 09:48:40','735','2022-10-20 23:39:29',10,0),('1','203',257993,'MORNING SHIFT ','2022-10-20','2022-10-21 07:56:09','2022-10-22 07:56:09','730',1656411.75,1656411.75,'730','2022-10-21 09:12:01','735','2022-10-21 21:34:59',10,0),('1','203',257994,'AFTERNOON SHIFT ','2022-10-22','2022-10-22 20:24:54','2022-10-23 20:24:54','730',1621980.50,1621980.50,'730','2022-10-23 10:50:41','735','2022-10-23 12:15:54',10,0),('1','203',257995,'MORNING SHIFT ','2022-10-23','2022-10-23 13:18:57','2022-10-24 13:18:57','730',4346426.00,4346426.00,'730','2022-10-23 15:18:25','735','2022-10-23 23:51:00',10,0),('1','203',257996,'AFTERNOON SHIFT ','2022-10-25','2022-10-26 06:48:00','2022-10-27 06:48:00','730',2215962.00,2215962.00,'730','2022-10-26 07:39:58','761','2022-10-26 11:06:26',10,0),('1','203',257997,'MORNING SHIFT ','2022-10-26','2022-10-26 12:45:05','2022-10-27 12:45:05','730',3213773.50,3213773.50,'730','2022-10-26 16:40:22','735','2022-10-26 20:12:03',10,0),('1','203',257998,'AFTERNOON SHIFT ','2022-10-30','2022-10-31 14:23:26','2022-11-01 14:23:26','730',2925436.50,2925436.50,'730','2022-10-31 14:25:31','735','2022-10-31 21:31:28',10,0),('1','203',257999,'MORNING SHIFT ','2022-10-31','2022-10-31 22:26:39','2022-11-01 22:26:39','730',2871286.25,2871286.25,'730','2022-11-01 06:20:26','735','2022-11-01 12:55:47',10,0),('1','203',258000,'AFTERNOON SHIFT ','2022-10-31','2022-11-01 13:28:45','2022-11-02 13:28:45','730',8255406.25,8255406.25,'730','2022-11-01 13:33:26','735','2022-11-01 19:05:34',10,0),('1','203',258001,'AFTERNOON SHIFT ','2022-11-01','2022-11-01 19:49:05','2022-11-02 19:49:05','730',2920282.75,2920282.75,'730','2022-11-02 06:56:11','761','2022-11-02 16:56:51',10,0),('1','203',258002,'MORNING SHIFT ','2022-11-02','2022-11-02 17:43:56','2022-11-03 17:43:56','730',2870392.00,2870392.00,'730','2022-11-02 19:00:57','735','2022-11-02 22:16:19',10,0),('1','203',258003,'AFTERNOON SHIFT ','2022-11-03','2022-11-04 07:48:19','2022-11-05 07:48:19','730',2368574.25,2368574.25,'730','2022-11-04 07:50:03','761','2022-11-04 15:15:57',10,0),('1','203',258004,'AFTERNOON SHIFT ','2022-11-04','2022-11-05 08:04:18','2022-11-06 08:04:18','730',182176.70,182176.70,'730','2022-11-05 08:08:22','735','2022-11-05 10:14:51',10,0),('1','203',258005,'AFTERNOON SHIFT ','2022-11-05','2022-11-05 17:38:19','2022-11-06 17:38:19','730',2709722.20,2709722.20,'730','2022-11-06 07:48:13','735','2022-11-06 13:57:10',10,0),('1','203',258006,'MORNING SHIFT ','2022-11-06','2022-11-06 14:33:12','2022-11-07 14:33:12','730',1722785.75,1722785.75,'730','2022-11-06 14:37:26','735','2022-11-06 20:52:34',10,0),('1','203',258007,'MORNING SHIFT II','2022-11-06','2022-11-07 06:20:52','2022-11-08 06:20:52','730',2016908.30,2016908.30,'730','2022-11-07 06:25:15','735','2022-11-07 08:17:52',10,0),('1','203',258008,'AFTERNOON SHIFT ','2022-11-07','2022-11-07 19:45:57','2022-11-08 19:45:57','730',7088512.30,7088512.30,'730','2022-11-08 09:35:43','735','2022-11-08 10:55:07',10,0),('1','203',258009,'MORNING SHIFT ','2022-11-08','2022-11-08 14:22:05','2022-11-09 14:22:05','730',6527261.10,6527261.10,'730','2022-11-09 09:06:26','735','2022-11-09 10:09:02',10,0),('1','203',258010,'AFTERNOON SHIFT ','2022-11-09','2022-11-09 20:02:42','2022-11-10 20:02:42','730',901238.90,901238.90,'730','2022-11-09 20:03:54','735','2022-11-09 23:01:40',10,0),('1','203',258011,'MORNING SHIFT ','2022-11-10','2022-11-10 13:15:43','2022-11-11 13:15:43','730',405861.70,405861.70,'730','2022-11-10 13:27:24','735','2022-11-10 20:57:56',10,0),('1','203',258012,'AFTERNOON SHIFT ','2022-11-10','2022-11-11 10:08:10','2022-11-12 10:08:10','730',1583858.20,1583858.20,'730','2022-11-11 16:57:05','735','2022-11-11 20:03:08',10,0),('1','203',258013,'MORNING SHIFT ','2022-11-11','2022-11-12 02:20:15','2022-11-13 02:20:15','730',2739284.20,2739284.20,'730','2022-11-12 05:58:53','735','2022-11-12 08:10:33',10,0),('1','203',258014,'AFTERNOON SHIFT ','2022-11-11','2022-11-12 11:20:15','2022-11-13 11:20:15','730',3565709.20,3565709.20,'730','2022-11-12 11:22:38','735','2022-11-12 18:36:22',10,0),('1','203',258015,'AFTERNOON SHIFT ','2022-11-12','2022-11-13 05:49:43','2022-11-14 05:49:43','730',2922909.60,2922909.60,'730','2022-11-13 05:53:23','735','2022-11-13 09:59:56',10,0),('1','203',258016,'AFTERNOON SHIFT ','2022-11-12','2022-11-13 11:39:17','2022-11-14 11:39:17','730',4155017.40,4155017.40,'730','2022-11-13 11:42:19','735','2022-11-13 16:17:49',10,0),('1','203',258017,'MORNING SHIFT ','2022-11-13','2022-11-13 16:29:21','2022-11-14 16:29:21','730',1041818.40,1041818.40,'730','2022-11-13 16:34:46','735','2022-11-13 20:21:18',10,0),('1','203',258018,'AFTERNOON SHIFT ','2022-11-13','2022-11-14 06:03:52','2022-11-15 06:03:52','730',3154249.00,3154249.00,'730','2022-11-14 06:33:36','761','2022-11-14 14:20:53',10,0),('1','203',258019,'AFTERNOON SHIFT ','2022-11-14','2022-11-15 11:33:59','2022-11-16 11:33:59','730',2026718.40,2026718.40,'730','2022-11-15 13:25:58','735','2022-11-15 13:30:53',10,0),('1','203',258020,'MORNING SHIFT ','2022-11-15','2022-11-15 15:23:19','2022-11-16 15:23:19','730',2936926.40,2936926.40,'730','2022-11-15 15:38:36','735','2022-11-16 00:00:27',10,0),('1','203',258021,'AFTERNOON SHIFT ','2022-11-15','2022-11-16 06:50:52','2022-11-17 06:50:52','730',4828720.00,4828720.00,'730','2022-11-16 06:56:48','735','2022-11-16 09:57:59',10,0),('1','203',258022,'MORNING SHIFT ','2022-11-16','2022-11-16 13:08:17','2022-11-17 13:08:17','730',3717459.40,3717459.40,'730','2022-11-17 05:58:12','761','2022-11-17 13:39:31',10,0),('1','203',258023,'AFTERNOON SHIFT ','2022-11-16','2022-11-17 13:40:54','2022-11-18 13:40:54','730',4241774.60,4241774.60,'730','2022-11-17 13:51:02','735','2022-11-17 14:09:06',10,0),('1','203',258024,'AFTERNOON SHIFT ','2022-11-18','2022-11-19 05:55:08','2022-11-20 05:55:08','730',3196342.80,3196342.80,'730','2022-11-19 06:05:48','735','2022-11-19 09:15:24',10,0),('1','203',258025,'MORNING SHIFT ','2022-11-19','2022-11-19 14:16:31','2022-11-20 14:16:31','730',2273223.60,2273223.60,'730','2022-11-19 14:48:38','735','2022-11-19 15:46:46',10,0),('1','203',258026,'AFTERNOON SHIFT ','2022-11-19','2022-11-19 19:50:51','2022-11-20 19:50:51','730',1679947.20,1679947.20,'730','2022-11-20 08:20:09','735','2022-11-20 23:09:12',10,0),('1','203',258027,'MORNING SHIFT ','2022-11-20','2022-11-21 00:17:22','2022-11-22 00:17:22','730',1036350.00,1036350.00,'730','2022-11-21 05:48:26','735','2022-11-21 09:58:26',10,0),('1','203',258028,'AFTERNOON SHIFT ','2022-11-20','2022-11-21 11:34:15','2022-11-22 11:34:15','730',2470891.20,2470891.20,'730','2022-11-21 11:40:47','735','2022-11-21 21:53:23',10,0),('1','203',258029,'AFTERNOON SHIFT ','2022-11-21','2022-11-22 05:55:09','2022-11-23 05:55:09','730',4528024.80,4528024.80,'730','2022-11-22 06:51:53','735','2022-11-22 13:19:51',10,0),('1','203',258030,'AFTERNOON SHIFT ','2022-11-22','2022-11-22 16:11:51','2022-11-23 16:11:51','730',3137739.40,3137739.40,'730','2022-11-23 11:04:36','735','2022-11-23 14:42:01',10,0),('1','203',258031,'MORNING SHIFT ','2022-11-23','2022-11-23 16:47:03','2022-11-24 16:47:03','730',3823142.60,3823142.60,'730','2022-11-23 16:55:25','735','2022-11-23 17:13:54',10,0),('1','203',258032,'AFTERNOON SHIFT ','2022-11-23','2022-11-24 05:58:07','2022-11-25 05:58:07','730',2568945.60,2568945.60,'730','2022-11-24 11:15:47','735','2022-11-24 14:31:45',10,0),('1','203',258033,'MORNING SHIFT ','2022-11-24','2022-11-24 14:57:44','2022-11-25 14:57:44','730',4081675.00,4081675.00,'730','2022-11-24 14:59:36','761','2022-11-24 15:26:06',10,0),('1','203',258034,'AFTERNOON SHIFT ','2022-11-24','2022-11-24 15:27:48','2022-11-25 15:27:48','730',3528282.00,3528282.00,'730','2022-11-25 07:23:37','735','2022-11-25 09:09:22',10,0),('1','203',258035,'AFTERNOON SHIFT ','2022-11-25','2022-11-25 20:03:35','2022-11-26 20:03:35','730',753359.20,753359.20,'730','2022-11-25 20:04:21','735','2022-11-26 00:08:25',10,0),('1','203',258036,'AFTERNOON SHIFT ','2022-11-26','2022-11-27 06:14:50','2022-11-28 06:14:50','730',4818219.80,4818219.80,'730','2022-11-27 06:20:09','735','2022-11-27 07:39:19',10,0),('1','203',258037,'AFTERNOON SHIFT ','2022-11-27','2022-11-27 17:49:17','2022-11-28 17:49:17','730',4114430.20,4114430.20,'730','2022-11-28 06:37:58','761','2022-11-28 12:33:49',10,0),('1','203',258038,'AFTERNOON SHIFT ','2022-11-28','2022-11-29 08:56:40','2022-11-30 08:56:40','730',1033824.00,1033824.00,'730','2022-11-29 09:02:34','761','2022-11-29 14:23:40',10,0),('1','203',258039,'MORNING SHIFT ','2022-11-29','2022-11-29 14:39:54','2022-11-30 14:39:54','730',488944.20,488944.20,'730','2022-11-29 14:45:36','735','2022-11-30 15:49:32',10,0),('1','203',258040,'AFTERNOON SHIFT','2022-11-29','2022-12-02 09:57:21','2022-12-03 09:57:21','730',210144.00,210144.00,'730','2022-12-02 09:58:46','761','2022-12-02 10:40:16',10,0),('1','203',258041,'MORNING SHIFT','2022-11-30','2022-12-02 10:42:54','2022-12-03 10:42:54','730',885412.00,885412.00,'730','2022-12-02 10:43:54','735','2022-12-02 11:47:54',10,0),('1','203',258042,'MORNING SHIFT','2022-12-01','2022-12-02 12:01:52','2022-12-03 12:01:52','730',522966.40,522966.40,'730','2022-12-02 12:11:55','761','2022-12-02 17:05:20',10,0),('1','203',258043,'MORNING SHIFT','2022-12-02','2022-12-04 11:47:44','2022-12-05 11:47:44','730',4516704.60,4516704.60,'730','2022-12-04 11:51:48','735','2022-12-05 00:29:19',10,0),('1','203',258044,'MORNING SHIFT','2022-12-03','2022-12-06 11:33:15','2022-12-07 11:33:15','730',594457.60,594457.60,'730','2022-12-06 11:34:16','761','2022-12-06 12:05:39',10,0),('1','203',258045,'AFTERNOON SHIFT','2022-12-05','2022-12-06 12:11:00','2022-12-07 12:11:00','730',1110416.40,1110416.40,'730','2022-12-06 12:13:55','735','2022-12-06 12:15:32',10,0),('1','203',258046,'MORNING SHIFT','2022-12-06','2022-12-06 12:30:07','2022-12-07 12:30:07','730',2465584.20,2465584.20,'730','2022-12-06 13:07:33','735','2022-12-06 22:02:31',10,0),('1','203',258047,'AFTERNOON SHIFT','2022-12-06','2022-12-07 12:34:05','2022-12-08 12:34:05','730',1480114.80,1480114.80,'730','2022-12-07 12:36:57','761','2022-12-07 16:34:32',10,0),('1','203',258048,'MORNING SHIFT','2022-12-07','2022-12-08 11:45:47','2022-12-09 11:45:47','730',1238441.40,1238441.40,'730','2022-12-08 11:48:52','761','2022-12-08 12:29:27',10,0),('1','203',258049,'MORNING SHIFT','2022-12-08','2022-12-09 12:38:09','2022-12-10 12:38:09','730',1754037.00,1754037.00,'730','2022-12-09 12:48:44','761','2022-12-09 15:32:18',10,0),('1','203',258050,'MORNING SHIFT','2022-12-09','2022-12-10 16:51:52','2022-12-11 16:51:52','730',5502695.40,5502695.40,'730','2022-12-10 17:22:33','735','2022-12-10 18:59:38',10,0),('1','203',258051,'AFTERNOON SHIFT','2022-12-09','2022-12-10 19:18:42','2022-12-11 19:18:42','730',2903895.80,2903895.80,'730','2022-12-10 19:21:25','735','2022-12-11 07:22:50',10,0),('1','203',258052,'AFTERNOON SHIFT','2022-12-10','2022-12-11 10:56:04','2022-12-12 10:56:04','730',4612958.20,4612958.20,'730','2022-12-11 11:00:00','735','2022-12-11 11:16:16',10,0),('1','203',258053,'MORNING SHIFT ','2022-12-11','2022-12-12 10:37:18','2022-12-13 10:37:18','730',2818614.60,2818614.60,'730','2022-12-12 11:58:38','761','2022-12-12 15:25:47',10,0),('1','203',258054,'AFTERNOON SHIFT ','2022-12-11','2022-12-12 19:51:39','2022-12-13 19:51:39','730',324948.80,324948.80,'730','2022-12-12 20:06:42','735','2022-12-12 22:52:30',10,0),('1','203',258055,'AFTERNOON SHIFT ','2022-12-12','2022-12-13 06:20:24','2022-12-14 06:20:24','730',2295497.00,2295497.00,'730','2022-12-13 06:47:18','735','2022-12-13 09:18:29',10,0),('1','203',258056,'MORNING SHIFT ','2022-12-13','2022-12-13 13:31:12','2022-12-14 13:31:12','730',4587218.80,4587218.80,'730','2022-12-13 13:39:10','735','2022-12-13 23:34:14',10,0),('1','203',258057,'AFTERNOON SHIFT ','2022-12-13','2022-12-14 07:59:35','2022-12-15 07:59:35','730',362401.60,362401.60,'730','2022-12-14 08:00:28','735','2022-12-14 10:04:46',10,0),('1','203',258058,'AFTERNOON SHIFT ','2022-12-14','2022-12-15 07:09:35','2022-12-16 07:09:35','730',1403639.20,1403639.20,'730','2022-12-15 07:18:41','735','2022-12-15 08:34:42',10,0),('1','203',258059,'AFTERNOON SHIFT ','2022-12-15','2022-12-16 08:38:27','2022-12-17 08:38:27','730',1179798.40,1179798.40,'730','2022-12-16 08:39:43','735','2022-12-16 08:56:45',10,0),('1','203',258060,'AFTERNOON SHIFT ','2022-12-16','2022-12-16 19:04:22','2022-12-17 19:04:22','730',2172216.20,2172216.20,'730','2022-12-17 09:43:38','735','2022-12-17 11:32:50',10,0),('1','203',258061,'MORNING SHIFT','2022-12-17','2022-12-17 15:09:48','2022-12-18 15:09:48','730',4609685.40,4609685.40,'730','2022-12-17 16:06:15','735','2022-12-17 23:49:20',10,0),('1','203',258062,'AFTERNOON SHIFT ','2022-12-17','2022-12-18 06:10:19','2022-12-19 06:10:19','730',826522.40,826522.40,'730','2022-12-18 06:11:09','735','2022-12-18 09:23:29',10,0),('1','203',258063,'AFTERNOON SHIFT ','2022-12-18','2022-12-19 06:28:36','2022-12-20 06:28:36','730',579946.40,579946.40,'730','2022-12-19 06:29:28','735','2022-12-19 10:05:24',10,0),('1','203',258064,'AFTERNOON SHIFT','2022-12-19','2022-12-19 21:17:38','2022-12-20 21:17:38','730',3078242.80,3078242.80,'730','2022-12-20 07:25:35','735','2022-12-20 08:50:44',10,0),('1','203',258065,'MORNING SHIFT ','2022-12-20','2022-12-20 13:39:43','2022-12-21 13:39:43','730',4628815.80,4628815.80,'730','2022-12-20 13:43:37','735','2022-12-20 21:13:43',10,0),('1','203',258066,'AFTERNOON SHIFT ','2022-12-20','2022-12-21 05:58:44','2022-12-22 05:58:44','730',2335262.20,2335262.20,'730','2022-12-21 06:03:59','735','2022-12-21 08:43:29',10,0),('1','203',258067,'MORNING SHIFT ','2022-12-21','2022-12-21 17:00:20','2022-12-22 17:00:20','730',6098307.20,6098307.20,'730','2022-12-21 20:10:15','735','2022-12-21 23:41:00',10,0),('1','203',258068,'AFTERNOON SHIFT ','2022-12-21','2022-12-22 05:23:51','2022-12-23 05:23:51','730',2583858.20,2583858.20,'730','2022-12-22 11:33:36','735','2022-12-22 20:35:06',10,0),('1','203',258069,'MORNING SHIFT ','2022-12-22','2022-12-22 22:14:40','2022-12-23 22:14:40','730',5788859.40,5788859.40,'730','2022-12-22 22:17:25','735','2022-12-23 08:32:06',10,0),('1','203',258070,'AFTERNOON SHIFT ','2022-12-22','2022-12-23 09:06:29','2022-12-24 09:06:29','730',1456324.20,1456324.20,'730','2022-12-23 09:30:19','735','2022-12-23 10:11:26',10,0),('1','203',258071,'MORNING SHIFT ','2022-12-23','2022-12-23 18:38:09','2022-12-24 18:38:09','730',3650895.00,3650895.00,'730','2022-12-23 18:41:43','735','2022-12-23 19:16:47',10,0),('1','203',258072,'AFTERNOON SHIFT ','2022-12-24','2022-12-24 20:13:07','2022-12-25 20:13:07','730',2216062.80,2216062.80,'730','2022-12-25 08:06:56','735','2022-12-25 15:41:18',10,0),('1','203',258073,'MORNING SHIFT ','2022-12-25','2022-12-25 21:28:01','2022-12-26 21:28:01','730',3699342.00,3699342.00,'730','2022-12-26 08:01:02','761','2022-12-26 11:14:56',10,0),('1','203',258074,'AFTERNOON SHIFT ','2022-12-26','2022-12-26 23:18:49','2022-12-27 23:18:49','730',1269120.60,1269120.60,'730','2022-12-27 09:41:50','761','2022-12-28 09:51:05',10,0),('1','203',258075,'AFTERNOON SHIFT ','2022-12-26','2022-12-28 09:59:28','2022-12-29 09:59:28','730',664153.60,664153.60,'730','2022-12-28 10:00:32','735','2022-12-28 10:18:38',10,0),('1','203',258076,'MORNING SHIFT ','2022-12-27','2022-12-28 10:32:53','2022-12-29 10:32:53','730',4102938.60,4102938.60,'730','2022-12-28 10:38:57','761','2022-12-28 11:37:39',10,0),('1','203',258077,'MORNING SHIFT ','2022-12-28','2022-12-28 13:18:05','2022-12-29 13:18:05','730',1942643.80,1942643.80,'730','2022-12-28 13:20:15','735','2022-12-28 19:52:13',10,0),('1','203',258078,'AFTERNOON SHIFT ','2022-12-28','2022-12-28 22:02:13','2022-12-29 22:02:13','730',2361504.60,2361504.60,'730','2022-12-29 06:48:32','735','2022-12-29 12:30:33',10,0),('1','203',258079,'MORNING SHIFT ','2022-12-29','2022-12-29 14:59:34','2022-12-30 14:59:34','730',6974395.60,6974395.60,'730','2022-12-29 15:49:57','735','2022-12-29 19:40:33',10,0),('1','203',258080,'AFTERNOON SHIFT ','2022-12-29','2022-12-30 06:37:52','2022-12-31 06:37:52','730',2212419.80,2212419.80,'730','2022-12-30 07:20:51','735','2022-12-30 10:22:34',10,0),('1','203',258081,'MORNING SHIFT ','2022-12-30','2022-12-30 16:23:56','2022-12-31 16:23:56','730',7421463.40,7421463.40,'730','2022-12-30 16:26:55','735','2022-12-30 20:00:01',10,0),('1','203',258082,'AFTERNOON SHIFT ','2022-12-30','2022-12-31 11:03:24','2023-01-01 11:03:24','730',195280.80,195280.80,'730','2022-12-31 11:05:12','735','2022-12-31 17:25:14',10,0),('1','203',258083,'AFTERNOON SHIFT ','2022-12-31','2022-12-31 21:46:44','2023-01-01 21:46:44','730',8836199.40,8836199.40,'730','2022-12-31 22:09:01','735','2023-01-01 09:45:21',10,0),('1','203',258084,'MORNING SHIFT ','2023-01-01','2023-01-02 07:03:22','2023-01-03 07:03:22','730',11035820.20,11035820.20,'730','2023-01-02 07:12:03','735','2023-01-02 09:44:43',10,0),('1','203',258085,'MORNING SHIFT ','2023-01-02','2023-01-02 13:37:39','2023-01-03 13:37:39','730',4299683.60,4299683.60,'730','2023-01-02 13:39:48','735','2023-01-02 16:02:05',10,0),('1','203',258086,'AFTERNOON SHIFT ','2023-01-02','2023-01-03 05:58:03','2023-01-04 05:58:03','730',5295206.00,5295206.00,'730','2023-01-03 06:43:27','735','2023-01-03 11:17:09',10,0),('1','203',258087,'MORNING SHIFT ','2023-01-03','2023-01-03 13:38:08','2023-01-04 13:38:08','730',4332269.40,4332269.40,'730','2023-01-03 13:40:18','735','2023-01-03 20:43:41',10,0),('1','203',258088,'AFTERNOON SHIFT ','2023-01-03','2023-01-04 07:12:26','2023-01-05 07:12:26','730',5439260.20,5439260.20,'730','2023-01-04 07:17:03','735','2023-01-04 09:15:46',10,0),('1','203',258089,'MORNING SHIFT ','2023-01-04','2023-01-04 13:31:21','2023-01-05 13:31:21','730',4288857.80,4288857.80,'730','2023-01-04 13:34:39','735','2023-01-04 17:37:17',10,0),('1','203',258090,'AFTERNOON SHIFT ','2023-01-04','2023-01-05 09:30:44','2023-01-06 09:30:44','730',4717394.80,4717394.80,'730','2023-01-05 09:34:38','735','2023-01-05 10:12:00',10,0),('1','203',258091,'MORNING SHIFT ','2023-01-05','2023-01-05 12:14:56','2023-01-06 12:14:56','730',10492346.00,10492346.00,'730','2023-01-06 07:01:04','735','2023-01-06 12:37:40',10,0),('1','203',258092,'MORNING SHIFT ','2023-01-06','2023-01-06 14:32:57','2023-01-07 14:32:57','730',7522025.80,7522025.80,'730','2023-01-06 14:36:02','735','2023-01-06 23:36:15',10,0),('1','203',258093,'AFTERNOON SHIFT ','2023-01-06','2023-01-07 14:36:37','2023-01-08 14:36:37','730',6097284.00,6097284.00,'730','2023-01-07 14:40:13','735','2023-01-07 18:13:10',10,0),('1','203',258094,'MORNING SHIFT ','2023-01-07','2023-01-08 07:00:02','2023-01-09 07:00:02','730',5748597.60,5748597.60,'730','2023-01-08 07:09:18','735','2023-01-08 09:29:45',10,0),('1','203',258095,'MORNING SHIFT ','2023-01-08','2023-01-08 14:15:17','2023-01-09 14:15:17','730',3933219.40,3933219.40,'730','2023-01-08 14:19:53','735','2023-01-08 19:20:33',10,0),('1','203',258096,'AFTERNOON SHIFT ','2023-01-08','2023-01-08 20:16:22','2023-01-09 20:16:22','730',6149126.00,6149126.00,'730','2023-01-09 07:16:36','735','2023-01-09 10:47:28',10,0),('1','203',258097,'MORNING SHIFT ','2023-01-09','2023-01-09 18:08:48','2023-01-10 18:08:48','730',5528532.80,5528532.80,'730','2023-01-10 06:27:53','735','2023-01-10 12:14:57',10,0),('1','203',258098,'MORNING SHIFT ','2023-01-10','2023-01-11 07:11:11','2023-01-12 07:11:11','730',1842394.40,1842394.40,'730','2023-01-11 07:18:26','761','2023-01-11 11:08:07',10,0),('1','203',258099,'AFTERNOON SHIFT ','2023-01-11','2023-01-12 06:57:37','2023-01-13 06:57:37','730',4489478.00,4489478.00,'730','2023-01-12 08:49:55','735','2023-01-12 14:07:33',10,0),('1','203',258100,'MORNING SHIFT ','2023-01-12','2023-01-12 19:11:21','2023-01-13 19:11:21','730',4422595.80,4422595.80,'730','2023-01-12 19:20:36','735','2023-01-13 10:19:13',10,0),('1','203',258101,'AFTERNOON SHIFT ','2023-01-12','2023-01-13 10:19:43','2023-01-14 10:19:43','730',2019889.80,2019889.80,'730','2023-01-13 11:41:36','735','2023-01-13 18:33:29',10,0),('1','203',258102,'MORNING SHIFT ','2023-01-13','2023-01-13 19:05:28','2023-01-14 19:05:28','730',4990164.20,4990164.20,'730','2023-01-13 19:08:03','735','2023-01-13 23:16:48',10,0),('1','203',258103,'AFTERNOON SHIFT ','2023-01-13','2023-01-14 07:36:28','2023-01-15 07:36:28','730',1931210.00,1931210.00,'730','2023-01-14 08:15:30','735','2023-01-14 11:56:08',10,0),('1','203',258104,'MORNING SHIFT ','2023-01-14','2023-01-14 21:55:07','2023-01-15 21:55:07','730',5229666.40,5229666.40,'730','2023-01-15 07:32:11','735','2023-01-15 09:13:32',10,0),('1','203',258105,'MORNING SHIFT ','2023-01-15','2023-01-15 13:41:41','2023-01-16 13:41:41','730',4682708.40,4682708.40,'730','2023-01-15 13:45:35','735','2023-01-15 15:16:31',10,0),('1','203',258106,'AFTERNOON SHIFT ','2023-01-15','2023-01-16 06:50:13','2023-01-17 06:50:13','730',3175742.40,3175742.40,'730','2023-01-16 06:52:58','735','2023-01-16 09:23:15',10,0),('1','203',258107,'MORNING SHIFT ','2023-01-16','2023-01-17 08:00:19','2023-01-18 08:00:19','730',4791838.80,4791838.80,'730','2023-01-17 08:05:44','761','2023-01-17 10:51:53',10,0),('1','203',258108,'MORNING SHIFT ','2023-01-17','2023-01-17 21:33:50','2023-01-18 21:33:50','730',4127081.00,4127081.00,'730','2023-01-18 07:01:33','735','2023-01-18 11:12:26',10,0),('1','203',258109,'MORNING SHIFT ','2023-01-18','2023-01-18 13:22:51','2023-01-19 13:22:51','730',1539726.00,1539726.00,'730','2023-01-19 06:42:13','761','2023-01-19 10:43:59',10,0),('1','203',258110,'MORNING SHIFT ','2023-01-19','2023-01-19 21:19:05','2023-01-20 21:19:05','730',1059242.40,1059242.40,'730','2023-01-20 06:52:30','735','2023-01-20 12:52:04',10,0),('1','203',258111,'AFTERNOON SHIFT ','2023-01-20','2023-01-20 20:50:44','2023-01-21 20:50:44','730',2032842.00,2032842.00,'730','2023-01-21 09:04:17','735','2023-01-21 18:17:24',10,0),('1','203',258112,'MORNING SHIFT ','2023-01-21','2023-01-21 19:44:11','2023-01-22 19:44:11','730',6197635.35,6197635.35,'730','2023-01-22 05:46:29','735','2023-01-22 21:39:59',10,0),('1','203',258113,'MORNING SHIFT ','2023-01-22','2023-01-22 22:12:14','2023-01-23 22:12:14','730',3923008.05,3923008.05,'730','2023-01-22 22:17:30','761','2023-01-23 10:13:22',10,0),('1','203',258114,'AFTERNOON SHIFT ','2023-01-22','2023-01-23 10:15:10','2023-01-24 10:15:10','730',671488.35,671488.35,'730','2023-01-23 10:17:20','735','2023-01-23 14:15:08',10,0),('1','203',258115,'MORNING SHIFT ','2023-01-23','2023-01-23 15:04:34','2023-01-24 15:04:34','730',3649387.95,3649387.95,'730','2023-01-23 15:06:29','735','2023-01-23 17:48:17',10,0),('1','203',258116,'AFTERNOON SHIFT ','2023-01-23','2023-01-24 09:32:44','2023-01-25 09:32:44','730',2900587.10,2900587.10,'730','2023-01-24 09:37:01','735','2023-01-24 10:34:57',10,0),('1','203',258117,'MORNING SHIFT ','2023-01-24','2023-01-24 15:35:57','2023-01-25 15:35:57','730',1452861.00,1452861.00,'730','2023-01-24 19:08:39','735','2023-01-24 22:43:35',10,0),('1','203',258118,'AFTERNOON SHIFT ','2023-01-24','2023-01-25 07:22:38','2023-01-26 07:22:38','730',5960195.00,5960195.00,'730','2023-01-25 07:53:05','735','2023-01-25 09:14:29',10,0),('1','203',258119,'MORNING SHIFT ','2023-01-25','2023-01-25 13:36:16','2023-01-26 13:36:16','730',6135409.10,6135409.10,'730','2023-01-25 13:38:30','735','2023-01-25 20:35:57',10,0),('1','203',258120,'AFTERNOON SHIFT ','2023-01-25','2023-01-26 08:15:04','2023-01-27 08:15:04','730',3279921.90,3279921.90,'730','2023-01-26 09:15:41','735','2023-01-26 10:49:18',10,0),('1','203',258121,'MORNING SHIFT ','2023-01-26','2023-01-26 18:11:01','2023-01-27 18:11:01','730',7483748.50,7483748.50,'730','2023-01-27 06:26:47','735','2023-01-27 11:18:45',10,0),('1','203',258122,'AFTERNOON SHIFT ','2023-01-26','2023-01-27 13:58:08','2023-01-28 13:58:08','730',1792961.50,1792961.50,'730','2023-01-27 14:01:26','735','2023-01-27 22:47:35',10,0),('1','203',258123,'MORNING SHIFT ','2023-01-27','2023-01-28 06:04:33','2023-01-29 06:04:33','730',9394593.30,9394593.30,'730','2023-01-28 06:11:45','735','2023-01-28 07:30:01',10,0),('1','203',258124,'AFTERNOON SHIFT ','2023-01-28','2023-01-29 09:09:30','2023-01-30 09:09:30','730',3185353.70,3185353.70,'730','2023-01-29 14:23:36','735','2023-01-29 23:26:49',10,0),('1','203',258125,'MORNING SHIFT ','2023-01-29','2023-01-30 06:17:38','2023-01-31 06:17:38','730',6082478.10,6082478.10,'730','2023-01-30 06:21:47','761','2023-01-30 10:11:10',10,0),('1','203',258126,'AFTERNOON SHIFT ','2023-01-29','2023-01-30 11:03:06','2023-01-31 11:03:06','730',667768.50,667768.50,'730','2023-01-30 12:15:47','735','2023-01-30 20:41:33',10,0),('1','203',258127,'MORNING SHIFT ','2023-01-30','2023-01-30 22:10:50','2023-01-31 22:10:50','730',4091584.80,4091584.80,'730','2023-01-30 22:13:22','735','2023-01-31 08:18:42',10,0),('1','203',258128,'AFTERNOON SHIFT ','2023-01-30','2023-01-31 09:39:46','2023-02-01 09:39:46','730',1816761.40,1816761.40,'730','2023-01-31 09:43:10','735','2023-01-31 09:51:22',10,0),('1','203',258129,'MORNING SHIFT ','2023-01-31','2023-01-31 19:16:42','2023-02-01 19:16:42','730',5199948.80,5199948.80,'730','2023-01-31 19:19:15','735','2023-01-31 23:51:53',10,0),('1','203',258130,'AFTERNOON SHIFT ','2023-01-31','2023-02-01 06:35:41','2023-02-02 06:35:41','730',4922116.50,4922116.50,'730','2023-02-01 06:38:44','735','2023-02-01 09:35:19',10,0),('1','203',258131,'MORNING SHIFT ','2023-02-01','2023-02-01 11:21:34','2023-02-02 11:21:34','730',2429976.70,2429976.70,'730','2023-02-01 17:18:26','735','2023-02-01 23:21:48',10,0),('1','203',258132,'AFTERNOON SHIFT ','2023-02-02','2023-02-02 06:20:03','2023-02-03 06:20:03','730',4990784.80,4990784.80,'730','2023-02-02 10:49:44','761','2023-02-02 22:42:44',10,0),('1','203',258133,'MORNING SHIFT ','2023-02-02','2023-02-03 06:13:26','2023-02-04 06:13:26','730',4113585.90,4113585.90,'730','2023-02-03 06:24:56','735','2023-02-03 11:20:38',10,0),('1','203',258134,'AFTERNOON SHIFT ','2023-02-02','2023-02-03 12:11:47','2023-02-04 12:11:47','730',5109402.20,5109402.20,'730','2023-02-03 12:14:43','735','2023-02-03 20:30:14',10,0),('1','203',258135,'MORNING SHIFT I ','2023-02-03','2023-02-03 20:35:28','2023-02-04 20:35:28','730',1881259.60,1881259.60,'730','2023-02-03 21:00:46','735','2023-02-03 23:03:03',10,0),('1','203',258136,'MORNING SHIFT II','2023-02-03','2023-02-04 06:03:31','2023-02-05 06:03:31','730',3141700.00,3141700.00,'730','2023-02-04 06:10:07','735','2023-02-04 10:43:12',10,0),('1','203',258137,'AFTERNOON SHIFT ','2023-02-03','2023-02-04 13:31:03','2023-02-05 13:31:03','730',5509805.40,5509805.40,'730','2023-02-04 13:36:48','735','2023-02-05 09:25:39',10,0),('1','203',258138,'AFTERNOON SHIFT ','2023-02-04','2023-02-05 10:39:48','2023-02-06 10:39:48','730',12078085.80,12078085.80,'730','2023-02-05 13:41:31','761','2023-02-05 14:07:37',10,0),('1','203',258139,'MORNING SHIFT ','2023-02-05','2023-02-06 09:29:30','2023-02-07 09:29:30','730',12609646.30,12609646.30,'730','2023-02-06 13:40:34','735','2023-02-06 19:30:43',10,0),('1','203',258140,'MORNING SHIFT ','2023-02-06','2023-02-06 22:37:21','2023-02-07 22:37:21','730',10376817.45,10376817.45,'730','2023-02-07 09:13:47','761','2023-02-07 15:13:07',10,0),('1','203',258141,'MORNING SHIFT ','2023-02-07','2023-02-08 10:31:38','2023-02-09 10:31:38','730',8639372.75,8639372.75,'730','2023-02-08 10:43:34','735','2023-02-08 11:47:46',10,0),('1','203',258142,'MORNING SHIFT ','2023-02-08','2023-02-08 17:53:49','2023-02-09 17:53:49','730',1639863.05,1639863.05,'730','2023-02-09 13:46:12','735','2023-02-09 19:04:31',10,0),('1','203',258143,'MORNING SHIFT ','2023-02-09','2023-02-10 09:39:42','2023-02-11 09:39:42','730',7699952.10,7699952.10,'730','2023-02-10 09:44:33','735','2023-02-10 10:59:35',10,0),('1','203',258144,'MORNING SHIFT ','2023-02-10','2023-02-11 06:08:29','2023-02-12 06:08:29','730',8820360.60,8820360.60,'730','2023-02-11 10:40:22','735','2023-02-11 12:22:53',10,0),('1','203',258145,'AFTERNOON SHIFT ','2023-02-11','2023-02-12 13:46:50','2023-02-13 13:46:50','730',6440468.30,6440468.30,'730','2023-02-12 14:17:00','735','2023-02-12 15:15:36',10,0),('1','203',258146,'MORNING SHIFT ','2023-02-12','2023-02-13 06:24:12','2023-02-14 06:24:12','730',6572456.85,6572456.85,'730','2023-02-13 06:33:35','761','2023-02-13 11:26:04',10,0),('1','203',258147,'MORNING SHIFT ','2023-02-13','2023-02-14 06:13:11','2023-02-15 06:13:11','730',6018300.70,6018300.70,'730','2023-02-14 06:16:24','735','2023-02-14 08:25:35',10,0),('1','203',258148,'MORNING SHIFT','2023-02-14','2023-02-15 07:08:46','2023-02-16 07:08:46','730',4239857.70,4239857.70,'730','2023-02-15 07:12:55','735','2023-02-15 16:38:40',10,0),('1','203',258149,'AFTERNOON SHIFT','2023-02-14','2023-02-15 18:33:16','2023-02-16 18:33:16','730',4107475.20,4107475.20,'730','2023-02-15 21:26:56','761','2023-02-15 21:45:36',10,0),('1','203',258150,'MORNING SHIFT','2023-02-15','2023-02-16 06:20:08','2023-02-17 06:20:08','730',8397078.30,8397078.30,'730','2023-02-16 10:08:51','761','2023-02-16 12:04:48',10,0),('1','203',258151,'MORNING SHIFT','2023-02-16','2023-02-17 11:35:06','2023-02-18 11:35:06','730',8649347.10,8649347.10,'730','2023-02-17 11:42:05','735','2023-02-17 18:53:10',10,0),('1','203',258152,'MORNING SHIFT','2023-02-17','2023-02-18 06:55:58','2023-02-19 06:55:58','730',8112182.00,8112182.00,'730','2023-02-18 07:02:28','735','2023-02-18 11:46:45',10,0),('1','203',258153,'MORNING SHIFT','2023-02-18','2023-02-19 06:18:23','2023-02-20 06:18:23','730',6745704.30,6745704.30,'730','2023-02-19 17:04:26','735','2023-02-19 23:07:57',10,0),('1','203',258154,'MORNING SHIFT','2023-02-19','2023-02-20 08:00:47','2023-02-21 08:00:47','730',9458105.60,9458105.60,'730','2023-02-20 08:04:03','735','2023-02-20 09:34:55',10,0),('1','203',258155,'MORNING SHIFT','2023-02-20','2023-02-21 06:12:00','2023-02-22 06:12:00','730',5935837.20,5935837.20,'730','2023-02-22 06:29:55','735','2023-02-22 10:09:49',10,0),('1','203',258156,'MORNING SHIFT','2023-02-21','2023-02-22 10:33:44','2023-02-23 10:33:44','730',7996826.10,7996826.10,'730','2023-02-22 10:41:00','735','2023-02-22 20:13:47',10,0),('1','203',258157,'MORNING SHIFT','2023-02-22','2023-02-23 07:57:57','2023-02-24 07:57:57','730',8472715.50,8472715.50,'730','2023-02-23 10:22:06','735','2023-02-23 15:10:15',10,0),('1','203',258158,'MORNING SHIFT','2023-02-23','2023-02-24 06:19:35','2023-02-25 06:19:35','730',7553771.40,7553771.40,'730','2023-02-24 06:36:40','761','2023-02-24 07:37:59',10,0),('1','203',258159,'AFTERNOON SHIFT','2023-02-23','2023-02-24 10:54:38','2023-02-25 10:54:38','730',956386.00,956386.00,'730','2023-02-24 10:55:18','735','2023-02-24 11:03:09',10,0),('1','203',258160,'MORNING SHIFT','2023-02-24','2023-02-24 21:35:47','2023-02-25 21:35:47','730',7467358.30,7467358.30,'730','2023-02-26 08:22:39','735','2023-02-26 08:36:04',10,0),('1','203',258161,'MORNING SHIFT','2023-02-26','2023-02-27 07:32:39','2023-02-28 07:32:39','730',9888966.80,9888966.80,'730','2023-02-27 07:42:40','735','2023-02-27 10:50:23',10,0),('1','203',258162,'MORNING SHIFT','2023-02-27','2023-02-28 07:50:33','2023-03-01 07:50:33','730',7899708.60,7899708.60,'730','2023-02-28 09:40:28','761','2023-02-28 10:08:47',10,0),('1','203',258163,'MORNING SHIFT','2023-02-28','2023-03-01 09:42:02','2023-03-02 09:42:02','730',7006967.60,7006967.60,'730','2023-03-01 10:31:51','735','2023-03-01 15:24:05',10,0),('1','203',258164,'MORNING SHIFT','2023-03-01','2023-03-02 12:15:21','2023-03-03 12:15:21','730',1199524.30,1199524.30,'730','2023-03-02 12:16:48','761','2023-03-03 11:00:32',10,0),('1','203',258165,'MORNING SHIFT','2023-03-02','2023-03-03 11:06:04','2023-03-04 11:06:04','730',938373.10,938373.10,'730','2023-03-03 11:07:26','761','2023-03-03 15:03:20',10,0),('1','203',258166,'AFTERNOON SHIFT','2023-03-05','2023-03-06 09:27:08','2023-03-07 09:27:08','730',603279.60,603279.60,'730','2023-03-06 09:31:19','735','2023-03-06 09:52:07',10,0),('1','203',258167,'MORNING SHIFT','2023-03-06','2023-03-07 08:23:17','2023-03-08 08:23:17','730',7442591.20,7442591.20,'730','2023-03-07 08:31:41','735','2023-03-07 15:59:07',10,0),('1','203',258168,'MORNING SHIFT','2023-03-07','2023-03-08 06:33:08','2023-03-09 06:33:08','730',7463208.80,7463208.80,'730','2023-03-08 13:17:00','735','2023-03-08 18:48:59',10,0),('1','203',258169,'MORNING SHIFT','2023-03-08','2023-03-09 08:56:08','2023-03-10 08:56:08','730',1777819.60,1777819.60,'730','2023-03-09 09:04:20','735','2023-03-09 09:22:54',10,0),('1','203',258170,'MORNING SHIFT','2023-03-09','2023-03-10 07:28:42','2023-03-11 07:28:42','730',7301476.70,7301476.70,'730','2023-03-10 07:31:52','735','2023-03-10 08:35:55',10,0),('1','203',258171,'MORNING SHIFT','2023-03-10','2023-03-11 08:39:06','2023-03-12 08:39:06','730',9973150.90,9973150.90,'730','2023-03-11 08:56:06','735','2023-03-11 10:31:02',10,0),('1','203',258172,'MORNING SHIFT','2023-03-11','2023-03-12 07:49:39','2023-03-13 07:49:39','730',8540191.10,8540191.10,'730','2023-03-12 07:58:37','735','2023-03-12 08:29:27',10,0),('1','203',258173,'MORNING SHIFT','2023-03-12','2023-03-13 07:41:48','2023-03-14 07:41:48','730',3443672.40,3443672.40,'730','2023-03-13 07:46:18','735','2023-03-13 10:06:56',10,0),('1','203',258174,'MORNING SHIFT','2023-03-13','2023-03-14 08:26:15','2023-03-15 08:26:15','730',8492890.30,8492890.30,'730','2023-03-14 08:30:22','735','2023-03-14 09:02:04',10,0),('1','203',258175,'MORNING SHIFT','2023-03-14','2023-03-15 08:29:07','2023-03-16 08:29:07','730',8200398.00,8200398.00,'730','2023-03-15 08:36:37','735','2023-03-15 10:42:37',10,0),('1','203',258176,'MORNING SHIFT','2023-03-15','2023-03-16 07:45:36','2023-03-17 07:45:36','730',8108248.70,8108248.70,'730','2023-03-16 07:50:25','735','2023-03-16 07:59:40',10,0),('1','203',258177,'MORNING SHIFT','2023-03-16','2023-03-17 08:18:29','2023-03-18 08:18:29','730',5506659.20,5506659.20,'730','2023-03-17 08:49:04','735','2023-03-17 09:06:25',10,0),('1','203',258178,'MORNING SHIFT','2023-03-17','2023-03-18 08:45:32','2023-03-19 08:45:32','730',9283530.20,9283530.20,'730','2023-03-18 10:10:23','761','2023-03-18 10:18:00',10,0),('1','203',258179,'AFTERNOON SHIFT','2023-03-18','2023-03-19 07:51:26','2023-03-20 07:51:26','730',1383228.80,1383228.80,'730','2023-03-19 07:54:47','735','2023-03-19 11:22:20',10,0),('1','203',258180,'MORNING SHIFT','2023-03-19','2023-03-20 08:04:03','2023-03-21 08:04:03','730',10380785.60,10380785.60,'730','2023-03-20 08:11:36','735','2023-03-20 09:03:06',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4915740 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','203','1026','246533',4715872,'3038','469',735.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246533',4715873,'3039','469',665.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246533',4715874,'3040','469',509.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246533',4715875,'3041','469',577.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246533',4715876,'3042','469',610.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246533',4715877,'3043','469',493.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246533',4715878,'3044','469',549.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246533',4715879,'3045','469',649.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246533',4715880,'3046','469',458.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246533',4715881,'3047','469',575.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246533',4715882,'3048','469',504.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246533',4715883,'3049','469',621.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246533',4715884,'3050','469',586.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246533',4715885,'3051','469',494.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246533',4715886,'3052','469',708.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246533',4715887,'3053','469',624.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246533',4715888,'3054','470',488.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246533',4715889,'3055','470',690.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246554',4716306,'3038','469',735.64,735.76,0.12,19.44,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246554',4716307,'3039','469',665.77,2473.02,1807.25,292774.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246554',4716308,'3040','469',509.43,2179.31,1669.88,270520.56,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246554',4716309,'3041','469',577.87,577.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246554',4716310,'3042','469',610.55,610.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246554',4716311,'3043','469',493.12,1959.29,1466.17,237519.54,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246554',4716312,'3044','469',549.42,549.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246554',4716313,'3045','469',649.68,1932.47,1282.79,207811.98,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246554',4716314,'3046','469',458.56,458.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246554',4716315,'3047','469',575.34,1516.82,941.48,152519.76,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246554',4716316,'3048','469',504.31,1602.74,1098.43,177945.66,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246554',4716317,'3049','469',621.36,621.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246554',4716318,'3050','469',586.56,586.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246554',4716319,'3051','469',494.03,1728.45,1234.42,199976.04,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246554',4716320,'3052','469',708.06,769.45,61.39,9945.18,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246554',4716321,'3053','469',624.95,1625.23,1000.28,162045.36,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246554',4716322,'3054','470',488.73,573.90,75.17,25933.65,0.00,0.00,10.00,0.00,0.00),('1','203','1028','246554',4716323,'3055','470',690.36,690.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246565',4716507,'3038','469',735.76,751.10,15.34,2531.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246565',4716508,'3039','469',2473.02,6262.47,3789.45,625259.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246565',4716509,'3040','469',2179.31,7767.13,5587.82,921990.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246565',4716510,'3041','469',577.87,577.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246565',4716511,'3042','469',610.55,610.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246565',4716512,'3043','469',1959.29,7391.00,5431.71,896232.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246565',4716513,'3044','469',549.42,549.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246565',4716514,'3045','469',1932.47,7579.69,5647.22,931791.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246565',4716515,'3046','469',458.56,458.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246565',4716516,'3047','469',1516.82,7138.72,5621.90,927613.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246565',4716517,'3048','469',1602.74,1602.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246565',4716518,'3049','469',621.36,4061.19,3439.83,567571.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246565',4716519,'3050','469',586.56,586.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246565',4716520,'3051','469',1728.45,6095.88,4367.43,720625.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246565',4716521,'3052','469',769.45,769.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246565',4716522,'3053','469',1625.23,4681.68,3056.45,504314.25,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246565',4716523,'3054','470',573.90,1086.88,501.51,173020.95,0.00,0.00,11.47,0.00,0.00),('1','203','1028','246565',4716524,'3055','470',690.36,760.65,70.29,24250.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246568',4716566,'3038','469',751.10,751.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246568',4716567,'3039','469',6262.47,13205.40,6942.93,1145583.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246568',4716568,'3040','469',7767.13,7767.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246568',4716569,'3041','469',577.87,6445.11,5867.24,968094.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246568',4716570,'3042','469',610.55,610.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246568',4716571,'3043','469',7391.00,12560.82,5169.82,853020.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246568',4716572,'3044','469',549.42,549.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246568',4716573,'3045','469',7579.69,13182.94,5603.25,924536.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246568',4716574,'3046','469',458.56,458.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246568',4716575,'3047','469',7138.72,10597.47,3431.75,566238.75,0.00,0.00,27.00,0.00,0.00),('1','203','1027','246568',4716576,'3048','469',1602.74,1602.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246568',4716577,'3049','469',4061.19,7047.42,2986.23,492727.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246568',4716578,'3050','469',586.56,586.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246568',4716579,'3051','469',6095.88,9165.12,3029.24,499824.60,0.00,0.00,40.00,0.00,0.00),('1','203','1027','246568',4716580,'3052','469',769.45,4253.80,3484.35,574917.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246568',4716581,'3053','469',4681.68,4681.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246568',4716582,'3054','470',1086.88,1178.91,92.03,31750.35,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246568',4716583,'3055','470',760.65,2424.69,1664.04,574093.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246580',4716823,'3038','469',751.10,751.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246580',4716824,'3039','469',13205.40,16116.00,2910.60,480249.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246580',4716825,'3040','469',7767.13,8298.43,531.30,87664.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246580',4716826,'3041','469',6445.11,9051.46,2606.35,430047.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246580',4716827,'3042','469',610.55,610.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246580',4716828,'3043','469',12560.82,14670.15,2109.33,348039.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246580',4716829,'3044','469',549.42,803.23,253.81,41878.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246580',4716830,'3045','469',13182.94,15205.31,2022.37,333691.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246580',4716831,'3046','469',458.56,4741.25,4282.69,706643.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246580',4716832,'3047','469',10597.47,15731.60,5134.13,847131.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246580',4716833,'3048','469',1602.74,5060.29,3457.55,570495.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246580',4716834,'3049','469',7047.42,10087.14,3039.72,501553.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246580',4716835,'3050','469',586.56,5512.47,4925.91,812775.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246580',4716836,'3051','469',9165.12,11293.36,2128.24,351159.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246580',4716837,'3052','469',4253.80,9019.92,4766.12,786409.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246580',4716838,'3053','469',4681.68,7461.30,2779.62,458637.30,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246580',4716839,'3054','470',1178.91,1249.65,70.74,24405.30,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246580',4716840,'3055','470',2424.69,3618.54,1193.85,411878.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246608',4717349,'3038','469',751.10,3046.27,2285.17,377053.05,0.00,0.00,10.00,0.00,0.00),('1','203','1026','246608',4717350,'3039','469',16116.00,19583.11,3457.11,570423.15,0.00,0.00,10.00,0.00,0.00),('1','203','1026','246608',4717351,'3040','469',8298.43,8308.43,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','203','1026','246608',4717352,'3041','469',9051.46,13204.66,4143.20,683628.00,0.00,0.00,10.00,0.00,0.00),('1','203','1026','246608',4717353,'3042','469',610.55,620.55,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','203','1026','246608',4717354,'3043','469',14670.15,18638.60,3958.45,653144.25,0.00,0.00,10.00,0.00,0.00),('1','203','1026','246608',4717355,'3044','469',803.23,2625.30,1812.07,298991.55,0.00,0.00,10.00,0.00,0.00),('1','203','1026','246608',4717356,'3045','469',15205.31,17980.06,2764.75,456183.75,0.00,0.00,10.00,0.00,0.00),('1','203','1027','246608',4717357,'3046','469',4741.25,6701.82,1950.57,321844.05,0.00,0.00,10.00,0.00,0.00),('1','203','1027','246608',4717358,'3047','469',15731.60,19323.85,3557.25,586946.25,0.00,0.00,35.00,0.00,0.00),('1','203','1027','246608',4717359,'3048','469',5060.29,8180.69,3100.40,511566.00,0.00,0.00,20.00,0.00,0.00),('1','203','1027','246608',4717360,'3049','469',10087.14,13301.56,3204.42,528729.30,0.00,0.00,10.00,0.00,0.00),('1','203','1027','246608',4717361,'3050','469',5512.47,9488.74,3966.27,654434.55,0.00,0.00,10.00,0.00,0.00),('1','203','1027','246608',4717362,'3051','469',11293.36,13521.95,2218.59,366067.35,0.00,0.00,10.00,0.00,0.00),('1','203','1027','246608',4717363,'3052','469',9019.92,11074.88,2044.96,337418.40,0.00,0.00,10.00,0.00,0.00),('1','203','1027','246608',4717364,'3053','469',7461.30,9574.38,2103.08,347008.20,0.00,0.00,10.00,0.00,0.00),('1','203','1028','246608',4717365,'3054','470',1249.65,1561.22,301.57,104041.65,0.00,0.00,10.00,0.00,0.00),('1','203','1028','246608',4717366,'3055','470',3618.54,4908.90,1280.36,441724.20,0.00,0.00,10.00,0.00,0.00),('1','203','1026','246620',4717602,'3038','469',3046.27,3046.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246620',4717603,'3039','469',19583.11,24795.77,5212.66,860088.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246620',4717604,'3040','469',8308.43,8308.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246620',4717605,'3041','469',13204.66,18270.50,5065.84,835863.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246620',4717606,'3042','469',620.55,2593.54,1972.99,325543.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246620',4717607,'3043','469',18638.60,21515.80,2877.20,474738.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246620',4717608,'3044','469',2625.30,2625.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246620',4717609,'3045','469',17980.06,21605.70,3625.64,598230.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246620',4717610,'3046','469',6701.82,6701.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246620',4717611,'3047','469',19323.85,22467.46,3143.61,518695.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246620',4717612,'3048','469',8180.69,10182.24,2001.55,330255.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246620',4717613,'3049','469',13301.56,17581.42,4279.86,706176.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246620',4717614,'3050','469',9488.74,12650.19,3161.45,521639.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246620',4717615,'3051','469',13521.95,16374.19,2852.24,470619.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246620',4717616,'3052','469',11074.88,13393.10,2318.22,382506.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246620',4717617,'3053','469',9574.38,11720.42,2111.04,348321.60,0.00,0.00,35.00,0.00,0.00),('1','203','1028','246620',4717618,'3054','470',1561.22,1561.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246620',4717619,'3055','470',4908.90,6435.73,1526.83,526756.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246626',4717704,'3038','469',3046.27,3046.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246626',4717705,'3039','469',24795.77,27172.53,2376.76,392165.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246626',4717706,'3040','469',8308.43,8308.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246626',4717707,'3041','469',18270.50,22270.27,3999.77,659962.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246626',4717708,'3042','469',2593.54,2593.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246626',4717709,'3043','469',21515.80,23969.18,2453.38,404807.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246626',4717710,'3044','469',2625.30,4106.67,1481.37,244426.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246626',4717711,'3045','469',21605.70,23991.07,2385.37,393586.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246626',4717712,'3046','469',6701.82,10671.65,3969.83,655021.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246626',4717713,'3047','469',22467.46,27068.26,4600.80,759132.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246626',4717714,'3048','469',10182.24,15075.09,4892.85,807320.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246626',4717715,'3049','469',17581.42,22662.11,5080.69,838313.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246626',4717716,'3050','469',12650.19,16291.91,3641.72,600883.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246626',4717717,'3051','469',16374.19,19804.44,3430.25,565991.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246626',4717718,'3052','469',13393.10,16589.16,3196.06,527349.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246626',4717719,'3053','469',11720.42,14431.88,2711.46,447390.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246626',4717720,'3054','470',1561.22,1695.15,133.93,46205.85,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246626',4717721,'3055','470',6435.73,7509.74,1074.01,370533.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246654',4718166,'3038','469',3046.27,3046.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246654',4718167,'3039','469',27172.53,27172.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246654',4718168,'3040','469',8308.43,8308.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246654',4718169,'3041','469',22270.27,22270.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246654',4718170,'3042','469',2593.54,2593.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246654',4718171,'3043','469',23969.18,23969.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246654',4718172,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246654',4718173,'3045','469',23991.07,23991.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246654',4718174,'3046','469',10671.65,10671.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246654',4718175,'3047','469',27068.26,30543.48,3475.22,573411.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246654',4718176,'3048','469',15075.09,17701.40,2626.31,433341.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246654',4718177,'3049','469',22662.11,25451.25,2789.14,460208.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246654',4718178,'3050','469',16291.91,19067.51,2765.60,456324.00,0.00,0.00,10.00,0.00,0.00),('1','203','1027','246654',4718179,'3051','469',19804.44,21909.45,2095.01,345676.65,0.00,0.00,10.00,0.00,0.00),('1','203','1027','246654',4718180,'3052','469',16589.16,19011.90,2422.74,399752.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246654',4718181,'3053','469',14431.88,17653.77,3221.89,531611.85,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246654',4718182,'3054','470',1695.15,1739.64,44.49,15349.05,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246654',4718183,'3055','470',7509.74,7669.32,159.58,55055.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246712',4718870,'3038','469',3046.27,3046.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246712',4718871,'3039','469',27172.53,27172.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246712',4718872,'3040','469',8308.43,8308.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246712',4718873,'3041','469',22270.27,23461.19,1190.92,196501.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246712',4718874,'3042','469',2593.54,2593.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246712',4718875,'3043','469',23969.18,24572.59,603.41,99562.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246712',4718876,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246712',4718877,'3045','469',23991.07,24755.28,764.21,126094.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246712',4718878,'3046','469',10671.65,12238.28,1566.63,258493.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246712',4718879,'3047','469',30543.48,33194.05,2650.57,437344.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246712',4718880,'3048','469',17701.40,19562.20,1860.80,307032.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246712',4718881,'3049','469',25451.25,28480.81,3029.56,499877.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246712',4718882,'3050','469',19067.51,22682.83,3615.32,596527.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246712',4718883,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246712',4718884,'3052','469',19011.90,23893.36,4881.46,805440.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246712',4718885,'3053','469',17653.77,17653.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246712',4718886,'3054','470',1739.64,1739.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246712',4718887,'3055','470',7669.32,8607.74,938.42,323754.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246739',4719291,'3038','469',3046.27,3046.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246739',4719292,'3039','469',27172.53,29717.37,2544.84,419898.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246739',4719293,'3040','469',8308.43,8308.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246739',4719294,'3041','469',23461.19,26087.50,2626.31,433341.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246739',4719295,'3042','469',2593.54,2593.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246739',4719296,'3043','469',24572.59,26568.06,1995.47,329252.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246739',4719297,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246739',4719298,'3045','469',24755.28,26860.31,2105.03,347329.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246739',4719299,'3046','469',12238.28,12238.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246739',4719300,'3047','469',33194.05,33798.98,604.93,99813.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246739',4719301,'3048','469',19562.20,19562.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246739',4719302,'3049','469',28480.81,30362.50,1881.69,310478.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246739',4719303,'3050','469',22682.83,24180.25,1497.42,247074.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246739',4719304,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246739',4719305,'3052','469',23893.36,23893.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246739',4719306,'3053','469',17653.77,19538.94,1885.17,311053.05,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246739',4719307,'3054','470',1739.64,1739.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246739',4719308,'3055','470',8607.74,9031.96,424.22,146355.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246758',4719706,'3038','469',3046.27,3046.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246758',4719707,'3039','469',29717.37,34058.26,4340.89,716246.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246758',4719708,'3040','469',8308.43,8308.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246758',4719709,'3041','469',26087.50,29138.17,3050.67,503360.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246758',4719710,'3042','469',2593.54,2593.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246758',4719711,'3043','469',26568.06,28503.93,1935.87,319418.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246758',4719712,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246758',4719713,'3045','469',26860.31,29255.25,2394.94,395165.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246758',4719714,'3046','469',12238.28,12238.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246758',4719715,'3047','469',33798.98,36078.02,2279.04,376041.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246758',4719716,'3048','469',19562.20,19562.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246758',4719717,'3049','469',30362.50,34018.76,3656.26,603282.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246758',4719718,'3050','469',24180.25,24180.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246758',4719719,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246758',4719720,'3052','469',23893.36,26310.41,2417.05,398813.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246758',4719721,'3053','469',19538.94,19538.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246758',4719722,'3054','470',1739.64,1748.34,8.70,3001.50,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246758',4719723,'3055','470',9031.96,9638.29,606.33,209183.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246857',4721705,'3038','469',3046.27,3046.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246857',4721706,'3039','469',34058.26,34058.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246857',4721707,'3040','469',8308.43,8308.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246857',4721708,'3041','469',29138.17,32558.69,3420.52,564385.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246857',4721709,'3042','469',2593.54,2593.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246857',4721710,'3043','469',28503.93,31229.27,2725.34,449681.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246857',4721711,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246857',4721712,'3045','469',29255.25,32408.84,3153.59,520342.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246857',4721713,'3046','469',12238.28,12238.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246857',4721714,'3047','469',36078.02,38983.93,2905.91,479475.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246857',4721715,'3048','469',19562.20,19562.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246857',4721716,'3049','469',34018.76,36525.25,2506.49,413570.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246857',4721717,'3050','469',24180.25,27053.47,2873.22,474081.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246857',4721718,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246857',4721719,'3052','469',26310.41,28624.82,2314.41,381877.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246857',4721720,'3053','469',19538.94,19538.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246857',4721721,'3054','470',1748.34,1748.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246857',4721722,'3055','470',9638.29,9977.32,339.03,116965.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246866',4721855,'3038','469',3046.27,3046.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246866',4721856,'3039','469',34058.26,34058.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246866',4721857,'3040','469',8308.43,8308.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246866',4721858,'3041','469',32558.69,36183.11,3604.42,594729.30,0.00,0.00,20.00,0.00,0.00),('1','203','1026','246866',4721859,'3042','469',2593.54,2593.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246866',4721860,'3043','469',31229.27,34276.34,3047.07,502766.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246866',4721861,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','246866',4721862,'3045','469',32408.84,34984.16,2575.32,424927.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246866',4721863,'3046','469',12238.28,14583.42,2345.14,386948.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246866',4721864,'3047','469',38983.93,38983.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246866',4721865,'3048','469',19562.20,19562.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246866',4721866,'3049','469',36525.25,38507.31,1982.06,327039.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246866',4721867,'3050','469',27053.47,29498.62,2445.15,403449.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246866',4721868,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246866',4721869,'3052','469',28624.82,32405.04,3780.22,623736.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','246866',4721870,'3053','469',19538.94,19538.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246866',4721871,'3054','470',1748.34,1748.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','246866',4721872,'3055','470',9977.32,10352.59,375.27,129468.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247171',4726929,'3038','469',3046.27,3046.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247171',4726930,'3039','469',34058.26,36139.26,2081.00,343365.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247171',4726931,'3040','469',8308.43,8308.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247171',4726932,'3041','469',36183.11,37930.97,1747.86,288396.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247171',4726933,'3042','469',2593.54,2593.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247171',4726934,'3043','469',34276.34,35945.54,1669.20,275418.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247171',4726935,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247171',4726936,'3045','469',34984.16,37153.96,2169.80,358017.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247171',4726937,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247171',4726938,'3047','469',38983.93,41533.50,2549.57,420679.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247171',4726939,'3048','469',19562.20,20565.23,1003.03,165499.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247171',4726940,'3049','469',38507.31,41157.58,2650.27,437294.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247171',4726941,'3050','469',29498.62,31914.14,2415.52,398560.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247171',4726942,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247171',4726943,'3052','469',32405.04,32405.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247171',4726944,'3053','469',19538.94,20189.08,650.14,107273.10,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247171',4726945,'3054','470',1748.34,2367.91,619.57,213751.65,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247171',4726946,'3055','470',10352.59,10650.22,297.63,102682.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247247',4728241,'3038','469',3046.27,3046.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247247',4728242,'3039','469',36139.26,38629.91,2490.65,410957.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247247',4728243,'3040','469',8308.43,8308.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247247',4728244,'3041','469',37930.97,37930.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247247',4728245,'3042','469',2593.54,2593.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247247',4728246,'3043','469',35945.54,37807.46,1861.92,307216.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247247',4728247,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247247',4728248,'3045','469',37153.96,39312.91,2158.95,356226.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247247',4728249,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247247',4728250,'3047','469',41533.50,43652.85,2119.35,349692.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247247',4728251,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247247',4728252,'3049','469',41157.58,43609.84,2452.26,404622.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247247',4728253,'3050','469',31914.14,34938.80,3024.66,499068.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247247',4728254,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247247',4728255,'3052','469',32405.04,34265.80,1860.76,307025.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247247',4728256,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247247',4728257,'3054','470',2367.91,2367.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247247',4728258,'3055','470',10650.22,11457.63,807.41,278556.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247276',4728885,'3038','469',3046.27,5036.36,1990.09,328364.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247276',4728886,'3039','469',38629.91,41501.73,2871.82,473850.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247276',4728887,'3040','469',8308.43,10390.79,2082.36,343589.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247276',4728888,'3041','469',37930.97,40745.50,2814.53,464397.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247276',4728889,'3042','469',2593.54,4923.00,2329.46,384360.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247276',4728890,'3043','469',37807.46,40475.26,2667.80,440187.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247276',4728891,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247276',4728892,'3045','469',39312.91,42057.86,2734.95,451266.75,0.00,0.00,10.00,0.00,0.00),('1','203','1027','247276',4728893,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247276',4728894,'3047','469',43652.85,43652.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247276',4728895,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247276',4728896,'3049','469',43609.84,43609.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247276',4728897,'3050','469',34938.80,34938.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247276',4728898,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247276',4728899,'3052','469',34265.80,34265.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247276',4728900,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247276',4728901,'3054','470',2367.91,2367.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247276',4728902,'3055','470',11457.63,11485.47,27.84,9604.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247349',4730391,'3038','469',5036.36,6215.07,1178.71,194487.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247349',4730392,'3039','469',41501.73,42829.85,1328.12,219139.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247349',4730393,'3040','469',10390.79,11703.50,1312.71,216597.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247349',4730394,'3041','469',40745.50,42096.25,1350.75,222873.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247349',4730395,'3042','469',4923.00,6472.18,1549.18,255614.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247349',4730396,'3043','469',40475.26,41484.03,1008.77,166447.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247349',4730397,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247349',4730398,'3045','469',42057.86,44048.47,1990.61,328450.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247349',4730399,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247349',4730400,'3047','469',43652.85,43652.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247349',4730401,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247349',4730402,'3049','469',43609.84,43609.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247349',4730403,'3050','469',34938.80,36616.55,1677.75,276828.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247349',4730404,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247349',4730405,'3052','469',34265.80,35673.85,1408.05,232328.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247349',4730406,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247349',4730407,'3054','470',2367.91,2367.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247349',4730408,'3055','470',11485.47,11485.87,0.00,0.00,0.00,0.00,0.40,0.00,0.00),('1','203','1026','247508',4732817,'3038','469',6215.07,6215.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247508',4732818,'3039','469',42829.85,42829.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247508',4732819,'3040','469',11703.50,11703.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247508',4732820,'3041','469',42096.25,42096.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247508',4732821,'3042','469',6472.18,6472.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247508',4732822,'3043','469',41484.03,41484.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247508',4732823,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247508',4732824,'3045','469',44048.47,44048.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247508',4732825,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247508',4732826,'3047','469',43652.85,48259.30,4606.45,760064.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247508',4732827,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247508',4732828,'3049','469',43609.84,48216.89,4607.05,760163.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247508',4732829,'3050','469',36616.55,41251.66,4635.11,764793.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247508',4732830,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247508',4732831,'3052','469',35673.85,39692.94,4019.09,663149.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247508',4732832,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247508',4732833,'3054','470',2367.91,2367.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247508',4732834,'3055','470',11485.87,11485.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247610',4734608,'3038','469',6215.07,6215.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247610',4734609,'3039','469',42829.85,42829.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247610',4734610,'3040','469',11703.50,11703.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247610',4734611,'3041','469',42096.25,42096.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247610',4734612,'3042','469',6472.18,6472.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247610',4734613,'3043','469',41484.03,41484.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247610',4734614,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247610',4734615,'3045','469',44048.47,44048.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247610',4734616,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247610',4734617,'3047','469',48259.30,49465.66,1206.36,199049.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247610',4734618,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247610',4734619,'3049','469',48216.89,50049.77,1832.88,302425.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247610',4734620,'3050','469',41251.66,42686.14,1404.48,231739.20,0.00,0.00,30.00,0.00,0.00),('1','203','1027','247610',4734621,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247610',4734622,'3052','469',39692.94,41548.69,1855.75,306198.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247610',4734623,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247610',4734624,'3054','470',2367.91,2367.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247610',4734625,'3055','470',11485.87,11485.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247772',4737267,'3038','469',6215.07,6215.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247772',4737268,'3039','469',42829.85,42829.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247772',4737269,'3040','469',11703.50,11703.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247772',4737270,'3041','469',42096.25,42096.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247772',4737271,'3042','469',6472.18,6472.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247772',4737272,'3043','469',41484.03,41484.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247772',4737273,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247772',4737274,'3045','469',44048.47,44048.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247772',4737275,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247772',4737276,'3047','469',49465.66,51105.54,1639.88,270580.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247772',4737277,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247772',4737278,'3049','469',50049.77,51894.30,1844.53,304347.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247772',4737279,'3050','469',42686.14,44262.13,1575.99,260038.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247772',4737280,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247772',4737281,'3052','469',41548.69,43409.98,1861.29,307112.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247772',4737282,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247772',4737283,'3054','470',2367.91,2367.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247772',4737284,'3055','470',11485.87,11627.33,141.46,48803.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247957',4740205,'3038','469',6215.07,6215.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247957',4740206,'3039','469',42829.85,42829.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247957',4740207,'3040','469',11703.50,11703.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247957',4740208,'3041','469',42096.25,42096.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247957',4740209,'3042','469',6472.18,6472.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247957',4740210,'3043','469',41484.03,41484.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247957',4740211,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','247957',4740212,'3045','469',44048.47,44048.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247957',4740213,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247957',4740214,'3047','469',51105.54,54452.97,3347.43,552325.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247957',4740215,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247957',4740216,'3049','469',51894.30,55016.54,3122.24,515169.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247957',4740217,'3050','469',44262.13,46958.60,2696.47,444917.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247957',4740218,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247957',4740219,'3052','469',43409.98,47591.18,4181.20,689898.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','247957',4740220,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247957',4740221,'3054','470',2367.91,2367.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','247957',4740222,'3055','470',11627.33,11667.69,40.36,13924.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248016',4741348,'3038','469',6215.07,6215.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248016',4741349,'3039','469',42829.85,42829.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248016',4741350,'3040','469',11703.50,11703.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248016',4741351,'3041','469',42096.25,42096.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248016',4741352,'3042','469',6472.18,6472.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248016',4741353,'3043','469',41484.03,41484.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248016',4741354,'3044','469',4106.67,4106.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248016',4741355,'3045','469',44048.47,44048.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248016',4741356,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248016',4741357,'3047','469',54452.97,59634.48,5181.51,854949.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248016',4741358,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248016',4741359,'3049','469',55016.54,58560.45,3543.91,584745.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248016',4741360,'3050','469',46958.60,50536.83,3578.23,590407.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248016',4741361,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248016',4741362,'3052','469',47591.18,53829.74,6238.56,1029362.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248016',4741363,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248016',4741364,'3054','470',2367.91,2367.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248016',4741365,'3055','470',11667.69,12259.39,591.70,204136.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248155',4743802,'3038','469',6215.07,6704.39,489.32,80737.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248155',4743803,'3039','469',42829.85,44915.24,2085.39,344089.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248155',4743804,'3040','469',11703.50,12066.22,362.72,59848.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248155',4743805,'3041','469',42096.25,45067.25,2971.00,490215.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248155',4743806,'3042','469',6472.18,7209.79,737.61,121705.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248155',4743807,'3043','469',41484.03,44333.04,2849.01,470086.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248155',4743808,'3044','469',4106.67,4771.27,664.60,109659.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248155',4743809,'3045','469',44048.47,46388.40,2339.93,386088.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248155',4743810,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248155',4743811,'3047','469',59634.48,61959.12,2324.64,383565.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248155',4743812,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248155',4743813,'3049','469',58560.45,60817.58,2257.13,372426.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248155',4743814,'3050','469',50536.83,52447.68,1910.85,315290.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248155',4743815,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248155',4743816,'3052','469',53829.74,56255.19,2425.45,400199.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248155',4743817,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248155',4743818,'3054','470',2367.91,2367.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248155',4743819,'3055','470',12259.39,13173.41,914.02,315336.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248294',4746250,'3038','469',6704.39,6704.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248294',4746251,'3039','469',44915.24,50869.94,5934.70,979225.50,0.00,0.00,20.00,0.00,0.00),('1','203','1026','248294',4746252,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248294',4746253,'3041','469',45067.25,49804.50,4727.25,779996.25,0.00,0.00,10.00,0.00,0.00),('1','203','1026','248294',4746254,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248294',4746255,'3043','469',44333.04,49592.01,5248.97,866080.05,0.00,0.00,10.00,0.00,0.00),('1','203','1026','248294',4746256,'3044','469',4771.27,4771.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248294',4746257,'3045','469',46388.40,50425.95,4027.55,664545.75,0.00,0.00,10.00,0.00,0.00),('1','203','1027','248294',4746258,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248294',4746259,'3047','469',61959.12,61959.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248294',4746260,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248294',4746261,'3049','469',60817.58,60817.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248294',4746262,'3050','469',52447.68,52447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248294',4746263,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248294',4746264,'3052','469',56255.19,56255.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248294',4746265,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248294',4746266,'3054','470',2367.91,2377.91,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','203','1028','248294',4746267,'3055','470',13173.41,13712.08,518.67,178941.15,0.00,0.00,20.00,0.00,0.00),('1','203','1026','248325',4746822,'3038','469',6704.39,6704.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248325',4746823,'3039','469',50869.94,53333.69,2463.75,406518.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248325',4746824,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248325',4746825,'3041','469',49804.50,52964.40,3159.90,521383.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248325',4746826,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248325',4746827,'3043','469',49592.01,53240.52,3648.51,602004.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248325',4746828,'3044','469',4771.27,4771.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248325',4746829,'3045','469',50425.95,53610.13,3184.18,525389.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248325',4746830,'3046','469',14583.42,14583.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248325',4746831,'3047','469',61959.12,61959.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248325',4746832,'3048','469',20565.23,20565.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248325',4746833,'3049','469',60817.58,60817.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248325',4746834,'3050','469',52447.68,52447.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248325',4746835,'3051','469',21909.45,21909.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248325',4746836,'3052','469',56255.19,56255.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248325',4746837,'3053','469',20189.08,20189.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248325',4746838,'3054','470',2377.91,2377.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248325',4746839,'3055','470',13712.08,14050.24,338.16,116665.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248476',4749117,'3038','469',6704.39,6704.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248476',4749118,'3039','469',53333.69,53333.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248476',4749119,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248476',4749120,'3041','469',52964.40,52964.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248476',4749121,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248476',4749122,'3043','469',53240.52,53240.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248476',4749123,'3044','469',4771.27,4771.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248476',4749124,'3045','469',53610.13,53610.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248476',4749125,'3046','469',14583.42,17414.26,2830.84,467088.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248476',4749126,'3047','469',61959.12,65595.89,3636.77,600067.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248476',4749127,'3048','469',20565.23,23263.98,2698.75,445293.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248476',4749128,'3049','469',60817.58,62658.92,1841.34,303821.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248476',4749129,'3050','469',52447.68,55663.49,3215.81,530608.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248476',4749130,'3051','469',21909.45,23901.45,1992.00,328680.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248476',4749131,'3052','469',56255.19,58248.69,1993.50,328927.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248476',4749132,'3053','469',20189.08,23106.19,2917.11,481323.15,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248476',4749133,'3054','470',2377.91,2377.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248476',4749134,'3055','470',14050.24,14634.30,584.06,201500.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248664',4752166,'3038','469',6704.39,6704.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248664',4752167,'3039','469',53333.69,56778.08,3444.39,568324.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248664',4752168,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248664',4752169,'3041','469',52964.40,58441.85,5477.45,903779.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248664',4752170,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248664',4752171,'3043','469',53240.52,55428.51,2187.99,361018.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248664',4752172,'3044','469',4771.27,4771.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248664',4752173,'3045','469',53610.13,56845.12,3234.99,533773.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248664',4752174,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248664',4752175,'3047','469',65595.89,67661.02,2065.13,340746.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248664',4752176,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248664',4752177,'3049','469',62658.92,65921.49,3262.57,538324.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248664',4752178,'3050','469',55663.49,57596.65,1933.16,318971.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248664',4752179,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248664',4752180,'3052','469',58248.69,58821.43,572.74,94502.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248664',4752181,'3053','469',23106.19,25164.45,2058.26,339612.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248664',4752182,'3054','470',2377.91,2377.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248664',4752183,'3055','470',14634.30,15080.06,445.76,153787.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248731',4753585,'3038','469',6704.39,8419.50,1715.11,282993.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248731',4753586,'3039','469',56778.08,59200.26,2422.18,399659.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248731',4753587,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248731',4753588,'3041','469',58441.85,61731.16,3289.31,542736.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248731',4753589,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248731',4753590,'3043','469',55428.51,57827.37,2398.86,395811.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248731',4753591,'3044','469',4771.27,4771.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248731',4753592,'3045','469',56845.12,60734.34,3889.22,641721.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248731',4753593,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248731',4753594,'3047','469',67661.02,67661.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248731',4753595,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248731',4753596,'3049','469',65921.49,68602.35,2680.86,442341.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248731',4753597,'3050','469',57596.65,60562.73,2966.08,489403.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248731',4753598,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248731',4753599,'3052','469',58821.43,61012.25,2190.82,361485.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248731',4753600,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248731',4753601,'3054','470',2377.91,2377.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248731',4753602,'3055','470',15080.06,15508.95,428.89,147967.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248878',4756021,'3038','469',8419.50,8419.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248878',4756022,'3039','469',59200.26,61498.00,2297.74,379127.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248878',4756023,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248878',4756024,'3041','469',61731.16,64957.26,3226.10,532306.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248878',4756025,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248878',4756026,'3043','469',57827.37,59971.15,2143.78,353723.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248878',4756027,'3044','469',4771.27,5321.98,550.71,90867.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248878',4756028,'3045','469',60734.34,62811.44,2077.10,342721.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248878',4756029,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248878',4756030,'3047','469',67661.02,70115.43,2454.41,404977.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248878',4756031,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248878',4756032,'3049','469',68602.35,70676.52,2074.17,342238.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248878',4756033,'3050','469',60562.73,62795.37,2232.64,368385.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248878',4756034,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248878',4756035,'3052','469',61012.25,64427.84,3415.59,563572.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248878',4756036,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248878',4756037,'3054','470',2377.91,2377.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248878',4756038,'3055','470',15508.95,16002.58,493.63,170302.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248938',4756899,'3038','469',8419.50,8419.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248938',4756900,'3039','469',61498.00,61498.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248938',4756901,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248938',4756902,'3041','469',64957.26,64957.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248938',4756903,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248938',4756904,'3043','469',59971.15,63972.10,4000.95,660156.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248938',4756905,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','248938',4756906,'3045','469',62811.44,67164.94,4353.50,718327.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248938',4756907,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248938',4756908,'3047','469',70115.43,70115.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248938',4756909,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248938',4756910,'3049','469',70676.52,70676.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248938',4756911,'3050','469',62795.37,66382.78,3587.41,591922.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248938',4756912,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248938',4756913,'3052','469',64427.84,67547.59,3119.75,514758.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','248938',4756914,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248938',4756915,'3054','470',2377.91,2377.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','248938',4756916,'3055','470',16002.58,16220.71,218.13,75254.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249124',4759966,'3038','469',8419.50,8419.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249124',4759967,'3039','469',61498.00,61498.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249124',4759968,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249124',4759969,'3041','469',64957.26,64957.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249124',4759970,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249124',4759971,'3043','469',63972.10,64968.01,995.91,164325.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249124',4759972,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249124',4759973,'3045','469',67164.94,68458.29,1293.35,213402.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249124',4759974,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249124',4759975,'3047','469',70115.43,70115.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249124',4759976,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249124',4759977,'3049','469',70676.52,70676.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249124',4759978,'3050','469',66382.78,67617.79,1225.01,202126.65,0.00,0.00,10.00,0.00,0.00),('1','203','1027','249124',4759979,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249124',4759980,'3052','469',67547.59,68755.92,1208.33,199374.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249124',4759981,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249124',4759982,'3054','470',2377.91,2377.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249124',4759983,'3055','470',16220.71,16340.57,119.86,41351.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249239',4762189,'3038','469',8419.50,8419.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249239',4762190,'3039','469',61498.00,61498.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249239',4762191,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249239',4762192,'3041','469',64957.26,64957.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249239',4762193,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249239',4762194,'3043','469',64968.01,64968.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249239',4762195,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249239',4762196,'3045','469',68458.29,68458.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249239',4762197,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249239',4762198,'3047','469',70115.43,70115.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249239',4762199,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249239',4762200,'3049','469',70676.52,70676.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249239',4762201,'3050','469',67617.79,71655.79,4038.00,666270.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249239',4762202,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249239',4762203,'3052','469',68755.92,73805.47,5029.55,829875.75,0.00,0.00,20.00,0.00,0.00),('1','203','1027','249239',4762204,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249239',4762205,'3054','470',2377.91,2377.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249239',4762206,'3055','470',16340.57,16631.58,291.01,100398.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249354',4764032,'3038','469',8419.50,8419.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249354',4764033,'3039','469',61498.00,61498.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249354',4764034,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249354',4764035,'3041','469',64957.26,64957.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249354',4764036,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249354',4764037,'3043','469',64968.01,64968.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249354',4764038,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249354',4764039,'3045','469',68458.29,68458.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249354',4764040,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249354',4764041,'3047','469',70115.43,70115.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249354',4764042,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249354',4764043,'3049','469',70676.52,70676.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249354',4764044,'3050','469',71655.79,71655.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249354',4764045,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249354',4764046,'3052','469',73805.47,73805.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249354',4764047,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249354',4764048,'3054','470',2377.91,2377.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249354',4764049,'3055','470',16631.58,16808.40,176.82,61002.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249374',4764263,'3038','469',8419.50,8419.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249374',4764264,'3039','469',61498.00,61498.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249374',4764265,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249374',4764266,'3041','469',64957.26,64957.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249374',4764267,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249374',4764268,'3043','469',64968.01,64968.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249374',4764269,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249374',4764270,'3045','469',68458.29,68458.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249374',4764271,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249374',4764272,'3047','469',70115.43,71968.40,1852.97,305740.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249374',4764273,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249374',4764274,'3049','469',70676.52,72093.20,1416.68,233752.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249374',4764275,'3050','469',71655.79,73418.42,1762.63,290833.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249374',4764276,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249374',4764277,'3052','469',73805.47,75402.13,1596.66,263448.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249374',4764278,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249374',4764279,'3054','470',2377.91,2427.91,50.00,17250.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249374',4764280,'3055','470',16808.40,16983.90,175.50,60547.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249598',4768165,'3038','469',8419.50,8419.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249598',4768166,'3039','469',61498.00,61498.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249598',4768167,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249598',4768168,'3041','469',64957.26,64957.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249598',4768169,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249598',4768170,'3043','469',64968.01,64968.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249598',4768171,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249598',4768172,'3045','469',68458.29,68458.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249598',4768173,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249598',4768174,'3047','469',71968.40,75389.15,3420.75,564423.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249598',4768175,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249598',4768176,'3049','469',72093.20,75939.82,3846.62,634692.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249598',4768177,'3050','469',73418.42,76922.43,3504.01,578161.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249598',4768178,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249598',4768179,'3052','469',75402.13,78616.01,3213.88,530290.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249598',4768180,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249598',4768181,'3054','470',2427.91,2427.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249598',4768182,'3055','470',16983.90,17710.82,726.92,250787.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249616',4768364,'3038','469',8419.50,8419.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249616',4768365,'3039','469',61498.00,63364.94,1866.94,308045.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249616',4768366,'3040','469',12066.22,12066.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249616',4768367,'3041','469',64957.26,66850.09,1892.83,312316.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249616',4768368,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249616',4768369,'3043','469',64968.01,66288.45,1320.44,217872.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249616',4768370,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249616',4768371,'3045','469',68458.29,70599.17,2140.88,353245.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249616',4768372,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249616',4768373,'3047','469',75389.15,77193.87,1804.72,297778.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249616',4768374,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249616',4768375,'3049','469',75939.82,77407.36,1467.54,242144.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249616',4768376,'3050','469',76922.43,77975.09,1052.66,173688.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249616',4768377,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249616',4768378,'3052','469',78616.01,80200.73,1584.72,261478.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249616',4768379,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249616',4768380,'3054','470',2427.91,2606.21,178.30,61513.50,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249616',4768381,'3055','470',17710.82,17954.46,243.64,84055.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249852',4772490,'3038','469',8419.50,8419.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249852',4772491,'3039','469',63364.94,64854.21,1489.27,245729.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249852',4772492,'3040','469',12066.22,12832.80,766.58,126485.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249852',4772493,'3041','469',66850.09,68292.25,1442.16,237956.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249852',4772494,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249852',4772495,'3043','469',66288.45,68241.87,1953.42,322314.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249852',4772496,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249852',4772497,'3045','469',70599.17,71968.82,1369.65,225992.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249852',4772498,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249852',4772499,'3047','469',77193.87,78470.91,1277.04,210711.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249852',4772500,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249852',4772501,'3049','469',77407.36,78943.23,1535.87,253418.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249852',4772502,'3050','469',77975.09,80123.02,2147.93,354408.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249852',4772503,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249852',4772504,'3052','469',80200.73,81325.90,1125.17,185653.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249852',4772505,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249852',4772506,'3054','470',2606.21,2606.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249852',4772507,'3055','470',17954.46,18568.64,614.18,211892.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249913',4773429,'3038','469',8419.50,8419.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249913',4773430,'3039','469',64854.21,66869.08,2004.87,330803.55,0.00,0.00,10.00,0.00,0.00),('1','203','1026','249913',4773431,'3040','469',12832.80,13591.71,748.91,123570.15,0.00,0.00,10.00,0.00,0.00),('1','203','1026','249913',4773432,'3041','469',68292.25,69676.85,1374.60,226809.00,0.00,0.00,10.00,0.00,0.00),('1','203','1026','249913',4773433,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249913',4773434,'3043','469',68241.87,70165.68,1913.81,315778.65,0.00,0.00,10.00,0.00,0.00),('1','203','1026','249913',4773435,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','249913',4773436,'3045','469',71968.82,73510.04,1531.22,252651.30,0.00,0.00,10.00,0.00,0.00),('1','203','1027','249913',4773437,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249913',4773438,'3047','469',78470.91,80130.62,1649.71,272202.15,0.00,0.00,10.00,0.00,0.00),('1','203','1027','249913',4773439,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249913',4773440,'3049','469',78943.23,80411.47,1458.24,240609.60,0.00,0.00,10.00,0.00,0.00),('1','203','1027','249913',4773441,'3050','469',80123.02,81759.56,1626.54,268379.10,0.00,0.00,10.00,0.00,0.00),('1','203','1027','249913',4773442,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','249913',4773443,'3052','469',81325.90,82724.92,1389.02,229188.30,0.00,0.00,10.00,0.00,0.00),('1','203','1027','249913',4773444,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249913',4773445,'3054','470',2606.21,2606.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','249913',4773446,'3055','470',18568.64,18996.92,418.28,144306.60,0.00,0.00,10.00,0.00,0.00),('1','203','1026','250101',4776603,'3038','469',8419.50,9286.06,866.56,142982.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250101',4776604,'3039','469',66869.08,68484.12,1615.04,266481.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250101',4776605,'3040','469',13591.71,13591.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250101',4776606,'3041','469',69676.85,71783.93,2107.08,347668.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250101',4776607,'3042','469',7209.79,7209.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250101',4776608,'3043','469',70165.68,71382.49,1216.81,200773.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250101',4776609,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250101',4776610,'3045','469',73510.04,74897.13,1387.09,228869.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250101',4776611,'3046','469',17414.26,17414.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250101',4776612,'3047','469',80130.62,81612.66,1482.04,244536.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250101',4776613,'3048','469',23263.98,23263.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250101',4776614,'3049','469',80411.47,82194.34,1782.87,294173.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250101',4776615,'3050','469',81759.56,83737.17,1977.61,326305.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250101',4776616,'3051','469',23901.45,23901.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250101',4776617,'3052','469',82724.92,83907.86,1182.94,195185.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250101',4776618,'3053','469',25164.45,25164.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','250101',4776619,'3054','470',2606.21,2606.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','250101',4776620,'3055','470',18996.92,19171.14,174.22,60105.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250159',4777499,'3038','469',9286.06,9298.18,12.12,1999.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250159',4777500,'3039','469',68484.12,70171.95,1687.83,278491.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250159',4777501,'3040','469',13591.71,14259.47,667.76,110180.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250159',4777502,'3041','469',71783.93,73276.26,1492.33,246234.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250159',4777503,'3042','469',7209.79,9045.71,1835.92,302926.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250159',4777504,'3043','469',71382.49,71382.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250159',4777505,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250159',4777506,'3045','469',74897.13,76404.45,1507.32,248707.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250159',4777507,'3046','469',17414.26,18656.79,1242.53,205017.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250159',4777508,'3047','469',81612.66,81612.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250159',4777509,'3048','469',23263.98,24640.16,1376.18,227069.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250159',4777510,'3049','469',82194.34,82194.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250159',4777511,'3050','469',83737.17,83737.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250159',4777512,'3051','469',23901.45,25117.81,1216.36,200699.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250159',4777513,'3052','469',83907.86,83907.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250159',4777514,'3053','469',25164.45,26035.87,871.42,143784.30,0.00,0.00,0.00,0.00,0.00),('1','203','1028','250159',4777515,'3054','470',2606.21,2666.21,60.00,20700.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','250159',4777516,'3055','470',19171.14,19294.90,123.76,42697.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250285',4779856,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250285',4779857,'3039','469',70171.95,72470.02,2298.07,379181.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250285',4779858,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250285',4779859,'3041','469',73276.26,75431.24,2154.98,355571.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250285',4779860,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250285',4779861,'3043','469',71382.49,73238.00,1855.51,306159.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250285',4779862,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250285',4779863,'3045','469',76404.45,78648.10,2243.65,370202.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250285',4779864,'3046','469',18656.79,18656.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250285',4779865,'3047','469',81612.66,81612.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250285',4779866,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250285',4779867,'3049','469',82194.34,82194.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250285',4779868,'3050','469',83737.17,83737.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250285',4779869,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250285',4779870,'3052','469',83907.86,83907.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250285',4779871,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','250285',4779872,'3054','470',2666.21,2666.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','250285',4779873,'3055','470',19294.90,19841.30,546.40,188508.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250497',4783204,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250497',4783205,'3039','469',72470.02,72470.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250497',4783206,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250497',4783207,'3041','469',75431.24,75431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250497',4783208,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250497',4783209,'3043','469',73238.00,73238.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250497',4783210,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250497',4783211,'3045','469',78648.10,78648.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250497',4783212,'3046','469',18656.79,18656.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250497',4783213,'3047','469',81612.66,81612.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250497',4783214,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250497',4783215,'3049','469',82194.34,82194.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250497',4783216,'3050','469',83737.17,83737.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250497',4783217,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250497',4783218,'3052','469',83907.86,83907.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250497',4783219,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','250497',4783220,'3054','470',2666.21,2726.21,60.00,20700.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','250497',4783221,'3055','470',19841.30,20029.42,188.12,64901.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250766',4788025,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250766',4788026,'3039','469',72470.02,72470.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250766',4788027,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250766',4788028,'3041','469',75431.24,75431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250766',4788029,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250766',4788030,'3043','469',73238.00,73238.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250766',4788031,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','250766',4788032,'3045','469',78648.10,78648.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250766',4788033,'3046','469',18656.79,18656.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250766',4788034,'3047','469',81612.66,81612.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250766',4788035,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250766',4788036,'3049','469',82194.34,82194.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250766',4788037,'3050','469',83737.17,83737.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250766',4788038,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250766',4788039,'3052','469',83907.86,83907.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','250766',4788040,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','250766',4788041,'3054','470',2726.21,2726.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','250766',4788042,'3055','470',20029.42,20235.82,206.40,71208.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251040',4792738,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251040',4792739,'3039','469',72470.02,75056.47,2586.45,426764.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251040',4792740,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251040',4792741,'3041','469',75431.24,78034.21,2602.97,429490.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251040',4792742,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251040',4792743,'3043','469',73238.00,75953.21,2715.21,448009.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251040',4792744,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251040',4792745,'3045','469',78648.10,80914.58,2266.48,373969.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251040',4792746,'3046','469',18656.79,18656.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251040',4792747,'3047','469',81612.66,81612.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251040',4792748,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251040',4792749,'3049','469',82194.34,82194.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251040',4792750,'3050','469',83737.17,83737.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251040',4792751,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251040',4792752,'3052','469',83907.86,83907.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251040',4792753,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251040',4792754,'3054','470',2726.21,2726.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251040',4792755,'3055','470',20235.82,20578.73,342.91,118303.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251128',4794273,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251128',4794274,'3039','469',75056.47,77268.33,2191.86,361656.90,0.00,0.00,20.00,0.00,0.00),('1','203','1026','251128',4794275,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251128',4794276,'3041','469',78034.21,81137.24,3083.03,508699.95,0.00,0.00,20.00,0.00,0.00),('1','203','1026','251128',4794277,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251128',4794278,'3043','469',75953.21,79126.74,3153.53,520332.45,0.00,0.00,20.00,0.00,0.00),('1','203','1026','251128',4794279,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251128',4794280,'3045','469',80914.58,82866.93,1947.35,321312.75,0.00,0.00,5.00,0.00,0.00),('1','203','1027','251128',4794281,'3046','469',18656.79,18656.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251128',4794282,'3047','469',81612.66,83504.94,1892.28,312226.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251128',4794283,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251128',4794284,'3049','469',82194.34,82194.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251128',4794285,'3050','469',83737.17,83737.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251128',4794286,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251128',4794287,'3052','469',83907.86,85652.19,1744.33,287814.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251128',4794288,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251128',4794289,'3054','470',2726.21,2726.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251128',4794290,'3055','470',20578.73,20876.96,298.23,102889.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251185',4795360,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251185',4795361,'3039','469',77268.33,77268.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251185',4795362,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251185',4795363,'3041','469',81137.24,84025.69,2888.45,476594.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251185',4795364,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251185',4795365,'3043','469',79126.74,81797.29,2638.71,435387.15,0.00,0.00,31.84,0.00,0.00),('1','203','1026','251185',4795366,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251185',4795367,'3045','469',82866.93,84201.09,1306.44,215562.60,0.00,0.00,27.72,0.00,0.00),('1','203','1027','251185',4795368,'3046','469',18656.79,18656.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251185',4795369,'3047','469',83504.94,85907.64,2402.70,396445.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251185',4795370,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251185',4795371,'3049','469',82194.34,84846.66,2652.32,437632.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251185',4795372,'3050','469',83737.17,85978.98,2241.81,369898.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251185',4795373,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251185',4795374,'3052','469',85652.19,87048.99,1396.80,230472.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251185',4795375,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251185',4795376,'3054','470',2726.21,2726.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251185',4795377,'3055','470',20876.96,22286.36,1409.40,486243.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251410',4799084,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251410',4799085,'3039','469',77268.33,77863.66,595.33,98229.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251410',4799086,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251410',4799087,'3041','469',84025.69,84866.30,840.61,138700.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251410',4799088,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251410',4799089,'3043','469',81797.29,82309.22,511.93,84468.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251410',4799090,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251410',4799091,'3045','469',84201.09,84926.24,725.15,119649.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251410',4799092,'3046','469',18656.79,18656.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251410',4799093,'3047','469',85907.64,87875.72,1968.08,324733.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251410',4799094,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251410',4799095,'3049','469',84846.66,87287.02,2440.36,402659.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251410',4799096,'3050','469',85978.98,88087.28,2108.30,347869.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251410',4799097,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251410',4799098,'3052','469',87048.99,89519.87,2470.88,407695.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251410',4799099,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251410',4799100,'3054','470',2726.21,2726.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251410',4799101,'3055','470',22286.36,22825.88,539.52,186134.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251508',4800840,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251508',4800841,'3039','469',77863.66,77863.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251508',4800842,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251508',4800843,'3041','469',84866.30,84866.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251508',4800844,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251508',4800845,'3043','469',82309.22,84327.83,2018.61,333070.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251508',4800846,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251508',4800847,'3045','469',84926.24,87605.10,2678.86,442011.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251508',4800848,'3046','469',18656.79,18656.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251508',4800849,'3047','469',87875.72,89679.73,1804.01,297661.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251508',4800850,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251508',4800851,'3049','469',87287.02,89436.71,2149.69,354698.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251508',4800852,'3050','469',88087.28,90379.41,2292.13,378201.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251508',4800853,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251508',4800854,'3052','469',89519.87,91843.02,2323.15,383319.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251508',4800855,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251508',4800856,'3054','470',2726.21,2726.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251508',4800857,'3055','470',22825.88,23596.05,770.17,265708.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251632',4802952,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251632',4802953,'3039','469',77863.66,77863.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251632',4802954,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251632',4802955,'3041','469',84866.30,84866.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251632',4802956,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251632',4802957,'3043','469',84327.83,86486.73,2138.39,352834.35,0.00,0.00,20.51,0.00,0.00),('1','203','1026','251632',4802958,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251632',4802959,'3045','469',87605.10,90438.78,2813.17,464173.05,0.00,0.00,20.51,0.00,0.00),('1','203','1027','251632',4802960,'3046','469',18656.79,18656.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251632',4802961,'3047','469',89679.73,89679.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251632',4802962,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251632',4802963,'3049','469',89436.71,91577.24,2120.04,349806.60,0.00,0.00,20.49,0.00,0.00),('1','203','1027','251632',4802964,'3050','469',90379.41,92440.58,2061.17,340093.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251632',4802965,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251632',4802966,'3052','469',91843.02,93479.04,1636.02,269943.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251632',4802967,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251632',4802968,'3054','470',2726.21,2786.21,60.00,20700.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251632',4802969,'3055','470',23596.05,23832.90,236.85,81713.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251688',4804101,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251688',4804102,'3039','469',77863.66,77863.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251688',4804103,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251688',4804104,'3041','469',84866.30,84866.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251688',4804105,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251688',4804106,'3043','469',86486.73,88972.88,2486.15,410214.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251688',4804107,'3044','469',5321.98,5321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251688',4804108,'3045','469',90438.78,93847.50,3408.72,562438.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251688',4804109,'3046','469',18656.79,19247.96,591.17,97543.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251688',4804110,'3047','469',89679.73,91921.66,2241.93,369918.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251688',4804111,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251688',4804112,'3049','469',91577.24,94129.23,2551.99,421078.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251688',4804113,'3050','469',92440.58,94894.97,2454.39,404974.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251688',4804114,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251688',4804115,'3052','469',93479.04,95954.84,2475.80,408507.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251688',4804116,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251688',4804117,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251688',4804118,'3055','470',23832.90,24334.67,501.77,173110.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251880',4807328,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251880',4807329,'3039','469',77863.66,79658.32,1794.66,296118.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251880',4807330,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251880',4807331,'3041','469',84866.30,86537.82,1671.52,275800.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251880',4807332,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251880',4807333,'3043','469',88972.88,90247.39,1274.51,210294.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251880',4807334,'3044','469',5321.98,6608.09,1286.11,212208.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251880',4807335,'3045','469',93847.50,95748.27,1900.77,313627.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251880',4807336,'3046','469',19247.96,19247.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251880',4807337,'3047','469',91921.66,92669.81,748.15,123444.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251880',4807338,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251880',4807339,'3049','469',94129.23,94864.86,735.63,121378.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251880',4807340,'3050','469',94894.97,95953.56,1058.59,174667.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251880',4807341,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251880',4807342,'3052','469',95954.84,97029.53,1074.69,177323.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251880',4807343,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251880',4807344,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251880',4807345,'3055','470',24334.67,24744.57,409.90,141415.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251925',4808200,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251925',4808201,'3039','469',79658.32,83505.16,3846.84,634728.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251925',4808202,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251925',4808203,'3041','469',86537.82,90603.24,4065.42,670794.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251925',4808204,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251925',4808205,'3043','469',90247.39,92946.86,2699.47,445412.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251925',4808206,'3044','469',6608.09,6721.30,113.21,18679.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','251925',4808207,'3045','469',95748.27,97184.70,1436.43,237010.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251925',4808208,'3046','469',19247.96,19247.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251925',4808209,'3047','469',92669.81,96446.69,3776.88,623185.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251925',4808210,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251925',4808211,'3049','469',94864.86,98560.50,3695.64,609780.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251925',4808212,'3050','469',95953.56,95953.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251925',4808213,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251925',4808214,'3052','469',97029.53,97029.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','251925',4808215,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251925',4808216,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','251925',4808217,'3055','470',24744.57,25469.35,724.78,250049.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252076',4810797,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252076',4810798,'3039','469',83505.16,85680.01,2174.85,358850.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252076',4810799,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252076',4810800,'3041','469',90603.24,93017.96,2414.72,398428.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252076',4810801,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252076',4810802,'3043','469',92946.86,95072.65,2125.79,350755.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252076',4810803,'3044','469',6721.30,6721.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252076',4810804,'3045','469',97184.70,99852.07,2667.37,440116.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252076',4810805,'3046','469',19247.96,19632.66,384.70,63475.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252076',4810806,'3047','469',96446.69,99463.84,3017.15,497829.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252076',4810807,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252076',4810808,'3049','469',98560.50,100918.30,2357.80,389037.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252076',4810809,'3050','469',95953.56,96203.55,249.99,41248.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252076',4810810,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252076',4810811,'3052','469',97029.53,97850.00,820.47,135377.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252076',4810812,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252076',4810813,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252076',4810814,'3055','470',25469.35,26164.35,695.00,239775.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252226',4813445,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252226',4813446,'3039','469',85680.01,85680.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252226',4813447,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252226',4813448,'3041','469',93017.96,93017.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252226',4813449,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252226',4813450,'3043','469',95072.65,95072.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252226',4813451,'3044','469',6721.30,6721.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252226',4813452,'3045','469',99852.07,103119.55,3267.48,539134.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252226',4813453,'3046','469',19632.66,19632.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252226',4813454,'3047','469',99463.84,103164.36,3700.52,610585.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252226',4813455,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252226',4813456,'3049','469',100918.30,105298.90,4380.60,722799.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252226',4813457,'3050','469',96203.55,100679.82,4476.27,738584.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252226',4813458,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252226',4813459,'3052','469',97850.00,102718.67,4868.67,803330.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252226',4813460,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252226',4813461,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252226',4813462,'3055','470',26164.35,27384.54,1220.19,420965.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252331',4815076,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252331',4815077,'3039','469',85680.01,85680.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252331',4815078,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252331',4815079,'3041','469',93017.96,93017.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252331',4815080,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252331',4815081,'3043','469',95072.65,97633.14,2560.49,422480.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252331',4815082,'3044','469',6721.30,6721.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252331',4815083,'3045','469',103119.55,105562.21,2442.66,403038.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252331',4815084,'3046','469',19632.66,19632.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252331',4815085,'3047','469',103164.36,105025.35,1860.99,307063.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252331',4815086,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252331',4815087,'3049','469',105298.90,107799.54,2500.64,412605.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252331',4815088,'3050','469',100679.82,102720.10,2040.28,336646.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252331',4815089,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252331',4815090,'3052','469',102718.67,104182.10,1463.43,241465.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252331',4815091,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252331',4815092,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252331',4815093,'3055','470',27384.54,27972.29,587.75,202773.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252393',4816422,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252393',4816423,'3039','469',85680.01,86890.46,1210.45,199724.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252393',4816424,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252393',4816425,'3041','469',93017.96,94288.91,1270.95,209706.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252393',4816426,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252393',4816427,'3043','469',97633.14,98326.99,693.85,114485.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252393',4816428,'3044','469',6721.30,6721.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252393',4816429,'3045','469',105562.21,110018.90,4456.69,735353.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252393',4816430,'3046','469',19632.66,19632.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252393',4816431,'3047','469',105025.35,107557.78,2532.43,417850.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252393',4816432,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252393',4816433,'3049','469',107799.54,110195.84,2396.30,395389.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252393',4816434,'3050','469',102720.10,105233.40,2513.30,414694.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252393',4816435,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252393',4816436,'3052','469',104182.10,106745.99,2563.89,423041.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252393',4816437,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252393',4816438,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252393',4816439,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252503',4818217,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252503',4818218,'3039','469',86890.46,86890.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252503',4818219,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252503',4818220,'3041','469',94288.91,94288.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252503',4818221,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252503',4818222,'3043','469',98326.99,100495.56,2158.57,356164.05,0.00,0.00,10.00,0.00,0.00),('1','203','1026','252503',4818223,'3044','469',6721.30,6721.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252503',4818224,'3045','469',110018.90,112673.14,2644.24,436299.60,0.00,0.00,10.00,0.00,0.00),('1','203','1027','252503',4818225,'3046','469',19632.66,19632.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252503',4818226,'3047','469',107557.78,109324.58,1756.80,289872.00,0.00,0.00,10.00,0.00,0.00),('1','203','1027','252503',4818227,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252503',4818228,'3049','469',110195.84,112445.07,2239.23,369472.95,0.00,0.00,10.00,0.00,0.00),('1','203','1027','252503',4818229,'3050','469',105233.40,107674.03,2430.63,401053.95,0.00,0.00,10.00,0.00,0.00),('1','203','1027','252503',4818230,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252503',4818231,'3052','469',106745.99,108819.87,2063.88,340540.20,0.00,0.00,10.00,0.00,0.00),('1','203','1027','252503',4818232,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252503',4818233,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252503',4818234,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252710',4821959,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252710',4821960,'3039','469',86890.46,88071.09,1180.63,194803.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252710',4821961,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252710',4821962,'3041','469',94288.91,96946.22,2657.31,438456.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252710',4821963,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252710',4821964,'3043','469',100495.56,105763.91,5268.35,869277.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252710',4821965,'3044','469',6721.30,6721.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252710',4821966,'3045','469',112673.14,116670.62,3997.48,659584.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252710',4821967,'3046','469',19632.66,19632.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252710',4821968,'3047','469',109324.58,113041.21,3716.63,613243.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252710',4821969,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252710',4821970,'3049','469',112445.07,116763.91,4318.84,712608.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252710',4821971,'3050','469',107674.03,107674.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252710',4821972,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252710',4821973,'3052','469',108819.87,108819.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252710',4821974,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252710',4821975,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252710',4821976,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252779',4822870,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252779',4822871,'3039','469',88071.09,88071.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252779',4822872,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252779',4822873,'3041','469',96946.22,96946.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252779',4822874,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252779',4822875,'3043','469',105763.91,105867.97,104.06,17169.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252779',4822876,'3044','469',6721.30,6721.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252779',4822877,'3045','469',116670.62,119733.99,3063.37,505456.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252779',4822878,'3046','469',19632.66,19632.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252779',4822879,'3047','469',113041.21,115985.05,2943.84,485733.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252779',4822880,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252779',4822881,'3049','469',116763.91,119178.42,2414.51,398394.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252779',4822882,'3050','469',107674.03,109855.03,2181.00,359865.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252779',4822883,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252779',4822884,'3052','469',108819.87,111754.03,2934.16,484136.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252779',4822885,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252779',4822886,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252779',4822887,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252946',4825922,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252946',4825923,'3039','469',88071.09,89764.19,1693.10,279361.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252946',4825924,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252946',4825925,'3041','469',96946.22,100809.26,3863.04,637401.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252946',4825926,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252946',4825927,'3043','469',105867.97,109485.33,3617.36,596864.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252946',4825928,'3044','469',6721.30,6721.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','252946',4825929,'3045','469',119733.99,119733.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252946',4825930,'3046','469',19632.66,19632.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252946',4825931,'3047','469',115985.05,115985.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252946',4825932,'3048','469',24640.16,24640.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252946',4825933,'3049','469',119178.42,122981.42,3803.00,627495.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252946',4825934,'3050','469',109855.03,112660.60,2805.57,462919.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252946',4825935,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252946',4825936,'3052','469',111754.03,111754.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','252946',4825937,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252946',4825938,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','252946',4825939,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253038',4827162,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253038',4827163,'3039','469',89764.19,90854.01,1089.82,179820.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253038',4827164,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253038',4827165,'3041','469',100809.26,101744.50,935.24,154314.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253038',4827166,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253038',4827167,'3043','469',109485.33,110193.02,707.69,116768.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253038',4827168,'3044','469',6721.30,6721.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253038',4827169,'3045','469',119733.99,120559.42,825.43,136195.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253038',4827170,'3046','469',19632.66,19632.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253038',4827171,'3047','469',115985.05,117495.40,1510.35,249207.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253038',4827172,'3048','469',24640.16,25749.16,1109.00,182985.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253038',4827173,'3049','469',122981.42,124964.02,1982.60,327129.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253038',4827174,'3050','469',112660.60,114074.68,1414.08,233323.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253038',4827175,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253038',4827176,'3052','469',111754.03,113186.64,1432.61,236380.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253038',4827177,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253038',4827178,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253038',4827179,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253137',4829142,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253137',4829143,'3039','469',90854.01,93144.63,2290.62,377952.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253137',4829144,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253137',4829145,'3041','469',101744.50,104826.32,3081.82,508500.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253137',4829146,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253137',4829147,'3043','469',110193.02,110193.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253137',4829148,'3044','469',6721.30,6721.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253137',4829149,'3045','469',120559.42,122239.94,1680.52,277285.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253137',4829150,'3046','469',19632.66,19632.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253137',4829151,'3047','469',117495.40,121036.98,3541.58,584360.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253137',4829152,'3048','469',25749.16,25749.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253137',4829153,'3049','469',124964.02,128158.61,3194.59,527107.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253137',4829154,'3050','469',114074.68,117490.34,3415.66,563583.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253137',4829155,'3051','469',25117.81,25117.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253137',4829156,'3052','469',113186.64,113995.88,809.24,133524.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253137',4829157,'3053','469',26035.87,26035.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253137',4829158,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253137',4829159,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253294',4831578,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253294',4831579,'3039','469',93144.63,95137.03,1992.40,328746.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253294',4831580,'3040','469',14259.47,14259.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253294',4831581,'3041','469',104826.32,106332.45,1506.13,248511.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253294',4831582,'3042','469',9045.71,9045.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253294',4831583,'3043','469',110193.02,111472.81,1279.79,211165.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253294',4831584,'3044','469',6721.30,7033.24,311.94,51470.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253294',4831585,'3045','469',122239.94,123684.20,1444.26,238302.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253294',4831586,'3046','469',19632.66,20336.42,703.76,116120.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253294',4831587,'3047','469',121036.98,122086.23,1049.25,173126.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253294',4831588,'3048','469',25749.16,25749.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253294',4831589,'3049','469',128158.61,129265.81,1107.20,182688.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253294',4831590,'3050','469',117490.34,118377.15,886.81,146323.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253294',4831591,'3051','469',25117.81,25755.07,637.26,105147.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253294',4831592,'3052','469',113995.88,114631.37,635.49,104855.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253294',4831593,'3053','469',26035.87,27165.07,1129.20,186318.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253294',4831594,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253294',4831595,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253410',4833671,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253410',4833672,'3039','469',95137.03,96655.85,1508.82,248955.30,0.00,0.00,10.00,0.00,0.00),('1','203','1026','253410',4833673,'3040','469',14259.47,15709.12,1439.65,237542.25,0.00,0.00,10.00,0.00,0.00),('1','203','1026','253410',4833674,'3041','469',106332.45,108613.24,2275.79,375505.35,0.00,0.00,5.00,0.00,0.00),('1','203','1026','253410',4833675,'3042','469',9045.71,10163.70,1117.99,184468.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253410',4833676,'3043','469',111472.81,112839.72,1366.91,225540.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253410',4833677,'3044','469',7033.24,7778.34,745.10,122941.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253410',4833678,'3045','469',123684.20,124931.42,1247.22,205791.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253410',4833679,'3046','469',20336.42,22134.85,1798.43,296740.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253410',4833680,'3047','469',122086.23,122868.88,782.65,129137.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253410',4833681,'3048','469',25749.16,25749.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253410',4833682,'3049','469',129265.81,130559.51,1293.70,213460.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253410',4833683,'3050','469',118377.15,120182.60,1805.45,297899.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253410',4833684,'3051','469',25755.07,25755.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253410',4833685,'3052','469',114631.37,115538.55,907.18,149684.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253410',4833686,'3053','469',27165.07,27165.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253410',4833687,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253410',4833688,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253538',4835656,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253538',4835657,'3039','469',96655.85,99026.27,2370.42,391119.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253538',4835658,'3040','469',15709.12,15709.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253538',4835659,'3041','469',108613.24,108613.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253538',4835660,'3042','469',10163.70,10163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253538',4835661,'3043','469',112839.72,112839.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253538',4835662,'3044','469',7778.34,7778.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253538',4835663,'3045','469',124931.42,126980.76,2049.34,338141.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253538',4835664,'3046','469',22134.85,22134.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253538',4835665,'3047','469',122868.88,124914.96,2046.08,337603.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253538',4835666,'3048','469',25749.16,25749.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253538',4835667,'3049','469',130559.51,132647.70,2088.19,344551.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253538',4835668,'3050','469',120182.60,121984.44,1801.84,297303.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253538',4835669,'3051','469',25755.07,25755.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253538',4835670,'3052','469',115538.55,117542.14,2003.59,330592.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253538',4835671,'3053','469',27165.07,27165.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253538',4835672,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253538',4835673,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253641',4837636,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253641',4837637,'3039','469',99026.27,100064.67,1038.40,171336.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253641',4837638,'3040','469',15709.12,15709.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253641',4837639,'3041','469',108613.24,108613.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253641',4837640,'3042','469',10163.70,10163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253641',4837641,'3043','469',112839.72,112839.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253641',4837642,'3044','469',7778.34,7778.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253641',4837643,'3045','469',126980.76,128296.98,1316.22,217176.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253641',4837644,'3046','469',22134.85,24352.26,2217.41,365872.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253641',4837645,'3047','469',124914.96,128031.05,3116.09,514154.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253641',4837646,'3048','469',25749.16,27536.69,1777.53,293292.45,0.00,0.00,10.00,0.00,0.00),('1','203','1027','253641',4837647,'3049','469',132647.70,136625.64,3974.94,655865.10,0.00,0.00,3.00,0.00,0.00),('1','203','1027','253641',4837648,'3050','469',121984.44,124966.19,2981.75,491988.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253641',4837649,'3051','469',25755.07,25755.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253641',4837650,'3052','469',117542.14,120193.70,2651.56,437507.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253641',4837651,'3053','469',27165.07,27708.92,543.85,89735.25,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253641',4837652,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253641',4837653,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253756',4839389,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253756',4839390,'3039','469',100064.67,100064.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253756',4839391,'3040','469',15709.12,15709.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253756',4839392,'3041','469',108613.24,108613.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253756',4839393,'3042','469',10163.70,10163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253756',4839394,'3043','469',112839.72,112839.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253756',4839395,'3044','469',7778.34,7778.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253756',4839396,'3045','469',128296.98,128296.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253756',4839397,'3046','469',24352.26,24352.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253756',4839398,'3047','469',128031.05,130646.21,2615.16,431501.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253756',4839399,'3048','469',27536.69,29811.58,2274.89,375356.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253756',4839400,'3049','469',136625.64,139078.12,2452.48,404659.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253756',4839401,'3050','469',124966.19,126728.71,1762.52,290815.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253756',4839402,'3051','469',25755.07,27607.19,1852.12,305599.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253756',4839403,'3052','469',120193.70,122496.59,2302.89,379976.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253756',4839404,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253756',4839405,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253756',4839406,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253890',4842112,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253890',4842113,'3039','469',100064.67,100923.96,859.29,141782.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253890',4842114,'3040','469',15709.12,15709.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253890',4842115,'3041','469',108613.24,109634.80,1021.56,168557.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253890',4842116,'3042','469',10163.70,10163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253890',4842117,'3043','469',112839.72,112839.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253890',4842118,'3044','469',7778.34,7778.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253890',4842119,'3045','469',128296.98,128296.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253890',4842120,'3046','469',24352.26,24352.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253890',4842121,'3047','469',130646.21,134539.79,3893.58,642440.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253890',4842122,'3048','469',29811.58,32574.03,2762.45,455804.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253890',4842123,'3049','469',139078.12,142396.86,3318.74,547592.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253890',4842124,'3050','469',126728.71,128640.13,1911.42,315384.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253890',4842125,'3051','469',27607.19,30052.98,2445.79,403555.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253890',4842126,'3052','469',122496.59,125017.44,2520.85,415940.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253890',4842127,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253890',4842128,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253890',4842129,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253979',4843261,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253979',4843262,'3039','469',100923.96,102549.01,1625.05,268133.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253979',4843263,'3040','469',15709.12,15709.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253979',4843264,'3041','469',109634.80,111336.47,1701.67,280775.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253979',4843265,'3042','469',10163.70,10163.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253979',4843266,'3043','469',112839.72,114517.02,1677.30,276754.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253979',4843267,'3044','469',7778.34,7778.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','253979',4843268,'3045','469',128296.98,129838.83,1541.85,254405.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253979',4843269,'3046','469',24352.26,24352.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253979',4843270,'3047','469',134539.79,134539.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253979',4843271,'3048','469',32574.03,32574.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253979',4843272,'3049','469',142396.86,142396.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253979',4843273,'3050','469',128640.13,130685.16,2045.03,337429.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253979',4843274,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253979',4843275,'3052','469',125017.44,126156.18,1138.74,187892.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','253979',4843276,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253979',4843277,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','253979',4843278,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254210',4847537,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254210',4847538,'3039','469',102549.01,105303.93,2754.92,454561.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254210',4847539,'3040','469',15709.12,18079.37,2370.25,391091.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254210',4847540,'3041','469',111336.47,114073.45,2736.98,451601.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254210',4847541,'3042','469',10163.70,12096.16,1932.46,318855.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254210',4847542,'3043','469',114517.02,117072.49,2555.47,421652.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254210',4847543,'3044','469',7778.34,7778.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254210',4847544,'3045','469',129838.83,132946.54,3107.71,512772.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254210',4847545,'3046','469',24352.26,24352.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254210',4847546,'3047','469',134539.79,134544.27,4.48,739.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254210',4847547,'3048','469',32574.03,32574.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254210',4847548,'3049','469',142396.86,142396.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254210',4847549,'3050','469',130685.16,131070.51,385.35,63582.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254210',4847550,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254210',4847551,'3052','469',126156.18,126793.57,637.39,105169.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254210',4847552,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254210',4847553,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254210',4847554,'3055','470',27972.29,27972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254287',4848815,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254287',4848816,'3039','469',105303.93,108509.47,3205.54,528914.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254287',4848817,'3040','469',18079.37,18079.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254287',4848818,'3041','469',114073.45,116849.29,2775.84,458013.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254287',4848819,'3042','469',12096.16,13668.81,1572.65,259487.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254287',4848820,'3043','469',117072.49,119197.90,2125.41,350692.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254287',4848821,'3044','469',7778.34,10037.13,2258.79,372700.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254287',4848822,'3045','469',132946.54,134811.07,1864.53,307647.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254287',4848823,'3046','469',24352.26,24352.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254287',4848824,'3047','469',134544.27,134544.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254287',4848825,'3048','469',32574.03,32574.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254287',4848826,'3049','469',142396.86,142396.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254287',4848827,'3050','469',131070.51,131070.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254287',4848828,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254287',4848829,'3052','469',126793.57,126793.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254287',4848830,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254287',4848831,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254287',4848832,'3055','470',27972.29,28516.80,531.51,183370.95,0.00,0.00,13.00,0.00,0.00),('1','203','1026','254486',4852109,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254486',4852110,'3039','469',108509.47,110224.47,1715.00,282975.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254486',4852111,'3040','469',18079.37,18683.07,603.70,99610.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254486',4852112,'3041','469',116849.29,118002.86,1153.57,190339.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254486',4852113,'3042','469',13668.81,14752.12,1083.31,178746.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254486',4852114,'3043','469',119197.90,120582.43,1384.53,228447.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254486',4852115,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254486',4852116,'3045','469',134811.07,136177.49,1366.42,225459.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254486',4852117,'3046','469',24352.26,24352.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254486',4852118,'3047','469',134544.27,134544.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254486',4852119,'3048','469',32574.03,32574.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254486',4852120,'3049','469',142396.86,142396.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254486',4852121,'3050','469',131070.51,131070.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254486',4852122,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254486',4852123,'3052','469',126793.57,126793.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254486',4852124,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254486',4852125,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254486',4852126,'3055','470',28516.80,28893.07,376.27,129813.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254508',4852636,'3038','469',9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254508',4852637,'3039','469',110224.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254508',4852638,'3040','469',18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254508',4852639,'3041','469',118002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254508',4852640,'3042','469',14752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254508',4852641,'3043','469',120582.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254508',4852642,'3044','469',10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254508',4852643,'3045','469',136177.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254508',4852644,'3046','469',24352.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254508',4852645,'3047','469',134544.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254508',4852646,'3048','469',32574.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254508',4852647,'3049','469',142396.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254508',4852648,'3050','469',131070.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254508',4852649,'3051','469',30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254508',4852650,'3052','469',126793.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254508',4852651,'3053','469',27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254508',4852652,'3054','470',2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254508',4852653,'3055','470',28893.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254648',4855316,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254648',4855317,'3039','469',110224.47,110224.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254648',4855318,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254648',4855319,'3041','469',118002.86,118002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254648',4855320,'3042','469',14752.12,14752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254648',4855321,'3043','469',120582.43,120582.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254648',4855322,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254648',4855323,'3045','469',136177.49,136177.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254648',4855324,'3046','469',24352.26,24352.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254648',4855325,'3047','469',134544.27,134544.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254648',4855326,'3048','469',32574.03,32574.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254648',4855327,'3049','469',142396.86,142396.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254648',4855328,'3050','469',131070.51,131070.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254648',4855329,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254648',4855330,'3052','469',126793.57,126793.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254648',4855331,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254648',4855332,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254648',4855333,'3055','470',28893.07,29218.45,324.38,113533.00,0.00,0.00,1.00,0.00,0.00),('1','203','1026','254783',4857324,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254783',4857325,'3039','469',110224.47,110224.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254783',4857326,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254783',4857327,'3041','469',118002.86,118002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254783',4857328,'3042','469',14752.12,14752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254783',4857329,'3043','469',120582.43,120582.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254783',4857330,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254783',4857331,'3045','469',136177.49,136177.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254783',4857332,'3046','469',24352.26,24352.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254783',4857333,'3047','469',134544.27,136769.02,2224.75,367083.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254783',4857334,'3048','469',32574.03,33197.25,623.22,102831.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254783',4857335,'3049','469',142396.86,143776.10,1379.24,227574.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254783',4857336,'3050','469',131070.51,132487.05,1416.54,233729.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254783',4857337,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254783',4857338,'3052','469',126793.57,128652.80,1859.23,306772.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254783',4857339,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254783',4857340,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254783',4857341,'3055','470',29218.45,29452.95,234.50,82075.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254987',4860759,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254987',4860760,'3039','469',110224.47,110224.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254987',4860761,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254987',4860762,'3041','469',118002.86,118002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254987',4860763,'3042','469',14752.12,14752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254987',4860764,'3043','469',120582.43,120582.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254987',4860765,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','254987',4860766,'3045','469',136177.49,136177.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254987',4860767,'3046','469',24352.26,25994.25,1641.99,270928.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254987',4860768,'3047','469',136769.02,139553.64,2784.62,459462.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254987',4860769,'3048','469',33197.25,35130.48,1933.23,318982.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254987',4860770,'3049','469',143776.10,146403.14,2617.04,431811.60,0.00,0.00,10.00,0.00,0.00),('1','203','1027','254987',4860771,'3050','469',132487.05,136123.11,3626.06,598299.90,0.00,0.00,10.00,0.00,0.00),('1','203','1027','254987',4860772,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','254987',4860773,'3052','469',128652.80,132120.72,3457.92,570556.80,0.00,0.00,10.00,0.00,0.00),('1','203','1027','254987',4860774,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254987',4860775,'3054','470',2786.21,2786.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','254987',4860776,'3055','470',29452.95,29986.39,533.44,186704.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255002',4861000,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255002',4861001,'3039','469',110224.47,110224.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255002',4861002,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255002',4861003,'3041','469',118002.86,118002.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255002',4861004,'3042','469',14752.12,14752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255002',4861005,'3043','469',120582.43,120582.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255002',4861006,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255002',4861007,'3045','469',136177.49,136177.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255002',4861008,'3046','469',25994.25,25994.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255002',4861009,'3047','469',139553.64,141556.36,2002.72,330448.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255002',4861010,'3048','469',35130.48,36228.96,1098.48,181249.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255002',4861011,'3049','469',146403.14,148915.07,2511.93,414468.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255002',4861012,'3050','469',136123.11,138542.34,2419.23,399172.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255002',4861013,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255002',4861014,'3052','469',132120.72,134230.74,2110.02,348153.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255002',4861015,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255002',4861016,'3054','470',2786.21,2886.21,100.00,35000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255002',4861017,'3055','470',29986.39,30161.82,175.43,61400.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255143',4863772,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255143',4863773,'3039','469',110224.47,113009.41,2779.94,458690.10,0.00,0.00,5.00,0.00,0.00),('1','203','1026','255143',4863774,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255143',4863775,'3041','469',118002.86,121913.46,3910.60,645249.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255143',4863776,'3042','469',14752.12,14752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255143',4863777,'3043','469',120582.43,122665.53,2083.10,343711.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255143',4863778,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255143',4863779,'3045','469',136177.49,138565.84,2388.35,394077.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255143',4863780,'3046','469',25994.25,25994.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255143',4863781,'3047','469',141556.36,141572.12,15.76,2600.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255143',4863782,'3048','469',36228.96,36228.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255143',4863783,'3049','469',148915.07,148915.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255143',4863784,'3050','469',138542.34,141488.69,2946.35,486147.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255143',4863785,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255143',4863786,'3052','469',134230.74,136464.52,2233.78,368573.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255143',4863787,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255143',4863788,'3054','470',2886.21,2886.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255143',4863789,'3055','470',30161.82,30443.55,281.73,98605.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255280',4866148,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255280',4866149,'3039','469',113009.41,115875.05,2865.64,472830.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255280',4866150,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255280',4866151,'3041','469',121913.46,124131.63,2218.17,365998.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255280',4866152,'3042','469',14752.12,14752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255280',4866153,'3043','469',122665.53,125943.33,3277.80,540837.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255280',4866154,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255280',4866155,'3045','469',138565.84,141373.03,2807.19,463186.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255280',4866156,'3046','469',25994.25,25994.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255280',4866157,'3047','469',141572.12,141572.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255280',4866158,'3048','469',36228.96,36228.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255280',4866159,'3049','469',148915.07,151251.10,2336.03,385444.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255280',4866160,'3050','469',141488.69,141488.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255280',4866161,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255280',4866162,'3052','469',136464.52,136464.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255280',4866163,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255280',4866164,'3054','470',2886.21,2886.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255280',4866165,'3055','470',30443.55,30500.74,57.19,20302.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255386',4867973,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255386',4867974,'3039','469',115875.05,119782.58,3907.53,644742.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255386',4867975,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255386',4867976,'3041','469',124131.63,127187.42,3045.79,502555.35,0.00,0.00,10.00,0.00,0.00),('1','203','1026','255386',4867977,'3042','469',14752.12,14752.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255386',4867978,'3043','469',125943.33,129659.60,3716.27,613184.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255386',4867979,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255386',4867980,'3045','469',141373.03,144731.13,3358.10,554086.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255386',4867981,'3046','469',25994.25,25994.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255386',4867982,'3047','469',141572.12,142792.22,1220.10,201316.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255386',4867983,'3048','469',36228.96,36228.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255386',4867984,'3049','469',151251.10,152967.07,1715.97,283135.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255386',4867985,'3050','469',141488.69,141488.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255386',4867986,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255386',4867987,'3052','469',136464.52,136464.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255386',4867988,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255386',4867989,'3054','470',2886.21,2886.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255386',4867990,'3055','470',30500.74,31505.88,1005.14,356824.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255532',4870046,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255532',4870047,'3039','469',119782.58,120692.68,910.10,150166.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255532',4870048,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255532',4870049,'3041','469',127187.42,128176.14,988.72,163138.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255532',4870050,'3042','469',14752.12,15172.52,420.40,69366.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255532',4870051,'3043','469',129659.60,130302.96,643.36,106154.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255532',4870052,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255532',4870053,'3045','469',144731.13,145405.05,673.92,111196.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255532',4870054,'3046','469',25994.25,25994.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255532',4870055,'3047','469',142792.22,142792.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255532',4870056,'3048','469',36228.96,36228.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255532',4870057,'3049','469',152967.07,152967.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255532',4870058,'3050','469',141488.69,141488.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255532',4870059,'3051','469',30052.98,30052.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255532',4870060,'3052','469',136464.52,136464.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255532',4870061,'3053','469',27708.92,27708.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255532',4870062,'3054','470',2886.21,2986.21,100.00,35500.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255532',4870063,'3055','470',31505.88,31725.51,219.63,77968.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255657',4872388,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255657',4872389,'3039','469',120692.68,120692.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255657',4872390,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255657',4872391,'3041','469',128176.14,128176.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255657',4872392,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255657',4872393,'3043','469',130302.96,130302.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255657',4872394,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255657',4872395,'3045','469',145405.05,145405.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255657',4872396,'3046','469',25994.25,26014.25,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','203','1027','255657',4872397,'3047','469',142792.22,146290.31,3478.09,573884.85,0.00,0.00,20.00,0.00,0.00),('1','203','1027','255657',4872398,'3048','469',36228.96,36249.63,0.00,0.00,0.00,0.00,20.67,0.00,0.00),('1','203','1027','255657',4872399,'3049','469',152967.07,157013.95,4026.88,664435.20,0.00,0.00,20.00,0.00,0.00),('1','203','1027','255657',4872400,'3050','469',141488.69,144381.14,2872.45,473954.25,0.00,0.00,20.00,0.00,0.00),('1','203','1027','255657',4872401,'3051','469',30052.98,31999.78,1926.80,317922.00,0.00,0.00,20.00,0.00,0.00),('1','203','1027','255657',4872402,'3052','469',136464.52,139096.89,2622.37,432691.05,0.00,0.00,10.00,0.00,0.00),('1','203','1027','255657',4872403,'3053','469',27708.92,29517.24,1798.32,296722.80,0.00,0.00,10.00,0.00,0.00),('1','203','1028','255657',4872404,'3054','470',2986.21,3151.12,154.91,54993.05,0.00,0.00,10.00,0.00,0.00),('1','203','1028','255657',4872405,'3055','470',31725.51,33368.83,1629.32,578408.60,0.00,0.00,14.00,0.00,0.00),('1','203','1026','255841',4875311,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255841',4875312,'3039','469',120692.68,123752.07,3046.28,502636.20,0.00,0.00,13.11,0.00,0.00),('1','203','1026','255841',4875313,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255841',4875314,'3041','469',128176.14,130605.28,2429.14,400808.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255841',4875315,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255841',4875316,'3043','469',130302.96,131823.48,1520.52,250885.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255841',4875317,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255841',4875318,'3045','469',145405.05,145405.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255841',4875319,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255841',4875320,'3047','469',146290.31,146290.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255841',4875321,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255841',4875322,'3049','469',157013.95,157013.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255841',4875323,'3050','469',144381.14,146922.01,2540.87,419243.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255841',4875324,'3051','469',31999.78,31999.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255841',4875325,'3052','469',139096.89,141574.60,2477.71,408822.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255841',4875326,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255841',4875327,'3054','470',3151.12,3151.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255841',4875328,'3055','470',33368.83,33675.03,306.20,108701.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255941',4876968,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255941',4876969,'3039','469',123752.07,126346.73,2594.66,428118.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255941',4876970,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255941',4876971,'3041','469',130605.28,133721.99,3116.71,514257.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255941',4876972,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255941',4876973,'3043','469',131823.48,134440.82,2617.34,431861.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255941',4876974,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','255941',4876975,'3045','469',145405.05,146689.89,1284.84,211998.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255941',4876976,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255941',4876977,'3047','469',146290.31,146290.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255941',4876978,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255941',4876979,'3049','469',157013.95,157863.18,849.23,140122.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255941',4876980,'3050','469',146922.01,150070.42,3148.41,519487.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255941',4876981,'3051','469',31999.78,31999.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255941',4876982,'3052','469',141574.60,144429.77,2855.17,471103.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','255941',4876983,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255941',4876984,'3054','470',3151.12,3151.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','255941',4876985,'3055','470',33675.03,33870.10,195.07,69249.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256020',4878255,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256020',4878256,'3039','469',126346.73,129165.94,2819.21,465169.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256020',4878257,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256020',4878258,'3041','469',133721.99,135653.18,1931.19,318646.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256020',4878259,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256020',4878260,'3043','469',134440.82,136733.42,2292.60,378279.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256020',4878261,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256020',4878262,'3045','469',146689.89,149259.97,2570.08,424063.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256020',4878263,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256020',4878264,'3047','469',146290.31,146290.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256020',4878265,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256020',4878266,'3049','469',157863.18,160495.00,2631.82,434250.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256020',4878267,'3050','469',150070.42,152195.01,2124.59,350557.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256020',4878268,'3051','469',31999.78,31999.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256020',4878269,'3052','469',144429.77,144429.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256020',4878270,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256020',4878271,'3054','470',3151.12,3151.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256020',4878272,'3055','470',33870.10,34143.63,273.53,97103.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256206',4881197,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256206',4881198,'3039','469',129165.94,133260.74,4094.80,675642.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256206',4881199,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256206',4881200,'3041','469',135653.18,135653.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256206',4881201,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256206',4881202,'3043','469',136733.42,141272.74,4539.32,748987.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256206',4881203,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256206',4881204,'3045','469',149259.97,153142.92,3882.95,640686.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256206',4881205,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256206',4881206,'3047','469',146290.31,146290.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256206',4881207,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256206',4881208,'3049','469',160495.00,160495.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256206',4881209,'3050','469',152195.01,155444.75,3249.74,536207.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256206',4881210,'3051','469',31999.78,32572.33,572.55,94470.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256206',4881211,'3052','469',144429.77,147370.83,2941.06,485274.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256206',4881212,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256206',4881213,'3054','470',3151.12,3151.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256206',4881214,'3055','470',34143.63,34733.42,589.79,209375.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256268',4882014,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256268',4882015,'3039','469',133260.74,136040.06,2779.32,458587.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256268',4882016,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256268',4882017,'3041','469',135653.18,138202.67,2549.49,420665.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256268',4882018,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256268',4882019,'3043','469',141272.74,144266.37,2993.63,493948.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256268',4882020,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256268',4882021,'3045','469',153142.92,156225.68,3082.76,508655.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256268',4882022,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256268',4882023,'3047','469',146290.31,146290.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256268',4882024,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256268',4882025,'3049','469',160495.00,160495.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256268',4882026,'3050','469',155444.75,155444.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256268',4882027,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256268',4882028,'3052','469',147370.83,147370.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256268',4882029,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256268',4882030,'3054','470',3151.12,3151.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256268',4882031,'3055','470',34733.42,35101.71,368.29,130742.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256496',4886137,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256496',4886138,'3039','469',136040.06,136040.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256496',4886139,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256496',4886140,'3041','469',138202.67,138202.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256496',4886141,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256496',4886142,'3043','469',144266.37,144266.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256496',4886143,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256496',4886144,'3045','469',156225.68,156225.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256496',4886145,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256496',4886146,'3047','469',146290.31,146290.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256496',4886147,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256496',4886148,'3049','469',160495.00,160495.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256496',4886149,'3050','469',155444.75,155444.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256496',4886150,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256496',4886151,'3052','469',147370.83,147370.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256496',4886152,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256496',4886153,'3054','470',3151.12,3151.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256496',4886154,'3055','470',35101.71,35321.66,219.95,78082.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256517',4886471,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256517',4886472,'3039','469',136040.06,136040.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256517',4886473,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256517',4886474,'3041','469',138202.67,138202.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256517',4886475,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256517',4886476,'3043','469',144266.37,144266.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256517',4886477,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256517',4886478,'3045','469',156225.68,156225.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256517',4886479,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256517',4886480,'3047','469',146290.31,151437.28,5146.97,849250.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256517',4886481,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256517',4886482,'3049','469',160495.00,165653.59,5158.59,851167.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256517',4886483,'3050','469',155444.75,160014.40,4569.65,753992.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256517',4886484,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256517',4886485,'3052','469',147370.83,152603.37,5232.54,863369.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256517',4886486,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256517',4886487,'3054','470',3151.12,3251.12,100.00,35500.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256517',4886488,'3055','470',35321.66,35466.99,145.33,51592.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256748',4890182,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256748',4890183,'3039','469',136040.06,142089.22,6049.16,998111.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256748',4890184,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256748',4890185,'3041','469',138202.67,145431.27,7228.60,1192719.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256748',4890186,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256748',4890187,'3043','469',144266.37,149871.15,5604.78,924788.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256748',4890188,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256748',4890189,'3045','469',156225.68,162726.03,6500.35,1072557.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256748',4890190,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256748',4890191,'3047','469',151437.28,151437.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256748',4890192,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256748',4890193,'3049','469',165653.59,165653.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256748',4890194,'3050','469',160014.40,160014.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256748',4890195,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256748',4890196,'3052','469',152603.37,152603.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256748',4890197,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256748',4890198,'3054','470',3251.12,3251.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256748',4890199,'3055','470',35466.99,36107.40,640.41,227345.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256784',4890812,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256784',4890813,'3039','469',142089.22,147310.15,5210.93,859803.45,0.00,0.00,10.00,0.00,0.00),('1','203','1026','256784',4890814,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256784',4890815,'3041','469',145431.27,150558.22,5116.95,844296.75,0.00,0.00,10.00,0.00,0.00),('1','203','1026','256784',4890816,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256784',4890817,'3043','469',149871.15,155567.50,5686.35,938247.75,0.00,0.00,10.00,0.00,0.00),('1','203','1026','256784',4890818,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256784',4890819,'3045','469',162726.03,167217.37,4486.34,740246.10,0.00,0.00,5.00,0.00,0.00),('1','203','1027','256784',4890820,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256784',4890821,'3047','469',151437.28,151437.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256784',4890822,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256784',4890823,'3049','469',165653.59,165653.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256784',4890824,'3050','469',160014.40,160014.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256784',4890825,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256784',4890826,'3052','469',152603.37,152603.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256784',4890827,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256784',4890828,'3054','470',3251.12,3251.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256784',4890829,'3055','470',36107.40,36496.55,389.15,138148.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256882',4892761,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256882',4892762,'3039','469',147310.15,150024.51,2704.36,446219.40,0.00,0.00,10.00,0.00,0.00),('1','203','1026','256882',4892763,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256882',4892764,'3041','469',150558.22,152846.02,2277.80,375837.00,0.00,0.00,10.00,0.00,0.00),('1','203','1026','256882',4892765,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256882',4892766,'3043','469',155567.50,158389.49,2811.99,463978.35,0.00,0.00,10.00,0.00,0.00),('1','203','1026','256882',4892767,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','256882',4892768,'3045','469',167217.37,169362.87,2138.54,352859.10,0.00,0.00,6.96,0.00,0.00),('1','203','1027','256882',4892769,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256882',4892770,'3047','469',151437.28,151437.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256882',4892771,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256882',4892772,'3049','469',165653.59,165653.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256882',4892773,'3050','469',160014.40,160014.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256882',4892774,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256882',4892775,'3052','469',152603.37,152603.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','256882',4892776,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256882',4892777,'3054','470',3251.12,3251.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','256882',4892778,'3055','470',36496.55,36793.89,297.34,105555.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257039',4895325,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257039',4895326,'3039','469',150024.51,150024.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257039',4895327,'3040','469',18683.07,18683.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257039',4895328,'3041','469',152846.02,152846.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257039',4895329,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257039',4895330,'3043','469',158389.49,159976.65,1587.16,261881.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257039',4895331,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257039',4895332,'3045','469',169362.87,170142.35,779.48,128614.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257039',4895333,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257039',4895334,'3047','469',151437.28,153892.65,2455.37,405136.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257039',4895335,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257039',4895336,'3049','469',165653.59,168760.32,3106.73,512610.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257039',4895337,'3050','469',160014.40,163334.61,3320.21,547834.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257039',4895338,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257039',4895339,'3052','469',152603.37,155463.00,2859.63,471838.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257039',4895340,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257039',4895341,'3054','470',3251.12,3351.12,100.00,36000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257039',4895342,'3055','470',36793.89,37874.39,1077.50,387900.00,0.00,0.00,3.00,0.00,0.00),('1','203','1026','257407',4902215,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257407',4902216,'3039','469',150024.51,152857.21,2832.70,467395.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257407',4902217,'3040','469',18683.07,21183.07,2500.00,412500.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257407',4902218,'3041','469',152846.02,156416.55,3570.53,589137.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257407',4902219,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257407',4902220,'3043','469',159976.65,159976.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257407',4902221,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257407',4902222,'3045','469',170142.35,172384.64,2242.29,369977.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257407',4902223,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257407',4902224,'3047','469',153892.65,155804.23,1911.58,315410.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257407',4902225,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257407',4902226,'3049','469',168760.32,170805.68,2045.36,337484.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257407',4902227,'3050','469',163334.61,164823.89,1489.28,245731.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257407',4902228,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257407',4902229,'3052','469',155463.00,156980.37,1513.37,249706.05,0.00,0.00,4.00,0.00,0.00),('1','203','1027','257407',4902230,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257407',4902231,'3054','470',3351.12,3351.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257407',4902232,'3055','470',37874.39,38434.20,559.81,201531.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257411',4902330,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257411',4902331,'3039','469',152857.21,155416.21,2559.00,422235.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257411',4902332,'3040','469',21183.07,21183.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257411',4902333,'3041','469',156416.55,156416.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257411',4902334,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257411',4902335,'3043','469',159976.65,159976.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257411',4902336,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257411',4902337,'3045','469',172384.64,177788.57,5383.93,888348.45,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257411',4902338,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257411',4902339,'3047','469',155804.23,160152.99,4348.76,717545.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257411',4902340,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257411',4902341,'3049','469',170805.68,174760.28,3954.60,652509.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257411',4902342,'3050','469',164823.89,167872.29,3048.40,502986.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257411',4902343,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257411',4902344,'3052','469',156980.37,156980.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257411',4902345,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257411',4902346,'3054','470',3351.12,3351.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257411',4902347,'3055','470',38434.20,39063.35,629.15,226494.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257583',4904976,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257583',4904977,'3039','469',155416.21,157519.65,2103.44,347067.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257583',4904978,'3040','469',21183.07,21183.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257583',4904979,'3041','469',156416.55,158923.56,2487.01,410356.65,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257583',4904980,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257583',4904981,'3043','469',159976.65,162109.91,2113.26,348687.90,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257583',4904982,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257583',4904983,'3045','469',177788.57,177788.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257583',4904984,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257583',4904985,'3047','469',160152.99,160152.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257583',4904986,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257583',4904987,'3049','469',174760.28,176489.79,1729.51,285369.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257583',4904988,'3050','469',167872.29,170252.71,2371.42,391284.30,0.00,0.00,9.00,0.00,0.00),('1','203','1027','257583',4904989,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257583',4904990,'3052','469',156980.37,158917.01,1936.64,319545.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257583',4904991,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257583',4904992,'3054','470',3351.12,3451.12,100.00,36000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257583',4904993,'3055','470',39063.35,39171.67,108.32,38995.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257584',4904994,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257584',4904995,'3039','469',157519.65,159862.91,2343.26,386637.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257584',4904996,'3040','469',21183.07,21183.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257584',4904997,'3041','469',158923.56,160782.62,1839.06,303444.90,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257584',4904998,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257584',4904999,'3043','469',162109.91,163788.34,1678.43,276940.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257584',4905000,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257584',4905001,'3045','469',177788.57,177788.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257584',4905002,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257584',4905003,'3047','469',160152.99,161359.47,1196.48,197419.20,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257584',4905004,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257584',4905005,'3049','469',176489.79,180438.16,3948.37,651481.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257584',4905006,'3050','469',170252.71,171935.50,1669.79,275515.35,0.00,0.00,13.00,0.00,0.00),('1','203','1027','257584',4905007,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257584',4905008,'3052','469',158917.01,160393.77,1466.76,242015.40,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257584',4905009,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257584',4905010,'3054','470',3451.12,3451.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257584',4905011,'3055','470',39171.67,39687.11,515.44,185558.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257585',4905012,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257585',4905013,'3039','469',159862.91,159862.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257585',4905014,'3040','469',21183.07,21183.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257585',4905015,'3041','469',160782.62,160782.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257585',4905016,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257585',4905017,'3043','469',163788.34,163788.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257585',4905018,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257585',4905019,'3045','469',177788.57,177788.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257585',4905020,'3046','469',26014.25,26014.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257585',4905021,'3047','469',161359.47,163999.79,2640.32,435652.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257585',4905022,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257585',4905023,'3049','469',180438.16,183679.81,3241.65,534872.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257585',4905024,'3050','469',171935.50,174778.58,2843.08,469108.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257585',4905025,'3051','469',32572.33,32572.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257585',4905026,'3052','469',160393.77,162824.36,2430.59,401047.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257585',4905027,'3053','469',29517.24,29517.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257585',4905028,'3054','470',3451.12,3451.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257585',4905029,'3055','470',39687.11,39965.99,278.88,100396.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257586',4905030,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257586',4905031,'3039','469',159862.91,161137.58,1274.67,210320.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257586',4905032,'3040','469',21183.07,21183.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257586',4905033,'3041','469',160782.62,162311.49,1528.87,252263.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257586',4905034,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257586',4905035,'3043','469',163788.34,164770.60,982.26,162072.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257586',4905036,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257586',4905037,'3045','469',177788.57,178731.54,942.97,155590.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257586',4905038,'3046','469',26014.25,26014.38,0.13,21.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257586',4905039,'3047','469',163999.79,167456.30,3456.51,570324.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257586',4905040,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257586',4905041,'3049','469',183679.81,187221.29,3541.48,584344.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257586',4905042,'3050','469',174778.58,178209.68,3431.10,566131.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257586',4905043,'3051','469',32572.33,32790.60,218.27,36014.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257586',4905044,'3052','469',162824.36,166782.16,3957.80,653037.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257586',4905045,'3053','469',29517.24,29821.80,304.56,50252.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257586',4905046,'3054','470',3451.12,3451.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257586',4905047,'3055','470',39965.99,40676.56,710.57,255805.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257587',4905048,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257587',4905049,'3039','469',161137.58,165033.83,3896.25,642881.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257587',4905050,'3040','469',21183.07,22040.86,857.79,141535.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257587',4905051,'3041','469',162311.49,166482.26,4170.77,688177.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257587',4905052,'3042','469',15172.52,15172.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257587',4905053,'3043','469',164770.60,168714.09,3943.49,650675.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257587',4905054,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257587',4905055,'3045','469',178731.54,182175.23,3443.69,568208.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257587',4905056,'3046','469',26014.38,26014.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257587',4905057,'3047','469',167456.30,167456.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257587',4905058,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257587',4905059,'3049','469',187221.29,187221.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257587',4905060,'3050','469',178209.68,178209.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257587',4905061,'3051','469',32790.60,32790.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257587',4905062,'3052','469',166782.16,166782.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257587',4905063,'3053','469',29821.80,29821.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257587',4905064,'3054','470',3451.12,3551.12,100.00,36000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257587',4905065,'3055','470',40676.56,41039.33,362.77,130597.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257588',4905066,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257588',4905067,'3039','469',165033.83,169526.06,4492.23,741217.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257588',4905068,'3040','469',22040.86,25256.60,3215.74,530597.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257588',4905069,'3041','469',166482.26,169111.33,2629.07,433796.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257588',4905070,'3042','469',15172.52,15801.00,628.48,103699.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257588',4905071,'3043','469',168714.09,173065.49,4331.40,714681.00,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257588',4905072,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257588',4905073,'3045','469',182175.23,187009.70,4834.47,797687.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257588',4905074,'3046','469',26014.38,26014.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257588',4905075,'3047','469',167456.30,167456.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257588',4905076,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257588',4905077,'3049','469',187221.29,187221.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257588',4905078,'3050','469',178209.68,178209.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257588',4905079,'3051','469',32790.60,32790.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257588',4905080,'3052','469',166782.16,166782.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257588',4905081,'3053','469',29821.80,29821.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257588',4905082,'3054','470',3551.12,3551.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257588',4905083,'3055','470',41039.33,41460.60,421.27,151657.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257589',4905084,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257589',4905085,'3039','469',169526.06,171941.40,2415.34,398531.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257589',4905086,'3040','469',25256.60,25256.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257589',4905087,'3041','469',169111.33,170962.44,1851.11,305433.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257589',4905088,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257589',4905089,'3043','469',173065.49,175418.13,2352.64,388185.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257589',4905090,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257589',4905091,'3045','469',187009.70,189145.95,2115.76,349100.40,0.00,0.00,20.49,0.00,0.00),('1','203','1027','257589',4905092,'3046','469',26014.38,26014.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257589',4905093,'3047','469',167456.30,168353.89,897.59,148102.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257589',4905094,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257589',4905095,'3049','469',187221.29,188272.05,1030.21,169984.65,0.00,0.00,20.55,0.00,0.00),('1','203','1027','257589',4905096,'3050','469',178209.68,179200.14,990.46,163425.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257589',4905097,'3051','469',32790.60,32790.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257589',4905098,'3052','469',166782.16,167697.73,894.97,147670.05,0.00,0.00,20.60,0.00,0.00),('1','203','1027','257589',4905099,'3053','469',29821.80,29821.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257589',4905100,'3054','470',3551.12,3551.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257589',4905101,'3055','470',41460.60,41703.82,243.22,87559.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257590',4905102,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257590',4905103,'3039','469',171941.40,171941.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257590',4905104,'3040','469',25256.60,25256.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257590',4905105,'3041','469',170962.44,170962.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257590',4905106,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257590',4905107,'3043','469',175418.13,175418.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257590',4905108,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257590',4905109,'3045','469',189145.95,189145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257590',4905110,'3046','469',26014.38,28878.01,2863.63,472498.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257590',4905111,'3047','469',168353.89,171039.78,2685.89,443171.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257590',4905112,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257590',4905113,'3049','469',188272.05,193290.73,5018.68,828082.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257590',4905114,'3050','469',179200.14,179887.82,687.68,113467.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257590',4905115,'3051','469',32790.60,35470.22,2679.62,442137.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257590',4905116,'3052','469',167697.73,171517.57,3819.84,630273.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257590',4905117,'3053','469',29821.80,29821.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257590',4905118,'3054','470',3551.12,3551.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257590',4905119,'3055','470',41703.82,42117.30,413.48,148852.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257591',4905120,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257591',4905121,'3039','469',171941.40,171941.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257591',4905122,'3040','469',25256.60,25256.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257591',4905123,'3041','469',170962.44,170962.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257591',4905124,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257591',4905125,'3043','469',175418.13,175418.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257591',4905126,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257591',4905127,'3045','469',189145.95,189145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257591',4905128,'3046','469',28878.01,28878.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257591',4905129,'3047','469',171039.78,174258.07,3218.29,531017.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257591',4905130,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257591',4905131,'3049','469',193290.73,196205.88,2915.15,480999.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257591',4905132,'3050','469',179887.82,182151.70,2263.88,373540.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257591',4905133,'3051','469',35470.22,35470.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257591',4905134,'3052','469',171517.57,173550.57,2033.00,335445.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257591',4905135,'3053','469',29821.80,29821.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257591',4905136,'3054','470',3551.12,3651.12,100.00,36000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257591',4905137,'3055','470',42117.30,42448.15,330.85,119106.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257592',4905138,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257592',4905139,'3039','469',171941.40,171941.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257592',4905140,'3040','469',25256.60,25256.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257592',4905141,'3041','469',170962.44,170962.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257592',4905142,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257592',4905143,'3043','469',175418.13,175418.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257592',4905144,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257592',4905145,'3045','469',189145.95,189145.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257592',4905146,'3046','469',28878.01,30782.38,1904.37,314221.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257592',4905147,'3047','469',174258.07,176013.79,1755.72,289693.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257592',4905148,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257592',4905149,'3049','469',196205.88,198928.84,2722.96,449288.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257592',4905150,'3050','469',182151.70,184600.16,2448.46,403995.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257592',4905151,'3051','469',35470.22,35470.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257592',4905152,'3052','469',173550.57,174802.82,1235.13,203796.45,0.00,0.00,17.12,0.00,0.00),('1','203','1027','257592',4905153,'3053','469',29821.80,31582.23,1760.43,290470.95,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257592',4905154,'3054','470',3651.12,3651.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257592',4905155,'3055','470',42448.15,42947.63,499.48,179812.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257593',4905156,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257593',4905157,'3039','469',171941.40,173883.39,1941.99,320428.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257593',4905158,'3040','469',25256.60,26004.65,748.05,123428.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257593',4905159,'3041','469',170962.44,172764.14,1801.70,297280.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257593',4905160,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257593',4905161,'3043','469',175418.13,176961.66,1543.53,254682.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257593',4905162,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257593',4905163,'3045','469',189145.95,191000.69,1854.74,306032.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257593',4905164,'3046','469',30782.38,31530.21,747.83,123391.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257593',4905165,'3047','469',176013.79,177028.70,1014.91,167460.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257593',4905166,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257593',4905167,'3049','469',198928.84,200757.50,1828.66,301728.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257593',4905168,'3050','469',184600.16,185748.65,1148.49,189500.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257593',4905169,'3051','469',35470.22,35470.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257593',4905170,'3052','469',174802.82,176491.71,1688.89,278666.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257593',4905171,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257593',4905172,'3054','470',3651.12,4406.12,755.00,271800.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257593',4905173,'3055','470',42947.63,43245.91,298.28,107380.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257594',4905174,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257594',4905175,'3039','469',173883.39,173883.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257594',4905176,'3040','469',26004.65,26004.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257594',4905177,'3041','469',172764.14,172764.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257594',4905178,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257594',4905179,'3043','469',176961.66,176961.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257594',4905180,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257594',4905181,'3045','469',191000.69,191000.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257594',4905182,'3046','469',31530.21,31530.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257594',4905183,'3047','469',177028.70,177028.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257594',4905184,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257594',4905185,'3049','469',200757.50,200757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257594',4905186,'3050','469',185748.65,185748.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257594',4905187,'3051','469',35470.22,35470.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257594',4905188,'3052','469',176491.71,176491.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257594',4905189,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257594',4905190,'3054','470',4406.12,4406.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257594',4905191,'3055','470',43245.91,43318.40,72.49,26096.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257595',4905192,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257595',4905193,'3039','469',173883.39,179170.84,5287.45,872429.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257595',4905194,'3040','469',26004.65,26886.88,882.23,145567.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257595',4905195,'3041','469',172764.14,176779.66,4015.52,662560.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257595',4905196,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257595',4905197,'3043','469',176961.66,181306.22,4344.56,716852.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257595',4905198,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257595',4905199,'3045','469',191000.69,195629.39,4628.70,763735.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257595',4905200,'3046','469',31530.21,31530.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257595',4905201,'3047','469',177028.70,179635.39,2606.69,430103.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257595',4905202,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257595',4905203,'3049','469',200757.50,200861.11,103.61,17095.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257595',4905204,'3050','469',185748.65,185748.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257595',4905205,'3051','469',35470.22,35470.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257595',4905206,'3052','469',176491.71,176491.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257595',4905207,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257595',4905208,'3054','470',4406.12,4406.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257595',4905209,'3055','470',43318.40,44023.50,705.10,267938.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257596',4905210,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257596',4905211,'3039','469',179170.84,183311.37,4140.53,683187.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257596',4905212,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257596',4905213,'3041','469',176779.66,180973.70,4194.04,692016.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257596',4905214,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257596',4905215,'3043','469',181306.22,184190.01,2883.79,475825.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257596',4905216,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257596',4905217,'3045','469',195629.39,198489.95,2860.56,471992.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257596',4905218,'3046','469',31530.21,31530.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257596',4905219,'3047','469',179635.39,179635.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257596',4905220,'3048','469',36249.63,36249.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257596',4905221,'3049','469',200861.11,204187.02,3325.91,548775.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257596',4905222,'3050','469',185748.65,185748.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257596',4905223,'3051','469',35470.22,35470.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257596',4905224,'3052','469',176491.71,176491.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257596',4905225,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257596',4905226,'3054','470',4406.12,4406.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257596',4905227,'3055','470',44023.50,44887.76,864.26,328418.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257597',4905228,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257597',4905229,'3039','469',183311.37,185430.71,2119.34,349691.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257597',4905230,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257597',4905231,'3041','469',180973.70,182946.23,1972.53,325467.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257597',4905232,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257597',4905233,'3043','469',184190.01,186819.56,2629.55,433875.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257597',4905234,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257597',4905235,'3045','469',198489.95,200754.10,2264.15,373584.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257597',4905236,'3046','469',31530.21,32422.42,892.21,147214.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257597',4905237,'3047','469',179635.39,182417.41,2782.02,459033.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257597',4905238,'3048','469',36249.63,36915.37,665.74,109847.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257597',4905239,'3049','469',204187.02,207709.80,3522.78,581258.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257597',4905240,'3050','469',185748.65,186380.77,632.12,104299.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257597',4905241,'3051','469',35470.22,37104.97,1634.75,269733.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257597',4905242,'3052','469',176491.71,178069.85,1578.14,260393.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257597',4905243,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257597',4905244,'3054','470',4406.12,4406.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257597',4905245,'3055','470',44887.76,45457.02,569.26,216318.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257598',4905246,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257598',4905247,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257598',4905248,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257598',4905249,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257598',4905250,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257598',4905251,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257598',4905252,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257598',4905253,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257598',4905254,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257598',4905255,'3047','469',182417.41,185616.03,3198.62,527772.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257598',4905256,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257598',4905257,'3049','469',207709.80,211327.84,3618.04,596976.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257598',4905258,'3050','469',186380.77,189346.69,2965.92,489376.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257598',4905259,'3051','469',37104.97,37104.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257598',4905260,'3052','469',178069.85,180726.97,2657.12,438424.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257598',4905261,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257598',4905262,'3054','470',4406.12,4406.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257598',4905263,'3055','470',45457.02,45642.81,185.79,70600.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257599',4905264,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257599',4905265,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257599',4905266,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257599',4905267,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257599',4905268,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257599',4905269,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257599',4905270,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257599',4905271,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257599',4905272,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257599',4905273,'3047','469',185616.03,185616.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257599',4905274,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257599',4905275,'3049','469',211327.84,211327.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257599',4905276,'3050','469',189346.69,189346.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257599',4905277,'3051','469',37104.97,37104.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257599',4905278,'3052','469',180726.97,180726.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257599',4905279,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257599',4905280,'3054','470',4406.12,4406.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257599',4905281,'3055','470',45642.81,45748.92,106.11,40321.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257600',4905282,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257600',4905283,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257600',4905284,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257600',4905285,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257600',4905286,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257600',4905287,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257600',4905288,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257600',4905289,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257600',4905290,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257600',4905291,'3047','469',185616.03,186964.05,1348.02,222423.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257600',4905292,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257600',4905293,'3049','469',211327.84,212966.93,1639.09,270449.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257600',4905294,'3050','469',189346.69,190623.41,1276.72,210658.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257600',4905295,'3051','469',37104.97,37104.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257600',4905296,'3052','469',180726.97,181987.16,1260.19,207931.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257600',4905297,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257600',4905298,'3054','470',4406.12,4935.27,529.15,201077.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257600',4905299,'3055','470',45748.92,46180.50,431.58,164000.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257601',4905300,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257601',4905301,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257601',4905302,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257601',4905303,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257601',4905304,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257601',4905305,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257601',4905306,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257601',4905307,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257601',4905308,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257601',4905309,'3047','469',186964.05,190723.24,3759.19,620266.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257601',4905310,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257601',4905311,'3049','469',212966.93,216785.11,3818.18,629999.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257601',4905312,'3050','469',190623.41,194403.33,3759.92,620386.80,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257601',4905313,'3051','469',37104.97,37188.60,83.63,13798.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257601',4905314,'3052','469',181987.16,185131.43,3144.27,518804.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257601',4905315,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257601',4905316,'3054','470',4935.27,4935.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257601',4905317,'3055','470',46180.50,46498.07,317.57,120676.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257602',4905318,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257602',4905319,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257602',4905320,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257602',4905321,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257602',4905322,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257602',4905323,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257602',4905324,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257602',4905325,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257602',4905326,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257602',4905327,'3047','469',190723.24,190723.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257602',4905328,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257602',4905329,'3049','469',216785.11,216785.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257602',4905330,'3050','469',194403.33,194403.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257602',4905331,'3051','469',37188.60,37188.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257602',4905332,'3052','469',185131.43,185131.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257602',4905333,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257602',4905334,'3054','470',4935.27,5014.22,78.95,30001.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257602',4905335,'3055','470',46498.07,46673.09,175.02,66507.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257603',4905336,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257603',4905337,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257603',4905338,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257603',4905339,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257603',4905340,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257603',4905341,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257603',4905342,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257603',4905343,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257603',4905344,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257603',4905345,'3047','469',190723.24,190723.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257603',4905346,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257603',4905347,'3049','469',216785.11,216785.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257603',4905348,'3050','469',194403.33,194403.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257603',4905349,'3051','469',37188.60,37188.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257603',4905350,'3052','469',185131.43,185131.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257603',4905351,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257603',4905352,'3054','470',5014.22,5163.72,149.50,58305.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257603',4905353,'3055','470',46673.09,46680.53,7.44,2901.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257604',4905354,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257604',4905355,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257604',4905356,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257604',4905357,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257604',4905358,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257604',4905359,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257604',4905360,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257604',4905361,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257604',4905362,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257604',4905363,'3047','469',190723.24,190723.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257604',4905364,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257604',4905365,'3049','469',216785.11,216785.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257604',4905366,'3050','469',194403.33,194403.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257604',4905367,'3051','469',37188.60,37188.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257604',4905368,'3052','469',185131.43,185131.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257604',4905369,'3053','469',31582.23,31582.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257604',4905370,'3054','470',5163.72,5220.39,56.67,22101.30,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257604',4905371,'3055','470',46680.53,46834.37,153.84,59997.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257605',4905372,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257605',4905373,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257605',4905374,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257605',4905375,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257605',4905376,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257605',4905377,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257605',4905378,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257605',4905379,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257605',4905380,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257605',4905381,'3047','469',190723.24,190723.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257605',4905382,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257605',4905383,'3049','469',216785.11,216785.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257605',4905384,'3050','469',194403.33,196935.72,2532.39,417844.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257605',4905385,'3051','469',37188.60,37547.74,359.14,59258.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257605',4905386,'3052','469',185131.43,188182.04,3050.61,503350.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257605',4905387,'3053','469',31582.23,32027.85,445.62,73527.30,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257605',4905388,'3054','470',5220.39,5276.67,56.28,21949.20,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257605',4905389,'3055','470',46834.37,47719.59,885.22,345235.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257606',4905390,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257606',4905391,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257606',4905392,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257606',4905393,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257606',4905394,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257606',4905395,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257606',4905396,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257606',4905397,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257606',4905398,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257606',4905399,'3047','469',190723.24,190723.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257606',4905400,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257606',4905401,'3049','469',216785.11,216785.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257606',4905402,'3050','469',196935.72,202929.13,5993.41,988912.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257606',4905403,'3051','469',37547.74,37547.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257606',4905404,'3052','469',188182.04,194690.54,6508.50,1073902.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257606',4905405,'3053','469',32027.85,32027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257606',4905406,'3054','470',5276.67,5276.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257606',4905407,'3055','470',47719.59,48888.31,1168.72,455800.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257607',4905408,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257607',4905409,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257607',4905410,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257607',4905411,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257607',4905412,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257607',4905413,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257607',4905414,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257607',4905415,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257607',4905416,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257607',4905417,'3047','469',190723.24,190723.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257607',4905418,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257607',4905419,'3049','469',216785.11,216785.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257607',4905420,'3050','469',202929.13,207848.29,4919.16,811661.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257607',4905421,'3051','469',37547.74,37547.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257607',4905422,'3052','469',194690.54,199700.18,5009.64,826590.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257607',4905423,'3053','469',32027.85,32027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257607',4905424,'3054','470',5276.67,6535.69,1259.02,491017.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257607',4905425,'3055','470',48888.31,50789.47,1901.16,741452.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257608',4905426,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257608',4905427,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257608',4905428,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257608',4905429,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257608',4905430,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257608',4905431,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257608',4905432,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257608',4905433,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257608',4905434,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257608',4905435,'3047','469',190723.24,190723.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257608',4905436,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257608',4905437,'3049','469',216785.11,216785.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257608',4905438,'3050','469',207848.29,207848.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257608',4905439,'3051','469',37547.74,37547.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257608',4905440,'3052','469',199700.18,199700.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257608',4905441,'3053','469',32027.85,32027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257608',4905442,'3054','470',6535.69,7261.51,725.82,283069.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257608',4905443,'3055','470',50789.47,52147.50,1358.03,529631.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257609',4905444,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257609',4905445,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257609',4905446,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257609',4905447,'3041','469',182946.23,182946.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257609',4905448,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257609',4905449,'3043','469',186819.56,186819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257609',4905450,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257609',4905451,'3045','469',200754.10,200754.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257609',4905452,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257609',4905453,'3047','469',190723.24,190723.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257609',4905454,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257609',4905455,'3049','469',216785.11,216785.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257609',4905456,'3050','469',207848.29,207848.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257609',4905457,'3051','469',37547.74,37547.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257609',4905458,'3052','469',199700.18,199700.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257609',4905459,'3053','469',32027.85,32027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257609',4905460,'3054','470',7261.51,7881.22,619.71,241686.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257609',4905461,'3055','470',52147.50,53023.23,875.73,341534.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257610',4905462,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257610',4905463,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257610',4905464,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257610',4905465,'3041','469',182946.23,184248.39,1302.16,214856.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257610',4905466,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257610',4905467,'3043','469',186819.56,189691.23,2871.67,473825.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257610',4905468,'3044','469',10037.13,10037.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257610',4905469,'3045','469',200754.10,202622.25,1868.15,308244.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257610',4905470,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257610',4905471,'3047','469',190723.24,190723.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257610',4905472,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257610',4905473,'3049','469',216785.11,216785.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257610',4905474,'3050','469',207848.29,209200.64,1352.35,223137.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257610',4905475,'3051','469',37547.74,37547.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257610',4905476,'3052','469',199700.18,199750.33,50.15,8274.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257610',4905477,'3053','469',32027.85,32027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257610',4905478,'3054','470',7881.22,7881.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257610',4905479,'3055','470',53023.23,53023.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257611',4905480,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257611',4905481,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257611',4905482,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257611',4905483,'3041','469',184248.39,190634.61,6376.22,1052076.30,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257611',4905484,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257611',4905485,'3043','469',189691.23,196065.46,6363.23,1049932.95,0.00,0.00,11.00,0.00,0.00),('1','203','1026','257611',4905486,'3044','469',10037.13,10870.37,823.24,135834.60,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257611',4905487,'3045','469',202622.25,202622.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257611',4905488,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257611',4905489,'3047','469',190723.24,190723.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257611',4905490,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257611',4905491,'3049','469',216785.11,216785.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257611',4905492,'3050','469',209200.64,209200.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257611',4905493,'3051','469',37547.74,37547.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257611',4905494,'3052','469',199750.33,199750.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257611',4905495,'3053','469',32027.85,32027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257611',4905496,'3054','470',7881.22,8176.80,270.58,105526.20,0.00,0.00,25.00,0.00,0.00),('1','203','1028','257611',4905497,'3055','470',53023.23,53187.83,144.60,56394.00,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257612',4905498,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257612',4905499,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257612',4905500,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257612',4905501,'3041','469',190634.61,190634.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257612',4905502,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257612',4905503,'3043','469',196065.46,200832.44,4766.98,786551.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257612',4905504,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257612',4905505,'3045','469',202622.25,208235.49,5613.24,926184.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257612',4905506,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257612',4905507,'3047','469',190723.24,195492.69,4769.45,786959.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257612',4905508,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257612',4905509,'3049','469',216785.11,221792.27,5007.16,826181.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257612',4905510,'3050','469',209200.64,214603.31,5402.67,891440.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257612',4905511,'3051','469',37547.74,37547.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257612',4905512,'3052','469',199750.33,199750.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257612',4905513,'3053','469',32027.85,32027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257612',4905514,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257612',4905515,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257613',4905516,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257613',4905517,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257613',4905518,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257613',4905519,'3041','469',190634.61,190634.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257613',4905520,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257613',4905521,'3043','469',200832.44,200832.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257613',4905522,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257613',4905523,'3045','469',208235.49,208235.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257613',4905524,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257613',4905525,'3047','469',195492.69,199074.30,3581.61,590965.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257613',4905526,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257613',4905527,'3049','469',221792.27,225634.32,3842.05,633938.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257613',4905528,'3050','469',214603.31,215655.28,1051.97,173575.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257613',4905529,'3051','469',37547.74,37547.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257613',4905530,'3052','469',199750.33,200466.93,716.60,118239.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257613',4905531,'3053','469',32027.85,32027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257613',4905532,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257613',4905533,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257614',4905534,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257614',4905535,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257614',4905536,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257614',4905537,'3041','469',190634.61,190634.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257614',4905538,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257614',4905539,'3043','469',200832.44,200832.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257614',4905540,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257614',4905541,'3045','469',208235.49,208235.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257614',4905542,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257614',4905543,'3047','469',199074.30,199074.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257614',4905544,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257614',4905545,'3049','469',225634.32,225694.86,60.54,9989.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257614',4905546,'3050','469',215655.28,221105.44,5450.16,899276.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257614',4905547,'3051','469',37547.74,37547.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257614',4905548,'3052','469',200466.93,207018.71,6541.78,1079393.70,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257614',4905549,'3053','469',32027.85,32027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257614',4905550,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257614',4905551,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257615',4905552,'3038','469',9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257615',4905553,'3039','469',185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257615',4905554,'3040','469',26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257615',4905555,'3041','469',190634.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257615',4905556,'3042','469',15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257615',4905557,'3043','469',200832.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257615',4905558,'3044','469',10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257615',4905559,'3045','469',208235.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257615',4905560,'3046','469',32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257615',4905561,'3047','469',199074.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257615',4905562,'3048','469',36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257615',4905563,'3049','469',225694.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257615',4905564,'3050','469',221105.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257615',4905565,'3051','469',37547.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257615',4905566,'3052','469',207018.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257615',4905567,'3053','469',32027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257615',4905568,'3054','470',8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257615',4905569,'3055','470',53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257616',4905570,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257616',4905571,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257616',4905572,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257616',4905573,'3041','469',190634.61,190634.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257616',4905574,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257616',4905575,'3043','469',200832.44,200832.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257616',4905576,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257616',4905577,'3045','469',208235.49,208235.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257616',4905578,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257616',4905579,'3047','469',199074.30,199074.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257616',4905580,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257616',4905581,'3049','469',225694.86,225694.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257616',4905582,'3050','469',221105.44,223800.95,2695.51,444759.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257616',4905583,'3051','469',37547.74,37547.85,0.00,0.00,0.00,0.00,0.11,0.00,0.00),('1','203','1027','257616',4905584,'3052','469',207018.71,209899.53,2880.82,475335.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257616',4905585,'3053','469',32027.85,33165.04,1137.19,187636.35,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257616',4905586,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257616',4905587,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257617',4905588,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257617',4905589,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257617',4905590,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257617',4905591,'3041','469',190634.61,190634.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257617',4905592,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257617',4905593,'3043','469',200832.44,206513.48,5671.04,935721.60,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257617',4905594,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257617',4905595,'3045','469',208235.49,213954.29,5698.80,940302.00,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257617',4905596,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257617',4905597,'3047','469',199074.30,199074.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257617',4905598,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257617',4905599,'3049','469',225694.86,225694.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257617',4905600,'3050','469',223800.95,223800.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257617',4905601,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257617',4905602,'3052','469',209899.53,209899.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257617',4905603,'3053','469',33165.04,33165.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257617',4905604,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257617',4905605,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257618',4905606,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257618',4905607,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257618',4905608,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257618',4905609,'3041','469',190634.61,190634.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257618',4905610,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257618',4905611,'3043','469',206513.48,210999.76,4486.28,740236.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257618',4905612,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257618',4905613,'3045','469',213954.29,218941.97,4987.68,822967.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257618',4905614,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257618',4905615,'3047','469',199074.30,199074.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257618',4905616,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257618',4905617,'3049','469',225694.86,225694.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257618',4905618,'3050','469',223800.95,224238.75,427.80,70587.00,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257618',4905619,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257618',4905620,'3052','469',209899.53,211728.69,1826.16,301316.40,0.00,0.00,3.00,0.00,0.00),('1','203','1027','257618',4905621,'3053','469',33165.04,33544.58,379.54,62624.10,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257618',4905622,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257618',4905623,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257619',4905624,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257619',4905625,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257619',4905626,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257619',4905627,'3041','469',190634.61,190855.83,221.22,36501.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257619',4905628,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257619',4905629,'3043','469',210999.76,215552.95,4553.19,751276.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257619',4905630,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257619',4905631,'3045','469',218941.97,223542.36,4600.39,759064.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257619',4905632,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257619',4905633,'3047','469',199074.30,199074.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257619',4905634,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257619',4905635,'3049','469',225694.86,229519.39,3824.53,631047.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257619',4905636,'3050','469',224238.75,228388.21,4149.46,684660.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257619',4905637,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257619',4905638,'3052','469',211728.69,211728.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257619',4905639,'3053','469',33544.58,33544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257619',4905640,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257619',4905641,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257620',4905642,'3038','469',9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257620',4905643,'3039','469',185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257620',4905644,'3040','469',26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257620',4905645,'3041','469',190855.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257620',4905646,'3042','469',15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257620',4905647,'3043','469',215552.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257620',4905648,'3044','469',10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257620',4905649,'3045','469',223542.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257620',4905650,'3046','469',32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257620',4905651,'3047','469',199074.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257620',4905652,'3048','469',36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257620',4905653,'3049','469',229519.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257620',4905654,'3050','469',228388.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257620',4905655,'3051','469',37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257620',4905656,'3052','469',211728.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257620',4905657,'3053','469',33544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257620',4905658,'3054','470',8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257620',4905659,'3055','470',53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257621',4905660,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257621',4905661,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257621',4905662,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257621',4905663,'3041','469',190855.83,190855.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257621',4905664,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257621',4905665,'3043','469',215552.95,215552.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257621',4905666,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257621',4905667,'3045','469',223542.36,223542.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257621',4905668,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257621',4905669,'3047','469',199074.30,199074.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257621',4905670,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257621',4905671,'3049','469',229519.39,236344.54,6802.15,1122354.75,0.00,0.00,23.00,0.00,0.00),('1','203','1027','257621',4905672,'3050','469',228388.21,234256.84,5848.63,965023.95,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257621',4905673,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257621',4905674,'3052','469',211728.69,213303.66,1554.97,256570.05,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257621',4905675,'3053','469',33544.58,33544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257621',4905676,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257621',4905677,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257622',4905678,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257622',4905679,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257622',4905680,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257622',4905681,'3041','469',190855.83,190855.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257622',4905682,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257622',4905683,'3043','469',215552.95,215552.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257622',4905684,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257622',4905685,'3045','469',223542.36,223542.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257622',4905686,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257622',4905687,'3047','469',199074.30,199074.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257622',4905688,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257622',4905689,'3049','469',236344.54,242330.33,5985.79,987655.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257622',4905690,'3050','469',234256.84,239493.28,5236.44,864012.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257622',4905691,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257622',4905692,'3052','469',213303.66,213303.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257622',4905693,'3053','469',33544.58,33544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257622',4905694,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257622',4905695,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257623',4905696,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257623',4905697,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257623',4905698,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257623',4905699,'3041','469',190855.83,190855.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257623',4905700,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257623',4905701,'3043','469',215552.95,215552.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257623',4905702,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257623',4905703,'3045','469',223542.36,223542.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257623',4905704,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257623',4905705,'3047','469',199074.30,199605.78,521.48,86044.20,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257623',4905706,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257623',4905707,'3049','469',242330.33,247207.78,4867.45,803129.25,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257623',4905708,'3050','469',239493.28,243826.00,4322.72,713248.80,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257623',4905709,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257623',4905710,'3052','469',213303.66,214385.28,1068.62,176322.30,0.00,0.00,13.00,0.00,0.00),('1','203','1027','257623',4905711,'3053','469',33544.58,33544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257623',4905712,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257623',4905713,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257624',4905714,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257624',4905715,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257624',4905716,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257624',4905717,'3041','469',190855.83,190855.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257624',4905718,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257624',4905719,'3043','469',215552.95,219961.88,4408.93,727473.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257624',4905720,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257624',4905721,'3045','469',223542.36,227598.48,4056.12,669259.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257624',4905722,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257624',4905723,'3047','469',199605.78,202333.90,2728.12,450139.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257624',4905724,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257624',4905725,'3049','469',247207.78,247207.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257624',4905726,'3050','469',243826.00,243826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257624',4905727,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257624',4905728,'3052','469',214385.28,216003.71,1618.43,267040.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257624',4905729,'3053','469',33544.58,33544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257624',4905730,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257624',4905731,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257625',4905732,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257625',4905733,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257625',4905734,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257625',4905735,'3041','469',190855.83,193669.53,2813.70,464260.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257625',4905736,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257625',4905737,'3043','469',219961.88,225525.96,5564.08,918073.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257625',4905738,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257625',4905739,'3045','469',227598.48,233554.60,5956.12,982759.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257625',4905740,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257625',4905741,'3047','469',202333.90,202333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257625',4905742,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257625',4905743,'3049','469',247207.78,247207.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257625',4905744,'3050','469',243826.00,243826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257625',4905745,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257625',4905746,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257625',4905747,'3053','469',33544.58,33544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257625',4905748,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257625',4905749,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257626',4905750,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257626',4905751,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257626',4905752,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257626',4905753,'3041','469',193669.53,193669.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257626',4905754,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257626',4905755,'3043','469',225525.96,229306.23,3774.27,622754.55,0.00,0.00,6.00,0.00,0.00),('1','203','1026','257626',4905756,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257626',4905757,'3045','469',233554.60,237360.58,3805.98,627986.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257626',4905758,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257626',4905759,'3047','469',202333.90,202333.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257626',4905760,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257626',4905761,'3049','469',247207.78,247207.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257626',4905762,'3050','469',243826.00,243826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257626',4905763,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257626',4905764,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257626',4905765,'3053','469',33544.58,33544.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257626',4905766,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257626',4905767,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257627',4905768,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257627',4905769,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257627',4905770,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257627',4905771,'3041','469',193669.53,193669.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257627',4905772,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257627',4905773,'3043','469',229306.23,229306.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257627',4905774,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257627',4905775,'3045','469',237360.58,237360.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257627',4905776,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257627',4905777,'3047','469',202333.90,205424.02,3090.12,509869.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257627',4905778,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257627',4905779,'3049','469',247207.78,250819.35,3611.57,595909.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257627',4905780,'3050','469',243826.00,243826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257627',4905781,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257627',4905782,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257627',4905783,'3053','469',33544.58,34590.43,1045.85,172565.25,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257627',4905784,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257627',4905785,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257628',4905786,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257628',4905787,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257628',4905788,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257628',4905789,'3041','469',193669.53,193669.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257628',4905790,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257628',4905791,'3043','469',229306.23,229306.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257628',4905792,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257628',4905793,'3045','469',237360.58,237360.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257628',4905794,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257628',4905795,'3047','469',205424.02,209454.23,4030.21,664984.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257628',4905796,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257628',4905797,'3049','469',250819.35,254566.15,3746.80,618222.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257628',4905798,'3050','469',243826.00,243826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257628',4905799,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257628',4905800,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257628',4905801,'3053','469',34590.43,34590.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257628',4905802,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257628',4905803,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257629',4905804,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257629',4905805,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257629',4905806,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257629',4905807,'3041','469',193669.53,197216.39,3546.86,585231.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257629',4905808,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257629',4905809,'3043','469',229306.23,232519.38,3213.15,530169.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257629',4905810,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257629',4905811,'3045','469',237360.58,240716.11,3355.53,553662.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257629',4905812,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257629',4905813,'3047','469',209454.23,214385.60,4931.37,813676.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257629',4905814,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257629',4905815,'3049','469',254566.15,259309.62,4743.47,782672.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257629',4905816,'3050','469',243826.00,243826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257629',4905817,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257629',4905818,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257629',4905819,'3053','469',34590.43,35701.30,1110.87,183293.55,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257629',4905820,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257629',4905821,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257630',4905822,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257630',4905823,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257630',4905824,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257630',4905825,'3041','469',197216.39,197216.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257630',4905826,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257630',4905827,'3043','469',232519.38,237529.56,5010.18,826679.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257630',4905828,'3044','469',10870.37,10870.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257630',4905829,'3045','469',240716.11,245512.13,4796.02,791343.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257630',4905830,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257630',4905831,'3047','469',214385.60,216022.28,1636.68,270052.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257630',4905832,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257630',4905833,'3049','469',259309.62,261464.16,2154.54,355499.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257630',4905834,'3050','469',243826.00,243826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257630',4905835,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257630',4905836,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257630',4905837,'3053','469',35701.30,35701.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257630',4905838,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257630',4905839,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257631',4905840,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257631',4905841,'3039','469',185430.71,185430.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257631',4905842,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257631',4905843,'3041','469',197216.39,200084.81,2868.42,473289.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257631',4905844,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257631',4905845,'3043','469',237529.56,241020.62,3491.06,576024.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257631',4905846,'3044','469',10870.37,11542.64,672.27,110924.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257631',4905847,'3045','469',245512.13,246723.29,1211.16,199841.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257631',4905848,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257631',4905849,'3047','469',216022.28,216022.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257631',4905850,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257631',4905851,'3049','469',261464.16,261464.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257631',4905852,'3050','469',243826.00,243826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257631',4905853,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257631',4905854,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257631',4905855,'3053','469',35701.30,35701.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257631',4905856,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257631',4905857,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257632',4905858,'3038','469',9298.18,9298.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257632',4905859,'3039','469',185430.71,189562.54,4131.83,681751.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257632',4905860,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257632',4905861,'3041','469',200084.81,202476.72,2391.91,394665.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257632',4905862,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257632',4905863,'3043','469',241020.62,241020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257632',4905864,'3044','469',11542.64,11542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257632',4905865,'3045','469',246723.29,250422.42,3699.13,610356.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257632',4905866,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257632',4905867,'3047','469',216022.28,217925.42,1903.14,314018.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257632',4905868,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257632',4905869,'3049','469',261464.16,263014.42,1550.26,255792.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257632',4905870,'3050','469',243826.00,243826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257632',4905871,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257632',4905872,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257632',4905873,'3053','469',35701.30,35701.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257632',4905874,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257632',4905875,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257633',4905876,'3038','469',9298.18,9298.29,0.00,0.00,0.00,0.00,0.11,0.00,0.00),('1','203','1026','257633',4905877,'3039','469',189562.54,190498.55,936.01,154441.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257633',4905878,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257633',4905879,'3041','469',202476.72,202476.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257633',4905880,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257633',4905881,'3043','469',241020.62,241020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257633',4905882,'3044','469',11542.64,11542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257633',4905883,'3045','469',250422.42,251291.46,869.04,143391.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257633',4905884,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257633',4905885,'3047','469',217925.42,221641.93,3716.51,613224.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257633',4905886,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257633',4905887,'3049','469',263014.42,267920.37,4905.95,809481.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257633',4905888,'3050','469',243826.00,246900.72,3074.72,507328.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257633',4905889,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257633',4905890,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257633',4905891,'3053','469',35701.30,37170.64,1469.34,242441.10,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257633',4905892,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257633',4905893,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257634',4905894,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257634',4905895,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257634',4905896,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257634',4905897,'3041','469',202476.72,202476.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257634',4905898,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257634',4905899,'3043','469',241020.62,241020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257634',4905900,'3044','469',11542.64,11542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257634',4905901,'3045','469',251291.46,251291.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257634',4905902,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257634',4905903,'3047','469',221641.93,221641.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257634',4905904,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257634',4905905,'3049','469',267920.37,272670.78,4750.41,783817.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257634',4905906,'3050','469',246900.72,250925.39,4024.67,664070.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257634',4905907,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257634',4905908,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257634',4905909,'3053','469',37170.64,37170.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257634',4905910,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257634',4905911,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257635',4905912,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257635',4905913,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257635',4905914,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257635',4905915,'3041','469',202476.72,202476.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257635',4905916,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257635',4905917,'3043','469',241020.62,241020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257635',4905918,'3044','469',11542.64,11542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257635',4905919,'3045','469',251291.46,251291.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257635',4905920,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257635',4905921,'3047','469',221641.93,221641.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257635',4905922,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257635',4905923,'3049','469',272670.78,276529.57,3858.79,636700.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257635',4905924,'3050','469',250925.39,254140.99,3215.60,530574.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257635',4905925,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257635',4905926,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257635',4905927,'3053','469',37170.64,39248.91,2078.27,342914.55,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257635',4905928,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257635',4905929,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257636',4905930,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257636',4905931,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257636',4905932,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257636',4905933,'3041','469',202476.72,202476.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257636',4905934,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257636',4905935,'3043','469',241020.62,241020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257636',4905936,'3044','469',11542.64,11542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257636',4905937,'3045','469',251291.46,251291.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257636',4905938,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257636',4905939,'3047','469',221641.93,221641.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257636',4905940,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257636',4905941,'3049','469',276529.57,280681.45,4151.88,685060.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257636',4905942,'3050','469',254140.99,257531.09,3390.10,559366.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257636',4905943,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257636',4905944,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257636',4905945,'3053','469',39248.91,39248.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257636',4905946,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257636',4905947,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257637',4905948,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257637',4905949,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257637',4905950,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257637',4905951,'3041','469',202476.72,202476.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257637',4905952,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257637',4905953,'3043','469',241020.62,241020.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257637',4905954,'3044','469',11542.64,11542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257637',4905955,'3045','469',251291.46,251291.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257637',4905956,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257637',4905957,'3047','469',221641.93,221641.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257637',4905958,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257637',4905959,'3049','469',280681.45,280681.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257637',4905960,'3050','469',257531.09,257531.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257637',4905961,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257637',4905962,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257637',4905963,'3053','469',39248.91,40117.43,833.52,137530.80,0.00,0.00,35.00,0.00,0.00),('1','203','1028','257637',4905964,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257637',4905965,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257638',4905966,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257638',4905967,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257638',4905968,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257638',4905969,'3041','469',202476.72,204025.08,1548.36,255479.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257638',4905970,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257638',4905971,'3043','469',241020.62,242639.76,1619.14,267158.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257638',4905972,'3044','469',11542.64,11542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257638',4905973,'3045','469',251291.46,253065.59,1774.13,292731.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257638',4905974,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257638',4905975,'3047','469',221641.93,221641.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257638',4905976,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257638',4905977,'3049','469',280681.45,280681.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257638',4905978,'3050','469',257531.09,257531.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257638',4905979,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257638',4905980,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257638',4905981,'3053','469',40117.43,40545.22,427.79,70585.35,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257638',4905982,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257638',4905983,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257639',4905984,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257639',4905985,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257639',4905986,'3040','469',26886.88,26886.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257639',4905987,'3041','469',204025.08,204025.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257639',4905988,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257639',4905989,'3043','469',242639.76,245036.99,2397.23,395542.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257639',4905990,'3044','469',11542.64,11542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257639',4905991,'3045','469',253065.59,255434.85,2369.26,390927.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257639',4905992,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257639',4905993,'3047','469',221641.93,221641.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257639',4905994,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257639',4905995,'3049','469',280681.45,280681.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257639',4905996,'3050','469',257531.09,257531.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257639',4905997,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257639',4905998,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257639',4905999,'3053','469',40545.22,40545.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257639',4906000,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257639',4906001,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257640',4906002,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257640',4906003,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257640',4906004,'3040','469',26886.88,27031.97,145.09,23939.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257640',4906005,'3041','469',204025.08,204025.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257640',4906006,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257640',4906007,'3043','469',245036.99,248816.44,3779.45,623609.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257640',4906008,'3044','469',11542.64,11542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257640',4906009,'3045','469',255434.85,259898.65,4463.80,736527.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257640',4906010,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257640',4906011,'3047','469',221641.93,221641.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257640',4906012,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257640',4906013,'3049','469',280681.45,280681.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257640',4906014,'3050','469',257531.09,257531.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257640',4906015,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257640',4906016,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257640',4906017,'3053','469',40545.22,42112.11,1546.89,255236.85,0.00,0.00,20.00,0.00,0.00),('1','203','1028','257640',4906018,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257640',4906019,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257641',4906020,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257641',4906021,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257641',4906022,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257641',4906023,'3041','469',204025.08,206216.19,2191.11,361533.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257641',4906024,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257641',4906025,'3043','469',248816.44,251286.22,2469.78,407513.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257641',4906026,'3044','469',11542.64,11542.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257641',4906027,'3045','469',259898.65,259898.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257641',4906028,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257641',4906029,'3047','469',221641.93,221641.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257641',4906030,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257641',4906031,'3049','469',280681.45,280681.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257641',4906032,'3050','469',257531.09,257531.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257641',4906033,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257641',4906034,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257641',4906035,'3053','469',42112.11,42112.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257641',4906036,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257641',4906037,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257642',4906038,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257642',4906039,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257642',4906040,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257642',4906041,'3041','469',206216.19,208777.19,2561.00,422565.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257642',4906042,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257642',4906043,'3043','469',251286.22,254098.93,2812.71,464097.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257642',4906044,'3044','469',11542.64,13503.74,1953.10,322261.50,0.00,0.00,8.00,0.00,0.00),('1','203','1026','257642',4906045,'3045','469',259898.65,259898.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257642',4906046,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257642',4906047,'3047','469',221641.93,221641.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257642',4906048,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257642',4906049,'3049','469',280681.45,280681.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257642',4906050,'3050','469',257531.09,257531.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257642',4906051,'3051','469',37547.85,37547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257642',4906052,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257642',4906053,'3053','469',42112.11,42112.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257642',4906054,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257642',4906055,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257643',4906056,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257643',4906057,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257643',4906058,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257643',4906059,'3041','469',208777.19,208777.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257643',4906060,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257643',4906061,'3043','469',254098.93,254098.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257643',4906062,'3044','469',13503.74,13503.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257643',4906063,'3045','469',259898.65,259898.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257643',4906064,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257643',4906065,'3047','469',221641.93,221641.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257643',4906066,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257643',4906067,'3049','469',280681.45,286523.51,5842.06,963939.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257643',4906068,'3050','469',257531.09,261968.40,4437.31,732156.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257643',4906069,'3051','469',37547.85,37548.07,0.22,36.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257643',4906070,'3052','469',216003.71,216003.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257643',4906071,'3053','469',42112.11,42112.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257643',4906072,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257643',4906073,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257644',4906074,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257644',4906075,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257644',4906076,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257644',4906077,'3041','469',208777.19,208777.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257644',4906078,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257644',4906079,'3043','469',254098.93,254098.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257644',4906080,'3044','469',13503.74,13503.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257644',4906081,'3045','469',259898.65,259898.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257644',4906082,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257644',4906083,'3047','469',221641.93,224313.08,2671.15,440739.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257644',4906084,'3048','469',36915.37,36915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257644',4906085,'3049','469',286523.51,289733.32,3209.81,529618.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257644',4906086,'3050','469',261968.40,264917.04,2948.64,486525.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257644',4906087,'3051','469',37548.07,37548.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257644',4906088,'3052','469',216003.71,217944.92,1941.21,320299.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257644',4906089,'3053','469',42112.11,42112.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257644',4906090,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257644',4906091,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257645',4906092,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257645',4906093,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257645',4906094,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257645',4906095,'3041','469',208777.19,208777.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257645',4906096,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257645',4906097,'3043','469',254098.93,258197.82,4088.89,674666.85,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257645',4906098,'3044','469',13503.74,13503.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257645',4906099,'3045','469',259898.65,264242.54,4333.89,715091.85,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257645',4906100,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257645',4906101,'3047','469',224313.08,227816.01,3492.93,576333.45,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257645',4906102,'3048','469',36915.37,37192.50,267.13,44076.45,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257645',4906103,'3049','469',289733.32,294111.95,4367.63,720658.95,0.00,0.00,11.00,0.00,0.00),('1','203','1027','257645',4906104,'3050','469',264917.04,268172.72,3255.68,537187.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257645',4906105,'3051','469',37548.07,37548.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257645',4906106,'3052','469',217944.92,218155.68,210.76,34775.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257645',4906107,'3053','469',42112.11,42112.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257645',4906108,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257645',4906109,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257646',4906110,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257646',4906111,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257646',4906112,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257646',4906113,'3041','469',208777.19,208777.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257646',4906114,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257646',4906115,'3043','469',258197.82,259990.37,1792.55,295770.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257646',4906116,'3044','469',13503.74,13503.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257646',4906117,'3045','469',264242.54,266274.95,2032.41,335347.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257646',4906118,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257646',4906119,'3047','469',227816.01,230546.86,2730.85,450590.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257646',4906120,'3048','469',37192.50,37192.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257646',4906121,'3049','469',294111.95,297143.04,3031.09,500129.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257646',4906122,'3050','469',268172.72,270611.72,2439.00,402435.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257646',4906123,'3051','469',37548.07,37548.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257646',4906124,'3052','469',218155.68,220242.17,2086.49,344270.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257646',4906125,'3053','469',42112.11,42112.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257646',4906126,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257646',4906127,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257647',4906128,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257647',4906129,'3039','469',190498.55,190498.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257647',4906130,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257647',4906131,'3041','469',208777.19,208777.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257647',4906132,'3042','469',15801.00,15801.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257647',4906133,'3043','469',259990.37,264524.82,4534.45,748184.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257647',4906134,'3044','469',13503.74,13503.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257647',4906135,'3045','469',266274.95,270226.67,3951.72,652033.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257647',4906136,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257647',4906137,'3047','469',230546.86,230546.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257647',4906138,'3048','469',37192.50,37192.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257647',4906139,'3049','469',297143.04,301337.01,4193.97,692005.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257647',4906140,'3050','469',270611.72,275129.85,4518.13,745491.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257647',4906141,'3051','469',37548.07,37548.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257647',4906142,'3052','469',220242.17,220242.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257647',4906143,'3053','469',42112.11,42112.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257647',4906144,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257647',4906145,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257648',4906146,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257648',4906147,'3039','469',190498.55,190899.73,391.18,64544.70,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257648',4906148,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257648',4906149,'3041','469',208777.19,209130.07,342.88,56575.20,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257648',4906150,'3042','469',15801.00,16398.25,587.25,96896.25,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257648',4906151,'3043','469',264524.82,266718.97,2184.15,360384.75,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257648',4906152,'3044','469',13503.74,13950.09,436.35,71997.75,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257648',4906153,'3045','469',270226.67,271944.60,1707.93,281808.45,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257648',4906154,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257648',4906155,'3047','469',230546.86,230546.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257648',4906156,'3048','469',37192.50,37674.62,472.12,77899.80,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257648',4906157,'3049','469',301337.01,304059.88,2714.57,447904.05,0.00,0.00,8.30,0.00,0.00),('1','203','1027','257648',4906158,'3050','469',275129.85,277735.34,2605.49,429905.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257648',4906159,'3051','469',37548.07,38082.24,534.17,88138.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257648',4906160,'3052','469',220242.17,221371.57,1129.40,186351.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257648',4906161,'3053','469',42112.11,42112.24,0.13,21.45,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257648',4906162,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257648',4906163,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257649',4906164,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257649',4906165,'3039','469',190899.73,190899.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257649',4906166,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257649',4906167,'3041','469',209130.07,209130.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257649',4906168,'3042','469',16398.25,16398.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257649',4906169,'3043','469',266718.97,271067.39,4328.42,714189.30,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257649',4906170,'3044','469',13950.09,13950.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257649',4906171,'3045','469',271944.60,276894.12,4949.52,816670.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257649',4906172,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257649',4906173,'3047','469',230546.86,230546.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257649',4906174,'3048','469',37674.62,37674.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257649',4906175,'3049','469',304059.88,308898.10,4838.22,798306.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257649',4906176,'3050','469',277735.34,282174.66,4439.32,732487.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257649',4906177,'3051','469',38082.24,38082.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257649',4906178,'3052','469',221371.57,221371.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257649',4906179,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257649',4906180,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257649',4906181,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257650',4906182,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257650',4906183,'3039','469',190899.73,190899.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257650',4906184,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257650',4906185,'3041','469',209130.07,209130.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257650',4906186,'3042','469',16398.25,16398.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257650',4906187,'3043','469',271067.39,271472.36,404.97,66820.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257650',4906188,'3044','469',13950.09,13950.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257650',4906189,'3045','469',276894.12,278112.00,1217.88,200950.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257650',4906190,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257650',4906191,'3047','469',230546.86,232086.83,1539.97,254095.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257650',4906192,'3048','469',37674.62,37674.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257650',4906193,'3049','469',308898.10,311015.92,2117.82,349440.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257650',4906194,'3050','469',282174.66,283555.17,1374.51,226794.15,0.00,0.00,6.00,0.00,0.00),('1','203','1027','257650',4906195,'3051','469',38082.24,38082.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257650',4906196,'3052','469',221371.57,223126.07,1754.50,289492.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257650',4906197,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257650',4906198,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257650',4906199,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257651',4906200,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257651',4906201,'3039','469',190899.73,190899.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257651',4906202,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257651',4906203,'3041','469',209130.07,212169.34,3039.27,501479.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257651',4906204,'3042','469',16398.25,16398.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257651',4906205,'3043','469',271472.36,275323.82,3851.46,635490.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257651',4906206,'3044','469',13950.09,13950.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257651',4906207,'3045','469',278112.00,278798.54,686.54,113279.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257651',4906208,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257651',4906209,'3047','469',232086.83,232086.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257651',4906210,'3048','469',37674.62,37674.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257651',4906211,'3049','469',311015.92,311015.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257651',4906212,'3050','469',283555.17,283555.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257651',4906213,'3051','469',38082.24,38082.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257651',4906214,'3052','469',223126.07,223126.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257651',4906215,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257651',4906216,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257651',4906217,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257652',4906218,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257652',4906219,'3039','469',190899.73,190899.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257652',4906220,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257652',4906221,'3041','469',212169.34,213711.96,1542.62,254532.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257652',4906222,'3042','469',16398.25,16398.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257652',4906223,'3043','469',275323.82,276868.97,1545.15,254949.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257652',4906224,'3044','469',13950.09,13950.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257652',4906225,'3045','469',278798.54,281006.99,2208.45,364394.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257652',4906226,'3046','469',32422.42,32422.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257652',4906227,'3047','469',232086.83,232086.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257652',4906228,'3048','469',37674.62,37674.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257652',4906229,'3049','469',311015.92,311913.19,897.27,148049.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257652',4906230,'3050','469',283555.17,287097.61,3542.44,584502.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257652',4906231,'3051','469',38082.24,38082.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257652',4906232,'3052','469',223126.07,224394.49,1268.42,209289.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257652',4906233,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257652',4906234,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257652',4906235,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257653',4906236,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257653',4906237,'3039','469',190899.73,190899.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257653',4906238,'3040','469',27031.97,27031.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257653',4906239,'3041','469',213711.96,213711.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257653',4906240,'3042','469',16398.25,16398.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257653',4906241,'3043','469',276868.97,276868.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257653',4906242,'3044','469',13950.09,13950.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257653',4906243,'3045','469',281006.99,281006.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257653',4906244,'3046','469',32422.42,32422.79,0.37,61.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257653',4906245,'3047','469',232086.83,234373.57,2286.74,377312.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257653',4906246,'3048','469',37674.62,37674.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257653',4906247,'3049','469',311913.19,315455.88,3542.69,584543.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257653',4906248,'3050','469',287097.61,290095.61,2998.00,494670.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257653',4906249,'3051','469',38082.24,38082.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257653',4906250,'3052','469',224394.49,224394.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257653',4906251,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257653',4906252,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257653',4906253,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257654',4906254,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257654',4906255,'3039','469',190899.73,190899.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257654',4906256,'3040','469',27031.97,28389.26,1347.29,222302.85,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257654',4906257,'3041','469',213711.96,214406.59,684.63,112963.95,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257654',4906258,'3042','469',16398.25,18003.38,1595.13,263196.45,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257654',4906259,'3043','469',276868.97,278499.23,1620.26,267342.90,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257654',4906260,'3044','469',13950.09,13959.41,-0.68,-112.20,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257654',4906261,'3045','469',281006.99,282516.75,1505.26,248367.90,0.00,0.00,4.50,0.00,0.00),('1','203','1027','257654',4906262,'3046','469',32422.79,33092.69,669.90,110533.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257654',4906263,'3047','469',234373.57,235072.22,698.65,115277.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257654',4906264,'3048','469',37674.62,38290.16,615.54,101564.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257654',4906265,'3049','469',315455.88,316320.63,864.75,142683.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257654',4906266,'3050','469',290095.61,290653.63,558.02,92073.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257654',4906267,'3051','469',38082.24,38665.19,582.95,96186.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257654',4906268,'3052','469',224394.49,225899.07,1504.58,248255.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257654',4906269,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257654',4906270,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257654',4906271,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257655',4906272,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257655',4906273,'3039','469',190899.73,190899.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257655',4906274,'3040','469',28389.26,28389.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257655',4906275,'3041','469',214406.59,218692.31,4285.72,707143.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257655',4906276,'3042','469',18003.38,18003.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257655',4906277,'3043','469',278499.23,282356.34,3857.11,636423.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257655',4906278,'3044','469',13959.41,13959.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257655',4906279,'3045','469',282516.75,285516.35,2999.60,494934.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257655',4906280,'3046','469',33092.69,33092.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257655',4906281,'3047','469',235072.22,235072.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257655',4906282,'3048','469',38290.16,38290.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257655',4906283,'3049','469',316320.63,320097.65,3777.02,623208.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257655',4906284,'3050','469',290653.63,294538.27,3884.64,640965.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257655',4906285,'3051','469',38665.19,38665.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257655',4906286,'3052','469',225899.07,225899.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257655',4906287,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257655',4906288,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257655',4906289,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257656',4906290,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257656',4906291,'3039','469',190899.73,191676.48,776.75,128163.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257656',4906292,'3040','469',28389.26,29095.78,706.52,116575.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257656',4906293,'3041','469',218692.31,220365.80,1673.49,276125.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257656',4906294,'3042','469',18003.38,18159.27,155.89,25721.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257656',4906295,'3043','469',282356.34,284427.31,2070.97,341710.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257656',4906296,'3044','469',13959.41,14486.01,526.60,86889.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257656',4906297,'3045','469',285516.35,287023.06,1506.71,248607.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257656',4906298,'3046','469',33092.69,33092.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257656',4906299,'3047','469',235072.22,237915.18,2842.96,469088.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257656',4906300,'3048','469',38290.16,40315.81,2025.65,334232.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257656',4906301,'3049','469',320097.65,323415.44,3317.79,547435.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257656',4906302,'3050','469',294538.27,297434.43,2896.16,477866.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257656',4906303,'3051','469',38665.19,40318.85,1653.66,272853.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257656',4906304,'3052','469',225899.07,227333.72,1414.65,233417.25,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257656',4906305,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257656',4906306,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257656',4906307,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257657',4906308,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257657',4906309,'3039','469',191676.48,191676.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257657',4906310,'3040','469',29095.78,29095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257657',4906311,'3041','469',220365.80,223857.01,3491.21,576049.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257657',4906312,'3042','469',18159.27,18159.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257657',4906313,'3043','469',284427.31,287604.24,3176.93,524193.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257657',4906314,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257657',4906315,'3045','469',287023.06,289428.48,2405.42,396894.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257657',4906316,'3046','469',33092.69,34344.73,1252.04,206586.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257657',4906317,'3047','469',237915.18,241152.07,3236.89,534086.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257657',4906318,'3048','469',40315.81,41666.29,1350.48,222829.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257657',4906319,'3049','469',323415.44,327624.14,4208.70,694435.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257657',4906320,'3050','469',297434.43,300326.33,2891.90,477163.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257657',4906321,'3051','469',40318.85,43692.82,3373.97,556705.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257657',4906322,'3052','469',227333.72,227333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257657',4906323,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257657',4906324,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257657',4906325,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257658',4906326,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257658',4906327,'3039','469',191676.48,191676.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257658',4906328,'3040','469',29095.78,29095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257658',4906329,'3041','469',223857.01,225644.94,1777.93,293358.45,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257658',4906330,'3042','469',18159.27,18159.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257658',4906331,'3043','469',287604.24,292552.99,4928.75,813243.75,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257658',4906332,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257658',4906333,'3045','469',289428.48,294789.12,5340.64,881205.60,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257658',4906334,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257658',4906335,'3047','469',241152.07,242894.00,1731.93,285768.45,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257658',4906336,'3048','469',41666.29,41666.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257658',4906337,'3049','469',327624.14,330107.46,2473.32,408097.80,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257658',4906338,'3050','469',300326.33,301948.10,1611.77,265942.05,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257658',4906339,'3051','469',43692.82,43692.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257658',4906340,'3052','469',227333.72,228461.84,1118.12,184489.80,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257658',4906341,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257658',4906342,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257658',4906343,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257659',4906344,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257659',4906345,'3039','469',191676.48,196704.03,5027.55,829545.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257659',4906346,'3040','469',29095.78,29095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257659',4906347,'3041','469',225644.94,230433.22,4788.28,790066.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257659',4906348,'3042','469',18159.27,18159.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257659',4906349,'3043','469',292552.99,297084.13,4531.14,747638.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257659',4906350,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257659',4906351,'3045','469',294789.12,294789.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257659',4906352,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257659',4906353,'3047','469',242894.00,242894.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257659',4906354,'3048','469',41666.29,41666.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257659',4906355,'3049','469',330107.46,330107.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257659',4906356,'3050','469',301948.10,301948.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257659',4906357,'3051','469',43692.82,43692.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257659',4906358,'3052','469',228461.84,228461.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257659',4906359,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257659',4906360,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257659',4906361,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257660',4906362,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257660',4906363,'3039','469',196704.03,200788.77,4084.74,673982.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257660',4906364,'3040','469',29095.78,29095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257660',4906365,'3041','469',230433.22,235236.56,4803.34,792551.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257660',4906366,'3042','469',18159.27,18159.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257660',4906367,'3043','469',297084.13,300915.13,3831.00,632115.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257660',4906368,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257660',4906369,'3045','469',294789.12,295246.84,457.72,75523.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257660',4906370,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257660',4906371,'3047','469',242894.00,242894.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257660',4906372,'3048','469',41666.29,41666.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257660',4906373,'3049','469',330107.46,330107.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257660',4906374,'3050','469',301948.10,301948.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257660',4906375,'3051','469',43692.82,43692.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257660',4906376,'3052','469',228461.84,228461.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257660',4906377,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257660',4906378,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257660',4906379,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257661',4906380,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257661',4906381,'3039','469',200788.77,200788.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257661',4906382,'3040','469',29095.78,29095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257661',4906383,'3041','469',235236.56,235236.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257661',4906384,'3042','469',18159.27,18159.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257661',4906385,'3043','469',300915.13,305154.66,4239.53,699522.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257661',4906386,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257661',4906387,'3045','469',295246.84,299980.03,4733.19,780976.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257661',4906388,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257661',4906389,'3047','469',242894.00,247451.66,4557.66,752013.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257661',4906390,'3048','469',41666.29,41666.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257661',4906391,'3049','469',330107.46,334809.67,4702.21,775864.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257661',4906392,'3050','469',301948.10,306592.15,4644.05,766268.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257661',4906393,'3051','469',43692.82,43692.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257661',4906394,'3052','469',228461.84,228461.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257661',4906395,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257661',4906396,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257661',4906397,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257662',4906398,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257662',4906399,'3039','469',200788.77,201716.83,918.06,151479.90,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257662',4906400,'3040','469',29095.78,29095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257662',4906401,'3041','469',235236.56,236202.69,956.13,157761.45,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257662',4906402,'3042','469',18159.27,18159.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257662',4906403,'3043','469',305154.66,307368.07,2203.41,363562.65,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257662',4906404,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257662',4906405,'3045','469',299980.03,302391.28,2401.25,396206.25,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257662',4906406,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257662',4906407,'3047','469',247451.66,251283.27,3821.61,630565.65,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257662',4906408,'3048','469',41666.29,41666.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257662',4906409,'3049','469',334809.67,338717.25,3907.58,644750.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257662',4906410,'3050','469',306592.15,310767.43,4175.28,688921.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257662',4906411,'3051','469',43692.82,43692.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257662',4906412,'3052','469',228461.84,232597.40,4135.56,682367.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257662',4906413,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257662',4906414,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257662',4906415,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257663',4906416,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257663',4906417,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257663',4906418,'3040','469',29095.78,29095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257663',4906419,'3041','469',236202.69,239099.48,2896.79,477970.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257663',4906420,'3042','469',18159.27,18159.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257663',4906421,'3043','469',307368.07,311721.98,4353.91,718395.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257663',4906422,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257663',4906423,'3045','469',302391.28,306505.10,4113.82,678780.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257663',4906424,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257663',4906425,'3047','469',251283.27,254473.26,3189.99,526348.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257663',4906426,'3048','469',41666.29,41666.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257663',4906427,'3049','469',338717.25,342771.37,4054.12,668929.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257663',4906428,'3050','469',310767.43,314515.93,3748.50,618502.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257663',4906429,'3051','469',43692.82,43692.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257663',4906430,'3052','469',232597.40,232597.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257663',4906431,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257663',4906432,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257663',4906433,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257664',4906434,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257664',4906435,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257664',4906436,'3040','469',29095.78,30483.41,1387.63,228958.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257664',4906437,'3041','469',239099.48,242412.72,3313.24,546684.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257664',4906438,'3042','469',18159.27,19078.92,919.65,151742.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257664',4906439,'3043','469',311721.98,316283.47,4561.49,752645.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257664',4906440,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257664',4906441,'3045','469',306505.10,311742.84,5232.74,863402.10,0.00,0.00,5.00,0.00,0.00),('1','203','1027','257664',4906442,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257664',4906443,'3047','469',254473.26,254473.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257664',4906444,'3048','469',41666.29,42197.01,530.72,87568.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257664',4906445,'3049','469',342771.37,342771.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257664',4906446,'3050','469',314515.93,314515.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257664',4906447,'3051','469',43692.82,44217.70,524.88,86605.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257664',4906448,'3052','469',232597.40,232597.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257664',4906449,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257664',4906450,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257664',4906451,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257665',4906452,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257665',4906453,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257665',4906454,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257665',4906455,'3041','469',242412.72,242924.20,496.48,81919.20,0.00,0.00,15.00,0.00,0.00),('1','203','1026','257665',4906456,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257665',4906457,'3043','469',316283.47,317048.95,750.48,123829.20,0.00,0.00,15.00,0.00,0.00),('1','203','1026','257665',4906458,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257665',4906459,'3045','469',311742.84,312945.21,1193.37,196906.05,0.00,0.00,9.00,0.00,0.00),('1','203','1027','257665',4906460,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257665',4906461,'3047','469',254473.26,254473.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257665',4906462,'3048','469',42197.01,42197.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257665',4906463,'3049','469',342771.37,342771.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257665',4906464,'3050','469',314515.93,314515.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257665',4906465,'3051','469',44217.70,44217.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257665',4906466,'3052','469',232597.40,232597.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257665',4906467,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257665',4906468,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257665',4906469,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257666',4906470,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257666',4906471,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257666',4906472,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257666',4906473,'3041','469',242924.20,242924.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257666',4906474,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257666',4906475,'3043','469',317048.95,320172.46,3123.51,515379.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257666',4906476,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257666',4906477,'3045','469',312945.21,316268.91,3323.70,548410.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257666',4906478,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257666',4906479,'3047','469',254473.26,254473.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257666',4906480,'3048','469',42197.01,42197.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257666',4906481,'3049','469',342771.37,345844.28,3072.91,507030.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257666',4906482,'3050','469',314515.93,317978.47,3462.54,571319.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257666',4906483,'3051','469',44217.70,44217.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257666',4906484,'3052','469',232597.40,233477.99,880.59,145297.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257666',4906485,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257666',4906486,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257666',4906487,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257667',4906488,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257667',4906489,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257667',4906490,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257667',4906491,'3041','469',242924.20,242924.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257667',4906492,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257667',4906493,'3043','469',320172.46,324498.33,4325.87,713768.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257667',4906494,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257667',4906495,'3045','469',316268.91,320600.35,4331.44,714687.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257667',4906496,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257667',4906497,'3047','469',254473.26,254473.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257667',4906498,'3048','469',42197.01,42197.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257667',4906499,'3049','469',345844.28,351765.37,5921.09,976979.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257667',4906500,'3050','469',317978.47,322819.03,4840.56,798692.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257667',4906501,'3051','469',44217.70,44217.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257667',4906502,'3052','469',233477.99,233477.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257667',4906503,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257667',4906504,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257667',4906505,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257668',4906506,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257668',4906507,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257668',4906508,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257668',4906509,'3041','469',242924.20,242924.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257668',4906510,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257668',4906511,'3043','469',324498.33,324498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257668',4906512,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257668',4906513,'3045','469',320600.35,322128.00,1517.65,250412.25,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257668',4906514,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257668',4906515,'3047','469',254473.26,257512.79,3029.53,499872.45,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257668',4906516,'3048','469',42197.01,42197.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257668',4906517,'3049','469',351765.37,355925.61,4150.24,684789.60,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257668',4906518,'3050','469',322819.03,326578.52,3759.49,620315.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257668',4906519,'3051','469',44217.70,44217.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257668',4906520,'3052','469',233477.99,234624.44,1146.45,189164.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257668',4906521,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257668',4906522,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257668',4906523,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257669',4906524,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257669',4906525,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257669',4906526,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257669',4906527,'3041','469',242924.20,242924.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257669',4906528,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257669',4906529,'3043','469',324498.33,330143.94,5645.61,931525.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257669',4906530,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257669',4906531,'3045','469',322128.00,327838.52,5710.52,942235.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257669',4906532,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257669',4906533,'3047','469',257512.79,257512.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257669',4906534,'3048','469',42197.01,42197.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257669',4906535,'3049','469',355925.61,361893.61,5968.00,984720.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257669',4906536,'3050','469',326578.52,331141.48,4562.96,752888.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257669',4906537,'3051','469',44217.70,44217.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257669',4906538,'3052','469',234624.44,234624.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257669',4906539,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257669',4906540,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257669',4906541,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257670',4906542,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257670',4906543,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257670',4906544,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257670',4906545,'3041','469',242924.20,242924.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257670',4906546,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257670',4906547,'3043','469',330143.94,336733.85,6589.91,1087335.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257670',4906548,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257670',4906549,'3045','469',327838.52,334414.80,6566.28,1083436.20,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257670',4906550,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257670',4906551,'3047','469',257512.79,257512.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257670',4906552,'3048','469',42197.01,43318.56,1111.55,183405.75,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257670',4906553,'3049','469',361893.61,361893.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257670',4906554,'3050','469',331141.48,331917.75,776.27,128084.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257670',4906555,'3051','469',44217.70,44217.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257670',4906556,'3052','469',234624.44,236562.30,1937.86,319746.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257670',4906557,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257670',4906558,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257670',4906559,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257671',4906560,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257671',4906561,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257671',4906562,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257671',4906563,'3041','469',242924.20,242924.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257671',4906564,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257671',4906565,'3043','469',336733.85,338680.25,1938.20,319803.00,0.00,0.00,8.20,0.00,0.00),('1','203','1026','257671',4906566,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257671',4906567,'3045','469',334414.80,336892.31,2467.51,407139.15,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257671',4906568,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257671',4906569,'3047','469',257512.79,257512.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257671',4906570,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257671',4906571,'3049','469',361893.61,364416.19,2522.58,416225.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257671',4906572,'3050','469',331917.75,334248.92,2331.17,384643.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257671',4906573,'3051','469',44217.70,44217.80,0.10,16.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257671',4906574,'3052','469',236562.30,237050.68,488.38,80582.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257671',4906575,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257671',4906576,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257671',4906577,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257672',4906578,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257672',4906579,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257672',4906580,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257672',4906581,'3041','469',242924.20,242924.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257672',4906582,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257672',4906583,'3043','469',338680.25,343875.42,5195.17,857203.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257672',4906584,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257672',4906585,'3045','469',336892.31,341324.95,4432.64,731385.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257672',4906586,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257672',4906587,'3047','469',257512.79,263834.49,6321.70,1043080.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257672',4906588,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257672',4906589,'3049','469',364416.19,368871.35,4455.16,735101.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257672',4906590,'3050','469',334248.92,338278.07,4029.15,664809.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257672',4906591,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257672',4906592,'3052','469',237050.68,237050.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257672',4906593,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257672',4906594,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257672',4906595,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257673',4906596,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257673',4906597,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257673',4906598,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257673',4906599,'3041','469',242924.20,242924.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257673',4906600,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257673',4906601,'3043','469',343875.42,347124.49,3249.07,536096.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257673',4906602,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257673',4906603,'3045','469',341324.95,344837.02,3512.07,579491.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257673',4906604,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257673',4906605,'3047','469',263834.49,266630.91,2796.42,461409.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257673',4906606,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257673',4906607,'3049','469',368871.35,372448.45,3577.10,590221.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257673',4906608,'3050','469',338278.07,341234.17,2956.10,487756.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257673',4906609,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257673',4906610,'3052','469',237050.68,239804.36,2753.68,454357.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257673',4906611,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257673',4906612,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257673',4906613,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257674',4906614,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257674',4906615,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257674',4906616,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257674',4906617,'3041','469',242924.20,244848.28,1914.08,315823.20,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257674',4906618,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257674',4906619,'3043','469',347124.49,349140.61,2006.12,331009.80,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257674',4906620,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257674',4906621,'3045','469',344837.02,346586.98,1739.96,287093.40,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257674',4906622,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257674',4906623,'3047','469',266630.91,268447.16,1805.25,297866.25,0.00,0.00,11.00,0.00,0.00),('1','203','1027','257674',4906624,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257674',4906625,'3049','469',372448.45,374691.92,2243.47,370172.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257674',4906626,'3050','469',341234.17,343006.81,1772.64,292485.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257674',4906627,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257674',4906628,'3052','469',239804.36,240982.39,1178.03,194374.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257674',4906629,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257674',4906630,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257674',4906631,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257675',4906632,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257675',4906633,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257675',4906634,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257675',4906635,'3041','469',244848.28,244848.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257675',4906636,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257675',4906637,'3043','469',349140.61,353798.81,4653.20,767778.00,0.00,0.00,5.00,0.00,0.00),('1','203','1026','257675',4906638,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257675',4906639,'3045','469',346586.98,351206.21,4619.23,762172.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257675',4906640,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257675',4906641,'3047','469',268447.16,273184.14,4736.98,781601.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257675',4906642,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257675',4906643,'3049','469',374691.92,380056.98,5365.06,885234.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257675',4906644,'3050','469',343006.81,347281.43,4274.62,705312.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257675',4906645,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257675',4906646,'3052','469',240982.39,240982.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257675',4906647,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257675',4906648,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257675',4906649,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257676',4906650,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257676',4906651,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257676',4906652,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257676',4906653,'3041','469',244848.28,244848.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257676',4906654,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257676',4906655,'3043','469',353798.81,355558.86,1760.05,290408.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257676',4906656,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257676',4906657,'3045','469',351206.21,353160.20,1953.99,322408.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257676',4906658,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257676',4906659,'3047','469',273184.14,273869.71,685.57,113119.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257676',4906660,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257676',4906661,'3049','469',380056.98,380871.71,814.73,134430.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257676',4906662,'3050','469',347281.43,348115.45,834.02,137613.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257676',4906663,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257676',4906664,'3052','469',240982.39,244677.28,3694.89,609656.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257676',4906665,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257676',4906666,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257676',4906667,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257677',4906668,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257677',4906669,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257677',4906670,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257677',4906671,'3041','469',244848.28,249455.69,4607.41,760222.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257677',4906672,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257677',4906673,'3043','469',355558.86,361213.23,5654.37,932971.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257677',4906674,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257677',4906675,'3045','469',353160.20,358307.79,5147.59,849352.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257677',4906676,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257677',4906677,'3047','469',273869.71,273869.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257677',4906678,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257677',4906679,'3049','469',380871.71,380871.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257677',4906680,'3050','469',348115.45,348115.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257677',4906681,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257677',4906682,'3052','469',244677.28,244677.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257677',4906683,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257677',4906684,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257677',4906685,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257678',4906686,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257678',4906687,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257678',4906688,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257678',4906689,'3041','469',249455.69,252821.18,3355.49,553655.85,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257678',4906690,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257678',4906691,'3043','469',361213.23,365099.89,3876.66,639648.90,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257678',4906692,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257678',4906693,'3045','469',358307.79,362162.11,3844.32,634312.80,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257678',4906694,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257678',4906695,'3047','469',273869.71,273869.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257678',4906696,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257678',4906697,'3049','469',380871.71,380871.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257678',4906698,'3050','469',348115.45,348115.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257678',4906699,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257678',4906700,'3052','469',244677.28,246061.14,1383.86,228336.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257678',4906701,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257678',4906702,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257678',4906703,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257679',4906704,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257679',4906705,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257679',4906706,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257679',4906707,'3041','469',252821.18,252821.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257679',4906708,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257679',4906709,'3043','469',365099.89,371478.57,6368.68,1050832.20,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257679',4906710,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257679',4906711,'3045','469',362162.11,368320.16,6148.05,1014428.25,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257679',4906712,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257679',4906713,'3047','469',273869.71,273869.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257679',4906714,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257679',4906715,'3049','469',380871.71,380871.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257679',4906716,'3050','469',348115.45,348115.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257679',4906717,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257679',4906718,'3052','469',246061.14,247646.65,1577.51,260289.15,0.00,0.00,8.00,0.00,0.00),('1','203','1027','257679',4906719,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257679',4906720,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257679',4906721,'3055','470',53187.83,53187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257680',4906722,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257680',4906723,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257680',4906724,'3040','469',30483.41,30483.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257680',4906725,'3041','469',252821.18,258433.35,5612.17,926008.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257680',4906726,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257680',4906727,'3043','469',371478.57,377205.12,5726.55,944880.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257680',4906728,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257680',4906729,'3045','469',368320.16,368320.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257680',4906730,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257680',4906731,'3047','469',273869.71,273869.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257680',4906732,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257680',4906733,'3049','469',380871.71,380871.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257680',4906734,'3050','469',348115.45,348115.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257680',4906735,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257680',4906736,'3052','469',247646.65,247646.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257680',4906737,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257680',4906738,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257680',4906739,'3055','470',53187.83,53297.93,110.10,74868.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257681',4906740,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257681',4906741,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257681',4906742,'3040','469',30483.41,30751.07,267.66,44163.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257681',4906743,'3041','469',258433.35,259806.87,1373.52,226630.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257681',4906744,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257681',4906745,'3043','469',377205.12,378505.61,1295.49,213755.85,0.00,0.00,5.00,0.00,0.00),('1','203','1026','257681',4906746,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257681',4906747,'3045','469',368320.16,371010.19,2680.03,442204.95,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257681',4906748,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257681',4906749,'3047','469',273869.71,273869.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257681',4906750,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257681',4906751,'3049','469',380871.71,380871.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257681',4906752,'3050','469',348115.45,348115.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257681',4906753,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257681',4906754,'3052','469',247646.65,247646.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257681',4906755,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257681',4906756,'3054','470',8176.80,8176.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257681',4906757,'3055','470',53297.93,53706.55,408.62,277861.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257682',4906758,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257682',4906759,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257682',4906760,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257682',4906761,'3041','469',259806.87,259806.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257682',4906762,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257682',4906763,'3043','469',378505.61,378505.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257682',4906764,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257682',4906765,'3045','469',371010.19,371761.33,741.14,122288.10,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257682',4906766,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257682',4906767,'3047','469',273869.71,277397.52,3517.81,580438.65,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257682',4906768,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257682',4906769,'3049','469',380871.71,385466.23,4591.52,757600.80,0.00,0.00,3.00,0.00,0.00),('1','203','1027','257682',4906770,'3050','469',348115.45,352325.81,4210.36,694709.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257682',4906771,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257682',4906772,'3052','469',247646.65,249034.71,1388.06,229029.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257682',4906773,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257682',4906774,'3054','470',8176.80,8244.44,64.39,43785.20,0.00,0.00,3.25,0.00,0.00),('1','203','1028','257682',4906775,'3055','470',53706.55,54749.61,1033.06,702480.80,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257683',4906776,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257683',4906777,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257683',4906778,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257683',4906779,'3041','469',259806.87,259806.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257683',4906780,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257683',4906781,'3043','469',378505.61,378505.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257683',4906782,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257683',4906783,'3045','469',371761.33,371761.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257683',4906784,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257683',4906785,'3047','469',277397.52,281815.12,4417.60,728904.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257683',4906786,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257683',4906787,'3049','469',385466.23,390510.50,5044.27,832304.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257683',4906788,'3050','469',352325.81,357347.45,5021.64,828570.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257683',4906789,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257683',4906790,'3052','469',249034.71,249034.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257683',4906791,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257683',4906792,'3054','470',8244.44,8344.44,100.00,68000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257683',4906793,'3055','470',54749.61,55274.41,524.80,356864.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257684',4906794,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257684',4906795,'3039','469',201716.83,201716.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257684',4906796,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257684',4906797,'3041','469',259806.87,259806.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257684',4906798,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257684',4906799,'3043','469',378505.61,378505.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257684',4906800,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257684',4906801,'3045','469',371761.33,371761.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257684',4906802,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257684',4906803,'3047','469',281815.12,281815.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257684',4906804,'3048','469',43318.56,43318.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257684',4906805,'3049','469',390510.50,390510.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257684',4906806,'3050','469',357347.45,357347.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257684',4906807,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257684',4906808,'3052','469',249034.71,249034.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257684',4906809,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257684',4906810,'3054','470',8344.44,8344.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257684',4906811,'3055','470',55274.41,55496.48,222.07,151007.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257685',4906812,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257685',4906813,'3039','469',201716.83,202614.54,891.71,147132.15,0.00,0.00,6.00,0.00,0.00),('1','203','1026','257685',4906814,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257685',4906815,'3041','469',259806.87,260649.83,842.96,139088.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257685',4906816,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257685',4906817,'3043','469',378505.61,379226.20,720.59,118897.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257685',4906818,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257685',4906819,'3045','469',371761.33,372683.18,921.85,152105.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257685',4906820,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257685',4906821,'3047','469',281815.12,284945.02,3129.90,516433.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257685',4906822,'3048','469',43318.56,44584.16,1265.60,208824.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257685',4906823,'3049','469',390510.50,393137.08,2626.58,433385.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257685',4906824,'3050','469',357347.45,360375.70,3028.25,499661.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257685',4906825,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257685',4906826,'3052','469',249034.71,251357.85,2323.14,383318.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257685',4906827,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257685',4906828,'3054','470',8344.44,8344.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257685',4906829,'3055','470',55496.48,55905.31,408.83,286181.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257686',4906830,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257686',4906831,'3039','469',202614.54,202614.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257686',4906832,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257686',4906833,'3041','469',260649.83,266068.75,5418.92,894121.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257686',4906834,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257686',4906835,'3043','469',379226.20,384355.11,5128.91,846270.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257686',4906836,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257686',4906837,'3045','469',372683.18,378053.79,5370.61,886150.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257686',4906838,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257686',4906839,'3047','469',284945.02,288793.96,3848.94,635075.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257686',4906840,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257686',4906841,'3049','469',393137.08,397648.54,4511.46,744390.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257686',4906842,'3050','469',360375.70,365152.92,4777.22,788241.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257686',4906843,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257686',4906844,'3052','469',251357.85,251357.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257686',4906845,'3053','469',42112.24,42112.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257686',4906846,'3054','470',8344.44,8344.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257686',4906847,'3055','470',55905.31,56275.06,369.75,258825.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257687',4906848,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257687',4906849,'3039','469',202614.54,202614.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257687',4906850,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257687',4906851,'3041','469',266068.75,271861.28,5782.53,954117.45,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257687',4906852,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257687',4906853,'3043','469',384355.11,389852.55,5487.44,905427.60,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257687',4906854,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257687',4906855,'3045','469',378053.79,380430.14,2366.35,390447.75,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257687',4906856,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257687',4906857,'3047','469',288793.96,290968.83,2164.87,357203.55,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257687',4906858,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257687',4906859,'3049','469',397648.54,399732.63,2075.89,342521.85,0.00,0.00,8.20,0.00,0.00),('1','203','1027','257687',4906860,'3050','469',365152.92,366468.85,1315.93,217128.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257687',4906861,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257687',4906862,'3052','469',251357.85,253661.45,2303.60,380094.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257687',4906863,'3053','469',42112.24,42813.67,701.43,115735.95,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257687',4906864,'3054','470',8344.44,8344.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257687',4906865,'3055','470',56275.06,56718.51,443.45,310415.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257688',4906866,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257688',4906867,'3039','469',202614.54,202614.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257688',4906868,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257688',4906869,'3041','469',271861.28,271861.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257688',4906870,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257688',4906871,'3043','469',389852.55,389852.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257688',4906872,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257688',4906873,'3045','469',380430.14,380430.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257688',4906874,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257688',4906875,'3047','469',290968.83,294850.44,3881.61,640465.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257688',4906876,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257688',4906877,'3049','469',399732.63,404191.44,4458.81,735703.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257688',4906878,'3050','469',366468.85,370559.56,4090.71,674967.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257688',4906879,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257688',4906880,'3052','469',253661.45,253661.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257688',4906881,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257688',4906882,'3054','470',8344.44,8467.58,123.14,86198.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257688',4906883,'3055','470',56718.51,57333.94,615.43,430801.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257689',4906884,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257689',4906885,'3039','469',202614.54,202614.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257689',4906886,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257689',4906887,'3041','469',271861.28,271861.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257689',4906888,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257689',4906889,'3043','469',389852.55,389852.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257689',4906890,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257689',4906891,'3045','469',380430.14,380430.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257689',4906892,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257689',4906893,'3047','469',294850.44,299368.01,4507.57,743749.05,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257689',4906894,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257689',4906895,'3049','469',404191.44,409115.27,4913.83,810781.95,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257689',4906896,'3050','469',370559.56,375494.19,4929.63,813388.95,0.00,0.00,5.00,0.00,0.00),('1','203','1027','257689',4906897,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257689',4906898,'3052','469',253661.45,257009.04,3337.59,550702.35,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257689',4906899,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257689',4906900,'3054','470',8467.58,8467.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257689',4906901,'3055','470',57333.94,57942.20,608.26,425782.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257690',4906902,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257690',4906903,'3039','469',202614.54,202614.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257690',4906904,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257690',4906905,'3041','469',271861.28,274061.85,2200.57,363094.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257690',4906906,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257690',4906907,'3043','469',389852.55,392275.15,2422.60,399729.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257690',4906908,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257690',4906909,'3045','469',380430.14,380430.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257690',4906910,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257690',4906911,'3047','469',299368.01,299368.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257690',4906912,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257690',4906913,'3049','469',409115.27,409115.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257690',4906914,'3050','469',375494.19,375494.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257690',4906915,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257690',4906916,'3052','469',257009.04,257009.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257690',4906917,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257690',4906918,'3054','470',8467.58,8467.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257690',4906919,'3055','470',57942.20,58193.92,251.72,176204.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257691',4906920,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257691',4906921,'3039','469',202614.54,202614.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257691',4906922,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257691',4906923,'3041','469',274061.85,277839.76,3777.91,623355.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257691',4906924,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257691',4906925,'3043','469',392275.15,396177.95,3902.80,643962.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257691',4906926,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257691',4906927,'3045','469',380430.14,382463.40,2033.26,335487.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257691',4906928,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257691',4906929,'3047','469',299368.01,299368.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257691',4906930,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257691',4906931,'3049','469',409115.27,409115.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257691',4906932,'3050','469',375494.19,375494.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257691',4906933,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257691',4906934,'3052','469',257009.04,257009.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257691',4906935,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257691',4906936,'3054','470',8467.58,8477.58,10.00,7000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257691',4906937,'3055','470',58193.92,58895.13,701.21,490847.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257692',4906938,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257692',4906939,'3039','469',202614.54,202614.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257692',4906940,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257692',4906941,'3041','469',277839.76,277839.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257692',4906942,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257692',4906943,'3043','469',396177.95,396177.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257692',4906944,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257692',4906945,'3045','469',382463.40,382463.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257692',4906946,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257692',4906947,'3047','469',299368.01,304049.14,4681.13,772386.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257692',4906948,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257692',4906949,'3049','469',409115.27,413936.55,4821.28,795511.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257692',4906950,'3050','469',375494.19,379826.85,4332.66,714888.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257692',4906951,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257692',4906952,'3052','469',257009.04,257009.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257692',4906953,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257692',4906954,'3054','470',8477.58,8653.86,176.28,123396.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257692',4906955,'3055','470',58895.13,59336.02,440.89,308623.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257693',4906956,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257693',4906957,'3039','469',202614.54,203280.92,656.38,108302.70,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257693',4906958,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257693',4906959,'3041','469',277839.76,278355.51,505.75,83448.75,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257693',4906960,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257693',4906961,'3043','469',396177.95,396730.69,542.74,89552.10,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257693',4906962,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257693',4906963,'3045','469',382463.40,382463.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257693',4906964,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257693',4906965,'3047','469',304049.14,308428.90,4369.76,721010.40,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257693',4906966,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257693',4906967,'3049','469',413936.55,419090.20,5153.65,850352.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257693',4906968,'3050','469',379826.85,384032.12,4205.27,693869.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257693',4906969,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257693',4906970,'3052','469',257009.04,259504.32,2495.28,411721.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257693',4906971,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257693',4906972,'3054','470',8653.86,8653.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257693',4906973,'3055','470',59336.02,59991.36,635.34,444738.00,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257694',4906974,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257694',4906975,'3039','469',203280.92,203280.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257694',4906976,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257694',4906977,'3041','469',278355.51,283623.09,5267.58,869150.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257694',4906978,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257694',4906979,'3043','469',396730.69,401700.43,4969.74,820007.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257694',4906980,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257694',4906981,'3045','469',382463.40,386376.40,3913.00,645645.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257694',4906982,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257694',4906983,'3047','469',308428.90,312586.09,4157.19,685936.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257694',4906984,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257694',4906985,'3049','469',419090.20,424782.74,5692.54,939269.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257694',4906986,'3050','469',384032.12,388586.77,4554.65,751517.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257694',4906987,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257694',4906988,'3052','469',259504.32,259504.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257694',4906989,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257694',4906990,'3054','470',8653.86,8653.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257694',4906991,'3055','470',59991.36,60488.23,496.87,347809.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257695',4906992,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257695',4906993,'3039','469',203280.92,203280.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257695',4906994,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257695',4906995,'3041','469',283623.09,287107.73,3484.64,574965.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257695',4906996,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257695',4906997,'3043','469',401700.43,405614.59,3914.16,645836.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257695',4906998,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257695',4906999,'3045','469',386376.40,389467.49,3091.09,510029.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257695',4907000,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257695',4907001,'3047','469',312586.09,314239.89,1653.80,272877.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257695',4907002,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257695',4907003,'3049','469',424782.74,426564.87,1773.13,292566.45,0.00,0.00,9.00,0.00,0.00),('1','203','1027','257695',4907004,'3050','469',388586.77,390322.28,1735.51,286359.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257695',4907005,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257695',4907006,'3052','469',259504.32,261166.41,1662.09,274244.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257695',4907007,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257695',4907008,'3054','470',8653.86,8653.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257695',4907009,'3055','470',60488.23,61155.66,667.43,467201.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257696',4907010,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257696',4907011,'3039','469',203280.92,203280.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257696',4907012,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257696',4907013,'3041','469',287107.73,287107.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257696',4907014,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257696',4907015,'3043','469',405614.59,405614.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257696',4907016,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257696',4907017,'3045','469',389467.49,389467.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257696',4907018,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257696',4907019,'3047','469',314239.89,316583.08,2343.19,386626.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257696',4907020,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257696',4907021,'3049','469',426564.87,429466.37,2901.50,478747.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257696',4907022,'3050','469',390322.28,393201.58,2879.30,475084.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257696',4907023,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257696',4907024,'3052','469',261166.41,261166.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257696',4907025,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257696',4907026,'3054','470',8653.86,8753.86,100.00,70000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257696',4907027,'3055','470',61155.66,62272.20,1116.54,781578.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257697',4907028,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257697',4907029,'3039','469',203280.92,203280.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257697',4907030,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257697',4907031,'3041','469',287107.73,287107.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257697',4907032,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257697',4907033,'3043','469',405614.59,408746.52,3131.93,516768.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257697',4907034,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257697',4907035,'3045','469',389467.49,391655.68,2188.19,361051.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257697',4907036,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257697',4907037,'3047','469',316583.08,321006.34,4423.26,729837.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257697',4907038,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257697',4907039,'3049','469',429466.37,434746.31,5279.94,871190.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257697',4907040,'3050','469',393201.58,397854.57,4652.99,767743.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257697',4907041,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257697',4907042,'3052','469',261166.41,263553.95,2373.54,391634.10,0.00,0.00,14.00,0.00,0.00),('1','203','1027','257697',4907043,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257697',4907044,'3054','470',8753.86,8753.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257697',4907045,'3055','470',62272.20,63103.08,830.88,581616.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257698',4907046,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257698',4907047,'3039','469',203280.92,203280.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257698',4907048,'3040','469',30751.07,30751.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257698',4907049,'3041','469',287107.73,291793.93,4686.20,773223.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257698',4907050,'3042','469',19078.92,19078.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257698',4907051,'3043','469',408746.52,413310.13,4563.61,752995.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257698',4907052,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257698',4907053,'3045','469',391655.68,395421.12,3765.44,621297.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257698',4907054,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257698',4907055,'3047','469',321006.34,325156.33,4149.99,684748.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257698',4907056,'3048','469',44584.16,44584.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257698',4907057,'3049','469',434746.31,438418.55,3672.24,605919.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257698',4907058,'3050','469',397854.57,401129.25,3274.68,540322.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257698',4907059,'3051','469',44217.80,44217.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257698',4907060,'3052','469',263553.95,263553.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257698',4907061,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257698',4907062,'3054','470',8753.86,8753.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257698',4907063,'3055','470',63103.08,64632.58,1529.50,1070650.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257699',4907064,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257699',4907065,'3039','469',203280.92,204361.17,1080.25,178241.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257699',4907066,'3040','469',30751.07,31587.88,836.81,138073.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257699',4907067,'3041','469',291793.93,295236.48,3442.55,568020.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257699',4907068,'3042','469',19078.92,19465.35,386.43,63760.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257699',4907069,'3043','469',413310.13,416300.45,2990.32,493402.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257699',4907070,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257699',4907071,'3045','469',395421.12,398761.56,3340.44,551172.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257699',4907072,'3046','469',34344.73,34344.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257699',4907073,'3047','469',325156.33,327675.64,2519.31,415686.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257699',4907074,'3048','469',44584.16,45525.90,941.74,155387.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257699',4907075,'3049','469',438418.55,441745.06,3326.51,548874.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257699',4907076,'3050','469',401129.25,403854.67,2725.42,449694.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257699',4907077,'3051','469',44217.80,45220.77,1002.97,165490.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257699',4907078,'3052','469',263553.95,264750.55,1196.60,197439.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257699',4907079,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257699',4907080,'3054','470',8753.86,8928.73,174.87,122409.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257699',4907081,'3055','470',64632.58,65715.18,1082.60,757820.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257700',4907082,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257700',4907083,'3039','469',204361.17,204361.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257700',4907084,'3040','469',31587.88,31587.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257700',4907085,'3041','469',295236.48,295236.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257700',4907086,'3042','469',19465.35,19465.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257700',4907087,'3043','469',416300.45,416300.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257700',4907088,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257700',4907089,'3045','469',398761.56,398761.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257700',4907090,'3046','469',34344.73,35815.05,1470.32,242602.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257700',4907091,'3047','469',327675.64,331960.86,4285.22,707061.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257700',4907092,'3048','469',45525.90,45525.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257700',4907093,'3049','469',441745.06,446768.01,5022.95,828786.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257700',4907094,'3050','469',403854.67,407358.84,3504.17,578188.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257700',4907095,'3051','469',45220.77,46264.87,1044.10,172276.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257700',4907096,'3052','469',264750.55,266645.17,1894.62,312612.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257700',4907097,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257700',4907098,'3054','470',8928.73,9018.73,90.00,63000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257700',4907099,'3055','470',65715.18,66959.32,1244.14,870898.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257701',4907100,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257701',4907101,'3039','469',204361.17,208283.39,3912.22,645516.30,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257701',4907102,'3040','469',31587.88,31587.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257701',4907103,'3041','469',295236.48,299162.33,3917.67,646415.55,0.00,0.00,8.18,0.00,0.00),('1','203','1026','257701',4907104,'3042','469',19465.35,23067.16,3601.81,594298.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257701',4907105,'3043','469',416300.45,417773.95,1473.50,243127.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257701',4907106,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257701',4907107,'3045','469',398761.56,402375.23,3613.67,596255.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257701',4907108,'3046','469',35815.05,35815.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257701',4907109,'3047','469',331960.86,333993.71,2032.85,335420.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257701',4907110,'3048','469',45525.90,45525.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257701',4907111,'3049','469',446768.01,447834.80,1066.79,176020.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257701',4907112,'3050','469',407358.84,408811.04,1452.20,239613.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257701',4907113,'3051','469',46264.87,46933.19,668.32,110272.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257701',4907114,'3052','469',266645.17,270379.35,3734.18,616139.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257701',4907115,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257701',4907116,'3054','470',9018.73,9018.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257701',4907117,'3055','470',66959.32,69141.44,2182.12,1527484.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257702',4907118,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257702',4907119,'3039','469',208283.39,208283.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257702',4907120,'3040','469',31587.88,31587.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257702',4907121,'3041','469',299162.33,299162.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257702',4907122,'3042','469',23067.16,23067.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257702',4907123,'3043','469',417773.95,417773.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257702',4907124,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257702',4907125,'3045','469',402375.23,402375.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257702',4907126,'3046','469',35815.05,35815.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257702',4907127,'3047','469',333993.71,337459.88,3466.17,571918.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257702',4907128,'3048','469',45525.90,45525.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257702',4907129,'3049','469',447834.80,451352.96,3518.16,580496.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257702',4907130,'3050','469',408811.04,412194.55,3383.51,558279.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257702',4907131,'3051','469',46933.19,46933.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257702',4907132,'3052','469',270379.35,274139.25,3759.90,620383.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257702',4907133,'3053','469',42813.67,42813.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257702',4907134,'3054','470',9018.73,9018.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257702',4907135,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257703',4907136,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257703',4907137,'3039','469',208283.39,210735.65,2442.26,402972.90,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257703',4907138,'3040','469',31587.88,31587.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257703',4907139,'3041','469',299162.33,301796.44,2624.11,432978.15,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257703',4907140,'3042','469',23067.16,23067.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257703',4907141,'3043','469',417773.95,420087.26,2303.31,380046.15,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257703',4907142,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257703',4907143,'3045','469',402375.23,405151.51,2776.28,458086.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257703',4907144,'3046','469',35815.05,36922.72,1107.67,182765.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257703',4907145,'3047','469',337459.88,339835.27,2375.39,391939.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257703',4907146,'3048','469',45525.90,46210.60,684.70,112975.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257703',4907147,'3049','469',451352.96,454091.41,2738.45,451844.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257703',4907148,'3050','469',412194.55,415019.42,2824.87,466103.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257703',4907149,'3051','469',46933.19,47544.56,611.37,100876.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257703',4907150,'3052','469',274139.25,277512.65,3373.40,556611.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257703',4907151,'3053','469',42813.67,42822.87,9.20,1518.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257703',4907152,'3054','470',9018.73,9018.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257703',4907153,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257704',4907154,'3038','469',9298.29,9298.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257704',4907155,'3039','469',210735.65,215175.98,4440.33,732654.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257704',4907156,'3040','469',31587.88,31587.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257704',4907157,'3041','469',301796.44,306709.73,4913.29,810692.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257704',4907158,'3042','469',23067.16,23067.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257704',4907159,'3043','469',420087.26,423582.52,3495.26,576717.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257704',4907160,'3044','469',14486.01,14486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257704',4907161,'3045','469',405151.51,409307.52,4156.01,685741.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257704',4907162,'3046','469',36922.72,36922.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257704',4907163,'3047','469',339835.27,343696.91,3861.64,637170.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257704',4907164,'3048','469',46210.60,46210.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257704',4907165,'3049','469',454091.41,458668.64,4577.23,755242.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257704',4907166,'3050','469',415019.42,419200.23,4180.81,689833.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257704',4907167,'3051','469',47544.56,47544.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257704',4907168,'3052','469',277512.65,277512.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257704',4907169,'3053','469',42822.87,42822.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257704',4907170,'3054','470',9018.73,9272.43,253.70,177590.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257704',4907171,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257705',4907172,'3038','469',9298.29,9999.99,701.70,115780.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257705',4907173,'3039','469',215175.98,218607.11,3421.13,564486.45,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257705',4907174,'3040','469',31587.88,32540.58,942.70,155545.50,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257705',4907175,'3041','469',306709.73,310727.05,4010.12,661669.80,0.00,0.00,7.20,0.00,0.00),('1','203','1026','257705',4907176,'3042','469',23067.16,23723.79,656.63,108343.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257705',4907177,'3043','469',423582.52,427572.86,3990.34,658406.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257705',4907178,'3044','469',14486.01,15260.74,774.73,127830.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257705',4907179,'3045','469',409307.52,413474.90,4167.38,687617.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257705',4907180,'3046','469',36922.72,36922.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257705',4907181,'3047','469',343696.91,345712.90,2015.99,332638.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257705',4907182,'3048','469',46210.60,46210.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257705',4907183,'3049','469',458668.64,461152.94,2484.30,409909.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257705',4907184,'3050','469',419200.23,421429.27,2229.04,367791.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257705',4907185,'3051','469',47544.56,47544.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257705',4907186,'3052','469',277512.65,279336.42,1823.77,300922.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257705',4907187,'3053','469',42822.87,42822.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257705',4907188,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257705',4907189,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257706',4907190,'3038','469',9999.99,9999.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257706',4907191,'3039','469',218607.11,218607.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257706',4907192,'3040','469',32540.58,32540.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257706',4907193,'3041','469',310727.05,310727.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257706',4907194,'3042','469',23723.79,23723.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257706',4907195,'3043','469',427572.86,429509.98,1937.12,319624.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257706',4907196,'3044','469',15260.74,15260.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257706',4907197,'3045','469',413474.90,415617.60,2142.70,353545.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257706',4907198,'3046','469',36922.72,36922.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257706',4907199,'3047','469',345712.90,349059.87,3346.97,552250.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257706',4907200,'3048','469',46210.60,48139.94,1929.34,318341.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257706',4907201,'3049','469',461152.94,463564.50,2411.56,397907.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257706',4907202,'3050','469',421429.27,424505.46,3076.19,507571.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257706',4907203,'3051','469',47544.56,48322.08,777.52,128290.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257706',4907204,'3052','469',279336.42,282725.72,3389.30,559234.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257706',4907205,'3053','469',42822.87,43487.28,664.41,109627.65,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257706',4907206,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257706',4907207,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257707',4907208,'3038','469',9999.99,10825.68,815.69,134588.85,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257707',4907209,'3039','469',218607.11,219334.83,727.72,120073.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257707',4907210,'3040','469',32540.58,32982.65,442.07,72941.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257707',4907211,'3041','469',310727.05,314109.37,3382.32,558082.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257707',4907212,'3042','469',23723.79,23723.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257707',4907213,'3043','469',429509.98,432134.64,2624.66,433068.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257707',4907214,'3044','469',15260.74,16036.49,775.75,127998.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257707',4907215,'3045','469',415617.60,418662.30,3044.70,502375.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257707',4907216,'3046','469',36922.72,37725.28,802.56,132422.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257707',4907217,'3047','469',349059.87,351485.94,2426.07,400301.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257707',4907218,'3048','469',48139.94,49097.32,957.38,157967.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257707',4907219,'3049','469',463564.50,466468.07,2903.57,479089.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257707',4907220,'3050','469',424505.46,427318.16,2812.70,464095.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257707',4907221,'3051','469',48322.08,49127.58,805.50,132907.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257707',4907222,'3052','469',282725.72,286195.47,3469.75,572508.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257707',4907223,'3053','469',43487.28,43487.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257707',4907224,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257707',4907225,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257708',4907226,'3038','469',10825.68,10825.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257708',4907227,'3039','469',219334.83,219334.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257708',4907228,'3040','469',32982.65,32982.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257708',4907229,'3041','469',314109.37,317443.83,3334.46,550185.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257708',4907230,'3042','469',23723.79,23723.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257708',4907231,'3043','469',432134.64,435360.06,3225.42,532194.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257708',4907232,'3044','469',16036.49,16036.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257708',4907233,'3045','469',418662.30,421826.15,3163.85,522035.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257708',4907234,'3046','469',37725.28,37725.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257708',4907235,'3047','469',351485.94,354372.00,2886.06,476199.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257708',4907236,'3048','469',49097.32,49097.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257708',4907237,'3049','469',466468.07,469065.91,2597.84,428643.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257708',4907238,'3050','469',427318.16,429912.80,2594.64,428115.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257708',4907239,'3051','469',49127.58,49127.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257708',4907240,'3052','469',286195.47,288440.90,2245.43,370495.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257708',4907241,'3053','469',43487.28,43487.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257708',4907242,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257708',4907243,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257709',4907244,'3038','469',10825.68,10825.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257709',4907245,'3039','469',219334.83,221516.64,2171.81,358348.65,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257709',4907246,'3040','469',32982.65,32982.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257709',4907247,'3041','469',317443.83,320477.19,3023.36,498854.40,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257709',4907248,'3042','469',23723.79,24737.57,1008.78,166448.70,0.00,0.00,5.00,0.00,0.00),('1','203','1026','257709',4907249,'3043','469',435360.06,437795.66,2435.60,401874.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257709',4907250,'3044','469',16036.49,17425.27,1388.78,229148.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257709',4907251,'3045','469',421826.15,424422.09,2595.94,428330.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257709',4907252,'3046','469',37725.28,39234.16,1508.88,248965.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257709',4907253,'3047','469',354372.00,355621.23,1249.23,206122.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257709',4907254,'3048','469',49097.32,49097.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257709',4907255,'3049','469',469065.91,471742.13,2676.22,441576.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257709',4907256,'3050','469',429912.80,432422.70,2509.90,414133.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257709',4907257,'3051','469',49127.58,49127.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257709',4907258,'3052','469',288440.90,289970.02,1529.12,252304.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257709',4907259,'3053','469',43487.28,44577.31,1090.03,179854.95,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257709',4907260,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257709',4907261,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257710',4907262,'3038','469',10825.68,10825.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257710',4907263,'3039','469',221516.64,221516.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257710',4907264,'3040','469',32982.65,32982.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257710',4907265,'3041','469',320477.19,320477.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257710',4907266,'3042','469',24737.57,24737.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257710',4907267,'3043','469',437795.66,437795.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257710',4907268,'3044','469',17425.27,17425.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257710',4907269,'3045','469',424422.09,424422.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257710',4907270,'3046','469',39234.16,41521.81,2282.65,376637.25,0.00,0.00,5.00,0.00,0.00),('1','203','1027','257710',4907271,'3047','469',355621.23,358112.43,2491.20,411048.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257710',4907272,'3048','469',49097.32,51367.55,2270.23,374587.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257710',4907273,'3049','469',471742.13,474110.18,2368.05,390728.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257710',4907274,'3050','469',432422.70,435052.62,2629.92,433936.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257710',4907275,'3051','469',49127.58,51205.70,2078.12,342889.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257710',4907276,'3052','469',289970.02,293396.43,3426.41,565357.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257710',4907277,'3053','469',44577.31,44577.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257710',4907278,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257710',4907279,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257711',4907280,'3038','469',10825.68,10825.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257711',4907281,'3039','469',221516.64,221516.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257711',4907282,'3040','469',32982.65,32982.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257711',4907283,'3041','469',320477.19,320477.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257711',4907284,'3042','469',24737.57,24737.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257711',4907285,'3043','469',437795.66,437795.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257711',4907286,'3044','469',17425.27,17425.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257711',4907287,'3045','469',424422.09,424422.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257711',4907288,'3046','469',41521.81,41521.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257711',4907289,'3047','469',358112.43,358112.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257711',4907290,'3048','469',51367.55,51367.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257711',4907291,'3049','469',474110.18,474110.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257711',4907292,'3050','469',435052.62,435052.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257711',4907293,'3051','469',51205.70,51205.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257711',4907294,'3052','469',293396.43,293396.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257711',4907295,'3053','469',44577.31,44577.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257711',4907296,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257711',4907297,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257712',4907298,'3038','469',10825.68,10825.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257712',4907299,'3039','469',221516.64,221516.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257712',4907300,'3040','469',32982.65,32982.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257712',4907301,'3041','469',320477.19,323433.74,2956.55,487830.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257712',4907302,'3042','469',24737.57,24737.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257712',4907303,'3043','469',437795.66,441664.70,3869.04,638391.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257712',4907304,'3044','469',17425.27,17425.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257712',4907305,'3045','469',424422.09,426647.18,2225.09,367139.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257712',4907306,'3046','469',41521.81,42679.82,1158.01,191071.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257712',4907307,'3047','469',358112.43,361371.63,3259.20,537768.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257712',4907308,'3048','469',51367.55,52212.12,844.57,139354.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257712',4907309,'3049','469',474110.18,477795.92,3685.74,608147.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257712',4907310,'3050','469',435052.62,438464.75,3412.13,563001.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257712',4907311,'3051','469',51205.70,51205.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257712',4907312,'3052','469',293396.43,296593.27,3196.84,527478.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257712',4907313,'3053','469',44577.31,45349.00,771.69,127328.85,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257712',4907314,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257712',4907315,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257713',4907316,'3038','469',10825.68,10825.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257713',4907317,'3039','469',221516.64,224853.75,3327.11,548973.15,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257713',4907318,'3040','469',32982.65,32992.77,0.00,0.00,0.00,0.00,10.12,0.00,0.00),('1','203','1026','257713',4907319,'3041','469',323433.74,326928.28,3484.54,574949.10,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257713',4907320,'3042','469',24737.57,24747.68,0.00,0.00,0.00,0.00,10.11,0.00,0.00),('1','203','1026','257713',4907321,'3043','469',441664.70,445734.71,4060.01,669901.65,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257713',4907322,'3044','469',17425.27,17435.61,0.00,0.00,0.00,0.00,10.34,0.00,0.00),('1','203','1026','257713',4907323,'3045','469',426647.18,426657.18,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257713',4907324,'3046','469',42679.82,42679.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257713',4907325,'3047','469',361371.63,361670.78,299.15,49359.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257713',4907326,'3048','469',52212.12,52222.12,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257713',4907327,'3049','469',477795.92,480925.14,3119.22,514671.30,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257713',4907328,'3050','469',438464.75,441556.43,3081.68,508477.20,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257713',4907329,'3051','469',51205.70,51205.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257713',4907330,'3052','469',296593.27,299338.47,2735.20,451308.00,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257713',4907331,'3053','469',45349.00,45349.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257713',4907332,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257713',4907333,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257714',4907334,'3038','469',10825.68,11503.70,678.02,111873.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257714',4907335,'3039','469',224853.75,226734.68,1880.93,310353.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257714',4907336,'3040','469',32992.77,33570.83,578.06,95379.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257714',4907337,'3041','469',326928.28,328924.93,1996.65,329447.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257714',4907338,'3042','469',24747.68,25471.09,723.41,119362.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257714',4907339,'3043','469',445734.71,447733.12,1998.41,329737.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257714',4907340,'3044','469',17435.61,17435.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257714',4907341,'3045','469',426657.18,428937.36,2280.18,376229.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257714',4907342,'3046','469',42679.82,42679.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257714',4907343,'3047','469',361670.78,361670.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257714',4907344,'3048','469',52222.12,52222.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257714',4907345,'3049','469',480925.14,481751.74,826.60,136389.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257714',4907346,'3050','469',441556.43,442367.28,810.85,133790.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257714',4907347,'3051','469',51205.70,51205.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257714',4907348,'3052','469',299338.47,300184.79,846.32,139642.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257714',4907349,'3053','469',45349.00,45349.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257714',4907350,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257714',4907351,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257715',4907352,'3038','469',11503.70,11503.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257715',4907353,'3039','469',226734.68,226734.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257715',4907354,'3040','469',33570.83,33570.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257715',4907355,'3041','469',328924.93,328924.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257715',4907356,'3042','469',25471.09,25471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257715',4907357,'3043','469',447733.12,447733.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257715',4907358,'3044','469',17435.61,17435.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257715',4907359,'3045','469',428937.36,428937.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257715',4907360,'3046','469',42679.82,42679.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257715',4907361,'3047','469',361670.78,361670.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257715',4907362,'3048','469',52222.12,52222.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257715',4907363,'3049','469',481751.74,481751.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257715',4907364,'3050','469',442367.28,442367.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257715',4907365,'3051','469',51205.70,51205.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257715',4907366,'3052','469',300184.79,300184.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257715',4907367,'3053','469',45349.00,45349.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257715',4907368,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257715',4907369,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257716',4907370,'3038','469',11503.70,11503.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257716',4907371,'3039','469',226734.68,230618.69,3884.01,640861.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257716',4907372,'3040','469',33570.83,33570.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257716',4907373,'3041','469',328924.93,332080.26,3155.33,520629.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257716',4907374,'3042','469',25471.09,25471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257716',4907375,'3043','469',447733.12,450808.91,3075.79,507505.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257716',4907376,'3044','469',17435.61,17435.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257716',4907377,'3045','469',428937.36,431757.76,2820.40,465366.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257716',4907378,'3046','469',42679.82,42679.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257716',4907379,'3047','469',361670.78,361670.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257716',4907380,'3048','469',52222.12,52222.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257716',4907381,'3049','469',481751.74,483600.51,1848.77,305047.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257716',4907382,'3050','469',442367.28,445295.35,2928.07,483131.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257716',4907383,'3051','469',51205.70,51205.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257716',4907384,'3052','469',300184.79,302225.70,2040.91,336750.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257716',4907385,'3053','469',45349.00,45349.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257716',4907386,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257716',4907387,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257717',4907388,'3038','469',11503.70,11503.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257717',4907389,'3039','469',230618.69,232200.44,1581.75,260988.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257717',4907390,'3040','469',33570.83,33570.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257717',4907391,'3041','469',332080.26,333367.59,1287.33,212409.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257717',4907392,'3042','469',25471.09,25471.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257717',4907393,'3043','469',450808.91,450808.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257717',4907394,'3044','469',17435.61,17435.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257717',4907395,'3045','469',431757.76,433002.41,1244.65,205367.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257717',4907396,'3046','469',42679.82,44155.31,1475.49,243455.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257717',4907397,'3047','469',361670.78,364576.22,2905.44,479397.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257717',4907398,'3048','469',52222.12,53486.18,1264.06,208569.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257717',4907399,'3049','469',483600.51,486760.40,3159.89,521381.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257717',4907400,'3050','469',445295.35,447788.76,2493.41,411412.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257717',4907401,'3051','469',51205.70,51205.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257717',4907402,'3052','469',302225.70,304744.31,2518.61,415570.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257717',4907403,'3053','469',45349.00,46387.58,1038.58,171365.70,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257717',4907404,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257717',4907405,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257718',4907406,'3038','469',11503.70,11503.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257718',4907407,'3039','469',232200.44,233992.51,1792.07,295691.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257718',4907408,'3040','469',33570.83,33570.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257718',4907409,'3041','469',333367.59,335048.36,1680.77,277327.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257718',4907410,'3042','469',25471.09,26234.43,763.34,125951.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257718',4907411,'3043','469',450808.91,451877.32,1068.41,176287.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257718',4907412,'3044','469',17435.61,18462.17,1026.56,169382.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257718',4907413,'3045','469',433002.41,434437.88,1435.47,236852.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257718',4907414,'3046','469',44155.31,46064.37,1909.06,314994.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257718',4907415,'3047','469',364576.22,366411.83,1835.61,302875.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257718',4907416,'3048','469',53486.18,55315.70,1829.52,301870.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257718',4907417,'3049','469',486760.40,488728.46,1968.06,324729.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257718',4907418,'3050','469',447788.76,450165.75,2376.99,392203.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257718',4907419,'3051','469',51205.70,51205.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257718',4907420,'3052','469',304744.31,306506.15,1761.84,290703.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257718',4907421,'3053','469',46387.58,46387.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257718',4907422,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257718',4907423,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257719',4907424,'3038','469',11503.70,11503.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257719',4907425,'3039','469',233992.51,237904.63,3902.12,643849.80,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257719',4907426,'3040','469',33570.83,36555.62,2984.79,492490.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257719',4907427,'3041','469',335048.36,337687.04,2638.68,435382.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257719',4907428,'3042','469',26234.43,29272.49,3038.06,501279.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257719',4907429,'3043','469',451877.32,454575.36,2698.04,445176.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257719',4907430,'3044','469',18462.17,21286.09,2823.92,465946.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257719',4907431,'3045','469',434437.88,437336.29,2898.41,478237.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257719',4907432,'3046','469',46064.37,46064.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257719',4907433,'3047','469',366411.83,366411.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257719',4907434,'3048','469',55315.70,55315.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257719',4907435,'3049','469',488728.46,488728.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257719',4907436,'3050','469',450165.75,450165.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257719',4907437,'3051','469',51205.70,51205.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257719',4907438,'3052','469',306506.15,306506.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257719',4907439,'3053','469',46387.58,46387.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257719',4907440,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257719',4907441,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257720',4907442,'3038','469',11503.70,11635.52,131.82,21750.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257720',4907443,'3039','469',237904.63,238133.71,229.08,37798.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257720',4907444,'3040','469',36555.62,36630.02,74.40,12276.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257720',4907445,'3041','469',337687.04,337858.88,171.84,28353.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257720',4907446,'3042','469',29272.49,29445.49,173.00,28545.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257720',4907447,'3043','469',454575.36,454710.65,135.29,22322.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257720',4907448,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257720',4907449,'3045','469',437336.29,437504.42,168.13,27741.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257720',4907450,'3046','469',46064.37,46064.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257720',4907451,'3047','469',366411.83,367596.79,1184.96,195518.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257720',4907452,'3048','469',55315.70,55315.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257720',4907453,'3049','469',488728.46,490020.27,1288.81,212653.65,0.00,0.00,3.00,0.00,0.00),('1','203','1027','257720',4907454,'3050','469',450165.75,451270.18,1104.43,182230.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257720',4907455,'3051','469',51205.70,51355.53,149.83,24721.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257720',4907456,'3052','469',306506.15,307406.89,900.74,148622.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257720',4907457,'3053','469',46387.58,47119.89,732.31,120831.15,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257720',4907458,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257720',4907459,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257721',4907460,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257721',4907461,'3039','469',238133.71,238133.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257721',4907462,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257721',4907463,'3041','469',337858.88,337858.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257721',4907464,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257721',4907465,'3043','469',454710.65,454710.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257721',4907466,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257721',4907467,'3045','469',437504.42,437504.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257721',4907468,'3046','469',46064.37,46064.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257721',4907469,'3047','469',367596.79,367596.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257721',4907470,'3048','469',55315.70,55315.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257721',4907471,'3049','469',490020.27,490020.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257721',4907472,'3050','469',451270.18,456774.24,5504.06,908169.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257721',4907473,'3051','469',51355.53,51355.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257721',4907474,'3052','469',307406.89,313534.42,6115.53,1009062.45,0.00,0.00,12.00,0.00,0.00),('1','203','1027','257721',4907475,'3053','469',47119.89,47119.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257721',4907476,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257721',4907477,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257722',4907478,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257722',4907479,'3039','469',238133.71,238133.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257722',4907480,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257722',4907481,'3041','469',337858.88,337858.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257722',4907482,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257722',4907483,'3043','469',454710.65,454710.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257722',4907484,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257722',4907485,'3045','469',437504.42,437504.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257722',4907486,'3046','469',46064.37,46064.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257722',4907487,'3047','469',367596.79,367596.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257722',4907488,'3048','469',55315.70,55315.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257722',4907489,'3049','469',490020.27,490020.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257722',4907490,'3050','469',456774.24,456774.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257722',4907491,'3051','469',51355.53,51355.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257722',4907492,'3052','469',313534.42,313534.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257722',4907493,'3053','469',47119.89,47119.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257722',4907494,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257722',4907495,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257723',4907496,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257723',4907497,'3039','469',238133.71,238133.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257723',4907498,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257723',4907499,'3041','469',337858.88,337858.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257723',4907500,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257723',4907501,'3043','469',454710.65,454710.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257723',4907502,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257723',4907503,'3045','469',437504.42,437504.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257723',4907504,'3046','469',46064.37,48634.44,2570.07,424061.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257723',4907505,'3047','469',367596.79,370440.70,2843.91,469245.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257723',4907506,'3048','469',55315.70,57936.77,2621.07,432476.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257723',4907507,'3049','469',490020.27,493126.35,3106.08,512503.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257723',4907508,'3050','469',456774.24,460345.77,3571.53,589302.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257723',4907509,'3051','469',51355.53,51355.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257723',4907510,'3052','469',313534.42,316890.60,3356.18,553769.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257723',4907511,'3053','469',47119.89,49375.53,2255.64,372180.60,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257723',4907512,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257723',4907513,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257724',4907514,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257724',4907515,'3039','469',238133.71,238133.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257724',4907516,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257724',4907517,'3041','469',337858.88,337858.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257724',4907518,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257724',4907519,'3043','469',454710.65,454710.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257724',4907520,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257724',4907521,'3045','469',437504.42,437504.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257724',4907522,'3046','469',48634.44,51196.50,2552.06,421089.90,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257724',4907523,'3047','469',370440.70,372986.88,2536.18,418469.70,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257724',4907524,'3048','469',57936.77,60536.95,2590.18,427379.70,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257724',4907525,'3049','469',493126.35,496541.07,3404.72,561778.80,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257724',4907526,'3050','469',460345.77,463785.80,3430.03,565954.95,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257724',4907527,'3051','469',51355.53,51355.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257724',4907528,'3052','469',316890.60,320717.72,3821.70,630580.50,0.00,0.00,5.42,0.00,0.00),('1','203','1027','257724',4907529,'3053','469',49375.53,49843.60,468.07,77231.55,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257724',4907530,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257724',4907531,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257725',4907532,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257725',4907533,'3039','469',238133.71,238133.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257725',4907534,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257725',4907535,'3041','469',337858.88,337858.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257725',4907536,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257725',4907537,'3043','469',454710.65,454710.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257725',4907538,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257725',4907539,'3045','469',437504.42,437504.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257725',4907540,'3046','469',51196.50,51196.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257725',4907541,'3047','469',372986.88,372986.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257725',4907542,'3048','469',60536.95,60536.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257725',4907543,'3049','469',496541.07,501441.92,4900.85,808640.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257725',4907544,'3050','469',463785.80,468013.30,4227.50,697537.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257725',4907545,'3051','469',51355.53,51355.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257725',4907546,'3052','469',320717.72,320717.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257725',4907547,'3053','469',49843.60,49843.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257725',4907548,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257725',4907549,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257726',4907550,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257726',4907551,'3039','469',238133.71,240304.53,2160.82,356535.30,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257726',4907552,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257726',4907553,'3041','469',337858.88,339720.01,1861.13,307086.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257726',4907554,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257726',4907555,'3043','469',454710.65,457351.79,2641.14,435788.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257726',4907556,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257726',4907557,'3045','469',437504.42,439608.39,2103.97,347155.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257726',4907558,'3046','469',51196.50,51196.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257726',4907559,'3047','469',372986.88,374616.37,1629.49,268865.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257726',4907560,'3048','469',60536.95,60536.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257726',4907561,'3049','469',501441.92,504668.37,3226.45,532364.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257726',4907562,'3050','469',468013.30,470624.85,2611.55,430905.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257726',4907563,'3051','469',51355.53,51355.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257726',4907564,'3052','469',320717.72,322388.98,1671.26,275757.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257726',4907565,'3053','469',49843.60,49843.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257726',4907566,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257726',4907567,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257727',4907568,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257727',4907569,'3039','469',240304.53,244046.53,3742.00,617430.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257727',4907570,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257727',4907571,'3041','469',339720.01,343487.16,3767.15,621579.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257727',4907572,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257727',4907573,'3043','469',457351.79,460346.58,2994.79,494140.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257727',4907574,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257727',4907575,'3045','469',439608.39,439608.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257727',4907576,'3046','469',51196.50,51196.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257727',4907577,'3047','469',374616.37,376846.22,2229.85,367925.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257727',4907578,'3048','469',60536.95,60536.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257727',4907579,'3049','469',504668.37,507301.20,2632.83,434416.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257727',4907580,'3050','469',470624.85,473543.66,2918.81,481603.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257727',4907581,'3051','469',51355.53,51355.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257727',4907582,'3052','469',322388.98,325515.35,3126.37,515851.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257727',4907583,'3053','469',49843.60,49843.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257727',4907584,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257727',4907585,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257728',4907586,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257728',4907587,'3039','469',244046.53,247758.58,3712.05,612488.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257728',4907588,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257728',4907589,'3041','469',343487.16,347354.04,3866.88,638035.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257728',4907590,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257728',4907591,'3043','469',460346.58,463494.14,3147.56,519347.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257728',4907592,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257728',4907593,'3045','469',439608.39,443129.84,3521.45,581039.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257728',4907594,'3046','469',51196.50,51196.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257728',4907595,'3047','469',376846.22,380310.43,3464.21,571594.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257728',4907596,'3048','469',60536.95,60803.70,266.75,44013.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257728',4907597,'3049','469',507301.20,510984.89,3683.69,607808.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257728',4907598,'3050','469',473543.66,476623.14,3079.48,508114.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257728',4907599,'3051','469',51355.53,51355.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257728',4907600,'3052','469',325515.35,328901.14,3385.79,558655.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257728',4907601,'3053','469',49843.60,49843.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257728',4907602,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257728',4907603,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257729',4907604,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257729',4907605,'3039','469',247758.58,249535.80,1777.22,293241.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257729',4907606,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257729',4907607,'3041','469',347354.04,349039.82,1685.78,278153.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257729',4907608,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257729',4907609,'3043','469',463494.14,465073.90,1579.76,260660.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257729',4907610,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257729',4907611,'3045','469',443129.84,444429.25,1299.41,214402.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257729',4907612,'3046','469',51196.50,51196.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257729',4907613,'3047','469',380310.43,382361.56,2051.13,338436.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257729',4907614,'3048','469',60803.70,60803.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257729',4907615,'3049','469',510984.89,513023.62,2038.73,336390.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257729',4907616,'3050','469',476623.14,478467.06,1843.92,304246.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257729',4907617,'3051','469',51355.53,51355.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257729',4907618,'3052','469',328901.14,330787.56,1886.42,311259.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257729',4907619,'3053','469',49843.60,49843.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257729',4907620,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257729',4907621,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257730',4907622,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257730',4907623,'3039','469',249535.80,252708.12,3172.32,523432.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257730',4907624,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257730',4907625,'3041','469',349039.82,352364.07,3324.25,548501.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257730',4907626,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257730',4907627,'3043','469',465073.90,467641.23,2567.33,423609.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257730',4907628,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257730',4907629,'3045','469',444429.25,447331.89,2902.64,478935.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257730',4907630,'3046','469',51196.50,51196.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257730',4907631,'3047','469',382361.56,384516.93,2155.37,355636.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257730',4907632,'3048','469',60803.70,60803.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257730',4907633,'3049','469',513023.62,515113.37,2089.75,344808.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257730',4907634,'3050','469',478467.06,480341.91,1874.85,309350.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257730',4907635,'3051','469',51355.53,51355.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257730',4907636,'3052','469',330787.56,332907.62,2120.06,349809.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257730',4907637,'3053','469',49843.60,49843.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257730',4907638,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257730',4907639,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257731',4907640,'3038','469',11635.52,11635.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257731',4907641,'3039','469',252708.12,254839.55,2131.43,351685.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257731',4907642,'3040','469',36630.02,36630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257731',4907643,'3041','469',352364.07,354618.54,2254.47,371987.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257731',4907644,'3042','469',29445.49,29445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257731',4907645,'3043','469',467641.23,469469.87,1828.64,301725.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257731',4907646,'3044','469',21286.09,21286.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257731',4907647,'3045','469',447331.89,447331.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257731',4907648,'3046','469',51196.50,51722.86,526.36,86849.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257731',4907649,'3047','469',384516.93,387104.42,2587.49,426935.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257731',4907650,'3048','469',60803.70,61313.50,509.80,84117.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257731',4907651,'3049','469',515113.37,518493.89,3380.52,557785.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257731',4907652,'3050','469',480341.91,483023.68,2681.77,442492.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257731',4907653,'3051','469',51355.53,51957.16,601.63,99268.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257731',4907654,'3052','469',332907.62,335729.61,2821.99,465628.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257731',4907655,'3053','469',49843.60,49847.37,3.77,622.05,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257731',4907656,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257731',4907657,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257732',4907658,'3038','469',11635.52,12616.79,971.27,160259.55,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257732',4907659,'3039','469',254839.55,256133.30,1283.75,211818.75,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257732',4907660,'3040','469',36630.02,37962.37,1322.35,218187.75,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257732',4907661,'3041','469',354618.54,355812.92,1184.38,195422.70,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257732',4907662,'3042','469',29445.49,30033.43,577.94,95360.10,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257732',4907663,'3043','469',469469.87,470911.19,1426.32,235342.80,0.00,0.00,15.00,0.00,0.00),('1','203','1026','257732',4907664,'3044','469',21286.09,22744.41,1458.32,240622.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257732',4907665,'3045','469',447331.89,448208.92,877.03,144709.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257732',4907666,'3046','469',51722.86,53291.29,1568.43,258790.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257732',4907667,'3047','469',387104.42,387939.35,834.93,137763.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257732',4907668,'3048','469',61313.50,62698.91,1385.41,228592.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257732',4907669,'3049','469',518493.89,520035.07,1541.18,254294.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257732',4907670,'3050','469',483023.68,484499.34,1475.66,243483.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257732',4907671,'3051','469',51957.16,53341.68,1384.52,228445.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257732',4907672,'3052','469',335729.61,337265.52,1535.91,253425.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257732',4907673,'3053','469',49847.37,50591.61,744.24,122799.60,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257732',4907674,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257732',4907675,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257733',4907676,'3038','469',12616.79,12616.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257733',4907677,'3039','469',256133.30,259849.46,3716.16,613166.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257733',4907678,'3040','469',37962.37,40446.62,2484.25,409901.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257733',4907679,'3041','469',355812.92,358934.68,3121.76,515090.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257733',4907680,'3042','469',30033.43,32283.17,2249.74,371207.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257733',4907681,'3043','469',470911.19,474172.23,3261.04,538071.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257733',4907682,'3044','469',22744.41,22744.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257733',4907683,'3045','469',448208.92,451539.52,3330.60,549549.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257733',4907684,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257733',4907685,'3047','469',387939.35,387939.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257733',4907686,'3048','469',62698.91,62698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257733',4907687,'3049','469',520035.07,520035.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257733',4907688,'3050','469',484499.34,484499.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257733',4907689,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257733',4907690,'3052','469',337265.52,337265.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257733',4907691,'3053','469',50591.61,50591.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257733',4907692,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257733',4907693,'3055','470',69141.44,69141.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257734',4907694,'3038','469',12616.79,12616.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257734',4907695,'3039','469',259849.46,261642.19,1792.73,295800.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257734',4907696,'3040','469',40446.62,40446.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257734',4907697,'3041','469',358934.68,360461.41,1526.73,251910.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257734',4907698,'3042','469',32283.17,32283.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257734',4907699,'3043','469',474172.23,475669.17,1496.94,246995.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257734',4907700,'3044','469',22744.41,22744.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257734',4907701,'3045','469',451539.52,452892.56,1353.04,223251.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257734',4907702,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257734',4907703,'3047','469',387939.35,388622.72,683.37,112756.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257734',4907704,'3048','469',62698.91,62698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257734',4907705,'3049','469',520035.07,520035.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257734',4907706,'3050','469',484499.34,485120.26,620.92,102451.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257734',4907707,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257734',4907708,'3052','469',337265.52,338357.49,1091.97,180175.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257734',4907709,'3053','469',50591.61,50591.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257734',4907710,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257734',4907711,'3055','470',69141.44,70002.30,860.86,602602.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257735',4907712,'3038','469',12616.79,12616.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257735',4907713,'3039','469',261642.19,265310.26,3668.07,605231.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257735',4907714,'3040','469',40446.62,40446.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257735',4907715,'3041','469',360461.41,364064.38,3602.97,594490.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257735',4907716,'3042','469',32283.17,32283.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257735',4907717,'3043','469',475669.17,478027.59,2358.42,389139.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257735',4907718,'3044','469',22744.41,22744.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257735',4907719,'3045','469',452892.56,455738.35,2845.79,469555.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257735',4907720,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257735',4907721,'3047','469',388622.72,388622.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257735',4907722,'3048','469',62698.91,62698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257735',4907723,'3049','469',520035.07,522223.30,2188.23,361057.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257735',4907724,'3050','469',485120.26,488128.15,3007.89,496301.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257735',4907725,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257735',4907726,'3052','469',338357.49,341069.15,2711.66,447423.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257735',4907727,'3053','469',50591.61,50591.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257735',4907728,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257735',4907729,'3055','470',70002.30,70259.30,257.00,179900.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257736',4907730,'3038','469',12616.79,12616.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257736',4907731,'3039','469',265310.26,268292.98,2982.72,492148.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257736',4907732,'3040','469',40446.62,40446.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257736',4907733,'3041','469',364064.38,367263.66,3199.28,527881.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257736',4907734,'3042','469',32283.17,33075.53,792.36,130739.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257736',4907735,'3043','469',478027.59,480649.40,2621.81,432598.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257736',4907736,'3044','469',22744.41,23748.10,1003.69,165608.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257736',4907737,'3045','469',455738.35,456988.57,1250.22,206286.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257736',4907738,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257736',4907739,'3047','469',388622.72,390078.91,1456.19,240271.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257736',4907740,'3048','469',62698.91,62698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257736',4907741,'3049','469',522223.30,523623.74,1400.44,231072.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257736',4907742,'3050','469',488128.15,489451.01,1322.86,218271.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257736',4907743,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257736',4907744,'3052','469',341069.15,341069.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257736',4907745,'3053','469',50591.61,50591.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257736',4907746,'3054','470',9272.43,9272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257736',4907747,'3055','470',70259.30,70624.04,364.74,255318.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257737',4907748,'3038','469',12616.79,12616.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257737',4907749,'3039','469',268292.98,268292.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257737',4907750,'3040','469',40446.62,40446.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257737',4907751,'3041','469',367263.66,367263.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257737',4907752,'3042','469',33075.53,33075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257737',4907753,'3043','469',480649.40,483404.03,2754.63,454513.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257737',4907754,'3044','469',23748.10,23748.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257737',4907755,'3045','469',456988.57,459176.20,2187.63,360958.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257737',4907756,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257737',4907757,'3047','469',390078.91,391561.03,1482.12,244549.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257737',4907758,'3048','469',62698.91,62698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257737',4907759,'3049','469',523623.74,525367.82,1739.08,286948.20,0.00,0.00,5.00,0.00,0.00),('1','203','1027','257737',4907760,'3050','469',489451.01,491246.61,1795.60,296274.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257737',4907761,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257737',4907762,'3052','469',341069.15,342983.32,1914.17,315838.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257737',4907763,'3053','469',50591.61,50591.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257737',4907764,'3054','470',9272.43,9322.43,50.00,35000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257737',4907765,'3055','470',70624.04,71282.19,658.15,460705.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257738',4907766,'3038','469',12616.79,12616.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257738',4907767,'3039','469',268292.98,270905.88,2612.90,431128.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257738',4907768,'3040','469',40446.62,40446.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257738',4907769,'3041','469',367263.66,370233.05,2969.39,489949.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257738',4907770,'3042','469',33075.53,33075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257738',4907771,'3043','469',483404.03,485564.52,2160.49,356480.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257738',4907772,'3044','469',23748.10,23748.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257738',4907773,'3045','469',459176.20,461485.01,2308.81,380953.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257738',4907774,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257738',4907775,'3047','469',391561.03,393859.03,2298.00,379170.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257738',4907776,'3048','469',62698.91,62698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257738',4907777,'3049','469',525367.82,527630.20,2262.38,373292.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257738',4907778,'3050','469',491246.61,493891.80,2645.19,436456.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257738',4907779,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257738',4907780,'3052','469',342983.32,345048.27,2064.95,340716.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257738',4907781,'3053','469',50591.61,50591.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257738',4907782,'3054','470',9322.43,9372.43,50.00,35000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257738',4907783,'3055','470',71282.19,72054.87,772.68,540876.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257739',4907784,'3038','469',12616.79,13508.34,891.55,147105.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257739',4907785,'3039','469',270905.88,271910.11,1004.23,165697.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257739',4907786,'3040','469',40446.62,41467.15,1020.53,168387.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257739',4907787,'3041','469',370233.05,370999.84,766.79,126520.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257739',4907788,'3042','469',33075.53,33075.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257739',4907789,'3043','469',485564.52,487464.01,1899.49,313415.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257739',4907790,'3044','469',23748.10,23748.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257739',4907791,'3045','469',461485.01,463290.68,1805.67,297935.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257739',4907792,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257739',4907793,'3047','469',393859.03,396499.43,2640.40,435666.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257739',4907794,'3048','469',62698.91,63994.41,1295.50,213757.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257739',4907795,'3049','469',527630.20,530435.73,2805.53,462912.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257739',4907796,'3050','469',493891.80,496640.25,2748.45,453494.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257739',4907797,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257739',4907798,'3052','469',345048.27,347644.32,2596.05,428348.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257739',4907799,'3053','469',50591.61,52268.54,1676.93,276693.45,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257739',4907800,'3054','470',9372.43,9372.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257739',4907801,'3055','470',72054.87,72937.07,882.20,617540.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257740',4907802,'3038','469',13508.34,16456.29,2947.95,486411.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257740',4907803,'3039','469',271910.11,275330.92,3420.81,564433.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257740',4907804,'3040','469',41467.15,44276.74,2809.59,463582.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257740',4907805,'3041','469',370999.84,374304.95,3305.11,545343.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257740',4907806,'3042','469',33075.53,35835.20,2759.67,455345.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257740',4907807,'3043','469',487464.01,490399.69,2935.68,484387.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257740',4907808,'3044','469',23748.10,26137.46,2389.36,394244.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257740',4907809,'3045','469',463290.68,463290.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257740',4907810,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257740',4907811,'3047','469',396499.43,396499.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257740',4907812,'3048','469',63994.41,63994.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257740',4907813,'3049','469',530435.73,530435.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257740',4907814,'3050','469',496640.25,496640.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257740',4907815,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257740',4907816,'3052','469',347644.32,347644.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257740',4907817,'3053','469',52268.54,52268.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257740',4907818,'3054','470',9372.43,9422.43,50.00,35000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257740',4907819,'3055','470',72937.07,74140.22,1203.15,842205.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257741',4907820,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257741',4907821,'3039','469',275330.92,275649.13,318.21,52504.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257741',4907822,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257741',4907823,'3041','469',374304.95,374584.34,269.39,44449.35,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257741',4907824,'3042','469',35835.20,35835.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257741',4907825,'3043','469',490399.69,490467.21,67.52,11140.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257741',4907826,'3044','469',26137.46,26346.86,209.40,34551.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257741',4907827,'3045','469',463290.68,464397.31,1106.63,182593.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257741',4907828,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257741',4907829,'3047','469',396499.43,396499.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257741',4907830,'3048','469',63994.41,63994.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257741',4907831,'3049','469',530435.73,530435.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257741',4907832,'3050','469',496640.25,496640.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257741',4907833,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257741',4907834,'3052','469',347644.32,347644.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257741',4907835,'3053','469',52268.54,52268.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257741',4907836,'3054','470',9422.43,9422.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257741',4907837,'3055','470',74140.22,74545.10,404.88,283416.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257742',4907838,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257742',4907839,'3039','469',275649.13,275649.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257742',4907840,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257742',4907841,'3041','469',374584.34,374584.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257742',4907842,'3042','469',35835.20,35835.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257742',4907843,'3043','469',490467.21,492136.32,1669.11,275403.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257742',4907844,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257742',4907845,'3045','469',464397.31,465960.46,1563.15,257919.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257742',4907846,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257742',4907847,'3047','469',396499.43,397859.75,1360.32,224452.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257742',4907848,'3048','469',63994.41,63994.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257742',4907849,'3049','469',530435.73,532335.63,1899.90,313483.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257742',4907850,'3050','469',496640.25,498340.10,1699.85,280475.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257742',4907851,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257742',4907852,'3052','469',347644.32,349440.93,1796.61,296440.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257742',4907853,'3053','469',52268.54,52268.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257742',4907854,'3054','470',9422.43,9919.32,496.89,347823.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257742',4907855,'3055','470',74545.10,75763.21,1218.11,852677.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257743',4907856,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257743',4907857,'3039','469',275649.13,278751.69,3102.56,511922.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257743',4907858,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257743',4907859,'3041','469',374584.34,377745.09,3160.75,521523.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257743',4907860,'3042','469',35835.20,35835.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257743',4907861,'3043','469',492136.32,494815.68,2679.36,442094.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257743',4907862,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257743',4907863,'3045','469',465960.46,469217.98,3257.52,537490.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257743',4907864,'3046','469',53291.29,53291.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257743',4907865,'3047','469',397859.75,400845.35,2985.60,492624.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257743',4907866,'3048','469',63994.41,63994.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257743',4907867,'3049','469',532335.63,533334.08,998.45,164744.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257743',4907868,'3050','469',498340.10,500408.42,2068.32,341272.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257743',4907869,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257743',4907870,'3052','469',349440.93,352282.69,2841.76,468890.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257743',4907871,'3053','469',52268.54,52268.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257743',4907872,'3054','470',9919.32,10628.48,709.16,496412.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257743',4907873,'3055','470',75763.21,75789.79,26.58,18606.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257744',4907874,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257744',4907875,'3039','469',278751.69,279018.16,266.47,43967.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257744',4907876,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257744',4907877,'3041','469',377745.09,378313.40,568.31,93771.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257744',4907878,'3042','469',35835.20,36480.71,645.51,106509.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257744',4907879,'3043','469',494815.68,494815.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257744',4907880,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257744',4907881,'3045','469',469217.98,469428.46,210.48,34729.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257744',4907882,'3046','469',53291.29,56133.45,2842.16,468956.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257744',4907883,'3047','469',400845.35,403947.54,3102.19,511861.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257744',4907884,'3048','469',63994.41,66165.91,2171.50,358297.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257744',4907885,'3049','469',533334.08,536179.77,2845.69,469538.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257744',4907886,'3050','469',500408.42,502777.96,2369.54,390974.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257744',4907887,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257744',4907888,'3052','469',352282.69,356327.07,4044.38,667322.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257744',4907889,'3053','469',52268.54,52268.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257744',4907890,'3054','470',10628.48,10628.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257744',4907891,'3055','470',75789.79,76274.50,480.71,336497.00,0.00,0.00,4.00,0.00,0.00),('1','203','1026','257745',4907892,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257745',4907893,'3039','469',279018.16,282440.74,3412.58,563075.70,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257745',4907894,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257745',4907895,'3041','469',378313.40,381283.32,2969.92,490036.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257745',4907896,'3042','469',36480.71,36480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257745',4907897,'3043','469',494815.68,497170.18,2354.50,388492.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257745',4907898,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257745',4907899,'3045','469',469428.46,469428.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257745',4907900,'3046','469',56133.45,56133.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257745',4907901,'3047','469',403947.54,406390.51,2442.97,403090.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257745',4907902,'3048','469',66165.91,66165.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257745',4907903,'3049','469',536179.77,539053.13,2873.36,474104.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257745',4907904,'3050','469',502777.96,504778.77,2000.81,330133.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257745',4907905,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257745',4907906,'3052','469',356327.07,358749.04,2421.97,399625.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257745',4907907,'3053','469',52268.54,52268.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257745',4907908,'3054','470',10628.48,11361.16,732.68,512876.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257745',4907909,'3055','470',76274.50,77324.93,1050.43,735301.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257746',4907910,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257746',4907911,'3039','469',282440.74,284074.80,1624.06,267969.90,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257746',4907912,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257746',4907913,'3041','469',381283.32,382981.03,1687.71,278472.15,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257746',4907914,'3042','469',36480.71,36480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257746',4907915,'3043','469',497170.18,499013.75,1843.57,304189.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257746',4907916,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257746',4907917,'3045','469',469428.46,470831.11,1402.65,231437.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257746',4907918,'3046','469',56133.45,57078.96,945.51,156009.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257746',4907919,'3047','469',406390.51,409126.40,2735.89,451421.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257746',4907920,'3048','469',66165.91,67735.02,1569.11,258903.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257746',4907921,'3049','469',539053.13,540959.02,1905.89,314471.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257746',4907922,'3050','469',504778.77,506497.51,1718.74,283592.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257746',4907923,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257746',4907924,'3052','469',358749.04,361616.00,2866.96,473048.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257746',4907925,'3053','469',52268.54,52268.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257746',4907926,'3054','470',11361.16,11411.16,50.00,35000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257746',4907927,'3055','470',77324.93,77543.79,218.86,153202.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257747',4907928,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257747',4907929,'3039','469',284074.80,284074.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257747',4907930,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257747',4907931,'3041','469',382981.03,382981.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257747',4907932,'3042','469',36480.71,36480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257747',4907933,'3043','469',499013.75,499013.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257747',4907934,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257747',4907935,'3045','469',470831.11,470831.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257747',4907936,'3046','469',57078.96,57424.45,335.49,55355.85,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257747',4907937,'3047','469',409126.40,411545.47,2409.07,397496.55,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257747',4907938,'3048','469',67735.02,68097.83,355.31,58626.15,0.00,0.00,7.50,0.00,0.00),('1','203','1027','257747',4907939,'3049','469',540959.02,543200.48,2241.46,369840.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257747',4907940,'3050','469',506497.51,509266.47,2768.96,456878.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257747',4907941,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257747',4907942,'3052','469',361616.00,364346.96,2730.96,450608.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257747',4907943,'3053','469',52268.54,52609.81,341.27,56309.55,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257747',4907944,'3054','470',11411.16,11411.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257747',4907945,'3055','470',77543.79,77952.44,408.65,286055.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257748',4907946,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257748',4907947,'3039','469',284074.80,284074.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257748',4907948,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257748',4907949,'3041','469',382981.03,382981.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257748',4907950,'3042','469',36480.71,36480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257748',4907951,'3043','469',499013.75,499013.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257748',4907952,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257748',4907953,'3045','469',470831.11,470831.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257748',4907954,'3046','469',57424.45,60297.06,2872.61,473980.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257748',4907955,'3047','469',411545.47,415097.51,3552.04,586086.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257748',4907956,'3048','469',68097.83,68097.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257748',4907957,'3049','469',543200.48,547546.14,4345.66,717033.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257748',4907958,'3050','469',509266.47,512777.17,3510.70,579265.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257748',4907959,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257748',4907960,'3052','469',364346.96,367889.73,3542.77,584557.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257748',4907961,'3053','469',52609.81,52609.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257748',4907962,'3054','470',11411.16,11461.16,50.00,35000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257748',4907963,'3055','470',77952.44,78404.42,440.98,308686.00,0.00,0.00,11.00,0.00,0.00),('1','203','1026','257749',4907964,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257749',4907965,'3039','469',284074.80,284074.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257749',4907966,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257749',4907967,'3041','469',382981.03,382981.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257749',4907968,'3042','469',36480.71,36480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257749',4907969,'3043','469',499013.75,499013.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257749',4907970,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257749',4907971,'3045','469',470831.11,470831.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257749',4907972,'3046','469',60297.06,60297.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257749',4907973,'3047','469',415097.51,415857.02,759.51,125319.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257749',4907974,'3048','469',68097.83,68097.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257749',4907975,'3049','469',547546.14,548204.71,658.57,108664.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257749',4907976,'3050','469',512777.17,513531.00,753.83,124381.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257749',4907977,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257749',4907978,'3052','469',367889.73,368633.23,743.50,122677.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257749',4907979,'3053','469',52609.81,52609.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257749',4907980,'3054','470',11461.16,11985.45,524.29,367003.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257749',4907981,'3055','470',78404.42,78404.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257750',4907982,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257750',4907983,'3039','469',284074.80,284074.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257750',4907984,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257750',4907985,'3041','469',382981.03,382981.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257750',4907986,'3042','469',36480.71,36480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257750',4907987,'3043','469',499013.75,499013.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257750',4907988,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257750',4907989,'3045','469',470831.11,470831.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257750',4907990,'3046','469',60297.06,60297.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257750',4907991,'3047','469',415857.02,417697.13,1830.11,301968.15,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257750',4907992,'3048','469',68097.83,68097.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257750',4907993,'3049','469',548204.71,550148.50,1933.79,319075.35,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257750',4907994,'3050','469',513531.00,515026.37,1485.37,245086.05,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257750',4907995,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257750',4907996,'3052','469',368633.23,369894.80,1261.57,208159.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257750',4907997,'3053','469',52609.81,52609.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257750',4907998,'3054','470',11985.45,12045.45,60.00,42000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257750',4907999,'3055','470',78404.42,80794.81,2390.39,1673273.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257751',4908000,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257751',4908001,'3039','469',284074.80,284074.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257751',4908002,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257751',4908003,'3041','469',382981.03,382981.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257751',4908004,'3042','469',36480.71,36480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257751',4908005,'3043','469',499013.75,499013.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257751',4908006,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257751',4908007,'3045','469',470831.11,470831.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257751',4908008,'3046','469',60297.06,63148.33,2851.27,470459.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257751',4908009,'3047','469',417697.13,419815.64,2118.51,349554.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257751',4908010,'3048','469',68097.83,70372.63,2274.80,375342.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257751',4908011,'3049','469',550148.50,552370.65,2222.15,366654.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257751',4908012,'3050','469',515026.37,517200.28,2173.91,358695.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257751',4908013,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257751',4908014,'3052','469',369894.80,372484.10,2589.30,427234.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257751',4908015,'3053','469',52609.81,52609.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257751',4908016,'3054','470',12045.45,12105.45,60.00,42000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257751',4908017,'3055','470',80794.81,81877.82,1083.01,758107.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257752',4908018,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257752',4908019,'3039','469',284074.80,284074.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257752',4908020,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257752',4908021,'3041','469',382981.03,382981.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257752',4908022,'3042','469',36480.71,36480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257752',4908023,'3043','469',499013.75,499013.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257752',4908024,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257752',4908025,'3045','469',470831.11,470831.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257752',4908026,'3046','469',63148.33,64323.76,1175.43,193945.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257752',4908027,'3047','469',419815.64,421635.45,1819.81,300268.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257752',4908028,'3048','469',70372.63,71689.68,1317.05,217313.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257752',4908029,'3049','469',552370.65,553743.71,1373.06,226554.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257752',4908030,'3050','469',517200.28,519013.59,1813.31,299196.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257752',4908031,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257752',4908032,'3052','469',372484.10,373120.71,636.61,105040.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257752',4908033,'3053','469',52609.81,53731.06,1121.25,185006.25,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257752',4908034,'3054','470',12105.45,12105.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257752',4908035,'3055','470',81877.82,82389.26,511.44,358008.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257753',4908036,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257753',4908037,'3039','469',284074.80,284074.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257753',4908038,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257753',4908039,'3041','469',382981.03,382981.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257753',4908040,'3042','469',36480.71,36480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257753',4908041,'3043','469',499013.75,499013.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257753',4908042,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257753',4908043,'3045','469',470831.11,470831.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257753',4908044,'3046','469',64323.76,65902.30,1578.54,260459.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257753',4908045,'3047','469',421635.45,423094.66,1459.21,240769.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257753',4908046,'3048','469',71689.68,73077.16,1387.48,228934.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257753',4908047,'3049','469',553743.71,555355.88,1612.17,266008.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257753',4908048,'3050','469',519013.59,520722.66,1709.07,281996.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257753',4908049,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257753',4908050,'3052','469',373120.71,375198.91,2078.20,342903.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257753',4908051,'3053','469',53731.06,53731.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257753',4908052,'3054','470',12105.45,12165.45,60.00,42000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257753',4908053,'3055','470',82389.26,83069.97,680.71,476497.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257754',4908054,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257754',4908055,'3039','469',284074.80,287003.08,2928.28,483166.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257754',4908056,'3040','469',44276.74,44276.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257754',4908057,'3041','469',382981.03,385851.01,2869.98,473546.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257754',4908058,'3042','469',36480.71,36480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257754',4908059,'3043','469',499013.75,501038.14,2024.39,334024.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257754',4908060,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257754',4908061,'3045','469',470831.11,473126.46,2295.35,378732.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257754',4908062,'3046','469',65902.30,67344.20,1441.90,237913.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257754',4908063,'3047','469',423094.66,424481.03,1386.37,228751.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257754',4908064,'3048','469',73077.16,74101.73,1024.57,169054.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257754',4908065,'3049','469',555355.88,557048.28,1692.40,279246.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257754',4908066,'3050','469',520722.66,522338.76,1616.10,266656.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257754',4908067,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257754',4908068,'3052','469',375198.91,376435.81,1236.90,204088.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257754',4908069,'3053','469',53731.06,54692.72,961.66,158673.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257754',4908070,'3054','470',12165.45,12165.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257754',4908071,'3055','470',83069.97,83566.96,496.99,347893.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257755',4908072,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257755',4908073,'3039','469',287003.08,289727.15,2724.07,449471.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257755',4908074,'3040','469',44276.74,46141.85,1865.11,307743.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257755',4908075,'3041','469',385851.01,387629.51,1778.50,293452.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257755',4908076,'3042','469',36480.71,38112.83,1632.12,269299.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257755',4908077,'3043','469',501038.14,502969.15,1931.01,318616.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257755',4908078,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257755',4908079,'3045','469',473126.46,475476.37,2349.91,387735.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257755',4908080,'3046','469',67344.20,67344.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257755',4908081,'3047','469',424481.03,424481.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257755',4908082,'3048','469',74101.73,74101.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257755',4908083,'3049','469',557048.28,557048.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257755',4908084,'3050','469',522338.76,522338.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257755',4908085,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257755',4908086,'3052','469',376435.81,376435.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257755',4908087,'3053','469',54692.72,54692.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257755',4908088,'3054','470',12165.45,12225.45,35.00,24500.00,0.00,0.00,25.00,0.00,0.00),('1','203','1028','257755',4908089,'3055','470',83566.96,83761.53,169.57,118699.00,0.00,0.00,25.00,0.00,0.00),('1','203','1026','257756',4908090,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257756',4908091,'3039','469',289727.15,291347.80,1620.65,267407.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257756',4908092,'3040','469',46141.85,46141.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257756',4908093,'3041','469',387629.51,389100.64,1471.13,242736.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257756',4908094,'3042','469',38112.83,38112.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257756',4908095,'3043','469',502969.15,504216.95,1247.80,205887.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257756',4908096,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257756',4908097,'3045','469',475476.37,476902.53,1426.16,235316.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257756',4908098,'3046','469',67344.20,67344.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257756',4908099,'3047','469',424481.03,425012.49,531.46,87690.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257756',4908100,'3048','469',74101.73,74101.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257756',4908101,'3049','469',557048.28,557710.44,662.16,109256.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257756',4908102,'3050','469',522338.76,522860.32,521.56,86057.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257756',4908103,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257756',4908104,'3052','469',376435.81,377003.55,567.74,93677.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257756',4908105,'3053','469',54692.72,54692.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257756',4908106,'3054','470',12225.45,12225.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257756',4908107,'3055','470',83761.53,83761.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257757',4908108,'3038','469',16456.29,16456.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257757',4908109,'3039','469',291347.80,294782.94,3435.14,566798.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257757',4908110,'3040','469',46141.85,46141.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257757',4908111,'3041','469',389100.64,392449.93,3349.29,552632.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257757',4908112,'3042','469',38112.83,38112.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257757',4908113,'3043','469',504216.95,507224.79,3007.84,496293.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257757',4908114,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257757',4908115,'3045','469',476902.53,479689.73,2787.20,459888.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257757',4908116,'3046','469',67344.20,67344.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257757',4908117,'3047','469',425012.49,428088.79,3076.30,507589.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257757',4908118,'3048','469',74101.73,74101.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257757',4908119,'3049','469',557710.44,557710.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257757',4908120,'3050','469',522860.32,525483.15,2622.83,432766.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257757',4908121,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257757',4908122,'3052','469',377003.55,379703.23,2699.68,445447.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257757',4908123,'3053','469',54692.72,54692.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257757',4908124,'3054','470',12225.45,12225.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257757',4908125,'3055','470',83761.53,83761.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257758',4908126,'3038','469',16456.29,16802.49,346.20,57123.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257758',4908127,'3039','469',294782.94,298480.09,3697.15,610029.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257758',4908128,'3040','469',46141.85,46512.67,370.82,61185.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257758',4908129,'3041','469',392449.93,396040.46,3590.53,592437.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257758',4908130,'3042','469',38112.83,38599.72,486.89,80336.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257758',4908131,'3043','469',507224.79,510767.70,3542.91,584580.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257758',4908132,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257758',4908133,'3045','469',479689.73,482691.76,3002.03,495334.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257758',4908134,'3046','469',67344.20,67962.03,617.83,101941.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257758',4908135,'3047','469',428088.79,430669.89,2581.10,425881.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257758',4908136,'3048','469',74101.73,74584.98,483.25,79736.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257758',4908137,'3049','469',557710.44,559602.87,1892.43,312250.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257758',4908138,'3050','469',525483.15,528534.57,3051.42,503484.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257758',4908139,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257758',4908140,'3052','469',379703.23,383049.20,3345.97,552085.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257758',4908141,'3053','469',54692.72,55212.54,519.82,85770.30,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257758',4908142,'3054','470',12225.45,12225.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257758',4908143,'3055','470',83761.53,83761.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257759',4908144,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257759',4908145,'3039','469',298480.09,301283.60,2803.51,462579.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257759',4908146,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257759',4908147,'3041','469',396040.46,398488.81,2448.35,403977.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257759',4908148,'3042','469',38599.72,38599.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257759',4908149,'3043','469',510767.70,513962.13,3194.43,527080.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257759',4908150,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257759',4908151,'3045','469',482691.76,484861.17,2169.41,357952.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257759',4908152,'3046','469',67962.03,67962.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257759',4908153,'3047','469',430669.89,430669.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257759',4908154,'3048','469',74584.98,74584.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257759',4908155,'3049','469',559602.87,562711.84,3108.97,512980.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257759',4908156,'3050','469',528534.57,530968.33,2433.76,401570.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257759',4908157,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257759',4908158,'3052','469',383049.20,385363.90,2314.70,381925.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257759',4908159,'3053','469',55212.54,55212.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257759',4908160,'3054','470',12225.45,12574.89,349.44,244608.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257759',4908161,'3055','470',83761.53,85017.17,1255.64,878948.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257760',4908162,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257760',4908163,'3039','469',301283.60,301725.04,441.44,72837.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257760',4908164,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257760',4908165,'3041','469',398488.81,398999.72,510.91,84300.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257760',4908166,'3042','469',38599.72,38599.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257760',4908167,'3043','469',513962.13,514273.89,301.76,49790.40,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257760',4908168,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257760',4908169,'3045','469',484861.17,485268.85,407.68,67267.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257760',4908170,'3046','469',67962.03,67962.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257760',4908171,'3047','469',430669.89,433511.47,2841.58,468860.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257760',4908172,'3048','469',74584.98,76307.01,1722.03,284134.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257760',4908173,'3049','469',562711.84,565286.64,2568.80,423852.00,0.00,0.00,6.00,0.00,0.00),('1','203','1027','257760',4908174,'3050','469',530968.33,534295.86,3317.53,547392.45,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257760',4908175,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257760',4908176,'3052','469',385363.90,388427.78,3053.88,503890.20,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257760',4908177,'3053','469',55212.54,55212.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257760',4908178,'3054','470',12574.89,12616.31,41.42,28994.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257760',4908179,'3055','470',85017.17,85211.60,151.86,106302.00,0.00,0.00,42.57,0.00,0.00),('1','203','1026','257761',4908180,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257761',4908181,'3039','469',301725.04,306636.38,4911.34,810371.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257761',4908182,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257761',4908183,'3041','469',398999.72,404062.57,5062.85,835370.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257761',4908184,'3042','469',38599.72,42330.14,3730.42,615519.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257761',4908185,'3043','469',514273.89,517989.45,3715.56,613067.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257761',4908186,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257761',4908187,'3045','469',485268.85,489996.03,4727.18,779984.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257761',4908188,'3046','469',67962.03,67962.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257761',4908189,'3047','469',433511.47,433511.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257761',4908190,'3048','469',76307.01,76307.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257761',4908191,'3049','469',565286.64,565286.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257761',4908192,'3050','469',534295.86,534295.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257761',4908193,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257761',4908194,'3052','469',388427.78,388427.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257761',4908195,'3053','469',55212.54,55212.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257761',4908196,'3054','470',12616.31,12616.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257761',4908197,'3055','470',85211.60,85851.54,639.94,447958.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257762',4908198,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257762',4908199,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257762',4908200,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257762',4908201,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257762',4908202,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257762',4908203,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257762',4908204,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257762',4908205,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257762',4908206,'3046','469',67962.03,69507.30,1545.27,254969.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257762',4908207,'3047','469',433511.47,435265.53,1754.06,289419.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257762',4908208,'3048','469',76307.01,77202.87,895.86,147816.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257762',4908209,'3049','469',565286.64,567543.24,2256.60,372339.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257762',4908210,'3050','469',534295.86,536142.51,1846.65,304697.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257762',4908211,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257762',4908212,'3052','469',388427.78,390885.27,2445.49,403505.85,0.00,0.00,12.00,0.00,0.00),('1','203','1027','257762',4908213,'3053','469',55212.54,55212.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257762',4908214,'3054','470',12616.31,12616.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257762',4908215,'3055','470',85851.54,87314.71,1463.17,1024219.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257763',4908216,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257763',4908217,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257763',4908218,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257763',4908219,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257763',4908220,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257763',4908221,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257763',4908222,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257763',4908223,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257763',4908224,'3046','469',69507.30,69507.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257763',4908225,'3047','469',435265.53,439056.75,3791.22,625551.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257763',4908226,'3048','469',77202.87,79558.43,2355.56,388667.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257763',4908227,'3049','469',567543.24,570598.14,3054.90,504058.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257763',4908228,'3050','469',536142.51,539598.58,3456.07,570251.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257763',4908229,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257763',4908230,'3052','469',390885.27,394751.17,3865.90,637873.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257763',4908231,'3053','469',55212.54,55212.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257763',4908232,'3054','470',12616.31,12616.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257763',4908233,'3055','470',87314.71,88125.13,810.42,567294.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257764',4908234,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257764',4908235,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257764',4908236,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257764',4908237,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257764',4908238,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257764',4908239,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257764',4908240,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257764',4908241,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257764',4908242,'3046','469',69507.30,69507.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257764',4908243,'3047','469',439056.75,439929.92,873.17,144073.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257764',4908244,'3048','469',79558.43,79558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257764',4908245,'3049','469',570598.14,571412.42,814.28,134356.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257764',4908246,'3050','469',539598.58,540406.61,808.03,133324.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257764',4908247,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257764',4908248,'3052','469',394751.17,395145.06,393.89,64991.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257764',4908249,'3053','469',55212.54,55212.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257764',4908250,'3054','470',12616.31,12616.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257764',4908251,'3055','470',88125.13,88351.41,226.28,158396.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257765',4908252,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257765',4908253,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257765',4908254,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257765',4908255,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257765',4908256,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257765',4908257,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257765',4908258,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257765',4908259,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257765',4908260,'3046','469',69507.30,69507.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257765',4908261,'3047','469',439929.92,439929.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257765',4908262,'3048','469',79558.43,79558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257765',4908263,'3049','469',571412.42,571412.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257765',4908264,'3050','469',540406.61,540406.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257765',4908265,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257765',4908266,'3052','469',395145.06,395145.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257765',4908267,'3053','469',55212.54,55212.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257765',4908268,'3054','470',12616.31,12662.58,46.27,32389.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257765',4908269,'3055','470',88351.41,89205.19,853.78,597646.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257766',4908270,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257766',4908271,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257766',4908272,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257766',4908273,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257766',4908274,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257766',4908275,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257766',4908276,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257766',4908277,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257766',4908278,'3046','469',69507.30,69507.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257766',4908279,'3047','469',439929.92,442208.54,2246.81,370723.65,0.00,0.00,31.81,0.00,0.00),('1','203','1027','257766',4908280,'3048','469',79558.43,79558.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257766',4908281,'3049','469',571412.42,574227.94,2805.52,462910.80,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257766',4908282,'3050','469',540406.61,542910.80,2504.19,413191.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257766',4908283,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257766',4908284,'3052','469',395145.06,397904.44,2759.38,455297.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257766',4908285,'3053','469',55212.54,55212.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257766',4908286,'3054','470',12662.58,13127.35,464.77,325339.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257766',4908287,'3055','470',89205.19,89811.77,586.13,410291.00,0.00,0.00,20.45,0.00,0.00),('1','203','1026','257767',4908288,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257767',4908289,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257767',4908290,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257767',4908291,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257767',4908292,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257767',4908293,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257767',4908294,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257767',4908295,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257767',4908296,'3046','469',69507.30,71213.77,1706.47,281567.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257767',4908297,'3047','469',442208.54,443851.85,1643.31,271146.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257767',4908298,'3048','469',79558.43,80750.09,1191.66,196623.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257767',4908299,'3049','469',574227.94,576451.93,2223.99,366958.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257767',4908300,'3050','469',542910.80,544783.42,1872.62,308982.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257767',4908301,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257767',4908302,'3052','469',397904.44,399600.70,1696.26,279882.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257767',4908303,'3053','469',55212.54,56605.86,1393.32,229897.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257767',4908304,'3054','470',13127.35,13127.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257767',4908305,'3055','470',89811.77,91030.42,1218.65,853055.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257768',4908306,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257768',4908307,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257768',4908308,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257768',4908309,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257768',4908310,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257768',4908311,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257768',4908312,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257768',4908313,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257768',4908314,'3046','469',71213.77,71213.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257768',4908315,'3047','469',443851.85,443851.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257768',4908316,'3048','469',80750.09,80750.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257768',4908317,'3049','469',576451.93,576451.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257768',4908318,'3050','469',544783.42,544783.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257768',4908319,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257768',4908320,'3052','469',399600.70,399600.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257768',4908321,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257768',4908322,'3054','470',13127.35,13228.66,101.31,70917.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257768',4908323,'3055','470',91030.42,91377.56,347.14,242998.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257769',4908324,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257769',4908325,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257769',4908326,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257769',4908327,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257769',4908328,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257769',4908329,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257769',4908330,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257769',4908331,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257769',4908332,'3046','469',71213.77,71213.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257769',4908333,'3047','469',443851.85,443851.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257769',4908334,'3048','469',80750.09,80750.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257769',4908335,'3049','469',576451.93,576451.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257769',4908336,'3050','469',544783.42,544783.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257769',4908337,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257769',4908338,'3052','469',399600.70,399600.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257769',4908339,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257769',4908340,'3054','470',13228.66,13623.51,394.85,276395.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257769',4908341,'3055','470',91377.56,91829.07,451.51,316057.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257770',4908342,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257770',4908343,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257770',4908344,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257770',4908345,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257770',4908346,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257770',4908347,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257770',4908348,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257770',4908349,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257770',4908350,'3046','469',71213.77,71213.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257770',4908351,'3047','469',443851.85,447420.07,3568.22,588756.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257770',4908352,'3048','469',80750.09,80750.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257770',4908353,'3049','469',576451.93,580611.16,4159.23,686272.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257770',4908354,'3050','469',544783.42,548383.31,3599.89,593981.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257770',4908355,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257770',4908356,'3052','469',399600.70,400722.92,1092.22,180216.30,0.00,0.00,30.00,0.00,0.00),('1','203','1027','257770',4908357,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257770',4908358,'3054','470',13623.51,14003.12,369.61,258727.00,0.00,0.00,10.00,0.00,0.00),('1','203','1028','257770',4908359,'3055','470',91829.07,92311.50,463.15,324205.00,0.00,0.00,19.28,0.00,0.00),('1','203','1026','257771',4908360,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257771',4908361,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257771',4908362,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257771',4908363,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257771',4908364,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257771',4908365,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257771',4908366,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257771',4908367,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257771',4908368,'3046','469',71213.77,71213.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257771',4908369,'3047','469',447420.07,450513.19,3093.12,510364.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257771',4908370,'3048','469',80750.09,80750.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257771',4908371,'3049','469',580611.16,583818.07,3196.91,527490.15,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257771',4908372,'3050','469',548383.31,551239.35,2856.04,471246.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257771',4908373,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257771',4908374,'3052','469',400722.92,401359.18,636.26,104982.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257771',4908375,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257771',4908376,'3054','470',14003.12,14003.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257771',4908377,'3055','470',92311.50,92663.20,351.70,246190.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257772',4908378,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257772',4908379,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257772',4908380,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257772',4908381,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257772',4908382,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257772',4908383,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257772',4908384,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257772',4908385,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257772',4908386,'3046','469',71213.77,71213.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257772',4908387,'3047','469',450513.19,453442.07,2928.88,483265.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257772',4908388,'3048','469',80750.09,80750.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257772',4908389,'3049','469',583818.07,587223.07,3405.00,561825.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257772',4908390,'3050','469',551239.35,554291.08,3035.67,500885.55,0.00,0.00,16.06,0.00,0.00),('1','203','1027','257772',4908391,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257772',4908392,'3052','469',401359.18,402737.32,1378.14,227393.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257772',4908393,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257772',4908394,'3054','470',14003.12,14003.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257772',4908395,'3055','470',92663.20,93475.02,811.82,568274.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257773',4908396,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257773',4908397,'3039','469',306636.38,306636.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257773',4908398,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257773',4908399,'3041','469',404062.57,404062.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257773',4908400,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257773',4908401,'3043','469',517989.45,517989.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257773',4908402,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257773',4908403,'3045','469',489996.03,489996.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257773',4908404,'3046','469',71213.77,71213.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257773',4908405,'3047','469',453442.07,457360.57,3918.50,646552.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257773',4908406,'3048','469',80750.09,80750.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257773',4908407,'3049','469',587223.07,592526.92,5303.85,875135.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257773',4908408,'3050','469',554291.08,558418.44,4127.36,681014.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257773',4908409,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257773',4908410,'3052','469',402737.32,402737.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257773',4908411,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257773',4908412,'3054','470',14003.12,14003.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257773',4908413,'3055','470',93475.02,94759.47,1284.45,899115.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257774',4908414,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257774',4908415,'3039','469',306636.38,309164.38,2528.00,417120.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257774',4908416,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257774',4908417,'3041','469',404062.57,406903.00,2840.43,468670.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257774',4908418,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257774',4908419,'3043','469',517989.45,520343.07,2353.62,388347.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257774',4908420,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257774',4908421,'3045','469',489996.03,490546.06,550.03,90754.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257774',4908422,'3046','469',71213.77,71213.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257774',4908423,'3047','469',457360.57,458629.76,1269.19,209416.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257774',4908424,'3048','469',80750.09,80750.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257774',4908425,'3049','469',592526.92,594102.45,1575.53,259962.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257774',4908426,'3050','469',558418.44,559617.00,1198.56,197762.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257774',4908427,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257774',4908428,'3052','469',402737.32,404162.25,1414.93,233463.45,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257774',4908429,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257774',4908430,'3054','470',14003.12,14951.32,948.20,663740.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257774',4908431,'3055','470',94759.47,95019.20,259.73,181811.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257775',4908432,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257775',4908433,'3039','469',309164.38,311699.76,2535.38,418337.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257775',4908434,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257775',4908435,'3041','469',406903.00,409859.04,2956.04,487746.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257775',4908436,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257775',4908437,'3043','469',520343.07,522840.64,2497.57,412099.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257775',4908438,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257775',4908439,'3045','469',490546.06,490791.59,242.53,40017.45,0.00,0.00,3.00,0.00,0.00),('1','203','1027','257775',4908440,'3046','469',71213.77,71213.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257775',4908441,'3047','469',458629.76,458629.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257775',4908442,'3048','469',80750.09,80750.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257775',4908443,'3049','469',594102.45,594102.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257775',4908444,'3050','469',559617.00,559617.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257775',4908445,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257775',4908446,'3052','469',404162.25,404162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257775',4908447,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257775',4908448,'3054','470',14951.32,14951.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257775',4908449,'3055','470',95019.20,95019.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257776',4908450,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257776',4908451,'3039','469',311699.76,311699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257776',4908452,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257776',4908453,'3041','469',409859.04,409859.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257776',4908454,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257776',4908455,'3043','469',522840.64,522840.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257776',4908456,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257776',4908457,'3045','469',490791.59,491338.81,547.22,90291.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257776',4908458,'3046','469',71213.77,71213.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257776',4908459,'3047','469',458629.76,458629.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257776',4908460,'3048','469',80750.09,80750.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257776',4908461,'3049','469',594102.45,594102.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257776',4908462,'3050','469',559617.00,559617.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257776',4908463,'3051','469',53341.68,53341.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257776',4908464,'3052','469',404162.25,404162.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257776',4908465,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257776',4908466,'3054','470',14951.32,15589.64,638.32,446824.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257776',4908467,'3055','470',95019.20,96464.85,1445.65,1011955.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257777',4908468,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257777',4908469,'3039','469',311699.76,311699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257777',4908470,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257777',4908471,'3041','469',409859.04,409859.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257777',4908472,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257777',4908473,'3043','469',522840.64,522840.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257777',4908474,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257777',4908475,'3045','469',491338.81,491548.92,210.11,34668.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257777',4908476,'3046','469',71213.77,73111.16,1897.39,313069.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257777',4908477,'3047','469',458629.76,460945.45,2315.69,382088.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257777',4908478,'3048','469',80750.09,83294.36,2544.27,419804.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257777',4908479,'3049','469',594102.45,595973.36,1870.91,308700.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257777',4908480,'3050','469',559617.00,561892.94,2275.94,375530.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257777',4908481,'3051','469',53341.68,55625.84,2284.16,376886.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257777',4908482,'3052','469',404162.25,404526.70,352.45,58154.25,0.00,0.00,12.00,0.00,0.00),('1','203','1027','257777',4908483,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257777',4908484,'3054','470',15589.64,16365.59,775.95,543165.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257777',4908485,'3055','470',96464.85,97208.21,743.36,520352.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257778',4908486,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257778',4908487,'3039','469',311699.76,311699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257778',4908488,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257778',4908489,'3041','469',409859.04,409859.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257778',4908490,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257778',4908491,'3043','469',522840.64,522840.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257778',4908492,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257778',4908493,'3045','469',491548.92,493444.89,1895.97,312835.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257778',4908494,'3046','469',73111.16,73111.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257778',4908495,'3047','469',460945.45,463123.11,2177.66,359313.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257778',4908496,'3048','469',83294.36,83294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257778',4908497,'3049','469',595973.36,597744.52,1771.16,292241.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257778',4908498,'3050','469',561892.94,564003.37,2110.43,348220.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257778',4908499,'3051','469',55625.84,55625.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257778',4908500,'3052','469',404526.70,404752.11,225.41,37192.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257778',4908501,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257778',4908502,'3054','470',16365.59,16692.22,326.63,228641.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257778',4908503,'3055','470',97208.21,97670.48,462.27,323589.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257779',4908504,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257779',4908505,'3039','469',311699.76,311699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257779',4908506,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257779',4908507,'3041','469',409859.04,409859.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257779',4908508,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257779',4908509,'3043','469',522840.64,522840.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257779',4908510,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257779',4908511,'3045','469',493444.89,493589.52,144.63,23863.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257779',4908512,'3046','469',73111.16,76593.41,3482.25,574571.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257779',4908513,'3047','469',463123.11,467506.91,4383.80,723327.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257779',4908514,'3048','469',83294.36,87788.28,4493.92,741496.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257779',4908515,'3049','469',597744.52,602226.76,4482.24,739569.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257779',4908516,'3050','469',564003.37,567116.03,3112.66,513588.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257779',4908517,'3051','469',55625.84,58553.70,2927.86,483096.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257779',4908518,'3052','469',404752.11,405195.45,443.34,73151.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257779',4908519,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257779',4908520,'3054','470',16692.22,16692.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257779',4908521,'3055','470',97670.48,99222.43,1551.95,1117404.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257780',4908522,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257780',4908523,'3039','469',311699.76,311699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257780',4908524,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257780',4908525,'3041','469',409859.04,409859.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257780',4908526,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257780',4908527,'3043','469',522840.64,522840.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257780',4908528,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257780',4908529,'3045','469',493589.52,493589.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257780',4908530,'3046','469',76593.41,76593.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257780',4908531,'3047','469',467506.91,469718.77,2211.86,364956.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257780',4908532,'3048','469',87788.28,87788.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257780',4908533,'3049','469',602226.76,604490.14,2263.38,373457.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257780',4908534,'3050','469',567116.03,569221.78,2105.75,347448.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257780',4908535,'3051','469',58553.70,58553.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257780',4908536,'3052','469',405195.45,405356.44,160.99,26563.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257780',4908537,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257780',4908538,'3054','470',16692.22,16738.44,46.22,33278.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257780',4908539,'3055','470',99222.43,99336.87,114.44,82396.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257781',4908540,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257781',4908541,'3039','469',311699.76,311699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257781',4908542,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257781',4908543,'3041','469',409859.04,409859.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257781',4908544,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257781',4908545,'3043','469',522840.64,522840.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257781',4908546,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257781',4908547,'3045','469',493589.52,496428.22,2818.70,465085.50,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257781',4908548,'3046','469',76593.41,76593.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257781',4908549,'3047','469',469718.77,473369.89,3631.12,599134.80,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257781',4908550,'3048','469',87788.28,89895.01,2106.73,347610.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257781',4908551,'3049','469',604490.14,608197.55,3707.41,611722.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257781',4908552,'3050','469',569221.78,573773.39,4551.61,751015.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257781',4908553,'3051','469',58553.70,58553.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257781',4908554,'3052','469',405356.44,405561.58,205.14,33848.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257781',4908555,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257781',4908556,'3054','470',16738.44,17284.74,546.30,393336.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257781',4908557,'3055','470',99336.87,99455.06,118.19,85096.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257782',4908558,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257782',4908559,'3039','469',311699.76,311699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257782',4908560,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257782',4908561,'3041','469',409859.04,409859.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257782',4908562,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257782',4908563,'3043','469',522840.64,522840.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257782',4908564,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257782',4908565,'3045','469',496428.22,496428.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257782',4908566,'3046','469',76593.41,76593.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257782',4908567,'3047','469',473369.89,474258.90,889.01,146686.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257782',4908568,'3048','469',89895.01,89895.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257782',4908569,'3049','469',608197.55,609227.85,1030.30,169999.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257782',4908570,'3050','469',573773.39,574684.23,910.84,150288.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257782',4908571,'3051','469',58553.70,58553.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257782',4908572,'3052','469',405561.58,405561.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257782',4908573,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257782',4908574,'3054','470',17284.74,17298.91,14.17,10202.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257782',4908575,'3055','470',99455.06,99662.65,207.59,149464.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257783',4908576,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257783',4908577,'3039','469',311699.76,311699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257783',4908578,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257783',4908579,'3041','469',409859.04,409859.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257783',4908580,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257783',4908581,'3043','469',522840.64,522840.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257783',4908582,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257783',4908583,'3045','469',496428.22,496428.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257783',4908584,'3046','469',76593.41,76988.26,394.85,65150.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257783',4908585,'3047','469',474258.90,476992.71,2733.81,451078.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257783',4908586,'3048','469',89895.01,92329.34,2434.33,401664.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257783',4908587,'3049','469',609227.85,611945.84,2717.99,448468.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257783',4908588,'3050','469',574684.23,577160.99,2476.76,408665.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257783',4908589,'3051','469',58553.70,60643.78,2090.08,344863.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257783',4908590,'3052','469',405561.58,408294.72,2727.14,449978.10,0.00,0.00,6.00,0.00,0.00),('1','203','1027','257783',4908591,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257783',4908592,'3054','470',17298.91,17433.32,134.41,96775.20,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257783',4908593,'3055','470',99662.65,100377.38,714.73,514605.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257784',4908594,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257784',4908595,'3039','469',311699.76,311699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257784',4908596,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257784',4908597,'3041','469',409859.04,409859.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257784',4908598,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257784',4908599,'3043','469',522840.64,522840.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257784',4908600,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257784',4908601,'3045','469',496428.22,496428.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257784',4908602,'3046','469',76988.26,76991.29,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257784',4908603,'3047','469',476992.71,479527.81,2535.10,418291.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257784',4908604,'3048','469',92329.34,94740.08,2410.74,397772.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257784',4908605,'3049','469',611945.84,614456.22,2510.38,414212.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257784',4908606,'3050','469',577160.99,579549.65,2388.66,394128.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257784',4908607,'3051','469',60643.78,60643.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257784',4908608,'3052','469',408294.72,410582.44,2287.72,377473.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257784',4908609,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257784',4908610,'3054','470',17433.32,17433.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257784',4908611,'3055','470',100377.38,101804.06,1426.68,1027209.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257785',4908612,'3038','469',16802.49,16802.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257785',4908613,'3039','469',311699.76,311699.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257785',4908614,'3040','469',46512.67,46512.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257785',4908615,'3041','469',409859.04,409859.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257785',4908616,'3042','469',42330.14,42330.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257785',4908617,'3043','469',522840.64,522840.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257785',4908618,'3044','469',26346.86,26346.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257785',4908619,'3045','469',496428.22,496428.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257785',4908620,'3046','469',76991.29,76991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257785',4908621,'3047','469',479527.81,479527.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257785',4908622,'3048','469',94740.08,94740.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257785',4908623,'3049','469',614456.22,614456.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257785',4908624,'3050','469',579549.65,579549.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257785',4908625,'3051','469',60643.78,60643.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257785',4908626,'3052','469',410582.44,410582.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257785',4908627,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257785',4908628,'3054','470',17433.32,17855.52,422.20,303984.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257785',4908629,'3055','470',101804.06,102347.84,543.78,391521.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257786',4908630,'3038','469',16802.49,20033.81,3231.32,533167.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257786',4908631,'3039','469',311699.76,314685.72,2985.96,492683.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257786',4908632,'3040','469',46512.67,48957.33,2444.66,403368.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257786',4908633,'3041','469',409859.04,412691.67,2832.63,467383.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257786',4908634,'3042','469',42330.14,44244.45,1914.31,315861.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257786',4908635,'3043','469',522840.64,525752.81,2912.17,480508.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257786',4908636,'3044','469',26346.86,28845.87,2499.01,412336.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257786',4908637,'3045','469',496428.22,496428.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257786',4908638,'3046','469',76991.29,76991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257786',4908639,'3047','469',479527.81,480244.95,717.14,118328.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257786',4908640,'3048','469',94740.08,94740.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257786',4908641,'3049','469',614456.22,614994.03,537.81,88738.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257786',4908642,'3050','469',579549.65,580107.34,557.69,92018.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257786',4908643,'3051','469',60643.78,60643.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257786',4908644,'3052','469',410582.44,411168.67,586.23,96727.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257786',4908645,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257786',4908646,'3054','470',17855.52,18066.84,211.32,152150.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257786',4908647,'3055','470',102347.84,102820.45,472.61,340279.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257787',4908648,'3038','469',20033.81,21086.17,1052.36,173639.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257787',4908649,'3039','469',314685.72,315473.62,787.90,130003.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257787',4908650,'3040','469',48957.33,49871.75,914.42,150879.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257787',4908651,'3041','469',412691.67,413758.70,1067.03,176059.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257787',4908652,'3042','469',44244.45,44936.07,691.62,114117.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257787',4908653,'3043','469',525752.81,526483.85,731.04,120621.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257787',4908654,'3044','469',28845.87,30011.91,1166.04,192396.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257787',4908655,'3045','469',496428.22,497180.71,752.49,124160.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257787',4908656,'3046','469',76991.29,76991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257787',4908657,'3047','469',480244.95,480244.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257787',4908658,'3048','469',94740.08,94740.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257787',4908659,'3049','469',614994.03,614994.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257787',4908660,'3050','469',580107.34,580107.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257787',4908661,'3051','469',60643.78,60643.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257787',4908662,'3052','469',411168.67,411168.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257787',4908663,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257787',4908664,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257787',4908665,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257788',4908666,'3038','469',21086.17,24115.09,3018.92,498121.80,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257788',4908667,'3039','469',315473.62,319262.27,3778.65,623477.25,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257788',4908668,'3040','469',49871.75,52772.02,2890.27,476894.55,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257788',4908669,'3041','469',413758.70,416612.55,2843.85,469235.25,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257788',4908670,'3042','469',44936.07,47725.54,2785.37,459586.05,0.00,0.00,4.10,0.00,0.00),('1','203','1026','257788',4908671,'3043','469',526483.85,529671.61,3187.76,525980.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257788',4908672,'3044','469',30011.91,30011.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257788',4908673,'3045','469',497180.71,500829.08,3648.37,601981.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257788',4908674,'3046','469',76991.29,76991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257788',4908675,'3047','469',480244.95,480244.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257788',4908676,'3048','469',94740.08,94740.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257788',4908677,'3049','469',614994.03,614994.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257788',4908678,'3050','469',580107.34,580107.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257788',4908679,'3051','469',60643.78,60643.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257788',4908680,'3052','469',411168.67,411168.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257788',4908681,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257788',4908682,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257788',4908683,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257789',4908684,'3038','469',24115.09,25239.12,1124.03,185464.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257789',4908685,'3039','469',319262.27,320424.16,1161.89,191711.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257789',4908686,'3040','469',52772.02,53690.76,918.74,151592.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257789',4908687,'3041','469',416612.55,417640.09,1027.54,169544.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257789',4908688,'3042','469',47725.54,48705.06,979.52,161620.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257789',4908689,'3043','469',529671.61,530571.89,900.28,148546.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257789',4908690,'3044','469',30011.91,31184.18,1172.27,193424.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257789',4908691,'3045','469',500829.08,501460.61,631.53,104202.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257789',4908692,'3046','469',76991.29,76991.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257789',4908693,'3047','469',480244.95,480244.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257789',4908694,'3048','469',94740.08,94740.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257789',4908695,'3049','469',614994.03,614994.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257789',4908696,'3050','469',580107.34,580107.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257789',4908697,'3051','469',60643.78,60643.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257789',4908698,'3052','469',411168.67,411168.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257789',4908699,'3053','469',56605.86,56605.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257789',4908700,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257789',4908701,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257790',4908702,'3038','469',25239.12,25239.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257790',4908703,'3039','469',320424.16,320424.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257790',4908704,'3040','469',53690.76,53690.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257790',4908705,'3041','469',417640.09,417640.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257790',4908706,'3042','469',48705.06,48705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257790',4908707,'3043','469',530571.89,530571.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257790',4908708,'3044','469',31184.18,31184.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257790',4908709,'3045','469',501460.61,501460.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257790',4908710,'3046','469',76991.29,80309.26,3307.97,545815.05,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257790',4908711,'3047','469',480244.95,484431.45,4186.50,690772.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257790',4908712,'3048','469',94740.08,98426.41,3686.33,608244.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257790',4908713,'3049','469',614994.03,618458.51,3464.48,571639.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257790',4908714,'3050','469',580107.34,584759.72,4652.38,767642.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257790',4908715,'3051','469',60643.78,60986.38,342.60,56529.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257790',4908716,'3052','469',411168.67,414751.52,3582.85,591170.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257790',4908717,'3053','469',56605.86,60088.97,3483.11,574713.15,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257790',4908718,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257790',4908719,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257791',4908720,'3038','469',25239.12,25239.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257791',4908721,'3039','469',320424.16,320424.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257791',4908722,'3040','469',53690.76,53690.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257791',4908723,'3041','469',417640.09,417640.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257791',4908724,'3042','469',48705.06,48705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257791',4908725,'3043','469',530571.89,530571.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257791',4908726,'3044','469',31184.18,31184.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257791',4908727,'3045','469',501460.61,501460.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257791',4908728,'3046','469',80309.26,82455.95,2146.69,354203.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257791',4908729,'3047','469',484431.45,486498.97,2067.52,341140.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257791',4908730,'3048','469',98426.41,99978.89,1552.48,256159.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257791',4908731,'3049','469',618458.51,620012.70,1554.19,256441.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257791',4908732,'3050','469',584759.72,586553.13,1793.41,295912.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257791',4908733,'3051','469',60986.38,61989.17,1002.79,165460.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257791',4908734,'3052','469',414751.52,416122.12,1370.60,226149.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257791',4908735,'3053','469',60088.97,61973.95,1884.98,311021.70,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257791',4908736,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257791',4908737,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257792',4908738,'3038','469',25239.12,25239.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257792',4908739,'3039','469',320424.16,320424.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257792',4908740,'3040','469',53690.76,53690.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257792',4908741,'3041','469',417640.09,417640.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257792',4908742,'3042','469',48705.06,48705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257792',4908743,'3043','469',530571.89,530571.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257792',4908744,'3044','469',31184.18,31184.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257792',4908745,'3045','469',501460.61,501460.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257792',4908746,'3046','469',82455.95,84349.21,1893.26,312387.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257792',4908747,'3047','469',486498.97,488742.00,2243.03,370099.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257792',4908748,'3048','469',99978.89,102087.03,2108.14,347843.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257792',4908749,'3049','469',620012.70,622268.88,2256.18,372269.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257792',4908750,'3050','469',586553.13,588427.06,1873.93,309198.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257792',4908751,'3051','469',61989.17,63785.53,1796.36,296399.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257792',4908752,'3052','469',416122.12,416540.88,418.76,69095.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257792',4908753,'3053','469',61973.95,64430.93,2456.98,405401.70,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257792',4908754,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257792',4908755,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257793',4908756,'3038','469',25239.12,25239.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257793',4908757,'3039','469',320424.16,320424.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257793',4908758,'3040','469',53690.76,53690.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257793',4908759,'3041','469',417640.09,417640.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257793',4908760,'3042','469',48705.06,48705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257793',4908761,'3043','469',530571.89,530571.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257793',4908762,'3044','469',31184.18,31184.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257793',4908763,'3045','469',501460.61,501460.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257793',4908764,'3046','469',84349.21,87135.31,2786.10,459706.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257793',4908765,'3047','469',488742.00,491701.31,2959.31,488286.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257793',4908766,'3048','469',102087.03,104821.76,2734.73,451230.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257793',4908767,'3049','469',622268.88,625417.00,3148.12,519439.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257793',4908768,'3050','469',588427.06,590903.17,2476.11,408558.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257793',4908769,'3051','469',63785.53,66159.98,2374.45,391784.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257793',4908770,'3052','469',416540.88,416540.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257793',4908771,'3053','469',64430.93,67986.12,3555.19,586606.35,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257793',4908772,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257793',4908773,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257794',4908774,'3038','469',25239.12,25239.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257794',4908775,'3039','469',320424.16,320424.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257794',4908776,'3040','469',53690.76,53690.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257794',4908777,'3041','469',417640.09,417640.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257794',4908778,'3042','469',48705.06,48705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257794',4908779,'3043','469',530571.89,530571.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257794',4908780,'3044','469',31184.18,31184.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257794',4908781,'3045','469',501460.61,501460.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257794',4908782,'3046','469',87135.31,87135.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257794',4908783,'3047','469',491701.31,495562.50,3861.19,637096.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257794',4908784,'3048','469',104821.76,104821.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257794',4908785,'3049','469',625417.00,629606.62,4179.62,689637.30,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257794',4908786,'3050','469',590903.17,594762.15,3848.98,635081.70,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257794',4908787,'3051','469',66159.98,66159.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257794',4908788,'3052','469',416540.88,416540.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257794',4908789,'3053','469',67986.12,72084.22,4088.10,674536.50,0.00,0.00,10.00,0.00,0.00),('1','203','1028','257794',4908790,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257794',4908791,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257795',4908792,'3038','469',25239.12,25239.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257795',4908793,'3039','469',320424.16,323539.01,3114.85,513950.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257795',4908794,'3040','469',53690.76,53690.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257795',4908795,'3041','469',417640.09,421058.10,3418.01,563971.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257795',4908796,'3042','469',48705.06,48705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257795',4908797,'3043','469',530571.89,533726.00,3154.11,520428.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257795',4908798,'3044','469',31184.18,31184.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257795',4908799,'3045','469',501460.61,504047.36,2586.75,426813.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257795',4908800,'3046','469',87135.31,87135.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257795',4908801,'3047','469',495562.50,495562.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257795',4908802,'3048','469',104821.76,104821.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257795',4908803,'3049','469',629606.62,629606.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257795',4908804,'3050','469',594762.15,594762.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257795',4908805,'3051','469',66159.98,66159.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257795',4908806,'3052','469',416540.88,416540.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257795',4908807,'3053','469',72084.22,72084.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257795',4908808,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257795',4908809,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257796',4908810,'3038','469',25239.12,25239.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257796',4908811,'3039','469',323539.01,323539.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257796',4908812,'3040','469',53690.76,53690.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257796',4908813,'3041','469',421058.10,421058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257796',4908814,'3042','469',48705.06,48705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257796',4908815,'3043','469',533726.00,533726.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257796',4908816,'3044','469',31184.18,31184.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257796',4908817,'3045','469',504047.36,504140.29,92.93,15333.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257796',4908818,'3046','469',87135.31,87135.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257796',4908819,'3047','469',495562.50,497960.81,2398.31,395721.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257796',4908820,'3048','469',104821.76,104821.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257796',4908821,'3049','469',629606.62,632192.62,2586.00,426690.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257796',4908822,'3050','469',594762.15,596748.59,1986.44,327762.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257796',4908823,'3051','469',66159.98,66159.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257796',4908824,'3052','469',416540.88,416583.30,42.42,6999.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257796',4908825,'3053','469',72084.22,74570.49,2486.27,410234.55,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257796',4908826,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257796',4908827,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257797',4908828,'3038','469',25239.12,25239.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257797',4908829,'3039','469',323539.01,323539.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257797',4908830,'3040','469',53690.76,53690.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257797',4908831,'3041','469',421058.10,421058.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257797',4908832,'3042','469',48705.06,48705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257797',4908833,'3043','469',533726.00,533726.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257797',4908834,'3044','469',31184.18,31184.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257797',4908835,'3045','469',504140.29,504140.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257797',4908836,'3046','469',87135.31,87135.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257797',4908837,'3047','469',497960.81,500624.98,2664.17,439588.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257797',4908838,'3048','469',104821.76,104821.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257797',4908839,'3049','469',632192.62,635033.05,2840.43,468670.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257797',4908840,'3050','469',596748.59,599457.97,2709.38,447047.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257797',4908841,'3051','469',66159.98,66159.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257797',4908842,'3052','469',416583.30,419005.13,2421.83,399601.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257797',4908843,'3053','469',74570.49,74570.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257797',4908844,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257797',4908845,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257798',4908846,'3038','469',25239.12,25239.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257798',4908847,'3039','469',323539.01,323896.05,357.04,58911.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257798',4908848,'3040','469',53690.76,53690.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257798',4908849,'3041','469',421058.10,421648.79,584.63,96463.95,0.00,0.00,6.06,0.00,0.00),('1','203','1026','257798',4908850,'3042','469',48705.06,48705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257798',4908851,'3043','469',533726.00,534081.24,355.24,58614.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257798',4908852,'3044','469',31184.18,31184.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257798',4908853,'3045','469',504140.29,504471.53,331.24,54654.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257798',4908854,'3046','469',87135.31,89298.20,2162.89,356876.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257798',4908855,'3047','469',500624.98,503466.93,2841.95,468921.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257798',4908856,'3048','469',104821.76,107589.45,2767.69,456668.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257798',4908857,'3049','469',635033.05,637440.72,2407.67,397265.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257798',4908858,'3050','469',599457.97,601656.60,2198.63,362773.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257798',4908859,'3051','469',66159.98,67710.49,1550.51,255834.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257798',4908860,'3052','469',419005.13,419005.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257798',4908861,'3053','469',74570.49,77772.35,3201.86,528306.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257798',4908862,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257798',4908863,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257799',4908864,'3038','469',25239.12,27256.40,2017.28,332851.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257799',4908865,'3039','469',323896.05,326362.39,2466.34,406946.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257799',4908866,'3040','469',53690.76,55987.63,2296.87,378983.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257799',4908867,'3041','469',421648.79,423568.28,1919.49,316715.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257799',4908868,'3042','469',48705.06,50330.77,1625.71,268242.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257799',4908869,'3043','469',534081.24,536175.38,2094.14,345533.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257799',4908870,'3044','469',31184.18,32886.10,1701.92,280816.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257799',4908871,'3045','469',504471.53,506798.37,2326.84,383928.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257799',4908872,'3046','469',89298.20,89298.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257799',4908873,'3047','469',503466.93,503466.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257799',4908874,'3048','469',107589.45,107589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257799',4908875,'3049','469',637440.72,637440.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257799',4908876,'3050','469',601656.60,601656.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257799',4908877,'3051','469',67710.49,67710.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257799',4908878,'3052','469',419005.13,419005.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257799',4908879,'3053','469',77772.35,77772.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257799',4908880,'3054','470',18066.84,18066.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257799',4908881,'3055','470',102820.45,102820.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257800',4908882,'3038','469',27256.40,27256.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257800',4908883,'3039','469',326362.39,326362.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257800',4908884,'3040','469',55987.63,55987.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257800',4908885,'3041','469',423568.28,423568.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257800',4908886,'3042','469',50330.77,50330.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257800',4908887,'3043','469',536175.38,536175.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257800',4908888,'3044','469',32886.10,32886.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257800',4908889,'3045','469',506798.37,506798.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257800',4908890,'3046','469',89298.20,89298.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257800',4908891,'3047','469',503466.93,503466.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257800',4908892,'3048','469',107589.45,107589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257800',4908893,'3049','469',637440.72,637440.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257800',4908894,'3050','469',601656.60,601656.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257800',4908895,'3051','469',67710.49,67710.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257800',4908896,'3052','469',419005.13,419005.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257800',4908897,'3053','469',77772.35,77772.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257800',4908898,'3054','470',18066.84,18178.44,111.60,84816.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257800',4908899,'3055','470',102820.45,103106.76,286.31,217595.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257801',4908900,'3038','469',27256.40,27256.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257801',4908901,'3039','469',326362.39,329549.07,3186.68,525802.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257801',4908902,'3040','469',55987.63,55987.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257801',4908903,'3041','469',423568.28,426763.94,3195.66,527283.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257801',4908904,'3042','469',50330.77,50330.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257801',4908905,'3043','469',536175.38,538474.62,2299.24,379374.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257801',4908906,'3044','469',32886.10,32886.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257801',4908907,'3045','469',506798.37,506798.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257801',4908908,'3046','469',89298.20,89298.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257801',4908909,'3047','469',503466.93,506259.65,2792.72,460798.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257801',4908910,'3048','469',107589.45,107589.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257801',4908911,'3049','469',637440.72,639976.83,2536.11,418458.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257801',4908912,'3050','469',601656.60,604092.32,2435.72,401893.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257801',4908913,'3051','469',67710.49,67710.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257801',4908914,'3052','469',419005.13,419005.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257801',4908915,'3053','469',77772.35,80559.02,2786.67,459800.55,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257801',4908916,'3054','470',18178.44,18178.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257801',4908917,'3055','470',103106.76,103492.54,385.78,293192.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257802',4908918,'3038','469',27256.40,27820.80,554.40,91476.00,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257802',4908919,'3039','469',329549.07,334040.17,4481.10,739381.50,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257802',4908920,'3040','469',55987.63,56714.68,717.05,118313.25,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257802',4908921,'3041','469',426763.94,431742.54,4966.60,819489.00,0.00,0.00,12.00,0.00,0.00),('1','203','1026','257802',4908922,'3042','469',50330.77,50919.12,588.35,97077.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257802',4908923,'3043','469',538474.62,542757.05,4282.43,706600.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257802',4908924,'3044','469',32886.10,33348.32,462.22,76266.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257802',4908925,'3045','469',506798.37,511231.82,4433.45,731519.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257802',4908926,'3046','469',89298.20,90234.62,936.42,154509.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257802',4908927,'3047','469',506259.65,509763.00,3503.35,578052.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257802',4908928,'3048','469',107589.45,108566.03,976.58,161135.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257802',4908929,'3049','469',639976.83,644151.34,4174.51,688794.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257802',4908930,'3050','469',604092.32,607822.25,3729.93,615438.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257802',4908931,'3051','469',67710.49,68653.69,943.20,155628.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257802',4908932,'3052','469',419005.13,419005.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257802',4908933,'3053','469',80559.02,84495.07,3936.05,649448.25,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257802',4908934,'3054','470',18178.44,18178.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257802',4908935,'3055','470',103492.54,104285.88,773.34,587738.40,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257803',4908936,'3038','469',27820.80,27820.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257803',4908937,'3039','469',334040.17,338809.58,4769.41,786952.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257803',4908938,'3040','469',56714.68,56714.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257803',4908939,'3041','469',431742.54,436585.29,4842.75,799053.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257803',4908940,'3042','469',50919.12,50919.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257803',4908941,'3043','469',542757.05,546670.11,3913.06,645654.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257803',4908942,'3044','469',33348.32,33348.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257803',4908943,'3045','469',511231.82,515421.52,4189.70,691300.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257803',4908944,'3046','469',90234.62,91520.42,1285.80,212157.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257803',4908945,'3047','469',509763.00,511487.14,1724.14,284483.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257803',4908946,'3048','469',108566.03,109200.96,634.93,104763.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257803',4908947,'3049','469',644151.34,649229.43,5078.09,837884.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257803',4908948,'3050','469',607822.25,612808.73,4986.48,822769.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257803',4908949,'3051','469',68653.69,69388.71,735.02,121278.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257803',4908950,'3052','469',419005.13,419005.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257803',4908951,'3053','469',84495.07,89244.92,4749.85,783725.25,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257803',4908952,'3054','470',18178.44,18178.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257803',4908953,'3055','470',104285.88,104906.17,620.29,471420.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257804',4908954,'3038','469',27820.80,27820.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257804',4908955,'3039','469',338809.58,338809.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257804',4908956,'3040','469',56714.68,56714.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257804',4908957,'3041','469',436585.29,436585.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257804',4908958,'3042','469',50919.12,50919.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257804',4908959,'3043','469',546670.11,546670.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257804',4908960,'3044','469',33348.32,33348.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257804',4908961,'3045','469',515421.52,515421.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257804',4908962,'3046','469',91520.42,91520.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257804',4908963,'3047','469',511487.14,511487.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257804',4908964,'3048','469',109200.96,109200.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257804',4908965,'3049','469',649229.43,649229.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257804',4908966,'3050','469',612808.73,612808.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257804',4908967,'3051','469',69388.71,69388.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257804',4908968,'3052','469',419005.13,419005.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257804',4908969,'3053','469',89244.92,89244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257804',4908970,'3054','470',18178.44,18178.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257804',4908971,'3055','470',104906.17,105392.08,485.91,369291.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257805',4908972,'3038','469',27820.80,27820.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257805',4908973,'3039','469',338809.58,342200.57,3390.99,559513.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257805',4908974,'3040','469',56714.68,56714.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257805',4908975,'3041','469',436585.29,439588.92,3003.63,495598.95,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257805',4908976,'3042','469',50919.12,50919.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257805',4908977,'3043','469',546670.11,548420.82,1750.71,288867.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257805',4908978,'3044','469',33348.32,33348.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257805',4908979,'3045','469',515421.52,518082.82,2661.30,439114.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257805',4908980,'3046','469',91520.42,91520.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257805',4908981,'3047','469',511487.14,513908.63,2421.49,399545.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257805',4908982,'3048','469',109200.96,109200.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257805',4908983,'3049','469',649229.43,651239.27,2009.84,331623.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257805',4908984,'3050','469',612808.73,614922.79,2114.06,348819.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257805',4908985,'3051','469',69388.71,69388.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257805',4908986,'3052','469',419005.13,419005.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257805',4908987,'3053','469',89244.92,91703.54,2458.62,405672.30,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257805',4908988,'3054','470',18178.44,18228.44,50.00,38000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257805',4908989,'3055','470',105392.08,106025.94,633.86,481733.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257806',4908990,'3038','469',27820.80,29059.53,1218.30,201019.50,0.00,0.00,20.43,0.00,0.00),('1','203','1026','257806',4908991,'3039','469',342200.57,346833.98,4633.41,764512.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257806',4908992,'3040','469',56714.68,58001.74,1266.63,208993.95,0.00,0.00,20.43,0.00,0.00),('1','203','1026','257806',4908993,'3041','469',439588.92,444044.90,4435.55,731865.75,0.00,0.00,20.43,0.00,0.00),('1','203','1026','257806',4908994,'3042','469',50919.12,52765.50,1846.38,304652.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257806',4908995,'3043','469',548420.82,551140.79,2699.53,445422.45,0.00,0.00,20.44,0.00,0.00),('1','203','1026','257806',4908996,'3044','469',33348.32,34953.63,1605.31,264876.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257806',4908997,'3045','469',518082.82,521472.85,3369.59,555982.35,0.00,0.00,20.44,0.00,0.00),('1','203','1027','257806',4908998,'3046','469',91520.42,92642.20,1121.78,185093.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257806',4908999,'3047','469',513908.63,516836.72,2921.99,482128.35,0.00,0.00,6.10,0.00,0.00),('1','203','1027','257806',4909000,'3048','469',109200.96,110221.43,1020.47,168377.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257806',4909001,'3049','469',651239.27,653970.96,2731.69,450728.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257806',4909002,'3050','469',614922.79,618276.73,3353.94,553400.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257806',4909003,'3051','469',69388.71,69924.45,535.74,88397.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257806',4909004,'3052','469',419005.13,420069.82,1064.69,175673.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257806',4909005,'3053','469',91703.54,93911.39,2207.85,364295.25,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257806',4909006,'3054','470',18228.44,18228.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257806',4909007,'3055','470',106025.94,107717.73,1671.32,1270203.20,0.00,0.00,20.47,0.00,0.00),('1','203','1026','257807',4909008,'3038','469',29059.53,31406.53,2347.00,387255.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257807',4909009,'3039','469',346833.98,349030.44,2196.46,362415.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257807',4909010,'3040','469',58001.74,59946.26,1944.52,320845.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257807',4909011,'3041','469',444044.90,445823.75,1778.85,293510.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257807',4909012,'3042','469',52765.50,54339.58,1574.08,259723.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257807',4909013,'3043','469',551140.79,553255.03,2114.24,348849.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257807',4909014,'3044','469',34953.63,34953.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257807',4909015,'3045','469',521472.85,523979.80,2506.95,413646.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257807',4909016,'3046','469',92642.20,92642.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257807',4909017,'3047','469',516836.72,516836.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257807',4909018,'3048','469',110221.43,110221.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257807',4909019,'3049','469',653970.96,653970.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257807',4909020,'3050','469',618276.73,618276.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257807',4909021,'3051','469',69924.45,69924.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257807',4909022,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257807',4909023,'3053','469',93911.39,93911.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257807',4909024,'3054','470',18228.44,19178.44,950.00,722000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257807',4909025,'3055','470',107717.73,108671.74,954.01,725047.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257808',4909026,'3038','469',31406.53,31406.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257808',4909027,'3039','469',349030.44,349030.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257808',4909028,'3040','469',59946.26,59946.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257808',4909029,'3041','469',445823.75,445823.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257808',4909030,'3042','469',54339.58,54339.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257808',4909031,'3043','469',553255.03,553255.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257808',4909032,'3044','469',34953.63,34953.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257808',4909033,'3045','469',523979.80,523979.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257808',4909034,'3046','469',92642.20,95012.39,2370.19,391081.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257808',4909035,'3047','469',516836.72,518966.95,2130.23,351487.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257808',4909036,'3048','469',110221.43,112157.29,1935.86,319416.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257808',4909037,'3049','469',653970.96,656240.59,2269.63,374488.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257808',4909038,'3050','469',618276.73,620270.73,1994.00,329010.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257808',4909039,'3051','469',69924.45,71821.65,1897.20,313038.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257808',4909040,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257808',4909041,'3053','469',93911.39,96384.36,2472.97,408040.05,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257808',4909042,'3054','470',19178.44,19178.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257808',4909043,'3055','470',108671.74,109254.93,583.19,443224.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257809',4909044,'3038','469',31406.53,31406.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257809',4909045,'3039','469',349030.44,349030.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257809',4909046,'3040','469',59946.26,59946.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257809',4909047,'3041','469',445823.75,445823.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257809',4909048,'3042','469',54339.58,54339.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257809',4909049,'3043','469',553255.03,553255.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257809',4909050,'3044','469',34953.63,34953.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257809',4909051,'3045','469',523979.80,523979.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257809',4909052,'3046','469',95012.39,95012.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257809',4909053,'3047','469',518966.95,518966.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257809',4909054,'3048','469',112157.29,112157.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257809',4909055,'3049','469',656240.59,656240.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257809',4909056,'3050','469',620270.73,620270.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257809',4909057,'3051','469',71821.65,71821.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257809',4909058,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257809',4909059,'3053','469',96384.36,96384.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257809',4909060,'3054','470',19178.44,19178.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257809',4909061,'3055','470',109254.93,109579.56,324.63,246718.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257810',4909062,'3038','469',31406.53,33290.95,1854.42,305979.30,0.00,0.00,30.00,0.00,0.00),('1','203','1026','257810',4909063,'3039','469',349030.44,351066.33,2035.89,335921.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257810',4909064,'3040','469',59946.26,61911.07,1964.81,324193.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257810',4909065,'3041','469',445823.75,447733.03,1909.28,315031.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257810',4909066,'3042','469',54339.58,56294.06,1954.48,322489.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257810',4909067,'3043','469',553255.03,555003.32,1748.29,288467.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257810',4909068,'3044','469',34953.63,36562.49,1608.86,265461.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257810',4909069,'3045','469',523979.80,525860.99,1881.19,310396.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257810',4909070,'3046','469',95012.39,95012.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257810',4909071,'3047','469',518966.95,518966.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257810',4909072,'3048','469',112157.29,112157.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257810',4909073,'3049','469',656240.59,656240.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257810',4909074,'3050','469',620270.73,620270.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257810',4909075,'3051','469',71821.65,71821.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257810',4909076,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257810',4909077,'3053','469',96384.36,96384.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257810',4909078,'3054','470',19178.44,19178.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257810',4909079,'3055','470',109579.56,110277.20,697.64,537182.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257811',4909080,'3038','469',33290.95,33290.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257811',4909081,'3039','469',351066.33,351066.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257811',4909082,'3040','469',61911.07,61911.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257811',4909083,'3041','469',447733.03,447733.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257811',4909084,'3042','469',56294.06,56294.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257811',4909085,'3043','469',555003.32,555003.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257811',4909086,'3044','469',36562.49,36562.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257811',4909087,'3045','469',525860.99,525860.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257811',4909088,'3046','469',95012.39,95012.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257811',4909089,'3047','469',518966.95,518966.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257811',4909090,'3048','469',112157.29,112157.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257811',4909091,'3049','469',656240.59,656240.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257811',4909092,'3050','469',620270.73,620270.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257811',4909093,'3051','469',71821.65,71821.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257811',4909094,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257811',4909095,'3053','469',96384.36,96384.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257811',4909096,'3054','470',19178.44,19178.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257811',4909097,'3055','470',110277.20,111350.46,1073.26,826410.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257812',4909098,'3038','469',33290.95,33290.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257812',4909099,'3039','469',351066.33,351066.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257812',4909100,'3040','469',61911.07,61911.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257812',4909101,'3041','469',447733.03,447733.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257812',4909102,'3042','469',56294.06,56294.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257812',4909103,'3043','469',555003.32,555003.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257812',4909104,'3044','469',36562.49,36562.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257812',4909105,'3045','469',525860.99,525860.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257812',4909106,'3046','469',95012.39,96526.94,1514.55,249900.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257812',4909107,'3047','469',518966.95,521903.48,2936.53,484527.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257812',4909108,'3048','469',112157.29,114988.41,2831.12,467134.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257812',4909109,'3049','469',656240.59,659235.52,2994.93,494163.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257812',4909110,'3050','469',620270.73,623229.07,2958.34,488126.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257812',4909111,'3051','469',71821.65,73260.44,1438.79,237400.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257812',4909112,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257812',4909113,'3053','469',96384.36,97151.88,767.52,126640.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257812',4909114,'3054','470',19178.44,20179.20,1000.76,770585.20,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257812',4909115,'3055','470',111350.46,112866.78,1516.32,1167566.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257813',4909116,'3038','469',33290.95,35991.05,2700.10,445516.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257813',4909117,'3039','469',351066.33,353711.05,2644.72,436378.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257813',4909118,'3040','469',61911.07,64348.05,2436.98,402101.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257813',4909119,'3041','469',447733.03,450654.24,2921.21,481999.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257813',4909120,'3042','469',56294.06,58798.62,2504.56,413252.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257813',4909121,'3043','469',555003.32,558243.52,3240.20,534633.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257813',4909122,'3044','469',36562.49,36562.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257813',4909123,'3045','469',525860.99,528890.52,3029.53,499872.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257813',4909124,'3046','469',96526.94,96526.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257813',4909125,'3047','469',521903.48,521903.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257813',4909126,'3048','469',114988.41,114988.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257813',4909127,'3049','469',659235.52,659235.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257813',4909128,'3050','469',623229.07,623229.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257813',4909129,'3051','469',73260.44,73260.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257813',4909130,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257813',4909131,'3053','469',97151.88,97151.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257813',4909132,'3054','470',20179.20,20563.61,384.41,295995.70,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257813',4909133,'3055','470',112866.78,113545.93,679.15,522945.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257814',4909134,'3038','469',35991.05,35991.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257814',4909135,'3039','469',353711.05,353871.02,159.97,26395.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257814',4909136,'3040','469',64348.05,64348.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257814',4909137,'3041','469',450654.24,450797.26,143.02,23598.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257814',4909138,'3042','469',58798.62,58798.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257814',4909139,'3043','469',558243.52,558359.77,116.25,19181.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257814',4909140,'3044','469',36562.49,36562.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257814',4909141,'3045','469',528890.52,529033.80,143.28,23641.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257814',4909142,'3046','469',96526.94,96526.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257814',4909143,'3047','469',521903.48,521903.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257814',4909144,'3048','469',114988.41,114988.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257814',4909145,'3049','469',659235.52,659235.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257814',4909146,'3050','469',623229.07,623229.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257814',4909147,'3051','469',73260.44,73260.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257814',4909148,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257814',4909149,'3053','469',97151.88,97151.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257814',4909150,'3054','470',20563.61,20898.25,334.64,257672.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257814',4909151,'3055','470',113545.93,115142.33,1596.40,1229228.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257815',4909152,'3038','469',35991.05,35991.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257815',4909153,'3039','469',353871.02,353871.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257815',4909154,'3040','469',64348.05,64348.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257815',4909155,'3041','469',450797.26,450797.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257815',4909156,'3042','469',58798.62,58798.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257815',4909157,'3043','469',558359.77,558359.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257815',4909158,'3044','469',36562.49,36562.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257815',4909159,'3045','469',529033.80,529033.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257815',4909160,'3046','469',96526.94,96526.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257815',4909161,'3047','469',521903.48,521903.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257815',4909162,'3048','469',114988.41,114988.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257815',4909163,'3049','469',659235.52,659235.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257815',4909164,'3050','469',623229.07,623229.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257815',4909165,'3051','469',73260.44,73260.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257815',4909166,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257815',4909167,'3053','469',97151.88,97151.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257815',4909168,'3054','470',20898.25,20898.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257815',4909169,'3055','470',115142.33,115251.69,109.36,84207.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257816',4909170,'3038','469',35991.05,35991.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257816',4909171,'3039','469',353871.02,357965.81,4082.79,673660.35,0.00,0.00,12.00,0.00,0.00),('1','203','1026','257816',4909172,'3040','469',64348.05,64348.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257816',4909173,'3041','469',450797.26,455223.12,4425.86,730266.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257816',4909174,'3042','469',58798.62,58798.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257816',4909175,'3043','469',558359.77,562691.16,4331.39,714679.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257816',4909176,'3044','469',36562.49,36562.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257816',4909177,'3045','469',529033.80,533029.90,3996.10,659356.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257816',4909178,'3046','469',96526.94,96526.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257816',4909179,'3047','469',521903.48,521903.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257816',4909180,'3048','469',114988.41,114988.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257816',4909181,'3049','469',659235.52,659487.88,252.36,41639.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257816',4909182,'3050','469',623229.07,623401.47,172.40,28446.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257816',4909183,'3051','469',73260.44,73260.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257816',4909184,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257816',4909185,'3053','469',97151.88,98353.74,1201.86,198306.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257816',4909186,'3054','470',20898.25,20898.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257816',4909187,'3055','470',115251.69,115251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257817',4909188,'3038','469',35991.05,35991.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257817',4909189,'3039','469',357965.81,357965.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257817',4909190,'3040','469',64348.05,64348.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257817',4909191,'3041','469',455223.12,455223.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257817',4909192,'3042','469',58798.62,58798.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257817',4909193,'3043','469',562691.16,562691.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257817',4909194,'3044','469',36562.49,36562.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257817',4909195,'3045','469',533029.90,533029.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257817',4909196,'3046','469',96526.94,96526.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257817',4909197,'3047','469',521903.48,525735.53,3832.05,632288.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257817',4909198,'3048','469',114988.41,118234.67,3246.26,535632.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257817',4909199,'3049','469',659487.88,662870.38,3382.50,558112.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257817',4909200,'3050','469',623401.47,626645.57,3244.10,535276.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257817',4909201,'3051','469',73260.44,76277.41,3016.97,497800.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257817',4909202,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257817',4909203,'3053','469',98353.74,98353.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257817',4909204,'3054','470',20898.25,20898.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257817',4909205,'3055','470',115251.69,115251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257818',4909206,'3038','469',35991.05,38294.29,2303.24,380034.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257818',4909207,'3039','469',357965.81,359783.82,1818.01,299971.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257818',4909208,'3040','469',64348.05,66270.86,1922.81,317263.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257818',4909209,'3041','469',455223.12,457796.14,2573.02,424548.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257818',4909210,'3042','469',58798.62,60743.06,1944.44,320832.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257818',4909211,'3043','469',562691.16,564744.55,2053.39,338809.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257818',4909212,'3044','469',36562.49,36562.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257818',4909213,'3045','469',533029.90,535384.45,2354.55,388500.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257818',4909214,'3046','469',96526.94,96526.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257818',4909215,'3047','469',525735.53,525735.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257818',4909216,'3048','469',118234.67,118234.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257818',4909217,'3049','469',662870.38,662870.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257818',4909218,'3050','469',626645.57,626645.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257818',4909219,'3051','469',76277.41,76277.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257818',4909220,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257818',4909221,'3053','469',98353.74,98353.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257818',4909222,'3054','470',20898.25,20898.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257818',4909223,'3055','470',115251.69,115251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257819',4909224,'3038','469',38294.29,38294.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257819',4909225,'3039','469',359783.82,359783.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257819',4909226,'3040','469',66270.86,66270.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257819',4909227,'3041','469',457796.14,457796.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257819',4909228,'3042','469',60743.06,60743.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257819',4909229,'3043','469',564744.55,564744.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257819',4909230,'3044','469',36562.49,36562.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257819',4909231,'3045','469',535384.45,535384.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257819',4909232,'3046','469',96526.94,99167.76,2640.82,435735.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257819',4909233,'3047','469',525735.53,528000.77,2265.24,373764.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257819',4909234,'3048','469',118234.67,120601.68,2367.01,390556.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257819',4909235,'3049','469',662870.38,665372.89,2502.51,412914.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257819',4909236,'3050','469',626645.57,629146.43,2500.86,412641.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257819',4909237,'3051','469',76277.41,77998.23,1720.82,283935.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257819',4909238,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257819',4909239,'3053','469',98353.74,98353.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257819',4909240,'3054','470',20898.25,20898.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257819',4909241,'3055','470',115251.69,115251.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257820',4909242,'3038','469',38294.29,39899.70,1595.41,263242.65,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257820',4909243,'3039','469',359783.82,361601.24,1807.42,298224.30,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257820',4909244,'3040','469',66270.86,68464.46,2183.60,360294.00,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257820',4909245,'3041','469',457796.14,459778.15,1972.01,325381.65,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257820',4909246,'3042','469',60743.06,62334.91,1580.85,260840.25,0.00,0.00,11.00,0.00,0.00),('1','203','1026','257820',4909247,'3043','469',564744.55,567047.47,2302.92,379981.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257820',4909248,'3044','469',36562.49,38132.18,1569.69,258998.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257820',4909249,'3045','469',535384.45,536802.20,1417.75,233928.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257820',4909250,'3046','469',99167.76,99167.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257820',4909251,'3047','469',528000.77,528000.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257820',4909252,'3048','469',120601.68,120601.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257820',4909253,'3049','469',665372.89,665372.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257820',4909254,'3050','469',629146.43,629146.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257820',4909255,'3051','469',77998.23,77998.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257820',4909256,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257820',4909257,'3053','469',98353.74,98353.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257820',4909258,'3054','470',20898.25,20898.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257820',4909259,'3055','470',115251.69,115957.94,706.25,565000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257821',4909260,'3038','469',39899.70,39899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257821',4909261,'3039','469',361601.24,361601.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257821',4909262,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257821',4909263,'3041','469',459778.15,459778.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257821',4909264,'3042','469',62334.91,62334.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257821',4909265,'3043','469',567047.47,567047.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257821',4909266,'3044','469',38132.18,38132.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257821',4909267,'3045','469',536802.20,536802.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257821',4909268,'3046','469',99167.76,99167.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257821',4909269,'3047','469',528000.77,528000.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257821',4909270,'3048','469',120601.68,120601.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257821',4909271,'3049','469',665372.89,665372.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257821',4909272,'3050','469',629146.43,629146.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257821',4909273,'3051','469',77998.23,77998.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257821',4909274,'3052','469',420069.82,420069.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257821',4909275,'3053','469',98353.74,98353.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257821',4909276,'3054','470',20898.25,21045.56,147.31,117848.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257821',4909277,'3055','470',115957.94,116186.60,228.66,182928.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257822',4909278,'3038','469',39899.70,39899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257822',4909279,'3039','469',361601.24,361601.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257822',4909280,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257822',4909281,'3041','469',459778.15,459778.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257822',4909282,'3042','469',62334.91,62334.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257822',4909283,'3043','469',567047.47,567047.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257822',4909284,'3044','469',38132.18,38132.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257822',4909285,'3045','469',536802.20,536802.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257822',4909286,'3046','469',99167.76,101537.28,2369.52,390970.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257822',4909287,'3047','469',528000.77,530368.50,2367.73,390675.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257822',4909288,'3048','469',120601.68,123064.71,2463.03,406399.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257822',4909289,'3049','469',665372.89,668756.82,3383.93,558348.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257822',4909290,'3050','469',629146.43,631756.51,2610.08,430663.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257822',4909291,'3051','469',77998.23,80743.72,2745.49,453005.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257822',4909292,'3052','469',420069.82,422606.54,2536.72,418558.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257822',4909293,'3053','469',98353.74,98356.78,0.00,0.00,0.00,0.00,3.04,0.00,0.00),('1','203','1028','257822',4909294,'3054','470',21045.56,21143.62,98.06,80409.20,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257822',4909295,'3055','470',116186.60,117367.68,1177.42,965484.40,0.00,0.00,3.66,0.00,0.00),('1','203','1026','257823',4909296,'3038','469',39899.70,39899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257823',4909297,'3039','469',361601.24,361601.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257823',4909298,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257823',4909299,'3041','469',459778.15,459778.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257823',4909300,'3042','469',62334.91,62334.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257823',4909301,'3043','469',567047.47,567047.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257823',4909302,'3044','469',38132.18,38132.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257823',4909303,'3045','469',536802.20,536802.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257823',4909304,'3046','469',101537.28,101537.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257823',4909305,'3047','469',530368.50,531673.68,1305.18,215354.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257823',4909306,'3048','469',123064.71,123064.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257823',4909307,'3049','469',668756.82,670322.79,1565.97,258385.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257823',4909308,'3050','469',631756.51,632965.22,1208.71,199437.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257823',4909309,'3051','469',80743.72,80743.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257823',4909310,'3052','469',422606.54,422606.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257823',4909311,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257823',4909312,'3054','470',21143.62,21143.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257823',4909313,'3055','470',117367.68,117736.30,368.62,302268.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257824',4909314,'3038','469',39899.70,39899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257824',4909315,'3039','469',361601.24,361601.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257824',4909316,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257824',4909317,'3041','469',459778.15,459778.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257824',4909318,'3042','469',62334.91,62334.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257824',4909319,'3043','469',567047.47,567047.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257824',4909320,'3044','469',38132.18,38132.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257824',4909321,'3045','469',536802.20,536802.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257824',4909322,'3046','469',101537.28,101537.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257824',4909323,'3047','469',531673.68,531673.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257824',4909324,'3048','469',123064.71,123064.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257824',4909325,'3049','469',670322.79,670322.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257824',4909326,'3050','469',632965.22,632965.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257824',4909327,'3051','469',80743.72,80743.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257824',4909328,'3052','469',422606.54,422919.19,312.65,51587.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257824',4909329,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257824',4909330,'3054','470',21143.62,21361.90,218.28,178989.60,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257824',4909331,'3055','470',117736.30,117883.99,147.69,121105.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257825',4909332,'3038','469',39899.70,39899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257825',4909333,'3039','469',361601.24,361601.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257825',4909334,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257825',4909335,'3041','469',459778.15,459778.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257825',4909336,'3042','469',62334.91,62334.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257825',4909337,'3043','469',567047.47,567047.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257825',4909338,'3044','469',38132.18,38132.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257825',4909339,'3045','469',536802.20,536802.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257825',4909340,'3046','469',101537.28,101537.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257825',4909341,'3047','469',531673.68,531673.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257825',4909342,'3048','469',123064.71,123064.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257825',4909343,'3049','469',670322.79,670322.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257825',4909344,'3050','469',632965.22,632965.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257825',4909345,'3051','469',80743.72,80743.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257825',4909346,'3052','469',422919.19,422919.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257825',4909347,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257825',4909348,'3054','470',21361.90,21594.78,232.88,190961.60,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257825',4909349,'3055','470',117883.99,118683.93,799.94,655950.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257826',4909350,'3038','469',39899.70,39899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257826',4909351,'3039','469',361601.24,361601.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257826',4909352,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257826',4909353,'3041','469',459778.15,459778.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257826',4909354,'3042','469',62334.91,62334.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257826',4909355,'3043','469',567047.47,567047.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257826',4909356,'3044','469',38132.18,38132.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257826',4909357,'3045','469',536802.20,536802.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257826',4909358,'3046','469',101537.28,101537.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257826',4909359,'3047','469',531673.68,533835.21,2141.53,353352.45,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257826',4909360,'3048','469',123064.71,124866.09,1791.38,295577.70,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257826',4909361,'3049','469',670322.79,672291.77,1968.98,324881.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257826',4909362,'3050','469',632965.22,635275.69,2310.47,381227.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257826',4909363,'3051','469',80743.72,80743.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257826',4909364,'3052','469',422919.19,425813.50,2894.31,477561.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257826',4909365,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257826',4909366,'3054','470',21594.78,22333.07,738.29,605397.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257826',4909367,'3055','470',118683.93,119475.21,791.28,648849.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257827',4909368,'3038','469',39899.70,39899.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257827',4909369,'3039','469',361601.24,361601.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257827',4909370,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257827',4909371,'3041','469',459778.15,459778.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257827',4909372,'3042','469',62334.91,62334.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257827',4909373,'3043','469',567047.47,567047.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257827',4909374,'3044','469',38132.18,38132.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257827',4909375,'3045','469',536802.20,536802.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257827',4909376,'3046','469',101537.28,102909.94,1372.66,226488.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257827',4909377,'3047','469',533835.21,535083.34,1248.13,205941.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257827',4909378,'3048','469',124866.09,126071.49,1205.40,198891.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257827',4909379,'3049','469',672291.77,673506.84,1215.07,200486.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257827',4909380,'3050','469',635275.69,636473.69,1198.00,197670.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257827',4909381,'3051','469',80743.72,80743.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257827',4909382,'3052','469',425813.50,427454.92,1641.42,270834.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257827',4909383,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257827',4909384,'3054','470',22333.07,22532.92,199.85,163877.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257827',4909385,'3055','470',119475.21,120254.65,779.44,639140.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257828',4909386,'3038','469',39899.70,44213.16,4313.46,711720.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257828',4909387,'3039','469',361601.24,365088.93,3487.69,575468.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257828',4909388,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257828',4909389,'3041','469',459778.15,464701.21,4923.06,812304.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257828',4909390,'3042','469',62334.91,65578.65,3243.74,535217.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257828',4909391,'3043','469',567047.47,570549.62,3502.15,577854.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257828',4909392,'3044','469',38132.18,41037.52,2905.34,479381.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257828',4909393,'3045','469',536802.20,540033.99,3231.79,533245.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257828',4909394,'3046','469',102909.94,102909.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257828',4909395,'3047','469',535083.34,535083.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257828',4909396,'3048','469',126071.49,126071.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257828',4909397,'3049','469',673506.84,673506.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257828',4909398,'3050','469',636473.69,636473.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257828',4909399,'3051','469',80743.72,80743.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257828',4909400,'3052','469',427454.92,427454.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257828',4909401,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257828',4909402,'3054','470',22532.92,22761.90,228.98,190053.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257828',4909403,'3055','470',120254.65,122118.51,1863.86,1547003.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257829',4909404,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257829',4909405,'3039','469',365088.93,367009.90,1910.97,315310.05,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257829',4909406,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257829',4909407,'3041','469',464701.21,466776.87,2065.66,340833.90,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257829',4909408,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257829',4909409,'3043','469',570549.62,572660.33,2110.71,348267.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257829',4909410,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257829',4909411,'3045','469',540033.99,541224.60,1190.61,196450.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257829',4909412,'3046','469',102909.94,102909.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257829',4909413,'3047','469',535083.34,535083.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257829',4909414,'3048','469',126071.49,126071.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257829',4909415,'3049','469',673506.84,673506.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257829',4909416,'3050','469',636473.69,636473.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257829',4909417,'3051','469',80743.72,80743.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257829',4909418,'3052','469',427454.92,427454.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257829',4909419,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257829',4909420,'3054','470',22761.90,22761.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257829',4909421,'3055','470',122118.51,122415.71,277.20,230076.00,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257830',4909422,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257830',4909423,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257830',4909424,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257830',4909425,'3041','469',466776.87,466776.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257830',4909426,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257830',4909427,'3043','469',572660.33,572660.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257830',4909428,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257830',4909429,'3045','469',541224.60,541224.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257830',4909430,'3046','469',102909.94,105313.84,2403.90,396643.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257830',4909431,'3047','469',535083.34,537628.98,2545.64,420030.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257830',4909432,'3048','469',126071.49,128587.43,2515.94,415130.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257830',4909433,'3049','469',673506.84,675946.52,2439.68,402547.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257830',4909434,'3050','469',636473.69,638625.05,2151.36,354974.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257830',4909435,'3051','469',80743.72,82908.80,2165.08,357238.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257830',4909436,'3052','469',427454.92,431093.91,3638.99,600433.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257830',4909437,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257830',4909438,'3054','470',22761.90,22761.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257830',4909439,'3055','470',122415.71,123053.62,637.91,529465.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257831',4909440,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257831',4909441,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257831',4909442,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257831',4909443,'3041','469',466776.87,466776.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257831',4909444,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257831',4909445,'3043','469',572660.33,572660.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257831',4909446,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257831',4909447,'3045','469',541224.60,541224.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257831',4909448,'3046','469',105313.84,105313.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257831',4909449,'3047','469',537628.98,538616.07,987.09,162869.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257831',4909450,'3048','469',128587.43,128587.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257831',4909451,'3049','469',675946.52,677199.56,1253.04,206751.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257831',4909452,'3050','469',638625.05,639560.41,935.36,154334.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257831',4909453,'3051','469',82908.80,82908.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257831',4909454,'3052','469',431093.91,432343.26,1249.35,206142.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257831',4909455,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257831',4909456,'3054','470',22761.90,22949.26,187.36,155508.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257831',4909457,'3055','470',123053.62,123851.66,798.04,662373.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257832',4909458,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257832',4909459,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257832',4909460,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257832',4909461,'3041','469',466776.87,466776.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257832',4909462,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257832',4909463,'3043','469',572660.33,572660.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257832',4909464,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257832',4909465,'3045','469',541224.60,541224.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257832',4909466,'3046','469',105313.84,107089.76,1775.92,293026.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257832',4909467,'3047','469',538616.07,540290.77,1674.70,276325.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257832',4909468,'3048','469',128587.43,130158.36,1570.93,259203.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257832',4909469,'3049','469',677199.56,679440.97,2241.41,369832.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257832',4909470,'3050','469',639560.41,641413.09,1852.68,305692.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257832',4909471,'3051','469',82908.80,84418.65,1509.85,249125.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257832',4909472,'3052','469',432343.26,434528.77,2185.51,360609.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257832',4909473,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257832',4909474,'3054','470',22949.26,22949.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257832',4909475,'3055','470',123851.66,124781.35,929.69,771642.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257833',4909476,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257833',4909477,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257833',4909478,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257833',4909479,'3041','469',466776.87,466776.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257833',4909480,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257833',4909481,'3043','469',572660.33,572660.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257833',4909482,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257833',4909483,'3045','469',541224.60,541224.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257833',4909484,'3046','469',107089.76,107089.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257833',4909485,'3047','469',540290.77,540290.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257833',4909486,'3048','469',130158.36,130158.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257833',4909487,'3049','469',679440.97,679440.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257833',4909488,'3050','469',641413.09,641413.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257833',4909489,'3051','469',84418.65,84418.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257833',4909490,'3052','469',434528.77,434528.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257833',4909491,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257833',4909492,'3054','470',22949.26,23195.79,246.53,204619.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257833',4909493,'3055','470',124781.35,124900.98,119.63,99292.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257834',4909494,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257834',4909495,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257834',4909496,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257834',4909497,'3041','469',466776.87,466776.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257834',4909498,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257834',4909499,'3043','469',572660.33,572660.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257834',4909500,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257834',4909501,'3045','469',541224.60,541224.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257834',4909502,'3046','469',107089.76,107089.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257834',4909503,'3047','469',540290.77,540290.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257834',4909504,'3048','469',130158.36,130158.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257834',4909505,'3049','469',679440.97,679440.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257834',4909506,'3050','469',641413.09,641413.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257834',4909507,'3051','469',84418.65,84418.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257834',4909508,'3052','469',434528.77,434528.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257834',4909509,'3053','469',98356.78,98356.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257834',4909510,'3054','470',23195.79,23389.67,193.88,160920.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257834',4909511,'3055','470',124900.98,125178.33,277.35,230200.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257835',4909512,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257835',4909513,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257835',4909514,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257835',4909515,'3041','469',466776.87,471113.00,4336.13,715461.45,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257835',4909516,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257835',4909517,'3043','469',572660.33,576220.28,3559.95,587391.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257835',4909518,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257835',4909519,'3045','469',541224.60,544308.82,3084.22,508896.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257835',4909520,'3046','469',107089.76,107089.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257835',4909521,'3047','469',540290.77,543198.65,2907.88,479800.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257835',4909522,'3048','469',130158.36,130158.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257835',4909523,'3049','469',679440.97,682942.96,3501.99,577828.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257835',4909524,'3050','469',641413.09,644625.84,3212.75,530103.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257835',4909525,'3051','469',84418.65,84418.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257835',4909526,'3052','469',434528.77,434528.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257835',4909527,'3053','469',98356.78,98667.10,310.32,51202.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257835',4909528,'3054','470',23389.67,23567.65,177.98,147723.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257835',4909529,'3055','470',125178.33,126436.00,1257.67,1043866.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257836',4909530,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257836',4909531,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257836',4909532,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257836',4909533,'3041','469',471113.00,474599.40,3486.40,575256.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257836',4909534,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257836',4909535,'3043','469',576220.28,579784.67,3564.39,588124.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257836',4909536,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257836',4909537,'3045','469',544308.82,544308.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257836',4909538,'3046','469',107089.76,107089.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257836',4909539,'3047','469',543198.65,545692.86,2494.21,411544.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257836',4909540,'3048','469',130158.36,130158.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257836',4909541,'3049','469',682942.96,685830.46,2887.50,476437.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257836',4909542,'3050','469',644625.84,646975.99,2350.15,387774.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257836',4909543,'3051','469',84418.65,84418.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257836',4909544,'3052','469',434528.77,437393.50,2864.73,472680.45,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257836',4909545,'3053','469',98667.10,98667.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257836',4909546,'3054','470',23567.65,23758.80,191.15,158654.50,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257836',4909547,'3055','470',126436.00,126747.67,311.67,258686.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257837',4909548,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257837',4909549,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257837',4909550,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257837',4909551,'3041','469',474599.40,474700.95,101.55,16755.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257837',4909552,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257837',4909553,'3043','469',579784.67,579784.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257837',4909554,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257837',4909555,'3045','469',544308.82,544308.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257837',4909556,'3046','469',107089.76,108513.48,1400.42,231069.30,0.00,0.00,23.30,0.00,0.00),('1','203','1027','257837',4909557,'3047','469',545692.86,547172.84,1469.98,242546.70,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257837',4909558,'3048','469',130158.36,131768.14,1599.78,263963.70,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257837',4909559,'3049','469',685830.46,687629.02,1788.56,295112.40,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257837',4909560,'3050','469',646975.99,648036.09,1050.10,173266.50,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257837',4909561,'3051','469',84418.65,85978.75,1560.10,257416.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257837',4909562,'3052','469',437393.50,439026.25,1632.75,269403.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257837',4909563,'3053','469',98667.10,98756.91,89.81,14818.65,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257837',4909564,'3054','470',23758.80,23758.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257837',4909565,'3055','470',126747.67,127129.76,353.96,293786.80,0.00,0.00,28.13,0.00,0.00),('1','203','1026','257838',4909566,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257838',4909567,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257838',4909568,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257838',4909569,'3041','469',474700.95,474700.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257838',4909570,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257838',4909571,'3043','469',579784.67,579784.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257838',4909572,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257838',4909573,'3045','469',544308.82,544308.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257838',4909574,'3046','469',108513.48,110995.07,2481.59,409462.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257838',4909575,'3047','469',547172.84,549575.21,2402.37,396391.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257838',4909576,'3048','469',131768.14,134593.37,2825.23,466162.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257838',4909577,'3049','469',687629.02,690800.33,3171.31,523266.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257838',4909578,'3050','469',648036.09,650960.28,2924.19,482491.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257838',4909579,'3051','469',85978.75,88288.09,2309.34,381041.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257838',4909580,'3052','469',439026.25,442255.93,3229.68,532897.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257838',4909581,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257838',4909582,'3054','470',23758.80,23758.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257838',4909583,'3055','470',127129.76,127129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257839',4909584,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257839',4909585,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257839',4909586,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257839',4909587,'3041','469',474700.95,474700.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257839',4909588,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257839',4909589,'3043','469',579784.67,579784.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257839',4909590,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257839',4909591,'3045','469',544308.82,544308.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257839',4909592,'3046','469',110995.07,110995.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257839',4909593,'3047','469',549575.21,549575.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257839',4909594,'3048','469',134593.37,134593.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257839',4909595,'3049','469',690800.33,690800.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257839',4909596,'3050','469',650960.28,650960.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257839',4909597,'3051','469',88288.09,88288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257839',4909598,'3052','469',442255.93,442255.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257839',4909599,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257839',4909600,'3054','470',23758.80,24092.62,333.82,277070.60,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257839',4909601,'3055','470',127129.76,128346.85,1217.09,1010184.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257840',4909602,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257840',4909603,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257840',4909604,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257840',4909605,'3041','469',474700.95,475707.20,983.25,162236.25,0.00,0.00,23.00,0.00,0.00),('1','203','1026','257840',4909606,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257840',4909607,'3043','469',579784.67,579784.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257840',4909608,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257840',4909609,'3045','469',544308.82,544308.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257840',4909610,'3046','469',110995.07,110995.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257840',4909611,'3047','469',549575.21,549575.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257840',4909612,'3048','469',134593.37,134593.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257840',4909613,'3049','469',690800.33,690800.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257840',4909614,'3050','469',650960.28,650960.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257840',4909615,'3051','469',88288.09,88288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257840',4909616,'3052','469',442255.93,442255.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257840',4909617,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257840',4909618,'3054','470',24092.62,24504.56,411.94,341910.20,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257840',4909619,'3055','470',128346.85,129257.96,911.11,756221.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257841',4909620,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257841',4909621,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257841',4909622,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257841',4909623,'3041','469',475707.20,475707.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257841',4909624,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257841',4909625,'3043','469',579784.67,579784.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257841',4909626,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257841',4909627,'3045','469',544308.82,544308.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257841',4909628,'3046','469',110995.07,112351.03,1355.96,223733.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257841',4909629,'3047','469',549575.21,551221.96,1646.75,271713.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257841',4909630,'3048','469',134593.37,135883.19,1289.82,212820.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257841',4909631,'3049','469',690800.33,692614.70,1814.37,299371.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257841',4909632,'3050','469',650960.28,652724.82,1764.54,291149.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257841',4909633,'3051','469',88288.09,88288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257841',4909634,'3052','469',442255.93,443831.68,1575.75,259998.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257841',4909635,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257841',4909636,'3054','470',24504.56,24885.56,381.00,316230.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257841',4909637,'3055','470',129257.96,129716.91,458.95,380928.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257842',4909638,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257842',4909639,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257842',4909640,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257842',4909641,'3041','469',475707.20,475707.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257842',4909642,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257842',4909643,'3043','469',579784.67,579784.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257842',4909644,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257842',4909645,'3045','469',544308.82,544308.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257842',4909646,'3046','469',112351.03,114034.96,1673.93,276198.45,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257842',4909647,'3047','469',551221.96,553003.00,1771.04,292221.60,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257842',4909648,'3048','469',135883.19,137449.56,1556.37,256801.05,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257842',4909649,'3049','469',692614.70,695136.73,2512.03,414484.95,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257842',4909650,'3050','469',652724.82,654344.20,1619.38,267197.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257842',4909651,'3051','469',88288.09,89805.80,1517.71,250422.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257842',4909652,'3052','469',443831.68,443831.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257842',4909653,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257842',4909654,'3054','470',24885.56,24885.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257842',4909655,'3055','470',129716.91,129974.81,257.90,214057.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257843',4909656,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257843',4909657,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257843',4909658,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257843',4909659,'3041','469',475707.20,476238.89,531.69,87728.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257843',4909660,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257843',4909661,'3043','469',579784.67,579784.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257843',4909662,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257843',4909663,'3045','469',544308.82,544308.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257843',4909664,'3046','469',114034.96,116770.38,2735.42,451344.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257843',4909665,'3047','469',553003.00,555652.57,2649.57,437179.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257843',4909666,'3048','469',137449.56,139894.53,2434.97,401770.05,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257843',4909667,'3049','469',695136.73,698429.30,3282.57,541624.05,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257843',4909668,'3050','469',654344.20,657176.64,2822.44,465702.60,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257843',4909669,'3051','469',89805.80,92483.06,2667.86,440196.90,0.00,0.00,9.40,0.00,0.00),('1','203','1027','257843',4909670,'3052','469',443831.68,444792.44,960.76,158525.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257843',4909671,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257843',4909672,'3054','470',24885.56,25204.44,318.88,264670.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257843',4909673,'3055','470',129974.81,130866.36,891.55,739986.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257844',4909674,'3038','469',44213.16,44213.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257844',4909675,'3039','469',367009.90,367009.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257844',4909676,'3040','469',68464.46,68464.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257844',4909677,'3041','469',476238.89,476625.47,386.58,63785.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257844',4909678,'3042','469',65578.65,65578.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257844',4909679,'3043','469',579784.67,579784.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257844',4909680,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257844',4909681,'3045','469',544308.82,544308.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257844',4909682,'3046','469',116770.38,116770.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257844',4909683,'3047','469',555652.57,557706.63,2054.06,338919.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257844',4909684,'3048','469',139894.53,139894.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257844',4909685,'3049','469',698429.30,700891.71,2462.41,406297.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257844',4909686,'3050','469',657176.64,659442.33,2265.69,373838.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257844',4909687,'3051','469',92483.06,92483.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257844',4909688,'3052','469',444792.44,444792.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257844',4909689,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257844',4909690,'3054','470',25204.44,25294.07,89.63,74392.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257844',4909691,'3055','470',130866.36,131155.78,289.42,240218.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257845',4909692,'3038','469',44213.16,45971.27,1758.11,290088.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257845',4909693,'3039','469',367009.90,368902.37,1892.47,312257.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257845',4909694,'3040','469',68464.46,70558.67,2094.21,345544.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257845',4909695,'3041','469',476625.47,478117.19,1491.72,246133.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257845',4909696,'3042','469',65578.65,67414.74,1836.09,302954.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257845',4909697,'3043','469',579784.67,581640.09,1855.42,306144.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257845',4909698,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257845',4909699,'3045','469',544308.82,546394.77,2085.95,344181.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257845',4909700,'3046','469',116770.38,116770.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257845',4909701,'3047','469',557706.63,557706.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257845',4909702,'3048','469',139894.53,139894.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257845',4909703,'3049','469',700891.71,700891.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257845',4909704,'3050','469',659442.33,659442.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257845',4909705,'3051','469',92483.06,92483.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257845',4909706,'3052','469',444792.44,445530.71,738.27,121814.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257845',4909707,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257845',4909708,'3054','470',25294.07,25496.28,202.21,167834.30,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257845',4909709,'3055','470',131155.78,131429.81,274.03,227444.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257846',4909710,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257846',4909711,'3039','469',368902.37,370994.67,2092.30,345229.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257846',4909712,'3040','469',70558.67,72122.01,1563.34,257951.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257846',4909713,'3041','469',478117.19,480110.11,1992.92,328831.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257846',4909714,'3042','469',67414.74,69333.16,1918.42,316539.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257846',4909715,'3043','469',581640.09,583315.86,1675.77,276502.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257846',4909716,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257846',4909717,'3045','469',546394.77,548304.39,1909.62,315087.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257846',4909718,'3046','469',116770.38,116770.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257846',4909719,'3047','469',557706.63,557706.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257846',4909720,'3048','469',139894.53,139894.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257846',4909721,'3049','469',700891.71,700891.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257846',4909722,'3050','469',659442.33,659442.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257846',4909723,'3051','469',92483.06,92483.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257846',4909724,'3052','469',445530.71,445530.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257846',4909725,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257846',4909726,'3054','470',25496.28,25722.67,226.39,187903.70,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257846',4909727,'3055','470',131429.81,131890.74,460.93,382571.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257847',4909728,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257847',4909729,'3039','469',370994.67,375068.12,4073.45,672119.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257847',4909730,'3040','469',72122.01,76204.76,4082.75,673653.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257847',4909731,'3041','469',480110.11,483164.50,3054.39,503974.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257847',4909732,'3042','469',69333.16,73049.42,3716.26,613182.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257847',4909733,'3043','469',583315.86,587688.87,4373.01,721546.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257847',4909734,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257847',4909735,'3045','469',548304.39,552226.46,3922.07,647141.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257847',4909736,'3046','469',116770.38,116770.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257847',4909737,'3047','469',557706.63,557706.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257847',4909738,'3048','469',139894.53,139894.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257847',4909739,'3049','469',700891.71,700891.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257847',4909740,'3050','469',659442.33,659442.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257847',4909741,'3051','469',92483.06,92483.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257847',4909742,'3052','469',445530.71,446275.75,745.04,122931.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257847',4909743,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257847',4909744,'3054','470',25722.67,26097.13,374.46,310801.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257847',4909745,'3055','470',131890.74,131949.02,58.28,48372.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257848',4909746,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257848',4909747,'3039','469',375068.12,375068.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257848',4909748,'3040','469',76204.76,76204.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257848',4909749,'3041','469',483164.50,483164.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257848',4909750,'3042','469',73049.42,73049.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257848',4909751,'3043','469',587688.87,587688.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257848',4909752,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257848',4909753,'3045','469',552226.46,552226.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257848',4909754,'3046','469',116770.38,116770.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257848',4909755,'3047','469',557706.63,557706.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257848',4909756,'3048','469',139894.53,139894.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257848',4909757,'3049','469',700891.71,700891.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257848',4909758,'3050','469',659442.33,659442.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257848',4909759,'3051','469',92483.06,92483.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257848',4909760,'3052','469',446275.75,446275.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257848',4909761,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257848',4909762,'3054','470',26097.13,26893.65,796.52,661111.60,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257848',4909763,'3055','470',131949.02,132763.37,814.35,675910.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257849',4909764,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257849',4909765,'3039','469',375068.12,375068.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257849',4909766,'3040','469',76204.76,76204.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257849',4909767,'3041','469',483164.50,483164.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257849',4909768,'3042','469',73049.42,73049.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257849',4909769,'3043','469',587688.87,587688.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257849',4909770,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257849',4909771,'3045','469',552226.46,552226.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257849',4909772,'3046','469',116770.38,118314.92,1534.54,253199.10,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257849',4909773,'3047','469',557706.63,559108.84,1392.21,229714.65,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257849',4909774,'3048','469',139894.53,141418.38,1513.85,249785.25,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257849',4909775,'3049','469',700891.71,702820.46,1918.75,316593.75,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257849',4909776,'3050','469',659442.33,661127.10,1674.77,276337.05,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257849',4909777,'3051','469',92483.06,93920.84,1427.78,235583.70,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257849',4909778,'3052','469',446275.75,448598.23,2322.48,383209.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257849',4909779,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257849',4909780,'3054','470',26893.65,27027.41,122.91,102015.30,0.00,0.00,10.85,0.00,0.00),('1','203','1028','257849',4909781,'3055','470',132763.37,133446.80,683.43,567246.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257850',4909782,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257850',4909783,'3039','469',375068.12,375068.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257850',4909784,'3040','469',76204.76,76204.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257850',4909785,'3041','469',483164.50,483164.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257850',4909786,'3042','469',73049.42,73049.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257850',4909787,'3043','469',587688.87,587688.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257850',4909788,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257850',4909789,'3045','469',552226.46,552226.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257850',4909790,'3046','469',118314.92,120864.58,2539.66,419043.90,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257850',4909791,'3047','469',559108.84,561798.82,2680.98,442361.70,0.00,0.00,9.00,0.00,0.00),('1','203','1027','257850',4909792,'3048','469',141418.38,143917.01,2498.63,412273.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257850',4909793,'3049','469',702820.46,705275.86,2455.40,405141.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257850',4909794,'3050','469',661127.10,664082.90,2955.80,487707.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257850',4909795,'3051','469',93920.84,93954.46,33.62,5547.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257850',4909796,'3052','469',448598.23,452294.33,3696.10,609856.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257850',4909797,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257850',4909798,'3054','470',27027.41,27734.05,698.64,579871.20,0.00,0.00,8.00,0.00,0.00),('1','203','1028','257850',4909799,'3055','470',133446.80,134258.51,811.71,673719.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257851',4909800,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257851',4909801,'3039','469',375068.12,375068.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257851',4909802,'3040','469',76204.76,76204.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257851',4909803,'3041','469',483164.50,483164.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257851',4909804,'3042','469',73049.42,73049.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257851',4909805,'3043','469',587688.87,587688.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257851',4909806,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257851',4909807,'3045','469',552226.46,552226.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257851',4909808,'3046','469',120864.58,123521.64,2657.06,438414.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257851',4909809,'3047','469',561798.82,564328.33,2529.51,417369.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257851',4909810,'3048','469',143917.01,146723.44,2806.43,463060.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257851',4909811,'3049','469',705275.86,708383.81,3107.95,512811.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257851',4909812,'3050','469',664082.90,667504.82,3421.92,564616.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257851',4909813,'3051','469',93954.46,93954.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257851',4909814,'3052','469',452294.33,453904.00,1609.67,265595.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257851',4909815,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257851',4909816,'3054','470',27734.05,29258.28,1524.23,1265110.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257851',4909817,'3055','470',134258.51,135494.17,1235.66,1025597.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257852',4909818,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257852',4909819,'3039','469',375068.12,375068.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257852',4909820,'3040','469',76204.76,76204.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257852',4909821,'3041','469',483164.50,483164.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257852',4909822,'3042','469',73049.42,73049.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257852',4909823,'3043','469',587688.87,587688.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257852',4909824,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257852',4909825,'3045','469',552226.46,552226.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257852',4909826,'3046','469',123521.64,123521.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257852',4909827,'3047','469',564328.33,565884.56,1556.23,256777.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257852',4909828,'3048','469',146723.44,147708.15,984.71,162477.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257852',4909829,'3049','469',708383.81,709528.68,1144.87,188903.55,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257852',4909830,'3050','469',667504.82,668566.40,1061.58,175160.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257852',4909831,'3051','469',93954.46,93954.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257852',4909832,'3052','469',453904.00,453904.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257852',4909833,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257852',4909834,'3054','470',29258.28,29484.37,226.09,187654.70,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257852',4909835,'3055','470',135494.17,135653.29,159.12,132069.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257853',4909836,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257853',4909837,'3039','469',375068.12,375068.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257853',4909838,'3040','469',76204.76,76204.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257853',4909839,'3041','469',483164.50,483164.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257853',4909840,'3042','469',73049.42,73049.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257853',4909841,'3043','469',587688.87,587688.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257853',4909842,'3044','469',41037.52,41037.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257853',4909843,'3045','469',552226.46,552226.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257853',4909844,'3046','469',123521.64,123521.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257853',4909845,'3047','469',565884.56,565884.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257853',4909846,'3048','469',147708.15,147708.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257853',4909847,'3049','469',709528.68,709528.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257853',4909848,'3050','469',668566.40,668566.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257853',4909849,'3051','469',93954.46,93954.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257853',4909850,'3052','469',453904.00,454707.18,803.18,132524.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257853',4909851,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257853',4909852,'3054','470',29484.37,29612.15,127.78,106057.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257853',4909853,'3055','470',135653.29,135922.57,269.28,223502.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257854',4909854,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257854',4909855,'3039','469',375068.12,379094.09,4025.97,664285.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257854',4909856,'3040','469',76204.76,80351.90,4147.14,684278.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257854',4909857,'3041','469',483164.50,487413.08,4248.58,701015.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257854',4909858,'3042','469',73049.42,76511.63,3462.21,571264.65,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257854',4909859,'3043','469',587688.87,591660.94,3972.07,655391.55,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257854',4909860,'3044','469',41037.52,43606.84,2569.32,423937.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257854',4909861,'3045','469',552226.46,556840.54,4614.08,761323.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257854',4909862,'3046','469',123521.64,123521.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257854',4909863,'3047','469',565884.56,565884.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257854',4909864,'3048','469',147708.15,147708.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257854',4909865,'3049','469',709528.68,709528.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257854',4909866,'3050','469',668566.40,668566.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257854',4909867,'3051','469',93954.46,93954.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257854',4909868,'3052','469',454707.18,455886.35,1179.17,194563.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257854',4909869,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257854',4909870,'3054','470',29612.15,29619.98,7.83,6498.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257854',4909871,'3055','470',135922.57,136651.95,729.38,605385.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257855',4909872,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257855',4909873,'3039','469',379094.09,379094.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257855',4909874,'3040','469',80351.90,80351.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257855',4909875,'3041','469',487413.08,487413.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257855',4909876,'3042','469',76511.63,76511.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257855',4909877,'3043','469',591660.94,591660.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257855',4909878,'3044','469',43606.84,43606.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257855',4909879,'3045','469',556840.54,556840.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257855',4909880,'3046','469',123521.64,123913.88,392.24,64719.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257855',4909881,'3047','469',565884.56,566744.74,860.18,141929.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257855',4909882,'3048','469',147708.15,148247.70,539.55,89025.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257855',4909883,'3049','469',709528.68,710542.88,1014.20,167343.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257855',4909884,'3050','469',668566.40,669396.79,830.39,137014.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257855',4909885,'3051','469',93954.46,93954.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257855',4909886,'3052','469',455886.35,456939.23,1052.88,173725.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257855',4909887,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257855',4909888,'3054','470',29619.98,30004.14,384.16,318852.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257855',4909889,'3055','470',136651.95,137129.10,477.15,396034.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257856',4909890,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257856',4909891,'3039','469',379094.09,379094.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257856',4909892,'3040','469',80351.90,80351.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257856',4909893,'3041','469',487413.08,487413.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257856',4909894,'3042','469',76511.63,76511.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257856',4909895,'3043','469',591660.94,591660.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257856',4909896,'3044','469',43606.84,43606.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257856',4909897,'3045','469',556840.54,559355.05,2514.51,414894.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257856',4909898,'3046','469',123913.88,127430.98,3517.10,580321.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257856',4909899,'3047','469',566744.74,570313.86,3569.12,588904.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257856',4909900,'3048','469',148247.70,152079.19,3831.49,632195.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257856',4909901,'3049','469',710542.88,714965.18,4422.30,729679.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257856',4909902,'3050','469',669396.79,673523.00,4126.21,680824.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257856',4909903,'3051','469',93954.46,97591.34,3636.88,600085.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257856',4909904,'3052','469',456939.23,456939.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257856',4909905,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257856',4909906,'3054','470',30004.14,30370.87,366.73,304385.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257856',4909907,'3055','470',137129.10,137427.11,298.01,247348.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257857',4909908,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257857',4909909,'3039','469',379094.09,379094.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257857',4909910,'3040','469',80351.90,80351.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257857',4909911,'3041','469',487413.08,487413.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257857',4909912,'3042','469',76511.63,76511.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257857',4909913,'3043','469',591660.94,591660.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257857',4909914,'3044','469',43606.84,43606.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257857',4909915,'3045','469',559355.05,559355.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257857',4909916,'3046','469',127430.98,127430.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257857',4909917,'3047','469',570313.86,570313.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257857',4909918,'3048','469',152079.19,152079.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257857',4909919,'3049','469',714965.18,714965.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257857',4909920,'3050','469',673523.00,673523.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257857',4909921,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257857',4909922,'3052','469',456939.23,458092.83,1143.90,188743.50,0.00,0.00,9.70,0.00,0.00),('1','203','1027','257857',4909923,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257857',4909924,'3054','470',30370.87,30629.54,258.67,214696.10,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257857',4909925,'3055','470',137427.11,138613.87,1186.76,985010.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257858',4909926,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257858',4909927,'3039','469',379094.09,380794.74,1700.65,280607.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257858',4909928,'3040','469',80351.90,81504.00,1152.10,190096.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257858',4909929,'3041','469',487413.08,488899.84,1486.76,245315.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257858',4909930,'3042','469',76511.63,78219.05,1707.42,281724.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257858',4909931,'3043','469',591660.94,593336.40,1675.46,276450.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257858',4909932,'3044','469',43606.84,44820.56,1213.72,200263.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257858',4909933,'3045','469',559355.05,560271.86,916.81,151273.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257858',4909934,'3046','469',127430.98,127430.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257858',4909935,'3047','469',570313.86,570313.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257858',4909936,'3048','469',152079.19,152079.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257858',4909937,'3049','469',714965.18,714965.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257858',4909938,'3050','469',673523.00,673523.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257858',4909939,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257858',4909940,'3052','469',458092.83,459015.55,922.72,152248.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257858',4909941,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257858',4909942,'3054','470',30629.54,30848.08,218.54,181388.20,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257858',4909943,'3055','470',138613.87,139640.22,1026.35,851870.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257859',4909944,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257859',4909945,'3039','469',380794.74,383572.88,2778.14,458393.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257859',4909946,'3040','469',81504.00,83631.17,2127.17,350983.05,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257859',4909947,'3041','469',488899.84,491330.96,2431.12,401134.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257859',4909948,'3042','469',78219.05,80989.94,2770.89,457196.85,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257859',4909949,'3043','469',593336.40,596057.82,2721.42,449034.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257859',4909950,'3044','469',44820.56,47268.96,2448.40,403986.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257859',4909951,'3045','469',560271.86,561752.91,1481.05,244373.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257859',4909952,'3046','469',127430.98,127430.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257859',4909953,'3047','469',570313.86,570313.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257859',4909954,'3048','469',152079.19,152079.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257859',4909955,'3049','469',714965.18,714965.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257859',4909956,'3050','469',673523.00,673523.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257859',4909957,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257859',4909958,'3052','469',459015.55,459559.36,533.81,88078.65,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257859',4909959,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257859',4909960,'3054','470',30848.08,30848.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257859',4909961,'3055','470',139640.22,140178.43,538.21,446714.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257860',4909962,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257860',4909963,'3039','469',383572.88,384334.79,761.91,125715.15,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257860',4909964,'3040','469',83631.17,83985.12,353.95,58401.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257860',4909965,'3041','469',491330.96,492114.01,783.05,129203.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257860',4909966,'3042','469',80989.94,81717.74,727.80,120087.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257860',4909967,'3043','469',596057.82,596772.36,714.54,117899.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257860',4909968,'3044','469',47268.96,48048.35,779.39,128599.35,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257860',4909969,'3045','469',561752.91,562062.96,310.05,51158.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257860',4909970,'3046','469',127430.98,127430.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257860',4909971,'3047','469',570313.86,570313.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257860',4909972,'3048','469',152079.19,152079.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257860',4909973,'3049','469',714965.18,714965.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257860',4909974,'3050','469',673523.00,673523.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257860',4909975,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257860',4909976,'3052','469',459559.36,459559.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257860',4909977,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257860',4909978,'3054','470',30848.08,30848.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257860',4909979,'3055','470',140178.43,140654.55,476.12,395179.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257861',4909980,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257861',4909981,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257861',4909982,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257861',4909983,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257861',4909984,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257861',4909985,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257861',4909986,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257861',4909987,'3045','469',562062.96,562288.27,225.31,41682.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257861',4909988,'3046','469',127430.98,127430.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257861',4909989,'3047','469',570313.86,570313.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257861',4909990,'3048','469',152079.19,152079.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257861',4909991,'3049','469',714965.18,714965.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257861',4909992,'3050','469',673523.00,673523.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257861',4909993,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257861',4909994,'3052','469',459559.36,459559.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257861',4909995,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257861',4909996,'3054','470',30848.08,30848.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257861',4909997,'3055','470',140654.55,140654.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257862',4909998,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257862',4909999,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257862',4910000,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257862',4910001,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257862',4910002,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257862',4910003,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257862',4910004,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257862',4910005,'3045','469',562288.27,562858.27,570.00,94050.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257862',4910006,'3046','469',127430.98,129165.84,1734.86,286251.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257862',4910007,'3047','469',570313.86,572724.34,2410.48,397729.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257862',4910008,'3048','469',152079.19,153903.29,1824.10,300976.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257862',4910009,'3049','469',714965.18,717360.23,2395.05,395183.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257862',4910010,'3050','469',673523.00,675905.39,2382.39,393094.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257862',4910011,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257862',4910012,'3052','469',459559.36,462204.15,2644.79,436390.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257862',4910013,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257862',4910014,'3054','470',30848.08,31159.19,311.11,258221.30,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257862',4910015,'3055','470',140654.55,141251.53,596.98,495493.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257863',4910016,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257863',4910017,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257863',4910018,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257863',4910019,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257863',4910020,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257863',4910021,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257863',4910022,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257863',4910023,'3045','469',562858.27,563399.84,541.57,89359.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257863',4910024,'3046','469',129165.84,129165.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257863',4910025,'3047','469',572724.34,572724.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257863',4910026,'3048','469',153903.29,153903.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257863',4910027,'3049','469',717360.23,717360.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257863',4910028,'3050','469',675905.39,675905.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257863',4910029,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257863',4910030,'3052','469',462204.15,462204.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257863',4910031,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257863',4910032,'3054','470',31159.19,31324.94,165.75,137572.50,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257863',4910033,'3055','470',141251.53,141950.25,698.72,579937.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257864',4910034,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257864',4910035,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257864',4910036,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257864',4910037,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257864',4910038,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257864',4910039,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257864',4910040,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257864',4910041,'3045','469',563399.84,563620.59,220.75,36423.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257864',4910042,'3046','469',129165.84,129165.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257864',4910043,'3047','469',572724.34,572724.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257864',4910044,'3048','469',153903.29,153903.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257864',4910045,'3049','469',717360.23,717360.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257864',4910046,'3050','469',675905.39,675905.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257864',4910047,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257864',4910048,'3052','469',462204.15,462204.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257864',4910049,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257864',4910050,'3054','470',31324.94,31324.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257864',4910051,'3055','470',141950.25,142186.80,236.55,196336.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257865',4910052,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257865',4910053,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257865',4910054,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257865',4910055,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257865',4910056,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257865',4910057,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257865',4910058,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257865',4910059,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257865',4910060,'3046','469',129165.84,129225.84,60.00,9900.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257865',4910061,'3047','469',572724.34,573050.70,326.36,53849.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257865',4910062,'3048','469',153903.29,154142.27,238.98,39431.70,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257865',4910063,'3049','469',717360.23,717718.78,358.55,59160.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257865',4910064,'3050','469',675905.39,676182.60,277.21,45739.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257865',4910065,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257865',4910066,'3052','469',462204.15,462655.47,451.32,74467.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257865',4910067,'3053','469',98756.91,98756.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257865',4910068,'3054','470',31324.94,31324.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257865',4910069,'3055','470',142186.80,142186.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257866',4910070,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257866',4910071,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257866',4910072,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257866',4910073,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257866',4910074,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257866',4910075,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257866',4910076,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257866',4910077,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257866',4910078,'3046','469',129225.84,133751.57,4525.73,837260.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257866',4910079,'3047','469',573050.70,578780.82,5730.12,1060072.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257866',4910080,'3048','469',154142.27,158760.06,4617.79,854291.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257866',4910081,'3049','469',717718.78,723109.26,5390.48,997238.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257866',4910082,'3050','469',676182.60,681392.96,5210.36,963916.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257866',4910083,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257866',4910084,'3052','469',462655.47,463316.60,661.13,122309.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257866',4910085,'3053','469',98756.91,98757.91,1.00,185.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257866',4910086,'3054','470',31324.94,32271.08,946.14,785296.20,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257866',4910087,'3055','470',142186.80,142545.79,358.99,297961.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257867',4910088,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257867',4910089,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257867',4910090,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257867',4910091,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257867',4910092,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257867',4910093,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257867',4910094,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257867',4910095,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257867',4910096,'3046','469',133751.57,133751.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257867',4910097,'3047','469',578780.82,578780.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257867',4910098,'3048','469',158760.06,158760.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257867',4910099,'3049','469',723109.26,723109.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257867',4910100,'3050','469',681392.96,681392.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257867',4910101,'3051','469',97591.34,97591.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257867',4910102,'3052','469',463316.60,463837.67,521.07,96397.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257867',4910103,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257867',4910104,'3054','470',32271.08,32271.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257867',4910105,'3055','470',142545.79,143473.57,927.78,770057.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257868',4910106,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257868',4910107,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257868',4910108,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257868',4910109,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257868',4910110,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257868',4910111,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257868',4910112,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257868',4910113,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257868',4910114,'3046','469',133751.57,135528.65,1762.28,326021.80,0.00,0.00,14.80,0.00,0.00),('1','203','1027','257868',4910115,'3047','469',578780.82,580583.41,1782.59,329779.15,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257868',4910116,'3048','469',158760.06,160572.57,1792.51,331614.35,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257868',4910117,'3049','469',723109.26,724603.45,1494.19,276425.15,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257868',4910118,'3050','469',681392.96,683829.04,2436.08,450674.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257868',4910119,'3051','469',97591.34,97591.48,0.14,25.90,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257868',4910120,'3052','469',463837.67,466641.11,2803.44,518636.40,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257868',4910121,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257868',4910122,'3054','470',32271.08,32271.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257868',4910123,'3055','470',143473.57,144694.28,1220.71,1013189.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257869',4910124,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257869',4910125,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257869',4910126,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257869',4910127,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257869',4910128,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257869',4910129,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257869',4910130,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257869',4910131,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257869',4910132,'3046','469',135528.65,135528.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257869',4910133,'3047','469',580583.41,582216.52,1633.11,302125.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257869',4910134,'3048','469',160572.57,160572.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257869',4910135,'3049','469',724603.45,726326.37,1722.92,318740.20,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257869',4910136,'3050','469',683829.04,685452.42,1623.38,300325.30,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257869',4910137,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257869',4910138,'3052','469',466641.11,468323.33,1672.22,309360.70,0.00,0.00,10.00,0.00,0.00),('1','203','1027','257869',4910139,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257869',4910140,'3054','470',32271.08,32425.84,154.76,128450.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257869',4910141,'3055','470',144694.28,144857.11,162.83,135148.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257870',4910142,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257870',4910143,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257870',4910144,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257870',4910145,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257870',4910146,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257870',4910147,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257870',4910148,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257870',4910149,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257870',4910150,'3046','469',135528.65,137824.91,2296.26,424808.10,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257870',4910151,'3047','469',582216.52,584161.77,1945.25,359871.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257870',4910152,'3048','469',160572.57,162686.02,2113.45,390988.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257870',4910153,'3049','469',726326.37,728321.28,1994.91,369058.35,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257870',4910154,'3050','469',685452.42,687686.35,2233.93,413277.05,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257870',4910155,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257870',4910156,'3052','469',468323.33,471134.98,2811.65,520155.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257870',4910157,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257870',4910158,'3054','470',32425.84,32425.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257870',4910159,'3055','470',144857.11,145412.20,555.09,460724.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257871',4910160,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257871',4910161,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257871',4910162,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257871',4910163,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257871',4910164,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257871',4910165,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257871',4910166,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257871',4910167,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257871',4910168,'3046','469',137824.91,137824.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257871',4910169,'3047','469',584161.77,586082.66,1920.89,355364.65,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257871',4910170,'3048','469',162686.02,164505.63,1819.61,336627.85,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257871',4910171,'3049','469',728321.28,730159.55,1838.27,340079.95,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257871',4910172,'3050','469',687686.35,689865.63,2179.28,403166.80,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257871',4910173,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257871',4910174,'3052','469',471134.98,472665.94,1530.96,283227.60,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257871',4910175,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257871',4910176,'3054','470',32425.84,32596.26,170.42,141448.60,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257871',4910177,'3055','470',145412.20,145546.90,134.70,111801.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257872',4910178,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257872',4910179,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257872',4910180,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257872',4910181,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257872',4910182,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257872',4910183,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257872',4910184,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257872',4910185,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257872',4910186,'3046','469',137824.91,137824.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257872',4910187,'3047','469',586082.66,586082.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257872',4910188,'3048','469',164505.63,164505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257872',4910189,'3049','469',730159.55,730159.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257872',4910190,'3050','469',689865.63,689865.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257872',4910191,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257872',4910192,'3052','469',472665.94,472665.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257872',4910193,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257872',4910194,'3054','470',32596.26,32596.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257872',4910195,'3055','470',145546.90,145753.58,206.68,171544.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257873',4910196,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257873',4910197,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257873',4910198,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257873',4910199,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257873',4910200,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257873',4910201,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257873',4910202,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257873',4910203,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257873',4910204,'3046','469',137824.91,137824.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257873',4910205,'3047','469',586082.66,586082.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257873',4910206,'3048','469',164505.63,164505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257873',4910207,'3049','469',730159.55,730159.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257873',4910208,'3050','469',689865.63,689865.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257873',4910209,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257873',4910210,'3052','469',472665.94,472665.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257873',4910211,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257873',4910212,'3054','470',32596.26,33320.49,724.23,601110.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257873',4910213,'3055','470',145753.58,146364.01,610.43,506656.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257874',4910214,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257874',4910215,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257874',4910216,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257874',4910217,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257874',4910218,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257874',4910219,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257874',4910220,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257874',4910221,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257874',4910222,'3046','469',137824.91,137824.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257874',4910223,'3047','469',586082.66,586082.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257874',4910224,'3048','469',164505.63,164505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257874',4910225,'3049','469',730159.55,730159.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257874',4910226,'3050','469',689865.63,689865.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257874',4910227,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257874',4910228,'3052','469',472665.94,472665.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257874',4910229,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257874',4910230,'3054','470',33320.49,33633.28,312.79,259615.70,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257874',4910231,'3055','470',146364.01,146549.05,185.04,153583.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257875',4910232,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257875',4910233,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257875',4910234,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257875',4910235,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257875',4910236,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257875',4910237,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257875',4910238,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257875',4910239,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257875',4910240,'3046','469',137824.91,137824.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257875',4910241,'3047','469',586082.66,586082.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257875',4910242,'3048','469',164505.63,164505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257875',4910243,'3049','469',730159.55,730159.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257875',4910244,'3050','469',689865.63,689865.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257875',4910245,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257875',4910246,'3052','469',472665.94,472665.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257875',4910247,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257875',4910248,'3054','470',33633.28,34059.28,417.08,346176.40,0.00,0.00,8.92,0.00,0.00),('1','203','1028','257875',4910249,'3055','470',146549.05,147306.94,757.89,629048.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257876',4910250,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257876',4910251,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257876',4910252,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257876',4910253,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257876',4910254,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257876',4910255,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257876',4910256,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257876',4910257,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257876',4910258,'3046','469',137824.91,137824.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257876',4910259,'3047','469',586082.66,586082.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257876',4910260,'3048','469',164505.63,164505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257876',4910261,'3049','469',730159.55,730159.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257876',4910262,'3050','469',689865.63,689865.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257876',4910263,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257876',4910264,'3052','469',472665.94,472665.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257876',4910265,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257876',4910266,'3054','470',34059.28,34761.34,702.06,582709.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257876',4910267,'3055','470',147306.94,148065.10,758.16,629272.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257877',4910268,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257877',4910269,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257877',4910270,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257877',4910271,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257877',4910272,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257877',4910273,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257877',4910274,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257877',4910275,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257877',4910276,'3046','469',137824.91,137824.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257877',4910277,'3047','469',586082.66,586082.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257877',4910278,'3048','469',164505.63,164505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257877',4910279,'3049','469',730159.55,730159.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257877',4910280,'3050','469',689865.63,689865.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257877',4910281,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257877',4910282,'3052','469',472665.94,472665.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257877',4910283,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257877',4910284,'3054','470',34761.34,35071.10,309.76,257100.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257877',4910285,'3055','470',148065.10,148428.93,363.83,301978.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257878',4910286,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257878',4910287,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257878',4910288,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257878',4910289,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257878',4910290,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257878',4910291,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257878',4910292,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257878',4910293,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257878',4910294,'3046','469',137824.91,137824.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257878',4910295,'3047','469',586082.66,586082.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257878',4910296,'3048','469',164505.63,164505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257878',4910297,'3049','469',730159.55,730159.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257878',4910298,'3050','469',689865.63,689865.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257878',4910299,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257878',4910300,'3052','469',472665.94,472665.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257878',4910301,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257878',4910302,'3054','470',35071.10,35467.10,393.56,322719.20,0.00,0.00,2.44,0.00,0.00),('1','203','1028','257878',4910303,'3055','470',148428.93,148897.94,469.01,384588.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257879',4910304,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257879',4910305,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257879',4910306,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257879',4910307,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257879',4910308,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257879',4910309,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257879',4910310,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257879',4910311,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257879',4910312,'3046','469',137824.91,137824.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257879',4910313,'3047','469',586082.66,586082.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257879',4910314,'3048','469',164505.63,164505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257879',4910315,'3049','469',730159.55,730159.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257879',4910316,'3050','469',689865.63,689865.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257879',4910317,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257879',4910318,'3052','469',472665.94,472665.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257879',4910319,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257879',4910320,'3054','470',35467.10,35910.40,443.30,363506.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257879',4910321,'3055','470',148897.94,148976.53,78.59,64443.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257880',4910322,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257880',4910323,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257880',4910324,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257880',4910325,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257880',4910326,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257880',4910327,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257880',4910328,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257880',4910329,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257880',4910330,'3046','469',137824.91,137824.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257880',4910331,'3047','469',586082.66,586082.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257880',4910332,'3048','469',164505.63,164505.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257880',4910333,'3049','469',730159.55,730159.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257880',4910334,'3050','469',689865.63,689865.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257880',4910335,'3051','469',97591.48,97591.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257880',4910336,'3052','469',472665.94,472665.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257880',4910337,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257880',4910338,'3054','470',35910.40,36143.47,233.07,188786.70,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257880',4910339,'3055','470',148976.53,149235.91,259.38,210097.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257881',4910340,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257881',4910341,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257881',4910342,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257881',4910343,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257881',4910344,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257881',4910345,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257881',4910346,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257881',4910347,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257881',4910348,'3046','469',137824.91,139651.49,1806.58,316151.50,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257881',4910349,'3047','469',586082.66,588278.48,2175.82,380768.50,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257881',4910350,'3048','469',164505.63,166565.79,2041.01,357176.75,0.00,0.00,19.15,0.00,0.00),('1','203','1027','257881',4910351,'3049','469',730159.55,732098.78,1939.23,339365.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257881',4910352,'3050','469',689865.63,691735.06,1869.43,327150.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257881',4910353,'3051','469',97591.48,99461.31,1869.83,327220.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257881',4910354,'3052','469',472665.94,475293.08,2627.14,459749.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257881',4910355,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257881',4910356,'3054','470',36143.47,36744.41,600.94,486761.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257881',4910357,'3055','470',149235.91,149499.49,263.58,213499.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257882',4910358,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257882',4910359,'3039','469',384334.79,384334.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257882',4910360,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257882',4910361,'3041','469',492114.01,492114.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257882',4910362,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257882',4910363,'3043','469',596772.36,596772.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257882',4910364,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257882',4910365,'3045','469',563620.59,563620.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257882',4910366,'3046','469',139651.49,139651.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257882',4910367,'3047','469',588278.48,591192.25,2913.77,509909.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257882',4910368,'3048','469',166565.79,168836.62,2270.83,397395.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257882',4910369,'3049','469',732098.78,734479.73,2380.95,416666.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257882',4910370,'3050','469',691735.06,693699.93,1964.87,343852.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257882',4910371,'3051','469',99461.31,101556.56,2095.25,366668.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257882',4910372,'3052','469',475293.08,478015.26,2722.18,476381.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257882',4910373,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257882',4910374,'3054','470',36744.41,36767.87,23.46,19002.60,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257882',4910375,'3055','470',149499.49,149615.86,116.37,94259.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257883',4910376,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257883',4910377,'3039','469',384334.79,385903.27,1547.98,270896.50,0.00,0.00,20.50,0.00,0.00),('1','203','1026','257883',4910378,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257883',4910379,'3041','469',492114.01,493766.42,1652.41,289171.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257883',4910380,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257883',4910381,'3043','469',596772.36,598357.21,1584.85,277348.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257883',4910382,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257883',4910383,'3045','469',563620.59,565000.91,1380.32,241556.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257883',4910384,'3046','469',139651.49,139651.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257883',4910385,'3047','469',591192.25,593525.71,2333.46,408355.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257883',4910386,'3048','469',168836.62,168836.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257883',4910387,'3049','469',734479.73,736766.84,2287.11,400244.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257883',4910388,'3050','469',693699.93,696230.49,2530.56,442848.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257883',4910389,'3051','469',101556.56,101556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257883',4910390,'3052','469',478015.26,478322.91,307.65,53838.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257883',4910391,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257883',4910392,'3054','470',36767.87,37001.45,233.58,189199.80,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257883',4910393,'3055','470',149615.86,149646.60,30.74,24899.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257884',4910394,'3038','469',45971.27,45971.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257884',4910395,'3039','469',385903.27,389568.20,3647.78,638361.50,0.00,0.00,17.15,0.00,0.00),('1','203','1026','257884',4910396,'3040','469',83985.12,83985.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257884',4910397,'3041','469',493766.42,497233.89,3467.47,606807.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257884',4910398,'3042','469',81717.74,81717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257884',4910399,'3043','469',598357.21,601187.47,2830.26,495295.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257884',4910400,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257884',4910401,'3045','469',565000.91,567843.05,2842.14,497374.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257884',4910402,'3046','469',139651.49,139651.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257884',4910403,'3047','469',593525.71,596253.73,2728.02,477403.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257884',4910404,'3048','469',168836.62,168836.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257884',4910405,'3049','469',736766.84,740623.59,3856.75,674931.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257884',4910406,'3050','469',696230.49,699397.02,3166.53,554142.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257884',4910407,'3051','469',101556.56,101556.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257884',4910408,'3052','469',478322.91,478322.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257884',4910409,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257884',4910410,'3054','470',37001.45,37389.01,387.56,313923.60,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257884',4910411,'3055','470',149646.60,150006.87,360.27,291818.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257885',4910412,'3038','469',45971.27,46950.13,978.86,171300.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257885',4910413,'3039','469',389568.20,393251.56,3683.36,644588.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257885',4910414,'3040','469',83985.12,84950.72,965.60,168980.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257885',4910415,'3041','469',497233.89,500835.17,3601.28,630224.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257885',4910416,'3042','469',81717.74,82696.56,978.82,171293.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257885',4910417,'3043','469',601187.47,604278.83,3091.36,540988.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257885',4910418,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257885',4910419,'3045','469',567843.05,568788.80,945.75,165506.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257885',4910420,'3046','469',139651.49,140422.37,770.88,134904.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257885',4910421,'3047','469',596253.73,598821.61,2567.88,449379.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257885',4910422,'3048','469',168836.62,169419.34,582.72,101976.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257885',4910423,'3049','469',740623.59,743883.65,3260.06,570510.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257885',4910424,'3050','469',699397.02,702373.69,2976.67,520917.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257885',4910425,'3051','469',101556.56,102223.62,667.06,116735.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257885',4910426,'3052','469',478322.91,482225.51,3892.46,681180.50,0.00,0.00,10.14,0.00,0.00),('1','203','1027','257885',4910427,'3053','469',98757.91,98757.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257885',4910428,'3054','470',37389.01,37413.70,24.69,19998.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257885',4910429,'3055','470',150006.87,151317.33,1310.46,1061472.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257886',4910430,'3038','469',46950.13,46950.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257886',4910431,'3039','469',393251.56,393251.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257886',4910432,'3040','469',84950.72,84950.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257886',4910433,'3041','469',500835.17,500835.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257886',4910434,'3042','469',82696.56,82696.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257886',4910435,'3043','469',604278.83,604278.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257886',4910436,'3044','469',48048.35,48048.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257886',4910437,'3045','469',568788.80,568788.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257886',4910438,'3046','469',140422.37,143687.74,3265.37,571439.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257886',4910439,'3047','469',598821.61,601607.27,2785.66,487490.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257886',4910440,'3048','469',169419.34,172587.22,3167.88,554379.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257886',4910441,'3049','469',743883.65,746692.25,2808.60,491505.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257886',4910442,'3050','469',702373.69,705071.18,2697.49,472060.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257886',4910443,'3051','469',102223.62,105002.58,2778.96,486318.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257886',4910444,'3052','469',482225.51,485006.97,2781.46,486755.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257886',4910445,'3053','469',98757.91,101185.34,2427.43,424800.25,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257886',4910446,'3054','470',37413.70,37413.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257886',4910447,'3055','470',151317.33,151317.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257887',4910448,'3038','469',46950.13,47685.47,735.34,128684.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257887',4910449,'3039','469',393251.56,394850.09,1598.53,279742.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257887',4910450,'3040','469',84950.72,85517.96,567.24,99267.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257887',4910451,'3041','469',500835.17,502607.34,1772.17,310129.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257887',4910452,'3042','469',82696.56,83213.33,516.77,90434.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257887',4910453,'3043','469',604278.83,605920.63,1641.80,287315.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257887',4910454,'3044','469',48048.35,48593.31,544.96,95368.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257887',4910455,'3045','469',568788.80,570082.28,1293.48,226359.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257887',4910456,'3046','469',143687.74,145037.42,1349.68,236194.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257887',4910457,'3047','469',601607.27,603694.34,2087.07,365237.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257887',4910458,'3048','469',172587.22,173784.86,1197.64,209587.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257887',4910459,'3049','469',746692.25,748923.23,2230.98,390421.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257887',4910460,'3050','469',705071.18,707184.96,2113.78,369911.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257887',4910461,'3051','469',105002.58,106284.23,1281.65,224288.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257887',4910462,'3052','469',485006.97,486994.52,1987.55,347821.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257887',4910463,'3053','469',101185.34,102562.71,1377.37,241039.75,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257887',4910464,'3054','470',37413.70,37413.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257887',4910465,'3055','470',151317.33,151317.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257888',4910466,'3038','469',47685.47,50686.42,3000.95,525166.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257888',4910467,'3039','469',394850.09,397309.93,2459.84,430472.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257888',4910468,'3040','469',85517.96,87702.07,2184.11,382219.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257888',4910469,'3041','469',502607.34,505151.28,2543.94,445189.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257888',4910470,'3042','469',83213.33,85875.10,2661.77,465809.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257888',4910471,'3043','469',605920.63,608194.11,2273.48,397859.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257888',4910472,'3044','469',48593.31,51226.30,2632.99,460773.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257888',4910473,'3045','469',570082.28,571792.78,1710.50,299337.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257888',4910474,'3046','469',145037.42,145037.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257888',4910475,'3047','469',603694.34,603694.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257888',4910476,'3048','469',173784.86,173784.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257888',4910477,'3049','469',748923.23,748923.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257888',4910478,'3050','469',707184.96,707184.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257888',4910479,'3051','469',106284.23,106284.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257888',4910480,'3052','469',486994.52,486994.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257888',4910481,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257888',4910482,'3054','470',37413.70,37413.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257888',4910483,'3055','470',151317.33,151317.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257889',4910484,'3038','469',50686.42,50686.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257889',4910485,'3039','469',397309.93,397503.16,193.23,33815.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257889',4910486,'3040','469',87702.07,87702.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257889',4910487,'3041','469',505151.28,505329.22,177.94,31139.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257889',4910488,'3042','469',85875.10,85875.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257889',4910489,'3043','469',608194.11,608367.98,173.87,30427.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257889',4910490,'3044','469',51226.30,51226.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257889',4910491,'3045','469',571792.78,571974.69,181.91,31834.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257889',4910492,'3046','469',145037.42,145037.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257889',4910493,'3047','469',603694.34,603694.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257889',4910494,'3048','469',173784.86,173784.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257889',4910495,'3049','469',748923.23,748923.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257889',4910496,'3050','469',707184.96,707184.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257889',4910497,'3051','469',106284.23,106284.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257889',4910498,'3052','469',486994.52,486994.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257889',4910499,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257889',4910500,'3054','470',37413.70,37413.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257889',4910501,'3055','470',151317.33,151317.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257890',4910502,'3038','469',50686.42,50686.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257890',4910503,'3039','469',397503.16,397503.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257890',4910504,'3040','469',87702.07,87702.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257890',4910505,'3041','469',505329.22,505329.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257890',4910506,'3042','469',85875.10,85875.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257890',4910507,'3043','469',608367.98,608367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257890',4910508,'3044','469',51226.30,51226.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257890',4910509,'3045','469',571974.69,571974.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257890',4910510,'3046','469',145037.42,145037.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257890',4910511,'3047','469',603694.34,603694.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257890',4910512,'3048','469',173784.86,173784.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257890',4910513,'3049','469',748923.23,748923.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257890',4910514,'3050','469',707184.96,707184.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257890',4910515,'3051','469',106284.23,106284.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257890',4910516,'3052','469',486994.52,486994.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257890',4910517,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257890',4910518,'3054','470',37413.70,37663.54,234.84,190220.40,0.00,0.00,15.00,0.00,0.00),('1','203','1028','257890',4910519,'3055','470',151317.33,151807.21,479.88,388702.80,0.00,0.00,10.00,0.00,0.00),('1','203','1026','257891',4910520,'3038','469',50686.42,50686.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257891',4910521,'3039','469',397503.16,397503.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257891',4910522,'3040','469',87702.07,87702.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257891',4910523,'3041','469',505329.22,505329.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257891',4910524,'3042','469',85875.10,85875.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257891',4910525,'3043','469',608367.98,608367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257891',4910526,'3044','469',51226.30,52415.40,1169.10,204592.50,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257891',4910527,'3045','469',571974.69,571974.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257891',4910528,'3046','469',145037.42,145886.45,834.03,145955.25,0.00,0.00,15.00,0.00,0.00),('1','203','1027','257891',4910529,'3047','469',603694.34,606272.91,2578.57,451249.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257891',4910530,'3048','469',173784.86,176088.22,2303.36,403088.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257891',4910531,'3049','469',748923.23,751345.21,2421.98,423846.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257891',4910532,'3050','469',707184.96,709411.67,2226.71,389674.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257891',4910533,'3051','469',106284.23,108388.05,2103.82,368168.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257891',4910534,'3052','469',486994.52,489826.65,2832.13,495622.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257891',4910535,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257891',4910536,'3054','470',37663.54,38990.78,1327.24,1075064.40,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257891',4910537,'3055','470',151807.21,152336.20,528.99,428481.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257892',4910538,'3038','469',50686.42,50686.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257892',4910539,'3039','469',397503.16,397503.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257892',4910540,'3040','469',87702.07,87702.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257892',4910541,'3041','469',505329.22,505329.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257892',4910542,'3042','469',85875.10,85875.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257892',4910543,'3043','469',608367.98,608367.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257892',4910544,'3044','469',52415.40,52415.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257892',4910545,'3045','469',571974.69,571974.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257892',4910546,'3046','469',145886.45,145886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257892',4910547,'3047','469',606272.91,606272.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257892',4910548,'3048','469',176088.22,176088.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257892',4910549,'3049','469',751345.21,751345.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257892',4910550,'3050','469',709411.67,709411.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257892',4910551,'3051','469',108388.05,108388.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257892',4910552,'3052','469',489826.65,489826.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257892',4910553,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257892',4910554,'3054','470',38990.78,39373.24,382.46,309792.60,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257892',4910555,'3055','470',152336.20,153094.46,758.26,614190.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257893',4910556,'3038','469',50686.42,50686.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257893',4910557,'3039','469',397503.16,399386.40,1863.24,326067.00,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257893',4910558,'3040','469',87702.07,87702.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257893',4910559,'3041','469',505329.22,507147.84,1798.62,314758.50,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257893',4910560,'3042','469',85875.10,87249.13,1368.03,239405.25,0.00,0.00,6.00,0.00,0.00),('1','203','1026','257893',4910561,'3043','469',608367.98,609330.32,962.34,168409.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257893',4910562,'3044','469',52415.40,52825.16,409.76,71708.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257893',4910563,'3045','469',571974.69,572341.33,366.64,64162.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257893',4910564,'3046','469',145886.45,145886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257893',4910565,'3047','469',606272.91,610297.78,4024.87,704352.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257893',4910566,'3048','469',176088.22,176732.64,644.42,112773.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257893',4910567,'3049','469',751345.21,755641.14,4295.93,751787.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257893',4910568,'3050','469',709411.67,713418.21,4006.54,701144.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257893',4910569,'3051','469',108388.05,109453.68,1065.63,186485.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257893',4910570,'3052','469',489826.65,494442.42,4615.77,807759.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257893',4910571,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257893',4910572,'3054','470',39373.24,39728.35,355.11,287639.10,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257893',4910573,'3055','470',153094.46,154388.06,1293.60,1047816.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257894',4910574,'3038','469',50686.42,50856.42,170.00,29750.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257894',4910575,'3039','469',399386.40,401927.95,2541.55,444771.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257894',4910576,'3040','469',87702.07,87702.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257894',4910577,'3041','469',507147.84,510059.66,2911.82,509568.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257894',4910578,'3042','469',87249.13,87809.09,559.96,97993.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257894',4910579,'3043','469',609330.32,611982.35,2652.03,464105.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257894',4910580,'3044','469',52825.16,53340.47,515.31,90179.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257894',4910581,'3045','469',572341.33,572393.27,51.94,9089.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257894',4910582,'3046','469',145886.45,145886.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257894',4910583,'3047','469',610297.78,611959.05,1661.27,290722.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257894',4910584,'3048','469',176732.64,176732.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257894',4910585,'3049','469',755641.14,757919.97,2278.83,398795.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257894',4910586,'3050','469',713418.21,715260.58,1842.37,322414.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257894',4910587,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257894',4910588,'3052','469',494442.42,496236.32,1793.90,313932.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257894',4910589,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257894',4910590,'3054','470',39728.35,39882.18,153.83,124602.30,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257894',4910591,'3055','470',154388.06,154670.30,282.24,228614.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257895',4910592,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257895',4910593,'3039','469',401927.95,404380.49,2452.54,429194.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257895',4910594,'3040','469',87702.07,87702.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257895',4910595,'3041','469',510059.66,512817.78,2752.40,481670.00,0.00,0.00,5.72,0.00,0.00),('1','203','1026','257895',4910596,'3042','469',87809.09,90057.88,2248.79,393538.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257895',4910597,'3043','469',611982.35,611982.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257895',4910598,'3044','469',53340.47,53442.42,101.95,17841.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257895',4910599,'3045','469',572393.27,572842.29,449.02,78578.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257895',4910600,'3046','469',145886.45,147431.24,1544.79,270338.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257895',4910601,'3047','469',611959.05,616386.68,4427.63,774835.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257895',4910602,'3048','469',176732.64,178130.16,1397.52,244566.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257895',4910603,'3049','469',757919.97,762823.33,4903.36,858088.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257895',4910604,'3050','469',715260.58,720389.70,5129.12,897596.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257895',4910605,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257895',4910606,'3052','469',496236.32,501910.31,5673.99,992948.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257895',4910607,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257895',4910608,'3054','470',39882.18,40145.27,263.09,213102.90,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257895',4910609,'3055','470',154670.30,154971.15,300.85,243688.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257896',4910610,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257896',4910611,'3039','469',404380.49,407328.52,2948.03,515905.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257896',4910612,'3040','469',87702.07,87702.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257896',4910613,'3041','469',512817.78,516505.54,3687.76,645358.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257896',4910614,'3042','469',90057.88,90057.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257896',4910615,'3043','469',611982.35,614212.55,2230.20,390285.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257896',4910616,'3044','469',53442.42,53442.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257896',4910617,'3045','469',572842.29,572842.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257896',4910618,'3046','469',147431.24,147431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257896',4910619,'3047','469',616386.68,620548.71,4162.03,728355.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257896',4910620,'3048','469',178130.16,178130.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257896',4910621,'3049','469',762823.33,767291.42,4468.09,781915.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257896',4910622,'3050','469',720389.70,720389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257896',4910623,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257896',4910624,'3052','469',501910.31,504989.97,3079.66,538940.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257896',4910625,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257896',4910626,'3054','470',40145.27,40145.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257896',4910627,'3055','470',154971.15,156387.28,1416.13,1147065.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257897',4910628,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257897',4910629,'3039','469',407328.52,411058.16,3729.64,652687.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257897',4910630,'3040','469',87702.07,87867.08,165.01,28876.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257897',4910631,'3041','469',516505.54,519979.47,3473.93,607937.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257897',4910632,'3042','469',90057.88,90308.56,250.68,43869.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257897',4910633,'3043','469',614212.55,614485.74,273.19,47808.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257897',4910634,'3044','469',53442.42,55915.68,2473.26,432820.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257897',4910635,'3045','469',572842.29,573267.70,425.41,74446.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257897',4910636,'3046','469',147431.24,147431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257897',4910637,'3047','469',620548.71,624471.76,3923.05,686533.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257897',4910638,'3048','469',178130.16,178130.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257897',4910639,'3049','469',767291.42,771047.15,3755.73,657252.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257897',4910640,'3050','469',720389.70,723435.68,3045.98,533046.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257897',4910641,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257897',4910642,'3052','469',504989.97,508316.78,3326.81,582191.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257897',4910643,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257897',4910644,'3054','470',40145.27,40145.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257897',4910645,'3055','470',156387.28,157448.13,1060.85,859288.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257898',4910646,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257898',4910647,'3039','469',411058.16,413587.95,2529.79,442713.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257898',4910648,'3040','469',87867.08,87867.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257898',4910649,'3041','469',519979.47,523153.80,3174.33,555507.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257898',4910650,'3042','469',90308.56,90308.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257898',4910651,'3043','469',614485.74,617335.14,2849.40,498645.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257898',4910652,'3044','469',55915.68,57298.62,1382.94,242014.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257898',4910653,'3045','469',573267.70,574010.89,743.19,130058.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257898',4910654,'3046','469',147431.24,147431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257898',4910655,'3047','469',624471.76,624471.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257898',4910656,'3048','469',178130.16,178130.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257898',4910657,'3049','469',771047.15,771047.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257898',4910658,'3050','469',723435.68,723435.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257898',4910659,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257898',4910660,'3052','469',508316.78,508316.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257898',4910661,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257898',4910662,'3054','470',40145.27,40145.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257898',4910663,'3055','470',157448.13,157652.31,204.18,165385.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257899',4910664,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257899',4910665,'3039','469',413587.95,416251.68,2663.73,466152.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257899',4910666,'3040','469',87867.08,87867.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257899',4910667,'3041','469',523153.80,525931.59,2777.79,486113.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257899',4910668,'3042','469',90308.56,90308.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257899',4910669,'3043','469',617335.14,620085.79,2750.65,481363.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257899',4910670,'3044','469',57298.62,59037.07,1738.45,304228.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257899',4910671,'3045','469',574010.89,574010.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257899',4910672,'3046','469',147431.24,147431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257899',4910673,'3047','469',624471.76,624471.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257899',4910674,'3048','469',178130.16,178130.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257899',4910675,'3049','469',771047.15,771047.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257899',4910676,'3050','469',723435.68,723435.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257899',4910677,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257899',4910678,'3052','469',508316.78,508316.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257899',4910679,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257899',4910680,'3054','470',40145.27,40335.48,190.21,154070.10,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257899',4910681,'3055','470',157652.31,157762.92,110.61,89594.10,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257900',4910682,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257900',4910683,'3039','469',416251.68,418911.47,2659.79,465463.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257900',4910684,'3040','469',87867.08,87867.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257900',4910685,'3041','469',525931.59,528625.68,2694.09,471465.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257900',4910686,'3042','469',90308.56,90308.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257900',4910687,'3043','469',620085.79,622144.95,2059.16,360353.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257900',4910688,'3044','469',59037.07,60016.35,979.28,171374.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257900',4910689,'3045','469',574010.89,574881.69,870.80,152390.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257900',4910690,'3046','469',147431.24,147431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257900',4910691,'3047','469',624471.76,624471.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257900',4910692,'3048','469',178130.16,178130.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257900',4910693,'3049','469',771047.15,771047.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257900',4910694,'3050','469',723435.68,723435.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257900',4910695,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257900',4910696,'3052','469',508316.78,508316.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257900',4910697,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257900',4910698,'3054','470',40335.48,40335.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257900',4910699,'3055','470',157762.92,158529.40,766.48,620848.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257901',4910700,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257901',4910701,'3039','469',418911.47,421685.07,2773.60,485380.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257901',4910702,'3040','469',87867.08,87946.45,79.37,13889.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257901',4910703,'3041','469',528625.68,531365.92,2740.24,479542.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257901',4910704,'3042','469',90308.56,90308.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257901',4910705,'3043','469',622144.95,623870.41,1725.46,301955.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257901',4910706,'3044','469',60016.35,62145.21,2128.86,372550.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257901',4910707,'3045','469',574881.69,574881.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257901',4910708,'3046','469',147431.24,147431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257901',4910709,'3047','469',624471.76,624471.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257901',4910710,'3048','469',178130.16,178130.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257901',4910711,'3049','469',771047.15,771047.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257901',4910712,'3050','469',723435.68,723435.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257901',4910713,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257901',4910714,'3052','469',508316.78,508316.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257901',4910715,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257901',4910716,'3054','470',40335.48,40375.29,39.81,32246.10,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257901',4910717,'3055','470',158529.40,158772.86,243.46,197202.60,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257902',4910718,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257902',4910719,'3039','469',421685.07,424163.56,2478.49,433735.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257902',4910720,'3040','469',87946.45,90109.56,2163.11,378544.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257902',4910721,'3041','469',531365.92,533130.79,1764.87,308852.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257902',4910722,'3042','469',90308.56,92255.44,1946.88,340704.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257902',4910723,'3043','469',623870.41,626074.17,2203.76,385658.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257902',4910724,'3044','469',62145.21,62195.50,50.29,8800.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257902',4910725,'3045','469',574881.69,577079.08,2197.39,384543.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257902',4910726,'3046','469',147431.24,149479.68,2048.44,358477.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257902',4910727,'3047','469',624471.76,626776.51,2304.75,403331.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257902',4910728,'3048','469',178130.16,180335.88,2205.72,386001.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257902',4910729,'3049','469',771047.15,773095.10,2047.95,358391.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257902',4910730,'3050','469',723435.68,726307.21,2871.53,502517.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257902',4910731,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257902',4910732,'3052','469',508316.78,510622.06,2305.28,403424.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257902',4910733,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257902',4910734,'3054','470',40375.29,40375.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257902',4910735,'3055','470',158772.86,159830.70,1057.84,856850.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257903',4910736,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257903',4910737,'3039','469',424163.56,428882.13,4718.57,825749.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257903',4910738,'3040','469',90109.56,93573.65,3464.09,606215.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257903',4910739,'3041','469',533130.79,535615.53,2484.74,434829.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257903',4910740,'3042','469',92255.44,92255.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257903',4910741,'3043','469',626074.17,630292.16,4217.99,738148.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257903',4910742,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257903',4910743,'3045','469',577079.08,580740.20,3661.12,640696.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257903',4910744,'3046','469',149479.68,149479.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257903',4910745,'3047','469',626776.51,626776.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257903',4910746,'3048','469',180335.88,180335.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257903',4910747,'3049','469',773095.10,773095.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257903',4910748,'3050','469',726307.21,726307.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257903',4910749,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257903',4910750,'3052','469',510622.06,510622.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257903',4910751,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257903',4910752,'3054','470',40375.29,40375.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257903',4910753,'3055','470',159830.70,160557.88,727.18,589015.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257904',4910754,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257904',4910755,'3039','469',428882.13,430955.08,2072.95,362766.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257904',4910756,'3040','469',93573.65,94781.65,1208.00,211400.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257904',4910757,'3041','469',535615.53,537053.16,1437.63,251585.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257904',4910758,'3042','469',92255.44,93463.04,1207.60,211330.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257904',4910759,'3043','469',630292.16,631557.13,1264.97,221369.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257904',4910760,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257904',4910761,'3045','469',580740.20,582309.27,1569.07,274587.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257904',4910762,'3046','469',149479.68,149479.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257904',4910763,'3047','469',626776.51,626776.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257904',4910764,'3048','469',180335.88,180335.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257904',4910765,'3049','469',773095.10,773095.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257904',4910766,'3050','469',726307.21,726307.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257904',4910767,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257904',4910768,'3052','469',510622.06,510622.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257904',4910769,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257904',4910770,'3054','470',40375.29,40375.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257904',4910771,'3055','470',160557.88,161045.13,487.25,394672.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257905',4910772,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257905',4910773,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257905',4910774,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257905',4910775,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257905',4910776,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257905',4910777,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257905',4910778,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257905',4910779,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257905',4910780,'3046','469',149479.68,149479.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257905',4910781,'3047','469',626776.51,630566.85,3790.34,663309.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257905',4910782,'3048','469',180335.88,182779.74,2443.86,427675.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257905',4910783,'3049','469',773095.10,776840.67,3745.57,655474.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257905',4910784,'3050','469',726307.21,730636.52,4329.31,757629.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257905',4910785,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257905',4910786,'3052','469',510622.06,514612.08,3990.02,698253.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257905',4910787,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257905',4910788,'3054','470',40375.29,40375.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257905',4910789,'3055','470',161045.13,161543.55,498.42,403720.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257906',4910790,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257906',4910791,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257906',4910792,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257906',4910793,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257906',4910794,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257906',4910795,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257906',4910796,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257906',4910797,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257906',4910798,'3046','469',149479.68,149479.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257906',4910799,'3047','469',630566.85,630566.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257906',4910800,'3048','469',182779.74,182779.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257906',4910801,'3049','469',776840.67,776840.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257906',4910802,'3050','469',730636.52,730636.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257906',4910803,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257906',4910804,'3052','469',514612.08,514612.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257906',4910805,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257906',4910806,'3054','470',40375.29,40451.09,75.80,61398.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257906',4910807,'3055','470',161543.55,161611.07,67.52,54691.20,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257907',4910808,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257907',4910809,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257907',4910810,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257907',4910811,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257907',4910812,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257907',4910813,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257907',4910814,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257907',4910815,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257907',4910816,'3046','469',149479.68,151364.92,1857.24,325017.00,0.00,0.00,28.00,0.00,0.00),('1','203','1027','257907',4910817,'3047','469',630566.85,633215.45,2648.60,463505.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257907',4910818,'3048','469',182779.74,185458.00,2678.26,468695.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257907',4910819,'3049','469',776840.67,779228.77,2388.10,417917.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257907',4910820,'3050','469',730636.52,732999.06,2362.54,413444.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257907',4910821,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257907',4910822,'3052','469',514612.08,517028.42,2416.34,422859.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257907',4910823,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257907',4910824,'3054','470',40451.09,40451.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257907',4910825,'3055','470',161611.07,161928.26,317.19,256923.90,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257908',4910826,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257908',4910827,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257908',4910828,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257908',4910829,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257908',4910830,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257908',4910831,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257908',4910832,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257908',4910833,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257908',4910834,'3046','469',151364.92,151364.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257908',4910835,'3047','469',633215.45,633215.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257908',4910836,'3048','469',185458.00,185458.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257908',4910837,'3049','469',779228.77,779228.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257908',4910838,'3050','469',732999.06,732999.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257908',4910839,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257908',4910840,'3052','469',517028.42,517028.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257908',4910841,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257908',4910842,'3054','470',40451.09,40451.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257908',4910843,'3055','470',161928.26,162243.34,315.08,255214.80,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257909',4910844,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257909',4910845,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257909',4910846,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257909',4910847,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257909',4910848,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257909',4910849,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257909',4910850,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257909',4910851,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257909',4910852,'3046','469',151364.92,153539.29,2174.37,380514.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257909',4910853,'3047','469',633215.45,636376.89,3161.44,553252.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257909',4910854,'3048','469',185458.00,188206.61,2748.61,481006.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257909',4910855,'3049','469',779228.77,781482.66,2253.89,394430.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257909',4910856,'3050','469',732999.06,736895.80,3896.74,681929.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257909',4910857,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257909',4910858,'3052','469',517028.42,520658.74,3630.32,635306.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257909',4910859,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257909',4910860,'3054','470',40451.09,40512.01,56.97,46145.70,0.00,0.00,3.95,0.00,0.00),('1','203','1028','257909',4910861,'3055','470',162243.34,164127.74,1884.40,1526364.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257910',4910862,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257910',4910863,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257910',4910864,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257910',4910865,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257910',4910866,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257910',4910867,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257910',4910868,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257910',4910869,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257910',4910870,'3046','469',153539.29,153539.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257910',4910871,'3047','469',636376.89,636376.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257910',4910872,'3048','469',188206.61,188206.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257910',4910873,'3049','469',781482.66,781482.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257910',4910874,'3050','469',736895.80,736895.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257910',4910875,'3051','469',109453.68,109453.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257910',4910876,'3052','469',520658.74,520658.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257910',4910877,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257910',4910878,'3054','470',40512.01,40512.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257910',4910879,'3055','470',164127.74,164902.27,774.53,627369.30,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257911',4910880,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257911',4910881,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257911',4910882,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257911',4910883,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257911',4910884,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257911',4910885,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257911',4910886,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257911',4910887,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257911',4910888,'3046','469',153539.29,154618.29,1079.00,188825.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257911',4910889,'3047','469',636376.89,637450.60,1073.71,187899.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257911',4910890,'3048','469',188206.61,189201.61,995.00,174125.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257911',4910891,'3049','469',781482.66,782416.10,933.44,163352.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257911',4910892,'3050','469',736895.80,737862.63,966.83,169195.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257911',4910893,'3051','469',109453.68,110261.45,807.77,141359.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257911',4910894,'3052','469',520658.74,522028.32,1369.58,239676.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257911',4910895,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257911',4910896,'3054','470',40512.01,40512.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257911',4910897,'3055','470',164902.27,166143.97,1241.70,1005777.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257912',4910898,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257912',4910899,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257912',4910900,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257912',4910901,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257912',4910902,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257912',4910903,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257912',4910904,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257912',4910905,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257912',4910906,'3046','469',154618.29,156599.41,1981.12,346696.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257912',4910907,'3047','469',637450.60,639628.58,2177.98,381146.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257912',4910908,'3048','469',189201.61,190821.49,1619.88,283479.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257912',4910909,'3049','469',782416.10,784199.45,1783.35,312086.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257912',4910910,'3050','469',737862.63,740291.47,2428.84,425047.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257912',4910911,'3051','469',110261.45,110261.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257912',4910912,'3052','469',522028.32,524828.33,2800.01,490001.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257912',4910913,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257912',4910914,'3054','470',40512.01,40594.72,82.71,66995.10,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257912',4910915,'3055','470',166143.97,167028.61,884.64,716558.40,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257913',4910916,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257913',4910917,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257913',4910918,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257913',4910919,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257913',4910920,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257913',4910921,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257913',4910922,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257913',4910923,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257913',4910924,'3046','469',156599.41,156599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257913',4910925,'3047','469',639628.58,639628.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257913',4910926,'3048','469',190821.49,190821.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257913',4910927,'3049','469',784199.45,784199.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257913',4910928,'3050','469',740291.47,740291.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257913',4910929,'3051','469',110261.45,110261.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257913',4910930,'3052','469',524828.33,524828.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257913',4910931,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257913',4910932,'3054','470',40594.72,40594.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257913',4910933,'3055','470',167028.61,167458.88,430.27,348518.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257914',4910934,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257914',4910935,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257914',4910936,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257914',4910937,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257914',4910938,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257914',4910939,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257914',4910940,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257914',4910941,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257914',4910942,'3046','469',156599.41,156599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257914',4910943,'3047','469',639628.58,639628.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257914',4910944,'3048','469',190821.49,190821.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257914',4910945,'3049','469',784199.45,784199.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257914',4910946,'3050','469',740291.47,740291.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257914',4910947,'3051','469',110261.45,110261.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257914',4910948,'3052','469',524828.33,524828.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257914',4910949,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257914',4910950,'3054','470',40594.72,40594.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257914',4910951,'3055','470',167458.88,167847.15,388.27,314498.70,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257915',4910952,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257915',4910953,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257915',4910954,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257915',4910955,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257915',4910956,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257915',4910957,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257915',4910958,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257915',4910959,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257915',4910960,'3046','469',156599.41,156599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257915',4910961,'3047','469',639628.58,639628.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257915',4910962,'3048','469',190821.49,190821.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257915',4910963,'3049','469',784199.45,784199.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257915',4910964,'3050','469',740291.47,740291.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257915',4910965,'3051','469',110261.45,110261.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257915',4910966,'3052','469',524828.33,524828.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257915',4910967,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257915',4910968,'3054','470',40594.72,40594.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257915',4910969,'3055','470',167847.15,168243.41,396.26,317008.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257916',4910970,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257916',4910971,'3039','469',430955.08,430955.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257916',4910972,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257916',4910973,'3041','469',537053.16,537053.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257916',4910974,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257916',4910975,'3043','469',631557.13,631557.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257916',4910976,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257916',4910977,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257916',4910978,'3046','469',156599.41,156599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257916',4910979,'3047','469',639628.58,642856.70,3228.12,564921.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257916',4910980,'3048','469',190821.49,193214.11,2392.62,418708.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257916',4910981,'3049','469',784199.45,786362.31,2162.86,378500.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257916',4910982,'3050','469',740291.47,742361.47,2070.00,362250.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257916',4910983,'3051','469',110261.45,112653.70,2392.25,418643.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257916',4910984,'3052','469',524828.33,527254.56,2426.23,424590.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257916',4910985,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257916',4910986,'3054','470',40594.72,40594.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257916',4910987,'3055','470',168243.41,168680.49,437.08,349664.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257917',4910988,'3038','469',50856.42,50856.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257917',4910989,'3039','469',430955.08,433027.21,2072.13,362622.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257917',4910990,'3040','469',94781.65,94781.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257917',4910991,'3041','469',537053.16,539096.35,2043.19,357558.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257917',4910992,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257917',4910993,'3043','469',631557.13,633552.26,1995.13,349147.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257917',4910994,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257917',4910995,'3045','469',582309.27,582309.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257917',4910996,'3046','469',156599.41,157076.90,477.49,83560.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257917',4910997,'3047','469',642856.70,645136.60,2279.90,398982.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257917',4910998,'3048','469',193214.11,193753.68,539.57,94424.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257917',4910999,'3049','469',786362.31,788182.99,1820.68,318619.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257917',4911000,'3050','469',742361.47,744319.33,1957.86,342625.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257917',4911001,'3051','469',112653.70,113035.76,382.06,66860.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257917',4911002,'3052','469',527254.56,529905.12,2650.56,463848.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257917',4911003,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257917',4911004,'3054','470',40594.72,40594.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257917',4911005,'3055','470',168680.49,168964.50,284.01,227208.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257918',4911006,'3038','469',50856.42,51292.07,435.65,76238.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257918',4911007,'3039','469',433027.21,436214.71,3187.50,557812.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257918',4911008,'3040','469',94781.65,95097.27,315.62,55233.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257918',4911009,'3041','469',539096.35,542227.74,3131.39,547993.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257918',4911010,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257918',4911011,'3043','469',633552.26,633864.92,312.66,54715.50,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257918',4911012,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257918',4911013,'3045','469',582309.27,582668.65,359.38,62891.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257918',4911014,'3046','469',157076.90,157076.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257918',4911015,'3047','469',645136.60,647410.40,2273.80,397915.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257918',4911016,'3048','469',193753.68,193753.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257918',4911017,'3049','469',788182.99,789988.33,1805.34,315934.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257918',4911018,'3050','469',744319.33,746087.82,1768.49,309485.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257918',4911019,'3051','469',113035.76,113035.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257918',4911020,'3052','469',529905.12,531767.97,1862.85,325998.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257918',4911021,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257918',4911022,'3054','470',40594.72,40594.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257918',4911023,'3055','470',168964.50,169588.43,623.93,499144.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257919',4911024,'3038','469',51292.07,51292.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257919',4911025,'3039','469',436214.71,439448.20,3213.49,562360.75,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257919',4911026,'3040','469',95097.27,95097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257919',4911027,'3041','469',542227.74,545566.77,3319.03,580830.25,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257919',4911028,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257919',4911029,'3043','469',633864.92,636291.94,2407.02,421228.50,0.00,0.00,20.00,0.00,0.00),('1','203','1026','257919',4911030,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257919',4911031,'3045','469',582668.65,582668.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257919',4911032,'3046','469',157076.90,157076.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257919',4911033,'3047','469',647410.40,650396.01,2979.32,521381.00,0.00,0.00,6.29,0.00,0.00),('1','203','1027','257919',4911034,'3048','469',193753.68,193753.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257919',4911035,'3049','469',789988.33,792987.28,2998.95,524816.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257919',4911036,'3050','469',746087.82,748984.31,2896.49,506885.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257919',4911037,'3051','469',113035.76,113035.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257919',4911038,'3052','469',531767.97,532251.82,483.85,84673.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257919',4911039,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257919',4911040,'3054','470',40594.72,40594.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257919',4911041,'3055','470',169588.43,170424.71,836.28,669024.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257920',4911042,'3038','469',51292.07,51292.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257920',4911043,'3039','469',439448.20,443585.24,4137.04,723982.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257920',4911044,'3040','469',95097.27,95097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257920',4911045,'3041','469',545566.77,549754.32,4187.55,732821.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257920',4911046,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257920',4911047,'3043','469',636291.94,639616.47,3324.53,581792.75,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257920',4911048,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257920',4911049,'3045','469',582668.65,582668.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257920',4911050,'3046','469',157076.90,157076.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257920',4911051,'3047','469',650396.01,653067.59,2671.58,467526.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257920',4911052,'3048','469',193753.68,193753.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257920',4911053,'3049','469',792987.28,796001.89,3014.61,527556.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257920',4911054,'3050','469',748984.31,752049.22,3044.91,532859.25,0.00,0.00,20.00,0.00,0.00),('1','203','1027','257920',4911055,'3051','469',113035.76,113035.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257920',4911056,'3052','469',532251.82,532251.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257920',4911057,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257920',4911058,'3054','470',40594.72,40844.72,250.00,200000.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257920',4911059,'3055','470',170424.71,170832.09,407.38,325904.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257921',4911060,'3038','469',51292.07,51292.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257921',4911061,'3039','469',443585.24,447404.24,3819.00,668325.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257921',4911062,'3040','469',95097.27,95097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257921',4911063,'3041','469',549754.32,553314.75,3560.43,623075.25,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257921',4911064,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257921',4911065,'3043','469',639616.47,639616.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257921',4911066,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257921',4911067,'3045','469',582668.65,585782.97,3114.32,545006.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257921',4911068,'3046','469',157076.90,157076.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257921',4911069,'3047','469',653067.59,656439.71,3372.12,590121.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257921',4911070,'3048','469',193753.68,193753.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257921',4911071,'3049','469',796001.89,798459.41,2457.52,430066.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257921',4911072,'3050','469',752049.22,755099.30,3050.08,533764.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257921',4911073,'3051','469',113035.76,113035.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257921',4911074,'3052','469',532251.82,534244.01,1992.19,348633.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257921',4911075,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257921',4911076,'3054','470',40844.72,40844.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257921',4911077,'3055','470',170832.09,171364.64,532.55,426040.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257922',4911078,'3038','469',51292.07,51292.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257922',4911079,'3039','469',447404.24,447404.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257922',4911080,'3040','469',95097.27,95097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257922',4911081,'3041','469',553314.75,553314.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257922',4911082,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257922',4911083,'3043','469',639616.47,639616.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257922',4911084,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257922',4911085,'3045','469',585782.97,585782.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257922',4911086,'3046','469',157076.90,157076.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257922',4911087,'3047','469',656439.71,657301.79,862.08,150864.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257922',4911088,'3048','469',193753.68,193863.50,109.82,19218.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257922',4911089,'3049','469',798459.41,799421.95,962.54,168444.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257922',4911090,'3050','469',755099.30,756214.43,1115.13,195147.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257922',4911091,'3051','469',113035.76,113035.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257922',4911092,'3052','469',534244.01,535167.65,923.64,161637.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257922',4911093,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257922',4911094,'3054','470',40844.72,40844.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257922',4911095,'3055','470',171364.64,171692.76,328.12,262496.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257923',4911096,'3038','469',51292.07,51292.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257923',4911097,'3039','469',447404.24,447404.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257923',4911098,'3040','469',95097.27,95097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257923',4911099,'3041','469',553314.75,553314.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257923',4911100,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257923',4911101,'3043','469',639616.47,639616.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257923',4911102,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257923',4911103,'3045','469',585782.97,585782.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257923',4911104,'3046','469',157076.90,157076.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257923',4911105,'3047','469',657301.79,657301.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257923',4911106,'3048','469',193863.50,193863.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257923',4911107,'3049','469',799421.95,799421.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257923',4911108,'3050','469',756214.43,756214.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257923',4911109,'3051','469',113035.76,113035.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257923',4911110,'3052','469',535167.65,535167.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257923',4911111,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257923',4911112,'3054','470',40844.72,40844.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257923',4911113,'3055','470',171692.76,171847.87,155.11,124088.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257924',4911114,'3038','469',51292.07,51292.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257924',4911115,'3039','469',447404.24,447404.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257924',4911116,'3040','469',95097.27,95097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257924',4911117,'3041','469',553314.75,553314.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257924',4911118,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257924',4911119,'3043','469',639616.47,639616.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257924',4911120,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257924',4911121,'3045','469',585782.97,585782.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257924',4911122,'3046','469',157076.90,159006.85,1929.95,337741.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257924',4911123,'3047','469',657301.79,659469.05,2167.26,379270.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257924',4911124,'3048','469',193863.50,195991.88,2128.38,372466.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257924',4911125,'3049','469',799421.95,801880.98,2459.03,430330.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257924',4911126,'3050','469',756214.43,757850.41,1635.98,286296.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257924',4911127,'3051','469',113035.76,115130.05,2094.29,366500.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257924',4911128,'3052','469',535167.65,537929.65,2762.00,483350.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257924',4911129,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257924',4911130,'3054','470',40844.72,40844.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257924',4911131,'3055','470',171847.87,172240.31,392.44,313952.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257925',4911132,'3038','469',51292.07,51292.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257925',4911133,'3039','469',447404.24,447404.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257925',4911134,'3040','469',95097.27,95097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257925',4911135,'3041','469',553314.75,553314.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257925',4911136,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257925',4911137,'3043','469',639616.47,639616.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257925',4911138,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257925',4911139,'3045','469',585782.97,585782.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257925',4911140,'3046','469',159006.85,159006.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257925',4911141,'3047','469',659469.05,661442.54,1973.49,345360.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257925',4911142,'3048','469',195991.88,197601.46,1609.58,281676.50,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257925',4911143,'3049','469',801880.98,803299.09,1418.11,248169.25,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257925',4911144,'3050','469',757850.41,759462.26,1611.85,282073.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257925',4911145,'3051','469',115130.05,115130.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257925',4911146,'3052','469',537929.65,539633.38,1703.73,298152.75,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257925',4911147,'3053','469',102562.71,102562.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257925',4911148,'3054','470',40844.72,40844.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1028','257925',4911149,'3055','470',172240.31,172751.64,511.33,409064.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257926',4911150,'3038','469',51292.07,51292.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257926',4911151,'3039','469',447404.24,447404.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257926',4911152,'3040','469',95097.27,95097.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257926',4911153,'3041','469',553314.75,553314.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257926',4911154,'3042','469',93463.04,93463.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257926',4911155,'3043','469',639616.47,639616.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257926',4911156,'3044','469',62195.50,62195.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1026','257926',4911157,'3045','469',585782.97,585782.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257926',4911158,'3046','469',159006.85,161557.57,2550.72,446376.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257926',4911159,'3047','469',661442.54,664139.54,2697.00,471975.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257926',4911160,'3048','469',197601.46,199990.02,2388.56,417998.00,0.00,0.00,0.00,0.00,0.00),('1','203','1027','257926',4911161,'3049','469',803299.09,805922.