-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_202
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_202`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_202` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_202`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4039 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (4024,400126,'',0,'22','1','202','PURCHASES.','','2021-12-25 17:53:36',5,0.00,0.00,'','479','2021-12-25 17:53:36','479',0,0),(4025,20063,'',0,'20','1','202','SALES','','2021-12-25 17:54:29',5,0.00,0.00,'','479','2021-12-25 17:54:29','479',0,0),(4026,40065,'',0,'6.1','1','202','CASH','','2021-12-25 17:54:59',5,0.00,0.00,'','479','2021-12-25 17:54:59','479',0,0),(4027,400367,'',0,'24','1','202','SALARIES & WAGES','','2021-12-25 17:55:16',5,0.00,0.00,'','479','2021-12-25 17:55:16','479',0,0),(4028,400368,'',0,'24','1','202','PURCHASES','','2021-12-25 17:55:32',5,0.00,0.00,'','479','2021-12-25 17:55:32','479',0,0),(4029,400714,'',0,'2','1','202','ZB(LPG)1014471475','','2021-12-25 17:56:08',5,0.00,0.00,'','479','2021-12-25 17:56:08','479',0,0),(4030,400715,'',0,'2','1','202','FB(IBAL)2023855223','','2021-12-25 17:56:25',5,0.00,0.00,'','479','2021-12-25 17:56:25','479',0,0),(4031,400716,'',0,'2','1','202','E-BILLS 1015372548','','2021-12-25 17:57:09',5,0.00,0.00,'','479','2021-12-25 17:57:09','479',0,0),(4032,400717,'',0,'2','1','202','E-BILLS  IBAL 1015372548','','2021-12-25 17:57:28',5,0.00,0.00,'','479','2021-12-25 17:57:28','479',0,0),(4033,400718,'',0,'2','1','202','UNITY BANK-0024061656','','2021-12-25 17:58:04',5,0.00,0.00,'','479','2021-12-25 17:58:04','479',0,0),(4034,400719,'',0,'2','1','202','DANKANO-EBILLS:ZNB1014717618','','2021-12-25 17:58:25',5,0.00,0.00,'','479','2021-12-25 17:58:25','479',0,0),(4035,400720,'',0,'2','1','202','UBA YOLA-1021398099','','2021-12-25 17:58:44',5,0.00,0.00,'','479','2021-12-25 17:58:44','479',0,0),(4036,400721,'',0,'2','1','202','FID POS COLLECTION-5620141491','','2021-12-25 17:59:01',5,0.00,0.00,'','479','2021-12-25 17:59:01','479',0,0),(4037,400722,'',0,'2','1','202','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:46:09',5,0.00,0.00,'','792','2023-02-20 14:46:09','792',0,0),(4038,400723,'',0,'2','1','202','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:48:33',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:06:17','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','202','JOSHUA GAS','MARARABA NASARAWA','0 7046523894','mado@gmail.com','MARARABA','NASARAWA','MARARABA, NASSARAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:10:09',5,'739','2022-03-06 08:02:42','739'),(2,'','1','202','ABU GAS','MARARABA NASARAWA','08052862369','hgaya@aaranonigeria.com','MARARABA','NASARAWA STATE.','MARARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:39:44',5,'739','2022-03-03 08:39:44','739'),(3,'','1','202','ABU','MARARABA NASARAWA','08052862369','abu@gmail.com','MARARABA','NASARAWA STATE.','MARARABA NASARAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 08:44:05',5,'739','2022-03-03 08:44:05','739'),(4,'','1','202','EBUBEST OIL  AND GAS','NEW NYANY ','09060352331','mado@gmail.com','KARU','NASARAWA STATE.','KARU LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 11:04:33',5,'739','2022-03-06 07:31:35','739'),(5,'','1','202','J0HNSON GAS','MASAKA','09060545348','mado@gmail.com','MASAKA','NASARAWA STATE.','MASAKA KARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-03 17:33:42',5,'739','2022-03-06 07:30:57','739'),(6,'','1','202','MUHAMMAD GAS','MASAKA','08166236839','mado@gmail.com','MASAKA','NASSARAWA STATE.','KARU  LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-05 07:32:03',5,'739','2022-03-06 08:01:30','739'),(7,'','1','202','MM GAS','MASAKA','08039707752','mado@gmail.com','MASAKA','NASARAWA STATE.','KARU LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-05 08:50:01',5,'739','2022-03-05 08:50:01','739'),(8,'','1','202','JONH GAS','MRARABA BY ABACH RAODA','08111172078','mado@gmail.com','MARARABA','NASARAWA STATE.','MARRABA KARU LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-05 14:03:00',5,'739','2022-03-05 14:03:00','739'),(9,'','1','202','J GAS','JAMES UCHIIR','090878892','jg@yahoo.com','NASARAWA','NASARAWA STATE.','NEW NYANYA BY ST. MARTINS.','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 08:41:53',5,'739','2022-03-06 08:41:53','739'),(10,'','1','202','CHIBEST GAS','NEW KARU','09065415277','mado@gmail.com','KARU','NASARAWA STATE.','NEW KARU NASARAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 09:52:19',5,'739','2022-03-06 09:52:19','739'),(11,'','1','202','CORNERSTONE GAS','IFEANYI FIDELIS','08023999092','merryfidelis@gmail.com','NASARAWA','NASARAWA STATE.','.TIPPER ROAD NEW NYANYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 11:20:38',5,'739','2022-03-06 11:20:38','739'),(12,'','1','202','threshold gas','MARARABA one manvillge','08086317272','mado@gmail.com','KARU','NASARAWA STATE.','mararaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 19:04:25',5,'739','2022-03-06 19:04:25','739'),(13,'','1','202','MR GAS','NEW NYANY ','08036917838','mado@gmail.com','KARU','NASARAWA STATE.','KARU LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-07 08:28:45',5,'739','2022-03-07 08:28:45','739'),(14,'','1','202','OMENA GAS','MR. DANIEL ','07068195627','hdaniel@yahoo.com','MARARABA','NASARAWA STATE.','MARARRABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-07 10:18:55',5,'739','2022-03-07 10:18:55','739'),(15,'','1','202','YOUNG ANDY GAS','ANDY','08060348948','abu@gmail.com','JABA LOCAL GOVT','KADUNA','KWOI, KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 07:14:01',5,'739','2022-03-08 07:14:01','739'),(16,'','1','202','HOUSES GAS','KUCHIKA KARU LGA','07066422039','hdaniel@yahoo.com','KARU','NASARAWA STATE.','KUCHIKA KARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 09:59:39',5,'739','2022-03-08 09:59:39','739'),(17,'','1','202','O~LIGHT GAS','OLAMIDE HASSAN','08040674621','olahassa@gmail.com','JIKWOI','ABUJA','JIKWOI PHASE 2\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 11:46:59',5,'739','2022-03-08 11:46:59','739'),(18,'','1','202','GOD PASS THEM OIL AND GAS','PAUL','08069784905','hdaniel@yahoo.com','MARARABA','NASSARAWA STATE.','KABAYI MARABA OPP BAWA BAKERY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-08 11:52:42',5,'739','2022-03-08 11:52:42','739'),(19,'','1','202','JACOB S.JAYKAY GAS','AKWANGA','08069315746','hdaniel@yahoo.com','AKWANGA','NASSARAWA STATE.','AKWANGA NASARAWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-23 09:44:16',5,'739','2022-03-23 09:44:16','739'),(20,'','1','202','JOBEST GAS','ADO','08142945773','abu@gmail.com','KARU','NASSARAWA STATE.','KARU LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-23 10:55:24',5,'739','2022-04-26 12:05:30','739'),(21,'','1','202','EJISON GAS CO.','EJIKE ENWE','08060715046','hgaya@aaranonigeria.com','NASARAWA','NASARAWA','MARARRABA BY SHARP CORNER OVERHEAD BRIDGE.','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-26 14:15:51',5,'739','2022-03-26 14:15:51','739'),(22,'','1','202','SUMACO GAS ','EMENIKE EZUUGWU','09068540670','jg@yahoo.com','NASARAWA','NASARAWA','ADO NEW KARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-27 11:00:31',5,'739','2022-03-27 11:00:31','739'),(23,'','1','202','agess gas','kabaye','07036111579','hgaya@aaranonigeria.com','NASARAWA','NASARAWA','kabaye','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-28 13:14:55',5,'739','2022-03-28 13:14:55','739'),(24,'','1','202','emmyshow gas','emmanuel aleyr','07033498554','abu@gmail.com','NASARAWA','NASARAWA STATE.','ADO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-31 12:18:41',5,'739','2022-03-31 12:18:41','739'),(25,'','1','202','matahias gas','MARARABA NASARAWA','07036111579','mado@gmail.com','MARARABA','NASSARAWA STATE.','kabaye','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-01 14:07:11',5,'739','2022-04-01 14:07:11','739'),(26,'','1','202','ANATE GAS','MR, ANATE','07050465021','hdaniel@yahoo.com','AUTA','NASSARAWA STATE.','AUTA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-01 17:36:04',5,'739','2022-04-01 17:36:04','739'),(27,'','1','202','S. B. GAS','BENJAMIN SAMUEL','08148204209','abu@gmail.com','MARARABA','NASSARAWA STATE.','MARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-02 07:53:26',5,'739','2022-04-02 07:53:26','739'),(28,'','1','202','MATTHEW GAS','MATTHEW','08039145122','hdaniel@yahoo.com','KARU','NASSARAWA STATE.','KARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-02 15:42:08',5,'739','2022-04-02 15:42:08','739'),(29,'','1','202','OYITES GAS','OYEMAECHI','08036470942','hdaniel@yahoo.com','KARU','NASSARAWA STATE.','MARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-03 08:31:26',5,'739','2022-04-03 08:31:26','739'),(30,'','1','202','PRINCE ABUTU GAS','NEW NYANYA','08146373493','jg@yahoo.com','KARU','NASSARAWA STATE.','NEW NYANYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-04 09:49:49',5,'739','2022-04-04 09:49:49','739'),(31,'','1','202','CHRIS GAS','NEW NYANY ','07031827717','abu@gmail.com','KARU','NASSARAWA STATE.','NEW YANAYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-04 10:08:48',5,'739','2022-04-04 10:08:48','739'),(32,'','1','202','CHUMCO GAS','NEW KARU','08061949817','hdaniel@yahoo.com','KARU','NASSARAWA STATE.','NEW KARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-04 12:55:20',5,'739','2022-04-04 12:55:20','739'),(33,'','1','202','operational loss','ado','07061980812','inusamuhammadwada@gmail.com','NASARAWA','NASARAWA','ado','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-04 15:08:03',5,'739','2022-04-04 15:08:03','739'),(34,'','1','202','john gas','mr. john okoro','08145402020','hdaniel@yahoo.com','NASARAWA','NASSARAWA STATE.','AKWANGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-05 08:33:16',5,'739','2022-04-05 08:33:16','739'),(35,'','1','202','GABRICO GAS','MR. RICHARD ABEYOU','08033041296','hdaniel@yahoo.com','KARU','NASARAWA STATE.','NEW NYANYA. ANGWAN TIV','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-05 12:11:28',5,'739','2022-04-05 12:11:28','739'),(36,'','1','202','DOZE GAS','ADO','08032443037','hdaniel@yahoo.com','KARU','NASSARAWA STATE.','ado','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-06 07:45:36',5,'739','2022-04-06 07:45:36','739'),(37,'','1','202','KALEFONA GAS','NEW KARU','08166372740','jg@yahoo.com','KARU','NASSARAWA STATE.','NEW KARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-06 12:08:04',5,'739','2022-04-06 12:08:04','739'),(38,'','1','202','S Y GAS','ALHAJI SADIQ YUSUF','08038268989','mado@gmail.com','NASARAWA','NASSARAWA STATE.','MASAKA BY JEHU TREE\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-07 10:26:20',5,'739','2022-04-07 10:26:20','739'),(39,'','1','202','ILIYU GAS','KWOI KADUNA','07031356383','mado@gmail.com','KWOI','KADUNA','KAWOI KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-20 07:05:12',5,'739','2022-04-20 07:05:12','739'),(40,'','1','202','CLEMENT GAS','KWOI KADUNA','07061899146','jg@yahoo.com','KWOI','KADUNA','KWOI KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-22 07:04:51',5,'739','2022-04-22 07:04:51','739'),(41,'','1','202','PURE GAS','JULIUS AGIBI','08028859377','jg@yahoo.com','NASARAWA','NASSARAWA STATE.','MASAKA BY ROYAL  COLLEGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-23 12:29:43',5,'739','2022-04-23 12:29:43','739'),(42,'','1','202','APACO GAS','CHINEDU','08121184605','jg@yahoo.com','NASARAWA','NASSARAWA STATE.','MASAKA KUCHIKAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-24 16:24:39',5,'739','2022-04-24 16:24:39','739'),(43,'','1','202','MABINAS GAS','ZONE NEN NYANYA','08067186950','mado@gmail.com','KARU','NASSARAWA STATE.','NASARAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-25 17:42:13',5,'739','2022-04-25 17:57:12','739'),(44,'','1','202','YUSAF GAS','  NYANY GANDARI','09019600642','hdaniel@yahoo.com','KARU','NASSARAWA STATE.','NYANYA GANDARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-26 11:15:42',5,'739','2022-04-26 11:15:42','739'),(45,'','1','202','DIVINE GAS','MASAKA ','08105604150','mado@gmail.com','MASAKA','NASSARAWA STATE.','MASAKA MASAKA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-27 16:59:05',5,'739','2022-04-27 16:59:05','739'),(46,'','1','202','PROSPER GAS',' ALONG ASO MARARABA','09021021029','jg@yahoo.com','KARU','NASSARAWA STATE.','ASO PADA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-30 14:54:45',5,'739','2022-04-30 14:54:45','739'),(47,'','1','202','ODEN OIL &GAS','MARARABA','08037864259','mado@gmail.com','KARU','NASSARAWA STATE.','NO 26 BABA SITER MARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-01 06:59:59',5,'739','2022-05-01 06:59:59','739'),(48,'','1','202','IKE GAS','ANGI JUNCTION MASAKA','07066290586','mado@gmail.com','KARU','NASSARAWA STATE.','ANGI JUNTION MASAKA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-01 08:01:14',5,'739','2022-05-01 08:01:14','739'),(49,'','1','202','EMMA GAS','EMMA','08142391699','jg@yahoo.com','KARU','F CT ABUJA','KARU ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-02 11:40:41',5,'739','2022-05-02 11:40:41','739'),(50,'','1','202','MUMMY APO GAS','ABENE JOSHUA','07027397373','hdaniel@yahoo.com','NASARAWA','NASSARAWA STATE.','NEW KARU BY AMERICANA FACTORY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-07 14:24:35',5,'739','2022-05-07 14:24:35','739'),(51,'','1','202','jokara gas','gwandara','07035209623','hgaya@aaranonigeria.com','KARU','NASARAWA STATE.','nassarawa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 13:39:40',5,'739','2022-11-23 10:45:15','739'),(52,'','1','202','ABDUL GAS','NYANYA  ABUJA','08036268412','mado@gmail.com','F C T','ABUJA','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 16:48:41',5,'739','2022-05-26 16:48:41','739'),(53,'','1','202','AUSTIN GAS','MR. AUSTIN NWAFOR','08036812870','jg@yahoo.com','NASARAWA','NASSARAWA STATE.','NYANYA BY AA RANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-28 08:28:52',5,'739','2022-05-28 08:28:52','739'),(54,'','1','202','NZE O GAS','KABEYI MARARABA','08032485975','hdaniel@yahoo.com','KARU','NASSARAWA STATE.','KARSHI KARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-29 08:17:48',5,'739','2022-05-29 08:17:48','739'),(55,'','1','202','NATHY GAS ','NATHANIEL ','08107279802','hdaniel@yahoo.com','NASSARAWA','NASSARAWA STATE.','CITY COLLEGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 12:29:42',5,'739','2022-05-30 12:29:42','739'),(56,'','1','202','G & SONS OIL AND GAS','GEOFREY IBRAHIM ','07069141133','jg@yahoo.com','MARARABA','NASSARAWA STATE.','KARU  CITY COLLEGE BY CIVIL DEFENCE JUNCTION.','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 13:07:30',5,'739','2022-05-30 13:07:30','739'),(57,'','1','202','JODFAVOR','MTN MASS KARU ','08067044333','info@aaranonigeria.com','KARU','NASARAWA','KARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-31 06:35:53',5,'739','2022-05-31 06:35:53','739'),(58,'','1','202','J B GAS','NASARAWA POLYTICNC','07030635359','mado@gmail.com','NASARAWA','NASSARAWA STATE.','NASARAWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-04 10:00:41',5,'739','2022-06-04 10:00:41','739'),(59,'','1','202','STELINO GAS','AUTA BA LIFAY','07061710653','hdaniel@yahoo.com','KARU','NASSARAWA STATE.','KARU L G A','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-04 09:50:50',5,'739','2022-07-04 09:50:50','739'),(60,'','1','202','BAKO GAS','NEW NYANYA','08079206720','mado@gmail.com','KARU','NASSARAWA STATE.','NEW NYANYA KARU LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-10 08:00:18',5,'739','2022-07-10 08:00:18','739'),(61,'','1','202','C GAS','CITY CO','08066055950','hdaniel@yahoo.com','MARARABA','NASSARAWA STATE.','MARARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-19 17:52:25',5,'739','2022-07-19 17:52:25','739'),(62,'','1','202','UCHE GAS','MARARABA NASARAWA','09023781434','mado@gmail.com','KARU','NASSARAWA STATE.','BY OLD KARU ROAD MARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-23 15:30:38',5,'739','2022-07-23 15:30:38','739'),(63,'','1','202','GODS TIME GAS','NEW KARU BY BEST INTENATIONAL ','09129052296','abu@gmail.com','KARU','NASSARAWA STATE.','KARU NASARAWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-26 11:13:45',5,'739','2022-07-26 11:13:45','739'),(64,'','1','202','N. DBEST GAS','AKU VILLAGE.MARARABA','08033300959','mado@gmail.com','KARU','NASSARAWA STATE.','AKU VILLAGE MARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-01 17:44:59',5,'739','2022-08-01 17:44:59','739'),(65,'','1','202','N   G  O.OIL GAS','NO 142 OID KARU ROAD MAMARABA','07039620499','mado@gmail.com','KARU','NASSARAWA STATE.','OID KARU ROAD MARARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-02 11:10:36',5,'739','2022-08-02 11:36:11','739'),(66,'','1','202','DANI BEN GAS','NEW YANYAN U/TV ','09056090468','mado@gmail.com','KARU','NASSARAWA STATE.','U/TV','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-02 11:19:08',5,'739','2022-08-02 11:19:08','739'),(67,'','1','202','MOZE GAS','MARARABA','08089868000','abu@gmail.com','KARU','NASARAWA','MARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-23 16:26:39',5,'739','2022-08-23 16:26:39','739'),(68,'','1','202','A.K JACOB GAS','KARU ','08101337669','jg@yahoo.com','KARU','NASARAWA','KUCHIKAU ADAMAWA BLOCK SAIDAMA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-30 10:37:22',5,'739','2022-08-30 10:37:22','739'),(69,'','1','202','LASSSA GAS','CITY CO','09019192654','hdaniel@yahoo.com','MARARABA','NASSARAWA STATE.','CITY CULLAGER','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-30 11:08:08',5,'739','2022-08-30 11:08:08','739'),(70,'','1','202','OBOCHI RICHARD GAS','AN GALAMBO KIFFO NASARAWA','08104347060','jg@yahoo.com','NASARAWA','NASARAWA STATE','NASARAWA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-29 12:43:08',5,'739','2022-11-29 12:43:08','739'),(71,'','1','202','OWEM GAS','TUDANWADA MARARABA','08026014066','jg@yahoo.com','KARU','NASARAWA STATE','MARARABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-02 10:50:41',5,'739','2022-12-02 10:50:41','739'),(72,'','1','202','IDRIS ABDULMAJID GAS','NO 18 AREA F NYANYA VIO ROAD ','08142536597','jg@yahoo.com','NYANYA','F C T','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-03 07:19:29',5,'739','2022-12-03 07:19:29','739');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3071 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','202','1036',3070,'5','LPG NOZZLE ',604738.23,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=448 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','202',1,'DAILY SHIFT','2022-03-02','2022-03-02 12:35:16','2022-03-03 12:35:16','739',0.00,0.00,'739','2022-03-03 08:18:14','739','2022-03-03 08:18:34',10,0),('1','202',2,'DAILY SHIFT','2022-03-03','2022-03-03 08:26:29','2022-03-04 08:26:29','739',0.00,0.00,'739','2022-03-03 19:30:48','739','2022-03-03 19:31:08',10,0),('1','202',3,'DAILY SHIFT','2022-03-04','2022-03-04 07:22:42','2022-03-05 07:22:42','739',0.00,0.00,'739','2022-03-04 19:27:41','739','2022-03-04 19:28:03',10,0),('1','202',4,'DAILY SHIFT','2022-03-05','2022-03-05 06:57:23','2022-03-06 06:57:23','739',0.00,0.00,'739','2022-03-05 19:30:32','739','2022-03-05 19:31:15',10,0),('1','202',5,'DAILY SHIFT','2022-03-06','2022-03-06 07:01:52','2022-03-07 07:01:52','739',0.00,0.00,'739','2022-03-06 20:11:45','739','2022-03-06 20:13:39',10,0),('1','202',6,'DAILY SHIFT','2022-03-07','2022-03-07 07:01:01','2022-03-08 07:01:01','739',0.00,0.00,'739','2022-03-07 19:54:29','739','2022-03-07 19:54:59',10,0),('1','202',7,'DAILY SHIFT','2022-03-08','2022-03-08 06:55:58','2022-03-09 06:55:58','739',0.00,0.00,'739','2022-03-08 21:02:58','739','2022-03-08 21:03:18',10,0),('1','202',8,'DAILY SHIFT','2022-03-09','2022-03-09 06:52:55','2022-03-10 06:52:55','739',0.00,0.00,'739','2022-03-09 19:25:28','739','2022-03-09 19:25:59',10,0),('1','202',9,'DAILY SHIFT','2022-03-22','2022-03-22 14:15:52','2022-03-23 14:15:52','739',0.00,0.00,'739','2022-03-22 19:37:02','739','2022-03-22 19:37:34',10,0),('1','202',10,'DAILY SHIFT','2022-03-23','2022-03-23 07:03:18','2022-03-24 07:03:18','739',0.00,0.00,'739','2022-03-23 19:42:11','739','2022-03-23 19:42:32',10,0),('1','202',11,'DAILY SHIFT','2022-03-26','2022-03-26 10:21:12','2022-03-27 10:21:12','739',0.00,0.00,'739','2022-03-26 19:55:34','739','2022-03-26 19:56:00',10,0),('1','202',12,'DAILY SHIFT','2022-03-27','2022-03-27 07:26:15','2022-03-28 07:26:15','739',0.00,0.00,'739','2022-03-27 10:30:37','739','2022-03-27 10:31:01',10,0),('1','202',13,'DAILY SHIFT','2022-03-27','2022-03-27 10:38:07','2022-03-28 10:38:07','739',0.00,0.00,'739','2022-03-27 19:30:02','739','2022-03-27 19:30:16',10,0),('1','202',14,'DAILY SHIFT','2022-03-28','2022-03-28 12:24:42','2022-03-29 12:24:42','739',0.00,0.00,'739','2022-03-28 19:24:18','739','2022-03-28 19:24:45',10,0),('1','202',15,'DAILY SHIFT','2022-03-29','2022-03-29 07:18:26','2022-03-30 07:18:26','739',0.00,0.00,'739','2022-03-29 19:48:40','739','2022-03-30 10:15:41',10,0),('1','202',16,'DAILY SHIFT','2022-03-30','2022-03-30 10:16:46','2022-03-31 10:16:46','739',0.00,0.00,'739','2022-03-30 19:30:24','739','2022-03-30 19:30:53',10,0),('1','202',17,'DAILY SHIFT','2022-03-31','2022-03-31 06:59:22','2022-04-01 06:59:22','739',0.00,0.00,'739','2022-03-31 18:07:31','739','2022-03-31 18:07:52',10,0),('1','202',18,'DAILY SHIFT','2022-04-01','2022-04-01 07:52:47','2022-04-02 07:52:47','739',0.00,0.00,'739','2022-04-01 19:49:05','739','2022-04-01 19:52:22',10,0),('1','202',19,'DAILY SHIFT','2022-04-02','2022-04-02 06:59:01','2022-04-03 06:59:01','739',0.00,0.00,'739','2022-04-02 20:05:30','739','2022-04-02 20:05:54',10,0),('1','202',20,'DAILY SHIFT','2022-04-03','2022-04-03 07:57:45','2022-04-04 07:57:45','739',0.00,0.00,'739','2022-04-03 17:58:21','739','2022-04-03 17:58:39',10,0),('1','202',21,'DAILY SHIFT','2022-04-04','2022-04-04 07:24:21','2022-04-05 07:24:21','739',0.00,0.00,'739','2022-04-04 19:53:37','739','2022-04-04 19:54:39',10,0),('1','202',22,'OPERATIONAL LOSS ','2022-04-04','2022-04-04 20:00:33','2022-04-05 20:00:33','739',0.00,0.00,'739','2022-04-04 20:08:16','739','2022-04-04 20:09:22',10,0),('1','202',23,'DAILY SHIFT','2022-04-05','2022-04-05 06:55:32','2022-04-06 06:55:32','739',0.00,0.00,'739','2022-04-05 19:29:34','739','2022-04-05 19:30:40',10,0),('1','202',24,'DAILY SHIFT','2022-04-06','2022-04-06 06:53:58','2022-04-07 06:53:58','739',0.00,0.00,'739','2022-04-06 16:56:53','739','2022-04-06 16:57:27',10,0),('1','202',25,'OPERATIONAL LOSS ','2022-04-06','2022-04-06 17:05:03','2022-04-07 17:05:03','739',0.00,0.00,'739','2022-04-06 17:10:15','739','2022-04-06 17:10:31',10,0),('1','202',26,'DAILY SHIFT','2022-04-07','2022-04-07 10:03:05','2022-04-08 10:03:05','739',0.00,0.00,'739','2022-04-07 19:27:14','739','2022-04-07 19:27:33',10,0),('1','202',27,'DAILY SHIFT','2022-04-08','2022-04-08 06:54:20','2022-04-09 06:54:20','739',0.00,0.00,'739','2022-04-08 19:25:55','739','2022-04-08 19:26:13',10,0),('1','202',28,'DAILY SHIFT','2022-04-09','2022-04-09 09:57:16','2022-04-10 09:57:16','739',0.00,0.00,'739','2022-04-09 19:43:43','739','2022-04-09 19:44:09',10,0),('1','202',29,'DAILY SHIFT','2022-04-10','2022-04-10 06:48:23','2022-04-11 06:48:23','739',0.00,0.00,'739','2022-04-10 19:16:03','739','2022-04-10 19:16:25',10,0),('1','202',30,'DAILY SHIFT','2022-04-11','2022-04-11 06:50:35','2022-04-12 06:50:35','739',0.00,0.00,'739','2022-04-11 17:28:41','739','2022-04-11 17:29:01',10,0),('1','202',31,'DAILY SHIFT','2022-04-12','2022-04-12 07:18:49','2022-04-13 07:18:49','739',0.00,0.00,'739','2022-04-12 09:44:35','739','2022-04-12 09:44:57',10,0),('1','202',32,'OPERATIONAL LOSS ','2022-04-12','2022-04-12 10:33:19','2022-04-13 10:33:19','739',0.00,0.00,'739','2022-04-12 10:38:26','739','2022-04-12 10:38:40',10,0),('1','202',33,'DAILY SHIFT','2022-04-12','2022-04-12 16:10:48','2022-04-13 16:10:48','739',0.00,0.00,'739','2022-04-12 19:11:30','739','2022-04-12 19:11:53',10,0),('1','202',34,'DAILY SHIFT','2022-04-13','2022-04-13 06:47:21','2022-04-14 06:47:21','739',0.00,0.00,'739','2022-04-13 19:30:25','739','2022-04-13 19:30:40',10,0),('1','202',35,'DAILY SHIFT','2022-04-14','2022-04-14 06:48:59','2022-04-15 06:48:59','739',0.00,0.00,'739','2022-04-14 19:19:55','739','2022-04-14 19:20:13',10,0),('1','202',36,'DAILY SHIFT','2022-04-15','2022-04-15 06:57:07','2022-04-16 06:57:07','739',0.00,0.00,'739','2022-04-15 19:31:08','739','2022-04-15 19:31:43',10,0),('1','202',37,'DAILY SHIFT','2022-04-16','2022-04-16 07:00:00','2022-04-17 07:00:00','739',0.00,0.00,'739','2022-04-16 19:34:41','739','2022-04-16 19:35:04',10,0),('1','202',38,'DAILY SHIFT','2022-04-17','2022-04-17 06:47:43','2022-04-18 06:47:43','739',0.00,0.00,'739','2022-04-17 11:01:28','739','2022-04-17 11:01:49',10,0),('1','202',39,'OPERATIONAL LOSS ','2022-04-17','2022-04-17 11:05:32','2022-04-18 11:05:32','739',0.00,0.00,'739','2022-04-17 11:08:47','739','2022-04-17 11:09:02',10,0),('1','202',40,'DAILY SHIFT','2022-04-17','2022-04-17 11:09:37','2022-04-18 11:09:37','739',0.00,0.00,'739','2022-04-17 19:31:06','739','2022-04-17 19:31:20',10,0),('1','202',41,'DAILY SHIFT','2022-04-18','2022-04-18 06:46:13','2022-04-19 06:46:13','739',0.00,0.00,'739','2022-04-18 19:20:28','739','2022-04-18 19:20:45',10,0),('1','202',42,'DAILY SHIFT','2022-04-19','2022-04-19 06:53:35','2022-04-20 06:53:35','739',0.00,0.00,'739','2022-04-19 19:20:05','739','2022-04-19 19:20:38',10,0),('1','202',43,'DAILY SHIFT','2022-04-20','2022-04-20 07:00:15','2022-04-21 07:00:15','739',0.00,0.00,'739','2022-04-20 19:19:44','739','2022-04-20 19:20:01',10,0),('1','202',44,'DAILY SHIFT','2022-04-21','2022-04-21 06:59:28','2022-04-22 06:59:28','739',0.00,0.00,'739','2022-04-21 11:37:02','739','2022-04-21 11:37:22',10,0),('1','202',45,'OPERATIONAL LOSS ','2022-04-21','2022-04-21 11:40:09','2022-04-22 11:40:09','739',0.00,0.00,'739','2022-04-21 11:44:11','739','2022-04-21 11:44:28',10,0),('1','202',46,'DAILY SHIFT','2022-04-21','2022-04-21 11:50:57','2022-04-22 11:50:57','739',0.00,0.00,'739','2022-04-21 19:29:14','739','2022-04-21 19:29:29',10,0),('1','202',47,'DAILY SHIFT','2022-04-22','2022-04-22 06:48:51','2022-04-23 06:48:51','739',0.00,0.00,'739','2022-04-22 19:30:57','739','2022-04-22 19:31:17',10,0),('1','202',48,'DAILY SHIFT','2022-04-23','2022-04-23 06:54:56','2022-04-24 06:54:56','739',0.00,0.00,'739','2022-04-23 19:44:11','739','2022-04-23 19:44:28',10,0),('1','202',49,'DAILY SHIFT','2022-04-24','2022-04-24 06:46:45','2022-04-25 06:46:45','739',0.00,0.00,'739','2022-04-24 19:22:44','739','2022-04-24 19:23:03',10,0),('1','202',50,'DAILY SHIFT','2022-04-25','2022-04-25 06:57:44','2022-04-26 06:57:44','739',0.00,0.00,'739','2022-04-25 19:34:52','739','2022-04-25 19:35:12',10,0),('1','202',51,'DAILY SHIFT','2022-04-26','2022-04-26 06:49:47','2022-04-27 06:49:47','739',0.00,0.00,'739','2022-04-26 19:27:43','739','2022-04-26 19:28:01',10,0),('1','202',52,'DAILY SHIFT','2022-04-27','2022-04-27 07:55:02','2022-04-28 07:55:02','739',0.00,0.00,'739','2022-04-27 19:39:05','739','2022-04-27 19:39:26',10,0),('1','202',53,'DAILY SHIFT','2022-04-28','2022-04-28 06:37:07','2022-04-29 06:37:07','739',0.00,0.00,'739','2022-04-28 19:34:02','739','2022-04-28 19:34:21',10,0),('1','202',54,'DAILY SHIFT','2022-04-29','2022-04-29 07:21:06','2022-04-30 07:21:06','739',0.00,0.00,'739','2022-04-29 19:26:15','739','2022-04-29 19:26:32',10,0),('1','202',55,'DAILY SHIFT','2022-04-30','2022-04-30 06:38:44','2022-05-01 06:38:44','739',0.00,0.00,'739','2022-04-30 19:40:15','739','2022-04-30 19:40:34',10,0),('1','202',56,'DAILY SHIFT','2022-05-01','2022-05-01 06:35:47','2022-05-02 06:35:47','739',0.00,0.00,'739','2022-05-01 19:44:31','739','2022-05-01 19:44:57',10,0),('1','202',57,'DAILY SHIFT','2022-05-02','2022-05-02 09:54:46','2022-05-03 09:54:46','739',0.00,0.00,'739','2022-05-02 19:37:24','739','2022-05-02 19:37:50',10,0),('1','202',58,'DAILY SHIFT','2022-05-03','2022-05-03 07:01:41','2022-05-04 07:01:41','739',0.00,0.00,'739','2022-05-03 20:02:14','739','2022-05-03 20:02:34',10,0),('1','202',59,'DAILY SHIFT','2022-05-04','2022-05-04 07:02:37','2022-05-05 07:02:37','739',0.00,0.00,'739','2022-05-04 19:42:56','739','2022-05-04 19:43:13',10,0),('1','202',60,'DAILY SHIFT','2022-05-05','2022-05-05 06:53:13','2022-05-06 06:53:13','739',0.00,0.00,'739','2022-05-05 19:40:10','739','2022-05-05 19:40:27',10,0),('1','202',61,'DAILY SHIFT','2022-05-06','2022-05-06 06:54:15','2022-05-07 06:54:15','739',0.00,0.00,'739','2022-05-06 19:54:17','739','2022-05-06 19:54:35',10,0),('1','202',62,'operational loss','2022-05-06','2022-05-06 19:58:58','2022-05-07 19:58:58','739',0.00,0.00,'739','2022-05-06 20:02:37','739','2022-05-06 20:02:59',10,0),('1','202',63,'DAILY SHIFT','2022-05-07','2022-05-07 06:49:30','2022-05-08 06:49:30','739',0.00,0.00,'739','2022-05-07 19:40:08','739','2022-05-07 19:40:27',10,0),('1','202',64,'DAILY SHIFT','2022-05-08','2022-05-08 06:52:44','2022-05-09 06:52:44','739',0.00,0.00,'739','2022-05-08 19:33:39','739','2022-05-08 19:33:57',10,0),('1','202',65,'DAILY SHIFT','2022-05-09','2022-05-09 06:28:55','2022-05-10 06:28:55','739',0.00,0.00,'739','2022-05-09 19:31:20','739','2022-05-09 19:31:51',10,0),('1','202',66,'DAILY SHIFT','2022-05-10','2022-05-10 06:50:44','2022-05-11 06:50:44','739',0.00,0.00,'739','2022-05-10 20:27:17','739','2022-05-10 20:27:45',10,0),('1','202',67,'DAILY SHIFT','2022-05-11','2022-05-11 06:59:48','2022-05-12 06:59:48','739',0.00,0.00,'739','2022-05-11 19:50:11','739','2022-05-11 19:50:29',10,0),('1','202',68,'DAILY SHIFT','2022-05-12','2022-05-12 06:40:22','2022-05-13 06:40:22','739',0.00,0.00,'739','2022-05-12 18:01:25','739','2022-05-12 18:01:44',10,0),('1','202',69,'OPERATIONAL LOSS ','2022-05-13','2022-05-13 13:54:46','2022-05-14 13:54:46','739',0.00,0.00,'739','2022-05-13 13:59:18','739','2022-05-13 13:59:58',10,0),('1','202',70,'DAILY SHIFT','2022-05-13','2022-05-13 14:00:17','2022-05-14 14:00:17','739',0.00,0.00,'739','2022-05-13 19:24:07','739','2022-05-13 19:24:27',10,0),('1','202',71,'DAILY SHIFT','2022-05-14','2022-05-14 07:21:30','2022-05-15 07:21:30','739',0.00,0.00,'739','2022-05-14 19:58:31','739','2022-05-14 19:58:47',10,0),('1','202',72,'DAILY SHIFT','2022-05-15','2022-05-15 06:51:59','2022-05-16 06:51:59','739',0.00,0.00,'739','2022-05-15 19:16:48','739','2022-05-15 19:17:09',10,0),('1','202',73,'DAILY SHIFT','2022-05-16','2022-05-16 07:12:07','2022-05-17 07:12:07','739',0.00,0.00,'739','2022-05-17 06:45:14','739','2022-05-17 06:45:57',10,0),('1','202',74,'DAILY SHIFT','2022-05-17','2022-05-17 06:46:13','2022-05-18 06:46:13','739',0.00,0.00,'739','2022-05-17 15:50:02','739','2022-05-17 15:50:19',10,0),('1','202',75,'OPERATIONAL LOSS ','2022-05-17','2022-05-17 15:56:01','2022-05-18 15:56:01','739',0.00,0.00,'739','2022-05-17 16:06:02','739','2022-05-17 16:06:19',10,0),('1','202',76,'DAILY SHIFT','2022-05-19','2022-05-19 15:27:46','2022-05-20 15:27:46','739',0.00,0.00,'739','2022-05-19 15:33:18','739','2022-05-19 15:33:35',10,0),('1','202',77,'DAILY SHIFT','2022-05-19','2022-05-19 15:33:58','2022-05-20 15:33:58','739',0.00,0.00,'739','2022-05-19 19:36:10','739','2022-05-19 19:36:29',10,0),('1','202',78,'DAILY SHIFT','2022-05-20','2022-05-20 06:51:32','2022-05-21 06:51:32','739',0.00,0.00,'739','2022-05-20 19:30:33','739','2022-05-20 19:30:55',10,0),('1','202',79,'DAILY SHIFT','2022-05-21','2022-05-21 06:50:19','2022-05-22 06:50:19','739',0.00,0.00,'739','2022-05-21 19:29:04','739','2022-05-21 19:29:39',10,0),('1','202',80,'DAILY SHIFT','2022-05-22','2022-05-22 06:42:33','2022-05-23 06:42:33','739',0.00,0.00,'739','2022-05-22 19:12:16','739','2022-05-22 19:12:32',10,0),('1','202',81,'DAILY SHIFT','2022-05-23','2022-05-23 06:43:25','2022-05-24 06:43:25','739',0.00,0.00,'739','2022-05-23 16:13:47','739','2022-05-23 16:14:14',10,0),('1','202',82,'DAILY SHIFT','2022-05-23','2022-05-23 16:14:43','2022-05-24 16:14:43','739',0.00,0.00,'739','2022-05-23 19:14:20','739','2022-05-23 19:14:37',10,0),('1','202',83,'DAILY SHIFT','2022-05-24','2022-05-24 06:45:24','2022-05-25 06:45:24','739',0.00,0.00,'739','2022-05-24 20:25:05','739','2022-05-24 20:25:25',10,0),('1','202',84,'DAILY SHIFT','2022-05-25','2022-05-25 06:04:30','2022-05-26 06:04:30','739',0.00,0.00,'739','2022-05-25 19:52:20','739','2022-05-25 19:52:40',10,0),('1','202',85,'DAILY SHIFT','2022-05-26','2022-05-26 06:58:54','2022-05-27 06:58:54','739',0.00,0.00,'739','2022-05-26 18:33:20','739','2022-05-26 18:33:35',10,0),('1','202',86,'DAILY SHIFT','2022-05-27','2022-05-27 09:15:54','2022-05-28 09:15:54','739',0.00,0.00,'739','2022-05-27 19:47:50','739','2022-05-27 19:48:08',10,0),('1','202',87,'DAILY SHIFT','2022-05-28','2022-05-28 06:53:54','2022-05-29 06:53:54','739',0.00,0.00,'739','2022-05-28 14:41:44','739','2022-05-28 14:42:03',10,0),('1','202',88,'OPERATIONAL LOSS ','2022-05-28','2022-05-28 14:51:56','2022-05-29 14:51:56','739',0.00,0.00,'739','2022-05-28 14:55:42','739','2022-05-28 14:56:02',10,0),('1','202',89,'DAILY SHIFT','2022-05-29','2022-05-29 07:23:24','2022-05-30 07:23:24','739',0.00,0.00,'739','2022-05-29 20:05:10','739','2022-05-29 20:05:30',10,0),('1','202',90,'DAILY SHIFT','2022-05-30','2022-05-30 06:48:34','2022-05-31 06:48:34','739',0.00,0.00,'739','2022-05-30 11:53:04','739','2022-05-30 11:53:19',10,0),('1','202',91,'OPERATIONAL LOSS ','2022-05-30','2022-05-30 11:56:13','2022-05-31 11:56:13','739',0.00,0.00,'739','2022-05-30 12:06:06','739','2022-05-30 12:06:22',10,0),('1','202',92,'DAILY SHIFT','2022-05-30','2022-05-30 12:06:42','2022-05-31 12:06:42','739',0.00,0.00,'739','2022-05-30 19:28:48','739','2022-05-30 19:29:11',10,0),('1','202',93,'DAILY SHIFT','2022-05-31','2022-05-31 06:16:55','2022-06-01 06:16:55','739',0.00,0.00,'739','2022-05-31 19:50:39','739','2022-05-31 19:51:00',10,0),('1','202',94,'DAILY SHIFT','2022-06-01','2022-06-01 06:38:34','2022-06-02 06:38:34','739',0.00,0.00,'739','2022-06-01 11:39:36','739','2022-06-01 11:39:54',10,0),('1','202',95,'operational loss','2022-06-01','2022-06-01 16:36:33','2022-06-02 16:36:33','739',0.00,0.00,'739','2022-06-01 16:40:16','739','2022-06-01 16:40:51',10,0),('1','202',96,'DAILY SHIFT','2022-06-03','2022-06-03 08:56:12','2022-06-04 08:56:12','739',0.00,0.00,'739','2022-06-03 19:56:28','739','2022-06-03 19:56:46',10,0),('1','202',97,'DAILY SHIFT','2022-06-04','2022-06-04 06:29:39','2022-06-05 06:29:39','739',0.00,0.00,'739','2022-06-04 19:30:22','739','2022-06-04 19:30:42',10,0),('1','202',98,'DAILY SHIFT','2022-06-05','2022-06-05 07:09:45','2022-06-06 07:09:45','739',0.00,0.00,'739','2022-06-05 19:45:20','739','2022-06-05 19:45:51',10,0),('1','202',99,'daily shift','2022-06-06','2022-06-06 06:38:50','2022-06-07 06:38:50','739',0.00,0.00,'739','2022-06-06 19:28:04','739','2022-06-06 19:28:28',10,0),('1','202',100,'DAILY SHIFT','2022-06-07','2022-06-07 06:42:15','2022-06-08 06:42:15','739',0.00,0.00,'739','2022-06-07 19:23:54','739','2022-06-07 19:24:10',10,0),('1','202',101,'DAILY SHIFT','2022-06-08','2022-06-08 06:22:50','2022-06-09 06:22:50','739',0.00,0.00,'739','2022-06-08 19:23:31','739','2022-06-08 19:23:56',10,0),('1','202',102,'DAILY SHIFT','2022-06-09','2022-06-09 06:41:38','2022-06-10 06:41:38','739',0.00,0.00,'739','2022-06-09 19:32:16','739','2022-06-09 19:32:32',10,0),('1','202',103,'DAILY SHIFT','2022-06-10','2022-06-10 06:08:18','2022-06-11 06:08:18','739',0.00,0.00,'739','2022-06-10 19:19:38','739','2022-06-10 19:20:16',10,0),('1','202',104,'DAILY SHIFT','2022-06-11','2022-06-11 06:48:48','2022-06-12 06:48:48','739',0.00,0.00,'739','2022-06-12 06:30:13','739','2022-06-12 06:30:29',10,0),('1','202',105,'DAILY SHIFT','2022-06-12','2022-06-12 06:31:02','2022-06-13 06:31:02','739',0.00,0.00,'739','2022-06-12 19:19:16','739','2022-06-12 19:19:43',10,0),('1','202',106,'DAILY SHIFT','2022-06-13','2022-06-13 06:38:47','2022-06-14 06:38:47','739',0.00,0.00,'739','2022-06-13 19:30:58','739','2022-06-13 19:31:16',10,0),('1','202',107,'DAILY SHIFT','2022-06-14','2022-06-14 06:14:39','2022-06-15 06:14:39','739',0.00,0.00,'739','2022-06-14 19:40:59','739','2022-06-14 19:41:21',10,0),('1','202',108,'DAILY SHIFT','2022-06-15','2022-06-15 06:41:14','2022-06-16 06:41:14','739',0.00,0.00,'739','2022-06-15 19:36:06','739','2022-06-15 19:36:24',10,0),('1','202',109,'DAILY SHIFT','2022-06-16','2022-06-16 06:23:45','2022-06-17 06:23:45','739',0.00,0.00,'739','2022-06-16 11:40:51','739','2022-06-16 11:41:08',10,0),('1','202',110,'OPERATIONAL LOSS ','2022-06-16','2022-06-16 15:02:14','2022-06-17 15:02:14','739',0.00,0.00,'739','2022-06-16 15:05:31','739','2022-06-16 15:05:49',10,0),('1','202',111,'DAILY SHIFT','2022-06-16','2022-06-16 15:06:16','2022-06-17 15:06:16','739',0.00,0.00,'739','2022-06-16 19:31:03','739','2022-06-16 19:32:01',10,0),('1','202',112,'DAILY SHIFT','2022-06-17','2022-06-17 07:21:20','2022-06-18 07:21:20','739',0.00,0.00,'739','2022-06-17 19:37:03','739','2022-06-17 19:37:21',10,0),('1','202',113,'DAILY SHIFT','2022-06-18','2022-06-18 06:21:23','2022-06-19 06:21:23','739',0.00,0.00,'739','2022-06-18 19:44:59','739','2022-06-18 19:45:23',10,0),('1','202',114,'DAILY SHIFT','2022-06-19','2022-06-19 07:03:20','2022-06-20 07:03:20','739',0.00,0.00,'739','2022-06-19 19:29:09','739','2022-06-19 19:29:54',10,0),('1','202',115,'DAILY SHIFT','2022-06-19','2022-06-19 19:33:54','2022-06-20 19:33:54','739',0.00,0.00,'739','2022-06-19 19:38:14','739','2022-06-19 19:39:06',10,0),('1','202',116,'DAILY SHIFT','2022-06-20','2022-06-20 08:03:30','2022-06-21 08:03:30','739',0.00,0.00,'739','2022-06-20 19:24:52','739','2022-06-20 19:25:14',10,0),('1','202',117,'DAILY SHIFT','2022-06-21','2022-06-21 06:44:25','2022-06-22 06:44:25','739',0.00,0.00,'739','2022-06-21 19:33:10','739','2022-06-21 19:33:30',10,0),('1','202',118,'DAILY SHIFT','2022-06-22','2022-06-22 06:27:36','2022-06-23 06:27:36','739',0.00,0.00,'739','2022-06-22 19:21:06','739','2022-06-22 19:22:07',10,0),('1','202',119,'DAILY SHIFT','2022-06-23','2022-06-23 06:52:27','2022-06-24 06:52:27','739',0.00,0.00,'739','2022-06-23 19:39:43','739','2022-06-23 19:40:00',10,0),('1','202',120,'DAILY SHIFT','2022-06-24','2022-06-24 06:58:27','2022-06-25 06:58:27','739',0.00,0.00,'739','2022-06-24 19:39:04','739','2022-06-24 19:39:22',10,0),('1','202',121,'DAILY SHIFT','2022-06-25','2022-06-25 09:46:13','2022-06-26 09:46:13','739',0.00,0.00,'739','2022-06-25 18:39:18','739','2022-06-25 18:39:38',10,0),('1','202',122,'DAILY SHIFT','2022-06-25','2022-06-25 18:57:08','2022-06-26 18:57:08','739',0.00,0.00,'739','2022-06-25 19:17:08','739','2022-06-25 19:17:56',10,0),('1','202',123,'DAILY SHIFT','2022-06-25','2022-06-25 19:24:50','2022-06-26 19:24:50','739',0.00,0.00,'739','2022-06-25 19:49:20','739','2022-06-25 19:49:42',10,0),('1','202',124,'DAILY SHIFT','2022-06-26','2022-06-26 06:21:34','2022-06-27 06:21:34','739',0.00,0.00,'739','2022-06-26 19:39:55','739','2022-06-26 19:40:17',10,0),('1','202',125,'DAILY SHIFT','2022-06-27','2022-06-27 06:51:43','2022-06-28 06:51:43','739',0.00,0.00,'739','2022-06-27 19:34:12','739','2022-06-27 19:34:29',10,0),('1','202',126,'DAILY SHIFT','2022-06-28','2022-06-28 06:09:32','2022-06-29 06:09:32','739',0.00,0.00,'739','2022-06-28 19:34:37','739','2022-06-28 19:34:58',10,0),('1','202',127,'DAILY SHIFT','2022-06-29','2022-06-29 06:41:14','2022-06-30 06:41:14','739',0.00,0.00,'739','2022-06-29 10:23:04','739','2022-06-29 10:23:22',10,0),('1','202',128,'DAILY SHIFT','2022-06-29','2022-06-29 10:23:39','2022-06-30 10:23:39','739',0.00,0.00,'739','2022-06-29 19:28:01','739','2022-06-29 19:28:22',10,0),('1','202',129,'DAILY SHIFT','2022-06-30','2022-06-30 06:19:51','2022-07-01 06:19:51','739',0.00,0.00,'739','2022-06-30 19:28:27','739','2022-06-30 19:28:46',10,0),('1','202',130,'DAILY SHIFT','2022-07-01','2022-07-01 06:49:12','2022-07-02 06:49:12','739',0.00,0.00,'739','2022-07-01 19:32:55','739','2022-07-01 19:33:59',10,0),('1','202',131,'DAILY SHIFT','2022-07-02','2022-07-02 06:11:13','2022-07-03 06:11:13','739',0.00,0.00,'739','2022-07-02 15:46:07','739','2022-07-02 15:46:37',10,0),('1','202',132,'OPERATIONAL LOSS ','2022-07-02','2022-07-02 15:47:11','2022-07-03 15:47:11','739',0.00,0.00,'739','2022-07-02 15:53:05','739','2022-07-02 15:53:21',10,0),('1','202',133,'DAILY SHIFT','2022-07-02','2022-07-02 16:28:58','2022-07-03 16:28:58','739',0.00,0.00,'739','2022-07-02 20:04:37','739','2022-07-02 20:04:53',10,0),('1','202',134,'DAILY SHIFT','2022-07-03','2022-07-03 06:53:22','2022-07-04 06:53:22','739',0.00,0.00,'739','2022-07-03 19:33:29','739','2022-07-03 19:33:56',10,0),('1','202',135,'DAILY SHIFT','2022-07-04','2022-07-04 06:36:20','2022-07-05 06:36:20','739',0.00,0.00,'739','2022-07-04 13:09:30','739','2022-07-04 13:09:54',10,0),('1','202',136,'OPERATIONAL LOSS ','2022-07-04','2022-07-04 13:10:26','2022-07-05 13:10:26','739',0.00,0.00,'739','2022-07-04 13:20:50','739','2022-07-04 13:21:08',10,0),('1','202',137,'DAILY SHIFT','2022-07-04','2022-07-04 13:21:33','2022-07-05 13:21:33','739',0.00,0.00,'739','2022-07-04 19:59:30','739','2022-07-04 19:59:54',10,0),('1','202',138,'DAILY SHIFT','2022-07-05','2022-07-05 06:53:08','2022-07-06 06:53:08','739',0.00,0.00,'739','2022-07-05 19:36:50','739','2022-07-05 19:37:16',10,0),('1','202',139,'DAILY SHIFT','2022-07-06','2022-07-06 06:13:21','2022-07-07 06:13:21','739',0.00,0.00,'739','2022-07-06 19:39:08','739','2022-07-06 19:39:37',10,0),('1','202',140,'DAILY SHIFT','2022-07-07','2022-07-07 06:21:52','2022-07-08 06:21:52','739',0.00,0.00,'739','2022-07-07 19:22:16','739','2022-07-07 19:22:34',10,0),('1','202',141,'DAILY SHIFT','2022-07-08','2022-07-08 06:33:11','2022-07-09 06:33:11','739',0.00,0.00,'739','2022-07-08 19:37:59','739','2022-07-08 19:40:52',10,0),('1','202',142,'DAILY SHIFT','2022-07-09','2022-07-09 11:51:18','2022-07-10 11:51:18','739',0.00,0.00,'739','2022-07-09 19:33:33','739','2022-07-09 19:33:50',10,0),('1','202',143,'DAILY SHIFT','2022-07-10','2022-07-10 06:31:32','2022-07-11 06:31:32','739',0.00,0.00,'739','2022-07-10 19:25:14','739','2022-07-10 19:25:36',10,0),('1','202',144,'DAILY SHIFT','2022-07-11','2022-07-11 06:32:28','2022-07-12 06:32:28','739',0.00,0.00,'739','2022-07-11 19:29:36','739','2022-07-11 19:29:58',10,0),('1','202',145,'DAILY SHIFT','2022-07-12','2022-07-12 06:45:15','2022-07-13 06:45:15','739',0.00,0.00,'739','2022-07-12 19:17:38','739','2022-07-12 19:18:00',10,0),('1','202',146,'DAILY SHIFT','2022-07-13','2022-07-13 06:43:01','2022-07-14 06:43:01','739',0.00,0.00,'739','2022-07-13 19:26:49','739','2022-07-13 19:27:06',10,0),('1','202',147,'DAILY SHIFT','2022-07-14','2022-07-14 06:36:33','2022-07-15 06:36:33','739',0.00,0.00,'739','2022-07-14 19:35:15','739','2022-07-14 19:35:33',10,0),('1','202',148,'DAILY SHIFT','2022-07-15','2022-07-15 06:24:43','2022-07-16 06:24:43','739',0.00,0.00,'739','2022-07-15 19:18:29','739','2022-07-15 19:18:48',10,0),('1','202',149,'DAILY SHIFT','2022-07-16','2022-07-16 06:31:57','2022-07-17 06:31:57','739',0.00,0.00,'739','2022-07-16 19:22:04','739','2022-07-16 19:22:24',10,0),('1','202',150,'DAILY SHIFT','2022-07-17','2022-07-17 06:44:12','2022-07-18 06:44:12','739',0.00,0.00,'739','2022-07-17 19:37:07','739','2022-07-17 19:37:25',10,0),('1','202',151,'DAILY SHIFT','2022-07-18','2022-07-18 06:37:12','2022-07-19 06:37:12','739',0.00,0.00,'739','2022-07-18 10:47:01','739','2022-07-18 10:47:17',10,0),('1','202',152,'OPERATIONAL LOSS ','2022-07-18','2022-07-18 10:52:42','2022-07-19 10:52:42','739',0.00,0.00,'739','2022-07-18 11:05:01','739','2022-07-18 11:05:26',10,0),('1','202',153,'DAILY SHIFT','2022-07-18','2022-07-18 11:05:51','2022-07-19 11:05:51','739',0.00,0.00,'739','2022-07-18 19:54:01','739','2022-07-18 19:54:24',10,0),('1','202',154,'DAILY SHIFT','2022-07-19','2022-07-19 06:15:02','2022-07-20 06:15:02','739',0.00,0.00,'739','2022-07-19 20:02:31','739','2022-07-19 20:03:08',10,0),('1','202',155,'DAILY SHIFT','2022-07-20','2022-07-20 06:22:19','2022-07-21 06:22:19','739',0.00,0.00,'739','2022-07-20 20:04:56','739','2022-07-20 20:05:13',10,0),('1','202',156,'DAILY SHIFT','2022-07-21','2022-07-21 06:27:04','2022-07-22 06:27:04','739',0.00,0.00,'739','2022-07-21 20:09:02','739','2022-07-21 20:09:21',10,0),('1','202',157,'DAILY SHIFT','2022-07-22','2022-07-22 07:09:43','2022-07-23 07:09:43','739',0.00,0.00,'739','2022-07-22 19:40:43','739','2022-07-22 19:41:14',10,0),('1','202',158,'DAILY SHIFT','2022-07-23','2022-07-23 06:35:47','2022-07-24 06:35:47','739',0.00,0.00,'739','2022-07-23 19:57:32','739','2022-07-23 19:57:59',10,0),('1','202',159,'DAILY SHIFT','2022-07-24','2022-07-24 06:25:40','2022-07-25 06:25:40','739',0.00,0.00,'739','2022-07-24 20:24:50','739','2022-07-24 20:25:09',10,0),('1','202',160,'DAILY SHIFT','2022-07-25','2022-07-25 06:21:03','2022-07-26 06:21:03','739',0.00,0.00,'739','2022-07-25 19:42:23','739','2022-07-25 19:42:49',10,0),('1','202',161,'DAILY SHIFT','2022-07-26','2022-07-26 06:14:50','2022-07-27 06:14:50','739',0.00,0.00,'739','2022-07-26 20:00:13','739','2022-07-26 20:00:45',10,0),('1','202',162,'DAILY SHIFT','2022-07-27','2022-07-27 06:22:12','2022-07-28 06:22:12','739',0.00,0.00,'739','2022-07-27 19:37:37','739','2022-07-27 19:38:05',10,0),('1','202',163,'DAILY SHIFT','2022-07-23','2022-07-27 19:39:19','2022-07-28 19:39:19','739',0.00,0.00,'739','2022-07-27 19:41:50','739','2022-07-27 19:42:17',10,0),('1','202',164,'DAILY SHIFT','2022-07-24','2022-07-27 19:42:55','2022-07-28 19:42:55','739',0.00,0.00,'739','2022-07-27 19:44:26','739','2022-07-27 19:44:46',10,0),('1','202',165,'DAILY SHIFT','2022-07-26','2022-07-27 19:45:19','2022-07-28 19:45:19','739',0.00,0.00,'739','2022-07-27 19:47:01','739','2022-07-28 06:30:54',10,0),('1','202',166,'DAILY SHIFT','2022-07-28','2022-07-28 06:31:17','2022-07-29 06:31:17','739',0.00,0.00,'739','2022-07-28 19:35:12','739','2022-07-28 19:35:40',10,0),('1','202',167,'DAILY SHIFT','2022-07-29','2022-07-29 06:22:01','2022-07-30 06:22:01','739',0.00,0.00,'739','2022-07-30 06:22:30','739','2022-07-30 06:22:55',10,0),('1','202',168,'DAILY SHIFT','2022-07-30','2022-07-30 06:23:19','2022-07-31 06:23:19','739',0.00,0.00,'739','2022-07-30 13:06:02','739','2022-07-30 13:06:20',10,0),('1','202',169,'DAILY SHIFT','2022-07-30','2022-07-30 13:07:00','2022-07-31 13:07:00','739',0.00,0.00,'739','2022-07-30 19:51:56','739','2022-07-30 19:52:32',10,0),('1','202',170,'Operation loss ','2022-07-30','2022-07-30 21:33:12','2022-07-31 21:33:12','739',0.00,0.00,'739','2022-07-30 21:39:18','739','2022-07-30 21:39:44',10,0),('1','202',171,'DAILY SHIFT','2022-07-31','2022-07-31 06:27:16','2022-08-01 06:27:16','739',0.00,0.00,'739','2022-07-31 14:00:22','739','2022-07-31 14:00:42',10,0),('1','202',172,'OPERATIONAL LOSS ','2022-07-31','2022-07-31 14:01:20','2022-08-01 14:01:20','739',0.00,0.00,'739','2022-07-31 14:09:16','739','2022-07-31 14:09:40',10,0),('1','202',173,'DAILY SHIFT','2022-07-31','2022-07-31 14:10:22','2022-08-01 14:10:22','739',0.00,0.00,'739','2022-07-31 19:38:24','739','2022-07-31 19:38:49',10,0),('1','202',174,'DAILY SHIFT','2022-08-01','2022-08-01 06:23:19','2022-08-02 06:23:19','739',0.00,0.00,'739','2022-08-01 19:34:23','739','2022-08-01 19:34:57',10,0),('1','202',175,'DAILY SHIFT','2022-08-02','2022-08-02 06:25:24','2022-08-03 06:25:24','739',0.00,0.00,'739','2022-08-02 19:47:42','739','2022-08-02 19:48:41',10,0),('1','202',176,'DAILY SHIFT','2022-08-03','2022-08-03 06:30:14','2022-08-04 06:30:14','739',0.00,0.00,'739','2022-08-03 19:47:01','739','2022-08-03 19:47:48',10,0),('1','202',177,'DAILY SHIFT','2022-08-04','2022-08-04 06:21:38','2022-08-05 06:21:38','739',0.00,0.00,'739','2022-08-04 19:53:19','739','2022-08-04 19:53:51',10,0),('1','202',178,'DAILY SHIFT','2022-08-05','2022-08-05 06:25:46','2022-08-06 06:25:46','739',0.00,0.00,'739','2022-08-05 20:13:51','739','2022-08-05 20:14:13',10,0),('1','202',179,'DAILY SHIFT','2022-08-06','2022-08-06 06:14:04','2022-08-07 06:14:04','739',0.00,0.00,'739','2022-08-06 20:05:39','739','2022-08-06 20:08:29',10,0),('1','202',180,'daily shift','2022-08-07','2022-08-07 06:25:03','2022-08-08 06:25:03','739',0.00,0.00,'739','2022-08-07 19:51:17','739','2022-08-07 19:51:44',10,0),('1','202',181,'daily shift','2022-08-08','2022-08-08 06:24:11','2022-08-09 06:24:11','739',0.00,0.00,'739','2022-08-08 20:16:59','739','2022-08-08 20:17:55',10,0),('1','202',182,'DAILY SHIFT','2022-08-09','2022-08-09 06:25:41','2022-08-10 06:25:41','739',0.00,0.00,'739','2022-08-09 19:56:56','739','2022-08-09 19:57:28',10,0),('1','202',183,'daily shift','2022-08-10','2022-08-10 06:21:48','2022-08-11 06:21:48','739',0.00,0.00,'739','2022-08-10 17:38:06','739','2022-08-10 17:38:31',10,0),('1','202',184,'operational loss','2022-08-10','2022-08-10 17:39:04','2022-08-11 17:39:04','739',0.00,0.00,'739','2022-08-10 21:40:57','739','2022-08-10 21:41:30',10,0),('1','202',185,'daily shift','2022-08-11','2022-08-11 06:29:27','2022-08-12 06:29:27','739',0.00,0.00,'739','2022-08-11 19:34:00','739','2022-08-11 19:34:21',10,0),('1','202',186,'daily shift','2022-08-12','2022-08-12 06:27:26','2022-08-13 06:27:26','739',0.00,0.00,'739','2022-08-12 19:32:20','739','2022-08-12 19:32:42',10,0),('1','202',187,'daily shift','2022-08-13','2022-08-13 06:39:46','2022-08-14 06:39:46','739',0.00,0.00,'739','2022-08-13 19:27:30','739','2022-08-13 19:27:49',10,0),('1','202',188,'DAILY SHIFT','2022-08-14','2022-08-14 06:34:44','2022-08-15 06:34:44','739',0.00,0.00,'739','2022-08-14 17:34:37','739','2022-08-14 17:34:58',10,0),('1','202',189,'DAILY SHIFT','2022-08-15','2022-08-15 06:58:34','2022-08-16 06:58:34','739',0.00,0.00,'739','2022-08-15 19:29:28','739','2022-08-15 19:29:45',10,0),('1','202',190,'DAILY SHIFT','2022-08-16','2022-08-16 06:07:17','2022-08-17 06:07:17','739',0.00,0.00,'739','2022-08-16 19:28:12','739','2022-08-16 19:28:32',10,0),('1','202',191,'DAILY SHIFT','2022-08-17','2022-08-17 06:17:52','2022-08-18 06:17:52','739',0.00,0.00,'739','2022-08-17 10:43:54','739','2022-08-17 10:44:12',10,0),('1','202',192,'OPERATIONAL LOSS ','2022-08-17','2022-08-17 10:44:36','2022-08-18 10:44:36','739',0.00,0.00,'739','2022-08-17 12:09:18','739','2022-08-17 12:09:37',10,0),('1','202',193,'DAILY SHIFT','2022-08-17','2022-08-17 14:18:23','2022-08-18 14:18:23','739',0.00,0.00,'739','2022-08-17 19:24:36','739','2022-08-17 19:24:59',10,0),('1','202',194,'DAILY SHIFT','2022-08-18','2022-08-18 05:58:45','2022-08-19 05:58:45','739',0.00,0.00,'739','2022-08-18 19:34:56','739','2022-08-18 19:35:26',10,0),('1','202',195,'DAILY SHIFT','2022-08-19','2022-08-19 05:56:43','2022-08-20 05:56:43','739',0.00,0.00,'739','2022-08-19 18:03:54','739','2022-08-19 18:04:16',10,0),('1','202',196,'DAILY SHIFT','2022-08-19','2022-08-19 18:05:08','2022-08-20 18:05:08','739',0.00,0.00,'739','2022-08-19 20:01:55','739','2022-08-19 20:02:19',10,0),('1','202',197,'OPERATIONAL LOSS ','2022-08-19','2022-08-19 20:08:30','2022-08-20 20:08:30','739',0.00,0.00,'739','2022-08-19 20:13:52','739','2022-08-19 20:14:11',10,0),('1','202',198,'DAILY SHIFT','2022-08-20','2022-08-20 06:16:58','2022-08-21 06:16:58','739',0.00,0.00,'739','2022-08-20 19:38:13','739','2022-08-20 19:38:37',10,0),('1','202',199,'daily shift','2022-08-21','2022-08-21 06:11:21','2022-08-22 06:11:21','739',0.00,0.00,'739','2022-08-21 18:05:25','739','2022-08-21 18:05:45',10,0),('1','202',200,'DAILY SHIFT','2022-08-22','2022-08-22 06:29:21','2022-08-23 06:29:21','739',0.00,0.00,'739','2022-08-22 20:00:06','739','2022-08-22 20:00:26',10,0),('1','202',201,'DAILY SHIFT','2022-08-23','2022-08-23 06:10:29','2022-08-24 06:10:29','739',0.00,0.00,'739','2022-08-23 09:53:14','739','2022-08-23 09:53:33',10,0),('1','202',202,'DAILY SHIFT','2022-08-23','2022-08-23 09:57:50','2022-08-24 09:57:50','739',0.00,0.00,'739','2022-08-23 19:49:08','739','2022-08-23 19:49:26',10,0),('1','202',203,'DAILY SHIFT','2022-08-24','2022-08-24 06:12:25','2022-08-25 06:12:25','739',0.00,0.00,'739','2022-08-24 20:27:26','739','2022-08-24 20:27:46',10,0),('1','202',204,'DAILY SHIFT','2022-08-25','2022-08-25 06:16:51','2022-08-26 06:16:51','739',0.00,0.00,'739','2022-08-25 19:41:02','739','2022-08-25 19:41:26',10,0),('1','202',205,'DAILY SHIFT','2022-08-26','2022-08-26 06:16:40','2022-08-27 06:16:40','739',0.00,0.00,'739','2022-08-26 19:28:09','739','2022-08-26 19:28:28',10,0),('1','202',206,'DAILY SHIFT','2022-08-27','2022-08-27 09:42:56','2022-08-28 09:42:56','739',0.00,0.00,'739','2022-08-27 19:25:34','739','2022-08-27 19:25:55',10,0),('1','202',207,'DAILY SHIFT','2022-08-28','2022-08-28 06:34:50','2022-08-29 06:34:50','739',0.00,0.00,'739','2022-08-28 19:18:22','739','2022-08-28 19:18:48',10,0),('1','202',208,'DAILY SHIFT','2022-08-29','2022-08-29 06:23:59','2022-08-30 06:23:59','739',0.00,0.00,'739','2022-08-29 16:22:29','739','2022-08-29 16:22:52',10,0),('1','202',209,'OPERATIONAL LOSS ','2022-08-29','2022-08-29 16:24:36','2022-08-30 16:24:36','739',0.00,0.00,'739','2022-08-29 16:30:58','739','2022-08-29 16:31:21',10,0),('1','202',210,'DAILY SHIFT','2022-08-30','2022-08-30 06:20:23','2022-08-31 06:20:23','739',0.00,0.00,'739','2022-08-30 19:33:44','739','2022-08-30 19:34:07',10,0),('1','202',211,'DAILY SHIFT','2022-08-31','2022-08-31 06:14:53','2022-09-01 06:14:53','739',0.00,0.00,'739','2022-08-31 14:42:51','739','2022-08-31 14:43:07',10,0),('1','202',212,'OPERATIONAL LOSS ','2022-08-31','2022-08-31 14:43:59','2022-09-01 14:43:59','739',0.00,0.00,'739','2022-08-31 15:06:38','739','2022-08-31 15:06:55',10,0),('1','202',213,'DAILY SHIFT','2022-08-31','2022-08-31 15:07:15','2022-09-01 15:07:15','739',0.00,0.00,'739','2022-08-31 19:32:21','739','2022-08-31 19:32:42',10,0),('1','202',214,'DAILY SHIFT','2022-09-01','2022-09-01 06:09:47','2022-09-02 06:09:47','739',0.00,0.00,'739','2022-09-01 19:16:30','739','2022-09-01 19:16:47',10,0),('1','202',215,'DAILY SALES','2022-09-02','2022-09-02 06:36:05','2022-09-03 06:36:05','739',0.00,0.00,'739','2022-09-02 17:28:58','739','2022-09-02 17:29:21',10,0),('1','202',216,'OPRITION LOSS','2022-09-02','2022-09-02 17:30:54','2022-09-03 17:30:54','739',0.00,0.00,'739','2022-09-02 17:36:59','739','2022-09-02 17:37:18',10,0),('1','202',217,'DAILY SALES','2022-09-02','2022-09-02 17:37:53','2022-09-03 17:37:53','739',0.00,0.00,'739','2022-09-02 19:55:03','739','2022-09-02 19:55:20',10,0),('1','202',218,'DAILY SALES','2022-09-03','2022-09-03 06:31:26','2022-09-04 06:31:26','739',0.00,0.00,'739','2022-09-03 18:04:26','739','2022-09-03 18:05:05',10,0),('1','202',219,'OPERATIONAL LOSS','2022-09-03','2022-09-03 18:32:49','2022-09-04 18:32:49','739',0.00,0.00,'739','2022-09-03 18:37:25','739','2022-09-03 18:38:17',10,0),('1','202',220,'DAILY SHIFT','2022-09-04','2022-09-04 06:36:21','2022-09-05 06:36:21','739',0.00,0.00,'739','2022-09-04 19:36:19','739','2022-09-04 19:36:49',10,0),('1','202',221,'DAILY SHIFT','2022-09-05','2022-09-05 06:17:06','2022-09-06 06:17:06','739',0.00,0.00,'739','2022-09-05 14:13:14','739','2022-09-05 14:13:58',10,0),('1','202',222,'OPERATIONAL LOSS','2022-09-05','2022-09-05 14:14:40','2022-09-06 14:14:40','739',0.00,0.00,'739','2022-09-05 14:20:01','739','2022-09-05 14:20:34',10,0),('1','202',223,'DAILY SHIFT','2022-09-05','2022-09-05 16:53:20','2022-09-06 16:53:20','739',0.00,0.00,'739','2022-09-05 19:21:17','739','2022-09-05 19:21:35',10,0),('1','202',224,'DAILY SHIFT','2022-09-06','2022-09-06 06:23:51','2022-09-07 06:23:51','739',0.00,0.00,'739','2022-09-06 19:40:45','739','2022-09-06 19:41:05',10,0),('1','202',225,'DAILY SALES','2022-09-07','2022-09-07 06:21:04','2022-09-08 06:21:04','739',0.00,0.00,'739','2022-09-07 14:31:24','739','2022-09-07 14:31:41',10,0),('1','202',226,'DAILY SHIFT','2022-09-07','2022-09-07 14:32:33','2022-09-08 14:32:33','739',0.00,0.00,'739','2022-09-07 14:36:09','739','2022-09-07 14:36:30',10,0),('1','202',227,'DAILY SHIFT','2022-09-07','2022-09-07 14:40:29','2022-09-08 14:40:29','739',0.00,0.00,'739','2022-09-07 20:07:12','739','2022-09-07 20:07:36',10,0),('1','202',228,'DAILY SHIFT','2022-09-08','2022-09-08 06:22:21','2022-09-09 06:22:21','739',0.00,0.00,'739','2022-09-08 20:06:12','739','2022-09-08 20:06:40',10,0),('1','202',229,'DAILY SHIFT','2022-09-09','2022-09-09 06:03:30','2022-09-10 06:03:30','739',0.00,0.00,'739','2022-09-09 14:32:24','739','2022-09-09 14:33:15',10,0),('1','202',230,'OPERATIONAL LOSS','2022-09-09','2022-09-09 14:39:43','2022-09-10 14:39:43','739',0.00,0.00,'739','2022-09-09 14:43:46','739','2022-09-09 14:44:09',10,0),('1','202',231,'DAILY SHIFT','2022-09-10','2022-09-10 06:54:54','2022-09-11 06:54:54','739',0.00,0.00,'739','2022-09-10 19:22:15','739','2022-09-10 19:22:32',10,0),('1','202',232,'DAILY SHIFT','2022-09-11','2022-09-11 06:13:03','2022-09-12 06:13:03','739',0.00,0.00,'739','2022-09-11 17:55:43','739','2022-09-11 17:56:02',10,0),('1','202',233,'OPERATIONAL LOSS','2022-09-11','2022-09-11 18:02:21','2022-09-12 18:02:21','739',0.00,0.00,'739','2022-09-13 10:46:16','739','2022-09-13 10:46:42',10,0),('1','202',234,'DAILY SHIFT','2022-09-13','2022-09-13 10:47:07','2022-09-14 10:47:07','739',0.00,0.00,'739','2022-09-13 19:16:07','739','2022-09-13 19:18:06',10,0),('1','202',235,'DAILY SHIFT','2022-09-14','2022-09-14 05:59:35','2022-09-15 05:59:35','739',0.00,0.00,'739','2022-09-15 06:00:06','739','2022-09-15 06:00:49',10,0),('1','202',236,'DAILY SHIFT','2022-09-15','2022-09-15 06:01:34','2022-09-16 06:01:34','739',0.00,0.00,'739','2022-09-15 19:28:43','739','2022-09-15 19:29:05',10,0),('1','202',237,'DAILY SHIFT','2022-09-16','2022-09-16 06:50:50','2022-09-17 06:50:50','739',0.00,0.00,'739','2022-09-16 19:32:54','739','2022-09-16 19:33:24',10,0),('1','202',238,'DAILY SHIFT','2022-09-17','2022-09-17 06:07:12','2022-09-18 06:07:12','739',0.00,0.00,'739','2022-09-17 12:09:52','739','2022-09-17 12:10:21',10,0),('1','202',239,'OPERATIONAL LOSS','2022-09-17','2022-09-17 12:11:31','2022-09-18 12:11:31','739',0.00,0.00,'739','2022-09-17 12:42:09','739','2022-09-17 12:42:39',10,0),('1','202',240,'DAILY SHIFT','2022-09-17','2022-09-17 12:45:23','2022-09-18 12:45:23','739',0.00,0.00,'739','2022-09-17 19:20:46','739','2022-09-17 19:21:15',10,0),('1','202',241,'DAILY SHIFT','2022-09-18','2022-09-18 05:59:08','2022-09-19 05:59:08','739',0.00,0.00,'739','2022-09-18 19:47:13','739','2022-09-18 19:47:34',10,0),('1','202',242,'DAILY SHIFT','2022-09-19','2022-09-19 05:59:50','2022-09-20 05:59:50','739',0.00,0.00,'739','2022-09-19 19:29:33','739','2022-09-19 19:30:21',10,0),('1','202',243,'DAILY SHIFT','2022-09-20','2022-09-20 06:02:39','2022-09-21 06:02:39','739',0.00,0.00,'739','2022-09-20 19:32:52','739','2022-09-20 19:33:15',10,0),('1','202',244,'DAILY SHIFT','2022-09-21','2022-09-21 06:25:26','2022-09-22 06:25:26','739',0.00,0.00,'739','2022-09-21 08:07:51','739','2022-09-21 08:08:18',10,0),('1','202',245,'OPERATIONAL LOSS','2022-09-21','2022-09-21 08:11:22','2022-09-22 08:11:22','739',0.00,0.00,'739','2022-09-21 08:16:14','739','2022-09-21 08:16:32',10,0),('1','202',246,'DAILY SHIFT','2022-09-21','2022-09-21 08:19:49','2022-09-22 08:19:49','739',0.00,0.00,'739','2022-09-21 19:37:52','739','2022-09-21 19:38:14',10,0),('1','202',247,'DAILY SHIFT','2022-09-22','2022-09-22 06:19:55','2022-09-23 06:19:55','739',0.00,0.00,'739','2022-09-22 19:19:22','739','2022-09-22 19:19:45',10,0),('1','202',248,'DAILY SHIFT','2022-09-23','2022-09-23 06:02:38','2022-09-24 06:02:38','739',0.00,0.00,'739','2022-09-23 19:25:54','739','2022-09-23 19:26:30',10,0),('1','202',249,'DAILY SHIFT','2022-09-24','2022-09-24 06:16:20','2022-09-25 06:16:20','739',0.00,0.00,'739','2022-09-24 18:35:43','739','2022-09-24 18:36:03',10,0),('1','202',250,'DAILY SHIFT','2022-09-25','2022-09-25 07:03:01','2022-09-26 07:03:01','739',0.00,0.00,'739','2022-09-25 10:51:29','739','2022-09-25 10:51:56',10,0),('1','202',251,'OPERATIONAL LOSS','2022-09-25','2022-09-25 10:53:21','2022-09-26 10:53:21','739',0.00,0.00,'739','2022-09-25 10:59:49','739','2022-09-25 11:00:05',10,0),('1','202',252,'DAILY SHIFT','2022-09-25','2022-09-25 11:00:43','2022-09-26 11:00:43','739',0.00,0.00,'739','2022-09-25 19:01:25','739','2022-09-25 19:01:49',10,0),('1','202',253,'DAILY SHIFTS ','2022-09-26','2022-09-26 06:10:22','2022-09-27 06:10:22','739',0.00,0.00,'739','2022-09-26 19:02:29','739','2022-09-26 19:03:04',10,0),('1','202',254,'DAILY SHIFT','2022-09-27','2022-09-27 05:58:59','2022-09-28 05:58:59','739',0.00,0.00,'739','2022-09-27 19:27:03','739','2022-09-27 19:27:35',10,0),('1','202',255,'DAILY SHIFT','2022-09-28','2022-09-28 06:03:16','2022-09-29 06:03:16','739',0.00,0.00,'739','2022-09-28 13:13:58','739','2022-09-28 13:14:18',10,0),('1','202',256,'DAILY SHIFT','2022-09-28','2022-09-28 13:28:28','2022-09-29 13:28:28','739',0.00,0.00,'739','2022-09-28 19:31:37','739','2022-09-28 19:32:17',10,0),('1','202',257,'DAILY SHIFT','2022-09-29','2022-09-29 05:38:05','2022-09-30 05:38:05','739',0.00,0.00,'739','2022-09-29 19:21:03','739','2022-09-29 19:21:22',10,0),('1','202',258,'DAILY SHIFT','2022-09-30','2022-09-30 06:11:38','2022-10-01 06:11:38','739',0.00,0.00,'739','2022-09-30 19:14:17','739','2022-09-30 19:14:43',10,0),('1','202',259,'DAILY SHIFT','2022-10-01','2022-10-01 06:14:35','2022-10-02 06:14:35','739',0.00,0.00,'739','2022-10-02 06:38:00','739','2022-10-02 06:38:22',10,0),('1','202',260,'DAILY SHIFT','2022-10-02','2022-10-02 06:38:56','2022-10-03 06:38:56','739',0.00,0.00,'739','2022-10-02 19:16:14','739','2022-10-02 19:16:59',10,0),('1','202',261,'DAILY SHIFT','2022-10-03','2022-10-03 06:30:19','2022-10-04 06:30:19','739',0.00,0.00,'739','2022-10-03 19:16:04','739','2022-10-03 19:16:24',10,0),('1','202',262,'DAILY SHIFT ','2022-10-04','2022-10-04 06:05:30','2022-10-05 06:05:30','739',0.00,0.00,'739','2022-10-04 14:55:27','739','2022-10-04 14:55:50',10,0),('1','202',263,'OPERATIONAL LOSS','2022-10-04','2022-10-04 14:57:23','2022-10-05 14:57:23','739',0.00,0.00,'739','2022-10-04 15:02:58','739','2022-10-04 15:03:15',10,0),('1','202',264,'DAILY SHIFT','2022-10-04','2022-10-04 15:03:53','2022-10-05 15:03:53','739',0.00,0.00,'739','2022-10-04 19:47:32','739','2022-10-04 19:48:05',10,0),('1','202',265,'DAILY SHIFT ','2022-10-05','2022-10-05 06:24:12','2022-10-06 06:24:12','739',0.00,0.00,'739','2022-10-05 19:16:09','739','2022-10-05 19:16:28',10,0),('1','202',266,'DAILY SHIFT','2022-10-06','2022-10-06 05:56:41','2022-10-07 05:56:41','739',0.00,0.00,'739','2022-10-06 11:05:23','739','2022-10-06 11:05:45',10,0),('1','202',267,'DAILY SHIFT','2022-10-08','2022-10-08 17:02:03','2022-10-09 17:02:03','739',0.00,0.00,'739','2022-10-08 18:51:22','739','2022-10-08 18:51:42',10,0),('1','202',268,'DAILY SHIFT','2022-10-09','2022-10-09 06:35:40','2022-10-10 06:35:40','739',0.00,0.00,'739','2022-10-09 19:18:45','739','2022-10-09 19:19:07',10,0),('1','202',269,'DAILY SHIFT','2022-10-10','2022-10-10 06:12:02','2022-10-11 06:12:02','739',0.00,0.00,'739','2022-10-10 14:47:29','739','2022-10-10 14:47:50',10,0),('1','202',270,'OPERATIONAL LOSS','2022-10-10','2022-10-10 14:55:02','2022-10-11 14:55:02','739',0.00,0.00,'739','2022-10-10 14:59:08','739','2022-10-10 14:59:27',10,0),('1','202',271,'DAILY SHIFT','2022-10-11','2022-10-11 16:55:58','2022-10-12 16:55:58','739',0.00,0.00,'739','2022-10-11 19:13:38','739','2022-10-11 19:13:59',10,0),('1','202',272,'DAILY SHIFT ','2022-10-12','2022-10-12 05:59:30','2022-10-13 05:59:30','739',0.00,0.00,'739','2022-10-12 19:15:14','739','2022-10-12 19:15:37',10,0),('1','202',273,'DAILY SHIFT','2022-10-13','2022-10-13 06:38:16','2022-10-14 06:38:16','739',0.00,0.00,'739','2022-10-13 18:35:54','739','2022-10-13 18:36:15',10,0),('1','202',274,'DAILY SHIFT','2022-10-14','2022-10-14 06:45:04','2022-10-15 06:45:04','739',0.00,0.00,'739','2022-10-14 10:14:30','739','2022-10-14 10:15:12',10,0),('1','202',275,'OPERATIONAL LOSS','2022-10-14','2022-10-14 10:17:27','2022-10-15 10:17:27','739',0.00,0.00,'739','2022-10-14 13:51:11','739','2022-10-14 13:51:28',10,0),('1','202',276,'DAILY SHIFT','2022-10-14','2022-10-14 13:53:31','2022-10-15 13:53:31','739',0.00,0.00,'739','2022-10-14 19:38:35','739','2022-10-14 19:39:19',10,0),('1','202',277,'DAILY SHIFT','2022-10-15','2022-10-15 06:28:53','2022-10-16 06:28:53','739',0.00,0.00,'739','2022-10-15 19:04:29','739','2022-10-15 19:04:57',10,0),('1','202',278,'DAILY SHIFT','2022-10-16','2022-10-16 06:26:59','2022-10-17 06:26:59','739',0.00,0.00,'739','2022-10-16 19:08:25','739','2022-10-16 19:08:44',10,0),('1','202',279,'DAILY SHIFT','2022-10-17','2022-10-17 06:11:21','2022-10-18 06:11:21','739',0.00,0.00,'739','2022-10-17 12:28:15','739','2022-10-17 12:28:34',10,0),('1','202',280,'OPERATIONAL LOSS','2022-10-17','2022-10-17 12:30:52','2022-10-18 12:30:52','739',0.00,0.00,'739','2022-10-17 12:33:40','739','2022-10-17 12:33:58',10,0),('1','202',281,'DAILY SHIFT','2022-10-17','2022-10-17 12:36:33','2022-10-18 12:36:33','739',0.00,0.00,'739','2022-10-17 19:06:54','739','2022-10-17 19:07:12',10,0),('1','202',282,'DAILY SHIFT','2022-10-18','2022-10-18 06:30:11','2022-10-19 06:30:11','739',0.00,0.00,'739','2022-10-18 20:34:25','739','2022-10-18 20:34:48',10,0),('1','202',283,'DAILY SHIFT','2022-10-19','2022-10-19 06:54:47','2022-10-20 06:54:47','739',0.00,0.00,'739','2022-10-19 19:13:01','739','2022-10-19 19:13:22',10,0),('1','202',284,'DAILY SHIFT','2022-10-20','2022-10-20 06:21:05','2022-10-21 06:21:05','739',0.00,0.00,'739','2022-10-20 19:01:02','739','2022-10-20 19:01:22',10,0),('1','202',285,'DAILY SHIFT','2022-10-21','2022-10-21 06:20:02','2022-10-22 06:20:02','739',0.00,0.00,'739','2022-10-21 19:09:24','739','2022-10-21 19:09:53',10,0),('1','202',286,'OPRITION LOSS','2022-10-21','2022-10-21 19:11:26','2022-10-22 19:11:26','739',0.00,0.00,'739','2022-10-21 19:14:39','739','2022-10-21 19:15:05',10,0),('1','202',287,'DAILY SHIFT','2022-10-22','2022-10-22 10:26:25','2022-10-23 10:26:25','739',0.00,0.00,'739','2022-10-22 19:10:09','739','2022-10-22 19:10:31',10,0),('1','202',288,'DAILY SHIFT','2022-10-23','2022-10-23 06:46:35','2022-10-24 06:46:35','739',0.00,0.00,'739','2022-10-23 19:16:21','739','2022-10-23 19:17:19',10,0),('1','202',289,'DAILY SHIFT','2022-10-24','2022-10-24 06:18:21','2022-10-25 06:18:21','739',0.00,0.00,'739','2022-10-24 19:57:31','739','2022-10-24 19:57:49',10,0),('1','202',290,'DAILY SHIFT','2022-10-25','2022-10-25 06:25:55','2022-10-26 06:25:55','739',0.00,0.00,'739','2022-10-25 18:16:30','739','2022-10-25 18:16:55',10,0),('1','202',291,'DAILY SHIFT','2022-10-26','2022-10-26 07:28:32','2022-10-27 07:28:32','739',0.00,0.00,'739','2022-10-26 08:23:20','739','2022-10-26 08:23:49',10,0),('1','202',292,'OPERATIONAL LOSS','2022-10-26','2022-10-26 08:24:22','2022-10-27 08:24:22','739',0.00,0.00,'739','2022-10-26 08:31:02','739','2022-10-26 08:31:26',10,0),('1','202',293,'DAILY SHIFT','2022-10-26','2022-10-26 08:31:49','2022-10-27 08:31:49','739',0.00,0.00,'739','2022-10-26 19:08:48','739','2022-10-26 19:09:07',10,0),('1','202',294,'DAILY SHIFT','2022-10-27','2022-10-27 06:28:55','2022-10-28 06:28:55','739',0.00,0.00,'739','2022-10-27 19:29:12','739','2022-10-27 19:29:36',10,0),('1','202',295,'DAILY SHIFT','2022-10-28','2022-10-28 06:14:08','2022-10-29 06:14:08','739',0.00,0.00,'739','2022-10-28 19:09:31','739','2022-10-28 19:09:59',10,0),('1','202',296,'DAILY SHIFT','2022-10-29','2022-10-29 09:33:41','2022-10-30 09:33:41','739',0.00,0.00,'739','2022-10-29 17:26:00','739','2022-10-29 17:26:21',10,0),('1','202',297,'OPERATIONAL LOSS','2022-10-30','2022-10-30 06:40:49','2022-10-31 06:40:49','739',0.00,0.00,'739','2022-10-30 06:46:59','739','2022-10-30 06:47:28',10,0),('1','202',298,'DAILY SHIFT','2022-10-30','2022-10-30 07:19:03','2022-10-31 07:19:03','739',0.00,0.00,'739','2022-10-30 19:26:39','739','2022-10-30 19:27:07',10,0),('1','202',299,'DAILY SHIFT ','2022-10-31','2022-10-31 06:21:11','2022-11-01 06:21:11','739',0.00,0.00,'739','2022-10-31 19:20:36','739','2022-10-31 19:20:58',10,0),('1','202',300,'DAILY SHIFT','2022-11-01','2022-11-01 06:24:22','2022-11-02 06:24:22','739',0.00,0.00,'739','2022-11-01 19:33:36','739','2022-11-01 19:34:02',10,0),('1','202',301,'DAILY SHIFT','2022-11-02','2022-11-02 06:19:35','2022-11-03 06:19:35','739',0.00,0.00,'739','2022-11-02 10:53:20','739','2022-11-02 10:53:41',10,0),('1','202',302,'DAILY SHIFT','2022-11-05','2022-11-05 08:05:33','2022-11-06 08:05:33','739',0.00,0.00,'739','2022-11-05 19:06:56','739','2022-11-05 19:07:17',10,0),('1','202',303,'DAILY SHIFT','2022-11-06','2022-11-06 08:32:20','2022-11-07 08:32:20','739',0.00,0.00,'739','2022-11-06 19:00:10','739','2022-11-06 19:01:03',10,0),('1','202',304,'DAILY SHIFT','2022-11-07','2022-11-07 06:33:01','2022-11-08 06:33:01','739',0.00,0.00,'739','2022-11-07 13:12:03','739','2022-11-07 13:12:22',10,0),('1','202',305,'OPRITION LOSS','2022-11-07','2022-11-07 13:13:31','2022-11-08 13:13:31','739',0.00,0.00,'739','2022-11-07 13:16:07','739','2022-11-07 13:16:24',10,0),('1','202',306,'DAILY SHIFT','2022-11-07','2022-11-07 13:18:48','2022-11-08 13:18:48','739',0.00,0.00,'739','2022-11-07 19:20:07','739','2022-11-07 19:20:27',10,0),('1','202',307,'DAILY SHIFT','2022-11-08','2022-11-08 06:27:34','2022-11-09 06:27:34','739',0.00,0.00,'739','2022-11-08 19:02:37','739','2022-11-08 19:03:14',10,0),('1','202',308,'DAILY SHIFT','2022-11-09','2022-11-09 06:33:45','2022-11-10 06:33:45','739',0.00,0.00,'739','2022-11-09 19:06:54','739','2022-11-09 19:07:14',10,0),('1','202',309,'DAILY SHIFT','2022-11-10','2022-11-10 06:23:30','2022-11-11 06:23:30','739',0.00,0.00,'739','2022-11-10 19:28:15','739','2022-11-10 19:30:19',10,0),('1','202',310,'Daily shift','2022-11-11','2022-11-11 07:26:24','2022-11-12 07:26:24','739',0.00,0.00,'739','2022-11-11 18:57:49','739','2022-11-11 18:58:10',10,0),('1','202',311,'Daily shift','2022-11-12','2022-11-12 07:09:36','2022-11-13 07:09:36','739',0.00,0.00,'739','2022-11-12 11:17:11','739','2022-11-12 11:17:41',10,0),('1','202',312,'OPERATIONAL LOSS','2022-11-12','2022-11-12 11:19:30','2022-11-13 11:19:30','739',0.00,0.00,'739','2022-11-12 11:24:42','739','2022-11-12 11:25:00',10,0),('1','202',313,'DAILY SHIFT','2022-11-12','2022-11-12 11:25:22','2022-11-13 11:25:22','739',0.00,0.00,'739','2022-11-12 19:38:20','739','2022-11-12 19:38:39',10,0),('1','202',314,'Daily shift','2022-11-13','2022-11-13 06:47:05','2022-11-14 06:47:05','739',0.00,0.00,'739','2022-11-13 19:05:09','739','2022-11-13 19:05:31',10,0),('1','202',315,'Daily shift','2022-11-14','2022-11-14 06:13:37','2022-11-15 06:13:37','739',0.00,0.00,'739','2022-11-14 19:14:55','739','2022-11-14 19:15:19',10,0),('1','202',316,'Daily shift','2022-11-15','2022-11-15 07:52:55','2022-11-16 07:52:55','739',0.00,0.00,'739','2022-11-15 18:54:24','739','2022-11-15 18:54:45',10,0),('1','202',317,'Daily shift','2022-11-16','2022-11-16 08:29:50','2022-11-17 08:29:50','739',0.00,0.00,'739','2022-11-16 15:43:29','739','2022-11-16 15:43:49',10,0),('1','202',318,'OPERATIONAL LOSS','2022-11-16','2022-11-16 15:44:53','2022-11-17 15:44:53','739',0.00,0.00,'739','2022-11-16 15:47:18','739','2022-11-16 15:47:37',10,0),('1','202',319,'DAILY SHIFT','2022-11-16','2022-11-16 15:50:01','2022-11-17 15:50:01','739',0.00,0.00,'739','2022-11-16 19:44:41','739','2022-11-16 19:44:59',10,0),('1','202',320,'Daily shift','2022-11-17','2022-11-17 07:28:47','2022-11-18 07:28:47','739',0.00,0.00,'739','2022-11-17 19:06:47','739','2022-11-17 19:07:08',10,0),('1','202',321,'Daily shift','2022-11-18','2022-11-18 06:48:59','2022-11-19 06:48:59','739',0.00,0.00,'739','2022-11-18 19:19:29','739','2022-11-18 19:20:38',10,0),('1','202',322,'DAILY SHIFT','2022-11-19','2022-11-19 06:40:52','2022-11-20 06:40:52','739',0.00,0.00,'739','2022-11-19 19:21:59','739','2022-11-19 19:22:18',10,0),('1','202',323,'Daily shift','2022-11-20','2022-11-20 06:56:24','2022-11-21 06:56:24','739',0.00,0.00,'739','2022-11-20 10:38:17','739','2022-11-20 10:38:42',10,0),('1','202',324,'OPRITION LOSS','2022-11-20','2022-11-20 10:40:06','2022-11-21 10:40:06','739',0.00,0.00,'739','2022-11-20 10:43:08','739','2022-11-20 10:43:28',10,0),('1','202',325,'DAILY SHIFT','2022-11-20','2022-11-20 10:47:47','2022-11-21 10:47:47','739',0.00,0.00,'739','2022-11-20 19:31:24','739','2022-11-20 19:31:44',10,0),('1','202',326,'DAILY SHIFT','2022-11-21','2022-11-21 06:40:21','2022-11-22 06:40:21','739',0.00,0.00,'739','2022-11-21 19:05:00','739','2022-11-21 19:05:21',10,0),('1','202',327,'DAILY SHIFT','2022-11-22','2022-11-22 06:52:34','2022-11-23 06:52:34','739',0.00,0.00,'739','2022-11-22 20:23:15','739','2022-11-22 20:23:33',10,0),('1','202',328,'DAILY SHIFT','2022-11-23','2022-11-23 07:38:42','2022-11-24 07:38:42','739',0.00,0.00,'739','2022-11-23 18:52:12','739','2022-11-23 18:52:35',10,0),('1','202',329,'Daily shift','2022-11-24','2022-11-24 07:28:03','2022-11-25 07:28:03','739',0.00,0.00,'739','2022-11-24 19:02:17','739','2022-11-24 19:02:41',10,0),('1','202',330,'DAILY SHIFT','2022-11-25','2022-11-25 07:11:31','2022-11-26 07:11:31','739',0.00,0.00,'739','2022-11-25 19:12:46','739','2022-11-25 19:13:05',10,0),('1','202',331,'Daily shift','2022-11-26','2022-11-26 08:22:37','2022-11-27 08:22:37','739',0.00,0.00,'739','2022-11-26 19:29:59','739','2022-11-26 19:30:17',10,0),('1','202',332,'DAILY SHIFT','2022-11-27','2022-11-27 07:56:20','2022-11-28 07:56:20','739',0.00,0.00,'739','2022-11-27 19:08:14','739','2022-11-27 19:08:36',10,0),('1','202',333,'DAILY SHIFT','2022-11-28','2022-11-28 07:38:35','2022-11-29 07:38:35','739',0.00,0.00,'739','2022-11-28 19:12:53','739','2022-11-28 19:13:17',10,0),('1','202',334,'Daily shift','2022-11-29','2022-11-29 07:44:26','2022-11-30 07:44:26','739',0.00,0.00,'739','2022-11-29 19:28:30','739','2022-11-29 19:28:54',10,0),('1','202',335,'DAILY SHIFT','2022-11-30','2022-11-30 09:24:26','2022-12-01 09:24:26','739',0.00,0.00,'739','2022-11-30 19:12:52','739','2022-11-30 19:13:24',10,0),('1','202',336,'DAILY SHIFT','2022-12-01','2022-12-01 07:00:03','2022-12-02 07:00:03','739',0.00,0.00,'739','2022-12-01 19:47:52','739','2022-12-01 19:48:21',10,0),('1','202',337,'DAILY SHIFT','2022-12-02','2022-12-02 06:48:28','2022-12-03 06:48:28','739',0.00,0.00,'739','2022-12-02 19:09:55','739','2022-12-02 19:10:18',10,0),('1','202',338,'DAILY SHIFT','2022-12-03','2022-12-03 06:38:25','2022-12-04 06:38:25','739',0.00,0.00,'739','2022-12-03 11:54:34','739','2022-12-03 11:55:04',10,0),('1','202',339,'OPERATIONAL LOSS','2022-12-03','2022-12-03 11:57:00','2022-12-04 11:57:00','739',0.00,0.00,'739','2022-12-03 14:51:22','739','2022-12-03 14:51:41',10,0),('1','202',340,'DAILY SHIFT','2022-12-03','2022-12-03 14:52:05','2022-12-04 14:52:05','739',0.00,0.00,'739','2022-12-03 19:17:48','739','2022-12-03 19:18:15',10,0),('1','202',341,'DAILY SHIFT','2022-12-04','2022-12-04 06:32:37','2022-12-05 06:32:37','739',0.00,0.00,'739','2022-12-04 19:01:26','739','2022-12-04 19:01:56',10,0),('1','202',342,'DAILY SHIFT','2022-12-05','2022-12-05 06:49:01','2022-12-06 06:49:01','739',0.00,0.00,'739','2022-12-05 19:21:32','739','2022-12-05 19:21:55',10,0),('1','202',343,'DAILY SHIFT','2022-12-06','2022-12-06 07:14:03','2022-12-07 07:14:03','739',0.00,0.00,'739','2022-12-06 19:09:47','739','2022-12-06 19:10:09',10,0),('1','202',344,'DAILY SHIFT','2022-12-07','2022-12-07 06:33:36','2022-12-08 06:33:36','739',0.00,0.00,'739','2022-12-07 19:26:50','739','2022-12-07 19:27:13',10,0),('1','202',345,'DAILY SHIFT','2022-12-08','2022-12-08 06:52:38','2022-12-09 06:52:38','739',0.00,0.00,'739','2022-12-08 19:05:57','739','2022-12-08 19:06:21',10,0),('1','202',346,'DAILY SHIFT','2022-12-09','2022-12-09 06:34:48','2022-12-10 06:34:48','739',0.00,0.00,'739','2022-12-09 19:04:18','739','2022-12-09 19:04:38',10,0),('1','202',347,'DAILY SHIFT','2022-12-10','2022-12-10 06:38:35','2022-12-11 06:38:35','739',0.00,0.00,'739','2022-12-10 19:19:42','739','2022-12-10 19:20:08',10,0),('1','202',348,'DAILY SHIFT','2022-12-11','2022-12-11 06:29:28','2022-12-12 06:29:28','739',0.00,0.00,'739','2022-12-12 06:58:02','739','2022-12-12 06:58:25',10,0),('1','202',349,'DAILY SHIFT','2022-12-12','2022-12-12 06:58:46','2022-12-13 06:58:46','739',0.00,0.00,'739','2022-12-12 19:04:55','739','2022-12-12 19:05:19',10,0),('1','202',350,'DAILY SHIFT','2022-12-13','2022-12-13 06:37:15','2022-12-14 06:37:15','739',0.00,0.00,'739','2022-12-13 19:06:58','739','2022-12-13 19:07:23',10,0),('1','202',351,'DAILY SHIFT','2022-12-14','2022-12-14 06:41:17','2022-12-15 06:41:17','739',0.00,0.00,'739','2022-12-14 19:10:16','739','2022-12-14 19:10:37',10,0),('1','202',352,'DAILY SHIFT','2022-12-15','2022-12-15 08:28:16','2022-12-16 08:28:16','739',0.00,0.00,'739','2022-12-15 18:32:02','739','2022-12-15 18:33:00',10,0),('1','202',353,'OPERATIONAL LOSS','2022-12-15','2022-12-15 19:41:42','2022-12-16 19:41:42','739',0.00,0.00,'739','2022-12-15 19:45:42','739','2022-12-15 19:46:02',10,0),('1','202',354,'DAILY SHIFT','2022-12-15','2022-12-15 19:51:18','2022-12-16 19:51:18','739',0.00,0.00,'739','2022-12-15 19:53:41','739','2022-12-15 19:54:09',10,0),('1','202',355,'DAILY SHIFT','2022-12-16','2022-12-16 06:40:25','2022-12-17 06:40:25','739',0.00,0.00,'739','2022-12-16 19:48:10','739','2022-12-16 19:48:30',10,0),('1','202',356,'DAILY SHIFT','2022-12-17','2022-12-17 06:48:12','2022-12-18 06:48:12','739',0.00,0.00,'739','2022-12-17 19:13:27','739','2022-12-17 19:14:20',10,0),('1','202',357,'DAILY SHIFT','2022-12-18','2022-12-18 06:37:14','2022-12-19 06:37:14','739',0.00,0.00,'739','2022-12-18 18:51:22','739','2022-12-18 18:51:51',10,0),('1','202',358,'DAILY SHIFT','2022-12-19','2022-12-19 06:35:31','2022-12-20 06:35:31','739',0.00,0.00,'739','2022-12-19 19:34:32','739','2022-12-19 19:34:54',10,0),('1','202',359,'DAILY SHIFT','2022-12-20','2022-12-20 06:54:33','2022-12-21 06:54:33','739',0.00,0.00,'739','2022-12-20 19:54:09','739','2022-12-20 19:54:37',10,0),('1','202',360,'DAILY SHIFT','2022-12-20','2022-12-20 19:55:33','2022-12-21 19:55:33','739',0.00,0.00,'739','2022-12-20 20:02:40','739','2022-12-20 20:02:57',10,0),('1','202',361,'Daily shift','2022-12-21','2022-12-21 07:34:31','2022-12-22 07:34:31','739',0.00,0.00,'739','2022-12-21 19:03:34','739','2022-12-21 19:04:08',10,0),('1','202',362,'DAILY SHIFT','2022-12-22','2022-12-22 06:15:14','2022-12-23 06:15:14','739',0.00,0.00,'739','2022-12-22 19:04:00','739','2022-12-22 19:04:37',10,0),('1','202',363,'DAILY SHIFT','2022-12-23','2022-12-23 06:21:02','2022-12-24 06:21:02','739',0.00,0.00,'739','2022-12-23 18:34:30','739','2022-12-23 18:35:05',10,0),('1','202',364,'DAILY SHIFT','2023-01-07','2023-01-07 08:39:11','2023-01-08 08:39:11','739',0.00,0.00,'739','2023-01-07 19:26:37','739','2023-01-07 19:26:57',10,0),('1','202',365,'DAILY SHIFT','2023-01-08','2023-01-08 06:53:34','2023-01-09 06:53:34','739',0.00,0.00,'739','2023-01-08 19:23:13','739','2023-01-08 19:23:39',10,0),('1','202',366,'DAILY SHIFT','2023-01-09','2023-01-09 06:45:56','2023-01-10 06:45:56','739',0.00,0.00,'739','2023-01-09 19:13:21','739','2023-01-09 19:13:50',10,0),('1','202',367,'DAILY SHIFT','2023-01-10','2023-01-10 06:41:55','2023-01-11 06:41:55','739',0.00,0.00,'739','2023-01-10 19:26:12','739','2023-01-10 19:31:03',10,0),('1','202',368,'DAILY SHIFT','2023-01-11','2023-01-11 06:59:14','2023-01-12 06:59:14','739',0.00,0.00,'739','2023-01-11 19:12:52','739','2023-01-11 19:13:19',10,0),('1','202',369,'DAILY SHIFT','2023-01-12','2023-01-12 06:44:31','2023-01-13 06:44:31','739',0.00,0.00,'739','2023-01-12 19:07:55','739','2023-01-12 19:08:22',10,0),('1','202',370,'DAILY SHIFT','2023-01-13','2023-01-13 06:23:56','2023-01-14 06:23:56','739',0.00,0.00,'739','2023-01-13 16:34:13','739','2023-01-13 16:34:35',10,0),('1','202',371,'OPERATIONAL LOSS','2023-01-13','2023-01-13 16:37:15','2023-01-14 16:37:15','739',0.00,0.00,'739','2023-01-13 16:46:34','739','2023-01-13 16:46:54',10,0),('1','202',372,'DAILY SHIFT','2023-01-13','2023-01-13 16:57:21','2023-01-14 16:57:21','739',0.00,0.00,'739','2023-01-13 19:35:19','739','2023-01-13 19:35:40',10,0),('1','202',373,'DAILY SHIFT','2023-01-14','2023-01-14 06:58:48','2023-01-15 06:58:48','739',0.00,0.00,'739','2023-01-14 19:10:51','739','2023-01-14 19:11:17',10,0),('1','202',374,'DAILY SHIFT','2023-01-15','2023-01-15 07:14:42','2023-01-16 07:14:42','739',0.00,0.00,'739','2023-01-15 19:42:14','739','2023-01-15 19:42:41',10,0),('1','202',375,'DAILY SHIFT','2023-01-16','2023-01-16 06:45:13','2023-01-17 06:45:13','739',0.00,0.00,'739','2023-01-16 21:56:58','739','2023-01-16 21:57:28',10,0),('1','202',376,'DAILY SHIFT','2023-01-17','2023-01-17 07:34:17','2023-01-18 07:34:17','739',0.00,0.00,'739','2023-01-17 12:04:01','739','2023-01-17 12:04:17',10,0),('1','202',377,'OPERATIONAL LOSS','2023-01-17','2023-01-17 12:04:54','2023-01-18 12:04:54','739',0.00,0.00,'739','2023-01-17 12:12:50','739','2023-01-17 12:13:11',10,0),('1','202',378,'DAILY SHIFT','2023-01-17','2023-01-17 12:13:48','2023-01-18 12:13:48','739',0.00,0.00,'739','2023-01-17 19:39:27','739','2023-01-17 19:40:00',10,0),('1','202',379,'DAILY SHIFT','2023-01-18','2023-01-18 10:35:45','2023-01-19 10:35:45','739',0.00,0.00,'739','2023-01-18 19:22:28','739','2023-01-18 19:22:51',10,0),('1','202',380,'DAILY SHIFT ','2023-01-19','2023-01-19 07:00:14','2023-01-20 07:00:14','739',0.00,0.00,'739','2023-01-19 19:16:29','739','2023-01-19 19:16:50',10,0),('1','202',381,'DAILY SHIFT','2023-01-20','2023-01-20 06:56:22','2023-01-21 06:56:22','739',0.00,0.00,'739','2023-01-20 19:23:12','739','2023-01-20 19:23:30',10,0),('1','202',382,'DAILY SHIFT','2023-01-21','2023-01-21 07:01:18','2023-01-22 07:01:18','739',0.00,0.00,'739','2023-01-21 11:06:08','739','2023-01-21 11:06:47',10,0),('1','202',383,'OPERATIONAL LOSS','2023-01-21','2023-01-21 11:11:53','2023-01-22 11:11:53','739',0.00,0.00,'739','2023-01-21 11:25:34','739','2023-01-21 11:25:53',10,0),('1','202',384,'DAILY SHIFT','2023-01-21','2023-01-21 11:26:15','2023-01-22 11:26:15','739',0.00,0.00,'739','2023-01-21 19:14:35','739','2023-01-21 19:15:00',10,0),('1','202',385,'DAILY SHIFT','2023-01-22','2023-01-22 06:41:12','2023-01-23 06:41:12','739',0.00,0.00,'739','2023-01-22 19:38:15','739','2023-01-22 19:38:38',10,0),('1','202',386,'DAILY SHIFT','2023-01-23','2023-01-23 06:53:44','2023-01-24 06:53:44','739',0.00,0.00,'739','2023-01-23 19:27:21','739','2023-01-23 19:27:40',10,0),('1','202',387,'DAILY SHIFT','2023-01-24','2023-01-24 06:48:25','2023-01-25 06:48:25','739',0.00,0.00,'739','2023-01-24 19:12:54','739','2023-01-24 19:13:21',10,0),('1','202',388,'DAILY SHIFT','2023-01-25','2023-01-25 06:45:41','2023-01-26 06:45:41','739',0.00,0.00,'739','2023-01-26 06:58:42','739','2023-01-26 06:59:01',10,0),('1','202',389,'DAILY SHIFT','2023-01-26','2023-01-26 06:59:33','2023-01-27 06:59:33','739',0.00,0.00,'739','2023-01-26 19:34:33','739','2023-01-26 19:34:56',10,0),('1','202',390,'DAILY SHIFT','2023-01-27','2023-01-27 06:52:36','2023-01-28 06:52:36','739',0.00,0.00,'739','2023-01-27 19:35:42','739','2023-01-27 19:36:02',10,0),('1','202',391,'DAILY SHIFT','2023-01-28','2023-01-28 08:56:29','2023-01-29 08:56:29','739',0.00,0.00,'739','2023-01-28 19:28:18','739','2023-01-28 19:28:43',10,0),('1','202',392,'DAILY SHIFT','2023-01-29','2023-01-29 06:53:14','2023-01-30 06:53:14','739',0.00,0.00,'739','2023-01-29 19:58:26','739','2023-01-29 19:58:47',10,0),('1','202',393,'DAILY SHIFT','2023-01-30','2023-01-30 06:29:45','2023-01-31 06:29:45','739',0.00,0.00,'739','2023-01-30 20:06:48','739','2023-01-30 20:07:09',10,0),('1','202',394,'DAILY SHIFT','2023-01-31','2023-01-31 06:50:17','2023-02-01 06:50:17','739',0.00,0.00,'739','2023-01-31 19:28:22','739','2023-01-31 19:28:51',10,0),('1','202',395,'DAILY SHIFT','2023-02-01','2023-02-01 06:38:31','2023-02-02 06:38:31','739',0.00,0.00,'739','2023-02-01 19:11:21','739','2023-02-01 19:11:48',10,0),('1','202',396,'OPERATIONAL LOSS','2023-02-01','2023-02-01 19:16:01','2023-02-02 19:16:01','739',0.00,0.00,'739','2023-02-01 19:26:22','739','2023-02-01 19:26:49',10,0),('1','202',397,'DAILY SHIFT','2023-02-01','2023-02-01 19:36:48','2023-02-02 19:36:48','739',0.00,0.00,'739','2023-02-01 19:43:42','739','2023-02-01 19:44:26',10,0),('1','202',398,'DAILY SHIFT','2023-02-02','2023-02-02 06:57:36','2023-02-03 06:57:36','739',0.00,0.00,'739','2023-02-02 19:48:33','739','2023-02-02 19:48:58',10,0),('1','202',399,'DAILY SHIFT','2023-02-03','2023-02-03 06:53:02','2023-02-04 06:53:02','739',0.00,0.00,'739','2023-02-03 19:25:00','739','2023-02-03 19:25:42',10,0),('1','202',400,'DAILY SHIFT','2023-02-04','2023-02-04 06:45:53','2023-02-05 06:45:53','739',0.00,0.00,'739','2023-02-04 19:54:34','739','2023-02-04 19:54:57',10,0),('1','202',401,'DAILY SHIFT','2023-02-05','2023-02-05 06:47:39','2023-02-06 06:47:39','739',0.00,0.00,'739','2023-02-05 19:48:25','739','2023-02-05 19:48:43',10,0),('1','202',402,'DAILY SHIFT','2023-02-06','2023-02-06 06:59:54','2023-02-07 06:59:54','739',0.00,0.00,'739','2023-02-06 19:57:27','739','2023-02-06 19:57:49',10,0),('1','202',403,'DAILY SHIFT ','2023-02-07','2023-02-07 06:40:47','2023-02-08 06:40:47','739',0.00,0.00,'739','2023-02-07 20:04:40','739','2023-02-07 20:05:15',10,0),('1','202',404,'DAILY SHIFT ','2023-02-08','2023-02-08 06:50:46','2023-02-09 06:50:46','739',0.00,0.00,'739','2023-02-08 19:32:18','739','2023-02-08 19:32:43',10,0),('1','202',405,'DAILY SHIFT ','2023-02-09','2023-02-09 06:47:30','2023-02-10 06:47:30','739',0.00,0.00,'739','2023-02-09 19:53:21','739','2023-02-09 19:53:49',10,0),('1','202',406,'DAILY SHIFT','2023-02-10','2023-02-10 06:46:30','2023-02-11 06:46:30','739',0.00,0.00,'739','2023-02-10 20:14:09','739','2023-02-10 20:14:35',10,0),('1','202',407,'DAILY SHIFT','2023-02-11','2023-02-11 06:54:30','2023-02-12 06:54:30','739',0.00,0.00,'739','2023-02-11 20:17:44','739','2023-02-11 20:18:08',10,0),('1','202',408,'DAILY SHIFT','2023-02-12','2023-02-12 07:09:31','2023-02-13 07:09:31','739',0.00,0.00,'739','2023-02-12 18:28:24','739','2023-02-12 18:28:55',10,0),('1','202',409,'OPERATIONAL LOSS','2023-02-12','2023-02-12 22:39:14','2023-02-13 22:39:14','739',0.00,0.00,'739','2023-02-12 22:43:15','739','2023-02-12 22:43:36',10,0),('1','202',410,'DAILY SHIFT','2023-02-13','2023-02-13 08:34:23','2023-02-14 08:34:23','739',0.00,0.00,'739','2023-02-13 21:05:45','739','2023-02-13 21:06:07',10,0),('1','202',411,'DAILY SHIFT','2023-02-14','2023-02-14 07:07:07','2023-02-15 07:07:07','739',0.00,0.00,'739','2023-02-14 21:46:20','739','2023-02-14 21:52:17',10,0),('1','202',412,'DAILY SHIFT','2023-02-15','2023-02-15 06:33:39','2023-02-16 06:33:39','739',0.00,0.00,'739','2023-02-15 20:52:59','739','2023-02-15 20:53:22',10,0),('1','202',413,'DAILY SHIFT','2023-02-16','2023-02-16 06:56:26','2023-02-17 06:56:26','739',0.00,0.00,'739','2023-02-16 19:55:27','739','2023-02-16 19:56:17',10,0),('1','202',414,'DAILY SHIFT','2023-02-17','2023-02-17 07:03:03','2023-02-18 07:03:03','739',0.00,0.00,'739','2023-02-17 20:13:55','739','2023-02-17 20:14:17',10,0),('1','202',415,'DAILY SHIFT','2023-02-18','2023-02-18 06:50:19','2023-02-19 06:50:19','739',0.00,0.00,'739','2023-02-18 20:38:14','739','2023-02-18 20:38:39',10,0),('1','202',416,'DAILY SHIFT','2023-02-19','2023-02-19 06:37:25','2023-02-20 06:37:25','739',0.00,0.00,'739','2023-02-19 19:52:20','739','2023-02-19 19:52:44',10,0),('1','202',417,'DAILY SHIFT','2023-02-20','2023-02-20 06:30:17','2023-02-21 06:30:17','739',0.00,0.00,'739','2023-02-20 20:27:21','739','2023-02-20 20:27:46',10,0),('1','202',418,'DAILY SHIFT','2023-02-21','2023-02-21 06:40:43','2023-02-22 06:40:43','739',0.00,0.00,'739','2023-02-21 20:21:27','739','2023-02-21 20:21:49',10,0),('1','202',419,'DAILY SHIFT','2023-02-22','2023-02-22 06:52:45','2023-02-23 06:52:45','739',0.00,0.00,'739','2023-02-22 21:03:04','739','2023-02-22 21:03:32',10,0),('1','202',420,'DAILY SHIFT','2023-02-23','2023-02-23 06:53:38','2023-02-24 06:53:38','739',0.00,0.00,'739','2023-02-23 20:22:32','739','2023-02-23 20:22:54',10,0),('1','202',421,'DAILY SHIFT','2023-02-24','2023-02-24 07:04:59','2023-02-25 07:04:59','739',0.00,0.00,'739','2023-02-24 20:26:05','739','2023-02-24 20:26:31',10,0),('1','202',422,'DAILY SHIFT','2023-02-26','2023-02-26 07:01:23','2023-02-27 07:01:23','739',0.00,0.00,'739','2023-02-26 19:14:12','739','2023-02-26 19:14:39',10,0),('1','202',423,'OPERATIONAL LOSS','2023-02-26','2023-02-26 19:28:47','2023-02-27 19:28:47','739',0.00,0.00,'739','2023-02-26 19:33:42','739','2023-02-26 19:34:18',10,0),('1','202',424,'DAILY SHIFT','2023-02-27','2023-02-27 07:02:16','2023-02-28 07:02:16','739',0.00,0.00,'739','2023-02-27 21:47:51','739','2023-02-27 21:48:13',10,0),('1','202',425,'DAILY SHIFT','2023-02-28','2023-02-28 06:50:23','2023-03-01 06:50:23','739',0.00,0.00,'739','2023-02-28 19:45:37','739','2023-02-28 19:46:05',10,0),('1','202',426,'DAILY SHIFT','2023-03-01','2023-03-01 07:02:29','2023-03-02 07:02:29','739',0.00,0.00,'739','2023-03-01 20:26:11','739','2023-03-01 20:26:42',10,0),('1','202',427,'DAILY SHIFT','2023-03-02','2023-03-02 06:45:02','2023-03-03 06:45:02','739',0.00,0.00,'739','2023-03-02 20:13:13','739','2023-03-02 20:13:37',10,0),('1','202',428,'DAILY SHIFT','2023-03-03','2023-03-03 08:10:54','2023-03-04 08:10:54','739',0.00,0.00,'739','2023-03-03 19:30:17','739','2023-03-03 19:30:39',10,0),('1','202',429,'DAILY SHIFT','2023-03-04','2023-03-04 07:03:15','2023-03-05 07:03:15','739',0.00,0.00,'739','2023-03-04 19:52:05','739','2023-03-04 19:52:44',10,0),('1','202',430,'DAILY SHIFT','2023-03-05','2023-03-05 07:01:26','2023-03-06 07:01:26','739',0.00,0.00,'739','2023-03-05 19:31:07','739','2023-03-05 19:31:34',10,0),('1','202',431,'DAILY SHIFT','2023-03-06','2023-03-06 06:59:34','2023-03-07 06:59:34','739',0.00,0.00,'739','2023-03-06 19:57:41','739','2023-03-06 19:58:07',10,0),('1','202',432,'DAILY SHIFT ','2023-03-07','2023-03-07 06:55:53','2023-03-08 06:55:53','739',0.00,0.00,'739','2023-03-07 19:38:00','739','2023-03-07 19:38:24',10,0),('1','202',433,'DAILY SHIFT','2023-03-08','2023-03-08 07:16:31','2023-03-09 07:16:31','739',0.00,0.00,'739','2023-03-08 22:28:03','739','2023-03-08 22:28:29',10,0),('1','202',434,'DAILY SHIFT','2023-03-09','2023-03-09 08:36:41','2023-03-10 08:36:41','739',0.00,0.00,'739','2023-03-09 20:10:20','739','2023-03-09 20:10:45',10,0),('1','202',435,'DAILY SHIFT','2023-03-10','2023-03-10 07:12:09','2023-03-11 07:12:09','739',0.00,0.00,'739','2023-03-10 13:17:18','739','2023-03-10 13:17:42',10,0),('1','202',436,'OPERATIONAL LOSS','2023-03-10','2023-03-10 13:18:31','2023-03-11 13:18:31','739',0.00,0.00,'739','2023-03-10 13:28:34','739','2023-03-10 13:28:53',10,0),('1','202',437,'DAILY SHIFT','2023-03-10','2023-03-10 13:38:09','2023-03-11 13:38:09','739',0.00,0.00,'739','2023-03-10 20:03:06','739','2023-03-10 20:03:37',10,0),('1','202',438,'DAILY SHIFT','2023-03-11','2023-03-11 07:13:27','2023-03-12 07:13:27','739',0.00,0.00,'739','2023-03-11 20:04:21','739','2023-03-11 20:04:48',10,0),('1','202',439,'DAILY SHIFT','2023-03-12','2023-03-12 06:43:17','2023-03-13 06:43:17','739',0.00,0.00,'739','2023-03-12 19:44:37','739','2023-03-12 19:45:28',10,0),('1','202',440,'OPERATIONAL LOSS','2023-03-12','2023-03-12 19:59:14','2023-03-13 19:59:14','739',0.00,0.00,'739','2023-03-12 20:02:39','739','2023-03-12 20:03:03',10,0),('1','202',441,'DAILY SHIFT','2023-03-13','2023-03-13 08:55:23','2023-03-14 08:55:23','739',0.00,0.00,'739','2023-03-13 20:45:09','739','2023-03-13 20:45:47',10,0),('1','202',442,'DAILY SHIFT','2023-03-14','2023-03-14 06:49:20','2023-03-15 06:49:20','739',0.00,0.00,'739','2023-03-14 20:56:37','739','2023-03-14 20:57:02',10,0),('1','202',443,'DAILY SHIFT','2023-03-15','2023-03-15 07:00:08','2023-03-16 07:00:08','739',0.00,0.00,'739','2023-03-15 23:12:07','739','2023-03-15 23:12:33',10,0),('1','202',444,'DAILY SHIFT','2023-03-16','2023-03-16 06:54:25','2023-03-17 06:54:25','739',0.00,0.00,'739','2023-03-16 20:13:22','739','2023-03-16 20:13:47',10,0),('1','202',445,'DAILY SHIFT','2023-03-17','2023-03-17 06:51:56','2023-03-18 06:51:56','739',0.00,0.00,'739','2023-03-17 20:53:08','739','2023-03-17 20:53:39',10,0),('1','202',446,'DAILY SHIFT','2023-03-19','2023-03-19 07:15:53','2023-03-20 07:15:53','739',0.00,0.00,'739','2023-03-19 19:34:33','739','2023-03-19 19:35:17',10,0),('1','202',447,'DAILY SHIFT','2023-03-20','2023-03-20 07:16:13','2023-03-21 07:16:13','739',0.00,0.00,'739','2023-03-20 19:54:14','739','2023-03-20 19:54:36',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=448 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','202','1036','1',1,'3070','477',0.00,462.01,0.00,0.00,462.01,241709.52,0.00,0.00,0.00),('1','202','1036','2',2,'3070','477',462.01,1047.66,0.00,0.00,585.65,325012.12,0.00,0.00,0.00),('1','202','1036','3',3,'3070','477',1047.66,1445.53,0.00,0.00,397.87,224596.16,0.00,0.00,0.00),('1','202','1036','4',4,'3070','477',1445.53,2426.76,0.00,0.00,981.23,544411.16,0.00,0.00,0.00),('1','202','1036','5',5,'3070','477',2426.76,4717.84,0.00,0.00,2291.08,1253410.44,0.00,0.00,0.00),('1','202','1036','6',6,'3070','477',4717.84,5970.09,0.00,0.00,1252.25,689577.00,0.00,0.00,0.00),('1','202','1036','7',7,'3070','477',5970.09,9528.33,0.00,0.00,3558.24,1913503.32,0.00,0.00,0.00),('1','202','1036','8',8,'3070','477',9528.33,9963.89,0.00,0.00,435.56,278758.40,0.00,0.00,0.00),('1','202','1036','9',9,'3070','477',9963.89,10240.59,0.00,0.00,276.70,181100.00,0.00,0.00,0.00),('1','202','1036','10',10,'3070','477',10240.59,11314.13,0.00,0.00,1073.54,678023.20,0.00,0.00,0.00),('1','202','1036','11',11,'3070','477',11314.13,11921.71,0.00,0.00,607.58,391338.40,0.00,0.00,0.00),('1','202','1036','12',12,'3070','477',11921.71,13207.23,0.00,0.00,1285.52,787033.60,0.00,0.00,0.00),('1','202','1036','13',13,'3070','477',13207.23,13950.46,0.00,0.00,743.23,494699.04,0.00,0.00,0.00),('1','202','1036','14',14,'3070','477',13950.46,14343.00,0.00,0.00,392.54,261491.52,0.00,0.00,0.00),('1','202','1036','15',15,'3070','477',14343.00,15217.93,0.00,0.00,874.93,572915.84,0.00,0.00,0.00),('1','202','1036','16',16,'3070','477',15217.93,15783.79,0.00,0.00,565.86,377207.68,0.00,0.00,0.00),('1','202','1036','17',17,'3070','477',15783.79,16298.92,0.00,0.00,515.13,325683.48,0.00,0.00,0.00),('1','202','1036','18',18,'3070','477',16298.92,18029.00,0.00,0.00,1730.08,1101132.28,0.00,0.00,0.00),('1','202','1036','19',19,'3070','477',18029.00,20765.96,0.00,0.00,2736.96,1728069.40,0.00,0.00,0.00),('1','202','1036','20',20,'3070','477',20765.96,22844.64,0.00,0.00,2078.68,1307937.00,0.00,0.00,0.00),('1','202','1036','21',21,'3070','477',22844.64,24898.16,0.00,0.00,2053.52,1292253.08,0.00,0.00,0.00),('1','202','1036','22',22,'3070','477',24898.16,24898.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','23',23,'3070','477',24898.16,26998.60,0.00,0.00,2100.44,1306782.16,0.00,0.00,0.00),('1','202','1036','24',24,'3070','477',26998.60,28058.22,0.00,0.00,1059.62,668656.14,0.00,0.00,0.00),('1','202','1036','25',25,'3070','477',28058.22,28058.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','26',26,'3070','477',28058.22,29345.20,0.00,0.00,1286.98,805584.72,0.00,0.00,0.00),('1','202','1036','27',27,'3070','477',29345.20,30716.17,0.00,0.00,1370.97,873891.58,0.00,0.00,0.00),('1','202','1036','28',28,'3070','477',30716.17,31758.50,0.00,0.00,1042.33,692107.12,0.00,0.00,0.00),('1','202','1036','29',29,'3070','477',31758.50,32731.64,0.00,0.00,973.14,646164.96,0.00,0.00,0.00),('1','202','1036','30',30,'3070','477',32731.64,33407.58,0.00,0.00,675.94,448824.16,0.00,0.00,0.00),('1','202','1036','31',31,'3070','477',33407.58,33548.24,0.00,0.00,140.66,93398.24,0.00,0.00,0.00),('1','202','1036','32',32,'3070','477',33548.24,33548.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','33',33,'3070','477',33548.24,33730.38,0.00,0.00,182.14,120940.96,0.00,0.00,0.00),('1','202','1036','34',34,'3070','477',33730.38,34348.61,0.00,0.00,618.23,410504.72,0.00,0.00,0.00),('1','202','1036','35',35,'3070','477',34348.61,35047.47,0.00,0.00,698.86,464043.04,0.00,0.00,0.00),('1','202','1036','36',36,'3070','477',35047.47,37432.53,0.00,0.00,2385.06,1505799.84,0.00,0.00,0.00),('1','202','1036','37',37,'3070','477',37432.53,38557.05,0.00,0.00,1124.52,746681.28,0.00,0.00,0.00),('1','202','1036','38',38,'3070','477',38557.05,38838.57,0.00,0.00,281.52,186929.28,0.00,0.00,0.00),('1','202','1036','39',39,'3070','477',38838.57,38838.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','40',40,'3070','477',38838.57,39416.75,0.00,0.00,578.18,383911.52,0.00,0.00,0.00),('1','202','1036','41',41,'3070','477',39416.75,40271.42,0.00,0.00,854.67,567500.88,0.00,0.00,0.00),('1','202','1036','42',42,'3070','477',40271.42,41121.28,0.00,0.00,849.86,553846.04,0.00,0.00,0.00),('1','202','1036','43',43,'3070','477',41121.28,43312.75,0.00,0.00,2191.47,1353295.08,0.00,0.00,0.00),('1','202','1036','44',44,'3070','477',43312.75,43862.32,0.00,0.00,549.57,350009.04,0.00,0.00,0.00),('1','202','1036','45',45,'3070','477',43862.32,43862.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','46',46,'3070','477',43862.32,44729.91,0.00,0.00,867.59,539713.76,0.00,0.00,0.00),('1','202','1036','47',47,'3070','477',44729.91,46300.62,0.00,0.00,1570.71,990283.44,0.00,0.00,0.00),('1','202','1036','48',48,'3070','477',46300.62,47836.71,0.00,0.00,1536.09,970892.76,0.00,0.00,0.00),('1','202','1036','49',49,'3070','477',47836.71,49682.13,0.00,0.00,1845.42,1177013.88,0.00,0.00,0.00),('1','202','1036','50',50,'3070','477',49682.13,50950.26,0.00,0.00,1268.13,797158.32,0.00,0.00,0.00),('1','202','1036','51',51,'3070','477',50950.26,52151.14,0.00,0.00,1200.88,765902.32,0.00,0.00,0.00),('1','202','1036','52',52,'3070','477',52151.14,52895.94,0.00,0.00,744.80,489927.20,0.00,0.00,0.00),('1','202','1036','53',53,'3070','477',52895.94,54458.49,0.00,0.00,1562.55,984106.20,0.00,0.00,0.00),('1','202','1036','54',54,'3070','477',54458.49,56110.77,0.00,0.00,1652.28,1072858.92,0.00,0.00,0.00),('1','202','1036','55',55,'3070','477',56110.77,59292.04,0.00,0.00,3181.27,2010954.94,0.00,0.00,0.00),('1','202','1036','56',56,'3070','477',59292.04,63335.72,0.00,0.00,4043.68,2505884.14,0.00,0.00,0.00),('1','202','1036','57',57,'3070','477',63335.72,64278.35,0.00,0.00,942.63,610600.26,0.00,0.00,0.00),('1','202','1036','58',58,'3070','477',64278.35,65888.27,0.00,0.00,1609.92,1012439.40,0.00,0.00,0.00),('1','202','1036','59',59,'3070','477',65888.27,67015.64,0.00,0.00,1127.37,726771.90,0.00,0.00,0.00),('1','202','1036','60',60,'3070','477',67015.64,68092.99,0.00,0.00,1077.35,684290.24,0.00,0.00,0.00),('1','202','1036','61',61,'3070','477',68092.99,68382.44,0.00,0.00,289.45,182754.82,0.00,0.00,0.00),('1','202','1036','62',62,'3070','477',68382.44,68382.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','63',63,'3070','477',68382.44,70018.58,0.00,0.00,1636.14,1047856.26,0.00,0.00,0.00),('1','202','1036','64',64,'3070','477',70018.58,71246.41,0.00,0.00,1227.83,815279.12,0.00,0.00,0.00),('1','202','1036','65',65,'3070','477',71246.41,72144.90,0.00,0.00,898.49,596597.36,0.00,0.00,0.00),('1','202','1036','66',66,'3070','477',72144.90,72369.82,0.00,0.00,224.92,149346.88,0.00,0.00,0.00),('1','202','1036','67',67,'3070','477',72369.82,73372.80,0.00,0.00,1002.98,665978.72,0.00,0.00,0.00),('1','202','1036','68',68,'3070','477',73372.80,74029.63,0.00,0.00,656.83,436135.12,0.00,0.00,0.00),('1','202','1036','69',69,'3070','477',74029.63,74029.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','70',70,'3070','477',74029.63,74409.41,0.00,0.00,379.78,252173.92,0.00,0.00,0.00),('1','202','1036','71',71,'3070','477',74409.41,75599.00,0.00,0.00,1189.59,789887.76,0.00,0.00,0.00),('1','202','1036','72',72,'3070','477',75599.00,77556.44,0.00,0.00,1957.44,1262848.32,0.00,0.00,0.00),('1','202','1036','73',73,'3070','477',77556.44,78634.63,0.00,0.00,1078.19,733169.20,0.00,0.00,0.00),('1','202','1036','74',74,'3070','477',78634.63,79307.94,0.00,0.00,673.31,457850.80,0.00,0.00,0.00),('1','202','1036','75',75,'3070','477',79307.94,79307.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','76',76,'3070','477',79307.94,79307.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','77',77,'3070','477',79307.94,79677.38,0.00,0.00,369.44,251219.20,0.00,0.00,0.00),('1','202','1036','78',78,'3070','477',79677.38,80607.64,0.00,0.00,930.26,632576.80,0.00,0.00,0.00),('1','202','1036','79',79,'3070','477',80607.64,82207.85,0.00,0.00,1600.21,1088142.80,0.00,0.00,0.00),('1','202','1036','80',80,'3070','477',82207.85,83497.79,0.00,0.00,1289.94,877159.20,0.00,0.00,0.00),('1','202','1036','81',81,'3070','477',83497.79,84248.75,0.00,0.00,750.96,510652.80,0.00,0.00,0.00),('1','202','1036','82',82,'3070','477',84248.75,84604.49,0.00,0.00,355.74,241903.20,0.00,0.00,0.00),('1','202','1036','83',83,'3070','477',84604.49,87038.86,0.00,0.00,2434.37,1546331.28,0.00,0.00,0.00),('1','202','1036','84',84,'3070','477',87038.86,87743.56,0.00,0.00,704.70,503139.00,0.00,0.00,0.00),('1','202','1036','85',85,'3070','477',87743.56,89655.73,0.00,0.00,1912.17,1323528.40,0.00,0.00,0.00),('1','202','1036','86',86,'3070','477',89655.73,92057.85,0.00,0.00,2402.12,1655652.40,0.00,0.00,0.00),('1','202','1036','87',87,'3070','477',92057.85,94901.67,0.00,0.00,2843.82,1956377.50,0.00,0.00,0.00),('1','202','1036','88',88,'3070','477',94901.67,94901.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','89',89,'3070','477',94901.67,98663.96,0.00,0.00,3762.29,2607454.80,0.00,0.00,0.00),('1','202','1036','90',90,'3070','477',98663.96,100239.94,0.00,0.00,1575.98,1083580.75,0.00,0.00,0.00),('1','202','1036','91',91,'3070','477',100239.94,100239.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','92',92,'3070','477',100239.94,102136.66,0.00,0.00,1896.72,1316850.60,0.00,0.00,0.00),('1','202','1036','93',93,'3070','477',102136.66,104535.02,0.00,0.00,2398.36,1750183.60,0.00,0.00,0.00),('1','202','1036','94',94,'3070','477',104535.02,105377.04,0.00,0.00,842.02,611944.40,0.00,0.00,0.00),('1','202','1036','95',95,'3070','477',105377.04,105377.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','96',96,'3070','477',105377.04,107495.90,0.00,0.00,2118.86,1540641.20,0.00,0.00,0.00),('1','202','1036','97',97,'3070','477',107495.90,112161.26,0.00,0.00,4665.36,3363543.60,0.00,0.00,0.00),('1','202','1036','98',98,'3070','477',112161.26,115787.98,0.00,0.00,3626.72,2651069.00,0.00,0.00,0.00),('1','202','1036','99',99,'3070','477',115787.98,116837.60,0.00,0.00,1049.62,797711.20,0.00,0.00,0.00),('1','202','1036','100',100,'3070','477',116837.60,117870.31,0.00,0.00,1032.71,784859.60,0.00,0.00,0.00),('1','202','1036','101',101,'3070','477',117870.31,118918.90,0.00,0.00,1048.59,796928.40,0.00,0.00,0.00),('1','202','1036','102',102,'3070','477',118918.90,121100.22,0.00,0.00,2181.32,1591803.20,0.00,0.00,0.00),('1','202','1036','103',103,'3070','477',121100.22,122180.29,0.00,0.00,1080.07,820853.20,0.00,0.00,0.00),('1','202','1036','104',104,'3070','477',122180.29,124080.51,0.00,0.00,1900.22,1444167.20,0.00,0.00,0.00),('1','202','1036','105',105,'3070','477',124080.51,125121.28,0.00,0.00,1040.77,790985.20,0.00,0.00,0.00),('1','202','1036','106',106,'3070','477',125121.28,126646.38,0.00,0.00,1525.10,1159076.00,0.00,0.00,0.00),('1','202','1036','107',107,'3070','477',126646.38,127999.06,0.00,0.00,1352.68,1028036.80,0.00,0.00,0.00),('1','202','1036','108',108,'3070','477',127999.06,129125.50,0.00,0.00,1126.44,856094.40,0.00,0.00,0.00),('1','202','1036','109',109,'3070','477',129125.50,129415.41,0.00,0.00,289.91,220331.60,0.00,0.00,0.00),('1','202','1036','110',110,'3070','477',129415.41,129415.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','111',111,'3070','477',129415.41,129932.11,0.00,0.00,516.70,392692.00,0.00,0.00,0.00),('1','202','1036','112',112,'3070','477',129932.11,130862.28,0.00,0.00,930.17,706929.20,0.00,0.00,0.00),('1','202','1036','113',113,'3070','477',130862.28,132543.43,0.00,0.00,1681.15,1277674.00,0.00,0.00,0.00),('1','202','1036','114',114,'3070','477',132543.43,134252.24,0.00,0.00,1708.81,1298695.60,0.00,0.00,0.00),('1','202','1036','115',115,'3070','477',134252.24,134252.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','116',116,'3070','477',134252.24,135300.70,0.00,0.00,1048.46,796829.60,0.00,0.00,0.00),('1','202','1036','117',117,'3070','477',135300.70,135998.65,0.00,0.00,697.95,530442.00,0.00,0.00,0.00),('1','202','1036','118',118,'3070','477',135998.65,136894.09,0.00,0.00,895.44,680534.40,0.00,0.00,0.00),('1','202','1036','119',119,'3070','477',136894.09,137902.71,0.00,0.00,1008.62,766551.20,0.00,0.00,0.00),('1','202','1036','120',120,'3070','477',137902.71,139183.21,0.00,0.00,1280.50,973180.00,0.00,0.00,0.00),('1','202','1036','121',121,'3070','477',139183.21,140189.15,0.00,0.00,1005.94,764514.40,0.00,0.00,0.00),('1','202','1036','122',122,'3070','477',140189.15,140189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','123',123,'3070','477',140189.15,140322.80,0.00,0.00,133.65,101574.00,0.00,0.00,0.00),('1','202','1036','124',124,'3070','477',140322.80,142952.20,0.00,0.00,2629.40,1945544.00,0.00,0.00,0.00),('1','202','1036','125',125,'3070','477',142952.20,144019.82,0.00,0.00,1067.62,811391.20,0.00,0.00,0.00),('1','202','1036','126',126,'3070','477',144019.82,145218.84,0.00,0.00,1199.02,911255.20,0.00,0.00,0.00),('1','202','1036','127',127,'3070','477',145218.84,145344.91,0.00,0.00,126.07,95813.20,0.00,0.00,0.00),('1','202','1036','128',128,'3070','477',145344.91,146355.93,0.00,0.00,1011.02,768375.20,0.00,0.00,0.00),('1','202','1036','129',129,'3070','477',146355.93,147636.30,0.00,0.00,1280.37,973081.20,0.00,0.00,0.00),('1','202','1036','130',130,'3070','477',147636.30,149040.87,0.00,0.00,1404.57,1067473.20,0.00,0.00,0.00),('1','202','1036','131',131,'3070','477',149040.87,150722.97,0.00,0.00,1682.10,1264796.00,0.00,0.00,0.00),('1','202','1036','132',132,'3070','477',150722.97,150722.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','133',133,'3070','477',150722.97,151248.18,0.00,0.00,525.21,392599.60,0.00,0.00,0.00),('1','202','1036','134',134,'3070','477',151248.18,155092.23,0.00,0.00,3844.05,2844718.00,0.00,0.00,0.00),('1','202','1036','135',135,'3070','477',155092.23,155995.32,0.00,0.00,903.09,669668.40,0.00,0.00,0.00),('1','202','1036','136',136,'3070','477',155995.32,155995.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','137',137,'3070','477',155995.32,158588.29,0.00,0.00,2592.97,1902052.40,0.00,0.00,0.00),('1','202','1036','138',138,'3070','477',158588.29,160970.42,0.00,0.00,2382.13,1766358.80,0.00,0.00,0.00),('1','202','1036','139',139,'3070','477',160970.42,162928.41,0.00,0.00,1957.99,1456328.00,0.00,0.00,0.00),('1','202','1036','140',140,'3070','477',162928.41,164744.87,0.00,0.00,1816.46,1359029.60,0.00,0.00,0.00),('1','202','1036','141',141,'3070','477',164744.87,166691.08,0.00,0.00,1946.21,1465015.20,0.00,0.00,0.00),('1','202','1036','142',142,'3070','477',166691.08,169361.69,0.00,0.00,2670.61,1983787.60,0.00,0.00,0.00),('1','202','1036','143',143,'3070','477',169361.69,171318.61,0.00,0.00,1956.92,1458339.20,0.00,0.00,0.00),('1','202','1036','144',144,'3070','477',171318.61,173878.68,0.00,0.00,2560.07,1896053.20,0.00,0.00,0.00),('1','202','1036','145',145,'3070','477',173878.68,174981.39,0.00,0.00,1102.71,838059.60,0.00,0.00,0.00),('1','202','1036','146',146,'3070','477',174981.39,175877.71,0.00,0.00,896.32,681203.20,0.00,0.00,0.00),('1','202','1036','147',147,'3070','477',175877.71,176831.12,0.00,0.00,953.41,724591.60,0.00,0.00,0.00),('1','202','1036','148',148,'3070','477',176831.12,177730.53,0.00,0.00,899.41,683551.60,0.00,0.00,0.00),('1','202','1036','149',149,'3070','477',177730.53,179210.32,0.00,0.00,1479.79,1124640.40,0.00,0.00,0.00),('1','202','1036','150',150,'3070','477',179210.32,180420.36,0.00,0.00,1210.04,919630.40,0.00,0.00,0.00),('1','202','1036','151',151,'3070','477',180420.36,180644.13,0.00,0.00,223.77,168745.20,0.00,0.00,0.00),('1','202','1036','152',152,'3070','477',180644.13,180644.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','153',153,'3070','477',180644.13,181669.56,0.00,0.00,1025.43,775926.80,0.00,0.00,0.00),('1','202','1036','154',154,'3070','477',181669.56,185026.94,0.00,0.00,3357.38,2446008.80,0.00,0.00,0.00),('1','202','1036','155',155,'3070','477',185026.94,186274.67,0.00,0.00,1247.73,937666.80,0.00,0.00,0.00),('1','202','1036','156',156,'3070','477',186274.67,187506.63,0.00,0.00,1231.96,927070.72,0.00,0.00,0.00),('1','202','1036','157',157,'3070','477',187506.63,189045.72,0.00,0.00,1539.09,1151516.40,0.00,0.00,0.00),('1','202','1036','158',158,'3070','477',189045.72,191448.88,0.00,0.00,2403.16,1742087.04,0.00,0.00,0.00),('1','202','1036','159',159,'3070','477',191448.88,193929.38,0.00,0.00,2480.50,1805214.00,0.00,0.00,0.00),('1','202','1036','160',160,'3070','477',193929.38,196046.05,0.00,0.00,2116.67,1519439.98,0.00,0.00,0.00),('1','202','1036','161',161,'3070','477',196046.05,198326.69,0.00,0.00,2280.64,1642627.64,0.00,0.00,0.00),('1','202','1036','162',162,'3070','477',198326.69,200497.03,0.00,0.00,2170.34,1572781.61,0.00,0.00,0.00),('1','202','1036','163',163,'3070','477',200497.03,200547.47,0.00,0.00,50.44,37527.36,0.00,0.00,0.00),('1','202','1036','164',164,'3070','477',200547.47,200618.10,0.00,0.00,70.63,52548.72,0.00,0.00,0.00),('1','202','1036','165',165,'3070','477',200618.10,200646.12,0.00,0.00,28.02,20846.88,0.00,0.00,0.00),('1','202','1036','166',166,'3070','477',200646.12,202726.66,0.00,0.00,2080.54,1497314.56,0.00,0.00,0.00),('1','202','1036','167',167,'3070','477',202726.66,204097.96,0.00,0.00,1371.30,1002901.20,0.00,0.00,0.00),('1','202','1036','168',168,'3070','477',204097.96,204788.36,0.00,0.00,690.40,505768.60,0.00,0.00,0.00),('1','202','1036','169',169,'3070','477',204788.36,207805.13,0.00,0.00,3016.77,2155175.85,0.00,0.00,0.00),('1','202','1036','170',170,'3070','477',207805.13,207805.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','171',171,'3070','477',207805.13,209850.38,0.00,0.00,2045.25,1476782.00,0.00,0.00,0.00),('1','202','1036','172',172,'3070','477',209850.38,209850.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','173',173,'3070','477',209850.38,210985.56,0.00,0.00,1135.18,824361.42,0.00,0.00,0.00),('1','202','1036','174',174,'3070','477',210985.56,213506.28,0.00,0.00,2520.72,1827268.28,0.00,0.00,0.00),('1','202','1036','175',175,'3070','477',213506.28,216430.45,0.00,0.00,2924.17,2110363.48,0.00,0.00,0.00),('1','202','1036','176',176,'3070','477',216430.45,218838.83,0.00,0.00,2408.38,1738130.72,0.00,0.00,0.00),('1','202','1036','177',177,'3070','477',218838.83,221126.65,0.00,0.00,2287.82,1661220.63,0.00,0.00,0.00),('1','202','1036','178',178,'3070','477',221126.65,224030.46,0.00,0.00,2903.81,2081324.14,0.00,0.00,0.00),('1','202','1036','179',179,'3070','477',224030.46,228085.65,0.00,0.00,4055.19,2907355.26,0.00,0.00,0.00),('1','202','1036','180',180,'3070','477',228085.65,231020.30,0.00,0.00,2934.65,2123452.60,0.00,0.00,0.00),('1','202','1036','181',181,'3070','477',231020.30,232302.93,0.00,0.00,1282.63,971408.96,0.00,0.00,0.00),('1','202','1036','182',182,'3070','477',232302.93,233630.37,0.00,0.00,1327.44,1008854.40,0.00,0.00,0.00),('1','202','1036','183',183,'3070','477',233630.37,234559.46,0.00,0.00,929.09,706108.40,0.00,0.00,0.00),('1','202','1036','184',184,'3070','477',234559.46,234559.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','185',185,'3070','477',234559.46,235895.11,0.00,0.00,1335.65,1015134.00,0.00,0.00,0.00),('1','202','1036','186',186,'3070','477',235895.11,237253.45,0.00,0.00,1358.34,1032338.40,0.00,0.00,0.00),('1','202','1036','187',187,'3070','477',237253.45,238883.16,0.00,0.00,1629.71,1238579.60,0.00,0.00,0.00),('1','202','1036','188',188,'3070','477',238883.16,239952.46,0.00,0.00,1069.30,812668.00,0.00,0.00,0.00),('1','202','1036','189',189,'3070','477',239952.46,241528.36,0.00,0.00,1575.90,1197684.00,0.00,0.00,0.00),('1','202','1036','190',190,'3070','477',241528.36,243393.34,0.00,0.00,1864.98,1375713.12,0.00,0.00,0.00),('1','202','1036','191',191,'3070','477',243393.34,245181.14,0.00,0.00,1787.80,1271364.74,0.00,0.00,0.00),('1','202','1036','192',192,'3070','477',245181.14,245181.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','193',193,'3070','477',245181.14,245887.89,0.00,0.00,706.75,521067.10,0.00,0.00,0.00),('1','202','1036','194',194,'3070','477',245887.89,247941.60,0.00,0.00,2053.71,1501610.24,0.00,0.00,0.00),('1','202','1036','195',195,'3070','477',247941.60,249861.16,0.00,0.00,1919.56,1397042.64,0.00,0.00,0.00),('1','202','1036','196',196,'3070','477',249861.16,249977.80,0.00,0.00,116.64,86780.16,0.00,0.00,0.00),('1','202','1036','197',197,'3070','477',249977.80,249977.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','198',198,'3070','477',249977.80,252796.37,0.00,0.00,2818.57,2049178.08,0.00,0.00,0.00),('1','202','1036','199',199,'3070','477',252796.37,254838.26,0.00,0.00,2041.89,1490941.06,0.00,0.00,0.00),('1','202','1036','200',200,'3070','477',254838.26,256779.02,0.00,0.00,1940.76,1430019.44,0.00,0.00,0.00),('1','202','1036','201',201,'3070','477',256779.02,257916.08,0.00,0.00,1137.06,819112.64,0.00,0.00,0.00),('1','202','1036','202',202,'3070','477',257916.08,259242.56,0.00,0.00,1326.48,964782.24,0.00,0.00,0.00),('1','202','1036','203',203,'3070','477',259242.56,261552.20,0.00,0.00,2309.64,1670978.32,0.00,0.00,0.00),('1','202','1036','204',204,'3070','477',261552.20,264189.11,0.00,0.00,2636.91,1897153.18,0.00,0.00,0.00),('1','202','1036','205',205,'3070','477',264189.11,266739.23,0.00,0.00,2550.12,1841380.24,0.00,0.00,0.00),('1','202','1036','206',206,'3070','477',266739.23,269975.08,0.00,0.00,3235.85,2330889.30,0.00,0.00,0.00),('1','202','1036','207',207,'3070','477',269975.08,272587.96,0.00,0.00,2612.88,1893217.44,0.00,0.00,0.00),('1','202','1036','208',208,'3070','477',272587.96,274640.85,0.00,0.00,2052.89,1478215.22,0.00,0.00,0.00),('1','202','1036','209',209,'3070','477',274640.85,274640.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','210',210,'3070','477',274640.85,278440.83,0.00,0.00,3799.98,2725377.24,0.00,0.00,0.00),('1','202','1036','211',211,'3070','477',278440.83,280298.32,0.00,0.00,1857.49,1339003.62,0.00,0.00,0.00),('1','202','1036','212',212,'3070','477',280298.32,280298.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','213',213,'3070','477',280298.32,281182.91,0.00,0.00,884.59,643451.42,0.00,0.00,0.00),('1','202','1036','214',214,'3070','477',281182.91,284368.90,0.00,0.00,3185.99,2302636.62,0.00,0.00,0.00),('1','202','1036','215',215,'3070','477',284368.90,285896.21,0.00,0.00,1527.31,1099218.14,0.00,0.00,0.00),('1','202','1036','216',216,'3070','477',285896.21,285896.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','217',217,'3070','477',285896.21,286734.66,0.00,0.00,838.45,601080.10,0.00,0.00,0.00),('1','202','1036','218',218,'3070','477',286734.66,290865.97,0.00,0.00,4131.31,2978821.98,0.00,0.00,0.00),('1','202','1036','219',219,'3070','477',290865.97,290865.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','220',220,'3070','477',290865.97,293848.39,0.00,0.00,2982.42,2161537.96,0.00,0.00,0.00),('1','202','1036','221',221,'3070','477',293848.39,295975.39,0.00,0.00,2127.00,1527351.00,0.00,0.00,0.00),('1','202','1036','222',222,'3070','477',295975.39,295975.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','223',223,'3070','477',295975.39,296533.81,0.00,0.00,558.42,406353.96,0.00,0.00,0.00),('1','202','1036','224',224,'3070','477',296533.81,299762.78,0.00,0.00,3228.97,2308676.86,0.00,0.00,0.00),('1','202','1036','225',225,'3070','477',299762.78,301512.37,0.00,0.00,1749.59,1256484.42,0.00,0.00,0.00),('1','202','1036','226',226,'3070','477',301512.37,301512.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','227',227,'3070','477',301512.37,303037.70,0.00,0.00,1525.33,1094419.54,0.00,0.00,0.00),('1','202','1036','228',228,'3070','477',303037.70,306076.43,0.00,0.00,3038.73,2185506.74,0.00,0.00,0.00),('1','202','1036','229',229,'3070','477',306076.43,306659.18,0.00,0.00,582.75,430069.50,0.00,0.00,0.00),('1','202','1036','230',230,'3070','477',306659.18,306659.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','231',231,'3070','477',306659.18,308439.50,0.00,0.00,1780.32,1313938.16,0.00,0.00,0.00),('1','202','1036','232',232,'3070','477',308439.50,309290.97,0.00,0.00,851.47,629146.86,0.00,0.00,0.00),('1','202','1036','233',233,'3070','477',309290.97,309290.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','234',234,'3070','477',309290.97,310159.27,0.00,0.00,868.30,640805.40,0.00,0.00,0.00),('1','202','1036','235',235,'3070','477',310159.27,311437.52,0.00,0.00,1278.25,943348.50,0.00,0.00,0.00),('1','202','1036','236',236,'3070','477',311437.52,312577.54,0.00,0.00,1140.02,841334.76,0.00,0.00,0.00),('1','202','1036','237',237,'3070','477',312577.54,314029.39,0.00,0.00,1451.85,1071465.30,0.00,0.00,0.00),('1','202','1036','238',238,'3070','477',314029.39,314063.17,0.00,0.00,33.78,24862.08,0.00,0.00,0.00),('1','202','1036','239',239,'3070','477',314063.17,314063.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','240',240,'3070','477',314063.17,315083.22,0.00,0.00,1020.05,752320.80,0.00,0.00,0.00),('1','202','1036','241',241,'3070','477',315083.22,316622.67,0.00,0.00,1539.45,1133035.20,0.00,0.00,0.00),('1','202','1036','242',242,'3070','477',316622.67,318038.49,0.00,0.00,1415.82,1042043.52,0.00,0.00,0.00),('1','202','1036','243',243,'3070','477',318038.49,318827.77,0.00,0.00,789.28,580910.08,0.00,0.00,0.00),('1','202','1036','244',244,'3070','477',318827.77,318877.16,0.00,0.00,49.39,36351.04,0.00,0.00,0.00),('1','202','1036','245',245,'3070','477',318877.16,318877.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','246',246,'3070','477',318877.16,320234.90,0.00,0.00,1357.74,999296.64,0.00,0.00,0.00),('1','202','1036','247',247,'3070','477',320234.90,321723.99,0.00,0.00,1489.09,1095970.24,0.00,0.00,0.00),('1','202','1036','248',248,'3070','477',321723.99,322853.60,0.00,0.00,1129.61,831392.96,0.00,0.00,0.00),('1','202','1036','249',249,'3070','477',322853.60,324294.26,0.00,0.00,1440.66,1060589.76,0.00,0.00,0.00),('1','202','1036','250',250,'3070','477',324294.26,324358.14,0.00,0.00,63.88,47015.68,0.00,0.00,0.00),('1','202','1036','251',251,'3070','477',324358.14,324358.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','252',252,'3070','477',324358.14,325402.21,0.00,0.00,1044.07,768435.52,0.00,0.00,0.00),('1','202','1036','253',253,'3070','477',325402.21,326945.64,0.00,0.00,1543.43,1135964.48,0.00,0.00,0.00),('1','202','1036','254',254,'3070','477',326945.64,329590.83,0.00,0.00,2645.19,1891419.84,0.00,0.00,0.00),('1','202','1036','255',255,'3070','477',329590.83,329807.53,0.00,0.00,216.70,156215.20,0.00,0.00,0.00),('1','202','1036','256',256,'3070','477',329807.53,330772.93,0.00,0.00,965.40,704774.40,0.00,0.00,0.00),('1','202','1036','257',257,'3070','477',330772.93,332666.66,0.00,0.00,1893.73,1375245.28,0.00,0.00,0.00),('1','202','1036','258',258,'3070','477',332666.66,334921.42,0.00,0.00,2254.76,1651079.36,0.00,0.00,0.00),('1','202','1036','259',259,'3070','477',334921.42,337298.27,0.00,0.00,2376.85,1722073.60,0.00,0.00,0.00),('1','202','1036','260',260,'3070','477',337298.27,339271.66,0.00,0.00,1973.39,1443451.40,0.00,0.00,0.00),('1','202','1036','261',261,'3070','477',339271.66,341152.78,0.00,0.00,1881.12,1384504.32,0.00,0.00,0.00),('1','202','1036','262',262,'3070','477',341152.78,341805.85,0.00,0.00,653.07,480659.52,0.00,0.00,0.00),('1','202','1036','263',263,'3070','477',341805.85,341805.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','264',264,'3070','477',341805.85,342335.40,0.00,0.00,529.55,389748.80,0.00,0.00,0.00),('1','202','1036','265',265,'3070','477',342335.40,344022.69,0.00,0.00,1687.29,1241845.44,0.00,0.00,0.00),('1','202','1036','266',266,'3070','477',344022.69,344601.85,0.00,0.00,579.16,426261.76,0.00,0.00,0.00),('1','202','1036','267',267,'3070','477',344601.85,344822.68,0.00,0.00,220.83,168714.12,0.00,0.00,0.00),('1','202','1036','268',268,'3070','477',344822.68,347727.61,0.00,0.00,2904.93,2219366.52,0.00,0.00,0.00),('1','202','1036','269',269,'3070','477',347727.61,348544.13,0.00,0.00,816.52,623821.28,0.00,0.00,0.00),('1','202','1036','270',270,'3070','477',348544.13,348544.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','271',271,'3070','477',348544.13,348860.79,0.00,0.00,316.66,241928.24,0.00,0.00,0.00),('1','202','1036','272',272,'3070','477',348860.79,350899.35,0.00,0.00,2038.56,1524842.88,0.00,0.00,0.00),('1','202','1036','273',273,'3070','477',350899.35,352824.12,0.00,0.00,1924.77,1439727.96,0.00,0.00,0.00),('1','202','1036','274',274,'3070','477',352824.12,352854.94,0.00,0.00,30.82,23053.36,0.00,0.00,0.00),('1','202','1036','275',275,'3070','477',352854.94,352854.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','276',276,'3070','477',352854.94,353656.75,0.00,0.00,801.81,599753.88,0.00,0.00,0.00),('1','202','1036','277',277,'3070','477',353656.75,356003.08,0.00,0.00,2346.33,1755054.84,0.00,0.00,0.00),('1','202','1036','278',278,'3070','477',356003.08,357685.36,0.00,0.00,1682.28,1258345.44,0.00,0.00,0.00),('1','202','1036','279',279,'3070','477',357685.36,358207.95,0.00,0.00,522.59,390897.32,0.00,0.00,0.00),('1','202','1036','280',280,'3070','477',358207.95,358207.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','281',281,'3070','477',358207.95,358988.45,0.00,0.00,780.50,583814.00,0.00,0.00,0.00),('1','202','1036','282',282,'3070','477',358988.45,360153.29,0.00,0.00,1164.84,871300.32,0.00,0.00,0.00),('1','202','1036','283',283,'3070','477',360153.29,361240.91,0.00,0.00,1087.62,826591.20,0.00,0.00,0.00),('1','202','1036','284',284,'3070','477',361240.91,362451.48,0.00,0.00,1210.57,920033.20,0.00,0.00,0.00),('1','202','1036','285',285,'3070','477',362451.48,363456.10,0.00,0.00,1004.62,763511.20,0.00,0.00,0.00),('1','202','1036','286',286,'3070','477',363456.10,363456.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','287',287,'3070','477',363456.10,364736.47,0.00,0.00,1280.37,973081.20,0.00,0.00,0.00),('1','202','1036','288',288,'3070','477',364736.47,366333.73,0.00,0.00,1597.26,1213917.60,0.00,0.00,0.00),('1','202','1036','289',289,'3070','477',366333.73,367689.28,0.00,0.00,1355.55,1030218.00,0.00,0.00,0.00),('1','202','1036','290',290,'3070','477',367689.28,368667.30,0.00,0.00,978.02,743295.20,0.00,0.00,0.00),('1','202','1036','291',291,'3070','477',368667.30,368720.93,0.00,0.00,53.63,42904.00,0.00,0.00,0.00),('1','202','1036','292',292,'3070','477',368720.93,368720.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','293',293,'3070','477',368720.93,369748.35,0.00,0.00,1027.42,821936.00,0.00,0.00,0.00),('1','202','1036','294',294,'3070','477',369748.35,371117.14,0.00,0.00,1368.79,1095032.00,0.00,0.00,0.00),('1','202','1036','295',295,'3070','477',371117.14,372460.76,0.00,0.00,1343.62,1074896.00,0.00,0.00,0.00),('1','202','1036','296',296,'3070','477',372460.76,373904.36,0.00,0.00,1443.60,1097136.00,0.00,0.00,0.00),('1','202','1036','297',297,'3070','477',373904.36,373904.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','298',298,'3070','477',373904.36,375447.65,0.00,0.00,1543.29,1172900.40,0.00,0.00,0.00),('1','202','1036','299',299,'3070','477',375447.65,377091.05,0.00,0.00,1643.40,1248984.00,0.00,0.00,0.00),('1','202','1036','300',300,'3070','477',377091.05,378743.54,0.00,0.00,1652.49,1255892.40,0.00,0.00,0.00),('1','202','1036','301',301,'3070','477',378743.54,379114.36,0.00,0.00,370.82,281823.20,0.00,0.00,0.00),('1','202','1036','302',302,'3070','477',379114.36,380879.64,0.00,0.00,1765.28,1341612.80,0.00,0.00,0.00),('1','202','1036','303',303,'3070','477',380879.64,382938.42,0.00,0.00,2058.78,1564672.80,0.00,0.00,0.00),('1','202','1036','304',304,'3070','477',382938.42,383097.79,0.00,0.00,159.37,121121.20,0.00,0.00,0.00),('1','202','1036','305',305,'3070','477',383097.79,383097.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','306',306,'3070','477',383097.79,383746.34,0.00,0.00,648.55,492898.00,0.00,0.00,0.00),('1','202','1036','307',307,'3070','477',383746.34,384901.36,0.00,0.00,1155.02,877815.20,0.00,0.00,0.00),('1','202','1036','308',308,'3070','477',384901.36,386252.71,0.00,0.00,1351.35,1027026.00,0.00,0.00,0.00),('1','202','1036','309',309,'3070','477',386252.71,387262.64,0.00,0.00,1009.93,767546.80,0.00,0.00,0.00),('1','202','1036','310',310,'3070','477',387262.64,388366.33,0.00,0.00,1103.69,838804.40,0.00,0.00,0.00),('1','202','1036','311',311,'3070','477',388366.33,388869.38,0.00,0.00,503.05,382318.00,0.00,0.00,0.00),('1','202','1036','312',312,'3070','477',388869.38,388869.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','313',313,'3070','477',388869.38,389526.15,0.00,0.00,656.77,499145.20,0.00,0.00,0.00),('1','202','1036','314',314,'3070','477',389526.15,390745.86,0.00,0.00,1219.71,926979.60,0.00,0.00,0.00),('1','202','1036','315',315,'3070','477',390745.86,391876.99,0.00,0.00,1131.13,859658.80,0.00,0.00,0.00),('1','202','1036','316',316,'3070','477',391876.99,393094.72,0.00,0.00,1217.73,925474.80,0.00,0.00,0.00),('1','202','1036','317',317,'3070','477',393094.72,393959.38,0.00,0.00,864.66,657141.60,0.00,0.00,0.00),('1','202','1036','318',318,'3070','477',393959.38,393959.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','319',319,'3070','477',393959.38,394287.40,0.00,0.00,328.02,249295.20,0.00,0.00,0.00),('1','202','1036','320',320,'3070','477',394287.40,395426.89,0.00,0.00,1139.49,866012.40,0.00,0.00,0.00),('1','202','1036','321',321,'3070','477',395426.89,396433.68,0.00,0.00,1006.79,765160.40,0.00,0.00,0.00),('1','202','1036','322',322,'3070','477',396433.68,398966.15,0.00,0.00,2532.47,1889458.40,0.00,0.00,0.00),('1','202','1036','323',323,'3070','477',398966.15,399095.10,0.00,0.00,128.95,98002.00,0.00,0.00,0.00),('1','202','1036','324',324,'3070','477',399095.10,399095.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','325',325,'3070','477',399095.10,400380.36,0.00,0.00,1285.26,969372.60,0.00,0.00,0.00),('1','202','1036','326',326,'3070','477',400380.36,401660.90,0.00,0.00,1280.54,968710.40,0.00,0.00,0.00),('1','202','1036','327',327,'3070','477',401660.90,404256.41,0.00,0.00,2595.51,1910153.70,0.00,0.00,0.00),('1','202','1036','328',328,'3070','477',404256.41,405571.96,0.00,0.00,1315.55,999818.00,0.00,0.00,0.00),('1','202','1036','329',329,'3070','477',405571.96,407041.20,0.00,0.00,1469.24,1103797.40,0.00,0.00,0.00),('1','202','1036','330',330,'3070','477',407041.20,408444.45,0.00,0.00,1403.25,1058870.00,0.00,0.00,0.00),('1','202','1036','331',331,'3070','477',408444.45,410438.57,0.00,0.00,1994.12,1484371.20,0.00,0.00,0.00),('1','202','1036','332',332,'3070','477',410438.57,412618.93,0.00,0.00,2180.36,1626080.10,0.00,0.00,0.00),('1','202','1036','333',333,'3070','477',412618.93,414563.04,0.00,0.00,1944.11,1448623.60,0.00,0.00,0.00),('1','202','1036','334',334,'3070','477',414563.04,416657.51,0.00,0.00,2094.47,1545147.20,0.00,0.00,0.00),('1','202','1036','335',335,'3070','477',416657.51,418352.23,0.00,0.00,1694.72,1276558.80,0.00,0.00,0.00),('1','202','1036','336',336,'3070','477',418352.23,420438.36,0.00,0.00,2086.13,1537976.00,0.00,0.00,0.00),('1','202','1036','337',337,'3070','477',420438.36,422463.54,0.00,0.00,2025.18,1495733.40,0.00,0.00,0.00),('1','202','1036','338',338,'3070','477',422463.54,423365.22,0.00,0.00,901.68,669580.20,0.00,0.00,0.00),('1','202','1036','339',339,'3070','477',423365.22,423365.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','340',340,'3070','477',423365.22,424262.65,0.00,0.00,897.43,660626.80,0.00,0.00,0.00),('1','202','1036','341',341,'3070','477',424262.65,426780.32,0.00,0.00,2517.67,1857638.80,0.00,0.00,0.00),('1','202','1036','342',342,'3070','477',426780.32,429223.73,0.00,0.00,2443.41,1799281.80,0.00,0.00,0.00),('1','202','1036','343',343,'3070','477',429223.73,431911.00,0.00,0.00,2687.27,1965242.60,0.00,0.00,0.00),('1','202','1036','344',344,'3070','477',431911.00,433132.50,0.00,0.00,1221.50,919340.00,0.00,0.00,0.00),('1','202','1036','345',345,'3070','477',433132.50,434966.10,0.00,0.00,1833.60,1347936.00,0.00,0.00,0.00),('1','202','1036','346',346,'3070','477',434966.10,436437.96,0.00,0.00,1471.86,1073028.96,0.00,0.00,0.00),('1','202','1036','347',347,'3070','477',436437.96,438619.69,0.00,0.00,2181.73,1583505.64,0.00,0.00,0.00),('1','202','1036','348',348,'3070','477',438619.69,440931.92,0.00,0.00,2312.23,1684971.28,0.00,0.00,0.00),('1','202','1036','349',349,'3070','477',440931.92,442481.80,0.00,0.00,1549.88,1132368.32,0.00,0.00,0.00),('1','202','1036','350',350,'3070','477',442481.80,445357.39,0.00,0.00,2875.59,2062002.24,0.00,0.00,0.00),('1','202','1036','351',351,'3070','477',445357.39,446885.28,0.00,0.00,1527.89,1115697.32,0.00,0.00,0.00),('1','202','1036','352',352,'3070','477',446885.28,447869.49,0.00,0.00,984.21,711778.56,0.00,0.00,0.00),('1','202','1036','353',353,'3070','477',447869.49,447869.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','354',354,'3070','477',447869.49,448252.61,0.00,0.00,383.12,281976.32,0.00,0.00,0.00),('1','202','1036','355',355,'3070','477',448252.61,450209.56,0.00,0.00,1956.95,1411333.04,0.00,0.00,0.00),('1','202','1036','356',356,'3070','477',450209.56,452073.62,0.00,0.00,1864.06,1364028.16,0.00,0.00,0.00),('1','202','1036','357',357,'3070','477',452073.62,453833.47,0.00,0.00,1759.85,1289489.60,0.00,0.00,0.00),('1','202','1036','358',358,'3070','477',453833.47,455695.65,0.00,0.00,1862.18,1355008.16,0.00,0.00,0.00),('1','202','1036','359',359,'3070','477',455695.65,456812.73,0.00,0.00,1117.08,812261.52,0.00,0.00,0.00),('1','202','1036','360',360,'3070','477',456812.73,457279.02,0.00,0.00,466.29,343189.44,0.00,0.00,0.00),('1','202','1036','361',361,'3070','477',457279.02,459231.52,0.00,0.00,1952.50,1437040.00,0.00,0.00,0.00),('1','202','1036','362',362,'3070','477',459231.52,461326.04,0.00,0.00,2094.52,1541566.72,0.00,0.00,0.00),('1','202','1036','363',363,'3070','477',461326.04,463314.15,0.00,0.00,1988.11,1453258.96,0.00,0.00,0.00),('1','202','1036','364',364,'3070','477',463314.15,464895.85,0.00,0.00,1581.70,1164131.20,0.00,0.00,0.00),('1','202','1036','365',365,'3070','477',464895.85,466610.56,0.00,0.00,1714.71,1262026.56,0.00,0.00,0.00),('1','202','1036','366',366,'3070','477',466610.56,468072.26,0.00,0.00,1461.70,1069601.20,0.00,0.00,0.00),('1','202','1036','367',367,'3070','477',468072.26,469465.05,0.00,0.00,1392.79,1025093.44,0.00,0.00,0.00),('1','202','1036','368',368,'3070','477',469465.05,470774.04,0.00,0.00,1308.99,963416.64,0.00,0.00,0.00),('1','202','1036','369',369,'3070','477',470774.04,471993.51,0.00,0.00,1219.47,897529.92,0.00,0.00,0.00),('1','202','1036','370',370,'3070','477',471993.51,472349.62,0.00,0.00,356.11,262096.96,0.00,0.00,0.00),('1','202','1036','371',371,'3070','477',472349.62,472349.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','372',372,'3070','477',472349.62,472792.29,0.00,0.00,442.67,325805.12,0.00,0.00,0.00),('1','202','1036','373',373,'3070','477',472792.29,474687.90,0.00,0.00,1895.61,1395168.96,0.00,0.00,0.00),('1','202','1036','374',374,'3070','477',474687.90,476617.91,0.00,0.00,1930.01,1420487.36,0.00,0.00,0.00),('1','202','1036','375',375,'3070','477',476617.91,478066.78,0.00,0.00,1448.87,1066368.32,0.00,0.00,0.00),('1','202','1036','376',376,'3070','477',478066.78,478314.45,0.00,0.00,247.67,182285.12,0.00,0.00,0.00),('1','202','1036','377',377,'3070','477',478314.45,478314.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','378',378,'3070','477',478314.45,479165.41,0.00,0.00,850.96,626306.56,0.00,0.00,0.00),('1','202','1036','379',379,'3070','477',479165.41,480446.65,0.00,0.00,1281.24,942992.64,0.00,0.00,0.00),('1','202','1036','380',380,'3070','477',480446.65,481465.63,0.00,0.00,1018.98,749969.28,0.00,0.00,0.00),('1','202','1036','381',381,'3070','477',481465.63,482650.19,0.00,0.00,1184.56,871836.16,0.00,0.00,0.00),('1','202','1036','382',382,'3070','477',482650.19,483501.17,0.00,0.00,850.98,600331.28,0.00,0.00,0.00),('1','202','1036','383',383,'3070','477',483501.17,483501.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','384',384,'3070','477',483501.17,484663.86,0.00,0.00,1162.69,854059.84,0.00,0.00,0.00),('1','202','1036','385',385,'3070','477',484663.86,486696.81,0.00,0.00,2032.95,1480627.20,0.00,0.00,0.00),('1','202','1036','386',386,'3070','477',486696.81,488421.68,0.00,0.00,1724.87,1237640.32,0.00,0.00,0.00),('1','202','1036','387',387,'3070','477',488421.68,490477.19,0.00,0.00,2055.51,1471639.36,0.00,0.00,0.00),('1','202','1036','388',388,'3070','477',490477.19,493323.03,0.00,0.00,2845.84,1998330.24,0.00,0.00,0.00),('1','202','1036','389',389,'3070','477',493323.03,495568.64,0.00,0.00,2245.61,1603757.76,0.00,0.00,0.00),('1','202','1036','390',390,'3070','477',495568.64,497810.03,0.00,0.00,2241.39,1591255.04,0.00,0.00,0.00),('1','202','1036','391',391,'3070','477',497810.03,500344.87,0.00,0.00,2534.84,1796678.24,0.00,0.00,0.00),('1','202','1036','392',392,'3070','477',500344.87,503460.46,0.00,0.00,3115.59,2210838.24,0.00,0.00,0.00),('1','202','1036','393',393,'3070','477',503460.46,505145.63,0.00,0.00,1685.17,1217633.12,0.00,0.00,0.00),('1','202','1036','394',394,'3070','477',505145.63,507211.61,0.00,0.00,2065.98,1463273.28,0.00,0.00,0.00),('1','202','1036','395',395,'3070','477',507211.61,508093.36,0.00,0.00,881.75,636578.56,0.00,0.00,0.00),('1','202','1036','396',396,'3070','477',508093.36,508093.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','397',397,'3070','477',508093.36,508093.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','398',398,'3070','477',508093.36,510412.79,0.00,0.00,2319.43,1666317.92,0.00,0.00,0.00),('1','202','1036','399',399,'3070','477',510412.79,512369.61,0.00,0.00,1956.82,1405303.52,0.00,0.00,0.00),('1','202','1036','400',400,'3070','477',512369.61,514558.86,0.00,0.00,2189.25,1581496.00,0.00,0.00,0.00),('1','202','1036','401',401,'3070','477',514558.86,516613.02,0.00,0.00,2054.16,1498253.76,0.00,0.00,0.00),('1','202','1036','402',402,'3070','477',516613.02,518229.17,0.00,0.00,1616.15,1175262.40,0.00,0.00,0.00),('1','202','1036','403',403,'3070','477',518229.17,520609.91,0.00,0.00,2380.74,1682308.64,0.00,0.00,0.00),('1','202','1036','404',404,'3070','477',520609.91,522964.10,0.00,0.00,2354.19,1684971.84,0.00,0.00,0.00),('1','202','1036','405',405,'3070','477',522964.10,524819.13,0.00,0.00,1855.03,1336388.08,0.00,0.00,0.00),('1','202','1036','406',406,'3070','477',524819.13,527492.84,0.00,0.00,2673.71,1873910.56,0.00,0.00,0.00),('1','202','1036','407',407,'3070','477',527492.84,530355.20,0.00,0.00,2862.36,2042659.16,0.00,0.00,0.00),('1','202','1036','408',408,'3070','477',530355.20,532842.49,0.00,0.00,2487.29,1778398.94,0.00,0.00,0.00),('1','202','1036','409',409,'3070','477',532842.49,532842.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','410',410,'3070','477',532842.49,534689.72,0.00,0.00,1847.23,1301547.84,0.00,0.00,0.00),('1','202','1036','411',411,'3070','477',534689.72,537564.77,0.00,0.00,2875.05,2033686.80,0.00,0.00,0.00),('1','202','1036','412',412,'3070','477',537564.77,539890.15,0.00,0.00,2325.38,1644835.35,0.00,0.00,0.00),('1','202','1036','413',413,'3070','477',539890.15,541493.29,0.00,0.00,1603.14,1162953.04,0.00,0.00,0.00),('1','202','1036','414',414,'3070','477',541493.29,542753.53,0.00,0.00,1260.24,919789.64,0.00,0.00,0.00),('1','202','1036','415',415,'3070','477',542753.53,545273.97,0.00,0.00,2520.44,1794531.84,0.00,0.00,0.00),('1','202','1036','416',416,'3070','477',545273.97,547450.07,0.00,0.00,2176.10,1578917.60,0.00,0.00,0.00),('1','202','1036','417',417,'3070','477',547450.07,548944.58,0.00,0.00,1494.51,1083283.79,0.00,0.00,0.00),('1','202','1036','418',418,'3070','477',548944.58,550620.37,0.00,0.00,1675.79,1213251.44,0.00,0.00,0.00),('1','202','1036','419',419,'3070','477',550620.37,552229.39,0.00,0.00,1609.02,1166914.72,0.00,0.00,0.00),('1','202','1036','420',420,'3070','477',552229.39,554677.88,0.00,0.00,2448.49,1761105.18,0.00,0.00,0.00),('1','202','1036','421',421,'3070','477',554677.88,556606.17,0.00,0.00,1928.29,1403544.44,0.00,0.00,0.00),('1','202','1036','422',422,'3070','477',556606.17,557605.26,0.00,0.00,999.09,713866.24,0.00,0.00,0.00),('1','202','1036','423',423,'3070','477',557605.26,557605.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','424',424,'3070','477',557605.26,559559.50,0.00,0.00,1954.24,1428927.86,0.00,0.00,0.00),('1','202','1036','425',425,'3070','477',559559.50,562892.23,0.00,0.00,3332.73,2341564.28,0.00,0.00,0.00),('1','202','1036','426',426,'3070','477',562892.23,564459.46,0.00,0.00,1567.23,1136096.28,0.00,0.00,0.00),('1','202','1036','427',427,'3070','477',564459.46,566691.32,0.00,0.00,2231.86,1573467.64,0.00,0.00,0.00),('1','202','1036','428',428,'3070','477',566691.32,567848.07,0.00,0.00,1156.75,829713.00,0.00,0.00,0.00),('1','202','1036','429',429,'3070','477',567848.07,570055.79,0.00,0.00,2207.72,1568517.92,0.00,0.00,0.00),('1','202','1036','430',430,'3070','477',570055.79,572730.68,0.00,0.00,2674.89,1917669.36,0.00,0.00,0.00),('1','202','1036','431',431,'3070','477',572730.68,575126.63,0.00,0.00,2395.95,1683619.00,0.00,0.00,0.00),('1','202','1036','432',432,'3070','477',575126.63,577626.29,0.00,0.00,2499.66,1774270.53,0.00,0.00,0.00),('1','202','1036','433',433,'3070','477',577626.29,579561.94,0.00,0.00,1935.65,1339370.26,0.00,0.00,0.00),('1','202','1036','434',434,'3070','477',579561.94,581895.65,0.00,0.00,2333.71,1589747.00,0.00,0.00,0.00),('1','202','1036','435',435,'3070','477',581895.65,582241.34,0.00,0.00,345.69,231733.00,0.00,0.00,0.00),('1','202','1036','436',436,'3070','477',582241.34,582241.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','437',437,'3070','477',582241.34,582712.43,0.00,0.00,471.09,328763.00,0.00,0.00,0.00),('1','202','1036','438',438,'3070','477',582712.43,586068.24,0.00,0.00,3355.81,2277298.00,0.00,0.00,0.00),('1','202','1036','439',439,'3070','477',586068.24,587274.23,0.00,0.00,1205.99,823293.00,0.00,0.00,0.00),('1','202','1036','440',440,'3070','477',587274.23,587274.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','202','1036','441',441,'3070','477',587274.23,590003.86,0.00,0.00,2729.63,1840241.00,0.00,0.00,0.00),('1','202','1036','442',442,'3070','477',590003.86,592980.39,0.00,0.00,2976.53,1990309.00,0.00,0.00,0.00),('1','202','1036','443',443,'3070','477',592980.39,595115.88,0.00,0.00,2135.49,1456343.00,0.00,0.00,0.00),('1','202','1036','444',444,'3070','477',595115.88,597078.29,0.00,0.00,1962.41,1334536.00,0.00,0.00,0.00),('1','202','1036','445',445,'3070','477',597078.29,599664.31,0.00,0.00,2586.02,1766958.50,0.00,0.00,0.00),('1','202','1036','446',446,'3070','477',599664.31,602950.86,0.00,0.00,3286.55,2257285.50,0.00,0.00,0.00),('1','202','1036','447',447,'3070','477',602950.86,604738.23,0.00,0.00,1787.37,1222809.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=448 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','202','1','477',507.00,568.00,0.00,462.01,145792.92,241709.52,95916.60,1),('1','202','2','477',0.00,568.00,0.00,585.65,0.00,325012.12,325012.12,2),('1','202','3','477',0.00,568.00,0.00,397.87,0.00,224596.16,224596.16,3),('1','202','4','477',0.00,568.00,0.00,981.23,0.00,544411.16,544411.16,4),('1','202','5','477',0.00,568.00,0.00,2291.08,0.00,1253410.44,1253410.44,5),('1','202','6','477',0.00,568.00,0.00,1252.25,0.00,689577.00,689577.00,6),('1','202','7','477',0.00,568.00,0.00,3558.24,0.00,1913503.32,1913503.32,7),('1','202','8','477',0.00,640.00,0.00,435.56,0.00,278758.40,278758.40,8),('1','202','9','477',0.00,680.00,0.00,276.70,0.00,181100.00,181100.00,9),('1','202','10','477',0.00,680.00,0.00,1073.54,0.00,678023.20,678023.20,10),('1','202','11','477',0.00,680.00,0.00,607.58,0.00,391338.40,391338.40,11),('1','202','12','477',0.00,680.00,0.00,1285.52,0.00,787033.60,787033.60,12),('1','202','13','477',507.00,688.00,0.00,743.23,376817.61,494699.04,117881.43,13),('1','202','14','477',507.00,688.00,0.00,392.54,199017.78,261491.52,62473.74,14),('1','202','15','477',507.00,688.00,0.00,874.93,443589.51,572915.84,129326.33,15),('1','202','16','477',507.00,688.00,0.00,565.86,0.00,377207.68,377207.68,16),('1','202','17','477',0.00,688.00,0.00,515.13,261170.91,325683.48,64512.57,17),('1','202','18','477',507.00,664.00,0.00,1730.08,877150.56,1101132.28,223981.72,18),('1','202','19','477',507.00,664.00,0.00,2736.96,1387638.72,1728069.40,340430.68,19),('1','202','20','477',507.00,664.00,0.00,2078.68,1053890.76,1307937.00,254046.24,20),('1','202','21','477',507.00,664.00,0.00,2053.52,1123149.09,1292253.08,169103.99,21),('1','202','22','477',602.00,664.00,0.00,0.00,0.00,0.00,0.00,22),('1','202','23','477',602.00,664.00,0.00,2100.44,909.02,1306782.16,1305873.14,23),('1','202','24','477',0.00,664.00,0.00,1059.62,0.00,668656.14,668656.14,24),('1','202','25','477',0.00,664.00,0.00,0.00,0.00,0.00,0.00,25),('1','202','26','477',0.00,664.00,0.00,1286.98,774761.96,805584.72,30822.76,26),('1','202','27','477',602.00,664.00,0.00,1370.97,825323.94,873891.58,48567.64,27),('1','202','28','477',602.00,664.00,0.00,1042.33,627482.66,692107.12,64624.46,28),('1','202','29','477',602.00,664.00,0.00,973.14,585830.28,646164.96,60334.68,29),('1','202','30','477',602.00,664.00,0.00,675.94,406915.88,448824.16,41908.28,30),('1','202','31','477',602.00,664.00,0.00,140.66,84677.32,93398.24,8720.92,31),('1','202','32','477',602.00,664.00,0.00,0.00,0.00,0.00,0.00,32),('1','202','33','477',602.00,664.00,0.00,182.14,109648.28,120940.96,11292.68,33),('1','202','34','477',602.00,664.00,0.00,618.23,372174.46,410504.72,38330.26,34),('1','202','35','477',602.00,664.00,0.00,698.86,420713.72,464043.04,43329.32,35),('1','202','36','477',602.00,664.00,0.00,2385.06,1435806.12,1505799.84,69993.72,36),('1','202','37','477',602.00,664.00,0.00,1124.52,676961.04,746681.28,69720.24,37),('1','202','38','477',602.00,664.00,0.00,281.52,169475.04,186929.28,17454.24,38),('1','202','39','477',602.00,664.00,0.00,0.00,0.00,0.00,0.00,39),('1','202','40','477',602.00,664.00,0.00,578.18,348064.36,383911.52,35847.16,40),('1','202','41','477',602.00,664.00,0.00,854.67,514511.34,567500.88,52989.54,41),('1','202','42','477',602.00,664.00,0.00,849.86,245778.54,553846.04,308067.50,42),('1','202','43','477',0.00,664.00,0.00,2191.47,0.00,1353295.08,1353295.08,43),('1','202','44','477',0.00,664.00,0.00,549.57,0.00,350009.04,350009.04,44),('1','202','45','477',0.00,664.00,0.00,0.00,0.00,0.00,0.00,45),('1','202','46','477',582.00,664.00,0.00,867.59,504937.38,539713.76,34776.38,46),('1','202','47','477',582.00,664.00,0.00,1570.71,914153.22,990283.44,76130.22,47),('1','202','48','477',582.00,664.00,0.00,1536.09,894004.38,970892.76,76888.38,48),('1','202','49','477',582.00,664.00,0.00,1845.42,1074034.44,1177013.88,102979.44,49),('1','202','50','477',582.00,664.00,0.00,1268.13,738051.66,797158.32,59106.66,50),('1','202','51','477',582.00,664.00,0.00,1200.88,698912.16,765902.32,66990.16,51),('1','202','52','477',582.00,664.00,0.00,744.80,433473.60,489927.20,56453.60,52),('1','202','53','477',582.00,664.00,0.00,1562.55,909404.10,984106.20,74702.10,53),('1','202','54','477',582.00,664.00,0.00,1652.28,961626.96,1072858.92,111231.96,54),('1','202','55','477',582.00,664.00,0.00,3181.27,1851499.14,2010954.94,159455.80,55),('1','202','56','477',582.00,664.00,0.00,4043.68,2353421.76,2505884.14,152462.38,56),('1','202','57','477',582.00,664.00,0.00,942.63,548610.66,610600.26,61989.60,57),('1','202','58','477',582.00,664.00,0.00,1609.92,936973.44,1012439.40,75465.96,58),('1','202','59','477',582.00,664.00,0.00,1127.37,656129.34,726771.90,70642.56,59),('1','202','60','477',582.00,664.00,0.00,1077.35,627017.70,684290.24,57272.54,60),('1','202','61','477',582.00,664.00,0.00,289.45,168459.90,182754.82,14294.92,61),('1','202','62','477',582.00,664.00,0.00,0.00,0.00,0.00,0.00,62),('1','202','63','477',582.00,664.00,0.00,1636.14,952233.48,1047856.26,95622.78,63),('1','202','64','477',582.00,664.00,0.00,1227.83,714597.06,815279.12,100682.06,64),('1','202','65','477',582.00,664.00,0.00,898.49,522921.18,596597.36,73676.18,65),('1','202','66','477',582.00,664.00,0.00,224.92,130903.44,149346.88,18443.44,66),('1','202','67','477',582.00,664.00,0.00,1002.98,583734.36,665978.72,82244.36,67),('1','202','68','477',582.00,664.00,0.00,656.83,382275.06,436135.12,53860.06,68),('1','202','69','477',582.00,664.00,0.00,0.00,0.00,0.00,0.00,69),('1','202','70','477',582.00,664.00,0.00,379.78,221031.96,252173.92,31141.96,70),('1','202','71','477',582.00,664.00,0.00,1189.59,692341.38,789887.76,97546.38,71),('1','202','72','477',582.00,664.00,0.00,1957.44,1139230.08,1262848.32,123618.24,72),('1','202','73','477',582.00,680.00,0.00,1078.19,627506.58,733169.20,105662.62,73),('1','202','74','477',582.00,680.00,0.00,673.31,391866.42,457850.80,65984.38,74),('1','202','75','477',582.00,680.00,0.00,0.00,0.00,0.00,0.00,75),('1','202','76','477',582.00,680.00,0.00,0.00,0.00,0.00,0.00,76),('1','202','77','477',592.00,680.00,0.00,369.44,218708.48,251219.20,32510.72,77),('1','202','78','477',592.00,680.00,0.00,930.26,550713.92,632576.80,81862.88,78),('1','202','79','477',592.00,680.00,0.00,1600.21,947324.32,1088142.80,140818.48,79),('1','202','80','477',592.00,680.00,0.00,1289.94,763644.48,877159.20,113514.72,80),('1','202','81','477',592.00,680.00,0.00,750.96,444568.32,510652.80,66084.48,81),('1','202','82','477',592.00,680.00,0.00,355.74,210598.08,241903.20,31305.12,82),('1','202','83','477',592.00,680.00,0.00,2434.37,1441147.04,1546331.28,105184.24,83),('1','202','84','477',592.00,680.00,0.00,704.70,417182.40,503139.00,85956.60,84),('1','202','85','477',592.00,720.00,0.00,1912.17,1132004.64,1323528.40,191523.76,85),('1','202','86','477',662.00,720.00,0.00,2402.12,1590203.44,1655652.40,65448.96,86),('1','202','87','477',662.00,720.00,0.00,2843.82,1882608.84,1956377.50,73768.66,87),('1','202','88','477',662.00,720.00,0.00,0.00,0.00,0.00,0.00,88),('1','202','89','477',662.00,720.00,0.00,3762.29,2490635.98,2607454.80,116818.82,89),('1','202','90','477',662.00,720.00,0.00,1575.98,1043298.76,1083580.75,40281.99,90),('1','202','91','477',662.00,720.00,0.00,0.00,0.00,0.00,0.00,91),('1','202','92','477',662.00,720.00,0.00,1896.72,1255628.64,1316850.60,61221.96,92),('1','202','93','477',662.00,720.00,0.00,2398.36,1587714.32,1750183.60,162469.28,93),('1','202','94','477',662.00,760.00,0.00,842.02,557417.24,611944.40,54527.16,94),('1','202','95','477',662.00,760.00,0.00,0.00,0.00,0.00,0.00,95),('1','202','96','477',662.00,760.00,0.00,2118.86,1402685.32,1540641.20,137955.88,96),('1','202','97','477',662.00,760.00,0.00,4665.36,3088468.32,3363543.60,275075.28,97),('1','202','98','477',662.00,760.00,0.00,3626.72,2400888.64,2651069.00,250180.36,98),('1','202','99','477',662.00,760.00,0.00,1049.62,694848.44,797711.20,102862.76,99),('1','202','100','477',662.00,760.00,0.00,1032.71,683654.02,784859.60,101205.58,100),('1','202','101','477',662.00,760.00,0.00,1048.59,694166.58,796928.40,102761.82,101),('1','202','102','477',662.00,760.00,0.00,2181.32,1444033.84,1591803.20,147769.36,102),('1','202','103','477',662.00,760.00,0.00,1080.07,715006.34,820853.20,105846.86,103),('1','202','104','477',662.00,760.00,0.00,1900.22,1257945.64,1444167.20,186221.56,104),('1','202','105','477',662.00,760.00,0.00,1040.77,688989.74,790985.20,101995.46,105),('1','202','106','477',662.00,760.00,0.00,1525.10,1009616.20,1159076.00,149459.80,106),('1','202','107','477',662.00,760.00,0.00,1352.68,895474.16,1028036.80,132562.64,107),('1','202','108','477',662.00,760.00,0.00,1126.44,745703.28,856094.40,110391.12,108),('1','202','109','477',662.00,760.00,0.00,289.91,191920.42,220331.60,28411.18,109),('1','202','110','477',662.00,760.00,0.00,0.00,0.00,0.00,0.00,110),('1','202','111','477',662.00,760.00,0.00,516.70,347222.40,392692.00,45469.60,111),('1','202','112','477',672.00,760.00,0.00,930.17,625074.24,706929.20,81854.96,112),('1','202','113','477',672.00,760.00,0.00,1681.15,1129732.80,1277674.00,147941.20,113),('1','202','114','477',672.00,760.00,0.00,1708.81,1148320.32,1298695.60,150375.28,114),('1','202','115','477',672.00,760.00,0.00,0.00,0.00,0.00,0.00,115),('1','202','116','477',672.00,760.00,0.00,1048.46,704565.12,796829.60,92264.48,116),('1','202','117','477',672.00,760.00,0.00,697.95,469022.40,530442.00,61419.60,117),('1','202','118','477',672.00,760.00,0.00,895.44,601735.68,680534.40,78798.72,118),('1','202','119','477',672.00,760.00,0.00,1008.62,677792.64,766551.20,88758.56,119),('1','202','120','477',672.00,760.00,0.00,1280.50,860496.00,973180.00,112684.00,120),('1','202','121','477',672.00,760.00,0.00,1005.94,675991.68,764514.40,88522.72,121),('1','202','122','477',672.00,760.00,0.00,0.00,0.00,0.00,0.00,122),('1','202','123','477',672.00,760.00,0.00,133.65,89812.80,101574.00,11761.20,123),('1','202','124','477',672.00,760.00,0.00,2629.40,1776211.00,1945544.00,169333.00,124),('1','202','125','477',682.00,760.00,0.00,1067.62,728116.84,811391.20,83274.36,125),('1','202','126','477',682.00,760.00,0.00,1199.02,817731.64,911255.20,93523.56,126),('1','202','127','477',682.00,760.00,0.00,126.07,85979.74,95813.20,9833.46,127),('1','202','128','477',682.00,760.00,0.00,1011.02,689515.64,768375.20,78859.56,128),('1','202','129','477',682.00,760.00,0.00,1280.37,873212.34,973081.20,99868.86,129),('1','202','130','477',682.00,760.00,0.00,1404.57,957916.74,1067473.20,109556.46,130),('1','202','131','477',682.00,760.00,0.00,1682.10,1147192.20,1264796.00,117603.80,131),('1','202','132','477',682.00,760.00,0.00,0.00,0.00,0.00,0.00,132),('1','202','133','477',682.00,760.00,0.00,525.21,358193.22,392599.60,34406.38,133),('1','202','134','477',682.00,760.00,0.00,3844.05,2621642.10,2844718.00,223075.90,134),('1','202','135','477',682.00,760.00,0.00,903.09,615907.38,669668.40,53761.02,135),('1','202','136','477',682.00,760.00,0.00,0.00,0.00,0.00,0.00,136),('1','202','137','477',682.00,760.00,0.00,2592.97,1768405.54,1902052.40,133646.86,137),('1','202','138','477',682.00,760.00,0.00,2382.13,1624612.66,1766358.80,141746.14,138),('1','202','139','477',682.00,760.00,0.00,1957.99,1335349.18,1456328.00,120978.82,139),('1','202','140','477',682.00,760.00,0.00,1816.46,1238825.72,1359029.60,120203.88,140),('1','202','141','477',682.00,760.00,0.00,1946.21,1327315.22,1465015.20,137699.98,141),('1','202','142','477',682.00,760.00,0.00,2670.61,1821356.02,1983787.60,162431.58,142),('1','202','143','477',682.00,760.00,0.00,1956.92,1334619.44,1458339.20,123719.76,143),('1','202','144','477',682.00,760.00,0.00,2560.07,1745967.74,1896053.20,150085.46,144),('1','202','145','477',682.00,760.00,0.00,1102.71,752048.22,838059.60,86011.38,145),('1','202','146','477',682.00,760.00,0.00,896.32,611290.24,681203.20,69912.96,146),('1','202','147','477',682.00,760.00,0.00,953.41,650225.62,724591.60,74365.98,147),('1','202','148','477',682.00,760.00,0.00,899.41,613397.62,683551.60,70153.98,148),('1','202','149','477',682.00,760.00,0.00,1479.79,1009216.78,1124640.40,115423.62,149),('1','202','150','477',682.00,760.00,0.00,1210.04,825247.28,919630.40,94383.12,150),('1','202','151','477',682.00,760.00,0.00,223.77,152611.14,168745.20,16134.06,151),('1','202','152','477',682.00,760.00,0.00,0.00,0.00,0.00,0.00,152),('1','202','153','477',682.00,760.00,0.00,1025.43,699343.26,775926.80,76583.54,153),('1','202','154','477',682.00,760.00,0.00,3357.38,2289733.16,2446008.80,156275.64,154),('1','202','155','477',682.00,760.00,0.00,1247.73,850951.86,937666.80,86714.94,155),('1','202','156','477',682.00,760.00,0.00,1231.96,840196.72,927070.72,86874.00,156),('1','202','157','477',682.00,760.00,0.00,1539.09,1049659.38,1151516.40,101857.02,157),('1','202','158','477',682.00,760.00,0.00,2403.16,1638955.12,1742087.04,103131.92,158),('1','202','159','477',682.00,744.00,0.00,2480.50,1691701.00,1805214.00,113513.00,159),('1','202','160','477',682.00,744.00,0.00,2116.67,1443568.94,1519439.98,75871.04,160),('1','202','161','477',682.00,744.00,0.00,2280.64,1555396.48,1642627.64,87231.16,161),('1','202','162','477',682.00,744.00,0.00,2170.34,1480171.88,1572781.61,92609.73,162),('1','202','163','477',682.00,744.00,0.00,50.44,34400.08,37527.36,3127.28,163),('1','202','164','477',682.00,744.00,0.00,70.63,48169.66,52548.72,4379.06,164),('1','202','165','477',682.00,744.00,0.00,28.02,19109.64,20846.88,1737.24,165),('1','202','166','477',682.00,744.00,0.00,2080.54,1418928.28,1497314.56,78386.28,166),('1','202','167','477',682.00,744.00,0.00,1371.30,935226.60,1002901.20,67674.60,167),('1','202','168','477',682.00,744.00,0.00,690.40,470852.80,505768.60,34915.80,168),('1','202','169','477',682.00,744.00,0.00,3016.77,2017638.95,2155175.85,137536.90,169),('1','202','170','477',665.00,744.00,0.00,0.00,0.00,0.00,0.00,170),('1','202','171','477',665.00,744.00,0.00,2045.25,1360091.25,1476782.00,116690.75,171),('1','202','172','477',665.00,744.00,0.00,0.00,0.00,0.00,0.00,172),('1','202','173','477',665.00,744.00,0.00,1135.18,754894.70,824361.42,69466.72,173),('1','202','174','477',665.00,744.00,0.00,2520.72,1676278.80,1827268.28,150989.48,174),('1','202','175','477',665.00,744.00,0.00,2924.17,1944573.05,2110363.48,165790.43,175),('1','202','176','477',665.00,744.00,0.00,2408.38,1601572.70,1738130.72,136558.02,176),('1','202','177','477',665.00,744.00,0.00,2287.82,1521400.30,1661220.63,139820.33,177),('1','202','178','477',665.00,744.00,0.00,2903.81,1931033.65,2081324.14,150290.49,178),('1','202','179','477',665.00,744.00,0.00,4055.19,2696701.35,2907355.26,210653.91,179),('1','202','180','477',665.00,744.00,0.00,2934.65,1951542.25,2123452.60,171910.35,180),('1','202','181','477',665.00,744.00,0.00,1282.63,852948.95,971408.96,118460.01,181),('1','202','182','477',665.00,760.00,0.00,1327.44,882747.60,1008854.40,126106.80,182),('1','202','183','477',665.00,760.00,0.00,929.09,617844.85,706108.40,88263.55,183),('1','202','184','477',665.00,760.00,0.00,0.00,0.00,0.00,0.00,184),('1','202','185','477',665.00,760.00,0.00,1335.65,888207.25,1015134.00,126926.75,185),('1','202','186','477',665.00,760.00,0.00,1358.34,903296.10,1032338.40,129042.30,186),('1','202','187','477',665.00,760.00,0.00,1629.71,1083757.15,1238579.60,154822.45,187),('1','202','188','477',665.00,760.00,0.00,1069.30,711084.50,812668.00,101583.50,188),('1','202','189','477',665.00,760.00,0.00,1575.90,1047973.50,1197684.00,149710.50,189),('1','202','190','477',665.00,760.00,0.00,1864.98,1221561.90,1375713.12,154151.22,190),('1','202','191','477',655.00,744.00,0.00,1787.80,1171009.00,1271364.74,100355.74,191),('1','202','192','477',655.00,744.00,0.00,0.00,0.00,0.00,0.00,192),('1','202','193','477',655.00,744.00,0.00,706.75,462921.25,521067.10,58145.85,193),('1','202','194','477',655.00,744.00,0.00,2053.71,1345180.05,1501610.24,156430.19,194),('1','202','195','477',655.00,744.00,0.00,1919.56,1257311.80,1397042.64,139730.84,195),('1','202','196','477',655.00,744.00,0.00,116.64,76399.20,86780.16,10380.96,196),('1','202','197','477',655.00,744.00,0.00,0.00,0.00,0.00,0.00,197),('1','202','198','477',655.00,744.00,0.00,2818.57,1846163.35,2049178.08,203014.73,198),('1','202','199','477',655.00,744.00,0.00,2041.89,1337437.95,1490941.06,153503.11,199),('1','202','200','477',655.00,744.00,0.00,1940.76,1271197.80,1430019.44,158821.64,200),('1','202','201','477',655.00,744.00,0.00,1137.06,744774.30,819112.64,74338.34,201),('1','202','202','477',665.00,738.00,0.00,1326.48,882109.20,964782.24,82673.04,202),('1','202','203','477',665.00,738.00,0.00,2309.64,1535910.60,1670978.32,135067.72,203),('1','202','204','477',665.00,738.00,0.00,2636.91,1753545.15,1897153.18,143608.03,204),('1','202','205','477',665.00,738.00,0.00,2550.12,1695829.80,1841380.24,145550.44,205),('1','202','206','477',665.00,738.00,0.00,3235.85,2151840.25,2330889.30,179049.05,206),('1','202','207','477',665.00,738.00,0.00,2612.88,1737565.20,1893217.44,155652.24,207),('1','202','208','477',665.00,738.00,0.00,2052.89,1365171.85,1478215.22,113043.37,208),('1','202','209','477',665.00,738.00,0.00,0.00,0.00,0.00,0.00,209),('1','202','210','477',665.00,738.00,0.00,3799.98,2526986.70,2725377.24,198390.54,210),('1','202','211','477',665.00,738.00,0.00,1857.49,1235230.85,1339003.62,103772.77,211),('1','202','212','477',665.00,738.00,0.00,0.00,0.00,0.00,0.00,212),('1','202','213','477',665.00,738.00,0.00,884.59,588252.35,643451.42,55199.07,213),('1','202','214','477',665.00,738.00,0.00,3185.99,2118683.35,2302636.62,183953.27,214),('1','202','215','477',665.00,738.00,0.00,1527.31,1015661.15,1099218.14,83556.99,215),('1','202','216','477',665.00,738.00,0.00,0.00,0.00,0.00,0.00,216),('1','202','217','477',665.00,738.00,0.00,838.45,557569.25,601080.10,43510.85,217),('1','202','218','477',665.00,738.00,0.00,4131.31,2747321.15,2978821.98,231500.83,218),('1','202','219','477',665.00,738.00,0.00,0.00,0.00,0.00,0.00,219),('1','202','220','477',665.00,738.00,0.00,2982.42,1983309.30,2161537.96,178228.66,220),('1','202','221','477',665.00,738.00,0.00,2127.00,1414455.00,1527351.00,112896.00,221),('1','202','222','477',665.00,738.00,0.00,0.00,0.00,0.00,0.00,222),('1','202','223','477',665.00,738.00,0.00,558.42,371349.30,406353.96,35004.66,223),('1','202','224','477',665.00,738.00,0.00,3228.97,2147265.05,2308676.86,161411.81,224),('1','202','225','477',665.00,738.00,0.00,1749.59,1163477.35,1256484.42,93007.07,225),('1','202','226','477',665.00,738.00,0.00,0.00,0.00,0.00,0.00,226),('1','202','227','477',665.00,738.00,0.00,1525.33,1014344.45,1094419.54,80075.09,227),('1','202','228','477',665.00,738.00,0.00,3038.73,2020755.45,2185506.74,164751.29,228),('1','202','229','477',665.00,738.00,0.00,582.75,387528.75,430069.50,42540.75,229),('1','202','230','477',665.00,738.00,0.00,0.00,0.00,0.00,0.00,230),('1','202','231','477',665.00,738.00,0.00,1780.32,1183912.80,1313938.16,130025.36,231),('1','202','232','477',665.00,738.00,0.00,851.47,566227.55,629146.86,62919.31,232),('1','202','233','477',665.00,738.00,0.00,0.00,0.00,0.00,0.00,233),('1','202','234','477',665.00,738.00,0.00,868.30,577419.50,640805.40,63385.90,234),('1','202','235','477',665.00,738.00,0.00,1278.25,850036.25,943348.50,93312.25,235),('1','202','236','477',665.00,738.00,0.00,1140.02,758113.30,841334.76,83221.46,236),('1','202','237','477',665.00,738.00,0.00,1451.85,965480.25,1071465.30,105985.05,237),('1','202','238','477',665.00,738.00,0.00,33.78,22463.70,24862.08,2398.38,238),('1','202','239','477',665.00,736.00,0.00,0.00,0.00,0.00,0.00,239),('1','202','240','477',665.00,736.00,0.00,1020.05,678333.25,752320.80,73987.55,240),('1','202','241','477',665.00,736.00,0.00,1539.45,1023734.25,1133035.20,109300.95,241),('1','202','242','477',665.00,736.00,0.00,1415.82,941520.30,1042043.52,100523.22,242),('1','202','243','477',665.00,736.00,0.00,789.28,524871.20,580910.08,56038.88,243),('1','202','244','477',665.00,736.00,0.00,49.39,32844.35,36351.04,3506.69,244),('1','202','245','477',665.00,736.00,0.00,0.00,0.00,0.00,0.00,245),('1','202','246','477',660.00,736.00,0.00,1357.74,896108.40,999296.64,103188.24,246),('1','202','247','477',660.00,736.00,0.00,1489.09,982799.40,1095970.24,113170.84,247),('1','202','248','477',660.00,736.00,0.00,1129.61,745542.60,831392.96,85850.36,248),('1','202','249','477',660.00,736.00,0.00,1440.66,950835.60,1060589.76,109754.16,249),('1','202','250','477',660.00,736.00,0.00,63.88,42160.80,47015.68,4854.88,250),('1','202','251','477',660.00,736.00,0.00,0.00,0.00,0.00,0.00,251),('1','202','252','477',660.00,736.00,0.00,1044.07,689086.20,768435.52,79349.32,252),('1','202','253','477',660.00,736.00,0.00,1543.43,1018663.80,1135964.48,117300.68,253),('1','202','254','477',660.00,736.00,0.00,2645.19,1745825.40,1891419.84,145594.44,254),('1','202','255','477',660.00,736.00,0.00,216.70,143022.00,156215.20,13193.20,255),('1','202','256','477',660.00,736.00,0.00,965.40,637164.00,704774.40,67610.40,256),('1','202','257','477',660.00,736.00,0.00,1893.73,1249861.80,1375245.28,125383.48,257),('1','202','258','477',660.00,736.00,0.00,2254.76,1488141.60,1651079.36,162937.76,258),('1','202','259','477',660.00,736.00,0.00,2376.85,1568721.00,1722073.60,153352.60,259),('1','202','260','477',660.00,736.00,0.00,1973.39,1302437.40,1443451.40,141014.00,260),('1','202','261','477',660.00,736.00,0.00,1881.12,1241539.20,1384504.32,142965.12,261),('1','202','262','477',660.00,736.00,0.00,653.07,431026.20,480659.52,49633.32,262),('1','202','263','477',660.00,736.00,0.00,0.00,0.00,0.00,0.00,263),('1','202','264','477',660.00,736.00,0.00,529.55,349503.00,389748.80,40245.80,264),('1','202','265','477',660.00,736.00,0.00,1687.29,1113611.40,1241845.44,128234.04,265),('1','202','266','477',660.00,736.00,0.00,579.16,382245.60,426261.76,44016.16,266),('1','202','267','477',660.00,736.00,0.00,220.83,145747.80,168714.12,22966.32,267),('1','202','268','477',660.00,764.00,0.00,2904.93,1917253.80,2219366.52,302112.72,268),('1','202','269','477',660.00,764.00,0.00,816.52,538903.20,623821.28,84918.08,269),('1','202','270','477',660.00,764.00,0.00,0.00,0.00,0.00,0.00,270),('1','202','271','477',660.00,764.00,0.00,316.66,208995.60,241928.24,32932.64,271),('1','202','272','477',660.00,748.00,0.00,2038.56,1345449.60,1524842.88,179393.28,272),('1','202','273','477',660.00,748.00,0.00,1924.77,1270348.20,1439727.96,169379.76,273),('1','202','274','477',660.00,748.00,0.00,30.82,20341.20,23053.36,2712.16,274),('1','202','275','477',660.00,748.00,0.00,0.00,0.00,0.00,0.00,275),('1','202','276','477',660.00,748.00,0.00,801.81,529194.60,599753.88,70559.28,276),('1','202','277','477',660.00,748.00,0.00,2346.33,1548577.80,1755054.84,206477.04,277),('1','202','278','477',660.00,748.00,0.00,1682.28,1110304.80,1258345.44,148040.64,278),('1','202','279','477',660.00,748.00,0.00,522.59,344909.40,390897.32,45987.92,279),('1','202','280','477',660.00,748.00,0.00,0.00,0.00,0.00,0.00,280),('1','202','281','477',660.00,748.00,0.00,780.50,515130.00,583814.00,68684.00,281),('1','202','282','477',660.00,748.00,0.00,1164.84,768794.40,871300.32,102505.92,282),('1','202','283','477',660.00,760.00,0.00,1087.62,717829.20,826591.20,108762.00,283),('1','202','284','477',660.00,760.00,0.00,1210.57,798976.20,920033.20,121057.00,284),('1','202','285','477',660.00,760.00,0.00,1004.62,663049.20,763511.20,100462.00,285),('1','202','286','477',660.00,760.00,0.00,0.00,0.00,0.00,0.00,286),('1','202','287','477',660.00,760.00,0.00,1280.37,845044.20,973081.20,128037.00,287),('1','202','288','477',660.00,760.00,0.00,1597.26,1054191.60,1213917.60,159726.00,288),('1','202','289','477',660.00,760.00,0.00,1355.55,894663.00,1030218.00,135555.00,289),('1','202','290','477',660.00,760.00,0.00,978.02,645493.20,743295.20,97802.00,290),('1','202','291','477',660.00,800.00,0.00,53.63,35395.80,42904.00,7508.20,291),('1','202','292','477',660.00,800.00,0.00,0.00,0.00,0.00,0.00,292),('1','202','293','477',660.00,800.00,0.00,1027.42,678097.20,821936.00,143838.80,293),('1','202','294','477',660.00,800.00,0.00,1368.79,903401.40,1095032.00,191630.60,294),('1','202','295','477',660.00,800.00,0.00,1343.62,886789.20,1074896.00,188106.80,295),('1','202','296','477',660.00,760.00,0.00,1443.60,952776.00,1097136.00,144360.00,296),('1','202','297','477',660.00,760.00,0.00,0.00,0.00,0.00,0.00,297),('1','202','298','477',660.00,760.00,0.00,1543.29,1018571.40,1172900.40,154329.00,298),('1','202','299','477',660.00,760.00,0.00,1643.40,1084644.00,1248984.00,164340.00,299),('1','202','300','477',660.00,760.00,0.00,1652.49,1090643.40,1255892.40,165249.00,300),('1','202','301','477',660.00,760.00,0.00,370.82,244741.20,281823.20,37082.00,301),('1','202','302','477',660.00,760.00,0.00,1765.28,1165084.80,1341612.80,176528.00,302),('1','202','303','477',660.00,760.00,0.00,2058.78,1358794.80,1564672.80,205878.00,303),('1','202','304','477',660.00,760.00,0.00,159.37,105184.20,121121.20,15937.00,304),('1','202','305','477',660.00,760.00,0.00,0.00,0.00,0.00,0.00,305),('1','202','306','477',660.00,760.00,0.00,648.55,428043.00,492898.00,64855.00,306),('1','202','307','477',660.00,760.00,0.00,1155.02,762313.20,877815.20,115502.00,307),('1','202','308','477',660.00,760.00,0.00,1351.35,891891.00,1027026.00,135135.00,308),('1','202','309','477',660.00,760.00,0.00,1009.93,666553.80,767546.80,100993.00,309),('1','202','310','477',660.00,760.00,0.00,1103.69,728435.40,838804.40,110369.00,310),('1','202','311','477',660.00,760.00,0.00,503.05,332013.00,382318.00,50305.00,311),('1','202','312','477',660.00,760.00,0.00,0.00,0.00,0.00,0.00,312),('1','202','313','477',685.00,760.00,0.00,656.77,449887.45,499145.20,49257.75,313),('1','202','314','477',685.00,760.00,0.00,1219.71,835501.35,926979.60,91478.25,314),('1','202','315','477',685.00,760.00,0.00,1131.13,774824.05,859658.80,84834.75,315),('1','202','316','477',685.00,760.00,0.00,1217.73,834145.05,925474.80,91329.75,316),('1','202','317','477',685.00,760.00,0.00,864.66,592292.10,657141.60,64849.50,317),('1','202','318','477',685.00,760.00,0.00,0.00,0.00,0.00,0.00,318),('1','202','319','477',685.00,760.00,0.00,328.02,224693.70,249295.20,24601.50,319),('1','202','320','477',685.00,760.00,0.00,1139.49,780550.65,866012.40,85461.75,320),('1','202','321','477',685.00,760.00,0.00,1006.79,689651.15,765160.40,75509.25,321),('1','202','322','477',685.00,760.00,0.00,2532.47,1734741.95,1889458.40,154716.45,322),('1','202','323','477',685.00,760.00,0.00,128.95,88330.75,98002.00,9671.25,323),('1','202','324','477',685.00,760.00,0.00,0.00,0.00,0.00,0.00,324),('1','202','325','477',675.00,760.00,0.00,1285.26,867550.50,969372.60,101822.10,325),('1','202','326','477',675.00,760.00,0.00,1280.54,864364.50,968710.40,104345.90,326),('1','202','327','477',675.00,760.00,0.00,2595.51,1751969.25,1910153.70,158184.45,327),('1','202','328','477',675.00,760.00,0.00,1315.55,887996.25,999818.00,111821.75,328),('1','202','329','477',675.00,760.00,0.00,1469.24,991737.00,1103797.40,112060.40,329),('1','202','330','477',675.00,760.00,0.00,1403.25,947193.75,1058870.00,111676.25,330),('1','202','331','477',675.00,760.00,0.00,1994.12,1346031.00,1484371.20,138340.20,331),('1','202','332','477',675.00,760.00,0.00,2180.36,1471743.00,1626080.10,154337.10,332),('1','202','333','477',675.00,760.00,0.00,1944.11,1312274.25,1448623.60,136349.35,333),('1','202','334','477',675.00,760.00,0.00,2094.47,1413767.25,1545147.20,131379.95,334),('1','202','335','477',675.00,760.00,0.00,1694.72,1143936.00,1276558.80,132622.80,335),('1','202','336','477',675.00,760.00,0.00,2086.13,1408137.75,1537976.00,129838.25,336),('1','202','337','477',675.00,760.00,0.00,2025.18,1366996.50,1495733.40,128736.90,337),('1','202','338','477',675.00,760.00,0.00,901.68,608634.00,669580.20,60946.20,338),('1','202','339','477',675.00,760.00,0.00,0.00,0.00,0.00,0.00,339),('1','202','340','477',660.00,760.00,0.00,897.43,592303.80,660626.80,68323.00,340),('1','202','341','477',660.00,760.00,0.00,2517.67,1661662.20,1857638.80,195976.60,341),('1','202','342','477',660.00,760.00,0.00,2443.41,1612650.60,1799281.80,186631.20,342),('1','202','343','477',660.00,760.00,0.00,2687.27,1773598.20,1965242.60,191644.40,343),('1','202','344','477',660.00,760.00,0.00,1221.50,806190.00,919340.00,113150.00,344),('1','202','345','477',660.00,760.00,0.00,1833.60,1210176.00,1347936.00,137760.00,345),('1','202','346','477',660.00,760.00,0.00,1471.86,971427.60,1073028.96,101601.36,346),('1','202','347','477',660.00,736.00,0.00,2181.73,1439941.80,1583505.64,143563.84,347),('1','202','348','477',660.00,736.00,0.00,2312.23,1526071.80,1684971.28,158899.48,348),('1','202','349','477',660.00,736.00,0.00,1549.88,1022920.80,1132368.32,109447.52,349),('1','202','350','477',660.00,736.00,0.00,2875.59,1897889.40,2062002.24,164112.84,350),('1','202','351','477',660.00,736.00,0.00,1527.89,1008407.40,1115697.32,107289.92,351),('1','202','352','477',660.00,736.00,0.00,984.21,649578.60,711778.56,62199.96,352),('1','202','353','477',660.00,736.00,0.00,0.00,0.00,0.00,0.00,353),('1','202','354','477',654.00,736.00,0.00,383.12,250560.48,281976.32,31415.84,354),('1','202','355','477',654.00,736.00,0.00,1956.95,1279845.30,1411333.04,131487.74,355),('1','202','356','477',654.00,736.00,0.00,1864.06,1219095.24,1364028.16,144932.92,356),('1','202','357','477',654.00,736.00,0.00,1759.85,1150941.90,1289489.60,138547.70,357),('1','202','358','477',654.00,736.00,0.00,1862.18,1217865.72,1355008.16,137142.44,358),('1','202','359','477',654.00,736.00,0.00,1117.08,730570.32,812261.52,81691.20,359),('1','202','360','477',654.00,736.00,0.00,466.29,304953.66,343189.44,38235.78,360),('1','202','361','477',654.00,736.00,0.00,1952.50,1276935.00,1437040.00,160105.00,361),('1','202','362','477',654.00,736.00,0.00,2094.52,1369816.08,1541566.72,171750.64,362),('1','202','363','477',654.00,736.00,0.00,1988.11,1300223.94,1453258.96,153035.02,363),('1','202','364','477',660.00,736.00,0.00,1581.70,1043922.00,1164131.20,120209.20,364),('1','202','365','477',660.00,736.00,0.00,1714.71,1131708.60,1262026.56,130317.96,365),('1','202','366','477',660.00,736.00,0.00,1461.70,964722.00,1069601.20,104879.20,366),('1','202','367','477',660.00,736.00,0.00,1392.79,919241.40,1025093.44,105852.04,367),('1','202','368','477',660.00,736.00,0.00,1308.99,863933.40,963416.64,99483.24,368),('1','202','369','477',660.00,736.00,0.00,1219.47,804850.20,897529.92,92679.72,369),('1','202','370','477',660.00,736.00,0.00,356.11,235032.60,262096.96,27064.36,370),('1','202','371','477',660.00,736.00,0.00,0.00,0.00,0.00,0.00,371),('1','202','372','477',660.00,736.00,0.00,442.67,292162.20,325805.12,33642.92,372),('1','202','373','477',660.00,736.00,0.00,1895.61,1251102.60,1395168.96,144066.36,373),('1','202','374','477',660.00,736.00,0.00,1930.01,1273806.60,1420487.36,146680.76,374),('1','202','375','477',660.00,736.00,0.00,1448.87,956254.20,1066368.32,110114.12,375),('1','202','376','477',660.00,736.00,0.00,247.67,163462.20,182285.12,18822.92,376),('1','202','377','477',660.00,736.00,0.00,0.00,0.00,0.00,0.00,377),('1','202','378','477',660.00,736.00,0.00,850.96,561633.60,626306.56,64672.96,378),('1','202','379','477',660.00,736.00,0.00,1281.24,845618.40,942992.64,97374.24,379),('1','202','380','477',660.00,736.00,0.00,1018.98,672526.80,749969.28,77442.48,380),('1','202','381','477',660.00,736.00,0.00,1184.56,781809.60,871836.16,90026.56,381),('1','202','382','477',660.00,736.00,0.00,850.98,561646.80,600331.28,38684.48,382),('1','202','383','477',660.00,736.00,0.00,0.00,0.00,0.00,0.00,383),('1','202','384','477',630.00,736.00,0.00,1162.69,732494.70,854059.84,121565.14,384),('1','202','385','477',630.00,736.00,0.00,2032.95,1280758.50,1480627.20,199868.70,385),('1','202','386','477',630.00,736.00,0.00,1724.87,1086668.10,1237640.32,150972.22,386),('1','202','387','477',630.00,736.00,0.00,2055.51,1294971.30,1471639.36,176668.06,387),('1','202','388','477',630.00,736.00,0.00,2845.84,1792879.20,1998330.24,205451.04,388),('1','202','389','477',630.00,736.00,0.00,2245.61,1414734.30,1603757.76,189023.46,389),('1','202','390','477',630.00,736.00,0.00,2241.39,1412075.70,1591255.04,179179.34,390),('1','202','391','477',630.00,736.00,0.00,2534.84,1596949.20,1796678.24,199729.04,391),('1','202','392','477',630.00,736.00,0.00,3115.59,1962821.70,2210838.24,248016.54,392),('1','202','393','477',630.00,736.00,0.00,1685.17,1061657.10,1217633.12,155976.02,393),('1','202','394','477',630.00,736.00,0.00,2065.98,1301567.40,1463273.28,161705.88,394),('1','202','395','477',630.00,736.00,0.00,881.75,555502.50,636578.56,81076.06,395),('1','202','396','477',630.00,736.00,0.00,0.00,0.00,0.00,0.00,396),('1','202','397','477',630.00,736.00,0.00,0.00,0.00,0.00,0.00,397),('1','202','398','477',630.00,736.00,0.00,2319.43,1461240.90,1666317.92,205077.02,398),('1','202','399','477',630.00,736.00,0.00,1956.82,1232796.60,1405303.52,172506.92,399),('1','202','400','477',630.00,736.00,0.00,2189.25,1379227.50,1581496.00,202268.50,400),('1','202','401','477',630.00,736.00,0.00,2054.16,1294120.80,1498253.76,204132.96,401),('1','202','402','477',630.00,736.00,0.00,1616.15,1018174.50,1175262.40,157087.90,402),('1','202','403','477',630.00,736.00,0.00,2380.74,1499866.20,1682308.64,182442.44,403),('1','202','404','477',630.00,736.00,0.00,2354.19,1483139.70,1684971.84,201832.14,404),('1','202','405','477',630.00,736.00,0.00,1855.03,1221573.60,1336388.08,114814.48,405),('1','202','406','477',660.00,736.00,0.00,2673.71,1764648.60,1873910.56,109261.96,406),('1','202','407','477',660.00,736.00,0.00,2862.36,1889157.60,2042659.16,153501.56,407),('1','202','408','477',660.00,736.00,0.00,2487.29,1641611.40,1778398.94,136787.54,408),('1','202','409','477',660.00,736.00,0.00,0.00,0.00,0.00,0.00,409),('1','202','410','477',660.00,736.00,0.00,1847.23,1163754.90,1301547.84,137792.94,410),('1','202','411','477',630.00,736.00,0.00,2875.05,1811281.50,2033686.80,222405.30,411),('1','202','412','477',630.00,736.00,0.00,2325.38,1464989.40,1644835.35,179845.95,412),('1','202','413','477',630.00,736.00,0.00,1603.14,1009978.20,1162953.04,152974.84,413),('1','202','414','477',630.00,736.00,0.00,1260.24,793951.20,919789.64,125838.44,414),('1','202','415','477',630.00,736.00,0.00,2520.44,1587877.20,1794531.84,206654.64,415),('1','202','416','477',630.00,736.00,0.00,2176.10,1370943.00,1578917.60,207974.60,416),('1','202','417','477',630.00,736.00,0.00,1494.51,941541.30,1083283.79,141742.49,417),('1','202','418','477',630.00,736.00,0.00,1675.79,1055747.70,1213251.44,157503.74,418),('1','202','419','477',630.00,736.00,0.00,1609.02,1013682.60,1166914.72,153232.12,419),('1','202','420','477',630.00,736.00,0.00,2448.49,1542548.70,1761105.18,218556.48,420),('1','202','421','477',630.00,736.00,0.00,1928.29,1214822.70,1403544.44,188721.74,421),('1','202','422','477',630.00,736.00,0.00,999.09,629426.70,713866.24,84439.54,422),('1','202','423','477',630.00,736.00,0.00,0.00,0.00,0.00,0.00,423),('1','202','424','477',630.00,736.00,0.00,1954.24,1231171.20,1428927.86,197756.66,424),('1','202','425','477',630.00,736.00,0.00,3332.73,2099619.90,2341564.28,241944.38,425),('1','202','426','477',630.00,736.00,0.00,1567.23,987354.90,1136096.28,148741.38,426),('1','202','427','477',630.00,736.00,0.00,2231.86,1406071.80,1573467.64,167395.84,427),('1','202','428','477',630.00,736.00,0.00,1156.75,728752.50,829713.00,100960.50,428),('1','202','429','477',630.00,736.00,0.00,2207.72,1390863.60,1568517.92,177654.32,429),('1','202','430','477',630.00,736.00,0.00,2674.89,1685180.70,1917669.36,232488.66,430),('1','202','431','477',630.00,736.00,0.00,2395.95,1509448.50,1683619.00,174170.50,431),('1','202','432','477',630.00,736.00,0.00,2499.66,1574785.80,1774270.53,199484.73,432),('1','202','433','477',630.00,736.00,0.00,1935.65,1263949.20,1339370.26,75421.06,433),('1','202','434','477',660.00,700.00,0.00,2333.71,1540248.60,1589747.00,49498.40,434),('1','202','435','477',660.00,700.00,0.00,345.69,228155.40,231733.00,3577.60,435),('1','202','436','477',660.00,700.00,0.00,0.00,0.00,0.00,0.00,436),('1','202','437','477',624.00,700.00,0.00,471.09,293960.16,328763.00,34802.84,437),('1','202','438','477',624.00,700.00,0.00,3355.81,2094025.44,2277298.00,183272.56,438),('1','202','439','477',624.00,700.00,0.00,1205.99,752537.76,823293.00,70755.24,439),('1','202','440','477',624.00,700.00,0.00,0.00,0.00,0.00,0.00,440),('1','202','441','477',624.00,700.00,0.00,2729.63,1703289.12,1840241.00,136951.88,441),('1','202','442','477',624.00,700.00,0.00,2976.53,1857354.72,1990309.00,132954.28,442),('1','202','443','477',624.00,700.00,0.00,2135.49,1332545.76,1456343.00,123797.24,443),('1','202','444','477',624.00,700.00,0.00,1962.41,1224543.84,1334536.00,109992.16,444),('1','202','445','477',624.00,700.00,0.00,2586.02,1613676.48,1766958.50,153282.02,445),('1','202','446','477',624.00,700.00,0.00,3286.55,2050807.20,2257285.50,206478.30,446),('1','202','447','477',624.00,700.00,0.00,1787.37,1115318.88,1222809.00,107490.12,447);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=437 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',436,'202','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=1037 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','202','436',1036,1,'477','LPG TANK ',28000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2021-12-25 17:45:15','2021-12-25 17:45:15','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','202',1036,7426.00,'2023-03-20 19:53:44');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2705257 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2612836,'1','202',NULL,477,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613913,'1','202','1036',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613914,'1','202',NULL,477,'Purchased from AA RANO NIGERIA LIMITED',0.00,12639510.00,24930.00,0.00,0.00,'2022-03-02 12:31:34','',''),(2613915,'1','202',NULL,477,'Reception corrector for bridging 1',0.00,0.00,0.00,24930.00,0.00,'2022-03-02 12:33:06','',''),(2613916,'1','202','1036',477,'Received from bridging 1',0.00,0.00,24930.00,0.00,0.00,'2022-03-02 12:33:06','',''),(2613917,'1','202','1036',477,'Retail Sale Id 1',1499.52,0.00,0.00,2.64,161.04,'2022-03-02 12:38:33','',''),(2613918,'1','202','1036',477,'Retail Sale Id 3',0.00,0.00,0.00,0.00,0.00,'2022-03-02 12:48:57','',''),(2613919,'1','202','1036',477,'Retail Sale Id 4',0.00,0.00,0.00,0.00,0.00,'2022-03-02 13:36:51','',''),(2613920,'1','202','1036',477,'Retail Sale Id 5',151718.48,0.00,0.00,267.11,16293.71,'2022-03-03 07:51:19','',''),(2613921,'1','202','1036',477,'Retail Sale Id 6',145309.20,0.00,0.00,284.92,854.76,'2022-03-03 08:11:59','',''),(2613922,'1','202','1036',477,'Return of Retail Sale Id 5',0.00,151718.48,267.11,0.00,-16293.71,'2022-03-03 08:13:15','',''),(2613923,'1','202','1036',477,'Retail Sale Id 7',94900.80,0.00,0.00,174.45,94900.80,'2022-03-03 08:17:47','',''),(2613924,'1','202','1036',477,'Retail Sale Id 8',6675.00,0.00,0.00,12.50,6675.00,'2022-03-03 08:45:10','',''),(2613925,'1','202','1036',477,'Retail Sale Id 9',6997.76,0.00,0.00,12.32,6997.76,'2022-03-03 09:23:01','',''),(2613926,'1','202','1036',477,'Retail Sale Id 10',1698.32,0.00,0.00,2.99,1698.32,'2022-03-03 09:26:12','',''),(2613927,'1','202','1036',477,'Retail Sale Id 11',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 09:31:59','',''),(2613928,'1','202','1036',477,'Retail Sale Id 12',2902.48,0.00,0.00,5.11,2902.48,'2022-03-03 09:32:43','',''),(2613929,'1','202','1036',477,'Retail Sale Id 13',999.68,0.00,0.00,1.76,999.68,'2022-03-03 09:39:28','',''),(2613930,'1','202','1036',477,'Retail Sale Id 14',2902.48,0.00,0.00,5.11,2902.48,'2022-03-03 09:44:41','',''),(2613931,'1','202','1036',477,'Retail Sale Id 15',999.68,0.00,0.00,1.76,999.68,'2022-03-03 09:46:19','',''),(2613932,'1','202','1036',477,'Retail Sale Id 16',7100.00,0.00,0.00,12.50,7100.00,'2022-03-03 09:59:46','',''),(2613933,'1','202','1036',477,'Retail Sale Id 17',7100.00,0.00,0.00,12.50,7100.00,'2022-03-03 10:00:45','',''),(2613934,'1','202','1036',477,'Retail Sale Id 18',3697.68,0.00,0.00,6.51,3697.68,'2022-03-03 10:20:30','',''),(2613935,'1','202','1036',477,'Retail Sale Id 19',28836.00,0.00,0.00,54.00,28836.00,'2022-03-03 11:05:30','',''),(2613936,'1','202','1036',477,'Retail Sale Id 20',1800.56,0.00,0.00,3.17,1800.56,'2022-03-03 11:44:58','',''),(2613937,'1','202','1036',477,'Retail Sale Id 21',6532.00,0.00,0.00,11.50,6532.00,'2022-03-03 12:20:50','',''),(2613938,'1','202','1036',477,'Retail Sale Id 22',7100.00,0.00,0.00,12.50,7100.00,'2022-03-03 13:24:42','',''),(2613939,'1','202','1036',477,'Retail Sale Id 23',2499.20,0.00,0.00,4.40,2499.20,'2022-03-03 13:26:02','',''),(2613940,'1','202','1036',477,'Retail Sale Id 24',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 13:49:22','',''),(2613941,'1','202','1036',477,'Retail Sale Id 25',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 14:16:14','',''),(2613942,'1','202','1036',477,'Retail Sale Id 26',1198.48,0.00,0.00,2.11,1198.48,'2022-03-03 14:50:35','',''),(2613943,'1','202','1036',477,'Retail Sale Id 27',7100.00,0.00,0.00,12.50,7100.00,'2022-03-03 14:51:43','',''),(2613944,'1','202','1036',477,'Retail Sale Id 28',5998.08,0.00,0.00,10.56,5998.08,'2022-03-03 14:52:38','',''),(2613945,'1','202','1036',477,'Retail Sale Id 29',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 15:01:11','',''),(2613946,'1','202','1036',477,'Retail Sale Id 30',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 15:02:11','',''),(2613947,'1','202','1036',477,'Retail Sale Id 31',8901.78,0.00,0.00,16.67,8901.78,'2022-03-03 15:05:14','',''),(2613948,'1','202','1036',477,'Retail Sale Id 32',2902.48,0.00,0.00,5.11,2902.48,'2022-03-03 15:06:55','',''),(2613949,'1','202','1036',477,'Retail Sale Id 33',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 16:01:33','',''),(2613950,'1','202','1036',477,'Retail Sale Id 34',1014283.28,0.00,0.00,1785.71,1014283.28,'2022-03-03 16:20:08','',''),(2613951,'1','202','1036',477,'Return of Retail Sale Id 34',0.00,1014283.28,1785.71,0.00,-1014283.28,'2022-03-03 16:23:01','',''),(2613952,'1','202','1036',477,'Retail Sale Id 35',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 16:23:52','',''),(2613953,'1','202','1036',477,'Retail Sale Id 37',7100.00,0.00,0.00,12.50,7100.00,'2022-03-03 16:38:03','',''),(2613954,'1','202','1036',477,'Retail Sale Id 38',3998.72,0.00,0.00,7.04,3998.72,'2022-03-03 16:38:55','',''),(2613955,'1','202','1036',477,'Retail Sale Id 39',7100.00,0.00,0.00,12.50,7100.00,'2022-03-03 16:43:14','',''),(2613956,'1','202','1036',477,'Retail Sale Id 40',7100.00,0.00,0.00,12.50,7100.00,'2022-03-03 16:51:54','',''),(2613957,'1','202','1036',477,'Retail Sale Id 41',1800.56,0.00,0.00,3.17,1800.56,'2022-03-03 16:57:18','',''),(2613958,'1','202','1036',477,'Retail Sale Id 42',1800.56,0.00,0.00,3.17,1800.56,'2022-03-03 16:58:03','',''),(2613959,'1','202','1036',477,'Retail Sale Id 43',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 16:59:03','',''),(2613960,'1','202','1036',477,'Retail Sale Id 44',1198.48,0.00,0.00,2.11,1198.48,'2022-03-03 17:03:44','',''),(2613961,'1','202','1036',477,'Retail Sale Id 45',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 17:25:51','',''),(2613962,'1','202','1036',477,'Retail Sale Id 46',37380.00,0.00,0.00,70.00,37380.00,'2022-03-03 17:35:09','',''),(2613963,'1','202','1036',477,'Retail Sale Id 47',2499.20,0.00,0.00,4.40,2499.20,'2022-03-03 17:45:35','',''),(2613964,'1','202','1036',477,'Retail Sale Id 48',1800.56,0.00,0.00,3.17,1800.56,'2022-03-03 17:52:04','',''),(2613965,'1','202','1036',477,'Retail Sale Id 49',1800.56,0.00,0.00,3.17,1800.56,'2022-03-03 17:58:31','',''),(2613966,'1','202','1036',477,'Retail Sale Id 50',3550.00,0.00,0.00,6.25,3550.00,'2022-03-03 18:01:19','',''),(2613967,'1','202','1036',477,'Retail Sale Id 51',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 18:04:58','',''),(2613968,'1','202','1036',477,'Retail Sale Id 52',2902.48,0.00,0.00,5.11,2902.48,'2022-03-03 18:11:04','',''),(2613969,'1','202','1036',477,'Retail Sale Id 53',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 18:22:47','',''),(2613970,'1','202','1036',477,'Retail Sale Id 54',2902.48,0.00,0.00,5.11,2902.48,'2022-03-03 18:29:00','',''),(2613971,'1','202','1036',477,'Retail Sale Id 55',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 18:42:49','',''),(2613972,'1','202','1036',477,'Retail Sale Id 56',1800.56,0.00,0.00,3.17,1800.56,'2022-03-03 18:48:11','',''),(2613973,'1','202','1036',477,'Retail Sale Id 57',7100.00,0.00,0.00,12.50,7100.00,'2022-03-03 18:51:02','',''),(2613974,'1','202','1036',477,'Retail Sale Id 58',1999.36,0.00,0.00,3.52,1999.36,'2022-03-03 18:55:23','',''),(2613975,'1','202','1036',477,'Retail Sale Id 59',3498.88,0.00,0.00,6.16,3498.88,'2022-03-03 19:14:02','',''),(2613976,'1','202','1036',477,'Retail Sale Id 60',38154.30,0.00,0.00,71.45,38154.30,'2022-03-03 19:28:12','',''),(2613977,'1','202','1036',477,'Retail Sale Id 61',33597.20,0.00,0.00,59.15,33597.20,'2022-03-03 19:30:00','',''),(2613978,'1','202','1036',477,'Retail Sale Id 62',999.68,0.00,0.00,1.76,999.68,'2022-03-04 07:28:45','',''),(2613979,'1','202','1036',477,'Retail Sale Id 63',2902.48,0.00,0.00,5.11,2902.48,'2022-03-04 07:29:54','',''),(2613980,'1','202','1036',477,'Retail Sale Id 64',5702.72,0.00,0.00,10.04,5702.72,'2022-03-04 07:30:59','',''),(2613981,'1','202','1036',477,'Retail Sale Id 65',1999.36,0.00,0.00,3.52,1999.36,'2022-03-04 07:32:03','',''),(2613982,'1','202','1036',477,'Retail Sale Id 66',2902.48,0.00,0.00,5.11,2902.48,'2022-03-04 07:35:59','',''),(2613983,'1','202','1036',477,'Retail Sale Id 67',5702.72,0.00,0.00,10.04,5702.72,'2022-03-04 07:39:13','',''),(2613984,'1','202','1036',477,'Retail Sale Id 68',7100.00,0.00,0.00,12.50,7100.00,'2022-03-04 08:34:03','',''),(2613985,'1','202','1036',477,'Retail Sale Id 69',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 08:35:17','',''),(2613986,'1','202','1036',477,'Retail Sale Id 70',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 08:50:33','',''),(2613987,'1','202','1036',477,'Retail Sale Id 71',7100.00,0.00,0.00,12.50,7100.00,'2022-03-04 08:55:20','',''),(2613988,'1','202','1036',477,'Retail Sale Id 72',2902.48,0.00,0.00,5.11,2902.48,'2022-03-04 08:57:48','',''),(2613989,'1','202','1036',477,'Retail Sale Id 73',7100.00,0.00,0.00,12.50,7100.00,'2022-03-04 08:58:59','',''),(2613990,'1','202','1036',477,'Retail Sale Id 74',7100.00,0.00,0.00,12.50,7100.00,'2022-03-04 09:07:52','',''),(2613991,'1','202','1036',477,'Retail Sale Id 75',999.68,0.00,0.00,1.76,999.68,'2022-03-04 09:24:12','',''),(2613992,'1','202','1036',477,'Retail Sale Id 76',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 09:28:39','',''),(2613993,'1','202','1036',477,'Retail Sale Id 77',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 09:53:39','',''),(2613994,'1','202','1036',477,'Retail Sale Id 78',1198.48,0.00,0.00,2.11,1198.48,'2022-03-04 09:57:54','',''),(2613995,'1','202','1036',477,'Retail Sale Id 79',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 10:08:35','',''),(2613996,'1','202','1036',477,'Retail Sale Id 80',6942.00,0.00,0.00,13.00,6942.00,'2022-03-04 10:17:06','',''),(2613997,'1','202','1036',477,'Retail Sale Id 81',1800.56,0.00,0.00,3.17,1800.56,'2022-03-04 10:18:04','',''),(2613998,'1','202','1036',477,'Retail Sale Id 82',1499.52,0.00,0.00,2.64,1499.52,'2022-03-04 10:20:42','',''),(2613999,'1','202','1036',477,'Retail Sale Id 83',7100.00,0.00,0.00,12.50,7100.00,'2022-03-04 10:44:03','',''),(2614000,'1','202','1036',477,'Retail Sale Id 84',2999.04,0.00,0.00,5.28,2999.04,'2022-03-04 11:20:16','',''),(2614001,'1','202','1036',477,'Retail Sale Id 85',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 11:24:35','',''),(2614002,'1','202','1036',477,'Retail Sale Id 86',7100.00,0.00,0.00,12.50,7100.00,'2022-03-04 11:55:21','',''),(2614003,'1','202','1036',477,'Retail Sale Id 87',7100.00,0.00,0.00,12.50,7100.00,'2022-03-04 11:59:31','',''),(2614004,'1','202','1036',477,'Retail Sale Id 88',1397.28,0.00,0.00,2.46,1397.28,'2022-03-04 12:00:12','',''),(2614005,'1','202','1036',477,'Retail Sale Id 89',6997.76,0.00,0.00,12.32,6997.76,'2022-03-04 12:08:08','',''),(2614006,'1','202','1036',477,'Retail Sale Id 90',5702.72,0.00,0.00,10.04,5702.72,'2022-03-04 12:37:08','',''),(2614007,'1','202','1036',477,'Retail Sale Id 91',1601.76,0.00,0.00,2.82,1601.76,'2022-03-04 12:51:59','',''),(2614008,'1','202','1036',477,'Retail Sale Id 92',3550.00,0.00,0.00,6.25,3550.00,'2022-03-04 13:01:54','',''),(2614009,'1','202','1036',477,'Retail Sale Id 93',7100.00,0.00,0.00,12.50,7100.00,'2022-03-04 13:06:09','',''),(2614010,'1','202','1036',477,'Retail Sale Id 94',999.68,0.00,0.00,1.76,999.68,'2022-03-04 13:56:43','',''),(2614011,'1','202','1036',477,'Retail Sale Id 95',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 14:12:15','',''),(2614012,'1','202','1036',477,'Retail Sale Id 96',2999.04,0.00,0.00,5.28,2999.04,'2022-03-04 15:16:56','',''),(2614013,'1','202','1036',477,'Retail Sale Id 97',999.68,0.00,0.00,1.76,999.68,'2022-03-04 15:24:18','',''),(2614014,'1','202','1036',477,'Retail Sale Id 98',499.84,0.00,0.00,0.88,499.84,'2022-03-04 15:25:27','',''),(2614015,'1','202','1036',477,'Retail Sale Id 99',2300.40,0.00,0.00,4.05,2300.40,'2022-03-04 15:45:27','',''),(2614016,'1','202','1036',477,'Retail Sale Id 99',4549.68,0.00,0.00,8.01,4549.68,'2022-03-04 15:45:27','',''),(2614017,'1','202','1036',477,'Retail Sale Id 100',999.68,0.00,0.00,1.76,999.68,'2022-03-04 15:47:07','',''),(2614018,'1','202','1036',477,'Retail Sale Id 101',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 15:59:12','',''),(2614019,'1','202','1036',477,'Retail Sale Id 102',2902.48,0.00,0.00,5.11,2902.48,'2022-03-04 16:24:45','',''),(2614020,'1','202','1036',477,'Retail Sale Id 103',999.68,0.00,0.00,1.76,999.68,'2022-03-04 16:30:54','',''),(2614021,'1','202','1036',477,'Retail Sale Id 104',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 16:31:44','',''),(2614022,'1','202','1036',477,'Retail Sale Id 105',1698.32,0.00,0.00,2.99,1698.32,'2022-03-04 16:54:07','',''),(2614023,'1','202','1036',477,'Retail Sale Id 108',7100.00,0.00,0.00,12.50,7100.00,'2022-03-04 16:59:48','',''),(2614024,'1','202','1036',477,'Retail Sale Id 109',1800.56,0.00,0.00,3.17,1800.56,'2022-03-04 17:15:28','',''),(2614025,'1','202','1036',477,'Retail Sale Id 110',2902.48,0.00,0.00,5.11,2902.48,'2022-03-04 17:20:25','',''),(2614026,'1','202','1036',477,'Retail Sale Id 111',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 17:29:41','',''),(2614027,'1','202','1036',477,'Retail Sale Id 112',1800.56,0.00,0.00,3.17,1800.56,'2022-03-04 17:30:26','',''),(2614028,'1','202','1036',477,'Retail Sale Id 113',1999.36,0.00,0.00,3.52,1999.36,'2022-03-04 17:31:11','',''),(2614029,'1','202','1036',477,'Retail Sale Id 114',897.44,0.00,0.00,1.58,897.44,'2022-03-04 17:39:50','',''),(2614030,'1','202','1036',477,'Retail Sale Id 115',3998.72,0.00,0.00,7.04,3998.72,'2022-03-04 17:42:01','',''),(2614031,'1','202','1036',477,'Retail Sale Id 116',2902.48,0.00,0.00,5.11,2902.48,'2022-03-04 17:48:59','',''),(2614032,'1','202','1036',477,'Retail Sale Id 117',2902.48,0.00,0.00,5.11,2902.48,'2022-03-04 17:51:37','',''),(2614033,'1','202','1036',477,'Retail Sale Id 118',999.68,0.00,0.00,1.76,999.68,'2022-03-04 18:00:16','',''),(2614034,'1','202','1036',477,'Retail Sale Id 119',3408.00,0.00,0.00,6.00,3408.00,'2022-03-04 18:03:25','',''),(2614035,'1','202','1036',477,'Retail Sale Id 120',999.68,0.00,0.00,1.76,999.68,'2022-03-04 18:11:26','',''),(2614036,'1','202','1036',477,'Retail Sale Id 121',1499.52,0.00,0.00,2.64,1499.52,'2022-03-04 18:23:36','',''),(2614037,'1','202','1036',477,'Retail Sale Id 122',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 18:25:09','',''),(2614038,'1','202','1036',477,'Retail Sale Id 123',1198.48,0.00,0.00,2.11,1198.48,'2022-03-04 18:27:48','',''),(2614039,'1','202','1036',477,'Retail Sale Id 124',1198.48,0.00,0.00,2.11,1198.48,'2022-03-04 18:32:53','',''),(2614040,'1','202','1036',477,'Retail Sale Id 125',3498.88,0.00,0.00,6.16,3498.88,'2022-03-04 18:35:53','',''),(2614041,'1','202','1036',477,'Retail Sale Id 126',14952.00,0.00,0.00,28.00,14952.00,'2022-03-04 19:00:12','',''),(2614042,'1','202','1036',477,'Return of Retail Sale Id 118',0.00,999.68,1.76,0.00,-999.68,'2022-03-04 19:21:08','',''),(2614043,'1','202','1036',477,'Return of Retail Sale Id 98',0.00,499.84,0.88,0.00,-499.84,'2022-03-04 19:26:53','',''),(2614044,'1','202','1036',477,'Retail Sale Id 127',2902.48,0.00,0.00,5.11,2902.48,'2022-03-05 06:57:56','',''),(2614045,'1','202','1036',477,'Retail Sale Id 128',1198.48,0.00,0.00,2.11,1198.48,'2022-03-05 07:20:41','',''),(2614046,'1','202','1036',477,'Retail Sale Id 129',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 07:24:47','',''),(2614047,'1','202','1036',477,'Retail Sale Id 130',999.68,0.00,0.00,1.76,999.68,'2022-03-05 07:30:03','',''),(2614048,'1','202','1036',477,'Retail Sale Id 131',31506.00,0.00,0.00,59.00,31506.00,'2022-03-05 07:33:13','',''),(2614049,'1','202','1036',477,'Retail Sale Id 132',7100.00,0.00,0.00,12.50,7100.00,'2022-03-05 07:34:24','',''),(2614050,'1','202','1036',477,'Retail Sale Id 133',2300.40,0.00,0.00,4.05,2300.40,'2022-03-05 07:39:31','',''),(2614051,'1','202','1036',477,'Retail Sale Id 134',6497.92,0.00,0.00,11.44,6497.92,'2022-03-05 07:40:42','',''),(2614052,'1','202','1036',477,'Retail Sale Id 135',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 07:52:19','',''),(2614053,'1','202','1036',477,'Retail Sale Id 136',5702.72,0.00,0.00,10.04,5702.72,'2022-03-05 08:05:18','',''),(2614054,'1','202','1036',477,'Retail Sale Id 137',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 08:07:23','',''),(2614055,'1','202','1036',477,'Retail Sale Id 138',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 08:08:49','',''),(2614056,'1','202','1036',477,'Retail Sale Id 139',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 08:14:43','',''),(2614057,'1','202','1036',477,'Retail Sale Id 140',2840.00,0.00,0.00,5.00,2840.00,'2022-03-05 08:17:32','',''),(2614058,'1','202','1036',477,'Retail Sale Id 141',602.08,0.00,0.00,1.06,602.08,'2022-03-05 08:20:54','',''),(2614059,'1','202','1036',477,'Retail Sale Id 142',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 08:25:34','',''),(2614060,'1','202','1036',477,'Retail Sale Id 143',2999.04,0.00,0.00,5.28,2999.04,'2022-03-05 08:26:50','',''),(2614061,'1','202','1036',477,'Retail Sale Id 144',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 08:28:54','',''),(2614062,'1','202','1036',477,'Retail Sale Id 145',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 08:33:45','',''),(2614063,'1','202','1036',477,'Retail Sale Id 146',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 08:35:49','',''),(2614064,'1','202','1036',477,'Retail Sale Id 147',2902.48,0.00,0.00,5.11,2902.48,'2022-03-05 08:37:08','',''),(2614065,'1','202','1036',477,'Retail Sale Id 148',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 08:42:45','',''),(2614066,'1','202','1036',477,'Retail Sale Id 150',6701.70,0.00,0.00,12.55,6701.70,'2022-03-05 08:52:19','',''),(2614067,'1','202','1036',477,'Retail Sale Id 152',2902.48,0.00,0.00,5.11,2902.48,'2022-03-05 08:57:52','',''),(2614068,'1','202','1036',477,'Retail Sale Id 154',1902.80,0.00,0.00,3.35,1902.80,'2022-03-05 09:05:16','',''),(2614069,'1','202','1036',477,'Retail Sale Id 155',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 09:06:21','',''),(2614070,'1','202','1036',477,'Retail Sale Id 156',2902.48,0.00,0.00,5.11,2902.48,'2022-03-05 09:08:14','',''),(2614071,'1','202','1036',477,'Retail Sale Id 158',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 09:17:08','',''),(2614072,'1','202','1036',477,'Retail Sale Id 159',7100.00,0.00,0.00,12.50,7100.00,'2022-03-05 09:18:23','',''),(2614073,'1','202','1036',477,'Retail Sale Id 160',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 09:21:16','',''),(2614074,'1','202','1036',477,'Retail Sale Id 161',4998.40,0.00,0.00,8.80,4998.40,'2022-03-05 09:21:54','',''),(2614075,'1','202','1036',477,'Retail Sale Id 162',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 09:22:31','',''),(2614076,'1','202','1036',477,'Return of Retail Sale Id 156',0.00,2902.48,5.11,0.00,-2902.48,'2022-03-05 09:24:31','',''),(2614077,'1','202','1036',477,'Retail Sale Id 163',1499.52,0.00,0.00,2.64,1499.52,'2022-03-05 09:25:51','',''),(2614078,'1','202','1036',477,'Retail Sale Id 157',7100.00,0.00,0.00,12.50,7100.00,'2022-03-05 09:27:24','',''),(2614079,'1','202','1036',477,'Retail Sale Id 164',2499.20,0.00,0.00,4.40,2499.20,'2022-03-05 09:35:08','',''),(2614080,'1','202','1036',477,'Retail Sale Id 165',999.68,0.00,0.00,1.76,999.68,'2022-03-05 09:39:55','',''),(2614081,'1','202','1036',477,'Retail Sale Id 166',2999.04,0.00,0.00,5.28,2999.04,'2022-03-05 09:41:11','',''),(2614082,'1','202','1036',477,'Retail Sale Id 167',2902.48,0.00,0.00,5.11,2902.48,'2022-03-05 09:51:06','',''),(2614083,'1','202','1036',477,'Retail Sale Id 168',1499.52,0.00,0.00,2.64,1499.52,'2022-03-05 10:17:17','',''),(2614084,'1','202','1036',477,'Retail Sale Id 169',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 10:20:14','',''),(2614085,'1','202','1036',477,'Retail Sale Id 170',4498.56,0.00,0.00,7.92,4498.56,'2022-03-05 10:21:13','',''),(2614086,'1','202','1036',477,'Retail Sale Id 171',800.88,0.00,0.00,1.41,800.88,'2022-03-05 10:29:00','',''),(2614087,'1','202','1036',477,'Retail Sale Id 173',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 10:29:43','',''),(2614088,'1','202','1036',477,'Retail Sale Id 174',2999.04,0.00,0.00,5.28,2999.04,'2022-03-05 10:36:19','',''),(2614089,'1','202','1036',477,'Retail Sale Id 175',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 10:37:36','',''),(2614090,'1','202','1036',477,'Retail Sale Id 176',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 10:42:54','',''),(2614091,'1','202','1036',477,'Retail Sale Id 178',1300.72,0.00,0.00,2.29,1300.72,'2022-03-05 10:49:39','',''),(2614092,'1','202','1036',477,'Retail Sale Id 180',2999.04,0.00,0.00,5.28,2999.04,'2022-03-05 10:55:11','',''),(2614093,'1','202','1036',477,'Retail Sale Id 181',2601.44,0.00,0.00,4.58,2601.44,'2022-03-05 10:58:11','',''),(2614094,'1','202','1036',477,'Retail Sale Id 182',7100.00,0.00,0.00,12.50,7100.00,'2022-03-05 11:01:58','',''),(2614095,'1','202','1036',477,'Retail Sale Id 183',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 11:07:20','',''),(2614096,'1','202','1036',477,'Retail Sale Id 184',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 11:07:51','',''),(2614097,'1','202','1036',477,'Retail Sale Id 185',7100.00,0.00,0.00,12.50,7100.00,'2022-03-05 11:08:57','',''),(2614098,'1','202','1036',477,'Retail Sale Id 186',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 11:10:39','',''),(2614099,'1','202','1036',477,'Retail Sale Id 187',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 11:18:39','',''),(2614100,'1','202','1036',477,'Retail Sale Id 188',32040.00,0.00,0.00,60.00,32040.00,'2022-03-05 11:22:58','',''),(2614101,'1','202','1036',477,'Retail Sale Id 189',499.84,0.00,0.00,0.88,499.84,'2022-03-05 11:39:19','',''),(2614102,'1','202','1036',477,'Retail Sale Id 190',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 11:40:15','',''),(2614103,'1','202','1036',477,'Retail Sale Id 191',7100.00,0.00,0.00,12.50,7100.00,'2022-03-05 11:56:43','',''),(2614104,'1','202','1036',477,'Retail Sale Id 192',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 12:00:22','',''),(2614105,'1','202','1036',477,'Retail Sale Id 193',20649.78,0.00,0.00,38.67,20649.78,'2022-03-05 12:04:17','',''),(2614106,'1','202','1036',477,'Retail Sale Id 194',2902.48,0.00,0.00,5.11,2902.48,'2022-03-05 12:05:59','',''),(2614107,'1','202','1036',477,'Retail Sale Id 195',4998.40,0.00,0.00,8.80,4998.40,'2022-03-05 12:10:40','',''),(2614108,'1','202','1036',477,'Retail Sale Id 196',31506.00,0.00,0.00,59.00,31506.00,'2022-03-05 12:25:44','',''),(2614109,'1','202','1036',477,'Retail Sale Id 197',2300.40,0.00,0.00,4.05,2300.40,'2022-03-05 12:39:05','',''),(2614110,'1','202','1036',477,'Retail Sale Id 198',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 12:46:21','',''),(2614111,'1','202','1036',477,'Retail Sale Id 199',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 13:07:27','',''),(2614112,'1','202','1036',477,'Retail Sale Id 200',32040.00,0.00,0.00,60.00,32040.00,'2022-03-05 13:15:42','',''),(2614113,'1','202','1036',477,'Retail Sale Id 201',999.68,0.00,0.00,1.76,999.68,'2022-03-05 13:17:57','',''),(2614114,'1','202','1036',477,'Retail Sale Id 202',2999.04,0.00,0.00,5.28,2999.04,'2022-03-05 13:19:00','',''),(2614115,'1','202','1036',477,'Retail Sale Id 203',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 13:24:41','',''),(2614116,'1','202','1036',477,'Retail Sale Id 204',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 13:31:41','',''),(2614117,'1','202','1036',477,'Retail Sale Id 205',999.68,0.00,0.00,1.76,999.68,'2022-03-05 13:35:32','',''),(2614118,'1','202','1036',477,'Retail Sale Id 206',7100.00,0.00,0.00,12.50,7100.00,'2022-03-05 13:37:36','',''),(2614119,'1','202','1036',477,'Retail Sale Id 207',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 13:41:10','',''),(2614120,'1','202','1036',477,'Retail Sale Id 208',999.68,0.00,0.00,1.76,999.68,'2022-03-05 13:42:59','',''),(2614121,'1','202','1036',477,'Retail Sale Id 209',1499.52,0.00,0.00,2.64,1499.52,'2022-03-05 13:45:48','',''),(2614122,'1','202','1036',477,'Retail Sale Id 210',28836.00,0.00,0.00,54.00,28836.00,'2022-03-05 14:04:13','',''),(2614123,'1','202','1036',477,'Retail Sale Id 211',7100.00,0.00,0.00,12.50,7100.00,'2022-03-05 14:21:09','',''),(2614124,'1','202','1036',477,'Retail Sale Id 212',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 14:25:49','',''),(2614125,'1','202','1036',477,'Retail Sale Id 213',3550.00,0.00,0.00,6.25,3550.00,'2022-03-05 14:29:49','',''),(2614126,'1','202','1036',477,'Retail Sale Id 214',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 14:40:46','',''),(2614127,'1','202','1036',477,'Retail Sale Id 215',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 14:42:33','',''),(2614128,'1','202','1036',477,'Retail Sale Id 216',2300.40,0.00,0.00,4.05,2300.40,'2022-03-05 14:47:33','',''),(2614129,'1','202','1036',477,'Retail Sale Id 217',2999.04,0.00,0.00,5.28,2999.04,'2022-03-05 14:49:37','',''),(2614130,'1','202','1036',477,'Retail Sale Id 218',568.00,0.00,0.00,1.00,568.00,'2022-03-05 14:51:25','',''),(2614131,'1','202','1036',477,'Retail Sale Id 219',7100.00,0.00,0.00,12.50,7100.00,'2022-03-05 14:55:05','',''),(2614132,'1','202','1036',477,'Return of Retail Sale Id 218',0.00,568.00,1.00,0.00,-568.00,'2022-03-05 14:56:25','',''),(2614133,'1','202','1036',477,'Retail Sale Id 220',2272.00,0.00,0.00,4.00,2272.00,'2022-03-05 14:58:41','',''),(2614134,'1','202','1036',477,'Retail Sale Id 221',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 15:08:03','',''),(2614135,'1','202','1036',477,'Retail Sale Id 222',2499.20,0.00,0.00,4.40,2499.20,'2022-03-05 15:09:09','',''),(2614136,'1','202','1036',477,'Retail Sale Id 223',1198.48,0.00,0.00,2.11,1198.48,'2022-03-05 15:13:00','',''),(2614137,'1','202','1036',477,'Retail Sale Id 224',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 15:22:01','',''),(2614138,'1','202','1036',477,'Retail Sale Id 225',999.68,0.00,0.00,1.76,999.68,'2022-03-05 15:23:10','',''),(2614139,'1','202','1036',477,'Retail Sale Id 226',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 15:24:34','',''),(2614140,'1','202','1036',477,'Retail Sale Id 227',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 15:28:26','',''),(2614141,'1','202','1036',477,'Retail Sale Id 228',2999.04,0.00,0.00,5.28,2999.04,'2022-03-05 16:35:35','',''),(2614142,'1','202','1036',477,'Retail Sale Id 229',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 16:46:12','',''),(2614143,'1','202','1036',477,'Retail Sale Id 230',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 16:47:38','',''),(2614144,'1','202','1036',477,'Retail Sale Id 231',12001.84,0.00,0.00,21.13,12001.84,'2022-03-05 16:51:19','',''),(2614145,'1','202','1036',477,'Retail Sale Id 232',6997.76,0.00,0.00,12.32,6997.76,'2022-03-05 16:54:50','',''),(2614146,'1','202','1036',477,'Retail Sale Id 233',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 16:55:49','',''),(2614147,'1','202','1036',477,'Retail Sale Id 234',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 16:59:27','',''),(2614148,'1','202','1036',477,'Retail Sale Id 235',1198.48,0.00,0.00,2.11,1198.48,'2022-03-05 17:10:38','',''),(2614149,'1','202','1036',477,'Retail Sale Id 236',1198.48,0.00,0.00,2.11,1198.48,'2022-03-05 17:14:19','',''),(2614150,'1','202','1036',477,'Retail Sale Id 237',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 17:15:59','',''),(2614151,'1','202','1036',477,'Retail Sale Id 238',999.68,0.00,0.00,1.76,999.68,'2022-03-05 17:16:45','',''),(2614152,'1','202','1036',477,'Retail Sale Id 239',1499.52,0.00,0.00,2.64,1499.52,'2022-03-05 17:17:36','',''),(2614153,'1','202','1036',477,'Retail Sale Id 240',2300.40,0.00,0.00,4.05,2300.40,'2022-03-05 17:18:41','',''),(2614154,'1','202','1036',477,'Retail Sale Id 242',2902.48,0.00,0.00,5.11,2902.48,'2022-03-05 17:23:44','',''),(2614155,'1','202','1036',477,'Retail Sale Id 243',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 17:25:32','',''),(2614156,'1','202','1036',477,'Retail Sale Id 246',1999.36,0.00,0.00,3.52,1999.36,'2022-03-05 17:44:26','',''),(2614157,'1','202','1036',477,'Retail Sale Id 247',1198.48,0.00,0.00,2.11,1198.48,'2022-03-05 17:51:30','',''),(2614158,'1','202','1036',477,'Retail Sale Id 248',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 17:54:56','',''),(2614159,'1','202','1036',477,'Retail Sale Id 249',19758.00,0.00,0.00,37.00,19758.00,'2022-03-05 17:57:50','',''),(2614160,'1','202','1036',477,'Retail Sale Id 251',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 18:01:27','',''),(2614161,'1','202','1036',477,'Retail Sale Id 252',4998.40,0.00,0.00,8.80,4998.40,'2022-03-05 18:07:36','',''),(2614162,'1','202','1036',477,'Retail Sale Id 253',1902.80,0.00,0.00,3.35,1902.80,'2022-03-05 18:24:40','',''),(2614163,'1','202','1036',477,'Retail Sale Id 254',1800.56,0.00,0.00,3.17,1800.56,'2022-03-05 18:35:22','',''),(2614164,'1','202','1036',477,'Retail Sale Id 255',3498.88,0.00,0.00,6.16,3498.88,'2022-03-05 18:37:02','',''),(2614165,'1','202','1036',477,'Retail Sale Id 256',2300.40,0.00,0.00,4.05,2300.40,'2022-03-05 18:37:53','',''),(2614166,'1','202','1036',477,'Retail Sale Id 257',4998.40,0.00,0.00,8.80,4998.40,'2022-03-05 18:40:23','',''),(2614167,'1','202','1036',477,'Retail Sale Id 258',2999.04,0.00,0.00,5.28,2999.04,'2022-03-05 19:00:40','',''),(2614168,'1','202','1036',477,'Retail Sale Id 259',2237.92,0.00,0.00,3.94,2237.92,'2022-03-05 19:28:33','',''),(2614169,'1','202','1036',477,'Retail Sale Id 260',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 07:02:18','',''),(2614170,'1','202','1036',477,'Retail Sale Id 261',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 07:05:51','',''),(2614171,'1','202','1036',477,'Retail Sale Id 262',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 07:08:23','',''),(2614172,'1','202','1036',477,'Retail Sale Id 263',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 07:09:19','',''),(2614173,'1','202','1036',477,'Retail Sale Id 264',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 07:10:19','',''),(2614174,'1','202','1036',477,'Retail Sale Id 265',4998.40,0.00,0.00,8.80,4998.40,'2022-03-06 07:18:52','',''),(2614175,'1','202','1036',477,'Retail Sale Id 266',999.68,0.00,0.00,1.76,999.68,'2022-03-06 07:19:59','',''),(2614176,'1','202','1036',477,'Retail Sale Id 268',8520.00,0.00,0.00,15.00,8520.00,'2022-03-06 07:33:52','',''),(2614177,'1','202','1036',477,'Retail Sale Id 269',3408.00,0.00,0.00,6.00,3408.00,'2022-03-06 07:43:22','',''),(2614178,'1','202','1036',477,'Retail Sale Id 270',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 07:48:25','',''),(2614179,'1','202','1036',477,'Retail Sale Id 271',1704.00,0.00,0.00,3.00,1704.00,'2022-03-06 08:07:19','',''),(2614180,'1','202','1036',477,'Retail Sale Id 272',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 08:14:54','',''),(2614181,'1','202','1036',477,'Retail Sale Id 273',4998.40,0.00,0.00,8.80,4998.40,'2022-03-06 08:16:19','',''),(2614182,'1','202','1036',477,'Retail Sale Id 274',1800.56,0.00,0.00,3.17,1800.56,'2022-03-06 08:27:19','',''),(2614183,'1','202','1036',477,'Retail Sale Id 275',1198.48,0.00,0.00,2.11,1198.48,'2022-03-06 08:28:44','',''),(2614184,'1','202','1036',477,'Retail Sale Id 277',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 08:34:55','',''),(2614185,'1','202','1036',477,'Retail Sale Id 278',9078.00,0.00,0.00,17.00,9078.00,'2022-03-06 08:43:49','',''),(2614186,'1','202','1036',477,'Retail Sale Id 279',1800.56,0.00,0.00,3.17,1800.56,'2022-03-06 08:48:49','',''),(2614187,'1','202','1036',477,'Retail Sale Id 280',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 08:57:24','',''),(2614188,'1','202','1036',477,'Retail Sale Id 282',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 09:15:39','',''),(2614189,'1','202','1036',477,'Retail Sale Id 283',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 09:24:39','',''),(2614190,'1','202','1036',477,'Retail Sale Id 284',999.68,0.00,0.00,1.76,999.68,'2022-03-06 09:25:51','',''),(2614191,'1','202','1036',477,'Retail Sale Id 285',999.68,0.00,0.00,1.76,999.68,'2022-03-06 09:31:52','',''),(2614192,'1','202','1036',477,'Retail Sale Id 286',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 09:35:34','',''),(2614193,'1','202','1036',477,'Retail Sale Id 287',2499.20,0.00,0.00,4.40,2499.20,'2022-03-06 09:36:25','',''),(2614194,'1','202','1036',477,'Retail Sale Id 288',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 09:42:49','',''),(2614195,'1','202','1036',477,'Retail Sale Id 289',53400.00,0.00,0.00,100.00,53400.00,'2022-03-06 09:46:07','',''),(2614196,'1','202','1036',477,'Retail Sale Id 290',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 09:47:25','',''),(2614197,'1','202','1036',477,'Retail Sale Id 291',26700.00,0.00,0.00,50.00,26700.00,'2022-03-06 09:53:24','',''),(2614198,'1','202','1036',477,'Retail Sale Id 292',2499.20,0.00,0.00,4.40,2499.20,'2022-03-06 09:54:32','',''),(2614199,'1','202','1036',477,'Retail Sale Id 293',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 09:55:11','',''),(2614200,'1','202','1036',477,'Retail Sale Id 294',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 09:56:04','',''),(2614201,'1','202','1036',477,'Retail Sale Id 295',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 09:57:56','',''),(2614202,'1','202','1036',477,'Retail Sale Id 296',999.68,0.00,0.00,1.76,999.68,'2022-03-06 10:04:48','',''),(2614203,'1','202','1036',477,'Retail Sale Id 297',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 10:05:34','',''),(2614204,'1','202','1036',477,'Retail Sale Id 298',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 10:06:22','',''),(2614205,'1','202','1036',477,'Retail Sale Id 299',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 10:07:21','',''),(2614206,'1','202','1036',477,'Retail Sale Id 300',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 10:08:11','',''),(2614207,'1','202','1036',477,'Retail Sale Id 301',5702.72,0.00,0.00,10.04,5702.72,'2022-03-06 10:08:49','',''),(2614208,'1','202','1036',477,'Retail Sale Id 302',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 10:09:29','',''),(2614209,'1','202','1036',477,'Retail Sale Id 304',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 10:10:03','',''),(2614210,'1','202','1036',477,'Retail Sale Id 305',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 10:10:39','',''),(2614211,'1','202','1036',477,'Retail Sale Id 306',698.64,0.00,0.00,1.23,698.64,'2022-03-06 10:11:24','',''),(2614212,'1','202','1036',477,'Retail Sale Id 307',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 10:11:28','',''),(2614213,'1','202','1036',477,'Retail Sale Id 308',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 10:16:42','',''),(2614214,'1','202','1036',477,'Retail Sale Id 309',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 10:18:24','',''),(2614215,'1','202','1036',477,'Retail Sale Id 310',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 10:20:02','',''),(2614216,'1','202','1036',477,'Retail Sale Id 311',1800.56,0.00,0.00,3.17,1800.56,'2022-03-06 10:24:06','',''),(2614217,'1','202','1036',477,'Retail Sale Id 312',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 10:39:00','',''),(2614218,'1','202','1036',477,'Retail Sale Id 313',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 10:39:42','',''),(2614219,'1','202','1036',477,'Retail Sale Id 314',1499.52,0.00,0.00,2.64,1499.52,'2022-03-06 10:41:52','',''),(2614220,'1','202','1036',477,'Retail Sale Id 315',6497.92,0.00,0.00,11.44,6497.92,'2022-03-06 10:46:52','',''),(2614221,'1','202','1036',477,'Retail Sale Id 316',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 10:48:14','',''),(2614222,'1','202','1036',477,'Retail Sale Id 317',999.68,0.00,0.00,1.76,999.68,'2022-03-06 10:50:17','',''),(2614223,'1','202','1036',477,'Retail Sale Id 318',2101.60,0.00,0.00,3.70,2101.60,'2022-03-06 10:53:42','',''),(2614224,'1','202','1036',477,'Retail Sale Id 319',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 10:55:33','',''),(2614225,'1','202','1036',477,'Retail Sale Id 320',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 10:57:48','',''),(2614226,'1','202','1036',477,'Retail Sale Id 321',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 11:01:24','',''),(2614227,'1','202','1036',477,'Retail Sale Id 322',26700.00,0.00,0.00,50.00,26700.00,'2022-03-06 11:22:36','',''),(2614228,'1','202','1036',477,'Retail Sale Id 323',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 11:24:17','',''),(2614229,'1','202','1036',477,'Retail Sale Id 324',8520.00,0.00,0.00,15.00,8520.00,'2022-03-06 11:26:18','',''),(2614230,'1','202','1036',477,'Retail Sale Id 325',1136.00,0.00,0.00,2.00,1136.00,'2022-03-06 11:27:44','',''),(2614231,'1','202','1036',477,'Retail Sale Id 327',3998.72,0.00,0.00,7.04,3998.72,'2022-03-06 11:34:04','',''),(2614232,'1','202','1036',477,'Retail Sale Id 328',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 11:38:10','',''),(2614233,'1','202','1036',477,'Retail Sale Id 329',3998.72,0.00,0.00,7.04,3998.72,'2022-03-06 11:45:30','',''),(2614234,'1','202','1036',477,'Retail Sale Id 330',999.68,0.00,0.00,1.76,999.68,'2022-03-06 11:47:53','',''),(2614235,'1','202','1036',477,'Retail Sale Id 332',1198.48,0.00,0.00,2.11,1198.48,'2022-03-06 11:51:52','',''),(2614236,'1','202','1036',477,'Retail Sale Id 333',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 11:56:05','',''),(2614237,'1','202','1036',477,'Retail Sale Id 335',2300.40,0.00,0.00,4.05,2300.40,'2022-03-06 12:06:18','',''),(2614238,'1','202','1036',477,'Retail Sale Id 336',999.68,0.00,0.00,1.76,999.68,'2022-03-06 12:19:21','',''),(2614239,'1','202','1036',477,'Retail Sale Id 337',2499.20,0.00,0.00,4.40,2499.20,'2022-03-06 12:20:35','',''),(2614240,'1','202','1036',477,'Retail Sale Id 338',999.68,0.00,0.00,1.76,999.68,'2022-03-06 12:23:58','',''),(2614241,'1','202','1036',477,'Retail Sale Id 339',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 12:28:42','',''),(2614242,'1','202','1036',477,'Retail Sale Id 340',3998.72,0.00,0.00,7.04,3998.72,'2022-03-06 12:33:35','',''),(2614243,'1','202','1036',477,'Retail Sale Id 341',1698.32,0.00,0.00,2.99,1698.32,'2022-03-06 12:43:45','',''),(2614244,'1','202','1036',477,'Retail Sale Id 343',5998.08,0.00,0.00,10.56,5998.08,'2022-03-06 13:07:13','',''),(2614245,'1','202','1036',477,'Retail Sale Id 344',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 13:13:52','',''),(2614246,'1','202','1036',477,'Retail Sale Id 345',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 13:22:14','',''),(2614247,'1','202','1036',477,'Retail Sale Id 346',800.88,0.00,0.00,1.41,800.88,'2022-03-06 13:23:27','',''),(2614248,'1','202','1036',477,'Retail Sale Id 347',3998.72,0.00,0.00,7.04,3998.72,'2022-03-06 13:24:48','',''),(2614249,'1','202','1036',477,'Retail Sale Id 348',999.68,0.00,0.00,1.76,999.68,'2022-03-06 13:26:03','',''),(2614250,'1','202','1036',477,'Retail Sale Id 349',1800.56,0.00,0.00,3.17,1800.56,'2022-03-06 13:42:04','',''),(2614251,'1','202','1036',477,'Retail Sale Id 350',1800.56,0.00,0.00,3.17,1800.56,'2022-03-06 13:43:21','',''),(2614252,'1','202','1036',477,'Retail Sale Id 351',29370.00,0.00,0.00,55.00,29370.00,'2022-03-06 13:45:30','',''),(2614253,'1','202','1036',477,'Retail Sale Id 352',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 13:47:12','',''),(2614254,'1','202','1036',477,'Retail Sale Id 353',1499.52,0.00,0.00,2.64,1499.52,'2022-03-06 13:51:11','',''),(2614255,'1','202','1036',477,'Retail Sale Id 354',17040.00,0.00,0.00,30.00,17040.00,'2022-03-06 13:52:08','',''),(2614256,'1','202','1036',477,'Retail Sale Id 355',1499.52,0.00,0.00,2.64,1499.52,'2022-03-06 13:52:54','',''),(2614257,'1','202','1036',477,'Retail Sale Id 356',1198.48,0.00,0.00,2.11,1198.48,'2022-03-06 13:53:44','',''),(2614258,'1','202','1036',477,'Retail Sale Id 357',1198.48,0.00,0.00,2.11,1198.48,'2022-03-06 13:56:44','',''),(2614259,'1','202','1036',477,'Retail Sale Id 358',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 14:00:47','',''),(2614260,'1','202','1036',477,'Retail Sale Id 359',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 14:03:20','',''),(2614261,'1','202','1036',477,'Retail Sale Id 361',999.68,0.00,0.00,1.76,999.68,'2022-03-06 14:06:23','',''),(2614262,'1','202','1036',477,'Retail Sale Id 362',2402.64,0.00,0.00,4.23,2402.64,'2022-03-06 14:07:37','',''),(2614263,'1','202','1036',477,'Retail Sale Id 363',602.08,0.00,0.00,1.06,602.08,'2022-03-06 14:08:23','',''),(2614264,'1','202','1036',477,'Retail Sale Id 364',1800.56,0.00,0.00,3.17,1800.56,'2022-03-06 14:09:41','',''),(2614265,'1','202','1036',477,'Retail Sale Id 365',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 14:17:51','',''),(2614266,'1','202','1036',477,'Retail Sale Id 366',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 14:29:50','',''),(2614267,'1','202','1036',477,'Retail Sale Id 367',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 14:46:49','',''),(2614268,'1','202','1036',477,'Retail Sale Id 368',3408.00,0.00,0.00,6.00,3408.00,'2022-03-06 14:47:45','',''),(2614269,'1','202','1036',477,'Retail Sale Id 369',1397.28,0.00,0.00,2.46,1397.28,'2022-03-06 15:00:33','',''),(2614270,'1','202','1036',477,'Retail Sale Id 370',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 15:09:43','',''),(2614271,'1','202','1036',477,'Retail Sale Id 371',1800.56,0.00,0.00,3.17,1800.56,'2022-03-06 15:10:53','',''),(2614272,'1','202','1036',477,'Retail Sale Id 372',999.68,0.00,0.00,1.76,999.68,'2022-03-06 15:23:42','',''),(2614273,'1','202','1036',477,'Retail Sale Id 373',1800.56,0.00,0.00,3.17,1800.56,'2022-03-06 15:36:42','',''),(2614274,'1','202','1036',477,'Retail Sale Id 374',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 15:50:33','',''),(2614275,'1','202','1036',477,'Retail Sale Id 375',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 16:19:37','',''),(2614276,'1','202','1036',477,'Retail Sale Id 376',1698.32,0.00,0.00,2.99,1698.32,'2022-03-06 16:23:08','',''),(2614277,'1','202','1036',477,'Retail Sale Id 377',1198.48,0.00,0.00,2.11,1198.48,'2022-03-06 16:24:39','',''),(2614278,'1','202','1036',477,'Retail Sale Id 378',1698.32,0.00,0.00,2.99,1698.32,'2022-03-06 16:34:01','',''),(2614279,'1','202','1036',477,'Retail Sale Id 379',1300.72,0.00,0.00,2.29,1300.72,'2022-03-06 16:36:47','',''),(2614280,'1','202','1036',477,'Retail Sale Id 380',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 16:40:45','',''),(2614281,'1','202','1036',477,'Retail Sale Id 381',1198.48,0.00,0.00,2.11,1198.48,'2022-03-06 16:41:43','',''),(2614282,'1','202','1036',477,'Retail Sale Id 382',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 16:42:52','',''),(2614283,'1','202','1036',477,'Retail Sale Id 383',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 16:48:32','',''),(2614284,'1','202','1036',477,'Retail Sale Id 384',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 16:57:03','',''),(2614285,'1','202','1036',477,'Retail Sale Id 385',2800.24,0.00,0.00,4.93,2800.24,'2022-03-06 16:58:14','',''),(2614286,'1','202','1036',477,'Retail Sale Id 386',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 16:59:19','',''),(2614287,'1','202','1036',477,'Retail Sale Id 387',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 17:00:13','',''),(2614288,'1','202','1036',477,'Retail Sale Id 388',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 17:01:12','',''),(2614289,'1','202','1036',477,'Retail Sale Id 389',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 17:01:59','',''),(2614290,'1','202','1036',477,'Retail Sale Id 391',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 17:04:24','',''),(2614291,'1','202','1036',477,'Retail Sale Id 392',57672.00,0.00,0.00,108.00,57672.00,'2022-03-06 17:08:38','',''),(2614292,'1','202','1036',477,'Retail Sale Id 393',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 17:09:12','',''),(2614293,'1','202','1036',477,'Retail Sale Id 394',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 17:10:14','',''),(2614294,'1','202','1036',477,'Retail Sale Id 395',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 17:10:58','',''),(2614295,'1','202','1036',477,'Retail Sale Id 396',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 17:12:05','',''),(2614296,'1','202','1036',477,'Retail Sale Id 397',9078.00,0.00,0.00,17.00,9078.00,'2022-03-06 17:13:52','',''),(2614297,'1','202','1036',477,'Retail Sale Id 398',1499.52,0.00,0.00,2.64,1499.52,'2022-03-06 17:14:31','',''),(2614298,'1','202','1036',477,'Retail Sale Id 399',698.64,0.00,0.00,1.23,698.64,'2022-03-06 17:17:22','',''),(2614299,'1','202','1036',477,'Retail Sale Id 400',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 17:21:57','',''),(2614300,'1','202','1036',477,'Retail Sale Id 401',1300.72,0.00,0.00,2.29,1300.72,'2022-03-06 17:22:50','',''),(2614301,'1','202','1036',477,'Retail Sale Id 402',2499.20,0.00,0.00,4.40,2499.20,'2022-03-06 17:23:41','',''),(2614302,'1','202','1036',477,'Retail Sale Id 403',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 17:25:41','',''),(2614303,'1','202','1036',477,'Retail Sale Id 404',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 17:26:31','',''),(2614304,'1','202','1036',477,'Retail Sale Id 405',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 17:28:26','',''),(2614305,'1','202','1036',477,'Retail Sale Id 406',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 17:29:41','',''),(2614306,'1','202','1036',477,'Retail Sale Id 407',999.68,0.00,0.00,1.76,999.68,'2022-03-06 17:30:43','',''),(2614307,'1','202','1036',477,'Retail Sale Id 408',1198.48,0.00,0.00,2.11,1198.48,'2022-03-06 17:31:32','',''),(2614308,'1','202','1036',477,'Retail Sale Id 409',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 17:32:50','',''),(2614309,'1','202','1036',477,'Retail Sale Id 410',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 17:34:20','',''),(2614310,'1','202','1036',477,'Retail Sale Id 411',1198.48,0.00,0.00,2.11,1198.48,'2022-03-06 17:35:55','',''),(2614311,'1','202','1036',477,'Retail Sale Id 413',1499.52,0.00,0.00,2.64,1499.52,'2022-03-06 17:43:57','',''),(2614312,'1','202','1036',477,'Retail Sale Id 414',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 17:44:48','',''),(2614313,'1','202','1036',477,'Retail Sale Id 415',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 17:46:17','',''),(2614314,'1','202','1036',477,'Retail Sale Id 416',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 17:48:02','',''),(2614315,'1','202','1036',477,'Retail Sale Id 417',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 17:48:53','',''),(2614316,'1','202','1036',477,'Retail Sale Id 418',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 17:50:18','',''),(2614317,'1','202','1036',477,'Retail Sale Id 419',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 18:06:12','',''),(2614318,'1','202','1036',477,'Retail Sale Id 420',897.44,0.00,0.00,1.58,897.44,'2022-03-06 18:14:51','',''),(2614319,'1','202','1036',477,'Retail Sale Id 421',7100.00,0.00,0.00,12.50,7100.00,'2022-03-06 18:16:20','',''),(2614320,'1','202','1036',477,'Retail Sale Id 422',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 18:23:33','',''),(2614321,'1','202','1036',477,'Retail Sale Id 423',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 18:24:32','',''),(2614322,'1','202','1036',477,'Retail Sale Id 424',1499.52,0.00,0.00,2.64,1499.52,'2022-03-06 18:28:02','',''),(2614323,'1','202','1036',477,'Retail Sale Id 426',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 18:44:58','',''),(2614324,'1','202','1036',477,'Retail Sale Id 427',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 18:56:36','',''),(2614325,'1','202','1036',477,'Retail Sale Id 428',1999.36,0.00,0.00,3.52,1999.36,'2022-03-06 18:58:34','',''),(2614326,'1','202','1036',477,'Retail Sale Id 429',2902.48,0.00,0.00,5.11,2902.48,'2022-03-06 18:59:26','',''),(2614327,'1','202','1036',477,'Retail Sale Id 430',1499.52,0.00,0.00,2.64,1499.52,'2022-03-06 19:01:55','',''),(2614328,'1','202','1036',477,'Retail Sale Id 431',540675.00,0.00,0.00,1012.50,540675.00,'2022-03-06 19:10:51','',''),(2614329,'1','202','1036',477,'Retail Sale Id 432',3498.88,0.00,0.00,6.16,3498.88,'2022-03-06 19:11:30','',''),(2614330,'1','202','1036',477,'Retail Sale Id 433',2999.04,0.00,0.00,5.28,2999.04,'2022-03-06 19:24:07','',''),(2614331,'1','202','1036',477,'Retail Sale Id 434',999.68,0.00,0.00,1.76,999.68,'2022-03-06 19:29:11','',''),(2614332,'1','202','1036',477,'Retail Sale Id 435',1300.72,0.00,0.00,2.29,1300.72,'2022-03-06 19:32:33','',''),(2614333,'1','202','1036',477,'Retail Sale Id 436',1499.52,0.00,0.00,2.64,1499.52,'2022-03-06 19:39:43','',''),(2614334,'1','202','1036',477,'Retail Sale Id 437',1800.56,0.00,0.00,3.17,1800.56,'2022-03-06 19:45:34','',''),(2614335,'1','202','1036',477,'Retail Sale Id 438',647.52,0.00,0.00,1.14,647.52,'2022-03-06 20:10:43','',''),(2614336,'1','202','1036',477,'Retail Sale Id 439',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 07:20:42','',''),(2614337,'1','202','1036',477,'Retail Sale Id 440',800.88,0.00,0.00,1.41,800.88,'2022-03-07 07:27:32','',''),(2614338,'1','202','1036',477,'Retail Sale Id 441',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 07:47:14','',''),(2614339,'1','202','1036',477,'Retail Sale Id 444',2300.40,0.00,0.00,4.05,2300.40,'2022-03-07 07:51:51','',''),(2614340,'1','202','1036',477,'Retail Sale Id 445',1999.36,0.00,0.00,3.52,1999.36,'2022-03-07 07:52:51','',''),(2614341,'1','202','1036',477,'Retail Sale Id 446',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 07:54:25','',''),(2614342,'1','202','1036',477,'Retail Sale Id 447',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 07:59:34','',''),(2614343,'1','202','1036',477,'Retail Sale Id 448',2999.04,0.00,0.00,5.28,2999.04,'2022-03-07 08:03:26','',''),(2614344,'1','202','1036',477,'Retail Sale Id 449',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 08:12:05','',''),(2614345,'1','202','1036',477,'Retail Sale Id 450',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 08:15:23','',''),(2614346,'1','202','1036',477,'Retail Sale Id 451',1198.48,0.00,0.00,2.11,1198.48,'2022-03-07 08:16:58','',''),(2614347,'1','202','1036',477,'Retail Sale Id 452',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 08:33:45','',''),(2614348,'1','202','1036',477,'Retail Sale Id 453',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 08:37:04','',''),(2614349,'1','202','1036',477,'Retail Sale Id 454',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 08:39:52','',''),(2614350,'1','202','1036',477,'Retail Sale Id 455',3300.08,0.00,0.00,5.81,3300.08,'2022-03-07 08:42:30','',''),(2614351,'1','202','1036',477,'Retail Sale Id 456',26700.00,0.00,0.00,50.00,26700.00,'2022-03-07 08:44:32','',''),(2614352,'1','202','1036',477,'Retail Sale Id 457',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 08:59:19','',''),(2614353,'1','202','1036',477,'Retail Sale Id 458',3998.72,0.00,0.00,7.04,3998.72,'2022-03-07 09:00:19','',''),(2614354,'1','202','1036',477,'Retail Sale Id 459',1198.48,0.00,0.00,2.11,1198.48,'2022-03-07 09:03:05','',''),(2614355,'1','202','1036',477,'Retail Sale Id 460',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 09:04:40','',''),(2614356,'1','202','1036',477,'Retail Sale Id 461',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 09:06:26','',''),(2614357,'1','202','1036',477,'Retail Sale Id 462',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 09:07:19','',''),(2614358,'1','202','1036',477,'Retail Sale Id 463',999.68,0.00,0.00,1.76,999.68,'2022-03-07 09:08:44','',''),(2614359,'1','202','1036',477,'Retail Sale Id 464',32040.00,0.00,0.00,60.00,32040.00,'2022-03-07 09:10:58','',''),(2614360,'1','202','1036',477,'Retail Sale Id 465',5998.08,0.00,0.00,10.56,5998.08,'2022-03-07 09:13:04','',''),(2614361,'1','202','1036',477,'Retail Sale Id 466',1999.36,0.00,0.00,3.52,1999.36,'2022-03-07 09:16:13','',''),(2614362,'1','202','1036',477,'Retail Sale Id 467',999.68,0.00,0.00,1.76,999.68,'2022-03-07 09:20:48','',''),(2614363,'1','202','1036',477,'Retail Sale Id 468',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 09:23:54','',''),(2614364,'1','202','1036',477,'Retail Sale Id 469',2999.04,0.00,0.00,5.28,2999.04,'2022-03-07 09:25:38','',''),(2614365,'1','202','1036',477,'Retail Sale Id 470',29370.00,0.00,0.00,55.00,29370.00,'2022-03-07 09:33:11','',''),(2614366,'1','202','1036',477,'Retail Sale Id 471',1999.36,0.00,0.00,3.52,1999.36,'2022-03-07 09:35:41','',''),(2614367,'1','202','1036',477,'Retail Sale Id 472',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 09:44:29','',''),(2614368,'1','202','1036',477,'Retail Sale Id 473',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 09:47:02','',''),(2614369,'1','202','1036',477,'Retail Sale Id 474',3500.00,0.00,0.00,1.00,3500.00,'2022-03-07 10:11:49','',''),(2614370,'1','202','1036',477,'Retail Sale Id 475',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 10:21:29','',''),(2614371,'1','202','1036',477,'Retail Sale Id 477',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 10:24:16','',''),(2614372,'1','202','1036',477,'Retail Sale Id 476',26700.00,0.00,0.00,50.00,26700.00,'2022-03-07 10:30:18','',''),(2614373,'1','202','1036',477,'Retail Sale Id 478',7476.00,0.00,0.00,14.00,7476.00,'2022-03-07 10:34:01','',''),(2614374,'1','202','1036',477,'Retail Sale Id 479',4998.40,0.00,0.00,8.80,4998.40,'2022-03-07 10:37:24','',''),(2614375,'1','202','1036',477,'Retail Sale Id 480',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 10:41:45','',''),(2614376,'1','202','1036',477,'Retail Sale Id 481',26700.00,0.00,0.00,50.00,26700.00,'2022-03-07 10:47:49','',''),(2614377,'1','202','1036',477,'Retail Sale Id 482',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 10:56:22','',''),(2614378,'1','202','1036',477,'Retail Sale Id 483',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 11:02:57','',''),(2614379,'1','202','1036',477,'Retail Sale Id 484',999.68,0.00,0.00,1.76,999.68,'2022-03-07 11:14:42','',''),(2614380,'1','202','1036',477,'Retail Sale Id 485',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 11:16:16','',''),(2614381,'1','202','1036',477,'Retail Sale Id 486',698.64,0.00,0.00,1.23,698.64,'2022-03-07 11:24:26','',''),(2614382,'1','202','1036',477,'Retail Sale Id 487',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 11:31:21','',''),(2614383,'1','202','1036',477,'Retail Sale Id 488',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 11:58:05','',''),(2614384,'1','202','1036',477,'Retail Sale Id 489',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 11:59:34','',''),(2614385,'1','202','1036',477,'Retail Sale Id 490',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 12:00:28','',''),(2614386,'1','202','1036',477,'Retail Sale Id 491',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 12:18:10','',''),(2614387,'1','202','1036',477,'Retail Sale Id 492',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 12:19:09','',''),(2614388,'1','202','1036',477,'Retail Sale Id 493',999.68,0.00,0.00,1.76,999.68,'2022-03-07 12:27:21','',''),(2614389,'1','202','1036',477,'Retail Sale Id 494',31506.00,0.00,0.00,59.00,31506.00,'2022-03-07 12:35:40','',''),(2614390,'1','202','1036',477,'Retail Sale Id 495',1999.36,0.00,0.00,3.52,1999.36,'2022-03-07 12:37:05','',''),(2614391,'1','202','1036',477,'Retail Sale Id 496',6675.00,0.00,0.00,12.50,6675.00,'2022-03-07 12:38:50','',''),(2614392,'1','202','1036',477,'Retail Sale Id 497',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 12:48:09','',''),(2614393,'1','202','1036',477,'Retail Sale Id 498',21360.00,0.00,0.00,40.00,21360.00,'2022-03-07 12:52:18','',''),(2614394,'1','202','1036',477,'Retail Sale Id 499',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 13:14:59','',''),(2614395,'1','202','1036',477,'Retail Sale Id 500',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 13:35:11','',''),(2614396,'1','202','1036',477,'Retail Sale Id 501',28302.00,0.00,0.00,53.00,28302.00,'2022-03-07 13:46:44','',''),(2614397,'1','202','1036',477,'Retail Sale Id 502',2499.20,0.00,0.00,4.40,2499.20,'2022-03-07 14:06:42','',''),(2614398,'1','202','1036',477,'Retail Sale Id 503',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 14:30:58','',''),(2614399,'1','202','1036',477,'Retail Sale Id 504',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 15:16:36','',''),(2614400,'1','202','1036',477,'Retail Sale Id 505',1198.48,0.00,0.00,2.11,1198.48,'2022-03-07 15:28:29','',''),(2614401,'1','202','1036',477,'Retail Sale Id 506',999.68,0.00,0.00,1.76,999.68,'2022-03-07 15:38:00','',''),(2614402,'1','202','1036',477,'Retail Sale Id 507',2499.20,0.00,0.00,4.40,2499.20,'2022-03-07 15:40:47','',''),(2614403,'1','202','1036',477,'Retail Sale Id 508',26700.00,0.00,0.00,50.00,26700.00,'2022-03-07 15:51:08','',''),(2614404,'1','202','1036',477,'Retail Sale Id 509',19758.00,0.00,0.00,37.00,19758.00,'2022-03-07 15:54:14','',''),(2614405,'1','202','1036',477,'Retail Sale Id 510',1499.52,0.00,0.00,2.64,1499.52,'2022-03-07 15:58:53','',''),(2614406,'1','202','1036',477,'Retail Sale Id 511',1499.52,0.00,0.00,2.64,1499.52,'2022-03-07 16:00:14','',''),(2614407,'1','202','1036',477,'Retail Sale Id 512',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 16:04:19','',''),(2614408,'1','202','1036',477,'Retail Sale Id 513',2999.04,0.00,0.00,5.28,2999.04,'2022-03-07 16:05:40','',''),(2614409,'1','202','1036',477,'Retail Sale Id 514',1999.36,0.00,0.00,3.52,1999.36,'2022-03-07 16:07:51','',''),(2614410,'1','202','1036',477,'Retail Sale Id 515',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 16:10:04','',''),(2614411,'1','202','1036',477,'Retail Sale Id 516',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 16:22:34','',''),(2614412,'1','202','1036',477,'Retail Sale Id 517',2300.40,0.00,0.00,4.05,2300.40,'2022-03-07 16:25:01','',''),(2614413,'1','202','1036',477,'Retail Sale Id 518',1300.72,0.00,0.00,2.29,1300.72,'2022-03-07 16:27:02','',''),(2614414,'1','202','1036',477,'Retail Sale Id 519',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 16:28:24','',''),(2614415,'1','202','1036',477,'Retail Sale Id 520',1999.36,0.00,0.00,3.52,1999.36,'2022-03-07 16:29:14','',''),(2614416,'1','202','1036',477,'Retail Sale Id 521',1999.36,0.00,0.00,3.52,1999.36,'2022-03-07 16:30:16','',''),(2614417,'1','202','1036',477,'Retail Sale Id 522',1198.48,0.00,0.00,2.11,1198.48,'2022-03-07 16:31:07','',''),(2614418,'1','202','1036',477,'Retail Sale Id 523',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 16:48:14','',''),(2614419,'1','202','1036',477,'Retail Sale Id 524',1198.48,0.00,0.00,2.11,1198.48,'2022-03-07 16:49:13','',''),(2614420,'1','202','1036',477,'Retail Sale Id 525',1499.52,0.00,0.00,2.64,1499.52,'2022-03-07 16:56:49','',''),(2614421,'1','202','1036',477,'Retail Sale Id 526',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 17:00:38','',''),(2614422,'1','202','1036',477,'Retail Sale Id 527',3998.72,0.00,0.00,7.04,3998.72,'2022-03-07 17:05:43','',''),(2614423,'1','202','1036',477,'Retail Sale Id 528',2300.40,0.00,0.00,4.05,2300.40,'2022-03-07 17:28:52','',''),(2614424,'1','202','1036',477,'Retail Sale Id 529',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 17:30:30','',''),(2614425,'1','202','1036',477,'Retail Sale Id 530',5702.72,0.00,0.00,10.04,5702.72,'2022-03-07 17:46:34','',''),(2614426,'1','202','1036',477,'Retail Sale Id 531',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 17:48:01','',''),(2614427,'1','202','1036',477,'Retail Sale Id 532',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 17:49:37','',''),(2614428,'1','202','1036',477,'Retail Sale Id 533',8010.00,0.00,0.00,15.00,8010.00,'2022-03-07 17:55:33','',''),(2614429,'1','202','1036',477,'Retail Sale Id 534',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 17:57:55','',''),(2614430,'1','202','1036',477,'Retail Sale Id 535',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 18:04:06','',''),(2614431,'1','202','1036',477,'Retail Sale Id 536',26700.00,0.00,0.00,50.00,26700.00,'2022-03-07 18:06:45','',''),(2614432,'1','202','1036',477,'Retail Sale Id 537',800.88,0.00,0.00,1.41,800.88,'2022-03-07 18:07:49','',''),(2614433,'1','202','1036',477,'Retail Sale Id 538',2300.40,0.00,0.00,4.05,2300.40,'2022-03-07 18:09:53','',''),(2614434,'1','202','1036',477,'Retail Sale Id 539',2499.20,0.00,0.00,4.40,2499.20,'2022-03-07 18:10:55','',''),(2614435,'1','202','1036',477,'Retail Sale Id 540',1999.36,0.00,0.00,3.52,1999.36,'2022-03-07 18:11:50','',''),(2614436,'1','202','1036',477,'Retail Sale Id 541',5998.08,0.00,0.00,10.56,5998.08,'2022-03-07 18:34:27','',''),(2614437,'1','202','1036',477,'Retail Sale Id 542',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 18:41:40','',''),(2614438,'1','202','1036',477,'Retail Sale Id 543',800.88,0.00,0.00,1.41,800.88,'2022-03-07 18:43:03','',''),(2614439,'1','202','1036',477,'Retail Sale Id 544',26700.00,0.00,0.00,50.00,26700.00,'2022-03-07 18:49:23','',''),(2614440,'1','202','1036',477,'Retail Sale Id 545',2999.04,0.00,0.00,5.28,2999.04,'2022-03-07 18:50:41','',''),(2614441,'1','202','1036',477,'Retail Sale Id 546',1198.48,0.00,0.00,2.11,1198.48,'2022-03-07 18:52:41','',''),(2614442,'1','202','1036',477,'Retail Sale Id 547',999.68,0.00,0.00,1.76,999.68,'2022-03-07 18:53:49','',''),(2614443,'1','202','1036',477,'Retail Sale Id 548',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 18:55:20','',''),(2614444,'1','202','1036',477,'Retail Sale Id 549',2198.16,0.00,0.00,3.87,2198.16,'2022-03-07 18:56:33','',''),(2614445,'1','202','1036',477,'Retail Sale Id 550',698.64,0.00,0.00,1.23,698.64,'2022-03-07 18:57:26','',''),(2614446,'1','202','1036',477,'Retail Sale Id 551',24030.00,0.00,0.00,45.00,24030.00,'2022-03-07 19:03:28','',''),(2614447,'1','202','1036',477,'Retail Sale Id 552',2902.48,0.00,0.00,5.11,2902.48,'2022-03-07 19:04:33','',''),(2614448,'1','202','1036',477,'Retail Sale Id 553',1499.52,0.00,0.00,2.64,1499.52,'2022-03-07 19:05:40','',''),(2614449,'1','202','1036',477,'Retail Sale Id 555',18156.00,0.00,0.00,34.00,18156.00,'2022-03-07 19:08:04','',''),(2614450,'1','202','1036',477,'Retail Sale Id 556',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 19:09:10','',''),(2614451,'1','202','1036',477,'Retail Sale Id 557',7100.00,0.00,0.00,12.50,7100.00,'2022-03-07 19:15:37','',''),(2614452,'1','202','1036',477,'Retail Sale Id 558',602.08,0.00,0.00,1.06,602.08,'2022-03-07 19:16:32','',''),(2614453,'1','202','1036',477,'Retail Sale Id 559',999.68,0.00,0.00,1.76,999.68,'2022-03-07 19:17:31','',''),(2614454,'1','202','1036',477,'Retail Sale Id 560',3498.88,0.00,0.00,6.16,3498.88,'2022-03-07 19:18:40','',''),(2614455,'1','202','1036',477,'Retail Sale Id 561',1800.56,0.00,0.00,3.17,1800.56,'2022-03-07 19:24:25','',''),(2614456,'1','202','1036',477,'Retail Sale Id 562',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 07:05:40','',''),(2614457,'1','202','1036',477,'Retail Sale Id 563',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 07:07:33','',''),(2614458,'1','202','1036',477,'Retail Sale Id 564',583000.00,0.00,0.00,1100.00,583000.00,'2022-03-08 07:14:54','',''),(2614459,'1','202','1036',477,'Retail Sale Id 565',4998.40,0.00,0.00,8.80,4998.40,'2022-03-08 07:15:54','',''),(2614460,'1','202','1036',477,'Retail Sale Id 566',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 07:17:08','',''),(2614461,'1','202','1036',477,'Retail Sale Id 567',999.68,0.00,0.00,1.76,999.68,'2022-03-08 07:18:50','',''),(2614462,'1','202','1036',477,'Retail Sale Id 568',2902.48,0.00,0.00,5.11,2902.48,'2022-03-08 07:28:30','',''),(2614463,'1','202','1036',477,'Retail Sale Id 569',58740.00,0.00,0.00,110.00,58740.00,'2022-03-08 07:30:13','',''),(2614464,'1','202','1036',477,'Retail Sale Id 570',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 07:31:23','',''),(2614465,'1','202','1036',477,'Retail Sale Id 571',2300.40,0.00,0.00,4.05,2300.40,'2022-03-08 07:34:30','',''),(2614466,'1','202','1036',477,'Retail Sale Id 572',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 07:35:42','',''),(2614467,'1','202','1036',477,'Retail Sale Id 573',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 07:36:33','',''),(2614468,'1','202','1036',477,'Retail Sale Id 574',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 07:43:32','',''),(2614469,'1','202','1036',477,'Retail Sale Id 575',10947.00,0.00,0.00,20.50,10947.00,'2022-03-08 07:55:05','',''),(2614470,'1','202','1036',477,'Retail Sale Id 576',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 07:56:26','',''),(2614471,'1','202','1036',477,'Retail Sale Id 577',800.88,0.00,0.00,1.41,800.88,'2022-03-08 07:58:08','',''),(2614472,'1','202','1036',477,'Retail Sale Id 578',6942.00,0.00,0.00,13.00,6942.00,'2022-03-08 08:03:25','',''),(2614473,'1','202','1036',477,'Retail Sale Id 579',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 08:06:28','',''),(2614474,'1','202','1036',477,'Retail Sale Id 580',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 08:07:34','',''),(2614475,'1','202','1036',477,'Retail Sale Id 581',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 08:08:37','',''),(2614476,'1','202','1036',477,'Retail Sale Id 582',999.68,0.00,0.00,1.76,999.68,'2022-03-08 08:18:06','',''),(2614477,'1','202','1036',477,'Retail Sale Id 583',2902.48,0.00,0.00,5.11,2902.48,'2022-03-08 08:31:12','',''),(2614478,'1','202','1036',477,'Retail Sale Id 584',1300.72,0.00,0.00,2.29,1300.72,'2022-03-08 08:32:29','',''),(2614479,'1','202','1036',477,'Retail Sale Id 585',1198.48,0.00,0.00,2.11,1198.48,'2022-03-08 08:42:30','',''),(2614480,'1','202','1036',477,'Retail Sale Id 586',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 08:51:12','',''),(2614481,'1','202','1036',477,'Retail Sale Id 587',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 08:51:53','',''),(2614482,'1','202','1036',477,'Retail Sale Id 588',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 09:03:57','',''),(2614483,'1','202','1036',477,'Retail Sale Id 589',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 09:05:18','',''),(2614484,'1','202','1036',477,'Retail Sale Id 590',29370.00,0.00,0.00,55.00,29370.00,'2022-03-08 09:10:31','',''),(2614485,'1','202','1036',477,'Retail Sale Id 591',999.68,0.00,0.00,1.76,999.68,'2022-03-08 09:11:37','',''),(2614486,'1','202','1036',477,'Retail Sale Id 592',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 09:12:48','',''),(2614487,'1','202','1036',477,'Retail Sale Id 593',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 09:13:49','',''),(2614488,'1','202','1036',477,'Retail Sale Id 594',800.88,0.00,0.00,1.41,800.88,'2022-03-08 09:14:57','',''),(2614489,'1','202','1036',477,'Retail Sale Id 595',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 09:16:05','',''),(2614490,'1','202','1036',477,'Retail Sale Id 596',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 09:29:43','',''),(2614491,'1','202','1036',477,'Retail Sale Id 597',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 09:30:40','',''),(2614492,'1','202','1036',477,'Retail Sale Id 598',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 09:31:46','',''),(2614493,'1','202','1036',477,'Retail Sale Id 599',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 09:32:31','',''),(2614494,'1','202','1036',477,'Retail Sale Id 600',32574.00,0.00,0.00,61.00,32574.00,'2022-03-08 09:41:11','',''),(2614495,'1','202','1036',477,'Retail Sale Id 601',33108.00,0.00,0.00,62.00,33108.00,'2022-03-08 09:44:09','',''),(2614496,'1','202','1036',477,'Retail Sale Id 602',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 09:46:59','',''),(2614497,'1','202','1036',477,'Retail Sale Id 603',46992.00,0.00,0.00,88.00,46992.00,'2022-03-08 10:01:44','',''),(2614498,'1','202','1036',477,'Retail Sale Id 604',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 10:11:58','',''),(2614499,'1','202','1036',477,'Retail Sale Id 605',999.68,0.00,0.00,1.76,999.68,'2022-03-08 10:12:53','',''),(2614500,'1','202','1036',477,'Retail Sale Id 606',536625.00,0.00,0.00,1012.50,536625.00,'2022-03-08 10:20:22','',''),(2614501,'1','202','1036',477,'Retail Sale Id 607',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 10:26:31','',''),(2614502,'1','202','1036',477,'Retail Sale Id 608',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 10:31:31','',''),(2614503,'1','202','1036',477,'Retail Sale Id 609',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 10:51:41','',''),(2614504,'1','202','1036',477,'Retail Sale Id 612',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 11:13:16','',''),(2614505,'1','202','1036',477,'Retail Sale Id 613',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 11:18:34','',''),(2614506,'1','202','1036',477,'Retail Sale Id 614',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 11:27:37','',''),(2614507,'1','202','1036',477,'Retail Sale Id 615',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 11:28:36','',''),(2614508,'1','202','1036',477,'Retail Sale Id 616',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 11:37:30','',''),(2614509,'1','202','1036',477,'Retail Sale Id 617',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 11:48:05','',''),(2614510,'1','202','1036',477,'Retail Sale Id 618',31506.00,0.00,0.00,59.00,31506.00,'2022-03-08 11:49:17','',''),(2614511,'1','202','1036',477,'Retail Sale Id 619',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 11:52:20','',''),(2614512,'1','202','1036',477,'Retail Sale Id 620',10947.00,0.00,0.00,20.50,10947.00,'2022-03-08 11:54:52','',''),(2614513,'1','202','1036',477,'Retail Sale Id 621',5340.00,0.00,0.00,10.00,5340.00,'2022-03-08 11:56:55','',''),(2614514,'1','202','1036',477,'Retail Sale Id 622',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 12:00:57','',''),(2614515,'1','202','1036',477,'Retail Sale Id 623',2902.48,0.00,0.00,5.11,2902.48,'2022-03-08 12:20:39','',''),(2614516,'1','202','1036',477,'Retail Sale Id 624',2902.48,0.00,0.00,5.11,2902.48,'2022-03-08 12:25:35','',''),(2614517,'1','202','1036',477,'Retail Sale Id 625',698.64,0.00,0.00,1.23,698.64,'2022-03-08 12:27:16','',''),(2614518,'1','202','1036',477,'Retail Sale Id 626',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 12:30:39','',''),(2614519,'1','202','1036',477,'Retail Sale Id 627',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 13:13:26','',''),(2614520,'1','202','1036',477,'Retail Sale Id 628',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 13:15:05','',''),(2614521,'1','202','1036',477,'Retail Sale Id 629',2902.48,0.00,0.00,5.11,2902.48,'2022-03-08 13:16:01','',''),(2614522,'1','202','1036',477,'Retail Sale Id 630',2902.48,0.00,0.00,5.11,2902.48,'2022-03-08 13:17:25','',''),(2614523,'1','202','1036',477,'Retail Sale Id 631',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 13:18:50','',''),(2614524,'1','202','1036',477,'Retail Sale Id 632',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 13:23:12','',''),(2614525,'1','202','1036',477,'Retail Sale Id 633',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 13:35:08','',''),(2614526,'1','202','1036',477,'Retail Sale Id 634',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 13:43:58','',''),(2614527,'1','202','1036',477,'Retail Sale Id 635',3998.72,0.00,0.00,7.04,3998.72,'2022-03-08 13:45:27','',''),(2614528,'1','202','1036',477,'Retail Sale Id 636',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 13:46:22','',''),(2614529,'1','202','1036',477,'Retail Sale Id 637',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 13:53:02','',''),(2614530,'1','202','1036',477,'Retail Sale Id 638',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 13:57:26','',''),(2614531,'1','202','1036',477,'Retail Sale Id 639',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 14:09:57','',''),(2614532,'1','202','1036',477,'Retail Sale Id 641',2499.20,0.00,0.00,4.40,2499.20,'2022-03-08 14:23:21','',''),(2614533,'1','202','1036',477,'Retail Sale Id 642',7743.00,0.00,0.00,14.50,7743.00,'2022-03-08 14:46:13','',''),(2614534,'1','202','1036',477,'Retail Sale Id 643',52332.00,0.00,0.00,98.00,52332.00,'2022-03-08 14:54:10','',''),(2614535,'1','202','1036',477,'Retail Sale Id 644',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 14:55:29','',''),(2614536,'1','202','1036',477,'Retail Sale Id 645',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 14:56:55','',''),(2614537,'1','202','1036',477,'Retail Sale Id 646',2999.04,0.00,0.00,5.28,2999.04,'2022-03-08 15:02:16','',''),(2614538,'1','202','1036',477,'Retail Sale Id 647',999.68,0.00,0.00,1.76,999.68,'2022-03-08 15:05:43','',''),(2614539,'1','202','1036',477,'Retail Sale Id 648',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 15:22:44','',''),(2614540,'1','202','1036',477,'Retail Sale Id 649',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 15:23:31','',''),(2614541,'1','202','1036',477,'Retail Sale Id 650',9879.00,0.00,0.00,18.50,9879.00,'2022-03-08 15:25:20','',''),(2614542,'1','202','1036',477,'Retail Sale Id 651',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 15:34:17','',''),(2614543,'1','202','1036',477,'Retail Sale Id 653',2300.40,0.00,0.00,4.05,2300.40,'2022-03-08 15:35:31','',''),(2614544,'1','202','1036',477,'Retail Sale Id 654',5702.72,0.00,0.00,10.04,5702.72,'2022-03-08 15:42:31','',''),(2614545,'1','202','1036',477,'Retail Sale Id 655',2999.04,0.00,0.00,5.28,2999.04,'2022-03-08 15:47:49','',''),(2614546,'1','202','1036',477,'Retail Sale Id 656',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 15:58:57','',''),(2614547,'1','202','1036',477,'Retail Sale Id 657',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 16:00:07','',''),(2614548,'1','202','1036',477,'Retail Sale Id 658',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 16:01:00','',''),(2614549,'1','202','1036',477,'Retail Sale Id 659',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 16:01:50','',''),(2614550,'1','202','1036',477,'Retail Sale Id 660',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 16:12:11','',''),(2614551,'1','202','1036',477,'Retail Sale Id 661',9345.00,0.00,0.00,17.50,9345.00,'2022-03-08 16:14:50','',''),(2614552,'1','202','1036',477,'Retail Sale Id 662',3998.72,0.00,0.00,7.04,3998.72,'2022-03-08 16:31:17','',''),(2614553,'1','202','1036',477,'Retail Sale Id 663',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 16:33:56','',''),(2614554,'1','202','1036',477,'Retail Sale Id 664',999.68,0.00,0.00,1.76,999.68,'2022-03-08 16:34:56','',''),(2614555,'1','202','1036',477,'Retail Sale Id 665',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 16:37:12','',''),(2614556,'1','202','1036',477,'Retail Sale Id 666',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 16:42:38','',''),(2614557,'1','202','1036',477,'Retail Sale Id 667',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 16:48:28','',''),(2614558,'1','202','1036',477,'Retail Sale Id 668',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 16:55:18','',''),(2614559,'1','202','1036',477,'Retail Sale Id 669',2902.48,0.00,0.00,5.11,2902.48,'2022-03-08 16:56:29','',''),(2614560,'1','202','1036',477,'Retail Sale Id 670',2999.04,0.00,0.00,5.28,2999.04,'2022-03-08 17:01:03','',''),(2614561,'1','202','1036',477,'Retail Sale Id 671',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 17:02:19','',''),(2614562,'1','202','1036',477,'Retail Sale Id 673',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 17:03:15','',''),(2614563,'1','202','1036',477,'Retail Sale Id 674',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 17:04:47','',''),(2614564,'1','202','1036',477,'Retail Sale Id 675',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 17:08:36','',''),(2614565,'1','202','1036',477,'Retail Sale Id 676',1198.48,0.00,0.00,2.11,1198.48,'2022-03-08 17:18:58','',''),(2614566,'1','202','1036',477,'Retail Sale Id 677',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 17:29:43','',''),(2614567,'1','202','1036',477,'Retail Sale Id 678',1198.48,0.00,0.00,2.11,1198.48,'2022-03-08 17:32:03','',''),(2614568,'1','202','1036',477,'Retail Sale Id 679',2999.04,0.00,0.00,5.28,2999.04,'2022-03-08 17:33:39','',''),(2614569,'1','202','1036',477,'Retail Sale Id 680',999.68,0.00,0.00,1.76,999.68,'2022-03-08 17:35:03','',''),(2614570,'1','202','1036',477,'Retail Sale Id 681',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 17:36:20','',''),(2614571,'1','202','1036',477,'Retail Sale Id 682',602.08,0.00,0.00,1.06,602.08,'2022-03-08 17:37:38','',''),(2614572,'1','202','1036',477,'Retail Sale Id 683',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 17:38:29','',''),(2614573,'1','202','1036',477,'Retail Sale Id 684',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 17:42:45','',''),(2614574,'1','202','1036',477,'Retail Sale Id 685',999.68,0.00,0.00,1.76,999.68,'2022-03-08 17:46:49','',''),(2614575,'1','202','1036',477,'Retail Sale Id 686',2999.04,0.00,0.00,5.28,2999.04,'2022-03-08 17:52:17','',''),(2614576,'1','202','1036',477,'Retail Sale Id 687',29370.00,0.00,0.00,55.00,29370.00,'2022-03-08 17:59:09','',''),(2614577,'1','202','1036',477,'Retail Sale Id 688',3498.88,0.00,0.00,6.16,3498.88,'2022-03-08 18:00:46','',''),(2614578,'1','202','1036',477,'Retail Sale Id 689',999.68,0.00,0.00,1.76,999.68,'2022-03-08 18:01:32','',''),(2614579,'1','202','1036',477,'Retail Sale Id 690',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 18:04:44','',''),(2614580,'1','202','1036',477,'Retail Sale Id 691',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 18:05:58','',''),(2614581,'1','202','1036',477,'Retail Sale Id 692',1800.56,0.00,0.00,3.17,1800.56,'2022-03-08 18:06:48','',''),(2614582,'1','202','1036',477,'Retail Sale Id 693',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 18:15:33','',''),(2614583,'1','202','1036',477,'Retail Sale Id 694',1499.52,0.00,0.00,2.64,1499.52,'2022-03-08 18:16:19','',''),(2614584,'1','202','1036',477,'Retail Sale Id 695',29370.00,0.00,0.00,55.00,29370.00,'2022-03-08 18:17:35','',''),(2614585,'1','202','1036',477,'Retail Sale Id 696',5702.72,0.00,0.00,10.04,5702.72,'2022-03-08 18:18:30','',''),(2614586,'1','202','1036',477,'Retail Sale Id 697',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 18:19:39','',''),(2614587,'1','202','1036',477,'Retail Sale Id 698',999.68,0.00,0.00,1.76,999.68,'2022-03-08 18:20:28','',''),(2614588,'1','202','1036',477,'Retail Sale Id 699',999.68,0.00,0.00,1.76,999.68,'2022-03-08 18:30:00','',''),(2614589,'1','202','1036',477,'Retail Sale Id 700',21360.00,0.00,0.00,40.00,21360.00,'2022-03-08 18:36:12','',''),(2614590,'1','202','1036',477,'Retail Sale Id 701',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 18:41:32','',''),(2614591,'1','202','1036',477,'Retail Sale Id 702',1198.48,0.00,0.00,2.11,1198.48,'2022-03-08 18:59:30','',''),(2614592,'1','202','1036',477,'Retail Sale Id 703',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 19:01:43','',''),(2614593,'1','202','1036',477,'Retail Sale Id 704',7100.00,0.00,0.00,12.50,7100.00,'2022-03-08 19:03:46','',''),(2614594,'1','202','1036',477,'Retail Sale Id 705',10680.00,0.00,0.00,20.00,10680.00,'2022-03-08 19:35:37','',''),(2614595,'1','202','1036',477,'Retail Sale Id 706',1999.36,0.00,0.00,3.52,1999.36,'2022-03-08 19:39:21','',''),(2614596,'1','202','1036',477,'Return of Retail Sale Id 642',0.00,7743.00,14.50,0.00,-7743.00,'2022-03-08 20:59:46','',''),(2614597,'1','202','1036',477,'Return of Retail Sale Id 699',0.00,999.68,1.76,0.00,-999.68,'2022-03-08 21:01:02','',''),(2614598,'1','202','1036',477,'Retail Sale Id 707',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 07:00:23','',''),(2614599,'1','202','1036',477,'Retail Sale Id 708',1497.60,0.00,0.00,2.34,1497.60,'2022-03-09 07:12:28','',''),(2614600,'1','202','1036',477,'Retail Sale Id 709',2598.40,0.00,0.00,4.06,2598.40,'2022-03-09 07:29:55','',''),(2614601,'1','202','1036',477,'Retail Sale Id 710',2598.40,0.00,0.00,4.06,2598.40,'2022-03-09 07:49:28','',''),(2614602,'1','202','1036',477,'Retail Sale Id 711',4000.00,0.00,0.00,6.25,4000.00,'2022-03-09 07:59:52','',''),(2614603,'1','202','1036',477,'Retail Sale Id 712',3001.60,0.00,0.00,4.69,3001.60,'2022-03-09 08:12:51','',''),(2614604,'1','202','1036',477,'Retail Sale Id 713',1299.20,0.00,0.00,2.03,1299.20,'2022-03-09 08:14:35','',''),(2614605,'1','202','1036',477,'Retail Sale Id 714',8000.00,0.00,0.00,12.50,8000.00,'2022-03-09 08:16:11','',''),(2614606,'1','202','1036',477,'Retail Sale Id 715',8000.00,0.00,0.00,12.50,8000.00,'2022-03-09 08:17:35','',''),(2614607,'1','202','1036',477,'Retail Sale Id 716',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 08:23:23','',''),(2614608,'1','202','1036',477,'Retail Sale Id 717',1952.00,0.00,0.00,3.05,1952.00,'2022-03-09 08:34:49','',''),(2614609,'1','202','1036',477,'Retail Sale Id 718',8000.00,0.00,0.00,12.50,8000.00,'2022-03-09 08:35:54','',''),(2614610,'1','202','1036',477,'Retail Sale Id 719',3001.60,0.00,0.00,4.69,3001.60,'2022-03-09 08:37:53','',''),(2614611,'1','202','1036',477,'Retail Sale Id 720',3001.60,0.00,0.00,4.69,3001.60,'2022-03-09 08:42:31','',''),(2614612,'1','202','1036',477,'Retail Sale Id 721',998.40,0.00,0.00,1.56,998.40,'2022-03-09 08:43:46','',''),(2614613,'1','202','1036',477,'Retail Sale Id 722',3200.00,0.00,0.00,5.00,3200.00,'2022-03-09 08:45:02','',''),(2614614,'1','202','1036',477,'Retail Sale Id 723',3200.00,0.00,0.00,5.00,3200.00,'2022-03-09 08:46:31','',''),(2614615,'1','202','1036',477,'Retail Sale Id 724',1952.00,0.00,0.00,3.05,1952.00,'2022-03-09 08:47:30','',''),(2614616,'1','202','1036',477,'Retail Sale Id 725',998.40,0.00,0.00,1.56,998.40,'2022-03-09 08:52:56','',''),(2614617,'1','202','1036',477,'Retail Sale Id 726',8000.00,0.00,0.00,12.50,8000.00,'2022-03-09 08:54:39','',''),(2614618,'1','202','1036',477,'Retail Sale Id 727',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 08:58:49','',''),(2614619,'1','202','1036',477,'Retail Sale Id 728',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 09:00:26','',''),(2614620,'1','202','1036',477,'Retail Sale Id 729',3200.00,0.00,0.00,5.00,3200.00,'2022-03-09 09:09:44','',''),(2614621,'1','202','1036',477,'Retail Sale Id 731',6400.00,0.00,0.00,10.00,6400.00,'2022-03-09 09:14:58','',''),(2614622,'1','202','1036',477,'Retail Sale Id 732',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 09:15:51','',''),(2614623,'1','202','1036',477,'Retail Sale Id 733',6400.00,0.00,0.00,10.00,6400.00,'2022-03-09 09:20:13','',''),(2614624,'1','202','1036',477,'Retail Sale Id 734',1203.20,0.00,0.00,1.88,1203.20,'2022-03-09 09:24:37','',''),(2614625,'1','202','1036',477,'Retail Sale Id 736',3200.00,0.00,0.00,5.00,3200.00,'2022-03-09 09:28:44','',''),(2614626,'1','202','1036',477,'Retail Sale Id 737',2003.20,0.00,0.00,3.13,2003.20,'2022-03-09 09:30:07','',''),(2614627,'1','202','1036',477,'Retail Sale Id 738',8000.00,0.00,0.00,12.50,8000.00,'2022-03-09 09:31:48','',''),(2614628,'1','202','1036',477,'Retail Sale Id 739',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 09:40:43','',''),(2614629,'1','202','1036',477,'Retail Sale Id 740',8000.00,0.00,0.00,12.50,8000.00,'2022-03-09 09:42:18','',''),(2614630,'1','202','1036',477,'Retail Sale Id 741',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 09:53:03','',''),(2614631,'1','202','1036',477,'Retail Sale Id 742',8000.00,0.00,0.00,12.50,8000.00,'2022-03-09 09:55:28','',''),(2614632,'1','202','1036',477,'Retail Sale Id 743',5120.00,0.00,0.00,8.00,5120.00,'2022-03-09 10:09:00','',''),(2614633,'1','202','1036',477,'Retail Sale Id 744',3200.00,0.00,0.00,5.00,3200.00,'2022-03-09 10:22:47','',''),(2614634,'1','202','1036',477,'Retail Sale Id 745',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 10:27:00','',''),(2614635,'1','202','1036',477,'Retail Sale Id 746',998.40,0.00,0.00,1.56,998.40,'2022-03-09 10:49:47','',''),(2614636,'1','202','1036',477,'Retail Sale Id 747',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 10:53:07','',''),(2614637,'1','202','1036',477,'Retail Sale Id 748',1401.60,0.00,0.00,2.19,1401.60,'2022-03-09 10:55:01','',''),(2614638,'1','202','1036',477,'Retail Sale Id 749',1952.00,0.00,0.00,3.05,1952.00,'2022-03-09 11:17:51','',''),(2614639,'1','202','1036',477,'Retail Sale Id 750',3001.60,0.00,0.00,4.69,3001.60,'2022-03-09 11:29:00','',''),(2614640,'1','202','1036',477,'Retail Sale Id 751',3001.60,0.00,0.00,4.69,3001.60,'2022-03-09 11:29:50','',''),(2614641,'1','202','1036',477,'Retail Sale Id 752',3200.00,0.00,0.00,5.00,3200.00,'2022-03-09 11:35:04','',''),(2614642,'1','202','1036',477,'Retail Sale Id 753',2899.20,0.00,0.00,4.53,2899.20,'2022-03-09 11:44:14','',''),(2614643,'1','202','1036',477,'Retail Sale Id 754',2003.20,0.00,0.00,3.13,2003.20,'2022-03-09 11:46:42','',''),(2614644,'1','202','1036',477,'Retail Sale Id 755',3200.00,0.00,0.00,5.00,3200.00,'2022-03-09 11:49:20','',''),(2614645,'1','202','1036',477,'Retail Sale Id 756',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 11:53:40','',''),(2614646,'1','202','1036',477,'Retail Sale Id 757',998.40,0.00,0.00,1.56,998.40,'2022-03-09 11:59:53','',''),(2614647,'1','202','1036',477,'Retail Sale Id 758',3200.00,0.00,0.00,5.00,3200.00,'2022-03-09 12:03:55','',''),(2614648,'1','202','1036',477,'Retail Sale Id 759',8000.00,0.00,0.00,12.50,8000.00,'2022-03-09 12:05:41','',''),(2614649,'1','202','1036',477,'Retail Sale Id 761',998.40,0.00,0.00,1.56,998.40,'2022-03-09 12:11:32','',''),(2614650,'1','202','1036',477,'Retail Sale Id 763',2598.40,0.00,0.00,4.06,2598.40,'2022-03-09 12:13:07','',''),(2614651,'1','202','1036',477,'Retail Sale Id 764',2502.40,0.00,0.00,3.91,2502.40,'2022-03-09 12:15:42','',''),(2614652,'1','202','1036',477,'Retail Sale Id 765',1497.60,0.00,0.00,2.34,1497.60,'2022-03-09 12:29:27','',''),(2614653,'1','202','1036',477,'Retail Sale Id 766',3500.80,0.00,0.00,5.47,3500.80,'2022-03-09 12:41:34','',''),(2614654,'1','202','1036',477,'Retail Sale Id 767',3500.80,0.00,0.00,5.47,3500.80,'2022-03-09 12:43:46','',''),(2614655,'1','202','1036',477,'Retail Sale Id 768',3200.00,0.00,0.00,5.00,3200.00,'2022-03-09 12:45:26','',''),(2614656,'1','202','1036',477,'Retail Sale Id 769',1497.60,0.00,0.00,2.34,1497.60,'2022-03-09 13:45:28','',''),(2614657,'1','202','1036',477,'Retail Sale Id 770',7680.00,0.00,0.00,12.00,7680.00,'2022-03-09 13:48:21','',''),(2614658,'1','202','1036',477,'Retail Sale Id 771',2003.20,0.00,0.00,3.13,2003.20,'2022-03-09 14:02:08','',''),(2614659,'1','202','1036',477,'Retail Sale Id 772',7001.60,0.00,0.00,10.94,7001.60,'2022-03-09 14:20:48','',''),(2614660,'1','202','1036',477,'Retail Sale Id 773',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 14:22:40','',''),(2614661,'1','202','1036',477,'Retail Sale Id 774',1952.00,0.00,0.00,3.05,1952.00,'2022-03-09 14:28:49','',''),(2614662,'1','202','1036',477,'Retail Sale Id 775',1952.00,0.00,0.00,3.05,1952.00,'2022-03-09 14:30:53','',''),(2614663,'1','202','1036',477,'Retail Sale Id 776',2003.20,0.00,0.00,3.13,2003.20,'2022-03-09 14:34:23','',''),(2614664,'1','202','1036',477,'Retail Sale Id 778',998.40,0.00,0.00,1.56,998.40,'2022-03-09 14:47:45','',''),(2614665,'1','202','1036',477,'Retail Sale Id 780',1952.00,0.00,0.00,3.05,1952.00,'2022-03-09 14:52:38','',''),(2614666,'1','202','1036',477,'Retail Sale Id 781',3852.80,0.00,0.00,6.02,3852.80,'2022-03-09 14:53:39','',''),(2614667,'1','202','1036',477,'Retail Sale Id 782',8000.00,0.00,0.00,12.50,8000.00,'2022-03-09 15:17:39','',''),(2614668,'1','202','1036',477,'Retail Sale Id 783',1497.60,0.00,0.00,2.34,1497.60,'2022-03-09 15:22:22','',''),(2614669,'1','202','1036',477,'Retail Sale Id 784',1497.60,0.00,0.00,2.34,1497.60,'2022-03-09 15:23:54','',''),(2614670,'1','202','1036',477,'Retail Sale Id 785',998.40,0.00,0.00,1.56,998.40,'2022-03-09 15:32:11','',''),(2614671,'1','202','1036',477,'Retail Sale Id 787',1952.00,0.00,0.00,3.05,1952.00,'2022-03-09 15:40:01','',''),(2614672,'1','202','1036',477,'Retail Sale Id 788',1952.00,0.00,0.00,3.05,1952.00,'2022-03-09 15:53:24','',''),(2614673,'1','202','1036',477,'Retail Sale Id 789',3001.60,0.00,0.00,4.69,3001.60,'2022-03-09 15:54:31','',''),(2614674,'1','202','1036',477,'Retail Sale Id 790',7001.60,0.00,0.00,10.94,7001.60,'2022-03-09 15:59:59','',''),(2614675,'1','202','1036',477,'Retail Sale Id 791',2003.20,0.00,0.00,3.13,2003.20,'2022-03-09 16:08:28','',''),(2614676,'1','202','1036',477,'Retail Sale Id 793',2003.20,0.00,0.00,3.13,2003.20,'2022-03-09 16:15:17','',''),(2614677,'1','202','1036',477,'Retail Sale Id 794',998.40,0.00,0.00,1.56,998.40,'2022-03-09 16:29:06','',''),(2614678,'1','202','1036',477,'Retail Sale Id 795',998.40,0.00,0.00,1.56,998.40,'2022-03-09 16:33:29','',''),(2614679,'1','202','1036',477,'Retail Sale Id 796',1900.80,0.00,0.00,2.97,1900.80,'2022-03-09 16:46:50','',''),(2614680,'1','202','1036',477,'Retail Sale Id 797',3400.00,0.00,0.00,5.00,3400.00,'2022-03-22 14:16:29','',''),(2614681,'1','202','1036',477,'Retail Sale Id 798',999.60,0.00,0.00,1.47,999.60,'2022-03-22 14:17:40','',''),(2614682,'1','202','1036',477,'Retail Sale Id 799',3998.40,0.00,0.00,5.88,3998.40,'2022-03-22 14:18:19','',''),(2614683,'1','202','1036',477,'Retail Sale Id 800',503.20,0.00,0.00,0.74,503.20,'2022-03-22 14:18:50','',''),(2614684,'1','202','1036',477,'Retail Sale Id 801',36480.00,0.00,0.00,60.00,36480.00,'2022-03-22 14:35:36','',''),(2614685,'1','202','1036',477,'Retail Sale Id 802',1700.00,0.00,0.00,2.50,1700.00,'2022-03-22 14:40:31','',''),(2614686,'1','202','1036',477,'Retail Sale Id 803',4100.40,0.00,0.00,6.03,4100.40,'2022-03-22 14:55:43','',''),(2614687,'1','202','1036',477,'Retail Sale Id 804',1502.80,0.00,0.00,2.21,1502.80,'2022-03-22 15:13:15','',''),(2614688,'1','202','1036',477,'Retail Sale Id 805',4100.40,0.00,0.00,6.03,4100.40,'2022-03-22 15:38:53','',''),(2614689,'1','202','1036',477,'Retail Sale Id 806',1502.80,0.00,0.00,2.21,1502.80,'2022-03-22 15:39:40','',''),(2614690,'1','202','1036',477,'Retail Sale Id 807',1502.80,0.00,0.00,2.21,1502.80,'2022-03-22 15:40:49','',''),(2614691,'1','202','1036',477,'Retail Sale Id 808',2998.80,0.00,0.00,4.41,2998.80,'2022-03-22 15:45:59','',''),(2614692,'1','202','1036',477,'Retail Sale Id 809',1999.20,0.00,0.00,2.94,1999.20,'2022-03-22 15:57:25','',''),(2614693,'1','202','1036',477,'Retail Sale Id 810',4100.40,0.00,0.00,6.03,4100.40,'2022-03-22 16:03:53','',''),(2614694,'1','202','1036',477,'Retail Sale Id 812',23104.00,0.00,0.00,38.00,23104.00,'2022-03-22 16:16:00','',''),(2614695,'1','202','1036',477,'Retail Sale Id 813',1400.80,0.00,0.00,2.06,1400.80,'2022-03-22 16:17:25','',''),(2614696,'1','202','1036',477,'Retail Sale Id 814',1502.80,0.00,0.00,2.21,1502.80,'2022-03-22 16:38:16','',''),(2614697,'1','202','1036',477,'Retail Sale Id 815',4100.40,0.00,0.00,6.03,4100.40,'2022-03-22 16:40:10','',''),(2614698,'1','202','1036',477,'Retail Sale Id 816',3400.00,0.00,0.00,5.00,3400.00,'2022-03-22 16:43:27','',''),(2614699,'1','202','1036',477,'Retail Sale Id 817',4100.40,0.00,0.00,6.03,4100.40,'2022-03-22 16:56:41','',''),(2614700,'1','202','1036',477,'Retail Sale Id 818',1999.20,0.00,0.00,2.94,1999.20,'2022-03-22 17:01:14','',''),(2614701,'1','202','1036',477,'Retail Sale Id 819',8500.00,0.00,0.00,12.50,8500.00,'2022-03-22 17:11:42','',''),(2614702,'1','202','1036',477,'Retail Sale Id 820',3400.00,0.00,0.00,5.00,3400.00,'2022-03-22 17:14:22','',''),(2614703,'1','202','1036',477,'Retail Sale Id 821',999.60,0.00,0.00,1.47,999.60,'2022-03-22 17:19:04','',''),(2614704,'1','202','1036',477,'Retail Sale Id 822',6800.00,0.00,0.00,10.00,6800.00,'2022-03-22 17:25:26','',''),(2614705,'1','202','1036',477,'Retail Sale Id 823',8500.00,0.00,0.00,12.50,8500.00,'2022-03-22 17:32:54','',''),(2614706,'1','202','1036',477,'Retail Sale Id 824',12600.40,0.00,0.00,18.53,12600.40,'2022-03-22 17:35:30','',''),(2614707,'1','202','1036',477,'Retail Sale Id 825',2502.40,0.00,0.00,3.68,2502.40,'2022-03-22 17:46:54','',''),(2614708,'1','202','1036',477,'Retail Sale Id 826',4100.40,0.00,0.00,6.03,4100.40,'2022-03-22 18:00:17','',''),(2614709,'1','202','1036',477,'Retail Sale Id 827',4100.40,0.00,0.00,6.03,4100.40,'2022-03-22 18:12:55','',''),(2614710,'1','202','1036',477,'Retail Sale Id 828',2801.60,0.00,0.00,4.12,2801.60,'2022-03-22 18:15:05','',''),(2614711,'1','202','1036',477,'Retail Sale Id 829',503.20,0.00,0.00,0.74,503.20,'2022-03-22 18:19:19','',''),(2614712,'1','202','1036',477,'Retail Sale Id 830',1502.80,0.00,0.00,2.21,1502.80,'2022-03-22 18:21:54','',''),(2614713,'1','202','1036',477,'Retail Sale Id 831',1502.80,0.00,0.00,2.21,1502.80,'2022-03-22 18:31:28','',''),(2614714,'1','202','1036',477,'Retail Sale Id 832',1999.20,0.00,0.00,2.94,1999.20,'2022-03-22 18:32:40','',''),(2614715,'1','202','1036',477,'Retail Sale Id 833',1400.80,0.00,0.00,2.06,1400.80,'2022-03-22 18:36:00','',''),(2614716,'1','202','1036',477,'Retail Sale Id 833',1400.80,0.00,0.00,2.06,1400.80,'2022-03-22 18:36:00','',''),(2614717,'1','202','1036',477,'Retail Sale Id 834',1502.80,0.00,0.00,2.21,1502.80,'2022-03-22 18:40:26','',''),(2614718,'1','202','1036',477,'Retail Sale Id 835',1400.80,0.00,0.00,2.06,1400.80,'2022-03-22 18:44:18','',''),(2614719,'1','202','1036',477,'Retail Sale Id 836',999.60,0.00,0.00,1.47,999.60,'2022-03-22 18:58:05','',''),(2614720,'1','202','1036',477,'Retail Sale Id 837',3998.40,0.00,0.00,5.88,3998.40,'2022-03-22 19:17:49','',''),(2614721,'1','202','1036',477,'Retail Sale Id 838',2087.60,0.00,0.00,3.07,2087.60,'2022-03-22 19:36:12','',''),(2614722,'1','202','1036',477,'Retail Sale Id 839',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 07:05:06','',''),(2614723,'1','202','1036',477,'Retail Sale Id 840',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 07:05:59','',''),(2614724,'1','202','1036',477,'Retail Sale Id 841',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 07:26:37','',''),(2614725,'1','202','1036',477,'Retail Sale Id 842',999.60,0.00,0.00,1.47,999.60,'2022-03-23 07:36:45','',''),(2614726,'1','202','1036',477,'Retail Sale Id 843',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 07:48:36','',''),(2614727,'1','202','1036',477,'Retail Sale Id 844',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 07:56:43','',''),(2614728,'1','202','1036',477,'Retail Sale Id 845',1700.00,0.00,0.00,2.50,1700.00,'2022-03-23 08:14:52','',''),(2614729,'1','202','1036',477,'Retail Sale Id 846',2046.80,0.00,0.00,3.01,2046.80,'2022-03-23 08:32:44','',''),(2614730,'1','202','1036',477,'Retail Sale Id 847',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 08:33:49','',''),(2614731,'1','202','1036',477,'Retail Sale Id 848',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 08:36:43','',''),(2614732,'1','202','1036',477,'Retail Sale Id 849',3400.00,0.00,0.00,5.00,3400.00,'2022-03-23 08:40:24','',''),(2614733,'1','202','1036',477,'Retail Sale Id 850',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 08:56:12','',''),(2614734,'1','202','1036',477,'Retail Sale Id 851',2046.80,0.00,0.00,3.01,2046.80,'2022-03-23 09:00:03','',''),(2614735,'1','202','1036',477,'Retail Sale Id 852',999.60,0.00,0.00,1.47,999.60,'2022-03-23 09:04:57','',''),(2614736,'1','202','1036',477,'Retail Sale Id 853',23712.00,0.00,0.00,39.00,23712.00,'2022-03-23 09:12:43','',''),(2614737,'1','202','1036',477,'Retail Sale Id 854',999.60,0.00,0.00,1.47,999.60,'2022-03-23 09:13:32','',''),(2614738,'1','202','1036',477,'Retail Sale Id 855',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 09:24:18','',''),(2614739,'1','202','1036',477,'Retail Sale Id 856',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 09:25:30','',''),(2614740,'1','202','1036',477,'Retail Sale Id 857',3400.00,0.00,0.00,5.00,3400.00,'2022-03-23 09:28:06','',''),(2614741,'1','202','1036',477,'Retail Sale Id 858',2720.00,0.00,0.00,4.00,2720.00,'2022-03-23 09:29:36','',''),(2614742,'1','202','1036',477,'Retail Sale Id 859',212800.00,0.00,0.00,350.00,212800.00,'2022-03-23 09:45:11','',''),(2614743,'1','202','1036',477,'Retail Sale Id 860',3400.00,0.00,0.00,5.00,3400.00,'2022-03-23 09:55:58','',''),(2614744,'1','202','1036',477,'Retail Sale Id 861',33440.00,0.00,0.00,55.00,33440.00,'2022-03-23 10:09:54','',''),(2614745,'1','202','1036',477,'Retail Sale Id 862',999.60,0.00,0.00,1.47,999.60,'2022-03-23 10:11:27','',''),(2614746,'1','202','1036',477,'Retail Sale Id 863',2040.00,0.00,0.00,3.00,2040.00,'2022-03-23 10:13:48','',''),(2614747,'1','202','1036',477,'Retail Sale Id 864',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 10:34:10','',''),(2614748,'1','202','1036',477,'Retail Sale Id 865',3998.40,0.00,0.00,5.88,3998.40,'2022-03-23 10:51:24','',''),(2614749,'1','202','1036',477,'Retail Sale Id 866',60800.00,0.00,0.00,100.00,60800.00,'2022-03-23 10:52:33','',''),(2614750,'1','202','1036',477,'Retail Sale Id 867',33440.00,0.00,0.00,55.00,33440.00,'2022-03-23 10:56:14','',''),(2614751,'1','202','1036',477,'Retail Sale Id 868',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 10:57:23','',''),(2614752,'1','202','1036',477,'Retail Sale Id 869',5800.40,0.00,0.00,8.53,5800.40,'2022-03-23 11:19:26','',''),(2614753,'1','202','1036',477,'Retail Sale Id 870',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 11:26:59','',''),(2614754,'1','202','1036',477,'Retail Sale Id 871',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 11:37:17','',''),(2614755,'1','202','1036',477,'Retail Sale Id 872',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 11:38:35','',''),(2614756,'1','202','1036',477,'Retail Sale Id 873',3502.00,0.00,0.00,5.15,3502.00,'2022-03-23 11:40:26','',''),(2614757,'1','202','1036',477,'Retail Sale Id 875',999.60,0.00,0.00,1.47,999.60,'2022-03-23 12:03:46','',''),(2614758,'1','202','1036',477,'Retail Sale Id 876',1502.80,0.00,0.00,2.21,1502.80,'2022-03-23 12:06:23','',''),(2614759,'1','202','1036',477,'Retail Sale Id 877',4864.00,0.00,0.00,8.00,4864.00,'2022-03-23 12:09:38','',''),(2614760,'1','202','1036',477,'Retail Sale Id 878',999.60,0.00,0.00,1.47,999.60,'2022-03-23 12:11:42','',''),(2614761,'1','202','1036',477,'Retail Sale Id 879',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 12:12:45','',''),(2614762,'1','202','1036',477,'Retail Sale Id 880',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 12:25:23','',''),(2614763,'1','202','1036',477,'Retail Sale Id 881',999.60,0.00,0.00,1.47,999.60,'2022-03-23 12:31:14','',''),(2614764,'1','202','1036',477,'Retail Sale Id 882',3400.00,0.00,0.00,5.00,3400.00,'2022-03-23 12:40:02','',''),(2614765,'1','202','1036',477,'Retail Sale Id 883',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 12:56:30','',''),(2614766,'1','202','1036',477,'Retail Sale Id 884',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 13:19:50','',''),(2614767,'1','202','1036',477,'Retail Sale Id 885',1196.80,0.00,0.00,1.76,1196.80,'2022-03-23 13:20:48','',''),(2614768,'1','202','1036',477,'Retail Sale Id 886',700.40,0.00,0.00,1.03,700.40,'2022-03-23 13:21:44','',''),(2614769,'1','202','1036',477,'Retail Sale Id 887',2896.80,0.00,0.00,4.26,2896.80,'2022-03-23 13:37:41','',''),(2614770,'1','202','1036',477,'Retail Sale Id 888',897.60,0.00,0.00,1.32,897.60,'2022-03-23 14:14:27','',''),(2614771,'1','202','1036',477,'Retail Sale Id 889',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 14:35:12','',''),(2614772,'1','202','1036',477,'Retail Sale Id 891',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 14:52:29','',''),(2614773,'1','202','1036',477,'Retail Sale Id 892',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 15:02:29','',''),(2614774,'1','202','1036',477,'Retail Sale Id 893',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 15:15:52','',''),(2614775,'1','202','1036',477,'Retail Sale Id 895',1502.80,0.00,0.00,2.21,1502.80,'2022-03-23 15:21:39','',''),(2614776,'1','202','1036',477,'Retail Sale Id 896',999.60,0.00,0.00,1.47,999.60,'2022-03-23 15:22:51','',''),(2614777,'1','202','1036',477,'Retail Sale Id 897',24320.00,0.00,0.00,40.00,24320.00,'2022-03-23 15:26:45','',''),(2614778,'1','202','1036',477,'Retail Sale Id 898',30400.00,0.00,0.00,50.00,30400.00,'2022-03-23 15:37:58','',''),(2614779,'1','202','1036',477,'Retail Sale Id 899',3801.20,0.00,0.00,5.59,3801.20,'2022-03-23 16:04:55','',''),(2614780,'1','202','1036',477,'Retail Sale Id 900',1196.80,0.00,0.00,1.76,1196.80,'2022-03-23 16:17:22','',''),(2614781,'1','202','1036',477,'Retail Sale Id 901',1802.00,0.00,0.00,2.65,1802.00,'2022-03-23 16:24:31','',''),(2614782,'1','202','1036',477,'Retail Sale Id 902',2998.80,0.00,0.00,4.41,2998.80,'2022-03-23 16:41:12','',''),(2614783,'1','202','1036',477,'Retail Sale Id 903',1502.80,0.00,0.00,2.21,1502.80,'2022-03-23 16:52:47','',''),(2614784,'1','202','1036',477,'Retail Sale Id 904',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 17:03:42','',''),(2614785,'1','202','1036',477,'Retail Sale Id 905',3400.00,0.00,0.00,5.00,3400.00,'2022-03-23 17:11:44','',''),(2614786,'1','202','1036',477,'Retail Sale Id 906',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 17:19:51','',''),(2614787,'1','202','1036',477,'Retail Sale Id 907',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 17:27:02','',''),(2614788,'1','202','1036',477,'Retail Sale Id 908',1951.60,0.00,0.00,2.87,1951.60,'2022-03-23 17:29:58','',''),(2614789,'1','202','1036',477,'Retail Sale Id 909',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 17:40:11','',''),(2614790,'1','202','1036',477,'Retail Sale Id 910',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 17:49:23','',''),(2614791,'1','202','1036',477,'Retail Sale Id 911',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 17:50:10','',''),(2614792,'1','202','1036',477,'Retail Sale Id 912',999.60,0.00,0.00,1.47,999.60,'2022-03-23 17:56:22','',''),(2614793,'1','202','1036',477,'Retail Sale Id 913',1502.80,0.00,0.00,2.21,1502.80,'2022-03-23 18:02:38','',''),(2614794,'1','202','1036',477,'Retail Sale Id 914',999.60,0.00,0.00,1.47,999.60,'2022-03-23 18:03:17','',''),(2614795,'1','202','1036',477,'Retail Sale Id 915',1502.80,0.00,0.00,2.21,1502.80,'2022-03-23 18:09:55','',''),(2614796,'1','202','1036',477,'Retail Sale Id 916',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 18:17:52','',''),(2614797,'1','202','1036',477,'Retail Sale Id 917',4100.40,0.00,0.00,6.03,4100.40,'2022-03-23 18:20:27','',''),(2614798,'1','202','1036',477,'Retail Sale Id 918',8200.80,0.00,0.00,12.06,8200.80,'2022-03-23 18:22:07','',''),(2614799,'1','202','1036',477,'Retail Sale Id 919',999.60,0.00,0.00,1.47,999.60,'2022-03-23 18:23:29','',''),(2614800,'1','202','1036',477,'Retail Sale Id 920',1196.80,0.00,0.00,1.76,1196.80,'2022-03-23 18:25:26','',''),(2614801,'1','202','1036',477,'Retail Sale Id 921',2101.20,0.00,0.00,3.09,2101.20,'2022-03-23 18:27:53','',''),(2614802,'1','202','1036',477,'Retail Sale Id 922',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 18:29:32','',''),(2614803,'1','202','1036',477,'Retail Sale Id 923',15200.00,0.00,0.00,25.00,15200.00,'2022-03-23 18:31:25','',''),(2614804,'1','202','1036',477,'Retail Sale Id 924',1400.80,0.00,0.00,2.06,1400.80,'2022-03-23 18:51:59','',''),(2614805,'1','202','1036',477,'Retail Sale Id 925',2842.40,0.00,0.00,4.18,2842.40,'2022-03-23 19:38:41','',''),(2614806,'1','202','1036',477,'Retail Sale Id 926',1101.60,0.00,0.00,1.62,1101.60,'2022-03-23 19:41:34','',''),(2614807,'1','202','1036',477,'Retail Sale Id 927',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 10:21:39','',''),(2614808,'1','202','1036',477,'Retail Sale Id 928',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 10:22:42','',''),(2614809,'1','202','1036',477,'Retail Sale Id 929',4100.40,0.00,0.00,6.03,4100.40,'2022-03-26 10:30:59','',''),(2614810,'1','202','1036',477,'Retail Sale Id 930',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 10:57:28','',''),(2614811,'1','202','1036',477,'Retail Sale Id 931',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 11:15:39','',''),(2614812,'1','202','1036',477,'Retail Sale Id 932',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 11:22:47','',''),(2614813,'1','202','1036',477,'Retail Sale Id 934',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 11:29:16','',''),(2614814,'1','202','1036',477,'Retail Sale Id 935',2046.80,0.00,0.00,3.01,2046.80,'2022-03-26 11:30:22','',''),(2614815,'1','202','1036',477,'Retail Sale Id 936',2046.80,0.00,0.00,3.01,2046.80,'2022-03-26 11:31:21','',''),(2614816,'1','202','1036',477,'Retail Sale Id 937',2046.80,0.00,0.00,3.01,2046.80,'2022-03-26 11:37:09','',''),(2614817,'1','202','1036',477,'Retail Sale Id 938',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 11:38:27','',''),(2614818,'1','202','1036',477,'Retail Sale Id 939',2998.80,0.00,0.00,4.41,2998.80,'2022-03-26 11:40:12','',''),(2614819,'1','202','1036',477,'Retail Sale Id 940',3060.00,0.00,0.00,4.50,3060.00,'2022-03-26 11:44:22','',''),(2614820,'1','202','1036',477,'Retail Sale Id 942',999.60,0.00,0.00,1.47,999.60,'2022-03-26 11:46:19','',''),(2614821,'1','202','1036',477,'Retail Sale Id 943',4100.40,0.00,0.00,6.03,4100.40,'2022-03-26 11:47:18','',''),(2614822,'1','202','1036',477,'Retail Sale Id 945',7500.40,0.00,0.00,11.03,7500.40,'2022-03-26 11:50:45','',''),(2614823,'1','202','1036',477,'Retail Sale Id 946',4100.40,0.00,0.00,6.03,4100.40,'2022-03-26 12:06:33','',''),(2614824,'1','202','1036',477,'Retail Sale Id 947',3400.00,0.00,0.00,5.00,3400.00,'2022-03-26 12:07:22','',''),(2614825,'1','202','1036',477,'Retail Sale Id 948',3400.00,0.00,0.00,5.00,3400.00,'2022-03-26 12:12:17','',''),(2614826,'1','202','1036',477,'Retail Sale Id 949',2998.80,0.00,0.00,4.41,2998.80,'2022-03-26 12:16:20','',''),(2614827,'1','202','1036',477,'Retail Sale Id 950',2046.80,0.00,0.00,3.01,2046.80,'2022-03-26 12:17:46','',''),(2614828,'1','202','1036',477,'Retail Sale Id 951',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 12:19:27','',''),(2614829,'1','202','1036',477,'Retail Sale Id 952',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 12:23:19','',''),(2614830,'1','202','1036',477,'Retail Sale Id 953',4100.40,0.00,0.00,6.03,4100.40,'2022-03-26 12:28:21','',''),(2614831,'1','202','1036',477,'Retail Sale Id 955',2747.20,0.00,0.00,4.04,2747.20,'2022-03-26 12:35:39','',''),(2614832,'1','202','1036',477,'Retail Sale Id 956',2046.80,0.00,0.00,3.01,2046.80,'2022-03-26 12:38:06','',''),(2614833,'1','202','1036',477,'Retail Sale Id 957',700.40,0.00,0.00,1.03,700.40,'2022-03-26 12:44:08','',''),(2614834,'1','202','1036',477,'Retail Sale Id 958',1196.80,0.00,0.00,1.76,1196.80,'2022-03-26 13:03:32','',''),(2614835,'1','202','1036',477,'Retail Sale Id 959',999.60,0.00,0.00,1.47,999.60,'2022-03-26 13:19:14','',''),(2614836,'1','202','1036',477,'Retail Sale Id 960',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 13:32:44','',''),(2614837,'1','202','1036',477,'Retail Sale Id 961',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 13:36:19','',''),(2614838,'1','202','1036',477,'Retail Sale Id 962',4100.40,0.00,0.00,6.03,4100.40,'2022-03-26 13:44:42','',''),(2614839,'1','202','1036',477,'Retail Sale Id 964',7296.00,0.00,0.00,12.00,7296.00,'2022-03-26 13:53:03','',''),(2614840,'1','202','1036',477,'Retail Sale Id 965',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 13:54:25','',''),(2614841,'1','202','1036',477,'Retail Sale Id 966',3998.40,0.00,0.00,5.88,3998.40,'2022-03-26 13:55:55','',''),(2614842,'1','202','1036',477,'Retail Sale Id 967',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 14:08:32','',''),(2614843,'1','202','1036',477,'Retail Sale Id 968',4100.40,0.00,0.00,6.03,4100.40,'2022-03-26 14:09:41','',''),(2614844,'1','202','1036',477,'Retail Sale Id 969',2046.80,0.00,0.00,3.01,2046.80,'2022-03-26 14:12:53','',''),(2614845,'1','202','1036',477,'Retail Sale Id 970',169632.00,0.00,0.00,279.00,169632.00,'2022-03-26 14:17:42','',''),(2614846,'1','202','1036',477,'Retail Sale Id 973',1360.00,0.00,0.00,2.00,1360.00,'2022-03-26 14:31:34','',''),(2614847,'1','202','1036',477,'Retail Sale Id 974',4100.40,0.00,0.00,6.03,4100.40,'2022-03-26 14:36:25','',''),(2614848,'1','202','1036',477,'Retail Sale Id 975',4998.00,0.00,0.00,7.35,4998.00,'2022-03-26 14:48:36','',''),(2614849,'1','202','1036',477,'Retail Sale Id 976',4399.60,0.00,0.00,6.47,4399.60,'2022-03-26 14:57:25','',''),(2614850,'1','202','1036',477,'Retail Sale Id 977',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 15:12:09','',''),(2614851,'1','202','1036',477,'Retail Sale Id 978',7296.00,0.00,0.00,12.00,7296.00,'2022-03-26 15:25:10','',''),(2614852,'1','202','1036',477,'Retail Sale Id 979',2720.00,0.00,0.00,4.00,2720.00,'2022-03-26 15:50:51','',''),(2614853,'1','202','1036',477,'Retail Sale Id 980',2998.80,0.00,0.00,4.41,2998.80,'2022-03-26 15:51:38','',''),(2614854,'1','202','1036',477,'Retail Sale Id 981',999.60,0.00,0.00,1.47,999.60,'2022-03-26 15:53:13','',''),(2614855,'1','202','1036',477,'Retail Sale Id 983',2502.40,0.00,0.00,3.68,2502.40,'2022-03-26 15:54:13','',''),(2614856,'1','202','1036',477,'Retail Sale Id 984',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 15:55:46','',''),(2614857,'1','202','1036',477,'Retail Sale Id 985',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 15:56:55','',''),(2614858,'1','202','1036',477,'Retail Sale Id 986',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 16:00:51','',''),(2614859,'1','202','1036',477,'Retail Sale Id 987',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 16:04:00','',''),(2614860,'1','202','1036',477,'Retail Sale Id 988',2203.20,0.00,0.00,3.24,2203.20,'2022-03-26 16:07:44','',''),(2614861,'1','202','1036',477,'Retail Sale Id 989',2502.40,0.00,0.00,3.68,2502.40,'2022-03-26 16:11:11','',''),(2614862,'1','202','1036',477,'Retail Sale Id 990',680.00,0.00,0.00,1.00,680.00,'2022-03-26 16:19:47','',''),(2614863,'1','202','1036',477,'Retail Sale Id 991',1298.80,0.00,0.00,1.91,1298.80,'2022-03-26 16:21:00','',''),(2614864,'1','202','1036',477,'Retail Sale Id 992',999.60,0.00,0.00,1.47,999.60,'2022-03-26 16:22:01','',''),(2614865,'1','202','1036',477,'Retail Sale Id 994',1700.00,0.00,0.00,2.50,1700.00,'2022-03-26 16:27:04','',''),(2614866,'1','202','1036',477,'Retail Sale Id 995',2801.60,0.00,0.00,4.12,2801.60,'2022-03-26 16:33:14','',''),(2614867,'1','202','1036',477,'Retail Sale Id 996',1400.80,0.00,0.00,2.06,1400.80,'2022-03-26 16:34:19','',''),(2614868,'1','202','1036',477,'Retail Sale Id 997',999.60,0.00,0.00,1.47,999.60,'2022-03-26 16:47:55','',''),(2614869,'1','202','1036',477,'Retail Sale Id 998',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 16:48:56','',''),(2614870,'1','202','1036',477,'Retail Sale Id 999',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 16:49:30','',''),(2614871,'1','202','1036',477,'Retail Sale Id 1000',4100.40,0.00,0.00,6.03,4100.40,'2022-03-26 17:18:22','',''),(2614872,'1','202','1036',477,'Retail Sale Id 1001',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 17:21:04','',''),(2614873,'1','202','1036',477,'Retail Sale Id 1002',2046.80,0.00,0.00,3.01,2046.80,'2022-03-26 17:42:12','',''),(2614874,'1','202','1036',477,'Retail Sale Id 1003',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 17:43:25','',''),(2614875,'1','202','1036',477,'Retail Sale Id 1005',700.40,0.00,0.00,1.03,700.40,'2022-03-26 17:50:32','',''),(2614876,'1','202','1036',477,'Retail Sale Id 1006',999.60,0.00,0.00,1.47,999.60,'2022-03-26 17:52:17','',''),(2614877,'1','202','1036',477,'Retail Sale Id 1007',2998.80,0.00,0.00,4.41,2998.80,'2022-03-26 17:59:20','',''),(2614878,'1','202','1036',477,'Retail Sale Id 1008',2502.40,0.00,0.00,3.68,2502.40,'2022-03-26 18:13:32','',''),(2614879,'1','202','1036',477,'Retail Sale Id 1009',1999.20,0.00,0.00,2.94,1999.20,'2022-03-26 18:18:17','',''),(2614880,'1','202','1036',477,'Retail Sale Id 1010',3502.00,0.00,0.00,5.15,3502.00,'2022-03-26 18:30:10','',''),(2614881,'1','202','1036',477,'Retail Sale Id 1011',3502.00,0.00,0.00,5.15,3502.00,'2022-03-26 18:30:50','',''),(2614882,'1','202','1036',477,'Retail Sale Id 1012',2801.60,0.00,0.00,4.12,2801.60,'2022-03-26 18:45:14','',''),(2614883,'1','202','1036',477,'Retail Sale Id 1013',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 18:56:53','',''),(2614884,'1','202','1036',477,'Retail Sale Id 1015',999.60,0.00,0.00,1.47,999.60,'2022-03-26 19:00:22','',''),(2614885,'1','202','1036',477,'Retail Sale Id 1016',3896.40,0.00,0.00,5.73,3896.40,'2022-03-26 19:51:45','',''),(2614886,'1','202','1036',477,'Retail Sale Id 1017',8500.00,0.00,0.00,12.50,8500.00,'2022-03-27 07:26:40','',''),(2614887,'1','202','1036',477,'Retail Sale Id 1018',4998.00,0.00,0.00,7.35,4998.00,'2022-03-27 07:34:02','',''),(2614888,'1','202','1036',477,'Retail Sale Id 1019',3400.00,0.00,0.00,5.00,3400.00,'2022-03-27 08:20:01','',''),(2614889,'1','202','1036',477,'Retail Sale Id 1020',700.40,0.00,0.00,1.03,700.40,'2022-03-27 08:22:10','',''),(2614890,'1','202','1036',477,'Retail Sale Id 1021',1700.00,0.00,0.00,2.50,1700.00,'2022-03-27 08:24:01','',''),(2614891,'1','202','1036',477,'Retail Sale Id 1022',999.60,0.00,0.00,1.47,999.60,'2022-03-27 08:24:58','',''),(2614892,'1','202','1036',477,'Retail Sale Id 1023',2998.80,0.00,0.00,4.41,2998.80,'2022-03-27 08:27:10','',''),(2614893,'1','202','1036',477,'Retail Sale Id 1024',1502.80,0.00,0.00,2.21,1502.80,'2022-03-27 08:28:13','',''),(2614894,'1','202','1036',477,'Retail Sale Id 1025',1298.80,0.00,0.00,1.91,1298.80,'2022-03-27 08:29:22','',''),(2614895,'1','202','1036',477,'Retail Sale Id 1026',2747.20,0.00,0.00,4.04,2747.20,'2022-03-27 08:30:23','',''),(2614896,'1','202','1036',477,'Retail Sale Id 1027',33440.00,0.00,0.00,55.00,33440.00,'2022-03-27 08:32:40','',''),(2614897,'1','202','1036',477,'Retail Sale Id 1028',1502.80,0.00,0.00,2.21,1502.80,'2022-03-27 08:33:45','',''),(2614898,'1','202','1036',477,'Retail Sale Id 1029',4100.40,0.00,0.00,6.03,4100.40,'2022-03-27 08:35:18','',''),(2614899,'1','202','1036',477,'Retail Sale Id 1031',6080.00,0.00,0.00,10.00,6080.00,'2022-03-27 08:36:50','',''),(2614900,'1','202','1036',477,'Retail Sale Id 1032',1502.80,0.00,0.00,2.21,1502.80,'2022-03-27 08:39:22','',''),(2614901,'1','202','1036',477,'Retail Sale Id 1034',2101.20,0.00,0.00,3.09,2101.20,'2022-03-27 08:43:00','',''),(2614902,'1','202','1036',477,'Retail Sale Id 1036',4998.00,0.00,0.00,7.35,4998.00,'2022-03-27 08:45:01','',''),(2614903,'1','202','1036',477,'Retail Sale Id 1037',3998.40,0.00,0.00,5.88,3998.40,'2022-03-27 08:48:29','',''),(2614904,'1','202','1036',477,'Retail Sale Id 1038',2998.80,0.00,0.00,4.41,2998.80,'2022-03-27 08:49:36','',''),(2614905,'1','202','1036',477,'Retail Sale Id 1039',27360.00,0.00,0.00,45.00,27360.00,'2022-03-27 08:52:52','',''),(2614906,'1','202','1036',477,'Retail Sale Id 1040',999.60,0.00,0.00,1.47,999.60,'2022-03-27 08:54:09','',''),(2614907,'1','202','1036',477,'Retail Sale Id 1041',2502.40,0.00,0.00,3.68,2502.40,'2022-03-27 08:55:37','',''),(2614908,'1','202','1036',477,'Retail Sale Id 1042',2801.60,0.00,0.00,4.12,2801.60,'2022-03-27 09:04:08','',''),(2614909,'1','202','1036',477,'Retail Sale Id 1044',701.76,0.00,0.00,1.02,701.76,'2022-03-27 09:16:26','',''),(2614910,'1','202','1036',477,'Retail Sale Id 1045',668800.00,0.00,0.00,1100.00,668800.00,'2022-03-27 09:57:22','',''),(2614911,'1','202','1036',477,'Return of Retail Sale Id 1044',0.00,701.76,1.02,0.00,-701.76,'2022-03-27 10:07:41','',''),(2614912,'1','202','1036',477,'Return of Retail Sale Id 1018',0.00,4998.00,7.35,0.00,-4998.00,'2022-03-27 10:30:01','',''),(2614913,'1','202','1036',477,'Retail Sale Id 1048',2497.44,0.00,0.00,3.63,657.03,'2022-03-27 10:49:32','',''),(2614914,'1','202','1036',477,'Retail Sale Id 1049',15600.00,0.00,0.00,25.00,2925.00,'2022-03-27 11:02:09','',''),(2614915,'1','202','1036',477,'Retail Sale Id 1050',2002.08,0.00,0.00,2.91,526.71,'2022-03-27 11:12:14','',''),(2614916,'1','202','1036',477,'Retail Sale Id 1051',2752.00,0.00,0.00,4.00,724.00,'2022-03-27 11:19:36','',''),(2614917,'1','202','1036',477,'Retail Sale Id 1052',3900.96,0.00,0.00,5.67,1026.27,'2022-03-27 11:20:43','',''),(2614918,'1','202','1036',477,'Retail Sale Id 1053',1396.64,0.00,0.00,2.03,367.43,'2022-03-27 11:21:51','',''),(2614919,'1','202','1036',477,'Retail Sale Id 1054',3501.92,0.00,0.00,5.09,921.29,'2022-03-27 11:23:50','',''),(2614920,'1','202','1036',477,'Retail Sale Id 1055',4196.80,0.00,0.00,6.10,1104.10,'2022-03-27 11:33:27','',''),(2614921,'1','202','1036',477,'Retail Sale Id 1056',26208.00,0.00,0.00,42.00,4914.00,'2022-03-27 11:35:40','',''),(2614922,'1','202','1036',477,'Retail Sale Id 1057',3446.88,0.00,0.00,5.01,906.81,'2022-03-27 11:37:35','',''),(2614923,'1','202','1036',477,'Retail Sale Id 1058',1396.64,0.00,0.00,2.03,367.43,'2022-03-27 11:41:47','',''),(2614924,'1','202','1036',477,'Retail Sale Id 1059',5497.12,0.00,0.00,7.99,1446.19,'2022-03-27 11:44:33','',''),(2614925,'1','202','1036',477,'Retail Sale Id 1060',1802.56,0.00,0.00,2.62,474.22,'2022-03-27 11:46:42','',''),(2614926,'1','202','1036',477,'Retail Sale Id 1061',2002.08,0.00,0.00,2.91,526.71,'2022-03-27 11:48:00','',''),(2614927,'1','202','1036',477,'Retail Sale Id 1062',1396.64,0.00,0.00,2.03,367.43,'2022-03-27 11:49:24','',''),(2614928,'1','202','1036',477,'Retail Sale Id 1063',997.60,0.00,0.00,1.45,262.45,'2022-03-27 11:54:39','',''),(2614929,'1','202','1036',477,'Retail Sale Id 1064',37440.00,0.00,0.00,60.00,7020.00,'2022-03-27 11:57:44','',''),(2614930,'1','202','1036',477,'Retail Sale Id 1065',8496.80,0.00,0.00,12.35,2235.35,'2022-03-27 11:59:25','',''),(2614931,'1','202','1036',477,'Retail Sale Id 1066',6240.00,0.00,0.00,10.00,1170.00,'2022-03-27 12:12:29','',''),(2614932,'1','202','1036',477,'Retail Sale Id 1067',997.60,0.00,0.00,1.45,262.45,'2022-03-27 12:13:30','',''),(2614933,'1','202','1036',477,'Retail Sale Id 1068',8999.04,0.00,0.00,13.08,2367.48,'2022-03-27 12:14:59','',''),(2614934,'1','202','1036',477,'Return of Retail Sale Id 1068',0.00,8999.04,13.08,0.00,-2367.48,'2022-03-27 12:16:44','',''),(2614935,'1','202','1036',477,'Retail Sale Id 1069',8600.00,0.00,0.00,12.50,2262.50,'2022-03-27 12:17:36','',''),(2614936,'1','202','1036',477,'Retail Sale Id 1070',2002.08,0.00,0.00,2.91,526.71,'2022-03-27 12:19:17','',''),(2614937,'1','202','1036',477,'Retail Sale Id 1071',2002.08,0.00,0.00,2.91,526.71,'2022-03-27 12:20:47','',''),(2614938,'1','202','1036',477,'Retail Sale Id 1072',5552.16,0.00,0.00,8.07,1460.67,'2022-03-27 12:29:01','',''),(2614939,'1','202','1036',477,'Retail Sale Id 1073',8496.80,0.00,0.00,12.35,2235.35,'2022-03-27 12:41:28','',''),(2614940,'1','202','1036',477,'Retail Sale Id 1074',4196.80,0.00,0.00,6.10,1104.10,'2022-03-27 12:47:48','',''),(2614941,'1','202','1036',477,'Retail Sale Id 1075',35568.00,0.00,0.00,57.00,6669.00,'2022-03-27 13:05:28','',''),(2614942,'1','202','1036',477,'Retail Sale Id 1076',3446.88,0.00,0.00,5.01,906.81,'2022-03-27 13:06:46','',''),(2614943,'1','202','1036',477,'Retail Sale Id 1077',997.60,0.00,0.00,1.45,262.45,'2022-03-27 13:29:41','',''),(2614944,'1','202','1036',477,'Retail Sale Id 1078',997.60,0.00,0.00,1.45,262.45,'2022-03-27 13:37:02','',''),(2614945,'1','202','1036',477,'Retail Sale Id 1079',1499.84,0.00,0.00,2.18,394.58,'2022-03-27 13:40:45','',''),(2614946,'1','202','1036',477,'Retail Sale Id 1080',2201.60,0.00,0.00,3.20,579.20,'2022-03-27 13:46:54','',''),(2614947,'1','202','1036',477,'Retail Sale Id 1081',3446.88,0.00,0.00,5.01,906.81,'2022-03-27 13:56:22','',''),(2614948,'1','202','1036',477,'Retail Sale Id 1082',1197.12,0.00,0.00,1.74,314.94,'2022-03-27 13:58:24','',''),(2614949,'1','202','1036',477,'Retail Sale Id 1084',1699.36,0.00,0.00,2.47,447.07,'2022-03-27 14:06:14','',''),(2614950,'1','202','1036',477,'Retail Sale Id 1085',8600.00,0.00,0.00,12.50,2262.50,'2022-03-27 14:08:16','',''),(2614951,'1','202','1036',477,'Retail Sale Id 1086',701.76,0.00,0.00,1.02,184.62,'2022-03-27 14:17:13','',''),(2614952,'1','202','1036',477,'Retail Sale Id 1087',997.60,0.00,0.00,1.45,262.45,'2022-03-27 14:23:58','',''),(2614953,'1','202','1036',477,'Retail Sale Id 1088',1396.64,0.00,0.00,2.03,367.43,'2022-03-27 14:25:41','',''),(2614954,'1','202','1036',477,'Retail Sale Id 1089',2002.08,0.00,0.00,2.91,526.71,'2022-03-27 14:27:03','',''),(2614955,'1','202','1036',477,'Retail Sale Id 1090',2497.44,0.00,0.00,3.63,657.03,'2022-03-27 14:33:06','',''),(2614956,'1','202','1036',477,'Retail Sale Id 1091',997.60,0.00,0.00,1.45,262.45,'2022-03-27 14:33:58','',''),(2614957,'1','202','1036',477,'Retail Sale Id 1092',1499.84,0.00,0.00,2.18,394.58,'2022-03-27 14:39:40','',''),(2614958,'1','202','1036',477,'Retail Sale Id 1093',4196.80,0.00,0.00,6.10,1104.10,'2022-03-27 14:42:37','',''),(2614959,'1','202','1036',477,'Retail Sale Id 1094',2002.08,0.00,0.00,2.91,526.71,'2022-03-27 14:46:50','',''),(2614960,'1','202','1036',477,'Retail Sale Id 1095',997.60,0.00,0.00,1.45,262.45,'2022-03-27 14:49:51','',''),(2614961,'1','202','1036',477,'Retail Sale Id 1096',2002.08,0.00,0.00,2.91,526.71,'2022-03-27 14:54:17','',''),(2614962,'1','202','1036',477,'Retail Sale Id 1097',5999.36,0.00,0.00,8.72,1578.32,'2022-03-27 14:59:32','',''),(2614963,'1','202','1036',477,'Retail Sale Id 1098',6996.96,0.00,0.00,10.17,1840.77,'2022-03-27 15:00:17','',''),(2614964,'1','202','1036',477,'Retail Sale Id 1099',997.60,0.00,0.00,1.45,262.45,'2022-03-27 15:17:34','',''),(2614965,'1','202','1036',477,'Retail Sale Id 1100',2999.68,0.00,0.00,4.36,789.16,'2022-03-27 15:18:18','',''),(2614966,'1','202','1036',477,'Retail Sale Id 1101',901.28,0.00,0.00,1.31,237.11,'2022-03-27 15:19:31','',''),(2614967,'1','202','1036',477,'Retail Sale Id 1102',8600.00,0.00,0.00,12.50,2262.50,'2022-03-27 15:53:36','',''),(2614968,'1','202','1036',477,'Retail Sale Id 1103',701.76,0.00,0.00,1.02,184.62,'2022-03-27 15:54:20','',''),(2614969,'1','202','1036',477,'Retail Sale Id 1104',8600.00,0.00,0.00,12.50,2262.50,'2022-03-27 16:06:27','',''),(2614970,'1','202','1036',477,'Retail Sale Id 1105',2999.68,0.00,0.00,4.36,789.16,'2022-03-27 16:10:38','',''),(2614971,'1','202','1036',477,'Retail Sale Id 1106',34320.00,0.00,0.00,55.00,6435.00,'2022-03-27 16:14:20','',''),(2614972,'1','202','1036',477,'Retail Sale Id 1107',2002.08,0.00,0.00,2.91,526.71,'2022-03-27 16:17:07','',''),(2614973,'1','202','1036',477,'Retail Sale Id 1108',3997.28,0.00,0.00,5.81,1051.61,'2022-03-27 16:27:43','',''),(2614974,'1','202','1036',477,'Retail Sale Id 1109',2098.40,0.00,0.00,3.05,552.05,'2022-03-27 16:33:52','',''),(2614975,'1','202','1036',477,'Retail Sale Id 1110',8600.00,0.00,0.00,12.50,2262.50,'2022-03-27 16:39:28','',''),(2614976,'1','202','1036',477,'Retail Sale Id 1111',2497.44,0.00,0.00,3.63,657.03,'2022-03-27 16:41:31','',''),(2614977,'1','202','1036',477,'Retail Sale Id 1112',997.60,0.00,0.00,1.45,262.45,'2022-03-27 16:43:24','',''),(2614978,'1','202','1036',477,'Retail Sale Id 1113',997.60,0.00,0.00,1.45,262.45,'2022-03-27 16:52:41','',''),(2614979,'1','202','1036',477,'Retail Sale Id 1114',5001.76,0.00,0.00,7.27,1315.87,'2022-03-27 16:57:44','',''),(2614980,'1','202','1036',477,'Retail Sale Id 1115',8600.00,0.00,0.00,12.50,2262.50,'2022-03-27 17:00:08','',''),(2614981,'1','202','1036',477,'Retail Sale Id 1116',3446.88,0.00,0.00,5.01,906.81,'2022-03-27 17:06:30','',''),(2614982,'1','202','1036',477,'Retail Sale Id 1120',1396.64,0.00,0.00,2.03,367.43,'2022-03-27 17:10:44','',''),(2614983,'1','202','1036',477,'Retail Sale Id 1121',2098.40,0.00,0.00,3.05,552.05,'2022-03-27 17:19:48','',''),(2614984,'1','202','1036',477,'Retail Sale Id 1122',8600.00,0.00,0.00,12.50,2262.50,'2022-03-27 17:23:11','',''),(2614985,'1','202','1036',477,'Retail Sale Id 1123',1396.64,0.00,0.00,2.03,367.43,'2022-03-27 17:30:04','',''),(2614986,'1','202','1036',477,'Retail Sale Id 1124',1499.84,0.00,0.00,2.18,394.58,'2022-03-27 17:37:52','',''),(2614987,'1','202','1036',477,'Retail Sale Id 1125',1197.12,0.00,0.00,1.74,314.94,'2022-03-27 17:41:29','',''),(2614988,'1','202','1036',477,'Retail Sale Id 1126',6900.64,0.00,0.00,10.03,1815.43,'2022-03-27 17:42:40','',''),(2614989,'1','202','1036',477,'Retail Sale Id 1127',4196.80,0.00,0.00,6.10,1104.10,'2022-03-27 17:43:42','',''),(2614990,'1','202','1036',477,'Retail Sale Id 1128',3446.88,0.00,0.00,5.01,906.81,'2022-03-27 17:46:16','',''),(2614991,'1','202','1036',477,'Retail Sale Id 1129',8600.00,0.00,0.00,12.50,2262.50,'2022-03-27 17:54:10','',''),(2614992,'1','202','1036',477,'Retail Sale Id 1130',997.60,0.00,0.00,1.45,262.45,'2022-03-27 17:55:33','',''),(2614993,'1','202','1036',477,'Retail Sale Id 1131',8600.00,0.00,0.00,12.50,2262.50,'2022-03-27 18:01:23','',''),(2614994,'1','202','1036',477,'Retail Sale Id 1132',2999.68,0.00,0.00,4.36,789.16,'2022-03-27 18:10:28','',''),(2614995,'1','202','1036',477,'Retail Sale Id 1133',997.60,0.00,0.00,1.45,262.45,'2022-03-27 18:11:57','',''),(2614996,'1','202','1036',477,'Retail Sale Id 1134',5999.36,0.00,0.00,8.72,1578.32,'2022-03-27 18:13:05','',''),(2614997,'1','202','1036',477,'Retail Sale Id 1135',1499.84,0.00,0.00,2.18,394.58,'2022-03-27 18:28:44','',''),(2614998,'1','202','1036',477,'Retail Sale Id 1136',1499.84,0.00,0.00,2.18,394.58,'2022-03-27 18:29:32','',''),(2614999,'1','202','1036',477,'Retail Sale Id 1137',3446.88,0.00,0.00,5.01,906.81,'2022-03-27 18:32:50','',''),(2615000,'1','202','1036',477,'Retail Sale Id 1138',5999.36,0.00,0.00,8.72,1578.32,'2022-03-27 18:33:44','',''),(2615001,'1','202','1036',477,'Retail Sale Id 1139',2002.08,0.00,0.00,2.91,526.71,'2022-03-27 18:37:37','',''),(2615002,'1','202','1036',477,'Retail Sale Id 1140',2999.68,0.00,0.00,4.36,789.16,'2022-03-27 18:43:01','',''),(2615003,'1','202','1036',477,'Retail Sale Id 1141',3997.28,0.00,0.00,5.81,1051.61,'2022-03-27 18:48:51','',''),(2615004,'1','202','1036',477,'Retail Sale Id 1142',4196.80,0.00,0.00,6.10,1104.10,'2022-03-27 18:57:59','',''),(2615005,'1','202','1036',477,'Retail Sale Id 1143',6895.20,0.00,0.00,11.05,1292.85,'2022-03-27 19:27:14','',''),(2615006,'1','202','1036',477,'Retail Sale Id 1144',50313.44,0.00,0.00,73.13,13236.53,'2022-03-27 19:29:10','',''),(2615007,'1','202','1036',477,'Retail Sale Id 1145',2002.08,0.00,0.00,2.91,526.71,'2022-03-28 12:25:11','',''),(2615008,'1','202','1036',477,'Retail Sale Id 1146',15600.00,0.00,0.00,25.00,2925.00,'2022-03-28 12:27:02','',''),(2615009,'1','202','1036',477,'Retail Sale Id 1147',8600.00,0.00,0.00,12.50,2262.50,'2022-03-28 12:28:12','',''),(2615010,'1','202','1036',477,'Retail Sale Id 1148',2002.08,0.00,0.00,2.91,526.71,'2022-03-28 12:48:22','',''),(2615011,'1','202','1036',477,'Retail Sale Id 1149',3446.88,0.00,0.00,5.01,906.81,'2022-03-28 12:49:59','',''),(2615012,'1','202','1036',477,'Retail Sale Id 1150',3446.88,0.00,0.00,5.01,906.81,'2022-03-28 12:54:01','',''),(2615013,'1','202','1036',477,'Retail Sale Id 1151',2002.08,0.00,0.00,2.91,526.71,'2022-03-28 12:55:12','',''),(2615014,'1','202','1036',477,'Retail Sale Id 1152',2002.08,0.00,0.00,2.91,526.71,'2022-03-28 12:56:20','',''),(2615015,'1','202','1036',477,'Retail Sale Id 1153',42432.00,0.00,0.00,68.00,7956.00,'2022-03-28 13:17:56','',''),(2615016,'1','202','1036',477,'Retail Sale Id 1154',25584.00,0.00,0.00,41.00,4797.00,'2022-03-28 13:21:20','',''),(2615017,'1','202','1036',477,'Retail Sale Id 1155',4148.64,0.00,0.00,6.03,1091.43,'2022-03-28 13:37:53','',''),(2615018,'1','202','1036',477,'Retail Sale Id 1156',502.24,0.00,0.00,0.73,132.13,'2022-03-28 13:50:56','',''),(2615019,'1','202','1036',477,'Retail Sale Id 1157',3446.88,0.00,0.00,5.01,906.81,'2022-03-28 13:55:30','',''),(2615020,'1','202','1036',477,'Retail Sale Id 1158',8600.00,0.00,0.00,12.50,2262.50,'2022-03-28 13:59:20','',''),(2615021,'1','202','1036',477,'Retail Sale Id 1159',1499.84,0.00,0.00,2.18,394.58,'2022-03-28 14:20:17','',''),(2615022,'1','202','1036',477,'Retail Sale Id 1160',502.24,0.00,0.00,0.73,132.13,'2022-03-28 14:27:22','',''),(2615023,'1','202','1036',477,'Retail Sale Id 1161',3997.28,0.00,0.00,5.81,1051.61,'2022-03-28 14:42:31','',''),(2615024,'1','202','1036',477,'Retail Sale Id 1162',1499.84,0.00,0.00,2.18,394.58,'2022-03-28 14:43:53','',''),(2615025,'1','202','1036',477,'Retail Sale Id 1163',1197.12,0.00,0.00,1.74,314.94,'2022-03-28 14:50:59','',''),(2615026,'1','202','1036',477,'Retail Sale Id 1164',2999.68,0.00,0.00,4.36,789.16,'2022-03-28 15:02:49','',''),(2615027,'1','202','1036',477,'Retail Sale Id 1165',8600.00,0.00,0.00,12.50,2262.50,'2022-03-28 15:12:00','',''),(2615028,'1','202','1036',477,'Retail Sale Id 1166',3446.88,0.00,0.00,5.01,906.81,'2022-03-28 15:24:33','',''),(2615029,'1','202','1036',477,'Retail Sale Id 1168',3997.28,0.00,0.00,5.81,1051.61,'2022-03-28 15:37:10','',''),(2615030,'1','202','1036',477,'Retail Sale Id 1169',4196.80,0.00,0.00,6.10,1104.10,'2022-03-28 15:42:11','',''),(2615031,'1','202','1036',477,'Retail Sale Id 1170',3997.28,0.00,0.00,5.81,1051.61,'2022-03-28 15:47:02','',''),(2615032,'1','202','1036',477,'Retail Sale Id 1172',2999.68,0.00,0.00,4.36,789.16,'2022-03-28 16:07:29','',''),(2615033,'1','202','1036',477,'Retail Sale Id 1173',2002.08,0.00,0.00,2.91,526.71,'2022-03-28 16:13:23','',''),(2615034,'1','202','1036',477,'Retail Sale Id 1174',4196.80,0.00,0.00,6.10,1104.10,'2022-03-28 16:22:12','',''),(2615035,'1','202','1036',477,'Retail Sale Id 1175',2098.40,0.00,0.00,3.05,552.05,'2022-03-28 16:53:50','',''),(2615036,'1','202','1036',477,'Retail Sale Id 1176',8600.00,0.00,0.00,12.50,2262.50,'2022-03-28 16:59:06','',''),(2615037,'1','202','1036',477,'Retail Sale Id 1177',2497.44,0.00,0.00,3.63,657.03,'2022-03-28 17:07:35','',''),(2615038,'1','202','1036',477,'Retail Sale Id 1178',2098.40,0.00,0.00,3.05,552.05,'2022-03-28 17:08:43','',''),(2615039,'1','202','1036',477,'Retail Sale Id 1179',6996.96,0.00,0.00,10.17,1840.77,'2022-03-28 17:16:37','',''),(2615040,'1','202','1036',477,'Retail Sale Id 1180',2098.40,0.00,0.00,3.05,552.05,'2022-03-28 17:22:29','',''),(2615041,'1','202','1036',477,'Retail Sale Id 1181',2752.00,0.00,0.00,4.00,724.00,'2022-03-28 17:25:02','',''),(2615042,'1','202','1036',477,'Retail Sale Id 1182',1376.00,0.00,0.00,2.00,362.00,'2022-03-28 17:27:26','',''),(2615043,'1','202','1036',477,'Retail Sale Id 1183',3997.28,0.00,0.00,5.81,1051.61,'2022-03-28 17:29:40','',''),(2615044,'1','202','1036',477,'Retail Sale Id 1184',3446.88,0.00,0.00,5.01,906.81,'2022-03-28 17:31:55','',''),(2615045,'1','202','1036',477,'Retail Sale Id 1185',2098.40,0.00,0.00,3.05,552.05,'2022-03-28 17:34:43','',''),(2615046,'1','202','1036',477,'Retail Sale Id 1186',2098.40,0.00,0.00,3.05,552.05,'2022-03-28 17:36:01','',''),(2615047,'1','202','1036',477,'Retail Sale Id 1187',2002.08,0.00,0.00,2.91,526.71,'2022-03-28 17:43:35','',''),(2615048,'1','202','1036',477,'Retail Sale Id 1188',997.60,0.00,0.00,1.45,262.45,'2022-03-28 17:55:09','',''),(2615049,'1','202','1036',477,'Retail Sale Id 1189',2999.68,0.00,0.00,4.36,789.16,'2022-03-28 18:07:22','',''),(2615050,'1','202','1036',477,'Retail Sale Id 1190',8600.00,0.00,0.00,12.50,2262.50,'2022-03-28 18:37:01','',''),(2615051,'1','202','1036',477,'Retail Sale Id 1191',4196.80,0.00,0.00,6.10,1104.10,'2022-03-28 18:40:15','',''),(2615052,'1','202','1036',477,'Retail Sale Id 1192',4196.80,0.00,0.00,6.10,1104.10,'2022-03-28 18:44:21','',''),(2615053,'1','202','1036',477,'Retail Sale Id 1193',997.60,0.00,0.00,1.45,262.45,'2022-03-28 18:47:59','',''),(2615054,'1','202','1036',477,'Retail Sale Id 1194',2752.00,0.00,0.00,4.00,724.00,'2022-03-28 18:50:30','',''),(2615055,'1','202','1036',477,'Retail Sale Id 1195',3446.88,0.00,0.00,5.01,906.81,'2022-03-28 19:01:36','',''),(2615056,'1','202','1036',477,'Retail Sale Id 1196',997.60,0.00,0.00,1.45,262.45,'2022-03-28 19:02:38','',''),(2615057,'1','202','1036',477,'Retail Sale Id 1197',21197.28,0.00,0.00,30.81,5576.61,'2022-03-28 19:23:08','',''),(2615058,'1','202','1036',477,'Retail Sale Id 1198',1499.84,0.00,0.00,2.18,394.58,'2022-03-29 07:18:52','',''),(2615059,'1','202','1036',477,'Retail Sale Id 1199',8600.00,0.00,0.00,12.50,2262.50,'2022-03-29 07:19:39','',''),(2615060,'1','202','1036',477,'Retail Sale Id 1200',997.60,0.00,0.00,1.45,262.45,'2022-03-29 07:21:07','',''),(2615061,'1','202','1036',477,'Retail Sale Id 1203',2999.68,0.00,0.00,4.36,789.16,'2022-03-29 07:24:27','',''),(2615062,'1','202','1036',477,'Retail Sale Id 1204',2002.08,0.00,0.00,2.91,526.71,'2022-03-29 07:31:46','',''),(2615063,'1','202','1036',477,'Retail Sale Id 1206',3501.92,0.00,0.00,5.09,921.29,'2022-03-29 07:36:34','',''),(2615064,'1','202','1036',477,'Retail Sale Id 1207',1396.64,0.00,0.00,2.03,367.43,'2022-03-29 07:40:34','',''),(2615065,'1','202','1036',477,'Retail Sale Id 1208',4300.00,0.00,0.00,6.25,1131.25,'2022-03-29 07:50:58','',''),(2615066,'1','202','1036',477,'Retail Sale Id 1209',4196.80,0.00,0.00,6.10,1104.10,'2022-03-29 07:54:21','',''),(2615067,'1','202','1036',477,'Retail Sale Id 1210',2999.68,0.00,0.00,4.36,789.16,'2022-03-29 07:58:45','',''),(2615068,'1','202','1036',477,'Retail Sale Id 1211',4196.80,0.00,0.00,6.10,1104.10,'2022-03-29 07:59:48','',''),(2615069,'1','202','1036',477,'Retail Sale Id 1212',2098.40,0.00,0.00,3.05,552.05,'2022-03-29 08:02:05','',''),(2615070,'1','202','1036',477,'Retail Sale Id 1213',4196.80,0.00,0.00,6.10,1104.10,'2022-03-29 09:43:03','',''),(2615071,'1','202','1036',477,'Retail Sale Id 1215',2098.40,0.00,0.00,3.05,552.05,'2022-03-29 10:59:45','',''),(2615072,'1','202','1036',477,'Retail Sale Id 1216',2098.40,0.00,0.00,3.05,552.05,'2022-03-29 11:19:39','',''),(2615073,'1','202','1036',477,'Retail Sale Id 1217',701.76,0.00,0.00,1.02,184.62,'2022-03-29 11:23:37','',''),(2615074,'1','202','1036',477,'Retail Sale Id 1218',2297.92,0.00,0.00,3.34,604.54,'2022-03-29 11:24:53','',''),(2615075,'1','202','1036',477,'Retail Sale Id 1219',65520.00,0.00,0.00,105.00,12285.00,'2022-03-29 11:54:54','',''),(2615076,'1','202','1036',477,'Retail Sale Id 1220',3446.88,0.00,0.00,5.01,906.81,'2022-03-29 12:08:54','',''),(2615077,'1','202','1036',477,'Retail Sale Id 1221',8600.00,0.00,0.00,12.50,2262.50,'2022-03-29 12:54:56','',''),(2615078,'1','202','1036',477,'Retail Sale Id 1222',2098.40,0.00,0.00,3.05,552.05,'2022-03-29 13:02:31','',''),(2615079,'1','202','1036',477,'Retail Sale Id 1223',997.60,0.00,0.00,1.45,262.45,'2022-03-29 13:25:47','',''),(2615080,'1','202','1036',477,'Retail Sale Id 1224',2098.40,0.00,0.00,3.05,552.05,'2022-03-29 13:27:22','',''),(2615081,'1','202','1036',477,'Retail Sale Id 1225',997.60,0.00,0.00,1.45,262.45,'2022-03-29 13:29:54','',''),(2615082,'1','202','1036',477,'Retail Sale Id 1226',502.24,0.00,0.00,0.73,132.13,'2022-03-29 13:39:36','',''),(2615083,'1','202','1036',477,'Retail Sale Id 1227',8600.00,0.00,0.00,12.50,2262.50,'2022-03-29 14:02:31','',''),(2615084,'1','202','1036',477,'Retail Sale Id 1228',701.76,0.00,0.00,1.02,184.62,'2022-03-29 14:09:34','',''),(2615085,'1','202','1036',477,'Retail Sale Id 1229',3997.28,0.00,0.00,5.81,1051.61,'2022-03-29 14:21:22','',''),(2615086,'1','202','1036',477,'Retail Sale Id 1230',2500.00,0.00,0.00,1.00,1993.00,'2022-03-29 14:26:18','',''),(2615087,'1','202','1036',477,'Retail Sale Id 1231',34320.00,0.00,0.00,55.00,6435.00,'2022-03-29 14:32:33','',''),(2615088,'1','202','1036',477,'Retail Sale Id 1232',2999.68,0.00,0.00,4.36,789.16,'2022-03-29 14:37:39','',''),(2615089,'1','202','1036',477,'Retail Sale Id 1233',4196.80,0.00,0.00,6.10,1104.10,'2022-03-29 14:39:25','',''),(2615090,'1','202','1036',477,'Retail Sale Id 1234',10608.00,0.00,0.00,17.00,1989.00,'2022-03-29 15:17:47','',''),(2615091,'1','202','1036',477,'Retail Sale Id 1235',997.60,0.00,0.00,1.45,262.45,'2022-03-29 15:21:14','',''),(2615092,'1','202','1036',477,'Retail Sale Id 1236',1499.84,0.00,0.00,2.18,394.58,'2022-03-29 15:26:36','',''),(2615093,'1','202','1036',477,'Retail Sale Id 1237',4196.80,0.00,0.00,6.10,1104.10,'2022-03-29 15:28:40','',''),(2615094,'1','202','1036',477,'Retail Sale Id 1238',2002.08,0.00,0.00,2.91,526.71,'2022-03-29 15:30:37','',''),(2615095,'1','202','1036',477,'Retail Sale Id 1239',1947.04,0.00,0.00,2.83,512.23,'2022-03-29 15:54:50','',''),(2615096,'1','202','1036',477,'Retail Sale Id 1240',1499.84,0.00,0.00,2.18,394.58,'2022-03-29 15:57:57','',''),(2615097,'1','202','1036',477,'Retail Sale Id 1241',2070.88,0.00,0.00,3.01,544.81,'2022-03-29 15:59:38','',''),(2615098,'1','202','1036',477,'Retail Sale Id 1242',3440.00,0.00,0.00,5.00,905.00,'2022-03-29 16:04:34','',''),(2615099,'1','202','1036',477,'Retail Sale Id 1243',8600.00,0.00,0.00,12.50,2262.50,'2022-03-29 16:05:44','',''),(2615100,'1','202','1036',477,'Retail Sale Id 1244',2002.08,0.00,0.00,2.91,526.71,'2022-03-29 16:06:49','',''),(2615101,'1','202','1036',477,'Retail Sale Id 1245',1499.84,0.00,0.00,2.18,394.58,'2022-03-29 16:47:26','',''),(2615102,'1','202','1036',477,'Retail Sale Id 1247',2098.40,0.00,0.00,3.05,552.05,'2022-03-29 16:50:54','',''),(2615103,'1','202','1036',477,'Retail Sale Id 1248',2999.68,0.00,0.00,4.36,789.16,'2022-03-29 16:51:46','',''),(2615104,'1','202','1036',477,'Retail Sale Id 1249',2999.68,0.00,0.00,4.36,789.16,'2022-03-29 17:00:18','',''),(2615105,'1','202','1036',477,'Retail Sale Id 1250',2497.44,0.00,0.00,3.63,657.03,'2022-03-29 17:01:53','',''),(2615106,'1','202','1036',477,'Retail Sale Id 1251',997.60,0.00,0.00,1.45,262.45,'2022-03-29 17:06:45','',''),(2615107,'1','202','1036',477,'Retail Sale Id 1252',4196.80,0.00,0.00,6.10,1104.10,'2022-03-29 17:07:51','',''),(2615108,'1','202','1036',477,'Retail Sale Id 1253',4196.80,0.00,0.00,6.10,1104.10,'2022-03-29 17:08:49','',''),(2615109,'1','202','1036',477,'Retail Sale Id 1254',2098.40,0.00,0.00,3.05,552.05,'2022-03-29 17:11:17','',''),(2615110,'1','202','1036',477,'Retail Sale Id 1255',1396.64,0.00,0.00,2.03,367.43,'2022-03-29 17:12:53','',''),(2615111,'1','202','1036',477,'Retail Sale Id 1256',2098.40,0.00,0.00,3.05,552.05,'2022-03-29 17:16:54','',''),(2615112,'1','202','1036',477,'Retail Sale Id 1257',8600.00,0.00,0.00,12.50,2262.50,'2022-03-29 17:25:14','',''),(2615113,'1','202','1036',477,'Retail Sale Id 1258',2752.00,0.00,0.00,4.00,724.00,'2022-03-29 17:27:17','',''),(2615114,'1','202','1036',477,'Retail Sale Id 1260',7602.40,0.00,0.00,11.05,2000.05,'2022-03-29 17:29:45','',''),(2615115,'1','202','1036',477,'Retail Sale Id 1261',1396.64,0.00,0.00,2.03,367.43,'2022-03-29 17:30:53','',''),(2615116,'1','202','1036',477,'Retail Sale Id 1262',9360.00,0.00,0.00,15.00,1755.00,'2022-03-29 17:32:05','',''),(2615117,'1','202','1036',477,'Retail Sale Id 1263',2002.08,0.00,0.00,2.91,526.71,'2022-03-29 17:33:06','',''),(2615118,'1','202','1036',477,'Retail Sale Id 1264',6996.96,0.00,0.00,10.17,1840.77,'2022-03-29 17:33:50','',''),(2615119,'1','202','1036',477,'Retail Sale Id 1265',8600.00,0.00,0.00,12.50,2262.50,'2022-03-29 17:34:48','',''),(2615120,'1','202','1036',477,'Retail Sale Id 1266',6900.64,0.00,0.00,10.03,1815.43,'2022-03-29 17:35:42','',''),(2615121,'1','202','1036',477,'Retail Sale Id 1267',2002.08,0.00,0.00,2.91,526.71,'2022-03-29 17:36:26','',''),(2615122,'1','202','1036',477,'Retail Sale Id 1268',997.60,0.00,0.00,1.45,262.45,'2022-03-29 17:37:07','',''),(2615123,'1','202','1036',477,'Retail Sale Id 1269',2098.40,0.00,0.00,3.05,552.05,'2022-03-29 17:39:13','',''),(2615124,'1','202','1036',477,'Retail Sale Id 1270',1802.56,0.00,0.00,2.62,474.22,'2022-03-29 17:41:06','',''),(2615125,'1','202','1036',477,'Retail Sale Id 1271',997.60,0.00,0.00,1.45,262.45,'2022-03-29 17:53:14','',''),(2615126,'1','202','1036',477,'Retail Sale Id 1272',997.60,0.00,0.00,1.45,262.45,'2022-03-29 17:54:02','',''),(2615127,'1','202','1036',477,'Retail Sale Id 1273',2752.00,0.00,0.00,4.00,724.00,'2022-03-29 18:17:20','',''),(2615128,'1','202','1036',477,'Retail Sale Id 1274',4196.80,0.00,0.00,6.10,1104.10,'2022-03-29 18:28:38','',''),(2615129,'1','202','1036',477,'Retail Sale Id 1275',4196.80,0.00,0.00,6.10,1104.10,'2022-03-29 18:32:57','',''),(2615130,'1','202','1036',477,'Retail Sale Id 1276',2002.08,0.00,0.00,2.91,526.71,'2022-03-29 18:33:38','',''),(2615131,'1','202','1036',477,'Retail Sale Id 1277',15600.00,0.00,0.00,25.00,2925.00,'2022-03-29 18:42:51','',''),(2615132,'1','202','1036',477,'Retail Sale Id 1278',2002.08,0.00,0.00,2.91,526.71,'2022-03-29 19:09:56','',''),(2615133,'1','202','1036',477,'Retail Sale Id 1279',1499.84,0.00,0.00,2.18,394.58,'2022-03-29 19:19:39','',''),(2615134,'1','202','1036',477,'Retail Sale Id 1280',165360.00,0.00,0.00,265.00,31005.00,'2022-03-29 19:45:57','',''),(2615135,'1','202','1036',477,'Retail Sale Id 1281',54496.48,0.00,0.00,79.21,14337.01,'2022-03-29 19:47:58','',''),(2615136,'1','202','1036',477,'Retail Sale Id 1282',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 10:26:58','',''),(2615137,'1','202','1036',477,'Retail Sale Id 1283',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 10:30:51','',''),(2615138,'1','202','1036',477,'Retail Sale Id 1284',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 10:31:38','',''),(2615139,'1','202','1036',477,'Retail Sale Id 1285',16740.00,0.00,0.00,27.00,16740.00,'2022-03-30 10:36:57','',''),(2615140,'1','202','1036',477,'Retail Sale Id 1286',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 10:39:30','',''),(2615141,'1','202','1036',477,'Retail Sale Id 1287',55597.28,0.00,0.00,80.81,55597.28,'2022-03-30 10:40:34','',''),(2615142,'1','202','1036',477,'Retail Sale Id 1288',39917.76,0.00,0.00,58.02,39917.76,'2022-03-30 10:42:43','',''),(2615143,'1','202','1036',477,'Retail Sale Id 1289',34100.00,0.00,0.00,55.00,34100.00,'2022-03-30 10:44:07','',''),(2615144,'1','202','1036',477,'Retail Sale Id 1291',6996.96,0.00,0.00,10.17,6996.96,'2022-03-30 10:46:04','',''),(2615145,'1','202','1036',477,'Retail Sale Id 1292',3446.88,0.00,0.00,5.01,3446.88,'2022-03-30 10:50:59','',''),(2615146,'1','202','1036',477,'Retail Sale Id 1293',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 10:55:09','',''),(2615147,'1','202','1036',477,'Retail Sale Id 1294',1396.64,0.00,0.00,2.03,1396.64,'2022-03-30 10:56:37','',''),(2615148,'1','202','1036',477,'Retail Sale Id 1295',997.60,0.00,0.00,1.45,997.60,'2022-03-30 11:01:02','',''),(2615149,'1','202','1036',477,'Retail Sale Id 1296',27900.00,0.00,0.00,45.00,27900.00,'2022-03-30 11:03:59','',''),(2615150,'1','202','1036',477,'Retail Sale Id 1297',2999.68,0.00,0.00,4.36,2999.68,'2022-03-30 11:12:43','',''),(2615151,'1','202','1036',477,'Retail Sale Id 1298',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 11:13:33','',''),(2615152,'1','202','1036',477,'Retail Sale Id 1299',2999.68,0.00,0.00,4.36,2999.68,'2022-03-30 11:18:34','',''),(2615153,'1','202','1036',477,'Retail Sale Id 1300',2098.40,0.00,0.00,3.05,2098.40,'2022-03-30 11:35:01','',''),(2615154,'1','202','1036',477,'Retail Sale Id 1301',3446.88,0.00,0.00,5.01,3446.88,'2022-03-30 11:36:24','',''),(2615155,'1','202','1036',477,'Retail Sale Id 1302',3446.88,0.00,0.00,5.01,3446.88,'2022-03-30 11:44:39','',''),(2615156,'1','202','1036',477,'Retail Sale Id 1303',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 16:40:47','',''),(2615157,'1','202','1036',477,'Retail Sale Id 1304',21080.00,0.00,0.00,34.00,21080.00,'2022-03-30 16:45:16','',''),(2615158,'1','202','1036',477,'Retail Sale Id 1305',2002.08,0.00,0.00,2.91,2002.08,'2022-03-30 16:46:34','',''),(2615159,'1','202','1036',477,'Retail Sale Id 1306',2098.40,0.00,0.00,3.05,2098.40,'2022-03-30 16:54:55','',''),(2615160,'1','202','1036',477,'Retail Sale Id 1307',6900.64,0.00,0.00,10.03,6900.64,'2022-03-30 16:57:39','',''),(2615161,'1','202','1036',477,'Retail Sale Id 1308',3398.72,0.00,0.00,4.94,3398.72,'2022-03-30 16:59:10','',''),(2615162,'1','202','1036',477,'Retail Sale Id 1309',7547.36,0.00,0.00,10.97,7547.36,'2022-03-30 17:03:43','',''),(2615163,'1','202','1036',477,'Retail Sale Id 1310',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 17:07:57','',''),(2615164,'1','202','1036',477,'Retail Sale Id 1311',3997.28,0.00,0.00,5.81,3997.28,'2022-03-30 17:10:06','',''),(2615165,'1','202','1036',477,'Retail Sale Id 1312',10540.00,0.00,0.00,17.00,10540.00,'2022-03-30 17:19:44','',''),(2615166,'1','202','1036',477,'Retail Sale Id 1313',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 17:21:05','',''),(2615167,'1','202','1036',477,'Retail Sale Id 1315',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 17:22:44','',''),(2615168,'1','202','1036',477,'Retail Sale Id 1316',3446.88,0.00,0.00,5.01,3446.88,'2022-03-30 17:25:24','',''),(2615169,'1','202','1036',477,'Retail Sale Id 1317',3446.88,0.00,0.00,5.01,3446.88,'2022-03-30 17:27:50','',''),(2615170,'1','202','1036',477,'Retail Sale Id 1318',3997.28,0.00,0.00,5.81,3997.28,'2022-03-30 17:28:50','',''),(2615171,'1','202','1036',477,'Retail Sale Id 1319',2903.36,0.00,0.00,4.22,2903.36,'2022-03-30 17:32:02','',''),(2615172,'1','202','1036',477,'Retail Sale Id 1320',2999.68,0.00,0.00,4.36,2999.68,'2022-03-30 17:32:56','',''),(2615173,'1','202','1036',477,'Retail Sale Id 1321',3446.88,0.00,0.00,5.01,3446.88,'2022-03-30 17:44:17','',''),(2615174,'1','202','1036',477,'Retail Sale Id 1322',6900.64,0.00,0.00,10.03,6900.64,'2022-03-30 17:48:33','',''),(2615175,'1','202','1036',477,'Retail Sale Id 1323',8600.00,0.00,0.00,12.50,8600.00,'2022-03-30 17:51:09','',''),(2615176,'1','202','1036',477,'Retail Sale Id 1324',4196.80,0.00,0.00,6.10,4196.80,'2022-03-30 17:58:07','',''),(2615177,'1','202','1036',477,'Retail Sale Id 1325',2752.00,0.00,0.00,4.00,2752.00,'2022-03-30 17:59:15','',''),(2615178,'1','202','1036',477,'Retail Sale Id 1326',997.60,0.00,0.00,1.45,997.60,'2022-03-30 18:00:45','',''),(2615179,'1','202','1036',477,'Retail Sale Id 1327',2999.68,0.00,0.00,4.36,2999.68,'2022-03-30 18:01:54','',''),(2615180,'1','202','1036',477,'Retail Sale Id 1328',6996.96,0.00,0.00,10.17,6996.96,'2022-03-30 18:06:57','',''),(2615181,'1','202','1036',477,'Retail Sale Id 1329',2999.68,0.00,0.00,4.36,2999.68,'2022-03-30 18:07:41','',''),(2615182,'1','202','1036',477,'Retail Sale Id 1330',2002.08,0.00,0.00,2.91,2002.08,'2022-03-30 18:08:37','',''),(2615183,'1','202','1036',477,'Retail Sale Id 1331',1499.84,0.00,0.00,2.18,1499.84,'2022-03-30 18:10:29','',''),(2615184,'1','202','1036',477,'Retail Sale Id 1333',2002.08,0.00,0.00,2.91,2002.08,'2022-03-30 18:16:50','',''),(2615185,'1','202','1036',477,'Retail Sale Id 1334',2098.40,0.00,0.00,3.05,2098.40,'2022-03-30 18:20:18','',''),(2615186,'1','202','1036',477,'Retail Sale Id 1335',2098.40,0.00,0.00,3.05,2098.40,'2022-03-30 18:23:42','',''),(2615187,'1','202','1036',477,'Retail Sale Id 1336',502.24,0.00,0.00,0.73,502.24,'2022-03-30 18:36:13','',''),(2615188,'1','202','1036',477,'Retail Sale Id 1337',1396.64,0.00,0.00,2.03,1396.64,'2022-03-30 18:37:27','',''),(2615189,'1','202','1036',477,'Retail Sale Id 1338',2999.68,0.00,0.00,4.36,2999.68,'2022-03-30 18:38:20','',''),(2615190,'1','202','1036',477,'Retail Sale Id 1339',3501.92,0.00,0.00,5.09,3501.92,'2022-03-30 18:52:27','',''),(2615191,'1','202','1036',477,'Retail Sale Id 1340',2999.68,0.00,0.00,4.36,2999.68,'2022-03-30 18:53:35','',''),(2615192,'1','202','1036',477,'Retail Sale Id 1341',2002.08,0.00,0.00,2.91,2002.08,'2022-03-30 18:54:37','',''),(2615193,'1','202','1036',477,'Retail Sale Id 1342',2497.44,0.00,0.00,3.63,2497.44,'2022-03-30 18:55:36','',''),(2615194,'1','202','1036',477,'Return of Retail Sale Id 1291',0.00,6996.96,10.17,0.00,-6996.96,'2022-03-30 19:26:35','',''),(2615195,'1','202','1036',477,'Retail Sale Id 1343',302.72,0.00,0.00,0.44,302.72,'2022-03-30 19:29:21','',''),(2615196,'1','202','1036',477,'Retail Sale Id 1344',1998.64,0.00,0.00,3.01,472.57,'2022-03-31 07:06:32','',''),(2615197,'1','202','1036',477,'Retail Sale Id 1345',7350.48,0.00,0.00,11.07,1737.99,'2022-03-31 07:08:31','',''),(2615198,'1','202','1036',477,'Retail Sale Id 1346',3997.28,0.00,0.00,6.02,945.14,'2022-03-31 07:10:28','',''),(2615199,'1','202','1036',477,'Retail Sale Id 1347',1998.64,0.00,0.00,3.01,472.57,'2022-03-31 07:12:26','',''),(2615200,'1','202','1036',477,'Retail Sale Id 1348',796.80,0.00,0.00,1.20,188.40,'2022-03-31 07:13:23','',''),(2615201,'1','202','1036',477,'Retail Sale Id 1349',4096.88,0.00,0.00,6.17,968.69,'2022-03-31 07:15:16','',''),(2615202,'1','202','1036',477,'Retail Sale Id 1350',3598.88,0.00,0.00,5.42,850.94,'2022-03-31 07:16:01','',''),(2615203,'1','202','1036',477,'Retail Sale Id 1351',1998.64,0.00,0.00,3.01,472.57,'2022-03-31 07:28:32','',''),(2615204,'1','202','1036',477,'Retail Sale Id 1352',3997.28,0.00,0.00,6.02,945.14,'2022-03-31 07:41:24','',''),(2615205,'1','202','1036',477,'Retail Sale Id 1353',1998.64,0.00,0.00,3.01,472.57,'2022-03-31 10:23:25','',''),(2615206,'1','202','1036',477,'Retail Sale Id 1354',3353.20,0.00,0.00,5.05,792.85,'2022-03-31 10:25:20','',''),(2615207,'1','202','1036',477,'Retail Sale Id 1355',1500.64,0.00,0.00,2.26,354.82,'2022-03-31 10:28:55','',''),(2615208,'1','202','1036',477,'Retail Sale Id 1356',3200.48,0.00,0.00,4.82,756.74,'2022-03-31 10:39:50','',''),(2615209,'1','202','1036',477,'Retail Sale Id 1357',597.60,0.00,0.00,0.90,141.30,'2022-03-31 10:42:49','',''),(2615210,'1','202','1036',477,'Retail Sale Id 1358',1998.64,0.00,0.00,3.01,472.57,'2022-03-31 10:45:09','',''),(2615211,'1','202','1036',477,'Retail Sale Id 1359',2503.28,0.00,0.00,3.77,591.89,'2022-03-31 10:47:58','',''),(2615212,'1','202','1036',477,'Retail Sale Id 1360',3353.20,0.00,0.00,5.05,792.85,'2022-03-31 11:01:10','',''),(2615213,'1','202','1036',477,'Retail Sale Id 1361',67320.00,0.00,0.00,110.00,11550.00,'2022-03-31 11:18:49','',''),(2615214,'1','202','1036',477,'Retail Sale Id 1362',3353.20,0.00,0.00,5.05,792.85,'2022-03-31 11:20:01','',''),(2615215,'1','202','1036',477,'Retail Sale Id 1363',1998.64,0.00,0.00,3.01,472.57,'2022-03-31 11:43:37','',''),(2615216,'1','202','1036',477,'Retail Sale Id 1364',1500.64,0.00,0.00,2.26,354.82,'2022-03-31 11:53:54','',''),(2615217,'1','202','1036',477,'Retail Sale Id 1365',33660.00,0.00,0.00,55.00,5775.00,'2022-03-31 11:56:28','',''),(2615218,'1','202','1036',477,'Retail Sale Id 1366',2397.04,0.00,0.00,3.61,566.77,'2022-03-31 12:00:15','',''),(2615219,'1','202','1036',477,'Retail Sale Id 1367',3499.28,0.00,0.00,5.27,827.39,'2022-03-31 12:12:44','',''),(2615220,'1','202','1036',477,'Retail Sale Id 1368',1347.92,0.00,0.00,2.03,318.71,'2022-03-31 12:14:11','',''),(2615221,'1','202','1036',477,'Retail Sale Id 1369',7650.00,0.00,0.00,12.50,1312.50,'2022-03-31 12:20:17','',''),(2615222,'1','202','1036',477,'Retail Sale Id 1370',2503.28,0.00,0.00,3.77,591.89,'2022-03-31 12:32:48','',''),(2615223,'1','202','1036',477,'Retail Sale Id 1371',6002.56,0.00,0.00,9.04,1419.28,'2022-03-31 12:33:53','',''),(2615224,'1','202','1036',477,'Retail Sale Id 1372',1998.64,0.00,0.00,3.01,472.57,'2022-03-31 12:35:06','',''),(2615225,'1','202','1036',477,'Retail Sale Id 1373',1002.64,0.00,0.00,1.51,237.07,'2022-03-31 12:35:54','',''),(2615226,'1','202','1036',477,'Retail Sale Id 1374',3001.28,0.00,0.00,4.52,709.64,'2022-03-31 12:57:33','',''),(2615227,'1','202','1036',477,'Retail Sale Id 1375',3001.28,0.00,0.00,4.52,709.64,'2022-03-31 12:58:40','',''),(2615228,'1','202','1036',477,'Retail Sale Id 1376',53159.84,0.00,0.00,80.06,12569.42,'2022-03-31 18:03:59','',''),(2615229,'1','202','1036',477,'Retail Sale Id 1377',83948.04,0.00,0.00,137.17,14402.85,'2022-03-31 18:06:30','',''),(2615230,'1','202','1036',477,'Retail Sale Id 1378',9960.00,0.00,0.00,15.00,2355.00,'2022-04-01 07:53:50','',''),(2615231,'1','202','1036',477,'Retail Sale Id 1379',63342.00,0.00,0.00,103.50,10867.50,'2022-04-01 07:55:38','',''),(2615232,'1','202','1036',477,'Retail Sale Id 1380',30600.00,0.00,0.00,50.00,5250.00,'2022-04-01 07:58:29','',''),(2615233,'1','202','1036',477,'Retail Sale Id 1381',23492.32,0.00,0.00,35.38,5554.66,'2022-04-01 07:59:50','',''),(2615234,'1','202','1036',477,'Retail Sale Id 1382',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 08:05:15','',''),(2615235,'1','202','1036',477,'Retail Sale Id 1383',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 08:07:25','',''),(2615236,'1','202','1036',477,'Retail Sale Id 1385',2702.48,0.00,0.00,4.07,638.99,'2022-04-01 08:09:58','',''),(2615237,'1','202','1036',477,'Retail Sale Id 1386',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 11:37:29','',''),(2615238,'1','202','1036',477,'Retail Sale Id 1387',3353.20,0.00,0.00,5.05,792.85,'2022-04-01 11:39:47','',''),(2615239,'1','202','1036',477,'Retail Sale Id 1388',8300.00,0.00,0.00,12.50,1962.50,'2022-04-01 11:43:19','',''),(2615240,'1','202','1036',477,'Retail Sale Id 1389',13280.00,0.00,0.00,20.00,3140.00,'2022-04-01 11:51:35','',''),(2615241,'1','202','1036',477,'Retail Sale Id 1390',8300.00,0.00,0.00,12.50,1962.50,'2022-04-01 12:01:02','',''),(2615242,'1','202','1036',477,'Retail Sale Id 1391',1347.92,0.00,0.00,2.03,318.71,'2022-04-01 12:03:54','',''),(2615243,'1','202','1036',477,'Retail Sale Id 1392',8300.00,0.00,0.00,12.50,1962.50,'2022-04-01 12:06:09','',''),(2615244,'1','202','1036',477,'Retail Sale Id 1393',3353.20,0.00,0.00,5.05,792.85,'2022-04-01 12:23:16','',''),(2615245,'1','202','1036',477,'Retail Sale Id 1394',1002.64,0.00,0.00,1.51,237.07,'2022-04-01 12:29:52','',''),(2615246,'1','202','1036',477,'Retail Sale Id 1395',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 12:35:45','',''),(2615247,'1','202','1036',477,'Retail Sale Id 1396',277646.04,0.00,0.00,453.67,47635.35,'2022-04-01 12:44:35','',''),(2615248,'1','202','1036',477,'Retail Sale Id 1397',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 12:47:25','',''),(2615249,'1','202','1036',477,'Retail Sale Id 1398',51951.36,0.00,0.00,78.24,12283.68,'2022-04-01 12:48:21','',''),(2615250,'1','202','1036',477,'Retail Sale Id 1399',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 12:51:39','',''),(2615251,'1','202','1036',477,'Retail Sale Id 1400',49003.20,0.00,0.00,73.80,11586.60,'2022-04-01 12:52:39','',''),(2615252,'1','202','1036',477,'Retail Sale Id 1401',69720.00,0.00,0.00,105.00,16485.00,'2022-04-01 12:56:27','',''),(2615253,'1','202','1036',477,'Retail Sale Id 1402',36720.00,0.00,0.00,60.00,6300.00,'2022-04-01 13:04:29','',''),(2615254,'1','202','1036',477,'Retail Sale Id 1403',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 13:05:45','',''),(2615255,'1','202','1036',477,'Retail Sale Id 1404',498.00,0.00,0.00,0.75,117.75,'2022-04-01 13:09:52','',''),(2615256,'1','202','1036',477,'Retail Sale Id 1405',30600.00,0.00,0.00,50.00,5250.00,'2022-04-01 13:15:04','',''),(2615257,'1','202','1036',477,'Retail Sale Id 1406',8300.00,0.00,0.00,12.50,1962.50,'2022-04-01 13:16:11','',''),(2615258,'1','202','1036',477,'Retail Sale Id 1407',8300.00,0.00,0.00,12.50,1962.50,'2022-04-01 13:19:09','',''),(2615259,'1','202','1036',477,'Retail Sale Id 1408',3950.80,0.00,0.00,5.95,934.15,'2022-04-01 13:27:33','',''),(2615260,'1','202','1036',477,'Retail Sale Id 1409',1500.64,0.00,0.00,2.26,354.82,'2022-04-01 13:53:18','',''),(2615261,'1','202','1036',477,'Retail Sale Id 1410',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 13:54:26','',''),(2615262,'1','202','1036',477,'Retail Sale Id 1411',14688.00,0.00,0.00,24.00,2520.00,'2022-04-01 14:08:00','',''),(2615263,'1','202','1036',477,'Retail Sale Id 1412',8300.00,0.00,0.00,12.50,1962.50,'2022-04-01 14:08:48','',''),(2615264,'1','202','1036',477,'Retail Sale Id 1413',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 14:14:42','',''),(2615265,'1','202','1036',477,'Retail Sale Id 1414',2503.28,0.00,0.00,3.77,591.89,'2022-04-01 14:22:58','',''),(2615266,'1','202','1036',477,'Retail Sale Id 1415',903.04,0.00,0.00,1.36,213.52,'2022-04-01 14:25:19','',''),(2615267,'1','202','1036',477,'Retail Sale Id 1416',1301.44,0.00,0.00,1.96,307.72,'2022-04-01 14:27:12','',''),(2615268,'1','202','1036',477,'Retail Sale Id 1417',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 14:37:20','',''),(2615269,'1','202','1036',477,'Retail Sale Id 1418',1347.92,0.00,0.00,2.03,318.71,'2022-04-01 14:40:44','',''),(2615270,'1','202','1036',477,'Retail Sale Id 1419',2702.48,0.00,0.00,4.07,638.99,'2022-04-01 15:07:26','',''),(2615271,'1','202','1036',477,'Retail Sale Id 1420',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 15:15:33','',''),(2615272,'1','202','1036',477,'Retail Sale Id 1421',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 15:22:39','',''),(2615273,'1','202','1036',477,'Retail Sale Id 1423',498.00,0.00,0.00,0.75,117.75,'2022-04-01 15:36:43','',''),(2615274,'1','202','1036',477,'Retail Sale Id 1424',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 15:40:07','',''),(2615275,'1','202','1036',477,'Retail Sale Id 1425',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 15:44:01','',''),(2615276,'1','202','1036',477,'Retail Sale Id 1426',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 15:51:44','',''),(2615277,'1','202','1036',477,'Retail Sale Id 1427',597.60,0.00,0.00,0.90,141.30,'2022-04-01 15:53:53','',''),(2615278,'1','202','1036',477,'Retail Sale Id 1428',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 16:03:13','',''),(2615279,'1','202','1036',477,'Retail Sale Id 1429',1500.64,0.00,0.00,2.26,354.82,'2022-04-01 16:04:11','',''),(2615280,'1','202','1036',477,'Retail Sale Id 1430',8300.00,0.00,0.00,12.50,1962.50,'2022-04-01 16:08:02','',''),(2615281,'1','202','1036',477,'Retail Sale Id 1431',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 16:14:04','',''),(2615282,'1','202','1036',477,'Retail Sale Id 1432',3353.20,0.00,0.00,5.05,792.85,'2022-04-01 16:17:49','',''),(2615283,'1','202','1036',477,'Retail Sale Id 1433',1401.04,0.00,0.00,2.11,331.27,'2022-04-01 16:22:25','',''),(2615284,'1','202','1036',477,'Retail Sale Id 1434',1401.04,0.00,0.00,2.11,331.27,'2022-04-01 16:23:24','',''),(2615285,'1','202','1036',477,'Retail Sale Id 1435',1002.64,0.00,0.00,1.51,237.07,'2022-04-01 16:24:21','',''),(2615286,'1','202','1036',477,'Retail Sale Id 1436',3353.20,0.00,0.00,5.05,792.85,'2022-04-01 16:25:32','',''),(2615287,'1','202','1036',477,'Retail Sale Id 1437',1002.64,0.00,0.00,1.51,237.07,'2022-04-01 16:26:39','',''),(2615288,'1','202','1036',477,'Retail Sale Id 1438',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 16:35:39','',''),(2615289,'1','202','1036',477,'Retail Sale Id 1439',33200.00,0.00,0.00,50.00,7850.00,'2022-04-01 16:47:15','',''),(2615290,'1','202','1036',477,'Retail Sale Id 1440',8300.00,0.00,0.00,12.50,1962.50,'2022-04-01 16:48:50','',''),(2615291,'1','202','1036',477,'Retail Sale Id 1441',1002.64,0.00,0.00,1.51,237.07,'2022-04-01 16:54:50','',''),(2615292,'1','202','1036',477,'Retail Sale Id 1442',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 17:08:59','',''),(2615293,'1','202','1036',477,'Retail Sale Id 1443',3001.28,0.00,0.00,4.52,709.64,'2022-04-01 17:10:06','',''),(2615294,'1','202','1036',477,'Retail Sale Id 1444',2802.08,0.00,0.00,4.22,662.54,'2022-04-01 17:12:55','',''),(2615295,'1','202','1036',477,'Retail Sale Id 1445',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 17:14:17','',''),(2615296,'1','202','1036',477,'Retail Sale Id 1446',2702.48,0.00,0.00,4.07,638.99,'2022-04-01 17:16:32','',''),(2615297,'1','202','1036',477,'Retail Sale Id 1447',6640.00,0.00,0.00,10.00,1570.00,'2022-04-01 17:22:12','',''),(2615298,'1','202','1036',477,'Retail Sale Id 1449',2702.48,0.00,0.00,4.07,638.99,'2022-04-01 17:24:58','',''),(2615299,'1','202','1036',477,'Retail Sale Id 1450',1201.84,0.00,0.00,1.81,284.17,'2022-04-01 17:26:27','',''),(2615300,'1','202','1036',477,'Retail Sale Id 1451',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 17:27:25','',''),(2615301,'1','202','1036',477,'Retail Sale Id 1452',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 17:28:25','',''),(2615302,'1','202','1036',477,'Retail Sale Id 1453',33660.00,0.00,0.00,55.00,5775.00,'2022-04-01 17:33:28','',''),(2615303,'1','202','1036',477,'Retail Sale Id 1454',30600.00,0.00,0.00,50.00,5250.00,'2022-04-01 17:36:49','',''),(2615304,'1','202','1036',477,'Retail Sale Id 1455',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 17:37:54','',''),(2615305,'1','202','1036',477,'Retail Sale Id 1456',10624.00,0.00,0.00,16.00,2512.00,'2022-04-01 17:39:45','',''),(2615306,'1','202','1036',477,'Retail Sale Id 1457',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 17:42:19','',''),(2615307,'1','202','1036',477,'Retail Sale Id 1458',1002.64,0.00,0.00,1.51,237.07,'2022-04-01 17:44:57','',''),(2615308,'1','202','1036',477,'Retail Sale Id 1459',4999.92,0.00,0.00,7.53,1182.21,'2022-04-01 17:50:40','',''),(2615309,'1','202','1036',477,'Retail Sale Id 1460',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 17:56:07','',''),(2615310,'1','202','1036',477,'Retail Sale Id 1461',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 17:58:00','',''),(2615311,'1','202','1036',477,'Retail Sale Id 1462',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 17:59:19','',''),(2615312,'1','202','1036',477,'Retail Sale Id 1463',42840.00,0.00,0.00,70.00,7350.00,'2022-04-01 18:00:52','',''),(2615313,'1','202','1036',477,'Retail Sale Id 1464',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 18:04:58','',''),(2615314,'1','202','1036',477,'Retail Sale Id 1465',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 18:05:52','',''),(2615315,'1','202','1036',477,'Retail Sale Id 1466',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 18:06:47','',''),(2615316,'1','202','1036',477,'Retail Sale Id 1467',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 18:10:28','',''),(2615317,'1','202','1036',477,'Retail Sale Id 1468',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 18:11:37','',''),(2615318,'1','202','1036',477,'Retail Sale Id 1469',3353.20,0.00,0.00,5.05,792.85,'2022-04-01 18:12:50','',''),(2615319,'1','202','1036',477,'Retail Sale Id 1470',2702.48,0.00,0.00,4.07,638.99,'2022-04-01 18:14:41','',''),(2615320,'1','202','1036',477,'Retail Sale Id 1471',1002.64,0.00,0.00,1.51,237.07,'2022-04-01 18:15:25','',''),(2615321,'1','202','1036',477,'Retail Sale Id 1472',3001.28,0.00,0.00,4.52,709.64,'2022-04-01 18:16:08','',''),(2615322,'1','202','1036',477,'Retail Sale Id 1473',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 18:17:22','',''),(2615323,'1','202','1036',477,'Retail Sale Id 1474',3997.28,0.00,0.00,6.02,945.14,'2022-04-01 18:18:00','',''),(2615324,'1','202','1036',477,'Retail Sale Id 1475',2702.48,0.00,0.00,4.07,638.99,'2022-04-01 18:21:05','',''),(2615325,'1','202','1036',477,'Retail Sale Id 1476',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 18:26:31','',''),(2615326,'1','202','1036',477,'Retail Sale Id 1477',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 18:31:48','',''),(2615327,'1','202','1036',477,'Retail Sale Id 1478',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 18:41:50','',''),(2615328,'1','202','1036',477,'Retail Sale Id 1479',8300.00,0.00,0.00,12.50,1962.50,'2022-04-01 18:53:38','',''),(2615329,'1','202','1036',477,'Retail Sale Id 1480',1998.64,0.00,0.00,3.01,472.57,'2022-04-01 19:15:29','',''),(2615330,'1','202','1036',477,'Retail Sale Id 1481',6699.76,0.00,0.00,10.09,1584.13,'2022-04-01 19:18:55','',''),(2615331,'1','202','1036',477,'Retail Sale Id 1482',4488.64,0.00,0.00,6.76,1061.32,'2022-04-01 19:48:05','',''),(2615332,'1','202','1036',477,'Retail Sale Id 1483',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 06:59:25','',''),(2615333,'1','202','1036',477,'Retail Sale Id 1484',73440.00,0.00,0.00,120.00,12600.00,'2022-04-02 07:10:42','',''),(2615334,'1','202','1036',477,'Retail Sale Id 1485',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 07:18:55','',''),(2615335,'1','202','1036',477,'Retail Sale Id 1486',2702.48,0.00,0.00,4.07,638.99,'2022-04-02 07:24:14','',''),(2615336,'1','202','1036',477,'Retail Sale Id 1487',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 07:27:44','',''),(2615337,'1','202','1036',477,'Retail Sale Id 1488',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 07:40:30','',''),(2615338,'1','202','1036',477,'Retail Sale Id 1489',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 07:46:31','',''),(2615339,'1','202','1036',477,'Retail Sale Id 1490',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 07:49:36','',''),(2615340,'1','202','1036',477,'Retail Sale Id 1491',1899.04,0.00,0.00,2.86,449.02,'2022-04-02 07:51:02','',''),(2615341,'1','202','1036',477,'Retail Sale Id 1492',66708.00,0.00,0.00,109.00,11445.00,'2022-04-02 07:54:35','',''),(2615342,'1','202','1036',477,'Retail Sale Id 1493',30600.00,0.00,0.00,50.00,5250.00,'2022-04-02 08:04:56','',''),(2615343,'1','202','1036',477,'Retail Sale Id 1494',7650.00,0.00,0.00,12.50,1312.50,'2022-04-02 08:06:47','',''),(2615344,'1','202','1036',477,'Retail Sale Id 1495',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 08:12:38','',''),(2615345,'1','202','1036',477,'Retail Sale Id 1496',796.80,0.00,0.00,1.20,188.40,'2022-04-02 08:15:00','',''),(2615346,'1','202','1036',477,'Retail Sale Id 1497',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 08:16:27','',''),(2615347,'1','202','1036',477,'Retail Sale Id 1498',6002.56,0.00,0.00,9.04,1419.28,'2022-04-02 08:17:43','',''),(2615348,'1','202','1036',477,'Retail Sale Id 1499',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 08:21:21','',''),(2615349,'1','202','1036',477,'Retail Sale Id 1500',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 08:26:21','',''),(2615350,'1','202','1036',477,'Retail Sale Id 1501',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 08:27:19','',''),(2615351,'1','202','1036',477,'Retail Sale Id 1502',8997.20,0.00,0.00,13.55,2127.35,'2022-04-02 08:29:48','',''),(2615352,'1','202','1036',477,'Retail Sale Id 1503',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 08:30:49','',''),(2615353,'1','202','1036',477,'Retail Sale Id 1504',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 08:34:23','',''),(2615354,'1','202','1036',477,'Retail Sale Id 1505',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 08:47:28','',''),(2615355,'1','202','1036',477,'Retail Sale Id 1506',2702.48,0.00,0.00,4.07,638.99,'2022-04-02 08:54:02','',''),(2615356,'1','202','1036',477,'Retail Sale Id 1507',4701.12,0.00,0.00,7.08,1111.56,'2022-04-02 09:01:32','',''),(2615357,'1','202','1036',477,'Retail Sale Id 1508',16524.00,0.00,0.00,27.00,2835.00,'2022-04-02 09:04:16','',''),(2615358,'1','202','1036',477,'Retail Sale Id 1509',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 09:07:15','',''),(2615359,'1','202','1036',477,'Retail Sale Id 1510',1401.04,0.00,0.00,2.11,331.27,'2022-04-02 09:09:01','',''),(2615360,'1','202','1036',477,'Retail Sale Id 1511',12240.00,0.00,0.00,20.00,2100.00,'2022-04-02 09:11:36','',''),(2615361,'1','202','1036',477,'Retail Sale Id 1512',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 09:13:28','',''),(2615362,'1','202','1036',477,'Retail Sale Id 1513',2802.08,0.00,0.00,4.22,662.54,'2022-04-02 09:14:36','',''),(2615363,'1','202','1036',477,'Retail Sale Id 1514',3353.20,0.00,0.00,5.05,792.85,'2022-04-02 09:20:15','',''),(2615364,'1','202','1036',477,'Retail Sale Id 1515',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 09:21:41','',''),(2615365,'1','202','1036',477,'Retail Sale Id 1516',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 09:23:48','',''),(2615366,'1','202','1036',477,'Retail Sale Id 1517',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 09:30:12','',''),(2615367,'1','202','1036',477,'Retail Sale Id 1518',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 09:31:50','',''),(2615368,'1','202','1036',477,'Retail Sale Id 1519',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 09:32:44','',''),(2615369,'1','202','1036',477,'Retail Sale Id 1520',7396.96,0.00,0.00,11.14,1748.98,'2022-04-02 09:38:43','',''),(2615370,'1','202','1036',477,'Retail Sale Id 1521',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 09:42:54','',''),(2615371,'1','202','1036',477,'Retail Sale Id 1522',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 09:43:54','',''),(2615372,'1','202','1036',477,'Retail Sale Id 1524',1500.64,0.00,0.00,2.26,354.82,'2022-04-02 09:44:41','',''),(2615373,'1','202','1036',477,'Retail Sale Id 1525',3320.00,0.00,0.00,5.00,785.00,'2022-04-02 09:49:04','',''),(2615374,'1','202','1036',477,'Retail Sale Id 1526',3984.00,0.00,0.00,6.00,942.00,'2022-04-02 09:50:43','',''),(2615375,'1','202','1036',477,'Retail Sale Id 1527',162180.00,0.00,0.00,265.00,27825.00,'2022-04-02 09:54:33','',''),(2615376,'1','202','1036',477,'Retail Sale Id 1528',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 09:56:00','',''),(2615377,'1','202','1036',477,'Retail Sale Id 1529',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 09:57:27','',''),(2615378,'1','202','1036',477,'Retail Sale Id 1530',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 10:02:50','',''),(2615379,'1','202','1036',477,'Retail Sale Id 1531',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 10:03:35','',''),(2615380,'1','202','1036',477,'Retail Sale Id 1532',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 10:05:31','',''),(2615381,'1','202','1036',477,'Retail Sale Id 1533',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 10:06:36','',''),(2615382,'1','202','1036',477,'Retail Sale Id 1534',1500.64,0.00,0.00,2.26,354.82,'2022-04-02 10:08:18','',''),(2615383,'1','202','1036',477,'Retail Sale Id 1535',3353.20,0.00,0.00,5.05,792.85,'2022-04-02 10:12:07','',''),(2615384,'1','202','1036',477,'Retail Sale Id 1536',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 10:14:26','',''),(2615385,'1','202','1036',477,'Retail Sale Id 1537',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 10:17:07','',''),(2615386,'1','202','1036',477,'Retail Sale Id 1538',102816.00,0.00,0.00,168.00,17640.00,'2022-04-02 10:20:20','',''),(2615387,'1','202','1036',477,'Retail Sale Id 1539',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 10:21:20','',''),(2615388,'1','202','1036',477,'Retail Sale Id 1540',903.04,0.00,0.00,1.36,213.52,'2022-04-02 10:26:01','',''),(2615389,'1','202','1036',477,'Retail Sale Id 1541',1500.64,0.00,0.00,2.26,354.82,'2022-04-02 10:26:56','',''),(2615390,'1','202','1036',477,'Retail Sale Id 1542',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 10:27:57','',''),(2615391,'1','202','1036',477,'Retail Sale Id 1543',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 10:29:20','',''),(2615392,'1','202','1036',477,'Retail Sale Id 1544',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 10:30:19','',''),(2615393,'1','202','1036',477,'Retail Sale Id 1545',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 10:31:13','',''),(2615394,'1','202','1036',477,'Retail Sale Id 1546',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 10:32:08','',''),(2615395,'1','202','1036',477,'Retail Sale Id 1547',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 10:33:14','',''),(2615396,'1','202','1036',477,'Retail Sale Id 1548',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 10:33:56','',''),(2615397,'1','202','1036',477,'Retail Sale Id 1549',4402.32,0.00,0.00,6.63,1040.91,'2022-04-02 10:35:06','',''),(2615398,'1','202','1036',477,'Retail Sale Id 1550',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 10:36:00','',''),(2615399,'1','202','1036',477,'Retail Sale Id 1551',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 10:36:48','',''),(2615400,'1','202','1036',477,'Retail Sale Id 1552',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 10:37:31','',''),(2615401,'1','202','1036',477,'Retail Sale Id 1553',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 10:42:57','',''),(2615402,'1','202','1036',477,'Retail Sale Id 1554',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 10:48:07','',''),(2615403,'1','202','1036',477,'Retail Sale Id 1555',8001.20,0.00,0.00,12.05,1891.85,'2022-04-02 10:49:24','',''),(2615404,'1','202','1036',477,'Retail Sale Id 1556',1899.04,0.00,0.00,2.86,449.02,'2022-04-02 10:52:04','',''),(2615405,'1','202','1036',477,'Retail Sale Id 1557',1600.24,0.00,0.00,2.41,378.37,'2022-04-02 10:54:05','',''),(2615406,'1','202','1036',477,'Retail Sale Id 1558',1600.24,0.00,0.00,2.41,378.37,'2022-04-02 10:55:00','',''),(2615407,'1','202','1036',477,'Retail Sale Id 1559',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 10:55:51','',''),(2615408,'1','202','1036',477,'Retail Sale Id 1560',33660.00,0.00,0.00,55.00,5775.00,'2022-04-02 10:57:24','',''),(2615409,'1','202','1036',477,'Retail Sale Id 1561',1660.00,0.00,0.00,2.50,392.50,'2022-04-02 11:00:17','',''),(2615410,'1','202','1036',477,'Retail Sale Id 1562',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 11:02:28','',''),(2615411,'1','202','1036',477,'Retail Sale Id 1563',39780.00,0.00,0.00,65.00,6825.00,'2022-04-02 11:07:19','',''),(2615412,'1','202','1036',477,'Retail Sale Id 1564',1500.64,0.00,0.00,2.26,354.82,'2022-04-02 11:08:31','',''),(2615413,'1','202','1036',477,'Retail Sale Id 1565',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 11:11:49','',''),(2615414,'1','202','1036',477,'Retail Sale Id 1566',6998.56,0.00,0.00,10.54,1654.78,'2022-04-02 11:13:40','',''),(2615415,'1','202','1036',477,'Retail Sale Id 1567',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 11:17:58','',''),(2615416,'1','202','1036',477,'Retail Sale Id 1568',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 11:18:56','',''),(2615417,'1','202','1036',477,'Retail Sale Id 1569',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 11:23:01','',''),(2615418,'1','202','1036',477,'Retail Sale Id 1570',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 11:26:49','',''),(2615419,'1','202','1036',477,'Retail Sale Id 1571',1201.84,0.00,0.00,1.81,284.17,'2022-04-02 11:27:37','',''),(2615420,'1','202','1036',477,'Retail Sale Id 1572',7350.48,0.00,0.00,11.07,1737.99,'2022-04-02 11:36:53','',''),(2615421,'1','202','1036',477,'Retail Sale Id 1573',1500.64,0.00,0.00,2.26,354.82,'2022-04-02 11:37:55','',''),(2615422,'1','202','1036',477,'Retail Sale Id 1574',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 11:39:44','',''),(2615423,'1','202','1036',477,'Retail Sale Id 1575',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 11:43:30','',''),(2615424,'1','202','1036',477,'Retail Sale Id 1577',1401.04,0.00,0.00,2.11,331.27,'2022-04-02 11:45:02','',''),(2615425,'1','202','1036',477,'Retail Sale Id 1578',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 11:47:02','',''),(2615426,'1','202','1036',477,'Retail Sale Id 1579',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 11:48:45','',''),(2615427,'1','202','1036',477,'Retail Sale Id 1580',8001.20,0.00,0.00,12.05,1891.85,'2022-04-02 11:50:02','',''),(2615428,'1','202','1036',477,'Retail Sale Id 1581',796.80,0.00,0.00,1.20,188.40,'2022-04-02 11:54:00','',''),(2615429,'1','202','1036',477,'Retail Sale Id 1582',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 11:55:01','',''),(2615430,'1','202','1036',477,'Retail Sale Id 1583',3353.20,0.00,0.00,5.05,792.85,'2022-04-02 11:56:30','',''),(2615431,'1','202','1036',477,'Retail Sale Id 1584',1401.04,0.00,0.00,2.11,331.27,'2022-04-02 11:58:01','',''),(2615432,'1','202','1036',477,'Retail Sale Id 1585',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 11:59:25','',''),(2615433,'1','202','1036',477,'Retail Sale Id 1586',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 12:00:04','',''),(2615434,'1','202','1036',477,'Retail Sale Id 1587',3353.20,0.00,0.00,5.05,792.85,'2022-04-02 12:02:23','',''),(2615435,'1','202','1036',477,'Retail Sale Id 1588',1500.64,0.00,0.00,2.26,354.82,'2022-04-02 12:06:25','',''),(2615436,'1','202','1036',477,'Retail Sale Id 1589',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 12:07:44','',''),(2615437,'1','202','1036',477,'Retail Sale Id 1590',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 12:09:03','',''),(2615438,'1','202','1036',477,'Retail Sale Id 1591',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 12:14:34','',''),(2615439,'1','202','1036',477,'Retail Sale Id 1592',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 12:16:25','',''),(2615440,'1','202','1036',477,'Retail Sale Id 1593',30600.00,0.00,0.00,50.00,5250.00,'2022-04-02 12:17:40','',''),(2615441,'1','202','1036',477,'Retail Sale Id 1594',36108.00,0.00,0.00,59.00,6195.00,'2022-04-02 12:24:35','',''),(2615442,'1','202','1036',477,'Retail Sale Id 1595',1401.04,0.00,0.00,2.11,331.27,'2022-04-02 12:27:08','',''),(2615443,'1','202','1036',477,'Retail Sale Id 1596',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 12:28:44','',''),(2615444,'1','202','1036',477,'Retail Sale Id 1597',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 12:29:26','',''),(2615445,'1','202','1036',477,'Retail Sale Id 1598',10404.00,0.00,0.00,17.00,1785.00,'2022-04-02 12:36:53','',''),(2615446,'1','202','1036',477,'Retail Sale Id 1599',4999.92,0.00,0.00,7.53,1182.21,'2022-04-02 12:45:23','',''),(2615447,'1','202','1036',477,'Retail Sale Id 1600',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 12:46:05','',''),(2615448,'1','202','1036',477,'Retail Sale Id 1601',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 12:54:00','',''),(2615449,'1','202','1036',477,'Retail Sale Id 1602',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 13:00:37','',''),(2615450,'1','202','1036',477,'Retail Sale Id 1603',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 13:03:43','',''),(2615451,'1','202','1036',477,'Retail Sale Id 1604',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 13:05:09','',''),(2615452,'1','202','1036',477,'Retail Sale Id 1605',4150.00,0.00,0.00,6.25,981.25,'2022-04-02 13:19:29','',''),(2615453,'1','202','1036',477,'Retail Sale Id 1606',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 13:20:35','',''),(2615454,'1','202','1036',477,'Retail Sale Id 1607',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 13:22:07','',''),(2615455,'1','202','1036',477,'Retail Sale Id 1608',4501.92,0.00,0.00,6.78,1064.46,'2022-04-02 13:23:22','',''),(2615456,'1','202','1036',477,'Retail Sale Id 1611',1401.04,0.00,0.00,2.11,331.27,'2022-04-02 13:37:05','',''),(2615457,'1','202','1036',477,'Retail Sale Id 1613',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 13:39:32','',''),(2615458,'1','202','1036',477,'Retail Sale Id 1614',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 13:47:45','',''),(2615459,'1','202','1036',477,'Retail Sale Id 1615',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 13:49:24','',''),(2615460,'1','202','1036',477,'Retail Sale Id 1616',2702.48,0.00,0.00,4.07,638.99,'2022-04-02 13:50:58','',''),(2615461,'1','202','1036',477,'Retail Sale Id 1617',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 13:52:42','',''),(2615462,'1','202','1036',477,'Retail Sale Id 1618',3353.20,0.00,0.00,5.05,792.85,'2022-04-02 13:55:17','',''),(2615463,'1','202','1036',477,'Retail Sale Id 1619',3353.20,0.00,0.00,5.05,792.85,'2022-04-02 13:56:59','',''),(2615464,'1','202','1036',477,'Retail Sale Id 1620',2702.48,0.00,0.00,4.07,638.99,'2022-04-02 14:06:32','',''),(2615465,'1','202','1036',477,'Retail Sale Id 1621',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 14:07:25','',''),(2615466,'1','202','1036',477,'Retail Sale Id 1622',14688.00,0.00,0.00,24.00,2520.00,'2022-04-02 14:22:12','',''),(2615467,'1','202','1036',477,'Retail Sale Id 1623',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 14:24:23','',''),(2615468,'1','202','1036',477,'Retail Sale Id 1624',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 14:26:23','',''),(2615469,'1','202','1036',477,'Retail Sale Id 1625',2503.28,0.00,0.00,3.77,591.89,'2022-04-02 14:27:47','',''),(2615470,'1','202','1036',477,'Retail Sale Id 1626',8001.20,0.00,0.00,12.05,1891.85,'2022-04-02 14:34:29','',''),(2615471,'1','202','1036',477,'Retail Sale Id 1628',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 14:36:03','',''),(2615472,'1','202','1036',477,'Retail Sale Id 1629',1699.84,0.00,0.00,2.56,401.92,'2022-04-02 14:37:12','',''),(2615473,'1','202','1036',477,'Retail Sale Id 1630',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 14:38:15','',''),(2615474,'1','202','1036',477,'Retail Sale Id 1631',90576.00,0.00,0.00,148.00,15540.00,'2022-04-02 14:44:40','',''),(2615475,'1','202','1036',477,'Retail Sale Id 1632',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 14:48:32','',''),(2615476,'1','202','1036',477,'Retail Sale Id 1633',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 14:52:13','',''),(2615477,'1','202','1036',477,'Retail Sale Id 1634',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 15:02:18','',''),(2615478,'1','202','1036',477,'Retail Sale Id 1635',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 15:03:22','',''),(2615479,'1','202','1036',477,'Retail Sale Id 1637',4999.92,0.00,0.00,7.53,1182.21,'2022-04-02 15:11:50','',''),(2615480,'1','202','1036',477,'Retail Sale Id 1638',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 15:13:19','',''),(2615481,'1','202','1036',477,'Retail Sale Id 1639',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 15:20:12','',''),(2615482,'1','202','1036',477,'Retail Sale Id 1640',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 15:33:08','',''),(2615483,'1','202','1036',477,'Retail Sale Id 1641',50796.00,0.00,0.00,83.00,8715.00,'2022-04-02 15:37:18','',''),(2615484,'1','202','1036',477,'Retail Sale Id 1642',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 15:39:09','',''),(2615485,'1','202','1036',477,'Retail Sale Id 1643',46206.00,0.00,0.00,75.50,7927.50,'2022-04-02 15:43:12','',''),(2615486,'1','202','1036',477,'Retail Sale Id 1645',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 15:50:23','',''),(2615487,'1','202','1036',477,'Retail Sale Id 1646',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 15:51:26','',''),(2615488,'1','202','1036',477,'Retail Sale Id 1647',3499.28,0.00,0.00,5.27,827.39,'2022-04-02 15:55:16','',''),(2615489,'1','202','1036',477,'Retail Sale Id 1648',3353.20,0.00,0.00,5.05,792.85,'2022-04-02 15:56:45','',''),(2615490,'1','202','1036',477,'Retail Sale Id 1649',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 15:58:01','',''),(2615491,'1','202','1036',477,'Retail Sale Id 1650',2702.48,0.00,0.00,4.07,638.99,'2022-04-02 16:01:13','',''),(2615492,'1','202','1036',477,'Retail Sale Id 1651',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 16:04:06','',''),(2615493,'1','202','1036',477,'Retail Sale Id 1652',36720.00,0.00,0.00,60.00,6300.00,'2022-04-02 16:07:20','',''),(2615494,'1','202','1036',477,'Retail Sale Id 1653',1301.44,0.00,0.00,1.96,307.72,'2022-04-02 16:12:58','',''),(2615495,'1','202','1036',477,'Retail Sale Id 1654',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 16:16:53','',''),(2615496,'1','202','1036',477,'Retail Sale Id 1655',30600.00,0.00,0.00,50.00,5250.00,'2022-04-02 16:20:17','',''),(2615497,'1','202','1036',477,'Retail Sale Id 1656',1500.64,0.00,0.00,2.26,354.82,'2022-04-02 16:21:55','',''),(2615498,'1','202','1036',477,'Retail Sale Id 1657',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 16:25:45','',''),(2615499,'1','202','1036',477,'Retail Sale Id 1658',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 16:28:07','',''),(2615500,'1','202','1036',477,'Retail Sale Id 1659',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 16:29:01','',''),(2615501,'1','202','1036',477,'Retail Sale Id 1660',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 16:29:48','',''),(2615502,'1','202','1036',477,'Retail Sale Id 1661',36720.00,0.00,0.00,60.00,6300.00,'2022-04-02 16:32:29','',''),(2615503,'1','202','1036',477,'Retail Sale Id 1662',1301.44,0.00,0.00,1.96,307.72,'2022-04-02 16:33:16','',''),(2615504,'1','202','1036',477,'Retail Sale Id 1664',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 16:46:08','',''),(2615505,'1','202','1036',477,'Retail Sale Id 1665',7503.20,0.00,0.00,11.30,1774.10,'2022-04-02 16:48:30','',''),(2615506,'1','202','1036',477,'Retail Sale Id 1666',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 16:52:18','',''),(2615507,'1','202','1036',477,'Retail Sale Id 1667',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 16:55:57','',''),(2615508,'1','202','1036',477,'Retail Sale Id 1668',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 16:57:20','',''),(2615509,'1','202','1036',477,'Retail Sale Id 1669',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 16:59:12','',''),(2615510,'1','202','1036',477,'Retail Sale Id 1670',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 17:01:05','',''),(2615511,'1','202','1036',477,'Retail Sale Id 1671',1500.64,0.00,0.00,2.26,354.82,'2022-04-02 17:02:07','',''),(2615512,'1','202','1036',477,'Retail Sale Id 1672',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 17:14:55','',''),(2615513,'1','202','1036',477,'Retail Sale Id 1673',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 17:17:49','',''),(2615514,'1','202','1036',477,'Retail Sale Id 1674',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 17:18:48','',''),(2615515,'1','202','1036',477,'Retail Sale Id 1675',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 17:21:55','',''),(2615516,'1','202','1036',477,'Retail Sale Id 1676',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 17:24:35','',''),(2615517,'1','202','1036',477,'Retail Sale Id 1677',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 17:25:54','',''),(2615518,'1','202','1036',477,'Retail Sale Id 1678',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 17:33:55','',''),(2615519,'1','202','1036',477,'Retail Sale Id 1679',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 17:44:55','',''),(2615520,'1','202','1036',477,'Retail Sale Id 1680',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 17:46:10','',''),(2615521,'1','202','1036',477,'Retail Sale Id 1681',15300.00,0.00,0.00,25.00,2625.00,'2022-04-02 17:57:47','',''),(2615522,'1','202','1036',477,'Retail Sale Id 1682',2656.00,0.00,0.00,4.00,628.00,'2022-04-02 17:59:34','',''),(2615523,'1','202','1036',477,'Retail Sale Id 1683',1500.64,0.00,0.00,2.26,354.82,'2022-04-02 18:00:10','',''),(2615524,'1','202','1036',477,'Retail Sale Id 1684',8300.00,0.00,0.00,12.50,1962.50,'2022-04-02 18:01:19','',''),(2615525,'1','202','1036',477,'Retail Sale Id 1685',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 18:02:10','',''),(2615526,'1','202','1036',477,'Retail Sale Id 1686',6998.56,0.00,0.00,10.54,1654.78,'2022-04-02 18:04:21','',''),(2615527,'1','202','1036',477,'Retail Sale Id 1687',2702.48,0.00,0.00,4.07,638.99,'2022-04-02 18:05:34','',''),(2615528,'1','202','1036',477,'Retail Sale Id 1688',30600.00,0.00,0.00,50.00,5250.00,'2022-04-02 18:13:38','',''),(2615529,'1','202','1036',477,'Retail Sale Id 1690',3001.28,0.00,0.00,4.52,709.64,'2022-04-02 18:15:02','',''),(2615530,'1','202','1036',477,'Retail Sale Id 1691',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 18:16:01','',''),(2615531,'1','202','1036',477,'Retail Sale Id 1693',3499.28,0.00,0.00,5.27,827.39,'2022-04-02 18:20:26','',''),(2615532,'1','202','1036',477,'Retail Sale Id 1694',1500.64,0.00,0.00,2.26,354.82,'2022-04-02 18:21:01','',''),(2615533,'1','202','1036',477,'Retail Sale Id 1695',36720.00,0.00,0.00,60.00,6300.00,'2022-04-02 18:22:18','',''),(2615534,'1','202','1036',477,'Retail Sale Id 1696',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 18:23:27','',''),(2615535,'1','202','1036',477,'Retail Sale Id 1697',33660.00,0.00,0.00,55.00,5775.00,'2022-04-02 18:24:52','',''),(2615536,'1','202','1036',477,'Retail Sale Id 1698',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 18:27:03','',''),(2615537,'1','202','1036',477,'Retail Sale Id 1699',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 18:27:48','',''),(2615538,'1','202','1036',477,'Retail Sale Id 1700',2702.48,0.00,0.00,4.07,638.99,'2022-04-02 18:39:25','',''),(2615539,'1','202','1036',477,'Retail Sale Id 1701',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 18:43:08','',''),(2615540,'1','202','1036',477,'Retail Sale Id 1702',1002.64,0.00,0.00,1.51,237.07,'2022-04-02 18:45:23','',''),(2615541,'1','202','1036',477,'Retail Sale Id 1703',3353.20,0.00,0.00,5.05,792.85,'2022-04-02 18:47:16','',''),(2615542,'1','202','1036',477,'Retail Sale Id 1704',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 18:55:20','',''),(2615543,'1','202','1036',477,'Retail Sale Id 1705',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 18:56:04','',''),(2615544,'1','202','1036',477,'Retail Sale Id 1706',1201.84,0.00,0.00,1.81,284.17,'2022-04-02 18:57:17','',''),(2615545,'1','202','1036',477,'Retail Sale Id 1707',3997.28,0.00,0.00,6.02,945.14,'2022-04-02 18:58:01','',''),(2615546,'1','202','1036',477,'Retail Sale Id 1708',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 18:59:12','',''),(2615547,'1','202','1036',477,'Retail Sale Id 1709',12297.28,0.00,0.00,18.52,2907.64,'2022-04-02 19:02:04','',''),(2615548,'1','202','1036',477,'Retail Sale Id 1710',1998.64,0.00,0.00,3.01,472.57,'2022-04-02 19:03:36','',''),(2615549,'1','202','1036',477,'Retail Sale Id 1711',5367.24,0.00,0.00,8.77,920.85,'2022-04-02 20:02:27','',''),(2615550,'1','202','1036',477,'Return of Retail Sale Id 1702',0.00,1002.64,1.51,0.00,-237.07,'2022-04-02 20:04:39','',''),(2615551,'1','202','1036',477,'Retail Sale Id 1712',4999.92,0.00,0.00,7.53,1182.21,'2022-04-03 08:00:34','',''),(2615552,'1','202','1036',477,'Retail Sale Id 1713',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 08:06:58','',''),(2615553,'1','202','1036',477,'Retail Sale Id 1714',2802.08,0.00,0.00,4.22,662.54,'2022-04-03 08:08:32','',''),(2615554,'1','202','1036',477,'Retail Sale Id 1715',44700.48,0.00,0.00,67.32,10569.24,'2022-04-03 08:13:01','',''),(2615555,'1','202','1036',477,'Retail Sale Id 1716',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 08:14:25','',''),(2615556,'1','202','1036',477,'Retail Sale Id 1717',1500.64,0.00,0.00,2.26,354.82,'2022-04-03 08:15:20','',''),(2615557,'1','202','1036',477,'Retail Sale Id 1718',7282.80,0.00,0.00,11.90,1249.50,'2022-04-03 08:17:32','',''),(2615558,'1','202','1036',477,'Retail Sale Id 1719',36720.00,0.00,0.00,60.00,6300.00,'2022-04-03 08:18:46','',''),(2615559,'1','202','1036',477,'Retail Sale Id 1720',139536.00,0.00,0.00,228.00,23940.00,'2022-04-03 08:19:46','',''),(2615560,'1','202','1036',477,'Retail Sale Id 1721',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 08:22:05','',''),(2615561,'1','202','1036',477,'Retail Sale Id 1722',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 08:24:36','',''),(2615562,'1','202','1036',477,'Retail Sale Id 1723',30600.00,0.00,0.00,50.00,5250.00,'2022-04-03 08:27:19','',''),(2615563,'1','202','1036',477,'Retail Sale Id 1724',1500.64,0.00,0.00,2.26,354.82,'2022-04-03 08:28:48','',''),(2615564,'1','202','1036',477,'Retail Sale Id 1725',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 08:32:47','',''),(2615565,'1','202','1036',477,'Retail Sale Id 1726',1500.64,0.00,0.00,2.26,354.82,'2022-04-03 08:33:44','',''),(2615566,'1','202','1036',477,'Retail Sale Id 1727',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 08:37:07','',''),(2615567,'1','202','1036',477,'Retail Sale Id 1728',5976.00,0.00,0.00,9.00,1413.00,'2022-04-03 08:40:00','',''),(2615568,'1','202','1036',477,'Retail Sale Id 1729',168300.00,0.00,0.00,275.00,28875.00,'2022-04-03 08:46:45','',''),(2615569,'1','202','1036',477,'Retail Sale Id 1730',1002.64,0.00,0.00,1.51,237.07,'2022-04-03 08:47:42','',''),(2615570,'1','202','1036',477,'Retail Sale Id 1731',1301.44,0.00,0.00,1.96,307.72,'2022-04-03 08:48:48','',''),(2615571,'1','202','1036',477,'Retail Sale Id 1732',61812.00,0.00,0.00,101.00,10605.00,'2022-04-03 08:53:29','',''),(2615572,'1','202','1036',477,'Retail Sale Id 1733',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 08:54:55','',''),(2615573,'1','202','1036',477,'Retail Sale Id 1734',1002.64,0.00,0.00,1.51,237.07,'2022-04-03 08:56:33','',''),(2615574,'1','202','1036',477,'Retail Sale Id 1735',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 09:00:16','',''),(2615575,'1','202','1036',477,'Retail Sale Id 1736',3001.28,0.00,0.00,4.52,709.64,'2022-04-03 09:02:23','',''),(2615576,'1','202','1036',477,'Retail Sale Id 1737',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 09:11:13','',''),(2615577,'1','202','1036',477,'Retail Sale Id 1738',70380.00,0.00,0.00,115.00,12075.00,'2022-04-03 09:14:46','',''),(2615578,'1','202','1036',477,'Retail Sale Id 1739',3320.00,0.00,0.00,5.00,785.00,'2022-04-03 09:24:48','',''),(2615579,'1','202','1036',477,'Retail Sale Id 1740',3300.08,0.00,0.00,4.97,780.29,'2022-04-03 09:36:43','',''),(2615580,'1','202','1036',477,'Retail Sale Id 1741',3001.28,0.00,0.00,4.52,709.64,'2022-04-03 09:37:52','',''),(2615581,'1','202','1036',477,'Retail Sale Id 1742',2503.28,0.00,0.00,3.77,591.89,'2022-04-03 09:39:36','',''),(2615582,'1','202','1036',477,'Retail Sale Id 1743',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 09:40:54','',''),(2615583,'1','202','1036',477,'Retail Sale Id 1744',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 09:41:57','',''),(2615584,'1','202','1036',477,'Retail Sale Id 1745',21420.00,0.00,0.00,35.00,3675.00,'2022-04-03 09:43:15','',''),(2615585,'1','202','1036',477,'Retail Sale Id 1746',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 09:45:49','',''),(2615586,'1','202','1036',477,'Retail Sale Id 1747',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 09:48:07','',''),(2615587,'1','202','1036',477,'Retail Sale Id 1748',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 09:53:46','',''),(2615588,'1','202','1036',477,'Retail Sale Id 1749',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 09:58:59','',''),(2615589,'1','202','1036',477,'Retail Sale Id 1750',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 10:00:40','',''),(2615590,'1','202','1036',477,'Retail Sale Id 1751',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 10:02:07','',''),(2615591,'1','202','1036',477,'Retail Sale Id 1752',2702.48,0.00,0.00,4.07,638.99,'2022-04-03 10:14:31','',''),(2615592,'1','202','1036',477,'Retail Sale Id 1753',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 10:22:12','',''),(2615593,'1','202','1036',477,'Retail Sale Id 1754',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 10:24:39','',''),(2615594,'1','202','1036',477,'Retail Sale Id 1755',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 10:26:34','',''),(2615595,'1','202','1036',477,'Retail Sale Id 1756',3399.68,0.00,0.00,5.12,803.84,'2022-04-03 10:41:15','',''),(2615596,'1','202','1036',477,'Retail Sale Id 1757',1347.92,0.00,0.00,2.03,318.71,'2022-04-03 10:43:29','',''),(2615597,'1','202','1036',477,'Retail Sale Id 1758',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 10:44:19','',''),(2615598,'1','202','1036',477,'Retail Sale Id 1759',3353.20,0.00,0.00,5.05,792.85,'2022-04-03 10:45:42','',''),(2615599,'1','202','1036',477,'Retail Sale Id 1761',1500.64,0.00,0.00,2.26,354.82,'2022-04-03 10:46:57','',''),(2615600,'1','202','1036',477,'Retail Sale Id 1762',36720.00,0.00,0.00,60.00,6300.00,'2022-04-03 10:48:59','',''),(2615601,'1','202','1036',477,'Retail Sale Id 1763',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 10:55:12','',''),(2615602,'1','202','1036',477,'Retail Sale Id 1764',70380.00,0.00,0.00,115.00,12075.00,'2022-04-03 11:00:54','',''),(2615603,'1','202','1036',477,'Retail Sale Id 1765',3353.20,0.00,0.00,5.05,792.85,'2022-04-03 11:02:04','',''),(2615604,'1','202','1036',477,'Retail Sale Id 1766',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 11:05:10','',''),(2615605,'1','202','1036',477,'Retail Sale Id 1767',6653.28,0.00,0.00,10.02,1573.14,'2022-04-03 11:07:12','',''),(2615606,'1','202','1036',477,'Retail Sale Id 1768',1002.64,0.00,0.00,1.51,237.07,'2022-04-03 11:15:55','',''),(2615607,'1','202','1036',477,'Retail Sale Id 1769',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 11:17:37','',''),(2615608,'1','202','1036',477,'Retail Sale Id 1770',30294.00,0.00,0.00,49.50,5197.50,'2022-04-03 11:23:56','',''),(2615609,'1','202','1036',477,'Retail Sale Id 1771',1002.64,0.00,0.00,1.51,237.07,'2022-04-03 11:28:14','',''),(2615610,'1','202','1036',477,'Retail Sale Id 1772',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 11:29:47','',''),(2615611,'1','202','1036',477,'Retail Sale Id 1773',2702.48,0.00,0.00,4.07,638.99,'2022-04-03 11:38:13','',''),(2615612,'1','202','1036',477,'Retail Sale Id 1774',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 11:47:13','',''),(2615613,'1','202','1036',477,'Retail Sale Id 1775',1500.64,0.00,0.00,2.26,354.82,'2022-04-03 11:48:22','',''),(2615614,'1','202','1036',477,'Retail Sale Id 1776',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 11:49:52','',''),(2615615,'1','202','1036',477,'Retail Sale Id 1777',3399.68,0.00,0.00,5.12,803.84,'2022-04-03 11:50:49','',''),(2615616,'1','202','1036',477,'Retail Sale Id 1778',30600.00,0.00,0.00,50.00,5250.00,'2022-04-03 11:52:42','',''),(2615617,'1','202','1036',477,'Retail Sale Id 1779',6653.28,0.00,0.00,10.02,1573.14,'2022-04-03 12:02:31','',''),(2615618,'1','202','1036',477,'Retail Sale Id 1780',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 12:07:00','',''),(2615619,'1','202','1036',477,'Retail Sale Id 1781',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 12:07:56','',''),(2615620,'1','202','1036',477,'Retail Sale Id 1782',1347.92,0.00,0.00,2.03,318.71,'2022-04-03 12:11:09','',''),(2615621,'1','202','1036',477,'Retail Sale Id 1783',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 12:14:39','',''),(2615622,'1','202','1036',477,'Retail Sale Id 1784',3001.28,0.00,0.00,4.52,709.64,'2022-04-03 12:15:46','',''),(2615623,'1','202','1036',477,'Retail Sale Id 1785',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 12:25:06','',''),(2615624,'1','202','1036',477,'Retail Sale Id 1786',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 12:26:12','',''),(2615625,'1','202','1036',477,'Retail Sale Id 1787',1799.44,0.00,0.00,2.71,425.47,'2022-04-03 12:27:19','',''),(2615626,'1','202','1036',477,'Retail Sale Id 1788',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 12:31:16','',''),(2615627,'1','202','1036',477,'Retail Sale Id 1789',1002.64,0.00,0.00,1.51,237.07,'2022-04-03 12:32:10','',''),(2615628,'1','202','1036',477,'Retail Sale Id 1790',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 12:45:23','',''),(2615629,'1','202','1036',477,'Retail Sale Id 1791',3499.28,0.00,0.00,5.27,827.39,'2022-04-03 12:51:30','',''),(2615630,'1','202','1036',477,'Retail Sale Id 1792',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 12:53:42','',''),(2615631,'1','202','1036',477,'Retail Sale Id 1793',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 12:54:38','',''),(2615632,'1','202','1036',477,'Retail Sale Id 1794',3499.28,0.00,0.00,5.27,827.39,'2022-04-03 12:55:40','',''),(2615633,'1','202','1036',477,'Retail Sale Id 1795',6653.28,0.00,0.00,10.02,1573.14,'2022-04-03 12:56:31','',''),(2615634,'1','202','1036',477,'Retail Sale Id 1796',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 12:58:01','',''),(2615635,'1','202','1036',477,'Retail Sale Id 1797',65484.00,0.00,0.00,107.00,11235.00,'2022-04-03 13:21:11','',''),(2615636,'1','202','1036',477,'Retail Sale Id 1798',3001.28,0.00,0.00,4.52,709.64,'2022-04-03 13:23:31','',''),(2615637,'1','202','1036',477,'Retail Sale Id 1799',3001.28,0.00,0.00,4.52,709.64,'2022-04-03 13:24:35','',''),(2615638,'1','202','1036',477,'Retail Sale Id 1800',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 13:25:14','',''),(2615639,'1','202','1036',477,'Retail Sale Id 1801',1401.04,0.00,0.00,2.11,331.27,'2022-04-03 13:26:07','',''),(2615640,'1','202','1036',477,'Retail Sale Id 1802',1401.04,0.00,0.00,2.11,331.27,'2022-04-03 13:26:59','',''),(2615641,'1','202','1036',477,'Retail Sale Id 1803',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 13:28:01','',''),(2615642,'1','202','1036',477,'Retail Sale Id 1804',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 13:33:44','',''),(2615643,'1','202','1036',477,'Retail Sale Id 1805',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 13:35:43','',''),(2615644,'1','202','1036',477,'Retail Sale Id 1806',1500.64,0.00,0.00,2.26,354.82,'2022-04-03 13:41:00','',''),(2615645,'1','202','1036',477,'Retail Sale Id 1807',4648.00,0.00,0.00,7.00,1099.00,'2022-04-03 13:42:17','',''),(2615646,'1','202','1036',477,'Retail Sale Id 1808',30600.00,0.00,0.00,50.00,5250.00,'2022-04-03 13:44:55','',''),(2615647,'1','202','1036',477,'Retail Sale Id 1810',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 13:47:22','',''),(2615648,'1','202','1036',477,'Retail Sale Id 1811',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 13:49:06','',''),(2615649,'1','202','1036',477,'Retail Sale Id 1812',863.20,0.00,0.00,1.30,204.10,'2022-04-03 13:53:30','',''),(2615650,'1','202','1036',477,'Retail Sale Id 1813',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 13:59:33','',''),(2615651,'1','202','1036',477,'Retail Sale Id 1815',1500.64,0.00,0.00,2.26,354.82,'2022-04-03 14:02:28','',''),(2615652,'1','202','1036',477,'Retail Sale Id 1816',2702.48,0.00,0.00,4.07,638.99,'2022-04-03 14:03:24','',''),(2615653,'1','202','1036',477,'Retail Sale Id 1817',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 14:04:04','',''),(2615654,'1','202','1036',477,'Retail Sale Id 1818',1500.64,0.00,0.00,2.26,354.82,'2022-04-03 14:06:29','',''),(2615655,'1','202','1036',477,'Retail Sale Id 1819',7503.20,0.00,0.00,11.30,1774.10,'2022-04-03 14:07:28','',''),(2615656,'1','202','1036',477,'Retail Sale Id 1820',3353.20,0.00,0.00,5.05,792.85,'2022-04-03 14:09:16','',''),(2615657,'1','202','1036',477,'Retail Sale Id 1821',3353.20,0.00,0.00,5.05,792.85,'2022-04-03 14:12:16','',''),(2615658,'1','202','1036',477,'Retail Sale Id 1822',3353.20,0.00,0.00,5.05,792.85,'2022-04-03 14:17:56','',''),(2615659,'1','202','1036',477,'Retail Sale Id 1823',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 14:23:19','',''),(2615660,'1','202','1036',477,'Retail Sale Id 1824',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 14:28:01','',''),(2615661,'1','202','1036',477,'Retail Sale Id 1825',3353.20,0.00,0.00,5.05,792.85,'2022-04-03 14:30:32','',''),(2615662,'1','202','1036',477,'Retail Sale Id 1826',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 14:47:37','',''),(2615663,'1','202','1036',477,'Retail Sale Id 1827',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 14:51:15','',''),(2615664,'1','202','1036',477,'Retail Sale Id 1828',6600.16,0.00,0.00,9.94,1560.58,'2022-04-03 14:54:52','',''),(2615665,'1','202','1036',477,'Retail Sale Id 1829',39780.00,0.00,0.00,65.00,6825.00,'2022-04-03 14:57:03','',''),(2615666,'1','202','1036',477,'Retail Sale Id 1830',903.04,0.00,0.00,1.36,213.52,'2022-04-03 14:59:06','',''),(2615667,'1','202','1036',477,'Retail Sale Id 1831',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 15:07:12','',''),(2615668,'1','202','1036',477,'Retail Sale Id 1833',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 15:13:09','',''),(2615669,'1','202','1036',477,'Retail Sale Id 1834',3353.20,0.00,0.00,5.05,792.85,'2022-04-03 15:14:44','',''),(2615670,'1','202','1036',477,'Retail Sale Id 1835',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 15:15:19','',''),(2615671,'1','202','1036',477,'Retail Sale Id 1836',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 15:29:14','',''),(2615672,'1','202','1036',477,'Retail Sale Id 1837',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 15:33:04','',''),(2615673,'1','202','1036',477,'Retail Sale Id 1838',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 15:34:07','',''),(2615674,'1','202','1036',477,'Retail Sale Id 1839',2702.48,0.00,0.00,4.07,638.99,'2022-04-03 15:35:15','',''),(2615675,'1','202','1036',477,'Retail Sale Id 1840',3001.28,0.00,0.00,4.52,709.64,'2022-04-03 15:39:30','',''),(2615676,'1','202','1036',477,'Retail Sale Id 1841',3001.28,0.00,0.00,4.52,709.64,'2022-04-03 15:40:57','',''),(2615677,'1','202','1036',477,'Retail Sale Id 1842',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 15:45:03','',''),(2615678,'1','202','1036',477,'Retail Sale Id 1843',4999.92,0.00,0.00,7.53,1182.21,'2022-04-03 15:46:20','',''),(2615679,'1','202','1036',477,'Retail Sale Id 1844',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 15:51:48','',''),(2615680,'1','202','1036',477,'Retail Sale Id 1845',1998.64,0.00,0.00,3.01,472.57,'2022-04-03 15:52:31','',''),(2615681,'1','202','1036',477,'Retail Sale Id 1846',105876.00,0.00,0.00,173.00,18165.00,'2022-04-03 15:57:46','',''),(2615682,'1','202','1036',477,'Retail Sale Id 1847',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 15:58:46','',''),(2615683,'1','202','1036',477,'Retail Sale Id 1847',8300.00,0.00,0.00,12.50,1962.50,'2022-04-03 15:58:46','',''),(2615684,'1','202','1036',477,'Retail Sale Id 1848',3353.20,0.00,0.00,5.05,792.85,'2022-04-03 16:04:23','',''),(2615685,'1','202','1036',477,'Retail Sale Id 1849',3997.28,0.00,0.00,6.02,945.14,'2022-04-03 16:06:24','',''),(2615686,'1','202','1036',477,'Return of Retail Sale Id 1846',0.00,105876.00,173.00,0.00,-18165.00,'2022-04-03 17:52:24','',''),(2615687,'1','202','1036',477,'Return of Retail Sale Id 1849',0.00,3997.28,6.02,0.00,-945.14,'2022-04-03 17:54:51','',''),(2615688,'1','202','1036',477,'Retail Sale Id 1850',11083.32,0.00,0.00,18.11,1901.55,'2022-04-03 17:57:44','',''),(2615689,'1','202','1036',477,'Retail Sale Id 1851',8300.00,0.00,0.00,12.50,1962.50,'2022-04-04 07:27:34','',''),(2615690,'1','202','1036',477,'Retail Sale Id 1852',23409.00,0.00,0.00,38.25,4016.25,'2022-04-04 07:34:01','',''),(2615691,'1','202','1036',477,'Retail Sale Id 1853',36720.00,0.00,0.00,60.00,6300.00,'2022-04-04 07:35:49','',''),(2615692,'1','202','1036',477,'Return of Retail Sale Id 1852',0.00,23409.00,38.25,0.00,-4016.25,'2022-04-04 07:36:44','',''),(2615693,'1','202','1036',477,'Retail Sale Id 1854',23470.20,0.00,0.00,38.35,4026.75,'2022-04-04 07:37:33','',''),(2615694,'1','202','1036',477,'Retail Sale Id 1855',903.04,0.00,0.00,1.36,213.52,'2022-04-04 07:38:52','',''),(2615695,'1','202','1036',477,'Retail Sale Id 1856',3353.20,0.00,0.00,5.05,792.85,'2022-04-04 07:39:44','',''),(2615696,'1','202','1036',477,'Retail Sale Id 1857',3001.28,0.00,0.00,4.52,709.64,'2022-04-04 07:44:24','',''),(2615697,'1','202','1036',477,'Retail Sale Id 1858',3001.28,0.00,0.00,4.52,709.64,'2022-04-04 07:45:06','',''),(2615698,'1','202','1036',477,'Retail Sale Id 1859',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 07:51:42','',''),(2615699,'1','202','1036',477,'Retail Sale Id 1860',30294.00,0.00,0.00,49.50,5197.50,'2022-04-04 08:02:34','',''),(2615700,'1','202','1036',477,'Retail Sale Id 1861',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 08:03:40','',''),(2615701,'1','202','1036',477,'Retail Sale Id 1862',6002.56,0.00,0.00,9.04,1419.28,'2022-04-04 08:07:08','',''),(2615702,'1','202','1036',477,'Retail Sale Id 1863',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 08:11:45','',''),(2615703,'1','202','1036',477,'Retail Sale Id 1864',12801.92,0.00,0.00,19.28,3026.96,'2022-04-04 08:16:23','',''),(2615704,'1','202','1036',477,'Retail Sale Id 1865',4150.00,0.00,0.00,6.25,981.25,'2022-04-04 08:19:13','',''),(2615705,'1','202','1036',477,'Retail Sale Id 1866',12240.00,0.00,0.00,20.00,2100.00,'2022-04-04 08:25:40','',''),(2615706,'1','202','1036',477,'Retail Sale Id 1867',6998.56,0.00,0.00,10.54,1654.78,'2022-04-04 08:26:43','',''),(2615707,'1','202','1036',477,'Retail Sale Id 1868',3001.28,0.00,0.00,4.52,709.64,'2022-04-04 08:29:17','',''),(2615708,'1','202','1036',477,'Retail Sale Id 1869',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 08:36:22','',''),(2615709,'1','202','1036',477,'Retail Sale Id 1870',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 08:40:51','',''),(2615710,'1','202','1036',477,'Retail Sale Id 1871',2702.48,0.00,0.00,4.07,638.99,'2022-04-04 08:58:23','',''),(2615711,'1','202','1036',477,'Retail Sale Id 1872',7304.00,0.00,0.00,11.00,1727.00,'2022-04-04 09:00:40','',''),(2615712,'1','202','1036',477,'Retail Sale Id 1873',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 09:01:35','',''),(2615713,'1','202','1036',477,'Retail Sale Id 1874',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 09:02:18','',''),(2615714,'1','202','1036',477,'Retail Sale Id 1876',1002.64,0.00,0.00,1.51,237.07,'2022-04-04 09:09:00','',''),(2615715,'1','202','1036',477,'Retail Sale Id 1877',18360.00,0.00,0.00,30.00,3150.00,'2022-04-04 09:12:33','',''),(2615716,'1','202','1036',477,'Retail Sale Id 1878',4999.92,0.00,0.00,7.53,1182.21,'2022-04-04 09:13:18','',''),(2615717,'1','202','1036',477,'Retail Sale Id 1879',24480.00,0.00,0.00,40.00,4200.00,'2022-04-04 09:15:15','',''),(2615718,'1','202','1036',477,'Retail Sale Id 1880',1500.64,0.00,0.00,2.26,354.82,'2022-04-04 09:17:25','',''),(2615719,'1','202','1036',477,'Retail Sale Id 1881',1699.84,0.00,0.00,2.56,401.92,'2022-04-04 09:20:15','',''),(2615720,'1','202','1036',477,'Retail Sale Id 1882',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 09:21:31','',''),(2615721,'1','202','1036',477,'Retail Sale Id 1883',3353.20,0.00,0.00,5.05,792.85,'2022-04-04 09:23:11','',''),(2615722,'1','202','1036',477,'Retail Sale Id 1884',4999.92,0.00,0.00,7.53,1182.21,'2022-04-04 09:24:46','',''),(2615723,'1','202','1036',477,'Retail Sale Id 1885',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 09:26:01','',''),(2615724,'1','202','1036',477,'Retail Sale Id 1886',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 09:30:47','',''),(2615725,'1','202','1036',477,'Retail Sale Id 1887',1401.04,0.00,0.00,2.11,331.27,'2022-04-04 09:32:41','',''),(2615726,'1','202','1036',477,'Retail Sale Id 1888',30600.00,0.00,0.00,50.00,5250.00,'2022-04-04 09:38:00','',''),(2615727,'1','202','1036',477,'Retail Sale Id 1889',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 09:44:02','',''),(2615728,'1','202','1036',477,'Retail Sale Id 1890',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 09:44:56','',''),(2615729,'1','202','1036',477,'Retail Sale Id 1891',1002.64,0.00,0.00,1.51,237.07,'2022-04-04 09:45:38','',''),(2615730,'1','202','1036',477,'Retail Sale Id 1892',8300.00,0.00,0.00,12.50,1962.50,'2022-04-04 09:46:37','',''),(2615731,'1','202','1036',477,'Retail Sale Id 1893',33660.00,0.00,0.00,55.00,5775.00,'2022-04-04 09:51:54','',''),(2615732,'1','202','1036',477,'Retail Sale Id 1895',8300.00,0.00,0.00,12.50,1962.50,'2022-04-04 10:05:17','',''),(2615733,'1','202','1036',477,'Retail Sale Id 1896',36720.00,0.00,0.00,60.00,6300.00,'2022-04-04 10:09:34','',''),(2615734,'1','202','1036',477,'Retail Sale Id 1897',3001.28,0.00,0.00,4.52,709.64,'2022-04-04 10:10:07','',''),(2615735,'1','202','1036',477,'Retail Sale Id 1898',8300.00,0.00,0.00,12.50,1962.50,'2022-04-04 10:13:37','',''),(2615736,'1','202','1036',477,'Retail Sale Id 1899',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 10:18:21','',''),(2615737,'1','202','1036',477,'Retail Sale Id 1900',4999.92,0.00,0.00,7.53,1182.21,'2022-04-04 10:23:39','',''),(2615738,'1','202','1036',477,'Retail Sale Id 1901',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 10:29:15','',''),(2615739,'1','202','1036',477,'Retail Sale Id 1902',102204.00,0.00,0.00,167.00,17535.00,'2022-04-04 10:33:22','',''),(2615740,'1','202','1036',477,'Retail Sale Id 1903',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 10:34:36','',''),(2615741,'1','202','1036',477,'Retail Sale Id 1904',1002.64,0.00,0.00,1.51,237.07,'2022-04-04 10:39:14','',''),(2615742,'1','202','1036',477,'Retail Sale Id 1905',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 10:47:24','',''),(2615743,'1','202','1036',477,'Retail Sale Id 1906',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 10:48:10','',''),(2615744,'1','202','1036',477,'Retail Sale Id 1907',2802.08,0.00,0.00,4.22,662.54,'2022-04-04 10:50:59','',''),(2615745,'1','202','1036',477,'Retail Sale Id 1908',8300.00,0.00,0.00,12.50,1962.50,'2022-04-04 10:52:12','',''),(2615746,'1','202','1036',477,'Retail Sale Id 1909',14688.00,0.00,0.00,24.00,2520.00,'2022-04-04 11:01:07','',''),(2615747,'1','202','1036',477,'Retail Sale Id 1910',8300.00,0.00,0.00,12.50,1962.50,'2022-04-04 11:03:39','',''),(2615748,'1','202','1036',477,'Retail Sale Id 1911',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 11:04:17','',''),(2615749,'1','202','1036',477,'Retail Sale Id 1912',8300.00,0.00,0.00,12.50,1962.50,'2022-04-04 11:08:04','',''),(2615750,'1','202','1036',477,'Retail Sale Id 1913',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 11:15:27','',''),(2615751,'1','202','1036',477,'Retail Sale Id 1914',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 11:20:03','',''),(2615752,'1','202','1036',477,'Retail Sale Id 1915',1002.64,0.00,0.00,1.51,237.07,'2022-04-04 11:28:41','',''),(2615753,'1','202','1036',477,'Retail Sale Id 1916',8300.00,0.00,0.00,12.50,1962.50,'2022-04-04 11:30:27','',''),(2615754,'1','202','1036',477,'Retail Sale Id 1917',1500.64,0.00,0.00,2.26,354.82,'2022-04-04 11:35:56','',''),(2615755,'1','202','1036',477,'Retail Sale Id 1918',1002.64,0.00,0.00,1.51,237.07,'2022-04-04 11:37:44','',''),(2615756,'1','202','1036',477,'Retail Sale Id 1919',2702.48,0.00,0.00,4.07,638.99,'2022-04-04 11:38:56','',''),(2615757,'1','202','1036',477,'Retail Sale Id 1920',39474.00,0.00,0.00,64.50,6772.50,'2022-04-04 11:40:36','',''),(2615758,'1','202','1036',477,'Retail Sale Id 1921',33660.00,0.00,0.00,55.00,5775.00,'2022-04-04 11:44:57','',''),(2615759,'1','202','1036',477,'Retail Sale Id 1922',1500.64,0.00,0.00,2.26,354.82,'2022-04-04 11:47:01','',''),(2615760,'1','202','1036',477,'Retail Sale Id 1923',69156.00,0.00,0.00,113.00,11865.00,'2022-04-04 11:57:26','',''),(2615761,'1','202','1036',477,'Retail Sale Id 1924',1002.64,0.00,0.00,1.51,237.07,'2022-04-04 11:58:48','',''),(2615762,'1','202','1036',477,'Retail Sale Id 1925',1002.64,0.00,0.00,1.51,237.07,'2022-04-04 11:59:29','',''),(2615763,'1','202','1036',477,'Retail Sale Id 1926',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 12:04:53','',''),(2615764,'1','202','1036',477,'Retail Sale Id 1927',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 12:06:49','',''),(2615765,'1','202','1036',477,'Retail Sale Id 1928',1998.64,0.00,0.00,3.01,472.57,'2022-04-04 12:10:32','',''),(2615766,'1','202','1036',477,'Retail Sale Id 1929',7197.76,0.00,0.00,10.84,1701.88,'2022-04-04 12:13:20','',''),(2615767,'1','202','1036',477,'Retail Sale Id 1930',3353.20,0.00,0.00,5.05,792.85,'2022-04-04 12:14:51','',''),(2615768,'1','202','1036',477,'Retail Sale Id 1931',3997.28,0.00,0.00,6.02,945.14,'2022-04-04 12:19:00','',''),(2615769,'1','202',NULL,477,'Purchased from AA RANO NIGERIA LIMITED',0.00,3178560.00,5280.00,0.00,0.00,'2022-04-04 12:20:48','',''),(2615770,'1','202',NULL,477,'Reception corrector for bridging 2',0.00,0.00,0.00,5280.00,0.00,'2022-04-04 12:21:49','',''),(2615771,'1','202','1036',477,'Received from bridging 2',0.00,0.00,5280.00,0.00,0.00,'2022-04-04 12:21:49','',''),(2615772,'1','202','1036',477,'Retail Sale Id 1932',3353.20,0.00,0.00,5.05,313.10,'2022-04-04 12:22:14','',''),(2615773,'1','202','1036',477,'Retail Sale Id 1933',697.20,0.00,0.00,1.05,65.10,'2022-04-04 12:28:33','',''),(2615774,'1','202','1036',477,'Retail Sale Id 1934',30600.00,0.00,0.00,50.00,500.00,'2022-04-04 12:56:01','',''),(2615775,'1','202','1036',477,'Retail Sale Id 1935',1201.84,0.00,0.00,1.81,112.22,'2022-04-04 13:21:11','',''),(2615776,'1','202','1036',477,'Retail Sale Id 1937',796.80,0.00,0.00,1.20,74.40,'2022-04-04 13:27:20','',''),(2615777,'1','202','1036',477,'Retail Sale Id 1938',3997.28,0.00,0.00,6.02,373.24,'2022-04-04 13:30:22','',''),(2615778,'1','202','1036',477,'Retail Sale Id 1940',3997.28,0.00,0.00,6.02,373.24,'2022-04-04 13:38:24','',''),(2615779,'1','202','1036',477,'Retail Sale Id 1942',3997.28,0.00,0.00,6.02,373.24,'2022-04-04 13:39:32','',''),(2615780,'1','202','1036',477,'Retail Sale Id 1943',10404.00,0.00,0.00,17.00,170.00,'2022-04-04 13:43:00','',''),(2615781,'1','202','1036',477,'Retail Sale Id 1944',30600.00,0.00,0.00,50.00,500.00,'2022-04-04 13:44:26','',''),(2615782,'1','202','1036',477,'Retail Sale Id 1945',6998.56,0.00,0.00,10.54,653.48,'2022-04-04 13:45:23','',''),(2615783,'1','202','1036',477,'Retail Sale Id 1946',30600.00,0.00,0.00,50.00,500.00,'2022-04-04 13:52:29','',''),(2615784,'1','202','1036',477,'Retail Sale Id 1947',3997.28,0.00,0.00,6.02,373.24,'2022-04-04 14:06:43','',''),(2615785,'1','202','1036',477,'Retail Sale Id 1948',8300.00,0.00,0.00,12.50,775.00,'2022-04-04 14:26:48','',''),(2615786,'1','202','1036',477,'Retail Sale Id 1949',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 14:32:57','',''),(2615787,'1','202','1036',477,'Retail Sale Id 1950',7650.00,0.00,0.00,12.50,125.00,'2022-04-04 14:34:45','',''),(2615788,'1','202','1036',477,'Retail Sale Id 1951',1002.64,0.00,0.00,1.51,93.62,'2022-04-04 14:35:38','',''),(2615789,'1','202','1036',477,'Retail Sale Id 1952',3353.20,0.00,0.00,5.05,313.10,'2022-04-04 14:44:15','',''),(2615790,'1','202','1036',477,'Retail Sale Id 1953',2702.48,0.00,0.00,4.07,252.34,'2022-04-04 14:45:09','',''),(2615791,'1','202','1036',477,'Retail Sale Id 1954',1500.64,0.00,0.00,2.26,140.12,'2022-04-04 14:47:05','',''),(2615792,'1','202','1036',477,'Retail Sale Id 1955',1201.84,0.00,0.00,1.81,112.22,'2022-04-04 14:48:57','',''),(2615793,'1','202','1036',477,'Retail Sale Id 1956',2197.84,0.00,0.00,3.31,205.22,'2022-04-04 14:50:10','',''),(2615794,'1','202','1036',477,'Retail Sale Id 1957',1201.84,0.00,0.00,1.81,112.22,'2022-04-04 15:00:51','',''),(2615795,'1','202','1036',477,'Retail Sale Id 1958',8300.00,0.00,0.00,12.50,775.00,'2022-04-04 15:06:37','',''),(2615796,'1','202','1036',477,'Retail Sale Id 1959',697.20,0.00,0.00,1.05,65.10,'2022-04-04 15:07:48','',''),(2615797,'1','202','1036',477,'Retail Sale Id 1960',1002.64,0.00,0.00,1.51,93.62,'2022-04-04 15:08:37','',''),(2615798,'1','202','1036',477,'Retail Sale Id 1962',796.80,0.00,0.00,1.20,74.40,'2022-04-04 15:11:10','',''),(2615799,'1','202','1036',477,'Retail Sale Id 1963',6653.28,0.00,0.00,10.02,621.24,'2022-04-04 15:47:48','',''),(2615800,'1','202','1036',477,'Retail Sale Id 1964',30600.00,0.00,0.00,50.00,500.00,'2022-04-04 15:50:48','',''),(2615801,'1','202','1036',477,'Retail Sale Id 1965',3399.68,0.00,0.00,5.12,317.44,'2022-04-04 15:53:48','',''),(2615802,'1','202','1036',477,'Retail Sale Id 1966',18360.00,0.00,0.00,30.00,300.00,'2022-04-04 15:56:12','',''),(2615803,'1','202','1036',477,'Retail Sale Id 1967',3001.28,0.00,0.00,4.52,280.24,'2022-04-04 15:57:26','',''),(2615804,'1','202','1036',477,'Retail Sale Id 1968',2098.24,0.00,0.00,3.16,195.92,'2022-04-04 16:19:21','',''),(2615805,'1','202','1036',477,'Retail Sale Id 1969',3997.28,0.00,0.00,6.02,373.24,'2022-04-04 16:20:20','',''),(2615806,'1','202','1036',477,'Retail Sale Id 1970',8001.20,0.00,0.00,12.05,747.10,'2022-04-04 16:21:41','',''),(2615807,'1','202','1036',477,'Retail Sale Id 1971',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 16:27:01','',''),(2615808,'1','202','1036',477,'Retail Sale Id 1972',1002.64,0.00,0.00,1.51,93.62,'2022-04-04 16:28:12','',''),(2615809,'1','202','1036',477,'Retail Sale Id 1973',42840.00,0.00,0.00,70.00,700.00,'2022-04-04 16:29:26','',''),(2615810,'1','202','1036',477,'Retail Sale Id 1974',30600.00,0.00,0.00,50.00,500.00,'2022-04-04 16:32:15','',''),(2615811,'1','202','1036',477,'Retail Sale Id 1975',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 16:33:51','',''),(2615812,'1','202','1036',477,'Retail Sale Id 1976',1401.04,0.00,0.00,2.11,130.82,'2022-04-04 16:34:43','',''),(2615813,'1','202','1036',477,'Retail Sale Id 1978',903.04,0.00,0.00,1.36,84.32,'2022-04-04 16:47:38','',''),(2615814,'1','202','1036',477,'Retail Sale Id 1980',1401.04,0.00,0.00,2.11,130.82,'2022-04-04 16:48:46','',''),(2615815,'1','202','1036',477,'Retail Sale Id 1981',4601.52,0.00,0.00,6.93,429.66,'2022-04-04 16:49:47','',''),(2615816,'1','202','1036',477,'Retail Sale Id 1982',3001.28,0.00,0.00,4.52,280.24,'2022-04-04 16:53:27','',''),(2615817,'1','202','1036',477,'Retail Sale Id 1983',1002.64,0.00,0.00,1.51,93.62,'2022-04-04 16:59:21','',''),(2615818,'1','202','1036',477,'Retail Sale Id 1984',30600.00,0.00,0.00,50.00,500.00,'2022-04-04 17:01:44','',''),(2615819,'1','202','1036',477,'Retail Sale Id 1985',3997.28,0.00,0.00,6.02,373.24,'2022-04-04 17:06:35','',''),(2615820,'1','202','1036',477,'Retail Sale Id 1986',6653.28,0.00,0.00,10.02,621.24,'2022-04-04 17:07:50','',''),(2615821,'1','202','1036',477,'Retail Sale Id 1987',7297.36,0.00,0.00,10.99,681.38,'2022-04-04 17:09:39','',''),(2615822,'1','202','1036',477,'Retail Sale Id 1988',6002.56,0.00,0.00,9.04,560.48,'2022-04-04 17:10:41','',''),(2615823,'1','202','1036',477,'Retail Sale Id 1989',30600.00,0.00,0.00,50.00,500.00,'2022-04-04 17:11:52','',''),(2615824,'1','202','1036',477,'Retail Sale Id 1990',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 17:20:19','',''),(2615825,'1','202','1036',477,'Retail Sale Id 1992',3001.28,0.00,0.00,4.52,280.24,'2022-04-04 17:21:18','',''),(2615826,'1','202','1036',477,'Retail Sale Id 1993',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 17:22:14','',''),(2615827,'1','202','1036',477,'Retail Sale Id 1994',1401.04,0.00,0.00,2.11,130.82,'2022-04-04 17:25:16','',''),(2615828,'1','202','1036',477,'Retail Sale Id 1995',3001.28,0.00,0.00,4.52,280.24,'2022-04-04 17:26:18','',''),(2615829,'1','202','1036',477,'Retail Sale Id 1996',39780.00,0.00,0.00,65.00,650.00,'2022-04-04 17:30:19','',''),(2615830,'1','202','1036',477,'Retail Sale Id 1997',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 17:34:40','',''),(2615831,'1','202','1036',477,'Retail Sale Id 1998',2503.28,0.00,0.00,3.77,233.74,'2022-04-04 17:35:33','',''),(2615832,'1','202','1036',477,'Retail Sale Id 1999',1002.64,0.00,0.00,1.51,93.62,'2022-04-04 17:44:11','',''),(2615833,'1','202','1036',477,'Retail Sale Id 2000',1401.04,0.00,0.00,2.11,130.82,'2022-04-04 17:44:55','',''),(2615834,'1','202','1036',477,'Retail Sale Id 2001',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 17:45:53','',''),(2615835,'1','202','1036',477,'Retail Sale Id 2002',3997.28,0.00,0.00,6.02,373.24,'2022-04-04 17:47:23','',''),(2615836,'1','202','1036',477,'Retail Sale Id 2003',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 17:48:40','',''),(2615837,'1','202','1036',477,'Retail Sale Id 2004',1500.64,0.00,0.00,2.26,140.12,'2022-04-04 17:49:47','',''),(2615838,'1','202','1036',477,'Retail Sale Id 2006',1002.64,0.00,0.00,1.51,93.62,'2022-04-04 17:53:39','',''),(2615839,'1','202','1036',477,'Retail Sale Id 2007',8300.00,0.00,0.00,12.50,775.00,'2022-04-04 17:55:44','',''),(2615840,'1','202','1036',477,'Retail Sale Id 2008',1500.64,0.00,0.00,2.26,140.12,'2022-04-04 17:56:39','',''),(2615841,'1','202','1036',477,'Retail Sale Id 2009',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 18:07:35','',''),(2615842,'1','202','1036',477,'Retail Sale Id 2010',8300.00,0.00,0.00,12.50,775.00,'2022-04-04 18:11:15','',''),(2615843,'1','202','1036',477,'Retail Sale Id 2011',597.60,0.00,0.00,0.90,55.80,'2022-04-04 18:19:33','',''),(2615844,'1','202','1036',477,'Retail Sale Id 2012',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 18:21:18','',''),(2615845,'1','202','1036',477,'Retail Sale Id 2013',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 18:27:19','',''),(2615846,'1','202','1036',477,'Retail Sale Id 2014',8300.00,0.00,0.00,12.50,775.00,'2022-04-04 18:32:07','',''),(2615847,'1','202','1036',477,'Retail Sale Id 2015',1998.64,0.00,0.00,3.01,186.62,'2022-04-04 18:34:13','',''),(2615848,'1','202','1036',477,'Retail Sale Id 2016',1002.64,0.00,0.00,1.51,93.62,'2022-04-04 18:36:48','',''),(2615849,'1','202','1036',477,'Retail Sale Id 2017',1500.64,0.00,0.00,2.26,140.12,'2022-04-04 18:47:26','',''),(2615850,'1','202','1036',477,'Retail Sale Id 2018',2702.48,0.00,0.00,4.07,252.34,'2022-04-04 18:49:53','',''),(2615851,'1','202','1036',477,'Retail Sale Id 2019',8001.20,0.00,0.00,12.05,747.10,'2022-04-04 18:51:48','',''),(2615852,'1','202','1036',477,'Retail Sale Id 2020',498.00,0.00,0.00,0.75,46.50,'2022-04-04 19:08:24','',''),(2615853,'1','202','1036',477,'Retail Sale Id 2021',2483.36,0.00,0.00,3.74,231.88,'2022-04-04 19:52:53','',''),(2615854,'1','202','1036',477,'Distributed to operational loss for sales id:1',1255386.72,0.00,0.00,2085.36,0.00,'2022-04-04 20:07:19','',''),(2615855,'1','202','1036',477,'Retail Sale Id 2022',1002.64,0.00,0.00,1.51,93.62,'2022-04-05 06:56:24','',''),(2615856,'1','202','1036',477,'Retail Sale Id 2023',26620.00,0.00,0.00,44.00,26620.00,'2022-04-05 07:15:55','',''),(2615857,'1','202','1036',477,'Retail Sale Id 2024',6653.28,0.00,0.00,10.02,6653.28,'2022-04-05 07:29:23','',''),(2615858,'1','202','1036',477,'Retail Sale Id 2025',2098.24,0.00,0.00,3.16,2098.24,'2022-04-05 07:36:56','',''),(2615859,'1','202','1036',477,'Retail Sale Id 2026',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 07:41:00','',''),(2615860,'1','202','1036',477,'Retail Sale Id 2027',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 07:52:32','',''),(2615861,'1','202','1036',477,'Retail Sale Id 2028',3499.28,0.00,0.00,5.27,3499.28,'2022-04-05 07:54:08','',''),(2615862,'1','202','1036',477,'Retail Sale Id 2029',1500.64,0.00,0.00,2.26,1500.64,'2022-04-05 07:54:52','',''),(2615863,'1','202','1036',477,'Retail Sale Id 2030',6653.28,0.00,0.00,10.02,6653.28,'2022-04-05 07:57:32','',''),(2615864,'1','202','1036',477,'Retail Sale Id 2031',2098.24,0.00,0.00,3.16,2098.24,'2022-04-05 08:02:21','',''),(2615865,'1','202','1036',477,'Retail Sale Id 2032',3001.28,0.00,0.00,4.52,3001.28,'2022-04-05 08:12:03','',''),(2615866,'1','202','1036',477,'Retail Sale Id 2033',10285.00,0.00,0.00,17.00,10285.00,'2022-04-05 08:13:12','',''),(2615867,'1','202','1036',477,'Retail Sale Id 2034',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 08:16:12','',''),(2615868,'1','202','1036',477,'Retail Sale Id 2035',3001.28,0.00,0.00,4.52,3001.28,'2022-04-05 08:20:45','',''),(2615869,'1','202','1036',477,'Retail Sale Id 2036',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 08:29:40','',''),(2615870,'1','202','1036',477,'Retail Sale Id 2037',3499.28,0.00,0.00,5.27,3499.28,'2022-04-05 08:30:30','',''),(2615871,'1','202','1036',477,'Retail Sale Id 2038',205700.00,0.00,0.00,340.00,205700.00,'2022-04-05 08:34:07','',''),(2615872,'1','202','1036',477,'Retail Sale Id 2039',1500.64,0.00,0.00,2.26,1500.64,'2022-04-05 08:35:03','',''),(2615873,'1','202','1036',477,'Retail Sale Id 2040',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 08:40:43','',''),(2615874,'1','202','1036',477,'Retail Sale Id 2041',1500.64,0.00,0.00,2.26,1500.64,'2022-04-05 08:47:00','',''),(2615875,'1','202','1036',477,'Retail Sale Id 2042',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 08:53:41','',''),(2615876,'1','202','1036',477,'Retail Sale Id 2043',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 08:58:04','',''),(2615877,'1','202','1036',477,'Retail Sale Id 2044',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 09:14:39','',''),(2615878,'1','202','1036',477,'Retail Sale Id 2045',3353.20,0.00,0.00,5.05,3353.20,'2022-04-05 09:26:46','',''),(2615879,'1','202','1036',477,'Retail Sale Id 2046',498.00,0.00,0.00,0.75,498.00,'2022-04-05 09:28:07','',''),(2615880,'1','202','1036',477,'Retail Sale Id 2047',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 09:33:17','',''),(2615881,'1','202','1036',477,'Retail Sale Id 2048',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 09:40:32','',''),(2615882,'1','202','1036',477,'Retail Sale Id 2053',3001.28,0.00,0.00,4.52,3001.28,'2022-04-05 09:46:02','',''),(2615883,'1','202','1036',477,'Retail Sale Id 2055',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 09:47:10','',''),(2615884,'1','202','1036',477,'Retail Sale Id 2056',2702.48,0.00,0.00,4.07,2702.48,'2022-04-05 09:50:05','',''),(2615885,'1','202','1036',477,'Retail Sale Id 2057',36300.00,0.00,0.00,60.00,36300.00,'2022-04-05 09:51:18','',''),(2615886,'1','202','1036',477,'Retail Sale Id 2058',1347.92,0.00,0.00,2.03,1347.92,'2022-04-05 09:53:26','',''),(2615887,'1','202','1036',477,'Retail Sale Id 2059',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 09:54:42','',''),(2615888,'1','202','1036',477,'Retail Sale Id 2060',33275.00,0.00,0.00,55.00,33275.00,'2022-04-05 09:57:12','',''),(2615889,'1','202','1036',477,'Retail Sale Id 2061',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 10:00:16','',''),(2615890,'1','202','1036',477,'Retail Sale Id 2062',14520.00,0.00,0.00,24.00,14520.00,'2022-04-05 10:03:12','',''),(2615891,'1','202','1036',477,'Retail Sale Id 2063',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 10:05:28','',''),(2615892,'1','202','1036',477,'Retail Sale Id 2064',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 10:18:56','',''),(2615893,'1','202','1036',477,'Retail Sale Id 2065',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 10:22:26','',''),(2615894,'1','202','1036',477,'Retail Sale Id 2066',4999.92,0.00,0.00,7.53,4999.92,'2022-04-05 10:25:45','',''),(2615895,'1','202','1036',477,'Retail Sale Id 2067',160325.00,0.00,0.00,265.00,160325.00,'2022-04-05 10:32:35','',''),(2615896,'1','202','1036',477,'Retail Sale Id 2068',3300.08,0.00,0.00,4.97,3300.08,'2022-04-05 10:56:19','',''),(2615897,'1','202','1036',477,'Retail Sale Id 2069',1899.04,0.00,0.00,2.86,1899.04,'2022-04-05 10:56:59','',''),(2615898,'1','202','1036',477,'Retail Sale Id 2070',3001.28,0.00,0.00,4.52,3001.28,'2022-04-05 10:57:55','',''),(2615899,'1','202','1036',477,'Retail Sale Id 2071',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 10:59:00','',''),(2615900,'1','202','1036',477,'Retail Sale Id 2072',3001.28,0.00,0.00,4.52,3001.28,'2022-04-05 11:07:14','',''),(2615901,'1','202','1036',477,'Retail Sale Id 2074',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 11:08:32','',''),(2615902,'1','202','1036',477,'Retail Sale Id 2075',37510.00,0.00,0.00,62.00,37510.00,'2022-04-05 11:11:13','',''),(2615903,'1','202','1036',477,'Retail Sale Id 2076',6653.28,0.00,0.00,10.02,6653.28,'2022-04-05 11:13:23','',''),(2615904,'1','202','1036',477,'Retail Sale Id 2077',1301.44,0.00,0.00,1.96,1301.44,'2022-04-05 11:19:06','',''),(2615905,'1','202','1036',477,'Retail Sale Id 2078',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 11:20:07','',''),(2615906,'1','202','1036',477,'Retail Sale Id 2079',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 11:21:16','',''),(2615907,'1','202','1036',477,'Retail Sale Id 2080',6699.76,0.00,0.00,10.09,6699.76,'2022-04-05 11:34:53','',''),(2615908,'1','202','1036',477,'Retail Sale Id 2081',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 11:36:34','',''),(2615909,'1','202','1036',477,'Retail Sale Id 2082',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 11:48:22','',''),(2615910,'1','202','1036',477,'Retail Sale Id 2083',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 11:51:45','',''),(2615911,'1','202','1036',477,'Retail Sale Id 2085',30250.00,0.00,0.00,50.00,30250.00,'2022-04-05 11:54:39','',''),(2615912,'1','202','1036',477,'Retail Sale Id 2086',172425.00,0.00,0.00,285.00,172425.00,'2022-04-05 12:03:51','',''),(2615913,'1','202','1036',477,'Retail Sale Id 2088',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 12:05:07','',''),(2615914,'1','202','1036',477,'Retail Sale Id 2089',3399.68,0.00,0.00,5.12,3399.68,'2022-04-05 12:08:34','',''),(2615915,'1','202','1036',477,'Retail Sale Id 2090',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 12:12:27','',''),(2615916,'1','202','1036',477,'Retail Sale Id 2091',4999.92,0.00,0.00,7.53,4999.92,'2022-04-05 12:15:31','',''),(2615917,'1','202','1036',477,'Retail Sale Id 2092',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 12:16:31','',''),(2615918,'1','202','1036',477,'Retail Sale Id 2093',50820.00,0.00,0.00,84.00,50820.00,'2022-04-05 12:23:52','',''),(2615919,'1','202','1036',477,'Retail Sale Id 2094',29947.50,0.00,0.00,49.50,29947.50,'2022-04-05 12:40:53','',''),(2615920,'1','202','1036',477,'Retail Sale Id 2095',3300.08,0.00,0.00,4.97,3300.08,'2022-04-05 12:42:05','',''),(2615921,'1','202','1036',477,'Retail Sale Id 2097',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 12:42:48','',''),(2615922,'1','202','1036',477,'Retail Sale Id 2098',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 12:50:50','',''),(2615923,'1','202','1036',477,'Retail Sale Id 2099',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 12:58:34','',''),(2615924,'1','202','1036',477,'Retail Sale Id 2100',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 12:59:21','',''),(2615925,'1','202','1036',477,'Retail Sale Id 2101',2503.28,0.00,0.00,3.77,2503.28,'2022-04-05 13:04:26','',''),(2615926,'1','202','1036',477,'Retail Sale Id 2102',1347.92,0.00,0.00,2.03,1347.92,'2022-04-05 13:13:57','',''),(2615927,'1','202','1036',477,'Retail Sale Id 2103',3353.20,0.00,0.00,5.05,3353.20,'2022-04-05 13:21:57','',''),(2615928,'1','202','1036',477,'Retail Sale Id 2105',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 13:23:10','',''),(2615929,'1','202','1036',477,'Retail Sale Id 2106',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 13:34:59','',''),(2615930,'1','202','1036',477,'Retail Sale Id 2107',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 13:42:21','',''),(2615931,'1','202','1036',477,'Retail Sale Id 2108',3001.28,0.00,0.00,4.52,3001.28,'2022-04-05 13:44:19','',''),(2615932,'1','202','1036',477,'Retail Sale Id 2109',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 13:45:29','',''),(2615933,'1','202','1036',477,'Retail Sale Id 2110',1500.64,0.00,0.00,2.26,1500.64,'2022-04-05 13:49:29','',''),(2615934,'1','202','1036',477,'Retail Sale Id 2111',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 13:58:20','',''),(2615935,'1','202','1036',477,'Retail Sale Id 2112',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 14:14:46','',''),(2615936,'1','202','1036',477,'Retail Sale Id 2113',1301.44,0.00,0.00,1.96,1301.44,'2022-04-05 14:16:57','',''),(2615937,'1','202','1036',477,'Retail Sale Id 2114',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 14:32:18','',''),(2615938,'1','202','1036',477,'Retail Sale Id 2115',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 14:33:31','',''),(2615939,'1','202','1036',477,'Retail Sale Id 2116',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 14:39:15','',''),(2615940,'1','202','1036',477,'Retail Sale Id 2117',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 14:42:54','',''),(2615941,'1','202','1036',477,'Retail Sale Id 2118',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 14:49:21','',''),(2615942,'1','202','1036',477,'Retail Sale Id 2119',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 14:50:43','',''),(2615943,'1','202','1036',477,'Retail Sale Id 2120',3353.20,0.00,0.00,5.05,3353.20,'2022-04-05 15:11:22','',''),(2615944,'1','202','1036',477,'Retail Sale Id 2121',697.20,0.00,0.00,1.05,697.20,'2022-04-05 15:17:10','',''),(2615945,'1','202','1036',477,'Retail Sale Id 2122',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 15:20:20','',''),(2615946,'1','202','1036',477,'Retail Sale Id 2123',3353.20,0.00,0.00,5.05,3353.20,'2022-04-05 15:23:40','',''),(2615947,'1','202','1036',477,'Retail Sale Id 2124',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 15:24:17','',''),(2615948,'1','202','1036',477,'Retail Sale Id 2125',3353.20,0.00,0.00,5.05,3353.20,'2022-04-05 15:35:34','',''),(2615949,'1','202','1036',477,'Retail Sale Id 2126',1328.00,0.00,0.00,2.00,1328.00,'2022-04-05 15:39:02','',''),(2615950,'1','202','1036',477,'Retail Sale Id 2127',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 15:39:51','',''),(2615951,'1','202','1036',477,'Retail Sale Id 2128',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 15:51:36','',''),(2615952,'1','202','1036',477,'Retail Sale Id 2129',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 15:52:31','',''),(2615953,'1','202','1036',477,'Retail Sale Id 2130',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 16:00:21','',''),(2615954,'1','202','1036',477,'Retail Sale Id 2131',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 16:01:10','',''),(2615955,'1','202','1036',477,'Retail Sale Id 2132',1401.04,0.00,0.00,2.11,1401.04,'2022-04-05 16:06:27','',''),(2615956,'1','202','1036',477,'Retail Sale Id 2133',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 16:08:58','',''),(2615957,'1','202','1036',477,'Retail Sale Id 2134',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 16:09:39','',''),(2615958,'1','202','1036',477,'Retail Sale Id 2135',1500.64,0.00,0.00,2.26,1500.64,'2022-04-05 16:10:46','',''),(2615959,'1','202','1036',477,'Retail Sale Id 2136',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 16:15:17','',''),(2615960,'1','202','1036',477,'Retail Sale Id 2137',1201.84,0.00,0.00,1.81,1201.84,'2022-04-05 16:23:20','',''),(2615961,'1','202','1036',477,'Retail Sale Id 2138',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 16:24:12','',''),(2615962,'1','202','1036',477,'Retail Sale Id 2139',1401.04,0.00,0.00,2.11,1401.04,'2022-04-05 16:25:11','',''),(2615963,'1','202','1036',477,'Retail Sale Id 2140',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 16:26:02','',''),(2615964,'1','202','1036',477,'Retail Sale Id 2141',1401.04,0.00,0.00,2.11,1401.04,'2022-04-05 16:27:23','',''),(2615965,'1','202','1036',477,'Retail Sale Id 2142',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 16:29:04','',''),(2615966,'1','202','1036',477,'Retail Sale Id 2143',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 16:30:22','',''),(2615967,'1','202','1036',477,'Retail Sale Id 2144',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 16:35:12','',''),(2615968,'1','202','1036',477,'Retail Sale Id 2145',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 16:36:03','',''),(2615969,'1','202','1036',477,'Retail Sale Id 2146',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 16:42:35','',''),(2615970,'1','202','1036',477,'Retail Sale Id 2147',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 16:43:15','',''),(2615971,'1','202','1036',477,'Retail Sale Id 2148',1401.04,0.00,0.00,2.11,1401.04,'2022-04-05 16:44:05','',''),(2615972,'1','202','1036',477,'Retail Sale Id 2149',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 16:44:42','',''),(2615973,'1','202','1036',477,'Retail Sale Id 2150',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 16:52:11','',''),(2615974,'1','202','1036',477,'Retail Sale Id 2151',35997.50,0.00,0.00,59.50,35997.50,'2022-04-05 16:53:55','',''),(2615975,'1','202','1036',477,'Retail Sale Id 2152',6002.56,0.00,0.00,9.04,6002.56,'2022-04-05 16:56:05','',''),(2615976,'1','202','1036',477,'Retail Sale Id 2153',3353.20,0.00,0.00,5.05,3353.20,'2022-04-05 16:58:06','',''),(2615977,'1','202','1036',477,'Retail Sale Id 2154',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 17:02:16','',''),(2615978,'1','202','1036',477,'Retail Sale Id 2155',8300.00,0.00,0.00,12.50,8300.00,'2022-04-05 17:07:46','',''),(2615979,'1','202','1036',477,'Retail Sale Id 2156',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 17:08:22','',''),(2615980,'1','202','1036',477,'Retail Sale Id 2157',1401.04,0.00,0.00,2.11,1401.04,'2022-04-05 17:17:21','',''),(2615981,'1','202','1036',477,'Retail Sale Id 2158',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 17:19:39','',''),(2615982,'1','202','1036',477,'Retail Sale Id 2159',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 17:27:30','',''),(2615983,'1','202','1036',477,'Retail Sale Id 2160',2702.48,0.00,0.00,4.07,2702.48,'2022-04-05 17:28:19','',''),(2615984,'1','202','1036',477,'Retail Sale Id 2161',3997.28,0.00,0.00,6.02,3997.28,'2022-04-05 17:29:15','',''),(2615985,'1','202','1036',477,'Retail Sale Id 2162',1500.64,0.00,0.00,2.26,1500.64,'2022-04-05 17:31:45','',''),(2615986,'1','202','1036',477,'Retail Sale Id 2163',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 17:40:40','',''),(2615987,'1','202','1036',477,'Retail Sale Id 2164',24200.00,0.00,0.00,40.00,24200.00,'2022-04-05 17:53:02','',''),(2615988,'1','202','1036',477,'Retail Sale Id 2165',33275.00,0.00,0.00,55.00,33275.00,'2022-04-05 18:00:30','',''),(2615989,'1','202','1036',477,'Retail Sale Id 2166',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 18:02:08','',''),(2615990,'1','202','1036',477,'Retail Sale Id 2167',498.00,0.00,0.00,0.75,498.00,'2022-04-05 18:03:20','',''),(2615991,'1','202','1036',477,'Retail Sale Id 2168',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 18:07:54','',''),(2615992,'1','202','1036',477,'Retail Sale Id 2169',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 18:09:29','',''),(2615993,'1','202','1036',477,'Retail Sale Id 2170',498.00,0.00,0.00,0.75,498.00,'2022-04-05 18:14:55','',''),(2615994,'1','202','1036',477,'Retail Sale Id 2171',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 18:23:44','',''),(2615995,'1','202','1036',477,'Retail Sale Id 2172',1500.64,0.00,0.00,2.26,1500.64,'2022-04-05 18:26:16','',''),(2615996,'1','202','1036',477,'Retail Sale Id 2173',2702.48,0.00,0.00,4.07,2702.48,'2022-04-05 18:37:56','',''),(2615997,'1','202','1036',477,'Retail Sale Id 2174',697.20,0.00,0.00,1.05,697.20,'2022-04-05 18:42:29','',''),(2615998,'1','202','1036',477,'Retail Sale Id 2175',3353.20,0.00,0.00,5.05,3353.20,'2022-04-05 18:47:21','',''),(2615999,'1','202','1036',477,'Retail Sale Id 2176',2702.48,0.00,0.00,4.07,2702.48,'2022-04-05 18:50:21','',''),(2616000,'1','202','1036',477,'Retail Sale Id 2177',12297.28,0.00,0.00,18.52,12297.28,'2022-04-05 18:51:38','',''),(2616001,'1','202','1036',477,'Retail Sale Id 2178',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 18:52:55','',''),(2616002,'1','202','1036',477,'Retail Sale Id 2179',1998.64,0.00,0.00,3.01,1998.64,'2022-04-05 18:54:50','',''),(2616003,'1','202','1036',477,'Retail Sale Id 2180',1002.64,0.00,0.00,1.51,1002.64,'2022-04-05 19:03:20','',''),(2616004,'1','202','1036',477,'Retail Sale Id 2181',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 07:09:31','',''),(2616005,'1','202','1036',477,'Retail Sale Id 2182',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 07:13:25','',''),(2616006,'1','202','1036',477,'Retail Sale Id 2183',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 07:19:33','',''),(2616007,'1','202','1036',477,'Retail Sale Id 2184',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 07:20:49','',''),(2616008,'1','202','1036',477,'Retail Sale Id 2185',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 07:25:19','',''),(2616009,'1','202','1036',477,'Retail Sale Id 2186',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 07:26:06','',''),(2616010,'1','202','1036',477,'Retail Sale Id 2187',1002.64,0.00,0.00,1.51,1002.64,'2022-04-06 07:28:58','',''),(2616011,'1','202','1036',477,'Retail Sale Id 2188',1002.64,0.00,0.00,1.51,1002.64,'2022-04-06 07:32:07','',''),(2616012,'1','202','1036',477,'Retail Sale Id 2189',1201.84,0.00,0.00,1.81,1201.84,'2022-04-06 07:32:49','',''),(2616013,'1','202','1036',477,'Retail Sale Id 2190',3001.28,0.00,0.00,4.52,3001.28,'2022-04-06 07:34:06','',''),(2616014,'1','202','1036',477,'Retail Sale Id 2191',3499.28,0.00,0.00,5.27,3499.28,'2022-04-06 07:35:40','',''),(2616015,'1','202','1036',477,'Retail Sale Id 2192',30250.00,0.00,0.00,50.00,30250.00,'2022-04-06 07:38:59','',''),(2616016,'1','202','1036',477,'Retail Sale Id 2193',7598.80,0.00,0.00,12.56,7598.80,'2022-04-06 07:47:12','',''),(2616017,'1','202','1036',477,'Retail Sale Id 2194',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 07:48:43','',''),(2616018,'1','202','1036',477,'Retail Sale Id 2195',1500.64,0.00,0.00,2.26,1500.64,'2022-04-06 07:54:58','',''),(2616019,'1','202','1036',477,'Retail Sale Id 2196',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 07:59:46','',''),(2616020,'1','202','1036',477,'Retail Sale Id 2197',2702.48,0.00,0.00,4.07,2702.48,'2022-04-06 08:04:06','',''),(2616021,'1','202','1036',477,'Retail Sale Id 2198',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 08:06:19','',''),(2616022,'1','202','1036',477,'Retail Sale Id 2199',29645.00,0.00,0.00,49.00,29645.00,'2022-04-06 08:13:21','',''),(2616023,'1','202','1036',477,'Retail Sale Id 2200',3353.20,0.00,0.00,5.05,3353.20,'2022-04-06 08:15:50','',''),(2616024,'1','202','1036',477,'Retail Sale Id 2201',30250.00,0.00,0.00,50.00,30250.00,'2022-04-06 08:20:53','',''),(2616025,'1','202','1036',477,'Retail Sale Id 2202',1401.04,0.00,0.00,2.11,1401.04,'2022-04-06 08:22:43','',''),(2616026,'1','202','1036',477,'Retail Sale Id 2203',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 08:27:59','',''),(2616027,'1','202','1036',477,'Retail Sale Id 2204',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 08:34:42','',''),(2616028,'1','202','1036',477,'Retail Sale Id 2205',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 08:55:26','',''),(2616029,'1','202','1036',477,'Retail Sale Id 2206',4999.92,0.00,0.00,7.53,4999.92,'2022-04-06 09:03:05','',''),(2616030,'1','202','1036',477,'Retail Sale Id 2207',3001.28,0.00,0.00,4.52,3001.28,'2022-04-06 09:04:56','',''),(2616031,'1','202','1036',477,'Retail Sale Id 2208',3353.20,0.00,0.00,5.05,3353.20,'2022-04-06 09:06:14','',''),(2616032,'1','202','1036',477,'Retail Sale Id 2209',2602.88,0.00,0.00,3.92,2602.88,'2022-04-06 09:07:52','',''),(2616033,'1','202','1036',477,'Retail Sale Id 2210',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 09:08:41','',''),(2616034,'1','202','1036',477,'Retail Sale Id 2211',3353.20,0.00,0.00,5.05,3353.20,'2022-04-06 09:20:59','',''),(2616035,'1','202','1036',477,'Retail Sale Id 2212',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 09:21:58','',''),(2616036,'1','202','1036',477,'Retail Sale Id 2213',33275.00,0.00,0.00,55.00,33275.00,'2022-04-06 09:27:51','',''),(2616037,'1','202','1036',477,'Retail Sale Id 2214',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 09:30:23','',''),(2616038,'1','202','1036',477,'Retail Sale Id 2215',1500.64,0.00,0.00,2.26,1500.64,'2022-04-06 09:31:04','',''),(2616039,'1','202','1036',477,'Retail Sale Id 2216',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 09:31:55','',''),(2616040,'1','202','1036',477,'Retail Sale Id 2217',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 09:34:55','',''),(2616041,'1','202','1036',477,'Retail Sale Id 2218',33275.00,0.00,0.00,55.00,33275.00,'2022-04-06 10:06:22','',''),(2616042,'1','202','1036',477,'Retail Sale Id 2219',697.20,0.00,0.00,1.05,697.20,'2022-04-06 10:07:47','',''),(2616043,'1','202','1036',477,'Retail Sale Id 2220',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 10:14:45','',''),(2616044,'1','202','1036',477,'Retail Sale Id 2221',15125.00,0.00,0.00,25.00,15125.00,'2022-04-06 10:23:43','',''),(2616045,'1','202','1036',477,'Retail Sale Id 2222',14520.00,0.00,0.00,24.00,14520.00,'2022-04-06 10:25:30','',''),(2616046,'1','202','1036',477,'Retail Sale Id 2223',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 10:26:45','',''),(2616047,'1','202','1036',477,'Retail Sale Id 2225',1500.64,0.00,0.00,2.26,1500.64,'2022-04-06 10:30:44','',''),(2616048,'1','202','1036',477,'Retail Sale Id 2226',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 10:37:29','',''),(2616049,'1','202','1036',477,'Retail Sale Id 2227',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 10:39:27','',''),(2616050,'1','202','1036',477,'Retail Sale Id 2228',3001.28,0.00,0.00,4.52,3001.28,'2022-04-06 10:46:08','',''),(2616051,'1','202','1036',477,'Retail Sale Id 2229',8001.20,0.00,0.00,12.05,8001.20,'2022-04-06 11:02:47','',''),(2616052,'1','202','1036',477,'Retail Sale Id 2230',1401.04,0.00,0.00,2.11,1401.04,'2022-04-06 11:10:00','',''),(2616053,'1','202','1036',477,'Retail Sale Id 2231',2901.68,0.00,0.00,4.37,2901.68,'2022-04-06 11:14:09','',''),(2616054,'1','202','1036',477,'Retail Sale Id 2232',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 11:22:29','',''),(2616055,'1','202','1036',477,'Retail Sale Id 2233',10587.50,0.00,0.00,17.50,10587.50,'2022-04-06 12:01:35','',''),(2616056,'1','202','1036',477,'Retail Sale Id 2234',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 12:04:15','',''),(2616057,'1','202','1036',477,'Retail Sale Id 2235',25410.00,0.00,0.00,42.00,25410.00,'2022-04-06 12:09:34','',''),(2616058,'1','202','1036',477,'Retail Sale Id 2236',3001.28,0.00,0.00,4.52,3001.28,'2022-04-06 12:11:34','',''),(2616059,'1','202','1036',477,'Retail Sale Id 2237',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 12:12:49','',''),(2616060,'1','202','1036',477,'Retail Sale Id 2238',33275.00,0.00,0.00,55.00,33275.00,'2022-04-06 12:14:19','',''),(2616061,'1','202','1036',477,'Retail Sale Id 2239',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 12:26:30','',''),(2616062,'1','202','1036',477,'Retail Sale Id 2240',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 12:27:09','',''),(2616063,'1','202','1036',477,'Retail Sale Id 2241',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 12:32:43','',''),(2616064,'1','202','1036',477,'Retail Sale Id 2242',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 12:46:51','',''),(2616065,'1','202','1036',477,'Retail Sale Id 2243',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 12:47:49','',''),(2616066,'1','202','1036',477,'Retail Sale Id 2244',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 12:48:40','',''),(2616067,'1','202','1036',477,'Retail Sale Id 2245',18150.00,0.00,0.00,30.00,18150.00,'2022-04-06 12:51:27','',''),(2616068,'1','202','1036',477,'Retail Sale Id 2246',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 12:58:18','',''),(2616069,'1','202','1036',477,'Retail Sale Id 2247',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 13:00:01','',''),(2616070,'1','202','1036',477,'Retail Sale Id 2248',2702.48,0.00,0.00,4.07,2702.48,'2022-04-06 13:14:52','',''),(2616071,'1','202','1036',477,'Retail Sale Id 2249',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 13:40:07','',''),(2616072,'1','202','1036',477,'Retail Sale Id 2250',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 13:46:29','',''),(2616073,'1','202','1036',477,'Retail Sale Id 2251',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 13:51:11','',''),(2616074,'1','202','1036',477,'Retail Sale Id 2252',2197.84,0.00,0.00,3.31,2197.84,'2022-04-06 13:53:21','',''),(2616075,'1','202','1036',477,'Retail Sale Id 2253',46585.00,0.00,0.00,77.00,46585.00,'2022-04-06 13:57:42','',''),(2616076,'1','202','1036',477,'Retail Sale Id 2254',650.72,0.00,0.00,0.98,650.72,'2022-04-06 13:58:32','',''),(2616077,'1','202','1036',477,'Retail Sale Id 2255',3353.20,0.00,0.00,5.05,3353.20,'2022-04-06 13:59:53','',''),(2616078,'1','202','1036',477,'Retail Sale Id 2256',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 14:03:55','',''),(2616079,'1','202','1036',477,'Retail Sale Id 2257',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 14:05:06','',''),(2616080,'1','202','1036',477,'Retail Sale Id 2260',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 14:05:52','',''),(2616081,'1','202','1036',477,'Retail Sale Id 2261',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 14:12:02','',''),(2616082,'1','202','1036',477,'Retail Sale Id 2262',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 14:26:38','',''),(2616083,'1','202','1036',477,'Retail Sale Id 2263',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 14:37:21','',''),(2616084,'1','202','1036',477,'Retail Sale Id 2264',30250.00,0.00,0.00,50.00,30250.00,'2022-04-06 14:45:21','',''),(2616085,'1','202','1036',477,'Retail Sale Id 2265',1201.84,0.00,0.00,1.81,1201.84,'2022-04-06 14:46:21','',''),(2616086,'1','202','1036',477,'Retail Sale Id 2266',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 14:50:19','',''),(2616087,'1','202','1036',477,'Retail Sale Id 2267',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 14:52:03','',''),(2616088,'1','202','1036',477,'Retail Sale Id 2268',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 14:57:21','',''),(2616089,'1','202','1036',477,'Retail Sale Id 2269',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 15:15:06','',''),(2616090,'1','202','1036',477,'Retail Sale Id 2270',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 15:17:38','',''),(2616091,'1','202','1036',477,'Retail Sale Id 2271',3001.28,0.00,0.00,4.52,3001.28,'2022-04-06 15:24:34','',''),(2616092,'1','202','1036',477,'Retail Sale Id 2272',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 15:28:32','',''),(2616093,'1','202','1036',477,'Retail Sale Id 2273',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 15:45:48','',''),(2616094,'1','202','1036',477,'Retail Sale Id 2274',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 15:46:53','',''),(2616095,'1','202','1036',477,'Retail Sale Id 2275',8300.00,0.00,0.00,12.50,8300.00,'2022-04-06 15:52:12','',''),(2616096,'1','202','1036',477,'Retail Sale Id 2276',3353.20,0.00,0.00,5.05,3353.20,'2022-04-06 15:54:46','',''),(2616097,'1','202','1036',477,'Retail Sale Id 2277',6653.28,0.00,0.00,10.02,6653.28,'2022-04-06 15:56:15','',''),(2616098,'1','202','1036',477,'Retail Sale Id 2278',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 15:56:57','',''),(2616099,'1','202','1036',477,'Retail Sale Id 2279',2197.84,0.00,0.00,3.31,2197.84,'2022-04-06 15:58:48','',''),(2616100,'1','202','1036',477,'Retail Sale Id 2280',3997.28,0.00,0.00,6.02,3997.28,'2022-04-06 16:19:43','',''),(2616101,'1','202','1036',477,'Retail Sale Id 2281',1347.92,0.00,0.00,2.03,1347.92,'2022-04-06 16:22:22','',''),(2616102,'1','202','1036',477,'Retail Sale Id 2282',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 16:27:13','',''),(2616103,'1','202','1036',477,'Retail Sale Id 2283',650.72,0.00,0.00,0.98,650.72,'2022-04-06 16:29:21','',''),(2616104,'1','202','1036',477,'Retail Sale Id 2284',1002.64,0.00,0.00,1.51,1002.64,'2022-04-06 16:30:20','',''),(2616105,'1','202','1036',477,'Retail Sale Id 2286',1998.64,0.00,0.00,3.01,1998.64,'2022-04-06 16:31:08','',''),(2616106,'1','202','1036',477,'Retail Sale Id 2287',3025.00,0.00,0.00,5.00,3025.00,'2022-04-06 16:33:29','',''),(2616107,'1','202','1036',477,'Return of Retail Sale Id 2286',0.00,1998.64,3.01,0.00,-1998.64,'2022-04-06 16:52:06','',''),(2616108,'1','202','1036',477,'Return of Retail Sale Id 2284',0.00,1002.64,1.51,0.00,-1002.64,'2022-04-06 16:53:25','',''),(2616109,'1','202','1036',477,'Return of Retail Sale Id 2283',0.00,650.72,0.98,0.00,-650.72,'2022-04-06 16:54:47','',''),(2616110,'1','202','1036',477,'Return of Retail Sale Id 2287',0.00,3025.00,5.00,0.00,-3025.00,'2022-04-06 16:55:56','',''),(2616111,'1','202','1036',477,'Distributed to operational loss for sales id:2',0.00,0.00,0.00,66.42,0.00,'2022-04-06 17:09:37','',''),(2616112,'1','202',NULL,477,'Purchased from AA RANO NIGERIA LIMITED',0.00,1806000.00,3000.00,0.00,0.00,'2022-04-07 10:19:18','',''),(2616113,'1','202',NULL,477,'Reception corrector for bridging 3',0.00,0.00,0.00,3000.00,0.00,'2022-04-07 10:19:59','',''),(2616114,'1','202','1036',477,'Received from bridging 3',0.00,0.00,3000.00,0.00,0.00,'2022-04-07 10:19:59','',''),(2616115,'1','202','1036',477,'Retail Sale Id 2288',71390.00,0.00,0.00,118.00,354.00,'2022-04-07 10:23:05','',''),(2616116,'1','202','1036',477,'Retail Sale Id 2289',8300.00,0.00,0.00,12.50,775.00,'2022-04-07 10:29:36','',''),(2616117,'1','202','1036',477,'Retail Sale Id 2291',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 10:31:06','',''),(2616118,'1','202','1036',477,'Retail Sale Id 2293',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 10:31:58','',''),(2616119,'1','202','1036',477,'Retail Sale Id 2294',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 10:39:13','',''),(2616120,'1','202','1036',477,'Retail Sale Id 2295',3353.20,0.00,0.00,5.05,313.10,'2022-04-07 10:41:22','',''),(2616121,'1','202','1036',477,'Retail Sale Id 2296',33275.00,0.00,0.00,55.00,165.00,'2022-04-07 10:46:56','',''),(2616122,'1','202','1036',477,'Retail Sale Id 2297',1002.64,0.00,0.00,1.51,93.62,'2022-04-07 10:48:28','',''),(2616123,'1','202','1036',477,'Retail Sale Id 2298',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 10:51:48','',''),(2616124,'1','202','1036',477,'Retail Sale Id 2299',8300.00,0.00,0.00,12.50,775.00,'2022-04-07 10:58:44','',''),(2616125,'1','202','1036',477,'Retail Sale Id 2300',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 11:14:25','',''),(2616126,'1','202','1036',477,'Retail Sale Id 2301',697.20,0.00,0.00,1.05,65.10,'2022-04-07 11:25:04','',''),(2616127,'1','202','1036',477,'Retail Sale Id 2302',3200.48,0.00,0.00,4.82,298.84,'2022-04-07 11:33:23','',''),(2616128,'1','202','1036',477,'Retail Sale Id 2303',8300.00,0.00,0.00,12.50,775.00,'2022-04-07 11:36:01','',''),(2616129,'1','202','1036',477,'Retail Sale Id 2304',1500.64,0.00,0.00,2.26,140.12,'2022-04-07 11:37:04','',''),(2616130,'1','202','1036',477,'Retail Sale Id 2305',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 11:44:20','',''),(2616131,'1','202','1036',477,'Retail Sale Id 2306',1002.64,0.00,0.00,1.51,93.62,'2022-04-07 11:51:59','',''),(2616132,'1','202','1036',477,'Retail Sale Id 2307',1328.00,0.00,0.00,2.00,124.00,'2022-04-07 11:57:11','',''),(2616133,'1','202','1036',477,'Retail Sale Id 2308',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 12:05:53','',''),(2616134,'1','202','1036',477,'Retail Sale Id 2309',38720.00,0.00,0.00,64.00,192.00,'2022-04-07 12:06:57','',''),(2616135,'1','202','1036',477,'Retail Sale Id 2310',1002.64,0.00,0.00,1.51,93.62,'2022-04-07 12:50:31','',''),(2616136,'1','202','1036',477,'Retail Sale Id 2311',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 12:51:21','',''),(2616137,'1','202','1036',477,'Retail Sale Id 2312',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 13:02:30','',''),(2616138,'1','202','1036',477,'Retail Sale Id 2313',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 13:06:10','',''),(2616139,'1','202','1036',477,'Retail Sale Id 2314',44165.00,0.00,0.00,73.00,219.00,'2022-04-07 13:16:21','',''),(2616140,'1','202','1036',477,'Retail Sale Id 2315',6653.28,0.00,0.00,10.02,621.24,'2022-04-07 13:20:15','',''),(2616141,'1','202','1036',477,'Retail Sale Id 2316',5497.92,0.00,0.00,8.28,513.36,'2022-04-07 13:38:49','',''),(2616142,'1','202','1036',477,'Retail Sale Id 2317',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 13:45:59','',''),(2616143,'1','202','1036',477,'Retail Sale Id 2318',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 14:01:20','',''),(2616144,'1','202','1036',477,'Retail Sale Id 2319',30250.00,0.00,0.00,50.00,150.00,'2022-04-07 14:09:20','',''),(2616145,'1','202','1036',477,'Retail Sale Id 2320',3353.20,0.00,0.00,5.05,313.10,'2022-04-07 14:11:09','',''),(2616146,'1','202','1036',477,'Retail Sale Id 2321',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 14:15:18','',''),(2616147,'1','202','1036',477,'Retail Sale Id 2322',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 14:25:45','',''),(2616148,'1','202','1036',477,'Retail Sale Id 2323',7503.20,0.00,0.00,11.30,700.60,'2022-04-07 14:34:01','',''),(2616149,'1','202','1036',477,'Retail Sale Id 2324',1201.84,0.00,0.00,1.81,112.22,'2022-04-07 14:36:46','',''),(2616150,'1','202','1036',477,'Retail Sale Id 2325',4999.92,0.00,0.00,7.53,466.86,'2022-04-07 14:38:19','',''),(2616151,'1','202','1036',477,'Retail Sale Id 2326',66499.60,0.00,0.00,100.15,6209.30,'2022-04-07 14:41:46','',''),(2616152,'1','202','1036',477,'Retail Sale Id 2327',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 14:48:47','',''),(2616153,'1','202','1036',477,'Retail Sale Id 2328',6998.56,0.00,0.00,10.54,653.48,'2022-04-07 14:52:32','',''),(2616154,'1','202','1036',477,'Retail Sale Id 2329',3001.28,0.00,0.00,4.52,280.24,'2022-04-07 14:53:37','',''),(2616155,'1','202','1036',477,'Retail Sale Id 2330',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 14:54:53','',''),(2616156,'1','202','1036',477,'Retail Sale Id 2331',3200.48,0.00,0.00,4.82,298.84,'2022-04-07 15:03:14','',''),(2616157,'1','202','1036',477,'Retail Sale Id 2332',8300.00,0.00,0.00,12.50,775.00,'2022-04-07 15:05:56','',''),(2616158,'1','202','1036',477,'Retail Sale Id 2333',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 15:13:01','',''),(2616159,'1','202','1036',477,'Retail Sale Id 2334',36300.00,0.00,0.00,60.00,180.00,'2022-04-07 15:22:59','',''),(2616160,'1','202','1036',477,'Retail Sale Id 2335',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 15:36:21','',''),(2616161,'1','202','1036',477,'Retail Sale Id 2336',8300.00,0.00,0.00,12.50,775.00,'2022-04-07 15:48:41','',''),(2616162,'1','202','1036',477,'Retail Sale Id 2337',1401.04,0.00,0.00,2.11,130.82,'2022-04-07 15:50:02','',''),(2616163,'1','202','1036',477,'Retail Sale Id 2338',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 15:56:03','',''),(2616164,'1','202','1036',477,'Retail Sale Id 2339',202675.00,0.00,0.00,335.00,1005.00,'2022-04-07 16:07:56','',''),(2616165,'1','202','1036',477,'Retail Sale Id 2340',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 16:08:44','',''),(2616166,'1','202','1036',477,'Retail Sale Id 2341',3353.20,0.00,0.00,5.05,313.10,'2022-04-07 16:10:41','',''),(2616167,'1','202','1036',477,'Retail Sale Id 2342',1401.04,0.00,0.00,2.11,130.82,'2022-04-07 16:11:50','',''),(2616168,'1','202','1036',477,'Retail Sale Id 2343',6998.56,0.00,0.00,10.54,653.48,'2022-04-07 16:28:32','',''),(2616169,'1','202','1036',477,'Retail Sale Id 2344',498.00,0.00,0.00,0.75,46.50,'2022-04-07 16:30:00','',''),(2616170,'1','202','1036',477,'Retail Sale Id 2345',1002.64,0.00,0.00,1.51,93.62,'2022-04-07 16:51:04','',''),(2616171,'1','202','1036',477,'Retail Sale Id 2346',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 16:52:23','',''),(2616172,'1','202','1036',477,'Retail Sale Id 2347',15125.00,0.00,0.00,25.00,75.00,'2022-04-07 16:56:06','',''),(2616173,'1','202','1036',477,'Retail Sale Id 2348',1401.04,0.00,0.00,2.11,130.82,'2022-04-07 16:57:02','',''),(2616174,'1','202','1036',477,'Retail Sale Id 2349',8300.00,0.00,0.00,12.50,775.00,'2022-04-07 17:11:01','',''),(2616175,'1','202','1036',477,'Retail Sale Id 2350',1002.64,0.00,0.00,1.51,93.62,'2022-04-07 17:12:02','',''),(2616176,'1','202','1036',477,'Retail Sale Id 2351',30250.00,0.00,0.00,50.00,150.00,'2022-04-07 17:16:47','',''),(2616177,'1','202','1036',477,'Retail Sale Id 2352',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 17:31:03','',''),(2616178,'1','202',NULL,477,'Purchased from AA RANO NIGERIA LIMITED',0.00,1505000.00,2500.00,0.00,0.00,'2022-04-07 17:33:01','',''),(2616179,'1','202',NULL,477,'Reception corrector for bridging 4',0.00,0.00,0.00,2500.00,0.00,'2022-04-07 17:34:02','',''),(2616180,'1','202','1036',477,'Received from bridging 4',0.00,0.00,2500.00,0.00,0.00,'2022-04-07 17:34:02','',''),(2616181,'1','202','1036',477,'Retail Sale Id 2353',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 17:35:06','',''),(2616182,'1','202','1036',477,'Retail Sale Id 2355',1201.84,0.00,0.00,1.81,112.22,'2022-04-07 17:36:25','',''),(2616183,'1','202','1036',477,'Retail Sale Id 2356',1002.64,0.00,0.00,1.51,93.62,'2022-04-07 17:42:53','',''),(2616184,'1','202','1036',477,'Retail Sale Id 2357',3997.28,0.00,0.00,6.02,373.24,'2022-04-07 17:47:29','',''),(2616185,'1','202','1036',477,'Retail Sale Id 2358',3001.28,0.00,0.00,4.52,280.24,'2022-04-07 17:48:29','',''),(2616186,'1','202','1036',477,'Retail Sale Id 2359',3353.20,0.00,0.00,5.05,313.10,'2022-04-07 17:51:47','',''),(2616187,'1','202','1036',477,'Retail Sale Id 2362',2602.88,0.00,0.00,3.92,243.04,'2022-04-07 17:52:41','',''),(2616188,'1','202','1036',477,'Retail Sale Id 2363',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 17:54:55','',''),(2616189,'1','202','1036',477,'Retail Sale Id 2364',3353.20,0.00,0.00,5.05,313.10,'2022-04-07 17:59:32','',''),(2616190,'1','202','1036',477,'Retail Sale Id 2365',3001.28,0.00,0.00,4.52,280.24,'2022-04-07 18:04:19','',''),(2616191,'1','202','1036',477,'Retail Sale Id 2367',8300.00,0.00,0.00,12.50,775.00,'2022-04-07 18:07:11','',''),(2616192,'1','202','1036',477,'Retail Sale Id 2368',4999.92,0.00,0.00,7.53,466.86,'2022-04-07 18:12:40','',''),(2616193,'1','202','1036',477,'Retail Sale Id 2369',1998.64,0.00,0.00,3.01,186.62,'2022-04-07 18:13:51','',''),(2616194,'1','202','1036',477,'Retail Sale Id 2369',8300.00,0.00,0.00,12.50,775.00,'2022-04-07 18:13:51','',''),(2616195,'1','202','1036',477,'Retail Sale Id 2370',1513.92,0.00,0.00,2.28,141.36,'2022-04-07 19:25:11','',''),(2616196,'1','202','1036',477,'Retail Sale Id 2371',3499.28,0.00,0.00,5.27,326.74,'2022-04-08 09:15:41','',''),(2616197,'1','202','1036',477,'Retail Sale Id 2372',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 09:16:45','',''),(2616198,'1','202','1036',477,'Retail Sale Id 2373',3353.20,0.00,0.00,5.05,313.10,'2022-04-08 09:21:46','',''),(2616199,'1','202','1036',477,'Retail Sale Id 2374',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 09:22:28','',''),(2616200,'1','202','1036',477,'Retail Sale Id 2375',1002.64,0.00,0.00,1.51,93.62,'2022-04-08 09:27:05','',''),(2616201,'1','202','1036',477,'Retail Sale Id 2376',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 09:30:42','',''),(2616202,'1','202','1036',477,'Retail Sale Id 2377',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 09:36:49','',''),(2616203,'1','202','1036',477,'Retail Sale Id 2378',14217.50,0.00,0.00,23.50,70.50,'2022-04-08 09:42:14','',''),(2616204,'1','202','1036',477,'Retail Sale Id 2379',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 09:43:22','',''),(2616205,'1','202','1036',477,'Retail Sale Id 2380',3499.28,0.00,0.00,5.27,326.74,'2022-04-08 09:44:13','',''),(2616206,'1','202','1036',477,'Retail Sale Id 2381',3001.28,0.00,0.00,4.52,280.24,'2022-04-08 09:45:03','',''),(2616207,'1','202','1036',477,'Retail Sale Id 2382',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 09:45:37','',''),(2616208,'1','202','1036',477,'Retail Sale Id 2383',14520.00,0.00,0.00,24.00,72.00,'2022-04-08 09:46:40','',''),(2616209,'1','202','1036',477,'Retail Sale Id 2384',3001.28,0.00,0.00,4.52,280.24,'2022-04-08 09:51:01','',''),(2616210,'1','202','1036',477,'Retail Sale Id 2385',2503.28,0.00,0.00,3.77,233.74,'2022-04-08 09:55:06','',''),(2616211,'1','202','1036',477,'Retail Sale Id 2386',1301.44,0.00,0.00,1.96,121.52,'2022-04-08 10:02:31','',''),(2616212,'1','202','1036',477,'Retail Sale Id 2387',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 10:04:39','',''),(2616213,'1','202','1036',477,'Retail Sale Id 2388',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 10:05:26','',''),(2616214,'1','202','1036',477,'Retail Sale Id 2389',2702.48,0.00,0.00,4.07,252.34,'2022-04-08 10:06:16','',''),(2616215,'1','202','1036',477,'Retail Sale Id 2390',2702.48,0.00,0.00,4.07,252.34,'2022-04-08 10:12:33','',''),(2616216,'1','202','1036',477,'Retail Sale Id 2391',3353.20,0.00,0.00,5.05,313.10,'2022-04-08 10:32:07','',''),(2616217,'1','202','1036',477,'Retail Sale Id 2392',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 10:33:10','',''),(2616218,'1','202','1036',477,'Retail Sale Id 2393',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 10:34:10','',''),(2616219,'1','202','1036',477,'Retail Sale Id 2394',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 10:40:40','',''),(2616220,'1','202','1036',477,'Retail Sale Id 2395',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 10:44:06','',''),(2616221,'1','202','1036',477,'Retail Sale Id 2396',33275.00,0.00,0.00,55.00,165.00,'2022-04-08 11:00:20','',''),(2616222,'1','202','1036',477,'Retail Sale Id 2397',1201.84,0.00,0.00,1.81,112.22,'2022-04-08 11:01:33','',''),(2616223,'1','202','1036',477,'Retail Sale Id 2398',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 11:02:44','',''),(2616224,'1','202','1036',477,'Retail Sale Id 2399',3001.28,0.00,0.00,4.52,280.24,'2022-04-08 11:03:36','',''),(2616225,'1','202','1036',477,'Retail Sale Id 2400',1002.64,0.00,0.00,1.51,93.62,'2022-04-08 11:05:01','',''),(2616226,'1','202','1036',477,'Retail Sale Id 2402',3353.20,0.00,0.00,5.05,313.10,'2022-04-08 11:25:47','',''),(2616227,'1','202','1036',477,'Retail Sale Id 2402',3353.20,0.00,0.00,5.05,313.10,'2022-04-08 11:25:47','',''),(2616228,'1','202','1036',477,'Retail Sale Id 2403',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 11:29:32','',''),(2616229,'1','202','1036',477,'Retail Sale Id 2404',8001.20,0.00,0.00,12.05,747.10,'2022-04-08 11:32:08','',''),(2616230,'1','202','1036',477,'Retail Sale Id 2405',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 11:32:53','',''),(2616231,'1','202','1036',477,'Retail Sale Id 2406',6653.28,0.00,0.00,10.02,621.24,'2022-04-08 11:39:34','',''),(2616232,'1','202','1036',477,'Retail Sale Id 2407',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 11:47:13','',''),(2616233,'1','202','1036',477,'Retail Sale Id 2408',1002.64,0.00,0.00,1.51,93.62,'2022-04-08 11:56:42','',''),(2616234,'1','202','1036',477,'Retail Sale Id 2409',3001.28,0.00,0.00,4.52,280.24,'2022-04-08 12:01:06','',''),(2616235,'1','202','1036',477,'Retail Sale Id 2410',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 12:02:23','',''),(2616236,'1','202','1036',477,'Retail Sale Id 2411',1002.64,0.00,0.00,1.51,93.62,'2022-04-08 12:07:21','',''),(2616237,'1','202','1036',477,'Retail Sale Id 2412',2503.28,0.00,0.00,3.77,233.74,'2022-04-08 12:09:16','',''),(2616238,'1','202','1036',477,'Retail Sale Id 2413',3353.20,0.00,0.00,5.05,313.10,'2022-04-08 12:13:21','',''),(2616239,'1','202','1036',477,'Retail Sale Id 2414',26015.00,0.00,0.00,43.00,129.00,'2022-04-08 12:16:37','',''),(2616240,'1','202','1036',477,'Retail Sale Id 2415',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 12:29:59','',''),(2616241,'1','202','1036',477,'Retail Sale Id 2416',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 12:30:49','',''),(2616242,'1','202','1036',477,'Retail Sale Id 2417',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 12:32:21','',''),(2616243,'1','202','1036',477,'Retail Sale Id 2418',36300.00,0.00,0.00,60.00,180.00,'2022-04-08 12:40:21','',''),(2616244,'1','202','1036',477,'Retail Sale Id 2419',3499.28,0.00,0.00,5.27,326.74,'2022-04-08 12:41:42','',''),(2616245,'1','202','1036',477,'Retail Sale Id 2420',3001.28,0.00,0.00,4.52,280.24,'2022-04-08 12:46:39','',''),(2616246,'1','202','1036',477,'Retail Sale Id 2421',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 12:47:12','',''),(2616247,'1','202','1036',477,'Retail Sale Id 2422',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 12:47:41','',''),(2616248,'1','202','1036',477,'Retail Sale Id 2423',1401.04,0.00,0.00,2.11,130.82,'2022-04-08 12:48:14','',''),(2616249,'1','202','1036',477,'Retail Sale Id 2424',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 12:48:47','',''),(2616250,'1','202','1036',477,'Retail Sale Id 2425',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 12:49:57','',''),(2616251,'1','202','1036',477,'Retail Sale Id 2426',6002.56,0.00,0.00,9.04,560.48,'2022-04-08 12:52:40','',''),(2616252,'1','202','1036',477,'Retail Sale Id 2427',22396.72,0.00,0.00,33.73,2091.26,'2022-04-08 12:53:55','',''),(2616253,'1','202','1036',477,'Retail Sale Id 2428',17396.80,0.00,0.00,26.20,1624.40,'2022-04-08 12:55:16','',''),(2616254,'1','202','1036',477,'Retail Sale Id 2429',6799.36,0.00,0.00,10.24,634.88,'2022-04-08 12:56:59','',''),(2616255,'1','202','1036',477,'Retail Sale Id 2430',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 12:57:54','',''),(2616256,'1','202','1036',477,'Retail Sale Id 2431',1301.44,0.00,0.00,1.96,121.52,'2022-04-08 12:58:59','',''),(2616257,'1','202','1036',477,'Retail Sale Id 2432',7503.20,0.00,0.00,11.30,700.60,'2022-04-08 13:00:07','',''),(2616258,'1','202','1036',477,'Retail Sale Id 2433',14520.00,0.00,0.00,24.00,72.00,'2022-04-08 13:01:50','',''),(2616259,'1','202','1036',477,'Retail Sale Id 2434',3353.20,0.00,0.00,5.05,313.10,'2022-04-08 13:09:17','',''),(2616260,'1','202','1036',477,'Retail Sale Id 2435',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 13:10:49','',''),(2616261,'1','202','1036',477,'Retail Sale Id 2436',15125.00,0.00,0.00,25.00,75.00,'2022-04-08 13:31:13','',''),(2616262,'1','202','1036',477,'Retail Sale Id 2437',1401.04,0.00,0.00,2.11,130.82,'2022-04-08 13:33:32','',''),(2616263,'1','202','1036',477,'Retail Sale Id 2438',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 13:38:56','',''),(2616264,'1','202','1036',477,'Retail Sale Id 2439',29645.00,0.00,0.00,49.00,147.00,'2022-04-08 13:59:15','',''),(2616265,'1','202','1036',477,'Retail Sale Id 2440',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 14:07:30','',''),(2616266,'1','202','1036',477,'Retail Sale Id 2441',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 14:22:44','',''),(2616267,'1','202','1036',477,'Retail Sale Id 2443',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 14:24:30','',''),(2616268,'1','202','1036',477,'Retail Sale Id 2445',2503.28,0.00,0.00,3.77,233.74,'2022-04-08 14:27:20','',''),(2616269,'1','202','1036',477,'Retail Sale Id 2446',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 14:33:06','',''),(2616270,'1','202','1036',477,'Retail Sale Id 2447',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 14:34:56','',''),(2616271,'1','202','1036',477,'Retail Sale Id 2449',1347.92,0.00,0.00,2.03,125.86,'2022-04-08 14:39:43','',''),(2616272,'1','202','1036',477,'Retail Sale Id 2450',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 14:41:08','',''),(2616273,'1','202','1036',477,'Retail Sale Id 2452',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 14:41:58','',''),(2616274,'1','202','1036',477,'Retail Sale Id 2454',3001.28,0.00,0.00,4.52,280.24,'2022-04-08 14:42:54','',''),(2616275,'1','202','1036',477,'Retail Sale Id 2455',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 14:44:12','',''),(2616276,'1','202','1036',477,'Retail Sale Id 2456',36300.00,0.00,0.00,60.00,180.00,'2022-04-08 14:45:21','',''),(2616277,'1','202','1036',477,'Retail Sale Id 2457',3499.28,0.00,0.00,5.27,326.74,'2022-04-08 14:49:06','',''),(2616278,'1','202','1036',477,'Retail Sale Id 2458',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 14:56:14','',''),(2616279,'1','202','1036',477,'Retail Sale Id 2459',24200.00,0.00,0.00,40.00,120.00,'2022-04-08 14:58:36','',''),(2616280,'1','202','1036',477,'Retail Sale Id 2460',8470.00,0.00,0.00,14.00,42.00,'2022-04-08 15:00:23','',''),(2616281,'1','202','1036',477,'Retail Sale Id 2461',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 15:02:38','',''),(2616282,'1','202','1036',477,'Retail Sale Id 2462',30250.00,0.00,0.00,50.00,150.00,'2022-04-08 15:04:03','',''),(2616283,'1','202','1036',477,'Retail Sale Id 2463',3353.20,0.00,0.00,5.05,313.10,'2022-04-08 15:05:18','',''),(2616284,'1','202','1036',477,'Retail Sale Id 2464',3353.20,0.00,0.00,5.05,313.10,'2022-04-08 15:12:38','',''),(2616285,'1','202','1036',477,'Retail Sale Id 2466',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 15:13:50','',''),(2616286,'1','202','1036',477,'Retail Sale Id 2467',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 15:31:34','',''),(2616287,'1','202','1036',477,'Retail Sale Id 2468',6653.28,0.00,0.00,10.02,621.24,'2022-04-08 15:34:11','',''),(2616288,'1','202','1036',477,'Retail Sale Id 2469',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 15:38:48','',''),(2616289,'1','202','1036',477,'Retail Sale Id 2470',1401.04,0.00,0.00,2.11,130.82,'2022-04-08 15:42:16','',''),(2616290,'1','202','1036',477,'Retail Sale Id 2471',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 15:50:58','',''),(2616291,'1','202','1036',477,'Retail Sale Id 2472',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 15:54:28','',''),(2616292,'1','202','1036',477,'Retail Sale Id 2473',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 15:56:34','',''),(2616293,'1','202','1036',477,'Retail Sale Id 2475',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 15:57:12','',''),(2616294,'1','202','1036',477,'Retail Sale Id 2476',40535.00,0.00,0.00,67.00,201.00,'2022-04-08 15:58:14','',''),(2616295,'1','202','1036',477,'Retail Sale Id 2478',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 16:02:10','',''),(2616296,'1','202','1036',477,'Retail Sale Id 2479',2702.48,0.00,0.00,4.07,252.34,'2022-04-08 16:06:35','',''),(2616297,'1','202','1036',477,'Retail Sale Id 2481',3001.28,0.00,0.00,4.52,280.24,'2022-04-08 16:12:24','',''),(2616298,'1','202','1036',477,'Retail Sale Id 2482',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 16:13:47','',''),(2616299,'1','202','1036',477,'Retail Sale Id 2483',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 16:21:07','',''),(2616300,'1','202','1036',477,'Retail Sale Id 2485',2503.28,0.00,0.00,3.77,233.74,'2022-04-08 16:22:04','',''),(2616301,'1','202','1036',477,'Retail Sale Id 2487',4999.92,0.00,0.00,7.53,466.86,'2022-04-08 16:22:42','',''),(2616302,'1','202','1036',477,'Retail Sale Id 2489',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 16:23:45','',''),(2616303,'1','202','1036',477,'Retail Sale Id 2491',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 16:26:09','',''),(2616304,'1','202','1036',477,'Retail Sale Id 2492',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 16:29:23','',''),(2616305,'1','202','1036',477,'Retail Sale Id 2494',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 16:35:14','',''),(2616306,'1','202','1036',477,'Retail Sale Id 2495',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 16:37:40','',''),(2616307,'1','202','1036',477,'Retail Sale Id 2496',35695.00,0.00,0.00,59.00,177.00,'2022-04-08 16:40:39','',''),(2616308,'1','202','1036',477,'Retail Sale Id 2497',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 16:44:54','',''),(2616309,'1','202','1036',477,'Retail Sale Id 2498',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 16:45:59','',''),(2616310,'1','202','1036',477,'Retail Sale Id 2500',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 16:47:40','',''),(2616311,'1','202','1036',477,'Retail Sale Id 2501',14520.00,0.00,0.00,24.00,72.00,'2022-04-08 16:51:31','',''),(2616312,'1','202','1036',477,'Retail Sale Id 2503',5351.84,0.00,0.00,8.06,499.72,'2022-04-08 16:56:52','',''),(2616313,'1','202','1036',477,'Retail Sale Id 2504',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 16:57:42','',''),(2616314,'1','202','1036',477,'Retail Sale Id 2505',697.20,0.00,0.00,1.05,65.10,'2022-04-08 17:06:35','',''),(2616315,'1','202','1036',477,'Retail Sale Id 2506',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 17:08:42','',''),(2616316,'1','202','1036',477,'Retail Sale Id 2507',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 17:18:41','',''),(2616317,'1','202','1036',477,'Retail Sale Id 2508',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 17:27:08','',''),(2616318,'1','202','1036',477,'Retail Sale Id 2510',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 17:27:57','',''),(2616319,'1','202','1036',477,'Retail Sale Id 2512',1002.64,0.00,0.00,1.51,93.62,'2022-04-08 17:28:59','',''),(2616320,'1','202','1036',477,'Retail Sale Id 2513',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 17:29:36','',''),(2616321,'1','202','1036',477,'Retail Sale Id 2514',1347.92,0.00,0.00,2.03,125.86,'2022-04-08 17:30:31','',''),(2616322,'1','202','1036',477,'Retail Sale Id 2515',1002.64,0.00,0.00,1.51,93.62,'2022-04-08 17:39:12','',''),(2616323,'1','202','1036',477,'Retail Sale Id 2516',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 17:45:36','',''),(2616324,'1','202','1036',477,'Retail Sale Id 2518',3353.20,0.00,0.00,5.05,313.10,'2022-04-08 17:46:29','',''),(2616325,'1','202','1036',477,'Retail Sale Id 2519',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 18:00:00','',''),(2616326,'1','202','1036',477,'Retail Sale Id 2520',4302.72,0.00,0.00,6.48,401.76,'2022-04-08 18:11:20','',''),(2616327,'1','202','1036',477,'Retail Sale Id 2522',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 18:12:44','',''),(2616328,'1','202','1036',477,'Retail Sale Id 2524',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 18:18:40','',''),(2616329,'1','202','1036',477,'Retail Sale Id 2525',8300.00,0.00,0.00,12.50,775.00,'2022-04-08 18:26:18','',''),(2616330,'1','202','1036',477,'Retail Sale Id 2527',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 18:27:03','',''),(2616331,'1','202','1036',477,'Retail Sale Id 2528',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 18:32:14','',''),(2616332,'1','202','1036',477,'Retail Sale Id 2529',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 18:49:51','',''),(2616333,'1','202','1036',477,'Retail Sale Id 2531',8997.20,0.00,0.00,13.55,840.10,'2022-04-08 18:51:40','',''),(2616334,'1','202','1036',477,'Retail Sale Id 2532',3997.28,0.00,0.00,6.02,373.24,'2022-04-08 19:02:52','',''),(2616335,'1','202','1036',477,'Retail Sale Id 2533',697.20,0.00,0.00,1.05,65.10,'2022-04-08 19:03:37','',''),(2616336,'1','202','1036',477,'Retail Sale Id 2534',1500.64,0.00,0.00,2.26,140.12,'2022-04-08 19:04:31','',''),(2616337,'1','202','1036',477,'Retail Sale Id 2535',3001.28,0.00,0.00,4.52,280.24,'2022-04-08 19:05:32','',''),(2616338,'1','202','1036',477,'Retail Sale Id 2537',1998.64,0.00,0.00,3.01,186.62,'2022-04-08 19:07:54','',''),(2616339,'1','202','1036',477,'Retail Sale Id 2539',3001.28,0.00,0.00,4.52,280.24,'2022-04-08 19:08:39','',''),(2616340,'1','202','1036',477,'Retail Sale Id 2541',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 09:58:01','',''),(2616341,'1','202','1036',477,'Retail Sale Id 2542',56698.96,0.00,0.00,85.39,5294.18,'2022-04-09 10:01:54','',''),(2616342,'1','202','1036',477,'Retail Sale Id 2544',3353.20,0.00,0.00,5.05,313.10,'2022-04-09 10:03:17','',''),(2616343,'1','202','1036',477,'Retail Sale Id 2546',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 10:04:03','',''),(2616344,'1','202','1036',477,'Retail Sale Id 2547',34800.24,0.00,0.00,52.41,3249.42,'2022-04-09 10:06:08','',''),(2616345,'1','202','1036',477,'Retail Sale Id 2548',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 10:07:19','',''),(2616346,'1','202','1036',477,'Retail Sale Id 2549',43498.64,0.00,0.00,65.51,4061.62,'2022-04-09 10:08:57','',''),(2616347,'1','202','1036',477,'Retail Sale Id 2551',4999.92,0.00,0.00,7.53,466.86,'2022-04-09 10:09:43','',''),(2616348,'1','202','1036',477,'Retail Sale Id 2552',35225.20,0.00,0.00,53.05,3289.10,'2022-04-09 10:11:35','',''),(2616349,'1','202','1036',477,'Retail Sale Id 2553',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 10:13:17','',''),(2616350,'1','202','1036',477,'Retail Sale Id 2555',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 10:14:02','',''),(2616351,'1','202','1036',477,'Retail Sale Id 2557',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 10:16:14','',''),(2616352,'1','202','1036',477,'Retail Sale Id 2559',3001.28,0.00,0.00,4.52,280.24,'2022-04-09 10:20:00','',''),(2616353,'1','202','1036',477,'Retail Sale Id 2561',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 10:21:10','',''),(2616354,'1','202','1036',477,'Retail Sale Id 2562',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 10:32:36','',''),(2616355,'1','202','1036',477,'Retail Sale Id 2563',1401.04,0.00,0.00,2.11,130.82,'2022-04-09 10:38:00','',''),(2616356,'1','202','1036',477,'Retail Sale Id 2565',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 10:44:02','',''),(2616357,'1','202','1036',477,'Retail Sale Id 2566',697.20,0.00,0.00,1.05,65.10,'2022-04-09 10:45:16','',''),(2616358,'1','202','1036',477,'Retail Sale Id 2568',1500.64,0.00,0.00,2.26,140.12,'2022-04-09 10:46:11','',''),(2616359,'1','202','1036',477,'Retail Sale Id 2570',1500.64,0.00,0.00,2.26,140.12,'2022-04-09 10:46:46','',''),(2616360,'1','202','1036',477,'Retail Sale Id 2572',498.00,0.00,0.00,0.75,46.50,'2022-04-09 10:47:31','',''),(2616361,'1','202','1036',477,'Retail Sale Id 2573',3001.28,0.00,0.00,4.52,280.24,'2022-04-09 10:48:31','',''),(2616362,'1','202','1036',477,'Retail Sale Id 2575',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 10:49:09','',''),(2616363,'1','202','1036',477,'Retail Sale Id 2577',3001.28,0.00,0.00,4.52,280.24,'2022-04-09 10:49:58','',''),(2616364,'1','202','1036',477,'Retail Sale Id 2578',3001.28,0.00,0.00,4.52,280.24,'2022-04-09 10:50:38','',''),(2616365,'1','202','1036',477,'Retail Sale Id 2580',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 11:00:20','',''),(2616366,'1','202','1036',477,'Retail Sale Id 2582',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 11:01:50','',''),(2616367,'1','202','1036',477,'Retail Sale Id 2584',3499.28,0.00,0.00,5.27,326.74,'2022-04-09 11:04:49','',''),(2616368,'1','202','1036',477,'Retail Sale Id 2585',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 11:07:49','',''),(2616369,'1','202','1036',477,'Retail Sale Id 2587',3001.28,0.00,0.00,4.52,280.24,'2022-04-09 11:15:52','',''),(2616370,'1','202','1036',477,'Retail Sale Id 2588',2702.48,0.00,0.00,4.07,252.34,'2022-04-09 11:17:51','',''),(2616371,'1','202','1036',477,'Retail Sale Id 2590',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 11:19:35','',''),(2616372,'1','202','1036',477,'Retail Sale Id 2591',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 11:21:18','',''),(2616373,'1','202','1036',477,'Retail Sale Id 2593',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 11:21:55','',''),(2616374,'1','202','1036',477,'Retail Sale Id 2595',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 11:22:46','',''),(2616375,'1','202','1036',477,'Retail Sale Id 2596',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 11:26:18','',''),(2616376,'1','202','1036',477,'Retail Sale Id 2597',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 11:27:14','',''),(2616377,'1','202','1036',477,'Retail Sale Id 2599',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 11:35:53','',''),(2616378,'1','202','1036',477,'Retail Sale Id 2600',1347.92,0.00,0.00,2.03,125.86,'2022-04-09 11:40:01','',''),(2616379,'1','202','1036',477,'Retail Sale Id 2601',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 11:43:20','',''),(2616380,'1','202','1036',477,'Retail Sale Id 2602',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 11:44:32','',''),(2616381,'1','202','1036',477,'Retail Sale Id 2604',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 11:46:32','',''),(2616382,'1','202','1036',477,'Retail Sale Id 2605',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 11:50:25','',''),(2616383,'1','202','1036',477,'Retail Sale Id 2606',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 11:55:12','',''),(2616384,'1','202','1036',477,'Retail Sale Id 2607',1699.84,0.00,0.00,2.56,158.72,'2022-04-09 11:57:55','',''),(2616385,'1','202','1036',477,'Retail Sale Id 2608',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 12:04:33','',''),(2616386,'1','202','1036',477,'Retail Sale Id 2610',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 12:06:05','',''),(2616387,'1','202','1036',477,'Retail Sale Id 2611',3001.28,0.00,0.00,4.52,280.24,'2022-04-09 12:07:02','',''),(2616388,'1','202','1036',477,'Retail Sale Id 2613',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 12:11:53','',''),(2616389,'1','202','1036',477,'Retail Sale Id 2615',4999.92,0.00,0.00,7.53,466.86,'2022-04-09 12:12:38','',''),(2616390,'1','202','1036',477,'Retail Sale Id 2617',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 12:13:58','',''),(2616391,'1','202','1036',477,'Retail Sale Id 2618',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 12:14:31','',''),(2616392,'1','202','1036',477,'Retail Sale Id 2619',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 12:15:13','',''),(2616393,'1','202','1036',477,'Retail Sale Id 2622',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 12:16:49','',''),(2616394,'1','202','1036',477,'Retail Sale Id 2623',14601.36,0.00,0.00,21.99,1363.38,'2022-04-09 12:31:44','',''),(2616395,'1','202','1036',477,'Retail Sale Id 2625',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 12:35:39','',''),(2616396,'1','202','1036',477,'Retail Sale Id 2626',3353.20,0.00,0.00,5.05,313.10,'2022-04-09 12:40:56','',''),(2616397,'1','202','1036',477,'Retail Sale Id 2628',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 12:43:10','',''),(2616398,'1','202','1036',477,'Retail Sale Id 2629',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 12:47:22','',''),(2616399,'1','202','1036',477,'Retail Sale Id 2631',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 12:48:17','',''),(2616400,'1','202','1036',477,'Retail Sale Id 2633',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 12:49:23','',''),(2616401,'1','202','1036',477,'Retail Sale Id 2634',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 12:58:27','',''),(2616402,'1','202','1036',477,'Retail Sale Id 2635',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 13:02:58','',''),(2616403,'1','202','1036',477,'Retail Sale Id 2637',2702.48,0.00,0.00,4.07,252.34,'2022-04-09 13:08:38','',''),(2616404,'1','202','1036',477,'Retail Sale Id 2638',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 13:13:52','',''),(2616405,'1','202','1036',477,'Retail Sale Id 2640',3353.20,0.00,0.00,5.05,313.10,'2022-04-09 13:17:18','',''),(2616406,'1','202','1036',477,'Retail Sale Id 2642',597.60,0.00,0.00,0.90,55.80,'2022-04-09 13:25:37','',''),(2616407,'1','202','1036',477,'Retail Sale Id 2643',4150.00,0.00,0.00,6.25,387.50,'2022-04-09 13:28:51','',''),(2616408,'1','202','1036',477,'Retail Sale Id 2645',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 13:29:32','',''),(2616409,'1','202','1036',477,'Retail Sale Id 2646',3353.20,0.00,0.00,5.05,313.10,'2022-04-09 13:36:41','',''),(2616410,'1','202','1036',477,'Retail Sale Id 2647',6002.56,0.00,0.00,9.04,560.48,'2022-04-09 13:39:25','',''),(2616411,'1','202','1036',477,'Retail Sale Id 2648',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 13:41:34','',''),(2616412,'1','202','1036',477,'Retail Sale Id 2650',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 14:16:06','',''),(2616413,'1','202','1036',477,'Retail Sale Id 2651',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 14:21:27','',''),(2616414,'1','202','1036',477,'Retail Sale Id 2652',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 14:28:29','',''),(2616415,'1','202','1036',477,'Retail Sale Id 2653',1500.64,0.00,0.00,2.26,140.12,'2022-04-09 14:41:07','',''),(2616416,'1','202','1036',477,'Retail Sale Id 2654',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 14:47:58','',''),(2616417,'1','202','1036',477,'Retail Sale Id 2655',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 14:52:13','',''),(2616418,'1','202','1036',477,'Retail Sale Id 2656',903.04,0.00,0.00,1.36,84.32,'2022-04-09 14:53:29','',''),(2616419,'1','202','1036',477,'Retail Sale Id 2657',4999.92,0.00,0.00,7.53,466.86,'2022-04-09 15:09:18','',''),(2616420,'1','202','1036',477,'Retail Sale Id 2658',2503.28,0.00,0.00,3.77,233.74,'2022-04-09 15:10:00','',''),(2616421,'1','202','1036',477,'Retail Sale Id 2659',3001.28,0.00,0.00,4.52,280.24,'2022-04-09 15:10:44','',''),(2616422,'1','202','1036',477,'Retail Sale Id 2660',5497.92,0.00,0.00,8.28,513.36,'2022-04-09 15:12:06','',''),(2616423,'1','202','1036',477,'Retail Sale Id 2661',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 15:18:17','',''),(2616424,'1','202','1036',477,'Retail Sale Id 2662',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 15:18:57','',''),(2616425,'1','202','1036',477,'Retail Sale Id 2663',3353.20,0.00,0.00,5.05,313.10,'2022-04-09 15:21:14','',''),(2616426,'1','202','1036',477,'Retail Sale Id 2664',3353.20,0.00,0.00,5.05,313.10,'2022-04-09 15:22:19','',''),(2616427,'1','202','1036',477,'Retail Sale Id 2665',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 15:23:11','',''),(2616428,'1','202','1036',477,'Retail Sale Id 2666',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 15:25:27','',''),(2616429,'1','202','1036',477,'Retail Sale Id 2667',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 15:38:03','',''),(2616430,'1','202','1036',477,'Retail Sale Id 2668',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 15:56:40','',''),(2616431,'1','202','1036',477,'Retail Sale Id 2669',3499.28,0.00,0.00,5.27,326.74,'2022-04-09 15:58:36','',''),(2616432,'1','202','1036',477,'Retail Sale Id 2670',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 15:59:47','',''),(2616433,'1','202','1036',477,'Retail Sale Id 2671',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 16:01:51','',''),(2616434,'1','202','1036',477,'Retail Sale Id 2672',3001.28,0.00,0.00,4.52,280.24,'2022-04-09 16:03:02','',''),(2616435,'1','202','1036',477,'Retail Sale Id 2673',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 16:04:14','',''),(2616436,'1','202','1036',477,'Retail Sale Id 2674',2702.48,0.00,0.00,4.07,252.34,'2022-04-09 16:07:58','',''),(2616437,'1','202','1036',477,'Retail Sale Id 2675',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 16:09:05','',''),(2616438,'1','202','1036',477,'Retail Sale Id 2676',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 16:10:09','',''),(2616439,'1','202','1036',477,'Retail Sale Id 2677',1301.44,0.00,0.00,1.96,121.52,'2022-04-09 16:11:13','',''),(2616440,'1','202','1036',477,'Retail Sale Id 2678',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 16:14:24','',''),(2616441,'1','202','1036',477,'Retail Sale Id 2679',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 16:20:26','',''),(2616442,'1','202','1036',477,'Retail Sale Id 2680',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 16:21:22','',''),(2616443,'1','202','1036',477,'Retail Sale Id 2681',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 16:24:07','',''),(2616444,'1','202','1036',477,'Retail Sale Id 2682',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 16:24:48','',''),(2616445,'1','202','1036',477,'Retail Sale Id 2683',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 16:25:28','',''),(2616446,'1','202','1036',477,'Retail Sale Id 2684',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 16:26:59','',''),(2616447,'1','202','1036',477,'Retail Sale Id 2685',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 16:28:48','',''),(2616448,'1','202','1036',477,'Retail Sale Id 2686',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 16:38:24','',''),(2616449,'1','202','1036',477,'Retail Sale Id 2687',2702.48,0.00,0.00,4.07,252.34,'2022-04-09 16:39:37','',''),(2616450,'1','202','1036',477,'Retail Sale Id 2688',3300.08,0.00,0.00,4.97,308.14,'2022-04-09 16:41:07','',''),(2616451,'1','202','1036',477,'Retail Sale Id 2689',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 16:45:43','',''),(2616452,'1','202','1036',477,'Retail Sale Id 2690',1500.64,0.00,0.00,2.26,140.12,'2022-04-09 16:46:59','',''),(2616453,'1','202','1036',477,'Retail Sale Id 2691',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 16:49:10','',''),(2616454,'1','202','1036',477,'Retail Sale Id 2692',796.80,0.00,0.00,1.20,74.40,'2022-04-09 16:50:02','',''),(2616455,'1','202','1036',477,'Retail Sale Id 2693',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 16:50:56','',''),(2616456,'1','202','1036',477,'Retail Sale Id 2694',2503.28,0.00,0.00,3.77,233.74,'2022-04-09 16:53:27','',''),(2616457,'1','202','1036',477,'Retail Sale Id 2695',697.20,0.00,0.00,1.05,65.10,'2022-04-09 17:00:26','',''),(2616458,'1','202','1036',477,'Retail Sale Id 2696',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 17:02:00','',''),(2616459,'1','202','1036',477,'Retail Sale Id 2697',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 17:02:59','',''),(2616460,'1','202','1036',477,'Retail Sale Id 2698',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 17:05:20','',''),(2616461,'1','202','1036',477,'Retail Sale Id 2699',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 17:10:06','',''),(2616462,'1','202','1036',477,'Retail Sale Id 2700',4999.92,0.00,0.00,7.53,466.86,'2022-04-09 17:11:17','',''),(2616463,'1','202','1036',477,'Retail Sale Id 2701',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 17:11:53','',''),(2616464,'1','202','1036',477,'Retail Sale Id 2702',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 17:12:31','',''),(2616465,'1','202','1036',477,'Retail Sale Id 2703',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 17:15:01','',''),(2616466,'1','202','1036',477,'Retail Sale Id 2704',3353.20,0.00,0.00,5.05,313.10,'2022-04-09 17:21:28','',''),(2616467,'1','202','1036',477,'Retail Sale Id 2705',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 17:22:14','',''),(2616468,'1','202','1036',477,'Retail Sale Id 2706',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 17:32:13','',''),(2616469,'1','202','1036',477,'Retail Sale Id 2707',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 17:32:50','',''),(2616470,'1','202','1036',477,'Retail Sale Id 2708',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 17:36:16','',''),(2616471,'1','202','1036',477,'Retail Sale Id 2709',697.20,0.00,0.00,1.05,65.10,'2022-04-09 17:39:16','',''),(2616472,'1','202','1036',477,'Retail Sale Id 2710',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 17:41:41','',''),(2616473,'1','202','1036',477,'Retail Sale Id 2711',7503.20,0.00,0.00,11.30,700.60,'2022-04-09 17:43:20','',''),(2616474,'1','202','1036',477,'Retail Sale Id 2712',796.80,0.00,0.00,1.20,74.40,'2022-04-09 17:44:01','',''),(2616475,'1','202','1036',477,'Retail Sale Id 2713',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 17:51:51','',''),(2616476,'1','202','1036',477,'Retail Sale Id 2715',8001.20,0.00,0.00,12.05,747.10,'2022-04-09 17:56:14','',''),(2616477,'1','202','1036',477,'Retail Sale Id 2716',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 18:05:18','',''),(2616478,'1','202','1036',477,'Retail Sale Id 2717',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 18:06:18','',''),(2616479,'1','202','1036',477,'Retail Sale Id 2718',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 18:15:32','',''),(2616480,'1','202','1036',477,'Retail Sale Id 2719',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 18:16:30','',''),(2616481,'1','202','1036',477,'Retail Sale Id 2720',8300.00,0.00,0.00,12.50,775.00,'2022-04-09 18:25:06','',''),(2616482,'1','202','1036',477,'Retail Sale Id 2721',3001.28,0.00,0.00,4.52,280.24,'2022-04-09 18:25:47','',''),(2616483,'1','202','1036',477,'Retail Sale Id 2722',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 18:26:44','',''),(2616484,'1','202','1036',477,'Retail Sale Id 2723',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 18:29:51','',''),(2616485,'1','202','1036',477,'Retail Sale Id 2724',1002.64,0.00,0.00,1.51,93.62,'2022-04-09 18:31:43','',''),(2616486,'1','202','1036',477,'Retail Sale Id 2725',3001.28,0.00,0.00,4.52,280.24,'2022-04-09 18:39:57','',''),(2616487,'1','202','1036',477,'Retail Sale Id 2726',2702.48,0.00,0.00,4.07,252.34,'2022-04-09 18:50:29','',''),(2616488,'1','202','1036',477,'Retail Sale Id 2727',1401.04,0.00,0.00,2.11,130.82,'2022-04-09 18:52:47','',''),(2616489,'1','202','1036',477,'Retail Sale Id 2729',903.04,0.00,0.00,1.36,84.32,'2022-04-09 18:54:49','',''),(2616490,'1','202','1036',477,'Retail Sale Id 2730',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 19:02:12','',''),(2616491,'1','202','1036',477,'Retail Sale Id 2731',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 19:03:11','',''),(2616492,'1','202','1036',477,'Retail Sale Id 2732',3997.28,0.00,0.00,6.02,373.24,'2022-04-09 19:07:32','',''),(2616493,'1','202','1036',477,'Retail Sale Id 2733',1201.84,0.00,0.00,1.81,112.22,'2022-04-09 19:22:14','',''),(2616494,'1','202','1036',477,'Retail Sale Id 2734',1998.64,0.00,0.00,3.01,186.62,'2022-04-09 19:22:52','',''),(2616495,'1','202','1036',477,'Retail Sale Id 2735',2961.44,0.00,0.00,4.46,276.52,'2022-04-09 19:43:11','',''),(2616496,'1','202','1036',477,'Retail Sale Id 2736',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 06:48:57','',''),(2616497,'1','202','1036',477,'Retail Sale Id 2737',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 06:52:00','',''),(2616498,'1','202','1036',477,'Retail Sale Id 2738',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 07:05:24','',''),(2616499,'1','202','1036',477,'Retail Sale Id 2739',3499.28,0.00,0.00,5.27,326.74,'2022-04-10 07:17:42','',''),(2616500,'1','202','1036',477,'Retail Sale Id 2741',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 07:25:26','',''),(2616501,'1','202','1036',477,'Retail Sale Id 2742',1799.44,0.00,0.00,2.71,168.02,'2022-04-10 07:27:36','',''),(2616502,'1','202','1036',477,'Retail Sale Id 2743',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 07:34:40','',''),(2616503,'1','202','1036',477,'Retail Sale Id 2744',1401.04,0.00,0.00,2.11,130.82,'2022-04-10 07:42:29','',''),(2616504,'1','202','1036',477,'Retail Sale Id 2745',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 07:46:37','',''),(2616505,'1','202','1036',477,'Retail Sale Id 2746',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 07:48:21','',''),(2616506,'1','202','1036',477,'Retail Sale Id 2747',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 07:50:56','',''),(2616507,'1','202','1036',477,'Retail Sale Id 2748',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 07:51:56','',''),(2616508,'1','202','1036',477,'Retail Sale Id 2749',6640.00,0.00,0.00,10.00,620.00,'2022-04-10 07:55:21','',''),(2616509,'1','202','1036',477,'Retail Sale Id 2750',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 08:03:29','',''),(2616510,'1','202','1036',477,'Retail Sale Id 2751',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 08:09:11','',''),(2616511,'1','202','1036',477,'Retail Sale Id 2752',796.80,0.00,0.00,1.20,74.40,'2022-04-10 08:11:21','',''),(2616512,'1','202','1036',477,'Retail Sale Id 2753',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 08:16:47','',''),(2616513,'1','202','1036',477,'Retail Sale Id 2754',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 08:18:53','',''),(2616514,'1','202','1036',477,'Retail Sale Id 2755',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 08:29:12','',''),(2616515,'1','202','1036',477,'Retail Sale Id 2756',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 08:29:56','',''),(2616516,'1','202','1036',477,'Retail Sale Id 2757',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 08:35:00','',''),(2616517,'1','202','1036',477,'Retail Sale Id 2758',796.80,0.00,0.00,1.20,74.40,'2022-04-10 08:37:52','',''),(2616518,'1','202','1036',477,'Retail Sale Id 2759',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 08:38:45','',''),(2616519,'1','202','1036',477,'Retail Sale Id 2760',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 08:46:23','',''),(2616520,'1','202','1036',477,'Retail Sale Id 2761',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 08:48:52','',''),(2616521,'1','202','1036',477,'Retail Sale Id 2762',3353.20,0.00,0.00,5.05,313.10,'2022-04-10 08:53:54','',''),(2616522,'1','202','1036',477,'Retail Sale Id 2763',3353.20,0.00,0.00,5.05,313.10,'2022-04-10 09:10:30','',''),(2616523,'1','202','1036',477,'Retail Sale Id 2764',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 09:13:35','',''),(2616524,'1','202','1036',477,'Retail Sale Id 2765',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 09:18:25','',''),(2616525,'1','202','1036',477,'Retail Sale Id 2766',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 09:19:23','',''),(2616526,'1','202','1036',477,'Retail Sale Id 2767',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 09:20:04','',''),(2616527,'1','202','1036',477,'Retail Sale Id 2768',2702.48,0.00,0.00,4.07,252.34,'2022-04-10 09:24:16','',''),(2616528,'1','202','1036',477,'Retail Sale Id 2769',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 09:25:07','',''),(2616529,'1','202','1036',477,'Retail Sale Id 2770',4999.92,0.00,0.00,7.53,466.86,'2022-04-10 09:28:44','',''),(2616530,'1','202','1036',477,'Retail Sale Id 2771',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 09:30:34','',''),(2616531,'1','202','1036',477,'Retail Sale Id 2772',2503.28,0.00,0.00,3.77,233.74,'2022-04-10 09:34:48','',''),(2616532,'1','202','1036',477,'Retail Sale Id 2773',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 09:36:12','',''),(2616533,'1','202','1036',477,'Retail Sale Id 2774',6640.00,0.00,0.00,10.00,620.00,'2022-04-10 09:40:39','',''),(2616534,'1','202','1036',477,'Retail Sale Id 2775',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 09:44:48','',''),(2616535,'1','202','1036',477,'Retail Sale Id 2776',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 09:50:13','',''),(2616536,'1','202','1036',477,'Retail Sale Id 2777',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 09:51:58','',''),(2616537,'1','202','1036',477,'Retail Sale Id 2778',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 09:54:08','',''),(2616538,'1','202','1036',477,'Retail Sale Id 2779',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 09:54:55','',''),(2616539,'1','202','1036',477,'Retail Sale Id 2780',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 09:56:23','',''),(2616540,'1','202','1036',477,'Retail Sale Id 2781',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 10:00:20','',''),(2616541,'1','202','1036',477,'Retail Sale Id 2782',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 10:01:15','',''),(2616542,'1','202','1036',477,'Retail Sale Id 2783',3353.20,0.00,0.00,5.05,313.10,'2022-04-10 10:02:21','',''),(2616543,'1','202','1036',477,'Retail Sale Id 2784',2702.48,0.00,0.00,4.07,252.34,'2022-04-10 10:09:18','',''),(2616544,'1','202','1036',477,'Retail Sale Id 2785',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 10:09:56','',''),(2616545,'1','202','1036',477,'Retail Sale Id 2786',796.80,0.00,0.00,1.20,74.40,'2022-04-10 10:10:31','',''),(2616546,'1','202','1036',477,'Retail Sale Id 2787',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 10:11:14','',''),(2616547,'1','202','1036',477,'Retail Sale Id 2788',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 10:12:07','',''),(2616548,'1','202','1036',477,'Retail Sale Id 2789',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 10:12:44','',''),(2616549,'1','202','1036',477,'Retail Sale Id 2790',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 10:13:31','',''),(2616550,'1','202','1036',477,'Retail Sale Id 2791',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 10:22:55','',''),(2616551,'1','202','1036',477,'Retail Sale Id 2792',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 10:27:43','',''),(2616552,'1','202','1036',477,'Retail Sale Id 2793',6653.28,0.00,0.00,10.02,621.24,'2022-04-10 10:31:58','',''),(2616553,'1','202','1036',477,'Retail Sale Id 2794',3353.20,0.00,0.00,5.05,313.10,'2022-04-10 10:33:04','',''),(2616554,'1','202','1036',477,'Retail Sale Id 2795',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 10:33:55','',''),(2616555,'1','202','1036',477,'Retail Sale Id 2796',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 10:35:23','',''),(2616556,'1','202','1036',477,'Retail Sale Id 2797',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 10:36:22','',''),(2616557,'1','202','1036',477,'Retail Sale Id 2798',3353.20,0.00,0.00,5.05,313.10,'2022-04-10 10:37:05','',''),(2616558,'1','202','1036',477,'Retail Sale Id 2799',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 10:42:43','',''),(2616559,'1','202','1036',477,'Retail Sale Id 2800',12622.64,0.00,0.00,19.01,1178.62,'2022-04-10 10:44:45','',''),(2616560,'1','202','1036',477,'Retail Sale Id 2801',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 10:50:10','',''),(2616561,'1','202','1036',477,'Retail Sale Id 2802',4999.92,0.00,0.00,7.53,466.86,'2022-04-10 10:50:53','',''),(2616562,'1','202','1036',477,'Retail Sale Id 2803',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 10:51:38','',''),(2616563,'1','202','1036',477,'Retail Sale Id 2804',1401.04,0.00,0.00,2.11,130.82,'2022-04-10 10:52:50','',''),(2616564,'1','202','1036',477,'Retail Sale Id 2805',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 10:55:46','',''),(2616565,'1','202','1036',477,'Retail Sale Id 2806',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 11:00:58','',''),(2616566,'1','202','1036',477,'Retail Sale Id 2807',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 11:03:00','',''),(2616567,'1','202','1036',477,'Retail Sale Id 2808',903.04,0.00,0.00,1.36,84.32,'2022-04-10 11:03:45','',''),(2616568,'1','202','1036',477,'Retail Sale Id 2809',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 11:05:03','',''),(2616569,'1','202','1036',477,'Retail Sale Id 2810',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 11:09:57','',''),(2616570,'1','202','1036',477,'Retail Sale Id 2811',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 11:18:11','',''),(2616571,'1','202','1036',477,'Retail Sale Id 2812',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 11:23:17','',''),(2616572,'1','202','1036',477,'Retail Sale Id 2813',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 11:29:08','',''),(2616573,'1','202','1036',477,'Retail Sale Id 2814',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 11:29:57','',''),(2616574,'1','202','1036',477,'Retail Sale Id 2815',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 11:30:58','',''),(2616575,'1','202','1036',477,'Retail Sale Id 2816',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 11:36:22','',''),(2616576,'1','202','1036',477,'Retail Sale Id 2817',2702.48,0.00,0.00,4.07,252.34,'2022-04-10 11:36:56','',''),(2616577,'1','202','1036',477,'Retail Sale Id 2818',796.80,0.00,0.00,1.20,74.40,'2022-04-10 11:47:19','',''),(2616578,'1','202','1036',477,'Retail Sale Id 2820',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 11:48:25','',''),(2616579,'1','202','1036',477,'Retail Sale Id 2821',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 11:50:18','',''),(2616580,'1','202','1036',477,'Retail Sale Id 2822',4999.92,0.00,0.00,7.53,466.86,'2022-04-10 11:51:29','',''),(2616581,'1','202','1036',477,'Retail Sale Id 2823',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 11:52:02','',''),(2616582,'1','202','1036',477,'Retail Sale Id 2824',697.20,0.00,0.00,1.05,65.10,'2022-04-10 11:53:10','',''),(2616583,'1','202','1036',477,'Retail Sale Id 2825',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 11:53:51','',''),(2616584,'1','202','1036',477,'Retail Sale Id 2826',697.20,0.00,0.00,1.05,65.10,'2022-04-10 11:56:27','',''),(2616585,'1','202','1036',477,'Retail Sale Id 2827',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 12:00:00','',''),(2616586,'1','202','1036',477,'Retail Sale Id 2828',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 12:02:45','',''),(2616587,'1','202','1036',477,'Retail Sale Id 2829',3353.20,0.00,0.00,5.05,313.10,'2022-04-10 12:03:55','',''),(2616588,'1','202','1036',477,'Retail Sale Id 2830',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 12:08:13','',''),(2616589,'1','202','1036',477,'Retail Sale Id 2831',33498.80,0.00,0.00,50.45,3127.90,'2022-04-10 12:11:46','',''),(2616590,'1','202','1036',477,'Retail Sale Id 2832',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 12:14:43','',''),(2616591,'1','202','1036',477,'Retail Sale Id 2833',3353.20,0.00,0.00,5.05,313.10,'2022-04-10 12:16:24','',''),(2616592,'1','202','1036',477,'Retail Sale Id 2834',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 12:17:10','',''),(2616593,'1','202','1036',477,'Retail Sale Id 2835',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 12:18:25','',''),(2616594,'1','202','1036',477,'Retail Sale Id 2836',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 12:19:18','',''),(2616595,'1','202','1036',477,'Retail Sale Id 2837',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 12:19:52','',''),(2616596,'1','202','1036',477,'Return of Retail Sale Id 2831',0.00,33498.80,50.45,0.00,-3127.90,'2022-04-10 12:20:35','',''),(2616597,'1','202','1036',477,'Retail Sale Id 2839',1401.04,0.00,0.00,2.11,130.82,'2022-04-10 12:22:20','',''),(2616598,'1','202','1036',477,'Retail Sale Id 2840',3353.20,0.00,0.00,5.05,313.10,'2022-04-10 12:26:48','',''),(2616599,'1','202','1036',477,'Retail Sale Id 2841',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 12:27:22','',''),(2616600,'1','202','1036',477,'Retail Sale Id 2842',1401.04,0.00,0.00,2.11,130.82,'2022-04-10 12:28:15','',''),(2616601,'1','202','1036',477,'Retail Sale Id 2843',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 12:29:02','',''),(2616602,'1','202','1036',477,'Retail Sale Id 2844',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 12:29:46','',''),(2616603,'1','202','1036',477,'Retail Sale Id 2845',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 12:30:41','',''),(2616604,'1','202','1036',477,'Retail Sale Id 2846',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 12:33:55','',''),(2616605,'1','202','1036',477,'Retail Sale Id 2847',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 12:34:37','',''),(2616606,'1','202','1036',477,'Retail Sale Id 2848',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 12:47:41','',''),(2616607,'1','202','1036',477,'Retail Sale Id 2849',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 12:48:18','',''),(2616608,'1','202','1036',477,'Retail Sale Id 2850',697.20,0.00,0.00,1.05,65.10,'2022-04-10 12:49:04','',''),(2616609,'1','202','1036',477,'Retail Sale Id 2851',697.20,0.00,0.00,1.05,65.10,'2022-04-10 12:51:48','',''),(2616610,'1','202','1036',477,'Retail Sale Id 2852',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 12:52:31','',''),(2616611,'1','202','1036',477,'Retail Sale Id 2853',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 12:53:07','',''),(2616612,'1','202','1036',477,'Retail Sale Id 2854',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 12:53:58','',''),(2616613,'1','202','1036',477,'Retail Sale Id 2855',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 12:55:13','',''),(2616614,'1','202','1036',477,'Retail Sale Id 2856',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 12:58:42','',''),(2616615,'1','202','1036',477,'Retail Sale Id 2857',6653.28,0.00,0.00,10.02,621.24,'2022-04-10 13:00:18','',''),(2616616,'1','202','1036',477,'Retail Sale Id 2858',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 13:05:00','',''),(2616617,'1','202','1036',477,'Retail Sale Id 2859',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 13:05:41','',''),(2616618,'1','202','1036',477,'Retail Sale Id 2860',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 13:06:19','',''),(2616619,'1','202','1036',477,'Retail Sale Id 2861',498.00,0.00,0.00,0.75,46.50,'2022-04-10 13:08:50','',''),(2616620,'1','202','1036',477,'Retail Sale Id 2862',2656.00,0.00,0.00,4.00,248.00,'2022-04-10 13:18:59','',''),(2616621,'1','202','1036',477,'Retail Sale Id 2864',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 13:20:17','',''),(2616622,'1','202','1036',477,'Retail Sale Id 2865',4999.92,0.00,0.00,7.53,466.86,'2022-04-10 13:25:03','',''),(2616623,'1','202','1036',477,'Retail Sale Id 2867',498.00,0.00,0.00,0.75,46.50,'2022-04-10 13:26:02','',''),(2616624,'1','202','1036',477,'Retail Sale Id 2870',1799.44,0.00,0.00,2.71,168.02,'2022-04-10 13:27:53','',''),(2616625,'1','202','1036',477,'Retail Sale Id 2875',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 13:32:47','',''),(2616626,'1','202','1036',477,'Retail Sale Id 2876',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 13:34:04','',''),(2616627,'1','202','1036',477,'Retail Sale Id 2877',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 13:38:49','',''),(2616628,'1','202','1036',477,'Retail Sale Id 2878',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 13:40:10','',''),(2616629,'1','202','1036',477,'Retail Sale Id 2880',1799.44,0.00,0.00,2.71,168.02,'2022-04-10 13:41:17','',''),(2616630,'1','202','1036',477,'Retail Sale Id 2882',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 13:41:56','',''),(2616631,'1','202','1036',477,'Retail Sale Id 2883',3353.20,0.00,0.00,5.05,313.10,'2022-04-10 13:43:12','',''),(2616632,'1','202','1036',477,'Retail Sale Id 2884',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 13:47:19','',''),(2616633,'1','202','1036',477,'Retail Sale Id 2885',2503.28,0.00,0.00,3.77,233.74,'2022-04-10 13:53:32','',''),(2616634,'1','202','1036',477,'Retail Sale Id 2886',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 14:00:19','',''),(2616635,'1','202','1036',477,'Retail Sale Id 2888',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 14:04:03','',''),(2616636,'1','202','1036',477,'Retail Sale Id 2889',1347.92,0.00,0.00,2.03,125.86,'2022-04-10 14:06:48','',''),(2616637,'1','202','1036',477,'Retail Sale Id 2890',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 14:09:33','',''),(2616638,'1','202','1036',477,'Retail Sale Id 2891',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 14:12:12','',''),(2616639,'1','202','1036',477,'Retail Sale Id 2892',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 14:14:23','',''),(2616640,'1','202','1036',477,'Retail Sale Id 2893',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 14:15:08','',''),(2616641,'1','202','1036',477,'Retail Sale Id 2895',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 14:18:38','',''),(2616642,'1','202','1036',477,'Retail Sale Id 2897',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 14:21:26','',''),(2616643,'1','202','1036',477,'Retail Sale Id 2899',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 14:22:12','',''),(2616644,'1','202','1036',477,'Retail Sale Id 2900',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 14:24:16','',''),(2616645,'1','202','1036',477,'Retail Sale Id 2901',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 14:25:02','',''),(2616646,'1','202','1036',477,'Retail Sale Id 2903',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 14:33:41','',''),(2616647,'1','202','1036',477,'Retail Sale Id 2904',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 14:40:13','',''),(2616648,'1','202','1036',477,'Retail Sale Id 2905',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 14:41:39','',''),(2616649,'1','202','1036',477,'Retail Sale Id 2907',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 14:48:21','',''),(2616650,'1','202','1036',477,'Retail Sale Id 2908',4999.92,0.00,0.00,7.53,466.86,'2022-04-10 14:49:57','',''),(2616651,'1','202','1036',477,'Retail Sale Id 2910',4999.92,0.00,0.00,7.53,466.86,'2022-04-10 14:52:38','',''),(2616652,'1','202','1036',477,'Retail Sale Id 2912',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 14:53:24','',''),(2616653,'1','202','1036',477,'Retail Sale Id 2914',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 14:58:25','',''),(2616654,'1','202','1036',477,'Retail Sale Id 2915',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 15:00:58','',''),(2616655,'1','202','1036',477,'Retail Sale Id 2916',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 15:02:12','',''),(2616656,'1','202','1036',477,'Retail Sale Id 2917',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 15:03:14','',''),(2616657,'1','202','1036',477,'Retail Sale Id 2919',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 15:03:53','',''),(2616658,'1','202','1036',477,'Retail Sale Id 2921',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 15:08:56','',''),(2616659,'1','202','1036',477,'Retail Sale Id 2922',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 15:17:09','',''),(2616660,'1','202','1036',477,'Retail Sale Id 2923',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 15:19:59','',''),(2616661,'1','202','1036',477,'Retail Sale Id 2924',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 15:22:13','',''),(2616662,'1','202','1036',477,'Retail Sale Id 2925',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 15:25:45','',''),(2616663,'1','202','1036',477,'Retail Sale Id 2926',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 15:27:18','',''),(2616664,'1','202','1036',477,'Retail Sale Id 2927',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 15:31:22','',''),(2616665,'1','202','1036',477,'Retail Sale Id 2928',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 15:36:49','',''),(2616666,'1','202','1036',477,'Retail Sale Id 2929',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 15:44:04','',''),(2616667,'1','202','1036',477,'Retail Sale Id 2930',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 15:52:48','',''),(2616668,'1','202','1036',477,'Retail Sale Id 2931',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 15:53:43','',''),(2616669,'1','202','1036',477,'Retail Sale Id 2932',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 16:04:49','',''),(2616670,'1','202','1036',477,'Retail Sale Id 2933',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 16:10:42','',''),(2616671,'1','202','1036',477,'Retail Sale Id 2935',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 16:11:59','',''),(2616672,'1','202','1036',477,'Retail Sale Id 2937',1301.44,0.00,0.00,1.96,121.52,'2022-04-10 16:13:38','',''),(2616673,'1','202','1036',477,'Retail Sale Id 2939',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 16:14:30','',''),(2616674,'1','202','1036',477,'Retail Sale Id 2941',1699.84,0.00,0.00,2.56,158.72,'2022-04-10 16:17:24','',''),(2616675,'1','202','1036',477,'Retail Sale Id 2943',6653.28,0.00,0.00,10.02,621.24,'2022-04-10 16:22:47','',''),(2616676,'1','202','1036',477,'Retail Sale Id 2945',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 16:23:51','',''),(2616677,'1','202','1036',477,'Retail Sale Id 2947',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 16:24:37','',''),(2616678,'1','202','1036',477,'Retail Sale Id 2948',2702.48,0.00,0.00,4.07,252.34,'2022-04-10 16:50:29','',''),(2616679,'1','202','1036',477,'Retail Sale Id 2949',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 16:54:16','',''),(2616680,'1','202','1036',477,'Retail Sale Id 2950',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 16:55:31','',''),(2616681,'1','202','1036',477,'Retail Sale Id 2951',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 16:59:20','',''),(2616682,'1','202','1036',477,'Retail Sale Id 2952',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 17:02:30','',''),(2616683,'1','202','1036',477,'Retail Sale Id 2953',2702.48,0.00,0.00,4.07,252.34,'2022-04-10 17:05:08','',''),(2616684,'1','202','1036',477,'Retail Sale Id 2955',2297.44,0.00,0.00,3.46,214.52,'2022-04-10 17:06:32','',''),(2616685,'1','202','1036',477,'Retail Sale Id 2957',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 17:14:04','',''),(2616686,'1','202','1036',477,'Retail Sale Id 2959',1301.44,0.00,0.00,1.96,121.52,'2022-04-10 17:16:10','',''),(2616687,'1','202','1036',477,'Retail Sale Id 2961',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 17:16:57','',''),(2616688,'1','202','1036',477,'Retail Sale Id 2963',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 17:22:12','',''),(2616689,'1','202','1036',477,'Retail Sale Id 2964',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 17:31:56','',''),(2616690,'1','202','1036',477,'Retail Sale Id 2966',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 17:33:16','',''),(2616691,'1','202','1036',477,'Retail Sale Id 2968',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 17:34:01','',''),(2616692,'1','202','1036',477,'Retail Sale Id 2969',3997.28,0.00,0.00,6.02,373.24,'2022-04-10 17:43:34','',''),(2616693,'1','202','1036',477,'Retail Sale Id 2970',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 17:44:37','',''),(2616694,'1','202','1036',477,'Retail Sale Id 2972',1002.64,0.00,0.00,1.51,93.62,'2022-04-10 17:45:30','',''),(2616695,'1','202','1036',477,'Retail Sale Id 2974',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 17:46:18','',''),(2616696,'1','202','1036',477,'Retail Sale Id 2975',3001.28,0.00,0.00,4.52,280.24,'2022-04-10 18:00:51','',''),(2616697,'1','202','1036',477,'Retail Sale Id 2976',1500.64,0.00,0.00,2.26,140.12,'2022-04-10 18:03:46','',''),(2616698,'1','202','1036',477,'Retail Sale Id 2977',2702.48,0.00,0.00,4.07,252.34,'2022-04-10 18:13:53','',''),(2616699,'1','202','1036',477,'Retail Sale Id 2978',1998.64,0.00,0.00,3.01,186.62,'2022-04-10 18:15:13','',''),(2616700,'1','202','1036',477,'Retail Sale Id 2979',1699.84,0.00,0.00,2.56,158.72,'2022-04-10 18:21:53','',''),(2616701,'1','202','1036',477,'Retail Sale Id 2980',8300.00,0.00,0.00,12.50,775.00,'2022-04-10 19:03:56','',''),(2616702,'1','202','1036',477,'Retail Sale Id 2981',2297.44,0.00,0.00,3.46,214.52,'2022-04-10 19:06:09','',''),(2616703,'1','202','1036',477,'Retail Sale Id 2982',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 07:01:59','',''),(2616704,'1','202','1036',477,'Retail Sale Id 2983',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 07:14:22','',''),(2616705,'1','202','1036',477,'Retail Sale Id 2984',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 07:27:08','',''),(2616706,'1','202','1036',477,'Retail Sale Id 2985',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 07:53:08','',''),(2616707,'1','202','1036',477,'Retail Sale Id 2986',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 07:56:05','',''),(2616708,'1','202','1036',477,'Retail Sale Id 2988',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 07:57:37','',''),(2616709,'1','202','1036',477,'Retail Sale Id 2990',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 07:58:31','',''),(2616710,'1','202','1036',477,'Retail Sale Id 2991',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 07:59:20','',''),(2616711,'1','202','1036',477,'Retail Sale Id 2992',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 08:03:23','',''),(2616712,'1','202','1036',477,'Retail Sale Id 2993',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 08:05:21','',''),(2616713,'1','202','1036',477,'Retail Sale Id 2995',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 08:08:02','',''),(2616714,'1','202','1036',477,'Retail Sale Id 2997',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 08:09:05','',''),(2616715,'1','202','1036',477,'Retail Sale Id 2998',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 08:10:19','',''),(2616716,'1','202','1036',477,'Retail Sale Id 3000',1500.64,0.00,0.00,2.26,140.12,'2022-04-11 08:11:29','',''),(2616717,'1','202','1036',477,'Retail Sale Id 3001',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 08:12:17','',''),(2616718,'1','202','1036',477,'Retail Sale Id 3004',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 08:12:57','',''),(2616719,'1','202','1036',477,'Retail Sale Id 3005',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 08:14:19','',''),(2616720,'1','202','1036',477,'Retail Sale Id 3006',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 08:15:10','',''),(2616721,'1','202','1036',477,'Retail Sale Id 3009',1301.44,0.00,0.00,1.96,121.52,'2022-04-11 08:19:17','',''),(2616722,'1','202','1036',477,'Retail Sale Id 3011',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 08:20:42','',''),(2616723,'1','202','1036',477,'Retail Sale Id 3012',1500.64,0.00,0.00,2.26,140.12,'2022-04-11 08:23:02','',''),(2616724,'1','202','1036',477,'Retail Sale Id 3013',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 08:23:57','',''),(2616725,'1','202','1036',477,'Retail Sale Id 3015',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 08:28:47','',''),(2616726,'1','202','1036',477,'Retail Sale Id 3017',1500.64,0.00,0.00,2.26,140.12,'2022-04-11 08:29:52','',''),(2616727,'1','202','1036',477,'Retail Sale Id 3018',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 08:30:42','',''),(2616728,'1','202','1036',477,'Retail Sale Id 3020',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 08:32:11','',''),(2616729,'1','202','1036',477,'Retail Sale Id 3022',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 08:35:43','',''),(2616730,'1','202','1036',477,'Retail Sale Id 3024',3001.28,0.00,0.00,4.52,280.24,'2022-04-11 08:36:27','',''),(2616731,'1','202','1036',477,'Retail Sale Id 3025',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 08:38:01','',''),(2616732,'1','202','1036',477,'Retail Sale Id 3027',3200.48,0.00,0.00,4.82,298.84,'2022-04-11 08:39:29','',''),(2616733,'1','202','1036',477,'Retail Sale Id 3028',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 08:43:02','',''),(2616734,'1','202','1036',477,'Retail Sale Id 3030',3353.20,0.00,0.00,5.05,313.10,'2022-04-11 08:50:36','',''),(2616735,'1','202','1036',477,'Retail Sale Id 3031',1401.04,0.00,0.00,2.11,130.82,'2022-04-11 08:54:01','',''),(2616736,'1','202','1036',477,'Retail Sale Id 3032',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 08:55:24','',''),(2616737,'1','202','1036',477,'Retail Sale Id 3034',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 08:58:23','',''),(2616738,'1','202','1036',477,'Retail Sale Id 3036',3001.28,0.00,0.00,4.52,280.24,'2022-04-11 09:00:03','',''),(2616739,'1','202','1036',477,'Retail Sale Id 3038',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 09:01:19','',''),(2616740,'1','202','1036',477,'Retail Sale Id 3039',498.00,0.00,0.00,0.75,46.50,'2022-04-11 09:01:59','',''),(2616741,'1','202','1036',477,'Retail Sale Id 3040',2802.08,0.00,0.00,4.22,261.64,'2022-04-11 09:02:56','',''),(2616742,'1','202','1036',477,'Retail Sale Id 3041',597.60,0.00,0.00,0.90,55.80,'2022-04-11 09:04:05','',''),(2616743,'1','202','1036',477,'Retail Sale Id 3043',498.00,0.00,0.00,0.75,46.50,'2022-04-11 09:05:51','',''),(2616744,'1','202','1036',477,'Retail Sale Id 3044',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 09:07:03','',''),(2616745,'1','202','1036',477,'Retail Sale Id 3045',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 09:07:47','',''),(2616746,'1','202','1036',477,'Retail Sale Id 3046',597.60,0.00,0.00,0.90,55.80,'2022-04-11 09:09:04','',''),(2616747,'1','202','1036',477,'Retail Sale Id 3048',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 09:10:11','',''),(2616748,'1','202','1036',477,'Retail Sale Id 3050',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 09:15:09','',''),(2616749,'1','202','1036',477,'Retail Sale Id 3051',1401.04,0.00,0.00,2.11,130.82,'2022-04-11 09:17:46','',''),(2616750,'1','202','1036',477,'Retail Sale Id 3053',2503.28,0.00,0.00,3.77,233.74,'2022-04-11 09:18:43','',''),(2616751,'1','202','1036',477,'Retail Sale Id 3054',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 09:19:35','',''),(2616752,'1','202','1036',477,'Retail Sale Id 3055',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 09:24:26','',''),(2616753,'1','202','1036',477,'Retail Sale Id 3057',1500.64,0.00,0.00,2.26,140.12,'2022-04-11 09:25:20','',''),(2616754,'1','202','1036',477,'Retail Sale Id 3058',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 09:27:02','',''),(2616755,'1','202','1036',477,'Retail Sale Id 3059',3001.28,0.00,0.00,4.52,280.24,'2022-04-11 09:36:15','',''),(2616756,'1','202','1036',477,'Retail Sale Id 3060',1500.64,0.00,0.00,2.26,140.12,'2022-04-11 09:40:02','',''),(2616757,'1','202','1036',477,'Retail Sale Id 3061',3001.28,0.00,0.00,4.52,280.24,'2022-04-11 09:41:14','',''),(2616758,'1','202','1036',477,'Retail Sale Id 3063',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 09:42:14','',''),(2616759,'1','202','1036',477,'Retail Sale Id 3065',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 09:44:14','',''),(2616760,'1','202','1036',477,'Retail Sale Id 3066',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 09:47:32','',''),(2616761,'1','202','1036',477,'Retail Sale Id 3068',1799.44,0.00,0.00,2.71,168.02,'2022-04-11 09:48:10','',''),(2616762,'1','202','1036',477,'Retail Sale Id 3069',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 09:57:03','',''),(2616763,'1','202','1036',477,'Retail Sale Id 3070',697.20,0.00,0.00,1.05,65.10,'2022-04-11 10:04:11','',''),(2616764,'1','202','1036',477,'Retail Sale Id 3071',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 10:06:16','',''),(2616765,'1','202','1036',477,'Retail Sale Id 3072',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 10:15:47','',''),(2616766,'1','202','1036',477,'Retail Sale Id 3073',1500.64,0.00,0.00,2.26,140.12,'2022-04-11 10:16:54','',''),(2616767,'1','202','1036',477,'Retail Sale Id 3074',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 10:24:28','',''),(2616768,'1','202','1036',477,'Retail Sale Id 3075',3353.20,0.00,0.00,5.05,313.10,'2022-04-11 10:40:51','',''),(2616769,'1','202','1036',477,'Retail Sale Id 3076',3001.28,0.00,0.00,4.52,280.24,'2022-04-11 10:47:07','',''),(2616770,'1','202','1036',477,'Retail Sale Id 3078',3353.20,0.00,0.00,5.05,313.10,'2022-04-11 10:47:45','',''),(2616771,'1','202','1036',477,'Retail Sale Id 3079',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 10:51:03','',''),(2616772,'1','202','1036',477,'Retail Sale Id 3081',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 10:55:37','',''),(2616773,'1','202','1036',477,'Retail Sale Id 3082',2702.48,0.00,0.00,4.07,252.34,'2022-04-11 11:00:08','',''),(2616774,'1','202','1036',477,'Retail Sale Id 3083',1500.64,0.00,0.00,2.26,140.12,'2022-04-11 11:01:33','',''),(2616775,'1','202','1036',477,'Retail Sale Id 3084',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 11:06:58','',''),(2616776,'1','202','1036',477,'Retail Sale Id 3085',2197.84,0.00,0.00,3.31,205.22,'2022-04-11 11:15:29','',''),(2616777,'1','202','1036',477,'Retail Sale Id 3086',2702.48,0.00,0.00,4.07,252.34,'2022-04-11 11:16:48','',''),(2616778,'1','202','1036',477,'Retail Sale Id 3087',3353.20,0.00,0.00,5.05,313.10,'2022-04-11 11:17:58','',''),(2616779,'1','202','1036',477,'Retail Sale Id 3088',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 11:18:53','',''),(2616780,'1','202','1036',477,'Retail Sale Id 3089',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 11:20:54','',''),(2616781,'1','202','1036',477,'Retail Sale Id 3090',5976.00,0.00,0.00,9.00,558.00,'2022-04-11 11:27:19','',''),(2616782,'1','202','1036',477,'Retail Sale Id 3091',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 11:28:04','',''),(2616783,'1','202','1036',477,'Retail Sale Id 3092',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 11:29:21','',''),(2616784,'1','202','1036',477,'Retail Sale Id 3093',3353.20,0.00,0.00,5.05,313.10,'2022-04-11 11:44:48','',''),(2616785,'1','202','1036',477,'Retail Sale Id 3095',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 11:50:16','',''),(2616786,'1','202','1036',477,'Retail Sale Id 3097',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 11:53:12','',''),(2616787,'1','202','1036',477,'Retail Sale Id 3098',2503.28,0.00,0.00,3.77,233.74,'2022-04-11 11:58:43','',''),(2616788,'1','202','1036',477,'Retail Sale Id 3100',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 12:03:12','',''),(2616789,'1','202','1036',477,'Retail Sale Id 3101',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 12:04:51','',''),(2616790,'1','202','1036',477,'Retail Sale Id 3102',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 12:05:34','',''),(2616791,'1','202','1036',477,'Retail Sale Id 3104',2702.48,0.00,0.00,4.07,252.34,'2022-04-11 12:08:18','',''),(2616792,'1','202','1036',477,'Retail Sale Id 3105',1347.92,0.00,0.00,2.03,125.86,'2022-04-11 12:10:13','',''),(2616793,'1','202','1036',477,'Retail Sale Id 3107',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 12:13:14','',''),(2616794,'1','202','1036',477,'Retail Sale Id 3108',4999.92,0.00,0.00,7.53,466.86,'2022-04-11 12:17:41','',''),(2616795,'1','202','1036',477,'Retail Sale Id 3109',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 12:31:00','',''),(2616796,'1','202','1036',477,'Retail Sale Id 3110',1899.04,0.00,0.00,2.86,177.32,'2022-04-11 12:34:29','',''),(2616797,'1','202','1036',477,'Retail Sale Id 3112',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 12:48:27','',''),(2616798,'1','202','1036',477,'Retail Sale Id 3113',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 12:51:09','',''),(2616799,'1','202','1036',477,'Retail Sale Id 3115',1401.04,0.00,0.00,2.11,130.82,'2022-04-11 12:55:00','',''),(2616800,'1','202','1036',477,'Retail Sale Id 3116',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 13:07:17','',''),(2616801,'1','202','1036',477,'Retail Sale Id 3117',3001.28,0.00,0.00,4.52,280.24,'2022-04-11 13:11:06','',''),(2616802,'1','202','1036',477,'Retail Sale Id 3118',1500.64,0.00,0.00,2.26,140.12,'2022-04-11 13:11:58','',''),(2616803,'1','202','1036',477,'Retail Sale Id 3119',2702.48,0.00,0.00,4.07,252.34,'2022-04-11 13:21:11','',''),(2616804,'1','202','1036',477,'Retail Sale Id 3120',2702.48,0.00,0.00,4.07,252.34,'2022-04-11 13:36:23','',''),(2616805,'1','202','1036',477,'Retail Sale Id 3121',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 13:40:05','',''),(2616806,'1','202','1036',477,'Retail Sale Id 3123',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 13:40:50','',''),(2616807,'1','202','1036',477,'Retail Sale Id 3124',5099.52,0.00,0.00,7.68,476.16,'2022-04-11 13:42:15','',''),(2616808,'1','202','1036',477,'Retail Sale Id 3125',3300.08,0.00,0.00,4.97,308.14,'2022-04-11 13:44:24','',''),(2616809,'1','202','1036',477,'Retail Sale Id 3126',2702.48,0.00,0.00,4.07,252.34,'2022-04-11 13:45:43','',''),(2616810,'1','202','1036',477,'Retail Sale Id 3128',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 13:46:22','',''),(2616811,'1','202','1036',477,'Retail Sale Id 3129',2503.28,0.00,0.00,3.77,233.74,'2022-04-11 14:00:14','',''),(2616812,'1','202','1036',477,'Retail Sale Id 3131',1401.04,0.00,0.00,2.11,130.82,'2022-04-11 14:01:02','',''),(2616813,'1','202','1036',477,'Retail Sale Id 3132',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 14:05:46','',''),(2616814,'1','202','1036',477,'Retail Sale Id 3134',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 14:06:31','',''),(2616815,'1','202','1036',477,'Retail Sale Id 3135',3499.28,0.00,0.00,5.27,326.74,'2022-04-11 14:16:05','',''),(2616816,'1','202','1036',477,'Retail Sale Id 3136',1952.16,0.00,0.00,2.94,182.28,'2022-04-11 14:19:01','',''),(2616817,'1','202','1036',477,'Retail Sale Id 3138',3353.20,0.00,0.00,5.05,313.10,'2022-04-11 14:20:41','',''),(2616818,'1','202','1036',477,'Retail Sale Id 3139',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 14:24:23','',''),(2616819,'1','202','1036',477,'Retail Sale Id 3141',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 14:25:25','',''),(2616820,'1','202','1036',477,'Retail Sale Id 3143',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 14:31:54','',''),(2616821,'1','202','1036',477,'Retail Sale Id 3144',3353.20,0.00,0.00,5.05,313.10,'2022-04-11 14:33:46','',''),(2616822,'1','202','1036',477,'Retail Sale Id 3146',3001.28,0.00,0.00,4.52,280.24,'2022-04-11 14:34:59','',''),(2616823,'1','202','1036',477,'Retail Sale Id 3148',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 14:46:58','',''),(2616824,'1','202','1036',477,'Retail Sale Id 3150',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 14:54:23','',''),(2616825,'1','202','1036',477,'Retail Sale Id 3152',697.20,0.00,0.00,1.05,65.10,'2022-04-11 15:06:50','',''),(2616826,'1','202','1036',477,'Retail Sale Id 3153',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 15:08:10','',''),(2616827,'1','202','1036',477,'Retail Sale Id 3154',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 15:14:00','',''),(2616828,'1','202','1036',477,'Retail Sale Id 3155',4999.92,0.00,0.00,7.53,466.86,'2022-04-11 15:22:16','',''),(2616829,'1','202','1036',477,'Retail Sale Id 3156',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 15:25:16','',''),(2616830,'1','202','1036',477,'Retail Sale Id 3157',3399.68,0.00,0.00,5.12,317.44,'2022-04-11 15:39:29','',''),(2616831,'1','202','1036',477,'Retail Sale Id 3159',3001.28,0.00,0.00,4.52,280.24,'2022-04-11 15:43:24','',''),(2616832,'1','202','1036',477,'Retail Sale Id 3160',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 15:47:50','',''),(2616833,'1','202','1036',477,'Retail Sale Id 3161',2503.28,0.00,0.00,3.77,233.74,'2022-04-11 15:51:15','',''),(2616834,'1','202','1036',477,'Retail Sale Id 3162',1002.64,0.00,0.00,1.51,93.62,'2022-04-11 15:51:54','',''),(2616835,'1','202','1036',477,'Retail Sale Id 3163',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 15:53:23','',''),(2616836,'1','202','1036',477,'Retail Sale Id 3164',1301.44,0.00,0.00,1.96,121.52,'2022-04-11 15:55:36','',''),(2616837,'1','202','1036',477,'Retail Sale Id 3165',697.20,0.00,0.00,1.05,65.10,'2022-04-11 15:59:10','',''),(2616838,'1','202','1036',477,'Retail Sale Id 3166',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 16:02:25','',''),(2616839,'1','202','1036',477,'Retail Sale Id 3167',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 16:08:12','',''),(2616840,'1','202','1036',477,'Retail Sale Id 3168',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 16:11:16','',''),(2616841,'1','202','1036',477,'Retail Sale Id 3169',3997.28,0.00,0.00,6.02,373.24,'2022-04-11 16:15:11','',''),(2616842,'1','202','1036',477,'Retail Sale Id 3170',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 16:16:34','',''),(2616843,'1','202','1036',477,'Retail Sale Id 3171',1500.64,0.00,0.00,2.26,140.12,'2022-04-11 16:17:29','',''),(2616844,'1','202','1036',477,'Retail Sale Id 3172',1500.64,0.00,0.00,2.26,140.12,'2022-04-11 16:22:39','',''),(2616845,'1','202','1036',477,'Retail Sale Id 3173',1998.64,0.00,0.00,3.01,186.62,'2022-04-11 16:33:13','',''),(2616846,'1','202','1036',477,'Retail Sale Id 3174',697.20,0.00,0.00,1.05,65.10,'2022-04-11 16:45:59','',''),(2616847,'1','202','1036',477,'Retail Sale Id 3175',3001.28,0.00,0.00,4.52,280.24,'2022-04-11 16:53:57','',''),(2616848,'1','202','1036',477,'Retail Sale Id 3176',1347.92,0.00,0.00,2.03,125.86,'2022-04-11 16:56:26','',''),(2616849,'1','202','1036',477,'Retail Sale Id 3177',3353.20,0.00,0.00,5.05,313.10,'2022-04-11 17:01:23','',''),(2616850,'1','202','1036',477,'Retail Sale Id 3179',8300.00,0.00,0.00,12.50,775.00,'2022-04-11 17:03:39','',''),(2616851,'1','202','1036',477,'Retail Sale Id 3180',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 07:19:13','',''),(2616852,'1','202','1036',477,'Retail Sale Id 3181',8300.00,0.00,0.00,12.50,775.00,'2022-04-12 07:28:41','',''),(2616853,'1','202','1036',477,'Retail Sale Id 3182',1201.84,0.00,0.00,1.81,112.22,'2022-04-12 07:32:31','',''),(2616854,'1','202','1036',477,'Retail Sale Id 3183',8300.00,0.00,0.00,12.50,775.00,'2022-04-12 07:40:52','',''),(2616855,'1','202','1036',477,'Retail Sale Id 3184',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 07:42:12','',''),(2616856,'1','202','1036',477,'Retail Sale Id 3185',8300.00,0.00,0.00,12.50,775.00,'2022-04-12 07:44:22','',''),(2616857,'1','202','1036',477,'Retail Sale Id 3186',1002.64,0.00,0.00,1.51,93.62,'2022-04-12 07:45:26','',''),(2616858,'1','202','1036',477,'Retail Sale Id 3187',796.80,0.00,0.00,1.20,74.40,'2022-04-12 07:50:25','',''),(2616859,'1','202','1036',477,'Retail Sale Id 3188',1002.64,0.00,0.00,1.51,93.62,'2022-04-12 07:52:10','',''),(2616860,'1','202','1036',477,'Return of Retail Sale Id 3185',0.00,8300.00,12.50,0.00,-775.00,'2022-04-12 07:59:40','',''),(2616861,'1','202','1036',477,'Retail Sale Id 3189',8100.80,0.00,0.00,12.20,756.40,'2022-04-12 08:00:28','',''),(2616862,'1','202','1036',477,'Retail Sale Id 3190',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 08:02:21','',''),(2616863,'1','202','1036',477,'Retail Sale Id 3191',1500.64,0.00,0.00,2.26,140.12,'2022-04-12 08:14:21','',''),(2616864,'1','202','1036',477,'Retail Sale Id 3193',3001.28,0.00,0.00,4.52,280.24,'2022-04-12 08:30:25','',''),(2616865,'1','202','1036',477,'Retail Sale Id 3194',8300.00,0.00,0.00,12.50,775.00,'2022-04-12 08:39:01','',''),(2616866,'1','202','1036',477,'Retail Sale Id 3195',3353.20,0.00,0.00,5.05,313.10,'2022-04-12 08:41:27','',''),(2616867,'1','202','1036',477,'Retail Sale Id 3196',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 08:43:18','',''),(2616868,'1','202','1036',477,'Retail Sale Id 3197',1002.64,0.00,0.00,1.51,93.62,'2022-04-12 08:46:01','',''),(2616869,'1','202','1036',477,'Retail Sale Id 3198',8300.00,0.00,0.00,12.50,775.00,'2022-04-12 08:58:25','',''),(2616870,'1','202','1036',477,'Retail Sale Id 3199',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 08:59:57','',''),(2616871,'1','202','1036',477,'Retail Sale Id 3200',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 09:02:09','',''),(2616872,'1','202','1036',477,'Retail Sale Id 3201',1301.44,0.00,0.00,1.96,121.52,'2022-04-12 09:02:52','',''),(2616873,'1','202','1036',477,'Retail Sale Id 3202',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 09:13:17','',''),(2616874,'1','202','1036',477,'Retail Sale Id 3203',1201.84,0.00,0.00,1.81,112.22,'2022-04-12 09:16:11','',''),(2616875,'1','202','1036',477,'Retail Sale Id 3204',1500.64,0.00,0.00,2.26,140.12,'2022-04-12 09:16:52','',''),(2616876,'1','202','1036',477,'Retail Sale Id 3205',1500.64,0.00,0.00,2.26,140.12,'2022-04-12 09:18:08','',''),(2616877,'1','202','1036',477,'Retail Sale Id 3206',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 09:22:47','',''),(2616878,'1','202','1036',477,'Retail Sale Id 3207',697.20,0.00,0.00,1.05,65.10,'2022-04-12 09:23:34','',''),(2616879,'1','202','1036',477,'Retail Sale Id 3208',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 09:24:17','',''),(2616880,'1','202','1036',477,'Retail Sale Id 3209',1002.64,0.00,0.00,1.51,93.62,'2022-04-12 09:28:08','',''),(2616881,'1','202','1036',477,'Retail Sale Id 3210',2051.76,0.00,0.00,3.09,191.58,'2022-04-12 09:43:21','',''),(2616882,'1','202','1036',477,'Distributed to operational loss for sales id:3',6007.96,0.00,0.00,9.98,0.00,'2022-04-12 10:37:45','',''),(2616883,'1','202',NULL,477,'Purchased from AA RANO NIGERIA LIMITED',0.00,1806000.00,3000.00,0.00,0.00,'2022-04-12 16:23:00','',''),(2616884,'1','202',NULL,477,'Reception corrector for bridging 5',0.00,0.00,0.00,3000.00,0.00,'2022-04-12 16:24:06','',''),(2616885,'1','202','1036',477,'Received from bridging 5',0.00,0.00,3000.00,0.00,0.00,'2022-04-12 16:24:06','',''),(2616886,'1','202','1036',477,'Retail Sale Id 3212',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 16:24:42','',''),(2616887,'1','202','1036',477,'Retail Sale Id 3214',1500.64,0.00,0.00,2.26,140.12,'2022-04-12 16:26:03','',''),(2616888,'1','202','1036',477,'Retail Sale Id 3215',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 16:30:00','',''),(2616889,'1','202','1036',477,'Retail Sale Id 3217',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 16:33:12','',''),(2616890,'1','202','1036',477,'Retail Sale Id 3221',1002.64,0.00,0.00,1.51,93.62,'2022-04-12 16:36:21','',''),(2616891,'1','202','1036',477,'Retail Sale Id 3222',1347.92,0.00,0.00,2.03,125.86,'2022-04-12 16:41:32','',''),(2616892,'1','202','1036',477,'Retail Sale Id 3223',8001.20,0.00,0.00,12.05,747.10,'2022-04-12 16:49:57','',''),(2616893,'1','202','1036',477,'Retail Sale Id 3224',3353.20,0.00,0.00,5.05,313.10,'2022-04-12 16:52:49','',''),(2616894,'1','202','1036',477,'Retail Sale Id 3225',2197.84,0.00,0.00,3.31,205.22,'2022-04-12 16:55:17','',''),(2616895,'1','202','1036',477,'Retail Sale Id 3227',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 16:56:02','',''),(2616896,'1','202','1036',477,'Retail Sale Id 3228',3353.20,0.00,0.00,5.05,313.10,'2022-04-12 17:02:09','',''),(2616897,'1','202','1036',477,'Retail Sale Id 3229',8300.00,0.00,0.00,12.50,775.00,'2022-04-12 17:03:14','',''),(2616898,'1','202','1036',477,'Retail Sale Id 3230',1500.64,0.00,0.00,2.26,140.12,'2022-04-12 17:04:06','',''),(2616899,'1','202','1036',477,'Retail Sale Id 3231',4701.12,0.00,0.00,7.08,438.96,'2022-04-12 17:05:05','',''),(2616900,'1','202','1036',477,'Retail Sale Id 3232',1002.64,0.00,0.00,1.51,93.62,'2022-04-12 17:06:10','',''),(2616901,'1','202','1036',477,'Retail Sale Id 3234',597.60,0.00,0.00,0.90,55.80,'2022-04-12 17:06:56','',''),(2616902,'1','202','1036',477,'Retail Sale Id 3235',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 17:14:34','',''),(2616903,'1','202','1036',477,'Retail Sale Id 3238',8001.20,0.00,0.00,12.05,747.10,'2022-04-12 17:15:38','',''),(2616904,'1','202','1036',477,'Retail Sale Id 3239',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 17:23:03','',''),(2616905,'1','202','1036',477,'Retail Sale Id 3240',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 17:29:02','',''),(2616906,'1','202','1036',477,'Retail Sale Id 3241',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 17:43:54','',''),(2616907,'1','202','1036',477,'Retail Sale Id 3244',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 17:44:43','',''),(2616908,'1','202','1036',477,'Retail Sale Id 3246',1002.64,0.00,0.00,1.51,93.62,'2022-04-12 17:45:30','',''),(2616909,'1','202','1036',477,'Retail Sale Id 3247',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 17:46:20','',''),(2616910,'1','202','1036',477,'Retail Sale Id 3248',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 17:47:12','',''),(2616911,'1','202','1036',477,'Retail Sale Id 3250',8300.00,0.00,0.00,12.50,775.00,'2022-04-12 17:54:45','',''),(2616912,'1','202','1036',477,'Retail Sale Id 3251',8300.00,0.00,0.00,12.50,775.00,'2022-04-12 18:02:41','',''),(2616913,'1','202','1036',477,'Retail Sale Id 3252',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 18:04:00','',''),(2616914,'1','202','1036',477,'Retail Sale Id 3253',3997.28,0.00,0.00,6.02,373.24,'2022-04-12 18:09:42','',''),(2616915,'1','202','1036',477,'Retail Sale Id 3254',2702.48,0.00,0.00,4.07,252.34,'2022-04-12 18:18:54','',''),(2616916,'1','202','1036',477,'Retail Sale Id 3256',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 18:20:18','',''),(2616917,'1','202','1036',477,'Retail Sale Id 3257',2503.28,0.00,0.00,3.77,233.74,'2022-04-12 18:28:40','',''),(2616918,'1','202','1036',477,'Retail Sale Id 3258',8300.00,0.00,0.00,12.50,775.00,'2022-04-12 18:29:36','',''),(2616919,'1','202','1036',477,'Retail Sale Id 3259',1500.64,0.00,0.00,2.26,140.12,'2022-04-12 18:31:33','',''),(2616920,'1','202','1036',477,'Retail Sale Id 3260',1998.64,0.00,0.00,3.01,186.62,'2022-04-12 18:42:46','',''),(2616921,'1','202','1036',477,'Retail Sale Id 3262',498.00,0.00,0.00,0.75,46.50,'2022-04-12 18:43:30','',''),(2616922,'1','202','1036',477,'Retail Sale Id 3263',1002.64,0.00,0.00,1.51,93.62,'2022-04-12 19:02:54','',''),(2616923,'1','202','1036',477,'Retail Sale Id 3264',8300.00,0.00,0.00,12.50,775.00,'2022-04-13 06:47:54','',''),(2616924,'1','202','1036',477,'Retail Sale Id 3265',4999.92,0.00,0.00,7.53,466.86,'2022-04-13 06:59:34','',''),(2616925,'1','202','1036',477,'Retail Sale Id 3266',8300.00,0.00,0.00,12.50,775.00,'2022-04-13 07:07:13','',''),(2616926,'1','202','1036',477,'Retail Sale Id 3267',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 07:13:19','',''),(2616927,'1','202','1036',477,'Retail Sale Id 3268',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 07:25:58','',''),(2616928,'1','202','1036',477,'Retail Sale Id 3269',1347.92,0.00,0.00,2.03,125.86,'2022-04-13 07:29:32','',''),(2616929,'1','202','1036',477,'Retail Sale Id 3270',6653.28,0.00,0.00,10.02,621.24,'2022-04-13 07:38:39','',''),(2616930,'1','202','1036',477,'Retail Sale Id 3271',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 07:42:36','',''),(2616931,'1','202','1036',477,'Retail Sale Id 3272',5351.84,0.00,0.00,8.06,499.72,'2022-04-13 07:49:39','',''),(2616932,'1','202','1036',477,'Retail Sale Id 3273',10298.64,0.00,0.00,15.51,961.62,'2022-04-13 07:51:10','',''),(2616933,'1','202','1036',477,'Retail Sale Id 3274',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 07:52:26','',''),(2616934,'1','202','1036',477,'Retail Sale Id 3275',8300.00,0.00,0.00,12.50,775.00,'2022-04-13 07:56:50','',''),(2616935,'1','202','1036',477,'Retail Sale Id 3276',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 08:00:13','',''),(2616936,'1','202','1036',477,'Retail Sale Id 3277',8300.00,0.00,0.00,12.50,775.00,'2022-04-13 08:17:59','',''),(2616937,'1','202','1036',477,'Retail Sale Id 3278',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 08:25:14','',''),(2616938,'1','202','1036',477,'Retail Sale Id 3279',1500.64,0.00,0.00,2.26,140.12,'2022-04-13 08:26:13','',''),(2616939,'1','202','1036',477,'Retail Sale Id 3280',2702.48,0.00,0.00,4.07,252.34,'2022-04-13 08:29:42','',''),(2616940,'1','202','1036',477,'Retail Sale Id 3282',3001.28,0.00,0.00,4.52,280.24,'2022-04-13 08:31:00','',''),(2616941,'1','202','1036',477,'Retail Sale Id 3283',1347.92,0.00,0.00,2.03,125.86,'2022-04-13 08:38:56','',''),(2616942,'1','202','1036',477,'Retail Sale Id 3284',1002.64,0.00,0.00,1.51,93.62,'2022-04-13 08:40:57','',''),(2616943,'1','202','1036',477,'Retail Sale Id 3285',5298.72,0.00,0.00,7.98,494.76,'2022-04-13 08:55:28','',''),(2616944,'1','202','1036',477,'Retail Sale Id 3286',1002.64,0.00,0.00,1.51,93.62,'2022-04-13 09:06:55','',''),(2616945,'1','202','1036',477,'Retail Sale Id 3288',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 09:16:00','',''),(2616946,'1','202','1036',477,'Retail Sale Id 3289',2098.24,0.00,0.00,3.16,195.92,'2022-04-13 09:17:05','',''),(2616947,'1','202','1036',477,'Retail Sale Id 3291',3353.20,0.00,0.00,5.05,313.10,'2022-04-13 09:22:35','',''),(2616948,'1','202','1036',477,'Retail Sale Id 3293',3499.28,0.00,0.00,5.27,326.74,'2022-04-13 09:23:27','',''),(2616949,'1','202','1036',477,'Retail Sale Id 3295',1002.64,0.00,0.00,1.51,93.62,'2022-04-13 09:24:17','',''),(2616950,'1','202','1036',477,'Retail Sale Id 3296',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 09:25:08','',''),(2616951,'1','202','1036',477,'Retail Sale Id 3297',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 09:42:37','',''),(2616952,'1','202','1036',477,'Retail Sale Id 3298',1347.92,0.00,0.00,2.03,125.86,'2022-04-13 09:45:50','',''),(2616953,'1','202','1036',477,'Retail Sale Id 3299',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 09:47:13','',''),(2616954,'1','202','1036',477,'Retail Sale Id 3300',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 09:50:32','',''),(2616955,'1','202','1036',477,'Retail Sale Id 3301',1347.92,0.00,0.00,2.03,125.86,'2022-04-13 09:55:49','',''),(2616956,'1','202','1036',477,'Retail Sale Id 3303',1002.64,0.00,0.00,1.51,93.62,'2022-04-13 09:57:00','',''),(2616957,'1','202','1036',477,'Retail Sale Id 3304',12297.28,0.00,0.00,18.52,1148.24,'2022-04-13 10:04:06','',''),(2616958,'1','202','1036',477,'Retail Sale Id 3305',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 10:18:43','',''),(2616959,'1','202','1036',477,'Retail Sale Id 3306',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 10:19:47','',''),(2616960,'1','202','1036',477,'Retail Sale Id 3308',6998.56,0.00,0.00,10.54,653.48,'2022-04-13 10:21:52','',''),(2616961,'1','202','1036',477,'Retail Sale Id 3310',2702.48,0.00,0.00,4.07,252.34,'2022-04-13 10:23:22','',''),(2616962,'1','202','1036',477,'Retail Sale Id 3311',1002.64,0.00,0.00,1.51,93.62,'2022-04-13 10:24:29','',''),(2616963,'1','202','1036',477,'Retail Sale Id 3312',1500.64,0.00,0.00,2.26,140.12,'2022-04-13 10:32:02','',''),(2616964,'1','202','1036',477,'Retail Sale Id 3313',6002.56,0.00,0.00,9.04,560.48,'2022-04-13 10:33:38','',''),(2616965,'1','202','1036',477,'Retail Sale Id 3315',4999.92,0.00,0.00,7.53,466.86,'2022-04-13 10:34:30','',''),(2616966,'1','202','1036',477,'Retail Sale Id 3316',1699.84,0.00,0.00,2.56,158.72,'2022-04-13 10:39:17','',''),(2616967,'1','202','1036',477,'Retail Sale Id 3317',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 10:41:35','',''),(2616968,'1','202',NULL,477,'Purchased from AA RANO NIGERIA LIMITED',0.00,1396640.00,2320.00,0.00,0.00,'2022-04-13 10:44:33','',''),(2616969,'1','202',NULL,477,'Reception corrector for bridging 6',0.00,0.00,0.00,2320.00,0.00,'2022-04-13 10:46:21','',''),(2616970,'1','202','1036',477,'Received from bridging 6',0.00,0.00,2320.00,0.00,0.00,'2022-04-13 10:46:21','',''),(2616971,'1','202','1036',477,'Retail Sale Id 3318',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 10:48:07','',''),(2616972,'1','202','1036',477,'Retail Sale Id 3319',8300.00,0.00,0.00,12.50,775.00,'2022-04-13 10:50:17','',''),(2616973,'1','202','1036',477,'Retail Sale Id 3321',7503.20,0.00,0.00,11.30,700.60,'2022-04-13 10:52:03','',''),(2616974,'1','202','1036',477,'Retail Sale Id 3323',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 10:52:48','',''),(2616975,'1','202','1036',477,'Retail Sale Id 3324',2503.28,0.00,0.00,3.77,233.74,'2022-04-13 10:58:30','',''),(2616976,'1','202','1036',477,'Retail Sale Id 3325',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 11:14:56','',''),(2616977,'1','202','1036',477,'Retail Sale Id 3326',1002.64,0.00,0.00,1.51,93.62,'2022-04-13 11:16:03','',''),(2616978,'1','202','1036',477,'Retail Sale Id 3328',2702.48,0.00,0.00,4.07,252.34,'2022-04-13 11:44:01','',''),(2616979,'1','202','1036',477,'Retail Sale Id 3329',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 11:58:24','',''),(2616980,'1','202','1036',477,'Retail Sale Id 3330',3984.00,0.00,0.00,6.00,372.00,'2022-04-13 12:26:24','',''),(2616981,'1','202','1036',477,'Retail Sale Id 3331',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 12:39:36','',''),(2616982,'1','202','1036',477,'Retail Sale Id 3332',1699.84,0.00,0.00,2.56,158.72,'2022-04-13 12:51:19','',''),(2616983,'1','202','1036',477,'Retail Sale Id 3334',1500.64,0.00,0.00,2.26,140.12,'2022-04-13 12:53:12','',''),(2616984,'1','202','1036',477,'Retail Sale Id 3335',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 13:03:26','',''),(2616985,'1','202','1036',477,'Retail Sale Id 3336',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 13:05:58','',''),(2616986,'1','202','1036',477,'Retail Sale Id 3337',1201.84,0.00,0.00,1.81,112.22,'2022-04-13 13:17:00','',''),(2616987,'1','202','1036',477,'Retail Sale Id 3338',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 13:27:05','',''),(2616988,'1','202','1036',477,'Retail Sale Id 3339',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 13:34:56','',''),(2616989,'1','202','1036',477,'Retail Sale Id 3340',8300.00,0.00,0.00,12.50,775.00,'2022-04-13 13:38:15','',''),(2616990,'1','202','1036',477,'Retail Sale Id 3341',3001.28,0.00,0.00,4.52,280.24,'2022-04-13 13:40:55','',''),(2616991,'1','202','1036',477,'Retail Sale Id 3342',3001.28,0.00,0.00,4.52,280.24,'2022-04-13 13:43:04','',''),(2616992,'1','202','1036',477,'Retail Sale Id 3343',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 13:44:31','',''),(2616993,'1','202','1036',477,'Retail Sale Id 3344',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 14:03:58','',''),(2616994,'1','202','1036',477,'Retail Sale Id 3345',4999.92,0.00,0.00,7.53,466.86,'2022-04-13 14:16:37','',''),(2616995,'1','202','1036',477,'Retail Sale Id 3346',3353.20,0.00,0.00,5.05,313.10,'2022-04-13 14:22:24','',''),(2616996,'1','202','1036',477,'Retail Sale Id 3347',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 14:24:46','',''),(2616997,'1','202','1036',477,'Retail Sale Id 3348',8300.00,0.00,0.00,12.50,775.00,'2022-04-13 14:26:08','',''),(2616998,'1','202','1036',477,'Retail Sale Id 3349',1002.64,0.00,0.00,1.51,93.62,'2022-04-13 14:31:50','',''),(2616999,'1','202','1036',477,'Retail Sale Id 3351',5398.32,0.00,0.00,8.13,504.06,'2022-04-13 14:38:52','',''),(2617000,'1','202','1036',477,'Retail Sale Id 3352',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 14:40:15','',''),(2617001,'1','202','1036',477,'Retail Sale Id 3353',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 14:42:50','',''),(2617002,'1','202','1036',477,'Retail Sale Id 3350',697.20,0.00,0.00,1.05,65.10,'2022-04-13 14:50:52','',''),(2617003,'1','202','1036',477,'Retail Sale Id 3354',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 14:57:38','',''),(2617004,'1','202','1036',477,'Retail Sale Id 3355',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 15:02:26','',''),(2617005,'1','202','1036',477,'Retail Sale Id 3356',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 15:03:47','',''),(2617006,'1','202','1036',477,'Retail Sale Id 3357',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 15:11:11','',''),(2617007,'1','202','1036',477,'Retail Sale Id 3359',1500.64,0.00,0.00,2.26,140.12,'2022-04-13 15:13:17','',''),(2617008,'1','202','1036',477,'Retail Sale Id 3360',1347.92,0.00,0.00,2.03,125.86,'2022-04-13 15:16:28','',''),(2617009,'1','202','1036',477,'Retail Sale Id 3361',1347.92,0.00,0.00,2.03,125.86,'2022-04-13 15:17:33','',''),(2617010,'1','202','1036',477,'Retail Sale Id 3362',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 15:49:23','',''),(2617011,'1','202','1036',477,'Retail Sale Id 3363',3353.20,0.00,0.00,5.05,313.10,'2022-04-13 15:54:24','',''),(2617012,'1','202','1036',477,'Retail Sale Id 3364',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 15:55:57','',''),(2617013,'1','202','1036',477,'Retail Sale Id 3365',2503.28,0.00,0.00,3.77,233.74,'2022-04-13 16:00:46','',''),(2617014,'1','202','1036',477,'Retail Sale Id 3366',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 16:10:30','',''),(2617015,'1','202','1036',477,'Retail Sale Id 3367',1500.64,0.00,0.00,2.26,140.12,'2022-04-13 16:18:28','',''),(2617016,'1','202','1036',477,'Retail Sale Id 3368',1699.84,0.00,0.00,2.56,158.72,'2022-04-13 16:29:18','',''),(2617017,'1','202','1036',477,'Retail Sale Id 3369',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 16:32:13','',''),(2617018,'1','202','1036',477,'Retail Sale Id 3370',1002.64,0.00,0.00,1.51,93.62,'2022-04-13 16:34:27','',''),(2617019,'1','202','1036',477,'Retail Sale Id 3371',2702.48,0.00,0.00,4.07,252.34,'2022-04-13 16:42:11','',''),(2617020,'1','202','1036',477,'Retail Sale Id 3372',697.20,0.00,0.00,1.05,65.10,'2022-04-13 16:58:48','',''),(2617021,'1','202','1036',477,'Retail Sale Id 3373',796.80,0.00,0.00,1.20,74.40,'2022-04-13 17:03:14','',''),(2617022,'1','202','1036',477,'Retail Sale Id 3374',8300.00,0.00,0.00,12.50,775.00,'2022-04-13 17:04:15','',''),(2617023,'1','202','1036',477,'Retail Sale Id 3375',1500.64,0.00,0.00,2.26,140.12,'2022-04-13 17:05:36','',''),(2617024,'1','202','1036',477,'Retail Sale Id 3376',1347.92,0.00,0.00,2.03,125.86,'2022-04-13 17:13:00','',''),(2617025,'1','202','1036',477,'Retail Sale Id 3377',3001.28,0.00,0.00,4.52,280.24,'2022-04-13 17:14:29','',''),(2617026,'1','202','1036',477,'Retail Sale Id 3379',3300.08,0.00,0.00,4.97,308.14,'2022-04-13 17:22:45','',''),(2617027,'1','202','1036',477,'Retail Sale Id 3380',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 17:25:41','',''),(2617028,'1','202','1036',477,'Retail Sale Id 3381',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 17:28:19','',''),(2617029,'1','202','1036',477,'Retail Sale Id 3383',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 17:32:23','',''),(2617030,'1','202','1036',477,'Retail Sale Id 3384',1401.04,0.00,0.00,2.11,130.82,'2022-04-13 17:36:30','',''),(2617031,'1','202','1036',477,'Retail Sale Id 3385',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 17:42:07','',''),(2617032,'1','202','1036',477,'Retail Sale Id 3386',1500.64,0.00,0.00,2.26,140.12,'2022-04-13 17:51:03','',''),(2617033,'1','202','1036',477,'Retail Sale Id 3387',2197.84,0.00,0.00,3.31,205.22,'2022-04-13 17:53:41','',''),(2617034,'1','202','1036',477,'Retail Sale Id 3378',3353.20,0.00,0.00,5.05,313.10,'2022-04-13 17:54:46','',''),(2617035,'1','202','1036',477,'Retail Sale Id 3388',1401.04,0.00,0.00,2.11,130.82,'2022-04-13 17:56:52','',''),(2617036,'1','202','1036',477,'Retail Sale Id 3389',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 18:08:13','',''),(2617037,'1','202','1036',477,'Retail Sale Id 3390',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 18:11:07','',''),(2617038,'1','202','1036',477,'Retail Sale Id 3391',3001.28,0.00,0.00,4.52,280.24,'2022-04-13 18:17:25','',''),(2617039,'1','202','1036',477,'Retail Sale Id 3392',8300.00,0.00,0.00,12.50,775.00,'2022-04-13 18:19:01','',''),(2617040,'1','202','1036',477,'Retail Sale Id 3393',6653.28,0.00,0.00,10.02,621.24,'2022-04-13 18:21:22','',''),(2617041,'1','202','1036',477,'Retail Sale Id 3394',1002.64,0.00,0.00,1.51,93.62,'2022-04-13 18:22:24','',''),(2617042,'1','202','1036',477,'Retail Sale Id 3395',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 18:30:51','',''),(2617043,'1','202','1036',477,'Retail Sale Id 3396',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 18:33:15','',''),(2617044,'1','202','1036',477,'Retail Sale Id 3397',1500.64,0.00,0.00,2.26,140.12,'2022-04-13 18:43:06','',''),(2617045,'1','202','1036',477,'Retail Sale Id 3398',1998.64,0.00,0.00,3.01,186.62,'2022-04-13 18:47:58','',''),(2617046,'1','202','1036',477,'Retail Sale Id 3399',3001.28,0.00,0.00,4.52,280.24,'2022-04-13 19:02:02','',''),(2617047,'1','202','1036',477,'Retail Sale Id 3400',1002.64,0.00,0.00,1.51,93.62,'2022-04-13 19:02:55','',''),(2617048,'1','202','1036',477,'Retail Sale Id 3401',8300.00,0.00,0.00,12.50,775.00,'2022-04-13 19:10:19','',''),(2617049,'1','202','1036',477,'Retail Sale Id 3402',3997.28,0.00,0.00,6.02,373.24,'2022-04-13 19:13:53','',''),(2617050,'1','202','1036',477,'Retail Sale Id 3403',1062.40,0.00,0.00,1.60,99.20,'2022-04-13 19:29:53','',''),(2617051,'1','202','1036',477,'Retail Sale Id 3404',3499.28,0.00,0.00,5.27,326.74,'2022-04-14 06:49:28','',''),(2617052,'1','202','1036',477,'Retail Sale Id 3405',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 07:03:35','',''),(2617053,'1','202','1036',477,'Retail Sale Id 3406',3353.20,0.00,0.00,5.05,313.10,'2022-04-14 07:06:50','',''),(2617054,'1','202','1036',477,'Retail Sale Id 3407',3001.28,0.00,0.00,4.52,280.24,'2022-04-14 07:12:37','',''),(2617055,'1','202','1036',477,'Retail Sale Id 3408',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 07:15:54','',''),(2617056,'1','202','1036',477,'Retail Sale Id 3409',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 07:20:36','',''),(2617057,'1','202','1036',477,'Retail Sale Id 3410',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 07:29:03','',''),(2617058,'1','202','1036',477,'Retail Sale Id 3411',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 07:29:41','',''),(2617059,'1','202','1036',477,'Retail Sale Id 3412',1002.64,0.00,0.00,1.51,93.62,'2022-04-14 07:30:18','',''),(2617060,'1','202','1036',477,'Retail Sale Id 3413',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 07:35:55','',''),(2617061,'1','202','1036',477,'Retail Sale Id 3414',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 07:39:36','',''),(2617062,'1','202','1036',477,'Retail Sale Id 3415',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 07:42:52','',''),(2617063,'1','202','1036',477,'Retail Sale Id 3416',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 07:47:33','',''),(2617064,'1','202','1036',477,'Retail Sale Id 3418',3353.20,0.00,0.00,5.05,313.10,'2022-04-14 07:51:25','',''),(2617065,'1','202','1036',477,'Retail Sale Id 3420',2602.88,0.00,0.00,3.92,243.04,'2022-04-14 07:55:12','',''),(2617066,'1','202','1036',477,'Retail Sale Id 3421',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 08:03:31','',''),(2617067,'1','202','1036',477,'Retail Sale Id 3422',2702.48,0.00,0.00,4.07,252.34,'2022-04-14 08:09:02','',''),(2617068,'1','202','1036',477,'Retail Sale Id 3423',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 08:10:47','',''),(2617069,'1','202','1036',477,'Retail Sale Id 3424',2503.28,0.00,0.00,3.77,233.74,'2022-04-14 08:15:30','',''),(2617070,'1','202','1036',477,'Retail Sale Id 3425',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 08:16:22','',''),(2617071,'1','202','1036',477,'Retail Sale Id 3426',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 08:18:32','',''),(2617072,'1','202','1036',477,'Retail Sale Id 3427',1500.64,0.00,0.00,2.26,140.12,'2022-04-14 08:20:13','',''),(2617073,'1','202','1036',477,'Retail Sale Id 3428',3001.28,0.00,0.00,4.52,280.24,'2022-04-14 08:23:38','',''),(2617074,'1','202','1036',477,'Retail Sale Id 3429',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 08:24:28','',''),(2617075,'1','202','1036',477,'Retail Sale Id 3430',1500.64,0.00,0.00,2.26,140.12,'2022-04-14 08:34:36','',''),(2617076,'1','202','1036',477,'Retail Sale Id 3431',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 08:40:49','',''),(2617077,'1','202','1036',477,'Retail Sale Id 3432',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 08:45:14','',''),(2617078,'1','202','1036',477,'Retail Sale Id 3433',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 08:47:06','',''),(2617079,'1','202','1036',477,'Retail Sale Id 3434',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 08:54:57','',''),(2617080,'1','202','1036',477,'Retail Sale Id 3436',3001.28,0.00,0.00,4.52,280.24,'2022-04-14 09:02:08','',''),(2617081,'1','202','1036',477,'Retail Sale Id 3437',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 09:08:08','',''),(2617082,'1','202','1036',477,'Retail Sale Id 3438',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 09:23:49','',''),(2617083,'1','202','1036',477,'Retail Sale Id 3439',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 09:24:39','',''),(2617084,'1','202','1036',477,'Retail Sale Id 3440',5497.92,0.00,0.00,8.28,513.36,'2022-04-14 09:28:09','',''),(2617085,'1','202','1036',477,'Retail Sale Id 3441',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 09:29:46','',''),(2617086,'1','202','1036',477,'Retail Sale Id 3442',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 09:32:16','',''),(2617087,'1','202','1036',477,'Retail Sale Id 3443',2702.48,0.00,0.00,4.07,252.34,'2022-04-14 09:33:45','',''),(2617088,'1','202','1036',477,'Retail Sale Id 3444',2503.28,0.00,0.00,3.77,233.74,'2022-04-14 09:36:59','',''),(2617089,'1','202','1036',477,'Retail Sale Id 3445',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 09:37:50','',''),(2617090,'1','202','1036',477,'Retail Sale Id 3446',1002.64,0.00,0.00,1.51,93.62,'2022-04-14 09:49:10','',''),(2617091,'1','202','1036',477,'Retail Sale Id 3447',903.04,0.00,0.00,1.36,84.32,'2022-04-14 09:52:21','',''),(2617092,'1','202','1036',477,'Retail Sale Id 3448',3001.28,0.00,0.00,4.52,280.24,'2022-04-14 09:53:13','',''),(2617093,'1','202','1036',477,'Retail Sale Id 3449',1500.64,0.00,0.00,2.26,140.12,'2022-04-14 10:00:39','',''),(2617094,'1','202','1036',477,'Retail Sale Id 3450',4999.92,0.00,0.00,7.53,466.86,'2022-04-14 10:12:53','',''),(2617095,'1','202','1036',477,'Retail Sale Id 3451',1500.64,0.00,0.00,2.26,140.12,'2022-04-14 10:13:41','',''),(2617096,'1','202','1036',477,'Retail Sale Id 3452',1401.04,0.00,0.00,2.11,130.82,'2022-04-14 10:20:06','',''),(2617097,'1','202','1036',477,'Retail Sale Id 3453',4999.92,0.00,0.00,7.53,466.86,'2022-04-14 10:21:01','',''),(2617098,'1','202','1036',477,'Retail Sale Id 3454',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 10:22:33','',''),(2617099,'1','202','1036',477,'Retail Sale Id 3455',903.04,0.00,0.00,1.36,84.32,'2022-04-14 10:26:38','',''),(2617100,'1','202','1036',477,'Retail Sale Id 3456',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 10:31:27','',''),(2617101,'1','202','1036',477,'Retail Sale Id 3457',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 10:32:38','',''),(2617102,'1','202','1036',477,'Retail Sale Id 3458',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 10:55:35','',''),(2617103,'1','202','1036',477,'Retail Sale Id 3459',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 10:58:02','',''),(2617104,'1','202','1036',477,'Retail Sale Id 3460',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 11:02:25','',''),(2617105,'1','202','1036',477,'Retail Sale Id 3461',6002.56,0.00,0.00,9.04,560.48,'2022-04-14 11:03:59','',''),(2617106,'1','202','1036',477,'Retail Sale Id 3462',1002.64,0.00,0.00,1.51,93.62,'2022-04-14 11:06:55','',''),(2617107,'1','202','1036',477,'Retail Sale Id 3463',1799.44,0.00,0.00,2.71,168.02,'2022-04-14 11:09:02','',''),(2617108,'1','202','1036',477,'Retail Sale Id 3464',1201.84,0.00,0.00,1.81,112.22,'2022-04-14 11:09:49','',''),(2617109,'1','202','1036',477,'Retail Sale Id 3465',1347.92,0.00,0.00,2.03,125.86,'2022-04-14 11:11:24','',''),(2617110,'1','202','1036',477,'Retail Sale Id 3466',1002.64,0.00,0.00,1.51,93.62,'2022-04-14 11:22:07','',''),(2617111,'1','202','1036',477,'Retail Sale Id 3467',796.80,0.00,0.00,1.20,74.40,'2022-04-14 11:23:20','',''),(2617112,'1','202','1036',477,'Retail Sale Id 3468',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 11:28:43','',''),(2617113,'1','202','1036',477,'Return of Retail Sale Id 3464',0.00,1201.84,1.81,0.00,-112.22,'2022-04-14 11:33:54','',''),(2617114,'1','202','1036',477,'Retail Sale Id 3469',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 11:35:14','',''),(2617115,'1','202','1036',477,'Retail Sale Id 3470',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 11:45:18','',''),(2617116,'1','202','1036',477,'Retail Sale Id 3471',3001.28,0.00,0.00,4.52,280.24,'2022-04-14 11:46:54','',''),(2617117,'1','202','1036',477,'Retail Sale Id 3472',2503.28,0.00,0.00,3.77,233.74,'2022-04-14 11:48:37','',''),(2617118,'1','202','1036',477,'Retail Sale Id 3474',2503.28,0.00,0.00,3.77,233.74,'2022-04-14 11:49:52','',''),(2617119,'1','202','1036',477,'Retail Sale Id 3475',1500.64,0.00,0.00,2.26,140.12,'2022-04-14 11:57:24','',''),(2617120,'1','202','1036',477,'Retail Sale Id 3476',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 12:01:27','',''),(2617121,'1','202','1036',477,'Retail Sale Id 3477',796.80,0.00,0.00,1.20,74.40,'2022-04-14 12:05:25','',''),(2617122,'1','202','1036',477,'Retail Sale Id 3478',3499.28,0.00,0.00,5.27,326.74,'2022-04-14 12:17:52','',''),(2617123,'1','202','1036',477,'Retail Sale Id 3479',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 12:26:05','',''),(2617124,'1','202','1036',477,'Retail Sale Id 3480',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 12:32:19','',''),(2617125,'1','202','1036',477,'Retail Sale Id 3481',6600.16,0.00,0.00,9.94,616.28,'2022-04-14 12:34:05','',''),(2617126,'1','202','1036',477,'Retail Sale Id 3482',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 12:39:30','',''),(2617127,'1','202','1036',477,'Retail Sale Id 3483',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 12:44:13','',''),(2617128,'1','202','1036',477,'Retail Sale Id 3484',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 12:44:59','',''),(2617129,'1','202','1036',477,'Retail Sale Id 3485',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 12:52:27','',''),(2617130,'1','202','1036',477,'Retail Sale Id 3486',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 12:54:13','',''),(2617131,'1','202','1036',477,'Retail Sale Id 3487',1002.64,0.00,0.00,1.51,93.62,'2022-04-14 13:04:21','',''),(2617132,'1','202','1036',477,'Retail Sale Id 3488',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 13:08:13','',''),(2617133,'1','202','1036',477,'Retail Sale Id 3495',4999.92,0.00,0.00,7.53,466.86,'2022-04-14 13:26:38','',''),(2617134,'1','202','1036',477,'Retail Sale Id 3498',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 13:45:53','',''),(2617135,'1','202','1036',477,'Retail Sale Id 3499',697.20,0.00,0.00,1.05,65.10,'2022-04-14 13:50:14','',''),(2617136,'1','202','1036',477,'Retail Sale Id 3501',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 13:50:52','',''),(2617137,'1','202','1036',477,'Retail Sale Id 3502',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 14:02:44','',''),(2617138,'1','202','1036',477,'Retail Sale Id 3503',697.20,0.00,0.00,1.05,65.10,'2022-04-14 14:04:09','',''),(2617139,'1','202','1036',477,'Retail Sale Id 3504',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 14:15:15','',''),(2617140,'1','202','1036',477,'Retail Sale Id 3505',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 14:41:39','',''),(2617141,'1','202','1036',477,'Retail Sale Id 3506',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 14:46:04','',''),(2617142,'1','202','1036',477,'Retail Sale Id 3507',3001.28,0.00,0.00,4.52,280.24,'2022-04-14 14:54:48','',''),(2617143,'1','202','1036',477,'Retail Sale Id 3508',697.20,0.00,0.00,1.05,65.10,'2022-04-14 14:59:20','',''),(2617144,'1','202','1036',477,'Retail Sale Id 3509',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 15:07:25','',''),(2617145,'1','202','1036',477,'Retail Sale Id 3510',1500.64,0.00,0.00,2.26,140.12,'2022-04-14 15:35:46','',''),(2617146,'1','202','1036',477,'Retail Sale Id 3511',6002.56,0.00,0.00,9.04,560.48,'2022-04-14 16:05:15','',''),(2617147,'1','202','1036',477,'Retail Sale Id 3512',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 16:08:41','',''),(2617148,'1','202','1036',477,'Retail Sale Id 3513',8001.20,0.00,0.00,12.05,747.10,'2022-04-14 16:10:15','',''),(2617149,'1','202','1036',477,'Retail Sale Id 3515',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 16:13:00','',''),(2617150,'1','202','1036',477,'Retail Sale Id 3517',14999.76,0.00,0.00,22.59,1400.58,'2022-04-14 16:14:40','',''),(2617151,'1','202','1036',477,'Retail Sale Id 3518',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 16:24:08','',''),(2617152,'1','202','1036',477,'Retail Sale Id 3519',1002.64,0.00,0.00,1.51,93.62,'2022-04-14 16:36:29','',''),(2617153,'1','202','1036',477,'Retail Sale Id 3521',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 16:37:11','',''),(2617154,'1','202','1036',477,'Retail Sale Id 3523',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 16:38:01','',''),(2617155,'1','202','1036',477,'Retail Sale Id 3524',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 16:44:38','',''),(2617156,'1','202','1036',477,'Retail Sale Id 3525',1002.64,0.00,0.00,1.51,93.62,'2022-04-14 16:47:28','',''),(2617157,'1','202','1036',477,'Retail Sale Id 3526',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 17:03:23','',''),(2617158,'1','202','1036',477,'Retail Sale Id 3527',3353.20,0.00,0.00,5.05,313.10,'2022-04-14 17:06:44','',''),(2617159,'1','202','1036',477,'Retail Sale Id 3528',3200.48,0.00,0.00,4.82,298.84,'2022-04-14 17:10:44','',''),(2617160,'1','202','1036',477,'Retail Sale Id 3529',697.20,0.00,0.00,1.05,65.10,'2022-04-14 17:11:48','',''),(2617161,'1','202','1036',477,'Retail Sale Id 3530',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 17:29:47','',''),(2617162,'1','202','1036',477,'Retail Sale Id 3531',3353.20,0.00,0.00,5.05,313.10,'2022-04-14 17:32:39','',''),(2617163,'1','202','1036',477,'Retail Sale Id 3532',3353.20,0.00,0.00,5.05,313.10,'2022-04-14 17:36:07','',''),(2617164,'1','202','1036',477,'Retail Sale Id 3534',1500.64,0.00,0.00,2.26,140.12,'2022-04-14 17:38:26','',''),(2617165,'1','202','1036',477,'Retail Sale Id 3535',4701.12,0.00,0.00,7.08,438.96,'2022-04-14 17:41:34','',''),(2617166,'1','202','1036',477,'Retail Sale Id 3536',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 17:42:55','',''),(2617167,'1','202','1036',477,'Retail Sale Id 3538',3200.48,0.00,0.00,4.82,298.84,'2022-04-14 17:49:06','',''),(2617168,'1','202','1036',477,'Retail Sale Id 3540',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 17:51:33','',''),(2617169,'1','202','1036',477,'Retail Sale Id 3541',697.20,0.00,0.00,1.05,65.10,'2022-04-14 17:55:50','',''),(2617170,'1','202','1036',477,'Retail Sale Id 3542',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 18:03:22','',''),(2617171,'1','202','1036',477,'Retail Sale Id 3543',2503.28,0.00,0.00,3.77,233.74,'2022-04-14 18:06:52','',''),(2617172,'1','202','1036',477,'Retail Sale Id 3544',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 18:12:01','',''),(2617173,'1','202','1036',477,'Retail Sale Id 3546',1002.64,0.00,0.00,1.51,93.62,'2022-04-14 18:14:58','',''),(2617174,'1','202','1036',477,'Retail Sale Id 3547',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 18:20:51','',''),(2617175,'1','202','1036',477,'Retail Sale Id 3548',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 18:21:47','',''),(2617176,'1','202','1036',477,'Retail Sale Id 3550',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 18:22:31','',''),(2617177,'1','202','1036',477,'Retail Sale Id 3551',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 18:24:11','',''),(2617178,'1','202','1036',477,'Retail Sale Id 3552',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 18:24:56','',''),(2617179,'1','202','1036',477,'Retail Sale Id 3554',1500.64,0.00,0.00,2.26,140.12,'2022-04-14 18:26:22','',''),(2617180,'1','202','1036',477,'Retail Sale Id 3555',3499.28,0.00,0.00,5.27,326.74,'2022-04-14 18:27:43','',''),(2617181,'1','202','1036',477,'Retail Sale Id 3556',796.80,0.00,0.00,1.20,74.40,'2022-04-14 18:29:30','',''),(2617182,'1','202','1036',477,'Retail Sale Id 3557',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 18:30:32','',''),(2617183,'1','202','1036',477,'Retail Sale Id 3559',1998.64,0.00,0.00,3.01,186.62,'2022-04-14 18:31:19','',''),(2617184,'1','202','1036',477,'Retail Sale Id 3560',8300.00,0.00,0.00,12.50,775.00,'2022-04-14 18:46:00','',''),(2617185,'1','202','1036',477,'Retail Sale Id 3561',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 18:46:52','',''),(2617186,'1','202','1036',477,'Retail Sale Id 3562',6653.28,0.00,0.00,10.02,621.24,'2022-04-14 18:48:55','',''),(2617187,'1','202','1036',477,'Retail Sale Id 3564',3997.28,0.00,0.00,6.02,373.24,'2022-04-14 19:06:23','',''),(2617188,'1','202','1036',477,'Retail Sale Id 3565',3499.28,0.00,0.00,5.27,326.74,'2022-04-14 19:10:41','',''),(2617189,'1','202','1036',477,'Retail Sale Id 3566',3353.20,0.00,0.00,5.05,313.10,'2022-04-14 19:11:56','',''),(2617190,'1','202','1036',477,'Return of Retail Sale Id 3565',0.00,3499.28,5.27,0.00,-326.74,'2022-04-14 19:13:10','',''),(2617191,'1','202','1036',477,'Return of Retail Sale Id 3541',0.00,697.20,1.05,0.00,-65.10,'2022-04-14 19:14:17','',''),(2617192,'1','202','1036',477,'Return of Retail Sale Id 3559',0.00,1998.64,3.01,0.00,-186.62,'2022-04-14 19:14:40','',''),(2617193,'1','202','1036',477,'Retail Sale Id 3567',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 07:01:21','',''),(2617194,'1','202','1036',477,'Retail Sale Id 3568',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 07:02:09','',''),(2617195,'1','202','1036',477,'Retail Sale Id 3569',3399.68,0.00,0.00,5.12,317.44,'2022-04-15 07:04:01','',''),(2617196,'1','202','1036',477,'Retail Sale Id 3571',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 07:04:42','',''),(2617197,'1','202','1036',477,'Retail Sale Id 3572',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 07:28:38','',''),(2617198,'1','202','1036',477,'Retail Sale Id 3573',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 07:30:29','',''),(2617199,'1','202','1036',477,'Retail Sale Id 3574',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 07:32:16','',''),(2617200,'1','202','1036',477,'Retail Sale Id 3575',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 07:47:25','',''),(2617201,'1','202','1036',477,'Retail Sale Id 3576',9960.00,0.00,0.00,15.00,930.00,'2022-04-15 07:49:33','',''),(2617202,'1','202','1036',477,'Retail Sale Id 3577',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 07:50:21','',''),(2617203,'1','202','1036',477,'Retail Sale Id 3578',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 07:51:05','',''),(2617204,'1','202','1036',477,'Retail Sale Id 3579',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 07:52:08','',''),(2617205,'1','202','1036',477,'Retail Sale Id 3580',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 07:52:59','',''),(2617206,'1','202','1036',477,'Retail Sale Id 3581',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 07:57:33','',''),(2617207,'1','202','1036',477,'Retail Sale Id 3582',3897.68,0.00,0.00,5.87,363.94,'2022-04-15 07:59:03','',''),(2617208,'1','202','1036',477,'Retail Sale Id 3583',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 08:01:02','',''),(2617209,'1','202','1036',477,'Retail Sale Id 3584',4999.92,0.00,0.00,7.53,466.86,'2022-04-15 08:01:55','',''),(2617210,'1','202','1036',477,'Retail Sale Id 3585',16600.00,0.00,0.00,25.00,1550.00,'2022-04-15 08:03:04','',''),(2617211,'1','202','1036',477,'Retail Sale Id 3586',3399.68,0.00,0.00,5.12,317.44,'2022-04-15 08:04:30','',''),(2617212,'1','202','1036',477,'Retail Sale Id 3587',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 08:07:59','',''),(2617213,'1','202','1036',477,'Retail Sale Id 3588',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 08:24:25','',''),(2617214,'1','202','1036',477,'Retail Sale Id 3589',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 08:32:08','',''),(2617215,'1','202','1036',477,'Retail Sale Id 3590',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 08:37:24','',''),(2617216,'1','202','1036',477,'Retail Sale Id 3591',1799.44,0.00,0.00,2.71,168.02,'2022-04-15 08:50:55','',''),(2617217,'1','202','1036',477,'Retail Sale Id 3592',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 09:20:58','',''),(2617218,'1','202','1036',477,'Retail Sale Id 3593',903.04,0.00,0.00,1.36,84.32,'2022-04-15 09:28:46','',''),(2617219,'1','202','1036',477,'Retail Sale Id 3595',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 09:45:22','',''),(2617220,'1','202','1036',477,'Retail Sale Id 3596',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 09:48:39','',''),(2617221,'1','202','1036',477,'Retail Sale Id 3597',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 10:10:52','',''),(2617222,'1','202','1036',477,'Retail Sale Id 3598',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 10:28:50','',''),(2617223,'1','202','1036',477,'Retail Sale Id 3599',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 10:31:19','',''),(2617224,'1','202','1036',477,'Retail Sale Id 3600',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 10:37:42','',''),(2617225,'1','202','1036',477,'Retail Sale Id 3602',3001.28,0.00,0.00,4.52,280.24,'2022-04-15 10:38:32','',''),(2617226,'1','202','1036',477,'Retail Sale Id 3603',1347.92,0.00,0.00,2.03,125.86,'2022-04-15 10:40:22','',''),(2617227,'1','202','1036',477,'Retail Sale Id 3604',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 10:46:59','',''),(2617228,'1','202','1036',477,'Retail Sale Id 3605',3353.20,0.00,0.00,5.05,313.10,'2022-04-15 10:47:53','',''),(2617229,'1','202','1036',477,'Retail Sale Id 3606',3353.20,0.00,0.00,5.05,313.10,'2022-04-15 10:52:46','',''),(2617230,'1','202','1036',477,'Retail Sale Id 3607',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 10:54:33','',''),(2617231,'1','202','1036',477,'Retail Sale Id 3608',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 10:58:02','',''),(2617232,'1','202','1036',477,'Retail Sale Id 3609',3499.28,0.00,0.00,5.27,326.74,'2022-04-15 11:00:37','',''),(2617233,'1','202','1036',477,'Retail Sale Id 3610',2503.28,0.00,0.00,3.77,233.74,'2022-04-15 11:01:46','',''),(2617234,'1','202','1036',477,'Retail Sale Id 3611',5976.00,0.00,0.00,9.00,558.00,'2022-04-15 11:02:50','',''),(2617235,'1','202','1036',477,'Retail Sale Id 3612',6653.28,0.00,0.00,10.02,621.24,'2022-04-15 11:07:05','',''),(2617236,'1','202','1036',477,'Retail Sale Id 3613',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 11:12:27','',''),(2617237,'1','202','1036',477,'Retail Sale Id 3615',597.60,0.00,0.00,0.90,55.80,'2022-04-15 11:13:20','',''),(2617238,'1','202','1036',477,'Retail Sale Id 3616',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 11:14:41','',''),(2617239,'1','202','1036',477,'Retail Sale Id 3617',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 11:18:08','',''),(2617240,'1','202','1036',477,'Retail Sale Id 3618',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 11:21:20','',''),(2617241,'1','202','1036',477,'Retail Sale Id 3619',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 11:23:11','',''),(2617242,'1','202','1036',477,'Retail Sale Id 3620',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 11:24:48','',''),(2617243,'1','202','1036',477,'Retail Sale Id 3622',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 11:27:36','',''),(2617244,'1','202','1036',477,'Retail Sale Id 3624',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 11:29:06','',''),(2617245,'1','202','1036',477,'Retail Sale Id 3625',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 11:32:03','',''),(2617246,'1','202','1036',477,'Retail Sale Id 3626',6002.56,0.00,0.00,9.04,560.48,'2022-04-15 11:34:49','',''),(2617247,'1','202','1036',477,'Retail Sale Id 3627',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 11:35:43','',''),(2617248,'1','202','1036',477,'Retail Sale Id 3629',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 11:36:43','',''),(2617249,'1','202','1036',477,'Retail Sale Id 3631',6653.28,0.00,0.00,10.02,621.24,'2022-04-15 11:37:28','',''),(2617250,'1','202','1036',477,'Retail Sale Id 3632',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 11:39:21','',''),(2617251,'1','202','1036',477,'Retail Sale Id 3635',9960.00,0.00,0.00,15.00,930.00,'2022-04-15 11:47:34','',''),(2617252,'1','202','1036',477,'Retail Sale Id 3637',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 11:58:14','',''),(2617253,'1','202','1036',477,'Retail Sale Id 3639',3001.28,0.00,0.00,4.52,280.24,'2022-04-15 11:58:59','',''),(2617254,'1','202','1036',477,'Retail Sale Id 3640',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 12:00:47','',''),(2617255,'1','202','1036',477,'Retail Sale Id 3642',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 12:01:20','',''),(2617256,'1','202','1036',477,'Retail Sale Id 3644',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 12:02:13','',''),(2617257,'1','202','1036',477,'Retail Sale Id 3645',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 12:07:08','',''),(2617258,'1','202','1036',477,'Retail Sale Id 3648',6653.28,0.00,0.00,10.02,621.24,'2022-04-15 12:08:21','',''),(2617259,'1','202','1036',477,'Retail Sale Id 3650',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 12:10:21','',''),(2617260,'1','202','1036',477,'Retail Sale Id 3652',3001.28,0.00,0.00,4.52,280.24,'2022-04-15 12:13:41','',''),(2617261,'1','202','1036',477,'Retail Sale Id 3654',3353.20,0.00,0.00,5.05,313.10,'2022-04-15 12:15:59','',''),(2617262,'1','202','1036',477,'Retail Sale Id 3656',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 12:16:53','',''),(2617263,'1','202','1036',477,'Retail Sale Id 3658',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 12:17:36','',''),(2617264,'1','202','1036',477,'Retail Sale Id 3659',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 12:19:18','',''),(2617265,'1','202','1036',477,'Retail Sale Id 3661',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 12:20:41','',''),(2617266,'1','202','1036',477,'Retail Sale Id 3662',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 12:22:03','',''),(2617267,'1','202','1036',477,'Retail Sale Id 3663',3353.20,0.00,0.00,5.05,313.10,'2022-04-15 12:30:26','',''),(2617268,'1','202','1036',477,'Retail Sale Id 3664',3353.20,0.00,0.00,5.05,313.10,'2022-04-15 12:32:08','',''),(2617269,'1','202','1036',477,'Retail Sale Id 3665',650.72,0.00,0.00,0.98,60.76,'2022-04-15 12:35:05','',''),(2617270,'1','202','1036',477,'Retail Sale Id 3666',6653.28,0.00,0.00,10.02,621.24,'2022-04-15 12:39:02','',''),(2617271,'1','202','1036',477,'Retail Sale Id 3668',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 12:42:10','',''),(2617272,'1','202','1036',477,'Retail Sale Id 3669',3499.28,0.00,0.00,5.27,326.74,'2022-04-15 12:43:20','',''),(2617273,'1','202','1036',477,'Retail Sale Id 3672',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 12:44:04','',''),(2617274,'1','202','1036',477,'Retail Sale Id 3673',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 12:47:04','',''),(2617275,'1','202','1036',477,'Retail Sale Id 3675',8001.20,0.00,0.00,12.05,747.10,'2022-04-15 12:47:51','',''),(2617276,'1','202','1036',477,'Retail Sale Id 3676',697.20,0.00,0.00,1.05,65.10,'2022-04-15 12:59:48','',''),(2617277,'1','202','1036',477,'Retail Sale Id 3677',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 13:01:57','',''),(2617278,'1','202','1036',477,'Retail Sale Id 3680',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 13:04:21','',''),(2617279,'1','202','1036',477,'Retail Sale Id 3681',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 13:07:10','',''),(2617280,'1','202','1036',477,'Retail Sale Id 3682',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 13:08:42','',''),(2617281,'1','202','1036',477,'Retail Sale Id 3683',3353.20,0.00,0.00,5.05,313.10,'2022-04-15 13:09:52','',''),(2617282,'1','202','1036',477,'Retail Sale Id 3685',6998.56,0.00,0.00,10.54,653.48,'2022-04-15 13:12:25','',''),(2617283,'1','202','1036',477,'Retail Sale Id 3687',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 13:15:35','',''),(2617284,'1','202','1036',477,'Retail Sale Id 3688',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 13:19:17','',''),(2617285,'1','202','1036',477,'Retail Sale Id 3689',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 13:20:16','',''),(2617286,'1','202','1036',477,'Retail Sale Id 3692',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 13:21:11','',''),(2617287,'1','202','1036',477,'Retail Sale Id 3694',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 13:23:27','',''),(2617288,'1','202','1036',477,'Retail Sale Id 3695',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 13:27:02','',''),(2617289,'1','202','1036',477,'Retail Sale Id 3696',4999.92,0.00,0.00,7.53,466.86,'2022-04-15 13:28:54','',''),(2617290,'1','202','1036',477,'Retail Sale Id 3698',2702.48,0.00,0.00,4.07,252.34,'2022-04-15 13:32:11','',''),(2617291,'1','202','1036',477,'Retail Sale Id 3700',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 13:34:18','',''),(2617292,'1','202','1036',477,'Retail Sale Id 3702',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 13:34:52','',''),(2617293,'1','202','1036',477,'Retail Sale Id 3704',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 13:37:09','',''),(2617294,'1','202','1036',477,'Retail Sale Id 3705',8001.20,0.00,0.00,12.05,747.10,'2022-04-15 13:38:36','',''),(2617295,'1','202','1036',477,'Retail Sale Id 3706',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 13:39:11','',''),(2617296,'1','202','1036',477,'Retail Sale Id 3708',1347.92,0.00,0.00,2.03,125.86,'2022-04-15 13:47:16','',''),(2617297,'1','202','1036',477,'Retail Sale Id 3709',597.60,0.00,0.00,0.90,55.80,'2022-04-15 13:48:52','',''),(2617298,'1','202','1036',477,'Retail Sale Id 3711',6640.00,0.00,0.00,10.00,620.00,'2022-04-15 13:49:59','',''),(2617299,'1','202','1036',477,'Retail Sale Id 3712',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 13:53:46','',''),(2617300,'1','202','1036',477,'Retail Sale Id 3714',798600.00,0.00,0.00,1320.00,3960.00,'2022-04-15 13:55:31','',''),(2617301,'1','202','1036',477,'Retail Sale Id 3715',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 13:56:24','',''),(2617302,'1','202','1036',477,'Retail Sale Id 3716',697.20,0.00,0.00,1.05,65.10,'2022-04-15 14:00:21','',''),(2617303,'1','202','1036',477,'Retail Sale Id 3717',2503.28,0.00,0.00,3.77,233.74,'2022-04-15 14:02:58','',''),(2617304,'1','202','1036',477,'Retail Sale Id 3718',5199.12,0.00,0.00,7.83,485.46,'2022-04-15 14:14:37','',''),(2617305,'1','202','1036',477,'Retail Sale Id 3719',6653.28,0.00,0.00,10.02,621.24,'2022-04-15 14:16:32','',''),(2617306,'1','202','1036',477,'Retail Sale Id 3720',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 14:17:38','',''),(2617307,'1','202','1036',477,'Retail Sale Id 3721',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 14:18:45','',''),(2617308,'1','202','1036',477,'Retail Sale Id 3723',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 14:20:07','',''),(2617309,'1','202','1036',477,'Retail Sale Id 3724',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 14:20:51','',''),(2617310,'1','202','1036',477,'Retail Sale Id 3725',3353.20,0.00,0.00,5.05,313.10,'2022-04-15 14:22:25','',''),(2617311,'1','202','1036',477,'Retail Sale Id 3726',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 14:23:04','',''),(2617312,'1','202','1036',477,'Retail Sale Id 3727',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 14:23:44','',''),(2617313,'1','202','1036',477,'Retail Sale Id 3728',3001.28,0.00,0.00,4.52,280.24,'2022-04-15 14:24:46','',''),(2617314,'1','202','1036',477,'Retail Sale Id 3729',4999.92,0.00,0.00,7.53,466.86,'2022-04-15 14:31:45','',''),(2617315,'1','202','1036',477,'Retail Sale Id 3730',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 14:36:53','',''),(2617316,'1','202','1036',477,'Retail Sale Id 3731',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 14:37:41','',''),(2617317,'1','202','1036',477,'Retail Sale Id 3732',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 14:38:38','',''),(2617318,'1','202','1036',477,'Retail Sale Id 3733',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 14:39:44','',''),(2617319,'1','202','1036',477,'Retail Sale Id 3734',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 14:43:48','',''),(2617320,'1','202','1036',477,'Retail Sale Id 3735',3353.20,0.00,0.00,5.05,313.10,'2022-04-15 14:44:58','',''),(2617321,'1','202','1036',477,'Retail Sale Id 3736',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 14:45:35','',''),(2617322,'1','202','1036',477,'Retail Sale Id 3737',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 14:50:01','',''),(2617323,'1','202','1036',477,'Retail Sale Id 3738',3001.28,0.00,0.00,4.52,280.24,'2022-04-15 14:50:54','',''),(2617324,'1','202','1036',477,'Retail Sale Id 3739',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 14:52:02','',''),(2617325,'1','202','1036',477,'Retail Sale Id 3740',498.00,0.00,0.00,0.75,46.50,'2022-04-15 14:54:46','',''),(2617326,'1','202','1036',477,'Retail Sale Id 3741',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 14:57:33','',''),(2617327,'1','202','1036',477,'Retail Sale Id 3742',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 15:05:02','',''),(2617328,'1','202','1036',477,'Retail Sale Id 3743',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 15:06:13','',''),(2617329,'1','202','1036',477,'Retail Sale Id 3744',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 15:06:56','',''),(2617330,'1','202','1036',477,'Retail Sale Id 3745',16600.00,0.00,0.00,25.00,1550.00,'2022-04-15 15:18:57','',''),(2617331,'1','202','1036',477,'Retail Sale Id 3746',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 15:19:58','',''),(2617332,'1','202','1036',477,'Retail Sale Id 3747',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 15:23:47','',''),(2617333,'1','202','1036',477,'Retail Sale Id 3748',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 15:28:09','',''),(2617334,'1','202','1036',477,'Retail Sale Id 3749',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 15:32:58','',''),(2617335,'1','202','1036',477,'Retail Sale Id 3750',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 15:34:03','',''),(2617336,'1','202','1036',477,'Retail Sale Id 3751',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 15:43:06','',''),(2617337,'1','202','1036',477,'Retail Sale Id 3752',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 15:45:17','',''),(2617338,'1','202','1036',477,'Retail Sale Id 3753',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 15:49:21','',''),(2617339,'1','202','1036',477,'Retail Sale Id 3754',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 15:56:09','',''),(2617340,'1','202','1036',477,'Retail Sale Id 3755',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 15:56:59','',''),(2617341,'1','202','1036',477,'Retail Sale Id 3756',3001.28,0.00,0.00,4.52,280.24,'2022-04-15 15:57:44','',''),(2617342,'1','202','1036',477,'Retail Sale Id 3757',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 15:58:31','',''),(2617343,'1','202','1036',477,'Retail Sale Id 3758',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 16:01:20','',''),(2617344,'1','202','1036',477,'Retail Sale Id 3759',796.80,0.00,0.00,1.20,74.40,'2022-04-15 16:02:53','',''),(2617345,'1','202','1036',477,'Retail Sale Id 3760',3001.28,0.00,0.00,4.52,280.24,'2022-04-15 16:07:01','',''),(2617346,'1','202','1036',477,'Retail Sale Id 3761',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 16:09:39','',''),(2617347,'1','202','1036',477,'Retail Sale Id 3762',2802.08,0.00,0.00,4.22,261.64,'2022-04-15 16:10:32','',''),(2617348,'1','202','1036',477,'Retail Sale Id 3764',2503.28,0.00,0.00,3.77,233.74,'2022-04-15 16:12:26','',''),(2617349,'1','202','1036',477,'Retail Sale Id 3763',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 16:13:40','',''),(2617350,'1','202','1036',477,'Retail Sale Id 3766',4501.92,0.00,0.00,6.78,420.36,'2022-04-15 16:18:34','',''),(2617351,'1','202','1036',477,'Retail Sale Id 3768',498.00,0.00,0.00,0.75,46.50,'2022-04-15 16:19:43','',''),(2617352,'1','202','1036',477,'Retail Sale Id 3769',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 16:21:41','',''),(2617353,'1','202','1036',477,'Retail Sale Id 3770',1347.92,0.00,0.00,2.03,125.86,'2022-04-15 16:22:53','',''),(2617354,'1','202','1036',477,'Retail Sale Id 3771',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 16:27:12','',''),(2617355,'1','202','1036',477,'Retail Sale Id 3772',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 16:28:28','',''),(2617356,'1','202','1036',477,'Retail Sale Id 3773',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 16:41:15','',''),(2617357,'1','202','1036',477,'Retail Sale Id 3774',1102.24,0.00,0.00,1.66,102.92,'2022-04-15 16:42:57','',''),(2617358,'1','202','1036',477,'Retail Sale Id 3775',697.20,0.00,0.00,1.05,65.10,'2022-04-15 16:48:19','',''),(2617359,'1','202','1036',477,'Retail Sale Id 3776',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 17:02:04','',''),(2617360,'1','202','1036',477,'Retail Sale Id 3777',3001.28,0.00,0.00,4.52,280.24,'2022-04-15 17:02:52','',''),(2617361,'1','202','1036',477,'Retail Sale Id 3778',1002.64,0.00,0.00,1.51,93.62,'2022-04-15 17:03:43','',''),(2617362,'1','202','1036',477,'Retail Sale Id 3781',6002.56,0.00,0.00,9.04,560.48,'2022-04-15 17:07:35','',''),(2617363,'1','202','1036',477,'Retail Sale Id 3782',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 17:08:55','',''),(2617364,'1','202','1036',477,'Retail Sale Id 3783',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 17:12:01','',''),(2617365,'1','202','1036',477,'Retail Sale Id 3784',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 17:17:41','',''),(2617366,'1','202','1036',477,'Retail Sale Id 3785',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 17:22:09','',''),(2617367,'1','202','1036',477,'Retail Sale Id 3786',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 17:23:27','',''),(2617368,'1','202','1036',477,'Retail Sale Id 3787',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 17:41:40','',''),(2617369,'1','202','1036',477,'Retail Sale Id 3788',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 17:45:29','',''),(2617370,'1','202','1036',477,'Retail Sale Id 3789',3001.28,0.00,0.00,4.52,280.24,'2022-04-15 17:48:51','',''),(2617371,'1','202','1036',477,'Retail Sale Id 3790',2802.08,0.00,0.00,4.22,261.64,'2022-04-15 18:01:44','',''),(2617372,'1','202','1036',477,'Retail Sale Id 3791',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 18:07:05','',''),(2617373,'1','202','1036',477,'Retail Sale Id 3792',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 18:12:27','',''),(2617374,'1','202','1036',477,'Retail Sale Id 3793',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 18:13:36','',''),(2617375,'1','202','1036',477,'Retail Sale Id 3794',8300.00,0.00,0.00,12.50,775.00,'2022-04-15 18:14:34','',''),(2617376,'1','202','1036',477,'Retail Sale Id 3795',750.32,0.00,0.00,1.13,70.06,'2022-04-15 18:15:58','',''),(2617377,'1','202','1036',477,'Retail Sale Id 3796',3353.20,0.00,0.00,5.05,313.10,'2022-04-15 18:16:34','',''),(2617378,'1','202','1036',477,'Retail Sale Id 3797',3001.28,0.00,0.00,4.52,280.24,'2022-04-15 18:18:34','',''),(2617379,'1','202','1036',477,'Retail Sale Id 3798',1998.64,0.00,0.00,3.01,186.62,'2022-04-15 18:23:38','',''),(2617380,'1','202','1036',477,'Retail Sale Id 3799',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 18:39:58','',''),(2617381,'1','202','1036',477,'Retail Sale Id 3800',3997.28,0.00,0.00,6.02,373.24,'2022-04-15 18:42:04','',''),(2617382,'1','202','1036',477,'Retail Sale Id 3801',1347.92,0.00,0.00,2.03,125.86,'2022-04-15 18:46:07','',''),(2617383,'1','202','1036',477,'Retail Sale Id 3802',1500.64,0.00,0.00,2.26,140.12,'2022-04-15 18:48:21','',''),(2617384,'1','202','1036',477,'Retail Sale Id 3803',697.20,0.00,0.00,1.05,65.10,'2022-04-15 18:54:58','',''),(2617385,'1','202','1036',477,'Return of Retail Sale Id 3740',0.00,498.00,0.75,0.00,-46.50,'2022-04-15 19:26:20','',''),(2617386,'1','202','1036',477,'Retail Sale Id 3804',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 07:00:24','',''),(2617387,'1','202','1036',477,'Retail Sale Id 3805',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 07:06:30','',''),(2617388,'1','202','1036',477,'Retail Sale Id 3806',3499.28,0.00,0.00,5.27,326.74,'2022-04-16 07:08:46','',''),(2617389,'1','202','1036',477,'Retail Sale Id 3807',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 07:29:45','',''),(2617390,'1','202','1036',477,'Retail Sale Id 3808',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 07:37:19','',''),(2617391,'1','202','1036',477,'Retail Sale Id 3809',3353.20,0.00,0.00,5.05,313.10,'2022-04-16 07:38:21','',''),(2617392,'1','202','1036',477,'Retail Sale Id 3810',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 07:39:02','',''),(2617393,'1','202','1036',477,'Retail Sale Id 3811',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 07:47:24','',''),(2617394,'1','202','1036',477,'Retail Sale Id 3812',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 07:52:41','',''),(2617395,'1','202','1036',477,'Retail Sale Id 3813',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 07:54:52','',''),(2617396,'1','202','1036',477,'Retail Sale Id 3814',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 07:56:41','',''),(2617397,'1','202','1036',477,'Retail Sale Id 3815',1401.04,0.00,0.00,2.11,130.82,'2022-04-16 08:02:16','',''),(2617398,'1','202','1036',477,'Retail Sale Id 3816',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 08:20:03','',''),(2617399,'1','202','1036',477,'Retail Sale Id 3817',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 08:27:11','',''),(2617400,'1','202','1036',477,'Retail Sale Id 3818',1401.04,0.00,0.00,2.11,130.82,'2022-04-16 08:30:19','',''),(2617401,'1','202','1036',477,'Retail Sale Id 3819',498.00,0.00,0.00,0.75,46.50,'2022-04-16 08:31:33','',''),(2617402,'1','202','1036',477,'Retail Sale Id 3820',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 08:32:33','',''),(2617403,'1','202','1036',477,'Retail Sale Id 3821',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 08:33:30','',''),(2617404,'1','202','1036',477,'Retail Sale Id 3822',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 08:34:14','',''),(2617405,'1','202','1036',477,'Retail Sale Id 3823',1699.84,0.00,0.00,2.56,158.72,'2022-04-16 08:35:37','',''),(2617406,'1','202','1036',477,'Retail Sale Id 3824',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 08:36:25','',''),(2617407,'1','202','1036',477,'Retail Sale Id 3825',1347.92,0.00,0.00,2.03,125.86,'2022-04-16 08:37:57','',''),(2617408,'1','202','1036',477,'Retail Sale Id 3826',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 08:39:54','',''),(2617409,'1','202','1036',477,'Retail Sale Id 3827',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 08:42:49','',''),(2617410,'1','202','1036',477,'Retail Sale Id 3828',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 08:43:24','',''),(2617411,'1','202','1036',477,'Retail Sale Id 3829',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 08:44:08','',''),(2617412,'1','202','1036',477,'Retail Sale Id 3830',3353.20,0.00,0.00,5.05,313.10,'2022-04-16 08:45:18','',''),(2617413,'1','202','1036',477,'Retail Sale Id 3831',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 08:48:05','',''),(2617414,'1','202','1036',477,'Retail Sale Id 3832',7396.96,0.00,0.00,11.14,690.68,'2022-04-16 08:49:50','',''),(2617415,'1','202','1036',477,'Retail Sale Id 3833',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 08:50:55','',''),(2617416,'1','202','1036',477,'Retail Sale Id 3834',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 08:53:50','',''),(2617417,'1','202','1036',477,'Retail Sale Id 3835',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 09:03:41','',''),(2617418,'1','202','1036',477,'Retail Sale Id 3836',597.60,0.00,0.00,0.90,55.80,'2022-04-16 09:05:23','',''),(2617419,'1','202','1036',477,'Retail Sale Id 3837',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 09:07:02','',''),(2617420,'1','202','1036',477,'Retail Sale Id 3838',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 09:11:35','',''),(2617421,'1','202','1036',477,'Retail Sale Id 3840',1799.44,0.00,0.00,2.71,168.02,'2022-04-16 09:15:38','',''),(2617422,'1','202','1036',477,'Retail Sale Id 3841',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 09:16:18','',''),(2617423,'1','202','1036',477,'Retail Sale Id 3843',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 09:23:49','',''),(2617424,'1','202','1036',477,'Retail Sale Id 3845',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 09:25:50','',''),(2617425,'1','202','1036',477,'Retail Sale Id 3846',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 09:26:41','',''),(2617426,'1','202','1036',477,'Retail Sale Id 3844',4999.92,0.00,0.00,7.53,466.86,'2022-04-16 09:27:17','',''),(2617427,'1','202','1036',477,'Retail Sale Id 3847',3698.48,0.00,0.00,5.57,345.34,'2022-04-16 09:32:07','',''),(2617428,'1','202','1036',477,'Retail Sale Id 3848',3698.48,0.00,0.00,5.57,345.34,'2022-04-16 09:32:58','',''),(2617429,'1','202','1036',477,'Retail Sale Id 3849',2656.00,0.00,0.00,4.00,248.00,'2022-04-16 09:34:36','',''),(2617430,'1','202','1036',477,'Retail Sale Id 3850',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 09:35:22','',''),(2617431,'1','202','1036',477,'Retail Sale Id 3842',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 09:35:59','',''),(2617432,'1','202','1036',477,'Retail Sale Id 3851',2503.28,0.00,0.00,3.77,233.74,'2022-04-16 09:39:17','',''),(2617433,'1','202','1036',477,'Retail Sale Id 3852',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 09:41:17','',''),(2617434,'1','202','1036',477,'Retail Sale Id 3853',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 09:42:28','',''),(2617435,'1','202','1036',477,'Retail Sale Id 3854',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 09:46:50','',''),(2617436,'1','202','1036',477,'Retail Sale Id 3855',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 09:47:32','',''),(2617437,'1','202','1036',477,'Retail Sale Id 3856',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 09:52:55','',''),(2617438,'1','202','1036',477,'Retail Sale Id 3857',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 09:54:23','',''),(2617439,'1','202','1036',477,'Retail Sale Id 3858',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 09:55:00','',''),(2617440,'1','202','1036',477,'Retail Sale Id 3859',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 09:55:42','',''),(2617441,'1','202','1036',477,'Retail Sale Id 3860',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 10:02:20','',''),(2617442,'1','202','1036',477,'Retail Sale Id 3861',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 10:14:49','',''),(2617443,'1','202','1036',477,'Retail Sale Id 3862',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 10:15:35','',''),(2617444,'1','202','1036',477,'Retail Sale Id 3863',1799.44,0.00,0.00,2.71,168.02,'2022-04-16 10:21:09','',''),(2617445,'1','202','1036',477,'Retail Sale Id 3864',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 10:25:11','',''),(2617446,'1','202','1036',477,'Retail Sale Id 3865',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 10:30:44','',''),(2617447,'1','202','1036',477,'Retail Sale Id 3866',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 10:32:43','',''),(2617448,'1','202','1036',477,'Retail Sale Id 3867',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 10:34:12','',''),(2617449,'1','202','1036',477,'Retail Sale Id 3868',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 10:35:42','',''),(2617450,'1','202','1036',477,'Retail Sale Id 3869',3353.20,0.00,0.00,5.05,313.10,'2022-04-16 10:37:02','',''),(2617451,'1','202','1036',477,'Retail Sale Id 3870',1201.84,0.00,0.00,1.81,112.22,'2022-04-16 10:37:44','',''),(2617452,'1','202','1036',477,'Retail Sale Id 3871',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 10:38:34','',''),(2617453,'1','202','1036',477,'Retail Sale Id 3872',3353.20,0.00,0.00,5.05,313.10,'2022-04-16 10:41:19','',''),(2617454,'1','202','1036',477,'Retail Sale Id 3873',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 10:43:16','',''),(2617455,'1','202','1036',477,'Retail Sale Id 3874',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 10:48:29','',''),(2617456,'1','202','1036',477,'Retail Sale Id 3875',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 10:51:13','',''),(2617457,'1','202','1036',477,'Retail Sale Id 3876',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 10:53:40','',''),(2617458,'1','202','1036',477,'Retail Sale Id 3877',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 10:56:56','',''),(2617459,'1','202','1036',477,'Retail Sale Id 3878',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 10:58:59','',''),(2617460,'1','202','1036',477,'Retail Sale Id 3879',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 11:05:24','',''),(2617461,'1','202','1036',477,'Retail Sale Id 3880',2503.28,0.00,0.00,3.77,233.74,'2022-04-16 11:06:17','',''),(2617462,'1','202','1036',477,'Retail Sale Id 3881',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 11:20:50','',''),(2617463,'1','202','1036',477,'Retail Sale Id 3882',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 11:22:00','',''),(2617464,'1','202','1036',477,'Retail Sale Id 3883',2297.44,0.00,0.00,3.46,214.52,'2022-04-16 11:25:35','',''),(2617465,'1','202','1036',477,'Retail Sale Id 3884',7304.00,0.00,0.00,11.00,682.00,'2022-04-16 11:27:21','',''),(2617466,'1','202','1036',477,'Retail Sale Id 3885',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 11:28:37','',''),(2617467,'1','202','1036',477,'Retail Sale Id 3886',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 11:32:28','',''),(2617468,'1','202','1036',477,'Retail Sale Id 3887',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 11:38:42','',''),(2617469,'1','202','1036',477,'Retail Sale Id 3888',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 11:40:18','',''),(2617470,'1','202','1036',477,'Retail Sale Id 3889',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 11:42:40','',''),(2617471,'1','202','1036',477,'Retail Sale Id 3890',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 11:55:34','',''),(2617472,'1','202','1036',477,'Retail Sale Id 3891',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 11:56:40','',''),(2617473,'1','202','1036',477,'Retail Sale Id 3892',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 12:06:10','',''),(2617474,'1','202','1036',477,'Retail Sale Id 3893',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 12:06:47','',''),(2617475,'1','202','1036',477,'Retail Sale Id 3894',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 12:13:23','',''),(2617476,'1','202','1036',477,'Retail Sale Id 3895',2503.28,0.00,0.00,3.77,233.74,'2022-04-16 12:17:26','',''),(2617477,'1','202','1036',477,'Retail Sale Id 3896',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 12:18:48','',''),(2617478,'1','202','1036',477,'Retail Sale Id 3897',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 12:33:10','',''),(2617479,'1','202','1036',477,'Retail Sale Id 3898',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 12:39:53','',''),(2617480,'1','202','1036',477,'Retail Sale Id 3899',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 12:47:14','',''),(2617481,'1','202','1036',477,'Retail Sale Id 3900',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 12:55:04','',''),(2617482,'1','202','1036',477,'Retail Sale Id 3901',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 12:59:57','',''),(2617483,'1','202','1036',477,'Retail Sale Id 3902',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 13:06:58','',''),(2617484,'1','202','1036',477,'Retail Sale Id 3903',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 13:21:51','',''),(2617485,'1','202','1036',477,'Retail Sale Id 3905',498.00,0.00,0.00,0.75,46.50,'2022-04-16 13:22:33','',''),(2617486,'1','202','1036',477,'Retail Sale Id 3906',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 13:24:24','',''),(2617487,'1','202','1036',477,'Retail Sale Id 3908',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 13:25:45','',''),(2617488,'1','202','1036',477,'Retail Sale Id 3910',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 13:30:29','',''),(2617489,'1','202','1036',477,'Retail Sale Id 3911',1347.92,0.00,0.00,2.03,125.86,'2022-04-16 13:33:37','',''),(2617490,'1','202','1036',477,'Retail Sale Id 3913',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 13:40:02','',''),(2617491,'1','202','1036',477,'Retail Sale Id 3915',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 13:40:45','',''),(2617492,'1','202','1036',477,'Retail Sale Id 3916',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 13:42:02','',''),(2617493,'1','202','1036',477,'Retail Sale Id 3918',2503.28,0.00,0.00,3.77,233.74,'2022-04-16 13:42:48','',''),(2617494,'1','202','1036',477,'Retail Sale Id 3920',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 13:43:26','',''),(2617495,'1','202','1036',477,'Retail Sale Id 3921',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 13:44:28','',''),(2617496,'1','202','1036',477,'Retail Sale Id 3924',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 13:45:41','',''),(2617497,'1','202','1036',477,'Retail Sale Id 3926',2503.28,0.00,0.00,3.77,233.74,'2022-04-16 13:49:43','',''),(2617498,'1','202','1036',477,'Retail Sale Id 3930',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 14:04:56','',''),(2617499,'1','202','1036',477,'Retail Sale Id 3932',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 14:08:46','',''),(2617500,'1','202','1036',477,'Retail Sale Id 3933',3300.08,0.00,0.00,4.97,308.14,'2022-04-16 14:13:15','',''),(2617501,'1','202','1036',477,'Retail Sale Id 3934',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 14:16:41','',''),(2617502,'1','202','1036',477,'Retail Sale Id 3935',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 14:17:48','',''),(2617503,'1','202','1036',477,'Retail Sale Id 3936',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 14:18:37','',''),(2617504,'1','202','1036',477,'Retail Sale Id 3938',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 14:19:24','',''),(2617505,'1','202','1036',477,'Retail Sale Id 3939',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 14:24:39','',''),(2617506,'1','202','1036',477,'Retail Sale Id 3940',4999.92,0.00,0.00,7.53,466.86,'2022-04-16 14:30:10','',''),(2617507,'1','202','1036',477,'Retail Sale Id 3941',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 14:31:21','',''),(2617508,'1','202','1036',477,'Retail Sale Id 3942',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 14:32:47','',''),(2617509,'1','202','1036',477,'Retail Sale Id 3943',2702.48,0.00,0.00,4.07,252.34,'2022-04-16 14:45:49','',''),(2617510,'1','202','1036',477,'Retail Sale Id 3944',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 14:46:50','',''),(2617511,'1','202','1036',477,'Retail Sale Id 3945',498.00,0.00,0.00,0.75,46.50,'2022-04-16 14:52:27','',''),(2617512,'1','202','1036',477,'Retail Sale Id 3947',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 14:53:48','',''),(2617513,'1','202','1036',477,'Retail Sale Id 3948',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 14:54:46','',''),(2617514,'1','202','1036',477,'Retail Sale Id 3949',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 14:55:54','',''),(2617515,'1','202','1036',477,'Retail Sale Id 3950',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 15:04:30','',''),(2617516,'1','202','1036',477,'Retail Sale Id 3951',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 15:06:05','',''),(2617517,'1','202','1036',477,'Retail Sale Id 3952',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 15:07:32','',''),(2617518,'1','202','1036',477,'Retail Sale Id 3954',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 15:08:28','',''),(2617519,'1','202','1036',477,'Retail Sale Id 3955',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 15:09:11','',''),(2617520,'1','202','1036',477,'Retail Sale Id 3957',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 15:10:04','',''),(2617521,'1','202','1036',477,'Retail Sale Id 3960',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 15:10:47','',''),(2617522,'1','202','1036',477,'Retail Sale Id 3962',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 15:11:53','',''),(2617523,'1','202','1036',477,'Retail Sale Id 3963',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 15:22:33','',''),(2617524,'1','202','1036',477,'Retail Sale Id 3964',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 15:34:36','',''),(2617525,'1','202','1036',477,'Retail Sale Id 3965',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 15:37:02','',''),(2617526,'1','202','1036',477,'Retail Sale Id 3966',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 15:39:12','',''),(2617527,'1','202','1036',477,'Retail Sale Id 3968',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 15:43:21','',''),(2617528,'1','202','1036',477,'Retail Sale Id 3969',1799.44,0.00,0.00,2.71,168.02,'2022-04-16 15:44:32','',''),(2617529,'1','202','1036',477,'Retail Sale Id 3970',6002.56,0.00,0.00,9.04,560.48,'2022-04-16 15:54:30','',''),(2617530,'1','202','1036',477,'Retail Sale Id 3971',2702.48,0.00,0.00,4.07,252.34,'2022-04-16 15:55:36','',''),(2617531,'1','202','1036',477,'Retail Sale Id 3972',1301.44,0.00,0.00,1.96,121.52,'2022-04-16 15:59:25','',''),(2617532,'1','202','1036',477,'Retail Sale Id 3973',4999.92,0.00,0.00,7.53,466.86,'2022-04-16 16:00:32','',''),(2617533,'1','202','1036',477,'Retail Sale Id 3976',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 16:02:41','',''),(2617534,'1','202','1036',477,'Retail Sale Id 3978',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 16:03:28','',''),(2617535,'1','202','1036',477,'Retail Sale Id 3979',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 16:06:02','',''),(2617536,'1','202','1036',477,'Retail Sale Id 3981',2702.48,0.00,0.00,4.07,252.34,'2022-04-16 16:07:04','',''),(2617537,'1','202','1036',477,'Retail Sale Id 3982',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 16:07:45','',''),(2617538,'1','202','1036',477,'Retail Sale Id 3985',1301.44,0.00,0.00,1.96,121.52,'2022-04-16 16:26:50','',''),(2617539,'1','202','1036',477,'Retail Sale Id 3986',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 16:33:35','',''),(2617540,'1','202','1036',477,'Retail Sale Id 3988',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 16:34:27','',''),(2617541,'1','202','1036',477,'Retail Sale Id 3989',2503.28,0.00,0.00,3.77,233.74,'2022-04-16 16:36:16','',''),(2617542,'1','202','1036',477,'Retail Sale Id 3992',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 16:37:27','',''),(2617543,'1','202','1036',477,'Retail Sale Id 3993',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 16:44:19','',''),(2617544,'1','202','1036',477,'Retail Sale Id 3995',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 16:48:43','',''),(2617545,'1','202','1036',477,'Retail Sale Id 3997',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 16:49:25','',''),(2617546,'1','202','1036',477,'Retail Sale Id 3998',697.20,0.00,0.00,1.05,65.10,'2022-04-16 16:51:20','',''),(2617547,'1','202','1036',477,'Retail Sale Id 3999',41832.00,0.00,0.00,63.00,3906.00,'2022-04-16 16:55:04','',''),(2617548,'1','202','1036',477,'Retail Sale Id 4001',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 16:56:37','',''),(2617549,'1','202','1036',477,'Retail Sale Id 4002',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 16:57:26','',''),(2617550,'1','202','1036',477,'Retail Sale Id 4004',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 16:58:06','',''),(2617551,'1','202','1036',477,'Retail Sale Id 4006',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 16:58:48','',''),(2617552,'1','202','1036',477,'Retail Sale Id 4007',498.00,0.00,0.00,0.75,46.50,'2022-04-16 16:59:42','',''),(2617553,'1','202','1036',477,'Retail Sale Id 4008',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 17:00:39','',''),(2617554,'1','202','1036',477,'Retail Sale Id 4010',16600.00,0.00,0.00,25.00,1550.00,'2022-04-16 17:02:18','',''),(2617555,'1','202','1036',477,'Retail Sale Id 4012',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 17:04:34','',''),(2617556,'1','202','1036',477,'Retail Sale Id 4014',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 17:06:23','',''),(2617557,'1','202','1036',477,'Retail Sale Id 4016',2503.28,0.00,0.00,3.77,233.74,'2022-04-16 17:07:01','',''),(2617558,'1','202','1036',477,'Retail Sale Id 4018',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 17:07:40','',''),(2617559,'1','202','1036',477,'Retail Sale Id 4019',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 17:09:50','',''),(2617560,'1','202','1036',477,'Retail Sale Id 4022',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 17:13:44','',''),(2617561,'1','202','1036',477,'Retail Sale Id 4024',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 17:19:32','',''),(2617562,'1','202','1036',477,'Retail Sale Id 4025',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 17:25:52','',''),(2617563,'1','202','1036',477,'Retail Sale Id 4026',2503.28,0.00,0.00,3.77,233.74,'2022-04-16 17:27:04','',''),(2617564,'1','202','1036',477,'Retail Sale Id 4028',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 17:28:03','',''),(2617565,'1','202','1036',477,'Retail Sale Id 4029',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 17:28:54','',''),(2617566,'1','202','1036',477,'Retail Sale Id 4030',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 17:30:41','',''),(2617567,'1','202','1036',477,'Retail Sale Id 4031',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 17:32:12','',''),(2617568,'1','202','1036',477,'Retail Sale Id 4032',2702.48,0.00,0.00,4.07,252.34,'2022-04-16 17:34:48','',''),(2617569,'1','202','1036',477,'Retail Sale Id 4034',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 17:36:20','',''),(2617570,'1','202','1036',477,'Retail Sale Id 4035',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 17:41:25','',''),(2617571,'1','202','1036',477,'Retail Sale Id 4037',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 17:43:29','',''),(2617572,'1','202','1036',477,'Retail Sale Id 4038',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 17:46:56','',''),(2617573,'1','202','1036',477,'Retail Sale Id 4039',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 17:48:38','',''),(2617574,'1','202','1036',477,'Retail Sale Id 4040',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 17:49:19','',''),(2617575,'1','202','1036',477,'Retail Sale Id 4041',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 17:50:44','',''),(2617576,'1','202','1036',477,'Retail Sale Id 4042',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 17:52:13','',''),(2617577,'1','202','1036',477,'Retail Sale Id 4043',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 17:54:28','',''),(2617578,'1','202','1036',477,'Retail Sale Id 4045',6653.28,0.00,0.00,10.02,621.24,'2022-04-16 17:57:24','',''),(2617579,'1','202','1036',477,'Retail Sale Id 4047',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 17:59:22','',''),(2617580,'1','202','1036',477,'Retail Sale Id 4048',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 18:01:01','',''),(2617581,'1','202','1036',477,'Retail Sale Id 4049',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 18:02:28','',''),(2617582,'1','202','1036',477,'Retail Sale Id 4050',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 18:04:44','',''),(2617583,'1','202','1036',477,'Retail Sale Id 4051',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 18:05:49','',''),(2617584,'1','202','1036',477,'Retail Sale Id 4052',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 18:08:30','',''),(2617585,'1','202','1036',477,'Retail Sale Id 4054',1201.84,0.00,0.00,1.81,112.22,'2022-04-16 18:15:01','',''),(2617586,'1','202','1036',477,'Retail Sale Id 4055',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 18:16:21','',''),(2617587,'1','202','1036',477,'Retail Sale Id 4057',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 18:17:11','',''),(2617588,'1','202','1036',477,'Retail Sale Id 4059',3001.28,0.00,0.00,4.52,280.24,'2022-04-16 18:17:49','',''),(2617589,'1','202','1036',477,'Retail Sale Id 4060',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 18:21:58','',''),(2617590,'1','202','1036',477,'Retail Sale Id 4061',2802.08,0.00,0.00,4.22,261.64,'2022-04-16 18:26:41','',''),(2617591,'1','202','1036',477,'Retail Sale Id 4062',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 18:28:24','',''),(2617592,'1','202','1036',477,'Retail Sale Id 4063',3997.28,0.00,0.00,6.02,373.24,'2022-04-16 18:29:49','',''),(2617593,'1','202','1036',477,'Retail Sale Id 4064',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 18:30:55','',''),(2617594,'1','202','1036',477,'Retail Sale Id 4065',6699.76,0.00,0.00,10.09,625.58,'2022-04-16 18:32:37','',''),(2617595,'1','202','1036',477,'Retail Sale Id 4066',6699.76,0.00,0.00,10.09,625.58,'2022-04-16 18:33:58','',''),(2617596,'1','202','1036',477,'Retail Sale Id 4068',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 18:34:52','',''),(2617597,'1','202','1036',477,'Retail Sale Id 4069',1347.92,0.00,0.00,2.03,125.86,'2022-04-16 18:35:50','',''),(2617598,'1','202','1036',477,'Retail Sale Id 4071',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 18:36:57','',''),(2617599,'1','202','1036',477,'Retail Sale Id 4072',8300.00,0.00,0.00,12.50,775.00,'2022-04-16 18:38:23','',''),(2617600,'1','202','1036',477,'Retail Sale Id 4074',1998.64,0.00,0.00,3.01,186.62,'2022-04-16 18:40:41','',''),(2617601,'1','202','1036',477,'Retail Sale Id 4075',1347.92,0.00,0.00,2.03,125.86,'2022-04-16 18:41:58','',''),(2617602,'1','202','1036',477,'Retail Sale Id 4077',6500.56,0.00,0.00,9.79,606.98,'2022-04-16 18:45:36','',''),(2617603,'1','202','1036',477,'Retail Sale Id 4078',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 18:47:48','',''),(2617604,'1','202','1036',477,'Retail Sale Id 4079',1002.64,0.00,0.00,1.51,93.62,'2022-04-16 19:00:06','',''),(2617605,'1','202','1036',477,'Retail Sale Id 4080',4501.92,0.00,0.00,6.78,420.36,'2022-04-16 19:00:58','',''),(2617606,'1','202','1036',477,'Retail Sale Id 4081',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 19:01:42','',''),(2617607,'1','202','1036',477,'Retail Sale Id 4082',1500.64,0.00,0.00,2.26,140.12,'2022-04-16 19:02:33','',''),(2617608,'1','202','1036',477,'Return of Retail Sale Id 4074',0.00,1998.64,3.01,0.00,-186.62,'2022-04-16 19:30:22','',''),(2617609,'1','202','1036',477,'Retail Sale Id 4083',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 06:56:37','',''),(2617610,'1','202','1036',477,'Retail Sale Id 4084',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 06:57:45','',''),(2617611,'1','202','1036',477,'Retail Sale Id 4085',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 06:59:02','',''),(2617612,'1','202','1036',477,'Retail Sale Id 4089',2503.28,0.00,0.00,3.77,233.74,'2022-04-17 07:00:11','',''),(2617613,'1','202','1036',477,'Retail Sale Id 4090',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 07:08:12','',''),(2617614,'1','202','1036',477,'Retail Sale Id 4092',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 07:13:05','',''),(2617615,'1','202','1036',477,'Retail Sale Id 4093',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 07:19:40','',''),(2617616,'1','202','1036',477,'Retail Sale Id 4094',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 07:26:26','',''),(2617617,'1','202','1036',477,'Retail Sale Id 4095',1401.04,0.00,0.00,2.11,130.82,'2022-04-17 07:28:16','',''),(2617618,'1','202','1036',477,'Retail Sale Id 4096',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 07:30:40','',''),(2617619,'1','202','1036',477,'Retail Sale Id 4097',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 07:35:57','',''),(2617620,'1','202','1036',477,'Retail Sale Id 4098',1347.92,0.00,0.00,2.03,125.86,'2022-04-17 07:38:26','',''),(2617621,'1','202','1036',477,'Retail Sale Id 4099',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 07:39:22','',''),(2617622,'1','202','1036',477,'Retail Sale Id 4100',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 07:40:27','',''),(2617623,'1','202','1036',477,'Retail Sale Id 4101',6799.36,0.00,0.00,10.24,634.88,'2022-04-17 07:50:49','',''),(2617624,'1','202','1036',477,'Retail Sale Id 4103',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 07:51:51','',''),(2617625,'1','202','1036',477,'Retail Sale Id 4104',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 07:53:18','',''),(2617626,'1','202','1036',477,'Retail Sale Id 4105',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 07:58:17','',''),(2617627,'1','202','1036',477,'Retail Sale Id 4107',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 07:58:57','',''),(2617628,'1','202','1036',477,'Retail Sale Id 4108',1699.84,0.00,0.00,2.56,158.72,'2022-04-17 08:03:07','',''),(2617629,'1','202','1036',477,'Retail Sale Id 4109',1347.92,0.00,0.00,2.03,125.86,'2022-04-17 08:04:46','',''),(2617630,'1','202','1036',477,'Retail Sale Id 4111',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 08:05:57','',''),(2617631,'1','202','1036',477,'Retail Sale Id 4112',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 08:07:21','',''),(2617632,'1','202','1036',477,'Retail Sale Id 4113',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 08:10:50','',''),(2617633,'1','202','1036',477,'Retail Sale Id 4114',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 08:12:45','',''),(2617634,'1','202','1036',477,'Retail Sale Id 4116',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 08:13:24','',''),(2617635,'1','202','1036',477,'Retail Sale Id 4118',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 08:14:11','',''),(2617636,'1','202','1036',477,'Retail Sale Id 4119',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 08:15:16','',''),(2617637,'1','202','1036',477,'Retail Sale Id 4120',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 08:16:12','',''),(2617638,'1','202','1036',477,'Retail Sale Id 4122',1347.92,0.00,0.00,2.03,125.86,'2022-04-17 08:17:09','',''),(2617639,'1','202','1036',477,'Retail Sale Id 4124',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 08:21:14','',''),(2617640,'1','202','1036',477,'Retail Sale Id 4125',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 08:23:16','',''),(2617641,'1','202','1036',477,'Retail Sale Id 4127',8300.00,0.00,0.00,12.50,775.00,'2022-04-17 08:24:04','',''),(2617642,'1','202','1036',477,'Retail Sale Id 4128',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 08:24:55','',''),(2617643,'1','202','1036',477,'Retail Sale Id 4131',1401.04,0.00,0.00,2.11,130.82,'2022-04-17 08:25:41','',''),(2617644,'1','202','1036',477,'Retail Sale Id 4134',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 08:29:21','',''),(2617645,'1','202','1036',477,'Retail Sale Id 4135',6653.28,0.00,0.00,10.02,621.24,'2022-04-17 08:30:21','',''),(2617646,'1','202','1036',477,'Retail Sale Id 4136',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 08:31:51','',''),(2617647,'1','202','1036',477,'Retail Sale Id 4137',6653.28,0.00,0.00,10.02,621.24,'2022-04-17 08:35:52','',''),(2617648,'1','202','1036',477,'Retail Sale Id 4138',1799.44,0.00,0.00,2.71,168.02,'2022-04-17 08:43:07','',''),(2617649,'1','202','1036',477,'Retail Sale Id 4139',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 08:45:53','',''),(2617650,'1','202','1036',477,'Retail Sale Id 4140',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 08:47:41','',''),(2617651,'1','202','1036',477,'Retail Sale Id 4141',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 08:49:01','',''),(2617652,'1','202','1036',477,'Retail Sale Id 4143',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 08:49:55','',''),(2617653,'1','202','1036',477,'Retail Sale Id 4144',1301.44,0.00,0.00,1.96,121.52,'2022-04-17 08:52:13','',''),(2617654,'1','202','1036',477,'Retail Sale Id 4145',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 08:53:09','',''),(2617655,'1','202','1036',477,'Retail Sale Id 4148',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 08:54:48','',''),(2617656,'1','202','1036',477,'Retail Sale Id 4149',5312.00,0.00,0.00,8.00,496.00,'2022-04-17 08:57:11','',''),(2617657,'1','202','1036',477,'Retail Sale Id 4153',1347.92,0.00,0.00,2.03,125.86,'2022-04-17 08:59:07','',''),(2617658,'1','202','1036',477,'Retail Sale Id 4154',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 09:00:16','',''),(2617659,'1','202','1036',477,'Retail Sale Id 4156',6002.56,0.00,0.00,9.04,560.48,'2022-04-17 09:06:16','',''),(2617660,'1','202','1036',477,'Retail Sale Id 4157',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 09:07:19','',''),(2617661,'1','202','1036',477,'Retail Sale Id 4159',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 09:08:17','',''),(2617662,'1','202','1036',477,'Retail Sale Id 4161',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 09:09:07','',''),(2617663,'1','202','1036',477,'Retail Sale Id 4163',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 09:09:56','',''),(2617664,'1','202','1036',477,'Retail Sale Id 4165',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 09:10:38','',''),(2617665,'1','202','1036',477,'Retail Sale Id 4167',697.20,0.00,0.00,1.05,65.10,'2022-04-17 09:13:02','',''),(2617666,'1','202','1036',477,'Retail Sale Id 4169',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 09:13:51','',''),(2617667,'1','202','1036',477,'Retail Sale Id 4171',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 09:14:41','',''),(2617668,'1','202','1036',477,'Retail Sale Id 4172',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 09:16:21','',''),(2617669,'1','202','1036',477,'Retail Sale Id 4173',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 09:18:30','',''),(2617670,'1','202','1036',477,'Retail Sale Id 4174',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 09:21:34','',''),(2617671,'1','202','1036',477,'Retail Sale Id 4175',8300.00,0.00,0.00,12.50,775.00,'2022-04-17 09:23:53','',''),(2617672,'1','202','1036',477,'Retail Sale Id 4177',8001.20,0.00,0.00,12.05,747.10,'2022-04-17 09:25:52','',''),(2617673,'1','202','1036',477,'Retail Sale Id 4178',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 09:26:48','',''),(2617674,'1','202','1036',477,'Retail Sale Id 4179',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 09:27:37','',''),(2617675,'1','202','1036',477,'Retail Sale Id 4181',1347.92,0.00,0.00,2.03,125.86,'2022-04-17 09:29:03','',''),(2617676,'1','202','1036',477,'Retail Sale Id 4182',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 09:30:01','',''),(2617677,'1','202','1036',477,'Return of Retail Sale Id 4182',0.00,1998.64,3.01,0.00,-186.62,'2022-04-17 10:07:53','',''),(2617678,'1','202','1036',477,'Return of Retail Sale Id 4179',0.00,1002.64,1.51,0.00,-93.62,'2022-04-17 10:08:28','',''),(2617679,'1','202','1036',477,'Return of Retail Sale Id 4178',0.00,1002.64,1.51,0.00,-93.62,'2022-04-17 10:23:15','',''),(2617680,'1','202','1036',477,'Retail Sale Id 4183',398.40,0.00,0.00,0.60,37.20,'2022-04-17 11:00:17','',''),(2617681,'1','202','1036',477,'Distributed to operational loss for sales id:4',17861.34,0.00,0.00,29.67,0.00,'2022-04-17 11:08:16','',''),(2617682,'1','202',NULL,477,'Purchased from AA RANO NIGERIA LIMITED',0.00,1806000.00,3000.00,0.00,0.00,'2022-04-17 11:10:41','',''),(2617683,'1','202',NULL,477,'Reception corrector for bridging 7',0.00,0.00,0.00,3000.00,0.00,'2022-04-17 11:11:24','',''),(2617684,'1','202','1036',477,'Received from bridging 7',0.00,0.00,3000.00,0.00,0.00,'2022-04-17 11:11:24','',''),(2617685,'1','202','1036',477,'Retail Sale Id 4185',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 11:13:07','',''),(2617686,'1','202','1036',477,'Retail Sale Id 4186',8300.00,0.00,0.00,12.50,775.00,'2022-04-17 11:17:02','',''),(2617687,'1','202','1036',477,'Retail Sale Id 4187',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 11:17:53','',''),(2617688,'1','202','1036',477,'Retail Sale Id 4188',2197.84,0.00,0.00,3.31,205.22,'2022-04-17 11:18:49','',''),(2617689,'1','202','1036',477,'Retail Sale Id 4189',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 11:21:34','',''),(2617690,'1','202','1036',477,'Retail Sale Id 4190',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 11:22:33','',''),(2617691,'1','202','1036',477,'Retail Sale Id 4191',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 11:24:15','',''),(2617692,'1','202','1036',477,'Retail Sale Id 4194',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 11:25:50','',''),(2617693,'1','202','1036',477,'Retail Sale Id 4196',3499.28,0.00,0.00,5.27,326.74,'2022-04-17 11:26:43','',''),(2617694,'1','202','1036',477,'Retail Sale Id 4198',1201.84,0.00,0.00,1.81,112.22,'2022-04-17 11:28:08','',''),(2617695,'1','202','1036',477,'Retail Sale Id 4200',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 11:28:48','',''),(2617696,'1','202','1036',477,'Retail Sale Id 4201',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 11:32:05','',''),(2617697,'1','202','1036',477,'Retail Sale Id 4202',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 11:33:34','',''),(2617698,'1','202','1036',477,'Retail Sale Id 4203',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 11:34:03','',''),(2617699,'1','202','1036',477,'Retail Sale Id 4205',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 11:40:26','',''),(2617700,'1','202','1036',477,'Retail Sale Id 4207',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 11:42:34','',''),(2617701,'1','202','1036',477,'Retail Sale Id 4209',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 11:43:34','',''),(2617702,'1','202','1036',477,'Retail Sale Id 4210',1347.92,0.00,0.00,2.03,125.86,'2022-04-17 11:44:12','',''),(2617703,'1','202','1036',477,'Retail Sale Id 4211',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 11:44:54','',''),(2617704,'1','202','1036',477,'Retail Sale Id 4212',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 11:45:32','',''),(2617705,'1','202','1036',477,'Retail Sale Id 4214',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 11:46:03','',''),(2617706,'1','202','1036',477,'Retail Sale Id 4216',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 11:46:37','',''),(2617707,'1','202','1036',477,'Retail Sale Id 4217',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 11:47:13','',''),(2617708,'1','202','1036',477,'Retail Sale Id 4218',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 11:47:41','',''),(2617709,'1','202','1036',477,'Retail Sale Id 4220',1401.04,0.00,0.00,2.11,130.82,'2022-04-17 11:48:19','',''),(2617710,'1','202','1036',477,'Retail Sale Id 4222',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 11:49:12','',''),(2617711,'1','202','1036',477,'Retail Sale Id 4224',1401.04,0.00,0.00,2.11,130.82,'2022-04-17 11:50:04','',''),(2617712,'1','202','1036',477,'Retail Sale Id 4225',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 11:51:27','',''),(2617713,'1','202','1036',477,'Retail Sale Id 4226',697.20,0.00,0.00,1.05,65.10,'2022-04-17 11:52:23','',''),(2617714,'1','202','1036',477,'Retail Sale Id 4227',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 11:53:40','',''),(2617715,'1','202','1036',477,'Retail Sale Id 4229',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 11:54:16','',''),(2617716,'1','202','1036',477,'Retail Sale Id 4230',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 11:55:00','',''),(2617717,'1','202','1036',477,'Retail Sale Id 4232',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 11:55:38','',''),(2617718,'1','202','1036',477,'Retail Sale Id 4234',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 11:56:19','',''),(2617719,'1','202','1036',477,'Retail Sale Id 4235',1347.92,0.00,0.00,2.03,125.86,'2022-04-17 11:58:22','',''),(2617720,'1','202','1036',477,'Retail Sale Id 4237',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 11:59:14','',''),(2617721,'1','202','1036',477,'Retail Sale Id 4239',3353.20,0.00,0.00,5.05,313.10,'2022-04-17 12:00:04','',''),(2617722,'1','202','1036',477,'Retail Sale Id 4240',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 12:05:10','',''),(2617723,'1','202','1036',477,'Retail Sale Id 4242',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 12:05:52','',''),(2617724,'1','202','1036',477,'Retail Sale Id 4244',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 12:06:33','',''),(2617725,'1','202','1036',477,'Retail Sale Id 4245',597.60,0.00,0.00,0.90,55.80,'2022-04-17 12:07:16','',''),(2617726,'1','202','1036',477,'Retail Sale Id 4246',8300.00,0.00,0.00,12.50,775.00,'2022-04-17 12:11:03','',''),(2617727,'1','202','1036',477,'Retail Sale Id 4247',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 12:11:57','',''),(2617728,'1','202','1036',477,'Retail Sale Id 4250',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 12:12:35','',''),(2617729,'1','202','1036',477,'Retail Sale Id 4251',796.80,0.00,0.00,1.20,74.40,'2022-04-17 12:13:30','',''),(2617730,'1','202','1036',477,'Retail Sale Id 4254',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 12:14:07','',''),(2617731,'1','202','1036',477,'Retail Sale Id 4256',697.20,0.00,0.00,1.05,65.10,'2022-04-17 12:14:48','',''),(2617732,'1','202','1036',477,'Retail Sale Id 4257',697.20,0.00,0.00,1.05,65.10,'2022-04-17 12:15:45','',''),(2617733,'1','202','1036',477,'Retail Sale Id 4258',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 12:16:25','',''),(2617734,'1','202','1036',477,'Retail Sale Id 4259',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 12:20:09','',''),(2617735,'1','202','1036',477,'Retail Sale Id 4261',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 12:22:36','',''),(2617736,'1','202','1036',477,'Retail Sale Id 4263',697.20,0.00,0.00,1.05,65.10,'2022-04-17 12:23:32','',''),(2617737,'1','202','1036',477,'Retail Sale Id 4264',1347.92,0.00,0.00,2.03,125.86,'2022-04-17 12:25:18','',''),(2617738,'1','202','1036',477,'Retail Sale Id 4266',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 12:25:58','',''),(2617739,'1','202','1036',477,'Retail Sale Id 4268',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 12:27:47','',''),(2617740,'1','202','1036',477,'Retail Sale Id 4269',8300.00,0.00,0.00,12.50,775.00,'2022-04-17 12:34:36','',''),(2617741,'1','202','1036',477,'Retail Sale Id 4270',1401.04,0.00,0.00,2.11,130.82,'2022-04-17 12:36:23','',''),(2617742,'1','202','1036',477,'Retail Sale Id 4271',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 12:44:04','',''),(2617743,'1','202','1036',477,'Retail Sale Id 4272',1401.04,0.00,0.00,2.11,130.82,'2022-04-17 12:46:13','',''),(2617744,'1','202','1036',477,'Retail Sale Id 4273',8300.00,0.00,0.00,12.50,775.00,'2022-04-17 12:47:37','',''),(2617745,'1','202','1036',477,'Retail Sale Id 4275',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 12:48:29','',''),(2617746,'1','202','1036',477,'Retail Sale Id 4277',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 12:49:09','',''),(2617747,'1','202','1036',477,'Retail Sale Id 4279',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 12:50:13','',''),(2617748,'1','202','1036',477,'Retail Sale Id 4281',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 12:51:05','',''),(2617749,'1','202','1036',477,'Retail Sale Id 4283',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 12:51:49','',''),(2617750,'1','202','1036',477,'Retail Sale Id 4284',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 12:53:15','',''),(2617751,'1','202','1036',477,'Retail Sale Id 4285',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 12:54:25','',''),(2617752,'1','202','1036',477,'Retail Sale Id 4287',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 12:55:38','',''),(2617753,'1','202','1036',477,'Retail Sale Id 4289',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 12:58:03','',''),(2617754,'1','202','1036',477,'Retail Sale Id 4290',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 13:03:17','',''),(2617755,'1','202','1036',477,'Retail Sale Id 4292',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 13:04:35','',''),(2617756,'1','202','1036',477,'Retail Sale Id 4294',1301.44,0.00,0.00,1.96,121.52,'2022-04-17 13:10:09','',''),(2617757,'1','202','1036',477,'Retail Sale Id 4295',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 13:12:13','',''),(2617758,'1','202','1036',477,'Retail Sale Id 4296',8300.00,0.00,0.00,12.50,775.00,'2022-04-17 13:13:38','',''),(2617759,'1','202','1036',477,'Retail Sale Id 4297',6500.56,0.00,0.00,9.79,606.98,'2022-04-17 13:18:52','',''),(2617760,'1','202','1036',477,'Retail Sale Id 4299',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 13:19:34','',''),(2617761,'1','202','1036',477,'Retail Sale Id 4300',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 13:23:44','',''),(2617762,'1','202','1036',477,'Retail Sale Id 4301',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 13:24:22','',''),(2617763,'1','202','1036',477,'Retail Sale Id 4302',597.60,0.00,0.00,0.90,55.80,'2022-04-17 13:24:56','',''),(2617764,'1','202','1036',477,'Retail Sale Id 4303',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 13:25:47','',''),(2617765,'1','202','1036',477,'Retail Sale Id 4304',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 13:28:11','',''),(2617766,'1','202','1036',477,'Retail Sale Id 4305',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 13:31:40','',''),(2617767,'1','202','1036',477,'Retail Sale Id 4306',1301.44,0.00,0.00,1.96,121.52,'2022-04-17 13:32:17','',''),(2617768,'1','202','1036',477,'Retail Sale Id 4307',1301.44,0.00,0.00,1.96,121.52,'2022-04-17 13:33:02','',''),(2617769,'1','202','1036',477,'Retail Sale Id 4308',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 13:42:20','',''),(2617770,'1','202','1036',477,'Retail Sale Id 4309',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 13:43:07','',''),(2617771,'1','202','1036',477,'Retail Sale Id 4310',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 13:44:09','',''),(2617772,'1','202','1036',477,'Retail Sale Id 4311',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 13:51:26','',''),(2617773,'1','202','1036',477,'Retail Sale Id 4312',4648.00,0.00,0.00,7.00,434.00,'2022-04-17 13:54:59','',''),(2617774,'1','202','1036',477,'Retail Sale Id 4313',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 13:58:27','',''),(2617775,'1','202','1036',477,'Retail Sale Id 4314',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 14:03:32','',''),(2617776,'1','202','1036',477,'Retail Sale Id 4315',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 14:04:25','',''),(2617777,'1','202','1036',477,'Retail Sale Id 4316',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 14:05:04','',''),(2617778,'1','202','1036',477,'Retail Sale Id 4317',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 14:05:43','',''),(2617779,'1','202','1036',477,'Retail Sale Id 4318',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 14:13:02','',''),(2617780,'1','202','1036',477,'Retail Sale Id 4319',3353.20,0.00,0.00,5.05,313.10,'2022-04-17 14:25:28','',''),(2617781,'1','202','1036',477,'Retail Sale Id 4320',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 14:30:06','',''),(2617782,'1','202','1036',477,'Retail Sale Id 4321',6002.56,0.00,0.00,9.04,560.48,'2022-04-17 14:36:27','',''),(2617783,'1','202','1036',477,'Retail Sale Id 4322',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 14:37:01','',''),(2617784,'1','202','1036',477,'Retail Sale Id 4323',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 14:45:03','',''),(2617785,'1','202','1036',477,'Retail Sale Id 4324',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 14:45:56','',''),(2617786,'1','202','1036',477,'Retail Sale Id 4325',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 14:53:15','',''),(2617787,'1','202','1036',477,'Retail Sale Id 4326',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 14:56:14','',''),(2617788,'1','202','1036',477,'Retail Sale Id 4327',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 15:13:44','',''),(2617789,'1','202','1036',477,'Retail Sale Id 4328',498.00,0.00,0.00,0.75,46.50,'2022-04-17 15:18:52','',''),(2617790,'1','202','1036',477,'Retail Sale Id 4329',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 15:19:59','',''),(2617791,'1','202','1036',477,'Retail Sale Id 4330',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 15:27:17','',''),(2617792,'1','202','1036',477,'Retail Sale Id 4331',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 15:33:52','',''),(2617793,'1','202','1036',477,'Retail Sale Id 4332',8300.00,0.00,0.00,12.50,775.00,'2022-04-17 15:35:15','',''),(2617794,'1','202','1036',477,'Retail Sale Id 4333',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 15:54:27','',''),(2617795,'1','202','1036',477,'Retail Sale Id 4334',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 16:24:33','',''),(2617796,'1','202','1036',477,'Retail Sale Id 4335',697.20,0.00,0.00,1.05,65.10,'2022-04-17 16:27:03','',''),(2617797,'1','202','1036',477,'Retail Sale Id 4336',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 16:32:50','',''),(2617798,'1','202','1036',477,'Retail Sale Id 4337',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 16:33:43','',''),(2617799,'1','202','1036',477,'Retail Sale Id 4338',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 16:43:37','',''),(2617800,'1','202','1036',477,'Retail Sale Id 4339',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 16:46:41','',''),(2617801,'1','202','1036',477,'Retail Sale Id 4340',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 16:52:04','',''),(2617802,'1','202','1036',477,'Retail Sale Id 4341',3353.20,0.00,0.00,5.05,313.10,'2022-04-17 16:54:48','',''),(2617803,'1','202','1036',477,'Retail Sale Id 4342',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 16:55:47','',''),(2617804,'1','202','1036',477,'Retail Sale Id 4343',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 16:56:39','',''),(2617805,'1','202','1036',477,'Retail Sale Id 4344',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 16:58:32','',''),(2617806,'1','202','1036',477,'Retail Sale Id 4345',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 17:02:48','',''),(2617807,'1','202','1036',477,'Retail Sale Id 4346',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 17:03:58','',''),(2617808,'1','202','1036',477,'Retail Sale Id 4347',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 17:08:22','',''),(2617809,'1','202','1036',477,'Retail Sale Id 4348',1347.92,0.00,0.00,2.03,125.86,'2022-04-17 17:10:36','',''),(2617810,'1','202','1036',477,'Retail Sale Id 4349',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 17:11:10','',''),(2617811,'1','202','1036',477,'Retail Sale Id 4350',8300.00,0.00,0.00,12.50,775.00,'2022-04-17 17:13:32','',''),(2617812,'1','202','1036',477,'Retail Sale Id 4351',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 17:16:46','',''),(2617813,'1','202','1036',477,'Retail Sale Id 4352',8300.00,0.00,0.00,12.50,775.00,'2022-04-17 17:17:57','',''),(2617814,'1','202','1036',477,'Retail Sale Id 4353',1799.44,0.00,0.00,2.71,168.02,'2022-04-17 17:21:40','',''),(2617815,'1','202','1036',477,'Retail Sale Id 4354',3353.20,0.00,0.00,5.05,313.10,'2022-04-17 17:31:24','',''),(2617816,'1','202','1036',477,'Retail Sale Id 4355',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 17:36:11','',''),(2617817,'1','202','1036',477,'Retail Sale Id 4356',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 17:38:49','',''),(2617818,'1','202','1036',477,'Retail Sale Id 4357',796.80,0.00,0.00,1.20,74.40,'2022-04-17 17:40:32','',''),(2617819,'1','202','1036',477,'Retail Sale Id 4358',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 17:41:34','',''),(2617820,'1','202','1036',477,'Retail Sale Id 4359',4999.92,0.00,0.00,7.53,466.86,'2022-04-17 17:43:29','',''),(2617821,'1','202','1036',477,'Retail Sale Id 4360',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 18:00:30','',''),(2617822,'1','202','1036',477,'Retail Sale Id 4361',1002.64,0.00,0.00,1.51,93.62,'2022-04-17 18:02:03','',''),(2617823,'1','202','1036',477,'Retail Sale Id 4362',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 18:02:40','',''),(2617824,'1','202','1036',477,'Retail Sale Id 4363',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 18:03:46','',''),(2617825,'1','202','1036',477,'Retail Sale Id 4364',4501.92,0.00,0.00,6.78,420.36,'2022-04-17 18:06:48','',''),(2617826,'1','202','1036',477,'Retail Sale Id 4365',3997.28,0.00,0.00,6.02,373.24,'2022-04-17 18:07:54','',''),(2617827,'1','202','1036',477,'Retail Sale Id 4366',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 18:12:19','',''),(2617828,'1','202','1036',477,'Retail Sale Id 4367',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 18:34:07','',''),(2617829,'1','202','1036',477,'Retail Sale Id 4368',3001.28,0.00,0.00,4.52,280.24,'2022-04-17 18:35:59','',''),(2617830,'1','202','1036',477,'Retail Sale Id 4369',1500.64,0.00,0.00,2.26,140.12,'2022-04-17 18:39:16','',''),(2617831,'1','202','1036',477,'Retail Sale Id 4370',1998.64,0.00,0.00,3.01,186.62,'2022-04-17 18:49:45','',''),(2617832,'1','202','1036',477,'Return of Retail Sale Id 4270',0.00,1401.04,2.11,0.00,-130.82,'2022-04-17 19:28:17','',''),(2617833,'1','202',NULL,477,'Purchased from AA RANO NIGERIA LIMITED',0.00,1270220.00,2110.00,0.00,0.00,'2022-04-17 19:29:57','',''),(2617834,'1','202',NULL,477,'Reception corrector for bridging 8',0.00,0.00,0.00,2110.00,0.00,'2022-04-17 19:30:34','',''),(2617835,'1','202','1036',477,'Received from bridging 8',0.00,0.00,2110.00,0.00,0.00,'2022-04-17 19:30:34','',''),(2617836,'1','202','1036',477,'Retail Sale Id 4371',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 06:54:59','',''),(2617837,'1','202','1036',477,'Retail Sale Id 4372',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 07:07:36','',''),(2617838,'1','202','1036',477,'Retail Sale Id 4373',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 07:29:10','',''),(2617839,'1','202','1036',477,'Retail Sale Id 4374',2702.48,0.00,0.00,4.07,252.34,'2022-04-18 07:49:17','',''),(2617840,'1','202','1036',477,'Retail Sale Id 4375',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 07:50:11','',''),(2617841,'1','202','1036',477,'Retail Sale Id 4376',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 07:51:48','',''),(2617842,'1','202','1036',477,'Retail Sale Id 4377',2503.28,0.00,0.00,3.77,233.74,'2022-04-18 07:55:55','',''),(2617843,'1','202','1036',477,'Retail Sale Id 4378',1201.84,0.00,0.00,1.81,112.22,'2022-04-18 07:58:27','',''),(2617844,'1','202','1036',477,'Retail Sale Id 4379',6002.56,0.00,0.00,9.04,560.48,'2022-04-18 08:02:28','',''),(2617845,'1','202','1036',477,'Retail Sale Id 4380',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 08:15:21','',''),(2617846,'1','202','1036',477,'Retail Sale Id 4381',3001.28,0.00,0.00,4.52,280.24,'2022-04-18 08:21:50','',''),(2617847,'1','202','1036',477,'Retail Sale Id 4382',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 08:22:33','',''),(2617848,'1','202','1036',477,'Retail Sale Id 4383',6500.56,0.00,0.00,9.79,606.98,'2022-04-18 08:24:46','',''),(2617849,'1','202','1036',477,'Retail Sale Id 4384',4501.92,0.00,0.00,6.78,420.36,'2022-04-18 08:25:43','',''),(2617850,'1','202','1036',477,'Retail Sale Id 4385',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 08:26:39','',''),(2617851,'1','202','1036',477,'Retail Sale Id 4386',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 08:28:43','',''),(2617852,'1','202','1036',477,'Retail Sale Id 4387',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 08:29:43','',''),(2617853,'1','202','1036',477,'Retail Sale Id 4388',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 08:30:39','',''),(2617854,'1','202','1036',477,'Retail Sale Id 4389',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 08:36:06','',''),(2617855,'1','202','1036',477,'Retail Sale Id 4390',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 08:39:04','',''),(2617856,'1','202','1036',477,'Retail Sale Id 4391',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 08:43:47','',''),(2617857,'1','202','1036',477,'Retail Sale Id 4392',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 08:47:56','',''),(2617858,'1','202','1036',477,'Retail Sale Id 4393',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 08:48:45','',''),(2617859,'1','202','1036',477,'Retail Sale Id 4394',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 08:49:32','',''),(2617860,'1','202','1036',477,'Retail Sale Id 4395',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 08:52:52','',''),(2617861,'1','202','1036',477,'Retail Sale Id 4397',1347.92,0.00,0.00,2.03,125.86,'2022-04-18 08:56:29','',''),(2617862,'1','202','1036',477,'Retail Sale Id 4398',6002.56,0.00,0.00,9.04,560.48,'2022-04-18 08:58:57','',''),(2617863,'1','202','1036',477,'Retail Sale Id 4399',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 09:00:28','',''),(2617864,'1','202','1036',477,'Retail Sale Id 4400',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 09:01:16','',''),(2617865,'1','202','1036',477,'Retail Sale Id 4401',3001.28,0.00,0.00,4.52,280.24,'2022-04-18 09:03:10','',''),(2617866,'1','202','1036',477,'Retail Sale Id 4402',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 09:06:21','',''),(2617867,'1','202','1036',477,'Retail Sale Id 4403',1646.72,0.00,0.00,2.48,153.76,'2022-04-18 09:07:31','',''),(2617868,'1','202','1036',477,'Retail Sale Id 4405',3001.28,0.00,0.00,4.52,280.24,'2022-04-18 09:25:58','',''),(2617869,'1','202','1036',477,'Retail Sale Id 4406',3399.68,0.00,0.00,5.12,317.44,'2022-04-18 09:28:53','',''),(2617870,'1','202','1036',477,'Retail Sale Id 4407',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 09:31:36','',''),(2617871,'1','202','1036',477,'Retail Sale Id 4408',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 09:37:48','',''),(2617872,'1','202','1036',477,'Retail Sale Id 4409',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 09:41:31','',''),(2617873,'1','202','1036',477,'Retail Sale Id 4410',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 09:43:53','',''),(2617874,'1','202','1036',477,'Retail Sale Id 4411',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 09:48:23','',''),(2617875,'1','202','1036',477,'Retail Sale Id 4412',6002.56,0.00,0.00,9.04,560.48,'2022-04-18 09:51:32','',''),(2617876,'1','202','1036',477,'Retail Sale Id 4413',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 09:52:16','',''),(2617877,'1','202','1036',477,'Retail Sale Id 4414',498.00,0.00,0.00,0.75,46.50,'2022-04-18 09:59:18','',''),(2617878,'1','202','1036',477,'Retail Sale Id 4415',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 10:00:23','',''),(2617879,'1','202','1036',477,'Retail Sale Id 4416',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 10:07:18','',''),(2617880,'1','202','1036',477,'Retail Sale Id 4417',4999.92,0.00,0.00,7.53,466.86,'2022-04-18 10:08:08','',''),(2617881,'1','202','1036',477,'Retail Sale Id 4418',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 10:09:29','',''),(2617882,'1','202','1036',477,'Retail Sale Id 4419',10298.64,0.00,0.00,15.51,961.62,'2022-04-18 10:13:28','',''),(2617883,'1','202','1036',477,'Retail Sale Id 4420',3001.28,0.00,0.00,4.52,280.24,'2022-04-18 10:14:19','',''),(2617884,'1','202','1036',477,'Retail Sale Id 4421',1301.44,0.00,0.00,1.96,121.52,'2022-04-18 10:15:52','',''),(2617885,'1','202','1036',477,'Retail Sale Id 4422',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 10:16:28','',''),(2617886,'1','202','1036',477,'Retail Sale Id 4423',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 10:22:16','',''),(2617887,'1','202','1036',477,'Retail Sale Id 4424',1201.84,0.00,0.00,1.81,112.22,'2022-04-18 10:26:23','',''),(2617888,'1','202','1036',477,'Retail Sale Id 4425',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 10:27:22','',''),(2617889,'1','202','1036',477,'Retail Sale Id 4426',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 10:31:12','',''),(2617890,'1','202','1036',477,'Retail Sale Id 4427',3353.20,0.00,0.00,5.05,313.10,'2022-04-18 10:32:57','',''),(2617891,'1','202','1036',477,'Retail Sale Id 4428',3399.68,0.00,0.00,5.12,317.44,'2022-04-18 10:34:22','',''),(2617892,'1','202','1036',477,'Retail Sale Id 4429',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 10:39:10','',''),(2617893,'1','202','1036',477,'Retail Sale Id 4430',1347.92,0.00,0.00,2.03,125.86,'2022-04-18 10:39:50','',''),(2617894,'1','202','1036',477,'Retail Sale Id 4431',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 10:40:27','',''),(2617895,'1','202','1036',477,'Retail Sale Id 4432',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 10:41:06','',''),(2617896,'1','202','1036',477,'Retail Sale Id 4433',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 10:47:36','',''),(2617897,'1','202','1036',477,'Retail Sale Id 4434',3001.28,0.00,0.00,4.52,280.24,'2022-04-18 10:51:55','',''),(2617898,'1','202','1036',477,'Retail Sale Id 4435',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 10:54:13','',''),(2617899,'1','202','1036',477,'Retail Sale Id 4436',1347.92,0.00,0.00,2.03,125.86,'2022-04-18 11:00:55','',''),(2617900,'1','202','1036',477,'Retail Sale Id 4437',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 11:07:39','',''),(2617901,'1','202','1036',477,'Retail Sale Id 4438',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 11:11:50','',''),(2617902,'1','202','1036',477,'Retail Sale Id 4439',6640.00,0.00,0.00,10.00,620.00,'2022-04-18 11:15:16','',''),(2617903,'1','202','1036',477,'Retail Sale Id 4440',2702.48,0.00,0.00,4.07,252.34,'2022-04-18 11:16:28','',''),(2617904,'1','202','1036',477,'Retail Sale Id 4441',8001.20,0.00,0.00,12.05,747.10,'2022-04-18 11:17:38','',''),(2617905,'1','202','1036',477,'Retail Sale Id 4442',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 11:18:41','',''),(2617906,'1','202','1036',477,'Retail Sale Id 4443',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 11:19:51','',''),(2617907,'1','202','1036',477,'Retail Sale Id 4444',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 11:22:33','',''),(2617908,'1','202','1036',477,'Retail Sale Id 4445',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 11:27:21','',''),(2617909,'1','202','1036',477,'Retail Sale Id 4446',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 11:31:03','',''),(2617910,'1','202','1036',477,'Retail Sale Id 4447',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 11:32:02','',''),(2617911,'1','202','1036',477,'Retail Sale Id 4448',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 11:33:56','',''),(2617912,'1','202','1036',477,'Retail Sale Id 4449',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 11:36:57','',''),(2617913,'1','202','1036',477,'Retail Sale Id 4450',1401.04,0.00,0.00,2.11,130.82,'2022-04-18 11:38:39','',''),(2617914,'1','202','1036',477,'Retail Sale Id 4451',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 11:40:16','',''),(2617915,'1','202','1036',477,'Retail Sale Id 4452',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 11:44:27','',''),(2617916,'1','202','1036',477,'Retail Sale Id 4453',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 11:45:04','',''),(2617917,'1','202','1036',477,'Retail Sale Id 4454',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 11:46:46','',''),(2617918,'1','202','1036',477,'Retail Sale Id 4457',2503.28,0.00,0.00,3.77,233.74,'2022-04-18 11:51:09','',''),(2617919,'1','202','1036',477,'Retail Sale Id 4458',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 11:52:48','',''),(2617920,'1','202','1036',477,'Retail Sale Id 4459',10650.56,0.00,0.00,16.04,994.48,'2022-04-18 11:55:10','',''),(2617921,'1','202','1036',477,'Retail Sale Id 4460',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 11:58:28','',''),(2617922,'1','202','1036',477,'Retail Sale Id 4461',3353.20,0.00,0.00,5.05,313.10,'2022-04-18 11:59:53','',''),(2617923,'1','202','1036',477,'Retail Sale Id 4462',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 12:01:03','',''),(2617924,'1','202','1036',477,'Retail Sale Id 4463',3001.28,0.00,0.00,4.52,280.24,'2022-04-18 12:02:10','',''),(2617925,'1','202','1036',477,'Retail Sale Id 4464',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 12:09:05','',''),(2617926,'1','202','1036',477,'Retail Sale Id 4465',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 12:13:55','',''),(2617927,'1','202','1036',477,'Retail Sale Id 4466',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 12:14:59','',''),(2617928,'1','202','1036',477,'Retail Sale Id 4467',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 12:16:25','',''),(2617929,'1','202','1036',477,'Retail Sale Id 4468',903.04,0.00,0.00,1.36,84.32,'2022-04-18 12:17:11','',''),(2617930,'1','202','1036',477,'Retail Sale Id 4469',1347.92,0.00,0.00,2.03,125.86,'2022-04-18 12:17:52','',''),(2617931,'1','202','1036',477,'Retail Sale Id 4470',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 12:18:56','',''),(2617932,'1','202','1036',477,'Retail Sale Id 4471',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 12:23:30','',''),(2617933,'1','202','1036',477,'Retail Sale Id 4472',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 12:27:04','',''),(2617934,'1','202','1036',477,'Retail Sale Id 4473',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 12:36:28','',''),(2617935,'1','202','1036',477,'Retail Sale Id 4474',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 12:40:10','',''),(2617936,'1','202','1036',477,'Retail Sale Id 4475',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 12:44:56','',''),(2617937,'1','202','1036',477,'Retail Sale Id 4476',6002.56,0.00,0.00,9.04,560.48,'2022-04-18 12:46:22','',''),(2617938,'1','202','1036',477,'Retail Sale Id 4477',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 12:50:50','',''),(2617939,'1','202','1036',477,'Retail Sale Id 4478',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 12:59:09','',''),(2617940,'1','202','1036',477,'Retail Sale Id 4479',1347.92,0.00,0.00,2.03,125.86,'2022-04-18 12:59:59','',''),(2617941,'1','202','1036',477,'Retail Sale Id 4480',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 13:00:58','',''),(2617942,'1','202','1036',477,'Retail Sale Id 4481',4999.92,0.00,0.00,7.53,466.86,'2022-04-18 13:10:02','',''),(2617943,'1','202','1036',477,'Retail Sale Id 4482',1347.92,0.00,0.00,2.03,125.86,'2022-04-18 13:25:45','',''),(2617944,'1','202','1036',477,'Retail Sale Id 4483',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 13:29:11','',''),(2617945,'1','202','1036',477,'Retail Sale Id 4485',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 13:29:57','',''),(2617946,'1','202','1036',477,'Retail Sale Id 4487',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 13:30:39','',''),(2617947,'1','202','1036',477,'Retail Sale Id 4489',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 13:32:57','',''),(2617948,'1','202','1036',477,'Retail Sale Id 4490',3353.20,0.00,0.00,5.05,313.10,'2022-04-18 13:33:41','',''),(2617949,'1','202','1036',477,'Retail Sale Id 4491',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 13:37:09','',''),(2617950,'1','202','1036',477,'Retail Sale Id 4492',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 13:38:09','',''),(2617951,'1','202','1036',477,'Retail Sale Id 4493',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 13:42:34','',''),(2617952,'1','202','1036',477,'Retail Sale Id 4494',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 13:45:17','',''),(2617953,'1','202','1036',477,'Retail Sale Id 4495',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 13:47:08','',''),(2617954,'1','202','1036',477,'Retail Sale Id 4496',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 13:56:32','',''),(2617955,'1','202','1036',477,'Retail Sale Id 4497',3353.20,0.00,0.00,5.05,313.10,'2022-04-18 14:03:09','',''),(2617956,'1','202','1036',477,'Retail Sale Id 4499',1201.84,0.00,0.00,1.81,112.22,'2022-04-18 14:03:54','',''),(2617957,'1','202','1036',477,'Retail Sale Id 4501',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 14:05:16','',''),(2617958,'1','202','1036',477,'Retail Sale Id 4502',10298.64,0.00,0.00,15.51,961.62,'2022-04-18 14:15:56','',''),(2617959,'1','202','1036',477,'Retail Sale Id 4503',3499.28,0.00,0.00,5.27,326.74,'2022-04-18 14:17:03','',''),(2617960,'1','202','1036',477,'Retail Sale Id 4505',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 14:25:19','',''),(2617961,'1','202','1036',477,'Retail Sale Id 4507',597.60,0.00,0.00,0.90,55.80,'2022-04-18 14:26:19','',''),(2617962,'1','202','1036',477,'Retail Sale Id 4508',3353.20,0.00,0.00,5.05,313.10,'2022-04-18 14:32:47','',''),(2617963,'1','202','1036',477,'Retail Sale Id 4509',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 14:34:31','',''),(2617964,'1','202','1036',477,'Retail Sale Id 4510',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 14:35:57','',''),(2617965,'1','202','1036',477,'Retail Sale Id 4511',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 14:36:44','',''),(2617966,'1','202','1036',477,'Retail Sale Id 4513',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 14:37:33','',''),(2617967,'1','202','1036',477,'Retail Sale Id 4514',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 14:45:30','',''),(2617968,'1','202','1036',477,'Retail Sale Id 4515',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 14:53:36','',''),(2617969,'1','202','1036',477,'Retail Sale Id 4516',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 15:00:41','',''),(2617970,'1','202','1036',477,'Retail Sale Id 4517',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 15:03:16','',''),(2617971,'1','202','1036',477,'Retail Sale Id 4518',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 15:11:26','',''),(2617972,'1','202','1036',477,'Retail Sale Id 4519',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 15:12:39','',''),(2617973,'1','202','1036',477,'Retail Sale Id 4520',498.00,0.00,0.00,0.75,46.50,'2022-04-18 15:14:11','',''),(2617974,'1','202','1036',477,'Retail Sale Id 4521',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 15:14:56','',''),(2617975,'1','202','1036',477,'Retail Sale Id 4522',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 15:16:50','',''),(2617976,'1','202','1036',477,'Retail Sale Id 4523',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 15:19:48','',''),(2617977,'1','202','1036',477,'Retail Sale Id 4524',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 15:34:20','',''),(2617978,'1','202','1036',477,'Retail Sale Id 4525',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 15:40:39','',''),(2617979,'1','202','1036',477,'Retail Sale Id 4526',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 15:47:51','',''),(2617980,'1','202','1036',477,'Retail Sale Id 4527',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 16:05:59','',''),(2617981,'1','202','1036',477,'Retail Sale Id 4528',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 16:08:55','',''),(2617982,'1','202','1036',477,'Retail Sale Id 4529',4999.92,0.00,0.00,7.53,466.86,'2022-04-18 16:11:40','',''),(2617983,'1','202','1036',477,'Retail Sale Id 4530',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 16:12:23','',''),(2617984,'1','202','1036',477,'Retail Sale Id 4531',3353.20,0.00,0.00,5.05,313.10,'2022-04-18 16:15:28','',''),(2617985,'1','202','1036',477,'Retail Sale Id 4533',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 16:20:34','',''),(2617986,'1','202','1036',477,'Retail Sale Id 4535',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 16:21:14','',''),(2617987,'1','202','1036',477,'Retail Sale Id 4536',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 16:31:25','',''),(2617988,'1','202','1036',477,'Retail Sale Id 4537',6699.76,0.00,0.00,10.09,625.58,'2022-04-18 16:37:13','',''),(2617989,'1','202','1036',477,'Retail Sale Id 4539',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 16:39:58','',''),(2617990,'1','202','1036',477,'Retail Sale Id 4540',3001.28,0.00,0.00,4.52,280.24,'2022-04-18 16:43:47','',''),(2617991,'1','202','1036',477,'Retail Sale Id 4542',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 16:44:38','',''),(2617992,'1','202','1036',477,'Retail Sale Id 4543',6653.28,0.00,0.00,10.02,621.24,'2022-04-18 16:48:58','',''),(2617993,'1','202','1036',477,'Retail Sale Id 4545',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 16:51:22','',''),(2617994,'1','202','1036',477,'Retail Sale Id 4547',796.80,0.00,0.00,1.20,74.40,'2022-04-18 16:52:19','',''),(2617995,'1','202','1036',477,'Retail Sale Id 4548',3353.20,0.00,0.00,5.05,313.10,'2022-04-18 16:53:39','',''),(2617996,'1','202','1036',477,'Retail Sale Id 4550',697.20,0.00,0.00,1.05,65.10,'2022-04-18 17:00:47','',''),(2617997,'1','202','1036',477,'Retail Sale Id 4551',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 17:06:24','',''),(2617998,'1','202','1036',477,'Retail Sale Id 4553',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 17:08:23','',''),(2617999,'1','202','1036',477,'Retail Sale Id 4554',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 17:12:02','',''),(2618000,'1','202','1036',477,'Retail Sale Id 4556',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 17:12:46','',''),(2618001,'1','202','1036',477,'Retail Sale Id 4557',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 17:17:44','',''),(2618002,'1','202','1036',477,'Retail Sale Id 4558',8001.20,0.00,0.00,12.05,747.10,'2022-04-18 17:25:52','',''),(2618003,'1','202','1036',477,'Retail Sale Id 4559',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 17:34:47','',''),(2618004,'1','202','1036',477,'Retail Sale Id 4561',1347.92,0.00,0.00,2.03,125.86,'2022-04-18 17:35:52','',''),(2618005,'1','202','1036',477,'Retail Sale Id 4563',3499.28,0.00,0.00,5.27,326.74,'2022-04-18 17:36:55','',''),(2618006,'1','202','1036',477,'Retail Sale Id 4564',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 17:37:54','',''),(2618007,'1','202','1036',477,'Retail Sale Id 4565',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 17:43:09','',''),(2618008,'1','202','1036',477,'Retail Sale Id 4566',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 17:44:57','',''),(2618009,'1','202','1036',477,'Retail Sale Id 4568',1998.64,0.00,0.00,3.01,186.62,'2022-04-18 17:46:15','',''),(2618010,'1','202','1036',477,'Retail Sale Id 4570',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 17:46:58','',''),(2618011,'1','202','1036',477,'Retail Sale Id 4572',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 17:47:42','',''),(2618012,'1','202','1036',477,'Retail Sale Id 4573',1799.44,0.00,0.00,2.71,168.02,'2022-04-18 17:48:46','',''),(2618013,'1','202','1036',477,'Retail Sale Id 4575',3997.28,0.00,0.00,6.02,373.24,'2022-04-18 18:06:20','',''),(2618014,'1','202','1036',477,'Retail Sale Id 4576',1002.64,0.00,0.00,1.51,93.62,'2022-04-18 18:14:49','',''),(2618015,'1','202','1036',477,'Retail Sale Id 4578',5497.92,0.00,0.00,8.28,513.36,'2022-04-18 18:15:48','',''),(2618016,'1','202','1036',477,'Retail Sale Id 4579',8300.00,0.00,0.00,12.50,775.00,'2022-04-18 18:18:59','',''),(2618017,'1','202','1036',477,'Retail Sale Id 4580',1500.64,0.00,0.00,2.26,140.12,'2022-04-18 18:42:44','',''),(2618018,'1','202','1036',477,'Retail Sale Id 4581',3227.04,0.00,0.00,4.86,301.32,'2022-04-18 19:18:41','',''),(2618019,'1','202','1036',477,'Retail Sale Id 4583',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 06:54:05','',''),(2618020,'1','202','1036',477,'Retail Sale Id 4584',697.20,0.00,0.00,1.05,65.10,'2022-04-19 07:17:35','',''),(2618021,'1','202','1036',477,'Retail Sale Id 4585',3001.28,0.00,0.00,4.52,280.24,'2022-04-19 07:21:38','',''),(2618022,'1','202','1036',477,'Retail Sale Id 4586',2350.56,0.00,0.00,3.54,219.48,'2022-04-19 07:33:00','',''),(2618023,'1','202','1036',477,'Retail Sale Id 4587',1002.64,0.00,0.00,1.51,93.62,'2022-04-19 07:34:17','',''),(2618024,'1','202','1036',477,'Retail Sale Id 4588',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 07:37:06','',''),(2618025,'1','202','1036',477,'Retail Sale Id 4589',2197.84,0.00,0.00,3.31,205.22,'2022-04-19 07:40:08','',''),(2618026,'1','202','1036',477,'Retail Sale Id 4590',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 07:47:24','',''),(2618027,'1','202','1036',477,'Retail Sale Id 4591',1500.64,0.00,0.00,2.26,140.12,'2022-04-19 07:49:40','',''),(2618028,'1','202','1036',477,'Retail Sale Id 4592',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 07:53:02','',''),(2618029,'1','202','1036',477,'Retail Sale Id 4593',4701.12,0.00,0.00,7.08,438.96,'2022-04-19 08:05:41','',''),(2618030,'1','202','1036',477,'Retail Sale Id 4594',3001.28,0.00,0.00,4.52,280.24,'2022-04-19 08:11:49','',''),(2618031,'1','202','1036',477,'Retail Sale Id 4595',903.04,0.00,0.00,1.36,84.32,'2022-04-19 08:16:27','',''),(2618032,'1','202','1036',477,'Retail Sale Id 4596',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 08:17:17','',''),(2618033,'1','202','1036',477,'Retail Sale Id 4597',8300.00,0.00,0.00,12.50,775.00,'2022-04-19 08:18:41','',''),(2618034,'1','202','1036',477,'Retail Sale Id 4598',1347.92,0.00,0.00,2.03,125.86,'2022-04-19 08:23:36','',''),(2618035,'1','202','1036',477,'Retail Sale Id 4599',3001.28,0.00,0.00,4.52,280.24,'2022-04-19 08:31:56','',''),(2618036,'1','202','1036',477,'Retail Sale Id 4600',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 08:32:47','',''),(2618037,'1','202','1036',477,'Retail Sale Id 4601',1347.92,0.00,0.00,2.03,125.86,'2022-04-19 08:40:51','',''),(2618038,'1','202','1036',477,'Retail Sale Id 4602',1002.64,0.00,0.00,1.51,93.62,'2022-04-19 08:41:33','',''),(2618039,'1','202','1036',477,'Retail Sale Id 4604',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 08:42:16','',''),(2618040,'1','202','1036',477,'Retail Sale Id 4605',6653.28,0.00,0.00,10.02,621.24,'2022-04-19 08:48:18','',''),(2618041,'1','202','1036',477,'Retail Sale Id 4606',4999.92,0.00,0.00,7.53,466.86,'2022-04-19 08:49:59','',''),(2618042,'1','202','1036',477,'Retail Sale Id 4607',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 08:57:29','',''),(2618043,'1','202','1036',477,'Retail Sale Id 4608',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 08:59:39','',''),(2618044,'1','202','1036',477,'Retail Sale Id 4610',2503.28,0.00,0.00,3.77,233.74,'2022-04-19 09:08:05','',''),(2618045,'1','202','1036',477,'Retail Sale Id 4611',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 09:09:28','',''),(2618046,'1','202','1036',477,'Retail Sale Id 4612',2098.24,0.00,0.00,3.16,195.92,'2022-04-19 09:12:56','',''),(2618047,'1','202','1036',477,'Retail Sale Id 4613',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 09:13:50','',''),(2618048,'1','202','1036',477,'Retail Sale Id 4614',4999.92,0.00,0.00,7.53,466.86,'2022-04-19 09:18:39','',''),(2618049,'1','202','1036',477,'Retail Sale Id 4616',1002.64,0.00,0.00,1.51,93.62,'2022-04-19 09:19:26','',''),(2618050,'1','202','1036',477,'Retail Sale Id 4617',3353.20,0.00,0.00,5.05,313.10,'2022-04-19 09:20:24','',''),(2618051,'1','202','1036',477,'Retail Sale Id 4618',8300.00,0.00,0.00,12.50,775.00,'2022-04-19 09:23:04','',''),(2618052,'1','202','1036',477,'Retail Sale Id 4620',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 09:24:01','',''),(2618053,'1','202','1036',477,'Retail Sale Id 4621',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 09:32:30','',''),(2618054,'1','202','1036',477,'Retail Sale Id 4622',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 09:33:50','',''),(2618055,'1','202','1036',477,'Retail Sale Id 4623',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 09:34:48','',''),(2618056,'1','202','1036',477,'Retail Sale Id 4624',3001.28,0.00,0.00,4.52,280.24,'2022-04-19 09:40:45','',''),(2618057,'1','202','1036',477,'Retail Sale Id 4625',1002.64,0.00,0.00,1.51,93.62,'2022-04-19 09:43:58','',''),(2618058,'1','202','1036',477,'Retail Sale Id 4626',8300.00,0.00,0.00,12.50,775.00,'2022-04-19 09:46:41','',''),(2618059,'1','202','1036',477,'Retail Sale Id 4627',16600.00,0.00,0.00,25.00,1550.00,'2022-04-19 09:49:35','',''),(2618060,'1','202','1036',477,'Retail Sale Id 4628',3353.20,0.00,0.00,5.05,313.10,'2022-04-19 10:02:38','',''),(2618061,'1','202','1036',477,'Retail Sale Id 4629',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 10:03:29','',''),(2618062,'1','202','1036',477,'Retail Sale Id 4632',1500.64,0.00,0.00,2.26,140.12,'2022-04-19 10:04:17','',''),(2618063,'1','202','1036',477,'Retail Sale Id 4633',1201.84,0.00,0.00,1.81,112.22,'2022-04-19 10:05:27','',''),(2618064,'1','202','1036',477,'Retail Sale Id 4634',1301.44,0.00,0.00,1.96,121.52,'2022-04-19 10:09:28','',''),(2618065,'1','202','1036',477,'Retail Sale Id 4635',1002.64,0.00,0.00,1.51,93.62,'2022-04-19 10:10:26','',''),(2618066,'1','202','1036',477,'Retail Sale Id 4636',4999.92,0.00,0.00,7.53,466.86,'2022-04-19 10:16:12','',''),(2618067,'1','202','1036',477,'Retail Sale Id 4637',1201.84,0.00,0.00,1.81,112.22,'2022-04-19 10:21:26','',''),(2618068,'1','202','1036',477,'Retail Sale Id 4639',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 10:23:50','',''),(2618069,'1','202','1036',477,'Retail Sale Id 4641',3001.28,0.00,0.00,4.52,280.24,'2022-04-19 10:36:09','',''),(2618070,'1','202','1036',477,'Retail Sale Id 4642',1002.64,0.00,0.00,1.51,93.62,'2022-04-19 10:41:10','',''),(2618071,'1','202','1036',477,'Retail Sale Id 4643',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 10:46:15','',''),(2618072,'1','202','1036',477,'Retail Sale Id 4645',3499.28,0.00,0.00,5.27,326.74,'2022-04-19 10:47:31','',''),(2618073,'1','202','1036',477,'Retail Sale Id 4646',1500.64,0.00,0.00,2.26,140.12,'2022-04-19 10:50:50','',''),(2618074,'1','202','1036',477,'Retail Sale Id 4648',3798.08,0.00,0.00,5.72,354.64,'2022-04-19 10:53:22','',''),(2618075,'1','202','1036',477,'Retail Sale Id 4650',2702.48,0.00,0.00,4.07,252.34,'2022-04-19 10:54:57','',''),(2618076,'1','202','1036',477,'Retail Sale Id 4651',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 10:55:44','',''),(2618077,'1','202','1036',477,'Retail Sale Id 4652',1002.64,0.00,0.00,1.51,93.62,'2022-04-19 10:57:10','',''),(2618078,'1','202','1036',477,'Retail Sale Id 4653',1500.64,0.00,0.00,2.26,140.12,'2022-04-19 11:06:14','',''),(2618079,'1','202','1036',477,'Retail Sale Id 4654',1002.64,0.00,0.00,1.51,93.62,'2022-04-19 11:12:21','',''),(2618080,'1','202','1036',477,'Retail Sale Id 4655',8300.00,0.00,0.00,12.50,775.00,'2022-04-19 11:13:57','',''),(2618081,'1','202','1036',477,'Retail Sale Id 4656',5298.72,0.00,0.00,7.98,494.76,'2022-04-19 11:26:42','',''),(2618082,'1','202','1036',477,'Retail Sale Id 4657',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 11:30:44','',''),(2618083,'1','202','1036',477,'Retail Sale Id 4658',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 11:36:19','',''),(2618084,'1','202','1036',477,'Retail Sale Id 4659',1500.64,0.00,0.00,2.26,140.12,'2022-04-19 11:49:24','',''),(2618085,'1','202','1036',477,'Retail Sale Id 4660',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 12:00:14','',''),(2618086,'1','202','1036',477,'Retail Sale Id 4661',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 12:12:05','',''),(2618087,'1','202','1036',477,'Retail Sale Id 4662',1002.64,0.00,0.00,1.51,93.62,'2022-04-19 12:27:34','',''),(2618088,'1','202','1036',477,'Retail Sale Id 4663',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 12:29:57','',''),(2618089,'1','202','1036',477,'Retail Sale Id 4664',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 12:43:40','',''),(2618090,'1','202','1036',477,'Retail Sale Id 4666',1347.92,0.00,0.00,2.03,125.86,'2022-04-19 12:48:58','',''),(2618091,'1','202','1036',477,'Retail Sale Id 4667',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 13:02:20','',''),(2618092,'1','202','1036',477,'Retail Sale Id 4668',1002.64,0.00,0.00,1.51,93.62,'2022-04-19 13:22:19','',''),(2618093,'1','202','1036',477,'Retail Sale Id 4669',9960.00,0.00,0.00,15.00,930.00,'2022-04-19 13:29:39','',''),(2618094,'1','202','1036',477,'Retail Sale Id 4670',6998.56,0.00,0.00,10.54,653.48,'2022-04-19 13:36:11','',''),(2618095,'1','202','1036',477,'Retail Sale Id 4671',4999.92,0.00,0.00,7.53,466.86,'2022-04-19 13:37:56','',''),(2618096,'1','202','1036',477,'Retail Sale Id 4672',1998.64,0.00,0.00,3.01,186.62,'2022-04-19 13:39:24','',''),(2618097,'1','202','1036',477,'Retail Sale Id 4673',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 13:40:31','',''),(2618098,'1','202','1036',477,'Retail Sale Id 4674',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 13:41:27','',''),(2618099,'1','202','1036',477,'Retail Sale Id 4675',6002.56,0.00,0.00,9.04,560.48,'2022-04-19 13:55:54','',''),(2618100,'1','202','1036',477,'Retail Sale Id 4682',3997.28,0.00,0.00,6.02,373.24,'2022-04-19 14:03:18','',''),(2618101,'1','202','1036',477,'Retail Sale Id 4683',14352.00,0.00,0.00,24.00,14352.00,'2022-04-19 14:27:29','',''),(2618102,'1','202','1036',477,'Retail Sale Id 4684',3001.28,0.00,0.00,4.52,3001.28,'2022-04-19 14:34:19','',''),(2618103,'1','202','1036',477,'Retail Sale Id 4685',1500.64,0.00,0.00,2.26,1500.64,'2022-04-19 14:37:41','',''),(2618104,'1','202','1036',477,'Retail Sale Id 4686',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 14:41:41','',''),(2618105,'1','202','1036',477,'Retail Sale Id 4687',29302.00,0.00,0.00,49.00,29302.00,'2022-04-19 14:44:36','',''),(2618106,'1','202','1036',477,'Retail Sale Id 4688',29900.00,0.00,0.00,50.00,29900.00,'2022-04-19 14:49:42','',''),(2618107,'1','202','1036',477,'Retail Sale Id 4689',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 15:11:00','',''),(2618108,'1','202','1036',477,'Retail Sale Id 4690',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 15:13:23','',''),(2618109,'1','202','1036',477,'Retail Sale Id 4691',1347.92,0.00,0.00,2.03,1347.92,'2022-04-19 15:21:13','',''),(2618110,'1','202','1036',477,'Retail Sale Id 4692',6653.28,0.00,0.00,10.02,6653.28,'2022-04-19 15:28:47','',''),(2618111,'1','202','1036',477,'Retail Sale Id 4693',697.20,0.00,0.00,1.05,697.20,'2022-04-19 15:35:10','',''),(2618112,'1','202','1036',477,'Retail Sale Id 4694',697.20,0.00,0.00,1.05,697.20,'2022-04-19 15:37:20','',''),(2618113,'1','202','1036',477,'Retail Sale Id 4695',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 15:43:06','',''),(2618114,'1','202','1036',477,'Retail Sale Id 4696',2503.28,0.00,0.00,3.77,2503.28,'2022-04-19 15:46:37','',''),(2618115,'1','202','1036',477,'Retail Sale Id 4697',8300.00,0.00,0.00,12.50,8300.00,'2022-04-19 15:49:55','',''),(2618116,'1','202','1036',477,'Retail Sale Id 4698',1699.84,0.00,0.00,2.56,1699.84,'2022-04-19 15:53:48','',''),(2618117,'1','202','1036',477,'Retail Sale Id 4699',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 15:59:05','',''),(2618118,'1','202','1036',477,'Retail Sale Id 4700',1002.64,0.00,0.00,1.51,1002.64,'2022-04-19 16:00:10','',''),(2618119,'1','202','1036',477,'Retail Sale Id 4701',21229.00,0.00,0.00,35.50,21229.00,'2022-04-19 16:09:22','',''),(2618120,'1','202','1036',477,'Retail Sale Id 4702',3001.28,0.00,0.00,4.52,3001.28,'2022-04-19 16:14:14','',''),(2618121,'1','202','1036',477,'Retail Sale Id 4703',1500.64,0.00,0.00,2.26,1500.64,'2022-04-19 16:14:55','',''),(2618122,'1','202','1036',477,'Retail Sale Id 4704',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 16:16:26','',''),(2618123,'1','202','1036',477,'Retail Sale Id 4705',8300.00,0.00,0.00,12.50,8300.00,'2022-04-19 16:17:34','',''),(2618124,'1','202','1036',477,'Retail Sale Id 4706',3001.28,0.00,0.00,4.52,3001.28,'2022-04-19 16:19:10','',''),(2618125,'1','202','1036',477,'Retail Sale Id 4707',6653.28,0.00,0.00,10.02,6653.28,'2022-04-19 16:25:41','',''),(2618126,'1','202','1036',477,'Retail Sale Id 4708',3353.20,0.00,0.00,5.05,3353.20,'2022-04-19 16:27:54','',''),(2618127,'1','202','1036',477,'Retail Sale Id 4709',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 16:33:47','',''),(2618128,'1','202','1036',477,'Retail Sale Id 4710',2503.28,0.00,0.00,3.77,2503.28,'2022-04-19 16:34:37','',''),(2618129,'1','202','1036',477,'Retail Sale Id 4711',8300.00,0.00,0.00,12.50,8300.00,'2022-04-19 16:35:59','',''),(2618130,'1','202','1036',477,'Retail Sale Id 4712',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 16:37:00','',''),(2618131,'1','202','1036',477,'Retail Sale Id 4713',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 16:41:49','',''),(2618132,'1','202','1036',477,'Retail Sale Id 4714',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 16:58:04','',''),(2618133,'1','202','1036',477,'Retail Sale Id 4715',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 17:01:29','',''),(2618134,'1','202','1036',477,'Retail Sale Id 4716',4648.00,0.00,0.00,7.00,4648.00,'2022-04-19 17:05:25','',''),(2618135,'1','202','1036',477,'Retail Sale Id 4717',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 17:13:56','',''),(2618136,'1','202','1036',477,'Retail Sale Id 4718',1002.64,0.00,0.00,1.51,1002.64,'2022-04-19 17:28:42','',''),(2618137,'1','202','1036',477,'Retail Sale Id 4719',3499.28,0.00,0.00,5.27,3499.28,'2022-04-19 17:31:31','',''),(2618138,'1','202','1036',477,'Retail Sale Id 4720',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 17:32:24','',''),(2618139,'1','202','1036',477,'Retail Sale Id 4721',3353.20,0.00,0.00,5.05,3353.20,'2022-04-19 17:32:57','',''),(2618140,'1','202','1036',477,'Retail Sale Id 4722',1500.64,0.00,0.00,2.26,1500.64,'2022-04-19 17:38:49','',''),(2618141,'1','202','1036',477,'Retail Sale Id 4723',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 17:39:33','',''),(2618142,'1','202','1036',477,'Retail Sale Id 4724',1500.64,0.00,0.00,2.26,1500.64,'2022-04-19 17:40:17','',''),(2618143,'1','202','1036',477,'Retail Sale Id 4725',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 17:40:54','',''),(2618144,'1','202','1036',477,'Retail Sale Id 4726',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 17:51:48','',''),(2618145,'1','202','1036',477,'Retail Sale Id 4727',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 17:52:38','',''),(2618146,'1','202','1036',477,'Retail Sale Id 4728',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 17:54:59','',''),(2618147,'1','202','1036',477,'Retail Sale Id 4729',3353.20,0.00,0.00,5.05,3353.20,'2022-04-19 17:56:04','',''),(2618148,'1','202','1036',477,'Retail Sale Id 4730',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 17:56:54','',''),(2618149,'1','202','1036',477,'Retail Sale Id 4731',8300.00,0.00,0.00,12.50,8300.00,'2022-04-19 17:57:56','',''),(2618150,'1','202','1036',477,'Retail Sale Id 4732',1002.64,0.00,0.00,1.51,1002.64,'2022-04-19 17:59:43','',''),(2618151,'1','202','1036',477,'Retail Sale Id 4733',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 18:05:43','',''),(2618152,'1','202','1036',477,'Retail Sale Id 4734',1347.92,0.00,0.00,2.03,1347.92,'2022-04-19 18:09:20','',''),(2618153,'1','202','1036',477,'Retail Sale Id 4735',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 18:14:05','',''),(2618154,'1','202','1036',477,'Retail Sale Id 4737',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 18:16:20','',''),(2618155,'1','202','1036',477,'Retail Sale Id 4738',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 18:17:13','',''),(2618156,'1','202','1036',477,'Retail Sale Id 4739',6002.56,0.00,0.00,9.04,6002.56,'2022-04-19 18:19:56','',''),(2618157,'1','202','1036',477,'Retail Sale Id 4740',697.20,0.00,0.00,1.05,697.20,'2022-04-19 18:20:47','',''),(2618158,'1','202','1036',477,'Retail Sale Id 4741',4999.92,0.00,0.00,7.53,4999.92,'2022-04-19 18:22:22','',''),(2618159,'1','202','1036',477,'Retail Sale Id 4742',1002.64,0.00,0.00,1.51,1002.64,'2022-04-19 18:24:04','',''),(2618160,'1','202','1036',477,'Retail Sale Id 4742',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 18:24:04','',''),(2618161,'1','202','1036',477,'Retail Sale Id 4743',1998.64,0.00,0.00,3.01,1998.64,'2022-04-19 18:29:09','',''),(2618162,'1','202','1036',477,'Retail Sale Id 4744',1799.44,0.00,0.00,2.71,1799.44,'2022-04-19 18:45:12','',''),(2618163,'1','202','1036',477,'Retail Sale Id 4745',3001.28,0.00,0.00,4.52,3001.28,'2022-04-19 18:47:53','',''),(2618164,'1','202','1036',477,'Retail Sale Id 4746',3997.28,0.00,0.00,6.02,3997.28,'2022-04-19 18:50:44','',''),(2618165,'1','202','1036',477,'Return of Retail Sale Id 4741',0.00,4999.92,7.53,0.00,-4999.92,'2022-04-19 19:19:17','',''),(2618166,'1','202','1036',477,'Retail Sale Id 4747',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 07:00:39','',''),(2618167,'1','202','1036',477,'Retail Sale Id 4748',29601.00,0.00,0.00,49.50,29601.00,'2022-04-20 07:02:04','',''),(2618168,'1','202','1036',477,'Retail Sale Id 4749',212040.00,0.00,0.00,360.00,212040.00,'2022-04-20 07:06:22','',''),(2618169,'1','202','1036',477,'Retail Sale Id 4751',1500.64,0.00,0.00,2.26,1500.64,'2022-04-20 07:08:07','',''),(2618170,'1','202','1036',477,'Retail Sale Id 4752',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 07:09:46','',''),(2618171,'1','202','1036',477,'Retail Sale Id 4753',6002.56,0.00,0.00,9.04,6002.56,'2022-04-20 07:17:01','',''),(2618172,'1','202','1036',477,'Retail Sale Id 4754',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 07:19:21','',''),(2618173,'1','202','1036',477,'Retail Sale Id 4755',29900.00,0.00,0.00,50.00,29900.00,'2022-04-20 07:25:42','',''),(2618174,'1','202','1036',477,'Retail Sale Id 4756',2702.48,0.00,0.00,4.07,2702.48,'2022-04-20 07:34:23','',''),(2618175,'1','202','1036',477,'Retail Sale Id 4757',1500.64,0.00,0.00,2.26,1500.64,'2022-04-20 07:35:24','',''),(2618176,'1','202','1036',477,'Retail Sale Id 4758',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 07:45:59','',''),(2618177,'1','202','1036',477,'Retail Sale Id 4759',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 07:48:23','',''),(2618178,'1','202','1036',477,'Retail Sale Id 4760',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 07:49:13','',''),(2618179,'1','202','1036',477,'Retail Sale Id 4760',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 07:49:13','',''),(2618180,'1','202','1036',477,'Retail Sale Id 4761',4150.00,0.00,0.00,6.25,4150.00,'2022-04-20 07:52:03','',''),(2618181,'1','202','1036',477,'Retail Sale Id 4762',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 08:01:30','',''),(2618182,'1','202','1036',477,'Retail Sale Id 4763',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 08:06:39','',''),(2618183,'1','202','1036',477,'Retail Sale Id 4764',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 08:17:27','',''),(2618184,'1','202','1036',477,'Retail Sale Id 4765',1002.64,0.00,0.00,1.51,1002.64,'2022-04-20 08:23:26','',''),(2618185,'1','202','1036',477,'Retail Sale Id 4766',1002.64,0.00,0.00,1.51,1002.64,'2022-04-20 08:24:07','',''),(2618186,'1','202','1036',477,'Retail Sale Id 4767',3499.28,0.00,0.00,5.27,3499.28,'2022-04-20 08:26:24','',''),(2618187,'1','202','1036',477,'Retail Sale Id 4768',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 08:31:30','',''),(2618188,'1','202','1036',477,'Retail Sale Id 4769',7350.48,0.00,0.00,11.07,7350.48,'2022-04-20 08:35:42','',''),(2618189,'1','202','1036',477,'Retail Sale Id 4770',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 08:38:36','',''),(2618190,'1','202','1036',477,'Retail Sale Id 4772',796.80,0.00,0.00,1.20,796.80,'2022-04-20 08:41:21','',''),(2618191,'1','202','1036',477,'Retail Sale Id 4773',2702.48,0.00,0.00,4.07,2702.48,'2022-04-20 08:46:25','',''),(2618192,'1','202','1036',477,'Retail Sale Id 4773',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 08:46:25','',''),(2618193,'1','202','1036',477,'Retail Sale Id 4774',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 08:51:09','',''),(2618194,'1','202','1036',477,'Retail Sale Id 4776',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 08:56:41','',''),(2618195,'1','202','1036',477,'Retail Sale Id 4777',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 08:58:43','',''),(2618196,'1','202','1036',477,'Retail Sale Id 4778',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 09:08:17','',''),(2618197,'1','202','1036',477,'Retail Sale Id 4779',3353.20,0.00,0.00,5.05,3353.20,'2022-04-20 09:11:10','',''),(2618198,'1','202','1036',477,'Retail Sale Id 4780',1500.64,0.00,0.00,2.26,1500.64,'2022-04-20 09:23:02','',''),(2618199,'1','202','1036',477,'Retail Sale Id 4781',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 09:25:22','',''),(2618200,'1','202','1036',477,'Retail Sale Id 4782',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 09:26:11','',''),(2618201,'1','202','1036',477,'Retail Sale Id 4783',796.80,0.00,0.00,1.20,796.80,'2022-04-20 09:26:52','',''),(2618202,'1','202','1036',477,'Retail Sale Id 4784',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 09:27:36','',''),(2618203,'1','202','1036',477,'Retail Sale Id 4785',697.20,0.00,0.00,1.05,697.20,'2022-04-20 09:28:23','',''),(2618204,'1','202','1036',477,'Retail Sale Id 4786',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 09:29:22','',''),(2618205,'1','202','1036',477,'Retail Sale Id 4787',65780.00,0.00,0.00,110.00,65780.00,'2022-04-20 09:42:32','',''),(2618206,'1','202','1036',477,'Retail Sale Id 4788',3353.20,0.00,0.00,5.05,3353.20,'2022-04-20 09:43:29','',''),(2618207,'1','202','1036',477,'Retail Sale Id 4789',2098.24,0.00,0.00,3.16,2098.24,'2022-04-20 09:46:28','',''),(2618208,'1','202','1036',477,'Retail Sale Id 4790',1500.64,0.00,0.00,2.26,1500.64,'2022-04-20 09:47:16','',''),(2618209,'1','202','1036',477,'Retail Sale Id 4791',1799.44,0.00,0.00,2.71,1799.44,'2022-04-20 09:51:22','',''),(2618210,'1','202','1036',477,'Retail Sale Id 4792',4999.92,0.00,0.00,7.53,4999.92,'2022-04-20 09:58:22','',''),(2618211,'1','202','1036',477,'Retail Sale Id 4793',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 10:00:56','',''),(2618212,'1','202','1036',477,'Retail Sale Id 4794',2702.48,0.00,0.00,4.07,2702.48,'2022-04-20 10:03:46','',''),(2618213,'1','202','1036',477,'Retail Sale Id 4795',206310.00,0.00,0.00,345.00,206310.00,'2022-04-20 10:06:16','',''),(2618214,'1','202','1036',477,'Retail Sale Id 4796',1002.64,0.00,0.00,1.51,1002.64,'2022-04-20 10:09:36','',''),(2618215,'1','202','1036',477,'Retail Sale Id 4797',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 10:14:09','',''),(2618216,'1','202','1036',477,'Retail Sale Id 4799',46046.00,0.00,0.00,77.00,46046.00,'2022-04-20 10:16:47','',''),(2618217,'1','202','1036',477,'Retail Sale Id 4800',3353.20,0.00,0.00,5.05,3353.20,'2022-04-20 10:17:47','',''),(2618218,'1','202','1036',477,'Retail Sale Id 4801',4000.00,0.00,0.00,1.00,4000.00,'2022-04-20 10:18:45','',''),(2618219,'1','202','1036',477,'Retail Sale Id 4802',2702.48,0.00,0.00,4.07,2702.48,'2022-04-20 10:21:19','',''),(2618220,'1','202','1036',477,'Retail Sale Id 4803',10298.64,0.00,0.00,15.51,10298.64,'2022-04-20 10:23:49','',''),(2618221,'1','202','1036',477,'Retail Sale Id 4804',1347.92,0.00,0.00,2.03,1347.92,'2022-04-20 10:28:02','',''),(2618222,'1','202','1036',477,'Retail Sale Id 4805',29302.00,0.00,0.00,49.00,29302.00,'2022-04-20 10:29:31','',''),(2618223,'1','202','1036',477,'Retail Sale Id 4806',4999.92,0.00,0.00,7.53,4999.92,'2022-04-20 10:51:31','',''),(2618224,'1','202','1036',477,'Retail Sale Id 4807',2702.48,0.00,0.00,4.07,2702.48,'2022-04-20 10:54:50','',''),(2618225,'1','202','1036',477,'Retail Sale Id 4808',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 10:58:47','',''),(2618226,'1','202','1036',477,'Retail Sale Id 4809',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 11:09:03','',''),(2618227,'1','202','1036',477,'Retail Sale Id 4810',1500.64,0.00,0.00,2.26,1500.64,'2022-04-20 11:19:31','',''),(2618228,'1','202','1036',477,'Retail Sale Id 4811',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 11:35:24','',''),(2618229,'1','202','1036',477,'Retail Sale Id 4812',1002.64,0.00,0.00,1.51,1002.64,'2022-04-20 11:37:32','',''),(2618230,'1','202','1036',477,'Retail Sale Id 4813',1347.92,0.00,0.00,2.03,1347.92,'2022-04-20 11:39:52','',''),(2618231,'1','202','1036',477,'Retail Sale Id 4814',1347.92,0.00,0.00,2.03,1347.92,'2022-04-20 11:45:29','',''),(2618232,'1','202','1036',477,'Retail Sale Id 4815',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 11:50:53','',''),(2618233,'1','202','1036',477,'Retail Sale Id 4816',3698.48,0.00,0.00,5.57,3698.48,'2022-04-20 11:53:11','',''),(2618234,'1','202','1036',477,'Retail Sale Id 4817',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 12:07:51','',''),(2618235,'1','202','1036',477,'Retail Sale Id 4818',3353.20,0.00,0.00,5.05,3353.20,'2022-04-20 12:15:14','',''),(2618236,'1','202','1036',477,'Retail Sale Id 4819',35880.00,0.00,0.00,60.00,35880.00,'2022-04-20 12:20:11','',''),(2618237,'1','202','1036',477,'Retail Sale Id 4820',2503.28,0.00,0.00,3.77,2503.28,'2022-04-20 12:22:43','',''),(2618238,'1','202','1036',477,'Retail Sale Id 4821',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 12:23:49','',''),(2618239,'1','202','1036',477,'Retail Sale Id 4822',3353.20,0.00,0.00,5.05,3353.20,'2022-04-20 12:25:41','',''),(2618240,'1','202','1036',477,'Retail Sale Id 4823',4999.92,0.00,0.00,7.53,4999.92,'2022-04-20 12:36:08','',''),(2618241,'1','202','1036',477,'Retail Sale Id 4824',8001.20,0.00,0.00,12.05,8001.20,'2022-04-20 12:49:08','',''),(2618242,'1','202','1036',477,'Retail Sale Id 4824',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 12:49:08','',''),(2618243,'1','202','1036',477,'Retail Sale Id 4825',29302.00,0.00,0.00,49.00,29302.00,'2022-04-20 12:53:14','',''),(2618244,'1','202','1036',477,'Retail Sale Id 4826',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 12:53:53','',''),(2618245,'1','202','1036',477,'Retail Sale Id 4827',32890.00,0.00,0.00,55.00,32890.00,'2022-04-20 13:04:30','',''),(2618246,'1','202','1036',477,'Retail Sale Id 4828',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 13:06:33','',''),(2618247,'1','202','1036',477,'Retail Sale Id 4830',1002.64,0.00,0.00,1.51,1002.64,'2022-04-20 13:09:24','',''),(2618248,'1','202','1036',477,'Retail Sale Id 4832',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 13:21:09','',''),(2618249,'1','202','1036',477,'Retail Sale Id 4833',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 13:22:30','',''),(2618250,'1','202','1036',477,'Retail Sale Id 4834',2702.48,0.00,0.00,4.07,2702.48,'2022-04-20 13:24:22','',''),(2618251,'1','202','1036',477,'Retail Sale Id 4835',1002.64,0.00,0.00,1.51,1002.64,'2022-04-20 13:27:41','',''),(2618252,'1','202','1036',477,'Retail Sale Id 4836',1500.64,0.00,0.00,2.26,1500.64,'2022-04-20 13:28:34','',''),(2618253,'1','202','1036',477,'Retail Sale Id 4838',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 13:34:29','',''),(2618254,'1','202','1036',477,'Retail Sale Id 4839',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 13:37:07','',''),(2618255,'1','202','1036',477,'Retail Sale Id 4841',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 13:43:30','',''),(2618256,'1','202','1036',477,'Retail Sale Id 4842',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 13:46:35','',''),(2618257,'1','202','1036',477,'Retail Sale Id 4845',2702.48,0.00,0.00,4.07,2702.48,'2022-04-20 13:48:42','',''),(2618258,'1','202','1036',477,'Retail Sale Id 4846',3001.28,0.00,0.00,4.52,3001.28,'2022-04-20 14:05:36','',''),(2618259,'1','202','1036',477,'Retail Sale Id 4847',3353.20,0.00,0.00,5.05,3353.20,'2022-04-20 14:06:21','',''),(2618260,'1','202','1036',477,'Retail Sale Id 4848',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 14:28:17','',''),(2618261,'1','202','1036',477,'Retail Sale Id 4849',33488.00,0.00,0.00,56.00,33488.00,'2022-04-20 14:39:33','',''),(2618262,'1','202','1036',477,'Retail Sale Id 4851',2503.28,0.00,0.00,3.77,2503.28,'2022-04-20 14:43:19','',''),(2618263,'1','202','1036',477,'Retail Sale Id 4852',29900.00,0.00,0.00,50.00,29900.00,'2022-04-20 14:51:30','',''),(2618264,'1','202','1036',477,'Retail Sale Id 4853',1500.64,0.00,0.00,2.26,1500.64,'2022-04-20 14:53:38','',''),(2618265,'1','202','1036',477,'Retail Sale Id 4856',6998.56,0.00,0.00,10.54,6998.56,'2022-04-20 14:54:13','',''),(2618266,'1','202','1036',477,'Retail Sale Id 4857',1799.44,0.00,0.00,2.71,1799.44,'2022-04-20 14:55:04','',''),(2618267,'1','202','1036',477,'Retail Sale Id 4860',3001.28,0.00,0.00,4.52,3001.28,'2022-04-20 14:55:46','',''),(2618268,'1','202','1036',477,'Retail Sale Id 4862',3001.28,0.00,0.00,4.52,3001.28,'2022-04-20 14:56:29','',''),(2618269,'1','202','1036',477,'Retail Sale Id 4863',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 15:04:49','',''),(2618270,'1','202','1036',477,'Retail Sale Id 4865',1401.04,0.00,0.00,2.11,1401.04,'2022-04-20 15:11:33','',''),(2618271,'1','202','1036',477,'Retail Sale Id 4867',1301.44,0.00,0.00,1.96,1301.44,'2022-04-20 15:12:49','',''),(2618272,'1','202','1036',477,'Retail Sale Id 4869',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 15:14:23','',''),(2618273,'1','202','1036',477,'Retail Sale Id 4871',29900.00,0.00,0.00,50.00,29900.00,'2022-04-20 15:18:26','',''),(2618274,'1','202','1036',477,'Retail Sale Id 4872',4999.92,0.00,0.00,7.53,4999.92,'2022-04-20 15:26:05','',''),(2618275,'1','202','1036',477,'Retail Sale Id 4873',2197.84,0.00,0.00,3.31,2197.84,'2022-04-20 15:33:24','',''),(2618276,'1','202','1036',477,'Retail Sale Id 4874',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 15:41:40','',''),(2618277,'1','202','1036',477,'Retail Sale Id 4876',1002.64,0.00,0.00,1.51,1002.64,'2022-04-20 15:42:22','',''),(2618278,'1','202','1036',477,'Retail Sale Id 4878',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 15:42:58','',''),(2618279,'1','202','1036',477,'Retail Sale Id 4879',17342.00,0.00,0.00,29.00,17342.00,'2022-04-20 15:45:38','',''),(2618280,'1','202','1036',477,'Retail Sale Id 4880',29900.00,0.00,0.00,50.00,29900.00,'2022-04-20 15:47:58','',''),(2618281,'1','202','1036',477,'Retail Sale Id 4881',3353.20,0.00,0.00,5.05,3353.20,'2022-04-20 15:49:52','',''),(2618282,'1','202','1036',477,'Retail Sale Id 4882',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 15:52:53','',''),(2618283,'1','202','1036',477,'Retail Sale Id 4883',2702.48,0.00,0.00,4.07,2702.48,'2022-04-20 16:01:36','',''),(2618284,'1','202','1036',477,'Retail Sale Id 4884',3353.20,0.00,0.00,5.05,3353.20,'2022-04-20 16:02:40','',''),(2618285,'1','202','1036',477,'Retail Sale Id 4885',32890.00,0.00,0.00,55.00,32890.00,'2022-04-20 16:10:13','',''),(2618286,'1','202','1036',477,'Retail Sale Id 4886',2702.48,0.00,0.00,4.07,2702.48,'2022-04-20 16:14:58','',''),(2618287,'1','202','1036',477,'Retail Sale Id 4887',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 16:15:46','',''),(2618288,'1','202','1036',477,'Retail Sale Id 4889',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 16:16:42','',''),(2618289,'1','202','1036',477,'Retail Sale Id 4891',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 16:18:44','',''),(2618290,'1','202','1036',477,'Retail Sale Id 4893',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 16:19:32','',''),(2618291,'1','202','1036',477,'Retail Sale Id 4895',2503.28,0.00,0.00,3.77,2503.28,'2022-04-20 16:23:36','',''),(2618292,'1','202','1036',477,'Retail Sale Id 4896',3300.08,0.00,0.00,4.97,3300.08,'2022-04-20 16:25:01','',''),(2618293,'1','202','1036',477,'Retail Sale Id 4898',3300.08,0.00,0.00,4.97,3300.08,'2022-04-20 16:26:10','',''),(2618294,'1','202','1036',477,'Retail Sale Id 4899',8300.00,0.00,0.00,12.50,8300.00,'2022-04-20 16:30:37','',''),(2618295,'1','202','1036',477,'Retail Sale Id 4900',1799.44,0.00,0.00,2.71,1799.44,'2022-04-20 16:33:40','',''),(2618296,'1','202','1036',477,'Retail Sale Id 4901',29900.00,0.00,0.00,50.00,29900.00,'2022-04-20 16:43:13','',''),(2618297,'1','202','1036',477,'Retail Sale Id 4903',2297.44,0.00,0.00,3.46,2297.44,'2022-04-20 16:44:04','',''),(2618298,'1','202','1036',477,'Retail Sale Id 4904',1002.64,0.00,0.00,1.51,1002.64,'2022-04-20 16:44:41','',''),(2618299,'1','202','1036',477,'Retail Sale Id 4907',1002.64,0.00,0.00,1.51,1002.64,'2022-04-20 16:45:22','',''),(2618300,'1','202','1036',477,'Retail Sale Id 4908',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 16:48:03','',''),(2618301,'1','202','1036',477,'Retail Sale Id 4909',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 16:51:39','',''),(2618302,'1','202','1036',477,'Retail Sale Id 4910',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 17:03:45','',''),(2618303,'1','202','1036',477,'Retail Sale Id 4911',1002.64,0.00,0.00,1.51,1002.64,'2022-04-20 17:12:10','',''),(2618304,'1','202','1036',477,'Retail Sale Id 4913',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 17:12:51','',''),(2618305,'1','202','1036',477,'Retail Sale Id 4914',498.00,0.00,0.00,0.75,498.00,'2022-04-20 17:14:09','',''),(2618306,'1','202','1036',477,'Retail Sale Id 4915',3997.28,0.00,0.00,6.02,3997.28,'2022-04-20 17:15:06','',''),(2618307,'1','202','1036',477,'Retail Sale Id 4917',1347.92,0.00,0.00,2.03,1347.92,'2022-04-20 17:23:37','',''),(2618308,'1','202','1036',477,'Retail Sale Id 4918',1500.64,0.00,0.00,2.26,1500.64,'2022-04-20 17:29:19','',''),(2618309,'1','202','1036',477,'Retail Sale Id 4919',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 17:36:49','',''),(2618310,'1','202','1036',477,'Retail Sale Id 4920',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 18:27:59','',''),(2618311,'1','202','1036',477,'Retail Sale Id 4921',1998.64,0.00,0.00,3.01,1998.64,'2022-04-20 18:34:55','',''),(2618312,'1','202','1036',477,'Retail Sale Id 4922',498.00,0.00,0.00,0.75,498.00,'2022-04-20 18:48:04','',''),(2618313,'1','202','1036',477,'Retail Sale Id 4923',1500.64,0.00,0.00,2.26,1500.64,'2022-04-20 19:00:13','',''),(2618314,'1','202','1036',477,'Retail Sale Id 4924',2250.96,0.00,0.00,3.39,2250.96,'2022-04-20 19:19:10','',''),(2618315,'1','202','1036',477,'Retail Sale Id 4925',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 07:00:05','',''),(2618316,'1','202','1036',477,'Retail Sale Id 4926',3001.28,0.00,0.00,4.52,3001.28,'2022-04-21 07:01:16','',''),(2618317,'1','202','1036',477,'Retail Sale Id 4927',8300.00,0.00,0.00,12.50,8300.00,'2022-04-21 07:05:44','',''),(2618318,'1','202','1036',477,'Retail Sale Id 4928',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 07:12:55','',''),(2618319,'1','202','1036',477,'Retail Sale Id 4929',1002.64,0.00,0.00,1.51,1002.64,'2022-04-21 07:14:08','',''),(2618320,'1','202','1036',477,'Retail Sale Id 4930',1998.64,0.00,0.00,3.01,1998.64,'2022-04-21 07:19:47','',''),(2618321,'1','202','1036',477,'Retail Sale Id 4931',3001.28,0.00,0.00,4.52,3001.28,'2022-04-21 07:28:41','',''),(2618322,'1','202','1036',477,'Retail Sale Id 4932',3353.20,0.00,0.00,5.05,3353.20,'2022-04-21 07:29:40','',''),(2618323,'1','202','1036',477,'Retail Sale Id 4933',1347.92,0.00,0.00,2.03,1347.92,'2022-04-21 07:32:48','',''),(2618324,'1','202','1036',477,'Retail Sale Id 4934',23920.00,0.00,0.00,40.00,23920.00,'2022-04-21 07:42:20','',''),(2618325,'1','202','1036',477,'Retail Sale Id 4935',1600.24,0.00,0.00,2.41,1600.24,'2022-04-21 07:43:24','',''),(2618326,'1','202','1036',477,'Retail Sale Id 4936',2702.48,0.00,0.00,4.07,2702.48,'2022-04-21 07:46:07','',''),(2618327,'1','202','1036',477,'Retail Sale Id 4939',6002.56,0.00,0.00,9.04,6002.56,'2022-04-21 07:50:55','',''),(2618328,'1','202','1036',477,'Retail Sale Id 4940',1002.64,0.00,0.00,1.51,1002.64,'2022-04-21 07:54:31','',''),(2618329,'1','202','1036',477,'Retail Sale Id 4941',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 07:59:10','',''),(2618330,'1','202','1036',477,'Retail Sale Id 4942',6998.56,0.00,0.00,10.54,6998.56,'2022-04-21 08:00:00','',''),(2618331,'1','202','1036',477,'Retail Sale Id 4943',29302.00,0.00,0.00,49.00,29302.00,'2022-04-21 08:04:04','',''),(2618332,'1','202','1036',477,'Retail Sale Id 4944',8300.00,0.00,0.00,12.50,8300.00,'2022-04-21 08:06:58','',''),(2618333,'1','202','1036',477,'Retail Sale Id 4947',3001.28,0.00,0.00,4.52,3001.28,'2022-04-21 08:09:12','',''),(2618334,'1','202','1036',477,'Retail Sale Id 4948',2702.48,0.00,0.00,4.07,2702.48,'2022-04-21 08:12:54','',''),(2618335,'1','202','1036',477,'Retail Sale Id 4949',4999.92,0.00,0.00,7.53,4999.92,'2022-04-21 08:13:54','',''),(2618336,'1','202','1036',477,'Retail Sale Id 4950',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 08:16:47','',''),(2618337,'1','202','1036',477,'Retail Sale Id 4951',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 08:17:42','',''),(2618338,'1','202','1036',477,'Retail Sale Id 4952',1002.64,0.00,0.00,1.51,1002.64,'2022-04-21 08:18:30','',''),(2618339,'1','202','1036',477,'Retail Sale Id 4954',1347.92,0.00,0.00,2.03,1347.92,'2022-04-21 08:19:44','',''),(2618340,'1','202','1036',477,'Retail Sale Id 4955',3353.20,0.00,0.00,5.05,3353.20,'2022-04-21 08:20:55','',''),(2618341,'1','202','1036',477,'Retail Sale Id 4956',3353.20,0.00,0.00,5.05,3353.20,'2022-04-21 08:27:14','',''),(2618342,'1','202','1036',477,'Retail Sale Id 4957',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 08:29:07','',''),(2618343,'1','202','1036',477,'Retail Sale Id 4958',1002.64,0.00,0.00,1.51,1002.64,'2022-04-21 08:30:08','',''),(2618344,'1','202','1036',477,'Retail Sale Id 4960',1998.64,0.00,0.00,3.01,1998.64,'2022-04-21 08:30:46','',''),(2618345,'1','202','1036',477,'Retail Sale Id 4962',1002.64,0.00,0.00,1.51,1002.64,'2022-04-21 08:31:33','',''),(2618346,'1','202','1036',477,'Retail Sale Id 4963',3353.20,0.00,0.00,5.05,3353.20,'2022-04-21 08:33:03','',''),(2618347,'1','202','1036',477,'Retail Sale Id 4964',35880.00,0.00,0.00,60.00,35880.00,'2022-04-21 08:34:47','',''),(2618348,'1','202','1036',477,'Retail Sale Id 4967',1201.84,0.00,0.00,1.81,1201.84,'2022-04-21 08:37:11','',''),(2618349,'1','202','1036',477,'Retail Sale Id 4969',1500.64,0.00,0.00,2.26,1500.64,'2022-04-21 08:37:58','',''),(2618350,'1','202','1036',477,'Retail Sale Id 4971',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 08:38:31','',''),(2618351,'1','202','1036',477,'Retail Sale Id 4973',2503.28,0.00,0.00,3.77,2503.28,'2022-04-21 08:40:03','',''),(2618352,'1','202','1036',477,'Retail Sale Id 4975',1002.64,0.00,0.00,1.51,1002.64,'2022-04-21 08:42:36','',''),(2618353,'1','202','1036',477,'Retail Sale Id 4976',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 08:45:54','',''),(2618354,'1','202','1036',477,'Retail Sale Id 4979',6002.56,0.00,0.00,9.04,6002.56,'2022-04-21 08:50:16','',''),(2618355,'1','202','1036',477,'Retail Sale Id 4981',1002.64,0.00,0.00,1.51,1002.64,'2022-04-21 08:54:10','',''),(2618356,'1','202','1036',477,'Retail Sale Id 4982',7475.00,0.00,0.00,12.50,7475.00,'2022-04-21 08:57:54','',''),(2618357,'1','202','1036',477,'Retail Sale Id 4984',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 08:59:25','',''),(2618358,'1','202','1036',477,'Retail Sale Id 4985',1998.64,0.00,0.00,3.01,1998.64,'2022-04-21 09:02:45','',''),(2618359,'1','202','1036',477,'Retail Sale Id 4987',1201.84,0.00,0.00,1.81,1201.84,'2022-04-21 09:03:31','',''),(2618360,'1','202','1036',477,'Retail Sale Id 4988',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 09:06:26','',''),(2618361,'1','202','1036',477,'Retail Sale Id 4989',1998.64,0.00,0.00,3.01,1998.64,'2022-04-21 09:11:38','',''),(2618362,'1','202','1036',477,'Retail Sale Id 4991',10650.56,0.00,0.00,16.04,10650.56,'2022-04-21 09:18:21','',''),(2618363,'1','202','1036',477,'Retail Sale Id 4992',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 09:24:48','',''),(2618364,'1','202','1036',477,'Retail Sale Id 4993',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 09:25:28','',''),(2618365,'1','202','1036',477,'Retail Sale Id 4994',1002.64,0.00,0.00,1.51,1002.64,'2022-04-21 09:26:10','',''),(2618366,'1','202','1036',477,'Retail Sale Id 4995',2656.00,0.00,0.00,4.00,2656.00,'2022-04-21 09:30:14','',''),(2618367,'1','202','1036',477,'Retail Sale Id 4996',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 09:31:28','',''),(2618368,'1','202','1036',477,'Retail Sale Id 4998',1998.64,0.00,0.00,3.01,1998.64,'2022-04-21 09:37:43','',''),(2618369,'1','202','1036',477,'Retail Sale Id 4999',3300.08,0.00,0.00,4.97,3300.08,'2022-04-21 09:42:36','',''),(2618370,'1','202','1036',477,'Retail Sale Id 5000',1500.64,0.00,0.00,2.26,1500.64,'2022-04-21 09:43:26','',''),(2618371,'1','202','1036',477,'Retail Sale Id 5001',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 09:44:06','',''),(2618372,'1','202','1036',477,'Retail Sale Id 5002',8300.00,0.00,0.00,12.50,8300.00,'2022-04-21 09:48:57','',''),(2618373,'1','202','1036',477,'Retail Sale Id 5003',498.00,0.00,0.00,0.75,498.00,'2022-04-21 09:55:41','',''),(2618374,'1','202','1036',477,'Retail Sale Id 5004',4999.92,0.00,0.00,7.53,4999.92,'2022-04-21 10:05:17','',''),(2618375,'1','202','1036',477,'Retail Sale Id 5005',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 10:05:57','',''),(2618376,'1','202','1036',477,'Retail Sale Id 5006',8300.00,0.00,0.00,12.50,8300.00,'2022-04-21 10:07:42','',''),(2618377,'1','202','1036',477,'Retail Sale Id 5007',8300.00,0.00,0.00,12.50,8300.00,'2022-04-21 10:08:43','',''),(2618378,'1','202','1036',477,'Retail Sale Id 5008',1998.64,0.00,0.00,3.01,1998.64,'2022-04-21 10:11:44','',''),(2618379,'1','202','1036',477,'Retail Sale Id 5009',3997.28,0.00,0.00,6.02,3997.28,'2022-04-21 10:17:29','',''),(2618380,'1','202','1036',477,'Retail Sale Id 5010',37674.00,0.00,0.00,63.00,37674.00,'2022-04-21 10:21:09','',''),(2618381,'1','202','1036',477,'Retail Sale Id 5011',41860.00,0.00,0.00,70.00,41860.00,'2022-04-21 10:23:45','',''),(2618382,'1','202','1036',477,'Retail Sale Id 5013',3353.20,0.00,0.00,5.05,3353.20,'2022-04-21 10:27:29','',''),(2618383,'1','202','1036',477,'Return of Retail Sale Id 5011',0.00,41860.00,70.00,0.00,-41860.00,'2022-04-21 11:32:50','',''),(2618384,'1','202','1036',477,'Retail Sale Id 5014',801.32,0.00,0.00,1.34,801.32,'2022-04-21 11:36:27','',''),(2618385,'1','202','1036',477,'Distributed to operational loss for sales id:5',0.00,0.00,0.00,86.25,0.00,'2022-04-21 11:43:44','',''),(2618386,'1','202',NULL,477,'Purchased from AA RANO NIGERIA LIMITED',0.00,14619840.00,25120.00,0.00,0.00,'2022-04-21 11:47:39','',''),(2618387,'1','202',NULL,477,'Reception corrector for bridging 9',0.00,0.00,0.00,25120.00,0.00,'2022-04-21 11:49:57','',''),(2618388,'1','202','1036',477,'Received from bridging 9',0.00,0.00,25120.00,0.00,0.00,'2022-04-21 11:49:57','',''),(2618389,'1','202','1036',477,'Retail Sale Id 5015',83720.00,0.00,0.00,140.00,2240.00,'2022-04-21 12:15:27','',''),(2618390,'1','202','1036',477,'Retail Sale Id 5017',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 12:18:28','',''),(2618391,'1','202','1036',477,'Retail Sale Id 5018',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 12:20:24','',''),(2618392,'1','202','1036',477,'Retail Sale Id 5020',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 12:21:04','',''),(2618393,'1','202','1036',477,'Retail Sale Id 5021',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 12:22:10','',''),(2618394,'1','202','1036',477,'Retail Sale Id 5023',8300.00,0.00,0.00,12.50,1025.00,'2022-04-21 12:22:50','',''),(2618395,'1','202','1036',477,'Retail Sale Id 5024',3997.28,0.00,0.00,6.02,493.64,'2022-04-21 12:24:21','',''),(2618396,'1','202','1036',477,'Retail Sale Id 5026',3997.28,0.00,0.00,6.02,493.64,'2022-04-21 12:25:03','',''),(2618397,'1','202','1036',477,'Retail Sale Id 5028',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 12:25:48','',''),(2618398,'1','202','1036',477,'Retail Sale Id 5030',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 12:36:40','',''),(2618399,'1','202','1036',477,'Retail Sale Id 5031',3652.00,0.00,0.00,5.50,451.00,'2022-04-21 12:41:44','',''),(2618400,'1','202','1036',477,'Retail Sale Id 5032',19734.00,0.00,0.00,33.00,528.00,'2022-04-21 12:43:35','',''),(2618401,'1','202','1036',477,'Retail Sale Id 5033',1500.64,0.00,0.00,2.26,185.32,'2022-04-21 12:45:28','',''),(2618402,'1','202','1036',477,'Retail Sale Id 5035',1301.44,0.00,0.00,1.96,160.72,'2022-04-21 12:51:40','',''),(2618403,'1','202','1036',477,'Retail Sale Id 5036',29900.00,0.00,0.00,50.00,800.00,'2022-04-21 12:57:19','',''),(2618404,'1','202','1036',477,'Retail Sale Id 5037',2702.48,0.00,0.00,4.07,333.74,'2022-04-21 13:00:48','',''),(2618405,'1','202','1036',477,'Retail Sale Id 5038',43654.00,0.00,0.00,73.00,1168.00,'2022-04-21 13:17:03','',''),(2618406,'1','202','1036',477,'Retail Sale Id 5039',3997.28,0.00,0.00,6.02,493.64,'2022-04-21 13:48:17','',''),(2618407,'1','202','1036',477,'Retail Sale Id 5040',3499.28,0.00,0.00,5.27,432.14,'2022-04-21 13:56:35','',''),(2618408,'1','202','1036',477,'Retail Sale Id 5041',3499.28,0.00,0.00,5.27,432.14,'2022-04-21 13:57:07','',''),(2618409,'1','202','1036',477,'Retail Sale Id 5042',1347.92,0.00,0.00,2.03,166.46,'2022-04-21 14:03:13','',''),(2618410,'1','202','1036',477,'Retail Sale Id 5043',3997.28,0.00,0.00,6.02,493.64,'2022-04-21 14:10:00','',''),(2618411,'1','202','1036',477,'Retail Sale Id 5044',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 14:10:54','',''),(2618412,'1','202','1036',477,'Retail Sale Id 5045',2702.48,0.00,0.00,4.07,333.74,'2022-04-21 14:21:32','',''),(2618413,'1','202','1036',477,'Retail Sale Id 5046',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 14:24:14','',''),(2618414,'1','202','1036',477,'Retail Sale Id 5046',8300.00,0.00,0.00,12.50,1025.00,'2022-04-21 14:24:14','',''),(2618415,'1','202','1036',477,'Retail Sale Id 5047',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 14:49:54','',''),(2618416,'1','202','1036',477,'Retail Sale Id 5048',3997.28,0.00,0.00,6.02,493.64,'2022-04-21 14:53:34','',''),(2618417,'1','202','1036',477,'Retail Sale Id 5049',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 15:14:08','',''),(2618418,'1','202','1036',477,'Retail Sale Id 5050',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 15:15:16','',''),(2618419,'1','202','1036',477,'Retail Sale Id 5051',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 15:21:24','',''),(2618420,'1','202','1036',477,'Retail Sale Id 5052',3300.08,0.00,0.00,4.97,407.54,'2022-04-21 15:23:58','',''),(2618421,'1','202','1036',477,'Retail Sale Id 5053',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 15:29:18','',''),(2618422,'1','202','1036',477,'Retail Sale Id 5054',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 15:32:19','',''),(2618423,'1','202','1036',477,'Retail Sale Id 5055',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 15:33:05','',''),(2618424,'1','202','1036',477,'Retail Sale Id 5056',1799.44,0.00,0.00,2.71,222.22,'2022-04-21 15:42:26','',''),(2618425,'1','202','1036',477,'Retail Sale Id 5057',29900.00,0.00,0.00,50.00,800.00,'2022-04-21 15:50:12','',''),(2618426,'1','202','1036',477,'Retail Sale Id 5058',3001.28,0.00,0.00,4.52,370.64,'2022-04-21 15:51:12','',''),(2618427,'1','202','1036',477,'Retail Sale Id 5059',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 15:52:30','',''),(2618428,'1','202','1036',477,'Retail Sale Id 5060',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 15:58:33','',''),(2618429,'1','202','1036',477,'Retail Sale Id 5061',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 15:59:31','',''),(2618430,'1','202','1036',477,'Retail Sale Id 5062',8300.00,0.00,0.00,12.50,1025.00,'2022-04-21 16:04:47','',''),(2618431,'1','202','1036',477,'Retail Sale Id 5063',35880.00,0.00,0.00,60.00,960.00,'2022-04-21 16:12:26','',''),(2618432,'1','202','1036',477,'Retail Sale Id 5064',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 16:15:45','',''),(2618433,'1','202','1036',477,'Retail Sale Id 5065',1347.92,0.00,0.00,2.03,166.46,'2022-04-21 16:18:55','',''),(2618434,'1','202','1036',477,'Retail Sale Id 5066',23920.00,0.00,0.00,40.00,640.00,'2022-04-21 16:23:20','',''),(2618435,'1','202','1036',477,'Retail Sale Id 5067',3001.28,0.00,0.00,4.52,370.64,'2022-04-21 16:24:21','',''),(2618436,'1','202','1036',477,'Retail Sale Id 5068',3001.28,0.00,0.00,4.52,370.64,'2022-04-21 16:26:33','',''),(2618437,'1','202','1036',477,'Retail Sale Id 5069',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 16:31:38','',''),(2618438,'1','202','1036',477,'Retail Sale Id 5070',3001.28,0.00,0.00,4.52,370.64,'2022-04-21 16:32:23','',''),(2618439,'1','202','1036',477,'Retail Sale Id 5071',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 16:34:24','',''),(2618440,'1','202','1036',477,'Retail Sale Id 5072',1899.04,0.00,0.00,2.86,234.52,'2022-04-21 16:39:59','',''),(2618441,'1','202','1036',477,'Retail Sale Id 5073',1500.64,0.00,0.00,2.26,185.32,'2022-04-21 16:40:46','',''),(2618442,'1','202','1036',477,'Retail Sale Id 5074',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 16:41:48','',''),(2618443,'1','202','1036',477,'Retail Sale Id 5075',8300.00,0.00,0.00,12.50,1025.00,'2022-04-21 16:44:33','',''),(2618444,'1','202','1036',477,'Retail Sale Id 5076',3997.28,0.00,0.00,6.02,493.64,'2022-04-21 16:45:40','',''),(2618445,'1','202','1036',477,'Retail Sale Id 5077',3997.28,0.00,0.00,6.02,493.64,'2022-04-21 16:48:40','',''),(2618446,'1','202','1036',477,'Retail Sale Id 5078',3997.28,0.00,0.00,6.02,493.64,'2022-04-21 16:49:36','',''),(2618447,'1','202','1036',477,'Retail Sale Id 5079',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 16:50:19','',''),(2618448,'1','202','1036',477,'Retail Sale Id 5080',3001.28,0.00,0.00,4.52,370.64,'2022-04-21 16:50:52','',''),(2618449,'1','202','1036',477,'Retail Sale Id 5082',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 16:58:59','',''),(2618450,'1','202','1036',477,'Retail Sale Id 5083',1301.44,0.00,0.00,1.96,160.72,'2022-04-21 17:02:09','',''),(2618451,'1','202','1036',477,'Retail Sale Id 5084',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 17:02:47','',''),(2618452,'1','202','1036',477,'Retail Sale Id 5085',8300.00,0.00,0.00,12.50,1025.00,'2022-04-21 17:06:36','',''),(2618453,'1','202','1036',477,'Retail Sale Id 5086',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 17:07:19','',''),(2618454,'1','202','1036',477,'Retail Sale Id 5087',1500.64,0.00,0.00,2.26,185.32,'2022-04-21 17:07:59','',''),(2618455,'1','202','1036',477,'Retail Sale Id 5088',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 17:09:59','',''),(2618456,'1','202','1036',477,'Retail Sale Id 5089',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 17:11:14','',''),(2618457,'1','202','1036',477,'Retail Sale Id 5090',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 17:11:57','',''),(2618458,'1','202','1036',477,'Retail Sale Id 5091',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 17:12:40','',''),(2618459,'1','202','1036',477,'Retail Sale Id 5092',3001.28,0.00,0.00,4.52,370.64,'2022-04-21 17:13:34','',''),(2618460,'1','202','1036',477,'Retail Sale Id 5093',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 17:22:15','',''),(2618461,'1','202','1036',477,'Retail Sale Id 5095',3997.28,0.00,0.00,6.02,493.64,'2022-04-21 17:30:32','',''),(2618462,'1','202','1036',477,'Retail Sale Id 5096',32890.00,0.00,0.00,55.00,880.00,'2022-04-21 17:40:35','',''),(2618463,'1','202','1036',477,'Retail Sale Id 5097',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 17:43:49','',''),(2618464,'1','202','1036',477,'Retail Sale Id 5098',1500.64,0.00,0.00,2.26,185.32,'2022-04-21 17:47:34','',''),(2618465,'1','202','1036',477,'Retail Sale Id 5098',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 17:47:34','',''),(2618466,'1','202','1036',477,'Retail Sale Id 5099',29900.00,0.00,0.00,50.00,800.00,'2022-04-21 17:50:59','',''),(2618467,'1','202','1036',477,'Retail Sale Id 5100',8300.00,0.00,0.00,12.50,1025.00,'2022-04-21 18:00:28','',''),(2618468,'1','202','1036',477,'Retail Sale Id 5101',3997.28,0.00,0.00,6.02,493.64,'2022-04-21 18:26:12','',''),(2618469,'1','202','1036',477,'Retail Sale Id 5102',8300.00,0.00,0.00,12.50,1025.00,'2022-04-21 18:27:24','',''),(2618470,'1','202','1036',477,'Retail Sale Id 5103',1998.64,0.00,0.00,3.01,246.82,'2022-04-21 18:28:39','',''),(2618471,'1','202','1036',477,'Retail Sale Id 5104',1002.64,0.00,0.00,1.51,123.82,'2022-04-21 18:37:57','',''),(2618472,'1','202','1036',477,'Retail Sale Id 5105',3300.08,0.00,0.00,4.97,407.54,'2022-04-21 18:42:30','',''),(2618473,'1','202','1036',477,'Retail Sale Id 5106',471.44,0.00,0.00,0.71,58.22,'2022-04-21 19:27:04','',''),(2618474,'1','202','1036',477,'Retail Sale Id 5107',697.20,0.00,0.00,1.05,86.10,'2022-04-22 07:01:03','',''),(2618475,'1','202','1036',477,'Retail Sale Id 5108',269100.00,0.00,0.00,450.00,7200.00,'2022-04-22 07:05:54','',''),(2618476,'1','202','1036',477,'Retail Sale Id 5109',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 07:06:28','',''),(2618477,'1','202','1036',477,'Retail Sale Id 5110',3200.48,0.00,0.00,4.82,395.24,'2022-04-22 07:09:25','',''),(2618478,'1','202','1036',477,'Retail Sale Id 5111',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 07:10:30','',''),(2618479,'1','202','1036',477,'Retail Sale Id 5112',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 07:15:47','',''),(2618480,'1','202','1036',477,'Retail Sale Id 5113',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 07:20:49','',''),(2618481,'1','202','1036',477,'Retail Sale Id 5114',2702.48,0.00,0.00,4.07,333.74,'2022-04-22 07:33:39','',''),(2618482,'1','202','1036',477,'Retail Sale Id 5115',4203.12,0.00,0.00,6.33,519.06,'2022-04-22 07:34:28','',''),(2618483,'1','202','1036',477,'Retail Sale Id 5116',796.80,0.00,0.00,1.20,98.40,'2022-04-22 07:43:26','',''),(2618484,'1','202','1036',477,'Retail Sale Id 5117',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 07:44:34','',''),(2618485,'1','202','1036',477,'Retail Sale Id 5118',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 07:52:38','',''),(2618486,'1','202','1036',477,'Retail Sale Id 5119',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 07:55:08','',''),(2618487,'1','202','1036',477,'Retail Sale Id 5120',8001.20,0.00,0.00,12.05,988.10,'2022-04-22 07:56:03','',''),(2618488,'1','202','1036',477,'Retail Sale Id 5121',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 08:02:19','',''),(2618489,'1','202','1036',477,'Retail Sale Id 5122',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 08:02:52','',''),(2618490,'1','202','1036',477,'Retail Sale Id 5123',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 08:09:26','',''),(2618491,'1','202','1036',477,'Retail Sale Id 5124',1500.64,0.00,0.00,2.26,185.32,'2022-04-22 08:11:50','',''),(2618492,'1','202','1036',477,'Retail Sale Id 5125',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 08:30:31','',''),(2618493,'1','202','1036',477,'Retail Sale Id 5126',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 08:40:28','',''),(2618494,'1','202','1036',477,'Retail Sale Id 5127',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 08:43:42','',''),(2618495,'1','202','1036',477,'Retail Sale Id 5128',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 08:48:39','',''),(2618496,'1','202','1036',477,'Retail Sale Id 5130',697.20,0.00,0.00,1.05,86.10,'2022-04-22 08:50:49','',''),(2618497,'1','202','1036',477,'Retail Sale Id 5131',2503.28,0.00,0.00,3.77,309.14,'2022-04-22 08:55:49','',''),(2618498,'1','202','1036',477,'Retail Sale Id 5132',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 08:59:33','',''),(2618499,'1','202','1036',477,'Retail Sale Id 5133',1500.64,0.00,0.00,2.26,185.32,'2022-04-22 09:00:24','',''),(2618500,'1','202','1036',477,'Retail Sale Id 5134',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 09:06:44','',''),(2618501,'1','202','1036',477,'Retail Sale Id 5135',2702.48,0.00,0.00,4.07,333.74,'2022-04-22 09:07:40','',''),(2618502,'1','202','1036',477,'Retail Sale Id 5136',4648.00,0.00,0.00,7.00,574.00,'2022-04-22 09:12:54','',''),(2618503,'1','202','1036',477,'Retail Sale Id 5137',3353.20,0.00,0.00,5.05,414.10,'2022-04-22 09:14:34','',''),(2618504,'1','202','1036',477,'Retail Sale Id 5138',3300.08,0.00,0.00,4.97,407.54,'2022-04-22 09:18:21','',''),(2618505,'1','202','1036',477,'Retail Sale Id 5139',2503.28,0.00,0.00,3.77,309.14,'2022-04-22 09:19:12','',''),(2618506,'1','202','1036',477,'Retail Sale Id 5140',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 09:20:23','',''),(2618507,'1','202','1036',477,'Retail Sale Id 5141',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 09:21:00','',''),(2618508,'1','202','1036',477,'Retail Sale Id 5142',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 09:29:48','',''),(2618509,'1','202','1036',477,'Retail Sale Id 5143',8300.00,0.00,0.00,12.50,1025.00,'2022-04-22 09:35:03','',''),(2618510,'1','202','1036',477,'Retail Sale Id 5144',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 09:39:05','',''),(2618511,'1','202','1036',477,'Retail Sale Id 5144',4999.92,0.00,0.00,7.53,617.46,'2022-04-22 09:39:05','',''),(2618512,'1','202','1036',477,'Retail Sale Id 5145',41860.00,0.00,0.00,70.00,1120.00,'2022-04-22 09:48:10','',''),(2618513,'1','202','1036',477,'Retail Sale Id 5146',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 09:52:57','',''),(2618514,'1','202','1036',477,'Retail Sale Id 5146',8300.00,0.00,0.00,12.50,1025.00,'2022-04-22 09:52:57','',''),(2618515,'1','202','1036',477,'Retail Sale Id 5147',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 09:59:51','',''),(2618516,'1','202','1036',477,'Retail Sale Id 5148',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 10:05:19','',''),(2618517,'1','202','1036',477,'Retail Sale Id 5149',3399.68,0.00,0.00,5.12,419.84,'2022-04-22 10:18:59','',''),(2618518,'1','202','1036',477,'Retail Sale Id 5150',2503.28,0.00,0.00,3.77,309.14,'2022-04-22 10:22:50','',''),(2618519,'1','202','1036',477,'Retail Sale Id 5151',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 10:32:17','',''),(2618520,'1','202','1036',477,'Retail Sale Id 5152',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 10:37:48','',''),(2618521,'1','202','1036',477,'Retail Sale Id 5153',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 10:39:24','',''),(2618522,'1','202','1036',477,'Retail Sale Id 5154',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 10:42:19','',''),(2618523,'1','202','1036',477,'Retail Sale Id 5155',4999.92,0.00,0.00,7.53,617.46,'2022-04-22 10:44:42','',''),(2618524,'1','202','1036',477,'Retail Sale Id 5156',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 10:45:32','',''),(2618525,'1','202','1036',477,'Retail Sale Id 5157',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 10:50:18','',''),(2618526,'1','202','1036',477,'Retail Sale Id 5158',23920.00,0.00,0.00,40.00,640.00,'2022-04-22 10:53:21','',''),(2618527,'1','202','1036',477,'Retail Sale Id 5159',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 10:54:51','',''),(2618528,'1','202','1036',477,'Retail Sale Id 5160',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 11:00:23','',''),(2618529,'1','202','1036',477,'Retail Sale Id 5161',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 11:03:18','',''),(2618530,'1','202','1036',477,'Retail Sale Id 5162',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 11:08:07','',''),(2618531,'1','202','1036',477,'Retail Sale Id 5163',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 11:18:44','',''),(2618532,'1','202','1036',477,'Retail Sale Id 5164',3499.28,0.00,0.00,5.27,432.14,'2022-04-22 11:21:45','',''),(2618533,'1','202','1036',477,'Retail Sale Id 5165',9302.64,0.00,0.00,14.01,1148.82,'2022-04-22 11:32:34','',''),(2618534,'1','202','1036',477,'Retail Sale Id 5166',41860.00,0.00,0.00,70.00,1120.00,'2022-04-22 11:45:49','',''),(2618535,'1','202','1036',477,'Retail Sale Id 5167',2503.28,0.00,0.00,3.77,309.14,'2022-04-22 11:48:22','',''),(2618536,'1','202','1036',477,'Retail Sale Id 5168',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 11:49:29','',''),(2618537,'1','202','1036',477,'Retail Sale Id 5170',3353.20,0.00,0.00,5.05,414.10,'2022-04-22 11:54:36','',''),(2618538,'1','202','1036',477,'Retail Sale Id 5171',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 11:55:54','',''),(2618539,'1','202','1036',477,'Retail Sale Id 5172',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 11:56:35','',''),(2618540,'1','202','1036',477,'Retail Sale Id 5174',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 12:02:15','',''),(2618541,'1','202','1036',477,'Retail Sale Id 5175',1500.64,0.00,0.00,2.26,185.32,'2022-04-22 12:03:03','',''),(2618542,'1','202','1036',477,'Retail Sale Id 5176',2702.48,0.00,0.00,4.07,333.74,'2022-04-22 12:10:17','',''),(2618543,'1','202','1036',477,'Retail Sale Id 5177',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 12:12:22','',''),(2618544,'1','202','1036',477,'Retail Sale Id 5178',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 12:18:44','',''),(2618545,'1','202','1036',477,'Retail Sale Id 5179',3353.20,0.00,0.00,5.05,414.10,'2022-04-22 12:20:03','',''),(2618546,'1','202','1036',477,'Retail Sale Id 5180',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 12:23:11','',''),(2618547,'1','202','1036',477,'Retail Sale Id 5181',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 12:24:06','',''),(2618548,'1','202','1036',477,'Retail Sale Id 5182',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 12:37:04','',''),(2618549,'1','202','1036',477,'Retail Sale Id 5183',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 12:41:55','',''),(2618550,'1','202','1036',477,'Retail Sale Id 5184',16744.00,0.00,0.00,28.00,448.00,'2022-04-22 12:45:24','',''),(2618551,'1','202','1036',477,'Retail Sale Id 5185',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 12:53:53','',''),(2618552,'1','202','1036',477,'Retail Sale Id 5186',6653.28,0.00,0.00,10.02,821.64,'2022-04-22 13:04:29','',''),(2618553,'1','202','1036',477,'Retail Sale Id 5187',19920.00,0.00,0.00,30.00,2460.00,'2022-04-22 13:10:54','',''),(2618554,'1','202','1036',477,'Retail Sale Id 5188',4501.92,0.00,0.00,6.78,555.96,'2022-04-22 13:12:07','',''),(2618555,'1','202','1036',477,'Retail Sale Id 5189',1500.64,0.00,0.00,2.26,185.32,'2022-04-22 13:13:12','',''),(2618556,'1','202','1036',477,'Retail Sale Id 5190',8001.20,0.00,0.00,12.05,988.10,'2022-04-22 13:15:08','',''),(2618557,'1','202','1036',477,'Retail Sale Id 5191',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 13:17:34','',''),(2618558,'1','202','1036',477,'Retail Sale Id 5192',1799.44,0.00,0.00,2.71,222.22,'2022-04-22 13:18:36','',''),(2618559,'1','202','1036',477,'Retail Sale Id 5193',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 13:37:40','',''),(2618560,'1','202','1036',477,'Retail Sale Id 5194',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 13:42:03','',''),(2618561,'1','202','1036',477,'Retail Sale Id 5195',8300.00,0.00,0.00,12.50,1025.00,'2022-04-22 13:47:44','',''),(2618562,'1','202','1036',477,'Retail Sale Id 5196',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 13:53:03','',''),(2618563,'1','202','1036',477,'Retail Sale Id 5198',1660.00,0.00,0.00,2.50,205.00,'2022-04-22 13:57:11','',''),(2618564,'1','202','1036',477,'Retail Sale Id 5199',23920.00,0.00,0.00,40.00,640.00,'2022-04-22 13:59:19','',''),(2618565,'1','202','1036',477,'Retail Sale Id 5200',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 14:03:34','',''),(2618566,'1','202','1036',477,'Retail Sale Id 5201',8300.00,0.00,0.00,12.50,1025.00,'2022-04-22 14:06:48','',''),(2618567,'1','202','1036',477,'Retail Sale Id 5202',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 14:18:02','',''),(2618568,'1','202','1036',477,'Retail Sale Id 5203',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 14:31:49','',''),(2618569,'1','202','1036',477,'Retail Sale Id 5205',1347.92,0.00,0.00,2.03,166.46,'2022-04-22 14:33:49','',''),(2618570,'1','202','1036',477,'Retail Sale Id 5208',8300.00,0.00,0.00,12.50,1025.00,'2022-04-22 14:40:11','',''),(2618571,'1','202','1036',477,'Retail Sale Id 5209',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 14:41:45','',''),(2618572,'1','202','1036',477,'Retail Sale Id 5209',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 14:41:45','',''),(2618573,'1','202','1036',477,'Retail Sale Id 5211',4999.92,0.00,0.00,7.53,617.46,'2022-04-22 14:42:36','',''),(2618574,'1','202','1036',477,'Retail Sale Id 5212',498.00,0.00,0.00,0.75,61.50,'2022-04-22 14:55:22','',''),(2618575,'1','202','1036',477,'Retail Sale Id 5213',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 15:10:52','',''),(2618576,'1','202','1036',477,'Retail Sale Id 5214',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 15:12:23','',''),(2618577,'1','202','1036',477,'Retail Sale Id 5215',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 15:22:38','',''),(2618578,'1','202','1036',477,'Retail Sale Id 5216',4999.92,0.00,0.00,7.53,617.46,'2022-04-22 15:24:15','',''),(2618579,'1','202','1036',477,'Retail Sale Id 5217',2503.28,0.00,0.00,3.77,309.14,'2022-04-22 15:30:47','',''),(2618580,'1','202','1036',477,'Retail Sale Id 5218',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 15:34:06','',''),(2618581,'1','202','1036',477,'Retail Sale Id 5219',3353.20,0.00,0.00,5.05,414.10,'2022-04-22 15:35:18','',''),(2618582,'1','202','1036',477,'Retail Sale Id 5220',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 15:48:19','',''),(2618583,'1','202','1036',477,'Retail Sale Id 5221',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 16:02:26','',''),(2618584,'1','202','1036',477,'Retail Sale Id 5222',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 16:03:52','',''),(2618585,'1','202','1036',477,'Retail Sale Id 5223',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 16:09:11','',''),(2618586,'1','202','1036',477,'Retail Sale Id 5225',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 16:12:23','',''),(2618587,'1','202','1036',477,'Retail Sale Id 5227',597.60,0.00,0.00,0.90,73.80,'2022-04-22 16:13:16','',''),(2618588,'1','202','1036',477,'Retail Sale Id 5228',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 16:14:38','',''),(2618589,'1','202','1036',477,'Retail Sale Id 5229',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 16:15:28','',''),(2618590,'1','202','1036',477,'Retail Sale Id 5230',29900.00,0.00,0.00,50.00,800.00,'2022-04-22 16:21:48','',''),(2618591,'1','202','1036',477,'Retail Sale Id 5231',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 16:25:59','',''),(2618592,'1','202','1036',477,'Retail Sale Id 5234',29899.92,0.00,0.00,45.03,3692.46,'2022-04-22 16:48:26','',''),(2618593,'1','202','1036',477,'Retail Sale Id 5235',6600.16,0.00,0.00,9.94,815.08,'2022-04-22 16:51:31','',''),(2618594,'1','202','1036',477,'Return of Retail Sale Id 5234',0.00,29899.92,45.03,0.00,-3692.46,'2022-04-22 16:53:11','',''),(2618595,'1','202','1036',477,'Retail Sale Id 5236',29900.00,0.00,0.00,50.00,800.00,'2022-04-22 16:54:15','',''),(2618596,'1','202','1036',477,'Retail Sale Id 5237',8300.00,0.00,0.00,12.50,1025.00,'2022-04-22 16:56:34','',''),(2618597,'1','202','1036',477,'Retail Sale Id 5238',1500.64,0.00,0.00,2.26,185.32,'2022-04-22 16:57:50','',''),(2618598,'1','202','1036',477,'Retail Sale Id 5239',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 16:58:46','',''),(2618599,'1','202','1036',477,'Retail Sale Id 5240',6653.28,0.00,0.00,10.02,821.64,'2022-04-22 16:59:28','',''),(2618600,'1','202','1036',477,'Retail Sale Id 5242',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 17:00:27','',''),(2618601,'1','202','1036',477,'Retail Sale Id 5244',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 17:01:09','',''),(2618602,'1','202','1036',477,'Retail Sale Id 5245',2503.28,0.00,0.00,3.77,309.14,'2022-04-22 17:01:53','',''),(2618603,'1','202','1036',477,'Retail Sale Id 5248',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 17:02:41','',''),(2618604,'1','202','1036',477,'Retail Sale Id 5251',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 17:04:41','',''),(2618605,'1','202','1036',477,'Retail Sale Id 5252',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 17:10:06','',''),(2618606,'1','202','1036',477,'Retail Sale Id 5253',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 17:12:50','',''),(2618607,'1','202','1036',477,'Retail Sale Id 5254',3499.28,0.00,0.00,5.27,432.14,'2022-04-22 17:21:38','',''),(2618608,'1','202','1036',477,'Retail Sale Id 5255',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 17:24:43','',''),(2618609,'1','202','1036',477,'Retail Sale Id 5256',498.00,0.00,0.00,0.75,61.50,'2022-04-22 17:26:15','',''),(2618610,'1','202','1036',477,'Retail Sale Id 5257',8300.00,0.00,0.00,12.50,1025.00,'2022-04-22 17:27:52','',''),(2618611,'1','202','1036',477,'Retail Sale Id 5258',2702.48,0.00,0.00,4.07,333.74,'2022-04-22 17:36:07','',''),(2618612,'1','202','1036',477,'Retail Sale Id 5259',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 17:36:53','',''),(2618613,'1','202','1036',477,'Retail Sale Id 5260',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 17:47:40','',''),(2618614,'1','202','1036',477,'Retail Sale Id 5262',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 17:48:14','',''),(2618615,'1','202','1036',477,'Retail Sale Id 5263',2802.08,0.00,0.00,4.22,346.04,'2022-04-22 17:50:40','',''),(2618616,'1','202','1036',477,'Retail Sale Id 5264',3353.20,0.00,0.00,5.05,414.10,'2022-04-22 17:52:06','',''),(2618617,'1','202','1036',477,'Retail Sale Id 5267',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 17:53:08','',''),(2618618,'1','202','1036',477,'Retail Sale Id 5268',8300.00,0.00,0.00,12.50,1025.00,'2022-04-22 17:54:04','',''),(2618619,'1','202','1036',477,'Retail Sale Id 5269',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 17:56:42','',''),(2618620,'1','202','1036',477,'Retail Sale Id 5269',8300.00,0.00,0.00,12.50,1025.00,'2022-04-22 17:56:42','',''),(2618621,'1','202','1036',477,'Retail Sale Id 5270',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 18:00:10','',''),(2618622,'1','202','1036',477,'Retail Sale Id 5271',3353.20,0.00,0.00,5.05,414.10,'2022-04-22 18:08:13','',''),(2618623,'1','202','1036',477,'Retail Sale Id 5273',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 18:09:54','',''),(2618624,'1','202','1036',477,'Retail Sale Id 5274',8300.00,0.00,0.00,12.50,1025.00,'2022-04-22 18:11:39','',''),(2618625,'1','202','1036',477,'Retail Sale Id 5275',3997.28,0.00,0.00,6.02,493.64,'2022-04-22 18:16:00','',''),(2618626,'1','202','1036',477,'Retail Sale Id 5276',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 18:20:13','',''),(2618627,'1','202','1036',477,'Retail Sale Id 5277',6653.28,0.00,0.00,10.02,821.64,'2022-04-22 18:20:59','',''),(2618628,'1','202','1036',477,'Retail Sale Id 5279',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 18:22:27','',''),(2618629,'1','202','1036',477,'Retail Sale Id 5281',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 18:26:27','',''),(2618630,'1','202','1036',477,'Retail Sale Id 5282',1347.92,0.00,0.00,2.03,166.46,'2022-04-22 18:44:51','',''),(2618631,'1','202','1036',477,'Retail Sale Id 5284',1002.64,0.00,0.00,1.51,123.82,'2022-04-22 18:48:54','',''),(2618632,'1','202','1036',477,'Retail Sale Id 5286',2503.28,0.00,0.00,3.77,309.14,'2022-04-22 18:56:54','',''),(2618633,'1','202','1036',477,'Retail Sale Id 5288',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 18:57:31','',''),(2618634,'1','202','1036',477,'Retail Sale Id 5290',3001.28,0.00,0.00,4.52,370.64,'2022-04-22 18:58:21','',''),(2618635,'1','202','1036',477,'Retail Sale Id 5291',2702.48,0.00,0.00,4.07,333.74,'2022-04-22 18:59:08','',''),(2618636,'1','202','1036',477,'Retail Sale Id 5294',6699.76,0.00,0.00,10.09,827.38,'2022-04-22 19:00:27','',''),(2618637,'1','202','1036',477,'Retail Sale Id 5296',1998.64,0.00,0.00,3.01,246.82,'2022-04-22 19:01:29','',''),(2618638,'1','202','1036',477,'Retail Sale Id 5298',8001.20,0.00,0.00,12.05,988.10,'2022-04-22 19:19:07','',''),(2618639,'1','202','1036',477,'Retail Sale Id 5300',11500.48,0.00,0.00,17.32,1420.24,'2022-04-23 06:55:23','',''),(2618640,'1','202','1036',477,'Retail Sale Id 5301',3499.28,0.00,0.00,5.27,432.14,'2022-04-23 06:58:17','',''),(2618641,'1','202','1036',477,'Retail Sale Id 5302',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 07:18:03','',''),(2618642,'1','202','1036',477,'Retail Sale Id 5303',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 07:25:56','',''),(2618643,'1','202','1036',477,'Retail Sale Id 5304',3001.28,0.00,0.00,4.52,370.64,'2022-04-23 07:27:12','',''),(2618644,'1','202','1036',477,'Retail Sale Id 5305',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 07:28:41','',''),(2618645,'1','202','1036',477,'Retail Sale Id 5305',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 07:28:41','',''),(2618646,'1','202','1036',477,'Retail Sale Id 5306',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 07:39:17','',''),(2618647,'1','202','1036',477,'Retail Sale Id 5307',697.20,0.00,0.00,1.05,86.10,'2022-04-23 07:44:25','',''),(2618648,'1','202','1036',477,'Retail Sale Id 5308',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 07:57:18','',''),(2618649,'1','202','1036',477,'Retail Sale Id 5310',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 07:59:37','',''),(2618650,'1','202','1036',477,'Retail Sale Id 5311',1600.24,0.00,0.00,2.41,197.62,'2022-04-23 08:06:13','',''),(2618651,'1','202','1036',477,'Retail Sale Id 5313',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 08:07:19','',''),(2618652,'1','202','1036',477,'Retail Sale Id 5314',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 08:09:32','',''),(2618653,'1','202','1036',477,'Retail Sale Id 5317',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 08:10:04','',''),(2618654,'1','202','1036',477,'Retail Sale Id 5318',6653.28,0.00,0.00,10.02,821.64,'2022-04-23 08:11:08','',''),(2618655,'1','202','1036',477,'Retail Sale Id 5319',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 08:12:35','',''),(2618656,'1','202','1036',477,'Retail Sale Id 5320',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 08:15:07','',''),(2618657,'1','202','1036',477,'Retail Sale Id 5321',4999.92,0.00,0.00,7.53,617.46,'2022-04-23 08:15:52','',''),(2618658,'1','202','1036',477,'Retail Sale Id 5324',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 08:16:32','',''),(2618659,'1','202','1036',477,'Retail Sale Id 5325',1347.92,0.00,0.00,2.03,166.46,'2022-04-23 08:22:20','',''),(2618660,'1','202','1036',477,'Retail Sale Id 5326',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 08:24:39','',''),(2618661,'1','202','1036',477,'Retail Sale Id 5327',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 08:25:54','',''),(2618662,'1','202','1036',477,'Retail Sale Id 5328',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 08:27:13','',''),(2618663,'1','202','1036',477,'Retail Sale Id 5329',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 08:32:49','',''),(2618664,'1','202','1036',477,'Retail Sale Id 5331',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 08:33:21','',''),(2618665,'1','202','1036',477,'Retail Sale Id 5333',3001.28,0.00,0.00,4.52,370.64,'2022-04-23 08:34:32','',''),(2618666,'1','202','1036',477,'Retail Sale Id 5334',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 08:42:21','',''),(2618667,'1','202','1036',477,'Retail Sale Id 5335',14352.00,0.00,0.00,24.00,384.00,'2022-04-23 08:47:03','',''),(2618668,'1','202','1036',477,'Retail Sale Id 5336',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 08:47:53','',''),(2618669,'1','202','1036',477,'Retail Sale Id 5337',498.00,0.00,0.00,0.75,61.50,'2022-04-23 08:52:17','',''),(2618670,'1','202','1036',477,'Retail Sale Id 5338',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 08:53:22','',''),(2618671,'1','202','1036',477,'Retail Sale Id 5339',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 09:03:42','',''),(2618672,'1','202','1036',477,'Retail Sale Id 5341',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 09:04:22','',''),(2618673,'1','202','1036',477,'Retail Sale Id 5342',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 09:06:52','',''),(2618674,'1','202','1036',477,'Retail Sale Id 5343',3300.08,0.00,0.00,4.97,407.54,'2022-04-23 09:12:20','',''),(2618675,'1','202','1036',477,'Retail Sale Id 5344',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 09:13:30','',''),(2618676,'1','202','1036',477,'Retail Sale Id 5345',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 09:15:38','',''),(2618677,'1','202','1036',477,'Retail Sale Id 5347',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 09:17:21','',''),(2618678,'1','202','1036',477,'Retail Sale Id 5348',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 09:19:38','',''),(2618679,'1','202','1036',477,'Retail Sale Id 5349',1401.04,0.00,0.00,2.11,173.02,'2022-04-23 09:21:28','',''),(2618680,'1','202','1036',477,'Retail Sale Id 5351',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 09:22:01','',''),(2618681,'1','202','1036',477,'Retail Sale Id 5352',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 09:23:37','',''),(2618682,'1','202','1036',477,'Retail Sale Id 5353',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 09:24:41','',''),(2618683,'1','202','1036',477,'Retail Sale Id 5354',796.80,0.00,0.00,1.20,98.40,'2022-04-23 09:27:41','',''),(2618684,'1','202','1036',477,'Retail Sale Id 5355',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 09:30:12','',''),(2618685,'1','202','1036',477,'Retail Sale Id 5356',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 09:34:43','',''),(2618686,'1','202','1036',477,'Retail Sale Id 5358',1799.44,0.00,0.00,2.71,222.22,'2022-04-23 09:35:26','',''),(2618687,'1','202','1036',477,'Retail Sale Id 5359',56810.00,0.00,0.00,95.00,1520.00,'2022-04-23 09:36:44','',''),(2618688,'1','202','1036',477,'Retail Sale Id 5360',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 09:39:36','',''),(2618689,'1','202','1036',477,'Retail Sale Id 5363',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 09:40:12','',''),(2618690,'1','202','1036',477,'Retail Sale Id 5365',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 09:40:47','',''),(2618691,'1','202','1036',477,'Retail Sale Id 5367',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 09:46:31','',''),(2618692,'1','202','1036',477,'Retail Sale Id 5368',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 09:48:13','',''),(2618693,'1','202','1036',477,'Retail Sale Id 5369',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 09:53:49','',''),(2618694,'1','202','1036',477,'Retail Sale Id 5371',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 09:58:28','',''),(2618695,'1','202','1036',477,'Retail Sale Id 5372',35880.00,0.00,0.00,60.00,960.00,'2022-04-23 10:02:59','',''),(2618696,'1','202','1036',477,'Retail Sale Id 5374',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 10:05:08','',''),(2618697,'1','202','1036',477,'Retail Sale Id 5375',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 10:11:07','',''),(2618698,'1','202','1036',477,'Retail Sale Id 5376',1328.00,0.00,0.00,2.00,164.00,'2022-04-23 10:18:35','',''),(2618699,'1','202','1036',477,'Retail Sale Id 5378',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 10:29:48','',''),(2618700,'1','202','1036',477,'Retail Sale Id 5379',56810.00,0.00,0.00,95.00,1520.00,'2022-04-23 10:37:29','',''),(2618701,'1','202','1036',477,'Retail Sale Id 5380',1201.84,0.00,0.00,1.81,148.42,'2022-04-23 10:39:04','',''),(2618702,'1','202','1036',477,'Retail Sale Id 5380',1201.84,0.00,0.00,1.81,148.42,'2022-04-23 10:39:04','',''),(2618703,'1','202','1036',477,'Retail Sale Id 5381',1799.44,0.00,0.00,2.71,222.22,'2022-04-23 10:40:30','',''),(2618704,'1','202','1036',477,'Retail Sale Id 5382',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 10:41:31','',''),(2618705,'1','202','1036',477,'Retail Sale Id 5384',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 10:46:30','',''),(2618706,'1','202','1036',477,'Retail Sale Id 5386',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 10:50:27','',''),(2618707,'1','202','1036',477,'Retail Sale Id 5387',37076.00,0.00,0.00,62.00,992.00,'2022-04-23 10:54:03','',''),(2618708,'1','202','1036',477,'Retail Sale Id 5388',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 11:01:46','',''),(2618709,'1','202','1036',477,'Retail Sale Id 5388',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 11:01:46','',''),(2618710,'1','202','1036',477,'Retail Sale Id 5389',32890.00,0.00,0.00,55.00,880.00,'2022-04-23 11:06:38','',''),(2618711,'1','202','1036',477,'Retail Sale Id 5391',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 11:09:16','',''),(2618712,'1','202','1036',477,'Retail Sale Id 5392',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 11:10:39','',''),(2618713,'1','202','1036',477,'Retail Sale Id 5394',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 11:11:43','',''),(2618714,'1','202','1036',477,'Retail Sale Id 5395',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 11:12:49','',''),(2618715,'1','202','1036',477,'Retail Sale Id 5397',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 11:19:54','',''),(2618716,'1','202','1036',477,'Retail Sale Id 5399',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 11:21:01','',''),(2618717,'1','202','1036',477,'Retail Sale Id 5401',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 11:28:01','',''),(2618718,'1','202','1036',477,'Retail Sale Id 5402',6002.56,0.00,0.00,9.04,741.28,'2022-04-23 11:39:21','',''),(2618719,'1','202','1036',477,'Retail Sale Id 5403',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 11:42:56','',''),(2618720,'1','202','1036',477,'Retail Sale Id 5405',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 11:44:13','',''),(2618721,'1','202','1036',477,'Retail Sale Id 5407',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 11:48:42','',''),(2618722,'1','202','1036',477,'Retail Sale Id 5408',2702.48,0.00,0.00,4.07,333.74,'2022-04-23 11:49:26','',''),(2618723,'1','202','1036',477,'Retail Sale Id 5409',3001.28,0.00,0.00,4.52,370.64,'2022-04-23 11:51:37','',''),(2618724,'1','202','1036',477,'Retail Sale Id 5411',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 11:53:17','',''),(2618725,'1','202','1036',477,'Retail Sale Id 5413',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 11:56:29','',''),(2618726,'1','202','1036',477,'Retail Sale Id 5415',8001.20,0.00,0.00,12.05,988.10,'2022-04-23 11:59:07','',''),(2618727,'1','202','1036',477,'Retail Sale Id 5416',1699.84,0.00,0.00,2.56,209.92,'2022-04-23 12:05:31','',''),(2618728,'1','202','1036',477,'Retail Sale Id 5418',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 12:06:11','',''),(2618729,'1','202','1036',477,'Retail Sale Id 5419',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 12:08:27','',''),(2618730,'1','202','1036',477,'Retail Sale Id 5421',2702.48,0.00,0.00,4.07,333.74,'2022-04-23 12:10:23','',''),(2618731,'1','202','1036',477,'Retail Sale Id 5423',1201.84,0.00,0.00,1.81,148.42,'2022-04-23 12:11:30','',''),(2618732,'1','202','1036',477,'Retail Sale Id 5424',35880.00,0.00,0.00,60.00,960.00,'2022-04-23 12:22:20','',''),(2618733,'1','202','1036',477,'Retail Sale Id 5425',1347.92,0.00,0.00,2.03,166.46,'2022-04-23 12:23:31','',''),(2618734,'1','202','1036',477,'Retail Sale Id 5426',35880.00,0.00,0.00,60.00,960.00,'2022-04-23 12:30:31','',''),(2618735,'1','202','1036',477,'Retail Sale Id 5428',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 12:31:59','',''),(2618736,'1','202','1036',477,'Retail Sale Id 5429',3499.28,0.00,0.00,5.27,432.14,'2022-04-23 12:33:31','',''),(2618737,'1','202','1036',477,'Retail Sale Id 5432',4999.92,0.00,0.00,7.53,617.46,'2022-04-23 12:34:45','',''),(2618738,'1','202','1036',477,'Retail Sale Id 5434',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 12:36:08','',''),(2618739,'1','202','1036',477,'Retail Sale Id 5436',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 12:46:44','',''),(2618740,'1','202','1036',477,'Retail Sale Id 5437',3001.28,0.00,0.00,4.52,370.64,'2022-04-23 12:47:22','',''),(2618741,'1','202','1036',477,'Retail Sale Id 5439',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 12:52:42','',''),(2618742,'1','202','1036',477,'Retail Sale Id 5440',2702.48,0.00,0.00,4.07,333.74,'2022-04-23 12:53:46','',''),(2618743,'1','202','1036',477,'Retail Sale Id 5442',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 12:55:15','',''),(2618744,'1','202','1036',477,'Retail Sale Id 5444',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 12:56:01','',''),(2618745,'1','202','1036',477,'Retail Sale Id 5445',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 12:57:20','',''),(2618746,'1','202','1036',477,'Retail Sale Id 5446',498.00,0.00,0.00,0.75,61.50,'2022-04-23 13:00:41','',''),(2618747,'1','202','1036',477,'Retail Sale Id 5448',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 13:01:21','',''),(2618748,'1','202','1036',477,'Retail Sale Id 5449',29900.00,0.00,0.00,50.00,800.00,'2022-04-23 13:09:50','',''),(2618749,'1','202','1036',477,'Retail Sale Id 5451',498.00,0.00,0.00,0.75,61.50,'2022-04-23 13:11:07','',''),(2618750,'1','202','1036',477,'Retail Sale Id 5452',3001.28,0.00,0.00,4.52,370.64,'2022-04-23 13:12:33','',''),(2618751,'1','202','1036',477,'Retail Sale Id 5453',35880.00,0.00,0.00,60.00,960.00,'2022-04-23 13:28:43','',''),(2618752,'1','202','1036',477,'Retail Sale Id 5454',1799.44,0.00,0.00,2.71,222.22,'2022-04-23 13:31:45','',''),(2618753,'1','202','1036',477,'Retail Sale Id 5455',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 13:44:51','',''),(2618754,'1','202','1036',477,'Retail Sale Id 5456',697.20,0.00,0.00,1.05,86.10,'2022-04-23 13:47:20','',''),(2618755,'1','202','1036',477,'Retail Sale Id 5457',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 13:49:31','',''),(2618756,'1','202','1036',477,'Retail Sale Id 5458',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 13:54:23','',''),(2618757,'1','202','1036',477,'Retail Sale Id 5459',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 14:06:27','',''),(2618758,'1','202','1036',477,'Retail Sale Id 5460',4648.00,0.00,0.00,7.00,574.00,'2022-04-23 14:08:45','',''),(2618759,'1','202','1036',477,'Retail Sale Id 5461',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 14:10:42','',''),(2618760,'1','202','1036',477,'Retail Sale Id 5462',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 14:12:39','',''),(2618761,'1','202','1036',477,'Retail Sale Id 5463',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 14:18:03','',''),(2618762,'1','202','1036',477,'Retail Sale Id 5464',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 14:22:42','',''),(2618763,'1','202','1036',477,'Retail Sale Id 5465',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 14:30:43','',''),(2618764,'1','202','1036',477,'Retail Sale Id 5466',3001.28,0.00,0.00,4.52,370.64,'2022-04-23 14:35:54','',''),(2618765,'1','202','1036',477,'Retail Sale Id 5467',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 14:36:55','',''),(2618766,'1','202','1036',477,'Retail Sale Id 5468',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 14:42:39','',''),(2618767,'1','202','1036',477,'Retail Sale Id 5469',697.20,0.00,0.00,1.05,86.10,'2022-04-23 14:44:19','',''),(2618768,'1','202','1036',477,'Retail Sale Id 5470',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 14:54:11','',''),(2618769,'1','202','1036',477,'Retail Sale Id 5471',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 14:55:26','',''),(2618770,'1','202','1036',477,'Retail Sale Id 5472',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 15:00:07','',''),(2618771,'1','202','1036',477,'Retail Sale Id 5473',4999.92,0.00,0.00,7.53,617.46,'2022-04-23 15:00:48','',''),(2618772,'1','202','1036',477,'Retail Sale Id 5474',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 15:05:12','',''),(2618773,'1','202','1036',477,'Retail Sale Id 5475',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 15:09:10','',''),(2618774,'1','202','1036',477,'Retail Sale Id 5476',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 15:11:16','',''),(2618775,'1','202','1036',477,'Retail Sale Id 5477',2702.48,0.00,0.00,4.07,333.74,'2022-04-23 15:12:20','',''),(2618776,'1','202','1036',477,'Retail Sale Id 5478',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 15:16:18','',''),(2618777,'1','202','1036',477,'Retail Sale Id 5479',7475.00,0.00,0.00,12.50,200.00,'2022-04-23 15:19:43','',''),(2618778,'1','202','1036',477,'Retail Sale Id 5480',664.00,0.00,0.00,1.00,82.00,'2022-04-23 15:21:08','',''),(2618779,'1','202','1036',477,'Return of Retail Sale Id 5480',0.00,664.00,1.00,0.00,-82.00,'2022-04-23 15:22:41','',''),(2618780,'1','202','1036',477,'Retail Sale Id 5481',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 15:23:48','',''),(2618781,'1','202','1036',477,'Retail Sale Id 5482',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 15:24:43','',''),(2618782,'1','202','1036',477,'Retail Sale Id 5483',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 15:27:33','',''),(2618783,'1','202','1036',477,'Retail Sale Id 5484',2503.28,0.00,0.00,3.77,309.14,'2022-04-23 15:31:00','',''),(2618784,'1','202','1036',477,'Retail Sale Id 5485',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 15:33:47','',''),(2618785,'1','202','1036',477,'Retail Sale Id 5486',2702.48,0.00,0.00,4.07,333.74,'2022-04-23 15:35:42','',''),(2618786,'1','202','1036',477,'Retail Sale Id 5487',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 15:36:45','',''),(2618787,'1','202','1036',477,'Retail Sale Id 5488',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 15:37:26','',''),(2618788,'1','202','1036',477,'Retail Sale Id 5489',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 15:51:05','',''),(2618789,'1','202','1036',477,'Retail Sale Id 5490',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 15:52:34','',''),(2618790,'1','202','1036',477,'Retail Sale Id 5492',796.80,0.00,0.00,1.20,98.40,'2022-04-23 16:08:20','',''),(2618791,'1','202','1036',477,'Retail Sale Id 5493',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 16:11:17','',''),(2618792,'1','202','1036',477,'Retail Sale Id 5494',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 16:12:06','',''),(2618793,'1','202','1036',477,'Retail Sale Id 5495',3001.28,0.00,0.00,4.52,370.64,'2022-04-23 16:19:30','',''),(2618794,'1','202','1036',477,'Retail Sale Id 5496',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 16:23:43','',''),(2618795,'1','202','1036',477,'Retail Sale Id 5497',1347.92,0.00,0.00,2.03,166.46,'2022-04-23 16:25:31','',''),(2618796,'1','202','1036',477,'Retail Sale Id 5499',3001.28,0.00,0.00,4.52,370.64,'2022-04-23 16:27:05','',''),(2618797,'1','202','1036',477,'Retail Sale Id 5500',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 16:30:29','',''),(2618798,'1','202','1036',477,'Retail Sale Id 5502',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 16:33:01','',''),(2618799,'1','202','1036',477,'Retail Sale Id 5503',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 16:34:20','',''),(2618800,'1','202','1036',477,'Retail Sale Id 5503',8300.00,0.00,0.00,12.50,1025.00,'2022-04-23 16:34:20','',''),(2618801,'1','202','1036',477,'Retail Sale Id 5504',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 16:34:53','',''),(2618802,'1','202','1036',477,'Retail Sale Id 5505',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 16:36:54','',''),(2618803,'1','202','1036',477,'Retail Sale Id 5506',1347.92,0.00,0.00,2.03,166.46,'2022-04-23 16:38:42','',''),(2618804,'1','202','1036',477,'Retail Sale Id 5507',6653.28,0.00,0.00,10.02,821.64,'2022-04-23 16:40:35','',''),(2618805,'1','202','1036',477,'Retail Sale Id 5508',4150.00,0.00,0.00,6.25,512.50,'2022-04-23 16:42:25','',''),(2618806,'1','202','1036',477,'Retail Sale Id 5509',29900.00,0.00,0.00,50.00,800.00,'2022-04-23 16:43:50','',''),(2618807,'1','202','1036',477,'Retail Sale Id 5510',3001.28,0.00,0.00,4.52,370.64,'2022-04-23 16:44:31','',''),(2618808,'1','202','1036',477,'Retail Sale Id 5511',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 16:45:48','',''),(2618809,'1','202','1036',477,'Retail Sale Id 5512',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 16:51:02','',''),(2618810,'1','202','1036',477,'Retail Sale Id 5513',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 16:51:56','',''),(2618811,'1','202','1036',477,'Retail Sale Id 5514',4501.92,0.00,0.00,6.78,555.96,'2022-04-23 16:52:54','',''),(2618812,'1','202','1036',477,'Retail Sale Id 5515',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 16:54:01','',''),(2618813,'1','202','1036',477,'Retail Sale Id 5516',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 16:58:21','',''),(2618814,'1','202','1036',477,'Retail Sale Id 5517',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 17:03:51','',''),(2618815,'1','202','1036',477,'Retail Sale Id 5518',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 17:07:52','',''),(2618816,'1','202','1036',477,'Retail Sale Id 5519',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 17:08:37','',''),(2618817,'1','202','1036',477,'Retail Sale Id 5520',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 17:09:13','',''),(2618818,'1','202','1036',477,'Retail Sale Id 5521',2802.08,0.00,0.00,4.22,346.04,'2022-04-23 17:10:21','',''),(2618819,'1','202','1036',477,'Retail Sale Id 5522',35880.00,0.00,0.00,60.00,960.00,'2022-04-23 17:17:19','',''),(2618820,'1','202','1036',477,'Retail Sale Id 5523',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 17:19:04','',''),(2618821,'1','202','1036',477,'Retail Sale Id 5525',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 17:21:17','',''),(2618822,'1','202','1036',477,'Retail Sale Id 5526',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 17:52:16','',''),(2618823,'1','202','1036',477,'Retail Sale Id 5527',3353.20,0.00,0.00,5.05,414.10,'2022-04-23 18:00:21','',''),(2618824,'1','202','1036',477,'Retail Sale Id 5528',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 18:01:30','',''),(2618825,'1','202','1036',477,'Retail Sale Id 5529',1500.64,0.00,0.00,2.26,185.32,'2022-04-23 18:07:03','',''),(2618826,'1','202','1036',477,'Retail Sale Id 5530',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 18:08:40','',''),(2618827,'1','202','1036',477,'Retail Sale Id 5531',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 18:09:54','',''),(2618828,'1','202','1036',477,'Retail Sale Id 5532',3997.28,0.00,0.00,6.02,493.64,'2022-04-23 18:11:00','',''),(2618829,'1','202','1036',477,'Retail Sale Id 5533',3001.28,0.00,0.00,4.52,370.64,'2022-04-23 18:12:09','',''),(2618830,'1','202','1036',477,'Retail Sale Id 5534',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 18:13:44','',''),(2618831,'1','202','1036',477,'Retail Sale Id 5535',1002.64,0.00,0.00,1.51,123.82,'2022-04-23 18:15:38','',''),(2618832,'1','202','1036',477,'Retail Sale Id 5536',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 18:37:47','',''),(2618833,'1','202','1036',477,'Retail Sale Id 5537',1998.64,0.00,0.00,3.01,246.82,'2022-04-23 18:47:04','',''),(2618834,'1','202','1036',477,'Retail Sale Id 5538',3399.68,0.00,0.00,5.12,419.84,'2022-04-23 18:47:59','',''),(2618835,'1','202','1036',477,'Retail Sale Id 5539',4150.00,0.00,0.00,6.25,512.50,'2022-04-23 18:54:51','',''),(2618836,'1','202','1036',477,'Retail Sale Id 5540',6115.44,0.00,0.00,9.21,755.22,'2022-04-23 19:43:05','',''),(2618837,'1','202','1036',477,'Retail Sale Id 5541',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 06:58:39','',''),(2618838,'1','202','1036',477,'Retail Sale Id 5542',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 07:05:26','',''),(2618839,'1','202','1036',477,'Retail Sale Id 5543',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 07:12:33','',''),(2618840,'1','202','1036',477,'Retail Sale Id 5544',498.00,0.00,0.00,0.75,61.50,'2022-04-24 07:13:30','',''),(2618841,'1','202','1036',477,'Retail Sale Id 5545',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 07:30:45','',''),(2618842,'1','202','1036',477,'Retail Sale Id 5546',200330.00,0.00,0.00,335.00,5360.00,'2022-04-24 07:36:58','',''),(2618843,'1','202','1036',477,'Retail Sale Id 5547',697.20,0.00,0.00,1.05,86.10,'2022-04-24 07:37:42','',''),(2618844,'1','202','1036',477,'Retail Sale Id 5548',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 07:39:53','',''),(2618845,'1','202','1036',477,'Retail Sale Id 5550',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 07:41:35','',''),(2618846,'1','202','1036',477,'Retail Sale Id 5551',697.20,0.00,0.00,1.05,86.10,'2022-04-24 07:48:42','',''),(2618847,'1','202','1036',477,'Retail Sale Id 5552',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 07:49:29','',''),(2618848,'1','202','1036',477,'Retail Sale Id 5553',6002.56,0.00,0.00,9.04,741.28,'2022-04-24 07:50:20','',''),(2618849,'1','202','1036',477,'Retail Sale Id 5554',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 07:54:06','',''),(2618850,'1','202','1036',477,'Retail Sale Id 5555',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 07:55:17','',''),(2618851,'1','202','1036',477,'Retail Sale Id 5556',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 07:55:45','',''),(2618852,'1','202','1036',477,'Retail Sale Id 5557',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 07:57:11','',''),(2618853,'1','202','1036',477,'Retail Sale Id 5558',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 07:58:47','',''),(2618854,'1','202','1036',477,'Retail Sale Id 5559',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 08:02:07','',''),(2618855,'1','202','1036',477,'Retail Sale Id 5560',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 08:04:12','',''),(2618856,'1','202','1036',477,'Retail Sale Id 5561',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 08:06:52','',''),(2618857,'1','202','1036',477,'Retail Sale Id 5562',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 08:07:35','',''),(2618858,'1','202','1036',477,'Retail Sale Id 5563',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 08:09:52','',''),(2618859,'1','202','1036',477,'Retail Sale Id 5564',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 08:10:26','',''),(2618860,'1','202','1036',477,'Retail Sale Id 5565',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 08:11:03','',''),(2618861,'1','202','1036',477,'Retail Sale Id 5566',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 08:11:41','',''),(2618862,'1','202','1036',477,'Retail Sale Id 5567',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 08:18:29','',''),(2618863,'1','202','1036',477,'Retail Sale Id 5568',498.00,0.00,0.00,0.75,61.50,'2022-04-24 08:19:14','',''),(2618864,'1','202','1036',477,'Retail Sale Id 5569',1401.04,0.00,0.00,2.11,173.02,'2022-04-24 08:27:51','',''),(2618865,'1','202','1036',477,'Retail Sale Id 5570',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 08:29:28','',''),(2618866,'1','202','1036',477,'Retail Sale Id 5571',1347.92,0.00,0.00,2.03,166.46,'2022-04-24 08:30:58','',''),(2618867,'1','202','1036',477,'Retail Sale Id 5572',50232.00,0.00,0.00,84.00,1344.00,'2022-04-24 08:36:51','',''),(2618868,'1','202','1036',477,'Retail Sale Id 5573',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 08:38:53','',''),(2618869,'1','202','1036',477,'Retail Sale Id 5574',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 08:39:59','',''),(2618870,'1','202','1036',477,'Retail Sale Id 5575',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 08:40:39','',''),(2618871,'1','202','1036',477,'Retail Sale Id 5576',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 08:42:25','',''),(2618872,'1','202','1036',477,'Retail Sale Id 5578',2503.28,0.00,0.00,3.77,309.14,'2022-04-24 08:45:16','',''),(2618873,'1','202','1036',477,'Retail Sale Id 5579',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 08:45:53','',''),(2618874,'1','202','1036',477,'Retail Sale Id 5580',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 08:46:23','',''),(2618875,'1','202','1036',477,'Retail Sale Id 5581',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 08:47:07','',''),(2618876,'1','202','1036',477,'Retail Sale Id 5582',697.20,0.00,0.00,1.05,86.10,'2022-04-24 08:53:09','',''),(2618877,'1','202','1036',477,'Retail Sale Id 5583',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 09:00:05','',''),(2618878,'1','202','1036',477,'Retail Sale Id 5584',697.20,0.00,0.00,1.05,86.10,'2022-04-24 09:05:44','',''),(2618879,'1','202','1036',477,'Retail Sale Id 5585',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 09:06:34','',''),(2618880,'1','202','1036',477,'Retail Sale Id 5586',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 09:07:37','',''),(2618881,'1','202','1036',477,'Retail Sale Id 5587',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 09:12:27','',''),(2618882,'1','202','1036',477,'Retail Sale Id 5588',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 09:14:14','',''),(2618883,'1','202','1036',477,'Retail Sale Id 5589',1347.92,0.00,0.00,2.03,166.46,'2022-04-24 09:15:31','',''),(2618884,'1','202','1036',477,'Retail Sale Id 5590',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 09:19:54','',''),(2618885,'1','202','1036',477,'Retail Sale Id 5591',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 09:20:33','',''),(2618886,'1','202','1036',477,'Retail Sale Id 5592',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 09:21:15','',''),(2618887,'1','202','1036',477,'Retail Sale Id 5593',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 09:21:58','',''),(2618888,'1','202','1036',477,'Retail Sale Id 5594',3001.28,0.00,0.00,4.52,370.64,'2022-04-24 09:22:35','',''),(2618889,'1','202','1036',477,'Retail Sale Id 5595',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 09:23:44','',''),(2618890,'1','202','1036',477,'Retail Sale Id 5596',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 09:24:41','',''),(2618891,'1','202','1036',477,'Retail Sale Id 5597',697.20,0.00,0.00,1.05,86.10,'2022-04-24 09:28:38','',''),(2618892,'1','202','1036',477,'Retail Sale Id 5598',6653.28,0.00,0.00,10.02,821.64,'2022-04-24 09:29:26','',''),(2618893,'1','202','1036',477,'Retail Sale Id 5599',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 09:41:04','',''),(2618894,'1','202','1036',477,'Retail Sale Id 5600',697.20,0.00,0.00,1.05,86.10,'2022-04-24 09:42:28','',''),(2618895,'1','202','1036',477,'Retail Sale Id 5601',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 09:43:23','',''),(2618896,'1','202','1036',477,'Retail Sale Id 5602',1347.92,0.00,0.00,2.03,166.46,'2022-04-24 09:44:11','',''),(2618897,'1','202','1036',477,'Retail Sale Id 5603',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 09:45:02','',''),(2618898,'1','202','1036',477,'Retail Sale Id 5604',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 09:45:55','',''),(2618899,'1','202','1036',477,'Retail Sale Id 5605',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 09:50:52','',''),(2618900,'1','202','1036',477,'Retail Sale Id 5606',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 09:52:08','',''),(2618901,'1','202','1036',477,'Retail Sale Id 5607',3001.28,0.00,0.00,4.52,370.64,'2022-04-24 09:52:44','',''),(2618902,'1','202','1036',477,'Retail Sale Id 5608',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 09:54:46','',''),(2618903,'1','202','1036',477,'Retail Sale Id 5609',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 09:55:41','',''),(2618904,'1','202','1036',477,'Retail Sale Id 5610',4999.92,0.00,0.00,7.53,617.46,'2022-04-24 09:56:41','',''),(2618905,'1','202','1036',477,'Retail Sale Id 5611',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 09:58:33','',''),(2618906,'1','202','1036',477,'Retail Sale Id 5612',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 09:59:12','',''),(2618907,'1','202','1036',477,'Retail Sale Id 5613',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 10:02:45','',''),(2618908,'1','202','1036',477,'Retail Sale Id 5614',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 10:06:46','',''),(2618909,'1','202','1036',477,'Retail Sale Id 5615',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 10:09:49','',''),(2618910,'1','202','1036',477,'Retail Sale Id 5616',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 10:15:08','',''),(2618911,'1','202','1036',477,'Retail Sale Id 5617',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 10:16:23','',''),(2618912,'1','202','1036',477,'Retail Sale Id 5618',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 10:17:07','',''),(2618913,'1','202','1036',477,'Retail Sale Id 5619',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 10:23:54','',''),(2618914,'1','202','1036',477,'Retail Sale Id 5620',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 10:27:05','',''),(2618915,'1','202','1036',477,'Retail Sale Id 5621',3001.28,0.00,0.00,4.52,370.64,'2022-04-24 10:27:57','',''),(2618916,'1','202','1036',477,'Retail Sale Id 5622',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 10:28:41','',''),(2618917,'1','202','1036',477,'Retail Sale Id 5623',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 10:32:43','',''),(2618918,'1','202','1036',477,'Retail Sale Id 5624',32890.00,0.00,0.00,55.00,880.00,'2022-04-24 10:36:44','',''),(2618919,'1','202','1036',477,'Retail Sale Id 5625',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 10:39:13','',''),(2618920,'1','202','1036',477,'Retail Sale Id 5626',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 10:40:30','',''),(2618921,'1','202','1036',477,'Retail Sale Id 5627',3001.28,0.00,0.00,4.52,370.64,'2022-04-24 10:45:07','',''),(2618922,'1','202','1036',477,'Retail Sale Id 5628',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 10:46:06','',''),(2618923,'1','202','1036',477,'Retail Sale Id 5629',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 10:47:56','',''),(2618924,'1','202','1036',477,'Retail Sale Id 5630',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 10:49:14','',''),(2618925,'1','202','1036',477,'Retail Sale Id 5631',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 10:49:59','',''),(2618926,'1','202','1036',477,'Retail Sale Id 5632',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 10:51:33','',''),(2618927,'1','202','1036',477,'Retail Sale Id 5633',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 10:52:36','',''),(2618928,'1','202','1036',477,'Retail Sale Id 5634',697.20,0.00,0.00,1.05,86.10,'2022-04-24 10:54:07','',''),(2618929,'1','202','1036',477,'Retail Sale Id 5635',1347.92,0.00,0.00,2.03,166.46,'2022-04-24 10:56:37','',''),(2618930,'1','202','1036',477,'Retail Sale Id 5636',2397.04,0.00,0.00,3.61,296.02,'2022-04-24 10:57:40','',''),(2618931,'1','202','1036',477,'Retail Sale Id 5637',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 10:58:58','',''),(2618932,'1','202','1036',477,'Retail Sale Id 5638',903.04,0.00,0.00,1.36,111.52,'2022-04-24 11:04:34','',''),(2618933,'1','202','1036',477,'Retail Sale Id 5639',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 11:06:15','',''),(2618934,'1','202','1036',477,'Retail Sale Id 5640',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 11:08:42','',''),(2618935,'1','202','1036',477,'Retail Sale Id 5641',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 11:15:00','',''),(2618936,'1','202','1036',477,'Retail Sale Id 5642',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 11:15:49','',''),(2618937,'1','202','1036',477,'Retail Sale Id 5643',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 11:16:43','',''),(2618938,'1','202','1036',477,'Retail Sale Id 5644',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 11:19:03','',''),(2618939,'1','202','1036',477,'Retail Sale Id 5645',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 11:23:41','',''),(2618940,'1','202','1036',477,'Retail Sale Id 5646',2098.24,0.00,0.00,3.16,259.12,'2022-04-24 11:27:24','',''),(2618941,'1','202','1036',477,'Retail Sale Id 5647',3001.28,0.00,0.00,4.52,370.64,'2022-04-24 11:29:32','',''),(2618942,'1','202','1036',477,'Retail Sale Id 5648',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 11:33:12','',''),(2618943,'1','202','1036',477,'Retail Sale Id 5649',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 11:37:09','',''),(2618944,'1','202','1036',477,'Retail Sale Id 5650',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 11:38:30','',''),(2618945,'1','202','1036',477,'Retail Sale Id 5651',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 11:41:17','',''),(2618946,'1','202','1036',477,'Retail Sale Id 5652',6998.56,0.00,0.00,10.54,864.28,'2022-04-24 11:44:29','',''),(2618947,'1','202','1036',477,'Retail Sale Id 5653',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 11:54:16','',''),(2618948,'1','202','1036',477,'Retail Sale Id 5653',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 11:54:16','',''),(2618949,'1','202','1036',477,'Retail Sale Id 5654',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 11:56:40','',''),(2618950,'1','202','1036',477,'Retail Sale Id 5655',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 11:57:41','',''),(2618951,'1','202','1036',477,'Retail Sale Id 5656',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 11:58:31','',''),(2618952,'1','202','1036',477,'Retail Sale Id 5657',2197.84,0.00,0.00,3.31,271.42,'2022-04-24 12:06:01','',''),(2618953,'1','202','1036',477,'Retail Sale Id 5658',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 12:06:54','',''),(2618954,'1','202','1036',477,'Retail Sale Id 5659',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 12:08:09','',''),(2618955,'1','202','1036',477,'Retail Sale Id 5659',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 12:08:09','',''),(2618956,'1','202','1036',477,'Retail Sale Id 5660',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 12:09:39','',''),(2618957,'1','202','1036',477,'Retail Sale Id 5662',3001.28,0.00,0.00,4.52,370.64,'2022-04-24 12:12:45','',''),(2618958,'1','202','1036',477,'Retail Sale Id 5663',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 12:13:40','',''),(2618959,'1','202','1036',477,'Retail Sale Id 5664',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 12:14:11','',''),(2618960,'1','202','1036',477,'Retail Sale Id 5665',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 12:14:57','',''),(2618961,'1','202','1036',477,'Retail Sale Id 5666',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 12:15:45','',''),(2618962,'1','202','1036',477,'Retail Sale Id 5668',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 12:22:06','',''),(2618963,'1','202','1036',477,'Retail Sale Id 5669',3499.28,0.00,0.00,5.27,432.14,'2022-04-24 12:24:00','',''),(2618964,'1','202','1036',477,'Retail Sale Id 5670',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 12:25:28','',''),(2618965,'1','202','1036',477,'Retail Sale Id 5671',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 12:30:17','',''),(2618966,'1','202','1036',477,'Retail Sale Id 5672',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 12:42:40','',''),(2618967,'1','202','1036',477,'Retail Sale Id 5673',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 12:44:07','',''),(2618968,'1','202','1036',477,'Retail Sale Id 5674',3499.28,0.00,0.00,5.27,432.14,'2022-04-24 12:48:28','',''),(2618969,'1','202','1036',477,'Retail Sale Id 5675',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 12:50:04','',''),(2618970,'1','202','1036',477,'Retail Sale Id 5676',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 13:02:31','',''),(2618971,'1','202','1036',477,'Retail Sale Id 5677',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 13:03:10','',''),(2618972,'1','202','1036',477,'Retail Sale Id 5678',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 13:05:22','',''),(2618973,'1','202','1036',477,'Retail Sale Id 5679',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 13:05:56','',''),(2618974,'1','202','1036',477,'Retail Sale Id 5680',14651.00,0.00,0.00,24.50,392.00,'2022-04-24 13:06:58','',''),(2618975,'1','202','1036',477,'Retail Sale Id 5681',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 13:09:50','',''),(2618976,'1','202','1036',477,'Retail Sale Id 5682',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 13:10:56','',''),(2618977,'1','202','1036',477,'Retail Sale Id 5683',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 13:11:58','',''),(2618978,'1','202','1036',477,'Retail Sale Id 5684',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 13:14:14','',''),(2618979,'1','202','1036',477,'Retail Sale Id 5685',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 13:16:23','',''),(2618980,'1','202','1036',477,'Retail Sale Id 5686',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 13:17:37','',''),(2618981,'1','202','1036',477,'Retail Sale Id 5687',2503.28,0.00,0.00,3.77,309.14,'2022-04-24 13:18:30','',''),(2618982,'1','202','1036',477,'Retail Sale Id 5688',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 13:20:26','',''),(2618983,'1','202','1036',477,'Retail Sale Id 5688',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 13:20:26','',''),(2618984,'1','202','1036',477,'Retail Sale Id 5689',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 13:24:56','',''),(2618985,'1','202','1036',477,'Retail Sale Id 5690',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 13:26:11','',''),(2618986,'1','202','1036',477,'Retail Sale Id 5691',697.20,0.00,0.00,1.05,86.10,'2022-04-24 13:27:03','',''),(2618987,'1','202','1036',477,'Retail Sale Id 5692',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 13:28:08','',''),(2618988,'1','202','1036',477,'Retail Sale Id 5693',2197.84,0.00,0.00,3.31,271.42,'2022-04-24 13:29:01','',''),(2618989,'1','202','1036',477,'Retail Sale Id 5694',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 13:29:44','',''),(2618990,'1','202','1036',477,'Retail Sale Id 5696',3001.28,0.00,0.00,4.52,370.64,'2022-04-24 13:31:50','',''),(2618991,'1','202','1036',477,'Retail Sale Id 5698',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 13:34:21','',''),(2618992,'1','202','1036',477,'Retail Sale Id 5699',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 13:40:05','',''),(2618993,'1','202','1036',477,'Retail Sale Id 5701',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 13:41:14','',''),(2618994,'1','202','1036',477,'Retail Sale Id 5702',41860.00,0.00,0.00,70.00,1120.00,'2022-04-24 13:45:44','',''),(2618995,'1','202','1036',477,'Retail Sale Id 5703',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 13:54:43','',''),(2618996,'1','202','1036',477,'Retail Sale Id 5704',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 13:56:59','',''),(2618997,'1','202','1036',477,'Retail Sale Id 5705',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 13:57:52','',''),(2618998,'1','202','1036',477,'Retail Sale Id 5706',3499.28,0.00,0.00,5.27,432.14,'2022-04-24 13:58:54','',''),(2618999,'1','202','1036',477,'Retail Sale Id 5707',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 13:59:56','',''),(2619000,'1','202','1036',477,'Retail Sale Id 5708',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 14:01:48','',''),(2619001,'1','202','1036',477,'Retail Sale Id 5710',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 14:02:35','',''),(2619002,'1','202','1036',477,'Retail Sale Id 5711',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 14:04:05','',''),(2619003,'1','202','1036',477,'Retail Sale Id 5713',3001.28,0.00,0.00,4.52,370.64,'2022-04-24 14:04:46','',''),(2619004,'1','202','1036',477,'Retail Sale Id 5714',1201.84,0.00,0.00,1.81,148.42,'2022-04-24 14:06:50','',''),(2619005,'1','202','1036',477,'Retail Sale Id 5715',32890.00,0.00,0.00,55.00,880.00,'2022-04-24 14:11:10','',''),(2619006,'1','202','1036',477,'Retail Sale Id 5716',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 14:12:39','',''),(2619007,'1','202','1036',477,'Retail Sale Id 5718',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 14:14:05','',''),(2619008,'1','202','1036',477,'Retail Sale Id 5720',3001.28,0.00,0.00,4.52,370.64,'2022-04-24 14:15:07','',''),(2619009,'1','202','1036',477,'Retail Sale Id 5721',498.00,0.00,0.00,0.75,61.50,'2022-04-24 14:24:20','',''),(2619010,'1','202','1036',477,'Retail Sale Id 5722',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 14:37:51','',''),(2619011,'1','202','1036',477,'Retail Sale Id 5723',2503.28,0.00,0.00,3.77,309.14,'2022-04-24 14:39:19','',''),(2619012,'1','202','1036',477,'Retail Sale Id 5725',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 14:40:52','',''),(2619013,'1','202','1036',477,'Retail Sale Id 5726',650.72,0.00,0.00,0.98,80.36,'2022-04-24 14:48:37','',''),(2619014,'1','202','1036',477,'Retail Sale Id 5727',1347.92,0.00,0.00,2.03,166.46,'2022-04-24 14:50:05','',''),(2619015,'1','202','1036',477,'Retail Sale Id 5730',3499.28,0.00,0.00,5.27,432.14,'2022-04-24 14:51:41','',''),(2619016,'1','202','1036',477,'Retail Sale Id 5732',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 14:54:55','',''),(2619017,'1','202','1036',477,'Retail Sale Id 5733',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 15:06:05','',''),(2619018,'1','202','1036',477,'Retail Sale Id 5734',903.04,0.00,0.00,1.36,111.52,'2022-04-24 15:07:53','',''),(2619019,'1','202','1036',477,'Retail Sale Id 5735',6002.56,0.00,0.00,9.04,741.28,'2022-04-24 15:09:54','',''),(2619020,'1','202','1036',477,'Retail Sale Id 5736',697.20,0.00,0.00,1.05,86.10,'2022-04-24 15:14:36','',''),(2619021,'1','202','1036',477,'Retail Sale Id 5737',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 15:19:51','',''),(2619022,'1','202','1036',477,'Retail Sale Id 5738',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 15:20:30','',''),(2619023,'1','202','1036',477,'Retail Sale Id 5739',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 15:23:14','',''),(2619024,'1','202','1036',477,'Retail Sale Id 5740',8001.20,0.00,0.00,12.05,988.10,'2022-04-24 15:26:01','',''),(2619025,'1','202','1036',477,'Retail Sale Id 5741',50232.00,0.00,0.00,84.00,1344.00,'2022-04-24 15:28:56','',''),(2619026,'1','202','1036',477,'Retail Sale Id 5742',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 15:30:30','',''),(2619027,'1','202','1036',477,'Retail Sale Id 5743',3001.28,0.00,0.00,4.52,370.64,'2022-04-24 15:34:00','',''),(2619028,'1','202','1036',477,'Retail Sale Id 5744',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 15:39:01','',''),(2619029,'1','202','1036',477,'Retail Sale Id 5745',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 15:41:06','',''),(2619030,'1','202','1036',477,'Retail Sale Id 5746',2702.48,0.00,0.00,4.07,333.74,'2022-04-24 15:43:33','',''),(2619031,'1','202','1036',477,'Retail Sale Id 5747',4501.92,0.00,0.00,6.78,555.96,'2022-04-24 15:45:45','',''),(2619032,'1','202','1036',477,'Retail Sale Id 5748',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 15:48:12','',''),(2619033,'1','202','1036',477,'Retail Sale Id 5749',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 15:58:53','',''),(2619034,'1','202','1036',477,'Retail Sale Id 5750',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 16:00:26','',''),(2619035,'1','202','1036',477,'Retail Sale Id 5750',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 16:00:26','',''),(2619036,'1','202','1036',477,'Retail Sale Id 5751',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 16:10:37','',''),(2619037,'1','202','1036',477,'Retail Sale Id 5753',1799.44,0.00,0.00,2.71,222.22,'2022-04-24 16:12:32','',''),(2619038,'1','202','1036',477,'Retail Sale Id 5754',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 16:13:35','',''),(2619039,'1','202','1036',477,'Retail Sale Id 5755',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 16:15:33','',''),(2619040,'1','202','1036',477,'Retail Sale Id 5756',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 16:19:27','',''),(2619041,'1','202','1036',477,'Retail Sale Id 5757',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 16:20:13','',''),(2619042,'1','202','1036',477,'Retail Sale Id 5758',14950.00,0.00,0.00,25.00,400.00,'2022-04-24 16:25:41','',''),(2619043,'1','202','1036',477,'Retail Sale Id 5760',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 16:26:25','',''),(2619044,'1','202','1036',477,'Retail Sale Id 5762',1201.84,0.00,0.00,1.81,148.42,'2022-04-24 16:27:50','',''),(2619045,'1','202','1036',477,'Retail Sale Id 5763',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 16:43:43','',''),(2619046,'1','202','1036',477,'Retail Sale Id 5764',2503.28,0.00,0.00,3.77,309.14,'2022-04-24 16:50:19','',''),(2619047,'1','202','1036',477,'Retail Sale Id 5765',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 16:52:14','',''),(2619048,'1','202','1036',477,'Retail Sale Id 5766',1347.92,0.00,0.00,2.03,166.46,'2022-04-24 16:55:30','',''),(2619049,'1','202','1036',477,'Retail Sale Id 5769',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 16:58:38','',''),(2619050,'1','202','1036',477,'Retail Sale Id 5770',697.20,0.00,0.00,1.05,86.10,'2022-04-24 17:06:15','',''),(2619051,'1','202','1036',477,'Retail Sale Id 5771',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 17:10:17','',''),(2619052,'1','202','1036',477,'Retail Sale Id 5773',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 17:18:06','',''),(2619053,'1','202','1036',477,'Retail Sale Id 5775',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 17:19:01','',''),(2619054,'1','202','1036',477,'Retail Sale Id 5776',7503.20,0.00,0.00,11.30,926.60,'2022-04-24 17:20:25','',''),(2619055,'1','202','1036',477,'Retail Sale Id 5777',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 17:22:45','',''),(2619056,'1','202','1036',477,'Retail Sale Id 5779',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 17:23:24','',''),(2619057,'1','202','1036',477,'Retail Sale Id 5781',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 17:24:24','',''),(2619058,'1','202','1036',477,'Retail Sale Id 5783',2702.48,0.00,0.00,4.07,333.74,'2022-04-24 17:25:00','',''),(2619059,'1','202','1036',477,'Retail Sale Id 5784',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 17:27:17','',''),(2619060,'1','202','1036',477,'Retail Sale Id 5784',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 17:27:17','',''),(2619061,'1','202','1036',477,'Retail Sale Id 5785',650.72,0.00,0.00,0.98,80.36,'2022-04-24 17:30:16','',''),(2619062,'1','202','1036',477,'Retail Sale Id 5788',1899.04,0.00,0.00,2.86,234.52,'2022-04-24 17:34:16','',''),(2619063,'1','202','1036',477,'Retail Sale Id 5788',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 17:34:16','',''),(2619064,'1','202','1036',477,'Retail Sale Id 5789',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 17:39:53','',''),(2619065,'1','202','1036',477,'Retail Sale Id 5790',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 17:40:53','',''),(2619066,'1','202','1036',477,'Retail Sale Id 5791',3353.20,0.00,0.00,5.05,414.10,'2022-04-24 17:43:38','',''),(2619067,'1','202','1036',477,'Retail Sale Id 5792',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 17:46:08','',''),(2619068,'1','202','1036',477,'Retail Sale Id 5793',1401.04,0.00,0.00,2.11,173.02,'2022-04-24 17:48:29','',''),(2619069,'1','202','1036',477,'Retail Sale Id 5794',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 17:50:09','',''),(2619070,'1','202','1036',477,'Retail Sale Id 5795',597.60,0.00,0.00,0.90,73.80,'2022-04-24 17:51:42','',''),(2619071,'1','202','1036',477,'Retail Sale Id 5796',1002.64,0.00,0.00,1.51,123.82,'2022-04-24 17:52:33','',''),(2619072,'1','202','1036',477,'Retail Sale Id 5798',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 17:53:16','',''),(2619073,'1','202','1036',477,'Retail Sale Id 5800',1799.44,0.00,0.00,2.71,222.22,'2022-04-24 17:55:46','',''),(2619074,'1','202','1036',477,'Retail Sale Id 5801',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 18:03:40','',''),(2619075,'1','202','1036',477,'Retail Sale Id 5802',1998.64,0.00,0.00,3.01,246.82,'2022-04-24 18:04:55','',''),(2619076,'1','202','1036',477,'Retail Sale Id 5803',750.32,0.00,0.00,1.13,92.66,'2022-04-24 18:19:50','',''),(2619077,'1','202','1036',477,'Retail Sale Id 5804',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 18:25:02','',''),(2619078,'1','202','1036',477,'Retail Sale Id 5805',3997.28,0.00,0.00,6.02,493.64,'2022-04-24 18:34:21','',''),(2619079,'1','202','1036',477,'Retail Sale Id 5806',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 19:00:44','',''),(2619080,'1','202','1036',477,'Retail Sale Id 5807',1500.64,0.00,0.00,2.26,185.32,'2022-04-24 19:01:26','',''),(2619081,'1','202','1036',477,'Retail Sale Id 5808',8300.00,0.00,0.00,12.50,1025.00,'2022-04-24 19:02:04','',''),(2619082,'1','202','1036',477,'Retail Sale Id 5809',697.20,0.00,0.00,1.05,86.10,'2022-04-24 19:03:05','',''),(2619083,'1','202','1036',477,'Retail Sale Id 5810',398.40,0.00,0.00,0.60,49.20,'2022-04-24 19:22:01','',''),(2619084,'1','202','1036',477,'Retail Sale Id 5811',1201.84,0.00,0.00,1.81,148.42,'2022-04-25 06:58:16','',''),(2619085,'1','202','1036',477,'Retail Sale Id 5812',1500.64,0.00,0.00,2.26,185.32,'2022-04-25 07:08:29','',''),(2619086,'1','202','1036',477,'Retail Sale Id 5813',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 07:17:56','',''),(2619087,'1','202','1036',477,'Retail Sale Id 5814',35880.00,0.00,0.00,60.00,960.00,'2022-04-25 07:24:15','',''),(2619088,'1','202','1036',477,'Retail Sale Id 5815',1347.92,0.00,0.00,2.03,166.46,'2022-04-25 07:37:34','',''),(2619089,'1','202','1036',477,'Retail Sale Id 5816',3353.20,0.00,0.00,5.05,414.10,'2022-04-25 07:41:11','',''),(2619090,'1','202','1036',477,'Retail Sale Id 5817',7350.48,0.00,0.00,11.07,907.74,'2022-04-25 07:54:45','',''),(2619091,'1','202','1036',477,'Retail Sale Id 5819',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 08:00:19','',''),(2619092,'1','202','1036',477,'Retail Sale Id 5821',498.00,0.00,0.00,0.75,61.50,'2022-04-25 08:00:57','',''),(2619093,'1','202','1036',477,'Retail Sale Id 5822',3353.20,0.00,0.00,5.05,414.10,'2022-04-25 08:04:07','',''),(2619094,'1','202','1036',477,'Retail Sale Id 5824',7503.20,0.00,0.00,11.30,926.60,'2022-04-25 08:04:52','',''),(2619095,'1','202','1036',477,'Retail Sale Id 5826',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 08:07:50','',''),(2619096,'1','202','1036',477,'Retail Sale Id 5827',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 08:08:36','',''),(2619097,'1','202','1036',477,'Retail Sale Id 5830',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 08:09:10','',''),(2619098,'1','202','1036',477,'Retail Sale Id 5832',1500.64,0.00,0.00,2.26,185.32,'2022-04-25 08:11:33','',''),(2619099,'1','202','1036',477,'Retail Sale Id 5833',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 08:17:27','',''),(2619100,'1','202','1036',477,'Retail Sale Id 5835',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 08:18:12','',''),(2619101,'1','202','1036',477,'Retail Sale Id 5836',7197.76,0.00,0.00,10.84,888.88,'2022-04-25 08:35:38','',''),(2619102,'1','202','1036',477,'Retail Sale Id 5838',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 08:36:42','',''),(2619103,'1','202','1036',477,'Retail Sale Id 5839',697.20,0.00,0.00,1.05,86.10,'2022-04-25 08:41:23','',''),(2619104,'1','202','1036',477,'Retail Sale Id 5840',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 08:49:11','',''),(2619105,'1','202','1036',477,'Retail Sale Id 5842',2802.08,0.00,0.00,4.22,346.04,'2022-04-25 08:53:03','',''),(2619106,'1','202','1036',477,'Retail Sale Id 5843',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 08:55:22','',''),(2619107,'1','202','1036',477,'Retail Sale Id 5844',8300.00,0.00,0.00,12.50,1025.00,'2022-04-25 09:20:04','',''),(2619108,'1','202','1036',477,'Retail Sale Id 5845',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 09:27:39','',''),(2619109,'1','202','1036',477,'Retail Sale Id 5847',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 09:28:16','',''),(2619110,'1','202','1036',477,'Retail Sale Id 5849',17940.00,0.00,0.00,30.00,480.00,'2022-04-25 09:34:28','',''),(2619111,'1','202','1036',477,'Retail Sale Id 5850',3353.20,0.00,0.00,5.05,414.10,'2022-04-25 09:43:27','',''),(2619112,'1','202','1036',477,'Retail Sale Id 5851',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 09:45:13','',''),(2619113,'1','202','1036',477,'Retail Sale Id 5852',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 09:47:18','',''),(2619114,'1','202','1036',477,'Retail Sale Id 5853',32890.00,0.00,0.00,55.00,880.00,'2022-04-25 09:49:46','',''),(2619115,'1','202','1036',477,'Retail Sale Id 5854',903.04,0.00,0.00,1.36,111.52,'2022-04-25 09:59:13','',''),(2619116,'1','202','1036',477,'Retail Sale Id 5855',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 10:01:40','',''),(2619117,'1','202','1036',477,'Retail Sale Id 5856',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 10:10:50','',''),(2619118,'1','202','1036',477,'Retail Sale Id 5857',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 10:12:59','',''),(2619119,'1','202','1036',477,'Retail Sale Id 5858',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 10:14:56','',''),(2619120,'1','202','1036',477,'Retail Sale Id 5859',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 10:15:42','',''),(2619121,'1','202','1036',477,'Retail Sale Id 5861',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 10:16:23','',''),(2619122,'1','202','1036',477,'Retail Sale Id 5862',8300.00,0.00,0.00,12.50,1025.00,'2022-04-25 10:18:40','',''),(2619123,'1','202','1036',477,'Retail Sale Id 5863',2702.48,0.00,0.00,4.07,333.74,'2022-04-25 10:19:54','',''),(2619124,'1','202','1036',477,'Retail Sale Id 5864',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 10:24:21','',''),(2619125,'1','202','1036',477,'Retail Sale Id 5865',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 10:30:57','',''),(2619126,'1','202','1036',477,'Retail Sale Id 5867',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 10:38:35','',''),(2619127,'1','202','1036',477,'Retail Sale Id 5868',20930.00,0.00,0.00,35.00,560.00,'2022-04-25 10:41:27','',''),(2619128,'1','202','1036',477,'Retail Sale Id 5869',597.60,0.00,0.00,0.90,73.80,'2022-04-25 10:45:26','',''),(2619129,'1','202','1036',477,'Retail Sale Id 5870',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 10:52:15','',''),(2619130,'1','202','1036',477,'Retail Sale Id 5872',1500.64,0.00,0.00,2.26,185.32,'2022-04-25 10:53:02','',''),(2619131,'1','202','1036',477,'Retail Sale Id 5873',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 10:57:28','',''),(2619132,'1','202','1036',477,'Retail Sale Id 5874',41860.00,0.00,0.00,70.00,1120.00,'2022-04-25 11:04:46','',''),(2619133,'1','202','1036',477,'Retail Sale Id 5877',8300.00,0.00,0.00,12.50,1025.00,'2022-04-25 11:10:41','',''),(2619134,'1','202','1036',477,'Retail Sale Id 5878',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 11:14:24','',''),(2619135,'1','202','1036',477,'Retail Sale Id 5879',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 11:19:21','',''),(2619136,'1','202','1036',477,'Retail Sale Id 5880',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 11:24:17','',''),(2619137,'1','202','1036',477,'Retail Sale Id 5882',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 11:25:06','',''),(2619138,'1','202','1036',477,'Retail Sale Id 5883',8300.00,0.00,0.00,12.50,1025.00,'2022-04-25 11:40:34','',''),(2619139,'1','202','1036',477,'Retail Sale Id 5884',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 12:00:03','',''),(2619140,'1','202','1036',477,'Retail Sale Id 5886',2503.28,0.00,0.00,3.77,309.14,'2022-04-25 12:00:54','',''),(2619141,'1','202','1036',477,'Retail Sale Id 5887',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 12:10:41','',''),(2619142,'1','202','1036',477,'Retail Sale Id 5888',2503.28,0.00,0.00,3.77,309.14,'2022-04-25 12:23:07','',''),(2619143,'1','202','1036',477,'Retail Sale Id 5889',2702.48,0.00,0.00,4.07,333.74,'2022-04-25 12:24:30','',''),(2619144,'1','202','1036',477,'Retail Sale Id 5891',1301.44,0.00,0.00,1.96,160.72,'2022-04-25 12:32:22','',''),(2619145,'1','202','1036',477,'Retail Sale Id 5893',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 12:36:08','',''),(2619146,'1','202','1036',477,'Retail Sale Id 5895',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 12:39:30','',''),(2619147,'1','202','1036',477,'Retail Sale Id 5896',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 12:40:13','',''),(2619148,'1','202','1036',477,'Retail Sale Id 5898',1401.04,0.00,0.00,2.11,173.02,'2022-04-25 12:46:40','',''),(2619149,'1','202','1036',477,'Retail Sale Id 5900',1401.04,0.00,0.00,2.11,173.02,'2022-04-25 12:47:46','',''),(2619150,'1','202','1036',477,'Retail Sale Id 5901',8300.00,0.00,0.00,12.50,1025.00,'2022-04-25 12:57:58','',''),(2619151,'1','202','1036',477,'Retail Sale Id 5902',3499.28,0.00,0.00,5.27,432.14,'2022-04-25 12:58:29','',''),(2619152,'1','202','1036',477,'Retail Sale Id 5903',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 13:09:22','',''),(2619153,'1','202','1036',477,'Retail Sale Id 5906',1201.84,0.00,0.00,1.81,148.42,'2022-04-25 13:12:09','',''),(2619154,'1','202','1036',477,'Retail Sale Id 5908',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 13:13:16','',''),(2619155,'1','202','1036',477,'Retail Sale Id 5909',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 13:17:57','',''),(2619156,'1','202','1036',477,'Retail Sale Id 5911',29900.00,0.00,0.00,50.00,800.00,'2022-04-25 13:32:21','',''),(2619157,'1','202','1036',477,'Retail Sale Id 5912',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 13:42:23','',''),(2619158,'1','202','1036',477,'Retail Sale Id 5913',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 13:46:14','',''),(2619159,'1','202','1036',477,'Retail Sale Id 5915',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 13:51:12','',''),(2619160,'1','202','1036',477,'Retail Sale Id 5916',1201.84,0.00,0.00,1.81,148.42,'2022-04-25 13:52:10','',''),(2619161,'1','202','1036',477,'Retail Sale Id 5918',1201.84,0.00,0.00,1.81,148.42,'2022-04-25 13:56:36','',''),(2619162,'1','202','1036',477,'Retail Sale Id 5920',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 14:02:24','',''),(2619163,'1','202','1036',477,'Retail Sale Id 5922',29900.00,0.00,0.00,50.00,800.00,'2022-04-25 14:06:15','',''),(2619164,'1','202','1036',477,'Retail Sale Id 5924',23920.00,0.00,0.00,40.00,640.00,'2022-04-25 14:15:18','',''),(2619165,'1','202','1036',477,'Retail Sale Id 5925',1500.64,0.00,0.00,2.26,185.32,'2022-04-25 14:18:47','',''),(2619166,'1','202','1036',477,'Retail Sale Id 5926',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 14:23:53','',''),(2619167,'1','202','1036',477,'Retail Sale Id 5926',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 14:23:53','',''),(2619168,'1','202','1036',477,'Retail Sale Id 5927',65780.00,0.00,0.00,110.00,1760.00,'2022-04-25 14:58:00','',''),(2619169,'1','202','1036',477,'Retail Sale Id 5928',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 14:58:48','',''),(2619170,'1','202','1036',477,'Retail Sale Id 5929',41860.00,0.00,0.00,70.00,1120.00,'2022-04-25 15:05:49','',''),(2619171,'1','202','1036',477,'Retail Sale Id 5930',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 15:13:36','',''),(2619172,'1','202','1036',477,'Retail Sale Id 5931',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 15:19:25','',''),(2619173,'1','202','1036',477,'Retail Sale Id 5932',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 15:22:02','',''),(2619174,'1','202','1036',477,'Retail Sale Id 5933',8300.00,0.00,0.00,12.50,1025.00,'2022-04-25 15:33:24','',''),(2619175,'1','202','1036',477,'Retail Sale Id 5934',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 15:34:29','',''),(2619176,'1','202','1036',477,'Retail Sale Id 5935',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 15:39:30','',''),(2619177,'1','202','1036',477,'Retail Sale Id 5936',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 15:41:27','',''),(2619178,'1','202','1036',477,'Retail Sale Id 5937',2702.48,0.00,0.00,4.07,333.74,'2022-04-25 15:47:20','',''),(2619179,'1','202','1036',477,'Retail Sale Id 5938',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 15:53:55','',''),(2619180,'1','202','1036',477,'Retail Sale Id 5939',1347.92,0.00,0.00,2.03,166.46,'2022-04-25 15:58:28','',''),(2619181,'1','202','1036',477,'Retail Sale Id 5940',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 16:01:55','',''),(2619182,'1','202','1036',477,'Retail Sale Id 5941',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 16:07:52','',''),(2619183,'1','202','1036',477,'Retail Sale Id 5942',2702.48,0.00,0.00,4.07,333.74,'2022-04-25 16:15:05','',''),(2619184,'1','202','1036',477,'Retail Sale Id 5943',1201.84,0.00,0.00,1.81,148.42,'2022-04-25 16:20:44','',''),(2619185,'1','202','1036',477,'Retail Sale Id 5944',4648.00,0.00,0.00,7.00,574.00,'2022-04-25 16:22:04','',''),(2619186,'1','202','1036',477,'Retail Sale Id 5945',697.20,0.00,0.00,1.05,86.10,'2022-04-25 16:23:33','',''),(2619187,'1','202','1036',477,'Retail Sale Id 5946',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 16:25:32','',''),(2619188,'1','202','1036',477,'Retail Sale Id 5947',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 16:30:11','',''),(2619189,'1','202','1036',477,'Retail Sale Id 5948',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 16:34:23','',''),(2619190,'1','202','1036',477,'Retail Sale Id 5949',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 16:35:47','',''),(2619191,'1','202','1036',477,'Retail Sale Id 5950',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 16:44:30','',''),(2619192,'1','202','1036',477,'Retail Sale Id 5951',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 16:50:31','',''),(2619193,'1','202','1036',477,'Retail Sale Id 5952',6998.56,0.00,0.00,10.54,864.28,'2022-04-25 16:53:15','',''),(2619194,'1','202','1036',477,'Retail Sale Id 5953',2702.48,0.00,0.00,4.07,333.74,'2022-04-25 17:00:59','',''),(2619195,'1','202','1036',477,'Retail Sale Id 5954',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 17:07:51','',''),(2619196,'1','202','1036',477,'Retail Sale Id 5955',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 17:08:36','',''),(2619197,'1','202','1036',477,'Retail Sale Id 5956',1500.64,0.00,0.00,2.26,185.32,'2022-04-25 17:10:21','',''),(2619198,'1','202','1036',477,'Retail Sale Id 5957',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 17:15:49','',''),(2619199,'1','202','1036',477,'Retail Sale Id 5958',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 17:19:42','',''),(2619200,'1','202','1036',477,'Retail Sale Id 5959',3353.20,0.00,0.00,5.05,414.10,'2022-04-25 17:22:34','',''),(2619201,'1','202','1036',477,'Retail Sale Id 5960',1500.64,0.00,0.00,2.26,185.32,'2022-04-25 17:23:15','',''),(2619202,'1','202','1036',477,'Retail Sale Id 5961',1401.04,0.00,0.00,2.11,173.02,'2022-04-25 17:23:57','',''),(2619203,'1','202','1036',477,'Retail Sale Id 5962',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 17:24:43','',''),(2619204,'1','202','1036',477,'Retail Sale Id 5963',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 17:25:40','',''),(2619205,'1','202','1036',477,'Retail Sale Id 5964',35880.00,0.00,0.00,60.00,960.00,'2022-04-25 17:28:00','',''),(2619206,'1','202','1036',477,'Retail Sale Id 5965',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 17:29:28','',''),(2619207,'1','202','1036',477,'Retail Sale Id 5966',4999.92,0.00,0.00,7.53,617.46,'2022-04-25 17:32:00','',''),(2619208,'1','202','1036',477,'Retail Sale Id 5967',1201.84,0.00,0.00,1.81,148.42,'2022-04-25 17:34:58','',''),(2619209,'1','202','1036',477,'Retail Sale Id 5968',3499.28,0.00,0.00,5.27,432.14,'2022-04-25 17:38:34','',''),(2619210,'1','202','1036',477,'Retail Sale Id 5969',29900.00,0.00,0.00,50.00,800.00,'2022-04-25 17:43:37','',''),(2619211,'1','202','1036',477,'Retail Sale Id 5970',1500.64,0.00,0.00,2.26,185.32,'2022-04-25 17:44:46','',''),(2619212,'1','202','1036',477,'Retail Sale Id 5971',3353.20,0.00,0.00,5.05,414.10,'2022-04-25 17:45:34','',''),(2619213,'1','202','1036',477,'Retail Sale Id 5972',2503.28,0.00,0.00,3.77,309.14,'2022-04-25 17:47:58','',''),(2619214,'1','202','1036',477,'Retail Sale Id 5973',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 17:49:29','',''),(2619215,'1','202','1036',477,'Retail Sale Id 5974',6002.56,0.00,0.00,9.04,741.28,'2022-04-25 17:51:48','',''),(2619216,'1','202','1036',477,'Retail Sale Id 5975',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 17:52:46','',''),(2619217,'1','202','1036',477,'Retail Sale Id 5976',1500.64,0.00,0.00,2.26,185.32,'2022-04-25 17:53:46','',''),(2619218,'1','202','1036',477,'Retail Sale Id 5977',3200.48,0.00,0.00,4.82,395.24,'2022-04-25 17:58:07','',''),(2619219,'1','202','1036',477,'Retail Sale Id 5978',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 18:00:08','',''),(2619220,'1','202','1036',477,'Retail Sale Id 5979',3499.28,0.00,0.00,5.27,432.14,'2022-04-25 18:02:19','',''),(2619221,'1','202','1036',477,'Retail Sale Id 5980',6998.56,0.00,0.00,10.54,864.28,'2022-04-25 18:04:32','',''),(2619222,'1','202','1036',477,'Retail Sale Id 5981',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 18:05:24','',''),(2619223,'1','202','1036',477,'Retail Sale Id 5982',8300.00,0.00,0.00,12.50,1025.00,'2022-04-25 18:15:05','',''),(2619224,'1','202','1036',477,'Retail Sale Id 5983',1699.84,0.00,0.00,2.56,209.92,'2022-04-25 18:20:31','',''),(2619225,'1','202','1036',477,'Retail Sale Id 5984',8300.00,0.00,0.00,12.50,1025.00,'2022-04-25 18:21:33','',''),(2619226,'1','202','1036',477,'Retail Sale Id 5985',3300.08,0.00,0.00,4.97,407.54,'2022-04-25 18:27:34','',''),(2619227,'1','202','1036',477,'Retail Sale Id 5986',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 18:30:24','',''),(2619228,'1','202','1036',477,'Retail Sale Id 5987',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 18:31:28','',''),(2619229,'1','202','1036',477,'Retail Sale Id 5988',3997.28,0.00,0.00,6.02,493.64,'2022-04-25 18:33:21','',''),(2619230,'1','202','1036',477,'Retail Sale Id 5989',1998.64,0.00,0.00,3.01,246.82,'2022-04-25 18:37:41','',''),(2619231,'1','202','1036',477,'Retail Sale Id 5990',1002.64,0.00,0.00,1.51,123.82,'2022-04-25 18:39:08','',''),(2619232,'1','202','1036',477,'Retail Sale Id 5991',3001.28,0.00,0.00,4.52,370.64,'2022-04-25 18:40:58','',''),(2619233,'1','202','1036',477,'Retail Sale Id 5992',1347.92,0.00,0.00,2.03,166.46,'2022-04-25 18:46:57','',''),(2619234,'1','202','1036',477,'Return of Retail Sale Id 5989',0.00,1998.64,3.01,0.00,-246.82,'2022-04-25 19:32:52','',''),(2619235,'1','202','1036',477,'Retail Sale Id 5993',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 06:55:10','',''),(2619236,'1','202','1036',477,'Retail Sale Id 5994',1500.64,0.00,0.00,2.26,185.32,'2022-04-26 06:56:12','',''),(2619237,'1','202','1036',477,'Retail Sale Id 5995',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 06:57:10','',''),(2619238,'1','202','1036',477,'Retail Sale Id 5996',3001.28,0.00,0.00,4.52,370.64,'2022-04-26 06:58:07','',''),(2619239,'1','202','1036',477,'Retail Sale Id 5997',8001.20,0.00,0.00,12.05,988.10,'2022-04-26 07:03:44','',''),(2619240,'1','202','1036',477,'Retail Sale Id 5998',3353.20,0.00,0.00,5.05,414.10,'2022-04-26 07:05:32','',''),(2619241,'1','202','1036',477,'Retail Sale Id 5999',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 07:15:49','',''),(2619242,'1','202','1036',477,'Retail Sale Id 6000',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 07:19:15','',''),(2619243,'1','202','1036',477,'Retail Sale Id 6001',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 07:21:27','',''),(2619244,'1','202','1036',477,'Retail Sale Id 6002',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 07:23:45','',''),(2619245,'1','202','1036',477,'Retail Sale Id 6003',1500.64,0.00,0.00,2.26,185.32,'2022-04-26 07:24:43','',''),(2619246,'1','202','1036',477,'Retail Sale Id 6004',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 07:33:32','',''),(2619247,'1','202','1036',477,'Retail Sale Id 6005',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 07:34:19','',''),(2619248,'1','202','1036',477,'Retail Sale Id 6006',3001.28,0.00,0.00,4.52,370.64,'2022-04-26 07:35:17','',''),(2619249,'1','202','1036',477,'Retail Sale Id 6007',1500.64,0.00,0.00,2.26,185.32,'2022-04-26 07:36:24','',''),(2619250,'1','202','1036',477,'Retail Sale Id 6009',3001.28,0.00,0.00,4.52,370.64,'2022-04-26 07:38:09','',''),(2619251,'1','202','1036',477,'Retail Sale Id 6010',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 07:39:23','',''),(2619252,'1','202','1036',477,'Retail Sale Id 6011',1102.24,0.00,0.00,1.66,136.12,'2022-04-26 07:40:08','',''),(2619253,'1','202','1036',477,'Retail Sale Id 6012',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 07:42:11','',''),(2619254,'1','202','1036',477,'Retail Sale Id 6013',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 07:45:00','',''),(2619255,'1','202','1036',477,'Retail Sale Id 6014',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 07:49:58','',''),(2619256,'1','202','1036',477,'Retail Sale Id 6015',3353.20,0.00,0.00,5.05,414.10,'2022-04-26 07:50:52','',''),(2619257,'1','202','1036',477,'Retail Sale Id 6016',903.04,0.00,0.00,1.36,111.52,'2022-04-26 07:51:45','',''),(2619258,'1','202','1036',477,'Retail Sale Id 6017',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 07:53:43','',''),(2619259,'1','202','1036',477,'Retail Sale Id 6018',1500.64,0.00,0.00,2.26,185.32,'2022-04-26 08:01:59','',''),(2619260,'1','202','1036',477,'Retail Sale Id 6019',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 08:05:02','',''),(2619261,'1','202','1036',477,'Retail Sale Id 6020',1347.92,0.00,0.00,2.03,166.46,'2022-04-26 08:06:20','',''),(2619262,'1','202','1036',477,'Retail Sale Id 6021',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 08:07:25','',''),(2619263,'1','202','1036',477,'Retail Sale Id 6022',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 08:35:38','',''),(2619264,'1','202','1036',477,'Retail Sale Id 6023',3353.20,0.00,0.00,5.05,414.10,'2022-04-26 08:37:21','',''),(2619265,'1','202','1036',477,'Retail Sale Id 6024',2350.56,0.00,0.00,3.54,290.28,'2022-04-26 08:40:54','',''),(2619266,'1','202','1036',477,'Retail Sale Id 6025',3353.20,0.00,0.00,5.05,414.10,'2022-04-26 08:41:51','',''),(2619267,'1','202','1036',477,'Retail Sale Id 6026',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 08:42:32','',''),(2619268,'1','202','1036',477,'Retail Sale Id 6027',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 08:43:18','',''),(2619269,'1','202','1036',477,'Retail Sale Id 6028',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 08:43:54','',''),(2619270,'1','202','1036',477,'Retail Sale Id 6029',29900.00,0.00,0.00,50.00,800.00,'2022-04-26 08:45:23','',''),(2619271,'1','202','1036',477,'Retail Sale Id 6030',29900.00,0.00,0.00,50.00,800.00,'2022-04-26 08:50:08','',''),(2619272,'1','202','1036',477,'Retail Sale Id 6031',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 08:51:31','',''),(2619273,'1','202','1036',477,'Retail Sale Id 6032',16146.00,0.00,0.00,27.00,432.00,'2022-04-26 08:59:03','',''),(2619274,'1','202','1036',477,'Retail Sale Id 6033',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 09:08:02','',''),(2619275,'1','202','1036',477,'Retail Sale Id 6034',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 09:09:03','',''),(2619276,'1','202','1036',477,'Retail Sale Id 6035',1799.44,0.00,0.00,2.71,222.22,'2022-04-26 09:09:35','',''),(2619277,'1','202','1036',477,'Retail Sale Id 6036',23920.00,0.00,0.00,40.00,640.00,'2022-04-26 09:11:22','',''),(2619278,'1','202','1036',477,'Retail Sale Id 6037',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 09:12:37','',''),(2619279,'1','202','1036',477,'Retail Sale Id 6038',3001.28,0.00,0.00,4.52,370.64,'2022-04-26 09:15:01','',''),(2619280,'1','202','1036',477,'Retail Sale Id 6039',29900.00,0.00,0.00,50.00,800.00,'2022-04-26 09:15:45','',''),(2619281,'1','202','1036',477,'Retail Sale Id 6040',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 09:19:25','',''),(2619282,'1','202','1036',477,'Retail Sale Id 6041',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 09:23:30','',''),(2619283,'1','202','1036',477,'Retail Sale Id 6042',3001.28,0.00,0.00,4.52,370.64,'2022-04-26 09:25:12','',''),(2619284,'1','202','1036',477,'Retail Sale Id 6043',1347.92,0.00,0.00,2.03,166.46,'2022-04-26 09:26:14','',''),(2619285,'1','202','1036',477,'Retail Sale Id 6044',29900.00,0.00,0.00,50.00,800.00,'2022-04-26 09:37:17','',''),(2619286,'1','202','1036',477,'Retail Sale Id 6045',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 09:39:04','',''),(2619287,'1','202','1036',477,'Retail Sale Id 6046',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 09:42:57','',''),(2619288,'1','202','1036',477,'Retail Sale Id 6047',1500.64,0.00,0.00,2.26,185.32,'2022-04-26 09:45:07','',''),(2619289,'1','202','1036',477,'Retail Sale Id 6049',903.04,0.00,0.00,1.36,111.52,'2022-04-26 09:52:10','',''),(2619290,'1','202','1036',477,'Retail Sale Id 6050',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 10:02:53','',''),(2619291,'1','202','1036',477,'Retail Sale Id 6051',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 10:06:57','',''),(2619292,'1','202','1036',477,'Retail Sale Id 6052',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 10:20:57','',''),(2619293,'1','202','1036',477,'Retail Sale Id 6053',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 10:21:41','',''),(2619294,'1','202','1036',477,'Retail Sale Id 6054',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 10:24:31','',''),(2619295,'1','202','1036',477,'Retail Sale Id 6054',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 10:24:31','',''),(2619296,'1','202','1036',477,'Retail Sale Id 6055',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 10:28:02','',''),(2619297,'1','202','1036',477,'Retail Sale Id 6056',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 10:42:14','',''),(2619298,'1','202','1036',477,'Retail Sale Id 6057',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 10:48:14','',''),(2619299,'1','202','1036',477,'Retail Sale Id 6058',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 10:54:02','',''),(2619300,'1','202','1036',477,'Retail Sale Id 6059',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 11:00:21','',''),(2619301,'1','202','1036',477,'Retail Sale Id 6060',2503.28,0.00,0.00,3.77,309.14,'2022-04-26 11:01:03','',''),(2619302,'1','202','1036',477,'Retail Sale Id 6061',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 11:03:20','',''),(2619303,'1','202','1036',477,'Retail Sale Id 6062',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 11:05:20','',''),(2619304,'1','202','1036',477,'Retail Sale Id 6063',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 11:09:38','',''),(2619305,'1','202','1036',477,'Retail Sale Id 6064',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 11:13:02','',''),(2619306,'1','202','1036',477,'Retail Sale Id 6065',35880.00,0.00,0.00,60.00,960.00,'2022-04-26 11:17:05','',''),(2619307,'1','202','1036',477,'Retail Sale Id 6066',2702.48,0.00,0.00,4.07,333.74,'2022-04-26 11:36:28','',''),(2619308,'1','202','1036',477,'Retail Sale Id 6067',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 11:40:40','',''),(2619309,'1','202','1036',477,'Retail Sale Id 6068',32890.00,0.00,0.00,55.00,880.00,'2022-04-26 12:01:41','',''),(2619310,'1','202','1036',477,'Retail Sale Id 6069',3353.20,0.00,0.00,5.05,414.10,'2022-04-26 12:47:56','',''),(2619311,'1','202','1036',477,'Retail Sale Id 6069',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 12:47:56','',''),(2619312,'1','202','1036',477,'Retail Sale Id 6070',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 12:56:23','',''),(2619313,'1','202','1036',477,'Retail Sale Id 6071',8997.20,0.00,0.00,13.55,1111.10,'2022-04-26 13:11:05','',''),(2619314,'1','202','1036',477,'Retail Sale Id 6072',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 13:12:21','',''),(2619315,'1','202','1036',477,'Retail Sale Id 6073',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 13:18:40','',''),(2619316,'1','202','1036',477,'Retail Sale Id 6075',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 13:30:58','',''),(2619317,'1','202','1036',477,'Retail Sale Id 6076',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 13:37:29','',''),(2619318,'1','202','1036',477,'Retail Sale Id 6077',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 13:52:30','',''),(2619319,'1','202','1036',477,'Retail Sale Id 6078',37674.00,0.00,0.00,63.00,1008.00,'2022-04-26 14:13:50','',''),(2619320,'1','202','1036',477,'Retail Sale Id 6079',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 14:16:56','',''),(2619321,'1','202','1036',477,'Retail Sale Id 6082',1899.04,0.00,0.00,2.86,234.52,'2022-04-26 14:17:42','',''),(2619322,'1','202','1036',477,'Retail Sale Id 6083',1201.84,0.00,0.00,1.81,148.42,'2022-04-26 14:28:09','',''),(2619323,'1','202','1036',477,'Retail Sale Id 6085',6002.56,0.00,0.00,9.04,741.28,'2022-04-26 14:28:56','',''),(2619324,'1','202','1036',477,'Retail Sale Id 6086',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 14:30:52','',''),(2619325,'1','202','1036',477,'Retail Sale Id 6087',3897.68,0.00,0.00,5.87,481.34,'2022-04-26 14:31:39','',''),(2619326,'1','202','1036',477,'Retail Sale Id 6089',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 14:33:13','',''),(2619327,'1','202','1036',477,'Retail Sale Id 6091',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 14:33:55','',''),(2619328,'1','202','1036',477,'Retail Sale Id 6092',1500.64,0.00,0.00,2.26,185.32,'2022-04-26 15:04:09','',''),(2619329,'1','202','1036',477,'Retail Sale Id 6095',3499.28,0.00,0.00,5.27,432.14,'2022-04-26 15:08:24','',''),(2619330,'1','202','1036',477,'Retail Sale Id 6097',1201.84,0.00,0.00,1.81,148.42,'2022-04-26 15:09:18','',''),(2619331,'1','202','1036',477,'Retail Sale Id 6098',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 15:17:56','',''),(2619332,'1','202','1036',477,'Retail Sale Id 6099',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 15:34:58','',''),(2619333,'1','202','1036',477,'Retail Sale Id 6100',6002.56,0.00,0.00,9.04,741.28,'2022-04-26 15:40:16','',''),(2619334,'1','202','1036',477,'Retail Sale Id 6102',298.80,0.00,0.00,0.45,36.90,'2022-04-26 15:41:02','',''),(2619335,'1','202','1036',477,'Retail Sale Id 6103',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 15:56:35','',''),(2619336,'1','202','1036',477,'Retail Sale Id 6104',1347.92,0.00,0.00,2.03,166.46,'2022-04-26 15:57:33','',''),(2619337,'1','202','1036',477,'Retail Sale Id 6105',3499.28,0.00,0.00,5.27,432.14,'2022-04-26 15:59:42','',''),(2619338,'1','202','1036',477,'Retail Sale Id 6107',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 16:00:25','',''),(2619339,'1','202','1036',477,'Retail Sale Id 6108',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 16:07:29','',''),(2619340,'1','202','1036',477,'Retail Sale Id 6110',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 16:08:22','',''),(2619341,'1','202','1036',477,'Retail Sale Id 6111',1347.92,0.00,0.00,2.03,166.46,'2022-04-26 16:09:15','',''),(2619342,'1','202','1036',477,'Retail Sale Id 6113',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 16:10:12','',''),(2619343,'1','202','1036',477,'Retail Sale Id 6114',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 16:11:25','',''),(2619344,'1','202','1036',477,'Retail Sale Id 6117',3353.20,0.00,0.00,5.05,414.10,'2022-04-26 16:13:30','',''),(2619345,'1','202','1036',477,'Retail Sale Id 6119',3353.20,0.00,0.00,5.05,414.10,'2022-04-26 16:14:09','',''),(2619346,'1','202','1036',477,'Retail Sale Id 6121',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 16:16:12','',''),(2619347,'1','202','1036',477,'Retail Sale Id 6122',3001.28,0.00,0.00,4.52,370.64,'2022-04-26 16:17:06','',''),(2619348,'1','202','1036',477,'Retail Sale Id 6124',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 16:17:53','',''),(2619349,'1','202','1036',477,'Retail Sale Id 6126',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 16:23:30','',''),(2619350,'1','202','1036',477,'Retail Sale Id 6127',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 16:24:42','',''),(2619351,'1','202','1036',477,'Retail Sale Id 6128',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 16:26:19','',''),(2619352,'1','202','1036',477,'Retail Sale Id 6129',1500.64,0.00,0.00,2.26,185.32,'2022-04-26 16:30:27','',''),(2619353,'1','202','1036',477,'Retail Sale Id 6131',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 16:38:12','',''),(2619354,'1','202','1036',477,'Retail Sale Id 6132',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 16:39:15','',''),(2619355,'1','202','1036',477,'Retail Sale Id 6134',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 16:42:34','',''),(2619356,'1','202','1036',477,'Retail Sale Id 6136',3499.28,0.00,0.00,5.27,432.14,'2022-04-26 16:43:16','',''),(2619357,'1','202','1036',477,'Retail Sale Id 6138',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 16:52:08','',''),(2619358,'1','202','1036',477,'Retail Sale Id 6138',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 16:52:08','',''),(2619359,'1','202','1036',477,'Retail Sale Id 6140',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 16:57:18','',''),(2619360,'1','202','1036',477,'Retail Sale Id 6141',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 17:00:37','',''),(2619361,'1','202','1036',477,'Retail Sale Id 6142',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 17:04:21','',''),(2619362,'1','202','1036',477,'Retail Sale Id 6143',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 17:06:16','',''),(2619363,'1','202','1036',477,'Retail Sale Id 6145',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 17:06:58','',''),(2619364,'1','202','1036',477,'Retail Sale Id 6146',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 17:16:15','',''),(2619365,'1','202','1036',477,'Retail Sale Id 6147',1347.92,0.00,0.00,2.03,166.46,'2022-04-26 17:21:40','',''),(2619366,'1','202','1036',477,'Retail Sale Id 6148',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 17:24:42','',''),(2619367,'1','202','1036',477,'Retail Sale Id 6149',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 17:25:52','',''),(2619368,'1','202','1036',477,'Retail Sale Id 6150',3001.28,0.00,0.00,4.52,370.64,'2022-04-26 17:26:40','',''),(2619369,'1','202','1036',477,'Retail Sale Id 6152',1347.92,0.00,0.00,2.03,166.46,'2022-04-26 17:31:15','',''),(2619370,'1','202','1036',477,'Retail Sale Id 6154',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 17:41:30','',''),(2619371,'1','202','1036',477,'Retail Sale Id 6156',6998.56,0.00,0.00,10.54,864.28,'2022-04-26 17:42:16','',''),(2619372,'1','202','1036',477,'Retail Sale Id 6157',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 17:43:16','',''),(2619373,'1','202','1036',477,'Retail Sale Id 6159',6002.56,0.00,0.00,9.04,741.28,'2022-04-26 17:44:26','',''),(2619374,'1','202','1036',477,'Retail Sale Id 6160',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 17:47:52','',''),(2619375,'1','202','1036',477,'Retail Sale Id 6161',8001.20,0.00,0.00,12.05,988.10,'2022-04-26 17:49:43','',''),(2619376,'1','202','1036',477,'Retail Sale Id 6163',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 17:50:26','',''),(2619377,'1','202','1036',477,'Retail Sale Id 6165',1500.64,0.00,0.00,2.26,185.32,'2022-04-26 17:51:20','',''),(2619378,'1','202','1036',477,'Retail Sale Id 6167',3353.20,0.00,0.00,5.05,414.10,'2022-04-26 17:52:01','',''),(2619379,'1','202','1036',477,'Retail Sale Id 6169',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 17:52:42','',''),(2619380,'1','202','1036',477,'Retail Sale Id 6171',19136.00,0.00,0.00,32.00,512.00,'2022-04-26 17:55:36','',''),(2619381,'1','202','1036',477,'Retail Sale Id 6172',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 18:07:27','',''),(2619382,'1','202','1036',477,'Retail Sale Id 6174',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 18:08:26','',''),(2619383,'1','202','1036',477,'Retail Sale Id 6175',1500.64,0.00,0.00,2.26,185.32,'2022-04-26 18:11:38','',''),(2619384,'1','202','1036',477,'Retail Sale Id 6176',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 18:13:15','',''),(2619385,'1','202','1036',477,'Retail Sale Id 6177',3997.28,0.00,0.00,6.02,493.64,'2022-04-26 18:16:27','',''),(2619386,'1','202','1036',477,'Retail Sale Id 6179',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 18:24:23','',''),(2619387,'1','202','1036',477,'Retail Sale Id 6180',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 18:30:52','',''),(2619388,'1','202','1036',477,'Retail Sale Id 6181',1998.64,0.00,0.00,3.01,246.82,'2022-04-26 18:36:27','',''),(2619389,'1','202','1036',477,'Retail Sale Id 6182',3001.28,0.00,0.00,4.52,370.64,'2022-04-26 18:39:13','',''),(2619390,'1','202','1036',477,'Retail Sale Id 6184',1002.64,0.00,0.00,1.51,123.82,'2022-04-26 18:40:57','',''),(2619391,'1','202','1036',477,'Retail Sale Id 6185',3353.20,0.00,0.00,5.05,414.10,'2022-04-26 18:50:27','',''),(2619392,'1','202','1036',477,'Retail Sale Id 6186',8300.00,0.00,0.00,12.50,1025.00,'2022-04-26 19:00:39','',''),(2619393,'1','202','1036',477,'Retail Sale Id 6187',3193.84,0.00,0.00,4.81,394.42,'2022-04-26 19:27:07','',''),(2619394,'1','202','1036',477,'Retail Sale Id 6188',8001.20,0.00,0.00,12.05,988.10,'2022-04-27 07:57:12','',''),(2619395,'1','202','1036',477,'Retail Sale Id 6190',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 07:57:53','',''),(2619396,'1','202','1036',477,'Retail Sale Id 6192',4601.52,0.00,0.00,6.93,568.26,'2022-04-27 07:58:47','',''),(2619397,'1','202','1036',477,'Retail Sale Id 6193',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 07:59:36','',''),(2619398,'1','202','1036',477,'Retail Sale Id 6194',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 08:05:59','',''),(2619399,'1','202','1036',477,'Retail Sale Id 6195',2702.48,0.00,0.00,4.07,333.74,'2022-04-27 08:19:16','',''),(2619400,'1','202','1036',477,'Retail Sale Id 6196',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 08:29:45','',''),(2619401,'1','202','1036',477,'Retail Sale Id 6197',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 08:30:28','',''),(2619402,'1','202','1036',477,'Retail Sale Id 6198',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 08:34:09','',''),(2619403,'1','202','1036',477,'Retail Sale Id 6199',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 08:44:30','',''),(2619404,'1','202','1036',477,'Retail Sale Id 6200',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 08:51:19','',''),(2619405,'1','202','1036',477,'Retail Sale Id 6201',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 08:56:03','',''),(2619406,'1','202','1036',477,'Retail Sale Id 6202',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 09:06:10','',''),(2619407,'1','202','1036',477,'Retail Sale Id 6203',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 09:07:30','',''),(2619408,'1','202','1036',477,'Retail Sale Id 6205',1301.44,0.00,0.00,1.96,160.72,'2022-04-27 09:22:03','',''),(2619409,'1','202','1036',477,'Retail Sale Id 6206',8001.20,0.00,0.00,12.05,988.10,'2022-04-27 09:26:15','',''),(2619410,'1','202','1036',477,'Retail Sale Id 6207',3353.20,0.00,0.00,5.05,414.10,'2022-04-27 09:30:55','',''),(2619411,'1','202','1036',477,'Retail Sale Id 6208',1500.64,0.00,0.00,2.26,185.32,'2022-04-27 09:32:16','',''),(2619412,'1','202','1036',477,'Retail Sale Id 6209',4648.00,0.00,0.00,7.00,574.00,'2022-04-27 09:35:52','',''),(2619413,'1','202','1036',477,'Retail Sale Id 6210',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 09:36:50','',''),(2619414,'1','202','1036',477,'Retail Sale Id 6211',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 09:41:24','',''),(2619415,'1','202','1036',477,'Retail Sale Id 6212',3001.28,0.00,0.00,4.52,370.64,'2022-04-27 09:47:57','',''),(2619416,'1','202','1036',477,'Retail Sale Id 6213',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 09:53:23','',''),(2619417,'1','202','1036',477,'Retail Sale Id 6214',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 09:58:29','',''),(2619418,'1','202','1036',477,'Retail Sale Id 6215',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 10:00:25','',''),(2619419,'1','202','1036',477,'Retail Sale Id 6217',1500.64,0.00,0.00,2.26,185.32,'2022-04-27 10:01:19','',''),(2619420,'1','202','1036',477,'Retail Sale Id 6218',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 10:05:51','',''),(2619421,'1','202','1036',477,'Retail Sale Id 6220',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 10:11:01','',''),(2619422,'1','202','1036',477,'Retail Sale Id 6221',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 10:12:08','',''),(2619423,'1','202','1036',477,'Retail Sale Id 6224',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 10:30:25','',''),(2619424,'1','202','1036',477,'Retail Sale Id 6225',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 10:31:27','',''),(2619425,'1','202','1036',477,'Retail Sale Id 6226',1899.04,0.00,0.00,2.86,234.52,'2022-04-27 10:50:25','',''),(2619426,'1','202','1036',477,'Retail Sale Id 6227',3399.68,0.00,0.00,5.12,419.84,'2022-04-27 10:53:15','',''),(2619427,'1','202','1036',477,'Retail Sale Id 6228',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 10:55:39','',''),(2619428,'1','202','1036',477,'Retail Sale Id 6229',4999.92,0.00,0.00,7.53,617.46,'2022-04-27 11:00:49','',''),(2619429,'1','202','1036',477,'Retail Sale Id 6230',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 11:11:01','',''),(2619430,'1','202','1036',477,'Retail Sale Id 6231',1500.64,0.00,0.00,2.26,185.32,'2022-04-27 11:15:23','',''),(2619431,'1','202','1036',477,'Retail Sale Id 6232',3353.20,0.00,0.00,5.05,414.10,'2022-04-27 11:16:13','',''),(2619432,'1','202','1036',477,'Retail Sale Id 6233',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 11:18:11','',''),(2619433,'1','202','1036',477,'Retail Sale Id 6234',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 11:19:48','',''),(2619434,'1','202','1036',477,'Retail Sale Id 6235',3353.20,0.00,0.00,5.05,414.10,'2022-04-27 12:00:49','',''),(2619435,'1','202','1036',477,'Retail Sale Id 6236',3001.28,0.00,0.00,4.52,370.64,'2022-04-27 12:07:45','',''),(2619436,'1','202','1036',477,'Retail Sale Id 6237',498.00,0.00,0.00,0.75,61.50,'2022-04-27 12:10:37','',''),(2619437,'1','202','1036',477,'Retail Sale Id 6238',3353.20,0.00,0.00,5.05,414.10,'2022-04-27 12:18:53','',''),(2619438,'1','202','1036',477,'Retail Sale Id 6239',1301.44,0.00,0.00,1.96,160.72,'2022-04-27 12:25:35','',''),(2619439,'1','202','1036',477,'Retail Sale Id 6240',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 12:30:57','',''),(2619440,'1','202','1036',477,'Retail Sale Id 6241',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 12:34:18','',''),(2619441,'1','202','1036',477,'Retail Sale Id 6242',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 12:36:26','',''),(2619442,'1','202','1036',477,'Retail Sale Id 6243',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 12:42:41','',''),(2619443,'1','202','1036',477,'Retail Sale Id 6245',4999.92,0.00,0.00,7.53,617.46,'2022-04-27 12:44:02','',''),(2619444,'1','202','1036',477,'Retail Sale Id 6246',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 12:52:49','',''),(2619445,'1','202','1036',477,'Retail Sale Id 6248',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 12:55:06','',''),(2619446,'1','202','1036',477,'Retail Sale Id 6249',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 13:14:45','',''),(2619447,'1','202','1036',477,'Retail Sale Id 6250',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 13:27:15','',''),(2619448,'1','202','1036',477,'Retail Sale Id 6251',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 13:39:04','',''),(2619449,'1','202','1036',477,'Retail Sale Id 6252',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 13:47:33','',''),(2619450,'1','202','1036',477,'Retail Sale Id 6253',2702.48,0.00,0.00,4.07,333.74,'2022-04-27 13:48:39','',''),(2619451,'1','202','1036',477,'Retail Sale Id 6254',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 13:50:04','',''),(2619452,'1','202','1036',477,'Retail Sale Id 6255',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 13:53:47','',''),(2619453,'1','202','1036',477,'Retail Sale Id 6256',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 13:54:27','',''),(2619454,'1','202','1036',477,'Retail Sale Id 6257',16600.00,0.00,0.00,25.00,2050.00,'2022-04-27 14:01:48','',''),(2619455,'1','202','1036',477,'Retail Sale Id 6258',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 14:14:50','',''),(2619456,'1','202','1036',477,'Retail Sale Id 6259',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 14:17:54','',''),(2619457,'1','202','1036',477,'Retail Sale Id 6260',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 14:20:55','',''),(2619458,'1','202','1036',477,'Retail Sale Id 6261',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 14:29:07','',''),(2619459,'1','202','1036',477,'Retail Sale Id 6262',3001.28,0.00,0.00,4.52,370.64,'2022-04-27 14:31:54','',''),(2619460,'1','202','1036',477,'Retail Sale Id 6263',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 14:34:51','',''),(2619461,'1','202','1036',477,'Retail Sale Id 6264',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 14:35:55','',''),(2619462,'1','202','1036',477,'Retail Sale Id 6265',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 14:38:08','',''),(2619463,'1','202','1036',477,'Retail Sale Id 6266',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 14:48:34','',''),(2619464,'1','202','1036',477,'Retail Sale Id 6267',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 14:57:01','',''),(2619465,'1','202','1036',477,'Retail Sale Id 6268',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 14:58:09','',''),(2619466,'1','202','1036',477,'Retail Sale Id 6269',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 15:08:18','',''),(2619467,'1','202','1036',477,'Retail Sale Id 6270',3001.28,0.00,0.00,4.52,370.64,'2022-04-27 15:10:53','',''),(2619468,'1','202','1036',477,'Retail Sale Id 6272',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 15:35:09','',''),(2619469,'1','202','1036',477,'Retail Sale Id 6273',2702.48,0.00,0.00,4.07,333.74,'2022-04-27 15:37:57','',''),(2619470,'1','202','1036',477,'Retail Sale Id 6274',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 15:39:25','',''),(2619471,'1','202','1036',477,'Retail Sale Id 6275',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 15:44:07','',''),(2619472,'1','202','1036',477,'Retail Sale Id 6276',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 15:48:58','',''),(2619473,'1','202','1036',477,'Retail Sale Id 6277',796.80,0.00,0.00,1.20,98.40,'2022-04-27 15:53:28','',''),(2619474,'1','202','1036',477,'Retail Sale Id 6278',32890.00,0.00,0.00,55.00,880.00,'2022-04-27 15:55:01','',''),(2619475,'1','202','1036',477,'Retail Sale Id 6279',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 16:01:47','',''),(2619476,'1','202','1036',477,'Retail Sale Id 6280',1347.92,0.00,0.00,2.03,166.46,'2022-04-27 16:03:40','',''),(2619477,'1','202','1036',477,'Retail Sale Id 6281',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 16:10:30','',''),(2619478,'1','202','1036',477,'Retail Sale Id 6282',1347.92,0.00,0.00,2.03,166.46,'2022-04-27 16:13:51','',''),(2619479,'1','202','1036',477,'Retail Sale Id 6283',3001.28,0.00,0.00,4.52,370.64,'2022-04-27 16:24:10','',''),(2619480,'1','202','1036',477,'Retail Sale Id 6284',1500.64,0.00,0.00,2.26,185.32,'2022-04-27 16:25:04','',''),(2619481,'1','202','1036',477,'Retail Sale Id 6285',1500.64,0.00,0.00,2.26,185.32,'2022-04-27 16:25:46','',''),(2619482,'1','202','1036',477,'Retail Sale Id 6286',3353.20,0.00,0.00,5.05,414.10,'2022-04-27 16:29:27','',''),(2619483,'1','202','1036',477,'Retail Sale Id 6287',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 16:40:06','',''),(2619484,'1','202','1036',477,'Retail Sale Id 6288',1301.44,0.00,0.00,1.96,160.72,'2022-04-27 16:43:11','',''),(2619485,'1','202','1036',477,'Retail Sale Id 6289',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 16:48:53','',''),(2619486,'1','202','1036',477,'Retail Sale Id 6290',8970.00,0.00,0.00,15.00,240.00,'2022-04-27 16:59:36','',''),(2619487,'1','202','1036',477,'Retail Sale Id 6292',4999.92,0.00,0.00,7.53,617.46,'2022-04-27 17:05:16','',''),(2619488,'1','202','1036',477,'Retail Sale Id 6293',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 17:10:50','',''),(2619489,'1','202','1036',477,'Retail Sale Id 6294',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 17:13:30','',''),(2619490,'1','202','1036',477,'Retail Sale Id 6295',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 17:14:17','',''),(2619491,'1','202','1036',477,'Retail Sale Id 6296',2503.28,0.00,0.00,3.77,309.14,'2022-04-27 17:18:20','',''),(2619492,'1','202','1036',477,'Retail Sale Id 6297',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 17:22:56','',''),(2619493,'1','202','1036',477,'Retail Sale Id 6298',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 17:23:30','',''),(2619494,'1','202','1036',477,'Retail Sale Id 6299',1699.84,0.00,0.00,2.56,209.92,'2022-04-27 17:25:44','',''),(2619495,'1','202','1036',477,'Retail Sale Id 6300',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 17:26:25','',''),(2619496,'1','202','1036',477,'Retail Sale Id 6301',3353.20,0.00,0.00,5.05,414.10,'2022-04-27 17:28:43','',''),(2619497,'1','202','1036',477,'Retail Sale Id 6301',3353.20,0.00,0.00,5.05,414.10,'2022-04-27 17:28:43','',''),(2619498,'1','202','1036',477,'Retail Sale Id 6302',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 17:29:47','',''),(2619499,'1','202','1036',477,'Retail Sale Id 6303',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 17:31:19','',''),(2619500,'1','202','1036',477,'Retail Sale Id 6304',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 17:32:41','',''),(2619501,'1','202','1036',477,'Retail Sale Id 6306',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 17:49:57','',''),(2619502,'1','202','1036',477,'Retail Sale Id 6307',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 17:54:04','',''),(2619503,'1','202','1036',477,'Retail Sale Id 6309',1102.24,0.00,0.00,1.66,136.12,'2022-04-27 17:56:27','',''),(2619504,'1','202','1036',477,'Retail Sale Id 6310',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 17:57:08','',''),(2619505,'1','202','1036',477,'Retail Sale Id 6311',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 17:57:46','',''),(2619506,'1','202','1036',477,'Retail Sale Id 6313',6002.56,0.00,0.00,9.04,741.28,'2022-04-27 18:07:54','',''),(2619507,'1','202','1036',477,'Retail Sale Id 6314',8300.00,0.00,0.00,12.50,1025.00,'2022-04-27 18:12:04','',''),(2619508,'1','202','1036',477,'Retail Sale Id 6315',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 18:13:07','',''),(2619509,'1','202','1036',477,'Retail Sale Id 6316',7702.40,0.00,0.00,11.60,951.20,'2022-04-27 18:16:14','',''),(2619510,'1','202','1036',477,'Retail Sale Id 6317',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 18:17:47','',''),(2619511,'1','202','1036',477,'Retail Sale Id 6318',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 18:18:28','',''),(2619512,'1','202','1036',477,'Retail Sale Id 6319',33200.00,0.00,0.00,50.00,4100.00,'2022-04-27 18:21:07','',''),(2619513,'1','202','1036',477,'Retail Sale Id 6320',1500.64,0.00,0.00,2.26,185.32,'2022-04-27 18:23:14','',''),(2619514,'1','202','1036',477,'Retail Sale Id 6321',3001.28,0.00,0.00,4.52,370.64,'2022-04-27 18:24:44','',''),(2619515,'1','202','1036',477,'Retail Sale Id 6322',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 18:27:37','',''),(2619516,'1','202','1036',477,'Retail Sale Id 6323',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 18:30:58','',''),(2619517,'1','202','1036',477,'Retail Sale Id 6324',1002.64,0.00,0.00,1.51,123.82,'2022-04-27 18:37:30','',''),(2619518,'1','202','1036',477,'Retail Sale Id 6325',3001.28,0.00,0.00,4.52,370.64,'2022-04-27 18:42:28','',''),(2619519,'1','202','1036',477,'Retail Sale Id 6326',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 18:46:19','',''),(2619520,'1','202','1036',477,'Retail Sale Id 6327',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 18:50:24','',''),(2619521,'1','202','1036',477,'Retail Sale Id 6328',1998.64,0.00,0.00,3.01,246.82,'2022-04-27 18:51:23','',''),(2619522,'1','202','1036',477,'Retail Sale Id 6329',3997.28,0.00,0.00,6.02,493.64,'2022-04-27 18:57:02','',''),(2619523,'1','202','1036',477,'Return of Retail Sale Id 6314',0.00,8300.00,12.50,0.00,-1025.00,'2022-04-27 19:32:47','',''),(2619524,'1','202','1036',477,'Retail Sale Id 6330',205413.00,0.00,0.00,343.50,5496.00,'2022-04-28 06:41:50','',''),(2619525,'1','202','1036',477,'Retail Sale Id 6331',697.20,0.00,0.00,1.05,86.10,'2022-04-28 07:14:22','',''),(2619526,'1','202','1036',477,'Retail Sale Id 6332',697.20,0.00,0.00,1.05,86.10,'2022-04-28 07:21:47','',''),(2619527,'1','202','1036',477,'Retail Sale Id 6333',796.80,0.00,0.00,1.20,98.40,'2022-04-28 07:22:57','',''),(2619528,'1','202','1036',477,'Retail Sale Id 6334',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 07:26:40','',''),(2619529,'1','202','1036',477,'Retail Sale Id 6335',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 07:32:42','',''),(2619530,'1','202','1036',477,'Retail Sale Id 6337',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 07:45:32','',''),(2619531,'1','202','1036',477,'Retail Sale Id 6338',2503.28,0.00,0.00,3.77,309.14,'2022-04-28 08:00:42','',''),(2619532,'1','202','1036',477,'Retail Sale Id 6339',29900.00,0.00,0.00,50.00,800.00,'2022-04-28 08:04:19','',''),(2619533,'1','202','1036',477,'Retail Sale Id 6336',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 08:29:06','',''),(2619534,'1','202','1036',477,'Retail Sale Id 6340',2503.28,0.00,0.00,3.77,309.14,'2022-04-28 08:30:04','',''),(2619535,'1','202','1036',477,'Retail Sale Id 6341',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 08:30:53','',''),(2619536,'1','202','1036',477,'Retail Sale Id 6342',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 08:35:24','',''),(2619537,'1','202','1036',477,'Retail Sale Id 6343',29900.00,0.00,0.00,50.00,800.00,'2022-04-28 08:37:04','',''),(2619538,'1','202','1036',477,'Retail Sale Id 6344',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 08:39:30','',''),(2619539,'1','202','1036',477,'Retail Sale Id 6345',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 08:47:21','',''),(2619540,'1','202','1036',477,'Retail Sale Id 6346',1401.04,0.00,0.00,2.11,173.02,'2022-04-28 08:49:35','',''),(2619541,'1','202','1036',477,'Retail Sale Id 6347',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 08:53:39','',''),(2619542,'1','202','1036',477,'Retail Sale Id 6348',4999.92,0.00,0.00,7.53,617.46,'2022-04-28 08:58:36','',''),(2619543,'1','202','1036',477,'Retail Sale Id 6349',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 09:00:04','',''),(2619544,'1','202','1036',477,'Retail Sale Id 6350',2702.48,0.00,0.00,4.07,333.74,'2022-04-28 09:06:14','',''),(2619545,'1','202','1036',477,'Retail Sale Id 6351',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 09:06:53','',''),(2619546,'1','202','1036',477,'Retail Sale Id 6352',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 09:08:06','',''),(2619547,'1','202','1036',477,'Retail Sale Id 6353',3499.28,0.00,0.00,5.27,432.14,'2022-04-28 09:09:29','',''),(2619548,'1','202','1036',477,'Retail Sale Id 6354',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 09:10:24','',''),(2619549,'1','202','1036',477,'Retail Sale Id 6355',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 09:16:10','',''),(2619550,'1','202','1036',477,'Retail Sale Id 6358',1301.44,0.00,0.00,1.96,160.72,'2022-04-28 09:19:27','',''),(2619551,'1','202','1036',477,'Retail Sale Id 6359',697.20,0.00,0.00,1.05,86.10,'2022-04-28 09:20:34','',''),(2619552,'1','202','1036',477,'Retail Sale Id 6360',6653.28,0.00,0.00,10.02,821.64,'2022-04-28 09:22:05','',''),(2619553,'1','202','1036',477,'Retail Sale Id 6361',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 09:23:25','',''),(2619554,'1','202','1036',477,'Retail Sale Id 6362',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 09:24:05','',''),(2619555,'1','202','1036',477,'Retail Sale Id 6363',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 09:41:22','',''),(2619556,'1','202','1036',477,'Retail Sale Id 6364',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 09:42:03','',''),(2619557,'1','202','1036',477,'Retail Sale Id 6365',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 09:43:28','',''),(2619558,'1','202','1036',477,'Retail Sale Id 6366',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 09:50:08','',''),(2619559,'1','202','1036',477,'Retail Sale Id 6367',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 09:52:33','',''),(2619560,'1','202','1036',477,'Retail Sale Id 6368',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 10:03:53','',''),(2619561,'1','202','1036',477,'Retail Sale Id 6369',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 10:04:40','',''),(2619562,'1','202','1036',477,'Retail Sale Id 6370',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 10:05:14','',''),(2619563,'1','202','1036',477,'Retail Sale Id 6371',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 10:16:20','',''),(2619564,'1','202','1036',477,'Retail Sale Id 6372',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 10:20:17','',''),(2619565,'1','202','1036',477,'Retail Sale Id 6373',1347.92,0.00,0.00,2.03,166.46,'2022-04-28 10:35:40','',''),(2619566,'1','202','1036',477,'Retail Sale Id 6374',697.20,0.00,0.00,1.05,86.10,'2022-04-28 10:38:05','',''),(2619567,'1','202','1036',477,'Retail Sale Id 6375',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 10:39:00','',''),(2619568,'1','202','1036',477,'Retail Sale Id 6377',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 10:43:03','',''),(2619569,'1','202','1036',477,'Retail Sale Id 6376',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 10:46:21','',''),(2619570,'1','202','1036',477,'Retail Sale Id 6378',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 10:53:08','',''),(2619571,'1','202','1036',477,'Retail Sale Id 6379',3001.28,0.00,0.00,4.52,370.64,'2022-04-28 11:01:01','',''),(2619572,'1','202','1036',477,'Retail Sale Id 6380',3001.28,0.00,0.00,4.52,370.64,'2022-04-28 11:04:12','',''),(2619573,'1','202','1036',477,'Retail Sale Id 6381',796.80,0.00,0.00,1.20,98.40,'2022-04-28 11:05:56','',''),(2619574,'1','202','1036',477,'Retail Sale Id 6382',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 11:06:40','',''),(2619575,'1','202','1036',477,'Retail Sale Id 6383',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 11:12:54','',''),(2619576,'1','202','1036',477,'Retail Sale Id 6384',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 11:14:25','',''),(2619577,'1','202','1036',477,'Retail Sale Id 6385',697.20,0.00,0.00,1.05,86.10,'2022-04-28 11:16:44','',''),(2619578,'1','202','1036',477,'Retail Sale Id 6386',29900.00,0.00,0.00,50.00,800.00,'2022-04-28 11:18:23','',''),(2619579,'1','202','1036',477,'Retail Sale Id 6387',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 11:19:05','',''),(2619580,'1','202','1036',477,'Retail Sale Id 6388',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 11:19:54','',''),(2619581,'1','202','1036',477,'Retail Sale Id 6389',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 11:20:30','',''),(2619582,'1','202','1036',477,'Retail Sale Id 6390',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 11:24:31','',''),(2619583,'1','202','1036',477,'Retail Sale Id 6391',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 11:25:34','',''),(2619584,'1','202','1036',477,'Retail Sale Id 6392',3001.28,0.00,0.00,4.52,370.64,'2022-04-28 11:26:49','',''),(2619585,'1','202','1036',477,'Retail Sale Id 6393',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 11:27:41','',''),(2619586,'1','202','1036',477,'Retail Sale Id 6394',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 11:30:16','',''),(2619587,'1','202','1036',477,'Retail Sale Id 6395',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 11:44:16','',''),(2619588,'1','202','1036',477,'Retail Sale Id 6395',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 11:44:16','',''),(2619589,'1','202','1036',477,'Retail Sale Id 6396',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 11:49:06','',''),(2619590,'1','202','1036',477,'Retail Sale Id 6397',6002.56,0.00,0.00,9.04,741.28,'2022-04-28 12:01:26','',''),(2619591,'1','202','1036',477,'Retail Sale Id 6398',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 12:05:53','',''),(2619592,'1','202','1036',477,'Retail Sale Id 6399',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 12:13:33','',''),(2619593,'1','202','1036',477,'Retail Sale Id 6400',36478.00,0.00,0.00,61.00,976.00,'2022-04-28 12:20:37','',''),(2619594,'1','202','1036',477,'Retail Sale Id 6401',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 12:22:04','',''),(2619595,'1','202','1036',477,'Retail Sale Id 6402',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 12:24:07','',''),(2619596,'1','202','1036',477,'Retail Sale Id 6403',1201.84,0.00,0.00,1.81,148.42,'2022-04-28 12:29:54','',''),(2619597,'1','202','1036',477,'Retail Sale Id 6404',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 12:32:20','',''),(2619598,'1','202','1036',477,'Retail Sale Id 6405',5298.72,0.00,0.00,7.98,654.36,'2022-04-28 12:33:18','',''),(2619599,'1','202','1036',477,'Retail Sale Id 6406',3499.28,0.00,0.00,5.27,432.14,'2022-04-28 12:36:42','',''),(2619600,'1','202','1036',477,'Retail Sale Id 6407',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 12:39:35','',''),(2619601,'1','202','1036',477,'Retail Sale Id 6408',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 13:10:23','',''),(2619602,'1','202','1036',477,'Retail Sale Id 6409',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 13:17:16','',''),(2619603,'1','202','1036',477,'Retail Sale Id 6410',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 13:17:56','',''),(2619604,'1','202','1036',477,'Retail Sale Id 6411',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 13:18:52','',''),(2619605,'1','202','1036',477,'Retail Sale Id 6412',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 13:19:57','',''),(2619606,'1','202','1036',477,'Retail Sale Id 6413',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 13:28:12','',''),(2619607,'1','202','1036',477,'Retail Sale Id 6414',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 14:12:58','',''),(2619608,'1','202','1036',477,'Retail Sale Id 6416',3499.28,0.00,0.00,5.27,432.14,'2022-04-28 14:13:40','',''),(2619609,'1','202','1036',477,'Retail Sale Id 6418',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 14:14:26','',''),(2619610,'1','202','1036',477,'Retail Sale Id 6420',2503.28,0.00,0.00,3.77,309.14,'2022-04-28 14:15:10','',''),(2619611,'1','202','1036',477,'Retail Sale Id 6422',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 14:15:56','',''),(2619612,'1','202','1036',477,'Retail Sale Id 6424',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 14:16:52','',''),(2619613,'1','202','1036',477,'Retail Sale Id 6425',3001.28,0.00,0.00,4.52,370.64,'2022-04-28 14:23:58','',''),(2619614,'1','202','1036',477,'Retail Sale Id 6426',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 14:25:11','',''),(2619615,'1','202','1036',477,'Retail Sale Id 6427',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 14:56:55','',''),(2619616,'1','202','1036',477,'Retail Sale Id 6429',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 14:59:39','',''),(2619617,'1','202','1036',477,'Retail Sale Id 6431',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 15:00:16','',''),(2619618,'1','202','1036',477,'Retail Sale Id 6433',6653.28,0.00,0.00,10.02,821.64,'2022-04-28 15:04:42','',''),(2619619,'1','202','1036',477,'Retail Sale Id 6435',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 15:05:54','',''),(2619620,'1','202','1036',477,'Retail Sale Id 6437',3499.28,0.00,0.00,5.27,432.14,'2022-04-28 15:06:37','',''),(2619621,'1','202','1036',477,'Retail Sale Id 6438',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 15:16:37','',''),(2619622,'1','202','1036',477,'Retail Sale Id 6439',29900.00,0.00,0.00,50.00,800.00,'2022-04-28 15:19:36','',''),(2619623,'1','202','1036',477,'Retail Sale Id 6440',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 15:22:26','',''),(2619624,'1','202','1036',477,'Retail Sale Id 6442',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 15:23:26','',''),(2619625,'1','202','1036',477,'Retail Sale Id 6443',7176.00,0.00,0.00,12.00,192.00,'2022-04-28 15:29:59','',''),(2619626,'1','202','1036',477,'Retail Sale Id 6444',2503.28,0.00,0.00,3.77,309.14,'2022-04-28 15:34:43','',''),(2619627,'1','202','1036',477,'Retail Sale Id 6446',3001.28,0.00,0.00,4.52,370.64,'2022-04-28 15:36:09','',''),(2619628,'1','202','1036',477,'Retail Sale Id 6447',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 15:37:22','',''),(2619629,'1','202','1036',477,'Retail Sale Id 6448',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 15:46:40','',''),(2619630,'1','202','1036',477,'Retail Sale Id 6449',29900.00,0.00,0.00,50.00,800.00,'2022-04-28 15:53:16','',''),(2619631,'1','202','1036',477,'Retail Sale Id 6451',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 15:54:09','',''),(2619632,'1','202','1036',477,'Retail Sale Id 6452',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 15:55:01','',''),(2619633,'1','202','1036',477,'Retail Sale Id 6454',3001.28,0.00,0.00,4.52,370.64,'2022-04-28 15:55:49','',''),(2619634,'1','202','1036',477,'Retail Sale Id 6456',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 15:56:36','',''),(2619635,'1','202','1036',477,'Retail Sale Id 6457',6998.56,0.00,0.00,10.54,864.28,'2022-04-28 16:09:31','',''),(2619636,'1','202','1036',477,'Retail Sale Id 6458',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 16:12:03','',''),(2619637,'1','202','1036',477,'Retail Sale Id 6459',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 16:13:04','',''),(2619638,'1','202','1036',477,'Retail Sale Id 6460',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 16:16:10','',''),(2619639,'1','202','1036',477,'Retail Sale Id 6461',2503.28,0.00,0.00,3.77,309.14,'2022-04-28 16:24:32','',''),(2619640,'1','202','1036',477,'Retail Sale Id 6462',16744.00,0.00,0.00,28.00,448.00,'2022-04-28 16:34:20','',''),(2619641,'1','202','1036',477,'Retail Sale Id 6464',1401.04,0.00,0.00,2.11,173.02,'2022-04-28 16:35:56','',''),(2619642,'1','202','1036',477,'Retail Sale Id 6466',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 16:36:45','',''),(2619643,'1','202','1036',477,'Retail Sale Id 6467',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 16:38:18','',''),(2619644,'1','202','1036',477,'Retail Sale Id 6468',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 16:39:10','',''),(2619645,'1','202','1036',477,'Retail Sale Id 6470',1347.92,0.00,0.00,2.03,166.46,'2022-04-28 16:42:38','',''),(2619646,'1','202','1036',477,'Retail Sale Id 6472',3499.28,0.00,0.00,5.27,432.14,'2022-04-28 16:47:33','',''),(2619647,'1','202','1036',477,'Retail Sale Id 6473',1347.92,0.00,0.00,2.03,166.46,'2022-04-28 16:48:30','',''),(2619648,'1','202','1036',477,'Retail Sale Id 6475',2503.28,0.00,0.00,3.77,309.14,'2022-04-28 16:51:01','',''),(2619649,'1','202','1036',477,'Retail Sale Id 6477',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 16:51:47','',''),(2619650,'1','202','1036',477,'Retail Sale Id 6478',3001.28,0.00,0.00,4.52,370.64,'2022-04-28 16:58:04','',''),(2619651,'1','202','1036',477,'Retail Sale Id 6480',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 16:59:12','',''),(2619652,'1','202','1036',477,'Retail Sale Id 6481',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 16:59:58','',''),(2619653,'1','202','1036',477,'Retail Sale Id 6483',1301.44,0.00,0.00,1.96,160.72,'2022-04-28 17:01:37','',''),(2619654,'1','202','1036',477,'Retail Sale Id 6484',1699.84,0.00,0.00,2.56,209.92,'2022-04-28 17:03:03','',''),(2619655,'1','202','1036',477,'Retail Sale Id 6486',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 17:03:57','',''),(2619656,'1','202','1036',477,'Retail Sale Id 6487',2702.48,0.00,0.00,4.07,333.74,'2022-04-28 17:06:12','',''),(2619657,'1','202','1036',477,'Retail Sale Id 6488',597.60,0.00,0.00,0.90,73.80,'2022-04-28 17:08:38','',''),(2619658,'1','202','1036',477,'Retail Sale Id 6489',1002.64,0.00,0.00,1.51,123.82,'2022-04-28 17:12:17','',''),(2619659,'1','202','1036',477,'Retail Sale Id 6491',1699.84,0.00,0.00,2.56,209.92,'2022-04-28 17:12:55','',''),(2619660,'1','202','1036',477,'Retail Sale Id 6492',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 17:16:32','',''),(2619661,'1','202','1036',477,'Retail Sale Id 6494',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 17:17:29','',''),(2619662,'1','202','1036',477,'Retail Sale Id 6496',1500.64,0.00,0.00,2.26,185.32,'2022-04-28 17:18:24','',''),(2619663,'1','202','1036',477,'Retail Sale Id 6498',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 17:22:21','',''),(2619664,'1','202','1036',477,'Retail Sale Id 6500',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 17:24:26','',''),(2619665,'1','202','1036',477,'Retail Sale Id 6502',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 17:25:21','',''),(2619666,'1','202','1036',477,'Retail Sale Id 6503',3001.28,0.00,0.00,4.52,370.64,'2022-04-28 17:46:17','',''),(2619667,'1','202','1036',477,'Retail Sale Id 6505',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 17:47:17','',''),(2619668,'1','202','1036',477,'Retail Sale Id 6506',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 17:49:15','',''),(2619669,'1','202','1036',477,'Retail Sale Id 6506',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 17:49:15','',''),(2619670,'1','202','1036',477,'Retail Sale Id 6508',1347.92,0.00,0.00,2.03,166.46,'2022-04-28 17:50:47','',''),(2619671,'1','202','1036',477,'Retail Sale Id 6510',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 17:51:57','',''),(2619672,'1','202','1036',477,'Retail Sale Id 6512',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 17:52:52','',''),(2619673,'1','202','1036',477,'Retail Sale Id 6514',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 17:53:31','',''),(2619674,'1','202','1036',477,'Retail Sale Id 6517',1347.92,0.00,0.00,2.03,166.46,'2022-04-28 17:54:51','',''),(2619675,'1','202','1036',477,'Retail Sale Id 6518',38870.00,0.00,0.00,65.00,1040.00,'2022-04-28 17:58:13','',''),(2619676,'1','202','1036',477,'Retail Sale Id 6519',8300.00,0.00,0.00,12.50,1025.00,'2022-04-28 17:59:34','',''),(2619677,'1','202','1036',477,'Retail Sale Id 6521',29900.00,0.00,0.00,50.00,800.00,'2022-04-28 18:01:07','',''),(2619678,'1','202','1036',477,'Retail Sale Id 6525',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 18:01:54','',''),(2619679,'1','202','1036',477,'Retail Sale Id 6527',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 18:02:47','',''),(2619680,'1','202','1036',477,'Retail Sale Id 6529',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 18:03:44','',''),(2619681,'1','202','1036',477,'Retail Sale Id 6530',6002.56,0.00,0.00,9.04,741.28,'2022-04-28 18:05:12','',''),(2619682,'1','202','1036',477,'Retail Sale Id 6532',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 18:08:47','',''),(2619683,'1','202','1036',477,'Retail Sale Id 6533',6002.56,0.00,0.00,9.04,741.28,'2022-04-28 18:15:21','',''),(2619684,'1','202','1036',477,'Retail Sale Id 6534',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 18:22:21','',''),(2619685,'1','202','1036',477,'Retail Sale Id 6535',498.00,0.00,0.00,0.75,61.50,'2022-04-28 18:27:11','',''),(2619686,'1','202','1036',477,'Retail Sale Id 6537',597.60,0.00,0.00,0.90,73.80,'2022-04-28 18:31:50','',''),(2619687,'1','202','1036',477,'Retail Sale Id 6538',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 18:34:37','',''),(2619688,'1','202','1036',477,'Retail Sale Id 6538',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 18:34:37','',''),(2619689,'1','202','1036',477,'Retail Sale Id 6540',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 18:35:32','',''),(2619690,'1','202','1036',477,'Retail Sale Id 6542',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 18:36:36','',''),(2619691,'1','202','1036',477,'Retail Sale Id 6546',3001.28,0.00,0.00,4.52,370.64,'2022-04-28 18:38:07','',''),(2619692,'1','202','1036',477,'Retail Sale Id 6547',1998.64,0.00,0.00,3.01,246.82,'2022-04-28 18:41:43','',''),(2619693,'1','202','1036',477,'Retail Sale Id 6550',1347.92,0.00,0.00,2.03,166.46,'2022-04-28 18:43:14','',''),(2619694,'1','202','1036',477,'Retail Sale Id 6552',3353.20,0.00,0.00,5.05,414.10,'2022-04-28 18:50:40','',''),(2619695,'1','202','1036',477,'Retail Sale Id 6554',3997.28,0.00,0.00,6.02,493.64,'2022-04-28 18:53:23','',''),(2619696,'1','202','1036',477,'Retail Sale Id 6555',2297.44,0.00,0.00,3.46,283.72,'2022-04-28 19:09:51','',''),(2619697,'1','202','1036',477,'Retail Sale Id 6556',697.20,0.00,0.00,1.05,86.10,'2022-04-29 07:21:47','',''),(2619698,'1','202','1036',477,'Retail Sale Id 6558',6653.28,0.00,0.00,10.02,821.64,'2022-04-29 07:22:32','',''),(2619699,'1','202','1036',477,'Retail Sale Id 6559',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 07:23:10','',''),(2619700,'1','202','1036',477,'Retail Sale Id 6560',29302.00,0.00,0.00,49.00,784.00,'2022-04-29 07:53:58','',''),(2619701,'1','202','1036',477,'Retail Sale Id 6561',2802.08,0.00,0.00,4.22,346.04,'2022-04-29 08:00:45','',''),(2619702,'1','202','1036',477,'Retail Sale Id 6563',3200.48,0.00,0.00,4.82,395.24,'2022-04-29 08:02:39','',''),(2619703,'1','202','1036',477,'Retail Sale Id 6564',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 08:33:40','',''),(2619704,'1','202','1036',477,'Retail Sale Id 6566',697.20,0.00,0.00,1.05,86.10,'2022-04-29 08:38:39','',''),(2619705,'1','202','1036',477,'Retail Sale Id 6567',2702.48,0.00,0.00,4.07,333.74,'2022-04-29 08:43:57','',''),(2619706,'1','202','1036',477,'Retail Sale Id 6569',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 08:54:12','',''),(2619707,'1','202','1036',477,'Retail Sale Id 6570',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 09:05:50','',''),(2619708,'1','202','1036',477,'Retail Sale Id 6572',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 09:12:40','',''),(2619709,'1','202','1036',477,'Retail Sale Id 6573',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 09:14:38','',''),(2619710,'1','202','1036',477,'Retail Sale Id 6574',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 09:58:48','',''),(2619711,'1','202','1036',477,'Retail Sale Id 6575',27648.96,0.00,0.00,41.64,3414.48,'2022-04-29 10:02:18','',''),(2619712,'1','202','1036',477,'Retail Sale Id 6576',7475.00,0.00,0.00,12.50,200.00,'2022-04-29 10:05:11','',''),(2619713,'1','202','1036',477,'Retail Sale Id 6577',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 10:06:08','',''),(2619714,'1','202','1036',477,'Retail Sale Id 6578',7304.00,0.00,0.00,11.00,902.00,'2022-04-29 10:08:24','',''),(2619715,'1','202','1036',477,'Retail Sale Id 6580',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 10:10:55','',''),(2619716,'1','202','1036',477,'Retail Sale Id 6582',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 10:12:09','',''),(2619717,'1','202','1036',477,'Retail Sale Id 6584',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 10:18:52','',''),(2619718,'1','202','1036',477,'Retail Sale Id 6586',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 10:19:52','',''),(2619719,'1','202','1036',477,'Retail Sale Id 6587',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 10:21:57','',''),(2619720,'1','202','1036',477,'Retail Sale Id 6589',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 10:24:16','',''),(2619721,'1','202','1036',477,'Retail Sale Id 6591',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 10:27:14','',''),(2619722,'1','202','1036',477,'Retail Sale Id 6593',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 10:28:08','',''),(2619723,'1','202','1036',477,'Retail Sale Id 6595',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 10:33:14','',''),(2619724,'1','202','1036',477,'Retail Sale Id 6596',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 10:39:01','',''),(2619725,'1','202','1036',477,'Retail Sale Id 6598',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 10:40:00','',''),(2619726,'1','202','1036',477,'Retail Sale Id 6599',3399.68,0.00,0.00,5.12,419.84,'2022-04-29 10:41:07','',''),(2619727,'1','202','1036',477,'Retail Sale Id 6600',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 10:46:31','',''),(2619728,'1','202','1036',477,'Retail Sale Id 6602',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 10:49:16','',''),(2619729,'1','202','1036',477,'Retail Sale Id 6603',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 10:51:16','',''),(2619730,'1','202','1036',477,'Retail Sale Id 6606',2702.48,0.00,0.00,4.07,333.74,'2022-04-29 10:55:06','',''),(2619731,'1','202','1036',477,'Retail Sale Id 6608',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 10:56:29','',''),(2619732,'1','202','1036',477,'Retail Sale Id 6609',498.00,0.00,0.00,0.75,61.50,'2022-04-29 10:57:45','',''),(2619733,'1','202','1036',477,'Retail Sale Id 6610',597.60,0.00,0.00,0.90,73.80,'2022-04-29 10:58:50','',''),(2619734,'1','202','1036',477,'Retail Sale Id 6612',597.60,0.00,0.00,0.90,73.80,'2022-04-29 10:59:45','',''),(2619735,'1','202','1036',477,'Retail Sale Id 6613',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 11:08:12','',''),(2619736,'1','202','1036',477,'Retail Sale Id 6614',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 11:09:22','',''),(2619737,'1','202','1036',477,'Retail Sale Id 6616',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 11:10:32','',''),(2619738,'1','202','1036',477,'Retail Sale Id 6617',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 11:11:59','',''),(2619739,'1','202','1036',477,'Retail Sale Id 6618',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 11:13:19','',''),(2619740,'1','202','1036',477,'Retail Sale Id 6620',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 11:14:17','',''),(2619741,'1','202','1036',477,'Retail Sale Id 6622',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 11:14:53','',''),(2619742,'1','202','1036',477,'Retail Sale Id 6624',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 11:15:42','',''),(2619743,'1','202','1036',477,'Retail Sale Id 6626',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 11:16:46','',''),(2619744,'1','202','1036',477,'Retail Sale Id 6627',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 11:28:12','',''),(2619745,'1','202','1036',477,'Retail Sale Id 6629',2503.28,0.00,0.00,3.77,309.14,'2022-04-29 11:30:16','',''),(2619746,'1','202','1036',477,'Retail Sale Id 6630',4302.72,0.00,0.00,6.48,531.36,'2022-04-29 11:31:12','',''),(2619747,'1','202','1036',477,'Retail Sale Id 6632',697.20,0.00,0.00,1.05,86.10,'2022-04-29 11:32:27','',''),(2619748,'1','202','1036',477,'Retail Sale Id 6633',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 11:39:03','',''),(2619749,'1','202','1036',477,'Retail Sale Id 6635',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 11:40:15','',''),(2619750,'1','202','1036',477,'Retail Sale Id 6636',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 11:41:59','',''),(2619751,'1','202','1036',477,'Retail Sale Id 6638',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 11:43:07','',''),(2619752,'1','202','1036',477,'Retail Sale Id 6639',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 11:56:11','',''),(2619753,'1','202','1036',477,'Retail Sale Id 6640',3353.20,0.00,0.00,5.05,414.10,'2022-04-29 11:57:18','',''),(2619754,'1','202','1036',477,'Retail Sale Id 6641',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 11:59:04','',''),(2619755,'1','202','1036',477,'Retail Sale Id 6643',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 12:01:06','',''),(2619756,'1','202','1036',477,'Retail Sale Id 6646',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 12:02:25','',''),(2619757,'1','202','1036',477,'Retail Sale Id 6647',1301.44,0.00,0.00,1.96,160.72,'2022-04-29 12:03:25','',''),(2619758,'1','202','1036',477,'Retail Sale Id 6649',4999.92,0.00,0.00,7.53,617.46,'2022-04-29 12:04:26','',''),(2619759,'1','202','1036',477,'Retail Sale Id 6650',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 12:05:24','',''),(2619760,'1','202','1036',477,'Retail Sale Id 6651',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 12:07:46','',''),(2619761,'1','202','1036',477,'Retail Sale Id 6652',3353.20,0.00,0.00,5.05,414.10,'2022-04-29 12:09:05','',''),(2619762,'1','202','1036',477,'Retail Sale Id 6654',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 12:11:27','',''),(2619763,'1','202','1036',477,'Retail Sale Id 6656',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:12:28','',''),(2619764,'1','202','1036',477,'Retail Sale Id 6657',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 12:14:37','',''),(2619765,'1','202','1036',477,'Retail Sale Id 6659',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 12:15:23','',''),(2619766,'1','202','1036',477,'Retail Sale Id 6661',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:16:09','',''),(2619767,'1','202','1036',477,'Retail Sale Id 6663',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 12:16:55','',''),(2619768,'1','202','1036',477,'Retail Sale Id 6665',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:17:33','',''),(2619769,'1','202','1036',477,'Retail Sale Id 6666',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:18:14','',''),(2619770,'1','202','1036',477,'Retail Sale Id 6668',1102.24,0.00,0.00,1.66,136.12,'2022-04-29 12:19:03','',''),(2619771,'1','202','1036',477,'Retail Sale Id 6671',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 12:19:49','',''),(2619772,'1','202','1036',477,'Retail Sale Id 6672',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 12:20:38','',''),(2619773,'1','202','1036',477,'Retail Sale Id 6674',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 12:21:32','',''),(2619774,'1','202','1036',477,'Retail Sale Id 6675',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:22:10','',''),(2619775,'1','202','1036',477,'Retail Sale Id 6677',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 12:23:20','',''),(2619776,'1','202','1036',477,'Retail Sale Id 6678',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 12:24:32','',''),(2619777,'1','202','1036',477,'Retail Sale Id 6680',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:25:15','',''),(2619778,'1','202','1036',477,'Retail Sale Id 6682',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 12:25:59','',''),(2619779,'1','202','1036',477,'Retail Sale Id 6683',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 12:28:48','',''),(2619780,'1','202','1036',477,'Retail Sale Id 6685',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:29:28','',''),(2619781,'1','202','1036',477,'Retail Sale Id 6686',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:30:14','',''),(2619782,'1','202','1036',477,'Retail Sale Id 6688',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 12:30:54','',''),(2619783,'1','202','1036',477,'Retail Sale Id 6689',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 12:32:25','',''),(2619784,'1','202','1036',477,'Retail Sale Id 6691',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:33:12','',''),(2619785,'1','202','1036',477,'Retail Sale Id 6693',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 12:33:55','',''),(2619786,'1','202','1036',477,'Retail Sale Id 6695',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 12:34:38','',''),(2619787,'1','202','1036',477,'Retail Sale Id 6696',796.80,0.00,0.00,1.20,98.40,'2022-04-29 12:37:26','',''),(2619788,'1','202','1036',477,'Retail Sale Id 6698',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 12:38:08','',''),(2619789,'1','202','1036',477,'Retail Sale Id 6699',29900.00,0.00,0.00,50.00,800.00,'2022-04-29 12:39:28','',''),(2619790,'1','202','1036',477,'Retail Sale Id 6700',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 12:41:27','',''),(2619791,'1','202','1036',477,'Retail Sale Id 6702',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:42:01','',''),(2619792,'1','202','1036',477,'Retail Sale Id 6704',697.20,0.00,0.00,1.05,86.10,'2022-04-29 12:42:53','',''),(2619793,'1','202','1036',477,'Retail Sale Id 6706',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 12:43:32','',''),(2619794,'1','202','1036',477,'Retail Sale Id 6707',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 12:44:51','',''),(2619795,'1','202','1036',477,'Retail Sale Id 6708',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 12:46:07','',''),(2619796,'1','202','1036',477,'Retail Sale Id 6710',3353.20,0.00,0.00,5.05,414.10,'2022-04-29 12:46:57','',''),(2619797,'1','202','1036',477,'Retail Sale Id 6711',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:48:07','',''),(2619798,'1','202','1036',477,'Retail Sale Id 6712',1799.44,0.00,0.00,2.71,222.22,'2022-04-29 12:48:56','',''),(2619799,'1','202','1036',477,'Retail Sale Id 6713',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:50:03','',''),(2619800,'1','202','1036',477,'Retail Sale Id 6714',1401.04,0.00,0.00,2.11,173.02,'2022-04-29 12:50:58','',''),(2619801,'1','202','1036',477,'Retail Sale Id 6716',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 12:51:36','',''),(2619802,'1','202','1036',477,'Retail Sale Id 6717',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 12:55:22','',''),(2619803,'1','202','1036',477,'Retail Sale Id 6718',1347.92,0.00,0.00,2.03,166.46,'2022-04-29 12:56:16','',''),(2619804,'1','202','1036',477,'Retail Sale Id 6720',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 12:57:04','',''),(2619805,'1','202','1036',477,'Retail Sale Id 6722',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 12:57:50','',''),(2619806,'1','202','1036',477,'Retail Sale Id 6724',3499.28,0.00,0.00,5.27,432.14,'2022-04-29 12:58:29','',''),(2619807,'1','202','1036',477,'Retail Sale Id 6725',3399.68,0.00,0.00,5.12,419.84,'2022-04-29 12:59:22','',''),(2619808,'1','202','1036',477,'Retail Sale Id 6730',6653.28,0.00,0.00,10.02,821.64,'2022-04-29 13:01:29','',''),(2619809,'1','202','1036',477,'Retail Sale Id 6732',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 13:03:13','',''),(2619810,'1','202','1036',477,'Retail Sale Id 6733',6653.28,0.00,0.00,10.02,821.64,'2022-04-29 13:06:25','',''),(2619811,'1','202','1036',477,'Retail Sale Id 6735',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 13:08:15','',''),(2619812,'1','202','1036',477,'Retail Sale Id 6737',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 13:08:57','',''),(2619813,'1','202','1036',477,'Retail Sale Id 6739',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 13:10:27','',''),(2619814,'1','202','1036',477,'Retail Sale Id 6741',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 13:11:18','',''),(2619815,'1','202','1036',477,'Retail Sale Id 6742',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 13:12:11','',''),(2619816,'1','202','1036',477,'Retail Sale Id 6743',3499.28,0.00,0.00,5.27,432.14,'2022-04-29 13:13:01','',''),(2619817,'1','202','1036',477,'Retail Sale Id 6745',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 13:13:57','',''),(2619818,'1','202','1036',477,'Retail Sale Id 6749',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 13:15:19','',''),(2619819,'1','202','1036',477,'Retail Sale Id 6751',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 13:16:00','',''),(2619820,'1','202','1036',477,'Retail Sale Id 6752',8001.20,0.00,0.00,12.05,988.10,'2022-04-29 13:17:08','',''),(2619821,'1','202','1036',477,'Retail Sale Id 6754',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 13:18:15','',''),(2619822,'1','202','1036',477,'Retail Sale Id 6755',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 13:19:22','',''),(2619823,'1','202','1036',477,'Retail Sale Id 6757',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 13:24:25','',''),(2619824,'1','202','1036',477,'Retail Sale Id 6759',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 13:25:21','',''),(2619825,'1','202','1036',477,'Retail Sale Id 6760',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 13:26:08','',''),(2619826,'1','202','1036',477,'Retail Sale Id 6762',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 13:26:57','',''),(2619827,'1','202','1036',477,'Retail Sale Id 6764',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 13:27:38','',''),(2619828,'1','202','1036',477,'Retail Sale Id 6766',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 13:28:28','',''),(2619829,'1','202','1036',477,'Retail Sale Id 6768',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 13:29:07','',''),(2619830,'1','202','1036',477,'Retail Sale Id 6769',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 13:30:29','',''),(2619831,'1','202','1036',477,'Retail Sale Id 6771',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 13:31:27','',''),(2619832,'1','202','1036',477,'Retail Sale Id 6773',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 13:32:04','',''),(2619833,'1','202','1036',477,'Retail Sale Id 6775',498.00,0.00,0.00,0.75,61.50,'2022-04-29 13:32:54','',''),(2619834,'1','202','1036',477,'Retail Sale Id 6776',1401.04,0.00,0.00,2.11,173.02,'2022-04-29 13:34:00','',''),(2619835,'1','202','1036',477,'Retail Sale Id 6778',3399.68,0.00,0.00,5.12,419.84,'2022-04-29 13:34:39','',''),(2619836,'1','202','1036',477,'Retail Sale Id 6779',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 13:36:51','',''),(2619837,'1','202','1036',477,'Retail Sale Id 6779',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 13:36:51','',''),(2619838,'1','202','1036',477,'Retail Sale Id 6782',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 13:39:51','',''),(2619839,'1','202','1036',477,'Retail Sale Id 6786',2802.08,0.00,0.00,4.22,346.04,'2022-04-29 13:48:02','',''),(2619840,'1','202','1036',477,'Retail Sale Id 6787',2503.28,0.00,0.00,3.77,309.14,'2022-04-29 13:49:13','',''),(2619841,'1','202','1036',477,'Retail Sale Id 6790',2802.08,0.00,0.00,4.22,346.04,'2022-04-29 13:50:45','',''),(2619842,'1','202','1036',477,'Retail Sale Id 6791',3353.20,0.00,0.00,5.05,414.10,'2022-04-29 13:55:31','',''),(2619843,'1','202','1036',477,'Retail Sale Id 6792',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 14:04:24','',''),(2619844,'1','202','1036',477,'Retail Sale Id 6793',3499.28,0.00,0.00,5.27,432.14,'2022-04-29 14:07:43','',''),(2619845,'1','202','1036',477,'Retail Sale Id 6794',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 14:10:27','',''),(2619846,'1','202','1036',477,'Retail Sale Id 6795',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 14:12:45','',''),(2619847,'1','202','1036',477,'Retail Sale Id 6796',2503.28,0.00,0.00,3.77,309.14,'2022-04-29 14:19:26','',''),(2619848,'1','202','1036',477,'Retail Sale Id 6797',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 14:24:48','',''),(2619849,'1','202','1036',477,'Retail Sale Id 6798',50232.00,0.00,0.00,84.00,1344.00,'2022-04-29 14:29:33','',''),(2619850,'1','202','1036',477,'Retail Sale Id 6799',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 14:34:40','',''),(2619851,'1','202','1036',477,'Retail Sale Id 6800',4501.92,0.00,0.00,6.78,555.96,'2022-04-29 14:37:29','',''),(2619852,'1','202','1036',477,'Retail Sale Id 6801',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 14:39:31','',''),(2619853,'1','202','1036',477,'Retail Sale Id 6802',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 14:41:38','',''),(2619854,'1','202','1036',477,'Retail Sale Id 6803',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 14:48:15','',''),(2619855,'1','202','1036',477,'Retail Sale Id 6804',5351.84,0.00,0.00,8.06,660.92,'2022-04-29 14:56:16','',''),(2619856,'1','202','1036',477,'Retail Sale Id 6805',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 15:01:00','',''),(2619857,'1','202','1036',477,'Retail Sale Id 6806',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 15:03:24','',''),(2619858,'1','202','1036',477,'Retail Sale Id 6807',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 15:04:28','',''),(2619859,'1','202','1036',477,'Retail Sale Id 6808',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 15:05:56','',''),(2619860,'1','202','1036',477,'Retail Sale Id 6809',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 15:06:35','',''),(2619861,'1','202','1036',477,'Retail Sale Id 6810',1899.04,0.00,0.00,2.86,234.52,'2022-04-29 15:07:18','',''),(2619862,'1','202','1036',477,'Retail Sale Id 6811',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 15:08:45','',''),(2619863,'1','202','1036',477,'Retail Sale Id 6812',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 15:09:43','',''),(2619864,'1','202','1036',477,'Retail Sale Id 6813',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 15:13:54','',''),(2619865,'1','202','1036',477,'Retail Sale Id 6815',697.20,0.00,0.00,1.05,86.10,'2022-04-29 15:15:08','',''),(2619866,'1','202','1036',477,'Retail Sale Id 6816',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 15:16:56','',''),(2619867,'1','202','1036',477,'Retail Sale Id 6817',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 15:19:46','',''),(2619868,'1','202','1036',477,'Retail Sale Id 6819',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 15:22:22','',''),(2619869,'1','202','1036',477,'Retail Sale Id 6820',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 15:26:30','',''),(2619870,'1','202','1036',477,'Retail Sale Id 6821',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 15:28:02','',''),(2619871,'1','202','1036',477,'Retail Sale Id 6822',2702.48,0.00,0.00,4.07,333.74,'2022-04-29 15:30:30','',''),(2619872,'1','202','1036',477,'Retail Sale Id 6823',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 15:31:03','',''),(2619873,'1','202','1036',477,'Retail Sale Id 6824',697.20,0.00,0.00,1.05,86.10,'2022-04-29 15:33:08','',''),(2619874,'1','202','1036',477,'Retail Sale Id 6825',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 15:34:52','',''),(2619875,'1','202','1036',477,'Retail Sale Id 6826',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 15:35:48','',''),(2619876,'1','202','1036',477,'Retail Sale Id 6827',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 15:37:40','',''),(2619877,'1','202','1036',477,'Retail Sale Id 6828',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 15:38:48','',''),(2619878,'1','202','1036',477,'Retail Sale Id 6829',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 15:39:58','',''),(2619879,'1','202','1036',477,'Retail Sale Id 6830',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 15:42:41','',''),(2619880,'1','202','1036',477,'Retail Sale Id 6831',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 15:43:59','',''),(2619881,'1','202','1036',477,'Retail Sale Id 6832',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 15:45:37','',''),(2619882,'1','202','1036',477,'Retail Sale Id 6833',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 15:50:05','',''),(2619883,'1','202','1036',477,'Retail Sale Id 6834',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 15:51:58','',''),(2619884,'1','202','1036',477,'Retail Sale Id 6835',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 15:55:47','',''),(2619885,'1','202','1036',477,'Retail Sale Id 6836',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 15:59:42','',''),(2619886,'1','202','1036',477,'Retail Sale Id 6837',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 16:05:56','',''),(2619887,'1','202','1036',477,'Retail Sale Id 6838',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 16:13:08','',''),(2619888,'1','202','1036',477,'Retail Sale Id 6839',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 16:14:09','',''),(2619889,'1','202','1036',477,'Retail Sale Id 6840',32890.00,0.00,0.00,55.00,880.00,'2022-04-29 16:15:47','',''),(2619890,'1','202','1036',477,'Retail Sale Id 6841',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 16:17:54','',''),(2619891,'1','202','1036',477,'Retail Sale Id 6842',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 16:18:38','',''),(2619892,'1','202','1036',477,'Retail Sale Id 6843',29900.00,0.00,0.00,50.00,800.00,'2022-04-29 16:22:56','',''),(2619893,'1','202','1036',477,'Retail Sale Id 6844',796.80,0.00,0.00,1.20,98.40,'2022-04-29 16:25:02','',''),(2619894,'1','202','1036',477,'Retail Sale Id 6845',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 16:25:53','',''),(2619895,'1','202','1036',477,'Retail Sale Id 6846',1201.84,0.00,0.00,1.81,148.42,'2022-04-29 16:26:54','',''),(2619896,'1','202','1036',477,'Retail Sale Id 6847',4501.92,0.00,0.00,6.78,555.96,'2022-04-29 16:27:50','',''),(2619897,'1','202','1036',477,'Retail Sale Id 6848',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 16:28:34','',''),(2619898,'1','202','1036',477,'Retail Sale Id 6849',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 16:35:15','',''),(2619899,'1','202','1036',477,'Retail Sale Id 6850',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 16:35:59','',''),(2619900,'1','202','1036',477,'Retail Sale Id 6851',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 16:37:02','',''),(2619901,'1','202','1036',477,'Retail Sale Id 6852',1347.92,0.00,0.00,2.03,166.46,'2022-04-29 16:41:42','',''),(2619902,'1','202','1036',477,'Retail Sale Id 6853',1799.44,0.00,0.00,2.71,222.22,'2022-04-29 16:42:44','',''),(2619903,'1','202','1036',477,'Retail Sale Id 6854',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 16:44:02','',''),(2619904,'1','202','1036',477,'Retail Sale Id 6855',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 16:45:06','',''),(2619905,'1','202','1036',477,'Retail Sale Id 6856',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 16:46:05','',''),(2619906,'1','202','1036',477,'Retail Sale Id 6857',3353.20,0.00,0.00,5.05,414.10,'2022-04-29 16:48:11','',''),(2619907,'1','202','1036',477,'Retail Sale Id 6858',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 16:49:03','',''),(2619908,'1','202','1036',477,'Retail Sale Id 6859',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 16:51:13','',''),(2619909,'1','202','1036',477,'Retail Sale Id 6861',14700.96,0.00,0.00,22.14,1815.48,'2022-04-29 16:52:59','',''),(2619910,'1','202','1036',477,'Retail Sale Id 6862',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 16:53:46','',''),(2619911,'1','202','1036',477,'Retail Sale Id 6863',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 16:54:45','',''),(2619912,'1','202','1036',477,'Retail Sale Id 6864',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 16:55:37','',''),(2619913,'1','202','1036',477,'Retail Sale Id 6865',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 16:57:34','',''),(2619914,'1','202','1036',477,'Retail Sale Id 6866',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 16:58:13','',''),(2619915,'1','202','1036',477,'Retail Sale Id 6867',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 16:58:54','',''),(2619916,'1','202','1036',477,'Retail Sale Id 6868',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 16:59:51','',''),(2619917,'1','202','1036',477,'Retail Sale Id 6869',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:00:37','',''),(2619918,'1','202','1036',477,'Retail Sale Id 6870',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:01:51','',''),(2619919,'1','202','1036',477,'Retail Sale Id 6871',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 17:02:46','',''),(2619920,'1','202','1036',477,'Retail Sale Id 6872',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:04:38','',''),(2619921,'1','202','1036',477,'Retail Sale Id 6873',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:05:20','',''),(2619922,'1','202','1036',477,'Retail Sale Id 6874',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:06:38','',''),(2619923,'1','202','1036',477,'Retail Sale Id 6875',2802.08,0.00,0.00,4.22,346.04,'2022-04-29 17:08:09','',''),(2619924,'1','202','1036',477,'Retail Sale Id 6876',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:08:46','',''),(2619925,'1','202','1036',477,'Retail Sale Id 6877',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 17:09:21','',''),(2619926,'1','202','1036',477,'Retail Sale Id 6878',6002.56,0.00,0.00,9.04,741.28,'2022-04-29 17:10:50','',''),(2619927,'1','202','1036',477,'Retail Sale Id 6879',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:11:59','',''),(2619928,'1','202','1036',477,'Retail Sale Id 6880',8001.20,0.00,0.00,12.05,988.10,'2022-04-29 17:12:44','',''),(2619929,'1','202','1036',477,'Retail Sale Id 6881',697.20,0.00,0.00,1.05,86.10,'2022-04-29 17:15:21','',''),(2619930,'1','202','1036',477,'Retail Sale Id 6882',1201.84,0.00,0.00,1.81,148.42,'2022-04-29 17:16:01','',''),(2619931,'1','202','1036',477,'Retail Sale Id 6883',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 17:17:29','',''),(2619932,'1','202','1036',477,'Retail Sale Id 6884',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:18:02','',''),(2619933,'1','202','1036',477,'Retail Sale Id 6885',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:18:40','',''),(2619934,'1','202','1036',477,'Retail Sale Id 6886',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 17:19:28','',''),(2619935,'1','202','1036',477,'Retail Sale Id 6887',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:20:09','',''),(2619936,'1','202','1036',477,'Retail Sale Id 6888',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 17:20:45','',''),(2619937,'1','202','1036',477,'Retail Sale Id 6889',1500.64,0.00,0.00,2.26,185.32,'2022-04-29 17:22:08','',''),(2619938,'1','202','1036',477,'Retail Sale Id 6890',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:24:04','',''),(2619939,'1','202','1036',477,'Retail Sale Id 6892',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 17:25:35','',''),(2619940,'1','202','1036',477,'Retail Sale Id 6893',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 17:26:19','',''),(2619941,'1','202','1036',477,'Retail Sale Id 6894',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 17:26:53','',''),(2619942,'1','202','1036',477,'Retail Sale Id 6895',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 17:29:09','',''),(2619943,'1','202','1036',477,'Retail Sale Id 6896',8300.00,0.00,0.00,12.50,1025.00,'2022-04-29 17:30:22','',''),(2619944,'1','202','1036',477,'Retail Sale Id 6897',4999.92,0.00,0.00,7.53,617.46,'2022-04-29 17:33:30','',''),(2619945,'1','202','1036',477,'Retail Sale Id 6898',40066.00,0.00,0.00,67.00,1072.00,'2022-04-29 17:36:49','',''),(2619946,'1','202','1036',477,'Retail Sale Id 6899',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 17:45:24','',''),(2619947,'1','202','1036',477,'Retail Sale Id 6900',1301.44,0.00,0.00,1.96,160.72,'2022-04-29 17:46:27','',''),(2619948,'1','202','1036',477,'Retail Sale Id 6901',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:46:59','',''),(2619949,'1','202','1036',477,'Retail Sale Id 6902',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 17:48:13','',''),(2619950,'1','202','1036',477,'Retail Sale Id 6903',2702.48,0.00,0.00,4.07,333.74,'2022-04-29 17:49:33','',''),(2619951,'1','202','1036',477,'Retail Sale Id 6904',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 17:50:54','',''),(2619952,'1','202','1036',477,'Retail Sale Id 6905',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 17:51:26','',''),(2619953,'1','202','1036',477,'Retail Sale Id 6906',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 17:55:29','',''),(2619954,'1','202','1036',477,'Retail Sale Id 6907',33200.00,0.00,0.00,50.00,4100.00,'2022-04-29 17:59:03','',''),(2619955,'1','202','1036',477,'Retail Sale Id 6908',1347.92,0.00,0.00,2.03,166.46,'2022-04-29 17:59:59','',''),(2619956,'1','202','1036',477,'Retail Sale Id 6909',1347.92,0.00,0.00,2.03,166.46,'2022-04-29 18:00:51','',''),(2619957,'1','202','1036',477,'Retail Sale Id 6910',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 18:01:25','',''),(2619958,'1','202','1036',477,'Retail Sale Id 6911',3353.20,0.00,0.00,5.05,414.10,'2022-04-29 18:04:17','',''),(2619959,'1','202','1036',477,'Retail Sale Id 6912',1347.92,0.00,0.00,2.03,166.46,'2022-04-29 18:05:10','',''),(2619960,'1','202','1036',477,'Retail Sale Id 6914',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 18:06:11','',''),(2619961,'1','202','1036',477,'Retail Sale Id 6915',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 18:07:30','',''),(2619962,'1','202','1036',477,'Retail Sale Id 6916',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 18:08:19','',''),(2619963,'1','202','1036',477,'Retail Sale Id 6917',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 18:11:32','',''),(2619964,'1','202','1036',477,'Retail Sale Id 6918',1347.92,0.00,0.00,2.03,166.46,'2022-04-29 18:14:18','',''),(2619965,'1','202','1036',477,'Retail Sale Id 6919',1201.84,0.00,0.00,1.81,148.42,'2022-04-29 18:15:05','',''),(2619966,'1','202','1036',477,'Retail Sale Id 6920',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 18:15:46','',''),(2619967,'1','202','1036',477,'Retail Sale Id 6921',2503.28,0.00,0.00,3.77,309.14,'2022-04-29 18:20:54','',''),(2619968,'1','202','1036',477,'Retail Sale Id 6922',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 18:28:47','',''),(2619969,'1','202','1036',477,'Retail Sale Id 6923',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 18:31:48','',''),(2619970,'1','202','1036',477,'Retail Sale Id 6924',4999.92,0.00,0.00,7.53,617.46,'2022-04-29 18:32:41','',''),(2619971,'1','202','1036',477,'Retail Sale Id 6925',4501.92,0.00,0.00,6.78,555.96,'2022-04-29 18:34:22','',''),(2619972,'1','202','1036',477,'Retail Sale Id 6926',3001.28,0.00,0.00,4.52,370.64,'2022-04-29 18:38:44','',''),(2619973,'1','202','1036',477,'Retail Sale Id 6927',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 18:39:27','',''),(2619974,'1','202','1036',477,'Retail Sale Id 6928',2702.48,0.00,0.00,4.07,333.74,'2022-04-29 18:40:09','',''),(2619975,'1','202','1036',477,'Retail Sale Id 6929',2702.48,0.00,0.00,4.07,333.74,'2022-04-29 18:40:56','',''),(2619976,'1','202','1036',477,'Retail Sale Id 6930',1002.64,0.00,0.00,1.51,123.82,'2022-04-29 18:43:56','',''),(2619977,'1','202','1036',477,'Retail Sale Id 6931',1347.92,0.00,0.00,2.03,166.46,'2022-04-29 18:44:47','',''),(2619978,'1','202','1036',477,'Retail Sale Id 6932',2702.48,0.00,0.00,4.07,333.74,'2022-04-29 18:45:56','',''),(2619979,'1','202','1036',477,'Retail Sale Id 6933',1998.64,0.00,0.00,3.01,246.82,'2022-04-29 18:47:20','',''),(2619980,'1','202','1036',477,'Retail Sale Id 6934',3997.28,0.00,0.00,6.02,493.64,'2022-04-29 19:00:39','',''),(2619981,'1','202','1036',477,'Return of Retail Sale Id 6824',0.00,697.20,1.05,0.00,-86.10,'2022-04-29 19:24:22','',''),(2619982,'1','202','1036',477,'Return of Retail Sale Id 6905',0.00,1002.64,1.51,0.00,-123.82,'2022-04-29 19:25:12','',''),(2619983,'1','202','1036',477,'Return of Retail Sale Id 6934',0.00,3997.28,6.02,0.00,-493.64,'2022-04-29 19:25:38','',''),(2619984,'1','202','1036',477,'Retail Sale Id 6935',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 06:39:14','',''),(2619985,'1','202','1036',477,'Retail Sale Id 6936',1347.92,0.00,0.00,2.03,166.46,'2022-04-30 06:40:28','',''),(2619986,'1','202','1036',477,'Retail Sale Id 6937',65780.00,0.00,0.00,110.00,1760.00,'2022-04-30 06:43:48','',''),(2619987,'1','202','1036',477,'Retail Sale Id 6938',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 07:17:29','',''),(2619988,'1','202','1036',477,'Retail Sale Id 6939',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 07:21:26','',''),(2619989,'1','202','1036',477,'Retail Sale Id 6940',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 07:23:07','',''),(2619990,'1','202','1036',477,'Retail Sale Id 6941',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 07:24:01','',''),(2619991,'1','202','1036',477,'Retail Sale Id 6942',3499.28,0.00,0.00,5.27,432.14,'2022-04-30 07:25:36','',''),(2619992,'1','202','1036',477,'Retail Sale Id 6943',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 07:26:18','',''),(2619993,'1','202','1036',477,'Retail Sale Id 6944',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 07:29:22','',''),(2619994,'1','202','1036',477,'Retail Sale Id 6945',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 07:39:51','',''),(2619995,'1','202','1036',477,'Retail Sale Id 6946',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 07:40:48','',''),(2619996,'1','202','1036',477,'Retail Sale Id 6948',29900.00,0.00,0.00,50.00,800.00,'2022-04-30 07:45:34','',''),(2619997,'1','202','1036',477,'Retail Sale Id 6949',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 07:47:51','',''),(2619998,'1','202','1036',477,'Retail Sale Id 6950',6002.56,0.00,0.00,9.04,741.28,'2022-04-30 07:48:50','',''),(2619999,'1','202','1036',477,'Retail Sale Id 6951',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 07:50:05','',''),(2620000,'1','202','1036',477,'Retail Sale Id 6952',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 07:52:08','',''),(2620001,'1','202','1036',477,'Retail Sale Id 6953',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 07:54:26','',''),(2620002,'1','202','1036',477,'Retail Sale Id 6954',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 07:57:08','',''),(2620003,'1','202','1036',477,'Retail Sale Id 6955',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 07:57:46','',''),(2620004,'1','202','1036',477,'Retail Sale Id 6956',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 07:59:29','',''),(2620005,'1','202','1036',477,'Retail Sale Id 6957',2702.48,0.00,0.00,4.07,333.74,'2022-04-30 08:00:09','',''),(2620006,'1','202','1036',477,'Retail Sale Id 6958',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 08:01:29','',''),(2620007,'1','202','1036',477,'Retail Sale Id 6958',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 08:01:29','',''),(2620008,'1','202','1036',477,'Retail Sale Id 6959',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 08:02:47','',''),(2620009,'1','202','1036',477,'Retail Sale Id 6960',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 08:03:26','',''),(2620010,'1','202','1036',477,'Retail Sale Id 6961',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 08:04:04','',''),(2620011,'1','202','1036',477,'Retail Sale Id 6962',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 08:04:39','',''),(2620012,'1','202','1036',477,'Retail Sale Id 6963',6002.56,0.00,0.00,9.04,741.28,'2022-04-30 08:05:37','',''),(2620013,'1','202','1036',477,'Retail Sale Id 6964',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 08:07:54','',''),(2620014,'1','202','1036',477,'Retail Sale Id 6965',2702.48,0.00,0.00,4.07,333.74,'2022-04-30 08:09:38','',''),(2620015,'1','202','1036',477,'Retail Sale Id 6966',5312.00,0.00,0.00,8.00,656.00,'2022-04-30 08:11:26','',''),(2620016,'1','202','1036',477,'Retail Sale Id 6967',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 08:12:43','',''),(2620017,'1','202','1036',477,'Retail Sale Id 6968',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 08:14:48','',''),(2620018,'1','202','1036',477,'Retail Sale Id 6969',38870.00,0.00,0.00,65.00,1040.00,'2022-04-30 08:16:24','',''),(2620019,'1','202','1036',477,'Retail Sale Id 6970',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 08:18:01','',''),(2620020,'1','202','1036',477,'Retail Sale Id 6971',29900.00,0.00,0.00,50.00,800.00,'2022-04-30 08:19:44','',''),(2620021,'1','202','1036',477,'Retail Sale Id 6972',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 08:21:07','',''),(2620022,'1','202','1036',477,'Retail Sale Id 6973',2702.48,0.00,0.00,4.07,333.74,'2022-04-30 08:21:50','',''),(2620023,'1','202','1036',477,'Retail Sale Id 6974',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 08:23:14','',''),(2620024,'1','202','1036',477,'Retail Sale Id 6975',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 08:26:12','',''),(2620025,'1','202','1036',477,'Retail Sale Id 6976',61594.00,0.00,0.00,103.00,1648.00,'2022-04-30 09:53:54','',''),(2620026,'1','202','1036',477,'Retail Sale Id 6977',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 10:02:42','',''),(2620027,'1','202','1036',477,'Retail Sale Id 6978',796.80,0.00,0.00,1.20,98.40,'2022-04-30 10:03:37','',''),(2620028,'1','202','1036',477,'Retail Sale Id 6979',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 10:04:15','',''),(2620029,'1','202','1036',477,'Retail Sale Id 6980',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:04:57','',''),(2620030,'1','202','1036',477,'Retail Sale Id 6981',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 10:06:12','',''),(2620031,'1','202','1036',477,'Retail Sale Id 6982',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 10:06:57','',''),(2620032,'1','202','1036',477,'Retail Sale Id 6983',1201.84,0.00,0.00,1.81,148.42,'2022-04-30 10:07:40','',''),(2620033,'1','202','1036',477,'Retail Sale Id 6984',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 10:08:26','',''),(2620034,'1','202','1036',477,'Retail Sale Id 6985',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 10:09:18','',''),(2620035,'1','202','1036',477,'Retail Sale Id 6986',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 10:10:09','',''),(2620036,'1','202','1036',477,'Retail Sale Id 6987',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:10:50','',''),(2620037,'1','202','1036',477,'Retail Sale Id 6988',29900.00,0.00,0.00,50.00,800.00,'2022-04-30 10:11:42','',''),(2620038,'1','202','1036',477,'Retail Sale Id 6989',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 10:13:30','',''),(2620039,'1','202','1036',477,'Retail Sale Id 6990',2503.28,0.00,0.00,3.77,309.14,'2022-04-30 10:14:36','',''),(2620040,'1','202','1036',477,'Retail Sale Id 6991',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:15:09','',''),(2620041,'1','202','1036',477,'Retail Sale Id 6992',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 10:15:37','',''),(2620042,'1','202','1036',477,'Retail Sale Id 6993',2197.84,0.00,0.00,3.31,271.42,'2022-04-30 10:16:20','',''),(2620043,'1','202','1036',477,'Retail Sale Id 6994',4999.92,0.00,0.00,7.53,617.46,'2022-04-30 10:17:16','',''),(2620044,'1','202','1036',477,'Retail Sale Id 6995',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 10:18:09','',''),(2620045,'1','202','1036',477,'Retail Sale Id 6996',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 10:19:04','',''),(2620046,'1','202','1036',477,'Retail Sale Id 6997',35880.00,0.00,0.00,60.00,960.00,'2022-04-30 10:20:28','',''),(2620047,'1','202','1036',477,'Retail Sale Id 6998',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 10:21:47','',''),(2620048,'1','202','1036',477,'Retail Sale Id 6999',697.20,0.00,0.00,1.05,86.10,'2022-04-30 10:22:35','',''),(2620049,'1','202','1036',477,'Retail Sale Id 7000',6002.56,0.00,0.00,9.04,741.28,'2022-04-30 10:23:23','',''),(2620050,'1','202','1036',477,'Retail Sale Id 7001',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 10:24:04','',''),(2620051,'1','202','1036',477,'Retail Sale Id 7002',498.00,0.00,0.00,0.75,61.50,'2022-04-30 10:24:56','',''),(2620052,'1','202','1036',477,'Retail Sale Id 7003',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 10:25:42','',''),(2620053,'1','202','1036',477,'Retail Sale Id 7004',1699.84,0.00,0.00,2.56,209.92,'2022-04-30 10:26:59','',''),(2620054,'1','202','1036',477,'Retail Sale Id 7005',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 10:27:39','',''),(2620055,'1','202','1036',477,'Retail Sale Id 7006',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 10:28:52','',''),(2620056,'1','202','1036',477,'Retail Sale Id 7007',6653.28,0.00,0.00,10.02,821.64,'2022-04-30 10:29:51','',''),(2620057,'1','202','1036',477,'Retail Sale Id 7008',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 10:31:06','',''),(2620058,'1','202','1036',477,'Retail Sale Id 7009',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:32:00','',''),(2620059,'1','202','1036',477,'Retail Sale Id 7010',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 10:32:32','',''),(2620060,'1','202','1036',477,'Retail Sale Id 7011',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 10:33:34','',''),(2620061,'1','202','1036',477,'Retail Sale Id 7012',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 10:34:30','',''),(2620062,'1','202','1036',477,'Retail Sale Id 7013',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:35:06','',''),(2620063,'1','202','1036',477,'Retail Sale Id 7014',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 10:35:46','',''),(2620064,'1','202','1036',477,'Retail Sale Id 7015',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 10:36:38','',''),(2620065,'1','202','1036',477,'Retail Sale Id 7016',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 10:37:19','',''),(2620066,'1','202','1036',477,'Retail Sale Id 7017',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 10:38:06','',''),(2620067,'1','202','1036',477,'Retail Sale Id 7018',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:39:06','',''),(2620068,'1','202','1036',477,'Retail Sale Id 7019',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 10:40:04','',''),(2620069,'1','202','1036',477,'Retail Sale Id 7020',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 10:41:37','',''),(2620070,'1','202','1036',477,'Retail Sale Id 7021',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 10:43:00','',''),(2620071,'1','202','1036',477,'Retail Sale Id 7022',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 10:43:42','',''),(2620072,'1','202','1036',477,'Retail Sale Id 7023',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 10:44:28','',''),(2620073,'1','202','1036',477,'Retail Sale Id 7024',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 10:45:35','',''),(2620074,'1','202','1036',477,'Retail Sale Id 7025',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:46:13','',''),(2620075,'1','202','1036',477,'Retail Sale Id 7026',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 10:47:03','',''),(2620076,'1','202','1036',477,'Retail Sale Id 7027',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:47:59','',''),(2620077,'1','202','1036',477,'Retail Sale Id 7028',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 10:48:36','',''),(2620078,'1','202','1036',477,'Retail Sale Id 7029',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:49:22','',''),(2620079,'1','202','1036',477,'Retail Sale Id 7030',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 10:50:23','',''),(2620080,'1','202','1036',477,'Retail Sale Id 7031',697.20,0.00,0.00,1.05,86.10,'2022-04-30 10:51:29','',''),(2620081,'1','202','1036',477,'Retail Sale Id 7032',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:52:11','',''),(2620082,'1','202','1036',477,'Retail Sale Id 7033',697.20,0.00,0.00,1.05,86.10,'2022-04-30 10:52:52','',''),(2620083,'1','202','1036',477,'Retail Sale Id 7034',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:54:21','',''),(2620084,'1','202','1036',477,'Retail Sale Id 7035',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 10:55:18','',''),(2620085,'1','202','1036',477,'Retail Sale Id 7036',1401.04,0.00,0.00,2.11,173.02,'2022-04-30 10:56:08','',''),(2620086,'1','202','1036',477,'Retail Sale Id 7037',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 10:56:56','',''),(2620087,'1','202','1036',477,'Retail Sale Id 7038',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 10:58:10','',''),(2620088,'1','202','1036',477,'Retail Sale Id 7039',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 10:58:54','',''),(2620089,'1','202','1036',477,'Retail Sale Id 7040',10465.00,0.00,0.00,17.50,280.00,'2022-04-30 11:00:59','',''),(2620090,'1','202','1036',477,'Retail Sale Id 7041',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 11:02:19','',''),(2620091,'1','202','1036',477,'Retail Sale Id 7043',3399.68,0.00,0.00,5.12,419.84,'2022-04-30 11:03:22','',''),(2620092,'1','202','1036',477,'Retail Sale Id 7044',1347.92,0.00,0.00,2.03,166.46,'2022-04-30 11:04:34','',''),(2620093,'1','202','1036',477,'Retail Sale Id 7045',697.20,0.00,0.00,1.05,86.10,'2022-04-30 11:09:25','',''),(2620094,'1','202','1036',477,'Retail Sale Id 7046',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 11:11:46','',''),(2620095,'1','202','1036',477,'Retail Sale Id 7047',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 11:12:48','',''),(2620096,'1','202','1036',477,'Retail Sale Id 7048',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 11:16:40','',''),(2620097,'1','202','1036',477,'Retail Sale Id 7049',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 11:17:43','',''),(2620098,'1','202','1036',477,'Retail Sale Id 7050',2702.48,0.00,0.00,4.07,333.74,'2022-04-30 11:19:04','',''),(2620099,'1','202','1036',477,'Retail Sale Id 7051',4648.00,0.00,0.00,7.00,574.00,'2022-04-30 11:21:18','',''),(2620100,'1','202','1036',477,'Retail Sale Id 7053',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 11:22:31','',''),(2620101,'1','202','1036',477,'Retail Sale Id 7054',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 11:24:42','',''),(2620102,'1','202','1036',477,'Retail Sale Id 7055',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 11:26:09','',''),(2620103,'1','202','1036',477,'Retail Sale Id 7056',498.00,0.00,0.00,0.75,61.50,'2022-04-30 11:27:01','',''),(2620104,'1','202','1036',477,'Retail Sale Id 7057',1347.92,0.00,0.00,2.03,166.46,'2022-04-30 11:28:14','',''),(2620105,'1','202','1036',477,'Retail Sale Id 7058',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 11:28:57','',''),(2620106,'1','202','1036',477,'Retail Sale Id 7059',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 11:30:54','',''),(2620107,'1','202','1036',477,'Retail Sale Id 7060',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 11:31:59','',''),(2620108,'1','202','1036',477,'Retail Sale Id 7061',7475.00,0.00,0.00,12.50,200.00,'2022-04-30 11:33:30','',''),(2620109,'1','202','1036',477,'Retail Sale Id 7062',1201.84,0.00,0.00,1.81,148.42,'2022-04-30 11:34:44','',''),(2620110,'1','202','1036',477,'Retail Sale Id 7063',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 11:35:32','',''),(2620111,'1','202','1036',477,'Retail Sale Id 7064',5398.32,0.00,0.00,8.13,666.66,'2022-04-30 11:37:20','',''),(2620112,'1','202','1036',477,'Retail Sale Id 7065',498.00,0.00,0.00,0.75,61.50,'2022-04-30 11:38:12','',''),(2620113,'1','202','1036',477,'Retail Sale Id 7066',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 11:39:07','',''),(2620114,'1','202','1036',477,'Retail Sale Id 7067',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 11:39:59','',''),(2620115,'1','202','1036',477,'Retail Sale Id 7068',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 11:40:31','',''),(2620116,'1','202','1036',477,'Retail Sale Id 7069',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 11:41:08','',''),(2620117,'1','202','1036',477,'Retail Sale Id 7070',697.20,0.00,0.00,1.05,86.10,'2022-04-30 11:42:04','',''),(2620118,'1','202','1036',477,'Retail Sale Id 7071',498.00,0.00,0.00,0.75,61.50,'2022-04-30 11:46:13','',''),(2620119,'1','202','1036',477,'Retail Sale Id 7072',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 11:48:13','',''),(2620120,'1','202','1036',477,'Retail Sale Id 7073',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 11:50:05','',''),(2620121,'1','202','1036',477,'Retail Sale Id 7074',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 11:51:21','',''),(2620122,'1','202','1036',477,'Retail Sale Id 7075',498.00,0.00,0.00,0.75,61.50,'2022-04-30 11:51:58','',''),(2620123,'1','202','1036',477,'Retail Sale Id 7076',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 11:52:38','',''),(2620124,'1','202','1036',477,'Retail Sale Id 7077',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 11:53:28','',''),(2620125,'1','202','1036',477,'Retail Sale Id 7078',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 11:54:12','',''),(2620126,'1','202','1036',477,'Retail Sale Id 7079',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 11:56:10','',''),(2620127,'1','202','1036',477,'Retail Sale Id 7080',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 11:57:00','',''),(2620128,'1','202','1036',477,'Retail Sale Id 7081',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 11:57:59','',''),(2620129,'1','202','1036',477,'Retail Sale Id 7082',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 11:59:12','',''),(2620130,'1','202','1036',477,'Retail Sale Id 7083',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 11:59:53','',''),(2620131,'1','202','1036',477,'Retail Sale Id 7084',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 12:00:34','',''),(2620132,'1','202','1036',477,'Retail Sale Id 7085',498.00,0.00,0.00,0.75,61.50,'2022-04-30 12:03:23','',''),(2620133,'1','202','1036',477,'Retail Sale Id 7086',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 12:05:35','',''),(2620134,'1','202','1036',477,'Retail Sale Id 7087',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 12:08:38','',''),(2620135,'1','202','1036',477,'Retail Sale Id 7088',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 12:10:08','',''),(2620136,'1','202','1036',477,'Retail Sale Id 7089',35880.00,0.00,0.00,60.00,960.00,'2022-04-30 12:12:06','',''),(2620137,'1','202','1036',477,'Retail Sale Id 7090',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 12:13:26','',''),(2620138,'1','202','1036',477,'Retail Sale Id 7091',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 12:13:56','',''),(2620139,'1','202','1036',477,'Retail Sale Id 7092',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 12:14:45','',''),(2620140,'1','202','1036',477,'Retail Sale Id 7093',2503.28,0.00,0.00,3.77,309.14,'2022-04-30 12:15:34','',''),(2620141,'1','202','1036',477,'Retail Sale Id 7094',1347.92,0.00,0.00,2.03,166.46,'2022-04-30 12:16:40','',''),(2620142,'1','202','1036',477,'Retail Sale Id 7095',1347.92,0.00,0.00,2.03,166.46,'2022-04-30 12:19:04','',''),(2620143,'1','202','1036',477,'Retail Sale Id 7096',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 12:20:00','',''),(2620144,'1','202','1036',477,'Retail Sale Id 7097',4999.92,0.00,0.00,7.53,617.46,'2022-04-30 12:20:58','',''),(2620145,'1','202','1036',477,'Retail Sale Id 7098',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 12:21:59','',''),(2620146,'1','202','1036',477,'Retail Sale Id 7099',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 12:22:40','',''),(2620147,'1','202','1036',477,'Retail Sale Id 7100',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 12:26:39','',''),(2620148,'1','202','1036',477,'Retail Sale Id 7101',6002.56,0.00,0.00,9.04,741.28,'2022-04-30 12:27:29','',''),(2620149,'1','202','1036',477,'Retail Sale Id 7102',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 12:28:19','',''),(2620150,'1','202','1036',477,'Retail Sale Id 7103',697.20,0.00,0.00,1.05,86.10,'2022-04-30 12:29:30','',''),(2620151,'1','202','1036',477,'Retail Sale Id 7104',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 12:32:23','',''),(2620152,'1','202','1036',477,'Retail Sale Id 7105',4999.92,0.00,0.00,7.53,617.46,'2022-04-30 12:33:50','',''),(2620153,'1','202','1036',477,'Retail Sale Id 7106',4648.00,0.00,0.00,7.00,574.00,'2022-04-30 12:35:05','',''),(2620154,'1','202','1036',477,'Retail Sale Id 7107',71760.00,0.00,0.00,120.00,1920.00,'2022-04-30 12:39:06','',''),(2620155,'1','202','1036',477,'Retail Sale Id 7108',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 12:40:56','',''),(2620156,'1','202','1036',477,'Retail Sale Id 7109',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 12:42:04','',''),(2620157,'1','202','1036',477,'Retail Sale Id 7110',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 12:43:37','',''),(2620158,'1','202','1036',477,'Retail Sale Id 7111',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 12:45:57','',''),(2620159,'1','202','1036',477,'Retail Sale Id 7112',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 12:47:40','',''),(2620160,'1','202','1036',477,'Retail Sale Id 7113',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 12:52:47','',''),(2620161,'1','202','1036',477,'Retail Sale Id 7114',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 12:53:26','',''),(2620162,'1','202','1036',477,'Retail Sale Id 7115',198835.00,0.00,0.00,332.50,5320.00,'2022-04-30 13:00:13','',''),(2620163,'1','202','1036',477,'Retail Sale Id 7116',7304.00,0.00,0.00,11.00,902.00,'2022-04-30 13:05:24','',''),(2620164,'1','202','1036',477,'Retail Sale Id 7117',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 13:06:11','',''),(2620165,'1','202','1036',477,'Retail Sale Id 7118',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 13:08:24','',''),(2620166,'1','202','1036',477,'Retail Sale Id 7119',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 13:09:12','',''),(2620167,'1','202','1036',477,'Retail Sale Id 7120',29900.00,0.00,0.00,50.00,800.00,'2022-04-30 13:11:40','',''),(2620168,'1','202','1036',477,'Retail Sale Id 7121',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 13:12:22','',''),(2620169,'1','202','1036',477,'Retail Sale Id 7122',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 13:15:21','',''),(2620170,'1','202','1036',477,'Retail Sale Id 7123',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 13:17:08','',''),(2620171,'1','202','1036',477,'Retail Sale Id 7124',4150.00,0.00,0.00,6.25,512.50,'2022-04-30 13:18:31','',''),(2620172,'1','202','1036',477,'Retail Sale Id 7125',60398.00,0.00,0.00,101.00,1616.00,'2022-04-30 13:20:08','',''),(2620173,'1','202','1036',477,'Retail Sale Id 7126',1347.92,0.00,0.00,2.03,166.46,'2022-04-30 13:20:50','',''),(2620174,'1','202','1036',477,'Retail Sale Id 7127',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 13:21:35','',''),(2620175,'1','202','1036',477,'Retail Sale Id 7127',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 13:21:35','',''),(2620176,'1','202','1036',477,'Retail Sale Id 7128',7304.00,0.00,0.00,11.00,902.00,'2022-04-30 13:22:41','',''),(2620177,'1','202','1036',477,'Retail Sale Id 7129',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 13:24:14','',''),(2620178,'1','202','1036',477,'Retail Sale Id 7130',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 13:25:29','',''),(2620179,'1','202','1036',477,'Retail Sale Id 7131',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 13:26:05','',''),(2620180,'1','202','1036',477,'Retail Sale Id 7132',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 13:26:49','',''),(2620181,'1','202','1036',477,'Retail Sale Id 7133',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 13:27:41','',''),(2620182,'1','202','1036',477,'Retail Sale Id 7134',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 13:29:49','',''),(2620183,'1','202','1036',477,'Retail Sale Id 7134',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 13:29:49','',''),(2620184,'1','202','1036',477,'Retail Sale Id 7135',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 13:30:46','',''),(2620185,'1','202','1036',477,'Retail Sale Id 7136',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 13:32:00','',''),(2620186,'1','202','1036',477,'Retail Sale Id 7137',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 13:32:58','',''),(2620187,'1','202','1036',477,'Retail Sale Id 7138',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 13:33:38','',''),(2620188,'1','202','1036',477,'Retail Sale Id 7139',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 13:34:27','',''),(2620189,'1','202','1036',477,'Retail Sale Id 7139',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 13:34:27','',''),(2620190,'1','202','1036',477,'Retail Sale Id 7140',1899.04,0.00,0.00,2.86,234.52,'2022-04-30 13:38:29','',''),(2620191,'1','202','1036',477,'Retail Sale Id 7141',4999.92,0.00,0.00,7.53,617.46,'2022-04-30 13:39:58','',''),(2620192,'1','202','1036',477,'Retail Sale Id 7143',3300.08,0.00,0.00,4.97,407.54,'2022-04-30 13:47:31','',''),(2620193,'1','202','1036',477,'Retail Sale Id 7144',3399.68,0.00,0.00,5.12,419.84,'2022-04-30 13:48:17','',''),(2620194,'1','202','1036',477,'Retail Sale Id 7142',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 13:49:12','',''),(2620195,'1','202','1036',477,'Retail Sale Id 7145',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 13:50:05','',''),(2620196,'1','202','1036',477,'Retail Sale Id 7146',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 13:51:38','',''),(2620197,'1','202','1036',477,'Retail Sale Id 7147',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 13:52:08','',''),(2620198,'1','202','1036',477,'Retail Sale Id 7148',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 13:53:39','',''),(2620199,'1','202','1036',477,'Retail Sale Id 7151',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 13:56:26','',''),(2620200,'1','202','1036',477,'Retail Sale Id 7152',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 13:57:21','',''),(2620201,'1','202','1036',477,'Retail Sale Id 7153',32997.64,0.00,0.00,55.18,882.88,'2022-04-30 13:58:56','',''),(2620202,'1','202','1036',477,'Retail Sale Id 7154',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 14:04:26','',''),(2620203,'1','202','1036',477,'Retail Sale Id 7155',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 14:05:02','',''),(2620204,'1','202','1036',477,'Retail Sale Id 7156',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 14:08:06','',''),(2620205,'1','202','1036',477,'Retail Sale Id 7157',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 14:09:14','',''),(2620206,'1','202','1036',477,'Retail Sale Id 7158',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 14:10:24','',''),(2620207,'1','202','1036',477,'Retail Sale Id 7159',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 14:14:46','',''),(2620208,'1','202','1036',477,'Retail Sale Id 7160',2503.28,0.00,0.00,3.77,309.14,'2022-04-30 14:20:06','',''),(2620209,'1','202','1036',477,'Retail Sale Id 7161',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 14:21:05','',''),(2620210,'1','202','1036',477,'Retail Sale Id 7162',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 14:23:49','',''),(2620211,'1','202','1036',477,'Retail Sale Id 7163',2503.28,0.00,0.00,3.77,309.14,'2022-04-30 14:28:43','',''),(2620212,'1','202','1036',477,'Retail Sale Id 7164',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 14:33:41','',''),(2620213,'1','202','1036',477,'Retail Sale Id 7165',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 14:34:39','',''),(2620214,'1','202','1036',477,'Retail Sale Id 7166',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 14:41:22','',''),(2620215,'1','202','1036',477,'Retail Sale Id 7167',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 14:49:26','',''),(2620216,'1','202','1036',477,'Retail Sale Id 7168',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 14:55:38','',''),(2620217,'1','202','1036',477,'Retail Sale Id 7169',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 14:56:16','',''),(2620218,'1','202','1036',477,'Retail Sale Id 7170',1201.84,0.00,0.00,1.81,148.42,'2022-04-30 14:57:13','',''),(2620219,'1','202','1036',477,'Retail Sale Id 7171',25002.38,0.00,0.00,41.81,668.96,'2022-04-30 14:58:38','',''),(2620220,'1','202','1036',477,'Retail Sale Id 7172',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 14:59:30','',''),(2620221,'1','202','1036',477,'Retail Sale Id 7173',2503.28,0.00,0.00,3.77,309.14,'2022-04-30 15:00:42','',''),(2620222,'1','202','1036',477,'Retail Sale Id 7174',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 15:01:39','',''),(2620223,'1','202','1036',477,'Retail Sale Id 7175',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 15:04:17','',''),(2620224,'1','202','1036',477,'Retail Sale Id 7176',2503.28,0.00,0.00,3.77,309.14,'2022-04-30 15:05:20','',''),(2620225,'1','202','1036',477,'Retail Sale Id 7177',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 15:05:54','',''),(2620226,'1','202','1036',477,'Retail Sale Id 7178',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 15:06:36','',''),(2620227,'1','202','1036',477,'Retail Sale Id 7179',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 15:07:28','',''),(2620228,'1','202','1036',477,'Retail Sale Id 7180',5398.32,0.00,0.00,8.13,666.66,'2022-04-30 15:08:54','',''),(2620229,'1','202','1036',477,'Retail Sale Id 7181',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 15:10:18','',''),(2620230,'1','202','1036',477,'Retail Sale Id 7182',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 15:12:58','',''),(2620231,'1','202','1036',477,'Retail Sale Id 7182',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 15:12:58','',''),(2620232,'1','202','1036',477,'Retail Sale Id 7183',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 15:14:43','',''),(2620233,'1','202','1036',477,'Retail Sale Id 7184',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 15:15:37','',''),(2620234,'1','202','1036',477,'Retail Sale Id 7185',2197.84,0.00,0.00,3.31,271.42,'2022-04-30 15:16:35','',''),(2620235,'1','202','1036',477,'Retail Sale Id 7186',1347.92,0.00,0.00,2.03,166.46,'2022-04-30 15:18:18','',''),(2620236,'1','202','1036',477,'Retail Sale Id 7187',5796.72,0.00,0.00,8.73,715.86,'2022-04-30 15:19:45','',''),(2620237,'1','202','1036',477,'Retail Sale Id 7188',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 15:21:13','',''),(2620238,'1','202','1036',477,'Retail Sale Id 7189',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 15:22:14','',''),(2620239,'1','202','1036',477,'Retail Sale Id 7190',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 15:25:27','',''),(2620240,'1','202','1036',477,'Retail Sale Id 7191',1899.04,0.00,0.00,2.86,234.52,'2022-04-30 15:28:44','',''),(2620241,'1','202','1036',477,'Retail Sale Id 7192',697.20,0.00,0.00,1.05,86.10,'2022-04-30 15:29:48','',''),(2620242,'1','202','1036',477,'Retail Sale Id 7193',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 15:31:35','',''),(2620243,'1','202','1036',477,'Retail Sale Id 7194',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 15:33:06','',''),(2620244,'1','202','1036',477,'Retail Sale Id 7195',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 15:34:12','',''),(2620245,'1','202','1036',477,'Retail Sale Id 7196',7802.00,0.00,0.00,11.75,963.50,'2022-04-30 15:40:17','',''),(2620246,'1','202','1036',477,'Retail Sale Id 7197',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 15:42:39','',''),(2620247,'1','202','1036',477,'Retail Sale Id 7198',796.80,0.00,0.00,1.20,98.40,'2022-04-30 15:46:07','',''),(2620248,'1','202','1036',477,'Retail Sale Id 7199',4501.92,0.00,0.00,6.78,555.96,'2022-04-30 15:47:28','',''),(2620249,'1','202','1036',477,'Retail Sale Id 7200',6998.56,0.00,0.00,10.54,864.28,'2022-04-30 15:49:10','',''),(2620250,'1','202','1036',477,'Retail Sale Id 7202',23920.00,0.00,0.00,40.00,640.00,'2022-04-30 15:55:52','',''),(2620251,'1','202','1036',477,'Retail Sale Id 7203',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 15:59:58','',''),(2620252,'1','202','1036',477,'Retail Sale Id 7204',3499.28,0.00,0.00,5.27,432.14,'2022-04-30 16:02:03','',''),(2620253,'1','202','1036',477,'Retail Sale Id 7205',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 16:04:27','',''),(2620254,'1','202','1036',477,'Retail Sale Id 7206',6500.56,0.00,0.00,9.79,802.78,'2022-04-30 16:08:12','',''),(2620255,'1','202','1036',477,'Retail Sale Id 7207',29900.00,0.00,0.00,50.00,800.00,'2022-04-30 16:10:52','',''),(2620256,'1','202','1036',477,'Retail Sale Id 7208',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 16:13:03','',''),(2620257,'1','202','1036',477,'Retail Sale Id 7209',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 16:17:05','',''),(2620258,'1','202','1036',477,'Retail Sale Id 7210',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 16:19:12','',''),(2620259,'1','202','1036',477,'Retail Sale Id 7211',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 16:21:34','',''),(2620260,'1','202','1036',477,'Retail Sale Id 7212',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 16:22:59','',''),(2620261,'1','202','1036',477,'Retail Sale Id 7213',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 16:24:37','',''),(2620262,'1','202','1036',477,'Retail Sale Id 7214',2197.84,0.00,0.00,3.31,271.42,'2022-04-30 16:29:31','',''),(2620263,'1','202','1036',477,'Retail Sale Id 7215',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 16:31:00','',''),(2620264,'1','202','1036',477,'Retail Sale Id 7216',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 16:31:53','',''),(2620265,'1','202','1036',477,'Retail Sale Id 7217',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 16:33:10','',''),(2620266,'1','202','1036',477,'Retail Sale Id 7218',1201.84,0.00,0.00,1.81,148.42,'2022-04-30 16:34:44','',''),(2620267,'1','202','1036',477,'Retail Sale Id 7219',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 16:35:54','',''),(2620268,'1','202','1036',477,'Retail Sale Id 7220',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 16:36:59','',''),(2620269,'1','202','1036',477,'Retail Sale Id 7221',2503.28,0.00,0.00,3.77,309.14,'2022-04-30 16:38:52','',''),(2620270,'1','202','1036',477,'Retail Sale Id 7223',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 16:41:03','',''),(2620271,'1','202','1036',477,'Retail Sale Id 7224',6002.56,0.00,0.00,9.04,741.28,'2022-04-30 16:41:43','',''),(2620272,'1','202','1036',477,'Retail Sale Id 7225',3499.28,0.00,0.00,5.27,432.14,'2022-04-30 16:43:25','',''),(2620273,'1','202','1036',477,'Retail Sale Id 7226',2503.28,0.00,0.00,3.77,309.14,'2022-04-30 16:44:24','',''),(2620274,'1','202','1036',477,'Retail Sale Id 7227',597.60,0.00,0.00,0.90,73.80,'2022-04-30 16:45:14','',''),(2620275,'1','202','1036',477,'Retail Sale Id 7228',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 16:45:59','',''),(2620276,'1','202','1036',477,'Retail Sale Id 7229',1347.92,0.00,0.00,2.03,166.46,'2022-04-30 16:47:01','',''),(2620277,'1','202','1036',477,'Retail Sale Id 7230',697.20,0.00,0.00,1.05,86.10,'2022-04-30 16:48:55','',''),(2620278,'1','202','1036',477,'Retail Sale Id 7231',34684.00,0.00,0.00,58.00,928.00,'2022-04-30 16:51:11','',''),(2620279,'1','202','1036',477,'Retail Sale Id 7232',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 16:52:42','',''),(2620280,'1','202','1036',477,'Retail Sale Id 7233',1899.04,0.00,0.00,2.86,234.52,'2022-04-30 16:53:33','',''),(2620281,'1','202','1036',477,'Retail Sale Id 7234',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 16:54:03','',''),(2620282,'1','202','1036',477,'Retail Sale Id 7235',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 16:54:41','',''),(2620283,'1','202','1036',477,'Retail Sale Id 7236',4999.92,0.00,0.00,7.53,617.46,'2022-04-30 16:55:26','',''),(2620284,'1','202','1036',477,'Retail Sale Id 7237',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 16:56:42','',''),(2620285,'1','202','1036',477,'Retail Sale Id 7238',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 16:57:32','',''),(2620286,'1','202','1036',477,'Retail Sale Id 7239',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 16:58:37','',''),(2620287,'1','202','1036',477,'Retail Sale Id 7240',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 16:59:56','',''),(2620288,'1','202','1036',477,'Retail Sale Id 7241',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 17:02:14','',''),(2620289,'1','202','1036',477,'Retail Sale Id 7242',498.00,0.00,0.00,0.75,61.50,'2022-04-30 17:03:22','',''),(2620290,'1','202','1036',477,'Retail Sale Id 7244',6653.28,0.00,0.00,10.02,821.64,'2022-04-30 17:14:04','',''),(2620291,'1','202','1036',477,'Retail Sale Id 7245',2702.48,0.00,0.00,4.07,333.74,'2022-04-30 17:15:56','',''),(2620292,'1','202','1036',477,'Retail Sale Id 7246',2503.28,0.00,0.00,3.77,309.14,'2022-04-30 17:18:43','',''),(2620293,'1','202','1036',477,'Retail Sale Id 7247',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 17:19:27','',''),(2620294,'1','202','1036',477,'Retail Sale Id 7248',3399.68,0.00,0.00,5.12,419.84,'2022-04-30 17:20:51','',''),(2620295,'1','202','1036',477,'Retail Sale Id 7249',697.20,0.00,0.00,1.05,86.10,'2022-04-30 17:23:17','',''),(2620296,'1','202','1036',477,'Retail Sale Id 7250',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 17:25:39','',''),(2620297,'1','202','1036',477,'Retail Sale Id 7251',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 17:32:44','',''),(2620298,'1','202','1036',477,'Retail Sale Id 7252',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 17:33:28','',''),(2620299,'1','202','1036',477,'Retail Sale Id 7253',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 17:36:56','',''),(2620300,'1','202','1036',477,'Retail Sale Id 7254',29900.00,0.00,0.00,50.00,800.00,'2022-04-30 17:39:02','',''),(2620301,'1','202','1036',477,'Retail Sale Id 7255',6653.28,0.00,0.00,10.02,821.64,'2022-04-30 17:40:40','',''),(2620302,'1','202','1036',477,'Retail Sale Id 7257',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 17:41:23','',''),(2620303,'1','202','1036',477,'Retail Sale Id 7259',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 17:42:03','',''),(2620304,'1','202','1036',477,'Retail Sale Id 7260',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 17:44:02','',''),(2620305,'1','202','1036',477,'Retail Sale Id 7261',3353.20,0.00,0.00,5.05,414.10,'2022-04-30 17:45:35','',''),(2620306,'1','202','1036',477,'Retail Sale Id 7262',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 17:46:29','',''),(2620307,'1','202','1036',477,'Retail Sale Id 7263',35880.00,0.00,0.00,60.00,960.00,'2022-04-30 17:49:39','',''),(2620308,'1','202','1036',477,'Retail Sale Id 7264',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 17:50:46','',''),(2620309,'1','202','1036',477,'Retail Sale Id 7265',796.80,0.00,0.00,1.20,98.40,'2022-04-30 17:52:06','',''),(2620310,'1','202','1036',477,'Retail Sale Id 7266',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 17:53:25','',''),(2620311,'1','202','1036',477,'Retail Sale Id 7267',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 17:54:20','',''),(2620312,'1','202','1036',477,'Retail Sale Id 7268',1347.92,0.00,0.00,2.03,166.46,'2022-04-30 17:55:35','',''),(2620313,'1','202','1036',477,'Retail Sale Id 7269',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 17:56:53','',''),(2620314,'1','202','1036',477,'Retail Sale Id 7270',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 17:57:51','',''),(2620315,'1','202','1036',477,'Retail Sale Id 7271',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 18:01:15','',''),(2620316,'1','202','1036',477,'Retail Sale Id 7272',2503.28,0.00,0.00,3.77,309.14,'2022-04-30 18:02:39','',''),(2620317,'1','202','1036',477,'Retail Sale Id 7273',1699.84,0.00,0.00,2.56,209.92,'2022-04-30 18:04:12','',''),(2620318,'1','202','1036',477,'Retail Sale Id 7274',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 18:06:53','',''),(2620319,'1','202','1036',477,'Retail Sale Id 7275',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 18:07:27','',''),(2620320,'1','202','1036',477,'Retail Sale Id 7276',697.20,0.00,0.00,1.05,86.10,'2022-04-30 18:08:17','',''),(2620321,'1','202','1036',477,'Retail Sale Id 7277',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 18:09:10','',''),(2620322,'1','202','1036',477,'Retail Sale Id 7278',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 18:09:50','',''),(2620323,'1','202','1036',477,'Retail Sale Id 7279',1347.92,0.00,0.00,2.03,166.46,'2022-04-30 18:10:37','',''),(2620324,'1','202','1036',477,'Retail Sale Id 7280',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 18:11:33','',''),(2620325,'1','202','1036',477,'Retail Sale Id 7281',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 18:12:45','',''),(2620326,'1','202','1036',477,'Retail Sale Id 7282',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 18:13:27','',''),(2620327,'1','202','1036',477,'Retail Sale Id 7283',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 18:15:00','',''),(2620328,'1','202','1036',477,'Retail Sale Id 7284',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 18:16:04','',''),(2620329,'1','202','1036',477,'Retail Sale Id 7285',4501.92,0.00,0.00,6.78,555.96,'2022-04-30 18:19:11','',''),(2620330,'1','202','1036',477,'Retail Sale Id 7286',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 18:20:05','',''),(2620331,'1','202','1036',477,'Retail Sale Id 7287',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 18:26:00','',''),(2620332,'1','202','1036',477,'Retail Sale Id 7288',6998.56,0.00,0.00,10.54,864.28,'2022-04-30 18:27:47','',''),(2620333,'1','202','1036',477,'Retail Sale Id 7289',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 18:29:35','',''),(2620334,'1','202','1036',477,'Retail Sale Id 7290',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 18:30:19','',''),(2620335,'1','202','1036',477,'Retail Sale Id 7291',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 18:31:06','',''),(2620336,'1','202','1036',477,'Retail Sale Id 7292',8300.00,0.00,0.00,12.50,1025.00,'2022-04-30 18:32:12','',''),(2620337,'1','202','1036',477,'Retail Sale Id 7293',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 18:32:54','',''),(2620338,'1','202','1036',477,'Retail Sale Id 7294',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 18:33:35','',''),(2620339,'1','202','1036',477,'Retail Sale Id 7295',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 18:34:19','',''),(2620340,'1','202','1036',477,'Retail Sale Id 7296',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 18:37:05','',''),(2620341,'1','202','1036',477,'Retail Sale Id 7297',4501.92,0.00,0.00,6.78,555.96,'2022-04-30 18:40:23','',''),(2620342,'1','202','1036',477,'Retail Sale Id 7298',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 18:41:14','',''),(2620343,'1','202','1036',477,'Retail Sale Id 7299',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 18:42:08','',''),(2620344,'1','202','1036',477,'Retail Sale Id 7300',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 18:42:52','',''),(2620345,'1','202','1036',477,'Retail Sale Id 7301',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 18:43:31','',''),(2620346,'1','202','1036',477,'Retail Sale Id 7302',1998.64,0.00,0.00,3.01,246.82,'2022-04-30 18:44:18','',''),(2620347,'1','202','1036',477,'Retail Sale Id 7303',1500.64,0.00,0.00,2.26,185.32,'2022-04-30 18:45:46','',''),(2620348,'1','202','1036',477,'Retail Sale Id 7304',1799.44,0.00,0.00,2.71,222.22,'2022-04-30 18:48:05','',''),(2620349,'1','202','1036',477,'Retail Sale Id 7305',1002.64,0.00,0.00,1.51,123.82,'2022-04-30 18:50:53','',''),(2620350,'1','202','1036',477,'Retail Sale Id 7306',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 18:51:41','',''),(2620351,'1','202','1036',477,'Retail Sale Id 7307',3001.28,0.00,0.00,4.52,370.64,'2022-04-30 19:01:06','',''),(2620352,'1','202','1036',477,'Retail Sale Id 7308',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 19:01:59','',''),(2620353,'1','202','1036',477,'Retail Sale Id 7309',3997.28,0.00,0.00,6.02,493.64,'2022-04-30 19:07:01','',''),(2620354,'1','202','1036',477,'Retail Sale Id 7310',3499.28,0.00,0.00,5.27,432.14,'2022-04-30 19:12:07','',''),(2620355,'1','202','1036',477,'Retail Sale Id 7311',5756.88,0.00,0.00,8.67,710.94,'2022-04-30 19:36:36','',''),(2620356,'1','202','1036',477,'Retail Sale Id 7312',298.80,0.00,0.00,0.45,36.90,'2022-04-30 19:39:14','',''),(2620357,'1','202','1036',477,'Retail Sale Id 7313',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 06:36:16','',''),(2620358,'1','202','1036',477,'Retail Sale Id 7314',4999.92,0.00,0.00,7.53,617.46,'2022-05-01 06:37:00','',''),(2620359,'1','202','1036',477,'Retail Sale Id 7315',2503.28,0.00,0.00,3.77,309.14,'2022-05-01 06:38:47','',''),(2620360,'1','202','1036',477,'Retail Sale Id 7316',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 06:40:21','',''),(2620361,'1','202','1036',477,'Retail Sale Id 7317',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 06:55:24','',''),(2620362,'1','202','1036',477,'Retail Sale Id 7318',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 06:56:18','',''),(2620363,'1','202','1036',477,'Retail Sale Id 7319',276874.00,0.00,0.00,463.00,7408.00,'2022-05-01 07:03:51','',''),(2620364,'1','202','1036',477,'Retail Sale Id 7320',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 07:04:41','',''),(2620365,'1','202','1036',477,'Retail Sale Id 7321',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 07:11:07','',''),(2620366,'1','202','1036',477,'Retail Sale Id 7322',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 07:22:01','',''),(2620367,'1','202','1036',477,'Retail Sale Id 7323',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 07:27:52','',''),(2620368,'1','202','1036',477,'Retail Sale Id 7324',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 07:29:53','',''),(2620369,'1','202','1036',477,'Retail Sale Id 7325',697.20,0.00,0.00,1.05,86.10,'2022-05-01 07:32:42','',''),(2620370,'1','202','1036',477,'Retail Sale Id 7326',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 07:33:49','',''),(2620371,'1','202','1036',477,'Retail Sale Id 7327',903.04,0.00,0.00,1.36,111.52,'2022-05-01 07:39:58','',''),(2620372,'1','202','1036',477,'Retail Sale Id 7329',269100.00,0.00,0.00,450.00,7200.00,'2022-05-01 07:46:49','',''),(2620373,'1','202','1036',477,'Retail Sale Id 7330',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 07:48:07','',''),(2620374,'1','202','1036',477,'Retail Sale Id 7331',697.20,0.00,0.00,1.05,86.10,'2022-05-01 07:48:52','',''),(2620375,'1','202','1036',477,'Retail Sale Id 7332',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 07:53:51','',''),(2620376,'1','202','1036',477,'Retail Sale Id 7333',1699.84,0.00,0.00,2.56,209.92,'2022-05-01 07:55:27','',''),(2620377,'1','202','1036',477,'Retail Sale Id 7334',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 07:57:11','',''),(2620378,'1','202','1036',477,'Retail Sale Id 7335',23920.00,0.00,0.00,40.00,640.00,'2022-05-01 08:02:39','',''),(2620379,'1','202','1036',477,'Retail Sale Id 7336',498.00,0.00,0.00,0.75,61.50,'2022-05-01 08:07:50','',''),(2620380,'1','202','1036',477,'Retail Sale Id 7337',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 08:08:43','',''),(2620381,'1','202','1036',477,'Retail Sale Id 7338',29900.00,0.00,0.00,50.00,800.00,'2022-05-01 08:17:43','',''),(2620382,'1','202','1036',477,'Retail Sale Id 7339',5398.32,0.00,0.00,8.13,666.66,'2022-05-01 08:20:01','',''),(2620383,'1','202','1036',477,'Retail Sale Id 7340',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 08:20:43','',''),(2620384,'1','202','1036',477,'Retail Sale Id 7341',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 08:21:19','',''),(2620385,'1','202','1036',477,'Retail Sale Id 7342',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 08:25:10','',''),(2620386,'1','202','1036',477,'Retail Sale Id 7343',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 08:26:05','',''),(2620387,'1','202','1036',477,'Retail Sale Id 7344',1347.92,0.00,0.00,2.03,166.46,'2022-05-01 08:28:33','',''),(2620388,'1','202','1036',477,'Retail Sale Id 7345',2503.28,0.00,0.00,3.77,309.14,'2022-05-01 08:29:27','',''),(2620389,'1','202','1036',477,'Retail Sale Id 7346',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 08:30:26','',''),(2620390,'1','202','1036',477,'Retail Sale Id 7347',1347.92,0.00,0.00,2.03,166.46,'2022-05-01 08:35:21','',''),(2620391,'1','202','1036',477,'Retail Sale Id 7348',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 08:39:33','',''),(2620392,'1','202','1036',477,'Retail Sale Id 7349',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 08:42:08','',''),(2620393,'1','202','1036',477,'Retail Sale Id 7350',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 08:44:17','',''),(2620394,'1','202','1036',477,'Retail Sale Id 7351',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 08:45:03','',''),(2620395,'1','202','1036',477,'Retail Sale Id 7352',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 08:45:54','',''),(2620396,'1','202','1036',477,'Retail Sale Id 7353',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 08:48:10','',''),(2620397,'1','202','1036',477,'Retail Sale Id 7354',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 08:49:20','',''),(2620398,'1','202','1036',477,'Retail Sale Id 7355',69966.00,0.00,0.00,117.00,1872.00,'2022-05-01 08:51:52','',''),(2620399,'1','202','1036',477,'Retail Sale Id 7356',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 08:52:30','',''),(2620400,'1','202','1036',477,'Retail Sale Id 7357',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 08:53:10','',''),(2620401,'1','202','1036',477,'Retail Sale Id 7358',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 08:53:46','',''),(2620402,'1','202','1036',477,'Retail Sale Id 7359',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 08:54:31','',''),(2620403,'1','202','1036',477,'Retail Sale Id 7360',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 08:56:10','',''),(2620404,'1','202','1036',477,'Retail Sale Id 7361',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 08:58:25','',''),(2620405,'1','202','1036',477,'Retail Sale Id 7362',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 09:00:39','',''),(2620406,'1','202','1036',477,'Retail Sale Id 7363',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 09:02:26','',''),(2620407,'1','202','1036',477,'Retail Sale Id 7364',723580.00,0.00,0.00,1210.00,19360.00,'2022-05-01 09:03:40','',''),(2620408,'1','202','1036',477,'Retail Sale Id 7365',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 09:04:20','',''),(2620409,'1','202','1036',477,'Retail Sale Id 7366',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 09:07:09','',''),(2620410,'1','202','1036',477,'Retail Sale Id 7367',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 09:10:11','',''),(2620411,'1','202','1036',477,'Retail Sale Id 7368',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 09:14:44','',''),(2620412,'1','202','1036',477,'Retail Sale Id 7370',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 09:22:12','',''),(2620413,'1','202','1036',477,'Retail Sale Id 7371',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 09:23:12','',''),(2620414,'1','202','1036',477,'Retail Sale Id 7372',3499.28,0.00,0.00,5.27,432.14,'2022-05-01 09:23:59','',''),(2620415,'1','202','1036',477,'Retail Sale Id 7373',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 09:25:11','',''),(2620416,'1','202','1036',477,'Retail Sale Id 7374',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 09:26:26','',''),(2620417,'1','202','1036',477,'Retail Sale Id 7375',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 09:28:07','',''),(2620418,'1','202','1036',477,'Retail Sale Id 7376',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 09:29:45','',''),(2620419,'1','202','1036',477,'Retail Sale Id 7377',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 09:34:57','',''),(2620420,'1','202','1036',477,'Retail Sale Id 7378',498.00,0.00,0.00,0.75,61.50,'2022-05-01 09:35:43','',''),(2620421,'1','202','1036',477,'Retail Sale Id 7379',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 09:39:22','',''),(2620422,'1','202','1036',477,'Retail Sale Id 7380',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 09:39:54','',''),(2620423,'1','202','1036',477,'Retail Sale Id 7381',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 09:40:51','',''),(2620424,'1','202','1036',477,'Retail Sale Id 7382',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 09:42:37','',''),(2620425,'1','202','1036',477,'Retail Sale Id 7383',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 09:44:05','',''),(2620426,'1','202','1036',477,'Retail Sale Id 7384',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 09:44:35','',''),(2620427,'1','202','1036',477,'Retail Sale Id 7385',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 09:45:11','',''),(2620428,'1','202','1036',477,'Retail Sale Id 7386',6653.28,0.00,0.00,10.02,821.64,'2022-05-01 09:46:36','',''),(2620429,'1','202','1036',477,'Retail Sale Id 7387',2702.48,0.00,0.00,4.07,333.74,'2022-05-01 09:47:51','',''),(2620430,'1','202','1036',477,'Retail Sale Id 7388',1699.84,0.00,0.00,2.56,209.92,'2022-05-01 09:48:43','',''),(2620431,'1','202','1036',477,'Retail Sale Id 7389',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 09:49:38','',''),(2620432,'1','202','1036',477,'Retail Sale Id 7390',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 09:50:23','',''),(2620433,'1','202','1036',477,'Retail Sale Id 7391',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 09:51:04','',''),(2620434,'1','202','1036',477,'Retail Sale Id 7392',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 09:52:01','',''),(2620435,'1','202','1036',477,'Retail Sale Id 7393',2503.28,0.00,0.00,3.77,309.14,'2022-05-01 09:52:43','',''),(2620436,'1','202','1036',477,'Retail Sale Id 7394',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 09:53:13','',''),(2620437,'1','202','1036',477,'Retail Sale Id 7395',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 09:54:01','',''),(2620438,'1','202','1036',477,'Retail Sale Id 7397',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 09:55:08','',''),(2620439,'1','202','1036',477,'Retail Sale Id 7398',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 09:55:47','',''),(2620440,'1','202','1036',477,'Retail Sale Id 7399',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 09:59:12','',''),(2620441,'1','202','1036',477,'Retail Sale Id 7400',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 10:00:33','',''),(2620442,'1','202','1036',477,'Retail Sale Id 7401',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 10:01:49','',''),(2620443,'1','202','1036',477,'Retail Sale Id 7402',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 10:04:09','',''),(2620444,'1','202','1036',477,'Retail Sale Id 7403',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 10:05:30','',''),(2620445,'1','202','1036',477,'Retail Sale Id 7404',697.20,0.00,0.00,1.05,86.10,'2022-05-01 10:08:32','',''),(2620446,'1','202','1036',477,'Retail Sale Id 7405',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 10:11:40','',''),(2620447,'1','202','1036',477,'Retail Sale Id 7406',7304.00,0.00,0.00,11.00,902.00,'2022-05-01 10:14:12','',''),(2620448,'1','202','1036',477,'Retail Sale Id 7407',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 10:15:51','',''),(2620449,'1','202','1036',477,'Retail Sale Id 7408',1201.84,0.00,0.00,1.81,148.42,'2022-05-01 10:16:34','',''),(2620450,'1','202','1036',477,'Retail Sale Id 7409',1799.44,0.00,0.00,2.71,222.22,'2022-05-01 10:19:07','',''),(2620451,'1','202','1036',477,'Retail Sale Id 7410',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 10:22:37','',''),(2620452,'1','202','1036',477,'Retail Sale Id 7411',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 10:25:11','',''),(2620453,'1','202','1036',477,'Retail Sale Id 7412',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 10:27:09','',''),(2620454,'1','202','1036',477,'Retail Sale Id 7413',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 10:31:34','',''),(2620455,'1','202','1036',477,'Retail Sale Id 7414',2702.48,0.00,0.00,4.07,333.74,'2022-05-01 10:33:23','',''),(2620456,'1','202','1036',477,'Retail Sale Id 7415',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 10:36:38','',''),(2620457,'1','202','1036',477,'Retail Sale Id 7416',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 10:39:22','',''),(2620458,'1','202','1036',477,'Retail Sale Id 7417',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 10:40:27','',''),(2620459,'1','202','1036',477,'Retail Sale Id 7418',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 10:42:44','',''),(2620460,'1','202','1036',477,'Retail Sale Id 7419',1799.44,0.00,0.00,2.71,222.22,'2022-05-01 10:44:16','',''),(2620461,'1','202','1036',477,'Retail Sale Id 7420',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 10:45:02','',''),(2620462,'1','202','1036',477,'Retail Sale Id 7421',2503.28,0.00,0.00,3.77,309.14,'2022-05-01 10:45:36','',''),(2620463,'1','202','1036',477,'Retail Sale Id 7424',8001.20,0.00,0.00,12.05,988.10,'2022-05-01 10:47:52','',''),(2620464,'1','202','1036',477,'Retail Sale Id 7425',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 10:51:22','',''),(2620465,'1','202','1036',477,'Retail Sale Id 7426',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 10:52:03','',''),(2620466,'1','202','1036',477,'Retail Sale Id 7427',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 10:52:45','',''),(2620467,'1','202','1036',477,'Retail Sale Id 7428',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 10:53:39','',''),(2620468,'1','202','1036',477,'Retail Sale Id 7429',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 10:55:05','',''),(2620469,'1','202','1036',477,'Retail Sale Id 7430',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 10:55:48','',''),(2620470,'1','202','1036',477,'Retail Sale Id 7430',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 10:55:48','',''),(2620471,'1','202','1036',477,'Retail Sale Id 7431',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 10:56:48','',''),(2620472,'1','202','1036',477,'Retail Sale Id 7432',1347.92,0.00,0.00,2.03,166.46,'2022-05-01 10:57:49','',''),(2620473,'1','202','1036',477,'Retail Sale Id 7433',1799.44,0.00,0.00,2.71,222.22,'2022-05-01 11:00:57','',''),(2620474,'1','202','1036',477,'Retail Sale Id 7434',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 11:02:05','',''),(2620475,'1','202','1036',477,'Retail Sale Id 7435',4150.00,0.00,0.00,6.25,512.50,'2022-05-01 11:03:40','',''),(2620476,'1','202','1036',477,'Retail Sale Id 7436',1347.92,0.00,0.00,2.03,166.46,'2022-05-01 11:04:59','',''),(2620477,'1','202','1036',477,'Retail Sale Id 7437',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 11:07:42','',''),(2620478,'1','202','1036',477,'Retail Sale Id 7438',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 11:09:44','',''),(2620479,'1','202','1036',477,'Retail Sale Id 7439',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 11:10:49','',''),(2620480,'1','202','1036',477,'Retail Sale Id 7440',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 11:11:25','',''),(2620481,'1','202','1036',477,'Retail Sale Id 7441',6998.56,0.00,0.00,10.54,864.28,'2022-05-01 11:12:24','',''),(2620482,'1','202','1036',477,'Retail Sale Id 7442',2802.08,0.00,0.00,4.22,346.04,'2022-05-01 11:13:17','',''),(2620483,'1','202','1036',477,'Retail Sale Id 7443',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 11:19:46','',''),(2620484,'1','202','1036',477,'Retail Sale Id 7444',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 11:20:52','',''),(2620485,'1','202','1036',477,'Retail Sale Id 7445',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 11:26:04','',''),(2620486,'1','202','1036',477,'Retail Sale Id 7446',2503.28,0.00,0.00,3.77,309.14,'2022-05-01 11:26:48','',''),(2620487,'1','202','1036',477,'Retail Sale Id 7447',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 11:28:15','',''),(2620488,'1','202','1036',477,'Retail Sale Id 7448',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 11:35:23','',''),(2620489,'1','202','1036',477,'Retail Sale Id 7449',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 11:36:06','',''),(2620490,'1','202','1036',477,'Retail Sale Id 7450',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 11:38:18','',''),(2620491,'1','202','1036',477,'Retail Sale Id 7451',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 11:39:10','',''),(2620492,'1','202','1036',477,'Retail Sale Id 7452',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 11:41:01','',''),(2620493,'1','202','1036',477,'Retail Sale Id 7453',1201.84,0.00,0.00,1.81,148.42,'2022-05-01 11:42:01','',''),(2620494,'1','202','1036',477,'Retail Sale Id 7454',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 11:43:05','',''),(2620495,'1','202','1036',477,'Retail Sale Id 7455',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 11:44:02','',''),(2620496,'1','202','1036',477,'Retail Sale Id 7456',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 11:44:40','',''),(2620497,'1','202','1036',477,'Retail Sale Id 7457',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 11:45:12','',''),(2620498,'1','202','1036',477,'Retail Sale Id 7458',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 11:47:11','',''),(2620499,'1','202','1036',477,'Retail Sale Id 7459',6002.56,0.00,0.00,9.04,741.28,'2022-05-01 11:49:40','',''),(2620500,'1','202','1036',477,'Retail Sale Id 7461',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 11:51:22','',''),(2620501,'1','202','1036',477,'Retail Sale Id 7461',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 11:51:22','',''),(2620502,'1','202','1036',477,'Retail Sale Id 7462',969.44,0.00,0.00,1.46,119.72,'2022-05-01 11:54:26','',''),(2620503,'1','202','1036',477,'Retail Sale Id 7463',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 11:55:16','',''),(2620504,'1','202','1036',477,'Retail Sale Id 7464',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 11:55:53','',''),(2620505,'1','202','1036',477,'Retail Sale Id 7465',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 12:02:23','',''),(2620506,'1','202','1036',477,'Retail Sale Id 7466',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 12:04:37','',''),(2620507,'1','202','1036',477,'Retail Sale Id 7467',65182.00,0.00,0.00,109.00,1744.00,'2022-05-01 12:05:35','',''),(2620508,'1','202','1036',477,'Retail Sale Id 7468',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 12:09:27','',''),(2620509,'1','202','1036',477,'Retail Sale Id 7469',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 12:12:37','',''),(2620510,'1','202','1036',477,'Retail Sale Id 7470',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 12:15:34','',''),(2620511,'1','202','1036',477,'Retail Sale Id 7471',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 12:16:25','',''),(2620512,'1','202','1036',477,'Retail Sale Id 7472',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 12:19:34','',''),(2620513,'1','202','1036',477,'Retail Sale Id 7473',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 12:20:12','',''),(2620514,'1','202','1036',477,'Retail Sale Id 7474',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 12:20:51','',''),(2620515,'1','202','1036',477,'Retail Sale Id 7475',1347.92,0.00,0.00,2.03,166.46,'2022-05-01 12:25:59','',''),(2620516,'1','202','1036',477,'Retail Sale Id 7476',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 12:26:44','',''),(2620517,'1','202','1036',477,'Retail Sale Id 7477',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 12:27:22','',''),(2620518,'1','202','1036',477,'Retail Sale Id 7478',697.20,0.00,0.00,1.05,86.10,'2022-05-01 12:32:51','',''),(2620519,'1','202','1036',477,'Retail Sale Id 7479',796.80,0.00,0.00,1.20,98.40,'2022-05-01 12:33:38','',''),(2620520,'1','202','1036',477,'Retail Sale Id 7480',4999.92,0.00,0.00,7.53,617.46,'2022-05-01 12:34:19','',''),(2620521,'1','202','1036',477,'Retail Sale Id 7481',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 12:35:12','',''),(2620522,'1','202','1036',477,'Retail Sale Id 7482',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 12:44:22','',''),(2620523,'1','202','1036',477,'Retail Sale Id 7484',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 12:45:26','',''),(2620524,'1','202','1036',477,'Retail Sale Id 7485',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 12:46:23','',''),(2620525,'1','202','1036',477,'Retail Sale Id 7486',2098.24,0.00,0.00,3.16,259.12,'2022-05-01 12:48:08','',''),(2620526,'1','202','1036',477,'Retail Sale Id 7487',4999.92,0.00,0.00,7.53,617.46,'2022-05-01 12:48:58','',''),(2620527,'1','202','1036',477,'Retail Sale Id 7488',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 12:49:33','',''),(2620528,'1','202','1036',477,'Retail Sale Id 7489',2503.28,0.00,0.00,3.77,309.14,'2022-05-01 12:51:12','',''),(2620529,'1','202','1036',477,'Retail Sale Id 7490',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 12:56:17','',''),(2620530,'1','202','1036',477,'Retail Sale Id 7491',4501.92,0.00,0.00,6.78,555.96,'2022-05-01 13:01:22','',''),(2620531,'1','202','1036',477,'Retail Sale Id 7492',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 13:02:06','',''),(2620532,'1','202','1036',477,'Retail Sale Id 7493',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 13:02:34','',''),(2620533,'1','202','1036',477,'Retail Sale Id 7494',6653.28,0.00,0.00,10.02,821.64,'2022-05-01 13:03:37','',''),(2620534,'1','202','1036',477,'Retail Sale Id 7495',6653.28,0.00,0.00,10.02,821.64,'2022-05-01 13:05:54','',''),(2620535,'1','202','1036',477,'Retail Sale Id 7496',498.00,0.00,0.00,0.75,61.50,'2022-05-01 13:06:51','',''),(2620536,'1','202','1036',477,'Retail Sale Id 7497',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 13:07:37','',''),(2620537,'1','202','1036',477,'Retail Sale Id 7498',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 13:08:23','',''),(2620538,'1','202','1036',477,'Retail Sale Id 7499',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 13:09:11','',''),(2620539,'1','202','1036',477,'Retail Sale Id 7500',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 13:10:28','',''),(2620540,'1','202','1036',477,'Retail Sale Id 7501',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 13:13:58','',''),(2620541,'1','202','1036',477,'Retail Sale Id 7502',19920.00,0.00,0.00,30.00,2460.00,'2022-05-01 13:17:01','',''),(2620542,'1','202','1036',477,'Retail Sale Id 7503',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 13:19:15','',''),(2620543,'1','202','1036',477,'Retail Sale Id 7504',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 13:20:31','',''),(2620544,'1','202','1036',477,'Retail Sale Id 7505',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 13:23:48','',''),(2620545,'1','202','1036',477,'Retail Sale Id 7506',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 13:29:32','',''),(2620546,'1','202','1036',477,'Retail Sale Id 7507',1799.44,0.00,0.00,2.71,222.22,'2022-05-01 13:31:04','',''),(2620547,'1','202','1036',477,'Retail Sale Id 7508',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 13:31:46','',''),(2620548,'1','202','1036',477,'Retail Sale Id 7509',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 13:33:33','',''),(2620549,'1','202','1036',477,'Retail Sale Id 7510',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 13:34:56','',''),(2620550,'1','202','1036',477,'Retail Sale Id 7511',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 13:36:07','',''),(2620551,'1','202','1036',477,'Retail Sale Id 7512',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 13:41:40','',''),(2620552,'1','202','1036',477,'Retail Sale Id 7513',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 13:42:18','',''),(2620553,'1','202','1036',477,'Retail Sale Id 7514',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 13:51:19','',''),(2620554,'1','202','1036',477,'Retail Sale Id 7515',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 13:52:12','',''),(2620555,'1','202','1036',477,'Retail Sale Id 7516',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 13:55:05','',''),(2620556,'1','202','1036',477,'Retail Sale Id 7518',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 13:58:58','',''),(2620557,'1','202','1036',477,'Retail Sale Id 7519',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 14:00:48','',''),(2620558,'1','202','1036',477,'Retail Sale Id 7520',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 14:03:49','',''),(2620559,'1','202','1036',477,'Retail Sale Id 7522',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 14:07:53','',''),(2620560,'1','202','1036',477,'Retail Sale Id 7523',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 14:08:47','',''),(2620561,'1','202','1036',477,'Retail Sale Id 7525',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 14:10:29','',''),(2620562,'1','202','1036',477,'Retail Sale Id 7526',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 14:11:24','',''),(2620563,'1','202','1036',477,'Retail Sale Id 7527',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 14:12:19','',''),(2620564,'1','202','1036',477,'Retail Sale Id 7528',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 14:13:25','',''),(2620565,'1','202','1036',477,'Retail Sale Id 7530',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 14:14:57','',''),(2620566,'1','202','1036',477,'Retail Sale Id 7531',50232.00,0.00,0.00,84.00,1344.00,'2022-05-01 14:18:23','',''),(2620567,'1','202','1036',477,'Retail Sale Id 7532',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 14:19:02','',''),(2620568,'1','202','1036',477,'Retail Sale Id 7534',35282.00,0.00,0.00,59.00,944.00,'2022-05-01 14:21:26','',''),(2620569,'1','202','1036',477,'Retail Sale Id 7535',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 14:22:55','',''),(2620570,'1','202','1036',477,'Retail Sale Id 7537',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 14:24:42','',''),(2620571,'1','202','1036',477,'Retail Sale Id 7538',32890.00,0.00,0.00,55.00,880.00,'2022-05-01 14:26:07','',''),(2620572,'1','202','1036',477,'Retail Sale Id 7539',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 14:27:46','',''),(2620573,'1','202','1036',477,'Retail Sale Id 7540',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 14:28:49','',''),(2620574,'1','202','1036',477,'Retail Sale Id 7541',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 14:31:28','',''),(2620575,'1','202','1036',477,'Retail Sale Id 7542',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 14:32:18','',''),(2620576,'1','202','1036',477,'Retail Sale Id 7543',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 14:34:02','',''),(2620577,'1','202','1036',477,'Retail Sale Id 7544',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 14:34:59','',''),(2620578,'1','202','1036',477,'Retail Sale Id 7545',1347.92,0.00,0.00,2.03,166.46,'2022-05-01 14:36:04','',''),(2620579,'1','202','1036',477,'Retail Sale Id 7546',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 14:37:31','',''),(2620580,'1','202','1036',477,'Retail Sale Id 7547',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 14:39:51','',''),(2620581,'1','202','1036',477,'Retail Sale Id 7548',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 14:40:50','',''),(2620582,'1','202','1036',477,'Retail Sale Id 7550',2503.28,0.00,0.00,3.77,309.14,'2022-05-01 14:41:38','',''),(2620583,'1','202','1036',477,'Retail Sale Id 7551',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 14:45:42','',''),(2620584,'1','202','1036',477,'Retail Sale Id 7552',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 14:50:24','',''),(2620585,'1','202','1036',477,'Retail Sale Id 7554',3499.28,0.00,0.00,5.27,432.14,'2022-05-01 14:51:11','',''),(2620586,'1','202','1036',477,'Retail Sale Id 7555',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 14:53:23','',''),(2620587,'1','202','1036',477,'Retail Sale Id 7557',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 14:57:10','',''),(2620588,'1','202','1036',477,'Retail Sale Id 7558',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 14:58:45','',''),(2620589,'1','202','1036',477,'Retail Sale Id 7559',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 15:01:02','',''),(2620590,'1','202','1036',477,'Retail Sale Id 7560',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 15:03:01','',''),(2620591,'1','202','1036',477,'Retail Sale Id 7561',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 15:04:27','',''),(2620592,'1','202','1036',477,'Retail Sale Id 7562',6998.56,0.00,0.00,10.54,864.28,'2022-05-01 15:07:20','',''),(2620593,'1','202','1036',477,'Retail Sale Id 7563',6653.28,0.00,0.00,10.02,821.64,'2022-05-01 15:08:44','',''),(2620594,'1','202','1036',477,'Retail Sale Id 7564',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 15:19:35','',''),(2620595,'1','202','1036',477,'Retail Sale Id 7565',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 15:20:48','',''),(2620596,'1','202','1036',477,'Retail Sale Id 7566',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 15:26:28','',''),(2620597,'1','202','1036',477,'Retail Sale Id 7567',7702.40,0.00,0.00,11.60,951.20,'2022-05-01 15:37:41','',''),(2620598,'1','202','1036',477,'Retail Sale Id 7569',5497.92,0.00,0.00,8.28,678.96,'2022-05-01 15:40:44','',''),(2620599,'1','202','1036',477,'Retail Sale Id 7570',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 15:56:53','',''),(2620600,'1','202','1036',477,'Retail Sale Id 7571',1347.92,0.00,0.00,2.03,166.46,'2022-05-01 16:10:42','',''),(2620601,'1','202','1036',477,'Retail Sale Id 7572',5351.84,0.00,0.00,8.06,660.92,'2022-05-01 16:15:19','',''),(2620602,'1','202','1036',477,'Retail Sale Id 7573',2702.48,0.00,0.00,4.07,333.74,'2022-05-01 16:16:40','',''),(2620603,'1','202','1036',477,'Retail Sale Id 7574',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 16:20:30','',''),(2620604,'1','202','1036',477,'Retail Sale Id 7575',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 16:21:40','',''),(2620605,'1','202','1036',477,'Retail Sale Id 7576',4501.92,0.00,0.00,6.78,555.96,'2022-05-01 16:22:39','',''),(2620606,'1','202','1036',477,'Retail Sale Id 7556',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 16:24:13','',''),(2620607,'1','202','1036',477,'Retail Sale Id 7577',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 16:25:23','',''),(2620608,'1','202','1036',477,'Retail Sale Id 7578',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 16:26:02','',''),(2620609,'1','202','1036',477,'Retail Sale Id 7579',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 16:33:42','',''),(2620610,'1','202','1036',477,'Retail Sale Id 7580',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 16:39:35','',''),(2620611,'1','202','1036',477,'Retail Sale Id 7581',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 16:40:18','',''),(2620612,'1','202','1036',477,'Retail Sale Id 7582',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 16:41:31','',''),(2620613,'1','202','1036',477,'Retail Sale Id 7583',2802.08,0.00,0.00,4.22,346.04,'2022-05-01 16:44:12','',''),(2620614,'1','202','1036',477,'Retail Sale Id 7584',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 16:49:04','',''),(2620615,'1','202','1036',477,'Retail Sale Id 7585',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 16:54:38','',''),(2620616,'1','202','1036',477,'Retail Sale Id 7586',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 16:58:33','',''),(2620617,'1','202','1036',477,'Retail Sale Id 7587',3499.28,0.00,0.00,5.27,432.14,'2022-05-01 17:04:49','',''),(2620618,'1','202','1036',477,'Retail Sale Id 7588',2702.48,0.00,0.00,4.07,333.74,'2022-05-01 17:07:06','',''),(2620619,'1','202','1036',477,'Retail Sale Id 7589',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 17:10:41','',''),(2620620,'1','202','1036',477,'Retail Sale Id 7590',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 17:11:24','',''),(2620621,'1','202','1036',477,'Retail Sale Id 7591',2702.48,0.00,0.00,4.07,333.74,'2022-05-01 17:12:45','',''),(2620622,'1','202','1036',477,'Retail Sale Id 7592',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 17:19:39','',''),(2620623,'1','202','1036',477,'Retail Sale Id 7593',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 17:21:08','',''),(2620624,'1','202','1036',477,'Retail Sale Id 7594',597.60,0.00,0.00,0.90,73.80,'2022-05-01 17:21:54','',''),(2620625,'1','202','1036',477,'Retail Sale Id 7595',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 17:27:54','',''),(2620626,'1','202','1036',477,'Retail Sale Id 7596',4999.92,0.00,0.00,7.53,617.46,'2022-05-01 17:37:03','',''),(2620627,'1','202','1036',477,'Retail Sale Id 7597',3001.28,0.00,0.00,4.52,370.64,'2022-05-01 17:39:14','',''),(2620628,'1','202','1036',477,'Retail Sale Id 7598',3353.20,0.00,0.00,5.05,414.10,'2022-05-01 17:42:24','',''),(2620629,'1','202','1036',477,'Retail Sale Id 7599',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 17:47:12','',''),(2620630,'1','202','1036',477,'Retail Sale Id 7600',2702.48,0.00,0.00,4.07,333.74,'2022-05-01 17:50:05','',''),(2620631,'1','202','1036',477,'Retail Sale Id 7601',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 17:51:55','',''),(2620632,'1','202','1036',477,'Retail Sale Id 7602',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 17:53:25','',''),(2620633,'1','202','1036',477,'Retail Sale Id 7603',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 17:54:52','',''),(2620634,'1','202','1036',477,'Retail Sale Id 7604',498.00,0.00,0.00,0.75,61.50,'2022-05-01 18:02:40','',''),(2620635,'1','202','1036',477,'Retail Sale Id 7605',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 18:06:28','',''),(2620636,'1','202','1036',477,'Retail Sale Id 7606',2702.48,0.00,0.00,4.07,333.74,'2022-05-01 18:12:54','',''),(2620637,'1','202','1036',477,'Retail Sale Id 7607',1301.44,0.00,0.00,1.96,160.72,'2022-05-01 18:14:31','',''),(2620638,'1','202','1036',477,'Retail Sale Id 7608',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 18:15:05','',''),(2620639,'1','202','1036',477,'Retail Sale Id 7609',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 18:15:42','',''),(2620640,'1','202','1036',477,'Retail Sale Id 7610',1998.64,0.00,0.00,3.01,246.82,'2022-05-01 18:16:53','',''),(2620641,'1','202','1036',477,'Retail Sale Id 7611',3798.08,0.00,0.00,5.72,469.04,'2022-05-01 18:18:47','',''),(2620642,'1','202','1036',477,'Retail Sale Id 7612',796.80,0.00,0.00,1.20,98.40,'2022-05-01 18:22:49','',''),(2620643,'1','202','1036',477,'Retail Sale Id 7613',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 18:23:29','',''),(2620644,'1','202','1036',477,'Retail Sale Id 7614',1799.44,0.00,0.00,2.71,222.22,'2022-05-01 18:30:37','',''),(2620645,'1','202','1036',477,'Retail Sale Id 7615',8300.00,0.00,0.00,12.50,1025.00,'2022-05-01 18:32:27','',''),(2620646,'1','202','1036',477,'Retail Sale Id 7616',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 18:36:18','',''),(2620647,'1','202','1036',477,'Retail Sale Id 7617',3997.28,0.00,0.00,6.02,493.64,'2022-05-01 18:39:41','',''),(2620648,'1','202','1036',477,'Retail Sale Id 7618',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 18:43:57','',''),(2620649,'1','202','1036',477,'Retail Sale Id 7619',1002.64,0.00,0.00,1.51,123.82,'2022-05-01 18:46:28','',''),(2620650,'1','202','1036',477,'Retail Sale Id 7620',3698.48,0.00,0.00,5.57,456.74,'2022-05-01 18:52:28','',''),(2620651,'1','202','1036',477,'Retail Sale Id 7621',498.00,0.00,0.00,0.75,61.50,'2022-05-01 18:53:31','',''),(2620652,'1','202','1036',477,'Retail Sale Id 7622',4999.92,0.00,0.00,7.53,617.46,'2022-05-01 18:58:50','',''),(2620653,'1','202','1036',477,'Retail Sale Id 7623',1500.64,0.00,0.00,2.26,185.32,'2022-05-01 18:59:33','',''),(2620654,'1','202','1036',477,'Retail Sale Id 7624',46004.14,0.00,0.00,76.93,1230.88,'2022-05-01 19:43:52','',''),(2620655,'1','202','1036',477,'Retail Sale Id 7625',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 10:00:06','',''),(2620656,'1','202','1036',477,'Retail Sale Id 7626',3353.20,0.00,0.00,5.05,414.10,'2022-05-02 10:01:44','',''),(2620657,'1','202','1036',477,'Retail Sale Id 7627',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 10:02:23','',''),(2620658,'1','202','1036',477,'Retail Sale Id 7628',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 10:11:17','',''),(2620659,'1','202','1036',477,'Retail Sale Id 7629',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 10:12:27','',''),(2620660,'1','202','1036',477,'Retail Sale Id 7630',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 10:13:16','',''),(2620661,'1','202','1036',477,'Retail Sale Id 7632',697.20,0.00,0.00,1.05,86.10,'2022-05-02 10:14:05','',''),(2620662,'1','202','1036',477,'Retail Sale Id 7633',29900.00,0.00,0.00,50.00,800.00,'2022-05-02 10:15:20','',''),(2620663,'1','202','1036',477,'Retail Sale Id 7634',498.00,0.00,0.00,0.75,61.50,'2022-05-02 10:17:09','',''),(2620664,'1','202','1036',477,'Retail Sale Id 7635',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 10:18:16','',''),(2620665,'1','202','1036',477,'Retail Sale Id 7636',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 10:18:51','',''),(2620666,'1','202','1036',477,'Retail Sale Id 7637',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 10:27:25','',''),(2620667,'1','202','1036',477,'Retail Sale Id 7639',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 10:28:17','',''),(2620668,'1','202','1036',477,'Retail Sale Id 7640',7297.36,0.00,0.00,10.99,901.18,'2022-05-02 10:30:16','',''),(2620669,'1','202','1036',477,'Retail Sale Id 7641',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 10:31:49','',''),(2620670,'1','202','1036',477,'Retail Sale Id 7642',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 10:32:58','',''),(2620671,'1','202','1036',477,'Retail Sale Id 7643',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 10:34:47','',''),(2620672,'1','202','1036',477,'Retail Sale Id 7644',2503.28,0.00,0.00,3.77,309.14,'2022-05-02 10:37:54','',''),(2620673,'1','202','1036',477,'Retail Sale Id 7645',1899.04,0.00,0.00,2.86,234.52,'2022-05-02 10:40:06','',''),(2620674,'1','202','1036',477,'Retail Sale Id 7646',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 10:41:09','',''),(2620675,'1','202','1036',477,'Retail Sale Id 7647',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 10:42:11','',''),(2620676,'1','202','1036',477,'Retail Sale Id 7649',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 10:42:53','',''),(2620677,'1','202','1036',477,'Retail Sale Id 7651',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 10:43:48','',''),(2620678,'1','202','1036',477,'Retail Sale Id 7652',498.00,0.00,0.00,0.75,61.50,'2022-05-02 10:50:57','',''),(2620679,'1','202','1036',477,'Retail Sale Id 7653',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 10:57:44','',''),(2620680,'1','202','1036',477,'Retail Sale Id 7654',2702.48,0.00,0.00,4.07,333.74,'2022-05-02 11:03:58','',''),(2620681,'1','202','1036',477,'Retail Sale Id 7650',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 11:06:56','',''),(2620682,'1','202','1036',477,'Retail Sale Id 7655',3001.28,0.00,0.00,4.52,370.64,'2022-05-02 11:08:19','',''),(2620683,'1','202','1036',477,'Retail Sale Id 7657',6998.56,0.00,0.00,10.54,864.28,'2022-05-02 11:10:40','',''),(2620684,'1','202','1036',477,'Retail Sale Id 7658',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 11:16:16','',''),(2620685,'1','202','1036',477,'Retail Sale Id 7659',3353.20,0.00,0.00,5.05,414.10,'2022-05-02 11:18:28','',''),(2620686,'1','202','1036',477,'Retail Sale Id 7661',4999.92,0.00,0.00,7.53,617.46,'2022-05-02 11:20:05','',''),(2620687,'1','202','1036',477,'Retail Sale Id 7664',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 11:26:32','',''),(2620688,'1','202','1036',477,'Retail Sale Id 7665',6653.28,0.00,0.00,10.02,821.64,'2022-05-02 11:41:11','',''),(2620689,'1','202','1036',477,'Retail Sale Id 7666',8970.00,0.00,0.00,15.00,240.00,'2022-05-02 11:43:11','',''),(2620690,'1','202','1036',477,'Retail Sale Id 7667',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 11:52:09','',''),(2620691,'1','202','1036',477,'Retail Sale Id 7668',1500.64,0.00,0.00,2.26,185.32,'2022-05-02 11:53:57','',''),(2620692,'1','202','1036',477,'Retail Sale Id 7669',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 11:55:06','',''),(2620693,'1','202','1036',477,'Retail Sale Id 7670',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 11:57:49','',''),(2620694,'1','202','1036',477,'Retail Sale Id 7671',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 12:01:08','',''),(2620695,'1','202','1036',477,'Retail Sale Id 7672',3353.20,0.00,0.00,5.05,414.10,'2022-05-02 12:01:53','',''),(2620696,'1','202','1036',477,'Retail Sale Id 7673',34684.00,0.00,0.00,58.00,928.00,'2022-05-02 12:08:07','',''),(2620697,'1','202','1036',477,'Retail Sale Id 7674',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 12:10:03','',''),(2620698,'1','202','1036',477,'Retail Sale Id 7675',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 12:10:51','',''),(2620699,'1','202','1036',477,'Retail Sale Id 7676',2702.48,0.00,0.00,4.07,333.74,'2022-05-02 12:16:34','',''),(2620700,'1','202','1036',477,'Retail Sale Id 7677',2702.48,0.00,0.00,4.07,333.74,'2022-05-02 12:21:38','',''),(2620701,'1','202','1036',477,'Retail Sale Id 7678',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 12:23:13','',''),(2620702,'1','202','1036',477,'Retail Sale Id 7679',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 12:26:02','',''),(2620703,'1','202','1036',477,'Retail Sale Id 7680',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 12:26:58','',''),(2620704,'1','202','1036',477,'Retail Sale Id 7681',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 12:32:42','',''),(2620705,'1','202','1036',477,'Retail Sale Id 7682',3300.08,0.00,0.00,4.97,407.54,'2022-05-02 12:34:08','',''),(2620706,'1','202','1036',477,'Retail Sale Id 7683',4648.00,0.00,0.00,7.00,574.00,'2022-05-02 12:35:32','',''),(2620707,'1','202','1036',477,'Retail Sale Id 7684',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 12:36:11','',''),(2620708,'1','202','1036',477,'Retail Sale Id 7685',2297.44,0.00,0.00,3.46,283.72,'2022-05-02 12:36:45','',''),(2620709,'1','202','1036',477,'Retail Sale Id 7686',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 12:38:34','',''),(2620710,'1','202','1036',477,'Retail Sale Id 7687',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 12:43:02','',''),(2620711,'1','202','1036',477,'Retail Sale Id 7688',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 12:45:55','',''),(2620712,'1','202','1036',477,'Retail Sale Id 7690',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 12:47:58','',''),(2620713,'1','202','1036',477,'Retail Sale Id 7691',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 12:50:06','',''),(2620714,'1','202','1036',477,'Retail Sale Id 7692',6002.56,0.00,0.00,9.04,741.28,'2022-05-02 12:52:48','',''),(2620715,'1','202','1036',477,'Retail Sale Id 7693',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 12:57:07','',''),(2620716,'1','202','1036',477,'Retail Sale Id 7694',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 13:02:20','',''),(2620717,'1','202','1036',477,'Retail Sale Id 7695',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 13:06:53','',''),(2620718,'1','202','1036',477,'Retail Sale Id 7696',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 13:08:51','',''),(2620719,'1','202','1036',477,'Retail Sale Id 7697',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 13:09:26','',''),(2620720,'1','202','1036',477,'Retail Sale Id 7698',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 13:10:40','',''),(2620721,'1','202','1036',477,'Retail Sale Id 7699',3499.28,0.00,0.00,5.27,432.14,'2022-05-02 13:11:52','',''),(2620722,'1','202','1036',477,'Retail Sale Id 7700',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 13:12:49','',''),(2620723,'1','202','1036',477,'Retail Sale Id 7701',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 13:14:34','',''),(2620724,'1','202','1036',477,'Retail Sale Id 7702',1500.64,0.00,0.00,2.26,185.32,'2022-05-02 13:17:53','',''),(2620725,'1','202','1036',477,'Retail Sale Id 7703',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 13:26:51','',''),(2620726,'1','202','1036',477,'Retail Sale Id 7704',2503.28,0.00,0.00,3.77,309.14,'2022-05-02 13:30:26','',''),(2620727,'1','202','1036',477,'Retail Sale Id 7705',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 13:32:09','',''),(2620728,'1','202','1036',477,'Retail Sale Id 7706',1301.44,0.00,0.00,1.96,160.72,'2022-05-02 13:32:50','',''),(2620729,'1','202','1036',477,'Retail Sale Id 7707',3001.28,0.00,0.00,4.52,370.64,'2022-05-02 13:36:12','',''),(2620730,'1','202','1036',477,'Retail Sale Id 7708',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 13:38:45','',''),(2620731,'1','202','1036',477,'Retail Sale Id 7709',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 13:42:26','',''),(2620732,'1','202','1036',477,'Retail Sale Id 7710',2297.44,0.00,0.00,3.46,283.72,'2022-05-02 13:43:44','',''),(2620733,'1','202','1036',477,'Retail Sale Id 7711',3353.20,0.00,0.00,5.05,414.10,'2022-05-02 13:44:37','',''),(2620734,'1','202','1036',477,'Retail Sale Id 7712',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 13:47:34','',''),(2620735,'1','202','1036',477,'Retail Sale Id 7713',498.00,0.00,0.00,0.75,61.50,'2022-05-02 13:59:35','',''),(2620736,'1','202','1036',477,'Retail Sale Id 7714',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 14:00:13','',''),(2620737,'1','202','1036',477,'Retail Sale Id 7715',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 14:02:38','',''),(2620738,'1','202','1036',477,'Retail Sale Id 7716',1500.64,0.00,0.00,2.26,185.32,'2022-05-02 14:06:09','',''),(2620739,'1','202','1036',477,'Retail Sale Id 7716',1500.64,0.00,0.00,2.26,185.32,'2022-05-02 14:06:09','',''),(2620740,'1','202','1036',477,'Retail Sale Id 7717',1500.64,0.00,0.00,2.26,185.32,'2022-05-02 14:10:03','',''),(2620741,'1','202','1036',477,'Retail Sale Id 7718',6002.56,0.00,0.00,9.04,741.28,'2022-05-02 14:30:07','',''),(2620742,'1','202','1036',477,'Retail Sale Id 7719',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 14:33:15','',''),(2620743,'1','202','1036',477,'Retail Sale Id 7720',1500.64,0.00,0.00,2.26,185.32,'2022-05-02 14:37:18','',''),(2620744,'1','202','1036',477,'Retail Sale Id 7721',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 14:46:57','',''),(2620745,'1','202','1036',477,'Retail Sale Id 7722',28000.88,0.00,0.00,42.17,3457.94,'2022-05-02 14:48:07','',''),(2620746,'1','202','1036',477,'Retail Sale Id 7723',3353.20,0.00,0.00,5.05,414.10,'2022-05-02 14:51:06','',''),(2620747,'1','202','1036',477,'Retail Sale Id 7724',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 14:52:15','',''),(2620748,'1','202','1036',477,'Retail Sale Id 7725',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 14:57:51','',''),(2620749,'1','202','1036',477,'Retail Sale Id 7726',7396.96,0.00,0.00,11.14,913.48,'2022-05-02 15:03:24','',''),(2620750,'1','202','1036',477,'Retail Sale Id 7727',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 15:04:06','',''),(2620751,'1','202','1036',477,'Retail Sale Id 7728',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 15:06:21','',''),(2620752,'1','202','1036',477,'Retail Sale Id 7729',2397.04,0.00,0.00,3.61,296.02,'2022-05-02 15:06:56','',''),(2620753,'1','202','1036',477,'Retail Sale Id 7730',1500.64,0.00,0.00,2.26,185.32,'2022-05-02 15:13:03','',''),(2620754,'1','202','1036',477,'Retail Sale Id 7731',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 15:14:49','',''),(2620755,'1','202','1036',477,'Retail Sale Id 7732',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 15:22:16','',''),(2620756,'1','202','1036',477,'Retail Sale Id 7733',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 15:26:23','',''),(2620757,'1','202','1036',477,'Retail Sale Id 7734',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 15:28:45','',''),(2620758,'1','202','1036',477,'Retail Sale Id 7735',3353.20,0.00,0.00,5.05,414.10,'2022-05-02 15:41:40','',''),(2620759,'1','202','1036',477,'Retail Sale Id 7736',6002.56,0.00,0.00,9.04,741.28,'2022-05-02 15:59:26','',''),(2620760,'1','202','1036',477,'Retail Sale Id 7737',3001.28,0.00,0.00,4.52,370.64,'2022-05-02 16:00:04','',''),(2620761,'1','202','1036',477,'Retail Sale Id 7738',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 16:09:15','',''),(2620762,'1','202','1036',477,'Retail Sale Id 7739',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 16:09:40','',''),(2620763,'1','202','1036',477,'Retail Sale Id 7740',1500.64,0.00,0.00,2.26,185.32,'2022-05-02 16:18:16','',''),(2620764,'1','202','1036',477,'Retail Sale Id 7741',4999.92,0.00,0.00,7.53,617.46,'2022-05-02 16:19:59','',''),(2620765,'1','202','1036',477,'Retail Sale Id 7742',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 16:20:29','',''),(2620766,'1','202','1036',477,'Retail Sale Id 7743',1347.92,0.00,0.00,2.03,166.46,'2022-05-02 16:21:38','',''),(2620767,'1','202','1036',477,'Retail Sale Id 7745',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 16:22:35','',''),(2620768,'1','202','1036',477,'Retail Sale Id 7746',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 16:28:57','',''),(2620769,'1','202','1036',477,'Retail Sale Id 7747',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 16:42:49','',''),(2620770,'1','202','1036',477,'Retail Sale Id 7748',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 16:43:30','',''),(2620771,'1','202','1036',477,'Retail Sale Id 7749',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 16:55:22','',''),(2620772,'1','202','1036',477,'Retail Sale Id 7750',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 16:56:24','',''),(2620773,'1','202','1036',477,'Retail Sale Id 7751',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 16:59:25','',''),(2620774,'1','202','1036',477,'Retail Sale Id 7752',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 17:08:26','',''),(2620775,'1','202','1036',477,'Retail Sale Id 7753',498.00,0.00,0.00,0.75,61.50,'2022-05-02 17:21:44','',''),(2620776,'1','202','1036',477,'Retail Sale Id 7754',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 17:25:53','',''),(2620777,'1','202','1036',477,'Retail Sale Id 7755',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 17:32:31','',''),(2620778,'1','202','1036',477,'Retail Sale Id 7756',28106.00,0.00,0.00,47.00,752.00,'2022-05-02 17:34:15','',''),(2620779,'1','202','1036',477,'Retail Sale Id 7757',6998.56,0.00,0.00,10.54,864.28,'2022-05-02 17:36:11','',''),(2620780,'1','202','1036',477,'Retail Sale Id 7758',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 17:36:52','',''),(2620781,'1','202','1036',477,'Retail Sale Id 7759',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 17:37:34','',''),(2620782,'1','202','1036',477,'Retail Sale Id 7760',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 17:44:42','',''),(2620783,'1','202','1036',477,'Retail Sale Id 7761',903.04,0.00,0.00,1.36,111.52,'2022-05-02 17:46:04','',''),(2620784,'1','202','1036',477,'Retail Sale Id 7762',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 17:51:09','',''),(2620785,'1','202','1036',477,'Retail Sale Id 7763',8300.00,0.00,0.00,12.50,1025.00,'2022-05-02 17:53:01','',''),(2620786,'1','202','1036',477,'Retail Sale Id 7764',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 17:53:49','',''),(2620787,'1','202','1036',477,'Retail Sale Id 7765',3499.28,0.00,0.00,5.27,432.14,'2022-05-02 17:54:26','',''),(2620788,'1','202','1036',477,'Retail Sale Id 7766',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 17:55:07','',''),(2620789,'1','202','1036',477,'Retail Sale Id 7767',2503.28,0.00,0.00,3.77,309.14,'2022-05-02 17:59:19','',''),(2620790,'1','202','1036',477,'Retail Sale Id 7768',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 17:59:55','',''),(2620791,'1','202','1036',477,'Retail Sale Id 7769',4203.12,0.00,0.00,6.33,519.06,'2022-05-02 18:01:03','',''),(2620792,'1','202','1036',477,'Retail Sale Id 7770',3353.20,0.00,0.00,5.05,414.10,'2022-05-02 18:02:28','',''),(2620793,'1','202','1036',477,'Retail Sale Id 7771',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 18:06:49','',''),(2620794,'1','202','1036',477,'Retail Sale Id 7772',1347.92,0.00,0.00,2.03,166.46,'2022-05-02 18:15:12','',''),(2620795,'1','202','1036',477,'Retail Sale Id 7773',1500.64,0.00,0.00,2.26,185.32,'2022-05-02 18:16:47','',''),(2620796,'1','202','1036',477,'Retail Sale Id 7774',1998.64,0.00,0.00,3.01,246.82,'2022-05-02 18:18:13','',''),(2620797,'1','202','1036',477,'Retail Sale Id 7775',3997.28,0.00,0.00,6.02,493.64,'2022-05-02 18:19:29','',''),(2620798,'1','202','1036',477,'Retail Sale Id 7776',1002.64,0.00,0.00,1.51,123.82,'2022-05-02 18:20:59','',''),(2620799,'1','202','1036',477,'Retail Sale Id 7777',3499.28,0.00,0.00,5.27,432.14,'2022-05-02 18:23:50','',''),(2620800,'1','202','1036',477,'Retail Sale Id 7778',4999.92,0.00,0.00,7.53,617.46,'2022-05-02 18:24:19','',''),(2620801,'1','202','1036',477,'Retail Sale Id 7779',37022.18,0.00,0.00,61.91,990.56,'2022-05-02 19:00:40','',''),(2620802,'1','202','1036',477,'Retail Sale Id 7780',215280.00,0.00,0.00,360.00,5760.00,'2022-05-03 07:02:53','',''),(2620803,'1','202','1036',477,'Retail Sale Id 7781',8300.00,0.00,0.00,12.50,1025.00,'2022-05-03 07:21:42','',''),(2620804,'1','202','1036',477,'Retail Sale Id 7782',1002.64,0.00,0.00,1.51,123.82,'2022-05-03 07:26:41','',''),(2620805,'1','202','1036',477,'Retail Sale Id 7783',1998.64,0.00,0.00,3.01,246.82,'2022-05-03 07:32:05','',''),(2620806,'1','202','1036',477,'Retail Sale Id 7784',1998.64,0.00,0.00,3.01,246.82,'2022-05-03 07:41:08','',''),(2620807,'1','202','1036',477,'Retail Sale Id 7785',3001.28,0.00,0.00,4.52,370.64,'2022-05-03 07:42:02','',''),(2620808,'1','202','1036',477,'Retail Sale Id 7786',3997.28,0.00,0.00,6.02,493.64,'2022-05-03 07:47:56','',''),(2620809,'1','202','1036',477,'Retail Sale Id 7787',4999.92,0.00,0.00,7.53,617.46,'2022-05-03 07:54:16','',''),(2620810,'1','202','1036',477,'Retail Sale Id 7788',1998.64,0.00,0.00,3.01,246.82,'2022-05-03 07:56:18','',''),(2620811,'1','202','1036',477,'Retail Sale Id 7789',1998.64,0.00,0.00,3.01,246.82,'2022-05-03 07:58:46','',''),(2620812,'1','202','1036',477,'Retail Sale Id 7790',1998.64,0.00,0.00,3.01,246.82,'2022-05-03 08:02:44','',''),(2620813,'1','202','1036',477,'Retail Sale Id 7791',4501.92,0.00,0.00,6.78,555.96,'2022-05-03 08:03:13','',''),(2620814,'1','202','1036',477,'Retail Sale Id 7792',3997.28,0.00,0.00,6.02,493.64,'2022-05-03 08:05:01','',''),(2620815,'1','202','1036',477,'Retail Sale Id 7793',597.60,0.00,0.00,0.90,73.80,'2022-05-03 08:07:10','',''),(2620816,'1','202','1036',477,'Retail Sale Id 7794',3997.28,0.00,0.00,6.02,493.64,'2022-05-03 08:11:07','',''),(2620817,'1','202','1036',477,'Retail Sale Id 7795',697.20,0.00,0.00,1.05,86.10,'2022-05-03 08:12:32','',''),(2620818,'1','202','1036',477,'Retail Sale Id 7796',3001.28,0.00,0.00,4.52,370.64,'2022-05-03 08:15:23','',''),(2620819,'1','202','1036',477,'Retail Sale Id 7797',1002.64,0.00,0.00,1.51,123.82,'2022-05-03 08:16:06','',''),(2620820,'1','202','1036',477,'Retail Sale Id 7798',1002.64,0.00,0.00,1.51,123.82,'2022-05-03 08:17:22','',''),(2620821,'1','202','1036',477,'Retail Sale Id 7799',1998.64,0.00,0.00,3.01,246.82,'2022-05-03 08:18:00','',''),(2620822,'1','202','1036',477,'Retail Sale Id 7800',3997.28,0.00,0.00,6.02,493.64,'2022-05-03 08:21:10','',''),(2620823,'1','202','1036',477,'Retail Sale Id 7801',1998.64,0.00,0.00,3.01,246.82,'2022-05-03 08:23:07','',''),(2620824,'1','202','1036',477,'Retail Sale Id 7802',1500.64,0.00,0.00,2.26,185.32,'2022-05-03 08:33:06','',''),(2620825,'1','202','1036',477,'Retail Sale Id 7803',1002.64,0.00,0.00,1.51,123.82,'2022-05-03 08:37:45','',''),(2620826,'1','202','1036',477,'Retail Sale Id 7804',4999.92,0.00,0.00,7.53,617.46,'2022-05-03 08:39:44','',''),(2620827,'1','202','1036',477,'Retail Sale Id 7805',697.20,0.00,0.00,1.05,86.10,'2022-05-03 08:42:58','',''),(2620828,'1','202','1036',477,'Retail Sale Id 7806',3001.28,0.00,0.00,4.52,370.64,'2022-05-03 08:52:21','',''),(2620829,'1','202','1036',477,'Retail Sale Id 7807',1002.64,0.00,0.00,1.51,123.82,'2022-05-03 08:54:14','',''),(2620830,'1','202','1036',477,'Retail Sale Id 7808',38870.00,0.00,0.00,65.00,1040.00,'2022-05-03 08:56:46','',''),(2620831,'1','202','1036',477,'Retail Sale Id 7809',1500.64,0.00,0.00,2.26,185.32,'2022-05-03 08:58:46','',''),(2620832,'1','202','1036',477,'Retail Sale Id 7810',796.80,0.00,0.00,1.20,98.40,'2022-05-03 08:59:26','',''),(2620833,'1','202','1036',477,'Retail Sale Id 7811',3353.20,0.00,0.00,5.05,414.10,'2022-05-03 09:00:15','',''),(2620834,'1','202','1036',477,'Retail Sale Id 7812',3997.28,0.00,0.00,6.02,493.64,'2022-05-03 09:03:22','',''),(2620835,'1','20