-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_201
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_201`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_201` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_201`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4052 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (4037,400127,'',0,'22','1','201','PURCHASES','','2021-12-25 18:12:45',5,0.00,0.00,'','479','2021-12-25 18:12:45','479',0,0),(4038,20064,'',0,'20','1','201','SALES','','2021-12-25 18:12:57',5,0.00,0.00,'','479','2021-12-25 18:12:57','479',0,0),(4039,40066,'',0,'6.1','1','201','CASH','','2021-12-25 18:13:18',5,0.00,0.00,'','479','2021-12-25 18:13:18','479',0,0),(4040,400369,'',0,'24','1','201','SALARIES & WAGES','','2021-12-25 18:13:47',5,0.00,0.00,'','479','2021-12-25 18:13:47','479',0,0),(4041,400370,'',0,'24','1','201','PURCHASES','','2021-12-25 18:14:19',5,0.00,0.00,'','479','2021-12-25 18:14:19','479',0,0),(4042,400722,'',0,'2','1','201','ZB(LPG)1014471475','','2021-12-25 18:14:37',5,0.00,0.00,'','479','2021-12-25 18:14:37','479',0,0),(4043,400723,'',0,'2','1','201','FB(IBAL)2023855223','','2021-12-25 18:14:52',5,0.00,0.00,'','479','2021-12-25 18:14:52','479',0,0),(4044,400724,'',0,'2','1','201','E-BILLS 1015372548','','2021-12-25 18:15:45',5,0.00,0.00,'','479','2021-12-25 18:15:45','479',0,0),(4045,400725,'',0,'2','1','201','E-BILLS  IBAL 1015372548','','2021-12-25 18:15:55',5,0.00,0.00,'','479','2021-12-25 18:15:55','479',0,0),(4046,400726,'',0,'2','1','201','UNITY BANK-0024061656','','2021-12-25 18:16:19',5,0.00,0.00,'','479','2021-12-25 18:16:19','479',0,0),(4047,400727,'',0,'2','1','201','UBA YOLA-1021398099','','2021-12-25 18:16:32',5,0.00,0.00,'','479','2021-12-25 18:16:32','479',0,0),(4048,400728,'',0,'2','1','201','DANKANO-EBILLS:ZNB1014717618','','2021-12-25 18:16:45',5,0.00,0.00,'','479','2021-12-25 18:16:45','479',0,0),(4049,400729,'',0,'2','1','201','FID POS COLLECTION-5620141491','','2021-12-25 18:17:00',5,0.00,0.00,'','479','2021-12-25 18:17:00','479',0,0),(4050,400730,'',0,'2','1','201','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:34:14',5,0.00,0.00,'','792','2023-02-20 14:34:14','792',0,0),(4051,400731,'',0,'2','1','201','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:37:11',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:52:30','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4171 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (4091,'','1','201','BAMAIYYI GAS','OGUNDIPE OLAYINKA KABIRU','08133002801','olayinkakabiru@gmail.com','GUSAU','ZAMFARA','TUDUN WADA GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-25 21:27:06',5,'740','2021-12-25 21:27:06','740'),(4092,'','1','201','FOOD PLACE RESTAURENT ','FOOD PLACE','08168694444','foodplaceresturent@gmail.com','GUSAU','ZAMFARA','OPP. GOVERMENT HOUSE GASAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-25 21:30:54',5,'740','2021-12-25 21:30:54','740'),(4094,'','1','201','MR GAS ','ABDULMALIK TUKUR','08139420935','hgaya@aaranonigeria.com','GUSAU','ZAMFARA','AHMADU BELLO WAYA GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-26 09:21:08',5,'740','2021-12-26 09:21:08','740'),(4099,'','1','201','A H GAS ','ALIYU MUHAMMAD','080654241210','hgaya@aaranonigeria.com','GUSAU','ZAMFARA','SAMARU OPP KINGS FAHAT HOSPITAL','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-27 08:46:39',5,'740','2021-12-27 08:46:39','740'),(4101,'','1','201','ARRAHAMSHEED GAS','ENGR ADEGBOYEGA ','08035569282','a@gmai.com','GUSAU','ZAMFARA','KAURA OPP KAURA LOCAL GOVERMENT ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-27 14:43:25',5,'740','2021-12-27 14:43:25','740'),(4105,'','1','201','SAEN MADA GAS ','SAED','08085841898','a@gmai.com','GUSAU','ZAMFARA','MADA GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-28 21:14:32',5,'740','2021-12-28 21:14:32','740'),(4111,'','1','201','RAHA GAS','HARUNA GARBA','09049079587','a@gmai.com','GUSAU','ZAMFARA','MUSLIM FOUNDATION OPP AZUZALALA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-30 07:56:05',5,'740','2021-12-30 07:56:05','740'),(4113,'','1','201','PRECIOUS GAS ','DURIS OSIEGBU','07061305896','a@gmail.com','GUSAU','ZAMFARA','IGALAH QTRS GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-30 09:48:31',5,'740','2021-12-30 09:48:31','740'),(4114,'','1','201','ANNUR GAS','ANNUR DAMBA','07038251281','annur@gmail.com','GUSAU','ZAMFARA','JUMA\'AT MOUQUE DEMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-30 09:59:42',5,'740','2021-12-30 09:59:42','740'),(4121,'','1','201','MONDAY GAS','MONDAY','08034762852','aarano@gmail.com','GUSAU','ZAMFARA','GOVERTMENT HOUSE ROAD G R A','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-31 10:42:04',5,'740','2021-12-31 10:42:04','740'),(4131,'','1','201','ABUBAKAR GAS ','ABUBAKAR YUSUF ','08060605708','aarano@gmail.com','GUSAU','ZAMFARA','MUSLIM FUNDATION ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-02 09:25:13',5,'740','2022-01-02 09:25:13','740'),(4132,'','1','201','ZURMI GAS ','Nura DAHIRU','08030528854','zurmi@gmail.com','Zurmi','Zamfara ','Gidan Gali house','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-02 10:03:05',5,'740','2022-01-02 10:03:05','740'),(4135,'','1','201','UMMA GAS ','MUSA TSAFE','07066286825','aarano@gmail.com','GUSAU','ZAMFARA','MALAMI ROAD TSAFE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-03 08:04:00',5,'740','2022-01-03 08:04:00','740'),(4138,'','1','201','MATASA GAS','YAHYA MUHAMMAD ','07038373834','aarano@gmail.com','GUSAU','ZAMFARA','JA\'EN MUSLIM FUNDATION ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-03 15:00:05',5,'740','2022-01-03 15:00:05','740'),(4139,'','1','201','YAHYA GAS ','YAHYA MUHAMMAD ','09124322837','aarano@gmail.com','GUSAU','ZAMFARA','MUSLIM FUNDATION GUSAU ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-08 17:26:57',5,'740','2022-02-08 17:26:57','740'),(4140,'','1','201','SAMEER RESTURENTS ','SAMEER','07069962130','foodplaceresturent@gmail.com','GUSAU','ZAMFARA','TUDUN WADA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-13 15:04:51',5,'740','2022-02-13 15:04:51','740'),(4141,'','1','201','KABIRU GAS','KABIRU IBRAHIM ','09036185001','aarano@gmail.com','GUSAU','ZAMFARA','TUKUR DAN FULANI SABUWAR KASUWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-26 11:00:27',5,'740','2022-02-26 11:00:27','740'),(4142,'','1','201','MAI SHAYI','JAMILU LAWALI ','08063549002','aarano@gmail.com','GUSAU','ZAMFARA','ZA\'UYA ROAD GUSAU ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-01 14:49:41',5,'740','2022-03-03 12:21:53','740'),(4143,'','1','201','CHAMPION GAS ','MRS CHAMPION ','08037777783','aarano@gmail.com','GUSAU','ZAMFARA','TUDUN WADA ROUND ABOUT ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 12:08:37',5,'740','2022-03-02 12:08:37','740'),(4144,'','1','201','OPERATIONAL LOSS','OPERATIONAL LOSS','08035569282','aarano@gmail.com','GUSAU','ZAMFARA','OPERATIONAL LOSS','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-15 11:51:08',5,'740','2022-03-15 11:51:08','740'),(4145,'','1','201','JAMILU MAFARA GAS ','JAMILU MAFARA ','08034119797','aarano@gmail.com','GUSAU','ZAMFARA','MAFARA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-21 15:30:18',5,'740','2022-03-21 15:30:18','740'),(4146,'','1','201','CHRISTY GAS ','CHISTY AGUH ','09066153552','christy@gmail.com','GUSAU','ZAMFARA','SHAFE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-25 11:48:08',5,'740','2022-03-25 11:48:08','740'),(4147,'','1','201','SANI GAS','SANI ABDULLAHI','08163540388','a@gmail.com','GUSAU','ZAMFARA','TUDUN WADA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-15 07:33:56',5,'740','2022-04-15 07:33:56','740'),(4148,'','1','201','BUNGUDU GAS','SANI GARBA','08068123114','a@gmail.com','GUSAU','ZAMFARA','GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-20 16:12:21',5,'740','2022-05-20 16:12:21','740'),(4149,'','1','201','MAGAMI GAS','YUSUF MAGAMI','08029320192','a@gmail.com','GUSAU','ZAMFARA','MAGAMI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-19 08:53:40',5,'740','2022-06-19 08:53:40','740'),(4150,'','1','201','ABDUL ZURMI','ABDUL ZURMI GAS','09063585687','a@gmail.com','GUSAU','ZAMFARA','ZAMFARA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-16 11:52:58',5,'740','2022-07-16 11:52:58','740'),(4151,'','1','201','KAURAN NAMODA GAS','KAURAN NAMODA','08035569282','a@gmail.com','GUSAU','ZAMFARA','ZAMFARA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-21 09:04:10',5,'740','2022-07-21 09:04:10','740'),(4152,'','1','201','MUHIBBAT GAS','MUHIBBAT','07032883378','a@gmail.com','GUSAU','ZAMFARA','TSAFE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-10 17:39:02',5,'740','2022-08-10 17:39:02','740'),(4153,'','1','201','DOGO GAS','T/WADA','09068546664','a@gmail.com','GUSAU','ZAMFARA','T/WADA GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-25 16:17:07',5,'740','2022-09-25 16:17:07','740'),(4154,'','1','201','M AND T GAS','MIKE','08032022940','a@gmail.com','GUSAU','ZAMFARA','KAURA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-27 12:59:27',5,'740','2022-09-27 12:59:27','740'),(4155,'','1','201','ALBARKA GAS','ABDULKARIM IDRIS','07033907714','a@gmail.com','GUSAU','ZAMFARA','KAURA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-28 11:47:00',5,'740','2022-09-28 11:47:00','740'),(4156,'','1','201','CHILAS GAS','CHILAS','08030401899','a@gmail.com','GUSAU','ZAMFARA','GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-30 13:04:38',5,'740','2022-09-30 13:04:38','740'),(4157,'','1','201','NURA MAFARA GAS','NURA','08062550404','a@gmail.com','GUSAU','ZAMFARA','TALATAR MAFARA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-02 11:36:33',5,'740','2022-10-02 11:36:33','740'),(4158,'','1','201','RAFMA GAS VENTURES','ALH TAJUDEEN ','07063671501','a@gmail','KATSINA','KATSINA','funtua','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-10 11:50:05',5,'740','2022-10-10 11:50:05','740'),(4159,'','1','201','REHOBOTH GAS ','JAMES','08161113337','a@gmail','GUSAU','ZAMFARA','UNGUWAR DALATU ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-11 15:33:06',5,'740','2022-10-11 15:33:06','740'),(4160,'','1','201','B/MAGAJI GAS','BELLO ABDULLAHI','08144257846','a@gmail','GUSAU','ZAMFARA','ZAMFARA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-12 15:47:32',5,'740','2022-10-12 15:47:32','740'),(4161,'','1','201','K K GAS FUNTUA','BABANGIDA','08032466447','a@gmail','KATSINA','KATSINA','FUNTUA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-16 10:49:34',5,'740','2022-10-16 10:49:34','740'),(4162,'','1','201','DADA GAS','TUKUR YA\'U','07068049633','a@gmail','ZAMFARA','ZAMFARA','GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-25 18:06:39',5,'740','2022-10-25 18:06:39','740'),(4163,'','1','201','AMINU HABIBU','BASHA GAS','09013881771','a@gmail','GUSAU','ZAMFARA','KAURA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-30 10:13:17',5,'740','2022-10-30 10:13:17','740'),(4164,'','1','201','BASHA GAS','AMINU HABIBU','09013881771','a@gmail','GUSAU','ZAMFARA','KAURA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-30 10:14:39',5,'740','2022-10-30 10:14:39','740'),(4165,'','1','201','EJIKE GAS','EJIKE GAS','07030150828','a@gmail','GUSAU','ZAMFARA','GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-03 11:22:56',5,'740','2022-11-03 11:22:56','740'),(4166,'','1','201','M.GAS FUNTUA','MANSUR FUNTUA','08039671830','a@gmail','KATSINA','KATSINA','FUNTUA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-06 09:32:10',5,'740','2022-11-06 09:32:10','740'),(4167,'','1','201','AMANA GAS','SAIFULLAHI','07036797250','a@gmail','KATSINA','KATSINA','FASKARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-06 12:24:08',5,'740','2022-11-06 12:24:08','740'),(4168,'','1','201','COLLINS GINI GAS ','COLINS','08034472201','a@gmail','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-07 15:39:37',5,'740','2022-11-07 15:39:37','740'),(4169,'','1','201','ABSAN COOKING GAS','SUNUSI LIMAN','08062243390','a@gmail','ZAMFARA','ZAMFARA','GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-10 09:47:45',5,'740','2022-11-10 09:47:45','740'),(4170,'','1','201','ASP MURADUN','ZAYYANU','08064337928','a@gmail','GUSAU','ZAMFARA','MARADUN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-17 15:32:04',5,'740','2022-11-17 15:32:04','740');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3072 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','201','1037',3071,'5','LPG NOZZLE ',378093.17,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=251678 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','201',248839,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'740',0.00,0.00,'740','2021-12-25 21:38:39','740','2021-12-25 21:39:16',10,0),('1','201',248848,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'740',0.00,0.00,'740','2021-12-25 21:58:23','740','2021-12-25 21:58:56',10,0),('1','201',248900,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'740',0.00,0.00,'740','2021-12-26 18:24:57','740','2021-12-26 18:25:17',10,0),('1','201',249101,'DAILY SHIFT ','2021-12-27','2021-12-27 00:00:00',NULL,'740',0.00,0.00,'740','2021-12-27 18:34:36','740','2021-12-27 18:34:55',10,0),('1','201',249344,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'740',0.00,0.00,'740','2021-12-28 18:59:02','740','2021-12-28 18:59:58',10,0),('1','201',249590,'DAILY SHIFT ','2021-12-29','2021-12-29 00:00:00',NULL,'740',0.00,0.00,'740','2021-12-29 20:01:59','740','2021-12-29 20:04:14',10,0),('1','201',249854,'DAILY SHIFT ','2021-12-30','2021-12-30 00:00:00',NULL,'740',0.00,0.00,'740','2021-12-30 20:50:57','740','2021-12-30 20:51:28',10,0),('1','201',250111,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'740',0.00,0.00,'740','2021-12-31 18:46:38','740','2021-12-31 18:47:25',10,0),('1','201',250334,'DAILY SHIFT ','2022-01-01','2022-01-01 00:00:00',NULL,'740',0.00,0.00,'740','2022-01-01 18:21:17','740','2022-01-01 18:24:00',10,0),('1','201',250573,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'740',0.00,0.00,'740','2022-01-02 18:03:52','740','2022-01-02 18:04:13',10,0),('1','201',250818,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'740',0.00,0.00,'740','2022-01-03 17:45:23','740','2022-01-03 17:45:42',10,0),('1','201',251049,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'740',0.00,0.00,'740','2022-01-04 18:28:02','740','2022-01-04 18:29:06',10,0),('1','201',251275,'DAILY SHIFT ','2022-01-05','2022-01-05 00:00:00',NULL,'740',0.00,0.00,'740','2022-01-05 13:34:46','740','2022-01-05 13:35:23',10,0),('1','201',251276,'DAILY SHIFT ','2022-02-02','2022-02-02 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-02 20:19:29','740','2022-02-02 20:20:17',10,0),('1','201',251277,'DAILY SHIFT ','2022-02-03','2022-02-03 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-03 20:15:56','740','2022-02-03 20:16:30',10,0),('1','201',251278,'DAILY SHIFT ','2022-02-04','2022-02-04 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-04 19:38:52','740','2022-02-04 19:39:11',10,0),('1','201',251279,'DAILY SHIFT ','2022-02-05','2022-02-05 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-05 19:13:24','740','2022-02-05 19:13:46',10,0),('1','201',251280,'DAILY SHIFT ','2022-02-06','2022-02-06 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-06 19:34:53','740','2022-02-06 19:36:18',10,0),('1','201',251281,'DAILY SHIFT ','2022-02-07','2022-02-07 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-07 19:36:42','740','2022-02-07 19:37:00',10,0),('1','201',251282,'DAILY SHIFT ','2022-02-08','2022-02-08 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-08 19:33:28','740','2022-02-08 19:33:47',10,0),('1','201',251283,'DAILY SHIFT ','2022-02-09','2022-02-09 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-09 19:06:52','740','2022-02-09 19:07:16',10,0),('1','201',251284,'DAILY SHIFT ','2022-02-10','2022-02-10 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-10 19:17:01','740','2022-02-10 19:17:20',10,0),('1','201',251285,'DAILY SHIFT ','2022-02-11','2022-02-11 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-11 20:16:11','740','2022-02-11 20:16:57',10,0),('1','201',251286,'DAILY SHIFT ','2022-02-12','2022-02-12 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-12 19:42:41','740','2022-02-12 19:42:59',10,0),('1','201',251287,'DAILY SHIFT ','2022-02-13','2022-02-13 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-13 20:00:06','740','2022-02-13 20:01:13',10,0),('1','201',251288,'DAILY SHIFT ','2022-02-14','2022-02-14 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-14 19:24:16','740','2022-02-14 19:25:10',10,0),('1','201',251289,'DAILY SHIFT ','2022-02-15','2022-02-15 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-15 20:05:15','740','2022-02-15 20:05:39',10,0),('1','201',251290,'DAILY SHIFT ','2022-02-16','2022-02-16 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-16 19:48:24','740','2022-02-16 19:48:45',10,0),('1','201',251291,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-17 19:17:20','740','2022-02-17 19:17:39',10,0),('1','201',251292,'DAILY SHIFT ','2022-02-18','2022-02-18 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-18 19:20:10','740','2022-02-18 19:20:24',10,0),('1','201',251293,'DAILY SHIFT ','2022-02-19','2022-02-19 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-19 20:48:38','740','2022-02-19 20:49:11',10,0),('1','201',251294,'DAILY SHIFT ','2022-02-20','2022-02-20 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-20 19:41:57','740','2022-02-20 19:42:16',10,0),('1','201',251295,'DAILY SHIFT ','2022-02-21','2022-02-21 00:00:00',NULL,'740',0.00,0.00,'740','2022-02-21 19:12:27','740','2022-02-21 19:12:53',10,0),('1','201',251296,'DAILY SHIFT ','2022-02-22','2022-02-22 07:48:43','2022-02-23 07:48:43','740',0.00,0.00,'740','2022-02-22 19:25:23','740','2022-02-22 19:25:39',10,0),('1','201',251297,'DAILY SHIFT ','2022-02-23','2022-02-23 07:22:15','2022-02-24 07:22:15','740',0.00,0.00,'740','2022-02-23 19:52:35','740','2022-02-23 19:53:28',10,0),('1','201',251298,'DAILY SHIFT ','2022-02-24','2022-02-24 06:49:59','2022-02-25 06:49:59','740',0.00,0.00,'740','2022-02-24 20:03:20','740','2022-02-24 20:03:41',10,0),('1','201',251299,'DAILY SHIFT ','2022-02-25','2022-02-25 06:19:26','2022-02-26 06:19:26','740',0.00,0.00,'740','2022-02-25 19:19:30','740','2022-02-25 19:19:47',10,0),('1','201',251300,'DAILY SHIFT ','2022-02-26','2022-02-26 06:14:06','2022-02-27 06:14:06','740',0.00,0.00,'740','2022-02-26 19:32:28','740','2022-02-26 19:32:43',10,0),('1','201',251301,'DAILY SHIFT ','2022-02-27','2022-02-27 06:09:33','2022-02-28 06:09:33','740',0.00,0.00,'740','2022-02-27 18:56:21','740','2022-02-27 18:56:37',10,0),('1','201',251302,'DAILY SHIFT ','2022-02-28','2022-02-28 06:58:43','2022-03-01 06:58:43','740',0.00,0.00,'740','2022-02-28 19:18:30','740','2022-02-28 19:18:47',10,0),('1','201',251303,'DAILY SHIFT ','2022-03-01','2022-03-01 06:38:51','2022-03-02 06:38:51','740',0.00,0.00,'740','2022-03-01 19:02:09','740','2022-03-01 19:02:25',10,0),('1','201',251304,'DAILY SHIFT ','2022-03-02','2022-03-02 06:06:12','2022-03-03 06:06:12','740',0.00,0.00,'740','2022-03-02 19:40:08','740','2022-03-02 19:40:28',10,0),('1','201',251305,'DAILY SHIFT ','2022-03-03','2022-03-03 06:27:38','2022-03-04 06:27:38','740',0.00,0.00,'740','2022-03-03 20:12:19','740','2022-03-03 20:12:55',10,0),('1','201',251306,'DAILY SHIFT ','2022-03-04','2022-03-04 06:41:59','2022-03-05 06:41:59','740',0.00,0.00,'740','2022-03-04 19:23:21','740','2022-03-04 19:23:36',10,0),('1','201',251307,'DAILY SHIFT ','2022-03-05','2022-03-05 06:23:34','2022-03-06 06:23:34','740',0.00,0.00,'740','2022-03-05 19:15:47','740','2022-03-05 19:16:09',10,0),('1','201',251308,'DAILY SHIFT ','2022-03-06','2022-03-06 06:57:47','2022-03-07 06:57:47','740',0.00,0.00,'740','2022-03-06 19:19:59','740','2022-03-06 19:20:31',10,0),('1','201',251309,'DAILY SHIFT','2022-03-07','2022-03-07 07:34:41','2022-03-08 07:34:41','740',0.00,0.00,'740','2022-03-07 22:38:15','740','2022-03-07 22:38:34',10,0),('1','201',251310,'DAILY SHIFT ','2022-03-08','2022-03-08 06:34:44','2022-03-09 06:34:44','740',0.00,0.00,'740','2022-03-08 20:09:36','740','2022-03-08 20:09:53',10,0),('1','201',251311,'OPERATIONAL LOSS','2022-03-15','2022-03-15 11:45:40','2022-03-16 11:45:40','740',0.00,0.00,'740','2022-03-15 12:41:36','740','2022-03-15 12:41:56',10,0),('1','201',251312,'DAILY SHIFT','2022-03-15','2022-03-15 17:36:39','2022-03-16 17:36:39','740',0.00,0.00,'740','2022-03-15 20:07:47','740','2022-03-15 20:08:11',10,0),('1','201',251313,'DAILY SHIFT','2022-03-16','2022-03-16 07:56:15','2022-03-17 07:56:15','740',0.00,0.00,'740','2022-03-16 18:58:25','740','2022-03-16 18:58:44',10,0),('1','201',251314,'DAILY SHIFT ','2022-03-17','2022-03-17 07:05:14','2022-03-18 07:05:14','740',0.00,0.00,'740','2022-03-17 18:55:33','740','2022-03-17 19:32:38',10,0),('1','201',251315,'DAILY SHIFT ','2022-03-18','2022-03-18 06:54:46','2022-03-19 06:54:46','740',0.00,0.00,'740','2022-03-18 19:31:47','740','2022-03-18 19:32:03',10,0),('1','201',251316,'DAILY SHIFT ','2022-03-19','2022-03-19 06:39:55','2022-03-20 06:39:55','740',0.00,0.00,'740','2022-03-19 18:54:23','740','2022-03-19 18:54:40',10,0),('1','201',251317,'DAILY SHIFT ','2022-03-20','2022-03-20 06:35:38','2022-03-21 06:35:38','740',0.00,0.00,'740','2022-03-20 19:12:34','740','2022-03-20 19:13:02',10,0),('1','201',251318,'DAILY SHIFT ','2022-03-21','2022-03-21 07:46:37','2022-03-22 07:46:37','740',0.00,0.00,'740','2022-03-21 19:38:39','740','2022-03-21 19:38:57',10,0),('1','201',251319,'DAILY SHIFT ','2022-03-22','2022-03-22 06:21:51','2022-03-23 06:21:51','740',0.00,0.00,'740','2022-03-22 19:36:41','740','2022-03-22 19:36:57',10,0),('1','201',251320,'DAILY SHIFT ','2022-03-23','2022-03-23 06:44:34','2022-03-24 06:44:34','740',0.00,0.00,'740','2022-03-23 19:26:33','740','2022-03-23 19:26:55',10,0),('1','201',251321,'DAILY SHIFT ','2022-03-24','2022-03-24 06:05:13','2022-03-25 06:05:13','740',0.00,0.00,'740','2022-03-24 19:27:12','740','2022-03-24 19:27:26',10,0),('1','201',251322,'DAILY SHIFT ','2022-03-25','2022-03-25 06:21:36','2022-03-26 06:21:36','740',0.00,0.00,'740','2022-03-25 19:15:37','740','2022-03-25 19:15:55',10,0),('1','201',251323,'DAILY SHIFT','2022-03-26','2022-03-26 08:23:53','2022-03-27 08:23:53','740',0.00,0.00,'740','2022-03-26 19:23:11','740','2022-03-26 19:23:40',10,0),('1','201',251324,'DAILY SHIFT ','2022-03-27','2022-03-27 07:15:52','2022-03-28 07:15:52','740',0.00,0.00,'740','2022-03-27 18:56:32','740','2022-03-27 18:56:48',10,0),('1','201',251325,'DAILY SHIFT ','2022-03-28','2022-03-28 07:20:01','2022-03-29 07:20:01','740',0.00,0.00,'740','2022-03-28 19:14:09','740','2022-03-28 19:15:17',10,0),('1','201',251326,'DAILY SHIFT ','2022-03-29','2022-03-29 06:09:08','2022-03-30 06:09:08','740',0.00,0.00,'740','2022-03-29 19:26:24','740','2022-03-29 19:26:40',10,0),('1','201',251327,'DAILY SHIFT ','2022-03-30','2022-03-30 06:09:55','2022-03-31 06:09:55','740',0.00,0.00,'740','2022-03-30 20:03:27','740','2022-03-30 20:04:06',10,0),('1','201',251328,'DAILY SHIFT ','2022-03-31','2022-03-31 06:21:09','2022-04-01 06:21:09','740',0.00,0.00,'740','2022-03-31 19:55:52','740','2022-03-31 19:56:11',10,0),('1','201',251329,'DAILY SHIFT ','2022-04-01','2022-04-01 06:53:50','2022-04-02 06:53:50','740',0.00,0.00,'740','2022-04-01 20:13:35','740','2022-04-01 20:13:49',10,0),('1','201',251330,'DAILY SHIFT ','2022-04-02','2022-04-02 06:30:57','2022-04-03 06:30:57','740',0.00,0.00,'740','2022-04-02 20:34:24','740','2022-04-02 20:34:39',10,0),('1','201',251331,'DAILY SHIFT ','2022-04-03','2022-04-03 06:34:43','2022-04-04 06:34:43','740',0.00,0.00,'740','2022-04-03 19:55:33','740','2022-04-03 19:55:51',10,0),('1','201',251332,'DAILY SHIFT ','2022-04-04','2022-04-04 06:59:28','2022-04-05 06:59:28','740',0.00,0.00,'740','2022-04-04 20:24:06','740','2022-04-04 20:24:25',10,0),('1','201',251333,'DAILY SHIFT ','2022-04-05','2022-04-05 06:53:53','2022-04-06 06:53:53','740',0.00,0.00,'740','2022-04-05 20:46:24','740','2022-04-05 20:46:44',10,0),('1','201',251334,'DAILY SHIFT ','2022-04-14','2022-04-14 07:37:02','2022-04-15 07:37:02','740',0.00,0.00,'740','2022-04-14 19:22:39','740','2022-04-14 19:23:03',10,0),('1','201',251335,'DAILY SHIFT ','2022-04-15','2022-04-15 07:33:03','2022-04-16 07:33:03','740',0.00,0.00,'740','2022-04-15 18:42:11','740','2022-04-15 18:45:11',10,0),('1','201',251336,'DAILY SHIFT','2022-04-16','2022-04-16 08:12:07','2022-04-17 08:12:07','740',0.00,0.00,'740','2022-04-16 18:52:11','740','2022-04-16 18:53:14',10,0),('1','201',251337,'Shift','2022-04-17','2022-04-17 07:14:54','2022-04-18 07:14:54','740',0.00,0.00,'740','2022-04-17 18:54:04','740','2022-04-17 18:54:33',10,0),('1','201',251338,'DAILY SHIFT','2022-04-18','2022-04-18 07:04:12','2022-04-19 07:04:12','740',0.00,0.00,'740','2022-04-18 18:43:07','740','2022-04-18 19:27:37',10,0),('1','201',251339,'DAILY SHIFT','2022-04-19','2022-04-19 07:10:20','2022-04-20 07:10:20','740',0.00,0.00,'740','2022-04-19 18:42:04','740','2022-04-19 18:42:27',10,0),('1','201',251340,'DAILY SHIFT','2022-04-20','2022-04-20 07:24:59','2022-04-21 07:24:59','740',0.00,0.00,'740','2022-04-20 18:46:23','740','2022-04-20 18:46:48',10,0),('1','201',251341,'DAILY SHIFT','2022-04-21','2022-04-21 07:10:04','2022-04-22 07:10:04','740',0.00,0.00,'740','2022-04-21 18:32:49','740','2022-04-21 18:33:18',10,0),('1','201',251342,'DAILY SHIFT','2022-04-22','2022-04-22 07:16:32','2022-04-23 07:16:32','740',0.00,0.00,'740','2022-04-22 18:34:14','740','2022-04-22 18:34:42',10,0),('1','201',251343,'DAILY SHIFT','2022-04-23','2022-04-23 07:10:16','2022-04-24 07:10:16','740',0.00,0.00,'740','2022-04-23 18:38:12','740','2022-04-23 18:38:35',10,0),('1','201',251344,'DAILY SHIFT','2022-04-24','2022-04-24 07:07:30','2022-04-25 07:07:30','740',0.00,0.00,'740','2022-04-24 18:34:28','740','2022-04-24 18:34:51',10,0),('1','201',251345,'DAILY SHIFT','2022-04-25','2022-04-25 07:02:26','2022-04-26 07:02:26','740',0.00,0.00,'740','2022-04-25 18:47:08','740','2022-04-25 18:47:54',10,0),('1','201',251346,'DAILY SHIFT','2022-04-26','2022-04-26 07:04:22','2022-04-27 07:04:22','740',0.00,0.00,'740','2022-04-26 18:44:34','740','2022-04-26 18:46:02',10,0),('1','201',251347,'DAILY SHIFT','2022-04-27','2022-04-27 07:01:32','2022-04-28 07:01:32','740',0.00,0.00,'740','2022-04-27 18:48:37','740','2022-04-27 18:49:04',10,0),('1','201',251348,'DAILY SHIFT','2022-04-28','2022-04-28 06:48:02','2022-04-29 06:48:02','740',0.00,0.00,'740','2022-04-28 18:38:09','740','2022-04-28 18:39:15',10,0),('1','201',251349,'DAILY SHIFT','2022-04-29','2022-04-29 06:59:45','2022-04-30 06:59:45','740',0.00,0.00,'740','2022-04-29 19:00:11','740','2022-04-29 19:06:15',10,0),('1','201',251350,'DAILY SHIFT','2022-04-30','2022-04-30 07:00:55','2022-05-01 07:00:55','740',0.00,0.00,'740','2022-04-30 18:54:47','740','2022-04-30 18:57:01',10,0),('1','201',251351,'DAILY SHIFT','2022-05-01','2022-05-01 07:01:40','2022-05-02 07:01:40','740',0.00,0.00,'740','2022-05-01 19:26:51','740','2022-05-01 19:29:18',10,0),('1','201',251352,'DAILY SHIFT','2022-05-02','2022-05-02 09:57:25','2022-05-03 09:57:25','740',0.00,0.00,'740','2022-05-02 18:25:42','740','2022-05-02 18:35:03',10,0),('1','201',251353,'DAILY SHIFT','2022-05-03','2022-05-03 06:51:39','2022-05-04 06:51:39','740',0.00,0.00,'740','2022-05-03 18:51:32','740','2022-05-03 18:53:25',10,0),('1','201',251354,'DAILY SHIFT','2022-05-04','2022-05-04 07:04:59','2022-05-05 07:04:59','740',0.00,0.00,'740','2022-05-04 18:33:29','740','2022-05-04 18:35:21',10,0),('1','201',251355,'DAILY SHIFT','2022-05-05','2022-05-05 06:57:59','2022-05-06 06:57:59','740',0.00,0.00,'740','2022-05-05 18:40:20','740','2022-05-05 18:41:31',10,0),('1','201',251356,'DAILY SHIFT','2022-05-06','2022-05-06 06:55:45','2022-05-07 06:55:45','740',0.00,0.00,'740','2022-05-06 18:44:28','740','2022-05-06 18:52:58',10,0),('1','201',251357,'DAILY SHIFT','2022-05-07','2022-05-07 06:59:47','2022-05-08 06:59:47','740',0.00,0.00,'740','2022-05-07 17:05:08','740','2022-05-07 17:05:29',10,0),('1','201',251358,'Shift','2022-05-07','2022-05-07 17:14:24','2022-05-08 17:14:24','740',0.00,0.00,'740','2022-05-07 18:07:45','740','2022-05-07 18:08:02',10,0),('1','201',251359,'DAILY SHIFT','2022-05-07','2022-05-07 18:08:27','2022-05-08 18:08:27','740',0.00,0.00,'740','2022-05-07 19:01:00','740','2022-05-07 19:01:36',10,0),('1','201',251360,'DAILY SHIFT','2022-05-08','2022-05-08 07:09:30','2022-05-09 07:09:30','740',0.00,0.00,'740','2022-05-08 18:54:05','740','2022-05-08 18:55:25',10,0),('1','201',251361,'DAILY SHIFT','2022-05-09','2022-05-09 07:00:37','2022-05-10 07:00:37','740',0.00,0.00,'740','2022-05-09 18:51:23','740','2022-05-09 18:51:59',10,0),('1','201',251362,'DAILY SHIFT','2022-05-10','2022-05-10 06:58:39','2022-05-11 06:58:39','740',0.00,0.00,'740','2022-05-10 18:56:46','740','2022-05-10 18:57:30',10,0),('1','201',251363,'DAILY SHIFT','2022-05-11','2022-05-11 06:56:51','2022-05-12 06:56:51','740',0.00,0.00,'740','2022-05-11 19:00:27','740','2022-05-11 19:01:47',10,0),('1','201',251364,'DAILY SHIFT','2022-05-12','2022-05-12 07:04:00','2022-05-13 07:04:00','740',0.00,0.00,'740','2022-05-12 19:01:17','740','2022-05-12 19:02:03',10,0),('1','201',251365,'DAILY SHIFT','2022-05-13','2022-05-13 06:58:06','2022-05-14 06:58:06','740',0.00,0.00,'740','2022-05-13 18:59:45','740','2022-05-13 19:05:30',10,0),('1','201',251366,'DAILY SHIFT','2022-05-14','2022-05-14 06:59:24','2022-05-15 06:59:24','740',0.00,0.00,'740','2022-05-14 18:59:19','740','2022-05-14 18:59:44',10,0),('1','201',251367,'Shift','2022-05-15','2022-05-15 06:47:56','2022-05-16 06:47:56','740',0.00,0.00,'740','2022-05-15 19:03:57','740','2022-05-15 19:04:32',10,0),('1','201',251368,'DAILY SHIFT','2022-05-16','2022-05-16 07:16:21','2022-05-17 07:16:21','740',0.00,0.00,'740','2022-05-16 19:06:35','740','2022-05-16 19:07:00',10,0),('1','201',251369,'DAILY SHIFT','2022-05-17','2022-05-17 06:59:27','2022-05-18 06:59:27','740',0.00,0.00,'740','2022-05-17 19:03:09','740','2022-05-17 19:03:35',10,0),('1','201',251370,'DAILY SHIFT','2022-05-18','2022-05-18 06:52:43','2022-05-19 06:52:43','740',0.00,0.00,'740','2022-05-18 18:54:15','740','2022-05-18 18:55:27',10,0),('1','201',251371,'DAILY SHIFT','2022-05-19','2022-05-19 06:34:41','2022-05-20 06:34:41','740',0.00,0.00,'740','2022-05-19 18:45:07','740','2022-05-19 18:45:32',10,0),('1','201',251372,'DAILY SHIFT','2022-05-20','2022-05-20 06:48:39','2022-05-21 06:48:39','740',0.00,0.00,'740','2022-05-20 18:54:51','740','2022-05-20 18:55:16',10,0),('1','201',251373,'DAILY SHIFT','2022-05-21','2022-05-21 06:50:42','2022-05-22 06:50:42','740',0.00,0.00,'740','2022-05-21 19:23:04','740','2022-05-21 19:23:45',10,0),('1','201',251374,'DAILY SHIFT','2022-05-22','2022-05-22 07:05:25','2022-05-23 07:05:25','740',0.00,0.00,'740','2022-05-22 18:55:37','740','2022-05-22 18:56:01',10,0),('1','201',251375,'DAILY SHIFT','2022-05-23','2022-05-23 07:07:28','2022-05-24 07:07:28','740',0.00,0.00,'740','2022-05-23 18:52:58','740','2022-05-23 18:53:22',10,0),('1','201',251376,'DAILY SHIFT','2022-05-24','2022-05-24 06:41:25','2022-05-25 06:41:25','740',0.00,0.00,'740','2022-05-24 19:01:40','740','2022-05-24 19:02:06',10,0),('1','201',251377,'DAILY SHIFT','2022-05-25','2022-05-25 06:49:25','2022-05-26 06:49:25','740',0.00,0.00,'740','2022-05-25 18:59:20','740','2022-05-25 19:33:39',10,0),('1','201',251378,'DAILY SHIFT','2022-05-26','2022-05-26 06:53:01','2022-05-27 06:53:01','740',0.00,0.00,'740','2022-05-26 18:40:22','740','2022-05-26 18:41:08',10,0),('1','201',251379,'DAILY SHIFT','2022-05-27','2022-05-27 06:41:17','2022-05-28 06:41:17','740',0.00,0.00,'740','2022-05-27 18:50:39','740','2022-05-27 18:51:01',10,0),('1','201',251380,'DAILY SHIFT','2022-05-28','2022-05-28 06:30:33','2022-05-29 06:30:33','740',0.00,0.00,'740','2022-05-28 18:42:34','740','2022-05-28 18:43:02',10,0),('1','201',251381,'DAILY SHIFT','2022-05-29','2022-05-29 06:29:38','2022-05-30 06:29:38','740',0.00,0.00,'740','2022-05-29 18:55:08','740','2022-05-29 18:55:34',10,0),('1','201',251382,'DAILY SHIFT','2022-05-30','2022-05-30 06:22:59','2022-05-31 06:22:59','740',0.00,0.00,'740','2022-05-30 19:01:33','740','2022-05-30 19:03:01',10,0),('1','201',251383,'DAILY SHIFT','2022-05-31','2022-05-31 06:49:07','2022-06-01 06:49:07','740',0.00,0.00,'740','2022-05-31 19:03:52','740','2022-05-31 19:04:18',10,0),('1','201',251384,'DAILY SHIFT','2022-06-01','2022-06-01 06:47:46','2022-06-02 06:47:46','740',0.00,0.00,'740','2022-06-01 19:03:07','740','2022-06-01 19:03:35',10,0),('1','201',251385,'DAILY SHIFT','2022-06-02','2022-06-02 06:42:10','2022-06-03 06:42:10','740',0.00,0.00,'740','2022-06-02 19:16:48','740','2022-06-02 19:17:09',10,0),('1','201',251386,'DAILY SHIFT','2022-06-03','2022-06-03 06:59:47','2022-06-04 06:59:47','740',0.00,0.00,'740','2022-06-03 19:19:12','740','2022-06-03 19:19:41',10,0),('1','201',251387,'DAILY SHIFT','2022-06-04','2022-06-04 07:07:05','2022-06-05 07:07:05','740',0.00,0.00,'740','2022-06-04 18:48:52','740','2022-06-04 18:49:15',10,0),('1','201',251388,'DAILY SHIFT','2022-06-05','2022-06-05 06:44:34','2022-06-06 06:44:34','740',0.00,0.00,'740','2022-06-05 19:01:16','740','2022-06-05 19:01:48',10,0),('1','201',251389,'DAILY SHIFT','2022-06-06','2022-06-06 06:33:17','2022-06-07 06:33:17','740',0.00,0.00,'740','2022-06-06 18:43:41','740','2022-06-06 18:44:03',10,0),('1','201',251390,'DAILY SHIFT','2022-06-07','2022-06-07 06:36:10','2022-06-08 06:36:10','740',0.00,0.00,'740','2022-06-07 18:49:06','740','2022-06-07 18:50:07',10,0),('1','201',251391,'DAILY SHIFT','2022-06-08','2022-06-08 06:30:25','2022-06-09 06:30:25','740',0.00,0.00,'740','2022-06-08 19:04:20','740','2022-06-08 19:05:04',10,0),('1','201',251392,'DAILY SHIFT','2022-06-09','2022-06-09 06:29:52','2022-06-10 06:29:52','740',0.00,0.00,'740','2022-06-09 19:06:15','740','2022-06-09 19:06:54',10,0),('1','201',251393,'DAILY SHIFT','2022-06-10','2022-06-10 06:24:15','2022-06-11 06:24:15','740',0.00,0.00,'740','2022-06-10 18:02:07','740','2022-06-10 18:02:32',10,0),('1','201',251394,'DAILY SHIFT','2022-06-11','2022-06-11 06:40:43','2022-06-12 06:40:43','740',0.00,0.00,'740','2022-06-11 19:09:38','740','2022-06-11 19:10:05',10,0),('1','201',251395,'DAILY SHIFT','2022-06-12','2022-06-12 06:48:16','2022-06-13 06:48:16','740',0.00,0.00,'740','2022-06-12 19:01:07','740','2022-06-12 19:01:32',10,0),('1','201',251396,'DAILY SHIFT','2022-06-13','2022-06-13 06:30:00','2022-06-14 06:30:00','740',0.00,0.00,'740','2022-06-13 19:00:48','740','2022-06-13 19:01:10',10,0),('1','201',251397,'DAILY SHIFT','2022-06-14','2022-06-14 06:46:31','2022-06-15 06:46:31','740',0.00,0.00,'740','2022-06-14 18:58:04','740','2022-06-14 18:58:30',10,0),('1','201',251398,'DAILY SHIFT','2022-06-15','2022-06-15 06:37:31','2022-06-16 06:37:31','740',0.00,0.00,'740','2022-06-15 19:01:40','740','2022-06-15 19:02:10',10,0),('1','201',251399,'DAILY SHIFT','2022-06-16','2022-06-16 06:52:09','2022-06-17 06:52:09','740',0.00,0.00,'740','2022-06-16 18:50:34','740','2022-06-16 18:51:01',10,0),('1','201',251400,'DAILY SHIFT','2022-06-17','2022-06-17 08:20:25','2022-06-18 08:20:25','740',0.00,0.00,'740','2022-06-17 11:39:58','740','2022-06-17 11:40:21',10,0),('1','201',251401,'Shift','2022-06-18','2022-06-18 19:31:37','2022-06-19 19:31:37','740',0.00,0.00,'740','2022-06-19 06:52:32','740','2022-06-19 06:53:00',10,0),('1','201',251402,'DAILY SHIFT','2022-06-19','2022-06-19 06:54:54','2022-06-20 06:54:54','740',0.00,0.00,'740','2022-06-19 19:08:03','740','2022-06-19 19:08:25',10,0),('1','201',251403,'DAILY SHIFT','2022-06-20','2022-06-20 06:44:51','2022-06-21 06:44:51','740',0.00,0.00,'740','2022-06-20 19:12:02','740','2022-06-20 19:12:29',10,0),('1','201',251404,'DAILY SHIFT','2022-06-21','2022-06-21 06:54:36','2022-06-22 06:54:36','740',0.00,0.00,'740','2022-06-21 18:55:39','740','2022-06-21 18:57:56',10,0),('1','201',251405,'DAILY SHIFT','2022-06-22','2022-06-22 06:53:53','2022-06-23 06:53:53','740',0.00,0.00,'740','2022-06-22 19:10:24','740','2022-06-22 19:10:48',10,0),('1','201',251406,'DAILY SHIFT','2022-06-23','2022-06-23 06:54:36','2022-06-24 06:54:36','740',0.00,0.00,'740','2022-06-23 19:08:55','740','2022-06-23 19:09:24',10,0),('1','201',251407,'DAILY SHIFT','2022-06-24','2022-06-24 06:54:27','2022-06-25 06:54:27','740',0.00,0.00,'740','2022-06-24 19:11:42','740','2022-06-24 19:12:08',10,0),('1','201',251408,'DAILY SHIFT','2022-06-25','2022-06-25 07:02:53','2022-06-26 07:02:53','740',0.00,0.00,'740','2022-06-25 19:10:00','740','2022-06-25 19:10:27',10,0),('1','201',251409,'DAILY SHIFT','2022-06-26','2022-06-26 06:50:59','2022-06-27 06:50:59','740',0.00,0.00,'740','2022-06-26 18:55:38','740','2022-06-26 18:56:01',10,0),('1','201',251410,'DAILY SHIFT','2022-06-27','2022-06-27 06:49:04','2022-06-28 06:49:04','740',0.00,0.00,'740','2022-06-27 18:52:21','740','2022-06-27 18:52:46',10,0),('1','201',251411,'DAILY SHIFT','2022-06-28','2022-06-28 06:50:52','2022-06-29 06:50:52','740',0.00,0.00,'740','2022-06-28 18:57:31','740','2022-06-28 18:57:56',10,0),('1','201',251412,'DAILY SHIFT','2022-06-29','2022-06-29 06:58:04','2022-06-30 06:58:04','740',0.00,0.00,'740','2022-06-29 19:02:02','740','2022-06-29 19:02:24',10,0),('1','201',251413,'DAILY SHIFT','2022-06-30','2022-06-30 06:58:02','2022-07-01 06:58:02','740',0.00,0.00,'740','2022-06-30 19:07:49','740','2022-06-30 19:08:11',10,0),('1','201',251414,'DAILY SHIFT','2022-07-01','2022-07-01 06:43:54','2022-07-02 06:43:54','740',0.00,0.00,'740','2022-07-01 19:08:31','740','2022-07-01 19:08:55',10,0),('1','201',251415,'DAILY SHIFT','2022-07-02','2022-07-02 06:56:41','2022-07-03 06:56:41','740',0.00,0.00,'740','2022-07-02 19:02:03','740','2022-07-02 19:02:29',10,0),('1','201',251416,'DAILY SHIFT','2022-07-03','2022-07-03 06:44:18','2022-07-04 06:44:18','740',0.00,0.00,'740','2022-07-03 19:13:10','740','2022-07-03 19:13:38',10,0),('1','201',251417,'DAILY SHIFT','2022-07-04','2022-07-04 06:57:38','2022-07-05 06:57:38','740',0.00,0.00,'740','2022-07-04 19:08:38','740','2022-07-04 19:09:01',10,0),('1','201',251418,'DAILY SHIFT','2022-07-05','2022-07-05 06:51:01','2022-07-06 06:51:01','740',0.00,0.00,'740','2022-07-05 19:08:57','740','2022-07-05 19:09:38',10,0),('1','201',251419,'DAILY SHIFT','2022-07-06','2022-07-06 06:43:09','2022-07-07 06:43:09','740',0.00,0.00,'740','2022-07-06 19:30:02','740','2022-07-06 19:30:33',10,0),('1','201',251420,'DAILY SHIFT','2022-07-07','2022-07-07 06:56:20','2022-07-08 06:56:20','740',0.00,0.00,'740','2022-07-07 19:25:17','740','2022-07-07 19:27:28',10,0),('1','201',251421,'DAILY SHIFT','2022-07-08','2022-07-08 06:51:55','2022-07-09 06:51:55','740',0.00,0.00,'740','2022-07-08 19:36:12','740','2022-07-08 19:36:40',10,0),('1','201',251422,'DAILY SHIFT','2022-07-09','2022-07-09 10:01:10','2022-07-10 10:01:10','740',0.00,0.00,'740','2022-07-09 18:40:44','740','2022-07-09 18:41:12',10,0),('1','201',251423,'DAILY SHIFT','2022-07-10','2022-07-10 07:06:01','2022-07-11 07:06:01','740',0.00,0.00,'740','2022-07-10 19:07:36','740','2022-07-10 19:08:46',10,0),('1','201',251424,'DAILY SHIFT','2022-07-11','2022-07-11 07:15:31','2022-07-12 07:15:31','740',0.00,0.00,'740','2022-07-11 19:12:44','740','2022-07-11 19:13:06',10,0),('1','201',251425,'DAILY SHIFT','2022-07-12','2022-07-12 07:27:46','2022-07-13 07:27:46','740',0.00,0.00,'740','2022-07-12 19:14:45','740','2022-07-12 19:15:59',10,0),('1','201',251426,'DAILY SHIFT','2022-07-13','2022-07-13 06:54:11','2022-07-14 06:54:11','740',0.00,0.00,'740','2022-07-13 19:01:07','740','2022-07-13 19:01:33',10,0),('1','201',251427,'DAILY SHIFT','2022-07-14','2022-07-14 07:05:26','2022-07-15 07:05:26','740',0.00,0.00,'740','2022-07-14 19:05:41','740','2022-07-14 19:06:10',10,0),('1','201',251428,'DAILY SHIFT','2022-07-15','2022-07-15 08:10:05','2022-07-16 08:10:05','740',0.00,0.00,'740','2022-07-15 15:02:09','740','2022-07-15 15:02:31',10,0),('1','201',251429,'Shift','2022-07-15','2022-07-15 15:02:57','2022-07-16 15:02:57','740',0.00,0.00,'740','2022-07-15 15:07:41','740','2022-07-15 15:07:57',10,0),('1','201',251430,'DAILY SHIFT','2022-07-15','2022-07-15 16:45:03','2022-07-16 16:45:03','740',0.00,0.00,'740','2022-07-15 19:18:58','740','2022-07-15 19:20:01',10,0),('1','201',251431,'DAILY SHIFT','2022-07-16','2022-07-16 07:38:16','2022-07-17 07:38:16','740',0.00,0.00,'740','2022-07-16 19:13:21','740','2022-07-16 19:13:44',10,0),('1','201',251432,'DAILY SHIFT','2022-07-17','2022-07-17 07:13:53','2022-07-18 07:13:53','740',0.00,0.00,'740','2022-07-17 18:55:28','740','2022-07-17 18:55:55',10,0),('1','201',251433,'DAILY SHIFT','2022-07-18','2022-07-18 08:50:48','2022-07-19 08:50:48','740',0.00,0.00,'740','2022-07-18 19:15:45','740','2022-07-18 19:16:07',10,0),('1','201',251434,'DAILY SHIFT','2022-07-19','2022-07-19 08:30:51','2022-07-20 08:30:51','740',0.00,0.00,'740','2022-07-19 19:09:30','740','2022-07-19 19:10:00',10,0),('1','201',251435,'DAILY SHIFT','2022-07-20','2022-07-20 07:06:44','2022-07-21 07:06:44','740',0.00,0.00,'740','2022-07-20 18:47:00','740','2022-07-20 18:47:44',10,0),('1','201',251436,'DAILY SHIFT','2022-07-21','2022-07-21 07:20:48','2022-07-22 07:20:48','740',0.00,0.00,'740','2022-07-21 19:23:13','740','2022-07-21 19:24:08',10,0),('1','201',251437,'DAILY SHIFT','2022-07-22','2022-07-22 06:34:56','2022-07-23 06:34:56','740',0.00,0.00,'740','2022-07-22 19:01:44','740','2022-07-22 19:04:30',10,0),('1','201',251438,'DAILY SHIFT','2022-07-23','2022-07-23 06:55:12','2022-07-24 06:55:12','740',0.00,0.00,'740','2022-07-23 19:06:15','740','2022-07-23 19:06:39',10,0),('1','201',251439,'DAILY SHIFT','2022-07-24','2022-07-24 06:54:20','2022-07-25 06:54:20','740',0.00,0.00,'740','2022-07-24 18:52:55','740','2022-07-24 18:53:25',10,0),('1','201',251440,'DAILY SHIFT','2022-07-25','2022-07-25 06:40:58','2022-07-26 06:40:58','740',0.00,0.00,'740','2022-07-25 18:55:11','740','2022-07-25 18:56:00',10,0),('1','201',251441,'DAILY SHIFT','2022-07-26','2022-07-26 07:00:18','2022-07-27 07:00:18','740',0.00,0.00,'740','2022-07-26 19:11:47','740','2022-07-26 19:12:09',10,0),('1','201',251442,'DAILY SHIFT','2022-07-27','2022-07-27 07:09:59','2022-07-28 07:09:59','740',0.00,0.00,'740','2022-07-27 19:23:28','740','2022-07-27 19:23:50',10,0),('1','201',251443,'DAILY SHIFT','2022-07-28','2022-07-28 06:45:03','2022-07-29 06:45:03','740',0.00,0.00,'740','2022-07-28 18:52:28','740','2022-07-28 18:52:51',10,0),('1','201',251444,'DAILY SHIFT','2022-07-29','2022-07-29 06:48:50','2022-07-30 06:48:50','740',0.00,0.00,'740','2022-07-29 19:10:11','740','2022-07-29 19:10:33',10,0),('1','201',251445,'DAILY SHIFT','2022-07-30','2022-07-30 07:08:32','2022-07-31 07:08:32','740',0.00,0.00,'740','2022-07-30 19:01:28','740','2022-07-30 19:02:00',10,0),('1','201',251446,'DAILY SHIFT','2022-07-31','2022-07-31 06:53:43','2022-08-01 06:53:43','740',0.00,0.00,'740','2022-07-31 18:55:02','740','2022-07-31 18:55:40',10,0),('1','201',251447,'DAILY SHIFT','2022-08-01','2022-08-01 06:47:03','2022-08-02 06:47:03','740',0.00,0.00,'740','2022-08-01 18:49:52','740','2022-08-01 18:50:50',10,0),('1','201',251448,'DAILY SHIFT','2022-08-02','2022-08-02 06:47:57','2022-08-03 06:47:57','740',0.00,0.00,'740','2022-08-02 18:58:11','740','2022-08-02 19:10:03',10,0),('1','201',251449,'DAILY SHIFT','2022-08-03','2022-08-03 06:52:08','2022-08-04 06:52:08','740',0.00,0.00,'740','2022-08-03 18:53:23','740','2022-08-03 18:54:00',10,0),('1','201',251450,'DAILY SHIFT','2022-08-04','2022-08-04 06:53:33','2022-08-05 06:53:33','740',0.00,0.00,'740','2022-08-04 19:01:17','740','2022-08-04 19:01:45',10,0),('1','201',251451,'DAILY SHIFT','2022-08-05','2022-08-05 06:57:41','2022-08-06 06:57:41','740',0.00,0.00,'740','2022-08-05 19:02:42','740','2022-08-05 19:03:09',10,0),('1','201',251452,'DAILY SHIFT','2022-08-06','2022-08-06 06:47:09','2022-08-07 06:47:09','740',0.00,0.00,'740','2022-08-06 18:57:19','740','2022-08-06 18:57:45',10,0),('1','201',251453,'DAILY SHIFT','2022-08-07','2022-08-07 06:54:05','2022-08-08 06:54:05','740',0.00,0.00,'740','2022-08-07 19:21:12','740','2022-08-07 19:24:36',10,0),('1','201',251454,'DAILY SHIFT','2022-08-08','2022-08-08 06:52:12','2022-08-09 06:52:12','740',0.00,0.00,'740','2022-08-08 19:11:36','740','2022-08-08 19:12:25',10,0),('1','201',251455,'DAILY SHIFT','2022-08-09','2022-08-09 06:57:03','2022-08-10 06:57:03','740',0.00,0.00,'740','2022-08-09 19:01:51','740','2022-08-09 19:02:18',10,0),('1','201',251456,'DAILY SHIFT','2022-08-10','2022-08-10 06:48:15','2022-08-11 06:48:15','740',0.00,0.00,'740','2022-08-10 18:50:51','740','2022-08-10 18:55:38',10,0),('1','201',251457,'DAILY SHIFT','2022-08-11','2022-08-11 07:06:01','2022-08-12 07:06:01','740',0.00,0.00,'740','2022-08-11 09:42:36','740','2022-08-11 09:43:19',10,0),('1','201',251458,'Shift','2022-08-11','2022-08-11 10:07:14','2022-08-12 10:07:14','740',0.00,0.00,'740','2022-08-11 10:14:01','740','2022-08-11 10:14:22',10,0),('1','201',251459,'DAILY SHIFT','2022-08-11','2022-08-11 15:13:13','2022-08-12 15:13:13','740',0.00,0.00,'740','2022-08-11 19:28:00','740','2022-08-11 19:29:56',10,0),('1','201',251460,'DAILY SHIFT','2022-08-12','2022-08-12 06:50:49','2022-08-13 06:50:49','740',0.00,0.00,'740','2022-08-12 18:58:49','740','2022-08-12 18:59:25',10,0),('1','201',251461,'DAILY SHIFT','2022-08-13','2022-08-13 06:56:42','2022-08-14 06:56:42','740',0.00,0.00,'740','2022-08-13 18:48:20','740','2022-08-13 18:48:45',10,0),('1','201',251462,'DAILY SHIFT','2022-08-14','2022-08-14 06:51:45','2022-08-15 06:51:45','740',0.00,0.00,'740','2022-08-14 18:51:54','740','2022-08-14 18:52:16',10,0),('1','201',251463,'DAILY SHIFT','2022-08-15','2022-08-15 06:59:51','2022-08-16 06:59:51','740',0.00,0.00,'740','2022-08-15 18:49:53','740','2022-08-15 18:50:16',10,0),('1','201',251464,'DAILY SHIFT','2022-08-16','2022-08-16 06:58:44','2022-08-17 06:58:44','740',0.00,0.00,'740','2022-08-16 18:53:27','740','2022-08-16 18:54:39',10,0),('1','201',251465,'DAILY SHIFT','2022-08-17','2022-08-17 06:59:26','2022-08-18 06:59:26','740',0.00,0.00,'740','2022-08-17 18:51:29','740','2022-08-17 18:52:00',10,0),('1','201',251466,'DAILY SHIFT','2022-08-18','2022-08-18 06:54:27','2022-08-19 06:54:27','740',0.00,0.00,'740','2022-08-18 18:51:55','740','2022-08-18 18:52:17',10,0),('1','201',251467,'DAILY SHIFT','2022-08-19','2022-08-19 06:57:47','2022-08-20 06:57:47','740',0.00,0.00,'740','2022-08-19 19:00:24','740','2022-08-19 19:01:01',10,0),('1','201',251468,'DAILY SHIFT','2022-08-20','2022-08-20 06:57:33','2022-08-21 06:57:33','740',0.00,0.00,'740','2022-08-20 18:43:56','740','2022-08-20 18:44:30',10,0),('1','201',251469,'DAILY SHIFT','2022-08-21','2022-08-21 06:53:08','2022-08-22 06:53:08','740',0.00,0.00,'740','2022-08-21 18:58:29','740','2022-08-21 18:58:58',10,0),('1','201',251470,'DAILY SHIFT','2022-08-22','2022-08-22 06:59:31','2022-08-23 06:59:31','740',0.00,0.00,'740','2022-08-22 18:49:27','740','2022-08-22 18:49:55',10,0),('1','201',251471,'DAILY SHIFT','2022-08-23','2022-08-23 06:57:13','2022-08-24 06:57:13','740',0.00,0.00,'740','2022-08-23 18:56:36','740','2022-08-23 18:56:58',10,0),('1','201',251472,'DAILY SHIFT','2022-08-24','2022-08-24 06:55:12','2022-08-25 06:55:12','740',0.00,0.00,'740','2022-08-24 18:50:12','740','2022-08-24 18:52:41',10,0),('1','201',251473,'DAILY SHIFT','2022-08-25','2022-08-25 07:00:39','2022-08-26 07:00:39','740',0.00,0.00,'740','2022-08-25 18:54:46','740','2022-08-25 18:55:14',10,0),('1','201',251474,'DAILY SHIFT','2022-08-26','2022-08-26 06:52:33','2022-08-27 06:52:33','740',0.00,0.00,'740','2022-08-26 18:40:58','740','2022-08-26 18:41:30',10,0),('1','201',251475,'DAILY SHIFT','2022-08-27','2022-08-27 06:52:45','2022-08-28 06:52:45','740',0.00,0.00,'740','2022-08-27 18:51:53','740','2022-08-27 18:52:16',10,0),('1','201',251476,'DAILY SHIFT','2022-08-28','2022-08-28 07:04:02','2022-08-29 07:04:02','740',0.00,0.00,'740','2022-08-28 18:52:36','740','2022-08-28 18:53:08',10,0),('1','201',251477,'DAILY SHIFT','2022-08-29','2022-08-29 07:03:08','2022-08-30 07:03:08','740',0.00,0.00,'740','2022-08-29 18:51:39','740','2022-08-29 18:55:48',10,0),('1','201',251478,'DAILY SHIFT','2022-08-30','2022-08-30 07:02:19','2022-08-31 07:02:19','740',0.00,0.00,'740','2022-08-30 18:49:07','740','2022-08-30 18:49:27',10,0),('1','201',251479,'DAILY SHIFT','2022-08-31','2022-08-31 06:57:10','2022-09-01 06:57:10','740',0.00,0.00,'740','2022-08-31 19:04:49','740','2022-08-31 19:05:13',10,0),('1','201',251480,'DAILY SHIFT','2022-09-01','2022-09-01 07:05:31','2022-09-02 07:05:31','740',0.00,0.00,'740','2022-09-01 19:01:37','740','2022-09-01 19:03:23',10,0),('1','201',251481,'DAILY SHIFT','2022-09-02','2022-09-02 06:54:07','2022-09-03 06:54:07','740',0.00,0.00,'740','2022-09-02 18:50:56','740','2022-09-02 18:51:45',10,0),('1','201',251482,'DAILY SHIFT','2022-09-03','2022-09-03 07:04:11','2022-09-04 07:04:11','740',0.00,0.00,'740','2022-09-03 19:11:36','740','2022-09-03 19:12:04',10,0),('1','201',251483,'DAILY SHIFT','2022-09-04','2022-09-04 06:57:04','2022-09-05 06:57:04','740',0.00,0.00,'740','2022-09-04 18:52:40','740','2022-09-04 18:53:32',10,0),('1','201',251484,'DAILY SHIFT','2022-09-05','2022-09-05 06:59:00','2022-09-06 06:59:00','740',0.00,0.00,'740','2022-09-05 18:55:08','740','2022-09-05 18:55:31',10,0),('1','201',251485,'DAILY SHIFT','2022-09-06','2022-09-06 07:01:34','2022-09-07 07:01:34','740',0.00,0.00,'740','2022-09-06 14:53:40','740','2022-09-06 14:57:18',10,0),('1','201',251486,'Shift','2022-09-06','2022-09-06 16:44:09','2022-09-07 16:44:09','740',0.00,0.00,'740','2022-09-10 16:38:34','740','2022-09-10 16:38:56',10,0),('1','201',251487,'DAILY SHIFT','2022-09-10','2022-09-10 16:39:30','2022-09-11 16:39:30','740',0.00,0.00,'740','2022-09-10 19:07:38','740','2022-09-10 19:08:17',10,0),('1','201',251488,'DAILY SHIFT','2022-09-11','2022-09-11 07:14:51','2022-09-12 07:14:51','740',0.00,0.00,'740','2022-09-11 19:07:46','740','2022-09-11 19:08:08',10,0),('1','201',251489,'DAILY SHIFT','2022-09-12','2022-09-12 06:44:49','2022-09-13 06:44:49','740',0.00,0.00,'740','2022-09-12 19:01:20','740','2022-09-12 19:01:54',10,0),('1','201',251490,'DAILY SHIFT','2022-09-13','2022-09-13 07:12:53','2022-09-14 07:12:53','740',0.00,0.00,'740','2022-09-13 18:42:47','740','2022-09-13 18:43:14',10,0),('1','201',251491,'DAILY SHIFT','2022-09-14','2022-09-14 06:59:28','2022-09-15 06:59:28','740',0.00,0.00,'740','2022-09-14 18:46:47','740','2022-09-14 18:47:40',10,0),('1','201',251492,'DAILY SHIFT','2022-09-15','2022-09-15 06:58:55','2022-09-16 06:58:55','740',0.00,0.00,'740','2022-09-15 18:49:00','740','2022-09-15 18:49:29',10,0),('1','201',251493,'DAILY SHIFT','2022-09-16','2022-09-16 07:01:08','2022-09-17 07:01:08','740',0.00,0.00,'740','2022-09-16 18:43:58','740','2022-09-16 18:45:06',10,0),('1','201',251494,'DAILY SHIFT','2022-09-17','2022-09-17 07:13:32','2022-09-18 07:13:32','740',0.00,0.00,'740','2022-09-17 18:52:24','740','2022-09-17 18:52:49',10,0),('1','201',251495,'DAILY SHIFT','2022-09-18','2022-09-18 07:04:42','2022-09-19 07:04:42','740',0.00,0.00,'740','2022-09-18 18:47:18','740','2022-09-18 18:47:41',10,0),('1','201',251496,'DAILY SHIFT','2022-09-19','2022-09-19 07:05:28','2022-09-20 07:05:28','740',0.00,0.00,'740','2022-09-19 18:46:23','740','2022-09-19 18:46:51',10,0),('1','201',251497,'DAILY SHIFT','2022-09-20','2022-09-20 06:59:45','2022-09-21 06:59:45','740',0.00,0.00,'740','2022-09-20 18:47:40','740','2022-09-20 18:48:14',10,0),('1','201',251498,'DAILY SHIFT','2022-09-21','2022-09-21 07:04:06','2022-09-22 07:04:06','740',0.00,0.00,'740','2022-09-21 18:45:01','740','2022-09-21 18:45:27',10,0),('1','201',251499,'DAILY SHIFT','2022-09-22','2022-09-22 07:02:56','2022-09-23 07:02:56','740',0.00,0.00,'740','2022-09-22 18:45:28','740','2022-09-22 18:45:52',10,0),('1','201',251500,'DAILY SHIFT','2022-09-23','2022-09-23 07:00:19','2022-09-24 07:00:19','740',0.00,0.00,'740','2022-09-23 18:47:55','740','2022-09-23 18:48:15',10,0),('1','201',251501,'DAILY SHIFT','2022-09-24','2022-09-24 07:10:28','2022-09-25 07:10:28','740',0.00,0.00,'740','2022-09-24 18:54:07','740','2022-09-24 18:54:36',10,0),('1','201',251502,'DAILY SHIFT','2022-09-25','2022-09-25 07:05:54','2022-09-26 07:05:54','740',0.00,0.00,'740','2022-09-25 18:49:26','740','2022-09-25 18:49:47',10,0),('1','201',251503,'DAILY SHIFT','2022-09-26','2022-09-26 07:08:09','2022-09-27 07:08:09','740',0.00,0.00,'740','2022-09-26 18:31:59','740','2022-09-26 18:32:28',10,0),('1','201',251504,'DAILY SHIFT','2022-09-27','2022-09-27 07:05:00','2022-09-28 07:05:00','740',0.00,0.00,'740','2022-09-27 19:04:54','740','2022-09-27 19:05:21',10,0),('1','201',251505,'DAILY SHIFT','2022-09-28','2022-09-28 07:05:56','2022-09-29 07:05:56','740',0.00,0.00,'740','2022-09-28 18:38:39','740','2022-09-28 18:39:11',10,0),('1','201',251506,'DAILY SHIFT','2022-09-29','2022-09-29 07:03:53','2022-09-30 07:03:53','740',0.00,0.00,'740','2022-09-29 18:37:07','740','2022-09-29 18:37:37',10,0),('1','201',251507,'DAILY SHIFT','2022-09-30','2022-09-30 07:04:29','2022-10-01 07:04:29','740',0.00,0.00,'740','2022-09-30 18:37:52','740','2022-09-30 18:38:17',10,0),('1','201',251508,'DAILY SHIFT','2022-10-01','2022-10-01 06:56:34','2022-10-02 06:56:34','740',0.00,0.00,'740','2022-10-01 18:32:54','740','2022-10-01 18:33:17',10,0),('1','201',251509,'DAILY SHIFT','2022-10-02','2022-10-02 06:57:50','2022-10-03 06:57:50','740',0.00,0.00,'740','2022-10-02 18:29:34','740','2022-10-02 18:29:58',10,0),('1','201',251510,'DAILY SHIFT','2022-10-03','2022-10-03 07:05:23','2022-10-04 07:05:23','740',0.00,0.00,'740','2022-10-03 10:48:29','740','2022-10-03 10:48:54',10,0),('1','201',251511,'Shift','2022-10-04','2022-10-04 18:45:32','2022-10-05 18:45:32','740',0.00,0.00,'740','2022-10-07 12:12:45','740','2022-10-07 12:13:03',10,0),('1','201',251512,'DAILY SHIFT','2022-10-07','2022-10-07 13:52:07','2022-10-08 13:52:07','740',0.00,0.00,'740','2022-10-07 18:33:14','740','2022-10-07 18:33:41',10,0),('1','201',251513,'DAILY SHIFT','2022-10-08','2022-10-08 07:01:11','2022-10-09 07:01:11','740',0.00,0.00,'740','2022-10-08 18:48:06','740','2022-10-08 18:48:37',10,0),('1','201',251514,'DAILY SHIFT','2022-10-09','2022-10-09 06:59:14','2022-10-10 06:59:14','740',0.00,0.00,'740','2022-10-09 18:36:45','740','2022-10-09 18:37:09',10,0),('1','201',251515,'DAILY SHIFT','2022-10-10','2022-10-10 06:51:51','2022-10-11 06:51:51','740',0.00,0.00,'740','2022-10-10 18:23:13','740','2022-10-10 18:23:35',10,0),('1','201',251516,'DAILY SHIFT','2022-10-11','2022-10-11 06:53:11','2022-10-12 06:53:11','740',0.00,0.00,'740','2022-10-11 18:31:00','740','2022-10-11 18:31:26',10,0),('1','201',251517,'DAILY SHIFT','2022-10-12','2022-10-12 07:05:02','2022-10-13 07:05:02','740',0.00,0.00,'740','2022-10-12 18:32:03','740','2022-10-12 18:33:23',10,0),('1','201',251518,'DAILY SHIFT','2022-10-13','2022-10-13 07:03:22','2022-10-14 07:03:22','740',0.00,0.00,'740','2022-10-13 18:38:39','740','2022-10-13 18:39:11',10,0),('1','201',251519,'DAILY SHIFT','2022-10-14','2022-10-14 07:04:39','2022-10-15 07:04:39','740',0.00,0.00,'740','2022-10-14 18:27:38','740','2022-10-14 18:28:13',10,0),('1','201',251520,'DAILY SHIFT','2022-10-15','2022-10-15 07:02:33','2022-10-16 07:02:33','740',0.00,0.00,'740','2022-10-15 18:36:59','740','2022-10-15 18:37:24',10,0),('1','201',251521,'DAILY SHIFT','2022-10-16','2022-10-16 07:06:46','2022-10-17 07:06:46','740',0.00,0.00,'740','2022-10-16 18:35:34','740','2022-10-16 18:36:00',10,0),('1','201',251522,'DAILY SHIFT','2022-10-17','2022-10-17 07:00:26','2022-10-18 07:00:26','740',0.00,0.00,'740','2022-10-17 18:30:58','740','2022-10-17 18:31:24',10,0),('1','201',251523,'DAILY SHIFT','2022-10-18','2022-10-18 07:01:30','2022-10-19 07:01:30','740',0.00,0.00,'740','2022-10-18 18:27:09','740','2022-10-18 18:27:33',10,0),('1','201',251524,'DAILY SHIFT','2022-10-19','2022-10-19 07:10:10','2022-10-20 07:10:10','740',0.00,0.00,'740','2022-10-19 18:24:19','740','2022-10-19 18:27:25',10,0),('1','201',251525,'DAILY SHIFT','2022-10-20','2022-10-20 07:10:26','2022-10-21 07:10:26','740',0.00,0.00,'740','2022-10-20 11:04:13','740','2022-10-20 11:04:40',10,0),('1','201',251526,'Shift','2022-10-20','2022-10-20 18:19:47','2022-10-21 18:19:47','740',0.00,0.00,'740','2022-10-24 13:50:31','740','2022-10-24 13:50:45',10,0),('1','201',251527,'Shift','2022-10-24','2022-10-24 13:51:46','2022-10-25 13:51:46','740',0.00,0.00,'740','2022-10-24 18:59:36','740','2022-10-24 19:02:41',10,0),('1','201',251528,'DAILY SHIFT','2022-10-25','2022-10-25 06:56:24','2022-10-26 06:56:24','740',0.00,0.00,'740','2022-10-25 19:14:45','740','2022-10-25 19:16:17',10,0),('1','201',251529,'DAILY SHIFT','2022-10-26','2022-10-26 07:01:03','2022-10-27 07:01:03','740',0.00,0.00,'740','2022-10-26 18:22:09','740','2022-10-26 18:22:32',10,0),('1','201',251530,'DAILY SHIFT','2022-10-27','2022-10-27 07:09:32','2022-10-28 07:09:32','740',0.00,0.00,'740','2022-10-27 18:26:36','740','2022-10-27 18:27:07',10,0),('1','201',251531,'DAILY SHIFT','2022-10-28','2022-10-28 07:06:32','2022-10-29 07:06:32','740',0.00,0.00,'740','2022-10-28 18:28:53','740','2022-10-28 18:29:34',10,0),('1','201',251532,'DAILY SHIFT','2022-10-29','2022-10-29 07:01:04','2022-10-30 07:01:04','740',0.00,0.00,'740','2022-10-29 18:24:16','740','2022-10-29 18:24:41',10,0),('1','201',251533,'DAILY SHIFT','2022-10-30','2022-10-30 07:02:47','2022-10-31 07:02:47','740',0.00,0.00,'740','2022-10-30 18:53:45','740','2022-10-30 18:57:53',10,0),('1','201',251534,'DAILY SHIFT','2022-10-31','2022-10-31 07:01:17','2022-11-01 07:01:17','740',0.00,0.00,'740','2022-10-31 18:36:50','740','2022-10-31 18:38:32',10,0),('1','201',251535,'DAILY SHIFT','2022-11-01','2022-11-01 07:00:16','2022-11-02 07:00:16','740',0.00,0.00,'740','2022-11-01 18:33:41','740','2022-11-01 18:35:21',10,0),('1','201',251536,'DAILY SHIFT','2022-11-02','2022-11-02 07:02:40','2022-11-03 07:02:40','740',0.00,0.00,'740','2022-11-02 18:36:06','740','2022-11-02 18:36:46',10,0),('1','201',251537,'DAILY SHIFT','2022-11-03','2022-11-03 07:07:06','2022-11-04 07:07:06','740',0.00,0.00,'740','2022-11-03 18:24:59','740','2022-11-03 18:25:54',10,0),('1','201',251538,'DAILY SHIFT','2022-11-04','2022-11-04 07:01:34','2022-11-05 07:01:34','740',0.00,0.00,'740','2022-11-04 12:10:27','740','2022-11-04 12:11:36',10,0),('1','201',251539,'OPERATIONAL LOSS','2022-11-04','2022-11-04 14:24:01','2022-11-05 14:24:01','740',0.00,0.00,'740','2022-11-04 14:39:17','740','2022-11-04 14:39:33',10,0),('1','201',251540,'DAILY SHIFT','2022-11-05','2022-11-05 09:01:17','2022-11-06 09:01:17','740',0.00,0.00,'740','2022-11-05 19:05:24','740','2022-11-05 19:07:20',10,0),('1','201',251541,'DAILY SHIFT','2022-11-06','2022-11-06 07:57:57','2022-11-07 07:57:57','740',0.00,0.00,'740','2022-11-06 18:40:15','740','2022-11-06 18:44:13',10,0),('1','201',251542,'DAILY SHIFT','2022-11-07','2022-11-07 07:01:49','2022-11-08 07:01:49','740',0.00,0.00,'740','2022-11-07 18:55:05','740','2022-11-07 19:10:50',10,0),('1','201',251543,'DAILY SHIFT','2022-11-08','2022-11-08 07:10:53','2022-11-09 07:10:53','740',0.00,0.00,'740','2022-11-08 18:39:23','740','2022-11-08 18:40:10',10,0),('1','201',251544,'DAILY SHIFT','2022-11-09','2022-11-09 07:01:40','2022-11-10 07:01:40','740',0.00,0.00,'740','2022-11-09 19:09:23','740','2022-11-09 19:09:49',10,0),('1','201',251545,'DAILY SHIFT','2022-11-10','2022-11-10 07:03:20','2022-11-11 07:03:20','740',0.00,0.00,'740','2022-11-10 12:00:20','740','2022-11-10 12:00:47',10,0),('1','201',251546,'Shift','2022-11-10','2022-11-10 18:40:40','2022-11-11 18:40:40','740',0.00,0.00,'740','2022-11-12 13:23:13','740','2022-11-12 13:23:40',10,0),('1','201',251547,'DAILY SHIFT','2022-11-12','2022-11-12 13:58:56','2022-11-13 13:58:56','740',0.00,0.00,'740','2022-11-12 18:19:13','740','2022-11-12 18:19:37',10,0),('1','201',251548,'DAILY SHIFT','2022-11-13','2022-11-13 07:23:58','2022-11-14 07:23:58','740',0.00,0.00,'740','2022-11-13 18:15:59','740','2022-11-13 18:16:29',10,0),('1','201',251549,'DAILY SHIFT','2022-11-14','2022-11-14 07:05:27','2022-11-15 07:05:27','740',0.00,0.00,'740','2022-11-14 18:21:35','740','2022-11-14 18:22:07',10,0),('1','201',251550,'DAILY SHIFT','2022-11-15','2022-11-15 06:54:24','2022-11-16 06:54:24','740',0.00,0.00,'740','2022-11-15 18:38:15','740','2022-11-15 18:38:39',10,0),('1','201',251551,'DAILY SHIFT','2022-11-16','2022-11-16 07:08:18','2022-11-17 07:08:18','740',0.00,0.00,'740','2022-11-16 18:11:23','740','2022-11-16 18:11:51',10,0),('1','201',251552,'DAILY SHIFT','2022-11-17','2022-11-17 07:08:28','2022-11-18 07:08:28','740',0.00,0.00,'740','2022-11-17 18:25:05','740','2022-11-17 18:25:33',10,0),('1','201',251553,'DAILY SHIFT','2022-11-18','2022-11-18 07:16:12','2022-11-19 07:16:12','740',0.00,0.00,'740','2022-11-18 18:14:59','740','2022-11-18 18:15:28',10,0),('1','201',251554,'DAILY SHIFT','2022-11-19','2022-11-19 07:03:14','2022-11-20 07:03:14','740',0.00,0.00,'740','2022-11-19 18:20:39','740','2022-11-19 18:21:39',10,0),('1','201',251555,'DAILY SHIFT','2022-11-20','2022-11-20 07:10:27','2022-11-21 07:10:27','740',0.00,0.00,'740','2022-11-20 20:22:06','740','2022-11-20 20:22:24',10,0),('1','201',251556,'DAILY SHIFT','2022-11-21','2022-11-21 07:11:54','2022-11-22 07:11:54','740',0.00,0.00,'740','2022-11-21 18:22:12','740','2022-11-21 18:22:37',10,0),('1','201',251557,'Shift','2022-11-21','2022-11-21 18:35:30','2022-11-22 18:35:30','740',0.00,0.00,'740','2022-11-21 18:39:01','740','2022-11-21 18:39:18',10,0),('1','201',251558,'DAILY SHIFT','2022-11-22','2022-11-22 07:04:27','2022-11-23 07:04:27','740',0.00,0.00,'740','2022-11-22 19:38:04','740','2022-11-22 19:38:27',10,0),('1','201',251559,'DAILY SHIFT','2022-11-23','2022-11-23 07:05:22','2022-11-24 07:05:22','740',0.00,0.00,'740','2022-11-23 18:59:36','740','2022-11-23 18:59:56',10,0),('1','201',251560,'DAILY SHIFT','2022-11-24','2022-11-24 07:14:21','2022-11-25 07:14:21','740',0.00,0.00,'740','2022-11-24 19:41:06','740','2022-11-24 19:41:23',10,0),('1','201',251561,'DAILY SHIFT','2022-11-25','2022-11-25 07:09:07','2022-11-26 07:09:07','740',0.00,0.00,'740','2022-11-25 18:39:42','740','2022-11-25 18:39:58',10,0),('1','201',251562,'DAILY SHIFT','2022-11-26','2022-11-26 07:07:28','2022-11-27 07:07:28','740',0.00,0.00,'740','2022-11-26 18:21:45','740','2022-11-26 18:22:10',10,0),('1','201',251563,'DAILY SHIFT','2022-11-27','2022-11-27 07:35:57','2022-11-28 07:35:57','740',0.00,0.00,'740','2022-11-27 18:21:58','740','2022-11-27 18:23:43',10,0),('1','201',251564,'DAILY SHIFT','2022-11-28','2022-11-28 07:06:58','2022-11-29 07:06:58','740',0.00,0.00,'740','2022-11-28 18:23:02','740','2022-11-28 18:23:21',10,0),('1','201',251565,'DAILY SHIFT','2022-11-29','2022-11-29 07:03:31','2022-11-30 07:03:31','740',0.00,0.00,'740','2022-11-29 17:38:37','740','2022-11-29 17:39:00',10,0),('1','201',251566,'Shift','2022-11-29','2022-11-29 18:40:38','2022-11-30 18:40:38','740',0.00,0.00,'740','2022-12-01 12:25:48','740','2022-12-01 12:26:02',10,0),('1','201',251567,'DAILY SHIFT','2022-12-01','2022-12-01 14:23:38','2022-12-02 14:23:38','740',0.00,0.00,'740','2022-12-01 18:23:27','740','2022-12-01 18:23:50',10,0),('1','201',251568,'DAILY SHIFT','2022-12-02','2022-12-02 07:29:33','2022-12-03 07:29:33','740',0.00,0.00,'740','2022-12-02 19:05:41','740','2022-12-02 19:06:31',10,0),('1','201',251569,'DAILY SHIFT','2022-12-03','2022-12-03 07:10:40','2022-12-04 07:10:40','740',0.00,0.00,'740','2022-12-03 18:27:58','740','2022-12-03 18:28:25',10,0),('1','201',251570,'DAILY SHIFT','2022-12-04','2022-12-04 07:06:48','2022-12-05 07:06:48','740',0.00,0.00,'740','2022-12-04 18:41:09','740','2022-12-04 18:42:01',10,0),('1','201',251571,'DAILY SHIFT','2022-12-05','2022-12-05 07:26:45','2022-12-06 07:26:45','740',0.00,0.00,'740','2022-12-05 18:19:01','740','2022-12-05 18:19:36',10,0),('1','201',251572,'DAILY SHIFT','2022-12-06','2022-12-06 07:19:44','2022-12-07 07:19:44','740',0.00,0.00,'740','2022-12-06 18:39:32','740','2022-12-06 18:40:34',10,0),('1','201',251573,'DAILY SHIFT','2022-12-07','2022-12-07 07:18:34','2022-12-08 07:18:34','740',0.00,0.00,'740','2022-12-07 18:19:50','740','2022-12-07 18:20:23',10,0),('1','201',251574,'DAILY SHIFT','2022-12-08','2022-12-08 07:18:36','2022-12-09 07:18:36','740',0.00,0.00,'740','2022-12-08 18:31:28','740','2022-12-08 18:32:04',10,0),('1','201',251575,'DAILY SHIFT','2022-12-09','2022-12-09 07:27:09','2022-12-10 07:27:09','740',0.00,0.00,'740','2022-12-09 18:19:27','740','2022-12-09 18:19:55',10,0),('1','201',251576,'DAILY SHIFT','2022-12-10','2022-12-10 07:22:00','2022-12-11 07:22:00','740',0.00,0.00,'740','2022-12-10 18:46:14','740','2022-12-10 18:46:38',10,0),('1','201',251577,'DAILY SHIFT','2022-12-11','2022-12-11 07:37:31','2022-12-12 07:37:31','740',0.00,0.00,'740','2022-12-11 18:21:46','740','2022-12-11 18:22:17',10,0),('1','201',251578,'DAILY SHIFT','2022-12-12','2022-12-12 07:29:10','2022-12-13 07:29:10','740',0.00,0.00,'740','2022-12-12 18:28:26','740','2022-12-12 18:29:02',10,0),('1','201',251579,'DAILY SHIFT','2022-12-13','2022-12-13 07:24:01','2022-12-14 07:24:01','740',0.00,0.00,'740','2022-12-13 18:13:35','740','2022-12-13 18:14:02',10,0),('1','201',251580,'DAILY SHIFT','2022-12-14','2022-12-14 07:28:37','2022-12-15 07:28:37','740',0.00,0.00,'740','2022-12-14 18:28:41','740','2022-12-14 18:29:02',10,0),('1','201',251581,'DAILY SHIFT','2022-12-15','2022-12-15 07:12:22','2022-12-16 07:12:22','740',0.00,0.00,'740','2022-12-15 18:16:11','740','2022-12-15 18:16:30',10,0),('1','201',251582,'DAILY SHIFT','2022-12-16','2022-12-16 07:19:41','2022-12-17 07:19:41','740',0.00,0.00,'740','2022-12-16 12:00:59','740','2022-12-16 12:01:24',10,0),('1','201',251583,'Shift','2022-12-16','2022-12-16 18:48:10','2022-12-17 18:48:10','740',0.00,0.00,'740','2022-12-16 19:17:51','740','2022-12-16 19:18:07',10,0),('1','201',251584,'DAILY SHIFT','2022-12-17','2022-12-17 07:11:16','2022-12-18 07:11:16','740',0.00,0.00,'740','2022-12-17 18:32:32','740','2022-12-17 18:32:58',10,0),('1','201',251585,'DAILY SHIFT','2022-12-18','2022-12-18 07:26:34','2022-12-19 07:26:34','740',0.00,0.00,'740','2022-12-18 18:30:46','740','2022-12-18 18:31:09',10,0),('1','201',251586,'DAILY SHIFT','2022-12-19','2022-12-19 07:25:11','2022-12-20 07:25:11','740',0.00,0.00,'740','2022-12-19 18:18:32','740','2022-12-19 18:18:50',10,0),('1','201',251587,'DAILY SHIFT','2022-12-20','2022-12-20 07:24:09','2022-12-21 07:24:09','740',0.00,0.00,'740','2022-12-20 18:14:39','740','2022-12-20 18:15:03',10,0),('1','201',251588,'DAILY SHIFT','2022-12-21','2022-12-21 07:18:37','2022-12-22 07:18:37','740',0.00,0.00,'740','2022-12-21 18:21:59','740','2022-12-21 18:22:25',10,0),('1','201',251589,'DAILY SHIFT','2022-12-22','2022-12-22 07:28:33','2022-12-23 07:28:33','740',0.00,0.00,'740','2022-12-22 18:42:28','740','2022-12-22 18:42:53',10,0),('1','201',251590,'DAILY SHIFT','2022-12-23','2022-12-23 07:36:06','2022-12-24 07:36:06','740',0.00,0.00,'740','2022-12-23 18:17:20','740','2022-12-23 18:17:41',10,0),('1','201',251591,'DAILY SHIFT','2022-12-24','2022-12-24 07:24:25','2022-12-25 07:24:25','740',0.00,0.00,'740','2022-12-24 18:45:10','740','2022-12-24 18:45:59',10,0),('1','201',251592,'DAILY SHIFT','2022-12-25','2022-12-25 07:01:45','2022-12-26 07:01:45','740',0.00,0.00,'740','2022-12-25 18:39:41','740','2022-12-25 18:40:10',10,0),('1','201',251593,'DAILY SHIFT','2022-12-26','2022-12-26 07:19:39','2022-12-27 07:19:39','740',0.00,0.00,'740','2022-12-26 18:36:17','740','2022-12-26 18:36:40',10,0),('1','201',251594,'DAILY SHIFT','2022-12-27','2022-12-27 07:24:55','2022-12-28 07:24:55','740',0.00,0.00,'740','2022-12-27 18:49:13','740','2022-12-27 18:49:39',10,0),('1','201',251595,'DAILY SHIFT','2022-12-28','2022-12-28 07:33:03','2022-12-29 07:33:03','740',0.00,0.00,'740','2022-12-28 18:38:39','740','2022-12-28 18:39:04',10,0),('1','201',251596,'DAILY SHIFT','2022-12-29','2022-12-29 07:30:45','2022-12-30 07:30:45','740',0.00,0.00,'740','2022-12-29 18:40:20','740','2022-12-29 18:40:46',10,0),('1','201',251597,'DAILY SHIFT','2022-12-30','2022-12-30 07:35:29','2022-12-31 07:35:29','740',0.00,0.00,'740','2022-12-30 18:49:30','740','2022-12-30 18:50:23',10,0),('1','201',251598,'DAILY SHIFT','2022-12-31','2022-12-31 07:40:47','2023-01-01 07:40:47','740',0.00,0.00,'740','2022-12-31 18:49:44','740','2022-12-31 18:50:04',10,0),('1','201',251599,'DAILY SHIFT','2023-01-01','2023-01-01 07:37:42','2023-01-02 07:37:42','740',0.00,0.00,'740','2023-01-01 18:46:18','740','2023-01-01 18:48:55',10,0),('1','201',251600,'DAILY SHIFT','2023-01-02','2023-01-02 07:50:35','2023-01-03 07:50:35','740',0.00,0.00,'740','2023-01-02 18:59:15','740','2023-01-02 18:59:46',10,0),('1','201',251601,'DAILY SHIFT','2023-01-03','2023-01-03 07:57:03','2023-01-04 07:57:03','740',0.00,0.00,'740','2023-01-03 19:27:12','740','2023-01-03 19:28:12',10,0),('1','201',251602,'DAILY SHIFT','2023-01-04','2023-01-04 07:49:35','2023-01-05 07:49:35','740',0.00,0.00,'740','2023-01-04 18:52:39','740','2023-01-04 18:53:00',10,0),('1','201',251603,'DAILY SHIFT','2023-01-05','2023-01-05 07:51:32','2023-01-06 07:51:32','740',0.00,0.00,'740','2023-01-05 18:33:13','740','2023-01-05 18:33:53',10,0),('1','201',251604,'DAILY SHIFT','2023-01-06','2023-01-06 07:50:31','2023-01-07 07:50:31','740',0.00,0.00,'740','2023-01-06 18:42:17','740','2023-01-06 18:42:44',10,0),('1','201',251605,'DAILY SHIFT','2023-01-07','2023-01-07 07:49:32','2023-01-08 07:49:32','740',0.00,0.00,'740','2023-01-07 18:53:09','740','2023-01-07 18:54:00',10,0),('1','201',251606,'Shift','2023-01-07','2023-01-07 20:01:30','2023-01-08 20:01:30','740',0.00,0.00,'740','2023-01-07 20:35:36','740','2023-01-07 20:35:55',10,0),('1','201',251607,'DAILY SHIFT','2023-01-08','2023-01-08 08:54:33','2023-01-09 08:54:33','740',0.00,0.00,'740','2023-01-08 19:23:54','740','2023-01-08 19:29:30',10,0),('1','201',251608,'DAILY SHIFT','2023-01-09','2023-01-09 07:40:10','2023-01-10 07:40:10','740',0.00,0.00,'740','2023-01-09 18:35:16','740','2023-01-09 18:35:35',10,0),('1','201',251609,'DAILY SHIFT','2023-01-10','2023-01-10 07:33:44','2023-01-11 07:33:44','740',0.00,0.00,'740','2023-01-10 18:17:24','740','2023-01-10 18:17:45',10,0),('1','201',251610,'DAILY SHIFT','2023-01-11','2023-01-11 07:36:13','2023-01-12 07:36:13','740',0.00,0.00,'740','2023-01-11 18:31:54','740','2023-01-11 18:32:18',10,0),('1','201',251611,'DAILY SHIFT','2023-01-12','2023-01-12 07:44:42','2023-01-13 07:44:42','740',0.00,0.00,'740','2023-01-12 18:21:00','740','2023-01-12 18:21:21',10,0),('1','201',251612,'DAILY SHIFT','2023-01-13','2023-01-13 07:40:54','2023-01-14 07:40:54','740',0.00,0.00,'740','2023-01-13 18:40:21','740','2023-01-13 18:41:05',10,0),('1','201',251613,'DAILY SHIFT','2023-01-14','2023-01-14 07:26:23','2023-01-15 07:26:23','740',0.00,0.00,'740','2023-01-14 18:24:17','740','2023-01-14 18:24:39',10,0),('1','201',251614,'DAILY SHIFT','2023-01-15','2023-01-15 07:41:35','2023-01-16 07:41:35','740',0.00,0.00,'740','2023-01-15 18:25:04','740','2023-01-15 18:27:08',10,0),('1','201',251615,'DAILY SHIFT','2023-01-16','2023-01-16 07:36:17','2023-01-17 07:36:17','740',0.00,0.00,'740','2023-01-16 18:41:38','740','2023-01-16 18:42:12',10,0),('1','201',251616,'DAILY SHIFT','2023-01-17','2023-01-17 07:46:00','2023-01-18 07:46:00','740',0.00,0.00,'740','2023-01-17 18:23:03','740','2023-01-17 18:23:51',10,0),('1','201',251617,'DAILY SHIFT','2023-01-18','2023-01-18 07:37:47','2023-01-19 07:37:47','740',0.00,0.00,'740','2023-01-18 18:18:22','740','2023-01-18 18:18:58',10,0),('1','201',251618,'DAILY SHIFT','2023-01-19','2023-01-19 07:36:08','2023-01-20 07:36:08','740',0.00,0.00,'740','2023-01-19 18:27:07','740','2023-01-19 18:30:34',10,0),('1','201',251619,'DAILY SHIFT','2023-01-20','2023-01-20 07:45:16','2023-01-21 07:45:16','740',0.00,0.00,'740','2023-01-20 18:30:55','740','2023-01-20 18:31:51',10,0),('1','201',251620,'DAILY SHIFT','2023-01-21','2023-01-21 07:41:36','2023-01-22 07:41:36','740',0.00,0.00,'740','2023-01-21 18:30:25','740','2023-01-21 18:30:47',10,0),('1','201',251621,'DAILY SHIFT','2023-01-22','2023-01-22 07:32:57','2023-01-23 07:32:57','740',0.00,0.00,'740','2023-01-22 18:19:52','740','2023-01-22 18:20:17',10,0),('1','201',251622,'DAILY SHIFT','2023-01-23','2023-01-23 07:34:01','2023-01-24 07:34:01','740',0.00,0.00,'740','2023-01-23 18:45:27','740','2023-01-23 18:45:56',10,0),('1','201',251623,'DAILY SHIFT','2023-01-24','2023-01-24 07:34:44','2023-01-25 07:34:44','740',0.00,0.00,'740','2023-01-24 18:42:13','740','2023-01-24 18:46:46',10,0),('1','201',251624,'DAILY SHIFT','2023-01-25','2023-01-25 07:32:19','2023-01-26 07:32:19','740',0.00,0.00,'740','2023-01-25 18:33:26','740','2023-01-25 18:33:54',10,0),('1','201',251625,'DAILY SHIFT','2023-01-26','2023-01-26 07:35:46','2023-01-27 07:35:46','740',0.00,0.00,'740','2023-01-26 18:30:19','740','2023-01-26 18:30:42',10,0),('1','201',251626,'DAILY SHIFT','2023-01-27','2023-01-27 07:32:06','2023-01-28 07:32:06','740',0.00,0.00,'740','2023-01-27 18:58:24','740','2023-01-27 18:58:57',10,0),('1','201',251627,'DAILY SHIFT','2023-01-28','2023-01-28 07:33:38','2023-01-29 07:33:38','740',0.00,0.00,'740','2023-01-28 18:32:10','740','2023-01-28 18:32:42',10,0),('1','201',251628,'Shift','2023-01-28','2023-01-28 19:16:18','2023-01-29 19:16:18','740',0.00,0.00,'740','2023-01-28 19:26:05','740','2023-01-28 19:26:21',10,0),('1','201',251629,'DAILY SHIFT','2023-01-29','2023-01-29 08:00:42','2023-01-30 08:00:42','740',0.00,0.00,'740','2023-01-29 18:44:00','740','2023-01-29 18:44:32',10,0),('1','201',251630,'DAILY SHIFT','2023-01-30','2023-01-30 07:35:21','2023-01-31 07:35:21','740',0.00,0.00,'740','2023-01-30 18:51:07','740','2023-01-30 18:51:32',10,0),('1','201',251631,'DAILY SHIFT','2023-01-31','2023-01-31 07:28:47','2023-02-01 07:28:47','740',0.00,0.00,'740','2023-01-31 18:43:44','740','2023-01-31 18:44:57',10,0),('1','201',251632,'DAILY SHIFT','2023-02-01','2023-02-01 07:49:52','2023-02-02 07:49:52','740',0.00,0.00,'740','2023-02-01 18:38:39','740','2023-02-01 18:40:00',10,0),('1','201',251633,'DAILY SHIFT','2023-02-02','2023-02-02 07:49:43','2023-02-03 07:49:43','740',0.00,0.00,'740','2023-02-02 19:03:19','740','2023-02-02 19:03:46',10,0),('1','201',251634,'DAILY SHIFT','2023-02-03','2023-02-03 07:50:03','2023-02-04 07:50:03','740',0.00,0.00,'740','2023-02-03 18:52:45','740','2023-02-03 18:53:15',10,0),('1','201',251635,'DAILY SHIFT','2023-02-04','2023-02-04 07:49:03','2023-02-05 07:49:03','740',0.00,0.00,'740','2023-02-04 19:11:54','740','2023-02-04 19:12:23',10,0),('1','201',251636,'DAILY SHIFT','2023-02-05','2023-02-05 07:47:41','2023-02-06 07:47:41','740',0.00,0.00,'740','2023-02-05 18:55:45','740','2023-02-05 18:56:09',10,0),('1','201',251637,'DAILY SHIFT','2023-02-06','2023-02-06 07:41:50','2023-02-07 07:41:50','740',0.00,0.00,'740','2023-02-06 18:55:44','740','2023-02-06 18:56:14',10,0),('1','201',251638,'DAILY SHIFT','2023-02-07','2023-02-07 07:33:26','2023-02-08 07:33:26','740',0.00,0.00,'740','2023-02-07 19:18:04','740','2023-02-07 19:18:38',10,0),('1','201',251639,'DAILY SHIFT','2023-02-08','2023-02-08 07:35:50','2023-02-09 07:35:50','740',0.00,0.00,'740','2023-02-08 18:54:41','740','2023-02-08 18:55:01',10,0),('1','201',251640,'DAILY SHIFT','2023-02-09','2023-02-09 07:41:00','2023-02-10 07:41:00','740',0.00,0.00,'740','2023-02-09 18:35:39','740','2023-02-09 18:37:26',10,0),('1','201',251641,'DAILY SHIFT','2023-02-10','2023-02-10 07:43:01','2023-02-11 07:43:01','740',0.00,0.00,'740','2023-02-10 18:41:43','740','2023-02-10 18:42:05',10,0),('1','201',251642,'DAILY SHIFT','2023-02-11','2023-02-11 07:35:40','2023-02-12 07:35:40','740',0.00,0.00,'740','2023-02-11 18:58:57','740','2023-02-11 18:59:27',10,0),('1','201',251643,'DAILY SHIFT','2023-02-12','2023-02-12 07:38:23','2023-02-13 07:38:23','740',0.00,0.00,'740','2023-02-12 18:50:17','740','2023-02-12 18:54:09',10,0),('1','201',251644,'DAILY SHIFT','2023-02-13','2023-02-13 07:36:05','2023-02-14 07:36:05','740',0.00,0.00,'740','2023-02-13 18:57:34','740','2023-02-13 18:57:59',10,0),('1','201',251645,'DAILY SHIFT','2023-02-14','2023-02-14 07:41:08','2023-02-15 07:41:08','740',0.00,0.00,'740','2023-02-14 18:56:38','740','2023-02-14 18:57:15',10,0),('1','201',251646,'DAILY SHIFT','2023-02-15','2023-02-15 07:35:18','2023-02-16 07:35:18','740',0.00,0.00,'740','2023-02-15 18:45:00','740','2023-02-15 18:45:28',10,0),('1','201',251647,'DAILY SHIFT','2023-02-16','2023-02-16 07:48:59','2023-02-17 07:48:59','740',0.00,0.00,'740','2023-02-16 18:59:18','740','2023-02-16 18:59:54',10,0),('1','201',251648,'DAILY SHIFT','2023-02-17','2023-02-17 07:45:11','2023-02-18 07:45:11','740',0.00,0.00,'740','2023-02-17 18:35:26','740','2023-02-17 18:35:54',10,0),('1','201',251649,'DAILY SHIFT','2023-02-18','2023-02-18 07:38:56','2023-02-19 07:38:56','740',0.00,0.00,'740','2023-02-18 18:55:10','740','2023-02-18 18:55:38',10,0),('1','201',251650,'DAILY SHIFT','2023-02-19','2023-02-19 07:39:15','2023-02-20 07:39:15','740',0.00,0.00,'740','2023-02-19 18:50:39','740','2023-02-19 18:53:53',10,0),('1','201',251651,'DAILY SHIFT','2023-02-20','2023-02-20 07:42:58','2023-02-21 07:42:58','740',0.00,0.00,'740','2023-02-20 19:04:15','740','2023-02-20 19:04:47',10,0),('1','201',251652,'DAILY SHIFT','2023-02-21','2023-02-21 07:40:10','2023-02-22 07:40:10','740',0.00,0.00,'740','2023-02-21 18:51:10','740','2023-02-21 18:51:53',10,0),('1','201',251653,'DAILY SHIFT','2023-02-22','2023-02-22 07:38:16','2023-02-23 07:38:16','740',0.00,0.00,'740','2023-02-22 18:42:36','740','2023-02-22 18:43:08',10,0),('1','201',251654,'DAILY SHIFT','2023-02-23','2023-02-23 07:39:29','2023-02-24 07:39:29','740',0.00,0.00,'740','2023-02-23 19:05:35','740','2023-02-23 19:06:07',10,0),('1','201',251655,'DAILY SHIFT','2023-02-24','2023-02-24 07:42:01','2023-02-25 07:42:01','740',0.00,0.00,'740','2023-02-24 19:12:39','740','2023-02-24 19:13:07',10,0),('1','201',251656,'DAILY SHIFT','2023-02-26','2023-02-26 07:30:20','2023-02-27 07:30:20','740',0.00,0.00,'740','2023-02-26 18:52:22','740','2023-02-26 18:56:07',10,0),('1','201',251657,'DAILY SHIFT','2023-02-27','2023-02-27 07:40:36','2023-02-28 07:40:36','740',0.00,0.00,'740','2023-02-27 18:55:55','740','2023-02-27 18:56:28',10,0),('1','201',251658,'DAILY SHIFT','2023-02-28','2023-02-28 07:36:08','2023-03-01 07:36:08','740',0.00,0.00,'740','2023-02-28 17:22:18','740','2023-02-28 17:23:29',10,0),('1','201',251659,'DAILY SHIFT','2023-03-01','2023-03-01 07:43:17','2023-03-02 07:43:17','740',0.00,0.00,'740','2023-03-01 18:50:50','740','2023-03-01 18:51:22',10,0),('1','201',251660,'DAILY SHIFT','2023-03-02','2023-03-02 07:27:39','2023-03-03 07:27:39','740',0.00,0.00,'740','2023-03-02 18:47:05','740','2023-03-02 18:48:37',10,0),('1','201',251661,'DAILY SHIFT','2023-03-03','2023-03-03 07:48:08','2023-03-04 07:48:08','740',0.00,0.00,'740','2023-03-03 19:07:54','740','2023-03-03 19:08:21',10,0),('1','201',251662,'DAILY SHIFT','2023-03-04','2023-03-04 07:33:11','2023-03-05 07:33:11','740',0.00,0.00,'740','2023-03-04 18:50:11','740','2023-03-04 18:50:38',10,0),('1','201',251663,'DAILY SHIFT','2023-03-05','2023-03-05 07:28:36','2023-03-06 07:28:36','740',0.00,0.00,'740','2023-03-05 18:46:11','740','2023-03-05 18:46:44',10,0),('1','201',251664,'DAILY SHIFT','2023-03-06','2023-03-06 07:36:23','2023-03-07 07:36:23','740',0.00,0.00,'740','2023-03-06 18:53:50','740','2023-03-06 18:54:13',10,0),('1','201',251665,'DAILY SHIFT','2023-03-07','2023-03-07 07:33:00','2023-03-08 07:33:00','740',0.00,0.00,'740','2023-03-07 18:38:08','740','2023-03-07 18:39:36',10,0),('1','201',251666,'DAILY SHIFT','2023-03-08','2023-03-08 07:20:12','2023-03-09 07:20:12','740',0.00,0.00,'740','2023-03-08 18:41:10','740','2023-03-08 18:41:31',10,0),('1','201',251667,'DAILY SHIFT','2023-03-09','2023-03-09 07:33:10','2023-03-10 07:33:10','740',0.00,0.00,'740','2023-03-09 18:50:37','740','2023-03-09 18:54:12',10,0),('1','201',251668,'DAILY SHIFT','2023-03-10','2023-03-10 07:29:28','2023-03-11 07:29:28','740',0.00,0.00,'740','2023-03-10 18:33:00','740','2023-03-10 18:33:21',10,0),('1','201',251669,'DAILY SHIFT','2023-03-11','2023-03-11 07:18:34','2023-03-12 07:18:34','740',0.00,0.00,'740','2023-03-11 18:50:39','740','2023-03-11 18:52:34',10,0),('1','201',251670,'DAILY SHIFT','2023-03-12','2023-03-12 07:47:59','2023-03-13 07:47:59','740',0.00,0.00,'740','2023-03-12 18:32:35','740','2023-03-12 18:32:58',10,0),('1','201',251671,'DAILY SHIFT','2023-03-13','2023-03-13 07:40:54','2023-03-14 07:40:54','740',0.00,0.00,'740','2023-03-13 18:54:18','740','2023-03-13 18:54:56',10,0),('1','201',251672,'DAILY SHIFT','2023-03-14','2023-03-14 07:33:00','2023-03-15 07:33:00','740',0.00,0.00,'740','2023-03-14 19:00:08','740','2023-03-14 19:00:54',10,0),('1','201',251673,'DAILY SHIFT','2023-03-15','2023-03-15 07:41:43','2023-03-16 07:41:43','740',0.00,0.00,'740','2023-03-15 18:55:05','740','2023-03-15 18:55:41',10,0),('1','201',251674,'DAILY SHIFT','2023-03-16','2023-03-16 07:32:52','2023-03-17 07:32:52','740',0.00,0.00,'740','2023-03-16 18:52:18','740','2023-03-16 18:52:50',10,0),('1','201',251675,'DAILY SHIFT','2023-03-17','2023-03-17 07:29:53','2023-03-18 07:29:53','740',0.00,0.00,'740','2023-03-17 18:56:13','740','2023-03-17 18:56:39',10,0),('1','201',251676,'DAILY SHIFT','2023-03-19','2023-03-19 07:24:28','2023-03-20 07:24:28','740',0.00,0.00,'740','2023-03-19 18:45:58','740','2023-03-19 18:46:22',10,0),('1','201',251677,'DAILY SHIFT','2023-03-20','2023-03-20 07:20:59','2023-03-21 07:20:59','740',0.00,0.00,'740','2023-03-20 18:59:33','740','2023-03-20 19:00:02',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4797219 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','201','1037','248839',4755531,'3071','478',0.00,370.08,0.00,0.00,370.08,219348.00,0.00,0.00,0.00),('1','201','1037','248848',4755674,'3071','478',370.08,754.90,0.00,0.00,384.82,225642.00,0.00,0.00,0.00),('1','201','1037','248900',4756338,'3071','478',754.90,1352.73,0.00,0.00,597.83,351948.00,0.00,0.00,0.00),('1','201','1037','249101',4759794,'3071','478',1352.73,2169.23,0.00,0.00,816.50,475330.00,0.00,0.00,0.00),('1','201','1037','249344',4763947,'3071','478',2169.23,2672.22,0.00,0.00,502.99,297566.50,0.00,0.00,0.00),('1','201','1037','249590',4768060,'3071','478',2672.22,3362.81,0.00,0.00,690.59,403916.90,0.00,0.00,0.00),('1','201','1037','249854',4772510,'3071','478',3362.81,4207.18,0.00,0.00,844.37,493200.90,0.00,0.00,0.00),('1','201','1037','250111',4776698,'3071','478',4207.18,4803.00,0.00,0.00,595.82,354792.00,0.00,0.00,0.00),('1','201','1037','250334',4780621,'3071','478',4803.00,5600.83,0.00,0.00,797.83,464338.00,0.00,0.00,0.00),('1','201','1037','250573',4784449,'3071','478',5600.83,6513.03,0.00,0.00,912.20,535708.80,0.00,0.00,0.00),('1','201','1037','250818',4788674,'3071','478',6513.03,7329.40,0.00,0.00,816.37,481420.80,0.00,0.00,0.00),('1','201','1037','251049',4792856,'3071','478',7329.40,8231.57,0.00,0.00,902.17,532782.00,0.00,0.00,0.00),('1','201','1037','251275',4796816,'3071','478',8231.57,8364.23,0.00,0.00,132.66,78321.00,0.00,0.00,0.00),('1','201','1037','251276',4796817,'3071','478',8364.23,8957.78,0.00,0.00,593.55,354630.00,0.00,0.00,0.00),('1','201','1037','251277',4796818,'3071','478',8957.78,9528.24,0.00,0.00,570.46,337026.00,0.00,0.00,0.00),('1','201','1037','251278',4796819,'3071','478',9528.24,10085.54,0.00,0.00,557.30,325314.10,0.00,0.00,0.00),('1','201','1037','251279',4796820,'3071','478',10085.54,10507.36,0.00,0.00,421.82,253092.00,0.00,0.00,0.00),('1','201','1037','251280',4796821,'3071','478',10507.36,11018.39,0.00,0.00,511.03,302793.00,0.00,0.00,0.00),('1','201','1037','251281',4796822,'3071','478',11018.39,11434.85,0.00,0.00,416.46,248376.00,0.00,0.00,0.00),('1','201','1037','251282',4796823,'3071','478',11434.85,11790.38,0.00,0.00,355.53,213228.00,0.00,0.00,0.00),('1','201','1037','251283',4796824,'3071','478',11790.38,12134.66,0.00,0.00,344.28,203819.40,0.00,0.00,0.00),('1','201','1037','251284',4796825,'3071','478',12134.66,12394.60,0.00,0.00,259.94,155964.00,0.00,0.00,0.00),('1','201','1037','251285',4796826,'3071','478',12394.60,12616.78,0.00,0.00,222.18,133308.00,0.00,0.00,0.00),('1','201','1037','251286',4796827,'3071','478',12616.78,12942.45,0.00,0.00,325.67,194592.00,0.00,0.00,0.00),('1','201','1037','251287',4796828,'3071','478',12942.45,13410.41,0.00,0.00,467.96,275853.50,0.00,0.00,0.00),('1','201','1037','251288',4796829,'3071','478',13410.41,13733.57,0.00,0.00,323.16,193236.00,0.00,0.00,0.00),('1','201','1037','251289',4796830,'3071','478',13733.57,14071.64,0.00,0.00,338.07,201972.00,0.00,0.00,0.00),('1','201','1037','251290',4796831,'3071','478',14071.64,14569.76,0.00,0.00,498.12,289802.00,0.00,0.00,0.00),('1','201','1037','251291',4796832,'3071','478',14569.76,14825.86,0.00,0.00,256.10,153660.00,0.00,0.00,0.00),('1','201','1037','251292',4796833,'3071','478',14825.86,15124.02,0.00,0.00,298.16,177546.00,0.00,0.00,0.00),('1','201','1037','251293',4796834,'3071','478',15124.02,15487.44,0.00,0.00,363.42,216927.00,0.00,0.00,0.00),('1','201','1037','251294',4796835,'3071','478',15487.44,15789.10,0.00,0.00,301.66,180996.00,0.00,0.00,0.00),('1','201','1037','251295',4796836,'3071','478',15789.10,16161.54,0.00,0.00,372.44,222954.00,0.00,0.00,0.00),('1','201','1037','251296',4796837,'3071','478',16161.54,16480.98,0.00,0.00,319.44,191124.00,0.00,0.00,0.00),('1','201','1037','251297',4796838,'3071','478',16480.98,16756.38,0.00,0.00,275.40,164190.00,0.00,0.00,0.00),('1','201','1037','251298',4796839,'3071','478',16756.38,17173.78,0.00,0.00,417.40,245200.00,0.00,0.00,0.00),('1','201','1037','251299',4796840,'3071','478',17173.78,17587.30,0.00,0.00,413.52,242862.00,0.00,0.00,0.00),('1','201','1037','251300',4796841,'3071','478',17587.30,18036.44,0.00,0.00,449.14,266936.50,0.00,0.00,0.00),('1','201','1037','251301',4796842,'3071','478',18036.44,18584.32,0.00,0.00,547.88,323478.00,0.00,0.00,0.00),('1','201','1037','251302',4796843,'3071','478',18584.32,19070.15,0.00,0.00,485.83,287998.00,0.00,0.00,0.00),('1','201','1037','251303',4796844,'3071','478',19070.15,19413.80,0.00,0.00,343.65,205275.00,0.00,0.00,0.00),('1','201','1037','251304',4796845,'3071','478',19413.80,19952.75,0.00,0.00,538.95,315420.00,0.00,0.00,0.00),('1','201','1037','251305',4796846,'3071','478',19952.75,20329.75,0.00,0.00,377.00,225510.00,0.00,0.00,0.00),('1','201','1037','251306',4796847,'3071','478',20329.75,20935.64,0.00,0.00,605.89,363354.00,0.00,0.00,0.00),('1','201','1037','251307',4796848,'3071','478',20935.64,21400.48,0.00,0.00,464.84,276854.00,0.00,0.00,0.00),('1','201','1037','251308',4796849,'3071','478',21400.48,21918.76,0.00,0.00,518.28,307468.00,0.00,0.00,0.00),('1','201','1037','251309',4796850,'3071','478',21918.76,22797.39,0.00,0.00,878.63,511103.00,0.00,0.00,0.00),('1','201','1037','251310',4796851,'3071','478',22797.39,23217.39,0.00,0.00,420.00,247282.50,0.00,0.00,0.00),('1','201','1037','251311',4796852,'3071','478',23217.39,23217.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251312',4796853,'3071','478',23217.39,23461.52,0.00,0.00,244.13,161128.40,0.00,0.00,0.00),('1','201','1037','251313',4796854,'3071','478',23461.52,23788.63,0.00,0.00,327.11,220434.80,0.00,0.00,0.00),('1','201','1037','251314',4796855,'3071','478',23788.63,24271.69,0.00,0.00,483.06,325240.80,0.00,0.00,0.00),('1','201','1037','251315',4796856,'3071','478',24271.69,24612.35,0.00,0.00,340.66,228928.80,0.00,0.00,0.00),('1','201','1037','251316',4796857,'3071','478',24612.35,25022.99,0.00,0.00,410.64,275755.20,0.00,0.00,0.00),('1','201','1037','251317',4796858,'3071','478',25022.99,25402.62,0.00,0.00,379.63,256148.40,0.00,0.00,0.00),('1','201','1037','251318',4796859,'3071','478',25402.62,25950.68,0.00,0.00,548.06,364080.80,0.00,0.00,0.00),('1','201','1037','251319',4796860,'3071','478',25950.68,26401.58,0.00,0.00,450.90,302432.00,0.00,0.00,0.00),('1','201','1037','251320',4796861,'3071','478',26401.58,26769.21,0.00,0.00,367.63,248919.60,0.00,0.00,0.00),('1','201','1037','251321',4796862,'3071','478',26769.21,27172.36,0.00,0.00,403.15,272153.20,0.00,0.00,0.00),('1','201','1037','251322',4796863,'3071','478',27172.36,27521.81,0.00,0.00,349.45,234146.00,0.00,0.00,0.00),('1','201','1037','251323',4796864,'3071','478',27521.81,27865.17,0.00,0.00,343.36,231707.20,0.00,0.00,0.00),('1','201','1037','251324',4796865,'3071','478',27865.17,28280.52,0.00,0.00,415.35,282286.00,0.00,0.00,0.00),('1','201','1037','251325',4796866,'3071','478',28280.52,28712.65,0.00,0.00,432.13,293658.40,0.00,0.00,0.00),('1','201','1037','251326',4796867,'3071','478',28712.65,29112.81,0.00,0.00,400.16,272108.80,0.00,0.00,0.00),('1','201','1037','251327',4796868,'3071','478',29112.81,29613.54,0.00,0.00,500.73,340268.40,0.00,0.00,0.00),('1','201','1037','251328',4796869,'3071','478',29613.54,30271.38,0.00,0.00,657.84,445902.40,0.00,0.00,0.00),('1','201','1037','251329',4796870,'3071','478',30271.38,31628.54,0.00,0.00,1357.16,868144.00,0.00,0.00,0.00),('1','201','1037','251330',4796871,'3071','478',31628.54,33640.02,0.00,0.00,2011.48,1287632.00,0.00,0.00,0.00),('1','201','1037','251331',4796872,'3071','478',33640.02,34516.16,0.00,0.00,876.14,564911.00,0.00,0.00,0.00),('1','201','1037','251332',4796873,'3071','478',34516.16,35354.79,0.00,0.00,838.63,541749.50,0.00,0.00,0.00),('1','201','1037','251333',4796874,'3071','478',35354.79,35551.34,0.00,0.00,196.55,127397.50,0.00,0.00,0.00),('1','201','1037','251334',4796875,'3071','478',35551.34,36209.57,0.00,0.00,658.23,422479.50,0.00,0.00,0.00),('1','201','1037','251335',4796876,'3071','478',36209.57,36609.27,0.00,0.00,399.70,258199.10,0.00,0.00,0.00),('1','201','1037','251336',4796877,'3071','478',36609.27,37025.34,0.00,0.00,416.07,270445.50,0.00,0.00,0.00),('1','201','1037','251337',4796878,'3071','478',37025.34,37488.91,0.00,0.00,463.57,296100.50,0.00,0.00,0.00),('1','201','1037','251338',4796879,'3071','478',37488.91,37829.19,0.00,0.00,340.28,219832.00,0.00,0.00,0.00),('1','201','1037','251339',4796880,'3071','478',37829.19,38233.31,0.00,0.00,404.12,259678.00,0.00,0.00,0.00),('1','201','1037','251340',4796881,'3071','478',38233.31,38527.97,0.00,0.00,294.66,189999.00,0.00,0.00,0.00),('1','201','1037','251341',4796882,'3071','478',38527.97,38910.49,0.00,0.00,382.52,246778.00,0.00,0.00,0.00),('1','201','1037','251342',4796883,'3071','478',38910.49,39330.16,0.00,0.00,419.67,272230.50,0.00,0.00,0.00),('1','201','1037','251343',4796884,'3071','478',39330.16,39619.18,0.00,0.00,289.02,187128.00,0.00,0.00,0.00),('1','201','1037','251344',4796885,'3071','478',39619.18,39960.00,0.00,0.00,340.82,221533.00,0.00,0.00,0.00),('1','201','1037','251345',4796886,'3071','478',39960.00,40394.38,0.00,0.00,434.38,280547.00,0.00,0.00,0.00),('1','201','1037','251346',4796887,'3071','478',40394.38,40855.95,0.00,0.00,461.57,299660.50,0.00,0.00,0.00),('1','201','1037','251347',4796888,'3071','478',40855.95,41291.89,0.00,0.00,435.94,283241.00,0.00,0.00,0.00),('1','201','1037','251348',4796889,'3071','478',41291.89,41822.16,0.00,0.00,530.27,344180.50,0.00,0.00,0.00),('1','201','1037','251349',4796890,'3071','478',41822.16,42465.51,0.00,0.00,643.35,417337.50,0.00,0.00,0.00),('1','201','1037','251350',4796891,'3071','478',42465.51,43351.28,0.00,0.00,885.77,574850.50,0.00,0.00,0.00),('1','201','1037','251351',4796892,'3071','478',43351.28,44054.49,0.00,0.00,703.21,455376.50,0.00,0.00,0.00),('1','201','1037','251352',4796893,'3071','478',44054.49,44198.04,0.00,0.00,143.55,92752.50,0.00,0.00,0.00),('1','201','1037','251353',4796894,'3071','478',44198.04,44761.92,0.00,0.00,563.88,364947.00,0.00,0.00,0.00),('1','201','1037','251354',4796895,'3071','478',44761.92,45246.05,0.00,0.00,484.13,313934.50,0.00,0.00,0.00),('1','201','1037','251355',4796896,'3071','478',45246.05,45656.00,0.00,0.00,409.95,265432.50,0.00,0.00,0.00),('1','201','1037','251356',4796897,'3071','478',45656.00,46115.72,0.00,0.00,459.72,298068.00,0.00,0.00,0.00),('1','201','1037','251357',4796898,'3071','478',46115.72,46474.20,0.00,0.00,358.48,232382.00,0.00,0.00,0.00),('1','201','1037','251358',4796899,'3071','478',46474.20,46474.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251359',4796900,'3071','478',46474.20,46559.17,0.00,0.00,84.97,54930.50,0.00,0.00,0.00),('1','201','1037','251360',4796901,'3071','478',46559.17,47069.08,0.00,0.00,509.91,331066.50,0.00,0.00,0.00),('1','201','1037','251361',4796902,'3071','478',47069.08,47535.68,0.00,0.00,466.60,299225.00,0.00,0.00,0.00),('1','201','1037','251362',4796903,'3071','478',47535.68,48352.70,0.00,0.00,817.02,529008.00,0.00,0.00,0.00),('1','201','1037','251363',4796904,'3071','478',48352.70,49167.12,0.00,0.00,814.42,521583.00,0.00,0.00,0.00),('1','201','1037','251364',4796905,'3071','478',49167.12,49867.26,0.00,0.00,700.14,451071.00,0.00,0.00,0.00),('1','201','1037','251365',4796906,'3071','478',49867.26,50288.59,0.00,0.00,421.33,272814.50,0.00,0.00,0.00),('1','201','1037','251366',4796907,'3071','478',50288.59,50818.89,0.00,0.00,530.30,341845.20,0.00,0.00,0.00),('1','201','1037','251367',4796908,'3071','478',50818.89,51496.24,0.00,0.00,677.35,467871.60,0.00,0.00,0.00),('1','201','1037','251368',4796909,'3071','478',51496.24,52029.90,0.00,0.00,533.66,370943.36,0.00,0.00,0.00),('1','201','1037','251369',4796910,'3071','478',52029.90,52507.41,0.00,0.00,477.51,331323.08,0.00,0.00,0.00),('1','201','1037','251370',4796911,'3071','478',52507.41,53118.25,0.00,0.00,610.84,419599.76,0.00,0.00,0.00),('1','201','1037','251371',4796912,'3071','478',53118.25,53577.83,0.00,0.00,459.58,319383.68,0.00,0.00,0.00),('1','201','1037','251372',4796913,'3071','478',53577.83,54259.91,0.00,0.00,682.08,470283.68,0.00,0.00,0.00),('1','201','1037','251373',4796914,'3071','478',54259.91,54761.60,0.00,0.00,501.69,346712.24,0.00,0.00,0.00),('1','201','1037','251374',4796915,'3071','478',54761.60,55404.59,0.00,0.00,642.99,442197.04,0.00,0.00,0.00),('1','201','1037','251375',4796916,'3071','478',55404.59,55995.51,0.00,0.00,590.92,406352.32,0.00,0.00,0.00),('1','201','1037','251376',4796917,'3071','478',55995.51,56495.97,0.00,0.00,500.46,347814.16,0.00,0.00,0.00),('1','201','1037','251377',4796918,'3071','478',56495.97,56929.99,0.00,0.00,434.02,320910.36,0.00,0.00,0.00),('1','201','1037','251378',4796919,'3071','478',56929.99,57424.64,0.00,0.00,494.65,363721.76,0.00,0.00,0.00),('1','201','1037','251379',4796920,'3071','478',57424.64,57824.03,0.00,0.00,399.39,294074.60,0.00,0.00,0.00),('1','201','1037','251380',4796921,'3071','478',57824.03,58427.11,0.00,0.00,603.08,438402.76,0.00,0.00,0.00),('1','201','1037','251381',4796922,'3071','478',58427.11,59034.33,0.00,0.00,607.22,444502.80,0.00,0.00,0.00),('1','201','1037','251382',4796923,'3071','478',59034.33,59639.10,0.00,0.00,604.77,446529.24,0.00,0.00,0.00),('1','201','1037','251383',4796924,'3071','478',59639.10,60176.66,0.00,0.00,537.56,396826.40,0.00,0.00,0.00),('1','201','1037','251384',4796925,'3071','478',60176.66,60781.15,0.00,0.00,604.49,445452.60,0.00,0.00,0.00),('1','201','1037','251385',4796926,'3071','478',60781.15,61263.76,0.00,0.00,482.61,357131.40,0.00,0.00,0.00),('1','201','1037','251386',4796927,'3071','478',61263.76,61804.55,0.00,0.00,540.79,395784.60,0.00,0.00,0.00),('1','201','1037','251387',4796928,'3071','478',61804.55,62330.69,0.00,0.00,526.14,388815.60,0.00,0.00,0.00),('1','201','1037','251388',4796929,'3071','478',62330.69,63057.88,0.00,0.00,727.19,531246.04,0.00,0.00,0.00),('1','201','1037','251389',4796930,'3071','478',63057.88,63616.92,0.00,0.00,559.04,413139.60,0.00,0.00,0.00),('1','201','1037','251390',4796931,'3071','478',63616.92,64217.79,0.00,0.00,600.87,444203.80,0.00,0.00,0.00),('1','201','1037','251391',4796932,'3071','478',64217.79,64821.25,0.00,0.00,603.46,446010.40,0.00,0.00,0.00),('1','201','1037','251392',4796933,'3071','478',64821.25,65399.45,0.00,0.00,578.20,426388.72,0.00,0.00,0.00),('1','201','1037','251393',4796934,'3071','478',65399.45,65882.57,0.00,0.00,483.12,357508.80,0.00,0.00,0.00),('1','201','1037','251394',4796935,'3071','478',65882.57,66498.98,0.00,0.00,616.41,448256.40,0.00,0.00,0.00),('1','201','1037','251395',4796936,'3071','478',66498.98,67045.59,0.00,0.00,546.61,403149.40,0.00,0.00,0.00),('1','201','1037','251396',4796937,'3071','478',67045.59,67553.05,0.00,0.00,507.46,374816.40,0.00,0.00,0.00),('1','201','1037','251397',4796938,'3071','478',67553.05,68101.92,0.00,0.00,548.87,403963.80,0.00,0.00,0.00),('1','201','1037','251398',4796939,'3071','478',68101.92,68614.27,0.00,0.00,512.35,378685.36,0.00,0.00,0.00),('1','201','1037','251399',4796940,'3071','478',68614.27,69097.56,0.00,0.00,483.29,357458.60,0.00,0.00,0.00),('1','201','1037','251400',4796941,'3071','478',69097.56,69217.38,0.00,0.00,119.82,88666.80,0.00,0.00,0.00),('1','201','1037','251401',4796942,'3071','478',69217.38,69217.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251402',4796943,'3071','478',69217.38,69954.51,0.00,0.00,737.13,534014.20,0.00,0.00,0.00),('1','201','1037','251403',4796944,'3071','478',69954.51,70546.00,0.00,0.00,591.49,436932.60,0.00,0.00,0.00),('1','201','1037','251404',4796945,'3071','478',70546.00,70992.14,0.00,0.00,446.14,327866.60,0.00,0.00,0.00),('1','201','1037','251405',4796946,'3071','478',70992.14,71442.39,0.00,0.00,450.25,332921.00,0.00,0.00,0.00),('1','201','1037','251406',4796947,'3071','478',71442.39,71612.16,0.00,0.00,169.77,125629.80,0.00,0.00,0.00),('1','201','1037','251407',4796948,'3071','478',71612.16,72201.33,0.00,0.00,589.17,429152.16,0.00,0.00,0.00),('1','201','1037','251408',4796949,'3071','478',72201.33,72719.77,0.00,0.00,518.44,381929.60,0.00,0.00,0.00),('1','201','1037','251409',4796950,'3071','478',72719.77,73436.13,0.00,0.00,716.36,526784.40,0.00,0.00,0.00),('1','201','1037','251410',4796951,'3071','478',73436.13,73993.27,0.00,0.00,557.14,411887.60,0.00,0.00,0.00),('1','201','1037','251411',4796952,'3071','478',73993.27,74572.91,0.00,0.00,579.64,424863.60,0.00,0.00,0.00),('1','201','1037','251412',4796953,'3071','478',74572.91,75347.11,0.00,0.00,774.20,563170.36,0.00,0.00,0.00),('1','201','1037','251413',4796954,'3071','478',75347.11,76079.55,0.00,0.00,732.44,536725.60,0.00,0.00,0.00),('1','201','1037','251414',4796955,'3071','478',76079.55,76647.16,0.00,0.00,567.61,416137.40,0.00,0.00,0.00),('1','201','1037','251415',4796956,'3071','478',76647.16,77261.02,0.00,0.00,613.86,453728.40,0.00,0.00,0.00),('1','201','1037','251416',4796957,'3071','478',77261.02,77921.42,0.00,0.00,660.40,488432.00,0.00,0.00,0.00),('1','201','1037','251417',4796958,'3071','478',77921.42,79927.28,0.00,0.00,2005.86,1436794.40,0.00,0.00,0.00),('1','201','1037','251418',4796959,'3071','478',79927.28,81212.12,0.00,0.00,1284.84,945355.96,0.00,0.00,0.00),('1','201','1037','251419',4796960,'3071','478',81212.12,82929.37,0.00,0.00,1717.25,1254969.00,0.00,0.00,0.00),('1','201','1037','251420',4796961,'3071','478',82929.37,84778.70,0.00,0.00,1849.33,1345415.20,0.00,0.00,0.00),('1','201','1037','251421',4796962,'3071','478',84778.70,87422.19,0.00,0.00,2643.49,1915922.60,0.00,0.00,0.00),('1','201','1037','251422',4796963,'3071','478',87422.19,87747.42,0.00,0.00,325.23,236727.36,0.00,0.00,0.00),('1','201','1037','251423',4796964,'3071','478',87747.42,88637.04,0.00,0.00,889.62,637044.36,0.00,0.00,0.00),('1','201','1037','251424',4796965,'3071','478',88637.04,89217.00,0.00,0.00,579.96,420370.40,0.00,0.00,0.00),('1','201','1037','251425',4796966,'3071','478',89217.00,89692.25,0.00,0.00,475.25,349779.36,0.00,0.00,0.00),('1','201','1037','251426',4796967,'3071','478',89692.25,90434.00,0.00,0.00,741.75,536861.00,0.00,0.00,0.00),('1','201','1037','251427',4796968,'3071','478',90434.00,91318.16,0.00,0.00,884.16,642068.40,0.00,0.00,0.00),('1','201','1037','251428',4796969,'3071','478',91318.16,91628.76,0.00,0.00,310.60,229316.00,0.00,0.00,0.00),('1','201','1037','251429',4796970,'3071','478',91628.76,91628.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251430',4796971,'3071','478',91628.76,91948.58,0.00,0.00,319.82,228966.80,0.00,0.00,0.00),('1','201','1037','251431',4796972,'3071','478',91948.58,92655.81,0.00,0.00,707.23,515430.20,0.00,0.00,0.00),('1','201','1037','251432',4796973,'3071','478',92655.81,93503.29,0.00,0.00,847.48,620647.84,0.00,0.00,0.00),('1','201','1037','251433',4796974,'3071','478',93503.29,94252.08,0.00,0.00,748.79,550347.00,0.00,0.00,0.00),('1','201','1037','251434',4796975,'3071','478',94252.08,95337.78,0.00,0.00,1085.70,784457.08,0.00,0.00,0.00),('1','201','1037','251435',4796976,'3071','478',95337.78,96467.37,0.00,0.00,1129.59,805514.60,0.00,0.00,0.00),('1','201','1037','251436',4796977,'3071','478',96467.37,97612.84,0.00,0.00,1145.47,827957.80,0.00,0.00,0.00),('1','201','1037','251437',4796978,'3071','478',97612.84,98792.05,0.00,0.00,1179.21,836579.40,0.00,0.00,0.00),('1','201','1037','251438',4796979,'3071','478',98792.05,99701.18,0.00,0.00,909.13,655224.84,0.00,0.00,0.00),('1','201','1037','251439',4796980,'3071','478',99701.18,100511.09,0.00,0.00,809.91,586507.40,0.00,0.00,0.00),('1','201','1037','251440',4796981,'3071','478',100511.09,101131.08,0.00,0.00,619.99,451961.60,0.00,0.00,0.00),('1','201','1037','251441',4796982,'3071','478',101131.08,101754.48,0.00,0.00,623.40,453561.88,0.00,0.00,0.00),('1','201','1037','251442',4796983,'3071','478',101754.48,102384.39,0.00,0.00,629.91,461733.40,0.00,0.00,0.00),('1','201','1037','251443',4796984,'3071','478',102384.39,103011.83,0.00,0.00,627.44,461533.60,0.00,0.00,0.00),('1','201','1037','251444',4796985,'3071','478',103011.83,103845.27,0.00,0.00,833.44,613782.64,0.00,0.00,0.00),('1','201','1037','251445',4796986,'3071','478',103845.27,104679.38,0.00,0.00,834.11,613149.40,0.00,0.00,0.00),('1','201','1037','251446',4796987,'3071','478',104679.38,105439.82,0.00,0.00,760.44,561955.60,0.00,0.00,0.00),('1','201','1037','251447',4796988,'3071','478',105439.82,106252.82,0.00,0.00,813.00,600080.00,0.00,0.00,0.00),('1','201','1037','251448',4796989,'3071','478',106252.82,107015.37,0.00,0.00,762.55,562285.44,0.00,0.00,0.00),('1','201','1037','251449',4796990,'3071','478',107015.37,107728.87,0.00,0.00,713.50,527088.00,0.00,0.00,0.00),('1','201','1037','251450',4796991,'3071','478',107728.87,109101.26,0.00,0.00,1372.39,1003549.12,0.00,0.00,0.00),('1','201','1037','251451',4796992,'3071','478',109101.26,110028.35,0.00,0.00,927.09,683524.96,0.00,0.00,0.00),('1','201','1037','251452',4796993,'3071','478',110028.35,110940.04,0.00,0.00,911.69,661714.60,0.00,0.00,0.00),('1','201','1037','251453',4796994,'3071','478',110940.04,112299.26,0.00,0.00,1359.22,981292.80,0.00,0.00,0.00),('1','201','1037','251454',4796995,'3071','478',112299.26,113155.04,0.00,0.00,855.78,628437.20,0.00,0.00,0.00),('1','201','1037','251455',4796996,'3071','478',113155.04,114184.34,0.00,0.00,1029.30,748020.00,0.00,0.00,0.00),('1','201','1037','251456',4796997,'3071','478',114184.34,115573.53,0.00,0.00,1389.19,995814.60,0.00,0.00,0.00),('1','201','1037','251457',4796998,'3071','478',115573.53,115697.53,0.00,0.00,124.00,86914.72,0.00,0.00,0.00),('1','201','1037','251458',4796999,'3071','478',115697.53,115697.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251459',4797000,'3071','478',115697.53,116567.96,0.00,0.00,870.43,619713.16,0.00,0.00,0.00),('1','201','1037','251460',4797001,'3071','478',116567.96,117332.83,0.00,0.00,764.87,558780.32,0.00,0.00,0.00),('1','201','1037','251461',4797002,'3071','478',117332.83,117966.42,0.00,0.00,633.59,463513.24,0.00,0.00,0.00),('1','201','1037','251462',4797003,'3071','478',117966.42,118540.11,0.00,0.00,573.69,423298.60,0.00,0.00,0.00),('1','201','1037','251463',4797004,'3071','478',118540.11,119715.09,0.00,0.00,1174.98,848123.20,0.00,0.00,0.00),('1','201','1037','251464',4797005,'3071','478',119715.09,120904.99,0.00,0.00,1189.90,860330.00,0.00,0.00,0.00),('1','201','1037','251465',4797006,'3071','478',120904.99,122002.63,0.00,0.00,1097.64,795379.60,0.00,0.00,0.00),('1','201','1037','251466',4797007,'3071','478',122002.63,123329.41,0.00,0.00,1326.78,951500.76,0.00,0.00,0.00),('1','201','1037','251467',4797008,'3071','478',123329.41,123962.80,0.00,0.00,633.39,461360.60,0.00,0.00,0.00),('1','201','1037','251468',4797009,'3071','478',123962.80,124775.10,0.00,0.00,812.30,597186.00,0.00,0.00,0.00),('1','201','1037','251469',4797010,'3071','478',124775.10,125431.89,0.00,0.00,656.79,481526.04,0.00,0.00,0.00),('1','201','1037','251470',4797011,'3071','478',125431.89,126150.23,0.00,0.00,718.34,530933.60,0.00,0.00,0.00),('1','201','1037','251471',4797012,'3071','478',126150.23,127048.71,0.00,0.00,898.48,649211.20,0.00,0.00,0.00),('1','201','1037','251472',4797013,'3071','478',127048.71,127814.65,0.00,0.00,765.94,559645.60,0.00,0.00,0.00),('1','201','1037','251473',4797014,'3071','478',127814.65,128426.40,0.00,0.00,611.75,451207.36,0.00,0.00,0.00),('1','201','1037','251474',4797015,'3071','478',128426.40,128974.55,0.00,0.00,548.15,405147.00,0.00,0.00,0.00),('1','201','1037','251475',4797016,'3071','478',128974.55,129556.26,0.00,0.00,581.71,430465.40,0.00,0.00,0.00),('1','201','1037','251476',4797017,'3071','478',129556.26,130522.20,0.00,0.00,965.94,693537.44,0.00,0.00,0.00),('1','201','1037','251477',4797018,'3071','478',130522.20,131542.67,0.00,0.00,1020.47,737946.44,0.00,0.00,0.00),('1','201','1037','251478',4797019,'3071','478',131542.67,132528.26,0.00,0.00,985.59,712968.60,0.00,0.00,0.00),('1','201','1037','251479',4797020,'3071','478',132528.26,133888.66,0.00,0.00,1360.40,978866.00,0.00,0.00,0.00),('1','201','1037','251480',4797021,'3071','478',133888.66,135433.00,0.00,0.00,1544.34,1111351.60,0.00,0.00,0.00),('1','201','1037','251481',4797022,'3071','478',135433.00,136258.54,0.00,0.00,825.54,602099.60,0.00,0.00,0.00),('1','201','1037','251482',4797023,'3071','478',136258.54,137196.29,0.00,0.00,937.75,688457.00,0.00,0.00,0.00),('1','201','1037','251483',4797024,'3071','478',137196.29,138255.81,0.00,0.00,1059.52,774540.80,0.00,0.00,0.00),('1','201','1037','251484',4797025,'3071','478',138255.81,139139.43,0.00,0.00,883.62,646904.80,0.00,0.00,0.00),('1','201','1037','251485',4797026,'3071','478',139139.43,139682.70,0.00,0.00,543.27,397399.80,0.00,0.00,0.00),('1','201','1037','251486',4797027,'3071','478',139682.70,139682.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251487',4797028,'3071','478',139682.70,139941.49,0.00,0.00,258.79,191504.60,0.00,0.00,0.00),('1','201','1037','251488',4797029,'3071','478',139941.49,140771.57,0.00,0.00,830.08,610255.20,0.00,0.00,0.00),('1','201','1037','251489',4797030,'3071','478',140771.57,141940.02,0.00,0.00,1168.45,848505.00,0.00,0.00,0.00),('1','201','1037','251490',4797031,'3071','478',141940.02,142966.18,0.00,0.00,1026.16,753401.24,0.00,0.00,0.00),('1','201','1037','251491',4797032,'3071','478',142966.18,143800.17,0.00,0.00,833.99,606460.60,0.00,0.00,0.00),('1','201','1037','251492',4797033,'3071','478',143800.17,144445.20,0.00,0.00,645.03,476816.20,0.00,0.00,0.00),('1','201','1037','251493',4797034,'3071','478',144445.20,144954.36,0.00,0.00,509.16,375629.56,0.00,0.00,0.00),('1','201','1037','251494',4797035,'3071','478',144954.36,145830.03,0.00,0.00,875.67,638051.80,0.00,0.00,0.00),('1','201','1037','251495',4797036,'3071','478',145830.03,146697.99,0.00,0.00,867.96,638198.40,0.00,0.00,0.00),('1','201','1037','251496',4797037,'3071','478',146697.99,147691.77,0.00,0.00,993.78,720503.20,0.00,0.00,0.00),('1','201','1037','251497',4797038,'3071','478',147691.77,148451.11,0.00,0.00,759.34,558171.60,0.00,0.00,0.00),('1','201','1037','251498',4797039,'3071','478',148451.11,149707.71,0.00,0.00,1256.60,904760.00,0.00,0.00,0.00),('1','201','1037','251499',4797040,'3071','478',149707.71,150709.18,0.00,0.00,1001.47,723729.80,0.00,0.00,0.00),('1','201','1037','251500',4797041,'3071','478',150709.18,152153.54,0.00,0.00,1444.36,1029990.24,0.00,0.00,0.00),('1','201','1037','251501',4797042,'3071','478',152153.54,152869.00,0.00,0.00,715.46,525942.40,0.00,0.00,0.00),('1','201','1037','251502',4797043,'3071','478',152869.00,153900.13,0.00,0.00,1031.13,749726.20,0.00,0.00,0.00),('1','201','1037','251503',4797044,'3071','478',153900.13,155341.27,0.00,0.00,1441.14,1039823.60,0.00,0.00,0.00),('1','201','1037','251504',4797045,'3071','478',155341.27,157334.86,0.00,0.00,1993.59,1427102.56,0.00,0.00,0.00),('1','201','1037','251505',4797046,'3071','478',157334.86,158528.48,0.00,0.00,1193.62,864314.80,0.00,0.00,0.00),('1','201','1037','251506',4797047,'3071','478',158528.48,159690.63,0.00,0.00,1162.15,843557.00,0.00,0.00,0.00),('1','201','1037','251507',4797048,'3071','478',159690.63,161189.72,0.00,0.00,1499.09,1076750.76,0.00,0.00,0.00),('1','201','1037','251508',4797049,'3071','478',161189.72,162150.17,0.00,0.00,960.45,705211.00,0.00,0.00,0.00),('1','201','1037','251509',4797050,'3071','478',162150.17,163268.33,0.00,0.00,1118.16,812244.76,0.00,0.00,0.00),('1','201','1037','251510',4797051,'3071','478',163268.33,163447.50,0.00,0.00,179.17,132585.80,0.00,0.00,0.00),('1','201','1037','251511',4797052,'3071','478',163447.50,163447.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251512',4797053,'3071','478',163447.50,164468.68,0.00,0.00,1021.18,726523.20,0.00,0.00,0.00),('1','201','1037','251513',4797054,'3071','478',164468.68,165975.82,0.00,0.00,1507.14,1085209.60,0.00,0.00,0.00),('1','201','1037','251514',4797055,'3071','478',165975.82,167150.15,0.00,0.00,1174.33,846234.20,0.00,0.00,0.00),('1','201','1037','251515',4797056,'3071','478',167150.15,168564.02,0.00,0.00,1413.87,1014429.80,0.00,0.00,0.00),('1','201','1037','251516',4797057,'3071','478',168564.02,169892.67,0.00,0.00,1328.65,953809.00,0.00,0.00,0.00),('1','201','1037','251517',4797058,'3071','478',169892.67,171689.47,0.00,0.00,1796.80,1282739.00,0.00,0.00,0.00),('1','201','1037','251518',4797059,'3071','478',171689.47,173347.95,0.00,0.00,1658.48,1180321.48,0.00,0.00,0.00),('1','201','1037','251519',4797060,'3071','478',173347.95,175678.39,0.00,0.00,2330.44,1652525.32,0.00,0.00,0.00),('1','201','1037','251520',4797061,'3071','478',175678.39,177469.78,0.00,0.00,1791.39,1275754.60,0.00,0.00,0.00),('1','201','1037','251521',4797062,'3071','478',177469.78,180205.18,0.00,0.00,2735.40,1931484.00,0.00,0.00,0.00),('1','201','1037','251522',4797063,'3071','478',180205.18,182185.46,0.00,0.00,1980.28,1411815.20,0.00,0.00,0.00),('1','201','1037','251523',4797064,'3071','478',182185.46,184322.89,0.00,0.00,2137.43,1515346.20,0.00,0.00,0.00),('1','201','1037','251524',4797065,'3071','478',184322.89,187190.33,0.00,0.00,2867.44,2028186.92,0.00,0.00,0.00),('1','201','1037','251525',4797066,'3071','478',187190.33,187675.61,0.00,0.00,485.28,344697.20,0.00,0.00,0.00),('1','201','1037','251526',4797067,'3071','478',187675.61,187675.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251527',4797068,'3071','478',187675.61,189604.18,0.00,0.00,1928.57,1395603.20,0.00,0.00,0.00),('1','201','1037','251528',4797069,'3071','478',189604.18,192460.73,0.00,0.00,2856.55,2065828.00,0.00,0.00,0.00),('1','201','1037','251529',4797070,'3071','478',192460.73,194724.18,0.00,0.00,2263.45,1643970.40,0.00,0.00,0.00),('1','201','1037','251530',4797071,'3071','478',194724.18,196483.33,0.00,0.00,1759.15,1283921.00,0.00,0.00,0.00),('1','201','1037','251531',4797072,'3071','478',196483.33,198363.65,0.00,0.00,1880.32,1373603.20,0.00,0.00,0.00),('1','201','1037','251532',4797073,'3071','478',198363.65,200448.09,0.00,0.00,2084.44,1521849.40,0.00,0.00,0.00),('1','201','1037','251533',4797074,'3071','478',200448.09,203319.26,0.00,0.00,2871.17,2083529.70,0.00,0.00,0.00),('1','201','1037','251534',4797075,'3071','478',203319.26,204711.90,0.00,0.00,1392.64,1031406.40,0.00,0.00,0.00),('1','201','1037','251535',4797076,'3071','478',204711.90,206591.41,0.00,0.00,1879.51,1382298.10,0.00,0.00,0.00),('1','201','1037','251536',4797077,'3071','478',206591.41,209714.15,0.00,0.00,3122.74,2267239.90,0.00,0.00,0.00),('1','201','1037','251537',4797078,'3071','478',209714.15,211788.37,0.00,0.00,2074.22,1516405.10,0.00,0.00,0.00),('1','201','1037','251538',4797079,'3071','478',211788.37,212437.46,0.00,0.00,649.09,475128.40,0.00,0.00,0.00),('1','201','1037','251539',4797080,'3071','478',212437.46,212437.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251540',4797081,'3071','478',212437.46,214971.13,0.00,0.00,2533.67,1899357.60,0.00,0.00,0.00),('1','201','1037','251541',4797082,'3071','478',214971.13,219018.99,0.00,0.00,4047.86,3019608.30,0.00,0.00,0.00),('1','201','1037','251542',4797083,'3071','478',219018.99,229177.52,0.00,0.00,10158.53,7428050.90,0.00,0.00,0.00),('1','201','1037','251543',4797084,'3071','478',229177.52,231734.91,0.00,0.00,2557.39,1915461.70,0.00,0.00,0.00),('1','201','1037','251544',4797085,'3071','478',231734.91,235410.37,0.00,0.00,3675.46,2743913.80,0.00,0.00,0.00),('1','201','1037','251545',4797086,'3071','478',235410.37,237395.12,0.00,0.00,1984.75,1471240.00,0.00,0.00,0.00),('1','201','1037','251546',4797087,'3071','478',237395.12,237395.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251547',4797088,'3071','478',237395.12,237834.33,0.00,0.00,439.21,338103.80,0.00,0.00,0.00),('1','201','1037','251548',4797089,'3071','478',237834.33,238783.01,0.00,0.00,948.68,727470.40,0.00,0.00,0.00),('1','201','1037','251549',4797090,'3071','478',238783.01,239683.83,0.00,0.00,900.82,696199.60,0.00,0.00,0.00),('1','201','1037','251550',4797091,'3071','478',239683.83,241244.51,0.00,0.00,1560.68,1181790.80,0.00,0.00,0.00),('1','201','1037','251551',4797092,'3071','478',241244.51,242949.09,0.00,0.00,1704.58,1288223.60,0.00,0.00,0.00),('1','201','1037','251552',4797093,'3071','478',242949.09,244515.35,0.00,0.00,1566.26,1187480.80,0.00,0.00,0.00),('1','201','1037','251553',4797094,'3071','478',244515.35,246328.49,0.00,0.00,1813.14,1364737.60,0.00,0.00,0.00),('1','201','1037','251554',4797095,'3071','478',246328.49,247585.27,0.00,0.00,1256.78,958134.40,0.00,0.00,0.00),('1','201','1037','251555',4797096,'3071','478',247585.27,249639.99,0.00,0.00,2054.72,1549761.60,0.00,0.00,0.00),('1','201','1037','251556',4797097,'3071','478',249639.99,250364.99,0.00,0.00,725.00,536500.00,0.00,0.00,0.00),('1','201','1037','251557',4797098,'3071','478',250364.99,251126.71,0.00,0.00,761.72,594141.60,0.00,0.00,0.00),('1','201','1037','251558',4797099,'3071','478',251126.71,252102.71,0.00,0.00,976.00,746980.00,0.00,0.00,0.00),('1','201','1037','251559',4797100,'3071','478',252102.71,253924.19,0.00,0.00,1821.48,1374454.40,0.00,0.00,0.00),('1','201','1037','251560',4797101,'3071','478',253924.19,254990.77,0.00,0.00,1066.58,813792.00,0.00,0.00,0.00),('1','201','1037','251561',4797102,'3071','478',254990.77,256118.48,0.00,0.00,1127.71,862533.80,0.00,0.00,0.00),('1','201','1037','251562',4797103,'3071','478',256118.48,257566.29,0.00,0.00,1447.81,1101191.80,0.00,0.00,0.00),('1','201','1037','251563',4797104,'3071','478',257566.29,259004.63,0.00,0.00,1438.34,1089225.20,0.00,0.00,0.00),('1','201','1037','251564',4797105,'3071','478',259004.63,260919.97,0.00,0.00,1915.34,1450940.80,0.00,0.00,0.00),('1','201','1037','251565',4797106,'3071','478',260919.97,262110.24,0.00,0.00,1190.27,896932.20,0.00,0.00,0.00),('1','201','1037','251566',4797107,'3071','478',262110.24,262110.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251567',4797108,'3071','478',262110.24,262618.89,0.00,0.00,508.65,388747.00,0.00,0.00,0.00),('1','201','1037','251568',4797109,'3071','478',262618.89,264475.93,0.00,0.00,1857.04,1413991.20,0.00,0.00,0.00),('1','201','1037','251569',4797110,'3071','478',264475.93,266367.64,0.00,0.00,1891.71,1443433.80,0.00,0.00,0.00),('1','201','1037','251570',4797111,'3071','478',266367.64,269159.97,0.00,0.00,2792.33,2070605.90,0.00,0.00,0.00),('1','201','1037','251571',4797112,'3071','478',269159.97,270618.84,0.00,0.00,1458.87,1091368.60,0.00,0.00,0.00),('1','201','1037','251572',4797113,'3071','478',270618.84,272070.34,0.00,0.00,1451.50,1081455.00,0.00,0.00,0.00),('1','201','1037','251573',4797114,'3071','478',272070.34,274951.36,0.00,0.00,2881.02,2086055.60,0.00,0.00,0.00),('1','201','1037','251574',4797115,'3071','478',274951.36,276426.65,0.00,0.00,1475.29,1087397.90,0.00,0.00,0.00),('1','201','1037','251575',4797116,'3071','478',276426.65,277152.46,0.00,0.00,725.81,556541.80,0.00,0.00,0.00),('1','201','1037','251576',4797117,'3071','478',277152.46,279892.62,0.00,0.00,2740.16,2004394.80,0.00,0.00,0.00),('1','201','1037','251577',4797118,'3071','478',279892.62,281951.66,0.00,0.00,2059.04,1517921.20,0.00,0.00,0.00),('1','201','1037','251578',4797119,'3071','478',281951.66,283134.89,0.00,0.00,1183.23,887814.40,0.00,0.00,0.00),('1','201','1037','251579',4797120,'3071','478',283134.89,283857.75,0.00,0.00,722.86,562045.80,0.00,0.00,0.00),('1','201','1037','251580',4797121,'3071','478',283857.75,285159.63,0.00,0.00,1301.88,963141.40,0.00,0.00,0.00),('1','201','1037','251581',4797122,'3071','478',285159.63,286161.08,0.00,0.00,1001.45,738781.00,0.00,0.00,0.00),('1','201','1037','251582',4797123,'3071','478',286161.08,286517.31,0.00,0.00,356.23,260240.40,0.00,0.00,0.00),('1','201','1037','251583',4797124,'3071','478',286517.31,286517.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251584',4797125,'3071','478',286517.31,288062.45,0.00,0.00,1545.14,1149909.20,0.00,0.00,0.00),('1','201','1037','251585',4797126,'3071','478',288062.45,290153.23,0.00,0.00,2090.78,1528258.40,0.00,0.00,0.00),('1','201','1037','251586',4797127,'3071','478',290153.23,291193.97,0.00,0.00,1040.74,785352.20,0.00,0.00,0.00),('1','201','1037','251587',4797128,'3071','478',291193.97,291951.15,0.00,0.00,757.18,581990.40,0.00,0.00,0.00),('1','201','1037','251588',4797129,'3071','478',291951.15,293170.74,0.00,0.00,1219.59,906375.20,0.00,0.00,0.00),('1','201','1037','251589',4797130,'3071','478',293170.74,295190.69,0.00,0.00,2019.95,1488357.10,0.00,0.00,0.00),('1','201','1037','251590',4797131,'3071','478',295190.69,296469.10,0.00,0.00,1278.41,970677.40,0.00,0.00,0.00),('1','201','1037','251591',4797132,'3071','478',296469.10,297664.20,0.00,0.00,1195.10,906873.00,0.00,0.00,0.00),('1','201','1037','251592',4797133,'3071','478',297664.20,299157.66,0.00,0.00,1493.46,1117753.80,0.00,0.00,0.00),('1','201','1037','251593',4797134,'3071','478',299157.66,299992.55,0.00,0.00,834.89,647271.10,0.00,0.00,0.00),('1','201','1037','251594',4797135,'3071','478',299992.55,300691.13,0.00,0.00,698.58,495616.80,0.00,0.00,0.00),('1','201','1037','251595',4797136,'3071','478',300691.13,302204.18,0.00,0.00,1513.05,1066540.50,0.00,0.00,0.00),('1','201','1037','251596',4797137,'3071','478',302204.18,302859.80,0.00,0.00,655.62,465170.20,0.00,0.00,0.00),('1','201','1037','251597',4797138,'3071','478',302859.80,303692.92,0.00,0.00,833.12,590095.20,0.00,0.00,0.00),('1','201','1037','251598',4797139,'3071','478',303692.92,304484.22,0.00,0.00,791.30,561213.00,0.00,0.00,0.00),('1','201','1037','251599',4797140,'3071','478',304484.22,305246.19,0.00,0.00,761.97,540168.70,0.00,0.00,0.00),('1','201','1037','251600',4797141,'3071','478',305246.19,306096.62,0.00,0.00,850.43,603377.40,0.00,0.00,0.00),('1','201','1037','251601',4797142,'3071','478',306096.62,307131.57,0.00,0.00,1034.95,732309.50,0.00,0.00,0.00),('1','201','1037','251602',4797143,'3071','478',307131.57,308078.16,0.00,0.00,946.59,671224.60,0.00,0.00,0.00),('1','201','1037','251603',4797144,'3071','478',308078.16,308829.42,0.00,0.00,751.26,532289.60,0.00,0.00,0.00),('1','201','1037','251604',4797145,'3071','478',308829.42,310086.39,0.00,0.00,1256.97,888063.70,0.00,0.00,0.00),('1','201','1037','251605',4797146,'3071','478',310086.39,310980.28,0.00,0.00,893.89,631211.90,0.00,0.00,0.00),('1','201','1037','251606',4797147,'3071','478',310980.28,310980.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251607',4797148,'3071','478',310980.28,312124.76,0.00,0.00,1144.48,809336.50,0.00,0.00,0.00),('1','201','1037','251608',4797149,'3071','478',312124.76,313588.88,0.00,0.00,1464.12,1032505.20,0.00,0.00,0.00),('1','201','1037','251609',4797150,'3071','478',313588.88,315302.53,0.00,0.00,1713.65,1207531.50,0.00,0.00,0.00),('1','201','1037','251610',4797151,'3071','478',315302.53,317304.47,0.00,0.00,2001.94,1408982.40,0.00,0.00,0.00),('1','201','1037','251611',4797152,'3071','478',317304.47,318785.48,0.00,0.00,1481.01,1043582.10,0.00,0.00,0.00),('1','201','1037','251612',4797153,'3071','478',318785.48,320490.15,0.00,0.00,1704.67,1202445.70,0.00,0.00,0.00),('1','201','1037','251613',4797154,'3071','478',320490.15,322244.17,0.00,0.00,1754.02,1234769.20,0.00,0.00,0.00),('1','201','1037','251614',4797155,'3071','478',322244.17,324346.64,0.00,0.00,2102.47,1480875.10,0.00,0.00,0.00),('1','201','1037','251615',4797156,'3071','478',324346.64,325593.14,0.00,0.00,1246.50,881355.00,0.00,0.00,0.00),('1','201','1037','251616',4797157,'3071','478',325593.14,326520.29,0.00,0.00,927.15,657596.50,0.00,0.00,0.00),('1','201','1037','251617',4797158,'3071','478',326520.29,327304.57,0.00,0.00,784.28,556358.80,0.00,0.00,0.00),('1','201','1037','251618',4797159,'3071','478',327304.57,328028.45,0.00,0.00,723.88,513409.80,0.00,0.00,0.00),('1','201','1037','251619',4797160,'3071','478',328028.45,328956.04,0.00,0.00,927.59,656588.90,0.00,0.00,0.00),('1','201','1037','251620',4797161,'3071','478',328956.04,329807.32,0.00,0.00,851.28,603848.80,0.00,0.00,0.00),('1','201','1037','251621',4797162,'3071','478',329807.32,330583.03,0.00,0.00,775.71,550474.10,0.00,0.00,0.00),('1','201','1037','251622',4797163,'3071','478',330583.03,331857.34,0.00,0.00,1274.31,900155.10,0.00,0.00,0.00),('1','201','1037','251623',4797164,'3071','478',331857.34,332605.00,0.00,0.00,747.66,530463.60,0.00,0.00,0.00),('1','201','1037','251624',4797165,'3071','478',332605.00,333264.00,0.00,0.00,659.00,466840.00,0.00,0.00,0.00),('1','201','1037','251625',4797166,'3071','478',333264.00,333828.13,0.00,0.00,564.13,400392.30,0.00,0.00,0.00),('1','201','1037','251626',4797167,'3071','478',333828.13,334758.07,0.00,0.00,929.94,657237.40,0.00,0.00,0.00),('1','201','1037','251627',4797168,'3071','478',334758.07,335784.63,0.00,0.00,1026.56,725112.60,0.00,0.00,0.00),('1','201','1037','251628',4797169,'3071','478',335784.63,335784.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','201','1037','251629',4797170,'3071','478',335784.63,337146.27,0.00,0.00,1361.64,959929.40,0.00,0.00,0.00),('1','201','1037','251630',4797171,'3071','478',337146.27,338333.31,0.00,0.00,1187.04,853234.20,0.00,0.00,0.00),('1','201','1037','251631',4797172,'3071','478',338333.31,339271.83,0.00,0.00,938.52,678369.60,0.00,0.00,0.00),('1','201','1037','251632',4797173,'3071','478',339271.83,340166.44,0.00,0.00,894.61,645640.30,0.00,0.00,0.00),('1','201','1037','251633',4797174,'3071','478',340166.44,341068.95,0.00,0.00,902.51,657887.30,0.00,0.00,0.00),('1','201','1037','251634',4797175,'3071','478',341068.95,341774.72,0.00,0.00,705.77,513277.10,0.00,0.00,0.00),('1','201','1037','251635',4797176,'3071','478',341774.72,342676.50,0.00,0.00,901.78,646719.40,0.00,0.00,0.00),('1','201','1037','251636',4797177,'3071','478',342676.50,343970.55,0.00,0.00,1294.05,931711.50,0.00,0.00,0.00),('1','201','1037','251637',4797178,'3071','478',343970.55,344735.76,0.00,0.00,765.21,554688.30,0.00,0.00,0.00),('1','201','1037','251638',4797179,'3071','478',344735.76,345720.03,0.00,0.00,984.27,716042.10,0.00,0.00,0.00),('1','201','1037','251639',4797180,'3071','478',345720.03,346488.50,0.00,0.00,768.47,558763.10,0.00,0.00,0.00),('1','201','1037','251640',4797181,'3071','478',346488.50,347261.55,0.00,0.00,773.05,562541.50,0.00,0.00,0.00),('1','201','1037','251641',4797182,'3071','478',347261.55,347965.24,0.00,0.00,703.69,513093.70,0.00,0.00,0.00),('1','201','1037','251642',4797183,'3071','478',347965.24,348851.48,0.00,0.00,886.24,644675.20,0.00,0.00,0.00),('1','201','1037','251643',4797184,'3071','478',348851.48,349645.54,0.00,0.00,794.06,579273.80,0.00,0.00,0.00),('1','201','1037','251644',4797185,'3071','478',349645.54,350657.68,0.00,0.00,1012.14,730522.20,0.00,0.00,0.00),('1','201','1037','251645',4797186,'3071','478',350657.68,351248.30,0.00,0.00,590.62,430807.60,0.00,0.00,0.00),('1','201','1037','251646',4797187,'3071','478',351248.30,352103.07,0.00,0.00,854.77,623457.10,0.00,0.00,0.00),('1','201','1037','251647',4797188,'3071','478',352103.07,352673.61,0.00,0.00,570.54,415744.20,0.00,0.00,0.00),('1','201','1037','251648',4797189,'3071','478',352673.61,353465.99,0.00,0.00,792.38,571957.40,0.00,0.00,0.00),('1','201','1037','251649',4797190,'3071','478',353465.99,354132.49,0.00,0.00,666.50,485615.00,0.00,0.00,0.00),('1','201','1037','251650',4797191,'3071','478',354132.49,354939.10,0.00,0.00,806.61,586965.30,0.00,0.00,0.00),('1','201','1037','251651',4797192,'3071','478',354939.10,355921.35,0.00,0.00,982.25,705177.50,0.00,0.00,0.00),('1','201','1037','251652',4797193,'3071','478',355921.35,356516.81,0.00,0.00,595.46,434100.80,0.00,0.00,0.00),('1','201','1037','251653',4797194,'3071','478',356516.81,357029.66,0.00,0.00,512.85,374380.50,0.00,0.00,0.00),('1','201','1037','251654',4797195,'3071','478',357029.66,357783.41,0.00,0.00,753.75,548737.50,0.00,0.00,0.00),('1','201','1037','251655',4797196,'3071','478',357783.41,358921.89,0.00,0.00,1138.48,829410.40,0.00,0.00,0.00),('1','201','1037','251656',4797197,'3071','478',358921.89,359927.58,0.00,0.00,1005.69,733208.70,0.00,0.00,0.00),('1','201','1037','251657',4797198,'3071','478',359927.58,360837.13,0.00,0.00,909.55,663506.50,0.00,0.00,0.00),('1','201','1037','251658',4797199,'3071','478',360837.13,361693.61,0.00,0.00,856.48,622365.40,0.00,0.00,0.00),('1','201','1037','251659',4797200,'3071','478',361693.61,362548.66,0.00,0.00,855.05,623826.50,0.00,0.00,0.00),('1','201','1037','251660',4797201,'3071','478',362548.66,363283.99,0.00,0.00,735.33,536790.90,0.00,0.00,0.00),('1','201','1037','251661',4797202,'3071','478',363283.99,364079.06,0.00,0.00,795.07,576081.10,0.00,0.00,0.00),('1','201','1037','251662',4797203,'3071','478',364079.06,364885.65,0.00,0.00,806.59,588480.70,0.00,0.00,0.00),('1','201','1037','251663',4797204,'3071','478',364885.65,365680.04,0.00,0.00,794.39,578869.70,0.00,0.00,0.00),('1','201','1037','251664',4797205,'3071','478',365680.04,366513.51,0.00,0.00,833.47,604893.10,0.00,0.00,0.00),('1','201','1037','251665',4797206,'3071','478',366513.51,367490.56,0.00,0.00,977.05,703976.50,0.00,0.00,0.00),('1','201','1037','251666',4797207,'3071','478',367490.56,368219.95,0.00,0.00,729.39,530864.70,0.00,0.00,0.00),('1','201','1037','251667',4797208,'3071','478',368219.95,368836.56,0.00,0.00,616.61,449114.00,0.00,0.00,0.00),('1','201','1037','251668',4797209,'3071','478',368836.56,369484.58,0.00,0.00,648.02,470804.60,0.00,0.00,0.00),('1','201','1037','251669',4797210,'3071','478',369484.58,370362.84,0.00,0.00,878.26,640709.80,0.00,0.00,0.00),('1','201','1037','251670',4797211,'3071','478',370362.84,370944.45,0.00,0.00,581.61,424575.30,0.00,0.00,0.00),('1','201','1037','251671',4797212,'3071','478',370944.45,371696.45,0.00,0.00,752.00,544490.00,0.00,0.00,0.00),('1','201','1037','251672',4797213,'3071','478',371696.45,372541.82,0.00,0.00,845.37,614195.10,0.00,0.00,0.00),('1','201','1037','251673',4797214,'3071','478',372541.82,373185.28,0.00,0.00,643.46,469275.80,0.00,0.00,0.00),('1','201','1037','251674',4797215,'3071','478',373185.28,373822.77,0.00,0.00,637.49,465202.70,0.00,0.00,0.00),('1','201','1037','251675',4797216,'3071','478',373822.77,374763.70,0.00,0.00,940.93,686878.90,0.00,0.00,0.00),('1','201','1037','251676',4797217,'3071','478',374763.70,375901.34,0.00,0.00,1137.64,828655.90,0.00,0.00,0.00),('1','201','1037','251677',4797218,'3071','478',375901.34,378093.17,0.00,0.00,2191.83,1546435.90,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=713996 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','201','248839','478',538.00,600.00,0.00,370.08,199103.04,219348.00,20244.96,707349),('1','201','248848','478',538.00,600.00,0.00,384.82,207033.16,225642.00,18608.84,707373),('1','201','248900','478',538.00,600.00,0.00,597.83,321632.54,351948.00,30315.46,707492),('1','201','249101','478',538.00,600.00,0.00,816.50,439277.00,475330.00,36053.00,708022),('1','201','249344','478',538.00,600.00,0.00,502.99,270608.62,297566.50,26957.88,708632),('1','201','249590','478',538.00,600.00,0.00,690.59,371537.42,403916.90,32379.48,709260),('1','201','249854','478',538.00,600.00,0.00,844.37,454271.06,493200.90,38929.84,709936),('1','201','250111','478',538.00,600.00,0.00,595.82,320551.16,354792.00,34240.84,710591),('1','201','250334','478',538.00,600.00,0.00,797.83,429232.54,464338.00,35105.46,711165),('1','201','250573','478',538.00,600.00,0.00,912.20,490763.60,535708.80,44945.20,711762),('1','201','250818','478',538.00,600.00,0.00,816.37,439207.06,481420.80,42213.74,712397),('1','201','251049','478',538.00,600.00,0.00,902.17,485367.46,532782.00,47414.54,712996),('1','201','251275','478',538.00,600.00,0.00,132.66,71371.08,78321.00,6949.92,713593),('1','201','251276','478',538.00,600.00,0.00,593.55,319329.90,354630.00,35300.10,713594),('1','201','251277','478',538.00,600.00,0.00,570.46,306907.48,337026.00,30118.52,713595),('1','201','251278','478',538.00,600.00,0.00,557.30,299827.40,325314.10,25486.70,713596),('1','201','251279','478',538.00,600.00,0.00,421.82,226939.16,253092.00,26152.84,713597),('1','201','251280','478',538.00,600.00,0.00,511.03,274934.14,302793.00,27858.86,713598),('1','201','251281','478',538.00,600.00,0.00,416.46,224055.48,248376.00,24320.52,713599),('1','201','251282','478',538.00,600.00,0.00,355.53,191275.14,213228.00,21952.86,713600),('1','201','251283','478',538.00,600.00,0.00,344.28,185222.64,203819.40,18596.76,713601),('1','201','251284','478',538.00,600.00,0.00,259.94,139847.72,155964.00,16116.28,713602),('1','201','251285','478',538.00,600.00,0.00,222.18,119532.84,133308.00,13775.16,713603),('1','201','251286','478',538.00,600.00,0.00,325.67,175210.46,194592.00,19381.54,713604),('1','201','251287','478',538.00,600.00,0.00,467.96,251762.48,275853.50,24091.02,713605),('1','201','251288','478',538.00,600.00,0.00,323.16,173860.08,193236.00,19375.92,713606),('1','201','251289','478',538.00,600.00,0.00,338.07,181881.66,201972.00,20090.34,713607),('1','201','251290','478',538.00,600.00,0.00,498.12,267988.56,289802.00,21813.44,713608),('1','201','251291','478',538.00,600.00,0.00,256.10,137781.80,153660.00,15878.20,713609),('1','201','251292','478',538.00,600.00,0.00,298.16,160410.08,177546.00,17135.92,713610),('1','201','251293','478',538.00,600.00,0.00,363.42,195519.96,216927.00,21407.04,713611),('1','201','251294','478',538.00,600.00,0.00,301.66,162293.08,180996.00,18702.92,713612),('1','201','251295','478',538.00,600.00,0.00,372.44,200372.72,222954.00,22581.28,713613),('1','201','251296','478',538.00,600.00,0.00,319.44,171858.72,191124.00,19265.28,713614),('1','201','251297','478',538.00,600.00,0.00,275.40,148165.20,164190.00,16024.80,713615),('1','201','251298','478',538.00,600.00,0.00,417.40,224561.20,245200.00,20638.80,713616),('1','201','251299','478',538.00,600.00,0.00,413.52,222473.76,242862.00,20388.24,713617),('1','201','251300','478',538.00,600.00,0.00,449.14,241637.32,266936.50,25299.18,713618),('1','201','251301','478',538.00,600.00,0.00,547.88,294759.44,323478.00,28718.56,713619),('1','201','251302','478',538.00,600.00,0.00,485.83,261376.54,287998.00,26621.46,713620),('1','201','251303','478',538.00,600.00,0.00,343.65,184883.70,205275.00,20391.30,713621),('1','201','251304','478',538.00,600.00,0.00,538.95,289955.10,315420.00,25464.90,713622),('1','201','251305','478',538.00,600.00,0.00,377.00,202826.00,225510.00,22684.00,713623),('1','201','251306','478',538.00,600.00,0.00,605.89,325968.82,363354.00,37385.18,713624),('1','201','251307','478',538.00,600.00,0.00,464.84,250083.92,276854.00,26770.08,713625),('1','201','251308','478',538.00,600.00,0.00,518.28,278834.64,307468.00,28633.36,713626),('1','201','251309','478',538.00,600.00,0.00,878.63,472702.94,511103.00,38400.06,713627),('1','201','251310','478',538.00,600.00,0.00,420.00,225960.00,247282.50,21322.50,713628),('1','201','251311','478',538.00,600.00,0.00,0.00,0.00,0.00,0.00,713629),('1','201','251312','478',612.00,680.00,0.00,244.13,149407.56,161128.40,11720.84,713630),('1','201','251313','478',612.00,680.00,0.00,327.11,200191.32,220434.80,20243.48,713631),('1','201','251314','478',612.00,680.00,0.00,483.06,295632.72,325240.80,29608.08,713632),('1','201','251315','478',612.00,680.00,0.00,340.66,208483.92,228928.80,20444.88,713633),('1','201','251316','478',612.00,680.00,0.00,410.64,251311.68,275755.20,24443.52,713634),('1','201','251317','478',612.00,680.00,0.00,379.63,232333.56,256148.40,23814.84,713635),('1','201','251318','478',612.00,680.00,0.00,548.06,335412.72,364080.80,28668.08,713636),('1','201','251319','478',612.00,680.00,0.00,450.90,275950.80,302432.00,26481.20,713637),('1','201','251320','478',612.00,680.00,0.00,367.63,224989.56,248919.60,23930.04,713638),('1','201','251321','478',612.00,680.00,0.00,403.15,246727.80,272153.20,25425.40,713639),('1','201','251322','478',612.00,680.00,0.00,349.45,213863.40,234146.00,20282.60,713640),('1','201','251323','478',612.00,680.00,0.00,343.36,210136.32,231707.20,21570.88,713641),('1','201','251324','478',612.00,680.00,0.00,415.35,254194.20,282286.00,28091.80,713642),('1','201','251325','478',612.00,680.00,0.00,432.13,264463.56,293658.40,29194.84,713643),('1','201','251326','478',612.00,680.00,0.00,400.16,244897.92,272108.80,27210.88,713644),('1','201','251327','478',612.00,680.00,0.00,500.73,306446.76,340268.40,33821.64,713645),('1','201','251328','478',612.00,680.00,0.00,657.84,402598.08,445902.40,43304.32,713646),('1','201','251329','478',612.00,650.00,0.00,1357.16,830581.92,868144.00,37562.08,713647),('1','201','251330','478',612.00,650.00,0.00,2011.48,1231025.76,1287632.00,56606.24,713648),('1','201','251331','478',612.00,650.00,0.00,876.14,536197.68,564911.00,28713.32,713649),('1','201','251332','478',612.00,650.00,0.00,838.63,513241.56,541749.50,28507.94,713650),('1','201','251333','478',612.00,650.00,0.00,196.55,120288.60,127397.50,7108.90,713651),('1','201','251334','478',612.00,650.00,0.00,658.23,402836.76,422479.50,19642.74,713652),('1','201','251335','478',612.00,650.00,0.00,399.70,244616.40,258199.10,13582.70,713653),('1','201','251336','478',612.00,650.00,0.00,416.07,254634.84,270445.50,15810.66,713654),('1','201','251337','478',612.00,650.00,0.00,463.57,283704.84,296100.50,12395.66,713655),('1','201','251338','478',612.00,650.00,0.00,340.28,208251.36,219832.00,11580.64,713656),('1','201','251339','478',612.00,650.00,0.00,404.12,247321.44,259678.00,12356.56,713657),('1','201','251340','478',612.00,650.00,0.00,294.66,180331.92,189999.00,9667.08,713658),('1','201','251341','478',612.00,650.00,0.00,382.52,234102.24,246778.00,12675.76,713659),('1','201','251342','478',612.00,650.00,0.00,419.67,256838.04,272230.50,15392.46,713660),('1','201','251343','478',612.00,650.00,0.00,289.02,176880.24,187128.00,10247.76,713661),('1','201','251344','478',612.00,650.00,0.00,340.82,208581.84,221533.00,12951.16,713662),('1','201','251345','478',612.00,650.00,0.00,434.38,265840.56,280547.00,14706.44,713663),('1','201','251346','478',612.00,650.00,0.00,461.57,282480.84,299660.50,17179.66,713664),('1','201','251347','478',612.00,650.00,0.00,435.94,266795.28,283241.00,16445.72,713665),('1','201','251348','478',612.00,650.00,0.00,530.27,324525.24,344180.50,19655.26,713666),('1','201','251349','478',612.00,650.00,0.00,643.35,393730.20,417337.50,23607.30,713667),('1','201','251350','478',612.00,650.00,0.00,885.77,542091.24,574850.50,32759.26,713668),('1','201','251351','478',612.00,650.00,0.00,703.21,430364.52,455376.50,25011.98,713669),('1','201','251352','478',612.00,650.00,0.00,143.55,87852.60,92752.50,4899.90,713670),('1','201','251353','478',612.00,650.00,0.00,563.88,345094.56,364947.00,19852.44,713671),('1','201','251354','478',612.00,650.00,0.00,484.13,296287.56,313934.50,17646.94,713672),('1','201','251355','478',612.00,650.00,0.00,409.95,250889.40,265432.50,14543.10,713673),('1','201','251356','478',612.00,650.00,0.00,459.72,281348.64,298068.00,16719.36,713674),('1','201','251357','478',612.00,650.00,0.00,358.48,219389.76,232382.00,12992.24,713675),('1','201','251358','478',612.00,620.00,0.00,0.00,0.00,0.00,0.00,713676),('1','201','251359','478',602.00,650.00,0.00,84.97,51151.94,54930.50,3778.56,713677),('1','201','251360','478',602.00,650.00,0.00,509.91,306965.82,331066.50,24100.68,713678),('1','201','251361','478',602.00,650.00,0.00,466.60,280893.20,299225.00,18331.80,713679),('1','201','251362','478',602.00,650.00,0.00,817.02,491846.04,529008.00,37161.96,713680),('1','201','251363','478',602.00,650.00,0.00,814.42,490280.84,521583.00,31302.16,713681),('1','201','251364','478',602.00,650.00,0.00,700.14,421484.28,451071.00,29586.72,713682),('1','201','251365','478',602.00,650.00,0.00,421.33,253640.66,272814.50,19173.84,713683),('1','201','251366','478',602.00,650.00,0.00,530.30,319240.60,341845.20,22604.60,713684),('1','201','251367','478',602.00,696.00,0.00,677.35,407764.70,467871.60,60106.90,713685),('1','201','251368','478',602.00,696.00,0.00,533.66,321263.32,370943.36,49680.04,713686),('1','201','251369','478',602.00,696.00,0.00,477.51,287461.02,331323.08,43862.06,713687),('1','201','251370','478',602.00,696.00,0.00,610.84,367725.68,419599.76,51874.08,713688),('1','201','251371','478',602.00,696.00,0.00,459.58,276667.16,319383.68,42716.52,713689),('1','201','251372','478',602.00,696.00,0.00,682.08,410612.16,470283.68,59671.52,713690),('1','201','251373','478',602.00,696.00,0.00,501.69,302017.38,346712.24,44694.86,713691),('1','201','251374','478',602.00,696.00,0.00,642.99,387079.98,442197.04,55117.06,713692),('1','201','251375','478',602.00,696.00,0.00,590.92,355733.84,406352.32,50618.48,713693),('1','201','251376','478',602.00,696.00,0.00,500.46,301276.92,347814.16,46537.24,713694),('1','201','251377','478',602.00,696.00,0.00,434.02,321174.80,320910.36,-264.44,713695),('1','201','251378','478',740.00,740.00,0.00,494.65,366041.00,363721.76,-2319.24,713696),('1','201','251379','478',740.00,740.00,0.00,399.39,295548.60,294074.60,-1474.00,713697),('1','201','251380','478',740.00,740.00,0.00,603.08,446279.20,438402.76,-7876.44,713698),('1','201','251381','478',740.00,740.00,0.00,607.22,449342.80,444502.80,-4840.00,713699),('1','201','251382','478',740.00,740.00,0.00,604.77,447529.80,446529.24,-1000.56,713700),('1','201','251383','478',740.00,740.00,0.00,537.56,397794.40,396826.40,-968.00,713701),('1','201','251384','478',740.00,740.00,0.00,604.49,447322.60,445452.60,-1870.00,713702),('1','201','251385','478',740.00,740.00,0.00,482.61,357131.40,357131.40,0.00,713703),('1','201','251386','478',740.00,740.00,0.00,540.79,400184.60,395784.60,-4400.00,713704),('1','201','251387','478',740.00,740.00,0.00,526.14,389343.60,388815.60,-528.00,713705),('1','201','251388','478',740.00,740.00,0.00,727.19,538120.60,531246.04,-6874.56,713706),('1','201','251389','478',740.00,740.00,0.00,559.04,413689.60,413139.60,-550.00,713707),('1','201','251390','478',740.00,740.00,0.00,600.87,444643.80,444203.80,-440.00,713708),('1','201','251391','478',740.00,740.00,0.00,603.46,446560.40,446010.40,-550.00,713709),('1','201','251392','478',740.00,740.00,0.00,578.20,427868.00,426388.72,-1479.28,713710),('1','201','251393','478',740.00,740.00,0.00,483.12,357508.80,357508.80,0.00,713711),('1','201','251394','478',740.00,740.00,0.00,616.41,456143.40,448256.40,-7887.00,713712),('1','201','251395','478',740.00,740.00,0.00,546.61,404491.40,403149.40,-1342.00,713713),('1','201','251396','478',740.00,740.00,0.00,507.46,375520.40,374816.40,-704.00,713714),('1','201','251397','478',740.00,740.00,0.00,548.87,406163.80,403963.80,-2200.00,713715),('1','201','251398','478',740.00,740.00,0.00,512.35,379139.00,378685.36,-453.64,713716),('1','201','251399','478',740.00,740.00,0.00,483.29,357634.60,357458.60,-176.00,713717),('1','201','251400','478',740.00,740.00,0.00,119.82,88666.80,88666.80,0.00,713718),('1','201','251401','478',740.00,740.00,0.00,0.00,0.00,0.00,0.00,713719),('1','201','251402','478',692.00,740.00,0.00,737.13,510093.96,534014.20,23920.24,713720),('1','201','251403','478',692.00,740.00,0.00,591.49,409311.08,436932.60,27621.52,713721),('1','201','251404','478',692.00,740.00,0.00,446.14,308728.88,327866.60,19137.72,713722),('1','201','251405','478',692.00,740.00,0.00,450.25,311573.00,332921.00,21348.00,713723),('1','201','251406','478',692.00,740.00,0.00,169.77,117480.84,125629.80,8148.96,713724),('1','201','251407','478',692.00,740.00,0.00,589.17,407705.64,429152.16,21446.52,713725),('1','201','251408','478',692.00,740.00,0.00,518.44,358760.48,381929.60,23169.12,713726),('1','201','251409','478',692.00,740.00,0.00,716.36,495721.12,526784.40,31063.28,713727),('1','201','251410','478',692.00,740.00,0.00,557.14,385540.88,411887.60,26346.72,713728),('1','201','251411','478',692.00,740.00,0.00,579.64,401110.88,424863.60,23752.72,713729),('1','201','251412','478',692.00,740.00,0.00,774.20,535746.40,563170.36,27423.96,713730),('1','201','251413','478',692.00,740.00,0.00,732.44,506848.48,536725.60,29877.12,713731),('1','201','251414','478',692.00,740.00,0.00,567.61,392786.12,416137.40,23351.28,713732),('1','201','251415','478',692.00,740.00,0.00,613.86,424791.12,453728.40,28937.28,713733),('1','201','251416','478',692.00,740.00,0.00,660.40,456996.80,488432.00,31435.20,713734),('1','201','251417','478',692.00,740.00,0.00,2005.86,1388055.12,1436794.40,48739.28,713735),('1','201','251418','478',692.00,740.00,0.00,1284.84,889109.28,945355.96,56246.68,713736),('1','201','251419','478',692.00,740.00,0.00,1717.25,1188337.00,1254969.00,66632.00,713737),('1','201','251420','478',692.00,740.00,0.00,1849.33,1279736.36,1345415.20,65678.84,713738),('1','201','251421','478',692.00,740.00,0.00,2643.49,1829295.08,1915922.60,86627.52,713739),('1','201','251422','478',692.00,740.00,0.00,325.23,225059.16,236727.36,11668.20,713740),('1','201','251423','478',692.00,740.00,0.00,889.62,615617.04,637044.36,21427.32,713741),('1','201','251424','478',692.00,740.00,0.00,579.96,401332.32,420370.40,19038.08,713742),('1','201','251425','478',692.00,740.00,0.00,475.25,328873.00,349779.36,20906.36,713743),('1','201','251426','478',692.00,740.00,0.00,741.75,513291.00,536861.00,23570.00,713744),('1','201','251427','478',692.00,740.00,0.00,884.16,611838.72,642068.40,30229.68,713745),('1','201','251428','478',692.00,740.00,0.00,310.60,214935.20,229316.00,14380.80,713746),('1','201','251429','478',692.00,740.00,0.00,0.00,0.00,0.00,0.00,713747),('1','201','251430','478',685.00,740.00,0.00,319.82,219076.70,228966.80,9890.10,713748),('1','201','251431','478',685.00,740.00,0.00,707.23,484452.55,515430.20,30977.65,713749),('1','201','251432','478',685.00,740.00,0.00,847.48,580523.80,620647.84,40124.04,713750),('1','201','251433','478',685.00,740.00,0.00,748.79,512921.15,550347.00,37425.85,713751),('1','201','251434','478',685.00,740.00,0.00,1085.70,743704.50,784457.08,40752.58,713752),('1','201','251435','478',685.00,740.00,0.00,1129.59,773769.15,805514.60,31745.45,713753),('1','201','251436','478',685.00,740.00,0.00,1145.47,784646.95,827957.80,43310.85,713754),('1','201','251437','478',685.00,740.00,0.00,1179.21,807758.85,836579.40,28820.55,713755),('1','201','251438','478',685.00,740.00,0.00,909.13,622754.05,655224.84,32470.79,713756),('1','201','251439','478',685.00,740.00,0.00,809.91,554788.35,586507.40,31719.05,713757),('1','201','251440','478',685.00,740.00,0.00,619.99,424693.15,451961.60,27268.45,713758),('1','201','251441','478',685.00,740.00,0.00,623.40,427029.00,453561.88,26532.88,713759),('1','201','251442','478',685.00,740.00,0.00,629.91,431488.35,461733.40,30245.05,713760),('1','201','251443','478',685.00,740.00,0.00,627.44,429796.40,461533.60,31737.20,713761),('1','201','251444','478',685.00,740.00,0.00,833.44,570906.40,613782.64,42876.24,713762),('1','201','251445','478',685.00,740.00,0.00,834.11,571365.35,613149.40,41784.05,713763),('1','201','251446','478',685.00,740.00,0.00,760.44,520901.40,561955.60,41054.20,713764),('1','201','251447','478',685.00,740.00,0.00,813.00,556905.00,600080.00,43175.00,713765),('1','201','251448','478',685.00,740.00,0.00,762.55,522346.75,562285.44,39938.69,713766),('1','201','251449','478',685.00,740.00,0.00,713.50,488747.50,527088.00,38340.50,713767),('1','201','251450','478',685.00,740.00,0.00,1372.39,940087.15,1003549.12,63461.97,713768),('1','201','251451','478',685.00,740.00,0.00,927.09,635056.65,683524.96,48468.31,713769),('1','201','251452','478',685.00,740.00,0.00,911.69,624507.65,661714.60,37206.95,713770),('1','201','251453','478',685.00,740.00,0.00,1359.22,931065.70,981292.80,50227.10,713771),('1','201','251454','478',685.00,740.00,0.00,855.78,586209.30,628437.20,42227.90,713772),('1','201','251455','478',685.00,740.00,0.00,1029.30,705070.50,748020.00,42949.50,713773),('1','201','251456','478',685.00,740.00,0.00,1389.19,951595.15,995814.60,44219.45,713774),('1','201','251457','478',685.00,740.00,0.00,124.00,84940.00,86914.72,1974.72,713775),('1','201','251458','478',685.00,740.00,0.00,0.00,0.00,0.00,0.00,713776),('1','201','251459','478',685.00,740.00,0.00,870.43,596244.55,619713.16,23468.61,713777),('1','201','251460','478',685.00,740.00,0.00,764.87,523935.95,558780.32,34844.37,713778),('1','201','251461','478',685.00,740.00,0.00,633.59,434009.15,463513.24,29504.09,713779),('1','201','251462','478',685.00,740.00,0.00,573.69,392977.65,423298.60,30320.95,713780),('1','201','251463','478',685.00,740.00,0.00,1174.98,804861.30,848123.20,43261.90,713781),('1','201','251464','478',685.00,740.00,0.00,1189.90,815081.50,860330.00,45248.50,713782),('1','201','251465','478',685.00,740.00,0.00,1097.64,751883.40,795379.60,43496.20,713783),('1','201','251466','478',685.00,740.00,0.00,1326.78,908844.30,951500.76,42656.46,713784),('1','201','251467','478',685.00,740.00,0.00,633.39,433872.15,461360.60,27488.45,713785),('1','201','251468','478',685.00,740.00,0.00,812.30,556425.50,597186.00,40760.50,713786),('1','201','251469','478',685.00,740.00,0.00,656.79,449901.15,481526.04,31624.89,713787),('1','201','251470','478',685.00,740.00,0.00,718.34,492062.90,530933.60,38870.70,713788),('1','201','251471','478',685.00,740.00,0.00,898.48,615458.80,649211.20,33752.40,713789),('1','201','251472','478',685.00,740.00,0.00,765.94,524668.90,559645.60,34976.70,713790),('1','201','251473','478',685.00,740.00,0.00,611.75,419048.75,451207.36,32158.61,713791),('1','201','251474','478',685.00,740.00,0.00,548.15,375482.75,405147.00,29664.25,713792),('1','201','251475','478',685.00,740.00,0.00,581.71,398471.35,430465.40,31994.05,713793),('1','201','251476','478',685.00,740.00,0.00,965.94,661668.90,693537.44,31868.54,713794),('1','201','251477','478',685.00,740.00,0.00,1020.47,699021.95,737946.44,38924.49,713795),('1','201','251478','478',685.00,740.00,0.00,985.59,675129.15,712968.60,37839.45,713796),('1','201','251479','478',685.00,740.00,0.00,1360.40,931874.00,978866.00,46992.00,713797),('1','201','251480','478',685.00,740.00,0.00,1544.34,1057872.90,1111351.60,53478.70,713798),('1','201','251481','478',685.00,740.00,0.00,825.54,565494.90,602099.60,36604.70,713799),('1','201','251482','478',685.00,740.00,0.00,937.75,642358.75,688457.00,46098.25,713800),('1','201','251483','478',685.00,740.00,0.00,1059.52,725771.20,774540.80,48769.60,713801),('1','201','251484','478',685.00,740.00,0.00,883.62,605279.70,646904.80,41625.10,713802),('1','201','251485','478',685.00,740.00,0.00,543.27,372139.95,397399.80,25259.85,713803),('1','201','251486','478',685.00,740.00,0.00,0.00,0.00,0.00,0.00,713804),('1','201','251487','478',685.00,740.00,0.00,258.79,177271.15,191504.60,14233.45,713805),('1','201','251488','478',685.00,740.00,0.00,830.08,568604.80,610255.20,41650.40,713806),('1','201','251489','478',685.00,740.00,0.00,1168.45,800388.25,848505.00,48116.75,713807),('1','201','251490','478',685.00,740.00,0.00,1026.16,702919.60,753401.24,50481.64,713808),('1','201','251491','478',685.00,740.00,0.00,833.99,571283.15,606460.60,35177.45,713809),('1','201','251492','478',685.00,740.00,0.00,645.03,441845.55,476816.20,34970.65,713810),('1','201','251493','478',685.00,740.00,0.00,509.16,348774.60,375629.56,26854.96,713811),('1','201','251494','478',685.00,740.00,0.00,875.67,599833.95,638051.80,38217.85,713812),('1','201','251495','478',685.00,740.00,0.00,867.96,594552.60,638198.40,43645.80,713813),('1','201','251496','478',685.00,740.00,0.00,993.78,680739.30,720503.20,39763.90,713814),('1','201','251497','478',685.00,740.00,0.00,759.34,520147.90,558171.60,38023.70,713815),('1','201','251498','478',685.00,740.00,0.00,1256.60,860771.00,904760.00,43989.00,713816),('1','201','251499','478',685.00,740.00,0.00,1001.47,686006.95,723729.80,37722.85,713817),('1','201','251500','478',685.00,740.00,0.00,1444.36,989386.60,1029990.24,40603.64,713818),('1','201','251501','478',685.00,740.00,0.00,715.46,490090.10,525942.40,35852.30,713819),('1','201','251502','478',685.00,740.00,0.00,1031.13,706324.05,749726.20,43402.15,713820),('1','201','251503','478',685.00,740.00,0.00,1441.14,987180.90,1039823.60,52642.70,713821),('1','201','251504','478',685.00,740.00,0.00,1993.59,1365609.15,1427102.56,61493.41,713822),('1','201','251505','478',685.00,740.00,0.00,1193.62,817629.70,864314.80,46685.10,713823),('1','201','251506','478',685.00,740.00,0.00,1162.15,796072.75,843557.00,47484.25,713824),('1','201','251507','478',685.00,740.00,0.00,1499.09,1026876.65,1076750.76,49874.11,713825),('1','201','251508','478',685.00,740.00,0.00,960.45,657908.25,705211.00,47302.75,713826),('1','201','251509','478',685.00,740.00,0.00,1118.16,765939.60,812244.76,46305.16,713827),('1','201','251510','478',685.00,740.00,0.00,179.17,122731.45,132585.80,9854.35,713828),('1','201','251511','478',685.00,620.00,0.00,0.00,0.00,0.00,0.00,713829),('1','201','251512','478',677.00,740.00,0.00,1021.18,691338.86,726523.20,35184.34,713830),('1','201','251513','478',677.00,740.00,0.00,1507.14,1020333.78,1085209.60,64875.82,713831),('1','201','251514','478',677.00,740.00,0.00,1174.33,795021.41,846234.20,51212.79,713832),('1','201','251515','478',677.00,740.00,0.00,1413.87,957189.99,1014429.80,57239.81,713833),('1','201','251516','478',677.00,740.00,0.00,1328.65,899496.05,953809.00,54312.95,713834),('1','201','251517','478',677.00,740.00,0.00,1796.80,1216433.60,1282739.00,66305.40,713835),('1','201','251518','478',677.00,740.00,0.00,1658.48,1122790.96,1180321.48,57530.52,713836),('1','201','251519','478',677.00,740.00,0.00,2330.44,1577707.88,1652525.32,74817.44,713837),('1','201','251520','478',677.00,740.00,0.00,1791.39,1212771.03,1275754.60,62983.57,713838),('1','201','251521','478',677.00,740.00,0.00,2735.40,1851865.80,1931484.00,79618.20,713839),('1','201','251522','478',677.00,740.00,0.00,1980.28,1340649.56,1411815.20,71165.64,713840),('1','201','251523','478',677.00,740.00,0.00,2137.43,1447040.11,1515346.20,68306.09,713841),('1','201','251524','478',677.00,740.00,0.00,2867.44,1941256.88,2028186.92,86930.04,713842),('1','201','251525','478',677.00,740.00,0.00,485.28,328534.56,344697.20,16162.64,713843),('1','201','251526','478',677.00,640.00,0.00,0.00,0.00,0.00,0.00,713844),('1','201','251527','478',760.00,760.00,0.00,1928.57,1465713.20,1395603.20,-70110.00,713845),('1','201','251528','478',760.00,760.00,0.00,2856.55,2170978.00,2065828.00,-105150.00,713846),('1','201','251529','478',760.00,760.00,0.00,2263.45,1720222.00,1643970.40,-76251.60,713847),('1','201','251530','478',760.00,760.00,0.00,1759.15,1336954.00,1283921.00,-53033.00,713848),('1','201','251531','478',760.00,760.00,0.00,1880.32,1429043.20,1373603.20,-55440.00,713849),('1','201','251532','478',760.00,760.00,0.00,2084.44,1584174.40,1521849.40,-62325.00,713850),('1','201','251533','478',760.00,760.00,0.00,2871.17,2182089.20,2083529.70,-98559.50,713851),('1','201','251534','478',760.00,760.00,0.00,1392.64,1058406.40,1031406.40,-27000.00,713852),('1','201','251535','478',760.00,760.00,0.00,1879.51,1428427.60,1382298.10,-46129.50,713853),('1','201','251536','478',760.00,760.00,0.00,3122.74,2373282.40,2267239.90,-106042.50,713854),('1','201','251537','478',760.00,760.00,0.00,2074.22,1576407.20,1516405.10,-60002.10,713855),('1','201','251538','478',760.00,760.00,0.00,649.09,493308.40,475128.40,-18180.00,713856),('1','201','251539','478',760.00,685.00,0.00,0.00,0.00,0.00,0.00,713857),('1','201','251540','478',780.00,780.00,0.00,2533.67,1976262.60,1899357.60,-76905.00,713858),('1','201','251541','478',780.00,780.00,0.00,4047.86,3157330.80,3019608.30,-137722.50,713859),('1','201','251542','478',780.00,780.00,0.00,10158.53,7923653.40,7428050.90,-495602.50,713860),('1','201','251543','478',780.00,780.00,0.00,2557.39,1994764.20,1915461.70,-79302.50,713861),('1','201','251544','478',780.00,780.00,0.00,3675.46,2866858.80,2743913.80,-122945.00,713862),('1','201','251545','478',780.00,780.00,0.00,1984.75,1548105.00,1471240.00,-76865.00,713863),('1','201','251546','478',780.00,685.00,0.00,0.00,0.00,0.00,0.00,713864),('1','201','251547','478',697.00,780.00,0.00,439.21,306129.37,338103.80,31974.43,713865),('1','201','251548','478',697.00,780.00,0.00,948.68,661229.96,727470.40,66240.44,713866),('1','201','251549','478',697.00,780.00,0.00,900.82,627871.54,696199.60,68328.06,713867),('1','201','251550','478',697.00,780.00,0.00,1560.68,1087793.96,1181790.80,93996.84,713868),('1','201','251551','478',697.00,780.00,0.00,1704.58,1188092.26,1288223.60,100131.34,713869),('1','201','251552','478',697.00,780.00,0.00,1566.26,1091683.22,1187480.80,95797.58,713870),('1','201','251553','478',697.00,780.00,0.00,1813.14,1263758.58,1364737.60,100979.02,713871),('1','201','251554','478',697.00,780.00,0.00,1256.78,875975.66,958134.40,82158.74,713872),('1','201','251555','478',697.00,780.00,0.00,2054.72,1432139.84,1549761.60,117621.76,713873),('1','201','251556','478',697.00,780.00,0.00,725.00,505325.00,536500.00,31175.00,713874),('1','201','251557','478',697.00,780.00,0.00,761.72,530918.84,594141.60,63222.76,713875),('1','201','251558','478',697.00,780.00,0.00,976.00,680272.00,746980.00,66708.00,713876),('1','201','251559','478',697.00,780.00,0.00,1821.48,1269571.56,1374454.40,104882.84,713877),('1','201','251560','478',697.00,780.00,0.00,1066.58,743406.26,813792.00,70385.74,713878),('1','201','251561','478',697.00,780.00,0.00,1127.71,786013.87,862533.80,76519.93,713879),('1','201','251562','478',697.00,780.00,0.00,1447.81,1009123.57,1101191.80,92068.23,713880),('1','201','251563','478',697.00,780.00,0.00,1438.34,1002522.98,1089225.20,86702.22,713881),('1','201','251564','478',697.00,780.00,0.00,1915.34,1334991.98,1450940.80,115948.82,713882),('1','201','251565','478',697.00,780.00,0.00,1190.27,829618.19,896932.20,67314.01,713883),('1','201','251566','478',697.00,640.00,0.00,0.00,0.00,0.00,0.00,713884),('1','201','251567','478',685.00,780.00,0.00,508.65,348425.25,388747.00,40321.75,713885),('1','201','251568','478',685.00,780.00,0.00,1857.04,1272072.40,1413991.20,141918.80,713886),('1','201','251569','478',685.00,780.00,0.00,1891.71,1295821.35,1443433.80,147612.45,713887),('1','201','251570','478',685.00,780.00,0.00,2792.33,2178017.40,2070605.90,-107411.50,713888),('1','201','251571','478',780.00,780.00,0.00,1458.87,1137918.60,1091368.60,-46550.00,713889),('1','201','251572','478',780.00,780.00,0.00,1451.50,1132170.00,1081455.00,-50715.00,713890),('1','201','251573','478',780.00,780.00,0.00,2881.02,2247195.60,2086055.60,-161140.00,713891),('1','201','251574','478',780.00,780.00,0.00,1475.29,1150726.20,1087397.90,-63328.30,713892),('1','201','251575','478',780.00,780.00,0.00,725.81,566131.80,556541.80,-9590.00,713893),('1','201','251576','478',780.00,780.00,0.00,2740.16,2137324.80,2004394.80,-132930.00,713894),('1','201','251577','478',780.00,780.00,0.00,2059.04,1606051.20,1517921.20,-88130.00,713895),('1','201','251578','478',780.00,780.00,0.00,1183.23,922919.40,887814.40,-35105.00,713896),('1','201','251579','478',780.00,780.00,0.00,722.86,563830.80,562045.80,-1785.00,713897),('1','201','251580','478',780.00,780.00,0.00,1301.88,1015466.40,963141.40,-52325.00,713898),('1','201','251581','478',780.00,780.00,0.00,1001.45,781131.00,738781.00,-42350.00,713899),('1','201','251582','478',780.00,780.00,0.00,356.23,277859.40,260240.40,-17619.00,713900),('1','201','251583','478',780.00,640.00,0.00,0.00,0.00,0.00,0.00,713901),('1','201','251584','478',685.00,780.00,0.00,1545.14,1058420.90,1149909.20,91488.30,713902),('1','201','251585','478',685.00,780.00,0.00,2090.78,1432184.30,1528258.40,96074.10,713903),('1','201','251586','478',685.00,780.00,0.00,1040.74,712906.90,785352.20,72445.30,713904),('1','201','251587','478',685.00,780.00,0.00,757.18,518668.30,581990.40,63322.10,713905),('1','201','251588','478',685.00,780.00,0.00,1219.59,835419.15,906375.20,70956.05,713906),('1','201','251589','478',685.00,780.00,0.00,2019.95,1383665.75,1488357.10,104691.35,713907),('1','201','251590','478',685.00,780.00,0.00,1278.41,875710.85,970677.40,94966.55,713908),('1','201','251591','478',685.00,780.00,0.00,1195.10,818643.50,906873.00,88229.50,713909),('1','201','251592','478',685.00,780.00,0.00,1493.46,1023020.10,1117753.80,94733.70,713910),('1','201','251593','478',685.00,780.00,0.00,834.89,571899.65,647271.10,75371.45,713911),('1','201','251594','478',710.00,710.00,0.00,698.58,495991.80,495616.80,-375.00,713912),('1','201','251595','478',710.00,710.00,0.00,1513.05,1074265.50,1066540.50,-7725.00,713913),('1','201','251596','478',710.00,710.00,0.00,655.62,465490.20,465170.20,-320.00,713914),('1','201','251597','478',710.00,710.00,0.00,833.12,591515.20,590095.20,-1420.00,713915),('1','201','251598','478',710.00,710.00,0.00,791.30,561823.00,561213.00,-610.00,713916),('1','201','251599','478',710.00,710.00,0.00,761.97,540998.70,540168.70,-830.00,713917),('1','201','251600','478',710.00,710.00,0.00,850.43,603805.30,603377.40,-427.90,713918),('1','201','251601','478',710.00,710.00,0.00,1034.95,734814.50,732309.50,-2505.00,713919),('1','201','251602','478',710.00,710.00,0.00,946.59,672078.90,671224.60,-854.30,713920),('1','201','251603','478',710.00,710.00,0.00,751.26,533394.60,532289.60,-1105.00,713921),('1','201','251604','478',710.00,710.00,0.00,1256.97,892448.70,888063.70,-4385.00,713922),('1','201','251605','478',710.00,710.00,0.00,893.89,634661.90,631211.90,-3450.00,713923),('1','201','251606','478',710.00,685.00,0.00,0.00,0.00,0.00,0.00,713924),('1','201','251607','478',660.00,710.00,0.00,1144.48,755356.80,809336.50,53979.70,713925),('1','201','251608','478',660.00,710.00,0.00,1464.12,966319.20,1032505.20,66186.00,713926),('1','201','251609','478',660.00,710.00,0.00,1713.65,1131009.00,1207531.50,76522.50,713927),('1','201','251610','478',660.00,710.00,0.00,2001.94,1321280.40,1408982.40,87702.00,713928),('1','201','251611','478',660.00,710.00,0.00,1481.01,977466.60,1043582.10,66115.50,713929),('1','201','251612','478',660.00,710.00,0.00,1704.67,1125082.20,1202445.70,77363.50,713930),('1','201','251613','478',660.00,710.00,0.00,1754.02,1157653.20,1234769.20,77116.00,713931),('1','201','251614','478',660.00,710.00,0.00,2102.47,1387630.20,1480875.10,93244.90,713932),('1','201','251615','478',660.00,710.00,0.00,1246.50,822690.00,881355.00,58665.00,713933),('1','201','251616','478',660.00,710.00,0.00,927.15,611919.00,657596.50,45677.50,713934),('1','201','251617','478',660.00,710.00,0.00,784.28,517624.80,556358.80,38734.00,713935),('1','201','251618','478',660.00,710.00,0.00,723.88,477760.80,513409.80,35649.00,713936),('1','201','251619','478',660.00,710.00,0.00,927.59,612209.40,656588.90,44379.50,713937),('1','201','251620','478',660.00,710.00,0.00,851.28,561844.80,603848.80,42004.00,713938),('1','201','251621','478',660.00,710.00,0.00,775.71,511968.60,550474.10,38505.50,713939),('1','201','251622','478',660.00,710.00,0.00,1274.31,841044.60,900155.10,59110.50,713940),('1','201','251623','478',660.00,710.00,0.00,747.66,493455.60,530463.60,37008.00,713941),('1','201','251624','478',660.00,710.00,0.00,659.00,434940.00,466840.00,31900.00,713942),('1','201','251625','478',660.00,710.00,0.00,564.13,372325.80,400392.30,28066.50,713943),('1','201','251626','478',660.00,710.00,0.00,929.94,613760.40,657237.40,43477.00,713944),('1','201','251627','478',660.00,710.00,0.00,1026.56,677529.60,725112.60,47583.00,713945),('1','201','251628','478',660.00,620.00,0.00,0.00,0.00,0.00,0.00,713946),('1','201','251629','478',651.00,710.00,0.00,1361.64,886427.64,959929.40,73501.76,713947),('1','201','251630','478',730.00,730.00,0.00,1187.04,866539.20,853234.20,-13305.00,713948),('1','201','251631','478',730.00,730.00,0.00,938.52,685119.60,678369.60,-6750.00,713949),('1','201','251632','478',730.00,730.00,0.00,894.61,653065.30,645640.30,-7425.00,713950),('1','201','251633','478',730.00,730.00,0.00,902.51,658832.30,657887.30,-945.00,713951),('1','201','251634','478',730.00,730.00,0.00,705.77,515212.10,513277.10,-1935.00,713952),('1','201','251635','478',730.00,730.00,0.00,901.78,658299.40,646719.40,-11580.00,713953),('1','201','251636','478',730.00,730.00,0.00,1294.05,944656.50,931711.50,-12945.00,713954),('1','201','251637','478',730.00,730.00,0.00,765.21,558603.30,554688.30,-3915.00,713955),('1','201','251638','478',730.00,730.00,0.00,984.27,718517.10,716042.10,-2475.00,713956),('1','201','251639','478',730.00,730.00,0.00,768.47,560983.10,558763.10,-2220.00,713957),('1','201','251640','478',730.00,730.00,0.00,773.05,564326.50,562541.50,-1785.00,713958),('1','201','251641','478',730.00,730.00,0.00,703.69,513693.70,513093.70,-600.00,713959),('1','201','251642','478',730.00,730.00,0.00,886.24,646955.20,644675.20,-2280.00,713960),('1','201','251643','478',730.00,730.00,0.00,794.06,579663.80,579273.80,-390.00,713961),('1','201','251644','478',730.00,730.00,0.00,1012.14,738862.20,730522.20,-8340.00,713962),('1','201','251645','478',730.00,730.00,0.00,590.62,431152.60,430807.60,-345.00,713963),('1','201','251646','478',730.00,730.00,0.00,854.77,623982.10,623457.10,-525.00,713964),('1','201','251647','478',730.00,730.00,0.00,570.54,416494.20,415744.20,-750.00,713965),('1','201','251648','478',730.00,730.00,0.00,792.38,578437.40,571957.40,-6480.00,713966),('1','201','251649','478',730.00,730.00,0.00,666.50,486545.00,485615.00,-930.00,713967),('1','201','251650','478',730.00,730.00,0.00,806.61,588825.30,586965.30,-1860.00,713968),('1','201','251651','478',730.00,730.00,0.00,982.25,717042.50,705177.50,-11865.00,713969),('1','201','251652','478',730.00,730.00,0.00,595.46,434685.80,434100.80,-585.00,713970),('1','201','251653','478',730.00,730.00,0.00,512.85,374380.50,374380.50,0.00,713971),('1','201','251654','478',730.00,730.00,0.00,753.75,550237.50,548737.50,-1500.00,713972),('1','201','251655','478',730.00,730.00,0.00,1138.48,831090.40,829410.40,-1680.00,713973),('1','201','251656','478',730.00,730.00,0.00,1005.69,734153.70,733208.70,-945.00,713974),('1','201','251657','478',730.00,730.00,0.00,909.55,663971.50,663506.50,-465.00,713975),('1','201','251658','478',730.00,730.00,0.00,856.48,624520.98,622365.40,-2155.58,713976),('1','201','251659','478',640.00,730.00,0.00,855.05,547232.00,623826.50,76594.50,713977),('1','201','251660','478',640.00,730.00,0.00,735.33,470611.20,536790.90,66179.70,713978),('1','201','251661','478',640.00,730.00,0.00,795.07,508844.80,576081.10,67236.30,713979),('1','201','251662','478',640.00,730.00,0.00,806.59,516217.60,588480.70,72263.10,713980),('1','201','251663','478',640.00,730.00,0.00,794.39,508409.60,578869.70,70460.10,713981),('1','201','251664','478',640.00,730.00,0.00,833.47,533420.80,604893.10,71472.30,713982),('1','201','251665','478',640.00,730.00,0.00,977.05,625312.00,703976.50,78664.50,713983),('1','201','251666','478',640.00,730.00,0.00,729.39,466809.60,530864.70,64055.10,713984),('1','201','251667','478',640.00,730.00,0.00,616.61,394630.40,449114.00,54483.60,713985),('1','201','251668','478',640.00,730.00,0.00,648.02,414732.80,470804.60,56071.80,713986),('1','201','251669','478',640.00,730.00,0.00,878.26,562086.40,640709.80,78623.40,713987),('1','201','251670','478',640.00,730.00,0.00,581.61,372230.40,424575.30,52344.90,713988),('1','201','251671','478',640.00,730.00,0.00,752.00,481280.00,544490.00,63210.00,713989),('1','201','251672','478',640.00,730.00,0.00,845.37,541036.80,614195.10,73158.30,713990),('1','201','251673','478',640.00,730.00,0.00,643.46,411814.40,469275.80,57461.40,713991),('1','201','251674','478',640.00,730.00,0.00,637.49,407993.60,465202.70,57209.10,713992),('1','201','251675','478',640.00,730.00,0.00,940.93,602195.20,686878.90,84683.70,713993),('1','201','251676','478',640.00,730.00,0.00,1137.64,728089.60,828655.90,100566.30,713994),('1','201','251677','478',640.00,730.00,0.00,2191.83,1402771.20,1546435.90,143664.70,713995);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=438 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',437,'201','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=1038 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','201','437',1037,1,'478','LPG TANK ',28000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2021-12-25 18:11:48','2021-12-25 18:11:48','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','201',1037,8600.44,'2023-03-20 18:48:39');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2665478 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2374365,'1','201',NULL,478,'Purchased from AA RANO NIGERIA LIMITED',0.00,13444620.00,24990.00,0.00,0.00,'2021-12-25 19:24:57','',''),(2374461,'1','201',NULL,478,'Returned purchase #88164 to AA RANO NIGERIA LIMITED',13444620.00,0.00,0.00,24990.00,0.00,'2021-12-25 20:13:50','',''),(2374544,'1','201',NULL,478,'Purchased from AA RANO NIGERIA LIMITED',0.00,13444620.00,24990.00,0.00,0.00,'2021-12-25 20:45:31','',''),(2374545,'1','201',NULL,478,'Reception corrector for bridging 128793',0.00,0.00,0.00,24990.00,0.00,'2021-12-25 20:52:37','',''),(2374546,'1','201','1037',478,'Received from bridging 128793',0.00,0.00,24990.00,0.00,0.00,'2021-12-25 20:52:37','',''),(2374556,'1','201','1037',478,'Retail Sale Id 1408418',600.00,0.00,0.00,1.00,62.00,'2021-12-25 21:03:59','',''),(2374591,'1','201','1037',478,'Retail Sale Id 1408419',163188.00,0.00,0.00,271.98,16862.76,'2021-12-25 21:19:00','',''),(2374594,'1','201','1037',478,'Retail Sale Id 1408420',51300.00,0.00,0.00,90.00,2880.00,'2021-12-25 21:32:11','',''),(2374608,'1','201','1037',478,'Retail Sale Id 1408421',4260.00,0.00,0.00,7.10,440.20,'2021-12-25 21:36:19','',''),(2374661,'1','201','1037',478,'Retail Sale Id 1408424',140892.00,0.00,0.00,234.82,14558.84,'2021-12-25 21:52:48','',''),(2374664,'1','201','1037',478,'Retail Sale Id 1408425',84750.00,0.00,0.00,150.00,4050.00,'2021-12-25 21:55:20','',''),(2375231,'1','201','1037',478,'Retail Sale Id 1408725',3000.00,0.00,0.00,5.00,310.00,'2021-12-26 07:33:43','',''),(2375257,'1','201','1037',478,'Retail Sale Id 1408742',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 07:36:04','',''),(2375273,'1','201','1037',478,'Retail Sale Id 1408754',4200.00,0.00,0.00,7.00,434.00,'2021-12-26 07:38:18','',''),(2375423,'1','201','1037',478,'Retail Sale Id 1408882',7500.00,0.00,0.00,12.50,775.00,'2021-12-26 07:54:26','',''),(2375553,'1','201','1037',478,'Retail Sale Id 1408956',28250.00,0.00,0.00,50.00,1350.00,'2021-12-26 08:01:39','',''),(2375786,'1','201','1037',478,'Retail Sale Id 1409125',4200.00,0.00,0.00,7.00,434.00,'2021-12-26 08:25:13','',''),(2375952,'1','201','1037',478,'Retail Sale Id 1409235',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 08:44:07','',''),(2375979,'1','201','1037',478,'Retail Sale Id 1409300',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 08:47:05','',''),(2375994,'1','201','1037',478,'Retail Sale Id 1409314',1500.00,0.00,0.00,2.50,155.00,'2021-12-26 08:48:56','',''),(2376125,'1','201','1037',478,'Retail Sale Id 1409423',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 09:03:02','',''),(2376260,'1','201','1037',478,'Retail Sale Id 1409518',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 09:15:30','',''),(2376370,'1','201','1037',478,'Retail Sale Id 1409572',28500.00,0.00,0.00,50.00,1600.00,'2021-12-26 09:23:25','',''),(2376380,'1','201','1037',478,'Retail Sale Id 1409585',1200.00,0.00,0.00,2.00,124.00,'2021-12-26 09:25:11','',''),(2376411,'1','201','1037',478,'Retail Sale Id 1409618',1200.00,0.00,0.00,2.00,124.00,'2021-12-26 09:30:18','',''),(2376523,'1','201','1037',478,'Retail Sale Id 1409708',1200.00,0.00,0.00,2.00,124.00,'2021-12-26 09:43:10','',''),(2376539,'1','201','1037',478,'Retail Sale Id 1409723',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 09:45:20','',''),(2376633,'1','201','1037',478,'Retail Sale Id 1409810',7200.00,0.00,0.00,12.00,744.00,'2021-12-26 09:56:55','',''),(2376656,'1','201','1037',478,'Retail Sale Id 1409835',7500.00,0.00,0.00,12.50,775.00,'2021-12-26 09:59:42','',''),(2376666,'1','201','1037',478,'Return of Retail Sale Id 1409810',0.00,7200.00,12.00,0.00,-744.00,'2021-12-26 10:01:04','',''),(2376672,'1','201','1037',478,'Retail Sale Id 1409852',3000.00,0.00,0.00,5.00,310.00,'2021-12-26 10:01:25','',''),(2376682,'1','201','1037',478,'Retail Sale Id 1409860',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 10:02:40','',''),(2376732,'1','201','1037',478,'Retail Sale Id 1409910',1602.00,0.00,0.00,2.67,165.54,'2021-12-26 10:08:37','',''),(2376783,'1','201','1037',478,'Retail Sale Id 1409963',7500.00,0.00,0.00,12.50,775.00,'2021-12-26 10:17:47','',''),(2376815,'1','201','1037',478,'Retail Sale Id 1409992',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 10:23:45','',''),(2376836,'1','201','1037',478,'Retail Sale Id 1410008',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 10:25:10','',''),(2376844,'1','201','1037',478,'Retail Sale Id 1410020',1200.00,0.00,0.00,2.00,124.00,'2021-12-26 10:26:24','',''),(2376868,'1','201','1037',478,'Retail Sale Id 1410046',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 10:28:46','',''),(2376886,'1','201','1037',478,'Retail Sale Id 1410065',3000.00,0.00,0.00,5.00,310.00,'2021-12-26 10:30:26','',''),(2377007,'1','201','1037',478,'Retail Sale Id 1410157',30000.00,0.00,0.00,50.00,3100.00,'2021-12-26 10:42:18','',''),(2377090,'1','201','1037',478,'Retail Sale Id 1410237',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 10:53:17','',''),(2377133,'1','201','1037',478,'Retail Sale Id 1410282',3000.00,0.00,0.00,5.00,310.00,'2021-12-26 10:58:39','',''),(2377152,'1','201','1037',478,'Retail Sale Id 1410290',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 10:59:51','',''),(2377237,'1','201','1037',478,'Retail Sale Id 1410362',2400.00,0.00,0.00,4.00,248.00,'2021-12-26 11:09:53','',''),(2377303,'1','201','1037',478,'Retail Sale Id 1410428',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 11:17:47','',''),(2377325,'1','201','1037',478,'Retail Sale Id 1410448',4002.00,0.00,0.00,6.67,413.54,'2021-12-26 11:19:50','',''),(2377339,'1','201','1037',478,'Retail Sale Id 1410463',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 11:21:15','',''),(2377359,'1','201','1037',478,'Retail Sale Id 1410482',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 11:24:23','',''),(2377403,'1','201','1037',478,'Retail Sale Id 1410525',1500.00,0.00,0.00,2.50,155.00,'2021-12-26 11:30:25','',''),(2377440,'1','201','1037',478,'Retail Sale Id 1410549',7500.00,0.00,0.00,12.50,775.00,'2021-12-26 11:33:58','',''),(2377491,'1','201','1037',478,'Retail Sale Id 1410599',600.00,0.00,0.00,1.00,62.00,'2021-12-26 11:40:04','',''),(2377628,'1','201','1037',478,'Retail Sale Id 1410707',7500.00,0.00,0.00,12.50,775.00,'2021-12-26 11:58:54','',''),(2377747,'1','201','1037',478,'Retail Sale Id 1410794',3000.00,0.00,0.00,5.00,310.00,'2021-12-26 12:10:56','',''),(2377770,'1','201','1037',478,'Retail Sale Id 1410813',1200.00,0.00,0.00,2.00,124.00,'2021-12-26 12:13:44','',''),(2377793,'1','201','1037',478,'Retail Sale Id 1410837',4998.00,0.00,0.00,8.33,516.46,'2021-12-26 12:17:17','',''),(2377806,'1','201','1037',478,'Retail Sale Id 1410850',1998.00,0.00,0.00,3.33,206.46,'2021-12-26 12:19:12','',''),(2377831,'1','201','1037',478,'Retail Sale Id 1410875',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 12:22:36','',''),(2377850,'1','201','1037',478,'Retail Sale Id 1410897',1200.00,0.00,0.00,2.00,124.00,'2021-12-26 12:25:35','',''),(2377866,'1','201','1037',478,'Retail Sale Id 1410913',1200.00,0.00,0.00,2.00,124.00,'2021-12-26 12:28:47','',''),(2377879,'1','201','1037',478,'Retail Sale Id 1410920',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 12:29:57','',''),(2377976,'1','201','1037',478,'Retail Sale Id 1410976',7500.00,0.00,0.00,12.50,775.00,'2021-12-26 12:37:46','',''),(2378169,'1','201','1037',478,'Retail Sale Id 1411172',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 13:06:05','',''),(2378313,'1','201','1037',478,'Retail Sale Id 1411298',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 13:28:49','',''),(2378358,'1','201','1037',478,'Retail Sale Id 1411308',28250.00,0.00,0.00,50.00,1350.00,'2021-12-26 13:31:17','',''),(2378393,'1','201','1037',478,'Retail Sale Id 1411342',600.00,0.00,0.00,1.00,62.00,'2021-12-26 13:37:46','',''),(2378444,'1','201','1037',478,'Retail Sale Id 1411389',2400.00,0.00,0.00,4.00,248.00,'2021-12-26 13:47:18','',''),(2378491,'1','201','1037',478,'Retail Sale Id 1411423',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 13:53:43','',''),(2378509,'1','201','1037',478,'Retail Sale Id 1411439',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 13:57:22','',''),(2378639,'1','201','1037',478,'Retail Sale Id 1411498',2400.00,0.00,0.00,4.00,248.00,'2021-12-26 14:05:28','',''),(2378707,'1','201','1037',478,'Retail Sale Id 1411544',9300.00,0.00,0.00,15.50,961.00,'2021-12-26 14:17:32','',''),(2378778,'1','201','1037',478,'Retail Sale Id 1411603',3000.00,0.00,0.00,5.00,310.00,'2021-12-26 14:25:52','',''),(2379166,'1','201','1037',478,'Retail Sale Id 1411817',4200.00,0.00,0.00,7.00,434.00,'2021-12-26 15:02:02','',''),(2379299,'1','201','1037',478,'Retail Sale Id 1411945',3000.00,0.00,0.00,5.00,310.00,'2021-12-26 15:22:55','',''),(2379342,'1','201','1037',478,'Retail Sale Id 1411983',28250.00,0.00,0.00,50.00,1350.00,'2021-12-26 15:30:33','',''),(2379434,'1','201','1037',478,'Retail Sale Id 1412011',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 15:36:14','',''),(2379546,'1','201','1037',478,'Retail Sale Id 1412098',7200.00,0.00,0.00,12.00,744.00,'2021-12-26 15:51:50','',''),(2379577,'1','201','1037',478,'Retail Sale Id 1412129',5400.00,0.00,0.00,9.00,558.00,'2021-12-26 15:55:58','',''),(2379595,'1','201','1037',478,'Retail Sale Id 1412150',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 15:59:59','',''),(2379699,'1','201','1037',478,'Retail Sale Id 1412260',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 16:14:52','',''),(2379774,'1','201','1037',478,'Retail Sale Id 1412332',1800.00,0.00,0.00,3.00,186.00,'2021-12-26 16:28:53','',''),(2379847,'1','201','1037',478,'Retail Sale Id 1412407',3600.00,0.00,0.00,6.00,372.00,'2021-12-26 16:50:13','',''),(2379852,'1','201','1037',478,'Retail Sale Id 1412412',1200.00,0.00,0.00,2.00,124.00,'2021-12-26 16:51:28','',''),(2380032,'1','201','1037',478,'Retail Sale Id 1412552',798.00,0.00,0.00,1.33,82.46,'2021-12-26 18:16:31','',''),(2380647,'1','201','1037',478,'Retail Sale Id 1412725',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 06:53:46','',''),(2380714,'1','201','1037',478,'Retail Sale Id 1412775',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 07:08:18','',''),(2380733,'1','201','1037',478,'Retail Sale Id 1412792',7500.00,0.00,0.00,12.50,775.00,'2021-12-27 07:12:11','',''),(2381357,'1','201','1037',478,'Retail Sale Id 1413211',2400.00,0.00,0.00,4.00,248.00,'2021-12-27 08:08:16','',''),(2381569,'1','201','1037',478,'Retail Sale Id 1413401',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 08:28:51','',''),(2381705,'1','201','1037',478,'Retail Sale Id 1413523',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 08:40:51','',''),(2381817,'1','201','1037',478,'Retail Sale Id 1413621',10830.00,0.00,0.00,19.00,608.00,'2021-12-27 08:48:45','',''),(2381847,'1','201','1037',478,'Retail Sale Id 1413651',1500.00,0.00,0.00,2.50,155.00,'2021-12-27 08:51:51','',''),(2381913,'1','201','1037',478,'Retail Sale Id 1413718',3300.00,0.00,0.00,5.50,341.00,'2021-12-27 08:59:20','',''),(2381967,'1','201','1037',478,'Retail Sale Id 1413770',6000.00,0.00,0.00,10.00,620.00,'2021-12-27 09:03:30','',''),(2382061,'1','201','1037',478,'Retail Sale Id 1413871',4002.00,0.00,0.00,6.67,413.54,'2021-12-27 09:12:58','',''),(2382145,'1','201','1037',478,'Retail Sale Id 1413951',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 09:21:46','',''),(2382199,'1','201','1037',478,'Retail Sale Id 1413990',4200.00,0.00,0.00,7.00,434.00,'2021-12-27 09:26:03','',''),(2382358,'1','201','1037',478,'Retail Sale Id 1414150',7500.00,0.00,0.00,12.50,775.00,'2021-12-27 09:42:44','',''),(2382479,'1','201','1037',478,'Retail Sale Id 1414260',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 09:55:08','',''),(2382664,'1','201','1037',478,'Retail Sale Id 1414357',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 10:08:18','',''),(2382701,'1','201','1037',478,'Retail Sale Id 1414392',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 10:11:27','',''),(2382735,'1','201','1037',478,'Retail Sale Id 1414435',3000.00,0.00,0.00,5.00,310.00,'2021-12-27 10:15:27','',''),(2382799,'1','201','1037',478,'Retail Sale Id 1414503',7500.00,0.00,0.00,12.50,775.00,'2021-12-27 10:22:41','',''),(2382859,'1','201','1037',478,'Retail Sale Id 1414564',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 10:27:30','',''),(2382896,'1','201','1037',478,'Retail Sale Id 1414594',2400.00,0.00,0.00,4.00,248.00,'2021-12-27 10:30:06','',''),(2382945,'1','201','1037',478,'Retail Sale Id 1414649',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 10:34:31','',''),(2383089,'1','201','1037',478,'Retail Sale Id 1414796',3000.00,0.00,0.00,5.00,310.00,'2021-12-27 10:48:52','',''),(2383203,'1','201','1037',478,'Retail Sale Id 1414905',2400.00,0.00,0.00,4.00,248.00,'2021-12-27 11:00:53','',''),(2383329,'1','201','1037',478,'Retail Sale Id 1415014',7800.00,0.00,0.00,13.00,806.00,'2021-12-27 11:12:40','',''),(2383377,'1','201','1037',478,'Retail Sale Id 1415070',2502.00,0.00,0.00,4.17,258.54,'2021-12-27 11:18:23','',''),(2383395,'1','201','1037',478,'Retail Sale Id 1415085',4800.00,0.00,0.00,8.00,496.00,'2021-12-27 11:20:05','',''),(2383405,'1','201','1037',478,'Retail Sale Id 1415093',2400.00,0.00,0.00,4.00,248.00,'2021-12-27 11:21:24','',''),(2383414,'1','201','1037',478,'Retail Sale Id 1415101',4200.00,0.00,0.00,7.00,434.00,'2021-12-27 11:22:30','',''),(2383433,'1','201','1037',478,'Retail Sale Id 1415116',1998.00,0.00,0.00,3.33,206.46,'2021-12-27 11:24:00','',''),(2383512,'1','201','1037',478,'Retail Sale Id 1415191',2400.00,0.00,0.00,4.00,248.00,'2021-12-27 11:32:41','',''),(2383702,'1','201','1037',478,'Retail Sale Id 1415365',7500.00,0.00,0.00,12.50,775.00,'2021-12-27 11:54:42','',''),(2383725,'1','201','1037',478,'Retail Sale Id 1415380',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 11:57:04','',''),(2383763,'1','201','1037',478,'Retail Sale Id 1415420',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 12:02:37','',''),(2383768,'1','201','1037',478,'Retail Sale Id 1415425',600.00,0.00,0.00,1.00,62.00,'2021-12-27 12:03:42','',''),(2383805,'1','201','1037',478,'Retail Sale Id 1415464',6000.00,0.00,0.00,10.00,620.00,'2021-12-27 12:10:26','',''),(2383879,'1','201','1037',478,'Retail Sale Id 1415504',7500.00,0.00,0.00,12.50,775.00,'2021-12-27 12:19:15','',''),(2383938,'1','201','1037',478,'Retail Sale Id 1415557',28250.00,0.00,0.00,50.00,1350.00,'2021-12-27 12:29:01','',''),(2383944,'1','201','1037',478,'Retail Sale Id 1415564',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 12:30:10','',''),(2383961,'1','201','1037',478,'Retail Sale Id 1415582',1200.00,0.00,0.00,2.00,124.00,'2021-12-27 12:32:51','',''),(2383967,'1','201','1037',478,'Retail Sale Id 1415588',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 12:33:45','',''),(2383974,'1','201','1037',478,'Retail Sale Id 1415594',7500.00,0.00,0.00,12.50,775.00,'2021-12-27 12:35:01','',''),(2384024,'1','201','1037',478,'Retail Sale Id 1415647',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 12:44:38','',''),(2384115,'1','201','1037',478,'Retail Sale Id 1415706',2400.00,0.00,0.00,4.00,248.00,'2021-12-27 12:52:58','',''),(2384121,'1','201','1037',478,'Retail Sale Id 1415713',1500.00,0.00,0.00,2.50,155.00,'2021-12-27 12:54:09','',''),(2384222,'1','201','1037',478,'Retail Sale Id 1415778',2400.00,0.00,0.00,4.00,248.00,'2021-12-27 13:05:30','',''),(2384252,'1','201','1037',478,'Retail Sale Id 1415807',3000.00,0.00,0.00,5.00,310.00,'2021-12-27 13:10:47','',''),(2384307,'1','201','1037',478,'Retail Sale Id 1415859',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 13:18:22','',''),(2384547,'1','201','1037',478,'Retail Sale Id 1416039',3000.00,0.00,0.00,5.00,310.00,'2021-12-27 13:46:27','',''),(2384597,'1','201','1037',478,'Retail Sale Id 1416090',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 13:55:18','',''),(2384633,'1','201','1037',478,'Retail Sale Id 1416120',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 14:02:35','',''),(2384678,'1','201','1037',478,'Retail Sale Id 1416135',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 14:05:36','',''),(2384731,'1','201','1037',478,'Retail Sale Id 1416158',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 14:10:49','',''),(2384775,'1','201','1037',478,'Retail Sale Id 1416176',1200.00,0.00,0.00,2.00,124.00,'2021-12-27 14:14:55','',''),(2384825,'1','201','1037',478,'Retail Sale Id 1416204',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 14:21:16','',''),(2384900,'1','201','1037',478,'Retail Sale Id 1416251',600.00,0.00,0.00,1.00,62.00,'2021-12-27 14:31:16','',''),(2384990,'1','201','1037',478,'Retail Sale Id 1416314',197750.00,0.00,0.00,350.00,9450.00,'2021-12-27 14:44:50','',''),(2385111,'1','201','1037',478,'Retail Sale Id 1416445',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 15:06:35','',''),(2385183,'1','201','1037',478,'Retail Sale Id 1416520',1500.00,0.00,0.00,2.50,155.00,'2021-12-27 15:22:19','',''),(2385271,'1','201','1037',478,'Retail Sale Id 1416577',2400.00,0.00,0.00,4.00,248.00,'2021-12-27 15:34:33','',''),(2385477,'1','201','1037',478,'Retail Sale Id 1416737',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 15:56:31','',''),(2385496,'1','201','1037',478,'Retail Sale Id 1416756',1500.00,0.00,0.00,2.50,155.00,'2021-12-27 15:58:26','',''),(2385505,'1','201','1037',478,'Retail Sale Id 1416765',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 15:59:47','',''),(2385563,'1','201','1037',478,'Retail Sale Id 1416822',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 16:07:38','',''),(2385601,'1','201','1037',478,'Retail Sale Id 1416858',7500.00,0.00,0.00,12.50,775.00,'2021-12-27 16:14:28','',''),(2385613,'1','201','1037',478,'Retail Sale Id 1416866',7500.00,0.00,0.00,12.50,775.00,'2021-12-27 16:16:32','',''),(2385626,'1','201','1037',478,'Retail Sale Id 1416879',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 16:18:15','',''),(2385721,'1','201','1037',478,'Retail Sale Id 1416953',1800.00,0.00,0.00,3.00,186.00,'2021-12-27 16:32:41','',''),(2385766,'1','201','1037',478,'Retail Sale Id 1416996',1200.00,0.00,0.00,2.00,124.00,'2021-12-27 16:43:58','',''),(2385845,'1','201','1037',478,'Retail Sale Id 1417062',1998.00,0.00,0.00,3.33,206.46,'2021-12-27 16:55:49','',''),(2385857,'1','201','1037',478,'Retail Sale Id 1417072',3000.00,0.00,0.00,5.00,310.00,'2021-12-27 16:57:49','',''),(2385865,'1','201','1037',478,'Retail Sale Id 1417080',7500.00,0.00,0.00,12.50,775.00,'2021-12-27 17:00:00','',''),(2385881,'1','201','1037',478,'Retail Sale Id 1417091',7500.00,0.00,0.00,12.50,775.00,'2021-12-27 17:03:54','',''),(2385904,'1','201','1037',478,'Retail Sale Id 1417120',3600.00,0.00,0.00,6.00,372.00,'2021-12-27 17:08:36','',''),(2386071,'1','201','1037',478,'Retail Sale Id 1417224',1500.00,0.00,0.00,2.50,155.00,'2021-12-27 17:46:35','',''),(2386540,'1','201','1037',478,'Retail Sale Id 1417316',600.00,0.00,0.00,1.00,62.00,'2021-12-28 06:06:30','',''),(2386548,'1','201','1037',478,'Retail Sale Id 1417320',600.00,0.00,0.00,1.00,62.00,'2021-12-28 06:07:58','',''),(2386684,'1','201','1037',478,'Return of Retail Sale Id 1417320',0.00,600.00,1.00,0.00,-62.00,'2021-12-28 06:41:28','',''),(2386688,'1','201','1037',478,'Return of Retail Sale Id 1417316',0.00,600.00,1.00,0.00,-62.00,'2021-12-28 06:42:08','',''),(2387052,'1','201','1037',478,'Retail Sale Id 1417694',1200.00,0.00,0.00,2.00,124.00,'2021-12-28 07:38:23','',''),(2387053,'1','201','1037',478,'Retail Sale Id 1417694',3000.00,0.00,0.00,5.00,310.00,'2021-12-28 07:38:23','',''),(2387066,'1','201','1037',478,'Retail Sale Id 1417708',3000.00,0.00,0.00,5.00,310.00,'2021-12-28 07:39:56','',''),(2387085,'1','201','1037',478,'Retail Sale Id 1417725',1998.00,0.00,0.00,3.33,206.46,'2021-12-28 07:42:22','',''),(2387131,'1','201','1037',478,'Retail Sale Id 1417772',7500.00,0.00,0.00,12.50,775.00,'2021-12-28 07:48:17','',''),(2387336,'1','201','1037',478,'Retail Sale Id 1417946',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 08:05:31','',''),(2387522,'1','201','1037',478,'Retail Sale Id 1418065',3000.00,0.00,0.00,5.00,310.00,'2021-12-28 08:17:35','',''),(2387544,'1','201','1037',478,'Retail Sale Id 1418078',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 08:18:43','',''),(2388130,'1','201','1037',478,'Retail Sale Id 1418452',7500.00,0.00,0.00,12.50,775.00,'2021-12-28 09:16:58','',''),(2388141,'1','201','1037',478,'Retail Sale Id 1418573',6000.00,0.00,0.00,10.00,620.00,'2021-12-28 09:18:31','',''),(2388159,'1','201','1037',478,'Retail Sale Id 1418593',28250.00,0.00,0.00,50.00,1350.00,'2021-12-28 09:20:23','',''),(2388231,'1','201','1037',478,'Retail Sale Id 1418664',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 09:29:15','',''),(2388474,'1','201','1037',478,'Retail Sale Id 1418898',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 09:56:03','',''),(2388653,'1','201','1037',478,'Retail Sale Id 1419067',3000.00,0.00,0.00,5.00,310.00,'2021-12-28 10:16:06','',''),(2388670,'1','201','1037',478,'Retail Sale Id 1419088',4998.00,0.00,0.00,8.33,516.46,'2021-12-28 10:18:13','',''),(2388718,'1','201','1037',478,'Retail Sale Id 1419135',2400.00,0.00,0.00,4.00,248.00,'2021-12-28 10:22:53','',''),(2388749,'1','201','1037',478,'Retail Sale Id 1419161',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 10:26:02','',''),(2388771,'1','201','1037',478,'Retail Sale Id 1419178',28500.00,0.00,0.00,50.00,1600.00,'2021-12-28 10:27:54','',''),(2388858,'1','201','1037',478,'Retail Sale Id 1419239',3000.00,0.00,0.00,5.00,310.00,'2021-12-28 10:35:09','',''),(2389074,'1','201','1037',478,'Retail Sale Id 1419449',10260.00,0.00,0.00,18.00,576.00,'2021-12-28 10:55:57','',''),(2389109,'1','201','1037',478,'Retail Sale Id 1419470',1800.00,0.00,0.00,3.00,186.00,'2021-12-28 10:59:54','',''),(2389142,'1','201','1037',478,'Retail Sale Id 1419510',1500.00,0.00,0.00,2.50,155.00,'2021-12-28 11:03:46','',''),(2389143,'1','201','1037',478,'Retail Sale Id 1419510',1800.00,0.00,0.00,3.00,186.00,'2021-12-28 11:03:46','',''),(2389144,'1','201','1037',478,'Retail Sale Id 1419510',1800.00,0.00,0.00,3.00,186.00,'2021-12-28 11:03:46','',''),(2389145,'1','201','1037',478,'Retail Sale Id 1419510',2400.00,0.00,0.00,4.00,248.00,'2021-12-28 11:03:46','',''),(2389146,'1','201','1037',478,'Retail Sale Id 1419510',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 11:03:46','',''),(2389204,'1','201','1037',478,'Retail Sale Id 1419559',1800.00,0.00,0.00,3.00,186.00,'2021-12-28 11:08:59','',''),(2389303,'1','201','1037',478,'Retail Sale Id 1419650',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 11:20:50','',''),(2389396,'1','201','1037',478,'Retail Sale Id 1419736',1200.00,0.00,0.00,2.00,124.00,'2021-12-28 11:32:25','',''),(2389480,'1','201','1037',478,'Retail Sale Id 1419810',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 11:40:25','',''),(2389569,'1','201','1037',478,'Retail Sale Id 1419898',1500.00,0.00,0.00,2.50,155.00,'2021-12-28 11:50:30','',''),(2389570,'1','201','1037',478,'Retail Sale Id 1419898',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 11:50:30','',''),(2389571,'1','201','1037',478,'Retail Sale Id 1419898',7800.00,0.00,0.00,13.00,806.00,'2021-12-28 11:50:30','',''),(2389658,'1','201','1037',478,'Retail Sale Id 1419955',3000.00,0.00,0.00,5.00,310.00,'2021-12-28 11:58:44','',''),(2389923,'1','201','1037',478,'Retail Sale Id 1420163',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 12:21:35','',''),(2390089,'1','201','1037',478,'Retail Sale Id 1420276',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 12:35:15','',''),(2390164,'1','201','1037',478,'Retail Sale Id 1420335',4200.00,0.00,0.00,7.00,434.00,'2021-12-28 12:41:03','',''),(2390180,'1','201','1037',478,'Retail Sale Id 1420348',6000.00,0.00,0.00,10.00,620.00,'2021-12-28 12:43:18','',''),(2390238,'1','201','1037',478,'Retail Sale Id 1420400',7062.50,0.00,0.00,12.50,337.50,'2021-12-28 12:48:54','',''),(2390249,'1','201','1037',478,'Retail Sale Id 1420411',9000.00,0.00,0.00,15.00,930.00,'2021-12-28 12:50:38','',''),(2390376,'1','201','1037',478,'Retail Sale Id 1420515',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 13:02:23','',''),(2390403,'1','201','1037',478,'Retail Sale Id 1420528',1500.00,0.00,0.00,2.50,155.00,'2021-12-28 13:03:43','',''),(2390420,'1','201','1037',478,'Retail Sale Id 1420543',1800.00,0.00,0.00,3.00,186.00,'2021-12-28 13:05:38','',''),(2390434,'1','201','1037',478,'Retail Sale Id 1420550',1200.00,0.00,0.00,2.00,124.00,'2021-12-28 13:06:57','',''),(2390490,'1','201','1037',478,'Retail Sale Id 1420580',600.00,0.00,0.00,1.00,62.00,'2021-12-28 13:11:45','',''),(2390675,'1','201','1037',478,'Retail Sale Id 1420716',7500.00,0.00,0.00,12.50,775.00,'2021-12-28 13:30:30','',''),(2390697,'1','201','1037',478,'Retail Sale Id 1420721',3000.00,0.00,0.00,5.00,310.00,'2021-12-28 13:31:43','',''),(2390776,'1','201','1037',478,'Retail Sale Id 1420764',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 13:38:20','',''),(2390859,'1','201','1037',478,'Retail Sale Id 1420834',1800.00,0.00,0.00,3.00,186.00,'2021-12-28 13:48:52','',''),(2391036,'1','201','1037',478,'Retail Sale Id 1420979',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 14:06:46','',''),(2391037,'1','201','1037',478,'Retail Sale Id 1420979',7500.00,0.00,0.00,12.50,775.00,'2021-12-28 14:06:46','',''),(2391038,'1','201','1037',478,'Retail Sale Id 1420979',7500.00,0.00,0.00,12.50,775.00,'2021-12-28 14:06:46','',''),(2391302,'1','201','1037',478,'Retail Sale Id 1421163',1800.00,0.00,0.00,3.00,186.00,'2021-12-28 14:33:30','',''),(2391315,'1','201','1037',478,'Retail Sale Id 1421177',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 14:35:34','',''),(2391356,'1','201','1037',478,'Retail Sale Id 1421208',1200.00,0.00,0.00,2.00,124.00,'2021-12-28 14:40:46','',''),(2391616,'1','201','1037',478,'Retail Sale Id 1421406',1800.00,0.00,0.00,3.00,186.00,'2021-12-28 15:12:17','',''),(2391665,'1','201','1037',478,'Retail Sale Id 1421465',7500.00,0.00,0.00,12.50,775.00,'2021-12-28 15:19:20','',''),(2391795,'1','201','1037',478,'Retail Sale Id 1421605',3498.00,0.00,0.00,5.83,361.46,'2021-12-28 15:38:44','',''),(2391804,'1','201','1037',478,'Retail Sale Id 1421615',3000.00,0.00,0.00,5.00,310.00,'2021-12-28 15:39:51','',''),(2391820,'1','201','1037',478,'Retail Sale Id 1421629',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 15:41:14','',''),(2391898,'1','201','1037',478,'Retail Sale Id 1421678',7500.00,0.00,0.00,12.50,775.00,'2021-12-28 15:47:45','',''),(2391933,'1','201','1037',478,'Retail Sale Id 1421711',1200.00,0.00,0.00,2.00,124.00,'2021-12-28 15:51:39','',''),(2391962,'1','201','1037',478,'Retail Sale Id 1421746',1200.00,0.00,0.00,2.00,124.00,'2021-12-28 15:54:54','',''),(2392237,'1','201','1037',478,'Retail Sale Id 1421926',1800.00,0.00,0.00,3.00,186.00,'2021-12-28 16:17:51','',''),(2392437,'1','201','1037',478,'Retail Sale Id 1422031',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 16:35:10','',''),(2392518,'1','201','1037',478,'Retail Sale Id 1422106',1200.00,0.00,0.00,2.00,124.00,'2021-12-28 16:46:04','',''),(2392528,'1','201','1037',478,'Retail Sale Id 1422116',4200.00,0.00,0.00,7.00,434.00,'2021-12-28 16:48:24','',''),(2392644,'1','201','1037',478,'Retail Sale Id 1422215',3600.00,0.00,0.00,6.00,372.00,'2021-12-28 17:03:15','',''),(2393618,'1','201','1037',478,'Retail Sale Id 1422635',114000.00,0.00,0.00,200.00,6400.00,'2021-12-29 07:01:00','',''),(2393643,'1','201','1037',478,'Retail Sale Id 1422663',3600.00,0.00,0.00,6.00,372.00,'2021-12-29 07:03:55','',''),(2393726,'1','201','1037',478,'Retail Sale Id 1422734',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 07:12:53','',''),(2393817,'1','201','1037',478,'Retail Sale Id 1422797',1002.00,0.00,0.00,1.67,103.54,'2021-12-29 07:20:44','',''),(2393903,'1','201','1037',478,'Retail Sale Id 1422846',3000.00,0.00,0.00,5.00,310.00,'2021-12-29 07:28:00','',''),(2393934,'1','201','1037',478,'Retail Sale Id 1422874',2400.00,0.00,0.00,4.00,248.00,'2021-12-29 07:31:47','',''),(2393975,'1','201','1037',478,'Retail Sale Id 1422909',4200.00,0.00,0.00,7.00,434.00,'2021-12-29 07:36:37','',''),(2394078,'1','201','1037',478,'Retail Sale Id 1422985',6600.00,0.00,0.00,11.00,682.00,'2021-12-29 07:46:07','',''),(2394465,'1','201','1037',478,'Retail Sale Id 1423283',4002.00,0.00,0.00,6.67,413.54,'2021-12-29 08:25:04','',''),(2394528,'1','201','1037',478,'Retail Sale Id 1423335',1998.00,0.00,0.00,3.33,206.46,'2021-12-29 08:31:34','',''),(2394539,'1','201','1037',478,'Retail Sale Id 1423347',7200.00,0.00,0.00,12.00,744.00,'2021-12-29 08:33:01','',''),(2394844,'1','201','1037',478,'Retail Sale Id 1423589',1200.00,0.00,0.00,2.00,124.00,'2021-12-29 09:00:22','',''),(2394857,'1','201','1037',478,'Retail Sale Id 1423603',22800.00,0.00,0.00,40.00,1280.00,'2021-12-29 09:03:56','',''),(2394865,'1','201','1037',478,'Retail Sale Id 1423610',3000.00,0.00,0.00,5.00,310.00,'2021-12-29 09:05:09','',''),(2394897,'1','201','1037',478,'Retail Sale Id 1423637',3600.00,0.00,0.00,6.00,372.00,'2021-12-29 09:10:14','',''),(2395071,'1','201','1037',478,'Retail Sale Id 1423750',1200.00,0.00,0.00,2.00,124.00,'2021-12-29 09:23:59','',''),(2395134,'1','201','1037',478,'Retail Sale Id 1423809',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 09:30:55','',''),(2395157,'1','201','1037',478,'Retail Sale Id 1423839',7500.00,0.00,0.00,12.50,775.00,'2021-12-29 09:32:38','',''),(2395165,'1','201','1037',478,'Retail Sale Id 1423846',3600.00,0.00,0.00,6.00,372.00,'2021-12-29 09:33:43','',''),(2395184,'1','201','1037',478,'Retail Sale Id 1423862',28250.00,0.00,0.00,50.00,1350.00,'2021-12-29 09:35:50','',''),(2395236,'1','201','1037',478,'Retail Sale Id 1423914',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 09:43:38','',''),(2395295,'1','201','1037',478,'Retail Sale Id 1423957',1200.00,0.00,0.00,2.00,124.00,'2021-12-29 09:48:41','',''),(2395381,'1','201','1037',478,'Retail Sale Id 1424041',5400.00,0.00,0.00,9.00,558.00,'2021-12-29 09:57:41','',''),(2395407,'1','201','1037',478,'Retail Sale Id 1424062',2400.00,0.00,0.00,4.00,248.00,'2021-12-29 10:01:18','',''),(2395415,'1','201','1037',478,'Retail Sale Id 1424070',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 10:02:20','',''),(2395429,'1','201','1037',478,'Retail Sale Id 1424082',3000.00,0.00,0.00,5.00,310.00,'2021-12-29 10:04:10','',''),(2395500,'1','201','1037',478,'Retail Sale Id 1424129',3702.00,0.00,0.00,6.17,382.54,'2021-12-29 10:09:31','',''),(2395550,'1','201','1037',478,'Retail Sale Id 1424183',3000.00,0.00,0.00,5.00,310.00,'2021-12-29 10:15:31','',''),(2395592,'1','201','1037',478,'Retail Sale Id 1424215',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 10:19:11','',''),(2395816,'1','201','1037',478,'Retail Sale Id 1424416',1200.00,0.00,0.00,2.00,124.00,'2021-12-29 10:44:45','',''),(2395830,'1','201','1037',478,'Retail Sale Id 1424431',600.00,0.00,0.00,1.00,62.00,'2021-12-29 10:46:20','',''),(2395922,'1','201','1037',478,'Retail Sale Id 1424505',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 10:56:05','',''),(2396054,'1','201','1037',478,'Retail Sale Id 1424626',3600.00,0.00,0.00,6.00,372.00,'2021-12-29 11:08:29','',''),(2396092,'1','201','1037',478,'Retail Sale Id 1424662',3000.00,0.00,0.00,5.00,310.00,'2021-12-29 11:12:38','',''),(2396144,'1','201','1037',478,'Retail Sale Id 1424706',1002.00,0.00,0.00,1.67,103.54,'2021-12-29 11:18:24','',''),(2396225,'1','201','1037',478,'Retail Sale Id 1424778',600.00,0.00,0.00,1.00,62.00,'2021-12-29 11:28:03','',''),(2396259,'1','201','1037',478,'Retail Sale Id 1424810',3600.00,0.00,0.00,6.00,372.00,'2021-12-29 11:32:18','',''),(2396615,'1','201','1037',478,'Retail Sale Id 1425124',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 12:17:24','',''),(2396644,'1','201','1037',478,'Retail Sale Id 1425149',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 12:22:05','',''),(2396663,'1','201','1037',478,'Retail Sale Id 1425170',3000.00,0.00,0.00,5.00,310.00,'2021-12-29 12:25:13','',''),(2396776,'1','201','1037',478,'Retail Sale Id 1425231',3000.00,0.00,0.00,5.00,310.00,'2021-12-29 12:38:19','',''),(2396924,'1','201','1037',478,'Retail Sale Id 1425388',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 12:57:14','',''),(2397099,'1','201','1037',478,'Retail Sale Id 1425522',600.00,0.00,0.00,1.00,62.00,'2021-12-29 13:17:14','',''),(2397118,'1','201','1037',478,'Retail Sale Id 1425538',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 13:19:31','',''),(2397181,'1','201','1037',478,'Retail Sale Id 1425590',2502.00,0.00,0.00,4.17,258.54,'2021-12-29 13:26:40','',''),(2397257,'1','201','1037',478,'Retail Sale Id 1425644',1500.00,0.00,0.00,2.50,155.00,'2021-12-29 13:35:15','',''),(2397337,'1','201','1037',478,'Retail Sale Id 1425697',2100.00,0.00,0.00,3.50,217.00,'2021-12-29 13:44:53','',''),(2397488,'1','201','1037',478,'Retail Sale Id 1425831',1200.00,0.00,0.00,2.00,124.00,'2021-12-29 14:02:59','',''),(2397494,'1','201','1037',478,'Retail Sale Id 1425840',600.00,0.00,0.00,1.00,62.00,'2021-12-29 14:03:55','',''),(2397588,'1','201','1037',478,'Retail Sale Id 1425916',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 14:12:18','',''),(2397601,'1','201','1037',478,'Retail Sale Id 1425928',3000.00,0.00,0.00,5.00,310.00,'2021-12-29 14:13:57','',''),(2397887,'1','201','1037',478,'Retail Sale Id 1426122',7500.00,0.00,0.00,12.50,775.00,'2021-12-29 14:38:55','',''),(2397910,'1','201','1037',478,'Retail Sale Id 1426133',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 14:40:14','',''),(2398005,'1','201','1037',478,'Retail Sale Id 1426205',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 14:49:16','',''),(2398163,'1','201','1037',478,'Retail Sale Id 1426314',2400.00,0.00,0.00,4.00,248.00,'2021-12-29 15:05:06','',''),(2398277,'1','201','1037',478,'Retail Sale Id 1426358',1200.00,0.00,0.00,2.00,124.00,'2021-12-29 15:12:26','',''),(2398377,'1','201','1037',478,'Retail Sale Id 1426426',5502.00,0.00,0.00,9.17,568.54,'2021-12-29 15:21:44','',''),(2398464,'1','201','1037',478,'Retail Sale Id 1426486',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 15:28:05','',''),(2398587,'1','201','1037',478,'Retail Sale Id 1426563',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 15:36:54','',''),(2398686,'1','201','1037',478,'Retail Sale Id 1426615',3600.00,0.00,0.00,6.00,372.00,'2021-12-29 15:42:45','',''),(2398761,'1','201','1037',478,'Retail Sale Id 1426678',600.00,0.00,0.00,1.00,62.00,'2021-12-29 15:50:42','',''),(2398788,'1','201','1037',478,'Retail Sale Id 1426695',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 15:52:56','',''),(2398831,'1','201','1037',478,'Retail Sale Id 1426722',4200.00,0.00,0.00,7.00,434.00,'2021-12-29 15:57:21','',''),(2398857,'1','201','1037',478,'Retail Sale Id 1426736',7500.00,0.00,0.00,12.50,775.00,'2021-12-29 15:58:55','',''),(2399005,'1','201','1037',478,'Retail Sale Id 1426851',1500.00,0.00,0.00,2.50,155.00,'2021-12-29 16:15:38','',''),(2399034,'1','201','1037',478,'Retail Sale Id 1426875',900.00,0.00,0.00,1.50,93.00,'2021-12-29 16:19:03','',''),(2399049,'1','201','1037',478,'Retail Sale Id 1426891',7500.00,0.00,0.00,12.50,775.00,'2021-12-29 16:20:35','',''),(2399050,'1','201','1037',478,'Retail Sale Id 1426891',7500.00,0.00,0.00,12.50,775.00,'2021-12-29 16:20:35','',''),(2399058,'1','201','1037',478,'Retail Sale Id 1426899',7500.00,0.00,0.00,12.50,775.00,'2021-12-29 16:21:50','',''),(2399139,'1','201','1037',478,'Retail Sale Id 1426985',3600.00,0.00,0.00,6.00,372.00,'2021-12-29 16:31:02','',''),(2399140,'1','201','1037',478,'Retail Sale Id 1426985',7200.00,0.00,0.00,12.00,744.00,'2021-12-29 16:31:02','',''),(2399204,'1','201','1037',478,'Retail Sale Id 1427041',1800.00,0.00,0.00,3.00,186.00,'2021-12-29 16:39:24','',''),(2399219,'1','201','1037',478,'Retail Sale Id 1427055',28250.00,0.00,0.00,50.00,1350.00,'2021-12-29 16:40:57','',''),(2399323,'1','201','1037',478,'Retail Sale Id 1427123',3000.00,0.00,0.00,5.00,310.00,'2021-12-29 16:51:39','',''),(2399355,'1','201','1037',478,'Retail Sale Id 1427154',4200.00,0.00,0.00,7.00,434.00,'2021-12-29 16:56:20','',''),(2399634,'1','201','1037',478,'Retail Sale Id 1427357',714.00,0.00,0.00,1.19,73.78,'2021-12-29 19:47:47','',''),(2399642,'1','201','1037',478,'Return of Retail Sale Id 1427357',0.00,714.00,1.19,0.00,-73.78,'2021-12-29 19:49:38','',''),(2399643,'1','201','1037',478,'Retail Sale Id 1427358',708.00,0.00,0.00,1.18,73.16,'2021-12-29 19:51:04','',''),(2399657,'1','201','1037',478,'Return of Retail Sale Id 1427055',0.00,28250.00,50.00,0.00,-1350.00,'2021-12-29 19:54:35','',''),(2399658,'1','201','1037',478,'Retail Sale Id 1427359',28254.90,0.00,0.00,49.57,1586.24,'2021-12-29 19:55:34','',''),(2399665,'1','201','1037',478,'Return of Retail Sale Id 1427154',0.00,4200.00,7.00,0.00,-434.00,'2021-12-29 19:57:37','',''),(2399666,'1','201','1037',478,'Retail Sale Id 1427360',4194.00,0.00,0.00,6.99,433.38,'2021-12-29 19:58:31','',''),(2400783,'1','201','1037',478,'Retail Sale Id 1427919',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 07:43:00','',''),(2400808,'1','201','1037',478,'Retail Sale Id 1427942',300.00,0.00,0.00,0.50,31.00,'2021-12-30 07:46:07','',''),(2400911,'1','201','1037',478,'Retail Sale Id 1428032',57000.00,0.00,0.00,100.00,3200.00,'2021-12-30 07:57:48','',''),(2400925,'1','201','1037',478,'Retail Sale Id 1428048',3000.00,0.00,0.00,5.00,310.00,'2021-12-30 07:59:23','',''),(2400978,'1','201','1037',478,'Retail Sale Id 1428089',3000.00,0.00,0.00,5.00,310.00,'2021-12-30 08:04:25','',''),(2401276,'1','201','1037',478,'Retail Sale Id 1428293',7500.00,0.00,0.00,12.50,775.00,'2021-12-30 08:29:02','',''),(2401647,'1','201','1037',478,'Retail Sale Id 1428555',3600.00,0.00,0.00,6.00,372.00,'2021-12-30 08:55:30','',''),(2401805,'1','201','1037',478,'Retail Sale Id 1428680',3600.00,0.00,0.00,6.00,372.00,'2021-12-30 09:07:49','',''),(2401819,'1','201','1037',478,'Retail Sale Id 1428695',1200.00,0.00,0.00,2.00,124.00,'2021-12-30 09:09:22','',''),(2401900,'1','201','1037',478,'Retail Sale Id 1428755',7500.00,0.00,0.00,12.50,775.00,'2021-12-30 09:15:57','',''),(2402248,'1','201','1037',478,'Retail Sale Id 1429060',85500.00,0.00,0.00,150.00,4800.00,'2021-12-30 09:49:22','',''),(2402261,'1','201','1037',478,'Retail Sale Id 1429074',19950.00,0.00,0.00,35.00,1120.00,'2021-12-30 09:51:01','',''),(2402279,'1','201','1037',478,'Retail Sale Id 1429091',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 09:53:00','',''),(2402290,'1','201','1037',478,'Retail Sale Id 1429101',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 09:54:03','',''),(2402330,'1','201','1037',478,'Retail Sale Id 1429139',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 09:57:35','',''),(2402347,'1','201','1037',478,'Retail Sale Id 1429157',3600.00,0.00,0.00,6.00,372.00,'2021-12-30 09:58:59','',''),(2402381,'1','201','1037',478,'Retail Sale Id 1429196',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 10:02:13','',''),(2402429,'1','201','1037',478,'Retail Sale Id 1429242',3000.00,0.00,0.00,5.00,310.00,'2021-12-30 10:07:17','',''),(2402485,'1','201','1037',478,'Retail Sale Id 1429298',1098.00,0.00,0.00,1.83,113.46,'2021-12-30 10:13:30','',''),(2402512,'1','201','1037',478,'Retail Sale Id 1429330',1500.00,0.00,0.00,2.50,155.00,'2021-12-30 10:17:05','',''),(2402560,'1','201','1037',478,'Retail Sale Id 1429373',1200.00,0.00,0.00,2.00,124.00,'2021-12-30 10:20:47','',''),(2402605,'1','201','1037',478,'Retail Sale Id 1429412',3600.00,0.00,0.00,6.00,372.00,'2021-12-30 10:25:36','',''),(2402623,'1','201','1037',478,'Retail Sale Id 1429436',3900.00,0.00,0.00,6.50,403.00,'2021-12-30 10:27:49','',''),(2402638,'1','201','1037',478,'Retail Sale Id 1429450',3600.00,0.00,0.00,6.00,372.00,'2021-12-30 10:29:03','',''),(2402650,'1','201','1037',478,'Retail Sale Id 1429464',2400.00,0.00,0.00,4.00,248.00,'2021-12-30 10:30:35','',''),(2402669,'1','201','1037',478,'Retail Sale Id 1429475',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 10:32:23','',''),(2402783,'1','201','1037',478,'Retail Sale Id 1429551',4200.00,0.00,0.00,7.00,434.00,'2021-12-30 10:41:04','',''),(2402800,'1','201','1037',478,'Retail Sale Id 1429569',2400.00,0.00,0.00,4.00,248.00,'2021-12-30 10:42:41','',''),(2402817,'1','201','1037',478,'Retail Sale Id 1429586',2400.00,0.00,0.00,4.00,248.00,'2021-12-30 10:45:10','',''),(2402827,'1','201','1037',478,'Retail Sale Id 1429594',3000.00,0.00,0.00,5.00,310.00,'2021-12-30 10:46:49','',''),(2402924,'1','201','1037',478,'Retail Sale Id 1429656',27000.90,0.00,0.00,47.37,1515.84,'2021-12-30 10:53:17','',''),(2403062,'1','201','1037',478,'Retail Sale Id 1429796',3000.00,0.00,0.00,5.00,310.00,'2021-12-30 11:09:20','',''),(2403071,'1','201','1037',478,'Retail Sale Id 1429805',1200.00,0.00,0.00,2.00,124.00,'2021-12-30 11:10:19','',''),(2403086,'1','201','1037',478,'Retail Sale Id 1429820',1602.00,0.00,0.00,2.67,165.54,'2021-12-30 11:11:40','',''),(2403110,'1','201','1037',478,'Retail Sale Id 1429836',3000.00,0.00,0.00,5.00,310.00,'2021-12-30 11:13:53','',''),(2403153,'1','201','1037',478,'Retail Sale Id 1429873',2400.00,0.00,0.00,4.00,248.00,'2021-12-30 11:18:56','',''),(2403251,'1','201','1037',478,'Retail Sale Id 1429968',6000.00,0.00,0.00,10.00,620.00,'2021-12-30 11:33:56','',''),(2403270,'1','201','1037',478,'Retail Sale Id 1429989',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 11:36:56','',''),(2403609,'1','201','1037',478,'Retail Sale Id 1430330',1200.00,0.00,0.00,2.00,124.00,'2021-12-30 12:24:31','',''),(2403610,'1','201','1037',478,'Retail Sale Id 1430330',1200.00,0.00,0.00,2.00,124.00,'2021-12-30 12:24:31','',''),(2403611,'1','201','1037',478,'Retail Sale Id 1430330',4800.00,0.00,0.00,8.00,496.00,'2021-12-30 12:24:31','',''),(2403654,'1','201','1037',478,'Retail Sale Id 1430360',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 12:28:52','',''),(2403655,'1','201','1037',478,'Retail Sale Id 1430360',7500.00,0.00,0.00,12.50,775.00,'2021-12-30 12:28:52','',''),(2403672,'1','201','1037',478,'Retail Sale Id 1430377',8550.00,0.00,0.00,15.00,480.00,'2021-12-30 12:30:28','',''),(2403685,'1','201','1037',478,'Retail Sale Id 1430389',3600.00,0.00,0.00,6.00,372.00,'2021-12-30 12:31:45','',''),(2403690,'1','201','1037',478,'Retail Sale Id 1430395',7500.00,0.00,0.00,12.50,775.00,'2021-12-30 12:32:50','',''),(2403917,'1','201','1037',478,'Retail Sale Id 1430450',57000.00,0.00,0.00,100.00,3200.00,'2021-12-30 13:01:23','',''),(2403930,'1','201','1037',478,'Retail Sale Id 1430598',5400.00,0.00,0.00,9.00,558.00,'2021-12-30 13:02:40','',''),(2403946,'1','201','1037',478,'Retail Sale Id 1430609',4800.00,0.00,0.00,8.00,496.00,'2021-12-30 13:04:40','',''),(2404161,'1','201','1037',478,'Retail Sale Id 1430758',4200.00,0.00,0.00,7.00,434.00,'2021-12-30 13:26:16','',''),(2404174,'1','201','1037',478,'Retail Sale Id 1430767',1200.00,0.00,0.00,2.00,124.00,'2021-12-30 13:27:08','',''),(2404240,'1','201','1037',478,'Retail Sale Id 1430811',3000.00,0.00,0.00,5.00,310.00,'2021-12-30 13:31:48','',''),(2404369,'1','201','1037',478,'Retail Sale Id 1430883',1500.00,0.00,0.00,2.50,155.00,'2021-12-30 13:40:32','',''),(2404432,'1','201','1037',478,'Retail Sale Id 1430896',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 13:43:07','',''),(2404601,'1','201','1037',478,'Retail Sale Id 1431032',3600.00,0.00,0.00,6.00,372.00,'2021-12-30 14:00:57','',''),(2404622,'1','201','1037',478,'Retail Sale Id 1431048',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 14:03:57','',''),(2404823,'1','201','1037',478,'Retail Sale Id 1431216',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 14:23:13','',''),(2404843,'1','201','1037',478,'Retail Sale Id 1431233',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 14:25:02','',''),(2405175,'1','201','1037',478,'Retail Sale Id 1431576',3000.00,0.00,0.00,5.00,310.00,'2021-12-30 15:08:17','',''),(2405189,'1','201','1037',478,'Retail Sale Id 1431587',1500.00,0.00,0.00,2.50,155.00,'2021-12-30 15:09:20','',''),(2405201,'1','201','1037',478,'Retail Sale Id 1431600',4200.00,0.00,0.00,7.00,434.00,'2021-12-30 15:10:45','',''),(2405213,'1','201','1037',478,'Retail Sale Id 1431614',7500.00,0.00,0.00,12.50,775.00,'2021-12-30 15:11:48','',''),(2405236,'1','201','1037',478,'Retail Sale Id 1431630',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 15:14:04','',''),(2405237,'1','201','1037',478,'Retail Sale Id 1431630',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 15:14:04','',''),(2405238,'1','201','1037',478,'Retail Sale Id 1431630',2400.00,0.00,0.00,4.00,248.00,'2021-12-30 15:14:04','',''),(2405252,'1','201','1037',478,'Retail Sale Id 1431643',4800.00,0.00,0.00,8.00,496.00,'2021-12-30 15:15:34','',''),(2405305,'1','201','1037',478,'Retail Sale Id 1431693',2400.00,0.00,0.00,4.00,248.00,'2021-12-30 15:20:25','',''),(2405329,'1','201','1037',478,'Retail Sale Id 1431716',3600.00,0.00,0.00,6.00,372.00,'2021-12-30 15:23:40','',''),(2405406,'1','201','1037',478,'Retail Sale Id 1431768',7500.00,0.00,0.00,12.50,775.00,'2021-12-30 15:30:31','',''),(2405420,'1','201','1037',478,'Retail Sale Id 1431782',4200.00,0.00,0.00,7.00,434.00,'2021-12-30 15:32:02','',''),(2405555,'1','201','1037',478,'Retail Sale Id 1431893',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 15:44:44','',''),(2405619,'1','201','1037',478,'Retail Sale Id 1431937',3600.00,0.00,0.00,6.00,372.00,'2021-12-30 15:49:50','',''),(2405684,'1','201','1037',478,'Retail Sale Id 1432004',7200.00,0.00,0.00,12.00,744.00,'2021-12-30 15:56:38','',''),(2405862,'1','201','1037',478,'Retail Sale Id 1432174',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 16:11:54','',''),(2405880,'1','201','1037',478,'Retail Sale Id 1432191',3000.00,0.00,0.00,5.00,310.00,'2021-12-30 16:13:43','',''),(2405892,'1','201','1037',478,'Retail Sale Id 1432202',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 16:14:40','',''),(2405915,'1','201','1037',478,'Retail Sale Id 1432222',7500.00,0.00,0.00,12.50,775.00,'2021-12-30 16:17:09','',''),(2405930,'1','201','1037',478,'Retail Sale Id 1432244',7500.00,0.00,0.00,12.50,775.00,'2021-12-30 16:18:33','',''),(2405989,'1','201','1037',478,'Retail Sale Id 1432301',1200.00,0.00,0.00,2.00,124.00,'2021-12-30 16:25:23','',''),(2406220,'1','201','1037',478,'Retail Sale Id 1432515',1800.00,0.00,0.00,3.00,186.00,'2021-12-30 16:45:28','',''),(2406370,'1','201','1037',478,'Retail Sale Id 1432639',2400.00,0.00,0.00,4.00,248.00,'2021-12-30 17:02:38','',''),(2407884,'1','201','1037',478,'Retail Sale Id 1433405',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 07:26:43','',''),(2408077,'1','201','1037',478,'Retail Sale Id 1433531',13800.00,0.00,0.00,23.00,1426.00,'2021-12-31 07:39:30','',''),(2408096,'1','201','1037',478,'Retail Sale Id 1433548',5400.00,0.00,0.00,9.00,558.00,'2021-12-31 07:41:32','',''),(2408362,'1','201','1037',478,'Retail Sale Id 1433752',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 08:03:55','',''),(2408419,'1','201','1037',478,'Retail Sale Id 1433811',2400.00,0.00,0.00,4.00,248.00,'2021-12-31 08:09:17','',''),(2408468,'1','201','1037',478,'Retail Sale Id 1433860',6498.00,0.00,0.00,10.83,671.46,'2021-12-31 08:13:41','',''),(2408552,'1','201','1037',478,'Retail Sale Id 1433938',7500.00,0.00,0.00,12.50,775.00,'2021-12-31 08:20:36','',''),(2408750,'1','201','1037',478,'Retail Sale Id 1434124',3000.00,0.00,0.00,5.00,310.00,'2021-12-31 08:37:37','',''),(2408789,'1','201','1037',478,'Retail Sale Id 1434141',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 08:39:02','',''),(2408829,'1','201','1037',478,'Retail Sale Id 1434183',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 08:42:28','',''),(2408856,'1','201','1037',478,'Retail Sale Id 1434206',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 08:44:16','',''),(2409289,'1','201','1037',478,'Retail Sale Id 1434583',5400.00,0.00,0.00,9.00,558.00,'2021-12-31 09:22:16','',''),(2409364,'1','201','1037',478,'Retail Sale Id 1434657',4800.00,0.00,0.00,8.00,496.00,'2021-12-31 09:32:29','',''),(2409386,'1','201','1037',478,'Retail Sale Id 1434679',2400.00,0.00,0.00,4.00,248.00,'2021-12-31 09:35:14','',''),(2409410,'1','201','1037',478,'Retail Sale Id 1434688',1002.00,0.00,0.00,1.67,103.54,'2021-12-31 09:36:19','',''),(2409455,'1','201','1037',478,'Retail Sale Id 1434743',22800.00,0.00,0.00,40.00,1280.00,'2021-12-31 09:42:06','',''),(2409522,'1','201','1037',478,'Retail Sale Id 1434805',1500.00,0.00,0.00,2.50,155.00,'2021-12-31 09:51:30','',''),(2409530,'1','201','1037',478,'Retail Sale Id 1434813',1998.00,0.00,0.00,3.33,206.46,'2021-12-31 09:52:32','',''),(2409573,'1','201','1037',478,'Retail Sale Id 1434862',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 09:58:46','',''),(2409610,'1','201','1037',478,'Retail Sale Id 1434902',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 10:04:46','',''),(2409725,'1','201','1037',478,'Retail Sale Id 1435024',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 10:19:19','',''),(2409735,'1','201','1037',478,'Retail Sale Id 1435035',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 10:20:26','',''),(2409756,'1','201','1037',478,'Retail Sale Id 1435056',600.00,0.00,0.00,1.00,62.00,'2021-12-31 10:22:20','',''),(2409773,'1','201','1037',478,'Retail Sale Id 1435075',2400.00,0.00,0.00,4.00,248.00,'2021-12-31 10:25:08','',''),(2409927,'1','201','1037',478,'Retail Sale Id 1435158',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 10:34:46','',''),(2410054,'1','201','1037',478,'Retail Sale Id 1435263',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 10:45:36','',''),(2410086,'1','201','1037',478,'Retail Sale Id 1435283',3000.00,0.00,0.00,5.00,310.00,'2021-12-31 10:47:46','',''),(2410170,'1','201','1037',478,'Retail Sale Id 1435359',2400.00,0.00,0.00,4.00,248.00,'2021-12-31 10:56:26','',''),(2410266,'1','201','1037',478,'Retail Sale Id 1435452',1998.00,0.00,0.00,3.33,206.46,'2021-12-31 11:08:10','',''),(2410348,'1','201','1037',478,'Retail Sale Id 1435528',1500.00,0.00,0.00,2.50,155.00,'2021-12-31 11:18:19','',''),(2410361,'1','201','1037',478,'Retail Sale Id 1435540',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 11:19:20','',''),(2410427,'1','201','1037',478,'Retail Sale Id 1435592',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 11:25:50','',''),(2410432,'1','201','1037',478,'Retail Sale Id 1435604',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 11:26:39','',''),(2410437,'1','201','1037',478,'Retail Sale Id 1435611',2400.00,0.00,0.00,4.00,248.00,'2021-12-31 11:27:31','',''),(2410683,'1','201','1037',478,'Retail Sale Id 1435832',1998.00,0.00,0.00,3.33,206.46,'2021-12-31 11:51:40','',''),(2410709,'1','201','1037',478,'Retail Sale Id 1435857',3000.00,0.00,0.00,5.00,310.00,'2021-12-31 11:54:38','',''),(2410752,'1','201','1037',478,'Retail Sale Id 1435894',2400.00,0.00,0.00,4.00,248.00,'2021-12-31 11:59:26','',''),(2410835,'1','201','1037',478,'Retail Sale Id 1435977',4200.00,0.00,0.00,7.00,434.00,'2021-12-31 12:13:03','',''),(2410950,'1','201','1037',478,'Retail Sale Id 1436095',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 12:30:11','',''),(2411138,'1','201','1037',478,'Retail Sale Id 1436278',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 13:08:24','',''),(2411165,'1','201','1037',478,'Retail Sale Id 1436305',7500.00,0.00,0.00,12.50,775.00,'2021-12-31 13:13:45','',''),(2411174,'1','201','1037',478,'Retail Sale Id 1436317',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 13:15:05','',''),(2411182,'1','201','1037',478,'Retail Sale Id 1436326',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 13:16:23','',''),(2411202,'1','201','1037',478,'Retail Sale Id 1436339',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 13:17:42','',''),(2411212,'1','201','1037',478,'Retail Sale Id 1436352',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 13:18:54','',''),(2411242,'1','201','1037',478,'Retail Sale Id 1436378',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 13:22:23','',''),(2411243,'1','201','1037',478,'Retail Sale Id 1436378',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 13:22:23','',''),(2411244,'1','201','1037',478,'Retail Sale Id 1436378',7500.00,0.00,0.00,12.50,775.00,'2021-12-31 13:22:23','',''),(2411251,'1','201','1037',478,'Retail Sale Id 1436388',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 13:23:31','',''),(2411272,'1','201','1037',478,'Retail Sale Id 1436411',4998.00,0.00,0.00,8.33,516.46,'2021-12-31 13:26:28','',''),(2411375,'1','201','1037',478,'Retail Sale Id 1436513',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 13:39:39','',''),(2411437,'1','201','1037',478,'Retail Sale Id 1436582',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 13:47:04','',''),(2411869,'1','201','1037',478,'Retail Sale Id 1436918',28500.00,0.00,0.00,50.00,1600.00,'2021-12-31 14:22:32','',''),(2411879,'1','201','1037',478,'Retail Sale Id 1436925',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 14:23:32','',''),(2411888,'1','201','1037',478,'Retail Sale Id 1436936',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 14:24:30','',''),(2411897,'1','201','1037',478,'Retail Sale Id 1436945',6000.00,0.00,0.00,10.00,620.00,'2021-12-31 14:25:31','',''),(2411918,'1','201','1037',478,'Retail Sale Id 1436969',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 14:28:21','',''),(2411919,'1','201','1037',478,'Retail Sale Id 1436969',6000.00,0.00,0.00,10.00,620.00,'2021-12-31 14:28:21','',''),(2412048,'1','201','1037',478,'Retail Sale Id 1437042',7200.00,0.00,0.00,12.00,744.00,'2021-12-31 14:37:42','',''),(2412062,'1','201','1037',478,'Retail Sale Id 1437055',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 14:38:52','',''),(2412079,'1','201','1037',478,'Retail Sale Id 1437070',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 14:40:29','',''),(2412080,'1','201','1037',478,'Retail Sale Id 1437070',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 14:40:29','',''),(2412146,'1','201','1037',478,'Retail Sale Id 1437132',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 14:48:40','',''),(2412198,'1','201','1037',478,'Retail Sale Id 1437159',3000.00,0.00,0.00,5.00,310.00,'2021-12-31 14:52:09','',''),(2412216,'1','201','1037',478,'Retail Sale Id 1437173',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 14:53:12','',''),(2412228,'1','201','1037',478,'Retail Sale Id 1437182',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 14:54:18','',''),(2412425,'1','201','1037',478,'Retail Sale Id 1437381',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 15:16:51','',''),(2412484,'1','201','1037',478,'Retail Sale Id 1437417',7500.00,0.00,0.00,12.50,775.00,'2021-12-31 15:20:25','',''),(2412555,'1','201','1037',478,'Retail Sale Id 1437457',7200.00,0.00,0.00,12.00,744.00,'2021-12-31 15:24:06','',''),(2412670,'1','201','1037',478,'Retail Sale Id 1437573',4200.00,0.00,0.00,7.00,434.00,'2021-12-31 15:31:22','',''),(2412696,'1','201','1037',478,'Retail Sale Id 1437586',600.00,0.00,0.00,1.00,62.00,'2021-12-31 15:32:38','',''),(2412709,'1','201','1037',478,'Retail Sale Id 1437592',2100.00,0.00,0.00,3.50,217.00,'2021-12-31 15:33:36','',''),(2412734,'1','201','1037',478,'Retail Sale Id 1437604',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 15:34:38','',''),(2412743,'1','201','1037',478,'Retail Sale Id 1437615',3000.00,0.00,0.00,5.00,310.00,'2021-12-31 15:35:41','',''),(2412866,'1','201','1037',478,'Retail Sale Id 1437696',4800.00,0.00,0.00,8.00,496.00,'2021-12-31 15:42:48','',''),(2412889,'1','201','1037',478,'Retail Sale Id 1437713',2400.00,0.00,0.00,4.00,248.00,'2021-12-31 15:44:19','',''),(2412932,'1','201','1037',478,'Retail Sale Id 1437748',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 15:47:25','',''),(2412944,'1','201','1037',478,'Retail Sale Id 1437761',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 15:48:45','',''),(2412945,'1','201','1037',478,'Retail Sale Id 1437761',2400.00,0.00,0.00,4.00,248.00,'2021-12-31 15:48:45','',''),(2412967,'1','201','1037',478,'Retail Sale Id 1437778',10800.00,0.00,0.00,18.00,1116.00,'2021-12-31 15:50:46','',''),(2412983,'1','201','1037',478,'Retail Sale Id 1437793',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 15:51:40','',''),(2413080,'1','201','1037',478,'Retail Sale Id 1437871',2100.00,0.00,0.00,3.50,217.00,'2021-12-31 15:59:53','',''),(2413172,'1','201','1037',478,'Retail Sale Id 1437952',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 16:07:40','',''),(2413206,'1','201','1037',478,'Retail Sale Id 1437977',3000.00,0.00,0.00,5.00,310.00,'2021-12-31 16:10:44','',''),(2413283,'1','201','1037',478,'Retail Sale Id 1438056',6000.00,0.00,0.00,10.00,620.00,'2021-12-31 16:19:30','',''),(2413324,'1','201','1037',478,'Retail Sale Id 1438098',2400.00,0.00,0.00,4.00,248.00,'2021-12-31 16:24:40','',''),(2413350,'1','201','1037',478,'Retail Sale Id 1438160',1200.00,0.00,0.00,2.00,124.00,'2021-12-31 16:27:13','',''),(2413408,'1','201','1037',478,'Retail Sale Id 1438219',7500.00,0.00,0.00,12.50,775.00,'2021-12-31 16:33:05','',''),(2413435,'1','201','1037',478,'Retail Sale Id 1438237',7500.00,0.00,0.00,12.50,775.00,'2021-12-31 16:34:54','',''),(2413597,'1','201','1037',478,'Retail Sale Id 1438354',5400.00,0.00,0.00,9.00,558.00,'2021-12-31 16:46:20','',''),(2413651,'1','201','1037',478,'Retail Sale Id 1438404',7500.00,0.00,0.00,12.50,775.00,'2021-12-31 16:51:55','',''),(2413659,'1','201','1037',478,'Retail Sale Id 1438413',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 16:52:55','',''),(2413675,'1','201','1037',478,'Retail Sale Id 1438430',1800.00,0.00,0.00,3.00,186.00,'2021-12-31 16:54:35','',''),(2413714,'1','201','1037',478,'Retail Sale Id 1438498',1500.00,0.00,0.00,2.50,155.00,'2021-12-31 16:58:36','',''),(2413722,'1','201','1037',478,'Retail Sale Id 1438548',3600.00,0.00,0.00,6.00,372.00,'2021-12-31 17:02:11','',''),(2414629,'1','201','1037',478,'Retail Sale Id 1438981',4200.00,0.00,0.00,7.00,434.00,'2022-01-01 06:49:59','',''),(2414800,'1','201','1037',478,'Retail Sale Id 1439128',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 07:12:25','',''),(2415012,'1','201','1037',478,'Retail Sale Id 1439298',3600.00,0.00,0.00,6.00,372.00,'2022-01-01 07:33:29','',''),(2415049,'1','201','1037',478,'Retail Sale Id 1439335',7500.00,0.00,0.00,12.50,775.00,'2022-01-01 07:38:53','',''),(2415154,'1','201','1037',478,'Retail Sale Id 1439415',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 07:48:04','',''),(2415178,'1','201','1037',478,'Retail Sale Id 1439427',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 07:49:17','',''),(2415282,'1','201','1037',478,'Retail Sale Id 1439475',1998.00,0.00,0.00,3.33,206.46,'2022-01-01 07:56:08','',''),(2415525,'1','201','1037',478,'Retail Sale Id 1439701',6840.00,0.00,0.00,12.00,384.00,'2022-01-01 08:17:35','',''),(2415580,'1','201','1037',478,'Retail Sale Id 1439749',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 08:22:11','',''),(2415591,'1','201','1037',478,'Retail Sale Id 1439761',1200.00,0.00,0.00,2.00,124.00,'2022-01-01 08:23:11','',''),(2415680,'1','201','1037',478,'Retail Sale Id 1439855',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 08:32:50','',''),(2415749,'1','201','1037',478,'Retail Sale Id 1439904',7500.00,0.00,0.00,12.50,775.00,'2022-01-01 08:36:33','',''),(2415788,'1','201','1037',478,'Retail Sale Id 1439946',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 08:40:29','',''),(2416011,'1','201','1037',478,'Retail Sale Id 1440138',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 09:00:22','',''),(2416103,'1','201','1037',478,'Retail Sale Id 1440223',4998.00,0.00,0.00,8.33,516.46,'2022-01-01 09:10:41','',''),(2416155,'1','201','1037',478,'Retail Sale Id 1440274',1998.00,0.00,0.00,3.33,206.46,'2022-01-01 09:16:45','',''),(2416257,'1','201','1037',478,'Retail Sale Id 1440369',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 09:26:31','',''),(2416298,'1','201','1037',478,'Retail Sale Id 1440391',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 09:28:31','',''),(2416497,'1','201','1037',478,'Retail Sale Id 1440572',1698.00,0.00,0.00,2.83,175.46,'2022-01-01 09:48:08','',''),(2416531,'1','201','1037',478,'Retail Sale Id 1440602',2100.00,0.00,0.00,3.50,217.00,'2022-01-01 09:51:29','',''),(2416541,'1','201','1037',478,'Retail Sale Id 1440609',3600.00,0.00,0.00,6.00,372.00,'2022-01-01 09:52:47','',''),(2416556,'1','201','1037',478,'Retail Sale Id 1440624',1002.00,0.00,0.00,1.67,103.54,'2022-01-01 09:53:57','',''),(2416667,'1','201','1037',478,'Retail Sale Id 1440700',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 10:04:15','',''),(2416757,'1','201','1037',478,'Retail Sale Id 1440795',1200.00,0.00,0.00,2.00,124.00,'2022-01-01 10:14:39','',''),(2416859,'1','201','1037',478,'Retail Sale Id 1440888',3600.00,0.00,0.00,6.00,372.00,'2022-01-01 10:24:41','',''),(2417111,'1','201','1037',478,'Retail Sale Id 1441110',1200.00,0.00,0.00,2.00,124.00,'2022-01-01 10:51:06','',''),(2417171,'1','201','1037',478,'Retail Sale Id 1441162',7500.00,0.00,0.00,12.50,775.00,'2022-01-01 10:57:48','',''),(2417299,'1','201','1037',478,'Retail Sale Id 1441263',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 11:11:55','',''),(2417310,'1','201','1037',478,'Retail Sale Id 1441286',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 11:13:03','',''),(2417323,'1','201','1037',478,'Retail Sale Id 1441300',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 11:14:07','',''),(2417376,'1','201','1037',478,'Retail Sale Id 1441353',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 11:20:05','',''),(2417384,'1','201','1037',478,'Retail Sale Id 1441362',2400.00,0.00,0.00,4.00,248.00,'2022-01-01 11:21:14','',''),(2417400,'1','201','1037',478,'Retail Sale Id 1441376',1602.00,0.00,0.00,2.67,165.54,'2022-01-01 11:23:49','',''),(2419134,'1','201','1037',478,'Retail Sale Id 1442852',7500.00,0.00,0.00,12.50,775.00,'2022-01-01 14:55:40','',''),(2419142,'1','201','1037',478,'Retail Sale Id 1442861',4500.00,0.00,0.00,7.50,465.00,'2022-01-01 14:57:37','',''),(2419151,'1','201','1037',478,'Retail Sale Id 1442869',600.00,0.00,0.00,1.00,62.00,'2022-01-01 14:59:09','',''),(2419152,'1','201','1037',478,'Retail Sale Id 1442869',600.00,0.00,0.00,1.00,62.00,'2022-01-01 14:59:09','',''),(2419160,'1','201','1037',478,'Retail Sale Id 1442877',2400.00,0.00,0.00,4.00,248.00,'2022-01-01 15:00:23','',''),(2419165,'1','201','1037',478,'Retail Sale Id 1442884',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 15:01:45','',''),(2419173,'1','201','1037',478,'Retail Sale Id 1442890',1200.00,0.00,0.00,2.00,124.00,'2022-01-01 15:02:54','',''),(2419179,'1','201','1037',478,'Retail Sale Id 1442899',7500.00,0.00,0.00,12.50,775.00,'2022-01-01 15:03:56','',''),(2419192,'1','201','1037',478,'Retail Sale Id 1442910',7500.00,0.00,0.00,12.50,775.00,'2022-01-01 15:05:47','',''),(2419199,'1','201','1037',478,'Retail Sale Id 1442919',3900.00,0.00,0.00,6.50,403.00,'2022-01-01 15:08:46','',''),(2419207,'1','201','1037',478,'Retail Sale Id 1442927',7500.00,0.00,0.00,12.50,775.00,'2022-01-01 15:10:03','',''),(2419260,'1','201','1037',478,'Retail Sale Id 1442966',3600.00,0.00,0.00,6.00,372.00,'2022-01-01 15:17:40','',''),(2419270,'1','201','1037',478,'Retail Sale Id 1442972',2400.00,0.00,0.00,4.00,248.00,'2022-01-01 15:18:54','',''),(2419280,'1','201','1037',478,'Retail Sale Id 1442980',15000.00,0.00,0.00,25.00,1550.00,'2022-01-01 15:20:13','',''),(2419341,'1','201','1037',478,'Retail Sale Id 1443036',7500.00,0.00,0.00,12.50,775.00,'2022-01-01 15:31:10','',''),(2419372,'1','201','1037',478,'Retail Sale Id 1443052',7500.00,0.00,0.00,12.50,775.00,'2022-01-01 15:33:53','',''),(2419380,'1','201','1037',478,'Retail Sale Id 1443060',4800.00,0.00,0.00,8.00,496.00,'2022-01-01 15:35:54','',''),(2419384,'1','201','1037',478,'Retail Sale Id 1443065',4800.00,0.00,0.00,8.00,496.00,'2022-01-01 15:37:12','',''),(2419517,'1','201','1037',478,'Retail Sale Id 1443189',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 15:57:51','',''),(2419529,'1','201','1037',478,'Retail Sale Id 1443203',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 15:58:53','',''),(2419535,'1','201','1037',478,'Retail Sale Id 1443208',4800.00,0.00,0.00,8.00,496.00,'2022-01-01 15:59:54','',''),(2419546,'1','201','1037',478,'Retail Sale Id 1443218',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 16:01:39','',''),(2419562,'1','201','1037',478,'Retail Sale Id 1443234',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 16:03:35','',''),(2419596,'1','201','1037',478,'Retail Sale Id 1443261',7500.00,0.00,0.00,12.50,775.00,'2022-01-01 16:06:34','',''),(2419618,'1','201','1037',478,'Retail Sale Id 1443275',2100.00,0.00,0.00,3.50,217.00,'2022-01-01 16:08:13','',''),(2419630,'1','201','1037',478,'Retail Sale Id 1443286',3000.00,0.00,0.00,5.00,310.00,'2022-01-01 16:09:11','',''),(2419644,'1','201','1037',478,'Retail Sale Id 1443299',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 16:10:56','',''),(2419652,'1','201','1037',478,'Retail Sale Id 1443307',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 16:11:57','',''),(2419671,'1','201','1037',478,'Retail Sale Id 1443329',226000.00,0.00,0.00,400.00,10800.00,'2022-01-01 16:14:54','',''),(2419756,'1','201','1037',478,'Retail Sale Id 1443409',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 16:27:08','',''),(2419824,'1','201','1037',478,'Retail Sale Id 1443427',1200.00,0.00,0.00,2.00,124.00,'2022-01-01 16:30:11','',''),(2419858,'1','201','1037',478,'Retail Sale Id 1443436',4200.00,0.00,0.00,7.00,434.00,'2022-01-01 16:32:07','',''),(2419910,'1','201','1037',478,'Retail Sale Id 1443488',1800.00,0.00,0.00,3.00,186.00,'2022-01-01 16:41:30','',''),(2419929,'1','201','1037',478,'Retail Sale Id 1443507',4002.00,0.00,0.00,6.67,413.54,'2022-01-01 16:46:21','',''),(2419959,'1','201','1037',478,'Retail Sale Id 1443534',3600.00,0.00,0.00,6.00,372.00,'2022-01-01 16:53:31','',''),(2421075,'1','201','1037',478,'Retail Sale Id 1444051',4998.00,0.00,0.00,8.33,516.46,'2022-01-02 07:20:22','',''),(2421262,'1','201','1037',478,'Retail Sale Id 1444208',7500.00,0.00,0.00,12.50,775.00,'2022-01-02 07:46:15','',''),(2421276,'1','201','1037',478,'Retail Sale Id 1444221',600.00,0.00,0.00,1.00,62.00,'2022-01-02 07:48:18','',''),(2421298,'1','201','1037',478,'Retail Sale Id 1444253',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 07:52:29','',''),(2421307,'1','201','1037',478,'Retail Sale Id 1444264',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 07:53:22','',''),(2421318,'1','201','1037',478,'Retail Sale Id 1444274',7500.00,0.00,0.00,12.50,775.00,'2022-01-02 07:55:00','',''),(2421352,'1','201','1037',478,'Retail Sale Id 1444311',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 08:01:56','',''),(2421448,'1','201','1037',478,'Retail Sale Id 1444363',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 08:09:58','',''),(2421510,'1','201','1037',478,'Retail Sale Id 1444408',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 08:16:13','',''),(2421522,'1','201','1037',478,'Retail Sale Id 1444422',2400.00,0.00,0.00,4.00,248.00,'2022-01-02 08:17:38','',''),(2421702,'1','201','1037',478,'Retail Sale Id 1444595',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 08:40:43','',''),(2421742,'1','201','1037',478,'Retail Sale Id 1444633',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 08:45:49','',''),(2421761,'1','201','1037',478,'Retail Sale Id 1444651',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 08:49:14','',''),(2421816,'1','201','1037',478,'Retail Sale Id 1444709',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 08:57:07','',''),(2421818,'1','201','1037',478,'Retail Sale Id 1444711',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 08:57:58','',''),(2421823,'1','201','1037',478,'Retail Sale Id 1444717',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 08:58:52','',''),(2421892,'1','201','1037',478,'Retail Sale Id 1444785',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 09:09:09','',''),(2421923,'1','201','1037',478,'Retail Sale Id 1444817',4800.00,0.00,0.00,8.00,496.00,'2022-01-02 09:13:20','',''),(2421931,'1','201','1037',478,'Retail Sale Id 1444835',1002.00,0.00,0.00,1.67,103.54,'2022-01-02 09:14:39','',''),(2421932,'1','201','1037',478,'Retail Sale Id 1444835',1002.00,0.00,0.00,1.67,103.54,'2022-01-02 09:14:39','',''),(2421938,'1','201','1037',478,'Retail Sale Id 1444841',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 09:15:45','',''),(2422014,'1','201','1037',478,'Retail Sale Id 1444919',13110.00,0.00,0.00,23.00,736.00,'2022-01-02 09:25:56','',''),(2422052,'1','201','1037',478,'Retail Sale Id 1444946',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 09:30:42','',''),(2422088,'1','201','1037',478,'Retail Sale Id 1444961',7500.00,0.00,0.00,12.50,775.00,'2022-01-02 09:32:49','',''),(2422140,'1','201','1037',478,'Retail Sale Id 1445014',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 09:38:07','',''),(2422174,'1','201','1037',478,'Retail Sale Id 1445038',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 09:40:50','',''),(2422214,'1','201','1037',478,'Retail Sale Id 1445062',600.00,0.00,0.00,1.00,62.00,'2022-01-02 09:44:15','',''),(2422284,'1','201','1037',478,'Retail Sale Id 1445124',7200.00,0.00,0.00,12.00,744.00,'2022-01-02 09:52:44','',''),(2422287,'1','201','1037',478,'Retail Sale Id 1445130',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 09:53:44','',''),(2422314,'1','201','1037',478,'Retail Sale Id 1445154',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 09:57:32','',''),(2422345,'1','201','1037',478,'Retail Sale Id 1445188',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 10:01:59','',''),(2422354,'1','201','1037',478,'Retail Sale Id 1445199',114000.00,0.00,0.00,200.00,6400.00,'2022-01-02 10:03:54','',''),(2422426,'1','201','1037',478,'Retail Sale Id 1445267',28500.00,0.00,0.00,50.00,1600.00,'2022-01-02 10:11:43','',''),(2422440,'1','201','1037',478,'Retail Sale Id 1445279',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 10:13:42','',''),(2422524,'1','201','1037',478,'Retail Sale Id 1445342',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 10:21:34','',''),(2422631,'1','201','1037',478,'Retail Sale Id 1445421',600.00,0.00,0.00,1.00,62.00,'2022-01-02 10:31:08','',''),(2422783,'1','201','1037',478,'Retail Sale Id 1445573',1998.00,0.00,0.00,3.33,206.46,'2022-01-02 10:47:05','',''),(2422973,'1','201','1037',478,'Retail Sale Id 1445749',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 11:07:45','',''),(2423005,'1','201','1037',478,'Retail Sale Id 1445779',28500.00,0.00,0.00,50.00,1600.00,'2022-01-02 11:10:49','',''),(2423023,'1','201','1037',478,'Retail Sale Id 1445792',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 11:12:28','',''),(2423036,'1','201','1037',478,'Retail Sale Id 1445807',7500.00,0.00,0.00,12.50,775.00,'2022-01-02 11:14:10','',''),(2423089,'1','201','1037',478,'Retail Sale Id 1445859',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 11:19:23','',''),(2423128,'1','201','1037',478,'Retail Sale Id 1445898',7500.00,0.00,0.00,12.50,775.00,'2022-01-02 11:22:54','',''),(2423133,'1','201','1037',478,'Retail Sale Id 1445905',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 11:23:43','',''),(2423193,'1','201','1037',478,'Retail Sale Id 1445969',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 11:29:34','',''),(2423200,'1','201','1037',478,'Retail Sale Id 1445977',7500.00,0.00,0.00,12.50,775.00,'2022-01-02 11:30:34','',''),(2423234,'1','201','1037',478,'Retail Sale Id 1446010',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 11:33:51','',''),(2423249,'1','201','1037',478,'Retail Sale Id 1446025',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 11:35:46','',''),(2423268,'1','201','1037',478,'Retail Sale Id 1446047',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 11:37:48','',''),(2423279,'1','201','1037',478,'Retail Sale Id 1446057',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 11:39:32','',''),(2423311,'1','201','1037',478,'Retail Sale Id 1446087',28500.00,0.00,0.00,50.00,1600.00,'2022-01-02 11:43:16','',''),(2423362,'1','201','1037',478,'Retail Sale Id 1446140',6498.00,0.00,0.00,10.83,671.46,'2022-01-02 11:49:50','',''),(2423454,'1','201','1037',478,'Retail Sale Id 1446223',600.00,0.00,0.00,1.00,62.00,'2022-01-02 12:02:46','',''),(2423545,'1','201','1037',478,'Retail Sale Id 1446322',2100.00,0.00,0.00,3.50,217.00,'2022-01-02 12:16:13','',''),(2423737,'1','201','1037',478,'Retail Sale Id 1446516',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 12:39:26','',''),(2423752,'1','201','1037',478,'Retail Sale Id 1446536',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 12:40:48','',''),(2423811,'1','201','1037',478,'Retail Sale Id 1446598',2100.00,0.00,0.00,3.50,217.00,'2022-01-02 12:47:31','',''),(2423822,'1','201','1037',478,'Retail Sale Id 1446609',5400.00,0.00,0.00,9.00,558.00,'2022-01-02 12:49:02','',''),(2423834,'1','201','1037',478,'Retail Sale Id 1446621',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 12:50:43','',''),(2423867,'1','201','1037',478,'Retail Sale Id 1446656',2400.00,0.00,0.00,4.00,248.00,'2022-01-02 12:54:44','',''),(2423879,'1','201','1037',478,'Retail Sale Id 1446669',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 12:55:40','',''),(2423897,'1','201','1037',478,'Retail Sale Id 1446689',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 12:58:05','',''),(2423941,'1','201','1037',478,'Retail Sale Id 1446742',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 13:04:36','',''),(2424039,'1','201','1037',478,'Retail Sale Id 1446826',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 13:17:18','',''),(2424113,'1','201','1037',478,'Retail Sale Id 1446899',4200.00,0.00,0.00,7.00,434.00,'2022-01-02 13:27:58','',''),(2424159,'1','201','1037',478,'Retail Sale Id 1446949',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 13:34:20','',''),(2424177,'1','201','1037',478,'Retail Sale Id 1446974',2400.00,0.00,0.00,4.00,248.00,'2022-01-02 13:37:20','',''),(2424234,'1','201','1037',478,'Retail Sale Id 1447028',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 13:45:09','',''),(2424282,'1','201','1037',478,'Retail Sale Id 1447073',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 13:51:50','',''),(2424379,'1','201','1037',478,'Retail Sale Id 1447125',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 14:01:05','',''),(2424389,'1','201','1037',478,'Retail Sale Id 1447134',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 14:02:11','',''),(2424398,'1','201','1037',478,'Retail Sale Id 1447143',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 14:03:10','',''),(2424578,'1','201','1037',478,'Retail Sale Id 1447252',7500.00,0.00,0.00,12.50,775.00,'2022-01-02 14:17:44','',''),(2424609,'1','201','1037',478,'Retail Sale Id 1447265',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 14:19:08','',''),(2424636,'1','201','1037',478,'Retail Sale Id 1447277',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 14:20:22','',''),(2424714,'1','201','1037',478,'Retail Sale Id 1447343',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 14:29:24','',''),(2424738,'1','201','1037',478,'Retail Sale Id 1447355',1602.00,0.00,0.00,2.67,165.54,'2022-01-02 14:31:10','',''),(2424746,'1','201','1037',478,'Retail Sale Id 1447363',198.00,0.00,0.00,0.33,20.46,'2022-01-02 14:32:27','',''),(2424753,'1','201','1037',478,'Retail Sale Id 1447371',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 14:33:22','',''),(2424785,'1','201','1037',478,'Retail Sale Id 1447401',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 14:36:06','',''),(2424786,'1','201','1037',478,'Retail Sale Id 1447401',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 14:36:06','',''),(2424787,'1','201','1037',478,'Retail Sale Id 1447401',2400.00,0.00,0.00,4.00,248.00,'2022-01-02 14:36:06','',''),(2424788,'1','201','1037',478,'Retail Sale Id 1447401',7500.00,0.00,0.00,12.50,775.00,'2022-01-02 14:36:06','',''),(2424850,'1','201','1037',478,'Retail Sale Id 1447466',7800.00,0.00,0.00,13.00,806.00,'2022-01-02 14:45:07','',''),(2424859,'1','201','1037',478,'Retail Sale Id 1447474',1998.00,0.00,0.00,3.33,206.46,'2022-01-02 14:46:32','',''),(2424874,'1','201','1037',478,'Retail Sale Id 1447489',4200.00,0.00,0.00,7.00,434.00,'2022-01-02 14:49:13','',''),(2424883,'1','201','1037',478,'Retail Sale Id 1447494',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 14:51:09','',''),(2424887,'1','201','1037',478,'Retail Sale Id 1447501',1998.00,0.00,0.00,3.33,206.46,'2022-01-02 14:52:23','',''),(2424890,'1','201','1037',478,'Retail Sale Id 1447504',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 14:53:21','',''),(2424921,'1','201','1037',478,'Retail Sale Id 1447531',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 14:57:04','',''),(2425022,'1','201','1037',478,'Retail Sale Id 1447591',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 15:04:31','',''),(2425026,'1','201','1037',478,'Retail Sale Id 1447594',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 15:05:44','',''),(2425032,'1','201','1037',478,'Retail Sale Id 1447600',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 15:06:46','',''),(2425038,'1','201','1037',478,'Retail Sale Id 1447610',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 15:07:41','',''),(2425173,'1','201','1037',478,'Retail Sale Id 1447750',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 15:32:17','',''),(2425187,'1','201','1037',478,'Retail Sale Id 1447764',4200.00,0.00,0.00,7.00,434.00,'2022-01-02 15:34:18','',''),(2425255,'1','201','1037',478,'Retail Sale Id 1447834',1002.00,0.00,0.00,1.67,103.54,'2022-01-02 15:44:36','',''),(2425265,'1','201','1037',478,'Retail Sale Id 1447843',1002.00,0.00,0.00,1.67,103.54,'2022-01-02 15:45:47','',''),(2425277,'1','201','1037',478,'Retail Sale Id 1447855',7500.00,0.00,0.00,12.50,775.00,'2022-01-02 15:47:57','',''),(2425302,'1','201','1037',478,'Retail Sale Id 1447876',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 15:51:04','',''),(2425324,'1','201','1037',478,'Retail Sale Id 1447890',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 15:52:50','',''),(2425334,'1','201','1037',478,'Retail Sale Id 1447899',7500.00,0.00,0.00,12.50,775.00,'2022-01-02 15:54:18','',''),(2425345,'1','201','1037',478,'Retail Sale Id 1447907',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 15:55:21','',''),(2425361,'1','201','1037',478,'Retail Sale Id 1447917',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 15:56:34','',''),(2425423,'1','201','1037',478,'Retail Sale Id 1447979',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 16:05:57','',''),(2425430,'1','201','1037',478,'Retail Sale Id 1447986',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 16:06:47','',''),(2425462,'1','201','1037',478,'Retail Sale Id 1447990',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 16:07:41','',''),(2425470,'1','201','1037',478,'Retail Sale Id 1448000',4200.00,0.00,0.00,7.00,434.00,'2022-01-02 16:08:37','',''),(2425518,'1','201','1037',478,'Retail Sale Id 1448067',1200.00,0.00,0.00,2.00,124.00,'2022-01-02 16:14:57','',''),(2425548,'1','201','1037',478,'Retail Sale Id 1448100',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 16:18:35','',''),(2425564,'1','201','1037',478,'Retail Sale Id 1448113',3000.00,0.00,0.00,5.00,310.00,'2022-01-02 16:20:21','',''),(2425714,'1','201','1037',478,'Retail Sale Id 1448221',1398.00,0.00,0.00,2.33,144.46,'2022-01-02 16:42:30','',''),(2425757,'1','201','1037',478,'Retail Sale Id 1448263',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 16:52:11','',''),(2425811,'1','201','1037',478,'Retail Sale Id 1448317',8002.80,0.00,0.00,14.04,449.28,'2022-01-02 17:07:03','',''),(2425815,'1','201','1037',478,'Retail Sale Id 1448321',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 17:08:00','',''),(2425822,'1','201','1037',478,'Retail Sale Id 1448329',3600.00,0.00,0.00,6.00,372.00,'2022-01-02 17:09:53','',''),(2425834,'1','201','1037',478,'Retail Sale Id 1448404',1800.00,0.00,0.00,3.00,186.00,'2022-01-02 17:19:09','',''),(2426710,'1','201','1037',478,'Retail Sale Id 1448807',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 07:22:18','',''),(2426731,'1','201','1037',478,'Retail Sale Id 1448831',7500.00,0.00,0.00,12.50,775.00,'2022-01-03 07:25:53','',''),(2427036,'1','201','1037',478,'Retail Sale Id 1449066',28500.00,0.00,0.00,50.00,1600.00,'2022-01-03 07:59:12','',''),(2427087,'1','201','1037',478,'Retail Sale Id 1449115',2100.00,0.00,0.00,3.50,217.00,'2022-01-03 08:07:29','',''),(2427150,'1','201','1037',478,'Retail Sale Id 1449179',7500.00,0.00,0.00,12.50,775.00,'2022-01-03 08:17:00','',''),(2427151,'1','201','1037',478,'Retail Sale Id 1449179',7500.00,0.00,0.00,12.50,775.00,'2022-01-03 08:17:00','',''),(2427223,'1','201','1037',478,'Retail Sale Id 1449250',7500.00,0.00,0.00,12.50,775.00,'2022-01-03 08:26:51','',''),(2427228,'1','201','1037',478,'Retail Sale Id 1449256',600.00,0.00,0.00,1.00,62.00,'2022-01-03 08:27:40','',''),(2427292,'1','201','1037',478,'Retail Sale Id 1449314',2502.00,0.00,0.00,4.17,258.54,'2022-01-03 08:36:06','',''),(2427473,'1','201','1037',478,'Retail Sale Id 1449497',4800.00,0.00,0.00,8.00,496.00,'2022-01-03 08:54:18','',''),(2427567,'1','201','1037',478,'Retail Sale Id 1449560',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 09:00:49','',''),(2427716,'1','201','1037',478,'Retail Sale Id 1449699',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 09:17:29','',''),(2427806,'1','201','1037',478,'Retail Sale Id 1449789',6498.00,0.00,0.00,10.83,671.46,'2022-01-03 09:28:13','',''),(2427807,'1','201','1037',478,'Retail Sale Id 1449789',6498.00,0.00,0.00,10.83,671.46,'2022-01-03 09:28:13','',''),(2427827,'1','201','1037',478,'Retail Sale Id 1449813',2400.00,0.00,0.00,4.00,248.00,'2022-01-03 09:31:00','',''),(2427848,'1','201','1037',478,'Retail Sale Id 1449827',4998.00,0.00,0.00,8.33,516.46,'2022-01-03 09:33:33','',''),(2427869,'1','201','1037',478,'Retail Sale Id 1449848',2400.00,0.00,0.00,4.00,248.00,'2022-01-03 09:35:03','',''),(2427921,'1','201','1037',478,'Retail Sale Id 1449915',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 09:43:05','',''),(2427945,'1','201','1037',478,'Retail Sale Id 1449936',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 09:45:51','',''),(2427989,'1','201','1037',478,'Retail Sale Id 1449978',2400.00,0.00,0.00,4.00,248.00,'2022-01-03 09:50:26','',''),(2428114,'1','201','1037',478,'Retail Sale Id 1450100',2400.00,0.00,0.00,4.00,248.00,'2022-01-03 10:05:21','',''),(2428124,'1','201','1037',478,'Retail Sale Id 1450111',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 10:06:40','',''),(2428125,'1','201','1037',478,'Retail Sale Id 1450111',7500.00,0.00,0.00,12.50,775.00,'2022-01-03 10:06:40','',''),(2428138,'1','201','1037',478,'Retail Sale Id 1450119',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 10:07:38','',''),(2428162,'1','201','1037',478,'Retail Sale Id 1450145',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 10:10:31','',''),(2428163,'1','201','1037',478,'Retail Sale Id 1450145',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 10:10:31','',''),(2428164,'1','201','1037',478,'Retail Sale Id 1450145',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 10:10:31','',''),(2428181,'1','201','1037',478,'Retail Sale Id 1450163',7200.00,0.00,0.00,12.00,744.00,'2022-01-03 10:12:47','',''),(2428235,'1','201','1037',478,'Retail Sale Id 1450199',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 10:19:00','',''),(2428284,'1','201','1037',478,'Retail Sale Id 1450245',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 10:25:26','',''),(2428365,'1','201','1037',478,'Retail Sale Id 1450325',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 10:33:53','',''),(2428449,'1','201','1037',478,'Retail Sale Id 1450407',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 10:43:06','',''),(2428458,'1','201','1037',478,'Retail Sale Id 1450416',2400.00,0.00,0.00,4.00,248.00,'2022-01-03 10:44:09','',''),(2428616,'1','201','1037',478,'Retail Sale Id 1450569',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 11:05:02','',''),(2428626,'1','201','1037',478,'Retail Sale Id 1450582',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 11:05:59','',''),(2428638,'1','201','1037',478,'Retail Sale Id 1450592',6000.00,0.00,0.00,10.00,620.00,'2022-01-03 11:07:03','',''),(2428644,'1','201','1037',478,'Retail Sale Id 1450597',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 11:08:12','',''),(2428719,'1','201','1037',478,'Retail Sale Id 1450670',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 11:17:28','',''),(2428768,'1','201','1037',478,'Retail Sale Id 1450703',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 11:21:27','',''),(2428796,'1','201','1037',478,'Retail Sale Id 1450732',1998.00,0.00,0.00,3.33,206.46,'2022-01-03 11:25:30','',''),(2428849,'1','201','1037',478,'Retail Sale Id 1450777',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 11:31:11','',''),(2428860,'1','201','1037',478,'Retail Sale Id 1450786',600.00,0.00,0.00,1.00,62.00,'2022-01-03 11:32:25','',''),(2428874,'1','201','1037',478,'Retail Sale Id 1450801',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 11:34:35','',''),(2428918,'1','201','1037',478,'Retail Sale Id 1450830',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 11:40:05','',''),(2428926,'1','201','1037',478,'Retail Sale Id 1450837',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 11:41:05','',''),(2429021,'1','201','1037',478,'Retail Sale Id 1450930',900.00,0.00,0.00,1.50,93.00,'2022-01-03 11:53:52','',''),(2429044,'1','201','1037',478,'Retail Sale Id 1450953',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 11:56:20','',''),(2429085,'1','201','1037',478,'Retail Sale Id 1450991',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 12:00:50','',''),(2429093,'1','201','1037',478,'Retail Sale Id 1451000',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 12:01:40','',''),(2429191,'1','201','1037',478,'Retail Sale Id 1451093',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 12:17:28','',''),(2429202,'1','201','1037',478,'Retail Sale Id 1451106',2400.00,0.00,0.00,4.00,248.00,'2022-01-03 12:18:35','',''),(2429274,'1','201','1037',478,'Retail Sale Id 1451175',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 12:27:57','',''),(2429283,'1','201','1037',478,'Retail Sale Id 1451183',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 12:29:10','',''),(2429291,'1','201','1037',478,'Retail Sale Id 1451192',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 12:30:05','',''),(2429349,'1','201','1037',478,'Retail Sale Id 1451241',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 12:36:43','',''),(2429350,'1','201','1037',478,'Retail Sale Id 1451241',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 12:36:43','',''),(2429487,'1','201','1037',478,'Retail Sale Id 1451360',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 12:53:49','',''),(2429546,'1','201','1037',478,'Retail Sale Id 1451413',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 13:01:51','',''),(2429597,'1','201','1037',478,'Retail Sale Id 1451461',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 13:07:48','',''),(2429665,'1','201','1037',478,'Retail Sale Id 1451530',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 13:13:15','',''),(2429716,'1','201','1037',478,'Retail Sale Id 1451568',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 13:17:58','',''),(2429964,'1','201','1037',478,'Retail Sale Id 1451773',7002.00,0.00,0.00,11.67,723.54,'2022-01-03 13:38:26','',''),(2430007,'1','201','1037',478,'Retail Sale Id 1451790',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 13:40:42','',''),(2430008,'1','201','1037',478,'Retail Sale Id 1451790',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 13:40:42','',''),(2430009,'1','201','1037',478,'Retail Sale Id 1451790',7500.00,0.00,0.00,12.50,775.00,'2022-01-03 13:40:42','',''),(2430231,'1','201','1037',478,'Retail Sale Id 1451894',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 13:57:46','',''),(2430248,'1','201','1037',478,'Retail Sale Id 1451968',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 13:58:44','',''),(2430264,'1','201','1037',478,'Retail Sale Id 1451983',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 14:00:02','',''),(2430462,'1','201','1037',478,'Retail Sale Id 1452110',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 14:15:39','',''),(2430478,'1','201','1037',478,'Retail Sale Id 1452119',4800.00,0.00,0.00,8.00,496.00,'2022-01-03 14:16:55','',''),(2430528,'1','201','1037',478,'Retail Sale Id 1452138',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 14:19:11','',''),(2430576,'1','201','1037',478,'Retail Sale Id 1452191',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 14:26:49','',''),(2430603,'1','201','1037',478,'Retail Sale Id 1452216',600.00,0.00,0.00,1.00,62.00,'2022-01-03 14:30:25','',''),(2430680,'1','201','1037',478,'Retail Sale Id 1452295',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 14:40:05','',''),(2430681,'1','201','1037',478,'Retail Sale Id 1452295',4200.00,0.00,0.00,7.00,434.00,'2022-01-03 14:40:05','',''),(2430700,'1','201','1037',478,'Retail Sale Id 1452313',7500.00,0.00,0.00,12.50,775.00,'2022-01-03 14:41:48','',''),(2430839,'1','201','1037',478,'Retail Sale Id 1452380',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 14:48:44','',''),(2430857,'1','201','1037',478,'Retail Sale Id 1452395',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 14:51:04','',''),(2430875,'1','201','1037',478,'Retail Sale Id 1452411',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 14:53:03','',''),(2430903,'1','201','1037',478,'Retail Sale Id 1452431',7200.00,0.00,0.00,12.00,744.00,'2022-01-03 14:55:23','',''),(2430923,'1','201','1037',478,'Retail Sale Id 1452451',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 14:57:31','',''),(2430939,'1','201','1037',478,'Retail Sale Id 1452465',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 14:59:42','',''),(2430959,'1','201','1037',478,'Retail Sale Id 1452486',85500.00,0.00,0.00,150.00,4800.00,'2022-01-03 15:02:29','',''),(2431020,'1','201','1037',478,'Retail Sale Id 1452545',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 15:09:17','',''),(2431194,'1','201','1037',478,'Retail Sale Id 1452645',4200.00,0.00,0.00,7.00,434.00,'2022-01-03 15:21:24','',''),(2431220,'1','201','1037',478,'Retail Sale Id 1452660',7200.00,0.00,0.00,12.00,744.00,'2022-01-03 15:22:59','',''),(2431257,'1','201','1037',478,'Retail Sale Id 1452684',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 15:26:25','',''),(2431302,'1','201','1037',478,'Retail Sale Id 1452729',1002.00,0.00,0.00,1.67,103.54,'2022-01-03 15:32:18','',''),(2431318,'1','201','1037',478,'Retail Sale Id 1452745',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 15:34:26','',''),(2431346,'1','201','1037',478,'Retail Sale Id 1452773',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 15:37:28','',''),(2431359,'1','201','1037',478,'Retail Sale Id 1452785',2400.00,0.00,0.00,4.00,248.00,'2022-01-03 15:38:35','',''),(2431417,'1','201','1037',478,'Retail Sale Id 1452841',11400.00,0.00,0.00,20.00,640.00,'2022-01-03 15:42:59','',''),(2431436,'1','201','1037',478,'Retail Sale Id 1452864',2502.00,0.00,0.00,4.17,258.54,'2022-01-03 15:44:39','',''),(2431523,'1','201','1037',478,'Retail Sale Id 1452950',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 15:53:12','',''),(2431531,'1','201','1037',478,'Retail Sale Id 1452958',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 15:54:05','',''),(2431545,'1','201','1037',478,'Retail Sale Id 1452968',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 15:55:08','',''),(2431654,'1','201','1037',478,'Retail Sale Id 1453077',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 16:04:55','',''),(2431668,'1','201','1037',478,'Retail Sale Id 1453091',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 16:06:14','',''),(2431700,'1','201','1037',478,'Retail Sale Id 1453122',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 16:09:31','',''),(2431720,'1','201','1037',478,'Retail Sale Id 1453141',3420.00,0.00,0.00,6.00,192.00,'2022-01-03 16:11:11','',''),(2431833,'1','201','1037',478,'Retail Sale Id 1453245',3600.00,0.00,0.00,6.00,372.00,'2022-01-03 16:21:53','',''),(2431890,'1','201','1037',478,'Retail Sale Id 1453314',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 16:27:03','',''),(2431965,'1','201','1037',478,'Retail Sale Id 1453378',4200.00,0.00,0.00,7.00,434.00,'2022-01-03 16:33:19','',''),(2432003,'1','201','1037',478,'Retail Sale Id 1453409',1500.00,0.00,0.00,2.50,155.00,'2022-01-03 16:37:15','',''),(2432055,'1','201','1037',478,'Retail Sale Id 1453454',1998.00,0.00,0.00,3.33,206.46,'2022-01-03 16:42:37','',''),(2432069,'1','201','1037',478,'Retail Sale Id 1453463',3000.00,0.00,0.00,5.00,310.00,'2022-01-03 16:44:53','',''),(2432168,'1','201','1037',478,'Retail Sale Id 1453551',1800.00,0.00,0.00,3.00,186.00,'2022-01-03 16:58:32','',''),(2432181,'1','201','1037',478,'Retail Sale Id 1453559',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 16:59:47','',''),(2432188,'1','201','1037',478,'Retail Sale Id 1453566',1200.00,0.00,0.00,2.00,124.00,'2022-01-03 17:00:40','',''),(2432199,'1','201','1037',478,'Retail Sale Id 1453575',22800.00,0.00,0.00,40.00,1280.00,'2022-01-03 17:02:10','',''),(2432221,'1','201','1037',478,'Retail Sale Id 1453596',8002.80,0.00,0.00,14.04,449.28,'2022-01-03 17:05:28','',''),(2433303,'1','201','1037',478,'Retail Sale Id 1454000',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 07:10:26','',''),(2433490,'1','201','1037',478,'Retail Sale Id 1454177',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 07:32:42','',''),(2433519,'1','201','1037',478,'Retail Sale Id 1454209',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 07:36:07','',''),(2433731,'1','201','1037',478,'Retail Sale Id 1454420',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 08:00:16','',''),(2433755,'1','201','1037',478,'Retail Sale Id 1454446',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 08:03:11','',''),(2433836,'1','201','1037',478,'Retail Sale Id 1454496',600.00,0.00,0.00,1.00,62.00,'2022-01-04 08:10:24','',''),(2433912,'1','201','1037',478,'Retail Sale Id 1454569',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 08:18:08','',''),(2434025,'1','201','1037',478,'Retail Sale Id 1454614',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 08:24:09','',''),(2434029,'1','201','1037',478,'Retail Sale Id 1454661',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 08:25:01','',''),(2434037,'1','201','1037',478,'Retail Sale Id 1454668',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 08:26:06','',''),(2434242,'1','201','1037',478,'Retail Sale Id 1454806',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 08:42:09','',''),(2434252,'1','201','1037',478,'Retail Sale Id 1454816',4800.00,0.00,0.00,8.00,496.00,'2022-01-04 08:43:14','',''),(2434262,'1','201','1037',478,'Retail Sale Id 1454830',2400.00,0.00,0.00,4.00,248.00,'2022-01-04 08:44:36','',''),(2434287,'1','201','1037',478,'Retail Sale Id 1454849',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 08:46:44','',''),(2434357,'1','201','1037',478,'Retail Sale Id 1454920',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 08:54:28','',''),(2434446,'1','201','1037',478,'Retail Sale Id 1455009',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 09:03:57','',''),(2434562,'1','201','1037',478,'Retail Sale Id 1455136',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 09:16:29','',''),(2434629,'1','201','1037',478,'Retail Sale Id 1455198',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 09:24:36','',''),(2434645,'1','201','1037',478,'Retail Sale Id 1455215',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 09:26:47','',''),(2434663,'1','201','1037',478,'Retail Sale Id 1455232',2502.00,0.00,0.00,4.17,258.54,'2022-01-04 09:28:32','',''),(2434821,'1','201','1037',478,'Retail Sale Id 1455325',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 09:37:13','',''),(2434852,'1','201','1037',478,'Retail Sale Id 1455357',1500.00,0.00,0.00,2.50,155.00,'2022-01-04 09:40:45','',''),(2434861,'1','201','1037',478,'Retail Sale Id 1455365',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 09:41:40','',''),(2434959,'1','201','1037',478,'Retail Sale Id 1455458',4200.00,0.00,0.00,7.00,434.00,'2022-01-04 09:51:42','',''),(2434988,'1','201','1037',478,'Retail Sale Id 1455475',2100.00,0.00,0.00,3.50,217.00,'2022-01-04 09:53:24','',''),(2435113,'1','201','1037',478,'Retail Sale Id 1455596',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 10:08:30','',''),(2435139,'1','201','1037',478,'Retail Sale Id 1455621',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 10:11:49','',''),(2435162,'1','201','1037',478,'Retail Sale Id 1455631',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 10:13:09','',''),(2435174,'1','201','1037',478,'Retail Sale Id 1455644',2400.00,0.00,0.00,4.00,248.00,'2022-01-04 10:14:02','',''),(2435341,'1','201','1037',478,'Retail Sale Id 1455764',4200.00,0.00,0.00,7.00,434.00,'2022-01-04 10:29:08','',''),(2435532,'1','201','1037',478,'Retail Sale Id 1455941',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 10:44:26','',''),(2435543,'1','201','1037',478,'Retail Sale Id 1455950',11400.00,0.00,0.00,20.00,640.00,'2022-01-04 10:45:46','',''),(2435591,'1','201','1037',478,'Retail Sale Id 1455987',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 10:49:51','',''),(2435605,'1','201','1037',478,'Retail Sale Id 1456002',4200.00,0.00,0.00,7.00,434.00,'2022-01-04 10:51:06','',''),(2435613,'1','201','1037',478,'Retail Sale Id 1456015',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 10:52:25','',''),(2435704,'1','201','1037',478,'Retail Sale Id 1456107',2400.00,0.00,0.00,4.00,248.00,'2022-01-04 11:00:54','',''),(2435927,'1','201','1037',478,'Retail Sale Id 1456317',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 11:21:36','',''),(2435982,'1','201','1037',478,'Retail Sale Id 1456350',57000.00,0.00,0.00,100.00,3200.00,'2022-01-04 11:24:32','',''),(2435996,'1','201','1037',478,'Retail Sale Id 1456362',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 11:25:53','',''),(2436012,'1','201','1037',478,'Retail Sale Id 1456382',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 11:27:28','',''),(2436031,'1','201','1037',478,'Retail Sale Id 1456399',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 11:29:19','',''),(2436041,'1','201','1037',478,'Retail Sale Id 1456409',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 11:30:30','',''),(2436069,'1','201','1037',478,'Retail Sale Id 1456439',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 11:33:19','',''),(2436086,'1','201','1037',478,'Retail Sale Id 1456450',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 11:34:57','',''),(2436122,'1','201','1037',478,'Retail Sale Id 1456487',7200.00,0.00,0.00,12.00,744.00,'2022-01-04 11:38:36','',''),(2436210,'1','201','1037',478,'Retail Sale Id 1456565',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 11:47:43','',''),(2436258,'1','201','1037',478,'Retail Sale Id 1456609',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 11:52:01','',''),(2436347,'1','201','1037',478,'Retail Sale Id 1456712',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 12:01:42','',''),(2436381,'1','201','1037',478,'Retail Sale Id 1456746',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 12:05:29','',''),(2436387,'1','201','1037',478,'Retail Sale Id 1456754',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 12:06:19','',''),(2436480,'1','201','1037',478,'Retail Sale Id 1456851',1002.00,0.00,0.00,1.67,103.54,'2022-01-04 12:17:14','',''),(2436532,'1','201','1037',478,'Retail Sale Id 1456906',4800.00,0.00,0.00,8.00,496.00,'2022-01-04 12:24:35','',''),(2436537,'1','201','1037',478,'Retail Sale Id 1456910',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 12:25:25','',''),(2436547,'1','201','1037',478,'Retail Sale Id 1456919',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 12:26:35','',''),(2436553,'1','201','1037',478,'Retail Sale Id 1456925',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 12:27:25','',''),(2436658,'1','201','1037',478,'Retail Sale Id 1457032',85500.00,0.00,0.00,150.00,4800.00,'2022-01-04 12:37:42','',''),(2436674,'1','201','1037',478,'Retail Sale Id 1457043',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 12:39:09','',''),(2436675,'1','201','1037',478,'Retail Sale Id 1457043',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 12:39:09','',''),(2436686,'1','201','1037',478,'Retail Sale Id 1457056',4200.00,0.00,0.00,7.00,434.00,'2022-01-04 12:39:57','',''),(2436695,'1','201','1037',478,'Retail Sale Id 1457070',1998.00,0.00,0.00,3.33,206.46,'2022-01-04 12:41:00','',''),(2436708,'1','201','1037',478,'Retail Sale Id 1457083',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 12:41:52','',''),(2436722,'1','201','1037',478,'Retail Sale Id 1457096',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 12:43:07','',''),(2436723,'1','201','1037',478,'Retail Sale Id 1457096',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 12:43:07','',''),(2436732,'1','201','1037',478,'Retail Sale Id 1457105',6000.00,0.00,0.00,10.00,620.00,'2022-01-04 12:44:02','',''),(2436759,'1','201','1037',478,'Retail Sale Id 1457135',7200.00,0.00,0.00,12.00,744.00,'2022-01-04 12:48:23','',''),(2436855,'1','201','1037',478,'Retail Sale Id 1457220',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 12:59:51','',''),(2436879,'1','201','1037',478,'Retail Sale Id 1457243',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 13:02:28','',''),(2436892,'1','201','1037',478,'Retail Sale Id 1457253',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 13:03:25','',''),(2437069,'1','201','1037',478,'Retail Sale Id 1457388',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 13:21:26','',''),(2437092,'1','201','1037',478,'Retail Sale Id 1457413',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 13:24:08','',''),(2437135,'1','201','1037',478,'Retail Sale Id 1457476',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 13:30:20','',''),(2437158,'1','201','1037',478,'Retail Sale Id 1457553',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 13:31:32','',''),(2437337,'1','201','1037',478,'Retail Sale Id 1457680',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 13:42:23','',''),(2437368,'1','201','1037',478,'Retail Sale Id 1457699',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 13:44:45','',''),(2437502,'1','201','1037',478,'Retail Sale Id 1457799',2400.00,0.00,0.00,4.00,248.00,'2022-01-04 13:55:38','',''),(2437606,'1','201','1037',478,'Retail Sale Id 1457913',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 14:06:52','',''),(2437644,'1','201','1037',478,'Retail Sale Id 1457934',2202.00,0.00,0.00,3.67,227.54,'2022-01-04 14:09:15','',''),(2437675,'1','201','1037',478,'Retail Sale Id 1457952',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 14:11:11','',''),(2437778,'1','201','1037',478,'Retail Sale Id 1458013',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 14:18:34','',''),(2437942,'1','201','1037',478,'Retail Sale Id 1458128',2400.00,0.00,0.00,4.00,248.00,'2022-01-04 14:33:31','',''),(2438006,'1','201','1037',478,'Retail Sale Id 1458185',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 14:40:07','',''),(2438064,'1','201','1037',478,'Retail Sale Id 1458228',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 14:43:56','',''),(2438084,'1','201','1037',478,'Retail Sale Id 1458238',5400.00,0.00,0.00,9.00,558.00,'2022-01-04 14:45:09','',''),(2438168,'1','201','1037',478,'Retail Sale Id 1458294',1998.00,0.00,0.00,3.33,206.46,'2022-01-04 14:51:12','',''),(2438183,'1','201','1037',478,'Retail Sale Id 1458307',7200.00,0.00,0.00,12.00,744.00,'2022-01-04 14:52:34','',''),(2438202,'1','201','1037',478,'Retail Sale Id 1458327',4200.00,0.00,0.00,7.00,434.00,'2022-01-04 14:54:49','',''),(2438212,'1','201','1037',478,'Retail Sale Id 1458339',600.00,0.00,0.00,1.00,62.00,'2022-01-04 14:56:09','',''),(2438213,'1','201','1037',478,'Retail Sale Id 1458339',600.00,0.00,0.00,1.00,62.00,'2022-01-04 14:56:09','',''),(2438405,'1','201','1037',478,'Retail Sale Id 1458461',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 15:07:02','',''),(2438415,'1','201','1037',478,'Retail Sale Id 1458470',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 15:08:04','',''),(2438610,'1','201','1037',478,'Retail Sale Id 1458655',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 15:23:44','',''),(2438645,'1','201','1037',478,'Retail Sale Id 1458684',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 15:26:32','',''),(2438672,'1','201','1037',478,'Retail Sale Id 1458702',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 15:28:45','',''),(2438689,'1','201','1037',478,'Retail Sale Id 1458722',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 15:32:05','',''),(2438764,'1','201','1037',478,'Retail Sale Id 1458806',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 15:40:03','',''),(2438837,'1','201','1037',478,'Retail Sale Id 1458875',2400.00,0.00,0.00,4.00,248.00,'2022-01-04 15:46:09','',''),(2438876,'1','201','1037',478,'Retail Sale Id 1458907',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 15:48:52','',''),(2438887,'1','201','1037',478,'Retail Sale Id 1458919',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 15:50:01','',''),(2438910,'1','201','1037',478,'Retail Sale Id 1458928',600.00,0.00,0.00,1.00,62.00,'2022-01-04 15:51:03','',''),(2439016,'1','201','1037',478,'Retail Sale Id 1459005',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 15:58:50','',''),(2439038,'1','201','1037',478,'Retail Sale Id 1459024',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 16:00:53','',''),(2439047,'1','201','1037',478,'Retail Sale Id 1459036',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 16:01:59','',''),(2439069,'1','201','1037',478,'Retail Sale Id 1459056',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 16:04:28','',''),(2439070,'1','201','1037',478,'Retail Sale Id 1459056',3600.00,0.00,0.00,6.00,372.00,'2022-01-04 16:04:28','',''),(2439133,'1','201','1037',478,'Retail Sale Id 1459113',900.00,0.00,0.00,1.50,93.00,'2022-01-04 16:09:39','',''),(2439137,'1','201','1037',478,'Retail Sale Id 1459118',600.00,0.00,0.00,1.00,62.00,'2022-01-04 16:10:16','',''),(2439159,'1','201','1037',478,'Retail Sale Id 1459136',7980.00,0.00,0.00,14.00,448.00,'2022-01-04 16:11:35','',''),(2439173,'1','201','1037',478,'Retail Sale Id 1459149',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 16:12:37','',''),(2439250,'1','201','1037',478,'Retail Sale Id 1459227',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 16:19:25','',''),(2439271,'1','201','1037',478,'Retail Sale Id 1459251',2400.00,0.00,0.00,4.00,248.00,'2022-01-04 16:21:59','',''),(2439285,'1','201','1037',478,'Retail Sale Id 1459267',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 16:23:47','',''),(2439319,'1','201','1037',478,'Retail Sale Id 1459302',4200.00,0.00,0.00,7.00,434.00,'2022-01-04 16:27:00','',''),(2439350,'1','201','1037',478,'Retail Sale Id 1459338',1800.00,0.00,0.00,3.00,186.00,'2022-01-04 16:30:03','',''),(2439462,'1','201','1037',478,'Retail Sale Id 1459461',1500.00,0.00,0.00,2.50,155.00,'2022-01-04 16:43:23','',''),(2439481,'1','201','1037',478,'Retail Sale Id 1459479',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 16:45:19','',''),(2439568,'1','201','1037',478,'Retail Sale Id 1459565',7500.00,0.00,0.00,12.50,775.00,'2022-01-04 16:58:25','',''),(2439578,'1','201','1037',478,'Retail Sale Id 1459582',1500.00,0.00,0.00,2.50,155.00,'2022-01-04 16:59:46','',''),(2439587,'1','201','1037',478,'Retail Sale Id 1459587',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 17:00:38','',''),(2439615,'1','201','1037',478,'Retail Sale Id 1459619',1200.00,0.00,0.00,2.00,124.00,'2022-01-04 17:04:41','',''),(2439635,'1','201','1037',478,'Retail Sale Id 1459640',3000.00,0.00,0.00,5.00,310.00,'2022-01-04 17:08:57','',''),(2440688,'1','201','1037',478,'Retail Sale Id 1460085',1200.00,0.00,0.00,2.00,124.00,'2022-01-05 07:05:38','',''),(2440689,'1','201','1037',478,'Retail Sale Id 1460085',1800.00,0.00,0.00,3.00,186.00,'2022-01-05 07:05:38','',''),(2440721,'1','201','1037',478,'Retail Sale Id 1460116',7200.00,0.00,0.00,12.00,744.00,'2022-01-05 07:09:50','',''),(2440800,'1','201','1037',478,'Retail Sale Id 1460185',1800.00,0.00,0.00,3.00,186.00,'2022-01-05 07:20:26','',''),(2440839,'1','201','1037',478,'Retail Sale Id 1460223',7200.00,0.00,0.00,12.00,744.00,'2022-01-05 07:27:05','',''),(2440867,'1','201','1037',478,'Retail Sale Id 1460252',1998.00,0.00,0.00,3.33,206.46,'2022-01-05 07:31:11','',''),(2440892,'1','201','1037',478,'Retail Sale Id 1460275',1800.00,0.00,0.00,3.00,186.00,'2022-01-05 07:33:57','',''),(2440893,'1','201','1037',478,'Retail Sale Id 1460275',3600.00,0.00,0.00,6.00,372.00,'2022-01-05 07:33:57','',''),(2441062,'1','201','1037',478,'Retail Sale Id 1460377',17100.00,0.00,0.00,30.00,960.00,'2022-01-05 07:44:02','',''),(2441227,'1','201','1037',478,'Retail Sale Id 1460481',3000.00,0.00,0.00,5.00,310.00,'2022-01-05 07:56:15','',''),(2441343,'1','201','1037',478,'Retail Sale Id 1460587',3600.00,0.00,0.00,6.00,372.00,'2022-01-05 08:08:31','',''),(2441363,'1','201','1037',478,'Retail Sale Id 1460603',1800.00,0.00,0.00,3.00,186.00,'2022-01-05 08:10:12','',''),(2441412,'1','201','1037',478,'Retail Sale Id 1460656',7500.00,0.00,0.00,12.50,775.00,'2022-01-05 08:15:31','',''),(2441424,'1','201','1037',478,'Retail Sale Id 1460664',1998.00,0.00,0.00,3.33,206.46,'2022-01-05 08:16:33','',''),(2441563,'1','201','1037',478,'Retail Sale Id 1460758',7125.00,0.00,0.00,12.50,400.00,'2022-01-05 09:26:44','',''),(2441592,'1','201','1037',478,'Retail Sale Id 1460776',2400.00,0.00,0.00,4.00,248.00,'2022-01-05 09:29:06','',''),(2441601,'1','201','1037',478,'Retail Sale Id 1460787',2400.00,0.00,0.00,4.00,248.00,'2022-01-05 09:30:31','',''),(2441684,'1','201','1037',478,'Retail Sale Id 1460833',3000.00,0.00,0.00,5.00,310.00,'2022-01-05 09:34:58','',''),(2441948,'1','201','1037',478,'Retail Sale Id 1461042',1800.00,0.00,0.00,3.00,186.00,'2022-01-05 09:58:40','',''),(2612956,'1','201',NULL,478,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613343,'1','201','1037',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613344,'1','201','1037',478,'Retail Sale Id 1461043',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 08:39:32','',''),(2613345,'1','201','1037',478,'Retail Sale Id 1461044',2700.00,0.00,0.00,4.50,279.00,'2022-02-02 08:41:54','',''),(2613346,'1','201','1037',478,'Retail Sale Id 1461045',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 09:03:49','',''),(2613347,'1','201','1037',478,'Retail Sale Id 1461046',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 09:06:32','',''),(2613348,'1','201','1037',478,'Retail Sale Id 1461047',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 09:17:11','',''),(2613349,'1','201','1037',478,'Retail Sale Id 1461048',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 09:20:17','',''),(2613350,'1','201','1037',478,'Retail Sale Id 1461049',1500.00,0.00,0.00,2.50,155.00,'2022-02-02 09:24:27','',''),(2613351,'1','201','1037',478,'Retail Sale Id 1461050',300.00,0.00,0.00,0.50,31.00,'2022-02-02 09:26:36','',''),(2613352,'1','201','1037',478,'Retail Sale Id 1461051',7500.00,0.00,0.00,12.50,775.00,'2022-02-02 09:30:45','',''),(2613353,'1','201','1037',478,'Retail Sale Id 1461052',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 10:03:11','',''),(2613354,'1','201','1037',478,'Retail Sale Id 1461053',1500.00,0.00,0.00,2.50,155.00,'2022-02-02 10:18:24','',''),(2613355,'1','201','1037',478,'Retail Sale Id 1461054',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 10:21:03','',''),(2613356,'1','201','1037',478,'Retail Sale Id 1461055',4200.00,0.00,0.00,7.00,434.00,'2022-02-02 10:26:37','',''),(2613357,'1','201','1037',478,'Retail Sale Id 1461056',7500.00,0.00,0.00,12.50,775.00,'2022-02-02 10:30:40','',''),(2613358,'1','201','1037',478,'Retail Sale Id 1461057',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 10:34:25','',''),(2613359,'1','201','1037',478,'Retail Sale Id 1461058',2400.00,0.00,0.00,4.00,248.00,'2022-02-02 10:45:16','',''),(2613360,'1','201','1037',478,'Retail Sale Id 1461059',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 10:51:46','',''),(2613361,'1','201','1037',478,'Retail Sale Id 1461060',2400.00,0.00,0.00,4.00,248.00,'2022-02-02 10:52:56','',''),(2613362,'1','201','1037',478,'Retail Sale Id 1461061',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 11:27:59','',''),(2613363,'1','201','1037',478,'Retail Sale Id 1461062',7500.00,0.00,0.00,12.50,775.00,'2022-02-02 11:30:31','',''),(2613364,'1','201','1037',478,'Retail Sale Id 1461064',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 11:40:54','',''),(2613365,'1','201','1037',478,'Retail Sale Id 1461065',10800.00,0.00,0.00,18.00,1116.00,'2022-02-02 11:51:35','',''),(2613366,'1','201','1037',478,'Retail Sale Id 1461066',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 11:54:49','',''),(2613367,'1','201','1037',478,'Retail Sale Id 1461067',1200.00,0.00,0.00,2.00,124.00,'2022-02-02 12:02:07','',''),(2613368,'1','201','1037',478,'Retail Sale Id 1461068',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 12:04:10','',''),(2613369,'1','201','1037',478,'Retail Sale Id 1461069',1200.00,0.00,0.00,2.00,124.00,'2022-02-02 12:13:59','',''),(2613370,'1','201','1037',478,'Retail Sale Id 1461070',2400.00,0.00,0.00,4.00,248.00,'2022-02-02 12:20:08','',''),(2613371,'1','201','1037',478,'Retail Sale Id 1461071',1200.00,0.00,0.00,2.00,124.00,'2022-02-02 12:25:37','',''),(2613372,'1','201','1037',478,'Retail Sale Id 1461072',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 12:42:00','',''),(2613373,'1','201','1037',478,'Retail Sale Id 1461073',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 12:51:14','',''),(2613374,'1','201','1037',478,'Retail Sale Id 1461074',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 12:54:08','',''),(2613375,'1','201','1037',478,'Retail Sale Id 1461075',2400.00,0.00,0.00,4.00,248.00,'2022-02-02 13:16:23','',''),(2613376,'1','201','1037',478,'Retail Sale Id 1461076',4200.00,0.00,0.00,7.00,434.00,'2022-02-02 13:42:48','',''),(2613377,'1','201','1037',478,'Retail Sale Id 1461077',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 13:49:51','',''),(2613378,'1','201','1037',478,'Retail Sale Id 1461078',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 13:53:24','',''),(2613379,'1','201','1037',478,'Retail Sale Id 1461079',2400.00,0.00,0.00,4.00,248.00,'2022-02-02 13:55:22','',''),(2613380,'1','201','1037',478,'Retail Sale Id 1461080',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 14:14:59','',''),(2613381,'1','201','1037',478,'Retail Sale Id 1461081',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 14:25:22','',''),(2613382,'1','201','1037',478,'Retail Sale Id 1461082',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 14:43:20','',''),(2613383,'1','201','1037',478,'Retail Sale Id 1461083',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 14:44:08','',''),(2613384,'1','201','1037',478,'Retail Sale Id 1461084',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 14:54:32','',''),(2613385,'1','201','1037',478,'Retail Sale Id 1461085',1200.00,0.00,0.00,2.00,124.00,'2022-02-02 14:55:40','',''),(2613386,'1','201','1037',478,'Retail Sale Id 1461086',2400.00,0.00,0.00,4.00,248.00,'2022-02-02 15:08:55','',''),(2613387,'1','201','1037',478,'Retail Sale Id 1461087',15000.00,0.00,0.00,25.00,1550.00,'2022-02-02 15:14:05','',''),(2613388,'1','201','1037',478,'Retail Sale Id 1461089',3000.00,0.00,0.00,5.00,310.00,'2022-02-02 15:15:53','',''),(2613389,'1','201','1037',478,'Retail Sale Id 1461090',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 15:25:45','',''),(2613390,'1','201','1037',478,'Retail Sale Id 1461091',7500.00,0.00,0.00,12.50,775.00,'2022-02-02 15:28:39','',''),(2613391,'1','201','1037',478,'Retail Sale Id 1461092',1200.00,0.00,0.00,2.00,124.00,'2022-02-02 15:29:48','',''),(2613392,'1','201','1037',478,'Retail Sale Id 1461093',1200.00,0.00,0.00,2.00,124.00,'2022-02-02 15:30:29','',''),(2613393,'1','201','1037',478,'Retail Sale Id 1461094',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 15:31:27','',''),(2613394,'1','201','1037',478,'Retail Sale Id 1461095',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 15:32:18','',''),(2613395,'1','201','1037',478,'Retail Sale Id 1461096',7200.00,0.00,0.00,12.00,744.00,'2022-02-02 15:43:29','',''),(2613396,'1','201','1037',478,'Retail Sale Id 1461097',1500.00,0.00,0.00,2.50,155.00,'2022-02-02 15:51:33','',''),(2613397,'1','201','1037',478,'Retail Sale Id 1461098',4200.00,0.00,0.00,7.00,434.00,'2022-02-02 15:54:06','',''),(2613398,'1','201','1037',478,'Retail Sale Id 1461099',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 15:58:28','',''),(2613399,'1','201','1037',478,'Retail Sale Id 1461100',4200.00,0.00,0.00,7.00,434.00,'2022-02-02 16:29:06','',''),(2613400,'1','201','1037',478,'Retail Sale Id 1461101',2400.00,0.00,0.00,4.00,248.00,'2022-02-02 16:40:25','',''),(2613401,'1','201','1037',478,'Retail Sale Id 1461102',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 16:49:03','',''),(2613402,'1','201','1037',478,'Retail Sale Id 1461103',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 16:51:28','',''),(2613403,'1','201','1037',478,'Retail Sale Id 1461104',4200.00,0.00,0.00,7.00,434.00,'2022-02-02 16:52:42','',''),(2613404,'1','201','1037',478,'Retail Sale Id 1461105',2400.00,0.00,0.00,4.00,248.00,'2022-02-02 16:55:00','',''),(2613405,'1','201','1037',478,'Retail Sale Id 1461106',1500.00,0.00,0.00,2.50,155.00,'2022-02-02 16:56:42','',''),(2613406,'1','201','1037',478,'Retail Sale Id 1461107',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 16:57:46','',''),(2613407,'1','201','1037',478,'Retail Sale Id 1461108',4998.00,0.00,0.00,8.33,516.46,'2022-02-02 17:02:17','',''),(2613408,'1','201','1037',478,'Retail Sale Id 1461109',28500.00,0.00,0.00,50.00,1600.00,'2022-02-02 17:08:58','',''),(2613409,'1','201','1037',478,'Retail Sale Id 1461110',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 17:09:57','',''),(2613410,'1','201','1037',478,'Retail Sale Id 1461111',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 17:13:27','',''),(2613411,'1','201','1037',478,'Retail Sale Id 1461112',7500.00,0.00,0.00,12.50,775.00,'2022-02-02 17:19:32','',''),(2613412,'1','201','1037',478,'Retail Sale Id 1461113',3600.00,0.00,0.00,6.00,372.00,'2022-02-02 17:20:53','',''),(2613413,'1','201','1037',478,'Retail Sale Id 1461114',1200.00,0.00,0.00,2.00,124.00,'2022-02-02 17:26:51','',''),(2613414,'1','201','1037',478,'Retail Sale Id 1461115',1002.00,0.00,0.00,1.67,103.54,'2022-02-02 17:43:15','',''),(2613415,'1','201','1037',478,'Retail Sale Id 1461116',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 17:44:28','',''),(2613416,'1','201','1037',478,'Retail Sale Id 1461117',7500.00,0.00,0.00,12.50,775.00,'2022-02-02 17:48:38','',''),(2613417,'1','201','1037',478,'Retail Sale Id 1461118',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 17:56:09','',''),(2613418,'1','201','1037',478,'Retail Sale Id 1461119',7200.00,0.00,0.00,12.00,744.00,'2022-02-02 18:00:50','',''),(2613419,'1','201','1037',478,'Retail Sale Id 1461120',9600.00,0.00,0.00,16.00,992.00,'2022-02-02 18:29:25','',''),(2613420,'1','201','1037',478,'Retail Sale Id 1461121',61080.00,0.00,0.00,101.80,6311.60,'2022-02-02 18:40:34','',''),(2613421,'1','201','1037',478,'Retail Sale Id 1461122',1800.00,0.00,0.00,3.00,186.00,'2022-02-02 18:53:52','',''),(2613422,'1','201','1037',478,'Retail Sale Id 1461123',5400.00,0.00,0.00,9.00,558.00,'2022-02-02 18:55:37','',''),(2613423,'1','201','1037',478,'Return of Retail Sale Id 1461123',0.00,5400.00,9.00,0.00,-558.00,'2022-02-02 19:33:37','',''),(2613424,'1','201','1037',478,'Retail Sale Id 1461124',5166.00,0.00,0.00,8.61,533.82,'2022-02-02 19:34:21','',''),(2613425,'1','201','1037',478,'Retail Sale Id 1461125',84.00,0.00,0.00,0.14,8.68,'2022-02-02 19:36:01','',''),(2613426,'1','201','1037',478,'Retail Sale Id 1461126',3000.00,0.00,0.00,5.00,310.00,'2022-02-03 08:09:13','',''),(2613427,'1','201','1037',478,'Retail Sale Id 1461127',3600.00,0.00,0.00,6.00,372.00,'2022-02-03 08:11:18','',''),(2613428,'1','201','1037',478,'Retail Sale Id 1461128',3000.00,0.00,0.00,5.00,310.00,'2022-02-03 08:22:17','',''),(2613429,'1','201','1037',478,'Retail Sale Id 1461129',3900.00,0.00,0.00,6.50,403.00,'2022-02-03 08:24:30','',''),(2613430,'1','201','1037',478,'Retail Sale Id 1461129',3900.00,0.00,0.00,6.50,403.00,'2022-02-03 08:24:30','',''),(2613431,'1','201','1037',478,'Retail Sale Id 1461130',3000.00,0.00,0.00,5.00,310.00,'2022-02-03 08:38:50','',''),(2613432,'1','201','1037',478,'Retail Sale Id 1461131',1800.00,0.00,0.00,3.00,186.00,'2022-02-03 08:51:33','',''),(2613433,'1','201','1037',478,'Retail Sale Id 1461132',3600.00,0.00,0.00,6.00,372.00,'2022-02-03 08:52:20','',''),(2613434,'1','201','1037',478,'Retail Sale Id 1461133',3600.00,0.00,0.00,6.00,372.00,'2022-02-03 09:01:03','',''),(2613435,'1','201','1037',478,'Retail Sale Id 1461134',3600.00,0.00,0.00,6.00,372.00,'2022-02-03 09:05:07','',''),(2613436,'1','201','1037',478,'Retail Sale Id 1461135',7500.00,0.00,0.00,12.50,775.00,'2022-02-03 09:13:18','',''),(2613437,'1','201','1037',478,'Retail Sale Id 1461136',3600.00,0.00,0.00,6.00,372.00,'2022-02-03 09:14:11','',''),(2613438,'1','201','1037',478,'Retail Sale Id 1461137',4200.00,0.00,0.00,7.00,434.00,'2022-02-03 09:15:13','',''),(2613439,'1','201','1037',478,'Retail Sale Id 1461138',1800.00,0.00,0.00,3.00,186.00,'2022-02-03 09:45:26','',''),(2613440,'1','201','1037',478,'Retail Sale Id 1461139',2502.00,0.00,0.00,4.17,258.54,'2022-02-03 09:47:51','',''),(2613441,'1','201','1037',478,'Retail Sale Id 1461140',1800.00,0.00,0.00,3.00,186.00,'2022-02-03 10:18:38','',''),(2613442,'1','201','1037',478,'Retail Sale Id 1461141',7500.00,0.00,0.00,12.50,775.00,'2022-02-03 10:26:30','',''),(2613443,'1','201','1037',478,'Retail Sale Id 1461142',6900.00,0.00,0.00,11.50,713.00,'2022-02-03 10:33:26','',''),(2613444,'1','201','1037',478,'Retail Sale Id 1461143',1002.00,0.00,0.00,1.67,103.54,'2022-02-03 10:43:51','',''),(2613445,'1','201','1037',478,'Retail Sale Id 1461144',1500.00,0.00,0.00,2.50,155.00,'2022-02-03 10:44:47','',''),(2613446,'1','201','1037',478,'Retail Sale Id 1461145',1200.00,0.00,0.00,2.00,124.00,'2022-02-03 10:49:29','',''),(2613447,'1','201','1037',478,'Retail Sale Id 1461147',7500.00,0.00,0.00,12.50,775.00,'2022-02-03 10:51:37','',''),(2613448,'1','201','1037',478,'Retail Sale Id 1461148',1800.00,0.00,0.00,3.00,186.00,'2022-02-03 10:56:58','',''),(2613449,'1','201','1037',478,'Retail Sale Id 1461149',2400.00,0.00,0.00,4.00,248.00,'2022-02-03 11:01:51','',''),(2613450,'1','201','1037',478,'Retail Sale Id 1461150',600.00,0.00,0.00,1.00,62.00,'2022-02-03 11:09:56','',''),(2613451,'1','201','1037',478,'Retail Sale Id 1461151',600.00,0.00,0.00,1.00,62.00,'2022-02-03 11:11:09','',''),(2613452,'1','201','1037',478,'Retail Sale Id 1461152',900.00,0.00,0.00,1.50,93.00,'2022-02-03 11:12:08','',''),(2613453,'1','201','1037',478,'Retail Sale Id 1461153',3000.00,0.00,0.00,5.00,310.00,'2022-02-03 11:13:22','',''),(2613454,'1','201','1037',478,'Retail Sale Id 1461154',2400.00,0.00,0.00,4.00,248.00,'2022-02-03 11:14:09','',''),(2613455,'1','201','1037',478,'Retail Sale Id 1461155',1002.00,0.00,0.00,1.67,103.54,'2022-02-03 11:19:19','',''),(2613456,'1','201','1037',478,'Retail Sale Id 1461156',56500.00,0.00,0.00,100.00,2700.00,'2022-02-03 11:21:59','',''),(2613457,'1','201','1037',478,'Retail Sale Id 1461157',7500.00,0.00,0.00,12.50,775.00,'2022-02-03 11:40:11','',''),(2613458,'1','201','1037',478,'Retail Sale Id 1461158',1800.00,0.00,0.00,3.00,186.00,'2022-02-03 11:57:31','',''),(2613459,'1','201','1037',478,'Retail Sale Id 1461159',1800.00,0.00,0.00,3.00,186.00,'2022-02-03 12:12:46','',''),(2613460,'1','201','1037',478,'Retail Sale Id 1461160',2400.00,0.00,0.00,4.00,248.00,'2022-02-03 12:39:15','',''),(2613461,'1','201','1037',478,'Retail Sale Id 1461161',22500.00,0.00,0.00,37.50,2325.00,'2022-02-03 12:50:41','',''),(2613462,'1','201','1037',478,'Retail Sale Id 1461162',2502.00,0.00,0.00,4.17,258.54,'2022-02-03 12:52:51','',''),(2613463,'1','201','1037',478,'Retail Sale Id 1461163',3000.00,0.00,0.00,5.00,310.00,'2022-02-03 12:57:41','',''),(2613464,'1','201','1037',478,'Retail Sale Id 1461164',1500.00,0.00,0.00,2.50,155.00,'2022-02-03 13:00:25','',''),(2613465,'1','201','1037',478,'Retail Sale Id 1461165',3000.00,0.00,0.00,5.00,310.00,'2022-02-03 13:27:12','',''),(2613466,'1','201','1037',478,'Retail Sale Id 1461166',3000.00,0.00,0.00,5.00,310.00,'2022-02-03 14:10:05','',''),(2613467,'1','201','1037',478,'Retail Sale Id 1461166',7500.00,0.00,0.00,12.50,775.00,'2022-02-03 14:10:05','',''),(2613468,'1','201','1037',478,'Retail Sale Id 1461167',1800.00,0.00,0.00,3.00,186.00,'2022-02-03 14:10:56','',''),(2613469,'1','201','1037',478,'Retail Sale Id 1461168',47880.00,0.00,0.00,79.80,4947.60,'2022-02-03 16:58:56','',''),(2613470,'1','201','1037',478,'Retail Sale Id 1461169',23700.00,0.00,0.00,39.50,2449.00,'2022-02-03 17:33:53','',''),(2613471,'1','201','1037',478,'Retail Sale Id 1461170',1800.00,0.00,0.00,3.00,186.00,'2022-02-03 17:35:31','',''),(2613472,'1','201','1037',478,'Retail Sale Id 1461171',28250.00,0.00,0.00,50.00,1350.00,'2022-02-03 17:36:48','',''),(2613473,'1','201','1037',478,'Retail Sale Id 1461172',3000.00,0.00,0.00,5.00,310.00,'2022-02-03 17:40:27','',''),(2613474,'1','201','1037',478,'Retail Sale Id 1461173',3600.00,0.00,0.00,6.00,372.00,'2022-02-03 17:42:45','',''),(2613475,'1','201','1037',478,'Retail Sale Id 1461174',1800.00,0.00,0.00,3.00,186.00,'2022-02-03 17:46:58','',''),(2613476,'1','201','1037',478,'Retail Sale Id 1461175',600.00,0.00,0.00,1.00,62.00,'2022-02-03 17:54:38','',''),(2613477,'1','201','1037',478,'Retail Sale Id 1461176',1800.00,0.00,0.00,3.00,186.00,'2022-02-03 17:55:12','',''),(2613478,'1','201','1037',478,'Retail Sale Id 1461177',3600.00,0.00,0.00,6.00,372.00,'2022-02-03 18:10:34','',''),(2613479,'1','201','1037',478,'Retail Sale Id 1461178',3600.00,0.00,0.00,6.00,372.00,'2022-02-03 18:11:24','',''),(2613480,'1','201','1037',478,'Retail Sale Id 1461179',7002.00,0.00,0.00,11.67,723.54,'2022-02-03 18:22:23','',''),(2613481,'1','201','1037',478,'Retail Sale Id 1461180',3600.00,0.00,0.00,6.00,372.00,'2022-02-03 18:23:10','',''),(2613482,'1','201','1037',478,'Return of Retail Sale Id 1461180',0.00,3600.00,6.00,0.00,-372.00,'2022-02-03 20:09:47','',''),(2613483,'1','201','1037',478,'Retail Sale Id 1461181',2886.00,0.00,0.00,4.81,298.22,'2022-02-03 20:12:19','',''),(2613484,'1','201','1037',478,'Retail Sale Id 1461182',2502.00,0.00,0.00,4.17,258.54,'2022-02-04 07:51:27','',''),(2613485,'1','201','1037',478,'Retail Sale Id 1461183',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 09:45:09','',''),(2613486,'1','201','1037',478,'Retail Sale Id 1461184',7500.00,0.00,0.00,12.50,775.00,'2022-02-04 09:52:48','',''),(2613487,'1','201','1037',478,'Retail Sale Id 1461185',1200.00,0.00,0.00,2.00,124.00,'2022-02-04 09:53:32','',''),(2613488,'1','201','1037',478,'Retail Sale Id 1461186',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 09:54:21','',''),(2613489,'1','201','1037',478,'Retail Sale Id 1461187',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 09:55:24','',''),(2613490,'1','201','1037',478,'Retail Sale Id 1461188',3600.00,0.00,0.00,6.00,372.00,'2022-02-04 09:56:19','',''),(2613491,'1','201','1037',478,'Retail Sale Id 1461189',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 09:57:20','',''),(2613492,'1','201','1037',478,'Retail Sale Id 1461190',2400.00,0.00,0.00,4.00,248.00,'2022-02-04 09:59:53','',''),(2613493,'1','201','1037',478,'Retail Sale Id 1461191',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 10:19:54','',''),(2613494,'1','201','1037',478,'Retail Sale Id 1461192',2400.00,0.00,0.00,4.00,248.00,'2022-02-04 10:21:01','',''),(2613495,'1','201','1037',478,'Retail Sale Id 1461193',4200.00,0.00,0.00,7.00,434.00,'2022-02-04 10:35:20','',''),(2613496,'1','201','1037',478,'Retail Sale Id 1461194',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 10:44:37','',''),(2613497,'1','201','1037',478,'Retail Sale Id 1461195',2100.00,0.00,0.00,3.50,217.00,'2022-02-04 10:52:51','',''),(2613498,'1','201','1037',478,'Retail Sale Id 1461196',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 11:04:20','',''),(2613499,'1','201','1037',478,'Retail Sale Id 1461197',2400.00,0.00,0.00,4.00,248.00,'2022-02-04 11:13:58','',''),(2613500,'1','201','1037',478,'Retail Sale Id 1461198',7200.00,0.00,0.00,12.00,744.00,'2022-02-04 11:21:44','',''),(2613501,'1','201','1037',478,'Retail Sale Id 1461199',1200.00,0.00,0.00,2.00,124.00,'2022-02-04 11:29:25','',''),(2613502,'1','201','1037',478,'Retail Sale Id 1461200',2400.00,0.00,0.00,4.00,248.00,'2022-02-04 11:31:12','',''),(2613503,'1','201','1037',478,'Retail Sale Id 1461201',113000.00,0.00,0.00,200.00,5400.00,'2022-02-04 11:36:29','',''),(2613504,'1','201','1037',478,'Retail Sale Id 1461202',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 11:37:47','',''),(2613505,'1','201','1037',478,'Retail Sale Id 1461203',1998.00,0.00,0.00,3.33,206.46,'2022-02-04 11:43:32','',''),(2613506,'1','201','1037',478,'Retail Sale Id 1461204',4200.00,0.00,0.00,7.00,434.00,'2022-02-04 11:52:10','',''),(2613507,'1','201','1037',478,'Retail Sale Id 1461205',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 12:05:18','',''),(2613508,'1','201','1037',478,'Retail Sale Id 1461206',7800.00,0.00,0.00,13.00,806.00,'2022-02-04 12:14:34','',''),(2613509,'1','201','1037',478,'Retail Sale Id 1461207',6002.10,0.00,0.00,10.53,336.96,'2022-02-04 12:23:17','',''),(2613510,'1','201','1037',478,'Retail Sale Id 1461208',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 12:33:20','',''),(2613511,'1','201','1037',478,'Retail Sale Id 1461209',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 12:34:57','',''),(2613512,'1','201','1037',478,'Retail Sale Id 1461210',900.00,0.00,0.00,1.50,93.00,'2022-02-04 12:40:11','',''),(2613513,'1','201','1037',478,'Retail Sale Id 1461211',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 12:49:12','',''),(2613514,'1','201','1037',478,'Retail Sale Id 1461212',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 12:54:38','',''),(2613515,'1','201','1037',478,'Retail Sale Id 1461213',3600.00,0.00,0.00,6.00,372.00,'2022-02-04 13:34:26','',''),(2613516,'1','201','1037',478,'Retail Sale Id 1461214',10500.00,0.00,0.00,17.50,1085.00,'2022-02-04 14:11:26','',''),(2613517,'1','201','1037',478,'Retail Sale Id 1461215',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 14:16:52','',''),(2613518,'1','201','1037',478,'Retail Sale Id 1461216',7500.00,0.00,0.00,12.50,775.00,'2022-02-04 14:25:23','',''),(2613519,'1','201','1037',478,'Retail Sale Id 1461217',2400.00,0.00,0.00,4.00,248.00,'2022-02-04 14:27:19','',''),(2613520,'1','201','1037',478,'Retail Sale Id 1461217',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 14:27:19','',''),(2613521,'1','201','1037',478,'Retail Sale Id 1461218',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 14:31:48','',''),(2613522,'1','201','1037',478,'Retail Sale Id 1461220',3600.00,0.00,0.00,6.00,372.00,'2022-02-04 14:33:55','',''),(2613523,'1','201','1037',478,'Retail Sale Id 1461221',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 14:35:17','',''),(2613524,'1','201','1037',478,'Retail Sale Id 1461222',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 15:00:13','',''),(2613525,'1','201','1037',478,'Retail Sale Id 1461223',1098.00,0.00,0.00,1.83,113.46,'2022-02-04 15:01:35','',''),(2613526,'1','201','1037',478,'Retail Sale Id 1461224',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 15:09:54','',''),(2613527,'1','201','1037',478,'Retail Sale Id 1461226',3600.00,0.00,0.00,6.00,372.00,'2022-02-04 15:11:03','',''),(2613528,'1','201','1037',478,'Retail Sale Id 1461227',4800.00,0.00,0.00,8.00,496.00,'2022-02-04 15:12:09','',''),(2613529,'1','201','1037',478,'Retail Sale Id 1461228',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 15:22:25','',''),(2613530,'1','201','1037',478,'Retail Sale Id 1461229',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 15:41:19','',''),(2613531,'1','201','1037',478,'Retail Sale Id 1461230',1200.00,0.00,0.00,2.00,124.00,'2022-02-04 15:43:48','',''),(2613532,'1','201','1037',478,'Retail Sale Id 1461231',1200.00,0.00,0.00,2.00,124.00,'2022-02-04 16:00:24','',''),(2613533,'1','201','1037',478,'Retail Sale Id 1461232',3600.00,0.00,0.00,6.00,372.00,'2022-02-04 16:09:12','',''),(2613534,'1','201','1037',478,'Retail Sale Id 1461233',3600.00,0.00,0.00,6.00,372.00,'2022-02-04 16:20:00','',''),(2613535,'1','201','1037',478,'Retail Sale Id 1461235',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 16:44:11','',''),(2613536,'1','201','1037',478,'Retail Sale Id 1461236',1002.00,0.00,0.00,1.67,103.54,'2022-02-04 16:53:45','',''),(2613537,'1','201','1037',478,'Retail Sale Id 1461237',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 16:56:28','',''),(2613538,'1','201','1037',478,'Retail Sale Id 1461238',3000.00,0.00,0.00,5.00,310.00,'2022-02-04 16:58:51','',''),(2613539,'1','201','1037',478,'Retail Sale Id 1461239',1200.00,0.00,0.00,2.00,124.00,'2022-02-04 17:04:58','',''),(2613540,'1','201','1037',478,'Retail Sale Id 1461240',1200.00,0.00,0.00,2.00,124.00,'2022-02-04 17:12:52','',''),(2613541,'1','201','1037',478,'Retail Sale Id 1461241',2400.00,0.00,0.00,4.00,248.00,'2022-02-04 17:17:31','',''),(2613542,'1','201','1037',478,'Retail Sale Id 1461242',28250.00,0.00,0.00,50.00,1350.00,'2022-02-04 17:35:32','',''),(2613543,'1','201','1037',478,'Retail Sale Id 1461243',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 17:39:55','',''),(2613544,'1','201','1037',478,'Retail Sale Id 1461244',1200.00,0.00,0.00,2.00,124.00,'2022-02-04 17:49:02','',''),(2613545,'1','201','1037',478,'Retail Sale Id 1461245',1002.00,0.00,0.00,1.67,103.54,'2022-02-04 17:50:02','',''),(2613546,'1','201','1037',478,'Retail Sale Id 1461246',6000.00,0.00,0.00,10.00,620.00,'2022-02-04 18:14:21','',''),(2613547,'1','201','1037',478,'Retail Sale Id 1461247',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 18:22:06','',''),(2613548,'1','201','1037',478,'Retail Sale Id 1461248',1200.00,0.00,0.00,2.00,124.00,'2022-02-04 18:28:14','',''),(2613549,'1','201','1037',478,'Retail Sale Id 1461249',1800.00,0.00,0.00,3.00,186.00,'2022-02-04 18:34:00','',''),(2613550,'1','201','1037',478,'Return of Retail Sale Id 1461241',0.00,2400.00,4.00,0.00,-248.00,'2022-02-04 19:34:52','',''),(2613551,'1','201','1037',478,'Retail Sale Id 1461250',1560.00,0.00,0.00,2.60,161.20,'2022-02-04 19:36:47','',''),(2613552,'1','201','1037',478,'Retail Sale Id 1461251',7500.00,0.00,0.00,12.50,775.00,'2022-02-05 09:32:36','',''),(2613553,'1','201','1037',478,'Retail Sale Id 1461252',3198.00,0.00,0.00,5.33,330.46,'2022-02-05 10:36:45','',''),(2613554,'1','201','1037',478,'Retail Sale Id 1461253',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 10:37:28','',''),(2613555,'1','201','1037',478,'Retail Sale Id 1461254',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 10:38:19','',''),(2613556,'1','201','1037',478,'Retail Sale Id 1461255',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 10:39:25','',''),(2613557,'1','201','1037',478,'Retail Sale Id 1461256',2400.00,0.00,0.00,4.00,248.00,'2022-02-05 10:40:24','',''),(2613558,'1','201','1037',478,'Retail Sale Id 1461257',3900.00,0.00,0.00,6.50,403.00,'2022-02-05 10:41:05','',''),(2613559,'1','201','1037',478,'Retail Sale Id 1461258',600.00,0.00,0.00,1.00,62.00,'2022-02-05 10:42:22','',''),(2613560,'1','201','1037',478,'Retail Sale Id 1461259',1998.00,0.00,0.00,3.33,206.46,'2022-02-05 10:43:11','',''),(2613561,'1','201','1037',478,'Retail Sale Id 1461260',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 10:43:49','',''),(2613562,'1','201','1037',478,'Retail Sale Id 1461261',1998.00,0.00,0.00,3.33,206.46,'2022-02-05 10:50:22','',''),(2613563,'1','201','1037',478,'Retail Sale Id 1461262',600.00,0.00,0.00,1.00,62.00,'2022-02-05 10:54:57','',''),(2613564,'1','201','1037',478,'Retail Sale Id 1461263',3000.00,0.00,0.00,5.00,310.00,'2022-02-05 10:58:39','',''),(2613565,'1','201','1037',478,'Retail Sale Id 1461264',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 11:01:01','',''),(2613566,'1','201','1037',478,'Retail Sale Id 1461265',7500.00,0.00,0.00,12.50,775.00,'2022-02-05 11:07:50','',''),(2613567,'1','201','1037',478,'Retail Sale Id 1461266',3000.00,0.00,0.00,5.00,310.00,'2022-02-05 11:11:59','',''),(2613568,'1','201','1037',478,'Retail Sale Id 1461267',2100.00,0.00,0.00,3.50,217.00,'2022-02-05 11:14:31','',''),(2613569,'1','201','1037',478,'Retail Sale Id 1461268',4002.00,0.00,0.00,6.67,413.54,'2022-02-05 11:17:17','',''),(2613570,'1','201','1037',478,'Retail Sale Id 1461269',7500.00,0.00,0.00,12.50,775.00,'2022-02-05 11:22:55','',''),(2613571,'1','201','1037',478,'Retail Sale Id 1461270',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 11:33:51','',''),(2613572,'1','201','1037',478,'Retail Sale Id 1461271',1200.00,0.00,0.00,2.00,124.00,'2022-02-05 11:52:32','',''),(2613573,'1','201','1037',478,'Retail Sale Id 1461272',900.00,0.00,0.00,1.50,93.00,'2022-02-05 11:56:14','',''),(2613574,'1','201','1037',478,'Retail Sale Id 1461273',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 12:03:29','',''),(2613575,'1','201','1037',478,'Retail Sale Id 1461274',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 12:09:19','',''),(2613576,'1','201','1037',478,'Retail Sale Id 1461275',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 12:23:44','',''),(2613577,'1','201','1037',478,'Retail Sale Id 1461276',1200.00,0.00,0.00,2.00,124.00,'2022-02-05 12:36:20','',''),(2613578,'1','201','1037',478,'Retail Sale Id 1461277',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 12:37:40','',''),(2613579,'1','201','1037',478,'Retail Sale Id 1461278',2700.00,0.00,0.00,4.50,279.00,'2022-02-05 12:40:53','',''),(2613580,'1','201','1037',478,'Retail Sale Id 1461279',600.00,0.00,0.00,1.00,62.00,'2022-02-05 12:42:15','',''),(2613581,'1','201','1037',478,'Retail Sale Id 1461280',5400.00,0.00,0.00,9.00,558.00,'2022-02-05 12:43:08','',''),(2613582,'1','201','1037',478,'Retail Sale Id 1461282',7500.00,0.00,0.00,12.50,775.00,'2022-02-05 13:15:39','',''),(2613583,'1','201','1037',478,'Retail Sale Id 1461283',600.00,0.00,0.00,1.00,62.00,'2022-02-05 13:37:50','',''),(2613584,'1','201','1037',478,'Retail Sale Id 1461284',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 13:38:46','',''),(2613585,'1','201','1037',478,'Retail Sale Id 1461285',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 13:46:55','',''),(2613586,'1','201','1037',478,'Retail Sale Id 1461286',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 13:48:15','',''),(2613587,'1','201','1037',478,'Retail Sale Id 1461287',3000.00,0.00,0.00,5.00,310.00,'2022-02-05 14:00:29','',''),(2613588,'1','201','1037',478,'Retail Sale Id 1461288',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 14:01:30','',''),(2613589,'1','201','1037',478,'Retail Sale Id 1461289',7200.00,0.00,0.00,12.00,744.00,'2022-02-05 14:02:02','',''),(2613590,'1','201','1037',478,'Retail Sale Id 1461290',600.00,0.00,0.00,1.00,62.00,'2022-02-05 14:02:36','',''),(2613591,'1','201','1037',478,'Retail Sale Id 1461291',7500.00,0.00,0.00,12.50,775.00,'2022-02-05 14:06:41','',''),(2613592,'1','201','1037',478,'Retail Sale Id 1461292',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 14:07:43','',''),(2613593,'1','201','1037',478,'Retail Sale Id 1461293',5400.00,0.00,0.00,9.00,558.00,'2022-02-05 14:08:39','',''),(2613594,'1','201','1037',478,'Retail Sale Id 1461294',4200.00,0.00,0.00,7.00,434.00,'2022-02-05 14:15:44','',''),(2613595,'1','201','1037',478,'Retail Sale Id 1461295',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 14:22:21','',''),(2613596,'1','201','1037',478,'Retail Sale Id 1461296',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 14:32:36','',''),(2613597,'1','201','1037',478,'Retail Sale Id 1461297',7500.00,0.00,0.00,12.50,775.00,'2022-02-05 14:49:54','',''),(2613598,'1','201','1037',478,'Retail Sale Id 1461298',3000.00,0.00,0.00,5.00,310.00,'2022-02-05 14:53:10','',''),(2613599,'1','201','1037',478,'Retail Sale Id 1461299',7500.00,0.00,0.00,12.50,775.00,'2022-02-05 15:00:47','',''),(2613600,'1','201','1037',478,'Retail Sale Id 1461300',1200.00,0.00,0.00,2.00,124.00,'2022-02-05 15:01:57','',''),(2613601,'1','201','1037',478,'Retail Sale Id 1461301',600.00,0.00,0.00,1.00,62.00,'2022-02-05 15:03:11','',''),(2613602,'1','201','1037',478,'Retail Sale Id 1461302',2100.00,0.00,0.00,3.50,217.00,'2022-02-05 15:14:35','',''),(2613603,'1','201','1037',478,'Retail Sale Id 1461303',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 15:19:54','',''),(2613604,'1','201','1037',478,'Retail Sale Id 1461304',3000.00,0.00,0.00,5.00,310.00,'2022-02-05 15:49:20','',''),(2613605,'1','201','1037',478,'Retail Sale Id 1461305',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 15:53:12','',''),(2613606,'1','201','1037',478,'Retail Sale Id 1461306',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 15:54:08','',''),(2613607,'1','201','1037',478,'Retail Sale Id 1461307',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 16:05:48','',''),(2613608,'1','201','1037',478,'Retail Sale Id 1461308',1500.00,0.00,0.00,2.50,155.00,'2022-02-05 16:06:54','',''),(2613609,'1','201','1037',478,'Retail Sale Id 1461309',7500.00,0.00,0.00,12.50,775.00,'2022-02-05 16:07:56','',''),(2613610,'1','201','1037',478,'Retail Sale Id 1461310',1500.00,0.00,0.00,2.50,155.00,'2022-02-05 16:08:53','',''),(2613611,'1','201','1037',478,'Retail Sale Id 1461311',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 16:15:08','',''),(2613612,'1','201','1037',478,'Retail Sale Id 1461312',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 16:25:55','',''),(2613613,'1','201','1037',478,'Retail Sale Id 1461313',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 16:49:08','',''),(2613614,'1','201','1037',478,'Retail Sale Id 1461314',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 16:52:39','',''),(2613615,'1','201','1037',478,'Retail Sale Id 1461314',4800.00,0.00,0.00,8.00,496.00,'2022-02-05 16:52:39','',''),(2613616,'1','201','1037',478,'Retail Sale Id 1461315',6000.00,0.00,0.00,10.00,620.00,'2022-02-05 17:03:58','',''),(2613617,'1','201','1037',478,'Retail Sale Id 1461316',1200.00,0.00,0.00,2.00,124.00,'2022-02-05 17:14:03','',''),(2613618,'1','201','1037',478,'Retail Sale Id 1461317',3000.00,0.00,0.00,5.00,310.00,'2022-02-05 17:18:33','',''),(2613619,'1','201','1037',478,'Retail Sale Id 1461317',3000.00,0.00,0.00,5.00,310.00,'2022-02-05 17:18:33','',''),(2613620,'1','201','1037',478,'Retail Sale Id 1461319',1998.00,0.00,0.00,3.33,206.46,'2022-02-05 17:22:01','',''),(2613621,'1','201','1037',478,'Retail Sale Id 1461320',3000.00,0.00,0.00,5.00,310.00,'2022-02-05 17:23:09','',''),(2613622,'1','201','1037',478,'Retail Sale Id 1461321',600.00,0.00,0.00,1.00,62.00,'2022-02-05 17:25:40','',''),(2613623,'1','201','1037',478,'Retail Sale Id 1461322',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 17:27:31','',''),(2613624,'1','201','1037',478,'Retail Sale Id 1461323',1200.00,0.00,0.00,2.00,124.00,'2022-02-05 17:31:55','',''),(2613625,'1','201','1037',478,'Retail Sale Id 1461324',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 17:32:49','',''),(2613626,'1','201','1037',478,'Retail Sale Id 1461325',798.00,0.00,0.00,1.33,82.46,'2022-02-05 17:34:02','',''),(2613627,'1','201','1037',478,'Retail Sale Id 1461326',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 17:39:17','',''),(2613628,'1','201','1037',478,'Retail Sale Id 1461327',600.00,0.00,0.00,1.00,62.00,'2022-02-05 17:40:05','',''),(2613629,'1','201','1037',478,'Retail Sale Id 1461328',3600.00,0.00,0.00,6.00,372.00,'2022-02-05 17:42:08','',''),(2613630,'1','201','1037',478,'Retail Sale Id 1461329',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 17:44:11','',''),(2613631,'1','201','1037',478,'Retail Sale Id 1461330',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 17:54:47','',''),(2613632,'1','201','1037',478,'Retail Sale Id 1461331',7500.00,0.00,0.00,12.50,775.00,'2022-02-05 18:06:13','',''),(2613633,'1','201','1037',478,'Retail Sale Id 1461332',1800.00,0.00,0.00,3.00,186.00,'2022-02-05 18:06:47','',''),(2613634,'1','201','1037',478,'Retail Sale Id 1461333',7500.00,0.00,0.00,12.50,775.00,'2022-02-05 18:07:26','',''),(2613635,'1','201','1037',478,'Retail Sale Id 1461334',2700.00,0.00,0.00,4.50,279.00,'2022-02-06 08:02:54','',''),(2613636,'1','201','1037',478,'Retail Sale Id 1461335',1002.00,0.00,0.00,1.67,103.54,'2022-02-06 08:18:19','',''),(2613637,'1','201','1037',478,'Retail Sale Id 1461336',7500.00,0.00,0.00,12.50,775.00,'2022-02-06 09:32:26','',''),(2613638,'1','201','1037',478,'Retail Sale Id 1461337',1500.00,0.00,0.00,2.50,155.00,'2022-02-06 09:33:50','',''),(2613639,'1','201','1037',478,'Retail Sale Id 1461338',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 09:35:07','',''),(2613640,'1','201','1037',478,'Retail Sale Id 1461339',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 09:36:27','',''),(2613641,'1','201','1037',478,'Retail Sale Id 1461339',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 09:36:27','',''),(2613642,'1','201','1037',478,'Retail Sale Id 1461340',73800.00,0.00,0.00,123.00,7626.00,'2022-02-06 09:38:24','',''),(2613643,'1','201','1037',478,'Retail Sale Id 1461342',57000.00,0.00,0.00,100.00,3200.00,'2022-02-06 09:47:09','',''),(2613644,'1','201','1037',478,'Retail Sale Id 1461343',7500.00,0.00,0.00,12.50,775.00,'2022-02-06 09:50:21','',''),(2613645,'1','201','1037',478,'Retail Sale Id 1461344',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 09:51:12','',''),(2613646,'1','201','1037',478,'Return of Retail Sale Id 1461340',0.00,73800.00,123.00,0.00,-7626.00,'2022-02-06 09:57:49','',''),(2613647,'1','201','1037',478,'Retail Sale Id 1461345',2400.00,0.00,0.00,4.00,248.00,'2022-02-06 10:08:08','',''),(2613648,'1','201','1037',478,'Retail Sale Id 1461346',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 10:22:39','',''),(2613649,'1','201','1037',478,'Retail Sale Id 1461347',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 10:32:11','',''),(2613650,'1','201','1037',478,'Retail Sale Id 1461348',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 10:34:00','',''),(2613651,'1','201','1037',478,'Retail Sale Id 1461349',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 10:39:13','',''),(2613652,'1','201','1037',478,'Retail Sale Id 1461350',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 10:42:37','',''),(2613653,'1','201','1037',478,'Retail Sale Id 1461352',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 10:52:00','',''),(2613654,'1','201','1037',478,'Retail Sale Id 1461353',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 11:01:03','',''),(2613655,'1','201','1037',478,'Retail Sale Id 1461354',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 11:02:02','',''),(2613656,'1','201','1037',478,'Retail Sale Id 1461355',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 11:29:28','',''),(2613657,'1','201','1037',478,'Retail Sale Id 1461356',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 11:32:38','',''),(2613658,'1','201','1037',478,'Retail Sale Id 1461357',7500.00,0.00,0.00,12.50,775.00,'2022-02-06 11:34:21','',''),(2613659,'1','201','1037',478,'Retail Sale Id 1461358',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 11:35:33','',''),(2613660,'1','201','1037',478,'Retail Sale Id 1461359',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 11:36:38','',''),(2613661,'1','201','1037',478,'Retail Sale Id 1461360',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 11:38:24','',''),(2613662,'1','201','1037',478,'Retail Sale Id 1461361',2400.00,0.00,0.00,4.00,248.00,'2022-02-06 11:52:01','',''),(2613663,'1','201','1037',478,'Retail Sale Id 1461362',2400.00,0.00,0.00,4.00,248.00,'2022-02-06 11:55:47','',''),(2613664,'1','201','1037',478,'Retail Sale Id 1461363',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 12:11:14','',''),(2613665,'1','201','1037',478,'Retail Sale Id 1461364',2400.00,0.00,0.00,4.00,248.00,'2022-02-06 12:12:21','',''),(2613666,'1','201','1037',478,'Retail Sale Id 1461365',4200.00,0.00,0.00,7.00,434.00,'2022-02-06 12:13:49','',''),(2613667,'1','201','1037',478,'Retail Sale Id 1461366',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 12:41:16','',''),(2613668,'1','201','1037',478,'Retail Sale Id 1461367',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 12:45:34','',''),(2613669,'1','201','1037',478,'Retail Sale Id 1461368',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 13:00:15','',''),(2613670,'1','201','1037',478,'Retail Sale Id 1461369',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 13:01:55','',''),(2613671,'1','201','1037',478,'Retail Sale Id 1461370',9690.00,0.00,0.00,17.00,544.00,'2022-02-06 13:06:39','',''),(2613672,'1','201','1037',478,'Retail Sale Id 1461371',6000.00,0.00,0.00,10.00,620.00,'2022-02-06 13:32:19','',''),(2613673,'1','201','1037',478,'Retail Sale Id 1461372',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 13:36:33','',''),(2613674,'1','201','1037',478,'Retail Sale Id 1461373',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 13:38:27','',''),(2613675,'1','201','1037',478,'Retail Sale Id 1461375',2400.00,0.00,0.00,4.00,248.00,'2022-02-06 13:43:18','',''),(2613676,'1','201','1037',478,'Retail Sale Id 1461376',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 13:44:24','',''),(2613677,'1','201','1037',478,'Retail Sale Id 1461377',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 13:46:46','',''),(2613678,'1','201','1037',478,'Retail Sale Id 1461378',300.00,0.00,0.00,0.50,31.00,'2022-02-06 13:48:20','',''),(2613679,'1','201','1037',478,'Retail Sale Id 1461379',2400.00,0.00,0.00,4.00,248.00,'2022-02-06 13:54:34','',''),(2613680,'1','201','1037',478,'Retail Sale Id 1461380',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 13:56:15','',''),(2613681,'1','201','1037',478,'Retail Sale Id 1461381',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 13:58:45','',''),(2613682,'1','201','1037',478,'Retail Sale Id 1461382',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 14:05:19','',''),(2613683,'1','201','1037',478,'Retail Sale Id 1461383',5985.00,0.00,0.00,10.50,336.00,'2022-02-06 14:10:42','',''),(2613684,'1','201','1037',478,'Retail Sale Id 1461384',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 14:15:23','',''),(2613685,'1','201','1037',478,'Retail Sale Id 1461385',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 14:23:22','',''),(2613686,'1','201','1037',478,'Retail Sale Id 1461386',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 14:27:45','',''),(2613687,'1','201','1037',478,'Retail Sale Id 1461387',1500.00,0.00,0.00,2.50,155.00,'2022-02-06 14:28:43','',''),(2613688,'1','201','1037',478,'Retail Sale Id 1461388',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 14:40:03','',''),(2613689,'1','201','1037',478,'Retail Sale Id 1461389',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 14:41:20','',''),(2613690,'1','201','1037',478,'Retail Sale Id 1461389',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 14:41:20','',''),(2613691,'1','201','1037',478,'Retail Sale Id 1461390',4002.00,0.00,0.00,6.67,413.54,'2022-02-06 14:54:27','',''),(2613692,'1','201','1037',478,'Retail Sale Id 1461391',600.00,0.00,0.00,1.00,62.00,'2022-02-06 14:59:20','',''),(2613693,'1','201','1037',478,'Retail Sale Id 1461392',600.00,0.00,0.00,1.00,62.00,'2022-02-06 15:09:22','',''),(2613694,'1','201','1037',478,'Retail Sale Id 1461393',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 15:18:57','',''),(2613695,'1','201','1037',478,'Retail Sale Id 1461393',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 15:18:57','',''),(2613696,'1','201','1037',478,'Retail Sale Id 1461394',1002.00,0.00,0.00,1.67,103.54,'2022-02-06 15:24:30','',''),(2613697,'1','201','1037',478,'Retail Sale Id 1461395',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 15:25:17','',''),(2613698,'1','201','1037',478,'Retail Sale Id 1461396',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 15:26:11','',''),(2613699,'1','201','1037',478,'Retail Sale Id 1461397',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 15:31:34','',''),(2613700,'1','201','1037',478,'Retail Sale Id 1461398',7500.00,0.00,0.00,12.50,775.00,'2022-02-06 15:35:30','',''),(2613701,'1','201','1037',478,'Retail Sale Id 1461399',7500.00,0.00,0.00,12.50,775.00,'2022-02-06 15:37:17','',''),(2613702,'1','201','1037',478,'Retail Sale Id 1461400',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 15:50:42','',''),(2613703,'1','201','1037',478,'Retail Sale Id 1461401',4998.00,0.00,0.00,8.33,516.46,'2022-02-06 15:52:39','',''),(2613704,'1','201','1037',478,'Retail Sale Id 1461402',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 15:54:01','',''),(2613705,'1','201','1037',478,'Retail Sale Id 1461402',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 15:54:01','',''),(2613706,'1','201','1037',478,'Retail Sale Id 1461403',2400.00,0.00,0.00,4.00,248.00,'2022-02-06 15:59:14','',''),(2613707,'1','201','1037',478,'Retail Sale Id 1461404',600.00,0.00,0.00,1.00,62.00,'2022-02-06 16:03:36','',''),(2613708,'1','201','1037',478,'Retail Sale Id 1461404',600.00,0.00,0.00,1.00,62.00,'2022-02-06 16:03:36','',''),(2613709,'1','201','1037',478,'Retail Sale Id 1461405',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 16:26:53','',''),(2613710,'1','201','1037',478,'Retail Sale Id 1461405',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 16:26:53','',''),(2613711,'1','201','1037',478,'Retail Sale Id 1461406',3600.00,0.00,0.00,6.00,372.00,'2022-02-06 16:33:02','',''),(2613712,'1','201','1037',478,'Retail Sale Id 1461407',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 16:42:29','',''),(2613713,'1','201','1037',478,'Retail Sale Id 1461408',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 16:47:57','',''),(2613714,'1','201','1037',478,'Retail Sale Id 1461409',900.00,0.00,0.00,1.50,93.00,'2022-02-06 16:54:14','',''),(2613715,'1','201','1037',478,'Retail Sale Id 1461410',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 16:55:19','',''),(2613716,'1','201','1037',478,'Retail Sale Id 1461411',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 17:05:33','',''),(2613717,'1','201','1037',478,'Retail Sale Id 1461412',1200.00,0.00,0.00,2.00,124.00,'2022-02-06 17:07:41','',''),(2613718,'1','201','1037',478,'Retail Sale Id 1461413',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 17:12:01','',''),(2613719,'1','201','1037',478,'Retail Sale Id 1461414',2400.00,0.00,0.00,4.00,248.00,'2022-02-06 17:18:05','',''),(2613720,'1','201','1037',478,'Retail Sale Id 1461415',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 17:22:28','',''),(2613721,'1','201','1037',478,'Retail Sale Id 1461416',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 17:28:00','',''),(2613722,'1','201','1037',478,'Retail Sale Id 1461416',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 17:28:00','',''),(2613723,'1','201','1037',478,'Retail Sale Id 1461417',1002.00,0.00,0.00,1.67,103.54,'2022-02-06 17:28:50','',''),(2613724,'1','201','1037',478,'Retail Sale Id 1461418',600.00,0.00,0.00,1.00,62.00,'2022-02-06 17:32:53','',''),(2613725,'1','201','1037',478,'Retail Sale Id 1461419',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 17:33:56','',''),(2613726,'1','201','1037',478,'Retail Sale Id 1461420',3000.00,0.00,0.00,5.00,310.00,'2022-02-06 17:48:46','',''),(2613727,'1','201','1037',478,'Retail Sale Id 1461421',1998.00,0.00,0.00,3.33,206.46,'2022-02-06 17:49:39','',''),(2613728,'1','201','1037',478,'Retail Sale Id 1461422',1800.00,0.00,0.00,3.00,186.00,'2022-02-06 18:01:35','',''),(2613729,'1','201','1037',478,'Retail Sale Id 1461423',114.00,0.00,0.00,0.19,11.78,'2022-02-06 19:16:04','',''),(2613730,'1','201','1037',478,'Retail Sale Id 1461424',6000.00,0.00,0.00,10.00,620.00,'2022-02-07 08:36:27','',''),(2613731,'1','201','1037',478,'Retail Sale Id 1461425',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 08:44:21','',''),(2613732,'1','201','1037',478,'Retail Sale Id 1461426',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 09:24:33','',''),(2613733,'1','201','1037',478,'Retail Sale Id 1461427',7800.00,0.00,0.00,13.00,806.00,'2022-02-07 09:26:10','',''),(2613734,'1','201','1037',478,'Retail Sale Id 1461429',7200.00,0.00,0.00,12.00,744.00,'2022-02-07 10:03:39','',''),(2613735,'1','201','1037',478,'Retail Sale Id 1461430',1200.00,0.00,0.00,2.00,124.00,'2022-02-07 10:06:27','',''),(2613736,'1','201','1037',478,'Retail Sale Id 1461431',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 10:24:19','',''),(2613737,'1','201','1037',478,'Retail Sale Id 1461432',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 10:30:20','',''),(2613738,'1','201','1037',478,'Retail Sale Id 1461433',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 10:32:01','',''),(2613739,'1','201','1037',478,'Retail Sale Id 1461434',1998.00,0.00,0.00,3.33,206.46,'2022-02-07 10:43:23','',''),(2613740,'1','201','1037',478,'Retail Sale Id 1461435',1602.00,0.00,0.00,2.67,165.54,'2022-02-07 10:44:55','',''),(2613741,'1','201','1037',478,'Retail Sale Id 1461436',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 10:51:33','',''),(2613742,'1','201','1037',478,'Retail Sale Id 1461437',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 10:56:48','',''),(2613743,'1','201','1037',478,'Retail Sale Id 1461438',9300.00,0.00,0.00,15.50,961.00,'2022-02-07 11:19:07','',''),(2613744,'1','201','1037',478,'Retail Sale Id 1461439',7500.00,0.00,0.00,12.50,775.00,'2022-02-07 11:40:06','',''),(2613745,'1','201','1037',478,'Retail Sale Id 1461440',28500.00,0.00,0.00,50.00,1600.00,'2022-02-07 11:44:28','',''),(2613746,'1','201','1037',478,'Retail Sale Id 1461441',2400.00,0.00,0.00,4.00,248.00,'2022-02-07 11:46:23','',''),(2613747,'1','201','1037',478,'Retail Sale Id 1461442',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 11:53:07','',''),(2613748,'1','201','1037',478,'Retail Sale Id 1461443',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 11:55:39','',''),(2613749,'1','201','1037',478,'Retail Sale Id 1461444',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 12:03:29','',''),(2613750,'1','201','1037',478,'Retail Sale Id 1461445',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 12:08:35','',''),(2613751,'1','201','1037',478,'Retail Sale Id 1461446',4200.00,0.00,0.00,7.00,434.00,'2022-02-07 12:14:06','',''),(2613752,'1','201','1037',478,'Retail Sale Id 1461447',3000.00,0.00,0.00,5.00,310.00,'2022-02-07 12:18:43','',''),(2613753,'1','201','1037',478,'Retail Sale Id 1461449',1200.00,0.00,0.00,2.00,124.00,'2022-02-07 12:43:34','',''),(2613754,'1','201','1037',478,'Retail Sale Id 1461450',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 12:50:38','',''),(2613755,'1','201','1037',478,'Retail Sale Id 1461451',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 13:00:39','',''),(2613756,'1','201','1037',478,'Retail Sale Id 1461452',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 13:07:08','',''),(2613757,'1','201','1037',478,'Retail Sale Id 1461453',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 13:49:21','',''),(2613758,'1','201','1037',478,'Retail Sale Id 1461454',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 13:50:32','',''),(2613759,'1','201','1037',478,'Retail Sale Id 1461455',7500.00,0.00,0.00,12.50,775.00,'2022-02-07 14:14:35','',''),(2613760,'1','201','1037',478,'Retail Sale Id 1461456',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 14:31:18','',''),(2613761,'1','201','1037',478,'Retail Sale Id 1461457',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 14:32:23','',''),(2613762,'1','201','1037',478,'Retail Sale Id 1461458',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 14:42:03','',''),(2613763,'1','201','1037',478,'Retail Sale Id 1461459',3000.00,0.00,0.00,5.00,310.00,'2022-02-07 14:54:17','',''),(2613764,'1','201','1037',478,'Retail Sale Id 1461460',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 14:54:59','',''),(2613765,'1','201','1037',478,'Retail Sale Id 1461461',7500.00,0.00,0.00,12.50,775.00,'2022-02-07 15:13:05','',''),(2613766,'1','201','1037',478,'Retail Sale Id 1461462',3000.00,0.00,0.00,5.00,310.00,'2022-02-07 15:17:39','',''),(2613767,'1','201','1037',478,'Retail Sale Id 1461463',1200.00,0.00,0.00,2.00,124.00,'2022-02-07 15:27:19','',''),(2613768,'1','201','1037',478,'Retail Sale Id 1461464',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 15:38:51','',''),(2613769,'1','201','1037',478,'Retail Sale Id 1461465',4800.00,0.00,0.00,8.00,496.00,'2022-02-07 15:44:35','',''),(2613770,'1','201','1037',478,'Retail Sale Id 1461466',1200.00,0.00,0.00,2.00,124.00,'2022-02-07 15:51:08','',''),(2613771,'1','201','1037',478,'Retail Sale Id 1461467',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 15:58:56','',''),(2613772,'1','201','1037',478,'Retail Sale Id 1461468',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 15:59:56','',''),(2613773,'1','201','1037',478,'Retail Sale Id 1461469',7500.00,0.00,0.00,12.50,775.00,'2022-02-07 16:00:48','',''),(2613774,'1','201','1037',478,'Retail Sale Id 1461470',1200.00,0.00,0.00,2.00,124.00,'2022-02-07 16:01:42','',''),(2613775,'1','201','1037',478,'Retail Sale Id 1461471',2400.00,0.00,0.00,4.00,248.00,'2022-02-07 16:04:54','',''),(2613776,'1','201','1037',478,'Retail Sale Id 1461472',1200.00,0.00,0.00,2.00,124.00,'2022-02-07 16:07:40','',''),(2613777,'1','201','1037',478,'Retail Sale Id 1461473',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 16:15:14','',''),(2613778,'1','201','1037',478,'Retail Sale Id 1461474',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 16:18:10','',''),(2613779,'1','201','1037',478,'Retail Sale Id 1461475',3000.00,0.00,0.00,5.00,310.00,'2022-02-07 16:29:25','',''),(2613780,'1','201','1037',478,'Retail Sale Id 1461476',3000.00,0.00,0.00,5.00,310.00,'2022-02-07 16:31:26','',''),(2613781,'1','201','1037',478,'Retail Sale Id 1461477',1200.00,0.00,0.00,2.00,124.00,'2022-02-07 16:46:07','',''),(2613782,'1','201','1037',478,'Retail Sale Id 1461478',4200.00,0.00,0.00,7.00,434.00,'2022-02-07 16:47:55','',''),(2613783,'1','201','1037',478,'Retail Sale Id 1461479',1002.00,0.00,0.00,1.67,103.54,'2022-02-07 16:50:42','',''),(2613784,'1','201','1037',478,'Retail Sale Id 1461480',1200.00,0.00,0.00,2.00,124.00,'2022-02-07 16:54:48','',''),(2613785,'1','201','1037',478,'Retail Sale Id 1461481',7200.00,0.00,0.00,12.00,744.00,'2022-02-07 16:55:52','',''),(2613786,'1','201','1037',478,'Retail Sale Id 1461482',7500.00,0.00,0.00,12.50,775.00,'2022-02-07 17:02:41','',''),(2613787,'1','201','1037',478,'Retail Sale Id 1461483',498.00,0.00,0.00,0.83,51.46,'2022-02-07 17:08:28','',''),(2613788,'1','201','1037',478,'Retail Sale Id 1461484',2400.00,0.00,0.00,4.00,248.00,'2022-02-07 17:14:06','',''),(2613789,'1','201','1037',478,'Retail Sale Id 1461485',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 17:20:21','',''),(2613790,'1','201','1037',478,'Retail Sale Id 1461486',2502.00,0.00,0.00,4.17,258.54,'2022-02-07 17:27:47','',''),(2613791,'1','201','1037',478,'Retail Sale Id 1461487',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 17:28:57','',''),(2613792,'1','201','1037',478,'Retail Sale Id 1461488',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 17:29:54','',''),(2613793,'1','201','1037',478,'Retail Sale Id 1461489',3000.00,0.00,0.00,5.00,310.00,'2022-02-07 17:31:33','',''),(2613794,'1','201','1037',478,'Retail Sale Id 1461490',498.00,0.00,0.00,0.83,51.46,'2022-02-07 17:32:31','',''),(2613795,'1','201','1037',478,'Retail Sale Id 1461491',1200.00,0.00,0.00,2.00,124.00,'2022-02-07 17:33:43','',''),(2613796,'1','201','1037',478,'Retail Sale Id 1461492',1002.00,0.00,0.00,1.67,103.54,'2022-02-07 17:37:10','',''),(2613797,'1','201','1037',478,'Retail Sale Id 1461493',3000.00,0.00,0.00,5.00,310.00,'2022-02-07 17:52:28','',''),(2613798,'1','201','1037',478,'Retail Sale Id 1461494',3600.00,0.00,0.00,6.00,372.00,'2022-02-07 17:53:24','',''),(2613799,'1','201','1037',478,'Retail Sale Id 1461495',2400.00,0.00,0.00,4.00,248.00,'2022-02-07 17:54:54','',''),(2613800,'1','201','1037',478,'Retail Sale Id 1461496',3000.00,0.00,0.00,5.00,310.00,'2022-02-07 17:55:48','',''),(2613801,'1','201','1037',478,'Retail Sale Id 1461497',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 18:10:24','',''),(2613802,'1','201','1037',478,'Retail Sale Id 1461498',1800.00,0.00,0.00,3.00,186.00,'2022-02-07 18:11:48','',''),(2613803,'1','201','1037',478,'Retail Sale Id 1461499',3000.00,0.00,0.00,5.00,310.00,'2022-02-07 18:50:20','',''),(2613804,'1','201','1037',478,'Return of Retail Sale Id 1461493',0.00,3000.00,5.00,0.00,-310.00,'2022-02-07 19:34:29','',''),(2613805,'1','201','1037',478,'Retail Sale Id 1461500',2574.00,0.00,0.00,4.29,265.98,'2022-02-07 19:36:15','',''),(2613806,'1','201','1037',478,'Retail Sale Id 1461501',2502.00,0.00,0.00,4.17,258.54,'2022-02-08 07:38:42','',''),(2613807,'1','201','1037',478,'Retail Sale Id 1461502',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 07:44:35','',''),(2613808,'1','201','1037',478,'Retail Sale Id 1461504',1500.00,0.00,0.00,2.50,155.00,'2022-02-08 08:15:26','',''),(2613809,'1','201','1037',478,'Retail Sale Id 1461505',498.00,0.00,0.00,0.83,51.46,'2022-02-08 08:42:26','',''),(2613810,'1','201','1037',478,'Retail Sale Id 1461506',6000.00,0.00,0.00,10.00,620.00,'2022-02-08 08:45:55','',''),(2613811,'1','201','1037',478,'Retail Sale Id 1461507',4200.00,0.00,0.00,7.00,434.00,'2022-02-08 08:47:57','',''),(2613812,'1','201','1037',478,'Retail Sale Id 1461508',4200.00,0.00,0.00,7.00,434.00,'2022-02-08 08:50:16','',''),(2613813,'1','201','1037',478,'Retail Sale Id 1461509',3000.00,0.00,0.00,5.00,310.00,'2022-02-08 09:00:50','',''),(2613814,'1','201','1037',478,'Retail Sale Id 1461510',7500.00,0.00,0.00,12.50,775.00,'2022-02-08 09:04:00','',''),(2613815,'1','201','1037',478,'Retail Sale Id 1461511',7500.00,0.00,0.00,12.50,775.00,'2022-02-08 09:24:01','',''),(2613816,'1','201','1037',478,'Retail Sale Id 1461512',2400.00,0.00,0.00,4.00,248.00,'2022-02-08 09:31:10','',''),(2613817,'1','201','1037',478,'Retail Sale Id 1461513',3600.00,0.00,0.00,6.00,372.00,'2022-02-08 09:34:34','',''),(2613818,'1','201','1037',478,'Retail Sale Id 1461514',3000.00,0.00,0.00,5.00,310.00,'2022-02-08 10:26:47','',''),(2613819,'1','201','1037',478,'Retail Sale Id 1461515',3000.00,0.00,0.00,5.00,310.00,'2022-02-08 10:41:09','',''),(2613820,'1','201','1037',478,'Retail Sale Id 1461516',3600.00,0.00,0.00,6.00,372.00,'2022-02-08 10:46:52','',''),(2613821,'1','201','1037',478,'Retail Sale Id 1461517',1500.00,0.00,0.00,2.50,155.00,'2022-02-08 11:50:18','',''),(2613822,'1','201','1037',478,'Retail Sale Id 1461518',1200.00,0.00,0.00,2.00,124.00,'2022-02-08 11:54:43','',''),(2613823,'1','201','1037',478,'Retail Sale Id 1461519',3000.00,0.00,0.00,5.00,310.00,'2022-02-08 11:59:07','',''),(2613824,'1','201','1037',478,'Retail Sale Id 1461520',7500.00,0.00,0.00,12.50,775.00,'2022-02-08 12:03:11','',''),(2613825,'1','201','1037',478,'Retail Sale Id 1461521',2700.00,0.00,0.00,4.50,279.00,'2022-02-08 12:07:48','',''),(2613826,'1','201','1037',478,'Retail Sale Id 1461522',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 12:18:32','',''),(2613827,'1','201','1037',478,'Retail Sale Id 1461523',3600.00,0.00,0.00,6.00,372.00,'2022-02-08 12:35:05','',''),(2613828,'1','201','1037',478,'Retail Sale Id 1461524',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 12:40:51','',''),(2613829,'1','201','1037',478,'Retail Sale Id 1461525',3600.00,0.00,0.00,6.00,372.00,'2022-02-08 12:42:10','',''),(2613830,'1','201','1037',478,'Retail Sale Id 1461526',10800.00,0.00,0.00,18.00,1116.00,'2022-02-08 12:43:48','',''),(2613831,'1','201','1037',478,'Retail Sale Id 1461527',6000.00,0.00,0.00,10.00,620.00,'2022-02-08 12:44:45','',''),(2613832,'1','201','1037',478,'Retail Sale Id 1461528',1200.00,0.00,0.00,2.00,124.00,'2022-02-08 12:49:05','',''),(2613833,'1','201','1037',478,'Retail Sale Id 1461529',2400.00,0.00,0.00,4.00,248.00,'2022-02-08 12:52:19','',''),(2613834,'1','201','1037',478,'Retail Sale Id 1461530',4200.00,0.00,0.00,7.00,434.00,'2022-02-08 13:00:55','',''),(2613835,'1','201','1037',478,'Retail Sale Id 1461531',3600.00,0.00,0.00,6.00,372.00,'2022-02-08 13:01:57','',''),(2613836,'1','201','1037',478,'Retail Sale Id 1461532',3000.00,0.00,0.00,5.00,310.00,'2022-02-08 13:12:42','',''),(2613837,'1','201','1037',478,'Retail Sale Id 1461533',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 13:24:46','',''),(2613838,'1','201','1037',478,'Retail Sale Id 1461534',3600.00,0.00,0.00,6.00,372.00,'2022-02-08 13:42:34','',''),(2613839,'1','201','1037',478,'Retail Sale Id 1461535',1200.00,0.00,0.00,2.00,124.00,'2022-02-08 13:55:23','',''),(2613840,'1','201','1037',478,'Retail Sale Id 1461536',1998.00,0.00,0.00,3.33,206.46,'2022-02-08 13:59:36','',''),(2613841,'1','201','1037',478,'Retail Sale Id 1461537',3000.00,0.00,0.00,5.00,310.00,'2022-02-08 14:04:03','',''),(2613842,'1','201','1037',478,'Retail Sale Id 1461538',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 14:17:26','',''),(2613843,'1','201','1037',478,'Retail Sale Id 1461539',7500.00,0.00,0.00,12.50,775.00,'2022-02-08 14:27:59','',''),(2613844,'1','201','1037',478,'Retail Sale Id 1461540',1200.00,0.00,0.00,2.00,124.00,'2022-02-08 14:31:18','',''),(2613845,'1','201','1037',478,'Retail Sale Id 1461541',3000.00,0.00,0.00,5.00,310.00,'2022-02-08 14:32:51','',''),(2613846,'1','201','1037',478,'Retail Sale Id 1461542',7500.00,0.00,0.00,12.50,775.00,'2022-02-08 14:36:41','',''),(2613847,'1','201','1037',478,'Retail Sale Id 1461543',5400.00,0.00,0.00,9.00,558.00,'2022-02-08 15:13:09','',''),(2613848,'1','201','1037',478,'Retail Sale Id 1461544',1200.00,0.00,0.00,2.00,124.00,'2022-02-08 15:18:27','',''),(2613849,'1','201','1037',478,'Retail Sale Id 1461545',1200.00,0.00,0.00,2.00,124.00,'2022-02-08 15:19:28','',''),(2613850,'1','201','1037',478,'Retail Sale Id 1461546',1200.00,0.00,0.00,2.00,124.00,'2022-02-08 15:20:23','',''),(2613851,'1','201','1037',478,'Retail Sale Id 1461547',1302.00,0.00,0.00,2.17,134.54,'2022-02-08 15:24:51','',''),(2613852,'1','201','1037',478,'Retail Sale Id 1461548',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 15:36:25','',''),(2613853,'1','201','1037',478,'Retail Sale Id 1461548',3900.00,0.00,0.00,6.50,403.00,'2022-02-08 15:36:25','',''),(2613854,'1','201','1037',478,'Retail Sale Id 1461549',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 15:43:32','',''),(2613855,'1','201','1037',478,'Retail Sale Id 1461550',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 15:56:32','',''),(2613856,'1','201','1037',478,'Retail Sale Id 1461552',1902.00,0.00,0.00,3.17,196.54,'2022-02-08 16:06:32','',''),(2613857,'1','201','1037',478,'Retail Sale Id 1461553',1200.00,0.00,0.00,2.00,124.00,'2022-02-08 16:19:37','',''),(2613858,'1','201','1037',478,'Retail Sale Id 1461554',3600.00,0.00,0.00,6.00,372.00,'2022-02-08 16:46:07','',''),(2613859,'1','201','1037',478,'Retail Sale Id 1461555',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 16:48:46','',''),(2613860,'1','201','1037',478,'Retail Sale Id 1461556',2400.00,0.00,0.00,4.00,248.00,'2022-02-08 16:50:18','',''),(2613861,'1','201','1037',478,'Retail Sale Id 1461557',600.00,0.00,0.00,1.00,62.00,'2022-02-08 16:51:13','',''),(2613862,'1','201','1037',478,'Retail Sale Id 1461558',300.00,0.00,0.00,0.50,31.00,'2022-02-08 16:52:02','',''),(2613863,'1','201','1037',478,'Retail Sale Id 1461559',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 16:52:51','',''),(2613864,'1','201','1037',478,'Retail Sale Id 1461560',3000.00,0.00,0.00,5.00,310.00,'2022-02-08 17:14:11','',''),(2613865,'1','201','1037',478,'Retail Sale Id 1461561',4800.00,0.00,0.00,8.00,496.00,'2022-02-08 17:24:31','',''),(2613866,'1','201','1037',478,'Retail Sale Id 1461562',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 17:28:47','',''),(2613867,'1','201','1037',478,'Retail Sale Id 1461563',7500.00,0.00,0.00,12.50,775.00,'2022-02-08 17:32:21','',''),(2613868,'1','201','1037',478,'Retail Sale Id 1461564',3600.00,0.00,0.00,6.00,372.00,'2022-02-08 17:49:03','',''),(2613869,'1','201','1037',478,'Retail Sale Id 1461565',600.00,0.00,0.00,1.00,62.00,'2022-02-08 17:54:17','',''),(2613870,'1','201','1037',478,'Retail Sale Id 1461566',1200.00,0.00,0.00,2.00,124.00,'2022-02-08 18:00:02','',''),(2613871,'1','201','1037',478,'Retail Sale Id 1461567',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 18:02:01','',''),(2613872,'1','201','1037',478,'Retail Sale Id 1461568',1800.00,0.00,0.00,3.00,186.00,'2022-02-08 18:03:48','',''),(2613873,'1','201','1037',478,'Retail Sale Id 1461569',1710.00,0.00,0.00,3.00,96.00,'2022-02-08 18:40:04','',''),(2613874,'1','201','1037',478,'Retail Sale Id 1461570',7500.00,0.00,0.00,12.50,775.00,'2022-02-08 18:41:53','',''),(2613875,'1','201','1037',478,'Return of Retail Sale Id 1461560',0.00,3000.00,5.00,0.00,-310.00,'2022-02-08 19:22:20','',''),(2613876,'1','201','1037',478,'Retail Sale Id 1461571',2916.00,0.00,0.00,4.86,301.32,'2022-02-08 19:23:01','',''),(2613877,'1','201','1037',478,'Retail Sale Id 1461572',2400.00,0.00,0.00,4.00,248.00,'2022-02-09 08:16:19','',''),(2613878,'1','201','1037',478,'Retail Sale Id 1461573',4200.00,0.00,0.00,7.00,434.00,'2022-02-09 08:23:19','',''),(2613879,'1','201','1037',478,'Retail Sale Id 1461574',11400.00,0.00,0.00,20.00,640.00,'2022-02-09 08:38:19','',''),(2613880,'1','201','1037',478,'Retail Sale Id 1461576',4200.00,0.00,0.00,7.00,434.00,'2022-02-09 08:58:40','',''),(2613881,'1','201','1037',478,'Retail Sale Id 1461577',3000.00,0.00,0.00,5.00,310.00,'2022-02-09 09:06:31','',''),(2613882,'1','201','1037',478,'Retail Sale Id 1461578',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 09:33:06','',''),(2613883,'1','201','1037',478,'Retail Sale Id 1461579',6000.00,0.00,0.00,10.00,620.00,'2022-02-09 10:12:03','',''),(2613884,'1','201','1037',478,'Retail Sale Id 1461580',3000.00,0.00,0.00,5.00,310.00,'2022-02-09 10:13:09','',''),(2613885,'1','201','1037',478,'Retail Sale Id 1461581',4200.00,0.00,0.00,7.00,434.00,'2022-02-09 10:14:18','',''),(2613886,'1','201','1037',478,'Retail Sale Id 1461582',4500.00,0.00,0.00,7.50,465.00,'2022-02-09 10:21:57','',''),(2613887,'1','201','1037',478,'Retail Sale Id 1461583',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 10:24:42','',''),(2613888,'1','201','1037',478,'Retail Sale Id 1461584',5502.00,0.00,0.00,9.17,568.54,'2022-02-09 10:47:46','',''),(2613889,'1','201','1037',478,'Retail Sale Id 1461585',600.00,0.00,0.00,1.00,62.00,'2022-02-09 11:08:58','',''),(2613890,'1','201','1037',478,'Retail Sale Id 1461586',600.00,0.00,0.00,1.00,62.00,'2022-02-09 11:26:25','',''),(2613891,'1','201','1037',478,'Retail Sale Id 1461587',7500.00,0.00,0.00,12.50,775.00,'2022-02-09 11:28:57','',''),(2613892,'1','201','1037',478,'Retail Sale Id 1461588',2400.00,0.00,0.00,4.00,248.00,'2022-02-09 11:31:13','',''),(2613893,'1','201','1037',478,'Retail Sale Id 1461589',7500.00,0.00,0.00,12.50,775.00,'2022-02-09 11:35:01','',''),(2613894,'1','201','1037',478,'Retail Sale Id 1461590',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 11:36:06','',''),(2613895,'1','201','1037',478,'Retail Sale Id 1461591',3600.00,0.00,0.00,6.00,372.00,'2022-02-09 12:13:52','',''),(2613896,'1','201','1037',478,'Retail Sale Id 1461592',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 12:21:15','',''),(2613897,'1','201','1037',478,'Retail Sale Id 1461593',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 12:42:29','',''),(2613898,'1','201','1037',478,'Retail Sale Id 1461594',3900.00,0.00,0.00,6.50,403.00,'2022-02-09 12:43:43','',''),(2613899,'1','201','1037',478,'Retail Sale Id 1461595',2400.00,0.00,0.00,4.00,248.00,'2022-02-09 13:00:47','',''),(2613900,'1','201','1037',478,'Retail Sale Id 1461596',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 13:23:27','',''),(2613901,'1','201','1037',478,'Retail Sale Id 1461597',3000.00,0.00,0.00,5.00,310.00,'2022-02-09 13:29:02','',''),(2613902,'1','201','1037',478,'Retail Sale Id 1461598',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 13:50:40','',''),(2613903,'1','201','1037',478,'Retail Sale Id 1461599',3000.00,0.00,0.00,5.00,310.00,'2022-02-09 13:59:27','',''),(2613904,'1','201','1037',478,'Retail Sale Id 1461600',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 14:01:07','',''),(2613905,'1','201','1037',478,'Retail Sale Id 1461601',1500.00,0.00,0.00,2.50,155.00,'2022-02-09 14:02:26','',''),(2613906,'1','201','1037',478,'Retail Sale Id 1461602',4500.00,0.00,0.00,7.50,465.00,'2022-02-09 14:12:46','',''),(2613907,'1','201','1037',478,'Retail Sale Id 1461603',498.00,0.00,0.00,0.83,51.46,'2022-02-09 14:14:26','',''),(2613908,'1','201','1037',478,'Retail Sale Id 1461604',6498.00,0.00,0.00,10.83,671.46,'2022-02-09 14:20:01','',''),(2613909,'1','201','1037',478,'Retail Sale Id 1461605',3000.00,0.00,0.00,5.00,310.00,'2022-02-09 14:29:35','',''),(2613910,'1','201','1037',478,'Retail Sale Id 1461606',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 14:48:34','',''),(2613911,'1','201','1037',478,'Retail Sale Id 1461607',6000.00,0.00,0.00,10.00,620.00,'2022-02-09 15:03:01','',''),(2613912,'1','201','1037',478,'Retail Sale Id 1461608',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 15:03:59','',''),(2613913,'1','201','1037',478,'Retail Sale Id 1461609',8550.00,0.00,0.00,15.00,480.00,'2022-02-09 15:06:41','',''),(2613914,'1','201','1037',478,'Retail Sale Id 1461610',3600.00,0.00,0.00,6.00,372.00,'2022-02-09 15:08:08','',''),(2613915,'1','201','1037',478,'Retail Sale Id 1461611',3600.00,0.00,0.00,6.00,372.00,'2022-02-09 15:10:10','',''),(2613916,'1','201','1037',478,'Retail Sale Id 1461612',8048.40,0.00,0.00,14.12,451.84,'2022-02-09 15:14:08','',''),(2613917,'1','201','1037',478,'Retail Sale Id 1461613',3000.00,0.00,0.00,5.00,310.00,'2022-02-09 15:16:49','',''),(2613918,'1','201','1037',478,'Retail Sale Id 1461614',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 15:19:12','',''),(2613919,'1','201','1037',478,'Retail Sale Id 1461614',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 15:19:12','',''),(2613920,'1','201','1037',478,'Retail Sale Id 1461616',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 15:20:13','',''),(2613921,'1','201','1037',478,'Retail Sale Id 1461617',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 15:29:49','',''),(2613922,'1','201','1037',478,'Retail Sale Id 1461618',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 15:31:10','',''),(2613923,'1','201','1037',478,'Return of Retail Sale Id 1461609',0.00,8550.00,15.00,0.00,-480.00,'2022-02-09 15:34:02','',''),(2613924,'1','201','1037',478,'Retail Sale Id 1461619',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 15:53:07','',''),(2613925,'1','201','1037',478,'Retail Sale Id 1461620',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 16:02:26','',''),(2613926,'1','201','1037',478,'Retail Sale Id 1461621',3600.00,0.00,0.00,6.00,372.00,'2022-02-09 16:06:42','',''),(2613927,'1','201','1037',478,'Retail Sale Id 1461622',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 16:10:11','',''),(2613928,'1','201','1037',478,'Retail Sale Id 1461623',7125.00,0.00,0.00,12.50,400.00,'2022-02-09 16:16:23','',''),(2613929,'1','201','1037',478,'Retail Sale Id 1461624',4002.00,0.00,0.00,6.67,413.54,'2022-02-09 16:18:21','',''),(2613930,'1','201','1037',478,'Retail Sale Id 1461625',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 16:29:24','',''),(2613931,'1','201','1037',478,'Retail Sale Id 1461626',1998.00,0.00,0.00,3.33,206.46,'2022-02-09 16:32:26','',''),(2613932,'1','201','1037',478,'Retail Sale Id 1461627',600000.00,0.00,0.00,1000.00,62000.00,'2022-02-09 16:45:14','',''),(2613933,'1','201','1037',478,'Return of Retail Sale Id 1461627',0.00,600000.00,1000.00,0.00,-62000.00,'2022-02-09 16:55:10','',''),(2613934,'1','201','1037',478,'Retail Sale Id 1461628',1002.00,0.00,0.00,1.67,103.54,'2022-02-09 16:57:02','',''),(2613935,'1','201','1037',478,'Retail Sale Id 1461629',25650.00,0.00,0.00,45.00,1440.00,'2022-02-09 17:09:24','',''),(2613936,'1','201','1037',478,'Retail Sale Id 1461630',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 17:15:48','',''),(2613937,'1','201','1037',478,'Retail Sale Id 1461631',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 17:19:36','',''),(2613938,'1','201','1037',478,'Retail Sale Id 1461632',2400.00,0.00,0.00,4.00,248.00,'2022-02-09 17:20:29','',''),(2613939,'1','201','1037',478,'Retail Sale Id 1461633',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 17:23:52','',''),(2613940,'1','201','1037',478,'Retail Sale Id 1461633',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 17:23:52','',''),(2613941,'1','201','1037',478,'Retail Sale Id 1461634',1800.00,0.00,0.00,3.00,186.00,'2022-02-09 17:37:03','',''),(2613942,'1','201','1037',478,'Retail Sale Id 1461635',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 17:47:16','',''),(2613943,'1','201','1037',478,'Retail Sale Id 1461636',3600.00,0.00,0.00,6.00,372.00,'2022-02-09 18:04:29','',''),(2613944,'1','201','1037',478,'Retail Sale Id 1461637',3600.00,0.00,0.00,6.00,372.00,'2022-02-09 18:05:25','',''),(2613945,'1','201','1037',478,'Retail Sale Id 1461638',1200.00,0.00,0.00,2.00,124.00,'2022-02-09 18:08:45','',''),(2613946,'1','201','1037',478,'Retail Sale Id 1461639',4800.00,0.00,0.00,8.00,496.00,'2022-02-09 18:15:29','',''),(2613947,'1','201','1037',478,'Return of Retail Sale Id 1461639',0.00,4800.00,8.00,0.00,-496.00,'2022-02-09 18:23:47','',''),(2613948,'1','201','1037',478,'Return of Retail Sale Id 1461634',0.00,1800.00,3.00,0.00,-186.00,'2022-02-09 18:25:49','',''),(2613949,'1','201','1037',478,'Return of Retail Sale Id 1461635',0.00,1200.00,2.00,0.00,-124.00,'2022-02-09 18:26:54','',''),(2613950,'1','201','1037',478,'Return of Retail Sale Id 1461638',0.00,1200.00,2.00,0.00,-124.00,'2022-02-09 18:27:44','',''),(2613951,'1','201','1037',478,'Return of Retail Sale Id 1461637',0.00,3600.00,6.00,0.00,-372.00,'2022-02-09 18:28:22','',''),(2613952,'1','201','1037',478,'Return of Retail Sale Id 1461636',0.00,3600.00,6.00,0.00,-372.00,'2022-02-09 18:29:08','',''),(2613953,'1','201','1037',478,'Return of Retail Sale Id 1461633',0.00,1200.00,2.00,0.00,-124.00,'2022-02-09 18:48:02','',''),(2613954,'1','201','1037',478,'Return of Retail Sale Id 1461633',0.00,1200.00,2.00,0.00,-124.00,'2022-02-09 18:48:02','',''),(2613955,'1','201','1037',478,'Retail Sale Id 1461640',1896.00,0.00,0.00,3.16,195.92,'2022-02-09 18:48:53','',''),(2613956,'1','201','1037',478,'Retail Sale Id 1461641',1998.00,0.00,0.00,3.33,206.46,'2022-02-10 08:23:14','',''),(2613957,'1','201','1037',478,'Retail Sale Id 1461642',3600.00,0.00,0.00,6.00,372.00,'2022-02-10 08:35:07','',''),(2613958,'1','201','1037',478,'Retail Sale Id 1461643',2400.00,0.00,0.00,4.00,248.00,'2022-02-10 08:53:34','',''),(2613959,'1','201','1037',478,'Retail Sale Id 1461644',4200.00,0.00,0.00,7.00,434.00,'2022-02-10 09:01:54','',''),(2613960,'1','201','1037',478,'Retail Sale Id 1461645',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 09:29:51','',''),(2613961,'1','201','1037',478,'Retail Sale Id 1461646',600.00,0.00,0.00,1.00,62.00,'2022-02-10 09:37:13','',''),(2613962,'1','201','1037',478,'Retail Sale Id 1461647',7500.00,0.00,0.00,12.50,775.00,'2022-02-10 09:55:36','',''),(2613963,'1','201','1037',478,'Retail Sale Id 1461648',1002.00,0.00,0.00,1.67,103.54,'2022-02-10 10:19:36','',''),(2613964,'1','201','1037',478,'Retail Sale Id 1461649',1200.00,0.00,0.00,2.00,124.00,'2022-02-10 10:27:37','',''),(2613965,'1','201','1037',478,'Retail Sale Id 1461650',3600.00,0.00,0.00,6.00,372.00,'2022-02-10 10:31:47','',''),(2613966,'1','201','1037',478,'Retail Sale Id 1461651',1998.00,0.00,0.00,3.33,206.46,'2022-02-10 10:48:45','',''),(2613967,'1','201','1037',478,'Retail Sale Id 1461652',7500.00,0.00,0.00,12.50,775.00,'2022-02-10 10:54:56','',''),(2613968,'1','201','1037',478,'Retail Sale Id 1461653',1200.00,0.00,0.00,2.00,124.00,'2022-02-10 11:15:21','',''),(2613969,'1','201','1037',478,'Retail Sale Id 1461654',3600.00,0.00,0.00,6.00,372.00,'2022-02-10 11:27:26','',''),(2613970,'1','201','1037',478,'Retail Sale Id 1461655',3600.00,0.00,0.00,6.00,372.00,'2022-02-10 11:42:19','',''),(2613971,'1','201','1037',478,'Retail Sale Id 1461656',3600.00,0.00,0.00,6.00,372.00,'2022-02-10 11:55:11','',''),(2613972,'1','201','1037',478,'Retail Sale Id 1461657',1200.00,0.00,0.00,2.00,124.00,'2022-02-10 12:02:59','',''),(2613973,'1','201','1037',478,'Retail Sale Id 1461658',3600.00,0.00,0.00,6.00,372.00,'2022-02-10 12:05:51','',''),(2613974,'1','201','1037',478,'Retail Sale Id 1461659',600.00,0.00,0.00,1.00,62.00,'2022-02-10 12:07:11','',''),(2613975,'1','201','1037',478,'Retail Sale Id 1461660',7500.00,0.00,0.00,12.50,775.00,'2022-02-10 12:13:22','',''),(2613976,'1','201','1037',478,'Retail Sale Id 1461661',7500.00,0.00,0.00,12.50,775.00,'2022-02-10 12:22:23','',''),(2613977,'1','201','1037',478,'Retail Sale Id 1461662',2400.00,0.00,0.00,4.00,248.00,'2022-02-10 12:50:30','',''),(2613978,'1','201','1037',478,'Retail Sale Id 1461663',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 12:54:15','',''),(2613979,'1','201','1037',478,'Retail Sale Id 1461664',498.00,0.00,0.00,0.83,51.46,'2022-02-10 12:58:58','',''),(2613980,'1','201','1037',478,'Retail Sale Id 1461665',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 13:00:59','',''),(2613981,'1','201','1037',478,'Retail Sale Id 1461666',3000.00,0.00,0.00,5.00,310.00,'2022-02-10 13:10:24','',''),(2613982,'1','201','1037',478,'Retail Sale Id 1461667',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 13:23:52','',''),(2613983,'1','201','1037',478,'Retail Sale Id 1461668',2400.00,0.00,0.00,4.00,248.00,'2022-02-10 13:56:00','',''),(2613984,'1','201','1037',478,'Retail Sale Id 1461669',600.00,0.00,0.00,1.00,62.00,'2022-02-10 14:33:29','',''),(2613985,'1','201','1037',478,'Retail Sale Id 1461670',3600.00,0.00,0.00,6.00,372.00,'2022-02-10 14:38:20','',''),(2613986,'1','201','1037',478,'Retail Sale Id 1461671',3000.00,0.00,0.00,5.00,310.00,'2022-02-10 14:49:48','',''),(2613987,'1','201','1037',478,'Retail Sale Id 1461672',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 15:02:12','',''),(2613988,'1','201','1037',478,'Retail Sale Id 1461673',1200.00,0.00,0.00,2.00,124.00,'2022-02-10 15:19:36','',''),(2613989,'1','201','1037',478,'Retail Sale Id 1461674',3000.00,0.00,0.00,5.00,310.00,'2022-02-10 15:41:56','',''),(2613990,'1','201','1037',478,'Retail Sale Id 1461675',600.00,0.00,0.00,1.00,62.00,'2022-02-10 15:44:41','',''),(2613991,'1','201','1037',478,'Retail Sale Id 1461676',3000.00,0.00,0.00,5.00,310.00,'2022-02-10 15:50:07','',''),(2613992,'1','201','1037',478,'Retail Sale Id 1461677',3498.00,0.00,0.00,5.83,361.46,'2022-02-10 15:54:19','',''),(2613993,'1','201','1037',478,'Retail Sale Id 1461678',600.00,0.00,0.00,1.00,62.00,'2022-02-10 16:00:17','',''),(2613994,'1','201','1037',478,'Retail Sale Id 1461679',7500.00,0.00,0.00,12.50,775.00,'2022-02-10 16:05:33','',''),(2613995,'1','201','1037',478,'Retail Sale Id 1461680',1200.00,0.00,0.00,2.00,124.00,'2022-02-10 16:08:30','',''),(2613996,'1','201','1037',478,'Retail Sale Id 1461681',1200.00,0.00,0.00,2.00,124.00,'2022-02-10 16:17:15','',''),(2613997,'1','201','1037',478,'Retail Sale Id 1461682',3600.00,0.00,0.00,6.00,372.00,'2022-02-10 16:22:04','',''),(2613998,'1','201','1037',478,'Retail Sale Id 1461683',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 16:35:45','',''),(2613999,'1','201','1037',478,'Retail Sale Id 1461684',4200.00,0.00,0.00,7.00,434.00,'2022-02-10 16:39:29','',''),(2614000,'1','201','1037',478,'Retail Sale Id 1461685',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 16:54:06','',''),(2614001,'1','201','1037',478,'Retail Sale Id 1461686',1200.00,0.00,0.00,2.00,124.00,'2022-02-10 17:03:41','',''),(2614002,'1','201','1037',478,'Retail Sale Id 1461687',6600.00,0.00,0.00,11.00,682.00,'2022-02-10 17:16:31','',''),(2614003,'1','201','1037',478,'Retail Sale Id 1461688',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 17:19:45','',''),(2614004,'1','201','1037',478,'Retail Sale Id 1461690',4200.00,0.00,0.00,7.00,434.00,'2022-02-10 17:29:30','',''),(2614005,'1','201','1037',478,'Retail Sale Id 1461691',1002.00,0.00,0.00,1.67,103.54,'2022-02-10 17:36:32','',''),(2614006,'1','201','1037',478,'Retail Sale Id 1461692',600.00,0.00,0.00,1.00,62.00,'2022-02-10 17:46:17','',''),(2614007,'1','201','1037',478,'Retail Sale Id 1461693',900.00,0.00,0.00,1.50,93.00,'2022-02-10 17:47:33','',''),(2614008,'1','201','1037',478,'Retail Sale Id 1461694',600.00,0.00,0.00,1.00,62.00,'2022-02-10 17:48:47','',''),(2614009,'1','201','1037',478,'Retail Sale Id 1461695',600.00,0.00,0.00,1.00,62.00,'2022-02-10 17:56:02','',''),(2614010,'1','201','1037',478,'Retail Sale Id 1461696',402.00,0.00,0.00,0.67,41.54,'2022-02-10 17:57:15','',''),(2614011,'1','201','1037',478,'Retail Sale Id 1461697',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 18:01:34','',''),(2614012,'1','201','1037',478,'Retail Sale Id 1461698',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 18:04:08','',''),(2614013,'1','201','1037',478,'Retail Sale Id 1461699',600.00,0.00,0.00,1.00,62.00,'2022-02-10 18:11:37','',''),(2614014,'1','201','1037',478,'Return of Retail Sale Id 1461691',0.00,1002.00,1.67,0.00,-103.54,'2022-02-10 18:13:50','',''),(2614015,'1','201','1037',478,'Retail Sale Id 1461700',324.00,0.00,0.00,0.54,33.48,'2022-02-10 18:15:15','',''),(2614016,'1','201','1037',478,'Retail Sale Id 1461701',3000.00,0.00,0.00,5.00,310.00,'2022-02-10 18:26:10','',''),(2614017,'1','201','1037',478,'Retail Sale Id 1461702',1800.00,0.00,0.00,3.00,186.00,'2022-02-10 18:29:39','',''),(2614018,'1','201','1037',478,'Retail Sale Id 1461703',4200.00,0.00,0.00,7.00,434.00,'2022-02-10 18:38:35','',''),(2614019,'1','201','1037',478,'Return of Retail Sale Id 1461695',0.00,600.00,1.00,0.00,-62.00,'2022-02-10 19:12:51','',''),(2614020,'1','201','1037',478,'Retail Sale Id 1461704',444.00,0.00,0.00,0.74,45.88,'2022-02-10 19:14:03','',''),(2614021,'1','201','1037',478,'Retail Sale Id 1461705',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 07:24:03','',''),(2614022,'1','201','1037',478,'Retail Sale Id 1461706',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 07:41:58','',''),(2614023,'1','201','1037',478,'Retail Sale Id 1461707',900.00,0.00,0.00,1.50,93.00,'2022-02-11 08:00:16','',''),(2614024,'1','201','1037',478,'Retail Sale Id 1461708',1200.00,0.00,0.00,2.00,124.00,'2022-02-11 08:12:07','',''),(2614025,'1','201','1037',478,'Retail Sale Id 1461709',3600.00,0.00,0.00,6.00,372.00,'2022-02-11 08:38:21','',''),(2614026,'1','201','1037',478,'Retail Sale Id 1461710',3000.00,0.00,0.00,5.00,310.00,'2022-02-11 08:51:18','',''),(2614027,'1','201','1037',478,'Retail Sale Id 1461711',3600.00,0.00,0.00,6.00,372.00,'2022-02-11 09:03:47','',''),(2614028,'1','201','1037',478,'Retail Sale Id 1461712',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 09:17:58','',''),(2614029,'1','201','1037',478,'Retail Sale Id 1461713',2400.00,0.00,0.00,4.00,248.00,'2022-02-11 09:32:12','',''),(2614030,'1','201','1037',478,'Retail Sale Id 1461714',3600.00,0.00,0.00,6.00,372.00,'2022-02-11 09:39:33','',''),(2614031,'1','201','1037',478,'Retail Sale Id 1461715',1200.00,0.00,0.00,2.00,124.00,'2022-02-11 09:46:53','',''),(2614032,'1','201','1037',478,'Retail Sale Id 1461716',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 09:50:37','',''),(2614033,'1','201','1037',478,'Retail Sale Id 1461717',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 09:54:25','',''),(2614034,'1','201','1037',478,'Retail Sale Id 1461718',1200.00,0.00,0.00,2.00,124.00,'2022-02-11 10:21:24','',''),(2614035,'1','201','1037',478,'Retail Sale Id 1461719',3000.00,0.00,0.00,5.00,310.00,'2022-02-11 10:25:35','',''),(2614036,'1','201','1037',478,'Retail Sale Id 1461720',1002.00,0.00,0.00,1.67,103.54,'2022-02-11 10:31:25','',''),(2614037,'1','201','1037',478,'Retail Sale Id 1461721',3000.00,0.00,0.00,5.00,310.00,'2022-02-11 10:41:59','',''),(2614038,'1','201','1037',478,'Retail Sale Id 1461722',3600.00,0.00,0.00,6.00,372.00,'2022-02-11 10:52:11','',''),(2614039,'1','201','1037',478,'Retail Sale Id 1461723',3000.00,0.00,0.00,5.00,310.00,'2022-02-11 11:18:58','',''),(2614040,'1','201','1037',478,'Retail Sale Id 1461724',3498.00,0.00,0.00,5.83,361.46,'2022-02-11 11:29:40','',''),(2614041,'1','201','1037',478,'Retail Sale Id 1461725',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 11:31:15','',''),(2614042,'1','201','1037',478,'Retail Sale Id 1461726',2400.00,0.00,0.00,4.00,248.00,'2022-02-11 11:32:20','',''),(2614043,'1','201','1037',478,'Retail Sale Id 1461727',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 11:33:33','',''),(2614044,'1','201','1037',478,'Retail Sale Id 1461728',4998.00,0.00,0.00,8.33,516.46,'2022-02-11 11:34:27','',''),(2614045,'1','201','1037',478,'Retail Sale Id 1461729',3000.00,0.00,0.00,5.00,310.00,'2022-02-11 11:35:11','',''),(2614046,'1','201','1037',478,'Retail Sale Id 1461731',4002.00,0.00,0.00,6.67,413.54,'2022-02-11 11:46:10','',''),(2614047,'1','201','1037',478,'Retail Sale Id 1461732',2400.00,0.00,0.00,4.00,248.00,'2022-02-11 11:49:52','',''),(2614048,'1','201','1037',478,'Retail Sale Id 1461733',3000.00,0.00,0.00,5.00,310.00,'2022-02-11 11:57:32','',''),(2614049,'1','201','1037',478,'Retail Sale Id 1461734',2400.00,0.00,0.00,4.00,248.00,'2022-02-11 12:11:32','',''),(2614050,'1','201','1037',478,'Retail Sale Id 1461735',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 12:16:46','',''),(2614051,'1','201','1037',478,'Retail Sale Id 1461736',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 12:20:07','',''),(2614052,'1','201','1037',478,'Retail Sale Id 1461737',7500.00,0.00,0.00,12.50,775.00,'2022-02-11 12:32:13','',''),(2614053,'1','201','1037',478,'Retail Sale Id 1461738',7500.00,0.00,0.00,12.50,775.00,'2022-02-11 12:39:07','',''),(2614054,'1','201','1037',478,'Retail Sale Id 1461739',1500.00,0.00,0.00,2.50,155.00,'2022-02-11 12:50:16','',''),(2614055,'1','201','1037',478,'Retail Sale Id 1461740',9000.00,0.00,0.00,15.00,930.00,'2022-02-11 13:18:32','',''),(2614056,'1','201','1037',478,'Retail Sale Id 1461741',7200.00,0.00,0.00,12.00,744.00,'2022-02-11 13:21:08','',''),(2614057,'1','201','1037',478,'Return of Retail Sale Id 1461740',0.00,9000.00,15.00,0.00,-930.00,'2022-02-11 13:22:22','',''),(2614058,'1','201','1037',478,'Retail Sale Id 1461742',7500.00,0.00,0.00,12.50,775.00,'2022-02-11 14:17:15','',''),(2614059,'1','201','1037',478,'Retail Sale Id 1461743',3600.00,0.00,0.00,6.00,372.00,'2022-02-11 14:29:28','',''),(2614060,'1','201','1037',478,'Retail Sale Id 1461744',1200.00,0.00,0.00,2.00,124.00,'2022-02-11 14:42:50','',''),(2614061,'1','201','1037',478,'Retail Sale Id 1461745',3600.00,0.00,0.00,6.00,372.00,'2022-02-11 14:55:07','',''),(2614062,'1','201','1037',478,'Retail Sale Id 1461746',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 15:03:17','',''),(2614063,'1','201','1037',478,'Retail Sale Id 1461747',3600.00,0.00,0.00,6.00,372.00,'2022-02-11 15:12:06','',''),(2614064,'1','201','1037',478,'Retail Sale Id 1461748',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 15:13:20','',''),(2614065,'1','201','1037',478,'Retail Sale Id 1461749',1800.00,0.00,0.00,3.00,186.00,'2022-02-11 15:32:54','',''),(2614066,'1','201','1037',478,'Retail Sale Id 1461750',6000.00,0.00,0.00,10.00,620.00,'2022-02-11 15:36:40','',''),(2614067,'1','201','1037',478,'Retail Sale Id 1461751',3000.00,0.00,0.00,5.00,310.00,'2022-02-11 15:41:50','',''),(2614068,'1','201','1037',478,'Retail Sale Id 1461752',14400.00,0.00,0.00,24.00,1488.00,'2022-02-11 15:48:05','',''),(2614069,'1','201','1037',478,'Return of Retail Sale Id 1461752',0.00,14400.00,24.00,0.00,-1488.00,'2022-02-11 16:11:24','',''),(2614070,'1','201','1037',478,'Return of Retail Sale Id 1461751',0.00,3000.00,5.00,0.00,-310.00,'2022-02-11 16:12:46','',''),(2614071,'1','201','1037',478,'Retail Sale Id 1461753',2400.00,0.00,0.00,4.00,248.00,'2022-02-11 16:13:31','',''),(2614072,'1','201','1037',478,'Retail Sale Id 1461754',108.00,0.00,0.00,0.18,11.16,'2022-02-11 17:32:51','',''),(2614073,'1','201','1037',478,'Retail Sale Id 1461755',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 07:36:59','',''),(2614074,'1','201','1037',478,'Retail Sale Id 1461756',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 08:51:40','',''),(2614075,'1','201','1037',478,'Retail Sale Id 1461757',6000.00,0.00,0.00,10.00,620.00,'2022-02-12 08:59:44','',''),(2614076,'1','201','1037',478,'Retail Sale Id 1461758',3000.00,0.00,0.00,5.00,310.00,'2022-02-12 09:06:11','',''),(2614077,'1','201','1037',478,'Retail Sale Id 1461759',6840.00,0.00,0.00,12.00,384.00,'2022-02-12 09:34:59','',''),(2614078,'1','201','1037',478,'Retail Sale Id 1461760',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 09:50:15','',''),(2614079,'1','201','1037',478,'Retail Sale Id 1461761',600.00,0.00,0.00,1.00,62.00,'2022-02-12 09:56:57','',''),(2614080,'1','201','1037',478,'Retail Sale Id 1461762',1998.00,0.00,0.00,3.33,206.46,'2022-02-12 10:00:12','',''),(2614081,'1','201','1037',478,'Retail Sale Id 1461763',1002.00,0.00,0.00,1.67,103.54,'2022-02-12 10:02:19','',''),(2614082,'1','201','1037',478,'Retail Sale Id 1461764',2502.00,0.00,0.00,4.17,258.54,'2022-02-12 10:04:23','',''),(2614083,'1','201','1037',478,'Retail Sale Id 1461765',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 10:11:19','',''),(2614084,'1','201','1037',478,'Retail Sale Id 1461766',2100.00,0.00,0.00,3.50,217.00,'2022-02-12 10:24:43','',''),(2614085,'1','201','1037',478,'Retail Sale Id 1461767',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 10:27:04','',''),(2614086,'1','201','1037',478,'Retail Sale Id 1461767',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 10:27:04','',''),(2614087,'1','201','1037',478,'Retail Sale Id 1461768',3000.00,0.00,0.00,5.00,310.00,'2022-02-12 10:30:08','',''),(2614088,'1','201','1037',478,'Retail Sale Id 1461769',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 10:42:32','',''),(2614089,'1','201','1037',478,'Retail Sale Id 1461770',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 10:43:30','',''),(2614090,'1','201','1037',478,'Retail Sale Id 1461771',3000.00,0.00,0.00,5.00,310.00,'2022-02-12 10:49:39','',''),(2614091,'1','201','1037',478,'Retail Sale Id 1461772',3600.00,0.00,0.00,6.00,372.00,'2022-02-12 11:05:31','',''),(2614092,'1','201','1037',478,'Retail Sale Id 1461773',3600.00,0.00,0.00,6.00,372.00,'2022-02-12 11:07:26','',''),(2614093,'1','201','1037',478,'Retail Sale Id 1461774',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 11:11:35','',''),(2614094,'1','201','1037',478,'Retail Sale Id 1461775',2400.00,0.00,0.00,4.00,248.00,'2022-02-12 11:12:37','',''),(2614095,'1','201','1037',478,'Retail Sale Id 1461776',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 11:24:37','',''),(2614096,'1','201','1037',478,'Retail Sale Id 1461776',3600.00,0.00,0.00,6.00,372.00,'2022-02-12 11:24:37','',''),(2614097,'1','201','1037',478,'Retail Sale Id 1461777',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 11:28:31','',''),(2614098,'1','201','1037',478,'Retail Sale Id 1461778',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 11:40:20','',''),(2614099,'1','201','1037',478,'Retail Sale Id 1461779',7500.00,0.00,0.00,12.50,775.00,'2022-02-12 11:48:44','',''),(2614100,'1','201','1037',478,'Retail Sale Id 1461780',3600.00,0.00,0.00,6.00,372.00,'2022-02-12 11:51:00','',''),(2614101,'1','201','1037',478,'Retail Sale Id 1461781',1998.00,0.00,0.00,3.33,206.46,'2022-02-12 12:11:29','',''),(2614102,'1','201','1037',478,'Retail Sale Id 1461782',3000.00,0.00,0.00,5.00,310.00,'2022-02-12 12:18:04','',''),(2614103,'1','201','1037',478,'Retail Sale Id 1461783',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 12:20:45','',''),(2614104,'1','201','1037',478,'Retail Sale Id 1461784',3600.00,0.00,0.00,6.00,372.00,'2022-02-12 12:25:45','',''),(2614105,'1','201','1037',478,'Retail Sale Id 1461785',402.00,0.00,0.00,0.67,41.54,'2022-02-12 12:27:20','',''),(2614106,'1','201','1037',478,'Retail Sale Id 1461786',8550.00,0.00,0.00,15.00,480.00,'2022-02-12 12:30:42','',''),(2614107,'1','201','1037',478,'Retail Sale Id 1461787',7500.00,0.00,0.00,12.50,775.00,'2022-02-12 12:39:54','',''),(2614108,'1','201','1037',478,'Retail Sale Id 1461788',2400.00,0.00,0.00,4.00,248.00,'2022-02-12 13:02:54','',''),(2614109,'1','201','1037',478,'Retail Sale Id 1461789',3000.00,0.00,0.00,5.00,310.00,'2022-02-12 13:36:32','',''),(2614110,'1','201','1037',478,'Retail Sale Id 1461790',1998.00,0.00,0.00,3.33,206.46,'2022-02-12 14:21:31','',''),(2614111,'1','201','1037',478,'Retail Sale Id 1461791',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 14:37:19','',''),(2614112,'1','201','1037',478,'Retail Sale Id 1461792',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 14:41:19','',''),(2614113,'1','201','1037',478,'Retail Sale Id 1461793',4800.00,0.00,0.00,8.00,496.00,'2022-02-12 14:46:18','',''),(2614114,'1','201','1037',478,'Retail Sale Id 1461794',3000.00,0.00,0.00,5.00,310.00,'2022-02-12 14:47:14','',''),(2614115,'1','201','1037',478,'Retail Sale Id 1461795',4800.00,0.00,0.00,8.00,496.00,'2022-02-12 14:50:04','',''),(2614116,'1','201','1037',478,'Retail Sale Id 1461796',7500.00,0.00,0.00,12.50,775.00,'2022-02-12 15:05:31','',''),(2614117,'1','201','1037',478,'Retail Sale Id 1461797',3000.00,0.00,0.00,5.00,310.00,'2022-02-12 15:06:17','',''),(2614118,'1','201','1037',478,'Retail Sale Id 1461798',3000.00,0.00,0.00,5.00,310.00,'2022-02-12 15:43:36','',''),(2614119,'1','201','1037',478,'Retail Sale Id 1461799',6000.00,0.00,0.00,10.00,620.00,'2022-02-12 15:50:23','',''),(2614120,'1','201','1037',478,'Retail Sale Id 1461800',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 16:06:17','',''),(2614121,'1','201','1037',478,'Retail Sale Id 1461801',4200.00,0.00,0.00,7.00,434.00,'2022-02-12 16:24:41','',''),(2614122,'1','201','1037',478,'Retail Sale Id 1461802',600.00,0.00,0.00,1.00,62.00,'2022-02-12 16:42:06','',''),(2614123,'1','201','1037',478,'Retail Sale Id 1461803',2400.00,0.00,0.00,4.00,248.00,'2022-02-12 16:52:36','',''),(2614124,'1','201','1037',478,'Retail Sale Id 1461804',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 16:57:18','',''),(2614125,'1','201','1037',478,'Retail Sale Id 1461805',8400.00,0.00,0.00,14.00,868.00,'2022-02-12 16:58:34','',''),(2614126,'1','201','1037',478,'Retail Sale Id 1461806',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 17:04:50','',''),(2614127,'1','201','1037',478,'Retail Sale Id 1461807',3000.00,0.00,0.00,5.00,310.00,'2022-02-12 17:07:10','',''),(2614128,'1','201','1037',478,'Retail Sale Id 1461808',3600.00,0.00,0.00,6.00,372.00,'2022-02-12 17:08:56','',''),(2614129,'1','201','1037',478,'Retail Sale Id 1461809',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 17:10:24','',''),(2614130,'1','201','1037',478,'Retail Sale Id 1461810',3600.00,0.00,0.00,6.00,372.00,'2022-02-12 17:18:26','',''),(2614131,'1','201','1037',478,'Retail Sale Id 1461811',2400.00,0.00,0.00,4.00,248.00,'2022-02-12 17:24:21','',''),(2614132,'1','201','1037',478,'Retail Sale Id 1461812',1998.00,0.00,0.00,3.33,206.46,'2022-02-12 17:25:20','',''),(2614133,'1','201','1037',478,'Retail Sale Id 1461813',3000.00,0.00,0.00,5.00,310.00,'2022-02-12 17:30:36','',''),(2614134,'1','201','1037',478,'Retail Sale Id 1461814',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 17:34:24','',''),(2614135,'1','201','1037',478,'Retail Sale Id 1461815',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 17:37:35','',''),(2614136,'1','201','1037',478,'Retail Sale Id 1461816',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 17:42:59','',''),(2614137,'1','201','1037',478,'Retail Sale Id 1461817',1200.00,0.00,0.00,2.00,124.00,'2022-02-12 17:50:58','',''),(2614138,'1','201','1037',478,'Retail Sale Id 1461818',1800.00,0.00,0.00,3.00,186.00,'2022-02-12 18:02:54','',''),(2614139,'1','201','1037',478,'Retail Sale Id 1461819',5802.00,0.00,0.00,9.67,599.54,'2022-02-12 18:45:42','',''),(2614140,'1','201','1037',478,'Return of Retail Sale Id 1461819',0.00,5802.00,9.67,0.00,-599.54,'2022-02-12 19:07:11','',''),(2614141,'1','201','1037',478,'Retail Sale Id 1461820',702.00,0.00,0.00,1.17,72.54,'2022-02-12 19:28:24','',''),(2614142,'1','201','1037',478,'Retail Sale Id 1461821',5802.00,0.00,0.00,9.67,599.54,'2022-02-12 19:29:29','',''),(2614143,'1','201','1037',478,'Retail Sale Id 1461822',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 07:42:20','',''),(2614144,'1','201','1037',478,'Retail Sale Id 1461823',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 08:06:42','',''),(2614145,'1','201','1037',478,'Retail Sale Id 1461824',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 08:39:27','',''),(2614146,'1','201','1037',478,'Retail Sale Id 1461825',7500.00,0.00,0.00,12.50,775.00,'2022-02-13 08:49:50','',''),(2614147,'1','201','1037',478,'Retail Sale Id 1461826',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 09:08:37','',''),(2614148,'1','201','1037',478,'Retail Sale Id 1461827',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 09:21:41','',''),(2614149,'1','201','1037',478,'Retail Sale Id 1461828',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 09:22:53','',''),(2614150,'1','201','1037',478,'Retail Sale Id 1461829',4998.00,0.00,0.00,8.33,516.46,'2022-02-13 09:26:54','',''),(2614151,'1','201','1037',478,'Retail Sale Id 1461830',28500.00,0.00,0.00,50.00,1600.00,'2022-02-13 10:04:27','',''),(2614152,'1','201','1037',478,'Retail Sale Id 1461831',7500.00,0.00,0.00,12.50,775.00,'2022-02-13 10:13:08','',''),(2614153,'1','201','1037',478,'Retail Sale Id 1461832',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 10:18:04','',''),(2614154,'1','201','1037',478,'Retail Sale Id 1461833',7500.00,0.00,0.00,12.50,775.00,'2022-02-13 10:29:48','',''),(2614155,'1','201','1037',478,'Retail Sale Id 1461834',3600.00,0.00,0.00,6.00,372.00,'2022-02-13 10:33:03','',''),(2614156,'1','201','1037',478,'Retail Sale Id 1461835',1998.00,0.00,0.00,3.33,206.46,'2022-02-13 10:34:08','',''),(2614157,'1','201','1037',478,'Retail Sale Id 1461836',1998.00,0.00,0.00,3.33,206.46,'2022-02-13 10:49:35','',''),(2614158,'1','201','1037',478,'Retail Sale Id 1461837',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 11:11:52','',''),(2614159,'1','201','1037',478,'Retail Sale Id 1461838',600.00,0.00,0.00,1.00,62.00,'2022-02-13 11:14:38','',''),(2614160,'1','201','1037',478,'Retail Sale Id 1461839',1500.00,0.00,0.00,2.50,155.00,'2022-02-13 12:00:18','',''),(2614161,'1','201','1037',478,'Retail Sale Id 1461840',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 12:14:43','',''),(2614162,'1','201','1037',478,'Retail Sale Id 1461841',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 12:25:39','',''),(2614163,'1','201','1037',478,'Retail Sale Id 1461842',2400.00,0.00,0.00,4.00,248.00,'2022-02-13 12:30:04','',''),(2614164,'1','201','1037',478,'Retail Sale Id 1461843',4998.00,0.00,0.00,8.33,516.46,'2022-02-13 12:32:37','',''),(2614165,'1','201','1037',478,'Retail Sale Id 1461844',4800.00,0.00,0.00,8.00,496.00,'2022-02-13 12:39:41','',''),(2614166,'1','201','1037',478,'Retail Sale Id 1461845',3000.00,0.00,0.00,5.00,310.00,'2022-02-13 12:40:43','',''),(2614167,'1','201','1037',478,'Retail Sale Id 1461846',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 12:48:07','',''),(2614168,'1','201','1037',478,'Retail Sale Id 1461847',3600.00,0.00,0.00,6.00,372.00,'2022-02-13 12:48:58','',''),(2614169,'1','201','1037',478,'Retail Sale Id 1461848',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 12:54:42','',''),(2614170,'1','201','1037',478,'Retail Sale Id 1461849',7500.00,0.00,0.00,12.50,775.00,'2022-02-13 13:06:49','',''),(2614171,'1','201','1037',478,'Retail Sale Id 1461850',7500.00,0.00,0.00,12.50,775.00,'2022-02-13 13:08:32','',''),(2614172,'1','201','1037',478,'Retail Sale Id 1461851',7500.00,0.00,0.00,12.50,775.00,'2022-02-13 13:18:54','',''),(2614173,'1','201','1037',478,'Retail Sale Id 1461852',3600.00,0.00,0.00,6.00,372.00,'2022-02-13 13:27:45','',''),(2614174,'1','201','1037',478,'Retail Sale Id 1461853',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 13:36:13','',''),(2614175,'1','201','1037',478,'Retail Sale Id 1461854',3000.00,0.00,0.00,5.00,310.00,'2022-02-13 13:47:25','',''),(2614176,'1','201','1037',478,'Retail Sale Id 1461855',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 13:56:34','',''),(2614177,'1','201','1037',478,'Retail Sale Id 1461856',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 13:57:41','',''),(2614178,'1','201','1037',478,'Retail Sale Id 1461857',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 14:09:15','',''),(2614179,'1','201','1037',478,'Retail Sale Id 1461858',2100.00,0.00,0.00,3.50,217.00,'2022-02-13 14:20:34','',''),(2614180,'1','201','1037',478,'Retail Sale Id 1461859',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 14:23:04','',''),(2614181,'1','201','1037',478,'Retail Sale Id 1461860',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 14:36:08','',''),(2614182,'1','201','1037',478,'Retail Sale Id 1461861',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 14:40:03','',''),(2614183,'1','201','1037',478,'Retail Sale Id 1461862',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 14:46:26','',''),(2614184,'1','201','1037',478,'Retail Sale Id 1461863',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 15:01:33','',''),(2614185,'1','201','1037',478,'Retail Sale Id 1461864',49437.50,0.00,0.00,87.50,2362.50,'2022-02-13 15:07:18','',''),(2614186,'1','201','1037',478,'Retail Sale Id 1461865',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 15:27:05','',''),(2614187,'1','201','1037',478,'Retail Sale Id 1461866',3000.00,0.00,0.00,5.00,310.00,'2022-02-13 15:29:43','',''),(2614188,'1','201','1037',478,'Retail Sale Id 1461867',3000.00,0.00,0.00,5.00,310.00,'2022-02-13 15:31:09','',''),(2614189,'1','201','1037',478,'Retail Sale Id 1461868',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 15:44:42','',''),(2614190,'1','201','1037',478,'Retail Sale Id 1461869',3000.00,0.00,0.00,5.00,310.00,'2022-02-13 16:00:07','',''),(2614191,'1','201','1037',478,'Retail Sale Id 1461870',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 16:12:39','',''),(2614192,'1','201','1037',478,'Retail Sale Id 1461871',6840.00,0.00,0.00,12.00,384.00,'2022-02-13 16:23:27','',''),(2614193,'1','201','1037',478,'Retail Sale Id 1461872',3000.00,0.00,0.00,5.00,310.00,'2022-02-13 16:28:40','',''),(2614194,'1','201','1037',478,'Retail Sale Id 1461873',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 16:42:17','',''),(2614195,'1','201','1037',478,'Retail Sale Id 1461874',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 16:44:28','',''),(2614196,'1','201','1037',478,'Retail Sale Id 1461875',7500.00,0.00,0.00,12.50,775.00,'2022-02-13 16:56:59','',''),(2614197,'1','201','1037',478,'Retail Sale Id 1461876',1998.00,0.00,0.00,3.33,206.46,'2022-02-13 17:02:07','',''),(2614198,'1','201','1037',478,'Retail Sale Id 1461877',2400.00,0.00,0.00,4.00,248.00,'2022-02-13 17:24:42','',''),(2614199,'1','201','1037',478,'Retail Sale Id 1461878',3600.00,0.00,0.00,6.00,372.00,'2022-02-13 17:28:13','',''),(2614200,'1','201','1037',478,'Retail Sale Id 1461879',7500.00,0.00,0.00,12.50,775.00,'2022-02-13 17:30:06','',''),(2614201,'1','201','1037',478,'Retail Sale Id 1461880',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 17:32:26','',''),(2614202,'1','201','1037',478,'Retail Sale Id 1461881',1800.00,0.00,0.00,3.00,186.00,'2022-02-13 17:39:48','',''),(2614203,'1','201','1037',478,'Retail Sale Id 1461882',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 17:42:15','',''),(2614204,'1','201','1037',478,'Retail Sale Id 1461883',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 17:43:24','',''),(2614205,'1','201','1037',478,'Retail Sale Id 1461884',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 17:44:14','',''),(2614206,'1','201','1037',478,'Retail Sale Id 1461885',6000.00,0.00,0.00,10.00,620.00,'2022-02-13 17:45:46','',''),(2614207,'1','201','1037',478,'Retail Sale Id 1461886',7500.00,0.00,0.00,12.50,775.00,'2022-02-13 17:49:48','',''),(2614208,'1','201','1037',478,'Retail Sale Id 1461887',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 17:50:53','',''),(2614209,'1','201','1037',478,'Retail Sale Id 1461888',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 17:57:45','',''),(2614210,'1','201','1037',478,'Retail Sale Id 1461889',798.00,0.00,0.00,1.33,82.46,'2022-02-13 17:59:30','',''),(2614211,'1','201','1037',478,'Retail Sale Id 1461890',2400.00,0.00,0.00,4.00,248.00,'2022-02-13 18:04:01','',''),(2614212,'1','201','1037',478,'Retail Sale Id 1461891',1200.00,0.00,0.00,2.00,124.00,'2022-02-13 18:06:21','',''),(2614213,'1','201','1037',478,'Retail Sale Id 1461892',588.00,0.00,0.00,0.98,60.76,'2022-02-13 19:19:57','',''),(2614214,'1','201','1037',478,'Retail Sale Id 1461893',7500.00,0.00,0.00,12.50,775.00,'2022-02-14 08:18:10','',''),(2614215,'1','201','1037',478,'Retail Sale Id 1461894',7500.00,0.00,0.00,12.50,775.00,'2022-02-14 08:19:51','',''),(2614216,'1','201','1037',478,'Retail Sale Id 1461895',7500.00,0.00,0.00,12.50,775.00,'2022-02-14 08:20:57','',''),(2614217,'1','201','1037',478,'Retail Sale Id 1461896',1200.00,0.00,0.00,2.00,124.00,'2022-02-14 08:32:20','',''),(2614218,'1','201','1037',478,'Retail Sale Id 1461897',3600.00,0.00,0.00,6.00,372.00,'2022-02-14 08:35:27','',''),(2614219,'1','201','1037',478,'Retail Sale Id 1461898',3600.00,0.00,0.00,6.00,372.00,'2022-02-14 08:45:33','',''),(2614220,'1','201','1037',478,'Retail Sale Id 1461899',1998.00,0.00,0.00,3.33,206.46,'2022-02-14 08:55:59','',''),(2614221,'1','201','1037',478,'Retail Sale Id 1461900',7500.00,0.00,0.00,12.50,775.00,'2022-02-14 09:02:17','',''),(2614222,'1','201','1037',478,'Retail Sale Id 1461901',1398.00,0.00,0.00,2.33,144.46,'2022-02-14 09:03:37','',''),(2614223,'1','201','1037',478,'Retail Sale Id 1461902',7500.00,0.00,0.00,12.50,775.00,'2022-02-14 09:28:02','',''),(2614224,'1','201','1037',478,'Retail Sale Id 1461903',1500.00,0.00,0.00,2.50,155.00,'2022-02-14 10:17:40','',''),(2614225,'1','201','1037',478,'Retail Sale Id 1461904',6840.00,0.00,0.00,12.00,384.00,'2022-02-14 10:24:34','',''),(2614226,'1','201','1037',478,'Retail Sale Id 1461905',1200.00,0.00,0.00,2.00,124.00,'2022-02-14 10:44:46','',''),(2614227,'1','201','1037',478,'Retail Sale Id 1461906',4200.00,0.00,0.00,7.00,434.00,'2022-02-14 10:48:38','',''),(2614228,'1','201','1037',478,'Retail Sale Id 1461907',1200.00,0.00,0.00,2.00,124.00,'2022-02-14 11:20:55','',''),(2614229,'1','201','1037',478,'Retail Sale Id 1461908',3000.00,0.00,0.00,5.00,310.00,'2022-02-14 11:28:19','',''),(2614230,'1','201','1037',478,'Retail Sale Id 1461909',3600.00,0.00,0.00,6.00,372.00,'2022-02-14 11:57:18','',''),(2614231,'1','201','1037',478,'Retail Sale Id 1461910',4200.00,0.00,0.00,7.00,434.00,'2022-02-14 11:58:37','',''),(2614232,'1','201','1037',478,'Retail Sale Id 1461911',3000.00,0.00,0.00,5.00,310.00,'2022-02-14 12:03:41','',''),(2614233,'1','201','1037',478,'Retail Sale Id 1461912',3000.00,0.00,0.00,5.00,310.00,'2022-02-14 12:09:06','',''),(2614234,'1','201','1037',478,'Retail Sale Id 1461913',2400.00,0.00,0.00,4.00,248.00,'2022-02-14 12:15:15','',''),(2614235,'1','201','1037',478,'Retail Sale Id 1461914',1998.00,0.00,0.00,3.33,206.46,'2022-02-14 12:58:53','',''),(2614236,'1','201','1037',478,'Retail Sale Id 1461915',900.00,0.00,0.00,1.50,93.00,'2022-02-14 13:04:41','',''),(2614237,'1','201','1037',478,'Retail Sale Id 1461916',3900.00,0.00,0.00,6.50,403.00,'2022-02-14 13:12:38','',''),(2614238,'1','201','1037',478,'Retail Sale Id 1461917',1800.00,0.00,0.00,3.00,186.00,'2022-02-14 13:26:06','',''),(2614239,'1','201','1037',478,'Retail Sale Id 1461918',3600.00,0.00,0.00,6.00,372.00,'2022-02-14 13:58:58','',''),(2614240,'1','201','1037',478,'Retail Sale Id 1461919',1200.00,0.00,0.00,2.00,124.00,'2022-02-14 14:09:44','',''),(2614241,'1','201','1037',478,'Retail Sale Id 1461920',1800.00,0.00,0.00,3.00,186.00,'2022-02-14 14:36:14','',''),(2614242,'1','201','1037',478,'Retail Sale Id 1461921',1800.00,0.00,0.00,3.00,186.00,'2022-02-14 14:37:54','',''),(2614243,'1','201','1037',478,'Retail Sale Id 1461922',3600.00,0.00,0.00,6.00,372.00,'2022-02-14 14:39:38','',''),(2614244,'1','201','1037',478,'Retail Sale Id 1461923',600.00,0.00,0.00,1.00,62.00,'2022-02-14 14:44:45','',''),(2614245,'1','201','1037',478,'Retail Sale Id 1461924',600.00,0.00,0.00,1.00,62.00,'2022-02-14 14:50:15','',''),(2614246,'1','201','1037',478,'Retail Sale Id 1461925',3000.00,0.00,0.00,5.00,310.00,'2022-02-14 14:54:26','',''),(2614247,'1','201','1037',478,'Retail Sale Id 1461926',4500.00,0.00,0.00,7.50,465.00,'2022-02-14 15:02:13','',''),(2614248,'1','201','1037',478,'Retail Sale Id 1461927',1800.00,0.00,0.00,3.00,186.00,'2022-02-14 15:22:21','',''),(2614249,'1','201','1037',478,'Retail Sale Id 1461928',2400.00,0.00,0.00,4.00,248.00,'2022-02-14 15:25:46','',''),(2614250,'1','201','1037',478,'Retail Sale Id 1461929',3900.00,0.00,0.00,6.50,403.00,'2022-02-14 15:36:15','',''),(2614251,'1','201','1037',478,'Retail Sale Id 1461930',1800.00,0.00,0.00,3.00,186.00,'2022-02-14 15:39:27','',''),(2614252,'1','201','1037',478,'Retail Sale Id 1461931',3600.00,0.00,0.00,6.00,372.00,'2022-02-14 15:49:14','',''),(2614253,'1','201','1037',478,'Retail Sale Id 1461932',600.00,0.00,0.00,1.00,62.00,'2022-02-14 15:58:16','',''),(2614254,'1','201','1037',478,'Retail Sale Id 1461933',4002.00,0.00,0.00,6.67,413.54,'2022-02-14 16:07:06','',''),(2614255,'1','201','1037',478,'Retail Sale Id 1461934',3000.00,0.00,0.00,5.00,310.00,'2022-02-14 16:15:39','',''),(2614256,'1','201','1037',478,'Retail Sale Id 1461935',12600.00,0.00,0.00,21.00,1302.00,'2022-02-14 16:33:37','',''),(2614257,'1','201','1037',478,'Retail Sale Id 1461936',600.00,0.00,0.00,1.00,62.00,'2022-02-14 16:45:36','',''),(2614258,'1','201','1037',478,'Retail Sale Id 1461937',1800.00,0.00,0.00,3.00,186.00,'2022-02-14 16:46:52','',''),(2614259,'1','201','1037',478,'Retail Sale Id 1461938',3000.00,0.00,0.00,5.00,310.00,'2022-02-14 16:59:24','',''),(2614260,'1','201','1037',478,'Retail Sale Id 1461939',3600.00,0.00,0.00,6.00,372.00,'2022-02-14 17:03:58','',''),(2614261,'1','201','1037',478,'Retail Sale Id 1461940',3000.00,0.00,0.00,5.00,310.00,'2022-02-14 17:13:28','',''),(2614262,'1','201','1037',478,'Retail Sale Id 1461941',7500.00,0.00,0.00,12.50,775.00,'2022-02-14 17:19:12','',''),(2614263,'1','201','1037',478,'Retail Sale Id 1461942',900.00,0.00,0.00,1.50,93.00,'2022-02-14 17:25:31','',''),(2614264,'1','201','1037',478,'Retail Sale Id 1461943',7500.00,0.00,0.00,12.50,775.00,'2022-02-14 17:27:11','',''),(2614265,'1','201','1037',478,'Retail Sale Id 1461944',3600.00,0.00,0.00,6.00,372.00,'2022-02-14 17:31:22','',''),(2614266,'1','201','1037',478,'Retail Sale Id 1461945',5700.00,0.00,0.00,10.00,320.00,'2022-02-14 17:44:16','',''),(2614267,'1','201','1037',478,'Retail Sale Id 1461946',4200.00,0.00,0.00,7.00,434.00,'2022-02-14 18:16:37','',''),(2614268,'1','201','1037',478,'Retail Sale Id 1461947',1800.00,0.00,0.00,3.00,186.00,'2022-02-14 18:17:46','',''),(2614269,'1','201','1037',478,'Retail Sale Id 1461948',3600.00,0.00,0.00,6.00,372.00,'2022-02-14 18:24:53','',''),(2614270,'1','201','1037',478,'Retail Sale Id 1461949',7500.00,0.00,0.00,12.50,775.00,'2022-02-15 08:33:04','',''),(2614271,'1','201','1037',478,'Retail Sale Id 1461950',2400.00,0.00,0.00,4.00,248.00,'2022-02-15 08:42:12','',''),(2614272,'1','201','1037',478,'Retail Sale Id 1461951',8550.00,0.00,0.00,15.00,480.00,'2022-02-15 08:53:00','',''),(2614273,'1','201','1037',478,'Retail Sale Id 1461952',2400.00,0.00,0.00,4.00,248.00,'2022-02-15 08:56:56','',''),(2614274,'1','201','1037',478,'Retail Sale Id 1461953',3000.00,0.00,0.00,5.00,310.00,'2022-02-15 09:38:20','',''),(2614275,'1','201','1037',478,'Retail Sale Id 1461954',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 09:50:18','',''),(2614276,'1','201','1037',478,'Retail Sale Id 1461955',7500.00,0.00,0.00,12.50,775.00,'2022-02-15 09:59:07','',''),(2614277,'1','201','1037',478,'Retail Sale Id 1461956',6000.00,0.00,0.00,10.00,620.00,'2022-02-15 10:08:23','',''),(2614278,'1','201','1037',478,'Retail Sale Id 1461957',3600.00,0.00,0.00,6.00,372.00,'2022-02-15 10:14:23','',''),(2614279,'1','201','1037',478,'Retail Sale Id 1461958',3600.00,0.00,0.00,6.00,372.00,'2022-02-15 10:17:12','',''),(2614280,'1','201','1037',478,'Retail Sale Id 1461959',1200.00,0.00,0.00,2.00,124.00,'2022-02-15 10:21:15','',''),(2614281,'1','201','1037',478,'Retail Sale Id 1461960',3000.00,0.00,0.00,5.00,310.00,'2022-02-15 10:34:13','',''),(2614282,'1','201','1037',478,'Retail Sale Id 1461961',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 10:36:05','',''),(2614283,'1','201','1037',478,'Retail Sale Id 1461962',1200.00,0.00,0.00,2.00,124.00,'2022-02-15 10:40:19','',''),(2614284,'1','201','1037',478,'Retail Sale Id 1461963',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 10:45:44','',''),(2614285,'1','201','1037',478,'Retail Sale Id 1461964',2400.00,0.00,0.00,4.00,248.00,'2022-02-15 10:58:46','',''),(2614286,'1','201','1037',478,'Retail Sale Id 1461965',3600.00,0.00,0.00,6.00,372.00,'2022-02-15 11:01:06','',''),(2614287,'1','201','1037',478,'Retail Sale Id 1461966',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 11:04:41','',''),(2614288,'1','201','1037',478,'Retail Sale Id 1461967',3000.00,0.00,0.00,5.00,310.00,'2022-02-15 11:49:40','',''),(2614289,'1','201','1037',478,'Retail Sale Id 1461968',1200.00,0.00,0.00,2.00,124.00,'2022-02-15 11:50:39','',''),(2614290,'1','201','1037',478,'Retail Sale Id 1461969',600.00,0.00,0.00,1.00,62.00,'2022-02-15 11:51:44','',''),(2614291,'1','201','1037',478,'Retail Sale Id 1461970',2400.00,0.00,0.00,4.00,248.00,'2022-02-15 12:29:22','',''),(2614292,'1','201','1037',478,'Retail Sale Id 1461971',1200.00,0.00,0.00,2.00,124.00,'2022-02-15 12:45:13','',''),(2614293,'1','201','1037',478,'Retail Sale Id 1461972',3600.00,0.00,0.00,6.00,372.00,'2022-02-15 12:46:16','',''),(2614294,'1','201','1037',478,'Retail Sale Id 1461973',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 13:34:45','',''),(2614295,'1','201','1037',478,'Retail Sale Id 1461974',2400.00,0.00,0.00,4.00,248.00,'2022-02-15 13:45:48','',''),(2614296,'1','201','1037',478,'Retail Sale Id 1461975',3000.00,0.00,0.00,5.00,310.00,'2022-02-15 13:52:58','',''),(2614297,'1','201','1037',478,'Retail Sale Id 1461976',7500.00,0.00,0.00,12.50,775.00,'2022-02-15 14:27:11','',''),(2614298,'1','201','1037',478,'Retail Sale Id 1461977',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 14:27:58','',''),(2614299,'1','201','1037',478,'Retail Sale Id 1461978',1200.00,0.00,0.00,2.00,124.00,'2022-02-15 14:33:32','',''),(2614300,'1','201','1037',478,'Retail Sale Id 1461979',3600.00,0.00,0.00,6.00,372.00,'2022-02-15 14:40:18','',''),(2614301,'1','201','1037',478,'Retail Sale Id 1461980',3600.00,0.00,0.00,6.00,372.00,'2022-02-15 14:44:00','',''),(2614302,'1','201','1037',478,'Retail Sale Id 1461980',7500.00,0.00,0.00,12.50,775.00,'2022-02-15 14:44:00','',''),(2614303,'1','201','1037',478,'Retail Sale Id 1461981',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 14:53:37','',''),(2614304,'1','201','1037',478,'Retail Sale Id 1461982',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 15:04:29','',''),(2614305,'1','201','1037',478,'Retail Sale Id 1461983',1998.00,0.00,0.00,3.33,206.46,'2022-02-15 15:05:45','',''),(2614306,'1','201','1037',478,'Retail Sale Id 1461984',1200.00,0.00,0.00,2.00,124.00,'2022-02-15 15:07:51','',''),(2614307,'1','201','1037',478,'Retail Sale Id 1461985',7980.00,0.00,0.00,14.00,448.00,'2022-02-15 15:11:00','',''),(2614308,'1','201','1037',478,'Retail Sale Id 1461986',600.00,0.00,0.00,1.00,62.00,'2022-02-15 15:28:24','',''),(2614309,'1','201','1037',478,'Retail Sale Id 1461987',3600.00,0.00,0.00,6.00,372.00,'2022-02-15 15:31:52','',''),(2614310,'1','201','1037',478,'Retail Sale Id 1461988',5700.00,0.00,0.00,9.50,589.00,'2022-02-15 15:34:09','',''),(2614311,'1','201','1037',478,'Retail Sale Id 1461989',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 15:46:27','',''),(2614312,'1','201','1037',478,'Retail Sale Id 1461990',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 16:07:02','',''),(2614313,'1','201','1037',478,'Retail Sale Id 1461991',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 16:13:13','',''),(2614314,'1','201','1037',478,'Retail Sale Id 1461992',1200.00,0.00,0.00,2.00,124.00,'2022-02-15 16:32:31','',''),(2614315,'1','201','1037',478,'Retail Sale Id 1461993',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 16:36:23','',''),(2614316,'1','201','1037',478,'Retail Sale Id 1461994',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 16:54:03','',''),(2614317,'1','201','1037',478,'Retail Sale Id 1461995',7500.00,0.00,0.00,12.50,775.00,'2022-02-15 16:56:44','',''),(2614318,'1','201','1037',478,'Retail Sale Id 1461996',3000.00,0.00,0.00,5.00,310.00,'2022-02-15 16:57:32','',''),(2614319,'1','201','1037',478,'Retail Sale Id 1461997',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 16:58:25','',''),(2614320,'1','201','1037',478,'Retail Sale Id 1461998',3000.00,0.00,0.00,5.00,310.00,'2022-02-15 16:59:50','',''),(2614321,'1','201','1037',478,'Retail Sale Id 1461999',2400.00,0.00,0.00,4.00,248.00,'2022-02-15 17:05:05','',''),(2614322,'1','201','1037',478,'Retail Sale Id 1462000',900.00,0.00,0.00,1.50,93.00,'2022-02-15 17:11:04','',''),(2614323,'1','201','1037',478,'Retail Sale Id 1462000',900.00,0.00,0.00,1.50,93.00,'2022-02-15 17:11:04','',''),(2614324,'1','201','1037',478,'Retail Sale Id 1462001',3000.00,0.00,0.00,5.00,310.00,'2022-02-15 17:15:57','',''),(2614325,'1','201','1037',478,'Retail Sale Id 1462002',3600.00,0.00,0.00,6.00,372.00,'2022-02-15 17:23:37','',''),(2614326,'1','201','1037',478,'Retail Sale Id 1462003',3600.00,0.00,0.00,6.00,372.00,'2022-02-15 17:32:18','',''),(2614327,'1','201','1037',478,'Retail Sale Id 1462004',1200.00,0.00,0.00,2.00,124.00,'2022-02-15 17:37:17','',''),(2614328,'1','201','1037',478,'Retail Sale Id 1462005',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 17:48:36','',''),(2614329,'1','201','1037',478,'Retail Sale Id 1462006',3000.00,0.00,0.00,5.00,310.00,'2022-02-15 18:06:33','',''),(2614330,'1','201','1037',478,'Retail Sale Id 1462007',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 18:12:36','',''),(2614331,'1','201','1037',478,'Retail Sale Id 1462008',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 18:13:30','',''),(2614332,'1','201','1037',478,'Retail Sale Id 1462009',600.00,0.00,0.00,1.00,62.00,'2022-02-15 18:16:35','',''),(2614333,'1','201','1037',478,'Retail Sale Id 1462010',3000.00,0.00,0.00,5.00,310.00,'2022-02-15 18:19:32','',''),(2614334,'1','201','1037',478,'Retail Sale Id 1462011',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 18:21:56','',''),(2614335,'1','201','1037',478,'Retail Sale Id 1462011',6000.00,0.00,0.00,10.00,620.00,'2022-02-15 18:21:56','',''),(2614336,'1','201','1037',478,'Retail Sale Id 1462011',7500.00,0.00,0.00,12.50,775.00,'2022-02-15 18:21:56','',''),(2614337,'1','201','1037',478,'Retail Sale Id 1462012',1800.00,0.00,0.00,3.00,186.00,'2022-02-15 18:30:18','',''),(2614338,'1','201','1037',478,'Return of Retail Sale Id 1462010',0.00,3000.00,5.00,0.00,-310.00,'2022-02-15 19:30:23','',''),(2614339,'1','201','1037',478,'Retail Sale Id 1462013',2544.00,0.00,0.00,4.24,262.88,'2022-02-15 19:31:02','',''),(2614340,'1','201','1037',478,'Retail Sale Id 1462014',1200.00,0.00,0.00,2.00,124.00,'2022-02-16 07:34:23','',''),(2614341,'1','201','1037',478,'Retail Sale Id 1462015',2400.00,0.00,0.00,4.00,248.00,'2022-02-16 08:30:24','',''),(2614342,'1','201','1037',478,'Retail Sale Id 1462016',3600.00,0.00,0.00,6.00,372.00,'2022-02-16 08:35:54','',''),(2614343,'1','201','1037',478,'Retail Sale Id 1462017',3000.00,0.00,0.00,5.00,310.00,'2022-02-16 09:21:25','',''),(2614344,'1','201','1037',478,'Retail Sale Id 1462018',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 09:48:01','',''),(2614345,'1','201','1037',478,'Retail Sale Id 1462019',3000.00,0.00,0.00,5.00,310.00,'2022-02-16 09:51:14','',''),(2614346,'1','201','1037',478,'Retail Sale Id 1462020',3600.00,0.00,0.00,6.00,372.00,'2022-02-16 09:53:58','',''),(2614347,'1','201','1037',478,'Retail Sale Id 1462021',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 09:55:14','',''),(2614348,'1','201','1037',478,'Retail Sale Id 1462022',7500.00,0.00,0.00,12.50,775.00,'2022-02-16 09:57:10','',''),(2614349,'1','201','1037',478,'Retail Sale Id 1462023',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 10:09:08','',''),(2614350,'1','201','1037',478,'Retail Sale Id 1462024',3000.00,0.00,0.00,5.00,310.00,'2022-02-16 10:14:29','',''),(2614351,'1','201','1037',478,'Retail Sale Id 1462025',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 10:15:33','',''),(2614352,'1','201','1037',478,'Retail Sale Id 1462026',7500.00,0.00,0.00,12.50,775.00,'2022-02-16 10:30:14','',''),(2614353,'1','201','1037',478,'Retail Sale Id 1462027',1200.00,0.00,0.00,2.00,124.00,'2022-02-16 10:32:04','',''),(2614354,'1','201','1037',478,'Retail Sale Id 1462028',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 10:34:08','',''),(2614355,'1','201','1037',478,'Retail Sale Id 1462029',4200.00,0.00,0.00,7.00,434.00,'2022-02-16 11:27:39','',''),(2614356,'1','201','1037',478,'Retail Sale Id 1462030',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 11:36:57','',''),(2614357,'1','201','1037',478,'Retail Sale Id 1462031',7500.00,0.00,0.00,12.50,775.00,'2022-02-16 12:14:52','',''),(2614358,'1','201','1037',478,'Retail Sale Id 1462032',7500.00,0.00,0.00,12.50,775.00,'2022-02-16 12:15:42','',''),(2614359,'1','201','1037',478,'Retail Sale Id 1462033',3420.00,0.00,0.00,6.00,192.00,'2022-02-16 12:36:13','',''),(2614360,'1','201','1037',478,'Retail Sale Id 1462034',7500.00,0.00,0.00,12.50,775.00,'2022-02-16 12:46:06','',''),(2614361,'1','201','1037',478,'Retail Sale Id 1462035',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 12:47:05','',''),(2614362,'1','201','1037',478,'Retail Sale Id 1462036',99750.00,0.00,0.00,175.00,5600.00,'2022-02-16 13:32:02','',''),(2614363,'1','201','1037',478,'Retail Sale Id 1462037',5985.00,0.00,0.00,10.50,336.00,'2022-02-16 13:34:17','',''),(2614364,'1','201','1037',478,'Retail Sale Id 1462038',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 14:17:47','',''),(2614365,'1','201','1037',478,'Retail Sale Id 1462039',53675.00,0.00,0.00,95.00,2565.00,'2022-02-16 15:36:47','',''),(2614366,'1','201','1037',478,'Retail Sale Id 1462040',600.00,0.00,0.00,1.00,62.00,'2022-02-16 15:38:20','',''),(2614367,'1','201','1037',478,'Retail Sale Id 1462041',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 16:07:36','',''),(2614368,'1','201','1037',478,'Retail Sale Id 1462042',2400.00,0.00,0.00,4.00,248.00,'2022-02-16 16:13:01','',''),(2614369,'1','201','1037',478,'Retail Sale Id 1462044',3000.00,0.00,0.00,5.00,310.00,'2022-02-16 16:31:37','',''),(2614370,'1','201','1037',478,'Retail Sale Id 1462045',3600.00,0.00,0.00,6.00,372.00,'2022-02-16 16:32:46','',''),(2614371,'1','201','1037',478,'Retail Sale Id 1462046',7500.00,0.00,0.00,12.50,775.00,'2022-02-16 16:38:54','',''),(2614372,'1','201','1037',478,'Retail Sale Id 1462048',600.00,0.00,0.00,1.00,62.00,'2022-02-16 16:45:53','',''),(2614373,'1','201','1037',478,'Retail Sale Id 1462049',1200.00,0.00,0.00,2.00,124.00,'2022-02-16 16:48:30','',''),(2614374,'1','201','1037',478,'Retail Sale Id 1462050',1998.00,0.00,0.00,3.33,206.46,'2022-02-16 16:55:09','',''),(2614375,'1','201','1037',478,'Retail Sale Id 1462051',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 17:12:17','',''),(2614376,'1','201','1037',478,'Retail Sale Id 1462052',3600.00,0.00,0.00,6.00,372.00,'2022-02-16 17:13:42','',''),(2614377,'1','201','1037',478,'Retail Sale Id 1462053',1500.00,0.00,0.00,2.50,155.00,'2022-02-16 17:17:44','',''),(2614378,'1','201','1037',478,'Retail Sale Id 1462054',600.00,0.00,0.00,1.00,62.00,'2022-02-16 17:35:15','',''),(2614379,'1','201','1037',478,'Retail Sale Id 1462055',2400.00,0.00,0.00,4.00,248.00,'2022-02-16 17:38:05','',''),(2614380,'1','201','1037',478,'Retail Sale Id 1462056',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 17:46:13','',''),(2614381,'1','201','1037',478,'Retail Sale Id 1462057',1998.00,0.00,0.00,3.33,206.46,'2022-02-16 17:50:27','',''),(2614382,'1','201','1037',478,'Retail Sale Id 1462058',1200.00,0.00,0.00,2.00,124.00,'2022-02-16 17:54:17','',''),(2614383,'1','201','1037',478,'Retail Sale Id 1462059',1200.00,0.00,0.00,2.00,124.00,'2022-02-16 17:55:36','',''),(2614384,'1','201','1037',478,'Retail Sale Id 1462060',1698.00,0.00,0.00,2.83,175.46,'2022-02-16 17:57:06','',''),(2614385,'1','201','1037',478,'Retail Sale Id 1462061',1800.00,0.00,0.00,3.00,186.00,'2022-02-16 18:20:38','',''),(2614386,'1','201','1037',478,'Retail Sale Id 1462062',3600.00,0.00,0.00,6.00,372.00,'2022-02-16 18:24:41','',''),(2614387,'1','201','1037',478,'Retail Sale Id 1462063',3000.00,0.00,0.00,5.00,310.00,'2022-02-16 18:25:38','',''),(2614388,'1','201','1037',478,'Retail Sale Id 1462064',600.00,0.00,0.00,1.00,62.00,'2022-02-16 18:57:32','',''),(2614389,'1','201','1037',478,'Retail Sale Id 1462065',372.00,0.00,0.00,0.62,38.44,'2022-02-16 19:44:12','',''),(2614390,'1','201','1037',478,'Retail Sale Id 1462066',60.00,0.00,0.00,0.10,6.20,'2022-02-16 19:45:53','',''),(2614391,'1','201','1037',478,'Return of Retail Sale Id 1462066',0.00,60.00,0.10,0.00,-6.20,'2022-02-16 19:46:41','',''),(2614392,'1','201','1037',478,'Retail Sale Id 1462067',6.00,0.00,0.00,0.01,0.62,'2022-02-16 19:47:31','',''),(2614393,'1','201','1037',478,'Retail Sale Id 1462068',1500.00,0.00,0.00,2.50,155.00,'2022-02-17 08:47:05','',''),(2614394,'1','201','1037',478,'Retail Sale Id 1462069',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 09:28:48','',''),(2614395,'1','201','1037',478,'Retail Sale Id 1462070',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 09:37:35','',''),(2614396,'1','201','1037',478,'Retail Sale Id 1462071',3600.00,0.00,0.00,6.00,372.00,'2022-02-17 09:38:40','',''),(2614397,'1','201','1037',478,'Retail Sale Id 1462072',3600.00,0.00,0.00,6.00,372.00,'2022-02-17 09:44:05','',''),(2614398,'1','201','1037',478,'Retail Sale Id 1462073',3600.00,0.00,0.00,6.00,372.00,'2022-02-17 10:04:34','',''),(2614399,'1','201','1037',478,'Retail Sale Id 1462074',1002.00,0.00,0.00,1.67,103.54,'2022-02-17 10:32:25','',''),(2614400,'1','201','1037',478,'Retail Sale Id 1462075',1002.00,0.00,0.00,1.67,103.54,'2022-02-17 10:33:27','',''),(2614401,'1','201','1037',478,'Retail Sale Id 1462076',3000.00,0.00,0.00,5.00,310.00,'2022-02-17 10:53:44','',''),(2614402,'1','201','1037',478,'Retail Sale Id 1462077',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 10:59:07','',''),(2614403,'1','201','1037',478,'Retail Sale Id 1462078',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 11:06:13','',''),(2614404,'1','201','1037',478,'Retail Sale Id 1462079',3600.00,0.00,0.00,6.00,372.00,'2022-02-17 11:20:19','',''),(2614405,'1','201','1037',478,'Retail Sale Id 1462080',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 11:27:59','',''),(2614406,'1','201','1037',478,'Retail Sale Id 1462081',1998.00,0.00,0.00,3.33,206.46,'2022-02-17 11:32:45','',''),(2614407,'1','201','1037',478,'Retail Sale Id 1462082',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 11:37:51','',''),(2614408,'1','201','1037',478,'Retail Sale Id 1462083',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 11:45:28','',''),(2614409,'1','201','1037',478,'Retail Sale Id 1462084',3000.00,0.00,0.00,5.00,310.00,'2022-02-17 11:47:43','',''),(2614410,'1','201','1037',478,'Retail Sale Id 1462085',3000.00,0.00,0.00,5.00,310.00,'2022-02-17 11:48:45','',''),(2614411,'1','201','1037',478,'Retail Sale Id 1462086',1998.00,0.00,0.00,3.33,206.46,'2022-02-17 11:54:08','',''),(2614412,'1','201','1037',478,'Retail Sale Id 1462087',1998.00,0.00,0.00,3.33,206.46,'2022-02-17 12:26:15','',''),(2614413,'1','201','1037',478,'Retail Sale Id 1462088',3000.00,0.00,0.00,5.00,310.00,'2022-02-17 12:27:16','',''),(2614414,'1','201','1037',478,'Retail Sale Id 1462090',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 12:33:33','',''),(2614415,'1','201','1037',478,'Retail Sale Id 1462090',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 12:33:33','',''),(2614416,'1','201','1037',478,'Retail Sale Id 1462091',6000.00,0.00,0.00,10.00,620.00,'2022-02-17 12:40:22','',''),(2614417,'1','201','1037',478,'Retail Sale Id 1462092',3600.00,0.00,0.00,6.00,372.00,'2022-02-17 12:46:58','',''),(2614418,'1','201','1037',478,'Retail Sale Id 1462093',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 12:59:28','',''),(2614419,'1','201','1037',478,'Retail Sale Id 1462094',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 14:31:07','',''),(2614420,'1','201','1037',478,'Return of Retail Sale Id 1462091',0.00,6000.00,10.00,0.00,-620.00,'2022-02-17 14:31:23','',''),(2614421,'1','201','1037',478,'Return of Retail Sale Id 1462093',0.00,1800.00,3.00,0.00,-186.00,'2022-02-17 14:32:03','',''),(2614422,'1','201','1037',478,'Return of Retail Sale Id 1462088',0.00,3000.00,5.00,0.00,-310.00,'2022-02-17 14:32:45','',''),(2614423,'1','201','1037',478,'Retail Sale Id 1462095',612.00,0.00,0.00,1.02,63.24,'2022-02-17 14:33:26','',''),(2614424,'1','201','1037',478,'Retail Sale Id 1462096',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 14:44:59','',''),(2614425,'1','201','1037',478,'Retail Sale Id 1462097',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 14:45:50','',''),(2614426,'1','201','1037',478,'Retail Sale Id 1462099',3000.00,0.00,0.00,5.00,310.00,'2022-02-17 14:51:45','',''),(2614427,'1','201','1037',478,'Retail Sale Id 1462100',4998.00,0.00,0.00,8.33,516.46,'2022-02-17 14:57:45','',''),(2614428,'1','201','1037',478,'Retail Sale Id 1462101',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 14:59:09','',''),(2614429,'1','201','1037',478,'Retail Sale Id 1462102',4200.00,0.00,0.00,7.00,434.00,'2022-02-17 15:00:56','',''),(2614430,'1','201','1037',478,'Retail Sale Id 1462103',7200.00,0.00,0.00,12.00,744.00,'2022-02-17 15:04:23','',''),(2614431,'1','201','1037',478,'Retail Sale Id 1462104',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 15:28:03','',''),(2614432,'1','201','1037',478,'Retail Sale Id 1462105',3000.00,0.00,0.00,5.00,310.00,'2022-02-17 15:40:47','',''),(2614433,'1','201','1037',478,'Retail Sale Id 1462106',3000.00,0.00,0.00,5.00,310.00,'2022-02-17 15:43:24','',''),(2614434,'1','201','1037',478,'Retail Sale Id 1462107',7500.00,0.00,0.00,12.50,775.00,'2022-02-17 15:47:37','',''),(2614435,'1','201','1037',478,'Retail Sale Id 1462108',2400.00,0.00,0.00,4.00,248.00,'2022-02-17 15:48:39','',''),(2614436,'1','201','1037',478,'Retail Sale Id 1462109',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 15:54:03','',''),(2614437,'1','201','1037',478,'Retail Sale Id 1462110',3600.00,0.00,0.00,6.00,372.00,'2022-02-17 16:02:28','',''),(2614438,'1','201','1037',478,'Retail Sale Id 1462111',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 16:03:18','',''),(2614439,'1','201','1037',478,'Retail Sale Id 1462112',600.00,0.00,0.00,1.00,62.00,'2022-02-17 16:15:59','',''),(2614440,'1','201','1037',478,'Retail Sale Id 1462113',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 16:17:18','',''),(2614441,'1','201','1037',478,'Retail Sale Id 1462114',600.00,0.00,0.00,1.00,62.00,'2022-02-17 16:22:36','',''),(2614442,'1','201','1037',478,'Retail Sale Id 1462115',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 16:24:37','',''),(2614443,'1','201','1037',478,'Retail Sale Id 1462116',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 16:43:12','',''),(2614444,'1','201','1037',478,'Retail Sale Id 1462117',3600.00,0.00,0.00,6.00,372.00,'2022-02-17 16:56:45','',''),(2614445,'1','201','1037',478,'Retail Sale Id 1462118',3000.00,0.00,0.00,5.00,310.00,'2022-02-17 16:59:03','',''),(2614446,'1','201','1037',478,'Retail Sale Id 1462119',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 17:02:41','',''),(2614447,'1','201','1037',478,'Retail Sale Id 1462120',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 17:03:58','',''),(2614448,'1','201','1037',478,'Retail Sale Id 1462121',4200.00,0.00,0.00,7.00,434.00,'2022-02-17 17:14:41','',''),(2614449,'1','201','1037',478,'Retail Sale Id 1462122',3000.00,0.00,0.00,5.00,310.00,'2022-02-17 17:17:52','',''),(2614450,'1','201','1037',478,'Retail Sale Id 1462123',1002.00,0.00,0.00,1.67,103.54,'2022-02-17 17:21:21','',''),(2614451,'1','201','1037',478,'Retail Sale Id 1462124',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 17:22:21','',''),(2614452,'1','201','1037',478,'Retail Sale Id 1462125',7500.00,0.00,0.00,12.50,775.00,'2022-02-17 17:24:33','',''),(2614453,'1','201','1037',478,'Retail Sale Id 1462127',1500.00,0.00,0.00,2.50,155.00,'2022-02-17 17:29:36','',''),(2614454,'1','201','1037',478,'Retail Sale Id 1462128',4200.00,0.00,0.00,7.00,434.00,'2022-02-17 17:43:27','',''),(2614455,'1','201','1037',478,'Retail Sale Id 1462129',3600.00,0.00,0.00,6.00,372.00,'2022-02-17 17:54:21','',''),(2614456,'1','201','1037',478,'Retail Sale Id 1462130',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 17:55:21','',''),(2614457,'1','201','1037',478,'Retail Sale Id 1462131',2400.00,0.00,0.00,4.00,248.00,'2022-02-17 17:59:53','',''),(2614458,'1','201','1037',478,'Retail Sale Id 1462132',300.00,0.00,0.00,0.50,31.00,'2022-02-17 18:01:19','',''),(2614459,'1','201','1037',478,'Retail Sale Id 1462133',3000.00,0.00,0.00,5.00,310.00,'2022-02-17 18:02:38','',''),(2614460,'1','201','1037',478,'Retail Sale Id 1462134',900.00,0.00,0.00,1.50,93.00,'2022-02-17 18:12:37','',''),(2614461,'1','201','1037',478,'Retail Sale Id 1462135',1800.00,0.00,0.00,3.00,186.00,'2022-02-17 18:17:27','',''),(2614462,'1','201','1037',478,'Retail Sale Id 1462136',1200.00,0.00,0.00,2.00,124.00,'2022-02-17 18:20:42','',''),(2614463,'1','201','1037',478,'Retail Sale Id 1462137',450.00,0.00,0.00,0.75,46.50,'2022-02-17 19:17:03','',''),(2614464,'1','201','1037',478,'Retail Sale Id 1462138',7500.00,0.00,0.00,12.50,775.00,'2022-02-18 07:57:56','',''),(2614465,'1','201','1037',478,'Retail Sale Id 1462139',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 08:18:01','',''),(2614466,'1','201','1037',478,'Retail Sale Id 1462140',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 08:31:13','',''),(2614467,'1','201','1037',478,'Retail Sale Id 1462141',3000.00,0.00,0.00,5.00,310.00,'2022-02-18 09:01:01','',''),(2614468,'1','201','1037',478,'Retail Sale Id 1462142',7500.00,0.00,0.00,12.50,775.00,'2022-02-18 09:16:41','',''),(2614469,'1','201','1037',478,'Retail Sale Id 1462143',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 09:34:28','',''),(2614470,'1','201','1037',478,'Retail Sale Id 1462144',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 09:35:27','',''),(2614471,'1','201','1037',478,'Retail Sale Id 1462145',3600.00,0.00,0.00,6.00,372.00,'2022-02-18 09:56:28','',''),(2614472,'1','201','1037',478,'Retail Sale Id 1462146',3000.00,0.00,0.00,5.00,310.00,'2022-02-18 10:25:46','',''),(2614473,'1','201','1037',478,'Retail Sale Id 1462147',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 10:34:26','',''),(2614474,'1','201','1037',478,'Retail Sale Id 1462148',600.00,0.00,0.00,1.00,62.00,'2022-02-18 10:37:12','',''),(2614475,'1','201','1037',478,'Retail Sale Id 1462149',3600.00,0.00,0.00,6.00,372.00,'2022-02-18 10:38:52','',''),(2614476,'1','201','1037',478,'Retail Sale Id 1462150',1998.00,0.00,0.00,3.33,206.46,'2022-02-18 11:16:23','',''),(2614477,'1','201','1037',478,'Retail Sale Id 1462151',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 11:26:40','',''),(2614478,'1','201','1037',478,'Retail Sale Id 1462152',11400.00,0.00,0.00,20.00,640.00,'2022-02-18 11:30:26','',''),(2614479,'1','201','1037',478,'Retail Sale Id 1462153',7500.00,0.00,0.00,12.50,775.00,'2022-02-18 11:46:45','',''),(2614480,'1','201','1037',478,'Retail Sale Id 1462154',1200.00,0.00,0.00,2.00,124.00,'2022-02-18 12:01:03','',''),(2614481,'1','201','1037',478,'Retail Sale Id 1462155',1200.00,0.00,0.00,2.00,124.00,'2022-02-18 12:02:19','',''),(2614482,'1','201','1037',478,'Retail Sale Id 1462156',1200.00,0.00,0.00,2.00,124.00,'2022-02-18 12:03:11','',''),(2614483,'1','201','1037',478,'Retail Sale Id 1462157',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 12:07:05','',''),(2614484,'1','201','1037',478,'Retail Sale Id 1462158',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 12:16:00','',''),(2614485,'1','201','1037',478,'Retail Sale Id 1462159',7200.00,0.00,0.00,12.00,744.00,'2022-02-18 12:17:58','',''),(2614486,'1','201','1037',478,'Retail Sale Id 1462160',3000.00,0.00,0.00,5.00,310.00,'2022-02-18 12:25:02','',''),(2614487,'1','201','1037',478,'Retail Sale Id 1462161',1200.00,0.00,0.00,2.00,124.00,'2022-02-18 12:31:05','',''),(2614488,'1','201','1037',478,'Retail Sale Id 1462162',14250.00,0.00,0.00,25.00,800.00,'2022-02-18 12:32:39','',''),(2614489,'1','201','1037',478,'Retail Sale Id 1462163',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 12:35:22','',''),(2614490,'1','201','1037',478,'Retail Sale Id 1462164',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 12:54:38','',''),(2614491,'1','201','1037',478,'Retail Sale Id 1462165',5400.00,0.00,0.00,9.00,558.00,'2022-02-18 12:59:37','',''),(2614492,'1','201','1037',478,'Retail Sale Id 1462166',1200.00,0.00,0.00,2.00,124.00,'2022-02-18 13:04:40','',''),(2614493,'1','201','1037',478,'Retail Sale Id 1462167',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 13:07:12','',''),(2614494,'1','201','1037',478,'Retail Sale Id 1462168',3600.00,0.00,0.00,6.00,372.00,'2022-02-18 13:08:33','',''),(2614495,'1','201','1037',478,'Retail Sale Id 1462169',1500.00,0.00,0.00,2.50,155.00,'2022-02-18 13:43:17','',''),(2614496,'1','201','1037',478,'Retail Sale Id 1462170',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 14:23:50','',''),(2614497,'1','201','1037',478,'Retail Sale Id 1462171',3600.00,0.00,0.00,6.00,372.00,'2022-02-18 14:35:26','',''),(2614498,'1','201','1037',478,'Retail Sale Id 1462172',2400.00,0.00,0.00,4.00,248.00,'2022-02-18 14:38:07','',''),(2614499,'1','201','1037',478,'Retail Sale Id 1462173',3000.00,0.00,0.00,5.00,310.00,'2022-02-18 15:05:44','',''),(2614500,'1','201','1037',478,'Retail Sale Id 1462174',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 15:11:27','',''),(2614501,'1','201','1037',478,'Retail Sale Id 1462175',6000.00,0.00,0.00,10.00,620.00,'2022-02-18 15:46:21','',''),(2614502,'1','201','1037',478,'Retail Sale Id 1462176',1200.00,0.00,0.00,2.00,124.00,'2022-02-18 15:48:10','',''),(2614503,'1','201','1037',478,'Retail Sale Id 1462177',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 15:53:53','',''),(2614504,'1','201','1037',478,'Retail Sale Id 1462178',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 15:57:27','',''),(2614505,'1','201','1037',478,'Retail Sale Id 1462179',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 16:02:14','',''),(2614506,'1','201','1037',478,'Retail Sale Id 1462180',1200.00,0.00,0.00,2.00,124.00,'2022-02-18 16:18:49','',''),(2614507,'1','201','1037',478,'Retail Sale Id 1462181',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 16:46:13','',''),(2614508,'1','201','1037',478,'Retail Sale Id 1462182',1200.00,0.00,0.00,2.00,124.00,'2022-02-18 16:57:53','',''),(2614509,'1','201','1037',478,'Retail Sale Id 1462183',1200.00,0.00,0.00,2.00,124.00,'2022-02-18 16:58:54','',''),(2614510,'1','201','1037',478,'Retail Sale Id 1462184',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 17:02:56','',''),(2614511,'1','201','1037',478,'Retail Sale Id 1462185',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 17:10:10','',''),(2614512,'1','201','1037',478,'Retail Sale Id 1462186',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 17:12:03','',''),(2614513,'1','201','1037',478,'Retail Sale Id 1462187',3000.00,0.00,0.00,5.00,310.00,'2022-02-18 17:13:59','',''),(2614514,'1','201','1037',478,'Retail Sale Id 1462187',3600.00,0.00,0.00,6.00,372.00,'2022-02-18 17:13:59','',''),(2614515,'1','201','1037',478,'Retail Sale Id 1462188',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 17:14:39','',''),(2614516,'1','201','1037',478,'Retail Sale Id 1462189',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 17:22:43','',''),(2614517,'1','201','1037',478,'Retail Sale Id 1462190',3000.00,0.00,0.00,5.00,310.00,'2022-02-18 17:33:55','',''),(2614518,'1','201','1037',478,'Retail Sale Id 1462191',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 17:35:32','',''),(2614519,'1','201','1037',478,'Retail Sale Id 1462192',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 17:37:34','',''),(2614520,'1','201','1037',478,'Retail Sale Id 1462194',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 17:38:48','',''),(2614521,'1','201','1037',478,'Retail Sale Id 1462195',3000.00,0.00,0.00,5.00,310.00,'2022-02-18 17:42:05','',''),(2614522,'1','201','1037',478,'Retail Sale Id 1462196',1800.00,0.00,0.00,3.00,186.00,'2022-02-18 17:53:46','',''),(2614523,'1','201','1037',478,'Retail Sale Id 1462197',1200.00,0.00,0.00,2.00,124.00,'2022-02-18 18:03:04','',''),(2614524,'1','201','1037',478,'Retail Sale Id 1462198',7500.00,0.00,0.00,12.50,775.00,'2022-02-18 18:14:27','',''),(2614525,'1','201','1037',478,'Return of Retail Sale Id 1462190',0.00,3000.00,5.00,0.00,-310.00,'2022-02-18 19:18:44','',''),(2614526,'1','201','1037',478,'Retail Sale Id 1462199',1998.00,0.00,0.00,3.33,206.46,'2022-02-18 19:19:27','',''),(2614527,'1','201','1037',478,'Retail Sale Id 1462200',3000.00,0.00,0.00,5.00,310.00,'2022-02-19 07:50:58','',''),(2614528,'1','201','1037',478,'Retail Sale Id 1462201',3900.00,0.00,0.00,6.50,403.00,'2022-02-19 08:13:16','',''),(2614529,'1','201','1037',478,'Retail Sale Id 1462201',7500.00,0.00,0.00,12.50,775.00,'2022-02-19 08:13:16','',''),(2614530,'1','201','1037',478,'Retail Sale Id 1462202',2400.00,0.00,0.00,4.00,248.00,'2022-02-19 08:29:53','',''),(2614531,'1','201','1037',478,'Retail Sale Id 1462203',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 08:38:33','',''),(2614532,'1','201','1037',478,'Retail Sale Id 1462204',15000.00,0.00,0.00,25.00,1550.00,'2022-02-19 08:39:38','',''),(2614533,'1','201','1037',478,'Retail Sale Id 1462205',6000.00,0.00,0.00,10.00,620.00,'2022-02-19 09:01:22','',''),(2614534,'1','201','1037',478,'Retail Sale Id 1462206',7500.00,0.00,0.00,12.50,775.00,'2022-02-19 09:12:40','',''),(2614535,'1','201','1037',478,'Retail Sale Id 1462207',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 09:15:50','',''),(2614536,'1','201','1037',478,'Retail Sale Id 1462208',14250.00,0.00,0.00,25.00,800.00,'2022-02-19 09:42:52','',''),(2614537,'1','201','1037',478,'Retail Sale Id 1462209',1500.00,0.00,0.00,2.50,155.00,'2022-02-19 09:43:51','',''),(2614538,'1','201','1037',478,'Retail Sale Id 1462210',3000.00,0.00,0.00,5.00,310.00,'2022-02-19 09:47:31','',''),(2614539,'1','201','1037',478,'Retail Sale Id 1462211',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 09:51:08','',''),(2614540,'1','201','1037',478,'Retail Sale Id 1462212',3300.00,0.00,0.00,5.50,341.00,'2022-02-19 10:16:49','',''),(2614541,'1','201','1037',478,'Retail Sale Id 1462213',1302.00,0.00,0.00,2.17,134.54,'2022-02-19 10:35:42','',''),(2614542,'1','201','1037',478,'Retail Sale Id 1462214',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 10:36:30','',''),(2614543,'1','201','1037',478,'Retail Sale Id 1462215',3600.00,0.00,0.00,6.00,372.00,'2022-02-19 11:17:27','',''),(2614544,'1','201','1037',478,'Retail Sale Id 1462216',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 11:28:41','',''),(2614545,'1','201','1037',478,'Retail Sale Id 1462217',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 11:30:25','',''),(2614546,'1','201','1037',478,'Retail Sale Id 1462218',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 11:31:19','',''),(2614547,'1','201','1037',478,'Retail Sale Id 1462219',3000.00,0.00,0.00,5.00,310.00,'2022-02-19 11:37:50','',''),(2614548,'1','201','1037',478,'Retail Sale Id 1462220',600.00,0.00,0.00,1.00,62.00,'2022-02-19 11:51:18','',''),(2614549,'1','201','1037',478,'Retail Sale Id 1462221',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 11:55:16','',''),(2614550,'1','201','1037',478,'Retail Sale Id 1462222',5400.00,0.00,0.00,9.00,558.00,'2022-02-19 12:06:09','',''),(2614551,'1','201','1037',478,'Retail Sale Id 1462222',5400.00,0.00,0.00,9.00,558.00,'2022-02-19 12:06:09','',''),(2614552,'1','201','1037',478,'Retail Sale Id 1462223',3600.00,0.00,0.00,6.00,372.00,'2022-02-19 12:08:36','',''),(2614553,'1','201','1037',478,'Retail Sale Id 1462224',3600.00,0.00,0.00,6.00,372.00,'2022-02-19 12:09:22','',''),(2614554,'1','201','1037',478,'Retail Sale Id 1462225',2400.00,0.00,0.00,4.00,248.00,'2022-02-19 12:14:38','',''),(2614555,'1','201','1037',478,'Retail Sale Id 1462226',3600.00,0.00,0.00,6.00,372.00,'2022-02-19 12:18:31','',''),(2614556,'1','201','1037',478,'Retail Sale Id 1462227',600.00,0.00,0.00,1.00,62.00,'2022-02-19 12:22:01','',''),(2614557,'1','201','1037',478,'Retail Sale Id 1462228',1500.00,0.00,0.00,2.50,155.00,'2022-02-19 12:29:13','',''),(2614558,'1','201','1037',478,'Retail Sale Id 1462229',3600.00,0.00,0.00,6.00,372.00,'2022-02-19 12:30:39','',''),(2614559,'1','201','1037',478,'Return of Retail Sale Id 1462226',0.00,3600.00,6.00,0.00,-372.00,'2022-02-19 12:32:08','',''),(2614560,'1','201','1037',478,'Return of Retail Sale Id 1462229',0.00,3600.00,6.00,0.00,-372.00,'2022-02-19 12:34:07','',''),(2614561,'1','201','1037',478,'Retail Sale Id 1462230',3600.00,0.00,0.00,6.00,372.00,'2022-02-19 12:35:11','',''),(2614562,'1','201','1037',478,'Retail Sale Id 1462231',3048.00,0.00,0.00,5.08,314.96,'2022-02-19 12:36:08','',''),(2614563,'1','201','1037',478,'Retail Sale Id 1462232',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 12:43:43','',''),(2614564,'1','201','1037',478,'Retail Sale Id 1462233',600.00,0.00,0.00,1.00,62.00,'2022-02-19 12:44:29','',''),(2614565,'1','201','1037',478,'Retail Sale Id 1462234',2400.00,0.00,0.00,4.00,248.00,'2022-02-19 12:50:03','',''),(2614566,'1','201','1037',478,'Retail Sale Id 1462235',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 12:53:24','',''),(2614567,'1','201','1037',478,'Retail Sale Id 1462236',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 12:56:59','',''),(2614568,'1','201','1037',478,'Retail Sale Id 1462237',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 12:58:09','',''),(2614569,'1','201','1037',478,'Retail Sale Id 1462238',7500.00,0.00,0.00,12.50,775.00,'2022-02-19 13:13:56','',''),(2614570,'1','201','1037',478,'Retail Sale Id 1462239',4002.00,0.00,0.00,6.67,413.54,'2022-02-19 13:34:14','',''),(2614571,'1','201','1037',478,'Retail Sale Id 1462240',3600.00,0.00,0.00,6.00,372.00,'2022-02-19 14:01:05','',''),(2614572,'1','201','1037',478,'Retail Sale Id 1462241',6000.00,0.00,0.00,10.00,620.00,'2022-02-19 14:07:27','',''),(2614573,'1','201','1037',478,'Retail Sale Id 1462242',600.00,0.00,0.00,1.00,62.00,'2022-02-19 14:08:55','',''),(2614574,'1','201','1037',478,'Retail Sale Id 1462242',600.00,0.00,0.00,1.00,62.00,'2022-02-19 14:08:55','',''),(2614575,'1','201','1037',478,'Retail Sale Id 1462243',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 14:16:27','',''),(2614576,'1','201','1037',478,'Retail Sale Id 1462244',3600.00,0.00,0.00,6.00,372.00,'2022-02-19 14:27:28','',''),(2614577,'1','201','1037',478,'Retail Sale Id 1462245',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 14:47:40','',''),(2614578,'1','201','1037',478,'Retail Sale Id 1462245',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 14:47:41','',''),(2614579,'1','201','1037',478,'Retail Sale Id 1462246',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 14:55:28','',''),(2614580,'1','201','1037',478,'Retail Sale Id 1462247',3000.00,0.00,0.00,5.00,310.00,'2022-02-19 14:56:36','',''),(2614581,'1','201','1037',478,'Retail Sale Id 1462248',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 15:08:20','',''),(2614582,'1','201','1037',478,'Retail Sale Id 1462249',7125.00,0.00,0.00,12.50,400.00,'2022-02-19 15:30:05','',''),(2614583,'1','201','1037',478,'Retail Sale Id 1462250',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 15:35:14','',''),(2614584,'1','201','1037',478,'Retail Sale Id 1462251',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 15:44:36','',''),(2614585,'1','201','1037',478,'Retail Sale Id 1462252',2100.00,0.00,0.00,3.50,217.00,'2022-02-19 15:46:21','',''),(2614586,'1','201','1037',478,'Retail Sale Id 1462253',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 15:47:18','',''),(2614587,'1','201','1037',478,'Retail Sale Id 1462254',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 15:56:05','',''),(2614588,'1','201','1037',478,'Retail Sale Id 1462255',2400.00,0.00,0.00,4.00,248.00,'2022-02-19 16:12:57','',''),(2614589,'1','201','1037',478,'Retail Sale Id 1462256',7500.00,0.00,0.00,12.50,775.00,'2022-02-19 16:21:06','',''),(2614590,'1','201','1037',478,'Retail Sale Id 1462257',3600.00,0.00,0.00,6.00,372.00,'2022-02-19 16:30:48','',''),(2614591,'1','201','1037',478,'Retail Sale Id 1462258',600.00,0.00,0.00,1.00,62.00,'2022-02-19 16:33:48','',''),(2614592,'1','201','1037',478,'Retail Sale Id 1462259',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 16:36:46','',''),(2614593,'1','201','1037',478,'Retail Sale Id 1462260',600.00,0.00,0.00,1.00,62.00,'2022-02-19 17:02:45','',''),(2614594,'1','201','1037',478,'Retail Sale Id 1462261',1200.00,0.00,0.00,2.00,124.00,'2022-02-19 17:04:08','',''),(2614595,'1','201','1037',478,'Retail Sale Id 1462262',4200.00,0.00,0.00,7.00,434.00,'2022-02-19 17:08:05','',''),(2614596,'1','201','1037',478,'Retail Sale Id 1462263',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 17:10:14','',''),(2614597,'1','201','1037',478,'Retail Sale Id 1462264',2400.00,0.00,0.00,4.00,248.00,'2022-02-19 17:26:08','',''),(2614598,'1','201','1037',478,'Retail Sale Id 1462265',600.00,0.00,0.00,1.00,62.00,'2022-02-19 17:28:00','',''),(2614599,'1','201','1037',478,'Retail Sale Id 1462266',3000.00,0.00,0.00,5.00,310.00,'2022-02-19 17:28:47','',''),(2614600,'1','201','1037',478,'Retail Sale Id 1462267',1002.00,0.00,0.00,1.67,103.54,'2022-02-19 17:54:51','',''),(2614601,'1','201','1037',478,'Retail Sale Id 1462268',3000.00,0.00,0.00,5.00,310.00,'2022-02-19 18:03:33','',''),(2614602,'1','201','1037',478,'Retail Sale Id 1462270',4998.00,0.00,0.00,8.33,516.46,'2022-02-19 18:18:48','',''),(2614603,'1','201','1037',478,'Retail Sale Id 1462271',600.00,0.00,0.00,1.00,62.00,'2022-02-19 18:19:50','',''),(2614604,'1','201','1037',478,'Retail Sale Id 1462272',1800.00,0.00,0.00,3.00,186.00,'2022-02-19 18:27:26','',''),(2614605,'1','201','1037',478,'Return of Retail Sale Id 1462262',0.00,4200.00,7.00,0.00,-434.00,'2022-02-19 18:45:36','',''),(2614606,'1','201','1037',478,'Retail Sale Id 1462273',3900.00,0.00,0.00,6.50,403.00,'2022-02-19 18:46:39','',''),(2614607,'1','201','1037',478,'Retail Sale Id 1462274',600.00,0.00,0.00,1.00,62.00,'2022-02-20 08:20:56','',''),(2614608,'1','201','1037',478,'Retail Sale Id 1462274',600.00,0.00,0.00,1.00,62.00,'2022-02-20 08:20:56','',''),(2614609,'1','201','1037',478,'Retail Sale Id 1462275',4200.00,0.00,0.00,7.00,434.00,'2022-02-20 08:22:12','',''),(2614610,'1','201','1037',478,'Retail Sale Id 1462276',600.00,0.00,0.00,1.00,62.00,'2022-02-20 08:36:16','',''),(2614611,'1','201','1037',478,'Retail Sale Id 1462277',7500.00,0.00,0.00,12.50,775.00,'2022-02-20 09:17:58','',''),(2614612,'1','201','1037',478,'Retail Sale Id 1462278',2100.00,0.00,0.00,3.50,217.00,'2022-02-20 09:27:40','',''),(2614613,'1','201','1037',478,'Retail Sale Id 1462279',1200.00,0.00,0.00,2.00,124.00,'2022-02-20 09:31:14','',''),(2614614,'1','201','1037',478,'Retail Sale Id 1462280',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 09:50:36','',''),(2614615,'1','201','1037',478,'Retail Sale Id 1462281',3600.00,0.00,0.00,6.00,372.00,'2022-02-20 09:59:14','',''),(2614616,'1','201','1037',478,'Retail Sale Id 1462282',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 10:07:50','',''),(2614617,'1','201','1037',478,'Retail Sale Id 1462283',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 10:10:36','',''),(2614618,'1','201','1037',478,'Retail Sale Id 1462284',7500.00,0.00,0.00,12.50,775.00,'2022-02-20 10:12:03','',''),(2614619,'1','201','1037',478,'Retail Sale Id 1462285',7500.00,0.00,0.00,12.50,775.00,'2022-02-20 10:17:11','',''),(2614620,'1','201','1037',478,'Retail Sale Id 1462286',1200.00,0.00,0.00,2.00,124.00,'2022-02-20 10:24:14','',''),(2614621,'1','201','1037',478,'Retail Sale Id 1462287',3600.00,0.00,0.00,6.00,372.00,'2022-02-20 10:44:48','',''),(2614622,'1','201','1037',478,'Retail Sale Id 1462288',1200.00,0.00,0.00,2.00,124.00,'2022-02-20 10:45:34','',''),(2614623,'1','201','1037',478,'Retail Sale Id 1462289',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 10:59:56','',''),(2614624,'1','201','1037',478,'Retail Sale Id 1462290',1200.00,0.00,0.00,2.00,124.00,'2022-02-20 11:07:32','',''),(2614625,'1','201','1037',478,'Retail Sale Id 1462290',1200.00,0.00,0.00,2.00,124.00,'2022-02-20 11:07:32','',''),(2614626,'1','201','1037',478,'Retail Sale Id 1462291',2400.00,0.00,0.00,4.00,248.00,'2022-02-20 11:10:51','',''),(2614627,'1','201','1037',478,'Retail Sale Id 1462292',3000.00,0.00,0.00,5.00,310.00,'2022-02-20 11:12:12','',''),(2614628,'1','201','1037',478,'Retail Sale Id 1462293',600.00,0.00,0.00,1.00,62.00,'2022-02-20 11:18:27','',''),(2614629,'1','201','1037',478,'Retail Sale Id 1462294',600.00,0.00,0.00,1.00,62.00,'2022-02-20 11:36:17','',''),(2614630,'1','201','1037',478,'Retail Sale Id 1462295',600.00,0.00,0.00,1.00,62.00,'2022-02-20 11:42:39','',''),(2614631,'1','201','1037',478,'Retail Sale Id 1462296',1200.00,0.00,0.00,2.00,124.00,'2022-02-20 11:47:40','',''),(2614632,'1','201','1037',478,'Retail Sale Id 1462297',7200.00,0.00,0.00,12.00,744.00,'2022-02-20 12:01:04','',''),(2614633,'1','201','1037',478,'Retail Sale Id 1462298',3000.00,0.00,0.00,5.00,310.00,'2022-02-20 12:15:11','',''),(2614634,'1','201','1037',478,'Retail Sale Id 1462299',2400.00,0.00,0.00,4.00,248.00,'2022-02-20 12:28:56','',''),(2614635,'1','201','1037',478,'Retail Sale Id 1462300',3600.00,0.00,0.00,6.00,372.00,'2022-02-20 12:41:41','',''),(2614636,'1','201','1037',478,'Retail Sale Id 1462301',7500.00,0.00,0.00,12.50,775.00,'2022-02-20 12:42:34','',''),(2614637,'1','201','1037',478,'Retail Sale Id 1462302',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 12:57:01','',''),(2614638,'1','201','1037',478,'Retail Sale Id 1462303',3000.00,0.00,0.00,5.00,310.00,'2022-02-20 12:58:31','',''),(2614639,'1','201','1037',478,'Retail Sale Id 1462304',3600.00,0.00,0.00,6.00,372.00,'2022-02-20 14:10:14','',''),(2614640,'1','201','1037',478,'Retail Sale Id 1462305',3000.00,0.00,0.00,5.00,310.00,'2022-02-20 14:17:11','',''),(2614641,'1','201','1037',478,'Retail Sale Id 1462306',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 14:20:22','',''),(2614642,'1','201','1037',478,'Retail Sale Id 1462307',4200.00,0.00,0.00,7.00,434.00,'2022-02-20 14:39:44','',''),(2614643,'1','201','1037',478,'Retail Sale Id 1462308',7500.00,0.00,0.00,12.50,775.00,'2022-02-20 14:43:06','',''),(2614644,'1','201','1037',478,'Retail Sale Id 1462309',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 14:51:40','',''),(2614645,'1','201','1037',478,'Retail Sale Id 1462310',1200.00,0.00,0.00,2.00,124.00,'2022-02-20 15:02:14','',''),(2614646,'1','201','1037',478,'Retail Sale Id 1462311',2400.00,0.00,0.00,4.00,248.00,'2022-02-20 15:02:59','',''),(2614647,'1','201','1037',478,'Retail Sale Id 1462312',1200.00,0.00,0.00,2.00,124.00,'2022-02-20 15:15:33','',''),(2614648,'1','201','1037',478,'Retail Sale Id 1462313',3000.00,0.00,0.00,5.00,310.00,'2022-02-20 15:16:50','',''),(2614649,'1','201','1037',478,'Retail Sale Id 1462314',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 15:53:24','',''),(2614650,'1','201','1037',478,'Retail Sale Id 1462315',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 15:58:55','',''),(2614651,'1','201','1037',478,'Retail Sale Id 1462316',1200.00,0.00,0.00,2.00,124.00,'2022-02-20 15:59:49','',''),(2614652,'1','201','1037',478,'Retail Sale Id 1462317',2400.00,0.00,0.00,4.00,248.00,'2022-02-20 16:21:57','',''),(2614653,'1','201','1037',478,'Retail Sale Id 1462318',3600.00,0.00,0.00,6.00,372.00,'2022-02-20 16:23:01','',''),(2614654,'1','201','1037',478,'Retail Sale Id 1462319',3600.00,0.00,0.00,6.00,372.00,'2022-02-20 16:24:12','',''),(2614655,'1','201','1037',478,'Retail Sale Id 1462320',600.00,0.00,0.00,1.00,62.00,'2022-02-20 16:47:33','',''),(2614656,'1','201','1037',478,'Retail Sale Id 1462320',600.00,0.00,0.00,1.00,62.00,'2022-02-20 16:47:33','',''),(2614657,'1','201','1037',478,'Retail Sale Id 1462321',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 16:50:00','',''),(2614658,'1','201','1037',478,'Retail Sale Id 1462322',3600.00,0.00,0.00,6.00,372.00,'2022-02-20 16:50:54','',''),(2614659,'1','201','1037',478,'Retail Sale Id 1462323',7500.00,0.00,0.00,12.50,775.00,'2022-02-20 16:53:14','',''),(2614660,'1','201','1037',478,'Retail Sale Id 1462324',4200.00,0.00,0.00,7.00,434.00,'2022-02-20 17:09:23','',''),(2614661,'1','201','1037',478,'Retail Sale Id 1462325',1500.00,0.00,0.00,2.50,155.00,'2022-02-20 17:14:48','',''),(2614662,'1','201','1037',478,'Retail Sale Id 1462326',600.00,0.00,0.00,1.00,62.00,'2022-02-20 17:15:36','',''),(2614663,'1','201','1037',478,'Retail Sale Id 1462327',600.00,0.00,0.00,1.00,62.00,'2022-02-20 17:16:31','',''),(2614664,'1','201','1037',478,'Retail Sale Id 1462328',3000.00,0.00,0.00,5.00,310.00,'2022-02-20 17:17:26','',''),(2614665,'1','201','1037',478,'Retail Sale Id 1462329',600.00,0.00,0.00,1.00,62.00,'2022-02-20 17:22:21','',''),(2614666,'1','201','1037',478,'Retail Sale Id 1462330',3000.00,0.00,0.00,5.00,310.00,'2022-02-20 17:23:47','',''),(2614667,'1','201','1037',478,'Retail Sale Id 1462331',1200.00,0.00,0.00,2.00,124.00,'2022-02-20 17:24:27','',''),(2614668,'1','201','1037',478,'Retail Sale Id 1462332',1800.00,0.00,0.00,3.00,186.00,'2022-02-20 17:44:04','',''),(2614669,'1','201','1037',478,'Retail Sale Id 1462333',7500.00,0.00,0.00,12.50,775.00,'2022-02-20 17:54:38','',''),(2614670,'1','201','1037',478,'Retail Sale Id 1462334',4200.00,0.00,0.00,7.00,434.00,'2022-02-20 17:58:03','',''),(2614671,'1','201','1037',478,'Retail Sale Id 1462335',1500.00,0.00,0.00,2.50,155.00,'2022-02-20 18:10:50','',''),(2614672,'1','201','1037',478,'Retail Sale Id 1462336',798.00,0.00,0.00,1.33,82.46,'2022-02-20 18:25:52','',''),(2614673,'1','201','1037',478,'Retail Sale Id 1462336',798.00,0.00,0.00,1.33,82.46,'2022-02-20 18:25:52','',''),(2614674,'1','201','1037',478,'Retail Sale Id 1462337',3600.00,0.00,0.00,6.00,372.00,'2022-02-20 18:38:07','',''),(2614675,'1','201','1037',478,'Retail Sale Id 1462338',600.00,0.00,0.00,1.00,62.00,'2022-02-21 07:58:13','',''),(2614676,'1','201','1037',478,'Retail Sale Id 1462339',1200.00,0.00,0.00,2.00,124.00,'2022-02-21 08:09:29','',''),(2614677,'1','201','1037',478,'Retail Sale Id 1462340',3000.00,0.00,0.00,5.00,310.00,'2022-02-21 08:13:42','',''),(2614678,'1','201','1037',478,'Retail Sale Id 1462341',4200.00,0.00,0.00,7.00,434.00,'2022-02-21 08:19:23','',''),(2614679,'1','201','1037',478,'Retail Sale Id 1462342',2400.00,0.00,0.00,4.00,248.00,'2022-02-21 08:28:42','',''),(2614680,'1','201','1037',478,'Retail Sale Id 1462343',4200.00,0.00,0.00,7.00,434.00,'2022-02-21 08:29:54','',''),(2614681,'1','201','1037',478,'Retail Sale Id 1462344',600.00,0.00,0.00,1.00,62.00,'2022-02-21 08:30:53','',''),(2614682,'1','201','1037',478,'Retail Sale Id 1462345',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 08:32:35','',''),(2614683,'1','201','1037',478,'Retail Sale Id 1462346',2400.00,0.00,0.00,4.00,248.00,'2022-02-21 08:33:22','',''),(2614684,'1','201','1037',478,'Retail Sale Id 1462347',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 08:35:04','',''),(2614685,'1','201','1037',478,'Retail Sale Id 1462348',9690.00,0.00,0.00,17.00,544.00,'2022-02-21 09:01:10','',''),(2614686,'1','201','1037',478,'Retail Sale Id 1462349',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 09:02:19','',''),(2614687,'1','201','1037',478,'Retail Sale Id 1462350',7500.00,0.00,0.00,12.50,775.00,'2022-02-21 09:15:52','',''),(2614688,'1','201','1037',478,'Retail Sale Id 1462351',3600.00,0.00,0.00,6.00,372.00,'2022-02-21 09:16:51','',''),(2614689,'1','201','1037',478,'Retail Sale Id 1462352',600.00,0.00,0.00,1.00,62.00,'2022-02-21 09:24:02','',''),(2614690,'1','201','1037',478,'Retail Sale Id 1462353',7500.00,0.00,0.00,12.50,775.00,'2022-02-21 09:36:06','',''),(2614691,'1','201','1037',478,'Retail Sale Id 1462354',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 10:01:51','',''),(2614692,'1','201','1037',478,'Retail Sale Id 1462355',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 10:05:08','',''),(2614693,'1','201','1037',478,'Retail Sale Id 1462355',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 10:05:08','',''),(2614694,'1','201','1037',478,'Retail Sale Id 1462356',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 10:16:19','',''),(2614695,'1','201','1037',478,'Retail Sale Id 1462357',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 11:00:08','',''),(2614696,'1','201','1037',478,'Retail Sale Id 1462358',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 11:05:39','',''),(2614697,'1','201','1037',478,'Retail Sale Id 1462359',900.00,0.00,0.00,1.50,93.00,'2022-02-21 11:12:06','',''),(2614698,'1','201','1037',478,'Retail Sale Id 1462360',900.00,0.00,0.00,1.50,93.00,'2022-02-21 11:12:55','',''),(2614699,'1','201','1037',478,'Retail Sale Id 1462361',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 11:24:54','',''),(2614700,'1','201','1037',478,'Retail Sale Id 1462362',7500.00,0.00,0.00,12.50,775.00,'2022-02-21 11:28:39','',''),(2614701,'1','201','1037',478,'Retail Sale Id 1462363',6000.00,0.00,0.00,10.00,620.00,'2022-02-21 11:30:06','',''),(2614702,'1','201','1037',478,'Retail Sale Id 1462363',7500.00,0.00,0.00,12.50,775.00,'2022-02-21 11:30:06','',''),(2614703,'1','201','1037',478,'Retail Sale Id 1462364',3600.00,0.00,0.00,6.00,372.00,'2022-02-21 11:39:59','',''),(2614704,'1','201','1037',478,'Retail Sale Id 1462365',3000.00,0.00,0.00,5.00,310.00,'2022-02-21 11:41:15','',''),(2614705,'1','201','1037',478,'Retail Sale Id 1462366',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 11:49:24','',''),(2614706,'1','201','1037',478,'Retail Sale Id 1462367',900.00,0.00,0.00,1.50,93.00,'2022-02-21 11:57:12','',''),(2614707,'1','201','1037',478,'Retail Sale Id 1462368',3600.00,0.00,0.00,6.00,372.00,'2022-02-21 11:58:57','',''),(2614708,'1','201','1037',478,'Retail Sale Id 1462369',600.00,0.00,0.00,1.00,62.00,'2022-02-21 12:19:39','',''),(2614709,'1','201','1037',478,'Retail Sale Id 1462370',600.00,0.00,0.00,1.00,62.00,'2022-02-21 12:23:26','',''),(2614710,'1','201','1037',478,'Retail Sale Id 1462372',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 12:28:50','',''),(2614711,'1','201','1037',478,'Retail Sale Id 1462373',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 12:37:47','',''),(2614712,'1','201','1037',478,'Retail Sale Id 1462374',6000.00,0.00,0.00,10.00,620.00,'2022-02-21 12:39:58','',''),(2614713,'1','201','1037',478,'Retail Sale Id 1462375',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 12:57:00','',''),(2614714,'1','201','1037',478,'Retail Sale Id 1462376',1200.00,0.00,0.00,2.00,124.00,'2022-02-21 13:32:33','',''),(2614715,'1','201','1037',478,'Retail Sale Id 1462377',7500.00,0.00,0.00,12.50,775.00,'2022-02-21 13:34:06','',''),(2614716,'1','201','1037',478,'Retail Sale Id 1462378',4002.00,0.00,0.00,6.67,413.54,'2022-02-21 13:51:29','',''),(2614717,'1','201','1037',478,'Retail Sale Id 1462379',1002.00,0.00,0.00,1.67,103.54,'2022-02-21 13:53:49','',''),(2614718,'1','201','1037',478,'Retail Sale Id 1462380',4200.00,0.00,0.00,7.00,434.00,'2022-02-21 13:58:22','',''),(2614719,'1','201','1037',478,'Retail Sale Id 1462381',3000.00,0.00,0.00,5.00,310.00,'2022-02-21 14:10:34','',''),(2614720,'1','201','1037',478,'Retail Sale Id 1462382',6600.00,0.00,0.00,11.00,682.00,'2022-02-21 14:19:22','',''),(2614721,'1','201','1037',478,'Retail Sale Id 1462383',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 14:29:46','',''),(2614722,'1','201','1037',478,'Retail Sale Id 1462384',7500.00,0.00,0.00,12.50,775.00,'2022-02-21 14:45:14','',''),(2614723,'1','201','1037',478,'Retail Sale Id 1462385',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 14:57:22','',''),(2614724,'1','201','1037',478,'Retail Sale Id 1462386',3000.00,0.00,0.00,5.00,310.00,'2022-02-21 15:01:29','',''),(2614725,'1','201','1037',478,'Retail Sale Id 1462387',600.00,0.00,0.00,1.00,62.00,'2022-02-21 15:32:09','',''),(2614726,'1','201','1037',478,'Retail Sale Id 1462388',4200.00,0.00,0.00,7.00,434.00,'2022-02-21 15:37:09','',''),(2614727,'1','201','1037',478,'Retail Sale Id 1462389',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 15:41:58','',''),(2614728,'1','201','1037',478,'Retail Sale Id 1462390',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 15:44:42','',''),(2614729,'1','201','1037',478,'Retail Sale Id 1462391',7500.00,0.00,0.00,12.50,775.00,'2022-02-21 15:49:34','',''),(2614730,'1','201','1037',478,'Retail Sale Id 1462392',3600.00,0.00,0.00,6.00,372.00,'2022-02-21 15:50:15','',''),(2614731,'1','201','1037',478,'Retail Sale Id 1462393',7500.00,0.00,0.00,12.50,775.00,'2022-02-21 15:53:54','',''),(2614732,'1','201','1037',478,'Retail Sale Id 1462394',600.00,0.00,0.00,1.00,62.00,'2022-02-21 16:01:16','',''),(2614733,'1','201','1037',478,'Retail Sale Id 1462395',7500.00,0.00,0.00,12.50,775.00,'2022-02-21 16:02:18','',''),(2614734,'1','201','1037',478,'Retail Sale Id 1462396',4200.00,0.00,0.00,7.00,434.00,'2022-02-21 16:13:29','',''),(2614735,'1','201','1037',478,'Retail Sale Id 1462397',600.00,0.00,0.00,1.00,62.00,'2022-02-21 16:41:44','',''),(2614736,'1','201','1037',478,'Retail Sale Id 1462398',3000.00,0.00,0.00,5.00,310.00,'2022-02-21 16:48:05','',''),(2614737,'1','201','1037',478,'Retail Sale Id 1462399',600.00,0.00,0.00,1.00,62.00,'2022-02-21 16:49:58','',''),(2614738,'1','201','1037',478,'Retail Sale Id 1462400',1200.00,0.00,0.00,2.00,124.00,'2022-02-21 17:18:21','',''),(2614739,'1','201','1037',478,'Retail Sale Id 1462400',1200.00,0.00,0.00,2.00,124.00,'2022-02-21 17:18:21','',''),(2614740,'1','201','1037',478,'Retail Sale Id 1462401',600.00,0.00,0.00,1.00,62.00,'2022-02-21 17:19:39','',''),(2614741,'1','201','1037',478,'Retail Sale Id 1462401',600.00,0.00,0.00,1.00,62.00,'2022-02-21 17:19:39','',''),(2614742,'1','201','1037',478,'Retail Sale Id 1462402',600.00,0.00,0.00,1.00,62.00,'2022-02-21 17:27:14','',''),(2614743,'1','201','1037',478,'Retail Sale Id 1462403',1200.00,0.00,0.00,2.00,124.00,'2022-02-21 17:31:23','',''),(2614744,'1','201','1037',478,'Retail Sale Id 1462404',7200.00,0.00,0.00,12.00,744.00,'2022-02-21 17:41:19','',''),(2614745,'1','201','1037',478,'Retail Sale Id 1462405',2400.00,0.00,0.00,4.00,248.00,'2022-02-21 17:57:11','',''),(2614746,'1','201','1037',478,'Retail Sale Id 1462406',4200.00,0.00,0.00,7.00,434.00,'2022-02-21 18:22:10','',''),(2614747,'1','201','1037',478,'Retail Sale Id 1462407',3600.00,0.00,0.00,6.00,372.00,'2022-02-21 18:23:34','',''),(2614748,'1','201','1037',478,'Retail Sale Id 1462408',1800.00,0.00,0.00,3.00,186.00,'2022-02-21 18:24:32','',''),(2614749,'1','201','1037',478,'Return of Retail Sale Id 1462408',0.00,1800.00,3.00,0.00,-186.00,'2022-02-21 18:36:34','',''),(2614750,'1','201','1037',478,'Retail Sale Id 1462409',1638.00,0.00,0.00,2.73,169.26,'2022-02-21 18:38:03','',''),(2614751,'1','201','1037',478,'Return of Retail Sale Id 1462406',0.00,4200.00,7.00,0.00,-434.00,'2022-02-21 19:11:10','',''),(2614752,'1','201','1037',478,'Retail Sale Id 1462410',3822.00,0.00,0.00,6.37,394.94,'2022-02-21 19:11:49','',''),(2614753,'1','201','1037',478,'Retail Sale Id 1462411',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 07:52:16','',''),(2614754,'1','201','1037',478,'Retail Sale Id 1462412',3000.00,0.00,0.00,5.00,310.00,'2022-02-22 08:10:07','',''),(2614755,'1','201','1037',478,'Retail Sale Id 1462413',3000.00,0.00,0.00,5.00,310.00,'2022-02-22 08:26:51','',''),(2614756,'1','201','1037',478,'Retail Sale Id 1462414',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 08:48:18','',''),(2614757,'1','201','1037',478,'Retail Sale Id 1462415',1200.00,0.00,0.00,2.00,124.00,'2022-02-22 09:01:19','',''),(2614758,'1','201','1037',478,'Retail Sale Id 1462416',7500.00,0.00,0.00,12.50,775.00,'2022-02-22 09:10:15','',''),(2614759,'1','201','1037',478,'Retail Sale Id 1462417',4200.00,0.00,0.00,7.00,434.00,'2022-02-22 09:36:55','',''),(2614760,'1','201','1037',478,'Retail Sale Id 1462418',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 09:48:43','',''),(2614761,'1','201','1037',478,'Retail Sale Id 1462419',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 09:56:31','',''),(2614762,'1','201','1037',478,'Retail Sale Id 1462420',2400.00,0.00,0.00,4.00,248.00,'2022-02-22 10:06:51','',''),(2614763,'1','201','1037',478,'Retail Sale Id 1462421',3600.00,0.00,0.00,6.00,372.00,'2022-02-22 10:14:14','',''),(2614764,'1','201','1037',478,'Retail Sale Id 1462422',1200.00,0.00,0.00,2.00,124.00,'2022-02-22 10:20:00','',''),(2614765,'1','201','1037',478,'Retail Sale Id 1462423',900.00,0.00,0.00,1.50,93.00,'2022-02-22 10:20:47','',''),(2614766,'1','201','1037',478,'Retail Sale Id 1462424',7500.00,0.00,0.00,12.50,775.00,'2022-02-22 10:22:05','',''),(2614767,'1','201','1037',478,'Retail Sale Id 1462425',3000.00,0.00,0.00,5.00,310.00,'2022-02-22 10:28:16','',''),(2614768,'1','201','1037',478,'Retail Sale Id 1462426',600.00,0.00,0.00,1.00,62.00,'2022-02-22 10:43:16','',''),(2614769,'1','201','1037',478,'Retail Sale Id 1462427',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 10:44:06','',''),(2614770,'1','201','1037',478,'Retail Sale Id 1462428',7500.00,0.00,0.00,12.50,775.00,'2022-02-22 10:50:11','',''),(2614771,'1','201','1037',478,'Retail Sale Id 1462429',6840.00,0.00,0.00,12.00,384.00,'2022-02-22 10:54:46','',''),(2614772,'1','201','1037',478,'Retail Sale Id 1462430',3600.00,0.00,0.00,6.00,372.00,'2022-02-22 11:16:29','',''),(2614773,'1','201','1037',478,'Retail Sale Id 1462431',4800.00,0.00,0.00,8.00,496.00,'2022-02-22 12:12:54','',''),(2614774,'1','201','1037',478,'Retail Sale Id 1462432',3600.00,0.00,0.00,6.00,372.00,'2022-02-22 12:16:30','',''),(2614775,'1','201','1037',478,'Retail Sale Id 1462433',1002.00,0.00,0.00,1.67,103.54,'2022-02-22 12:31:41','',''),(2614776,'1','201','1037',478,'Retail Sale Id 1462434',3600.00,0.00,0.00,6.00,372.00,'2022-02-22 12:37:37','',''),(2614777,'1','201','1037',478,'Retail Sale Id 1462435',600.00,0.00,0.00,1.00,62.00,'2022-02-22 12:52:13','',''),(2614778,'1','201','1037',478,'Retail Sale Id 1462436',3600.00,0.00,0.00,6.00,372.00,'2022-02-22 12:53:25','',''),(2614779,'1','201','1037',478,'Retail Sale Id 1462436',6000.00,0.00,0.00,10.00,620.00,'2022-02-22 12:53:25','',''),(2614780,'1','201','1037',478,'Retail Sale Id 1462437',3600.00,0.00,0.00,6.00,372.00,'2022-02-22 13:04:19','',''),(2614781,'1','201','1037',478,'Retail Sale Id 1462438',3600.00,0.00,0.00,6.00,372.00,'2022-02-22 14:32:29','',''),(2614782,'1','201','1037',478,'Retail Sale Id 1462439',5700.00,0.00,0.00,9.50,589.00,'2022-02-22 14:36:18','',''),(2614783,'1','201','1037',478,'Retail Sale Id 1462440',1200.00,0.00,0.00,2.00,124.00,'2022-02-22 14:37:36','',''),(2614784,'1','201','1037',478,'Retail Sale Id 1462441',3600.00,0.00,0.00,6.00,372.00,'2022-02-22 15:02:06','',''),(2614785,'1','201','1037',478,'Retail Sale Id 1462442',1998.00,0.00,0.00,3.33,206.46,'2022-02-22 15:03:00','',''),(2614786,'1','201','1037',478,'Retail Sale Id 1462443',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 15:04:43','',''),(2614787,'1','201','1037',478,'Retail Sale Id 1462444',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 15:19:41','',''),(2614788,'1','201','1037',478,'Retail Sale Id 1462445',13800.00,0.00,0.00,23.00,1426.00,'2022-02-22 15:27:50','',''),(2614789,'1','201','1037',478,'Retail Sale Id 1462446',3420.00,0.00,0.00,6.00,192.00,'2022-02-22 15:32:38','',''),(2614790,'1','201','1037',478,'Retail Sale Id 1462447',7200.00,0.00,0.00,12.00,744.00,'2022-02-22 15:50:29','',''),(2614791,'1','201','1037',478,'Retail Sale Id 1462449',2400.00,0.00,0.00,4.00,248.00,'2022-02-22 16:07:22','',''),(2614792,'1','201','1037',478,'Retail Sale Id 1462450',1200.00,0.00,0.00,2.00,124.00,'2022-02-22 16:51:48','',''),(2614793,'1','201','1037',478,'Retail Sale Id 1462451',4200.00,0.00,0.00,7.00,434.00,'2022-02-22 16:54:20','',''),(2614794,'1','201','1037',478,'Retail Sale Id 1462452',1200.00,0.00,0.00,2.00,124.00,'2022-02-22 16:55:50','',''),(2614795,'1','201','1037',478,'Retail Sale Id 1462453',3600.00,0.00,0.00,6.00,372.00,'2022-02-22 16:59:06','',''),(2614796,'1','201','1037',478,'Retail Sale Id 1462454',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 17:04:58','',''),(2614797,'1','201','1037',478,'Retail Sale Id 1462455',1500.00,0.00,0.00,2.50,155.00,'2022-02-22 17:19:08','',''),(2614798,'1','201','1037',478,'Retail Sale Id 1462455',1500.00,0.00,0.00,2.50,155.00,'2022-02-22 17:19:08','',''),(2614799,'1','201','1037',478,'Retail Sale Id 1462456',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 17:27:34','',''),(2614800,'1','201','1037',478,'Retail Sale Id 1462457',600.00,0.00,0.00,1.00,62.00,'2022-02-22 17:28:29','',''),(2614801,'1','201','1037',478,'Retail Sale Id 1462458',3000.00,0.00,0.00,5.00,310.00,'2022-02-22 17:38:20','',''),(2614802,'1','201','1037',478,'Retail Sale Id 1462459',2502.00,0.00,0.00,4.17,258.54,'2022-02-22 17:40:04','',''),(2614803,'1','201','1037',478,'Retail Sale Id 1462460',3000.00,0.00,0.00,5.00,310.00,'2022-02-22 17:40:50','',''),(2614804,'1','201','1037',478,'Retail Sale Id 1462461',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 17:43:06','',''),(2614805,'1','201','1037',478,'Retail Sale Id 1462462',4200.00,0.00,0.00,7.00,434.00,'2022-02-22 17:48:52','',''),(2614806,'1','201','1037',478,'Retail Sale Id 1462463',600.00,0.00,0.00,1.00,62.00,'2022-02-22 17:51:28','',''),(2614807,'1','201','1037',478,'Retail Sale Id 1462464',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 17:54:50','',''),(2614808,'1','201','1037',478,'Retail Sale Id 1462465',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 17:59:07','',''),(2614809,'1','201','1037',478,'Retail Sale Id 1462466',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 18:00:54','',''),(2614810,'1','201','1037',478,'Retail Sale Id 1462467',3600.00,0.00,0.00,6.00,372.00,'2022-02-22 18:07:19','',''),(2614811,'1','201','1037',478,'Retail Sale Id 1462468',3000.00,0.00,0.00,5.00,310.00,'2022-02-22 18:10:39','',''),(2614812,'1','201','1037',478,'Retail Sale Id 1462469',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 18:17:23','',''),(2614813,'1','201','1037',478,'Retail Sale Id 1462469',1800.00,0.00,0.00,3.00,186.00,'2022-02-22 18:17:23','',''),(2614814,'1','201','1037',478,'Retail Sale Id 1462470',1998.00,0.00,0.00,3.33,206.46,'2022-02-22 18:18:55','',''),(2614815,'1','201','1037',478,'Retail Sale Id 1462471',3000.00,0.00,0.00,5.00,310.00,'2022-02-22 18:42:08','',''),(2614816,'1','201','1037',478,'Return of Retail Sale Id 1462466',0.00,1800.00,3.00,0.00,-186.00,'2022-02-22 19:23:44','',''),(2614817,'1','201','1037',478,'Retail Sale Id 1462472',1464.00,0.00,0.00,2.44,151.28,'2022-02-22 19:24:25','',''),(2614818,'1','201','1037',478,'Retail Sale Id 1462473',3000.00,0.00,0.00,5.00,310.00,'2022-02-23 07:58:00','',''),(2614819,'1','201','1037',478,'Retail Sale Id 1462474',10260.00,0.00,0.00,18.00,576.00,'2022-02-23 08:22:42','',''),(2614820,'1','201','1037',478,'Retail Sale Id 1462475',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 08:35:36','',''),(2614821,'1','201','1037',478,'Retail Sale Id 1462476',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 08:43:38','',''),(2614822,'1','201','1037',478,'Retail Sale Id 1462477',498.00,0.00,0.00,0.83,51.46,'2022-02-23 08:48:20','',''),(2614823,'1','201','1037',478,'Retail Sale Id 1462478',4002.00,0.00,0.00,6.67,413.54,'2022-02-23 08:49:13','',''),(2614824,'1','201','1037',478,'Retail Sale Id 1462479',6000.00,0.00,0.00,10.00,620.00,'2022-02-23 08:56:05','',''),(2614825,'1','201','1037',478,'Retail Sale Id 1462480',2400.00,0.00,0.00,4.00,248.00,'2022-02-23 09:10:29','',''),(2614826,'1','201','1037',478,'Retail Sale Id 1462481',3000.00,0.00,0.00,5.00,310.00,'2022-02-23 09:17:46','',''),(2614827,'1','201','1037',478,'Retail Sale Id 1462482',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 09:33:14','',''),(2614828,'1','201','1037',478,'Retail Sale Id 1462483',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 10:03:08','',''),(2614829,'1','201','1037',478,'Retail Sale Id 1462487',798.00,0.00,0.00,1.33,82.46,'2022-02-23 11:53:32','',''),(2614830,'1','201','1037',478,'Retail Sale Id 1462488',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 11:54:55','',''),(2614831,'1','201','1037',478,'Retail Sale Id 1462489',1200.00,0.00,0.00,2.00,124.00,'2022-02-23 12:17:22','',''),(2614832,'1','201','1037',478,'Retail Sale Id 1462490',1200.00,0.00,0.00,2.00,124.00,'2022-02-23 13:42:55','',''),(2614833,'1','201','1037',478,'Retail Sale Id 1462491',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 13:59:33','',''),(2614834,'1','201','1037',478,'Retail Sale Id 1462492',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 14:02:33','',''),(2614835,'1','201','1037',478,'Retail Sale Id 1462493',2502.00,0.00,0.00,4.17,258.54,'2022-02-23 14:13:41','',''),(2614836,'1','201','1037',478,'Retail Sale Id 1462494',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 14:18:40','',''),(2614837,'1','201','1037',478,'Retail Sale Id 1462495',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 14:33:20','',''),(2614838,'1','201','1037',478,'Retail Sale Id 1462496',1200.00,0.00,0.00,2.00,124.00,'2022-02-23 14:42:44','',''),(2614839,'1','201','1037',478,'Retail Sale Id 1462497',1200.00,0.00,0.00,2.00,124.00,'2022-02-23 14:48:11','',''),(2614840,'1','201','1037',478,'Retail Sale Id 1462498',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 15:13:35','',''),(2614841,'1','201','1037',478,'Retail Sale Id 1462499',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 15:24:27','',''),(2614842,'1','201','1037',478,'Retail Sale Id 1462500',1200.00,0.00,0.00,2.00,124.00,'2022-02-23 15:29:06','',''),(2614843,'1','201','1037',478,'Retail Sale Id 1462501',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 15:38:48','',''),(2614844,'1','201','1037',478,'Retail Sale Id 1462502',3900.00,0.00,0.00,6.50,403.00,'2022-02-23 15:49:35','',''),(2614845,'1','201','1037',478,'Retail Sale Id 1462503',1200.00,0.00,0.00,2.00,124.00,'2022-02-23 15:58:25','',''),(2614846,'1','201','1037',478,'Retail Sale Id 1462504',3000.00,0.00,0.00,5.00,310.00,'2022-02-23 16:13:40','',''),(2614847,'1','201','1037',478,'Retail Sale Id 1462505',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 16:15:07','',''),(2614848,'1','201','1037',478,'Retail Sale Id 1462506',6000.00,0.00,0.00,10.00,620.00,'2022-02-23 16:15:58','',''),(2614849,'1','201','1037',478,'Retail Sale Id 1462507',1200.00,0.00,0.00,2.00,124.00,'2022-02-23 16:16:43','',''),(2614850,'1','201','1037',478,'Retail Sale Id 1462508',1200.00,0.00,0.00,2.00,124.00,'2022-02-23 16:17:15','',''),(2614851,'1','201','1037',478,'Retail Sale Id 1462509',1200.00,0.00,0.00,2.00,124.00,'2022-02-23 16:17:54','',''),(2614852,'1','201','1037',478,'Retail Sale Id 1462510',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 16:24:27','',''),(2614853,'1','201','1037',478,'Retail Sale Id 1462511',4002.00,0.00,0.00,6.67,413.54,'2022-02-23 16:25:29','',''),(2614854,'1','201','1037',478,'Retail Sale Id 1462512',3900.00,0.00,0.00,6.50,403.00,'2022-02-23 16:39:03','',''),(2614855,'1','201','1037',478,'Retail Sale Id 1462513',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 16:39:48','',''),(2614856,'1','201','1037',478,'Retail Sale Id 1462514',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 16:40:38','',''),(2614857,'1','201','1037',478,'Retail Sale Id 1462515',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 16:43:32','',''),(2614858,'1','201','1037',478,'Retail Sale Id 1462516',3000.00,0.00,0.00,5.00,310.00,'2022-02-23 16:44:20','',''),(2614859,'1','201','1037',478,'Retail Sale Id 1462517',600.00,0.00,0.00,1.00,62.00,'2022-02-23 16:57:16','',''),(2614860,'1','201','1037',478,'Retail Sale Id 1462518',600.00,0.00,0.00,1.00,62.00,'2022-02-23 17:02:14','',''),(2614861,'1','201','1037',478,'Retail Sale Id 1462519',600.00,0.00,0.00,1.00,62.00,'2022-02-23 17:08:44','',''),(2614862,'1','201','1037',478,'Retail Sale Id 1462520',1998.00,0.00,0.00,3.33,206.46,'2022-02-23 17:10:43','',''),(2614863,'1','201','1037',478,'Retail Sale Id 1462521',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 17:14:53','',''),(2614864,'1','201','1037',478,'Retail Sale Id 1462522',600.00,0.00,0.00,1.00,62.00,'2022-02-23 17:15:57','',''),(2614865,'1','201','1037',478,'Retail Sale Id 1462523',7500.00,0.00,0.00,12.50,775.00,'2022-02-23 17:19:42','',''),(2614866,'1','201','1037',478,'Retail Sale Id 1462524',1200.00,0.00,0.00,2.00,124.00,'2022-02-23 17:29:23','',''),(2614867,'1','201','1037',478,'Retail Sale Id 1462525',3420.00,0.00,0.00,6.00,192.00,'2022-02-23 17:32:14','',''),(2614868,'1','201','1037',478,'Retail Sale Id 1462526',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 17:46:02','',''),(2614869,'1','201','1037',478,'Retail Sale Id 1462527',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 17:55:57','',''),(2614870,'1','201','1037',478,'Retail Sale Id 1462528',3000.00,0.00,0.00,5.00,310.00,'2022-02-23 17:57:08','',''),(2614871,'1','201','1037',478,'Retail Sale Id 1462529',900.00,0.00,0.00,1.50,93.00,'2022-02-23 17:57:57','',''),(2614872,'1','201','1037',478,'Retail Sale Id 1462530',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 17:59:14','',''),(2614873,'1','201','1037',478,'Retail Sale Id 1462531',7500.00,0.00,0.00,12.50,775.00,'2022-02-23 18:00:07','',''),(2614874,'1','201','1037',478,'Retail Sale Id 1462532',3600.00,0.00,0.00,6.00,372.00,'2022-02-23 18:09:08','',''),(2614875,'1','201','1037',478,'Retail Sale Id 1462533',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 18:09:58','',''),(2614876,'1','201','1037',478,'Retail Sale Id 1462534',1800.00,0.00,0.00,3.00,186.00,'2022-02-23 18:35:18','',''),(2614877,'1','201','1037',478,'Retail Sale Id 1462535',6270.00,0.00,0.00,11.00,352.00,'2022-02-23 18:46:40','',''),(2614878,'1','201','1037',478,'Return of Retail Sale Id 1462527',0.00,3600.00,6.00,0.00,-372.00,'2022-02-23 19:36:07','',''),(2614879,'1','201','1037',478,'Retail Sale Id 1462536',3540.00,0.00,0.00,5.90,365.80,'2022-02-23 19:36:43','',''),(2614880,'1','201','1037',478,'Retail Sale Id 1462537',7500.00,0.00,0.00,12.50,775.00,'2022-02-24 08:02:37','',''),(2614881,'1','201','1037',478,'Retail Sale Id 1462538',3000.00,0.00,0.00,5.00,310.00,'2022-02-24 08:10:22','',''),(2614882,'1','201','1037',478,'Retail Sale Id 1462539',600.00,0.00,0.00,1.00,62.00,'2022-02-24 08:17:38','',''),(2614883,'1','201','1037',478,'Retail Sale Id 1462540',7500.00,0.00,0.00,12.50,775.00,'2022-02-24 08:22:05','',''),(2614884,'1','201','1037',478,'Retail Sale Id 1462541',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 08:25:24','',''),(2614885,'1','201','1037',478,'Retail Sale Id 1462542',3000.00,0.00,0.00,5.00,310.00,'2022-02-24 08:31:27','',''),(2614886,'1','201','1037',478,'Retail Sale Id 1462544',4002.00,0.00,0.00,6.67,413.54,'2022-02-24 08:36:50','',''),(2614887,'1','201','1037',478,'Retail Sale Id 1462545',14250.00,0.00,0.00,25.00,800.00,'2022-02-24 08:49:51','',''),(2614888,'1','201','1037',478,'Retail Sale Id 1462546',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 08:55:31','',''),(2614889,'1','201','1037',478,'Retail Sale Id 1462547',3600.00,0.00,0.00,6.00,372.00,'2022-02-24 09:33:13','',''),(2614890,'1','201','1037',478,'Retail Sale Id 1462548',600.00,0.00,0.00,1.00,62.00,'2022-02-24 09:34:23','',''),(2614891,'1','201','1037',478,'Retail Sale Id 1462549',1200.00,0.00,0.00,2.00,124.00,'2022-02-24 09:35:05','',''),(2614892,'1','201','1037',478,'Retail Sale Id 1462550',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 09:39:17','',''),(2614893,'1','201','1037',478,'Retail Sale Id 1462551',600.00,0.00,0.00,1.00,62.00,'2022-02-24 09:43:02','',''),(2614894,'1','201','1037',478,'Retail Sale Id 1462553',7200.00,0.00,0.00,12.00,744.00,'2022-02-24 09:45:55','',''),(2614895,'1','201','1037',478,'Retail Sale Id 1462553',7800.00,0.00,0.00,13.00,806.00,'2022-02-24 09:45:55','',''),(2614896,'1','201','1037',478,'Retail Sale Id 1462554',3600.00,0.00,0.00,6.00,372.00,'2022-02-24 09:59:19','',''),(2614897,'1','201','1037',478,'Retail Sale Id 1462555',3000.00,0.00,0.00,5.00,310.00,'2022-02-24 10:10:03','',''),(2614898,'1','201','1037',478,'Retail Sale Id 1462556',1500.00,0.00,0.00,2.50,155.00,'2022-02-24 10:15:32','',''),(2614899,'1','201','1037',478,'Retail Sale Id 1462557',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 10:25:05','',''),(2614900,'1','201','1037',478,'Return of Retail Sale Id 1462553',0.00,7200.00,12.00,0.00,-744.00,'2022-02-24 10:55:42','',''),(2614901,'1','201','1037',478,'Return of Retail Sale Id 1462553',0.00,7800.00,13.00,0.00,-806.00,'2022-02-24 10:55:42','',''),(2614902,'1','201','1037',478,'Retail Sale Id 1462558',6138.00,0.00,0.00,10.23,634.26,'2022-02-24 11:00:13','',''),(2614903,'1','201','1037',478,'Retail Sale Id 1462558',7200.00,0.00,0.00,12.00,744.00,'2022-02-24 11:00:13','',''),(2614904,'1','201','1037',478,'Retail Sale Id 1462559',1500.00,0.00,0.00,2.50,155.00,'2022-02-24 11:09:55','',''),(2614905,'1','201','1037',478,'Retail Sale Id 1462560',56500.00,0.00,0.00,100.00,2700.00,'2022-02-24 11:14:41','',''),(2614906,'1','201','1037',478,'Retail Sale Id 1462561',1200.00,0.00,0.00,2.00,124.00,'2022-02-24 11:35:01','',''),(2614907,'1','201','1037',478,'Retail Sale Id 1462562',6840.00,0.00,0.00,12.00,384.00,'2022-02-24 11:46:53','',''),(2614908,'1','201','1037',478,'Retail Sale Id 1462563',7500.00,0.00,0.00,12.50,775.00,'2022-02-24 11:57:58','',''),(2614909,'1','201','1037',478,'Retail Sale Id 1462564',3900.00,0.00,0.00,6.50,403.00,'2022-02-24 12:04:56','',''),(2614910,'1','201','1037',478,'Retail Sale Id 1462565',2400.00,0.00,0.00,4.00,248.00,'2022-02-24 12:14:51','',''),(2614911,'1','201','1037',478,'Retail Sale Id 1462566',1200.00,0.00,0.00,2.00,124.00,'2022-02-24 12:33:10','',''),(2614912,'1','201','1037',478,'Retail Sale Id 1462567',3420.00,0.00,0.00,6.00,192.00,'2022-02-24 12:46:53','',''),(2614913,'1','201','1037',478,'Retail Sale Id 1462568',1500.00,0.00,0.00,2.50,155.00,'2022-02-24 12:48:27','',''),(2614914,'1','201','1037',478,'Retail Sale Id 1462569',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 12:49:14','',''),(2614915,'1','201','1037',478,'Retail Sale Id 1462570',7500.00,0.00,0.00,12.50,775.00,'2022-02-24 12:50:45','',''),(2614916,'1','201','1037',478,'Retail Sale Id 1462571',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 12:55:08','',''),(2614917,'1','201','1037',478,'Retail Sale Id 1462572',1200.00,0.00,0.00,2.00,124.00,'2022-02-24 12:55:53','',''),(2614918,'1','201','1037',478,'Retail Sale Id 1462573',7002.00,0.00,0.00,11.67,723.54,'2022-02-24 13:14:54','',''),(2614919,'1','201','1037',478,'Retail Sale Id 1462574',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 13:15:58','',''),(2614920,'1','201','1037',478,'Retail Sale Id 1462575',900.00,0.00,0.00,1.50,93.00,'2022-02-24 13:34:03','',''),(2614921,'1','201','1037',478,'Retail Sale Id 1462576',3600.00,0.00,0.00,6.00,372.00,'2022-02-24 14:23:08','',''),(2614922,'1','201','1037',478,'Retail Sale Id 1462577',1200.00,0.00,0.00,2.00,124.00,'2022-02-24 14:42:52','',''),(2614923,'1','201','1037',478,'Retail Sale Id 1462578',3000.00,0.00,0.00,5.00,310.00,'2022-02-24 15:07:57','',''),(2614924,'1','201','1037',478,'Retail Sale Id 1462579',3000.00,0.00,0.00,5.00,310.00,'2022-02-24 15:08:58','',''),(2614925,'1','201','1037',478,'Retail Sale Id 1462580',1002.00,0.00,0.00,1.67,103.54,'2022-02-24 15:21:26','',''),(2614926,'1','201','1037',478,'Retail Sale Id 1462581',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 15:37:27','',''),(2614927,'1','201','1037',478,'Retail Sale Id 1462582',3600.00,0.00,0.00,6.00,372.00,'2022-02-24 15:47:43','',''),(2614928,'1','201','1037',478,'Retail Sale Id 1462583',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 16:21:09','',''),(2614929,'1','201','1037',478,'Retail Sale Id 1462584',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 16:23:05','',''),(2614930,'1','201','1037',478,'Retail Sale Id 1462585',3600.00,0.00,0.00,6.00,372.00,'2022-02-24 16:33:11','',''),(2614931,'1','201','1037',478,'Retail Sale Id 1462586',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 16:46:23','',''),(2614932,'1','201','1037',478,'Retail Sale Id 1462587',7500.00,0.00,0.00,12.50,775.00,'2022-02-24 16:48:33','',''),(2614933,'1','201','1037',478,'Retail Sale Id 1462588',1800.00,0.00,0.00,3.00,186.00,'2022-02-24 16:52:22','',''),(2614934,'1','201','1037',478,'Retail Sale Id 1462589',900.00,0.00,0.00,1.50,93.00,'2022-02-24 17:02:29','',''),(2614935,'1','201','1037',478,'Retail Sale Id 1462590',1200.00,0.00,0.00,2.00,124.00,'2022-02-24 17:09:47','',''),(2614936,'1','201','1037',478,'Retail Sale Id 1462591',3600.00,0.00,0.00,6.00,372.00,'2022-02-24 17:12:45','',''),(2614937,'1','201','1037',478,'Retail Sale Id 1462592',600.00,0.00,0.00,1.00,62.00,'2022-02-24 17:17:07','',''),(2614938,'1','201','1037',478,'Retail Sale Id 1462593',6840.00,0.00,0.00,12.00,384.00,'2022-02-24 17:25:28','',''),(2614939,'1','201','1037',478,'Retail Sale Id 1462594',1200.00,0.00,0.00,2.00,124.00,'2022-02-24 17:31:42','',''),(2614940,'1','201','1037',478,'Retail Sale Id 1462595',1200.00,0.00,0.00,2.00,124.00,'2022-02-24 17:32:29','',''),(2614941,'1','201','1037',478,'Retail Sale Id 1462596',1002.00,0.00,0.00,1.67,103.54,'2022-02-24 17:33:25','',''),(2614942,'1','201','1037',478,'Retail Sale Id 1462597',7200.00,0.00,0.00,12.00,744.00,'2022-02-24 17:37:49','',''),(2614943,'1','201','1037',478,'Retail Sale Id 1462599',1710.00,0.00,0.00,3.00,96.00,'2022-02-24 17:52:50','',''),(2614944,'1','201','1037',478,'Retail Sale Id 1462600',1998.00,0.00,0.00,3.33,206.46,'2022-02-24 17:56:09','',''),(2614945,'1','201','1037',478,'Return of Retail Sale Id 1462591',0.00,3600.00,6.00,0.00,-372.00,'2022-02-24 19:40:43','',''),(2614946,'1','201','1037',478,'Retail Sale Id 1462601',3396.00,0.00,0.00,5.66,350.92,'2022-02-24 19:41:33','',''),(2614947,'1','201','1037',478,'Retail Sale Id 1462602',600.00,0.00,0.00,1.00,62.00,'2022-02-25 07:56:59','',''),(2614948,'1','201','1037',478,'Retail Sale Id 1462603',4002.00,0.00,0.00,6.67,413.54,'2022-02-25 07:59:02','',''),(2614949,'1','201','1037',478,'Retail Sale Id 1462604',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 08:50:43','',''),(2614950,'1','201','1037',478,'Retail Sale Id 1462605',4800.00,0.00,0.00,8.00,496.00,'2022-02-25 08:59:03','',''),(2614951,'1','201','1037',478,'Retail Sale Id 1462606',900.00,0.00,0.00,1.50,93.00,'2022-02-25 09:11:22','',''),(2614952,'1','201','1037',478,'Retail Sale Id 1462607',7200.00,0.00,0.00,12.00,744.00,'2022-02-25 09:13:45','',''),(2614953,'1','201','1037',478,'Retail Sale Id 1462608',1998.00,0.00,0.00,3.33,206.46,'2022-02-25 09:14:53','',''),(2614954,'1','201','1037',478,'Retail Sale Id 1462609',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 09:31:11','',''),(2614955,'1','201','1037',478,'Retail Sale Id 1462610',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 09:48:46','',''),(2614956,'1','201','1037',478,'Retail Sale Id 1462610',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 09:48:46','',''),(2614957,'1','201','1037',478,'Retail Sale Id 1462611',3000.00,0.00,0.00,5.00,310.00,'2022-02-25 09:54:50','',''),(2614958,'1','201','1037',478,'Retail Sale Id 1462612',3000.00,0.00,0.00,5.00,310.00,'2022-02-25 10:09:47','',''),(2614959,'1','201','1037',478,'Retail Sale Id 1462613',3600.00,0.00,0.00,6.00,372.00,'2022-02-25 10:27:59','',''),(2614960,'1','201','1037',478,'Retail Sale Id 1462614',2100.00,0.00,0.00,3.50,217.00,'2022-02-25 10:30:55','',''),(2614961,'1','201','1037',478,'Retail Sale Id 1462615',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 10:35:58','',''),(2614962,'1','201','1037',478,'Retail Sale Id 1462616',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 10:44:55','',''),(2614963,'1','201','1037',478,'Retail Sale Id 1462617',600.00,0.00,0.00,1.00,62.00,'2022-02-25 10:46:27','',''),(2614964,'1','201','1037',478,'Retail Sale Id 1462618',56500.00,0.00,0.00,100.00,2700.00,'2022-02-25 10:51:37','',''),(2614965,'1','201','1037',478,'Retail Sale Id 1462619',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 10:58:43','',''),(2614966,'1','201','1037',478,'Retail Sale Id 1462620',2400.00,0.00,0.00,4.00,248.00,'2022-02-25 11:04:43','',''),(2614967,'1','201','1037',478,'Retail Sale Id 1462621',6000.00,0.00,0.00,10.00,620.00,'2022-02-25 11:06:02','',''),(2614968,'1','201','1037',478,'Retail Sale Id 1462622',3600.00,0.00,0.00,6.00,372.00,'2022-02-25 11:06:41','',''),(2614969,'1','201','1037',478,'Retail Sale Id 1462623',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 11:11:16','',''),(2614970,'1','201','1037',478,'Retail Sale Id 1462624',3000.00,0.00,0.00,5.00,310.00,'2022-02-25 11:13:42','',''),(2614971,'1','201','1037',478,'Retail Sale Id 1462625',28250.00,0.00,0.00,50.00,1350.00,'2022-02-25 11:18:06','',''),(2614972,'1','201','1037',478,'Retail Sale Id 1462626',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 11:18:58','',''),(2614973,'1','201','1037',478,'Retail Sale Id 1462627',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 11:21:22','',''),(2614974,'1','201','1037',478,'Retail Sale Id 1462628',5400.00,0.00,0.00,9.00,558.00,'2022-02-25 11:36:00','',''),(2614975,'1','201','1037',478,'Retail Sale Id 1462629',2400.00,0.00,0.00,4.00,248.00,'2022-02-25 11:47:22','',''),(2614976,'1','201','1037',478,'Retail Sale Id 1462630',7200.00,0.00,0.00,12.00,744.00,'2022-02-25 11:52:52','',''),(2614977,'1','201','1037',478,'Retail Sale Id 1462631',3600.00,0.00,0.00,6.00,372.00,'2022-02-25 11:53:52','',''),(2614978,'1','201','1037',478,'Retail Sale Id 1462632',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 11:54:31','',''),(2614979,'1','201','1037',478,'Retail Sale Id 1462633',2400.00,0.00,0.00,4.00,248.00,'2022-02-25 11:55:23','',''),(2614980,'1','201','1037',478,'Retail Sale Id 1462634',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 11:59:39','',''),(2614981,'1','201','1037',478,'Retail Sale Id 1462635',798.00,0.00,0.00,1.33,82.46,'2022-02-25 12:07:57','',''),(2614982,'1','201','1037',478,'Retail Sale Id 1462636',3600.00,0.00,0.00,6.00,372.00,'2022-02-25 12:17:50','',''),(2614983,'1','201','1037',478,'Retail Sale Id 1462637',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 12:20:59','',''),(2614984,'1','201','1037',478,'Retail Sale Id 1462638',3600.00,0.00,0.00,6.00,372.00,'2022-02-25 13:11:39','',''),(2614985,'1','201','1037',478,'Retail Sale Id 1462639',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 14:10:58','',''),(2614986,'1','201','1037',478,'Retail Sale Id 1462640',7500.00,0.00,0.00,12.50,775.00,'2022-02-25 14:16:11','',''),(2614987,'1','201','1037',478,'Retail Sale Id 1462641',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 14:29:42','',''),(2614988,'1','201','1037',478,'Retail Sale Id 1462642',2400.00,0.00,0.00,4.00,248.00,'2022-02-25 14:34:19','',''),(2614989,'1','201','1037',478,'Retail Sale Id 1462643',6000.00,0.00,0.00,10.00,620.00,'2022-02-25 14:46:02','',''),(2614990,'1','201','1037',478,'Retail Sale Id 1462644',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 14:47:23','',''),(2614991,'1','201','1037',478,'Retail Sale Id 1462645',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 14:51:28','',''),(2614992,'1','201','1037',478,'Retail Sale Id 1462646',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 15:09:51','',''),(2614993,'1','201','1037',478,'Retail Sale Id 1462647',2400.00,0.00,0.00,4.00,248.00,'2022-02-25 15:12:09','',''),(2614994,'1','201','1037',478,'Retail Sale Id 1462648',2802.00,0.00,0.00,4.67,289.54,'2022-02-25 15:17:42','',''),(2614995,'1','201','1037',478,'Retail Sale Id 1462649',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 15:29:30','',''),(2614996,'1','201','1037',478,'Retail Sale Id 1462650',498.00,0.00,0.00,0.83,51.46,'2022-02-25 15:43:32','',''),(2614997,'1','201','1037',478,'Retail Sale Id 1462651',3000.00,0.00,0.00,5.00,310.00,'2022-02-25 16:24:38','',''),(2614998,'1','201','1037',478,'Retail Sale Id 1462652',3600.00,0.00,0.00,6.00,372.00,'2022-02-25 16:51:36','',''),(2614999,'1','201','1037',478,'Retail Sale Id 1462653',3600.00,0.00,0.00,6.00,372.00,'2022-02-25 16:56:35','',''),(2615000,'1','201','1037',478,'Retail Sale Id 1462654',2400.00,0.00,0.00,4.00,248.00,'2022-02-25 17:00:52','',''),(2615001,'1','201','1037',478,'Retail Sale Id 1462655',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 17:03:22','',''),(2615002,'1','201','1037',478,'Retail Sale Id 1462656',600.00,0.00,0.00,1.00,62.00,'2022-02-25 17:05:48','',''),(2615003,'1','201','1037',478,'Retail Sale Id 1462656',600.00,0.00,0.00,1.00,62.00,'2022-02-25 17:05:48','',''),(2615004,'1','201','1037',478,'Retail Sale Id 1462657',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 17:15:41','',''),(2615005,'1','201','1037',478,'Retail Sale Id 1462658',600.00,0.00,0.00,1.00,62.00,'2022-02-25 17:16:55','',''),(2615006,'1','201','1037',478,'Retail Sale Id 1462659',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 17:20:53','',''),(2615007,'1','201','1037',478,'Retail Sale Id 1462660',1200.00,0.00,0.00,2.00,124.00,'2022-02-25 17:21:31','',''),(2615008,'1','201','1037',478,'Retail Sale Id 1462661',498.00,0.00,0.00,0.83,51.46,'2022-02-25 17:22:09','',''),(2615009,'1','201','1037',478,'Retail Sale Id 1462662',2100.00,0.00,0.00,3.50,217.00,'2022-02-25 17:46:18','',''),(2615010,'1','201','1037',478,'Retail Sale Id 1462664',3498.00,0.00,0.00,5.83,361.46,'2022-02-25 17:48:51','',''),(2615011,'1','201','1037',478,'Retail Sale Id 1462665',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 17:55:20','',''),(2615012,'1','201','1037',478,'Retail Sale Id 1462666',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 18:01:27','',''),(2615013,'1','201','1037',478,'Retail Sale Id 1462667',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 18:05:40','',''),(2615014,'1','201','1037',478,'Retail Sale Id 1462668',1800.00,0.00,0.00,3.00,186.00,'2022-02-25 18:07:45','',''),(2615015,'1','201','1037',478,'Retail Sale Id 1462669',18.00,0.00,0.00,0.03,1.86,'2022-02-25 19:13:21','',''),(2615016,'1','201','1037',478,'Retail Sale Id 1462670',7500.00,0.00,0.00,12.50,775.00,'2022-02-26 08:24:16','',''),(2615017,'1','201','1037',478,'Retail Sale Id 1462671',15000.00,0.00,0.00,25.00,1550.00,'2022-02-26 08:25:17','',''),(2615018,'1','201','1037',478,'Retail Sale Id 1462672',3000.00,0.00,0.00,5.00,310.00,'2022-02-26 09:00:58','',''),(2615019,'1','201','1037',478,'Retail Sale Id 1462673',7500.00,0.00,0.00,12.50,775.00,'2022-02-26 09:07:46','',''),(2615020,'1','201','1037',478,'Retail Sale Id 1462674',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 09:31:19','',''),(2615021,'1','201','1037',478,'Retail Sale Id 1462675',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 09:47:46','',''),(2615022,'1','201','1037',478,'Retail Sale Id 1462676',3600.00,0.00,0.00,6.00,372.00,'2022-02-26 09:59:45','',''),(2615023,'1','201','1037',478,'Retail Sale Id 1462677',7500.00,0.00,0.00,12.50,775.00,'2022-02-26 10:15:41','',''),(2615024,'1','201','1037',478,'Retail Sale Id 1462678',6000.00,0.00,0.00,10.00,620.00,'2022-02-26 10:17:44','',''),(2615025,'1','201','1037',478,'Retail Sale Id 1462679',6840.00,0.00,0.00,12.00,384.00,'2022-02-26 10:20:29','',''),(2615026,'1','201','1037',478,'Retail Sale Id 1462680',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 10:21:30','',''),(2615027,'1','201','1037',478,'Retail Sale Id 1462681',600.00,0.00,0.00,1.00,62.00,'2022-02-26 10:22:23','',''),(2615028,'1','201','1037',478,'Retail Sale Id 1462682',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 10:56:03','',''),(2615029,'1','201','1037',478,'Retail Sale Id 1462683',28250.00,0.00,0.00,50.00,1350.00,'2022-02-26 10:59:18','',''),(2615030,'1','201','1037',478,'Retail Sale Id 1462684',600.00,0.00,0.00,1.00,62.00,'2022-02-26 11:07:16','',''),(2615031,'1','201','1037',478,'Retail Sale Id 1462685',6498.00,0.00,0.00,10.83,671.46,'2022-02-26 11:09:29','',''),(2615032,'1','201','1037',478,'Retail Sale Id 1462686',600.00,0.00,0.00,1.00,62.00,'2022-02-26 11:16:49','',''),(2615033,'1','201','1037',478,'Retail Sale Id 1462687',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 11:18:05','',''),(2615034,'1','201','1037',478,'Retail Sale Id 1462688',7500.00,0.00,0.00,12.50,775.00,'2022-02-26 11:47:09','',''),(2615035,'1','201','1037',478,'Retail Sale Id 1462689',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 11:50:36','',''),(2615036,'1','201','1037',478,'Retail Sale Id 1462690',3600.00,0.00,0.00,6.00,372.00,'2022-02-26 11:54:23','',''),(2615037,'1','201','1037',478,'Retail Sale Id 1462691',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 12:02:22','',''),(2615038,'1','201','1037',478,'Retail Sale Id 1462692',3600.00,0.00,0.00,6.00,372.00,'2022-02-26 12:17:21','',''),(2615039,'1','201','1037',478,'Retail Sale Id 1462693',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 12:21:53','',''),(2615040,'1','201','1037',478,'Retail Sale Id 1462694',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 12:29:31','',''),(2615041,'1','201','1037',478,'Retail Sale Id 1462694',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 12:29:31','',''),(2615042,'1','201','1037',478,'Retail Sale Id 1462695',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 12:31:15','',''),(2615043,'1','201','1037',478,'Retail Sale Id 1462696',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 12:58:21','',''),(2615044,'1','201','1037',478,'Retail Sale Id 1462697',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 13:16:11','',''),(2615045,'1','201','1037',478,'Retail Sale Id 1462698',3000.00,0.00,0.00,5.00,310.00,'2022-02-26 13:17:07','',''),(2615046,'1','201','1037',478,'Retail Sale Id 1462699',7500.00,0.00,0.00,12.50,775.00,'2022-02-26 13:24:01','',''),(2615047,'1','201','1037',478,'Retail Sale Id 1462700',6000.00,0.00,0.00,10.00,620.00,'2022-02-26 13:32:08','',''),(2615048,'1','201','1037',478,'Retail Sale Id 1462701',3600.00,0.00,0.00,6.00,372.00,'2022-02-26 13:37:47','',''),(2615049,'1','201','1037',478,'Retail Sale Id 1462702',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 14:25:53','',''),(2615050,'1','201','1037',478,'Retail Sale Id 1462703',3600.00,0.00,0.00,6.00,372.00,'2022-02-26 14:32:04','',''),(2615051,'1','201','1037',478,'Retail Sale Id 1462704',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 14:35:30','',''),(2615052,'1','201','1037',478,'Retail Sale Id 1462705',1500.00,0.00,0.00,2.50,155.00,'2022-02-26 14:41:41','',''),(2615053,'1','201','1037',478,'Retail Sale Id 1462706',300.00,0.00,0.00,0.50,31.00,'2022-02-26 14:42:47','',''),(2615054,'1','201','1037',478,'Retail Sale Id 1462707',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 15:00:20','',''),(2615055,'1','201','1037',478,'Retail Sale Id 1462708',2100.00,0.00,0.00,3.50,217.00,'2022-02-26 15:12:58','',''),(2615056,'1','201','1037',478,'Retail Sale Id 1462709',7500.00,0.00,0.00,12.50,775.00,'2022-02-26 15:14:38','',''),(2615057,'1','201','1037',478,'Retail Sale Id 1462710',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 15:26:56','',''),(2615058,'1','201','1037',478,'Retail Sale Id 1462711',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 15:38:33','',''),(2615059,'1','201','1037',478,'Retail Sale Id 1462712',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 16:24:33','',''),(2615060,'1','201','1037',478,'Retail Sale Id 1462713',3600.00,0.00,0.00,6.00,372.00,'2022-02-26 16:51:02','',''),(2615061,'1','201','1037',478,'Retail Sale Id 1462714',7200.00,0.00,0.00,12.00,744.00,'2022-02-26 16:52:10','',''),(2615062,'1','201','1037',478,'Retail Sale Id 1462715',3600.00,0.00,0.00,6.00,372.00,'2022-02-26 16:57:35','',''),(2615063,'1','201','1037',478,'Retail Sale Id 1462716',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 16:58:20','',''),(2615064,'1','201','1037',478,'Retail Sale Id 1462717',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 17:09:14','',''),(2615065,'1','201','1037',478,'Retail Sale Id 1462717',1998.00,0.00,0.00,3.33,206.46,'2022-02-26 17:09:14','',''),(2615066,'1','201','1037',478,'Retail Sale Id 1462718',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 17:09:57','',''),(2615067,'1','201','1037',478,'Retail Sale Id 1462719',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 17:12:59','',''),(2615068,'1','201','1037',478,'Retail Sale Id 1462719',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 17:12:59','',''),(2615069,'1','201','1037',478,'Retail Sale Id 1462720',1500.00,0.00,0.00,2.50,155.00,'2022-02-26 17:13:44','',''),(2615070,'1','201','1037',478,'Retail Sale Id 1462721',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 17:14:22','',''),(2615071,'1','201','1037',478,'Retail Sale Id 1462722',600.00,0.00,0.00,1.00,62.00,'2022-02-26 17:16:04','',''),(2615072,'1','201','1037',478,'Retail Sale Id 1462723',7500.00,0.00,0.00,12.50,775.00,'2022-02-26 17:18:04','',''),(2615073,'1','201','1037',478,'Retail Sale Id 1462724',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 17:18:48','',''),(2615074,'1','201','1037',478,'Retail Sale Id 1462725',4200.00,0.00,0.00,7.00,434.00,'2022-02-26 17:20:38','',''),(2615075,'1','201','1037',478,'Retail Sale Id 1462726',600.00,0.00,0.00,1.00,62.00,'2022-02-26 17:26:46','',''),(2615076,'1','201','1037',478,'Retail Sale Id 1462727',4800.00,0.00,0.00,8.00,496.00,'2022-02-26 17:29:38','',''),(2615077,'1','201','1037',478,'Retail Sale Id 1462728',3000.00,0.00,0.00,5.00,310.00,'2022-02-26 17:31:54','',''),(2615078,'1','201','1037',478,'Retail Sale Id 1462729',3000.00,0.00,0.00,5.00,310.00,'2022-02-26 17:32:48','',''),(2615079,'1','201','1037',478,'Retail Sale Id 1462730',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 17:40:54','',''),(2615080,'1','201','1037',478,'Retail Sale Id 1462731',1200.00,0.00,0.00,2.00,124.00,'2022-02-26 17:41:49','',''),(2615081,'1','201','1037',478,'Retail Sale Id 1462732',3000.00,0.00,0.00,5.00,310.00,'2022-02-26 17:46:02','',''),(2615082,'1','201','1037',478,'Retail Sale Id 1462733',3600.00,0.00,0.00,6.00,372.00,'2022-02-26 17:50:33','',''),(2615083,'1','201','1037',478,'Retail Sale Id 1462734',1800.00,0.00,0.00,3.00,186.00,'2022-02-26 17:54:26','',''),(2615084,'1','201','1037',478,'Retail Sale Id 1462734',7200.00,0.00,0.00,12.00,744.00,'2022-02-26 17:54:26','',''),(2615085,'1','201','1037',478,'Retail Sale Id 1462735',3000.00,0.00,0.00,5.00,310.00,'2022-02-26 18:15:08','',''),(2615086,'1','201','1037',478,'Retail Sale Id 1462737',6000.00,0.00,0.00,10.00,620.00,'2022-02-26 18:16:45','',''),(2615087,'1','201','1037',478,'Retail Sale Id 1462738',3600.00,0.00,0.00,6.00,372.00,'2022-02-26 18:33:14','',''),(2615088,'1','201','1037',478,'Retail Sale Id 1462739',3000.00,0.00,0.00,5.00,310.00,'2022-02-26 18:37:29','',''),(2615089,'1','201','1037',478,'Retail Sale Id 1462740',7062.50,0.00,0.00,12.50,337.50,'2022-02-26 19:09:01','',''),(2615090,'1','201','1037',478,'Return of Retail Sale Id 1462729',0.00,3000.00,5.00,0.00,-310.00,'2022-02-26 19:31:15','',''),(2615091,'1','201','1037',478,'Retail Sale Id 1462741',2988.00,0.00,0.00,4.98,308.76,'2022-02-26 19:31:50','',''),(2615092,'1','201','1037',478,'Retail Sale Id 1462742',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 07:49:27','',''),(2615093,'1','201','1037',478,'Retail Sale Id 1462743',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 08:13:33','',''),(2615094,'1','201','1037',478,'Retail Sale Id 1462744',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 08:19:38','',''),(2615095,'1','201','1037',478,'Retail Sale Id 1462745',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 08:57:10','',''),(2615096,'1','201','1037',478,'Retail Sale Id 1462746',7500.00,0.00,0.00,12.50,775.00,'2022-02-27 09:00:43','',''),(2615097,'1','201','1037',478,'Retail Sale Id 1462747',56500.00,0.00,0.00,100.00,2700.00,'2022-02-27 09:06:04','',''),(2615098,'1','201','1037',478,'Retail Sale Id 1462748',7500.00,0.00,0.00,12.50,775.00,'2022-02-27 09:13:33','',''),(2615099,'1','201','1037',478,'Retail Sale Id 1462749',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 09:23:24','',''),(2615100,'1','201','1037',478,'Retail Sale Id 1462750',7500.00,0.00,0.00,12.50,775.00,'2022-02-27 09:25:34','',''),(2615101,'1','201','1037',478,'Retail Sale Id 1462751',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 09:40:44','',''),(2615102,'1','201','1037',478,'Retail Sale Id 1462752',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 09:43:21','',''),(2615103,'1','201','1037',478,'Retail Sale Id 1462753',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 09:44:06','',''),(2615104,'1','201','1037',478,'Retail Sale Id 1462754',2400.00,0.00,0.00,4.00,248.00,'2022-02-27 09:46:42','',''),(2615105,'1','201','1037',478,'Retail Sale Id 1462755',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 09:47:51','',''),(2615106,'1','201','1037',478,'Retail Sale Id 1462756',2400.00,0.00,0.00,4.00,248.00,'2022-02-27 09:50:41','',''),(2615107,'1','201','1037',478,'Retail Sale Id 1462757',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 10:26:16','',''),(2615108,'1','201','1037',478,'Retail Sale Id 1462758',7500.00,0.00,0.00,12.50,775.00,'2022-02-27 10:29:50','',''),(2615109,'1','201','1037',478,'Retail Sale Id 1462759',2400.00,0.00,0.00,4.00,248.00,'2022-02-27 10:57:22','',''),(2615110,'1','201','1037',478,'Retail Sale Id 1462760',3300.00,0.00,0.00,5.50,341.00,'2022-02-27 11:03:17','',''),(2615111,'1','201','1037',478,'Retail Sale Id 1462761',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 11:10:25','',''),(2615112,'1','201','1037',478,'Retail Sale Id 1462762',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 11:30:53','',''),(2615113,'1','201','1037',478,'Retail Sale Id 1462763',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 11:32:14','',''),(2615114,'1','201','1037',478,'Retail Sale Id 1462764',7500.00,0.00,0.00,12.50,775.00,'2022-02-27 11:53:40','',''),(2615115,'1','201','1037',478,'Retail Sale Id 1462765',7500.00,0.00,0.00,12.50,775.00,'2022-02-27 11:56:46','',''),(2615116,'1','201','1037',478,'Retail Sale Id 1462766',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 11:57:39','',''),(2615117,'1','201','1037',478,'Retail Sale Id 1462767',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 11:58:30','',''),(2615118,'1','201','1037',478,'Retail Sale Id 1462768',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 12:05:16','',''),(2615119,'1','201','1037',478,'Retail Sale Id 1462769',7500.00,0.00,0.00,12.50,775.00,'2022-02-27 12:07:21','',''),(2615120,'1','201','1037',478,'Retail Sale Id 1462770',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 12:18:30','',''),(2615121,'1','201','1037',478,'Retail Sale Id 1462771',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 12:23:15','',''),(2615122,'1','201','1037',478,'Retail Sale Id 1462773',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 12:31:47','',''),(2615123,'1','201','1037',478,'Retail Sale Id 1462774',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 12:39:44','',''),(2615124,'1','201','1037',478,'Retail Sale Id 1462775',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 12:48:05','',''),(2615125,'1','201','1037',478,'Retail Sale Id 1462775',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 12:48:05','',''),(2615126,'1','201','1037',478,'Retail Sale Id 1462776',28250.00,0.00,0.00,50.00,1350.00,'2022-02-27 12:50:35','',''),(2615127,'1','201','1037',478,'Retail Sale Id 1462777',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 12:51:34','',''),(2615128,'1','201','1037',478,'Retail Sale Id 1462778',600.00,0.00,0.00,1.00,62.00,'2022-02-27 13:18:01','',''),(2615129,'1','201','1037',478,'Retail Sale Id 1462779',5400.00,0.00,0.00,9.00,558.00,'2022-02-27 13:18:46','',''),(2615130,'1','201','1037',478,'Retail Sale Id 1462780',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 13:20:06','',''),(2615131,'1','201','1037',478,'Retail Sale Id 1462781',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 13:35:58','',''),(2615132,'1','201','1037',478,'Retail Sale Id 1462782',2400.00,0.00,0.00,4.00,248.00,'2022-02-27 13:52:34','',''),(2615133,'1','201','1037',478,'Retail Sale Id 1462783',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 13:55:14','',''),(2615134,'1','201','1037',478,'Retail Sale Id 1462784',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 14:17:59','',''),(2615135,'1','201','1037',478,'Retail Sale Id 1462785',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 14:20:56','',''),(2615136,'1','201','1037',478,'Retail Sale Id 1462786',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 14:30:33','',''),(2615137,'1','201','1037',478,'Retail Sale Id 1462787',2400.00,0.00,0.00,4.00,248.00,'2022-02-27 14:34:07','',''),(2615138,'1','201','1037',478,'Retail Sale Id 1462788',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 14:41:04','',''),(2615139,'1','201','1037',478,'Retail Sale Id 1462789',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 14:42:15','',''),(2615140,'1','201','1037',478,'Retail Sale Id 1462790',900.00,0.00,0.00,1.50,93.00,'2022-02-27 14:44:25','',''),(2615141,'1','201','1037',478,'Retail Sale Id 1462791',600.00,0.00,0.00,1.00,62.00,'2022-02-27 14:45:25','',''),(2615142,'1','201','1037',478,'Retail Sale Id 1462792',600.00,0.00,0.00,1.00,62.00,'2022-02-27 15:07:28','',''),(2615143,'1','201','1037',478,'Retail Sale Id 1462793',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 15:08:17','',''),(2615144,'1','201','1037',478,'Retail Sale Id 1462794',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 15:18:48','',''),(2615145,'1','201','1037',478,'Retail Sale Id 1462795',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 15:30:09','',''),(2615146,'1','201','1037',478,'Retail Sale Id 1462796',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 15:34:18','',''),(2615147,'1','201','1037',478,'Retail Sale Id 1462797',6000.00,0.00,0.00,10.00,620.00,'2022-02-27 15:42:34','',''),(2615148,'1','201','1037',478,'Retail Sale Id 1462798',2400.00,0.00,0.00,4.00,248.00,'2022-02-27 15:51:35','',''),(2615149,'1','201','1037',478,'Retail Sale Id 1462799',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 15:53:45','',''),(2615150,'1','201','1037',478,'Retail Sale Id 1462800',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 15:59:41','',''),(2615151,'1','201','1037',478,'Retail Sale Id 1462801',2700.00,0.00,0.00,4.50,279.00,'2022-02-27 16:02:32','',''),(2615152,'1','201','1037',478,'Retail Sale Id 1462802',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 16:24:39','',''),(2615153,'1','201','1037',478,'Retail Sale Id 1462804',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 16:36:43','',''),(2615154,'1','201','1037',478,'Retail Sale Id 1462804',7002.00,0.00,0.00,11.67,723.54,'2022-02-27 16:36:43','',''),(2615155,'1','201','1037',478,'Retail Sale Id 1462805',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 16:37:32','',''),(2615156,'1','201','1037',478,'Retail Sale Id 1462806',600.00,0.00,0.00,1.00,62.00,'2022-02-27 16:53:32','',''),(2615157,'1','201','1037',478,'Retail Sale Id 1462806',600.00,0.00,0.00,1.00,62.00,'2022-02-27 16:53:32','',''),(2615158,'1','201','1037',478,'Retail Sale Id 1462807',3900.00,0.00,0.00,6.50,403.00,'2022-02-27 16:54:31','',''),(2615159,'1','201','1037',478,'Retail Sale Id 1462808',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 16:57:22','',''),(2615160,'1','201','1037',478,'Retail Sale Id 1462809',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 17:01:55','',''),(2615161,'1','201','1037',478,'Retail Sale Id 1462810',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 17:13:41','',''),(2615162,'1','201','1037',478,'Retail Sale Id 1462811',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 17:19:16','',''),(2615163,'1','201','1037',478,'Retail Sale Id 1462812',3798.00,0.00,0.00,6.33,392.46,'2022-02-27 17:31:50','',''),(2615164,'1','201','1037',478,'Retail Sale Id 1462813',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 17:33:48','',''),(2615165,'1','201','1037',478,'Retail Sale Id 1462814',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 17:38:51','',''),(2615166,'1','201','1037',478,'Retail Sale Id 1462815',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 17:40:37','',''),(2615167,'1','201','1037',478,'Retail Sale Id 1462816',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 17:44:14','',''),(2615168,'1','201','1037',478,'Retail Sale Id 1462817',7500.00,0.00,0.00,12.50,775.00,'2022-02-27 17:46:28','',''),(2615169,'1','201','1037',478,'Retail Sale Id 1462818',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 17:54:20','',''),(2615170,'1','201','1037',478,'Retail Sale Id 1462819',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 17:57:25','',''),(2615171,'1','201','1037',478,'Retail Sale Id 1462820',3000.00,0.00,0.00,5.00,310.00,'2022-02-27 18:05:54','',''),(2615172,'1','201','1037',478,'Retail Sale Id 1462821',1800.00,0.00,0.00,3.00,186.00,'2022-02-27 18:09:46','',''),(2615173,'1','201','1037',478,'Retail Sale Id 1462822',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 18:14:16','',''),(2615174,'1','201','1037',478,'Retail Sale Id 1462823',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 18:15:39','',''),(2615175,'1','201','1037',478,'Retail Sale Id 1462824',3600.00,0.00,0.00,6.00,372.00,'2022-02-27 18:19:13','',''),(2615176,'1','201','1037',478,'Retail Sale Id 1462825',600.00,0.00,0.00,1.00,62.00,'2022-02-27 18:22:40','',''),(2615177,'1','201','1037',478,'Retail Sale Id 1462826',1200.00,0.00,0.00,2.00,124.00,'2022-02-27 18:25:05','',''),(2615178,'1','201','1037',478,'Return of Retail Sale Id 1462820',0.00,3000.00,5.00,0.00,-310.00,'2022-02-27 18:54:35','',''),(2615179,'1','201','1037',478,'Retail Sale Id 1462827',2928.00,0.00,0.00,4.88,302.56,'2022-02-27 18:55:19','',''),(2615180,'1','201','1037',478,'Retail Sale Id 1462828',6000.00,0.00,0.00,10.00,620.00,'2022-02-28 07:43:05','',''),(2615181,'1','201','1037',478,'Retail Sale Id 1462829',3600.00,0.00,0.00,6.00,372.00,'2022-02-28 08:31:08','',''),(2615182,'1','201','1037',478,'Retail Sale Id 1462830',7500.00,0.00,0.00,12.50,775.00,'2022-02-28 08:43:15','',''),(2615183,'1','201','1037',478,'Retail Sale Id 1462831',2400.00,0.00,0.00,4.00,248.00,'2022-02-28 08:51:00','',''),(2615184,'1','201','1037',478,'Retail Sale Id 1462832',56500.00,0.00,0.00,100.00,2700.00,'2022-02-28 08:54:40','',''),(2615185,'1','201','1037',478,'Retail Sale Id 1462833',900.00,0.00,0.00,1.50,93.00,'2022-02-28 09:00:26','',''),(2615186,'1','201','1037',478,'Retail Sale Id 1462834',7500.00,0.00,0.00,12.50,775.00,'2022-02-28 09:05:24','',''),(2615187,'1','201','1037',478,'Retail Sale Id 1462835',600.00,0.00,0.00,1.00,62.00,'2022-02-28 09:29:42','',''),(2615188,'1','201','1037',478,'Retail Sale Id 1462836',3600.00,0.00,0.00,6.00,372.00,'2022-02-28 09:41:58','',''),(2615189,'1','201','1037',478,'Retail Sale Id 1462836',3600.00,0.00,0.00,6.00,372.00,'2022-02-28 09:41:58','',''),(2615190,'1','201','1037',478,'Retail Sale Id 1462837',1200.00,0.00,0.00,2.00,124.00,'2022-02-28 10:24:22','',''),(2615191,'1','201','1037',478,'Retail Sale Id 1462837',1200.00,0.00,0.00,2.00,124.00,'2022-02-28 10:24:22','',''),(2615192,'1','201','1037',478,'Retail Sale Id 1462838',3000.00,0.00,0.00,5.00,310.00,'2022-02-28 10:42:49','',''),(2615193,'1','201','1037',478,'Retail Sale Id 1462839',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 10:44:00','',''),(2615194,'1','201','1037',478,'Retail Sale Id 1462840',4200.00,0.00,0.00,7.00,434.00,'2022-02-28 10:55:11','',''),(2615195,'1','201','1037',478,'Retail Sale Id 1462841',3000.00,0.00,0.00,5.00,310.00,'2022-02-28 11:14:52','',''),(2615196,'1','201','1037',478,'Retail Sale Id 1462842',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 11:29:16','',''),(2615197,'1','201','1037',478,'Retail Sale Id 1462843',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 11:38:24','',''),(2615198,'1','201','1037',478,'Retail Sale Id 1462844',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 12:06:31','',''),(2615199,'1','201','1037',478,'Retail Sale Id 1462845',4002.00,0.00,0.00,6.67,413.54,'2022-02-28 12:17:38','',''),(2615200,'1','201','1037',478,'Retail Sale Id 1462846',2400.00,0.00,0.00,4.00,248.00,'2022-02-28 12:19:46','',''),(2615201,'1','201','1037',478,'Retail Sale Id 1462847',600.00,0.00,0.00,1.00,62.00,'2022-02-28 12:20:51','',''),(2615202,'1','201','1037',478,'Retail Sale Id 1462848',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 12:39:31','',''),(2615203,'1','201','1037',478,'Retail Sale Id 1462849',3000.00,0.00,0.00,5.00,310.00,'2022-02-28 12:54:38','',''),(2615204,'1','201','1037',478,'Retail Sale Id 1462850',4800.00,0.00,0.00,8.00,496.00,'2022-02-28 12:56:24','',''),(2615205,'1','201','1037',478,'Retail Sale Id 1462851',3600.00,0.00,0.00,6.00,372.00,'2022-02-28 13:05:22','',''),(2615206,'1','201','1037',478,'Retail Sale Id 1462852',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 13:12:39','',''),(2615207,'1','201','1037',478,'Retail Sale Id 1462853',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 13:19:15','',''),(2615208,'1','201','1037',478,'Retail Sale Id 1462854',3000.00,0.00,0.00,5.00,310.00,'2022-02-28 13:19:57','',''),(2615209,'1','201','1037',478,'Retail Sale Id 1462855',4200.00,0.00,0.00,7.00,434.00,'2022-02-28 13:23:46','',''),(2615210,'1','201','1037',478,'Retail Sale Id 1462856',1200.00,0.00,0.00,2.00,124.00,'2022-02-28 13:42:26','',''),(2615211,'1','201','1037',478,'Retail Sale Id 1462857',2100.00,0.00,0.00,3.50,217.00,'2022-02-28 13:59:05','',''),(2615212,'1','201','1037',478,'Retail Sale Id 1462858',7200.00,0.00,0.00,12.00,744.00,'2022-02-28 14:02:18','',''),(2615213,'1','201','1037',478,'Retail Sale Id 1462859',1200.00,0.00,0.00,2.00,124.00,'2022-02-28 14:15:18','',''),(2615214,'1','201','1037',478,'Retail Sale Id 1462860',1200.00,0.00,0.00,2.00,124.00,'2022-02-28 14:45:15','',''),(2615215,'1','201','1037',478,'Retail Sale Id 1462861',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 14:54:07','',''),(2615216,'1','201','1037',478,'Retail Sale Id 1462862',7500.00,0.00,0.00,12.50,775.00,'2022-02-28 14:56:23','',''),(2615217,'1','201','1037',478,'Retail Sale Id 1462863',600.00,0.00,0.00,1.00,62.00,'2022-02-28 15:00:19','',''),(2615218,'1','201','1037',478,'Retail Sale Id 1462864',1998.00,0.00,0.00,3.33,206.46,'2022-02-28 15:06:29','',''),(2615219,'1','201','1037',478,'Retail Sale Id 1462865',3600.00,0.00,0.00,6.00,372.00,'2022-02-28 15:08:13','',''),(2615220,'1','201','1037',478,'Retail Sale Id 1462866',2400.00,0.00,0.00,4.00,248.00,'2022-02-28 15:09:12','',''),(2615221,'1','201','1037',478,'Retail Sale Id 1462867',7500.00,0.00,0.00,12.50,775.00,'2022-02-28 15:24:58','',''),(2615222,'1','201','1037',478,'Retail Sale Id 1462868',3600.00,0.00,0.00,6.00,372.00,'2022-02-28 15:35:52','',''),(2615223,'1','201','1037',478,'Retail Sale Id 1462869',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 15:43:26','',''),(2615224,'1','201','1037',478,'Retail Sale Id 1462869',7500.00,0.00,0.00,12.50,775.00,'2022-02-28 15:43:26','',''),(2615225,'1','201','1037',478,'Retail Sale Id 1462870',7500.00,0.00,0.00,12.50,775.00,'2022-02-28 15:44:28','',''),(2615226,'1','201','1037',478,'Retail Sale Id 1462871',4200.00,0.00,0.00,7.00,434.00,'2022-02-28 16:14:49','',''),(2615227,'1','201','1037',478,'Retail Sale Id 1462872',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 16:28:37','',''),(2615228,'1','201','1037',478,'Retail Sale Id 1462873',1200.00,0.00,0.00,2.00,124.00,'2022-02-28 16:33:17','',''),(2615229,'1','201','1037',478,'Retail Sale Id 1462874',1998.00,0.00,0.00,3.33,206.46,'2022-02-28 16:34:27','',''),(2615230,'1','201','1037',478,'Retail Sale Id 1462875',1200.00,0.00,0.00,2.00,124.00,'2022-02-28 16:35:47','',''),(2615231,'1','201','1037',478,'Retail Sale Id 1462876',7500.00,0.00,0.00,12.50,775.00,'2022-02-28 16:37:20','',''),(2615232,'1','201','1037',478,'Retail Sale Id 1462877',7500.00,0.00,0.00,12.50,775.00,'2022-02-28 16:38:21','',''),(2615233,'1','201','1037',478,'Retail Sale Id 1462878',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 16:44:21','',''),(2615234,'1','201','1037',478,'Retail Sale Id 1462879',3600.00,0.00,0.00,6.00,372.00,'2022-02-28 16:47:48','',''),(2615235,'1','201','1037',478,'Retail Sale Id 1462880',7500.00,0.00,0.00,12.50,775.00,'2022-02-28 17:00:05','',''),(2615236,'1','201','1037',478,'Retail Sale Id 1462881',1998.00,0.00,0.00,3.33,206.46,'2022-02-28 17:03:19','',''),(2615237,'1','201','1037',478,'Retail Sale Id 1462882',2400.00,0.00,0.00,4.00,248.00,'2022-02-28 17:05:45','',''),(2615238,'1','201','1037',478,'Retail Sale Id 1462883',3600.00,0.00,0.00,6.00,372.00,'2022-02-28 17:07:01','',''),(2615239,'1','201','1037',478,'Retail Sale Id 1462884',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:12:21','',''),(2615240,'1','201','1037',478,'Retail Sale Id 1462885',3600.00,0.00,0.00,6.00,372.00,'2022-02-28 17:14:34','',''),(2615241,'1','201','1037',478,'Retail Sale Id 1462886',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:18:54','',''),(2615242,'1','201','1037',478,'Retail Sale Id 1462887',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:19:44','',''),(2615243,'1','201','1037',478,'Retail Sale Id 1462889',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:23:19','',''),(2615244,'1','201','1037',478,'Retail Sale Id 1462890',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:34:26','',''),(2615245,'1','201','1037',478,'Retail Sale Id 1462891',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:40:14','',''),(2615246,'1','201','1037',478,'Retail Sale Id 1462892',2400.00,0.00,0.00,4.00,248.00,'2022-02-28 17:41:06','',''),(2615247,'1','201','1037',478,'Retail Sale Id 1462893',1200.00,0.00,0.00,2.00,124.00,'2022-02-28 17:42:37','',''),(2615248,'1','201','1037',478,'Retail Sale Id 1462894',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:46:30','',''),(2615249,'1','201','1037',478,'Retail Sale Id 1462895',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:48:28','',''),(2615250,'1','201','1037',478,'Retail Sale Id 1462896',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:50:00','',''),(2615251,'1','201','1037',478,'Retail Sale Id 1462897',3498.00,0.00,0.00,5.83,361.46,'2022-02-28 17:51:18','',''),(2615252,'1','201','1037',478,'Retail Sale Id 1462898',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:53:42','',''),(2615253,'1','201','1037',478,'Retail Sale Id 1462899',1800.00,0.00,0.00,3.00,186.00,'2022-02-28 17:57:11','',''),(2615254,'1','201','1037',478,'Retail Sale Id 1462900',1200.00,0.00,0.00,2.00,124.00,'2022-02-28 18:02:15','',''),(2615255,'1','201','1037',478,'Retail Sale Id 1462901',7002.00,0.00,0.00,11.67,723.54,'2022-02-28 18:04:40','',''),(2615256,'1','201','1037',478,'Retail Sale Id 1462902',1002.00,0.00,0.00,1.67,103.54,'2022-02-28 18:21:04','',''),(2615257,'1','201','1037',478,'Retail Sale Id 1462903',1002.00,0.00,0.00,1.67,103.54,'2022-02-28 18:28:49','',''),(2615258,'1','201','1037',478,'Return of Retail Sale Id 1462894',0.00,1800.00,3.00,0.00,-186.00,'2022-02-28 19:16:50','',''),(2615259,'1','201','1037',478,'Retail Sale Id 1462904',1098.00,0.00,0.00,1.83,113.46,'2022-02-28 19:17:51','',''),(2615260,'1','201','1037',478,'Retail Sale Id 1462905',7500.00,0.00,0.00,12.50,775.00,'2022-03-01 07:30:31','',''),(2615261,'1','201','1037',478,'Retail Sale Id 1462906',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 07:33:39','',''),(2615262,'1','201','1037',478,'Retail Sale Id 1462907',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 08:06:02','',''),(2615263,'1','201','1037',478,'Retail Sale Id 1462908',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 08:26:45','',''),(2615264,'1','201','1037',478,'Retail Sale Id 1462909',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 08:38:18','',''),(2615265,'1','201','1037',478,'Retail Sale Id 1462910',2502.00,0.00,0.00,4.17,258.54,'2022-03-01 08:39:20','',''),(2615266,'1','201','1037',478,'Retail Sale Id 1462911',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 08:57:56','',''),(2615267,'1','201','1037',478,'Retail Sale Id 1462912',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 09:33:50','',''),(2615268,'1','201','1037',478,'Retail Sale Id 1462913',7500.00,0.00,0.00,12.50,775.00,'2022-03-01 09:43:24','',''),(2615269,'1','201','1037',478,'Retail Sale Id 1462914',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 09:44:13','',''),(2615270,'1','201','1037',478,'Retail Sale Id 1462915',900.00,0.00,0.00,1.50,93.00,'2022-03-01 09:45:24','',''),(2615271,'1','201','1037',478,'Retail Sale Id 1462916',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 09:52:17','',''),(2615272,'1','201','1037',478,'Retail Sale Id 1462917',1002.00,0.00,0.00,1.67,103.54,'2022-03-01 10:15:48','',''),(2615273,'1','201','1037',478,'Retail Sale Id 1462918',600.00,0.00,0.00,1.00,62.00,'2022-03-01 10:18:35','',''),(2615274,'1','201','1037',478,'Retail Sale Id 1462919',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 10:19:38','',''),(2615275,'1','201','1037',478,'Retail Sale Id 1462921',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 10:28:09','',''),(2615276,'1','201','1037',478,'Retail Sale Id 1462922',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 10:34:57','',''),(2615277,'1','201','1037',478,'Retail Sale Id 1462922',7200.00,0.00,0.00,12.00,744.00,'2022-03-01 10:34:57','',''),(2615278,'1','201','1037',478,'Retail Sale Id 1462923',2400.00,0.00,0.00,4.00,248.00,'2022-03-01 11:10:57','',''),(2615279,'1','201','1037',478,'Retail Sale Id 1462924',7500.00,0.00,0.00,12.50,775.00,'2022-03-01 11:20:51','',''),(2615280,'1','201','1037',478,'Retail Sale Id 1462925',3000.00,0.00,0.00,5.00,310.00,'2022-03-01 11:22:42','',''),(2615281,'1','201','1037',478,'Retail Sale Id 1462926',3000.00,0.00,0.00,5.00,310.00,'2022-03-01 11:24:32','',''),(2615282,'1','201','1037',478,'Retail Sale Id 1462927',3000.00,0.00,0.00,5.00,310.00,'2022-03-01 11:25:29','',''),(2615283,'1','201','1037',478,'Retail Sale Id 1462928',900.00,0.00,0.00,1.50,93.00,'2022-03-01 11:29:08','',''),(2615284,'1','201','1037',478,'Retail Sale Id 1462929',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 11:31:38','',''),(2615285,'1','201','1037',478,'Retail Sale Id 1462930',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 11:32:32','',''),(2615286,'1','201','1037',478,'Retail Sale Id 1462931',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 11:56:14','',''),(2615287,'1','201','1037',478,'Retail Sale Id 1462933',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 11:57:09','',''),(2615288,'1','201','1037',478,'Retail Sale Id 1462934',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 11:57:51','',''),(2615289,'1','201','1037',478,'Retail Sale Id 1462935',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 11:58:31','',''),(2615290,'1','201','1037',478,'Retail Sale Id 1462936',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 12:08:38','',''),(2615291,'1','201','1037',478,'Retail Sale Id 1462937',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 12:11:38','',''),(2615292,'1','201','1037',478,'Retail Sale Id 1462938',600.00,0.00,0.00,1.00,62.00,'2022-03-01 12:22:47','',''),(2615293,'1','201','1037',478,'Retail Sale Id 1462939',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 12:45:50','',''),(2615294,'1','201','1037',478,'Retail Sale Id 1462940',7500.00,0.00,0.00,12.50,775.00,'2022-03-01 12:58:15','',''),(2615295,'1','201','1037',478,'Retail Sale Id 1462941',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 13:00:41','',''),(2615296,'1','201','1037',478,'Retail Sale Id 1462942',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 13:24:31','',''),(2615297,'1','201','1037',478,'Retail Sale Id 1462943',4998.00,0.00,0.00,8.33,516.46,'2022-03-01 13:36:35','',''),(2615298,'1','201','1037',478,'Retail Sale Id 1462944',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 13:57:09','',''),(2615299,'1','201','1037',478,'Retail Sale Id 1462946',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 14:04:10','',''),(2615300,'1','201','1037',478,'Retail Sale Id 1462947',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 14:16:35','',''),(2615301,'1','201','1037',478,'Retail Sale Id 1462948',6840.00,0.00,0.00,12.00,384.00,'2022-03-01 14:20:32','',''),(2615302,'1','201','1037',478,'Retail Sale Id 1462949',600.00,0.00,0.00,1.00,62.00,'2022-03-01 14:26:52','',''),(2615303,'1','201','1037',478,'Retail Sale Id 1462950',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 14:34:36','',''),(2615304,'1','201','1037',478,'Retail Sale Id 1462951',1998.00,0.00,0.00,3.33,206.46,'2022-03-01 14:36:51','',''),(2615305,'1','201','1037',478,'Retail Sale Id 1462952',7500.00,0.00,0.00,12.50,775.00,'2022-03-01 14:38:08','',''),(2615306,'1','201','1037',478,'Retail Sale Id 1462953',7500.00,0.00,0.00,12.50,775.00,'2022-03-01 15:08:59','',''),(2615307,'1','201','1037',478,'Retail Sale Id 1462955',4998.00,0.00,0.00,8.33,516.46,'2022-03-01 15:24:08','',''),(2615308,'1','201','1037',478,'Retail Sale Id 1462956',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 15:33:53','',''),(2615309,'1','201','1037',478,'Retail Sale Id 1462958',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 15:47:35','',''),(2615310,'1','201','1037',478,'Retail Sale Id 1462960',7800.00,0.00,0.00,13.00,806.00,'2022-03-01 15:51:43','',''),(2615311,'1','201','1037',478,'Retail Sale Id 1462961',6498.00,0.00,0.00,10.83,671.46,'2022-03-01 15:56:34','',''),(2615312,'1','201','1037',478,'Retail Sale Id 1462962',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 16:45:42','',''),(2615313,'1','201','1037',478,'Retail Sale Id 1462963',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 16:47:51','',''),(2615314,'1','201','1037',478,'Retail Sale Id 1462963',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 16:47:51','',''),(2615315,'1','201','1037',478,'Retail Sale Id 1462964',1002.00,0.00,0.00,1.67,103.54,'2022-03-01 16:58:05','',''),(2615316,'1','201','1037',478,'Retail Sale Id 1462965',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 17:02:08','',''),(2615317,'1','201','1037',478,'Retail Sale Id 1462966',1200.00,0.00,0.00,2.00,124.00,'2022-03-01 17:28:36','',''),(2615318,'1','201','1037',478,'Retail Sale Id 1462967',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 17:29:32','',''),(2615319,'1','201','1037',478,'Retail Sale Id 1462968',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 17:39:14','',''),(2615320,'1','201','1037',478,'Retail Sale Id 1462969',1800.00,0.00,0.00,3.00,186.00,'2022-03-01 17:50:08','',''),(2615321,'1','201','1037',478,'Retail Sale Id 1462970',10545.00,0.00,0.00,18.50,592.00,'2022-03-01 17:52:19','',''),(2615322,'1','201','1037',478,'Retail Sale Id 1462971',3000.00,0.00,0.00,5.00,310.00,'2022-03-01 18:07:05','',''),(2615323,'1','201','1037',478,'Retail Sale Id 1462972',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 18:21:11','',''),(2615324,'1','201','1037',478,'Retail Sale Id 1462973',3600.00,0.00,0.00,6.00,372.00,'2022-03-01 18:34:37','',''),(2615325,'1','201','1037',478,'Return of Retail Sale Id 1462963',0.00,1800.00,3.00,0.00,-186.00,'2022-03-01 19:00:47','',''),(2615326,'1','201','1037',478,'Return of Retail Sale Id 1462963',0.00,3600.00,6.00,0.00,-372.00,'2022-03-01 19:00:47','',''),(2615327,'1','201','1037',478,'Retail Sale Id 1462974',5292.00,0.00,0.00,8.82,546.84,'2022-03-01 19:01:26','',''),(2615328,'1','201','1037',478,'Retail Sale Id 1462975',600.00,0.00,0.00,1.00,62.00,'2022-03-02 08:18:42','',''),(2615329,'1','201','1037',478,'Retail Sale Id 1462976',7200.00,0.00,0.00,12.00,744.00,'2022-03-02 08:33:14','',''),(2615330,'1','201','1037',478,'Retail Sale Id 1462977',2400.00,0.00,0.00,4.00,248.00,'2022-03-02 08:42:26','',''),(2615331,'1','201','1037',478,'Retail Sale Id 1462978',1200.00,0.00,0.00,2.00,124.00,'2022-03-02 09:00:59','',''),(2615332,'1','201','1037',478,'Retail Sale Id 1462979',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 09:09:34','',''),(2615333,'1','201','1037',478,'Retail Sale Id 1462980',3600.00,0.00,0.00,6.00,372.00,'2022-03-02 09:44:36','',''),(2615334,'1','201','1037',478,'Retail Sale Id 1462981',7500.00,0.00,0.00,12.50,775.00,'2022-03-02 09:48:32','',''),(2615335,'1','201','1037',478,'Retail Sale Id 1462982',1200.00,0.00,0.00,2.00,124.00,'2022-03-02 09:49:34','',''),(2615336,'1','201','1037',478,'Retail Sale Id 1462983',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 10:29:07','',''),(2615337,'1','201','1037',478,'Retail Sale Id 1462984',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 10:37:11','',''),(2615338,'1','201','1037',478,'Retail Sale Id 1462985',4998.00,0.00,0.00,8.33,516.46,'2022-03-02 10:42:40','',''),(2615339,'1','201','1037',478,'Retail Sale Id 1462986',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 10:44:08','',''),(2615340,'1','201','1037',478,'Retail Sale Id 1462987',3600.00,0.00,0.00,6.00,372.00,'2022-03-02 10:55:20','',''),(2615341,'1','201','1037',478,'Retail Sale Id 1462988',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 11:12:01','',''),(2615342,'1','201','1037',478,'Retail Sale Id 1462989',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 11:28:18','',''),(2615343,'1','201','1037',478,'Retail Sale Id 1462990',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 12:00:36','',''),(2615344,'1','201','1037',478,'Retail Sale Id 1462991',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 12:02:13','',''),(2615345,'1','201','1037',478,'Retail Sale Id 1462992',3000.00,0.00,0.00,5.00,310.00,'2022-03-02 12:08:59','',''),(2615346,'1','201','1037',478,'Retail Sale Id 1462993',142500.00,0.00,0.00,250.00,8000.00,'2022-03-02 12:09:50','',''),(2615347,'1','201','1037',478,'Retail Sale Id 1462995',1500.00,0.00,0.00,2.50,155.00,'2022-03-02 12:22:28','',''),(2615348,'1','201','1037',478,'Retail Sale Id 1462996',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 12:41:07','',''),(2615349,'1','201','1037',478,'Retail Sale Id 1462997',4800.00,0.00,0.00,8.00,496.00,'2022-03-02 13:01:59','',''),(2615350,'1','201','1037',478,'Retail Sale Id 1462998',7500.00,0.00,0.00,12.50,775.00,'2022-03-02 13:20:30','',''),(2615351,'1','201','1037',478,'Retail Sale Id 1462999',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 14:26:50','',''),(2615352,'1','201','1037',478,'Retail Sale Id 1463000',3000.00,0.00,0.00,5.00,310.00,'2022-03-02 14:47:06','',''),(2615353,'1','201','1037',478,'Retail Sale Id 1463001',4800.00,0.00,0.00,8.00,496.00,'2022-03-02 14:48:30','',''),(2615354,'1','201','1037',478,'Retail Sale Id 1463002',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 14:55:23','',''),(2615355,'1','201','1037',478,'Retail Sale Id 1463002',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 14:55:23','',''),(2615356,'1','201','1037',478,'Retail Sale Id 1463003',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 15:09:57','',''),(2615357,'1','201','1037',478,'Retail Sale Id 1463004',4800.00,0.00,0.00,8.00,496.00,'2022-03-02 15:16:51','',''),(2615358,'1','201','1037',478,'Retail Sale Id 1463004',6600.00,0.00,0.00,11.00,682.00,'2022-03-02 15:16:51','',''),(2615359,'1','201','1037',478,'Retail Sale Id 1463005',8550.00,0.00,0.00,15.00,480.00,'2022-03-02 15:18:43','',''),(2615360,'1','201','1037',478,'Retail Sale Id 1463006',1200.00,0.00,0.00,2.00,124.00,'2022-03-02 15:19:48','',''),(2615361,'1','201','1037',478,'Retail Sale Id 1463007',3600.00,0.00,0.00,6.00,372.00,'2022-03-02 15:20:53','',''),(2615362,'1','201','1037',478,'Retail Sale Id 1463008',3000.00,0.00,0.00,5.00,310.00,'2022-03-02 15:27:01','',''),(2615363,'1','201','1037',478,'Retail Sale Id 1463009',600.00,0.00,0.00,1.00,62.00,'2022-03-02 15:54:29','',''),(2615364,'1','201','1037',478,'Retail Sale Id 1463018',3000.00,0.00,0.00,5.00,310.00,'2022-03-02 16:10:22','',''),(2615365,'1','201','1037',478,'Retail Sale Id 1463019',900.00,0.00,0.00,1.50,93.00,'2022-03-02 16:25:57','',''),(2615366,'1','201','1037',478,'Retail Sale Id 1463020',1998.00,0.00,0.00,3.33,206.46,'2022-03-02 16:45:08','',''),(2615367,'1','201','1037',478,'Retail Sale Id 1463021',1200.00,0.00,0.00,2.00,124.00,'2022-03-02 16:52:45','',''),(2615368,'1','201','1037',478,'Retail Sale Id 1463022',3600.00,0.00,0.00,6.00,372.00,'2022-03-02 16:58:15','',''),(2615369,'1','201','1037',478,'Retail Sale Id 1463023',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 16:59:19','',''),(2615370,'1','201','1037',478,'Retail Sale Id 1463024',3600.00,0.00,0.00,6.00,372.00,'2022-03-02 17:00:39','',''),(2615371,'1','201','1037',478,'Retail Sale Id 1463025',600.00,0.00,0.00,1.00,62.00,'2022-03-02 17:08:31','',''),(2615372,'1','201','1037',478,'Retail Sale Id 1463026',1200.00,0.00,0.00,2.00,124.00,'2022-03-02 17:09:52','',''),(2615373,'1','201','1037',478,'Retail Sale Id 1463027',3600.00,0.00,0.00,6.00,372.00,'2022-03-02 17:10:55','',''),(2615374,'1','201','1037',478,'Retail Sale Id 1463029',1200.00,0.00,0.00,2.00,124.00,'2022-03-02 17:11:55','',''),(2615375,'1','201','1037',478,'Retail Sale Id 1463030',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 17:12:42','',''),(2615376,'1','201','1037',478,'Retail Sale Id 1463031',3600.00,0.00,0.00,6.00,372.00,'2022-03-02 17:16:13','',''),(2615377,'1','201','1037',478,'Retail Sale Id 1463031',7500.00,0.00,0.00,12.50,775.00,'2022-03-02 17:16:13','',''),(2615378,'1','201','1037',478,'Retail Sale Id 1463032',1200.00,0.00,0.00,2.00,124.00,'2022-03-02 17:19:29','',''),(2615379,'1','201','1037',478,'Retail Sale Id 1463033',1200.00,0.00,0.00,2.00,124.00,'2022-03-02 17:25:15','',''),(2615380,'1','201','1037',478,'Retail Sale Id 1463034',3600.00,0.00,0.00,6.00,372.00,'2022-03-02 17:26:43','',''),(2615381,'1','201','1037',478,'Retail Sale Id 1463035',3000.00,0.00,0.00,5.00,310.00,'2022-03-02 17:35:40','',''),(2615382,'1','201','1037',478,'Retail Sale Id 1463036',1800.00,0.00,0.00,3.00,186.00,'2022-03-02 17:44:39','',''),(2615383,'1','201','1037',478,'Retail Sale Id 1463037',1998.00,0.00,0.00,3.33,206.46,'2022-03-02 17:46:05','',''),(2615384,'1','201','1037',478,'Retail Sale Id 1463038',5400.00,0.00,0.00,9.00,558.00,'2022-03-02 17:55:58','',''),(2615385,'1','201','1037',478,'Retail Sale Id 1463039',1200.00,0.00,0.00,2.00,124.00,'2022-03-02 18:15:32','',''),(2615386,'1','201','1037',478,'Retail Sale Id 1463040',600.00,0.00,0.00,1.00,62.00,'2022-03-02 18:19:53','',''),(2615387,'1','201','1037',478,'Retail Sale Id 1463040',600.00,0.00,0.00,1.00,62.00,'2022-03-02 18:19:53','',''),(2615388,'1','201','1037',478,'Retail Sale Id 1463040',600.00,0.00,0.00,1.00,62.00,'2022-03-02 18:19:53','',''),(2615389,'1','201','1037',478,'Retail Sale Id 1463041',7500.00,0.00,0.00,12.50,775.00,'2022-03-02 18:34:18','',''),(2615390,'1','201','1037',478,'Return of Retail Sale Id 1463034',0.00,3600.00,6.00,0.00,-372.00,'2022-03-02 19:14:14','',''),(2615391,'1','201','1037',478,'Retail Sale Id 1463042',3570.00,0.00,0.00,5.95,368.90,'2022-03-02 19:14:58','',''),(2615392,'1','201','1037',478,'Retail Sale Id 1463043',6.00,0.00,0.00,0.01,0.62,'2022-03-02 19:21:34','',''),(2615393,'1','201','1037',478,'Retail Sale Id 1463044',3000.00,0.00,0.00,5.00,310.00,'2022-03-03 08:11:35','',''),(2615394,'1','201','1037',478,'Retail Sale Id 1463045',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 08:30:00','',''),(2615395,'1','201','1037',478,'Retail Sale Id 1463046',600.00,0.00,0.00,1.00,62.00,'2022-03-03 08:31:22','',''),(2615396,'1','201','1037',478,'Retail Sale Id 1463047',3000.00,0.00,0.00,5.00,310.00,'2022-03-03 08:49:54','',''),(2615397,'1','201','1037',478,'Retail Sale Id 1463048',3900.00,0.00,0.00,6.50,403.00,'2022-03-03 08:53:14','',''),(2615398,'1','201','1037',478,'Retail Sale Id 1463049',7500.00,0.00,0.00,12.50,775.00,'2022-03-03 08:57:27','',''),(2615399,'1','201','1037',478,'Retail Sale Id 1463050',7200.00,0.00,0.00,12.00,744.00,'2022-03-03 10:02:31','',''),(2615400,'1','201','1037',478,'Retail Sale Id 1463051',1200.00,0.00,0.00,2.00,124.00,'2022-03-03 10:08:19','',''),(2615401,'1','201','1037',478,'Retail Sale Id 1463052',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 10:09:08','',''),(2615402,'1','201','1037',478,'Retail Sale Id 1463053',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 10:14:38','',''),(2615403,'1','201','1037',478,'Retail Sale Id 1463054',1200.00,0.00,0.00,2.00,124.00,'2022-03-03 10:16:57','',''),(2615404,'1','201','1037',478,'Retail Sale Id 1463055',3600.00,0.00,0.00,6.00,372.00,'2022-03-03 10:23:02','',''),(2615405,'1','201','1037',478,'Retail Sale Id 1463056',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 10:30:27','',''),(2615406,'1','201','1037',478,'Retail Sale Id 1463057',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 10:35:04','',''),(2615407,'1','201','1037',478,'Retail Sale Id 1463058',600.00,0.00,0.00,1.00,62.00,'2022-03-03 10:40:42','',''),(2615408,'1','201','1037',478,'Retail Sale Id 1463059',1500.00,0.00,0.00,2.50,155.00,'2022-03-03 10:44:41','',''),(2615409,'1','201','1037',478,'Retail Sale Id 1463060',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 11:07:36','',''),(2615410,'1','201','1037',478,'Retail Sale Id 1463061',1998.00,0.00,0.00,3.33,206.46,'2022-03-03 11:21:51','',''),(2615411,'1','201','1037',478,'Retail Sale Id 1463062',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 11:31:16','',''),(2615412,'1','201','1037',478,'Retail Sale Id 1463063',7500.00,0.00,0.00,12.50,775.00,'2022-03-03 11:34:20','',''),(2615413,'1','201','1037',478,'Retail Sale Id 1463064',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 11:36:49','',''),(2615414,'1','201','1037',478,'Retail Sale Id 1463065',1200.00,0.00,0.00,2.00,124.00,'2022-03-03 12:02:05','',''),(2615415,'1','201','1037',478,'Retail Sale Id 1463066',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 12:12:20','',''),(2615416,'1','201','1037',478,'Retail Sale Id 1463067',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 12:13:01','',''),(2615417,'1','201','1037',478,'Retail Sale Id 1463068',13110.00,0.00,0.00,23.00,736.00,'2022-03-03 12:17:08','',''),(2615418,'1','201','1037',478,'Retail Sale Id 1463069',6000.00,0.00,0.00,10.00,620.00,'2022-03-03 12:24:57','',''),(2615419,'1','201','1037',478,'Retail Sale Id 1463070',2400.00,0.00,0.00,4.00,248.00,'2022-03-03 13:22:56','',''),(2615420,'1','201','1037',478,'Retail Sale Id 1463071',3600.00,0.00,0.00,6.00,372.00,'2022-03-03 13:23:58','',''),(2615421,'1','201','1037',478,'Retail Sale Id 1463072',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 13:52:08','',''),(2615422,'1','201','1037',478,'Retail Sale Id 1463073',3000.00,0.00,0.00,5.00,310.00,'2022-03-03 13:57:44','',''),(2615423,'1','201','1037',478,'Retail Sale Id 1463074',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 14:17:17','',''),(2615424,'1','201','1037',478,'Retail Sale Id 1463075',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 14:22:33','',''),(2615425,'1','201','1037',478,'Retail Sale Id 1463075',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 14:22:33','',''),(2615426,'1','201','1037',478,'Retail Sale Id 1463076',1200.00,0.00,0.00,2.00,124.00,'2022-03-03 14:46:53','',''),(2615427,'1','201','1037',478,'Retail Sale Id 1463077',7500.00,0.00,0.00,12.50,775.00,'2022-03-03 14:56:57','',''),(2615428,'1','201','1037',478,'Retail Sale Id 1463078',3600.00,0.00,0.00,6.00,372.00,'2022-03-03 15:13:33','',''),(2615429,'1','201','1037',478,'Retail Sale Id 1463079',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 15:23:43','',''),(2615430,'1','201','1037',478,'Retail Sale Id 1463080',7500.00,0.00,0.00,12.50,775.00,'2022-03-03 15:35:04','',''),(2615431,'1','201','1037',478,'Retail Sale Id 1463081',600.00,0.00,0.00,1.00,62.00,'2022-03-03 15:36:06','',''),(2615432,'1','201','1037',478,'Retail Sale Id 1463082',1200.00,0.00,0.00,2.00,124.00,'2022-03-03 15:44:58','',''),(2615433,'1','201','1037',478,'Retail Sale Id 1463083',1002.00,0.00,0.00,1.67,103.54,'2022-03-03 15:45:55','',''),(2615434,'1','201','1037',478,'Retail Sale Id 1463084',1500.00,0.00,0.00,2.50,155.00,'2022-03-03 15:54:07','',''),(2615435,'1','201','1037',478,'Retail Sale Id 1463085',3000.00,0.00,0.00,5.00,310.00,'2022-03-03 15:54:58','',''),(2615436,'1','201','1037',478,'Retail Sale Id 1463086',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 15:55:55','',''),(2615437,'1','201','1037',478,'Retail Sale Id 1463087',2400.00,0.00,0.00,4.00,248.00,'2022-03-03 16:03:50','',''),(2615438,'1','201','1037',478,'Retail Sale Id 1463089',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 16:29:59','',''),(2615439,'1','201','1037',478,'Retail Sale Id 1463089',3000.00,0.00,0.00,5.00,310.00,'2022-03-03 16:29:59','',''),(2615440,'1','201','1037',478,'Retail Sale Id 1463090',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 16:41:27','',''),(2615441,'1','201','1037',478,'Retail Sale Id 1463090',7500.00,0.00,0.00,12.50,775.00,'2022-03-03 16:41:27','',''),(2615442,'1','201','1037',478,'Retail Sale Id 1463091',2400.00,0.00,0.00,4.00,248.00,'2022-03-03 16:56:01','',''),(2615443,'1','201','1037',478,'Retail Sale Id 1463092',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 16:59:55','',''),(2615444,'1','201','1037',478,'Retail Sale Id 1463093',3600.00,0.00,0.00,6.00,372.00,'2022-03-03 17:06:40','',''),(2615445,'1','201','1037',478,'Retail Sale Id 1463094',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 17:10:58','',''),(2615446,'1','201','1037',478,'Retail Sale Id 1463094',7500.00,0.00,0.00,12.50,775.00,'2022-03-03 17:10:58','',''),(2615447,'1','201','1037',478,'Retail Sale Id 1463094',7500.00,0.00,0.00,12.50,775.00,'2022-03-03 17:10:58','',''),(2615448,'1','201','1037',478,'Retail Sale Id 1463095',3600.00,0.00,0.00,6.00,372.00,'2022-03-03 17:15:05','',''),(2615449,'1','201','1037',478,'Retail Sale Id 1463096',3600.00,0.00,0.00,6.00,372.00,'2022-03-03 17:19:08','',''),(2615450,'1','201','1037',478,'Retail Sale Id 1463097',4800.00,0.00,0.00,8.00,496.00,'2022-03-03 17:21:09','',''),(2615451,'1','201','1037',478,'Retail Sale Id 1463098',7500.00,0.00,0.00,12.50,775.00,'2022-03-03 17:24:48','',''),(2615452,'1','201','1037',478,'Retail Sale Id 1463099',1002.00,0.00,0.00,1.67,103.54,'2022-03-03 17:26:27','',''),(2615453,'1','201','1037',478,'Retail Sale Id 1463100',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 17:33:20','',''),(2615454,'1','201','1037',478,'Retail Sale Id 1463101',600.00,0.00,0.00,1.00,62.00,'2022-03-03 17:34:24','',''),(2615455,'1','201','1037',478,'Retail Sale Id 1463102',4998.00,0.00,0.00,8.33,516.46,'2022-03-03 17:36:57','',''),(2615456,'1','201','1037',478,'Retail Sale Id 1463103',3600.00,0.00,0.00,6.00,372.00,'2022-03-03 17:37:46','',''),(2615457,'1','201','1037',478,'Retail Sale Id 1463104',6000.00,0.00,0.00,10.00,620.00,'2022-03-03 17:38:51','',''),(2615458,'1','201','1037',478,'Retail Sale Id 1463105',6498.00,0.00,0.00,10.83,671.46,'2022-03-03 17:44:42','',''),(2615459,'1','201','1037',478,'Retail Sale Id 1463106',1200.00,0.00,0.00,2.00,124.00,'2022-03-03 17:50:19','',''),(2615460,'1','201','1037',478,'Retail Sale Id 1463106',1200.00,0.00,0.00,2.00,124.00,'2022-03-03 17:50:19','',''),(2615461,'1','201','1037',478,'Retail Sale Id 1463107',1500.00,0.00,0.00,2.50,155.00,'2022-03-03 17:59:51','',''),(2615462,'1','201','1037',478,'Retail Sale Id 1463108',1800.00,0.00,0.00,3.00,186.00,'2022-03-03 18:04:56','',''),(2615463,'1','201','1037',478,'Retail Sale Id 1463109',1500.00,0.00,0.00,2.50,155.00,'2022-03-03 18:38:21','',''),(2615464,'1','201','1037',478,'Retail Sale Id 1463110',5202.00,0.00,0.00,8.67,537.54,'2022-03-03 20:11:27','',''),(2615465,'1','201','1037',478,'Retail Sale Id 1463111',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 07:48:30','',''),(2615466,'1','201','1037',478,'Retail Sale Id 1463112',4800.00,0.00,0.00,8.00,496.00,'2022-03-04 08:15:31','',''),(2615467,'1','201','1037',478,'Retail Sale Id 1463113',4200.00,0.00,0.00,7.00,434.00,'2022-03-04 08:17:32','',''),(2615468,'1','201','1037',478,'Retail Sale Id 1463114',1500.00,0.00,0.00,2.50,155.00,'2022-03-04 08:55:45','',''),(2615469,'1','201','1037',478,'Retail Sale Id 1463115',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 09:02:00','',''),(2615470,'1','201','1037',478,'Retail Sale Id 1463116',4200.00,0.00,0.00,7.00,434.00,'2022-03-04 09:05:37','',''),(2615471,'1','201','1037',478,'Retail Sale Id 1463117',600.00,0.00,0.00,1.00,62.00,'2022-03-04 09:07:29','',''),(2615472,'1','201','1037',478,'Retail Sale Id 1463118',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 09:16:40','',''),(2615473,'1','201','1037',478,'Retail Sale Id 1463119',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 09:17:37','',''),(2615474,'1','201','1037',478,'Retail Sale Id 1463120',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 09:25:48','',''),(2615475,'1','201','1037',478,'Retail Sale Id 1463121',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 09:30:57','',''),(2615476,'1','201','1037',478,'Retail Sale Id 1463122',2400.00,0.00,0.00,4.00,248.00,'2022-03-04 09:36:18','',''),(2615477,'1','201','1037',478,'Retail Sale Id 1463123',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 10:02:43','',''),(2615478,'1','201','1037',478,'Retail Sale Id 1463123',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 10:02:43','',''),(2615479,'1','201','1037',478,'Return of Retail Sale Id 1463113',0.00,4200.00,7.00,0.00,-434.00,'2022-03-04 10:02:56','',''),(2615480,'1','201','1037',478,'Retail Sale Id 1463124',3372.00,0.00,0.00,5.62,348.44,'2022-03-04 10:03:51','',''),(2615481,'1','201','1037',478,'Retail Sale Id 1463125',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 10:07:16','',''),(2615482,'1','201','1037',478,'Retail Sale Id 1463126',3420.00,0.00,0.00,6.00,192.00,'2022-03-04 10:11:38','',''),(2615483,'1','201','1037',478,'Retail Sale Id 1463127',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 10:27:08','',''),(2615484,'1','201','1037',478,'Retail Sale Id 1463128',6600.00,0.00,0.00,11.00,682.00,'2022-03-04 10:35:02','',''),(2615485,'1','201','1037',478,'Retail Sale Id 1463129',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 10:37:10','',''),(2615486,'1','201','1037',478,'Retail Sale Id 1463130',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 10:40:19','',''),(2615487,'1','201','1037',478,'Retail Sale Id 1463131',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 10:42:20','',''),(2615488,'1','201','1037',478,'Retail Sale Id 1463132',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 10:43:24','',''),(2615489,'1','201','1037',478,'Retail Sale Id 1463133',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 10:51:21','',''),(2615490,'1','201','1037',478,'Retail Sale Id 1463133',7500.00,0.00,0.00,12.50,775.00,'2022-03-04 10:51:21','',''),(2615491,'1','201','1037',478,'Retail Sale Id 1463134',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 10:55:04','',''),(2615492,'1','201','1037',478,'Retail Sale Id 1463135',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 10:56:14','',''),(2615493,'1','201','1037',478,'Retail Sale Id 1463136',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 11:00:18','',''),(2615494,'1','201','1037',478,'Retail Sale Id 1463137',7500.00,0.00,0.00,12.50,775.00,'2022-03-04 11:01:45','',''),(2615495,'1','201','1037',478,'Retail Sale Id 1463138',600.00,0.00,0.00,1.00,62.00,'2022-03-04 11:19:29','',''),(2615496,'1','201','1037',478,'Retail Sale Id 1463139',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 11:25:56','',''),(2615497,'1','201','1037',478,'Retail Sale Id 1463140',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 11:29:11','',''),(2615498,'1','201','1037',478,'Retail Sale Id 1463141',2400.00,0.00,0.00,4.00,248.00,'2022-03-04 11:36:41','',''),(2615499,'1','201','1037',478,'Retail Sale Id 1463142',6600.00,0.00,0.00,11.00,682.00,'2022-03-04 12:03:10','',''),(2615500,'1','201','1037',478,'Retail Sale Id 1463142',6600.00,0.00,0.00,11.00,682.00,'2022-03-04 12:03:10','',''),(2615501,'1','201','1037',478,'Retail Sale Id 1463143',2400.00,0.00,0.00,4.00,248.00,'2022-03-04 12:04:06','',''),(2615502,'1','201','1037',478,'Retail Sale Id 1463144',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 12:08:17','',''),(2615503,'1','201','1037',478,'Retail Sale Id 1463145',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 12:09:07','',''),(2615504,'1','201','1037',478,'Retail Sale Id 1463146',6000.00,0.00,0.00,10.00,620.00,'2022-03-04 12:13:00','',''),(2615505,'1','201','1037',478,'Retail Sale Id 1463147',6000.00,0.00,0.00,10.00,620.00,'2022-03-04 12:17:42','',''),(2615506,'1','201','1037',478,'Retail Sale Id 1463148',4002.00,0.00,0.00,6.67,413.54,'2022-03-04 12:18:52','',''),(2615507,'1','201','1037',478,'Retail Sale Id 1463149',2502.00,0.00,0.00,4.17,258.54,'2022-03-04 12:30:25','',''),(2615508,'1','201','1037',478,'Retail Sale Id 1463150',2400.00,0.00,0.00,4.00,248.00,'2022-03-04 12:31:32','',''),(2615509,'1','201','1037',478,'Retail Sale Id 1463151',4200.00,0.00,0.00,7.00,434.00,'2022-03-04 12:32:26','',''),(2615510,'1','201','1037',478,'Retail Sale Id 1463152',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 13:55:01','',''),(2615511,'1','201','1037',478,'Retail Sale Id 1463153',4002.00,0.00,0.00,6.67,413.54,'2022-03-04 13:58:49','',''),(2615512,'1','201','1037',478,'Retail Sale Id 1463154',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 14:01:28','',''),(2615513,'1','201','1037',478,'Retail Sale Id 1463155',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 14:02:18','',''),(2615514,'1','201','1037',478,'Retail Sale Id 1463156',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 14:06:02','',''),(2615515,'1','201','1037',478,'Retail Sale Id 1463157',6600.00,0.00,0.00,11.00,682.00,'2022-03-04 14:10:25','',''),(2615516,'1','201','1037',478,'Retail Sale Id 1463157',6600.00,0.00,0.00,11.00,682.00,'2022-03-04 14:10:25','',''),(2615517,'1','201','1037',478,'Retail Sale Id 1463157',6600.00,0.00,0.00,11.00,682.00,'2022-03-04 14:10:25','',''),(2615518,'1','201','1037',478,'Retail Sale Id 1463158',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 14:25:42','',''),(2615519,'1','201','1037',478,'Retail Sale Id 1463159',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 14:26:43','',''),(2615520,'1','201','1037',478,'Retail Sale Id 1463160',1500.00,0.00,0.00,2.50,155.00,'2022-03-04 14:35:54','',''),(2615521,'1','201','1037',478,'Retail Sale Id 1463161',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 14:43:11','',''),(2615522,'1','201','1037',478,'Retail Sale Id 1463162',4500.00,0.00,0.00,7.50,465.00,'2022-03-04 14:44:27','',''),(2615523,'1','201','1037',478,'Retail Sale Id 1463163',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 15:01:48','',''),(2615524,'1','201','1037',478,'Retail Sale Id 1463163',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 15:01:48','',''),(2615525,'1','201','1037',478,'Retail Sale Id 1463163',7500.00,0.00,0.00,12.50,775.00,'2022-03-04 15:01:48','',''),(2615526,'1','201','1037',478,'Retail Sale Id 1463164',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 15:02:45','',''),(2615527,'1','201','1037',478,'Retail Sale Id 1463164',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 15:02:45','',''),(2615528,'1','201','1037',478,'Retail Sale Id 1463165',2400.00,0.00,0.00,4.00,248.00,'2022-03-04 15:03:33','',''),(2615529,'1','201','1037',478,'Retail Sale Id 1463166',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 15:11:41','',''),(2615530,'1','201','1037',478,'Retail Sale Id 1463167',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 15:16:14','',''),(2615531,'1','201','1037',478,'Retail Sale Id 1463168',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 15:19:46','',''),(2615532,'1','201','1037',478,'Retail Sale Id 1463169',6000.00,0.00,0.00,10.00,620.00,'2022-03-04 15:20:34','',''),(2615533,'1','201','1037',478,'Retail Sale Id 1463170',6000.00,0.00,0.00,10.00,620.00,'2022-03-04 15:22:08','',''),(2615534,'1','201','1037',478,'Retail Sale Id 1463171',600.00,0.00,0.00,1.00,62.00,'2022-03-04 15:22:48','',''),(2615535,'1','201','1037',478,'Retail Sale Id 1463172',600.00,0.00,0.00,1.00,62.00,'2022-03-04 15:23:42','',''),(2615536,'1','201','1037',478,'Retail Sale Id 1463172',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 15:23:42','',''),(2615537,'1','201','1037',478,'Retail Sale Id 1463173',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 15:24:22','',''),(2615538,'1','201','1037',478,'Retail Sale Id 1463174',7500.00,0.00,0.00,12.50,775.00,'2022-03-04 15:25:15','',''),(2615539,'1','201','1037',478,'Retail Sale Id 1463175',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 15:26:10','',''),(2615540,'1','201','1037',478,'Retail Sale Id 1463176',4200.00,0.00,0.00,7.00,434.00,'2022-03-04 15:27:00','',''),(2615541,'1','201','1037',478,'Retail Sale Id 1463177',2400.00,0.00,0.00,4.00,248.00,'2022-03-04 15:27:44','',''),(2615542,'1','201','1037',478,'Retail Sale Id 1463178',7500.00,0.00,0.00,12.50,775.00,'2022-03-04 15:31:29','',''),(2615543,'1','201','1037',478,'Retail Sale Id 1463179',2400.00,0.00,0.00,4.00,248.00,'2022-03-04 15:38:30','',''),(2615544,'1','201','1037',478,'Retail Sale Id 1463180',7500.00,0.00,0.00,12.50,775.00,'2022-03-04 15:55:23','',''),(2615545,'1','201','1037',478,'Retail Sale Id 1463181',4200.00,0.00,0.00,7.00,434.00,'2022-03-04 16:13:01','',''),(2615546,'1','201','1037',478,'Retail Sale Id 1463182',4200.00,0.00,0.00,7.00,434.00,'2022-03-04 16:15:17','',''),(2615547,'1','201','1037',478,'Retail Sale Id 1463183',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 16:18:12','',''),(2615548,'1','201','1037',478,'Retail Sale Id 1463184',6498.00,0.00,0.00,10.83,671.46,'2022-03-04 16:35:15','',''),(2615549,'1','201','1037',478,'Retail Sale Id 1463185',600.00,0.00,0.00,1.00,62.00,'2022-03-04 16:42:40','',''),(2615550,'1','201','1037',478,'Retail Sale Id 1463186',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 16:54:17','',''),(2615551,'1','201','1037',478,'Retail Sale Id 1463187',4200.00,0.00,0.00,7.00,434.00,'2022-03-04 16:56:40','',''),(2615552,'1','201','1037',478,'Retail Sale Id 1463188',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 16:58:35','',''),(2615553,'1','201','1037',478,'Retail Sale Id 1463189',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 16:59:11','',''),(2615554,'1','201','1037',478,'Retail Sale Id 1463190',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 17:01:05','',''),(2615555,'1','201','1037',478,'Retail Sale Id 1463191',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 17:02:01','',''),(2615556,'1','201','1037',478,'Retail Sale Id 1463192',1500.00,0.00,0.00,2.50,155.00,'2022-03-04 17:04:21','',''),(2615557,'1','201','1037',478,'Retail Sale Id 1463193',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 17:05:08','',''),(2615558,'1','201','1037',478,'Retail Sale Id 1463194',4800.00,0.00,0.00,8.00,496.00,'2022-03-04 17:05:55','',''),(2615559,'1','201','1037',478,'Retail Sale Id 1463195',600.00,0.00,0.00,1.00,62.00,'2022-03-04 17:06:49','',''),(2615560,'1','201','1037',478,'Retail Sale Id 1463196',600.00,0.00,0.00,1.00,62.00,'2022-03-04 17:07:27','',''),(2615561,'1','201','1037',478,'Retail Sale Id 1463197',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 17:08:14','',''),(2615562,'1','201','1037',478,'Retail Sale Id 1463198',1002.00,0.00,0.00,1.67,103.54,'2022-03-04 17:12:16','',''),(2615563,'1','201','1037',478,'Retail Sale Id 1463199',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 17:13:41','',''),(2615564,'1','201','1037',478,'Retail Sale Id 1463200',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 17:15:01','',''),(2615565,'1','201','1037',478,'Retail Sale Id 1463201',3000.00,0.00,0.00,5.00,310.00,'2022-03-04 17:16:28','',''),(2615566,'1','201','1037',478,'Retail Sale Id 1463201',6000.00,0.00,0.00,10.00,620.00,'2022-03-04 17:16:28','',''),(2615567,'1','201','1037',478,'Retail Sale Id 1463202',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 17:17:31','',''),(2615568,'1','201','1037',478,'Retail Sale Id 1463203',1002.00,0.00,0.00,1.67,103.54,'2022-03-04 17:27:08','',''),(2615569,'1','201','1037',478,'Retail Sale Id 1463204',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 17:27:54','',''),(2615570,'1','201','1037',478,'Retail Sale Id 1463205',600.00,0.00,0.00,1.00,62.00,'2022-03-04 17:38:24','',''),(2615571,'1','201','1037',478,'Retail Sale Id 1463206',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 17:39:17','',''),(2615572,'1','201','1037',478,'Retail Sale Id 1463207',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 17:41:53','',''),(2615573,'1','201','1037',478,'Retail Sale Id 1463208',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 17:45:44','',''),(2615574,'1','201','1037',478,'Retail Sale Id 1463209',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 17:49:20','',''),(2615575,'1','201','1037',478,'Retail Sale Id 1463210',1200.00,0.00,0.00,2.00,124.00,'2022-03-04 17:50:54','',''),(2615576,'1','201','1037',478,'Retail Sale Id 1463211',1998.00,0.00,0.00,3.33,206.46,'2022-03-04 17:57:11','',''),(2615577,'1','201','1037',478,'Retail Sale Id 1463212',1002.00,0.00,0.00,1.67,103.54,'2022-03-04 17:58:00','',''),(2615578,'1','201','1037',478,'Retail Sale Id 1463213',1002.00,0.00,0.00,1.67,103.54,'2022-03-04 17:58:36','',''),(2615579,'1','201','1037',478,'Retail Sale Id 1463214',1002.00,0.00,0.00,1.67,103.54,'2022-03-04 18:12:17','',''),(2615580,'1','201','1037',478,'Retail Sale Id 1463215',1800.00,0.00,0.00,3.00,186.00,'2022-03-04 18:13:10','',''),(2615581,'1','201','1037',478,'Retail Sale Id 1463216',2100.00,0.00,0.00,3.50,217.00,'2022-03-04 18:15:31','',''),(2615582,'1','201','1037',478,'Retail Sale Id 1463217',7500.00,0.00,0.00,12.50,775.00,'2022-03-04 18:18:13','',''),(2615583,'1','201','1037',478,'Return of Retail Sale Id 1463187',0.00,4200.00,7.00,0.00,-434.00,'2022-03-04 18:28:09','',''),(2615584,'1','201','1037',478,'Retail Sale Id 1463218',4068.00,0.00,0.00,6.78,420.36,'2022-03-04 18:29:16','',''),(2615585,'1','201','1037',478,'Retail Sale Id 1463219',7500.00,0.00,0.00,12.50,775.00,'2022-03-04 18:41:19','',''),(2615586,'1','201','1037',478,'Retail Sale Id 1463220',3600.00,0.00,0.00,6.00,372.00,'2022-03-04 18:45:37','',''),(2615587,'1','201','1037',478,'Return of Retail Sale Id 1463215',0.00,1800.00,3.00,0.00,-186.00,'2022-03-04 19:19:21','',''),(2615588,'1','201','1037',478,'Retail Sale Id 1463221',1782.00,0.00,0.00,2.97,184.14,'2022-03-04 19:19:57','',''),(2615589,'1','201','1037',478,'Retail Sale Id 1463222',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 07:31:46','',''),(2615590,'1','201','1037',478,'Retail Sale Id 1463223',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 07:47:03','',''),(2615591,'1','201','1037',478,'Retail Sale Id 1463224',6498.00,0.00,0.00,10.83,671.46,'2022-03-05 07:58:27','',''),(2615592,'1','201','1037',478,'Retail Sale Id 1463225',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 08:22:46','',''),(2615593,'1','201','1037',478,'Retail Sale Id 1463226',3000.00,0.00,0.00,5.00,310.00,'2022-03-05 08:41:36','',''),(2615594,'1','201','1037',478,'Retail Sale Id 1463227',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 09:05:04','',''),(2615595,'1','201','1037',478,'Retail Sale Id 1463228',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 09:07:08','',''),(2615596,'1','201','1037',478,'Retail Sale Id 1463229',2400.00,0.00,0.00,4.00,248.00,'2022-03-05 09:12:52','',''),(2615597,'1','201','1037',478,'Retail Sale Id 1463230',3000.00,0.00,0.00,5.00,310.00,'2022-03-05 09:13:37','',''),(2615598,'1','201','1037',478,'Retail Sale Id 1463231',2100.00,0.00,0.00,3.50,217.00,'2022-03-05 09:14:40','',''),(2615599,'1','201','1037',478,'Retail Sale Id 1463232',3300.00,0.00,0.00,5.50,341.00,'2022-03-05 09:23:14','',''),(2615600,'1','201','1037',478,'Retail Sale Id 1463232',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 09:23:14','',''),(2615601,'1','201','1037',478,'Retail Sale Id 1463233',1200.00,0.00,0.00,2.00,124.00,'2022-03-05 09:27:43','',''),(2615602,'1','201','1037',478,'Retail Sale Id 1463235',2400.00,0.00,0.00,4.00,248.00,'2022-03-05 09:29:22','',''),(2615603,'1','201','1037',478,'Retail Sale Id 1463236',3000.00,0.00,0.00,5.00,310.00,'2022-03-05 09:30:04','',''),(2615604,'1','201','1037',478,'Retail Sale Id 1463237',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 09:31:33','',''),(2615605,'1','201','1037',478,'Retail Sale Id 1463238',1200.00,0.00,0.00,2.00,124.00,'2022-03-05 09:32:10','',''),(2615606,'1','201','1037',478,'Retail Sale Id 1463239',1200.00,0.00,0.00,2.00,124.00,'2022-03-05 09:39:48','',''),(2615607,'1','201','1037',478,'Retail Sale Id 1463240',1200.00,0.00,0.00,2.00,124.00,'2022-03-05 09:44:22','',''),(2615608,'1','201','1037',478,'Retail Sale Id 1463241',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 09:54:40','',''),(2615609,'1','201','1037',478,'Retail Sale Id 1463242',7002.00,0.00,0.00,11.67,723.54,'2022-03-05 09:55:58','',''),(2615610,'1','201','1037',478,'Retail Sale Id 1463243',7500.00,0.00,0.00,12.50,775.00,'2022-03-05 10:32:30','',''),(2615611,'1','201','1037',478,'Retail Sale Id 1463244',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 10:41:01','',''),(2615612,'1','201','1037',478,'Retail Sale Id 1463245',1002.00,0.00,0.00,1.67,103.54,'2022-03-05 10:47:33','',''),(2615613,'1','201','1037',478,'Retail Sale Id 1463246',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 10:50:15','',''),(2615614,'1','201','1037',478,'Retail Sale Id 1463246',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 10:50:15','',''),(2615615,'1','201','1037',478,'Retail Sale Id 1463247',2100.00,0.00,0.00,3.50,217.00,'2022-03-05 11:31:17','',''),(2615616,'1','201','1037',478,'Retail Sale Id 1463249',1500.00,0.00,0.00,2.50,155.00,'2022-03-05 11:36:14','',''),(2615617,'1','201','1037',478,'Retail Sale Id 1463250',4200.00,0.00,0.00,7.00,434.00,'2022-03-05 11:54:48','',''),(2615618,'1','201','1037',478,'Retail Sale Id 1463251',2400.00,0.00,0.00,4.00,248.00,'2022-03-05 11:56:25','',''),(2615619,'1','201','1037',478,'Retail Sale Id 1463252',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 12:16:25','',''),(2615620,'1','201','1037',478,'Retail Sale Id 1463253',600.00,0.00,0.00,1.00,62.00,'2022-03-05 12:18:56','',''),(2615621,'1','201','1037',478,'Retail Sale Id 1463254',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 12:26:48','',''),(2615622,'1','201','1037',478,'Retail Sale Id 1463255',1200.00,0.00,0.00,2.00,124.00,'2022-03-05 12:31:47','',''),(2615623,'1','201','1037',478,'Retail Sale Id 1463256',2400.00,0.00,0.00,4.00,248.00,'2022-03-05 12:51:11','',''),(2615624,'1','201','1037',478,'Retail Sale Id 1463257',3000.00,0.00,0.00,5.00,310.00,'2022-03-05 12:55:42','',''),(2615625,'1','201','1037',478,'Retail Sale Id 1463258',7500.00,0.00,0.00,12.50,775.00,'2022-03-05 13:00:51','',''),(2615626,'1','201','1037',478,'Retail Sale Id 1463259',7200.00,0.00,0.00,12.00,744.00,'2022-03-05 13:25:06','',''),(2615627,'1','201','1037',478,'Retail Sale Id 1463260',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 13:36:34','',''),(2615628,'1','201','1037',478,'Retail Sale Id 1463261',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 13:39:55','',''),(2615629,'1','201','1037',478,'Retail Sale Id 1463262',1200.00,0.00,0.00,2.00,124.00,'2022-03-05 13:48:56','',''),(2615630,'1','201','1037',478,'Retail Sale Id 1463263',2502.00,0.00,0.00,4.17,258.54,'2022-03-05 13:52:34','',''),(2615631,'1','201','1037',478,'Retail Sale Id 1463264',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 14:08:59','',''),(2615632,'1','201','1037',478,'Retail Sale Id 1463265',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 14:15:26','',''),(2615633,'1','201','1037',478,'Retail Sale Id 1463266',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 14:21:17','',''),(2615634,'1','201','1037',478,'Retail Sale Id 1463267',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 14:35:59','',''),(2615635,'1','201','1037',478,'Retail Sale Id 1463268',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 14:59:34','',''),(2615636,'1','201','1037',478,'Retail Sale Id 1463269',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 15:25:39','',''),(2615637,'1','201','1037',478,'Retail Sale Id 1463270',3000.00,0.00,0.00,5.00,310.00,'2022-03-05 15:34:45','',''),(2615638,'1','201','1037',478,'Retail Sale Id 1463271',5700.00,0.00,0.00,10.00,320.00,'2022-03-05 15:36:07','',''),(2615639,'1','201','1037',478,'Retail Sale Id 1463272',6000.00,0.00,0.00,10.00,620.00,'2022-03-05 16:08:53','',''),(2615640,'1','201','1037',478,'Retail Sale Id 1463272',7200.00,0.00,0.00,12.00,744.00,'2022-03-05 16:08:53','',''),(2615641,'1','201','1037',478,'Retail Sale Id 1463273',7500.00,0.00,0.00,12.50,775.00,'2022-03-05 16:09:41','',''),(2615642,'1','201','1037',478,'Retail Sale Id 1463274',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 16:10:32','',''),(2615643,'1','201','1037',478,'Retail Sale Id 1463275',1002.00,0.00,0.00,1.67,103.54,'2022-03-05 16:15:27','',''),(2615644,'1','201','1037',478,'Retail Sale Id 1463276',1200.00,0.00,0.00,2.00,124.00,'2022-03-05 16:16:32','',''),(2615645,'1','201','1037',478,'Retail Sale Id 1463277',6000.00,0.00,0.00,10.00,620.00,'2022-03-05 16:40:10','',''),(2615646,'1','201','1037',478,'Retail Sale Id 1463278',1002.00,0.00,0.00,1.67,103.54,'2022-03-05 16:43:48','',''),(2615647,'1','201','1037',478,'Retail Sale Id 1463279',1002.00,0.00,0.00,1.67,103.54,'2022-03-05 16:44:40','',''),(2615648,'1','201','1037',478,'Retail Sale Id 1463281',6900.00,0.00,0.00,11.50,713.00,'2022-03-05 16:55:33','',''),(2615649,'1','201','1037',478,'Retail Sale Id 1463282',600.00,0.00,0.00,1.00,62.00,'2022-03-05 16:56:42','',''),(2615650,'1','201','1037',478,'Retail Sale Id 1463282',600.00,0.00,0.00,1.00,62.00,'2022-03-05 16:56:42','',''),(2615651,'1','201','1037',478,'Retail Sale Id 1463283',7500.00,0.00,0.00,12.50,775.00,'2022-03-05 17:12:32','',''),(2615652,'1','201','1037',478,'Retail Sale Id 1463284',7500.00,0.00,0.00,12.50,775.00,'2022-03-05 17:22:40','',''),(2615653,'1','201','1037',478,'Retail Sale Id 1463285',3600.00,0.00,0.00,6.00,372.00,'2022-03-05 17:24:18','',''),(2615654,'1','201','1037',478,'Retail Sale Id 1463286',4002.00,0.00,0.00,6.67,413.54,'2022-03-05 17:26:43','',''),(2615655,'1','201','1037',478,'Retail Sale Id 1463287',7500.00,0.00,0.00,12.50,775.00,'2022-03-05 17:27:27','',''),(2615656,'1','201','1037',478,'Retail Sale Id 1463288',5502.00,0.00,0.00,9.17,568.54,'2022-03-05 17:28:15','',''),(2615657,'1','201','1037',478,'Retail Sale Id 1463289',1200.00,0.00,0.00,2.00,124.00,'2022-03-05 17:29:51','',''),(2615658,'1','201','1037',478,'Retail Sale Id 1463290',28250.00,0.00,0.00,50.00,1350.00,'2022-03-05 17:31:28','',''),(2615659,'1','201','1037',478,'Retail Sale Id 1463291',600.00,0.00,0.00,1.00,62.00,'2022-03-05 17:39:06','',''),(2615660,'1','201','1037',478,'Retail Sale Id 1463292',1200.00,0.00,0.00,2.00,124.00,'2022-03-05 17:40:33','',''),(2615661,'1','201','1037',478,'Retail Sale Id 1463293',1200.00,0.00,0.00,2.00,124.00,'2022-03-05 17:46:35','',''),(2615662,'1','201','1037',478,'Retail Sale Id 1463294',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 17:51:42','',''),(2615663,'1','201','1037',478,'Retail Sale Id 1463294',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 17:51:42','',''),(2615664,'1','201','1037',478,'Retail Sale Id 1463294',7200.00,0.00,0.00,12.00,744.00,'2022-03-05 17:51:42','',''),(2615665,'1','201','1037',478,'Retail Sale Id 1463295',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 17:59:52','',''),(2615666,'1','201','1037',478,'Retail Sale Id 1463296',1800.00,0.00,0.00,3.00,186.00,'2022-03-05 18:14:03','',''),(2615667,'1','201','1037',478,'Retail Sale Id 1463297',7500.00,0.00,0.00,12.50,775.00,'2022-03-05 18:21:06','',''),(2615668,'1','201','1037',478,'Return of Retail Sale Id 1463292',0.00,1200.00,2.00,0.00,-124.00,'2022-03-05 19:00:39','',''),(2615669,'1','201','1037',478,'Retail Sale Id 1463298',990.00,0.00,0.00,1.65,102.30,'2022-03-05 19:01:26','',''),(2615670,'1','201','1037',478,'Retail Sale Id 1463299',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 08:10:32','',''),(2615671,'1','201','1037',478,'Retail Sale Id 1463300',900.00,0.00,0.00,1.50,93.00,'2022-03-06 08:12:39','',''),(2615672,'1','201','1037',478,'Retail Sale Id 1463301',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 08:13:37','',''),(2615673,'1','201','1037',478,'Retail Sale Id 1463302',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 08:22:55','',''),(2615674,'1','201','1037',478,'Retail Sale Id 1463303',600.00,0.00,0.00,1.00,62.00,'2022-03-06 08:28:08','',''),(2615675,'1','201','1037',478,'Retail Sale Id 1463304',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 08:42:02','',''),(2615676,'1','201','1037',478,'Retail Sale Id 1463305',600.00,0.00,0.00,1.00,62.00,'2022-03-06 08:46:06','',''),(2615677,'1','201','1037',478,'Retail Sale Id 1463306',7500.00,0.00,0.00,12.50,775.00,'2022-03-06 08:49:51','',''),(2615678,'1','201','1037',478,'Retail Sale Id 1463306',7500.00,0.00,0.00,12.50,775.00,'2022-03-06 08:49:51','',''),(2615679,'1','201','1037',478,'Retail Sale Id 1463307',7500.00,0.00,0.00,12.50,775.00,'2022-03-06 08:55:27','',''),(2615680,'1','201','1037',478,'Retail Sale Id 1463308',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 08:56:12','',''),(2615681,'1','201','1037',478,'Retail Sale Id 1463309',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 08:59:08','',''),(2615682,'1','201','1037',478,'Retail Sale Id 1463310',600.00,0.00,0.00,1.00,62.00,'2022-03-06 09:00:49','',''),(2615683,'1','201','1037',478,'Retail Sale Id 1463311',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 09:02:16','',''),(2615684,'1','201','1037',478,'Retail Sale Id 1463312',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 09:05:21','',''),(2615685,'1','201','1037',478,'Retail Sale Id 1463313',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 09:06:46','',''),(2615686,'1','201','1037',478,'Retail Sale Id 1463314',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 09:21:23','',''),(2615687,'1','201','1037',478,'Retail Sale Id 1463315',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 09:22:48','',''),(2615688,'1','201','1037',478,'Retail Sale Id 1463316',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 09:32:33','',''),(2615689,'1','201','1037',478,'Retail Sale Id 1463317',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 09:33:56','',''),(2615690,'1','201','1037',478,'Retail Sale Id 1463318',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 09:35:22','',''),(2615691,'1','201','1037',478,'Retail Sale Id 1463319',1002.00,0.00,0.00,1.67,103.54,'2022-03-06 09:39:28','',''),(2615692,'1','201','1037',478,'Retail Sale Id 1463320',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 09:41:53','',''),(2615693,'1','201','1037',478,'Retail Sale Id 1463321',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 09:45:28','',''),(2615694,'1','201','1037',478,'Retail Sale Id 1463322',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 09:48:19','',''),(2615695,'1','201','1037',478,'Retail Sale Id 1463323',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 09:54:07','',''),(2615696,'1','201','1037',478,'Retail Sale Id 1463324',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 10:03:55','',''),(2615697,'1','201','1037',478,'Retail Sale Id 1463325',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 10:29:33','',''),(2615698,'1','201','1037',478,'Retail Sale Id 1463326',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 10:45:20','',''),(2615699,'1','201','1037',478,'Retail Sale Id 1463327',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 10:48:28','',''),(2615700,'1','201','1037',478,'Retail Sale Id 1463328',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 10:50:02','',''),(2615701,'1','201','1037',478,'Retail Sale Id 1463329',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 10:55:18','',''),(2615702,'1','201','1037',478,'Retail Sale Id 1463330',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 11:00:22','',''),(2615703,'1','201','1037',478,'Retail Sale Id 1463331',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 11:36:51','',''),(2615704,'1','201','1037',478,'Retail Sale Id 1463332',1500.00,0.00,0.00,2.50,155.00,'2022-03-06 11:43:45','',''),(2615705,'1','201','1037',478,'Retail Sale Id 1463332',1500.00,0.00,0.00,2.50,155.00,'2022-03-06 11:43:45','',''),(2615706,'1','201','1037',478,'Retail Sale Id 1463333',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 12:02:26','',''),(2615707,'1','201','1037',478,'Retail Sale Id 1463334',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 12:08:45','',''),(2615708,'1','201','1037',478,'Retail Sale Id 1463335',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 12:14:03','',''),(2615709,'1','201','1037',478,'Retail Sale Id 1463336',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 12:26:30','',''),(2615710,'1','201','1037',478,'Retail Sale Id 1463336',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 12:26:30','',''),(2615711,'1','201','1037',478,'Retail Sale Id 1463337',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 12:29:03','',''),(2615712,'1','201','1037',478,'Retail Sale Id 1463338',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 12:37:09','',''),(2615713,'1','201','1037',478,'Retail Sale Id 1463339',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 12:49:55','',''),(2615714,'1','201','1037',478,'Retail Sale Id 1463339',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 12:49:55','',''),(2615715,'1','201','1037',478,'Retail Sale Id 1463339',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 12:49:55','',''),(2615716,'1','201','1037',478,'Retail Sale Id 1463340',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 12:59:21','',''),(2615717,'1','201','1037',478,'Retail Sale Id 1463341',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 13:11:17','',''),(2615718,'1','201','1037',478,'Retail Sale Id 1463342',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 13:55:01','',''),(2615719,'1','201','1037',478,'Retail Sale Id 1463343',7500.00,0.00,0.00,12.50,775.00,'2022-03-06 13:56:16','',''),(2615720,'1','201','1037',478,'Retail Sale Id 1463344',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 13:57:08','',''),(2615721,'1','201','1037',478,'Retail Sale Id 1463345',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 13:57:57','',''),(2615722,'1','201','1037',478,'Retail Sale Id 1463346',1500.00,0.00,0.00,2.50,155.00,'2022-03-06 14:03:22','',''),(2615723,'1','201','1037',478,'Retail Sale Id 1463347',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 14:20:29','',''),(2615724,'1','201','1037',478,'Retail Sale Id 1463348',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 14:27:41','',''),(2615725,'1','201','1037',478,'Retail Sale Id 1463348',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 14:27:41','',''),(2615726,'1','201','1037',478,'Retail Sale Id 1463349',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 14:30:57','',''),(2615727,'1','201','1037',478,'Retail Sale Id 1463350',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 14:31:55','',''),(2615728,'1','201','1037',478,'Retail Sale Id 1463351',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 14:42:49','',''),(2615729,'1','201','1037',478,'Retail Sale Id 1463351',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 14:42:49','',''),(2615730,'1','201','1037',478,'Retail Sale Id 1463352',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 14:43:56','',''),(2615731,'1','201','1037',478,'Retail Sale Id 1463353',4200.00,0.00,0.00,7.00,434.00,'2022-03-06 14:48:08','',''),(2615732,'1','201','1037',478,'Retail Sale Id 1463354',7500.00,0.00,0.00,12.50,775.00,'2022-03-06 14:54:56','',''),(2615733,'1','201','1037',478,'Retail Sale Id 1463355',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 15:00:47','',''),(2615734,'1','201','1037',478,'Retail Sale Id 1463356',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 15:06:28','',''),(2615735,'1','201','1037',478,'Retail Sale Id 1463357',7500.00,0.00,0.00,12.50,775.00,'2022-03-06 15:13:25','',''),(2615736,'1','201','1037',478,'Retail Sale Id 1463358',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 15:15:45','',''),(2615737,'1','201','1037',478,'Retail Sale Id 1463359',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 15:24:49','',''),(2615738,'1','201','1037',478,'Retail Sale Id 1463360',56500.00,0.00,0.00,100.00,2700.00,'2022-03-06 15:30:03','',''),(2615739,'1','201','1037',478,'Retail Sale Id 1463361',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 15:36:14','',''),(2615740,'1','201','1037',478,'Retail Sale Id 1463362',4200.00,0.00,0.00,7.00,434.00,'2022-03-06 15:41:21','',''),(2615741,'1','201','1037',478,'Retail Sale Id 1463363',2400.00,0.00,0.00,4.00,248.00,'2022-03-06 15:42:56','',''),(2615742,'1','201','1037',478,'Retail Sale Id 1463364',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 15:44:57','',''),(2615743,'1','201','1037',478,'Retail Sale Id 1463364',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 15:44:57','',''),(2615744,'1','201','1037',478,'Retail Sale Id 1463365',1998.00,0.00,0.00,3.33,206.46,'2022-03-06 15:50:17','',''),(2615745,'1','201','1037',478,'Retail Sale Id 1463366',2100.00,0.00,0.00,3.50,217.00,'2022-03-06 16:08:58','',''),(2615746,'1','201','1037',478,'Retail Sale Id 1463367',600.00,0.00,0.00,1.00,62.00,'2022-03-06 16:18:58','',''),(2615747,'1','201','1037',478,'Retail Sale Id 1463368',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 16:25:34','',''),(2615748,'1','201','1037',478,'Retail Sale Id 1463368',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 16:25:34','',''),(2615749,'1','201','1037',478,'Retail Sale Id 1463369',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 16:28:52','',''),(2615750,'1','201','1037',478,'Retail Sale Id 1463370',2400.00,0.00,0.00,4.00,248.00,'2022-03-06 16:30:32','',''),(2615751,'1','201','1037',478,'Retail Sale Id 1463371',3600.00,0.00,0.00,6.00,372.00,'2022-03-06 16:32:24','',''),(2615752,'1','201','1037',478,'Retail Sale Id 1463372',3000.00,0.00,0.00,5.00,310.00,'2022-03-06 16:36:51','',''),(2615753,'1','201','1037',478,'Retail Sale Id 1463373',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 16:42:39','',''),(2615754,'1','201','1037',478,'Retail Sale Id 1463374',2100.00,0.00,0.00,3.50,217.00,'2022-03-06 16:45:57','',''),(2615755,'1','201','1037',478,'Retail Sale Id 1463375',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 16:47:04','',''),(2615756,'1','201','1037',478,'Retail Sale Id 1463376',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 16:55:40','',''),(2615757,'1','201','1037',478,'Retail Sale Id 1463377',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 17:02:20','',''),(2615758,'1','201','1037',478,'Retail Sale Id 1463378',4200.00,0.00,0.00,7.00,434.00,'2022-03-06 17:11:09','',''),(2615759,'1','201','1037',478,'Retail Sale Id 1463379',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 17:13:13','',''),(2615760,'1','201','1037',478,'Retail Sale Id 1463380',600.00,0.00,0.00,1.00,62.00,'2022-03-06 17:14:30','',''),(2615761,'1','201','1037',478,'Retail Sale Id 1463381',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 17:21:43','',''),(2615762,'1','201','1037',478,'Retail Sale Id 1463382',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 17:41:27','',''),(2615763,'1','201','1037',478,'Retail Sale Id 1463383',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 17:43:31','',''),(2615764,'1','201','1037',478,'Retail Sale Id 1463384',600.00,0.00,0.00,1.00,62.00,'2022-03-06 17:55:53','',''),(2615765,'1','201','1037',478,'Retail Sale Id 1463385',1800.00,0.00,0.00,3.00,186.00,'2022-03-06 18:06:53','',''),(2615766,'1','201','1037',478,'Retail Sale Id 1463386',7500.00,0.00,0.00,12.50,775.00,'2022-03-06 18:21:12','',''),(2615767,'1','201','1037',478,'Retail Sale Id 1463387',2400.00,0.00,0.00,4.00,248.00,'2022-03-06 18:24:06','',''),(2615768,'1','201','1037',478,'Retail Sale Id 1463388',1200.00,0.00,0.00,2.00,124.00,'2022-03-06 18:31:08','',''),(2615769,'1','201','1037',478,'Return of Retail Sale Id 1463381',0.00,1800.00,3.00,0.00,-186.00,'2022-03-06 19:03:12','',''),(2615770,'1','201','1037',478,'Retail Sale Id 1463389',468.00,0.00,0.00,0.78,48.36,'2022-03-06 19:03:47','',''),(2615771,'1','201','1037',478,'Retail Sale Id 1463390',6498.00,0.00,0.00,10.83,671.46,'2022-03-07 07:35:27','',''),(2615772,'1','201','1037',478,'Retail Sale Id 1463391',600.00,0.00,0.00,1.00,62.00,'2022-03-07 07:48:45','',''),(2615773,'1','201','1037',478,'Retail Sale Id 1463392',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 08:20:03','',''),(2615774,'1','201','1037',478,'Retail Sale Id 1463393',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 08:27:52','',''),(2615775,'1','201','1037',478,'Retail Sale Id 1463394',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 08:39:44','',''),(2615776,'1','201','1037',478,'Retail Sale Id 1463395',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 08:41:04','',''),(2615777,'1','201','1037',478,'Retail Sale Id 1463396',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 08:46:05','',''),(2615778,'1','201','1037',478,'Retail Sale Id 1463397',56500.00,0.00,0.00,100.00,2700.00,'2022-03-07 09:18:21','',''),(2615779,'1','201','1037',478,'Retail Sale Id 1463398',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 09:21:56','',''),(2615780,'1','201','1037',478,'Retail Sale Id 1463399',4200.00,0.00,0.00,7.00,434.00,'2022-03-07 09:39:01','',''),(2615781,'1','201','1037',478,'Retail Sale Id 1463400',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 10:10:19','',''),(2615782,'1','201','1037',478,'Retail Sale Id 1463401',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 10:12:18','',''),(2615783,'1','201','1037',478,'Retail Sale Id 1463402',60455.00,0.00,0.00,107.00,2889.00,'2022-03-07 10:15:38','',''),(2615784,'1','201','1037',478,'Retail Sale Id 1463403',600.00,0.00,0.00,1.00,62.00,'2022-03-07 10:24:04','',''),(2615785,'1','201','1037',478,'Retail Sale Id 1463404',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 10:31:08','',''),(2615786,'1','201','1037',478,'Retail Sale Id 1463405',84750.00,0.00,0.00,150.00,4050.00,'2022-03-07 11:13:51','',''),(2615787,'1','201','1037',478,'Retail Sale Id 1463406',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 11:21:34','',''),(2615788,'1','201','1037',478,'Retail Sale Id 1463406',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 11:21:34','',''),(2615789,'1','201','1037',478,'Retail Sale Id 1463407',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 11:25:09','',''),(2615790,'1','201','1037',478,'Retail Sale Id 1463408',3000.00,0.00,0.00,5.00,310.00,'2022-03-07 11:26:17','',''),(2615791,'1','201','1037',478,'Retail Sale Id 1463409',6270.00,0.00,0.00,11.00,352.00,'2022-03-07 11:48:26','',''),(2615792,'1','201','1037',478,'Retail Sale Id 1463410',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 12:23:17','',''),(2615793,'1','201','1037',478,'Retail Sale Id 1463411',7500.00,0.00,0.00,12.50,775.00,'2022-03-07 12:46:45','',''),(2615794,'1','201','1037',478,'Retail Sale Id 1463412',3000.00,0.00,0.00,5.00,310.00,'2022-03-07 12:53:15','',''),(2615795,'1','201','1037',478,'Retail Sale Id 1463413',7200.00,0.00,0.00,12.00,744.00,'2022-03-07 12:56:12','',''),(2615796,'1','201','1037',478,'Retail Sale Id 1463414',600.00,0.00,0.00,1.00,62.00,'2022-03-07 13:03:06','',''),(2615797,'1','201','1037',478,'Retail Sale Id 1463415',28500.00,0.00,0.00,50.00,1600.00,'2022-03-07 13:05:04','',''),(2615798,'1','201','1037',478,'Retail Sale Id 1463416',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 13:06:05','',''),(2615799,'1','201','1037',478,'Retail Sale Id 1463417',1500.00,0.00,0.00,2.50,155.00,'2022-03-07 13:10:27','',''),(2615800,'1','201','1037',478,'Retail Sale Id 1463418',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 13:11:29','',''),(2615801,'1','201','1037',478,'Retail Sale Id 1463419',6000.00,0.00,0.00,10.00,620.00,'2022-03-07 13:15:08','',''),(2615802,'1','201','1037',478,'Retail Sale Id 1463420',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 13:18:59','',''),(2615803,'1','201','1037',478,'Retail Sale Id 1463421',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 13:36:29','',''),(2615804,'1','201','1037',478,'Retail Sale Id 1463422',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 13:56:21','',''),(2615805,'1','201','1037',478,'Retail Sale Id 1463423',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 14:04:12','',''),(2615806,'1','201','1037',478,'Retail Sale Id 1463424',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 14:30:05','',''),(2615807,'1','201','1037',478,'Retail Sale Id 1463425',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 14:41:06','',''),(2615808,'1','201','1037',478,'Retail Sale Id 1463425',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 14:41:06','',''),(2615809,'1','201','1037',478,'Retail Sale Id 1463426',1998.00,0.00,0.00,3.33,206.46,'2022-03-07 14:41:53','',''),(2615810,'1','201','1037',478,'Retail Sale Id 1463427',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 14:42:35','',''),(2615811,'1','201','1037',478,'Retail Sale Id 1463428',4200.00,0.00,0.00,7.00,434.00,'2022-03-07 14:43:13','',''),(2615812,'1','201','1037',478,'Retail Sale Id 1463429',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 14:49:01','',''),(2615813,'1','201','1037',478,'Retail Sale Id 1463430',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 14:49:52','',''),(2615814,'1','201','1037',478,'Retail Sale Id 1463431',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 14:54:08','',''),(2615815,'1','201','1037',478,'Retail Sale Id 1463432',7500.00,0.00,0.00,12.50,775.00,'2022-03-07 14:55:17','',''),(2615816,'1','201','1037',478,'Retail Sale Id 1463433',3000.00,0.00,0.00,5.00,310.00,'2022-03-07 14:58:30','',''),(2615817,'1','201','1037',478,'Retail Sale Id 1463434',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 15:00:59','',''),(2615818,'1','201','1037',478,'Return of Retail Sale Id 1463428',0.00,4200.00,7.00,0.00,-434.00,'2022-03-07 15:09:52','',''),(2615819,'1','201','1037',478,'Retail Sale Id 1463435',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 15:13:35','',''),(2615820,'1','201','1037',478,'Retail Sale Id 1463436',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 15:16:00','',''),(2615821,'1','201','1037',478,'Retail Sale Id 1463437',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 15:17:08','',''),(2615822,'1','201','1037',478,'Retail Sale Id 1463438',3900.00,0.00,0.00,6.50,403.00,'2022-03-07 15:21:19','',''),(2615823,'1','201','1037',478,'Retail Sale Id 1463438',3900.00,0.00,0.00,6.50,403.00,'2022-03-07 15:21:19','',''),(2615824,'1','201','1037',478,'Retail Sale Id 1463439',2400.00,0.00,0.00,4.00,248.00,'2022-03-07 15:27:37','',''),(2615825,'1','201','1037',478,'Return of Retail Sale Id 1463438',0.00,3900.00,6.50,0.00,-403.00,'2022-03-07 15:27:57','',''),(2615826,'1','201','1037',478,'Return of Retail Sale Id 1463438',0.00,3900.00,6.50,0.00,-403.00,'2022-03-07 15:27:57','',''),(2615827,'1','201','1037',478,'Retail Sale Id 1463440',3900.00,0.00,0.00,6.50,403.00,'2022-03-07 15:29:15','',''),(2615828,'1','201','1037',478,'Retail Sale Id 1463441',4200.00,0.00,0.00,7.00,434.00,'2022-03-07 15:31:32','',''),(2615829,'1','201','1037',478,'Retail Sale Id 1463442',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 15:32:41','',''),(2615830,'1','201','1037',478,'Retail Sale Id 1463443',6000.00,0.00,0.00,10.00,620.00,'2022-03-07 15:38:29','',''),(2615831,'1','201','1037',478,'Retail Sale Id 1463444',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 15:41:53','',''),(2615832,'1','201','1037',478,'Retail Sale Id 1463445',7500.00,0.00,0.00,12.50,775.00,'2022-03-07 15:43:23','',''),(2615833,'1','201','1037',478,'Retail Sale Id 1463446',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 15:55:21','',''),(2615834,'1','201','1037',478,'Retail Sale Id 1463447',28250.00,0.00,0.00,50.00,1350.00,'2022-03-07 15:57:29','',''),(2615835,'1','201','1037',478,'Retail Sale Id 1463448',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 15:59:42','',''),(2615836,'1','201','1037',478,'Retail Sale Id 1463449',1500.00,0.00,0.00,2.50,155.00,'2022-03-07 16:06:50','',''),(2615837,'1','201','1037',478,'Retail Sale Id 1463450',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 16:13:28','',''),(2615838,'1','201','1037',478,'Retail Sale Id 1463451',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 16:19:21','',''),(2615839,'1','201','1037',478,'Retail Sale Id 1463452',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 16:23:57','',''),(2615840,'1','201','1037',478,'Retail Sale Id 1463453',3000.00,0.00,0.00,5.00,310.00,'2022-03-07 16:35:48','',''),(2615841,'1','201','1037',478,'Retail Sale Id 1463454',3000.00,0.00,0.00,5.00,310.00,'2022-03-07 16:41:20','',''),(2615842,'1','201','1037',478,'Retail Sale Id 1463455',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 16:45:56','',''),(2615843,'1','201','1037',478,'Retail Sale Id 1463456',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 16:52:19','',''),(2615844,'1','201','1037',478,'Retail Sale Id 1463457',1002.00,0.00,0.00,1.67,103.54,'2022-03-07 17:02:24','',''),(2615845,'1','201','1037',478,'Retail Sale Id 1463458',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 17:03:27','',''),(2615846,'1','201','1037',478,'Retail Sale Id 1463459',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 17:04:43','',''),(2615847,'1','201','1037',478,'Retail Sale Id 1463460',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 17:05:59','',''),(2615848,'1','201','1037',478,'Retail Sale Id 1463461',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 17:21:12','',''),(2615849,'1','201','1037',478,'Retail Sale Id 1463462',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 17:21:47','',''),(2615850,'1','201','1037',478,'Retail Sale Id 1463463',3000.00,0.00,0.00,5.00,310.00,'2022-03-07 17:23:36','',''),(2615851,'1','201','1037',478,'Retail Sale Id 1463464',7500.00,0.00,0.00,12.50,775.00,'2022-03-07 17:24:58','',''),(2615852,'1','201','1037',478,'Retail Sale Id 1463465',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 17:29:51','',''),(2615853,'1','201','1037',478,'Retail Sale Id 1463466',7500.00,0.00,0.00,12.50,775.00,'2022-03-07 17:31:31','',''),(2615854,'1','201','1037',478,'Retail Sale Id 1463467',2400.00,0.00,0.00,4.00,248.00,'2022-03-07 17:32:24','',''),(2615855,'1','201','1037',478,'Retail Sale Id 1463468',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 17:33:06','',''),(2615856,'1','201','1037',478,'Retail Sale Id 1463469',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 17:33:55','',''),(2615857,'1','201','1037',478,'Retail Sale Id 1463470',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 17:34:39','',''),(2615858,'1','201','1037',478,'Retail Sale Id 1463471',3000.00,0.00,0.00,5.00,310.00,'2022-03-07 17:35:11','',''),(2615859,'1','201','1037',478,'Retail Sale Id 1463472',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 17:44:43','',''),(2615860,'1','201','1037',478,'Retail Sale Id 1463473',600.00,0.00,0.00,1.00,62.00,'2022-03-07 17:47:49','',''),(2615861,'1','201','1037',478,'Retail Sale Id 1463474',3000.00,0.00,0.00,5.00,310.00,'2022-03-07 17:49:55','',''),(2615862,'1','201','1037',478,'Retail Sale Id 1463475',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 17:51:46','',''),(2615863,'1','201','1037',478,'Retail Sale Id 1463476',600.00,0.00,0.00,1.00,62.00,'2022-03-07 17:56:06','',''),(2615864,'1','201','1037',478,'Retail Sale Id 1463477',3000.00,0.00,0.00,5.00,310.00,'2022-03-07 17:57:15','',''),(2615865,'1','201','1037',478,'Retail Sale Id 1463478',3600.00,0.00,0.00,6.00,372.00,'2022-03-07 18:02:23','',''),(2615866,'1','201','1037',478,'Retail Sale Id 1463479',7500.00,0.00,0.00,12.50,775.00,'2022-03-07 18:13:23','',''),(2615867,'1','201','1037',478,'Retail Sale Id 1463480',1200.00,0.00,0.00,2.00,124.00,'2022-03-07 18:19:29','',''),(2615868,'1','201','1037',478,'Retail Sale Id 1463481',1800.00,0.00,0.00,3.00,186.00,'2022-03-07 18:21:14','',''),(2615869,'1','201','1037',478,'Retail Sale Id 1463482',702.00,0.00,0.00,1.17,72.54,'2022-03-07 18:22:02','',''),(2615870,'1','201','1037',478,'Retail Sale Id 1463483',7500.00,0.00,0.00,12.50,775.00,'2022-03-07 18:49:58','',''),(2615871,'1','201','1037',478,'Retail Sale Id 1463484',4002.00,0.00,0.00,6.67,413.54,'2022-03-07 18:51:37','',''),(2615872,'1','201','1037',478,'Return of Retail Sale Id 1463475',0.00,1800.00,3.00,0.00,-186.00,'2022-03-07 19:26:01','',''),(2615873,'1','201','1037',478,'Retail Sale Id 1463485',1776.00,0.00,0.00,2.96,183.52,'2022-03-07 19:26:40','',''),(2615874,'1','201','1037',478,'Retail Sale Id 1463486',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 07:24:20','',''),(2615875,'1','201','1037',478,'Retail Sale Id 1463487',7500.00,0.00,0.00,12.50,775.00,'2022-03-08 07:25:43','',''),(2615876,'1','201','1037',478,'Retail Sale Id 1463488',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 08:35:00','',''),(2615877,'1','201','1037',478,'Retail Sale Id 1463489',6000.00,0.00,0.00,10.00,620.00,'2022-03-08 08:35:56','',''),(2615878,'1','201','1037',478,'Retail Sale Id 1463490',56500.00,0.00,0.00,100.00,2700.00,'2022-03-08 09:24:52','',''),(2615879,'1','201','1037',478,'Retail Sale Id 1463491',3600.00,0.00,0.00,6.00,372.00,'2022-03-08 09:26:12','',''),(2615880,'1','201','1037',478,'Retail Sale Id 1463492',7500.00,0.00,0.00,12.50,775.00,'2022-03-08 09:53:35','',''),(2615881,'1','201','1037',478,'Retail Sale Id 1463493',3000.00,0.00,0.00,5.00,310.00,'2022-03-08 09:54:18','',''),(2615882,'1','201','1037',478,'Retail Sale Id 1463494',1200.00,0.00,0.00,2.00,124.00,'2022-03-08 10:05:02','',''),(2615883,'1','201','1037',478,'Retail Sale Id 1463495',1710.00,0.00,0.00,3.00,96.00,'2022-03-08 10:13:46','',''),(2615884,'1','201','1037',478,'Retail Sale Id 1463496',3000.00,0.00,0.00,5.00,310.00,'2022-03-08 10:24:33','',''),(2615885,'1','201','1037',478,'Retail Sale Id 1463497',1200.00,0.00,0.00,2.00,124.00,'2022-03-08 10:25:32','',''),(2615886,'1','201','1037',478,'Retail Sale Id 1463498',1998.00,0.00,0.00,3.33,206.46,'2022-03-08 10:31:44','',''),(2615887,'1','201','1037',478,'Retail Sale Id 1463499',6600.00,0.00,0.00,11.00,682.00,'2022-03-08 10:44:32','',''),(2615888,'1','201','1037',478,'Retail Sale Id 1463500',4560.00,0.00,0.00,8.00,256.00,'2022-03-08 10:56:11','',''),(2615889,'1','201','1037',478,'Retail Sale Id 1463501',600.00,0.00,0.00,1.00,62.00,'2022-03-08 10:59:00','',''),(2615890,'1','201','1037',478,'Retail Sale Id 1463502',7500.00,0.00,0.00,12.50,775.00,'2022-03-08 11:07:04','',''),(2615891,'1','201','1037',478,'Retail Sale Id 1463503',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 11:12:07','',''),(2615892,'1','201','1037',478,'Retail Sale Id 1463504',3600.00,0.00,0.00,6.00,372.00,'2022-03-08 11:20:02','',''),(2615893,'1','201','1037',478,'Retail Sale Id 1463505',7062.50,0.00,0.00,12.50,337.50,'2022-03-08 11:25:14','',''),(2615894,'1','201','1037',478,'Retail Sale Id 1463506',798.00,0.00,0.00,1.33,82.46,'2022-03-08 11:31:59','',''),(2615895,'1','201','1037',478,'Retail Sale Id 1463507',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 11:33:07','',''),(2615896,'1','201','1037',478,'Retail Sale Id 1463508',1500.00,0.00,0.00,2.50,155.00,'2022-03-08 11:39:09','',''),(2615897,'1','201','1037',478,'Retail Sale Id 1463509',7500.00,0.00,0.00,12.50,775.00,'2022-03-08 11:45:02','',''),(2615898,'1','201','1037',478,'Retail Sale Id 1463510',7200.00,0.00,0.00,12.00,744.00,'2022-03-08 11:53:36','',''),(2615899,'1','201','1037',478,'Retail Sale Id 1463510',7500.00,0.00,0.00,12.50,775.00,'2022-03-08 11:53:36','',''),(2615900,'1','201','1037',478,'Retail Sale Id 1463511',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 12:07:27','',''),(2615901,'1','201','1037',478,'Retail Sale Id 1463512',2400.00,0.00,0.00,4.00,248.00,'2022-03-08 12:13:20','',''),(2615902,'1','201','1037',478,'Retail Sale Id 1463513',8550.00,0.00,0.00,15.00,480.00,'2022-03-08 12:17:16','',''),(2615903,'1','201','1037',478,'Retail Sale Id 1463514',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 12:26:18','',''),(2615904,'1','201','1037',478,'Retail Sale Id 1463515',1200.00,0.00,0.00,2.00,124.00,'2022-03-08 12:32:25','',''),(2615905,'1','201','1037',478,'Retail Sale Id 1463516',1002.00,0.00,0.00,1.67,103.54,'2022-03-08 12:47:21','',''),(2615906,'1','201','1037',478,'Retail Sale Id 1463517',1002.00,0.00,0.00,1.67,103.54,'2022-03-08 13:01:52','',''),(2615907,'1','201','1037',478,'Retail Sale Id 1463518',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 13:20:25','',''),(2615908,'1','201','1037',478,'Retail Sale Id 1463519',2100.00,0.00,0.00,3.50,217.00,'2022-03-08 13:28:26','',''),(2615909,'1','201','1037',478,'Retail Sale Id 1463520',3000.00,0.00,0.00,5.00,310.00,'2022-03-08 13:37:32','',''),(2615910,'1','201','1037',478,'Retail Sale Id 1463521',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 13:53:10','',''),(2615911,'1','201','1037',478,'Retail Sale Id 1463522',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 13:54:16','',''),(2615912,'1','201','1037',478,'Retail Sale Id 1463523',4200.00,0.00,0.00,7.00,434.00,'2022-03-08 13:55:11','',''),(2615913,'1','201','1037',478,'Retail Sale Id 1463524',1200.00,0.00,0.00,2.00,124.00,'2022-03-08 14:07:14','',''),(2615914,'1','201','1037',478,'Retail Sale Id 1463525',1200.00,0.00,0.00,2.00,124.00,'2022-03-08 14:08:02','',''),(2615915,'1','201','1037',478,'Retail Sale Id 1463526',3600.00,0.00,0.00,6.00,372.00,'2022-03-08 14:08:53','',''),(2615916,'1','201','1037',478,'Retail Sale Id 1463527',7500.00,0.00,0.00,12.50,775.00,'2022-03-08 14:11:33','',''),(2615917,'1','201','1037',478,'Retail Sale Id 1463528',1200.00,0.00,0.00,2.00,124.00,'2022-03-08 14:28:55','',''),(2615918,'1','201','1037',478,'Retail Sale Id 1463529',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 14:30:00','',''),(2615919,'1','201','1037',478,'Retail Sale Id 1463530',2400.00,0.00,0.00,4.00,248.00,'2022-03-08 14:32:50','',''),(2615920,'1','201','1037',478,'Retail Sale Id 1463531',1200.00,0.00,0.00,2.00,124.00,'2022-03-08 14:47:10','',''),(2615921,'1','201','1037',478,'Retail Sale Id 1463532',3600.00,0.00,0.00,6.00,372.00,'2022-03-08 15:01:12','',''),(2615922,'1','201','1037',478,'Retail Sale Id 1463533',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 15:02:00','',''),(2615923,'1','201','1037',478,'Retail Sale Id 1463534',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 15:07:36','',''),(2615924,'1','201','1037',478,'Retail Sale Id 1463535',6000.00,0.00,0.00,10.00,620.00,'2022-03-08 15:08:30','',''),(2615925,'1','201','1037',478,'Retail Sale Id 1463536',1200.00,0.00,0.00,2.00,124.00,'2022-03-08 15:09:16','',''),(2615926,'1','201','1037',478,'Retail Sale Id 1463537',3000.00,0.00,0.00,5.00,310.00,'2022-03-08 15:30:20','',''),(2615927,'1','201','1037',478,'Retail Sale Id 1463538',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 15:31:17','',''),(2615928,'1','201','1037',478,'Retail Sale Id 1463539',3000.00,0.00,0.00,5.00,310.00,'2022-03-08 15:34:01','',''),(2615929,'1','201','1037',478,'Retail Sale Id 1463540',2400.00,0.00,0.00,4.00,248.00,'2022-03-08 15:39:53','',''),(2615930,'1','201','1037',478,'Retail Sale Id 1463541',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 15:40:59','',''),(2615931,'1','201','1037',478,'Retail Sale Id 1463542',2400.00,0.00,0.00,4.00,248.00,'2022-03-08 15:42:42','',''),(2615932,'1','201','1037',478,'Retail Sale Id 1463543',600.00,0.00,0.00,1.00,62.00,'2022-03-08 15:48:44','',''),(2615933,'1','201','1037',478,'Retail Sale Id 1463544',1800.00,0.00,0.00,3.00,186.00,'2022-03-08 15:49:27','',''),(2615934,'1','201','1037',478,'Retail Sale Id 1463545',2502.00,0.00,0.00,4.17,258.54,'2022-03-08 16:07:51','',''),(2615935,'1','201','1037',478,'Return of Retail Sale Id 1463545',0.00,2502.00,4.17,0.00,-258.54,'2022-03-08 16:44:04','',''),(2615936,'1','201','1037',478,'Retail Sale Id 1463546',2202.00,0.00,0.00,3.67,227.54,'2022-03-08 16:44:44','',''),(2615937,'1','201','1037',478,'Retail Sale Id 1463547',534.00,0.00,0.00,0.89,55.18,'2022-03-08 19:21:08','',''),(2615938,'1','201','1037',478,'Retail Sale Id 1463548',5964.00,0.00,0.00,9.94,616.28,'2022-03-08 20:07:14','',''),(2615939,'1','201','1037',478,'Distributed to OPERATIONAL LOSS for sales id:1',926764.18,0.00,0.00,1722.61,0.00,'2022-03-15 12:33:42','',''),(2615940,'1','201','1037',478,'Distributed to OPERATIONAL LOSS for sales id:2',26900.00,0.00,0.00,50.00,0.00,'2022-03-15 12:38:43','',''),(2615941,'1','201',NULL,478,'Purchased from AA RANO NIGERIA LIMITED',0.00,15336720.00,25060.00,0.00,0.00,'2022-03-15 13:01:38','',''),(2615942,'1','201',NULL,478,'Reception corrector for bridging 128794',0.00,0.00,0.00,25060.00,0.00,'2022-03-15 13:06:18','',''),(2615943,'1','201','1037',478,'Received from bridging 128794',0.00,0.00,25060.00,0.00,0.00,'2022-03-15 13:06:18','',''),(2615944,'1','201','1037',478,'Retail Sale Id 1463549',64000.00,0.00,0.00,100.00,2800.00,'2022-03-15 18:58:04','',''),(2615945,'1','201','1037',478,'Retail Sale Id 1463550',14080.00,0.00,0.00,22.00,616.00,'2022-03-15 19:02:25','',''),(2615946,'1','201','1037',478,'Retail Sale Id 1463551',77139.20,0.00,0.00,113.44,7713.92,'2022-03-15 19:04:44','',''),(2615947,'1','201','1037',478,'Retail Sale Id 1463552',4902.80,0.00,0.00,7.21,490.28,'2022-03-15 19:58:35','',''),(2615948,'1','201','1037',478,'Retail Sale Id 1463553',1006.40,0.00,0.00,1.48,100.64,'2022-03-15 20:00:32','',''),(2615949,'1','201','1037',478,'Retail Sale Id 1463554',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 07:57:46','',''),(2615950,'1','201','1037',478,'Retail Sale Id 1463555',3400.00,0.00,0.00,5.00,340.00,'2022-03-16 08:14:08','',''),(2615951,'1','201','1037',478,'Retail Sale Id 1463556',1360.00,0.00,0.00,2.00,136.00,'2022-03-16 08:53:40','',''),(2615952,'1','201','1037',478,'Retail Sale Id 1463557',999.60,0.00,0.00,1.47,99.96,'2022-03-16 09:14:13','',''),(2615953,'1','201','1037',478,'Retail Sale Id 1463558',8500.00,0.00,0.00,12.50,850.00,'2022-03-16 09:29:50','',''),(2615954,'1','201','1037',478,'Retail Sale Id 1463559',32000.00,0.00,0.00,50.00,1400.00,'2022-03-16 09:39:10','',''),(2615955,'1','201','1037',478,'Retail Sale Id 1463560',1999.20,0.00,0.00,2.94,199.92,'2022-03-16 09:42:47','',''),(2615956,'1','201','1037',478,'Retail Sale Id 1463561',8500.00,0.00,0.00,12.50,850.00,'2022-03-16 09:51:41','',''),(2615957,'1','201','1037',478,'Retail Sale Id 1463562',4080.00,0.00,0.00,6.00,408.00,'2022-03-16 10:02:47','',''),(2615958,'1','201','1037',478,'Retail Sale Id 1463563',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 10:41:01','',''),(2615959,'1','201','1037',478,'Retail Sale Id 1463564',1360.00,0.00,0.00,2.00,136.00,'2022-03-16 10:41:49','',''),(2615960,'1','201','1037',478,'Retail Sale Id 1463565',8160.00,0.00,0.00,12.00,816.00,'2022-03-16 10:43:59','',''),(2615961,'1','201','1037',478,'Retail Sale Id 1463566',3400.00,0.00,0.00,5.00,340.00,'2022-03-16 10:44:57','',''),(2615962,'1','201','1037',478,'Retail Sale Id 1463567',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 10:46:07','',''),(2615963,'1','201','1037',478,'Retail Sale Id 1463569',999.60,0.00,0.00,1.47,99.96,'2022-03-16 10:59:47','',''),(2615964,'1','201','1037',478,'Retail Sale Id 1463570',3400.00,0.00,0.00,5.00,340.00,'2022-03-16 11:05:43','',''),(2615965,'1','201','1037',478,'Retail Sale Id 1463571',1502.80,0.00,0.00,2.21,150.28,'2022-03-16 11:09:35','',''),(2615966,'1','201','1037',478,'Retail Sale Id 1463572',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 11:17:24','',''),(2615967,'1','201','1037',478,'Retail Sale Id 1463573',680.00,0.00,0.00,1.00,68.00,'2022-03-16 11:18:47','',''),(2615968,'1','201','1037',478,'Retail Sale Id 1463574',680.00,0.00,0.00,1.00,68.00,'2022-03-16 11:23:44','',''),(2615969,'1','201','1037',478,'Retail Sale Id 1463575',2720.00,0.00,0.00,4.00,272.00,'2022-03-16 11:28:54','',''),(2615970,'1','201','1037',478,'Retail Sale Id 1463576',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 11:31:16','',''),(2615971,'1','201','1037',478,'Retail Sale Id 1463577',2720.00,0.00,0.00,4.00,272.00,'2022-03-16 14:17:35','',''),(2615972,'1','201','1037',478,'Retail Sale Id 1463578',4080.00,0.00,0.00,6.00,408.00,'2022-03-16 14:18:44','',''),(2615973,'1','201','1037',478,'Retail Sale Id 1463579',6120.00,0.00,0.00,9.00,612.00,'2022-03-16 14:19:43','',''),(2615974,'1','201','1037',478,'Retail Sale Id 1463580',1360.00,0.00,0.00,2.00,136.00,'2022-03-16 14:20:28','',''),(2615975,'1','201','1037',478,'Retail Sale Id 1463581',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 14:21:21','',''),(2615976,'1','201','1037',478,'Retail Sale Id 1463582',4080.00,0.00,0.00,6.00,408.00,'2022-03-16 14:22:01','',''),(2615977,'1','201','1037',478,'Retail Sale Id 1463583',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 14:22:44','',''),(2615978,'1','201','1037',478,'Retail Sale Id 1463584',6120.00,0.00,0.00,9.00,612.00,'2022-03-16 14:23:21','',''),(2615979,'1','201','1037',478,'Retail Sale Id 1463585',4080.00,0.00,0.00,6.00,408.00,'2022-03-16 14:24:07','',''),(2615980,'1','201','1037',478,'Retail Sale Id 1463586',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 14:24:50','',''),(2615981,'1','201','1037',478,'Retail Sale Id 1463587',1598.00,0.00,0.00,2.35,159.80,'2022-03-16 14:25:39','',''),(2615982,'1','201','1037',478,'Retail Sale Id 1463588',1360.00,0.00,0.00,2.00,136.00,'2022-03-16 14:31:44','',''),(2615983,'1','201','1037',478,'Retail Sale Id 1463589',2720.00,0.00,0.00,4.00,272.00,'2022-03-16 14:36:56','',''),(2615984,'1','201','1037',478,'Retail Sale Id 1463590',1360.00,0.00,0.00,2.00,136.00,'2022-03-16 14:38:08','',''),(2615985,'1','201','1037',478,'Retail Sale Id 1463591',3400.00,0.00,0.00,5.00,340.00,'2022-03-16 14:41:01','',''),(2615986,'1','201','1037',478,'Retail Sale Id 1463592',3400.00,0.00,0.00,5.00,340.00,'2022-03-16 14:42:15','',''),(2615987,'1','201','1037',478,'Retail Sale Id 1463593',5440.00,0.00,0.00,8.00,544.00,'2022-03-16 14:43:36','',''),(2615988,'1','201','1037',478,'Retail Sale Id 1463594',4080.00,0.00,0.00,6.00,408.00,'2022-03-16 14:46:32','',''),(2615989,'1','201','1037',478,'Retail Sale Id 1463595',1360.00,0.00,0.00,2.00,136.00,'2022-03-16 14:49:26','',''),(2615990,'1','201','1037',478,'Retail Sale Id 1463596',2380.00,0.00,0.00,3.50,238.00,'2022-03-16 14:56:33','',''),(2615991,'1','201','1037',478,'Retail Sale Id 1463597',4080.00,0.00,0.00,6.00,408.00,'2022-03-16 15:04:31','',''),(2615992,'1','201','1037',478,'Retail Sale Id 1463598',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 15:10:30','',''),(2615993,'1','201','1037',478,'Return of Retail Sale Id 1463591',0.00,3400.00,5.00,0.00,-340.00,'2022-03-16 15:10:44','',''),(2615994,'1','201','1037',478,'Retail Sale Id 1463599',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 15:18:40','',''),(2615995,'1','201','1037',478,'Retail Sale Id 1463600',2502.40,0.00,0.00,3.68,250.24,'2022-03-16 15:26:23','',''),(2615996,'1','201','1037',478,'Retail Sale Id 1463601',680.00,0.00,0.00,1.00,68.00,'2022-03-16 16:32:32','',''),(2615997,'1','201','1037',478,'Retail Sale Id 1463602',2998.80,0.00,0.00,4.41,299.88,'2022-03-16 16:33:28','',''),(2615998,'1','201','1037',478,'Retail Sale Id 1463603',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 16:34:20','',''),(2615999,'1','201','1037',478,'Retail Sale Id 1463604',4420.00,0.00,0.00,6.50,442.00,'2022-03-16 16:35:25','',''),(2616000,'1','201','1037',478,'Retail Sale Id 1463605',4080.00,0.00,0.00,6.00,408.00,'2022-03-16 16:36:43','',''),(2616001,'1','201','1037',478,'Retail Sale Id 1463606',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 16:37:26','',''),(2616002,'1','201','1037',478,'Retail Sale Id 1463607',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 16:38:10','',''),(2616003,'1','201','1037',478,'Retail Sale Id 1463608',4998.00,0.00,0.00,7.35,499.80,'2022-03-16 16:38:57','',''),(2616004,'1','201','1037',478,'Retail Sale Id 1463609',3400.00,0.00,0.00,5.00,340.00,'2022-03-16 16:39:48','',''),(2616005,'1','201','1037',478,'Retail Sale Id 1463610',1360.00,0.00,0.00,2.00,136.00,'2022-03-16 16:40:28','',''),(2616006,'1','201','1037',478,'Retail Sale Id 1463611',4760.00,0.00,0.00,7.00,476.00,'2022-03-16 16:41:59','',''),(2616007,'1','201','1037',478,'Retail Sale Id 1463612',1360.00,0.00,0.00,2.00,136.00,'2022-03-16 16:43:45','',''),(2616008,'1','201','1037',478,'Retail Sale Id 1463613',1196.80,0.00,0.00,1.76,119.68,'2022-03-16 16:45:58','',''),(2616009,'1','201','1037',478,'Retail Sale Id 1463614',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 16:52:03','',''),(2616010,'1','201','1037',478,'Retail Sale Id 1463615',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 16:56:20','',''),(2616011,'1','201','1037',478,'Retail Sale Id 1463616',680.00,0.00,0.00,1.00,68.00,'2022-03-16 17:02:18','',''),(2616012,'1','201','1037',478,'Retail Sale Id 1463617',2720.00,0.00,0.00,4.00,272.00,'2022-03-16 17:05:18','',''),(2616013,'1','201','1037',478,'Retail Sale Id 1463618',2720.00,0.00,0.00,4.00,272.00,'2022-03-16 17:06:43','',''),(2616014,'1','201','1037',478,'Retail Sale Id 1463619',999.60,0.00,0.00,1.47,99.96,'2022-03-16 17:14:27','',''),(2616015,'1','201','1037',478,'Retail Sale Id 1463620',6800.00,0.00,0.00,10.00,680.00,'2022-03-16 17:17:48','',''),(2616016,'1','201','1037',478,'Retail Sale Id 1463621',1360.00,0.00,0.00,2.00,136.00,'2022-03-16 17:22:34','',''),(2616017,'1','201','1037',478,'Retail Sale Id 1463622',680.00,0.00,0.00,1.00,68.00,'2022-03-16 18:33:04','',''),(2616018,'1','201','1037',478,'Retail Sale Id 1463623',2040.00,0.00,0.00,3.00,204.00,'2022-03-16 18:33:55','',''),(2616019,'1','201','1037',478,'Retail Sale Id 1463625',6800.00,0.00,0.00,10.00,680.00,'2022-03-17 07:45:30','',''),(2616020,'1','201','1037',478,'Retail Sale Id 1463626',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 08:21:10','',''),(2616021,'1','201','1037',478,'Retail Sale Id 1463627',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 08:30:17','',''),(2616022,'1','201','1037',478,'Retail Sale Id 1463628',1020.00,0.00,0.00,1.50,102.00,'2022-03-17 08:36:59','',''),(2616023,'1','201','1037',478,'Retail Sale Id 1463629',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 08:40:14','',''),(2616024,'1','201','1037',478,'Retail Sale Id 1463630',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 08:41:55','',''),(2616025,'1','201','1037',478,'Retail Sale Id 1463631',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 08:45:40','',''),(2616026,'1','201','1037',478,'Retail Sale Id 1463632',3740.00,0.00,0.00,5.50,374.00,'2022-03-17 08:49:46','',''),(2616027,'1','201','1037',478,'Retail Sale Id 1463633',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 08:51:42','',''),(2616028,'1','201','1037',478,'Retail Sale Id 1463634',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 09:05:09','',''),(2616029,'1','201','1037',478,'Retail Sale Id 1463635',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 09:06:06','',''),(2616030,'1','201','1037',478,'Retail Sale Id 1463636',32000.00,0.00,0.00,50.00,1400.00,'2022-03-17 09:07:18','',''),(2616031,'1','201','1037',478,'Retail Sale Id 1463637',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 09:08:18','',''),(2616032,'1','201','1037',478,'Retail Sale Id 1463638',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 09:12:18','',''),(2616033,'1','201','1037',478,'Retail Sale Id 1463639',1700.00,0.00,0.00,2.50,170.00,'2022-03-17 09:35:08','',''),(2616034,'1','201','1037',478,'Retail Sale Id 1463640',1999.20,0.00,0.00,2.94,199.92,'2022-03-17 09:36:04','',''),(2616035,'1','201','1037',478,'Retail Sale Id 1463641',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 09:55:21','',''),(2616036,'1','201','1037',478,'Retail Sale Id 1463642',7480.00,0.00,0.00,11.00,748.00,'2022-03-17 10:05:51','',''),(2616037,'1','201','1037',478,'Retail Sale Id 1463643',680.00,0.00,0.00,1.00,68.00,'2022-03-17 10:06:54','',''),(2616038,'1','201','1037',478,'Retail Sale Id 1463644',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 10:07:45','',''),(2616039,'1','201','1037',478,'Retail Sale Id 1463645',7040.00,0.00,0.00,11.00,308.00,'2022-03-17 10:10:19','',''),(2616040,'1','201','1037',478,'Retail Sale Id 1463646',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 10:19:23','',''),(2616041,'1','201','1037',478,'Retail Sale Id 1463647',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 10:20:33','',''),(2616042,'1','201','1037',478,'Retail Sale Id 1463648',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 10:23:56','',''),(2616043,'1','201','1037',478,'Retail Sale Id 1463649',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 10:35:33','',''),(2616044,'1','201','1037',478,'Retail Sale Id 1463650',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 10:40:48','',''),(2616045,'1','201','1037',478,'Retail Sale Id 1463651',999.60,0.00,0.00,1.47,99.96,'2022-03-17 10:43:46','',''),(2616046,'1','201','1037',478,'Retail Sale Id 1463652',2720.00,0.00,0.00,4.00,272.00,'2022-03-17 11:00:30','',''),(2616047,'1','201','1037',478,'Retail Sale Id 1463652',2720.00,0.00,0.00,4.00,272.00,'2022-03-17 11:00:30','',''),(2616048,'1','201','1037',478,'Retail Sale Id 1463653',3998.40,0.00,0.00,5.88,399.84,'2022-03-17 11:01:24','',''),(2616049,'1','201','1037',478,'Retail Sale Id 1463654',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 11:02:59','',''),(2616050,'1','201','1037',478,'Retail Sale Id 1463655',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 11:08:36','',''),(2616051,'1','201','1037',478,'Retail Sale Id 1463656',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 11:09:35','',''),(2616052,'1','201','1037',478,'Retail Sale Id 1463657',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 11:12:22','',''),(2616053,'1','201','1037',478,'Retail Sale Id 1463658',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 11:19:33','',''),(2616054,'1','201','1037',478,'Retail Sale Id 1463659',2998.80,0.00,0.00,4.41,299.88,'2022-03-17 11:20:46','',''),(2616055,'1','201','1037',478,'Retail Sale Id 1463660',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 11:31:44','',''),(2616056,'1','201','1037',478,'Retail Sale Id 1463661',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 11:32:52','',''),(2616057,'1','201','1037',478,'Retail Sale Id 1463662',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 11:38:49','',''),(2616058,'1','201','1037',478,'Retail Sale Id 1463663',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 11:50:56','',''),(2616059,'1','201','1037',478,'Retail Sale Id 1463664',1020.00,0.00,0.00,1.50,102.00,'2022-03-17 11:52:38','',''),(2616060,'1','201','1037',478,'Retail Sale Id 1463665',700.40,0.00,0.00,1.03,70.04,'2022-03-17 11:57:09','',''),(2616061,'1','201','1037',478,'Retail Sale Id 1463666',2998.80,0.00,0.00,4.41,299.88,'2022-03-17 12:03:27','',''),(2616062,'1','201','1037',478,'Retail Sale Id 1463667',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 12:09:43','',''),(2616063,'1','201','1037',478,'Retail Sale Id 1463668',8500.00,0.00,0.00,12.50,850.00,'2022-03-17 12:12:59','',''),(2616064,'1','201','1037',478,'Retail Sale Id 1463669',8500.00,0.00,0.00,12.50,850.00,'2022-03-17 12:19:12','',''),(2616065,'1','201','1037',478,'Retail Sale Id 1463670',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 12:27:42','',''),(2616066,'1','201','1037',478,'Retail Sale Id 1463671',680.00,0.00,0.00,1.00,68.00,'2022-03-17 12:39:15','',''),(2616067,'1','201','1037',478,'Retail Sale Id 1463672',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 12:48:04','',''),(2616068,'1','201','1037',478,'Retail Sale Id 1463673',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 12:57:02','',''),(2616069,'1','201','1037',478,'Retail Sale Id 1463674',598.40,0.00,0.00,0.88,59.84,'2022-03-17 13:27:44','',''),(2616070,'1','201','1037',478,'Retail Sale Id 1463675',1999.20,0.00,0.00,2.94,199.92,'2022-03-17 13:33:27','',''),(2616071,'1','201','1037',478,'Retail Sale Id 1463676',999.60,0.00,0.00,1.47,99.96,'2022-03-17 13:34:06','',''),(2616072,'1','201','1037',478,'Retail Sale Id 1463677',999.60,0.00,0.00,1.47,99.96,'2022-03-17 13:34:41','',''),(2616073,'1','201','1037',478,'Retail Sale Id 1463678',34000.00,0.00,0.00,50.00,3400.00,'2022-03-17 13:36:01','',''),(2616074,'1','201','1037',478,'Retail Sale Id 1463679',4760.00,0.00,0.00,7.00,476.00,'2022-03-17 13:39:29','',''),(2616075,'1','201','1037',478,'Retail Sale Id 1463680',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 13:44:01','',''),(2616076,'1','201','1037',478,'Retail Sale Id 1463681',4998.00,0.00,0.00,7.35,499.80,'2022-03-17 14:02:40','',''),(2616077,'1','201','1037',478,'Retail Sale Id 1463682',1502.80,0.00,0.00,2.21,150.28,'2022-03-17 14:11:50','',''),(2616078,'1','201','1037',478,'Retail Sale Id 1463683',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 14:14:01','',''),(2616079,'1','201','1037',478,'Retail Sale Id 1463684',1999.20,0.00,0.00,2.94,199.92,'2022-03-17 14:17:59','',''),(2616080,'1','201','1037',478,'Retail Sale Id 1463685',1999.20,0.00,0.00,2.94,199.92,'2022-03-17 14:21:33','',''),(2616081,'1','201','1037',478,'Retail Sale Id 1463686',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 14:23:41','',''),(2616082,'1','201','1037',478,'Retail Sale Id 1463687',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 14:34:30','',''),(2616083,'1','201','1037',478,'Retail Sale Id 1463688',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 14:45:03','',''),(2616084,'1','201','1037',478,'Retail Sale Id 1463690',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 14:50:11','',''),(2616085,'1','201','1037',478,'Retail Sale Id 1463691',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 14:51:36','',''),(2616086,'1','201','1037',478,'Retail Sale Id 1463692',1999.20,0.00,0.00,2.94,199.92,'2022-03-17 14:53:55','',''),(2616087,'1','201','1037',478,'Retail Sale Id 1463693',2998.80,0.00,0.00,4.41,299.88,'2022-03-17 15:07:56','',''),(2616088,'1','201','1037',478,'Retail Sale Id 1463694',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 15:23:07','',''),(2616089,'1','201','1037',478,'Retail Sale Id 1463695',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 15:27:48','',''),(2616090,'1','201','1037',478,'Retail Sale Id 1463696',2998.80,0.00,0.00,4.41,299.88,'2022-03-17 15:28:36','',''),(2616091,'1','201','1037',478,'Retail Sale Id 1463697',12800.00,0.00,0.00,20.00,560.00,'2022-03-17 15:38:28','',''),(2616092,'1','201','1037',478,'Retail Sale Id 1463698',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 15:39:30','',''),(2616093,'1','201','1037',478,'Retail Sale Id 1463699',2720.00,0.00,0.00,4.00,272.00,'2022-03-17 15:40:19','',''),(2616094,'1','201','1037',478,'Retail Sale Id 1463700',1999.20,0.00,0.00,2.94,199.92,'2022-03-17 15:52:17','',''),(2616095,'1','201','1037',478,'Retail Sale Id 1463701',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 15:53:04','',''),(2616096,'1','201','1037',478,'Retail Sale Id 1463702',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 15:58:26','',''),(2616097,'1','201','1037',478,'Retail Sale Id 1463703',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 16:11:02','',''),(2616098,'1','201','1037',478,'Retail Sale Id 1463704',1700.00,0.00,0.00,2.50,170.00,'2022-03-17 16:14:14','',''),(2616099,'1','201','1037',478,'Retail Sale Id 1463705',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 16:23:08','',''),(2616100,'1','201','1037',478,'Retail Sale Id 1463706',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 16:32:31','',''),(2616101,'1','201','1037',478,'Retail Sale Id 1463707',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 16:42:28','',''),(2616102,'1','201','1037',478,'Retail Sale Id 1463708',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 16:48:54','',''),(2616103,'1','201','1037',478,'Retail Sale Id 1463709',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 16:59:22','',''),(2616104,'1','201','1037',478,'Retail Sale Id 1463710',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 17:23:49','',''),(2616105,'1','201','1037',478,'Retail Sale Id 1463711',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 17:24:34','',''),(2616106,'1','201','1037',478,'Retail Sale Id 1463712',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 17:41:32','',''),(2616107,'1','201','1037',478,'Retail Sale Id 1463713',6800.00,0.00,0.00,10.00,680.00,'2022-03-17 17:56:57','',''),(2616108,'1','201','1037',478,'Retail Sale Id 1463714',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 17:57:42','',''),(2616109,'1','201','1037',478,'Retail Sale Id 1463715',1196.80,0.00,0.00,1.76,119.68,'2022-03-17 18:20:54','',''),(2616110,'1','201','1037',478,'Retail Sale Id 1463716',1196.80,0.00,0.00,1.76,119.68,'2022-03-17 18:21:35','',''),(2616111,'1','201','1037',478,'Retail Sale Id 1463717',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 18:34:56','',''),(2616112,'1','201','1037',478,'Retail Sale Id 1463718',2998.80,0.00,0.00,4.41,299.88,'2022-03-18 08:05:38','',''),(2616113,'1','201','1037',478,'Retail Sale Id 1463719',999.60,0.00,0.00,1.47,99.96,'2022-03-18 08:06:36','',''),(2616114,'1','201','1037',478,'Retail Sale Id 1463720',3060.00,0.00,0.00,4.50,306.00,'2022-03-18 08:11:19','',''),(2616115,'1','201','1037',478,'Retail Sale Id 1463721',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 08:43:08','',''),(2616116,'1','201','1037',478,'Retail Sale Id 1463722',1360.00,0.00,0.00,2.00,136.00,'2022-03-18 08:56:39','',''),(2616117,'1','201','1037',478,'Retail Sale Id 1463723',8500.00,0.00,0.00,12.50,850.00,'2022-03-18 09:05:11','',''),(2616118,'1','201','1037',478,'Retail Sale Id 1463724',8160.00,0.00,0.00,12.00,816.00,'2022-03-18 09:19:54','',''),(2616119,'1','201','1037',478,'Retail Sale Id 1463725',1999.20,0.00,0.00,2.94,199.92,'2022-03-18 09:21:34','',''),(2616120,'1','201','1037',478,'Retail Sale Id 1463726',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 09:22:52','',''),(2616121,'1','201','1037',478,'Retail Sale Id 1463727',2998.80,0.00,0.00,4.41,299.88,'2022-03-18 09:27:42','',''),(2616122,'1','201','1037',478,'Retail Sale Id 1463728',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 09:40:21','',''),(2616123,'1','201','1037',478,'Retail Sale Id 1463728',4420.00,0.00,0.00,6.50,442.00,'2022-03-18 09:40:21','',''),(2616124,'1','201','1037',478,'Retail Sale Id 1463729',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 09:42:17','',''),(2616125,'1','201','1037',478,'Retail Sale Id 1463730',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 09:44:17','',''),(2616126,'1','201','1037',478,'Retail Sale Id 1463731',7996.80,0.00,0.00,11.76,799.68,'2022-03-18 09:56:28','',''),(2616127,'1','201','1037',478,'Retail Sale Id 1463732',1360.00,0.00,0.00,2.00,136.00,'2022-03-18 09:59:55','',''),(2616128,'1','201','1037',478,'Retail Sale Id 1463734',1360.00,0.00,0.00,2.00,136.00,'2022-03-18 11:00:06','',''),(2616129,'1','201','1037',478,'Retail Sale Id 1463735',3400.00,0.00,0.00,5.00,340.00,'2022-03-18 11:04:14','',''),(2616130,'1','201','1037',478,'Retail Sale Id 1463736',1802.00,0.00,0.00,2.65,180.20,'2022-03-18 11:05:13','',''),(2616131,'1','201','1037',478,'Retail Sale Id 1463737',6800.00,0.00,0.00,10.00,680.00,'2022-03-18 11:49:50','',''),(2616132,'1','201','1037',478,'Retail Sale Id 1463738',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 12:23:01','',''),(2616133,'1','201','1037',478,'Retail Sale Id 1463739',680.00,0.00,0.00,1.00,68.00,'2022-03-18 12:27:29','',''),(2616134,'1','201','1037',478,'Retail Sale Id 1463740',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 12:28:12','',''),(2616135,'1','201','1037',478,'Retail Sale Id 1463741',1999.20,0.00,0.00,2.94,199.92,'2022-03-18 12:29:28','',''),(2616136,'1','201','1037',478,'Retail Sale Id 1463742',8500.00,0.00,0.00,12.50,850.00,'2022-03-18 12:32:14','',''),(2616137,'1','201','1037',478,'Retail Sale Id 1463742',8500.00,0.00,0.00,12.50,850.00,'2022-03-18 12:32:14','',''),(2616138,'1','201','1037',478,'Retail Sale Id 1463743',1360.00,0.00,0.00,2.00,136.00,'2022-03-18 12:39:44','',''),(2616139,'1','201','1037',478,'Retail Sale Id 1463744',1360.00,0.00,0.00,2.00,136.00,'2022-03-18 12:58:18','',''),(2616140,'1','201','1037',478,'Retail Sale Id 1463745',680.00,0.00,0.00,1.00,68.00,'2022-03-18 13:00:52','',''),(2616141,'1','201','1037',478,'Retail Sale Id 1463746',1360.00,0.00,0.00,2.00,136.00,'2022-03-18 13:52:47','',''),(2616142,'1','201','1037',478,'Retail Sale Id 1463747',550.80,0.00,0.00,0.81,55.08,'2022-03-18 14:45:14','',''),(2616143,'1','201','1037',478,'Retail Sale Id 1463748',2720.00,0.00,0.00,4.00,272.00,'2022-03-18 14:49:39','',''),(2616144,'1','201','1037',478,'Retail Sale Id 1463748',4760.00,0.00,0.00,7.00,476.00,'2022-03-18 14:49:39','',''),(2616145,'1','201','1037',478,'Retail Sale Id 1463748',8500.00,0.00,0.00,12.50,850.00,'2022-03-18 14:49:39','',''),(2616146,'1','201','1037',478,'Retail Sale Id 1463749',2720.00,0.00,0.00,4.00,272.00,'2022-03-18 14:51:28','',''),(2616147,'1','201','1037',478,'Retail Sale Id 1463750',3400.00,0.00,0.00,5.00,340.00,'2022-03-18 14:57:14','',''),(2616148,'1','201','1037',478,'Retail Sale Id 1463751',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 15:19:37','',''),(2616149,'1','201','1037',478,'Retail Sale Id 1463752',30720.00,0.00,0.00,48.00,1344.00,'2022-03-18 15:42:07','',''),(2616150,'1','201','1037',478,'Retail Sale Id 1463753',12800.00,0.00,0.00,20.00,560.00,'2022-03-18 15:43:35','',''),(2616151,'1','201','1037',478,'Retail Sale Id 1463754',2720.00,0.00,0.00,4.00,272.00,'2022-03-18 15:45:15','',''),(2616152,'1','201','1037',478,'Retail Sale Id 1463755',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 16:09:40','',''),(2616153,'1','201','1037',478,'Retail Sale Id 1463756',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 16:36:48','',''),(2616154,'1','201','1037',478,'Retail Sale Id 1463757',1360.00,0.00,0.00,2.00,136.00,'2022-03-18 16:37:47','',''),(2616155,'1','201','1037',478,'Retail Sale Id 1463758',1360.00,0.00,0.00,2.00,136.00,'2022-03-18 16:38:27','',''),(2616156,'1','201','1037',478,'Retail Sale Id 1463759',1360.00,0.00,0.00,2.00,136.00,'2022-03-18 16:39:07','',''),(2616157,'1','201','1037',478,'Retail Sale Id 1463760',1502.80,0.00,0.00,2.21,150.28,'2022-03-18 16:52:54','',''),(2616158,'1','201','1037',478,'Retail Sale Id 1463761',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 17:13:43','',''),(2616159,'1','201','1037',478,'Retail Sale Id 1463762',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 17:14:23','',''),(2616160,'1','201','1037',478,'Retail Sale Id 1463763',6800.00,0.00,0.00,10.00,680.00,'2022-03-18 17:16:31','',''),(2616161,'1','201','1037',478,'Retail Sale Id 1463764',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 17:19:41','',''),(2616162,'1','201','1037',478,'Retail Sale Id 1463765',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 17:23:20','',''),(2616163,'1','201','1037',478,'Retail Sale Id 1463766',3400.00,0.00,0.00,5.00,340.00,'2022-03-18 17:24:40','',''),(2616164,'1','201','1037',478,'Retail Sale Id 1463767',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 17:34:29','',''),(2616165,'1','201','1037',478,'Retail Sale Id 1463768',680.00,0.00,0.00,1.00,68.00,'2022-03-18 17:42:34','',''),(2616166,'1','201','1037',478,'Retail Sale Id 1463769',7996.80,0.00,0.00,11.76,799.68,'2022-03-18 17:43:27','',''),(2616167,'1','201','1037',478,'Retail Sale Id 1463770',1700.00,0.00,0.00,2.50,170.00,'2022-03-18 17:48:31','',''),(2616168,'1','201','1037',478,'Retail Sale Id 1463771',1999.20,0.00,0.00,2.94,199.92,'2022-03-18 17:49:55','',''),(2616169,'1','201','1037',478,'Retail Sale Id 1463772',3400.00,0.00,0.00,5.00,340.00,'2022-03-18 17:54:50','',''),(2616170,'1','201','1037',478,'Retail Sale Id 1463773',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 18:26:55','',''),(2616171,'1','201','1037',478,'Retail Sale Id 1463774',1931.20,0.00,0.00,2.84,193.12,'2022-03-18 19:22:27','',''),(2616172,'1','201','1037',478,'Retail Sale Id 1463775',136.00,0.00,0.00,0.20,13.60,'2022-03-18 19:24:19','',''),(2616173,'1','201','1037',478,'Return of Retail Sale Id 1463775',0.00,136.00,0.20,0.00,-13.60,'2022-03-18 19:25:22','',''),(2616174,'1','201','1037',478,'Return of Retail Sale Id 1463774',0.00,1931.20,2.84,0.00,-193.12,'2022-03-18 19:25:51','',''),(2616175,'1','201','1037',478,'Retail Sale Id 1463776',1944.80,0.00,0.00,2.86,194.48,'2022-03-18 19:27:26','',''),(2616176,'1','201','1037',478,'Retail Sale Id 1463777',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 07:47:54','',''),(2616177,'1','201','1037',478,'Retail Sale Id 1463778',32000.00,0.00,0.00,50.00,1400.00,'2022-03-19 07:57:40','',''),(2616178,'1','201','1037',478,'Retail Sale Id 1463779',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 09:05:04','',''),(2616179,'1','201','1037',478,'Retail Sale Id 1463780',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 09:12:47','',''),(2616180,'1','201','1037',478,'Retail Sale Id 1463781',2699.60,0.00,0.00,3.97,269.96,'2022-03-19 09:16:08','',''),(2616181,'1','201','1037',478,'Retail Sale Id 1463782',1700.00,0.00,0.00,2.50,170.00,'2022-03-19 09:20:52','',''),(2616182,'1','201','1037',478,'Retail Sale Id 1463783',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 09:25:00','',''),(2616183,'1','201','1037',478,'Retail Sale Id 1463784',9600.00,0.00,0.00,15.00,420.00,'2022-03-19 09:36:23','',''),(2616184,'1','201','1037',478,'Retail Sale Id 1463785',1802.00,0.00,0.00,2.65,180.20,'2022-03-19 09:37:36','',''),(2616185,'1','201','1037',478,'Retail Sale Id 1463786',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 09:49:21','',''),(2616186,'1','201','1037',478,'Retail Sale Id 1463787',6400.00,0.00,0.00,10.00,280.00,'2022-03-19 09:56:55','',''),(2616187,'1','201','1037',478,'Retail Sale Id 1463788',2720.00,0.00,0.00,4.00,272.00,'2022-03-19 09:59:22','',''),(2616188,'1','201','1037',478,'Retail Sale Id 1463789',3400.00,0.00,0.00,5.00,340.00,'2022-03-19 10:04:00','',''),(2616189,'1','201','1037',478,'Retail Sale Id 1463790',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 10:22:21','',''),(2616190,'1','201','1037',478,'Retail Sale Id 1463791',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 10:34:08','',''),(2616191,'1','201','1037',478,'Retail Sale Id 1463792',8500.00,0.00,0.00,12.50,850.00,'2022-03-19 10:35:56','',''),(2616192,'1','201','1037',478,'Retail Sale Id 1463793',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 10:38:42','',''),(2616193,'1','201','1037',478,'Retail Sale Id 1463794',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 10:40:32','',''),(2616194,'1','201','1037',478,'Retail Sale Id 1463795',999.60,0.00,0.00,1.47,99.96,'2022-03-19 10:41:50','',''),(2616195,'1','201','1037',478,'Retail Sale Id 1463796',2720.00,0.00,0.00,4.00,272.00,'2022-03-19 11:20:41','',''),(2616196,'1','201','1037',478,'Retail Sale Id 1463797',1897.20,0.00,0.00,2.79,189.72,'2022-03-19 11:28:50','',''),(2616197,'1','201','1037',478,'Retail Sale Id 1463798',1700.00,0.00,0.00,2.50,170.00,'2022-03-19 11:42:59','',''),(2616198,'1','201','1037',478,'Retail Sale Id 1463799',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 11:53:06','',''),(2616199,'1','201','1037',478,'Retail Sale Id 1463800',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 12:01:27','',''),(2616200,'1','201','1037',478,'Retail Sale Id 1463800',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 12:01:27','',''),(2616201,'1','201','1037',478,'Retail Sale Id 1463801',3998.40,0.00,0.00,5.88,399.84,'2022-03-19 12:20:37','',''),(2616202,'1','201','1037',478,'Retail Sale Id 1463802',2720.00,0.00,0.00,4.00,272.00,'2022-03-19 12:22:09','',''),(2616203,'1','201','1037',478,'Retail Sale Id 1463803',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 12:22:56','',''),(2616204,'1','201','1037',478,'Retail Sale Id 1463804',2502.40,0.00,0.00,3.68,250.24,'2022-03-19 12:23:49','',''),(2616205,'1','201','1037',478,'Retail Sale Id 1463805',2380.00,0.00,0.00,3.50,238.00,'2022-03-19 12:29:01','',''),(2616206,'1','201','1037',478,'Retail Sale Id 1463806',2720.00,0.00,0.00,4.00,272.00,'2022-03-19 12:29:49','',''),(2616207,'1','201','1037',478,'Retail Sale Id 1463807',680.00,0.00,0.00,1.00,68.00,'2022-03-19 12:31:09','',''),(2616208,'1','201','1037',478,'Retail Sale Id 1463808',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 12:43:33','',''),(2616209,'1','201','1037',478,'Retail Sale Id 1463809',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 12:45:57','',''),(2616210,'1','201','1037',478,'Retail Sale Id 1463810',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 12:54:24','',''),(2616211,'1','201','1037',478,'Retail Sale Id 1463811',8500.00,0.00,0.00,12.50,850.00,'2022-03-19 13:01:39','',''),(2616212,'1','201','1037',478,'Retail Sale Id 1463812',6120.00,0.00,0.00,9.00,612.00,'2022-03-19 13:08:18','',''),(2616213,'1','201','1037',478,'Return of Retail Sale Id 1463812',0.00,6120.00,9.00,0.00,-612.00,'2022-03-19 13:20:54','',''),(2616214,'1','201','1037',478,'Retail Sale Id 1463813',5365.20,0.00,0.00,7.89,536.52,'2022-03-19 13:22:11','',''),(2616215,'1','201','1037',478,'Retail Sale Id 1463814',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 13:43:21','',''),(2616216,'1','201','1037',478,'Retail Sale Id 1463815',1999.20,0.00,0.00,2.94,199.92,'2022-03-19 14:24:34','',''),(2616217,'1','201','1037',478,'Retail Sale Id 1463816',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 14:37:24','',''),(2616218,'1','201','1037',478,'Retail Sale Id 1463817',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 14:47:32','',''),(2616219,'1','201','1037',478,'Retail Sale Id 1463818',2720.00,0.00,0.00,4.00,272.00,'2022-03-19 14:53:03','',''),(2616220,'1','201','1037',478,'Retail Sale Id 1463819',1700.00,0.00,0.00,2.50,170.00,'2022-03-19 14:54:32','',''),(2616221,'1','201','1037',478,'Retail Sale Id 1463820',3400.00,0.00,0.00,5.00,340.00,'2022-03-19 14:55:11','',''),(2616222,'1','201','1037',478,'Retail Sale Id 1463821',2720.00,0.00,0.00,4.00,272.00,'2022-03-19 15:03:05','',''),(2616223,'1','201','1037',478,'Retail Sale Id 1463822',8160.00,0.00,0.00,12.00,816.00,'2022-03-19 15:19:37','',''),(2616224,'1','201','1037',478,'Retail Sale Id 1463823',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 15:24:11','',''),(2616225,'1','201','1037',478,'Retail Sale Id 1463824',8500.00,0.00,0.00,12.50,850.00,'2022-03-19 15:27:14','',''),(2616226,'1','201','1037',478,'Retail Sale Id 1463825',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 15:35:18','',''),(2616227,'1','201','1037',478,'Retail Sale Id 1463826',999.60,0.00,0.00,1.47,99.96,'2022-03-19 15:36:25','',''),(2616228,'1','201','1037',478,'Retail Sale Id 1463827',6997.20,0.00,0.00,10.29,699.72,'2022-03-19 15:37:29','',''),(2616229,'1','201','1037',478,'Retail Sale Id 1463828',2720.00,0.00,0.00,4.00,272.00,'2022-03-19 15:41:16','',''),(2616230,'1','201','1037',478,'Retail Sale Id 1463829',8500.00,0.00,0.00,12.50,850.00,'2022-03-19 15:42:37','',''),(2616231,'1','201','1037',478,'Retail Sale Id 1463830',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 15:47:14','',''),(2616232,'1','201','1037',478,'Retail Sale Id 1463831',3400.00,0.00,0.00,5.00,340.00,'2022-03-19 16:12:27','',''),(2616233,'1','201','1037',478,'Retail Sale Id 1463832',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 16:14:12','',''),(2616234,'1','201','1037',478,'Retail Sale Id 1463833',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 16:20:55','',''),(2616235,'1','201','1037',478,'Retail Sale Id 1463834',1999.20,0.00,0.00,2.94,199.92,'2022-03-19 16:25:23','',''),(2616236,'1','201','1037',478,'Retail Sale Id 1463835',1278.40,0.00,0.00,1.88,127.84,'2022-03-19 16:36:54','',''),(2616237,'1','201','1037',478,'Return of Retail Sale Id 1463832',0.00,1360.00,2.00,0.00,-136.00,'2022-03-19 16:41:33','',''),(2616238,'1','201','1037',478,'Retail Sale Id 1463837',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 16:46:23','',''),(2616239,'1','201','1037',478,'Retail Sale Id 1463837',2380.00,0.00,0.00,3.50,238.00,'2022-03-19 16:46:23','',''),(2616240,'1','201','1037',478,'Retail Sale Id 1463838',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 16:47:05','',''),(2616241,'1','201','1037',478,'Retail Sale Id 1463839',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 16:47:45','',''),(2616242,'1','201','1037',478,'Retail Sale Id 1463840',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 16:48:39','',''),(2616243,'1','201','1037',478,'Retail Sale Id 1463841',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 16:49:24','',''),(2616244,'1','201','1037',478,'Retail Sale Id 1463842',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 16:53:39','',''),(2616245,'1','201','1037',478,'Retail Sale Id 1463843',1502.80,0.00,0.00,2.21,150.28,'2022-03-19 17:03:53','',''),(2616246,'1','201','1037',478,'Retail Sale Id 1463844',7680.00,0.00,0.00,12.00,336.00,'2022-03-19 17:07:23','',''),(2616247,'1','201','1037',478,'Retail Sale Id 1463845',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 17:08:11','',''),(2616248,'1','201','1037',478,'Retail Sale Id 1463846',680.00,0.00,0.00,1.00,68.00,'2022-03-19 17:10:52','',''),(2616249,'1','201','1037',478,'Retail Sale Id 1463847',4760.00,0.00,0.00,7.00,476.00,'2022-03-19 17:16:22','',''),(2616250,'1','201','1037',478,'Retail Sale Id 1463848',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 17:17:30','',''),(2616251,'1','201','1037',478,'Retail Sale Id 1463849',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 17:22:27','',''),(2616252,'1','201','1037',478,'Retail Sale Id 1463850',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 17:23:26','',''),(2616253,'1','201','1037',478,'Retail Sale Id 1463851',680.00,0.00,0.00,1.00,68.00,'2022-03-19 17:25:01','',''),(2616254,'1','201','1037',478,'Retail Sale Id 1463851',680.00,0.00,0.00,1.00,68.00,'2022-03-19 17:25:01','',''),(2616255,'1','201','1037',478,'Retail Sale Id 1463852',3502.00,0.00,0.00,5.15,350.20,'2022-03-19 17:29:35','',''),(2616256,'1','201','1037',478,'Retail Sale Id 1463853',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 17:35:40','',''),(2616257,'1','201','1037',478,'Retail Sale Id 1463855',1700.00,0.00,0.00,2.50,170.00,'2022-03-19 17:44:15','',''),(2616258,'1','201','1037',478,'Retail Sale Id 1463856',1999.20,0.00,0.00,2.94,199.92,'2022-03-19 17:44:57','',''),(2616259,'1','201','1037',478,'Retail Sale Id 1463857',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 17:45:36','',''),(2616260,'1','201','1037',478,'Retail Sale Id 1463858',1502.80,0.00,0.00,2.21,150.28,'2022-03-19 17:52:26','',''),(2616261,'1','201','1037',478,'Retail Sale Id 1463859',2502.40,0.00,0.00,3.68,250.24,'2022-03-19 17:59:49','',''),(2616262,'1','201','1037',478,'Retail Sale Id 1463860',680.00,0.00,0.00,1.00,68.00,'2022-03-19 18:08:46','',''),(2616263,'1','201','1037',478,'Retail Sale Id 1463861',1196.80,0.00,0.00,1.76,119.68,'2022-03-19 18:19:42','',''),(2616264,'1','201','1037',478,'Retail Sale Id 1463862',1802.00,0.00,0.00,2.65,180.20,'2022-03-19 18:24:32','',''),(2616265,'1','201','1037',478,'Retail Sale Id 1463863',238.00,0.00,0.00,0.35,23.80,'2022-03-19 18:25:48','',''),(2616266,'1','201','1037',478,'Retail Sale Id 1463864',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 18:26:35','',''),(2616267,'1','201','1037',478,'Retail Sale Id 1463865',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 18:27:42','',''),(2616268,'1','201','1037',478,'Return of Retail Sale Id 1463864',0.00,2040.00,3.00,0.00,-204.00,'2022-03-19 18:52:36','',''),(2616269,'1','201','1037',478,'Retail Sale Id 1463866',1251.20,0.00,0.00,1.84,125.12,'2022-03-19 18:53:16','',''),(2616270,'1','201','1037',478,'Retail Sale Id 1463867',2720.00,0.00,0.00,4.00,272.00,'2022-03-20 07:29:57','',''),(2616271,'1','201','1037',478,'Retail Sale Id 1463868',3400.00,0.00,0.00,5.00,340.00,'2022-03-20 07:36:48','',''),(2616272,'1','201','1037',478,'Retail Sale Id 1463869',1700.00,0.00,0.00,2.50,170.00,'2022-03-20 07:49:11','',''),(2616273,'1','201','1037',478,'Retail Sale Id 1463870',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 07:55:01','',''),(2616274,'1','201','1037',478,'Retail Sale Id 1463871',32000.00,0.00,0.00,50.00,1400.00,'2022-03-20 08:08:33','',''),(2616275,'1','201','1037',478,'Retail Sale Id 1463872',2720.00,0.00,0.00,4.00,272.00,'2022-03-20 08:14:57','',''),(2616276,'1','201','1037',478,'Retail Sale Id 1463873',680.00,0.00,0.00,1.00,68.00,'2022-03-20 08:29:18','',''),(2616277,'1','201','1037',478,'Retail Sale Id 1463874',217.60,0.00,0.00,0.32,21.76,'2022-03-20 08:30:14','',''),(2616278,'1','201','1037',478,'Retail Sale Id 1463875',2998.80,0.00,0.00,4.41,299.88,'2022-03-20 08:37:24','',''),(2616279,'1','201','1037',478,'Retail Sale Id 1463876',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 08:48:10','',''),(2616280,'1','201','1037',478,'Retail Sale Id 1463877',6800.00,0.00,0.00,10.00,680.00,'2022-03-20 08:53:03','',''),(2616281,'1','201','1037',478,'Retail Sale Id 1463877',6800.00,0.00,0.00,10.00,680.00,'2022-03-20 08:53:03','',''),(2616282,'1','201','1037',478,'Retail Sale Id 1463878',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 08:59:33','',''),(2616283,'1','201','1037',478,'Retail Sale Id 1463879',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 09:03:47','',''),(2616284,'1','201','1037',478,'Retail Sale Id 1463880',3400.00,0.00,0.00,5.00,340.00,'2022-03-20 09:15:39','',''),(2616285,'1','201','1037',478,'Retail Sale Id 1463881',4080.00,0.00,0.00,6.00,408.00,'2022-03-20 09:30:46','',''),(2616286,'1','201','1037',478,'Retail Sale Id 1463882',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 09:48:36','',''),(2616287,'1','201','1037',478,'Retail Sale Id 1463883',1020.00,0.00,0.00,1.50,102.00,'2022-03-20 09:58:55','',''),(2616288,'1','201','1037',478,'Retail Sale Id 1463884',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 10:04:57','',''),(2616289,'1','201','1037',478,'Retail Sale Id 1463885',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 10:07:12','',''),(2616290,'1','201','1037',478,'Retail Sale Id 1463887',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 10:23:25','',''),(2616291,'1','201','1037',478,'Retail Sale Id 1463888',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 10:24:04','',''),(2616292,'1','201','1037',478,'Retail Sale Id 1463889',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 10:25:13','',''),(2616293,'1','201','1037',478,'Retail Sale Id 1463890',4080.00,0.00,0.00,6.00,408.00,'2022-03-20 10:33:05','',''),(2616294,'1','201','1037',478,'Retail Sale Id 1463891',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 10:56:25','',''),(2616295,'1','201','1037',478,'Retail Sale Id 1463892',3400.00,0.00,0.00,5.00,340.00,'2022-03-20 11:00:56','',''),(2616296,'1','201','1037',478,'Retail Sale Id 1463893',4080.00,0.00,0.00,6.00,408.00,'2022-03-20 11:21:08','',''),(2616297,'1','201','1037',478,'Retail Sale Id 1463894',7480.00,0.00,0.00,11.00,748.00,'2022-03-20 11:26:55','',''),(2616298,'1','201','1037',478,'Retail Sale Id 1463894',7480.00,0.00,0.00,11.00,748.00,'2022-03-20 11:26:55','',''),(2616299,'1','201','1037',478,'Retail Sale Id 1463895',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 11:38:46','',''),(2616300,'1','201','1037',478,'Retail Sale Id 1463896',1502.80,0.00,0.00,2.21,150.28,'2022-03-20 11:49:36','',''),(2616301,'1','201','1037',478,'Retail Sale Id 1463897',6997.20,0.00,0.00,10.29,699.72,'2022-03-20 11:55:46','',''),(2616302,'1','201','1037',478,'Retail Sale Id 1463898',1999.20,0.00,0.00,2.94,199.92,'2022-03-20 11:57:04','',''),(2616303,'1','201','1037',478,'Retail Sale Id 1463899',680.00,0.00,0.00,1.00,68.00,'2022-03-20 12:02:58','',''),(2616304,'1','201','1037',478,'Retail Sale Id 1463900',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 12:03:39','',''),(2616305,'1','201','1037',478,'Retail Sale Id 1463901',4080.00,0.00,0.00,6.00,408.00,'2022-03-20 12:11:52','',''),(2616306,'1','201','1037',478,'Retail Sale Id 1463902',680.00,0.00,0.00,1.00,68.00,'2022-03-20 12:20:02','',''),(2616307,'1','201','1037',478,'Retail Sale Id 1463903',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 12:23:55','',''),(2616308,'1','201','1037',478,'Retail Sale Id 1463904',999.60,0.00,0.00,1.47,99.96,'2022-03-20 13:08:28','',''),(2616309,'1','201','1037',478,'Retail Sale Id 1463905',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 13:34:46','',''),(2616310,'1','201','1037',478,'Retail Sale Id 1463906',680.00,0.00,0.00,1.00,68.00,'2022-03-20 13:46:51','',''),(2616311,'1','201','1037',478,'Retail Sale Id 1463907',8500.00,0.00,0.00,12.50,850.00,'2022-03-20 14:09:02','',''),(2616312,'1','201','1037',478,'Retail Sale Id 1463908',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 14:10:51','',''),(2616313,'1','201','1037',478,'Retail Sale Id 1463909',7500.40,0.00,0.00,11.03,750.04,'2022-03-20 14:23:46','',''),(2616314,'1','201','1037',478,'Retail Sale Id 1463910',4080.00,0.00,0.00,6.00,408.00,'2022-03-20 14:25:51','',''),(2616315,'1','201','1037',478,'Retail Sale Id 1463911',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 14:28:13','',''),(2616316,'1','201','1037',478,'Retail Sale Id 1463913',3400.00,0.00,0.00,5.00,340.00,'2022-03-20 14:49:47','',''),(2616317,'1','201','1037',478,'Retail Sale Id 1463915',680.00,0.00,0.00,1.00,68.00,'2022-03-20 15:02:15','',''),(2616318,'1','201','1037',478,'Retail Sale Id 1463916',3400.00,0.00,0.00,5.00,340.00,'2022-03-20 15:09:11','',''),(2616319,'1','201','1037',478,'Retail Sale Id 1463917',4080.00,0.00,0.00,6.00,408.00,'2022-03-20 15:19:29','',''),(2616320,'1','201','1037',478,'Retail Sale Id 1463918',4998.00,0.00,0.00,7.35,499.80,'2022-03-20 15:20:13','',''),(2616321,'1','201','1037',478,'Retail Sale Id 1463919',8500.00,0.00,0.00,12.50,850.00,'2022-03-20 15:21:03','',''),(2616322,'1','201','1037',478,'Retail Sale Id 1463920',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 15:22:03','',''),(2616323,'1','201','1037',478,'Retail Sale Id 1463921',1196.80,0.00,0.00,1.76,119.68,'2022-03-20 15:22:52','',''),(2616324,'1','201','1037',478,'Retail Sale Id 1463922',8160.00,0.00,0.00,12.00,816.00,'2022-03-20 15:55:28','',''),(2616325,'1','201','1037',478,'Retail Sale Id 1463923',3202.80,0.00,0.00,4.71,320.28,'2022-03-20 15:56:59','',''),(2616326,'1','201','1037',478,'Retail Sale Id 1463925',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 16:25:56','',''),(2616327,'1','201','1037',478,'Retail Sale Id 1463926',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 16:26:58','',''),(2616328,'1','201','1037',478,'Retail Sale Id 1463927',340.00,0.00,0.00,0.50,34.00,'2022-03-20 16:33:51','',''),(2616329,'1','201','1037',478,'Retail Sale Id 1463928',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 16:35:02','',''),(2616330,'1','201','1037',478,'Retail Sale Id 1463929',2720.00,0.00,0.00,4.00,272.00,'2022-03-20 16:41:21','',''),(2616331,'1','201','1037',478,'Retail Sale Id 1463930',4420.00,0.00,0.00,6.50,442.00,'2022-03-20 16:47:30','',''),(2616332,'1','201','1037',478,'Retail Sale Id 1463931',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 16:49:40','',''),(2616333,'1','201','1037',478,'Retail Sale Id 1463932',2998.80,0.00,0.00,4.41,299.88,'2022-03-20 16:56:28','',''),(2616334,'1','201','1037',478,'Return of Retail Sale Id 1463930',0.00,4420.00,6.50,0.00,-442.00,'2022-03-20 17:01:37','',''),(2616335,'1','201','1037',478,'Retail Sale Id 1463933',4250.00,0.00,0.00,6.25,425.00,'2022-03-20 17:03:35','',''),(2616336,'1','201','1037',478,'Retail Sale Id 1463934',5440.00,0.00,0.00,8.00,544.00,'2022-03-20 17:16:02','',''),(2616337,'1','201','1037',478,'Retail Sale Id 1463935',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 17:18:16','',''),(2616338,'1','201','1037',478,'Retail Sale Id 1463936',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 17:19:47','',''),(2616339,'1','201','1037',478,'Retail Sale Id 1463937',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 17:20:48','',''),(2616340,'1','201','1037',478,'Retail Sale Id 1463938',999.60,0.00,0.00,1.47,99.96,'2022-03-20 17:24:18','',''),(2616341,'1','201','1037',478,'Retail Sale Id 1463939',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 17:26:12','',''),(2616342,'1','201','1037',478,'Retail Sale Id 1463940',8500.00,0.00,0.00,12.50,850.00,'2022-03-20 17:27:52','',''),(2616343,'1','201','1037',478,'Retail Sale Id 1463941',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 17:41:37','',''),(2616344,'1','201','1037',478,'Retail Sale Id 1463942',999.60,0.00,0.00,1.47,99.96,'2022-03-20 17:42:42','',''),(2616345,'1','201','1037',478,'Retail Sale Id 1463943',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 17:49:17','',''),(2616346,'1','201','1037',478,'Retail Sale Id 1463944',5501.20,0.00,0.00,8.09,550.12,'2022-03-20 17:51:00','',''),(2616347,'1','201','1037',478,'Retail Sale Id 1463945',802.40,0.00,0.00,1.18,80.24,'2022-03-20 18:03:13','',''),(2616348,'1','201','1037',478,'Retail Sale Id 1463946',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 18:05:26','',''),(2616349,'1','201','1037',478,'Retail Sale Id 1463946',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 18:05:26','',''),(2616350,'1','201','1037',478,'Return of Retail Sale Id 1463942',0.00,999.60,1.47,0.00,-99.96,'2022-03-20 19:10:28','',''),(2616351,'1','201','1037',478,'Retail Sale Id 1463947',503.20,0.00,0.00,0.74,50.32,'2022-03-20 19:11:08','',''),(2616352,'1','201','1037',478,'Retail Sale Id 1463948',3400.00,0.00,0.00,5.00,340.00,'2022-03-21 07:52:40','',''),(2616353,'1','201','1037',478,'Retail Sale Id 1463950',7378.00,0.00,0.00,10.85,737.80,'2022-03-21 07:57:44','',''),(2616354,'1','201','1037',478,'Retail Sale Id 1463952',2720.00,0.00,0.00,4.00,272.00,'2022-03-21 07:59:47','',''),(2616355,'1','201','1037',478,'Retail Sale Id 1463953',1020.00,0.00,0.00,1.50,102.00,'2022-03-21 08:08:25','',''),(2616356,'1','201','1037',478,'Retail Sale Id 1463954',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 08:09:31','',''),(2616357,'1','201','1037',478,'Retail Sale Id 1463955',2380.00,0.00,0.00,3.50,238.00,'2022-03-21 08:11:08','',''),(2616358,'1','201','1037',478,'Retail Sale Id 1463956',9600.00,0.00,0.00,15.00,420.00,'2022-03-21 08:26:06','',''),(2616359,'1','201','1037',478,'Retail Sale Id 1463957',1360.00,0.00,0.00,2.00,136.00,'2022-03-21 08:30:32','',''),(2616360,'1','201','1037',478,'Retail Sale Id 1463958',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 08:46:01','',''),(2616361,'1','201','1037',478,'Retail Sale Id 1463959',3400.00,0.00,0.00,5.00,340.00,'2022-03-21 08:47:22','',''),(2616362,'1','201','1037',478,'Retail Sale Id 1463960',4998.00,0.00,0.00,7.35,499.80,'2022-03-21 08:50:11','',''),(2616363,'1','201','1037',478,'Retail Sale Id 1463961',8500.00,0.00,0.00,12.50,850.00,'2022-03-21 09:12:26','',''),(2616364,'1','201','1037',478,'Retail Sale Id 1463962',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 09:37:31','',''),(2616365,'1','201','1037',478,'Retail Sale Id 1463963',680.00,0.00,0.00,1.00,68.00,'2022-03-21 09:38:36','',''),(2616366,'1','201','1037',478,'Retail Sale Id 1463964',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 09:45:18','',''),(2616367,'1','201','1037',478,'Retail Sale Id 1463965',2502.40,0.00,0.00,3.68,250.24,'2022-03-21 09:46:32','',''),(2616368,'1','201','1037',478,'Retail Sale Id 1463966',3998.40,0.00,0.00,5.88,399.84,'2022-03-21 09:51:28','',''),(2616369,'1','201','1037',478,'Retail Sale Id 1463967',3400.00,0.00,0.00,5.00,340.00,'2022-03-21 10:18:02','',''),(2616370,'1','201','1037',478,'Retail Sale Id 1463968',1360.00,0.00,0.00,2.00,136.00,'2022-03-21 10:23:14','',''),(2616371,'1','201','1037',478,'Retail Sale Id 1463969',1700.00,0.00,0.00,2.50,170.00,'2022-03-21 10:33:25','',''),(2616372,'1','201','1037',478,'Retail Sale Id 1463970',3400.00,0.00,0.00,5.00,340.00,'2022-03-21 10:36:54','',''),(2616373,'1','201','1037',478,'Retail Sale Id 1463971',3400.00,0.00,0.00,5.00,340.00,'2022-03-21 10:37:36','',''),(2616374,'1','201','1037',478,'Retail Sale Id 1463972',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 10:41:18','',''),(2616375,'1','201','1037',478,'Retail Sale Id 1463973',999.60,0.00,0.00,1.47,99.96,'2022-03-21 10:42:43','',''),(2616376,'1','201','1037',478,'Retail Sale Id 1463974',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 11:15:14','',''),(2616377,'1','201','1037',478,'Retail Sale Id 1463974',7480.00,0.00,0.00,11.00,748.00,'2022-03-21 11:15:14','',''),(2616378,'1','201','1037',478,'Retail Sale Id 1463975',2720.00,0.00,0.00,4.00,272.00,'2022-03-21 11:16:51','',''),(2616379,'1','201','1037',478,'Retail Sale Id 1463976',680.00,0.00,0.00,1.00,68.00,'2022-03-21 11:27:55','',''),(2616380,'1','201','1037',478,'Retail Sale Id 1463977',1400.80,0.00,0.00,2.06,140.08,'2022-03-21 12:06:40','',''),(2616381,'1','201','1037',478,'Retail Sale Id 1463978',8500.00,0.00,0.00,12.50,850.00,'2022-03-21 12:18:51','',''),(2616382,'1','201','1037',478,'Retail Sale Id 1463979',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 12:28:21','',''),(2616383,'1','201','1037',478,'Retail Sale Id 1463980',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 12:29:56','',''),(2616384,'1','201','1037',478,'Retail Sale Id 1463981',1502.80,0.00,0.00,2.21,150.28,'2022-03-21 12:32:57','',''),(2616385,'1','201','1037',478,'Retail Sale Id 1463982',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 12:39:39','',''),(2616386,'1','201','1037',478,'Retail Sale Id 1463983',2998.80,0.00,0.00,4.41,299.88,'2022-03-21 12:40:42','',''),(2616387,'1','201','1037',478,'Retail Sale Id 1463984',4760.00,0.00,0.00,7.00,476.00,'2022-03-21 12:43:16','',''),(2616388,'1','201','1037',478,'Retail Sale Id 1463985',2998.80,0.00,0.00,4.41,299.88,'2022-03-21 12:49:20','',''),(2616389,'1','201','1037',478,'Retail Sale Id 1463986',3400.00,0.00,0.00,5.00,340.00,'2022-03-21 13:02:00','',''),(2616390,'1','201','1037',478,'Retail Sale Id 1463986',3400.00,0.00,0.00,5.00,340.00,'2022-03-21 13:02:00','',''),(2616391,'1','201','1037',478,'Retail Sale Id 1463987',2998.80,0.00,0.00,4.41,299.88,'2022-03-21 13:26:10','',''),(2616392,'1','201','1037',478,'Retail Sale Id 1463988',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 13:32:51','',''),(2616393,'1','201','1037',478,'Retail Sale Id 1463989',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 13:41:06','',''),(2616394,'1','201','1037',478,'Retail Sale Id 1463990',8500.00,0.00,0.00,12.50,850.00,'2022-03-21 13:45:45','',''),(2616395,'1','201','1037',478,'Retail Sale Id 1463991',12800.00,0.00,0.00,20.00,560.00,'2022-03-21 14:05:52','',''),(2616396,'1','201','1037',478,'Retail Sale Id 1463992',3502.00,0.00,0.00,5.15,350.20,'2022-03-21 14:09:03','',''),(2616397,'1','201','1037',478,'Retail Sale Id 1463993',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 14:10:49','',''),(2616398,'1','201','1037',478,'Retail Sale Id 1463994',3400.00,0.00,0.00,5.00,340.00,'2022-03-21 14:23:41','',''),(2616399,'1','201','1037',478,'Retail Sale Id 1463995',1360.00,0.00,0.00,2.00,136.00,'2022-03-21 14:33:05','',''),(2616400,'1','201','1037',478,'Retail Sale Id 1463996',1502.80,0.00,0.00,2.21,150.28,'2022-03-21 14:54:56','',''),(2616401,'1','201','1037',478,'Retail Sale Id 1463997',1360.00,0.00,0.00,2.00,136.00,'2022-03-21 14:56:06','',''),(2616402,'1','201','1037',478,'Retail Sale Id 1463998',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 15:08:05','',''),(2616403,'1','201','1037',478,'Retail Sale Id 1463999',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 15:18:03','',''),(2616404,'1','201','1037',478,'Retail Sale Id 1464000',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 15:23:24','',''),(2616405,'1','201','1037',478,'Retail Sale Id 1464001',6800.00,0.00,0.00,10.00,680.00,'2022-03-21 15:24:49','',''),(2616406,'1','201','1037',478,'Retail Sale Id 1464002',8500.00,0.00,0.00,12.50,850.00,'2022-03-21 15:30:37','',''),(2616407,'1','201','1037',478,'Retail Sale Id 1464003',64000.00,0.00,0.00,100.00,2800.00,'2022-03-21 15:31:57','',''),(2616408,'1','201','1037',478,'Retail Sale Id 1464004',51200.00,0.00,0.00,80.00,2240.00,'2022-03-21 15:32:41','',''),(2616409,'1','201','1037',478,'Retail Sale Id 1464005',2720.00,0.00,0.00,4.00,272.00,'2022-03-21 15:41:59','',''),(2616410,'1','201','1037',478,'Retail Sale Id 1464006',1999.20,0.00,0.00,2.94,199.92,'2022-03-21 15:49:00','',''),(2616411,'1','201','1037',478,'Retail Sale Id 1464007',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 16:23:20','',''),(2616412,'1','201','1037',478,'Retail Sale Id 1464008',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 16:41:04','',''),(2616413,'1','201','1037',478,'Retail Sale Id 1464009',1360.00,0.00,0.00,2.00,136.00,'2022-03-21 16:50:21','',''),(2616414,'1','201','1037',478,'Retail Sale Id 1464010',680.00,0.00,0.00,1.00,68.00,'2022-03-21 16:58:11','',''),(2616415,'1','201','1037',478,'Retail Sale Id 1464011',1360.00,0.00,0.00,2.00,136.00,'2022-03-21 17:00:33','',''),(2616416,'1','201','1037',478,'Retail Sale Id 1464012',8160.00,0.00,0.00,12.00,816.00,'2022-03-21 17:03:25','',''),(2616417,'1','201','1037',478,'Retail Sale Id 1464013',8500.00,0.00,0.00,12.50,850.00,'2022-03-21 17:11:58','',''),(2616418,'1','201','1037',478,'Retail Sale Id 1464014',1999.20,0.00,0.00,2.94,199.92,'2022-03-21 17:35:02','',''),(2616419,'1','201','1037',478,'Retail Sale Id 1464015',1196.80,0.00,0.00,1.76,119.68,'2022-03-21 17:36:15','',''),(2616420,'1','201','1037',478,'Retail Sale Id 1464015',1502.80,0.00,0.00,2.21,150.28,'2022-03-21 17:36:15','',''),(2616421,'1','201','1037',478,'Retail Sale Id 1464016',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 17:37:03','',''),(2616422,'1','201','1037',478,'Retail Sale Id 1464017',2502.40,0.00,0.00,3.68,250.24,'2022-03-21 17:37:50','',''),(2616423,'1','201','1037',478,'Retail Sale Id 1464018',1360.00,0.00,0.00,2.00,136.00,'2022-03-21 17:54:45','',''),(2616424,'1','201','1037',478,'Retail Sale Id 1464019',1196.80,0.00,0.00,1.76,119.68,'2022-03-21 18:01:09','',''),(2616425,'1','201','1037',478,'Retail Sale Id 1464020',1360.00,0.00,0.00,2.00,136.00,'2022-03-21 18:04:02','',''),(2616426,'1','201','1037',478,'Retail Sale Id 1464021',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 18:13:27','',''),(2616427,'1','201','1037',478,'Retail Sale Id 1464022',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 18:16:12','',''),(2616428,'1','201','1037',478,'Retail Sale Id 1464023',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 18:25:04','',''),(2616429,'1','201','1037',478,'Return of Retail Sale Id 1464016',0.00,4080.00,6.00,0.00,-408.00,'2022-03-21 19:37:21','',''),(2616430,'1','201','1037',478,'Retail Sale Id 1464024',1142.40,0.00,0.00,1.68,114.24,'2022-03-21 19:37:59','',''),(2616431,'1','201','1037',478,'Retail Sale Id 1464025',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 07:56:27','',''),(2616432,'1','201','1037',478,'Retail Sale Id 1464026',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 07:58:19','',''),(2616433,'1','201','1037',478,'Retail Sale Id 1464027',3400.00,0.00,0.00,5.00,340.00,'2022-03-22 08:09:06','',''),(2616434,'1','201','1037',478,'Retail Sale Id 1464028',2720.00,0.00,0.00,4.00,272.00,'2022-03-22 08:12:50','',''),(2616435,'1','201','1037',478,'Retail Sale Id 1464029',1999.20,0.00,0.00,2.94,199.92,'2022-03-22 08:22:34','',''),(2616436,'1','201','1037',478,'Retail Sale Id 1464030',8500.00,0.00,0.00,12.50,850.00,'2022-03-22 08:38:03','',''),(2616437,'1','201','1037',478,'Retail Sale Id 1464031',4760.00,0.00,0.00,7.00,476.00,'2022-03-22 08:39:25','',''),(2616438,'1','201','1037',478,'Retail Sale Id 1464032',8500.00,0.00,0.00,12.50,850.00,'2022-03-22 08:40:08','',''),(2616439,'1','201','1037',478,'Retail Sale Id 1464033',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 09:24:33','',''),(2616440,'1','201','1037',478,'Retail Sale Id 1464034',2720.00,0.00,0.00,4.00,272.00,'2022-03-22 09:37:12','',''),(2616441,'1','201','1037',478,'Retail Sale Id 1464035',999.60,0.00,0.00,1.47,99.96,'2022-03-22 09:41:39','',''),(2616442,'1','201','1037',478,'Retail Sale Id 1464036',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 09:46:33','',''),(2616443,'1','201','1037',478,'Retail Sale Id 1464037',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 09:50:26','',''),(2616444,'1','201','1037',478,'Retail Sale Id 1464038',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 10:00:22','',''),(2616445,'1','201','1037',478,'Retail Sale Id 1464039',3060.00,0.00,0.00,4.50,306.00,'2022-03-22 10:06:43','',''),(2616446,'1','201','1037',478,'Retail Sale Id 1464040',16000.00,0.00,0.00,25.00,700.00,'2022-03-22 10:24:25','',''),(2616447,'1','201','1037',478,'Retail Sale Id 1464041',1502.80,0.00,0.00,2.21,150.28,'2022-03-22 10:26:04','',''),(2616448,'1','201','1037',478,'Retail Sale Id 1464042',999.60,0.00,0.00,1.47,99.96,'2022-03-22 10:35:54','',''),(2616449,'1','201','1037',478,'Retail Sale Id 1464043',6997.20,0.00,0.00,10.29,699.72,'2022-03-22 10:39:02','',''),(2616450,'1','201','1037',478,'Retail Sale Id 1464045',8000.00,0.00,0.00,12.50,350.00,'2022-03-22 10:58:57','',''),(2616451,'1','201','1037',478,'Retail Sale Id 1464046',3400.00,0.00,0.00,5.00,340.00,'2022-03-22 11:09:45','',''),(2616452,'1','201','1037',478,'Retail Sale Id 1464047',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 11:11:26','',''),(2616453,'1','201','1037',478,'Retail Sale Id 1464048',7680.00,0.00,0.00,12.00,336.00,'2022-03-22 11:19:12','',''),(2616454,'1','201','1037',478,'Retail Sale Id 1464049',680.00,0.00,0.00,1.00,68.00,'2022-03-22 11:38:48','',''),(2616455,'1','201','1037',478,'Retail Sale Id 1464050',1360.00,0.00,0.00,2.00,136.00,'2022-03-22 11:40:52','',''),(2616456,'1','201','1037',478,'Retail Sale Id 1464051',680.00,0.00,0.00,1.00,68.00,'2022-03-22 11:49:47','',''),(2616457,'1','201','1037',478,'Retail Sale Id 1464052',7996.80,0.00,0.00,11.76,799.68,'2022-03-22 11:57:06','',''),(2616458,'1','201','1037',478,'Retail Sale Id 1464053',999.60,0.00,0.00,1.47,99.96,'2022-03-22 11:58:22','',''),(2616459,'1','201','1037',478,'Retail Sale Id 1464056',2720.00,0.00,0.00,4.00,272.00,'2022-03-22 12:03:12','',''),(2616460,'1','201','1037',478,'Retail Sale Id 1464057',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 12:04:11','',''),(2616461,'1','201','1037',478,'Retail Sale Id 1464058',3502.00,0.00,0.00,5.15,350.20,'2022-03-22 12:14:40','',''),(2616462,'1','201','1037',478,'Retail Sale Id 1464059',1360.00,0.00,0.00,2.00,136.00,'2022-03-22 12:17:41','',''),(2616463,'1','201','1037',478,'Retail Sale Id 1464060',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 12:19:40','',''),(2616464,'1','201','1037',478,'Retail Sale Id 1464061',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 12:20:58','',''),(2616465,'1','201','1037',478,'Retail Sale Id 1464062',1802.00,0.00,0.00,2.65,180.20,'2022-03-22 12:24:02','',''),(2616466,'1','201','1037',478,'Retail Sale Id 1464063',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 12:24:46','',''),(2616467,'1','201','1037',478,'Retail Sale Id 1464064',3400.00,0.00,0.00,5.00,340.00,'2022-03-22 12:25:52','',''),(2616468,'1','201','1037',478,'Retail Sale Id 1464065',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 12:35:13','',''),(2616469,'1','201','1037',478,'Retail Sale Id 1464066',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 12:44:40','',''),(2616470,'1','201','1037',478,'Retail Sale Id 1464067',999.60,0.00,0.00,1.47,99.96,'2022-03-22 13:12:18','',''),(2616471,'1','201','1037',478,'Retail Sale Id 1464068',1360.00,0.00,0.00,2.00,136.00,'2022-03-22 13:20:24','',''),(2616472,'1','201','1037',478,'Retail Sale Id 1464069',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 13:21:25','',''),(2616473,'1','201','1037',478,'Retail Sale Id 1464070',32000.00,0.00,0.00,50.00,1400.00,'2022-03-22 13:24:26','',''),(2616474,'1','201','1037',478,'Retail Sale Id 1464071',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 13:37:58','',''),(2616475,'1','201','1037',478,'Retail Sale Id 1464072',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 13:44:17','',''),(2616476,'1','201','1037',478,'Retail Sale Id 1464073',8500.00,0.00,0.00,12.50,850.00,'2022-03-22 13:55:37','',''),(2616477,'1','201','1037',478,'Retail Sale Id 1464074',1999.20,0.00,0.00,2.94,199.92,'2022-03-22 13:58:19','',''),(2616478,'1','201','1037',478,'Retail Sale Id 1464075',1196.80,0.00,0.00,1.76,119.68,'2022-03-22 14:10:34','',''),(2616479,'1','201','1037',478,'Retail Sale Id 1464076',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 14:14:06','',''),(2616480,'1','201','1037',478,'Retail Sale Id 1464077',3903.20,0.00,0.00,5.74,390.32,'2022-03-22 14:28:58','',''),(2616481,'1','201','1037',478,'Retail Sale Id 1464078',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 14:41:29','',''),(2616482,'1','201','1037',478,'Retail Sale Id 1464079',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 14:47:43','',''),(2616483,'1','201','1037',478,'Retail Sale Id 1464080',8500.00,0.00,0.00,12.50,850.00,'2022-03-22 14:50:06','',''),(2616484,'1','201','1037',478,'Retail Sale Id 1464081',802.40,0.00,0.00,1.18,80.24,'2022-03-22 15:04:18','',''),(2616485,'1','201','1037',478,'Retail Sale Id 1464082',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 15:06:21','',''),(2616486,'1','201','1037',478,'Retail Sale Id 1464083',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 15:07:47','',''),(2616487,'1','201','1037',478,'Retail Sale Id 1464084',1360.00,0.00,0.00,2.00,136.00,'2022-03-22 16:01:18','',''),(2616488,'1','201','1037',478,'Retail Sale Id 1464085',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 16:09:47','',''),(2616489,'1','201','1037',478,'Retail Sale Id 1464086',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 16:23:58','',''),(2616490,'1','201','1037',478,'Retail Sale Id 1464087',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 16:37:13','',''),(2616491,'1','201','1037',478,'Retail Sale Id 1464088',8500.00,0.00,0.00,12.50,850.00,'2022-03-22 16:39:11','',''),(2616492,'1','201','1037',478,'Retail Sale Id 1464088',8500.00,0.00,0.00,12.50,850.00,'2022-03-22 16:39:11','',''),(2616493,'1','201','1037',478,'Retail Sale Id 1464089',3400.00,0.00,0.00,5.00,340.00,'2022-03-22 16:43:56','',''),(2616494,'1','201','1037',478,'Retail Sale Id 1464090',1999.20,0.00,0.00,2.94,199.92,'2022-03-22 16:46:11','',''),(2616495,'1','201','1037',478,'Retail Sale Id 1464091',3400.00,0.00,0.00,5.00,340.00,'2022-03-22 16:55:52','',''),(2616496,'1','201','1037',478,'Retail Sale Id 1464092',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 16:58:41','',''),(2616497,'1','201','1037',478,'Retail Sale Id 1464093',1999.20,0.00,0.00,2.94,199.92,'2022-03-22 16:59:25','',''),(2616498,'1','201','1037',478,'Retail Sale Id 1464094',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 17:00:39','',''),(2616499,'1','201','1037',478,'Retail Sale Id 1464095',3502.00,0.00,0.00,5.15,350.20,'2022-03-22 17:05:14','',''),(2616500,'1','201','1037',478,'Retail Sale Id 1464096',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 17:06:10','',''),(2616501,'1','201','1037',478,'Retail Sale Id 1464098',1360.00,0.00,0.00,2.00,136.00,'2022-03-22 17:09:24','',''),(2616502,'1','201','1037',478,'Retail Sale Id 1464099',680.00,0.00,0.00,1.00,68.00,'2022-03-22 17:10:31','',''),(2616503,'1','201','1037',478,'Retail Sale Id 1464100',6800.00,0.00,0.00,10.00,680.00,'2022-03-22 17:11:14','',''),(2616504,'1','201','1037',478,'Retail Sale Id 1464101',2720.00,0.00,0.00,4.00,272.00,'2022-03-22 17:16:05','',''),(2616505,'1','201','1037',478,'Retail Sale Id 1464102',1360.00,0.00,0.00,2.00,136.00,'2022-03-22 17:18:25','',''),(2616506,'1','201','1037',478,'Retail Sale Id 1464103',3200.00,0.00,0.00,5.00,140.00,'2022-03-22 17:28:00','',''),(2616507,'1','201','1037',478,'Retail Sale Id 1464104',2998.80,0.00,0.00,4.41,299.88,'2022-03-22 17:30:10','',''),(2616508,'1','201','1037',478,'Retail Sale Id 1464105',401.20,0.00,0.00,0.59,40.12,'2022-03-22 17:31:17','',''),(2616509,'1','201','1037',478,'Retail Sale Id 1464106',999.60,0.00,0.00,1.47,99.96,'2022-03-22 17:32:27','',''),(2616510,'1','201','1037',478,'Retail Sale Id 1464107',680.00,0.00,0.00,1.00,68.00,'2022-03-22 17:50:41','',''),(2616511,'1','201','1037',478,'Retail Sale Id 1464108',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 18:01:36','',''),(2616512,'1','201','1037',478,'Retail Sale Id 1464109',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 18:10:24','',''),(2616513,'1','201','1037',478,'Retail Sale Id 1464109',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 18:10:24','',''),(2616514,'1','201','1037',478,'Retail Sale Id 1464110',680.00,0.00,0.00,1.00,68.00,'2022-03-22 18:25:47','',''),(2616515,'1','201','1037',478,'Retail Sale Id 1464111',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 18:38:57','',''),(2616516,'1','201','1037',478,'Return of Retail Sale Id 1464104',0.00,2998.80,4.41,0.00,-299.88,'2022-03-22 19:31:13','',''),(2616517,'1','201','1037',478,'Retail Sale Id 1464112',1700.00,0.00,0.00,2.50,170.00,'2022-03-22 19:31:47','',''),(2616518,'1','201','1037',478,'Return of Retail Sale Id 1464106',0.00,999.60,1.47,0.00,-99.96,'2022-03-22 19:34:44','',''),(2616519,'1','201','1037',478,'Retail Sale Id 1464113',1550.40,0.00,0.00,2.28,155.04,'2022-03-22 19:36:13','',''),(2616520,'1','201','1037',478,'Retail Sale Id 1464114',6800.00,0.00,0.00,10.00,680.00,'2022-03-23 08:11:56','',''),(2616521,'1','201','1037',478,'Retail Sale Id 1464115',8500.00,0.00,0.00,12.50,850.00,'2022-03-23 08:12:40','',''),(2616522,'1','201','1037',478,'Retail Sale Id 1464116',8500.00,0.00,0.00,12.50,850.00,'2022-03-23 08:13:21','',''),(2616523,'1','201','1037',478,'Retail Sale Id 1464117',3400.00,0.00,0.00,5.00,340.00,'2022-03-23 08:32:11','',''),(2616524,'1','201','1037',478,'Retail Sale Id 1464118',7500.80,0.00,0.00,11.72,328.16,'2022-03-23 09:01:33','',''),(2616525,'1','201','1037',478,'Retail Sale Id 1464119',1502.80,0.00,0.00,2.21,150.28,'2022-03-23 09:02:30','',''),(2616526,'1','201','1037',478,'Retail Sale Id 1464120',4760.00,0.00,0.00,7.00,476.00,'2022-03-23 09:04:48','',''),(2616527,'1','201','1037',478,'Retail Sale Id 1464121',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 09:11:05','',''),(2616528,'1','201','1037',478,'Retail Sale Id 1464123',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 09:18:16','',''),(2616529,'1','201','1037',478,'Retail Sale Id 1464124',897.60,0.00,0.00,1.32,89.76,'2022-03-23 09:30:33','',''),(2616530,'1','201','1037',478,'Retail Sale Id 1464125',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 09:48:44','',''),(2616531,'1','201','1037',478,'Retail Sale Id 1464126',2502.40,0.00,0.00,3.68,250.24,'2022-03-23 09:59:46','',''),(2616532,'1','201','1037',478,'Retail Sale Id 1464127',2998.80,0.00,0.00,4.41,299.88,'2022-03-23 10:08:01','',''),(2616533,'1','201','1037',478,'Retail Sale Id 1464128',2720.00,0.00,0.00,4.00,272.00,'2022-03-23 10:10:58','',''),(2616534,'1','201','1037',478,'Retail Sale Id 1464129',9600.00,0.00,0.00,15.00,420.00,'2022-03-23 10:12:01','',''),(2616535,'1','201','1037',478,'Retail Sale Id 1464130',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 10:14:44','',''),(2616536,'1','201','1037',478,'Retail Sale Id 1464130',6120.00,0.00,0.00,9.00,612.00,'2022-03-23 10:14:44','',''),(2616537,'1','201','1037',478,'Retail Sale Id 1464132',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 10:22:43','',''),(2616538,'1','201','1037',478,'Retail Sale Id 1464133',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 10:35:28','',''),(2616539,'1','201','1037',478,'Retail Sale Id 1464134',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 10:37:28','',''),(2616540,'1','201','1037',478,'Retail Sale Id 1464135',1700.00,0.00,0.00,2.50,170.00,'2022-03-23 10:47:35','',''),(2616541,'1','201','1037',478,'Retail Sale Id 1464136',4080.00,0.00,0.00,6.00,408.00,'2022-03-23 10:50:13','',''),(2616542,'1','201','1037',478,'Retail Sale Id 1464137',2998.80,0.00,0.00,4.41,299.88,'2022-03-23 11:05:21','',''),(2616543,'1','201','1037',478,'Retail Sale Id 1464138',8500.00,0.00,0.00,12.50,850.00,'2022-03-23 11:07:54','',''),(2616544,'1','201','1037',478,'Retail Sale Id 1464139',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 11:09:40','',''),(2616545,'1','201','1037',478,'Retail Sale Id 1464140',680.00,0.00,0.00,1.00,68.00,'2022-03-23 11:17:37','',''),(2616546,'1','201','1037',478,'Retail Sale Id 1464141',4080.00,0.00,0.00,6.00,408.00,'2022-03-23 11:19:59','',''),(2616547,'1','201','1037',478,'Retail Sale Id 1464142',680.00,0.00,0.00,1.00,68.00,'2022-03-23 11:23:43','',''),(2616548,'1','201','1037',478,'Retail Sale Id 1464143',2502.40,0.00,0.00,3.68,250.24,'2022-03-23 11:29:11','',''),(2616549,'1','201','1037',478,'Retail Sale Id 1464144',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 11:35:17','',''),(2616550,'1','201','1037',478,'Retail Sale Id 1464144',2720.00,0.00,0.00,4.00,272.00,'2022-03-23 11:35:17','',''),(2616551,'1','201','1037',478,'Retail Sale Id 1464145',680.00,0.00,0.00,1.00,68.00,'2022-03-23 11:35:59','',''),(2616552,'1','201','1037',478,'Retail Sale Id 1464146',1999.20,0.00,0.00,2.94,199.92,'2022-03-23 11:36:54','',''),(2616553,'1','201','1037',478,'Retail Sale Id 1464147',4760.00,0.00,0.00,7.00,476.00,'2022-03-23 12:00:09','',''),(2616554,'1','201','1037',478,'Retail Sale Id 1464147',17000.00,0.00,0.00,25.00,1700.00,'2022-03-23 12:00:09','',''),(2616555,'1','201','1037',478,'Retail Sale Id 1464148',1020.00,0.00,0.00,1.50,102.00,'2022-03-23 12:02:35','',''),(2616556,'1','201','1037',478,'Retail Sale Id 1464148',1020.00,0.00,0.00,1.50,102.00,'2022-03-23 12:02:35','',''),(2616557,'1','201','1037',478,'Retail Sale Id 1464149',1700.00,0.00,0.00,2.50,170.00,'2022-03-23 12:10:16','',''),(2616558,'1','201','1037',478,'Retail Sale Id 1464150',2998.80,0.00,0.00,4.41,299.88,'2022-03-23 12:28:53','',''),(2616559,'1','201','1037',478,'Retail Sale Id 1464151',2998.80,0.00,0.00,4.41,299.88,'2022-03-23 12:31:05','',''),(2616560,'1','201','1037',478,'Retail Sale Id 1464152',7996.80,0.00,0.00,11.76,799.68,'2022-03-23 12:52:42','',''),(2616561,'1','201','1037',478,'Retail Sale Id 1464153',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 12:57:35','',''),(2616562,'1','201','1037',478,'Retail Sale Id 1464154',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 14:06:25','',''),(2616563,'1','201','1037',478,'Return of Retail Sale Id 1464147',0.00,4760.00,7.00,0.00,-476.00,'2022-03-23 14:07:46','',''),(2616564,'1','201','1037',478,'Return of Retail Sale Id 1464147',0.00,17000.00,25.00,0.00,-1700.00,'2022-03-23 14:07:46','',''),(2616565,'1','201','1037',478,'Retail Sale Id 1464155',20978.00,0.00,0.00,30.85,2097.80,'2022-03-23 14:15:35','',''),(2616566,'1','201','1037',478,'Retail Sale Id 1464156',4998.00,0.00,0.00,7.35,499.80,'2022-03-23 14:21:03','',''),(2616567,'1','201','1037',478,'Retail Sale Id 1464157',680.00,0.00,0.00,1.00,68.00,'2022-03-23 14:24:59','',''),(2616568,'1','201','1037',478,'Retail Sale Id 1464158',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 14:39:07','',''),(2616569,'1','201','1037',478,'Retail Sale Id 1464159',4080.00,0.00,0.00,6.00,408.00,'2022-03-23 14:50:11','',''),(2616570,'1','201','1037',478,'Retail Sale Id 1464160',1999.20,0.00,0.00,2.94,199.92,'2022-03-23 15:00:12','',''),(2616571,'1','201','1037',478,'Retail Sale Id 1464161',3400.00,0.00,0.00,5.00,340.00,'2022-03-23 15:06:45','',''),(2616572,'1','201','1037',478,'Retail Sale Id 1464161',4080.00,0.00,0.00,6.00,408.00,'2022-03-23 15:06:45','',''),(2616573,'1','201','1037',478,'Retail Sale Id 1464162',4080.00,0.00,0.00,6.00,408.00,'2022-03-23 15:08:32','',''),(2616574,'1','201','1037',478,'Retail Sale Id 1464163',680.00,0.00,0.00,1.00,68.00,'2022-03-23 15:10:50','',''),(2616575,'1','201','1037',478,'Retail Sale Id 1464164',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 15:25:19','',''),(2616576,'1','201','1037',478,'Retail Sale Id 1464165',8500.00,0.00,0.00,12.50,850.00,'2022-03-23 15:30:05','',''),(2616577,'1','201','1037',478,'Retail Sale Id 1464167',4080.00,0.00,0.00,6.00,408.00,'2022-03-23 15:54:48','',''),(2616578,'1','201','1037',478,'Retail Sale Id 1464168',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 16:09:39','',''),(2616579,'1','201','1037',478,'Retail Sale Id 1464169',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 16:10:35','',''),(2616580,'1','201','1037',478,'Retail Sale Id 1464171',2720.00,0.00,0.00,4.00,272.00,'2022-03-23 16:20:53','',''),(2616581,'1','201','1037',478,'Retail Sale Id 1464172',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 16:24:38','',''),(2616582,'1','201','1037',478,'Retail Sale Id 1464173',8500.00,0.00,0.00,12.50,850.00,'2022-03-23 16:25:39','',''),(2616583,'1','201','1037',478,'Retail Sale Id 1464174',8500.00,0.00,0.00,12.50,850.00,'2022-03-23 16:45:33','',''),(2616584,'1','201','1037',478,'Retail Sale Id 1464175',1999.20,0.00,0.00,2.94,199.92,'2022-03-23 16:51:21','',''),(2616585,'1','201','1037',478,'Retail Sale Id 1464176',1598.00,0.00,0.00,2.35,159.80,'2022-03-23 16:58:54','',''),(2616586,'1','201','1037',478,'Retail Sale Id 1464177',4760.00,0.00,0.00,7.00,476.00,'2022-03-23 17:02:18','',''),(2616587,'1','201','1037',478,'Retail Sale Id 1464178',3400.00,0.00,0.00,5.00,340.00,'2022-03-23 17:03:45','',''),(2616588,'1','201','1037',478,'Retail Sale Id 1464179',680.00,0.00,0.00,1.00,68.00,'2022-03-23 17:11:10','',''),(2616589,'1','201','1037',478,'Retail Sale Id 1464179',680.00,0.00,0.00,1.00,68.00,'2022-03-23 17:11:10','',''),(2616590,'1','201','1037',478,'Retail Sale Id 1464180',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 17:15:55','',''),(2616591,'1','201','1037',478,'Retail Sale Id 1464181',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 17:22:48','',''),(2616592,'1','201','1037',478,'Retail Sale Id 1464182',680.00,0.00,0.00,1.00,68.00,'2022-03-23 17:24:49','',''),(2616593,'1','201','1037',478,'Retail Sale Id 1464183',3400.00,0.00,0.00,5.00,340.00,'2022-03-23 17:29:16','',''),(2616594,'1','201','1037',478,'Retail Sale Id 1464184',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 17:33:43','',''),(2616595,'1','201','1037',478,'Retail Sale Id 1464185',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 17:40:21','',''),(2616596,'1','201','1037',478,'Retail Sale Id 1464186',680.00,0.00,0.00,1.00,68.00,'2022-03-23 18:02:54','',''),(2616597,'1','201','1037',478,'Retail Sale Id 1464187',680.00,0.00,0.00,1.00,68.00,'2022-03-23 18:08:13','',''),(2616598,'1','201','1037',478,'Retail Sale Id 1464188',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 18:09:17','',''),(2616599,'1','201','1037',478,'Retail Sale Id 1464189',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 18:10:36','',''),(2616600,'1','201','1037',478,'Retail Sale Id 1464190',2502.40,0.00,0.00,3.68,250.24,'2022-03-23 18:30:01','',''),(2616601,'1','201','1037',478,'Return of Retail Sale Id 1464183',0.00,3400.00,5.00,0.00,-340.00,'2022-03-23 19:21:34','',''),(2616602,'1','201','1037',478,'Retail Sale Id 1464191',2740.40,0.00,0.00,4.03,274.04,'2022-03-23 19:22:26','',''),(2616603,'1','201','1037',478,'Return of Retail Sale Id 1464182',0.00,680.00,1.00,0.00,-68.00,'2022-03-23 19:24:54','',''),(2616604,'1','201','1037',478,'Retail Sale Id 1464192',367.20,0.00,0.00,0.54,36.72,'2022-03-23 19:25:30','',''),(2616605,'1','201','1037',478,'Retail Sale Id 1464193',2502.40,0.00,0.00,3.68,250.24,'2022-03-24 07:58:31','',''),(2616606,'1','201','1037',478,'Retail Sale Id 1464194',4420.00,0.00,0.00,6.50,442.00,'2022-03-24 08:09:43','',''),(2616607,'1','201','1037',478,'Retail Sale Id 1464195',1360.00,0.00,0.00,2.00,136.00,'2022-03-24 08:14:53','',''),(2616608,'1','201','1037',478,'Retail Sale Id 1464196',7680.00,0.00,0.00,12.00,336.00,'2022-03-24 08:19:21','',''),(2616609,'1','201','1037',478,'Retail Sale Id 1464197',4760.00,0.00,0.00,7.00,476.00,'2022-03-24 08:26:40','',''),(2616610,'1','201','1037',478,'Retail Sale Id 1464198',1360.00,0.00,0.00,2.00,136.00,'2022-03-24 09:04:13','',''),(2616611,'1','201','1037',478,'Retail Sale Id 1464199',8500.00,0.00,0.00,12.50,850.00,'2022-03-24 09:20:49','',''),(2616612,'1','201','1037',478,'Retail Sale Id 1464200',2502.40,0.00,0.00,3.68,250.24,'2022-03-24 09:23:00','',''),(2616613,'1','201','1037',478,'Retail Sale Id 1464201',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 09:47:29','',''),(2616614,'1','201','1037',478,'Retail Sale Id 1464202',4760.00,0.00,0.00,7.00,476.00,'2022-03-24 09:59:22','',''),(2616615,'1','201','1037',478,'Retail Sale Id 1464202',4760.00,0.00,0.00,7.00,476.00,'2022-03-24 09:59:22','',''),(2616616,'1','201','1037',478,'Retail Sale Id 1464202',4760.00,0.00,0.00,7.00,476.00,'2022-03-24 09:59:22','',''),(2616617,'1','201','1037',478,'Retail Sale Id 1464203',1360.00,0.00,0.00,2.00,136.00,'2022-03-24 10:01:21','',''),(2616618,'1','201','1037',478,'Retail Sale Id 1464204',3400.00,0.00,0.00,5.00,340.00,'2022-03-24 10:02:10','',''),(2616619,'1','201','1037',478,'Retail Sale Id 1464205',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 10:13:38','',''),(2616620,'1','201','1037',478,'Retail Sale Id 1464206',1360.00,0.00,0.00,2.00,136.00,'2022-03-24 10:17:48','',''),(2616621,'1','201','1037',478,'Retail Sale Id 1464207',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 10:28:18','',''),(2616622,'1','201','1037',478,'Retail Sale Id 1464208',897.60,0.00,0.00,1.32,89.76,'2022-03-24 10:40:46','',''),(2616623,'1','201','1037',478,'Retail Sale Id 1464209',1999.20,0.00,0.00,2.94,199.92,'2022-03-24 10:44:10','',''),(2616624,'1','201','1037',478,'Retail Sale Id 1464210',1700.00,0.00,0.00,2.50,170.00,'2022-03-24 10:48:38','',''),(2616625,'1','201','1037',478,'Retail Sale Id 1464211',12800.00,0.00,0.00,20.00,560.00,'2022-03-24 10:57:21','',''),(2616626,'1','201','1037',478,'Retail Sale Id 1464212',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 11:36:37','',''),(2616627,'1','201','1037',478,'Retail Sale Id 1464213',1360.00,0.00,0.00,2.00,136.00,'2022-03-24 11:50:38','',''),(2616628,'1','201','1037',478,'Retail Sale Id 1464214',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 11:52:22','',''),(2616629,'1','201','1037',478,'Retail Sale Id 1464215',3400.00,0.00,0.00,5.00,340.00,'2022-03-24 11:54:45','',''),(2616630,'1','201','1037',478,'Retail Sale Id 1464216',1700.00,0.00,0.00,2.50,170.00,'2022-03-24 12:00:00','',''),(2616631,'1','201','1037',478,'Retail Sale Id 1464217',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 12:02:02','',''),(2616632,'1','201','1037',478,'Retail Sale Id 1464218',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 12:08:24','',''),(2616633,'1','201','1037',478,'Retail Sale Id 1464219',2998.80,0.00,0.00,4.41,299.88,'2022-03-24 12:29:44','',''),(2616634,'1','201','1037',478,'Retail Sale Id 1464220',8500.00,0.00,0.00,12.50,850.00,'2022-03-24 12:43:37','',''),(2616635,'1','201','1037',478,'Retail Sale Id 1464221',3400.00,0.00,0.00,5.00,340.00,'2022-03-24 12:44:42','',''),(2616636,'1','201','1037',478,'Retail Sale Id 1464222',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 13:01:33','',''),(2616637,'1','201','1037',478,'Retail Sale Id 1464223',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 13:27:07','',''),(2616638,'1','201','1037',478,'Retail Sale Id 1464223',3400.00,0.00,0.00,5.00,340.00,'2022-03-24 13:27:07','',''),(2616639,'1','201','1037',478,'Retail Sale Id 1464224',1020.00,0.00,0.00,1.50,102.00,'2022-03-24 13:42:39','',''),(2616640,'1','201','1037',478,'Retail Sale Id 1464225',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 13:48:24','',''),(2616641,'1','201','1037',478,'Retail Sale Id 1464226',1020.00,0.00,0.00,1.50,102.00,'2022-03-24 14:18:12','',''),(2616642,'1','201','1037',478,'Retail Sale Id 1464227',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 14:25:28','',''),(2616643,'1','201','1037',478,'Retail Sale Id 1464228',4059.60,0.00,0.00,5.97,405.96,'2022-03-24 14:29:43','',''),(2616644,'1','201','1037',478,'Retail Sale Id 1464229',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 14:30:49','',''),(2616645,'1','201','1037',478,'Retail Sale Id 1464230',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 14:34:03','',''),(2616646,'1','201','1037',478,'Retail Sale Id 1464230',8500.00,0.00,0.00,12.50,850.00,'2022-03-24 14:34:03','',''),(2616647,'1','201','1037',478,'Return of Retail Sale Id 1464205',0.00,4080.00,6.00,0.00,-408.00,'2022-03-24 14:37:18','',''),(2616648,'1','201','1037',478,'Retail Sale Id 1464231',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 14:43:30','',''),(2616649,'1','201','1037',478,'Retail Sale Id 1464232',2720.00,0.00,0.00,4.00,272.00,'2022-03-24 14:48:45','',''),(2616650,'1','201','1037',478,'Retail Sale Id 1464233',4760.00,0.00,0.00,7.00,476.00,'2022-03-24 14:51:18','',''),(2616651,'1','201','1037',478,'Retail Sale Id 1464234',1360.00,0.00,0.00,2.00,136.00,'2022-03-24 14:53:11','',''),(2616652,'1','201','1037',478,'Retail Sale Id 1464235',1360.00,0.00,0.00,2.00,136.00,'2022-03-24 15:06:49','',''),(2616653,'1','201','1037',478,'Retail Sale Id 1464236',4760.00,0.00,0.00,7.00,476.00,'2022-03-24 15:12:52','',''),(2616654,'1','201','1037',478,'Retail Sale Id 1464237',3840.00,0.00,0.00,6.00,168.00,'2022-03-24 15:18:38','',''),(2616655,'1','201','1037',478,'Retail Sale Id 1464238',2720.00,0.00,0.00,4.00,272.00,'2022-03-24 15:21:50','',''),(2616656,'1','201','1037',478,'Retail Sale Id 1464239',1502.80,0.00,0.00,2.21,150.28,'2022-03-24 15:30:39','',''),(2616657,'1','201','1037',478,'Retail Sale Id 1464240',2720.00,0.00,0.00,4.00,272.00,'2022-03-24 15:35:32','',''),(2616658,'1','201','1037',478,'Retail Sale Id 1464241',2998.80,0.00,0.00,4.41,299.88,'2022-03-24 15:36:49','',''),(2616659,'1','201','1037',478,'Retail Sale Id 1464242',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 15:46:27','',''),(2616660,'1','201','1037',478,'Retail Sale Id 1464243',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 16:09:58','',''),(2616661,'1','201','1037',478,'Retail Sale Id 1464244',8500.00,0.00,0.00,12.50,850.00,'2022-03-24 16:14:32','',''),(2616662,'1','201','1037',478,'Retail Sale Id 1464245',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 16:33:36','',''),(2616663,'1','201','1037',478,'Retail Sale Id 1464246',1360.00,0.00,0.00,2.00,136.00,'2022-03-24 16:39:46','',''),(2616664,'1','201','1037',478,'Retail Sale Id 1464247',3400.00,0.00,0.00,5.00,340.00,'2022-03-24 16:43:23','',''),(2616665,'1','201','1037',478,'Retail Sale Id 1464248',8160.00,0.00,0.00,12.00,816.00,'2022-03-24 16:45:31','',''),(2616666,'1','201','1037',478,'Retail Sale Id 1464249',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 16:47:15','',''),(2616667,'1','201','1037',478,'Retail Sale Id 1464250',8500.00,0.00,0.00,12.50,850.00,'2022-03-24 16:56:02','',''),(2616668,'1','201','1037',478,'Retail Sale Id 1464251',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 16:56:46','',''),(2616669,'1','201','1037',478,'Retail Sale Id 1464252',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 17:02:52','',''),(2616670,'1','201','1037',478,'Retail Sale Id 1464253',1360.00,0.00,0.00,2.00,136.00,'2022-03-24 17:03:57','',''),(2616671,'1','201','1037',478,'Retail Sale Id 1464254',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 17:13:10','',''),(2616672,'1','201','1037',478,'Retail Sale Id 1464255',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 17:15:08','',''),(2616673,'1','201','1037',478,'Retail Sale Id 1464256',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 17:19:34','',''),(2616674,'1','201','1037',478,'Retail Sale Id 1464257',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 17:27:49','',''),(2616675,'1','201','1037',478,'Retail Sale Id 1464258',7500.80,0.00,0.00,11.72,328.16,'2022-03-24 17:32:32','',''),(2616676,'1','201','1037',478,'Retail Sale Id 1464259',3998.40,0.00,0.00,5.88,399.84,'2022-03-24 17:36:37','',''),(2616677,'1','201','1037',478,'Retail Sale Id 1464260',8500.00,0.00,0.00,12.50,850.00,'2022-03-24 17:44:51','',''),(2616678,'1','201','1037',478,'Retail Sale Id 1464261',3400.00,0.00,0.00,5.00,340.00,'2022-03-24 17:51:57','',''),(2616679,'1','201','1037',478,'Retail Sale Id 1464262',1196.80,0.00,0.00,1.76,119.68,'2022-03-24 17:54:32','',''),(2616680,'1','201','1037',478,'Retail Sale Id 1464263',6997.20,0.00,0.00,10.29,699.72,'2022-03-24 17:58:34','',''),(2616681,'1','201','1037',478,'Retail Sale Id 1464264',1360.00,0.00,0.00,2.00,136.00,'2022-03-24 18:12:20','',''),(2616682,'1','201','1037',478,'Return of Retail Sale Id 1464262',0.00,1196.80,1.76,0.00,-119.68,'2022-03-24 19:24:27','',''),(2616683,'1','201','1037',478,'Retail Sale Id 1464265',775.20,0.00,0.00,1.14,77.52,'2022-03-24 19:25:37','',''),(2616684,'1','201','1037',478,'Retail Sale Id 1464266',4420.00,0.00,0.00,6.50,442.00,'2022-03-25 08:14:59','',''),(2616685,'1','201','1037',478,'Retail Sale Id 1464266',8500.00,0.00,0.00,12.50,850.00,'2022-03-25 08:14:59','',''),(2616686,'1','201','1037',478,'Retail Sale Id 1464267',1700.00,0.00,0.00,2.50,170.00,'2022-03-25 08:46:26','',''),(2616687,'1','201','1037',478,'Retail Sale Id 1464268',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 08:49:00','',''),(2616688,'1','201','1037',478,'Retail Sale Id 1464268',8160.00,0.00,0.00,12.00,816.00,'2022-03-25 08:49:00','',''),(2616689,'1','201','1037',478,'Retail Sale Id 1464269',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 08:55:39','',''),(2616690,'1','201','1037',478,'Retail Sale Id 1464270',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 09:09:06','',''),(2616691,'1','201','1037',478,'Retail Sale Id 1464271',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 09:21:56','',''),(2616692,'1','201','1037',478,'Retail Sale Id 1464272',8500.00,0.00,0.00,12.50,850.00,'2022-03-25 09:25:14','',''),(2616693,'1','201','1037',478,'Retail Sale Id 1464273',680.00,0.00,0.00,1.00,68.00,'2022-03-25 09:46:06','',''),(2616694,'1','201','1037',478,'Retail Sale Id 1464274',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 09:50:14','',''),(2616695,'1','201','1037',478,'Retail Sale Id 1464275',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 09:57:10','',''),(2616696,'1','201','1037',478,'Retail Sale Id 1464276',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 10:00:28','',''),(2616697,'1','201','1037',478,'Retail Sale Id 1464277',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 10:19:31','',''),(2616698,'1','201','1037',478,'Retail Sale Id 1464278',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 10:41:33','',''),(2616699,'1','201','1037',478,'Retail Sale Id 1464279',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 10:47:00','',''),(2616700,'1','201','1037',478,'Retail Sale Id 1464280',3400.00,0.00,0.00,5.00,340.00,'2022-03-25 11:17:40','',''),(2616701,'1','201','1037',478,'Retail Sale Id 1464281',16000.00,0.00,0.00,25.00,700.00,'2022-03-25 11:20:55','',''),(2616702,'1','201','1037',478,'Retail Sale Id 1464282',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 11:21:57','',''),(2616703,'1','201','1037',478,'Retail Sale Id 1464283',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 11:23:15','',''),(2616704,'1','201','1037',478,'Retail Sale Id 1464284',1196.80,0.00,0.00,1.76,119.68,'2022-03-25 11:31:13','',''),(2616705,'1','201','1037',478,'Retail Sale Id 1464284',1196.80,0.00,0.00,1.76,119.68,'2022-03-25 11:31:13','',''),(2616706,'1','201','1037',478,'Retail Sale Id 1464285',32000.00,0.00,0.00,50.00,1400.00,'2022-03-25 11:34:30','',''),(2616707,'1','201','1037',478,'Retail Sale Id 1464286',4501.60,0.00,0.00,6.62,450.16,'2022-03-25 11:47:12','',''),(2616708,'1','201','1037',478,'Retail Sale Id 1464286',4501.60,0.00,0.00,6.62,450.16,'2022-03-25 11:47:12','',''),(2616709,'1','201','1037',478,'Retail Sale Id 1464287',1999.20,0.00,0.00,2.94,199.92,'2022-03-25 11:48:08','',''),(2616710,'1','201','1037',478,'Retail Sale Id 1464288',3400.00,0.00,0.00,5.00,340.00,'2022-03-25 12:00:40','',''),(2616711,'1','201','1037',478,'Retail Sale Id 1464289',999.60,0.00,0.00,1.47,99.96,'2022-03-25 12:02:08','',''),(2616712,'1','201','1037',478,'Retail Sale Id 1464290',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 12:11:46','',''),(2616713,'1','201','1037',478,'Retail Sale Id 1464290',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 12:11:46','',''),(2616714,'1','201','1037',478,'Retail Sale Id 1464290',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 12:11:46','',''),(2616715,'1','201','1037',478,'Retail Sale Id 1464291',680.00,0.00,0.00,1.00,68.00,'2022-03-25 12:12:51','',''),(2616716,'1','201','1037',478,'Retail Sale Id 1464292',1999.20,0.00,0.00,2.94,199.92,'2022-03-25 12:14:36','',''),(2616717,'1','201','1037',478,'Retail Sale Id 1464293',3502.00,0.00,0.00,5.15,350.20,'2022-03-25 12:15:44','',''),(2616718,'1','201','1037',478,'Retail Sale Id 1464294',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 12:16:33','',''),(2616719,'1','201','1037',478,'Retail Sale Id 1464295',3400.00,0.00,0.00,5.00,340.00,'2022-03-25 12:53:24','',''),(2616720,'1','201','1037',478,'Retail Sale Id 1464296',8500.00,0.00,0.00,12.50,850.00,'2022-03-25 13:49:54','',''),(2616721,'1','201','1037',478,'Retail Sale Id 1464296',8500.00,0.00,0.00,12.50,850.00,'2022-03-25 13:49:54','',''),(2616722,'1','201','1037',478,'Retail Sale Id 1464297',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 13:52:28','',''),(2616723,'1','201','1037',478,'Retail Sale Id 1464298',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 14:14:21','',''),(2616724,'1','201','1037',478,'Retail Sale Id 1464299',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 14:25:48','',''),(2616725,'1','201','1037',478,'Retail Sale Id 1464299',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 14:25:48','',''),(2616726,'1','201','1037',478,'Retail Sale Id 1464300',680.00,0.00,0.00,1.00,68.00,'2022-03-25 14:46:29','',''),(2616727,'1','201','1037',478,'Retail Sale Id 1464300',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 14:46:29','',''),(2616728,'1','201','1037',478,'Retail Sale Id 1464301',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 14:59:38','',''),(2616729,'1','201','1037',478,'Retail Sale Id 1464302',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 15:23:22','',''),(2616730,'1','201','1037',478,'Retail Sale Id 1464302',8500.00,0.00,0.00,12.50,850.00,'2022-03-25 15:23:22','',''),(2616731,'1','201','1037',478,'Retail Sale Id 1464303',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 15:26:11','',''),(2616732,'1','201','1037',478,'Retail Sale Id 1464304',7680.00,0.00,0.00,12.00,336.00,'2022-03-25 15:40:14','',''),(2616733,'1','201','1037',478,'Retail Sale Id 1464305',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 16:18:13','',''),(2616734,'1','201','1037',478,'Retail Sale Id 1464306',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 16:43:03','',''),(2616735,'1','201','1037',478,'Retail Sale Id 1464307',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 16:45:19','',''),(2616736,'1','201','1037',478,'Retail Sale Id 1464308',680.00,0.00,0.00,1.00,68.00,'2022-03-25 16:49:27','',''),(2616737,'1','201','1037',478,'Retail Sale Id 1464309',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 17:15:42','',''),(2616738,'1','201','1037',478,'Retail Sale Id 1464310',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 17:20:55','',''),(2616739,'1','201','1037',478,'Retail Sale Id 1464311',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 17:25:39','',''),(2616740,'1','201','1037',478,'Retail Sale Id 1464312',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 17:39:48','',''),(2616741,'1','201','1037',478,'Retail Sale Id 1464313',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 17:44:07','',''),(2616742,'1','201','1037',478,'Retail Sale Id 1464314',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 17:53:46','',''),(2616743,'1','201','1037',478,'Retail Sale Id 1464315',1196.80,0.00,0.00,1.76,119.68,'2022-03-25 17:55:42','',''),(2616744,'1','201','1037',478,'Retail Sale Id 1464316',3400.00,0.00,0.00,5.00,340.00,'2022-03-25 17:59:44','',''),(2616745,'1','201','1037',478,'Retail Sale Id 1464317',3400.00,0.00,0.00,5.00,340.00,'2022-03-25 18:10:10','',''),(2616746,'1','201','1037',478,'Retail Sale Id 1464318',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 18:11:09','',''),(2616747,'1','201','1037',478,'Retail Sale Id 1464319',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 18:18:00','',''),(2616748,'1','201','1037',478,'Return of Retail Sale Id 1464314',0.00,1360.00,2.00,0.00,-136.00,'2022-03-25 19:13:17','',''),(2616749,'1','201','1037',478,'Retail Sale Id 1464320',1312.40,0.00,0.00,1.93,131.24,'2022-03-25 19:13:55','',''),(2616750,'1','201','1037',478,'Retail Sale Id 1464321',2720.00,0.00,0.00,4.00,272.00,'2022-03-26 08:24:45','',''),(2616751,'1','201','1037',478,'Retail Sale Id 1464322',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 08:25:22','',''),(2616752,'1','201','1037',478,'Retail Sale Id 1464323',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 08:26:14','',''),(2616753,'1','201','1037',478,'Retail Sale Id 1464324',7500.80,0.00,0.00,11.72,328.16,'2022-03-26 08:46:41','',''),(2616754,'1','201','1037',478,'Retail Sale Id 1464325',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 08:47:53','',''),(2616755,'1','201','1037',478,'Retail Sale Id 1464326',4998.00,0.00,0.00,7.35,499.80,'2022-03-26 08:50:38','',''),(2616756,'1','201','1037',478,'Retail Sale Id 1464327',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 09:02:10','',''),(2616757,'1','201','1037',478,'Retail Sale Id 1464328',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 09:08:23','',''),(2616758,'1','201','1037',478,'Return of Retail Sale Id 1464328',0.00,2040.00,3.00,0.00,-204.00,'2022-03-26 09:15:52','',''),(2616759,'1','201','1037',478,'Retail Sale Id 1464329',1876.80,0.00,0.00,2.76,187.68,'2022-03-26 09:16:59','',''),(2616760,'1','201','1037',478,'Retail Sale Id 1464330',1700.00,0.00,0.00,2.50,170.00,'2022-03-26 09:31:57','',''),(2616761,'1','201','1037',478,'Retail Sale Id 1464331',4760.00,0.00,0.00,7.00,476.00,'2022-03-26 09:47:12','',''),(2616762,'1','201','1037',478,'Retail Sale Id 1464332',4080.00,0.00,0.00,6.00,408.00,'2022-03-26 09:48:54','',''),(2616763,'1','201','1037',478,'Retail Sale Id 1464333',680.00,0.00,0.00,1.00,68.00,'2022-03-26 09:52:44','',''),(2616764,'1','201','1037',478,'Retail Sale Id 1464334',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 09:56:40','',''),(2616765,'1','201','1037',478,'Retail Sale Id 1464335',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 09:58:25','',''),(2616766,'1','201','1037',478,'Retail Sale Id 1464336',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 10:16:33','',''),(2616767,'1','201','1037',478,'Retail Sale Id 1464336',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 10:16:33','',''),(2616768,'1','201','1037',478,'Retail Sale Id 1464337',2380.00,0.00,0.00,3.50,238.00,'2022-03-26 10:17:47','',''),(2616769,'1','201','1037',478,'Retail Sale Id 1464338',1700.00,0.00,0.00,2.50,170.00,'2022-03-26 10:20:01','',''),(2616770,'1','201','1037',478,'Retail Sale Id 1464339',2720.00,0.00,0.00,4.00,272.00,'2022-03-26 10:33:39','',''),(2616771,'1','201','1037',478,'Retail Sale Id 1464340',4080.00,0.00,0.00,6.00,408.00,'2022-03-26 10:39:07','',''),(2616772,'1','201','1037',478,'Retail Sale Id 1464341',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 10:40:30','',''),(2616773,'1','201','1037',478,'Retail Sale Id 1464342',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 10:52:57','',''),(2616774,'1','201','1037',478,'Retail Sale Id 1464343',3998.40,0.00,0.00,5.88,399.84,'2022-03-26 10:55:10','',''),(2616775,'1','201','1037',478,'Retail Sale Id 1464344',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 11:08:26','',''),(2616776,'1','201','1037',478,'Retail Sale Id 1464345',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 11:09:15','',''),(2616777,'1','201','1037',478,'Retail Sale Id 1464347',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 11:34:58','',''),(2616778,'1','201','1037',478,'Retail Sale Id 1464348',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 11:36:10','',''),(2616779,'1','201','1037',478,'Retail Sale Id 1464349',7996.80,0.00,0.00,11.76,799.68,'2022-03-26 12:09:06','',''),(2616780,'1','201','1037',478,'Retail Sale Id 1464350',2720.00,0.00,0.00,4.00,272.00,'2022-03-26 12:10:42','',''),(2616781,'1','201','1037',478,'Retail Sale Id 1464351',3740.00,0.00,0.00,5.50,374.00,'2022-03-26 12:31:53','',''),(2616782,'1','201','1037',478,'Retail Sale Id 1464351',4080.00,0.00,0.00,6.00,408.00,'2022-03-26 12:31:53','',''),(2616783,'1','201','1037',478,'Retail Sale Id 1464352',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 12:42:29','',''),(2616784,'1','201','1037',478,'Retail Sale Id 1464353',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 12:51:33','',''),(2616785,'1','201','1037',478,'Retail Sale Id 1464354',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 12:56:15','',''),(2616786,'1','201','1037',478,'Retail Sale Id 1464355',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 13:04:11','',''),(2616787,'1','201','1037',478,'Retail Sale Id 1464356',3520.00,0.00,0.00,5.50,154.00,'2022-03-26 13:26:37','',''),(2616788,'1','201','1037',478,'Retail Sale Id 1464357',7480.00,0.00,0.00,11.00,748.00,'2022-03-26 13:28:47','',''),(2616789,'1','201','1037',478,'Retail Sale Id 1464358',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 13:41:34','',''),(2616790,'1','201','1037',478,'Retail Sale Id 1464359',8000.00,0.00,0.00,12.50,350.00,'2022-03-26 13:58:07','',''),(2616791,'1','201','1037',478,'Retail Sale Id 1464360',2720.00,0.00,0.00,4.00,272.00,'2022-03-26 14:03:23','',''),(2616792,'1','201','1037',478,'Retail Sale Id 1464361',680.00,0.00,0.00,1.00,68.00,'2022-03-26 14:05:14','',''),(2616793,'1','201','1037',478,'Retail Sale Id 1464362',1920.00,0.00,0.00,3.00,84.00,'2022-03-26 14:25:26','',''),(2616794,'1','201','1037',478,'Retail Sale Id 1464363',2720.00,0.00,0.00,4.00,272.00,'2022-03-26 15:00:51','',''),(2616795,'1','201','1037',478,'Retail Sale Id 1464364',1196.80,0.00,0.00,1.76,119.68,'2022-03-26 15:02:19','',''),(2616796,'1','201','1037',478,'Retail Sale Id 1464365',8500.00,0.00,0.00,12.50,850.00,'2022-03-26 15:07:55','',''),(2616797,'1','201','1037',478,'Retail Sale Id 1464366',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 15:08:46','',''),(2616798,'1','201','1037',478,'Retail Sale Id 1464367',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 15:14:57','',''),(2616799,'1','201','1037',478,'Retail Sale Id 1464368',1700.00,0.00,0.00,2.50,170.00,'2022-03-26 15:17:42','',''),(2616800,'1','201','1037',478,'Retail Sale Id 1464369',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 15:18:53','',''),(2616801,'1','201','1037',478,'Retail Sale Id 1464370',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 15:19:56','',''),(2616802,'1','201','1037',478,'Retail Sale Id 1464371',8500.00,0.00,0.00,12.50,850.00,'2022-03-26 15:30:19','',''),(2616803,'1','201','1037',478,'Retail Sale Id 1464372',8500.00,0.00,0.00,12.50,850.00,'2022-03-26 15:37:54','',''),(2616804,'1','201','1037',478,'Retail Sale Id 1464373',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 15:57:04','',''),(2616805,'1','201','1037',478,'Retail Sale Id 1464374',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 16:17:27','',''),(2616806,'1','201','1037',478,'Retail Sale Id 1464375',3060.00,0.00,0.00,4.50,306.00,'2022-03-26 16:26:18','',''),(2616807,'1','201','1037',478,'Retail Sale Id 1464376',8160.00,0.00,0.00,12.00,816.00,'2022-03-26 16:27:28','',''),(2616808,'1','201','1037',478,'Retail Sale Id 1464377',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 16:28:43','',''),(2616809,'1','201','1037',478,'Retail Sale Id 1464378',999.60,0.00,0.00,1.47,99.96,'2022-03-26 16:35:42','',''),(2616810,'1','201','1037',478,'Retail Sale Id 1464379',999.60,0.00,0.00,1.47,99.96,'2022-03-26 16:39:59','',''),(2616811,'1','201','1037',478,'Retail Sale Id 1464380',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 16:54:11','',''),(2616812,'1','201','1037',478,'Retail Sale Id 1464381',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 16:59:56','',''),(2616813,'1','201','1037',478,'Retail Sale Id 1464382',4760.00,0.00,0.00,7.00,476.00,'2022-03-26 17:07:23','',''),(2616814,'1','201','1037',478,'Retail Sale Id 1464383',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 17:08:32','',''),(2616815,'1','201','1037',478,'Retail Sale Id 1464384',680.00,0.00,0.00,1.00,68.00,'2022-03-26 17:11:56','',''),(2616816,'1','201','1037',478,'Retail Sale Id 1464385',3400.00,0.00,0.00,5.00,340.00,'2022-03-26 17:18:50','',''),(2616817,'1','201','1037',478,'Retail Sale Id 1464386',7500.80,0.00,0.00,11.72,328.16,'2022-03-26 17:20:08','',''),(2616818,'1','201','1037',478,'Retail Sale Id 1464387',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 17:27:36','',''),(2616819,'1','201','1037',478,'Retail Sale Id 1464388',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 17:32:48','',''),(2616820,'1','201','1037',478,'Retail Sale Id 1464388',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 17:32:48','',''),(2616821,'1','201','1037',478,'Retail Sale Id 1464389',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 17:33:45','',''),(2616822,'1','201','1037',478,'Retail Sale Id 1464390',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 17:47:25','',''),(2616823,'1','201','1037',478,'Retail Sale Id 1464390',1360.00,0.00,0.00,2.00,136.00,'2022-03-26 17:47:25','',''),(2616824,'1','201','1037',478,'Retail Sale Id 1464391',1700.00,0.00,0.00,2.50,170.00,'2022-03-26 17:50:15','',''),(2616825,'1','201','1037',478,'Retail Sale Id 1464392',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 17:52:53','',''),(2616826,'1','201','1037',478,'Retail Sale Id 1464393',999.60,0.00,0.00,1.47,99.96,'2022-03-26 18:00:28','',''),(2616827,'1','201','1037',478,'Retail Sale Id 1464394',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 18:13:09','',''),(2616828,'1','201','1037',478,'Retail Sale Id 1464395',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 18:18:17','',''),(2616829,'1','201','1037',478,'Retail Sale Id 1464396',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 07:40:42','',''),(2616830,'1','201','1037',478,'Retail Sale Id 1464397',2998.80,0.00,0.00,4.41,299.88,'2022-03-27 07:47:03','',''),(2616831,'1','201','1037',478,'Retail Sale Id 1464398',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 08:16:39','',''),(2616832,'1','201','1037',478,'Retail Sale Id 1464399',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 08:24:18','',''),(2616833,'1','201','1037',478,'Retail Sale Id 1464400',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 08:28:05','',''),(2616834,'1','201','1037',478,'Retail Sale Id 1464401',7500.40,0.00,0.00,11.03,750.04,'2022-03-27 08:52:49','',''),(2616835,'1','201','1037',478,'Retail Sale Id 1464403',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 08:58:13','',''),(2616836,'1','201','1037',478,'Retail Sale Id 1464404',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 09:00:22','',''),(2616837,'1','201','1037',478,'Retail Sale Id 1464405',2720.00,0.00,0.00,4.00,272.00,'2022-03-27 09:01:54','',''),(2616838,'1','201','1037',478,'Retail Sale Id 1464406',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 09:16:42','',''),(2616839,'1','201','1037',478,'Retail Sale Id 1464407',4760.00,0.00,0.00,7.00,476.00,'2022-03-27 09:27:00','',''),(2616840,'1','201','1037',478,'Retail Sale Id 1464408',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 09:51:36','',''),(2616841,'1','201','1037',478,'Retail Sale Id 1464409',2568.00,0.00,0.00,4.00,120.00,'2022-03-27 09:54:55','',''),(2616842,'1','201','1037',478,'Retail Sale Id 1464410',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 09:55:47','',''),(2616843,'1','201','1037',478,'Retail Sale Id 1464411',1020.00,0.00,0.00,1.50,102.00,'2022-03-27 10:15:54','',''),(2616844,'1','201','1037',478,'Retail Sale Id 1464412',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 10:27:14','',''),(2616845,'1','201','1037',478,'Retail Sale Id 1464413',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 10:29:39','',''),(2616846,'1','201','1037',478,'Retail Sale Id 1464414',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 10:38:21','',''),(2616847,'1','201','1037',478,'Retail Sale Id 1464415',7500.40,0.00,0.00,11.03,750.04,'2022-03-27 10:41:01','',''),(2616848,'1','201','1037',478,'Retail Sale Id 1464416',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 10:44:49','',''),(2616849,'1','201','1037',478,'Return of Retail Sale Id 1464414',0.00,8500.00,12.50,0.00,-850.00,'2022-03-27 10:45:59','',''),(2616850,'1','201','1037',478,'Retail Sale Id 1464417',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 10:56:39','',''),(2616851,'1','201','1037',478,'Retail Sale Id 1464418',1502.80,0.00,0.00,2.21,150.28,'2022-03-27 11:00:17','',''),(2616852,'1','201','1037',478,'Retail Sale Id 1464419',2998.80,0.00,0.00,4.41,299.88,'2022-03-27 11:26:39','',''),(2616853,'1','201','1037',478,'Retail Sale Id 1464419',7996.80,0.00,0.00,11.76,799.68,'2022-03-27 11:26:39','',''),(2616854,'1','201','1037',478,'Retail Sale Id 1464420',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 11:27:41','',''),(2616855,'1','201','1037',478,'Retail Sale Id 1464421',999.60,0.00,0.00,1.47,99.96,'2022-03-27 11:30:33','',''),(2616856,'1','201','1037',478,'Retail Sale Id 1464422',802.40,0.00,0.00,1.18,80.24,'2022-03-27 12:02:01','',''),(2616857,'1','201','1037',478,'Retail Sale Id 1464423',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 12:07:44','',''),(2616858,'1','201','1037',478,'Retail Sale Id 1464424',4420.00,0.00,0.00,6.50,442.00,'2022-03-27 12:14:38','',''),(2616859,'1','201','1037',478,'Retail Sale Id 1464425',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 12:48:05','',''),(2616860,'1','201','1037',478,'Retail Sale Id 1464426',1700.00,0.00,0.00,2.50,170.00,'2022-03-27 12:50:18','',''),(2616861,'1','201','1037',478,'Retail Sale Id 1464427',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 13:01:57','',''),(2616862,'1','201','1037',478,'Retail Sale Id 1464428',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 13:05:04','',''),(2616863,'1','201','1037',478,'Retail Sale Id 1464429',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 13:21:53','',''),(2616864,'1','201','1037',478,'Retail Sale Id 1464430',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 13:30:35','',''),(2616865,'1','201','1037',478,'Retail Sale Id 1464431',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 13:31:25','',''),(2616866,'1','201','1037',478,'Retail Sale Id 1464432',680.00,0.00,0.00,1.00,68.00,'2022-03-27 13:36:33','',''),(2616867,'1','201','1037',478,'Retail Sale Id 1464433',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 13:39:25','',''),(2616868,'1','201','1037',478,'Retail Sale Id 1464434',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 13:54:07','',''),(2616869,'1','201','1037',478,'Retail Sale Id 1464435',802.40,0.00,0.00,1.18,80.24,'2022-03-27 13:55:00','',''),(2616870,'1','201','1037',478,'Retail Sale Id 1464436',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 13:56:07','',''),(2616871,'1','201','1037',478,'Retail Sale Id 1464437',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 13:56:53','',''),(2616872,'1','201','1037',478,'Retail Sale Id 1464438',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 14:06:06','',''),(2616873,'1','201','1037',478,'Retail Sale Id 1464439',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 14:06:52','',''),(2616874,'1','201','1037',478,'Retail Sale Id 1464440',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 14:07:59','',''),(2616875,'1','201','1037',478,'Retail Sale Id 1464441',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 14:09:00','',''),(2616876,'1','201','1037',478,'Retail Sale Id 1464443',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 14:30:07','',''),(2616877,'1','201','1037',478,'Retail Sale Id 1464444',6997.20,0.00,0.00,10.29,699.72,'2022-03-27 14:37:06','',''),(2616878,'1','201','1037',478,'Retail Sale Id 1464445',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 14:44:56','',''),(2616879,'1','201','1037',478,'Retail Sale Id 1464446',1999.20,0.00,0.00,2.94,199.92,'2022-03-27 15:11:24','',''),(2616880,'1','201','1037',478,'Retail Sale Id 1464447',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 15:15:12','',''),(2616881,'1','201','1037',478,'Retail Sale Id 1464448',680.00,0.00,0.00,1.00,68.00,'2022-03-27 15:22:51','',''),(2616882,'1','201','1037',478,'Retail Sale Id 1464449',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 15:26:55','',''),(2616883,'1','201','1037',478,'Retail Sale Id 1464450',680.00,0.00,0.00,1.00,68.00,'2022-03-27 15:44:25','',''),(2616884,'1','201','1037',478,'Retail Sale Id 1464451',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 15:56:17','',''),(2616885,'1','201','1037',478,'Retail Sale Id 1464451',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 15:56:17','',''),(2616886,'1','201','1037',478,'Retail Sale Id 1464452',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 16:02:16','',''),(2616887,'1','201','1037',478,'Retail Sale Id 1464453',2998.80,0.00,0.00,4.41,299.88,'2022-03-27 16:18:57','',''),(2616888,'1','201','1037',478,'Retail Sale Id 1464454',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 16:34:56','',''),(2616889,'1','201','1037',478,'Retail Sale Id 1464455',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 16:48:34','',''),(2616890,'1','201','1037',478,'Retail Sale Id 1464456',2502.40,0.00,0.00,3.68,250.24,'2022-03-27 16:49:57','',''),(2616891,'1','201','1037',478,'Retail Sale Id 1464457',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 16:53:00','',''),(2616892,'1','201','1037',478,'Retail Sale Id 1464458',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 16:55:44','',''),(2616893,'1','201','1037',478,'Retail Sale Id 1464459',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 16:57:48','',''),(2616894,'1','201','1037',478,'Retail Sale Id 1464460',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 16:58:46','',''),(2616895,'1','201','1037',478,'Retail Sale Id 1464461',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 17:12:26','',''),(2616896,'1','201','1037',478,'Retail Sale Id 1464462',680.00,0.00,0.00,1.00,68.00,'2022-03-27 17:15:57','',''),(2616897,'1','201','1037',478,'Retail Sale Id 1464463',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 17:18:55','',''),(2616898,'1','201','1037',478,'Retail Sale Id 1464464',680.00,0.00,0.00,1.00,68.00,'2022-03-27 17:24:21','',''),(2616899,'1','201','1037',478,'Retail Sale Id 1464464',680.00,0.00,0.00,1.00,68.00,'2022-03-27 17:24:21','',''),(2616900,'1','201','1037',478,'Retail Sale Id 1464465',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 17:27:34','',''),(2616901,'1','201','1037',478,'Retail Sale Id 1464466',1999.20,0.00,0.00,2.94,199.92,'2022-03-27 17:32:28','',''),(2616902,'1','201','1037',478,'Retail Sale Id 1464467',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 17:33:12','',''),(2616903,'1','201','1037',478,'Retail Sale Id 1464468',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 17:34:51','',''),(2616904,'1','201','1037',478,'Retail Sale Id 1464469',8160.00,0.00,0.00,12.00,816.00,'2022-03-27 17:42:24','',''),(2616905,'1','201','1037',478,'Retail Sale Id 1464470',1196.80,0.00,0.00,1.76,119.68,'2022-03-27 17:47:07','',''),(2616906,'1','201','1037',478,'Retail Sale Id 1464471',8500.00,0.00,0.00,12.50,850.00,'2022-03-27 17:48:10','',''),(2616907,'1','201','1037',478,'Retail Sale Id 1464472',3597.20,0.00,0.00,5.29,359.72,'2022-03-27 17:49:10','',''),(2616908,'1','201','1037',478,'Retail Sale Id 1464473',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 17:50:08','',''),(2616909,'1','201','1037',478,'Retail Sale Id 1464475',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 17:51:38','',''),(2616910,'1','201','1037',478,'Retail Sale Id 1464476',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 17:52:36','',''),(2616911,'1','201','1037',478,'Retail Sale Id 1464477',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 17:58:41','',''),(2616912,'1','201','1037',478,'Retail Sale Id 1464478',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 18:02:21','',''),(2616913,'1','201','1037',478,'Retail Sale Id 1464479',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 18:07:46','',''),(2616914,'1','201','1037',478,'Retail Sale Id 1464480',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 18:11:02','',''),(2616915,'1','201','1037',478,'Retail Sale Id 1464481',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 18:14:27','',''),(2616916,'1','201','1037',478,'Retail Sale Id 1464482',2998.80,0.00,0.00,4.41,299.88,'2022-03-27 18:16:30','',''),(2616917,'1','201','1037',478,'Retail Sale Id 1464483',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 18:19:14','',''),(2616918,'1','201','1037',478,'Retail Sale Id 1464484',1999.20,0.00,0.00,2.94,199.92,'2022-03-27 18:20:28','',''),(2616919,'1','201','1037',478,'Return of Retail Sale Id 1464482',0.00,2998.80,4.41,0.00,-299.88,'2022-03-27 18:54:58','',''),(2616920,'1','201','1037',478,'Retail Sale Id 1464485',3005.60,0.00,0.00,4.42,300.56,'2022-03-27 18:55:31','',''),(2616921,'1','201','1037',478,'Retail Sale Id 1464486',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 07:34:15','',''),(2616922,'1','201','1037',478,'Retail Sale Id 1464487',680.00,0.00,0.00,1.00,68.00,'2022-03-28 07:41:52','',''),(2616923,'1','201','1037',478,'Retail Sale Id 1464488',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 08:10:08','',''),(2616924,'1','201','1037',478,'Retail Sale Id 1464489',9003.20,0.00,0.00,13.24,900.32,'2022-03-28 08:13:22','',''),(2616925,'1','201','1037',478,'Retail Sale Id 1464490',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 08:20:48','',''),(2616926,'1','201','1037',478,'Retail Sale Id 1464491',680.00,0.00,0.00,1.00,68.00,'2022-03-28 08:24:52','',''),(2616927,'1','201','1037',478,'Retail Sale Id 1464492',700.40,0.00,0.00,1.03,70.04,'2022-03-28 08:26:46','',''),(2616928,'1','201','1037',478,'Retail Sale Id 1464493',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 08:28:15','',''),(2616929,'1','201','1037',478,'Retail Sale Id 1464495',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 08:39:17','',''),(2616930,'1','201','1037',478,'Retail Sale Id 1464496',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 08:49:06','',''),(2616931,'1','201','1037',478,'Retail Sale Id 1464497',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 09:07:32','',''),(2616932,'1','201','1037',478,'Retail Sale Id 1464498',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 09:56:29','',''),(2616933,'1','201','1037',478,'Retail Sale Id 1464499',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 10:01:26','',''),(2616934,'1','201','1037',478,'Retail Sale Id 1464500',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 10:12:50','',''),(2616935,'1','201','1037',478,'Retail Sale Id 1464501',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 10:37:07','',''),(2616936,'1','201','1037',478,'Retail Sale Id 1464502',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 10:38:02','',''),(2616937,'1','201','1037',478,'Retail Sale Id 1464503',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 10:55:23','',''),(2616938,'1','201','1037',478,'Retail Sale Id 1464504',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 10:59:14','',''),(2616939,'1','201','1037',478,'Retail Sale Id 1464505',3998.40,0.00,0.00,5.88,399.84,'2022-03-28 11:15:41','',''),(2616940,'1','201','1037',478,'Retail Sale Id 1464506',2720.00,0.00,0.00,4.00,272.00,'2022-03-28 11:27:18','',''),(2616941,'1','201','1037',478,'Retail Sale Id 1464507',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 11:33:40','',''),(2616942,'1','201','1037',478,'Retail Sale Id 1464508',6800.00,0.00,0.00,10.00,680.00,'2022-03-28 11:47:16','',''),(2616943,'1','201','1037',478,'Retail Sale Id 1464509',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 11:51:23','',''),(2616944,'1','201','1037',478,'Retail Sale Id 1464510',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 11:55:42','',''),(2616945,'1','201','1037',478,'Retail Sale Id 1464511',16320.00,0.00,0.00,24.00,1632.00,'2022-03-28 11:57:03','',''),(2616946,'1','201','1037',478,'Retail Sale Id 1464512',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 12:05:55','',''),(2616947,'1','201','1037',478,'Retail Sale Id 1464513',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 12:10:45','',''),(2616948,'1','201','1037',478,'Retail Sale Id 1464514',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 12:13:27','',''),(2616949,'1','201','1037',478,'Retail Sale Id 1464515',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 12:14:33','',''),(2616950,'1','201','1037',478,'Retail Sale Id 1464516',2720.00,0.00,0.00,4.00,272.00,'2022-03-28 12:16:03','',''),(2616951,'1','201','1037',478,'Retail Sale Id 1464517',3746.80,0.00,0.00,5.51,374.68,'2022-03-28 12:18:10','',''),(2616952,'1','201','1037',478,'Retail Sale Id 1464518',2720.00,0.00,0.00,4.00,272.00,'2022-03-28 12:20:03','',''),(2616953,'1','201','1037',478,'Retail Sale Id 1464519',1849.60,0.00,0.00,2.72,184.96,'2022-03-28 12:22:06','',''),(2616954,'1','201','1037',478,'Retail Sale Id 1464520',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 12:25:24','',''),(2616955,'1','201','1037',478,'Return of Retail Sale Id 1464515',0.00,2040.00,3.00,0.00,-204.00,'2022-03-28 12:25:49','',''),(2616956,'1','201','1037',478,'Retail Sale Id 1464521',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 13:40:28','',''),(2616957,'1','201','1037',478,'Retail Sale Id 1464522',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 13:41:05','',''),(2616958,'1','201','1037',478,'Retail Sale Id 1464523',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 13:42:37','',''),(2616959,'1','201','1037',478,'Retail Sale Id 1464524',6800.00,0.00,0.00,10.00,680.00,'2022-03-28 13:44:17','',''),(2616960,'1','201','1037',478,'Retail Sale Id 1464525',6800.00,0.00,0.00,10.00,680.00,'2022-03-28 14:10:09','',''),(2616961,'1','201','1037',478,'Retail Sale Id 1464526',1502.80,0.00,0.00,2.21,150.28,'2022-03-28 14:15:29','',''),(2616962,'1','201','1037',478,'Retail Sale Id 1464527',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 14:18:50','',''),(2616963,'1','201','1037',478,'Retail Sale Id 1464528',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 14:20:12','',''),(2616964,'1','201','1037',478,'Retail Sale Id 1464529',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 14:21:09','',''),(2616965,'1','201','1037',478,'Retail Sale Id 1464530',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 14:24:38','',''),(2616966,'1','201','1037',478,'Retail Sale Id 1464531',680.00,0.00,0.00,1.00,68.00,'2022-03-28 14:28:10','',''),(2616967,'1','201','1037',478,'Retail Sale Id 1464532',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 14:29:48','',''),(2616968,'1','201','1037',478,'Retail Sale Id 1464533',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 14:35:38','',''),(2616969,'1','201','1037',478,'Retail Sale Id 1464534',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 14:36:35','',''),(2616970,'1','201','1037',478,'Retail Sale Id 1464535',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 14:47:05','',''),(2616971,'1','201','1037',478,'Retail Sale Id 1464536',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 15:03:19','',''),(2616972,'1','201','1037',478,'Retail Sale Id 1464537',999.60,0.00,0.00,1.47,99.96,'2022-03-28 15:14:51','',''),(2616973,'1','201','1037',478,'Retail Sale Id 1464537',999.60,0.00,0.00,1.47,99.96,'2022-03-28 15:14:51','',''),(2616974,'1','201','1037',478,'Retail Sale Id 1464538',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 15:15:50','',''),(2616975,'1','201','1037',478,'Retail Sale Id 1464539',3210.00,0.00,0.00,5.00,150.00,'2022-03-28 15:16:51','',''),(2616976,'1','201','1037',478,'Retail Sale Id 1464540',7480.00,0.00,0.00,11.00,748.00,'2022-03-28 15:20:03','',''),(2616977,'1','201','1037',478,'Retail Sale Id 1464540',7480.00,0.00,0.00,11.00,748.00,'2022-03-28 15:20:03','',''),(2616978,'1','201','1037',478,'Retail Sale Id 1464541',6800.00,0.00,0.00,10.00,680.00,'2022-03-28 15:30:41','',''),(2616979,'1','201','1037',478,'Retail Sale Id 1464541',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 15:30:41','',''),(2616980,'1','201','1037',478,'Retail Sale Id 1464542',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 15:53:19','',''),(2616981,'1','201','1037',478,'Retail Sale Id 1464543',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 16:28:42','',''),(2616982,'1','201','1037',478,'Retail Sale Id 1464544',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 16:30:55','',''),(2616983,'1','201','1037',478,'Retail Sale Id 1464545',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 16:38:38','',''),(2616984,'1','201','1037',478,'Retail Sale Id 1464546',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 16:41:29','',''),(2616985,'1','201','1037',478,'Retail Sale Id 1464547',2720.00,0.00,0.00,4.00,272.00,'2022-03-28 16:44:07','',''),(2616986,'1','201','1037',478,'Retail Sale Id 1464548',680.00,0.00,0.00,1.00,68.00,'2022-03-28 16:44:51','',''),(2616987,'1','201','1037',478,'Retail Sale Id 1464549',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 16:49:06','',''),(2616988,'1','201','1037',478,'Retail Sale Id 1464550',5997.60,0.00,0.00,8.82,599.76,'2022-03-28 16:50:38','',''),(2616989,'1','201','1037',478,'Retail Sale Id 1464551',2998.80,0.00,0.00,4.41,299.88,'2022-03-28 16:51:10','',''),(2616990,'1','201','1037',478,'Retail Sale Id 1464552',1999.20,0.00,0.00,2.94,199.92,'2022-03-28 16:52:01','',''),(2616991,'1','201','1037',478,'Retail Sale Id 1464553',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 16:58:06','',''),(2616992,'1','201','1037',478,'Retail Sale Id 1464554',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 17:04:52','',''),(2616993,'1','201','1037',478,'Retail Sale Id 1464555',999.60,0.00,0.00,1.47,99.96,'2022-03-28 17:06:06','',''),(2616994,'1','201','1037',478,'Retail Sale Id 1464556',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 17:08:08','',''),(2616995,'1','201','1037',478,'Retail Sale Id 1464557',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 17:11:49','',''),(2616996,'1','201','1037',478,'Retail Sale Id 1464558',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 17:27:32','',''),(2616997,'1','201','1037',478,'Retail Sale Id 1464559',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 17:35:13','',''),(2616998,'1','201','1037',478,'Retail Sale Id 1464560',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 17:47:20','',''),(2616999,'1','201','1037',478,'Retail Sale Id 1464561',8160.00,0.00,0.00,12.00,816.00,'2022-03-28 17:52:31','',''),(2617000,'1','201','1037',478,'Retail Sale Id 1464562',2720.00,0.00,0.00,4.00,272.00,'2022-03-28 18:04:12','',''),(2617001,'1','201','1037',478,'Retail Sale Id 1464563',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 18:13:28','',''),(2617002,'1','201','1037',478,'Retail Sale Id 1464564',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 18:14:51','',''),(2617003,'1','201','1037',478,'Retail Sale Id 1464565',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 18:22:07','',''),(2617004,'1','201','1037',478,'Return of Retail Sale Id 1464557',0.00,2040.00,3.00,0.00,-204.00,'2022-03-28 19:09:19','',''),(2617005,'1','201','1037',478,'Retail Sale Id 1464566',1672.80,0.00,0.00,2.46,167.28,'2022-03-28 19:10:28','',''),(2617006,'1','201','1037',478,'Retail Sale Id 1464567',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 08:10:12','',''),(2617007,'1','201','1037',478,'Retail Sale Id 1464568',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 08:26:42','',''),(2617008,'1','201','1037',478,'Retail Sale Id 1464569',2720.00,0.00,0.00,4.00,272.00,'2022-03-29 08:36:35','',''),(2617009,'1','201','1037',478,'Retail Sale Id 1464570',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 08:45:44','',''),(2617010,'1','201','1037',478,'Retail Sale Id 1464571',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 08:58:41','',''),(2617011,'1','201','1037',478,'Retail Sale Id 1464572',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 09:02:32','',''),(2617012,'1','201','1037',478,'Retail Sale Id 1464573',4760.00,0.00,0.00,7.00,476.00,'2022-03-29 09:31:40','',''),(2617013,'1','201','1037',478,'Retail Sale Id 1464574',4420.00,0.00,0.00,6.50,442.00,'2022-03-29 09:32:45','',''),(2617014,'1','201','1037',478,'Retail Sale Id 1464575',1802.00,0.00,0.00,2.65,180.20,'2022-03-29 09:34:48','',''),(2617015,'1','201','1037',478,'Retail Sale Id 1464576',3060.00,0.00,0.00,4.50,306.00,'2022-03-29 10:03:44','',''),(2617016,'1','201','1037',478,'Retail Sale Id 1464577',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 10:32:54','',''),(2617017,'1','201','1037',478,'Retail Sale Id 1464577',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 10:32:54','',''),(2617018,'1','201','1037',478,'Retail Sale Id 1464578',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 10:43:54','',''),(2617019,'1','201','1037',478,'Retail Sale Id 1464580',2896.80,0.00,0.00,4.26,289.68,'2022-03-29 10:53:07','',''),(2617020,'1','201','1037',478,'Retail Sale Id 1464581',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 10:58:20','',''),(2617021,'1','201','1037',478,'Retail Sale Id 1464582',680.00,0.00,0.00,1.00,68.00,'2022-03-29 11:00:23','',''),(2617022,'1','201','1037',478,'Retail Sale Id 1464583',8160.00,0.00,0.00,12.00,816.00,'2022-03-29 11:11:42','',''),(2617023,'1','201','1037',478,'Retail Sale Id 1464584',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 11:18:25','',''),(2617024,'1','201','1037',478,'Retail Sale Id 1464585',999.60,0.00,0.00,1.47,99.96,'2022-03-29 11:34:14','',''),(2617025,'1','201','1037',478,'Retail Sale Id 1464586',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 11:41:16','',''),(2617026,'1','201','1037',478,'Retail Sale Id 1464587',3699.20,0.00,0.00,5.44,369.92,'2022-03-29 11:43:05','',''),(2617027,'1','201','1037',478,'Retail Sale Id 1464588',3998.40,0.00,0.00,5.88,399.84,'2022-03-29 12:12:53','',''),(2617028,'1','201','1037',478,'Retail Sale Id 1464589',7996.80,0.00,0.00,11.76,799.68,'2022-03-29 12:14:54','',''),(2617029,'1','201','1037',478,'Retail Sale Id 1464590',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 12:18:40','',''),(2617030,'1','201','1037',478,'Retail Sale Id 1464591',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 12:23:47','',''),(2617031,'1','201','1037',478,'Retail Sale Id 1464592',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 12:30:00','',''),(2617032,'1','201','1037',478,'Retail Sale Id 1464593',1999.20,0.00,0.00,2.94,199.92,'2022-03-29 12:32:15','',''),(2617033,'1','201','1037',478,'Retail Sale Id 1464594',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 12:36:43','',''),(2617034,'1','201','1037',478,'Retail Sale Id 1464595',2720.00,0.00,0.00,4.00,272.00,'2022-03-29 12:42:01','',''),(2617035,'1','201','1037',478,'Retail Sale Id 1464596',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 12:53:56','',''),(2617036,'1','201','1037',478,'Retail Sale Id 1464597',2720.00,0.00,0.00,4.00,272.00,'2022-03-29 12:57:35','',''),(2617037,'1','201','1037',478,'Retail Sale Id 1464598',2998.80,0.00,0.00,4.41,299.88,'2022-03-29 13:11:13','',''),(2617038,'1','201','1037',478,'Retail Sale Id 1464599',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 13:16:22','',''),(2617039,'1','201','1037',478,'Retail Sale Id 1464600',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 13:48:20','',''),(2617040,'1','201','1037',478,'Retail Sale Id 1464601',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 13:49:57','',''),(2617041,'1','201','1037',478,'Retail Sale Id 1464602',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 14:07:16','',''),(2617042,'1','201','1037',478,'Retail Sale Id 1464603',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 14:21:24','',''),(2617043,'1','201','1037',478,'Retail Sale Id 1464604',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 14:35:51','',''),(2617044,'1','201','1037',478,'Retail Sale Id 1464605',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 14:50:52','',''),(2617045,'1','201','1037',478,'Retail Sale Id 1464606',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 15:04:52','',''),(2617046,'1','201','1037',478,'Retail Sale Id 1464607',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 15:08:48','',''),(2617047,'1','201','1037',478,'Retail Sale Id 1464608',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 15:09:47','',''),(2617048,'1','201','1037',478,'Retail Sale Id 1464609',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 15:13:34','',''),(2617049,'1','201','1037',478,'Retail Sale Id 1464610',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 15:16:35','',''),(2617050,'1','201','1037',478,'Retail Sale Id 1464611',6800.00,0.00,0.00,10.00,680.00,'2022-03-29 15:24:19','',''),(2617051,'1','201','1037',478,'Retail Sale Id 1464612',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 15:32:33','',''),(2617052,'1','201','1037',478,'Retail Sale Id 1464613',680.00,0.00,0.00,1.00,68.00,'2022-03-29 15:40:48','',''),(2617053,'1','201','1037',478,'Retail Sale Id 1464614',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 15:41:43','',''),(2617054,'1','201','1037',478,'Retail Sale Id 1464615',8160.00,0.00,0.00,12.00,816.00,'2022-03-29 15:52:09','',''),(2617055,'1','201','1037',478,'Retail Sale Id 1464616',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 15:57:43','',''),(2617056,'1','201','1037',478,'Retail Sale Id 1464617',2998.80,0.00,0.00,4.41,299.88,'2022-03-29 16:06:48','',''),(2617057,'1','201','1037',478,'Retail Sale Id 1464618',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 16:11:36','',''),(2617058,'1','201','1037',478,'Retail Sale Id 1464618',8160.00,0.00,0.00,12.00,816.00,'2022-03-29 16:11:36','',''),(2617059,'1','201','1037',478,'Retail Sale Id 1464619',2203.20,0.00,0.00,3.24,220.32,'2022-03-29 16:21:50','',''),(2617060,'1','201','1037',478,'Retail Sale Id 1464620',2203.20,0.00,0.00,3.24,220.32,'2022-03-29 16:35:07','',''),(2617061,'1','201','1037',478,'Retail Sale Id 1464621',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 16:36:26','',''),(2617062,'1','201','1037',478,'Retail Sale Id 1464622',4202.40,0.00,0.00,6.18,420.24,'2022-03-29 16:46:04','',''),(2617063,'1','201','1037',478,'Retail Sale Id 1464623',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 16:47:48','',''),(2617064,'1','201','1037',478,'Retail Sale Id 1464624',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 16:49:29','',''),(2617065,'1','201','1037',478,'Retail Sale Id 1464625',1196.80,0.00,0.00,1.76,119.68,'2022-03-29 16:57:10','',''),(2617066,'1','201','1037',478,'Retail Sale Id 1464626',8160.00,0.00,0.00,12.00,816.00,'2022-03-29 17:05:30','',''),(2617067,'1','201','1037',478,'Retail Sale Id 1464627',680.00,0.00,0.00,1.00,68.00,'2022-03-29 17:08:07','',''),(2617068,'1','201','1037',478,'Retail Sale Id 1464627',680.00,0.00,0.00,1.00,68.00,'2022-03-29 17:08:07','',''),(2617069,'1','201','1037',478,'Retail Sale Id 1464628',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 17:13:20','',''),(2617070,'1','201','1037',478,'Retail Sale Id 1464629',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 17:15:41','',''),(2617071,'1','201','1037',478,'Retail Sale Id 1464630',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 17:16:25','',''),(2617072,'1','201','1037',478,'Retail Sale Id 1464631',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 17:17:48','',''),(2617073,'1','201','1037',478,'Retail Sale Id 1464632',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 17:19:30','',''),(2617074,'1','201','1037',478,'Retail Sale Id 1464633',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 17:20:26','',''),(2617075,'1','201','1037',478,'Retail Sale Id 1464634',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 17:29:20','',''),(2617076,'1','201','1037',478,'Retail Sale Id 1464634',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 17:29:20','',''),(2617077,'1','201','1037',478,'Retail Sale Id 1464635',1700.00,0.00,0.00,2.50,170.00,'2022-03-29 17:32:50','',''),(2617078,'1','201','1037',478,'Retail Sale Id 1464636',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 17:33:52','',''),(2617079,'1','201','1037',478,'Retail Sale Id 1464637',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 17:37:50','',''),(2617080,'1','201','1037',478,'Retail Sale Id 1464638',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 17:38:56','',''),(2617081,'1','201','1037',478,'Retail Sale Id 1464639',7996.80,0.00,0.00,11.76,799.68,'2022-03-29 17:43:36','',''),(2617082,'1','201','1037',478,'Retail Sale Id 1464640',1999.20,0.00,0.00,2.94,199.92,'2022-03-29 17:44:39','',''),(2617083,'1','201','1037',478,'Retail Sale Id 1464641',3597.20,0.00,0.00,5.29,359.72,'2022-03-29 17:57:53','',''),(2617084,'1','201','1037',478,'Retail Sale Id 1464642',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 18:02:06','',''),(2617085,'1','201','1037',478,'Retail Sale Id 1464643',680.00,0.00,0.00,1.00,68.00,'2022-03-29 18:06:10','',''),(2617086,'1','201','1037',478,'Retail Sale Id 1464644',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 18:07:29','',''),(2617087,'1','201','1037',478,'Retail Sale Id 1464645',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 18:33:58','',''),(2617088,'1','201','1037',478,'Retail Sale Id 1464646',1360.00,0.00,0.00,2.00,136.00,'2022-03-29 18:35:16','',''),(2617089,'1','201','1037',478,'Retail Sale Id 1464647',6997.20,0.00,0.00,10.29,699.72,'2022-03-29 18:36:48','',''),(2617090,'1','201','1037',478,'Retail Sale Id 1464648',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 18:51:20','',''),(2617091,'1','201','1037',478,'Return of Retail Sale Id 1464640',0.00,1999.20,2.94,0.00,-199.92,'2022-03-29 19:25:30','',''),(2617092,'1','201','1037',478,'Retail Sale Id 1464649',1822.40,0.00,0.00,2.68,182.24,'2022-03-29 19:26:08','',''),(2617093,'1','201','1037',478,'Retail Sale Id 1464650',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 08:05:48','',''),(2617094,'1','201','1037',478,'Retail Sale Id 1464651',1999.20,0.00,0.00,2.94,199.92,'2022-03-30 08:24:11','',''),(2617095,'1','201','1037',478,'Retail Sale Id 1464652',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 08:26:46','',''),(2617096,'1','201','1037',478,'Retail Sale Id 1464653',999.60,0.00,0.00,1.47,99.96,'2022-03-30 08:33:01','',''),(2617097,'1','201','1037',478,'Retail Sale Id 1464654',3801.20,0.00,0.00,5.59,380.12,'2022-03-30 08:35:25','',''),(2617098,'1','201','1037',478,'Retail Sale Id 1464655',1999.20,0.00,0.00,2.94,199.92,'2022-03-30 08:51:25','',''),(2617099,'1','201','1037',478,'Retail Sale Id 1464656',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 08:55:33','',''),(2617100,'1','201','1037',478,'Retail Sale Id 1464657',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 08:59:14','',''),(2617101,'1','201','1037',478,'Retail Sale Id 1464658',999.60,0.00,0.00,1.47,99.96,'2022-03-30 09:04:24','',''),(2617102,'1','201','1037',478,'Retail Sale Id 1464659',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 09:15:59','',''),(2617103,'1','201','1037',478,'Retail Sale Id 1464660',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 09:27:33','',''),(2617104,'1','201','1037',478,'Retail Sale Id 1464661',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 09:29:58','',''),(2617105,'1','201','1037',478,'Retail Sale Id 1464662',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 09:51:30','',''),(2617106,'1','201','1037',478,'Retail Sale Id 1464663',4760.00,0.00,0.00,7.00,476.00,'2022-03-30 09:57:22','',''),(2617107,'1','201','1037',478,'Retail Sale Id 1464664',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 10:00:16','',''),(2617108,'1','201','1037',478,'Retail Sale Id 1464664',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 10:00:16','',''),(2617109,'1','201','1037',478,'Retail Sale Id 1464665',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 10:07:48','',''),(2617110,'1','201','1037',478,'Retail Sale Id 1464666',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 10:24:14','',''),(2617111,'1','201','1037',478,'Retail Sale Id 1464667',3060.00,0.00,0.00,4.50,306.00,'2022-03-30 10:31:06','',''),(2617112,'1','201','1037',478,'Retail Sale Id 1464668',2720.00,0.00,0.00,4.00,272.00,'2022-03-30 10:33:46','',''),(2617113,'1','201','1037',478,'Retail Sale Id 1464669',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 11:07:51','',''),(2617114,'1','201','1037',478,'Retail Sale Id 1464670',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 11:12:16','',''),(2617115,'1','201','1037',478,'Retail Sale Id 1464671',7996.80,0.00,0.00,11.76,799.68,'2022-03-30 11:32:52','',''),(2617116,'1','201','1037',478,'Retail Sale Id 1464672',1740.80,0.00,0.00,2.56,174.08,'2022-03-30 11:34:59','',''),(2617117,'1','201','1037',478,'Retail Sale Id 1464673',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 11:38:32','',''),(2617118,'1','201','1037',478,'Retail Sale Id 1464674',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 11:41:33','',''),(2617119,'1','201','1037',478,'Retail Sale Id 1464674',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 11:41:33','',''),(2617120,'1','201','1037',478,'Retail Sale Id 1464675',3998.40,0.00,0.00,5.88,399.84,'2022-03-30 11:43:11','',''),(2617121,'1','201','1037',478,'Retail Sale Id 1464676',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 11:47:12','',''),(2617122,'1','201','1037',478,'Retail Sale Id 1464677',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 11:49:47','',''),(2617123,'1','201','1037',478,'Retail Sale Id 1464678',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 11:52:22','',''),(2617124,'1','201','1037',478,'Retail Sale Id 1464679',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 12:16:54','',''),(2617125,'1','201','1037',478,'Retail Sale Id 1464680',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 12:28:01','',''),(2617126,'1','201','1037',478,'Retail Sale Id 1464681',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 12:31:24','',''),(2617127,'1','201','1037',478,'Retail Sale Id 1464682',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 12:41:46','',''),(2617128,'1','201','1037',478,'Retail Sale Id 1464683',2720.00,0.00,0.00,4.00,272.00,'2022-03-30 12:50:13','',''),(2617129,'1','201','1037',478,'Retail Sale Id 1464684',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 13:01:52','',''),(2617130,'1','201','1037',478,'Retail Sale Id 1464685',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 13:04:25','',''),(2617131,'1','201','1037',478,'Return of Retail Sale Id 1464672',0.00,1740.80,2.56,0.00,-174.08,'2022-03-30 13:07:02','',''),(2617132,'1','201','1037',478,'Retail Sale Id 1464686',999.60,0.00,0.00,1.47,99.96,'2022-03-30 13:20:38','',''),(2617133,'1','201','1037',478,'Retail Sale Id 1464687',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 13:23:06','',''),(2617134,'1','201','1037',478,'Retail Sale Id 1464688',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 13:25:24','',''),(2617135,'1','201','1037',478,'Retail Sale Id 1464689',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 13:27:30','',''),(2617136,'1','201','1037',478,'Retail Sale Id 1464689',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 13:27:30','',''),(2617137,'1','201','1037',478,'Retail Sale Id 1464690',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 13:28:26','',''),(2617138,'1','201','1037',478,'Retail Sale Id 1464691',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 13:29:23','',''),(2617139,'1','201','1037',478,'Retail Sale Id 1464692',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 13:31:49','',''),(2617140,'1','201','1037',478,'Retail Sale Id 1464693',2720.00,0.00,0.00,4.00,272.00,'2022-03-30 13:34:38','',''),(2617141,'1','201','1037',478,'Retail Sale Id 1464694',4760.00,0.00,0.00,7.00,476.00,'2022-03-30 13:35:22','',''),(2617142,'1','201','1037',478,'Retail Sale Id 1464695',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 13:41:18','',''),(2617143,'1','201','1037',478,'Retail Sale Id 1464696',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 13:50:07','',''),(2617144,'1','201','1037',478,'Retail Sale Id 1464697',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 14:00:40','',''),(2617145,'1','201','1037',478,'Retail Sale Id 1464698',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 14:03:05','',''),(2617146,'1','201','1037',478,'Retail Sale Id 1464699',6120.00,0.00,0.00,9.00,612.00,'2022-03-30 14:05:19','',''),(2617147,'1','201','1037',478,'Retail Sale Id 1464700',7140.00,0.00,0.00,10.50,714.00,'2022-03-30 14:08:31','',''),(2617148,'1','201','1037',478,'Retail Sale Id 1464701',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 14:09:18','',''),(2617149,'1','201','1037',478,'Retail Sale Id 1464702',8160.00,0.00,0.00,12.00,816.00,'2022-03-30 14:25:53','',''),(2617150,'1','201','1037',478,'Retail Sale Id 1464703',1926.00,0.00,0.00,3.00,90.00,'2022-03-30 14:37:08','',''),(2617151,'1','201','1037',478,'Retail Sale Id 1464704',1926.00,0.00,0.00,3.00,90.00,'2022-03-30 14:38:14','',''),(2617152,'1','201','1037',478,'Retail Sale Id 1464705',1502.80,0.00,0.00,2.21,150.28,'2022-03-30 15:02:43','',''),(2617153,'1','201','1037',478,'Retail Sale Id 1464706',680.00,0.00,0.00,1.00,68.00,'2022-03-30 15:19:55','',''),(2617154,'1','201','1037',478,'Retail Sale Id 1464707',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 15:24:03','',''),(2617155,'1','201','1037',478,'Retail Sale Id 1464707',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 15:24:03','',''),(2617156,'1','201','1037',478,'Retail Sale Id 1464708',7480.00,0.00,0.00,11.00,748.00,'2022-03-30 15:25:16','',''),(2617157,'1','201','1037',478,'Retail Sale Id 1464709',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 15:28:01','',''),(2617158,'1','201','1037',478,'Retail Sale Id 1464710',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 15:42:35','',''),(2617159,'1','201','1037',478,'Retail Sale Id 1464711',680.00,0.00,0.00,1.00,68.00,'2022-03-30 15:43:48','',''),(2617160,'1','201','1037',478,'Retail Sale Id 1464712',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 15:44:58','',''),(2617161,'1','201','1037',478,'Retail Sale Id 1464713',4760.00,0.00,0.00,7.00,476.00,'2022-03-30 15:52:38','',''),(2617162,'1','201','1037',478,'Retail Sale Id 1464714',2998.80,0.00,0.00,4.41,299.88,'2022-03-30 15:53:50','',''),(2617163,'1','201','1037',478,'Retail Sale Id 1464715',8160.00,0.00,0.00,12.00,816.00,'2022-03-30 15:55:16','',''),(2617164,'1','201','1037',478,'Retail Sale Id 1464716',6800.00,0.00,0.00,10.00,680.00,'2022-03-30 16:00:25','',''),(2617165,'1','201','1037',478,'Retail Sale Id 1464717',680.00,0.00,0.00,1.00,68.00,'2022-03-30 16:02:12','',''),(2617166,'1','201','1037',478,'Retail Sale Id 1464718',1999.20,0.00,0.00,2.94,199.92,'2022-03-30 16:11:07','',''),(2617167,'1','201','1037',478,'Retail Sale Id 1464719',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 16:16:33','',''),(2617168,'1','201','1037',478,'Retail Sale Id 1464720',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 16:17:07','',''),(2617169,'1','201','1037',478,'Retail Sale Id 1464721',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 16:17:37','',''),(2617170,'1','201','1037',478,'Retail Sale Id 1464722',680.00,0.00,0.00,1.00,68.00,'2022-03-30 16:18:09','',''),(2617171,'1','201','1037',478,'Retail Sale Id 1464723',2720.00,0.00,0.00,4.00,272.00,'2022-03-30 16:20:24','',''),(2617172,'1','201','1037',478,'Retail Sale Id 1464724',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 16:33:04','',''),(2617173,'1','201','1037',478,'Retail Sale Id 1464725',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 16:36:18','',''),(2617174,'1','201','1037',478,'Retail Sale Id 1464726',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 16:37:27','',''),(2617175,'1','201','1037',478,'Retail Sale Id 1464727',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 16:45:43','',''),(2617176,'1','201','1037',478,'Retail Sale Id 1464728',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 16:46:46','',''),(2617177,'1','201','1037',478,'Retail Sale Id 1464729',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 16:49:51','',''),(2617178,'1','201','1037',478,'Retail Sale Id 1464730',5997.60,0.00,0.00,8.82,599.76,'2022-03-30 16:51:35','',''),(2617179,'1','201','1037',478,'Retail Sale Id 1464731',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 16:54:31','',''),(2617180,'1','201','1037',478,'Retail Sale Id 1464732',1700.00,0.00,0.00,2.50,170.00,'2022-03-30 16:59:43','',''),(2617181,'1','201','1037',478,'Retail Sale Id 1464733',2380.00,0.00,0.00,3.50,238.00,'2022-03-30 17:10:31','',''),(2617182,'1','201','1037',478,'Retail Sale Id 1464734',2998.80,0.00,0.00,4.41,299.88,'2022-03-30 17:17:56','',''),(2617183,'1','201','1037',478,'Retail Sale Id 1464735',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 17:18:27','',''),(2617184,'1','201','1037',478,'Retail Sale Id 1464736',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 17:24:58','',''),(2617185,'1','201','1037',478,'Retail Sale Id 1464737',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 17:26:13','',''),(2617186,'1','201','1037',478,'Retail Sale Id 1464738',2998.80,0.00,0.00,4.41,299.88,'2022-03-30 17:39:26','',''),(2617187,'1','201','1037',478,'Retail Sale Id 1464739',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 17:45:12','',''),(2617188,'1','201','1037',478,'Retail Sale Id 1464740',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 17:47:41','',''),(2617189,'1','201','1037',478,'Retail Sale Id 1464741',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 17:54:14','',''),(2617190,'1','201','1037',478,'Retail Sale Id 1464742',1196.80,0.00,0.00,1.76,119.68,'2022-03-30 17:56:37','',''),(2617191,'1','201','1037',478,'Retail Sale Id 1464743',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 17:57:48','',''),(2617192,'1','201','1037',478,'Retail Sale Id 1464744',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 18:03:49','',''),(2617193,'1','201','1037',478,'Retail Sale Id 1464745',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 18:11:20','',''),(2617194,'1','201','1037',478,'Retail Sale Id 1464746',2998.80,0.00,0.00,4.41,299.88,'2022-03-30 18:12:22','',''),(2617195,'1','201','1037',478,'Retail Sale Id 1464747',4760.00,0.00,0.00,7.00,476.00,'2022-03-30 18:14:47','',''),(2617196,'1','201','1037',478,'Retail Sale Id 1464748',4692.00,0.00,0.00,6.90,469.20,'2022-03-30 18:20:48','',''),(2617197,'1','201','1037',478,'Return of Retail Sale Id 1464747',0.00,4760.00,7.00,0.00,-476.00,'2022-03-30 18:24:21','',''),(2617198,'1','201','1037',478,'Retail Sale Id 1464749',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 18:26:36','',''),(2617199,'1','201','1037',478,'Retail Sale Id 1464751',8500.00,0.00,0.00,12.50,850.00,'2022-03-30 18:54:05','',''),(2617200,'1','201','1037',478,'Return of Retail Sale Id 1464744',0.00,8500.00,12.50,0.00,-850.00,'2022-03-30 19:55:53','',''),(2617201,'1','201','1037',478,'Retail Sale Id 1464752',3359.20,0.00,0.00,4.94,335.92,'2022-03-30 19:56:32','',''),(2617202,'1','201','1037',478,'Retail Sale Id 1464753',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 07:49:17','',''),(2617203,'1','201','1037',478,'Retail Sale Id 1464754',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 07:50:21','',''),(2617204,'1','201','1037',478,'Retail Sale Id 1464755',6800.00,0.00,0.00,10.00,680.00,'2022-03-31 07:57:33','',''),(2617205,'1','201','1037',478,'Retail Sale Id 1464756',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 08:10:32','',''),(2617206,'1','201','1037',478,'Retail Sale Id 1464757',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 08:11:54','',''),(2617207,'1','201','1037',478,'Retail Sale Id 1464758',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 08:22:59','',''),(2617208,'1','201','1037',478,'Retail Sale Id 1464759',503.20,0.00,0.00,0.74,50.32,'2022-03-31 08:38:38','',''),(2617209,'1','201','1037',478,'Retail Sale Id 1464760',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 08:53:32','',''),(2617210,'1','201','1037',478,'Retail Sale Id 1464761',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 09:04:44','',''),(2617211,'1','201','1037',478,'Retail Sale Id 1464762',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 09:07:12','',''),(2617212,'1','201','1037',478,'Retail Sale Id 1464763',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 09:09:41','',''),(2617213,'1','201','1037',478,'Retail Sale Id 1464764',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 09:18:21','',''),(2617214,'1','201','1037',478,'Retail Sale Id 1464765',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 09:39:26','',''),(2617215,'1','201','1037',478,'Retail Sale Id 1464766',680.00,0.00,0.00,1.00,68.00,'2022-03-31 09:41:00','',''),(2617216,'1','201','1037',478,'Retail Sale Id 1464767',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 09:50:05','',''),(2617217,'1','201','1037',478,'Retail Sale Id 1464768',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 10:02:39','',''),(2617218,'1','201','1037',478,'Retail Sale Id 1464769',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 10:06:45','',''),(2617219,'1','201','1037',478,'Retail Sale Id 1464770',6800.00,0.00,0.00,10.00,680.00,'2022-03-31 10:11:17','',''),(2617220,'1','201','1037',478,'Retail Sale Id 1464771',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 10:21:03','',''),(2617221,'1','201','1037',478,'Retail Sale Id 1464772',1700.00,0.00,0.00,2.50,170.00,'2022-03-31 10:22:45','',''),(2617222,'1','201','1037',478,'Retail Sale Id 1464773',2998.80,0.00,0.00,4.41,299.88,'2022-03-31 10:35:54','',''),(2617223,'1','201','1037',478,'Retail Sale Id 1464774',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 10:46:49','',''),(2617224,'1','201','1037',478,'Retail Sale Id 1464775',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 10:47:47','',''),(2617225,'1','201','1037',478,'Retail Sale Id 1464775',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 10:47:47','',''),(2617226,'1','201','1037',478,'Retail Sale Id 1464776',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 10:51:39','',''),(2617227,'1','201','1037',478,'Retail Sale Id 1464777',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 10:59:30','',''),(2617228,'1','201','1037',478,'Retail Sale Id 1464778',2998.80,0.00,0.00,4.41,299.88,'2022-03-31 11:01:20','',''),(2617229,'1','201','1037',478,'Retail Sale Id 1464779',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 11:10:48','',''),(2617230,'1','201','1037',478,'Retail Sale Id 1464780',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 11:24:45','',''),(2617231,'1','201','1037',478,'Retail Sale Id 1464781',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 11:28:02','',''),(2617232,'1','201','1037',478,'Retail Sale Id 1464782',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 11:33:51','',''),(2617233,'1','201','1037',478,'Retail Sale Id 1464783',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 11:45:49','',''),(2617234,'1','201','1037',478,'Retail Sale Id 1464784',8160.00,0.00,0.00,12.00,816.00,'2022-03-31 11:51:03','',''),(2617235,'1','201','1037',478,'Retail Sale Id 1464785',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 11:53:22','',''),(2617236,'1','201','1037',478,'Retail Sale Id 1464786',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 11:54:18','',''),(2617237,'1','201','1037',478,'Retail Sale Id 1464787',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 12:01:54','',''),(2617238,'1','201','1037',478,'Retail Sale Id 1464788',4760.00,0.00,0.00,7.00,476.00,'2022-03-31 12:10:11','',''),(2617239,'1','201','1037',478,'Retail Sale Id 1464789',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 12:15:59','',''),(2617240,'1','201','1037',478,'Retail Sale Id 1464790',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 12:27:25','',''),(2617241,'1','201','1037',478,'Retail Sale Id 1464791',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 12:33:06','',''),(2617242,'1','201','1037',478,'Retail Sale Id 1464792',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 12:35:24','',''),(2617243,'1','201','1037',478,'Retail Sale Id 1464793',6420.00,0.00,0.00,10.00,300.00,'2022-03-31 12:39:09','',''),(2617244,'1','201','1037',478,'Retail Sale Id 1464794',4494.00,0.00,0.00,7.00,210.00,'2022-03-31 12:41:01','',''),(2617245,'1','201','1037',478,'Retail Sale Id 1464795',4494.00,0.00,0.00,7.00,210.00,'2022-03-31 12:42:14','',''),(2617246,'1','201','1037',478,'Retail Sale Id 1464796',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 12:51:32','',''),(2617247,'1','201','1037',478,'Retail Sale Id 1464797',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 12:53:13','',''),(2617248,'1','201','1037',478,'Retail Sale Id 1464798',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 12:53:58','',''),(2617249,'1','201','1037',478,'Retail Sale Id 1464799',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 13:09:53','',''),(2617250,'1','201','1037',478,'Retail Sale Id 1464800',3638.00,0.00,0.00,5.35,363.80,'2022-03-31 13:10:44','',''),(2617251,'1','201','1037',478,'Retail Sale Id 1464801',1999.20,0.00,0.00,2.94,199.92,'2022-03-31 13:13:06','',''),(2617252,'1','201','1037',478,'Retail Sale Id 1464802',680.00,0.00,0.00,1.00,68.00,'2022-03-31 13:16:05','',''),(2617253,'1','201','1037',478,'Retail Sale Id 1464803',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 13:25:16','',''),(2617254,'1','201','1037',478,'Retail Sale Id 1464804',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 13:31:05','',''),(2617255,'1','201','1037',478,'Retail Sale Id 1464805',3998.40,0.00,0.00,5.88,399.84,'2022-03-31 13:32:44','',''),(2617256,'1','201','1037',478,'Retail Sale Id 1464806',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 13:37:17','',''),(2617257,'1','201','1037',478,'Retail Sale Id 1464807',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 13:52:36','',''),(2617258,'1','201','1037',478,'Retail Sale Id 1464808',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 13:53:54','',''),(2617259,'1','201','1037',478,'Retail Sale Id 1464809',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 14:00:34','',''),(2617260,'1','201','1037',478,'Retail Sale Id 1464810',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 14:01:08','',''),(2617261,'1','201','1037',478,'Retail Sale Id 1464811',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 14:10:07','',''),(2617262,'1','201','1037',478,'Retail Sale Id 1464812',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 14:16:37','',''),(2617263,'1','201','1037',478,'Retail Sale Id 1464813',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 14:37:32','',''),(2617264,'1','201','1037',478,'Retail Sale Id 1464814',6800.00,0.00,0.00,10.00,680.00,'2022-03-31 14:44:10','',''),(2617265,'1','201','1037',478,'Retail Sale Id 1464815',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 14:45:13','',''),(2617266,'1','201','1037',478,'Retail Sale Id 1464816',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 14:51:21','',''),(2617267,'1','201','1037',478,'Retail Sale Id 1464817',3740.00,0.00,0.00,5.50,374.00,'2022-03-31 15:02:09','',''),(2617268,'1','201','1037',478,'Retail Sale Id 1464818',7996.80,0.00,0.00,11.76,799.68,'2022-03-31 15:08:35','',''),(2617269,'1','201','1037',478,'Retail Sale Id 1464818',7996.80,0.00,0.00,11.76,799.68,'2022-03-31 15:08:35','',''),(2617270,'1','201','1037',478,'Retail Sale Id 1464819',2998.80,0.00,0.00,4.41,299.88,'2022-03-31 15:09:50','',''),(2617271,'1','201','1037',478,'Retail Sale Id 1464820',3631.20,0.00,0.00,5.34,363.12,'2022-03-31 15:11:39','',''),(2617272,'1','201','1037',478,'Return of Retail Sale Id 1464817',0.00,3740.00,5.50,0.00,-374.00,'2022-03-31 15:13:21','',''),(2617273,'1','201','1037',478,'Retail Sale Id 1464821',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 15:25:30','',''),(2617274,'1','201','1037',478,'Retail Sale Id 1464822',2380.00,0.00,0.00,3.50,238.00,'2022-03-31 15:27:18','',''),(2617275,'1','201','1037',478,'Retail Sale Id 1464823',1802.00,0.00,0.00,2.65,180.20,'2022-03-31 15:28:59','',''),(2617276,'1','201','1037',478,'Retail Sale Id 1464824',7996.80,0.00,0.00,11.76,799.68,'2022-03-31 15:33:33','',''),(2617277,'1','201','1037',478,'Retail Sale Id 1464825',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 15:39:04','',''),(2617278,'1','201','1037',478,'Retail Sale Id 1464825',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 15:39:04','',''),(2617279,'1','201','1037',478,'Retail Sale Id 1464827',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 15:41:49','',''),(2617280,'1','201','1037',478,'Retail Sale Id 1464827',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 15:41:49','',''),(2617281,'1','201','1037',478,'Retail Sale Id 1464828',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 15:43:43','',''),(2617282,'1','201','1037',478,'Retail Sale Id 1464829',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 15:44:33','',''),(2617283,'1','201','1037',478,'Retail Sale Id 1464830',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 15:51:46','',''),(2617284,'1','201','1037',478,'Retail Sale Id 1464831',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 15:57:16','',''),(2617285,'1','201','1037',478,'Retail Sale Id 1464832',4760.00,0.00,0.00,7.00,476.00,'2022-03-31 16:03:52','',''),(2617286,'1','201','1037',478,'Retail Sale Id 1464833',2998.80,0.00,0.00,4.41,299.88,'2022-03-31 16:07:02','',''),(2617287,'1','201','1037',478,'Retail Sale Id 1464834',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 16:09:09','',''),(2617288,'1','201','1037',478,'Retail Sale Id 1464835',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 16:16:30','',''),(2617289,'1','201','1037',478,'Retail Sale Id 1464836',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 16:33:45','',''),(2617290,'1','201','1037',478,'Retail Sale Id 1464837',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 16:35:49','',''),(2617291,'1','201','1037',478,'Retail Sale Id 1464838',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 16:37:56','',''),(2617292,'1','201','1037',478,'Retail Sale Id 1464839',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 16:42:14','',''),(2617293,'1','201','1037',478,'Retail Sale Id 1464840',999.60,0.00,0.00,1.47,99.96,'2022-03-31 16:52:42','',''),(2617294,'1','201','1037',478,'Retail Sale Id 1464841',999.60,0.00,0.00,1.47,99.96,'2022-03-31 16:53:56','',''),(2617295,'1','201','1037',478,'Retail Sale Id 1464842',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 16:55:25','',''),(2617296,'1','201','1037',478,'Retail Sale Id 1464843',680.00,0.00,0.00,1.00,68.00,'2022-03-31 16:56:36','',''),(2617297,'1','201','1037',478,'Retail Sale Id 1464844',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 16:57:37','',''),(2617298,'1','201','1037',478,'Retail Sale Id 1464845',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 17:04:23','',''),(2617299,'1','201','1037',478,'Retail Sale Id 1464846',6800.00,0.00,0.00,10.00,680.00,'2022-03-31 17:16:49','',''),(2617300,'1','201','1037',478,'Retail Sale Id 1464847',680.00,0.00,0.00,1.00,68.00,'2022-03-31 17:17:35','',''),(2617301,'1','201','1037',478,'Retail Sale Id 1464848',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 17:18:37','',''),(2617302,'1','201','1037',478,'Retail Sale Id 1464849',5997.60,0.00,0.00,8.82,599.76,'2022-03-31 17:19:37','',''),(2617303,'1','201','1037',478,'Retail Sale Id 1464850',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 17:20:23','',''),(2617304,'1','201','1037',478,'Retail Sale Id 1464851',2998.80,0.00,0.00,4.41,299.88,'2022-03-31 17:21:05','',''),(2617305,'1','201','1037',478,'Retail Sale Id 1464852',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 17:22:00','',''),(2617306,'1','201','1037',478,'Retail Sale Id 1464853',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 17:22:30','',''),(2617307,'1','201','1037',478,'Retail Sale Id 1464854',680.00,0.00,0.00,1.00,68.00,'2022-03-31 17:25:25','',''),(2617308,'1','201','1037',478,'Retail Sale Id 1464855',2998.80,0.00,0.00,4.41,299.88,'2022-03-31 17:27:58','',''),(2617309,'1','201','1037',478,'Retail Sale Id 1464856',680.00,0.00,0.00,1.00,68.00,'2022-03-31 17:30:26','',''),(2617310,'1','201','1037',478,'Retail Sale Id 1464857',2998.80,0.00,0.00,4.41,299.88,'2022-03-31 17:31:43','',''),(2617311,'1','201','1037',478,'Retail Sale Id 1464858',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 17:35:10','',''),(2617312,'1','201','1037',478,'Retail Sale Id 1464859',1999.20,0.00,0.00,2.94,199.92,'2022-03-31 17:38:54','',''),(2617313,'1','201','1037',478,'Retail Sale Id 1464860',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 17:40:45','',''),(2617314,'1','201','1037',478,'Retail Sale Id 1464861',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 17:43:12','',''),(2617315,'1','201','1037',478,'Retail Sale Id 1464861',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 17:43:12','',''),(2617316,'1','201','1037',478,'Retail Sale Id 1464861',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 17:43:12','',''),(2617317,'1','201','1037',478,'Retail Sale Id 1464862',999.60,0.00,0.00,1.47,99.96,'2022-03-31 17:47:12','',''),(2617318,'1','201','1037',478,'Retail Sale Id 1464863',680.00,0.00,0.00,1.00,68.00,'2022-03-31 17:48:01','',''),(2617319,'1','201','1037',478,'Retail Sale Id 1464864',4420.00,0.00,0.00,6.50,442.00,'2022-03-31 17:57:36','',''),(2617320,'1','201','1037',478,'Retail Sale Id 1464865',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 17:58:21','',''),(2617321,'1','201','1037',478,'Retail Sale Id 1464866',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 18:01:38','',''),(2617322,'1','201','1037',478,'Retail Sale Id 1464867',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 18:03:03','',''),(2617323,'1','201','1037',478,'Retail Sale Id 1464868',1502.80,0.00,0.00,2.21,150.28,'2022-03-31 18:08:21','',''),(2617324,'1','201','1037',478,'Retail Sale Id 1464869',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 18:14:26','',''),(2617325,'1','201','1037',478,'Retail Sale Id 1464870',706.20,0.00,0.00,1.10,33.00,'2022-03-31 18:16:28','',''),(2617326,'1','201','1037',478,'Retail Sale Id 1464871',537.20,0.00,0.00,0.79,53.72,'2022-03-31 18:22:17','',''),(2617327,'1','201','1037',478,'Retail Sale Id 1464872',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 18:24:47','',''),(2617328,'1','201','1037',478,'Retail Sale Id 1464873',1360.00,0.00,0.00,2.00,136.00,'2022-03-31 18:25:53','',''),(2617329,'1','201','1037',478,'Retail Sale Id 1464874',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 18:26:27','',''),(2617330,'1','201','1037',478,'Retail Sale Id 1464875',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 18:27:24','',''),(2617331,'1','201','1037',478,'Retail Sale Id 1464876',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 18:31:06','',''),(2617332,'1','201','1037',478,'Retail Sale Id 1464877',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 18:34:49','',''),(2617333,'1','201','1037',478,'Retail Sale Id 1464878',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 18:36:22','',''),(2617334,'1','201','1037',478,'Retail Sale Id 1464879',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 18:39:34','',''),(2617335,'1','201','1037',478,'Retail Sale Id 1464880',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 18:40:46','',''),(2617336,'1','201','1037',478,'Retail Sale Id 1464881',8025.00,0.00,0.00,12.50,375.00,'2022-03-31 19:24:15','',''),(2617337,'1','201','1037',478,'Return of Retail Sale Id 1464875',0.00,2040.00,3.00,0.00,-204.00,'2022-03-31 19:26:06','',''),(2617338,'1','201','1037',478,'Retail Sale Id 1464882',1373.60,0.00,0.00,2.02,137.36,'2022-03-31 19:26:56','',''),(2617339,'1','201','1037',478,'Return of Retail Sale Id 1464882',0.00,1373.60,2.02,0.00,-137.36,'2022-03-31 19:29:07','',''),(2617340,'1','201','1037',478,'Retail Sale Id 1464883',1353.20,0.00,0.00,1.99,135.32,'2022-03-31 19:32:08','',''),(2617341,'1','201','1037',478,'Retail Sale Id 1464884',20.40,0.00,0.00,0.03,2.04,'2022-03-31 19:33:31','',''),(2617342,'1','201','1037',478,'Return of Retail Sale Id 1464884',0.00,20.40,0.03,0.00,-2.04,'2022-03-31 19:44:28','',''),(2617343,'1','201','1037',478,'Return of Retail Sale Id 1464883',0.00,1353.20,1.99,0.00,-135.32,'2022-03-31 19:45:04','',''),(2617344,'1','201','1037',478,'Retail Sale Id 1464885',1353.20,0.00,0.00,1.99,135.32,'2022-03-31 19:47:02','',''),(2617345,'1','201','1037',478,'Return of Retail Sale Id 1464885',0.00,1353.20,1.99,0.00,-135.32,'2022-03-31 19:47:56','',''),(2617346,'1','201','1037',478,'Retail Sale Id 1464886',1373.60,0.00,0.00,2.02,137.36,'2022-03-31 19:49:35','',''),(2617347,'1','201','1037',478,'Retail Sale Id 1464887',8125.00,0.00,0.00,12.50,475.00,'2022-04-01 07:29:07','',''),(2617348,'1','201','1037',478,'Retail Sale Id 1464888',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 07:47:02','',''),(2617349,'1','201','1037',478,'Retail Sale Id 1464889',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 07:47:59','',''),(2617350,'1','201','1037',478,'Retail Sale Id 1464890',8125.00,0.00,0.00,12.50,475.00,'2022-04-01 08:01:59','',''),(2617351,'1','201','1037',478,'Retail Sale Id 1464891',6500.00,0.00,0.00,10.00,380.00,'2022-04-01 08:07:20','',''),(2617352,'1','201','1037',478,'Retail Sale Id 1464892',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 08:10:50','',''),(2617353,'1','201','1037',478,'Retail Sale Id 1464893',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 08:13:40','',''),(2617354,'1','201','1037',478,'Retail Sale Id 1464894',62000.00,0.00,0.00,100.00,800.00,'2022-04-01 08:22:20','',''),(2617355,'1','201','1037',478,'Retail Sale Id 1464895',650.00,0.00,0.00,1.00,38.00,'2022-04-01 08:23:42','',''),(2617356,'1','201','1037',478,'Retail Sale Id 1464896',3100.00,0.00,0.00,5.00,40.00,'2022-04-01 08:29:26','',''),(2617357,'1','201','1037',478,'Retail Sale Id 1464897',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 08:34:35','',''),(2617358,'1','201','1037',478,'Retail Sale Id 1464898',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 08:37:38','',''),(2617359,'1','201','1037',478,'Retail Sale Id 1464899',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 08:43:08','',''),(2617360,'1','201','1037',478,'Retail Sale Id 1464900',31000.00,0.00,0.00,50.00,400.00,'2022-04-01 08:47:09','',''),(2617361,'1','201','1037',478,'Retail Sale Id 1464901',650.00,0.00,0.00,1.00,38.00,'2022-04-01 08:49:14','',''),(2617362,'1','201','1037',478,'Retail Sale Id 1464902',7000.50,0.00,0.00,10.77,409.26,'2022-04-01 08:54:18','',''),(2617363,'1','201','1037',478,'Retail Sale Id 1464903',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 09:03:28','',''),(2617364,'1','201','1037',478,'Retail Sale Id 1464904',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 09:13:12','',''),(2617365,'1','201','1037',478,'Retail Sale Id 1464906',5200.00,0.00,0.00,8.00,304.00,'2022-04-01 09:15:17','',''),(2617366,'1','201','1037',478,'Retail Sale Id 1464907',4550.00,0.00,0.00,7.00,266.00,'2022-04-01 09:19:13','',''),(2617367,'1','201','1037',478,'Retail Sale Id 1464908',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 09:21:57','',''),(2617368,'1','201','1037',478,'Retail Sale Id 1464909',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 09:30:38','',''),(2617369,'1','201','1037',478,'Retail Sale Id 1464910',4550.00,0.00,0.00,7.00,266.00,'2022-04-01 09:33:39','',''),(2617370,'1','201','1037',478,'Retail Sale Id 1464911',2002.00,0.00,0.00,3.08,117.04,'2022-04-01 09:34:42','',''),(2617371,'1','201','1037',478,'Retail Sale Id 1464912',1001.00,0.00,0.00,1.54,58.52,'2022-04-01 09:37:18','',''),(2617372,'1','201','1037',478,'Retail Sale Id 1464913',650.00,0.00,0.00,1.00,38.00,'2022-04-01 09:42:40','',''),(2617373,'1','201','1037',478,'Retail Sale Id 1464914',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 09:44:13','',''),(2617374,'1','201','1037',478,'Retail Sale Id 1464915',3997.50,0.00,0.00,6.15,233.70,'2022-04-01 09:44:53','',''),(2617375,'1','201','1037',478,'Retail Sale Id 1464916',2002.00,0.00,0.00,3.08,117.04,'2022-04-01 10:02:15','',''),(2617376,'1','201','1037',478,'Retail Sale Id 1464917',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 10:03:30','',''),(2617377,'1','201','1037',478,'Retail Sale Id 1464918',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 10:04:39','',''),(2617378,'1','201','1037',478,'Retail Sale Id 1464919',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 10:06:21','',''),(2617379,'1','201','1037',478,'Retail Sale Id 1464920',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 10:07:20','',''),(2617380,'1','201','1037',478,'Retail Sale Id 1464921',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 10:08:39','',''),(2617381,'1','201','1037',478,'Retail Sale Id 1464922',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 10:10:20','',''),(2617382,'1','201','1037',478,'Retail Sale Id 1464923',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 10:11:12','',''),(2617383,'1','201','1037',478,'Retail Sale Id 1464924',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 10:12:41','',''),(2617384,'1','201','1037',478,'Retail Sale Id 1464925',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 10:15:03','',''),(2617385,'1','201','1037',478,'Retail Sale Id 1464926',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 10:16:21','',''),(2617386,'1','201','1037',478,'Retail Sale Id 1464927',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 10:18:55','',''),(2617387,'1','201','1037',478,'Retail Sale Id 1464928',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 10:26:23','',''),(2617388,'1','201','1037',478,'Retail Sale Id 1464929',7501.00,0.00,0.00,11.54,438.52,'2022-04-01 10:30:26','',''),(2617389,'1','201','1037',478,'Retail Sale Id 1464930',6500.00,0.00,0.00,10.00,380.00,'2022-04-01 10:32:32','',''),(2617390,'1','201','1037',478,'Retail Sale Id 1464930',7800.00,0.00,0.00,12.00,456.00,'2022-04-01 10:32:32','',''),(2617391,'1','201','1037',478,'Retail Sale Id 1464931',8125.00,0.00,0.00,12.50,475.00,'2022-04-01 10:33:46','',''),(2617392,'1','201','1037',478,'Retail Sale Id 1464932',1800.50,0.00,0.00,2.77,105.26,'2022-04-01 10:36:37','',''),(2617393,'1','201','1037',478,'Retail Sale Id 1464933',4511.00,0.00,0.00,6.94,263.72,'2022-04-01 10:41:22','',''),(2617394,'1','201','1037',478,'Retail Sale Id 1464934',3997.50,0.00,0.00,6.15,233.70,'2022-04-01 10:43:42','',''),(2617395,'1','201','1037',478,'Retail Sale Id 1464935',2197.00,0.00,0.00,3.38,128.44,'2022-04-01 10:44:57','',''),(2617396,'1','201','1037',478,'Retail Sale Id 1464936',4550.00,0.00,0.00,7.00,266.00,'2022-04-01 10:50:54','',''),(2617397,'1','201','1037',478,'Return of Retail Sale Id 1464907',0.00,4550.00,7.00,0.00,-266.00,'2022-04-01 11:01:50','',''),(2617398,'1','201','1037',478,'Retail Sale Id 1464937',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 11:06:30','',''),(2617399,'1','201','1037',478,'Retail Sale Id 1464938',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 11:07:52','',''),(2617400,'1','201','1037',478,'Retail Sale Id 1464939',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 11:20:21','',''),(2617401,'1','201','1037',478,'Retail Sale Id 1464940',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 11:21:37','',''),(2617402,'1','201','1037',478,'Retail Sale Id 1464941',2275.00,0.00,0.00,3.50,133.00,'2022-04-01 11:22:37','',''),(2617403,'1','201','1037',478,'Retail Sale Id 1464942',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 11:27:02','',''),(2617404,'1','201','1037',478,'Retail Sale Id 1464943',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 11:29:29','',''),(2617405,'1','201','1037',478,'Retail Sale Id 1464944',15500.00,0.00,0.00,25.00,200.00,'2022-04-01 11:31:22','',''),(2617406,'1','201','1037',478,'Retail Sale Id 1464945',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 11:41:28','',''),(2617407,'1','201','1037',478,'Retail Sale Id 1464946',7000.50,0.00,0.00,10.77,409.26,'2022-04-01 11:47:39','',''),(2617408,'1','201','1037',478,'Retail Sale Id 1464947',2502.50,0.00,0.00,3.85,146.30,'2022-04-01 11:48:26','',''),(2617409,'1','201','1037',478,'Retail Sale Id 1464948',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 11:56:52','',''),(2617410,'1','201','1037',478,'Retail Sale Id 1464949',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 11:58:10','',''),(2617411,'1','201','1037',478,'Retail Sale Id 1464950',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 11:58:52','',''),(2617412,'1','201','1037',478,'Retail Sale Id 1464951',7800.00,0.00,0.00,12.00,456.00,'2022-04-01 12:09:03','',''),(2617413,'1','201','1037',478,'Retail Sale Id 1464952',9100.00,0.00,0.00,14.00,532.00,'2022-04-01 12:10:05','',''),(2617414,'1','201','1037',478,'Retail Sale Id 1464953',650.00,0.00,0.00,1.00,38.00,'2022-04-01 12:10:47','',''),(2617415,'1','201','1037',478,'Retail Sale Id 1464954',975.00,0.00,0.00,1.50,57.00,'2022-04-01 12:12:09','',''),(2617416,'1','201','1037',478,'Retail Sale Id 1464955',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 12:14:27','',''),(2617417,'1','201','1037',478,'Retail Sale Id 1464956',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 12:15:05','',''),(2617418,'1','201','1037',478,'Retail Sale Id 1464957',3003.00,0.00,0.00,4.62,175.56,'2022-04-01 12:16:11','',''),(2617419,'1','201','1037',478,'Retail Sale Id 1464958',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 12:22:20','',''),(2617420,'1','201','1037',478,'Retail Sale Id 1464959',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 12:23:40','',''),(2617421,'1','201','1037',478,'Retail Sale Id 1464960',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 12:25:08','',''),(2617422,'1','201','1037',478,'Retail Sale Id 1464961',123000.00,0.00,0.00,200.00,600.00,'2022-04-01 12:26:52','',''),(2617423,'1','201','1037',478,'Retail Sale Id 1464962',9002.50,0.00,0.00,13.85,526.30,'2022-04-01 12:27:43','',''),(2617424,'1','201','1037',478,'Retail Sale Id 1464963',3003.00,0.00,0.00,4.62,175.56,'2022-04-01 12:28:30','',''),(2617425,'1','201','1037',478,'Retail Sale Id 1464964',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 12:29:11','',''),(2617426,'1','201','1037',478,'Retail Sale Id 1464965',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 12:31:53','',''),(2617427,'1','201','1037',478,'Retail Sale Id 1464966',650.00,0.00,0.00,1.00,38.00,'2022-04-01 12:34:28','',''),(2617428,'1','201','1037',478,'Retail Sale Id 1464966',650.00,0.00,0.00,1.00,38.00,'2022-04-01 12:34:28','',''),(2617429,'1','201','1037',478,'Return of Retail Sale Id 1464952',0.00,9100.00,14.00,0.00,-532.00,'2022-04-01 12:37:37','',''),(2617430,'1','201','1037',478,'Retail Sale Id 1464967',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 12:40:01','',''),(2617431,'1','201','1037',478,'Retail Sale Id 1464968',2353.00,0.00,0.00,3.62,137.56,'2022-04-01 12:41:27','',''),(2617432,'1','201','1037',478,'Retail Sale Id 1464969',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 12:42:19','',''),(2617433,'1','201','1037',478,'Retail Sale Id 1464970',4225.00,0.00,0.00,6.50,247.00,'2022-04-01 12:43:21','',''),(2617434,'1','201','1037',478,'Retail Sale Id 1464971',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 12:44:24','',''),(2617435,'1','201','1037',478,'Retail Sale Id 1464972',15500.00,0.00,0.00,25.00,200.00,'2022-04-01 13:07:15','',''),(2617436,'1','201','1037',478,'Retail Sale Id 1464973',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 13:08:33','',''),(2617437,'1','201','1037',478,'Retail Sale Id 1464974',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 13:09:53','',''),(2617438,'1','201','1037',478,'Retail Sale Id 1464975',7800.00,0.00,0.00,12.00,456.00,'2022-04-01 13:11:55','',''),(2617439,'1','201','1037',478,'Retail Sale Id 1464976',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 13:20:56','',''),(2617440,'1','201','1037',478,'Retail Sale Id 1464977',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 13:23:01','',''),(2617441,'1','201','1037',478,'Retail Sale Id 1464978',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 13:24:01','',''),(2617442,'1','201','1037',478,'Retail Sale Id 1464979',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 13:32:49','',''),(2617443,'1','201','1037',478,'Retail Sale Id 1464980',3575.00,0.00,0.00,5.50,209.00,'2022-04-01 13:34:32','',''),(2617444,'1','201','1037',478,'Retail Sale Id 1464981',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 13:35:42','',''),(2617445,'1','201','1037',478,'Retail Sale Id 1464982',1501.50,0.00,0.00,2.31,87.78,'2022-04-01 13:47:27','',''),(2617446,'1','201','1037',478,'Retail Sale Id 1464983',8125.00,0.00,0.00,12.50,475.00,'2022-04-01 13:57:37','',''),(2617447,'1','201','1037',478,'Retail Sale Id 1464984',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 13:58:37','',''),(2617448,'1','201','1037',478,'Retail Sale Id 1464985',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 14:02:49','',''),(2617449,'1','201','1037',478,'Retail Sale Id 1464986',2801.50,0.00,0.00,4.31,163.78,'2022-04-01 14:11:38','',''),(2617450,'1','201','1037',478,'Retail Sale Id 1464987',8125.00,0.00,0.00,12.50,475.00,'2022-04-01 14:19:44','',''),(2617451,'1','201','1037',478,'Retail Sale Id 1464988',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 14:23:25','',''),(2617452,'1','201','1037',478,'Retail Sale Id 1464989',6500.00,0.00,0.00,10.00,380.00,'2022-04-01 14:24:55','',''),(2617453,'1','201','1037',478,'Retail Sale Id 1464990',2502.50,0.00,0.00,3.85,146.30,'2022-04-01 14:27:27','',''),(2617454,'1','201','1037',478,'Retail Sale Id 1464991',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 14:28:34','',''),(2617455,'1','201','1037',478,'Retail Sale Id 1464992',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 14:31:32','',''),(2617456,'1','201','1037',478,'Retail Sale Id 1464993',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 14:32:29','',''),(2617457,'1','201','1037',478,'Retail Sale Id 1464994',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 14:34:15','',''),(2617458,'1','201','1037',478,'Retail Sale Id 1464995',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 14:35:57','',''),(2617459,'1','201','1037',478,'Return of Retail Sale Id 1464963',0.00,3003.00,4.62,0.00,-175.56,'2022-04-01 14:47:44','',''),(2617460,'1','201','1037',478,'Retail Sale Id 1464996',2002.00,0.00,0.00,3.08,117.04,'2022-04-01 14:55:29','',''),(2617461,'1','201','1037',478,'Retail Sale Id 1464997',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 14:57:39','',''),(2617462,'1','201','1037',478,'Retail Sale Id 1464998',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 14:58:56','',''),(2617463,'1','201','1037',478,'Retail Sale Id 1464999',1001.00,0.00,0.00,1.54,58.52,'2022-04-01 15:02:44','',''),(2617464,'1','201','1037',478,'Retail Sale Id 1465000',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 15:04:17','',''),(2617465,'1','201','1037',478,'Retail Sale Id 1465001',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 15:06:18','',''),(2617466,'1','201','1037',478,'Retail Sale Id 1465002',3575.00,0.00,0.00,5.50,209.00,'2022-04-01 15:11:18','',''),(2617467,'1','201','1037',478,'Retail Sale Id 1465003',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 15:15:02','',''),(2617468,'1','201','1037',478,'Retail Sale Id 1465004',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 15:26:13','',''),(2617469,'1','201','1037',478,'Retail Sale Id 1465005',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 15:27:22','',''),(2617470,'1','201','1037',478,'Retail Sale Id 1465007',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 15:29:29','',''),(2617471,'1','201','1037',478,'Retail Sale Id 1465008',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 15:30:13','',''),(2617472,'1','201','1037',478,'Retail Sale Id 1465009',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 15:30:49','',''),(2617473,'1','201','1037',478,'Retail Sale Id 1465010',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 15:31:28','',''),(2617474,'1','201','1037',478,'Retail Sale Id 1465011',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 15:36:30','',''),(2617475,'1','201','1037',478,'Retail Sale Id 1465012',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 15:40:34','',''),(2617476,'1','201','1037',478,'Retail Sale Id 1465013',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 15:42:05','',''),(2617477,'1','201','1037',478,'Retail Sale Id 1465014',1625.00,0.00,0.00,2.50,95.00,'2022-04-01 15:44:25','',''),(2617478,'1','201','1037',478,'Retail Sale Id 1465015',2002.00,0.00,0.00,3.08,117.04,'2022-04-01 15:47:27','',''),(2617479,'1','201','1037',478,'Retail Sale Id 1465016',1501.50,0.00,0.00,2.31,87.78,'2022-04-01 15:48:12','',''),(2617480,'1','201','1037',478,'Retail Sale Id 1465017',1501.50,0.00,0.00,2.31,87.78,'2022-04-01 15:48:47','',''),(2617481,'1','201','1037',478,'Retail Sale Id 1465018',4550.00,0.00,0.00,7.00,266.00,'2022-04-01 15:50:08','',''),(2617482,'1','201','1037',478,'Retail Sale Id 1465019',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 15:56:26','',''),(2617483,'1','201','1037',478,'Retail Sale Id 1465020',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 15:58:36','',''),(2617484,'1','201','1037',478,'Retail Sale Id 1465021',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 16:03:09','',''),(2617485,'1','201','1037',478,'Retail Sale Id 1465022',2002.00,0.00,0.00,3.08,117.04,'2022-04-01 16:07:00','',''),(2617486,'1','201','1037',478,'Retail Sale Id 1465023',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 16:10:17','',''),(2617487,'1','201','1037',478,'Retail Sale Id 1465024',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 16:12:40','',''),(2617488,'1','201','1037',478,'Retail Sale Id 1465025',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 16:18:16','',''),(2617489,'1','201','1037',478,'Retail Sale Id 1465026',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 16:24:51','',''),(2617490,'1','201','1037',478,'Retail Sale Id 1465027',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 16:25:35','',''),(2617491,'1','201','1037',478,'Retail Sale Id 1465028',1001.00,0.00,0.00,1.54,58.52,'2022-04-01 16:27:15','',''),(2617492,'1','201','1037',478,'Retail Sale Id 1465029',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 16:33:21','',''),(2617493,'1','201','1037',478,'Retail Sale Id 1465029',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 16:33:21','',''),(2617494,'1','201','1037',478,'Retail Sale Id 1465030',5200.00,0.00,0.00,8.00,304.00,'2022-04-01 16:34:25','',''),(2617495,'1','201','1037',478,'Retail Sale Id 1465031',4550.00,0.00,0.00,7.00,266.00,'2022-04-01 16:41:26','',''),(2617496,'1','201','1037',478,'Retail Sale Id 1465032',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 16:42:21','',''),(2617497,'1','201','1037',478,'Retail Sale Id 1465033',8125.00,0.00,0.00,12.50,475.00,'2022-04-01 16:43:14','',''),(2617498,'1','201','1037',478,'Retail Sale Id 1465034',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 16:44:40','',''),(2617499,'1','201','1037',478,'Retail Sale Id 1465035',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 16:45:22','',''),(2617500,'1','201','1037',478,'Retail Sale Id 1465036',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 16:45:56','',''),(2617501,'1','201','1037',478,'Retail Sale Id 1465037',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 16:47:57','',''),(2617502,'1','201','1037',478,'Retail Sale Id 1465038',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 16:51:28','',''),(2617503,'1','201','1037',478,'Retail Sale Id 1465039',650.00,0.00,0.00,1.00,38.00,'2022-04-01 16:52:44','',''),(2617504,'1','201','1037',478,'Retail Sale Id 1465040',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 16:56:18','',''),(2617505,'1','201','1037',478,'Retail Sale Id 1465041',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 16:57:39','',''),(2617506,'1','201','1037',478,'Retail Sale Id 1465042',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 16:58:25','',''),(2617507,'1','201','1037',478,'Retail Sale Id 1465043',3003.00,0.00,0.00,4.62,175.56,'2022-04-01 16:59:24','',''),(2617508,'1','201','1037',478,'Retail Sale Id 1465044',2002.00,0.00,0.00,3.08,117.04,'2022-04-01 17:00:15','',''),(2617509,'1','201','1037',478,'Retail Sale Id 1465045',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 17:00:58','',''),(2617510,'1','201','1037',478,'Retail Sale Id 1465046',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 17:07:43','',''),(2617511,'1','201','1037',478,'Retail Sale Id 1465047',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 17:11:43','',''),(2617512,'1','201','1037',478,'Retail Sale Id 1465048',2002.00,0.00,0.00,3.08,117.04,'2022-04-01 17:12:34','',''),(2617513,'1','201','1037',478,'Retail Sale Id 1465049',2002.00,0.00,0.00,3.08,117.04,'2022-04-01 17:14:02','',''),(2617514,'1','201','1037',478,'Retail Sale Id 1465050',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 17:15:11','',''),(2617515,'1','201','1037',478,'Retail Sale Id 1465051',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 17:16:18','',''),(2617516,'1','201','1037',478,'Retail Sale Id 1465052',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 17:18:24','',''),(2617517,'1','201','1037',478,'Retail Sale Id 1465053',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 17:19:38','',''),(2617518,'1','201','1037',478,'Retail Sale Id 1465054',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 17:24:28','',''),(2617519,'1','201','1037',478,'Retail Sale Id 1465055',7800.00,0.00,0.00,12.00,456.00,'2022-04-01 17:25:38','',''),(2617520,'1','201','1037',478,'Retail Sale Id 1465056',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 17:26:59','',''),(2617521,'1','201','1037',478,'Retail Sale Id 1465057',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 17:29:37','',''),(2617522,'1','201','1037',478,'Retail Sale Id 1465058',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 17:35:48','',''),(2617523,'1','201','1037',478,'Retail Sale Id 1465059',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 17:37:20','',''),(2617524,'1','201','1037',478,'Retail Sale Id 1465060',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 17:38:25','',''),(2617525,'1','201','1037',478,'Retail Sale Id 1465061',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 17:40:01','',''),(2617526,'1','201','1037',478,'Retail Sale Id 1465062',3003.00,0.00,0.00,4.62,175.56,'2022-04-01 17:41:20','',''),(2617527,'1','201','1037',478,'Retail Sale Id 1465063',3003.00,0.00,0.00,4.62,175.56,'2022-04-01 17:44:29','',''),(2617528,'1','201','1037',478,'Retail Sale Id 1465064',3003.00,0.00,0.00,4.62,175.56,'2022-04-01 17:46:31','',''),(2617529,'1','201','1037',478,'Retail Sale Id 1465065',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 17:47:16','',''),(2617530,'1','201','1037',478,'Retail Sale Id 1465066',2502.50,0.00,0.00,3.85,146.30,'2022-04-01 17:48:56','',''),(2617531,'1','201','1037',478,'Retail Sale Id 1465067',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 17:50:12','',''),(2617532,'1','201','1037',478,'Retail Sale Id 1465068',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 17:50:49','',''),(2617533,'1','201','1037',478,'Retail Sale Id 1465069',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 17:54:12','',''),(2617534,'1','201','1037',478,'Retail Sale Id 1465070',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 17:58:59','',''),(2617535,'1','201','1037',478,'Retail Sale Id 1465070',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 17:58:59','',''),(2617536,'1','201','1037',478,'Retail Sale Id 1465070',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 17:58:59','',''),(2617537,'1','201','1037',478,'Retail Sale Id 1465070',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 17:58:59','',''),(2617538,'1','201','1037',478,'Retail Sale Id 1465071',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 18:03:48','',''),(2617539,'1','201','1037',478,'Retail Sale Id 1465071',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 18:03:48','',''),(2617540,'1','201','1037',478,'Retail Sale Id 1465071',2600.00,0.00,0.00,4.00,152.00,'2022-04-01 18:03:48','',''),(2617541,'1','201','1037',478,'Retail Sale Id 1465072',650.00,0.00,0.00,1.00,38.00,'2022-04-01 18:06:46','',''),(2617542,'1','201','1037',478,'Retail Sale Id 1465073',1202.50,0.00,0.00,1.85,70.30,'2022-04-01 18:09:51','',''),(2617543,'1','201','1037',478,'Retail Sale Id 1465074',1898.00,0.00,0.00,2.92,110.96,'2022-04-01 18:10:52','',''),(2617544,'1','201','1037',478,'Retail Sale Id 1465075',1501.50,0.00,0.00,2.31,87.78,'2022-04-01 18:11:45','',''),(2617545,'1','201','1037',478,'Retail Sale Id 1465076',7800.00,0.00,0.00,12.00,456.00,'2022-04-01 18:15:01','',''),(2617546,'1','201','1037',478,'Retail Sale Id 1465077',1001.00,0.00,0.00,1.54,58.52,'2022-04-01 18:18:08','',''),(2617547,'1','201','1037',478,'Retail Sale Id 1465078',1001.00,0.00,0.00,1.54,58.52,'2022-04-01 18:18:50','',''),(2617548,'1','201','1037',478,'Retail Sale Id 1465079',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 18:19:32','',''),(2617549,'1','201','1037',478,'Retail Sale Id 1465080',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 18:20:06','',''),(2617550,'1','201','1037',478,'Retail Sale Id 1465081',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 18:28:28','',''),(2617551,'1','201','1037',478,'Retail Sale Id 1465082',7440.00,0.00,0.00,12.00,96.00,'2022-04-01 18:30:36','',''),(2617552,'1','201','1037',478,'Retail Sale Id 1465083',1300.00,0.00,0.00,2.00,76.00,'2022-04-01 18:32:18','',''),(2617553,'1','201','1037',478,'Retail Sale Id 1465084',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 18:33:04','',''),(2617554,'1','201','1037',478,'Retail Sale Id 1465085',6500.00,0.00,0.00,10.00,380.00,'2022-04-01 18:41:38','',''),(2617555,'1','201','1037',478,'Retail Sale Id 1465086',650.00,0.00,0.00,1.00,38.00,'2022-04-01 18:42:53','',''),(2617556,'1','201','1037',478,'Retail Sale Id 1465087',650.00,0.00,0.00,1.00,38.00,'2022-04-01 18:43:34','',''),(2617557,'1','201','1037',478,'Return of Retail Sale Id 1464894',0.00,62000.00,100.00,0.00,-800.00,'2022-04-01 19:29:54','',''),(2617558,'1','201','1037',478,'Retail Sale Id 1465088',61500.00,0.00,0.00,100.00,300.00,'2022-04-01 19:30:51','',''),(2617559,'1','201','1037',478,'Retail Sale Id 1465089',1839.50,0.00,0.00,2.83,107.54,'2022-04-01 19:54:27','',''),(2617560,'1','201','1037',478,'Return of Retail Sale Id 1465089',0.00,1839.50,2.83,0.00,-107.54,'2022-04-01 19:55:26','',''),(2617561,'1','201','1037',478,'Retail Sale Id 1465090',1839.50,0.00,0.00,2.83,107.54,'2022-04-01 19:56:47','',''),(2617562,'1','201','1037',478,'Retail Sale Id 1465091',52.00,0.00,0.00,0.08,3.04,'2022-04-01 20:06:29','',''),(2617563,'1','201','1037',478,'Return of Retail Sale Id 1465091',0.00,52.00,0.08,0.00,-3.04,'2022-04-01 20:08:59','',''),(2617564,'1','201','1037',478,'Return of Retail Sale Id 1465090',0.00,1839.50,2.83,0.00,-107.54,'2022-04-01 20:09:37','',''),(2617565,'1','201','1037',478,'Retail Sale Id 1465092',1891.50,0.00,0.00,2.91,110.58,'2022-04-01 20:11:25','',''),(2617566,'1','201','1037',478,'Retail Sale Id 1465093',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 07:19:31','',''),(2617567,'1','201','1037',478,'Retail Sale Id 1465094',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 07:55:13','',''),(2617568,'1','201','1037',478,'Retail Sale Id 1465095',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 07:57:11','',''),(2617569,'1','201','1037',478,'Retail Sale Id 1465096',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 07:58:04','',''),(2617570,'1','201','1037',478,'Retail Sale Id 1465097',92250.00,0.00,0.00,150.00,450.00,'2022-04-02 08:06:46','',''),(2617571,'1','201','1037',478,'Retail Sale Id 1465098',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 08:20:58','',''),(2617572,'1','201','1037',478,'Retail Sale Id 1465099',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 08:24:36','',''),(2617573,'1','201','1037',478,'Retail Sale Id 1465100',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 08:25:48','',''),(2617574,'1','201','1037',478,'Retail Sale Id 1465101',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 08:29:37','',''),(2617575,'1','201','1037',478,'Retail Sale Id 1465102',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 08:36:29','',''),(2617576,'1','201','1037',478,'Retail Sale Id 1465103',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 08:42:29','',''),(2617577,'1','201','1037',478,'Retail Sale Id 1465104',6500.00,0.00,0.00,10.00,380.00,'2022-04-02 08:48:08','',''),(2617578,'1','201','1037',478,'Retail Sale Id 1465105',1001.00,0.00,0.00,1.54,58.52,'2022-04-02 08:49:06','',''),(2617579,'1','201','1037',478,'Retail Sale Id 1465106',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 08:50:24','',''),(2617580,'1','201','1037',478,'Retail Sale Id 1465107',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 08:51:56','',''),(2617581,'1','201','1037',478,'Retail Sale Id 1465108',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 08:55:24','',''),(2617582,'1','201','1037',478,'Retail Sale Id 1465109',61500.00,0.00,0.00,100.00,300.00,'2022-04-02 09:05:20','',''),(2617583,'1','201','1037',478,'Retail Sale Id 1465110',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 09:08:19','',''),(2617584,'1','201','1037',478,'Retail Sale Id 1465111',2925.00,0.00,0.00,4.50,171.00,'2022-04-02 09:10:00','',''),(2617585,'1','201','1037',478,'Retail Sale Id 1465112',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 09:11:05','',''),(2617586,'1','201','1037',478,'Retail Sale Id 1465113',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 09:12:06','',''),(2617587,'1','201','1037',478,'Retail Sale Id 1465114',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 09:12:57','',''),(2617588,'1','201','1037',478,'Retail Sale Id 1465115',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 09:13:44','',''),(2617589,'1','201','1037',478,'Retail Sale Id 1465116',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 09:14:48','',''),(2617590,'1','201','1037',478,'Retail Sale Id 1465117',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 09:24:24','',''),(2617591,'1','201','1037',478,'Retail Sale Id 1465118',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 09:25:51','',''),(2617592,'1','201','1037',478,'Retail Sale Id 1465119',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 09:30:29','',''),(2617593,'1','201','1037',478,'Retail Sale Id 1465120',7800.00,0.00,0.00,12.00,456.00,'2022-04-02 09:31:35','',''),(2617594,'1','201','1037',478,'Retail Sale Id 1465121',5200.00,0.00,0.00,8.00,304.00,'2022-04-02 09:32:24','',''),(2617595,'1','201','1037',478,'Retail Sale Id 1465122',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 09:33:30','',''),(2617596,'1','201','1037',478,'Retail Sale Id 1465123',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 09:40:50','',''),(2617597,'1','201','1037',478,'Retail Sale Id 1465123',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 09:40:50','',''),(2617598,'1','201','1037',478,'Retail Sale Id 1465124',2002.00,0.00,0.00,3.08,117.04,'2022-04-02 09:43:27','',''),(2617599,'1','201','1037',478,'Retail Sale Id 1465125',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 09:52:00','',''),(2617600,'1','201','1037',478,'Retail Sale Id 1465126',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 09:57:00','',''),(2617601,'1','201','1037',478,'Retail Sale Id 1465127',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 09:59:51','',''),(2617602,'1','201','1037',478,'Retail Sale Id 1465128',18600.00,0.00,0.00,30.00,240.00,'2022-04-02 10:02:40','',''),(2617603,'1','201','1037',478,'Retail Sale Id 1465129',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 10:04:12','',''),(2617604,'1','201','1037',478,'Retail Sale Id 1465129',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 10:04:12','',''),(2617605,'1','201','1037',478,'Retail Sale Id 1465130',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 10:05:04','',''),(2617606,'1','201','1037',478,'Retail Sale Id 1465131',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 10:06:30','',''),(2617607,'1','201','1037',478,'Retail Sale Id 1465132',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 10:09:08','',''),(2617608,'1','201','1037',478,'Retail Sale Id 1465133',4550.00,0.00,0.00,7.00,266.00,'2022-04-02 10:09:46','',''),(2617609,'1','201','1037',478,'Retail Sale Id 1465134',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 10:10:27','',''),(2617610,'1','201','1037',478,'Retail Sale Id 1465135',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 10:11:07','',''),(2617611,'1','201','1037',478,'Retail Sale Id 1465136',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 10:11:46','',''),(2617612,'1','201','1037',478,'Retail Sale Id 1465137',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 10:12:31','',''),(2617613,'1','201','1037',478,'Retail Sale Id 1465138',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 10:14:28','',''),(2617614,'1','201','1037',478,'Retail Sale Id 1465139',3497.00,0.00,0.00,5.38,204.44,'2022-04-02 10:15:32','',''),(2617615,'1','201','1037',478,'Retail Sale Id 1465140',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 10:19:43','',''),(2617616,'1','201','1037',478,'Retail Sale Id 1465141',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 10:20:28','',''),(2617617,'1','201','1037',478,'Retail Sale Id 1465142',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 10:21:31','',''),(2617618,'1','201','1037',478,'Retail Sale Id 1465143',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 10:26:22','',''),(2617619,'1','201','1037',478,'Retail Sale Id 1465144',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 10:27:50','',''),(2617620,'1','201','1037',478,'Retail Sale Id 1465145',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 10:28:50','',''),(2617621,'1','201','1037',478,'Retail Sale Id 1465146',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 10:29:51','',''),(2617622,'1','201','1037',478,'Retail Sale Id 1465147',1001.00,0.00,0.00,1.54,58.52,'2022-04-02 10:30:34','',''),(2617623,'1','201','1037',478,'Retail Sale Id 1465148',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 10:33:07','',''),(2617624,'1','201','1037',478,'Retail Sale Id 1465149',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 10:37:31','',''),(2617625,'1','201','1037',478,'Retail Sale Id 1465150',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 10:38:36','',''),(2617626,'1','201','1037',478,'Retail Sale Id 1465151',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 10:43:34','',''),(2617627,'1','201','1037',478,'Retail Sale Id 1465152',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 10:45:12','',''),(2617628,'1','201','1037',478,'Retail Sale Id 1465153',2275.00,0.00,0.00,3.50,133.00,'2022-04-02 10:47:34','',''),(2617629,'1','201','1037',478,'Retail Sale Id 1465154',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 10:53:34','',''),(2617630,'1','201','1037',478,'Retail Sale Id 1465155',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 10:58:49','',''),(2617631,'1','201','1037',478,'Retail Sale Id 1465156',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 11:00:38','',''),(2617632,'1','201','1037',478,'Retail Sale Id 1465157',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 11:07:31','',''),(2617633,'1','201','1037',478,'Retail Sale Id 1465158',4998.50,0.00,0.00,7.69,292.22,'2022-04-02 11:10:42','',''),(2617634,'1','201','1037',478,'Retail Sale Id 1465159',6500.00,0.00,0.00,10.00,380.00,'2022-04-02 11:12:52','',''),(2617635,'1','201','1037',478,'Retail Sale Id 1465160',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 11:14:10','',''),(2617636,'1','201','1037',478,'Retail Sale Id 1465161',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 11:16:48','',''),(2617637,'1','201','1037',478,'Retail Sale Id 1465162',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 11:18:30','',''),(2617638,'1','201','1037',478,'Retail Sale Id 1465163',7800.00,0.00,0.00,12.00,456.00,'2022-04-02 11:20:47','',''),(2617639,'1','201','1037',478,'Retail Sale Id 1465164',4998.50,0.00,0.00,7.69,292.22,'2022-04-02 11:23:19','',''),(2617640,'1','201','1037',478,'Retail Sale Id 1465165',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 11:24:19','',''),(2617641,'1','201','1037',478,'Retail Sale Id 1465166',5200.00,0.00,0.00,8.00,304.00,'2022-04-02 11:26:13','',''),(2617642,'1','201','1037',478,'Retail Sale Id 1465167',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 11:27:29','',''),(2617643,'1','201','1037',478,'Retail Sale Id 1465168',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 11:28:43','',''),(2617644,'1','201','1037',478,'Retail Sale Id 1465169',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 11:31:47','',''),(2617645,'1','201','1037',478,'Retail Sale Id 1465170',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 11:34:35','',''),(2617646,'1','201','1037',478,'Retail Sale Id 1465171',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 11:36:15','',''),(2617647,'1','201','1037',478,'Retail Sale Id 1465172',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 11:37:08','',''),(2617648,'1','201','1037',478,'Retail Sale Id 1465173',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 11:38:00','',''),(2617649,'1','201','1037',478,'Retail Sale Id 1465174',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 11:40:25','',''),(2617650,'1','201','1037',478,'Retail Sale Id 1465175',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 11:46:13','',''),(2617651,'1','201','1037',478,'Retail Sale Id 1465176',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 11:47:00','',''),(2617652,'1','201','1037',478,'Retail Sale Id 1465177',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 11:48:50','',''),(2617653,'1','201','1037',478,'Retail Sale Id 1465178',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 11:49:48','',''),(2617654,'1','201','1037',478,'Retail Sale Id 1465179',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 11:50:40','',''),(2617655,'1','201','1037',478,'Retail Sale Id 1465180',1501.50,0.00,0.00,2.31,87.78,'2022-04-02 11:55:49','',''),(2617656,'1','201','1037',478,'Retail Sale Id 1465181',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 11:58:31','',''),(2617657,'1','201','1037',478,'Retail Sale Id 1465182',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 11:59:11','',''),(2617658,'1','201','1037',478,'Retail Sale Id 1465183',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 12:00:06','',''),(2617659,'1','201','1037',478,'Retail Sale Id 1465184',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 12:01:08','',''),(2617660,'1','201','1037',478,'Retail Sale Id 1465185',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 12:02:38','',''),(2617661,'1','201','1037',478,'Retail Sale Id 1465186',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 12:07:41','',''),(2617662,'1','201','1037',478,'Retail Sale Id 1465187',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 12:08:59','',''),(2617663,'1','201','1037',478,'Retail Sale Id 1465188',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 12:09:50','',''),(2617664,'1','201','1037',478,'Retail Sale Id 1465189',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 12:12:25','',''),(2617665,'1','201','1037',478,'Retail Sale Id 1465190',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 12:13:31','',''),(2617666,'1','201','1037',478,'Retail Sale Id 1465191',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 12:15:13','',''),(2617667,'1','201','1037',478,'Retail Sale Id 1465192',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 12:16:57','',''),(2617668,'1','201','1037',478,'Retail Sale Id 1465193',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 12:17:43','',''),(2617669,'1','201','1037',478,'Retail Sale Id 1465194',31000.00,0.00,0.00,50.00,400.00,'2022-04-02 12:19:18','',''),(2617670,'1','201','1037',478,'Retail Sale Id 1465195',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 12:20:20','',''),(2617671,'1','201','1037',478,'Retail Sale Id 1465196',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 12:22:36','',''),(2617672,'1','201','1037',478,'Retail Sale Id 1465197',5850.00,0.00,0.00,9.00,342.00,'2022-04-02 12:23:26','',''),(2617673,'1','201','1037',478,'Retail Sale Id 1465198',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 12:24:21','',''),(2617674,'1','201','1037',478,'Retail Sale Id 1465199',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 12:25:30','',''),(2617675,'1','201','1037',478,'Retail Sale Id 1465200',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 12:30:16','',''),(2617676,'1','201','1037',478,'Retail Sale Id 1465201',5200.00,0.00,0.00,8.00,304.00,'2022-04-02 12:31:32','',''),(2617677,'1','201','1037',478,'Retail Sale Id 1465202',3575.00,0.00,0.00,5.50,209.00,'2022-04-02 12:32:57','',''),(2617678,'1','201','1037',478,'Retail Sale Id 1465203',3497.00,0.00,0.00,5.38,204.44,'2022-04-02 12:35:00','',''),(2617679,'1','201','1037',478,'Retail Sale Id 1465204',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 12:41:24','',''),(2617680,'1','201','1037',478,'Retail Sale Id 1465205',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 12:42:39','',''),(2617681,'1','201','1037',478,'Retail Sale Id 1465206',4550.00,0.00,0.00,7.00,266.00,'2022-04-02 12:43:24','',''),(2617682,'1','201','1037',478,'Retail Sale Id 1465207',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 12:44:02','',''),(2617683,'1','201','1037',478,'Retail Sale Id 1465208',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 12:44:40','',''),(2617684,'1','201','1037',478,'Retail Sale Id 1465209',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 12:45:15','',''),(2617685,'1','201','1037',478,'Retail Sale Id 1465210',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 12:47:53','',''),(2617686,'1','201','1037',478,'Retail Sale Id 1465211',2002.00,0.00,0.00,3.08,117.04,'2022-04-02 12:50:30','',''),(2617687,'1','201','1037',478,'Retail Sale Id 1465212',1001.00,0.00,0.00,1.54,58.52,'2022-04-02 12:51:39','',''),(2617688,'1','201','1037',478,'Retail Sale Id 1465213',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 12:52:40','',''),(2617689,'1','201','1037',478,'Retail Sale Id 1465214',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 12:53:37','',''),(2617690,'1','201','1037',478,'Retail Sale Id 1465215',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 12:54:37','',''),(2617691,'1','201','1037',478,'Retail Sale Id 1465216',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 13:01:10','',''),(2617692,'1','201','1037',478,'Retail Sale Id 1465217',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 13:02:28','',''),(2617693,'1','201','1037',478,'Retail Sale Id 1465218',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 13:08:35','',''),(2617694,'1','201','1037',478,'Retail Sale Id 1465219',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 13:10:36','',''),(2617695,'1','201','1037',478,'Retail Sale Id 1465220',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 13:20:22','',''),(2617696,'1','201','1037',478,'Retail Sale Id 1465221',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 13:34:34','',''),(2617697,'1','201','1037',478,'Retail Sale Id 1465222',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 13:35:26','',''),(2617698,'1','201','1037',478,'Retail Sale Id 1465223',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 13:36:19','',''),(2617699,'1','201','1037',478,'Retail Sale Id 1465224',1703.00,0.00,0.00,2.62,99.56,'2022-04-02 13:37:24','',''),(2617700,'1','201','1037',478,'Retail Sale Id 1465225',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 13:38:25','',''),(2617701,'1','201','1037',478,'Retail Sale Id 1465226',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 13:41:09','',''),(2617702,'1','201','1037',478,'Retail Sale Id 1465227',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 13:42:05','',''),(2617703,'1','201','1037',478,'Retail Sale Id 1465228',650.00,0.00,0.00,1.00,38.00,'2022-04-02 13:43:25','',''),(2617704,'1','201','1037',478,'Retail Sale Id 1465229',2002.00,0.00,0.00,3.08,117.04,'2022-04-02 13:48:13','',''),(2617705,'1','201','1037',478,'Retail Sale Id 1465230',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 13:50:03','',''),(2617706,'1','201','1037',478,'Retail Sale Id 1465231',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 13:52:40','',''),(2617707,'1','201','1037',478,'Retail Sale Id 1465232',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 13:53:31','',''),(2617708,'1','201','1037',478,'Retail Sale Id 1465233',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 13:54:17','',''),(2617709,'1','201','1037',478,'Retail Sale Id 1465234',1599.00,0.00,0.00,2.46,93.48,'2022-04-02 13:55:24','',''),(2617710,'1','201','1037',478,'Retail Sale Id 1465235',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 13:56:23','',''),(2617711,'1','201','1037',478,'Retail Sale Id 1465236',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 13:58:01','',''),(2617712,'1','201','1037',478,'Retail Sale Id 1465237',31000.00,0.00,0.00,50.00,400.00,'2022-04-02 13:59:37','',''),(2617713,'1','201','1037',478,'Retail Sale Id 1465238',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 14:00:52','',''),(2617714,'1','201','1037',478,'Retail Sale Id 1465239',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 14:02:34','',''),(2617715,'1','201','1037',478,'Retail Sale Id 1465240',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 14:03:22','',''),(2617716,'1','201','1037',478,'Retail Sale Id 1465241',7150.00,0.00,0.00,11.00,418.00,'2022-04-02 14:04:21','',''),(2617717,'1','201','1037',478,'Retail Sale Id 1465242',4550.00,0.00,0.00,7.00,266.00,'2022-04-02 14:05:42','',''),(2617718,'1','201','1037',478,'Retail Sale Id 1465243',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 14:06:59','',''),(2617719,'1','201','1037',478,'Retail Sale Id 1465244',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 14:09:19','',''),(2617720,'1','201','1037',478,'Retail Sale Id 1465245',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 14:09:58','',''),(2617721,'1','201','1037',478,'Retail Sale Id 1465246',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 14:11:26','',''),(2617722,'1','201','1037',478,'Retail Sale Id 1465247',5850.00,0.00,0.00,9.00,342.00,'2022-04-02 14:12:57','',''),(2617723,'1','201','1037',478,'Retail Sale Id 1465248',6175.00,0.00,0.00,9.50,361.00,'2022-04-02 14:13:56','',''),(2617724,'1','201','1037',478,'Retail Sale Id 1465249',61500.00,0.00,0.00,100.00,300.00,'2022-04-02 14:15:13','',''),(2617725,'1','201','1037',478,'Retail Sale Id 1465250',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 14:16:14','',''),(2617726,'1','201','1037',478,'Retail Sale Id 1465251',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 14:17:55','',''),(2617727,'1','201','1037',478,'Retail Sale Id 1465252',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 14:18:44','',''),(2617728,'1','201','1037',478,'Retail Sale Id 1465253',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 14:19:58','',''),(2617729,'1','201','1037',478,'Retail Sale Id 1465254',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 14:21:15','',''),(2617730,'1','201','1037',478,'Retail Sale Id 1465255',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 14:22:58','',''),(2617731,'1','201','1037',478,'Retail Sale Id 1465256',6500.00,0.00,0.00,10.00,380.00,'2022-04-02 14:27:52','',''),(2617732,'1','201','1037',478,'Retail Sale Id 1465257',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 14:31:32','',''),(2617733,'1','201','1037',478,'Retail Sale Id 1465258',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 14:34:35','',''),(2617734,'1','201','1037',478,'Retail Sale Id 1465259',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 14:35:43','',''),(2617735,'1','201','1037',478,'Retail Sale Id 1465260',2002.00,0.00,0.00,3.08,117.04,'2022-04-02 14:36:42','',''),(2617736,'1','201','1037',478,'Retail Sale Id 1465261',3720.00,0.00,0.00,6.00,48.00,'2022-04-02 14:37:30','',''),(2617737,'1','201','1037',478,'Retail Sale Id 1465262',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 14:38:37','',''),(2617738,'1','201','1037',478,'Retail Sale Id 1465263',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 14:39:28','',''),(2617739,'1','201','1037',478,'Retail Sale Id 1465264',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 14:41:03','',''),(2617740,'1','201','1037',478,'Retail Sale Id 1465265',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 14:42:30','',''),(2617741,'1','201','1037',478,'Retail Sale Id 1465266',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 14:43:59','',''),(2617742,'1','201','1037',478,'Retail Sale Id 1465267',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 14:44:55','',''),(2617743,'1','201','1037',478,'Retail Sale Id 1465268',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 14:45:39','',''),(2617744,'1','201','1037',478,'Retail Sale Id 1465269',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 14:47:44','',''),(2617745,'1','201','1037',478,'Retail Sale Id 1465270',7800.00,0.00,0.00,12.00,456.00,'2022-04-02 14:50:55','',''),(2617746,'1','201','1037',478,'Retail Sale Id 1465271',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 14:52:09','',''),(2617747,'1','201','1037',478,'Retail Sale Id 1465272',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 14:52:38','',''),(2617748,'1','201','1037',478,'Retail Sale Id 1465273',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 14:53:12','',''),(2617749,'1','201','1037',478,'Retail Sale Id 1465274',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 14:55:44','',''),(2617750,'1','201','1037',478,'Retail Sale Id 1465275',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 14:57:19','',''),(2617751,'1','201','1037',478,'Retail Sale Id 1465276',4550.00,0.00,0.00,7.00,266.00,'2022-04-02 14:58:29','',''),(2617752,'1','201','1037',478,'Retail Sale Id 1465277',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 15:00:34','',''),(2617753,'1','201','1037',478,'Retail Sale Id 1465278',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 15:01:27','',''),(2617754,'1','201','1037',478,'Retail Sale Id 1465279',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 15:02:18','',''),(2617755,'1','201','1037',478,'Retail Sale Id 1465280',650.00,0.00,0.00,1.00,38.00,'2022-04-02 15:04:13','',''),(2617756,'1','201','1037',478,'Retail Sale Id 1465280',650.00,0.00,0.00,1.00,38.00,'2022-04-02 15:04:13','',''),(2617757,'1','201','1037',478,'Retail Sale Id 1465280',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 15:04:13','',''),(2617758,'1','201','1037',478,'Retail Sale Id 1465281',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 15:06:15','',''),(2617759,'1','201','1037',478,'Retail Sale Id 1465282',4550.00,0.00,0.00,7.00,266.00,'2022-04-02 15:14:33','',''),(2617760,'1','201','1037',478,'Retail Sale Id 1465283',8450.00,0.00,0.00,13.00,494.00,'2022-04-02 15:16:05','',''),(2617761,'1','201','1037',478,'Retail Sale Id 1465284',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 15:17:22','',''),(2617762,'1','201','1037',478,'Retail Sale Id 1465285',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 15:18:41','',''),(2617763,'1','201','1037',478,'Retail Sale Id 1465286',500.50,0.00,0.00,0.77,29.26,'2022-04-02 15:19:58','',''),(2617764,'1','201','1037',478,'Retail Sale Id 1465286',1001.00,0.00,0.00,1.54,58.52,'2022-04-02 15:19:58','',''),(2617765,'1','201','1037',478,'Retail Sale Id 1465287',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 15:20:55','',''),(2617766,'1','201','1037',478,'Retail Sale Id 1465288',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 15:22:43','',''),(2617767,'1','201','1037',478,'Retail Sale Id 1465289',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 15:24:41','',''),(2617768,'1','201','1037',478,'Retail Sale Id 1465290',6500.00,0.00,0.00,10.00,380.00,'2022-04-02 15:25:42','',''),(2617769,'1','201','1037',478,'Retail Sale Id 1465291',3497.00,0.00,0.00,5.38,204.44,'2022-04-02 15:27:00','',''),(2617770,'1','201','1037',478,'Retail Sale Id 1465292',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 15:29:42','',''),(2617771,'1','201','1037',478,'Retail Sale Id 1465293',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 15:34:07','',''),(2617772,'1','201','1037',478,'Retail Sale Id 1465294',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 15:35:09','',''),(2617773,'1','201','1037',478,'Retail Sale Id 1465295',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 15:37:12','',''),(2617774,'1','201','1037',478,'Retail Sale Id 1465296',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 15:39:03','',''),(2617775,'1','201','1037',478,'Retail Sale Id 1465297',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 15:42:15','',''),(2617776,'1','201','1037',478,'Retail Sale Id 1465298',5525.00,0.00,0.00,8.50,323.00,'2022-04-02 15:44:54','',''),(2617777,'1','201','1037',478,'Retail Sale Id 1465299',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 15:47:45','',''),(2617778,'1','201','1037',478,'Retail Sale Id 1465300',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 15:52:33','',''),(2617779,'1','201','1037',478,'Retail Sale Id 1465301',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 15:54:37','',''),(2617780,'1','201','1037',478,'Retail Sale Id 1465302',1001.00,0.00,0.00,1.54,58.52,'2022-04-02 15:55:51','',''),(2617781,'1','201','1037',478,'Retail Sale Id 1465303',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 15:57:54','',''),(2617782,'1','201','1037',478,'Retail Sale Id 1465304',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 15:59:02','',''),(2617783,'1','201','1037',478,'Retail Sale Id 1465305',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:00:10','',''),(2617784,'1','201','1037',478,'Retail Sale Id 1465306',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 16:01:41','',''),(2617785,'1','201','1037',478,'Retail Sale Id 1465307',780.00,0.00,0.00,1.20,45.60,'2022-04-02 16:03:18','',''),(2617786,'1','201','1037',478,'Retail Sale Id 1465308',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 16:04:22','',''),(2617787,'1','201','1037',478,'Retail Sale Id 1465309',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:05:34','',''),(2617788,'1','201','1037',478,'Retail Sale Id 1465310',702.00,0.00,0.00,1.08,41.04,'2022-04-02 16:06:32','',''),(2617789,'1','201','1037',478,'Retail Sale Id 1465311',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:09:11','',''),(2617790,'1','201','1037',478,'Retail Sale Id 1465312',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 16:11:46','',''),(2617791,'1','201','1037',478,'Retail Sale Id 1465313',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:14:02','',''),(2617792,'1','201','1037',478,'Retail Sale Id 1465314',6500.00,0.00,0.00,10.00,380.00,'2022-04-02 16:15:26','',''),(2617793,'1','201','1037',478,'Retail Sale Id 1465315',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:18:08','',''),(2617794,'1','201','1037',478,'Retail Sale Id 1465316',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 16:20:02','',''),(2617795,'1','201','1037',478,'Retail Sale Id 1465317',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:26:39','',''),(2617796,'1','201','1037',478,'Retail Sale Id 1465318',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 16:27:32','',''),(2617797,'1','201','1037',478,'Retail Sale Id 1465319',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 16:29:35','',''),(2617798,'1','201','1037',478,'Retail Sale Id 1465320',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:30:28','',''),(2617799,'1','201','1037',478,'Retail Sale Id 1465321',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 16:34:28','',''),(2617800,'1','201','1037',478,'Retail Sale Id 1465321',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:34:28','',''),(2617801,'1','201','1037',478,'Retail Sale Id 1465322',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 16:35:33','',''),(2617802,'1','201','1037',478,'Retail Sale Id 1465323',1501.50,0.00,0.00,2.31,87.78,'2022-04-02 16:36:20','',''),(2617803,'1','201','1037',478,'Retail Sale Id 1465324',650.00,0.00,0.00,1.00,38.00,'2022-04-02 16:45:59','',''),(2617804,'1','201','1037',478,'Retail Sale Id 1465325',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 16:47:57','',''),(2617805,'1','201','1037',478,'Retail Sale Id 1465325',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 16:47:57','',''),(2617806,'1','201','1037',478,'Retail Sale Id 1465326',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 16:48:51','',''),(2617807,'1','201','1037',478,'Retail Sale Id 1465327',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:49:49','',''),(2617808,'1','201','1037',478,'Retail Sale Id 1465327',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 16:49:49','',''),(2617809,'1','201','1037',478,'Retail Sale Id 1465328',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 16:56:18','',''),(2617810,'1','201','1037',478,'Retail Sale Id 1465329',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 16:57:22','',''),(2617811,'1','201','1037',478,'Retail Sale Id 1465330',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 16:58:22','',''),(2617812,'1','201','1037',478,'Retail Sale Id 1465331',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:59:23','',''),(2617813,'1','201','1037',478,'Retail Sale Id 1465332',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 17:00:12','',''),(2617814,'1','201','1037',478,'Retail Sale Id 1465333',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 17:01:02','',''),(2617815,'1','201','1037',478,'Retail Sale Id 1465334',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 17:01:56','',''),(2617816,'1','201','1037',478,'Retail Sale Id 1465335',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 17:02:31','',''),(2617817,'1','201','1037',478,'Retail Sale Id 1465336',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:03:03','',''),(2617818,'1','201','1037',478,'Retail Sale Id 1465337',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 17:03:44','',''),(2617819,'1','201','1037',478,'Retail Sale Id 1465338',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:05:24','',''),(2617820,'1','201','1037',478,'Retail Sale Id 1465339',650.00,0.00,0.00,1.00,38.00,'2022-04-02 17:06:06','',''),(2617821,'1','201','1037',478,'Retail Sale Id 1465340',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 17:06:36','',''),(2617822,'1','201','1037',478,'Retail Sale Id 1465341',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 17:07:10','',''),(2617823,'1','201','1037',478,'Retail Sale Id 1465342',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 17:09:22','',''),(2617824,'1','201','1037',478,'Retail Sale Id 1465343',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 17:10:41','',''),(2617825,'1','201','1037',478,'Retail Sale Id 1465344',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:11:20','',''),(2617826,'1','201','1037',478,'Retail Sale Id 1465345',1001.00,0.00,0.00,1.54,58.52,'2022-04-02 17:12:43','',''),(2617827,'1','201','1037',478,'Retail Sale Id 1465346',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 17:13:51','',''),(2617828,'1','201','1037',478,'Retail Sale Id 1465347',3997.50,0.00,0.00,6.15,233.70,'2022-04-02 17:15:36','',''),(2617829,'1','201','1037',478,'Retail Sale Id 1465347',3997.50,0.00,0.00,6.15,233.70,'2022-04-02 17:15:36','',''),(2617830,'1','201','1037',478,'Retail Sale Id 1465348',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:16:45','',''),(2617831,'1','201','1037',478,'Retail Sale Id 1465349',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:17:36','',''),(2617832,'1','201','1037',478,'Retail Sale Id 1465350',598.00,0.00,0.00,0.92,34.96,'2022-04-02 17:18:40','',''),(2617833,'1','201','1037',478,'Retail Sale Id 1465351',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 17:19:48','',''),(2617834,'1','201','1037',478,'Retail Sale Id 1465352',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:20:49','',''),(2617835,'1','201','1037',478,'Retail Sale Id 1465353',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:22:34','',''),(2617836,'1','201','1037',478,'Retail Sale Id 1465354',1001.00,0.00,0.00,1.54,58.52,'2022-04-02 17:23:41','',''),(2617837,'1','201','1037',478,'Retail Sale Id 1465355',650.00,0.00,0.00,1.00,38.00,'2022-04-02 17:24:21','',''),(2617838,'1','201','1037',478,'Retail Sale Id 1465356',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 17:25:59','',''),(2617839,'1','201','1037',478,'Retail Sale Id 1465357',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 17:27:25','',''),(2617840,'1','201','1037',478,'Retail Sale Id 1465358',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:29:55','',''),(2617841,'1','201','1037',478,'Retail Sale Id 1465359',7150.00,0.00,0.00,11.00,418.00,'2022-04-02 17:33:49','',''),(2617842,'1','201','1037',478,'Retail Sale Id 1465360',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 17:35:08','',''),(2617843,'1','201','1037',478,'Retail Sale Id 1465361',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 17:37:41','',''),(2617844,'1','201','1037',478,'Retail Sale Id 1465362',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:39:25','',''),(2617845,'1','201','1037',478,'Retail Sale Id 1465363',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 17:40:33','',''),(2617846,'1','201','1037',478,'Retail Sale Id 1465364',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:41:29','',''),(2617847,'1','201','1037',478,'Retail Sale Id 1465365',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:42:19','',''),(2617848,'1','201','1037',478,'Retail Sale Id 1465366',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:43:09','',''),(2617849,'1','201','1037',478,'Retail Sale Id 1465367',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 17:44:17','',''),(2617850,'1','201','1037',478,'Retail Sale Id 1465368',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 17:45:23','',''),(2617851,'1','201','1037',478,'Retail Sale Id 1465369',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:46:13','',''),(2617852,'1','201','1037',478,'Retail Sale Id 1465370',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 17:47:12','',''),(2617853,'1','201','1037',478,'Retail Sale Id 1465371',1001.00,0.00,0.00,1.54,58.52,'2022-04-02 17:47:57','',''),(2617854,'1','201','1037',478,'Retail Sale Id 1465372',650.00,0.00,0.00,1.00,38.00,'2022-04-02 17:48:56','',''),(2617855,'1','201','1037',478,'Retail Sale Id 1465373',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 17:50:48','',''),(2617856,'1','201','1037',478,'Retail Sale Id 1465374',61500.00,0.00,0.00,100.00,300.00,'2022-04-02 17:56:01','',''),(2617857,'1','201','1037',478,'Retail Sale Id 1465375',2002.00,0.00,0.00,3.08,117.04,'2022-04-02 18:07:22','',''),(2617858,'1','201','1037',478,'Retail Sale Id 1465376',6500.00,0.00,0.00,10.00,380.00,'2022-04-02 18:13:08','',''),(2617859,'1','201','1037',478,'Retail Sale Id 1465377',2925.00,0.00,0.00,4.50,171.00,'2022-04-02 18:22:04','',''),(2617860,'1','201','1037',478,'Retail Sale Id 1465378',1300.00,0.00,0.00,2.00,76.00,'2022-04-02 18:23:11','',''),(2617861,'1','201','1037',478,'Retail Sale Id 1465379',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 18:43:14','',''),(2617862,'1','201','1037',478,'Return of Retail Sale Id 1465376',0.00,6500.00,10.00,0.00,-380.00,'2022-04-02 20:15:52','',''),(2617863,'1','201','1037',478,'Retail Sale Id 1465380',3991.00,0.00,0.00,6.14,233.32,'2022-04-02 20:22:10','',''),(2617864,'1','201','1037',478,'Return of Retail Sale Id 1465380',0.00,3991.00,6.14,0.00,-233.32,'2022-04-02 20:23:28','',''),(2617865,'1','201','1037',478,'Retail Sale Id 1465381',2476.50,0.00,0.00,3.81,144.78,'2022-04-02 20:28:31','',''),(2617866,'1','201','1037',478,'Return of Retail Sale Id 1465381',0.00,2476.50,3.81,0.00,-144.78,'2022-04-02 20:29:34','',''),(2617867,'1','201','1037',478,'Retail Sale Id 1465382',2509.00,0.00,0.00,3.86,146.68,'2022-04-02 20:31:07','',''),(2617868,'1','201','1037',478,'Return of Retail Sale Id 1465382',0.00,2509.00,3.86,0.00,-146.68,'2022-04-02 20:32:54','',''),(2617869,'1','201','1037',478,'Retail Sale Id 1465383',2476.50,0.00,0.00,3.81,144.78,'2022-04-02 20:33:41','',''),(2617870,'1','201','1037',478,'Retail Sale Id 1465384',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 07:34:56','',''),(2617871,'1','201','1037',478,'Retail Sale Id 1465385',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 08:13:09','',''),(2617872,'1','201','1037',478,'Retail Sale Id 1465386',3720.00,0.00,0.00,6.00,48.00,'2022-04-03 08:23:31','',''),(2617873,'1','201','1037',478,'Retail Sale Id 1465387',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 08:38:34','',''),(2617874,'1','201','1037',478,'Retail Sale Id 1465388',4550.00,0.00,0.00,7.00,266.00,'2022-04-03 08:53:08','',''),(2617875,'1','201','1037',478,'Retail Sale Id 1465389',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 08:57:02','',''),(2617876,'1','201','1037',478,'Retail Sale Id 1465390',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 09:25:56','',''),(2617877,'1','201','1037',478,'Retail Sale Id 1465391',3003.00,0.00,0.00,4.62,175.56,'2022-04-03 09:40:21','',''),(2617878,'1','201','1037',478,'Retail Sale Id 1465392',2600.00,0.00,0.00,4.00,152.00,'2022-04-03 09:44:00','',''),(2617879,'1','201','1037',478,'Retail Sale Id 1465393',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 09:47:50','',''),(2617880,'1','201','1037',478,'Retail Sale Id 1465394',61500.00,0.00,0.00,100.00,300.00,'2022-04-03 09:52:23','',''),(2617881,'1','201','1037',478,'Retail Sale Id 1465395',3003.00,0.00,0.00,4.62,175.56,'2022-04-03 09:56:03','',''),(2617882,'1','201','1037',478,'Retail Sale Id 1465396',2002.00,0.00,0.00,3.08,117.04,'2022-04-03 10:02:05','',''),(2617883,'1','201','1037',478,'Retail Sale Id 1465397',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 10:03:24','',''),(2617884,'1','201','1037',478,'Retail Sale Id 1465398',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 10:19:07','',''),(2617885,'1','201','1037',478,'Retail Sale Id 1465399',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 10:22:30','',''),(2617886,'1','201','1037',478,'Retail Sale Id 1465400',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 10:26:42','',''),(2617887,'1','201','1037',478,'Retail Sale Id 1465401',2002.00,0.00,0.00,3.08,117.04,'2022-04-03 10:28:31','',''),(2617888,'1','201','1037',478,'Retail Sale Id 1465402',2600.00,0.00,0.00,4.00,152.00,'2022-04-03 10:30:46','',''),(2617889,'1','201','1037',478,'Retail Sale Id 1465403',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 10:33:56','',''),(2617890,'1','201','1037',478,'Retail Sale Id 1465404',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 10:35:51','',''),(2617891,'1','201','1037',478,'Retail Sale Id 1465405',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 10:38:09','',''),(2617892,'1','201','1037',478,'Retail Sale Id 1465406',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 10:42:50','',''),(2617893,'1','201','1037',478,'Retail Sale Id 1465407',650.00,0.00,0.00,1.00,38.00,'2022-04-03 10:48:36','',''),(2617894,'1','201','1037',478,'Retail Sale Id 1465408',975.00,0.00,0.00,1.50,57.00,'2022-04-03 10:51:11','',''),(2617895,'1','201','1037',478,'Retail Sale Id 1465409',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 10:52:08','',''),(2617896,'1','201','1037',478,'Retail Sale Id 1465410',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 10:59:50','',''),(2617897,'1','201','1037',478,'Retail Sale Id 1465411',975.00,0.00,0.00,1.50,57.00,'2022-04-03 11:04:04','',''),(2617898,'1','201','1037',478,'Retail Sale Id 1465412',2600.00,0.00,0.00,4.00,152.00,'2022-04-03 11:05:25','',''),(2617899,'1','201','1037',478,'Retail Sale Id 1465413',4998.50,0.00,0.00,7.69,292.22,'2022-04-03 11:06:40','',''),(2617900,'1','201','1037',478,'Retail Sale Id 1465414',3003.00,0.00,0.00,4.62,175.56,'2022-04-03 11:17:57','',''),(2617901,'1','201','1037',478,'Retail Sale Id 1465415',650.00,0.00,0.00,1.00,38.00,'2022-04-03 11:25:56','',''),(2617902,'1','201','1037',478,'Retail Sale Id 1465416',2502.50,0.00,0.00,3.85,146.30,'2022-04-03 11:28:59','',''),(2617903,'1','201','1037',478,'Retail Sale Id 1465417',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 11:31:52','',''),(2617904,'1','201','1037',478,'Retail Sale Id 1465418',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 11:36:34','',''),(2617905,'1','201','1037',478,'Retail Sale Id 1465419',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 11:38:07','',''),(2617906,'1','201','1037',478,'Retail Sale Id 1465420',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 11:39:27','',''),(2617907,'1','201','1037',478,'Retail Sale Id 1465421',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 11:40:18','',''),(2617908,'1','201','1037',478,'Retail Sale Id 1465422',1001.00,0.00,0.00,1.54,58.52,'2022-04-03 11:41:09','',''),(2617909,'1','201','1037',478,'Retail Sale Id 1465422',1001.00,0.00,0.00,1.54,58.52,'2022-04-03 11:41:09','',''),(2617910,'1','201','1037',478,'Retail Sale Id 1465423',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 11:41:40','',''),(2617911,'1','201','1037',478,'Retail Sale Id 1465424',4550.00,0.00,0.00,7.00,266.00,'2022-04-03 11:42:12','',''),(2617912,'1','201','1037',478,'Retail Sale Id 1465425',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 11:46:48','',''),(2617913,'1','201','1037',478,'Retail Sale Id 1465426',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 11:47:55','',''),(2617914,'1','201','1037',478,'Retail Sale Id 1465426',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 11:47:55','',''),(2617915,'1','201','1037',478,'Retail Sale Id 1465427',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 11:49:24','',''),(2617916,'1','201','1037',478,'Retail Sale Id 1465428',4550.00,0.00,0.00,7.00,266.00,'2022-04-03 11:52:51','',''),(2617917,'1','201','1037',478,'Retail Sale Id 1465429',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 11:54:09','',''),(2617918,'1','201','1037',478,'Retail Sale Id 1465430',4550.00,0.00,0.00,7.00,266.00,'2022-04-03 11:59:29','',''),(2617919,'1','201','1037',478,'Return of Retail Sale Id 1465428',0.00,4550.00,7.00,0.00,-266.00,'2022-04-03 12:02:52','',''),(2617920,'1','201','1037',478,'Retail Sale Id 1465431',4134.00,0.00,0.00,6.36,241.68,'2022-04-03 12:04:35','',''),(2617921,'1','201','1037',478,'Retail Sale Id 1465432',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 12:05:29','',''),(2617922,'1','201','1037',478,'Retail Sale Id 1465433',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 12:06:06','',''),(2617923,'1','201','1037',478,'Retail Sale Id 1465434',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 12:08:53','',''),(2617924,'1','201','1037',478,'Retail Sale Id 1465435',9100.00,0.00,0.00,14.00,532.00,'2022-04-03 12:13:13','',''),(2617925,'1','201','1037',478,'Retail Sale Id 1465436',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 12:14:22','',''),(2617926,'1','201','1037',478,'Retail Sale Id 1465437',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 12:16:22','',''),(2617927,'1','201','1037',478,'Retail Sale Id 1465437',8125.00,0.00,0.00,12.50,475.00,'2022-04-03 12:16:22','',''),(2617928,'1','201','1037',478,'Retail Sale Id 1465438',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 12:24:42','',''),(2617929,'1','201','1037',478,'Retail Sale Id 1465439',3003.00,0.00,0.00,4.62,175.56,'2022-04-03 12:25:32','',''),(2617930,'1','201','1037',478,'Retail Sale Id 1465440',650.00,0.00,0.00,1.00,38.00,'2022-04-03 12:36:36','',''),(2617931,'1','201','1037',478,'Retail Sale Id 1465441',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 12:37:38','',''),(2617932,'1','201','1037',478,'Retail Sale Id 1465442',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 12:43:30','',''),(2617933,'1','201','1037',478,'Retail Sale Id 1465443',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 12:45:22','',''),(2617934,'1','201','1037',478,'Retail Sale Id 1465444',2398.50,0.00,0.00,3.69,140.22,'2022-04-03 12:54:15','',''),(2617935,'1','201','1037',478,'Retail Sale Id 1465445',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 12:56:22','',''),(2617936,'1','201','1037',478,'Retail Sale Id 1465445',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 12:56:22','',''),(2617937,'1','201','1037',478,'Retail Sale Id 1465446',650.00,0.00,0.00,1.00,38.00,'2022-04-03 12:59:21','',''),(2617938,'1','201','1037',478,'Retail Sale Id 1465447',2600.00,0.00,0.00,4.00,152.00,'2022-04-03 13:02:18','',''),(2617939,'1','201','1037',478,'Retail Sale Id 1465448',1703.00,0.00,0.00,2.62,99.56,'2022-04-03 13:19:10','',''),(2617940,'1','201','1037',478,'Retail Sale Id 1465449',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 13:21:50','',''),(2617941,'1','201','1037',478,'Retail Sale Id 1465449',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 13:21:50','',''),(2617942,'1','201','1037',478,'Retail Sale Id 1465449',2600.00,0.00,0.00,4.00,152.00,'2022-04-03 13:21:50','',''),(2617943,'1','201','1037',478,'Retail Sale Id 1465450',2002.00,0.00,0.00,3.08,117.04,'2022-04-03 13:22:42','',''),(2617944,'1','201','1037',478,'Retail Sale Id 1465451',650.00,0.00,0.00,1.00,38.00,'2022-04-03 13:25:58','',''),(2617945,'1','201','1037',478,'Retail Sale Id 1465452',325.00,0.00,0.00,0.50,19.00,'2022-04-03 13:26:51','',''),(2617946,'1','201','1037',478,'Retail Sale Id 1465453',2600.00,0.00,0.00,4.00,152.00,'2022-04-03 13:27:21','',''),(2617947,'1','201','1037',478,'Retail Sale Id 1465454',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 13:29:24','',''),(2617948,'1','201','1037',478,'Retail Sale Id 1465455',325.00,0.00,0.00,0.50,19.00,'2022-04-03 13:30:11','',''),(2617949,'1','201','1037',478,'Retail Sale Id 1465456',2002.00,0.00,0.00,3.08,117.04,'2022-04-03 13:34:15','',''),(2617950,'1','201','1037',478,'Retail Sale Id 1465457',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 13:39:05','',''),(2617951,'1','201','1037',478,'Retail Sale Id 1465458',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 13:40:24','',''),(2617952,'1','201','1037',478,'Retail Sale Id 1465459',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 13:41:34','',''),(2617953,'1','201','1037',478,'Retail Sale Id 1465460',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 13:46:04','',''),(2617954,'1','201','1037',478,'Retail Sale Id 1465461',8125.00,0.00,0.00,12.50,475.00,'2022-04-03 13:51:57','',''),(2617955,'1','201','1037',478,'Retail Sale Id 1465462',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 13:55:00','',''),(2617956,'1','201','1037',478,'Retail Sale Id 1465463',8125.00,0.00,0.00,12.50,475.00,'2022-04-03 14:02:04','',''),(2617957,'1','201','1037',478,'Retail Sale Id 1465464',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 14:06:33','',''),(2617958,'1','201','1037',478,'Retail Sale Id 1465465',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 14:10:04','',''),(2617959,'1','201','1037',478,'Retail Sale Id 1465466',5200.00,0.00,0.00,8.00,304.00,'2022-04-03 14:11:17','',''),(2617960,'1','201','1037',478,'Retail Sale Id 1465467',5200.00,0.00,0.00,8.00,304.00,'2022-04-03 14:24:52','',''),(2617961,'1','201','1037',478,'Retail Sale Id 1465468',2002.00,0.00,0.00,3.08,117.04,'2022-04-03 14:28:50','',''),(2617962,'1','201','1037',478,'Retail Sale Id 1465470',6175.00,0.00,0.00,9.50,361.00,'2022-04-03 14:31:26','',''),(2617963,'1','201','1037',478,'Retail Sale Id 1465472',8125.00,0.00,0.00,12.50,475.00,'2022-04-03 14:33:44','',''),(2617964,'1','201','1037',478,'Retail Sale Id 1465473',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 14:35:07','',''),(2617965,'1','201','1037',478,'Retail Sale Id 1465474',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 14:36:04','',''),(2617966,'1','201','1037',478,'Retail Sale Id 1465475',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 14:37:27','',''),(2617967,'1','201','1037',478,'Retail Sale Id 1465476',18600.00,0.00,0.00,30.00,240.00,'2022-04-03 14:42:39','',''),(2617968,'1','201','1037',478,'Retail Sale Id 1465477',4550.00,0.00,0.00,7.00,266.00,'2022-04-03 14:43:51','',''),(2617969,'1','201','1037',478,'Retail Sale Id 1465478',2600.00,0.00,0.00,4.00,152.00,'2022-04-03 14:45:16','',''),(2617970,'1','201','1037',478,'Retail Sale Id 1465479',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 14:46:21','',''),(2617971,'1','201','1037',478,'Retail Sale Id 1465480',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 14:50:01','',''),(2617972,'1','201','1037',478,'Retail Sale Id 1465481',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 14:52:12','',''),(2617973,'1','201','1037',478,'Retail Sale Id 1465482',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 14:52:53','',''),(2617974,'1','201','1037',478,'Retail Sale Id 1465483',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 14:59:35','',''),(2617975,'1','201','1037',478,'Retail Sale Id 1465484',8125.00,0.00,0.00,12.50,475.00,'2022-04-03 15:03:46','',''),(2617976,'1','201','1037',478,'Retail Sale Id 1465485',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 15:05:50','',''),(2617977,'1','201','1037',478,'Retail Sale Id 1465486',234.00,0.00,0.00,0.36,13.68,'2022-04-03 15:07:05','',''),(2617978,'1','201','1037',478,'Retail Sale Id 1465487',799.50,0.00,0.00,1.23,46.74,'2022-04-03 15:08:07','',''),(2617979,'1','201','1037',478,'Retail Sale Id 1465488',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 15:09:52','',''),(2617980,'1','201','1037',478,'Retail Sale Id 1465489',1599.00,0.00,0.00,2.46,93.48,'2022-04-03 15:13:29','',''),(2617981,'1','201','1037',478,'Retail Sale Id 1465491',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 15:15:44','',''),(2617982,'1','201','1037',478,'Retail Sale Id 1465492',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 15:17:11','',''),(2617983,'1','201','1037',478,'Retail Sale Id 1465493',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 15:19:44','',''),(2617984,'1','201','1037',478,'Retail Sale Id 1465494',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 15:26:40','',''),(2617985,'1','201','1037',478,'Retail Sale Id 1465495',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 15:28:10','',''),(2617986,'1','201','1037',478,'Retail Sale Id 1465496',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 15:30:28','',''),(2617987,'1','201','1037',478,'Retail Sale Id 1465497',4550.00,0.00,0.00,7.00,266.00,'2022-04-03 15:38:51','',''),(2617988,'1','201','1037',478,'Retail Sale Id 1465498',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 15:41:34','',''),(2617989,'1','201','1037',478,'Retail Sale Id 1465499',8125.00,0.00,0.00,12.50,475.00,'2022-04-03 15:42:46','',''),(2617990,'1','201','1037',478,'Retail Sale Id 1465500',8125.00,0.00,0.00,12.50,475.00,'2022-04-03 15:47:20','',''),(2617991,'1','201','1037',478,'Retail Sale Id 1465501',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 15:52:28','',''),(2617992,'1','201','1037',478,'Retail Sale Id 1465502',2502.50,0.00,0.00,3.85,146.30,'2022-04-03 16:02:26','',''),(2617993,'1','201','1037',478,'Retail Sale Id 1465503',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 16:04:31','',''),(2617994,'1','201','1037',478,'Retail Sale Id 1465504',1001.00,0.00,0.00,1.54,58.52,'2022-04-03 16:17:42','',''),(2617995,'1','201','1037',478,'Retail Sale Id 1465505',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 16:18:44','',''),(2617996,'1','201','1037',478,'Retail Sale Id 1465506',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 16:22:21','',''),(2617997,'1','201','1037',478,'Retail Sale Id 1465507',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 16:23:33','',''),(2617998,'1','201','1037',478,'Retail Sale Id 1465508',6500.00,0.00,0.00,10.00,380.00,'2022-04-03 16:32:47','',''),(2617999,'1','201','1037',478,'Retail Sale Id 1465509',4550.00,0.00,0.00,7.00,266.00,'2022-04-03 16:33:54','',''),(2618000,'1','201','1037',478,'Retail Sale Id 1465510',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 16:36:42','',''),(2618001,'1','201','1037',478,'Retail Sale Id 1465511',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 16:37:30','',''),(2618002,'1','201','1037',478,'Retail Sale Id 1465512',3003.00,0.00,0.00,4.62,175.56,'2022-04-03 16:38:41','',''),(2618003,'1','201','1037',478,'Retail Sale Id 1465513',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 16:42:00','',''),(2618004,'1','201','1037',478,'Retail Sale Id 1465515',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 16:44:32','',''),(2618005,'1','201','1037',478,'Retail Sale Id 1465516',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 16:45:42','',''),(2618006,'1','201','1037',478,'Retail Sale Id 1465516',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 16:45:42','',''),(2618007,'1','201','1037',478,'Retail Sale Id 1465517',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 16:46:17','',''),(2618008,'1','201','1037',478,'Retail Sale Id 1465519',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 16:49:31','',''),(2618009,'1','201','1037',478,'Retail Sale Id 1465520',6500.00,0.00,0.00,10.00,380.00,'2022-04-03 16:50:04','',''),(2618010,'1','201','1037',478,'Retail Sale Id 1465521',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 16:52:48','',''),(2618011,'1','201','1037',478,'Retail Sale Id 1465522',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 16:54:51','',''),(2618012,'1','201','1037',478,'Retail Sale Id 1465523',2502.50,0.00,0.00,3.85,146.30,'2022-04-03 16:55:48','',''),(2618013,'1','201','1037',478,'Retail Sale Id 1465524',2002.00,0.00,0.00,3.08,117.04,'2022-04-03 16:56:41','',''),(2618014,'1','201','1037',478,'Retail Sale Id 1465525',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 17:02:21','',''),(2618015,'1','201','1037',478,'Retail Sale Id 1465526',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 17:03:21','',''),(2618016,'1','201','1037',478,'Retail Sale Id 1465527',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 17:09:28','',''),(2618017,'1','201','1037',478,'Retail Sale Id 1465528',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 17:17:59','',''),(2618018,'1','201','1037',478,'Retail Sale Id 1465529',2600.00,0.00,0.00,4.00,152.00,'2022-04-03 17:24:39','',''),(2618019,'1','201','1037',478,'Retail Sale Id 1465530',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 17:26:22','',''),(2618020,'1','201','1037',478,'Retail Sale Id 1465531',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 17:26:56','',''),(2618021,'1','201','1037',478,'Retail Sale Id 1465532',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 17:28:28','',''),(2618022,'1','201','1037',478,'Retail Sale Id 1465533',4550.00,0.00,0.00,7.00,266.00,'2022-04-03 17:31:02','',''),(2618023,'1','201','1037',478,'Retail Sale Id 1465534',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 17:31:58','',''),(2618024,'1','201','1037',478,'Retail Sale Id 1465535',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 17:38:24','',''),(2618025,'1','201','1037',478,'Retail Sale Id 1465535',8125.00,0.00,0.00,12.50,475.00,'2022-04-03 17:38:24','',''),(2618026,'1','201','1037',478,'Retail Sale Id 1465536',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 17:39:39','',''),(2618027,'1','201','1037',478,'Retail Sale Id 1465537',1501.50,0.00,0.00,2.31,87.78,'2022-04-03 17:40:15','',''),(2618028,'1','201','1037',478,'Retail Sale Id 1465538',8001.50,0.00,0.00,12.31,467.78,'2022-04-03 17:40:54','',''),(2618029,'1','201','1037',478,'Retail Sale Id 1465539',2600.00,0.00,0.00,4.00,152.00,'2022-04-03 17:41:29','',''),(2618030,'1','201','1037',478,'Retail Sale Id 1465540',2600.00,0.00,0.00,4.00,152.00,'2022-04-03 17:42:19','',''),(2618031,'1','201','1037',478,'Retail Sale Id 1465541',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 17:43:00','',''),(2618032,'1','201','1037',478,'Retail Sale Id 1465542',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 17:43:58','',''),(2618033,'1','201','1037',478,'Retail Sale Id 1465543',2275.00,0.00,0.00,3.50,133.00,'2022-04-03 17:45:29','',''),(2618034,'1','201','1037',478,'Retail Sale Id 1465544',6500.00,0.00,0.00,10.00,380.00,'2022-04-03 17:46:28','',''),(2618035,'1','201','1037',478,'Retail Sale Id 1465545',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 17:53:00','',''),(2618036,'1','201','1037',478,'Retail Sale Id 1465546',1300.00,0.00,0.00,2.00,76.00,'2022-04-03 17:57:34','',''),(2618037,'1','201','1037',478,'Retail Sale Id 1465547',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 18:07:14','',''),(2618038,'1','201','1037',478,'Return of Retail Sale Id 1465539',0.00,2600.00,4.00,0.00,-152.00,'2022-04-03 19:50:46','',''),(2618039,'1','201','1037',478,'Retail Sale Id 1465548',1534.00,0.00,0.00,2.36,89.68,'2022-04-03 19:52:15','',''),(2618040,'1','201','1037',478,'Retail Sale Id 1465549',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 07:52:32','',''),(2618041,'1','201','1037',478,'Retail Sale Id 1465550',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 08:17:03','',''),(2618042,'1','201','1037',478,'Retail Sale Id 1465551',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 08:21:39','',''),(2618043,'1','201','1037',478,'Retail Sale Id 1465552',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 08:30:11','',''),(2618044,'1','201','1037',478,'Retail Sale Id 1465553',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 08:43:55','',''),(2618045,'1','201','1037',478,'Retail Sale Id 1465554',1501.50,0.00,0.00,2.31,87.78,'2022-04-04 08:55:38','',''),(2618046,'1','201','1037',478,'Retail Sale Id 1465555',2600.00,0.00,0.00,4.00,152.00,'2022-04-04 09:03:45','',''),(2618047,'1','201','1037',478,'Retail Sale Id 1465556',3003.00,0.00,0.00,4.62,175.56,'2022-04-04 09:05:23','',''),(2618048,'1','201','1037',478,'Retail Sale Id 1465557',31000.00,0.00,0.00,50.00,400.00,'2022-04-04 09:08:22','',''),(2618049,'1','201','1037',478,'Retail Sale Id 1465558',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 09:17:35','',''),(2618050,'1','201','1037',478,'Retail Sale Id 1465559',4498.00,0.00,0.00,6.92,262.96,'2022-04-04 09:28:19','',''),(2618051,'1','201','1037',478,'Retail Sale Id 1465560',3497.00,0.00,0.00,5.38,204.44,'2022-04-04 09:29:11','',''),(2618052,'1','201','1037',478,'Retail Sale Id 1465561',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 09:31:13','',''),(2618053,'1','201','1037',478,'Retail Sale Id 1465562',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 09:32:46','',''),(2618054,'1','201','1037',478,'Retail Sale Id 1465563',1202.50,0.00,0.00,1.85,70.30,'2022-04-04 09:51:50','',''),(2618055,'1','201','1037',478,'Retail Sale Id 1465564',1001.00,0.00,0.00,1.54,58.52,'2022-04-04 09:53:45','',''),(2618056,'1','201','1037',478,'Retail Sale Id 1465565',15500.00,0.00,0.00,25.00,200.00,'2022-04-04 09:55:36','',''),(2618057,'1','201','1037',478,'Retail Sale Id 1465566',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 09:57:59','',''),(2618058,'1','201','1037',478,'Retail Sale Id 1465567',1501.50,0.00,0.00,2.31,87.78,'2022-04-04 10:02:38','',''),(2618059,'1','201','1037',478,'Retail Sale Id 1465568',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 10:03:54','',''),(2618060,'1','201','1037',478,'Retail Sale Id 1465569',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 10:05:49','',''),(2618061,'1','201','1037',478,'Retail Sale Id 1465570',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 10:09:11','',''),(2618062,'1','201','1037',478,'Retail Sale Id 1465571',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 10:10:36','',''),(2618063,'1','201','1037',478,'Retail Sale Id 1465572',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 10:12:54','',''),(2618064,'1','201','1037',478,'Retail Sale Id 1465573',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 10:18:09','',''),(2618065,'1','201','1037',478,'Retail Sale Id 1465574',2600.00,0.00,0.00,4.00,152.00,'2022-04-04 10:22:02','',''),(2618066,'1','201','1037',478,'Retail Sale Id 1465575',1001.00,0.00,0.00,1.54,58.52,'2022-04-04 10:24:25','',''),(2618067,'1','201','1037',478,'Retail Sale Id 1465576',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 10:26:20','',''),(2618068,'1','201','1037',478,'Retail Sale Id 1465577',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 10:27:23','',''),(2618069,'1','201','1037',478,'Retail Sale Id 1465578',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 10:55:14','',''),(2618070,'1','201','1037',478,'Retail Sale Id 1465579',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 10:57:49','',''),(2618071,'1','201','1037',478,'Retail Sale Id 1465580',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 11:00:02','',''),(2618072,'1','201','1037',478,'Retail Sale Id 1465580',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 11:00:02','',''),(2618073,'1','201','1037',478,'Retail Sale Id 1465581',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 11:02:29','',''),(2618074,'1','201','1037',478,'Retail Sale Id 1465582',2600.00,0.00,0.00,4.00,152.00,'2022-04-04 11:08:21','',''),(2618075,'1','201','1037',478,'Retail Sale Id 1465583',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 11:09:17','',''),(2618076,'1','201','1037',478,'Retail Sale Id 1465584',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 11:15:36','',''),(2618077,'1','201','1037',478,'Retail Sale Id 1465585',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 11:16:37','',''),(2618078,'1','201','1037',478,'Retail Sale Id 1465586',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 11:18:25','',''),(2618079,'1','201','1037',478,'Retail Sale Id 1465587',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 11:26:17','',''),(2618080,'1','201','1037',478,'Retail Sale Id 1465588',1001.00,0.00,0.00,1.54,58.52,'2022-04-04 11:27:28','',''),(2618081,'1','201','1037',478,'Retail Sale Id 1465589',2002.00,0.00,0.00,3.08,117.04,'2022-04-04 11:28:24','',''),(2618082,'1','201','1037',478,'Retail Sale Id 1465590',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 11:38:07','',''),(2618083,'1','201','1037',478,'Retail Sale Id 1465591',2600.00,0.00,0.00,4.00,152.00,'2022-04-04 11:51:27','',''),(2618084,'1','201','1037',478,'Retail Sale Id 1465592',669.50,0.00,0.00,1.03,39.14,'2022-04-04 11:56:51','',''),(2618085,'1','201','1037',478,'Retail Sale Id 1465593',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 12:07:09','',''),(2618086,'1','201','1037',478,'Retail Sale Id 1465594',1501.50,0.00,0.00,2.31,87.78,'2022-04-04 12:08:15','',''),(2618087,'1','201','1037',478,'Retail Sale Id 1465595',8001.50,0.00,0.00,12.31,467.78,'2022-04-04 12:11:07','',''),(2618088,'1','201','1037',478,'Retail Sale Id 1465596',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 12:18:43','',''),(2618089,'1','201','1037',478,'Retail Sale Id 1465596',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 12:18:43','',''),(2618090,'1','201','1037',478,'Retail Sale Id 1465596',4550.00,0.00,0.00,7.00,266.00,'2022-04-04 12:18:43','',''),(2618091,'1','201','1037',478,'Retail Sale Id 1465597',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 12:23:55','',''),(2618092,'1','201','1037',478,'Retail Sale Id 1465598',299.00,0.00,0.00,0.46,17.48,'2022-04-04 12:25:08','',''),(2618093,'1','201','1037',478,'Retail Sale Id 1465599',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 12:30:01','',''),(2618094,'1','201','1037',478,'Retail Sale Id 1465600',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 12:37:45','',''),(2618095,'1','201','1037',478,'Retail Sale Id 1465601',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 12:41:06','',''),(2618096,'1','201','1037',478,'Retail Sale Id 1465602',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 12:43:08','',''),(2618097,'1','201','1037',478,'Retail Sale Id 1465603',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 12:53:09','',''),(2618098,'1','201','1037',478,'Retail Sale Id 1465604',3003.00,0.00,0.00,4.62,175.56,'2022-04-04 12:54:23','',''),(2618099,'1','201','1037',478,'Retail Sale Id 1465605',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 12:55:59','',''),(2618100,'1','201','1037',478,'Retail Sale Id 1465606',799.50,0.00,0.00,1.23,46.74,'2022-04-04 12:58:20','',''),(2618101,'1','201','1037',478,'Retail Sale Id 1465607',2002.00,0.00,0.00,3.08,117.04,'2022-04-04 13:00:11','',''),(2618102,'1','201','1037',478,'Retail Sale Id 1465608',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 13:05:31','',''),(2618103,'1','201','1037',478,'Retail Sale Id 1465609',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 13:08:14','',''),(2618104,'1','201','1037',478,'Retail Sale Id 1465609',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 13:08:14','',''),(2618105,'1','201','1037',478,'Retail Sale Id 1465610',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 13:09:04','',''),(2618106,'1','201','1037',478,'Retail Sale Id 1465611',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 13:12:45','',''),(2618107,'1','201','1037',478,'Retail Sale Id 1465612',650.00,0.00,0.00,1.00,38.00,'2022-04-04 13:13:59','',''),(2618108,'1','201','1037',478,'Retail Sale Id 1465613',3720.00,0.00,0.00,6.00,48.00,'2022-04-04 13:24:34','',''),(2618109,'1','201','1037',478,'Retail Sale Id 1465614',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 13:29:14','',''),(2618110,'1','201','1037',478,'Retail Sale Id 1465615',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 13:32:17','',''),(2618111,'1','201','1037',478,'Retail Sale Id 1465616',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 13:34:04','',''),(2618112,'1','201','1037',478,'Retail Sale Id 1465617',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 13:36:00','',''),(2618113,'1','201','1037',478,'Retail Sale Id 1465618',650.00,0.00,0.00,1.00,38.00,'2022-04-04 13:37:51','',''),(2618114,'1','201','1037',478,'Retail Sale Id 1465619',3720.00,0.00,0.00,6.00,48.00,'2022-04-04 13:58:57','',''),(2618115,'1','201','1037',478,'Retail Sale Id 1465620',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 14:00:41','',''),(2618116,'1','201','1037',478,'Retail Sale Id 1465621',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 14:01:26','',''),(2618117,'1','201','1037',478,'Retail Sale Id 1465622',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 14:12:20','',''),(2618118,'1','201','1037',478,'Retail Sale Id 1465623',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 14:14:51','',''),(2618119,'1','201','1037',478,'Retail Sale Id 1465624',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 14:16:43','',''),(2618120,'1','201','1037',478,'Retail Sale Id 1465625',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 14:17:44','',''),(2618121,'1','201','1037',478,'Retail Sale Id 1465626',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 14:20:54','',''),(2618122,'1','201','1037',478,'Retail Sale Id 1465627',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 14:29:12','',''),(2618123,'1','201','1037',478,'Retail Sale Id 1465628',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 14:31:17','',''),(2618124,'1','201','1037',478,'Retail Sale Id 1465629',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 14:41:00','',''),(2618125,'1','201','1037',478,'Retail Sale Id 1465630',2600.00,0.00,0.00,4.00,152.00,'2022-04-04 14:42:43','',''),(2618126,'1','201','1037',478,'Retail Sale Id 1465630',2600.00,0.00,0.00,4.00,152.00,'2022-04-04 14:42:43','',''),(2618127,'1','201','1037',478,'Retail Sale Id 1465631',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 14:45:08','',''),(2618128,'1','201','1037',478,'Retail Sale Id 1465632',7800.00,0.00,0.00,12.00,456.00,'2022-04-04 14:51:31','',''),(2618129,'1','201','1037',478,'Retail Sale Id 1465633',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 15:03:47','',''),(2618130,'1','201','1037',478,'Retail Sale Id 1465634',1001.00,0.00,0.00,1.54,58.52,'2022-04-04 15:07:06','',''),(2618131,'1','201','1037',478,'Retail Sale Id 1465634',1001.00,0.00,0.00,1.54,58.52,'2022-04-04 15:07:06','',''),(2618132,'1','201','1037',478,'Retail Sale Id 1465635',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 15:10:19','',''),(2618133,'1','201','1037',478,'Retail Sale Id 1465636',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 15:11:45','',''),(2618134,'1','201','1037',478,'Retail Sale Id 1465637',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 15:18:32','',''),(2618135,'1','201','1037',478,'Retail Sale Id 1465638',7150.00,0.00,0.00,11.00,418.00,'2022-04-04 15:21:03','',''),(2618136,'1','201','1037',478,'Retail Sale Id 1465639',15500.00,0.00,0.00,25.00,200.00,'2022-04-04 15:25:55','',''),(2618137,'1','201','1037',478,'Retail Sale Id 1465640',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 15:33:20','',''),(2618138,'1','201','1037',478,'Retail Sale Id 1465641',2002.00,0.00,0.00,3.08,117.04,'2022-04-04 15:36:44','',''),(2618139,'1','201','1037',478,'Retail Sale Id 1465642',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 15:44:10','',''),(2618140,'1','201','1037',478,'Retail Sale Id 1465643',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 15:47:43','',''),(2618141,'1','201','1037',478,'Retail Sale Id 1465644',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 15:48:37','',''),(2618142,'1','201','1037',478,'Retail Sale Id 1465645',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 15:49:30','',''),(2618143,'1','201','1037',478,'Retail Sale Id 1465646',2502.50,0.00,0.00,3.85,146.30,'2022-04-04 15:54:21','',''),(2618144,'1','201','1037',478,'Return of Retail Sale Id 1465599',0.00,1950.00,3.00,0.00,-114.00,'2022-04-04 16:00:33','',''),(2618145,'1','201','1037',478,'Retail Sale Id 1465647',1748.50,0.00,0.00,2.69,102.22,'2022-04-04 16:02:20','',''),(2618146,'1','201','1037',478,'Retail Sale Id 1465648',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 16:15:04','',''),(2618147,'1','201','1037',478,'Retail Sale Id 1465649',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 16:17:20','',''),(2618148,'1','201','1037',478,'Retail Sale Id 1465650',7501.00,0.00,0.00,11.54,438.52,'2022-04-04 16:18:52','',''),(2618149,'1','201','1037',478,'Retail Sale Id 1465651',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 16:21:16','',''),(2618150,'1','201','1037',478,'Retail Sale Id 1465652',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 16:22:24','',''),(2618151,'1','201','1037',478,'Retail Sale Id 1465653',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 16:23:41','',''),(2618152,'1','201','1037',478,'Retail Sale Id 1465654',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 16:24:44','',''),(2618153,'1','201','1037',478,'Retail Sale Id 1465655',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 16:25:40','',''),(2618154,'1','201','1037',478,'Retail Sale Id 1465656',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 16:26:31','',''),(2618155,'1','201','1037',478,'Retail Sale Id 1465657',3497.00,0.00,0.00,5.38,204.44,'2022-04-04 16:33:22','',''),(2618156,'1','201','1037',478,'Retail Sale Id 1465658',2925.00,0.00,0.00,4.50,171.00,'2022-04-04 16:34:39','',''),(2618157,'1','201','1037',478,'Retail Sale Id 1465659',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 16:35:46','',''),(2618158,'1','201','1037',478,'Retail Sale Id 1465660',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 16:37:15','',''),(2618159,'1','201','1037',478,'Retail Sale Id 1465661',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 16:38:06','',''),(2618160,'1','201','1037',478,'Retail Sale Id 1465662',1501.50,0.00,0.00,2.31,87.78,'2022-04-04 16:41:02','',''),(2618161,'1','201','1037',478,'Retail Sale Id 1465663',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 16:42:42','',''),(2618162,'1','201','1037',478,'Retail Sale Id 1465664',1001.00,0.00,0.00,1.54,58.52,'2022-04-04 16:43:45','',''),(2618163,'1','201','1037',478,'Retail Sale Id 1465665',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 16:44:30','',''),(2618164,'1','201','1037',478,'Retail Sale Id 1465666',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 16:47:13','',''),(2618165,'1','201','1037',478,'Retail Sale Id 1465667',897.00,0.00,0.00,1.38,52.44,'2022-04-04 16:49:04','',''),(2618166,'1','201','1037',478,'Retail Sale Id 1465668',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 16:51:05','',''),(2618167,'1','201','1037',478,'Retail Sale Id 1465669',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 16:52:56','',''),(2618168,'1','201','1037',478,'Retail Sale Id 1465670',7800.00,0.00,0.00,12.00,456.00,'2022-04-04 16:55:31','',''),(2618169,'1','201','1037',478,'Retail Sale Id 1465671',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 16:56:24','',''),(2618170,'1','201','1037',478,'Retail Sale Id 1465672',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 16:57:29','',''),(2618171,'1','201','1037',478,'Retail Sale Id 1465673',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 16:58:19','',''),(2618172,'1','201','1037',478,'Retail Sale Id 1465674',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 16:59:07','',''),(2618173,'1','201','1037',478,'Retail Sale Id 1465675',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 16:59:59','',''),(2618174,'1','201','1037',478,'Retail Sale Id 1465676',6825.00,0.00,0.00,10.50,399.00,'2022-04-04 17:04:33','',''),(2618175,'1','201','1037',478,'Retail Sale Id 1465677',650.00,0.00,0.00,1.00,38.00,'2022-04-04 17:06:45','',''),(2618176,'1','201','1037',478,'Retail Sale Id 1465678',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 17:10:46','',''),(2618177,'1','201','1037',478,'Retail Sale Id 1465679',2600.00,0.00,0.00,4.00,152.00,'2022-04-04 17:12:41','',''),(2618178,'1','201','1037',478,'Retail Sale Id 1465680',2600.00,0.00,0.00,4.00,152.00,'2022-04-04 17:16:18','',''),(2618179,'1','201','1037',478,'Retail Sale Id 1465681',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 17:17:23','',''),(2618180,'1','201','1037',478,'Retail Sale Id 1465682',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 17:20:20','',''),(2618181,'1','201','1037',478,'Retail Sale Id 1465683',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 17:21:18','',''),(2618182,'1','201','1037',478,'Retail Sale Id 1465684',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 17:22:35','',''),(2618183,'1','201','1037',478,'Retail Sale Id 1465685',1001.00,0.00,0.00,1.54,58.52,'2022-04-04 17:23:33','',''),(2618184,'1','201','1037',478,'Retail Sale Id 1465686',650.00,0.00,0.00,1.00,38.00,'2022-04-04 17:24:21','',''),(2618185,'1','201','1037',478,'Retail Sale Id 1465687',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 17:25:10','',''),(2618186,'1','201','1037',478,'Retail Sale Id 1465688',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 17:25:59','',''),(2618187,'1','201','1037',478,'Retail Sale Id 1465689',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 17:27:13','',''),(2618188,'1','201','1037',478,'Retail Sale Id 1465690',2600.00,0.00,0.00,4.00,152.00,'2022-04-04 17:28:38','',''),(2618189,'1','201','1037',478,'Retail Sale Id 1465691',2002.00,0.00,0.00,3.08,117.04,'2022-04-04 17:29:35','',''),(2618190,'1','201','1037',478,'Retail Sale Id 1465692',6500.00,0.00,0.00,10.00,380.00,'2022-04-04 17:32:09','',''),(2618191,'1','201','1037',478,'Retail Sale Id 1465693',3003.00,0.00,0.00,4.62,175.56,'2022-04-04 17:33:03','',''),(2618192,'1','201','1037',478,'Retail Sale Id 1465694',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 17:34:07','',''),(2618193,'1','201','1037',478,'Retail Sale Id 1465695',6500.00,0.00,0.00,10.00,380.00,'2022-04-04 17:36:27','',''),(2618194,'1','201','1037',478,'Retail Sale Id 1465696',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 17:43:31','',''),(2618195,'1','201','1037',478,'Retail Sale Id 1465697',3497.00,0.00,0.00,5.38,204.44,'2022-04-04 17:45:28','',''),(2618196,'1','201','1037',478,'Retail Sale Id 1465698',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 17:46:38','',''),(2618197,'1','201','1037',478,'Retail Sale Id 1465699',4225.00,0.00,0.00,6.50,247.00,'2022-04-04 17:50:48','',''),(2618198,'1','201','1037',478,'Retail Sale Id 1465700',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 18:02:19','',''),(2618199,'1','201','1037',478,'Retail Sale Id 1465701',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 18:04:00','',''),(2618200,'1','201','1037',478,'Retail Sale Id 1465702',500.50,0.00,0.00,0.77,29.26,'2022-04-04 18:05:05','',''),(2618201,'1','201','1037',478,'Retail Sale Id 1465703',2002.00,0.00,0.00,3.08,117.04,'2022-04-04 18:11:18','',''),(2618202,'1','201','1037',478,'Retail Sale Id 1465704',1300.00,0.00,0.00,2.00,76.00,'2022-04-04 18:13:42','',''),(2618203,'1','201','1037',478,'Return of Retail Sale Id 1465703',0.00,2002.00,3.08,0.00,-117.04,'2022-04-04 20:13:07','',''),(2618204,'1','201','1037',478,'Retail Sale Id 1465705',1813.50,0.00,0.00,2.79,106.02,'2022-04-04 20:15:08','',''),(2618205,'1','201','1037',478,'Return of Retail Sale Id 1465705',0.00,1813.50,2.79,0.00,-106.02,'2022-04-04 20:20:26','',''),(2618206,'1','201','1037',478,'Retail Sale Id 1465706',1794.00,0.00,0.00,2.76,104.88,'2022-04-04 20:22:05','',''),(2618207,'1','201','1037',478,'Retail Sale Id 1465707',1300.00,0.00,0.00,2.00,76.00,'2022-04-05 07:56:23','',''),(2618208,'1','201','1037',478,'Retail Sale Id 1465708',3575.00,0.00,0.00,5.50,209.00,'2022-04-05 08:21:02','',''),(2618209,'1','201','1037',478,'Retail Sale Id 1465709',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 08:27:30','',''),(2618210,'1','201','1037',478,'Retail Sale Id 1465710',3250.00,0.00,0.00,5.00,190.00,'2022-04-05 08:31:56','',''),(2618211,'1','201','1037',478,'Retail Sale Id 1465711',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 09:04:12','',''),(2618212,'1','201','1037',478,'Retail Sale Id 1465712',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 09:13:36','',''),(2618213,'1','201','1037',478,'Retail Sale Id 1465713',3250.00,0.00,0.00,5.00,190.00,'2022-04-05 09:21:00','',''),(2618214,'1','201','1037',478,'Retail Sale Id 1465714',7440.00,0.00,0.00,12.00,96.00,'2022-04-05 09:23:08','',''),(2618215,'1','201','1037',478,'Retail Sale Id 1465715',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 09:28:17','',''),(2618216,'1','201','1037',478,'Retail Sale Id 1465716',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 09:32:13','',''),(2618217,'1','201','1037',478,'Retail Sale Id 1465717',2600.00,0.00,0.00,4.00,152.00,'2022-04-05 09:41:17','',''),(2618218,'1','201','1037',478,'Retail Sale Id 1465718',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 09:55:40','',''),(2618219,'1','201','1037',478,'Retail Sale Id 1465719',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 10:06:02','',''),(2618220,'1','201','1037',478,'Retail Sale Id 1465720',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 10:12:39','',''),(2618221,'1','201','1037',478,'Retail Sale Id 1465720',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 10:12:39','',''),(2618222,'1','201','1037',478,'Retail Sale Id 1465721',2002.00,0.00,0.00,3.08,117.04,'2022-04-05 10:39:54','',''),(2618223,'1','201','1037',478,'Retail Sale Id 1465722',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 10:43:59','',''),(2618224,'1','201','1037',478,'Retail Sale Id 1465723',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 10:51:55','',''),(2618225,'1','201','1037',478,'Retail Sale Id 1465724',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 10:58:42','',''),(2618226,'1','201','1037',478,'Retail Sale Id 1465725',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 11:03:56','',''),(2618227,'1','201','1037',478,'Retail Sale Id 1465726',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 11:15:02','',''),(2618228,'1','201','1037',478,'Retail Sale Id 1465727',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 11:20:12','',''),(2618229,'1','201','1037',478,'Retail Sale Id 1465728',1300.00,0.00,0.00,2.00,76.00,'2022-04-05 11:21:19','',''),(2618230,'1','201','1037',478,'Retail Sale Id 1465729',1300.00,0.00,0.00,2.00,76.00,'2022-04-05 11:21:54','',''),(2618231,'1','201','1037',478,'Retail Sale Id 1465730',1300.00,0.00,0.00,2.00,76.00,'2022-04-05 11:22:30','',''),(2618232,'1','201','1037',478,'Retail Sale Id 1465731',650.00,0.00,0.00,1.00,38.00,'2022-04-05 11:23:47','',''),(2618233,'1','201','1037',478,'Retail Sale Id 1465732',1651.00,0.00,0.00,2.54,96.52,'2022-04-05 11:26:02','',''),(2618234,'1','201','1037',478,'Return of Retail Sale Id 1465727',0.00,1950.00,3.00,0.00,-114.00,'2022-04-05 11:27:07','',''),(2618235,'1','201','1037',478,'Retail Sale Id 1465733',1001.00,0.00,0.00,1.54,58.52,'2022-04-05 11:33:50','',''),(2618236,'1','201','1037',478,'Retail Sale Id 1465734',2002.00,0.00,0.00,3.08,117.04,'2022-04-05 11:39:35','',''),(2618237,'1','201','1037',478,'Retail Sale Id 1465735',1300.00,0.00,0.00,2.00,76.00,'2022-04-05 11:47:17','',''),(2618238,'1','201','1037',478,'Retail Sale Id 1465736',5200.00,0.00,0.00,8.00,304.00,'2022-04-05 11:48:37','',''),(2618239,'1','201','1037',478,'Retail Sale Id 1465737',1300.00,0.00,0.00,2.00,76.00,'2022-04-05 11:49:29','',''),(2618240,'1','201','1037',478,'Retail Sale Id 1465738',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 11:55:24','',''),(2618241,'1','201','1037',478,'Retail Sale Id 1465739',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 12:00:35','',''),(2618242,'1','201','1037',478,'Retail Sale Id 1465740',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 12:04:58','',''),(2618243,'1','201','1037',478,'Retail Sale Id 1465741',1300.00,0.00,0.00,2.00,76.00,'2022-04-05 12:07:23','',''),(2618244,'1','201','1037',478,'Retail Sale Id 1465742',650.00,0.00,0.00,1.00,38.00,'2022-04-05 12:18:59','',''),(2618245,'1','201','1037',478,'Retail Sale Id 1465743',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 12:21:24','',''),(2618246,'1','201','1037',478,'Retail Sale Id 1465744',2002.00,0.00,0.00,3.08,117.04,'2022-04-05 12:25:11','',''),(2618247,'1','201','1037',478,'Retail Sale Id 1465745',1300.00,0.00,0.00,2.00,76.00,'2022-04-05 12:32:32','',''),(2618248,'1','201','1037',478,'Retail Sale Id 1465746',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 12:33:35','',''),(2618249,'1','201','1037',478,'Retail Sale Id 1465747',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 12:34:24','',''),(2618250,'1','201','1037',478,'Retail Sale Id 1465748',4550.00,0.00,0.00,7.00,266.00,'2022-04-05 12:38:09','',''),(2618251,'1','201','1037',478,'Retail Sale Id 1465749',4160.00,0.00,0.00,6.40,243.20,'2022-04-05 12:56:26','',''),(2618252,'1','201','1037',478,'Retail Sale Id 1465750',3250.00,0.00,0.00,5.00,190.00,'2022-04-05 13:03:05','',''),(2618253,'1','201','1037',478,'Return of Retail Sale Id 1465748',0.00,4550.00,7.00,0.00,-266.00,'2022-04-05 13:13:04','',''),(2618254,'1','201','1037',478,'Retail Sale Id 1465751',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 13:16:31','',''),(2618255,'1','201','1037',478,'Retail Sale Id 1465752',7800.00,0.00,0.00,12.00,456.00,'2022-04-05 13:25:06','',''),(2618256,'1','201','1037',478,'Retail Sale Id 1465753',1202.50,0.00,0.00,1.85,70.30,'2022-04-05 13:27:04','',''),(2618257,'1','201','1037',478,'Retail Sale Id 1465754',88660.00,0.00,0.00,143.00,1144.00,'2022-04-05 13:48:35','',''),(2618258,'1','201','1037',478,'Return of Retail Sale Id 1465753',0.00,1202.50,1.85,0.00,-70.30,'2022-04-05 14:31:04','',''),(2618259,'1','201','1037',478,'Return of Retail Sale Id 1465751',0.00,8125.00,12.50,0.00,-475.00,'2022-04-05 14:32:06','',''),(2618260,'1','201','1037',478,'Return of Retail Sale Id 1465750',0.00,3250.00,5.00,0.00,-190.00,'2022-04-05 14:32:50','',''),(2618261,'1','201','1037',478,'Return of Retail Sale Id 1465754',0.00,88660.00,143.00,0.00,-1144.00,'2022-04-05 14:33:53','',''),(2618262,'1','201','1037',478,'Retail Sale Id 1465755',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 17:07:26','',''),(2618263,'1','201','1037',478,'Retail Sale Id 1465756',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 17:08:34','',''),(2618264,'1','201','1037',478,'Retail Sale Id 1465757',4550.00,0.00,0.00,7.00,266.00,'2022-04-05 17:27:51','',''),(2618265,'1','201','1037',478,'Retail Sale Id 1465758',3250.00,0.00,0.00,5.00,190.00,'2022-04-05 17:30:17','',''),(2618266,'1','201','1037',478,'Retail Sale Id 1465759',1969.50,0.00,0.00,3.03,115.14,'2022-04-05 17:40:11','',''),(2618267,'1','201','1037',478,'Return of Retail Sale Id 1465755',0.00,3003.00,4.62,0.00,-175.56,'2022-04-05 17:42:14','',''),(2618268,'1','201','1037',478,'Return of Retail Sale Id 1465707',0.00,1300.00,2.00,0.00,-76.00,'2022-04-05 17:44:51','',''),(2618269,'1','201','1037',478,'Return of Retail Sale Id 1465758',0.00,3250.00,5.00,0.00,-190.00,'2022-04-05 17:45:55','',''),(2618270,'1','201','1037',478,'Return of Retail Sale Id 1465757',0.00,4550.00,7.00,0.00,-266.00,'2022-04-05 17:46:43','',''),(2618271,'1','201','1037',478,'Retail Sale Id 1465760',39.00,0.00,0.00,0.06,2.28,'2022-04-05 20:45:58','',''),(2618272,'1','201','1037',478,'Retail Sale Id 1465761',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 08:08:13','',''),(2618273,'1','201','1037',478,'Retail Sale Id 1465762',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 09:01:23','',''),(2618274,'1','201','1037',478,'Retail Sale Id 1465763',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 09:04:02','',''),(2618275,'1','201','1037',478,'Retail Sale Id 1465764',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 09:04:46','',''),(2618276,'1','201','1037',478,'Retail Sale Id 1465765',35165.00,0.00,0.00,54.10,2055.80,'2022-04-14 09:09:31','',''),(2618277,'1','201','1037',478,'Retail Sale Id 1465766',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 09:17:40','',''),(2618278,'1','201','1037',478,'Retail Sale Id 1465767',2567.50,0.00,0.00,3.95,150.10,'2022-04-14 09:28:56','',''),(2618279,'1','201','1037',478,'Retail Sale Id 1465768',6500.00,0.00,0.00,10.00,380.00,'2022-04-14 09:30:34','',''),(2618280,'1','201','1037',478,'Retail Sale Id 1465769',3250.00,0.00,0.00,5.00,190.00,'2022-04-14 09:39:46','',''),(2618281,'1','201','1037',478,'Retail Sale Id 1465770',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 09:47:36','',''),(2618282,'1','201','1037',478,'Retail Sale Id 1465771',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 10:09:52','',''),(2618283,'1','201','1037',478,'Retail Sale Id 1465772',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 10:10:45','',''),(2618284,'1','201','1037',478,'Retail Sale Id 1465773',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 10:25:38','',''),(2618285,'1','201','1037',478,'Retail Sale Id 1465774',2002.00,0.00,0.00,3.08,117.04,'2022-04-14 10:28:47','',''),(2618286,'1','201','1037',478,'Retail Sale Id 1465775',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 10:35:29','',''),(2618287,'1','201','1037',478,'Retail Sale Id 1465775',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 10:35:29','',''),(2618288,'1','201','1037',478,'Retail Sale Id 1465776',2600.00,0.00,0.00,4.00,152.00,'2022-04-14 11:02:16','',''),(2618289,'1','201','1037',478,'Retail Sale Id 1465777',3497.00,0.00,0.00,5.38,204.44,'2022-04-14 11:12:33','',''),(2618290,'1','201','1037',478,'Retail Sale Id 1465778',8450.00,0.00,0.00,13.00,494.00,'2022-04-14 11:16:11','',''),(2618291,'1','201','1037',478,'Retail Sale Id 1465778',8450.00,0.00,0.00,13.00,494.00,'2022-04-14 11:16:11','',''),(2618292,'1','201','1037',478,'Retail Sale Id 1465779',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 11:23:31','',''),(2618293,'1','201','1037',478,'Retail Sale Id 1465780',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 11:31:17','',''),(2618294,'1','201','1037',478,'Retail Sale Id 1465781',1001.00,0.00,0.00,1.54,58.52,'2022-04-14 11:57:58','',''),(2618295,'1','201','1037',478,'Retail Sale Id 1465782',2600.00,0.00,0.00,4.00,152.00,'2022-04-14 11:59:06','',''),(2618296,'1','201','1037',478,'Retail Sale Id 1465783',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 12:03:03','',''),(2618297,'1','201','1037',478,'Retail Sale Id 1465784',5850.00,0.00,0.00,9.00,342.00,'2022-04-14 12:12:50','',''),(2618298,'1','201','1037',478,'Retail Sale Id 1465785',2002.00,0.00,0.00,3.08,117.04,'2022-04-14 12:50:25','',''),(2618299,'1','201','1037',478,'Retail Sale Id 1465786',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 12:54:32','',''),(2618300,'1','201','1037',478,'Retail Sale Id 1465787',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 12:55:21','',''),(2618301,'1','201','1037',478,'Retail Sale Id 1465788',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 12:55:56','',''),(2618302,'1','201','1037',478,'Retail Sale Id 1465789',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 12:56:29','',''),(2618303,'1','201','1037',478,'Retail Sale Id 1465790',650.00,0.00,0.00,1.00,38.00,'2022-04-14 12:57:05','',''),(2618304,'1','201','1037',478,'Retail Sale Id 1465791',1800.50,0.00,0.00,2.77,105.26,'2022-04-14 13:05:40','',''),(2618305,'1','201','1037',478,'Retail Sale Id 1465792',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 13:07:18','',''),(2618306,'1','201','1037',478,'Retail Sale Id 1465792',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 13:07:18','',''),(2618307,'1','201','1037',478,'Retail Sale Id 1465793',2480.00,0.00,0.00,4.00,32.00,'2022-04-14 13:11:03','',''),(2618308,'1','201','1037',478,'Retail Sale Id 1465794',3250.00,0.00,0.00,5.00,190.00,'2022-04-14 13:12:07','',''),(2618309,'1','201','1037',478,'Return of Retail Sale Id 1465791',0.00,1800.50,2.77,0.00,-105.26,'2022-04-14 13:15:13','',''),(2618310,'1','201','1037',478,'Retail Sale Id 1465795',2600.00,0.00,0.00,4.00,152.00,'2022-04-14 13:18:53','',''),(2618311,'1','201','1037',478,'Retail Sale Id 1465796',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 13:25:13','',''),(2618312,'1','201','1037',478,'Retail Sale Id 1465797',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 13:42:31','',''),(2618313,'1','201','1037',478,'Retail Sale Id 1465798',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 14:00:14','',''),(2618314,'1','201','1037',478,'Retail Sale Id 1465798',7800.00,0.00,0.00,12.00,456.00,'2022-04-14 14:00:14','',''),(2618315,'1','201','1037',478,'Retail Sale Id 1465799',3698.50,0.00,0.00,5.69,216.22,'2022-04-14 14:01:09','',''),(2618316,'1','201','1037',478,'Retail Sale Id 1465800',3250.00,0.00,0.00,5.00,190.00,'2022-04-14 14:02:25','',''),(2618317,'1','201','1037',478,'Retail Sale Id 1465801',2600.00,0.00,0.00,4.00,152.00,'2022-04-14 14:05:03','',''),(2618318,'1','201','1037',478,'Retail Sale Id 1465802',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 14:08:16','',''),(2618319,'1','201','1037',478,'Retail Sale Id 1465803',3003.00,0.00,0.00,4.62,175.56,'2022-04-14 14:15:53','',''),(2618320,'1','201','1037',478,'Retail Sale Id 1465804',1501.50,0.00,0.00,2.31,87.78,'2022-04-14 14:19:44','',''),(2618321,'1','201','1037',478,'Retail Sale Id 1465805',4550.00,0.00,0.00,7.00,266.00,'2022-04-14 14:41:27','',''),(2618322,'1','201','1037',478,'Retail Sale Id 1465806',3250.00,0.00,0.00,5.00,190.00,'2022-04-14 14:43:47','',''),(2618323,'1','201','1037',478,'Retail Sale Id 1465807',2801.50,0.00,0.00,4.31,163.78,'2022-04-14 14:48:52','',''),(2618324,'1','201','1037',478,'Retail Sale Id 1465808',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 14:59:46','',''),(2618325,'1','201','1037',478,'Retail Sale Id 1465809',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 15:10:07','',''),(2618326,'1','201','1037',478,'Retail Sale Id 1465810',6500.00,0.00,0.00,10.00,380.00,'2022-04-14 15:14:45','',''),(2618327,'1','201','1037',478,'Retail Sale Id 1465811',2600.00,0.00,0.00,4.00,152.00,'2022-04-14 15:16:25','',''),(2618328,'1','201','1037',478,'Retail Sale Id 1465812',3250.00,0.00,0.00,5.00,190.00,'2022-04-14 15:18:30','',''),(2618329,'1','201','1037',478,'Retail Sale Id 1465812',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 15:18:30','',''),(2618330,'1','201','1037',478,'Retail Sale Id 1465813',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 15:30:06','',''),(2618331,'1','201','1037',478,'Retail Sale Id 1465814',3250.00,0.00,0.00,5.00,190.00,'2022-04-14 15:32:28','',''),(2618332,'1','201','1037',478,'Retail Sale Id 1465815',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 15:33:47','',''),(2618333,'1','201','1037',478,'Retail Sale Id 1465816',1599.00,0.00,0.00,2.46,93.48,'2022-04-14 15:40:16','',''),(2618334,'1','201','1037',478,'Retail Sale Id 1465817',1001.00,0.00,0.00,1.54,58.52,'2022-04-14 15:48:28','',''),(2618335,'1','201','1037',478,'Retail Sale Id 1465818',3250.00,0.00,0.00,5.00,190.00,'2022-04-14 15:55:38','',''),(2618336,'1','201','1037',478,'Retail Sale Id 1465819',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 15:56:32','',''),(2618337,'1','201','1037',478,'Retail Sale Id 1465820',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 16:11:18','',''),(2618338,'1','201','1037',478,'Retail Sale Id 1465821',92250.00,0.00,0.00,150.00,450.00,'2022-04-14 16:13:10','',''),(2618339,'1','201','1037',478,'Retail Sale Id 1465822',650.00,0.00,0.00,1.00,38.00,'2022-04-14 16:15:29','',''),(2618340,'1','201','1037',478,'Retail Sale Id 1465823',2600.00,0.00,0.00,4.00,152.00,'2022-04-14 16:17:12','',''),(2618341,'1','201','1037',478,'Retail Sale Id 1465824',4550.00,0.00,0.00,7.00,266.00,'2022-04-14 16:18:44','',''),(2618342,'1','201','1037',478,'Retail Sale Id 1465825',2600.00,0.00,0.00,4.00,152.00,'2022-04-14 16:20:05','',''),(2618343,'1','201','1037',478,'Retail Sale Id 1465826',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 16:21:11','',''),(2618344,'1','201','1037',478,'Retail Sale Id 1465827',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 16:22:08','',''),(2618345,'1','201','1037',478,'Retail Sale Id 1465828',1001.00,0.00,0.00,1.54,58.52,'2022-04-14 16:23:07','',''),(2618346,'1','201','1037',478,'Retail Sale Id 1465829',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 16:26:09','',''),(2618347,'1','201','1037',478,'Retail Sale Id 1465830',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 16:28:01','',''),(2618348,'1','201','1037',478,'Retail Sale Id 1465831',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 16:40:01','',''),(2618349,'1','201','1037',478,'Retail Sale Id 1465832',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 16:42:36','',''),(2618350,'1','201','1037',478,'Retail Sale Id 1465833',3250.00,0.00,0.00,5.00,190.00,'2022-04-14 16:49:12','',''),(2618351,'1','201','1037',478,'Retail Sale Id 1465834',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 16:51:05','',''),(2618352,'1','201','1037',478,'Retail Sale Id 1465835',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 16:51:56','',''),(2618353,'1','201','1037',478,'Retail Sale Id 1465836',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 16:52:57','',''),(2618354,'1','201','1037',478,'Retail Sale Id 1465837',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 16:58:09','',''),(2618355,'1','201','1037',478,'Retail Sale Id 1465839',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 17:03:27','',''),(2618356,'1','201','1037',478,'Retail Sale Id 1465840',3003.00,0.00,0.00,4.62,175.56,'2022-04-14 17:17:46','',''),(2618357,'1','201','1037',478,'Retail Sale Id 1465841',1202.50,0.00,0.00,1.85,70.30,'2022-04-14 17:18:48','',''),(2618358,'1','201','1037',478,'Retail Sale Id 1465842',650.00,0.00,0.00,1.00,38.00,'2022-04-14 17:21:21','',''),(2618359,'1','201','1037',478,'Retail Sale Id 1465843',3003.00,0.00,0.00,4.62,175.56,'2022-04-14 17:24:03','',''),(2618360,'1','201','1037',478,'Retail Sale Id 1465844',1300.00,0.00,0.00,2.00,76.00,'2022-04-14 17:25:04','',''),(2618361,'1','201','1037',478,'Retail Sale Id 1465845',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 17:26:57','',''),(2618362,'1','201','1037',478,'Retail Sale Id 1465846',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 17:28:13','',''),(2618363,'1','201','1037',478,'Retail Sale Id 1465847',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 17:31:50','',''),(2618364,'1','201','1037',478,'Retail Sale Id 1465848',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 17:32:58','',''),(2618365,'1','201','1037',478,'Retail Sale Id 1465849',4550.00,0.00,0.00,7.00,266.00,'2022-04-14 17:45:16','',''),(2618366,'1','201','1037',478,'Retail Sale Id 1465850',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 17:46:26','',''),(2618367,'1','201','1037',478,'Retail Sale Id 1465851',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 17:49:35','',''),(2618368,'1','201','1037',478,'Retail Sale Id 1465852',1001.00,0.00,0.00,1.54,58.52,'2022-04-14 17:50:14','',''),(2618369,'1','201','1037',478,'Retail Sale Id 1465853',12400.00,0.00,0.00,20.00,160.00,'2022-04-15 07:34:38','',''),(2618370,'1','201','1037',478,'Retail Sale Id 1465854',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 07:55:59','',''),(2618371,'1','201','1037',478,'Retail Sale Id 1465855',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 09:02:48','',''),(2618372,'1','201','1037',478,'Retail Sale Id 1465856',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 09:17:46','',''),(2618373,'1','201','1037',478,'Retail Sale Id 1465857',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 09:41:02','',''),(2618374,'1','201','1037',478,'Retail Sale Id 1465858',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 09:54:30','',''),(2618375,'1','201','1037',478,'Retail Sale Id 1465859',3250.00,0.00,0.00,5.00,190.00,'2022-04-15 10:06:35','',''),(2618376,'1','201','1037',478,'Retail Sale Id 1465860',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 10:30:58','',''),(2618377,'1','201','1037',478,'Retail Sale Id 1465861',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 10:33:33','',''),(2618378,'1','201','1037',478,'Retail Sale Id 1465862',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 10:40:11','',''),(2618379,'1','201','1037',478,'Retail Sale Id 1465863',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 10:42:36','',''),(2618380,'1','201','1037',478,'Retail Sale Id 1465864',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 11:00:11','',''),(2618381,'1','201','1037',478,'Retail Sale Id 1465865',3250.00,0.00,0.00,5.00,190.00,'2022-04-15 11:34:08','',''),(2618382,'1','201','1037',478,'Retail Sale Id 1465866',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 11:39:00','',''),(2618383,'1','201','1037',478,'Retail Sale Id 1465867',4550.00,0.00,0.00,7.00,266.00,'2022-04-15 11:44:55','',''),(2618384,'1','201','1037',478,'Retail Sale Id 1465868',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 11:47:01','',''),(2618385,'1','201','1037',478,'Retail Sale Id 1465869',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 11:48:52','',''),(2618386,'1','201','1037',478,'Retail Sale Id 1465870',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 11:52:38','',''),(2618387,'1','201','1037',478,'Retail Sale Id 1465871',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 11:53:33','',''),(2618388,'1','201','1037',478,'Retail Sale Id 1465872',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 12:03:04','',''),(2618389,'1','201','1037',478,'Retail Sale Id 1465873',3770.00,0.00,0.00,5.80,220.40,'2022-04-15 12:08:27','',''),(2618390,'1','201','1037',478,'Return of Retail Sale Id 1465872',0.00,3900.00,6.00,0.00,-228.00,'2022-04-15 12:18:08','',''),(2618391,'1','201','1037',478,'Retail Sale Id 1465874',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 12:22:32','',''),(2618392,'1','201','1037',478,'Retail Sale Id 1465875',650.00,0.00,0.00,1.00,38.00,'2022-04-15 12:23:38','',''),(2618393,'1','201','1037',478,'Retail Sale Id 1465876',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 12:30:18','',''),(2618394,'1','201','1037',478,'Retail Sale Id 1465877',2600.00,0.00,0.00,4.00,152.00,'2022-04-15 12:42:56','',''),(2618395,'1','201','1037',478,'Retail Sale Id 1465878',1001.00,0.00,0.00,1.54,58.52,'2022-04-15 12:48:44','',''),(2618396,'1','201','1037',478,'Retail Sale Id 1465879',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 12:57:46','',''),(2618397,'1','201','1037',478,'Retail Sale Id 1465880',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 13:44:16','',''),(2618398,'1','201','1037',478,'Retail Sale Id 1465881',2002.00,0.00,0.00,3.08,117.04,'2022-04-15 13:46:29','',''),(2618399,'1','201','1037',478,'Retail Sale Id 1465882',1501.50,0.00,0.00,2.31,87.78,'2022-04-15 13:54:04','',''),(2618400,'1','201','1037',478,'Retail Sale Id 1465883',21080.00,0.00,0.00,34.00,272.00,'2022-04-15 13:55:15','',''),(2618401,'1','201','1037',478,'Retail Sale Id 1465884',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 13:56:55','',''),(2618402,'1','201','1037',478,'Retail Sale Id 1465885',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 14:04:29','',''),(2618403,'1','201','1037',478,'Retail Sale Id 1465886',650.00,0.00,0.00,1.00,38.00,'2022-04-15 14:06:18','',''),(2618404,'1','201','1037',478,'Retail Sale Id 1465887',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 14:10:44','',''),(2618405,'1','201','1037',478,'Retail Sale Id 1465888',4550.00,0.00,0.00,7.00,266.00,'2022-04-15 14:11:45','',''),(2618406,'1','201','1037',478,'Retail Sale Id 1465889',2002.00,0.00,0.00,3.08,117.04,'2022-04-15 14:26:06','',''),(2618407,'1','201','1037',478,'Retail Sale Id 1465890',3003.00,0.00,0.00,4.62,175.56,'2022-04-15 14:28:44','',''),(2618408,'1','201','1037',478,'Retail Sale Id 1465891',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 14:40:52','',''),(2618409,'1','201','1037',478,'Retail Sale Id 1465892',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 14:46:08','',''),(2618410,'1','201','1037',478,'Retail Sale Id 1465893',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 14:48:39','',''),(2618411,'1','201','1037',478,'Retail Sale Id 1465894',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 14:49:22','',''),(2618412,'1','201','1037',478,'Retail Sale Id 1465895',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 14:50:17','',''),(2618413,'1','201','1037',478,'Retail Sale Id 1465896',2600.00,0.00,0.00,4.00,152.00,'2022-04-15 14:56:08','',''),(2618414,'1','201','1037',478,'Retail Sale Id 1465897',6500.00,0.00,0.00,10.00,380.00,'2022-04-15 14:56:56','',''),(2618415,'1','201','1037',478,'Retail Sale Id 1465898',1501.50,0.00,0.00,2.31,87.78,'2022-04-15 14:58:04','',''),(2618416,'1','201','1037',478,'Retail Sale Id 1465898',1501.50,0.00,0.00,2.31,87.78,'2022-04-15 14:58:04','',''),(2618417,'1','201','1037',478,'Retail Sale Id 1465899',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 15:04:17','',''),(2618418,'1','201','1037',478,'Retail Sale Id 1465900',3003.00,0.00,0.00,4.62,175.56,'2022-04-15 15:06:56','',''),(2618419,'1','201','1037',478,'Retail Sale Id 1465901',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 15:11:18','',''),(2618420,'1','201','1037',478,'Retail Sale Id 1465902',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 15:12:49','',''),(2618421,'1','201','1037',478,'Retail Sale Id 1465903',650.00,0.00,0.00,1.00,38.00,'2022-04-15 15:26:35','',''),(2618422,'1','201','1037',478,'Retail Sale Id 1465904',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 15:28:26','',''),(2618423,'1','201','1037',478,'Retail Sale Id 1465905',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 15:41:53','',''),(2618424,'1','201','1037',478,'Retail Sale Id 1465906',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 15:48:27','',''),(2618425,'1','201','1037',478,'Retail Sale Id 1465907',1001.00,0.00,0.00,1.54,58.52,'2022-04-15 15:49:14','',''),(2618426,'1','201','1037',478,'Retail Sale Id 1465908',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 16:15:25','',''),(2618427,'1','201','1037',478,'Retail Sale Id 1465909',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 16:23:13','',''),(2618428,'1','201','1037',478,'Retail Sale Id 1465910',1625.00,0.00,0.00,2.50,95.00,'2022-04-15 16:32:36','',''),(2618429,'1','201','1037',478,'Retail Sale Id 1465911',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 16:34:18','',''),(2618430,'1','201','1037',478,'Retail Sale Id 1465912',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 16:36:02','',''),(2618431,'1','201','1037',478,'Retail Sale Id 1465913',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 16:40:50','',''),(2618432,'1','201','1037',478,'Retail Sale Id 1465914',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 16:43:47','',''),(2618433,'1','201','1037',478,'Retail Sale Id 1465915',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 16:44:42','',''),(2618434,'1','201','1037',478,'Retail Sale Id 1465916',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 16:45:28','',''),(2618435,'1','201','1037',478,'Retail Sale Id 1465917',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 16:48:27','',''),(2618436,'1','201','1037',478,'Retail Sale Id 1465918',4550.00,0.00,0.00,7.00,266.00,'2022-04-15 16:50:37','',''),(2618437,'1','201','1037',478,'Retail Sale Id 1465919',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 16:55:08','',''),(2618438,'1','201','1037',478,'Retail Sale Id 1465919',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 16:55:08','',''),(2618439,'1','201','1037',478,'Retail Sale Id 1465920',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 16:56:36','',''),(2618440,'1','201','1037',478,'Retail Sale Id 1465920',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 16:56:36','',''),(2618441,'1','201','1037',478,'Retail Sale Id 1465921',3250.00,0.00,0.00,5.00,190.00,'2022-04-15 17:01:58','',''),(2618442,'1','201','1037',478,'Return of Retail Sale Id 1465917',0.00,8125.00,12.50,0.00,-475.00,'2022-04-15 17:03:47','',''),(2618443,'1','201','1037',478,'Retail Sale Id 1465922',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 17:04:32','',''),(2618444,'1','201','1037',478,'Retail Sale Id 1465923',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 17:06:03','',''),(2618445,'1','201','1037',478,'Retail Sale Id 1465924',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 17:24:11','',''),(2618446,'1','201','1037',478,'Retail Sale Id 1465925',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 17:31:45','',''),(2618447,'1','201','1037',478,'Retail Sale Id 1465926',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 17:32:44','',''),(2618448,'1','201','1037',478,'Retail Sale Id 1465927',7800.00,0.00,0.00,12.00,456.00,'2022-04-15 17:40:48','',''),(2618449,'1','201','1037',478,'Retail Sale Id 1465928',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 17:43:43','',''),(2618450,'1','201','1037',478,'Retail Sale Id 1465929',3250.00,0.00,0.00,5.00,190.00,'2022-04-15 17:45:22','',''),(2618451,'1','201','1037',478,'Retail Sale Id 1465930',1001.00,0.00,0.00,1.54,58.52,'2022-04-15 17:46:13','',''),(2618452,'1','201','1037',478,'Retail Sale Id 1465931',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 18:08:58','',''),(2618453,'1','201','1037',478,'Return of Retail Sale Id 1465883',0.00,21080.00,34.00,0.00,-272.00,'2022-04-15 18:35:12','',''),(2618454,'1','201','1037',478,'Retail Sale Id 1465932',10905.80,0.00,0.00,17.59,140.72,'2022-04-15 18:36:28','',''),(2618455,'1','201','1037',478,'Return of Retail Sale Id 1465932',0.00,10905.80,17.59,0.00,-140.72,'2022-04-15 18:37:55','',''),(2618456,'1','201','1037',478,'Retail Sale Id 1465933',20788.60,0.00,0.00,33.53,268.24,'2022-04-15 18:39:16','',''),(2618457,'1','201','1037',478,'Retail Sale Id 1465934',598.00,0.00,0.00,0.92,34.96,'2022-04-15 18:41:03','',''),(2618458,'1','201','1037',478,'Retail Sale Id 1465935',4550.00,0.00,0.00,7.00,266.00,'2022-04-16 08:41:19','',''),(2618459,'1','201','1037',478,'Retail Sale Id 1465936',8125.00,0.00,0.00,12.50,475.00,'2022-04-16 08:56:30','',''),(2618460,'1','201','1037',478,'Retail Sale Id 1465937',3003.00,0.00,0.00,4.62,175.56,'2022-04-16 09:15:43','',''),(2618461,'1','201','1037',478,'Retail Sale Id 1465938',3250.00,0.00,0.00,5.00,190.00,'2022-04-16 09:31:02','',''),(2618462,'1','201','1037',478,'Retail Sale Id 1465939',1300.00,0.00,0.00,2.00,76.00,'2022-04-16 10:00:00','',''),(2618463,'1','201','1037',478,'Retail Sale Id 1465940',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 10:02:44','',''),(2618464,'1','201','1037',478,'Retail Sale Id 1465941',2600.00,0.00,0.00,4.00,152.00,'2022-04-16 10:11:30','',''),(2618465,'1','201','1037',478,'Retail Sale Id 1465942',650.00,0.00,0.00,1.00,38.00,'2022-04-16 10:24:53','',''),(2618466,'1','201','1037',478,'Retail Sale Id 1465943',3250.00,0.00,0.00,5.00,190.00,'2022-04-16 10:40:12','',''),(2618467,'1','201','1037',478,'Retail Sale Id 1465944',2600.00,0.00,0.00,4.00,152.00,'2022-04-16 10:44:24','',''),(2618468,'1','201','1037',478,'Retail Sale Id 1465945',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 11:02:42','',''),(2618469,'1','201','1037',478,'Retail Sale Id 1465945',8125.00,0.00,0.00,12.50,475.00,'2022-04-16 11:02:42','',''),(2618470,'1','201','1037',478,'Retail Sale Id 1465946',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 11:03:32','',''),(2618471,'1','201','1037',478,'Retail Sale Id 1465947',8125.00,0.00,0.00,12.50,475.00,'2022-04-16 11:08:12','',''),(2618472,'1','201','1037',478,'Retail Sale Id 1465948',1300.00,0.00,0.00,2.00,76.00,'2022-04-16 11:18:26','',''),(2618473,'1','201','1037',478,'Retail Sale Id 1465949',2502.50,0.00,0.00,3.85,146.30,'2022-04-16 11:26:27','',''),(2618474,'1','201','1037',478,'Retail Sale Id 1465950',2925.00,0.00,0.00,4.50,171.00,'2022-04-16 11:27:48','',''),(2618475,'1','201','1037',478,'Retail Sale Id 1465951',5200.00,0.00,0.00,8.00,304.00,'2022-04-16 11:39:02','',''),(2618476,'1','201','1037',478,'Retail Sale Id 1465952',3250.00,0.00,0.00,5.00,190.00,'2022-04-16 11:43:38','',''),(2618477,'1','201','1037',478,'Retail Sale Id 1465953',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 11:57:12','',''),(2618478,'1','201','1037',478,'Retail Sale Id 1465954',3250.00,0.00,0.00,5.00,190.00,'2022-04-16 12:00:26','',''),(2618479,'1','201','1037',478,'Retail Sale Id 1465954',6500.00,0.00,0.00,10.00,380.00,'2022-04-16 12:00:26','',''),(2618480,'1','201','1037',478,'Retail Sale Id 1465955',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 12:14:39','',''),(2618481,'1','201','1037',478,'Retail Sale Id 1465956',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 12:23:55','',''),(2618482,'1','201','1037',478,'Retail Sale Id 1465957',1001.00,0.00,0.00,1.54,58.52,'2022-04-16 12:25:05','',''),(2618483,'1','201','1037',478,'Retail Sale Id 1465958',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 12:30:47','',''),(2618484,'1','201','1037',478,'Retail Sale Id 1465959',3250.00,0.00,0.00,5.00,190.00,'2022-04-16 12:33:06','',''),(2618485,'1','201','1037',478,'Retail Sale Id 1465960',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 12:41:13','',''),(2618486,'1','201','1037',478,'Retail Sale Id 1465961',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 12:56:38','',''),(2618487,'1','201','1037',478,'Retail Sale Id 1465962',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 12:58:41','',''),(2618488,'1','201','1037',478,'Retail Sale Id 1465963',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 13:02:08','',''),(2618489,'1','201','1037',478,'Retail Sale Id 1465964',2600.00,0.00,0.00,4.00,152.00,'2022-04-16 13:13:39','',''),(2618490,'1','201','1037',478,'Retail Sale Id 1465965',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 13:14:53','',''),(2618491,'1','201','1037',478,'Retail Sale Id 1465966',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 13:28:17','',''),(2618492,'1','201','1037',478,'Retail Sale Id 1465968',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 13:45:27','',''),(2618493,'1','201','1037',478,'Retail Sale Id 1465969',3250.00,0.00,0.00,5.00,190.00,'2022-04-16 13:50:06','',''),(2618494,'1','201','1037',478,'Retail Sale Id 1465970',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 13:55:49','',''),(2618495,'1','201','1037',478,'Retail Sale Id 1465971',650.00,0.00,0.00,1.00,38.00,'2022-04-16 13:59:33','',''),(2618496,'1','201','1037',478,'Retail Sale Id 1465972',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 14:01:17','',''),(2618497,'1','201','1037',478,'Retail Sale Id 1465973',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 14:20:17','',''),(2618498,'1','201','1037',478,'Retail Sale Id 1465974',1501.50,0.00,0.00,2.31,87.78,'2022-04-16 14:32:17','',''),(2618499,'1','201','1037',478,'Retail Sale Id 1465975',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 14:37:53','',''),(2618500,'1','201','1037',478,'Retail Sale Id 1465976',2275.00,0.00,0.00,3.50,133.00,'2022-04-16 14:42:30','',''),(2618501,'1','201','1037',478,'Retail Sale Id 1465977',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 15:02:12','',''),(2618502,'1','201','1037',478,'Retail Sale Id 1465978',5999.50,0.00,0.00,9.23,350.74,'2022-04-16 15:03:45','',''),(2618503,'1','201','1037',478,'Retail Sale Id 1465979',325.00,0.00,0.00,0.50,19.00,'2022-04-16 15:05:49','',''),(2618504,'1','201','1037',478,'Retail Sale Id 1465980',650.00,0.00,0.00,1.00,38.00,'2022-04-16 15:07:47','',''),(2618505,'1','201','1037',478,'Retail Sale Id 1465982',8125.00,0.00,0.00,12.50,475.00,'2022-04-16 15:10:02','',''),(2618506,'1','201','1037',478,'Retail Sale Id 1465983',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 15:13:10','',''),(2618507,'1','201','1037',478,'Retail Sale Id 1465984',3250.00,0.00,0.00,5.00,190.00,'2022-04-16 15:17:15','',''),(2618508,'1','201','1037',478,'Retail Sale Id 1465985',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 15:37:11','',''),(2618509,'1','201','1037',478,'Retail Sale Id 1465986',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 15:41:58','',''),(2618510,'1','201','1037',478,'Retail Sale Id 1465987',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 15:47:36','',''),(2618511,'1','201','1037',478,'Retail Sale Id 1465988',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 16:09:53','',''),(2618512,'1','201','1037',478,'Retail Sale Id 1465989',2600.00,0.00,0.00,4.00,152.00,'2022-04-16 16:23:42','',''),(2618513,'1','201','1037',478,'Retail Sale Id 1465991',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 16:26:45','',''),(2618514,'1','201','1037',478,'Retail Sale Id 1465992',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 16:27:53','',''),(2618515,'1','201','1037',478,'Retail Sale Id 1465993',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 16:30:13','',''),(2618516,'1','201','1037',478,'Retail Sale Id 1465994',1800.50,0.00,0.00,2.77,105.26,'2022-04-16 16:32:23','',''),(2618517,'1','201','1037',478,'Retail Sale Id 1465995',3250.00,0.00,0.00,5.00,190.00,'2022-04-16 16:33:23','',''),(2618518,'1','201','1037',478,'Retail Sale Id 1465996',1833.00,0.00,0.00,2.82,107.16,'2022-04-16 16:34:14','',''),(2618519,'1','201','1037',478,'Retail Sale Id 1465997',3250.00,0.00,0.00,5.00,190.00,'2022-04-16 16:34:59','',''),(2618520,'1','201','1037',478,'Return of Retail Sale Id 1465992',0.00,1950.00,3.00,0.00,-114.00,'2022-04-16 16:36:01','',''),(2618521,'1','201','1037',478,'Retail Sale Id 1465998',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 16:38:21','',''),(2618522,'1','201','1037',478,'Retail Sale Id 1465999',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 16:49:52','',''),(2618523,'1','201','1037',478,'Retail Sale Id 1466000',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 16:54:13','',''),(2618524,'1','201','1037',478,'Retail Sale Id 1466000',8125.00,0.00,0.00,12.50,475.00,'2022-04-16 16:54:13','',''),(2618525,'1','201','1037',478,'Retail Sale Id 1466001',2600.00,0.00,0.00,4.00,152.00,'2022-04-16 16:55:46','',''),(2618526,'1','201','1037',478,'Retail Sale Id 1466002',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 16:58:42','',''),(2618527,'1','201','1037',478,'Retail Sale Id 1466003',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 16:59:38','',''),(2618528,'1','201','1037',478,'Retail Sale Id 1466004',650.00,0.00,0.00,1.00,38.00,'2022-04-16 17:04:58','',''),(2618529,'1','201','1037',478,'Retail Sale Id 1466006',2275.00,0.00,0.00,3.50,133.00,'2022-04-16 17:13:08','',''),(2618530,'1','201','1037',478,'Retail Sale Id 1466007',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 17:23:14','',''),(2618531,'1','201','1037',478,'Retail Sale Id 1466007',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 17:23:14','',''),(2618532,'1','201','1037',478,'Retail Sale Id 1466007',8125.00,0.00,0.00,12.50,475.00,'2022-04-16 17:23:14','',''),(2618533,'1','201','1037',478,'Retail Sale Id 1466008',8125.00,0.00,0.00,12.50,475.00,'2022-04-16 17:27:22','',''),(2618534,'1','201','1037',478,'Retail Sale Id 1466009',1001.00,0.00,0.00,1.54,58.52,'2022-04-16 17:36:52','',''),(2618535,'1','201','1037',478,'Retail Sale Id 1466010',6175.00,0.00,0.00,9.50,361.00,'2022-04-16 17:48:52','',''),(2618536,'1','201','1037',478,'Retail Sale Id 1466011',8125.00,0.00,0.00,12.50,475.00,'2022-04-16 18:00:11','',''),(2618537,'1','201','1037',478,'Retail Sale Id 1466012',8125.00,0.00,0.00,12.50,475.00,'2022-04-16 18:01:31','',''),(2618538,'1','201','1037',478,'Retail Sale Id 1466013',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 18:07:07','',''),(2618539,'1','201','1037',478,'Retail Sale Id 1466014',1001.00,0.00,0.00,1.54,58.52,'2022-04-16 18:08:03','',''),(2618540,'1','201','1037',478,'Retail Sale Id 1466015',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 18:08:36','',''),(2618541,'1','201','1037',478,'Retail Sale Id 1466016',1202.50,0.00,0.00,1.85,70.30,'2022-04-16 18:15:34','',''),(2618542,'1','201','1037',478,'Retail Sale Id 1466017',1300.00,0.00,0.00,2.00,76.00,'2022-04-16 18:23:42','',''),(2618543,'1','201','1037',478,'Retail Sale Id 1466018',2600.00,0.00,0.00,4.00,152.00,'2022-04-17 08:47:49','',''),(2618544,'1','201','1037',478,'Retail Sale Id 1466019',6200.00,0.00,0.00,10.00,80.00,'2022-04-17 08:48:57','',''),(2618545,'1','201','1037',478,'Retail Sale Id 1466020',31000.00,0.00,0.00,50.00,400.00,'2022-04-17 08:50:17','',''),(2618546,'1','201','1037',478,'Retail Sale Id 1466021',8125.00,0.00,0.00,12.50,475.00,'2022-04-17 08:52:01','',''),(2618547,'1','201','1037',478,'Retail Sale Id 1466022',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 08:53:09','',''),(2618548,'1','201','1037',478,'Retail Sale Id 1466023',650.00,0.00,0.00,1.00,38.00,'2022-04-17 08:54:01','',''),(2618549,'1','201','1037',478,'Retail Sale Id 1466024',7800.00,0.00,0.00,12.00,456.00,'2022-04-17 08:54:56','',''),(2618550,'1','201','1037',478,'Retail Sale Id 1466025',975.00,0.00,0.00,1.50,57.00,'2022-04-17 08:59:04','',''),(2618551,'1','201','1037',478,'Retail Sale Id 1466026',1898.00,0.00,0.00,2.92,110.96,'2022-04-17 09:35:09','',''),(2618552,'1','201','1037',478,'Retail Sale Id 1466027',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 09:48:33','',''),(2618553,'1','201','1037',478,'Retail Sale Id 1466028',1001.00,0.00,0.00,1.54,58.52,'2022-04-17 09:53:40','',''),(2618554,'1','201','1037',478,'Retail Sale Id 1466029',1501.50,0.00,0.00,2.31,87.78,'2022-04-17 09:55:24','',''),(2618555,'1','201','1037',478,'Retail Sale Id 1466031',2600.00,0.00,0.00,4.00,152.00,'2022-04-17 10:00:16','',''),(2618556,'1','201','1037',478,'Retail Sale Id 1466032',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 10:18:20','',''),(2618557,'1','201','1037',478,'Retail Sale Id 1466033',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 10:23:20','',''),(2618558,'1','201','1037',478,'Retail Sale Id 1466034',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 10:24:06','',''),(2618559,'1','201','1037',478,'Retail Sale Id 1466035',3003.00,0.00,0.00,4.62,175.56,'2022-04-17 10:27:37','',''),(2618560,'1','201','1037',478,'Retail Sale Id 1466036',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 10:34:27','',''),(2618561,'1','201','1037',478,'Retail Sale Id 1466037',858.00,0.00,0.00,1.32,50.16,'2022-04-17 10:38:11','',''),(2618562,'1','201','1037',478,'Retail Sale Id 1466038',1001.00,0.00,0.00,1.54,58.52,'2022-04-17 10:40:57','',''),(2618563,'1','201','1037',478,'Retail Sale Id 1466039',1001.00,0.00,0.00,1.54,58.52,'2022-04-17 10:41:43','',''),(2618564,'1','201','1037',478,'Retail Sale Id 1466040',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 11:13:02','',''),(2618565,'1','201','1037',478,'Retail Sale Id 1466041',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 11:14:45','',''),(2618566,'1','201','1037',478,'Retail Sale Id 1466042',2600.00,0.00,0.00,4.00,152.00,'2022-04-17 12:09:21','',''),(2618567,'1','201','1037',478,'Retail Sale Id 1466043',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 12:10:45','',''),(2618568,'1','201','1037',478,'Retail Sale Id 1466044',650.00,0.00,0.00,1.00,38.00,'2022-04-17 12:15:23','',''),(2618569,'1','201','1037',478,'Retail Sale Id 1466045',650.00,0.00,0.00,1.00,38.00,'2022-04-17 12:23:15','',''),(2618570,'1','201','1037',478,'Retail Sale Id 1466046',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 12:35:57','',''),(2618571,'1','201','1037',478,'Retail Sale Id 1466047',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 12:39:13','',''),(2618572,'1','201','1037',478,'Retail Sale Id 1466048',3003.00,0.00,0.00,4.62,175.56,'2022-04-17 12:56:46','',''),(2618573,'1','201','1037',478,'Retail Sale Id 1466049',650.00,0.00,0.00,1.00,38.00,'2022-04-17 12:58:29','',''),(2618574,'1','201','1037',478,'Retail Sale Id 1466050',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 13:04:57','',''),(2618575,'1','201','1037',478,'Retail Sale Id 1466051',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 13:19:28','',''),(2618576,'1','201','1037',478,'Retail Sale Id 1466052',650.00,0.00,0.00,1.00,38.00,'2022-04-17 13:20:12','',''),(2618577,'1','201','1037',478,'Retail Sale Id 1466053',650.00,0.00,0.00,1.00,38.00,'2022-04-17 13:21:27','',''),(2618578,'1','201','1037',478,'Retail Sale Id 1466054',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 13:31:35','',''),(2618579,'1','201','1037',478,'Retail Sale Id 1466055',2600.00,0.00,0.00,4.00,152.00,'2022-04-17 13:55:26','',''),(2618580,'1','201','1037',478,'Retail Sale Id 1466056',7440.00,0.00,0.00,12.00,96.00,'2022-04-17 13:58:19','',''),(2618581,'1','201','1037',478,'Retail Sale Id 1466057',7440.00,0.00,0.00,12.00,96.00,'2022-04-17 13:59:35','',''),(2618582,'1','201','1037',478,'Retail Sale Id 1466058',9300.00,0.00,0.00,15.00,120.00,'2022-04-17 14:08:53','',''),(2618583,'1','201','1037',478,'Retail Sale Id 1466059',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 14:15:31','',''),(2618584,'1','201','1037',478,'Retail Sale Id 1466060',7800.00,0.00,0.00,12.00,456.00,'2022-04-17 14:53:37','',''),(2618585,'1','201','1037',478,'Retail Sale Id 1466061',4550.00,0.00,0.00,7.00,266.00,'2022-04-17 14:54:19','',''),(2618586,'1','201','1037',478,'Retail Sale Id 1466062',6200.00,0.00,0.00,10.00,80.00,'2022-04-17 15:24:05','',''),(2618587,'1','201','1037',478,'Retail Sale Id 1466063',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 15:25:02','',''),(2618588,'1','201','1037',478,'Retail Sale Id 1466064',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 15:25:51','',''),(2618589,'1','201','1037',478,'Retail Sale Id 1466065',2600.00,0.00,0.00,4.00,152.00,'2022-04-17 15:26:36','',''),(2618590,'1','201','1037',478,'Retail Sale Id 1466066',650.00,0.00,0.00,1.00,38.00,'2022-04-17 15:27:18','',''),(2618591,'1','201','1037',478,'Retail Sale Id 1466067',1098.50,0.00,0.00,1.69,64.22,'2022-04-17 15:28:00','',''),(2618592,'1','201','1037',478,'Retail Sale Id 1466068',3003.00,0.00,0.00,4.62,175.56,'2022-04-17 15:28:49','',''),(2618593,'1','201','1037',478,'Retail Sale Id 1466069',4550.00,0.00,0.00,7.00,266.00,'2022-04-17 15:54:30','',''),(2618594,'1','201','1037',478,'Retail Sale Id 1466070',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 16:17:55','',''),(2618595,'1','201','1037',478,'Retail Sale Id 1466071',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 16:21:00','',''),(2618596,'1','201','1037',478,'Retail Sale Id 1466072',1300.00,0.00,0.00,2.00,76.00,'2022-04-17 16:34:09','',''),(2618597,'1','201','1037',478,'Retail Sale Id 1466073',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 16:35:40','',''),(2618598,'1','201','1037',478,'Retail Sale Id 1466074',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 16:37:52','',''),(2618599,'1','201','1037',478,'Retail Sale Id 1466075',6500.00,0.00,0.00,10.00,380.00,'2022-04-17 16:44:41','',''),(2618600,'1','201','1037',478,'Retail Sale Id 1466076',3250.00,0.00,0.00,5.00,190.00,'2022-04-17 16:45:52','',''),(2618601,'1','201','1037',478,'Retail Sale Id 1466077',1300.00,0.00,0.00,2.00,76.00,'2022-04-17 16:47:28','',''),(2618602,'1','201','1037',478,'Retail Sale Id 1466078',3250.00,0.00,0.00,5.00,190.00,'2022-04-17 16:50:29','',''),(2618603,'1','201','1037',478,'Retail Sale Id 1466079',4550.00,0.00,0.00,7.00,266.00,'2022-04-17 16:56:15','',''),(2618604,'1','201','1037',478,'Retail Sale Id 1466080',2600.00,0.00,0.00,4.00,152.00,'2022-04-17 16:57:36','',''),(2618605,'1','201','1037',478,'Retail Sale Id 1466081',3003.00,0.00,0.00,4.62,175.56,'2022-04-17 17:02:14','',''),(2618606,'1','201','1037',478,'Retail Sale Id 1466082',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 17:03:04','',''),(2618607,'1','201','1037',478,'Retail Sale Id 1466083',1001.00,0.00,0.00,1.54,58.52,'2022-04-17 17:12:50','',''),(2618608,'1','201','1037',478,'Retail Sale Id 1466084',9300.00,0.00,0.00,15.00,120.00,'2022-04-17 17:14:29','',''),(2618609,'1','201','1037',478,'Retail Sale Id 1466085',3698.50,0.00,0.00,5.69,216.22,'2022-04-17 17:15:25','',''),(2618610,'1','201','1037',478,'Retail Sale Id 1466086',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 17:21:20','',''),(2618611,'1','201','1037',478,'Retail Sale Id 1466087',2600.00,0.00,0.00,4.00,152.00,'2022-04-17 17:27:40','',''),(2618612,'1','201','1037',478,'Retail Sale Id 1466088',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 17:32:02','',''),(2618613,'1','201','1037',478,'Retail Sale Id 1466089',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 17:33:35','',''),(2618614,'1','201','1037',478,'Retail Sale Id 1466090',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 17:37:02','',''),(2618615,'1','201','1037',478,'Retail Sale Id 1466091',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 17:48:38','',''),(2618616,'1','201','1037',478,'Retail Sale Id 1466092',1300.00,0.00,0.00,2.00,76.00,'2022-04-17 17:54:48','',''),(2618617,'1','201','1037',478,'Retail Sale Id 1466093',1300.00,0.00,0.00,2.00,76.00,'2022-04-17 17:55:24','',''),(2618618,'1','201','1037',478,'Retail Sale Id 1466094',7800.00,0.00,0.00,12.00,456.00,'2022-04-17 18:24:29','',''),(2618619,'1','201','1037',478,'Retail Sale Id 1466095',31000.00,0.00,0.00,50.00,400.00,'2022-04-17 18:27:58','',''),(2618620,'1','201','1037',478,'Retail Sale Id 1466096',14880.00,0.00,0.00,24.00,192.00,'2022-04-18 07:41:36','',''),(2618621,'1','201','1037',478,'Retail Sale Id 1466097',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 09:11:20','',''),(2618622,'1','201','1037',478,'Retail Sale Id 1466098',3250.00,0.00,0.00,5.00,190.00,'2022-04-18 09:12:26','',''),(2618623,'1','201','1037',478,'Retail Sale Id 1466099',2600.00,0.00,0.00,4.00,152.00,'2022-04-18 09:13:50','',''),(2618624,'1','201','1037',478,'Retail Sale Id 1466100',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 09:50:55','',''),(2618625,'1','201','1037',478,'Retail Sale Id 1466101',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 10:03:53','',''),(2618626,'1','201','1037',478,'Retail Sale Id 1466102',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 10:06:01','',''),(2618627,'1','201','1037',478,'Retail Sale Id 1466103',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 10:31:21','',''),(2618628,'1','201','1037',478,'Retail Sale Id 1466104',650.00,0.00,0.00,1.00,38.00,'2022-04-18 10:41:24','',''),(2618629,'1','201','1037',478,'Retail Sale Id 1466105',1001.00,0.00,0.00,1.54,58.52,'2022-04-18 10:51:09','',''),(2618630,'1','201','1037',478,'Retail Sale Id 1466106',4550.00,0.00,0.00,7.00,266.00,'2022-04-18 10:54:31','',''),(2618631,'1','201','1037',478,'Retail Sale Id 1466107',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 11:18:28','',''),(2618632,'1','201','1037',478,'Retail Sale Id 1466108',3720.00,0.00,0.00,6.00,48.00,'2022-04-18 12:01:44','',''),(2618633,'1','201','1037',478,'Retail Sale Id 1466109',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 12:02:38','',''),(2618634,'1','201','1037',478,'Retail Sale Id 1466109',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 12:02:38','',''),(2618635,'1','201','1037',478,'Retail Sale Id 1466110',7000.50,0.00,0.00,10.77,409.26,'2022-04-18 12:03:24','',''),(2618636,'1','201','1037',478,'Retail Sale Id 1466111',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 12:13:41','',''),(2618637,'1','201','1037',478,'Retail Sale Id 1466112',3575.00,0.00,0.00,5.50,209.00,'2022-04-18 13:34:02','',''),(2618638,'1','201','1037',478,'Retail Sale Id 1466112',8125.00,0.00,0.00,12.50,475.00,'2022-04-18 13:34:02','',''),(2618639,'1','201','1037',478,'Retail Sale Id 1466113',8125.00,0.00,0.00,12.50,475.00,'2022-04-18 13:41:20','',''),(2618640,'1','201','1037',478,'Retail Sale Id 1466114',1625.00,0.00,0.00,2.50,95.00,'2022-04-18 13:42:25','',''),(2618641,'1','201','1037',478,'Retail Sale Id 1466115',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 13:47:17','',''),(2618642,'1','201','1037',478,'Retail Sale Id 1466116',3003.00,0.00,0.00,4.62,175.56,'2022-04-18 13:48:19','',''),(2618643,'1','201','1037',478,'Retail Sale Id 1466117',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 13:48:57','',''),(2618644,'1','201','1037',478,'Retail Sale Id 1466118',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 13:49:51','',''),(2618645,'1','201','1037',478,'Retail Sale Id 1466119',9750.00,0.00,0.00,15.00,570.00,'2022-04-18 14:10:17','',''),(2618646,'1','201','1037',478,'Retail Sale Id 1466120',16575.00,0.00,0.00,25.50,969.00,'2022-04-18 14:51:47','',''),(2618647,'1','201','1037',478,'Retail Sale Id 1466121',2275.00,0.00,0.00,3.50,133.00,'2022-04-18 14:52:54','',''),(2618648,'1','201','1037',478,'Retail Sale Id 1466122',7800.00,0.00,0.00,12.00,456.00,'2022-04-18 14:53:49','',''),(2618649,'1','201','1037',478,'Retail Sale Id 1466123',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 14:54:20','',''),(2618650,'1','201','1037',478,'Retail Sale Id 1466124',975.00,0.00,0.00,1.50,57.00,'2022-04-18 15:00:47','',''),(2618651,'1','201','1037',478,'Retail Sale Id 1466125',3497.00,0.00,0.00,5.38,204.44,'2022-04-18 15:01:29','',''),(2618652,'1','201','1037',478,'Retail Sale Id 1466126',3250.00,0.00,0.00,5.00,190.00,'2022-04-18 15:09:21','',''),(2618653,'1','201','1037',478,'Retail Sale Id 1466127',2002.00,0.00,0.00,3.08,117.04,'2022-04-18 15:16:23','',''),(2618654,'1','201','1037',478,'Retail Sale Id 1466128',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 15:25:40','',''),(2618655,'1','201','1037',478,'Retail Sale Id 1466129',2002.00,0.00,0.00,3.08,117.04,'2022-04-18 15:34:10','',''),(2618656,'1','201','1037',478,'Retail Sale Id 1466129',2002.00,0.00,0.00,3.08,117.04,'2022-04-18 15:34:10','',''),(2618657,'1','201','1037',478,'Retail Sale Id 1466130',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 15:46:09','',''),(2618658,'1','201','1037',478,'Retail Sale Id 1466131',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 15:48:05','',''),(2618659,'1','201','1037',478,'Retail Sale Id 1466132',8125.00,0.00,0.00,12.50,475.00,'2022-04-18 16:01:54','',''),(2618660,'1','201','1037',478,'Retail Sale Id 1466133',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 16:22:30','',''),(2618661,'1','201','1037',478,'Retail Sale Id 1466134',3250.00,0.00,0.00,5.00,190.00,'2022-04-18 16:28:34','',''),(2618662,'1','201','1037',478,'Retail Sale Id 1466135',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 16:31:51','',''),(2618663,'1','201','1037',478,'Retail Sale Id 1466136',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 16:32:30','',''),(2618664,'1','201','1037',478,'Retail Sale Id 1466137',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 16:35:30','',''),(2618665,'1','201','1037',478,'Retail Sale Id 1466138',3250.00,0.00,0.00,5.00,190.00,'2022-04-18 16:36:16','',''),(2618666,'1','201','1037',478,'Retail Sale Id 1466139',9300.00,0.00,0.00,15.00,120.00,'2022-04-18 16:41:57','',''),(2618667,'1','201','1037',478,'Retail Sale Id 1466140',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 16:49:34','',''),(2618668,'1','201','1037',478,'Retail Sale Id 1466141',3250.00,0.00,0.00,5.00,190.00,'2022-04-18 17:01:40','',''),(2618669,'1','201','1037',478,'Retail Sale Id 1466142',4998.50,0.00,0.00,7.69,292.22,'2022-04-18 17:02:44','',''),(2618670,'1','201','1037',478,'Retail Sale Id 1466143',1001.00,0.00,0.00,1.54,58.52,'2022-04-18 17:07:57','',''),(2618671,'1','201','1037',478,'Retail Sale Id 1466144',650.00,0.00,0.00,1.00,38.00,'2022-04-18 17:09:26','',''),(2618672,'1','201','1037',478,'Retail Sale Id 1466145',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 17:10:17','',''),(2618673,'1','201','1037',478,'Retail Sale Id 1466146',4550.00,0.00,0.00,7.00,266.00,'2022-04-18 17:16:19','',''),(2618674,'1','201','1037',478,'Retail Sale Id 1466147',1001.00,0.00,0.00,1.54,58.52,'2022-04-18 17:17:22','',''),(2618675,'1','201','1037',478,'Retail Sale Id 1466148',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 17:44:32','',''),(2618676,'1','201','1037',478,'Retail Sale Id 1466149',3250.00,0.00,0.00,5.00,190.00,'2022-04-18 17:45:49','',''),(2618677,'1','201','1037',478,'Retail Sale Id 1466150',1001.00,0.00,0.00,1.54,58.52,'2022-04-18 17:53:05','',''),(2618678,'1','201','1037',478,'Retail Sale Id 1466151',8125.00,0.00,0.00,12.50,475.00,'2022-04-18 17:55:15','',''),(2618679,'1','201','1037',478,'Retail Sale Id 1466152',598.00,0.00,0.00,0.92,34.96,'2022-04-18 18:01:21','',''),(2618680,'1','201','1037',478,'Retail Sale Id 1466153',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 18:02:13','',''),(2618681,'1','201','1037',478,'Retail Sale Id 1466154',3250.00,0.00,0.00,5.00,190.00,'2022-04-18 18:03:29','',''),(2618682,'1','201','1037',478,'Retail Sale Id 1466155',650.00,0.00,0.00,1.00,38.00,'2022-04-18 18:13:29','',''),(2618683,'1','201','1037',478,'Retail Sale Id 1466156',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 07:57:13','',''),(2618684,'1','201','1037',478,'Retail Sale Id 1466157',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 08:00:32','',''),(2618685,'1','201','1037',478,'Retail Sale Id 1466158',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 08:19:08','',''),(2618686,'1','201','1037',478,'Retail Sale Id 1466159',62000.00,0.00,0.00,100.00,800.00,'2022-04-19 08:41:22','',''),(2618687,'1','201','1037',478,'Retail Sale Id 1466160',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 08:49:00','',''),(2618688,'1','201','1037',478,'Retail Sale Id 1466161',1300.00,0.00,0.00,2.00,76.00,'2022-04-19 09:17:08','',''),(2618689,'1','201','1037',478,'Retail Sale Id 1466162',1300.00,0.00,0.00,2.00,76.00,'2022-04-19 09:18:00','',''),(2618690,'1','201','1037',478,'Retail Sale Id 1466163',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 09:18:41','',''),(2618691,'1','201','1037',478,'Retail Sale Id 1466164',2600.00,0.00,0.00,4.00,152.00,'2022-04-19 09:19:22','',''),(2618692,'1','201','1037',478,'Retail Sale Id 1466165',8125.00,0.00,0.00,12.50,475.00,'2022-04-19 09:36:34','',''),(2618693,'1','201','1037',478,'Retail Sale Id 1466166',8125.00,0.00,0.00,12.50,475.00,'2022-04-19 10:06:18','',''),(2618694,'1','201','1037',478,'Retail Sale Id 1466167',3250.00,0.00,0.00,5.00,190.00,'2022-04-19 10:11:03','',''),(2618695,'1','201','1037',478,'Retail Sale Id 1466168',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 10:21:14','',''),(2618696,'1','201','1037',478,'Retail Sale Id 1466169',4998.50,0.00,0.00,7.69,292.22,'2022-04-19 11:00:57','',''),(2618697,'1','201','1037',478,'Retail Sale Id 1466170',1001.00,0.00,0.00,1.54,58.52,'2022-04-19 11:13:54','',''),(2618698,'1','201','1037',478,'Retail Sale Id 1466171',3250.00,0.00,0.00,5.00,190.00,'2022-04-19 11:16:23','',''),(2618699,'1','201','1037',478,'Retail Sale Id 1466172',2002.00,0.00,0.00,3.08,117.04,'2022-04-19 12:06:55','',''),(2618700,'1','201','1037',478,'Retail Sale Id 1466173',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 12:14:05','',''),(2618701,'1','201','1037',478,'Retail Sale Id 1466174',4550.00,0.00,0.00,7.00,266.00,'2022-04-19 12:18:43','',''),(2618702,'1','201','1037',478,'Retail Sale Id 1466176',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 12:36:35','',''),(2618703,'1','201','1037',478,'Retail Sale Id 1466177',1300.00,0.00,0.00,2.00,76.00,'2022-04-19 12:58:44','',''),(2618704,'1','201','1037',478,'Retail Sale Id 1466178',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 13:29:11','',''),(2618705,'1','201','1037',478,'Retail Sale Id 1466179',3250.00,0.00,0.00,5.00,190.00,'2022-04-19 13:36:56','',''),(2618706,'1','201','1037',478,'Retail Sale Id 1466180',7800.00,0.00,0.00,12.00,456.00,'2022-04-19 13:41:08','',''),(2618707,'1','201','1037',478,'Retail Sale Id 1466181',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 13:43:08','',''),(2618708,'1','201','1037',478,'Retail Sale Id 1466182',8125.00,0.00,0.00,12.50,475.00,'2022-04-19 13:46:41','',''),(2618709,'1','201','1037',478,'Retail Sale Id 1466183',2002.00,0.00,0.00,3.08,117.04,'2022-04-19 14:00:24','',''),(2618710,'1','201','1037',478,'Retail Sale Id 1466184',6500.00,0.00,0.00,10.00,380.00,'2022-04-19 14:10:14','',''),(2618711,'1','201','1037',478,'Retail Sale Id 1466185',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 14:14:35','',''),(2618712,'1','201','1037',478,'Retail Sale Id 1466186',650.00,0.00,0.00,1.00,38.00,'2022-04-19 14:22:26','',''),(2618713,'1','201','1037',478,'Retail Sale Id 1466187',1501.50,0.00,0.00,2.31,87.78,'2022-04-19 14:45:33','',''),(2618714,'1','201','1037',478,'Retail Sale Id 1466188',2600.00,0.00,0.00,4.00,152.00,'2022-04-19 14:58:32','',''),(2618715,'1','201','1037',478,'Retail Sale Id 1466189',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 15:13:09','',''),(2618716,'1','201','1037',478,'Retail Sale Id 1466190',136.50,0.00,0.00,0.21,7.98,'2022-04-19 15:18:33','',''),(2618717,'1','201','1037',478,'Retail Sale Id 1466191',7800.00,0.00,0.00,12.00,456.00,'2022-04-19 15:23:52','',''),(2618718,'1','201','1037',478,'Retail Sale Id 1466192',975.00,0.00,0.00,1.50,57.00,'2022-04-19 15:27:59','',''),(2618719,'1','201','1037',478,'Retail Sale Id 1466193',4550.00,0.00,0.00,7.00,266.00,'2022-04-19 15:45:48','',''),(2618720,'1','201','1037',478,'Retail Sale Id 1466194',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 16:18:49','',''),(2618721,'1','201','1037',478,'Retail Sale Id 1466196',1001.00,0.00,0.00,1.54,58.52,'2022-04-19 16:23:33','',''),(2618722,'1','201','1037',478,'Retail Sale Id 1466197',3250.00,0.00,0.00,5.00,190.00,'2022-04-19 16:34:58','',''),(2618723,'1','201','1037',478,'Retail Sale Id 1466197',8125.00,0.00,0.00,12.50,475.00,'2022-04-19 16:34:58','',''),(2618724,'1','201','1037',478,'Retail Sale Id 1466198',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 16:40:14','',''),(2618725,'1','201','1037',478,'Retail Sale Id 1466199',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 16:42:54','',''),(2618726,'1','201','1037',478,'Retail Sale Id 1466200',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 16:44:08','',''),(2618727,'1','201','1037',478,'Retail Sale Id 1466201',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 16:45:48','',''),(2618728,'1','201','1037',478,'Retail Sale Id 1466202',1001.00,0.00,0.00,1.54,58.52,'2022-04-19 16:52:22','',''),(2618729,'1','201','1037',478,'Retail Sale Id 1466202',1001.00,0.00,0.00,1.54,58.52,'2022-04-19 16:52:22','',''),(2618730,'1','201','1037',478,'Retail Sale Id 1466203',799.50,0.00,0.00,1.23,46.74,'2022-04-19 16:53:24','',''),(2618731,'1','201','1037',478,'Retail Sale Id 1466204',1300.00,0.00,0.00,2.00,76.00,'2022-04-19 16:54:14','',''),(2618732,'1','201','1037',478,'Retail Sale Id 1466205',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 16:55:08','',''),(2618733,'1','201','1037',478,'Retail Sale Id 1466206',2600.00,0.00,0.00,4.00,152.00,'2022-04-19 16:55:43','',''),(2618734,'1','201','1037',478,'Retail Sale Id 1466207',3003.00,0.00,0.00,4.62,175.56,'2022-04-19 17:03:51','',''),(2618735,'1','201','1037',478,'Retail Sale Id 1466208',1300.00,0.00,0.00,2.00,76.00,'2022-04-19 17:05:04','',''),(2618736,'1','201','1037',478,'Retail Sale Id 1466209',2600.00,0.00,0.00,4.00,152.00,'2022-04-19 17:06:01','',''),(2618737,'1','201','1037',478,'Retail Sale Id 1466210',2600.00,0.00,0.00,4.00,152.00,'2022-04-19 17:07:05','',''),(2618738,'1','201','1037',478,'Retail Sale Id 1466211',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 17:09:13','',''),(2618739,'1','201','1037',478,'Retail Sale Id 1466212',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 17:10:09','',''),(2618740,'1','201','1037',478,'Retail Sale Id 1466213',1001.00,0.00,0.00,1.54,58.52,'2022-04-19 17:15:51','',''),(2618741,'1','201','1037',478,'Retail Sale Id 1466214',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 17:20:26','',''),(2618742,'1','201','1037',478,'Retail Sale Id 1466215',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 17:35:09','',''),(2618743,'1','201','1037',478,'Retail Sale Id 1466215',3250.00,0.00,0.00,5.00,190.00,'2022-04-19 17:35:09','',''),(2618744,'1','201','1037',478,'Retail Sale Id 1466216',8125.00,0.00,0.00,12.50,475.00,'2022-04-19 17:38:54','',''),(2618745,'1','201','1037',478,'Retail Sale Id 1466217',3575.00,0.00,0.00,5.50,209.00,'2022-04-19 17:41:11','',''),(2618746,'1','201','1037',478,'Retail Sale Id 1466218',1300.00,0.00,0.00,2.00,76.00,'2022-04-19 17:44:46','',''),(2618747,'1','201','1037',478,'Retail Sale Id 1466219',1001.00,0.00,0.00,1.54,58.52,'2022-04-19 17:50:27','',''),(2618748,'1','201','1037',478,'Retail Sale Id 1466221',1703.00,0.00,0.00,2.62,99.56,'2022-04-19 17:51:58','',''),(2618749,'1','201','1037',478,'Retail Sale Id 1466222',1300.00,0.00,0.00,2.00,76.00,'2022-04-19 18:01:29','',''),(2618750,'1','201','1037',478,'Retail Sale Id 1466223',650.00,0.00,0.00,1.00,38.00,'2022-04-19 18:03:10','',''),(2618751,'1','201','1037',478,'Retail Sale Id 1466224',1001.00,0.00,0.00,1.54,58.52,'2022-04-19 18:06:59','',''),(2618752,'1','201','1037',478,'Retail Sale Id 1466225',2600.00,0.00,0.00,4.00,152.00,'2022-04-20 08:12:17','',''),(2618753,'1','201','1037',478,'Retail Sale Id 1466226',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 08:28:34','',''),(2618754,'1','201','1037',478,'Retail Sale Id 1466227',5850.00,0.00,0.00,9.00,342.00,'2022-04-20 08:36:47','',''),(2618755,'1','201','1037',478,'Retail Sale Id 1466228',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 09:08:56','',''),(2618756,'1','201','1037',478,'Retail Sale Id 1466229',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 09:59:41','',''),(2618757,'1','201','1037',478,'Retail Sale Id 1466230',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 10:06:53','',''),(2618758,'1','201','1037',478,'Retail Sale Id 1466231',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 10:08:25','',''),(2618759,'1','201','1037',478,'Retail Sale Id 1466232',3003.00,0.00,0.00,4.62,175.56,'2022-04-20 10:14:01','',''),(2618760,'1','201','1037',478,'Retail Sale Id 1466233',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 10:19:03','',''),(2618761,'1','201','1037',478,'Retail Sale Id 1466234',650.00,0.00,0.00,1.00,38.00,'2022-04-20 10:48:51','',''),(2618762,'1','201','1037',478,'Retail Sale Id 1466235',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 11:00:53','',''),(2618763,'1','201','1037',478,'Retail Sale Id 1466235',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 11:00:53','',''),(2618764,'1','201','1037',478,'Retail Sale Id 1466236',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 11:07:06','',''),(2618765,'1','201','1037',478,'Retail Sale Id 1466237',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 11:11:30','',''),(2618766,'1','201','1037',478,'Retail Sale Id 1466238',650.00,0.00,0.00,1.00,38.00,'2022-04-20 11:18:03','',''),(2618767,'1','201','1037',478,'Retail Sale Id 1466239',3997.50,0.00,0.00,6.15,233.70,'2022-04-20 11:20:10','',''),(2618768,'1','201','1037',478,'Retail Sale Id 1466240',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 11:26:34','',''),(2618769,'1','201','1037',478,'Retail Sale Id 1466241',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 11:42:39','',''),(2618770,'1','201','1037',478,'Retail Sale Id 1466242',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 12:07:53','',''),(2618771,'1','201','1037',478,'Retail Sale Id 1466243',2002.00,0.00,0.00,3.08,117.04,'2022-04-20 12:10:43','',''),(2618772,'1','201','1037',478,'Retail Sale Id 1466244',4550.00,0.00,0.00,7.00,266.00,'2022-04-20 12:14:43','',''),(2618773,'1','201','1037',478,'Retail Sale Id 1466245',650.00,0.00,0.00,1.00,38.00,'2022-04-20 13:09:03','',''),(2618774,'1','201','1037',478,'Retail Sale Id 1466246',1300.00,0.00,0.00,2.00,76.00,'2022-04-20 13:11:23','',''),(2618775,'1','201','1037',478,'Retail Sale Id 1466247',1300.00,0.00,0.00,2.00,76.00,'2022-04-20 13:12:04','',''),(2618776,'1','201','1037',478,'Retail Sale Id 1466248',1300.00,0.00,0.00,2.00,76.00,'2022-04-20 13:12:43','',''),(2618777,'1','201','1037',478,'Retail Sale Id 1466249',650.00,0.00,0.00,1.00,38.00,'2022-04-20 13:13:15','',''),(2618778,'1','201','1037',478,'Retail Sale Id 1466250',6500.00,0.00,0.00,10.00,380.00,'2022-04-20 13:45:27','',''),(2618779,'1','201','1037',478,'Retail Sale Id 1466251',975.00,0.00,0.00,1.50,57.00,'2022-04-20 13:54:02','',''),(2618780,'1','201','1037',478,'Retail Sale Id 1466252',1625.00,0.00,0.00,2.50,95.00,'2022-04-20 14:02:52','',''),(2618781,'1','201','1037',478,'Retail Sale Id 1466253',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 14:26:16','',''),(2618782,'1','201','1037',478,'Retail Sale Id 1466254',4550.00,0.00,0.00,7.00,266.00,'2022-04-20 14:27:02','',''),(2618783,'1','201','1037',478,'Retail Sale Id 1466255',7000.50,0.00,0.00,10.77,409.26,'2022-04-20 14:33:28','',''),(2618784,'1','201','1037',478,'Retail Sale Id 1466256',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 15:12:41','',''),(2618785,'1','201','1037',478,'Retail Sale Id 1466257',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 15:22:50','',''),(2618786,'1','201','1037',478,'Retail Sale Id 1466258',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 15:28:10','',''),(2618787,'1','201','1037',478,'Retail Sale Id 1466259',1300.00,0.00,0.00,2.00,76.00,'2022-04-20 15:37:13','',''),(2618788,'1','201','1037',478,'Retail Sale Id 1466260',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 15:48:03','',''),(2618789,'1','201','1037',478,'Retail Sale Id 1466261',31000.00,0.00,0.00,50.00,400.00,'2022-04-20 16:05:30','',''),(2618790,'1','201','1037',478,'Retail Sale Id 1466262',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 16:14:43','',''),(2618791,'1','201','1037',478,'Retail Sale Id 1466263',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 16:23:09','',''),(2618792,'1','201','1037',478,'Retail Sale Id 1466264',620.00,0.00,0.00,1.00,8.00,'2022-04-20 16:28:50','',''),(2618793,'1','201','1037',478,'Retail Sale Id 1466265',2600.00,0.00,0.00,4.00,152.00,'2022-04-20 16:31:31','',''),(2618794,'1','201','1037',478,'Retail Sale Id 1466266',1001.00,0.00,0.00,1.54,58.52,'2022-04-20 16:40:33','',''),(2618795,'1','201','1037',478,'Retail Sale Id 1466267',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 16:48:11','',''),(2618796,'1','201','1037',478,'Retail Sale Id 1466268',1300.00,0.00,0.00,2.00,76.00,'2022-04-20 16:54:00','',''),(2618797,'1','201','1037',478,'Retail Sale Id 1466269',7501.00,0.00,0.00,11.54,438.52,'2022-04-20 16:59:16','',''),(2618798,'1','201','1037',478,'Retail Sale Id 1466270',4225.00,0.00,0.00,6.50,247.00,'2022-04-20 17:02:29','',''),(2618799,'1','201','1037',478,'Retail Sale Id 1466271',617.50,0.00,0.00,0.95,36.10,'2022-04-20 17:08:05','',''),(2618800,'1','201','1037',478,'Retail Sale Id 1466272',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 17:09:09','',''),(2618801,'1','201','1037',478,'Retail Sale Id 1466273',1755.00,0.00,0.00,2.70,102.60,'2022-04-20 17:15:00','',''),(2618802,'1','201','1037',478,'Retail Sale Id 1466274',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 17:15:51','',''),(2618803,'1','201','1037',478,'Return of Retail Sale Id 1466272',0.00,1950.00,3.00,0.00,-114.00,'2022-04-20 17:17:02','',''),(2618804,'1','201','1037',478,'Retail Sale Id 1466275',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 17:31:17','',''),(2618805,'1','201','1037',478,'Retail Sale Id 1466276',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 17:39:14','',''),(2618806,'1','201','1037',478,'Retail Sale Id 1466277',8125.00,0.00,0.00,12.50,475.00,'2022-04-20 17:41:58','',''),(2618807,'1','201','1037',478,'Retail Sale Id 1466278',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 17:43:30','',''),(2618808,'1','201','1037',478,'Retail Sale Id 1466279',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 17:48:32','',''),(2618809,'1','201','1037',478,'Retail Sale Id 1466280',500.50,0.00,0.00,0.77,29.26,'2022-04-20 18:01:28','',''),(2618810,'1','201','1037',478,'Retail Sale Id 1466281',1001.00,0.00,0.00,1.54,58.52,'2022-04-20 18:11:58','',''),(2618811,'1','201','1037',478,'Retail Sale Id 1466283',13640.00,0.00,0.00,22.00,176.00,'2022-04-21 07:15:25','',''),(2618812,'1','201','1037',478,'Retail Sale Id 1466284',8125.00,0.00,0.00,12.50,475.00,'2022-04-21 07:40:27','',''),(2618813,'1','201','1037',478,'Retail Sale Id 1466285',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 07:54:44','',''),(2618814,'1','201','1037',478,'Retail Sale Id 1466286',4225.00,0.00,0.00,6.50,247.00,'2022-04-21 07:59:36','',''),(2618815,'1','201','1037',478,'Retail Sale Id 1466287',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 08:27:27','',''),(2618816,'1','201','1037',478,'Retail Sale Id 1466288',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 08:30:59','',''),(2618817,'1','201','1037',478,'Retail Sale Id 1466289',4550.00,0.00,0.00,7.00,266.00,'2022-04-21 09:11:32','',''),(2618818,'1','201','1037',478,'Retail Sale Id 1466290',3802.50,0.00,0.00,5.85,222.30,'2022-04-21 09:39:32','',''),(2618819,'1','201','1037',478,'Retail Sale Id 1466292',2002.00,0.00,0.00,3.08,117.04,'2022-04-21 10:07:23','',''),(2618820,'1','201','1037',478,'Retail Sale Id 1466293',1800.50,0.00,0.00,2.77,105.26,'2022-04-21 10:09:29','',''),(2618821,'1','201','1037',478,'Retail Sale Id 1466294',650.00,0.00,0.00,1.00,38.00,'2022-04-21 10:11:22','',''),(2618822,'1','201','1037',478,'Retail Sale Id 1466295',2600.00,0.00,0.00,4.00,152.00,'2022-04-21 10:13:33','',''),(2618823,'1','201','1037',478,'Retail Sale Id 1466296',975.00,0.00,0.00,1.50,57.00,'2022-04-21 10:24:41','',''),(2618824,'1','201','1037',478,'Retail Sale Id 1466297',1625.00,0.00,0.00,2.50,95.00,'2022-04-21 10:48:01','',''),(2618825,'1','201','1037',478,'Retail Sale Id 1466298',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 10:55:55','',''),(2618826,'1','201','1037',478,'Retail Sale Id 1466299',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 11:01:48','',''),(2618827,'1','201','1037',478,'Retail Sale Id 1466300',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 11:02:57','',''),(2618828,'1','201','1037',478,'Retail Sale Id 1466301',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 11:13:02','',''),(2618829,'1','201','1037',478,'Retail Sale Id 1466302',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 11:13:41','',''),(2618830,'1','201','1037',478,'Retail Sale Id 1466303',650.00,0.00,0.00,1.00,38.00,'2022-04-21 11:14:14','',''),(2618831,'1','201','1037',478,'Retail Sale Id 1466304',8125.00,0.00,0.00,12.50,475.00,'2022-04-21 11:22:53','',''),(2618832,'1','201','1037',478,'Retail Sale Id 1466305',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 11:23:51','',''),(2618833,'1','201','1037',478,'Retail Sale Id 1466306',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 11:24:24','',''),(2618834,'1','201','1037',478,'Retail Sale Id 1466307',650.00,0.00,0.00,1.00,38.00,'2022-04-21 12:14:18','',''),(2618835,'1','201','1037',478,'Retail Sale Id 1466308',24800.00,0.00,0.00,40.00,320.00,'2022-04-21 12:17:48','',''),(2618836,'1','201','1037',478,'Retail Sale Id 1466309',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 12:36:51','',''),(2618837,'1','201','1037',478,'Retail Sale Id 1466310',3250.00,0.00,0.00,5.00,190.00,'2022-04-21 12:57:33','',''),(2618838,'1','201','1037',478,'Retail Sale Id 1466311',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 13:01:28','',''),(2618839,'1','201','1037',478,'Retail Sale Id 1466312',13000.00,0.00,0.00,20.00,760.00,'2022-04-21 13:19:43','',''),(2618840,'1','201','1037',478,'Retail Sale Id 1466313',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 13:39:28','',''),(2618841,'1','201','1037',478,'Retail Sale Id 1466314',2600.00,0.00,0.00,4.00,152.00,'2022-04-21 13:55:45','',''),(2618842,'1','201','1037',478,'Retail Sale Id 1466315',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 14:09:22','',''),(2618843,'1','201','1037',478,'Retail Sale Id 1466315',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 14:09:22','',''),(2618844,'1','201','1037',478,'Retail Sale Id 1466316',8125.00,0.00,0.00,12.50,475.00,'2022-04-21 14:17:28','',''),(2618845,'1','201','1037',478,'Retail Sale Id 1466317',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 14:20:04','',''),(2618846,'1','201','1037',478,'Retail Sale Id 1466318',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 14:27:54','',''),(2618847,'1','201','1037',478,'Retail Sale Id 1466319',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 14:37:04','',''),(2618848,'1','201','1037',478,'Retail Sale Id 1466320',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 14:39:56','',''),(2618849,'1','201','1037',478,'Retail Sale Id 1466321',6500.00,0.00,0.00,10.00,380.00,'2022-04-21 14:41:29','',''),(2618850,'1','201','1037',478,'Retail Sale Id 1466322',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 14:45:06','',''),(2618851,'1','201','1037',478,'Retail Sale Id 1466323',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 14:52:18','',''),(2618852,'1','201','1037',478,'Retail Sale Id 1466324',1300.00,0.00,0.00,2.00,76.00,'2022-04-21 15:07:45','',''),(2618853,'1','201','1037',478,'Retail Sale Id 1466325',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 15:12:38','',''),(2618854,'1','201','1037',478,'Retail Sale Id 1466326',5200.00,0.00,0.00,8.00,304.00,'2022-04-21 15:13:41','',''),(2618855,'1','201','1037',478,'Retail Sale Id 1466327',3250.00,0.00,0.00,5.00,190.00,'2022-04-21 15:23:40','',''),(2618856,'1','201','1037',478,'Retail Sale Id 1466328',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 15:39:21','',''),(2618857,'1','201','1037',478,'Retail Sale Id 1466329',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 15:40:40','',''),(2618858,'1','201','1037',478,'Retail Sale Id 1466330',3250.00,0.00,0.00,5.00,190.00,'2022-04-21 15:51:25','',''),(2618859,'1','201','1037',478,'Retail Sale Id 1466330',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 15:51:25','',''),(2618860,'1','201','1037',478,'Retail Sale Id 1466331',1001.00,0.00,0.00,1.54,58.52,'2022-04-21 15:53:14','',''),(2618861,'1','201','1037',478,'Retail Sale Id 1466332',3900.00,0.00,0.00,6.00,228.00,'2022-04-21 15:57:51','',''),(2618862,'1','201','1037',478,'Retail Sale Id 1466333',4550.00,0.00,0.00,7.00,266.00,'2022-04-21 16:02:52','',''),(2618863,'1','201','1037',478,'Retail Sale Id 1466334',1300.00,0.00,0.00,2.00,76.00,'2022-04-21 16:07:02','',''),(2618864,'1','201','1037',478,'Retail Sale Id 1466336',2502.50,0.00,0.00,3.85,146.30,'2022-04-21 16:16:12','',''),(2618865,'1','201','1037',478,'Retail Sale Id 1466337',702.00,0.00,0.00,1.08,41.04,'2022-04-21 16:37:43','',''),(2618866,'1','201','1037',478,'Retail Sale Id 1466338',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 16:42:16','',''),(2618867,'1','201','1037',478,'Retail Sale Id 1466339',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 16:43:13','',''),(2618868,'1','201','1037',478,'Retail Sale Id 1466340',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 16:47:00','',''),(2618869,'1','201','1037',478,'Retail Sale Id 1466341',1950.00,0.00,0.00,3.00,114.00,'2022-04-21 16:53:10','',''),(2618870,'1','201','1037',478,'Retail Sale Id 1466342',1300.00,0.00,0.00,2.00,76.00,'2022-04-21 17:00:22','',''),(2618871,'1','201','1037',478,'Retail Sale Id 1466343',650.00,0.00,0.00,1.00,38.00,'2022-04-21 17:05:14','',''),(2618872,'1','201','1037',478,'Retail Sale Id 1466344',3003.00,0.00,0.00,4.62,175.56,'2022-04-21 17:14:23','',''),(2618873,'1','201','1037',478,'Retail Sale Id 1466344',3003.00,0.00,0.00,4.62,175.56,'2022-04-21 17:14:23','',''),(2618874,'1','201','1037',478,'Retail Sale Id 1466345',1300.00,0.00,0.00,2.00,76.00,'2022-04-21 17:48:27','',''),(2618875,'1','201','1037',478,'Retail Sale Id 1466346',8125.00,0.00,0.00,12.50,475.00,'2022-04-21 17:49:34','',''),(2618876,'1','201','1037',478,'Retail Sale Id 1466347',8125.00,0.00,0.00,12.50,475.00,'2022-04-21 18:12:48','',''),(2618877,'1','201','1037',478,'Retail Sale Id 1466348',3250.00,0.00,0.00,5.00,190.00,'2022-04-21 18:14:49','',''),(2618878,'1','201','1037',478,'Retail Sale Id 1466349',1371.50,0.00,0.00,2.11,80.18,'2022-04-21 18:30:53','',''),(2618879,'1','201','1037',478,'Retail Sale Id 1466350',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 08:06:59','',''),(2618880,'1','201','1037',478,'Retail Sale Id 1466351',2002.00,0.00,0.00,3.08,117.04,'2022-04-22 08:18:07','',''),(2618881,'1','201','1037',478,'Retail Sale Id 1466352',3250.00,0.00,0.00,5.00,190.00,'2022-04-22 08:38:03','',''),(2618882,'1','201','1037',478,'Retail Sale Id 1466353',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 08:41:39','',''),(2618883,'1','201','1037',478,'Retail Sale Id 1466354',650.00,0.00,0.00,1.00,38.00,'2022-04-22 08:42:43','',''),(2618884,'1','201','1037',478,'Retail Sale Id 1466355',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 09:13:36','',''),(2618885,'1','201','1037',478,'Retail Sale Id 1466356',5200.00,0.00,0.00,8.00,304.00,'2022-04-22 09:20:14','',''),(2618886,'1','201','1037',478,'Retail Sale Id 1466357',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 09:22:13','',''),(2618887,'1','201','1037',478,'Retail Sale Id 1466358',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 09:36:05','',''),(2618888,'1','201','1037',478,'Retail Sale Id 1466359',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 09:59:12','',''),(2618889,'1','201','1037',478,'Retail Sale Id 1466360',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 10:00:37','',''),(2618890,'1','201','1037',478,'Retail Sale Id 1466361',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 10:08:45','',''),(2618891,'1','201','1037',478,'Retail Sale Id 1466362',2600.00,0.00,0.00,4.00,152.00,'2022-04-22 10:13:02','',''),(2618892,'1','201','1037',478,'Retail Sale Id 1466363',1300.00,0.00,0.00,2.00,76.00,'2022-04-22 10:16:25','',''),(2618893,'1','201','1037',478,'Retail Sale Id 1466364',650.00,0.00,0.00,1.00,38.00,'2022-04-22 10:18:54','',''),(2618894,'1','201','1037',478,'Retail Sale Id 1466365',1501.50,0.00,0.00,2.31,87.78,'2022-04-22 10:22:07','',''),(2618895,'1','201','1037',478,'Retail Sale Id 1466366',1001.00,0.00,0.00,1.54,58.52,'2022-04-22 10:44:31','',''),(2618896,'1','201','1037',478,'Retail Sale Id 1466367',4225.00,0.00,0.00,6.50,247.00,'2022-04-22 10:51:56','',''),(2618897,'1','201','1037',478,'Retail Sale Id 1466368',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 10:54:26','',''),(2618898,'1','201','1037',478,'Retail Sale Id 1466368',7800.00,0.00,0.00,12.00,456.00,'2022-04-22 10:54:26','',''),(2618899,'1','201','1037',478,'Retail Sale Id 1466369',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 10:58:41','',''),(2618900,'1','201','1037',478,'Retail Sale Id 1466370',2600.00,0.00,0.00,4.00,152.00,'2022-04-22 11:00:34','',''),(2618901,'1','201','1037',478,'Retail Sale Id 1466371',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 11:26:44','',''),(2618902,'1','201','1037',478,'Retail Sale Id 1466372',3250.00,0.00,0.00,5.00,190.00,'2022-04-22 11:40:20','',''),(2618903,'1','201','1037',478,'Retail Sale Id 1466373',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 11:44:37','',''),(2618904,'1','201','1037',478,'Retail Sale Id 1466373',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 11:44:37','',''),(2618905,'1','201','1037',478,'Retail Sale Id 1466374',6500.00,0.00,0.00,10.00,380.00,'2022-04-22 11:52:20','',''),(2618906,'1','201','1037',478,'Retail Sale Id 1466375',650.00,0.00,0.00,1.00,38.00,'2022-04-22 12:00:39','',''),(2618907,'1','201','1037',478,'Retail Sale Id 1466376',3250.00,0.00,0.00,5.00,190.00,'2022-04-22 12:01:52','',''),(2618908,'1','201','1037',478,'Retail Sale Id 1466377',2002.00,0.00,0.00,3.08,117.04,'2022-04-22 12:07:28','',''),(2618909,'1','201','1037',478,'Retail Sale Id 1466378',2502.50,0.00,0.00,3.85,146.30,'2022-04-22 12:39:57','',''),(2618910,'1','201','1037',478,'Retail Sale Id 1466379',10400.00,0.00,0.00,16.00,608.00,'2022-04-22 12:49:21','',''),(2618911,'1','201','1037',478,'Retail Sale Id 1466380',4550.00,0.00,0.00,7.00,266.00,'2022-04-22 13:09:20','',''),(2618912,'1','201','1037',478,'Retail Sale Id 1466381',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 13:10:18','',''),(2618913,'1','201','1037',478,'Retail Sale Id 1466382',2600.00,0.00,0.00,4.00,152.00,'2022-04-22 13:12:01','',''),(2618914,'1','201','1037',478,'Retail Sale Id 1466383',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 13:28:30','',''),(2618915,'1','201','1037',478,'Retail Sale Id 1466383',3048.50,0.00,0.00,4.69,178.22,'2022-04-22 13:28:30','',''),(2618916,'1','201','1037',478,'Retail Sale Id 1466384',1300.00,0.00,0.00,2.00,76.00,'2022-04-22 13:33:28','',''),(2618917,'1','201','1037',478,'Retail Sale Id 1466385',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 13:44:14','',''),(2618918,'1','201','1037',478,'Retail Sale Id 1466386',4998.50,0.00,0.00,7.69,292.22,'2022-04-22 14:01:33','',''),(2618919,'1','201','1037',478,'Retail Sale Id 1466388',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 14:13:59','',''),(2618920,'1','201','1037',478,'Retail Sale Id 1466389',1300.00,0.00,0.00,2.00,76.00,'2022-04-22 14:16:08','',''),(2618921,'1','201','1037',478,'Retail Sale Id 1466390',8125.00,0.00,0.00,12.50,475.00,'2022-04-22 14:20:29','',''),(2618922,'1','201','1037',478,'Retail Sale Id 1466391',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 14:22:19','',''),(2618923,'1','201','1037',478,'Retail Sale Id 1466393',2600.00,0.00,0.00,4.00,152.00,'2022-04-22 14:34:57','',''),(2618924,'1','201','1037',478,'Retail Sale Id 1466394',2002.00,0.00,0.00,3.08,117.04,'2022-04-22 14:39:37','',''),(2618925,'1','201','1037',478,'Retail Sale Id 1466395',8125.00,0.00,0.00,12.50,475.00,'2022-04-22 14:41:46','',''),(2618926,'1','201','1037',478,'Retail Sale Id 1466396',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 15:01:24','',''),(2618927,'1','201','1037',478,'Retail Sale Id 1466397',8125.00,0.00,0.00,12.50,475.00,'2022-04-22 15:04:48','',''),(2618928,'1','201','1037',478,'Retail Sale Id 1466398',8125.00,0.00,0.00,12.50,475.00,'2022-04-22 15:06:00','',''),(2618929,'1','201','1037',478,'Retail Sale Id 1466399',2600.00,0.00,0.00,4.00,152.00,'2022-04-22 15:11:45','',''),(2618930,'1','201','1037',478,'Retail Sale Id 1466400',2600.00,0.00,0.00,4.00,152.00,'2022-04-22 15:16:32','',''),(2618931,'1','201','1037',478,'Retail Sale Id 1466401',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 15:33:58','',''),(2618932,'1','201','1037',478,'Retail Sale Id 1466402',3250.00,0.00,0.00,5.00,190.00,'2022-04-22 15:35:09','',''),(2618933,'1','201','1037',478,'Retail Sale Id 1466403',3250.00,0.00,0.00,5.00,190.00,'2022-04-22 15:36:17','',''),(2618934,'1','201','1037',478,'Retail Sale Id 1466404',6500.00,0.00,0.00,10.00,380.00,'2022-04-22 15:45:25','',''),(2618935,'1','201','1037',478,'Retail Sale Id 1466405',1300.00,0.00,0.00,2.00,76.00,'2022-04-22 16:02:37','',''),(2618936,'1','201','1037',478,'Retail Sale Id 1466406',1001.00,0.00,0.00,1.54,58.52,'2022-04-22 16:09:50','',''),(2618937,'1','201','1037',478,'Retail Sale Id 1466407',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 16:19:35','',''),(2618938,'1','201','1037',478,'Retail Sale Id 1466408',3250.00,0.00,0.00,5.00,190.00,'2022-04-22 16:26:55','',''),(2618939,'1','201','1037',478,'Retail Sale Id 1466409',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 16:30:06','',''),(2618940,'1','201','1037',478,'Retail Sale Id 1466410',4225.00,0.00,0.00,6.50,247.00,'2022-04-22 16:35:18','',''),(2618941,'1','201','1037',478,'Retail Sale Id 1466411',2600.00,0.00,0.00,4.00,152.00,'2022-04-22 16:39:30','',''),(2618942,'1','201','1037',478,'Retail Sale Id 1466412',1300.00,0.00,0.00,2.00,76.00,'2022-04-22 16:40:31','',''),(2618943,'1','201','1037',478,'Retail Sale Id 1466413',1300.00,0.00,0.00,2.00,76.00,'2022-04-22 16:42:17','',''),(2618944,'1','201','1037',478,'Retail Sale Id 1466414',2600.00,0.00,0.00,4.00,152.00,'2022-04-22 16:47:55','',''),(2618945,'1','201','1037',478,'Retail Sale Id 1466415',1300.00,0.00,0.00,2.00,76.00,'2022-04-22 16:49:03','',''),(2618946,'1','201','1037',478,'Retail Sale Id 1466416',8125.00,0.00,0.00,12.50,475.00,'2022-04-22 16:50:15','',''),(2618947,'1','201','1037',478,'Retail Sale Id 1466417',2600.00,0.00,0.00,4.00,152.00,'2022-04-22 17:03:59','',''),(2618948,'1','201','1037',478,'Retail Sale Id 1466418',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 17:06:32','',''),(2618949,'1','201','1037',478,'Retail Sale Id 1466419',650.00,0.00,0.00,1.00,38.00,'2022-04-22 17:11:57','',''),(2618950,'1','201','1037',478,'Retail Sale Id 1466420',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 17:14:46','',''),(2618951,'1','201','1037',478,'Retail Sale Id 1466421',3900.00,0.00,0.00,6.00,228.00,'2022-04-22 17:17:54','',''),(2618952,'1','201','1037',478,'Retail Sale Id 1466422',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 17:20:29','',''),(2618953,'1','201','1037',478,'Retail Sale Id 1466423',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 17:21:20','',''),(2618954,'1','201','1037',478,'Retail Sale Id 1466424',1501.50,0.00,0.00,2.31,87.78,'2022-04-22 17:22:09','',''),(2618955,'1','201','1037',478,'Retail Sale Id 1466425',11470.00,0.00,0.00,18.50,148.00,'2022-04-22 17:23:50','',''),(2618956,'1','201','1037',478,'Retail Sale Id 1466426',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 17:27:37','',''),(2618957,'1','201','1037',478,'Retail Sale Id 1466427',5850.00,0.00,0.00,9.00,342.00,'2022-04-22 17:29:02','',''),(2618958,'1','201','1037',478,'Retail Sale Id 1466428',1950.00,0.00,0.00,3.00,114.00,'2022-04-22 17:31:51','',''),(2618959,'1','201','1037',478,'Retail Sale Id 1466429',8125.00,0.00,0.00,12.50,475.00,'2022-04-22 17:34:22','',''),(2618960,'1','201','1037',478,'Retail Sale Id 1466430',2600.00,0.00,0.00,4.00,152.00,'2022-04-22 17:41:26','',''),(2618961,'1','201','1037',478,'Retail Sale Id 1466431',6200.00,0.00,0.00,10.00,80.00,'2022-04-23 07:47:58','',''),(2618962,'1','201','1037',478,'Return of Retail Sale Id 1466431',0.00,6200.00,10.00,0.00,-80.00,'2022-04-23 07:52:49','',''),(2618963,'1','201','1037',478,'Retail Sale Id 1466432',3250.00,0.00,0.00,5.00,190.00,'2022-04-23 09:51:36','',''),(2618964,'1','201','1037',478,'Retail Sale Id 1466433',3003.00,0.00,0.00,4.62,175.56,'2022-04-23 09:52:34','',''),(2618965,'1','201','1037',478,'Retail Sale Id 1466434',650.00,0.00,0.00,1.00,38.00,'2022-04-23 09:55:50','',''),(2618966,'1','201','1037',478,'Retail Sale Id 1466436',4550.00,0.00,0.00,7.00,266.00,'2022-04-23 10:05:06','',''),(2618967,'1','201','1037',478,'Retail Sale Id 1466437',3900.00,0.00,0.00,6.00,228.00,'2022-04-23 13:20:26','',''),(2618968,'1','201','1037',478,'Retail Sale Id 1466438',4348.50,0.00,0.00,6.69,254.22,'2022-04-23 13:22:21','',''),(2618969,'1','201','1037',478,'Retail Sale Id 1466439',1625.00,0.00,0.00,2.50,95.00,'2022-04-23 13:23:17','',''),(2618970,'1','201','1037',478,'Retail Sale Id 1466440',8125.00,0.00,0.00,12.50,475.00,'2022-04-23 13:23:59','',''),(2618971,'1','201','1037',478,'Return of Retail Sale Id 1466436',0.00,4550.00,7.00,0.00,-266.00,'2022-04-23 13:26:33','',''),(2618972,'1','201','1037',478,'Retail Sale Id 1466441',3900.00,0.00,0.00,6.00,228.00,'2022-04-23 13:31:14','',''),(2618973,'1','201','1037',478,'Retail Sale Id 1466442',3900.00,0.00,0.00,6.00,228.00,'2022-04-23 13:50:54','',''),(2618974,'1','201','1037',478,'Retail Sale Id 1466443',4550.00,0.00,0.00,7.00,266.00,'2022-04-23 13:52:43','',''),(2618975,'1','201','1037',478,'Retail Sale Id 1466444',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 13:55:34','',''),(2618976,'1','201','1037',478,'Retail Sale Id 1466445',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 13:56:38','',''),(2618977,'1','201','1037',478,'Retail Sale Id 1466446',650.00,0.00,0.00,1.00,38.00,'2022-04-23 14:11:09','',''),(2618978,'1','201','1037',478,'Retail Sale Id 1466447',7750.00,0.00,0.00,12.50,100.00,'2022-04-23 14:22:53','',''),(2618979,'1','201','1037',478,'Retail Sale Id 1466449',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 14:24:54','',''),(2618980,'1','201','1037',478,'Retail Sale Id 1466450',3900.00,0.00,0.00,6.00,228.00,'2022-04-23 14:29:20','',''),(2618981,'1','201','1037',478,'Retail Sale Id 1466451',2600.00,0.00,0.00,4.00,152.00,'2022-04-23 14:31:29','',''),(2618982,'1','201','1037',478,'Retail Sale Id 1466452',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 14:35:10','',''),(2618983,'1','201','1037',478,'Retail Sale Id 1466453',3250.00,0.00,0.00,5.00,190.00,'2022-04-23 14:40:41','',''),(2618984,'1','201','1037',478,'Retail Sale Id 1466454',5850.00,0.00,0.00,9.00,342.00,'2022-04-23 14:48:48','',''),(2618985,'1','201','1037',478,'Retail Sale Id 1466455',3250.00,0.00,0.00,5.00,190.00,'2022-04-23 14:50:30','',''),(2618986,'1','201','1037',478,'Retail Sale Id 1466456',3900.00,0.00,0.00,6.00,228.00,'2022-04-23 14:57:01','',''),(2618987,'1','201','1037',478,'Retail Sale Id 1466457',1001.00,0.00,0.00,1.54,58.52,'2022-04-23 15:13:25','',''),(2618988,'1','201','1037',478,'Retail Sale Id 1466458',4550.00,0.00,0.00,7.00,266.00,'2022-04-23 15:14:17','',''),(2618989,'1','201','1037',478,'Retail Sale Id 1466459',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 15:22:08','',''),(2618990,'1','201','1037',478,'Retail Sale Id 1466460',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 15:23:54','',''),(2618991,'1','201','1037',478,'Retail Sale Id 1466461',3900.00,0.00,0.00,6.00,228.00,'2022-04-23 15:31:09','',''),(2618992,'1','201','1037',478,'Retail Sale Id 1466462',2502.50,0.00,0.00,3.85,146.30,'2022-04-23 15:55:14','',''),(2618993,'1','201','1037',478,'Retail Sale Id 1466464',3900.00,0.00,0.00,6.00,228.00,'2022-04-23 16:08:37','',''),(2618994,'1','201','1037',478,'Retail Sale Id 1466465',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 16:09:19','',''),(2618995,'1','201','1037',478,'Retail Sale Id 1466466',650.00,0.00,0.00,1.00,38.00,'2022-04-23 16:11:26','',''),(2618996,'1','201','1037',478,'Retail Sale Id 1466467',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 16:14:46','',''),(2618997,'1','201','1037',478,'Retail Sale Id 1466468',3900.00,0.00,0.00,6.00,228.00,'2022-04-23 16:20:24','',''),(2618998,'1','201','1037',478,'Retail Sale Id 1466468',7800.00,0.00,0.00,12.00,456.00,'2022-04-23 16:20:24','',''),(2618999,'1','201','1037',478,'Retail Sale Id 1466468',7800.00,0.00,0.00,12.00,456.00,'2022-04-23 16:20:24','',''),(2619000,'1','201','1037',478,'Retail Sale Id 1466469',8125.00,0.00,0.00,12.50,475.00,'2022-04-23 16:42:35','',''),(2619001,'1','201','1037',478,'Retail Sale Id 1466470',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 16:43:25','',''),(2619002,'1','201','1037',478,'Retail Sale Id 1466471',6500.00,0.00,0.00,10.00,380.00,'2022-04-23 16:44:27','',''),(2619003,'1','201','1037',478,'Retail Sale Id 1466472',2600.00,0.00,0.00,4.00,152.00,'2022-04-23 16:54:12','',''),(2619004,'1','201','1037',478,'Retail Sale Id 1466473',1501.50,0.00,0.00,2.31,87.78,'2022-04-23 16:57:31','',''),(2619005,'1','201','1037',478,'Retail Sale Id 1466474',8125.00,0.00,0.00,12.50,475.00,'2022-04-23 16:59:37','',''),(2619006,'1','201','1037',478,'Retail Sale Id 1466475',1300.00,0.00,0.00,2.00,76.00,'2022-04-23 17:04:42','',''),(2619007,'1','201','1037',478,'Retail Sale Id 1466476',3720.00,0.00,0.00,6.00,48.00,'2022-04-23 17:05:35','',''),(2619008,'1','201','1037',478,'Retail Sale Id 1466477',1300.00,0.00,0.00,2.00,76.00,'2022-04-23 17:06:43','',''),(2619009,'1','201','1037',478,'Retail Sale Id 1466478',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 17:13:47','',''),(2619010,'1','201','1037',478,'Retail Sale Id 1466479',3003.00,0.00,0.00,4.62,175.56,'2022-04-23 17:21:36','',''),(2619011,'1','201','1037',478,'Retail Sale Id 1466480',4550.00,0.00,0.00,7.00,266.00,'2022-04-23 17:24:33','',''),(2619012,'1','201','1037',478,'Retail Sale Id 1466481',1950.00,0.00,0.00,3.00,114.00,'2022-04-23 17:25:41','',''),(2619013,'1','201','1037',478,'Retail Sale Id 1466482',1300.00,0.00,0.00,2.00,76.00,'2022-04-23 17:26:26','',''),(2619014,'1','201','1037',478,'Retail Sale Id 1466483',3720.00,0.00,0.00,6.00,48.00,'2022-04-23 17:28:55','',''),(2619015,'1','201','1037',478,'Retail Sale Id 1466484',8125.00,0.00,0.00,12.50,475.00,'2022-04-23 17:30:30','',''),(2619016,'1','201','1037',478,'Retail Sale Id 1466485',2600.00,0.00,0.00,4.00,152.00,'2022-04-23 17:31:24','',''),(2619017,'1','201','1037',478,'Retail Sale Id 1466486',3003.00,0.00,0.00,4.62,175.56,'2022-04-23 17:43:21','',''),(2619018,'1','201','1037',478,'Retail Sale Id 1466487',1001.00,0.00,0.00,1.54,58.52,'2022-04-23 17:45:42','',''),(2619019,'1','201','1037',478,'Retail Sale Id 1466488',799.50,0.00,0.00,1.23,46.74,'2022-04-23 18:24:54','',''),(2619020,'1','201','1037',478,'Retail Sale Id 1466489',4550.00,0.00,0.00,7.00,266.00,'2022-04-24 08:26:19','',''),(2619021,'1','201','1037',478,'Retail Sale Id 1466490',4550.00,0.00,0.00,7.00,266.00,'2022-04-24 08:33:14','',''),(2619022,'1','201','1037',478,'Retail Sale Id 1466491',2600.00,0.00,0.00,4.00,152.00,'2022-04-24 08:40:45','',''),(2619023,'1','201','1037',478,'Retail Sale Id 1466492',8125.00,0.00,0.00,12.50,475.00,'2022-04-24 08:59:28','',''),(2619024,'1','201','1037',478,'Retail Sale Id 1466493',7000.50,0.00,0.00,10.77,409.26,'2022-04-24 09:01:05','',''),(2619025,'1','201','1037',478,'Retail Sale Id 1466495',2002.00,0.00,0.00,3.08,117.04,'2022-04-24 09:15:36','',''),(2619026,'1','201','1037',478,'Retail Sale Id 1466496',1300.00,0.00,0.00,2.00,76.00,'2022-04-24 09:26:29','',''),(2619027,'1','201','1037',478,'Retail Sale Id 1466497',650.00,0.00,0.00,1.00,38.00,'2022-04-24 09:27:48','',''),(2619028,'1','201','1037',478,'Retail Sale Id 1466498',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 09:39:41','',''),(2619029,'1','201','1037',478,'Retail Sale Id 1466499',1001.00,0.00,0.00,1.54,58.52,'2022-04-24 09:46:13','',''),(2619030,'1','201','1037',478,'Retail Sale Id 1466500',3250.00,0.00,0.00,5.00,190.00,'2022-04-24 10:22:14','',''),(2619031,'1','201','1037',478,'Retail Sale Id 1466501',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 10:25:46','',''),(2619032,'1','201','1037',478,'Retail Sale Id 1466502',8125.00,0.00,0.00,12.50,475.00,'2022-04-24 10:30:23','',''),(2619033,'1','201','1037',478,'Retail Sale Id 1466503',1300.00,0.00,0.00,2.00,76.00,'2022-04-24 10:48:15','',''),(2619034,'1','201','1037',478,'Retail Sale Id 1466504',3250.00,0.00,0.00,5.00,190.00,'2022-04-24 11:00:31','',''),(2619035,'1','201','1037',478,'Retail Sale Id 1466505',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 11:05:43','',''),(2619036,'1','201','1037',478,'Retail Sale Id 1466506',3250.00,0.00,0.00,5.00,190.00,'2022-04-24 11:13:32','',''),(2619037,'1','201','1037',478,'Retail Sale Id 1466507',975.00,0.00,0.00,1.50,57.00,'2022-04-24 11:15:03','',''),(2619038,'1','201','1037',478,'Retail Sale Id 1466508',1300.00,0.00,0.00,2.00,76.00,'2022-04-24 11:16:03','',''),(2619039,'1','201','1037',478,'Retail Sale Id 1466509',1300.00,0.00,0.00,2.00,76.00,'2022-04-24 11:44:53','',''),(2619040,'1','201','1037',478,'Retail Sale Id 1466510',8125.00,0.00,0.00,12.50,475.00,'2022-04-24 11:52:04','',''),(2619041,'1','201','1037',478,'Retail Sale Id 1466510',8125.00,0.00,0.00,12.50,475.00,'2022-04-24 11:52:04','',''),(2619042,'1','201','1037',478,'Retail Sale Id 1466511',1300.00,0.00,0.00,2.00,76.00,'2022-04-24 12:08:38','',''),(2619043,'1','201','1037',478,'Retail Sale Id 1466512',3250.00,0.00,0.00,5.00,190.00,'2022-04-24 12:40:50','',''),(2619044,'1','201','1037',478,'Retail Sale Id 1466513',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 12:45:01','',''),(2619045,'1','201','1037',478,'Retail Sale Id 1466514',3900.00,0.00,0.00,6.00,228.00,'2022-04-24 12:46:37','',''),(2619046,'1','201','1037',478,'Retail Sale Id 1466515',2275.00,0.00,0.00,3.50,133.00,'2022-04-24 13:08:24','',''),(2619047,'1','201','1037',478,'Retail Sale Id 1466516',8125.00,0.00,0.00,12.50,475.00,'2022-04-24 13:13:45','',''),(2619048,'1','201','1037',478,'Retail Sale Id 1466517',3900.00,0.00,0.00,6.00,228.00,'2022-04-24 13:18:07','',''),(2619049,'1','201','1037',478,'Retail Sale Id 1466518',3900.00,0.00,0.00,6.00,228.00,'2022-04-24 13:21:52','',''),(2619050,'1','201','1037',478,'Retail Sale Id 1466519',3250.00,0.00,0.00,5.00,190.00,'2022-04-24 13:22:29','',''),(2619051,'1','201','1037',478,'Retail Sale Id 1466520',3900.00,0.00,0.00,6.00,228.00,'2022-04-24 13:35:27','',''),(2619052,'1','201','1037',478,'Retail Sale Id 1466521',8125.00,0.00,0.00,12.50,475.00,'2022-04-24 13:36:42','',''),(2619053,'1','201','1037',478,'Retail Sale Id 1466522',1001.00,0.00,0.00,1.54,58.52,'2022-04-24 13:39:29','',''),(2619054,'1','201','1037',478,'Retail Sale Id 1466523',1300.00,0.00,0.00,2.00,76.00,'2022-04-24 13:56:47','',''),(2619055,'1','201','1037',478,'Retail Sale Id 1466524',650.00,0.00,0.00,1.00,38.00,'2022-04-24 14:00:28','',''),(2619056,'1','201','1037',478,'Retail Sale Id 1466525',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 14:20:48','',''),(2619057,'1','201','1037',478,'Retail Sale Id 1466526',3900.00,0.00,0.00,6.00,228.00,'2022-04-24 14:28:48','',''),(2619058,'1','201','1037',478,'Retail Sale Id 1466527',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 14:47:50','',''),(2619059,'1','201','1037',478,'Retail Sale Id 1466528',3900.00,0.00,0.00,6.00,228.00,'2022-04-24 15:04:40','',''),(2619060,'1','201','1037',478,'Retail Sale Id 1466529',3900.00,0.00,0.00,6.00,228.00,'2022-04-24 15:19:45','',''),(2619061,'1','201','1037',478,'Retail Sale Id 1466530',598.00,0.00,0.00,0.92,34.96,'2022-04-24 15:24:13','',''),(2619062,'1','201','1037',478,'Retail Sale Id 1466531',3497.00,0.00,0.00,5.38,204.44,'2022-04-24 15:31:33','',''),(2619063,'1','201','1037',478,'Retail Sale Id 1466532',3003.00,0.00,0.00,4.62,175.56,'2022-04-24 15:46:04','',''),(2619064,'1','201','1037',478,'Retail Sale Id 1466533',3900.00,0.00,0.00,6.00,228.00,'2022-04-24 15:52:59','',''),(2619065,'1','201','1037',478,'Retail Sale Id 1466533',8125.00,0.00,0.00,12.50,475.00,'2022-04-24 15:52:59','',''),(2619066,'1','201','1037',478,'Retail Sale Id 1466534',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 15:53:58','',''),(2619067,'1','201','1037',478,'Retail Sale Id 1466535',4550.00,0.00,0.00,7.00,266.00,'2022-04-24 16:07:39','',''),(2619068,'1','201','1037',478,'Retail Sale Id 1466535',8125.00,0.00,0.00,12.50,475.00,'2022-04-24 16:07:39','',''),(2619069,'1','201','1037',478,'Retail Sale Id 1466536',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 16:08:42','',''),(2619070,'1','201','1037',478,'Retail Sale Id 1466537',3900.00,0.00,0.00,6.00,228.00,'2022-04-24 16:12:55','',''),(2619071,'1','201','1037',478,'Retail Sale Id 1466538',2002.00,0.00,0.00,3.08,117.04,'2022-04-24 16:40:09','',''),(2619072,'1','201','1037',478,'Retail Sale Id 1466539',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 16:40:59','',''),(2619073,'1','201','1037',478,'Retail Sale Id 1466540',4998.50,0.00,0.00,7.69,292.22,'2022-04-24 16:48:01','',''),(2619074,'1','201','1037',478,'Retail Sale Id 1466541',3003.00,0.00,0.00,4.62,175.56,'2022-04-24 16:52:36','',''),(2619075,'1','201','1037',478,'Retail Sale Id 1466542',3003.00,0.00,0.00,4.62,175.56,'2022-04-24 16:53:53','',''),(2619076,'1','201','1037',478,'Retail Sale Id 1466543',1001.00,0.00,0.00,1.54,58.52,'2022-04-24 16:54:51','',''),(2619077,'1','201','1037',478,'Retail Sale Id 1466544',3900.00,0.00,0.00,6.00,228.00,'2022-04-24 16:57:06','',''),(2619078,'1','201','1037',478,'Retail Sale Id 1466545',2600.00,0.00,0.00,4.00,152.00,'2022-04-24 16:58:59','',''),(2619079,'1','201','1037',478,'Retail Sale Id 1466546',1625.00,0.00,0.00,2.50,95.00,'2022-04-24 17:01:04','',''),(2619080,'1','201','1037',478,'Retail Sale Id 1466547',7501.00,0.00,0.00,11.54,438.52,'2022-04-24 17:05:00','',''),(2619081,'1','201','1037',478,'Retail Sale Id 1466548',3497.00,0.00,0.00,5.38,204.44,'2022-04-24 17:07:33','',''),(2619082,'1','201','1037',478,'Retail Sale Id 1466549',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 17:13:47','',''),(2619083,'1','201','1037',478,'Retail Sale Id 1466550',650.00,0.00,0.00,1.00,38.00,'2022-04-24 17:27:57','',''),(2619084,'1','201','1037',478,'Retail Sale Id 1466551',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 17:37:21','',''),(2619085,'1','201','1037',478,'Retail Sale Id 1466552',1950.00,0.00,0.00,3.00,114.00,'2022-04-24 17:47:41','',''),(2619086,'1','201','1037',478,'Retail Sale Id 1466553',1300.00,0.00,0.00,2.00,76.00,'2022-04-24 18:00:59','',''),(2619087,'1','201','1037',478,'Retail Sale Id 1466554',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 08:08:15','',''),(2619088,'1','201','1037',478,'Retail Sale Id 1466555',6200.00,0.00,0.00,10.00,80.00,'2022-04-25 08:12:41','',''),(2619089,'1','201','1037',478,'Retail Sale Id 1466556',1300.00,0.00,0.00,2.00,76.00,'2022-04-25 08:47:13','',''),(2619090,'1','201','1037',478,'Retail Sale Id 1466557',2600.00,0.00,0.00,4.00,152.00,'2022-04-25 09:09:51','',''),(2619091,'1','201','1037',478,'Retail Sale Id 1466558',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 09:28:08','',''),(2619092,'1','201','1037',478,'Retail Sale Id 1466559',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 09:32:31','',''),(2619093,'1','201','1037',478,'Retail Sale Id 1466560',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 09:54:06','',''),(2619094,'1','201','1037',478,'Retail Sale Id 1466561',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 10:37:19','',''),(2619095,'1','201','1037',478,'Retail Sale Id 1466561',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 10:37:19','',''),(2619096,'1','201','1037',478,'Retail Sale Id 1466562',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 11:00:32','',''),(2619097,'1','201','1037',478,'Retail Sale Id 1466564',7800.00,0.00,0.00,12.00,456.00,'2022-04-25 11:16:41','',''),(2619098,'1','201','1037',478,'Retail Sale Id 1466564',7800.00,0.00,0.00,12.00,456.00,'2022-04-25 11:16:41','',''),(2619099,'1','201','1037',478,'Retail Sale Id 1466565',1501.50,0.00,0.00,2.31,87.78,'2022-04-25 11:19:51','',''),(2619100,'1','201','1037',478,'Retail Sale Id 1466566',1001.00,0.00,0.00,1.54,58.52,'2022-04-25 11:30:41','',''),(2619101,'1','201','1037',478,'Retail Sale Id 1466567',3250.00,0.00,0.00,5.00,190.00,'2022-04-25 11:33:10','',''),(2619102,'1','201','1037',478,'Retail Sale Id 1466568',4550.00,0.00,0.00,7.00,266.00,'2022-04-25 11:39:35','',''),(2619103,'1','201','1037',478,'Retail Sale Id 1466569',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 11:52:10','',''),(2619104,'1','201','1037',478,'Retail Sale Id 1466570',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 12:00:58','',''),(2619105,'1','201','1037',478,'Retail Sale Id 1466571',3250.00,0.00,0.00,5.00,190.00,'2022-04-25 12:19:07','',''),(2619106,'1','201','1037',478,'Retail Sale Id 1466572',1001.00,0.00,0.00,1.54,58.52,'2022-04-25 12:49:23','',''),(2619107,'1','201','1037',478,'Retail Sale Id 1466573',3003.00,0.00,0.00,4.62,175.56,'2022-04-25 12:53:07','',''),(2619108,'1','201','1037',478,'Retail Sale Id 1466574',3250.00,0.00,0.00,5.00,190.00,'2022-04-25 12:53:54','',''),(2619109,'1','201','1037',478,'Retail Sale Id 1466575',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 12:57:12','',''),(2619110,'1','201','1037',478,'Retail Sale Id 1466576',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 13:14:56','',''),(2619111,'1','201','1037',478,'Retail Sale Id 1466577',3250.00,0.00,0.00,5.00,190.00,'2022-04-25 13:18:18','',''),(2619112,'1','201','1037',478,'Retail Sale Id 1466578',3250.00,0.00,0.00,5.00,190.00,'2022-04-25 13:27:17','',''),(2619113,'1','201','1037',478,'Retail Sale Id 1466579',8125.00,0.00,0.00,12.50,475.00,'2022-04-25 13:28:26','',''),(2619114,'1','201','1037',478,'Retail Sale Id 1466580',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 13:29:50','',''),(2619115,'1','201','1037',478,'Retail Sale Id 1466581',1001.00,0.00,0.00,1.54,58.52,'2022-04-25 13:36:31','',''),(2619116,'1','201','1037',478,'Retail Sale Id 1466582',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 14:06:00','',''),(2619117,'1','201','1037',478,'Retail Sale Id 1466583',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 14:23:35','',''),(2619118,'1','201','1037',478,'Retail Sale Id 1466584',7150.00,0.00,0.00,11.00,418.00,'2022-04-25 14:24:54','',''),(2619119,'1','201','1037',478,'Retail Sale Id 1466585',4550.00,0.00,0.00,7.00,266.00,'2022-04-25 14:27:08','',''),(2619120,'1','201','1037',478,'Retail Sale Id 1466585',4550.00,0.00,0.00,7.00,266.00,'2022-04-25 14:27:08','',''),(2619121,'1','201','1037',478,'Retail Sale Id 1466586',2002.00,0.00,0.00,3.08,117.04,'2022-04-25 14:28:09','',''),(2619122,'1','201','1037',478,'Retail Sale Id 1466587',2502.50,0.00,0.00,3.85,146.30,'2022-04-25 14:37:22','',''),(2619123,'1','201','1037',478,'Retail Sale Id 1466588',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 15:09:17','',''),(2619124,'1','201','1037',478,'Retail Sale Id 1466589',31000.00,0.00,0.00,50.00,400.00,'2022-04-25 15:10:18','',''),(2619125,'1','201','1037',478,'Retail Sale Id 1466590',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 15:28:15','',''),(2619126,'1','201','1037',478,'Retail Sale Id 1466591',3003.00,0.00,0.00,4.62,175.56,'2022-04-25 15:43:51','',''),(2619127,'1','201','1037',478,'Retail Sale Id 1466592',7000.50,0.00,0.00,10.77,409.26,'2022-04-25 15:44:54','',''),(2619128,'1','201','1037',478,'Retail Sale Id 1466593',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 15:46:46','',''),(2619129,'1','201','1037',478,'Retail Sale Id 1466593',4550.00,0.00,0.00,7.00,266.00,'2022-04-25 15:46:46','',''),(2619130,'1','201','1037',478,'Retail Sale Id 1466593',8125.00,0.00,0.00,12.50,475.00,'2022-04-25 15:46:46','',''),(2619131,'1','201','1037',478,'Retail Sale Id 1466594',650.00,0.00,0.00,1.00,38.00,'2022-04-25 16:01:02','',''),(2619132,'1','201','1037',478,'Retail Sale Id 1466595',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 16:02:13','',''),(2619133,'1','201','1037',478,'Retail Sale Id 1466596',3003.00,0.00,0.00,4.62,175.56,'2022-04-25 16:03:21','',''),(2619134,'1','201','1037',478,'Retail Sale Id 1466597',1300.00,0.00,0.00,2.00,76.00,'2022-04-25 16:19:58','',''),(2619135,'1','201','1037',478,'Retail Sale Id 1466598',2801.50,0.00,0.00,4.31,163.78,'2022-04-25 16:30:48','',''),(2619136,'1','201','1037',478,'Retail Sale Id 1466599',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 16:37:51','',''),(2619137,'1','201','1037',478,'Retail Sale Id 1466600',3997.50,0.00,0.00,6.15,233.70,'2022-04-25 16:38:58','',''),(2619138,'1','201','1037',478,'Retail Sale Id 1466601',2600.00,0.00,0.00,4.00,152.00,'2022-04-25 16:44:29','',''),(2619139,'1','201','1037',478,'Retail Sale Id 1466602',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 16:49:29','',''),(2619140,'1','201','1037',478,'Retail Sale Id 1466603',1300.00,0.00,0.00,2.00,76.00,'2022-04-25 16:55:34','',''),(2619141,'1','201','1037',478,'Retail Sale Id 1466604',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 16:56:35','',''),(2619142,'1','201','1037',478,'Retail Sale Id 1466605',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 16:58:44','',''),(2619143,'1','201','1037',478,'Retail Sale Id 1466606',8125.00,0.00,0.00,12.50,475.00,'2022-04-25 17:00:12','',''),(2619144,'1','201','1037',478,'Retail Sale Id 1466607',650.00,0.00,0.00,1.00,38.00,'2022-04-25 17:01:01','',''),(2619145,'1','201','1037',478,'Retail Sale Id 1466608',650.00,0.00,0.00,1.00,38.00,'2022-04-25 17:03:15','',''),(2619146,'1','201','1037',478,'Retail Sale Id 1466609',2502.50,0.00,0.00,3.85,146.30,'2022-04-25 17:06:13','',''),(2619147,'1','201','1037',478,'Retail Sale Id 1466610',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 17:06:56','',''),(2619148,'1','201','1037',478,'Retail Sale Id 1466611',8125.00,0.00,0.00,12.50,475.00,'2022-04-25 17:08:08','',''),(2619149,'1','201','1037',478,'Retail Sale Id 1466612',3250.00,0.00,0.00,5.00,190.00,'2022-04-25 17:09:40','',''),(2619150,'1','201','1037',478,'Retail Sale Id 1466613',4550.00,0.00,0.00,7.00,266.00,'2022-04-25 17:15:26','',''),(2619151,'1','201','1037',478,'Retail Sale Id 1466614',2600.00,0.00,0.00,4.00,152.00,'2022-04-25 17:21:36','',''),(2619152,'1','201','1037',478,'Retail Sale Id 1466615',975.00,0.00,0.00,1.50,57.00,'2022-04-25 17:31:01','',''),(2619153,'1','201','1037',478,'Retail Sale Id 1466616',1300.00,0.00,0.00,2.00,76.00,'2022-04-25 17:33:10','',''),(2619154,'1','201','1037',478,'Retail Sale Id 1466617',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 17:34:24','',''),(2619155,'1','201','1037',478,'Retail Sale Id 1466618',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 17:35:17','',''),(2619156,'1','201','1037',478,'Retail Sale Id 1466619',1300.00,0.00,0.00,2.00,76.00,'2022-04-25 17:37:55','',''),(2619157,'1','201','1037',478,'Retail Sale Id 1466620',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 17:46:21','',''),(2619158,'1','201','1037',478,'Retail Sale Id 1466621',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 17:48:57','',''),(2619159,'1','201','1037',478,'Retail Sale Id 1466622',1001.00,0.00,0.00,1.54,58.52,'2022-04-25 17:51:35','',''),(2619160,'1','201','1037',478,'Retail Sale Id 1466623',6500.00,0.00,0.00,10.00,380.00,'2022-04-25 17:56:22','',''),(2619161,'1','201','1037',478,'Retail Sale Id 1466625',3900.00,0.00,0.00,6.00,228.00,'2022-04-25 18:01:42','',''),(2619162,'1','201','1037',478,'Retail Sale Id 1466626',1950.00,0.00,0.00,3.00,114.00,'2022-04-25 18:05:44','',''),(2619163,'1','201','1037',478,'Retail Sale Id 1466626',4550.00,0.00,0.00,7.00,266.00,'2022-04-25 18:05:44','',''),(2619164,'1','201','1037',478,'Retail Sale Id 1466627',1300.00,0.00,0.00,2.00,76.00,'2022-04-25 18:12:35','',''),(2619165,'1','201','1037',478,'Retail Sale Id 1466628',1001.00,0.00,0.00,1.54,58.52,'2022-04-25 18:25:11','',''),(2619166,'1','201','1037',478,'Return of Retail Sale Id 1466628',0.00,1001.00,1.54,0.00,-58.52,'2022-04-25 18:39:07','',''),(2619167,'1','201','1037',478,'Retail Sale Id 1466629',1001.00,0.00,0.00,1.54,58.52,'2022-04-25 18:41:13','',''),(2619168,'1','201','1037',478,'Retail Sale Id 1466630',3900.00,0.00,0.00,6.00,228.00,'2022-04-26 08:18:15','',''),(2619169,'1','201','1037',478,'Retail Sale Id 1466631',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 08:27:39','',''),(2619170,'1','201','1037',478,'Retail Sale Id 1466632',1001.00,0.00,0.00,1.54,58.52,'2022-04-26 08:43:57','',''),(2619171,'1','201','1037',478,'Retail Sale Id 1466633',3250.00,0.00,0.00,5.00,190.00,'2022-04-26 08:56:35','',''),(2619172,'1','201','1037',478,'Retail Sale Id 1466634',1300.00,0.00,0.00,2.00,76.00,'2022-04-26 09:02:24','',''),(2619173,'1','201','1037',478,'Retail Sale Id 1466635',3900.00,0.00,0.00,6.00,228.00,'2022-04-26 09:20:02','',''),(2619174,'1','201','1037',478,'Retail Sale Id 1466636',2301.00,0.00,0.00,3.54,134.52,'2022-04-26 09:25:36','',''),(2619175,'1','201','1037',478,'Retail Sale Id 1466637',4225.00,0.00,0.00,6.50,247.00,'2022-04-26 09:27:13','',''),(2619176,'1','201','1037',478,'Retail Sale Id 1466638',1001.00,0.00,0.00,1.54,58.52,'2022-04-26 09:45:03','',''),(2619177,'1','201','1037',478,'Retail Sale Id 1466639',3900.00,0.00,0.00,6.00,228.00,'2022-04-26 09:57:00','',''),(2619178,'1','201','1037',478,'Retail Sale Id 1466640',4550.00,0.00,0.00,7.00,266.00,'2022-04-26 10:04:54','',''),(2619179,'1','201','1037',478,'Retail Sale Id 1466641',4998.50,0.00,0.00,7.69,292.22,'2022-04-26 10:10:30','',''),(2619180,'1','201','1037',478,'Retail Sale Id 1466642',3250.00,0.00,0.00,5.00,190.00,'2022-04-26 10:26:15','',''),(2619181,'1','201','1037',478,'Retail Sale Id 1466643',3250.00,0.00,0.00,5.00,190.00,'2022-04-26 10:46:32','',''),(2619182,'1','201','1037',478,'Retail Sale Id 1466644',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 11:11:58','',''),(2619183,'1','201','1037',478,'Retail Sale Id 1466645',8125.00,0.00,0.00,12.50,475.00,'2022-04-26 11:36:32','',''),(2619184,'1','201','1037',478,'Retail Sale Id 1466646',6500.00,0.00,0.00,10.00,380.00,'2022-04-26 11:45:07','',''),(2619185,'1','201','1037',478,'Retail Sale Id 1466647',8125.00,0.00,0.00,12.50,475.00,'2022-04-26 11:58:17','',''),(2619186,'1','201','1037',478,'Retail Sale Id 1466648',3900.00,0.00,0.00,6.00,228.00,'2022-04-26 12:15:48','',''),(2619187,'1','201','1037',478,'Retail Sale Id 1466649',2600.00,0.00,0.00,4.00,152.00,'2022-04-26 12:22:45','',''),(2619188,'1','201','1037',478,'Retail Sale Id 1466650',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 12:31:02','',''),(2619189,'1','201','1037',478,'Retail Sale Id 1466651',3250.00,0.00,0.00,5.00,190.00,'2022-04-26 12:37:29','',''),(2619190,'1','201','1037',478,'Retail Sale Id 1466652',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 12:42:11','',''),(2619191,'1','201','1037',478,'Retail Sale Id 1466653',8125.00,0.00,0.00,12.50,475.00,'2022-04-26 12:49:36','',''),(2619192,'1','201','1037',478,'Retail Sale Id 1466654',1703.00,0.00,0.00,2.62,99.56,'2022-04-26 12:50:23','',''),(2619193,'1','201','1037',478,'Retail Sale Id 1466655',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 13:03:54','',''),(2619194,'1','201','1037',478,'Retail Sale Id 1466656',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 13:19:27','',''),(2619195,'1','201','1037',478,'Retail Sale Id 1466657',8125.00,0.00,0.00,12.50,475.00,'2022-04-26 13:21:20','',''),(2619196,'1','201','1037',478,'Retail Sale Id 1466658',3250.00,0.00,0.00,5.00,190.00,'2022-04-26 13:27:20','',''),(2619197,'1','201','1037',478,'Retail Sale Id 1466659',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 13:38:34','',''),(2619198,'1','201','1037',478,'Retail Sale Id 1466660',7440.00,0.00,0.00,12.00,96.00,'2022-04-26 13:42:00','',''),(2619199,'1','201','1037',478,'Retail Sale Id 1466661',650.00,0.00,0.00,1.00,38.00,'2022-04-26 13:44:26','',''),(2619200,'1','201','1037',478,'Return of Retail Sale Id 1466656',0.00,1950.00,3.00,0.00,-114.00,'2022-04-26 13:48:38','',''),(2619201,'1','201','1037',478,'Retail Sale Id 1466662',1885.00,0.00,0.00,2.90,110.20,'2022-04-26 13:51:31','',''),(2619202,'1','201','1037',478,'Retail Sale Id 1466663',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 13:57:19','',''),(2619203,'1','201','1037',478,'Retail Sale Id 1466664',3900.00,0.00,0.00,6.00,228.00,'2022-04-26 14:14:53','',''),(2619204,'1','201','1037',478,'Retail Sale Id 1466665',6500.00,0.00,0.00,10.00,380.00,'2022-04-26 14:28:15','',''),(2619205,'1','201','1037',478,'Retail Sale Id 1466666',2600.00,0.00,0.00,4.00,152.00,'2022-04-26 14:36:50','',''),(2619206,'1','201','1037',478,'Retail Sale Id 1466667',2600.00,0.00,0.00,4.00,152.00,'2022-04-26 14:39:50','',''),(2619207,'1','201','1037',478,'Retail Sale Id 1466668',2600.00,0.00,0.00,4.00,152.00,'2022-04-26 14:56:15','',''),(2619208,'1','201','1037',478,'Retail Sale Id 1466668',8125.00,0.00,0.00,12.50,475.00,'2022-04-26 14:56:15','',''),(2619209,'1','201','1037',478,'Retail Sale Id 1466669',5200.00,0.00,0.00,8.00,304.00,'2022-04-26 15:01:51','',''),(2619210,'1','201','1037',478,'Retail Sale Id 1466670',4550.00,0.00,0.00,7.00,266.00,'2022-04-26 15:08:08','',''),(2619211,'1','201','1037',478,'Retail Sale Id 1466671',4550.00,0.00,0.00,7.00,266.00,'2022-04-26 15:21:27','',''),(2619212,'1','201','1037',478,'Retail Sale Id 1466672',3900.00,0.00,0.00,6.00,228.00,'2022-04-26 15:46:12','',''),(2619213,'1','201','1037',478,'Retail Sale Id 1466673',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 15:59:05','',''),(2619214,'1','201','1037',478,'Retail Sale Id 1466674',7800.00,0.00,0.00,12.00,456.00,'2022-04-26 16:05:10','',''),(2619215,'1','201','1037',478,'Retail Sale Id 1466675',1001.00,0.00,0.00,1.54,58.52,'2022-04-26 16:07:14','',''),(2619216,'1','201','1037',478,'Retail Sale Id 1466676',1300.00,0.00,0.00,2.00,76.00,'2022-04-26 16:15:13','',''),(2619217,'1','201','1037',478,'Retail Sale Id 1466677',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 16:15:59','',''),(2619218,'1','201','1037',478,'Retail Sale Id 1466678',8125.00,0.00,0.00,12.50,475.00,'2022-04-26 16:17:53','',''),(2619219,'1','201','1037',478,'Retail Sale Id 1466679',3900.00,0.00,0.00,6.00,228.00,'2022-04-26 16:23:05','',''),(2619220,'1','201','1037',478,'Retail Sale Id 1466680',6500.00,0.00,0.00,10.00,380.00,'2022-04-26 16:25:23','',''),(2619221,'1','201','1037',478,'Retail Sale Id 1466681',650.00,0.00,0.00,1.00,38.00,'2022-04-26 16:28:44','',''),(2619222,'1','201','1037',478,'Retail Sale Id 1466682',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 16:33:19','',''),(2619223,'1','201','1037',478,'Retail Sale Id 1466683',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 16:36:05','',''),(2619224,'1','201','1037',478,'Retail Sale Id 1466684',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 16:37:18','',''),(2619225,'1','201','1037',478,'Retail Sale Id 1466685',8125.00,0.00,0.00,12.50,475.00,'2022-04-26 16:42:29','',''),(2619226,'1','201','1037',478,'Retail Sale Id 1466686',6500.00,0.00,0.00,10.00,380.00,'2022-04-26 16:58:13','',''),(2619227,'1','201','1037',478,'Retail Sale Id 1466686',7800.00,0.00,0.00,12.00,456.00,'2022-04-26 16:58:13','',''),(2619228,'1','201','1037',478,'Retail Sale Id 1466687',3250.00,0.00,0.00,5.00,190.00,'2022-04-26 16:59:24','',''),(2619229,'1','201','1037',478,'Retail Sale Id 1466689',3900.00,0.00,0.00,6.00,228.00,'2022-04-26 17:05:17','',''),(2619230,'1','201','1037',478,'Retail Sale Id 1466690',1625.00,0.00,0.00,2.50,95.00,'2022-04-26 17:08:00','',''),(2619231,'1','201','1037',478,'Retail Sale Id 1466690',6825.00,0.00,0.00,10.50,399.00,'2022-04-26 17:08:00','',''),(2619232,'1','201','1037',478,'Retail Sale Id 1466691',3250.00,0.00,0.00,5.00,190.00,'2022-04-26 17:13:04','',''),(2619233,'1','201','1037',478,'Retail Sale Id 1466692',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 17:15:00','',''),(2619234,'1','201','1037',478,'Retail Sale Id 1466693',7501.00,0.00,0.00,11.54,438.52,'2022-04-26 17:18:17','',''),(2619235,'1','201','1037',478,'Retail Sale Id 1466694',1501.50,0.00,0.00,2.31,87.78,'2022-04-26 17:19:43','',''),(2619236,'1','201','1037',478,'Retail Sale Id 1466695',3900.00,0.00,0.00,6.00,228.00,'2022-04-26 17:26:33','',''),(2619237,'1','201','1037',478,'Retail Sale Id 1466696',5999.50,0.00,0.00,9.23,350.74,'2022-04-26 17:29:37','',''),(2619238,'1','201','1037',478,'Retail Sale Id 1466698',8125.00,0.00,0.00,12.50,475.00,'2022-04-26 17:33:45','',''),(2619239,'1','201','1037',478,'Retail Sale Id 1466699',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 17:34:46','',''),(2619240,'1','201','1037',478,'Retail Sale Id 1466700',1053.00,0.00,0.00,1.62,61.56,'2022-04-26 17:35:26','',''),(2619241,'1','201','1037',478,'Retail Sale Id 1466701',1001.00,0.00,0.00,1.54,58.52,'2022-04-26 17:36:06','',''),(2619242,'1','201','1037',478,'Retail Sale Id 1466702',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 17:38:32','',''),(2619243,'1','201','1037',478,'Retail Sale Id 1466703',650.00,0.00,0.00,1.00,38.00,'2022-04-26 17:39:57','',''),(2619244,'1','201','1037',478,'Retail Sale Id 1466703',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 17:39:57','',''),(2619245,'1','201','1037',478,'Retail Sale Id 1466704',1001.00,0.00,0.00,1.54,58.52,'2022-04-26 17:41:51','',''),(2619246,'1','201','1037',478,'Retail Sale Id 1466705',8125.00,0.00,0.00,12.50,475.00,'2022-04-26 17:44:00','',''),(2619247,'1','201','1037',478,'Retail Sale Id 1466706',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 17:46:21','',''),(2619248,'1','201','1037',478,'Retail Sale Id 1466707',3250.00,0.00,0.00,5.00,190.00,'2022-04-26 17:56:25','',''),(2619249,'1','201','1037',478,'Retail Sale Id 1466708',650.00,0.00,0.00,1.00,38.00,'2022-04-26 17:59:52','',''),(2619250,'1','201','1037',478,'Retail Sale Id 1466709',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 18:05:25','',''),(2619251,'1','201','1037',478,'Retail Sale Id 1466710',1950.00,0.00,0.00,3.00,114.00,'2022-04-26 18:12:07','',''),(2619252,'1','201','1037',478,'Retail Sale Id 1466711',650.00,0.00,0.00,1.00,38.00,'2022-04-26 18:27:28','',''),(2619253,'1','201','1037',478,'Return of Retail Sale Id 1466710',0.00,1950.00,3.00,0.00,-114.00,'2022-04-26 18:43:15','',''),(2619254,'1','201','1037',478,'Retail Sale Id 1466712',1573.00,0.00,0.00,2.42,91.96,'2022-04-26 18:43:52','',''),(2619255,'1','201','1037',478,'Retail Sale Id 1466713',1300.00,0.00,0.00,2.00,76.00,'2022-04-27 07:31:44','',''),(2619256,'1','201','1037',478,'Retail Sale Id 1466714',1950.00,0.00,0.00,3.00,114.00,'2022-04-27 07:34:46','',''),(2619257,'1','201','1037',478,'Retail Sale Id 1466715',8125.00,0.00,0.00,12.50,475.00,'2022-04-27 08:09:01','',''),(2619258,'1','201','1037',478,'Retail Sale Id 1466716',650.00,0.00,0.00,1.00,38.00,'2022-04-27 08:47:57','',''),(2619259,'1','201','1037',478,'Retail Sale Id 1466717',4225.00,0.00,0.00,6.50,247.00,'2022-04-27 09:38:33','',''),(2619260,'1','201','1037',478,'Retail Sale Id 1466718',1950.00,0.00,0.00,3.00,114.00,'2022-04-27 09:43:16','',''),(2619261,'1','201','1037',478,'Retail Sale Id 1466719',8125.00,0.00,0.00,12.50,475.00,'2022-04-27 09:46:12','',''),(2619262,'1','201','1037',478,'Retail Sale Id 1466720',3900.00,0.00,0.00,6.00,228.00,'2022-04-27 09:58:02','',''),(2619263,'1','201','1037',478,'Retail Sale Id 1466721',3003.00,0.00,0.00,4.62,175.56,'2022-04-27 09:59:00','',''),(2619264,'1','201','1037',478,'Retail Sale Id 1466722',5200.00,0.00,0.00,8.00,304.00,'2022-04-27 10:07:59','',''),(2619265,'1','201','1037',478,'Retail Sale Id 1466723',2600.00,0.00,0.00,4.00,152.00,'2022-04-27 10:22:07','',''),(2619266,'1','201','1037',478,'Retail Sale Id 1466724',2600.00,0.00,0.00,4.00,152.00,'2022-04-27 10:36:20','',''),(2619267,'1','201','1037',478,'Retail Sale Id 146