-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_200
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_200`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_200` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_200`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4073 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3951,400125,'',0,'22','1','200','PURCHASES','','2021-12-04 10:02:37',5,0.00,0.00,'','479','2021-12-04 10:02:37','479',0,0),(3952,20060,'',0,'20','1','200','SALES','','2021-12-04 10:02:57',5,0.00,0.00,'','479','2021-12-04 10:02:57','479',0,0),(3953,40060,'',0,'6.1','1','200','CASH','','2021-12-04 10:03:12',5,0.00,0.00,'','479','2021-12-04 10:03:12','479',0,0),(3954,400355,'',0,'24','1','200','SALARIES & WAGES','','2021-12-04 10:03:35',5,0.00,0.00,'','479','2021-12-04 10:03:35','479',0,0),(3955,400356,'',0,'24','1','200','PURCHASES','','2021-12-04 10:03:55',5,0.00,0.00,'','479','2021-12-04 10:03:55','479',0,0),(3956,400690,'',0,'2','1','200','ZB(LPG)1014471475','','2021-12-04 10:04:31',5,0.00,0.00,'','479','2021-12-04 10:04:31','479',0,0),(3957,400691,'',0,'2','1','200','FB(IBAL)2023855223','','2021-12-04 10:04:46',5,0.00,0.00,'','479','2021-12-04 10:04:46','479',0,0),(3958,400692,'',0,'2','1','200','E-BILLS 1015372548','','2021-12-04 10:05:21',5,0.00,0.00,'','479','2021-12-04 10:05:21','479',0,0),(3959,400693,'',0,'2','1','200','E-BILLS  IBAL 1015372548','','2021-12-04 10:06:16',5,0.00,0.00,'','479','2021-12-04 10:06:16','479',0,0),(3960,400694,'',0,'2','1','200','UNITY BANK-0024061656','','2021-12-04 10:06:51',5,0.00,0.00,'','479','2021-12-04 10:06:51','479',0,0),(3961,400695,'',0,'2','1','200','UBA YOLA-1021398099','','2021-12-04 10:07:16',5,0.00,0.00,'','479','2021-12-04 10:07:16','479',0,0),(3962,400696,'',0,'2','1','200','FID POS COLLECTION-5620141491','','2021-12-04 10:07:32',5,0.00,0.00,'','479','2021-12-04 10:07:32','479',0,0),(4069,400741,'',0,'2','1','200','ECB (E-BILLS): 258300104','','2022-01-04 20:20:54',5,0.00,0.00,'','479','2022-01-04 20:20:54','479',0,0),(4070,400742,'',0,'2','1','200','ZNB (POS) COLLECTION :10159653','','2022-01-04 20:23:20',5,0.00,0.00,'','479','2022-01-04 20:23:20','479',0,0),(4071,400743,'',0,'2','1','200','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:37:22',5,0.00,0.00,'','792','2023-02-20 14:37:22','792',0,0),(4072,400744,'',0,'2','1','200','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:39:30',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:56:11','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4274 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (3947,'','1','200','E.U GAS','EMMANUEL UKAIGWE','08065154400','hgaya@aaraninigeria.com','KADUNA','KADUNA','NO:43 SABO ROAD KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-04 12:12:55',5,'724','2022-09-22 17:56:15','724'),(3949,'','1','200','AL\'IHSAN GAS','SABIU UMAR','0706299342','@gmail.com','KADUNA','KADUNA','KAWO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-05 13:07:45',5,'724','2021-12-16 16:26:30','724'),(3950,'','1','200','SHUAIBU GAS','SHUAIBU ISAH','08024966423','@gmail.com','KADUNA','KADUNA','kato road','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-06 07:48:42',5,'724','2021-12-10 20:50:48','724'),(3952,'','1','200','AA RIDER GAS','MUSTAPHA A BALA','08085692187','@gmail.com','KADUNA','KADUNA','HAYAN NAIYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-06 07:55:45',5,'724','2021-12-06 07:55:45','724'),(3958,'','1','200','HARUNA GAS','HARUNA TOMUS','07035944990','@gmail.com','KADUNA','KADUNA','MALALI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-06 10:41:42',5,'724','2021-12-06 10:41:42','724'),(3959,'','1','200','ISHAQ GAS','ISHAQ MUHAMMAD','08034323937','@gmail.com','KADUNA','KADUNA','NO 82 MASSACI STREET, SABON KAWO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-06 11:20:01',5,'724','2021-12-06 11:20:01','724'),(3960,'','1','200','HNS GAS','TANKO BALA MUSA','08024987511','@gmail.com','KADUNA','KADUNA','KADORE GIDAN JAMILA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-06 11:46:41',5,'724','2021-12-06 11:46:41','724'),(3961,'','1','200','ADAMCY GAS','ADAMU ','08038157259','@gmail.com','KADUNA','KADUNA','SABON BIRNI KAWO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-06 14:59:41',5,'724','2022-02-01 10:25:26','724'),(3964,'','1','200','EXCLUSIVE GAS','ASIYA HASSAN','08147004440','hgaya@aaranonigerian.com','KADUNA','KADUNA','PTF ROAD HAYIN BANKI','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-07 08:16:42',5,'724','2021-12-14 09:56:45','724'),(3965,'','1','200','AMD GAS','ANAS MAIWADA','08130844323','hgaya@aaranonigerian.com','KADUNA','KADUNA','DAN DAURA KAURU LOCAL GOVERNMENT KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-07 10:05:11',5,'724','2022-11-22 13:56:39','724'),(3966,'','1','200','YUMOH GAS','MUSA YAKUBU','08064786043','hgaya@aaranonigerian.com','KADUNA','KADUNA','NO;1 KUBO ROAD ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-07 10:08:25',5,'724','2021-12-07 10:08:25','724'),(3967,'','1','200','BALA KAWO GAS','BALA KAWO','08064284203','hgaya@aaranonigerian.com','KADUNA','KADUNA','SABON BIRNI STREET SABON KAWO','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-12-07 10:29:57',5,'724','2021-12-07 10:29:57','724'),(3968,'','1','200','JAMILU GAS','JAMILU ISA','08139699932','hgaya@aaranonigerian.com','KADUNA','KADUNA','BADARAWA GWARU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-07 11:14:28',5,'724','2021-12-07 11:14:28','724'),(3971,'','1','200','IBRAHIM GAS','IBRAHIM MUHAMMAD','08100100846','hgaya@aaranonigerian.com','KADUNA','KADUNA','MAKARFI ROAD','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-07 12:42:10',5,'724','2021-12-07 12:42:10','724'),(3972,'','1','200','IBRAHIM AA GAS','IBRAHIM ','08100100846','hgaya@aaranonigerian.com','KADUNA','KADUNA','MAKARFI ROAD ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-07 13:12:22',5,'724','2022-02-06 15:30:32','724'),(3975,'','1','200','MAA OIL AND GAS','ABUBAKAR AHMAD','08035971125','hgaya@aaranonigerian.com','KADUNA','KADUNA','BADARAWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-07 17:12:40',5,'724','2021-12-07 17:12:40','724'),(3977,'','1','200','FEMI ADESHINA GAS','FEMI ADESHINA ','08137479592','hgaya@aaranonigeria.com','KADUNA ','KADUNA','NO:28 SHAGARI ROAD OPPOSITE LINE SARKI NARAYI KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-08 09:12:19',5,'724','2022-09-19 16:02:56','724'),(3978,'','1','200','HATAKIZMAN GAS','INUSA HARUNA','08035864464','hgaya@aaranonigeria.com','KADUNA','KADUNA','LAMIDO ROAD','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-08 09:48:51',5,'724','2022-01-20 14:22:10','724'),(3979,'','1','200','YUSMAN GAS','YUSUF USMAN','08068048792','hgaya@aaranonigeria.com','KADUNA','KADUNA','NEW NDC LAYOUT','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-08 10:04:37',5,'724','2021-12-08 10:04:37','724'),(3981,'','1','200','EMMY GAS','EMMANUEL SABO','07068529644','hgaya@aaranonigerian.com','KADUNA','KADUNA','NO:100 ISAH KAITA ROAD KADUNA','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-08 12:31:04',5,'724','2021-12-08 12:31:04','724'),(3983,'','1','200','DOGO GAS','SALISU USMAN','09065134143','hgaya@aaranonigerian.com','KADUNA','KADUNA','UNGUWAR DOSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-08 14:05:25',5,'724','2022-09-26 17:20:44','724'),(3984,'','1','200','LAWANDI GAS','LAWAN SAMINU','08032142224','hgaya@aaranonigerian.com','KADUNA','KADUNA','PA3 IBRAHIM TAIWO ROAD KADUNA','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-08 15:56:24',5,'724','2021-12-08 15:56:24','724'),(3985,'','1','200','M K GAS','ISMAIL GAS','08026703325','hgaya@aaranonigerian.com','KADUNA','KADUNA','AJDHDUFU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-08 16:11:10',5,'724','2021-12-08 16:11:10','724'),(3986,'','1','200','MIDAS ISLAND GAS','MAJOR MC JOSEP','08068068825','saintodiamond@gmail.com','KADUNA','KADUNA','1DIV BARRACK  NIGERIAN ARMY','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-08 17:08:23',5,'724','2022-09-23 11:35:12','724'),(3988,'','1','200','AA GATA OIL & GAS','AHMAD ADAMU SULEIMAN','08038216956','hgaya@aaranonigeria.com','KADUNA','KADUNA','NO: 19B GARBA KOKO ROAD NDC KAWO KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-09 11:18:44',5,'724','2022-08-25 15:58:55','724'),(3989,'','1','200','A Y GAS','AYO BABALOLA','08028197218','babalolaayo76@gmail.com','KADUNA','KADUNA','ALKALI ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-09 11:28:03',5,'724','2021-12-09 11:28:03','724'),(3990,'','1','200','IBRAHIM S GAS','SURAJO IBRAHIM','08131487873','hgaya@aaranonigerian.com','KADUNA','KADUNA','BISHARA BY MAKARFI ROAD KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-09 11:54:08',5,'724','2022-08-31 10:46:54','724'),(3991,'','1','200','IBRAHIM I GAS','IBRAHIM LAWAN','08032231769','hgaya@aaranonigerian.com','KADUNA','KADUNA','MALALI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-09 11:56:39',5,'724','2021-12-09 11:56:39','724'),(3992,'','1','200','NAGURU GAS','SURAJO IBRAHIM','08131487873','elsuraj212@gmail.com','KADUNA','KADUNA','gubichi road','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-09 12:22:00',5,'724','2021-12-09 12:22:00','724'),(3993,'','1','200','HIKMAT GAS','ABDULMAJEED A OWENIYI','08036053085','hikmatpetroleum@gmail.com','KADUNA','KADUNA','no 10 amurtala muhammad way kabala west, kaduna','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-09 14:23:39',5,'724','2021-12-09 14:23:39','724'),(3994,'','1','200','ABDULAZIZ GAS','ABDULAZIZ TAHIR','09097498522','hgaya@aaranonigeria.com','KADUNA','KADUNA','NDC UNGUWAN KAJI','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-09 15:34:04',5,'724','2021-12-09 15:34:04','724'),(3996,'','1','200','RAJAB GAS','RAJAB','08039336265','hgaya@aaranonigerian.com','KADUNA','KADUNA','RAFIN GUZA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-10 08:25:59',5,'724','2021-12-10 08:25:59','724'),(4000,'','1','200','CJL GAS','CHIJIOKE MBANEFO','08037873248','cjlgases2015@gmail.com','KADUNA SOUTH','KADUNA','No. 60 AKALI ROAD','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-10 12:50:29',5,'724','2022-04-04 17:37:58','724'),(4002,'','1','200','ISMAIL GAS','ISMAIL ISAH','08026702325','hgaya@aaranonigeria.com','KADUNA','KADUNA','NO. 12 ALKHAIL ROAD','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-11 08:40:01',5,'724','2021-12-11 08:40:01','724'),(4003,'','1','200','NAZIFI GAS','MOHAMMED NAZIFI','07088831031','hgaya@aaranonigeria.com','KADUNA','KADUNA','YAKUBU BALA ROAD','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-11 09:25:34',5,'724','2021-12-11 09:25:34','724'),(4004,'','1','200','KUNLE GAS','KUNLE MIKEL','09166073422','hgaya@aaranonigeria.com','KADUNA','KADUNA','ALKALI ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-11 09:27:11',5,'724','2023-03-09 15:28:12','724'),(4005,'','1','200','AHMAD GAS','AHMAD RUFAI','08120242892','hgaya@aaranonigeria.com','KADUNA','KADUNA','HADEJIA ROAD, MALALI GABAS','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-11 09:32:51',5,'724','2021-12-11 09:32:51','724'),(4008,'','1','200','FAREED GAS','ISA MUHAMMAD','07066595732','isahfareed80@gmail.com','KADUNA','KADUNA','NARIYA KABALA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-11 13:11:08',5,'724','2021-12-11 13:11:08','724'),(4011,'','1','200','GAYE GAS','MUSA HUSSAINI','07068743204','hgaya@aaranonigerian.com','KADUNA','KADUNA','RAFIN GUZA ','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-12 07:57:08',5,'724','2021-12-12 07:57:08','724'),(4012,'','1','200','SAGIR GAS','SAGIR HALADU','08024971015','hgaya@aaranonigerian.com','KADUNA','KADUNA','DANBUSHIYA','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-12 08:10:29',5,'724','2021-12-12 08:10:29','724'),(4014,'','1','200','KOBAG VENTURES NIG','ABDULLATEEF SULEIMAN','08035982138','hgaya@aaranonigerian.com','KADUNA','KADUNA','NO;173 COLLEGE ROAD UNGUWAN DOSA KAWO KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-12 11:55:46',5,'724','2022-04-28 18:44:31','724'),(4015,'','1','200','J.A GASES','JOSEPH ABBA','08036420200','hgaya@aaranonigerian.com','KADUNA','KADUNA','NO;57 ALKALI ROAD','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-12 12:26:28',5,'724','2021-12-12 12:26:28','724'),(4026,'','1','200','YTK GAS','UZAIRU USMAN','07044442924','hgaya@aaranonigeria.com','KADUNA','KADUNA','NUMBER 12 ABAKWA, KADUNA','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-14 12:46:21',5,'724','2021-12-14 12:46:21','724'),(4028,'','1','200','ANAS GAS','ABBA ANAS','08038104196','hgaya@aaranonigeria.com','KADUNA','KADUNA','ZANGO ROAD, UNGUWA MUAZU','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-15 10:48:34',5,'724','2021-12-15 10:48:34','724'),(4029,'','1','200','BILAL GAS','BILAL MOHAMMAD','09066664143','hgaya@aaranonigeria.com','KADUNA','KADUNA','UNGUWA DOSA, KARAYE JUNCTION','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-15 12:04:13',5,'724','2021-12-15 12:04:13','724'),(4030,'','1','200','T.J GAS','TIJANI AHMED','08138507620','hgaya@aaranonigeria.com','KADUNA','KADUNA','DAGELE 1, UNGUWA RIMI, KADUNA','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-15 14:39:24',5,'724','2021-12-15 14:39:24','724'),(4031,'','1','200','KAMILU GAS','SULEIMAN SULEIMAN','08085334485','hgaya@aaranonigeria.com','KADUNA','KADUNA','DAGELE ONE, UGUWAN RIMI','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-15 14:40:37',5,'724','2021-12-15 14:40:37','724'),(4032,'','1','200','ASSADEEK GAS','MUDASSIR SADIQ','07034988934','hgaya@aaranonigeria.com','KADUNA','KADUNA','KABALA WEST','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-15 15:05:44',5,'724','2021-12-15 15:05:44','724'),(4039,'','1','200','AFRAH GAS INVESTIMENT','USMAN LAWAL','08063139923','hgaya@aaranonigeria.com','KADUNA','KADUNA','NO. C 16 BAMAKO ROAD ANGUWAN RIMI','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-16 11:12:24',5,'724','2021-12-16 11:12:24','724'),(4040,'','1','200','ANNUR GAS','NURA IBRAHIM','07033865047','hgaya@aaranonigeria.com','KADUNA','KADUNA','UNGUWAN RIMI FULANI ROAD','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-16 14:28:26',5,'724','2021-12-16 14:28:26','724'),(4041,'','1','200','QUARTER HOUSE GAS','YUSUF SOBA','08034323023','hgaya@aaranonigeria.com','KADUNA','KADUNA','NUMBER 2 OBALI ROAD, MALALI GRA','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-16 15:06:45',5,'724','2022-01-06 17:17:42','724'),(4045,'','1','200','LIGYARA GASES','SADA AUWAL','07038425286','hgaya@aaranonigeria.com','KADUNA','KADUNA','MANGWARAN AKWAI HAYIN NAIYA','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-17 14:22:31',5,'724','2022-08-24 12:29:35','724'),(4048,'','1','200','IBRAHIM MIYATI','IBRAHIM MIYETTI ALLAH','08030791113','hgaya@aaranonigeria.com','KADUNA','KADUNA','MAKARFI ROAD, BY MIYETTI ALLAH','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-18 15:19:32',5,'724','2021-12-18 15:19:32','724'),(4050,'','1','200','DENNIS GAS','DENNIS','08109585972','hgaya@aaranonigeria.com','KADUNA','KADUNA','ALKALI ROAD','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-19 11:20:10',5,'724','2021-12-19 11:20:10','724'),(4055,'','1','200','M. JAMIL GAS','JAMILU ABDULKAREEM','08134418282','hgaya@aaranonigeria.com','KADUNA','KADUNA','NO. BAMAKO ROAD, UGUWAN RIMI, KADUNA','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-19 14:15:38',5,'724','2021-12-19 14:15:38','724'),(4058,'','1','200','IMRAN OIL AND GAS','IMRAN MUHAMMAD','09012668667','hgaya@aaranonigeria.com','KADUNA','KADUNA','KABALAN DOKI BY GAMJI GATE','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-20 08:19:41',5,'724','2021-12-20 08:19:41','724'),(4061,'','1','200','BAB ATUNDE GAS','JOSHUA BABATUNDE','08033329349','hgaya@aaranonigeria.com','KADUNA','KADUNA','NO. 23 YAKUBU AVENUE, OFF ALKALI ROAD','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-20 16:55:55',5,'724','2021-12-20 16:55:55','724'),(4063,'','1','200','SATCOM GLOBAL VENTURES LIMITED','SA\'ID MUHAMMAD YUSUF','07036202047','hgaya@aaranonigeria.com','KADUNA','KADUNA','UNGUWAN MU\'AZU','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-21 09:49:21',5,'724','2021-12-21 09:49:21','724'),(4069,'','1','200','EMMANUEL GAS','EMMANUEL ISHAYA','08135274506','hgaya@aaranonigerian.com','KADUNA','KADUNA','NO:4 GHANA ROAD MALALI KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-21 15:39:50',5,'724','2022-11-16 11:51:32','724'),(4071,'','1','200','BEN GAS','BENSON OCHONOGWU','08165269793','hgaya@aaranonigeria.com','KADUNA','KADUNA','MALALI, KADUNA','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-22 08:58:54',5,'724','2021-12-22 08:58:54','724'),(4076,'','1','200','YUSUF AL\'IHSAN GAS','YUSUF HAMISU','07048098127','hgaya@aaranonigeria.com','KADUNA','KADUNA','NDC  KAMFANIN MAN KYADA BUS STOP','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-22 15:44:07',5,'724','2022-11-05 17:17:56','724'),(4079,'','1','200','ALFA GAS','SALIHU SALAHUDDEEN','08147812002','hgaya@aaranonigeria.com','KADUNA','KADUNA','EYE CENTRE ROAD MANDO','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-23 09:42:26',5,'724','2021-12-23 09:42:26','724'),(4081,'','1','200','CHAMPION GAS','CHAMPION','0806488200','hgaya@aaranonigeria.com','KADUNA','KADUNA','MALALI KADUNA','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-23 10:39:08',5,'724','2021-12-23 10:39:08','724'),(4083,'','1','200','PG GASES','TANIMU YAHAYA','08133337790','hgaya@aaranonigeria.com','KADUNA','KADUNA','FANBEGUWA ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-24 07:45:56',5,'724','2021-12-24 07:45:56','724'),(4084,'','1','200','ABDUL GAS','ABDULKADIR ISAH','08036145602','hgaya@aaranonigeria.com','KADUNA','KADUNA','KASUWAN BACCI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-24 08:13:07',5,'724','2023-01-21 15:54:05','724'),(4085,'','1','200','BRENDAN CEE GAS REFILL','OKAFOR LOVETH','08064773810','hgaya@aaranonigerian.com','KADUNA','KADUNA','NIGERIA AIRFORCE BASE KADUNA','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-24 09:05:03',5,'724','2021-12-24 09:05:03','724'),(4088,'','1','200','YELLOW GAS ','JOHN','08036155170','hgaya@aaranonigeria.com','KADUNA','KADUNA','ALKALI ROAD SHOPPING COMPLEX','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-25 11:10:36',5,'724','2021-12-25 11:10:36','724'),(4089,'','1','200','MK GAS KADUNA','MUSA IBRAHIM','08033441826','hgaya@aaranonigeria.com','KADUNA','KADUNA','NO. 2 MAIDUWA ROAD BARNAWA KADUNA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-25 11:32:09',5,'724','2021-12-25 11:32:09','724'),(4090,'','1','200','BAKARYA GAS','GODWIN ','07063339569','hgaya@aaranonigeria.com','KADUNA','KADUNA','NO. 05 MANI STREET KAKURE','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-25 14:23:31',5,'724','2021-12-25 14:23:31','724'),(4097,'','1','200','OPERATIONAL LOSS','KADUNA LPG','08067097606','hgaya@aaranonigeria.com','KADUNA NORTH','KADUNA STATE','KADUNA MONDO ROUNDABOUT','Nigeria',2000.00,0.00,0.00,'0000-00-00','2021-12-26 15:45:25',5,'724','2021-12-26 15:45:25','724'),(4100,'','1','200','BAWA GAS','MUSA BAWA','08028434542','hgaya@aaranonigeria.com','KADUNA','KADUNA','ALKALI ROAD','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-12-27 11:33:44',5,'724','2021-12-27 11:33:44','724'),(4110,'','1','200','KAMRU GLOBAL VENTURES','MAHMOUD MUSA HARUNA','08036867997','hgaya@aaranonigeria.com','KADUNA','KADUNA','NO 10 FAROUQ ABDULLAHI ROAD BARAKALLAHU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-29 14:12:04',5,'724','2022-03-23 09:09:33','724'),(4129,'','1','200','SULAIMAN GAS','Sulaiman Garba','08031177045','hgaya@aaranonigeria.com','Kaduna','Kaduna','No10 Kamaru Avenue Malali Kaduba','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-01-02 08:37:21',5,'724','2022-04-24 13:30:26','724'),(4140,'','1','200','AL-LUSIRAJ GAS','YUSUF SANI','08064155502','hgaya@aaranonigeria.com','KADUNA','KADUNA','GOVERNOR ROAD','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-01-05 09:59:29',5,'724','2022-01-05 09:59:29','724'),(4143,'','1','200','DOMINO\'S PIZZA KADUNA','ABDULLAHI ','07035306177','hgaya@aaranonigerian.com','KADUNA SOUTH','KADUNA','BARNAWA KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-05 19:14:44',5,'724','2022-01-05 19:19:13','724'),(4145,'','1','200','COACH GAS','Sulaiman Sani','08030818241','hgaya@aaranonigeria.com','KADUNA','KADUNA','MAKARFI ROAD, KADUNA','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-01-06 07:53:53',5,'724','2022-01-13 21:02:36','724'),(4150,'','1','200','ABWAS GAS','ABUBAKAR WASIU AJIBOLA','07033353883','hgaya@aaranonigerian.com','KADUNA','KADUNA','KABALA WEST OPP CELE JUMCTION BUS STOP KADUNA','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-01-06 15:41:32',5,'724','2022-01-06 15:41:32','724'),(4162,'','1','200','DAN MUSA GAS','ATAMA MUSA','08037053944','hgaya@aaranonigeria.com','KADUNA','KADUNA','ALKAIRI ROAD','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-01-09 13:35:18',5,'724','2022-01-09 13:35:18','724'),(4163,'','1','200','LIBERTY GAS','ALIYU YAKUBU','07031142045','hgaya@aaranonigeria.com','KADUNA NORTH','KADUNA','DANLADI ROAD, BY ISAH KIATA','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-01-09 15:21:43',5,'724','2022-01-09 15:21:43','724'),(4166,'','1','200','WAZIRI GAS','ABUBAKAR ISA','08054043330','hgaya@aaranonigerian.com','KADUNA','KADUNA','NO MAIN ROAD BADARAWA KADUNA','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-01-11 11:38:44',5,'724','2022-01-11 11:38:44','724'),(4171,'','1','200','CHAWAI GAS','MUSTAPHA AUWAL','08065297182','hgaya@aarano.com.ng','KADUNA','KADUNA','HADEJA ROAD COLLAGE ROAD','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-01-13 17:01:13',5,'724','2022-01-29 15:01:42','724'),(4176,'','1','200','MUHAMMAD GAS','ABDULQADIR MUHAMMAD','08146608230','hgaya@aarano.com.ng','KADUNA','KADUNA','SHOP NO. 05 MAI YAN-KUNNE PILAZA U/MU\'AZU KADUNA','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-01-16 10:58:00',5,'724','2022-04-04 17:32:18','724'),(4177,'','1','200','AMAN GAS','ABDULLAHI MOHAMMAD','07062196899','hgaya@aaranonigeria.com','KADUNA NORTH','KADUNA','HAYIN NA IYA','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-01-16 13:58:58',5,'724','2022-03-20 10:06:26','724'),(4179,'','1','200','OIL MONEY GAS','RABIU ABDULLAHI','07033835757','hgaya@aaranonigerian.com','KADUNA','KADUNA','UNGUWAN RIMI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-17 10:55:24',5,'724','2022-01-17 10:55:24','724'),(4186,'','1','200','MARVIS OIL & GAS LIMITED','JOHNSON OBANIBI','08137374733','hgaya@aaranonigerian.com','CHUKUN','KADUNA','NO:50 POST OFFICE ROAD, SABON TASHA KADUNA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-18 12:26:41',5,'724','2022-06-10 11:03:15','724'),(4199,'','1','200','SUNNY GAS','SUNDAY SANI','08034192700','hgaya@aarano.com.ng','KADUNA','KADUNA','ALKALI ROAD SHOPPING COMPLEX','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-01-19 12:22:34',5,'724','2022-01-19 12:22:34','724'),(4200,'','1','200','CLIFFORD GAS','CLIFFORD ','08024251134','hgaya@aarano.com.ng','KADUNA','KADUNA','NO. 060 HAJJ CAMP MANDO','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-01-19 13:50:20',5,'724','2022-01-19 13:50:20','724'),(4219,'','1','200','PAYLESS GAS','FIDELIS OTSOJA','08063452316','hgaya@aaranonigerian.com','KADUNA SOUTH','KADUNA','SHOP 18 BADARAWA COMPLEX BY 212 BAKERY KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-21 11:05:46',5,'724','2022-01-21 11:05:46','724'),(4227,'','1','200','ALEX GAS','ALIXIX HARRY','08135357300','hgaya@aarano.com.ng','KACHIA','KADUNA','KACHIA','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-01-23 12:32:27',5,'724','2022-01-23 12:32:27','724'),(4240,'','1','200','UMAR GAS','UMAR SALISU','09022613333','hgaya@aarano.com.ng','IGABI','KADUNA','HAYIN NA\'IYA ','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-01-25 15:31:07',5,'724','2022-01-25 15:31:07','724'),(4241,'','1','200','UMMA DAN I. VENTURES','ABBAS MAHMOUD','08067581004','hgaya@aaranonigeria.com','KADUNA NORTH','KADUNA','NO;25 IBRAHIM DALLATU STREET KADAURE KADUNA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-31 09:18:33',5,'724','2023-01-20 14:11:27','724'),(4242,'','1','200','DANITEST VENTURE','OGBU EMMANUEL','09033725117','hgaya@aaraninigeria.com','KADUNA','KADUNA','ARUGUNGU ROAD BY ABEOKUTA STRESS KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-01 11:43:13',5,'724','2022-10-24 17:23:03','724'),(4243,'','1','200','BLK GAS','BASHIR LIMAN','08035558268','hgaya@aaranonigerian.com','KADUNA','KADUNA','NO. 06B ALKALI ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-02 14:53:32',5,'724','2022-05-29 11:24:07','724'),(4244,'','1','200','A B GAS','IBRAHAM ','08081249648','hgaya@aaranonigerian.com','KADUNA','KADUNA','BARNAWA DAMBU AVENURE','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-02-05 12:44:11',5,'724','2022-02-05 12:44:11','724'),(4245,'','1','200','SUMLA GLOBAL RESOURCES NIG LTD','CHRISTOPHER ALIDU','08067994427','hgaya@aaranonigerian.com','KADUNA SOUTH','KADUNA','KUDENDA KADUNA SOUTH','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-05 17:11:08',5,'724','2022-02-05 17:14:26','724'),(4246,'','1','200','EDACHE GAS','DANIEL EDACHE','08124744369','hgaya@aaraninigeria.com','KADUNA','KADUNA','NO 52 ALKALI ROAD U/RIMI KADUNA','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-02-13 13:45:06',5,'724','2022-02-13 13:45:06','724'),(4247,'','1','200','GG GAS','GEORGE','08094084510','hgaya@aaraninigeria.com','KADUNA','KADUNA','ALKARI ROAD ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-14 09:42:23',5,'724','2022-02-14 09:42:23','724'),(4248,'','1','200','ZALLAH GAS','ADAMU AHMAD','09066374668','hgaya@aaraninigeria.com','KADUNA NORTH','KADUNA','U/RIMI C66 BAMAKO ROAD','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-03-04 10:07:52',5,'724','2022-03-04 10:07:52','724'),(4249,'','1','200','YAKUBU GASES','YAKUBU IBRAHIM','08033136866','hgaya@aaraninigeria.com','KADUNA','KADUNA','BB18/22 MUSA YAKUBU CRESCENT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-12 11:42:54',5,'724','2022-03-12 11:42:54','724'),(4250,'','1','200','KANKARA PETROLEUM RESOURCES','ALIYU SULEIMAN','08068114766','hgaya@aaraninigeria.com','KADUNA','KADUNA','BLOCK 5 AGRIC QUATERS AIRFORCE BASE KADUNA','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-03-12 16:52:11',5,'724','2022-03-12 16:52:11','724'),(4251,'','1','200','IKON ALLAH ENTERPRISES GAS','VICTORIA OJO','08036136997','hgaya@aaraninigeria.com','KADUNA','KADUNA','NO56 ALKALI ROAD SHOPPING COMPLEX KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-14 14:44:52',5,'724','2022-03-14 14:44:52','724'),(4252,'','1','200','SABIU GAS','SABIU DAYYABU','08035936923','hgaya@aaraninigeria.com','KADUNA','KADUNA','NASSARAWA BY BYE PASS ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-21 15:41:25',5,'724','2022-03-21 15:41:25','724'),(4253,'','1','200','SS GAS VENTURES','SHAFIU SHEHU','08038282250','hgaya@aaraninigeria.com','KADUNA','KADUNA','MARABAN JOS','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-26 13:22:45',5,'724','2022-09-11 10:59:30','724'),(4254,'','1','200','COLA & S0NS GAS ','IDRIS MUHAMMAD','08061664794','hgaya@aaraninigeria.com','IGABI','KADUNA','MAKARFI ROAD IGABI KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-26 13:25:49',5,'724','2022-03-26 13:25:49','724'),(4255,'','1','200','SK GAS','ABDULLATIF SHAKIRU','07066256994','hgaya@aaraninigeria.com','KADUNA','KADUNA','KABALA NARIYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-28 15:21:46',5,'724','2022-03-28 15:21:46','724'),(4256,'','1','200','SAUKI OIL & GAS','ABUBAKAR SAGIR','08143698904','hgaya@aaraninigeria.com','KADUNA','KADUNA','UNGUWAN DOSA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-03 10:07:02',5,'724','2022-04-03 10:07:02','724'),(4257,'','1','200','HUSSAINI IBRAHIM GASES','HUSSAINI IBRAHIM','08066905044','hgaya@aaraninigeria.com','KADUNA','KADUNA','GAMJI GET KABALA KADUNA NORTH','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-05 10:11:53',5,'724','2022-04-05 10:15:54','724'),(4258,'','1','200','ALMUWAHHID GAS','ABU-ISLAM BIN ABDUSSALAM BOLA ','08066555959','hgaya@aaraninigeria.com','IGABI','KADUNA','FAKI ROAD DOWN BUS-STOP HAYIN MALLAM BELLO ','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-04-07 10:08:00',5,'724','2022-04-07 10:08:00','724'),(4259,'','1','200','NAGARI GAS','UMAR USMAN','08068993399','hgaya@aaraninigeria.com','KADUNA','KADUNA','NO;71 ZAKARIYYA MAI MALALI NASFAT GRA KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-07 14:43:34',5,'724','2022-04-07 14:43:34','724'),(4260,'','1','200','SULEIMAN BAHIR GAS','SULEIMAN BASHIR','08036045796','hgaya@aaraninigeria.com','KADUNA','KADUNA','196 COLLEGE ROAD U/ DOSA KAWO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-19 14:16:05',5,'724','2022-04-19 14:18:42','724'),(4261,'','1','200','YUSIF GAS','YUSIF TOMOS','08036925469','hgaya@aaraninigeria.com','KADUNA','KADUNA','MALALI U/SHAKARA KADUNA NORTH','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-28 14:24:13',5,'724','2022-04-28 14:24:13','724'),(4262,'','1','200','STEEL HUB GAS','ISMAIL MIKAIL ABDULLAHI','07067621842','hgaya@aaraninigeria.com','KADUNA','KADUNA','NO 33 LEMU ROAD','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-05-09 10:35:30',5,'724','2022-05-09 10:35:30','724'),(4263,'','1','200','GRACE GAS','GRACE ABA','09094670070','hgaya@aaraninigeria.com','KADUNA','KADUNA','ALIYU MAKAMA ROAD BARNAWA','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-05-12 10:09:02',5,'724','2022-05-12 10:09:02','724'),(4264,'','1','200','JUPITECH  GAS','JUPITECH GASES','07033106286','hgaya@aaraninigeria.com','KADUNA','KADUNA','KUJAMA KACHIA KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-16 07:27:03',5,'724','2022-06-16 07:31:59','724'),(4265,'','1','200','SUBLIME OIL & GAS NIG LTD','SAGIR MUHAMMAD','08035310999','hgaya@aaraninigeria.com','KADUNA','KADUNA','NNAMDI AZIKIWE EPRESS WAY BYE PASS BY KAGORO KADUNA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-21 16:08:24',5,'724','2022-06-23 11:03:10','724'),(4266,'','1','200','TRANSFER TO ZARIA','ZARIA LPG','08067097606','hgaya@aaraninigeria.com','ZARIA','KADUNA','ZARIA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-07-14 14:12:47',5,'724','2022-07-14 14:12:47','724'),(4267,'','1','200','MUSA GAS','MUSA ADAMU','08031532219','hgaya@aaraninigeria.com','KADUNA','KADUNA','DAN HUNNU MILLEIUM CITY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-18 10:27:49',5,'724','2022-08-18 10:27:49','724'),(4268,'','1','200','SOLO GAS','SOLOMAN','08035871190','hgaya@aaraninigeria.com','KADUNA','KADUNA','AK 10 LOGOS STREET BY YORUBA ROAD ','Nigeria',300.00,0.00,0.00,'0000-00-00','2022-09-20 13:45:42',5,'724','2022-09-20 13:45:42','724'),(4269,'','1','200','JONATHAN GAS','JONATHAN','08131868651','hgaya@aaraninigeria.com','KADUNA SOUTH','KADUNA','POST OFFICE JUNCTION SABON TASHA KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-23 11:26:27',5,'724','2022-09-23 11:26:27','724'),(4270,'','1','200','U/ADIESON GAS ','AKOMAYE DOMINIC','07068952646','hgaya@aaraninigeria.com','KADUNA','KADUNA','JAYOBA HOTEL OPP COMMAND SECONDARY SCHOOL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-23 11:39:13',5,'724','2022-09-23 11:39:13','724'),(4271,'','1','200','SANI GAS','SANI GAJERE','09020392737','hgaya@aaraninigeria.com','KADUNA','KADUNA','UNGUWAN MAI GERO STREET ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-30 15:15:47',5,'724','2022-09-30 15:15:47','724'),(4272,'','1','200','ALALA GROUP GAS','FRIDAY MAGAJI','08165568363','hgaya@aaraninigeria.com','KADUNA','KADUNA','NO;13 OBATOTO STREET KARUGA NARAYI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-15 17:07:13',5,'724','2022-10-15 17:08:05','724'),(4273,'','1','200','AMINCI GAS','IBRAHIM ALI','08030452997','hgaya@aaraninigeria.com','KADUNA NORTH','KADUNA','HAYIN NA\'IYA  OFISHIN DILLALAI','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-10-23 15:36:09',5,'724','2022-10-23 15:36:09','724');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2510 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
INSERT INTO `customers_status` VALUES (2508,'1','200','4145',0,'NOT DEALER','2022-01-06 15:49:52'),(2509,'1','200','4145',5,'NEW DEALER','2022-01-11 10:35:24');
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3045 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','200','1025',3037,'5','LPG NOZZLE 1',199919.00,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-08-22 19:20:35','724'),('1','200','1025',3038,'5','LPG NOZZLE 2',199680.78,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-12 00:01:43','483'),('1','200','1025',3039,'5','LPG NOZZLE 3',280320.54,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-12 00:02:19','483'),('1','200','1025',3040,'5','LPG NOZZLE 4',284120.13,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-12 00:02:57','483'),('1','200','1025',3041,'5','LPG NOZZLE 5',250711.46,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-12 00:03:42','483'),('1','200','1025',3042,'5','LPG NOZZLE 6',294856.16,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-12 00:04:19','483'),('1','200','1025',3043,'5','LPG NOZZLE 7',315425.50,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-12 00:04:53','483'),('1','200','1025',3044,'5','LPG NOZZLE 8',284583.98,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-12 00:05:30','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257988 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','200',243697,'DAILY SALES','2021-12-04','2021-12-04 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-04 19:23:17','724','2021-12-04 19:23:39',10,0),('1','200',243883,'DAILY SALES','2021-12-05','2021-12-05 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-05 18:45:41','724','2021-12-05 18:46:24',10,0),('1','200',244055,'DAILY SALES','2021-12-06','2021-12-06 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-06 18:36:27','724','2021-12-06 18:36:55',10,0),('1','200',244302,'Daily shift','2021-12-07','2021-12-07 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-08 05:06:17','724','2021-12-08 05:06:46',10,0),('1','200',244504,'Daily shift','2021-12-08','2021-12-08 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-08 21:34:02','724','2021-12-08 21:34:59',10,0),('1','200',244726,'DALIY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-09 18:33:21','724','2021-12-09 18:34:40',10,0),('1','200',244955,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-10 17:56:39','724','2021-12-10 17:57:28',10,0),('1','200',245198,'DAILY SHIFT ','2021-12-11','2021-12-11 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-11 20:40:42','724','2021-12-11 20:41:28',10,0),('1','200',245424,'DAILY SHIFT ','2021-12-12','2021-12-12 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-12 21:48:33','724','2021-12-12 21:49:02',10,0),('1','200',245664,'DAILY SHIFT ','2021-12-13','2021-12-13 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-13 18:10:14','724','2021-12-13 18:11:24',10,0),('1','200',245924,'DAILY SHIFT ','2021-12-14','2021-12-14 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-14 18:24:45','724','2021-12-14 18:28:55',10,0),('1','200',246174,'DAILY SHIFT ','2021-12-15','2021-12-15 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-15 17:54:41','724','2021-12-15 17:55:15',10,0),('1','200',246464,'DAILY SALES','2021-12-16','2021-12-16 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-16 18:07:26','724','2021-12-16 18:08:03',10,0),('1','200',246702,'DAILY SALES','2021-12-17','2021-12-17 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-17 18:14:45','724','2021-12-17 18:15:32',10,0),('1','200',246937,'DAILY SALES','2021-12-18','2021-12-18 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-18 17:59:35','724','2021-12-18 18:00:37',10,0),('1','200',247172,'DAILY SALES','2021-12-19','2021-12-19 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-19 17:41:17','724','2021-12-19 17:42:04',10,0),('1','200',247409,'DAILY SALES','2021-12-20','2021-12-20 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-20 18:29:41','724','2021-12-20 18:30:33',10,0),('1','200',247673,'DAILY SALES','2021-12-21','2021-12-21 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-21 19:22:44','724','2021-12-21 19:23:27',10,0),('1','200',247912,'DAILY SALES','2021-12-22','2021-12-22 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-22 17:43:21','724','2021-12-22 17:44:13',10,0),('1','200',248163,'DAILY SALES','2021-12-23','2021-12-23 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-23 21:09:48','724','2021-12-23 21:11:52',10,0),('1','200',248415,'DAILY SALES','2021-12-24','2021-12-24 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-24 19:06:02','724','2021-12-24 19:06:49',10,0),('1','200',248650,'DAILY SALES','2021-12-25','2021-12-25 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-25 20:59:34','724','2021-12-25 21:00:17',10,0),('1','200',248877,'DAILY SALES','2021-12-26','2021-12-26 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-26 15:38:42','724','2021-12-26 15:39:06',10,0),('1','200',249024,'DAILY SALES','2021-12-26','2021-12-26 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-26 15:52:54','724','2021-12-26 15:53:12',10,0),('1','200',249062,'DAILY SALES','2021-12-26','2021-12-26 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-26 19:52:26','724','2021-12-26 19:52:46',10,0),('1','200',249118,'DAILY SALES','2021-12-27','2021-12-27 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-27 19:25:12','724','2021-12-27 19:25:34',10,0),('1','200',249364,'DAILY SALES','2021-12-28','2021-12-28 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-28 18:35:43','724','2021-12-28 18:36:14',10,0),('1','200',249609,'DAILY SALES','2021-12-29','2021-12-29 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-29 18:28:59','724','2021-12-29 18:29:47',10,0),('1','200',249874,'DAILY SALES','2021-12-30','2021-12-30 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-30 20:49:49','724','2021-12-30 20:50:17',10,0),('1','200',250102,'DAILY SALES','2021-12-31','2021-12-31 00:00:00',NULL,'724',0.00,0.00,'724','2021-12-31 22:12:35','724','2021-12-31 22:13:23',10,0),('1','200',250356,'DAILY SALES','2022-01-01','2022-01-01 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-01 17:44:54','724','2022-01-01 17:45:32',10,0),('1','200',250563,'DAILY SALES','2022-01-02','2022-01-02 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-02 19:25:35','724','2022-01-02 19:27:33',10,0),('1','200',250817,'DAILY SALES','2022-01-03','2022-01-03 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-03 17:56:33','724','2022-01-03 17:57:06',10,0),('1','200',251044,'DAILY SALES','2022-01-04','2022-01-04 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-04 17:46:30','724','2022-01-04 17:47:29',10,0),('1','200',251278,'DAILY SALES','2022-01-05','2022-01-05 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-05 20:18:42','724','2022-01-05 20:19:09',10,0),('1','200',251526,'DAILY SALES','2022-01-06','2022-01-06 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-06 19:31:15','724','2022-01-06 19:32:10',10,0),('1','200',251772,'DAILY SALES','2022-01-07','2022-01-07 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-08 07:18:26','724','2022-01-08 07:19:12',10,0),('1','200',251998,'DAILY SALES','2022-01-08','2022-01-08 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-08 19:49:07','724','2022-01-08 19:49:33',10,0),('1','200',252239,'DAILY SALES','2022-01-09','2022-01-09 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-10 07:34:14','724','2022-01-10 07:35:19',10,0),('1','200',252488,'DAILY SALES','2022-01-10','2022-01-10 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-10 21:40:11','724','2022-01-10 21:41:05',10,0),('1','200',252725,'DAILY SALES','2022-01-11','2022-01-11 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-11 19:03:28','724','2022-01-11 19:04:50',10,0),('1','200',252972,'DAILY SALES','2022-01-12','2022-01-12 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-12 19:00:40','724','2022-01-12 19:01:36',10,0),('1','200',253212,'DAILY SALES','2022-01-13','2022-01-13 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-13 19:28:30','724','2022-01-13 19:30:18',10,0),('1','200',253477,'DAILY SALES','2022-01-14','2022-01-14 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-14 20:45:56','724','2022-01-14 20:50:09',10,0),('1','200',253719,'DAILY SALES','2022-01-15','2022-01-15 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-15 19:36:55','724','2022-01-15 19:41:40',10,0),('1','200',253960,'DAILY SALES','2022-01-16','2022-01-16 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-16 09:55:45','724','2022-01-16 09:56:05',10,0),('1','200',254013,'DAILY SALES','2022-01-16','2022-01-16 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-16 22:09:23','724','2022-01-16 22:11:03',10,0),('1','200',254217,'DAILY SALES','2022-01-17','2022-01-17 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-17 19:26:39','724','2022-01-17 19:28:08',10,0),('1','200',254457,'DAILY SALES','2022-01-18','2022-01-18 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-18 19:28:49','724','2022-01-18 19:29:17',10,0),('1','200',254714,'DAILY SALES','2022-01-19','2022-01-19 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-19 19:50:16','724','2022-01-19 19:50:45',10,0),('1','200',254958,'DAILY SALES','2022-01-20','2022-01-20 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-20 18:51:37','724','2022-01-20 18:53:03',10,0),('1','200',255204,'DAILY SALES','2022-01-21','2022-01-21 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-21 19:30:56','724','2022-01-21 19:32:08',10,0),('1','200',255483,'DAILY SALES','2022-01-22','2022-01-22 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-22 19:03:18','724','2022-01-22 19:06:08',10,0),('1','200',255734,'DAILY SALES','2022-01-23','2022-01-23 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-23 19:24:12','724','2022-01-23 19:24:59',10,0),('1','200',255953,'DAILY SALES','2022-01-24','2022-01-24 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-24 20:01:00','724','2022-01-24 20:02:14',10,0),('1','200',256212,'DAILY SALES','2022-01-25','2022-01-25 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-25 18:37:06','724','2022-01-25 18:37:47',10,0),('1','200',256507,'DAILY SALES','2022-01-26','2022-01-26 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-26 18:58:11','724','2022-01-26 18:59:15',10,0),('1','200',256749,'DAILY SALES','2022-01-27','2022-01-27 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-27 18:57:29','724','2022-01-27 18:58:16',10,0),('1','200',256990,'DAILY SALES','2022-01-28','2022-01-28 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-28 19:13:08','724','2022-01-28 19:14:54',10,0),('1','200',257247,'DAILY SALES','2022-01-29','2022-01-29 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-29 18:53:53','724','2022-01-29 18:54:29',10,0),('1','200',257506,'DAILY SALES','2022-01-30','2022-01-30 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-30 18:54:35','724','2022-01-30 18:55:39',10,0),('1','200',257507,'DAILY SALES','2022-01-31','2022-01-31 00:00:00',NULL,'724',0.00,0.00,'724','2022-01-31 19:03:07','724','2022-01-31 19:03:29',10,0),('1','200',257508,'DAILY SALES','2022-02-01','2022-02-01 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-01 19:11:31','724','2022-02-01 19:11:50',10,0),('1','200',257509,'DAILY SALES','2022-02-02','2022-02-02 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-02 19:36:45','724','2022-02-02 19:37:06',10,0),('1','200',257510,'DAILY SALES','2022-02-03','2022-02-03 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-03 19:24:16','724','2022-02-03 19:24:47',10,0),('1','200',257511,'DAILY SALES','2022-02-04','2022-02-04 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-04 20:05:57','724','2022-02-04 20:06:18',10,0),('1','200',257512,'DAILY SALES','2022-02-05','2022-02-05 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-05 19:57:21','724','2022-02-05 19:58:16',10,0),('1','200',257513,'DAILY SALES','2022-02-06','2022-02-06 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-06 20:05:38','724','2022-02-06 20:06:02',10,0),('1','200',257514,'DAILY SALES','2022-02-07','2022-02-07 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-07 19:26:00','724','2022-02-07 19:26:19',10,0),('1','200',257515,'DAILY SALES','2022-02-08','2022-02-08 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-08 20:26:01','724','2022-02-08 20:26:24',10,0),('1','200',257516,'DAILY SALES','2022-02-09','2022-02-09 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-09 20:55:06','724','2022-02-09 20:55:39',10,0),('1','200',257517,'DAILY SALES','2022-02-10','2022-02-10 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-10 19:31:32','724','2022-02-10 19:31:55',10,0),('1','200',257518,'DAILY SALES','2022-02-11','2022-02-11 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-11 22:03:21','724','2022-02-11 22:03:37',10,0),('1','200',257519,'DAILY SALES ','2022-02-12','2022-02-12 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-12 20:22:20','724','2022-02-12 20:22:44',10,0),('1','200',257520,'DAILY SALES ','2022-02-13','2022-02-13 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-13 11:25:32','724','2022-02-13 11:25:59',10,0),('1','200',257521,'BULK SALES','2022-02-13','2022-02-13 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-13 11:45:46','724','2022-02-13 11:46:06',10,0),('1','200',257522,'DAILY SALES','2022-02-13','2022-02-13 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-13 20:02:21','724','2022-02-13 20:02:41',10,0),('1','200',257523,'DAILY SALES ','2022-02-14','2022-02-14 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-14 19:52:04','724','2022-02-14 19:52:22',10,0),('1','200',257524,'DAILY SALES ','2022-02-15','2022-02-15 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-15 13:54:11','724','2022-02-15 13:54:32',10,0),('1','200',257525,'BULK SALES','2022-02-15','2022-02-15 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-15 14:10:36','724','2022-02-15 14:10:54',10,0),('1','200',257526,'DAILY SALES','2022-02-15','2022-02-15 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-16 00:56:11','724','2022-02-16 00:57:43',10,0),('1','200',257527,'DAILY SALES ','2022-02-16','2022-02-16 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-16 20:06:34','724','2022-02-16 20:06:59',10,0),('1','200',257528,'DAILY SALES ','2022-02-17','2022-02-17 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-17 20:51:22','724','2022-02-17 20:51:50',10,0),('1','200',257529,'DAILY SALES ','2022-02-18','2022-02-18 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-18 22:02:01','724','2022-02-18 22:02:22',10,0),('1','200',257530,'BULK SALES','2022-02-18','2022-02-18 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-18 22:08:01','724','2022-02-18 22:08:20',10,0),('1','200',257531,'DAILY SALES ','2022-02-19','2022-02-19 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-19 20:46:51','724','2022-02-19 20:47:08',10,0),('1','200',257532,'DAILY SALES ','2022-02-20','2022-02-20 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-20 19:53:45','724','2022-02-20 19:54:03',10,0),('1','200',257533,'DAILY SALES ','2022-02-21','2022-02-21 00:00:00',NULL,'724',0.00,0.00,'724','2022-02-21 20:08:23','724','2022-02-21 20:08:41',10,0),('1','200',257534,'DAILY SALES ','2022-02-22','2022-02-22 06:22:31','2022-02-23 06:22:31','724',0.00,0.00,'724','2022-02-22 19:52:46','724','2022-02-22 19:53:12',10,0),('1','200',257535,'DAILY SALES ','2022-02-23','2022-02-23 06:55:03','2022-02-24 06:55:03','724',0.00,0.00,'724','2022-02-23 20:06:56','724','2022-02-23 20:08:08',10,0),('1','200',257536,'DAILY SALES ','2022-02-24','2022-02-24 06:08:10','2022-02-25 06:08:10','724',0.00,0.00,'724','2022-02-24 19:42:45','724','2022-02-24 19:43:06',10,0),('1','200',257537,'DAILY SALES ','2022-02-25','2022-02-25 06:27:11','2022-02-26 06:27:11','724',0.00,0.00,'724','2022-02-25 20:37:28','724','2022-02-25 20:38:56',10,0),('1','200',257538,'DAILY SALES','2022-02-26','2022-02-26 06:34:08','2022-02-27 06:34:08','724',0.00,0.00,'724','2022-02-26 13:20:00','724','2022-02-26 13:20:21',10,0),('1','200',257539,'BULK SALES','2022-02-26','2022-02-26 13:23:16','2022-02-27 13:23:16','724',0.00,0.00,'724','2022-02-26 13:30:40','724','2022-02-26 13:30:59',10,0),('1','200',257540,'DAILY SALES','2022-02-26','2022-02-26 16:28:03','2022-02-27 16:28:03','724',0.00,0.00,'724','2022-02-26 20:31:41','724','2022-02-26 20:32:08',10,0),('1','200',257541,'DAILY SALES ','2022-02-27','2022-02-27 06:26:39','2022-02-28 06:26:39','724',0.00,0.00,'724','2022-02-27 20:48:29','724','2022-02-27 20:48:48',10,0),('1','200',257542,'DAILY SALES ','2022-02-28','2022-02-28 06:16:48','2022-03-01 06:16:48','724',0.00,0.00,'724','2022-02-28 20:09:48','724','2022-02-28 20:10:08',10,0),('1','200',257543,'DAILY SALES ','2022-03-01','2022-03-01 06:17:09','2022-03-02 06:17:09','724',0.00,0.00,'724','2022-03-01 19:37:55','724','2022-03-01 19:38:19',10,0),('1','200',257544,'DAILY SALES ','2022-03-02','2022-03-02 06:25:12','2022-03-03 06:25:12','724',0.00,0.00,'724','2022-03-02 19:49:17','724','2022-03-02 19:49:34',10,0),('1','200',257545,'DAILY SALES ','2022-03-03','2022-03-03 07:34:55','2022-03-04 07:34:55','724',0.00,0.00,'724','2022-03-03 20:00:33','724','2022-03-03 20:01:12',10,0),('1','200',257546,'DAILY SALES ','2022-03-04','2022-03-04 06:34:07','2022-03-05 06:34:07','724',0.00,0.00,'724','2022-03-04 20:25:41','724','2022-03-04 20:26:09',10,0),('1','200',257547,'DAILY SALES ','2022-03-05','2022-03-05 06:29:11','2022-03-06 06:29:11','724',0.00,0.00,'724','2022-03-05 20:00:19','724','2022-03-05 20:01:30',10,0),('1','200',257548,'DAILY SALES ','2022-03-06','2022-03-06 06:46:12','2022-03-07 06:46:12','724',0.00,0.00,'724','2022-03-06 20:18:42','724','2022-03-06 20:19:25',10,0),('1','200',257549,'DAILY SALES ','2022-03-07','2022-03-07 06:44:52','2022-03-08 06:44:52','724',0.00,0.00,'724','2022-03-07 11:07:50','724','2022-03-07 11:08:17',10,0),('1','200',257550,'BULK SALES','2022-03-07','2022-03-07 14:44:29','2022-03-08 14:44:29','724',0.00,0.00,'724','2022-03-07 14:48:06','724','2022-03-07 14:48:25',10,0),('1','200',257551,'DAILY SALES','2022-03-08','2022-03-08 16:20:24','2022-03-09 16:20:24','724',0.00,0.00,'724','2022-03-08 20:11:55','724','2022-03-08 20:12:24',10,0),('1','200',257552,'DAILY SALES ','2022-03-09','2022-03-09 06:55:36','2022-03-10 06:55:36','724',0.00,0.00,'724','2022-03-09 19:48:22','724','2022-03-09 19:48:52',10,0),('1','200',257553,'DAILY SALES','2022-03-10','2022-03-10 06:45:54','2022-03-11 06:45:54','724',0.00,0.00,'724','2022-03-10 20:09:50','724','2022-03-10 20:10:20',10,0),('1','200',257554,'DAILY SALES ','2022-03-11','2022-03-11 07:00:18','2022-03-12 07:00:18','724',0.00,0.00,'724','2022-03-11 19:12:48','724','2022-03-11 19:13:34',10,0),('1','200',257555,'DAILY SALES ','2022-03-12','2022-03-12 06:42:00','2022-03-13 06:42:00','724',0.00,0.00,'724','2022-03-12 19:18:24','724','2022-03-12 19:18:53',10,0),('1','200',257556,'DAILY SALES ','2022-03-13','2022-03-13 07:06:22','2022-03-14 07:06:22','724',0.00,0.00,'724','2022-03-13 16:17:43','724','2022-03-13 16:18:03',10,0),('1','200',257557,'BULK SALES','2022-03-13','2022-03-13 16:18:55','2022-03-14 16:18:55','724',0.00,0.00,'724','2022-03-13 16:23:37','724','2022-03-13 16:24:13',10,0),('1','200',257558,'DAILY SALES','2022-03-13','2022-03-13 16:30:31','2022-03-14 16:30:31','724',0.00,0.00,'724','2022-03-13 19:59:06','724','2022-03-13 19:59:54',10,0),('1','200',257559,'DAILY SALES ','2022-03-14','2022-03-14 07:04:49','2022-03-15 07:04:49','724',0.00,0.00,'724','2022-03-14 19:39:21','724','2022-03-14 19:39:49',10,0),('1','200',257560,'DAILY SALES ','2022-03-15','2022-03-15 06:27:02','2022-03-16 06:27:02','724',0.00,0.00,'724','2022-03-15 19:32:34','724','2022-03-15 19:33:11',10,0),('1','200',257561,'DAILY SALES ','2022-03-16','2022-03-16 06:25:25','2022-03-17 06:25:25','724',0.00,0.00,'724','2022-03-16 20:31:29','724','2022-03-16 20:31:54',10,0),('1','200',257562,'DAILY SALES ','2022-03-17','2022-03-17 06:43:49','2022-03-18 06:43:49','724',0.00,0.00,'724','2022-03-17 19:28:08','724','2022-03-17 19:28:33',10,0),('1','200',257563,'DAILY SALES ','2022-03-18','2022-03-18 06:35:41','2022-03-19 06:35:41','724',0.00,0.00,'724','2022-03-18 19:18:31','724','2022-03-18 19:18:53',10,0),('1','200',257564,'DAILY SALES ','2022-03-19','2022-03-19 06:25:54','2022-03-20 06:25:54','724',0.00,0.00,'724','2022-03-19 19:52:50','724','2022-03-19 19:54:45',10,0),('1','200',257565,'DAILY SALES ','2022-03-20','2022-03-20 06:27:57','2022-03-21 06:27:57','724',0.00,0.00,'724','2022-03-20 19:05:25','724','2022-03-20 19:05:55',10,0),('1','200',257566,'DAILY SALES ','2022-03-21','2022-03-21 06:53:52','2022-03-22 06:53:52','724',0.00,0.00,'724','2022-03-21 19:16:34','724','2022-03-21 19:17:00',10,0),('1','200',257567,'DAILY SALES ','2022-03-22','2022-03-22 06:28:18','2022-03-23 06:28:18','724',0.00,0.00,'724','2022-03-22 18:58:53','724','2022-03-22 18:59:20',10,0),('1','200',257568,'DAILY SALES ','2022-03-23','2022-03-23 06:26:10','2022-03-24 06:26:10','724',0.00,0.00,'724','2022-03-23 16:07:28','724','2022-03-23 16:07:47',10,0),('1','200',257569,'BULK SALES','2022-03-23','2022-03-23 16:10:46','2022-03-24 16:10:46','724',0.00,0.00,'724','2022-03-23 16:18:09','724','2022-03-23 16:18:28',10,0),('1','200',257570,'DAILY SALES','2022-03-24','2022-03-24 10:59:34','2022-03-25 10:59:34','724',0.00,0.00,'724','2022-03-24 19:25:42','724','2022-03-24 19:26:23',10,0),('1','200',257571,'DAILY SALES ','2022-03-25','2022-03-25 06:19:33','2022-03-26 06:19:33','724',0.00,0.00,'724','2022-03-25 19:14:45','724','2022-03-25 19:15:30',10,0),('1','200',257572,'DAILY SALES ','2022-03-26','2022-03-26 07:00:56','2022-03-27 07:00:56','724',0.00,0.00,'724','2022-03-26 19:47:54','724','2022-03-26 19:48:11',10,0),('1','200',257573,'DAILY SALES ','2022-03-27','2022-03-27 06:41:53','2022-03-28 06:41:53','724',0.00,0.00,'724','2022-03-27 19:17:10','724','2022-03-27 19:18:11',10,0),('1','200',257574,'DAILY SALES','2022-03-28','2022-03-28 07:05:17','2022-03-29 07:05:17','724',0.00,0.00,'724','2022-03-28 19:15:53','724','2022-03-28 19:16:23',10,0),('1','200',257575,'DAILY SALES ','2022-03-29','2022-03-29 06:27:45','2022-03-30 06:27:45','724',0.00,0.00,'724','2022-03-29 13:18:43','724','2022-03-29 13:19:01',10,0),('1','200',257576,'BULK SALES','2022-03-29','2022-03-29 13:19:28','2022-03-30 13:19:28','724',0.00,0.00,'724','2022-03-29 13:22:00','724','2022-03-29 13:22:42',10,0),('1','200',257577,'DAILY SALES','2022-03-29','2022-03-29 13:25:26','2022-03-30 13:25:26','724',0.00,0.00,'724','2022-03-29 19:00:42','724','2022-03-29 19:01:27',10,0),('1','200',257578,'DAILY SALES ','2022-03-30','2022-03-30 06:03:50','2022-03-31 06:03:50','724',0.00,0.00,'724','2022-03-30 19:13:21','724','2022-03-30 19:13:50',10,0),('1','200',257579,'DAILY SALES ','2022-03-31','2022-03-31 06:27:34','2022-04-01 06:27:34','724',0.00,0.00,'724','2022-03-31 19:24:45','724','2022-03-31 19:25:16',10,0),('1','200',257580,'DAILY SALES ','2022-04-01','2022-04-01 06:41:48','2022-04-02 06:41:48','724',0.00,0.00,'724','2022-04-01 20:13:42','724','2022-04-01 20:14:25',10,0),('1','200',257581,'DAILY SALES ','2022-04-02','2022-04-02 06:01:55','2022-04-03 06:01:55','724',0.00,0.00,'724','2022-04-02 14:14:13','724','2022-04-02 14:14:45',10,0),('1','200',257582,'BULK SALES','2022-04-02','2022-04-02 15:47:28','2022-04-03 15:47:28','724',0.00,0.00,'724','2022-04-02 15:50:16','724','2022-04-02 15:50:35',10,0),('1','200',257583,'DAILY SALES','2022-04-02','2022-04-02 16:47:10','2022-04-03 16:47:10','724',0.00,0.00,'724','2022-04-02 20:02:10','724','2022-04-02 20:02:42',10,0),('1','200',257584,'DAILY SALES','2022-04-03','2022-04-03 06:16:13','2022-04-04 06:16:13','724',0.00,0.00,'724','2022-04-03 18:52:03','724','2022-04-03 18:52:43',10,0),('1','200',257585,'DAILY SALES ','2022-04-04','2022-04-04 06:20:49','2022-04-05 06:20:49','724',0.00,0.00,'724','2022-04-04 18:31:59','724','2022-04-04 18:32:25',10,0),('1','200',257586,'DAILY SALES ','2022-04-05','2022-04-05 06:15:45','2022-04-06 06:15:45','724',0.00,0.00,'724','2022-04-05 20:08:36','724','2022-04-05 20:09:11',10,0),('1','200',257587,'DAILY SALES ','2022-04-06','2022-04-06 06:06:26','2022-04-07 06:06:26','724',0.00,0.00,'724','2022-04-06 11:56:10','724','2022-04-06 11:57:07',10,0),('1','200',257588,'BULK SALES','2022-04-06','2022-04-06 13:05:40','2022-04-07 13:05:40','724',0.00,0.00,'724','2022-04-06 13:08:44','724','2022-04-06 13:09:02',10,0),('1','200',257589,'DAILY SALES','2022-04-07','2022-04-07 07:26:36','2022-04-08 07:26:36','724',0.00,0.00,'724','2022-04-07 18:47:43','724','2022-04-07 18:48:09',10,0),('1','200',257590,'DAILY SALES ','2022-04-08','2022-04-08 06:01:41','2022-04-09 06:01:41','724',0.00,0.00,'724','2022-04-08 18:31:26','724','2022-04-08 18:31:56',10,0),('1','200',257591,'DAILY SALES ','2022-04-09','2022-04-09 06:05:29','2022-04-10 06:05:29','724',0.00,0.00,'724','2022-04-09 18:16:51','724','2022-04-09 18:19:56',10,0),('1','200',257592,'DAILY SALES ','2022-04-10','2022-04-10 07:47:11','2022-04-11 07:47:11','724',0.00,0.00,'724','2022-04-10 18:29:32','724','2022-04-10 18:30:30',10,0),('1','200',257593,'DAILY SALES ','2022-04-11','2022-04-11 06:04:34','2022-04-12 06:04:34','724',0.00,0.00,'724','2022-04-11 18:22:23','724','2022-04-11 18:24:06',10,0),('1','200',257594,'DAILY SALES ','2022-04-12','2022-04-12 06:11:29','2022-04-13 06:11:29','724',0.00,0.00,'724','2022-04-12 11:54:55','724','2022-04-12 11:56:10',10,0),('1','200',257595,'BULK SALES','2022-04-12','2022-04-12 11:57:01','2022-04-13 11:57:01','724',0.00,0.00,'724','2022-04-12 12:01:16','724','2022-04-12 12:01:36',10,0),('1','200',257596,'DAILY SALES','2022-04-12','2022-04-12 12:05:23','2022-04-13 12:05:23','724',0.00,0.00,'724','2022-04-12 18:03:36','724','2022-04-12 18:04:11',10,0),('1','200',257597,'DAILY SALES ','2022-04-13','2022-04-13 07:36:45','2022-04-14 07:36:45','724',0.00,0.00,'724','2022-04-13 18:20:05','724','2022-04-13 18:20:30',10,0),('1','200',257598,'DAILY SALES ','2022-04-14','2022-04-14 06:04:42','2022-04-15 06:04:42','724',0.00,0.00,'724','2022-04-14 18:02:07','724','2022-04-14 18:02:28',10,0),('1','200',257599,'DAILY SALES ','2022-04-15','2022-04-15 06:20:39','2022-04-16 06:20:39','724',0.00,0.00,'724','2022-04-15 18:51:26','724','2022-04-15 18:51:49',10,0),('1','200',257600,'DAILY SALES ','2022-04-16','2022-04-16 07:43:16','2022-04-17 07:43:16','724',0.00,0.00,'724','2022-04-16 18:20:41','724','2022-04-16 18:21:15',10,0),('1','200',257601,'DAILY SALES ','2022-04-17','2022-04-17 06:50:24','2022-04-18 06:50:24','724',0.00,0.00,'724','2022-04-17 12:01:09','724','2022-04-17 12:01:28',10,0),('1','200',257602,'BULK SALES','2022-04-17','2022-04-17 12:04:02','2022-04-18 12:04:02','724',0.00,0.00,'724','2022-04-17 12:09:07','724','2022-04-17 12:09:31',10,0),('1','200',257603,'DAILY SALES','2022-04-17','2022-04-17 12:14:10','2022-04-18 12:14:10','724',0.00,0.00,'724','2022-04-17 18:00:35','724','2022-04-17 18:00:53',10,0),('1','200',257604,'DAILY SALES ','2022-04-18','2022-04-18 06:49:43','2022-04-19 06:49:43','724',0.00,0.00,'724','2022-04-18 18:33:41','724','2022-04-18 18:34:26',10,0),('1','200',257605,'DAILY SALES ','2022-04-19','2022-04-19 07:09:00','2022-04-20 07:09:00','724',0.00,0.00,'724','2022-04-19 18:27:04','724','2022-04-19 18:27:31',10,0),('1','200',257606,'DAILY SALES ','2022-04-20','2022-04-20 06:04:46','2022-04-21 06:04:46','724',0.00,0.00,'724','2022-04-20 18:30:13','724','2022-04-20 18:30:34',10,0),('1','200',257607,'DAILY SALES ','2022-04-21','2022-04-21 06:20:03','2022-04-22 06:20:03','724',0.00,0.00,'724','2022-04-21 18:06:32','724','2022-04-21 18:07:00',10,0),('1','200',257608,'DAILY SALES ','2022-04-22','2022-04-22 07:03:04','2022-04-23 07:03:04','724',0.00,0.00,'724','2022-04-22 18:17:12','724','2022-04-22 18:17:55',10,0),('1','200',257609,'DAILY SALES ','2022-04-23','2022-04-23 06:27:52','2022-04-24 06:27:52','724',0.00,0.00,'724','2022-04-23 18:44:18','724','2022-04-23 18:45:02',10,0),('1','200',257610,'DAILY SALES ','2022-04-24','2022-04-24 06:17:40','2022-04-25 06:17:40','724',0.00,0.00,'724','2022-04-24 18:59:06','724','2022-04-24 18:59:36',10,0),('1','200',257611,'DAILY SALES ','2022-04-25','2022-04-25 07:37:45','2022-04-26 07:37:45','724',0.00,0.00,'724','2022-04-25 18:30:47','724','2022-04-25 18:31:19',10,0),('1','200',257612,'DAILY SALES ','2022-04-26','2022-04-26 07:10:29','2022-04-27 07:10:29','724',0.00,0.00,'724','2022-04-26 18:42:12','724','2022-04-26 18:43:16',10,0),('1','200',257613,'DAILY SALES ','2022-04-27','2022-04-27 06:23:48','2022-04-28 06:23:48','724',0.00,0.00,'724','2022-04-27 18:34:54','724','2022-04-27 18:35:24',10,0),('1','200',257614,'DAILY SALES ','2022-04-28','2022-04-28 06:10:04','2022-04-29 06:10:04','724',0.00,0.00,'724','2022-04-28 18:47:17','724','2022-04-28 18:47:42',10,0),('1','200',257615,'DAILY SALES ','2022-04-29','2022-04-29 06:07:22','2022-04-30 06:07:22','724',0.00,0.00,'724','2022-04-29 19:22:04','724','2022-04-29 19:22:33',10,0),('1','200',257616,'BULK SALES','2022-04-29','2022-04-29 19:27:59','2022-04-30 19:27:59','724',0.00,0.00,'724','2022-04-29 19:48:49','724','2022-04-29 19:49:10',10,0),('1','200',257617,'DAILY SALES ','2022-04-30','2022-04-30 07:01:52','2022-05-01 07:01:52','724',0.00,0.00,'724','2022-04-30 21:09:45','724','2022-04-30 21:10:05',10,0),('1','200',257618,'DAILY SALES ','2022-05-01','2022-05-01 06:49:45','2022-05-02 06:49:45','724',0.00,0.00,'724','2022-05-01 20:31:23','724','2022-05-01 20:31:43',10,0),('1','200',257619,'DAILY SALES ','2022-05-02','2022-05-02 10:24:48','2022-05-03 10:24:48','724',0.00,0.00,'724','2022-05-02 17:55:32','724','2022-05-02 17:55:58',10,0),('1','200',257620,'DAILY SALES ','2022-05-03','2022-05-03 07:06:27','2022-05-04 07:06:27','724',0.00,0.00,'724','2022-05-03 19:25:23','724','2022-05-03 19:25:49',10,0),('1','200',257621,'DAILY SALES ','2022-05-04','2022-05-04 07:05:38','2022-05-05 07:05:38','724',0.00,0.00,'724','2022-05-04 19:09:23','724','2022-05-04 19:09:46',10,0),('1','200',257622,'DAILY SALES ','2022-05-05','2022-05-05 07:08:46','2022-05-06 07:08:46','724',0.00,0.00,'724','2022-05-05 19:24:35','724','2022-05-05 19:25:08',10,0),('1','200',257623,'DAILY SALES ','2022-05-06','2022-05-06 06:25:18','2022-05-07 06:25:18','724',0.00,0.00,'724','2022-05-06 19:38:54','724','2022-05-06 19:39:14',10,0),('1','200',257624,'DAILY SALES','2022-05-07','2022-05-07 06:53:25','2022-05-08 06:53:25','724',0.00,0.00,'724','2022-05-07 19:23:17','724','2022-05-07 19:23:54',10,0),('1','200',257625,'DAILY SALES','2022-05-08','2022-05-08 07:04:06','2022-05-09 07:04:06','724',0.00,0.00,'724','2022-05-08 19:17:34','724','2022-05-08 19:18:06',10,0),('1','200',257626,'DAILY SALES','2022-05-09','2022-05-09 07:21:07','2022-05-10 07:21:07','724',0.00,0.00,'724','2022-05-09 13:01:55','724','2022-05-09 13:02:17',10,0),('1','200',257627,'BULK SALES','2022-05-09','2022-05-09 13:02:58','2022-05-10 13:02:58','724',0.00,0.00,'724','2022-05-09 13:11:28','724','2022-05-09 13:12:58',10,0),('1','200',257628,'DAILY SALES','2022-05-09','2022-05-09 13:13:50','2022-05-10 13:13:50','724',0.00,0.00,'724','2022-05-09 18:41:50','724','2022-05-09 18:42:22',10,0),('1','200',257629,'DAILY SALES','2022-05-10','2022-05-10 07:04:16','2022-05-11 07:04:16','724',0.00,0.00,'724','2022-05-10 19:12:36','724','2022-05-10 19:13:45',10,0),('1','200',257630,'DAILY SALES','2022-05-11','2022-05-11 07:07:07','2022-05-12 07:07:07','724',0.00,0.00,'724','2022-05-11 19:16:41','724','2022-05-11 19:17:04',10,0),('1','200',257631,'DAILY SALES','2022-05-12','2022-05-12 07:17:32','2022-05-13 07:17:32','724',0.00,0.00,'724','2022-05-12 19:13:54','724','2022-05-12 19:14:35',10,0),('1','200',257632,'DAILY SALES','2022-05-13','2022-05-13 06:02:58','2022-05-14 06:02:58','724',0.00,0.00,'724','2022-05-13 19:42:19','724','2022-05-13 19:42:43',10,0),('1','200',257633,'DAILY SALES','2022-05-14','2022-05-14 07:05:30','2022-05-15 07:05:30','724',0.00,0.00,'724','2022-05-14 13:09:00','724','2022-05-14 13:09:46',10,0),('1','200',257634,'DAILY SALES','2022-05-15','2022-05-15 09:02:47','2022-05-16 09:02:47','724',0.00,0.00,'724','2022-05-15 09:04:28','724','2022-05-15 09:07:37',10,0),('1','200',257635,'BULK SALES','2022-05-15','2022-05-15 09:08:22','2022-05-16 09:08:22','724',0.00,0.00,'724','2022-05-15 09:18:30','724','2022-05-15 09:18:48',10,0),('1','200',257636,'DAILY SALES','2022-05-15','2022-05-15 09:57:47','2022-05-16 09:57:47','724',0.00,0.00,'724','2022-05-15 18:54:54','724','2022-05-15 18:55:20',10,0),('1','200',257637,'DAILY SALES','2022-05-16','2022-05-16 07:00:04','2022-05-17 07:00:04','724',0.00,0.00,'724','2022-05-16 18:47:11','724','2022-05-16 18:48:05',10,0),('1','200',257638,'DAILY SALES','2022-05-17','2022-05-17 06:13:39','2022-05-18 06:13:39','724',0.00,0.00,'724','2022-05-17 18:50:06','724','2022-05-17 18:50:30',10,0),('1','200',257639,'DAILY SALES try','2022-05-18','2022-05-18 06:20:54','2022-05-19 06:20:54','724',0.00,0.00,'724','2022-05-18 19:01:00','724','2022-05-18 19:01:47',10,0),('1','200',257640,'DAILY SALES','2022-05-19','2022-05-19 06:24:15','2022-05-20 06:24:15','724',0.00,0.00,'724','2022-05-19 19:29:45','724','2022-05-19 19:30:07',10,0),('1','200',257641,'DAILY SALES','2022-05-20','2022-05-20 06:27:46','2022-05-21 06:27:46','724',0.00,0.00,'724','2022-05-20 14:43:07','724','2022-05-20 14:43:49',10,0),('1','200',257642,'BULK SALES','2022-05-20','2022-05-20 14:44:25','2022-05-21 14:44:25','724',0.00,0.00,'724','2022-05-20 14:48:27','724','2022-05-20 14:48:54',10,0),('1','200',257643,'DAILY SALES','2022-05-20','2022-05-20 15:08:44','2022-05-21 15:08:44','724',0.00,0.00,'724','2022-05-20 18:38:59','724','2022-05-20 18:39:41',10,0),('1','200',257644,'DAILY SALES','2022-05-21','2022-05-21 06:57:22','2022-05-22 06:57:22','724',0.00,0.00,'724','2022-05-21 19:02:34','724','2022-05-21 19:03:14',10,0),('1','200',257645,'DAILY SALES','2022-05-22','2022-05-22 07:01:30','2022-05-23 07:01:30','724',0.00,0.00,'724','2022-05-22 19:08:08','724','2022-05-22 19:08:43',10,0),('1','200',257646,'DAILY SALES','2022-05-23','2022-05-23 07:06:17','2022-05-24 07:06:17','724',0.00,0.00,'724','2022-05-23 18:24:19','724','2022-05-23 18:24:40',10,0),('1','200',257647,'DAILY SALES','2022-05-24','2022-05-24 06:23:07','2022-05-25 06:23:07','724',0.00,0.00,'724','2022-05-24 18:55:37','724','2022-05-24 18:56:11',10,0),('1','200',257648,'DAILY SALES','2022-05-25','2022-05-25 06:27:36','2022-05-26 06:27:36','724',0.00,0.00,'724','2022-05-25 18:36:01','724','2022-05-25 18:37:02',10,0),('1','200',257649,'DAILY SALES','2022-05-26','2022-05-26 07:00:25','2022-05-27 07:00:25','724',0.00,0.00,'724','2022-05-26 18:50:28','724','2022-05-26 18:50:55',10,0),('1','200',257650,'DAILY SALES','2022-05-27','2022-05-27 06:55:03','2022-05-28 06:55:03','724',0.00,0.00,'724','2022-05-27 18:31:44','724','2022-05-27 18:32:15',10,0),('1','200',257651,'DAILY SALES','2022-05-28','2022-05-28 06:18:54','2022-05-29 06:18:54','724',0.00,0.00,'724','2022-05-28 18:55:52','724','2022-05-28 18:56:16',10,0),('1','200',257652,'DAILY SALES','2022-05-29','2022-05-29 06:51:12','2022-05-30 06:51:12','724',0.00,0.00,'724','2022-05-29 19:05:21','724','2022-05-29 19:05:50',10,0),('1','200',257653,'DAILY SALES','2022-05-30','2022-05-30 07:05:46','2022-05-31 07:05:46','724',0.00,0.00,'724','2022-05-30 19:43:32','724','2022-05-30 19:43:52',10,0),('1','200',257654,'DAILY SALES','2022-05-31','2022-05-31 06:10:30','2022-06-01 06:10:30','724',0.00,0.00,'724','2022-05-31 11:26:30','724','2022-05-31 11:27:08',10,0),('1','200',257655,'BULK SALES','2022-05-31','2022-05-31 11:27:53','2022-06-01 11:27:53','724',0.00,0.00,'724','2022-05-31 11:35:44','724','2022-05-31 11:36:06',10,0),('1','200',257656,'DAILY SALES','2022-05-31','2022-05-31 11:36:37','2022-06-01 11:36:37','724',0.00,0.00,'724','2022-05-31 19:57:46','724','2022-05-31 19:58:10',10,0),('1','200',257657,'DAILY SALES','2022-06-01','2022-06-01 06:26:35','2022-06-02 06:26:35','724',0.00,0.00,'724','2022-06-01 18:34:14','724','2022-06-01 18:36:14',10,0),('1','200',257658,'DAILY SALES','2022-06-02','2022-06-02 06:52:13','2022-06-03 06:52:13','724',0.00,0.00,'724','2022-06-02 12:21:59','724','2022-06-02 12:22:24',10,0),('1','200',257659,'OVARAGE','2022-06-02','2022-06-02 12:49:02','2022-06-03 12:49:02','724',0.00,0.00,'724','2022-06-02 12:50:37','724','2022-06-02 12:51:00',10,0),('1','200',257660,'DAILY SALES','2022-06-03','2022-06-03 06:05:48','2022-06-04 06:05:48','724',0.00,0.00,'724','2022-06-03 19:38:11','724','2022-06-03 19:38:41',10,0),('1','200',257661,'DAILY SALES','2022-06-04','2022-06-04 07:01:30','2022-06-05 07:01:30','724',0.00,0.00,'724','2022-06-04 19:39:00','724','2022-06-04 19:39:55',10,0),('1','200',257662,'DAILY SALES','2022-06-05','2022-06-05 06:02:34','2022-06-06 06:02:34','724',0.00,0.00,'724','2022-06-05 20:01:25','724','2022-06-05 20:01:55',10,0),('1','200',257663,'DAILY SALES','2022-06-06','2022-06-06 06:37:43','2022-06-07 06:37:43','724',0.00,0.00,'724','2022-06-06 19:22:22','724','2022-06-06 19:22:52',10,0),('1','200',257664,'DAILY SALES','2022-06-07','2022-06-07 07:05:02','2022-06-08 07:05:02','724',0.00,0.00,'724','2022-06-07 11:57:14','724','2022-06-07 11:57:45',10,0),('1','200',257665,'BULK SALES','2022-06-07','2022-06-07 11:58:55','2022-06-08 11:58:55','724',0.00,0.00,'724','2022-06-07 13:09:14','724','2022-06-07 13:09:39',10,0),('1','200',257666,'DAILY SALES','2022-06-08','2022-06-08 09:12:25','2022-06-09 09:12:25','724',0.00,0.00,'724','2022-06-08 18:57:14','724','2022-06-08 18:57:42',10,0),('1','200',257667,'DAILY SALES','2022-06-09','2022-06-09 07:15:58','2022-06-10 07:15:58','724',0.00,0.00,'724','2022-06-10 06:24:12','724','2022-06-10 06:24:33',10,0),('1','200',257668,'DAILY SALES','2022-06-10','2022-06-10 06:26:29','2022-06-11 06:26:29','724',0.00,0.00,'724','2022-06-10 18:55:27','724','2022-06-10 18:56:10',10,0),('1','200',257669,'DAILY SALES','2022-06-11','2022-06-11 06:27:08','2022-06-12 06:27:08','724',0.00,0.00,'724','2022-06-11 19:52:59','724','2022-06-11 19:53:29',10,0),('1','200',257670,'DAILY SALES','2022-06-12','2022-06-12 07:12:48','2022-06-13 07:12:48','724',0.00,0.00,'724','2022-06-12 09:32:36','724','2022-06-12 09:33:37',10,0),('1','200',257671,'BULK SALES','2022-06-12','2022-06-12 09:35:33','2022-06-13 09:35:33','724',0.00,0.00,'724','2022-06-12 10:25:25','724','2022-06-12 10:25:48',10,0),('1','200',257672,'DAILY SALES','2022-06-13','2022-06-13 06:45:13','2022-06-14 06:45:13','724',0.00,0.00,'724','2022-06-13 18:49:36','724','2022-06-13 18:50:18',10,0),('1','200',257673,'DAILY SALES','2022-06-14','2022-06-14 07:01:54','2022-06-15 07:01:54','724',0.00,0.00,'724','2022-06-14 18:36:30','724','2022-06-14 18:37:05',10,0),('1','200',257674,'DAILY SALES','2022-06-15','2022-06-15 07:23:55','2022-06-16 07:23:55','724',0.00,0.00,'724','2022-06-15 18:41:14','724','2022-06-15 18:41:47',10,0),('1','200',257675,'DAILY SALES','2022-06-16','2022-06-16 07:21:00','2022-06-17 07:21:00','724',0.00,0.00,'724','2022-06-16 18:57:18','724','2022-06-16 18:57:57',10,0),('1','200',257676,'DAILY SALES','2022-06-17','2022-06-17 07:14:26','2022-06-18 07:14:26','724',0.00,0.00,'724','2022-06-17 18:45:42','724','2022-06-17 18:46:14',10,0),('1','200',257677,'DAILY SALES','2022-06-18','2022-06-18 06:41:26','2022-06-19 06:41:26','724',0.00,0.00,'724','2022-06-18 18:35:29','724','2022-06-18 18:36:25',10,0),('1','200',257678,'DAILY SALES','2022-06-19','2022-06-19 07:13:11','2022-06-20 07:13:11','724',0.00,0.00,'724','2022-06-19 18:10:22','724','2022-06-19 18:10:49',10,0),('1','200',257679,'DAILY SALES','2022-06-20','2022-06-20 07:13:11','2022-06-21 07:13:11','724',0.00,0.00,'724','2022-06-20 18:32:55','724','2022-06-20 18:33:30',10,0),('1','200',257680,'DAILY SALES','2022-06-21','2022-06-21 07:11:33','2022-06-22 07:11:33','724',0.00,0.00,'724','2022-06-21 18:24:09','724','2022-06-21 18:24:59',10,0),('1','200',257681,'DAILY SALES','2022-06-22','2022-06-22 07:18:49','2022-06-23 07:18:49','724',0.00,0.00,'724','2022-06-22 18:36:57','724','2022-06-22 18:37:28',10,0),('1','200',257682,'DAILY SALES','2022-06-23','2022-06-23 07:12:32','2022-06-24 07:12:32','724',0.00,0.00,'724','2022-06-23 10:53:15','724','2022-06-23 10:53:37',10,0),('1','200',257683,'BULK SALES','2022-06-23','2022-06-23 10:54:44','2022-06-24 10:54:44','724',0.00,0.00,'724','2022-06-23 10:58:12','724','2022-06-23 10:58:29',10,0),('1','200',257684,'BULK SALES','2022-06-23','2022-06-23 11:02:28','2022-06-24 11:02:28','724',0.00,0.00,'724','2022-06-23 11:06:27','724','2022-06-23 11:06:44',10,0),('1','200',257685,'DAILY SALES','2022-06-23','2022-06-23 11:19:20','2022-06-24 11:19:20','724',0.00,0.00,'724','2022-06-23 18:32:34','724','2022-06-23 18:33:06',10,0),('1','200',257686,'DAILY SALES','2022-06-24','2022-06-24 07:07:33','2022-06-25 07:07:33','724',0.00,0.00,'724','2022-06-24 18:47:32','724','2022-06-24 18:48:00',10,0),('1','200',257687,'DAILY SALES','2022-06-25','2022-06-25 07:16:35','2022-06-26 07:16:35','724',0.00,0.00,'724','2022-06-25 18:16:05','724','2022-06-25 18:16:31',10,0),('1','200',257688,'DAILY SALES','2022-06-26','2022-06-26 07:18:36','2022-06-27 07:18:36','724',0.00,0.00,'724','2022-06-26 19:15:53','724','2022-06-26 19:16:48',10,0),('1','200',257689,'DAILY SALES','2022-06-27','2022-06-27 07:12:25','2022-06-28 07:12:25','724',0.00,0.00,'724','2022-06-27 18:23:38','724','2022-06-27 18:24:24',10,0),('1','200',257690,'DAILY SALES','2022-06-28','2022-06-28 07:05:31','2022-06-29 07:05:31','724',0.00,0.00,'724','2022-06-28 18:42:45','724','2022-06-28 18:43:35',10,0),('1','200',257691,'DAILY SALES','2022-06-29','2022-06-29 07:11:49','2022-06-30 07:11:49','724',0.00,0.00,'724','2022-06-29 18:46:07','724','2022-06-29 18:46:52',10,0),('1','200',257692,'DAILY SALES','2022-06-30','2022-06-30 07:07:26','2022-07-01 07:07:26','724',0.00,0.00,'724','2022-06-30 16:00:32','724','2022-06-30 16:01:01',10,0),('1','200',257693,'BULK SALES','2022-06-30','2022-06-30 16:02:32','2022-07-01 16:02:32','724',0.00,0.00,'724','2022-07-01 09:14:21','724','2022-07-01 09:14:54',10,0),('1','200',257694,'DAILY SALES','2022-07-02','2022-07-02 08:19:48','2022-07-03 08:19:48','724',0.00,0.00,'724','2022-07-02 19:11:43','724','2022-07-02 19:12:22',10,0),('1','200',257695,'DAILY SALES','2022-07-03','2022-07-03 07:19:17','2022-07-04 07:19:17','724',0.00,0.00,'724','2022-07-03 19:40:15','724','2022-07-03 19:40:58',10,0),('1','200',257696,'DAILY SALES','2022-07-04','2022-07-04 07:14:38','2022-07-05 07:14:38','724',0.00,0.00,'724','2022-07-04 19:02:08','724','2022-07-04 19:03:05',10,0),('1','200',257697,'DAILY SALES','2022-07-05','2022-07-05 07:05:41','2022-07-06 07:05:41','724',0.00,0.00,'724','2022-07-05 20:14:30','724','2022-07-05 20:14:52',10,0),('1','200',257698,'DAILY SALES','2022-07-06','2022-07-06 07:06:03','2022-07-07 07:06:03','724',0.00,0.00,'724','2022-07-06 19:20:48','724','2022-07-06 19:21:24',10,0),('1','200',257699,'DAILY SALES','2022-07-07','2022-07-07 07:24:46','2022-07-08 07:24:46','724',0.00,0.00,'724','2022-07-07 21:49:32','724','2022-07-07 21:49:58',10,0),('1','200',257700,'DAILY SALES','2022-07-08','2022-07-08 07:17:54','2022-07-09 07:17:54','724',0.00,0.00,'724','2022-07-08 20:54:25','724','2022-07-08 20:55:22',10,0),('1','200',257701,'DAILY SALES','2022-07-09','2022-07-09 12:01:35','2022-07-10 12:01:35','724',0.00,0.00,'724','2022-07-09 17:59:07','724','2022-07-09 17:59:44',10,0),('1','200',257702,'DAILY SALES','2022-07-10','2022-07-10 07:23:59','2022-07-11 07:23:59','724',0.00,0.00,'724','2022-07-10 10:10:18','724','2022-07-10 10:10:45',10,0),('1','200',257703,'BULK SALES','2022-07-10','2022-07-10 10:11:18','2022-07-11 10:11:18','724',0.00,0.00,'724','2022-07-10 10:24:06','724','2022-07-10 10:24:36',10,0),('1','200',257704,'DAILY SALES','2022-07-10','2022-07-10 10:32:44','2022-07-11 10:32:44','724',0.00,0.00,'724','2022-07-10 18:32:36','724','2022-07-10 18:33:08',10,0),('1','200',257705,'DAILY SALES','2022-07-11','2022-07-11 07:19:12','2022-07-12 07:19:12','724',0.00,0.00,'724','2022-07-11 18:21:38','724','2022-07-11 18:22:23',10,0),('1','200',257706,'DAILY SALES','2022-07-12','2022-07-12 07:24:24','2022-07-13 07:24:24','724',0.00,0.00,'724','2022-07-12 18:40:40','724','2022-07-12 18:55:18',10,0),('1','200',257707,'DAILY SALES','2022-07-13','2022-07-13 07:04:04','2022-07-14 07:04:04','724',0.00,0.00,'724','2022-07-13 19:29:19','724','2022-07-13 19:31:05',10,0),('1','200',257708,'DAILY SALES','2022-07-14','2022-07-14 07:25:17','2022-07-15 07:25:17','724',0.00,0.00,'724','2022-07-14 14:04:29','724','2022-07-14 14:05:27',10,0),('1','200',257709,'BULK SALES','2022-07-14','2022-07-14 14:06:57','2022-07-15 14:06:57','724',0.00,0.00,'724','2022-07-14 14:21:54','724','2022-07-14 14:22:21',10,0),('1','200',257710,'DAILY SALES','2022-07-14','2022-07-14 15:08:13','2022-07-15 15:08:13','724',0.00,0.00,'724','2022-07-14 18:39:06','724','2022-07-15 07:21:34',10,0),('1','200',257711,'DAILY SALES','2022-07-15','2022-07-15 07:22:09','2022-07-16 07:22:09','724',0.00,0.00,'724','2022-07-15 18:46:25','724','2022-07-15 18:49:31',10,0),('1','200',257712,'DAILY SALES','2022-07-16','2022-07-16 07:58:21','2022-07-17 07:58:21','724',0.00,0.00,'724','2022-07-16 18:48:40','724','2022-07-16 18:52:25',10,0),('1','200',257713,'DAILY SALES','2022-07-17','2022-07-17 07:28:41','2022-07-18 07:28:41','724',0.00,0.00,'724','2022-07-17 18:52:53','724','2022-07-17 18:55:40',10,0),('1','200',257714,'DAILY SALES','2022-07-18','2022-07-18 07:17:19','2022-07-19 07:17:19','724',0.00,0.00,'724','2022-07-18 18:59:47','724','2022-07-18 19:00:53',10,0),('1','200',257715,'DAILY SALES','2022-07-19','2022-07-19 07:05:37','2022-07-20 07:05:37','724',0.00,0.00,'724','2022-07-19 18:14:59','724','2022-07-19 18:17:52',10,0),('1','200',257716,'BULK SALES','2022-07-19','2022-07-19 18:18:44','2022-07-20 18:18:44','724',0.00,0.00,'724','2022-07-19 18:24:06','724','2022-07-19 18:24:57',10,0),('1','200',257717,'DAILY SALES','2022-07-20','2022-07-20 07:17:03','2022-07-21 07:17:03','724',0.00,0.00,'724','2022-07-20 19:01:29','724','2022-07-20 19:02:03',10,0),('1','200',257718,'DAILY SALES','2022-07-21','2022-07-21 07:15:04','2022-07-22 07:15:04','724',0.00,0.00,'724','2022-07-21 18:52:45','724','2022-07-21 18:53:32',10,0),('1','200',257719,'DAILY SALES','2022-07-22','2022-07-22 07:24:12','2022-07-23 07:24:12','724',0.00,0.00,'724','2022-07-22 18:51:59','724','2022-07-22 18:53:20',10,0),('1','200',257720,'DAILY SALES','2022-07-23','2022-07-23 07:16:39','2022-07-24 07:16:39','724',0.00,0.00,'724','2022-07-23 19:11:25','724','2022-07-23 19:11:57',10,0),('1','200',257721,'DAILY SALES','2022-07-24','2022-07-24 07:08:04','2022-07-25 07:08:04','724',0.00,0.00,'724','2022-07-24 19:15:01','724','2022-07-24 19:15:38',10,0),('1','200',257722,'DAILY SALES','2022-07-25','2022-07-25 07:06:59','2022-07-26 07:06:59','724',0.00,0.00,'724','2022-07-25 18:26:54','724','2022-07-25 18:27:49',10,0),('1','200',257723,'DAILY SALES','2022-07-26','2022-07-26 07:44:44','2022-07-27 07:44:44','724',0.00,0.00,'724','2022-07-26 19:02:44','724','2022-07-26 19:03:29',10,0),('1','200',257724,'DAILY SALES','2022-07-27','2022-07-27 06:30:17','2022-07-28 06:30:17','724',0.00,0.00,'724','2022-07-27 19:02:56','724','2022-07-27 19:03:30',10,0),('1','200',257725,'DAILY SALES','2022-07-28','2022-07-28 08:29:43','2022-07-29 08:29:43','724',0.00,0.00,'724','2022-07-28 19:03:55','724','2022-07-28 19:04:27',10,0),('1','200',257726,'DAILY SALES','2022-07-29','2022-07-29 06:43:32','2022-07-30 06:43:32','724',0.00,0.00,'724','2022-07-29 19:51:35','724','2022-07-29 19:52:01',10,0),('1','200',257727,'BULK SALES','2022-07-29','2022-07-29 19:53:07','2022-07-30 19:53:07','724',0.00,0.00,'724','2022-07-29 19:57:12','724','2022-07-29 19:57:43',10,0),('1','200',257728,'DAILY SALES','2022-07-30','2022-07-30 06:39:02','2022-07-31 06:39:02','724',0.00,0.00,'724','2022-07-30 19:31:36','724','2022-07-30 19:32:02',10,0),('1','200',257729,'DAILY SALES','2022-07-31','2022-07-31 06:43:26','2022-08-01 06:43:26','724',0.00,0.00,'724','2022-07-31 19:48:54','724','2022-07-31 19:49:24',10,0),('1','200',257730,'DAILY SALES','2022-08-01','2022-08-01 07:04:00','2022-08-02 07:04:00','724',0.00,0.00,'724','2022-08-01 19:37:28','724','2022-08-01 19:38:07',10,0),('1','200',257731,'DAILY SALES','2022-08-02','2022-08-02 06:28:10','2022-08-03 06:28:10','724',0.00,0.00,'724','2022-08-02 19:29:26','724','2022-08-02 19:29:50',10,0),('1','200',257732,'BULK SALES','2022-08-02','2022-08-02 19:30:31','2022-08-03 19:30:31','724',0.00,0.00,'724','2022-08-02 19:35:11','724','2022-08-02 19:35:39',10,0),('1','200',257733,'DAILY SALES','2022-08-03','2022-08-03 07:00:41','2022-08-04 07:00:41','724',0.00,0.00,'724','2022-08-03 19:32:03','724','2022-08-03 19:33:34',10,0),('1','200',257734,'DAILY SALES','2022-08-04','2022-08-04 06:11:38','2022-08-05 06:11:38','724',0.00,0.00,'724','2022-08-04 19:45:19','724','2022-08-04 19:46:01',10,0),('1','200',257735,'DAILY SALES','2022-08-05','2022-08-05 07:05:08','2022-08-06 07:05:08','724',0.00,0.00,'724','2022-08-05 20:13:35','724','2022-08-05 20:14:04',10,0),('1','200',257736,'DAILY SALES','2022-08-06','2022-08-06 06:58:38','2022-08-07 06:58:38','724',0.00,0.00,'724','2022-08-06 18:14:06','724','2022-08-06 18:15:05',10,0),('1','200',257737,'BULK SALES','2022-08-06','2022-08-06 18:17:20','2022-08-07 18:17:20','724',0.00,0.00,'724','2022-08-06 18:26:19','724','2022-08-06 18:26:51',10,0),('1','200',257738,'DAILY SALES','2022-08-09','2022-08-09 08:25:14','2022-08-10 08:25:14','724',0.00,0.00,'724','2022-08-09 20:35:20','724','2022-08-09 20:36:13',10,0),('1','200',257739,'DAILY SALES','2022-08-10','2022-08-10 06:05:27','2022-08-11 06:05:27','724',0.00,0.00,'724','2022-08-10 19:32:57','724','2022-08-10 19:33:25',10,0),('1','200',257740,'DAILY SALES','2022-08-11','2022-08-11 06:10:10','2022-08-12 06:10:10','724',0.00,0.00,'724','2022-08-11 19:00:39','724','2022-08-11 19:01:18',10,0),('1','200',257741,'DAILY SALES','2022-08-12','2022-08-12 06:55:40','2022-08-13 06:55:40','724',0.00,0.00,'724','2022-08-12 19:19:21','724','2022-08-12 19:19:51',10,0),('1','200',257742,'DAILY SALES','2022-08-13','2022-08-13 06:37:47','2022-08-14 06:37:47','724',0.00,0.00,'724','2022-08-14 06:38:21','724','2022-08-14 06:38:49',10,0),('1','200',257743,'DAILY SALES','2022-08-14','2022-08-14 06:40:00','2022-08-15 06:40:00','724',0.00,0.00,'724','2022-08-15 06:57:22','724','2022-08-15 06:57:48',10,0),('1','200',257744,'DAILY SALES','2022-08-15','2022-08-15 06:58:57','2022-08-16 06:58:57','724',0.00,0.00,'724','2022-08-15 19:26:06','724','2022-08-15 19:26:30',10,0),('1','200',257745,'DAILY SALES','2022-08-16','2022-08-16 06:19:39','2022-08-17 06:19:39','724',0.00,0.00,'724','2022-08-17 07:43:12','724','2022-08-17 07:43:45',10,0),('1','200',257746,'DAILY SALES','2022-08-17','2022-08-17 07:45:51','2022-08-18 07:45:51','724',0.00,0.00,'724','2022-08-17 18:41:27','724','2022-08-17 18:42:26',10,0),('1','200',257747,'DAILY SALES','2022-08-18','2022-08-18 07:16:40','2022-08-19 07:16:40','724',0.00,0.00,'724','2022-08-19 07:15:49','724','2022-08-19 07:16:17',10,0),('1','200',257748,'DAILY SALES','2022-08-19','2022-08-19 07:16:49','2022-08-20 07:16:49','724',0.00,0.00,'724','2022-08-19 18:50:35','724','2022-08-19 18:51:35',10,0),('1','200',257749,'DAILY SALES','2022-08-20','2022-08-20 07:16:47','2022-08-21 07:16:47','724',0.00,0.00,'724','2022-08-20 18:38:09','724','2022-08-20 18:39:38',10,0),('1','200',257750,'DAILY SALES','2022-08-21','2022-08-21 07:18:09','2022-08-22 07:18:09','724',0.00,0.00,'724','2022-08-21 18:39:56','724','2022-08-21 18:40:21',10,0),('1','200',257751,'DAILY SALES','2022-08-22','2022-08-22 07:34:22','2022-08-23 07:34:22','724',0.00,0.00,'724','2022-08-22 19:11:11','724','2022-08-22 19:11:42',10,0),('1','200',257752,'BULK SALES','2022-08-22','2022-08-22 19:12:36','2022-08-23 19:12:36','724',0.00,0.00,'724','2022-08-22 19:19:33','724','2022-08-22 19:19:57',10,0),('1','200',257753,'DAILY SALES','2022-08-23','2022-08-23 07:32:36','2022-08-24 07:32:36','724',0.00,0.00,'724','2022-08-23 18:42:43','724','2022-08-23 18:43:34',10,0),('1','200',257754,'DAILY SALES','2022-08-24','2022-08-24 07:03:39','2022-08-25 07:03:39','724',0.00,0.00,'724','2022-08-25 07:20:47','724','2022-08-25 07:21:11',10,0),('1','200',257755,'DAILY SALES','2022-08-25','2022-08-25 07:21:34','2022-08-26 07:21:34','724',0.00,0.00,'724','2022-08-25 19:41:02','724','2022-08-25 19:41:28',10,0),('1','200',257756,'DAILY SALES ','2022-08-26','2022-08-26 07:05:25','2022-08-27 07:05:25','724',0.00,0.00,'724','2022-08-26 18:34:06','724','2022-08-26 18:34:42',10,0),('1','200',257757,'DAILY SALES ','2022-08-27','2022-08-27 06:56:40','2022-08-28 06:56:40','724',0.00,0.00,'724','2022-08-27 19:10:55','724','2022-08-27 19:12:04',10,0),('1','200',257758,'DAILY SALES ','2022-08-28','2022-08-28 07:03:51','2022-08-29 07:03:51','724',0.00,0.00,'724','2022-08-28 18:32:17','724','2022-08-28 18:32:49',10,0),('1','200',257759,'DAILY SALES ','2022-08-29','2022-08-29 06:31:24','2022-08-30 06:31:24','724',0.00,0.00,'724','2022-08-29 19:26:44','724','2022-08-29 19:27:11',10,0),('1','200',257760,'DAILY SALES ','2022-08-30','2022-08-30 06:57:13','2022-08-31 06:57:13','724',0.00,0.00,'724','2022-08-30 18:38:10','724','2022-08-30 18:39:06',10,0),('1','200',257761,'DAILY SALES ','2022-08-31','2022-08-31 07:12:26','2022-09-01 07:12:26','724',0.00,0.00,'724','2022-08-31 19:27:42','724','2022-08-31 19:28:44',10,0),('1','200',257762,'DAILY SALES ','2022-09-01','2022-09-01 07:17:54','2022-09-02 07:17:54','724',0.00,0.00,'724','2022-09-01 19:25:18','724','2022-09-01 19:25:59',10,0),('1','200',257763,'DAILY SALES ','2022-09-02','2022-09-02 07:02:39','2022-09-03 07:02:39','724',0.00,0.00,'724','2022-09-02 14:29:56','724','2022-09-02 14:30:24',10,0),('1','200',257764,'BULK SALES','2022-09-02','2022-09-02 14:30:47','2022-09-03 14:30:47','724',0.00,0.00,'724','2022-09-02 14:34:04','724','2022-09-02 14:34:27',10,0),('1','200',257765,'DAILY SALES','2022-09-02','2022-09-02 14:37:26','2022-09-03 14:37:26','724',0.00,0.00,'724','2022-09-02 19:19:51','724','2022-09-02 19:20:19',10,0),('1','200',257766,'DAILY SALES ','2022-09-03','2022-09-03 06:12:05','2022-09-04 06:12:05','724',0.00,0.00,'724','2022-09-03 19:39:42','724','2022-09-03 19:40:19',10,0),('1','200',257767,'DAILY SALES ','2022-09-04','2022-09-04 06:56:13','2022-09-05 06:56:13','724',0.00,0.00,'724','2022-09-04 18:59:19','724','2022-09-04 18:59:46',10,0),('1','200',257768,'DAILY SALES ','2022-09-05','2022-09-05 07:33:21','2022-09-06 07:33:21','724',0.00,0.00,'724','2022-09-05 18:57:19','724','2022-09-05 18:57:46',10,0),('1','200',257769,'DAILY SALES ','2022-09-06','2022-09-06 07:22:22','2022-09-07 07:22:22','724',0.00,0.00,'724','2022-09-06 21:06:08','724','2022-09-06 21:07:13',10,0),('1','200',257770,'DAILY SALES ','2022-09-07','2022-09-07 07:25:38','2022-09-08 07:25:38','724',0.00,0.00,'724','2022-09-07 19:09:58','724','2022-09-07 19:11:24',10,0),('1','200',257771,'DAILY SALES','2022-09-08','2022-09-08 07:23:04','2022-09-09 07:23:04','724',0.00,0.00,'724','2022-09-08 19:22:22','724','2022-09-08 19:22:50',10,0),('1','200',257772,'DAILY SALES ','2022-09-09','2022-09-09 06:35:58','2022-09-10 06:35:58','724',0.00,0.00,'724','2022-09-09 18:50:52','724','2022-09-09 18:51:23',10,0),('1','200',257773,'DAILY SALES ','2022-09-10','2022-09-10 06:21:12','2022-09-11 06:21:12','724',0.00,0.00,'724','2022-09-11 07:10:12','724','2022-09-11 07:11:54',10,0),('1','200',257774,'DAILY SALES ','2022-09-11','2022-09-11 07:12:52','2022-09-12 07:12:52','724',0.00,0.00,'724','2022-09-11 19:18:02','724','2022-09-11 19:18:29',10,0),('1','200',257775,'DAILY SALES','2022-09-12','2022-09-12 07:35:22','2022-09-13 07:35:22','724',0.00,0.00,'724','2022-09-12 19:33:15','724','2022-09-12 19:39:19',10,0),('1','200',257776,'DAILY SALES ','2022-09-13','2022-09-13 07:14:32','2022-09-14 07:14:32','724',0.00,0.00,'724','2022-09-13 19:04:43','724','2022-09-13 19:05:08',10,0),('1','200',257777,'DAILY SALES ','2022-09-14','2022-09-14 06:39:06','2022-09-15 06:39:06','724',0.00,0.00,'724','2022-09-14 18:40:15','724','2022-09-14 18:40:45',10,0),('1','200',257778,'DAILY SALES ','2022-09-15','2022-09-15 06:17:03','2022-09-16 06:17:03','724',0.00,0.00,'724','2022-09-15 18:52:22','724','2022-09-15 18:54:00',10,0),('1','200',257779,'DAILY SALES ','2022-09-16','2022-09-16 06:31:32','2022-09-17 06:31:32','724',0.00,0.00,'724','2022-09-16 19:50:10','724','2022-09-16 19:51:34',10,0),('1','200',257780,'DAILY SALES ','2022-09-17','2022-09-17 06:38:04','2022-09-18 06:38:04','724',0.00,0.00,'724','2022-09-17 19:27:43','724','2022-09-17 19:28:49',10,0),('1','200',257781,'DAILY SALES ','2022-09-18','2022-09-18 07:07:35','2022-09-19 07:07:35','724',0.00,0.00,'724','2022-09-18 18:39:24','724','2022-09-18 18:40:26',10,0),('1','200',257782,'DAILY SALES ','2022-09-19','2022-09-19 06:16:10','2022-09-20 06:16:10','724',0.00,0.00,'724','2022-09-19 19:21:26','724','2022-09-19 19:22:26',10,0),('1','200',257783,'DAILY SALES ','2022-09-20','2022-09-20 06:35:40','2022-09-21 06:35:40','724',0.00,0.00,'724','2022-09-20 19:19:42','724','2022-09-20 19:20:48',10,0),('1','200',257784,'DAILY SALES ','2022-09-21','2022-09-21 07:21:48','2022-09-22 07:21:48','724',0.00,0.00,'724','2022-09-21 18:23:24','724','2022-09-21 18:24:20',10,0),('1','200',257785,'DAILY SALES','2022-09-22','2022-09-22 07:01:19','2022-09-23 07:01:19','724',0.00,0.00,'724','2022-09-22 07:05:53','724','2022-09-22 07:06:35',10,0),('1','200',257786,'BULK SALES','2022-09-22','2022-09-22 07:08:34','2022-09-23 07:08:34','724',0.00,0.00,'724','2022-09-22 07:41:47','724','2022-09-22 07:42:15',10,0),('1','200',257787,'DAILY SALES','2022-09-22','2022-09-22 09:01:48','2022-09-23 09:01:48','724',0.00,0.00,'724','2022-09-22 19:39:19','724','2022-09-22 19:40:15',10,0),('1','200',257788,'DAILY SALES','2022-09-23','2022-09-23 07:06:54','2022-09-24 07:06:54','724',0.00,0.00,'724','2022-09-23 18:56:52','724','2022-09-23 18:57:48',10,0),('1','200',257789,'DAILY SALES','2022-09-24','2022-09-24 07:09:41','2022-09-25 07:09:41','724',0.00,0.00,'724','2022-09-24 19:17:10','724','2022-09-24 19:20:19',10,0),('1','200',257790,'DAILY SALES ','2022-09-25','2022-09-25 06:45:03','2022-09-26 06:45:03','724',0.00,0.00,'724','2022-09-25 18:49:48','724','2022-09-25 18:51:15',10,0),('1','200',257791,'DAILY SALES','2022-09-26','2022-09-26 07:09:11','2022-09-27 07:09:11','724',0.00,0.00,'724','2022-09-26 18:56:19','724','2022-09-26 18:57:15',10,0),('1','200',257792,'DAILY SALES','2022-09-27','2022-09-27 07:10:11','2022-09-28 07:10:11','724',0.00,0.00,'724','2022-09-27 19:02:33','724','2022-09-27 19:03:25',10,0),('1','200',257793,'DAILY SALES','2022-09-28','2022-09-28 07:07:02','2022-09-29 07:07:02','724',0.00,0.00,'724','2022-09-28 19:18:18','724','2022-09-28 19:19:18',10,0),('1','200',257794,'DAILY SALES ','2022-09-29','2022-09-29 07:05:36','2022-09-30 07:05:36','724',0.00,0.00,'724','2022-09-29 19:32:11','724','2022-09-29 19:33:32',10,0),('1','200',257795,'DAILY SALES','2022-09-30','2022-09-30 07:06:59','2022-10-01 07:06:59','724',0.00,0.00,'724','2022-09-30 14:37:12','724','2022-09-30 14:37:49',10,0),('1','200',257796,'BULK SALES','2022-09-30','2022-09-30 14:39:44','2022-10-01 14:39:44','724',0.00,0.00,'724','2022-09-30 14:42:56','724','2022-09-30 14:43:27',10,0),('1','200',257797,'DAILY SALES','2022-09-30','2022-09-30 14:48:28','2022-10-01 14:48:28','724',0.00,0.00,'724','2022-09-30 19:27:37','724','2022-09-30 19:28:27',10,0),('1','200',257798,'DAILY SALES','2022-10-01','2022-10-01 07:10:50','2022-10-02 07:10:50','724',0.00,0.00,'724','2022-10-01 19:52:26','724','2022-10-01 19:53:45',10,0),('1','200',257799,'DAILY SALES','2022-10-02','2022-10-02 07:11:00','2022-10-03 07:11:00','724',0.00,0.00,'724','2022-10-02 18:58:27','724','2022-10-02 18:59:30',10,0),('1','200',257800,'DAILY SALES','2022-10-03','2022-10-03 07:09:40','2022-10-04 07:09:40','724',0.00,0.00,'724','2022-10-03 18:31:09','724','2022-10-03 18:32:03',10,0),('1','200',257801,'DAILY SALES','2022-10-04','2022-10-04 07:07:45','2022-10-05 07:07:45','724',0.00,0.00,'724','2022-10-04 15:12:12','724','2022-10-04 15:12:40',10,0),('1','200',257802,'OVARAGE','2022-10-04','2022-10-04 15:15:25','2022-10-05 15:15:25','724',0.00,0.00,'724','2022-10-04 15:45:47','724','2022-10-04 15:46:10',10,0),('1','200',257803,'DAILY SALES','2022-10-06','2022-10-06 12:29:31','2022-10-07 12:29:31','724',0.00,0.00,'724','2022-10-06 19:08:54','724','2022-10-06 19:10:01',10,0),('1','200',257804,'DAILY SALES','2022-10-07','2022-10-07 07:10:39','2022-10-08 07:10:39','724',0.00,0.00,'724','2022-10-07 19:20:33','724','2022-10-07 19:21:02',10,0),('1','200',257805,'DAILY SALES','2022-10-08','2022-10-08 07:09:42','2022-10-09 07:09:42','724',0.00,0.00,'724','2022-10-08 19:40:49','724','2022-10-08 19:41:41',10,0),('1','200',257806,'DAILY SALES','2022-10-09','2022-10-09 07:15:39','2022-10-10 07:15:39','724',0.00,0.00,'724','2022-10-09 19:54:56','724','2022-10-09 19:55:34',10,0),('1','200',257807,'DAILY SALES','2022-10-10','2022-10-10 07:09:24','2022-10-11 07:09:24','724',0.00,0.00,'724','2022-10-10 15:30:35','724','2022-10-10 15:31:10',10,0),('1','200',257808,'BULK SALES','2022-10-10','2022-10-10 15:31:53','2022-10-11 15:31:53','724',0.00,0.00,'724','2022-10-10 15:42:57','724','2022-10-10 15:43:31',10,0),('1','200',257809,'DAILY SALES','2022-10-11','2022-10-11 08:10:00','2022-10-12 08:10:00','724',0.00,0.00,'724','2022-10-11 18:54:49','724','2022-10-11 18:55:29',10,0),('1','200',257810,'DAILY SALES','2022-10-12','2022-10-12 07:11:46','2022-10-13 07:11:46','724',0.00,0.00,'724','2022-10-12 18:46:10','724','2022-10-12 18:47:17',10,0),('1','200',257811,'DAILY SALES','2022-10-13','2022-10-13 07:12:12','2022-10-14 07:12:12','724',0.00,0.00,'724','2022-10-13 19:47:14','724','2022-10-13 19:50:10',10,0),('1','200',257812,'DAILY SALES','2022-10-14','2022-10-14 07:10:24','2022-10-15 07:10:24','724',0.00,0.00,'724','2022-10-14 19:10:08','724','2022-10-14 19:10:45',10,0),('1','200',257813,'BULK SALES','2022-10-14','2022-10-14 19:28:55','2022-10-15 19:28:55','724',0.00,0.00,'724','2022-10-14 19:36:45','724','2022-10-14 19:37:19',10,0),('1','200',257814,'DAILY SALES','2022-10-15','2022-10-15 08:41:34','2022-10-16 08:41:34','724',0.00,0.00,'724','2022-10-15 19:06:18','724','2022-10-15 19:07:09',10,0),('1','200',257815,'DAILY SALES','2022-10-16','2022-10-16 07:08:21','2022-10-17 07:08:21','724',0.00,0.00,'724','2022-10-16 19:42:16','724','2022-10-16 19:42:57',10,0),('1','200',257816,'DAILY SALES','2022-10-17','2022-10-17 07:04:53','2022-10-18 07:04:53','724',0.00,0.00,'724','2022-10-17 19:56:29','724','2022-10-17 20:24:15',10,0),('1','200',257817,'DAILY SALES','2022-10-18','2022-10-18 07:09:04','2022-10-19 07:09:04','724',0.00,0.00,'724','2022-10-18 19:38:19','724','2022-10-18 19:38:54',10,0),('1','200',257818,'BULK SALES','2022-10-18','2022-10-18 19:40:14','2022-10-19 19:40:14','724',0.00,0.00,'724','2022-10-18 19:46:52','724','2022-10-18 19:47:20',10,0),('1','200',257819,'DAILY SALES','2022-10-23','2022-10-23 09:41:03','2022-10-24 09:41:03','724',0.00,0.00,'724','2022-10-23 19:30:56','724','2022-10-23 19:31:34',10,0),('1','200',257820,'DAILY SALES','2022-10-24','2022-10-24 07:15:09','2022-10-25 07:15:09','724',0.00,0.00,'724','2022-10-24 19:17:40','724','2022-10-24 19:18:08',10,0),('1','200',257821,'DAILY SALES','2022-10-25','2022-10-25 07:09:25','2022-10-26 07:09:25','724',0.00,0.00,'724','2022-10-25 18:38:11','724','2022-10-25 18:40:05',10,0),('1','200',257822,'DAILY SALES','2022-10-26','2022-10-26 07:11:05','2022-10-27 07:11:05','724',0.00,0.00,'724','2022-10-26 18:58:33','724','2022-10-26 18:59:12',10,0),('1','200',257823,'DAILY SALES','2022-10-27','2022-10-27 07:09:37','2022-10-28 07:09:37','724',0.00,0.00,'724','2022-10-27 18:52:14','724','2022-10-27 18:52:47',10,0),('1','200',257824,'DAILY SALES','2022-10-28','2022-10-28 07:08:48','2022-10-29 07:08:48','724',0.00,0.00,'724','2022-10-28 19:17:05','724','2022-10-28 19:17:42',10,0),('1','200',257825,'DAILY SALES','2022-10-29','2022-10-29 07:12:54','2022-10-30 07:12:54','724',0.00,0.00,'724','2022-10-29 19:16:09','724','2022-10-29 19:16:40',10,0),('1','200',257826,'DAILY SALES','2022-10-30','2022-10-30 07:08:28','2022-10-31 07:08:28','724',0.00,0.00,'724','2022-10-30 19:16:50','724','2022-10-30 19:17:22',10,0),('1','200',257827,'DAILY SALES','2022-10-31','2022-10-31 07:08:03','2022-11-01 07:08:03','724',0.00,0.00,'724','2022-10-31 20:47:22','724','2022-10-31 20:48:23',10,0),('1','200',257828,'DAILY SALES','2022-11-01','2022-11-01 07:01:07','2022-11-02 07:01:07','724',0.00,0.00,'724','2022-11-01 19:51:03','724','2022-11-01 19:51:42',10,0),('1','200',257829,'DAILY SALES','2022-11-02','2022-11-02 07:02:31','2022-11-03 07:02:31','724',0.00,0.00,'724','2022-11-02 19:32:51','724','2022-11-02 19:33:29',10,0),('1','200',257830,'DAILY SALES','2022-11-03','2022-11-03 07:12:54','2022-11-04 07:12:54','724',0.00,0.00,'724','2022-11-03 19:45:34','724','2022-11-03 19:46:12',10,0),('1','200',257831,'DAILY SALES','2022-11-04','2022-11-04 07:26:26','2022-11-05 07:26:26','724',0.00,0.00,'724','2022-11-04 19:08:55','724','2022-11-04 19:09:42',10,0),('1','200',257832,'DAILY SALES','2022-11-05','2022-11-05 08:09:45','2022-11-06 08:09:45','724',0.00,0.00,'724','2022-11-05 16:14:54','724','2022-11-05 16:15:46',10,0),('1','200',257833,'BULK SALES','2022-11-05','2022-11-05 16:16:38','2022-11-06 16:16:38','724',0.00,0.00,'724','2022-11-05 16:21:03','724','2022-11-05 16:21:35',10,0),('1','200',257834,'DAILY SALES ','2022-11-05','2022-11-05 16:22:09','2022-11-06 16:22:09','724',0.00,0.00,'724','2022-11-05 19:31:33','724','2022-11-05 19:31:59',10,0),('1','200',257835,'DAILY SALES','2022-11-06','2022-11-06 07:48:32','2022-11-07 07:48:32','724',0.00,0.00,'724','2022-11-06 19:06:22','724','2022-11-06 19:06:46',10,0),('1','200',257836,'DAILY SALES','2022-11-07','2022-11-07 07:07:22','2022-11-08 07:07:22','724',0.00,0.00,'724','2022-11-07 19:03:37','724','2022-11-07 19:04:16',10,0),('1','200',257837,'DAILY SALES','2022-11-08','2022-11-08 07:23:27','2022-11-09 07:23:27','724',0.00,0.00,'724','2022-11-08 19:17:17','724','2022-11-08 19:18:06',10,0),('1','200',257838,'DAILY SALES','2022-11-09','2022-11-09 07:13:40','2022-11-10 07:13:40','724',0.00,0.00,'724','2022-11-09 19:01:25','724','2022-11-09 19:01:55',10,0),('1','200',257839,'DAILY SALES','2022-11-10','2022-11-10 07:15:07','2022-11-11 07:15:07','724',0.00,0.00,'724','2022-11-10 19:11:20','724','2022-11-10 19:11:52',10,0),('1','200',257840,'DAILY SALES','2022-11-11','2022-11-11 07:14:12','2022-11-12 07:14:12','724',0.00,0.00,'724','2022-11-11 19:13:44','724','2022-11-11 19:16:58',10,0),('1','200',257841,'DAILY SALES','2022-11-12','2022-11-12 07:16:13','2022-11-13 07:16:13','724',0.00,0.00,'724','2022-11-12 19:41:34','724','2022-11-12 19:42:21',10,0),('1','200',257842,'DAILY SALES','2022-11-13','2022-11-13 07:28:17','2022-11-14 07:28:17','724',0.00,0.00,'724','2022-11-13 19:16:14','724','2022-11-13 19:16:44',10,0),('1','200',257843,'DAILY SALES','2022-11-14','2022-11-14 07:08:50','2022-11-15 07:08:50','724',0.00,0.00,'724','2022-11-14 19:40:30','724','2022-11-14 19:41:21',10,0),('1','200',257844,'DAILY SALES','2022-11-15','2022-11-15 07:21:58','2022-11-16 07:21:58','724',0.00,0.00,'724','2022-11-15 18:53:33','724','2022-11-15 18:54:15',10,0),('1','200',257845,'DAILY SALES','2022-11-16','2022-11-16 06:55:09','2022-11-17 06:55:09','724',0.00,0.00,'724','2022-11-16 18:38:28','724','2022-11-16 18:50:18',10,0),('1','200',257846,'BULK SALES','2022-11-16','2022-11-16 18:51:07','2022-11-17 18:51:07','724',0.00,0.00,'724','2022-11-16 19:16:41','724','2022-11-16 19:17:26',10,0),('1','200',257847,'DAILY SALES','2022-11-17','2022-11-17 06:44:44','2022-11-18 06:44:44','724',0.00,0.00,'724','2022-11-17 18:54:48','724','2022-11-17 18:57:10',10,0),('1','200',257848,'DAILY SALES','2022-11-18','2022-11-18 07:09:33','2022-11-19 07:09:33','724',0.00,0.00,'724','2022-11-18 18:45:03','724','2022-11-18 18:45:52',10,0),('1','200',257849,'DAILY SALES','2022-11-19','2022-11-19 06:46:38','2022-11-20 06:46:38','724',0.00,0.00,'724','2022-11-19 19:09:38','724','2022-11-19 19:10:27',10,0),('1','200',257850,'DAILY SALES','2022-11-20','2022-11-20 07:00:41','2022-11-21 07:00:41','724',0.00,0.00,'724','2022-11-20 18:31:48','724','2022-11-20 18:32:24',10,0),('1','200',257851,'DAILY SALES','2022-11-21','2022-11-21 07:14:27','2022-11-22 07:14:27','724',0.00,0.00,'724','2022-11-21 19:20:22','724','2022-11-21 19:21:13',10,0),('1','200',257852,'DAILY SALES','2022-11-22','2022-11-22 07:02:33','2022-11-23 07:02:33','724',0.00,0.00,'724','2022-11-22 18:37:33','724','2022-11-22 18:38:19',10,0),('1','200',257853,'DAILY SALES','2022-11-23','2022-11-23 07:03:23','2022-11-24 07:03:23','724',0.00,0.00,'724','2022-11-23 18:46:52','724','2022-11-23 18:48:09',10,0),('1','200',257854,'DAILY SALES','2022-11-24','2022-11-24 06:53:19','2022-11-25 06:53:19','724',0.00,0.00,'724','2022-11-24 19:09:01','724','2022-11-24 19:09:37',10,0),('1','200',257855,'DAILY SALES','2022-11-25','2022-11-25 06:54:59','2022-11-26 06:54:59','724',0.00,0.00,'724','2022-11-25 18:50:03','724','2022-11-25 18:50:35',10,0),('1','200',257856,'DAILY SALES','2022-11-26','2022-11-26 07:15:54','2022-11-27 07:15:54','724',0.00,0.00,'724','2022-11-26 19:16:37','724','2022-11-26 19:17:12',10,0),('1','200',257857,'DAILY SALES','2022-11-27','2022-11-27 07:00:24','2022-11-28 07:00:24','724',0.00,0.00,'724','2022-11-27 13:46:52','724','2022-11-27 13:47:26',10,0),('1','200',257858,'BULK SALES','2022-11-27','2022-11-27 13:48:25','2022-11-28 13:48:25','724',0.00,0.00,'724','2022-11-27 13:52:45','724','2022-11-27 13:53:14',10,0),('1','200',257859,'DAILY SALES','2022-11-27','2022-11-27 13:58:32','2022-11-28 13:58:32','724',0.00,0.00,'724','2022-11-27 18:50:29','724','2022-11-27 18:51:34',10,0),('1','200',257860,'DAILY SALES','2022-11-28','2022-11-28 06:50:54','2022-11-29 06:50:54','724',0.00,0.00,'724','2022-11-28 18:54:39','724','2022-11-28 18:55:32',10,0),('1','200',257861,'DAILY SALES','2022-11-29','2022-11-29 07:11:54','2022-11-30 07:11:54','724',0.00,0.00,'724','2022-11-29 18:32:38','724','2022-11-29 18:34:14',10,0),('1','200',257862,'DAILY SALES','2022-11-30','2022-11-30 07:16:14','2022-12-01 07:16:14','724',0.00,0.00,'724','2022-11-30 19:19:39','724','2022-11-30 19:22:56',10,0),('1','200',257863,'DAILY SALES','2022-12-01','2022-12-01 07:16:01','2022-12-02 07:16:01','724',0.00,0.00,'724','2022-12-01 19:08:15','724','2022-12-01 19:08:51',10,0),('1','200',257864,'DAILY SALES','2022-12-02','2022-12-02 07:06:43','2022-12-03 07:06:43','724',0.00,0.00,'724','2022-12-02 19:01:15','724','2022-12-02 19:03:07',10,0),('1','200',257865,'DAILY SALES','2022-12-03','2022-12-03 06:58:04','2022-12-04 06:58:04','724',0.00,0.00,'724','2022-12-03 19:24:50','724','2022-12-03 19:26:15',10,0),('1','200',257866,'DAILY SALES','2022-12-04','2022-12-04 06:51:22','2022-12-05 06:51:22','724',0.00,0.00,'724','2022-12-04 18:52:22','724','2022-12-04 18:53:17',10,0),('1','200',257867,'DAILY SALES','2022-12-05','2022-12-05 06:47:02','2022-12-06 06:47:02','724',0.00,0.00,'724','2022-12-05 18:58:44','724','2022-12-05 18:59:17',10,0),('1','200',257868,'DAILY SALES','2022-12-06','2022-12-06 06:51:22','2022-12-07 06:51:22','724',0.00,0.00,'724','2022-12-06 19:04:42','724','2022-12-06 19:05:20',10,0),('1','200',257869,'DAILY SALES','2022-12-07','2022-12-07 07:13:24','2022-12-08 07:13:24','724',0.00,0.00,'724','2022-12-08 07:10:42','724','2022-12-08 07:11:43',10,0),('1','200',257870,'DAILY SALES','2022-12-08','2022-12-08 07:12:24','2022-12-09 07:12:24','724',0.00,0.00,'724','2022-12-08 18:51:10','724','2022-12-08 18:52:44',10,0),('1','200',257871,'BULK SALES','2022-12-08','2022-12-08 19:02:08','2022-12-09 19:02:08','724',0.00,0.00,'724','2022-12-08 19:21:16','724','2022-12-08 19:21:49',10,0),('1','200',257872,'DAILY SALES','2022-12-09','2022-12-09 08:22:55','2022-12-10 08:22:55','724',0.00,0.00,'724','2022-12-09 19:11:15','724','2022-12-09 19:12:27',10,0),('1','200',257873,'DAILY SALES','2022-12-10','2022-12-10 07:05:33','2022-12-11 07:05:33','724',0.00,0.00,'724','2022-12-10 20:17:01','724','2022-12-10 20:17:46',10,0),('1','200',257874,'DAILY SALES','2022-12-11','2022-12-11 06:52:59','2022-12-12 06:52:59','724',0.00,0.00,'724','2022-12-11 19:21:14','724','2022-12-11 19:22:14',10,0),('1','200',257875,'DAILY SALES','2022-12-12','2022-12-12 07:04:19','2022-12-13 07:04:19','724',0.00,0.00,'724','2022-12-12 19:28:59','724','2022-12-12 19:31:09',10,0),('1','200',257876,'DAILY SALES','2022-12-13','2022-12-13 06:54:26','2022-12-14 06:54:26','724',0.00,0.00,'724','2022-12-13 18:40:24','724','2022-12-13 18:41:00',10,0),('1','200',257877,'DAILY SALES','2022-12-14','2022-12-14 06:59:48','2022-12-15 06:59:48','724',0.00,0.00,'724','2022-12-14 19:14:57','724','2022-12-14 19:15:26',10,0),('1','200',257878,'DAILY SALES','2022-12-15','2022-12-15 06:36:03','2022-12-16 06:36:03','724',0.00,0.00,'724','2022-12-15 19:24:44','724','2022-12-15 19:25:49',10,0),('1','200',257879,'DAILY SALES','2022-12-16','2022-12-16 06:56:52','2022-12-17 06:56:52','724',0.00,0.00,'724','2022-12-16 20:46:52','724','2022-12-16 20:47:31',10,0),('1','200',257880,'DAILY SALES','2022-12-17','2022-12-17 06:58:27','2022-12-18 06:58:27','724',0.00,0.00,'724','2022-12-17 18:57:12','724','2022-12-17 18:58:22',10,0),('1','200',257881,'DAILY SALES','2022-12-18','2022-12-18 06:55:43','2022-12-19 06:55:43','724',0.00,0.00,'724','2022-12-18 18:55:41','724','2022-12-18 18:57:02',10,0),('1','200',257882,'DAILY SALES','2022-12-19','2022-12-19 07:08:30','2022-12-20 07:08:30','724',0.00,0.00,'724','2022-12-19 18:39:53','724','2022-12-19 18:40:23',10,0),('1','200',257883,'DAILY SALES','2022-12-20','2022-12-20 07:03:57','2022-12-21 07:03:57','724',0.00,0.00,'724','2022-12-20 18:50:20','724','2022-12-20 18:51:25',10,0),('1','200',257884,'DAILY SALES','2022-12-21','2022-12-21 06:55:08','2022-12-22 06:55:08','724',0.00,0.00,'724','2022-12-21 19:32:13','724','2022-12-21 19:34:06',10,0),('1','200',257885,'DAILY SALES','2022-12-22','2022-12-22 07:05:38','2022-12-23 07:05:38','724',0.00,0.00,'724','2022-12-23 06:54:13','724','2022-12-23 06:59:29',10,0),('1','200',257886,'DAILY SALES','2022-12-23','2022-12-23 07:01:01','2022-12-24 07:01:01','724',0.00,0.00,'724','2022-12-23 19:29:17','724','2022-12-23 19:30:18',10,0),('1','200',257887,'DAILY SALES','2022-12-24','2022-12-24 06:41:18','2022-12-25 06:41:18','724',0.00,0.00,'724','2022-12-24 17:13:31','724','2022-12-24 17:14:18',10,0),('1','200',257888,'BULK SALES','2022-12-24','2022-12-24 17:14:44','2022-12-25 17:14:44','724',0.00,0.00,'724','2022-12-24 17:18:18','724','2022-12-24 17:18:59',10,0),('1','200',257889,'DAILY SALES','2022-12-24','2022-12-24 17:22:00','2022-12-25 17:22:00','724',0.00,0.00,'724','2022-12-24 20:33:58','724','2022-12-24 20:37:05',10,0),('1','200',257890,'DAILY SALES','2022-12-25','2022-12-25 07:13:15','2022-12-26 07:13:15','724',0.00,0.00,'724','2022-12-26 06:52:02','724','2022-12-26 06:53:11',10,0),('1','200',257891,'DAILY SALES','2022-12-26','2022-12-26 06:53:58','2022-12-27 06:53:58','724',0.00,0.00,'724','2022-12-26 19:51:10','724','2022-12-26 19:51:51',10,0),('1','200',257892,'DAILY SALES','2022-12-27','2022-12-27 07:13:35','2022-12-28 07:13:35','724',0.00,0.00,'724','2022-12-27 19:31:53','724','2022-12-27 19:32:30',10,0),('1','200',257893,'DAILY SALES','2022-12-28','2022-12-28 07:08:57','2022-12-29 07:08:57','724',0.00,0.00,'724','2022-12-28 19:41:47','724','2022-12-28 19:42:46',10,0),('1','200',257894,'DAILY SALES','2022-12-29','2022-12-29 07:07:15','2022-12-30 07:07:15','724',0.00,0.00,'724','2022-12-29 20:05:43','724','2022-12-29 20:26:45',10,0),('1','200',257895,'DAILY SALES','2022-12-30','2022-12-30 07:07:27','2022-12-31 07:07:27','724',0.00,0.00,'724','2022-12-30 19:38:55','724','2022-12-30 19:39:59',10,0),('1','200',257896,'DAILY SALES','2022-12-31','2022-12-31 07:07:37','2023-01-01 07:07:37','724',0.00,0.00,'724','2022-12-31 19:25:01','724','2022-12-31 19:25:45',10,0),('1','200',257897,'DAILY SALES','2023-01-01','2023-01-01 06:52:56','2023-01-02 06:52:56','724',0.00,0.00,'724','2023-01-01 19:44:30','724','2023-01-01 19:45:42',10,0),('1','200',257898,'DAILY SALES','2023-01-02','2023-01-02 06:57:39','2023-01-03 06:57:39','724',0.00,0.00,'724','2023-01-02 19:39:36','724','2023-01-02 19:40:31',10,0),('1','200',257899,'DAILY SALES','2023-01-03','2023-01-03 07:05:12','2023-01-04 07:05:12','724',0.00,0.00,'724','2023-01-03 19:03:59','724','2023-01-03 19:05:00',10,0),('1','200',257900,'DAILY SALES','2023-01-04','2023-01-04 06:55:17','2023-01-05 06:55:17','724',0.00,0.00,'724','2023-01-04 19:50:33','724','2023-01-04 19:53:26',10,0),('1','200',257901,'DAILY SALES','2023-01-05','2023-01-05 06:48:41','2023-01-06 06:48:41','724',0.00,0.00,'724','2023-01-05 19:47:55','724','2023-01-05 19:50:16',10,0),('1','200',257902,'DAILY SALES','2023-01-06','2023-01-06 07:17:24','2023-01-07 07:17:24','724',0.00,0.00,'724','2023-01-06 19:27:51','724','2023-01-06 19:28:23',10,0),('1','200',257903,'DAILY SALES','2023-01-07','2023-01-07 07:00:00','2023-01-08 07:00:00','724',0.00,0.00,'724','2023-01-07 19:24:04','724','2023-01-07 19:27:39',10,0),('1','200',257904,'DAILY SALES','2023-01-08','2023-01-08 06:52:52','2023-01-09 06:52:52','724',0.00,0.00,'724','2023-01-08 19:17:58','724','2023-01-08 19:18:38',10,0),('1','200',257905,'BULK SALES','2023-01-08','2023-01-08 19:19:27','2023-01-09 19:19:27','724',0.00,0.00,'724','2023-01-08 19:26:02','724','2023-01-08 19:26:38',10,0),('1','200',257906,'DAILY SALES','2023-01-09','2023-01-09 07:03:25','2023-01-10 07:03:25','724',0.00,0.00,'724','2023-01-09 19:55:58','724','2023-01-09 19:56:54',10,0),('1','200',257907,'DAILY SALES','2023-01-10','2023-01-10 07:09:37','2023-01-11 07:09:37','724',0.00,0.00,'724','2023-01-10 19:11:55','724','2023-01-10 19:13:31',10,0),('1','200',257908,'DAILY SALES','2023-01-11','2023-01-11 07:18:02','2023-01-12 07:18:02','724',0.00,0.00,'724','2023-01-11 18:55:15','724','2023-01-11 18:56:26',10,0),('1','200',257909,'DAILY SALES','2023-01-12','2023-01-12 06:58:33','2023-01-13 06:58:33','724',0.00,0.00,'724','2023-01-12 19:28:25','724','2023-01-12 19:29:54',10,0),('1','200',257910,'DAILY SALES','2023-01-13','2023-01-13 07:01:31','2023-01-14 07:01:31','724',0.00,0.00,'724','2023-01-13 18:41:19','724','2023-01-13 18:43:06',10,0),('1','200',257911,'DAILY SALES','2023-01-14','2023-01-14 06:59:32','2023-01-15 06:59:32','724',0.00,0.00,'724','2023-01-15 07:08:28','724','2023-01-15 07:11:45',10,0),('1','200',257912,'DAILY SALES','2023-01-15','2023-01-15 07:12:12','2023-01-16 07:12:12','724',0.00,0.00,'724','2023-01-15 18:53:59','724','2023-01-15 18:55:06',10,0),('1','200',257913,'DAILY SALES','2023-01-16','2023-01-16 06:52:06','2023-01-17 06:52:06','724',0.00,0.00,'724','2023-01-16 18:39:19','724','2023-01-16 18:40:16',10,0),('1','200',257914,'DAILY SALES','2023-01-17','2023-01-17 06:52:38','2023-01-18 06:52:38','724',0.00,0.00,'724','2023-01-17 19:12:05','724','2023-01-17 19:12:54',10,0),('1','200',257915,'DAILY SALES','2023-01-18','2023-01-18 06:55:00','2023-01-19 06:55:00','724',0.00,0.00,'724','2023-01-18 20:04:37','724','2023-01-19 06:57:56',10,0),('1','200',257916,'DAILY SALES','2023-01-19','2023-01-19 06:58:25','2023-01-20 06:58:25','724',0.00,0.00,'724','2023-01-19 16:20:47','724','2023-01-19 16:21:42',10,0),('1','200',257917,'BULK SALES','2023-01-19','2023-01-19 16:30:52','2023-01-20 16:30:52','724',0.00,0.00,'724','2023-01-19 16:41:26','724','2023-01-19 16:43:20',10,0),('1','200',257918,'DAILY SALES','2023-01-19','2023-01-19 16:46:15','2023-01-20 16:46:15','724',0.00,0.00,'724','2023-01-19 19:43:14','724','2023-01-19 19:43:46',10,0),('1','200',257919,'DAILY SALES','2023-01-20','2023-01-20 07:16:07','2023-01-21 07:16:07','724',0.00,0.00,'724','2023-01-20 21:13:32','724','2023-01-20 21:14:01',10,0),('1','200',257920,'DAILY SALES','2023-01-21','2023-01-21 06:59:35','2023-01-22 06:59:35','724',0.00,0.00,'724','2023-01-21 18:39:13','724','2023-01-21 18:39:58',10,0),('1','200',257921,'DAILY SALES','2023-01-22','2023-01-22 06:59:02','2023-01-23 06:59:02','724',0.00,0.00,'724','2023-01-22 19:10:09','724','2023-01-22 19:12:10',10,0),('1','200',257922,'DAILY SALES','2023-01-23','2023-01-23 06:59:50','2023-01-24 06:59:50','724',0.00,0.00,'724','2023-01-23 19:07:47','724','2023-01-23 19:09:43',10,0),('1','200',257923,'DAILY SALES','2023-01-24','2023-01-24 07:02:30','2023-01-25 07:02:30','724',0.00,0.00,'724','2023-01-24 19:10:41','724','2023-01-24 19:13:44',10,0),('1','200',257924,'DAILY SALES','2023-01-25','2023-01-25 07:14:49','2023-01-26 07:14:49','724',0.00,0.00,'724','2023-01-25 19:05:36','724','2023-01-25 19:06:29',10,0),('1','200',257925,'DAILY SALES','2023-01-26','2023-01-26 06:52:19','2023-01-27 06:52:19','724',0.00,0.00,'724','2023-01-26 19:05:24','724','2023-01-26 19:07:03',10,0),('1','200',257926,'DAILY SALES','2023-01-27','2023-01-27 07:11:11','2023-01-28 07:11:11','724',0.00,0.00,'724','2023-01-27 19:52:26','724','2023-01-27 19:52:58',10,0),('1','200',257927,'DAILY SALES','2023-01-28','2023-01-28 06:59:59','2023-01-29 06:59:59','724',0.00,0.00,'724','2023-01-28 20:48:50','724','2023-01-28 20:54:09',10,0),('1','200',257928,'DAILY SALES','2023-01-29','2023-01-29 06:58:53','2023-01-30 06:58:53','724',0.00,0.00,'724','2023-01-29 13:00:19','724','2023-01-29 13:00:56',10,0),('1','200',257929,'BULK SALES','2023-01-29','2023-01-29 13:01:35','2023-01-30 13:01:35','724',0.00,0.00,'724','2023-01-29 13:04:30','724','2023-01-29 13:05:33',10,0),('1','200',257930,'DAILY SALES','2023-01-29','2023-01-29 13:08:26','2023-01-30 13:08:26','724',0.00,0.00,'724','2023-01-30 07:14:13','724','2023-01-30 07:14:52',10,0),('1','200',257931,'DAILY SALES','2023-01-30','2023-01-30 07:15:32','2023-01-31 07:15:32','724',0.00,0.00,'724','2023-01-30 19:47:36','724','2023-01-30 19:48:14',10,0),('1','200',257932,'DAILY SALES','2023-01-31','2023-01-31 06:59:45','2023-02-01 06:59:45','724',0.00,0.00,'724','2023-01-31 19:25:50','724','2023-01-31 19:26:41',10,0),('1','200',257933,'DAILY SALES','2023-02-01','2023-02-01 07:03:05','2023-02-02 07:03:05','724',0.00,0.00,'724','2023-02-01 19:58:44','724','2023-02-01 20:00:52',10,0),('1','200',257934,'DAILY SALES','2023-02-02','2023-02-02 06:59:08','2023-02-03 06:59:08','724',0.00,0.00,'724','2023-02-02 20:10:19','724','2023-02-02 20:11:38',10,0),('1','200',257935,'DAILY SALES','2023-02-03','2023-02-03 06:57:26','2023-02-04 06:57:26','724',0.00,0.00,'724','2023-02-03 20:07:04','724','2023-02-03 20:09:24',10,0),('1','200',257936,'DAILY SALES','2023-02-04','2023-02-04 06:55:41','2023-02-05 06:55:41','724',0.00,0.00,'724','2023-02-04 18:53:29','724','2023-02-04 18:54:37',10,0),('1','200',257937,'DAILY SALES','2023-02-05','2023-02-05 07:07:07','2023-02-06 07:07:07','724',0.00,0.00,'724','2023-02-05 19:12:24','724','2023-02-05 19:51:06',10,0),('1','200',257938,'DAILY SALES','2023-02-06','2023-02-06 06:59:03','2023-02-07 06:59:03','724',0.00,0.00,'724','2023-02-06 19:44:10','724','2023-02-06 19:46:46',10,0),('1','200',257939,'DAILY SALES','2023-02-07','2023-02-07 07:05:36','2023-02-08 07:05:36','724',0.00,0.00,'724','2023-02-07 10:38:36','724','2023-02-07 10:39:39',10,0),('1','200',257940,'BULK SALES','2023-02-07','2023-02-07 10:41:19','2023-02-08 10:41:19','724',0.00,0.00,'724','2023-02-07 10:49:23','724','2023-02-07 10:50:30',10,0),('1','200',257941,'DAILY SALES','2023-02-07','2023-02-07 11:00:44','2023-02-08 11:00:44','724',0.00,0.00,'724','2023-02-08 07:06:02','724','2023-02-08 07:07:10',10,0),('1','200',257942,'DAILY SALES','2023-02-08','2023-02-08 07:07:56','2023-02-09 07:07:56','724',0.00,0.00,'724','2023-02-08 19:31:26','724','2023-02-08 19:32:25',10,0),('1','200',257943,'DAILY SALES ','2023-02-09','2023-02-09 07:14:10','2023-02-10 07:14:10','724',0.00,0.00,'724','2023-02-09 19:27:28','724','2023-02-09 19:29:58',10,0),('1','200',257944,'DAILY SALES','2023-02-10','2023-02-10 07:10:13','2023-02-11 07:10:13','724',0.00,0.00,'724','2023-02-10 20:39:36','724','2023-02-10 20:40:11',10,0),('1','200',257945,'DAILY SALES','2023-02-11','2023-02-11 06:34:35','2023-02-12 06:34:35','724',0.00,0.00,'724','2023-02-11 20:26:51','724','2023-02-11 20:28:10',10,0),('1','200',257946,'DAILY SALES','2023-02-12','2023-02-12 07:27:36','2023-02-13 07:27:36','724',0.00,0.00,'724','2023-02-12 11:00:46','724','2023-02-12 11:01:16',10,0),('1','200',257947,'BULK SALES','2023-02-12','2023-02-12 11:01:45','2023-02-13 11:01:45','724',0.00,0.00,'724','2023-02-12 11:06:03','724','2023-02-12 11:06:50',10,0),('1','200',257948,'DAILY SALES','2023-02-12','2023-02-12 11:11:46','2023-02-13 11:11:46','724',0.00,0.00,'724','2023-02-12 19:48:49','724','2023-02-12 19:51:43',10,0),('1','200',257949,'DAILY SALES','2023-02-13','2023-02-13 07:15:08','2023-02-14 07:15:08','724',0.00,0.00,'724','2023-02-13 19:40:57','724','2023-02-13 19:41:48',10,0),('1','200',257950,'DAILY SALES','2023-02-14','2023-02-14 06:54:47','2023-02-15 06:54:47','724',0.00,0.00,'724','2023-02-14 20:06:13','724','2023-02-14 20:08:07',10,0),('1','200',257951,'DAILY SALES','2023-02-15','2023-02-15 07:10:37','2023-02-16 07:10:37','724',0.00,0.00,'724','2023-02-15 19:16:19','724','2023-02-15 19:17:29',10,0),('1','200',257952,'DAILY SALES','2023-02-16','2023-02-16 06:55:20','2023-02-17 06:55:20','724',0.00,0.00,'724','2023-02-16 19:29:42','724','2023-02-16 19:31:51',10,0),('1','200',257953,'DAILY SALES','2023-02-17','2023-02-17 07:00:49','2023-02-18 07:00:49','724',0.00,0.00,'724','2023-02-17 19:29:18','724','2023-02-17 19:30:05',10,0),('1','200',257954,'DAILY SALES','2023-02-18','2023-02-18 07:00:56','2023-02-19 07:00:56','724',0.00,0.00,'724','2023-02-19 06:48:39','724','2023-02-19 06:49:54',10,0),('1','200',257955,'DAILY SALES','2023-02-19','2023-02-19 06:50:29','2023-02-20 06:50:29','724',0.00,0.00,'724','2023-02-19 20:00:02','724','2023-02-19 20:01:10',10,0),('1','200',257956,'DAILY SALES','2023-02-20','2023-02-20 08:39:39','2023-02-21 08:39:39','724',0.00,0.00,'724','2023-02-20 20:11:05','724','2023-02-20 20:11:43',10,0),('1','200',257957,'DAILY SALES','2023-02-21','2023-02-21 07:10:25','2023-02-22 07:10:25','724',0.00,0.00,'724','2023-02-21 19:54:11','724','2023-02-21 19:56:18',10,0),('1','200',257958,'DAILY SALES','2023-02-22','2023-02-22 06:50:42','2023-02-23 06:50:42','724',0.00,0.00,'724','2023-02-22 20:02:28','724','2023-02-22 20:26:25',10,0),('1','200',257959,'DAILY SALES','2023-02-23','2023-02-23 06:57:33','2023-02-24 06:57:33','724',0.00,0.00,'724','2023-02-23 20:53:36','724','2023-02-23 20:55:21',10,0),('1','200',257960,'DAILY SALES','2023-02-24','2023-02-24 06:52:52','2023-02-25 06:52:52','724',0.00,0.00,'724','2023-02-24 23:26:19','724','2023-02-24 23:27:37',10,0),('1','200',257961,'DAILY SALES','2023-02-26','2023-02-26 08:05:59','2023-02-27 08:05:59','724',0.00,0.00,'724','2023-02-26 20:09:26','724','2023-02-26 20:13:38',10,0),('1','200',257962,'DAILY SALES','2023-02-27','2023-02-27 07:06:27','2023-02-28 07:06:27','724',0.00,0.00,'724','2023-02-27 21:12:17','724','2023-02-27 21:13:01',10,0),('1','200',257963,'DAILY SALES','2023-02-28','2023-02-28 07:11:46','2023-03-01 07:11:46','724',0.00,0.00,'724','2023-02-28 20:46:40','724','2023-03-01 07:13:20',10,0),('1','200',257964,'DAILY SALES','2023-03-01','2023-03-01 07:14:04','2023-03-02 07:14:04','724',0.00,0.00,'724','2023-03-01 19:49:55','724','2023-03-01 19:51:19',10,0),('1','200',257965,'DAILY SALES','2023-03-02','2023-03-02 06:56:49','2023-03-03 06:56:49','724',0.00,0.00,'724','2023-03-02 19:58:14','724','2023-03-02 20:12:59',10,0),('1','200',257966,'DAILY SALES','2023-03-03','2023-03-03 06:56:09','2023-03-04 06:56:09','724',0.00,0.00,'724','2023-03-03 11:35:13','724','2023-03-03 11:43:58',10,0),('1','200',257967,'BULK SALES','2023-03-03','2023-03-03 11:44:59','2023-03-04 11:44:59','724',0.00,0.00,'724','2023-03-03 12:09:26','724','2023-03-03 12:11:05',10,0),('1','200',257968,'DAILY SALES','2023-03-03','2023-03-03 12:16:19','2023-03-04 12:16:19','724',0.00,0.00,'724','2023-03-03 19:47:34','724','2023-03-03 19:48:42',10,0),('1','200',257969,'DAILY SALES','2023-03-04','2023-03-04 07:17:23','2023-03-05 07:17:23','724',0.00,0.00,'724','2023-03-04 19:31:07','724','2023-03-04 19:31:45',10,0),('1','200',257970,'DAILY SALES','2023-03-05','2023-03-05 07:14:09','2023-03-06 07:14:09','724',0.00,0.00,'724','2023-03-05 20:28:58','724','2023-03-05 20:31:42',10,0),('1','200',257971,'DAILY SALES','2023-03-06','2023-03-06 07:28:17','2023-03-07 07:28:17','724',0.00,0.00,'724','2023-03-06 17:55:05','724','2023-03-06 17:57:04',10,0),('1','200',257972,'BULK SALES','2023-03-06','2023-03-06 17:58:24','2023-03-07 17:58:24','724',0.00,0.00,'724','2023-03-06 18:02:51','724','2023-03-06 18:03:55',10,0),('1','200',257973,'DAILY SALES','2023-03-07','2023-03-07 07:05:48','2023-03-08 07:05:48','724',0.00,0.00,'724','2023-03-07 20:04:53','724','2023-03-07 20:07:24',10,0),('1','200',257974,'DAILY SALES','2023-03-08','2023-03-08 06:52:46','2023-03-09 06:52:46','724',0.00,0.00,'724','2023-03-08 19:08:03','724','2023-03-08 19:19:04',10,0),('1','200',257975,'DAILY SALES','2023-03-09','2023-03-09 06:58:34','2023-03-10 06:58:34','724',0.00,0.00,'724','2023-03-09 19:43:34','724','2023-03-09 19:45:42',10,0),('1','200',257976,'DAILY SALES','2023-03-10','2023-03-10 07:03:12','2023-03-11 07:03:12','724',0.00,0.00,'724','2023-03-10 19:57:20','724','2023-03-10 19:58:15',10,0),('1','200',257977,'Daily sales ','2023-03-11','2023-03-11 06:20:00','2023-03-12 06:20:00','724',0.00,0.00,'724','2023-03-11 11:32:14','724','2023-03-11 11:33:24',10,0),('1','200',257978,'BULK SALES','2023-03-11','2023-03-11 12:35:41','2023-03-12 12:35:41','724',0.00,0.00,'724','2023-03-11 12:41:00','724','2023-03-11 12:41:43',10,0),('1','200',257979,'DAILY SALES','2023-03-11','2023-03-11 12:49:11','2023-03-12 12:49:11','724',0.00,0.00,'724','2023-03-11 19:49:46','724','2023-03-11 19:50:24',10,0),('1','200',257980,'DAILY SALES ','2023-03-12','2023-03-12 07:20:32','2023-03-13 07:20:32','724',0.00,0.00,'724','2023-03-12 19:14:00','724','2023-03-12 19:15:17',10,0),('1','200',257981,'DAILY SALES','2023-03-13','2023-03-13 04:54:25','2023-03-14 04:54:25','724',0.00,0.00,'724','2023-03-13 19:30:41','724','2023-03-13 19:31:26',10,0),('1','200',257982,'DAILY SALES','2023-03-14','2023-03-14 06:37:55','2023-03-15 06:37:55','724',0.00,0.00,'724','2023-03-14 20:23:42','724','2023-03-14 20:24:27',10,0),('1','200',257983,'DAILY SALES ','2023-03-15','2023-03-15 07:21:43','2023-03-16 07:21:43','724',0.00,0.00,'724','2023-03-15 20:39:21','724','2023-03-15 20:39:58',10,0),('1','200',257984,'DAILY SALES','2023-03-16','2023-03-16 07:06:13','2023-03-17 07:06:13','724',0.00,0.00,'724','2023-03-16 19:59:29','724','2023-03-16 20:02:20',10,0),('1','200',257985,'DAILY SALES ','2023-03-17','2023-03-17 07:09:12','2023-03-18 07:09:12','724',0.00,0.00,'724','2023-03-17 20:46:24','724','2023-03-17 20:53:59',10,0),('1','200',257986,'DAILY SALES','2023-03-19','2023-03-19 06:12:06','2023-03-20 06:12:06','724',0.00,0.00,'724','2023-03-19 19:26:26','724','2023-03-19 19:28:17',10,0),('1','200',257987,'DAILY SALES','2023-03-20','2023-03-20 07:13:28','2023-03-21 07:13:28','724',0.00,0.00,'724','2023-03-20 20:14:45','724','2023-03-20 20:25:49',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4907433 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','200','1025','243697',4667450,'3037','468',0.00,706.01,0.00,0.00,706.01,443664.04,0.00,0.00,0.00),('1','200','1025','243883',4670662,'3037','468',706.01,1463.43,0.00,0.00,757.42,482287.52,0.00,0.00,0.00),('1','200','1025','244055',4673702,'3037','468',1463.43,2793.23,0.00,0.00,1329.80,841856.80,0.00,0.00,0.00),('1','200','1025','244302',4677837,'3037','468',2793.23,4672.72,0.00,0.00,1879.49,1184237.44,0.00,0.00,0.00),('1','200','1025','244504',4681581,'3037','468',4672.72,6197.36,0.00,0.00,1524.64,966719.84,0.00,0.00,0.00),('1','200','1025','244726',4685317,'3037','468',6197.36,7629.24,0.00,0.00,1431.88,913483.28,0.00,0.00,0.00),('1','200','1025','244955',4689489,'3037','468',7629.24,9543.34,0.00,0.00,1914.10,1202603.60,0.00,0.00,0.00),('1','200','1025','245198',4693673,'3037','468',9543.34,12228.15,0.00,0.00,2684.81,1692331.36,0.00,0.00,0.00),('1','200','1025','245424',4697590,'3037','468',12228.15,14025.73,0.00,0.00,1797.58,1139414.48,0.00,0.00,0.00),('1','200','1025','245664',4701764,'3037','468',14025.73,15581.88,0.00,0.00,1556.15,989748.40,0.00,0.00,0.00),('1','200','1025','245924',4705753,'3037','468',15581.88,17313.80,0.00,0.00,1731.92,1059629.44,0.00,0.00,0.00),('1','200','1025','246174',4709960,'3037','468',17313.80,18998.67,0.00,0.00,1684.87,1033893.84,0.00,0.00,0.00),('1','200','1025','246464',4714646,'3037','468',18998.67,21590.66,0.00,0.00,2591.99,1580969.68,0.00,0.00,0.00),('1','200','1025','246702',4718779,'3037','468',21590.66,23024.83,0.00,0.00,1434.17,882555.44,0.00,0.00,0.00),('1','200','1025','246937',4723053,'3037','468',23024.83,26782.83,0.00,0.00,3758.00,2289280.00,0.00,0.00,0.00),('1','200','1025','247172',4726947,'3037','468',26782.83,28921.04,0.00,0.00,2138.21,1313940.72,0.00,0.00,0.00),('1','200','1025','247409',4731131,'3037','468',28921.04,30527.66,0.00,0.00,1606.62,996740.64,0.00,0.00,0.00),('1','200','1025','247673',4735565,'3037','468',30527.66,32649.07,0.00,0.00,2121.41,1262472.64,0.00,0.00,0.00),('1','200','1025','247912',4739629,'3037','468',32649.07,34828.39,0.00,0.00,2179.32,1296525.12,0.00,0.00,0.00),('1','200','1025','248163',4743882,'3037','468',34828.39,37720.83,0.00,0.00,2892.44,1709567.72,0.00,0.00,0.00),('1','200','1025','248415',4748136,'3037','468',37720.83,42314.44,0.00,0.00,4593.61,2705211.76,0.00,0.00,0.00),('1','200','1025','248650',4752046,'3037','468',42314.44,45267.52,0.00,0.00,2953.08,1763225.28,0.00,0.00,0.00),('1','200','1025','248877',4756020,'3037','468',45267.52,46849.76,0.00,0.00,1582.24,943892.08,0.00,0.00,0.00),('1','200','1025','249024',4758544,'3037','468',46849.76,46849.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','249062',4759254,'3037','468',46849.76,47764.94,0.00,0.00,915.18,531948.60,0.00,0.00,0.00),('1','200','1025','249118',4759912,'3037','468',47764.94,50596.26,0.00,0.00,2831.32,1644807.00,0.00,0.00,0.00),('1','200','1025','249364',4764194,'3037','468',50596.26,53705.58,0.00,0.00,3109.32,1802217.00,0.00,0.00,0.00),('1','200','1025','249609',4768273,'3037','468',53705.58,56132.93,0.00,0.00,2427.35,1417414.80,0.00,0.00,0.00),('1','200','1025','249874',4772751,'3037','468',56132.93,59137.74,0.00,0.00,3004.81,1752606.00,0.00,0.00,0.00),('1','200','1025','250102',4776621,'3037','468',59137.74,61944.63,0.00,0.00,2806.89,1631812.50,0.00,0.00,0.00),('1','200','1025','250356',4780835,'3037','468',61944.63,64787.73,0.00,0.00,2843.10,1655565.00,0.00,0.00,0.00),('1','200','1025','250563',4784366,'3037','468',64787.73,67076.83,0.00,0.00,2289.10,1338570.00,0.00,0.00,0.00),('1','200','1025','250817',4788673,'3037','468',67076.83,69854.61,0.00,0.00,2777.78,1614843.90,0.00,0.00,0.00),('1','200','1025','251044',4792808,'3037','468',69854.61,72597.26,0.00,0.00,2742.65,1599435.00,0.00,0.00,0.00),('1','200','1025','251278',4796834,'3037','468',72597.26,75570.96,0.00,0.00,2973.70,1652467.20,0.00,0.00,0.00),('1','200','1025','251526',4801036,'3037','468',75570.96,79173.48,0.00,0.00,3602.52,2001483.52,0.00,0.00,0.00),('1','200','1025','251772',4805462,'3037','468',79173.48,81644.98,0.00,0.00,2471.50,1388917.44,0.00,0.00,0.00),('1','200','1025','251998',4809371,'3037','468',81644.98,85732.35,0.00,0.00,4087.37,2264005.12,0.00,0.00,0.00),('1','200','1025','252239',4813568,'3037','468',85732.35,89306.84,0.00,0.00,3574.49,1980170.24,0.00,0.00,0.00),('1','200','1025','252488',4818085,'3037','468',89306.84,91697.52,0.00,0.00,2390.68,1335607.68,0.00,0.00,0.00),('1','200','1025','252725',4822163,'3037','468',91697.52,95950.17,0.00,0.00,4252.65,2350160.80,0.00,0.00,0.00),('1','200','1025','252972',4826159,'3037','468',95950.17,98746.18,0.00,0.00,2796.01,1561777.60,0.00,0.00,0.00),('1','200','1025','253212',4830277,'3037','468',98746.18,101516.38,0.00,0.00,2770.20,1539203.20,0.00,0.00,0.00),('1','200','1025','253477',4834800,'3037','468',101516.38,104629.53,0.00,0.00,3113.15,1732748.80,0.00,0.00,0.00),('1','200','1025','253719',4838817,'3037','468',104629.53,107820.91,0.00,0.00,3191.38,1769674.88,0.00,0.00,0.00),('1','200','1025','253960',4843072,'3037','468',107820.91,107989.76,0.00,0.00,168.85,93319.36,0.00,0.00,0.00),('1','200','1025','254013',4843900,'3037','468',107989.76,110360.13,0.00,0.00,2370.37,1317959.36,0.00,0.00,0.00),('1','200','1025','254217',4847646,'3037','468',110360.13,113974.65,0.00,0.00,3614.52,2004811.20,0.00,0.00,0.00),('1','200','1025','254457',4851780,'3037','468',113974.65,117264.54,0.00,0.00,3289.89,1830256.64,0.00,0.00,0.00),('1','200','1025','254714',4856227,'3037','468',117264.54,121273.95,0.00,0.00,4009.41,2218876.16,0.00,0.00,0.00),('1','200','1025','254958',4860405,'3037','468',121273.95,125320.80,0.00,0.00,4046.85,2236016.96,0.00,0.00,0.00),('1','200','1025','255204',4864572,'3037','468',125320.80,129254.70,0.00,0.00,3933.90,2180246.40,0.00,0.00,0.00),('1','200','1025','255483',4869368,'3037','468',129254.70,132399.01,0.00,0.00,3144.31,1742434.88,0.00,0.00,0.00),('1','200','1025','255734',4873503,'3037','468',132399.01,136378.87,0.00,0.00,3979.86,2208415.36,0.00,0.00,0.00),('1','200','1025','255953',4877067,'3037','468',136378.87,141615.32,0.00,0.00,5236.45,2880497.32,0.00,0.00,0.00),('1','200','1025','256212',4881255,'3037','468',141615.32,144142.61,0.00,0.00,2527.29,1404727.04,0.00,0.00,0.00),('1','200','1025','256507',4886306,'3037','468',144142.61,147615.39,0.00,0.00,3472.78,1937713.28,0.00,0.00,0.00),('1','200','1025','256749',4890200,'3037','468',147615.39,150547.96,0.00,0.00,2932.57,1637384.32,0.00,0.00,0.00),('1','200','1025','256990',4894467,'3037','468',150547.96,154247.20,0.00,0.00,3699.24,2049946.24,0.00,0.00,0.00),('1','200','1025','257247',4899234,'3037','468',154247.20,157352.91,0.00,0.00,3105.71,1736149.76,0.00,0.00,0.00),('1','200','1025','257506',4903668,'3037','468',157352.91,161347.43,0.00,0.00,3994.52,2225543.36,0.00,0.00,0.00),('1','200','1025','257507',4903669,'3037','468',161347.43,163813.95,0.00,0.00,2466.52,1384948.16,0.00,0.00,0.00),('1','200','1025','257508',4903670,'3037','468',163813.95,167876.98,0.00,0.00,4063.03,2255121.28,0.00,0.00,0.00),('1','200','1025','257509',4903671,'3037','468',167876.98,172348.58,0.00,0.00,4471.60,2488937.60,0.00,0.00,0.00),('1','200','1025','257510',4903672,'3037','468',172348.58,176387.28,0.00,0.00,4038.70,2260499.20,0.00,0.00,0.00),('1','200','1025','257511',4903673,'3037','468',176387.28,182963.41,0.00,0.00,6576.13,3625706.88,0.00,0.00,0.00),('1','200','1025','257512',4903674,'3037','468',182963.41,187454.02,0.00,0.00,4490.61,2503039.36,0.00,0.00,0.00),('1','200','1025','257513',4903675,'3037','468',187454.02,190936.81,0.00,0.00,3482.79,1959623.04,0.00,0.00,0.00),('1','200','1025','257514',4903676,'3037','468',190936.81,194526.14,0.00,0.00,3589.33,2012362.88,0.00,0.00,0.00),('1','200','1025','257515',4903677,'3037','468',194526.14,199107.69,0.00,0.00,4581.55,2546028.80,0.00,0.00,0.00),('1','200','1025','257516',4903678,'3037','468',199107.69,203129.78,0.00,0.00,4022.09,2237219.84,0.00,0.00,0.00),('1','200','1025','257517',4903679,'3037','468',203129.78,206060.63,0.00,0.00,2930.85,1652405.76,0.00,0.00,0.00),('1','200','1025','257518',4903680,'3037','468',206060.63,206060.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257519',4903681,'3037','468',33137.04,33137.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257519',4903682,'3038','468',31294.91,31294.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257519',4903683,'3039','468',9278.54,10179.47,0.00,0.00,900.93,518935.68,0.00,0.00,0.00),('1','200','1025','257519',4903684,'3040','468',9118.14,9944.77,0.00,0.00,826.63,476138.88,0.00,0.00,0.00),('1','200','1025','257519',4903685,'3041','468',51395.31,51395.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257519',4903686,'3042','468',53371.99,53371.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257519',4903687,'3043','468',11362.66,12469.21,0.00,0.00,1106.55,601963.20,0.00,0.00,0.00),('1','200','1025','257519',4903688,'3044','468',12438.94,13119.94,0.00,0.00,681.00,370464.00,0.00,0.00,0.00),('1','200','1025','257520',4903689,'3037','468',33137.04,33137.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257520',4903690,'3038','468',31294.91,31294.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257520',4903691,'3039','468',10179.47,10310.98,0.00,0.00,131.51,75749.76,0.00,0.00,0.00),('1','200','1025','257520',4903692,'3040','468',9944.77,10051.58,0.00,0.00,106.81,61522.56,0.00,0.00,0.00),('1','200','1025','257520',4903693,'3041','468',51395.31,51395.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257520',4903694,'3042','468',53371.99,53371.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257520',4903695,'3043','468',12469.21,12604.21,0.00,0.00,135.00,73440.00,0.00,0.00,0.00),('1','200','1025','257520',4903696,'3044','468',13119.94,13319.81,0.00,0.00,199.87,108729.28,0.00,0.00,0.00),('1','200','1025','257521',4903697,'3037','468',33137.04,33137.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257521',4903698,'3038','468',31294.91,31294.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257521',4903699,'3039','468',10310.98,10310.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257521',4903700,'3040','468',10051.58,10051.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257521',4903701,'3041','468',51395.31,51395.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257521',4903702,'3042','468',53371.99,53371.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257521',4903703,'3043','468',12604.21,12604.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257521',4903704,'3044','468',13319.81,13319.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257522',4903705,'3037','468',33137.04,33137.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257522',4903706,'3038','468',31294.91,31294.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257522',4903707,'3039','468',10310.98,10954.90,0.00,0.00,643.92,370897.92,0.00,0.00,0.00),('1','200','1025','257522',4903708,'3040','468',10051.58,10822.31,0.00,0.00,770.73,443940.48,0.00,0.00,0.00),('1','200','1025','257522',4903709,'3041','468',51395.31,51395.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257522',4903710,'3042','468',53371.99,53371.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257522',4903711,'3043','468',12604.21,13163.66,0.00,0.00,559.45,304340.80,0.00,0.00,0.00),('1','200','1025','257522',4903712,'3044','468',13319.81,13789.25,0.00,0.00,469.44,255375.36,0.00,0.00,0.00),('1','200','1025','257523',4903713,'3037','468',33137.04,33137.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257523',4903714,'3038','468',31294.91,31294.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257523',4903715,'3039','468',10954.90,11605.00,0.00,0.00,650.10,374457.60,0.00,0.00,0.00),('1','200','1025','257523',4903716,'3040','468',10822.31,11559.84,0.00,0.00,737.53,424817.28,0.00,0.00,0.00),('1','200','1025','257523',4903717,'3041','468',51395.31,51395.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257523',4903718,'3042','468',53371.99,53371.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257523',4903719,'3043','468',13163.66,13923.16,0.00,0.00,759.50,413168.00,0.00,0.00,0.00),('1','200','1025','257523',4903720,'3044','468',13789.25,14290.73,0.00,0.00,501.48,272805.12,0.00,0.00,0.00),('1','200','1025','257524',4903721,'3037','468',33137.04,33449.85,0.00,0.00,312.81,180178.56,0.00,0.00,0.00),('1','200','1025','257524',4903722,'3038','468',31294.91,31626.75,0.00,0.00,331.84,191139.84,0.00,0.00,0.00),('1','200','1025','257524',4903723,'3039','468',11605.00,11605.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257524',4903724,'3040','468',11559.84,11559.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257524',4903725,'3041','468',51395.31,51723.01,0.00,0.00,327.70,178268.80,0.00,0.00,0.00),('1','200','1025','257524',4903726,'3042','468',53371.99,53488.65,0.00,0.00,116.66,63463.04,0.00,0.00,0.00),('1','200','1025','257524',4903727,'3043','468',13923.16,14048.16,0.00,0.00,125.00,68000.00,0.00,0.00,0.00),('1','200','1025','257524',4903728,'3044','468',14290.73,14420.73,0.00,0.00,130.00,70720.00,0.00,0.00,0.00),('1','200','1025','257525',4903729,'3037','468',33449.85,33449.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257525',4903730,'3038','468',31626.75,31626.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257525',4903731,'3039','468',11605.00,11605.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257525',4903732,'3040','468',11559.84,11559.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257525',4903733,'3041','468',51723.01,51723.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257525',4903734,'3042','468',53488.65,53488.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257525',4903735,'3043','468',14048.16,14048.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257525',4903736,'3044','468',14420.73,14420.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257526',4903737,'3037','468',33449.85,33690.67,0.00,0.00,240.82,138712.32,0.00,0.00,0.00),('1','200','1025','257526',4903738,'3038','468',31626.75,31801.82,0.00,0.00,175.07,100840.32,0.00,0.00,0.00),('1','200','1025','257526',4903739,'3039','468',11605.00,11863.27,0.00,0.00,258.27,148763.52,0.00,0.00,0.00),('1','200','1025','257526',4903740,'3040','468',11559.84,11559.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257526',4903741,'3041','468',51723.01,51840.57,0.00,0.00,117.56,63952.64,0.00,0.00,0.00),('1','200','1025','257526',4903742,'3042','468',53488.65,53747.73,0.00,0.00,259.08,140939.52,0.00,0.00,0.00),('1','200','1025','257526',4903743,'3043','468',14048.16,14287.16,0.00,0.00,239.00,130016.00,0.00,0.00,0.00),('1','200','1025','257526',4903744,'3044','468',14420.73,14590.73,0.00,0.00,170.00,92480.00,0.00,0.00,0.00),('1','200','1025','257527',4903745,'3037','468',33690.67,34407.00,0.00,0.00,716.33,412606.08,0.00,0.00,0.00),('1','200','1025','257527',4903746,'3038','468',31801.82,32638.05,0.00,0.00,836.23,481668.48,0.00,0.00,0.00),('1','200','1025','257527',4903747,'3039','468',11863.27,11863.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257527',4903748,'3040','468',11559.84,11559.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257527',4903749,'3041','468',51840.57,52712.07,0.00,0.00,871.50,474096.00,0.00,0.00,0.00),('1','200','1025','257527',4903750,'3042','468',53747.73,54579.22,0.00,0.00,831.49,452330.56,0.00,0.00,0.00),('1','200','1025','257527',4903751,'3043','468',14287.16,15167.16,0.00,0.00,880.00,478720.00,0.00,0.00,0.00),('1','200','1025','257527',4903752,'3044','468',14590.73,15459.73,0.00,0.00,869.00,472736.00,0.00,0.00,0.00),('1','200','1025','257528',4903753,'3037','468',34407.00,35092.77,0.00,0.00,685.77,395003.52,0.00,0.00,0.00),('1','200','1025','257528',4903754,'3038','468',32638.05,33376.68,0.00,0.00,738.63,425450.88,0.00,0.00,0.00),('1','200','1025','257528',4903755,'3039','468',11863.27,11863.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257528',4903756,'3040','468',11559.84,11559.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257528',4903757,'3041','468',52712.07,52792.89,0.00,0.00,80.82,43966.08,0.00,0.00,0.00),('1','200','1025','257528',4903758,'3042','468',54579.22,54857.61,0.00,0.00,278.39,151444.16,0.00,0.00,0.00),('1','200','1025','257528',4903759,'3043','468',15167.16,15982.67,0.00,0.00,815.51,443637.44,0.00,0.00,0.00),('1','200','1025','257528',4903760,'3044','468',15459.73,16254.78,0.00,0.00,795.05,432507.20,0.00,0.00,0.00),('1','200','1025','257529',4903761,'3037','468',35092.77,35425.21,0.00,0.00,332.44,191485.44,0.00,0.00,0.00),('1','200','1025','257529',4903762,'3038','468',33376.68,33775.61,0.00,0.00,398.93,229783.68,0.00,0.00,0.00),('1','200','1025','257529',4903763,'3039','468',11863.27,11863.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257529',4903764,'3040','468',11559.84,11559.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257529',4903765,'3041','468',52792.89,52932.25,0.00,0.00,139.36,75811.84,0.00,0.00,0.00),('1','200','1025','257529',4903766,'3042','468',54857.61,54902.61,0.00,0.00,45.00,24480.00,0.00,0.00,0.00),('1','200','1025','257529',4903767,'3043','468',15982.67,16702.52,0.00,0.00,719.85,390843.42,0.00,0.00,0.00),('1','200','1025','257529',4903768,'3044','468',16254.78,17004.79,0.00,0.00,750.01,407084.04,0.00,0.00,0.00),('1','200','1025','257530',4903769,'3037','468',35425.21,35425.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257530',4903770,'3038','468',33775.61,33775.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257530',4903771,'3039','468',11863.27,11863.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257530',4903772,'3040','468',11559.84,11559.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257530',4903773,'3041','468',52932.25,52932.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257530',4903774,'3042','468',54902.61,54902.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257530',4903775,'3043','468',16702.52,16702.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257530',4903776,'3044','468',17004.79,17004.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257531',4903777,'3037','468',35425.21,36176.26,0.00,0.00,751.05,432604.80,0.00,0.00,0.00),('1','200','1025','257531',4903778,'3038','468',33775.61,34660.89,0.00,0.00,885.28,509921.28,0.00,0.00,0.00),('1','200','1025','257531',4903779,'3039','468',11863.27,11863.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257531',4903780,'3040','468',11559.84,11559.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257531',4903781,'3041','468',52932.25,53159.75,0.00,0.00,227.50,123760.00,0.00,0.00,0.00),('1','200','1025','257531',4903782,'3042','468',54902.61,55344.61,0.00,0.00,442.00,240448.00,0.00,0.00,0.00),('1','200','1025','257531',4903783,'3043','468',16702.52,17306.02,0.00,0.00,603.50,328304.00,0.00,0.00,0.00),('1','200','1025','257531',4903784,'3044','468',17004.79,17561.35,0.00,0.00,556.56,302768.64,0.00,0.00,0.00),('1','200','1025','257532',4903785,'3037','468',36176.26,36176.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257532',4903786,'3038','468',34660.89,34660.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257532',4903787,'3039','468',11863.27,12893.46,0.00,0.00,1030.19,593389.44,0.00,0.00,0.00),('1','200','1025','257532',4903788,'3040','468',11559.84,12204.71,0.00,0.00,644.87,371445.12,0.00,0.00,0.00),('1','200','1025','257532',4903789,'3041','468',53159.75,53402.80,0.00,0.00,243.05,132219.20,0.00,0.00,0.00),('1','200','1025','257532',4903790,'3042','468',55344.61,55683.06,0.00,0.00,338.45,184116.80,0.00,0.00,0.00),('1','200','1025','257532',4903791,'3043','468',17306.02,17450.02,0.00,0.00,144.00,78336.00,0.00,0.00,0.00),('1','200','1025','257532',4903792,'3044','468',17561.35,17639.35,0.00,0.00,78.00,42432.00,0.00,0.00,0.00),('1','200','1025','257533',4903793,'3037','468',36176.26,36176.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257533',4903794,'3038','468',34660.89,34660.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257533',4903795,'3039','468',12893.46,13919.67,0.00,0.00,1026.21,591096.96,0.00,0.00,0.00),('1','200','1025','257533',4903796,'3040','468',12204.71,12874.76,0.00,0.00,670.05,385948.80,0.00,0.00,0.00),('1','200','1025','257533',4903797,'3041','468',53402.80,53838.93,0.00,0.00,436.13,237414.72,0.00,0.00,0.00),('1','200','1025','257533',4903798,'3042','468',55683.06,56116.69,0.00,0.00,433.63,241570.56,0.00,0.00,0.00),('1','200','1025','257533',4903799,'3043','468',17450.02,17979.02,0.00,0.00,529.00,287776.00,0.00,0.00,0.00),('1','200','1025','257533',4903800,'3044','468',17639.35,18252.48,0.00,0.00,613.13,333542.72,0.00,0.00,0.00),('1','200','1025','257534',4903801,'3037','468',36176.26,36176.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257534',4903802,'3038','468',34660.89,34660.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257534',4903803,'3039','468',13919.67,14343.11,0.00,0.00,423.44,243901.44,0.00,0.00,0.00),('1','200','1025','257534',4903804,'3040','468',12874.76,13961.65,0.00,0.00,1086.89,626048.64,0.00,0.00,0.00),('1','200','1025','257534',4903805,'3041','468',53838.93,53838.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257534',4903806,'3042','468',56116.69,56236.69,0.00,0.00,120.00,65280.00,0.00,0.00,0.00),('1','200','1025','257534',4903807,'3043','468',17979.02,18569.02,0.00,0.00,590.00,320960.00,0.00,0.00,0.00),('1','200','1025','257534',4903808,'3044','468',18252.48,18921.99,0.00,0.00,669.51,364213.44,0.00,0.00,0.00),('1','200','1025','257535',4903809,'3037','468',36176.26,36908.02,0.00,0.00,731.76,421493.76,0.00,0.00,0.00),('1','200','1025','257535',4903810,'3038','468',34660.89,35518.16,0.00,0.00,857.27,493787.52,0.00,0.00,0.00),('1','200','1025','257535',4903811,'3039','468',14343.11,14343.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257535',4903812,'3040','468',13961.65,13961.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257535',4903813,'3041','468',53838.93,54118.93,0.00,0.00,280.00,152320.00,0.00,0.00,0.00),('1','200','1025','257535',4903814,'3042','468',56236.69,56949.69,0.00,0.00,713.00,387872.00,0.00,0.00,0.00),('1','200','1025','257535',4903815,'3043','468',18569.02,19643.52,0.00,0.00,1074.50,584528.00,0.00,0.00,0.00),('1','200','1025','257535',4903816,'3044','468',18921.99,19894.99,0.00,0.00,973.00,529312.00,0.00,0.00,0.00),('1','200','1025','257536',4903817,'3037','468',36908.02,37757.49,0.00,0.00,849.47,489294.72,0.00,0.00,0.00),('1','200','1025','257536',4903818,'3038','468',35518.16,36370.43,0.00,0.00,852.27,490907.52,0.00,0.00,0.00),('1','200','1025','257536',4903819,'3039','468',14343.11,14343.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257536',4903820,'3040','468',13961.65,13961.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257536',4903821,'3041','468',54118.93,54392.72,0.00,0.00,273.79,148941.76,0.00,0.00,0.00),('1','200','1025','257536',4903822,'3042','468',56949.69,57103.82,0.00,0.00,154.13,83846.72,0.00,0.00,0.00),('1','200','1025','257536',4903823,'3043','468',19643.52,20013.52,0.00,0.00,370.00,201280.00,0.00,0.00,0.00),('1','200','1025','257536',4903824,'3044','468',19894.99,20054.99,0.00,0.00,160.00,87040.00,0.00,0.00,0.00),('1','200','1025','257537',4903825,'3037','468',37757.49,38515.45,0.00,0.00,757.96,436584.96,0.00,0.00,0.00),('1','200','1025','257537',4903826,'3038','468',36370.43,37097.91,0.00,0.00,727.48,419028.48,0.00,0.00,0.00),('1','200','1025','257537',4903827,'3039','468',14343.11,14343.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257537',4903828,'3040','468',13961.65,13961.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257537',4903829,'3041','468',54392.72,54829.92,0.00,0.00,437.20,237836.80,0.00,0.00,0.00),('1','200','1025','257537',4903830,'3042','468',57103.82,57520.02,0.00,0.00,416.20,226412.80,0.00,0.00,0.00),('1','200','1025','257537',4903831,'3043','468',20013.52,20671.52,0.00,0.00,658.00,357952.00,0.00,0.00,0.00),('1','200','1025','257537',4903832,'3044','468',20054.99,20584.99,0.00,0.00,530.00,288320.00,0.00,0.00,0.00),('1','200','1025','257538',4903833,'3037','468',38515.45,38810.00,0.00,0.00,294.55,169660.80,0.00,0.00,0.00),('1','200','1025','257538',4903834,'3038','468',37097.91,37573.67,0.00,0.00,475.76,274037.76,0.00,0.00,0.00),('1','200','1025','257538',4903835,'3039','468',14343.11,14343.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257538',4903836,'3040','468',13961.65,13961.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257538',4903837,'3041','468',54829.92,54962.94,0.00,0.00,133.02,72362.88,0.00,0.00,0.00),('1','200','1025','257538',4903838,'3042','468',57520.02,57641.84,0.00,0.00,121.82,66270.08,0.00,0.00,0.00),('1','200','1025','257538',4903839,'3043','468',20671.52,20851.52,0.00,0.00,180.00,97920.00,0.00,0.00,0.00),('1','200','1025','257538',4903840,'3044','468',20584.99,20689.99,0.00,0.00,105.00,57120.00,0.00,0.00,0.00),('1','200','1025','257539',4903841,'3037','468',38810.00,38810.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257539',4903842,'3038','468',37573.67,37573.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257539',4903843,'3039','468',14343.11,14343.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257539',4903844,'3040','468',13961.65,13961.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257539',4903845,'3041','468',54962.94,54962.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257539',4903846,'3042','468',57641.84,57641.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257539',4903847,'3043','468',20851.52,20851.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257539',4903848,'3044','468',20689.99,20689.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257540',4903849,'3037','468',38810.00,39316.75,0.00,0.00,506.75,291888.00,0.00,0.00,0.00),('1','200','1025','257540',4903850,'3038','468',37573.67,38077.49,0.00,0.00,503.82,290200.32,0.00,0.00,0.00),('1','200','1025','257540',4903851,'3039','468',14343.11,14541.53,0.00,0.00,198.42,114289.92,0.00,0.00,0.00),('1','200','1025','257540',4903852,'3040','468',13961.65,13961.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257540',4903853,'3041','468',54962.94,55337.94,0.00,0.00,375.00,204000.00,0.00,0.00,0.00),('1','200','1025','257540',4903854,'3042','468',57641.84,58230.85,0.00,0.00,589.01,320421.44,0.00,0.00,0.00),('1','200','1025','257540',4903855,'3043','468',20851.52,21432.02,0.00,0.00,580.50,315792.00,0.00,0.00,0.00),('1','200','1025','257540',4903856,'3044','468',20689.99,21291.49,0.00,0.00,601.50,327216.00,0.00,0.00,0.00),('1','200','1025','257541',4903857,'3037','468',39316.75,40068.03,0.00,0.00,751.28,432737.28,0.00,0.00,0.00),('1','200','1025','257541',4903858,'3038','468',38077.49,38968.05,0.00,0.00,890.56,512962.56,0.00,0.00,0.00),('1','200','1025','257541',4903859,'3039','468',14541.53,14541.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257541',4903860,'3040','468',13961.65,13961.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257541',4903861,'3041','468',55337.94,55950.83,0.00,0.00,612.89,333412.16,0.00,0.00,0.00),('1','200','1025','257541',4903862,'3042','468',58230.85,58812.51,0.00,0.00,581.66,316423.04,0.00,0.00,0.00),('1','200','1025','257541',4903863,'3043','468',21432.02,21934.03,0.00,0.00,502.01,273093.44,0.00,0.00,0.00),('1','200','1025','257541',4903864,'3044','468',21291.49,21883.83,0.00,0.00,592.34,322232.96,0.00,0.00,0.00),('1','200','1025','257542',4903865,'3037','468',40068.03,40765.07,0.00,0.00,697.04,401495.04,0.00,0.00,0.00),('1','200','1025','257542',4903866,'3038','468',38968.05,39806.45,0.00,0.00,838.40,482918.40,0.00,0.00,0.00),('1','200','1025','257542',4903867,'3039','468',14541.53,14541.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257542',4903868,'3040','468',13961.65,13961.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257542',4903869,'3041','468',55950.83,56130.03,0.00,0.00,179.20,97484.80,0.00,0.00,0.00),('1','200','1025','257542',4903870,'3042','468',58812.51,59059.51,0.00,0.00,247.00,134368.00,0.00,0.00,0.00),('1','200','1025','257542',4903871,'3043','468',21934.03,22565.03,0.00,0.00,631.00,343264.00,0.00,0.00,0.00),('1','200','1025','257542',4903872,'3044','468',21883.83,22486.33,0.00,0.00,602.50,327760.00,0.00,0.00,0.00),('1','200','1025','257543',4903873,'3037','468',40765.07,40765.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257543',4903874,'3038','468',39806.45,39806.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257543',4903875,'3039','468',14541.53,15439.04,0.00,0.00,897.51,516965.76,0.00,0.00,0.00),('1','200','1025','257543',4903876,'3040','468',13961.65,14708.38,0.00,0.00,746.73,430116.48,0.00,0.00,0.00),('1','200','1025','257543',4903877,'3041','468',56130.03,56453.03,0.00,0.00,323.00,175712.00,0.00,0.00,0.00),('1','200','1025','257543',4903878,'3042','468',59059.51,59614.87,0.00,0.00,555.36,302115.84,0.00,0.00,0.00),('1','200','1025','257543',4903879,'3043','468',22565.03,23548.53,0.00,0.00,983.50,535024.00,0.00,0.00,0.00),('1','200','1025','257543',4903880,'3044','468',22486.33,23302.33,0.00,0.00,816.00,443904.00,0.00,0.00,0.00),('1','200','1025','257544',4903881,'3037','468',40765.07,40765.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257544',4903882,'3038','468',39806.45,39806.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257544',4903883,'3039','468',15439.04,16330.15,0.00,0.00,891.11,513279.36,0.00,0.00,0.00),('1','200','1025','257544',4903884,'3040','468',14708.38,15600.22,0.00,0.00,891.84,513699.84,0.00,0.00,0.00),('1','200','1025','257544',4903885,'3041','468',56453.03,56877.53,0.00,0.00,424.50,230928.00,0.00,0.00,0.00),('1','200','1025','257544',4903886,'3042','468',59614.87,60171.87,0.00,0.00,557.00,303008.00,0.00,0.00,0.00),('1','200','1025','257544',4903887,'3043','468',23548.53,23982.03,0.00,0.00,433.50,235824.00,0.00,0.00,0.00),('1','200','1025','257544',4903888,'3044','468',23302.33,23664.33,0.00,0.00,362.00,196928.00,0.00,0.00,0.00),('1','200','1025','257545',4903889,'3037','468',40765.07,40765.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257545',4903890,'3038','468',39806.45,39806.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257545',4903891,'3039','468',16330.15,17352.45,0.00,0.00,1022.30,588844.80,0.00,0.00,0.00),('1','200','1025','257545',4903892,'3040','468',15600.22,16671.24,0.00,0.00,1071.02,616907.52,0.00,0.00,0.00),('1','200','1025','257545',4903893,'3041','468',56877.53,57296.53,0.00,0.00,419.00,227936.00,0.00,0.00,0.00),('1','200','1025','257545',4903894,'3042','468',60171.87,60680.87,0.00,0.00,509.00,276896.00,0.00,0.00,0.00),('1','200','1025','257545',4903895,'3043','468',23982.03,24753.03,0.00,0.00,771.00,419424.00,0.00,0.00,0.00),('1','200','1025','257545',4903896,'3044','468',23664.33,24304.83,0.00,0.00,640.50,348432.00,0.00,0.00,0.00),('1','200','1025','257546',4903897,'3037','468',40765.07,41241.40,0.00,0.00,476.33,274366.08,0.00,0.00,0.00),('1','200','1025','257546',4903898,'3038','468',39806.45,40341.22,0.00,0.00,534.77,308027.52,0.00,0.00,0.00),('1','200','1025','257546',4903899,'3039','468',17352.45,17830.57,0.00,0.00,478.12,275397.12,0.00,0.00,0.00),('1','200','1025','257546',4903900,'3040','468',16671.24,17305.11,0.00,0.00,633.87,365109.12,0.00,0.00,0.00),('1','200','1025','257546',4903901,'3041','468',57296.53,57856.64,0.00,0.00,560.11,305099.84,0.00,0.00,0.00),('1','200','1025','257546',4903902,'3042','468',60680.87,61075.87,0.00,0.00,395.00,214880.00,0.00,0.00,0.00),('1','200','1025','257546',4903903,'3043','468',24753.03,25011.53,0.00,0.00,258.50,140624.00,0.00,0.00,0.00),('1','200','1025','257546',4903904,'3044','468',24304.83,24636.83,0.00,0.00,332.00,180608.00,0.00,0.00,0.00),('1','200','1025','257547',4903905,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257547',4903906,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257547',4903907,'3039','468',17830.57,19138.31,0.00,0.00,1307.74,753258.24,0.00,0.00,0.00),('1','200','1025','257547',4903908,'3040','468',17305.11,18557.31,0.00,0.00,1252.20,721267.20,0.00,0.00,0.00),('1','200','1025','257547',4903909,'3041','468',57856.64,58301.25,0.00,0.00,444.61,241867.84,0.00,0.00,0.00),('1','200','1025','257547',4903910,'3042','468',61075.87,61855.87,0.00,0.00,780.00,423320.00,0.00,0.00,0.00),('1','200','1025','257547',4903911,'3043','468',25011.53,25939.63,0.00,0.00,928.10,504886.40,0.00,0.00,0.00),('1','200','1025','257547',4903912,'3044','468',24636.83,25356.66,0.00,0.00,719.83,391587.52,0.00,0.00,0.00),('1','200','1025','257548',4903913,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257548',4903914,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257548',4903915,'3039','468',19138.31,20032.80,0.00,0.00,894.49,515226.24,0.00,0.00,0.00),('1','200','1025','257548',4903916,'3040','468',18557.31,19896.84,0.00,0.00,1339.53,771569.28,0.00,0.00,0.00),('1','200','1025','257548',4903917,'3041','468',58301.25,59221.37,0.00,0.00,920.12,500545.28,0.00,0.00,0.00),('1','200','1025','257548',4903918,'3042','468',61855.87,62818.26,0.00,0.00,962.39,522740.16,0.00,0.00,0.00),('1','200','1025','257548',4903919,'3043','468',25939.63,26558.94,0.00,0.00,619.31,336904.64,0.00,0.00,0.00),('1','200','1025','257548',4903920,'3044','468',25356.66,25765.75,0.00,0.00,409.09,222544.96,0.00,0.00,0.00),('1','200','1025','257549',4903921,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257549',4903922,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257549',4903923,'3039','468',20032.80,20240.19,0.00,0.00,207.39,119456.64,0.00,0.00,0.00),('1','200','1025','257549',4903924,'3040','468',19896.84,20102.60,0.00,0.00,205.76,118517.76,0.00,0.00,0.00),('1','200','1025','257549',4903925,'3041','468',59221.37,59275.37,0.00,0.00,54.00,29376.00,0.00,0.00,0.00),('1','200','1025','257549',4903926,'3042','468',62818.26,62897.71,0.00,0.00,79.45,43220.80,0.00,0.00,0.00),('1','200','1025','257549',4903927,'3043','468',26558.94,26587.94,0.00,0.00,29.00,15776.00,0.00,0.00,0.00),('1','200','1025','257549',4903928,'3044','468',25765.75,25780.75,0.00,0.00,15.00,8160.00,0.00,0.00,0.00),('1','200','1025','257550',4903929,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257550',4903930,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257550',4903931,'3039','468',20240.19,20240.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257550',4903932,'3040','468',20102.60,20102.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257550',4903933,'3041','468',59275.37,59275.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257550',4903934,'3042','468',62897.71,62897.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257550',4903935,'3043','468',26587.94,26587.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257550',4903936,'3044','468',25780.75,25780.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257551',4903937,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257551',4903938,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257551',4903939,'3039','468',20240.19,20537.60,0.00,0.00,297.41,178446.00,0.00,0.00,0.00),('1','200','1025','257551',4903940,'3040','468',20102.60,20407.27,0.00,0.00,304.67,182802.00,0.00,0.00,0.00),('1','200','1025','257551',4903941,'3041','468',59275.37,59688.86,0.00,0.00,413.49,234862.32,0.00,0.00,0.00),('1','200','1025','257551',4903942,'3042','468',62897.71,63345.21,0.00,0.00,447.50,254180.00,0.00,0.00,0.00),('1','200','1025','257551',4903943,'3043','468',26587.94,27001.38,0.00,0.00,413.44,234833.92,0.00,0.00,0.00),('1','200','1025','257551',4903944,'3044','468',25780.75,26230.75,0.00,0.00,450.00,255600.00,0.00,0.00,0.00),('1','200','1025','257552',4903945,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257552',4903946,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257552',4903947,'3039','468',20537.60,21386.61,0.00,0.00,849.01,543366.40,0.00,0.00,0.00),('1','200','1025','257552',4903948,'3040','468',20407.27,21195.85,0.00,0.00,788.58,504691.20,0.00,0.00,0.00),('1','200','1025','257552',4903949,'3041','468',59688.86,60386.44,0.00,0.00,697.58,432499.60,0.00,0.00,0.00),('1','200','1025','257552',4903950,'3042','468',63345.21,64144.63,0.00,0.00,799.42,495640.40,0.00,0.00,0.00),('1','200','1025','257552',4903951,'3043','468',27001.38,27689.04,0.00,0.00,687.66,426349.20,0.00,0.00,0.00),('1','200','1025','257552',4903952,'3044','468',26230.75,26793.36,0.00,0.00,562.61,348818.20,0.00,0.00,0.00),('1','200','1025','257553',4903953,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257553',4903954,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257553',4903955,'3039','468',21386.61,22139.89,0.00,0.00,753.28,482099.20,0.00,0.00,0.00),('1','200','1025','257553',4903956,'3040','468',21195.85,22162.28,0.00,0.00,966.43,618515.20,0.00,0.00,0.00),('1','200','1025','257553',4903957,'3041','468',60386.44,61043.04,0.00,0.00,656.60,407092.00,0.00,0.00,0.00),('1','200','1025','257553',4903958,'3042','468',64144.63,64670.27,0.00,0.00,525.64,325896.80,0.00,0.00,0.00),('1','200','1025','257553',4903959,'3043','468',27689.04,28056.04,0.00,0.00,367.00,227540.00,0.00,0.00,0.00),('1','200','1025','257553',4903960,'3044','468',26793.36,27063.36,0.00,0.00,270.00,167400.00,0.00,0.00,0.00),('1','200','1025','257554',4903961,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257554',4903962,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257554',4903963,'3039','468',22139.89,23112.11,0.00,0.00,972.22,622220.80,0.00,0.00,0.00),('1','200','1025','257554',4903964,'3040','468',22162.28,23135.31,0.00,0.00,973.03,622739.20,0.00,0.00,0.00),('1','200','1025','257554',4903965,'3041','468',61043.04,61468.52,0.00,0.00,425.48,263797.60,0.00,0.00,0.00),('1','200','1025','257554',4903966,'3042','468',64670.27,64921.77,0.00,0.00,251.50,155930.00,0.00,0.00,0.00),('1','200','1025','257554',4903967,'3043','468',28056.04,28156.04,0.00,0.00,100.00,62000.00,0.00,0.00,0.00),('1','200','1025','257554',4903968,'3044','468',27063.36,27232.36,0.00,0.00,169.00,104780.00,0.00,0.00,0.00),('1','200','1025','257555',4903969,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257555',4903970,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257555',4903971,'3039','468',23112.11,24442.46,0.00,0.00,1330.35,851424.00,0.00,0.00,0.00),('1','200','1025','257555',4903972,'3040','468',23135.31,24429.02,0.00,0.00,1293.71,827974.40,0.00,0.00,0.00),('1','200','1025','257555',4903973,'3041','468',61468.52,62499.52,0.00,0.00,1031.00,639220.00,0.00,0.00,0.00),('1','200','1025','257555',4903974,'3042','468',64921.77,65863.29,0.00,0.00,941.52,583742.40,0.00,0.00,0.00),('1','200','1025','257555',4903975,'3043','468',28156.04,29089.77,0.00,0.00,933.73,578912.60,0.00,0.00,0.00),('1','200','1025','257555',4903976,'3044','468',27232.36,28311.00,0.00,0.00,1078.64,668756.80,0.00,0.00,0.00),('1','200','1025','257556',4903977,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257556',4903978,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257556',4903979,'3039','468',24442.46,25454.85,0.00,0.00,1012.39,647929.60,0.00,0.00,0.00),('1','200','1025','257556',4903980,'3040','468',24429.02,25327.94,0.00,0.00,898.92,575308.80,0.00,0.00,0.00),('1','200','1025','257556',4903981,'3041','468',62499.52,63298.94,0.00,0.00,799.42,495640.40,0.00,0.00,0.00),('1','200','1025','257556',4903982,'3042','468',65863.29,66751.30,0.00,0.00,888.01,550566.20,0.00,0.00,0.00),('1','200','1025','257556',4903983,'3043','468',29089.77,29931.02,0.00,0.00,841.25,521575.00,0.00,0.00,0.00),('1','200','1025','257556',4903984,'3044','468',28311.00,28914.00,0.00,0.00,603.00,373860.00,0.00,0.00,0.00),('1','200','1025','257557',4903985,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257557',4903986,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257557',4903987,'3039','468',25454.85,25454.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257557',4903988,'3040','468',25327.94,25327.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257557',4903989,'3041','468',63298.94,63298.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257557',4903990,'3042','468',66751.30,66751.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257557',4903991,'3043','468',29931.02,29931.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257557',4903992,'3044','468',28914.00,28914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257558',4903993,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257558',4903994,'3038','468',40341.22,40341.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257558',4903995,'3039','468',25454.85,25841.99,0.00,0.00,387.14,263255.20,0.00,0.00,0.00),('1','200','1025','257558',4903996,'3040','468',25327.94,25693.70,0.00,0.00,365.76,248716.80,0.00,0.00,0.00),('1','200','1025','257558',4903997,'3041','468',63298.94,63571.38,0.00,0.00,272.44,174361.60,0.00,0.00,0.00),('1','200','1025','257558',4903998,'3042','468',66751.30,66889.30,0.00,0.00,138.00,88320.00,0.00,0.00,0.00),('1','200','1025','257558',4903999,'3043','468',29931.02,29951.02,0.00,0.00,20.00,12800.00,0.00,0.00,0.00),('1','200','1025','257558',4904000,'3044','468',28914.00,28930.00,0.00,0.00,16.00,10240.00,0.00,0.00,0.00),('1','200','1025','257559',4904001,'3037','468',41241.40,41241.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257559',4904002,'3038','468',40341.22,40342.22,0.00,0.00,1.00,680.00,0.00,0.00,0.00),('1','200','1025','257559',4904003,'3039','468',25841.99,27166.90,0.00,0.00,1324.91,900938.80,0.00,0.00,0.00),('1','200','1025','257559',4904004,'3040','468',25693.70,27116.93,0.00,0.00,1423.23,967796.40,0.00,0.00,0.00),('1','200','1025','257559',4904005,'3041','468',63571.38,64489.49,0.00,0.00,918.11,587590.40,0.00,0.00,0.00),('1','200','1025','257559',4904006,'3042','468',66889.30,67534.53,0.00,0.00,645.23,412947.20,0.00,0.00,0.00),('1','200','1025','257559',4904007,'3043','468',29951.02,30576.62,0.00,0.00,625.60,400384.00,0.00,0.00,0.00),('1','200','1025','257559',4904008,'3044','468',28930.00,29156.80,0.00,0.00,226.80,145152.00,0.00,0.00,0.00),('1','200','1025','257560',4904009,'3037','468',41241.40,41600.97,0.00,0.00,359.57,244507.60,0.00,0.00,0.00),('1','200','1025','257560',4904010,'3038','468',40342.22,40779.95,0.00,0.00,437.73,297656.40,0.00,0.00,0.00),('1','200','1025','257560',4904011,'3039','468',27166.90,27424.97,0.00,0.00,258.07,175487.60,0.00,0.00,0.00),('1','200','1025','257560',4904012,'3040','468',27116.93,27379.75,0.00,0.00,262.82,178717.60,0.00,0.00,0.00),('1','200','1025','257560',4904013,'3041','468',64489.49,64976.99,0.00,0.00,487.50,312000.00,0.00,0.00,0.00),('1','200','1025','257560',4904014,'3042','468',67534.53,68061.03,0.00,0.00,526.50,336960.00,0.00,0.00,0.00),('1','200','1025','257560',4904015,'3043','468',30576.62,31390.73,0.00,0.00,814.11,521030.40,0.00,0.00,0.00),('1','200','1025','257560',4904016,'3044','468',29156.80,30006.70,0.00,0.00,849.90,543936.00,0.00,0.00,0.00),('1','200','1025','257561',4904017,'3037','468',41600.97,42642.41,0.00,0.00,1041.44,708179.20,0.00,0.00,0.00),('1','200','1025','257561',4904018,'3038','468',40779.95,41667.45,0.00,0.00,887.50,603500.00,0.00,0.00,0.00),('1','200','1025','257561',4904019,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257561',4904020,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257561',4904021,'3041','468',64976.99,65749.75,0.00,0.00,772.76,494566.40,0.00,0.00,0.00),('1','200','1025','257561',4904022,'3042','468',68061.03,68823.03,0.00,0.00,762.00,487680.00,0.00,0.00,0.00),('1','200','1025','257561',4904023,'3043','468',31390.73,32346.42,0.00,0.00,955.69,611641.60,0.00,0.00,0.00),('1','200','1025','257561',4904024,'3044','468',30006.70,31150.20,0.00,0.00,1143.50,731840.00,0.00,0.00,0.00),('1','200','1025','257562',4904025,'3037','468',42642.41,43483.82,0.00,0.00,841.41,572158.80,0.00,0.00,0.00),('1','200','1025','257562',4904026,'3038','468',41667.45,42357.25,0.00,0.00,689.80,469064.00,0.00,0.00,0.00),('1','200','1025','257562',4904027,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257562',4904028,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257562',4904029,'3041','468',65749.75,66513.45,0.00,0.00,763.70,488768.00,0.00,0.00,0.00),('1','200','1025','257562',4904030,'3042','468',68823.03,69535.53,0.00,0.00,712.50,456000.00,0.00,0.00,0.00),('1','200','1025','257562',4904031,'3043','468',32346.42,33363.80,0.00,0.00,1017.38,651123.20,0.00,0.00,0.00),('1','200','1025','257562',4904032,'3044','468',31150.20,32103.20,0.00,0.00,953.00,609920.00,0.00,0.00,0.00),('1','200','1025','257563',4904033,'3037','468',43483.82,44301.37,0.00,0.00,817.55,523232.00,0.00,0.00,0.00),('1','200','1025','257563',4904034,'3038','468',42357.25,42963.62,0.00,0.00,606.37,388076.80,0.00,0.00,0.00),('1','200','1025','257563',4904035,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257563',4904036,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257563',4904037,'3041','468',66513.45,67252.45,0.00,0.00,739.00,455224.00,0.00,0.00,0.00),('1','200','1025','257563',4904038,'3042','468',69535.53,70205.98,0.00,0.00,670.45,412997.20,0.00,0.00,0.00),('1','200','1025','257563',4904039,'3043','468',33363.80,34585.17,0.00,0.00,1221.37,752363.92,0.00,0.00,0.00),('1','200','1025','257563',4904040,'3044','468',32103.20,33444.33,0.00,0.00,1341.13,826136.08,0.00,0.00,0.00),('1','200','1025','257564',4904041,'3037','468',44301.37,45049.31,0.00,0.00,747.94,478681.60,0.00,0.00,0.00),('1','200','1025','257564',4904042,'3038','468',42963.62,43731.85,0.00,0.00,768.23,491667.20,0.00,0.00,0.00),('1','200','1025','257564',4904043,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257564',4904044,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257564',4904045,'3041','468',67252.45,68094.75,0.00,0.00,842.30,518856.80,0.00,0.00,0.00),('1','200','1025','257564',4904046,'3042','468',70205.98,70952.68,0.00,0.00,746.70,459967.20,0.00,0.00,0.00),('1','200','1025','257564',4904047,'3043','468',34585.17,35425.69,0.00,0.00,840.52,517760.32,0.00,0.00,0.00),('1','200','1025','257564',4904048,'3044','468',33444.33,34481.33,0.00,0.00,1037.00,638792.00,0.00,0.00,0.00),('1','200','1025','257565',4904049,'3037','468',45049.31,45721.67,0.00,0.00,672.36,430310.40,0.00,0.00,0.00),('1','200','1025','257565',4904050,'3038','468',43731.85,44619.60,0.00,0.00,887.75,568160.00,0.00,0.00,0.00),('1','200','1025','257565',4904051,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257565',4904052,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257565',4904053,'3041','468',68094.75,68833.63,0.00,0.00,738.88,455150.08,0.00,0.00,0.00),('1','200','1025','257565',4904054,'3042','468',70952.68,71597.68,0.00,0.00,645.00,397320.00,0.00,0.00,0.00),('1','200','1025','257565',4904055,'3043','468',35425.69,35833.69,0.00,0.00,408.00,251328.00,0.00,0.00,0.00),('1','200','1025','257565',4904056,'3044','468',34481.33,34982.33,0.00,0.00,501.00,308616.00,0.00,0.00,0.00),('1','200','1025','257566',4904057,'3037','468',45721.67,46546.68,0.00,0.00,825.01,528006.40,0.00,0.00,0.00),('1','200','1025','257566',4904058,'3038','468',44619.60,45299.49,0.00,0.00,679.89,435129.60,0.00,0.00,0.00),('1','200','1025','257566',4904059,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257566',4904060,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257566',4904061,'3041','468',68833.63,69542.63,0.00,0.00,709.00,436744.00,0.00,0.00,0.00),('1','200','1025','257566',4904062,'3042','468',71597.68,72660.69,0.00,0.00,1063.01,654814.16,0.00,0.00,0.00),('1','200','1025','257566',4904063,'3043','468',35833.69,36998.09,0.00,0.00,1164.40,717270.40,0.00,0.00,0.00),('1','200','1025','257566',4904064,'3044','468',34982.33,36314.80,0.00,0.00,1332.47,820801.52,0.00,0.00,0.00),('1','200','1025','257567',4904065,'3037','468',46546.68,47448.07,0.00,0.00,901.39,576889.60,0.00,0.00,0.00),('1','200','1025','257567',4904066,'3038','468',45299.49,45958.86,0.00,0.00,659.37,421996.80,0.00,0.00,0.00),('1','200','1025','257567',4904067,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257567',4904068,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257567',4904069,'3041','468',69542.63,70592.63,0.00,0.00,1050.00,646800.00,0.00,0.00,0.00),('1','200','1025','257567',4904070,'3042','468',72660.69,73316.19,0.00,0.00,655.50,403788.00,0.00,0.00,0.00),('1','200','1025','257567',4904071,'3043','468',36998.09,37542.09,0.00,0.00,544.00,335104.00,0.00,0.00,0.00),('1','200','1025','257567',4904072,'3044','468',36314.80,36630.26,0.00,0.00,315.46,194323.36,0.00,0.00,0.00),('1','200','1025','257568',4904073,'3037','468',47448.07,47678.23,0.00,0.00,230.16,147302.40,0.00,0.00,0.00),('1','200','1025','257568',4904074,'3038','468',45958.86,46206.46,0.00,0.00,247.60,158464.00,0.00,0.00,0.00),('1','200','1025','257568',4904075,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257568',4904076,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257568',4904077,'3041','468',70592.63,71420.46,0.00,0.00,827.83,509943.28,0.00,0.00,0.00),('1','200','1025','257568',4904078,'3042','468',73316.19,73866.00,0.00,0.00,549.81,338682.96,0.00,0.00,0.00),('1','200','1025','257568',4904079,'3043','468',37542.09,38492.59,0.00,0.00,950.50,585508.00,0.00,0.00,0.00),('1','200','1025','257568',4904080,'3044','468',36630.26,37810.76,0.00,0.00,1180.50,727188.00,0.00,0.00,0.00),('1','200','1025','257569',4904081,'3037','468',47678.23,47678.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257569',4904082,'3038','468',46206.46,46206.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257569',4904083,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257569',4904084,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257569',4904085,'3041','468',71420.46,71420.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257569',4904086,'3042','468',73866.00,73866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257569',4904087,'3043','468',38492.59,38492.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257569',4904088,'3044','468',37810.76,37810.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257570',4904089,'3037','468',47678.23,48212.97,0.00,0.00,534.74,342233.60,0.00,0.00,0.00),('1','200','1025','257570',4904090,'3038','468',46206.46,46668.83,0.00,0.00,462.37,295916.80,0.00,0.00,0.00),('1','200','1025','257570',4904091,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257570',4904092,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257570',4904093,'3041','468',71420.46,72191.92,0.00,0.00,771.46,475219.36,0.00,0.00,0.00),('1','200','1025','257570',4904094,'3042','468',73866.00,74504.63,0.00,0.00,638.63,393396.08,0.00,0.00,0.00),('1','200','1025','257570',4904095,'3043','468',38492.59,39325.07,0.00,0.00,832.48,512807.68,0.00,0.00,0.00),('1','200','1025','257570',4904096,'3044','468',37810.76,38705.76,0.00,0.00,895.00,551320.00,0.00,0.00,0.00),('1','200','1025','257571',4904097,'3037','468',48212.97,48654.43,0.00,0.00,441.46,282534.40,0.00,0.00,0.00),('1','200','1025','257571',4904098,'3038','468',46668.83,47370.43,0.00,0.00,701.60,449024.00,0.00,0.00,0.00),('1','200','1025','257571',4904099,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257571',4904100,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257571',4904101,'3041','468',72191.92,73255.03,0.00,0.00,1063.11,654875.76,0.00,0.00,0.00),('1','200','1025','257571',4904102,'3042','468',74504.63,75298.63,0.00,0.00,794.00,489104.00,0.00,0.00,0.00),('1','200','1025','257571',4904103,'3043','468',39325.07,40389.76,0.00,0.00,1064.69,655849.04,0.00,0.00,0.00),('1','200','1025','257571',4904104,'3044','468',38705.76,39819.67,0.00,0.00,1113.91,686168.56,0.00,0.00,0.00),('1','200','1025','257572',4904105,'3037','468',48654.43,49497.42,0.00,0.00,842.99,539513.60,0.00,0.00,0.00),('1','200','1025','257572',4904106,'3038','468',47370.43,48016.26,0.00,0.00,645.83,413331.20,0.00,0.00,0.00),('1','200','1025','257572',4904107,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257572',4904108,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257572',4904109,'3041','468',73255.03,73845.03,0.00,0.00,590.00,363440.00,0.00,0.00,0.00),('1','200','1025','257572',4904110,'3042','468',75298.63,75861.13,0.00,0.00,562.50,346500.00,0.00,0.00,0.00),('1','200','1025','257572',4904111,'3043','468',40389.76,41105.34,0.00,0.00,715.58,440797.28,0.00,0.00,0.00),('1','200','1025','257572',4904112,'3044','468',39819.67,40802.33,0.00,0.00,982.66,605318.56,0.00,0.00,0.00),('1','200','1025','257573',4904113,'3037','468',49497.42,50403.86,0.00,0.00,906.44,616379.20,0.00,0.00,0.00),('1','200','1025','257573',4904114,'3038','468',48016.26,48664.66,0.00,0.00,648.40,440912.00,0.00,0.00,0.00),('1','200','1025','257573',4904115,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257573',4904116,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257573',4904117,'3041','468',73845.03,74666.03,0.00,0.00,821.00,527082.00,0.00,0.00,0.00),('1','200','1025','257573',4904118,'3042','468',75861.13,76530.75,0.00,0.00,669.62,429896.04,0.00,0.00,0.00),('1','200','1025','257573',4904119,'3043','468',41105.34,41823.19,0.00,0.00,717.85,460859.70,0.00,0.00,0.00),('1','200','1025','257573',4904120,'3044','468',40802.33,41618.12,0.00,0.00,815.79,523737.18,0.00,0.00,0.00),('1','200','1025','257574',4904121,'3037','468',50403.86,51198.92,0.00,0.00,795.06,540640.80,0.00,0.00,0.00),('1','200','1025','257574',4904122,'3038','468',48664.66,49260.84,0.00,0.00,596.18,405402.40,0.00,0.00,0.00),('1','200','1025','257574',4904123,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257574',4904124,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257574',4904125,'3041','468',74666.03,75368.03,0.00,0.00,702.00,450684.00,0.00,0.00,0.00),('1','200','1025','257574',4904126,'3042','468',76530.75,77303.22,0.00,0.00,772.47,495925.74,0.00,0.00,0.00),('1','200','1025','257574',4904127,'3043','468',41823.19,42663.19,0.00,0.00,840.00,539280.00,0.00,0.00,0.00),('1','200','1025','257574',4904128,'3044','468',41618.12,42481.62,0.00,0.00,863.50,554367.00,0.00,0.00,0.00),('1','200','1025','257575',4904129,'3037','468',51198.92,51436.48,0.00,0.00,237.56,161540.80,0.00,0.00,0.00),('1','200','1025','257575',4904130,'3038','468',49260.84,49438.93,0.00,0.00,178.09,121101.20,0.00,0.00,0.00),('1','200','1025','257575',4904131,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257575',4904132,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257575',4904133,'3041','468',75368.03,75881.53,0.00,0.00,513.50,329667.00,0.00,0.00,0.00),('1','200','1025','257575',4904134,'3042','468',77303.22,77627.72,0.00,0.00,324.50,208329.00,0.00,0.00,0.00),('1','200','1025','257575',4904135,'3043','468',42663.19,43098.19,0.00,0.00,435.00,279270.00,0.00,0.00,0.00),('1','200','1025','257575',4904136,'3044','468',42481.62,42865.12,0.00,0.00,383.50,246207.00,0.00,0.00,0.00),('1','200','1025','257576',4904137,'3037','468',51436.48,51436.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257576',4904138,'3038','468',49438.93,49438.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257576',4904139,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257576',4904140,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257576',4904141,'3041','468',75881.53,75881.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257576',4904142,'3042','468',77627.72,77627.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257576',4904143,'3043','468',43098.19,43098.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257576',4904144,'3044','468',42865.12,42865.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257577',4904145,'3037','468',51436.48,51999.13,0.00,0.00,562.65,382602.00,0.00,0.00,0.00),('1','200','1025','257577',4904146,'3038','468',49438.93,49830.76,0.00,0.00,391.83,266444.40,0.00,0.00,0.00),('1','200','1025','257577',4904147,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257577',4904148,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257577',4904149,'3041','468',75881.53,76024.03,0.00,0.00,142.50,91485.00,0.00,0.00,0.00),('1','200','1025','257577',4904150,'3042','468',77627.72,77812.22,0.00,0.00,184.50,118449.00,0.00,0.00,0.00),('1','200','1025','257577',4904151,'3043','468',43098.19,43490.69,0.00,0.00,392.50,251985.00,0.00,0.00,0.00),('1','200','1025','257577',4904152,'3044','468',42865.12,43243.27,0.00,0.00,378.15,242772.30,0.00,0.00,0.00),('1','200','1025','257578',4904153,'3037','468',51999.13,52716.97,0.00,0.00,717.84,488131.20,0.00,0.00,0.00),('1','200','1025','257578',4904154,'3038','468',49830.76,50593.37,0.00,0.00,762.61,518574.80,0.00,0.00,0.00),('1','200','1025','257578',4904155,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257578',4904156,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257578',4904157,'3041','468',76024.03,76831.64,0.00,0.00,807.61,518485.62,0.00,0.00,0.00),('1','200','1025','257578',4904158,'3042','468',77812.22,78376.99,0.00,0.00,564.77,362582.34,0.00,0.00,0.00),('1','200','1025','257578',4904159,'3043','468',43490.69,45007.93,0.00,0.00,1517.24,974068.08,0.00,0.00,0.00),('1','200','1025','257578',4904160,'3044','468',43243.27,44860.07,0.00,0.00,1616.80,1037985.60,0.00,0.00,0.00),('1','200','1025','257579',4904161,'3037','468',52716.97,53925.02,0.00,0.00,1208.05,821474.00,0.00,0.00,0.00),('1','200','1025','257579',4904162,'3038','468',50593.37,51740.51,0.00,0.00,1147.14,780055.20,0.00,0.00,0.00),('1','200','1025','257579',4904163,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257579',4904164,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257579',4904165,'3041','468',76831.64,77276.14,0.00,0.00,444.50,285369.00,0.00,0.00,0.00),('1','200','1025','257579',4904166,'3042','468',78376.99,78671.49,0.00,0.00,294.50,189069.00,0.00,0.00,0.00),('1','200','1025','257579',4904167,'3043','468',45007.93,45752.39,0.00,0.00,744.46,477943.32,0.00,0.00,0.00),('1','200','1025','257579',4904168,'3044','468',44860.07,45459.36,0.00,0.00,599.29,384744.18,0.00,0.00,0.00),('1','200','1025','257580',4904169,'3037','468',53925.02,55634.00,0.00,0.00,1708.98,1162106.40,0.00,0.00,0.00),('1','200','1025','257580',4904170,'3038','468',51740.51,53288.82,0.00,0.00,1548.31,1052850.80,0.00,0.00,0.00),('1','200','1025','257580',4904171,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257580',4904172,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257580',4904173,'3041','468',77276.14,78255.43,0.00,0.00,979.29,628704.18,0.00,0.00,0.00),('1','200','1025','257580',4904174,'3042','468',78671.49,79456.99,0.00,0.00,785.50,504291.00,0.00,0.00,0.00),('1','200','1025','257580',4904175,'3043','468',45752.39,46923.85,0.00,0.00,1171.46,752077.32,0.00,0.00,0.00),('1','200','1025','257580',4904176,'3044','468',45459.36,46592.02,0.00,0.00,1132.66,727167.72,0.00,0.00,0.00),('1','200','1025','257581',4904177,'3037','468',55634.00,56590.39,0.00,0.00,956.39,631217.40,0.00,0.00,0.00),('1','200','1025','257581',4904178,'3038','468',53288.82,54086.81,0.00,0.00,797.99,526673.40,0.00,0.00,0.00),('1','200','1025','257581',4904179,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257581',4904180,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257581',4904181,'3041','468',78255.43,78889.93,0.00,0.00,634.50,399735.00,0.00,0.00,0.00),('1','200','1025','257581',4904182,'3042','468',79456.99,80073.49,0.00,0.00,616.50,388395.00,0.00,0.00,0.00),('1','200','1025','257581',4904183,'3043','468',46923.85,47793.85,0.00,0.00,870.00,548100.00,0.00,0.00,0.00),('1','200','1025','257581',4904184,'3044','468',46592.02,47632.02,0.00,0.00,1040.00,655200.00,0.00,0.00,0.00),('1','200','1025','257582',4904185,'3037','468',56590.39,56590.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257582',4904186,'3038','468',54086.81,54086.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257582',4904187,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257582',4904188,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257582',4904189,'3041','468',78889.93,78889.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257582',4904190,'3042','468',80073.49,80073.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257582',4904191,'3043','468',47793.85,47793.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257582',4904192,'3044','468',47632.02,47632.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257583',4904193,'3037','468',56590.39,57070.75,0.00,0.00,480.36,317037.60,0.00,0.00,0.00),('1','200','1025','257583',4904194,'3038','468',54086.81,54490.99,0.00,0.00,404.18,266758.80,0.00,0.00,0.00),('1','200','1025','257583',4904195,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257583',4904196,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257583',4904197,'3041','468',78889.93,79384.93,0.00,0.00,495.00,311850.00,0.00,0.00,0.00),('1','200','1025','257583',4904198,'3042','468',80073.49,80642.81,0.00,0.00,569.32,358671.60,0.00,0.00,0.00),('1','200','1025','257583',4904199,'3043','468',47793.85,48321.85,0.00,0.00,528.00,332640.00,0.00,0.00,0.00),('1','200','1025','257583',4904200,'3044','468',47632.02,48158.02,0.00,0.00,526.00,331380.00,0.00,0.00,0.00),('1','200','1025','257584',4904201,'3037','468',57070.75,58730.88,0.00,0.00,1660.13,1095685.80,0.00,0.00,0.00),('1','200','1025','257584',4904202,'3038','468',54490.99,55896.30,0.00,0.00,1405.31,927504.60,0.00,0.00,0.00),('1','200','1025','257584',4904203,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257584',4904204,'3040','468',27379.75,27379.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257584',4904205,'3041','468',79384.93,80682.94,0.00,0.00,1298.01,817746.30,0.00,0.00,0.00),('1','200','1025','257584',4904206,'3042','468',80642.81,82100.31,0.00,0.00,1457.50,918225.00,0.00,0.00,0.00),('1','200','1025','257584',4904207,'3043','468',48321.85,50064.37,0.00,0.00,1742.52,1097787.60,0.00,0.00,0.00),('1','200','1025','257584',4904208,'3044','468',48158.02,49991.47,0.00,0.00,1833.45,1155073.50,0.00,0.00,0.00),('1','200','1025','257585',4904209,'3037','468',58730.88,59731.72,0.00,0.00,1000.84,660554.40,0.00,0.00,0.00),('1','200','1025','257585',4904210,'3038','468',55896.30,57002.64,0.00,0.00,1106.34,730184.40,0.00,0.00,0.00),('1','200','1025','257585',4904211,'3039','468',27424.97,27424.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257585',4904212,'3040','468',27379.75,27414.07,0.00,0.00,34.32,22651.20,0.00,0.00,0.00),('1','200','1025','257585',4904213,'3041','468',80682.94,81914.22,0.00,0.00,1231.28,775706.40,0.00,0.00,0.00),('1','200','1025','257585',4904214,'3042','468',82100.31,83455.51,0.00,0.00,1355.20,853776.00,0.00,0.00,0.00),('1','200','1025','257585',4904215,'3043','468',50064.37,51276.92,0.00,0.00,1212.55,763906.50,0.00,0.00,0.00),('1','200','1025','257585',4904216,'3044','468',49991.47,50166.03,0.00,0.00,174.56,109972.80,0.00,0.00,0.00),('1','200','1025','257586',4904217,'3037','468',59731.72,60962.21,0.00,0.00,1230.49,812123.40,0.00,0.00,0.00),('1','200','1025','257586',4904218,'3038','468',57002.64,58205.43,0.00,0.00,1202.79,793841.40,0.00,0.00,0.00),('1','200','1025','257586',4904219,'3039','468',27424.97,28828.20,0.00,0.00,1403.23,926131.80,0.00,0.00,0.00),('1','200','1025','257586',4904220,'3040','468',27414.07,28765.47,0.00,0.00,1351.40,891924.00,0.00,0.00,0.00),('1','200','1025','257586',4904221,'3041','468',81914.22,81914.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257586',4904222,'3042','468',83455.51,83455.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257586',4904223,'3043','468',51276.92,51276.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257586',4904224,'3044','468',50166.03,50166.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257587',4904225,'3037','468',60962.21,61223.85,0.00,0.00,261.64,172682.40,0.00,0.00,0.00),('1','200','1025','257587',4904226,'3038','468',58205.43,58563.67,0.00,0.00,358.24,236438.40,0.00,0.00,0.00),('1','200','1025','257587',4904227,'3039','468',28828.20,28963.43,0.00,0.00,135.23,89251.80,0.00,0.00,0.00),('1','200','1025','257587',4904228,'3040','468',28765.47,29003.89,0.00,0.00,238.42,157357.20,0.00,0.00,0.00),('1','200','1025','257587',4904229,'3041','468',81914.22,81914.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257587',4904230,'3042','468',83455.51,83455.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257587',4904231,'3043','468',51276.92,51276.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257587',4904232,'3044','468',50166.03,50166.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257588',4904233,'3037','468',61223.85,61223.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257588',4904234,'3038','468',58563.67,58563.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257588',4904235,'3039','468',28963.43,28963.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257588',4904236,'3040','468',29003.89,29003.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257588',4904237,'3041','468',81914.22,81914.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257588',4904238,'3042','468',83455.51,83455.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257588',4904239,'3043','468',51276.92,51276.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257588',4904240,'3044','468',50166.03,50166.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257589',4904241,'3037','468',61223.85,62160.89,0.00,0.00,937.04,618446.40,0.00,0.00,0.00),('1','200','1025','257589',4904242,'3038','468',58563.67,59471.29,0.00,0.00,907.62,599029.20,0.00,0.00,0.00),('1','200','1025','257589',4904243,'3039','468',28963.43,28963.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257589',4904244,'3040','468',29003.89,29003.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257589',4904245,'3041','468',81914.22,82577.15,0.00,0.00,662.93,417645.90,0.00,0.00,0.00),('1','200','1025','257589',4904246,'3042','468',83455.51,84237.52,0.00,0.00,782.01,492666.30,0.00,0.00,0.00),('1','200','1025','257589',4904247,'3043','468',51276.92,52271.92,0.00,0.00,995.00,626850.00,0.00,0.00,0.00),('1','200','1025','257589',4904248,'3044','468',50166.03,50936.92,0.00,0.00,770.89,485660.70,0.00,0.00,0.00),('1','200','1025','257590',4904249,'3037','468',62160.89,62993.12,0.00,0.00,832.23,549271.80,0.00,0.00,0.00),('1','200','1025','257590',4904250,'3038','468',59471.29,60543.94,0.00,0.00,1072.65,707949.00,0.00,0.00,0.00),('1','200','1025','257590',4904251,'3039','468',28963.43,28963.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257590',4904252,'3040','468',29003.89,29003.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257590',4904253,'3041','468',82577.15,83182.16,0.00,0.00,605.01,381156.30,0.00,0.00,0.00),('1','200','1025','257590',4904254,'3042','468',84237.52,85012.52,0.00,0.00,775.00,488250.00,0.00,0.00,0.00),('1','200','1025','257590',4904255,'3043','468',52271.92,52988.19,0.00,0.00,716.27,451250.10,0.00,0.00,0.00),('1','200','1025','257590',4904256,'3044','468',50936.92,51486.92,0.00,0.00,550.00,346500.00,0.00,0.00,0.00),('1','200','1025','257591',4904257,'3037','468',62993.12,64353.73,0.00,0.00,1360.61,898002.60,0.00,0.00,0.00),('1','200','1025','257591',4904258,'3038','468',60543.94,61943.08,0.00,0.00,1399.14,923432.40,0.00,0.00,0.00),('1','200','1025','257591',4904259,'3039','468',28963.43,28963.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257591',4904260,'3040','468',29003.89,29003.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257591',4904261,'3041','468',83182.16,83779.42,0.00,0.00,597.26,376273.80,0.00,0.00,0.00),('1','200','1025','257591',4904262,'3042','468',85012.52,85594.28,0.00,0.00,581.76,366508.80,0.00,0.00,0.00),('1','200','1025','257591',4904263,'3043','468',52988.19,54021.21,0.00,0.00,1033.02,650802.60,0.00,0.00,0.00),('1','200','1025','257591',4904264,'3044','468',51486.92,52265.42,0.00,0.00,778.50,490455.00,0.00,0.00,0.00),('1','200','1025','257592',4904265,'3037','468',64353.73,65574.89,0.00,0.00,1221.16,805965.60,0.00,0.00,0.00),('1','200','1025','257592',4904266,'3038','468',61943.08,62591.27,0.00,0.00,648.19,427805.40,0.00,0.00,0.00),('1','200','1025','257592',4904267,'3039','468',28963.43,28963.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257592',4904268,'3040','468',29003.89,29003.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257592',4904269,'3041','468',83779.42,84144.42,0.00,0.00,365.00,229950.00,0.00,0.00,0.00),('1','200','1025','257592',4904270,'3042','468',85594.28,86218.28,0.00,0.00,624.00,393120.00,0.00,0.00,0.00),('1','200','1025','257592',4904271,'3043','468',54021.21,54421.71,0.00,0.00,400.50,252315.00,0.00,0.00,0.00),('1','200','1025','257592',4904272,'3044','468',52265.42,52751.92,0.00,0.00,486.50,306495.00,0.00,0.00,0.00),('1','200','1025','257593',4904273,'3037','468',65574.89,66380.67,0.00,0.00,805.78,531814.80,0.00,0.00,0.00),('1','200','1025','257593',4904274,'3038','468',62591.27,63501.70,0.00,0.00,910.43,600883.80,0.00,0.00,0.00),('1','200','1025','257593',4904275,'3039','468',28963.43,28963.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257593',4904276,'3040','468',29003.89,29003.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257593',4904277,'3041','468',84144.42,84610.94,0.00,0.00,466.52,293907.60,0.00,0.00,0.00),('1','200','1025','257593',4904278,'3042','468',86218.28,86659.78,0.00,0.00,441.50,278145.00,0.00,0.00,0.00),('1','200','1025','257593',4904279,'3043','468',54421.71,55250.58,0.00,0.00,828.87,522188.10,0.00,0.00,0.00),('1','200','1025','257593',4904280,'3044','468',52751.92,53591.77,0.00,0.00,839.85,529105.50,0.00,0.00,0.00),('1','200','1025','257594',4904281,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257594',4904282,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257594',4904283,'3039','468',28963.43,29273.62,0.00,0.00,310.19,204725.40,0.00,0.00,0.00),('1','200','1025','257594',4904284,'3040','468',29003.89,29267.63,0.00,0.00,263.74,174068.40,0.00,0.00,0.00),('1','200','1025','257594',4904285,'3041','468',84610.94,84676.04,0.00,0.00,65.10,41013.00,0.00,0.00,0.00),('1','200','1025','257594',4904286,'3042','468',86659.78,86765.02,0.00,0.00,105.24,66301.20,0.00,0.00,0.00),('1','200','1025','257594',4904287,'3043','468',55250.58,55431.72,0.00,0.00,181.14,114118.20,0.00,0.00,0.00),('1','200','1025','257594',4904288,'3044','468',53591.77,53728.50,0.00,0.00,136.73,86139.90,0.00,0.00,0.00),('1','200','1025','257595',4904289,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257595',4904290,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257595',4904291,'3039','468',29273.62,29273.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257595',4904292,'3040','468',29267.63,29267.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257595',4904293,'3041','468',84676.04,84676.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257595',4904294,'3042','468',86765.02,86765.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257595',4904295,'3043','468',55431.72,55431.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257595',4904296,'3044','468',53728.50,53728.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257596',4904297,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257596',4904298,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257596',4904299,'3039','468',29273.62,29806.96,0.00,0.00,533.34,352004.40,0.00,0.00,0.00),('1','200','1025','257596',4904300,'3040','468',29267.63,29882.96,0.00,0.00,615.33,406117.80,0.00,0.00,0.00),('1','200','1025','257596',4904301,'3041','468',84676.04,85101.94,0.00,0.00,425.90,268317.00,0.00,0.00,0.00),('1','200','1025','257596',4904302,'3042','468',86765.02,87269.53,0.00,0.00,504.51,317841.30,0.00,0.00,0.00),('1','200','1025','257596',4904303,'3043','468',55431.72,55815.48,0.00,0.00,383.76,241768.80,0.00,0.00,0.00),('1','200','1025','257596',4904304,'3044','468',53728.50,54130.77,0.00,0.00,402.27,253430.10,0.00,0.00,0.00),('1','200','1025','257597',4904305,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257597',4904306,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257597',4904307,'3039','468',29806.96,30852.56,0.00,0.00,1045.60,690096.00,0.00,0.00,0.00),('1','200','1025','257597',4904308,'3040','468',29882.96,31057.44,0.00,0.00,1174.48,775156.80,0.00,0.00,0.00),('1','200','1025','257597',4904309,'3041','468',85101.94,85533.94,0.00,0.00,432.00,272160.00,0.00,0.00,0.00),('1','200','1025','257597',4904310,'3042','468',87269.53,87915.53,0.00,0.00,646.00,406980.00,0.00,0.00,0.00),('1','200','1025','257597',4904311,'3043','468',55815.48,56743.31,0.00,0.00,927.83,584532.90,0.00,0.00,0.00),('1','200','1025','257597',4904312,'3044','468',54130.77,55047.27,0.00,0.00,916.50,577395.00,0.00,0.00,0.00),('1','200','1025','257598',4904313,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257598',4904314,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257598',4904315,'3039','468',30852.56,32019.04,0.00,0.00,1166.48,769876.80,0.00,0.00,0.00),('1','200','1025','257598',4904316,'3040','468',31057.44,32434.59,0.00,0.00,1377.15,908919.00,0.00,0.00,0.00),('1','200','1025','257598',4904317,'3041','468',85533.94,86102.62,0.00,0.00,568.68,358268.40,0.00,0.00,0.00),('1','200','1025','257598',4904318,'3042','468',87915.53,88577.53,0.00,0.00,662.00,417060.00,0.00,0.00,0.00),('1','200','1025','257598',4904319,'3043','468',56743.31,57679.81,0.00,0.00,936.50,589995.00,0.00,0.00,0.00),('1','200','1025','257598',4904320,'3044','468',55047.27,55910.77,0.00,0.00,863.50,544005.00,0.00,0.00,0.00),('1','200','1025','257599',4904321,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257599',4904322,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257599',4904323,'3039','468',32019.04,33001.33,0.00,0.00,982.29,648311.40,0.00,0.00,0.00),('1','200','1025','257599',4904324,'3040','468',32434.59,33536.74,0.00,0.00,1102.15,727419.00,0.00,0.00,0.00),('1','200','1025','257599',4904325,'3041','468',86102.62,86583.62,0.00,0.00,481.00,303030.00,0.00,0.00,0.00),('1','200','1025','257599',4904326,'3042','468',88577.53,89182.83,0.00,0.00,605.30,381339.00,0.00,0.00,0.00),('1','200','1025','257599',4904327,'3043','468',57679.81,58383.82,0.00,0.00,704.01,443526.30,0.00,0.00,0.00),('1','200','1025','257599',4904328,'3044','468',55910.77,56469.27,0.00,0.00,558.50,351855.00,0.00,0.00,0.00),('1','200','1025','257600',4904329,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257600',4904330,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257600',4904331,'3039','468',33001.33,33916.08,0.00,0.00,914.75,603735.00,0.00,0.00,0.00),('1','200','1025','257600',4904332,'3040','468',33536.74,34663.19,0.00,0.00,1126.45,743457.00,0.00,0.00,0.00),('1','200','1025','257600',4904333,'3041','468',86583.62,87180.53,0.00,0.00,596.91,376053.30,0.00,0.00,0.00),('1','200','1025','257600',4904334,'3042','468',89182.83,89502.83,0.00,0.00,320.00,201600.00,0.00,0.00,0.00),('1','200','1025','257600',4904335,'3043','468',58383.82,59136.06,0.00,0.00,752.24,473911.20,0.00,0.00,0.00),('1','200','1025','257600',4904336,'3044','468',56469.27,57271.26,0.00,0.00,801.99,505253.70,0.00,0.00,0.00),('1','200','1025','257601',4904337,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257601',4904338,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257601',4904339,'3039','468',33916.08,34113.29,0.00,0.00,197.21,130158.60,0.00,0.00,0.00),('1','200','1025','257601',4904340,'3040','468',34663.19,35072.71,0.00,0.00,409.52,270283.20,0.00,0.00,0.00),('1','200','1025','257601',4904341,'3041','468',87180.53,87820.53,0.00,0.00,640.00,403200.00,0.00,0.00,0.00),('1','200','1025','257601',4904342,'3042','468',89502.83,90106.83,0.00,0.00,604.00,380520.00,0.00,0.00,0.00),('1','200','1025','257601',4904343,'3043','468',59136.06,59485.52,0.00,0.00,349.46,220159.80,0.00,0.00,0.00),('1','200','1025','257601',4904344,'3044','468',57271.26,57486.26,0.00,0.00,215.00,135450.00,0.00,0.00,0.00),('1','200','1025','257602',4904345,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257602',4904346,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257602',4904347,'3039','468',34113.29,34113.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257602',4904348,'3040','468',35072.71,35072.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257602',4904349,'3041','468',87820.53,87820.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257602',4904350,'3042','468',90106.83,90106.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257602',4904351,'3043','468',59485.52,59485.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257602',4904352,'3044','468',57486.26,57486.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257603',4904353,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257603',4904354,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257603',4904355,'3039','468',34113.29,34923.28,0.00,0.00,809.99,534593.40,0.00,0.00,0.00),('1','200','1025','257603',4904356,'3040','468',35072.71,35842.74,0.00,0.00,770.03,508219.80,0.00,0.00,0.00),('1','200','1025','257603',4904357,'3041','468',87820.53,88084.34,0.00,0.00,263.81,166200.30,0.00,0.00,0.00),('1','200','1025','257603',4904358,'3042','468',90106.83,90932.63,0.00,0.00,825.80,520254.00,0.00,0.00,0.00),('1','200','1025','257603',4904359,'3043','468',59485.52,59927.95,0.00,0.00,442.43,278730.90,0.00,0.00,0.00),('1','200','1025','257603',4904360,'3044','468',57486.26,57855.26,0.00,0.00,369.00,232470.00,0.00,0.00,0.00),('1','200','1025','257604',4904361,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257604',4904362,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257604',4904363,'3039','468',34923.28,35551.38,0.00,0.00,628.10,414546.00,0.00,0.00,0.00),('1','200','1025','257604',4904364,'3040','468',35842.74,37146.82,0.00,0.00,1304.08,860692.80,0.00,0.00,0.00),('1','200','1025','257604',4904365,'3041','468',88084.34,88428.24,0.00,0.00,343.90,216657.00,0.00,0.00,0.00),('1','200','1025','257604',4904366,'3042','468',90932.63,91722.29,0.00,0.00,789.66,497485.80,0.00,0.00,0.00),('1','200','1025','257604',4904367,'3043','468',59927.95,60690.61,0.00,0.00,762.66,480475.80,0.00,0.00,0.00),('1','200','1025','257604',4904368,'3044','468',57855.26,58549.24,0.00,0.00,693.98,437207.40,0.00,0.00,0.00),('1','200','1025','257605',4904369,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257605',4904370,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257605',4904371,'3039','468',35551.38,36557.93,0.00,0.00,1006.55,664323.00,0.00,0.00,0.00),('1','200','1025','257605',4904372,'3040','468',37146.82,38006.60,0.00,0.00,859.78,567454.80,0.00,0.00,0.00),('1','200','1025','257605',4904373,'3041','468',88428.24,88784.24,0.00,0.00,356.00,224280.00,0.00,0.00,0.00),('1','200','1025','257605',4904374,'3042','468',91722.29,92054.29,0.00,0.00,332.00,209160.00,0.00,0.00,0.00),('1','200','1025','257605',4904375,'3043','468',60690.61,61512.67,0.00,0.00,822.06,517897.80,0.00,0.00,0.00),('1','200','1025','257605',4904376,'3044','468',58549.24,59136.24,0.00,0.00,587.00,369810.00,0.00,0.00,0.00),('1','200','1025','257606',4904377,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257606',4904378,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257606',4904379,'3039','468',36557.93,37474.08,0.00,0.00,916.15,604659.00,0.00,0.00,0.00),('1','200','1025','257606',4904380,'3040','468',38006.60,38794.93,0.00,0.00,788.33,520297.80,0.00,0.00,0.00),('1','200','1025','257606',4904381,'3041','468',88784.24,89228.74,0.00,0.00,444.50,280035.00,0.00,0.00,0.00),('1','200','1025','257606',4904382,'3042','468',92054.29,92636.79,0.00,0.00,582.50,366975.00,0.00,0.00,0.00),('1','200','1025','257606',4904383,'3043','468',61512.67,62294.67,0.00,0.00,782.00,492660.00,0.00,0.00,0.00),('1','200','1025','257606',4904384,'3044','468',59136.24,59719.24,0.00,0.00,583.00,367290.00,0.00,0.00,0.00),('1','200','1025','257607',4904385,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257607',4904386,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257607',4904387,'3039','468',37474.08,38318.93,0.00,0.00,844.85,557601.00,0.00,0.00,0.00),('1','200','1025','257607',4904388,'3040','468',38794.93,39506.88,0.00,0.00,711.95,469887.00,0.00,0.00,0.00),('1','200','1025','257607',4904389,'3041','468',89228.74,89734.74,0.00,0.00,506.00,318780.00,0.00,0.00,0.00),('1','200','1025','257607',4904390,'3042','468',92636.79,92970.79,0.00,0.00,334.00,210420.00,0.00,0.00,0.00),('1','200','1025','257607',4904391,'3043','468',62294.67,63281.68,0.00,0.00,987.01,621816.30,0.00,0.00,0.00),('1','200','1025','257607',4904392,'3044','468',59719.24,60551.37,0.00,0.00,832.13,524241.90,0.00,0.00,0.00),('1','200','1025','257608',4904393,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257608',4904394,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257608',4904395,'3039','468',38318.93,39240.80,0.00,0.00,921.87,608434.20,0.00,0.00,0.00),('1','200','1025','257608',4904396,'3040','468',39506.88,40178.43,0.00,0.00,671.55,443223.00,0.00,0.00,0.00),('1','200','1025','257608',4904397,'3041','468',89734.74,90335.64,0.00,0.00,600.90,378567.00,0.00,0.00,0.00),('1','200','1025','257608',4904398,'3042','468',92970.79,93587.79,0.00,0.00,617.00,388710.00,0.00,0.00,0.00),('1','200','1025','257608',4904399,'3043','468',63281.68,63672.58,0.00,0.00,390.90,246267.00,0.00,0.00,0.00),('1','200','1025','257608',4904400,'3044','468',60551.37,60911.37,0.00,0.00,360.00,226800.00,0.00,0.00,0.00),('1','200','1025','257609',4904401,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257609',4904402,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257609',4904403,'3039','468',39240.80,40152.08,0.00,0.00,911.28,601444.80,0.00,0.00,0.00),('1','200','1025','257609',4904404,'3040','468',40178.43,41395.80,0.00,0.00,1217.37,803464.20,0.00,0.00,0.00),('1','200','1025','257609',4904405,'3041','468',90335.64,91142.49,0.00,0.00,806.85,508315.50,0.00,0.00,0.00),('1','200','1025','257609',4904406,'3042','468',93587.79,94345.82,0.00,0.00,758.03,477558.90,0.00,0.00,0.00),('1','200','1025','257609',4904407,'3043','468',63672.58,64848.52,0.00,0.00,1175.94,740842.20,0.00,0.00,0.00),('1','200','1025','257609',4904408,'3044','468',60911.37,61931.06,0.00,0.00,1019.69,642404.70,0.00,0.00,0.00),('1','200','1025','257610',4904409,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257610',4904410,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257610',4904411,'3039','468',40152.08,41123.49,0.00,0.00,971.41,641130.60,0.00,0.00,0.00),('1','200','1025','257610',4904412,'3040','468',41395.80,42450.80,0.00,0.00,1055.00,696300.00,0.00,0.00,0.00),('1','200','1025','257610',4904413,'3041','468',91142.49,91593.00,0.00,0.00,450.51,283821.30,0.00,0.00,0.00),('1','200','1025','257610',4904414,'3042','468',94345.82,94911.82,0.00,0.00,566.00,356580.00,0.00,0.00,0.00),('1','200','1025','257610',4904415,'3043','468',64848.52,65561.52,0.00,0.00,713.00,449190.00,0.00,0.00,0.00),('1','200','1025','257610',4904416,'3044','468',61931.06,62469.06,0.00,0.00,538.00,338940.00,0.00,0.00,0.00),('1','200','1025','257611',4904417,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257611',4904418,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257611',4904419,'3039','468',41123.49,42151.34,0.00,0.00,1027.85,678381.00,0.00,0.00,0.00),('1','200','1025','257611',4904420,'3040','468',42450.80,43306.84,0.00,0.00,856.04,564986.40,0.00,0.00,0.00),('1','200','1025','257611',4904421,'3041','468',91593.00,92337.70,0.00,0.00,744.70,469161.00,0.00,0.00,0.00),('1','200','1025','257611',4904422,'3042','468',94911.82,95676.85,0.00,0.00,765.03,481968.90,0.00,0.00,0.00),('1','200','1025','257611',4904423,'3043','468',65561.52,66277.68,0.00,0.00,716.16,451180.80,0.00,0.00,0.00),('1','200','1025','257611',4904424,'3044','468',62469.06,63174.52,0.00,0.00,705.46,444439.80,0.00,0.00,0.00),('1','200','1025','257612',4904425,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257612',4904426,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257612',4904427,'3039','468',42151.34,43100.50,0.00,0.00,949.16,626445.60,0.00,0.00,0.00),('1','200','1025','257612',4904428,'3040','468',43306.84,44089.43,0.00,0.00,782.59,516509.40,0.00,0.00,0.00),('1','200','1025','257612',4904429,'3041','468',92337.70,92703.10,0.00,0.00,365.40,230202.00,0.00,0.00,0.00),('1','200','1025','257612',4904430,'3042','468',95676.85,96197.98,0.00,0.00,521.13,328311.90,0.00,0.00,0.00),('1','200','1025','257612',4904431,'3043','468',66277.68,67031.56,0.00,0.00,753.88,474944.40,0.00,0.00,0.00),('1','200','1025','257612',4904432,'3044','468',63174.52,63885.15,0.00,0.00,710.63,447696.90,0.00,0.00,0.00),('1','200','1025','257613',4904433,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257613',4904434,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257613',4904435,'3039','468',43100.50,44227.31,0.00,0.00,1126.81,743694.60,0.00,0.00,0.00),('1','200','1025','257613',4904436,'3040','468',44089.43,44952.56,0.00,0.00,863.13,569665.80,0.00,0.00,0.00),('1','200','1025','257613',4904437,'3041','468',92703.10,93188.15,0.00,0.00,485.05,305581.50,0.00,0.00,0.00),('1','200','1025','257613',4904438,'3042','468',96197.98,96742.03,0.00,0.00,544.05,342751.50,0.00,0.00,0.00),('1','200','1025','257613',4904439,'3043','468',67031.56,68017.28,0.00,0.00,985.72,621003.60,0.00,0.00,0.00),('1','200','1025','257613',4904440,'3044','468',63885.15,64644.15,0.00,0.00,759.00,478170.00,0.00,0.00,0.00),('1','200','1025','257614',4904441,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257614',4904442,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257614',4904443,'3039','468',44227.31,45316.45,0.00,0.00,1089.14,718832.40,0.00,0.00,0.00),('1','200','1025','257614',4904444,'3040','468',44952.56,46076.37,0.00,0.00,1123.81,741714.60,0.00,0.00,0.00),('1','200','1025','257614',4904445,'3041','468',93188.15,93884.15,0.00,0.00,696.00,438480.00,0.00,0.00,0.00),('1','200','1025','257614',4904446,'3042','468',96742.03,97580.03,0.00,0.00,838.00,527940.00,0.00,0.00,0.00),('1','200','1025','257614',4904447,'3043','468',68017.28,68968.39,0.00,0.00,951.11,599199.30,0.00,0.00,0.00),('1','200','1025','257614',4904448,'3044','468',64644.15,65393.04,0.00,0.00,748.89,471800.70,0.00,0.00,0.00),('1','200','1025','257615',4904449,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257615',4904450,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257615',4904451,'3039','468',45316.45,46458.91,0.00,0.00,1142.46,754023.60,0.00,0.00,0.00),('1','200','1025','257615',4904452,'3040','468',46076.37,47167.44,0.00,0.00,1091.07,720106.20,0.00,0.00,0.00),('1','200','1025','257615',4904453,'3041','468',93884.15,94405.93,0.00,0.00,521.78,328721.40,0.00,0.00,0.00),('1','200','1025','257615',4904454,'3042','468',97580.03,98084.25,0.00,0.00,504.22,317658.60,0.00,0.00,0.00),('1','200','1025','257615',4904455,'3043','468',68968.39,69674.25,0.00,0.00,705.86,444691.80,0.00,0.00,0.00),('1','200','1025','257615',4904456,'3044','468',65393.04,65936.78,0.00,0.00,543.74,342556.20,0.00,0.00,0.00),('1','200','1025','257616',4904457,'3037','468',66380.67,66380.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257616',4904458,'3038','468',63501.70,63501.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257616',4904459,'3039','468',46458.91,46458.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257616',4904460,'3040','468',47167.44,47167.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257616',4904461,'3041','468',94405.93,94405.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257616',4904462,'3042','468',98084.25,98084.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257616',4904463,'3043','468',69674.25,69674.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257616',4904464,'3044','468',65936.78,65936.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257617',4904465,'3037','468',66380.67,66927.03,0.00,0.00,546.36,360597.60,0.00,0.00,0.00),('1','200','1025','257617',4904466,'3038','468',63501.70,63928.25,0.00,0.00,426.55,281523.00,0.00,0.00,0.00),('1','200','1025','257617',4904467,'3039','468',46458.91,47876.18,0.00,0.00,1417.27,935398.20,0.00,0.00,0.00),('1','200','1025','257617',4904468,'3040','468',47167.44,48409.02,0.00,0.00,1241.58,819442.80,0.00,0.00,0.00),('1','200','1025','257617',4904469,'3041','468',94405.93,95813.95,0.00,0.00,1408.02,887052.60,0.00,0.00,0.00),('1','200','1025','257617',4904470,'3042','468',98084.25,99351.75,0.00,0.00,1267.50,798525.00,0.00,0.00,0.00),('1','200','1025','257617',4904471,'3043','468',69674.25,71382.25,0.00,0.00,1708.00,1076040.00,0.00,0.00,0.00),('1','200','1025','257617',4904472,'3044','468',65936.78,67095.28,0.00,0.00,1158.50,729855.00,0.00,0.00,0.00),('1','200','1025','257618',4904473,'3037','468',66927.03,67768.35,0.00,0.00,841.32,555271.20,0.00,0.00,0.00),('1','200','1025','257618',4904474,'3038','468',63928.25,64823.54,0.00,0.00,895.29,590891.40,0.00,0.00,0.00),('1','200','1025','257618',4904475,'3039','468',47876.18,48463.64,0.00,0.00,587.46,387723.60,0.00,0.00,0.00),('1','200','1025','257618',4904476,'3040','468',48409.02,48918.59,0.00,0.00,509.57,336316.20,0.00,0.00,0.00),('1','200','1025','257618',4904477,'3041','468',95813.95,96465.39,0.00,0.00,651.44,410407.20,0.00,0.00,0.00),('1','200','1025','257618',4904478,'3042','468',99351.75,100434.75,0.00,0.00,1083.00,682290.00,0.00,0.00,0.00),('1','200','1025','257618',4904479,'3043','468',71382.25,72809.95,0.00,0.00,1427.70,899451.00,0.00,0.00,0.00),('1','200','1025','257618',4904480,'3044','468',67095.28,68041.79,0.00,0.00,946.51,596301.30,0.00,0.00,0.00),('1','200','1025','257619',4904481,'3037','468',67768.35,68276.61,0.00,0.00,508.26,335451.60,0.00,0.00,0.00),('1','200','1025','257619',4904482,'3038','468',64823.54,65502.46,0.00,0.00,678.92,448087.20,0.00,0.00,0.00),('1','200','1025','257619',4904483,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257619',4904484,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257619',4904485,'3041','468',96465.39,96568.89,0.00,0.00,103.50,65205.00,0.00,0.00,0.00),('1','200','1025','257619',4904486,'3042','468',100434.75,100676.65,0.00,0.00,241.90,152397.00,0.00,0.00,0.00),('1','200','1025','257619',4904487,'3043','468',72809.95,73360.33,0.00,0.00,550.38,346739.40,0.00,0.00,0.00),('1','200','1025','257619',4904488,'3044','468',68041.79,68688.29,0.00,0.00,646.50,407295.00,0.00,0.00,0.00),('1','200','1025','257620',4904489,'3037','468',68276.61,68872.37,0.00,0.00,595.76,393201.60,0.00,0.00,0.00),('1','200','1025','257620',4904490,'3038','468',65502.46,66241.51,0.00,0.00,739.05,487773.00,0.00,0.00,0.00),('1','200','1025','257620',4904491,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257620',4904492,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257620',4904493,'3041','468',96568.89,96955.90,0.00,0.00,387.01,243816.30,0.00,0.00,0.00),('1','200','1025','257620',4904494,'3042','468',100676.65,100973.61,0.00,0.00,296.96,187084.80,0.00,0.00,0.00),('1','200','1025','257620',4904495,'3043','468',73360.33,74258.33,0.00,0.00,898.00,565740.00,0.00,0.00,0.00),('1','200','1025','257620',4904496,'3044','468',68688.29,69126.29,0.00,0.00,438.00,275940.00,0.00,0.00,0.00),('1','200','1025','257621',4904497,'3037','468',68872.37,69541.66,0.00,0.00,669.29,441731.40,0.00,0.00,0.00),('1','200','1025','257621',4904498,'3038','468',66241.51,67047.00,0.00,0.00,805.49,531623.40,0.00,0.00,0.00),('1','200','1025','257621',4904499,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257621',4904500,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257621',4904501,'3041','468',96955.90,97636.05,0.00,0.00,680.15,428494.50,0.00,0.00,0.00),('1','200','1025','257621',4904502,'3042','468',100973.61,101904.11,0.00,0.00,930.50,586215.00,0.00,0.00,0.00),('1','200','1025','257621',4904503,'3043','468',74258.33,75342.76,0.00,0.00,1084.43,683190.90,0.00,0.00,0.00),('1','200','1025','257621',4904504,'3044','468',69126.29,69801.29,0.00,0.00,675.00,425250.00,0.00,0.00,0.00),('1','200','1025','257622',4904505,'3037','468',69541.66,70502.16,0.00,0.00,960.50,633930.00,0.00,0.00,0.00),('1','200','1025','257622',4904506,'3038','468',67047.00,67899.01,0.00,0.00,852.01,562326.60,0.00,0.00,0.00),('1','200','1025','257622',4904507,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257622',4904508,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257622',4904509,'3041','468',97636.05,98011.21,0.00,0.00,375.16,236350.80,0.00,0.00,0.00),('1','200','1025','257622',4904510,'3042','468',101904.11,102594.56,0.00,0.00,690.45,434983.50,0.00,0.00,0.00),('1','200','1025','257622',4904511,'3043','468',75342.76,76151.34,0.00,0.00,808.58,509405.40,0.00,0.00,0.00),('1','200','1025','257622',4904512,'3044','468',69801.29,70120.29,0.00,0.00,319.00,200970.00,0.00,0.00,0.00),('1','200','1025','257623',4904513,'3037','468',70502.16,71954.85,0.00,0.00,1452.69,958775.40,0.00,0.00,0.00),('1','200','1025','257623',4904514,'3038','468',67899.01,68863.80,0.00,0.00,964.79,636761.40,0.00,0.00,0.00),('1','200','1025','257623',4904515,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257623',4904516,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257623',4904517,'3041','468',98011.21,98436.93,0.00,0.00,425.72,268203.60,0.00,0.00,0.00),('1','200','1025','257623',4904518,'3042','468',102594.56,102972.56,0.00,0.00,378.00,238140.00,0.00,0.00,0.00),('1','200','1025','257623',4904519,'3043','468',76151.34,76843.84,0.00,0.00,692.50,436275.00,0.00,0.00,0.00),('1','200','1025','257623',4904520,'3044','468',70120.29,70867.29,0.00,0.00,747.00,470610.00,0.00,0.00,0.00),('1','200','1025','257624',4904521,'3037','468',71954.85,73329.73,0.00,0.00,1374.88,907420.80,0.00,0.00,0.00),('1','200','1025','257624',4904522,'3038','468',68863.80,70497.20,0.00,0.00,1633.40,1078044.00,0.00,0.00,0.00),('1','200','1025','257624',4904523,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257624',4904524,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257624',4904525,'3041','468',98436.93,98571.42,0.00,0.00,134.49,84728.70,0.00,0.00,0.00),('1','200','1025','257624',4904526,'3042','468',102972.56,103437.56,0.00,0.00,465.00,292950.00,0.00,0.00,0.00),('1','200','1025','257624',4904527,'3043','468',76843.84,77766.41,0.00,0.00,922.57,581219.10,0.00,0.00,0.00),('1','200','1025','257624',4904528,'3044','468',70867.29,71629.42,0.00,0.00,762.13,480141.90,0.00,0.00,0.00),('1','200','1025','257625',4904529,'3037','468',73329.73,74509.06,0.00,0.00,1179.33,778357.80,0.00,0.00,0.00),('1','200','1025','257625',4904530,'3038','468',70497.20,71733.17,0.00,0.00,1235.97,815740.20,0.00,0.00,0.00),('1','200','1025','257625',4904531,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257625',4904532,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257625',4904533,'3041','468',98571.42,99326.20,0.00,0.00,754.78,475511.40,0.00,0.00,0.00),('1','200','1025','257625',4904534,'3042','468',103437.56,104155.49,0.00,0.00,717.93,452295.90,0.00,0.00,0.00),('1','200','1025','257625',4904535,'3043','468',77766.41,78644.41,0.00,0.00,878.00,553140.00,0.00,0.00,0.00),('1','200','1025','257625',4904536,'3044','468',71629.42,72377.53,0.00,0.00,748.11,471309.30,0.00,0.00,0.00),('1','200','1025','257626',4904537,'3037','468',74509.06,75042.54,0.00,0.00,533.48,352096.80,0.00,0.00,0.00),('1','200','1025','257626',4904538,'3038','468',71733.17,72241.76,0.00,0.00,508.59,335669.40,0.00,0.00,0.00),('1','200','1025','257626',4904539,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257626',4904540,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257626',4904541,'3041','468',99326.20,99410.84,0.00,0.00,84.64,53323.20,0.00,0.00,0.00),('1','200','1025','257626',4904542,'3042','468',104155.49,104458.12,0.00,0.00,302.63,190656.90,0.00,0.00,0.00),('1','200','1025','257626',4904543,'3043','468',78644.41,79019.51,0.00,0.00,375.10,236313.00,0.00,0.00,0.00),('1','200','1025','257626',4904544,'3044','468',72377.53,72675.53,0.00,0.00,298.00,187740.00,0.00,0.00,0.00),('1','200','1025','257627',4904545,'3037','468',75042.54,75042.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257627',4904546,'3038','468',72241.76,72241.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257627',4904547,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257627',4904548,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257627',4904549,'3041','468',99410.84,99410.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257627',4904550,'3042','468',104458.12,104458.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257627',4904551,'3043','468',79019.51,79019.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257627',4904552,'3044','468',72675.53,72675.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257628',4904553,'3037','468',75042.54,75756.48,0.00,0.00,713.94,471200.40,0.00,0.00,0.00),('1','200','1025','257628',4904554,'3038','468',72241.76,72911.54,0.00,0.00,669.78,442054.80,0.00,0.00,0.00),('1','200','1025','257628',4904555,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257628',4904556,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257628',4904557,'3041','468',99410.84,99628.83,0.00,0.00,217.99,137333.70,0.00,0.00,0.00),('1','200','1025','257628',4904558,'3042','468',104458.12,104872.11,0.00,0.00,413.99,260813.70,0.00,0.00,0.00),('1','200','1025','257628',4904559,'3043','468',79019.51,79396.12,0.00,0.00,376.61,237264.30,0.00,0.00,0.00),('1','200','1025','257628',4904560,'3044','468',72675.53,72846.03,0.00,0.00,170.50,107415.00,0.00,0.00,0.00),('1','200','1025','257629',4904561,'3037','468',75756.48,76983.86,0.00,0.00,1227.38,810070.80,0.00,0.00,0.00),('1','200','1025','257629',4904562,'3038','468',72911.54,74532.22,0.00,0.00,1620.68,1069648.80,0.00,0.00,0.00),('1','200','1025','257629',4904563,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257629',4904564,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257629',4904565,'3041','468',99628.83,100010.83,0.00,0.00,382.00,240660.00,0.00,0.00,0.00),('1','200','1025','257629',4904566,'3042','468',104872.11,105447.11,0.00,0.00,575.00,362250.00,0.00,0.00,0.00),('1','200','1025','257629',4904567,'3043','468',79396.12,80340.12,0.00,0.00,944.00,594720.00,0.00,0.00,0.00),('1','200','1025','257629',4904568,'3044','468',72846.03,73718.13,0.00,0.00,872.10,549423.00,0.00,0.00,0.00),('1','200','1025','257630',4904569,'3037','468',76983.86,78132.30,0.00,0.00,1148.44,757970.40,0.00,0.00,0.00),('1','200','1025','257630',4904570,'3038','468',74532.22,75621.10,0.00,0.00,1088.88,718660.80,0.00,0.00,0.00),('1','200','1025','257630',4904571,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257630',4904572,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257630',4904573,'3041','468',100010.83,100478.08,0.00,0.00,467.25,294367.50,0.00,0.00,0.00),('1','200','1025','257630',4904574,'3042','468',105447.11,106020.10,0.00,0.00,572.99,360983.70,0.00,0.00,0.00),('1','200','1025','257630',4904575,'3043','468',80340.12,80998.62,0.00,0.00,658.50,414855.00,0.00,0.00,0.00),('1','200','1025','257630',4904576,'3044','468',73718.13,74290.14,0.00,0.00,572.01,360366.30,0.00,0.00,0.00),('1','200','1025','257631',4904577,'3037','468',78132.30,79225.53,0.00,0.00,1093.23,721531.80,0.00,0.00,0.00),('1','200','1025','257631',4904578,'3038','468',75621.10,76826.76,0.00,0.00,1205.66,795735.60,0.00,0.00,0.00),('1','200','1025','257631',4904579,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257631',4904580,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257631',4904581,'3041','468',100478.08,100705.97,0.00,0.00,227.89,143570.70,0.00,0.00,0.00),('1','200','1025','257631',4904582,'3042','468',106020.10,106595.96,0.00,0.00,575.86,362791.80,0.00,0.00,0.00),('1','200','1025','257631',4904583,'3043','468',80998.62,81866.83,0.00,0.00,868.21,546972.30,0.00,0.00,0.00),('1','200','1025','257631',4904584,'3044','468',74290.14,74767.14,0.00,0.00,477.00,300510.00,0.00,0.00,0.00),('1','200','1025','257632',4904585,'3037','468',79225.53,80256.90,0.00,0.00,1031.37,680704.20,0.00,0.00,0.00),('1','200','1025','257632',4904586,'3038','468',76826.76,78080.27,0.00,0.00,1253.51,827316.60,0.00,0.00,0.00),('1','200','1025','257632',4904587,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257632',4904588,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257632',4904589,'3041','468',100705.97,101118.97,0.00,0.00,413.00,260190.00,0.00,0.00,0.00),('1','200','1025','257632',4904590,'3042','468',106595.96,106991.46,0.00,0.00,395.50,249165.00,0.00,0.00,0.00),('1','200','1025','257632',4904591,'3043','468',81866.83,82497.83,0.00,0.00,631.00,397530.00,0.00,0.00,0.00),('1','200','1025','257632',4904592,'3044','468',74767.14,75072.14,0.00,0.00,305.00,192150.00,0.00,0.00,0.00),('1','200','1025','257633',4904593,'3037','468',80256.90,80525.97,0.00,0.00,269.07,177586.20,0.00,0.00,0.00),('1','200','1025','257633',4904594,'3038','468',78080.27,78528.38,0.00,0.00,448.11,295752.60,0.00,0.00,0.00),('1','200','1025','257633',4904595,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257633',4904596,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257633',4904597,'3041','468',101118.97,101118.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257633',4904598,'3042','468',106991.46,106991.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257633',4904599,'3043','468',82497.83,82497.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257633',4904600,'3044','468',75072.14,75072.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257634',4904601,'3037','468',80525.97,80525.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257634',4904602,'3038','468',78528.38,78528.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257634',4904603,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257634',4904604,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257634',4904605,'3041','468',101118.97,101118.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257634',4904606,'3042','468',106991.46,106991.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257634',4904607,'3043','468',82497.83,82497.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257634',4904608,'3044','468',75072.14,75122.14,0.00,0.00,50.00,31500.00,0.00,0.00,0.00),('1','200','1025','257635',4904609,'3037','468',80525.97,80525.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257635',4904610,'3038','468',78528.38,78528.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257635',4904611,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257635',4904612,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257635',4904613,'3041','468',101118.97,101118.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257635',4904614,'3042','468',106991.46,106991.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257635',4904615,'3043','468',82497.83,82497.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257635',4904616,'3044','468',75122.14,75122.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257636',4904617,'3037','468',80525.97,81563.24,0.00,0.00,1037.27,713641.76,0.00,0.00,0.00),('1','200','1025','257636',4904618,'3038','468',78528.38,79446.81,0.00,0.00,918.43,631879.84,0.00,0.00,0.00),('1','200','1025','257636',4904619,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257636',4904620,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257636',4904621,'3041','468',101118.97,101304.38,0.00,0.00,185.41,119404.04,0.00,0.00,0.00),('1','200','1025','257636',4904622,'3042','468',106991.46,107426.91,0.00,0.00,435.45,280429.80,0.00,0.00,0.00),('1','200','1025','257636',4904623,'3043','468',82497.83,83204.12,0.00,0.00,706.29,454850.76,0.00,0.00,0.00),('1','200','1025','257636',4904624,'3044','468',75122.14,75494.13,0.00,0.00,371.99,239561.56,0.00,0.00,0.00),('1','200','1025','257637',4904625,'3037','468',81563.24,82554.78,0.00,0.00,991.54,682179.52,0.00,0.00,0.00),('1','200','1025','257637',4904626,'3038','468',79446.81,80390.81,0.00,0.00,944.00,649472.00,0.00,0.00,0.00),('1','200','1025','257637',4904627,'3039','468',48463.64,48463.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257637',4904628,'3040','468',48918.59,48918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257637',4904629,'3041','468',101304.38,101733.79,0.00,0.00,429.41,276540.04,0.00,0.00,0.00),('1','200','1025','257637',4904630,'3042','468',107426.91,108130.10,0.00,0.00,703.19,452854.36,0.00,0.00,0.00),('1','200','1025','257637',4904631,'3043','468',83204.12,84489.25,0.00,0.00,1285.13,827623.72,0.00,0.00,0.00),('1','200','1025','257637',4904632,'3044','468',75494.13,76357.30,0.00,0.00,863.17,555881.48,0.00,0.00,0.00),('1','200','1025','257638',4904633,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257638',4904634,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257638',4904635,'3039','468',48463.64,49342.82,0.00,0.00,879.18,604875.84,0.00,0.00,0.00),('1','200','1025','257638',4904636,'3040','468',48918.59,49788.80,0.00,0.00,870.21,598704.48,0.00,0.00,0.00),('1','200','1025','257638',4904637,'3041','468',101733.79,101873.79,0.00,0.00,140.00,90160.00,0.00,0.00,0.00),('1','200','1025','257638',4904638,'3042','468',108130.10,108538.10,0.00,0.00,408.00,262752.00,0.00,0.00,0.00),('1','200','1025','257638',4904639,'3043','468',84489.25,85031.25,0.00,0.00,542.00,349048.00,0.00,0.00,0.00),('1','200','1025','257638',4904640,'3044','468',76357.30,76906.30,0.00,0.00,549.00,353556.00,0.00,0.00,0.00),('1','200','1025','257639',4904641,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257639',4904642,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257639',4904643,'3039','468',49342.82,50402.98,0.00,0.00,1060.16,729390.08,0.00,0.00,0.00),('1','200','1025','257639',4904644,'3040','468',49788.80,50938.31,0.00,0.00,1149.51,790862.88,0.00,0.00,0.00),('1','200','1025','257639',4904645,'3041','468',101873.79,101972.79,0.00,0.00,99.00,63756.00,0.00,0.00,0.00),('1','200','1025','257639',4904646,'3042','468',108538.10,108887.78,0.00,0.00,349.68,225193.92,0.00,0.00,0.00),('1','200','1025','257639',4904647,'3043','468',85031.25,85797.75,0.00,0.00,766.50,493626.00,0.00,0.00,0.00),('1','200','1025','257639',4904648,'3044','468',76906.30,77663.98,0.00,0.00,757.68,487945.92,0.00,0.00,0.00),('1','200','1025','257640',4904649,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257640',4904650,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257640',4904651,'3039','468',50402.98,51494.03,0.00,0.00,1091.05,750642.40,0.00,0.00,0.00),('1','200','1025','257640',4904652,'3040','468',50938.31,52007.29,0.00,0.00,1068.98,735458.24,0.00,0.00,0.00),('1','200','1025','257640',4904653,'3041','468',101972.79,102228.29,0.00,0.00,255.50,165092.00,0.00,0.00,0.00),('1','200','1025','257640',4904654,'3042','468',108887.78,109256.78,0.00,0.00,369.00,237636.00,0.00,0.00,0.00),('1','200','1025','257640',4904655,'3043','468',85797.75,86668.21,0.00,0.00,870.46,560576.24,0.00,0.00,0.00),('1','200','1025','257640',4904656,'3044','468',77663.98,78573.48,0.00,0.00,909.50,585718.00,0.00,0.00,0.00),('1','200','1025','257641',4904657,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257641',4904658,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257641',4904659,'3039','468',51494.03,52127.42,0.00,0.00,633.39,435772.32,0.00,0.00,0.00),('1','200','1025','257641',4904660,'3040','468',52007.29,52796.61,0.00,0.00,789.32,543052.16,0.00,0.00,0.00),('1','200','1025','257641',4904661,'3041','468',102228.29,102601.54,0.00,0.00,373.25,240373.00,0.00,0.00,0.00),('1','200','1025','257641',4904662,'3042','468',109256.78,109758.71,0.00,0.00,501.93,323242.92,0.00,0.00,0.00),('1','200','1025','257641',4904663,'3043','468',86668.21,87223.21,0.00,0.00,555.00,357420.00,0.00,0.00,0.00),('1','200','1025','257641',4904664,'3044','468',78573.48,79027.48,0.00,0.00,454.00,292376.00,0.00,0.00,0.00),('1','200','1025','257642',4904665,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257642',4904666,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257642',4904667,'3039','468',52127.42,52127.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257642',4904668,'3040','468',52796.61,52796.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257642',4904669,'3041','468',102601.54,102601.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257642',4904670,'3042','468',109758.71,109758.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257642',4904671,'3043','468',87223.21,87223.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257642',4904672,'3044','468',79027.48,79027.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257643',4904673,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257643',4904674,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257643',4904675,'3039','468',52127.42,52479.82,0.00,0.00,352.40,242451.20,0.00,0.00,0.00),('1','200','1025','257643',4904676,'3040','468',52796.61,53155.13,0.00,0.00,358.52,246661.76,0.00,0.00,0.00),('1','200','1025','257643',4904677,'3041','468',102601.54,102881.55,0.00,0.00,280.01,180326.44,0.00,0.00,0.00),('1','200','1025','257643',4904678,'3042','468',109758.71,110084.78,0.00,0.00,326.07,209989.08,0.00,0.00,0.00),('1','200','1025','257643',4904679,'3043','468',87223.21,87440.21,0.00,0.00,217.00,139748.00,0.00,0.00,0.00),('1','200','1025','257643',4904680,'3044','468',79027.48,79298.98,0.00,0.00,271.50,174846.00,0.00,0.00,0.00),('1','200','1025','257644',4904681,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257644',4904682,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257644',4904683,'3039','468',52479.82,53863.34,0.00,0.00,1383.52,951861.76,0.00,0.00,0.00),('1','200','1025','257644',4904684,'3040','468',53155.13,54528.04,0.00,0.00,1372.91,944562.08,0.00,0.00,0.00),('1','200','1025','257644',4904685,'3041','468',102881.55,103217.05,0.00,0.00,335.50,219752.50,0.00,0.00,0.00),('1','200','1025','257644',4904686,'3042','468',110084.78,110659.57,0.00,0.00,574.79,376487.45,0.00,0.00,0.00),('1','200','1025','257644',4904687,'3043','468',87440.21,88001.29,0.00,0.00,561.08,367507.40,0.00,0.00,0.00),('1','200','1025','257644',4904688,'3044','468',79298.98,79724.98,0.00,0.00,426.00,279030.00,0.00,0.00,0.00),('1','200','1025','257645',4904689,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257645',4904690,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257645',4904691,'3039','468',53863.34,54889.49,0.00,0.00,1026.15,705991.20,0.00,0.00,0.00),('1','200','1025','257645',4904692,'3040','468',54528.04,55734.10,0.00,0.00,1206.06,829769.28,0.00,0.00,0.00),('1','200','1025','257645',4904693,'3041','468',103217.05,103562.55,0.00,0.00,345.50,226467.50,0.00,0.00,0.00),('1','200','1025','257645',4904694,'3042','468',110659.57,111065.57,0.00,0.00,406.00,266342.50,0.00,0.00,0.00),('1','200','1025','257645',4904695,'3043','468',88001.29,88574.29,0.00,0.00,573.00,375315.00,0.00,0.00,0.00),('1','200','1025','257645',4904696,'3044','468',79724.98,80234.08,0.00,0.00,509.10,333460.50,0.00,0.00,0.00),('1','200','1025','257646',4904697,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257646',4904698,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257646',4904699,'3039','468',54889.49,55979.35,0.00,0.00,1089.86,749823.68,0.00,0.00,0.00),('1','200','1025','257646',4904700,'3040','468',55734.10,56843.18,0.00,0.00,1109.08,763047.04,0.00,0.00,0.00),('1','200','1025','257646',4904701,'3041','468',103562.55,103881.05,0.00,0.00,318.50,208617.50,0.00,0.00,0.00),('1','200','1025','257646',4904702,'3042','468',111065.57,111565.07,0.00,0.00,499.50,327172.50,0.00,0.00,0.00),('1','200','1025','257646',4904703,'3043','468',88574.29,89082.79,0.00,0.00,508.50,333067.50,0.00,0.00,0.00),('1','200','1025','257646',4904704,'3044','468',80234.08,80561.08,0.00,0.00,327.00,214185.00,0.00,0.00,0.00),('1','200','1025','257647',4904705,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257647',4904706,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257647',4904707,'3039','468',55979.35,56888.26,0.00,0.00,908.91,625330.08,0.00,0.00,0.00),('1','200','1025','257647',4904708,'3040','468',56843.18,57928.69,0.00,0.00,1085.51,746830.88,0.00,0.00,0.00),('1','200','1025','257647',4904709,'3041','468',103881.05,103921.05,0.00,0.00,40.00,26200.00,0.00,0.00,0.00),('1','200','1025','257647',4904710,'3042','468',111565.07,111887.21,0.00,0.00,322.14,211001.70,0.00,0.00,0.00),('1','200','1025','257647',4904711,'3043','468',89082.79,89810.67,0.00,0.00,727.88,476761.40,0.00,0.00,0.00),('1','200','1025','257647',4904712,'3044','468',80561.08,81361.23,0.00,0.00,800.15,524098.25,0.00,0.00,0.00),('1','200','1025','257648',4904713,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257648',4904714,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257648',4904715,'3039','468',56888.26,57837.93,0.00,0.00,949.67,702755.80,0.00,0.00,0.00),('1','200','1025','257648',4904716,'3040','468',57928.69,58865.44,0.00,0.00,936.75,693195.00,0.00,0.00,0.00),('1','200','1025','257648',4904717,'3041','468',103921.05,104123.05,0.00,0.00,202.00,138370.00,0.00,0.00,0.00),('1','200','1025','257648',4904718,'3042','468',111887.21,112244.18,0.00,0.00,356.97,244524.45,0.00,0.00,0.00),('1','200','1025','257648',4904719,'3043','468',89810.67,90658.41,0.00,0.00,847.74,580701.90,0.00,0.00,0.00),('1','200','1025','257648',4904720,'3044','468',81361.23,81714.42,0.00,0.00,353.19,241935.15,0.00,0.00,0.00),('1','200','1025','257649',4904721,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257649',4904722,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257649',4904723,'3039','468',57837.93,59073.78,0.00,0.00,1235.85,914529.00,0.00,0.00,0.00),('1','200','1025','257649',4904724,'3040','468',58865.44,59986.64,0.00,0.00,1121.20,829688.00,0.00,0.00,0.00),('1','200','1025','257649',4904725,'3041','468',104123.05,104669.05,0.00,0.00,546.00,374010.00,0.00,0.00,0.00),('1','200','1025','257649',4904726,'3042','468',112244.18,112952.21,0.00,0.00,708.03,485000.55,0.00,0.00,0.00),('1','200','1025','257649',4904727,'3043','468',90658.41,90913.41,0.00,0.00,255.00,174675.00,0.00,0.00,0.00),('1','200','1025','257649',4904728,'3044','468',81714.42,81922.42,0.00,0.00,208.00,142480.00,0.00,0.00,0.00),('1','200','1025','257650',4904729,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257650',4904730,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257650',4904731,'3039','468',59073.78,60216.04,0.00,0.00,1142.26,845272.40,0.00,0.00,0.00),('1','200','1025','257650',4904732,'3040','468',59986.64,61198.70,0.00,0.00,1212.06,896924.40,0.00,0.00,0.00),('1','200','1025','257650',4904733,'3041','468',104669.05,105344.05,0.00,0.00,675.00,462375.00,0.00,0.00,0.00),('1','200','1025','257650',4904734,'3042','468',112952.21,113714.97,0.00,0.00,762.76,522490.60,0.00,0.00,0.00),('1','200','1025','257650',4904735,'3043','468',90913.41,91669.41,0.00,0.00,756.00,517860.00,0.00,0.00,0.00),('1','200','1025','257650',4904736,'3044','468',81922.42,82342.42,0.00,0.00,420.00,287700.00,0.00,0.00,0.00),('1','200','1025','257651',4904737,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257651',4904738,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257651',4904739,'3039','468',60216.04,61468.89,0.00,0.00,1252.85,927109.00,0.00,0.00,0.00),('1','200','1025','257651',4904740,'3040','468',61198.70,62396.30,0.00,0.00,1197.60,886224.00,0.00,0.00,0.00),('1','200','1025','257651',4904741,'3041','468',105344.05,105511.05,0.00,0.00,167.00,114395.00,0.00,0.00,0.00),('1','200','1025','257651',4904742,'3042','468',113714.97,114270.97,0.00,0.00,556.00,380860.00,0.00,0.00,0.00),('1','200','1025','257651',4904743,'3043','468',91669.41,92496.42,0.00,0.00,827.01,566501.85,0.00,0.00,0.00),('1','200','1025','257651',4904744,'3044','468',82342.42,82799.41,0.00,0.00,456.99,313038.15,0.00,0.00,0.00),('1','200','1025','257652',4904745,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257652',4904746,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257652',4904747,'3039','468',61468.89,63248.99,0.00,0.00,1780.10,1317274.00,0.00,0.00,0.00),('1','200','1025','257652',4904748,'3040','468',62396.30,63707.98,0.00,0.00,1311.68,970643.20,0.00,0.00,0.00),('1','200','1025','257652',4904749,'3041','468',105511.05,105924.55,0.00,0.00,413.50,283414.70,0.00,0.00,0.00),('1','200','1025','257652',4904750,'3042','468',114270.97,115009.47,0.00,0.00,738.50,505872.50,0.00,0.00,0.00),('1','200','1025','257652',4904751,'3043','468',92496.42,93119.42,0.00,0.00,623.00,426755.00,0.00,0.00,0.00),('1','200','1025','257652',4904752,'3044','468',82799.41,83217.48,0.00,0.00,418.07,286377.95,0.00,0.00,0.00),('1','200','1025','257653',4904753,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257653',4904754,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257653',4904755,'3039','468',63248.99,64943.22,0.00,0.00,1694.23,1253730.20,0.00,0.00,0.00),('1','200','1025','257653',4904756,'3040','468',63707.98,64720.34,0.00,0.00,1012.36,749146.40,0.00,0.00,0.00),('1','200','1025','257653',4904757,'3041','468',105924.55,106299.05,0.00,0.00,374.50,256532.50,0.00,0.00,0.00),('1','200','1025','257653',4904758,'3042','468',115009.47,115639.93,0.00,0.00,630.46,431865.10,0.00,0.00,0.00),('1','200','1025','257653',4904759,'3043','468',93119.42,94053.92,0.00,0.00,934.50,640132.50,0.00,0.00,0.00),('1','200','1025','257653',4904760,'3044','468',83217.48,84028.48,0.00,0.00,811.00,555535.00,0.00,0.00,0.00),('1','200','1025','257654',4904761,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257654',4904762,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257654',4904763,'3039','468',64943.22,65399.51,0.00,0.00,456.29,337654.60,0.00,0.00,0.00),('1','200','1025','257654',4904764,'3040','468',64720.34,65017.10,0.00,0.00,296.76,219602.40,0.00,0.00,0.00),('1','200','1025','257654',4904765,'3041','468',106299.05,106349.05,0.00,0.00,50.00,34250.00,0.00,0.00,0.00),('1','200','1025','257654',4904766,'3042','468',115639.93,115758.93,0.00,0.00,119.00,81515.00,0.00,0.00,0.00),('1','200','1025','257654',4904767,'3043','468',94053.92,94290.15,0.00,0.00,236.23,161817.55,0.00,0.00,0.00),('1','200','1025','257654',4904768,'3044','468',84028.48,84126.48,0.00,0.00,98.00,67130.00,0.00,0.00,0.00),('1','200','1025','257655',4904769,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257655',4904770,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257655',4904771,'3039','468',65399.51,65399.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257655',4904772,'3040','468',65017.10,65017.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257655',4904773,'3041','468',106349.05,106349.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257655',4904774,'3042','468',115758.93,115758.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257655',4904775,'3043','468',94290.15,94290.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257655',4904776,'3044','468',84126.48,84126.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257656',4904777,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257656',4904778,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257656',4904779,'3039','468',65399.51,66342.75,0.00,0.00,943.24,697997.60,0.00,0.00,0.00),('1','200','1025','257656',4904780,'3040','468',65017.10,65847.89,0.00,0.00,830.79,614784.60,0.00,0.00,0.00),('1','200','1025','257656',4904781,'3041','468',106349.05,106941.55,0.00,0.00,592.50,411787.50,0.00,0.00,0.00),('1','200','1025','257656',4904782,'3042','468',115758.93,116373.51,0.00,0.00,614.58,427133.10,0.00,0.00,0.00),('1','200','1025','257656',4904783,'3043','468',94290.15,94837.59,0.00,0.00,547.44,380470.80,0.00,0.00,0.00),('1','200','1025','257656',4904784,'3044','468',84126.48,84457.98,0.00,0.00,331.50,230392.50,0.00,0.00,0.00),('1','200','1025','257657',4904785,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257657',4904786,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257657',4904787,'3039','468',66342.75,67601.69,0.00,0.00,1258.94,931615.60,0.00,0.00,0.00),('1','200','1025','257657',4904788,'3040','468',65847.89,67147.66,0.00,0.00,1299.77,961829.80,0.00,0.00,0.00),('1','200','1025','257657',4904789,'3041','468',106941.55,107120.55,0.00,0.00,179.00,124804.00,0.00,0.00,0.00),('1','200','1025','257657',4904790,'3042','468',116373.51,116840.18,0.00,0.00,466.67,324802.32,0.00,0.00,0.00),('1','200','1025','257657',4904791,'3043','468',94837.59,95666.28,0.00,0.00,828.69,576768.24,0.00,0.00,0.00),('1','200','1025','257657',4904792,'3044','468',84457.98,85021.09,0.00,0.00,563.11,391924.56,0.00,0.00,0.00),('1','200','1025','257658',4904793,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257658',4904794,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257658',4904795,'3039','468',67601.69,68205.00,0.00,0.00,603.31,446449.40,0.00,0.00,0.00),('1','200','1025','257658',4904796,'3040','468',67147.66,67665.84,0.00,0.00,518.18,383453.20,0.00,0.00,0.00),('1','200','1025','257658',4904797,'3041','468',107120.55,107230.55,0.00,0.00,110.00,76560.00,0.00,0.00,0.00),('1','200','1025','257658',4904798,'3042','468',116840.18,117020.18,0.00,0.00,180.00,125280.00,0.00,0.00,0.00),('1','200','1025','257658',4904799,'3043','468',95666.28,95903.56,0.00,0.00,237.28,165146.88,0.00,0.00,0.00),('1','200','1025','257658',4904800,'3044','468',85021.09,85236.09,0.00,0.00,215.00,149640.00,0.00,0.00,0.00),('1','200','1025','257659',4904801,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257659',4904802,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257659',4904803,'3039','468',68205.00,68205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257659',4904804,'3040','468',67665.84,67673.95,0.00,0.00,8.11,6001.40,0.00,0.00,0.00),('1','200','1025','257659',4904805,'3041','468',107230.55,107230.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257659',4904806,'3042','468',117020.18,117020.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257659',4904807,'3043','468',95903.56,95903.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257659',4904808,'3044','468',85236.09,85236.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257660',4904809,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257660',4904810,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257660',4904811,'3039','468',68205.00,70075.27,0.00,0.00,1870.27,1402702.50,0.00,0.00,0.00),('1','200','1025','257660',4904812,'3040','468',67673.95,69340.31,0.00,0.00,1666.36,1249770.00,0.00,0.00,0.00),('1','200','1025','257660',4904813,'3041','468',107230.55,107954.55,0.00,0.00,724.00,509696.00,0.00,0.00,0.00),('1','200','1025','257660',4904814,'3042','468',117020.18,117971.18,0.00,0.00,951.00,669504.00,0.00,0.00,0.00),('1','200','1025','257660',4904815,'3043','468',95903.56,97281.10,0.00,0.00,1377.54,969788.16,0.00,0.00,0.00),('1','200','1025','257660',4904816,'3044','468',85236.09,86521.26,0.00,0.00,1285.17,904759.68,0.00,0.00,0.00),('1','200','1025','257661',4904817,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257661',4904818,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257661',4904819,'3039','468',70075.27,71572.99,0.00,0.00,1497.72,1123290.00,0.00,0.00,0.00),('1','200','1025','257661',4904820,'3040','468',69340.31,70775.29,0.00,0.00,1434.98,1076235.00,0.00,0.00,0.00),('1','200','1025','257661',4904821,'3041','468',107954.55,108904.65,0.00,0.00,950.10,668870.40,0.00,0.00,0.00),('1','200','1025','257661',4904822,'3042','468',117971.18,119091.18,0.00,0.00,1120.00,788480.00,0.00,0.00,0.00),('1','200','1025','257661',4904823,'3043','468',97281.10,97889.60,0.00,0.00,608.50,428384.00,0.00,0.00,0.00),('1','200','1025','257661',4904824,'3044','468',86521.26,86964.26,0.00,0.00,443.00,311872.00,0.00,0.00,0.00),('1','200','1025','257662',4904825,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257662',4904826,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257662',4904827,'3039','468',71572.99,72979.55,0.00,0.00,1406.56,1054920.00,0.00,0.00,0.00),('1','200','1025','257662',4904828,'3040','468',70775.29,72396.15,0.00,0.00,1620.86,1215645.00,0.00,0.00,0.00),('1','200','1025','257662',4904829,'3041','468',108904.65,109310.65,0.00,0.00,406.00,285824.00,0.00,0.00,0.00),('1','200','1025','257662',4904830,'3042','468',119091.18,119807.68,0.00,0.00,716.50,504416.00,0.00,0.00,0.00),('1','200','1025','257662',4904831,'3043','468',97889.60,98935.60,0.00,0.00,1046.00,736384.00,0.00,0.00,0.00),('1','200','1025','257662',4904832,'3044','468',86964.26,87958.15,0.00,0.00,993.89,699698.56,0.00,0.00,0.00),('1','200','1025','257663',4904833,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257663',4904834,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257663',4904835,'3039','468',72979.55,74864.34,0.00,0.00,1884.79,1413592.50,0.00,0.00,0.00),('1','200','1025','257663',4904836,'3040','468',72396.15,74050.70,0.00,0.00,1654.55,1240912.50,0.00,0.00,0.00),('1','200','1025','257663',4904837,'3041','468',109310.65,109310.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257663',4904838,'3042','468',119807.68,119807.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257663',4904839,'3043','468',98935.60,98935.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257663',4904840,'3044','468',87958.15,87958.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257664',4904841,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257664',4904842,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257664',4904843,'3039','468',74864.34,75281.73,0.00,0.00,417.39,313042.50,0.00,0.00,0.00),('1','200','1025','257664',4904844,'3040','468',74050.70,74483.44,0.00,0.00,432.74,324555.00,0.00,0.00,0.00),('1','200','1025','257664',4904845,'3041','468',109310.65,109310.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257664',4904846,'3042','468',119807.68,119807.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257664',4904847,'3043','468',98935.60,98935.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257664',4904848,'3044','468',87958.15,87958.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257665',4904849,'3037','468',82554.78,82554.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257665',4904850,'3038','468',80390.81,80390.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257665',4904851,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257665',4904852,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257665',4904853,'3041','468',109310.65,109310.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257665',4904854,'3042','468',119807.68,119807.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257665',4904855,'3043','468',98935.60,98935.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257665',4904856,'3044','468',87958.15,87958.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257666',4904857,'3037','468',82554.78,83689.10,0.00,0.00,1134.32,850740.00,0.00,0.00,0.00),('1','200','1025','257666',4904858,'3038','468',80390.81,81756.77,0.00,0.00,1365.96,1024470.00,0.00,0.00,0.00),('1','200','1025','257666',4904859,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257666',4904860,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257666',4904861,'3041','468',109310.65,110047.30,0.00,0.00,736.65,523021.50,0.00,0.00,0.00),('1','200','1025','257666',4904862,'3042','468',119807.68,120406.03,0.00,0.00,598.35,424828.50,0.00,0.00,0.00),('1','200','1025','257666',4904863,'3043','468',98935.60,99755.60,0.00,0.00,820.00,582200.00,0.00,0.00,0.00),('1','200','1025','257666',4904864,'3044','468',87958.15,88864.15,0.00,0.00,906.00,643260.00,0.00,0.00,0.00),('1','200','1025','257667',4904865,'3037','468',83689.10,84920.22,0.00,0.00,1231.12,923340.00,0.00,0.00,0.00),('1','200','1025','257667',4904866,'3038','468',81756.77,82822.50,0.00,0.00,1065.73,799297.50,0.00,0.00,0.00),('1','200','1025','257667',4904867,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257667',4904868,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257667',4904869,'3041','468',110047.30,110362.30,0.00,0.00,315.00,223650.00,0.00,0.00,0.00),('1','200','1025','257667',4904870,'3042','468',120406.03,121186.53,0.00,0.00,780.50,554155.00,0.00,0.00,0.00),('1','200','1025','257667',4904871,'3043','468',99755.60,100544.10,0.00,0.00,788.50,559835.00,0.00,0.00,0.00),('1','200','1025','257667',4904872,'3044','468',88864.15,89407.15,0.00,0.00,543.00,385530.00,0.00,0.00,0.00),('1','200','1025','257668',4904873,'3037','468',84920.22,86190.89,0.00,0.00,1270.67,953002.50,0.00,0.00,0.00),('1','200','1025','257668',4904874,'3038','468',82822.50,84278.13,0.00,0.00,1455.63,1091722.50,0.00,0.00,0.00),('1','200','1025','257668',4904875,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257668',4904876,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257668',4904877,'3041','468',110362.30,111100.80,0.00,0.00,738.50,524335.00,0.00,0.00,0.00),('1','200','1025','257668',4904878,'3042','468',121186.53,121908.44,0.00,0.00,721.91,512556.10,0.00,0.00,0.00),('1','200','1025','257668',4904879,'3043','468',100544.10,101339.10,0.00,0.00,795.00,564450.00,0.00,0.00,0.00),('1','200','1025','257668',4904880,'3044','468',89407.15,90290.66,0.00,0.00,883.51,627292.10,0.00,0.00,0.00),('1','200','1025','257669',4904881,'3037','468',86190.89,87753.23,0.00,0.00,1562.34,1171755.00,0.00,0.00,0.00),('1','200','1025','257669',4904882,'3038','468',84278.13,85898.27,0.00,0.00,1620.14,1215105.00,0.00,0.00,0.00),('1','200','1025','257669',4904883,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257669',4904884,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257669',4904885,'3041','468',111100.80,112033.81,0.00,0.00,933.01,662437.10,0.00,0.00,0.00),('1','200','1025','257669',4904886,'3042','468',121908.44,123051.94,0.00,0.00,1143.50,811885.00,0.00,0.00,0.00),('1','200','1025','257669',4904887,'3043','468',101339.10,102978.04,0.00,0.00,1638.94,1163647.40,0.00,0.00,0.00),('1','200','1025','257669',4904888,'3044','468',90290.66,91769.17,0.00,0.00,1478.51,1049742.10,0.00,0.00,0.00),('1','200','1025','257670',4904889,'3037','468',87753.23,87983.14,0.00,0.00,229.91,172432.50,0.00,0.00,0.00),('1','200','1025','257670',4904890,'3038','468',85898.27,86071.96,0.00,0.00,173.69,130267.50,0.00,0.00,0.00),('1','200','1025','257670',4904891,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257670',4904892,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257670',4904893,'3041','468',112033.81,112033.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257670',4904894,'3042','468',123051.94,123051.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257670',4904895,'3043','468',102978.04,102978.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257670',4904896,'3044','468',91769.17,91769.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257671',4904897,'3037','468',87983.14,87983.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257671',4904898,'3038','468',86071.96,86071.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257671',4904899,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257671',4904900,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257671',4904901,'3041','468',112033.81,112033.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257671',4904902,'3042','468',123051.94,123051.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257671',4904903,'3043','468',102978.04,102978.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257671',4904904,'3044','468',91769.17,91769.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257672',4904905,'3037','468',87983.14,89298.30,0.00,0.00,1315.16,1012673.20,0.00,0.00,0.00),('1','200','1025','257672',4904906,'3038','468',86071.96,87636.09,0.00,0.00,1564.13,1204380.10,0.00,0.00,0.00),('1','200','1025','257672',4904907,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257672',4904908,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257672',4904909,'3041','468',112033.81,112827.54,0.00,0.00,793.73,575454.25,0.00,0.00,0.00),('1','200','1025','257672',4904910,'3042','468',123051.94,124335.45,0.00,0.00,1283.51,930544.75,0.00,0.00,0.00),('1','200','1025','257672',4904911,'3043','468',102978.04,104238.68,0.00,0.00,1260.64,913964.00,0.00,0.00,0.00),('1','200','1025','257672',4904912,'3044','468',91769.17,92949.13,0.00,0.00,1179.96,855471.00,0.00,0.00,0.00),('1','200','1025','257673',4904913,'3037','468',89298.30,90256.25,0.00,0.00,957.95,737621.50,0.00,0.00,0.00),('1','200','1025','257673',4904914,'3038','468',87636.09,88630.63,0.00,0.00,994.54,765795.80,0.00,0.00,0.00),('1','200','1025','257673',4904915,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257673',4904916,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257673',4904917,'3041','468',112827.54,113232.54,0.00,0.00,405.00,293625.00,0.00,0.00,0.00),('1','200','1025','257673',4904918,'3042','468',124335.45,124863.38,0.00,0.00,527.93,382749.25,0.00,0.00,0.00),('1','200','1025','257673',4904919,'3043','468',104238.68,105024.72,0.00,0.00,786.04,569879.00,0.00,0.00,0.00),('1','200','1025','257673',4904920,'3044','468',92949.13,93746.83,0.00,0.00,797.70,578332.50,0.00,0.00,0.00),('1','200','1025','257674',4904921,'3037','468',90256.25,91228.39,0.00,0.00,972.14,748547.80,0.00,0.00,0.00),('1','200','1025','257674',4904922,'3038','468',88630.63,89697.62,0.00,0.00,1066.99,821582.30,0.00,0.00,0.00),('1','200','1025','257674',4904923,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257674',4904924,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257674',4904925,'3041','468',113232.54,113484.75,0.00,0.00,252.21,182852.25,0.00,0.00,0.00),('1','200','1025','257674',4904926,'3042','468',124863.38,125326.17,0.00,0.00,462.79,335522.75,0.00,0.00,0.00),('1','200','1025','257674',4904927,'3043','468',105024.72,105565.22,0.00,0.00,540.50,391862.50,0.00,0.00,0.00),('1','200','1025','257674',4904928,'3044','468',93746.83,94365.83,0.00,0.00,619.00,448775.00,0.00,0.00,0.00),('1','200','1025','257675',4904929,'3037','468',91228.39,92156.32,0.00,0.00,927.93,714506.10,0.00,0.00,0.00),('1','200','1025','257675',4904930,'3038','468',89697.62,90723.42,0.00,0.00,1025.80,789866.00,0.00,0.00,0.00),('1','200','1025','257675',4904931,'3039','468',75281.73,75281.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257675',4904932,'3040','468',74483.44,74483.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257675',4904933,'3041','468',113484.75,113719.03,0.00,0.00,234.28,169853.00,0.00,0.00,0.00),('1','200','1025','257675',4904934,'3042','468',125326.17,125725.67,0.00,0.00,399.50,289637.50,0.00,0.00,0.00),('1','200','1025','257675',4904935,'3043','468',105565.22,105988.22,0.00,0.00,423.00,306675.00,0.00,0.00,0.00),('1','200','1025','257675',4904936,'3044','468',94365.83,94767.33,0.00,0.00,401.50,291087.50,0.00,0.00,0.00),('1','200','1025','257676',4904937,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257676',4904938,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257676',4904939,'3039','468',75281.73,76499.73,0.00,0.00,1218.00,937860.00,0.00,0.00,0.00),('1','200','1025','257676',4904940,'3040','468',74483.44,75594.11,0.00,0.00,1110.67,855215.90,0.00,0.00,0.00),('1','200','1025','257676',4904941,'3041','468',113719.03,113820.03,0.00,0.00,101.00,73225.00,0.00,0.00,0.00),('1','200','1025','257676',4904942,'3042','468',125725.67,125876.68,0.00,0.00,151.01,109482.25,0.00,0.00,0.00),('1','200','1025','257676',4904943,'3043','468',105988.22,106520.57,0.00,0.00,532.35,385953.75,0.00,0.00,0.00),('1','200','1025','257676',4904944,'3044','468',94767.33,95216.74,0.00,0.00,449.41,325822.25,0.00,0.00,0.00),('1','200','1025','257677',4904945,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257677',4904946,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257677',4904947,'3039','468',76499.73,77816.56,0.00,0.00,1316.83,1013959.10,0.00,0.00,0.00),('1','200','1025','257677',4904948,'3040','468',75594.11,76540.52,0.00,0.00,946.41,728735.70,0.00,0.00,0.00),('1','200','1025','257677',4904949,'3041','468',113820.03,114198.38,0.00,0.00,378.35,274303.75,0.00,0.00,0.00),('1','200','1025','257677',4904950,'3042','468',125876.68,126409.44,0.00,0.00,532.76,386251.00,0.00,0.00,0.00),('1','200','1025','257677',4904951,'3043','468',106520.57,107351.18,0.00,0.00,830.61,602192.25,0.00,0.00,0.00),('1','200','1025','257677',4904952,'3044','468',95216.74,96153.89,0.00,0.00,937.15,679433.75,0.00,0.00,0.00),('1','200','1025','257678',4904953,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257678',4904954,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257678',4904955,'3039','468',77816.56,79008.88,0.00,0.00,1192.32,918086.40,0.00,0.00,0.00),('1','200','1025','257678',4904956,'3040','468',76540.52,77701.30,0.00,0.00,1160.78,893800.60,0.00,0.00,0.00),('1','200','1025','257678',4904957,'3041','468',114198.38,114374.54,0.00,0.00,176.16,127716.00,0.00,0.00,0.00),('1','200','1025','257678',4904958,'3042','468',126409.44,126729.44,0.00,0.00,320.00,232000.00,0.00,0.00,0.00),('1','200','1025','257678',4904959,'3043','468',107351.18,108095.18,0.00,0.00,744.00,539400.00,0.00,0.00,0.00),('1','200','1025','257678',4904960,'3044','468',96153.89,96909.39,0.00,0.00,755.50,547737.50,0.00,0.00,0.00),('1','200','1025','257679',4904961,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257679',4904962,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257679',4904963,'3039','468',79008.88,80088.22,0.00,0.00,1079.34,831091.80,0.00,0.00,0.00),('1','200','1025','257679',4904964,'3040','468',77701.30,78646.59,0.00,0.00,945.29,727873.30,0.00,0.00,0.00),('1','200','1025','257679',4904965,'3041','468',114374.54,114500.40,0.00,0.00,125.86,91248.50,0.00,0.00,0.00),('1','200','1025','257679',4904966,'3042','468',126729.44,126878.60,0.00,0.00,149.16,108141.00,0.00,0.00,0.00),('1','200','1025','257679',4904967,'3043','468',108095.18,108718.39,0.00,0.00,623.21,451827.25,0.00,0.00,0.00),('1','200','1025','257679',4904968,'3044','468',96909.39,97420.39,0.00,0.00,511.00,370475.00,0.00,0.00,0.00),('1','200','1025','257680',4904969,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257680',4904970,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257680',4904971,'3039','468',80088.22,81203.60,0.00,0.00,1115.38,858842.60,0.00,0.00,0.00),('1','200','1025','257680',4904972,'3040','468',78646.59,79540.22,0.00,0.00,893.63,688095.10,0.00,0.00,0.00),('1','200','1025','257680',4904973,'3041','468',114500.40,114754.73,0.00,0.00,254.33,184389.25,0.00,0.00,0.00),('1','200','1025','257680',4904974,'3042','468',126878.60,127122.61,0.00,0.00,244.01,176907.25,0.00,0.00,0.00),('1','200','1025','257680',4904975,'3043','468',108718.39,109149.39,0.00,0.00,431.00,312475.00,0.00,0.00,0.00),('1','200','1025','257680',4904976,'3044','468',97420.39,97811.39,0.00,0.00,391.00,283475.00,0.00,0.00,0.00),('1','200','1025','257681',4904977,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257681',4904978,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257681',4904979,'3039','468',81203.60,82293.41,0.00,0.00,1089.81,839153.70,0.00,0.00,0.00),('1','200','1025','257681',4904980,'3040','468',79540.22,80564.14,0.00,0.00,1023.92,788418.40,0.00,0.00,0.00),('1','200','1025','257681',4904981,'3041','468',114754.73,115087.41,0.00,0.00,332.68,241193.00,0.00,0.00,0.00),('1','200','1025','257681',4904982,'3042','468',127122.61,127364.61,0.00,0.00,242.00,175450.00,0.00,0.00,0.00),('1','200','1025','257681',4904983,'3043','468',109149.39,109917.22,0.00,0.00,767.83,556676.75,0.00,0.00,0.00),('1','200','1025','257681',4904984,'3044','468',97811.39,98403.60,0.00,0.00,592.21,429352.25,0.00,0.00,0.00),('1','200','1025','257682',4904985,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257682',4904986,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257682',4904987,'3039','468',82293.41,82608.65,0.00,0.00,315.24,242734.80,0.00,0.00,0.00),('1','200','1025','257682',4904988,'3040','468',80564.14,80899.88,0.00,0.00,335.74,258519.80,0.00,0.00,0.00),('1','200','1025','257682',4904989,'3041','468',115087.41,115226.21,0.00,0.00,138.80,100630.00,0.00,0.00,0.00),('1','200','1025','257682',4904990,'3042','468',127364.61,127465.86,0.00,0.00,101.25,73406.25,0.00,0.00,0.00),('1','200','1025','257682',4904991,'3043','468',109917.22,110017.22,0.00,0.00,100.00,72500.00,0.00,0.00,0.00),('1','200','1025','257682',4904992,'3044','468',98403.60,98498.60,0.00,0.00,95.00,68875.00,0.00,0.00,0.00),('1','200','1025','257683',4904993,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257683',4904994,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257683',4904995,'3039','468',82608.65,82608.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257683',4904996,'3040','468',80899.88,80899.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257683',4904997,'3041','468',115226.21,115226.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257683',4904998,'3042','468',127465.86,127465.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257683',4904999,'3043','468',110017.22,110017.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257683',4905000,'3044','468',98498.60,98498.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257684',4905001,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257684',4905002,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257684',4905003,'3039','468',82608.65,82608.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257684',4905004,'3040','468',80899.88,80899.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257684',4905005,'3041','468',115226.21,115226.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257684',4905006,'3042','468',127465.86,127465.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257684',4905007,'3043','468',110017.22,110017.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257684',4905008,'3044','468',98498.60,98498.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257685',4905009,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257685',4905010,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257685',4905011,'3039','468',82608.65,83393.67,0.00,0.00,785.02,604465.40,0.00,0.00,0.00),('1','200','1025','257685',4905012,'3040','468',80899.88,81684.70,0.00,0.00,784.82,604311.40,0.00,0.00,0.00),('1','200','1025','257685',4905013,'3041','468',115226.21,115457.39,0.00,0.00,231.18,167605.50,0.00,0.00,0.00),('1','200','1025','257685',4905014,'3042','468',127465.86,127785.95,0.00,0.00,320.09,232065.25,0.00,0.00,0.00),('1','200','1025','257685',4905015,'3043','468',110017.22,110507.22,0.00,0.00,490.00,355250.00,0.00,0.00,0.00),('1','200','1025','257685',4905016,'3044','468',98498.60,98964.60,0.00,0.00,466.00,337850.00,0.00,0.00,0.00),('1','200','1025','257686',4905017,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257686',4905018,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257686',4905019,'3039','468',83393.67,84681.86,0.00,0.00,1288.19,991906.30,0.00,0.00,0.00),('1','200','1025','257686',4905020,'3040','468',81684.70,82742.69,0.00,0.00,1057.99,814652.30,0.00,0.00,0.00),('1','200','1025','257686',4905021,'3041','468',115457.39,115770.25,0.00,0.00,312.86,226823.50,0.00,0.00,0.00),('1','200','1025','257686',4905022,'3042','468',127785.95,128147.95,0.00,0.00,362.00,262450.00,0.00,0.00,0.00),('1','200','1025','257686',4905023,'3043','468',110507.22,111352.72,0.00,0.00,845.50,612987.50,0.00,0.00,0.00),('1','200','1025','257686',4905024,'3044','468',98964.60,99840.13,0.00,0.00,875.53,634759.25,0.00,0.00,0.00),('1','200','1025','257687',4905025,'3037','468',92156.32,92156.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257687',4905026,'3038','468',90723.42,90723.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257687',4905027,'3039','468',84681.86,85883.07,0.00,0.00,1201.21,924931.70,0.00,0.00,0.00),('1','200','1025','257687',4905028,'3040','468',82742.69,83977.70,0.00,0.00,1235.01,950957.70,0.00,0.00,0.00),('1','200','1025','257687',4905029,'3041','468',115770.25,116126.72,0.00,0.00,356.47,258440.75,0.00,0.00,0.00),('1','200','1025','257687',4905030,'3042','468',128147.95,128844.72,0.00,0.00,696.77,505158.25,0.00,0.00,0.00),('1','200','1025','257687',4905031,'3043','468',111352.72,111942.72,0.00,0.00,590.00,427750.00,0.00,0.00,0.00),('1','200','1025','257687',4905032,'3044','468',99840.13,100417.13,0.00,0.00,577.00,418325.00,0.00,0.00,0.00),('1','200','1025','257688',4905033,'3037','468',92156.32,93719.40,0.00,0.00,1563.08,1203571.60,0.00,0.00,0.00),('1','200','1025','257688',4905034,'3038','468',90723.42,92342.04,0.00,0.00,1618.62,1246337.40,0.00,0.00,0.00),('1','200','1025','257688',4905035,'3039','468',85883.07,85883.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257688',4905036,'3040','468',83977.70,83977.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257688',4905037,'3041','468',116126.72,116549.72,0.00,0.00,423.00,306675.00,0.00,0.00,0.00),('1','200','1025','257688',4905038,'3042','468',128844.72,129479.09,0.00,0.00,634.37,459918.25,0.00,0.00,0.00),('1','200','1025','257688',4905039,'3043','468',111942.72,112627.84,0.00,0.00,685.12,496712.00,0.00,0.00,0.00),('1','200','1025','257688',4905040,'3044','468',100417.13,100960.10,0.00,0.00,542.97,393653.25,0.00,0.00,0.00),('1','200','1025','257689',4905041,'3037','468',93719.40,94731.28,0.00,0.00,1011.88,779147.60,0.00,0.00,0.00),('1','200','1025','257689',4905042,'3038','468',92342.04,93501.12,0.00,0.00,1159.08,892491.60,0.00,0.00,0.00),('1','200','1025','257689',4905043,'3039','468',85883.07,85883.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257689',4905044,'3040','468',83977.70,83977.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257689',4905045,'3041','468',116549.72,117100.59,0.00,0.00,550.87,399380.75,0.00,0.00,0.00),('1','200','1025','257689',4905046,'3042','468',129479.09,129999.32,0.00,0.00,520.23,377166.75,0.00,0.00,0.00),('1','200','1025','257689',4905047,'3043','468',112627.84,113434.84,0.00,0.00,807.00,585075.00,0.00,0.00,0.00),('1','200','1025','257689',4905048,'3044','468',100960.10,101508.10,0.00,0.00,548.00,397300.00,0.00,0.00,0.00),('1','200','1025','257690',4905049,'3037','468',94731.28,95906.63,0.00,0.00,1175.35,905019.50,0.00,0.00,0.00),('1','200','1025','257690',4905050,'3038','468',93501.12,94612.82,0.00,0.00,1111.70,856009.00,0.00,0.00,0.00),('1','200','1025','257690',4905051,'3039','468',85883.07,85883.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257690',4905052,'3040','468',83977.70,83977.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257690',4905053,'3041','468',117100.59,117397.08,0.00,0.00,296.49,214955.25,0.00,0.00,0.00),('1','200','1025','257690',4905054,'3042','468',129999.32,130178.46,0.00,0.00,179.14,129876.50,0.00,0.00,0.00),('1','200','1025','257690',4905055,'3043','468',113434.84,114060.84,0.00,0.00,626.00,453850.00,0.00,0.00,0.00),('1','200','1025','257690',4905056,'3044','468',101508.10,101952.26,0.00,0.00,444.16,322016.00,0.00,0.00,0.00),('1','200','1025','257691',4905057,'3037','468',95906.63,97307.31,0.00,0.00,1400.68,1078523.60,0.00,0.00,0.00),('1','200','1025','257691',4905058,'3038','468',94612.82,96012.97,0.00,0.00,1400.15,1078115.50,0.00,0.00,0.00),('1','200','1025','257691',4905059,'3039','468',85883.07,85883.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257691',4905060,'3040','468',83977.70,83977.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257691',4905061,'3041','468',117397.08,118344.88,0.00,0.00,947.80,687155.00,0.00,0.00,0.00),('1','200','1025','257691',4905062,'3042','468',130178.46,131020.53,0.00,0.00,842.07,610500.75,0.00,0.00,0.00),('1','200','1025','257691',4905063,'3043','468',114060.84,115135.29,0.00,0.00,1074.45,778976.25,0.00,0.00,0.00),('1','200','1025','257691',4905064,'3044','468',101952.26,103071.61,0.00,0.00,1119.35,811528.75,0.00,0.00,0.00),('1','200','1025','257692',4905065,'3037','468',97307.31,98166.84,0.00,0.00,859.53,661838.10,0.00,0.00,0.00),('1','200','1025','257692',4905066,'3038','468',96012.97,96832.93,0.00,0.00,819.96,631369.20,0.00,0.00,0.00),('1','200','1025','257692',4905067,'3039','468',85883.07,85883.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257692',4905068,'3040','468',83977.70,83977.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257692',4905069,'3041','468',118344.88,118452.77,0.00,0.00,107.89,78220.25,0.00,0.00,0.00),('1','200','1025','257692',4905070,'3042','468',131020.53,131150.47,0.00,0.00,129.94,94206.50,0.00,0.00,0.00),('1','200','1025','257692',4905071,'3043','468',115135.29,115450.79,0.00,0.00,315.50,228737.50,0.00,0.00,0.00),('1','200','1025','257692',4905072,'3044','468',103071.61,103340.11,0.00,0.00,268.50,194662.50,0.00,0.00,0.00),('1','200','1025','257693',4905073,'3037','468',98166.84,98166.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257693',4905074,'3038','468',96832.93,96832.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257693',4905075,'3039','468',85883.07,85883.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257693',4905076,'3040','468',83977.70,83977.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257693',4905077,'3041','468',118452.77,118452.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257693',4905078,'3042','468',131150.47,131150.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257693',4905079,'3043','468',115450.79,115450.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257693',4905080,'3044','468',103340.11,103340.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257694',4905081,'3037','468',98166.84,99784.38,0.00,0.00,1617.54,1245505.80,0.00,0.00,0.00),('1','200','1025','257694',4905082,'3038','468',96832.93,98459.06,0.00,0.00,1626.13,1252120.10,0.00,0.00,0.00),('1','200','1025','257694',4905083,'3039','468',85883.07,85883.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257694',4905084,'3040','468',83977.70,83977.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257694',4905085,'3041','468',118452.77,119045.66,0.00,0.00,592.89,429845.25,0.00,0.00,0.00),('1','200','1025','257694',4905086,'3042','468',131150.47,131751.68,0.00,0.00,601.21,435877.25,0.00,0.00,0.00),('1','200','1025','257694',4905087,'3043','468',115450.79,116435.21,0.00,0.00,984.42,713704.50,0.00,0.00,0.00),('1','200','1025','257694',4905088,'3044','468',103340.11,104156.61,0.00,0.00,816.50,591962.50,0.00,0.00,0.00),('1','200','1025','257695',4905089,'3037','468',99784.38,101437.20,0.00,0.00,1652.82,1272671.40,0.00,0.00,0.00),('1','200','1025','257695',4905090,'3038','468',98459.06,100141.80,0.00,0.00,1682.74,1295709.80,0.00,0.00,0.00),('1','200','1025','257695',4905091,'3039','468',85883.07,85883.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257695',4905092,'3040','468',83977.70,83977.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257695',4905093,'3041','468',119045.66,120159.12,0.00,0.00,1113.46,807258.50,0.00,0.00,0.00),('1','200','1025','257695',4905094,'3042','468',131751.68,132580.20,0.00,0.00,828.52,600677.00,0.00,0.00,0.00),('1','200','1025','257695',4905095,'3043','468',116435.21,117163.72,0.00,0.00,728.51,528169.75,0.00,0.00,0.00),('1','200','1025','257695',4905096,'3044','468',104156.61,104697.11,0.00,0.00,540.50,391862.50,0.00,0.00,0.00),('1','200','1025','257696',4905097,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257696',4905098,'3038','468',100141.80,100141.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257696',4905099,'3039','468',85883.07,87529.30,0.00,0.00,1646.23,1267597.10,0.00,0.00,0.00),('1','200','1025','257696',4905100,'3040','468',83977.70,85260.28,0.00,0.00,1282.58,987586.60,0.00,0.00,0.00),('1','200','1025','257696',4905101,'3041','468',120159.12,120884.48,0.00,0.00,725.36,525886.00,0.00,0.00,0.00),('1','200','1025','257696',4905102,'3042','468',132580.20,133242.67,0.00,0.00,662.47,480290.75,0.00,0.00,0.00),('1','200','1025','257696',4905103,'3043','468',117163.72,118060.17,0.00,0.00,896.45,649926.25,0.00,0.00,0.00),('1','200','1025','257696',4905104,'3044','468',104697.11,105494.85,0.00,0.00,797.74,578361.50,0.00,0.00,0.00),('1','200','1025','257697',4905105,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257697',4905106,'3038','468',100141.80,100141.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257697',4905107,'3039','468',87529.30,89018.20,0.00,0.00,1488.90,1146453.00,0.00,0.00,0.00),('1','200','1025','257697',4905108,'3040','468',85260.28,86812.44,0.00,0.00,1552.16,1195163.20,0.00,0.00,0.00),('1','200','1025','257697',4905109,'3041','468',120884.48,121256.48,0.00,0.00,372.00,269700.00,0.00,0.00,0.00),('1','200','1025','257697',4905110,'3042','468',133242.67,133906.88,0.00,0.00,664.21,481552.25,0.00,0.00,0.00),('1','200','1025','257697',4905111,'3043','468',118060.17,119112.54,0.00,0.00,1052.37,762968.25,0.00,0.00,0.00),('1','200','1025','257697',4905112,'3044','468',105494.85,106199.10,0.00,0.00,704.25,510581.25,0.00,0.00,0.00),('1','200','1025','257698',4905113,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257698',4905114,'3038','468',100141.80,100141.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257698',4905115,'3039','468',89018.20,90513.45,0.00,0.00,1495.25,1150575.50,0.00,0.00,0.00),('1','200','1025','257698',4905116,'3040','468',86812.44,88149.09,0.00,0.00,1336.65,1029220.50,0.00,0.00,0.00),('1','200','1025','257698',4905117,'3041','468',121256.48,121832.82,0.00,0.00,576.34,417846.50,0.00,0.00,0.00),('1','200','1025','257698',4905118,'3042','468',133906.88,134415.45,0.00,0.00,508.57,368713.25,0.00,0.00,0.00),('1','200','1025','257698',4905119,'3043','468',119112.54,119911.11,0.00,0.00,798.57,578963.25,0.00,0.00,0.00),('1','200','1025','257698',4905120,'3044','468',106199.10,107144.60,0.00,0.00,945.50,685487.50,0.00,0.00,0.00),('1','200','1025','257699',4905121,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257699',4905122,'3038','468',100141.80,100141.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257699',4905123,'3039','468',90513.45,92290.10,0.00,0.00,1776.65,1363520.50,0.00,0.00,0.00),('1','200','1025','257699',4905124,'3040','468',88149.09,89724.68,0.00,0.00,1575.59,1213204.30,0.00,0.00,0.00),('1','200','1025','257699',4905125,'3041','468',121832.82,122227.82,0.00,0.00,395.00,286375.00,0.00,0.00,0.00),('1','200','1025','257699',4905126,'3042','468',134415.45,134919.45,0.00,0.00,504.00,365400.00,0.00,0.00,0.00),('1','200','1025','257699',4905127,'3043','468',119911.11,120829.11,0.00,0.00,918.00,665550.00,0.00,0.00,0.00),('1','200','1025','257699',4905128,'3044','468',107144.60,108070.71,0.00,0.00,926.11,671429.75,0.00,0.00,0.00),('1','200','1025','257700',4905129,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257700',4905130,'3038','468',100141.80,100680.33,0.00,0.00,538.53,414668.10,0.00,0.00,0.00),('1','200','1025','257700',4905131,'3039','468',92290.10,93894.17,0.00,0.00,1604.07,1235133.90,0.00,0.00,0.00),('1','200','1025','257700',4905132,'3040','468',89724.68,91416.05,0.00,0.00,1691.37,1302354.90,0.00,0.00,0.00),('1','200','1025','257700',4905133,'3041','468',122227.82,123263.58,0.00,0.00,1035.76,751016.45,0.00,0.00,0.00),('1','200','1025','257700',4905134,'3042','468',134919.45,136489.61,0.00,0.00,1570.16,1138366.00,0.00,0.00,0.00),('1','200','1025','257700',4905135,'3043','468',120829.11,122515.29,0.00,0.00,1686.18,1222480.50,0.00,0.00,0.00),('1','200','1025','257700',4905136,'3044','468',108070.71,109726.71,0.00,0.00,1656.00,1200600.00,0.00,0.00,0.00),('1','200','1025','257701',4905137,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257701',4905138,'3038','468',100680.33,100680.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257701',4905139,'3039','468',93894.17,94641.89,0.00,0.00,747.72,575744.40,0.00,0.00,0.00),('1','200','1025','257701',4905140,'3040','468',91416.05,92028.19,0.00,0.00,612.14,471347.80,0.00,0.00,0.00),('1','200','1025','257701',4905141,'3041','468',123263.58,123642.58,0.00,0.00,379.00,274775.00,0.00,0.00,0.00),('1','200','1025','257701',4905142,'3042','468',136489.61,136938.30,0.00,0.00,448.69,325300.25,0.00,0.00,0.00),('1','200','1025','257701',4905143,'3043','468',122515.29,122927.98,0.00,0.00,412.69,299200.25,0.00,0.00,0.00),('1','200','1025','257701',4905144,'3044','468',109726.71,109954.05,0.00,0.00,227.34,164821.50,0.00,0.00,0.00),('1','200','1025','257702',4905145,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257702',4905146,'3038','468',100680.33,100680.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257702',4905147,'3039','468',94641.89,94740.14,0.00,0.00,98.25,75652.50,0.00,0.00,0.00),('1','200','1025','257702',4905148,'3040','468',92028.19,92111.06,0.00,0.00,82.87,63809.90,0.00,0.00,0.00),('1','200','1025','257702',4905149,'3041','468',123642.58,123718.08,0.00,0.00,75.50,54737.50,0.00,0.00,0.00),('1','200','1025','257702',4905150,'3042','468',136938.30,137033.44,0.00,0.00,95.14,68976.50,0.00,0.00,0.00),('1','200','1025','257702',4905151,'3043','468',122927.98,123080.70,0.00,0.00,152.72,110722.00,0.00,0.00,0.00),('1','200','1025','257702',4905152,'3044','468',109954.05,110062.05,0.00,0.00,108.00,78300.00,0.00,0.00,0.00),('1','200','1025','257703',4905153,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257703',4905154,'3038','468',100680.33,100680.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257703',4905155,'3039','468',94740.14,94740.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257703',4905156,'3040','468',92111.06,92111.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257703',4905157,'3041','468',123718.08,123718.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257703',4905158,'3042','468',137033.44,137033.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257703',4905159,'3043','468',123080.70,123080.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257703',4905160,'3044','468',110062.05,110062.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257704',4905161,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257704',4905162,'3038','468',100680.33,100680.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257704',4905163,'3039','468',94740.14,95488.77,0.00,0.00,748.63,576445.10,0.00,0.00,0.00),('1','200','1025','257704',4905164,'3040','468',92111.06,93034.43,0.00,0.00,923.37,710994.90,0.00,0.00,0.00),('1','200','1025','257704',4905165,'3041','468',123718.08,124139.31,0.00,0.00,421.23,305391.75,0.00,0.00,0.00),('1','200','1025','257704',4905166,'3042','468',137033.44,137610.63,0.00,0.00,577.19,418462.75,0.00,0.00,0.00),('1','200','1025','257704',4905167,'3043','468',123080.70,123734.99,0.00,0.00,654.29,474360.25,0.00,0.00,0.00),('1','200','1025','257704',4905168,'3044','468',110062.05,110839.55,0.00,0.00,777.50,563687.50,0.00,0.00,0.00),('1','200','1025','257705',4905169,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257705',4905170,'3038','468',100680.33,100680.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257705',4905171,'3039','468',95488.77,96810.30,0.00,0.00,1321.53,1017578.10,0.00,0.00,0.00),('1','200','1025','257705',4905172,'3040','468',93034.43,94341.19,0.00,0.00,1306.76,1006205.20,0.00,0.00,0.00),('1','200','1025','257705',4905173,'3041','468',124139.31,124139.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257705',4905174,'3042','468',137610.63,137610.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257705',4905175,'3043','468',123734.99,123734.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257705',4905176,'3044','468',110839.55,110839.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257706',4905177,'3037','468',101437.20,101437.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257706',4905178,'3038','468',100680.33,100680.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257706',4905179,'3039','468',96810.30,97689.87,0.00,0.00,879.57,677268.90,0.00,0.00,0.00),('1','200','1025','257706',4905180,'3040','468',94341.19,95606.18,0.00,0.00,1264.99,974042.30,0.00,0.00,0.00),('1','200','1025','257706',4905181,'3041','468',124139.31,124139.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257706',4905182,'3042','468',137610.63,137610.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257706',4905183,'3043','468',123734.99,123734.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257706',4905184,'3044','468',110839.55,110839.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257707',4905185,'3037','468',101437.20,102341.32,0.00,0.00,904.12,696172.40,0.00,0.00,0.00),('1','200','1025','257707',4905186,'3038','468',100680.33,101773.16,0.00,0.00,1092.83,841479.10,0.00,0.00,0.00),('1','200','1025','257707',4905187,'3039','468',97689.87,97689.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257707',4905188,'3040','468',95606.18,95606.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257707',4905189,'3041','468',124139.31,124350.81,0.00,0.00,211.50,153337.50,0.00,0.00,0.00),('1','200','1025','257707',4905190,'3042','468',137610.63,138032.22,0.00,0.00,421.59,305652.75,0.00,0.00,0.00),('1','200','1025','257707',4905191,'3043','468',123734.99,124673.18,0.00,0.00,938.19,680187.75,0.00,0.00,0.00),('1','200','1025','257707',4905192,'3044','468',110839.55,111820.46,0.00,0.00,980.91,711159.75,0.00,0.00,0.00),('1','200','1025','257708',4905193,'3037','468',102341.32,102858.24,0.00,0.00,516.92,398028.40,0.00,0.00,0.00),('1','200','1025','257708',4905194,'3038','468',101773.16,102321.61,0.00,0.00,548.45,422306.50,0.00,0.00,0.00),('1','200','1025','257708',4905195,'3039','468',97689.87,97689.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257708',4905196,'3040','468',95606.18,95606.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257708',4905197,'3041','468',124350.81,124825.79,0.00,0.00,474.98,344360.50,0.00,0.00,0.00),('1','200','1025','257708',4905198,'3042','468',138032.22,138494.68,0.00,0.00,462.46,335283.50,0.00,0.00,0.00),('1','200','1025','257708',4905199,'3043','468',124673.18,125381.18,0.00,0.00,708.00,513300.00,0.00,0.00,0.00),('1','200','1025','257708',4905200,'3044','468',111820.46,112426.46,0.00,0.00,606.00,439350.00,0.00,0.00,0.00),('1','200','1025','257709',4905201,'3037','468',102858.24,102858.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257709',4905202,'3038','468',102321.61,102321.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257709',4905203,'3039','468',97689.87,97689.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257709',4905204,'3040','468',95606.18,95606.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257709',4905205,'3041','468',124825.79,124825.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257709',4905206,'3042','468',138494.68,138494.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257709',4905207,'3043','468',125381.18,125381.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257709',4905208,'3044','468',112426.46,112426.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257710',4905209,'3037','468',102858.24,103351.00,0.00,0.00,492.76,379425.20,0.00,0.00,0.00),('1','200','1025','257710',4905210,'3038','468',102321.61,102820.38,0.00,0.00,498.77,384052.90,0.00,0.00,0.00),('1','200','1025','257710',4905211,'3039','468',97689.87,97689.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257710',4905212,'3040','468',95606.18,95606.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257710',4905213,'3041','468',124825.79,125085.27,0.00,0.00,259.48,188123.00,0.00,0.00,0.00),('1','200','1025','257710',4905214,'3042','468',138494.68,138850.61,0.00,0.00,355.93,258049.25,0.00,0.00,0.00),('1','200','1025','257710',4905215,'3043','468',125381.18,125799.68,0.00,0.00,418.50,303412.50,0.00,0.00,0.00),('1','200','1025','257710',4905216,'3044','468',112426.46,112856.46,0.00,0.00,430.00,311750.00,0.00,0.00,0.00),('1','200','1025','257711',4905217,'3037','468',103351.00,104242.29,0.00,0.00,891.29,686293.30,0.00,0.00,0.00),('1','200','1025','257711',4905218,'3038','468',102820.38,103948.31,0.00,0.00,1127.93,868506.10,0.00,0.00,0.00),('1','200','1025','257711',4905219,'3039','468',97689.87,97689.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257711',4905220,'3040','468',95606.18,95606.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257711',4905221,'3041','468',125085.27,125465.44,0.00,0.00,380.17,275623.25,0.00,0.00,0.00),('1','200','1025','257711',4905222,'3042','468',138850.61,139458.44,0.00,0.00,607.83,440676.75,0.00,0.00,0.00),('1','200','1025','257711',4905223,'3043','468',125799.68,126344.82,0.00,0.00,545.14,395226.50,0.00,0.00,0.00),('1','200','1025','257711',4905224,'3044','468',112856.46,113225.46,0.00,0.00,369.00,267525.00,0.00,0.00,0.00),('1','200','1025','257712',4905225,'3037','468',104242.29,105383.45,0.00,0.00,1141.16,878693.20,0.00,0.00,0.00),('1','200','1025','257712',4905226,'3038','468',103948.31,105315.29,0.00,0.00,1366.98,1052574.60,0.00,0.00,0.00),('1','200','1025','257712',4905227,'3039','468',97689.87,97689.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257712',4905228,'3040','468',95606.18,95606.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257712',4905229,'3041','468',125465.44,126527.55,0.00,0.00,1062.11,770029.75,0.00,0.00,0.00),('1','200','1025','257712',4905230,'3042','468',139458.44,140576.99,0.00,0.00,1118.55,810948.75,0.00,0.00,0.00),('1','200','1025','257712',4905231,'3043','468',126344.82,127099.33,0.00,0.00,754.51,547019.75,0.00,0.00,0.00),('1','200','1025','257712',4905232,'3044','468',113225.46,114238.61,0.00,0.00,1013.15,734533.75,0.00,0.00,0.00),('1','200','1025','257713',4905233,'3037','468',105383.45,106799.14,0.00,0.00,1415.69,1090081.30,0.00,0.00,0.00),('1','200','1025','257713',4905234,'3038','468',105315.29,106586.29,0.00,0.00,1271.00,978670.00,0.00,0.00,0.00),('1','200','1025','257713',4905235,'3039','468',97689.87,97689.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257713',4905236,'3040','468',95606.18,95606.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257713',4905237,'3041','468',126527.55,126894.55,0.00,0.00,367.00,266075.00,0.00,0.00,0.00),('1','200','1025','257713',4905238,'3042','468',140576.99,140875.99,0.00,0.00,299.00,216775.00,0.00,0.00,0.00),('1','200','1025','257713',4905239,'3043','468',127099.33,128074.33,0.00,0.00,975.00,706875.00,0.00,0.00,0.00),('1','200','1025','257713',4905240,'3044','468',114238.61,115016.11,0.00,0.00,777.50,563687.50,0.00,0.00,0.00),('1','200','1025','257714',4905241,'3037','468',106799.14,107681.70,0.00,0.00,882.56,679571.20,0.00,0.00,0.00),('1','200','1025','257714',4905242,'3038','468',106586.29,107593.02,0.00,0.00,1006.73,775182.10,0.00,0.00,0.00),('1','200','1025','257714',4905243,'3039','468',97689.87,97689.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257714',4905244,'3040','468',95606.18,95606.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257714',4905245,'3041','468',126894.55,127529.91,0.00,0.00,635.36,460636.00,0.00,0.00,0.00),('1','200','1025','257714',4905246,'3042','468',140875.99,141790.80,0.00,0.00,914.81,663237.25,0.00,0.00,0.00),('1','200','1025','257714',4905247,'3043','468',128074.33,129047.31,0.00,0.00,972.98,705410.50,0.00,0.00,0.00),('1','200','1025','257714',4905248,'3044','468',115016.11,115890.73,0.00,0.00,874.62,634099.50,0.00,0.00,0.00),('1','200','1025','257715',4905249,'3037','468',107681.70,107729.43,0.00,0.00,47.73,36752.10,0.00,0.00,0.00),('1','200','1025','257715',4905250,'3038','468',107593.02,107640.88,0.00,0.00,47.86,36852.20,0.00,0.00,0.00),('1','200','1025','257715',4905251,'3039','468',97689.87,98546.70,0.00,0.00,856.83,659759.10,0.00,0.00,0.00),('1','200','1025','257715',4905252,'3040','468',95606.18,96404.72,0.00,0.00,798.54,614875.80,0.00,0.00,0.00),('1','200','1025','257715',4905253,'3041','468',127529.91,127529.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257715',4905254,'3042','468',141790.80,141790.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257715',4905255,'3043','468',129047.31,129047.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257715',4905256,'3044','468',115890.73,115890.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257716',4905257,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257716',4905258,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257716',4905259,'3039','468',98546.70,98546.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257716',4905260,'3040','468',96404.72,96404.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257716',4905261,'3041','468',127529.91,127529.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257716',4905262,'3042','468',141790.80,141790.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257716',4905263,'3043','468',129047.31,129047.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257716',4905264,'3044','468',115890.73,115890.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257717',4905265,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257717',4905266,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257717',4905267,'3039','468',98546.70,99767.79,0.00,0.00,1221.09,940239.30,0.00,0.00,0.00),('1','200','1025','257717',4905268,'3040','468',96404.72,97624.77,0.00,0.00,1220.05,939438.50,0.00,0.00,0.00),('1','200','1025','257717',4905269,'3041','468',127529.91,128363.41,0.00,0.00,833.50,604287.50,0.00,0.00,0.00),('1','200','1025','257717',4905270,'3042','468',141790.80,142701.35,0.00,0.00,910.55,660148.75,0.00,0.00,0.00),('1','200','1025','257717',4905271,'3043','468',129047.31,130255.81,0.00,0.00,1208.50,876162.50,0.00,0.00,0.00),('1','200','1025','257717',4905272,'3044','468',115890.73,116744.55,0.00,0.00,853.82,619019.50,0.00,0.00,0.00),('1','200','1025','257718',4905273,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257718',4905274,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257718',4905275,'3039','468',99767.79,101159.00,0.00,0.00,1391.21,1071231.70,0.00,0.00,0.00),('1','200','1025','257718',4905276,'3040','468',97624.77,98715.02,0.00,0.00,1090.25,839492.50,0.00,0.00,0.00),('1','200','1025','257718',4905277,'3041','468',128363.41,128633.91,0.00,0.00,270.50,196112.50,0.00,0.00,0.00),('1','200','1025','257718',4905278,'3042','468',142701.35,143393.73,0.00,0.00,692.38,501975.50,0.00,0.00,0.00),('1','200','1025','257718',4905279,'3043','468',130255.81,131390.10,0.00,0.00,1134.29,822360.25,0.00,0.00,0.00),('1','200','1025','257718',4905280,'3044','468',116744.55,117344.15,0.00,0.00,599.60,434710.00,0.00,0.00,0.00),('1','200','1025','257719',4905281,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257719',4905282,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257719',4905283,'3039','468',101159.00,102208.18,0.00,0.00,1049.18,807868.60,0.00,0.00,0.00),('1','200','1025','257719',4905284,'3040','468',98715.02,99619.91,0.00,0.00,904.89,696765.30,0.00,0.00,0.00),('1','200','1025','257719',4905285,'3041','468',128633.91,129080.07,0.00,0.00,446.16,323466.00,0.00,0.00,0.00),('1','200','1025','257719',4905286,'3042','468',143393.73,144064.87,0.00,0.00,671.14,486576.50,0.00,0.00,0.00),('1','200','1025','257719',4905287,'3043','468',131390.10,132192.82,0.00,0.00,802.72,581972.00,0.00,0.00,0.00),('1','200','1025','257719',4905288,'3044','468',117344.15,118100.65,0.00,0.00,756.50,548462.50,0.00,0.00,0.00),('1','200','1025','257720',4905289,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257720',4905290,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257720',4905291,'3039','468',102208.18,103791.68,0.00,0.00,1583.50,1219295.00,0.00,0.00,0.00),('1','200','1025','257720',4905292,'3040','468',99619.91,101034.37,0.00,0.00,1414.46,1089134.20,0.00,0.00,0.00),('1','200','1025','257720',4905293,'3041','468',129080.07,129725.94,0.00,0.00,645.87,468255.75,0.00,0.00,0.00),('1','200','1025','257720',4905294,'3042','468',144064.87,144874.66,0.00,0.00,809.79,587097.75,0.00,0.00,0.00),('1','200','1025','257720',4905295,'3043','468',132192.82,133080.32,0.00,0.00,887.50,643437.50,0.00,0.00,0.00),('1','200','1025','257720',4905296,'3044','468',118100.65,119060.65,0.00,0.00,960.00,696000.00,0.00,0.00,0.00),('1','200','1025','257721',4905297,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257721',4905298,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257721',4905299,'3039','468',103791.68,105123.87,0.00,0.00,1332.19,1025786.30,0.00,0.00,0.00),('1','200','1025','257721',4905300,'3040','468',101034.37,102215.93,0.00,0.00,1181.56,909801.20,0.00,0.00,0.00),('1','200','1025','257721',4905301,'3041','468',129725.94,129934.03,0.00,0.00,208.09,150865.25,0.00,0.00,0.00),('1','200','1025','257721',4905302,'3042','468',144874.66,145291.66,0.00,0.00,417.00,302325.00,0.00,0.00,0.00),('1','200','1025','257721',4905303,'3043','468',133080.32,133419.82,0.00,0.00,339.50,246137.50,0.00,0.00,0.00),('1','200','1025','257721',4905304,'3044','468',119060.65,119386.65,0.00,0.00,326.00,236350.00,0.00,0.00,0.00),('1','200','1025','257722',4905305,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257722',4905306,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257722',4905307,'3039','468',105123.87,106264.35,0.00,0.00,1140.48,878169.60,0.00,0.00,0.00),('1','200','1025','257722',4905308,'3040','468',102215.93,103398.07,0.00,0.00,1182.14,910247.80,0.00,0.00,0.00),('1','200','1025','257722',4905309,'3041','468',129934.03,130129.76,0.00,0.00,195.73,141904.25,0.00,0.00,0.00),('1','200','1025','257722',4905310,'3042','468',145291.66,145703.86,0.00,0.00,412.20,298845.00,0.00,0.00,0.00),('1','200','1025','257722',4905311,'3043','468',133419.82,134078.20,0.00,0.00,658.38,477325.50,0.00,0.00,0.00),('1','200','1025','257722',4905312,'3044','468',119386.65,119773.22,0.00,0.00,386.57,280263.25,0.00,0.00,0.00),('1','200','1025','257723',4905313,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257723',4905314,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257723',4905315,'3039','468',106264.35,107447.00,0.00,0.00,1182.65,910640.50,0.00,0.00,0.00),('1','200','1025','257723',4905316,'3040','468',103398.07,104534.79,0.00,0.00,1136.72,875274.40,0.00,0.00,0.00),('1','200','1025','257723',4905317,'3041','468',130129.76,130533.51,0.00,0.00,403.75,292865.00,0.00,0.00,0.00),('1','200','1025','257723',4905318,'3042','468',145703.86,146317.86,0.00,0.00,614.00,445150.00,0.00,0.00,0.00),('1','200','1025','257723',4905319,'3043','468',134078.20,134991.21,0.00,0.00,913.01,661932.25,0.00,0.00,0.00),('1','200','1025','257723',4905320,'3044','468',119773.22,120606.22,0.00,0.00,833.00,603925.00,0.00,0.00,0.00),('1','200','1025','257724',4905321,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257724',4905322,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257724',4905323,'3039','468',107447.00,108716.05,0.00,0.00,1269.05,977168.50,0.00,0.00,0.00),('1','200','1025','257724',4905324,'3040','468',104534.79,105740.24,0.00,0.00,1205.45,928196.50,0.00,0.00,0.00),('1','200','1025','257724',4905325,'3041','468',130533.51,130883.48,0.00,0.00,349.97,253728.25,0.00,0.00,0.00),('1','200','1025','257724',4905326,'3042','468',146317.86,146656.71,0.00,0.00,338.85,245666.25,0.00,0.00,0.00),('1','200','1025','257724',4905327,'3043','468',134991.21,135585.36,0.00,0.00,594.15,430758.75,0.00,0.00,0.00),('1','200','1025','257724',4905328,'3044','468',120606.22,121327.66,0.00,0.00,721.44,523044.00,0.00,0.00,0.00),('1','200','1025','257725',4905329,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257725',4905330,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257725',4905331,'3039','468',108716.05,110059.89,0.00,0.00,1343.84,1034756.80,0.00,0.00,0.00),('1','200','1025','257725',4905332,'3040','468',105740.24,107180.89,0.00,0.00,1440.65,1109300.50,0.00,0.00,0.00),('1','200','1025','257725',4905333,'3041','468',130883.48,131429.49,0.00,0.00,546.01,395857.25,0.00,0.00,0.00),('1','200','1025','257725',4905334,'3042','468',146656.71,147193.73,0.00,0.00,537.02,389339.50,0.00,0.00,0.00),('1','200','1025','257725',4905335,'3043','468',135585.36,136357.36,0.00,0.00,772.00,559700.00,0.00,0.00,0.00),('1','200','1025','257725',4905336,'3044','468',121327.66,122166.16,0.00,0.00,838.50,607912.50,0.00,0.00,0.00),('1','200','1025','257726',4905337,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257726',4905338,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257726',4905339,'3039','468',110059.89,111121.81,0.00,0.00,1061.92,817678.40,0.00,0.00,0.00),('1','200','1025','257726',4905340,'3040','468',107180.89,108350.92,0.00,0.00,1170.03,900923.10,0.00,0.00,0.00),('1','200','1025','257726',4905341,'3041','468',131429.49,131971.43,0.00,0.00,541.94,392906.50,0.00,0.00,0.00),('1','200','1025','257726',4905342,'3042','468',147193.73,147573.58,0.00,0.00,379.85,275391.25,0.00,0.00,0.00),('1','200','1025','257726',4905343,'3043','468',136357.36,136977.79,0.00,0.00,620.43,449811.75,0.00,0.00,0.00),('1','200','1025','257726',4905344,'3044','468',122166.16,122770.66,0.00,0.00,604.50,438262.50,0.00,0.00,0.00),('1','200','1025','257727',4905345,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257727',4905346,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257727',4905347,'3039','468',111121.81,111121.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257727',4905348,'3040','468',108350.92,108350.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257727',4905349,'3041','468',131971.43,131971.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257727',4905350,'3042','468',147573.58,147573.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257727',4905351,'3043','468',136977.79,136977.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257727',4905352,'3044','468',122770.66,122770.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257728',4905353,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257728',4905354,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257728',4905355,'3039','468',111121.81,112467.73,0.00,0.00,1345.92,1036358.40,0.00,0.00,0.00),('1','200','1025','257728',4905356,'3040','468',108350.92,109936.42,0.00,0.00,1585.50,1220835.00,0.00,0.00,0.00),('1','200','1025','257728',4905357,'3041','468',131971.43,132516.50,0.00,0.00,545.07,395175.75,0.00,0.00,0.00),('1','200','1025','257728',4905358,'3042','468',147573.58,148280.88,0.00,0.00,707.30,512792.50,0.00,0.00,0.00),('1','200','1025','257728',4905359,'3043','468',136977.79,137820.79,0.00,0.00,843.00,611175.00,0.00,0.00,0.00),('1','200','1025','257728',4905360,'3044','468',122770.66,123768.66,0.00,0.00,998.00,723550.00,0.00,0.00,0.00),('1','200','1025','257729',4905361,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257729',4905362,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257729',4905363,'3039','468',112467.73,113970.73,0.00,0.00,1503.00,1157310.00,0.00,0.00,0.00),('1','200','1025','257729',4905364,'3040','468',109936.42,111164.09,0.00,0.00,1227.67,945305.90,0.00,0.00,0.00),('1','200','1025','257729',4905365,'3041','468',132516.50,132808.00,0.00,0.00,291.50,211337.50,0.00,0.00,0.00),('1','200','1025','257729',4905366,'3042','468',148280.88,148791.88,0.00,0.00,511.00,370475.00,0.00,0.00,0.00),('1','200','1025','257729',4905367,'3043','468',137820.79,138655.12,0.00,0.00,834.33,604889.25,0.00,0.00,0.00),('1','200','1025','257729',4905368,'3044','468',123768.66,124426.59,0.00,0.00,657.93,476999.25,0.00,0.00,0.00),('1','200','1025','257730',4905369,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257730',4905370,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257730',4905371,'3039','468',113970.73,115383.16,0.00,0.00,1412.43,1087571.10,0.00,0.00,0.00),('1','200','1025','257730',4905372,'3040','468',111164.09,112819.61,0.00,0.00,1655.52,1274750.40,0.00,0.00,0.00),('1','200','1025','257730',4905373,'3041','468',132808.00,133524.50,0.00,0.00,716.50,519462.50,0.00,0.00,0.00),('1','200','1025','257730',4905374,'3042','468',148791.88,149755.59,0.00,0.00,963.71,698689.75,0.00,0.00,0.00),('1','200','1025','257730',4905375,'3043','468',138655.12,139561.12,0.00,0.00,906.00,656850.00,0.00,0.00,0.00),('1','200','1025','257730',4905376,'3044','468',124426.59,125486.75,0.00,0.00,1060.16,768616.00,0.00,0.00,0.00),('1','200','1025','257731',4905377,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257731',4905378,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257731',4905379,'3039','468',115383.16,116981.40,0.00,0.00,1598.24,1230644.80,0.00,0.00,0.00),('1','200','1025','257731',4905380,'3040','468',112819.61,114465.05,0.00,0.00,1645.44,1266988.80,0.00,0.00,0.00),('1','200','1025','257731',4905381,'3041','468',133524.50,134162.81,0.00,0.00,638.31,462774.75,0.00,0.00,0.00),('1','200','1025','257731',4905382,'3042','468',149755.59,150637.09,0.00,0.00,881.50,639087.50,0.00,0.00,0.00),('1','200','1025','257731',4905383,'3043','468',139561.12,140654.27,0.00,0.00,1093.15,792533.75,0.00,0.00,0.00),('1','200','1025','257731',4905384,'3044','468',125486.75,126566.75,0.00,0.00,1080.00,783000.00,0.00,0.00,0.00),('1','200','1025','257732',4905385,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257732',4905386,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257732',4905387,'3039','468',116981.40,116981.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257732',4905388,'3040','468',114465.05,114465.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257732',4905389,'3041','468',134162.81,134162.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257732',4905390,'3042','468',150637.09,150637.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257732',4905391,'3043','468',140654.27,140654.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257732',4905392,'3044','468',126566.75,126566.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257733',4905393,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257733',4905394,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257733',4905395,'3039','468',116981.40,118795.50,0.00,0.00,1814.10,1396857.00,0.00,0.00,0.00),('1','200','1025','257733',4905396,'3040','468',114465.05,116279.26,0.00,0.00,1814.21,1396941.70,0.00,0.00,0.00),('1','200','1025','257733',4905397,'3041','468',134162.81,134693.74,0.00,0.00,530.93,384924.25,0.00,0.00,0.00),('1','200','1025','257733',4905398,'3042','468',150637.09,151289.09,0.00,0.00,652.00,472700.00,0.00,0.00,0.00),('1','200','1025','257733',4905399,'3043','468',140654.27,141561.27,0.00,0.00,907.00,657575.00,0.00,0.00,0.00),('1','200','1025','257733',4905400,'3044','468',126566.75,127369.75,0.00,0.00,803.00,582175.00,0.00,0.00,0.00),('1','200','1025','257734',4905401,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257734',4905402,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257734',4905403,'3039','468',118795.50,120226.11,0.00,0.00,1430.61,1101569.70,0.00,0.00,0.00),('1','200','1025','257734',4905404,'3040','468',116279.26,117895.23,0.00,0.00,1615.97,1244296.90,0.00,0.00,0.00),('1','200','1025','257734',4905405,'3041','468',134693.74,135203.74,0.00,0.00,510.00,369750.00,0.00,0.00,0.00),('1','200','1025','257734',4905406,'3042','468',151289.09,152006.63,0.00,0.00,717.54,520216.50,0.00,0.00,0.00),('1','200','1025','257734',4905407,'3043','468',141561.27,142455.09,0.00,0.00,893.82,648019.50,0.00,0.00,0.00),('1','200','1025','257734',4905408,'3044','468',127369.75,128322.25,0.00,0.00,952.50,690562.50,0.00,0.00,0.00),('1','200','1025','257735',4905409,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257735',4905410,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257735',4905411,'3039','468',120226.11,121561.97,0.00,0.00,1335.86,1028612.20,0.00,0.00,0.00),('1','200','1025','257735',4905412,'3040','468',117895.23,119488.01,0.00,0.00,1592.78,1226440.60,0.00,0.00,0.00),('1','200','1025','257735',4905413,'3041','468',135203.74,136232.50,0.00,0.00,1028.76,745851.00,0.00,0.00,0.00),('1','200','1025','257735',4905414,'3042','468',152006.63,153424.06,0.00,0.00,1417.43,1027636.75,0.00,0.00,0.00),('1','200','1025','257735',4905415,'3043','468',142455.09,143977.02,0.00,0.00,1521.93,1103399.25,0.00,0.00,0.00),('1','200','1025','257735',4905416,'3044','468',128322.25,129722.63,0.00,0.00,1400.38,1015275.50,0.00,0.00,0.00),('1','200','1025','257736',4905417,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257736',4905418,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257736',4905419,'3039','468',121561.97,122819.09,0.00,0.00,1257.12,967982.40,0.00,0.00,0.00),('1','200','1025','257736',4905420,'3040','468',119488.01,120914.22,0.00,0.00,1426.21,1098181.70,0.00,0.00,0.00),('1','200','1025','257736',4905421,'3041','468',136232.50,136232.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257736',4905422,'3042','468',153424.06,153424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257736',4905423,'3043','468',143977.02,143977.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257736',4905424,'3044','468',129722.63,129722.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257737',4905425,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257737',4905426,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257737',4905427,'3039','468',122819.09,122819.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257737',4905428,'3040','468',120914.22,120914.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257737',4905429,'3041','468',136232.50,136232.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257737',4905430,'3042','468',153424.06,153424.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257737',4905431,'3043','468',143977.02,143977.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257737',4905432,'3044','468',129722.63,129722.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257738',4905433,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257738',4905434,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257738',4905435,'3039','468',122819.09,123895.00,0.00,0.00,1075.91,849968.90,0.00,0.00,0.00),('1','200','1025','257738',4905436,'3040','468',120914.22,121992.48,0.00,0.00,1078.26,851825.40,0.00,0.00,0.00),('1','200','1025','257738',4905437,'3041','468',136232.50,138367.40,0.00,0.00,2134.90,1579826.00,0.00,0.00,0.00),('1','200','1025','257738',4905438,'3042','468',153424.06,155732.28,0.00,0.00,2308.22,1708082.80,0.00,0.00,0.00),('1','200','1025','257738',4905439,'3043','468',143977.02,146337.55,0.00,0.00,2360.53,1746792.20,0.00,0.00,0.00),('1','200','1025','257738',4905440,'3044','468',129722.63,132131.00,0.00,0.00,2408.37,1782193.80,0.00,0.00,0.00),('1','200','1025','257739',4905441,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257739',4905442,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257739',4905443,'3039','468',123895.00,124946.67,0.00,0.00,1051.67,830819.30,0.00,0.00,0.00),('1','200','1025','257739',4905444,'3040','468',121992.48,123152.51,0.00,0.00,1160.03,916423.70,0.00,0.00,0.00),('1','200','1025','257739',4905445,'3041','468',138367.40,138770.65,0.00,0.00,403.25,298721.50,0.00,0.00,0.00),('1','200','1025','257739',4905446,'3042','468',155732.28,156196.96,0.00,0.00,464.68,343863.20,0.00,0.00,0.00),('1','200','1025','257739',4905447,'3043','468',146337.55,147014.93,0.00,0.00,677.38,501261.20,0.00,0.00,0.00),('1','200','1025','257739',4905448,'3044','468',132131.00,132885.32,0.00,0.00,754.32,558196.80,0.00,0.00,0.00),('1','200','1025','257740',4905449,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257740',4905450,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257740',4905451,'3039','468',124946.67,126262.14,0.00,0.00,1315.47,1039221.30,0.00,0.00,0.00),('1','200','1025','257740',4905452,'3040','468',123152.51,124435.00,0.00,0.00,1282.49,1013167.10,0.00,0.00,0.00),('1','200','1025','257740',4905453,'3041','468',138770.65,139334.86,0.00,0.00,564.21,417815.40,0.00,0.00,0.00),('1','200','1025','257740',4905454,'3042','468',156196.96,156611.18,0.00,0.00,414.22,306522.80,0.00,0.00,0.00),('1','200','1025','257740',4905455,'3043','468',147014.93,147841.48,0.00,0.00,826.55,611647.00,0.00,0.00,0.00),('1','200','1025','257740',4905456,'3044','468',132885.32,133609.32,0.00,0.00,724.00,535760.00,0.00,0.00,0.00),('1','200','1025','257741',4905457,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257741',4905458,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257741',4905459,'3039','468',126262.14,127223.61,0.00,0.00,961.47,759561.30,0.00,0.00,0.00),('1','200','1025','257741',4905460,'3040','468',124435.00,125616.05,0.00,0.00,1181.05,933029.50,0.00,0.00,0.00),('1','200','1025','257741',4905461,'3041','468',139334.86,140014.36,0.00,0.00,679.50,502830.00,0.00,0.00,0.00),('1','200','1025','257741',4905462,'3042','468',156611.18,157249.46,0.00,0.00,638.28,472327.20,0.00,0.00,0.00),('1','200','1025','257741',4905463,'3043','468',147841.48,149201.95,0.00,0.00,1360.47,1006747.80,0.00,0.00,0.00),('1','200','1025','257741',4905464,'3044','468',133609.32,134653.57,0.00,0.00,1044.25,772745.00,0.00,0.00,0.00),('1','200','1025','257742',4905465,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257742',4905466,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257742',4905467,'3039','468',127223.61,128368.30,0.00,0.00,1144.69,904305.10,0.00,0.00,0.00),('1','200','1025','257742',4905468,'3040','468',125616.05,126953.28,0.00,0.00,1337.23,1056411.70,0.00,0.00,0.00),('1','200','1025','257742',4905469,'3041','468',140014.36,140751.36,0.00,0.00,737.00,545380.00,0.00,0.00,0.00),('1','200','1025','257742',4905470,'3042','468',157249.46,158030.30,0.00,0.00,780.84,577821.60,0.00,0.00,0.00),('1','200','1025','257742',4905471,'3043','468',149201.95,149977.78,0.00,0.00,775.83,574114.20,0.00,0.00,0.00),('1','200','1025','257742',4905472,'3044','468',134653.57,135448.57,0.00,0.00,795.00,588300.00,0.00,0.00,0.00),('1','200','1025','257743',4905473,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257743',4905474,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257743',4905475,'3039','468',128368.30,129439.78,0.00,0.00,1071.48,846469.20,0.00,0.00,0.00),('1','200','1025','257743',4905476,'3040','468',126953.28,128436.96,0.00,0.00,1483.68,1172107.20,0.00,0.00,0.00),('1','200','1025','257743',4905477,'3041','468',140751.36,141178.36,0.00,0.00,427.00,315980.00,0.00,0.00,0.00),('1','200','1025','257743',4905478,'3042','468',158030.30,158433.30,0.00,0.00,403.00,298220.00,0.00,0.00,0.00),('1','200','1025','257743',4905479,'3043','468',149977.78,150374.78,0.00,0.00,397.00,293780.00,0.00,0.00,0.00),('1','200','1025','257743',4905480,'3044','468',135448.57,135814.58,0.00,0.00,366.01,270847.40,0.00,0.00,0.00),('1','200','1025','257744',4905481,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257744',4905482,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257744',4905483,'3039','468',129439.78,130418.35,0.00,0.00,978.57,773070.30,0.00,0.00,0.00),('1','200','1025','257744',4905484,'3040','468',128436.96,129550.41,0.00,0.00,1113.45,879625.50,0.00,0.00,0.00),('1','200','1025','257744',4905485,'3041','468',141178.36,141645.47,0.00,0.00,467.11,345661.40,0.00,0.00,0.00),('1','200','1025','257744',4905486,'3042','468',158433.30,159195.76,0.00,0.00,762.46,564220.40,0.00,0.00,0.00),('1','200','1025','257744',4905487,'3043','468',150374.78,151013.28,0.00,0.00,638.50,472490.00,0.00,0.00,0.00),('1','200','1025','257744',4905488,'3044','468',135814.58,136393.08,0.00,0.00,578.50,428090.00,0.00,0.00,0.00),('1','200','1025','257745',4905489,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257745',4905490,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257745',4905491,'3039','468',130418.35,131813.49,0.00,0.00,1395.14,1102160.60,0.00,0.00,0.00),('1','200','1025','257745',4905492,'3040','468',129550.41,130925.92,0.00,0.00,1375.51,1086652.90,0.00,0.00,0.00),('1','200','1025','257745',4905493,'3041','468',141645.47,142432.97,0.00,0.00,787.50,582750.00,0.00,0.00,0.00),('1','200','1025','257745',4905494,'3042','468',159195.76,159986.76,0.00,0.00,791.00,585340.00,0.00,0.00,0.00),('1','200','1025','257745',4905495,'3043','468',151013.28,152285.36,0.00,0.00,1272.08,941339.20,0.00,0.00,0.00),('1','200','1025','257745',4905496,'3044','468',136393.08,137642.58,0.00,0.00,1249.50,924630.00,0.00,0.00,0.00),('1','200','1025','257746',4905497,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257746',4905498,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257746',4905499,'3039','468',131813.49,132816.89,0.00,0.00,1003.40,792686.00,0.00,0.00,0.00),('1','200','1025','257746',4905500,'3040','468',130925.92,132155.31,0.00,0.00,1229.39,971218.10,0.00,0.00,0.00),('1','200','1025','257746',4905501,'3041','468',142432.97,142733.97,0.00,0.00,301.00,222740.00,0.00,0.00,0.00),('1','200','1025','257746',4905502,'3042','468',159986.76,160445.57,0.00,0.00,458.81,339519.40,0.00,0.00,0.00),('1','200','1025','257746',4905503,'3043','468',152285.36,153034.83,0.00,0.00,749.47,554607.80,0.00,0.00,0.00),('1','200','1025','257746',4905504,'3044','468',137642.58,138503.75,0.00,0.00,861.17,637265.80,0.00,0.00,0.00),('1','200','1025','257747',4905505,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257747',4905506,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257747',4905507,'3039','468',132816.89,133814.92,0.00,0.00,998.03,788443.70,0.00,0.00,0.00),('1','200','1025','257747',4905508,'3040','468',132155.31,133234.62,0.00,0.00,1079.31,852654.90,0.00,0.00,0.00),('1','200','1025','257747',4905509,'3041','468',142733.97,143115.47,0.00,0.00,381.50,282310.00,0.00,0.00,0.00),('1','200','1025','257747',4905510,'3042','468',160445.57,160998.78,0.00,0.00,553.21,409375.40,0.00,0.00,0.00),('1','200','1025','257747',4905511,'3043','468',153034.83,153540.60,0.00,0.00,505.77,374269.80,0.00,0.00,0.00),('1','200','1025','257747',4905512,'3044','468',138503.75,139023.25,0.00,0.00,519.50,384430.00,0.00,0.00,0.00),('1','200','1025','257748',4905513,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257748',4905514,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257748',4905515,'3039','468',133814.92,134808.64,0.00,0.00,993.72,785038.80,0.00,0.00,0.00),('1','200','1025','257748',4905516,'3040','468',133234.62,134389.91,0.00,0.00,1155.29,912679.10,0.00,0.00,0.00),('1','200','1025','257748',4905517,'3041','468',143115.47,143538.59,0.00,0.00,423.12,313108.80,0.00,0.00,0.00),('1','200','1025','257748',4905518,'3042','468',160998.78,161480.68,0.00,0.00,481.90,356606.00,0.00,0.00,0.00),('1','200','1025','257748',4905519,'3043','468',153540.60,154222.61,0.00,0.00,682.01,504687.40,0.00,0.00,0.00),('1','200','1025','257748',4905520,'3044','468',139023.25,139643.47,0.00,0.00,620.22,458962.80,0.00,0.00,0.00),('1','200','1025','257749',4905521,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257749',4905522,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257749',4905523,'3039','468',134808.64,136108.71,0.00,0.00,1300.07,1027055.30,0.00,0.00,0.00),('1','200','1025','257749',4905524,'3040','468',134389.91,135727.58,0.00,0.00,1337.67,1056759.30,0.00,0.00,0.00),('1','200','1025','257749',4905525,'3041','468',143538.59,144250.02,0.00,0.00,711.43,526458.20,0.00,0.00,0.00),('1','200','1025','257749',4905526,'3042','468',161480.68,162129.02,0.00,0.00,648.34,479771.60,0.00,0.00,0.00),('1','200','1025','257749',4905527,'3043','468',154222.61,155039.11,0.00,0.00,816.50,604210.00,0.00,0.00,0.00),('1','200','1025','257749',4905528,'3044','468',139643.47,140618.48,0.00,0.00,975.01,721507.40,0.00,0.00,0.00),('1','200','1025','257750',4905529,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257750',4905530,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257750',4905531,'3039','468',136108.71,137225.55,0.00,0.00,1116.84,882303.60,0.00,0.00,0.00),('1','200','1025','257750',4905532,'3040','468',135727.58,136768.98,0.00,0.00,1041.40,822706.00,0.00,0.00,0.00),('1','200','1025','257750',4905533,'3041','468',144250.02,144594.02,0.00,0.00,344.00,254560.00,0.00,0.00,0.00),('1','200','1025','257750',4905534,'3042','468',162129.02,162397.02,0.00,0.00,268.00,198320.00,0.00,0.00,0.00),('1','200','1025','257750',4905535,'3043','468',155039.11,155456.11,0.00,0.00,417.00,308580.00,0.00,0.00,0.00),('1','200','1025','257750',4905536,'3044','468',140618.48,141126.48,0.00,0.00,508.00,375920.00,0.00,0.00,0.00),('1','200','1025','257751',4905537,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257751',4905538,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257751',4905539,'3039','468',137225.55,138170.99,0.00,0.00,945.44,746897.60,0.00,0.00,0.00),('1','200','1025','257751',4905540,'3040','468',136768.98,137693.44,0.00,0.00,924.46,730323.40,0.00,0.00,0.00),('1','200','1025','257751',4905541,'3041','468',144594.02,144951.58,0.00,0.00,357.56,264594.40,0.00,0.00,0.00),('1','200','1025','257751',4905542,'3042','468',162397.02,162780.02,0.00,0.00,383.00,283420.00,0.00,0.00,0.00),('1','200','1025','257751',4905543,'3043','468',155456.11,156204.11,0.00,0.00,748.00,553520.00,0.00,0.00,0.00),('1','200','1025','257751',4905544,'3044','468',141126.48,141744.18,0.00,0.00,617.70,457098.00,0.00,0.00,0.00),('1','200','1025','257752',4905545,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257752',4905546,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257752',4905547,'3039','468',138170.99,138170.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257752',4905548,'3040','468',137693.44,137693.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257752',4905549,'3041','468',144951.58,144951.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257752',4905550,'3042','468',162780.02,162780.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257752',4905551,'3043','468',156204.11,156204.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257752',4905552,'3044','468',141744.18,141744.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257753',4905553,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257753',4905554,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257753',4905555,'3039','468',138170.99,139094.00,0.00,0.00,923.01,729177.90,0.00,0.00,0.00),('1','200','1025','257753',4905556,'3040','468',137693.44,138789.40,0.00,0.00,1095.96,865808.40,0.00,0.00,0.00),('1','200','1025','257753',4905557,'3041','468',144951.58,145432.46,0.00,0.00,480.88,356151.20,0.00,0.00,0.00),('1','200','1025','257753',4905558,'3042','468',162780.02,163190.25,0.00,0.00,410.23,303570.20,0.00,0.00,0.00),('1','200','1025','257753',4905559,'3043','468',156204.11,157224.11,0.00,0.00,1020.00,754800.00,0.00,0.00,0.00),('1','200','1025','257753',4905560,'3044','468',141744.18,142570.22,0.00,0.00,826.04,611269.60,0.00,0.00,0.00),('1','200','1025','257754',4905561,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257754',4905562,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257754',4905563,'3039','468',139094.00,140190.91,0.00,0.00,1096.91,866558.90,0.00,0.00,0.00),('1','200','1025','257754',4905564,'3040','468',138789.40,139874.65,0.00,0.00,1085.25,857347.50,0.00,0.00,0.00),('1','200','1025','257754',4905565,'3041','468',145432.46,145790.46,0.00,0.00,358.00,264920.00,0.00,0.00,0.00),('1','200','1025','257754',4905566,'3042','468',163190.25,163514.88,0.00,0.00,324.63,240226.20,0.00,0.00,0.00),('1','200','1025','257754',4905567,'3043','468',157224.11,157769.61,0.00,0.00,545.50,403670.00,0.00,0.00,0.00),('1','200','1025','257754',4905568,'3044','468',142570.22,143245.10,0.00,0.00,674.88,499411.20,0.00,0.00,0.00),('1','200','1025','257755',4905569,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257755',4905570,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257755',4905571,'3039','468',140190.91,141299.21,0.00,0.00,1108.30,875557.00,0.00,0.00,0.00),('1','200','1025','257755',4905572,'3040','468',139874.65,140944.35,0.00,0.00,1069.70,845063.00,0.00,0.00,0.00),('1','200','1025','257755',4905573,'3041','468',145790.46,146196.96,0.00,0.00,406.50,300810.00,0.00,0.00,0.00),('1','200','1025','257755',4905574,'3042','468',163514.88,164066.07,0.00,0.00,551.19,407880.60,0.00,0.00,0.00),('1','200','1025','257755',4905575,'3043','468',157769.61,158542.76,0.00,0.00,773.15,572131.00,0.00,0.00,0.00),('1','200','1025','257755',4905576,'3044','468',143245.10,143890.10,0.00,0.00,645.00,477300.00,0.00,0.00,0.00),('1','200','1025','257756',4905577,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257756',4905578,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257756',4905579,'3039','468',141299.21,142515.71,0.00,0.00,1216.50,961035.00,0.00,0.00,0.00),('1','200','1025','257756',4905580,'3040','468',140944.35,142126.95,0.00,0.00,1182.60,934254.00,0.00,0.00,0.00),('1','200','1025','257756',4905581,'3041','468',146196.96,146655.36,0.00,0.00,458.40,339216.00,0.00,0.00,0.00),('1','200','1025','257756',4905582,'3042','468',164066.07,164561.57,0.00,0.00,495.50,366670.00,0.00,0.00,0.00),('1','200','1025','257756',4905583,'3043','468',158542.76,159239.58,0.00,0.00,696.82,515646.80,0.00,0.00,0.00),('1','200','1025','257756',4905584,'3044','468',143890.10,144422.10,0.00,0.00,532.00,393680.00,0.00,0.00,0.00),('1','200','1025','257757',4905585,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257757',4905586,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257757',4905587,'3039','468',142515.71,143635.90,0.00,0.00,1120.19,884950.10,0.00,0.00,0.00),('1','200','1025','257757',4905588,'3040','468',142126.95,143513.15,0.00,0.00,1386.20,1095098.00,0.00,0.00,0.00),('1','200','1025','257757',4905589,'3041','468',146655.36,147271.87,0.00,0.00,616.51,456217.40,0.00,0.00,0.00),('1','200','1025','257757',4905590,'3042','468',164561.57,165168.57,0.00,0.00,607.00,449180.00,0.00,0.00,0.00),('1','200','1025','257757',4905591,'3043','468',159239.58,159702.30,0.00,0.00,462.72,342412.80,0.00,0.00,0.00),('1','200','1025','257757',4905592,'3044','468',144422.10,145023.10,0.00,0.00,601.00,444740.00,0.00,0.00,0.00),('1','200','1025','257758',4905593,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257758',4905594,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257758',4905595,'3039','468',143635.90,144615.10,0.00,0.00,979.20,773568.00,0.00,0.00,0.00),('1','200','1025','257758',4905596,'3040','468',143513.15,144658.91,0.00,0.00,1145.76,905150.40,0.00,0.00,0.00),('1','200','1025','257758',4905597,'3041','468',147271.87,147570.83,0.00,0.00,298.96,221230.40,0.00,0.00,0.00),('1','200','1025','257758',4905598,'3042','468',165168.57,165593.77,0.00,0.00,425.20,314648.00,0.00,0.00,0.00),('1','200','1025','257758',4905599,'3043','468',159702.30,160651.08,0.00,0.00,948.78,702097.20,0.00,0.00,0.00),('1','200','1025','257758',4905600,'3044','468',145023.10,145912.15,0.00,0.00,889.05,657897.00,0.00,0.00,0.00),('1','200','1025','257759',4905601,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257759',4905602,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257759',4905603,'3039','468',144615.10,145556.57,0.00,0.00,941.47,743761.30,0.00,0.00,0.00),('1','200','1025','257759',4905604,'3040','468',144658.91,145651.76,0.00,0.00,992.85,784351.50,0.00,0.00,0.00),('1','200','1025','257759',4905605,'3041','468',147570.83,147865.74,0.00,0.00,294.91,218233.40,0.00,0.00,0.00),('1','200','1025','257759',4905606,'3042','468',165593.77,165876.85,0.00,0.00,283.08,209479.20,0.00,0.00,0.00),('1','200','1025','257759',4905607,'3043','468',160651.08,161190.23,0.00,0.00,539.15,398971.00,0.00,0.00,0.00),('1','200','1025','257759',4905608,'3044','468',145912.15,146520.65,0.00,0.00,608.50,450290.00,0.00,0.00,0.00),('1','200','1025','257760',4905609,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257760',4905610,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257760',4905611,'3039','468',145556.57,146760.35,0.00,0.00,1203.78,950986.20,0.00,0.00,0.00),('1','200','1025','257760',4905612,'3040','468',145651.76,147030.62,0.00,0.00,1378.86,1089299.40,0.00,0.00,0.00),('1','200','1025','257760',4905613,'3041','468',147865.74,148384.74,0.00,0.00,519.00,384060.00,0.00,0.00,0.00),('1','200','1025','257760',4905614,'3042','468',165876.85,166278.53,0.00,0.00,401.68,297243.20,0.00,0.00,0.00),('1','200','1025','257760',4905615,'3043','468',161190.23,161963.94,0.00,0.00,773.71,572545.40,0.00,0.00,0.00),('1','200','1025','257760',4905616,'3044','468',146520.65,147223.50,0.00,0.00,702.85,520109.00,0.00,0.00,0.00),('1','200','1025','257761',4905617,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257761',4905618,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257761',4905619,'3039','468',146760.35,147852.04,0.00,0.00,1091.69,862435.10,0.00,0.00,0.00),('1','200','1025','257761',4905620,'3040','468',147030.62,148387.83,0.00,0.00,1357.21,1072195.90,0.00,0.00,0.00),('1','200','1025','257761',4905621,'3041','468',148384.74,149041.24,0.00,0.00,656.50,485810.00,0.00,0.00,0.00),('1','200','1025','257761',4905622,'3042','468',166278.53,167003.40,0.00,0.00,724.87,536403.80,0.00,0.00,0.00),('1','200','1025','257761',4905623,'3043','468',161963.94,162562.16,0.00,0.00,598.22,442682.80,0.00,0.00,0.00),('1','200','1025','257761',4905624,'3044','468',147223.50,147697.34,0.00,0.00,473.84,350641.60,0.00,0.00,0.00),('1','200','1025','257762',4905625,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257762',4905626,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257762',4905627,'3039','468',147852.04,149262.49,0.00,0.00,1410.45,1114255.50,0.00,0.00,0.00),('1','200','1025','257762',4905628,'3040','468',148387.83,150031.30,0.00,0.00,1643.47,1298341.30,0.00,0.00,0.00),('1','200','1025','257762',4905629,'3041','468',149041.24,149477.04,0.00,0.00,435.80,322492.00,0.00,0.00,0.00),('1','200','1025','257762',4905630,'3042','468',167003.40,167543.72,0.00,0.00,540.32,399836.80,0.00,0.00,0.00),('1','200','1025','257762',4905631,'3043','468',162562.16,163299.38,0.00,0.00,737.22,545542.80,0.00,0.00,0.00),('1','200','1025','257762',4905632,'3044','468',147697.34,148190.27,0.00,0.00,492.93,364768.20,0.00,0.00,0.00),('1','200','1025','257763',4905633,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257763',4905634,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257763',4905635,'3039','468',149262.49,149917.24,0.00,0.00,654.75,517252.50,0.00,0.00,0.00),('1','200','1025','257763',4905636,'3040','468',150031.30,150805.30,0.00,0.00,774.00,611460.00,0.00,0.00,0.00),('1','200','1025','257763',4905637,'3041','468',149477.04,149667.96,0.00,0.00,190.92,141280.80,0.00,0.00,0.00),('1','200','1025','257763',4905638,'3042','468',167543.72,167715.84,0.00,0.00,172.12,127368.80,0.00,0.00,0.00),('1','200','1025','257763',4905639,'3043','468',163299.38,163909.76,0.00,0.00,610.38,451681.20,0.00,0.00,0.00),('1','200','1025','257763',4905640,'3044','468',148190.27,148813.29,0.00,0.00,623.02,461034.80,0.00,0.00,0.00),('1','200','1025','257764',4905641,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257764',4905642,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257764',4905643,'3039','468',149917.24,149917.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257764',4905644,'3040','468',150805.30,150805.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257764',4905645,'3041','468',149667.96,149667.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257764',4905646,'3042','468',167715.84,167715.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257764',4905647,'3043','468',163909.76,163909.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257764',4905648,'3044','468',148813.29,148813.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257765',4905649,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257765',4905650,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257765',4905651,'3039','468',149917.24,150503.74,0.00,0.00,586.50,457470.00,0.00,0.00,0.00),('1','200','1025','257765',4905652,'3040','468',150805.30,151442.06,0.00,0.00,636.76,496672.80,0.00,0.00,0.00),('1','200','1025','257765',4905653,'3041','468',149667.96,149927.96,0.00,0.00,260.00,189800.00,0.00,0.00,0.00),('1','200','1025','257765',4905654,'3042','468',167715.84,167981.84,0.00,0.00,266.00,194180.00,0.00,0.00,0.00),('1','200','1025','257765',4905655,'3043','468',163909.76,164155.76,0.00,0.00,246.00,179580.00,0.00,0.00,0.00),('1','200','1025','257765',4905656,'3044','468',148813.29,149040.28,0.00,0.00,226.99,165702.70,0.00,0.00,0.00),('1','200','1025','257766',4905657,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257766',4905658,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257766',4905659,'3039','468',150503.74,152112.67,0.00,0.00,1608.93,1254965.40,0.00,0.00,0.00),('1','200','1025','257766',4905660,'3040','468',151442.06,153025.87,0.00,0.00,1583.81,1235371.80,0.00,0.00,0.00),('1','200','1025','257766',4905661,'3041','468',149927.96,150413.46,0.00,0.00,485.50,354415.00,0.00,0.00,0.00),('1','200','1025','257766',4905662,'3042','468',167981.84,168624.34,0.00,0.00,642.50,469025.00,0.00,0.00,0.00),('1','200','1025','257766',4905663,'3043','468',164155.76,165167.27,0.00,0.00,1011.51,738402.30,0.00,0.00,0.00),('1','200','1025','257766',4905664,'3044','468',149040.28,149882.44,0.00,0.00,842.16,614776.80,0.00,0.00,0.00),('1','200','1025','257767',4905665,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257767',4905666,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257767',4905667,'3039','468',152112.67,153435.30,0.00,0.00,1322.63,1031651.40,0.00,0.00,0.00),('1','200','1025','257767',4905668,'3040','468',153025.87,154391.97,0.00,0.00,1366.10,1065558.00,0.00,0.00,0.00),('1','200','1025','257767',4905669,'3041','468',150413.46,151098.46,0.00,0.00,685.00,500050.00,0.00,0.00,0.00),('1','200','1025','257767',4905670,'3042','468',168624.34,169201.84,0.00,0.00,577.50,421575.00,0.00,0.00,0.00),('1','200','1025','257767',4905671,'3043','468',165167.27,165691.77,0.00,0.00,524.50,382885.00,0.00,0.00,0.00),('1','200','1025','257767',4905672,'3044','468',149882.44,150423.94,0.00,0.00,541.50,395295.00,0.00,0.00,0.00),('1','200','1025','257768',4905673,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257768',4905674,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257768',4905675,'3039','468',153435.30,154539.80,0.00,0.00,1104.50,861510.00,0.00,0.00,0.00),('1','200','1025','257768',4905676,'3040','468',154391.97,155634.62,0.00,0.00,1242.65,969267.00,0.00,0.00,0.00),('1','200','1025','257768',4905677,'3041','468',151098.46,151693.76,0.00,0.00,595.30,434569.00,0.00,0.00,0.00),('1','200','1025','257768',4905678,'3042','468',169201.84,169740.20,0.00,0.00,538.36,393002.80,0.00,0.00,0.00),('1','200','1025','257768',4905679,'3043','468',165691.77,166434.82,0.00,0.00,743.05,542426.50,0.00,0.00,0.00),('1','200','1025','257768',4905680,'3044','468',150423.94,151060.94,0.00,0.00,637.00,465010.00,0.00,0.00,0.00),('1','200','1025','257769',4905681,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257769',4905682,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257769',4905683,'3039','468',154539.80,155053.54,0.00,0.00,513.74,400717.20,0.00,0.00,0.00),('1','200','1025','257769',4905684,'3040','468',155634.62,156108.27,0.00,0.00,473.65,369447.00,0.00,0.00,0.00),('1','200','1025','257769',4905685,'3041','468',151693.76,152202.44,0.00,0.00,508.68,371336.40,0.00,0.00,0.00),('1','200','1025','257769',4905686,'3042','468',169740.20,170397.25,0.00,0.00,657.05,479646.50,0.00,0.00,0.00),('1','200','1025','257769',4905687,'3043','468',166434.82,167416.52,0.00,0.00,981.70,716641.00,0.00,0.00,0.00),('1','200','1025','257769',4905688,'3044','468',151060.94,152105.94,0.00,0.00,1045.00,762850.00,0.00,0.00,0.00),('1','200','1025','257770',4905689,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257770',4905690,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257770',4905691,'3039','468',155053.54,156025.55,0.00,0.00,972.01,758167.80,0.00,0.00,0.00),('1','200','1025','257770',4905692,'3040','468',156108.27,157249.90,0.00,0.00,1141.63,890471.40,0.00,0.00,0.00),('1','200','1025','257770',4905693,'3041','468',152202.44,152593.80,0.00,0.00,391.36,285692.80,0.00,0.00,0.00),('1','200','1025','257770',4905694,'3042','468',170397.25,171033.50,0.00,0.00,636.25,464462.50,0.00,0.00,0.00),('1','200','1025','257770',4905695,'3043','468',167416.52,168356.02,0.00,0.00,939.50,685835.00,0.00,0.00,0.00),('1','200','1025','257770',4905696,'3044','468',152105.94,152882.70,0.00,0.00,776.76,567034.80,0.00,0.00,0.00),('1','200','1025','257771',4905697,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257771',4905698,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257771',4905699,'3039','468',156025.55,157345.78,0.00,0.00,1320.23,1029779.40,0.00,0.00,0.00),('1','200','1025','257771',4905700,'3040','468',157249.90,158633.68,0.00,0.00,1383.78,1079348.40,0.00,0.00,0.00),('1','200','1025','257771',4905701,'3041','468',152593.80,153219.64,0.00,0.00,625.84,456863.20,0.00,0.00,0.00),('1','200','1025','257771',4905702,'3042','468',171033.50,171665.71,0.00,0.00,632.21,461513.30,0.00,0.00,0.00),('1','200','1025','257771',4905703,'3043','468',168356.02,169301.72,0.00,0.00,945.70,690361.00,0.00,0.00,0.00),('1','200','1025','257771',4905704,'3044','468',152882.70,153700.70,0.00,0.00,818.00,597140.00,0.00,0.00,0.00),('1','200','1025','257772',4905705,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257772',4905706,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257772',4905707,'3039','468',157345.78,158395.64,0.00,0.00,1049.86,818890.80,0.00,0.00,0.00),('1','200','1025','257772',4905708,'3040','468',158633.68,159738.19,0.00,0.00,1104.51,861517.80,0.00,0.00,0.00),('1','200','1025','257772',4905709,'3041','468',153219.64,153728.71,0.00,0.00,509.07,371621.10,0.00,0.00,0.00),('1','200','1025','257772',4905710,'3042','468',171665.71,172280.47,0.00,0.00,614.76,448774.80,0.00,0.00,0.00),('1','200','1025','257772',4905711,'3043','468',169301.72,170305.33,0.00,0.00,1003.61,732635.30,0.00,0.00,0.00),('1','200','1025','257772',4905712,'3044','468',153700.70,154524.33,0.00,0.00,823.63,601249.90,0.00,0.00,0.00),('1','200','1025','257773',4905713,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257773',4905714,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257773',4905715,'3039','468',158395.64,159551.32,0.00,0.00,1155.68,901430.40,0.00,0.00,0.00),('1','200','1025','257773',4905716,'3040','468',159738.19,161111.39,0.00,0.00,1373.20,1071096.00,0.00,0.00,0.00),('1','200','1025','257773',4905717,'3041','468',153728.71,154188.35,0.00,0.00,459.64,335837.20,0.00,0.00,0.00),('1','200','1025','257773',4905718,'3042','468',172280.47,172929.47,0.00,0.00,649.00,473770.00,0.00,0.00,0.00),('1','200','1025','257773',4905719,'3043','468',170305.33,171285.91,0.00,0.00,980.58,715823.40,0.00,0.00,0.00),('1','200','1025','257773',4905720,'3044','468',154524.33,155335.75,0.00,0.00,811.42,592336.60,0.00,0.00,0.00),('1','200','1025','257774',4905721,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257774',4905722,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257774',4905723,'3039','468',159551.32,160826.59,0.00,0.00,1275.27,994710.60,0.00,0.00,0.00),('1','200','1025','257774',4905724,'3040','468',161111.39,162514.31,0.00,0.00,1402.92,1094277.60,0.00,0.00,0.00),('1','200','1025','257774',4905725,'3041','468',154188.35,154486.21,0.00,0.00,297.86,217437.80,0.00,0.00,0.00),('1','200','1025','257774',4905726,'3042','468',172929.47,173435.57,0.00,0.00,506.10,369453.00,0.00,0.00,0.00),('1','200','1025','257774',4905727,'3043','468',171285.91,171815.91,0.00,0.00,530.00,386900.00,0.00,0.00,0.00),('1','200','1025','257774',4905728,'3044','468',155335.75,155969.25,0.00,0.00,633.50,462455.00,0.00,0.00,0.00),('1','200','1025','257775',4905729,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257775',4905730,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257775',4905731,'3039','468',160826.59,162000.79,0.00,0.00,1174.20,915876.00,0.00,0.00,0.00),('1','200','1025','257775',4905732,'3040','468',162514.31,163629.86,0.00,0.00,1115.55,870129.00,0.00,0.00,0.00),('1','200','1025','257775',4905733,'3041','468',154486.21,154913.87,0.00,0.00,427.66,312191.80,0.00,0.00,0.00),('1','200','1025','257775',4905734,'3042','468',173435.57,173989.65,0.00,0.00,554.08,404478.40,0.00,0.00,0.00),('1','200','1025','257775',4905735,'3043','468',171815.91,172425.63,0.00,0.00,609.72,445095.60,0.00,0.00,0.00),('1','200','1025','257775',4905736,'3044','468',155969.25,156763.75,0.00,0.00,794.50,579985.00,0.00,0.00,0.00),('1','200','1025','257776',4905737,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257776',4905738,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257776',4905739,'3039','468',162000.79,163105.46,0.00,0.00,1104.67,861642.60,0.00,0.00,0.00),('1','200','1025','257776',4905740,'3040','468',163629.86,164892.61,0.00,0.00,1262.75,984945.00,0.00,0.00,0.00),('1','200','1025','257776',4905741,'3041','468',154913.87,155514.55,0.00,0.00,600.68,438496.40,0.00,0.00,0.00),('1','200','1025','257776',4905742,'3042','468',173989.65,174635.79,0.00,0.00,646.14,471682.20,0.00,0.00,0.00),('1','200','1025','257776',4905743,'3043','468',172425.63,173329.63,0.00,0.00,904.00,659920.00,0.00,0.00,0.00),('1','200','1025','257776',4905744,'3044','468',156763.75,157726.26,0.00,0.00,962.51,702632.30,0.00,0.00,0.00),('1','200','1025','257777',4905745,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257777',4905746,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257777',4905747,'3039','468',163105.46,164006.58,0.00,0.00,901.12,702873.60,0.00,0.00,0.00),('1','200','1025','257777',4905748,'3040','468',164892.61,165924.27,0.00,0.00,1031.66,804694.80,0.00,0.00,0.00),('1','200','1025','257777',4905749,'3041','468',155514.55,155780.85,0.00,0.00,266.30,194399.00,0.00,0.00,0.00),('1','200','1025','257777',4905750,'3042','468',174635.79,175245.37,0.00,0.00,609.58,444993.40,0.00,0.00,0.00),('1','200','1025','257777',4905751,'3043','468',173329.63,174336.73,0.00,0.00,1007.10,735183.00,0.00,0.00,0.00),('1','200','1025','257777',4905752,'3044','468',157726.26,158573.26,0.00,0.00,847.00,618310.00,0.00,0.00,0.00),('1','200','1025','257778',4905753,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257778',4905754,'3038','468',107640.88,107640.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257778',4905755,'3039','468',164006.58,165204.90,0.00,0.00,1198.32,934689.60,0.00,0.00,0.00),('1','200','1025','257778',4905756,'3040','468',165924.27,167040.09,0.00,0.00,1115.82,870339.60,0.00,0.00,0.00),('1','200','1025','257778',4905757,'3041','468',155780.85,155900.61,0.00,0.00,119.76,87424.80,0.00,0.00,0.00),('1','200','1025','257778',4905758,'3042','468',175245.37,176045.03,0.00,0.00,799.66,583751.80,0.00,0.00,0.00),('1','200','1025','257778',4905759,'3043','468',174336.73,175192.58,0.00,0.00,855.85,624770.50,0.00,0.00,0.00),('1','200','1025','257778',4905760,'3044','468',158573.26,159284.59,0.00,0.00,711.33,519270.90,0.00,0.00,0.00),('1','200','1025','257779',4905761,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257779',4905762,'3038','468',107640.88,107646.88,0.00,0.00,6.00,4680.00,0.00,0.00,0.00),('1','200','1025','257779',4905763,'3039','468',165204.90,166258.76,0.00,0.00,1053.86,822010.80,0.00,0.00,0.00),('1','200','1025','257779',4905764,'3040','468',167040.09,168054.39,0.00,0.00,1014.30,791154.00,0.00,0.00,0.00),('1','200','1025','257779',4905765,'3041','468',155900.61,155900.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257779',4905766,'3042','468',176045.03,176829.13,0.00,0.00,784.10,572393.00,0.00,0.00,0.00),('1','200','1025','257779',4905767,'3043','468',175192.58,176699.20,0.00,0.00,1506.62,1099832.60,0.00,0.00,0.00),('1','200','1025','257779',4905768,'3044','468',159284.59,160702.67,0.00,0.00,1418.08,1035198.40,0.00,0.00,0.00),('1','200','1025','257780',4905769,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257780',4905770,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257780',4905771,'3039','468',166258.76,167468.91,0.00,0.00,1210.15,943917.00,0.00,0.00,0.00),('1','200','1025','257780',4905772,'3040','468',168054.39,169470.28,0.00,0.00,1415.89,1104394.20,0.00,0.00,0.00),('1','200','1025','257780',4905773,'3041','468',155900.61,155948.61,0.00,0.00,48.00,35040.00,0.00,0.00,0.00),('1','200','1025','257780',4905774,'3042','468',176829.13,177413.66,0.00,0.00,584.53,426706.91,0.00,0.00,0.00),('1','200','1025','257780',4905775,'3043','468',176699.20,177467.66,0.00,0.00,768.46,560975.80,0.00,0.00,0.00),('1','200','1025','257780',4905776,'3044','468',160702.67,161629.09,0.00,0.00,926.42,676286.60,0.00,0.00,0.00),('1','200','1025','257781',4905777,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257781',4905778,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257781',4905779,'3039','468',167468.91,168706.91,0.00,0.00,1238.00,965640.00,0.00,0.00,0.00),('1','200','1025','257781',4905780,'3040','468',169470.28,170726.36,0.00,0.00,1256.08,979742.40,0.00,0.00,0.00),('1','200','1025','257781',4905781,'3041','468',155948.61,155948.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257781',4905782,'3042','468',177413.66,178193.30,0.00,0.00,779.64,569187.20,0.00,0.00,0.00),('1','200','1025','257781',4905783,'3043','468',177467.66,178142.62,0.00,0.00,674.96,492720.80,0.00,0.00,0.00),('1','200','1025','257781',4905784,'3044','468',161629.09,162291.09,0.00,0.00,662.00,483260.00,0.00,0.00,0.00),('1','200','1025','257782',4905785,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257782',4905786,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257782',4905787,'3039','468',168706.91,169835.06,0.00,0.00,1128.15,879957.00,0.00,0.00,0.00),('1','200','1025','257782',4905788,'3040','468',170726.36,171872.59,0.00,0.00,1146.23,894059.40,0.00,0.00,0.00),('1','200','1025','257782',4905789,'3041','468',155948.61,155948.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257782',4905790,'3042','468',178193.30,179070.60,0.00,0.00,877.30,640429.00,0.00,0.00,0.00),('1','200','1025','257782',4905791,'3043','468',178142.62,179326.62,0.00,0.00,1184.00,864320.00,0.00,0.00,0.00),('1','200','1025','257782',4905792,'3044','468',162291.09,163302.33,0.00,0.00,1011.24,738205.20,0.00,0.00,0.00),('1','200','1025','257783',4905793,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257783',4905794,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257783',4905795,'3039','468',169835.06,170882.80,0.00,0.00,1047.74,817237.20,0.00,0.00,0.00),('1','200','1025','257783',4905796,'3040','468',171872.59,173015.24,0.00,0.00,1142.65,891267.00,0.00,0.00,0.00),('1','200','1025','257783',4905797,'3041','468',155948.61,155948.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257783',4905798,'3042','468',179070.60,180082.64,0.00,0.00,1012.04,739089.20,0.00,0.00,0.00),('1','200','1025','257783',4905799,'3043','468',179326.62,180597.13,0.00,0.00,1270.51,927472.30,0.00,0.00,0.00),('1','200','1025','257783',4905800,'3044','468',163302.33,164540.44,0.00,0.00,1238.11,903820.30,0.00,0.00,0.00),('1','200','1025','257784',4905801,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257784',4905802,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257784',4905803,'3039','468',170882.80,171312.15,0.00,0.00,429.35,334893.00,0.00,0.00,0.00),('1','200','1025','257784',4905804,'3040','468',173015.24,173513.81,0.00,0.00,498.57,388884.60,0.00,0.00,0.00),('1','200','1025','257784',4905805,'3041','468',155948.61,155948.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257784',4905806,'3042','468',180082.64,180720.98,0.00,0.00,638.34,465988.20,0.00,0.00,0.00),('1','200','1025','257784',4905807,'3043','468',180597.13,181366.13,0.00,0.00,769.00,561370.00,0.00,0.00,0.00),('1','200','1025','257784',4905808,'3044','468',164540.44,165497.94,0.00,0.00,957.50,698975.00,0.00,0.00,0.00),('1','200','1025','257785',4905809,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257785',4905810,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257785',4905811,'3039','468',171312.15,171312.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257785',4905812,'3040','468',173513.81,173513.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257785',4905813,'3041','468',155948.61,155948.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257785',4905814,'3042','468',180720.98,180720.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257785',4905815,'3043','468',181366.13,181410.09,0.00,0.00,43.96,32090.80,0.00,0.00,0.00),('1','200','1025','257785',4905816,'3044','468',165497.94,165563.98,0.00,0.00,66.04,48209.20,0.00,0.00,0.00),('1','200','1025','257786',4905817,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257786',4905818,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257786',4905819,'3039','468',171312.15,171312.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257786',4905820,'3040','468',173513.81,173513.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257786',4905821,'3041','468',155948.61,155948.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257786',4905822,'3042','468',180720.98,180720.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257786',4905823,'3043','468',181410.09,181410.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257786',4905824,'3044','468',165563.98,165563.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257787',4905825,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257787',4905826,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257787',4905827,'3039','468',171312.15,172272.90,0.00,0.00,960.75,749385.00,0.00,0.00,0.00),('1','200','1025','257787',4905828,'3040','468',173513.81,174407.86,0.00,0.00,894.05,697359.00,0.00,0.00,0.00),('1','200','1025','257787',4905829,'3041','468',155948.61,155948.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257787',4905830,'3042','468',180720.98,181721.98,0.00,0.00,1001.00,730730.00,0.00,0.00,0.00),('1','200','1025','257787',4905831,'3043','468',181410.09,182701.87,0.00,0.00,1291.78,942999.40,0.00,0.00,0.00),('1','200','1025','257787',4905832,'3044','468',165563.98,166655.94,0.00,0.00,1091.96,797130.80,0.00,0.00,0.00),('1','200','1025','257788',4905833,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257788',4905834,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257788',4905835,'3039','468',172272.90,173555.78,0.00,0.00,1282.88,1000646.40,0.00,0.00,0.00),('1','200','1025','257788',4905836,'3040','468',174407.86,175556.88,0.00,0.00,1149.02,896235.60,0.00,0.00,0.00),('1','200','1025','257788',4905837,'3041','468',155948.61,156345.61,0.00,0.00,397.00,289810.00,0.00,0.00,0.00),('1','200','1025','257788',4905838,'3042','468',181721.98,182391.85,0.00,0.00,669.87,489005.10,0.00,0.00,0.00),('1','200','1025','257788',4905839,'3043','468',182701.87,183652.41,0.00,0.00,950.54,693894.20,0.00,0.00,0.00),('1','200','1025','257788',4905840,'3044','468',166655.94,167539.92,0.00,0.00,883.98,645305.40,0.00,0.00,0.00),('1','200','1025','257789',4905841,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257789',4905842,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257789',4905843,'3039','468',173555.78,174605.10,0.00,0.00,1049.32,818469.60,0.00,0.00,0.00),('1','200','1025','257789',4905844,'3040','468',175556.88,176894.18,0.00,0.00,1337.30,1043094.00,0.00,0.00,0.00),('1','200','1025','257789',4905845,'3041','468',156345.61,156958.61,0.00,0.00,613.00,447490.00,0.00,0.00,0.00),('1','200','1025','257789',4905846,'3042','468',182391.85,183032.35,0.00,0.00,640.50,467565.00,0.00,0.00,0.00),('1','200','1025','257789',4905847,'3043','468',183652.41,184538.93,0.00,0.00,886.52,647159.60,0.00,0.00,0.00),('1','200','1025','257789',4905848,'3044','468',167539.92,168626.84,0.00,0.00,1086.92,793451.60,0.00,0.00,0.00),('1','200','1025','257790',4905849,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257790',4905850,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257790',4905851,'3039','468',174605.10,176126.25,0.00,0.00,1521.15,1186497.00,0.00,0.00,0.00),('1','200','1025','257790',4905852,'3040','468',176894.18,178466.35,0.00,0.00,1572.17,1226292.60,0.00,0.00,0.00),('1','200','1025','257790',4905853,'3041','468',156958.61,157599.23,0.00,0.00,640.62,467652.60,0.00,0.00,0.00),('1','200','1025','257790',4905854,'3042','468',183032.35,183581.64,0.00,0.00,549.29,400981.70,0.00,0.00,0.00),('1','200','1025','257790',4905855,'3043','468',184538.93,185257.43,0.00,0.00,718.50,524505.00,0.00,0.00,0.00),('1','200','1025','257790',4905856,'3044','468',168626.84,169334.85,0.00,0.00,708.01,516847.30,0.00,0.00,0.00),('1','200','1025','257791',4905857,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257791',4905858,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257791',4905859,'3039','468',176126.25,177240.91,0.00,0.00,1114.66,869434.80,0.00,0.00,0.00),('1','200','1025','257791',4905860,'3040','468',178466.35,179674.14,0.00,0.00,1207.79,942076.20,0.00,0.00,0.00),('1','200','1025','257791',4905861,'3041','468',157599.23,158472.61,0.00,0.00,873.38,637567.40,0.00,0.00,0.00),('1','200','1025','257791',4905862,'3042','468',183581.64,184320.90,0.00,0.00,739.26,539659.80,0.00,0.00,0.00),('1','200','1025','257791',4905863,'3043','468',185257.43,186203.23,0.00,0.00,945.80,690434.00,0.00,0.00,0.00),('1','200','1025','257791',4905864,'3044','468',169334.85,170241.35,0.00,0.00,906.50,661745.00,0.00,0.00,0.00),('1','200','1025','257792',4905865,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257792',4905866,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257792',4905867,'3039','468',177240.91,178814.47,0.00,0.00,1573.56,1227376.80,0.00,0.00,0.00),('1','200','1025','257792',4905868,'3040','468',179674.14,181202.07,0.00,0.00,1527.93,1191785.40,0.00,0.00,0.00),('1','200','1025','257792',4905869,'3041','468',158472.61,159044.81,0.00,0.00,572.20,417706.00,0.00,0.00,0.00),('1','200','1025','257792',4905870,'3042','468',184320.90,184925.85,0.00,0.00,604.95,441613.50,0.00,0.00,0.00),('1','200','1025','257792',4905871,'3043','468',186203.23,186919.56,0.00,0.00,716.33,522920.90,0.00,0.00,0.00),('1','200','1025','257792',4905872,'3044','468',170241.35,170883.69,0.00,0.00,642.34,468908.20,0.00,0.00,0.00),('1','200','1025','257793',4905873,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257793',4905874,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257793',4905875,'3039','468',178814.47,180057.24,0.00,0.00,1242.77,969360.60,0.00,0.00,0.00),('1','200','1025','257793',4905876,'3040','468',181202.07,182276.09,0.00,0.00,1074.02,837735.60,0.00,0.00,0.00),('1','200','1025','257793',4905877,'3041','468',159044.81,159764.55,0.00,0.00,719.74,525410.20,0.00,0.00,0.00),('1','200','1025','257793',4905878,'3042','468',184925.85,185744.95,0.00,0.00,819.10,597943.00,0.00,0.00,0.00),('1','200','1025','257793',4905879,'3043','468',186919.56,187915.06,0.00,0.00,995.50,726715.00,0.00,0.00,0.00),('1','200','1025','257793',4905880,'3044','468',170883.69,171892.45,0.00,0.00,1008.76,736394.80,0.00,0.00,0.00),('1','200','1025','257794',4905881,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257794',4905882,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257794',4905883,'3039','468',180057.24,181540.71,0.00,0.00,1483.47,1157106.60,0.00,0.00,0.00),('1','200','1025','257794',4905884,'3040','468',182276.09,183756.53,0.00,0.00,1480.44,1154743.20,0.00,0.00,0.00),('1','200','1025','257794',4905885,'3041','468',159764.55,160219.47,0.00,0.00,454.92,332091.60,0.00,0.00,0.00),('1','200','1025','257794',4905886,'3042','468',185744.95,186213.18,0.00,0.00,468.23,341807.90,0.00,0.00,0.00),('1','200','1025','257794',4905887,'3043','468',187915.06,188622.06,0.00,0.00,707.00,516110.00,0.00,0.00,0.00),('1','200','1025','257794',4905888,'3044','468',171892.45,172656.45,0.00,0.00,764.00,557720.00,0.00,0.00,0.00),('1','200','1025','257795',4905889,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257795',4905890,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257795',4905891,'3039','468',181540.71,182625.28,0.00,0.00,1084.57,845964.60,0.00,0.00,0.00),('1','200','1025','257795',4905892,'3040','468',183756.53,184745.34,0.00,0.00,988.81,771271.80,0.00,0.00,0.00),('1','200','1025','257795',4905893,'3041','468',160219.47,160810.59,0.00,0.00,591.12,431517.60,0.00,0.00,0.00),('1','200','1025','257795',4905894,'3042','468',186213.18,186837.78,0.00,0.00,624.60,455958.00,0.00,0.00,0.00),('1','200','1025','257795',4905895,'3043','468',188622.06,189290.64,0.00,0.00,668.58,488063.40,0.00,0.00,0.00),('1','200','1025','257795',4905896,'3044','468',172656.45,173422.45,0.00,0.00,766.00,559180.00,0.00,0.00,0.00),('1','200','1025','257796',4905897,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257796',4905898,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257796',4905899,'3039','468',182625.28,182625.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257796',4905900,'3040','468',184745.34,184745.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257796',4905901,'3041','468',160810.59,160810.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257796',4905902,'3042','468',186837.78,186837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257796',4905903,'3043','468',189290.64,189290.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257796',4905904,'3044','468',173422.45,173422.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257797',4905905,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257797',4905906,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257797',4905907,'3039','468',182625.28,183277.53,0.00,0.00,652.25,508755.00,0.00,0.00,0.00),('1','200','1025','257797',4905908,'3040','468',184745.34,185380.95,0.00,0.00,635.61,495775.80,0.00,0.00,0.00),('1','200','1025','257797',4905909,'3041','468',160810.59,161024.09,0.00,0.00,213.50,155855.00,0.00,0.00,0.00),('1','200','1025','257797',4905910,'3042','468',186837.78,187030.20,0.00,0.00,192.42,140466.60,0.00,0.00,0.00),('1','200','1025','257797',4905911,'3043','468',189290.64,189590.39,0.00,0.00,299.75,218817.50,0.00,0.00,0.00),('1','200','1025','257797',4905912,'3044','468',173422.45,173656.87,0.00,0.00,234.42,171126.60,0.00,0.00,0.00),('1','200','1025','257798',4905913,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257798',4905914,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257798',4905915,'3039','468',183277.53,185408.32,0.00,0.00,2130.79,1662016.20,0.00,0.00,0.00),('1','200','1025','257798',4905916,'3040','468',185380.95,187386.24,0.00,0.00,2005.29,1564126.20,0.00,0.00,0.00),('1','200','1025','257798',4905917,'3041','468',161024.09,161664.52,0.00,0.00,640.43,467513.90,0.00,0.00,0.00),('1','200','1025','257798',4905918,'3042','468',187030.20,187932.89,0.00,0.00,902.69,658963.70,0.00,0.00,0.00),('1','200','1025','257798',4905919,'3043','468',189590.39,190782.00,0.00,0.00,1191.61,869875.30,0.00,0.00,0.00),('1','200','1025','257798',4905920,'3044','468',173656.87,174886.06,0.00,0.00,1229.19,897308.70,0.00,0.00,0.00),('1','200','1025','257799',4905921,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257799',4905922,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257799',4905923,'3039','468',185408.32,187090.38,0.00,0.00,1682.06,1312006.80,0.00,0.00,0.00),('1','200','1025','257799',4905924,'3040','468',187386.24,188898.18,0.00,0.00,1511.94,1179313.20,0.00,0.00,0.00),('1','200','1025','257799',4905925,'3041','468',161664.52,162180.97,0.00,0.00,516.45,377008.50,0.00,0.00,0.00),('1','200','1025','257799',4905926,'3042','468',187932.89,188869.77,0.00,0.00,936.88,683922.40,0.00,0.00,0.00),('1','200','1025','257799',4905927,'3043','468',190782.00,192035.00,0.00,0.00,1253.00,914690.00,0.00,0.00,0.00),('1','200','1025','257799',4905928,'3044','468',174886.06,176068.57,0.00,0.00,1182.51,863232.30,0.00,0.00,0.00),('1','200','1025','257800',4905929,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257800',4905930,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257800',4905931,'3039','468',187090.38,188746.04,0.00,0.00,1655.66,1291414.80,0.00,0.00,0.00),('1','200','1025','257800',4905932,'3040','468',188898.18,190645.64,0.00,0.00,1747.46,1363018.80,0.00,0.00,0.00),('1','200','1025','257800',4905933,'3041','468',162180.97,162795.49,0.00,0.00,614.52,448599.60,0.00,0.00,0.00),('1','200','1025','257800',4905934,'3042','468',188869.77,189259.49,0.00,0.00,389.72,284495.60,0.00,0.00,0.00),('1','200','1025','257800',4905935,'3043','468',192035.00,192641.50,0.00,0.00,606.50,442745.00,0.00,0.00,0.00),('1','200','1025','257800',4905936,'3044','468',176068.57,176922.45,0.00,0.00,853.88,623332.40,0.00,0.00,0.00),('1','200','1025','257801',4905937,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257801',4905938,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257801',4905939,'3039','468',188746.04,189532.96,0.00,0.00,786.92,613797.60,0.00,0.00,0.00),('1','200','1025','257801',4905940,'3040','468',190645.64,191520.19,0.00,0.00,874.55,682149.00,0.00,0.00,0.00),('1','200','1025','257801',4905941,'3041','468',162795.49,162795.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257801',4905942,'3042','468',189259.49,189259.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257801',4905943,'3043','468',192641.50,192641.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257801',4905944,'3044','468',176922.45,176922.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257802',4905945,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257802',4905946,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257802',4905947,'3039','468',189532.96,189687.98,0.00,0.00,155.02,120915.60,0.00,0.00,0.00),('1','200','1025','257802',4905948,'3040','468',191520.19,191658.94,0.00,0.00,138.75,108225.00,0.00,0.00,0.00),('1','200','1025','257802',4905949,'3041','468',162795.49,162795.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257802',4905950,'3042','468',189259.49,189259.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257802',4905951,'3043','468',192641.50,192641.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257802',4905952,'3044','468',176922.45,176922.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257803',4905953,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257803',4905954,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257803',4905955,'3039','468',189687.98,190360.25,0.00,0.00,672.27,524370.60,0.00,0.00,0.00),('1','200','1025','257803',4905956,'3040','468',191658.94,192339.10,0.00,0.00,680.16,530524.80,0.00,0.00,0.00),('1','200','1025','257803',4905957,'3041','468',162795.49,163074.48,0.00,0.00,278.99,203662.70,0.00,0.00,0.00),('1','200','1025','257803',4905958,'3042','468',189259.49,189486.49,0.00,0.00,227.00,165710.00,0.00,0.00,0.00),('1','200','1025','257803',4905959,'3043','468',192641.50,193079.90,0.00,0.00,438.40,320032.00,0.00,0.00,0.00),('1','200','1025','257803',4905960,'3044','468',176922.45,177313.75,0.00,0.00,391.30,285649.00,0.00,0.00,0.00),('1','200','1025','257804',4905961,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257804',4905962,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257804',4905963,'3039','468',190360.25,191545.73,0.00,0.00,1185.48,924674.40,0.00,0.00,0.00),('1','200','1025','257804',4905964,'3040','468',192339.10,193694.90,0.00,0.00,1355.80,1057524.00,0.00,0.00,0.00),('1','200','1025','257804',4905965,'3041','468',163074.48,163763.48,0.00,0.00,689.00,502970.00,0.00,0.00,0.00),('1','200','1025','257804',4905966,'3042','468',189486.49,190246.50,0.00,0.00,760.01,554807.30,0.00,0.00,0.00),('1','200','1025','257804',4905967,'3043','468',193079.90,194008.61,0.00,0.00,928.71,677958.30,0.00,0.00,0.00),('1','200','1025','257804',4905968,'3044','468',177313.75,178535.01,0.00,0.00,1221.26,891519.80,0.00,0.00,0.00),('1','200','1025','257805',4905969,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257805',4905970,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257805',4905971,'3039','468',191545.73,193225.41,0.00,0.00,1679.68,1310150.40,0.00,0.00,0.00),('1','200','1025','257805',4905972,'3040','468',193694.90,195338.26,0.00,0.00,1643.36,1281820.80,0.00,0.00,0.00),('1','200','1025','257805',4905973,'3041','468',163763.48,165584.17,0.00,0.00,1820.69,1329103.70,0.00,0.00,0.00),('1','200','1025','257805',4905974,'3042','468',190246.50,191934.11,0.00,0.00,1687.61,1231955.30,0.00,0.00,0.00),('1','200','1025','257805',4905975,'3043','468',194008.61,195948.77,0.00,0.00,1940.16,1416316.80,0.00,0.00,0.00),('1','200','1025','257805',4905976,'3044','468',178535.01,180472.63,0.00,0.00,1937.62,1414562.60,0.00,0.00,0.00),('1','200','1025','257806',4905977,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257806',4905978,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257806',4905979,'3039','468',193225.41,194667.35,0.00,0.00,1441.94,1124713.20,0.00,0.00,0.00),('1','200','1025','257806',4905980,'3040','468',195338.26,196803.66,0.00,0.00,1465.40,1143012.00,0.00,0.00,0.00),('1','200','1025','257806',4905981,'3041','468',165584.17,165808.17,0.00,0.00,224.00,163520.00,0.00,0.00,0.00),('1','200','1025','257806',4905982,'3042','468',191934.11,192155.11,0.00,0.00,221.00,161330.00,0.00,0.00,0.00),('1','200','1025','257806',4905983,'3043','468',195948.77,195948.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257806',4905984,'3044','468',180472.63,180472.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257807',4905985,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257807',4905986,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257807',4905987,'3039','468',194667.35,195676.07,0.00,0.00,1008.72,786801.60,0.00,0.00,0.00),('1','200','1025','257807',4905988,'3040','468',196803.66,197894.02,0.00,0.00,1090.36,850480.80,0.00,0.00,0.00),('1','200','1025','257807',4905989,'3041','468',165808.17,165808.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257807',4905990,'3042','468',192155.11,192155.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257807',4905991,'3043','468',195948.77,195948.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257807',4905992,'3044','468',180472.63,180472.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257808',4905993,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257808',4905994,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257808',4905995,'3039','468',195676.07,195676.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257808',4905996,'3040','468',197894.02,197894.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257808',4905997,'3041','468',165808.17,165808.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257808',4905998,'3042','468',192155.11,192155.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257808',4905999,'3043','468',195948.77,195948.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257808',4906000,'3044','468',180472.63,180472.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257809',4906001,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257809',4906002,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257809',4906003,'3039','468',195676.07,196653.54,0.00,0.00,977.47,762426.60,0.00,0.00,0.00),('1','200','1025','257809',4906004,'3040','468',197894.02,199057.50,0.00,0.00,1163.48,907514.40,0.00,0.00,0.00),('1','200','1025','257809',4906005,'3041','468',165808.17,166870.17,0.00,0.00,1062.00,775260.00,0.00,0.00,0.00),('1','200','1025','257809',4906006,'3042','468',192155.11,193203.72,0.00,0.00,1048.61,765485.30,0.00,0.00,0.00),('1','200','1025','257809',4906007,'3043','468',195948.77,197272.76,0.00,0.00,1323.99,966512.70,0.00,0.00,0.00),('1','200','1025','257809',4906008,'3044','468',180472.63,181802.42,0.00,0.00,1329.79,970746.70,0.00,0.00,0.00),('1','200','1025','257810',4906009,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257810',4906010,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257810',4906011,'3039','468',196653.54,198046.52,0.00,0.00,1392.98,1086524.40,0.00,0.00,0.00),('1','200','1025','257810',4906012,'3040','468',199057.50,200316.95,0.00,0.00,1259.45,982371.00,0.00,0.00,0.00),('1','200','1025','257810',4906013,'3041','468',166870.17,168084.82,0.00,0.00,1214.65,886694.50,0.00,0.00,0.00),('1','200','1025','257810',4906014,'3042','468',193203.72,194356.53,0.00,0.00,1152.81,841551.30,0.00,0.00,0.00),('1','200','1025','257810',4906015,'3043','468',197272.76,198506.27,0.00,0.00,1233.51,900462.30,0.00,0.00,0.00),('1','200','1025','257810',4906016,'3044','468',181802.42,183312.92,0.00,0.00,1510.50,1102665.00,0.00,0.00,0.00),('1','200','1025','257811',4906017,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257811',4906018,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257811',4906019,'3039','468',198046.52,199166.78,0.00,0.00,1120.26,873802.80,0.00,0.00,0.00),('1','200','1025','257811',4906020,'3040','468',200316.95,201576.29,0.00,0.00,1259.34,982285.20,0.00,0.00,0.00),('1','200','1025','257811',4906021,'3041','468',168084.82,169133.50,0.00,0.00,1048.68,765536.40,0.00,0.00,0.00),('1','200','1025','257811',4906022,'3042','468',194356.53,195419.45,0.00,0.00,1062.92,775931.60,0.00,0.00,0.00),('1','200','1025','257811',4906023,'3043','468',198506.27,199176.00,0.00,0.00,669.73,488902.90,0.00,0.00,0.00),('1','200','1025','257811',4906024,'3044','468',183312.92,183999.68,0.00,0.00,686.76,501334.80,0.00,0.00,0.00),('1','200','1025','257812',4906025,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257812',4906026,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257812',4906027,'3039','468',199166.78,201041.85,0.00,0.00,1875.07,1462554.60,0.00,0.00,0.00),('1','200','1025','257812',4906028,'3040','468',201576.29,203419.67,0.00,0.00,1843.38,1437836.40,0.00,0.00,0.00),('1','200','1025','257812',4906029,'3041','468',169133.50,169539.50,0.00,0.00,406.00,296380.00,0.00,0.00,0.00),('1','200','1025','257812',4906030,'3042','468',195419.45,195583.15,0.00,0.00,163.70,119501.00,0.00,0.00,0.00),('1','200','1025','257812',4906031,'3043','468',199176.00,199176.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257812',4906032,'3044','468',183999.68,183999.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257813',4906033,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257813',4906034,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257813',4906035,'3039','468',201041.85,201041.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257813',4906036,'3040','468',203419.67,203419.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257813',4906037,'3041','468',169539.50,169539.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257813',4906038,'3042','468',195583.15,195583.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257813',4906039,'3043','468',199176.00,199176.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257813',4906040,'3044','468',183999.68,183999.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257814',4906041,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257814',4906042,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257814',4906043,'3039','468',201041.85,202337.80,0.00,0.00,1295.95,997881.50,0.00,0.00,0.00),('1','200','1025','257814',4906044,'3040','468',203419.67,204539.77,0.00,0.00,1120.10,862477.00,0.00,0.00,0.00),('1','200','1025','257814',4906045,'3041','468',169539.50,170412.00,0.00,0.00,872.50,628200.00,0.00,0.00,0.00),('1','200','1025','257814',4906046,'3042','468',195583.15,196447.58,0.00,0.00,864.43,622389.60,0.00,0.00,0.00),('1','200','1025','257814',4906047,'3043','468',199176.00,200072.50,0.00,0.00,896.50,645480.00,0.00,0.00,0.00),('1','200','1025','257814',4906048,'3044','468',183999.68,185285.96,0.00,0.00,1286.28,926121.60,0.00,0.00,0.00),('1','200','1025','257815',4906049,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257815',4906050,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257815',4906051,'3039','468',202337.80,204229.11,0.00,0.00,1891.31,1456308.70,0.00,0.00,0.00),('1','200','1025','257815',4906052,'3040','468',204539.77,206327.13,0.00,0.00,1787.36,1376267.20,0.00,0.00,0.00),('1','200','1025','257815',4906053,'3041','468',170412.00,171951.00,0.00,0.00,1539.00,1108080.00,0.00,0.00,0.00),('1','200','1025','257815',4906054,'3042','468',196447.58,198103.69,0.00,0.00,1656.11,1192399.20,0.00,0.00,0.00),('1','200','1025','257815',4906055,'3043','468',200072.50,201416.57,0.00,0.00,1344.07,967730.40,0.00,0.00,0.00),('1','200','1025','257815',4906056,'3044','468',185285.96,186797.29,0.00,0.00,1511.33,1088157.60,0.00,0.00,0.00),('1','200','1025','257816',4906057,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257816',4906058,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257816',4906059,'3039','468',204229.11,206255.50,0.00,0.00,2026.39,1560320.30,0.00,0.00,0.00),('1','200','1025','257816',4906060,'3040','468',206327.13,208670.11,0.00,0.00,2342.98,1804094.60,0.00,0.00,0.00),('1','200','1025','257816',4906061,'3041','468',171951.00,171951.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257816',4906062,'3042','468',198103.69,198103.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257816',4906063,'3043','468',201416.57,201416.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257816',4906064,'3044','468',186797.29,186797.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257817',4906065,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257817',4906066,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257817',4906067,'3039','468',206255.50,208439.18,0.00,0.00,2183.68,1681433.60,0.00,0.00,0.00),('1','200','1025','257817',4906068,'3040','468',208670.11,210953.85,0.00,0.00,2283.74,1758479.80,0.00,0.00,0.00),('1','200','1025','257817',4906069,'3041','468',171951.00,171951.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257817',4906070,'3042','468',198103.69,198103.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257817',4906071,'3043','468',201416.57,201416.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257817',4906072,'3044','468',186797.29,186797.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257818',4906073,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257818',4906074,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257818',4906075,'3039','468',208439.18,208439.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257818',4906076,'3040','468',210953.85,210953.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257818',4906077,'3041','468',171951.00,171951.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257818',4906078,'3042','468',198103.69,198103.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257818',4906079,'3043','468',201416.57,201416.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257818',4906080,'3044','468',186797.29,186797.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257819',4906081,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257819',4906082,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257819',4906083,'3039','468',208439.18,209586.69,0.00,0.00,1147.51,906532.90,0.00,0.00,0.00),('1','200','1025','257819',4906084,'3040','468',210953.85,211914.45,0.00,0.00,960.60,758874.00,0.00,0.00,0.00),('1','200','1025','257819',4906085,'3041','468',171951.00,173590.59,0.00,0.00,1639.59,1229692.50,0.00,0.00,0.00),('1','200','1025','257819',4906086,'3042','468',198103.69,199837.69,0.00,0.00,1734.00,1300500.00,0.00,0.00,0.00),('1','200','1025','257819',4906087,'3043','468',201416.57,202860.27,0.00,0.00,1443.70,1082775.00,0.00,0.00,0.00),('1','200','1025','257819',4906088,'3044','468',186797.29,188509.80,0.00,0.00,1712.51,1284382.50,0.00,0.00,0.00),('1','200','1025','257820',4906089,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257820',4906090,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257820',4906091,'3039','468',209586.69,210725.95,0.00,0.00,1139.26,900015.40,0.00,0.00,0.00),('1','200','1025','257820',4906092,'3040','468',211914.45,213083.39,0.00,0.00,1168.94,923462.60,0.00,0.00,0.00),('1','200','1025','257820',4906093,'3041','468',173590.59,175296.15,0.00,0.00,1705.56,1279170.00,0.00,0.00,0.00),('1','200','1025','257820',4906094,'3042','468',199837.69,201641.43,0.00,0.00,1803.74,1352805.00,0.00,0.00,0.00),('1','200','1025','257820',4906095,'3043','468',202860.27,204099.67,0.00,0.00,1239.40,929550.00,0.00,0.00,0.00),('1','200','1025','257820',4906096,'3044','468',188509.80,189986.30,0.00,0.00,1476.50,1107375.00,0.00,0.00,0.00),('1','200','1025','257821',4906097,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257821',4906098,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257821',4906099,'3039','468',210725.95,211767.22,0.00,0.00,1041.27,822603.30,0.00,0.00,0.00),('1','200','1025','257821',4906100,'3040','468',213083.39,214087.16,0.00,0.00,1003.77,792978.30,0.00,0.00,0.00),('1','200','1025','257821',4906101,'3041','468',175296.15,175822.58,0.00,0.00,526.43,394822.50,0.00,0.00,0.00),('1','200','1025','257821',4906102,'3042','468',201641.43,202133.93,0.00,0.00,492.50,369375.00,0.00,0.00,0.00),('1','200','1025','257821',4906103,'3043','468',204099.67,204884.00,0.00,0.00,784.33,588247.50,0.00,0.00,0.00),('1','200','1025','257821',4906104,'3044','468',189986.30,190653.80,0.00,0.00,667.50,500625.00,0.00,0.00,0.00),('1','200','1025','257822',4906105,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257822',4906106,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257822',4906107,'3039','468',211767.22,212947.31,0.00,0.00,1180.09,932281.10,0.00,0.00,0.00),('1','200','1025','257822',4906108,'3040','468',214087.16,215371.24,0.00,0.00,1284.08,1014423.20,0.00,0.00,0.00),('1','200','1025','257822',4906109,'3041','468',175822.58,176373.08,0.00,0.00,550.50,420582.00,0.00,0.00,0.00),('1','200','1025','257822',4906110,'3042','468',202133.93,202718.96,0.00,0.00,585.03,446962.92,0.00,0.00,0.00),('1','200','1025','257822',4906111,'3043','468',204884.00,205568.10,0.00,0.00,684.10,522652.40,0.00,0.00,0.00),('1','200','1025','257822',4906112,'3044','468',190653.80,191439.21,0.00,0.00,785.41,600053.24,0.00,0.00,0.00),('1','200','1025','257823',4906113,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257823',4906114,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257823',4906115,'3039','468',212947.31,214031.68,0.00,0.00,1084.37,856652.30,0.00,0.00,0.00),('1','200','1025','257823',4906116,'3040','468',215371.24,216516.24,0.00,0.00,1145.00,904550.00,0.00,0.00,0.00),('1','200','1025','257823',4906117,'3041','468',176373.08,177012.08,0.00,0.00,639.00,488196.00,0.00,0.00,0.00),('1','200','1025','257823',4906118,'3042','468',202718.96,203278.72,0.00,0.00,559.76,427656.64,0.00,0.00,0.00),('1','200','1025','257823',4906119,'3043','468',205568.10,206132.60,0.00,0.00,564.50,431278.00,0.00,0.00,0.00),('1','200','1025','257823',4906120,'3044','468',191439.21,191906.25,0.00,0.00,467.04,356818.56,0.00,0.00,0.00),('1','200','1025','257824',4906121,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257824',4906122,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257824',4906123,'3039','468',214031.68,215196.88,0.00,0.00,1165.20,920508.00,0.00,0.00,0.00),('1','200','1025','257824',4906124,'3040','468',216516.24,217684.70,0.00,0.00,1168.46,923083.40,0.00,0.00,0.00),('1','200','1025','257824',4906125,'3041','468',177012.08,177167.08,0.00,0.00,155.00,118420.00,0.00,0.00,0.00),('1','200','1025','257824',4906126,'3042','468',203278.72,203656.61,0.00,0.00,377.89,288707.96,0.00,0.00,0.00),('1','200','1025','257824',4906127,'3043','468',206132.60,206997.10,0.00,0.00,864.50,660478.00,0.00,0.00,0.00),('1','200','1025','257824',4906128,'3044','468',191906.25,192926.75,0.00,0.00,1020.50,779662.00,0.00,0.00,0.00),('1','200','1025','257825',4906129,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257825',4906130,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257825',4906131,'3039','468',215196.88,216479.71,0.00,0.00,1282.83,1013435.70,0.00,0.00,0.00),('1','200','1025','257825',4906132,'3040','468',217684.70,219023.00,0.00,0.00,1338.30,1057257.00,0.00,0.00,0.00),('1','200','1025','257825',4906133,'3041','468',177167.08,177167.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257825',4906134,'3042','468',203656.61,204357.11,0.00,0.00,700.50,535182.00,0.00,0.00,0.00),('1','200','1025','257825',4906135,'3043','468',206997.10,207509.62,0.00,0.00,512.52,391565.28,0.00,0.00,0.00),('1','200','1025','257825',4906136,'3044','468',192926.75,193587.25,0.00,0.00,660.50,504622.00,0.00,0.00,0.00),('1','200','1025','257826',4906137,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257826',4906138,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257826',4906139,'3039','468',216479.71,217803.21,0.00,0.00,1323.50,1045565.00,0.00,0.00,0.00),('1','200','1025','257826',4906140,'3040','468',219023.00,220296.25,0.00,0.00,1273.25,1005867.50,0.00,0.00,0.00),('1','200','1025','257826',4906141,'3041','468',177167.08,177167.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257826',4906142,'3042','468',204357.11,204802.31,0.00,0.00,445.20,340132.80,0.00,0.00,0.00),('1','200','1025','257826',4906143,'3043','468',207509.62,208244.28,0.00,0.00,734.66,561280.24,0.00,0.00,0.00),('1','200','1025','257826',4906144,'3044','468',193587.25,194459.14,0.00,0.00,871.89,666123.96,0.00,0.00,0.00),('1','200','1025','257827',4906145,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257827',4906146,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257827',4906147,'3039','468',217803.21,219408.26,0.00,0.00,1605.05,1267989.50,0.00,0.00,0.00),('1','200','1025','257827',4906148,'3040','468',220296.25,221717.52,0.00,0.00,1421.27,1122803.30,0.00,0.00,0.00),('1','200','1025','257827',4906149,'3041','468',177167.08,177167.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257827',4906150,'3042','468',204802.31,205450.31,0.00,0.00,648.00,495072.00,0.00,0.00,0.00),('1','200','1025','257827',4906151,'3043','468',208244.28,209398.51,0.00,0.00,1154.23,881831.72,0.00,0.00,0.00),('1','200','1025','257827',4906152,'3044','468',194459.14,195371.83,0.00,0.00,912.69,697295.16,0.00,0.00,0.00),('1','200','1025','257828',4906153,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257828',4906154,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257828',4906155,'3039','468',219408.26,220709.62,0.00,0.00,1301.36,1028074.40,0.00,0.00,0.00),('1','200','1025','257828',4906156,'3040','468',221717.52,223124.99,0.00,0.00,1407.47,1111901.30,0.00,0.00,0.00),('1','200','1025','257828',4906157,'3041','468',177167.08,177382.08,0.00,0.00,215.00,164260.00,0.00,0.00,0.00),('1','200','1025','257828',4906158,'3042','468',205450.31,206387.42,0.00,0.00,937.11,715952.04,0.00,0.00,0.00),('1','200','1025','257828',4906159,'3043','468',209398.51,210706.87,0.00,0.00,1308.36,999587.04,0.00,0.00,0.00),('1','200','1025','257828',4906160,'3044','468',195371.83,195899.83,0.00,0.00,528.00,403392.00,0.00,0.00,0.00),('1','200','1025','257829',4906161,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257829',4906162,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257829',4906163,'3039','468',220709.62,222048.66,0.00,0.00,1339.04,1057841.60,0.00,0.00,0.00),('1','200','1025','257829',4906164,'3040','468',223124.99,224237.86,0.00,0.00,1112.87,879167.30,0.00,0.00,0.00),('1','200','1025','257829',4906165,'3041','468',177382.08,177695.08,0.00,0.00,313.00,239132.00,0.00,0.00,0.00),('1','200','1025','257829',4906166,'3042','468',206387.42,206946.11,0.00,0.00,558.69,426839.16,0.00,0.00,0.00),('1','200','1025','257829',4906167,'3043','468',210706.87,211581.87,0.00,0.00,875.00,668500.00,0.00,0.00,0.00),('1','200','1025','257829',4906168,'3044','468',195899.83,196813.28,0.00,0.00,913.45,697875.80,0.00,0.00,0.00),('1','200','1025','257830',4906169,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257830',4906170,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257830',4906171,'3039','468',222048.66,223191.53,0.00,0.00,1142.87,902867.30,0.00,0.00,0.00),('1','200','1025','257830',4906172,'3040','468',224237.86,225486.26,0.00,0.00,1248.40,986236.00,0.00,0.00,0.00),('1','200','1025','257830',4906173,'3041','468',177695.08,178127.62,0.00,0.00,432.54,330460.56,0.00,0.00,0.00),('1','200','1025','257830',4906174,'3042','468',206946.11,207587.61,0.00,0.00,641.50,490106.00,0.00,0.00,0.00),('1','200','1025','257830',4906175,'3043','468',211581.87,212182.02,0.00,0.00,600.15,458514.60,0.00,0.00,0.00),('1','200','1025','257830',4906176,'3044','468',196813.28,197451.98,0.00,0.00,638.70,487966.80,0.00,0.00,0.00),('1','200','1025','257831',4906177,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257831',4906178,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257831',4906179,'3039','468',223191.53,224526.11,0.00,0.00,1334.58,1054318.20,0.00,0.00,0.00),('1','200','1025','257831',4906180,'3040','468',225486.26,226774.48,0.00,0.00,1288.22,1017693.80,0.00,0.00,0.00),('1','200','1025','257831',4906181,'3041','468',178127.62,178633.26,0.00,0.00,505.64,386308.96,0.00,0.00,0.00),('1','200','1025','257831',4906182,'3042','468',207587.61,207898.81,0.00,0.00,311.20,237756.80,0.00,0.00,0.00),('1','200','1025','257831',4906183,'3043','468',212182.02,212307.27,0.00,0.00,125.25,95691.00,0.00,0.00,0.00),('1','200','1025','257831',4906184,'3044','468',197451.98,197568.96,0.00,0.00,116.98,89372.72,0.00,0.00,0.00),('1','200','1025','257832',4906185,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257832',4906186,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257832',4906187,'3039','468',224526.11,225335.44,0.00,0.00,809.33,639370.70,0.00,0.00,0.00),('1','200','1025','257832',4906188,'3040','468',226774.48,227611.96,0.00,0.00,837.48,661609.20,0.00,0.00,0.00),('1','200','1025','257832',4906189,'3041','468',178633.26,179174.60,0.00,0.00,541.34,413583.76,0.00,0.00,0.00),('1','200','1025','257832',4906190,'3042','468',207898.81,208488.25,0.00,0.00,589.44,450332.16,0.00,0.00,0.00),('1','200','1025','257832',4906191,'3043','468',212307.27,212947.57,0.00,0.00,640.30,489189.20,0.00,0.00,0.00),('1','200','1025','257832',4906192,'3044','468',197568.96,198217.96,0.00,0.00,649.00,495836.00,0.00,0.00,0.00),('1','200','1025','257833',4906193,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257833',4906194,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257833',4906195,'3039','468',225335.44,225335.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257833',4906196,'3040','468',227611.96,227611.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257833',4906197,'3041','468',179174.60,179174.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257833',4906198,'3042','468',208488.25,208488.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257833',4906199,'3043','468',212947.57,212947.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257833',4906200,'3044','468',198217.96,198217.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257834',4906201,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257834',4906202,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257834',4906203,'3039','468',225335.44,225556.51,0.00,0.00,221.07,174645.30,0.00,0.00,0.00),('1','200','1025','257834',4906204,'3040','468',227611.96,227895.59,0.00,0.00,283.63,224067.70,0.00,0.00,0.00),('1','200','1025','257834',4906205,'3041','468',179174.60,179336.60,0.00,0.00,162.00,123768.00,0.00,0.00,0.00),('1','200','1025','257834',4906206,'3042','468',208488.25,208631.25,0.00,0.00,143.00,109252.00,0.00,0.00,0.00),('1','200','1025','257834',4906207,'3043','468',212947.57,213164.57,0.00,0.00,217.00,165788.00,0.00,0.00,0.00),('1','200','1025','257834',4906208,'3044','468',198217.96,198391.96,0.00,0.00,174.00,132936.00,0.00,0.00,0.00),('1','200','1025','257835',4906209,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257835',4906210,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257835',4906211,'3039','468',225556.51,226721.69,0.00,0.00,1165.18,920492.20,0.00,0.00,0.00),('1','200','1025','257835',4906212,'3040','468',227895.59,229142.64,0.00,0.00,1247.05,1009229.50,0.00,0.00,0.00),('1','200','1025','257835',4906213,'3041','468',179336.60,179795.15,0.00,0.00,458.55,350332.20,0.00,0.00,0.00),('1','200','1025','257835',4906214,'3042','468',208631.25,208879.05,0.00,0.00,247.80,189319.20,0.00,0.00,0.00),('1','200','1025','257835',4906215,'3043','468',213164.57,213717.52,0.00,0.00,552.95,422453.80,0.00,0.00,0.00),('1','200','1025','257835',4906216,'3044','468',198391.96,199298.63,0.00,0.00,906.67,692695.88,0.00,0.00,0.00),('1','200','1025','257836',4906217,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257836',4906218,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257836',4906219,'3039','468',226721.69,227717.04,0.00,0.00,995.35,786326.50,0.00,0.00,0.00),('1','200','1025','257836',4906220,'3040','468',229142.64,230031.28,0.00,0.00,888.64,702025.60,0.00,0.00,0.00),('1','200','1025','257836',4906221,'3041','468',179795.15,180175.06,0.00,0.00,379.91,290251.24,0.00,0.00,0.00),('1','200','1025','257836',4906222,'3042','468',208879.05,209300.47,0.00,0.00,421.42,321964.88,0.00,0.00,0.00),('1','200','1025','257836',4906223,'3043','468',213717.52,214606.13,0.00,0.00,888.61,678898.04,0.00,0.00,0.00),('1','200','1025','257836',4906224,'3044','468',199298.63,200196.63,0.00,0.00,898.00,686072.00,0.00,0.00,0.00),('1','200','1025','257837',4906225,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257837',4906226,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257837',4906227,'3039','468',227717.04,228755.71,0.00,0.00,1038.67,810162.60,0.00,0.00,0.00),('1','200','1025','257837',4906228,'3040','468',230031.28,231086.72,0.00,0.00,1055.44,823243.20,0.00,0.00,0.00),('1','200','1025','257837',4906229,'3041','468',180175.06,180882.03,0.00,0.00,706.97,523157.80,0.00,0.00,0.00),('1','200','1025','257837',4906230,'3042','468',209300.47,209791.97,0.00,0.00,491.50,363710.00,0.00,0.00,0.00),('1','200','1025','257837',4906231,'3043','468',214606.13,215464.38,0.00,0.00,858.25,635105.00,0.00,0.00,0.00),('1','200','1025','257837',4906232,'3044','468',200196.63,201170.43,0.00,0.00,973.80,720612.00,0.00,0.00,0.00),('1','200','1025','257838',4906233,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257838',4906234,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257838',4906235,'3039','468',228755.71,229808.37,0.00,0.00,1052.66,821074.80,0.00,0.00,0.00),('1','200','1025','257838',4906236,'3040','468',231086.72,232041.03,0.00,0.00,954.31,744361.80,0.00,0.00,0.00),('1','200','1025','257838',4906237,'3041','468',180882.03,181283.03,0.00,0.00,401.00,296740.00,0.00,0.00,0.00),('1','200','1025','257838',4906238,'3042','468',209791.97,210219.47,0.00,0.00,427.50,316350.00,0.00,0.00,0.00),('1','200','1025','257838',4906239,'3043','468',215464.38,215949.67,0.00,0.00,485.29,359114.60,0.00,0.00,0.00),('1','200','1025','257838',4906240,'3044','468',201170.43,201845.07,0.00,0.00,674.64,499233.60,0.00,0.00,0.00),('1','200','1025','257839',4906241,'3037','468',107729.43,107729.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257839',4906242,'3038','468',107646.88,107646.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257839',4906243,'3039','468',229808.37,230788.47,0.00,0.00,980.10,764478.00,0.00,0.00,0.00),('1','200','1025','257839',4906244,'3040','468',232041.03,232890.08,0.00,0.00,849.05,662259.00,0.00,0.00,0.00),('1','200','1025','257839',4906245,'3041','468',181283.03,182026.57,0.00,0.00,743.54,550219.60,0.00,0.00,0.00),('1','200','1025','257839',4906246,'3042','468',210219.47,210994.35,0.00,0.00,774.88,573513.60,0.00,0.00,0.00),('1','200','1025','257839',4906247,'3043','468',215949.67,216812.25,0.00,0.00,862.58,638309.20,0.00,0.00,0.00),('1','200','1025','257839',4906248,'3044','468',201845.07,202749.57,0.00,0.00,904.50,669330.00,0.00,0.00,0.00),('1','200','1025','257840',4906249,'3037','468',107729.43,108489.88,0.00,0.00,760.45,593151.00,0.00,0.00,0.00),('1','200','1025','257840',4906250,'3038','468',107646.88,108593.95,0.00,0.00,947.07,738714.60,0.00,0.00,0.00),('1','200','1025','257840',4906251,'3039','468',230788.47,230788.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257840',4906252,'3040','468',232890.08,232890.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257840',4906253,'3041','468',182026.57,182502.07,0.00,0.00,475.50,351870.00,0.00,0.00,0.00),('1','200','1025','257840',4906254,'3042','468',210994.35,211584.20,0.00,0.00,589.85,436489.00,0.00,0.00,0.00),('1','200','1025','257840',4906255,'3043','468',216812.25,217544.75,0.00,0.00,732.50,542050.00,0.00,0.00,0.00),('1','200','1025','257840',4906256,'3044','468',202749.57,203445.07,0.00,0.00,695.50,514670.00,0.00,0.00,0.00),('1','200','1025','257841',4906257,'3037','468',108489.88,109574.92,0.00,0.00,1085.04,846331.20,0.00,0.00,0.00),('1','200','1025','257841',4906258,'3038','468',108593.95,109791.72,0.00,0.00,1197.77,934260.60,0.00,0.00,0.00),('1','200','1025','257841',4906259,'3039','468',230788.47,230788.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257841',4906260,'3040','468',232890.08,232890.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257841',4906261,'3041','468',182502.07,182718.07,0.00,0.00,216.00,159840.00,0.00,0.00,0.00),('1','200','1025','257841',4906262,'3042','468',211584.20,211829.22,0.00,0.00,245.02,181314.80,0.00,0.00,0.00),('1','200','1025','257841',4906263,'3043','468',217544.75,217804.25,0.00,0.00,259.50,192030.00,0.00,0.00,0.00),('1','200','1025','257841',4906264,'3044','468',203445.07,203811.07,0.00,0.00,366.00,270840.00,0.00,0.00,0.00),('1','200','1025','257842',4906265,'3037','468',109574.92,110930.55,0.00,0.00,1355.63,1057391.40,0.00,0.00,0.00),('1','200','1025','257842',4906266,'3038','468',109791.72,110955.42,0.00,0.00,1163.70,907686.00,0.00,0.00,0.00),('1','200','1025','257842',4906267,'3039','468',230788.47,230788.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257842',4906268,'3040','468',232890.08,232890.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257842',4906269,'3041','468',182718.07,182770.57,0.00,0.00,52.50,38850.00,0.00,0.00,0.00),('1','200','1025','257842',4906270,'3042','468',211829.22,212214.49,0.00,0.00,385.27,285099.80,0.00,0.00,0.00),('1','200','1025','257842',4906271,'3043','468',217804.25,218225.16,0.00,0.00,420.91,311473.40,0.00,0.00,0.00),('1','200','1025','257842',4906272,'3044','468',203811.07,204083.96,0.00,0.00,272.89,201938.60,0.00,0.00,0.00),('1','200','1025','257843',4906273,'3037','468',110930.55,111851.17,0.00,0.00,920.62,718083.60,0.00,0.00,0.00),('1','200','1025','257843',4906274,'3038','468',110955.42,111957.79,0.00,0.00,1002.37,781848.60,0.00,0.00,0.00),('1','200','1025','257843',4906275,'3039','468',230788.47,230788.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257843',4906276,'3040','468',232890.08,232890.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257843',4906277,'3041','468',182770.57,183129.46,0.00,0.00,358.89,265578.60,0.00,0.00,0.00),('1','200','1025','257843',4906278,'3042','468',212214.49,212743.49,0.00,0.00,529.00,391460.00,0.00,0.00,0.00),('1','200','1025','257843',4906279,'3043','468',218225.16,219109.98,0.00,0.00,884.82,654766.80,0.00,0.00,0.00),('1','200','1025','257843',4906280,'3044','468',204083.96,204653.84,0.00,0.00,569.88,421711.20,0.00,0.00,0.00),('1','200','1025','257844',4906281,'3037','468',111851.17,112873.09,0.00,0.00,1021.92,797097.60,0.00,0.00,0.00),('1','200','1025','257844',4906282,'3038','468',111957.79,112897.33,0.00,0.00,939.54,732841.20,0.00,0.00,0.00),('1','200','1025','257844',4906283,'3039','468',230788.47,230788.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257844',4906284,'3040','468',232890.08,232890.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257844',4906285,'3041','468',183129.46,183782.85,0.00,0.00,653.39,483508.60,0.00,0.00,0.00),('1','200','1025','257844',4906286,'3042','468',212743.49,213531.24,0.00,0.00,787.75,582935.00,0.00,0.00,0.00),('1','200','1025','257844',4906287,'3043','468',219109.98,220091.99,0.00,0.00,982.01,726687.40,0.00,0.00,0.00),('1','200','1025','257844',4906288,'3044','468',204653.84,205507.34,0.00,0.00,853.50,631590.00,0.00,0.00,0.00),('1','200','1025','257845',4906289,'3037','468',112873.09,112873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257845',4906290,'3038','468',112897.33,112897.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257845',4906291,'3039','468',230788.47,231776.67,0.00,0.00,988.20,770796.00,0.00,0.00,0.00),('1','200','1025','257845',4906292,'3040','468',232890.08,233850.93,0.00,0.00,960.85,749463.00,0.00,0.00,0.00),('1','200','1025','257845',4906293,'3041','468',183782.85,184362.08,0.00,0.00,579.23,428630.20,0.00,0.00,0.00),('1','200','1025','257845',4906294,'3042','468',213531.24,214387.59,0.00,0.00,856.35,633699.00,0.00,0.00,0.00),('1','200','1025','257845',4906295,'3043','468',220091.99,220682.49,0.00,0.00,590.50,436970.00,0.00,0.00,0.00),('1','200','1025','257845',4906296,'3044','468',205507.34,206145.49,0.00,0.00,638.15,472231.00,0.00,0.00,0.00),('1','200','1025','257846',4906297,'3037','468',112873.09,112873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257846',4906298,'3038','468',112897.33,112897.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257846',4906299,'3039','468',231776.67,231776.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257846',4906300,'3040','468',233850.93,233850.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257846',4906301,'3041','468',184362.08,184362.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257846',4906302,'3042','468',214387.59,214387.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257846',4906303,'3043','468',220682.49,220682.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257846',4906304,'3044','468',206145.49,206145.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257847',4906305,'3037','468',112873.09,112873.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257847',4906306,'3038','468',112897.33,112897.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257847',4906307,'3039','468',231776.67,232757.66,0.00,0.00,980.99,765172.20,0.00,0.00,0.00),('1','200','1025','257847',4906308,'3040','468',233850.93,234907.51,0.00,0.00,1056.58,824132.40,0.00,0.00,0.00),('1','200','1025','257847',4906309,'3041','468',184362.08,184798.90,0.00,0.00,436.82,323246.80,0.00,0.00,0.00),('1','200','1025','257847',4906310,'3042','468',214387.59,214816.43,0.00,0.00,428.84,317341.60,0.00,0.00,0.00),('1','200','1025','257847',4906311,'3043','468',220682.49,221231.97,0.00,0.00,549.48,406615.20,0.00,0.00,0.00),('1','200','1025','257847',4906312,'3044','468',206145.49,206667.57,0.00,0.00,522.08,386339.20,0.00,0.00,0.00),('1','200','1025','257848',4906313,'3037','468',112873.09,114053.07,0.00,0.00,1179.98,920384.40,0.00,0.00,0.00),('1','200','1025','257848',4906314,'3038','468',112897.33,113947.40,0.00,0.00,1050.07,819054.60,0.00,0.00,0.00),('1','200','1025','257848',4906315,'3039','468',232757.66,232757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257848',4906316,'3040','468',234907.51,234907.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257848',4906317,'3041','468',184798.90,185612.60,0.00,0.00,813.70,602138.00,0.00,0.00,0.00),('1','200','1025','257848',4906318,'3042','468',214816.43,215937.91,0.00,0.00,1121.48,829895.20,0.00,0.00,0.00),('1','200','1025','257848',4906319,'3043','468',221231.97,222215.37,0.00,0.00,983.40,727716.00,0.00,0.00,0.00),('1','200','1025','257848',4906320,'3044','468',206667.57,207485.58,0.00,0.00,818.01,605327.40,0.00,0.00,0.00),('1','200','1025','257849',4906321,'3037','468',114053.07,115098.75,0.00,0.00,1045.68,815630.40,0.00,0.00,0.00),('1','200','1025','257849',4906322,'3038','468',113947.40,115176.61,0.00,0.00,1229.21,958783.80,0.00,0.00,0.00),('1','200','1025','257849',4906323,'3039','468',232757.66,232757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257849',4906324,'3040','468',234907.51,234907.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257849',4906325,'3041','468',185612.60,185837.60,0.00,0.00,225.00,166500.00,0.00,0.00,0.00),('1','200','1025','257849',4906326,'3042','468',215937.91,216256.41,0.00,0.00,318.50,235690.00,0.00,0.00,0.00),('1','200','1025','257849',4906327,'3043','468',222215.37,222554.87,0.00,0.00,339.50,251230.00,0.00,0.00,0.00),('1','200','1025','257849',4906328,'3044','468',207485.58,207780.08,0.00,0.00,294.50,217930.00,0.00,0.00,0.00),('1','200','1025','257850',4906329,'3037','468',115098.75,116391.78,0.00,0.00,1293.03,1008563.40,0.00,0.00,0.00),('1','200','1025','257850',4906330,'3038','468',115176.61,116376.74,0.00,0.00,1200.13,936101.40,0.00,0.00,0.00),('1','200','1025','257850',4906331,'3039','468',232757.66,232757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257850',4906332,'3040','468',234907.51,234907.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257850',4906333,'3041','468',185837.60,186238.60,0.00,0.00,401.00,296740.00,0.00,0.00,0.00),('1','200','1025','257850',4906334,'3042','468',216256.41,216668.91,0.00,0.00,412.50,305250.00,0.00,0.00,0.00),('1','200','1025','257850',4906335,'3043','468',222554.87,223068.27,0.00,0.00,513.40,379916.00,0.00,0.00,0.00),('1','200','1025','257850',4906336,'3044','468',207780.08,208234.26,0.00,0.00,454.18,336093.20,0.00,0.00,0.00),('1','200','1025','257851',4906337,'3037','468',116391.78,117347.37,0.00,0.00,955.59,745360.20,0.00,0.00,0.00),('1','200','1025','257851',4906338,'3038','468',116376.74,117430.22,0.00,0.00,1053.48,821714.40,0.00,0.00,0.00),('1','200','1025','257851',4906339,'3039','468',232757.66,232757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257851',4906340,'3040','468',234907.51,234907.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257851',4906341,'3041','468',186238.60,186843.10,0.00,0.00,604.50,447330.00,0.00,0.00,0.00),('1','200','1025','257851',4906342,'3042','468',216668.91,217211.47,0.00,0.00,542.56,401494.40,0.00,0.00,0.00),('1','200','1025','257851',4906343,'3043','468',223068.27,223821.43,0.00,0.00,753.16,557338.40,0.00,0.00,0.00),('1','200','1025','257851',4906344,'3044','468',208234.26,208966.26,0.00,0.00,732.00,541680.00,0.00,0.00,0.00),('1','200','1025','257852',4906345,'3037','468',117347.37,118310.50,0.00,0.00,963.13,751241.40,0.00,0.00,0.00),('1','200','1025','257852',4906346,'3038','468',117430.22,118281.46,0.00,0.00,851.24,663967.20,0.00,0.00,0.00),('1','200','1025','257852',4906347,'3039','468',232757.66,232757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257852',4906348,'3040','468',234907.51,234907.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257852',4906349,'3041','468',186843.10,187185.79,0.00,0.00,342.69,253590.60,0.00,0.00,0.00),('1','200','1025','257852',4906350,'3042','468',217211.47,217916.97,0.00,0.00,705.50,522070.00,0.00,0.00,0.00),('1','200','1025','257852',4906351,'3043','468',223821.43,224569.93,0.00,0.00,748.50,553890.00,0.00,0.00,0.00),('1','200','1025','257852',4906352,'3044','468',208966.26,209546.76,0.00,0.00,580.50,429570.00,0.00,0.00,0.00),('1','200','1025','257853',4906353,'3037','468',118310.50,119490.77,0.00,0.00,1180.27,920610.60,0.00,0.00,0.00),('1','200','1025','257853',4906354,'3038','468',118281.46,119257.82,0.00,0.00,976.36,761560.80,0.00,0.00,0.00),('1','200','1025','257853',4906355,'3039','468',232757.66,232757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257853',4906356,'3040','468',234907.51,234907.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257853',4906357,'3041','468',187185.79,187584.79,0.00,0.00,399.00,295260.00,0.00,0.00,0.00),('1','200','1025','257853',4906358,'3042','468',217916.97,218428.47,0.00,0.00,511.50,378510.00,0.00,0.00,0.00),('1','200','1025','257853',4906359,'3043','468',224569.93,225231.93,0.00,0.00,662.00,489880.00,0.00,0.00,0.00),('1','200','1025','257853',4906360,'3044','468',209546.76,210141.15,0.00,0.00,594.39,439848.60,0.00,0.00,0.00),('1','200','1025','257854',4906361,'3037','468',119490.77,120494.12,0.00,0.00,1003.35,782613.00,0.00,0.00,0.00),('1','200','1025','257854',4906362,'3038','468',119257.82,120288.07,0.00,0.00,1030.25,803595.00,0.00,0.00,0.00),('1','200','1025','257854',4906363,'3039','468',232757.66,232757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257854',4906364,'3040','468',234907.51,234907.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257854',4906365,'3041','468',187584.79,188153.90,0.00,0.00,569.11,421141.40,0.00,0.00,0.00),('1','200','1025','257854',4906366,'3042','468',218428.47,219176.85,0.00,0.00,748.38,553801.20,0.00,0.00,0.00),('1','200','1025','257854',4906367,'3043','468',225231.93,225819.93,0.00,0.00,588.00,435120.00,0.00,0.00,0.00),('1','200','1025','257854',4906368,'3044','468',210141.15,210558.15,0.00,0.00,417.00,308580.00,0.00,0.00,0.00),('1','200','1025','257855',4906369,'3037','468',120494.12,120494.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257855',4906370,'3038','468',120288.07,120288.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257855',4906371,'3039','468',232757.66,233842.14,0.00,0.00,1084.48,845894.40,0.00,0.00,0.00),('1','200','1025','257855',4906372,'3040','468',234907.51,236001.23,0.00,0.00,1093.72,853101.60,0.00,0.00,0.00),('1','200','1025','257855',4906373,'3041','468',188153.90,188689.13,0.00,0.00,535.23,396070.20,0.00,0.00,0.00),('1','200','1025','257855',4906374,'3042','468',219176.85,220152.76,0.00,0.00,975.91,722173.40,0.00,0.00,0.00),('1','200','1025','257855',4906375,'3043','468',225819.93,226678.81,0.00,0.00,858.88,635571.20,0.00,0.00,0.00),('1','200','1025','257855',4906376,'3044','468',210558.15,211234.65,0.00,0.00,676.50,500610.00,0.00,0.00,0.00),('1','200','1025','257856',4906377,'3037','468',120494.12,120494.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257856',4906378,'3038','468',120288.07,120288.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257856',4906379,'3039','468',233842.14,235227.40,0.00,0.00,1385.26,1080502.80,0.00,0.00,0.00),('1','200','1025','257856',4906380,'3040','468',236001.23,237496.71,0.00,0.00,1495.48,1166474.40,0.00,0.00,0.00),('1','200','1025','257856',4906381,'3041','468',188689.13,189565.77,0.00,0.00,876.64,648713.60,0.00,0.00,0.00),('1','200','1025','257856',4906382,'3042','468',220152.76,221032.52,0.00,0.00,879.76,651022.40,0.00,0.00,0.00),('1','200','1025','257856',4906383,'3043','468',226678.81,227724.90,0.00,0.00,1046.09,774106.60,0.00,0.00,0.00),('1','200','1025','257856',4906384,'3044','468',211234.65,212331.15,0.00,0.00,1096.50,811410.00,0.00,0.00,0.00),('1','200','1025','257857',4906385,'3037','468',120494.12,120494.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257857',4906386,'3038','468',120288.07,120288.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257857',4906387,'3039','468',235227.40,235812.80,0.00,0.00,585.40,456612.00,0.00,0.00,0.00),('1','200','1025','257857',4906388,'3040','468',237496.71,238087.94,0.00,0.00,591.23,461159.40,0.00,0.00,0.00),('1','200','1025','257857',4906389,'3041','468',189565.77,189763.52,0.00,0.00,197.75,146335.00,0.00,0.00,0.00),('1','200','1025','257857',4906390,'3042','468',221032.52,221226.52,0.00,0.00,194.00,143560.00,0.00,0.00,0.00),('1','200','1025','257857',4906391,'3043','468',227724.90,227849.90,0.00,0.00,125.00,92500.00,0.00,0.00,0.00),('1','200','1025','257857',4906392,'3044','468',212331.15,212496.15,0.00,0.00,165.00,122100.00,0.00,0.00,0.00),('1','200','1025','257858',4906393,'3037','468',120494.12,120494.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257858',4906394,'3038','468',120288.07,120288.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257858',4906395,'3039','468',235812.80,235812.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257858',4906396,'3040','468',238087.94,238087.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257858',4906397,'3041','468',189763.52,189763.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257858',4906398,'3042','468',221226.52,221226.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257858',4906399,'3043','468',227849.90,227849.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257858',4906400,'3044','468',212496.15,212496.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257859',4906401,'3037','468',120494.12,120494.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257859',4906402,'3038','468',120288.07,120288.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257859',4906403,'3039','468',235812.80,236238.88,0.00,0.00,426.08,332342.40,0.00,0.00,0.00),('1','200','1025','257859',4906404,'3040','468',238087.94,238536.64,0.00,0.00,448.70,349986.00,0.00,0.00,0.00),('1','200','1025','257859',4906405,'3041','468',189763.52,189960.02,0.00,0.00,196.50,145410.00,0.00,0.00,0.00),('1','200','1025','257859',4906406,'3042','468',221226.52,221545.38,0.00,0.00,318.86,235956.40,0.00,0.00,0.00),('1','200','1025','257859',4906407,'3043','468',227849.90,228050.90,0.00,0.00,201.00,148740.00,0.00,0.00,0.00),('1','200','1025','257859',4906408,'3044','468',212496.15,212641.65,0.00,0.00,145.50,107670.00,0.00,0.00,0.00),('1','200','1025','257860',4906409,'3037','468',120494.12,120494.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257860',4906410,'3038','468',120288.07,120288.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257860',4906411,'3039','468',236238.88,237455.88,0.00,0.00,1217.00,949260.00,0.00,0.00,0.00),('1','200','1025','257860',4906412,'3040','468',238536.64,239702.60,0.00,0.00,1165.96,909448.80,0.00,0.00,0.00),('1','200','1025','257860',4906413,'3041','468',189960.02,190651.80,0.00,0.00,691.78,511994.00,0.00,0.00,0.00),('1','200','1025','257860',4906414,'3042','468',221545.38,222452.02,0.00,0.00,906.64,670913.60,0.00,0.00,0.00),('1','200','1025','257860',4906415,'3043','468',228050.90,229215.40,0.00,0.00,1164.50,861730.00,0.00,0.00,0.00),('1','200','1025','257860',4906416,'3044','468',212641.65,213533.65,0.00,0.00,892.00,660080.00,0.00,0.00,0.00),('1','200','1025','257861',4906417,'3037','468',120494.12,120494.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257861',4906418,'3038','468',120288.07,120288.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257861',4906419,'3039','468',237455.88,238674.40,0.00,0.00,1218.52,950445.60,0.00,0.00,0.00),('1','200','1025','257861',4906420,'3040','468',239702.60,241070.83,0.00,0.00,1368.23,1067219.40,0.00,0.00,0.00),('1','200','1025','257861',4906421,'3041','468',190651.80,191102.30,0.00,0.00,450.50,333370.00,0.00,0.00,0.00),('1','200','1025','257861',4906422,'3042','468',222452.02,222976.02,0.00,0.00,524.00,387760.00,0.00,0.00,0.00),('1','200','1025','257861',4906423,'3043','468',229215.40,229817.90,0.00,0.00,602.50,445850.00,0.00,0.00,0.00),('1','200','1025','257861',4906424,'3044','468',213533.65,214209.14,0.00,0.00,675.49,499862.60,0.00,0.00,0.00),('1','200','1025','257862',4906425,'3037','468',120494.12,121783.47,0.00,0.00,1289.35,1005693.00,0.00,0.00,0.00),('1','200','1025','257862',4906426,'3038','468',120288.07,121553.88,0.00,0.00,1265.81,987331.80,0.00,0.00,0.00),('1','200','1025','257862',4906427,'3039','468',238674.40,238674.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257862',4906428,'3040','468',241070.83,241070.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257862',4906429,'3041','468',191102.30,191436.99,0.00,0.00,334.69,247670.60,0.00,0.00,0.00),('1','200','1025','257862',4906430,'3042','468',222976.02,223496.54,0.00,0.00,520.52,385184.80,0.00,0.00,0.00),('1','200','1025','257862',4906431,'3043','468',229817.90,230582.82,0.00,0.00,764.92,566040.80,0.00,0.00,0.00),('1','200','1025','257862',4906432,'3044','468',214209.14,215061.27,0.00,0.00,852.13,630576.20,0.00,0.00,0.00),('1','200','1025','257863',4906433,'3037','468',121783.47,121783.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257863',4906434,'3038','468',121553.88,121553.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257863',4906435,'3039','468',238674.40,240375.50,0.00,0.00,1701.10,1326858.00,0.00,0.00,0.00),('1','200','1025','257863',4906436,'3040','468',241070.83,242677.96,0.00,0.00,1607.13,1253561.40,0.00,0.00,0.00),('1','200','1025','257863',4906437,'3041','468',191436.99,192008.66,0.00,0.00,571.67,423035.80,0.00,0.00,0.00),('1','200','1025','257863',4906438,'3042','468',223496.54,224220.60,0.00,0.00,724.06,535804.40,0.00,0.00,0.00),('1','200','1025','257863',4906439,'3043','468',230582.82,231566.17,0.00,0.00,983.35,727679.00,0.00,0.00,0.00),('1','200','1025','257863',4906440,'3044','468',215061.27,215972.77,0.00,0.00,911.50,674510.00,0.00,0.00,0.00),('1','200','1025','257864',4906441,'3037','468',121783.47,123183.93,0.00,0.00,1400.46,1092358.80,0.00,0.00,0.00),('1','200','1025','257864',4906442,'3038','468',121553.88,122919.62,0.00,0.00,1365.74,1065277.20,0.00,0.00,0.00),('1','200','1025','257864',4906443,'3039','468',240375.50,240375.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257864',4906444,'3040','468',242677.96,242677.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257864',4906445,'3041','468',192008.66,192455.16,0.00,0.00,446.50,330410.00,0.00,0.00,0.00),('1','200','1025','257864',4906446,'3042','468',224220.60,224888.92,0.00,0.00,668.32,494556.80,0.00,0.00,0.00),('1','200','1025','257864',4906447,'3043','468',231566.17,232383.89,0.00,0.00,817.72,605112.80,0.00,0.00,0.00),('1','200','1025','257864',4906448,'3044','468',215972.77,216792.30,0.00,0.00,819.53,606452.20,0.00,0.00,0.00),('1','200','1025','257865',4906449,'3037','468',123183.93,124654.94,0.00,0.00,1471.01,1147387.80,0.00,0.00,0.00),('1','200','1025','257865',4906450,'3038','468',122919.62,124475.97,0.00,0.00,1556.35,1213953.00,0.00,0.00,0.00),('1','200','1025','257865',4906451,'3039','468',240375.50,240375.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257865',4906452,'3040','468',242677.96,242677.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257865',4906453,'3041','468',192455.16,193037.49,0.00,0.00,582.33,430924.20,0.00,0.00,0.00),('1','200','1025','257865',4906454,'3042','468',224888.92,225584.33,0.00,0.00,695.41,514603.40,0.00,0.00,0.00),('1','200','1025','257865',4906455,'3043','468',232383.89,233217.19,0.00,0.00,833.30,616642.00,0.00,0.00,0.00),('1','200','1025','257865',4906456,'3044','468',216792.30,217710.80,0.00,0.00,918.50,679690.00,0.00,0.00,0.00),('1','200','1025','257866',4906457,'3037','468',124654.94,125964.76,0.00,0.00,1309.82,1021659.60,0.00,0.00,0.00),('1','200','1025','257866',4906458,'3038','468',124475.97,125841.67,0.00,0.00,1365.70,1065246.00,0.00,0.00,0.00),('1','200','1025','257866',4906459,'3039','468',240375.50,240375.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257866',4906460,'3040','468',242677.96,242677.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257866',4906461,'3041','468',193037.49,193457.91,0.00,0.00,420.42,311110.80,0.00,0.00,0.00),('1','200','1025','257866',4906462,'3042','468',225584.33,225987.83,0.00,0.00,403.50,298590.00,0.00,0.00,0.00),('1','200','1025','257866',4906463,'3043','468',233217.19,233899.19,0.00,0.00,682.00,504680.00,0.00,0.00,0.00),('1','200','1025','257866',4906464,'3044','468',217710.80,218334.63,0.00,0.00,623.83,461634.20,0.00,0.00,0.00),('1','200','1025','257867',4906465,'3037','468',125964.76,127035.63,0.00,0.00,1070.87,835278.60,0.00,0.00,0.00),('1','200','1025','257867',4906466,'3038','468',125841.67,126924.94,0.00,0.00,1083.27,844950.60,0.00,0.00,0.00),('1','200','1025','257867',4906467,'3039','468',240375.50,240375.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257867',4906468,'3040','468',242677.96,242677.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257867',4906469,'3041','468',193457.91,194190.91,0.00,0.00,733.00,542420.00,0.00,0.00,0.00),('1','200','1025','257867',4906470,'3042','468',225987.83,226716.83,0.00,0.00,729.00,539460.00,0.00,0.00,0.00),('1','200','1025','257867',4906471,'3043','468',233899.19,234500.58,0.00,0.00,601.39,445028.60,0.00,0.00,0.00),('1','200','1025','257867',4906472,'3044','468',218334.63,218930.38,0.00,0.00,595.75,440855.00,0.00,0.00,0.00),('1','200','1025','257868',4906473,'3037','468',127035.63,128140.38,0.00,0.00,1104.75,861705.00,0.00,0.00,0.00),('1','200','1025','257868',4906474,'3038','468',126924.94,127999.54,0.00,0.00,1074.60,838188.00,0.00,0.00,0.00),('1','200','1025','257868',4906475,'3039','468',240375.50,240375.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257868',4906476,'3040','468',242677.96,242677.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257868',4906477,'3041','468',194190.91,194504.23,0.00,0.00,313.32,231856.80,0.00,0.00,0.00),('1','200','1025','257868',4906478,'3042','468',226716.83,227181.83,0.00,0.00,465.00,344100.00,0.00,0.00,0.00),('1','200','1025','257868',4906479,'3043','468',234500.58,235311.09,0.00,0.00,810.51,599777.40,0.00,0.00,0.00),('1','200','1025','257868',4906480,'3044','468',218930.38,219877.38,0.00,0.00,947.00,700780.00,0.00,0.00,0.00),('1','200','1025','257869',4906481,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257869',4906482,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257869',4906483,'3039','468',240375.50,241729.73,0.00,0.00,1354.23,1056299.40,0.00,0.00,0.00),('1','200','1025','257869',4906484,'3040','468',242677.96,244021.99,0.00,0.00,1344.03,1048343.40,0.00,0.00,0.00),('1','200','1025','257869',4906485,'3041','468',194504.23,195009.73,0.00,0.00,505.50,374070.00,0.00,0.00,0.00),('1','200','1025','257869',4906486,'3042','468',227181.83,227930.15,0.00,0.00,748.32,553756.80,0.00,0.00,0.00),('1','200','1025','257869',4906487,'3043','468',235311.09,236212.85,0.00,0.00,901.76,667302.40,0.00,0.00,0.00),('1','200','1025','257869',4906488,'3044','468',219877.38,220821.18,0.00,0.00,943.80,698555.60,0.00,0.00,0.00),('1','200','1025','257870',4906489,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257870',4906490,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257870',4906491,'3039','468',241729.73,242722.18,0.00,0.00,992.45,774111.00,0.00,0.00,0.00),('1','200','1025','257870',4906492,'3040','468',244021.99,244963.42,0.00,0.00,941.43,734315.40,0.00,0.00,0.00),('1','200','1025','257870',4906493,'3041','468',195009.73,195752.20,0.00,0.00,742.47,549427.80,0.00,0.00,0.00),('1','200','1025','257870',4906494,'3042','468',227930.15,228636.61,0.00,0.00,706.46,522780.40,0.00,0.00,0.00),('1','200','1025','257870',4906495,'3043','468',236212.85,237155.28,0.00,0.00,942.43,697398.20,0.00,0.00,0.00),('1','200','1025','257870',4906496,'3044','468',220821.18,221647.48,0.00,0.00,826.30,611462.00,0.00,0.00,0.00),('1','200','1025','257871',4906497,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257871',4906498,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257871',4906499,'3039','468',242722.18,242722.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257871',4906500,'3040','468',244963.42,244963.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257871',4906501,'3041','468',195752.20,195752.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257871',4906502,'3042','468',228636.61,228636.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257871',4906503,'3043','468',237155.28,237155.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257871',4906504,'3044','468',221647.48,221647.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257872',4906505,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257872',4906506,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257872',4906507,'3039','468',242722.18,243794.32,0.00,0.00,1072.14,836269.20,0.00,0.00,0.00),('1','200','1025','257872',4906508,'3040','468',244963.42,246188.70,0.00,0.00,1225.28,955718.40,0.00,0.00,0.00),('1','200','1025','257872',4906509,'3041','468',195752.20,196008.85,0.00,0.00,256.65,189921.00,0.00,0.00,0.00),('1','200','1025','257872',4906510,'3042','468',228636.61,229070.48,0.00,0.00,433.87,321063.80,0.00,0.00,0.00),('1','200','1025','257872',4906511,'3043','468',237155.28,237952.53,0.00,0.00,797.25,589965.00,0.00,0.00,0.00),('1','200','1025','257872',4906512,'3044','468',221647.48,222279.88,0.00,0.00,632.40,467976.00,0.00,0.00,0.00),('1','200','1025','257873',4906513,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257873',4906514,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257873',4906515,'3039','468',243794.32,244865.56,0.00,0.00,1071.24,835567.20,0.00,0.00,0.00),('1','200','1025','257873',4906516,'3040','468',246188.70,247370.34,0.00,0.00,1181.64,921679.20,0.00,0.00,0.00),('1','200','1025','257873',4906517,'3041','468',196008.85,196489.20,0.00,0.00,480.35,355459.00,0.00,0.00,0.00),('1','200','1025','257873',4906518,'3042','468',229070.48,229598.48,0.00,0.00,528.00,390720.00,0.00,0.00,0.00),('1','200','1025','257873',4906519,'3043','468',237952.53,238605.53,0.00,0.00,653.00,483220.00,0.00,0.00,0.00),('1','200','1025','257873',4906520,'3044','468',222279.88,222881.88,0.00,0.00,602.00,445480.00,0.00,0.00,0.00),('1','200','1025','257874',4906521,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257874',4906522,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257874',4906523,'3039','468',244865.56,245892.41,0.00,0.00,1026.85,800943.00,0.00,0.00,0.00),('1','200','1025','257874',4906524,'3040','468',247370.34,248571.02,0.00,0.00,1200.68,936530.40,0.00,0.00,0.00),('1','200','1025','257874',4906525,'3041','468',196489.20,196837.83,0.00,0.00,348.63,257986.20,0.00,0.00,0.00),('1','200','1025','257874',4906526,'3042','468',229598.48,230229.57,0.00,0.00,631.09,467006.60,0.00,0.00,0.00),('1','200','1025','257874',4906527,'3043','468',238605.53,239382.26,0.00,0.00,776.73,574780.20,0.00,0.00,0.00),('1','200','1025','257874',4906528,'3044','468',222881.88,223569.38,0.00,0.00,687.50,508750.00,0.00,0.00,0.00),('1','200','1025','257875',4906529,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257875',4906530,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257875',4906531,'3039','468',245892.41,246912.20,0.00,0.00,1019.79,795436.20,0.00,0.00,0.00),('1','200','1025','257875',4906532,'3040','468',248571.02,249918.04,0.00,0.00,1347.02,1050675.60,0.00,0.00,0.00),('1','200','1025','257875',4906533,'3041','468',196837.83,197179.83,0.00,0.00,342.00,253080.00,0.00,0.00,0.00),('1','200','1025','257875',4906534,'3042','468',230229.57,230744.57,0.00,0.00,515.00,381100.00,0.00,0.00,0.00),('1','200','1025','257875',4906535,'3043','468',239382.26,239994.28,0.00,0.00,612.02,452894.80,0.00,0.00,0.00),('1','200','1025','257875',4906536,'3044','468',223569.38,224096.88,0.00,0.00,527.50,390350.00,0.00,0.00,0.00),('1','200','1025','257876',4906537,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257876',4906538,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257876',4906539,'3039','468',246912.20,247993.83,0.00,0.00,1081.63,843671.40,0.00,0.00,0.00),('1','200','1025','257876',4906540,'3040','468',249918.04,251089.61,0.00,0.00,1171.57,913824.60,0.00,0.00,0.00),('1','200','1025','257876',4906541,'3041','468',197179.83,197750.78,0.00,0.00,570.95,422503.00,0.00,0.00,0.00),('1','200','1025','257876',4906542,'3042','468',230744.57,231230.11,0.00,0.00,485.54,359299.60,0.00,0.00,0.00),('1','200','1025','257876',4906543,'3043','468',239994.28,240405.74,0.00,0.00,411.46,304480.40,0.00,0.00,0.00),('1','200','1025','257876',4906544,'3044','468',224096.88,224391.88,0.00,0.00,295.00,218300.00,0.00,0.00,0.00),('1','200','1025','257877',4906545,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257877',4906546,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257877',4906547,'3039','468',247993.83,248970.70,0.00,0.00,976.87,761958.60,0.00,0.00,0.00),('1','200','1025','257877',4906548,'3040','468',251089.61,252303.44,0.00,0.00,1213.83,944787.40,0.00,0.00,0.00),('1','200','1025','257877',4906549,'3041','468',197750.78,198321.93,0.00,0.00,571.15,422651.00,0.00,0.00,0.00),('1','200','1025','257877',4906550,'3042','468',231230.11,232013.46,0.00,0.00,783.35,579679.00,0.00,0.00,0.00),('1','200','1025','257877',4906551,'3043','468',240405.74,241238.74,0.00,0.00,833.00,616420.00,0.00,0.00,0.00),('1','200','1025','257877',4906552,'3044','468',224391.88,225298.68,0.00,0.00,906.80,671032.00,0.00,0.00,0.00),('1','200','1025','257878',4906553,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257878',4906554,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257878',4906555,'3039','468',248970.70,249871.62,0.00,0.00,900.92,702717.60,0.00,0.00,0.00),('1','200','1025','257878',4906556,'3040','468',252303.44,253388.37,0.00,0.00,1084.93,846245.40,0.00,0.00,0.00),('1','200','1025','257878',4906557,'3041','468',198321.93,199048.74,0.00,0.00,726.81,537839.40,0.00,0.00,0.00),('1','200','1025','257878',4906558,'3042','468',232013.46,232711.64,0.00,0.00,698.18,516653.20,0.00,0.00,0.00),('1','200','1025','257878',4906559,'3043','468',241238.74,241716.80,0.00,0.00,478.06,353764.40,0.00,0.00,0.00),('1','200','1025','257878',4906560,'3044','468',225298.68,226174.69,0.00,0.00,876.01,648247.40,0.00,0.00,0.00),('1','200','1025','257879',4906561,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257879',4906562,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257879',4906563,'3039','468',249871.62,251040.82,0.00,0.00,1169.20,911976.00,0.00,0.00,0.00),('1','200','1025','257879',4906564,'3040','468',253388.37,254423.62,0.00,0.00,1035.25,807495.00,0.00,0.00,0.00),('1','200','1025','257879',4906565,'3041','468',199048.74,199407.60,0.00,0.00,358.86,265556.40,0.00,0.00,0.00),('1','200','1025','257879',4906566,'3042','468',232711.64,233427.84,0.00,0.00,716.20,529988.00,0.00,0.00,0.00),('1','200','1025','257879',4906567,'3043','468',241716.80,242359.58,0.00,0.00,642.78,475657.20,0.00,0.00,0.00),('1','200','1025','257879',4906568,'3044','468',226174.69,226906.51,0.00,0.00,731.82,541546.80,0.00,0.00,0.00),('1','200','1025','257880',4906569,'3037','468',128140.38,128140.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257880',4906570,'3038','468',127999.54,127999.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257880',4906571,'3039','468',251040.82,252063.22,0.00,0.00,1022.40,797472.00,0.00,0.00,0.00),('1','200','1025','257880',4906572,'3040','468',254423.62,255620.34,0.00,0.00,1196.72,933441.60,0.00,0.00,0.00),('1','200','1025','257880',4906573,'3041','468',199407.60,199806.73,0.00,0.00,399.13,295356.20,0.00,0.00,0.00),('1','200','1025','257880',4906574,'3042','468',233427.84,233812.54,0.00,0.00,384.70,284678.00,0.00,0.00,0.00),('1','200','1025','257880',4906575,'3043','468',242359.58,242995.12,0.00,0.00,635.54,470299.60,0.00,0.00,0.00),('1','200','1025','257880',4906576,'3044','468',226906.51,227554.51,0.00,0.00,648.00,479520.00,0.00,0.00,0.00),('1','200','1025','257881',4906577,'3037','468',128140.38,128981.70,0.00,0.00,841.32,656229.60,0.00,0.00,0.00),('1','200','1025','257881',4906578,'3038','468',127999.54,128821.00,0.00,0.00,821.46,640738.80,0.00,0.00,0.00),('1','200','1025','257881',4906579,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257881',4906580,'3040','468',255620.34,255620.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257881',4906581,'3041','468',199806.73,200013.73,0.00,0.00,207.00,153180.00,0.00,0.00,0.00),('1','200','1025','257881',4906582,'3042','468',233812.54,234179.04,0.00,0.00,366.50,271210.00,0.00,0.00,0.00),('1','200','1025','257881',4906583,'3043','468',242995.12,243778.62,0.00,0.00,783.50,579790.00,0.00,0.00,0.00),('1','200','1025','257881',4906584,'3044','468',227554.51,227974.21,0.00,0.00,419.70,310578.00,0.00,0.00,0.00),('1','200','1025','257882',4906585,'3037','468',128981.70,129868.99,0.00,0.00,887.29,692086.20,0.00,0.00,0.00),('1','200','1025','257882',4906586,'3038','468',128821.00,129984.84,0.00,0.00,1163.84,907795.20,0.00,0.00,0.00),('1','200','1025','257882',4906587,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257882',4906588,'3040','468',255620.34,255620.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257882',4906589,'3041','468',200013.73,200743.73,0.00,0.00,730.00,540200.00,0.00,0.00,0.00),('1','200','1025','257882',4906590,'3042','468',234179.04,234870.32,0.00,0.00,691.28,511547.20,0.00,0.00,0.00),('1','200','1025','257882',4906591,'3043','468',243778.62,244607.70,0.00,0.00,829.08,613519.20,0.00,0.00,0.00),('1','200','1025','257882',4906592,'3044','468',227974.21,228703.40,0.00,0.00,729.19,539600.60,0.00,0.00,0.00),('1','200','1025','257883',4906593,'3037','468',129868.99,130746.64,0.00,0.00,877.65,684567.00,0.00,0.00,0.00),('1','200','1025','257883',4906594,'3038','468',129984.84,130929.41,0.00,0.00,944.57,736764.60,0.00,0.00,0.00),('1','200','1025','257883',4906595,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257883',4906596,'3040','468',255620.34,255620.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257883',4906597,'3041','468',200743.73,201260.54,0.00,0.00,516.81,382439.40,0.00,0.00,0.00),('1','200','1025','257883',4906598,'3042','468',234870.32,235431.32,0.00,0.00,561.00,415140.00,0.00,0.00,0.00),('1','200','1025','257883',4906599,'3043','468',244607.70,245080.05,0.00,0.00,472.35,349539.00,0.00,0.00,0.00),('1','200','1025','257883',4906600,'3044','468',228703.40,229220.90,0.00,0.00,517.50,382950.00,0.00,0.00,0.00),('1','200','1025','257884',4906601,'3037','468',130746.64,131792.09,0.00,0.00,1045.45,815451.00,0.00,0.00,0.00),('1','200','1025','257884',4906602,'3038','468',130929.41,131815.48,0.00,0.00,886.07,691134.60,0.00,0.00,0.00),('1','200','1025','257884',4906603,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257884',4906604,'3040','468',255620.34,255620.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257884',4906605,'3041','468',201260.54,201985.00,0.00,0.00,724.46,536100.40,0.00,0.00,0.00),('1','200','1025','257884',4906606,'3042','468',235431.32,236131.32,0.00,0.00,700.00,518000.00,0.00,0.00,0.00),('1','200','1025','257884',4906607,'3043','468',245080.05,245706.05,0.00,0.00,626.00,463240.00,0.00,0.00,0.00),('1','200','1025','257884',4906608,'3044','468',229220.90,229730.40,0.00,0.00,509.50,377030.00,0.00,0.00,0.00),('1','200','1025','257885',4906609,'3037','468',131792.09,133102.78,0.00,0.00,1310.69,1022338.20,0.00,0.00,0.00),('1','200','1025','257885',4906610,'3038','468',131815.48,133067.77,0.00,0.00,1252.29,976786.20,0.00,0.00,0.00),('1','200','1025','257885',4906611,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257885',4906612,'3040','468',255620.34,255620.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257885',4906613,'3041','468',201985.00,202473.50,0.00,0.00,488.50,361490.00,0.00,0.00,0.00),('1','200','1025','257885',4906614,'3042','468',236131.32,236665.92,0.00,0.00,534.60,395604.00,0.00,0.00,0.00),('1','200','1025','257885',4906615,'3043','468',245706.05,246709.01,0.00,0.00,1002.96,742190.40,0.00,0.00,0.00),('1','200','1025','257885',4906616,'3044','468',229730.40,230662.10,0.00,0.00,931.70,689458.00,0.00,0.00,0.00),('1','200','1025','257886',4906617,'3037','468',133102.78,134310.94,0.00,0.00,1208.16,930283.20,0.00,0.00,0.00),('1','200','1025','257886',4906618,'3038','468',133067.77,134271.07,0.00,0.00,1203.30,926541.00,0.00,0.00,0.00),('1','200','1025','257886',4906619,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257886',4906620,'3040','468',255620.34,255620.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257886',4906621,'3041','468',202473.50,202987.40,0.00,0.00,513.90,375147.00,0.00,0.00,0.00),('1','200','1025','257886',4906622,'3042','468',236665.92,237245.91,0.00,0.00,579.99,423392.70,0.00,0.00,0.00),('1','200','1025','257886',4906623,'3043','468',246709.01,247506.91,0.00,0.00,797.90,582467.00,0.00,0.00,0.00),('1','200','1025','257886',4906624,'3044','468',230662.10,231358.71,0.00,0.00,696.61,508525.30,0.00,0.00,0.00),('1','200','1025','257887',4906625,'3037','468',134310.94,135272.51,0.00,0.00,961.57,740408.90,0.00,0.00,0.00),('1','200','1025','257887',4906626,'3038','468',134271.07,135234.02,0.00,0.00,962.95,741471.50,0.00,0.00,0.00),('1','200','1025','257887',4906627,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257887',4906628,'3040','468',255620.34,255927.63,0.00,0.00,307.29,236613.30,0.00,0.00,0.00),('1','200','1025','257887',4906629,'3041','468',202987.40,203784.26,0.00,0.00,796.86,581707.80,0.00,0.00,0.00),('1','200','1025','257887',4906630,'3042','468',237245.91,238333.63,0.00,0.00,1087.72,794035.60,0.00,0.00,0.00),('1','200','1025','257887',4906631,'3043','468',247506.91,248648.41,0.00,0.00,1141.50,833295.00,0.00,0.00,0.00),('1','200','1025','257887',4906632,'3044','468',231358.71,232331.27,0.00,0.00,972.56,709968.80,0.00,0.00,0.00),('1','200','1025','257888',4906633,'3037','468',135272.51,135272.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257888',4906634,'3038','468',135234.02,135234.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257888',4906635,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257888',4906636,'3040','468',255927.63,255927.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257888',4906637,'3041','468',203784.26,203784.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257888',4906638,'3042','468',238333.63,238333.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257888',4906639,'3043','468',248648.41,248648.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257888',4906640,'3044','468',232331.27,232331.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257889',4906641,'3037','468',135272.51,135514.86,0.00,0.00,242.35,186609.50,0.00,0.00,0.00),('1','200','1025','257889',4906642,'3038','468',135234.02,135431.07,0.00,0.00,197.05,151728.50,0.00,0.00,0.00),('1','200','1025','257889',4906643,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257889',4906644,'3040','468',255927.63,256131.97,0.00,0.00,204.34,157341.80,0.00,0.00,0.00),('1','200','1025','257889',4906645,'3041','468',203784.26,203933.20,0.00,0.00,148.94,108726.20,0.00,0.00,0.00),('1','200','1025','257889',4906646,'3042','468',238333.63,238474.18,0.00,0.00,140.55,102601.50,0.00,0.00,0.00),('1','200','1025','257889',4906647,'3043','468',248648.41,248851.91,0.00,0.00,203.50,148555.00,0.00,0.00,0.00),('1','200','1025','257889',4906648,'3044','468',232331.27,232478.77,0.00,0.00,147.50,107675.00,0.00,0.00,0.00),('1','200','1025','257890',4906649,'3037','468',135514.86,136354.87,0.00,0.00,840.01,646807.70,0.00,0.00,0.00),('1','200','1025','257890',4906650,'3038','468',135431.07,136498.88,0.00,0.00,1067.81,822213.70,0.00,0.00,0.00),('1','200','1025','257890',4906651,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257890',4906652,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257890',4906653,'3041','468',203933.20,204266.82,0.00,0.00,333.62,243542.60,0.00,0.00,0.00),('1','200','1025','257890',4906654,'3042','468',238474.18,239056.40,0.00,0.00,582.22,425020.60,0.00,0.00,0.00),('1','200','1025','257890',4906655,'3043','468',248851.91,249647.56,0.00,0.00,795.65,580824.50,0.00,0.00,0.00),('1','200','1025','257890',4906656,'3044','468',232478.77,233293.77,0.00,0.00,815.00,594950.00,0.00,0.00,0.00),('1','200','1025','257891',4906657,'3037','468',136354.87,137732.52,0.00,0.00,1377.65,1060790.50,0.00,0.00,0.00),('1','200','1025','257891',4906658,'3038','468',136498.88,137679.41,0.00,0.00,1180.53,909008.10,0.00,0.00,0.00),('1','200','1025','257891',4906659,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257891',4906660,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257891',4906661,'3041','468',204266.82,204625.32,0.00,0.00,358.50,261705.00,0.00,0.00,0.00),('1','200','1025','257891',4906662,'3042','468',239056.40,239489.60,0.00,0.00,433.20,316236.00,0.00,0.00,0.00),('1','200','1025','257891',4906663,'3043','468',249647.56,250314.24,0.00,0.00,666.68,486676.40,0.00,0.00,0.00),('1','200','1025','257891',4906664,'3044','468',233293.77,233826.42,0.00,0.00,532.65,388834.50,0.00,0.00,0.00),('1','200','1025','257892',4906665,'3037','468',137732.52,138658.79,0.00,0.00,926.27,713227.90,0.00,0.00,0.00),('1','200','1025','257892',4906666,'3038','468',137679.41,138700.57,0.00,0.00,1021.16,786293.20,0.00,0.00,0.00),('1','200','1025','257892',4906667,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257892',4906668,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257892',4906669,'3041','468',204625.32,205323.44,0.00,0.00,698.12,509627.60,0.00,0.00,0.00),('1','200','1025','257892',4906670,'3042','468',239489.60,240436.60,0.00,0.00,947.00,691310.00,0.00,0.00,0.00),('1','200','1025','257892',4906671,'3043','468',250314.24,251533.14,0.00,0.00,1218.90,889797.00,0.00,0.00,0.00),('1','200','1025','257892',4906672,'3044','468',233826.42,234765.42,0.00,0.00,939.00,685470.00,0.00,0.00,0.00),('1','200','1025','257893',4906673,'3037','468',138658.79,139737.13,0.00,0.00,1078.34,830321.80,0.00,0.00,0.00),('1','200','1025','257893',4906674,'3038','468',138700.57,139678.06,0.00,0.00,977.49,752667.30,0.00,0.00,0.00),('1','200','1025','257893',4906675,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257893',4906676,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257893',4906677,'3041','468',205323.44,205688.44,0.00,0.00,365.00,266450.00,0.00,0.00,0.00),('1','200','1025','257893',4906678,'3042','468',240436.60,240896.10,0.00,0.00,459.50,335435.00,0.00,0.00,0.00),('1','200','1025','257893',4906679,'3043','468',251533.14,252233.64,0.00,0.00,700.50,511365.00,0.00,0.00,0.00),('1','200','1025','257893',4906680,'3044','468',234765.42,235361.42,0.00,0.00,596.00,435080.00,0.00,0.00,0.00),('1','200','1025','257894',4906681,'3037','468',139737.13,140646.59,0.00,0.00,909.46,700284.20,0.00,0.00,0.00),('1','200','1025','257894',4906682,'3038','468',139678.06,140565.32,0.00,0.00,887.26,683190.20,0.00,0.00,0.00),('1','200','1025','257894',4906683,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257894',4906684,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257894',4906685,'3041','468',205688.44,206040.44,0.00,0.00,352.00,256960.00,0.00,0.00,0.00),('1','200','1025','257894',4906686,'3042','468',240896.10,241325.15,0.00,0.00,429.05,313206.50,0.00,0.00,0.00),('1','200','1025','257894',4906687,'3043','468',252233.64,252813.14,0.00,0.00,579.50,423035.00,0.00,0.00,0.00),('1','200','1025','257894',4906688,'3044','468',235361.42,235746.32,0.00,0.00,384.90,280977.00,0.00,0.00,0.00),('1','200','1025','257895',4906689,'3037','468',140646.59,141366.65,0.00,0.00,720.06,554446.20,0.00,0.00,0.00),('1','200','1025','257895',4906690,'3038','468',140565.32,141552.58,0.00,0.00,987.26,760190.20,0.00,0.00,0.00),('1','200','1025','257895',4906691,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257895',4906692,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257895',4906693,'3041','468',206040.44,206471.94,0.00,0.00,431.50,314995.00,0.00,0.00,0.00),('1','200','1025','257895',4906694,'3042','468',241325.15,241726.67,0.00,0.00,401.52,293109.60,0.00,0.00,0.00),('1','200','1025','257895',4906695,'3043','468',252813.14,253424.40,0.00,0.00,611.26,446219.80,0.00,0.00,0.00),('1','200','1025','257895',4906696,'3044','468',235746.32,236129.47,0.00,0.00,383.15,279699.50,0.00,0.00,0.00),('1','200','1025','257896',4906697,'3037','468',141366.65,142573.55,0.00,0.00,1206.90,929313.00,0.00,0.00,0.00),('1','200','1025','257896',4906698,'3038','468',141552.58,142628.36,0.00,0.00,1075.78,828350.60,0.00,0.00,0.00),('1','200','1025','257896',4906699,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257896',4906700,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257896',4906701,'3041','468',206471.94,207008.44,0.00,0.00,536.50,391645.00,0.00,0.00,0.00),('1','200','1025','257896',4906702,'3042','468',241726.67,242411.67,0.00,0.00,685.00,500050.00,0.00,0.00,0.00),('1','200','1025','257896',4906703,'3043','468',253424.40,254432.20,0.00,0.00,1007.80,735694.00,0.00,0.00,0.00),('1','200','1025','257896',4906704,'3044','468',236129.47,236610.47,0.00,0.00,481.00,351130.00,0.00,0.00,0.00),('1','200','1025','257897',4906705,'3037','468',142573.55,143819.60,0.00,0.00,1246.05,959458.50,0.00,0.00,0.00),('1','200','1025','257897',4906706,'3038','468',142628.36,143639.88,0.00,0.00,1011.52,778870.40,0.00,0.00,0.00),('1','200','1025','257897',4906707,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257897',4906708,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257897',4906709,'3041','468',207008.44,207327.94,0.00,0.00,319.50,233235.00,0.00,0.00,0.00),('1','200','1025','257897',4906710,'3042','468',242411.67,242716.17,0.00,0.00,304.50,222285.00,0.00,0.00,0.00),('1','200','1025','257897',4906711,'3043','468',254432.20,254735.20,0.00,0.00,303.00,221190.00,0.00,0.00,0.00),('1','200','1025','257897',4906712,'3044','468',236610.47,237008.97,0.00,0.00,398.50,290905.00,0.00,0.00,0.00),('1','200','1025','257898',4906713,'3037','468',143819.60,145020.83,0.00,0.00,1201.23,924947.10,0.00,0.00,0.00),('1','200','1025','257898',4906714,'3038','468',143639.88,144638.70,0.00,0.00,998.82,769091.40,0.00,0.00,0.00),('1','200','1025','257898',4906715,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257898',4906716,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257898',4906717,'3041','468',207327.94,207765.08,0.00,0.00,437.14,319112.20,0.00,0.00,0.00),('1','200','1025','257898',4906718,'3042','468',242716.17,243345.57,0.00,0.00,629.40,459462.00,0.00,0.00,0.00),('1','200','1025','257898',4906719,'3043','468',254735.20,255052.23,0.00,0.00,317.03,231431.90,0.00,0.00,0.00),('1','200','1025','257898',4906720,'3044','468',237008.97,237376.47,0.00,0.00,367.50,268275.00,0.00,0.00,0.00),('1','200','1025','257899',4906721,'3037','468',145020.83,146044.14,0.00,0.00,1023.31,787948.70,0.00,0.00,0.00),('1','200','1025','257899',4906722,'3038','468',144638.70,145499.12,0.00,0.00,860.42,662523.40,0.00,0.00,0.00),('1','200','1025','257899',4906723,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257899',4906724,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257899',4906725,'3041','468',207765.08,208208.45,0.00,0.00,443.37,323660.10,0.00,0.00,0.00),('1','200','1025','257899',4906726,'3042','468',243345.57,243938.21,0.00,0.00,592.64,432627.20,0.00,0.00,0.00),('1','200','1025','257899',4906727,'3043','468',255052.23,255595.23,0.00,0.00,543.00,396390.00,0.00,0.00,0.00),('1','200','1025','257899',4906728,'3044','468',237376.47,237767.47,0.00,0.00,391.00,285430.00,0.00,0.00,0.00),('1','200','1025','257900',4906729,'3037','468',146044.14,147007.80,0.00,0.00,963.66,742018.20,0.00,0.00,0.00),('1','200','1025','257900',4906730,'3038','468',145499.12,146524.53,0.00,0.00,1025.41,789565.70,0.00,0.00,0.00),('1','200','1025','257900',4906731,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257900',4906732,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257900',4906733,'3041','468',208208.45,208756.45,0.00,0.00,548.00,400040.00,0.00,0.00,0.00),('1','200','1025','257900',4906734,'3042','468',243938.21,244423.21,0.00,0.00,485.00,354050.00,0.00,0.00,0.00),('1','200','1025','257900',4906735,'3043','468',255595.23,256025.53,0.00,0.00,430.30,314119.00,0.00,0.00,0.00),('1','200','1025','257900',4906736,'3044','468',237767.47,238187.67,0.00,0.00,420.20,306746.00,0.00,0.00,0.00),('1','200','1025','257901',4906737,'3037','468',147007.80,148027.94,0.00,0.00,1020.14,785507.80,0.00,0.00,0.00),('1','200','1025','257901',4906738,'3038','468',146524.53,147383.94,0.00,0.00,859.41,661745.70,0.00,0.00,0.00),('1','200','1025','257901',4906739,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257901',4906740,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257901',4906741,'3041','468',208756.45,209108.33,0.00,0.00,351.88,256872.40,0.00,0.00,0.00),('1','200','1025','257901',4906742,'3042','468',244423.21,245050.81,0.00,0.00,627.60,458148.00,0.00,0.00,0.00),('1','200','1025','257901',4906743,'3043','468',256025.53,256647.03,0.00,0.00,621.50,453695.00,0.00,0.00,0.00),('1','200','1025','257901',4906744,'3044','468',238187.67,238743.67,0.00,0.00,556.00,405880.00,0.00,0.00,0.00),('1','200','1025','257902',4906745,'3037','468',148027.94,149248.54,0.00,0.00,1220.60,939862.00,0.00,0.00,0.00),('1','200','1025','257902',4906746,'3038','468',147383.94,148473.16,0.00,0.00,1089.22,838699.40,0.00,0.00,0.00),('1','200','1025','257902',4906747,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257902',4906748,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257902',4906749,'3041','468',209108.33,209474.83,0.00,0.00,366.50,267545.00,0.00,0.00,0.00),('1','200','1025','257902',4906750,'3042','468',245050.81,245697.65,0.00,0.00,646.84,472193.20,0.00,0.00,0.00),('1','200','1025','257902',4906751,'3043','468',256647.03,257288.03,0.00,0.00,641.00,467930.00,0.00,0.00,0.00),('1','200','1025','257902',4906752,'3044','468',238743.67,239335.67,0.00,0.00,592.00,432160.00,0.00,0.00,0.00),('1','200','1025','257903',4906753,'3037','468',149248.54,150375.90,0.00,0.00,1127.36,868067.20,0.00,0.00,0.00),('1','200','1025','257903',4906754,'3038','468',148473.16,149653.76,0.00,0.00,1180.60,909062.00,0.00,0.00,0.00),('1','200','1025','257903',4906755,'3039','468',252063.22,252063.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257903',4906756,'3040','468',256131.97,256131.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257903',4906757,'3041','468',209474.83,209758.65,0.00,0.00,283.82,207188.60,0.00,0.00,0.00),('1','200','1025','257903',4906758,'3042','468',245697.65,246001.65,0.00,0.00,304.00,221920.00,0.00,0.00,0.00),('1','200','1025','257903',4906759,'3043','468',257288.03,257754.53,0.00,0.00,466.50,340545.00,0.00,0.00,0.00),('1','200','1025','257903',4906760,'3044','468',239335.67,239890.83,0.00,0.00,555.16,405266.80,0.00,0.00,0.00),('1','200','1025','257904',4906761,'3037','468',150375.90,150375.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257904',4906762,'3038','468',149653.76,149653.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257904',4906763,'3039','468',252063.22,253201.82,0.00,0.00,1138.60,876722.00,0.00,0.00,0.00),('1','200','1025','257904',4906764,'3040','468',256131.97,257226.02,0.00,0.00,1094.05,842418.50,0.00,0.00,0.00),('1','200','1025','257904',4906765,'3041','468',209758.65,210011.15,0.00,0.00,252.50,184325.00,0.00,0.00,0.00),('1','200','1025','257904',4906766,'3042','468',246001.65,246351.15,0.00,0.00,349.50,255135.00,0.00,0.00,0.00),('1','200','1025','257904',4906767,'3043','468',257754.53,258282.64,0.00,0.00,528.11,385520.30,0.00,0.00,0.00),('1','200','1025','257904',4906768,'3044','468',239890.83,240372.83,0.00,0.00,482.00,351860.00,0.00,0.00,0.00),('1','200','1025','257905',4906769,'3037','468',150375.90,150375.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257905',4906770,'3038','468',149653.76,149653.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257905',4906771,'3039','468',253201.82,253201.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257905',4906772,'3040','468',257226.02,257226.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257905',4906773,'3041','468',210011.15,210011.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257905',4906774,'3042','468',246351.15,246351.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257905',4906775,'3043','468',258282.64,258282.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257905',4906776,'3044','468',240372.83,240372.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257906',4906777,'3037','468',150375.90,150375.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257906',4906778,'3038','468',149653.76,149653.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257906',4906779,'3039','468',253201.82,254268.49,0.00,0.00,1066.67,821335.90,0.00,0.00,0.00),('1','200','1025','257906',4906780,'3040','468',257226.02,258183.61,0.00,0.00,957.59,737344.30,0.00,0.00,0.00),('1','200','1025','257906',4906781,'3041','468',210011.15,210211.14,0.00,0.00,199.99,145992.70,0.00,0.00,0.00),('1','200','1025','257906',4906782,'3042','468',246351.15,246826.65,0.00,0.00,475.50,347115.00,0.00,0.00,0.00),('1','200','1025','257906',4906783,'3043','468',258282.64,258822.64,0.00,0.00,540.00,394200.00,0.00,0.00,0.00),('1','200','1025','257906',4906784,'3044','468',240372.83,240873.83,0.00,0.00,501.00,365730.00,0.00,0.00,0.00),('1','200','1025','257907',4906785,'3037','468',150375.90,150375.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257907',4906786,'3038','468',149653.76,149653.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257907',4906787,'3039','468',254268.49,255290.95,0.00,0.00,1022.46,787294.20,0.00,0.00,0.00),('1','200','1025','257907',4906788,'3040','468',258183.61,259297.23,0.00,0.00,1113.62,855427.40,0.00,0.00,0.00),('1','200','1025','257907',4906789,'3041','468',210211.14,210931.14,0.00,0.00,720.00,525600.00,0.00,0.00,0.00),('1','200','1025','257907',4906790,'3042','468',246826.65,247611.15,0.00,0.00,784.50,572685.00,0.00,0.00,0.00),('1','200','1025','257907',4906791,'3043','468',258822.64,259946.73,0.00,0.00,1124.09,820585.70,0.00,0.00,0.00),('1','200','1025','257907',4906792,'3044','468',240873.83,241679.77,0.00,0.00,805.94,588336.20,0.00,0.00,0.00),('1','200','1025','257908',4906793,'3037','468',150375.90,151236.52,0.00,0.00,860.62,662677.40,0.00,0.00,0.00),('1','200','1025','257908',4906794,'3038','468',149653.76,150493.74,0.00,0.00,839.98,646784.60,0.00,0.00,0.00),('1','200','1025','257908',4906795,'3039','468',255290.95,255290.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257908',4906796,'3040','468',259297.23,259297.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257908',4906797,'3041','468',210931.14,211490.85,0.00,0.00,559.71,408588.30,0.00,0.00,0.00),('1','200','1025','257908',4906798,'3042','468',247611.15,248209.15,0.00,0.00,598.00,436540.00,0.00,0.00,0.00),('1','200','1025','257908',4906799,'3043','468',259946.73,260967.23,0.00,0.00,1020.50,744965.00,0.00,0.00,0.00),('1','200','1025','257908',4906800,'3044','468',241679.77,242324.00,0.00,0.00,644.23,470287.90,0.00,0.00,0.00),('1','200','1025','257909',4906801,'3037','468',151236.52,152617.58,0.00,0.00,1381.06,1063416.20,0.00,0.00,0.00),('1','200','1025','257909',4906802,'3038','468',150493.74,151625.35,0.00,0.00,1131.61,871339.70,0.00,0.00,0.00),('1','200','1025','257909',4906803,'3039','468',255290.95,255290.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257909',4906804,'3040','468',259297.23,259297.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257909',4906805,'3041','468',211490.85,212258.35,0.00,0.00,767.50,560275.00,0.00,0.00,0.00),('1','200','1025','257909',4906806,'3042','468',248209.15,248783.84,0.00,0.00,574.69,419523.70,0.00,0.00,0.00),('1','200','1025','257909',4906807,'3043','468',260967.23,261777.37,0.00,0.00,810.14,591402.20,0.00,0.00,0.00),('1','200','1025','257909',4906808,'3044','468',242324.00,242804.00,0.00,0.00,480.00,350400.00,0.00,0.00,0.00),('1','200','1025','257910',4906809,'3037','468',152617.58,153829.75,0.00,0.00,1212.17,933370.90,0.00,0.00,0.00),('1','200','1025','257910',4906810,'3038','468',151625.35,152597.62,0.00,0.00,972.27,748647.90,0.00,0.00,0.00),('1','200','1025','257910',4906811,'3039','468',255290.95,255290.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257910',4906812,'3040','468',259297.23,259297.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257910',4906813,'3041','468',212258.35,212617.35,0.00,0.00,359.00,262070.00,0.00,0.00,0.00),('1','200','1025','257910',4906814,'3042','468',248783.84,249267.35,0.00,0.00,483.51,352962.30,0.00,0.00,0.00),('1','200','1025','257910',4906815,'3043','468',261777.37,262294.73,0.00,0.00,517.36,377672.80,0.00,0.00,0.00),('1','200','1025','257910',4906816,'3044','468',242804.00,243042.85,0.00,0.00,238.85,174360.50,0.00,0.00,0.00),('1','200','1025','257911',4906817,'3037','468',153829.75,154814.05,0.00,0.00,984.30,757911.00,0.00,0.00,0.00),('1','200','1025','257911',4906818,'3038','468',152597.62,153626.42,0.00,0.00,1028.80,792176.00,0.00,0.00,0.00),('1','200','1025','257911',4906819,'3039','468',255290.95,255290.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257911',4906820,'3040','468',259297.23,259297.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257911',4906821,'3041','468',212617.35,213001.35,0.00,0.00,384.00,280320.00,0.00,0.00,0.00),('1','200','1025','257911',4906822,'3042','468',249267.35,249736.54,0.00,0.00,469.19,342508.70,0.00,0.00,0.00),('1','200','1025','257911',4906823,'3043','468',262294.73,263029.71,0.00,0.00,734.98,536535.40,0.00,0.00,0.00),('1','200','1025','257911',4906824,'3044','468',243042.85,243691.34,0.00,0.00,648.49,473397.70,0.00,0.00,0.00),('1','200','1025','257912',4906825,'3037','468',154814.05,155856.78,0.00,0.00,1042.73,802902.10,0.00,0.00,0.00),('1','200','1025','257912',4906826,'3038','468',153626.42,154678.40,0.00,0.00,1051.98,810024.60,0.00,0.00,0.00),('1','200','1025','257912',4906827,'3039','468',255290.95,255290.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257912',4906828,'3040','468',259297.23,259297.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257912',4906829,'3041','468',213001.35,213282.36,0.00,0.00,281.01,205137.30,0.00,0.00,0.00),('1','200','1025','257912',4906830,'3042','468',249736.54,250132.04,0.00,0.00,395.50,288715.00,0.00,0.00,0.00),('1','200','1025','257912',4906831,'3043','468',263029.71,263678.72,0.00,0.00,649.01,473777.30,0.00,0.00,0.00),('1','200','1025','257912',4906832,'3044','468',243691.34,244358.84,0.00,0.00,667.50,487275.00,0.00,0.00,0.00),('1','200','1025','257913',4906833,'3037','468',155856.78,156823.10,0.00,0.00,966.32,744066.40,0.00,0.00,0.00),('1','200','1025','257913',4906834,'3038','468',154678.40,155828.74,0.00,0.00,1150.34,885761.80,0.00,0.00,0.00),('1','200','1025','257913',4906835,'3039','468',255290.95,255290.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257913',4906836,'3040','468',259297.23,259297.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257913',4906837,'3041','468',213282.36,213939.36,0.00,0.00,657.00,479610.00,0.00,0.00,0.00),('1','200','1025','257913',4906838,'3042','468',250132.04,250883.54,0.00,0.00,751.50,548595.00,0.00,0.00,0.00),('1','200','1025','257913',4906839,'3043','468',263678.72,264575.82,0.00,0.00,897.10,654883.00,0.00,0.00,0.00),('1','200','1025','257913',4906840,'3044','468',244358.84,245071.57,0.00,0.00,712.73,520292.90,0.00,0.00,0.00),('1','200','1025','257914',4906841,'3037','468',156823.10,157725.69,0.00,0.00,902.59,694994.30,0.00,0.00,0.00),('1','200','1025','257914',4906842,'3038','468',155828.74,156967.88,0.00,0.00,1139.14,877137.80,0.00,0.00,0.00),('1','200','1025','257914',4906843,'3039','468',255290.95,255290.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257914',4906844,'3040','468',259297.23,259297.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257914',4906845,'3041','468',213939.36,214428.86,0.00,0.00,489.50,357335.00,0.00,0.00,0.00),('1','200','1025','257914',4906846,'3042','468',250883.54,251365.54,0.00,0.00,482.00,351860.00,0.00,0.00,0.00),('1','200','1025','257914',4906847,'3043','468',264575.82,265241.82,0.00,0.00,666.00,486180.00,0.00,0.00,0.00),('1','200','1025','257914',4906848,'3044','468',245071.57,245566.07,0.00,0.00,494.50,360985.00,0.00,0.00,0.00),('1','200','1025','257915',4906849,'3037','468',157725.69,157725.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257915',4906850,'3038','468',156967.88,156967.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257915',4906851,'3039','468',255290.95,256247.32,0.00,0.00,956.37,736404.90,0.00,0.00,0.00),('1','200','1025','257915',4906852,'3040','468',259297.23,260312.73,0.00,0.00,1015.50,781935.00,0.00,0.00,0.00),('1','200','1025','257915',4906853,'3041','468',214428.86,214894.86,0.00,0.00,466.00,340180.00,0.00,0.00,0.00),('1','200','1025','257915',4906854,'3042','468',251365.54,251975.33,0.00,0.00,609.79,445146.70,0.00,0.00,0.00),('1','200','1025','257915',4906855,'3043','468',265241.82,266202.82,0.00,0.00,961.00,701530.00,0.00,0.00,0.00),('1','200','1025','257915',4906856,'3044','468',245566.07,246468.73,0.00,0.00,902.66,658941.80,0.00,0.00,0.00),('1','200','1025','257916',4906857,'3037','468',157725.69,157725.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257916',4906858,'3038','468',156967.88,156967.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257916',4906859,'3039','468',256247.32,257077.33,0.00,0.00,830.01,639107.70,0.00,0.00,0.00),('1','200','1025','257916',4906860,'3040','468',260312.73,261021.43,0.00,0.00,708.70,545699.00,0.00,0.00,0.00),('1','200','1025','257916',4906861,'3041','468',214894.86,215057.86,0.00,0.00,163.00,118990.00,0.00,0.00,0.00),('1','200','1025','257916',4906862,'3042','468',251975.33,252292.03,0.00,0.00,316.70,231191.00,0.00,0.00,0.00),('1','200','1025','257916',4906863,'3043','468',266202.82,266711.82,0.00,0.00,509.00,371570.00,0.00,0.00,0.00),('1','200','1025','257916',4906864,'3044','468',246468.73,246773.23,0.00,0.00,304.50,222285.00,0.00,0.00,0.00),('1','200','1025','257917',4906865,'3037','468',157725.69,157725.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257917',4906866,'3038','468',156967.88,156967.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257917',4906867,'3039','468',257077.33,257077.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257917',4906868,'3040','468',261021.43,261021.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257917',4906869,'3041','468',215057.86,215057.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257917',4906870,'3042','468',252292.03,252292.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257917',4906871,'3043','468',266711.82,266711.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257917',4906872,'3044','468',246773.23,246773.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257918',4906873,'3037','468',157725.69,157725.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257918',4906874,'3038','468',156967.88,156967.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257918',4906875,'3039','468',257077.33,257231.66,0.00,0.00,154.33,118834.10,0.00,0.00,0.00),('1','200','1025','257918',4906876,'3040','468',261021.43,261138.92,0.00,0.00,117.49,90467.30,0.00,0.00,0.00),('1','200','1025','257918',4906877,'3041','468',215057.86,215200.36,0.00,0.00,142.50,104025.00,0.00,0.00,0.00),('1','200','1025','257918',4906878,'3042','468',252292.03,252431.53,0.00,0.00,139.50,101835.00,0.00,0.00,0.00),('1','200','1025','257918',4906879,'3043','468',266711.82,266862.19,0.00,0.00,150.37,109770.10,0.00,0.00,0.00),('1','200','1025','257918',4906880,'3044','468',246773.23,246893.73,0.00,0.00,120.50,87965.00,0.00,0.00,0.00),('1','200','1025','257919',4906881,'3037','468',157725.69,157725.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257919',4906882,'3038','468',156967.88,156967.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257919',4906883,'3039','468',257231.66,258064.94,0.00,0.00,833.28,641625.60,0.00,0.00,0.00),('1','200','1025','257919',4906884,'3040','468',261138.92,261903.66,0.00,0.00,764.74,588849.80,0.00,0.00,0.00),('1','200','1025','257919',4906885,'3041','468',215200.36,215858.85,0.00,0.00,658.49,480697.70,0.00,0.00,0.00),('1','200','1025','257919',4906886,'3042','468',252431.53,253095.03,0.00,0.00,663.50,484355.00,0.00,0.00,0.00),('1','200','1025','257919',4906887,'3043','468',266862.19,267660.19,0.00,0.00,798.00,582540.00,0.00,0.00,0.00),('1','200','1025','257919',4906888,'3044','468',246893.73,247555.24,0.00,0.00,661.51,482902.30,0.00,0.00,0.00),('1','200','1025','257920',4906889,'3037','468',157725.69,157725.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257920',4906890,'3038','468',156967.88,156967.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257920',4906891,'3039','468',258064.94,259001.29,0.00,0.00,936.35,720989.50,0.00,0.00,0.00),('1','200','1025','257920',4906892,'3040','468',261903.66,263156.43,0.00,0.00,1252.77,964632.90,0.00,0.00,0.00),('1','200','1025','257920',4906893,'3041','468',215858.85,216328.61,0.00,0.00,469.76,342924.80,0.00,0.00,0.00),('1','200','1025','257920',4906894,'3042','468',253095.03,253511.53,0.00,0.00,416.50,304045.00,0.00,0.00,0.00),('1','200','1025','257920',4906895,'3043','468',267660.19,268250.02,0.00,0.00,589.83,430575.90,0.00,0.00,0.00),('1','200','1025','257920',4906896,'3044','468',247555.24,248168.24,0.00,0.00,613.00,447490.00,0.00,0.00,0.00),('1','200','1025','257921',4906897,'3037','468',157725.69,157725.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257921',4906898,'3038','468',156967.88,156967.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257921',4906899,'3039','468',259001.29,260178.14,0.00,0.00,1176.85,906174.50,0.00,0.00,0.00),('1','200','1025','257921',4906900,'3040','468',263156.43,264222.47,0.00,0.00,1066.04,820850.80,0.00,0.00,0.00),('1','200','1025','257921',4906901,'3041','468',216328.61,216649.01,0.00,0.00,320.40,233892.00,0.00,0.00,0.00),('1','200','1025','257921',4906902,'3042','468',253511.53,253887.03,0.00,0.00,375.50,274115.00,0.00,0.00,0.00),('1','200','1025','257921',4906903,'3043','468',268250.02,268964.12,0.00,0.00,714.10,521293.00,0.00,0.00,0.00),('1','200','1025','257921',4906904,'3044','468',248168.24,248609.24,0.00,0.00,441.00,321930.00,0.00,0.00,0.00),('1','200','1025','257922',4906905,'3037','468',157725.69,158616.74,0.00,0.00,891.05,686108.50,0.00,0.00,0.00),('1','200','1025','257922',4906906,'3038','468',156967.88,157946.46,0.00,0.00,978.58,753506.60,0.00,0.00,0.00),('1','200','1025','257922',4906907,'3039','468',260178.14,260178.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257922',4906908,'3040','468',264222.47,264222.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257922',4906909,'3041','468',216649.01,217078.51,0.00,0.00,429.50,313535.00,0.00,0.00,0.00),('1','200','1025','257922',4906910,'3042','468',253887.03,254532.03,0.00,0.00,645.00,470850.00,0.00,0.00,0.00),('1','200','1025','257922',4906911,'3043','468',268964.12,269500.92,0.00,0.00,536.80,391864.00,0.00,0.00,0.00),('1','200','1025','257922',4906912,'3044','468',248609.24,249023.44,0.00,0.00,414.20,302366.00,0.00,0.00,0.00),('1','200','1025','257923',4906913,'3037','468',158616.74,159495.78,0.00,0.00,879.04,676860.80,0.00,0.00,0.00),('1','200','1025','257923',4906914,'3038','468',157946.46,158580.10,0.00,0.00,633.64,487902.80,0.00,0.00,0.00),('1','200','1025','257923',4906915,'3039','468',260178.14,260178.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257923',4906916,'3040','468',264222.47,264222.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257923',4906917,'3041','468',217078.51,217795.85,0.00,0.00,717.34,523658.20,0.00,0.00,0.00),('1','200','1025','257923',4906918,'3042','468',254532.03,255657.78,0.00,0.00,1125.75,821797.50,0.00,0.00,0.00),('1','200','1025','257923',4906919,'3043','468',269500.92,270655.66,0.00,0.00,1154.74,842960.20,0.00,0.00,0.00),('1','200','1025','257923',4906920,'3044','468',249023.44,249858.94,0.00,0.00,835.50,609915.00,0.00,0.00,0.00),('1','200','1025','257924',4906921,'3037','468',159495.78,160297.17,0.00,0.00,801.39,617070.30,0.00,0.00,0.00),('1','200','1025','257924',4906922,'3038','468',158580.10,159436.46,0.00,0.00,856.36,659397.20,0.00,0.00,0.00),('1','200','1025','257924',4906923,'3039','468',260178.14,260178.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257924',4906924,'3040','468',264222.47,264222.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257924',4906925,'3041','468',217795.85,218090.85,0.00,0.00,295.00,215350.00,0.00,0.00,0.00),('1','200','1025','257924',4906926,'3042','468',255657.78,256010.78,0.00,0.00,353.00,257690.00,0.00,0.00,0.00),('1','200','1025','257924',4906927,'3043','468',270655.66,270955.16,0.00,0.00,299.50,218635.00,0.00,0.00,0.00),('1','200','1025','257924',4906928,'3044','468',249858.94,250077.94,0.00,0.00,219.00,159870.00,0.00,0.00,0.00),('1','200','1025','257925',4906929,'3037','468',160297.17,161163.31,0.00,0.00,866.14,666927.80,0.00,0.00,0.00),('1','200','1025','257925',4906930,'3038','468',159436.46,160340.49,0.00,0.00,904.03,696103.10,0.00,0.00,0.00),('1','200','1025','257925',4906931,'3039','468',260178.14,260178.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257925',4906932,'3040','468',264222.47,264222.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257925',4906933,'3041','468',218090.85,218210.85,0.00,0.00,120.00,87600.00,0.00,0.00,0.00),('1','200','1025','257925',4906934,'3042','468',256010.78,256327.28,0.00,0.00,316.50,231045.00,0.00,0.00,0.00),('1','200','1025','257925',4906935,'3043','468',270955.16,271721.62,0.00,0.00,766.46,559515.80,0.00,0.00,0.00),('1','200','1025','257925',4906936,'3044','468',250077.94,250513.94,0.00,0.00,436.00,318280.00,0.00,0.00,0.00),('1','200','1025','257926',4906937,'3037','468',161163.31,161163.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257926',4906938,'3038','468',160340.49,160340.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257926',4906939,'3039','468',260178.14,261008.98,0.00,0.00,830.84,639746.80,0.00,0.00,0.00),('1','200','1025','257926',4906940,'3040','468',264222.47,265152.73,0.00,0.00,930.26,716300.20,0.00,0.00,0.00),('1','200','1025','257926',4906941,'3041','468',218210.85,218884.35,0.00,0.00,673.50,491655.00,0.00,0.00,0.00),('1','200','1025','257926',4906942,'3042','468',256327.28,256985.24,0.00,0.00,657.96,480310.80,0.00,0.00,0.00),('1','200','1025','257926',4906943,'3043','468',271721.62,272430.82,0.00,0.00,709.20,517716.00,0.00,0.00,0.00),('1','200','1025','257926',4906944,'3044','468',250513.94,251008.28,0.00,0.00,494.34,360868.20,0.00,0.00,0.00),('1','200','1025','257927',4906945,'3037','468',161163.31,162085.19,0.00,0.00,921.88,709847.60,0.00,0.00,0.00),('1','200','1025','257927',4906946,'3038','468',160340.49,161483.27,0.00,0.00,1142.78,879940.60,0.00,0.00,0.00),('1','200','1025','257927',4906947,'3039','468',261008.98,261008.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257927',4906948,'3040','468',265152.73,265152.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257927',4906949,'3041','468',218884.35,219701.94,0.00,0.00,817.59,596840.70,0.00,0.00,0.00),('1','200','1025','257927',4906950,'3042','468',256985.24,257384.84,0.00,0.00,399.60,291708.00,0.00,0.00,0.00),('1','200','1025','257927',4906951,'3043','468',272430.82,272856.62,0.00,0.00,425.80,310834.00,0.00,0.00,0.00),('1','200','1025','257927',4906952,'3044','468',251008.28,251494.78,0.00,0.00,486.50,355145.00,0.00,0.00,0.00),('1','200','1025','257928',4906953,'3037','468',162085.19,162085.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257928',4906954,'3038','468',161483.27,161483.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257928',4906955,'3039','468',261008.98,261523.35,0.00,0.00,514.37,396064.90,0.00,0.00,0.00),('1','200','1025','257928',4906956,'3040','468',265152.73,265698.00,0.00,0.00,545.27,419857.90,0.00,0.00,0.00),('1','200','1025','257928',4906957,'3041','468',219701.94,219831.44,0.00,0.00,129.50,94535.00,0.00,0.00,0.00),('1','200','1025','257928',4906958,'3042','468',257384.84,257552.34,0.00,0.00,167.50,122275.00,0.00,0.00,0.00),('1','200','1025','257928',4906959,'3043','468',272856.62,273057.12,0.00,0.00,200.50,146365.00,0.00,0.00,0.00),('1','200','1025','257928',4906960,'3044','468',251494.78,251682.35,0.00,0.00,187.57,136926.10,0.00,0.00,0.00),('1','200','1025','257929',4906961,'3037','468',162085.19,162085.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257929',4906962,'3038','468',161483.27,161483.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257929',4906963,'3039','468',261523.35,261523.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257929',4906964,'3040','468',265698.00,265698.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257929',4906965,'3041','468',219831.44,219831.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257929',4906966,'3042','468',257552.34,257552.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257929',4906967,'3043','468',273057.12,273057.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257929',4906968,'3044','468',251682.35,251682.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257930',4906969,'3037','468',162085.19,162085.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257930',4906970,'3038','468',161483.27,161483.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257930',4906971,'3039','468',261523.35,262182.69,0.00,0.00,659.34,507691.80,0.00,0.00,0.00),('1','200','1025','257930',4906972,'3040','468',265698.00,266353.40,0.00,0.00,655.40,504658.00,0.00,0.00,0.00),('1','200','1025','257930',4906973,'3041','468',219831.44,220109.73,0.00,0.00,278.29,203151.70,0.00,0.00,0.00),('1','200','1025','257930',4906974,'3042','468',257552.34,258064.89,0.00,0.00,512.55,374161.50,0.00,0.00,0.00),('1','200','1025','257930',4906975,'3043','468',273057.12,273469.12,0.00,0.00,412.00,300760.00,0.00,0.00,0.00),('1','200','1025','257930',4906976,'3044','468',251682.35,252003.88,0.00,0.00,321.53,234716.90,0.00,0.00,0.00),('1','200','1025','257931',4906977,'3037','468',162085.19,163039.36,0.00,0.00,954.17,734710.90,0.00,0.00,0.00),('1','200','1025','257931',4906978,'3038','468',161483.27,162346.25,0.00,0.00,862.98,664494.60,0.00,0.00,0.00),('1','200','1025','257931',4906979,'3039','468',262182.69,262182.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257931',4906980,'3040','468',266353.40,266353.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257931',4906981,'3041','468',220109.73,220727.03,0.00,0.00,617.30,450629.00,0.00,0.00,0.00),('1','200','1025','257931',4906982,'3042','468',258064.89,258676.99,0.00,0.00,612.10,446833.00,0.00,0.00,0.00),('1','200','1025','257931',4906983,'3043','468',273469.12,273961.62,0.00,0.00,492.50,359525.00,0.00,0.00,0.00),('1','200','1025','257931',4906984,'3044','468',252003.88,252420.38,0.00,0.00,416.50,304045.00,0.00,0.00,0.00),('1','200','1025','257932',4906985,'3037','468',163039.36,163823.76,0.00,0.00,784.40,603988.00,0.00,0.00,0.00),('1','200','1025','257932',4906986,'3038','468',162346.25,163086.26,0.00,0.00,740.01,569807.70,0.00,0.00,0.00),('1','200','1025','257932',4906987,'3039','468',262182.69,262182.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257932',4906988,'3040','468',266353.40,266353.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257932',4906989,'3041','468',220727.03,221235.93,0.00,0.00,508.90,371497.00,0.00,0.00,0.00),('1','200','1025','257932',4906990,'3042','468',258676.99,259390.29,0.00,0.00,713.30,520709.00,0.00,0.00,0.00),('1','200','1025','257932',4906991,'3043','468',273961.62,274968.38,0.00,0.00,1006.76,734934.80,0.00,0.00,0.00),('1','200','1025','257932',4906992,'3044','468',252420.38,253044.49,0.00,0.00,624.11,455600.30,0.00,0.00,0.00),('1','200','1025','257933',4906993,'3037','468',163823.76,164694.63,0.00,0.00,870.87,670569.90,0.00,0.00,0.00),('1','200','1025','257933',4906994,'3038','468',163086.26,163938.72,0.00,0.00,852.46,656394.20,0.00,0.00,0.00),('1','200','1025','257933',4906995,'3039','468',262182.69,262182.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257933',4906996,'3040','468',266353.40,266353.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257933',4906997,'3041','468',221235.93,221572.67,0.00,0.00,336.74,245820.20,0.00,0.00,0.00),('1','200','1025','257933',4906998,'3042','468',259390.29,259707.91,0.00,0.00,317.62,231862.60,0.00,0.00,0.00),('1','200','1025','257933',4906999,'3043','468',274968.38,275454.31,0.00,0.00,485.93,354728.90,0.00,0.00,0.00),('1','200','1025','257933',4907000,'3044','468',253044.49,253292.40,0.00,0.00,247.91,180974.30,0.00,0.00,0.00),('1','200','1025','257934',4907001,'3037','468',164694.63,165905.33,0.00,0.00,1210.70,932239.00,0.00,0.00,0.00),('1','200','1025','257934',4907002,'3038','468',163938.72,165100.63,0.00,0.00,1161.91,894670.70,0.00,0.00,0.00),('1','200','1025','257934',4907003,'3039','468',262182.69,262182.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257934',4907004,'3040','468',266353.40,266353.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257934',4907005,'3041','468',221572.67,221941.67,0.00,0.00,369.00,269370.00,0.00,0.00,0.00),('1','200','1025','257934',4907006,'3042','468',259707.91,260114.41,0.00,0.00,406.50,296745.00,0.00,0.00,0.00),('1','200','1025','257934',4907007,'3043','468',275454.31,275953.81,0.00,0.00,499.50,364635.00,0.00,0.00,0.00),('1','200','1025','257934',4907008,'3044','468',253292.40,253654.40,0.00,0.00,362.00,264260.00,0.00,0.00,0.00),('1','200','1025','257935',4907009,'3037','468',165905.33,166960.90,0.00,0.00,1055.57,812788.90,0.00,0.00,0.00),('1','200','1025','257935',4907010,'3038','468',165100.63,166034.64,0.00,0.00,934.01,719187.70,0.00,0.00,0.00),('1','200','1025','257935',4907011,'3039','468',262182.69,262182.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257935',4907012,'3040','468',266353.40,266353.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257935',4907013,'3041','468',221941.67,222537.12,0.00,0.00,595.45,434678.50,0.00,0.00,0.00),('1','200','1025','257935',4907014,'3042','468',260114.41,260975.25,0.00,0.00,860.84,628413.20,0.00,0.00,0.00),('1','200','1025','257935',4907015,'3043','468',275953.81,276790.80,0.00,0.00,836.99,611002.70,0.00,0.00,0.00),('1','200','1025','257935',4907016,'3044','468',253654.40,254240.92,0.00,0.00,586.52,428159.60,0.00,0.00,0.00),('1','200','1025','257936',4907017,'3037','468',166960.90,168029.67,0.00,0.00,1068.77,822952.90,0.00,0.00,0.00),('1','200','1025','257936',4907018,'3038','468',166034.64,167255.35,0.00,0.00,1220.71,939946.70,0.00,0.00,0.00),('1','200','1025','257936',4907019,'3039','468',262182.69,262182.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257936',4907020,'3040','468',266353.40,266353.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257936',4907021,'3041','468',222537.12,223068.62,0.00,0.00,531.50,387995.00,0.00,0.00,0.00),('1','200','1025','257936',4907022,'3042','468',260975.25,261852.95,0.00,0.00,877.70,640721.00,0.00,0.00,0.00),('1','200','1025','257936',4907023,'3043','468',276790.80,277465.90,0.00,0.00,675.10,492823.00,0.00,0.00,0.00),('1','200','1025','257936',4907024,'3044','468',254240.92,254794.62,0.00,0.00,553.70,404201.00,0.00,0.00,0.00),('1','200','1025','257937',4907025,'3037','468',168029.67,168955.72,0.00,0.00,926.05,713058.50,0.00,0.00,0.00),('1','200','1025','257937',4907026,'3038','468',167255.35,168395.44,0.00,0.00,1140.09,877869.30,0.00,0.00,0.00),('1','200','1025','257937',4907027,'3039','468',262182.69,262616.30,0.00,0.00,433.61,333879.70,0.00,0.00,0.00),('1','200','1025','257937',4907028,'3040','468',266353.40,266740.86,0.00,0.00,387.46,298344.20,0.00,0.00,0.00),('1','200','1025','257937',4907029,'3041','468',223068.62,223454.96,0.00,0.00,386.34,282028.20,0.00,0.00,0.00),('1','200','1025','257937',4907030,'3042','468',261852.95,262369.91,0.00,0.00,516.96,377380.80,0.00,0.00,0.00),('1','200','1025','257937',4907031,'3043','468',277465.90,278172.23,0.00,0.00,706.33,515620.90,0.00,0.00,0.00),('1','200','1025','257937',4907032,'3044','468',254794.62,255244.02,0.00,0.00,449.40,328062.00,0.00,0.00,0.00),('1','200','1025','257938',4907033,'3037','468',168955.72,168955.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257938',4907034,'3038','468',168395.44,168395.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257938',4907035,'3039','468',262616.30,263791.82,0.00,0.00,1175.52,905150.40,0.00,0.00,0.00),('1','200','1025','257938',4907036,'3040','468',266740.86,267722.42,0.00,0.00,981.56,755801.20,0.00,0.00,0.00),('1','200','1025','257938',4907037,'3041','468',223454.96,224421.59,0.00,0.00,966.63,705639.90,0.00,0.00,0.00),('1','200','1025','257938',4907038,'3042','468',262369.91,263197.99,0.00,0.00,828.08,604498.40,0.00,0.00,0.00),('1','200','1025','257938',4907039,'3043','468',278172.23,279294.23,0.00,0.00,1122.00,819060.00,0.00,0.00,0.00),('1','200','1025','257938',4907040,'3044','468',255244.02,255911.11,0.00,0.00,667.09,486975.70,0.00,0.00,0.00),('1','200','1025','257939',4907041,'3037','468',168955.72,168955.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257939',4907042,'3038','468',168395.44,168395.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257939',4907043,'3039','468',263791.82,263976.42,0.00,0.00,184.60,142142.00,0.00,0.00,0.00),('1','200','1025','257939',4907044,'3040','468',267722.42,267911.33,0.00,0.00,188.91,145460.70,0.00,0.00,0.00),('1','200','1025','257939',4907045,'3041','468',224421.59,224479.59,0.00,0.00,58.00,42340.00,0.00,0.00,0.00),('1','200','1025','257939',4907046,'3042','468',263197.99,263284.20,0.00,0.00,86.21,62933.30,0.00,0.00,0.00),('1','200','1025','257939',4907047,'3043','468',279294.23,279427.23,0.00,0.00,133.00,97090.00,0.00,0.00,0.00),('1','200','1025','257939',4907048,'3044','468',255911.11,256015.12,0.00,0.00,104.01,75927.30,0.00,0.00,0.00),('1','200','1025','257940',4907049,'3037','468',168955.72,168955.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257940',4907050,'3038','468',168395.44,168395.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257940',4907051,'3039','468',263976.42,263976.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257940',4907052,'3040','468',267911.33,267911.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257940',4907053,'3041','468',224479.59,224479.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257940',4907054,'3042','468',263284.20,263284.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257940',4907055,'3043','468',279427.23,279427.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257940',4907056,'3044','468',256015.12,256015.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257941',4907057,'3037','468',168955.72,168955.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257941',4907058,'3038','468',168395.44,168395.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257941',4907059,'3039','468',263976.42,265022.70,0.00,0.00,1046.28,795172.80,0.00,0.00,0.00),('1','200','1025','257941',4907060,'3040','468',267911.33,268942.26,0.00,0.00,1030.93,783506.80,0.00,0.00,0.00),('1','200','1025','257941',4907061,'3041','468',224479.59,224964.09,0.00,0.00,484.50,348960.00,0.00,0.00,0.00),('1','200','1025','257941',4907062,'3042','468',263284.20,263842.16,0.00,0.00,557.96,401731.20,0.00,0.00,0.00),('1','200','1025','257941',4907063,'3043','468',279427.23,279991.23,0.00,0.00,564.00,406080.00,0.00,0.00,0.00),('1','200','1025','257941',4907064,'3044','468',256015.12,256603.57,0.00,0.00,588.45,423684.00,0.00,0.00,0.00),('1','200','1025','257942',4907065,'3037','468',168955.72,168955.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257942',4907066,'3038','468',168395.44,168395.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257942',4907067,'3039','468',265022.70,266058.49,0.00,0.00,1035.79,787200.40,0.00,0.00,0.00),('1','200','1025','257942',4907068,'3040','468',268942.26,270043.65,0.00,0.00,1101.39,834616.40,0.00,0.00,0.00),('1','200','1025','257942',4907069,'3041','468',224964.09,225350.05,0.00,0.00,385.96,277891.20,0.00,0.00,0.00),('1','200','1025','257942',4907070,'3042','468',263842.16,264452.45,0.00,0.00,610.29,439408.80,0.00,0.00,0.00),('1','200','1025','257942',4907071,'3043','468',279991.23,281052.23,0.00,0.00,1061.00,763920.00,0.00,0.00,0.00),('1','200','1025','257942',4907072,'3044','468',256603.57,257394.58,0.00,0.00,791.01,569527.20,0.00,0.00,0.00),('1','200','1025','257943',4907073,'3037','468',168955.72,169773.19,0.00,0.00,817.47,621277.20,0.00,0.00,0.00),('1','200','1025','257943',4907074,'3038','468',168395.44,169320.57,0.00,0.00,925.13,703098.80,0.00,0.00,0.00),('1','200','1025','257943',4907075,'3039','468',266058.49,266058.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257943',4907076,'3040','468',270043.65,270043.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257943',4907077,'3041','468',225350.05,226053.05,0.00,0.00,703.00,506160.00,0.00,0.00,0.00),('1','200','1025','257943',4907078,'3042','468',264452.45,265046.95,0.00,0.00,594.50,428040.00,0.00,0.00,0.00),('1','200','1025','257943',4907079,'3043','468',281052.23,281605.73,0.00,0.00,553.50,398520.00,0.00,0.00,0.00),('1','200','1025','257943',4907080,'3044','468',257394.58,257808.08,0.00,0.00,413.50,297720.00,0.00,0.00,0.00),('1','200','1025','257944',4907081,'3037','468',169773.19,170735.24,0.00,0.00,962.05,731158.00,0.00,0.00,0.00),('1','200','1025','257944',4907082,'3038','468',169320.57,170119.29,0.00,0.00,798.72,607027.20,0.00,0.00,0.00),('1','200','1025','257944',4907083,'3039','468',266058.49,266058.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257944',4907084,'3040','468',270043.65,270043.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257944',4907085,'3041','468',226053.05,226313.23,0.00,0.00,260.18,187329.60,0.00,0.00,0.00),('1','200','1025','257944',4907086,'3042','468',265046.95,265522.28,0.00,0.00,475.33,342237.60,0.00,0.00,0.00),('1','200','1025','257944',4907087,'3043','468',281605.73,282357.29,0.00,0.00,751.56,541123.20,0.00,0.00,0.00),('1','200','1025','257944',4907088,'3044','468',257808.08,258199.08,0.00,0.00,391.00,281520.00,0.00,0.00,0.00),('1','200','1025','257945',4907089,'3037','468',170735.24,170735.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257945',4907090,'3038','468',170119.29,170119.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257945',4907091,'3039','468',266058.49,267247.19,0.00,0.00,1188.70,903412.00,0.00,0.00,0.00),('1','200','1025','257945',4907092,'3040','468',270043.65,271121.00,0.00,0.00,1077.35,818786.00,0.00,0.00,0.00),('1','200','1025','257945',4907093,'3041','468',226313.23,226853.77,0.00,0.00,540.54,389188.80,0.00,0.00,0.00),('1','200','1025','257945',4907094,'3042','468',265522.28,266085.26,0.00,0.00,562.98,405345.60,0.00,0.00,0.00),('1','200','1025','257945',4907095,'3043','468',282357.29,283353.79,0.00,0.00,996.50,717480.00,0.00,0.00,0.00),('1','200','1025','257945',4907096,'3044','468',258199.08,258899.03,0.00,0.00,699.95,503964.00,0.00,0.00,0.00),('1','200','1025','257946',4907097,'3037','468',170735.24,170735.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257946',4907098,'3038','468',170119.29,170119.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257946',4907099,'3039','468',267247.19,267354.91,0.00,0.00,107.72,81867.20,0.00,0.00,0.00),('1','200','1025','257946',4907100,'3040','468',271121.00,271166.84,0.00,0.00,45.84,34838.40,0.00,0.00,0.00),('1','200','1025','257946',4907101,'3041','468',226853.77,226902.67,0.00,0.00,48.90,35208.00,0.00,0.00,0.00),('1','200','1025','257946',4907102,'3042','468',266085.26,266134.26,0.00,0.00,49.00,35280.00,0.00,0.00,0.00),('1','200','1025','257946',4907103,'3043','468',283353.79,283402.79,0.00,0.00,49.00,35280.00,0.00,0.00,0.00),('1','200','1025','257946',4907104,'3044','468',258899.03,258938.03,0.00,0.00,39.00,28080.00,0.00,0.00,0.00),('1','200','1025','257947',4907105,'3037','468',170735.24,170735.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257947',4907106,'3038','468',170119.29,170119.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257947',4907107,'3039','468',267354.91,267354.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257947',4907108,'3040','468',271166.84,271166.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257947',4907109,'3041','468',226902.67,226902.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257947',4907110,'3042','468',266134.26,266134.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257947',4907111,'3043','468',283402.79,283402.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257947',4907112,'3044','468',258938.03,258938.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257948',4907113,'3037','468',170735.24,170735.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257948',4907114,'3038','468',170119.29,170119.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257948',4907115,'3039','468',267354.91,268469.82,0.00,0.00,1114.91,847331.60,0.00,0.00,0.00),('1','200','1025','257948',4907116,'3040','468',271166.84,272152.17,0.00,0.00,985.33,748850.80,0.00,0.00,0.00),('1','200','1025','257948',4907117,'3041','468',226902.67,227504.87,0.00,0.00,602.20,433584.00,0.00,0.00,0.00),('1','200','1025','257948',4907118,'3042','468',266134.26,266684.26,0.00,0.00,550.00,396000.00,0.00,0.00,0.00),('1','200','1025','257948',4907119,'3043','468',283402.79,284055.59,0.00,0.00,652.80,470016.00,0.00,0.00,0.00),('1','200','1025','257948',4907120,'3044','468',258938.03,259343.03,0.00,0.00,405.00,291600.00,0.00,0.00,0.00),('1','200','1025','257949',4907121,'3037','468',170735.24,171796.34,0.00,0.00,1061.10,806436.00,0.00,0.00,0.00),('1','200','1025','257949',4907122,'3038','468',170119.29,171231.62,0.00,0.00,1112.33,845370.80,0.00,0.00,0.00),('1','200','1025','257949',4907123,'3039','468',268469.82,268469.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257949',4907124,'3040','468',272152.17,272152.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257949',4907125,'3041','468',227504.87,228689.37,0.00,0.00,1184.50,852840.00,0.00,0.00,0.00),('1','200','1025','257949',4907126,'3042','468',266684.26,267660.26,0.00,0.00,976.00,702720.00,0.00,0.00,0.00),('1','200','1025','257949',4907127,'3043','468',284055.59,285184.96,0.00,0.00,1129.37,813146.40,0.00,0.00,0.00),('1','200','1025','257949',4907128,'3044','468',259343.03,260414.60,0.00,0.00,1071.57,771530.40,0.00,0.00,0.00),('1','200','1025','257950',4907129,'3037','468',171796.34,172585.02,0.00,0.00,788.68,599396.80,0.00,0.00,0.00),('1','200','1025','257950',4907130,'3038','468',171231.62,172093.35,0.00,0.00,861.73,654914.80,0.00,0.00,0.00),('1','200','1025','257950',4907131,'3039','468',268469.82,268469.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257950',4907132,'3040','468',272152.17,272152.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257950',4907133,'3041','468',228689.37,229026.02,0.00,0.00,336.65,242388.00,0.00,0.00,0.00),('1','200','1025','257950',4907134,'3042','468',267660.26,268190.31,0.00,0.00,530.05,381636.00,0.00,0.00,0.00),('1','200','1025','257950',4907135,'3043','468',285184.96,285768.66,0.00,0.00,583.70,420264.00,0.00,0.00,0.00),('1','200','1025','257950',4907136,'3044','468',260414.60,260998.16,0.00,0.00,583.56,420163.20,0.00,0.00,0.00),('1','200','1025','257951',4907137,'3037','468',172585.02,172585.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257951',4907138,'3038','468',172093.35,172093.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257951',4907139,'3039','468',268469.82,269427.85,0.00,0.00,958.03,728102.80,0.00,0.00,0.00),('1','200','1025','257951',4907140,'3040','468',272152.17,273117.30,0.00,0.00,965.13,733498.80,0.00,0.00,0.00),('1','200','1025','257951',4907141,'3041','468',229026.02,229682.52,0.00,0.00,656.50,472680.00,0.00,0.00,0.00),('1','200','1025','257951',4907142,'3042','468',268190.31,268827.63,0.00,0.00,637.32,458870.40,0.00,0.00,0.00),('1','200','1025','257951',4907143,'3043','468',285768.66,286491.17,0.00,0.00,722.51,520207.20,0.00,0.00,0.00),('1','200','1025','257951',4907144,'3044','468',260998.16,261634.84,0.00,0.00,636.68,458409.60,0.00,0.00,0.00),('1','200','1025','257952',4907145,'3037','468',172585.02,172585.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257952',4907146,'3038','468',172093.35,172093.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257952',4907147,'3039','468',269427.85,270384.39,0.00,0.00,956.54,726970.40,0.00,0.00,0.00),('1','200','1025','257952',4907148,'3040','468',273117.30,273981.78,0.00,0.00,864.48,657004.80,0.00,0.00,0.00),('1','200','1025','257952',4907149,'3041','468',229682.52,230235.03,0.00,0.00,552.51,397807.20,0.00,0.00,0.00),('1','200','1025','257952',4907150,'3042','468',268827.63,269388.13,0.00,0.00,560.50,403560.00,0.00,0.00,0.00),('1','200','1025','257952',4907151,'3043','468',286491.17,287301.67,0.00,0.00,810.50,583560.00,0.00,0.00,0.00),('1','200','1025','257952',4907152,'3044','468',261634.84,262426.72,0.00,0.00,791.88,570153.60,0.00,0.00,0.00),('1','200','1025','257953',4907153,'3037','468',172585.02,172585.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257953',4907154,'3038','468',172093.35,172093.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257953',4907155,'3039','468',270384.39,271198.82,0.00,0.00,814.43,618966.80,0.00,0.00,0.00),('1','200','1025','257953',4907156,'3040','468',273981.78,274797.95,0.00,0.00,816.17,620289.20,0.00,0.00,0.00),('1','200','1025','257953',4907157,'3041','468',230235.03,230618.41,0.00,0.00,383.38,276033.60,0.00,0.00,0.00),('1','200','1025','257953',4907158,'3042','468',269388.13,269813.53,0.00,0.00,425.40,306288.00,0.00,0.00,0.00),('1','200','1025','257953',4907159,'3043','468',287301.67,287836.08,0.00,0.00,534.41,384775.20,0.00,0.00,0.00),('1','200','1025','257953',4907160,'3044','468',262426.72,262983.82,0.00,0.00,557.10,401112.00,0.00,0.00,0.00),('1','200','1025','257954',4907161,'3037','468',172585.02,172585.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257954',4907162,'3038','468',172093.35,172093.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257954',4907163,'3039','468',271198.82,272403.48,0.00,0.00,1204.66,915541.60,0.00,0.00,0.00),('1','200','1025','257954',4907164,'3040','468',274797.95,275969.06,0.00,0.00,1171.11,890043.60,0.00,0.00,0.00),('1','200','1025','257954',4907165,'3041','468',230618.41,231073.40,0.00,0.00,454.99,327592.80,0.00,0.00,0.00),('1','200','1025','257954',4907166,'3042','468',269813.53,270588.57,0.00,0.00,775.04,558028.80,0.00,0.00,0.00),('1','200','1025','257954',4907167,'3043','468',287836.08,288738.08,0.00,0.00,902.00,649440.00,0.00,0.00,0.00),('1','200','1025','257954',4907168,'3044','468',262983.82,263822.15,0.00,0.00,838.33,610170.80,0.00,0.00,0.00),('1','200','1025','257955',4907169,'3037','468',172585.02,172585.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257955',4907170,'3038','468',172093.35,172093.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257955',4907171,'3039','468',272403.48,273506.78,0.00,0.00,1103.30,838508.00,0.00,0.00,0.00),('1','200','1025','257955',4907172,'3040','468',275969.06,277004.77,0.00,0.00,1035.71,787139.60,0.00,0.00,0.00),('1','200','1025','257955',4907173,'3041','468',231073.40,231345.39,0.00,0.00,271.99,195832.80,0.00,0.00,0.00),('1','200','1025','257955',4907174,'3042','468',270588.57,270989.16,0.00,0.00,400.59,288424.80,0.00,0.00,0.00),('1','200','1025','257955',4907175,'3043','468',288738.08,289254.08,0.00,0.00,516.00,371520.00,0.00,0.00,0.00),('1','200','1025','257955',4907176,'3044','468',263822.15,264280.11,0.00,0.00,457.96,329731.20,0.00,0.00,0.00),('1','200','1025','257956',4907177,'3037','468',172585.02,172585.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257956',4907178,'3038','468',172093.35,172093.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257956',4907179,'3039','468',273506.78,274291.41,0.00,0.00,784.63,596318.80,0.00,0.00,0.00),('1','200','1025','257956',4907180,'3040','468',277004.77,277778.78,0.00,0.00,774.01,588247.60,0.00,0.00,0.00),('1','200','1025','257956',4907181,'3041','468',231345.39,232021.04,0.00,0.00,675.65,486468.00,0.00,0.00,0.00),('1','200','1025','257956',4907182,'3042','468',270989.16,271672.66,0.00,0.00,683.50,492120.00,0.00,0.00,0.00),('1','200','1025','257956',4907183,'3043','468',289254.08,289860.58,0.00,0.00,606.50,436680.00,0.00,0.00,0.00),('1','200','1025','257956',4907184,'3044','468',264280.11,264894.71,0.00,0.00,614.60,442512.00,0.00,0.00,0.00),('1','200','1025','257957',4907185,'3037','468',172585.02,173444.46,0.00,0.00,859.44,653174.40,0.00,0.00,0.00),('1','200','1025','257957',4907186,'3038','468',172093.35,173144.48,0.00,0.00,1051.13,798858.80,0.00,0.00,0.00),('1','200','1025','257957',4907187,'3039','468',274291.41,274291.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257957',4907188,'3040','468',277778.78,277778.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257957',4907189,'3041','468',232021.04,232768.03,0.00,0.00,746.99,537832.80,0.00,0.00,0.00),('1','200','1025','257957',4907190,'3042','468',271672.66,272472.66,0.00,0.00,800.00,576000.00,0.00,0.00,0.00),('1','200','1025','257957',4907191,'3043','468',289860.58,290823.58,0.00,0.00,963.00,695160.00,0.00,0.00,0.00),('1','200','1025','257957',4907192,'3044','468',264894.71,265652.21,0.00,0.00,757.50,545400.00,0.00,0.00,0.00),('1','200','1025','257958',4907193,'3037','468',173444.46,174587.07,0.00,0.00,1142.61,868383.60,0.00,0.00,0.00),('1','200','1025','257958',4907194,'3038','468',173144.48,174385.01,0.00,0.00,1240.53,942802.80,0.00,0.00,0.00),('1','200','1025','257958',4907195,'3039','468',274291.41,274291.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257958',4907196,'3040','468',277778.78,277778.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257958',4907197,'3041','468',232768.03,233310.03,0.00,0.00,542.00,390240.00,0.00,0.00,0.00),('1','200','1025','257958',4907198,'3042','468',272472.66,273214.37,0.00,0.00,741.71,534031.20,0.00,0.00,0.00),('1','200','1025','257958',4907199,'3043','468',290823.58,291626.04,0.00,0.00,802.46,577771.20,0.00,0.00,0.00),('1','200','1025','257958',4907200,'3044','468',265652.21,266179.47,0.00,0.00,527.26,379627.20,0.00,0.00,0.00),('1','200','1025','257959',4907201,'3037','468',174587.07,176101.51,0.00,0.00,1514.44,1150974.40,0.00,0.00,0.00),('1','200','1025','257959',4907202,'3038','468',174385.01,175908.90,0.00,0.00,1523.89,1158156.40,0.00,0.00,0.00),('1','200','1025','257959',4907203,'3039','468',274291.41,274291.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257959',4907204,'3040','468',277778.78,277778.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257959',4907205,'3041','468',233310.03,234202.73,0.00,0.00,892.70,642744.00,0.00,0.00,0.00),('1','200','1025','257959',4907206,'3042','468',273214.37,274486.58,0.00,0.00,1272.21,915991.20,0.00,0.00,0.00),('1','200','1025','257959',4907207,'3043','468',291626.04,292982.66,0.00,0.00,1356.62,976766.40,0.00,0.00,0.00),('1','200','1025','257959',4907208,'3044','468',266179.47,267130.61,0.00,0.00,951.14,684820.80,0.00,0.00,0.00),('1','200','1025','257960',4907209,'3037','468',176101.51,178194.31,0.00,0.00,2092.80,1590528.00,0.00,0.00,0.00),('1','200','1025','257960',4907210,'3038','468',175908.90,177830.92,0.00,0.00,1922.02,1460735.20,0.00,0.00,0.00),('1','200','1025','257960',4907211,'3039','468',274291.41,274291.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257960',4907212,'3040','468',277778.78,277778.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257960',4907213,'3041','468',234202.73,235486.73,0.00,0.00,1284.00,924480.00,0.00,0.00,0.00),('1','200','1025','257960',4907214,'3042','468',274486.58,275875.08,0.00,0.00,1388.50,999720.00,0.00,0.00,0.00),('1','200','1025','257960',4907215,'3043','468',292982.66,294543.76,0.00,0.00,1561.10,1123992.00,0.00,0.00,0.00),('1','200','1025','257960',4907216,'3044','468',267130.61,268380.13,0.00,0.00,1249.52,899654.40,0.00,0.00,0.00),('1','200','1025','257961',4907217,'3037','468',178194.31,179821.44,0.00,0.00,1627.13,1236618.80,0.00,0.00,0.00),('1','200','1025','257961',4907218,'3038','468',177830.92,179310.62,0.00,0.00,1479.70,1124572.00,0.00,0.00,0.00),('1','200','1025','257961',4907219,'3039','468',274291.41,274291.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257961',4907220,'3040','468',277778.78,277778.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257961',4907221,'3041','468',235486.73,236992.10,0.00,0.00,1505.37,1083866.40,0.00,0.00,0.00),('1','200','1025','257961',4907222,'3042','468',275875.08,277399.22,0.00,0.00,1524.14,1097380.80,0.00,0.00,0.00),('1','200','1025','257961',4907223,'3043','468',294543.76,296013.27,0.00,0.00,1469.51,1058047.20,0.00,0.00,0.00),('1','200','1025','257961',4907224,'3044','468',268380.13,269620.93,0.00,0.00,1240.80,893376.00,0.00,0.00,0.00),('1','200','1025','257962',4907225,'3037','468',179821.44,181649.14,0.00,0.00,1827.70,1389052.00,0.00,0.00,0.00),('1','200','1025','257962',4907226,'3038','468',179310.62,181042.08,0.00,0.00,1731.46,1313509.60,0.00,0.00,0.00),('1','200','1025','257962',4907227,'3039','468',274291.41,274291.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257962',4907228,'3040','468',277778.78,277778.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257962',4907229,'3041','468',236992.10,238003.84,0.00,0.00,1011.74,728452.80,0.00,0.00,0.00),('1','200','1025','257962',4907230,'3042','468',277399.22,278338.52,0.00,0.00,939.30,676296.00,0.00,0.00,0.00),('1','200','1025','257962',4907231,'3043','468',296013.27,297189.09,0.00,0.00,1175.82,846590.40,0.00,0.00,0.00),('1','200','1025','257962',4907232,'3044','468',269620.93,270621.01,0.00,0.00,1000.08,720057.60,0.00,0.00,0.00),('1','200','1025','257963',4907233,'3037','468',181649.14,183059.93,0.00,0.00,1410.79,1072200.40,0.00,0.00,0.00),('1','200','1025','257963',4907234,'3038','468',181042.08,182481.21,0.00,0.00,1439.13,1093738.80,0.00,0.00,0.00),('1','200','1025','257963',4907235,'3039','468',274291.41,274291.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257963',4907236,'3040','468',277778.78,277778.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257963',4907237,'3041','468',238003.84,238367.37,0.00,0.00,363.53,261741.60,0.00,0.00,0.00),('1','200','1025','257963',4907238,'3042','468',278338.52,279033.73,0.00,0.00,695.21,500551.20,0.00,0.00,0.00),('1','200','1025','257963',4907239,'3043','468',297189.09,297854.75,0.00,0.00,665.66,479275.20,0.00,0.00,0.00),('1','200','1025','257963',4907240,'3044','468',270621.01,271175.80,0.00,0.00,554.79,399448.80,0.00,0.00,0.00),('1','200','1025','257964',4907241,'3037','468',183059.93,184215.51,0.00,0.00,1155.58,878240.80,0.00,0.00,0.00),('1','200','1025','257964',4907242,'3038','468',182481.21,183595.29,0.00,0.00,1114.08,846700.80,0.00,0.00,0.00),('1','200','1025','257964',4907243,'3039','468',274291.41,274291.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257964',4907244,'3040','468',277778.78,277778.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257964',4907245,'3041','468',238367.37,238921.99,0.00,0.00,554.62,399326.40,0.00,0.00,0.00),('1','200','1025','257964',4907246,'3042','468',279033.73,279867.04,0.00,0.00,833.31,599983.20,0.00,0.00,0.00),('1','200','1025','257964',4907247,'3043','468',297854.75,298782.25,0.00,0.00,927.50,667800.00,0.00,0.00,0.00),('1','200','1025','257964',4907248,'3044','468',271175.80,271872.23,0.00,0.00,696.43,501429.60,0.00,0.00,0.00),('1','200','1025','257965',4907249,'3037','468',184215.51,184223.88,0.00,0.00,8.37,6361.20,0.00,0.00,0.00),('1','200','1025','257965',4907250,'3038','468',183595.29,183714.03,0.00,0.00,118.74,90242.40,0.00,0.00,0.00),('1','200','1025','257965',4907251,'3039','468',274291.41,275310.54,0.00,0.00,1019.13,774538.80,0.00,0.00,0.00),('1','200','1025','257965',4907252,'3040','468',277778.78,278776.59,0.00,0.00,997.81,758335.60,0.00,0.00,0.00),('1','200','1025','257965',4907253,'3041','468',238921.99,239446.21,0.00,0.00,524.22,377438.40,0.00,0.00,0.00),('1','200','1025','257965',4907254,'3042','468',279867.04,280457.97,0.00,0.00,590.93,425469.60,0.00,0.00,0.00),('1','200','1025','257965',4907255,'3043','468',298782.25,299538.25,0.00,0.00,756.00,544320.00,0.00,0.00,0.00),('1','200','1025','257965',4907256,'3044','468',271872.23,272410.22,0.00,0.00,537.99,387352.80,0.00,0.00,0.00),('1','200','1025','257966',4907257,'3037','468',184223.88,184409.25,0.00,0.00,185.37,140881.20,0.00,0.00,0.00),('1','200','1025','257966',4907258,'3038','468',183714.03,183812.10,0.00,0.00,98.07,74533.20,0.00,0.00,0.00),('1','200','1025','257966',4907259,'3039','468',275310.54,275318.91,0.00,0.00,8.37,6361.20,0.00,0.00,0.00),('1','200','1025','257966',4907260,'3040','468',278776.59,278895.33,0.00,0.00,118.74,90242.40,0.00,0.00,0.00),('1','200','1025','257966',4907261,'3041','468',239446.21,239452.08,0.00,0.00,5.87,4226.40,0.00,0.00,0.00),('1','200','1025','257966',4907262,'3042','468',280457.97,280624.38,0.00,0.00,166.41,119815.20,0.00,0.00,0.00),('1','200','1025','257966',4907263,'3043','468',299538.25,299656.52,0.00,0.00,118.27,85154.40,0.00,0.00,0.00),('1','200','1025','257966',4907264,'3044','468',272410.22,272478.44,0.00,0.00,68.22,49118.40,0.00,0.00,0.00),('1','200','1025','257967',4907265,'3037','468',184409.25,184409.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257967',4907266,'3038','468',183812.10,183812.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257967',4907267,'3039','468',275318.91,275318.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257967',4907268,'3040','468',278895.33,278895.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257967',4907269,'3041','468',239452.08,239452.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257967',4907270,'3042','468',280624.38,280624.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257967',4907271,'3043','468',299656.52,299656.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257967',4907272,'3044','468',272478.44,272478.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257968',4907273,'3037','468',184409.25,184923.01,0.00,0.00,513.76,390457.60,0.00,0.00,0.00),('1','200','1025','257968',4907274,'3038','468',183812.10,184332.35,0.00,0.00,520.25,395390.00,0.00,0.00,0.00),('1','200','1025','257968',4907275,'3039','468',275318.91,275318.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257968',4907276,'3040','468',278895.33,278895.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257968',4907277,'3041','468',239452.08,239781.68,0.00,0.00,329.60,237312.00,0.00,0.00,0.00),('1','200','1025','257968',4907278,'3042','468',280624.38,280885.88,0.00,0.00,261.50,188280.00,0.00,0.00,0.00),('1','200','1025','257968',4907279,'3043','468',299656.52,299968.89,0.00,0.00,312.37,224906.40,0.00,0.00,0.00),('1','200','1025','257968',4907280,'3044','468',272478.44,272597.91,0.00,0.00,119.47,86018.40,0.00,0.00,0.00),('1','200','1025','257969',4907281,'3037','468',184923.01,186107.05,0.00,0.00,1184.04,899870.40,0.00,0.00,0.00),('1','200','1025','257969',4907282,'3038','468',184332.35,185562.76,0.00,0.00,1230.41,935111.60,0.00,0.00,0.00),('1','200','1025','257969',4907283,'3039','468',275318.91,275318.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257969',4907284,'3040','468',278895.33,278895.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257969',4907285,'3041','468',239781.68,240263.60,0.00,0.00,481.92,346982.40,0.00,0.00,0.00),('1','200','1025','257969',4907286,'3042','468',280885.88,281604.31,0.00,0.00,718.43,517269.60,0.00,0.00,0.00),('1','200','1025','257969',4907287,'3043','468',299968.89,301095.22,0.00,0.00,1126.33,810957.60,0.00,0.00,0.00),('1','200','1025','257969',4907288,'3044','468',272597.91,273079.91,0.00,0.00,482.00,347040.00,0.00,0.00,0.00),('1','200','1025','257970',4907289,'3037','468',186107.05,187471.77,0.00,0.00,1364.72,1037187.20,0.00,0.00,0.00),('1','200','1025','257970',4907290,'3038','468',185562.76,186736.92,0.00,0.00,1174.16,892361.60,0.00,0.00,0.00),('1','200','1025','257970',4907291,'3039','468',275318.91,275318.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257970',4907292,'3040','468',278895.33,278895.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257970',4907293,'3041','468',240263.60,240667.08,0.00,0.00,403.48,290505.60,0.00,0.00,0.00),('1','200','1025','257970',4907294,'3042','468',281604.31,282458.61,0.00,0.00,854.30,615096.00,0.00,0.00,0.00),('1','200','1025','257970',4907295,'3043','468',301095.22,301778.22,0.00,0.00,683.00,491760.00,0.00,0.00,0.00),('1','200','1025','257970',4907296,'3044','468',273079.91,273624.41,0.00,0.00,544.50,392040.00,0.00,0.00,0.00),('1','200','1025','257971',4907297,'3037','468',187471.77,188211.47,0.00,0.00,739.70,562172.00,0.00,0.00,0.00),('1','200','1025','257971',4907298,'3038','468',186736.92,187563.46,0.00,0.00,826.54,628170.40,0.00,0.00,0.00),('1','200','1025','257971',4907299,'3039','468',275318.91,275318.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257971',4907300,'3040','468',278895.33,278895.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257971',4907301,'3041','468',240667.08,240947.91,0.00,0.00,280.83,202197.60,0.00,0.00,0.00),('1','200','1025','257971',4907302,'3042','468',282458.61,282857.07,0.00,0.00,398.46,286891.20,0.00,0.00,0.00),('1','200','1025','257971',4907303,'3043','468',301778.22,302242.59,0.00,0.00,464.37,334346.40,0.00,0.00,0.00),('1','200','1025','257971',4907304,'3044','468',273624.41,273987.05,0.00,0.00,362.64,261100.80,0.00,0.00,0.00),('1','200','1025','257972',4907305,'3037','468',188211.47,188211.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257972',4907306,'3038','468',187563.46,187563.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257972',4907307,'3039','468',275318.91,275318.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257972',4907308,'3040','468',278895.33,278895.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257972',4907309,'3041','468',240947.91,240947.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257972',4907310,'3042','468',282857.07,282857.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257972',4907311,'3043','468',302242.59,302242.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257972',4907312,'3044','468',273987.05,273987.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257973',4907313,'3037','468',188211.47,189254.50,0.00,0.00,1043.03,792702.80,0.00,0.00,0.00),('1','200','1025','257973',4907314,'3038','468',187563.46,188704.07,0.00,0.00,1140.61,866863.60,0.00,0.00,0.00),('1','200','1025','257973',4907315,'3039','468',275318.91,275318.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257973',4907316,'3040','468',278895.33,278895.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257973',4907317,'3041','468',240947.91,241873.39,0.00,0.00,925.48,666345.60,0.00,0.00,0.00),('1','200','1025','257973',4907318,'3042','468',282857.07,283766.79,0.00,0.00,909.72,654998.40,0.00,0.00,0.00),('1','200','1025','257973',4907319,'3043','468',302242.59,303130.36,0.00,0.00,887.77,639194.40,0.00,0.00,0.00),('1','200','1025','257973',4907320,'3044','468',273987.05,274760.55,0.00,0.00,773.50,556920.00,0.00,0.00,0.00),('1','200','1025','257974',4907321,'3037','468',189254.50,190408.04,0.00,0.00,1153.54,876690.40,0.00,0.00,0.00),('1','200','1025','257974',4907322,'3038','468',188704.07,189823.95,0.00,0.00,1119.88,851108.80,0.00,0.00,0.00),('1','200','1025','257974',4907323,'3039','468',275318.91,275318.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257974',4907324,'3040','468',278895.33,278895.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257974',4907325,'3041','468',241873.39,242073.33,0.00,0.00,199.94,135959.20,0.00,0.00,0.00),('1','200','1025','257974',4907326,'3042','468',283766.79,284005.08,0.00,0.00,238.29,162037.20,0.00,0.00,0.00),('1','200','1025','257974',4907327,'3043','468',303130.36,303425.30,0.00,0.00,294.94,200559.20,0.00,0.00,0.00),('1','200','1025','257974',4907328,'3044','468',274760.55,275145.11,0.00,0.00,384.56,261500.80,0.00,0.00,0.00),('1','200','1025','257975',4907329,'3037','468',190408.04,191449.64,0.00,0.00,1041.60,791616.00,0.00,0.00,0.00),('1','200','1025','257975',4907330,'3038','468',189823.95,190854.80,0.00,0.00,1030.85,783446.00,0.00,0.00,0.00),('1','200','1025','257975',4907331,'3039','468',275318.91,275318.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257975',4907332,'3040','468',278895.33,278895.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257975',4907333,'3041','468',242073.33,242546.82,0.00,0.00,473.49,321973.20,0.00,0.00,0.00),('1','200','1025','257975',4907334,'3042','468',284005.08,284750.23,0.00,0.00,745.15,506702.00,0.00,0.00,0.00),('1','200','1025','257975',4907335,'3043','468',303425.30,304071.30,0.00,0.00,646.00,439280.00,0.00,0.00,0.00),('1','200','1025','257975',4907336,'3044','468',275145.11,275774.61,0.00,0.00,629.50,428060.00,0.00,0.00,0.00),('1','200','1025','257976',4907337,'3037','468',191449.64,191449.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257976',4907338,'3038','468',190854.80,190854.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257976',4907339,'3039','468',275318.91,276362.83,0.00,0.00,1043.92,793379.20,0.00,0.00,0.00),('1','200','1025','257976',4907340,'3040','468',278895.33,279964.84,0.00,0.00,1069.51,812827.60,0.00,0.00,0.00),('1','200','1025','257976',4907341,'3041','468',242546.82,243353.07,0.00,0.00,806.25,548250.00,0.00,0.00,0.00),('1','200','1025','257976',4907342,'3042','468',284750.23,285830.35,0.00,0.00,1080.12,734481.60,0.00,0.00,0.00),('1','200','1025','257976',4907343,'3043','468',304071.30,305655.14,0.00,0.00,1583.84,1077011.20,0.00,0.00,0.00),('1','200','1025','257976',4907344,'3044','468',275774.61,276743.72,0.00,0.00,969.11,658994.80,0.00,0.00,0.00),('1','200','1025','257977',4907345,'3037','468',191449.64,191449.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257977',4907346,'3038','468',190854.80,190854.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257977',4907347,'3039','468',276362.83,276795.76,0.00,0.00,432.93,329026.80,0.00,0.00,0.00),('1','200','1025','257977',4907348,'3040','468',279964.84,280387.71,0.00,0.00,422.87,321381.20,0.00,0.00,0.00),('1','200','1025','257977',4907349,'3041','468',243353.07,243353.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257977',4907350,'3042','468',285830.35,285830.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257977',4907351,'3043','468',305655.14,305655.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257977',4907352,'3044','468',276743.72,276743.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257978',4907353,'3037','468',191449.64,191449.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257978',4907354,'3038','468',190854.80,190854.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257978',4907355,'3039','468',276795.76,276795.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257978',4907356,'3040','468',280387.71,280387.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257978',4907357,'3041','468',243353.07,243353.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257978',4907358,'3042','468',285830.35,285830.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257978',4907359,'3043','468',305655.14,305655.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257978',4907360,'3044','468',276743.72,276743.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257979',4907361,'3037','468',191449.64,191449.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257979',4907362,'3038','468',190854.80,190854.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257979',4907363,'3039','468',276795.76,277495.63,0.00,0.00,699.87,531901.20,0.00,0.00,0.00),('1','200','1025','257979',4907364,'3040','468',280387.71,281143.06,0.00,0.00,755.35,574066.00,0.00,0.00,0.00),('1','200','1025','257979',4907365,'3041','468',243353.07,243684.31,0.00,0.00,331.24,225243.20,0.00,0.00,0.00),('1','200','1025','257979',4907366,'3042','468',285830.35,286233.64,0.00,0.00,403.29,274237.20,0.00,0.00,0.00),('1','200','1025','257979',4907367,'3043','468',305655.14,306095.41,0.00,0.00,440.27,299383.60,0.00,0.00,0.00),('1','200','1025','257979',4907368,'3044','468',276743.72,277149.47,0.00,0.00,405.75,275910.00,0.00,0.00,0.00),('1','200','1025','257980',4907369,'3037','468',191449.64,191449.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257980',4907370,'3038','468',190854.80,190854.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257980',4907371,'3039','468',277495.63,278813.19,0.00,0.00,1317.56,1001345.60,0.00,0.00,0.00),('1','200','1025','257980',4907372,'3040','468',281143.06,282397.60,0.00,0.00,1254.54,953450.40,0.00,0.00,0.00),('1','200','1025','257980',4907373,'3041','468',243684.31,244015.24,0.00,0.00,330.93,225032.40,0.00,0.00,0.00),('1','200','1025','257980',4907374,'3042','468',286233.64,286673.43,0.00,0.00,439.79,299057.20,0.00,0.00,0.00),('1','200','1025','257980',4907375,'3043','468',306095.41,306732.41,0.00,0.00,637.00,433160.00,0.00,0.00,0.00),('1','200','1025','257980',4907376,'3044','468',277149.47,277661.39,0.00,0.00,511.92,348105.60,0.00,0.00,0.00),('1','200','1025','257981',4907377,'3037','468',191449.64,192320.11,0.00,0.00,870.47,661557.20,0.00,0.00,0.00),('1','200','1025','257981',4907378,'3038','468',190854.80,192072.61,0.00,0.00,1217.81,925535.60,0.00,0.00,0.00),('1','200','1025','257981',4907379,'3039','468',278813.19,278813.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257981',4907380,'3040','468',282397.60,282397.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257981',4907381,'3041','468',244015.24,244912.04,0.00,0.00,896.80,609824.00,0.00,0.00,0.00),('1','200','1025','257981',4907382,'3042','468',286673.43,287581.93,0.00,0.00,908.50,617780.00,0.00,0.00,0.00),('1','200','1025','257981',4907383,'3043','468',306732.41,307569.41,0.00,0.00,837.00,569160.00,0.00,0.00,0.00),('1','200','1025','257981',4907384,'3044','468',277661.39,278217.89,0.00,0.00,556.50,378420.00,0.00,0.00,0.00),('1','200','1025','257982',4907385,'3037','468',192320.11,193406.50,0.00,0.00,1086.39,825656.40,0.00,0.00,0.00),('1','200','1025','257982',4907386,'3038','468',192072.61,193300.32,0.00,0.00,1227.71,933059.60,0.00,0.00,0.00),('1','200','1025','257982',4907387,'3039','468',278813.19,278813.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257982',4907388,'3040','468',282397.60,282397.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257982',4907389,'3041','468',244912.04,245646.52,0.00,0.00,734.48,499446.40,0.00,0.00,0.00),('1','200','1025','257982',4907390,'3042','468',287581.93,288389.63,0.00,0.00,807.70,549236.00,0.00,0.00,0.00),('1','200','1025','257982',4907391,'3043','468',307569.41,308482.47,0.00,0.00,913.06,622080.80,0.00,0.00,0.00),('1','200','1025','257982',4907392,'3044','468',278217.89,278965.44,0.00,0.00,747.55,508334.00,0.00,0.00,0.00),('1','200','1025','257983',4907393,'3037','468',193406.50,194674.44,0.00,0.00,1267.94,963634.40,0.00,0.00,0.00),('1','200','1025','257983',4907394,'3038','468',193300.32,194729.70,0.00,0.00,1429.38,1086328.80,0.00,0.00,0.00),('1','200','1025','257983',4907395,'3039','468',278813.19,278813.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257983',4907396,'3040','468',282397.60,282397.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257983',4907397,'3041','468',245646.52,246779.31,0.00,0.00,1132.79,770297.20,0.00,0.00,0.00),('1','200','1025','257983',4907398,'3042','468',288389.63,289815.63,0.00,0.00,1426.00,969680.00,0.00,0.00,0.00),('1','200','1025','257983',4907399,'3043','468',308482.47,309890.98,0.00,0.00,1408.51,957786.80,0.00,0.00,0.00),('1','200','1025','257983',4907400,'3044','468',278965.44,279766.70,0.00,0.00,801.26,544856.80,0.00,0.00,0.00),('1','200','1025','257984',4907401,'3037','468',194674.44,196335.10,0.00,0.00,1660.66,1262101.60,0.00,0.00,0.00),('1','200','1025','257984',4907402,'3038','468',194729.70,196414.04,0.00,0.00,1684.34,1280098.40,0.00,0.00,0.00),('1','200','1025','257984',4907403,'3039','468',278813.19,278813.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257984',4907404,'3040','468',282397.60,282397.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257984',4907405,'3041','468',246779.31,247698.97,0.00,0.00,919.66,625368.80,0.00,0.00,0.00),('1','200','1025','257984',4907406,'3042','468',289815.63,290786.42,0.00,0.00,970.79,660137.20,0.00,0.00,0.00),('1','200','1025','257984',4907407,'3043','468',309890.98,311153.94,0.00,0.00,1262.96,858812.80,0.00,0.00,0.00),('1','200','1025','257984',4907408,'3044','468',279766.70,280890.82,0.00,0.00,1124.12,764401.60,0.00,0.00,0.00),('1','200','1025','257985',4907409,'3037','468',196335.10,198098.31,0.00,0.00,1763.21,1338919.60,0.00,0.00,0.00),('1','200','1025','257985',4907410,'3038','468',196414.04,197994.58,0.00,0.00,1580.54,1201210.40,0.00,0.00,0.00),('1','200','1025','257985',4907411,'3039','468',278813.19,278813.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257985',4907412,'3040','468',282397.60,282397.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257985',4907413,'3041','468',247698.97,248731.67,0.00,0.00,1032.70,702236.00,0.00,0.00,0.00),('1','200','1025','257985',4907414,'3042','468',290786.42,292435.79,0.00,0.00,1649.37,1121571.60,0.00,0.00,0.00),('1','200','1025','257985',4907415,'3043','468',311153.94,312929.53,0.00,0.00,1775.59,1207401.20,0.00,0.00,0.00),('1','200','1025','257985',4907416,'3044','468',280890.82,282089.44,0.00,0.00,1198.62,815061.60,0.00,0.00,0.00),('1','200','1025','257986',4907417,'3037','468',198098.31,199919.00,0.00,0.00,1820.69,1383724.40,0.00,0.00,0.00),('1','200','1025','257986',4907418,'3038','468',197994.58,199680.78,0.00,0.00,1686.20,1281512.00,0.00,0.00,0.00),('1','200','1025','257986',4907419,'3039','468',278813.19,278813.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257986',4907420,'3040','468',282397.60,282397.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257986',4907421,'3041','468',248731.67,249797.99,0.00,0.00,1066.32,725097.60,0.00,0.00,0.00),('1','200','1025','257986',4907422,'3042','468',292435.79,293634.81,0.00,0.00,1199.02,815333.60,0.00,0.00,0.00),('1','200','1025','257986',4907423,'3043','468',312929.53,314333.50,0.00,0.00,1403.97,954699.60,0.00,0.00,0.00),('1','200','1025','257986',4907424,'3044','468',282089.44,283562.98,0.00,0.00,1473.54,1002007.20,0.00,0.00,0.00),('1','200','1025','257987',4907425,'3037','468',199919.00,199919.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257987',4907426,'3038','468',199680.78,199680.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','200','1025','257987',4907427,'3039','468',278813.19,280320.54,0.00,0.00,1507.35,1145586.00,0.00,0.00,0.00),('1','200','1025','257987',4907428,'3040','468',282397.60,284120.13,0.00,0.00,1722.53,1309122.80,0.00,0.00,0.00),('1','200','1025','257987',4907429,'3041','468',249797.99,250711.46,0.00,0.00,913.47,621159.60,0.00,0.00,0.00),('1','200','1025','257987',4907430,'3042','468',293634.81,294856.16,0.00,0.00,1221.35,830518.15,0.00,0.00,0.00),('1','200','1025','257987',4907431,'3043','468',314333.50,315425.50,0.00,0.00,1092.00,742560.00,0.00,0.00,0.00),('1','200','1025','257987',4907432,'3044','468',283562.98,284583.98,0.00,0.00,1021.00,694280.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730140 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','200','243697','468',586.00,656.00,0.00,706.01,413721.86,443664.04,29942.18,694012),('1','200','243883','468',586.00,656.00,0.00,757.42,443848.12,482287.52,38439.40,694502),('1','200','244055','468',586.00,656.00,0.00,1329.80,779262.80,841856.80,62594.00,694936),('1','200','244302','468',586.00,656.00,0.00,1879.49,1101381.14,1184237.44,82856.30,695592),('1','200','244504','468',586.00,656.00,0.00,1524.64,893439.04,966719.84,73280.80,696123),('1','200','244726','468',586.00,656.00,0.00,1431.88,839081.68,913483.28,74401.60,696711),('1','200','244955','468',586.00,656.00,0.00,1914.10,1121662.60,1202603.60,80941.00,697308),('1','200','245198','468',586.00,656.00,0.00,2684.81,1573298.66,1692331.36,119032.70,697926),('1','200','245424','468',586.00,656.00,0.00,1797.58,1053381.88,1139414.48,86032.60,698509),('1','200','245664','468',586.00,656.00,0.00,1556.15,911903.90,989748.40,77844.50,699129),('1','200','245924','468',586.00,632.00,0.00,1731.92,1014905.12,1059629.44,44724.32,699809),('1','200','246174','468',586.00,632.00,0.00,1684.87,987333.82,1033893.84,46560.02,700447),('1','200','246464','468',586.00,632.00,0.00,2591.99,1518906.14,1580969.68,62063.54,701203),('1','200','246702','468',586.00,632.00,0.00,1434.17,840423.62,882555.44,42131.82,701832),('1','200','246937','468',586.00,632.00,0.00,3758.00,2202188.00,2289280.00,87092.00,702434),('1','200','247172','468',586.00,632.00,0.00,2138.21,1252991.06,1313940.72,60949.66,703043),('1','200','247409','468',586.00,632.00,0.00,1606.62,941479.32,996740.64,55261.32,703634),('1','200','247673','468',586.00,632.00,0.00,2121.41,1199705.98,1262472.64,62766.66,704334),('1','200','247912','468',560.00,616.00,0.00,2179.32,1220419.20,1296525.12,76105.92,704952),('1','200','248163','468',560.00,616.00,0.00,2892.44,1619766.40,1709567.72,89801.32,705598),('1','200','248415','468',560.00,616.00,0.00,4593.61,2572421.60,2705211.76,132790.16,706248),('1','200','248650','468',560.00,616.00,0.00,2953.08,1653724.80,1763225.28,109500.48,706845),('1','200','248877','468',560.00,616.00,0.00,1582.24,886054.40,943892.08,57837.68,707437),('1','200','249024','468',560.00,616.00,0.00,0.00,0.00,0.00,0.00,707823),('1','200','249062','468',540.00,600.00,0.00,915.18,494197.20,531948.60,37751.40,707929),('1','200','249118','468',540.00,600.00,0.00,2831.32,1528912.80,1644807.00,115894.20,708047),('1','200','249364','468',540.00,600.00,0.00,3109.32,1679032.80,1802217.00,123184.20,708672),('1','200','249609','468',540.00,600.00,0.00,2427.35,1310769.00,1417414.80,106645.80,709300),('1','200','249874','468',540.00,600.00,0.00,3004.81,1622597.40,1752606.00,130008.60,709983),('1','200','250102','468',540.00,600.00,0.00,2806.89,1515720.60,1631812.50,116091.90,710571),('1','200','250356','468',540.00,600.00,0.00,2843.10,1535274.00,1655565.00,120291.00,711207),('1','200','250563','468',540.00,600.00,0.00,2289.10,1236114.00,1338570.00,102456.00,711744),('1','200','250817','468',540.00,600.00,0.00,2777.78,1500001.20,1614843.90,114842.70,712396),('1','200','251044','468',540.00,600.00,0.00,2742.65,1481031.00,1599435.00,118404.00,712984),('1','200','251278','468',530.00,576.00,0.00,2973.70,1576061.00,1652467.20,76406.20,713598),('1','200','251526','468',530.00,576.00,0.00,3602.52,1909335.60,2001483.52,92147.92,714247),('1','200','251772','468',530.00,576.00,0.00,2471.50,1309895.00,1388917.44,79022.44,714891),('1','200','251998','468',530.00,576.00,0.00,4087.37,2166306.10,2264005.12,97699.02,715491),('1','200','252239','468',530.00,576.00,0.00,3574.49,1894479.70,1980170.24,85690.54,716122),('1','200','252488','468',530.00,576.00,0.00,2390.68,1267060.40,1335607.68,68547.28,716760),('1','200','252725','468',530.00,576.00,0.00,4252.65,2253904.50,2350160.80,96256.30,717376),('1','200','252972','468',530.00,576.00,0.00,2796.01,1481885.30,1561777.60,79892.30,718019),('1','200','253212','468',530.00,576.00,0.00,2770.20,1468206.00,1539203.20,70997.20,718654),('1','200','253477','468',530.00,576.00,0.00,3113.15,1649969.50,1732748.80,82779.30,719337),('1','200','253719','468',530.00,576.00,0.00,3191.38,1691431.40,1769674.88,78243.48,719955),('1','200','253960','468',530.00,576.00,0.00,168.85,89490.50,93319.36,3828.86,720584),('1','200','254013','468',520.00,576.00,0.00,2370.37,1232592.40,1317959.36,85366.96,720713),('1','200','254217','468',520.00,576.00,0.00,3614.52,1879550.40,2004811.20,125260.80,721246),('1','200','254457','468',520.00,576.00,0.00,3289.89,1710742.80,1830256.64,119513.84,721872),('1','200','254714','468',520.00,576.00,0.00,4009.41,2084893.20,2218876.16,133982.96,722517),('1','200','254958','468',520.00,576.00,0.00,4046.85,2104362.00,2236016.96,131654.96,723144),('1','200','255204','468',520.00,576.00,0.00,3933.90,2045628.00,2180246.40,134618.40,723773),('1','200','255483','468',520.00,576.00,0.00,3144.31,1635041.20,1742434.88,107393.68,724462),('1','200','255734','468',520.00,576.00,0.00,3979.86,2069527.20,2208415.36,138888.16,725090),('1','200','255953','468',520.00,576.00,0.00,5236.45,2722954.00,2880497.32,157543.32,725650),('1','200','256212','468',520.00,576.00,0.00,2527.29,1314190.80,1404727.04,90536.24,726291),('1','200','256507','468',520.00,576.00,0.00,3472.78,1805845.60,1937713.28,131867.68,727052),('1','200','256749','468',520.00,576.00,0.00,2932.57,1524936.40,1637384.32,112447.92,727669),('1','200','256990','468',520.00,576.00,0.00,3699.24,1923604.80,2049946.24,126341.44,728305),('1','200','257247','468',520.00,576.00,0.00,3105.71,1614969.20,1736149.76,121180.56,728982),('1','200','257506','468',520.00,576.00,0.00,3994.52,2077150.40,2225543.36,148392.96,729658),('1','200','257507','468',520.00,576.00,0.00,2466.52,1282590.40,1384948.16,102357.76,729659),('1','200','257508','468',520.00,576.00,0.00,4063.03,2112775.60,2255121.28,142345.68,729660),('1','200','257509','468',520.00,576.00,0.00,4471.60,2325232.00,2488937.60,163705.60,729661),('1','200','257510','468',520.00,576.00,0.00,4038.70,2100124.00,2260499.20,160375.20,729662),('1','200','257511','468',520.00,576.00,0.00,6576.13,3419587.60,3625706.88,206119.28,729663),('1','200','257512','468',520.00,576.00,0.00,4490.61,2335117.20,2503039.36,167922.16,729664),('1','200','257513','468',520.00,576.00,0.00,3482.79,1811050.80,1959623.04,148572.24,729665),('1','200','257514','468',520.00,576.00,0.00,3589.33,1866451.60,2012362.88,145911.28,729666),('1','200','257515','468',520.00,576.00,0.00,4581.55,2382406.00,2546028.80,163622.80,729667),('1','200','257516','468',520.00,576.00,0.00,4022.09,2091486.80,2237219.84,145733.04,729668),('1','200','257517','468',520.00,576.00,0.00,2930.85,1524042.00,1652405.76,128363.76,729669),('1','200','257518','468',520.00,576.00,0.00,3262.99,1696754.80,1817076.48,120321.68,729670),('1','200','257519','468',520.00,576.00,0.00,3515.11,1827857.20,1967501.76,139644.56,729671),('1','200','257520','468',520.00,576.00,0.00,573.19,298058.80,319441.60,21382.80,729672),('1','200','257521','468',520.00,576.00,0.00,0.00,0.00,0.00,0.00,729673),('1','200','257522','468',520.00,576.00,0.00,2443.54,1268197.26,1374554.56,106357.30,729674),('1','200','257523','468',519.00,576.00,0.00,2648.61,1374628.59,1485248.00,110619.41,729675),('1','200','257524','468',519.00,576.00,0.00,1344.01,697541.19,751770.24,54229.05,729676),('1','200','257525','468',519.00,576.00,0.00,0.00,0.00,0.00,0.00,729677),('1','200','257526','468',519.00,576.00,0.00,1459.80,757636.20,815704.32,58068.12,729678),('1','200','257527','468',519.00,576.00,0.00,5004.55,2597361.45,2772157.12,174795.67,729679),('1','200','257528','468',519.00,576.00,0.00,3394.17,1761574.23,1892009.28,130435.05,729680),('1','200','257529','468',519.00,576.00,0.00,2385.59,1238121.21,1319488.42,81367.21,729681),('1','200','257530','468',519.00,576.00,0.00,0.00,0.00,0.00,0.00,729682),('1','200','257531','468',519.00,576.00,0.00,3465.89,1798796.91,1937806.72,139009.81,729683),('1','200','257532','468',519.00,576.00,0.00,2478.56,1286372.64,1401938.56,115565.92,729684),('1','200','257533','468',519.00,576.00,0.00,3708.15,1924529.85,2077349.76,152819.91,729685),('1','200','257534','468',519.00,576.00,0.00,2889.84,1499826.96,1620403.52,120576.56,729686),('1','200','257535','468',519.00,576.00,0.00,4629.53,2402726.07,2569313.28,166587.21,729687),('1','200','257536','468',519.00,576.00,0.00,2659.66,1380363.54,1501310.72,120947.18,729688),('1','200','257537','468',519.00,576.00,0.00,3526.84,1830429.96,1966135.04,135705.08,729689),('1','200','257538','468',519.00,576.00,0.00,1310.15,679967.85,737371.52,57403.67,729690),('1','200','257539','468',519.00,576.00,0.00,0.00,0.00,0.00,0.00,729691),('1','200','257540','468',519.00,576.00,0.00,3355.00,1741245.00,1863807.68,122562.68,729692),('1','200','257541','468',519.00,576.00,0.00,3930.74,2040054.06,2190861.44,150807.38,729693),('1','200','257542','468',519.00,576.00,0.00,3195.14,1658277.66,1787290.24,129012.58,729694),('1','200','257543','468',519.00,576.00,0.00,4322.10,2243169.90,2403838.08,160668.18,729695),('1','200','257544','468',519.00,576.00,0.00,3559.95,1847614.05,1993667.20,146053.15,729696),('1','200','257545','468',519.00,576.00,0.00,4432.82,2300633.58,2478440.32,177806.74,729697),('1','200','257546','468',519.00,576.00,0.00,3668.70,1904055.30,2064111.68,160056.38,729698),('1','200','257547','468',519.00,576.00,0.00,5432.48,2819457.12,3036187.20,216730.08,729699),('1','200','257548','468',519.00,576.00,0.00,5144.93,2670218.67,2869530.56,199311.89,729700),('1','200','257549','468',519.00,576.00,0.00,590.60,306521.40,334507.20,27985.80,729701),('1','200','257550','468',519.00,576.00,0.00,0.00,0.00,0.00,0.00,729702),('1','200','257551','468',538.00,576.00,0.00,2326.51,1251662.38,1340724.24,89061.86,729703),('1','200','257552','468',538.00,600.00,0.00,4384.86,2359054.68,2751365.00,392310.32,729704),('1','200','257553','468',538.00,640.00,0.00,3538.95,1903955.10,2228543.20,324588.10,729705),('1','200','257554','468',538.00,640.00,0.00,2891.23,1555481.74,1831467.60,275985.86,729706),('1','200','257555','468',538.00,640.00,0.00,6608.95,3555615.10,4150030.20,594415.10,729707),('1','200','257556','468',538.00,640.00,0.00,5042.99,2713128.62,3164880.00,451751.38,729708),('1','200','257557','468',538.00,640.00,0.00,0.00,0.00,0.00,0.00,729709),('1','200','257558','468',602.00,680.00,0.00,1199.34,722002.68,797693.60,75690.92,729710),('1','200','257559','468',602.00,680.00,0.00,5164.88,3109257.76,3415488.80,306231.04,729711),('1','200','257560','468',602.00,680.00,0.00,3996.20,2405712.40,2610295.60,204583.20,729712),('1','200','257561','468',602.00,680.00,0.00,5562.89,3348859.78,3637407.20,288547.42,729713),('1','200','257562','468',602.00,680.00,0.00,4977.79,2996629.58,3247034.00,250404.42,729714),('1','200','257563','468',602.00,640.00,0.00,5395.87,3248313.74,3358030.00,109716.26,729715),('1','200','257564','468',602.00,640.00,0.00,4982.69,2999579.38,3105725.12,106145.74,729716),('1','200','257565','468',602.00,640.00,0.00,3852.99,2319499.98,2410884.48,91384.50,729717),('1','200','257566','468',602.00,640.00,0.00,5773.78,3475815.56,3592766.08,116950.52,729718),('1','200','257567','468',602.00,640.00,0.00,4125.72,2483683.44,2578901.76,95218.32,729719),('1','200','257568','468',602.00,640.00,0.00,3986.40,2399812.80,2467088.64,67275.84,729720),('1','200','257569','468',602.00,640.00,0.00,0.00,0.00,0.00,0.00,729721),('1','200','257570','468',602.00,640.00,0.00,4134.68,2489077.36,2570893.52,81816.16,729722),('1','200','257571','468',602.00,640.00,0.00,5178.77,3117619.54,3217555.76,99936.22,729723),('1','200','257572','468',602.00,640.00,0.00,4339.56,2612415.12,2708900.64,96485.52,729724),('1','200','257573','468',602.00,680.00,0.00,4579.10,2756618.20,2998866.12,242247.92,729725),('1','200','257574','468',602.00,680.00,0.00,4569.21,2750664.42,2986299.94,235635.52,729726),('1','200','257575','468',602.00,680.00,0.00,2072.15,1247434.30,1346115.00,98680.70,729727),('1','200','257576','468',602.00,680.00,0.00,0.00,0.00,0.00,0.00,729728),('1','200','257577','468',627.00,680.00,0.00,2052.13,1286685.51,1353737.70,67052.19,729729),('1','200','257578','468',627.00,680.00,0.00,5986.87,3753767.49,3899827.64,146060.15,729730),('1','200','257579','468',627.00,680.00,0.00,4437.94,2782588.38,2938654.70,156066.32,729731),('1','200','257580','468',627.00,680.00,0.00,7326.20,4593527.40,4827197.42,233670.02,729732),('1','200','257581','468',627.00,680.00,0.00,4915.38,3081943.26,3149320.80,67377.54,729733),('1','200','257582','468',627.00,660.00,0.00,0.00,0.00,0.00,0.00,729734),('1','200','257583','468',600.00,660.00,0.00,3002.86,1801716.00,1918338.00,116622.00,729735),('1','200','257584','468',600.00,660.00,0.00,9396.92,5638152.00,6012022.80,373870.80,729736),('1','200','257585','468',600.00,660.00,0.00,6115.09,3669054.00,3916751.70,247697.70,729737),('1','200','257586','468',600.00,660.00,0.00,5187.91,3112746.00,3424020.60,311274.60,729738),('1','200','257587','468',600.00,660.00,0.00,993.53,596118.00,655729.80,59611.80,729739),('1','200','257588','468',600.00,660.00,0.00,0.00,0.00,0.00,0.00,729740),('1','200','257589','468',600.00,660.00,0.00,5055.49,3033294.00,3240298.50,207004.50,729741),('1','200','257590','468',600.00,660.00,0.00,4551.16,2730696.00,2924377.20,193681.20,729742),('1','200','257591','468',600.00,660.00,0.00,5750.29,3450174.00,3705475.20,255301.20,729743),('1','200','257592','468',600.00,660.00,0.00,3745.35,2247210.00,2415651.00,168441.00,729744),('1','200','257593','468',600.00,660.00,0.00,4292.95,2575770.00,2756044.80,180274.80,729745),('1','200','257594','468',600.00,660.00,0.00,1062.14,637284.00,686366.10,49082.10,729746),('1','200','257595','468',600.00,660.00,0.00,0.00,0.00,0.00,0.00,729747),('1','200','257596','468',600.00,660.00,0.00,2865.11,1719066.00,1839479.40,120413.40,729748),('1','200','257597','468',600.00,660.00,0.00,5142.41,3085446.00,3306320.70,220874.70,729749),('1','200','257598','468',600.00,660.00,0.00,5574.31,3344586.00,3588124.20,243538.20,729750),('1','200','257599','468',600.00,660.00,0.00,4433.25,2659950.00,2855480.70,195530.70,729751),('1','200','257600','468',600.00,660.00,0.00,4512.34,2707404.00,2904010.20,196606.20,729752),('1','200','257601','468',600.00,660.00,0.00,2415.19,1449114.00,1539771.60,90657.60,729753),('1','200','257602','468',600.00,660.00,0.00,0.00,0.00,0.00,0.00,729754),('1','200','257603','468',600.00,660.00,0.00,3481.06,2088636.00,2240468.40,151832.40,729755),('1','200','257604','468',600.00,660.00,0.00,4522.38,2713428.00,2907064.80,193636.80,729756),('1','200','257605','468',600.00,660.00,0.00,3963.39,2378034.00,2552925.60,174891.60,729757),('1','200','257606','468',600.00,660.00,0.00,4096.48,2457888.00,2631916.80,174028.80,729758),('1','200','257607','468',600.00,660.00,0.00,4215.94,2529564.00,2702746.20,173182.20,729759),('1','200','257608','468',600.00,660.00,0.00,3562.22,2137332.00,2292001.20,154669.20,729760),('1','200','257609','468',600.00,660.00,0.00,5889.16,3533496.00,3774030.30,240534.30,729761),('1','200','257610','468',600.00,660.00,0.00,4293.92,2576352.00,2765961.90,189609.90,729762),('1','200','257611','468',600.00,660.00,0.00,4815.24,2889144.00,3090117.90,200973.90,729763),('1','200','257612','468',600.00,660.00,0.00,4082.79,2449674.00,2624110.20,174436.20,729764),('1','200','257613','468',600.00,660.00,0.00,4763.76,2858256.00,3060867.00,202611.00,729765),('1','200','257614','468',600.00,660.00,0.00,5446.95,3268170.00,3497967.00,229797.00,729766),('1','200','257615','468',600.00,660.00,0.00,4509.13,2705478.00,2907757.80,202279.80,729767),('1','200','257616','468',600.00,660.00,0.00,0.00,0.00,0.00,0.00,729768),('1','200','257617','468',590.00,660.00,0.00,9173.78,5412530.20,5888434.20,475904.00,729769),('1','200','257618','468',590.00,660.00,0.00,6942.29,4095951.10,4458651.90,362700.80,729770),('1','200','257619','468',590.00,660.00,0.00,2729.46,1610381.40,1755175.20,144793.80,729771),('1','200','257620','468',590.00,660.00,0.00,3354.78,1979320.20,2153555.70,174235.50,729772),('1','200','257621','468',590.00,660.00,0.00,4844.86,2858467.40,3096505.20,238037.80,729773),('1','200','257622','468',590.00,660.00,0.00,4005.70,2363363.00,2577966.30,214603.30,729774),('1','200','257623','468',590.00,660.00,0.00,4660.70,2749813.00,3008765.40,258952.40,729775),('1','200','257624','468',590.00,660.00,0.00,5292.47,3122557.30,3424504.50,301947.20,729776),('1','200','257625','468',590.00,660.00,0.00,5514.12,3253330.80,3546354.60,293023.80,729777),('1','200','257626','468',590.00,660.00,0.00,2102.44,1240439.60,1355799.30,115359.70,729778),('1','200','257627','468',590.00,660.00,0.00,0.00,0.00,0.00,0.00,729779),('1','200','257628','468',590.00,660.00,0.00,2562.81,1512057.90,1656081.90,144024.00,729780),('1','200','257629','468',590.00,660.00,0.00,5621.16,3316484.40,3626772.60,310288.20,729781),('1','200','257630','468',590.00,660.00,0.00,4508.07,2659761.30,2907203.70,247442.40,729782),('1','200','257631','468',590.00,660.00,0.00,4447.85,2624231.50,2871112.20,246880.70,729783),('1','200','257632','468',590.00,660.00,0.00,4029.38,2377334.20,2607055.80,229721.60,729784),('1','200','257633','468',590.00,660.00,0.00,717.18,423136.20,473338.80,50202.60,729785),('1','200','257634','468',590.00,660.00,0.00,50.00,29500.00,31500.00,2000.00,729786),('1','200','257635','468',590.00,660.00,0.00,0.00,0.00,0.00,0.00,729787),('1','200','257636','468',625.00,688.00,0.00,3654.84,2284275.00,2439767.76,155492.76,729788),('1','200','257637','468',625.00,688.00,0.00,5216.44,3260275.00,3444551.12,184276.12,729789),('1','200','257638','468',625.00,688.00,0.00,3388.39,2117743.75,2259096.32,141352.57,729790),('1','200','257639','468',625.00,688.00,0.00,4182.53,2614081.25,2790774.80,176693.55,729791),('1','200','257640','468',625.00,688.00,0.00,4564.49,2852806.25,3035122.88,182316.63,729792),('1','200','257641','468',625.00,688.00,0.00,3306.89,2066806.25,2192236.40,125430.15,729793),('1','200','257642','468',625.00,688.00,0.00,0.00,0.00,0.00,0.00,729794),('1','200','257643','468',625.00,688.00,0.00,1805.50,1128437.50,1194022.48,65584.98,729795),('1','200','257644','468',625.00,688.00,0.00,4653.80,2908625.00,3139201.19,230576.19,729796),('1','200','257645','468',625.00,688.00,0.00,4065.81,2541131.25,2737345.98,196214.73,729797),('1','200','257646','468',625.00,688.00,0.00,3852.44,2407775.00,2595913.22,188138.22,729798),('1','200','257647','468',625.00,688.00,0.00,3884.59,2427868.75,2610222.31,182353.56,729799),('1','200','257648','468',625.00,740.00,0.00,3646.32,2278950.00,2601482.30,322532.30,729800),('1','200','257649','468',625.00,740.00,0.00,4074.08,2546300.00,2920382.55,374082.55,729801),('1','200','257650','468',625.00,740.00,0.00,4968.08,3105050.00,3532622.40,427572.40,729802),('1','200','257651','468',625.00,740.00,0.00,4457.45,2785906.25,3188128.00,402221.75,729803),('1','200','257652','468',625.00,740.00,0.00,5284.85,3303031.25,3790337.35,487306.10,729804),('1','200','257653','468',625.00,740.00,0.00,5457.05,3410656.25,3886941.70,476285.45,729805),('1','200','257654','468',625.00,740.00,0.00,1256.28,785175.00,901969.55,116794.55,729806),('1','200','257655','468',625.00,740.00,0.00,0.00,0.00,0.00,0.00,729807),('1','200','257656','468',625.00,740.00,0.00,3860.05,2547633.00,2762566.10,214933.10,729808),('1','200','257657','468',660.00,740.00,0.00,4596.18,3033478.80,3311744.52,278265.72,729809),('1','200','257658','468',660.00,740.00,0.00,1863.77,1230088.20,1346529.48,116441.28,729810),('1','200','257659','468',660.00,740.00,0.00,8.11,5352.60,6001.40,648.80,729811),('1','200','257660','468',680.00,750.00,0.00,7874.34,5354551.20,5706220.34,351669.14,729812),('1','200','257661','468',680.00,750.00,0.00,6054.30,4116924.00,4397131.40,280207.40,729813),('1','200','257662','468',680.00,750.00,0.00,6189.81,4209070.80,4496887.56,287816.76,729814),('1','200','257663','468',680.00,750.00,0.00,3539.34,2406751.20,2654505.00,247753.80,729815),('1','200','257664','468',680.00,750.00,0.00,850.13,578088.40,637597.50,59509.10,729816),('1','200','257665','468',680.00,750.00,0.00,0.00,0.00,0.00,0.00,729817),('1','200','257666','468',682.00,750.00,0.00,5561.28,3792792.96,4048520.00,255727.04,729818),('1','200','257667','468',682.00,750.00,0.00,4723.85,3221665.70,3445807.50,224141.80,729819),('1','200','257668','468',682.00,750.00,0.00,5865.22,4000080.04,4273358.20,273278.16,729820),('1','200','257669','468',682.00,750.00,0.00,8376.44,5712732.08,6074571.60,361839.52,729821),('1','200','257670','468',682.00,750.00,0.00,403.60,275255.20,302700.00,27444.80,729822),('1','200','257671','468',682.00,750.00,0.00,0.00,0.00,0.00,0.00,729823),('1','200','257672','468',682.00,770.00,0.00,7397.13,5044842.66,5492487.30,447644.64,729824),('1','200','257673','468',682.00,770.00,0.00,4469.16,3047967.12,3328003.05,280035.93,729825),('1','200','257674','468',682.00,770.00,0.00,3913.63,2669095.66,2929142.60,260046.94,729826),('1','200','257675','468',682.00,770.00,0.00,3412.01,2326990.82,2561625.10,234634.28,729827),('1','200','257676','468',682.00,770.00,0.00,3562.44,2429584.08,2687559.15,257975.07,729828),('1','200','257677','468',682.00,770.00,0.00,4942.11,3370519.02,3684875.55,314356.53,729829),('1','200','257678','468',682.00,770.00,0.00,4348.76,2965854.32,3258740.50,292886.18,729830),('1','200','257679','468',682.00,770.00,0.00,3433.86,2341892.52,2580656.85,238764.33,729831),('1','200','257680','468',682.00,770.00,0.00,3329.35,2270616.70,2504184.20,233567.50,729832),('1','200','257681','468',682.00,770.00,0.00,4048.45,2761042.90,3030244.10,269201.20,729833),('1','200','257682','468',682.00,770.00,0.00,1086.03,740672.46,816665.85,75993.39,729834),('1','200','257683','468',682.00,770.00,0.00,0.00,0.00,0.00,0.00,729835),('1','200','257684','468',682.00,770.00,0.00,0.00,0.00,0.00,0.00,729836),('1','200','257685','468',682.00,770.00,0.00,3077.11,2098589.02,2301547.55,202958.53,729837),('1','200','257686','468',682.00,770.00,0.00,4742.07,3234091.74,3543578.85,309487.11,729838),('1','200','257687','468',682.00,770.00,0.00,4656.46,3175705.72,3485563.40,309857.68,729839),('1','200','257688','468',682.00,770.00,0.00,5467.16,3728603.12,4106867.50,378264.38,729840),('1','200','257689','468',682.00,770.00,0.00,4597.06,3135194.92,3430561.70,295366.78,729841),('1','200','257690','468',682.00,770.00,0.00,3832.84,2613996.88,2881726.25,267729.37,729842),('1','200','257691','468',682.00,770.00,0.00,6784.50,4627029.00,5044799.85,417770.85,729843),('1','200','257692','468',682.00,770.00,0.00,2501.32,1705900.24,1889034.05,183133.81,729844),('1','200','257693','468',682.00,770.00,0.00,0.00,0.00,0.00,0.00,729845),('1','200','257694','468',682.00,770.00,0.00,6238.69,4254786.58,4669015.40,414228.82,729846),('1','200','257695','468',682.00,770.00,0.00,6546.55,4464747.10,4896348.95,431601.85,729847),('1','200','257696','468',682.00,770.00,0.00,6010.83,4099386.06,4489648.20,390262.14,729848),('1','200','257697','468',682.00,770.00,0.00,5833.89,3978712.98,4366417.95,387704.97,729849),('1','200','257698','468',682.00,770.00,0.00,5660.88,3860720.16,4230806.50,370086.34,729850),('1','200','257699','468',682.00,770.00,0.00,6095.35,4157028.70,4565479.55,408450.85,729851),('1','200','257700','468',682.00,770.00,0.00,9782.07,6671371.74,7264619.85,593248.11,729852),('1','200','257701','468',682.00,770.00,0.00,2827.58,1928409.56,2111189.20,182779.64,729853),('1','200','257702','468',682.00,770.00,0.00,612.48,417711.36,452198.40,34487.04,729854),('1','200','257703','468',682.00,770.00,0.00,0.00,0.00,0.00,0.00,729855),('1','200','257704','468',682.00,770.00,0.00,4102.21,2797707.22,3049342.25,251635.03,729856),('1','200','257705','468',682.00,770.00,0.00,2628.29,1792493.78,2023783.30,231289.52,729857),('1','200','257706','468',682.00,770.00,0.00,2144.56,1462589.92,1651311.20,188721.28,729858),('1','200','257707','468',682.00,770.00,0.00,4549.14,3102513.48,3387989.25,285475.77,729859),('1','200','257708','468',682.00,770.00,0.00,3316.81,2262064.42,2452628.90,190564.48,729860),('1','200','257709','468',682.00,770.00,0.00,0.00,0.00,0.00,0.00,729861),('1','200','257710','468',682.00,770.00,0.00,2455.44,1674610.08,1824812.85,150202.77,729862),('1','200','257711','468',682.00,770.00,0.00,3921.36,2674367.52,2933850.90,259483.38,729863),('1','200','257712','468',682.00,770.00,0.00,6456.46,4403305.72,4793799.80,390494.08,729864),('1','200','257713','468',682.00,770.00,0.00,5105.19,3481739.58,3822163.80,340424.22,729865),('1','200','257714','468',682.00,770.00,0.00,5287.06,3605774.92,3918136.55,312361.63,729866),('1','200','257715','468',682.00,770.00,0.00,1750.96,1194154.72,1348239.20,154084.48,729867),('1','200','257716','468',682.00,770.00,0.00,0.00,0.00,0.00,0.00,729868),('1','200','257717','468',682.00,770.00,0.00,6247.51,4260801.82,4639296.05,378494.23,729869),('1','200','257718','468',682.00,770.00,0.00,5178.23,3531552.86,3865882.45,334329.59,729870),('1','200','257719','468',682.00,770.00,0.00,4630.59,3158062.38,3445110.90,287048.52,729871),('1','200','257720','468',682.00,770.00,0.00,6301.12,4297363.84,4703220.20,405856.36,729872),('1','200','257721','468',682.00,770.00,0.00,3804.34,2594559.88,2871265.25,276705.37,729873),('1','200','257722','468',682.00,770.00,0.00,3975.50,2711291.00,2986755.40,275464.40,729874),('1','200','257723','468',682.00,770.00,0.00,5083.13,3466694.66,3789787.15,323092.49,729875),('1','200','257724','468',682.00,770.00,0.00,4478.91,3054616.62,3358562.25,303945.63,729876),('1','200','257725','468',682.00,770.00,0.00,5478.02,3736009.64,4096866.55,360856.91,729877),('1','200','257726','468',682.00,770.00,0.00,4378.67,2986252.94,3274973.50,288720.56,729878),('1','200','257727','468',682.00,770.00,0.00,0.00,0.00,0.00,0.00,729879),('1','200','257728','468',682.00,770.00,0.00,6024.79,4108906.78,4499886.65,390979.87,729880),('1','200','257729','468',682.00,770.00,0.00,5025.43,3427343.26,3766316.90,338973.64,729881),('1','200','257730','468',682.00,770.00,0.00,6714.32,4579166.24,5005939.75,426773.51,729882),('1','200','257731','468',682.00,770.00,0.00,6936.64,4730788.48,5175029.60,444241.12,729883),('1','200','257732','468',682.00,770.00,0.00,0.00,0.00,0.00,0.00,729884),('1','200','257733','468',682.00,770.00,0.00,6521.24,4447485.68,4891172.95,443687.27,729885),('1','200','257734','468',682.00,770.00,0.00,6120.44,4174140.08,4574415.10,400275.02,729886),('1','200','257735','468',682.00,770.00,0.00,8297.14,5658649.48,6147215.30,488565.82,729887),('1','200','257736','468',682.00,770.00,0.00,2683.33,1830031.06,2066164.10,236133.04,729888),('1','200','257737','468',682.00,770.00,0.00,0.00,0.00,0.00,0.00,729889),('1','200','257738','468',682.00,790.00,0.00,11366.19,7751741.58,8518689.10,766947.52,729890),('1','200','257739','468',682.00,790.00,0.00,4511.33,3076727.06,3449285.70,372558.64,729891),('1','200','257740','468',682.00,790.00,0.00,5126.94,3496573.08,3924133.60,427560.52,729892),('1','200','257741','468',682.00,790.00,0.00,5865.02,3999943.64,4447240.80,447297.16,729893),('1','200','257742','468',685.00,790.00,0.00,5570.59,3815854.15,4246332.60,430478.45,729894),('1','200','257743','468',685.00,790.00,0.00,4148.17,2841496.45,3197403.80,355907.35,729895),('1','200','257744','468',685.00,790.00,0.00,4538.59,3108934.15,3463157.60,354223.45,729896),('1','200','257745','468',685.00,790.00,0.00,6870.73,4706450.05,5222872.70,516422.65,729897),('1','200','257746','468',685.00,790.00,0.00,4603.24,3153219.40,3518037.10,364817.70,729898),('1','200','257747','468',685.00,790.00,0.00,4037.32,2765564.20,3091483.80,325919.60,729899),('1','200','257748','468',685.00,790.00,0.00,4356.26,2984038.10,3331082.90,347044.80,729900),('1','200','257749','468',685.00,790.00,0.00,5789.02,3965478.70,4415761.80,450283.10,729901),('1','200','257750','468',685.00,790.00,0.00,3695.24,2531239.40,2842389.60,311150.20,729902),('1','200','257751','468',685.00,790.00,0.00,3976.16,2723669.60,3035853.40,312183.80,729903),('1','200','257752','468',685.00,790.00,0.00,0.00,0.00,0.00,0.00,729904),('1','200','257753','468',673.00,790.00,0.00,4756.12,3200868.76,3620777.30,419908.54,729905),('1','200','257754','468',673.00,790.00,0.00,4085.17,2749319.41,3132133.80,382814.39,729906),('1','200','257755','468',673.00,790.00,0.00,4553.84,3064734.32,3478741.60,414007.28,729907),('1','200','257756','468',673.00,790.00,0.00,4581.82,3083564.86,3510501.80,426936.94,729908),('1','200','257757','468',673.00,790.00,0.00,4793.62,3226106.26,3672598.30,446492.04,729909),('1','200','257758','468',673.00,790.00,0.00,4686.95,3154317.35,3574591.00,420273.65,729910),('1','200','257759','468',673.00,790.00,0.00,3659.96,2463153.08,2805086.40,341933.32,729911),('1','200','257760','468',673.00,790.00,0.00,4979.88,3351459.24,3814243.20,462783.96,729912),('1','200','257761','468',673.00,790.00,0.00,4902.33,3299268.09,3750169.20,450901.11,729913),('1','200','257762','468',673.00,790.00,0.00,5260.19,3540107.87,4045236.60,505128.73,729914),('1','200','257763','468',673.00,790.00,0.00,3025.19,2035952.87,2310078.10,274125.23,729915),('1','200','257764','468',673.00,790.00,0.00,0.00,0.00,0.00,0.00,729916),('1','200','257765','468',673.00,790.00,0.00,2222.25,1495574.25,1683405.50,187831.25,729917),('1','200','257766','468',673.00,780.00,0.00,6174.41,4155377.93,4666956.30,511578.37,729918),('1','200','257767','468',673.00,780.00,0.00,5017.23,3376595.79,3797014.40,420418.61,729919),('1','200','257768','468',673.00,780.00,0.00,4860.86,3271358.78,3665785.30,394426.52,729920),('1','200','257769','468',673.00,780.00,0.00,4179.82,2813018.86,3100638.10,287619.24,729921),('1','200','257770','468',673.00,780.00,0.00,4857.51,3269104.23,3651664.30,382560.07,729922),('1','200','257771','468',673.00,780.00,0.00,5725.76,3853436.48,4315005.30,461568.82,729923),('1','200','257772','468',673.00,780.00,0.00,5105.44,3435961.12,3834689.70,398728.58,729924),('1','200','257773','468',673.00,780.00,0.00,5429.52,3654066.96,4090293.60,436226.64,729925),('1','200','257774','468',673.00,780.00,0.00,4645.65,3126522.45,3525234.00,398711.55,729926),('1','200','257775','468',673.00,780.00,0.00,4675.71,3146752.83,3527755.80,381002.97,729927),('1','200','257776','468',673.00,780.00,0.00,5480.75,3688544.75,4119318.50,430773.75,729928),('1','200','257777','468',673.00,780.00,0.00,4662.76,3138037.48,3500453.80,362416.32,729929),('1','200','257778','468',673.00,780.00,0.00,4800.74,3230898.02,3620247.20,389349.18,729930),('1','200','257779','468',673.00,780.00,0.00,5782.96,3891932.08,4325268.80,433336.72,729931),('1','200','257780','468',673.00,780.00,0.00,4953.45,3333671.85,3747320.51,413648.66,729932),('1','200','257781','468',673.00,780.00,0.00,4610.68,3102987.64,3490550.40,387562.76,729933),('1','200','257782','468',673.00,780.00,0.00,5346.92,3598477.16,4016970.60,418493.44,729934),('1','200','257783','468',673.00,780.00,0.00,5711.05,3843536.65,4278886.00,435349.35,729935),('1','200','257784','468',673.00,780.00,0.00,3292.76,2216027.48,2450110.80,234083.32,729936),('1','200','257785','468',673.00,780.00,0.00,110.00,74030.00,80300.00,6270.00,729937),('1','200','257786','468',673.00,780.00,0.00,0.00,0.00,0.00,0.00,729938),('1','200','257787','468',666.00,780.00,0.00,5239.54,3489533.64,3917604.20,428070.56,729939),('1','200','257788','468',666.00,780.00,0.00,5333.29,3551971.14,4014896.70,462925.56,729940),('1','200','257789','468',666.00,780.00,0.00,5613.56,3738630.96,4217229.80,478598.84,729941),('1','200','257790','468',666.00,780.00,0.00,5709.74,3802686.84,4322776.20,520089.36,729942),('1','200','257791','468',666.00,780.00,0.00,5787.39,3854401.74,4340917.20,486515.46,729943),('1','200','257792','468',666.00,780.00,0.00,5637.31,3754448.46,4270310.80,515862.34,729944),('1','200','257793','468',666.00,780.00,0.00,5859.89,3902686.74,4393559.20,490872.46,729945),('1','200','257794','468',666.00,780.00,0.00,5358.06,3568467.96,4059579.30,491111.34,729946),('1','200','257795','468',666.00,780.00,0.00,4723.68,3145970.88,3551955.40,405984.52,729947),('1','200','257796','468',666.00,780.00,0.00,0.00,0.00,0.00,0.00,729948),('1','200','257797','468',666.00,780.00,0.00,2227.95,1483814.70,1690796.50,206981.80,729949),('1','200','257798','468',666.00,780.00,0.00,8100.00,5394600.00,6119804.00,725204.00,729950),('1','200','257799','468',666.00,780.00,0.00,7082.84,4717171.44,5330173.20,613001.76,729951),('1','200','257800','468',666.00,780.00,0.00,5867.74,3907914.84,4453606.20,545691.36,729952),('1','200','257801','468',666.00,780.00,0.00,1661.47,1106539.02,1295946.60,189407.58,729953),('1','200','257802','468',666.00,780.00,0.00,293.77,195650.82,229140.60,33489.78,729954),('1','200','257803','468',666.00,780.00,0.00,2688.12,1790287.92,2029949.10,239661.18,729955),('1','200','257804','468',666.00,780.00,0.00,6140.26,4089413.16,4609453.80,520040.64,729956),('1','200','257805','468',666.00,780.00,0.00,10709.12,7132273.92,7983909.60,851635.68,729957),('1','200','257806','468',666.00,780.00,0.00,3352.34,2232658.44,2592575.20,359916.76,729958),('1','200','257807','468',666.00,780.00,0.00,2099.08,1397987.28,1637282.40,239295.12,729959),('1','200','257808','468',666.00,780.00,0.00,0.00,0.00,0.00,0.00,729960),('1','200','257809','468',666.00,780.00,0.00,6905.34,4598956.44,5147945.70,548989.26,729961),('1','200','257810','468',666.00,780.00,0.00,7763.90,5170757.40,5800268.50,629511.10,729962),('1','200','257811','468',666.00,780.00,0.00,5847.69,3894561.54,4387793.70,493232.16,729963),('1','200','257812','468',666.00,780.00,0.00,4288.15,2855907.90,3316272.00,460364.10,729964),('1','200','257813','468',666.00,780.00,0.00,0.00,0.00,0.00,0.00,729965),('1','200','257814','468',666.00,770.00,0.00,6335.76,4219616.16,4682549.70,462933.54,729966),('1','200','257815','468',666.00,770.00,0.00,9729.18,6479633.88,7188943.10,709309.22,729967),('1','200','257816','468',666.00,770.00,0.00,4369.37,2910000.42,3364414.90,454414.48,729968),('1','200','257817','468',666.00,770.00,0.00,4467.42,2975301.72,3439913.40,464611.68,729969),('1','200','257818','468',666.00,770.00,0.00,0.00,0.00,0.00,0.00,729970),('1','200','257819','468',675.00,770.00,0.00,8637.91,5830589.25,6562756.90,732167.65,729971),('1','200','257820','468',675.00,790.00,0.00,8533.40,5760045.00,6492378.00,732333.00,729972),('1','200','257821','468',675.00,790.00,0.00,4515.80,3048165.00,3468651.60,420486.60,729973),('1','200','257822','468',675.00,790.00,0.00,5069.21,3421716.75,3936954.86,515238.11,729974),('1','200','257823','468',675.00,790.00,0.00,4459.67,3010277.25,3465151.50,454874.25,729975),('1','200','257824','468',675.00,790.00,0.00,4751.55,3207296.25,3690859.36,483563.11,729976),('1','200','257825','468',675.00,790.00,0.00,4494.65,3033888.75,3502061.98,468173.23,729977),('1','200','257826','468',675.00,790.00,0.00,4648.50,3137737.50,3618969.50,481232.00,729978),('1','200','257827','468',675.00,790.00,0.00,5741.24,3875337.00,4464991.68,589654.68,729979),('1','200','257828','468',675.00,790.00,0.00,5697.30,3845677.50,4423166.78,577489.28,729980),('1','200','257829','468',675.00,790.00,0.00,5112.05,3450633.75,3969355.86,518722.11,729981),('1','200','257830','468',675.00,790.00,0.00,4704.16,3175308.00,3656151.26,480843.26,729982),('1','200','257831','468',675.00,790.00,0.00,3681.87,2485262.25,2881141.48,395879.23,729983),('1','200','257832','468',675.00,790.00,0.00,4066.89,2745150.75,3149921.02,404770.27,729984),('1','200','257833','468',675.00,790.00,0.00,0.00,0.00,0.00,0.00,729985),('1','200','257834','468',675.00,790.00,0.00,1200.70,810472.50,930457.00,119984.50,729986),('1','200','257835','468',675.00,790.00,0.00,4578.20,3090285.00,3584522.78,494237.78,729987),('1','200','257836','468',675.00,790.00,0.00,4471.93,3018552.75,3465538.26,446985.51,729988),('1','200','257837','468',675.00,780.00,0.00,5124.63,3459125.25,3875990.60,416865.35,729989),('1','200','257838','468',675.00,780.00,0.00,3995.40,2696895.00,3036874.80,339979.80,729990),('1','200','257839','468',675.00,780.00,0.00,5114.65,3452388.75,3858109.40,405720.65,729991),('1','200','257840','468',675.00,780.00,0.00,4200.87,2835587.25,3176944.60,341357.35,729992),('1','200','257841','468',675.00,780.00,0.00,3369.33,2274297.75,2584616.60,310318.85,729993),('1','200','257842','468',675.00,780.00,0.00,3650.90,2464357.50,2802439.20,338081.70,729994),('1','200','257843','468',675.00,780.00,0.00,4265.58,2879266.50,3233448.80,354182.30,729995),('1','200','257844','468',675.00,780.00,0.00,5238.11,3535724.25,3954659.80,418935.55,729996),('1','200','257845','468',675.00,780.00,0.00,4613.28,3113964.00,3491789.20,377825.20,729997),('1','200','257846','468',675.00,780.00,0.00,0.00,0.00,0.00,0.00,729998),('1','200','257847','468',675.00,780.00,0.00,3974.79,2682983.25,3022847.40,339864.15,729999),('1','200','257848','468',675.00,780.00,0.00,5966.64,4027482.00,4504515.60,477033.60,730000),('1','200','257849','468',675.00,780.00,0.00,3452.39,2330363.25,2645764.20,315400.95,730001),('1','200','257850','468',675.00,780.00,0.00,4274.24,2885112.00,3262664.00,377552.00,730002),('1','200','257851','468',675.00,780.00,0.00,4641.29,3132870.75,3514917.40,382046.65,730003),('1','200','257852','468',675.00,780.00,0.00,4191.56,2829303.00,3174329.20,345026.20,730004),('1','200','257853','468',675.00,780.00,0.00,4323.52,2918376.00,3285670.00,367294.00,730005),('1','200','257854','468',675.00,780.00,0.00,4356.09,2940360.75,3304850.60,364489.85,730006),('1','200','257855','468',675.00,780.00,0.00,5224.72,3526686.00,3953420.80,426734.80,730007),('1','200','257856','468',675.00,780.00,0.00,6779.73,4576317.75,5132229.80,555912.05,730008),('1','200','257857','468',675.00,780.00,0.00,1858.38,1254406.50,1422266.40,167859.90,730009),('1','200','257858','468',675.00,780.00,0.00,0.00,0.00,0.00,0.00,730010),('1','200','257859','468',675.00,780.00,0.00,1736.64,1172232.00,1320104.80,147872.80,730011),('1','200','257860','468',675.00,780.00,0.00,6037.88,4075569.00,4563426.40,487857.40,730012),('1','200','257861','468',675.00,780.00,0.00,4839.24,3266487.00,3684507.60,418020.60,730013),('1','200','257862','468',675.00,780.00,0.00,5027.42,3393508.50,3822497.20,428988.70,730014),('1','200','257863','468',675.00,780.00,0.00,6498.81,4386696.75,4941448.60,554751.85,730015),('1','200','257864','468',675.00,780.00,0.00,5518.27,3724832.25,4194167.80,469335.55,730016),('1','200','257865','468',675.00,780.00,0.00,6056.90,4088407.50,4603200.40,514792.90,730017),('1','200','257866','468',675.00,780.00,0.00,4805.27,3243557.25,3662920.60,419363.35,730018),('1','200','257867','468',675.00,780.00,0.00,4813.28,3248964.00,3647992.80,399028.80,730019),('1','200','257868','468',675.00,780.00,0.00,4715.18,3182746.50,3576407.20,393660.70,730020),('1','200','257869','468',675.00,780.00,0.00,5797.64,3913407.00,4398327.60,484920.60,730021),('1','200','257870','468',675.00,780.00,0.00,5151.54,3477289.50,3889494.80,412205.30,730022),('1','200','257871','468',675.00,780.00,0.00,0.00,0.00,0.00,0.00,730023),('1','200','257872','468',666.00,780.00,0.00,4417.59,2942114.94,3360913.40,418798.46,730024),('1','200','257873','468',666.00,780.00,0.00,4516.23,3007809.18,3432125.40,424316.22,730025),('1','200','257874','468',666.00,780.00,0.00,4671.48,3111205.68,3545996.40,434790.72,730026),('1','200','257875','468',666.00,780.00,0.00,4363.33,2905977.78,3323536.60,417558.82,730027),('1','200','257876','468',666.00,780.00,0.00,4016.15,2674755.90,3062079.00,387323.10,730028),('1','200','257877','468',666.00,780.00,0.00,5285.00,3519810.00,3996528.00,476718.00,730029),('1','200','257878','468',666.00,780.00,0.00,4764.91,3173430.06,3605467.40,432037.34,730030),('1','200','257879','468',666.00,780.00,0.00,4654.11,3099637.26,3532219.40,432582.14,730031),('1','200','257880','468',666.00,780.00,0.00,4286.49,2854802.34,3260767.40,405965.06,730032),('1','200','257881','468',666.00,780.00,0.00,3439.48,2290693.68,2611726.40,321032.72,730033),('1','200','257882','468',666.00,780.00,0.00,5030.68,3350432.88,3804748.40,454315.52,730034),('1','200','257883','468',666.00,780.00,0.00,3889.88,2590660.08,2951400.00,360739.92,730035),('1','200','257884','468',666.00,780.00,0.00,4491.48,2991325.68,3400956.00,409630.32,730036),('1','200','257885','468',666.00,780.00,0.00,5520.74,3676812.84,4187866.80,511053.96,730037),('1','200','257886','468',666.00,770.00,0.00,4999.86,3329906.76,3746356.20,416449.44,730038),('1','200','257887','468',666.00,770.00,0.00,6230.45,4149479.70,4637500.90,488021.20,730039),('1','200','257888','468',666.00,770.00,0.00,0.00,0.00,0.00,0.00,730040),('1','200','257889','468',666.00,770.00,0.00,1284.23,855297.18,963237.50,107940.32,730041),('1','200','257890','468',666.00,770.00,0.00,4434.31,2953250.46,3313359.10,360108.64,730042),('1','200','257891','468',666.00,770.00,0.00,4549.21,3029773.86,3423250.50,393476.64,730043),('1','200','257892','468',666.00,770.00,0.00,5750.45,3829799.70,4275725.70,445926.00,730044),('1','200','257893','468',666.00,770.00,0.00,4176.83,2781768.78,3131319.10,349550.32,730045),('1','200','257894','468',666.00,770.00,0.00,3542.17,2359085.22,2657652.90,298567.68,730046),('1','200','257895','468',666.00,770.00,0.00,3534.75,2354143.50,2648660.30,294516.80,730047),('1','200','257896','468',666.00,770.00,0.00,4992.98,3325324.68,3736182.60,410857.92,730048),('1','200','257897','468',666.00,770.00,0.00,3583.07,2386324.62,2705943.90,319619.28,730049),('1','200','257898','468',666.00,770.00,0.00,3951.12,2631445.92,2972319.60,340873.68,730050),('1','200','257899','468',666.00,770.00,0.00,3853.74,2566590.84,2888579.40,321988.56,730051),('1','200','257900','468',666.00,770.00,0.00,3872.57,2579131.62,2906538.90,327407.28,730052),('1','200','257901','468',666.00,770.00,0.00,4036.53,2688328.98,3021848.90,333519.92,730053),('1','200','257902','468',666.00,770.00,0.00,4556.16,3034402.56,3418389.60,383987.04,730054),('1','200','257903','468',666.00,770.00,0.00,3917.44,2609015.04,2952049.60,343034.56,730055),('1','200','257904','468',666.00,770.00,0.00,3844.76,2560610.16,2895980.80,335370.64,730056),('1','200','257905','468',666.00,770.00,0.00,0.00,0.00,0.00,0.00,730057),('1','200','257906','468',666.00,770.00,0.00,3740.75,2491339.50,2811717.90,320378.40,730058),('1','200','257907','468',666.00,770.00,0.00,5570.61,3710026.26,4149928.50,439902.24,730059),('1','200','257908','468',666.00,770.00,0.00,4523.04,3012344.64,3369843.20,357498.56,730060),('1','200','257909','468',666.00,770.00,0.00,5145.00,3426570.00,3856356.80,429786.80,730061),('1','200','257910','468',666.00,770.00,0.00,3783.16,2519584.56,2849084.40,329499.84,730062),('1','200','257911','468',666.00,770.00,0.00,4249.76,2830340.16,3182848.80,352508.64,730063),('1','200','257912','468',666.00,770.00,0.00,4087.73,2722428.18,3067831.30,345403.12,730064),('1','200','257913','468',666.00,770.00,0.00,5134.99,3419903.34,3833209.10,413305.76,730065),('1','200','257914','468',666.00,770.00,0.00,4173.73,2779704.18,3128492.10,348787.92,730066),('1','200','257915','468',666.00,770.00,0.00,4911.32,3270939.12,3664138.40,393199.28,730067),('1','200','257916','468',666.00,770.00,0.00,2831.91,1886052.06,2128842.70,242790.64,730068),('1','200','257917','468',666.00,770.00,0.00,0.00,0.00,0.00,0.00,730069),('1','200','257918','468',666.00,770.00,0.00,824.69,549243.54,612896.50,63652.96,730070),('1','200','257919','468',666.00,770.00,0.00,4379.52,2916760.32,3260970.40,344210.08,730071),('1','200','257920','468',666.00,770.00,0.00,4278.21,2849287.86,3210658.10,361370.24,730072),('1','200','257921','468',666.00,770.00,0.00,4093.89,2726530.74,3078255.30,351724.56,730073),('1','200','257922','468',666.00,770.00,0.00,3895.13,2594156.58,2918230.10,324073.52,730074),('1','200','257923','468',666.00,770.00,0.00,5346.01,3560442.66,3963094.50,402651.84,730075),('1','200','257924','468',666.00,770.00,0.00,2824.25,1880950.50,2128012.50,247062.00,730076),('1','200','257925','468',666.00,770.00,0.00,3409.13,2270480.58,2559471.70,288991.12,730077),('1','200','257926','468',666.00,770.00,0.00,4296.10,2861202.60,3206597.00,345394.40,730078),('1','200','257927','468',666.00,770.00,0.00,4194.15,2793303.90,3144315.90,351012.00,730079),('1','200','257928','468',666.00,770.00,0.00,1744.71,1161976.86,1316023.90,154047.04,730080),('1','200','257929','468',666.00,770.00,0.00,0.00,0.00,0.00,0.00,730081),('1','200','257930','468',639.00,770.00,0.00,2839.11,1814191.29,2125139.90,310948.61,730082),('1','200','257931','468',649.00,770.00,0.00,3955.55,2567151.95,2960237.50,393085.55,730083),('1','200','257932','468',649.00,770.00,0.00,4377.48,2840984.52,3256536.80,415552.28,730084),('1','200','257933','468',649.00,770.00,0.00,3111.53,2019382.97,2340350.10,320967.13,730085),('1','200','257934','468',649.00,770.00,0.00,4009.61,2602236.89,3021919.70,419682.81,730086),('1','200','257935','468',649.00,770.00,0.00,4869.38,3160227.62,3634230.60,474002.98,730087),('1','200','257936','468',649.00,770.00,0.00,4927.48,3197934.52,3688639.60,490705.08,730088),('1','200','257937','468',649.00,770.00,0.00,4946.24,3210109.76,3726243.60,516133.84,730089),('1','200','257938','468',649.00,770.00,0.00,5740.88,3725831.12,4277125.60,551294.48,730090),('1','200','257939','468',649.00,770.00,0.00,754.73,489819.77,565893.30,76073.53,730091),('1','200','257940','468',649.00,770.00,0.00,0.00,0.00,0.00,0.00,730092),('1','200','257941','468',649.00,760.00,0.00,4272.12,2772605.88,3159134.80,386528.92,730093),('1','200','257942','468',649.00,760.00,0.00,4985.44,3235550.56,3672564.00,437013.44,730094),('1','200','257943','468',649.00,760.00,0.00,4007.10,2600607.90,2954816.00,354208.10,730095),('1','200','257944','468',649.00,760.00,0.00,3638.84,2361607.16,2690395.60,328788.44,730096),('1','200','257945','468',649.00,760.00,0.00,5066.02,3287846.98,3738176.40,450329.42,730097),('1','200','257946','468',649.00,760.00,0.00,339.46,220309.54,250553.60,30244.06,730098),('1','200','257947','468',649.00,760.00,0.00,0.00,0.00,0.00,0.00,730099),('1','200','257948','468',649.00,760.00,0.00,4310.24,2797345.76,3187382.40,390036.64,730100),('1','200','257949','468',649.00,760.00,0.00,6534.87,4241130.63,4792043.60,550912.97,730101),('1','200','257950','468',649.00,760.00,0.00,3684.37,2391156.13,2718762.80,327606.67,730102),('1','200','257951','468',649.00,760.00,0.00,4576.17,2969934.33,3371768.80,401834.47,730103),('1','200','257952','468',649.00,760.00,0.00,4536.41,2944130.09,3339056.00,394925.91,730104),('1','200','257953','468',649.00,760.00,0.00,3530.89,2291547.61,2607464.80,315917.19,730105),('1','200','257954','468',649.00,760.00,0.00,5346.13,3469638.37,3950817.60,481179.23,730106),('1','200','257955','468',649.00,760.00,0.00,3785.55,2456821.95,2811156.40,354334.45,730107),('1','200','257956','468',645.00,760.00,0.00,4138.89,2669584.05,3042346.40,372762.35,730108),('1','200','257957','468',645.00,760.00,0.00,5178.06,3339848.70,3806426.00,466577.30,730109),('1','200','257958','468',645.00,760.00,0.00,4996.57,3222787.65,3692856.00,470068.35,730110),('1','200','257959','468',645.00,760.00,0.00,7511.00,4844595.00,5529453.20,684858.20,730111),('1','200','257960','468',645.00,760.00,0.00,9497.94,6126171.30,6999109.60,872938.30,730112),('1','200','257961','468',645.00,760.00,0.00,8846.65,5706089.25,6493861.20,787771.95,730113),('1','200','257962','468',645.00,760.00,0.00,7686.10,4957534.50,5673958.40,716423.90,730114),('1','200','257963','468',645.00,760.00,0.00,5129.11,3308275.95,3806956.00,498680.05,730115),('1','200','257964','468',645.00,760.00,0.00,5281.52,3406580.40,3893480.80,486900.40,730116),('1','200','257965','468',645.00,760.00,0.00,4553.19,2936807.55,3364058.80,427251.25,730117),('1','200','257966','468',645.00,760.00,0.00,769.32,496211.40,570332.40,74121.00,730118),('1','200','257967','468',645.00,760.00,0.00,0.00,0.00,0.00,0.00,730119),('1','200','257968','468',645.00,760.00,0.00,2056.95,1326732.75,1522364.40,195631.65,730120),('1','200','257969','468',645.00,760.00,0.00,5223.13,3368918.85,3857231.60,488312.75,730121),('1','200','257970','468',645.00,760.00,0.00,5024.16,3240583.20,3718950.40,478367.20,730122),('1','200','257971','468',645.00,760.00,0.00,3072.54,1981788.30,2274878.40,293090.10,730123),('1','200','257972','468',645.00,760.00,0.00,0.00,0.00,0.00,0.00,730124),('1','200','257973','468',645.00,760.00,0.00,5680.11,3663670.95,4177024.80,513353.85,730125),('1','200','257974','468',645.00,760.00,0.00,3391.15,2187291.75,2487855.60,300563.85,730126),('1','200','257975','468',645.00,760.00,0.00,4566.59,2945450.55,3271077.20,325626.65,730127),('1','200','257976','468',645.00,760.00,0.00,6552.75,4226523.75,4624944.40,398420.65,730128),('1','200','257977','468',645.00,760.00,0.00,855.80,551991.00,650408.00,98417.00,730129),('1','200','257978','468',645.00,760.00,0.00,0.00,0.00,0.00,0.00,730130),('1','200','257979','468',634.00,760.00,0.00,3035.77,1924678.18,2180741.20,256063.02,730131),('1','200','257980','468',634.00,760.00,0.00,4491.74,2847763.16,3260151.20,412388.04,730132),('1','200','257981','468',634.00,760.00,0.00,5287.08,3352008.72,3762276.80,410268.08,730133),('1','200','257982','468',634.00,760.00,0.00,5516.89,3497708.26,3937813.20,440104.94,730134),('1','200','257983','468',634.00,760.00,0.00,7465.88,4733367.92,5292584.00,559216.08,730135),('1','200','257984','468',634.00,760.00,0.00,7622.53,4832684.02,5450920.40,618236.38,730136),('1','200','257985','468',634.00,760.00,0.00,9000.03,5706019.02,6386400.40,680381.38,730137),('1','200','257986','468',634.00,760.00,0.00,8649.74,5483935.16,6162374.40,678439.24,730138),('1','200','257987','468',634.00,760.00,0.00,7477.70,4740861.80,5343226.55,602364.75,730139);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=427 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',426,'200','PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=1026 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','200','426',1025,1,'468','LPG TANK ',70000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2021-12-04 09:59:06','2021-12-04 09:59:06','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','200',1025,6702.64,'2023-03-20 20:06:24');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2809068 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2153391,'1','200',NULL,468,'Purchased from AA RANO NIGERIA LIMITED',0.00,14726180.00,25130.00,0.00,0.00,'2021-12-04 11:25:57','',''),(2154002,'1','200',NULL,468,'Reception corrector for bridging 126194',0.00,0.00,0.00,25130.00,0.00,'2021-12-04 11:59:00','',''),(2154003,'1','200','1025',468,'Received from bridging 126194',0.00,0.00,25130.00,0.00,0.00,'2021-12-04 11:59:00','',''),(2154371,'1','200','1025',468,'Retail Sale Id 1275218',8200.00,0.00,0.00,0.00,875.00,'2021-12-04 12:16:21','',''),(2154372,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:16:21','',''),(2154790,'1','200','1025',468,'Retail Sale Id 1275430',8200.00,0.00,0.00,0.00,875.00,'2021-12-04 12:43:32','',''),(2154791,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:43:32','',''),(2157138,'1','200','1025',468,'Retail Sale Id 1276668',8200.00,0.00,0.00,0.00,875.00,'2021-12-04 14:51:41','',''),(2157139,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:51:41','',''),(2158181,'1','200','1025',468,'Retail Sale Id 1277129',4001.60,0.00,0.00,0.00,427.00,'2021-12-04 15:43:10','',''),(2158182,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 15:43:10','',''),(2158440,'1','200','1025',468,'Retail Sale Id 1277250',8200.00,0.00,0.00,0.00,875.00,'2021-12-04 15:55:24','',''),(2158441,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:55:24','',''),(2158740,'1','200',NULL,468,'Purchased from AA RANO NIGERIA LIMITED',0.00,14655860.00,25010.00,0.00,0.00,'2021-12-04 16:09:53','',''),(2158799,'1','200',NULL,468,'Reception corrector for bridging 126223',0.00,0.00,0.00,25010.00,0.00,'2021-12-04 16:12:28','',''),(2158800,'1','200','1025',468,'Received from bridging 126223',0.00,0.00,25010.00,0.00,0.00,'2021-12-04 16:12:28','',''),(2159077,'1','200','1025',468,'Retail Sale Id 1277598',2624.00,0.00,0.00,0.00,280.00,'2021-12-04 16:25:24','',''),(2159078,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 16:25:24','',''),(2159579,'1','200','1025',468,'Retail Sale Id 1277869',6999.52,0.00,0.00,0.00,746.90,'2021-12-04 16:48:12','',''),(2159580,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-04 16:48:12','',''),(2159932,'1','200','1025',468,'Retail Sale Id 1278038',2801.12,0.00,0.00,0.00,298.90,'2021-12-04 17:07:52','',''),(2159933,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.27,0.00,'2021-12-04 17:07:52','',''),(2161236,'1','200','1025',468,'Retail Sale Id 1278561',58974.40,0.00,0.00,0.00,6293.00,'2021-12-04 19:20:32','',''),(2161237,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,89.90,0.00,'2021-12-04 19:20:32','',''),(2161243,'1','200','1025',468,'Retail Sale Id 1278563',335463.40,0.00,0.00,0.00,18396.38,'2021-12-04 19:21:40','',''),(2161244,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,541.07,0.00,'2021-12-04 19:21:40','',''),(2164098,'1','200','1025',468,'Retail Sale Id 1279768',1968.00,0.00,0.00,0.00,210.00,'2021-12-05 08:17:58','',''),(2164099,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 08:17:58','',''),(2164154,'1','200','1025',468,'Retail Sale Id 1279792',1351.36,0.00,0.00,0.00,144.20,'2021-12-05 08:20:15','',''),(2164155,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-05 08:20:15','',''),(2164192,'1','200','1025',468,'Retail Sale Id 1279816',2000.80,0.00,0.00,0.00,213.50,'2021-12-05 08:22:03','',''),(2164193,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:22:03','',''),(2164296,'1','200','1025',468,'Retail Sale Id 1279860',3280.00,0.00,0.00,0.00,350.00,'2021-12-05 08:25:52','',''),(2164297,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:25:52','',''),(2164496,'1','200','1025',468,'Retail Sale Id 1279978',2000.80,0.00,0.00,0.00,213.50,'2021-12-05 08:36:02','',''),(2164497,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:36:02','',''),(2164560,'1','200','1025',468,'Retail Sale Id 1280009',3949.12,0.00,0.00,0.00,421.40,'2021-12-05 08:39:47','',''),(2164561,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 08:39:47','',''),(2165097,'1','200','1025',468,'Retail Sale Id 1280278',3936.00,0.00,0.00,0.00,420.00,'2021-12-05 09:08:38','',''),(2165098,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:08:38','',''),(2166367,'1','200','1025',468,'Retail Sale Id 1280948',2997.92,0.00,0.00,0.00,319.90,'2021-12-05 10:17:27','',''),(2166368,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 10:17:27','',''),(2166748,'1','200','1025',468,'Retail Sale Id 1281144',2624.00,0.00,0.00,0.00,280.00,'2021-12-05 10:41:11','',''),(2166749,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 10:41:11','',''),(2166782,'1','200','1025',468,'Retail Sale Id 1281160',8200.00,0.00,0.00,0.00,875.00,'2021-12-05 10:43:43','',''),(2166783,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:43:43','',''),(2166885,'1','200','1025',468,'Retail Sale Id 1281217',1318.56,0.00,0.00,0.00,140.70,'2021-12-05 10:48:14','',''),(2166886,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-05 10:48:14','',''),(2166887,'1','200','1025',468,'Retail Sale Id 1281217',1922.08,0.00,0.00,0.00,205.10,'2021-12-05 10:48:14','',''),(2166888,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.93,0.00,'2021-12-05 10:48:14','',''),(2166985,'1','200','1025',468,'Retail Sale Id 1281270',8200.00,0.00,0.00,0.00,875.00,'2021-12-05 10:53:35','',''),(2166986,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:53:35','',''),(2167045,'1','200','1025',468,'Retail Sale Id 1281301',8200.00,0.00,0.00,0.00,875.00,'2021-12-05 10:57:25','',''),(2167046,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:57:25','',''),(2167300,'1','200','1025',468,'Retail Sale Id 1281444',997.12,0.00,0.00,0.00,106.40,'2021-12-05 11:12:03','',''),(2167301,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 11:12:03','',''),(2167435,'1','200','1025',468,'Retail Sale Id 1281502',186000.00,0.00,0.00,0.00,10200.00,'2021-12-05 11:20:27','',''),(2167436,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-05 11:20:27','',''),(2167465,'1','200','1025',468,'Retail Sale Id 1281517',4001.60,0.00,0.00,0.00,427.00,'2021-12-05 11:22:28','',''),(2167466,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 11:22:28','',''),(2167565,'1','200','1025',468,'Retail Sale Id 1281568',2997.92,0.00,0.00,0.00,319.90,'2021-12-05 11:27:59','',''),(2167566,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 11:27:59','',''),(2168222,'1','200','1025',468,'Retail Sale Id 1281950',2630.56,0.00,0.00,0.00,280.70,'2021-12-05 12:05:31','',''),(2168223,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-05 12:05:31','',''),(2168593,'1','200','1025',468,'Retail Sale Id 1282131',3280.00,0.00,0.00,0.00,350.00,'2021-12-05 12:21:50','',''),(2168594,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:21:50','',''),(2168643,'1','200','1025',468,'Retail Sale Id 1282159',2000.80,0.00,0.00,0.00,213.50,'2021-12-05 12:24:07','',''),(2168644,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 12:24:07','',''),(2168870,'1','200','1025',468,'Retail Sale Id 1282275',2997.92,0.00,0.00,0.00,319.90,'2021-12-05 12:34:13','',''),(2168871,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 12:34:13','',''),(2169169,'1','200','1025',468,'Retail Sale Id 1282447',3942.56,0.00,0.00,0.00,420.70,'2021-12-05 12:52:08','',''),(2169170,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 12:52:08','',''),(2169199,'1','200','1025',468,'Retail Sale Id 1282464',3608.00,0.00,0.00,0.00,385.00,'2021-12-05 12:53:54','',''),(2169200,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-05 12:53:54','',''),(2169534,'1','200','1025',468,'Retail Sale Id 1282651',3949.12,0.00,0.00,0.00,421.40,'2021-12-05 13:10:46','',''),(2169535,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 13:10:46','',''),(2169704,'1','200','1025',468,'Retail Sale Id 1282732',8200.00,0.00,0.00,0.00,875.00,'2021-12-05 13:21:11','',''),(2169705,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:21:11','',''),(2169885,'1','200','1025',468,'Retail Sale Id 1282825',7878.56,0.00,0.00,0.00,840.70,'2021-12-05 13:31:32','',''),(2169886,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.01,0.00,'2021-12-05 13:31:32','',''),(2169959,'1','200','1025',468,'Retail Sale Id 1282855',8200.00,0.00,0.00,0.00,875.00,'2021-12-05 13:34:46','',''),(2169960,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:34:46','',''),(2170186,'1','200','1025',468,'Retail Sale Id 1282935',8200.00,0.00,0.00,0.00,875.00,'2021-12-05 13:45:28','',''),(2170187,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:45:28','',''),(2171876,'1','200','1025',468,'Retail Sale Id 1283665',8200.00,0.00,0.00,0.00,875.00,'2021-12-05 15:25:13','',''),(2171877,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:25:13','',''),(2172171,'1','200','1025',468,'Retail Sale Id 1283810',1502.24,0.00,0.00,0.00,160.30,'2021-12-05 15:41:02','',''),(2172172,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 15:41:02','',''),(2172353,'1','200','1025',468,'Retail Sale Id 1283906',2053.28,0.00,0.00,0.00,219.10,'2021-12-05 15:49:21','',''),(2172354,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 15:49:21','',''),(2172355,'1','200','1025',468,'Retail Sale Id 1283906',3949.12,0.00,0.00,0.00,421.40,'2021-12-05 15:49:21','',''),(2172356,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 15:49:21','',''),(2172414,'1','200','1025',468,'Retail Sale Id 1283940',6002.40,0.00,0.00,0.00,640.50,'2021-12-05 15:53:01','',''),(2172415,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-05 15:53:01','',''),(2172546,'1','200','1025',468,'Retail Sale Id 1284010',997.12,0.00,0.00,0.00,106.40,'2021-12-05 16:00:40','',''),(2172547,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 16:00:40','',''),(2172690,'1','200','1025',468,'Retail Sale Id 1284080',3949.12,0.00,0.00,0.00,421.40,'2021-12-05 16:09:32','',''),(2172691,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 16:09:32','',''),(2172728,'1','200','1025',468,'Retail Sale Id 1284101',2630.56,0.00,0.00,0.00,280.70,'2021-12-05 16:12:11','',''),(2172729,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-05 16:12:11','',''),(2172744,'1','200','1025',468,'Retail Sale Id 1284109',2000.80,0.00,0.00,0.00,213.50,'2021-12-05 16:13:21','',''),(2172745,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:13:21','',''),(2172766,'1','200','1025',468,'Retail Sale Id 1284120',8200.00,0.00,0.00,0.00,875.00,'2021-12-05 16:14:33','',''),(2172767,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:14:33','',''),(2172792,'1','200','1025',468,'Retail Sale Id 1284133',3949.12,0.00,0.00,0.00,421.40,'2021-12-05 16:16:55','',''),(2172793,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 16:16:55','',''),(2172830,'1','200','1025',468,'Retail Sale Id 1284153',2650.24,0.00,0.00,0.00,282.80,'2021-12-05 16:19:16','',''),(2172831,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.04,0.00,'2021-12-05 16:19:16','',''),(2172912,'1','200','1025',468,'Retail Sale Id 1284199',701.92,0.00,0.00,0.00,74.90,'2021-12-05 16:23:51','',''),(2172913,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-05 16:23:51','',''),(2172983,'1','200','1025',468,'Retail Sale Id 1284235',3949.12,0.00,0.00,0.00,421.40,'2021-12-05 16:29:01','',''),(2172984,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-05 16:29:01','',''),(2173213,'1','200','1025',468,'Retail Sale Id 1284360',2000.80,0.00,0.00,0.00,213.50,'2021-12-05 16:42:16','',''),(2173214,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 16:42:16','',''),(2173269,'1','200','1025',468,'Retail Sale Id 1284387',1502.24,0.00,0.00,0.00,160.30,'2021-12-05 16:45:39','',''),(2173270,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 16:45:39','',''),(2174078,'1','200','1025',468,'Retail Sale Id 1284787',65100.00,0.00,0.00,0.00,3570.00,'2021-12-05 17:55:40','',''),(2174079,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-05 17:55:40','',''),(2174141,'1','200','1025',468,'Retail Sale Id 1284811',63468.00,0.00,0.00,0.00,6772.50,'2021-12-05 18:05:47','',''),(2174142,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,96.75,0.00,'2021-12-05 18:05:47','',''),(2174198,'1','200','1025',468,'Return of Retail Sale Id 1279792',0.00,1351.36,2.06,0.00,-144.20,'2021-12-05 18:15:22','',''),(2175445,'1','200','1025',468,'Retail Sale Id 1285171',3280.00,0.00,0.00,0.00,350.00,'2021-12-06 07:03:40','',''),(2175446,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:03:40','',''),(2175638,'1','200','1025',468,'Retail Sale Id 1285275',2801.12,0.00,0.00,0.00,298.90,'2021-12-06 07:17:54','',''),(2175639,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.27,0.00,'2021-12-06 07:17:54','',''),(2175883,'1','200','1025',468,'Retail Sale Id 1285397',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 07:32:48','',''),(2175884,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 07:32:48','',''),(2176033,'1','200','1025',468,'Retail Sale Id 1285472',1502.24,0.00,0.00,0.00,160.30,'2021-12-06 07:41:13','',''),(2176034,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 07:41:13','',''),(2176231,'1','200','1025',468,'Retail Sale Id 1285566',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 07:49:17','',''),(2176232,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:49:17','',''),(2176270,'1','200','1025',468,'Retail Sale Id 1285586',37200.00,0.00,0.00,0.00,2040.00,'2021-12-06 07:51:17','',''),(2176271,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 07:51:17','',''),(2176452,'1','200','1025',468,'Retail Sale Id 1285658',155000.00,0.00,0.00,0.00,8500.00,'2021-12-06 07:58:31','',''),(2176453,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-06 07:58:31','',''),(2176489,'1','200','1025',468,'Retail Sale Id 1285680',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 08:00:40','',''),(2176490,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 08:00:40','',''),(2176558,'1','200','1025',468,'Retail Sale Id 1285724',6002.40,0.00,0.00,0.00,640.50,'2021-12-06 08:05:05','',''),(2176559,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-06 08:05:05','',''),(2176728,'1','200','1025',468,'Retail Sale Id 1285811',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 08:14:56','',''),(2176729,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:14:56','',''),(2176808,'1','200','1025',468,'Retail Sale Id 1285851',4998.72,0.00,0.00,0.00,533.40,'2021-12-06 08:21:28','',''),(2176809,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 08:21:28','',''),(2176853,'1','200','1025',468,'Retail Sale Id 1285874',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 08:26:25','',''),(2176854,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:26:25','',''),(2176974,'1','200','1025',468,'Retail Sale Id 1285935',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 08:35:53','',''),(2176975,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 08:35:53','',''),(2177033,'1','200','1025',468,'Retail Sale Id 1285962',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 08:41:05','',''),(2177034,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:41:05','',''),(2177102,'1','200','1025',468,'Retail Sale Id 1285994',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 08:45:30','',''),(2177103,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:45:30','',''),(2177104,'1','200','1025',468,'Retail Sale Id 1285994',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 08:45:30','',''),(2177105,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 08:45:30','',''),(2177138,'1','200','1025',468,'Retail Sale Id 1286010',997.12,0.00,0.00,0.00,106.40,'2021-12-06 08:48:02','',''),(2177139,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 08:48:02','',''),(2177181,'1','200','1025',468,'Retail Sale Id 1286032',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 08:50:57','',''),(2177182,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 08:50:57','',''),(2177243,'1','200','1025',468,'Retail Sale Id 1286064',997.12,0.00,0.00,0.00,106.40,'2021-12-06 08:55:57','',''),(2177244,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 08:55:57','',''),(2177540,'1','200','1025',468,'Retail Sale Id 1286201',2000.80,0.00,0.00,0.00,213.50,'2021-12-06 09:16:50','',''),(2177541,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 09:16:50','',''),(2177835,'1','200','1025',468,'Retail Sale Id 1286336',997.12,0.00,0.00,0.00,106.40,'2021-12-06 09:34:20','',''),(2177836,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 09:34:20','',''),(2177859,'1','200','1025',468,'Retail Sale Id 1286345',6560.00,0.00,0.00,0.00,700.00,'2021-12-06 09:36:05','',''),(2177860,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 09:36:05','',''),(2178320,'1','200','1025',468,'Retail Sale Id 1286557',1318.56,0.00,0.00,0.00,140.70,'2021-12-06 10:04:29','',''),(2178321,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-06 10:04:29','',''),(2178485,'1','200','1025',468,'Retail Sale Id 1286628',4598.56,0.00,0.00,0.00,490.70,'2021-12-06 10:12:44','',''),(2178486,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.01,0.00,'2021-12-06 10:12:44','',''),(2178643,'1','200','1025',468,'Retail Sale Id 1286713',1200.48,0.00,0.00,0.00,128.10,'2021-12-06 10:24:53','',''),(2178644,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.83,0.00,'2021-12-06 10:24:53','',''),(2178733,'1','200','1025',468,'Retail Sale Id 1286752',3280.00,0.00,0.00,0.00,350.00,'2021-12-06 10:30:14','',''),(2178734,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:30:14','',''),(2178846,'1','200','1025',468,'Retail Sale Id 1286821',3280.00,0.00,0.00,0.00,350.00,'2021-12-06 10:37:56','',''),(2178847,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:37:56','',''),(2179070,'1','200','1025',468,'Retail Sale Id 1286948',106020.00,0.00,0.00,0.00,5814.00,'2021-12-06 10:51:32','',''),(2179071,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,171.00,0.00,'2021-12-06 10:51:32','',''),(2179122,'1','200','1025',468,'Retail Sale Id 1286980',1318.56,0.00,0.00,0.00,140.70,'2021-12-06 10:54:54','',''),(2179123,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-06 10:54:54','',''),(2179153,'1','200','1025',468,'Retail Sale Id 1286996',3280.00,0.00,0.00,0.00,350.00,'2021-12-06 10:56:47','',''),(2179154,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:56:47','',''),(2179199,'1','200','1025',468,'Retail Sale Id 1287027',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 10:59:31','',''),(2179200,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 10:59:31','',''),(2179285,'1','200','1025',468,'Retail Sale Id 1287078',4998.72,0.00,0.00,0.00,533.40,'2021-12-06 11:05:17','',''),(2179286,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 11:05:17','',''),(2179341,'1','200','1025',468,'Retail Sale Id 1287107',7222.56,0.00,0.00,0.00,770.70,'2021-12-06 11:07:56','',''),(2179342,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,11.01,0.00,'2021-12-06 11:07:56','',''),(2179441,'1','200','1025',468,'Retail Sale Id 1287153',13120.00,0.00,0.00,0.00,1400.00,'2021-12-06 11:14:22','',''),(2179442,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 11:14:22','',''),(2179583,'1','200','1025',468,'Retail Sale Id 1287237',80600.00,0.00,0.00,0.00,4420.00,'2021-12-06 11:22:55','',''),(2179584,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-06 11:22:55','',''),(2179625,'1','200','1025',468,'Retail Sale Id 1287261',1318.56,0.00,0.00,0.00,140.70,'2021-12-06 11:26:13','',''),(2179626,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-06 11:26:13','',''),(2179918,'1','200','1025',468,'Retail Sale Id 1287474',19220.00,0.00,0.00,0.00,1054.00,'2021-12-06 11:48:53','',''),(2179919,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,31.00,0.00,'2021-12-06 11:48:53','',''),(2179970,'1','200','1025',468,'Retail Sale Id 1287504',4598.56,0.00,0.00,0.00,490.70,'2021-12-06 11:52:54','',''),(2179971,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.01,0.00,'2021-12-06 11:52:54','',''),(2180028,'1','200','1025',468,'Retail Sale Id 1287529',5910.56,0.00,0.00,0.00,630.70,'2021-12-06 11:56:03','',''),(2180029,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.01,0.00,'2021-12-06 11:56:03','',''),(2180398,'1','200','1025',468,'Retail Sale Id 1287739',3936.00,0.00,0.00,0.00,420.00,'2021-12-06 12:18:36','',''),(2180399,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:18:36','',''),(2180400,'1','200','1025',468,'Retail Sale Id 1287739',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 12:18:36','',''),(2180401,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:18:36','',''),(2180402,'1','200','1025',468,'Retail Sale Id 1287739',9840.00,0.00,0.00,0.00,1050.00,'2021-12-06 12:18:36','',''),(2180403,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 12:18:36','',''),(2181006,'1','200','1025',468,'Retail Sale Id 1288050',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 12:56:27','',''),(2181007,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:56:27','',''),(2181057,'1','200','1025',468,'Retail Sale Id 1288079',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 12:59:06','',''),(2181058,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 12:59:06','',''),(2181102,'1','200','1025',468,'Retail Sale Id 1288097',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 13:01:08','',''),(2181103,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:01:08','',''),(2181132,'1','200','1025',468,'Retail Sale Id 1288111',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 13:02:51','',''),(2181133,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:02:51','',''),(2181156,'1','200','1025',468,'Retail Sale Id 1288123',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 13:04:38','',''),(2181157,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:04:38','',''),(2181192,'1','200','1025',468,'Retail Sale Id 1288141',1640.00,0.00,0.00,0.00,175.00,'2021-12-06 13:07:03','',''),(2181193,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 13:07:03','',''),(2181373,'1','200','1025',468,'Retail Sale Id 1288235',3280.00,0.00,0.00,0.00,350.00,'2021-12-06 13:15:57','',''),(2181374,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:15:57','',''),(2181437,'1','200','1025',468,'Retail Sale Id 1288254',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 13:19:01','',''),(2181438,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:19:01','',''),(2181588,'1','200','1025',468,'Retail Sale Id 1288329',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 13:30:26','',''),(2181589,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:30:26','',''),(2181756,'1','200','1025',468,'Retail Sale Id 1288390',6560.00,0.00,0.00,0.00,700.00,'2021-12-06 13:38:59','',''),(2181757,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 13:38:59','',''),(2181873,'1','200','1025',468,'Retail Sale Id 1288443',2000.80,0.00,0.00,0.00,213.50,'2021-12-06 13:43:51','',''),(2181874,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 13:43:51','',''),(2181939,'1','200','1025',468,'Retail Sale Id 1288477',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 13:47:13','',''),(2181940,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:47:13','',''),(2182233,'1','200','1025',468,'Retail Sale Id 1288608',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 14:00:57','',''),(2182234,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:00:57','',''),(2182265,'1','200','1025',468,'Retail Sale Id 1288625',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 14:02:47','',''),(2182266,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:02:47','',''),(2182726,'1','200','1025',468,'Retail Sale Id 1288828',2630.56,0.00,0.00,0.00,280.70,'2021-12-06 14:24:05','',''),(2182727,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-06 14:24:05','',''),(2183291,'1','200','1025',468,'Retail Sale Id 1289087',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 14:53:11','',''),(2183292,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 14:53:11','',''),(2183473,'1','200','1025',468,'Retail Sale Id 1289181',62000.00,0.00,0.00,0.00,3400.00,'2021-12-06 15:02:55','',''),(2183474,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 15:02:55','',''),(2183544,'1','200','1025',468,'Retail Sale Id 1289212',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 15:06:44','',''),(2183546,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:06:44','',''),(2183953,'1','200','1025',468,'Retail Sale Id 1289392',5248.00,0.00,0.00,0.00,560.00,'2021-12-06 15:26:19','',''),(2183954,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 15:26:19','',''),(2184136,'1','200','1025',468,'Retail Sale Id 1289487',3942.56,0.00,0.00,0.00,420.70,'2021-12-06 15:36:46','',''),(2184137,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 15:36:46','',''),(2184209,'1','200','1025',468,'Retail Sale Id 1289516',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 15:39:27','',''),(2184210,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:39:27','',''),(2184276,'1','200','1025',468,'Retail Sale Id 1289533',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 15:41:24','',''),(2184277,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:41:24','',''),(2184393,'1','200','1025',468,'Retail Sale Id 1289571',3942.56,0.00,0.00,0.00,420.70,'2021-12-06 15:45:12','',''),(2184394,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 15:45:12','',''),(2184888,'1','200','1025',468,'Retail Sale Id 1289793',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 16:12:47','',''),(2184889,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 16:12:47','',''),(2184919,'1','200','1025',468,'Retail Sale Id 1289807',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 16:15:00','',''),(2184920,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:15:00','',''),(2184956,'1','200','1025',468,'Retail Sale Id 1289822',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 16:17:05','',''),(2184957,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:17:05','',''),(2185001,'1','200','1025',468,'Retail Sale Id 1289845',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 16:19:08','',''),(2185002,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 16:19:08','',''),(2185031,'1','200','1025',468,'Retail Sale Id 1289863',656.00,0.00,0.00,0.00,70.00,'2021-12-06 16:20:48','',''),(2185032,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 16:20:48','',''),(2185083,'1','200','1025',468,'Retail Sale Id 1289882',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 16:23:13','',''),(2185084,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:23:13','',''),(2185129,'1','200','1025',468,'Retail Sale Id 1289909',5910.56,0.00,0.00,0.00,630.70,'2021-12-06 16:25:40','',''),(2185130,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.01,0.00,'2021-12-06 16:25:40','',''),(2185195,'1','200','1025',468,'Retail Sale Id 1289943',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 16:29:01','',''),(2185196,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 16:29:01','',''),(2185291,'1','200','1025',468,'Retail Sale Id 1289990',1968.00,0.00,0.00,0.00,210.00,'2021-12-06 16:33:35','',''),(2185292,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:33:35','',''),(2185456,'1','200','1025',468,'Retail Sale Id 1290067',3280.00,0.00,0.00,0.00,350.00,'2021-12-06 16:42:44','',''),(2185457,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:42:44','',''),(2185519,'1','200','1025',468,'Retail Sale Id 1290098',3949.12,0.00,0.00,0.00,421.40,'2021-12-06 16:46:58','',''),(2185520,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-06 16:46:58','',''),(2185599,'1','200','1025',468,'Retail Sale Id 1290137',2630.56,0.00,0.00,0.00,280.70,'2021-12-06 16:50:05','',''),(2185600,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-06 16:50:05','',''),(2185645,'1','200','1025',468,'Retail Sale Id 1290161',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 16:52:17','',''),(2185646,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:52:17','',''),(2185820,'1','200','1025',468,'Retail Sale Id 1290256',3280.00,0.00,0.00,0.00,350.00,'2021-12-06 17:03:54','',''),(2185821,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 17:03:54','',''),(2185855,'1','200','1025',468,'Retail Sale Id 1290274',37200.00,0.00,0.00,0.00,2040.00,'2021-12-06 17:06:38','',''),(2185856,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 17:06:38','',''),(2185901,'1','200','1025',468,'Retail Sale Id 1290297',8200.00,0.00,0.00,0.00,875.00,'2021-12-06 17:09:25','',''),(2185902,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:09:25','',''),(2185925,'1','200','1025',468,'Retail Sale Id 1290312',997.12,0.00,0.00,0.00,106.40,'2021-12-06 17:11:14','',''),(2185926,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 17:11:14','',''),(2185959,'1','200','1025',468,'Retail Sale Id 1290331',27900.00,0.00,0.00,0.00,1530.00,'2021-12-06 17:13:10','',''),(2185960,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-06 17:13:10','',''),(2186517,'1','200','1025',468,'Return of Retail Sale Id 1286821',0.00,3280.00,5.00,0.00,-350.00,'2021-12-06 18:34:16','',''),(2186518,'1','200','1025',468,'Return of Retail Sale Id 1290312',0.00,997.12,1.52,0.00,-106.40,'2021-12-06 18:35:38','',''),(2187832,'1','200','1025',468,'Retail Sale Id 1290990',6560.00,0.00,0.00,0.00,700.00,'2021-12-07 06:53:34','',''),(2187833,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 06:53:34','',''),(2188565,'1','200','1025',468,'Retail Sale Id 1291353',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 07:29:49','',''),(2188566,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:29:49','',''),(2188632,'1','200','1025',468,'Retail Sale Id 1291390',2000.80,0.00,0.00,0.00,213.50,'2021-12-07 07:32:43','',''),(2188633,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 07:32:43','',''),(2188716,'1','200','1025',468,'Retail Sale Id 1291435',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 07:37:13','',''),(2188717,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:37:13','',''),(2188896,'1','200','1025',468,'Retail Sale Id 1291546',2000.80,0.00,0.00,0.00,213.50,'2021-12-07 07:46:44','',''),(2188897,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 07:46:44','',''),(2188938,'1','200','1025',468,'Retail Sale Id 1291575',6560.00,0.00,0.00,0.00,700.00,'2021-12-07 07:49:25','',''),(2188939,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 07:49:25','',''),(2189035,'1','200','1025',468,'Retail Sale Id 1291617',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 07:54:17','',''),(2189036,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:54:17','',''),(2189037,'1','200','1025',468,'Retail Sale Id 1291617',3280.00,0.00,0.00,0.00,350.00,'2021-12-07 07:54:17','',''),(2189038,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:54:17','',''),(2189079,'1','200','1025',468,'Retail Sale Id 1291636',2997.92,0.00,0.00,0.00,319.90,'2021-12-07 07:56:34','',''),(2189080,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 07:56:34','',''),(2189185,'1','200','1025',468,'Retail Sale Id 1291687',2630.56,0.00,0.00,0.00,280.70,'2021-12-07 08:02:53','',''),(2189186,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-07 08:02:53','',''),(2189416,'1','200','1025',468,'Retail Sale Id 1291792',1318.56,0.00,0.00,0.00,140.70,'2021-12-07 08:15:28','',''),(2189417,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-07 08:15:28','',''),(2189448,'1','200','1025',468,'Retail Sale Id 1291813',82000.00,0.00,0.00,0.00,8750.00,'2021-12-07 08:17:25','',''),(2189449,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-07 08:17:25','',''),(2189509,'1','200','1025',468,'Return of Retail Sale Id 1291813',0.00,82000.00,125.00,0.00,-8750.00,'2021-12-07 08:21:00','',''),(2189513,'1','200','1025',468,'Retail Sale Id 1291844',62000.00,0.00,0.00,0.00,3400.00,'2021-12-07 08:21:22','',''),(2189514,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 08:21:22','',''),(2189537,'1','200','1025',468,'Retail Sale Id 1291857',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 08:22:34','',''),(2189538,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:22:34','',''),(2189557,'1','200','1025',468,'Retail Sale Id 1291864',7878.56,0.00,0.00,0.00,840.70,'2021-12-07 08:23:40','',''),(2189558,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.01,0.00,'2021-12-07 08:23:40','',''),(2189637,'1','200','1025',468,'Retail Sale Id 1291903',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 08:29:32','',''),(2189638,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:29:32','',''),(2190025,'1','200','1025',468,'Retail Sale Id 1292059',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 08:48:08','',''),(2190026,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:48:08','',''),(2190061,'1','200','1025',468,'Retail Sale Id 1292080',3942.56,0.00,0.00,0.00,420.70,'2021-12-07 08:50:09','',''),(2190062,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 08:50:09','',''),(2190120,'1','200','1025',468,'Retail Sale Id 1292101',3942.56,0.00,0.00,0.00,420.70,'2021-12-07 08:53:02','',''),(2190121,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 08:53:02','',''),(2190866,'1','200','1025',468,'Retail Sale Id 1292463',1318.56,0.00,0.00,0.00,140.70,'2021-12-07 09:33:11','',''),(2190867,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-07 09:33:11','',''),(2190912,'1','200','1025',468,'Retail Sale Id 1292485',7222.56,0.00,0.00,0.00,770.70,'2021-12-07 09:35:40','',''),(2190913,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,11.01,0.00,'2021-12-07 09:35:40','',''),(2191000,'1','200','1025',468,'Retail Sale Id 1292533',7222.56,0.00,0.00,0.00,770.70,'2021-12-07 09:40:37','',''),(2191001,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,11.01,0.00,'2021-12-07 09:40:37','',''),(2191164,'1','200','1025',468,'Retail Sale Id 1292621',3942.56,0.00,0.00,0.00,420.70,'2021-12-07 09:52:19','',''),(2191165,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 09:52:19','',''),(2191258,'1','200','1025',468,'Retail Sale Id 1292671',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 09:59:20','',''),(2191259,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:59:20','',''),(2191378,'1','200','1025',468,'Retail Sale Id 1292730',9300.00,0.00,0.00,0.00,510.00,'2021-12-07 10:07:14','',''),(2191379,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-07 10:07:14','',''),(2191405,'1','200','1025',468,'Retail Sale Id 1292741',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 10:08:15','',''),(2191406,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:08:15','',''),(2191427,'1','200','1025',468,'Retail Sale Id 1292752',1318.56,0.00,0.00,0.00,140.70,'2021-12-07 10:10:12','',''),(2191428,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-07 10:10:12','',''),(2191511,'1','200','1025',468,'Retail Sale Id 1292800',204600.00,0.00,0.00,0.00,11220.00,'2021-12-07 10:15:36','',''),(2191512,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,330.00,0.00,'2021-12-07 10:15:36','',''),(2191541,'1','200','1025',468,'Retail Sale Id 1292817',3280.00,0.00,0.00,0.00,350.00,'2021-12-07 10:17:20','',''),(2191542,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 10:17:20','',''),(2191688,'1','200','1025',468,'Retail Sale Id 1292890',662.56,0.00,0.00,0.00,70.70,'2021-12-07 10:29:07','',''),(2191689,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-07 10:29:07','',''),(2191801,'1','200','1025',468,'Retail Sale Id 1292951',310000.00,0.00,0.00,0.00,17000.00,'2021-12-07 10:38:09','',''),(2191802,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,500.00,0.00,'2021-12-07 10:38:09','',''),(2191879,'1','200','1025',468,'Retail Sale Id 1292990',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 10:42:37','',''),(2191880,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:42:37','',''),(2191903,'1','200','1025',468,'Retail Sale Id 1293002',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 10:44:11','',''),(2191904,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:44:11','',''),(2191975,'1','200','1025',468,'Retail Sale Id 1293028',7878.56,0.00,0.00,0.00,840.70,'2021-12-07 10:46:47','',''),(2191976,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.01,0.00,'2021-12-07 10:46:47','',''),(2192288,'1','200','1025',468,'Retail Sale Id 1293169',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 11:02:48','',''),(2192289,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:02:48','',''),(2192418,'1','200','1025',468,'Retail Sale Id 1293233',997.12,0.00,0.00,0.00,106.40,'2021-12-07 11:09:30','',''),(2192419,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 11:09:30','',''),(2192468,'1','200','1025',468,'Retail Sale Id 1293263',5248.00,0.00,0.00,0.00,560.00,'2021-12-07 11:11:50','',''),(2192469,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 11:11:50','',''),(2192544,'1','200','1025',468,'Retail Sale Id 1293305',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 11:16:44','',''),(2192545,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:16:44','',''),(2192590,'1','200','1025',468,'Retail Sale Id 1293346',65100.00,0.00,0.00,0.00,3570.00,'2021-12-07 11:20:04','',''),(2192591,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-07 11:20:04','',''),(2192652,'1','200','1025',468,'Retail Sale Id 1293391',1318.56,0.00,0.00,0.00,140.70,'2021-12-07 11:25:20','',''),(2192653,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-07 11:25:20','',''),(2192871,'1','200','1025',468,'Retail Sale Id 1293500',3280.00,0.00,0.00,0.00,350.00,'2021-12-07 11:40:55','',''),(2192872,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:40:55','',''),(2192901,'1','200','1025',468,'Retail Sale Id 1293518',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 11:42:56','',''),(2192902,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:42:56','',''),(2192973,'1','200','1025',468,'Retail Sale Id 1293541',1502.24,0.00,0.00,0.00,160.30,'2021-12-07 11:45:58','',''),(2192974,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-07 11:45:58','',''),(2192975,'1','200','1025',468,'Retail Sale Id 1293541',2997.92,0.00,0.00,0.00,319.90,'2021-12-07 11:45:58','',''),(2192976,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-07 11:45:58','',''),(2192989,'1','200','1025',468,'Retail Sale Id 1293547',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 11:47:27','',''),(2192990,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:47:27','',''),(2193009,'1','200','1025',468,'Retail Sale Id 1293557',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 11:49:58','',''),(2193010,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:49:58','',''),(2193137,'1','200','1025',468,'Retail Sale Id 1293635',2000.80,0.00,0.00,0.00,213.50,'2021-12-07 12:01:45','',''),(2193138,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 12:01:45','',''),(2193187,'1','200','1025',468,'Retail Sale Id 1293665',3280.00,0.00,0.00,0.00,350.00,'2021-12-07 12:06:57','',''),(2193188,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 12:06:57','',''),(2193219,'1','200','1025',468,'Retail Sale Id 1293682',997.12,0.00,0.00,0.00,106.40,'2021-12-07 12:10:59','',''),(2193220,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 12:10:59','',''),(2193221,'1','200','1025',468,'Retail Sale Id 1293682',3942.56,0.00,0.00,0.00,420.70,'2021-12-07 12:10:59','',''),(2193222,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 12:10:59','',''),(2193223,'1','200','1025',468,'Retail Sale Id 1293682',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 12:10:59','',''),(2193224,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:10:59','',''),(2193225,'1','200','1025',468,'Retail Sale Id 1293682',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 12:10:59','',''),(2193226,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:10:59','',''),(2193269,'1','200','1025',468,'Retail Sale Id 1293705',3949.12,0.00,0.00,0.00,421.40,'2021-12-07 12:13:27','',''),(2193270,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 12:13:27','',''),(2193323,'1','200','1025',468,'Retail Sale Id 1293735',3280.00,0.00,0.00,0.00,350.00,'2021-12-07 12:18:18','',''),(2193324,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 12:18:18','',''),(2193631,'1','200','1025',468,'Retail Sale Id 1293898',3949.12,0.00,0.00,0.00,421.40,'2021-12-07 12:45:09','',''),(2193632,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 12:45:09','',''),(2193845,'1','200','1025',468,'Retail Sale Id 1294021',3949.12,0.00,0.00,0.00,421.40,'2021-12-07 12:58:58','',''),(2193846,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 12:58:58','',''),(2193940,'1','200','1025',468,'Retail Sale Id 1294066',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 13:04:53','',''),(2193941,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:04:53','',''),(2194104,'1','200','1025',468,'Retail Sale Id 1294153',31000.00,0.00,0.00,0.00,1700.00,'2021-12-07 13:16:09','',''),(2194105,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 13:16:09','',''),(2194357,'1','200','1025',468,'Retail Sale Id 1294346',2630.56,0.00,0.00,0.00,280.70,'2021-12-07 13:29:16','',''),(2194358,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-07 13:29:16','',''),(2194603,'1','200','1025',468,'Retail Sale Id 1294445',7878.56,0.00,0.00,0.00,840.70,'2021-12-07 13:43:05','',''),(2194604,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.01,0.00,'2021-12-07 13:43:05','',''),(2194617,'1','200','1025',468,'Retail Sale Id 1294453',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 13:44:22','',''),(2194618,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:44:22','',''),(2194651,'1','200','1025',468,'Retail Sale Id 1294468',1860.00,0.00,0.00,0.00,102.00,'2021-12-07 13:46:28','',''),(2194652,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 13:46:28','',''),(2194957,'1','200','1025',468,'Retail Sale Id 1294616',3280.00,0.00,0.00,0.00,350.00,'2021-12-07 14:06:50','',''),(2194958,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:06:50','',''),(2195328,'1','200','1025',468,'Retail Sale Id 1294769',3942.56,0.00,0.00,0.00,420.70,'2021-12-07 14:25:19','',''),(2195329,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 14:25:19','',''),(2195362,'1','200','1025',468,'Retail Sale Id 1294786',3280.00,0.00,0.00,0.00,350.00,'2021-12-07 14:26:52','',''),(2195363,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:26:52','',''),(2195682,'1','200','1025',468,'Retail Sale Id 1294950',1318.56,0.00,0.00,0.00,140.70,'2021-12-07 14:44:57','',''),(2195683,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-07 14:44:57','',''),(2195954,'1','200','1025',468,'Retail Sale Id 1295099',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 15:00:18','',''),(2195955,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:00:18','',''),(2195956,'1','200','1025',468,'Retail Sale Id 1295099',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 15:00:18','',''),(2195957,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:00:18','',''),(2196021,'1','200','1025',468,'Retail Sale Id 1295122',6560.00,0.00,0.00,0.00,700.00,'2021-12-07 15:03:57','',''),(2196022,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 15:03:57','',''),(2196062,'1','200','1025',468,'Retail Sale Id 1295143',6888.00,0.00,0.00,0.00,735.00,'2021-12-07 15:06:32','',''),(2196063,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-07 15:06:32','',''),(2196064,'1','200','1025',468,'Retail Sale Id 1295143',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 15:06:32','',''),(2196065,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:06:32','',''),(2196088,'1','200','1025',468,'Retail Sale Id 1295156',4598.56,0.00,0.00,0.00,490.70,'2021-12-07 15:07:58','',''),(2196089,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.01,0.00,'2021-12-07 15:07:58','',''),(2196252,'1','200','1025',468,'Retail Sale Id 1295229',1640.00,0.00,0.00,0.00,175.00,'2021-12-07 15:15:45','',''),(2196253,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 15:15:45','',''),(2196528,'1','200','1025',468,'Retail Sale Id 1295383',2630.56,0.00,0.00,0.00,280.70,'2021-12-07 15:30:17','',''),(2196529,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-07 15:30:17','',''),(2196578,'1','200','1025',468,'Retail Sale Id 1295405',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 15:32:22','',''),(2196579,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:32:22','',''),(2196614,'1','200','1025',468,'Retail Sale Id 1295424',3949.12,0.00,0.00,0.00,421.40,'2021-12-07 15:34:15','',''),(2196615,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 15:34:15','',''),(2196689,'1','200','1025',468,'Retail Sale Id 1295460',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 15:37:55','',''),(2196690,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:37:55','',''),(2197012,'1','200','1025',468,'Retail Sale Id 1295620',4598.56,0.00,0.00,0.00,490.70,'2021-12-07 15:52:41','',''),(2197013,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.01,0.00,'2021-12-07 15:52:41','',''),(2197062,'1','200','1025',468,'Retail Sale Id 1295648',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 15:54:58','',''),(2197063,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:54:58','',''),(2197101,'1','200','1025',468,'Retail Sale Id 1295666',3949.12,0.00,0.00,0.00,421.40,'2021-12-07 15:56:47','',''),(2197102,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 15:56:47','',''),(2197155,'1','200','1025',468,'Retail Sale Id 1295694',1318.56,0.00,0.00,0.00,140.70,'2021-12-07 15:59:26','',''),(2197156,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-07 15:59:26','',''),(2197157,'1','200','1025',468,'Retail Sale Id 1295694',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 15:59:26','',''),(2197158,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:59:26','',''),(2197193,'1','200','1025',468,'Retail Sale Id 1295714',3949.12,0.00,0.00,0.00,421.40,'2021-12-07 16:01:21','',''),(2197194,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-07 16:01:21','',''),(2197253,'1','200','1025',468,'Retail Sale Id 1295745',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 16:04:46','',''),(2197254,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:04:46','',''),(2197494,'1','200','1025',468,'Retail Sale Id 1295870',1968.00,0.00,0.00,0.00,210.00,'2021-12-07 16:15:48','',''),(2197495,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:15:48','',''),(2197928,'1','200','1025',468,'Retail Sale Id 1296103',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 16:36:41','',''),(2197929,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:36:41','',''),(2198327,'1','200','1025',468,'Retail Sale Id 1296312',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 16:59:27','',''),(2198328,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:59:27','',''),(2198376,'1','200','1025',468,'Retail Sale Id 1296334',3280.00,0.00,0.00,0.00,350.00,'2021-12-07 17:01:46','',''),(2198377,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 17:01:46','',''),(2198407,'1','200','1025',468,'Retail Sale Id 1296346',1318.56,0.00,0.00,0.00,140.70,'2021-12-07 17:03:35','',''),(2198408,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-07 17:03:35','',''),(2198511,'1','200','1025',468,'Retail Sale Id 1296398',997.12,0.00,0.00,0.00,106.40,'2021-12-07 17:10:51','',''),(2198512,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 17:10:51','',''),(2198563,'1','200','1025',468,'Retail Sale Id 1296428',155000.00,0.00,0.00,0.00,8500.00,'2021-12-07 17:15:07','',''),(2198564,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-07 17:15:07','',''),(2198587,'1','200','1025',468,'Retail Sale Id 1296455',8200.00,0.00,0.00,0.00,875.00,'2021-12-07 17:16:53','',''),(2198588,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:16:53','',''),(2200359,'1','200','1025',468,'Retail Sale Id 1297032',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 06:55:47','',''),(2200360,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:55:47','',''),(2200501,'1','200','1025',468,'Retail Sale Id 1297104',3949.12,0.00,0.00,0.00,421.40,'2021-12-08 07:04:03','',''),(2200502,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 07:04:03','',''),(2200559,'1','200','1025',468,'Retail Sale Id 1297131',3949.12,0.00,0.00,0.00,421.40,'2021-12-08 07:07:24','',''),(2200560,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 07:07:24','',''),(2200737,'1','200','1025',468,'Retail Sale Id 1297208',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 07:18:42','',''),(2200738,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:18:42','',''),(2200842,'1','200','1025',468,'Retail Sale Id 1297263',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 07:23:29','',''),(2200843,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:23:29','',''),(2200993,'1','200','1025',468,'Retail Sale Id 1297331',498.56,0.00,0.00,0.00,53.20,'2021-12-08 07:32:23','',''),(2200994,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,0.76,0.00,'2021-12-08 07:32:23','',''),(2201188,'1','200','1025',468,'Retail Sale Id 1297417',2630.56,0.00,0.00,0.00,280.70,'2021-12-08 07:41:58','',''),(2201189,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-08 07:41:58','',''),(2201389,'1','200','1025',468,'Retail Sale Id 1297518',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 07:53:14','',''),(2201390,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:53:14','',''),(2201531,'1','200','1025',468,'Retail Sale Id 1297569',3949.12,0.00,0.00,0.00,421.40,'2021-12-08 07:59:03','',''),(2201532,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 07:59:03','',''),(2201565,'1','200','1025',468,'Retail Sale Id 1297585',3949.12,0.00,0.00,0.00,421.40,'2021-12-08 08:00:48','',''),(2201566,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 08:00:48','',''),(2201734,'1','200','1025',468,'Retail Sale Id 1297671',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 08:11:30','',''),(2201735,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:11:30','',''),(2201748,'1','200','1025',468,'Retail Sale Id 1297678',6560.00,0.00,0.00,0.00,700.00,'2021-12-08 08:12:34','',''),(2201749,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 08:12:34','',''),(2201768,'1','200','1025',468,'Retail Sale Id 1297689',3949.12,0.00,0.00,0.00,421.40,'2021-12-08 08:13:59','',''),(2201769,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 08:13:59','',''),(2201797,'1','200','1025',468,'Retail Sale Id 1297703',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 08:15:28','',''),(2201798,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:15:28','',''),(2201953,'1','200','1025',468,'Retail Sale Id 1297786',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 08:25:23','',''),(2201954,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:25:23','',''),(2201963,'1','200','1025',468,'Retail Sale Id 1297793',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 08:26:28','',''),(2201964,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:26:28','',''),(2202338,'1','200','1025',468,'Retail Sale Id 1297932',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 08:45:31','',''),(2202339,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:45:31','',''),(2202413,'1','200','1025',468,'Retail Sale Id 1297960',9512.00,0.00,0.00,0.00,1015.00,'2021-12-08 08:48:32','',''),(2202414,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,14.50,0.00,'2021-12-08 08:48:32','',''),(2202474,'1','200','1025',468,'Retail Sale Id 1297980',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 08:51:34','',''),(2202475,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:51:34','',''),(2202562,'1','200','1025',468,'Retail Sale Id 1298018',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 08:55:29','',''),(2202563,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:55:29','',''),(2202676,'1','200','1025',468,'Retail Sale Id 1298074',1318.56,0.00,0.00,0.00,140.70,'2021-12-08 09:03:18','',''),(2202677,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-08 09:03:18','',''),(2202678,'1','200','1025',468,'Retail Sale Id 1298074',1318.56,0.00,0.00,0.00,140.70,'2021-12-08 09:03:18','',''),(2202679,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-08 09:03:18','',''),(2202866,'1','200','1025',468,'Retail Sale Id 1298173',34100.00,0.00,0.00,0.00,1870.00,'2021-12-08 09:14:01','',''),(2202867,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-08 09:14:01','',''),(2202884,'1','200','1025',468,'Retail Sale Id 1298181',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 09:15:04','',''),(2202885,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:15:04','',''),(2202900,'1','200','1025',468,'Retail Sale Id 1298187',16400.00,0.00,0.00,0.00,1750.00,'2021-12-08 09:16:04','',''),(2202901,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 09:16:04','',''),(2203045,'1','200','1025',468,'Retail Sale Id 1298259',4998.72,0.00,0.00,0.00,533.40,'2021-12-08 09:26:47','',''),(2203046,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-08 09:26:47','',''),(2203065,'1','200','1025',468,'Retail Sale Id 1298268',3949.12,0.00,0.00,0.00,421.40,'2021-12-08 09:28:33','',''),(2203066,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 09:28:33','',''),(2203269,'1','200','1025',468,'Retail Sale Id 1298373',3949.12,0.00,0.00,0.00,421.40,'2021-12-08 09:45:47','',''),(2203270,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 09:45:47','',''),(2203338,'1','200','1025',468,'Retail Sale Id 1298401',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 09:49:53','',''),(2203339,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:49:53','',''),(2203410,'1','200','1025',468,'Retail Sale Id 1298434',115320.00,0.00,0.00,0.00,6324.00,'2021-12-08 09:55:30','',''),(2203411,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,186.00,0.00,'2021-12-08 09:55:30','',''),(2203617,'1','200','1025',468,'Retail Sale Id 1298517',23560.00,0.00,0.00,0.00,1292.00,'2021-12-08 10:09:37','',''),(2203618,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,38.00,0.00,'2021-12-08 10:09:37','',''),(2203663,'1','200','1025',468,'Retail Sale Id 1298546',662.56,0.00,0.00,0.00,70.70,'2021-12-08 10:12:34','',''),(2203664,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-08 10:12:34','',''),(2203783,'1','200','1025',468,'Retail Sale Id 1298601',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 10:19:50','',''),(2203784,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 10:19:50','',''),(2203813,'1','200','1025',468,'Retail Sale Id 1298628',3949.12,0.00,0.00,0.00,421.40,'2021-12-08 10:22:17','',''),(2203814,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 10:22:17','',''),(2203858,'1','200','1025',468,'Retail Sale Id 1298646',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 10:24:35','',''),(2203859,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 10:24:35','',''),(2203955,'1','200','1025',468,'Retail Sale Id 1298660',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 10:30:11','',''),(2203956,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 10:30:11','',''),(2204097,'1','200','1025',468,'Return of Retail Sale Id 1297960',0.00,9512.00,14.50,0.00,-1015.00,'2021-12-08 10:40:42','',''),(2204353,'1','200','1025',468,'Retail Sale Id 1298881',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 11:02:54','',''),(2204354,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:02:54','',''),(2204355,'1','200','1025',468,'Retail Sale Id 1298881',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 11:02:54','',''),(2204356,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:02:54','',''),(2204376,'1','200','1025',468,'Retail Sale Id 1298891',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 11:04:26','',''),(2204377,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:04:26','',''),(2204488,'1','200','1025',468,'Retail Sale Id 1298953',248000.00,0.00,0.00,0.00,13600.00,'2021-12-08 11:10:41','',''),(2204489,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-08 11:10:41','',''),(2204522,'1','200','1025',468,'Retail Sale Id 1298973',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 11:13:11','',''),(2204523,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:13:11','',''),(2204612,'1','200','1025',468,'Retail Sale Id 1299017',2000.80,0.00,0.00,0.00,213.50,'2021-12-08 11:20:27','',''),(2204613,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 11:20:27','',''),(2204734,'1','200','1025',468,'Retail Sale Id 1299078',4500.16,0.00,0.00,0.00,480.20,'2021-12-08 11:29:16','',''),(2204735,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-08 11:29:16','',''),(2204746,'1','200','1025',468,'Retail Sale Id 1299084',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 11:30:34','',''),(2204747,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:30:34','',''),(2204848,'1','200','1025',468,'Retail Sale Id 1299136',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 11:36:44','',''),(2204849,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:36:44','',''),(2205014,'1','200','1025',468,'Retail Sale Id 1299226',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 11:45:36','',''),(2205015,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:45:36','',''),(2205034,'1','200','1025',468,'Retail Sale Id 1299235',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 11:47:07','',''),(2205035,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:47:07','',''),(2205369,'1','200','1025',468,'Retail Sale Id 1299381',3942.56,0.00,0.00,0.00,420.70,'2021-12-08 12:12:58','',''),(2205370,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 12:12:58','',''),(2205391,'1','200','1025',468,'Retail Sale Id 1299391',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 12:14:32','',''),(2205392,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:14:32','',''),(2205437,'1','200','1025',468,'Retail Sale Id 1299413',2499.36,0.00,0.00,0.00,266.70,'2021-12-08 12:17:58','',''),(2205438,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-08 12:17:58','',''),(2205473,'1','200','1025',468,'Retail Sale Id 1299431',649.44,0.00,0.00,0.00,69.30,'2021-12-08 12:21:28','',''),(2205474,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,0.99,0.00,'2021-12-08 12:21:28','',''),(2205479,'1','200','1025',468,'Retail Sale Id 1299434',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 12:22:35','',''),(2205480,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:22:35','',''),(2205672,'1','200','1025',468,'Retail Sale Id 1299529',74400.00,0.00,0.00,0.00,4080.00,'2021-12-08 12:37:05','',''),(2205673,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-08 12:37:05','',''),(2205776,'1','200','1025',468,'Retail Sale Id 1299578',2000.80,0.00,0.00,0.00,213.50,'2021-12-08 12:43:51','',''),(2205777,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 12:43:51','',''),(2206015,'1','200','1025',468,'Retail Sale Id 1299674',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 12:57:32','',''),(2206016,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:57:32','',''),(2206068,'1','200','1025',468,'Retail Sale Id 1299696',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 13:02:36','',''),(2206069,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:02:36','',''),(2206070,'1','200','1025',468,'Retail Sale Id 1299696',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 13:02:36','',''),(2206071,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:02:36','',''),(2206106,'1','200','1025',468,'Retail Sale Id 1299711',2624.00,0.00,0.00,0.00,280.00,'2021-12-08 13:04:50','',''),(2206107,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 13:04:50','',''),(2206134,'1','200','1025',468,'Retail Sale Id 1299726',2624.00,0.00,0.00,0.00,280.00,'2021-12-08 13:06:36','',''),(2206135,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 13:06:36','',''),(2206267,'1','200','1025',468,'Retail Sale Id 1299788',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 13:15:00','',''),(2206268,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:15:00','',''),(2206297,'1','200','1025',468,'Retail Sale Id 1299800',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 13:17:09','',''),(2206298,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:17:09','',''),(2206469,'1','200','1025',468,'Retail Sale Id 1299890',2624.00,0.00,0.00,0.00,280.00,'2021-12-08 13:29:41','',''),(2206470,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 13:29:41','',''),(2206471,'1','200','1025',468,'Retail Sale Id 1299890',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 13:29:41','',''),(2206472,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:29:41','',''),(2206670,'1','200','1025',468,'Retail Sale Id 1299967',7872.00,0.00,0.00,0.00,840.00,'2021-12-08 13:40:46','',''),(2206671,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 13:40:46','',''),(2207150,'1','200','1025',468,'Retail Sale Id 1300157',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 14:08:34','',''),(2207151,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:08:34','',''),(2207175,'1','200','1025',468,'Retail Sale Id 1300169',31000.00,0.00,0.00,0.00,1700.00,'2021-12-08 14:09:40','',''),(2207176,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 14:09:40','',''),(2207205,'1','200','1025',468,'Retail Sale Id 1300179',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 14:11:31','',''),(2207206,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:11:31','',''),(2207594,'1','200','1025',468,'Retail Sale Id 1300360',3949.12,0.00,0.00,0.00,421.40,'2021-12-08 14:31:37','',''),(2207595,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-08 14:31:37','',''),(2207623,'1','200','1025',468,'Retail Sale Id 1300377',656.00,0.00,0.00,0.00,70.00,'2021-12-08 14:32:58','',''),(2207624,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 14:32:58','',''),(2207692,'1','200','1025',468,'Retail Sale Id 1300409',1502.24,0.00,0.00,0.00,160.30,'2021-12-08 14:36:28','',''),(2207693,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-08 14:36:28','',''),(2208019,'1','200','1025',468,'Retail Sale Id 1300580',1312.00,0.00,0.00,0.00,140.00,'2021-12-08 14:56:02','',''),(2208020,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 14:56:02','',''),(2208197,'1','200','1025',468,'Retail Sale Id 1300656',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 15:08:22','',''),(2208198,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:08:22','',''),(2208331,'1','200','1025',468,'Retail Sale Id 1300722',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 15:16:28','',''),(2208332,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:16:28','',''),(2208532,'1','200','1025',468,'Retail Sale Id 1300817',2000.80,0.00,0.00,0.00,213.50,'2021-12-08 15:26:23','',''),(2208533,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 15:26:23','',''),(2208673,'1','200','1025',468,'Retail Sale Id 1300881',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 15:33:06','',''),(2208674,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:33:06','',''),(2208729,'1','200','1025',468,'Retail Sale Id 1300921',12400.00,0.00,0.00,0.00,680.00,'2021-12-08 15:36:12','',''),(2208730,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-08 15:36:12','',''),(2208757,'1','200','1025',468,'Retail Sale Id 1300934',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 15:37:29','',''),(2208758,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:37:29','',''),(2208839,'1','200','1025',468,'Retail Sale Id 1300969',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 15:41:55','',''),(2208840,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:41:55','',''),(2208883,'1','200','1025',468,'Retail Sale Id 1300997',3942.56,0.00,0.00,0.00,420.70,'2021-12-08 15:43:43','',''),(2208884,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 15:43:43','',''),(2208945,'1','200','1025',468,'Retail Sale Id 1301030',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 15:47:07','',''),(2208946,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:47:07','',''),(2208973,'1','200','1025',468,'Retail Sale Id 1301047',1312.00,0.00,0.00,0.00,140.00,'2021-12-08 15:48:55','',''),(2208974,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 15:48:55','',''),(2208995,'1','200','1025',468,'Retail Sale Id 1301058',656.00,0.00,0.00,0.00,70.00,'2021-12-08 15:50:15','',''),(2208996,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 15:50:15','',''),(2209008,'1','200','1025',468,'Retail Sale Id 1301064',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 15:51:35','',''),(2209009,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:51:35','',''),(2209061,'1','200','1025',468,'Retail Sale Id 1301082',4100.00,0.00,0.00,0.00,437.50,'2021-12-08 15:53:44','',''),(2209062,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 15:53:44','',''),(2209083,'1','200','1025',468,'Retail Sale Id 1301092',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 15:55:06','',''),(2209084,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:55:06','',''),(2209131,'1','200','1025',468,'Retail Sale Id 1301119',34100.00,0.00,0.00,0.00,1870.00,'2021-12-08 15:58:02','',''),(2209132,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-08 15:58:02','',''),(2209157,'1','200','1025',468,'Retail Sale Id 1301132',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 15:59:35','',''),(2209158,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:59:35','',''),(2209197,'1','200','1025',468,'Retail Sale Id 1301155',997.12,0.00,0.00,0.00,106.40,'2021-12-08 16:01:06','',''),(2209198,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 16:01:06','',''),(2209227,'1','200','1025',468,'Retail Sale Id 1301170',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 16:02:37','',''),(2209228,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:02:37','',''),(2209271,'1','200','1025',468,'Retail Sale Id 1301193',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 16:04:43','',''),(2209272,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:04:43','',''),(2209440,'1','200','1025',468,'Retail Sale Id 1301267',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 16:11:43','',''),(2209441,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:11:43','',''),(2209478,'1','200','1025',468,'Retail Sale Id 1301287',3100.00,0.00,0.00,0.00,170.00,'2021-12-08 16:13:02','',''),(2209479,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:13:02','',''),(2209628,'1','200','1025',468,'Retail Sale Id 1301346',5904.00,0.00,0.00,0.00,630.00,'2021-12-08 16:18:35','',''),(2209629,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 16:18:35','',''),(2209664,'1','200','1025',468,'Retail Sale Id 1301367',3280.00,0.00,0.00,0.00,350.00,'2021-12-08 16:20:22','',''),(2209665,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:20:22','',''),(2209684,'1','200','1025',468,'Retail Sale Id 1301377',2000.80,0.00,0.00,0.00,213.50,'2021-12-08 16:21:36','',''),(2209685,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 16:21:36','',''),(2209780,'1','200','1025',468,'Retail Sale Id 1301468',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 16:28:25','',''),(2209781,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:28:25','',''),(2210047,'1','200','1025',468,'Retail Sale Id 1301673',2624.00,0.00,0.00,0.00,280.00,'2021-12-08 16:39:55','',''),(2210048,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 16:39:55','',''),(2210223,'1','200','1025',468,'Retail Sale Id 1301765',7216.00,0.00,0.00,0.00,770.00,'2021-12-08 16:48:58','',''),(2210224,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 16:48:58','',''),(2210255,'1','200','1025',468,'Retail Sale Id 1301780',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 16:50:21','',''),(2210256,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:50:21','',''),(2210279,'1','200','1025',468,'Retail Sale Id 1301792',8200.00,0.00,0.00,0.00,875.00,'2021-12-08 16:51:50','',''),(2210280,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:51:50','',''),(2210378,'1','200','1025',468,'Retail Sale Id 1301846',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 16:58:00','',''),(2210379,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:58:00','',''),(2210432,'1','200','1025',468,'Retail Sale Id 1301876',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 17:01:51','',''),(2210433,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 17:01:51','',''),(2210452,'1','200','1025',468,'Retail Sale Id 1301886',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 17:03:32','',''),(2210453,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:03:32','',''),(2210519,'1','200','1025',468,'Retail Sale Id 1301924',2361.60,0.00,0.00,0.00,252.00,'2021-12-08 17:09:42','',''),(2210520,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.60,0.00,'2021-12-08 17:09:42','',''),(2210549,'1','200','1025',468,'Retail Sale Id 1301943',3936.00,0.00,0.00,0.00,420.00,'2021-12-08 17:12:43','',''),(2210550,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:12:43','',''),(2210629,'1','200','1025',468,'Retail Sale Id 1301990',1968.00,0.00,0.00,0.00,210.00,'2021-12-08 17:19:29','',''),(2210630,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 17:19:29','',''),(2212333,'1','200','1025',468,'Retail Sale Id 1302521',1318.56,0.00,0.00,0.00,140.70,'2021-12-09 06:32:58','',''),(2212334,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.01,0.00,'2021-12-09 06:32:58','',''),(2212426,'1','200','1025',468,'Retail Sale Id 1302554',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 06:37:47','',''),(2212427,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:37:47','',''),(2212607,'1','200','1025',468,'Retail Sale Id 1302639',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 06:47:23','',''),(2212608,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:47:23','',''),(2212676,'1','200','1025',468,'Retail Sale Id 1302675',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 06:51:23','',''),(2212677,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 06:51:23','',''),(2212890,'1','200','1025',468,'Retail Sale Id 1302768',37200.00,0.00,0.00,0.00,2040.00,'2021-12-09 07:03:24','',''),(2212891,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 07:03:24','',''),(2212910,'1','200','1025',468,'Retail Sale Id 1302778',2624.00,0.00,0.00,0.00,280.00,'2021-12-09 07:04:52','',''),(2212911,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 07:04:52','',''),(2213210,'1','200','1025',468,'Retail Sale Id 1302915',6560.00,0.00,0.00,0.00,700.00,'2021-12-09 07:18:47','',''),(2213211,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 07:18:47','',''),(2213502,'1','200','1025',468,'Retail Sale Id 1303056',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 07:31:40','',''),(2213503,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 07:31:40','',''),(2213816,'1','200','1025',468,'Retail Sale Id 1303207',3280.00,0.00,0.00,0.00,350.00,'2021-12-09 07:47:04','',''),(2213817,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:47:04','',''),(2213956,'1','200','1025',468,'Retail Sale Id 1303271',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 07:53:56','',''),(2213957,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:53:56','',''),(2214062,'1','200','1025',468,'Retail Sale Id 1303332',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 08:01:18','',''),(2214063,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 08:01:18','',''),(2214230,'1','200','1025',468,'Retail Sale Id 1303417',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 08:10:06','',''),(2214231,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:10:06','',''),(2214348,'1','200','1025',468,'Retail Sale Id 1303480',2997.92,0.00,0.00,0.00,319.90,'2021-12-09 08:16:11','',''),(2214349,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-09 08:16:11','',''),(2214551,'1','200','1025',468,'Retail Sale Id 1303557',1397.28,0.00,0.00,0.00,149.10,'2021-12-09 08:25:17','',''),(2214552,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.13,0.00,'2021-12-09 08:25:17','',''),(2214608,'1','200','1025',468,'Retail Sale Id 1303579',1312.00,0.00,0.00,0.00,140.00,'2021-12-09 08:27:48','',''),(2214609,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 08:27:48','',''),(2214833,'1','200','1025',468,'Retail Sale Id 1303688',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 08:38:32','',''),(2214834,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:38:32','',''),(2214835,'1','200','1025',468,'Retail Sale Id 1303688',2624.00,0.00,0.00,0.00,280.00,'2021-12-09 08:38:32','',''),(2214836,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 08:38:32','',''),(2214889,'1','200','1025',468,'Retail Sale Id 1303714',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 08:40:34','',''),(2214890,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 08:40:34','',''),(2215068,'1','200','1025',468,'Retail Sale Id 1303794',656.00,0.00,0.00,0.00,70.00,'2021-12-09 08:49:49','',''),(2215069,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 08:49:49','',''),(2215146,'1','200','1025',468,'Retail Sale Id 1303833',7440.00,0.00,0.00,0.00,408.00,'2021-12-09 08:54:58','',''),(2215147,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 08:54:58','',''),(2215176,'1','200','1025',468,'Retail Sale Id 1303853',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 08:57:07','',''),(2215177,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:57:07','',''),(2215208,'1','200','1025',468,'Retail Sale Id 1303867',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 08:59:19','',''),(2215209,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:59:19','',''),(2216167,'1','200','1025',468,'Retail Sale Id 1304302',1312.00,0.00,0.00,0.00,140.00,'2021-12-09 09:49:40','',''),(2216168,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 09:49:40','',''),(2216364,'1','200','1025',468,'Retail Sale Id 1304396',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 09:58:31','',''),(2216365,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:58:31','',''),(2216451,'1','200','1025',468,'Retail Sale Id 1304431',6560.00,0.00,0.00,0.00,700.00,'2021-12-09 10:03:06','',''),(2216452,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 10:03:06','',''),(2216667,'1','200','1025',468,'Retail Sale Id 1304548',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 10:17:29','',''),(2216668,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:17:29','',''),(2216697,'1','200','1025',468,'Retail Sale Id 1304564',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 10:19:32','',''),(2216698,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:19:32','',''),(2216757,'1','200','1025',468,'Retail Sale Id 1304599',7498.08,0.00,0.00,0.00,800.10,'2021-12-09 10:23:11','',''),(2216758,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,11.43,0.00,'2021-12-09 10:23:11','',''),(2216789,'1','200','1025',468,'Retail Sale Id 1304613',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 10:25:18','',''),(2216790,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:25:18','',''),(2216853,'1','200','1025',468,'Retail Sale Id 1304647',1502.24,0.00,0.00,0.00,160.30,'2021-12-09 10:28:53','',''),(2216854,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 10:28:53','',''),(2216889,'1','200','1025',468,'Retail Sale Id 1304666',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 10:31:10','',''),(2216890,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:31:10','',''),(2216955,'1','200','1025',468,'Retail Sale Id 1304700',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 10:35:53','',''),(2216956,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:35:53','',''),(2217074,'1','200','1025',468,'Retail Sale Id 1304766',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 10:44:04','',''),(2217075,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:44:04','',''),(2217166,'1','200','1025',468,'Retail Sale Id 1304813',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 10:49:41','',''),(2217167,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:49:41','',''),(2217301,'1','200','1025',468,'Retail Sale Id 1304879',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 10:59:22','',''),(2217302,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:59:22','',''),(2217392,'1','200','1025',468,'Retail Sale Id 1304923',997.12,0.00,0.00,0.00,106.40,'2021-12-09 11:05:14','',''),(2217393,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 11:05:14','',''),(2217493,'1','200','1025',468,'Retail Sale Id 1304965',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 11:12:46','',''),(2217494,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:12:46','',''),(2217630,'1','200','1025',468,'Retail Sale Id 1305032',31000.00,0.00,0.00,0.00,1700.00,'2021-12-09 11:21:26','',''),(2217631,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 11:21:26','',''),(2217654,'1','200','1025',468,'Retail Sale Id 1305048',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 11:22:37','',''),(2217655,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:22:37','',''),(2217753,'1','200','1025',468,'Retail Sale Id 1305095',1312.00,0.00,0.00,0.00,140.00,'2021-12-09 11:28:41','',''),(2217754,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 11:28:41','',''),(2217755,'1','200','1025',468,'Retail Sale Id 1305095',1312.00,0.00,0.00,0.00,140.00,'2021-12-09 11:28:41','',''),(2217756,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 11:28:41','',''),(2217807,'1','200','1025',468,'Retail Sale Id 1305122',3280.00,0.00,0.00,0.00,350.00,'2021-12-09 11:30:43','',''),(2217808,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 11:30:43','',''),(2217835,'1','200','1025',468,'Retail Sale Id 1305135',3280.00,0.00,0.00,0.00,350.00,'2021-12-09 11:32:44','',''),(2217836,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 11:32:44','',''),(2217858,'1','200','1025',468,'Retail Sale Id 1305146',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 11:34:08','',''),(2217859,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:34:08','',''),(2217870,'1','200','1025',468,'Retail Sale Id 1305154',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 11:35:13','',''),(2217871,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:35:13','',''),(2217895,'1','200','1025',468,'Retail Sale Id 1305164',39680.00,0.00,0.00,0.00,2176.00,'2021-12-09 11:36:42','',''),(2217896,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,64.00,0.00,'2021-12-09 11:36:42','',''),(2218022,'1','200','1025',468,'Retail Sale Id 1305222',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 11:45:35','',''),(2218023,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:45:35','',''),(2218146,'1','200','1025',468,'Retail Sale Id 1305288',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 11:52:06','',''),(2218147,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:52:06','',''),(2218172,'1','200','1025',468,'Retail Sale Id 1305302',3280.00,0.00,0.00,0.00,350.00,'2021-12-09 11:53:50','',''),(2218173,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 11:53:50','',''),(2218240,'1','200','1025',468,'Retail Sale Id 1305333',12400.00,0.00,0.00,0.00,680.00,'2021-12-09 11:58:37','',''),(2218241,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 11:58:37','',''),(2218280,'1','200','1025',468,'Retail Sale Id 1305359',57040.00,0.00,0.00,0.00,3128.00,'2021-12-09 12:01:12','',''),(2218281,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,92.00,0.00,'2021-12-09 12:01:12','',''),(2218690,'1','200','1025',468,'Retail Sale Id 1305575',93000.00,0.00,0.00,0.00,5100.00,'2021-12-09 12:28:08','',''),(2218691,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 12:28:08','',''),(2218704,'1','200','1025',468,'Retail Sale Id 1305584',6560.00,0.00,0.00,0.00,700.00,'2021-12-09 12:29:04','',''),(2218705,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 12:29:04','',''),(2218876,'1','200','1025',468,'Retail Sale Id 1305669',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 12:39:50','',''),(2218877,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 12:39:50','',''),(2218878,'1','200','1025',468,'Retail Sale Id 1305669',7216.00,0.00,0.00,0.00,770.00,'2021-12-09 12:39:50','',''),(2218879,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 12:39:50','',''),(2218946,'1','200','1025',468,'Retail Sale Id 1305706',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 12:43:30','',''),(2218947,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 12:43:30','',''),(2219017,'1','200','1025',468,'Retail Sale Id 1305744',997.12,0.00,0.00,0.00,106.40,'2021-12-09 12:46:53','',''),(2219018,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 12:46:53','',''),(2219119,'1','200','1025',468,'Retail Sale Id 1305787',800.32,0.00,0.00,0.00,85.40,'2021-12-09 12:52:11','',''),(2219120,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.22,0.00,'2021-12-09 12:52:11','',''),(2219147,'1','200','1025',468,'Retail Sale Id 1305809',7872.00,0.00,0.00,0.00,840.00,'2021-12-09 12:54:03','',''),(2219148,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-09 12:54:03','',''),(2219239,'1','200','1025',468,'Retail Sale Id 1305845',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 12:58:42','',''),(2219240,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:58:42','',''),(2219337,'1','200','1025',468,'Retail Sale Id 1305899',6999.52,0.00,0.00,0.00,746.90,'2021-12-09 13:05:43','',''),(2219338,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-09 13:05:43','',''),(2219361,'1','200','1025',468,'Retail Sale Id 1305922',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 13:08:25','',''),(2219362,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:08:25','',''),(2219490,'1','200','1025',468,'Retail Sale Id 1305969',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 13:15:44','',''),(2219491,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:15:44','',''),(2219952,'1','200','1025',468,'Retail Sale Id 1306132',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 13:40:38','',''),(2219953,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:40:38','',''),(2220118,'1','200','1025',468,'Retail Sale Id 1306215',3280.00,0.00,0.00,0.00,350.00,'2021-12-09 13:51:11','',''),(2220119,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:51:11','',''),(2220228,'1','200','1025',468,'Retail Sale Id 1306273',38440.00,0.00,0.00,0.00,2108.00,'2021-12-09 13:59:16','',''),(2220229,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-09 13:59:16','',''),(2220328,'1','200','1025',468,'Retail Sale Id 1306311',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 14:06:26','',''),(2220329,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:06:26','',''),(2220423,'1','200','1025',468,'Retail Sale Id 1306347',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 14:11:16','',''),(2220424,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:11:16','',''),(2220425,'1','200','1025',468,'Retail Sale Id 1306347',26240.00,0.00,0.00,0.00,2800.00,'2021-12-09 14:11:16','',''),(2220426,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 14:11:16','',''),(2220472,'1','200','1025',468,'Retail Sale Id 1306412',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 14:14:25','',''),(2220473,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:14:25','',''),(2220504,'1','200','1025',468,'Retail Sale Id 1306426',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 14:16:04','',''),(2220505,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:16:04','',''),(2220516,'1','200','1025',468,'Retail Sale Id 1306434',2499.36,0.00,0.00,0.00,266.70,'2021-12-09 14:17:16','',''),(2220517,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-09 14:17:16','',''),(2220544,'1','200','1025',468,'Retail Sale Id 1306447',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 14:18:37','',''),(2220545,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:18:37','',''),(2220596,'1','200','1025',468,'Retail Sale Id 1306474',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 14:22:10','',''),(2220597,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:22:10','',''),(2220690,'1','200','1025',468,'Retail Sale Id 1306526',34100.00,0.00,0.00,0.00,1870.00,'2021-12-09 14:26:34','',''),(2220691,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-09 14:26:34','',''),(2220872,'1','200','1025',468,'Retail Sale Id 1306600',5576.00,0.00,0.00,0.00,595.00,'2021-12-09 14:35:08','',''),(2220873,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.50,0.00,'2021-12-09 14:35:08','',''),(2221076,'1','200','1025',468,'Retail Sale Id 1306656',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 14:42:48','',''),(2221077,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:42:48','',''),(2221464,'1','200','1025',468,'Retail Sale Id 1306837',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 14:58:11','',''),(2221465,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:58:11','',''),(2221538,'1','200','1025',468,'Retail Sale Id 1306877',1312.00,0.00,0.00,0.00,140.00,'2021-12-09 15:03:12','',''),(2221539,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:03:12','',''),(2221646,'1','200','1025',468,'Retail Sale Id 1306935',3280.00,0.00,0.00,0.00,350.00,'2021-12-09 15:08:21','',''),(2221647,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:08:21','',''),(2221721,'1','200','1025',468,'Retail Sale Id 1306978',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 15:11:31','',''),(2221722,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:11:31','',''),(2221723,'1','200','1025',468,'Retail Sale Id 1306978',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 15:11:31','',''),(2221724,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:11:31','',''),(2221725,'1','200','1025',468,'Retail Sale Id 1306978',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 15:11:31','',''),(2221726,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:11:31','',''),(2221835,'1','200','1025',468,'Retail Sale Id 1307038',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 15:17:38','',''),(2221836,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:17:38','',''),(2221915,'1','200','1025',468,'Retail Sale Id 1307076',2624.00,0.00,0.00,0.00,280.00,'2021-12-09 15:21:21','',''),(2221916,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 15:21:21','',''),(2221947,'1','200','1025',468,'Retail Sale Id 1307091',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 15:22:59','',''),(2221948,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:22:59','',''),(2222110,'1','200','1025',468,'Retail Sale Id 1307175',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 15:30:54','',''),(2222111,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:30:54','',''),(2222140,'1','200','1025',468,'Retail Sale Id 1307187',3299.68,0.00,0.00,0.00,352.10,'2021-12-09 15:32:19','',''),(2222141,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-09 15:32:19','',''),(2222184,'1','200','1025',468,'Retail Sale Id 1307213',2997.92,0.00,0.00,0.00,319.90,'2021-12-09 15:35:08','',''),(2222185,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-09 15:35:08','',''),(2222236,'1','200','1025',468,'Retail Sale Id 1307237',12400.00,0.00,0.00,0.00,680.00,'2021-12-09 15:37:27','',''),(2222237,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 15:37:27','',''),(2222266,'1','200','1025',468,'Retail Sale Id 1307252',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 15:39:11','',''),(2222267,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:39:11','',''),(2222437,'1','200','1025',468,'Retail Sale Id 1307334',3280.00,0.00,0.00,0.00,350.00,'2021-12-09 15:49:14','',''),(2222438,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:49:14','',''),(2222465,'1','200','1025',468,'Retail Sale Id 1307348',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 15:50:46','',''),(2222466,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:50:46','',''),(2222515,'1','200','1025',468,'Retail Sale Id 1307373',3280.00,0.00,0.00,0.00,350.00,'2021-12-09 15:53:27','',''),(2222516,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:53:27','',''),(2222559,'1','200','1025',468,'Retail Sale Id 1307390',88660.00,0.00,0.00,0.00,4862.00,'2021-12-09 15:55:12','',''),(2222560,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,143.00,0.00,'2021-12-09 15:55:12','',''),(2222616,'1','200','1025',468,'Retail Sale Id 1307423',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 15:58:15','',''),(2222617,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:58:15','',''),(2222660,'1','200','1025',468,'Retail Sale Id 1307445',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 16:00:58','',''),(2222661,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:00:58','',''),(2222813,'1','200','1025',468,'Retail Sale Id 1307521',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 16:08:53','',''),(2222814,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:08:53','',''),(2222901,'1','200','1025',468,'Retail Sale Id 1307567',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 16:13:23','',''),(2222902,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:13:23','',''),(2222955,'1','200','1025',468,'Retail Sale Id 1307593',2997.92,0.00,0.00,0.00,319.90,'2021-12-09 16:16:08','',''),(2222956,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-09 16:16:08','',''),(2222985,'1','200','1025',468,'Retail Sale Id 1307611',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 16:17:39','',''),(2222986,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:17:39','',''),(2223284,'1','200','1025',468,'Retail Sale Id 1307746',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 16:33:58','',''),(2223285,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:33:58','',''),(2223441,'1','200','1025',468,'Retail Sale Id 1307807',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 16:41:37','',''),(2223442,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:41:37','',''),(2223485,'1','200','1025',468,'Retail Sale Id 1307823',3280.00,0.00,0.00,0.00,350.00,'2021-12-09 16:43:34','',''),(2223486,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:43:34','',''),(2223524,'1','200','1025',468,'Retail Sale Id 1307837',1968.00,0.00,0.00,0.00,210.00,'2021-12-09 16:45:40','',''),(2223525,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:45:40','',''),(2223673,'1','200','1025',468,'Retail Sale Id 1307891',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 16:55:04','',''),(2223674,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:55:04','',''),(2223675,'1','200','1025',468,'Retail Sale Id 1307891',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 16:55:04','',''),(2223676,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:55:04','',''),(2223677,'1','200','1025',468,'Retail Sale Id 1307891',8200.00,0.00,0.00,0.00,875.00,'2021-12-09 16:55:04','',''),(2223678,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:55:04','',''),(2223707,'1','200','1025',468,'Retail Sale Id 1307922',1312.00,0.00,0.00,0.00,140.00,'2021-12-09 16:56:42','',''),(2223708,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:56:42','',''),(2223782,'1','200','1025',468,'Retail Sale Id 1307959',2000.80,0.00,0.00,0.00,213.50,'2021-12-09 17:01:39','',''),(2223783,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 17:01:39','',''),(2223830,'1','200','1025',468,'Retail Sale Id 1307980',596.96,0.00,0.00,0.00,63.70,'2021-12-09 17:04:02','',''),(2223831,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,0.91,0.00,'2021-12-09 17:04:02','',''),(2223950,'1','200','1025',468,'Retail Sale Id 1308039',3936.00,0.00,0.00,0.00,420.00,'2021-12-09 17:13:20','',''),(2223951,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 17:13:20','',''),(2224401,'1','200','1025',468,'Return of Retail Sale Id 1307237',0.00,12400.00,20.00,0.00,-680.00,'2021-12-09 18:18:36','',''),(2224409,'1','200','1025',468,'Retail Sale Id 1308261',5890.00,0.00,0.00,0.00,323.00,'2021-12-09 18:22:33','',''),(2224410,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-09 18:22:33','',''),(2224440,'1','200','1025',468,'Return of Retail Sale Id 1308039',0.00,3936.00,6.00,0.00,-420.00,'2021-12-09 18:30:23','',''),(2224443,'1','200','1025',468,'Return of Retail Sale Id 1307980',0.00,596.96,0.91,0.00,-63.70,'2021-12-09 18:31:33','',''),(2224445,'1','200','1025',468,'Retail Sale Id 1308275',321.44,0.00,0.00,0.00,34.30,'2021-12-09 18:32:33','',''),(2224446,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,0.49,0.00,'2021-12-09 18:32:33','',''),(2225164,'1','200','1025',468,'Retail Sale Id 1308391',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 06:12:59','',''),(2225165,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 06:12:59','',''),(2225840,'1','200','1025',468,'Retail Sale Id 1308714',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 07:05:18','',''),(2225841,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 07:05:18','',''),(2225862,'1','200','1025',468,'Retail Sale Id 1308726',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 07:06:57','',''),(2225863,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 07:06:57','',''),(2226000,'1','200','1025',468,'Retail Sale Id 1308801',2000.80,0.00,0.00,0.00,213.50,'2021-12-10 07:15:35','',''),(2226001,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-10 07:15:35','',''),(2226052,'1','200','1025',468,'Retail Sale Id 1308827',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 07:18:11','',''),(2226053,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 07:18:11','',''),(2226232,'1','200','1025',468,'Retail Sale Id 1308919',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 07:27:11','',''),(2226233,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:27:11','',''),(2226439,'1','200','1025',468,'Retail Sale Id 1309011',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 07:38:30','',''),(2226440,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:38:30','',''),(2226491,'1','200','1025',468,'Retail Sale Id 1309024',62000.00,0.00,0.00,0.00,3400.00,'2021-12-10 07:41:36','',''),(2226492,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 07:41:36','',''),(2226527,'1','200','1025',468,'Retail Sale Id 1309054',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 07:43:26','',''),(2226528,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:43:26','',''),(2226700,'1','200','1025',468,'Retail Sale Id 1309126',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 07:52:01','',''),(2226701,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:52:01','',''),(2226962,'1','200','1025',468,'Retail Sale Id 1309228',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 08:04:14','',''),(2226963,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:04:14','',''),(2227144,'1','200','1025',468,'Retail Sale Id 1309302',997.12,0.00,0.00,0.00,106.40,'2021-12-10 08:13:08','',''),(2227145,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-10 08:13:08','',''),(2227164,'1','200','1025',468,'Retail Sale Id 1309309',4001.60,0.00,0.00,0.00,427.00,'2021-12-10 08:14:03','',''),(2227165,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-10 08:14:03','',''),(2227507,'1','200','1025',468,'Retail Sale Id 1309459',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 08:29:49','',''),(2227508,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:29:49','',''),(2227663,'1','200','1025',468,'Retail Sale Id 1309545',162750.00,0.00,0.00,0.00,8925.00,'2021-12-10 08:38:02','',''),(2227664,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,262.50,0.00,'2021-12-10 08:38:02','',''),(2227870,'1','200','1025',468,'Retail Sale Id 1309631',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 08:47:08','',''),(2227871,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:47:08','',''),(2228069,'1','200','1025',468,'Retail Sale Id 1309726',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 08:56:11','',''),(2228070,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:56:11','',''),(2228084,'1','200','1025',468,'Retail Sale Id 1309735',2000.80,0.00,0.00,0.00,213.50,'2021-12-10 08:57:10','',''),(2228085,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-10 08:57:10','',''),(2228120,'1','200','1025',468,'Retail Sale Id 1309754',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 08:58:32','',''),(2228121,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:58:32','',''),(2228170,'1','200','1025',468,'Retail Sale Id 1309780',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 09:00:20','',''),(2228171,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 09:00:20','',''),(2228196,'1','200','1025',468,'Retail Sale Id 1309790',6560.00,0.00,0.00,0.00,700.00,'2021-12-10 09:01:13','',''),(2228197,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 09:01:13','',''),(2228362,'1','200','1025',468,'Retail Sale Id 1309871',8200.00,0.00,0.00,0.00,875.00,'2021-12-10 09:10:16','',''),(2228363,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:10:16','',''),(2228439,'1','200','1025',468,'Retail Sale Id 1309906',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 09:14:32','',''),(2228440,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 09:14:32','',''),(2228574,'1','200','1025',468,'Retail Sale Id 1309967',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 09:22:45','',''),(2228575,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:22:45','',''),(2228779,'1','200','1025',468,'Retail Sale Id 1310057',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 09:34:20','',''),(2228780,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:34:20','',''),(2228835,'1','200','1025',468,'Retail Sale Id 1310092',8200.00,0.00,0.00,0.00,875.00,'2021-12-10 09:38:11','',''),(2228836,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:38:11','',''),(2228973,'1','200','1025',468,'Retail Sale Id 1310163',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 09:45:27','',''),(2228974,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 09:45:27','',''),(2229212,'1','200','1025',468,'Retail Sale Id 1310279',9300.00,0.00,0.00,0.00,510.00,'2021-12-10 10:00:28','',''),(2229213,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-10 10:00:28','',''),(2229315,'1','200','1025',468,'Retail Sale Id 1310319',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 10:06:46','',''),(2229316,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:06:46','',''),(2229443,'1','200','1025',468,'Retail Sale Id 1310384',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 10:13:12','',''),(2229444,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:13:12','',''),(2229647,'1','200','1025',468,'Retail Sale Id 1310477',62000.00,0.00,0.00,0.00,3400.00,'2021-12-10 10:23:34','',''),(2229648,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 10:23:34','',''),(2229777,'1','200','1025',468,'Retail Sale Id 1310538',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 10:31:08','',''),(2229778,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 10:31:08','',''),(2229793,'1','200','1025',468,'Retail Sale Id 1310545',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 10:32:34','',''),(2229794,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:32:34','',''),(2229834,'1','200','1025',468,'Retail Sale Id 1310560',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 10:34:27','',''),(2229835,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:34:27','',''),(2229957,'1','200','1025',468,'Retail Sale Id 1310619',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 10:42:23','',''),(2229958,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:42:23','',''),(2229981,'1','200','1025',468,'Retail Sale Id 1310630',997.12,0.00,0.00,0.00,106.40,'2021-12-10 10:44:17','',''),(2229982,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-10 10:44:17','',''),(2229983,'1','200','1025',468,'Retail Sale Id 1310630',1502.24,0.00,0.00,0.00,160.30,'2021-12-10 10:44:17','',''),(2229984,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-10 10:44:17','',''),(2230019,'1','200','1025',468,'Retail Sale Id 1310645',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 10:45:43','',''),(2230020,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:45:43','',''),(2230059,'1','200','1025',468,'Retail Sale Id 1310663',6560.00,0.00,0.00,0.00,700.00,'2021-12-10 10:47:56','',''),(2230060,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 10:47:56','',''),(2230137,'1','200','1025',468,'Retail Sale Id 1310692',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 10:51:22','',''),(2230138,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 10:51:22','',''),(2230412,'1','200','1025',468,'Retail Sale Id 1310822',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 11:06:58','',''),(2230413,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:06:58','',''),(2230701,'1','200','1025',468,'Retail Sale Id 1310929',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 11:22:50','',''),(2230702,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 11:22:50','',''),(2230967,'1','200','1025',468,'Retail Sale Id 1311067',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 11:42:09','',''),(2230968,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:42:09','',''),(2230985,'1','200','1025',468,'Retail Sale Id 1311080',6560.00,0.00,0.00,0.00,700.00,'2021-12-10 11:43:59','',''),(2230986,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 11:43:59','',''),(2231197,'1','200','1025',468,'Retail Sale Id 1311181',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 11:59:03','',''),(2231198,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:59:03','',''),(2231457,'1','200','1025',468,'Retail Sale Id 1311276',1312.00,0.00,0.00,0.00,140.00,'2021-12-10 12:19:16','',''),(2231458,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 12:19:16','',''),(2231519,'1','200','1025',468,'Retail Sale Id 1311349',6100.80,0.00,0.00,0.00,651.00,'2021-12-10 12:24:28','',''),(2231520,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.30,0.00,'2021-12-10 12:24:28','',''),(2231546,'1','200','1025',468,'Retail Sale Id 1311365',6560.00,0.00,0.00,0.00,700.00,'2021-12-10 12:26:14','',''),(2231547,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 12:26:14','',''),(2231626,'1','200','1025',468,'Retail Sale Id 1311410',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 12:36:07','',''),(2231627,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 12:36:07','',''),(2231880,'1','200','1025',468,'Retail Sale Id 1311543',2624.00,0.00,0.00,0.00,280.00,'2021-12-10 12:55:30','',''),(2231881,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 12:55:30','',''),(2232077,'1','200','1025',468,'Retail Sale Id 1311645',274040.00,0.00,0.00,0.00,15028.00,'2021-12-10 13:09:13','',''),(2232078,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,442.00,0.00,'2021-12-10 13:09:13','',''),(2232248,'1','200','1025',468,'Retail Sale Id 1311707',186000.00,0.00,0.00,0.00,10200.00,'2021-12-10 13:18:17','',''),(2232249,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-10 13:18:17','',''),(2232989,'1','200','1025',468,'Retail Sale Id 1312050',7872.00,0.00,0.00,0.00,840.00,'2021-12-10 13:57:20','',''),(2232990,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-10 13:57:20','',''),(2233150,'1','200','1025',468,'Retail Sale Id 1312102',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 14:03:00','',''),(2233151,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 14:03:00','',''),(2233253,'1','200','1025',468,'Retail Sale Id 1312141',997.12,0.00,0.00,0.00,106.40,'2021-12-10 14:08:17','',''),(2233254,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-10 14:08:17','',''),(2233323,'1','200','1025',468,'Retail Sale Id 1312181',5248.00,0.00,0.00,0.00,560.00,'2021-12-10 14:13:38','',''),(2233324,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 14:13:38','',''),(2233325,'1','200','1025',468,'Retail Sale Id 1312181',5248.00,0.00,0.00,0.00,560.00,'2021-12-10 14:13:38','',''),(2233326,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 14:13:38','',''),(2233409,'1','200','1025',468,'Retail Sale Id 1312218',2499.36,0.00,0.00,0.00,266.70,'2021-12-10 14:17:29','',''),(2233410,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-10 14:17:29','',''),(2233459,'1','200','1025',468,'Retail Sale Id 1312245',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 14:20:27','',''),(2233460,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:20:27','',''),(2233543,'1','200','1025',468,'Retail Sale Id 1312278',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 14:24:08','',''),(2233544,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 14:24:08','',''),(2233880,'1','200','1025',468,'Retail Sale Id 1312418',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 14:37:29','',''),(2233881,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:37:29','',''),(2233931,'1','200','1025',468,'Retail Sale Id 1312440',37200.00,0.00,0.00,0.00,2040.00,'2021-12-10 14:39:59','',''),(2233932,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-10 14:39:59','',''),(2234149,'1','200','1025',468,'Retail Sale Id 1312535',8200.00,0.00,0.00,0.00,875.00,'2021-12-10 14:48:05','',''),(2234150,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:48:05','',''),(2234187,'1','200','1025',468,'Retail Sale Id 1312554',6560.00,0.00,0.00,0.00,700.00,'2021-12-10 14:49:22','',''),(2234188,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 14:49:22','',''),(2234229,'1','200','1025',468,'Retail Sale Id 1312573',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 14:51:21','',''),(2234230,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:51:21','',''),(2234400,'1','200','1025',468,'Retail Sale Id 1312658',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 15:01:00','',''),(2234401,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:01:00','',''),(2234416,'1','200','1025',468,'Retail Sale Id 1312667',31000.00,0.00,0.00,0.00,1700.00,'2021-12-10 15:02:33','',''),(2234417,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 15:02:33','',''),(2234504,'1','200','1025',468,'Retail Sale Id 1312706',1502.24,0.00,0.00,0.00,160.30,'2021-12-10 15:06:42','',''),(2234505,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-10 15:06:42','',''),(2234852,'1','200','1025',468,'Retail Sale Id 1312881',8200.00,0.00,0.00,0.00,875.00,'2021-12-10 15:21:40','',''),(2234853,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:21:40','',''),(2234938,'1','200','1025',468,'Retail Sale Id 1312933',997.12,0.00,0.00,0.00,106.40,'2021-12-10 15:24:57','',''),(2234939,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-10 15:24:57','',''),(2234992,'1','200','1025',468,'Retail Sale Id 1312960',2000.80,0.00,0.00,0.00,213.50,'2021-12-10 15:26:56','',''),(2234993,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-10 15:26:56','',''),(2235054,'1','200','1025',468,'Retail Sale Id 1312975',1312.00,0.00,0.00,0.00,140.00,'2021-12-10 15:28:11','',''),(2235055,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:28:11','',''),(2235219,'1','200','1025',468,'Retail Sale Id 1313049',2000.80,0.00,0.00,0.00,213.50,'2021-12-10 15:35:23','',''),(2235220,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-10 15:35:23','',''),(2235445,'1','200','1025',468,'Retail Sale Id 1313158',1797.44,0.00,0.00,0.00,191.80,'2021-12-10 15:44:43','',''),(2235446,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.74,0.00,'2021-12-10 15:44:43','',''),(2235487,'1','200','1025',468,'Retail Sale Id 1313189',4264.00,0.00,0.00,0.00,455.00,'2021-12-10 15:46:58','',''),(2235488,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.50,0.00,'2021-12-10 15:46:58','',''),(2235525,'1','200','1025',468,'Retail Sale Id 1313212',2624.00,0.00,0.00,0.00,280.00,'2021-12-10 15:49:04','',''),(2235526,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 15:49:04','',''),(2235558,'1','200','1025',468,'Retail Sale Id 1313234',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 15:50:52','',''),(2235559,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:50:52','',''),(2235587,'1','200','1025',468,'Retail Sale Id 1313249',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 15:52:12','',''),(2235588,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:52:12','',''),(2235626,'1','200','1025',468,'Retail Sale Id 1313272',8200.00,0.00,0.00,0.00,875.00,'2021-12-10 15:54:19','',''),(2235627,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:54:19','',''),(2235727,'1','200','1025',468,'Retail Sale Id 1313318',656.00,0.00,0.00,0.00,70.00,'2021-12-10 15:58:47','',''),(2235728,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 15:58:47','',''),(2235790,'1','200','1025',468,'Retail Sale Id 1313350',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 16:01:14','',''),(2235791,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:01:14','',''),(2235816,'1','200','1025',468,'Retail Sale Id 1313365',3936.00,0.00,0.00,0.00,420.00,'2021-12-10 16:02:57','',''),(2235817,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:02:57','',''),(2236209,'1','200','1025',468,'Retail Sale Id 1313556',34100.00,0.00,0.00,0.00,1870.00,'2021-12-10 16:20:24','',''),(2236210,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-10 16:20:24','',''),(2236243,'1','200','1025',468,'Retail Sale Id 1313578',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 16:21:57','',''),(2236244,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:21:57','',''),(2236278,'1','200','1025',468,'Retail Sale Id 1313600',34100.00,0.00,0.00,0.00,1870.00,'2021-12-10 16:23:22','',''),(2236279,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-10 16:23:22','',''),(2236314,'1','200','1025',468,'Retail Sale Id 1313616',15500.00,0.00,0.00,0.00,850.00,'2021-12-10 16:24:44','',''),(2236315,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 16:24:44','',''),(2236336,'1','200','1025',468,'Retail Sale Id 1313627',5580.00,0.00,0.00,0.00,306.00,'2021-12-10 16:26:07','',''),(2236337,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-10 16:26:07','',''),(2236411,'1','200','1025',468,'Retail Sale Id 1313664',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 16:29:17','',''),(2236412,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:29:17','',''),(2236606,'1','200','1025',468,'Retail Sale Id 1313748',1502.24,0.00,0.00,0.00,160.30,'2021-12-10 16:38:26','',''),(2236607,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-10 16:38:26','',''),(2236700,'1','200','1025',468,'Retail Sale Id 1313784',2624.00,0.00,0.00,0.00,280.00,'2021-12-10 16:43:18','',''),(2236701,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 16:43:18','',''),(2236766,'1','200','1025',468,'Retail Sale Id 1313823',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 16:47:03','',''),(2236767,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 16:47:03','',''),(2236794,'1','200','1025',468,'Retail Sale Id 1313837',1968.00,0.00,0.00,0.00,210.00,'2021-12-10 16:49:03','',''),(2236795,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:49:03','',''),(2236826,'1','200','1025',468,'Retail Sale Id 1313852',8200.00,0.00,0.00,0.00,875.00,'2021-12-10 16:51:06','',''),(2236827,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:51:06','',''),(2237070,'1','200','1025',468,'Retail Sale Id 1313971',3280.00,0.00,0.00,0.00,350.00,'2021-12-10 17:05:24','',''),(2237071,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 17:05:24','',''),(2238428,'1','200','1025',468,'Retail Sale Id 1314435',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 06:03:14','',''),(2238429,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 06:03:14','',''),(2238576,'1','200','1025',468,'Retail Sale Id 1314480',997.12,0.00,0.00,0.00,106.40,'2021-12-11 06:15:42','',''),(2238577,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-11 06:15:42','',''),(2238672,'1','200','1025',468,'Retail Sale Id 1314522',11160.00,0.00,0.00,0.00,612.00,'2021-12-11 06:24:14','',''),(2238673,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-11 06:24:14','',''),(2238882,'1','200','1025',468,'Retail Sale Id 1314611',268.96,0.00,0.00,0.00,28.70,'2021-12-11 06:37:13','',''),(2238883,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,0.41,0.00,'2021-12-11 06:37:13','',''),(2239807,'1','200','1025',468,'Retail Sale Id 1315105',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 07:33:51','',''),(2239808,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 07:33:51','',''),(2240082,'1','200','1025',468,'Retail Sale Id 1315262',2000.80,0.00,0.00,0.00,213.50,'2021-12-11 07:47:54','',''),(2240083,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-11 07:47:54','',''),(2240084,'1','200','1025',468,'Retail Sale Id 1315262',3503.04,0.00,0.00,0.00,373.80,'2021-12-11 07:47:54','',''),(2240085,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-11 07:47:54','',''),(2240164,'1','200','1025',468,'Retail Sale Id 1315287',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 07:50:13','',''),(2240165,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 07:50:13','',''),(2240202,'1','200','1025',468,'Retail Sale Id 1315301',1312.00,0.00,0.00,0.00,140.00,'2021-12-11 07:51:33','',''),(2240203,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 07:51:33','',''),(2240232,'1','200','1025',468,'Retail Sale Id 1315317',2000.80,0.00,0.00,0.00,213.50,'2021-12-11 07:53:20','',''),(2240233,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-11 07:53:20','',''),(2240260,'1','200','1025',468,'Retail Sale Id 1315334',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 07:54:33','',''),(2240261,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 07:54:33','',''),(2240308,'1','200','1025',468,'Retail Sale Id 1315354',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 07:56:24','',''),(2240309,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 07:56:24','',''),(2240361,'1','200','1025',468,'Retail Sale Id 1315385',6560.00,0.00,0.00,0.00,700.00,'2021-12-11 07:58:44','',''),(2240362,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 07:58:44','',''),(2240410,'1','200','1025',468,'Retail Sale Id 1315404',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 08:00:35','',''),(2240411,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 08:00:35','',''),(2240465,'1','200','1025',468,'Retail Sale Id 1315413',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 08:03:08','',''),(2240466,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 08:03:08','',''),(2240806,'1','200','1025',468,'Retail Sale Id 1315571',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 08:18:06','',''),(2240807,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:18:06','',''),(2240890,'1','200','1025',468,'Retail Sale Id 1315619',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 08:22:01','',''),(2240891,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 08:22:01','',''),(2241102,'1','200','1025',468,'Retail Sale Id 1315724',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 08:33:33','',''),(2241103,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 08:33:33','',''),(2241256,'1','200','1025',468,'Retail Sale Id 1315788',4340.00,0.00,0.00,0.00,238.00,'2021-12-11 08:41:12','',''),(2241257,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 08:41:12','',''),(2241346,'1','200','1025',468,'Retail Sale Id 1315825',44640.00,0.00,0.00,0.00,2448.00,'2021-12-11 08:45:09','',''),(2241347,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,72.00,0.00,'2021-12-11 08:45:09','',''),(2241758,'1','200','1025',468,'Retail Sale Id 1316011',2624.00,0.00,0.00,0.00,280.00,'2021-12-11 09:03:01','',''),(2241759,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 09:03:01','',''),(2241816,'1','200','1025',468,'Retail Sale Id 1316038',997.12,0.00,0.00,0.00,106.40,'2021-12-11 09:05:49','',''),(2241817,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-11 09:05:49','',''),(2241818,'1','200','1025',468,'Retail Sale Id 1316038',1312.00,0.00,0.00,0.00,140.00,'2021-12-11 09:05:49','',''),(2241819,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 09:05:49','',''),(2242193,'1','200','1025',468,'Retail Sale Id 1316218',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 09:22:10','',''),(2242194,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:22:10','',''),(2242225,'1','200','1025',468,'Retail Sale Id 1316234',1312.00,0.00,0.00,0.00,140.00,'2021-12-11 09:23:32','',''),(2242226,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 09:23:32','',''),(2242227,'1','200','1025',468,'Retail Sale Id 1316234',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 09:23:32','',''),(2242228,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:23:32','',''),(2242301,'1','200','1025',468,'Retail Sale Id 1316268',31000.00,0.00,0.00,0.00,1700.00,'2021-12-11 09:28:27','',''),(2242302,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 09:28:27','',''),(2242398,'1','200','1025',468,'Retail Sale Id 1316320',31000.00,0.00,0.00,0.00,1700.00,'2021-12-11 09:33:32','',''),(2242399,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 09:33:32','',''),(2242436,'1','200','1025',468,'Retail Sale Id 1316339',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 09:35:19','',''),(2242437,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:35:19','',''),(2242482,'1','200','1025',468,'Retail Sale Id 1316368',2499.36,0.00,0.00,0.00,266.70,'2021-12-11 09:37:25','',''),(2242483,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-11 09:37:25','',''),(2242536,'1','200','1025',468,'Retail Sale Id 1316397',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 09:39:58','',''),(2242537,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 09:39:58','',''),(2242604,'1','200','1025',468,'Retail Sale Id 1316430',2624.00,0.00,0.00,0.00,280.00,'2021-12-11 09:42:53','',''),(2242605,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 09:42:53','',''),(2242788,'1','200','1025',468,'Retail Sale Id 1316522',170500.00,0.00,0.00,0.00,9350.00,'2021-12-11 09:51:18','',''),(2242789,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-11 09:51:18','',''),(2242947,'1','200','1025',468,'Retail Sale Id 1316593',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 09:59:44','',''),(2242948,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:59:44','',''),(2242949,'1','200','1025',468,'Retail Sale Id 1316593',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 09:59:44','',''),(2242950,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:59:44','',''),(2243053,'1','200','1025',468,'Retail Sale Id 1316624',310000.00,0.00,0.00,0.00,17000.00,'2021-12-11 10:05:27','',''),(2243054,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,500.00,0.00,'2021-12-11 10:05:27','',''),(2243377,'1','200','1025',468,'Retail Sale Id 1316766',37200.00,0.00,0.00,0.00,2040.00,'2021-12-11 10:18:25','',''),(2243378,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 10:18:25','',''),(2243760,'1','200','1025',468,'Retail Sale Id 1316957',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 10:39:38','',''),(2243761,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 10:39:38','',''),(2243798,'1','200','1025',468,'Retail Sale Id 1316977',7216.00,0.00,0.00,0.00,770.00,'2021-12-11 10:41:47','',''),(2243799,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 10:41:47','',''),(2243860,'1','200','1025',468,'Retail Sale Id 1317008',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 10:44:38','',''),(2243861,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:44:38','',''),(2243894,'1','200','1025',468,'Retail Sale Id 1317024',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 10:46:51','',''),(2243895,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 10:46:51','',''),(2244006,'1','200','1025',468,'Retail Sale Id 1317084',6560.00,0.00,0.00,0.00,700.00,'2021-12-11 10:53:36','',''),(2244007,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 10:53:36','',''),(2244092,'1','200','1025',468,'Retail Sale Id 1317125',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 10:58:11','',''),(2244093,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 10:58:11','',''),(2244231,'1','200','1025',468,'Retail Sale Id 1317177',656.00,0.00,0.00,0.00,70.00,'2021-12-11 11:03:31','',''),(2244232,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 11:03:31','',''),(2244349,'1','200','1025',468,'Retail Sale Id 1317238',2000.80,0.00,0.00,0.00,213.50,'2021-12-11 11:09:49','',''),(2244350,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-11 11:09:49','',''),(2244425,'1','200','1025',468,'Retail Sale Id 1317278',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 11:14:02','',''),(2244426,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 11:14:02','',''),(2244451,'1','200','1025',468,'Retail Sale Id 1317287',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 11:15:17','',''),(2244452,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:15:17','',''),(2244453,'1','200','1025',468,'Retail Sale Id 1317287',32800.00,0.00,0.00,0.00,3500.00,'2021-12-11 11:15:17','',''),(2244454,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 11:15:17','',''),(2244543,'1','200','1025',468,'Retail Sale Id 1317335',1312.00,0.00,0.00,0.00,140.00,'2021-12-11 11:20:06','',''),(2244544,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 11:20:06','',''),(2244570,'1','200','1025',468,'Retail Sale Id 1317348',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 11:21:20','',''),(2244571,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 11:21:20','',''),(2244712,'1','200','1025',468,'Retail Sale Id 1317412',656.00,0.00,0.00,0.00,70.00,'2021-12-11 11:27:23','',''),(2244713,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 11:27:23','',''),(2244756,'1','200','1025',468,'Retail Sale Id 1317430',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 11:30:21','',''),(2244757,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:30:21','',''),(2244874,'1','200','1025',468,'Retail Sale Id 1317500',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 11:37:26','',''),(2244875,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:37:26','',''),(2244904,'1','200','1025',468,'Retail Sale Id 1317517',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 11:39:16','',''),(2244905,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:39:16','',''),(2245061,'1','200','1025',468,'Retail Sale Id 1317603',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 11:50:03','',''),(2245062,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:50:03','',''),(2245337,'1','200','1025',468,'Retail Sale Id 1317739',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 12:06:15','',''),(2245338,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 12:06:15','',''),(2245445,'1','200','1025',468,'Retail Sale Id 1317844',8396.80,0.00,0.00,0.00,896.00,'2021-12-11 12:13:58','',''),(2245446,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.80,0.00,'2021-12-11 12:13:58','',''),(2245581,'1','200','1025',468,'Retail Sale Id 1317915',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 12:21:28','',''),(2245582,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 12:21:28','',''),(2245792,'1','200','1025',468,'Retail Sale Id 1318008',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 12:33:12','',''),(2245793,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 12:33:12','',''),(2245947,'1','200','1025',468,'Retail Sale Id 1318090',74400.00,0.00,0.00,0.00,4080.00,'2021-12-11 12:43:14','',''),(2245948,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-11 12:43:14','',''),(2245997,'1','200','1025',468,'Retail Sale Id 1318118',4001.60,0.00,0.00,0.00,427.00,'2021-12-11 12:46:43','',''),(2245998,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-11 12:46:43','',''),(2246122,'1','200','1025',468,'Retail Sale Id 1318180',6560.00,0.00,0.00,0.00,700.00,'2021-12-11 12:56:06','',''),(2246123,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 12:56:06','',''),(2246162,'1','200','1025',468,'Retail Sale Id 1318195',7216.00,0.00,0.00,0.00,770.00,'2021-12-11 12:59:05','',''),(2246163,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 12:59:05','',''),(2246194,'1','200','1025',468,'Retail Sale Id 1318221',656.00,0.00,0.00,0.00,70.00,'2021-12-11 13:01:09','',''),(2246195,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 13:01:09','',''),(2246222,'1','200','1025',468,'Retail Sale Id 1318236',2624.00,0.00,0.00,0.00,280.00,'2021-12-11 13:02:41','',''),(2246223,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 13:02:41','',''),(2246278,'1','200','1025',468,'Retail Sale Id 1318270',13120.00,0.00,0.00,0.00,1400.00,'2021-12-11 13:08:43','',''),(2246279,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-11 13:08:43','',''),(2246288,'1','200','1025',468,'Retail Sale Id 1318273',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 13:09:23','',''),(2246289,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 13:09:23','',''),(2246328,'1','200','1025',468,'Retail Sale Id 1318294',2000.80,0.00,0.00,0.00,213.50,'2021-12-11 13:13:08','',''),(2246329,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-11 13:13:08','',''),(2246399,'1','200','1025',468,'Retail Sale Id 1318325',186000.00,0.00,0.00,0.00,10200.00,'2021-12-11 13:18:14','',''),(2246400,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-11 13:18:14','',''),(2246421,'1','200','1025',468,'Retail Sale Id 1318340',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 13:19:50','',''),(2246422,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 13:19:50','',''),(2246456,'1','200','1025',468,'Retail Sale Id 1318350',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 13:21:03','',''),(2246457,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:21:03','',''),(2246509,'1','200','1025',468,'Retail Sale Id 1318375',656.00,0.00,0.00,0.00,70.00,'2021-12-11 13:23:58','',''),(2246510,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 13:23:58','',''),(2246537,'1','200','1025',468,'Retail Sale Id 1318385',6002.40,0.00,0.00,0.00,640.50,'2021-12-11 13:25:46','',''),(2246538,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-11 13:25:46','',''),(2246563,'1','200','1025',468,'Retail Sale Id 1318399',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 13:27:34','',''),(2246564,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:27:34','',''),(2246810,'1','200','1025',468,'Retail Sale Id 1318494',997.12,0.00,0.00,0.00,106.40,'2021-12-11 13:43:09','',''),(2246811,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-11 13:43:09','',''),(2246881,'1','200','1025',468,'Retail Sale Id 1318531',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 13:49:12','',''),(2246882,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 13:49:12','',''),(2246984,'1','200','1025',468,'Retail Sale Id 1318583',55800.00,0.00,0.00,0.00,3060.00,'2021-12-11 13:55:23','',''),(2246985,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-11 13:55:23','',''),(2247020,'1','200','1025',468,'Retail Sale Id 1318601',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 13:57:04','',''),(2247021,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 13:57:04','',''),(2247087,'1','200','1025',468,'Retail Sale Id 1318632',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 14:01:31','',''),(2247088,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:01:31','',''),(2247089,'1','200','1025',468,'Retail Sale Id 1318632',2624.00,0.00,0.00,0.00,280.00,'2021-12-11 14:01:31','',''),(2247090,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 14:01:31','',''),(2247109,'1','200','1025',468,'Retail Sale Id 1318650',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 14:03:12','',''),(2247110,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:03:12','',''),(2247139,'1','200','1025',468,'Retail Sale Id 1318663',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 14:05:10','',''),(2247140,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:05:10','',''),(2247188,'1','200','1025',468,'Retail Sale Id 1318689',7872.00,0.00,0.00,0.00,840.00,'2021-12-11 14:08:27','',''),(2247189,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 14:08:27','',''),(2247270,'1','200','1025',468,'Retail Sale Id 1318724',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 14:12:04','',''),(2247271,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:12:04','',''),(2247468,'1','200','1025',468,'Retail Sale Id 1318820',99200.00,0.00,0.00,0.00,5440.00,'2021-12-11 14:25:17','',''),(2247469,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,160.00,0.00,'2021-12-11 14:25:17','',''),(2247532,'1','200','1025',468,'Retail Sale Id 1318850',701.92,0.00,0.00,0.00,74.90,'2021-12-11 14:30:13','',''),(2247533,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-11 14:30:13','',''),(2247582,'1','200','1025',468,'Retail Sale Id 1318884',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 14:33:51','',''),(2247583,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:33:51','',''),(2247600,'1','200','1025',468,'Retail Sale Id 1318895',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 14:34:45','',''),(2247601,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:34:45','',''),(2247610,'1','200','1025',468,'Retail Sale Id 1318901',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 14:35:39','',''),(2247611,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:35:39','',''),(2247650,'1','200','1025',468,'Retail Sale Id 1318923',6560.00,0.00,0.00,0.00,700.00,'2021-12-11 14:37:39','',''),(2247651,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 14:37:39','',''),(2247694,'1','200','1025',468,'Retail Sale Id 1318951',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 14:40:32','',''),(2247695,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:40:32','',''),(2247696,'1','200','1025',468,'Retail Sale Id 1318951',7216.00,0.00,0.00,0.00,770.00,'2021-12-11 14:40:32','',''),(2247697,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 14:40:32','',''),(2247746,'1','200','1025',468,'Retail Sale Id 1318967',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 14:43:44','',''),(2247747,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:43:44','',''),(2247748,'1','200','1025',468,'Retail Sale Id 1318967',7872.00,0.00,0.00,0.00,840.00,'2021-12-11 14:43:44','',''),(2247749,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 14:43:44','',''),(2247768,'1','200','1025',468,'Retail Sale Id 1318985',997.12,0.00,0.00,0.00,106.40,'2021-12-11 14:44:47','',''),(2247769,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-11 14:44:47','',''),(2247874,'1','200','1025',468,'Retail Sale Id 1319034',14880.00,0.00,0.00,0.00,816.00,'2021-12-11 14:50:56','',''),(2247875,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-11 14:50:56','',''),(2247902,'1','200','1025',468,'Retail Sale Id 1319054',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 14:52:55','',''),(2247903,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:52:55','',''),(2247944,'1','200','1025',468,'Retail Sale Id 1319076',1640.00,0.00,0.00,0.00,175.00,'2021-12-11 14:54:57','',''),(2247945,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-11 14:54:57','',''),(2248023,'1','200','1025',468,'Retail Sale Id 1319118',3699.84,0.00,0.00,0.00,394.80,'2021-12-11 14:59:02','',''),(2248024,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.64,0.00,'2021-12-11 14:59:02','',''),(2248065,'1','200','1025',468,'Retail Sale Id 1319141',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 15:02:01','',''),(2248066,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:02:01','',''),(2248326,'1','200','1025',468,'Retail Sale Id 1319232',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 15:12:56','',''),(2248327,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:12:56','',''),(2248356,'1','200','1025',468,'Retail Sale Id 1319246',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 15:14:50','',''),(2248357,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:14:50','',''),(2248416,'1','200','1025',468,'Retail Sale Id 1319278',1640.00,0.00,0.00,0.00,175.00,'2021-12-11 15:17:43','',''),(2248417,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-11 15:17:43','',''),(2248502,'1','200','1025',468,'Retail Sale Id 1319327',6500.96,0.00,0.00,0.00,693.70,'2021-12-11 15:22:27','',''),(2248503,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.91,0.00,'2021-12-11 15:22:27','',''),(2248522,'1','200','1025',468,'Retail Sale Id 1319337',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 15:23:44','',''),(2248523,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:23:44','',''),(2248538,'1','200','1025',468,'Retail Sale Id 1319348',2624.00,0.00,0.00,0.00,280.00,'2021-12-11 15:24:42','',''),(2248539,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 15:24:42','',''),(2248574,'1','200','1025',468,'Retail Sale Id 1319367',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 15:26:49','',''),(2248575,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:26:49','',''),(2248660,'1','200','1025',468,'Retail Sale Id 1319417',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 15:31:43','',''),(2248661,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:31:43','',''),(2248722,'1','200','1025',468,'Retail Sale Id 1319449',2624.00,0.00,0.00,0.00,280.00,'2021-12-11 15:34:44','',''),(2248723,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 15:34:44','',''),(2248724,'1','200','1025',468,'Retail Sale Id 1319449',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 15:34:44','',''),(2248725,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:34:44','',''),(2248800,'1','200','1025',468,'Retail Sale Id 1319491',8060.00,0.00,0.00,0.00,442.00,'2021-12-11 15:38:53','',''),(2248801,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-11 15:38:53','',''),(2248884,'1','200','1025',468,'Retail Sale Id 1319540',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 15:44:04','',''),(2248885,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:44:04','',''),(2249003,'1','200','1025',468,'Retail Sale Id 1319590',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 15:48:48','',''),(2249004,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:48:48','',''),(2249061,'1','200','1025',468,'Retail Sale Id 1319620',6560.00,0.00,0.00,0.00,700.00,'2021-12-11 15:51:35','',''),(2249062,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 15:51:35','',''),(2249125,'1','200','1025',468,'Retail Sale Id 1319649',1502.24,0.00,0.00,0.00,160.30,'2021-12-11 15:53:56','',''),(2249126,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-11 15:53:56','',''),(2249206,'1','200','1025',468,'Retail Sale Id 1319676',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 15:56:23','',''),(2249207,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:56:23','',''),(2249265,'1','200','1025',468,'Retail Sale Id 1319695',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 15:58:25','',''),(2249266,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:58:25','',''),(2249357,'1','200','1025',468,'Retail Sale Id 1319740',74400.00,0.00,0.00,0.00,4080.00,'2021-12-11 16:02:03','',''),(2249358,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-11 16:02:03','',''),(2249405,'1','200','1025',468,'Retail Sale Id 1319757',6560.00,0.00,0.00,0.00,700.00,'2021-12-11 16:04:03','',''),(2249406,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 16:04:03','',''),(2249407,'1','200','1025',468,'Retail Sale Id 1319757',6560.00,0.00,0.00,0.00,700.00,'2021-12-11 16:04:03','',''),(2249408,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 16:04:03','',''),(2249452,'1','200','1025',468,'Retail Sale Id 1319785',2000.80,0.00,0.00,0.00,213.50,'2021-12-11 16:06:32','',''),(2249453,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-11 16:06:32','',''),(2249500,'1','200','1025',468,'Retail Sale Id 1319804',7872.00,0.00,0.00,0.00,840.00,'2021-12-11 16:08:22','',''),(2249501,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 16:08:22','',''),(2249550,'1','200','1025',468,'Retail Sale Id 1319834',2997.92,0.00,0.00,0.00,319.90,'2021-12-11 16:10:57','',''),(2249551,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-11 16:10:57','',''),(2249602,'1','200','1025',468,'Retail Sale Id 1319903',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 16:14:02','',''),(2249603,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:14:02','',''),(2249623,'1','200','1025',468,'Retail Sale Id 1319917',2997.92,0.00,0.00,0.00,319.90,'2021-12-11 16:15:02','',''),(2249624,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-11 16:15:02','',''),(2249693,'1','200','1025',468,'Retail Sale Id 1319952',34100.00,0.00,0.00,0.00,1870.00,'2021-12-11 16:19:34','',''),(2249694,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-11 16:19:34','',''),(2249815,'1','200','1025',468,'Retail Sale Id 1320010',2000.80,0.00,0.00,0.00,213.50,'2021-12-11 16:26:30','',''),(2249816,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-11 16:26:30','',''),(2250004,'1','200','1025',468,'Retail Sale Id 1320088',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 16:35:49','',''),(2250005,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:35:49','',''),(2250040,'1','200','1025',468,'Retail Sale Id 1320104',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 16:37:14','',''),(2250041,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:37:14','',''),(2250083,'1','200','1025',468,'Retail Sale Id 1320111',6888.00,0.00,0.00,0.00,735.00,'2021-12-11 16:38:27','',''),(2250084,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-11 16:38:27','',''),(2250095,'1','200','1025',468,'Retail Sale Id 1320115',2000.80,0.00,0.00,0.00,213.50,'2021-12-11 16:39:28','',''),(2250096,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-11 16:39:28','',''),(2250109,'1','200','1025',468,'Retail Sale Id 1320124',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 16:40:33','',''),(2250110,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 16:40:33','',''),(2250200,'1','200','1025',468,'Retail Sale Id 1320163',3936.00,0.00,0.00,0.00,420.00,'2021-12-11 16:46:18','',''),(2250201,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:46:18','',''),(2250220,'1','200','1025',468,'Retail Sale Id 1320174',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 16:47:46','',''),(2250221,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:47:46','',''),(2250264,'1','200','1025',468,'Retail Sale Id 1320191',3280.00,0.00,0.00,0.00,350.00,'2021-12-11 16:49:50','',''),(2250265,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 16:49:50','',''),(2250276,'1','200','1025',468,'Retail Sale Id 1320194',2000.80,0.00,0.00,0.00,213.50,'2021-12-11 16:50:45','',''),(2250277,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-11 16:50:45','',''),(2250447,'1','200','1025',468,'Retail Sale Id 1320267',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 17:00:20','',''),(2250448,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 17:00:20','',''),(2250465,'1','200','1025',468,'Retail Sale Id 1320275',2997.92,0.00,0.00,0.00,319.90,'2021-12-11 17:01:23','',''),(2250466,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-11 17:01:23','',''),(2250560,'1','200','1025',468,'Retail Sale Id 1320320',2000.80,0.00,0.00,0.00,213.50,'2021-12-11 17:06:03','',''),(2250561,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-11 17:06:03','',''),(2250652,'1','200','1025',468,'Retail Sale Id 1320373',1502.24,0.00,0.00,0.00,160.30,'2021-12-11 17:15:04','',''),(2250653,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-11 17:15:04','',''),(2250664,'1','200','1025',468,'Retail Sale Id 1320380',8200.00,0.00,0.00,0.00,875.00,'2021-12-11 17:15:56','',''),(2250665,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 17:15:56','',''),(2250670,'1','200','1025',468,'Retail Sale Id 1320384',498.56,0.00,0.00,0.00,53.20,'2021-12-11 17:17:01','',''),(2250671,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,0.76,0.00,'2021-12-11 17:17:01','',''),(2250926,'1','200','1025',468,'Retail Sale Id 1320503',4592.00,0.00,0.00,0.00,490.00,'2021-12-11 17:38:20','',''),(2250927,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 17:38:20','',''),(2250947,'1','200','1025',468,'Retail Sale Id 1320513',2624.00,0.00,0.00,0.00,280.00,'2021-12-11 17:39:55','',''),(2250948,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 17:39:55','',''),(2250992,'1','200','1025',468,'Retail Sale Id 1320532',1312.00,0.00,0.00,0.00,140.00,'2021-12-11 17:42:37','',''),(2250993,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 17:42:37','',''),(2251436,'1','200','1025',468,'Retail Sale Id 1320714',1968.00,0.00,0.00,0.00,210.00,'2021-12-11 18:35:37','',''),(2251437,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 18:35:37','',''),(2252379,'1','200','1025',468,'Retail Sale Id 1320958',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 06:38:06','',''),(2252380,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 06:38:06','',''),(2252454,'1','200','1025',468,'Retail Sale Id 1320997',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 06:44:34','',''),(2252455,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 06:44:34','',''),(2252906,'1','200','1025',468,'Retail Sale Id 1321187',4001.60,0.00,0.00,0.00,427.00,'2021-12-12 07:14:45','',''),(2252907,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-12 07:14:45','',''),(2253000,'1','200','1025',468,'Retail Sale Id 1321236',1312.00,0.00,0.00,0.00,140.00,'2021-12-12 07:21:28','',''),(2253001,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 07:21:28','',''),(2253030,'1','200','1025',468,'Retail Sale Id 1321255',1312.00,0.00,0.00,0.00,140.00,'2021-12-12 07:23:36','',''),(2253031,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 07:23:36','',''),(2253426,'1','200','1025',468,'Retail Sale Id 1321479',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 07:49:05','',''),(2253427,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 07:49:05','',''),(2253499,'1','200','1025',468,'Retail Sale Id 1321516',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 07:54:13','',''),(2253500,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 07:54:13','',''),(2253525,'1','200','1025',468,'Retail Sale Id 1321531',4001.60,0.00,0.00,0.00,427.00,'2021-12-12 07:56:33','',''),(2253526,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-12 07:56:33','',''),(2253575,'1','200','1025',468,'Retail Sale Id 1321549',6560.00,0.00,0.00,0.00,700.00,'2021-12-12 07:58:34','',''),(2253576,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 07:58:34','',''),(2253632,'1','200','1025',468,'Retail Sale Id 1321581',108500.00,0.00,0.00,0.00,5950.00,'2021-12-12 08:02:12','',''),(2253633,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,175.00,0.00,'2021-12-12 08:02:12','',''),(2253843,'1','200','1025',468,'Retail Sale Id 1321668',48360.00,0.00,0.00,0.00,2652.00,'2021-12-12 08:15:50','',''),(2253844,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,78.00,0.00,'2021-12-12 08:15:50','',''),(2253951,'1','200','1025',468,'Retail Sale Id 1321737',6560.00,0.00,0.00,0.00,700.00,'2021-12-12 08:23:16','',''),(2253952,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 08:23:16','',''),(2253977,'1','200','1025',468,'Retail Sale Id 1321749',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 08:24:43','',''),(2253978,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 08:24:43','',''),(2254102,'1','200','1025',468,'Retail Sale Id 1321817',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 08:34:22','',''),(2254103,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 08:34:22','',''),(2254418,'1','200','1025',468,'Retail Sale Id 1321956',1640.00,0.00,0.00,0.00,175.00,'2021-12-12 08:50:45','',''),(2254419,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-12 08:50:45','',''),(2254472,'1','200','1025',468,'Retail Sale Id 1321991',1312.00,0.00,0.00,0.00,140.00,'2021-12-12 08:54:45','',''),(2254473,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 08:54:45','',''),(2254524,'1','200','1025',468,'Retail Sale Id 1322009',6560.00,0.00,0.00,0.00,700.00,'2021-12-12 08:57:47','',''),(2254525,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 08:57:47','',''),(2254586,'1','200','1025',468,'Retail Sale Id 1322047',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 09:01:33','',''),(2254587,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 09:01:33','',''),(2254687,'1','200','1025',468,'Retail Sale Id 1322102',2624.00,0.00,0.00,0.00,280.00,'2021-12-12 09:06:53','',''),(2254688,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 09:06:53','',''),(2254713,'1','200','1025',468,'Retail Sale Id 1322113',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 09:08:30','',''),(2254714,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:08:30','',''),(2254779,'1','200','1025',468,'Retail Sale Id 1322144',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 09:11:33','',''),(2254780,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 09:11:33','',''),(2254815,'1','200','1025',468,'Retail Sale Id 1322159',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 09:12:53','',''),(2254816,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:12:53','',''),(2254873,'1','200','1025',468,'Retail Sale Id 1322195',186000.00,0.00,0.00,0.00,10200.00,'2021-12-12 09:16:36','',''),(2254874,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-12 09:16:36','',''),(2254897,'1','200','1025',468,'Retail Sale Id 1322208',4001.60,0.00,0.00,0.00,427.00,'2021-12-12 09:18:06','',''),(2254898,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-12 09:18:06','',''),(2254923,'1','200','1025',468,'Retail Sale Id 1322220',2000.80,0.00,0.00,0.00,213.50,'2021-12-12 09:19:09','',''),(2254924,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-12 09:19:09','',''),(2254996,'1','200','1025',468,'Retail Sale Id 1322261',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 09:24:06','',''),(2254997,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:24:06','',''),(2254998,'1','200','1025',468,'Retail Sale Id 1322261',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 09:24:06','',''),(2254999,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:24:06','',''),(2255016,'1','200','1025',468,'Retail Sale Id 1322268',2997.92,0.00,0.00,0.00,319.90,'2021-12-12 09:25:04','',''),(2255017,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-12 09:25:04','',''),(2255052,'1','200','1025',468,'Retail Sale Id 1322280',17360.00,0.00,0.00,0.00,952.00,'2021-12-12 09:27:31','',''),(2255053,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-12 09:27:31','',''),(2255193,'1','200','1025',468,'Retail Sale Id 1322343',4001.60,0.00,0.00,0.00,427.00,'2021-12-12 09:34:45','',''),(2255194,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-12 09:34:45','',''),(2255361,'1','200','1025',468,'Retail Sale Id 1322436',1312.00,0.00,0.00,0.00,140.00,'2021-12-12 09:46:36','',''),(2255362,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 09:46:36','',''),(2255579,'1','200','1025',468,'Retail Sale Id 1322531',6999.52,0.00,0.00,0.00,746.90,'2021-12-12 09:56:09','',''),(2255580,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.67,0.00,'2021-12-12 09:56:09','',''),(2255640,'1','200','1025',468,'Retail Sale Id 1322557',2000.80,0.00,0.00,0.00,213.50,'2021-12-12 09:58:40','',''),(2255641,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-12 09:58:40','',''),(2255731,'1','200','1025',468,'Retail Sale Id 1322594',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 10:02:40','',''),(2255732,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 10:02:40','',''),(2255797,'1','200','1025',468,'Retail Sale Id 1322627',3280.00,0.00,0.00,0.00,350.00,'2021-12-12 10:05:31','',''),(2255798,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 10:05:31','',''),(2255863,'1','200','1025',468,'Retail Sale Id 1322667',34100.00,0.00,0.00,0.00,1870.00,'2021-12-12 10:08:47','',''),(2255864,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-12 10:08:47','',''),(2255934,'1','200','1025',468,'Retail Sale Id 1322700',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 10:12:31','',''),(2255935,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:12:31','',''),(2255962,'1','200','1025',468,'Retail Sale Id 1322717',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 10:14:05','',''),(2255963,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:14:05','',''),(2256049,'1','200','1025',468,'Retail Sale Id 1322767',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 10:18:18','',''),(2256050,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:18:18','',''),(2256123,'1','200','1025',468,'Retail Sale Id 1322804',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 10:23:50','',''),(2256124,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:23:50','',''),(2256125,'1','200','1025',468,'Retail Sale Id 1322804',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 10:23:50','',''),(2256126,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:23:50','',''),(2256163,'1','200','1025',468,'Retail Sale Id 1322829',7872.00,0.00,0.00,0.00,840.00,'2021-12-12 10:25:52','',''),(2256164,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-12 10:25:52','',''),(2256377,'1','200','1025',468,'Retail Sale Id 1322943',2624.00,0.00,0.00,0.00,280.00,'2021-12-12 10:36:53','',''),(2256378,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 10:36:53','',''),(2256652,'1','200','1025',468,'Retail Sale Id 1323079',5248.00,0.00,0.00,0.00,560.00,'2021-12-12 10:49:52','',''),(2256653,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-12 10:49:52','',''),(2256693,'1','200','1025',468,'Retail Sale Id 1323098',7872.00,0.00,0.00,0.00,840.00,'2021-12-12 10:51:52','',''),(2256694,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-12 10:51:52','',''),(2256735,'1','200','1025',468,'Retail Sale Id 1323120',5904.00,0.00,0.00,0.00,630.00,'2021-12-12 10:53:28','',''),(2256736,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-12 10:53:28','',''),(2256777,'1','200','1025',468,'Retail Sale Id 1323143',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 10:55:47','',''),(2256778,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 10:55:47','',''),(2256824,'1','200','1025',468,'Retail Sale Id 1323162',4001.60,0.00,0.00,0.00,427.00,'2021-12-12 10:57:37','',''),(2256825,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-12 10:57:37','',''),(2256863,'1','200','1025',468,'Retail Sale Id 1323182',17980.00,0.00,0.00,0.00,986.00,'2021-12-12 10:59:18','',''),(2256864,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,29.00,0.00,'2021-12-12 10:59:18','',''),(2256992,'1','200','1025',468,'Retail Sale Id 1323239',1312.00,0.00,0.00,0.00,140.00,'2021-12-12 11:04:02','',''),(2256993,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 11:04:02','',''),(2257137,'1','200','1025',468,'Retail Sale Id 1323319',5248.00,0.00,0.00,0.00,560.00,'2021-12-12 11:09:44','',''),(2257138,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-12 11:09:44','',''),(2257429,'1','200','1025',468,'Retail Sale Id 1323466',5248.00,0.00,0.00,0.00,560.00,'2021-12-12 11:21:46','',''),(2257430,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-12 11:21:47','',''),(2257465,'1','200','1025',468,'Retail Sale Id 1323483',656.00,0.00,0.00,0.00,70.00,'2021-12-12 11:23:22','',''),(2257466,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 11:23:22','',''),(2257481,'1','200','1025',468,'Retail Sale Id 1323490',2997.92,0.00,0.00,0.00,319.90,'2021-12-12 11:24:29','',''),(2257482,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-12 11:24:29','',''),(2257509,'1','200','1025',468,'Retail Sale Id 1323502',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 11:25:32','',''),(2257510,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:25:32','',''),(2257546,'1','200','1025',468,'Retail Sale Id 1323520',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 11:27:11','',''),(2257547,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 11:27:11','',''),(2257656,'1','200','1025',468,'Retail Sale Id 1323591',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 11:32:46','',''),(2257657,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:32:46','',''),(2257692,'1','200','1025',468,'Retail Sale Id 1323610',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 11:34:31','',''),(2257693,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:34:31','',''),(2257905,'1','200','1025',468,'Retail Sale Id 1323701',997.12,0.00,0.00,0.00,106.40,'2021-12-12 11:44:27','',''),(2257906,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-12 11:44:27','',''),(2258054,'1','200','1025',468,'Retail Sale Id 1323781',2997.92,0.00,0.00,0.00,319.90,'2021-12-12 11:51:37','',''),(2258055,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-12 11:51:37','',''),(2258074,'1','200','1025',468,'Retail Sale Id 1323792',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 11:52:24','',''),(2258075,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:52:24','',''),(2258122,'1','200','1025',468,'Retail Sale Id 1323812',1351.36,0.00,0.00,0.00,144.20,'2021-12-12 11:54:24','',''),(2258123,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-12 11:54:24','',''),(2258172,'1','200','1025',468,'Retail Sale Id 1323836',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 11:56:35','',''),(2258173,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:56:35','',''),(2258200,'1','200','1025',468,'Retail Sale Id 1323853',3280.00,0.00,0.00,0.00,350.00,'2021-12-12 11:58:13','',''),(2258201,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 11:58:13','',''),(2258222,'1','200','1025',468,'Retail Sale Id 1323864',111600.00,0.00,0.00,0.00,6120.00,'2021-12-12 11:59:21','',''),(2258223,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-12 11:59:21','',''),(2258462,'1','200','1025',468,'Retail Sale Id 1323977',2624.00,0.00,0.00,0.00,280.00,'2021-12-12 12:13:33','',''),(2258463,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 12:13:33','',''),(2258658,'1','200','1025',468,'Retail Sale Id 1324073',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 12:22:42','',''),(2258659,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:22:42','',''),(2258660,'1','200','1025',468,'Retail Sale Id 1324073',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 12:22:42','',''),(2258661,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:22:42','',''),(2258844,'1','200','1025',468,'Retail Sale Id 1324131',76260.00,0.00,0.00,0.00,4182.00,'2021-12-12 12:30:26','',''),(2258845,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,123.00,0.00,'2021-12-12 12:30:26','',''),(2258982,'1','200','1025',468,'Retail Sale Id 1324225',656.00,0.00,0.00,0.00,70.00,'2021-12-12 12:36:36','',''),(2258983,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 12:36:36','',''),(2259079,'1','200','1025',468,'Retail Sale Id 1324272',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 12:40:45','',''),(2259080,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:40:45','',''),(2259081,'1','200','1025',468,'Retail Sale Id 1324272',32800.00,0.00,0.00,0.00,3500.00,'2021-12-12 12:40:45','',''),(2259082,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 12:40:45','',''),(2259471,'1','200','1025',468,'Retail Sale Id 1324450',1312.00,0.00,0.00,0.00,140.00,'2021-12-12 12:59:14','',''),(2259472,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 12:59:14','',''),(2259563,'1','200','1025',468,'Retail Sale Id 1324505',58900.00,0.00,0.00,0.00,3230.00,'2021-12-12 13:05:07','',''),(2259564,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-12 13:05:07','',''),(2259920,'1','200','1025',468,'Retail Sale Id 1324674',2624.00,0.00,0.00,0.00,280.00,'2021-12-12 13:23:46','',''),(2259921,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 13:23:46','',''),(2259958,'1','200','1025',468,'Retail Sale Id 1324689',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 13:25:51','',''),(2259959,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 13:25:51','',''),(2260010,'1','200','1025',468,'Return of Retail Sale Id 1324505',0.00,58900.00,95.00,0.00,-3230.00,'2021-12-12 13:27:45','',''),(2260017,'1','200','1025',468,'Retail Sale Id 1324715',4998.72,0.00,0.00,0.00,533.40,'2021-12-12 13:28:05','',''),(2260018,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-12 13:28:05','',''),(2260115,'1','200','1025',468,'Retail Sale Id 1324750',43400.00,0.00,0.00,0.00,2380.00,'2021-12-12 13:31:52','',''),(2260116,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-12 13:31:52','',''),(2260133,'1','200','1025',468,'Retail Sale Id 1324759',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 13:32:54','',''),(2260134,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 13:32:54','',''),(2260171,'1','200','1025',468,'Retail Sale Id 1324778',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 13:34:43','',''),(2260172,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:34:43','',''),(2260360,'1','200','1025',468,'Retail Sale Id 1324858',7544.00,0.00,0.00,0.00,805.00,'2021-12-12 13:43:39','',''),(2260361,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-12 13:43:39','',''),(2260586,'1','200','1025',468,'Retail Sale Id 1324961',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 13:55:20','',''),(2260587,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 13:55:20','',''),(2260613,'1','200','1025',468,'Retail Sale Id 1324976',2000.80,0.00,0.00,0.00,213.50,'2021-12-12 13:56:35','',''),(2260614,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-12 13:56:35','',''),(2260655,'1','200','1025',468,'Retail Sale Id 1324995',1502.24,0.00,0.00,0.00,160.30,'2021-12-12 13:58:14','',''),(2260656,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-12 13:58:14','',''),(2260823,'1','200','1025',468,'Retail Sale Id 1325043',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 14:04:29','',''),(2260824,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 14:04:29','',''),(2260853,'1','200','1025',468,'Retail Sale Id 1325059',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 14:06:15','',''),(2260854,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:06:15','',''),(2261043,'1','200','1025',468,'Retail Sale Id 1325136',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 14:15:12','',''),(2261044,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:15:12','',''),(2261055,'1','200','1025',468,'Retail Sale Id 1325143',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 14:16:22','',''),(2261056,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:16:22','',''),(2261161,'1','200','1025',468,'Retail Sale Id 1325188',3280.00,0.00,0.00,0.00,350.00,'2021-12-12 14:22:19','',''),(2261162,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 14:22:19','',''),(2261336,'1','200','1025',468,'Retail Sale Id 1325237',34100.00,0.00,0.00,0.00,1870.00,'2021-12-12 14:28:20','',''),(2261337,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-12 14:28:20','',''),(2261392,'1','200','1025',468,'Retail Sale Id 1325254',2000.80,0.00,0.00,0.00,213.50,'2021-12-12 14:30:10','',''),(2261393,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-12 14:30:10','',''),(2261584,'1','200','1025',468,'Retail Sale Id 1325341',11808.00,0.00,0.00,0.00,1260.00,'2021-12-12 14:42:06','',''),(2261585,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-12 14:42:06','',''),(2261606,'1','200','1025',468,'Retail Sale Id 1325359',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 14:44:01','',''),(2261607,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 14:44:01','',''),(2261739,'1','200','1025',468,'Retail Sale Id 1325408',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 14:49:51','',''),(2261740,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:49:51','',''),(2261935,'1','200','1025',468,'Retail Sale Id 1325500',1312.00,0.00,0.00,0.00,140.00,'2021-12-12 15:00:28','',''),(2261936,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 15:00:28','',''),(2262141,'1','200','1025',468,'Retail Sale Id 1325579',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 15:11:28','',''),(2262142,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:11:28','',''),(2262208,'1','200','1025',468,'Retail Sale Id 1325615',2624.00,0.00,0.00,0.00,280.00,'2021-12-12 15:15:18','',''),(2262209,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 15:15:18','',''),(2262258,'1','200','1025',468,'Retail Sale Id 1325640',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 15:17:55','',''),(2262259,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 15:17:55','',''),(2262420,'1','200','1025',468,'Retail Sale Id 1325711',3949.12,0.00,0.00,0.00,421.40,'2021-12-12 15:27:19','',''),(2262421,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-12 15:27:19','',''),(2262483,'1','200','1025',468,'Retail Sale Id 1325743',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 15:31:13','',''),(2262484,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:31:13','',''),(2262606,'1','200','1025',468,'Retail Sale Id 1325797',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 15:37:49','',''),(2262607,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 15:37:49','',''),(2262682,'1','200','1025',468,'Retail Sale Id 1325831',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 15:42:00','',''),(2262683,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:42:00','',''),(2262792,'1','200','1025',468,'Retail Sale Id 1325883',1502.24,0.00,0.00,0.00,160.30,'2021-12-12 15:47:49','',''),(2262793,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-12 15:47:49','',''),(2262873,'1','200','1025',468,'Retail Sale Id 1325925',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 15:52:40','',''),(2262874,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 15:52:40','',''),(2262889,'1','200','1025',468,'Retail Sale Id 1325934',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 15:54:09','',''),(2262890,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:54:09','',''),(2262921,'1','200','1025',468,'Retail Sale Id 1325948',2000.80,0.00,0.00,0.00,213.50,'2021-12-12 15:56:55','',''),(2262922,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-12 15:56:55','',''),(2263003,'1','200','1025',468,'Retail Sale Id 1325989',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 16:02:09','',''),(2263004,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:02:09','',''),(2263083,'1','200','1025',468,'Retail Sale Id 1326025',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 16:09:00','',''),(2263084,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:09:00','',''),(2263085,'1','200','1025',468,'Retail Sale Id 1326025',2624.00,0.00,0.00,0.00,280.00,'2021-12-12 16:09:00','',''),(2263086,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 16:09:00','',''),(2263212,'1','200','1025',468,'Retail Sale Id 1326094',1968.00,0.00,0.00,0.00,210.00,'2021-12-12 16:17:22','',''),(2263213,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:17:22','',''),(2263242,'1','200','1025',468,'Retail Sale Id 1326108',2000.80,0.00,0.00,0.00,213.50,'2021-12-12 16:19:03','',''),(2263243,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-12 16:19:03','',''),(2263358,'1','200','1025',468,'Retail Sale Id 1326148',8003.20,0.00,0.00,0.00,854.00,'2021-12-12 16:25:02','',''),(2263359,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-12 16:25:02','',''),(2263530,'1','200','1025',468,'Retail Sale Id 1326229',7750.00,0.00,0.00,0.00,425.00,'2021-12-12 16:35:04','',''),(2263531,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:35:04','',''),(2263685,'1','200','1025',468,'Retail Sale Id 1326298',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 16:44:27','',''),(2263686,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:44:27','',''),(2263761,'1','200','1025',468,'Retail Sale Id 1326334',3936.00,0.00,0.00,0.00,420.00,'2021-12-12 16:48:44','',''),(2263762,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 16:48:44','',''),(2263799,'1','200','1025',468,'Retail Sale Id 1326348',1902.40,0.00,0.00,0.00,203.00,'2021-12-12 16:50:13','',''),(2263800,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-12 16:50:13','',''),(2263866,'1','200','1025',468,'Retail Sale Id 1326382',8200.00,0.00,0.00,0.00,875.00,'2021-12-12 16:54:03','',''),(2263867,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:54:03','',''),(2263909,'1','200','1025',468,'Retail Sale Id 1326405',5248.00,0.00,0.00,0.00,560.00,'2021-12-12 16:57:11','',''),(2263910,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-12 16:57:11','',''),(2264454,'1','200','1025',468,'Return of Retail Sale Id 1321255',0.00,1312.00,2.00,0.00,-140.00,'2021-12-12 17:54:40','',''),(2265488,'1','200','1025',468,'Retail Sale Id 1326861',6560.00,0.00,0.00,0.00,700.00,'2021-12-13 06:32:14','',''),(2265489,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 06:32:14','',''),(2265490,'1','200','1025',468,'Retail Sale Id 1326861',6560.00,0.00,0.00,0.00,700.00,'2021-12-13 06:32:14','',''),(2265491,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 06:32:14','',''),(2265615,'1','200','1025',468,'Retail Sale Id 1326916',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 06:44:21','',''),(2265616,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 06:44:21','',''),(2265629,'1','200','1025',468,'Retail Sale Id 1326922',3280.00,0.00,0.00,0.00,350.00,'2021-12-13 06:45:57','',''),(2265630,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 06:45:57','',''),(2265959,'1','200','1025',468,'Retail Sale Id 1327108',3798.24,0.00,0.00,0.00,405.30,'2021-12-13 07:11:27','',''),(2265960,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.79,0.00,'2021-12-13 07:11:27','',''),(2266111,'1','200','1025',468,'Retail Sale Id 1327183',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 07:21:10','',''),(2266112,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:21:10','',''),(2266145,'1','200','1025',468,'Retail Sale Id 1327208',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 07:24:14','',''),(2266146,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:24:14','',''),(2266399,'1','200','1025',468,'Retail Sale Id 1327327',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 07:40:03','',''),(2266400,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:40:03','',''),(2266433,'1','200','1025',468,'Retail Sale Id 1327342',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 07:42:18','',''),(2266434,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:42:18','',''),(2266435,'1','200','1025',468,'Retail Sale Id 1327342',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 07:42:18','',''),(2266436,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:42:18','',''),(2266437,'1','200','1025',468,'Retail Sale Id 1327342',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 07:42:18','',''),(2266438,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:42:18','',''),(2266439,'1','200','1025',468,'Retail Sale Id 1327342',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 07:42:18','',''),(2266440,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:42:18','',''),(2266466,'1','200','1025',468,'Retail Sale Id 1327359',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 07:43:51','',''),(2266467,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:43:51','',''),(2266572,'1','200','1025',468,'Retail Sale Id 1327405',2997.92,0.00,0.00,0.00,319.90,'2021-12-13 07:49:35','',''),(2266573,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-13 07:49:35','',''),(2266702,'1','200','1025',468,'Retail Sale Id 1327469',45880.00,0.00,0.00,0.00,2516.00,'2021-12-13 07:57:56','',''),(2266703,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,74.00,0.00,'2021-12-13 07:57:56','',''),(2266735,'1','200','1025',468,'Retail Sale Id 1327483',2997.92,0.00,0.00,0.00,319.90,'2021-12-13 07:59:08','',''),(2266736,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-13 07:59:08','',''),(2266829,'1','200','1025',468,'Retail Sale Id 1327522',6560.00,0.00,0.00,0.00,700.00,'2021-12-13 08:03:17','',''),(2266830,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 08:03:17','',''),(2266888,'1','200','1025',468,'Retail Sale Id 1327537',6560.00,0.00,0.00,0.00,700.00,'2021-12-13 08:05:05','',''),(2266889,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 08:05:05','',''),(2266953,'1','200','1025',468,'Retail Sale Id 1327563',7872.00,0.00,0.00,0.00,840.00,'2021-12-13 08:07:25','',''),(2266954,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 08:07:25','',''),(2267035,'1','200','1025',468,'Retail Sale Id 1327594',2000.80,0.00,0.00,0.00,213.50,'2021-12-13 08:11:38','',''),(2267036,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-13 08:11:38','',''),(2267222,'1','200','1025',468,'Retail Sale Id 1327647',2997.92,0.00,0.00,0.00,319.90,'2021-12-13 08:18:48','',''),(2267223,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-13 08:18:48','',''),(2267390,'1','200','1025',468,'Retail Sale Id 1327734',1968.00,0.00,0.00,0.00,210.00,'2021-12-13 08:29:52','',''),(2267391,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 08:29:52','',''),(2267874,'1','200','1025',468,'Retail Sale Id 1327934',997.12,0.00,0.00,0.00,106.40,'2021-12-13 08:52:42','',''),(2267875,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-13 08:52:42','',''),(2267914,'1','200','1025',468,'Retail Sale Id 1327955',6560.00,0.00,0.00,0.00,700.00,'2021-12-13 08:55:52','',''),(2267915,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 08:55:52','',''),(2268081,'1','200','1025',468,'Retail Sale Id 1328028',53940.00,0.00,0.00,0.00,2958.00,'2021-12-13 09:05:04','',''),(2268082,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,87.00,0.00,'2021-12-13 09:05:04','',''),(2268246,'1','200','1025',468,'Retail Sale Id 1328095',7872.00,0.00,0.00,0.00,840.00,'2021-12-13 09:13:05','',''),(2268247,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 09:13:05','',''),(2268306,'1','200','1025',468,'Retail Sale Id 1328128',1312.00,0.00,0.00,0.00,140.00,'2021-12-13 09:17:12','',''),(2268307,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 09:17:12','',''),(2268358,'1','200','1025',468,'Retail Sale Id 1328148',2000.80,0.00,0.00,0.00,213.50,'2021-12-13 09:20:31','',''),(2268359,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-13 09:20:31','',''),(2268410,'1','200','1025',468,'Retail Sale Id 1328176',2000.80,0.00,0.00,0.00,213.50,'2021-12-13 09:23:22','',''),(2268411,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-13 09:23:22','',''),(2268696,'1','200','1025',468,'Retail Sale Id 1328326',1502.24,0.00,0.00,0.00,160.30,'2021-12-13 09:43:10','',''),(2268697,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-13 09:43:10','',''),(2268849,'1','200','1025',468,'Retail Sale Id 1328403',3280.00,0.00,0.00,0.00,350.00,'2021-12-13 09:52:08','',''),(2268850,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 09:52:08','',''),(2269133,'1','200','1025',468,'Retail Sale Id 1328551',7872.00,0.00,0.00,0.00,840.00,'2021-12-13 10:10:29','',''),(2269134,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 10:10:29','',''),(2269217,'1','200','1025',468,'Retail Sale Id 1328602',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 10:17:28','',''),(2269218,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:17:28','',''),(2269259,'1','200','1025',468,'Retail Sale Id 1328623',1968.00,0.00,0.00,0.00,210.00,'2021-12-13 10:20:16','',''),(2269260,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:20:16','',''),(2269377,'1','200','1025',468,'Retail Sale Id 1328658',7872.00,0.00,0.00,0.00,840.00,'2021-12-13 10:29:53','',''),(2269378,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 10:29:53','',''),(2269379,'1','200','1025',468,'Retail Sale Id 1328658',7872.00,0.00,0.00,0.00,840.00,'2021-12-13 10:29:53','',''),(2269380,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 10:29:53','',''),(2269574,'1','200','1025',468,'Retail Sale Id 1328767',2624.00,0.00,0.00,0.00,280.00,'2021-12-13 10:40:28','',''),(2269575,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 10:40:28','',''),(2269624,'1','200','1025',468,'Retail Sale Id 1328792',2997.92,0.00,0.00,0.00,319.90,'2021-12-13 10:43:19','',''),(2269625,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-13 10:43:19','',''),(2269692,'1','200','1025',468,'Retail Sale Id 1328821',6560.00,0.00,0.00,0.00,700.00,'2021-12-13 10:47:20','',''),(2269693,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 10:47:20','',''),(2269748,'1','200','1025',468,'Retail Sale Id 1328855',3280.00,0.00,0.00,0.00,350.00,'2021-12-13 10:50:17','',''),(2269749,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 10:50:17','',''),(2270077,'1','200','1025',468,'Retail Sale Id 1329009',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 11:12:01','',''),(2270078,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:12:01','',''),(2270171,'1','200','1025',468,'Retail Sale Id 1329059',4592.00,0.00,0.00,0.00,490.00,'2021-12-13 11:18:44','',''),(2270172,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-13 11:18:44','',''),(2270214,'1','200','1025',468,'Retail Sale Id 1329078',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 11:21:27','',''),(2270215,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:21:27','',''),(2270362,'1','200','1025',468,'Retail Sale Id 1329143',7872.00,0.00,0.00,0.00,840.00,'2021-12-13 11:32:39','',''),(2270363,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 11:32:39','',''),(2270378,'1','200','1025',468,'Retail Sale Id 1329151',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 11:34:19','',''),(2270379,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 11:34:19','',''),(2270552,'1','200','1025',468,'Retail Sale Id 1329239',2499.36,0.00,0.00,0.00,266.70,'2021-12-13 11:49:19','',''),(2270553,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-13 11:49:19','',''),(2270592,'1','200','1025',468,'Retail Sale Id 1329260',37200.00,0.00,0.00,0.00,2040.00,'2021-12-13 11:52:50','',''),(2270593,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-13 11:52:50','',''),(2270627,'1','200','1025',468,'Retail Sale Id 1329279',1312.00,0.00,0.00,0.00,140.00,'2021-12-13 11:57:00','',''),(2270628,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 11:57:00','',''),(2270661,'1','200','1025',468,'Retail Sale Id 1329294',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 12:00:40','',''),(2270662,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 12:00:40','',''),(2270685,'1','200','1025',468,'Retail Sale Id 1329308',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 12:02:28','',''),(2270686,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 12:02:28','',''),(2271020,'1','200','1025',468,'Retail Sale Id 1329490',124000.00,0.00,0.00,0.00,6800.00,'2021-12-13 12:28:22','',''),(2271021,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-13 12:28:22','',''),(2271042,'1','200','1025',468,'Retail Sale Id 1329509',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 12:30:23','',''),(2271043,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 12:30:23','',''),(2271166,'1','200','1025',468,'Retail Sale Id 1329582',1968.00,0.00,0.00,0.00,210.00,'2021-12-13 12:39:44','',''),(2271167,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:39:44','',''),(2271180,'1','200','1025',468,'Retail Sale Id 1329591',2000.80,0.00,0.00,0.00,213.50,'2021-12-13 12:40:37','',''),(2271181,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-13 12:40:37','',''),(2271229,'1','200','1025',468,'Retail Sale Id 1329614',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 12:43:42','',''),(2271230,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 12:43:42','',''),(2271291,'1','200','1025',468,'Retail Sale Id 1329645',62000.00,0.00,0.00,0.00,3400.00,'2021-12-13 12:47:35','',''),(2271292,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 12:47:35','',''),(2271661,'1','200','1025',468,'Retail Sale Id 1329821',656.00,0.00,0.00,0.00,70.00,'2021-12-13 13:10:11','',''),(2271662,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 13:10:11','',''),(2271998,'1','200','1025',468,'Retail Sale Id 1329955',32800.00,0.00,0.00,0.00,3500.00,'2021-12-13 13:27:44','',''),(2271999,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 13:27:44','',''),(2272206,'1','200','1025',468,'Retail Sale Id 1330041',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 13:40:13','',''),(2272207,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:40:13','',''),(2272240,'1','200','1025',468,'Retail Sale Id 1330056',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 13:42:10','',''),(2272241,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:42:10','',''),(2272260,'1','200','1025',468,'Retail Sale Id 1330066',2499.36,0.00,0.00,0.00,266.70,'2021-12-13 13:43:51','',''),(2272261,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-13 13:43:51','',''),(2272388,'1','200','1025',468,'Retail Sale Id 1330112',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 13:50:20','',''),(2272389,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:50:20','',''),(2272424,'1','200','1025',468,'Retail Sale Id 1330130',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 13:52:03','',''),(2272425,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:52:03','',''),(2272634,'1','200','1025',468,'Retail Sale Id 1330227',3280.00,0.00,0.00,0.00,350.00,'2021-12-13 14:03:45','',''),(2272635,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 14:03:45','',''),(2272752,'1','200','1025',468,'Retail Sale Id 1330282',1312.00,0.00,0.00,0.00,140.00,'2021-12-13 14:11:37','',''),(2272753,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 14:11:37','',''),(2272853,'1','200','1025',468,'Retail Sale Id 1330409',3280.00,0.00,0.00,0.00,350.00,'2021-12-13 14:16:44','',''),(2272854,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 14:16:44','',''),(2272882,'1','200','1025',468,'Retail Sale Id 1330419',656.00,0.00,0.00,0.00,70.00,'2021-12-13 14:18:39','',''),(2272883,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 14:18:39','',''),(2273036,'1','200','1025',468,'Retail Sale Id 1330487',3201.28,0.00,0.00,0.00,341.60,'2021-12-13 14:28:29','',''),(2273037,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.88,0.00,'2021-12-13 14:28:29','',''),(2273201,'1','200','1025',468,'Retail Sale Id 1330552',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 14:36:37','',''),(2273202,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 14:36:37','',''),(2273306,'1','200','1025',468,'Retail Sale Id 1330596',2624.00,0.00,0.00,0.00,280.00,'2021-12-13 14:41:57','',''),(2273307,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 14:41:57','',''),(2273338,'1','200','1025',468,'Retail Sale Id 1330616',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 14:44:30','',''),(2273339,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:44:30','',''),(2273371,'1','200','1025',468,'Retail Sale Id 1330634',1312.00,0.00,0.00,0.00,140.00,'2021-12-13 14:46:27','',''),(2273372,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 14:46:27','',''),(2273383,'1','200','1025',468,'Retail Sale Id 1330643',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 14:47:49','',''),(2273384,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 14:47:49','',''),(2273519,'1','200','1025',468,'Retail Sale Id 1330712',1968.00,0.00,0.00,0.00,210.00,'2021-12-13 14:58:02','',''),(2273520,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:58:02','',''),(2273521,'1','200','1025',468,'Retail Sale Id 1330712',1968.00,0.00,0.00,0.00,210.00,'2021-12-13 14:58:02','',''),(2273522,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:58:02','',''),(2273685,'1','200','1025',468,'Retail Sale Id 1330808',7872.00,0.00,0.00,0.00,840.00,'2021-12-13 15:09:11','',''),(2273686,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 15:09:11','',''),(2273714,'1','200','1025',468,'Retail Sale Id 1330825',2997.92,0.00,0.00,0.00,319.90,'2021-12-13 15:10:52','',''),(2273715,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-13 15:10:52','',''),(2273732,'1','200','1025',468,'Retail Sale Id 1330833',3280.00,0.00,0.00,0.00,350.00,'2021-12-13 15:11:59','',''),(2273733,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 15:11:59','',''),(2273798,'1','200','1025',468,'Retail Sale Id 1330858',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 15:15:46','',''),(2273799,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:15:46','',''),(2273824,'1','200','1025',468,'Retail Sale Id 1330872',4001.60,0.00,0.00,0.00,427.00,'2021-12-13 15:18:03','',''),(2273825,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-13 15:18:03','',''),(2273974,'1','200','1025',468,'Retail Sale Id 1330934',5904.00,0.00,0.00,0.00,630.00,'2021-12-13 15:24:37','',''),(2273975,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-13 15:24:37','',''),(2274015,'1','200','1025',468,'Retail Sale Id 1330946',43710.00,0.00,0.00,0.00,2397.00,'2021-12-13 15:26:25','',''),(2274016,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,70.50,0.00,'2021-12-13 15:26:25','',''),(2274115,'1','200','1025',468,'Retail Sale Id 1330988',1312.00,0.00,0.00,0.00,140.00,'2021-12-13 15:30:10','',''),(2274116,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 15:30:10','',''),(2274117,'1','200','1025',468,'Retail Sale Id 1330988',1312.00,0.00,0.00,0.00,140.00,'2021-12-13 15:30:10','',''),(2274118,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 15:30:10','',''),(2274176,'1','200','1025',468,'Retail Sale Id 1331012',3280.00,0.00,0.00,0.00,350.00,'2021-12-13 15:32:20','',''),(2274177,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 15:32:20','',''),(2274178,'1','200','1025',468,'Retail Sale Id 1331012',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 15:32:20','',''),(2274179,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:32:20','',''),(2274218,'1','200','1025',468,'Retail Sale Id 1331034',7440.00,0.00,0.00,0.00,408.00,'2021-12-13 15:34:10','',''),(2274219,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 15:34:10','',''),(2274343,'1','200','1025',468,'Retail Sale Id 1331090',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 15:39:18','',''),(2274344,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 15:39:18','',''),(2274393,'1','200','1025',468,'Retail Sale Id 1331116',6.56,0.00,0.00,0.00,0.70,'2021-12-13 15:41:36','',''),(2274394,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,0.01,0.00,'2021-12-13 15:41:36','',''),(2274469,'1','200','1025',468,'Retail Sale Id 1331157',5248.00,0.00,0.00,0.00,560.00,'2021-12-13 15:44:57','',''),(2274470,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-13 15:44:57','',''),(2274501,'1','200','1025',468,'Retail Sale Id 1331170',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 15:46:37','',''),(2274502,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 15:46:37','',''),(2274623,'1','200','1025',468,'Retail Sale Id 1331241',3280.00,0.00,0.00,0.00,350.00,'2021-12-13 15:53:14','',''),(2274624,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 15:53:14','',''),(2274692,'1','200','1025',468,'Retail Sale Id 1331270',34100.00,0.00,0.00,0.00,1870.00,'2021-12-13 15:57:10','',''),(2274693,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-13 15:57:10','',''),(2274777,'1','200','1025',468,'Retail Sale Id 1331322',34100.00,0.00,0.00,0.00,1870.00,'2021-12-13 16:02:05','',''),(2274778,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-13 16:02:05','',''),(2274951,'1','200','1025',468,'Retail Sale Id 1331407',17980.00,0.00,0.00,0.00,986.00,'2021-12-13 16:11:52','',''),(2274952,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,29.00,0.00,'2021-12-13 16:11:52','',''),(2275097,'1','200','1025',468,'Retail Sale Id 1331480',3280.00,0.00,0.00,0.00,350.00,'2021-12-13 16:19:13','',''),(2275098,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:19:13','',''),(2275131,'1','200','1025',468,'Retail Sale Id 1331497',2624.00,0.00,0.00,0.00,280.00,'2021-12-13 16:20:45','',''),(2275132,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 16:20:45','',''),(2275133,'1','200','1025',468,'Retail Sale Id 1331497',2624.00,0.00,0.00,0.00,280.00,'2021-12-13 16:20:45','',''),(2275134,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 16:20:45','',''),(2275135,'1','200','1025',468,'Retail Sale Id 1331497',3280.00,0.00,0.00,0.00,350.00,'2021-12-13 16:20:45','',''),(2275136,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 16:20:45','',''),(2275165,'1','200','1025',468,'Retail Sale Id 1331511',1502.24,0.00,0.00,0.00,160.30,'2021-12-13 16:22:19','',''),(2275166,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-13 16:22:19','',''),(2275313,'1','200','1025',468,'Retail Sale Id 1331588',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 16:30:29','',''),(2275314,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:30:29','',''),(2275346,'1','200','1025',468,'Retail Sale Id 1331600',1312.00,0.00,0.00,0.00,140.00,'2021-12-13 16:32:15','',''),(2275347,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 16:32:15','',''),(2275393,'1','200','1025',468,'Retail Sale Id 1331629',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 16:34:41','',''),(2275394,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:34:41','',''),(2275423,'1','200','1025',468,'Retail Sale Id 1331645',62620.00,0.00,0.00,0.00,3434.00,'2021-12-13 16:36:11','',''),(2275424,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,101.00,0.00,'2021-12-13 16:36:11','',''),(2275449,'1','200','1025',468,'Retail Sale Id 1331660',12400.00,0.00,0.00,0.00,680.00,'2021-12-13 16:38:04','',''),(2275450,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-13 16:38:04','',''),(2275552,'1','200','1025',468,'Retail Sale Id 1331716',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 16:44:12','',''),(2275553,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:44:12','',''),(2275617,'1','200','1025',468,'Retail Sale Id 1331751',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 16:50:05','',''),(2275618,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:50:05','',''),(2275632,'1','200','1025',468,'Retail Sale Id 1331760',3936.00,0.00,0.00,0.00,420.00,'2021-12-13 16:51:07','',''),(2275633,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:51:07','',''),(2275658,'1','200','1025',468,'Retail Sale Id 1331769',8200.00,0.00,0.00,0.00,875.00,'2021-12-13 16:52:31','',''),(2275659,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:52:31','',''),(2276299,'1','200','1025',468,'Retail Sale Id 1332050',15481.60,0.00,0.00,0.00,1652.00,'2021-12-13 18:08:50','',''),(2276300,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,23.60,0.00,'2021-12-13 18:08:50','',''),(2276985,'1','200','1025',468,'Retail Sale Id 1332138',1264.00,0.00,0.00,0.00,92.00,'2021-12-14 06:08:44','',''),(2276986,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 06:08:44','',''),(2277061,'1','200','1025',468,'Retail Sale Id 1332171',3792.00,0.00,0.00,0.00,276.00,'2021-12-14 06:16:41','',''),(2277062,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 06:16:41','',''),(2277140,'1','200','1025',468,'Retail Sale Id 1332205',3792.00,0.00,0.00,0.00,276.00,'2021-12-14 06:23:36','',''),(2277141,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 06:23:36','',''),(2277510,'1','200','1025',468,'Retail Sale Id 1332334',3950.00,0.00,0.00,0.00,287.50,'2021-12-14 06:44:40','',''),(2277511,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-14 06:44:40','',''),(2277678,'1','200','1025',468,'Retail Sale Id 1332419',3501.28,0.00,0.00,0.00,254.84,'2021-12-14 06:54:19','',''),(2277679,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-14 06:54:19','',''),(2277776,'1','200','1025',468,'Retail Sale Id 1332468',7900.00,0.00,0.00,0.00,575.00,'2021-12-14 07:03:14','',''),(2277777,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 07:03:14','',''),(2277889,'1','200','1025',468,'Retail Sale Id 1332527',7900.00,0.00,0.00,0.00,575.00,'2021-12-14 07:11:38','',''),(2277890,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 07:11:38','',''),(2277940,'1','200','1025',468,'Retail Sale Id 1332560',12640.00,0.00,0.00,0.00,920.00,'2021-12-14 07:14:26','',''),(2277941,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-14 07:14:26','',''),(2277968,'1','200','1025',468,'Retail Sale Id 1332573',1997.12,0.00,0.00,0.00,145.36,'2021-12-14 07:16:22','',''),(2277969,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-14 07:16:22','',''),(2278303,'1','200','1025',468,'Retail Sale Id 1332739',1896.00,0.00,0.00,0.00,138.00,'2021-12-14 07:36:42','',''),(2278304,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:36:42','',''),(2278412,'1','200','1025',468,'Retail Sale Id 1332799',1264.00,0.00,0.00,0.00,92.00,'2021-12-14 07:42:01','',''),(2278413,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 07:42:01','',''),(2278468,'1','200','1025',468,'Retail Sale Id 1332904',7900.00,0.00,0.00,0.00,575.00,'2021-12-14 07:46:54','',''),(2278469,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 07:46:54','',''),(2278516,'1','200','1025',468,'Retail Sale Id 1332962',3792.00,0.00,0.00,0.00,276.00,'2021-12-14 07:49:38','',''),(2278517,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 07:49:38','',''),(2279013,'1','200','1025',468,'Retail Sale Id 1333191',7584.00,0.00,0.00,0.00,552.00,'2021-12-14 08:14:36','',''),(2279014,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-14 08:14:36','',''),(2279097,'1','200','1025',468,'Retail Sale Id 1333267',3002.00,0.00,0.00,0.00,218.50,'2021-12-14 08:19:22','',''),(2279098,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-14 08:19:22','',''),(2279129,'1','200','1025',468,'Retail Sale Id 1333281',1896.00,0.00,0.00,0.00,138.00,'2021-12-14 08:21:16','',''),(2279130,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:21:16','',''),(2279195,'1','200','1025',468,'Retail Sale Id 1333317',3792.00,0.00,0.00,0.00,276.00,'2021-12-14 08:26:14','',''),(2279196,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 08:26:14','',''),(2279291,'1','200','1025',468,'Retail Sale Id 1333369',3160.00,0.00,0.00,0.00,230.00,'2021-12-14 08:31:21','',''),(2279292,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 08:31:21','',''),(2279325,'1','200','1025',468,'Retail Sale Id 1333385',9000.00,0.00,0.00,0.00,210.00,'2021-12-14 08:33:27','',''),(2279326,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-14 08:33:27','',''),(2279621,'1','200','1025',468,'Retail Sale Id 1333548',7584.00,0.00,0.00,0.00,552.00,'2021-12-14 08:48:30','',''),(2279622,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-14 08:48:30','',''),(2279649,'1','200','1025',468,'Retail Sale Id 1333563',7900.00,0.00,0.00,0.00,575.00,'2021-12-14 08:50:38','',''),(2279650,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 08:50:38','',''),(2279991,'1','200','1025',468,'Retail Sale Id 1333680',998.56,0.00,0.00,0.00,72.68,'2021-12-14 09:04:35','',''),(2279992,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-14 09:04:35','',''),(2279993,'1','200','1025',468,'Retail Sale Id 1333680',1301.92,0.00,0.00,0.00,94.76,'2021-12-14 09:04:35','',''),(2279994,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-14 09:04:35','',''),(2280053,'1','200','1025',468,'Retail Sale Id 1333726',3792.00,0.00,0.00,0.00,276.00,'2021-12-14 09:07:43','',''),(2280054,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 09:07:43','',''),(2280391,'1','200','1025',468,'Retail Sale Id 1333855',1896.00,0.00,0.00,0.00,138.00,'2021-12-14 09:22:58','',''),(2280392,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:22:58','',''),(2280454,'1','200','1025',468,'Retail Sale Id 1333882',3792.00,0.00,0.00,0.00,276.00,'2021-12-14 09:25:51','',''),(2280455,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 09:25:51','',''),(2280522,'1','200','1025',468,'Retail Sale Id 1333918',7900.00,0.00,0.00,0.00,575.00,'2021-12-14 09:29:50','',''),(2280523,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 09:29:50','',''),(2280572,'1','200','1025',468,'Retail Sale Id 1333945',1264.00,0.00,0.00,0.00,92.00,'2021-12-14 09:32:38','',''),(2280573,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 09:32:38','',''),(2280630,'1','200','1025',468,'Retail Sale Id 1333978',7900.00,0.00,0.00,0.00,575.00,'2021-12-14 09:35:34','',''),(2280631,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 09:35:34','',''),(2280654,'1','200','1025',468,'Retail Sale Id 1333990',90000.00,0.00,0.00,0.00,2100.00,'2021-12-14 09:37:49','',''),(2280655,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-14 09:37:49','',''),(2280848,'1','200','1025',468,'Retail Sale Id 1334078',1896.00,0.00,0.00,0.00,138.00,'2021-12-14 09:48:58','',''),(2280849,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:48:58','',''),(2281098,'1','200','1025',468,'Retail Sale Id 1334215',1497.84,0.00,0.00,0.00,109.02,'2021-12-14 10:04:16','',''),(2281099,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-14 10:04:16','',''),(2281115,'1','200','1025',468,'Retail Sale Id 1334224',3792.00,0.00,0.00,0.00,276.00,'2021-12-14 10:05:40','',''),(2281116,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:05:40','',''),(2281404,'1','200','1025',468,'Retail Sale Id 1334358',998.56,0.00,0.00,0.00,72.68,'2021-12-14 10:19:24','',''),(2281405,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-14 10:19:24','',''),(2281521,'1','200','1025',468,'Retail Sale Id 1334416',3160.00,0.00,0.00,0.00,230.00,'2021-12-14 10:24:23','',''),(2281522,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:24:23','',''),(2281630,'1','200','1025',468,'Retail Sale Id 1334526',1264.00,0.00,0.00,0.00,92.00,'2021-12-14 10:31:21','',''),(2281631,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 10:31:21','',''),(2281820,'1','200','1025',468,'Retail Sale Id 1334629',72000.00,0.00,0.00,0.00,1680.00,'2021-12-14 10:41:15','',''),(2281821,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-14 10:41:15','',''),(2281969,'1','200','1025',468,'Retail Sale Id 1334704',5056.00,0.00,0.00,0.00,368.00,'2021-12-14 10:49:44','',''),(2281970,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-14 10:49:44','',''),(2282076,'1','200','1025',468,'Retail Sale Id 1334764',1997.12,0.00,0.00,0.00,145.36,'2021-12-14 10:56:19','',''),(2282077,'1','200','1025',468,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-14 10:56:19','',''),(2282522,'1','200','1025',468,'Retail Sale Id 1335415',0.00,0.00,0.00,0.00,0.00,'2021-12-14 12:35:25','',''),(2282528,'1','200','1025',468,'Retail Sale Id 1335423',3792.00,0.00,0.00,6.00,276.00,'2021-12-14 12:36:04','',''),(2282550,'1','200','1025',468,'Retail Sale Id 1335434',7900.00,0.00,0.00,12.50,575.00,'2021-12-14 12:37:17','',''),(2282581,'1','200','1025',468,'Retail Sale Id 1335462',2528.00,0.00,0.00,4.00,184.00,'2021-12-14 12:41:44','',''),(2282646,'1','200','1025',468,'Retail Sale Id 1335512',22800.00,0.00,0.00,38.00,532.00,'2021-12-14 12:48:52','',''),(2282729,'1','200','1025',468,'Retail Sale Id 1335573',1896.00,0.00,0.00,3.00,138.00,'2021-12-14 12:58:32','',''),(2282739,'1','200','1025',468,'Retail Sale Id 1335584',6952.00,0.00,0.00,11.00,506.00,'2021-12-14 13:00:05','',''),(2282785,'1','200','1025',468,'Retail Sale Id 1335637',99000.00,0.00,0.00,165.00,2310.00,'2021-12-14 13:06:41','',''),(2282805,'1','200','1025',468,'Retail Sale Id 1335643',7584.00,0.00,0.00,12.00,552.00,'2021-12-14 13:08:12','',''),(2282867,'1','200','1025',468,'Retail Sale Id 1335712',7900.00,0.00,0.00,12.50,575.00,'2021-12-14 13:18:09','',''),(2282979,'1','200','1025',468,'Retail Sale Id 1335793',1264.00,0.00,0.00,2.00,92.00,'2021-12-14 13:30:55','',''),(2283000,'1','200','1025',468,'Retail Sale Id 1335808',1896.00,0.00,0.00,3.00,138.00,'2021-12-14 13:33:23','',''),(2283077,'1','200','1025',468,'Retail Sale Id 1335856',3792.00,0.00,0.00,6.00,276.00,'2021-12-14 13:40:51','',''),(2283182,'1','200','1025',468,'Retail Sale Id 1335935',7584.00,0.00,0.00,12.00,552.00,'2021-12-14 13:54:21','',''),(2283236,'1','200','1025',468,'Retail Sale Id 1335953',3160.00,0.00,0.00,5.00,230.00,'2021-12-14 13:57:20','',''),(2283243,'1','200','1025',468,'Retail Sale Id 1335957',7900.00,0.00,0.00,12.50,575.00,'2021-12-14 13:58:21','',''),(2283271,'1','200','1025',468,'Retail Sale Id 1335982',210000.00,0.00,0.00,350.00,4900.00,'2021-12-14 14:02:07','',''),(2283340,'1','200','1025',468,'Retail Sale Id 1336024',1997.12,0.00,0.00,3.16,145.36,'2021-12-14 14:07:17','',''),(2283373,'1','200','1025',468,'Retail Sale Id 1336037',1896.00,0.00,0.00,3.00,138.00,'2021-12-14 14:08:56','',''),(2283494,'1','200','1025',468,'Retail Sale Id 1336147',17400.00,0.00,0.00,29.00,406.00,'2021-12-14 14:24:35','',''),(2283611,'1','200','1025',468,'Retail Sale Id 1336219',3792.00,0.00,0.00,6.00,276.00,'2021-12-14 14:34:50','',''),(2283617,'1','200','1025',468,'Retail Sale Id 1336228',4999.12,0.00,0.00,7.91,363.86,'2021-12-14 14:36:09','',''),(2283629,'1','200','1025',468,'Retail Sale Id 1336239',7900.00,0.00,0.00,12.50,575.00,'2021-12-14 14:37:41','',''),(2283644,'1','200','1025',468,'Retail Sale Id 1336250',2528.00,0.00,0.00,4.00,184.00,'2021-12-14 14:39:35','',''),(2283690,'1','200','1025',468,'Retail Sale Id 1336284',632.00,0.00,0.00,1.00,46.00,'2021-12-14 14:44:51','',''),(2283756,'1','200','1025',468,'Retail Sale Id 1336321',3792.00,0.00,0.00,6.00,276.00,'2021-12-14 14:51:22','',''),(2283773,'1','200','1025',468,'Retail Sale Id 1336344',2528.00,0.00,0.00,4.00,184.00,'2021-12-14 14:54:25','',''),(2283830,'1','200','1025',468,'Retail Sale Id 1336389',3792.00,0.00,0.00,6.00,276.00,'2021-12-14 15:02:40','',''),(2283892,'1','200','1025',468,'Retail Sale Id 1336454',3792.00,0.00,0.00,6.00,276.00,'2021-12-14 15:14:13','',''),(2283922,'1','200','1025',468,'Retail Sale Id 1336480',3160.00,0.00,0.00,5.00,230.00,'2021-12-14 15:19:18','',''),(2283934,'1','200','1025',468,'Retail Sale Id 1336496',2528.00,0.00,0.00,4.00,184.00,'2021-12-14 15:21:14','',''),(2283942,'1','200','1025',468,'Retail Sale Id 1336506',1896.00,0.00,0.00,3.00,138.00,'2021-12-14 15:23:09','',''),(2284002,'1','200','1025',468,'Retail Sale Id 1336529',1264.00,0.00,0.00,2.00,92.00,'2021-12-14 15:27:12','',''),(2284019,'1','200','1025',468,'Retail Sale Id 1336546',1896.00,0.00,0.00,3.00,138.00,'2021-12-14 15:28:58','',''),(2284031,'1','200','1025',468,'Retail Sale Id 1336557',3792.00,0.00,0.00,6.00,276.00,'2021-12-14 15:30:25','',''),(2284310,'1','200','1025',468,'Retail Sale Id 1336730',1896.00,0.00,0.00,3.00,138.00,'2021-12-14 15:53:04','',''),(2284341,'1','200','1025',468,'Retail Sale Id 1336758',1896.00,0.00,0.00,3.00,138.00,'2021-12-14 15:57:20','',''),(2284410,'1','200','1025',468,'Retail Sale Id 1336798',1896.00,0.00,0.00,3.00,138.00,'2021-12-14 16:02:16','',''),(2284431,'1','200','1025',468,'Retail Sale Id 1336821',3002.00,0.00,0.00,4.75,218.50,'2021-12-14 16:04:15','',''),(2284446,'1','200','1025',468,'Retail Sale Id 1336838',3792.00,0.00,0.00,6.00,276.00,'2021-12-14 16:06:06','',''),(2284468,'1','200','1025',468,'Retail Sale Id 1336859',7900.00,0.00,0.00,12.50,575.00,'2021-12-14 16:07:50','',''),(2284480,'1','200','1025',468,'Retail Sale Id 1336871',3160.00,0.00,0.00,5.00,230.00,'2021-12-14 16:09:13','',''),(2284486,'1','200','1025',468,'Retail Sale Id 1336881',3160.00,0.00,0.00,5.00,230.00,'2021-12-14 16:10:37','',''),(2284574,'1','200','1025',468,'Retail Sale Id 1336969',1896.00,0.00,0.00,3.00,138.00,'2021-12-14 16:21:44','',''),(2284595,'1','200','1025',468,'Retail Sale Id 1336989',102000.00,0.00,0.00,170.00,2380.00,'2021-12-14 16:23:45','',''),(2284621,'1','200','1025',468,'Retail Sale Id 1337002',998.56,0.00,0.00,1.58,72.68,'2021-12-14 16:24:55','',''),(2284647,'1','200','1025',468,'Retail Sale Id 1337026',998.56,0.00,0.00,1.58,72.68,'2021-12-14 16:26:43','',''),(2284663,'1','200','1025',468,'Retail Sale Id 1337040',7900.00,0.00,0.00,12.50,575.00,'2021-12-14 16:28:08','',''),(2284694,'1','200','1025',468,'Retail Sale Id 1337059',10112.00,0.00,0.00,16.00,736.00,'2021-12-14 16:29:28','',''),(2284713,'1','200','1025',468,'Retail Sale Id 1337078',2528.00,0.00,0.00,4.00,184.00,'2021-12-14 16:31:01','',''),(2284875,'1','200','1025',468,'Retail Sale Id 1337191',31600.00,0.00,0.00,50.00,2300.00,'2021-12-14 16:43:24','',''),(2285016,'1','200','1025',468,'Retail Sale Id 1337296',2528.00,0.00,0.00,4.00,184.00,'2021-12-14 16:58:00','',''),(2285033,'1','200','1025',468,'Retail Sale Id 1337313',7900.00,0.00,0.00,12.50,575.00,'2021-12-14 17:00:22','',''),(2285050,'1','200','1025',468,'Retail Sale Id 1337327',7900.00,0.00,0.00,12.50,575.00,'2021-12-14 17:02:16','',''),(2285088,'1','200','1025',468,'Retail Sale Id 1337370',7900.00,0.00,0.00,12.50,575.00,'2021-12-14 17:06:52','',''),(2285100,'1','200','1025',468,'Retail Sale Id 1337381',1896.00,0.00,0.00,3.00,138.00,'2021-12-14 17:08:20','',''),(2285114,'1','200','1025',468,'Retail Sale Id 1337398',5056.00,0.00,0.00,8.00,368.00,'2021-12-14 17:09:55','',''),(2285306,'1','200','1025',468,'Retail Sale Id 1337572',33000.00,0.00,0.00,55.00,770.00,'2021-12-14 18:09:46','',''),(2285310,'1','200','1025',468,'Retail Sale Id 1337576',26537.68,0.00,0.00,41.99,1931.54,'2021-12-14 18:11:53','',''),(2285313,'1','200','1025',468,'Retail Sale Id 1337580',632.00,0.00,0.00,1.00,46.00,'2021-12-14 18:14:38','',''),(2286096,'1','200','1025',468,'Retail Sale Id 1337795',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 06:32:19','',''),(2286218,'1','200','1025',468,'Retail Sale Id 1337881',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 06:45:53','',''),(2286219,'1','200','1025',468,'Retail Sale Id 1337881',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 06:45:53','',''),(2286220,'1','200','1025',468,'Retail Sale Id 1337881',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 06:45:53','',''),(2286237,'1','200','1025',468,'Retail Sale Id 1337900',998.56,0.00,0.00,1.58,72.68,'2021-12-15 06:48:55','',''),(2286248,'1','200','1025',468,'Retail Sale Id 1337917',6320.00,0.00,0.00,10.00,460.00,'2021-12-15 06:50:50','',''),(2286506,'1','200','1025',468,'Retail Sale Id 1338176',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 07:23:29','',''),(2286712,'1','200','1025',468,'Retail Sale Id 1338356',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 07:44:54','',''),(2286765,'1','200','1025',468,'Retail Sale Id 1338391',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 07:49:30','',''),(2286818,'1','200','1025',468,'Retail Sale Id 1338412',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 07:51:35','',''),(2286850,'1','200','1025',468,'Retail Sale Id 1338447',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 07:57:09','',''),(2287010,'1','200','1025',468,'Retail Sale Id 1338545',4424.00,0.00,0.00,7.00,322.00,'2021-12-15 08:08:38','',''),(2287035,'1','200','1025',468,'Retail Sale Id 1338569',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 08:11:38','',''),(2287061,'1','200','1025',468,'Retail Sale Id 1338587',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 08:13:57','',''),(2287103,'1','200','1025',468,'Retail Sale Id 1338628',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 08:18:18','',''),(2287198,'1','200','1025',468,'Retail Sale Id 1338711',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 08:28:00','',''),(2287398,'1','200','1025',468,'Retail Sale Id 1338879',2528.00,0.00,0.00,4.00,184.00,'2021-12-15 08:48:30','',''),(2287445,'1','200','1025',468,'Retail Sale Id 1338928',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 08:54:22','',''),(2287473,'1','200','1025',468,'Retail Sale Id 1338954',998.56,0.00,0.00,1.58,72.68,'2021-12-15 08:59:01','',''),(2287490,'1','200','1025',468,'Retail Sale Id 1338965',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 09:00:49','',''),(2287604,'1','200','1025',468,'Retail Sale Id 1339034',5056.00,0.00,0.00,8.00,368.00,'2021-12-15 09:10:58','',''),(2287692,'1','200','1025',468,'Retail Sale Id 1339110',6900.00,0.00,0.00,11.50,161.00,'2021-12-15 09:21:12','',''),(2287873,'1','200','1025',468,'Retail Sale Id 1339277',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 09:42:39','',''),(2287942,'1','200','1025',468,'Retail Sale Id 1339333',9480.00,0.00,0.00,15.00,690.00,'2021-12-15 09:49:45','',''),(2287959,'1','200','1025',468,'Retail Sale Id 1339347',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 09:52:25','',''),(2288012,'1','200','1025',468,'Retail Sale Id 1339357',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 09:57:36','',''),(2288013,'1','200','1025',468,'Retail Sale Id 1339357',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 09:57:36','',''),(2288042,'1','200','1025',468,'Retail Sale Id 1339408',33000.00,0.00,0.00,55.00,770.00,'2021-12-15 10:01:43','',''),(2288045,'1','200','1025',468,'Retail Sale Id 1339413',1497.84,0.00,0.00,2.37,109.02,'2021-12-15 10:02:58','',''),(2288082,'1','200','1025',468,'Retail Sale Id 1339448',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 10:08:02','',''),(2288109,'1','200','1025',468,'Retail Sale Id 1339462',499.28,0.00,0.00,0.79,36.34,'2021-12-15 10:09:54','',''),(2288115,'1','200','1025',468,'Retail Sale Id 1339469',102000.00,0.00,0.00,170.00,2380.00,'2021-12-15 10:11:05','',''),(2288166,'1','200','1025',468,'Retail Sale Id 1339506',3002.00,0.00,0.00,4.75,218.50,'2021-12-15 10:16:47','',''),(2288195,'1','200','1025',468,'Retail Sale Id 1339534',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 10:21:40','',''),(2288198,'1','200','1025',468,'Retail Sale Id 1339536',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 10:22:44','',''),(2288226,'1','200','1025',468,'Retail Sale Id 1339562',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 10:27:24','',''),(2288237,'1','200','1025',468,'Retail Sale Id 1339574',6952.00,0.00,0.00,11.00,506.00,'2021-12-15 10:29:31','',''),(2288257,'1','200','1025',468,'Retail Sale Id 1339596',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 10:33:14','',''),(2288263,'1','200','1025',468,'Retail Sale Id 1339603',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 10:34:15','',''),(2288287,'1','200','1025',468,'Retail Sale Id 1339619',1997.12,0.00,0.00,3.16,145.36,'2021-12-15 10:37:08','',''),(2288346,'1','200','1025',468,'Retail Sale Id 1339666',998.56,0.00,0.00,1.58,72.68,'2021-12-15 10:45:04','',''),(2288347,'1','200','1025',468,'Retail Sale Id 1339666',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 10:45:04','',''),(2288358,'1','200','1025',468,'Retail Sale Id 1339677',1264.00,0.00,0.00,2.00,92.00,'2021-12-15 10:46:02','',''),(2288385,'1','200','1025',468,'Retail Sale Id 1339696',27000.00,0.00,0.00,45.00,630.00,'2021-12-15 10:49:28','',''),(2288397,'1','200','1025',468,'Retail Sale Id 1339707',9000.00,0.00,0.00,15.00,210.00,'2021-12-15 10:50:57','',''),(2288473,'1','200','1025',468,'Retail Sale Id 1339772',1264.00,0.00,0.00,2.00,92.00,'2021-12-15 10:58:09','',''),(2288504,'1','200','1025',468,'Retail Sale Id 1339803',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 11:02:15','',''),(2288523,'1','200','1025',468,'Retail Sale Id 1339815',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 11:04:09','',''),(2288689,'1','200','1025',468,'Retail Sale Id 1339943',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 11:22:21','',''),(2288690,'1','200','1025',468,'Retail Sale Id 1339943',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 11:22:21','',''),(2288731,'1','200','1025',468,'Retail Sale Id 1339988',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 11:25:11','',''),(2288740,'1','200','1025',468,'Retail Sale Id 1339999',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 11:26:52','',''),(2288751,'1','200','1025',468,'Retail Sale Id 1340007',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 11:28:24','',''),(2288776,'1','200','1025',468,'Retail Sale Id 1340025',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 11:31:55','',''),(2288777,'1','200','1025',468,'Retail Sale Id 1340025',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 11:31:55','',''),(2288792,'1','200','1025',468,'Retail Sale Id 1340042',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 11:33:40','',''),(2288851,'1','200','1025',468,'Retail Sale Id 1340105',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 11:41:43','',''),(2288862,'1','200','1025',468,'Retail Sale Id 1340118',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 11:43:45','',''),(2288890,'1','200','1025',468,'Retail Sale Id 1340146',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 11:48:08','',''),(2288959,'1','200','1025',468,'Retail Sale Id 1340220',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 11:55:23','',''),(2288988,'1','200','1025',468,'Retail Sale Id 1340249',13500.00,0.00,0.00,22.50,315.00,'2021-12-15 11:59:22','',''),(2288998,'1','200','1025',468,'Retail Sale Id 1340260',1997.12,0.00,0.00,3.16,145.36,'2021-12-15 12:01:51','',''),(2289015,'1','200','1025',468,'Retail Sale Id 1340278',30000.00,0.00,0.00,50.00,700.00,'2021-12-15 12:05:03','',''),(2289027,'1','200','1025',468,'Retail Sale Id 1340288',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 12:06:20','',''),(2289108,'1','200','1025',468,'Retail Sale Id 1340367',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 12:17:40','',''),(2289122,'1','200','1025',468,'Retail Sale Id 1340380',1997.12,0.00,0.00,3.16,145.36,'2021-12-15 12:19:36','',''),(2289147,'1','200','1025',468,'Retail Sale Id 1340408',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 12:23:05','',''),(2289195,'1','200','1025',468,'Retail Sale Id 1340454',802.64,0.00,0.00,1.27,58.42,'2021-12-15 12:29:05','',''),(2289308,'1','200','1025',468,'Retail Sale Id 1340561',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 12:45:38','',''),(2289349,'1','200','1025',468,'Retail Sale Id 1340599',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 12:53:01','',''),(2289355,'1','200','1025',468,'Retail Sale Id 1340606',30000.00,0.00,0.00,50.00,700.00,'2021-12-15 12:55:18','',''),(2289370,'1','200','1025',468,'Retail Sale Id 1340616',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 12:57:56','',''),(2289405,'1','200','1025',468,'Retail Sale Id 1340651',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 13:02:44','',''),(2289420,'1','200','1025',468,'Retail Sale Id 1340665',30000.00,0.00,0.00,50.00,700.00,'2021-12-15 13:05:29','',''),(2289427,'1','200','1025',468,'Retail Sale Id 1340674',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 13:06:45','',''),(2289587,'1','200','1025',468,'Retail Sale Id 1340761',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 13:20:48','',''),(2289588,'1','200','1025',468,'Retail Sale Id 1340761',15800.00,0.00,0.00,25.00,1150.00,'2021-12-15 13:20:48','',''),(2289888,'1','200','1025',468,'Retail Sale Id 1340997',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 13:55:27','',''),(2289889,'1','200','1025',468,'Retail Sale Id 1340997',6320.00,0.00,0.00,10.00,460.00,'2021-12-15 13:55:27','',''),(2290069,'1','200','1025',468,'Retail Sale Id 1341099',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 14:07:10','',''),(2290095,'1','200','1025',468,'Retail Sale Id 1341110',897.44,0.00,0.00,1.42,65.32,'2021-12-15 14:08:51','',''),(2290112,'1','200','1025',468,'Retail Sale Id 1341128',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 14:10:47','',''),(2290175,'1','200','1025',468,'Retail Sale Id 1341148',1264.00,0.00,0.00,2.00,92.00,'2021-12-15 14:13:30','',''),(2290333,'1','200','1025',468,'Retail Sale Id 1341294',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 14:31:21','',''),(2290423,'1','200','1025',468,'Retail Sale Id 1341373',18000.00,0.00,0.00,30.00,420.00,'2021-12-15 14:41:58','',''),(2290458,'1','200','1025',468,'Retail Sale Id 1341401',16800.00,0.00,0.00,28.00,392.00,'2021-12-15 14:45:38','',''),(2290493,'1','200','1025',468,'Retail Sale Id 1341420',1997.12,0.00,0.00,3.16,145.36,'2021-12-15 14:48:05','',''),(2290541,'1','200','1025',468,'Retail Sale Id 1341453',1264.00,0.00,0.00,2.00,92.00,'2021-12-15 14:51:50','',''),(2290572,'1','200','1025',468,'Retail Sale Id 1341479',165000.00,0.00,0.00,275.00,3850.00,'2021-12-15 14:54:53','',''),(2290639,'1','200','1025',468,'Retail Sale Id 1341531',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 14:59:56','',''),(2290719,'1','200','1025',468,'Retail Sale Id 1341599',99000.00,0.00,0.00,165.00,2310.00,'2021-12-15 15:07:05','',''),(2290750,'1','200','1025',468,'Retail Sale Id 1341612',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 15:08:49','',''),(2290882,'1','200','1025',468,'Retail Sale Id 1341706',6320.00,0.00,0.00,10.00,460.00,'2021-12-15 15:20:23','',''),(2290904,'1','200','1025',468,'Retail Sale Id 1341729',1264.00,0.00,0.00,2.00,92.00,'2021-12-15 15:22:19','',''),(2290968,'1','200','1025',468,'Retail Sale Id 1341752',1497.84,0.00,0.00,2.37,109.02,'2021-12-15 15:24:28','',''),(2291057,'1','200','1025',468,'Retail Sale Id 1341798',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 15:30:10','',''),(2291074,'1','200','1025',468,'Retail Sale Id 1341816',1264.00,0.00,0.00,2.00,92.00,'2021-12-15 15:31:52','',''),(2291092,'1','200','1025',468,'Retail Sale Id 1341832',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 15:33:28','',''),(2291126,'1','200','1025',468,'Retail Sale Id 1341866',5688.00,0.00,0.00,9.00,414.00,'2021-12-15 15:36:59','',''),(2291222,'1','200','1025',468,'Retail Sale Id 1341950',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 15:45:56','',''),(2291231,'1','200','1025',468,'Retail Sale Id 1341959',1997.12,0.00,0.00,3.16,145.36,'2021-12-15 15:47:02','',''),(2291241,'1','200','1025',468,'Retail Sale Id 1341970',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 15:48:21','',''),(2291252,'1','200','1025',468,'Retail Sale Id 1341980',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 15:49:26','',''),(2291273,'1','200','1025',468,'Retail Sale Id 1342001',6320.00,0.00,0.00,10.00,460.00,'2021-12-15 15:51:20','',''),(2291324,'1','200','1025',468,'Retail Sale Id 1342043',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 15:55:36','',''),(2291352,'1','200','1025',468,'Retail Sale Id 1342055',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 15:56:50','',''),(2291400,'1','200','1025',468,'Retail Sale Id 1342092',600.40,0.00,0.00,0.95,43.70,'2021-12-15 16:00:10','',''),(2291478,'1','200','1025',468,'Retail Sale Id 1342178',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 16:08:59','',''),(2291596,'1','200','1025',468,'Retail Sale Id 1342279',1264.00,0.00,0.00,2.00,92.00,'2021-12-15 16:18:48','',''),(2291631,'1','200','1025',468,'Retail Sale Id 1342313',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 16:22:09','',''),(2291649,'1','200','1025',468,'Retail Sale Id 1342331',2528.00,0.00,0.00,4.00,184.00,'2021-12-15 16:24:09','',''),(2291668,'1','200','1025',468,'Retail Sale Id 1342353',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 16:26:05','',''),(2291699,'1','200','1025',468,'Retail Sale Id 1342380',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 16:29:06','',''),(2291700,'1','200','1025',468,'Retail Sale Id 1342380',7900.00,0.00,0.00,12.50,575.00,'2021-12-15 16:29:06','',''),(2291732,'1','200','1025',468,'Retail Sale Id 1342417',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 16:32:07','',''),(2291897,'1','200','1025',468,'Retail Sale Id 1342544',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 16:45:21','',''),(2291924,'1','200','1025',468,'Retail Sale Id 1342568',1896.00,0.00,0.00,3.00,138.00,'2021-12-15 16:47:07','',''),(2292011,'1','200','1025',468,'Retail Sale Id 1342661',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 16:56:51','',''),(2292012,'1','200','1025',468,'Retail Sale Id 1342661',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 16:56:51','',''),(2292025,'1','200','1025',468,'Retail Sale Id 1342677',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 16:58:07','',''),(2292040,'1','200','1025',468,'Retail Sale Id 1342685',4999.12,0.00,0.00,7.91,363.86,'2021-12-15 16:59:04','',''),(2292091,'1','200','1025',468,'Retail Sale Id 1342723',3160.00,0.00,0.00,5.00,230.00,'2021-12-15 17:04:47','',''),(2292124,'1','200','1025',468,'Retail Sale Id 1342756',3792.00,0.00,0.00,6.00,276.00,'2021-12-15 17:08:20','',''),(2293107,'1','200','1025',468,'Retail Sale Id 1343297',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 06:21:46','',''),(2293132,'1','200','1025',468,'Retail Sale Id 1343320',46800.00,0.00,0.00,78.00,1092.00,'2021-12-16 06:26:13','',''),(2293184,'1','200','1025',468,'Retail Sale Id 1343353',1997.12,0.00,0.00,3.16,145.36,'2021-12-16 06:32:36','',''),(2293594,'1','200','1025',468,'Retail Sale Id 1343682',2528.00,0.00,0.00,4.00,184.00,'2021-12-16 07:09:23','',''),(2293617,'1','200','1025',468,'Retail Sale Id 1343705',998.56,0.00,0.00,1.58,72.68,'2021-12-16 07:12:12','',''),(2293631,'1','200','1025',468,'Retail Sale Id 1343719',1264.00,0.00,0.00,2.00,92.00,'2021-12-16 07:13:54','',''),(2294184,'1','200','1025',468,'Retail Sale Id 1344052',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 07:50:06','',''),(2294231,'1','200','1025',468,'Retail Sale Id 1344097',240000.00,0.00,0.00,400.00,5600.00,'2021-12-16 07:55:48','',''),(2294254,'1','200','1025',468,'Retail Sale Id 1344117',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 07:58:34','',''),(2294349,'1','200','1025',468,'Retail Sale Id 1344180',1997.12,0.00,0.00,3.16,145.36,'2021-12-16 08:05:45','',''),(2294374,'1','200','1025',468,'Retail Sale Id 1344201',1497.84,0.00,0.00,2.37,109.02,'2021-12-16 08:07:47','',''),(2294375,'1','200','1025',468,'Retail Sale Id 1344201',4999.12,0.00,0.00,7.91,363.86,'2021-12-16 08:07:47','',''),(2294397,'1','200','1025',468,'Retail Sale Id 1344221',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 08:09:38','',''),(2294519,'1','200','1025',468,'Retail Sale Id 1344306',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 08:16:59','',''),(2294572,'1','200','1025',468,'Retail Sale Id 1344356',4999.12,0.00,0.00,7.91,363.86,'2021-12-16 08:21:03','',''),(2294776,'1','200','1025',468,'Retail Sale Id 1344511',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 08:37:36','',''),(2294819,'1','200','1025',468,'Retail Sale Id 1344530',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 08:39:35','',''),(2294992,'1','200','1025',468,'Retail Sale Id 1344650',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 08:52:52','',''),(2295020,'1','200','1025',468,'Retail Sale Id 1344673',7584.00,0.00,0.00,12.00,552.00,'2021-12-16 08:55:23','',''),(2295037,'1','200','1025',468,'Retail Sale Id 1344685',36000.00,0.00,0.00,60.00,840.00,'2021-12-16 08:56:48','',''),(2295065,'1','200','1025',468,'Retail Sale Id 1344712',30000.00,0.00,0.00,50.00,700.00,'2021-12-16 08:59:38','',''),(2295079,'1','200','1025',468,'Retail Sale Id 1344724',4200.00,0.00,0.00,7.00,98.00,'2021-12-16 09:01:04','',''),(2295127,'1','200','1025',468,'Retail Sale Id 1344771',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 09:05:30','',''),(2295263,'1','200','1025',468,'Retail Sale Id 1344895',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 09:17:36','',''),(2295446,'1','200','1025',468,'Retail Sale Id 1345048',1997.12,0.00,0.00,3.16,145.36,'2021-12-16 09:34:11','',''),(2295459,'1','200','1025',468,'Retail Sale Id 1345061',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 09:35:32','',''),(2295528,'1','200','1025',468,'Retail Sale Id 1345116',6320.00,0.00,0.00,10.00,460.00,'2021-12-16 09:42:02','',''),(2295624,'1','200','1025',468,'Retail Sale Id 1345199',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 09:51:59','',''),(2295625,'1','200','1025',468,'Retail Sale Id 1345199',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 09:51:59','',''),(2295626,'1','200','1025',468,'Retail Sale Id 1345199',5056.00,0.00,0.00,8.00,368.00,'2021-12-16 09:51:59','',''),(2295714,'1','200','1025',468,'Retail Sale Id 1345252',6320.00,0.00,0.00,10.00,460.00,'2021-12-16 09:58:49','',''),(2295715,'1','200','1025',468,'Retail Sale Id 1345252',6320.00,0.00,0.00,10.00,460.00,'2021-12-16 09:58:49','',''),(2295728,'1','200','1025',468,'Retail Sale Id 1345268',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 10:00:16','',''),(2295773,'1','200','1025',468,'Retail Sale Id 1345282',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 10:02:02','',''),(2295904,'1','200','1025',468,'Retail Sale Id 1345376',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 10:13:01','',''),(2295905,'1','200','1025',468,'Retail Sale Id 1345376',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 10:13:01','',''),(2295971,'1','200','1025',468,'Retail Sale Id 1345451',150000.00,0.00,0.00,250.00,3500.00,'2021-12-16 10:21:14','',''),(2296078,'1','200','1025',468,'Retail Sale Id 1345528',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 10:33:50','',''),(2296079,'1','200','1025',468,'Retail Sale Id 1345528',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 10:33:50','',''),(2296080,'1','200','1025',468,'Retail Sale Id 1345528',31600.00,0.00,0.00,50.00,2300.00,'2021-12-16 10:33:50','',''),(2296177,'1','200','1025',468,'Retail Sale Id 1345654',7501.84,0.00,0.00,11.87,546.02,'2021-12-16 10:46:02','',''),(2296257,'1','200','1025',468,'Retail Sale Id 1345733',6952.00,0.00,0.00,11.00,506.00,'2021-12-16 10:55:22','',''),(2296282,'1','200','1025',468,'Retail Sale Id 1345759',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 10:57:54','',''),(2296283,'1','200','1025',468,'Retail Sale Id 1345759',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 10:57:54','',''),(2296357,'1','200','1025',468,'Retail Sale Id 1345835',1997.12,0.00,0.00,3.16,145.36,'2021-12-16 11:07:17','',''),(2296441,'1','200','1025',468,'Retail Sale Id 1345898',4108.00,0.00,0.00,6.50,299.00,'2021-12-16 11:14:47','',''),(2296452,'1','200','1025',468,'Retail Sale Id 1345915',150000.00,0.00,0.00,250.00,3500.00,'2021-12-16 11:16:12','',''),(2296531,'1','200','1025',468,'Retail Sale Id 1345976',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 11:25:54','',''),(2296532,'1','200','1025',468,'Retail Sale Id 1345976',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 11:25:54','',''),(2296632,'1','200','1025',468,'Retail Sale Id 1346064',63000.00,0.00,0.00,105.00,1470.00,'2021-12-16 11:37:36','',''),(2296699,'1','200','1025',468,'Retail Sale Id 1346141',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 11:45:34','',''),(2296722,'1','200','1025',468,'Retail Sale Id 1346164',4424.00,0.00,0.00,7.00,322.00,'2021-12-16 11:48:33','',''),(2296770,'1','200','1025',468,'Retail Sale Id 1346209',7584.00,0.00,0.00,12.00,552.00,'2021-12-16 11:54:21','',''),(2296781,'1','200','1025',468,'Retail Sale Id 1346218',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 11:55:50','',''),(2296782,'1','200','1025',468,'Retail Sale Id 1346218',6952.00,0.00,0.00,11.00,506.00,'2021-12-16 11:55:50','',''),(2296795,'1','200','1025',468,'Retail Sale Id 1346232',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 11:57:35','',''),(2296853,'1','200','1025',468,'Retail Sale Id 1346274',72000.00,0.00,0.00,120.00,1680.00,'2021-12-16 12:03:36','',''),(2296865,'1','200','1025',468,'Retail Sale Id 1346282',21600.00,0.00,0.00,36.00,504.00,'2021-12-16 12:05:21','',''),(2296888,'1','200','1025',468,'Retail Sale Id 1346306',1264.00,0.00,0.00,2.00,92.00,'2021-12-16 12:08:24','',''),(2296935,'1','200','1025',468,'Retail Sale Id 1346330',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 12:11:35','',''),(2297162,'1','200','1025',468,'Retail Sale Id 1346530',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 12:39:15','',''),(2297193,'1','200','1025',468,'Retail Sale Id 1346562',1497.84,0.00,0.00,2.37,109.02,'2021-12-16 12:43:01','',''),(2297230,'1','200','1025',468,'Retail Sale Id 1346586',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 12:45:33','',''),(2297242,'1','200','1025',468,'Retail Sale Id 1346601',2528.00,0.00,0.00,4.00,184.00,'2021-12-16 12:46:43','',''),(2297296,'1','200','1025',468,'Retail Sale Id 1346645',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 12:53:02','',''),(2297308,'1','200','1025',468,'Retail Sale Id 1346661',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 12:54:41','',''),(2297375,'1','200','1025',468,'Retail Sale Id 1346705',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 13:02:00','',''),(2297395,'1','200','1025',468,'Retail Sale Id 1346724',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 13:05:38','',''),(2297410,'1','200','1025',468,'Retail Sale Id 1346740',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 13:07:42','',''),(2297446,'1','200','1025',468,'Retail Sale Id 1346775',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 13:12:26','',''),(2297556,'1','200','1025',468,'Retail Sale Id 1346888',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 13:24:18','',''),(2297577,'1','200','1025',468,'Retail Sale Id 1346901',1264000.00,0.00,0.00,2000.00,92000.00,'2021-12-16 13:25:31','',''),(2297591,'1','200','1025',468,'Retail Sale Id 1346911',1264.00,0.00,0.00,2.00,92.00,'2021-12-16 13:26:39','',''),(2297631,'1','200','1025',468,'Retail Sale Id 1346936',632.00,0.00,0.00,1.00,46.00,'2021-12-16 13:30:39','',''),(2297651,'1','200','1025',468,'Retail Sale Id 1346952',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 13:32:40','',''),(2297664,'1','200','1025',468,'Retail Sale Id 1346971',1997.12,0.00,0.00,3.16,145.36,'2021-12-16 13:34:34','',''),(2297705,'1','200','1025',468,'Retail Sale Id 1346995',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 13:36:32','',''),(2297720,'1','200','1025',468,'Retail Sale Id 1347011',2844.00,0.00,0.00,4.50,207.00,'2021-12-16 13:38:18','',''),(2297732,'1','200','1025',468,'Retail Sale Id 1347023',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 13:39:53','',''),(2297768,'1','200','1025',468,'Retail Sale Id 1347053',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 13:43:10','',''),(2297925,'1','200','1025',468,'Retail Sale Id 1347173',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 13:56:40','',''),(2297935,'1','200','1025',468,'Return of Retail Sale Id 1346901',0.00,1264000.00,2000.00,0.00,-92000.00,'2021-12-16 13:57:26','',''),(2297978,'1','200','1025',468,'Retail Sale Id 1347211',3002.00,0.00,0.00,4.75,218.50,'2021-12-16 14:01:46','',''),(2298125,'1','200','1025',468,'Retail Sale Id 1347317',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 14:13:35','',''),(2298142,'1','200','1025',468,'Retail Sale Id 1347332',1497.84,0.00,0.00,2.37,109.02,'2021-12-16 14:15:52','',''),(2298153,'1','200','1025',468,'Retail Sale Id 1347346',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 14:17:23','',''),(2298214,'1','200','1025',468,'Retail Sale Id 1347392',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 14:22:24','',''),(2298222,'1','200','1025',468,'Retail Sale Id 1347399',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 14:23:33','',''),(2298232,'1','200','1025',468,'Retail Sale Id 1347409',2528.00,0.00,0.00,4.00,184.00,'2021-12-16 14:24:45','',''),(2298248,'1','200','1025',468,'Retail Sale Id 1347425',2528.00,0.00,0.00,4.00,184.00,'2021-12-16 14:26:33','',''),(2298272,'1','200','1025',468,'Retail Sale Id 1347454',15000.00,0.00,0.00,25.00,350.00,'2021-12-16 14:29:42','',''),(2298290,'1','200','1025',468,'Retail Sale Id 1347474',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 14:31:26','',''),(2298295,'1','200','1025',468,'Retail Sale Id 1347479',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 14:32:24','',''),(2298338,'1','200','1025',468,'Retail Sale Id 1347523',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 14:38:03','',''),(2298357,'1','200','1025',468,'Retail Sale Id 1347544',6320.00,0.00,0.00,10.00,460.00,'2021-12-16 14:40:07','',''),(2298613,'1','200','1025',468,'Retail Sale Id 1347671',1997.12,0.00,0.00,3.16,145.36,'2021-12-16 14:54:35','',''),(2298622,'1','200','1025',468,'Retail Sale Id 1347679',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 14:55:54','',''),(2298685,'1','200','1025',468,'Retail Sale Id 1347742',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 15:05:01','',''),(2298702,'1','200','1025',468,'Retail Sale Id 1347757',22500.00,0.00,0.00,37.50,525.00,'2021-12-16 15:07:47','',''),(2298720,'1','200','1025',468,'Retail Sale Id 1347771',6000.00,0.00,0.00,10.00,140.00,'2021-12-16 15:09:38','',''),(2298743,'1','200','1025',468,'Retail Sale Id 1347795',3501.28,0.00,0.00,5.54,254.84,'2021-12-16 15:11:55','',''),(2298843,'1','200','1025',468,'Retail Sale Id 1347886',6952.00,0.00,0.00,11.00,506.00,'2021-12-16 15:22:04','',''),(2298866,'1','200','1025',468,'Retail Sale Id 1347895',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 15:23:22','',''),(2298928,'1','200','1025',468,'Retail Sale Id 1347914',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 15:25:05','',''),(2298969,'1','200','1025',468,'Retail Sale Id 1347925',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 15:26:18','',''),(2299045,'1','200','1025',468,'Retail Sale Id 1347985',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 15:32:21','',''),(2299090,'1','200','1025',468,'Retail Sale Id 1348029',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 15:36:23','',''),(2299108,'1','200','1025',468,'Retail Sale Id 1348048',1264.00,0.00,0.00,2.00,92.00,'2021-12-16 15:37:40','',''),(2299123,'1','200','1025',468,'Retail Sale Id 1348060',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 15:39:03','',''),(2299134,'1','200','1025',468,'Retail Sale Id 1348074',1997.12,0.00,0.00,3.16,145.36,'2021-12-16 15:39:56','',''),(2299146,'1','200','1025',468,'Retail Sale Id 1348083',2528.00,0.00,0.00,4.00,184.00,'2021-12-16 15:41:04','',''),(2299251,'1','200','1025',468,'Retail Sale Id 1348164',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 15:48:33','',''),(2299267,'1','200','1025',468,'Retail Sale Id 1348175',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 15:49:57','',''),(2299286,'1','200','1025',468,'Retail Sale Id 1348196',2528.00,0.00,0.00,4.00,184.00,'2021-12-16 15:51:39','',''),(2299342,'1','200','1025',468,'Retail Sale Id 1348235',9000.00,0.00,0.00,15.00,210.00,'2021-12-16 15:54:58','',''),(2299371,'1','200','1025',468,'Retail Sale Id 1348250',3002.00,0.00,0.00,4.75,218.50,'2021-12-16 15:56:13','',''),(2299404,'1','200','1025',468,'Retail Sale Id 1348267',1800.00,0.00,0.00,3.00,42.00,'2021-12-16 15:58:09','',''),(2299496,'1','200','1025',468,'Retail Sale Id 1348347',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 16:05:23','',''),(2299518,'1','200','1025',468,'Retail Sale Id 1348370',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 16:06:33','',''),(2299574,'1','200','1025',468,'Retail Sale Id 1348404',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 16:09:52','',''),(2299703,'1','200','1025',468,'Retail Sale Id 1348462',5688.00,0.00,0.00,9.00,414.00,'2021-12-16 16:16:12','',''),(2299715,'1','200','1025',468,'Retail Sale Id 1348477',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 16:17:08','',''),(2299755,'1','200','1025',468,'Retail Sale Id 1348518',1497.84,0.00,0.00,2.37,109.02,'2021-12-16 16:20:39','',''),(2299793,'1','200','1025',468,'Retail Sale Id 1348552',12008.00,0.00,0.00,19.00,874.00,'2021-12-16 16:24:04','',''),(2299828,'1','200','1025',468,'Retail Sale Id 1348591',180000.00,0.00,0.00,300.00,4200.00,'2021-12-16 16:27:25','',''),(2299862,'1','200','1025',468,'Retail Sale Id 1348621',998.56,0.00,0.00,1.58,72.68,'2021-12-16 16:29:53','',''),(2299883,'1','200','1025',468,'Retail Sale Id 1348642',3002.00,0.00,0.00,4.75,218.50,'2021-12-16 16:31:29','',''),(2299963,'1','200','1025',468,'Retail Sale Id 1348718',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 16:39:48','',''),(2300005,'1','200','1025',468,'Retail Sale Id 1348760',24000.00,0.00,0.00,40.00,560.00,'2021-12-16 16:44:28','',''),(2300096,'1','200','1025',468,'Retail Sale Id 1348849',3002.00,0.00,0.00,4.75,218.50,'2021-12-16 16:53:10','',''),(2300106,'1','200','1025',468,'Retail Sale Id 1348858',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 16:54:23','',''),(2300160,'1','200','1025',468,'Retail Sale Id 1348883',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 16:59:18','',''),(2300161,'1','200','1025',468,'Retail Sale Id 1348883',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 16:59:18','',''),(2300184,'1','200','1025',468,'Retail Sale Id 1348911',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 17:02:23','',''),(2300185,'1','200','1025',468,'Retail Sale Id 1348911',7900.00,0.00,0.00,12.50,575.00,'2021-12-16 17:02:23','',''),(2300194,'1','200','1025',468,'Retail Sale Id 1348919',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 17:03:25','',''),(2300202,'1','200','1025',468,'Retail Sale Id 1348927',1896.00,0.00,0.00,3.00,138.00,'2021-12-16 17:04:34','',''),(2300215,'1','200','1025',468,'Retail Sale Id 1348938',3160.00,0.00,0.00,5.00,230.00,'2021-12-16 17:07:06','',''),(2300276,'1','200','1025',468,'Retail Sale Id 1348984',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 17:13:49','',''),(2300296,'1','200','1025',468,'Retail Sale Id 1349001',3792.00,0.00,0.00,6.00,276.00,'2021-12-16 17:17:05','',''),(2301328,'1','200','1025',468,'Retail Sale Id 1349459',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 06:12:48','',''),(2301394,'1','200','1025',468,'Retail Sale Id 1349507',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 06:23:20','',''),(2301465,'1','200','1025',468,'Retail Sale Id 1349560',2502.72,0.00,0.00,3.96,182.16,'2021-12-17 06:34:10','',''),(2301608,'1','200','1025',468,'Retail Sale Id 1349678',1997.12,0.00,0.00,3.16,145.36,'2021-12-17 06:54:27','',''),(2301718,'1','200','1025',468,'Retail Sale Id 1349734',1700.08,0.00,0.00,2.69,123.74,'2021-12-17 07:01:39','',''),(2301719,'1','200','1025',468,'Retail Sale Id 1349734',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 07:01:39','',''),(2301800,'1','200','1025',468,'Retail Sale Id 1349818',6320.00,0.00,0.00,10.00,460.00,'2021-12-17 07:11:16','',''),(2301846,'1','200','1025',468,'Retail Sale Id 1349846',66000.00,0.00,0.00,110.00,1540.00,'2021-12-17 07:14:11','',''),(2301925,'1','200','1025',468,'Retail Sale Id 1349898',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 07:19:43','',''),(2301945,'1','200','1025',468,'Retail Sale Id 1349919',36000.00,0.00,0.00,60.00,840.00,'2021-12-17 07:22:23','',''),(2302023,'1','200','1025',468,'Retail Sale Id 1349971',56400.00,0.00,0.00,94.00,1316.00,'2021-12-17 07:30:20','',''),(2302039,'1','200','1025',468,'Retail Sale Id 1350010',802.64,0.00,0.00,1.27,58.42,'2021-12-17 07:31:57','',''),(2302100,'1','200','1025',468,'Retail Sale Id 1350058',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 07:38:03','',''),(2302147,'1','200','1025',468,'Retail Sale Id 1350085',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 07:41:53','',''),(2302234,'1','200','1025',468,'Retail Sale Id 1350152',998.56,0.00,0.00,1.58,72.68,'2021-12-17 07:50:32','',''),(2302267,'1','200','1025',468,'Retail Sale Id 1350189',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 07:54:35','',''),(2302358,'1','200','1025',468,'Retail Sale Id 1350255',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 08:01:47','',''),(2302359,'1','200','1025',468,'Retail Sale Id 1350255',2528.00,0.00,0.00,4.00,184.00,'2021-12-17 08:01:47','',''),(2302371,'1','200','1025',468,'Retail Sale Id 1350266',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 08:02:57','',''),(2302389,'1','200','1025',468,'Retail Sale Id 1350285',3002.00,0.00,0.00,4.75,218.50,'2021-12-17 08:04:10','',''),(2302398,'1','200','1025',468,'Retail Sale Id 1350295',1264.00,0.00,0.00,2.00,92.00,'2021-12-17 08:05:04','',''),(2302462,'1','200','1025',468,'Retail Sale Id 1350353',1264.00,0.00,0.00,2.00,92.00,'2021-12-17 08:12:47','',''),(2302498,'1','200','1025',468,'Retail Sale Id 1350395',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 08:16:48','',''),(2302511,'1','200','1025',468,'Retail Sale Id 1350408',632.00,0.00,0.00,1.00,46.00,'2021-12-17 08:18:00','',''),(2302539,'1','200','1025',468,'Retail Sale Id 1350434',8400.00,0.00,0.00,14.00,196.00,'2021-12-17 08:19:53','',''),(2302553,'1','200','1025',468,'Retail Sale Id 1350450',2844.00,0.00,0.00,4.50,207.00,'2021-12-17 08:21:31','',''),(2302580,'1','200','1025',468,'Retail Sale Id 1350476',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 08:23:40','',''),(2302650,'1','200','1025',468,'Retail Sale Id 1350518',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 08:28:14','',''),(2302735,'1','200','1025',468,'Retail Sale Id 1350607',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 08:36:32','',''),(2302736,'1','200','1025',468,'Retail Sale Id 1350607',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 08:36:32','',''),(2302737,'1','200','1025',468,'Retail Sale Id 1350607',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 08:36:32','',''),(2302738,'1','200','1025',468,'Retail Sale Id 1350607',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 08:36:32','',''),(2302777,'1','200','1025',468,'Retail Sale Id 1350633',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 08:40:15','',''),(2302936,'1','200','1025',468,'Retail Sale Id 1350733',2199.36,0.00,0.00,3.48,160.08,'2021-12-17 08:52:17','',''),(2302953,'1','200','1025',468,'Retail Sale Id 1350749',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 08:53:36','',''),(2302979,'1','200','1025',468,'Retail Sale Id 1350762',3002.00,0.00,0.00,4.75,218.50,'2021-12-17 08:54:54','',''),(2302986,'1','200','1025',468,'Retail Sale Id 1350769',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 08:56:22','',''),(2303256,'1','200','1025',468,'Retail Sale Id 1350933',6320.00,0.00,0.00,10.00,460.00,'2021-12-17 09:18:29','',''),(2303279,'1','200','1025',468,'Retail Sale Id 1350958',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 09:20:33','',''),(2303301,'1','200','1025',468,'Retail Sale Id 1350982',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 09:22:44','',''),(2303343,'1','200','1025',468,'Retail Sale Id 1351011',632.00,0.00,0.00,1.00,46.00,'2021-12-17 09:26:17','',''),(2303407,'1','200','1025',468,'Retail Sale Id 1351057',1801.20,0.00,0.00,2.85,131.10,'2021-12-17 09:31:47','',''),(2303426,'1','200','1025',468,'Retail Sale Id 1351073',1200.80,0.00,0.00,1.90,87.40,'2021-12-17 09:33:04','',''),(2303488,'1','200','1025',468,'Retail Sale Id 1351114',5056.00,0.00,0.00,8.00,368.00,'2021-12-17 09:36:35','',''),(2303721,'1','200','1025',468,'Retail Sale Id 1351288',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 09:57:48','',''),(2303777,'1','200','1025',468,'Retail Sale Id 1351341',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 10:03:38','',''),(2303785,'1','200','1025',468,'Retail Sale Id 1351364',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 10:05:58','',''),(2303813,'1','200','1025',468,'Retail Sale Id 1351424',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 10:09:16','',''),(2303873,'1','200','1025',468,'Retail Sale Id 1351470',6320.00,0.00,0.00,10.00,460.00,'2021-12-17 10:14:53','',''),(2303896,'1','200','1025',468,'Retail Sale Id 1351493',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 10:17:43','',''),(2303920,'1','200','1025',468,'Retail Sale Id 1351514',1264.00,0.00,0.00,2.00,92.00,'2021-12-17 10:19:32','',''),(2303951,'1','200','1025',468,'Retail Sale Id 1351543',30000.00,0.00,0.00,50.00,700.00,'2021-12-17 10:23:34','',''),(2303962,'1','200','1025',468,'Retail Sale Id 1351556',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 10:24:57','',''),(2303975,'1','200','1025',468,'Retail Sale Id 1351567',1497.84,0.00,0.00,2.37,109.02,'2021-12-17 10:26:37','',''),(2303996,'1','200','1025',468,'Retail Sale Id 1351587',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 10:29:20','',''),(2304015,'1','200','1025',468,'Retail Sale Id 1351604',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 10:31:23','',''),(2304045,'1','200','1025',468,'Retail Sale Id 1351627',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 10:34:32','',''),(2304074,'1','200','1025',468,'Retail Sale Id 1351653',2528.00,0.00,0.00,4.00,184.00,'2021-12-17 10:37:57','',''),(2304086,'1','200','1025',468,'Retail Sale Id 1351665',3501.28,0.00,0.00,5.54,254.84,'2021-12-17 10:39:25','',''),(2304100,'1','200','1025',468,'Retail Sale Id 1351681',998.56,0.00,0.00,1.58,72.68,'2021-12-17 10:41:09','',''),(2304139,'1','200','1025',468,'Retail Sale Id 1351720',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 10:46:02','',''),(2304181,'1','200','1025',468,'Retail Sale Id 1351769',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 10:51:10','',''),(2304266,'1','200','1025',468,'Retail Sale Id 1351846',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 11:01:45','',''),(2304307,'1','200','1025',468,'Retail Sale Id 1351879',2528.00,0.00,0.00,4.00,184.00,'2021-12-17 11:04:50','',''),(2304358,'1','200','1025',468,'Retail Sale Id 1351930',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 11:10:30','',''),(2304399,'1','200','1025',468,'Retail Sale Id 1351973',2528.00,0.00,0.00,4.00,184.00,'2021-12-17 11:14:38','',''),(2304442,'1','200','1025',468,'Retail Sale Id 1352010',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 11:18:13','',''),(2304577,'1','200','1025',468,'Retail Sale Id 1352118',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 11:28:26','',''),(2304801,'1','200','1025',468,'Retail Sale Id 1352344',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 11:54:44','',''),(2304802,'1','200','1025',468,'Retail Sale Id 1352344',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 11:54:44','',''),(2304908,'1','200','1025',468,'Retail Sale Id 1352427',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 12:06:24','',''),(2304916,'1','200','1025',468,'Retail Sale Id 1352434',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 12:08:03','',''),(2304984,'1','200','1025',468,'Retail Sale Id 1352508',37200.00,0.00,0.00,62.00,868.00,'2021-12-17 12:18:18','',''),(2305075,'1','200','1025',468,'Retail Sale Id 1352599',1497.84,0.00,0.00,2.37,109.02,'2021-12-17 12:34:31','',''),(2305153,'1','200','1025',468,'Retail Sale Id 1352655',2502.72,0.00,0.00,3.96,182.16,'2021-12-17 12:43:30','',''),(2305219,'1','200','1025',468,'Retail Sale Id 1352733',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 12:55:29','',''),(2305278,'1','200','1025',468,'Retail Sale Id 1352791',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 13:03:09','',''),(2305335,'1','200','1025',468,'Retail Sale Id 1352844',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 13:12:04','',''),(2305354,'1','200','1025',468,'Retail Sale Id 1352865',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 13:16:01','',''),(2305397,'1','200','1025',468,'Retail Sale Id 1352915',1997.12,0.00,0.00,3.16,145.36,'2021-12-17 13:22:16','',''),(2305416,'1','200','1025',468,'Retail Sale Id 1352936',4999.12,0.00,0.00,7.91,363.86,'2021-12-17 13:25:23','',''),(2305439,'1','200','1025',468,'Retail Sale Id 1352956',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 13:28:05','',''),(2305482,'1','200','1025',468,'Retail Sale Id 1353000',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 13:33:26','',''),(2305483,'1','200','1025',468,'Retail Sale Id 1353000',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 13:33:26','',''),(2305484,'1','200','1025',468,'Retail Sale Id 1353000',5056.00,0.00,0.00,8.00,368.00,'2021-12-17 13:33:26','',''),(2305613,'1','200','1025',468,'Retail Sale Id 1353084',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 13:44:42','',''),(2305761,'1','200','1025',468,'Retail Sale Id 1353192',2528.00,0.00,0.00,4.00,184.00,'2021-12-17 13:59:52','',''),(2305812,'1','200','1025',468,'Retail Sale Id 1353223',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 14:03:41','',''),(2305827,'1','200','1025',468,'Retail Sale Id 1353239',1997.12,0.00,0.00,3.16,145.36,'2021-12-17 14:05:34','',''),(2305861,'1','200','1025',468,'Retail Sale Id 1353267',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 14:08:49','',''),(2305904,'1','200','1025',468,'Retail Sale Id 1353307',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 14:13:18','',''),(2305912,'1','200','1025',468,'Retail Sale Id 1353315',5056.00,0.00,0.00,8.00,368.00,'2021-12-17 14:14:43','',''),(2305998,'1','200','1025',468,'Retail Sale Id 1353387',1497.84,0.00,0.00,2.37,109.02,'2021-12-17 14:26:50','',''),(2306017,'1','200','1025',468,'Retail Sale Id 1353405',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 14:28:31','',''),(2306029,'1','200','1025',468,'Retail Sale Id 1353416',90000.00,0.00,0.00,150.00,2100.00,'2021-12-17 14:30:18','',''),(2306129,'1','200','1025',468,'Retail Sale Id 1353506',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 14:38:53','',''),(2306136,'1','200','1025',468,'Retail Sale Id 1353518',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 14:40:10','',''),(2306184,'1','200','1025',468,'Retail Sale Id 1353536',72000.00,0.00,0.00,120.00,1680.00,'2021-12-17 14:42:34','',''),(2306205,'1','200','1025',468,'Retail Sale Id 1353551',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 14:44:00','',''),(2306248,'1','200','1025',468,'Retail Sale Id 1353577',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 14:46:05','',''),(2306249,'1','200','1025',468,'Retail Sale Id 1353577',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 14:46:05','',''),(2306396,'1','200','1025',468,'Retail Sale Id 1353672',6320.00,0.00,0.00,10.00,460.00,'2021-12-17 14:56:34','',''),(2306406,'1','200','1025',468,'Retail Sale Id 1353682',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 14:57:50','',''),(2306503,'1','200','1025',468,'Retail Sale Id 1353773',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 15:08:50','',''),(2306514,'1','200','1025',468,'Retail Sale Id 1353791',998.56,0.00,0.00,1.58,72.68,'2021-12-17 15:09:52','',''),(2306561,'1','200','1025',468,'Retail Sale Id 1353836',632.00,0.00,0.00,1.00,46.00,'2021-12-17 15:15:17','',''),(2306573,'1','200','1025',468,'Retail Sale Id 1353847',948.00,0.00,0.00,1.50,69.00,'2021-12-17 15:16:48','',''),(2306574,'1','200','1025',468,'Retail Sale Id 1353847',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 15:16:48','',''),(2306614,'1','200','1025',468,'Retail Sale Id 1353874',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 15:19:29','',''),(2306675,'1','200','1025',468,'Retail Sale Id 1353908',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 15:23:00','',''),(2306706,'1','200','1025',468,'Retail Sale Id 1353939',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 15:25:28','',''),(2306726,'1','200','1025',468,'Retail Sale Id 1353957',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 15:26:59','',''),(2306761,'1','200','1025',468,'Retail Sale Id 1353982',1264.00,0.00,0.00,2.00,92.00,'2021-12-17 15:29:24','',''),(2306792,'1','200','1025',468,'Retail Sale Id 1353997',1264.00,0.00,0.00,2.00,92.00,'2021-12-17 15:31:04','',''),(2306813,'1','200','1025',468,'Retail Sale Id 1354026',15600.00,0.00,0.00,26.00,364.00,'2021-12-17 15:33:37','',''),(2306862,'1','200','1025',468,'Retail Sale Id 1354042',35400.00,0.00,0.00,59.00,826.00,'2021-12-17 15:35:48','',''),(2306932,'1','200','1025',468,'Retail Sale Id 1354095',998.56,0.00,0.00,1.58,72.68,'2021-12-17 15:40:30','',''),(2306988,'1','200','1025',468,'Retail Sale Id 1354138',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 15:44:13','',''),(2307015,'1','200','1025',468,'Retail Sale Id 1354157',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 15:45:40','',''),(2307047,'1','200','1025',468,'Retail Sale Id 1354188',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 15:47:49','',''),(2307082,'1','200','1025',468,'Retail Sale Id 1354230',998.56,0.00,0.00,1.58,72.68,'2021-12-17 15:50:47','',''),(2307128,'1','200','1025',468,'Retail Sale Id 1354277',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 15:55:13','',''),(2307253,'1','200','1025',468,'Retail Sale Id 1354406',2528.00,0.00,0.00,4.00,184.00,'2021-12-17 16:06:16','',''),(2307306,'1','200','1025',468,'Retail Sale Id 1354467',1497.84,0.00,0.00,2.37,109.02,'2021-12-17 16:11:48','',''),(2307398,'1','200','1025',468,'Retail Sale Id 1354563',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 16:19:26','',''),(2307420,'1','200','1025',468,'Retail Sale Id 1354587',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 16:20:49','',''),(2307431,'1','200','1025',468,'Retail Sale Id 1354596',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 16:22:07','',''),(2307508,'1','200','1025',468,'Retail Sale Id 1354672',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 16:29:42','',''),(2307565,'1','200','1025',468,'Retail Sale Id 1354734',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 16:35:10','',''),(2307599,'1','200','1025',468,'Retail Sale Id 1354771',3160.00,0.00,0.00,5.00,230.00,'2021-12-17 16:39:14','',''),(2307619,'1','200','1025',468,'Retail Sale Id 1354789',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 16:41:21','',''),(2307635,'1','200','1025',468,'Retail Sale Id 1354805',3792.00,0.00,0.00,6.00,276.00,'2021-12-17 16:42:35','',''),(2307653,'1','200','1025',468,'Retail Sale Id 1354825',3002.00,0.00,0.00,4.75,218.50,'2021-12-17 16:44:49','',''),(2307777,'1','200','1025',468,'Retail Sale Id 1354905',7900.00,0.00,0.00,12.50,575.00,'2021-12-17 16:55:49','',''),(2307796,'1','200','1025',468,'Retail Sale Id 1354931',1896.00,0.00,0.00,3.00,138.00,'2021-12-17 16:58:47','',''),(2309062,'1','200','1025',468,'Retail Sale Id 1355460',46500.00,0.00,0.00,77.50,1085.00,'2021-12-18 06:07:19','',''),(2309226,'1','200','1025',468,'Retail Sale Id 1355622',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 06:38:45','',''),(2309393,'1','200','1025',468,'Retail Sale Id 1355771',12000.00,0.00,0.00,20.00,280.00,'2021-12-18 06:54:21','',''),(2309433,'1','200','1025',468,'Retail Sale Id 1355807',600.00,0.00,0.00,1.00,14.00,'2021-12-18 06:57:39','',''),(2309473,'1','200','1025',468,'Retail Sale Id 1355835',3002.00,0.00,0.00,4.75,218.50,'2021-12-18 07:00:45','',''),(2309492,'1','200','1025',468,'Retail Sale Id 1355849',2528.00,0.00,0.00,4.00,184.00,'2021-12-18 07:02:07','',''),(2309561,'1','200','1025',468,'Retail Sale Id 1355891',998.56,0.00,0.00,1.58,72.68,'2021-12-18 07:05:45','',''),(2309581,'1','200','1025',468,'Retail Sale Id 1355906',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 07:07:44','',''),(2309612,'1','200','1025',468,'Retail Sale Id 1355932',2502.72,0.00,0.00,3.96,182.16,'2021-12-18 07:11:06','',''),(2309638,'1','200','1025',468,'Retail Sale Id 1355962',2502.72,0.00,0.00,3.96,182.16,'2021-12-18 07:13:05','',''),(2309695,'1','200','1025',468,'Retail Sale Id 1355998',2528.00,0.00,0.00,4.00,184.00,'2021-12-18 07:17:38','',''),(2309802,'1','200','1025',468,'Retail Sale Id 1356078',150000.00,0.00,0.00,250.00,3500.00,'2021-12-18 07:25:55','',''),(2309932,'1','200','1025',468,'Retail Sale Id 1356187',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 07:39:12','',''),(2310027,'1','200','1025',468,'Retail Sale Id 1356260',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 07:45:19','',''),(2310076,'1','200','1025',468,'Retail Sale Id 1356294',1497.84,0.00,0.00,2.37,109.02,'2021-12-18 07:48:16','',''),(2310122,'1','200','1025',468,'Retail Sale Id 1356333',6320.00,0.00,0.00,10.00,460.00,'2021-12-18 07:52:41','',''),(2310203,'1','200','1025',468,'Retail Sale Id 1356407',162000.00,0.00,0.00,270.00,3780.00,'2021-12-18 08:00:29','',''),(2310217,'1','200','1025',468,'Retail Sale Id 1356423',144000.00,0.00,0.00,240.00,3360.00,'2021-12-18 08:02:34','',''),(2310231,'1','200','1025',468,'Retail Sale Id 1356439',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 08:03:55','',''),(2310317,'1','200','1025',468,'Retail Sale Id 1356499',5056.00,0.00,0.00,8.00,368.00,'2021-12-18 08:10:32','',''),(2310421,'1','200','1025',468,'Retail Sale Id 1356565',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 08:18:41','',''),(2310438,'1','200','1025',468,'Retail Sale Id 1356584',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 08:20:32','',''),(2310535,'1','200','1025',468,'Retail Sale Id 1356651',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 08:26:06','',''),(2310650,'1','200','1025',468,'Retail Sale Id 1356741',6320.00,0.00,0.00,10.00,460.00,'2021-12-18 08:34:28','',''),(2310692,'1','200','1025',468,'Retail Sale Id 1356787',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 08:38:27','',''),(2310705,'1','200','1025',468,'Retail Sale Id 1356802',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 08:39:23','',''),(2310729,'1','200','1025',468,'Retail Sale Id 1356824',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 08:41:24','',''),(2310747,'1','200','1025',468,'Retail Sale Id 1356845',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 08:42:49','',''),(2310772,'1','200','1025',468,'Retail Sale Id 1356866',2528.00,0.00,0.00,4.00,184.00,'2021-12-18 08:45:14','',''),(2310952,'1','200','1025',468,'Retail Sale Id 1357034',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 09:00:16','',''),(2310987,'1','200','1025',468,'Retail Sale Id 1357055',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 09:02:39','',''),(2311006,'1','200','1025',468,'Retail Sale Id 1357072',1997.12,0.00,0.00,3.16,145.36,'2021-12-18 09:04:13','',''),(2311098,'1','200','1025',468,'Retail Sale Id 1357147',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 09:11:25','',''),(2311113,'1','200','1025',468,'Retail Sale Id 1357160',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 09:12:33','',''),(2311141,'1','200','1025',468,'Retail Sale Id 1357174',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 09:13:58','',''),(2311198,'1','200','1025',468,'Retail Sale Id 1357207',300000.00,0.00,0.00,500.00,7000.00,'2021-12-18 09:17:55','',''),(2311205,'1','200','1025',468,'Retail Sale Id 1357213',30000.00,0.00,0.00,50.00,700.00,'2021-12-18 09:18:48','',''),(2311246,'1','200','1025',468,'Retail Sale Id 1357255',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 09:24:14','',''),(2311247,'1','200','1025',468,'Retail Sale Id 1357255',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 09:24:14','',''),(2311248,'1','200','1025',468,'Retail Sale Id 1357255',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 09:24:14','',''),(2311279,'1','200','1025',468,'Retail Sale Id 1357296',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 09:27:23','',''),(2311294,'1','200','1025',468,'Retail Sale Id 1357307',6320.00,0.00,0.00,10.00,460.00,'2021-12-18 09:28:48','',''),(2311305,'1','200','1025',468,'Retail Sale Id 1357319',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 09:29:47','',''),(2311329,'1','200','1025',468,'Retail Sale Id 1357343',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 09:32:14','',''),(2311342,'1','200','1025',468,'Retail Sale Id 1357356',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 09:33:22','',''),(2311353,'1','200','1025',468,'Retail Sale Id 1357371',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 09:34:50','',''),(2311365,'1','200','1025',468,'Retail Sale Id 1357382',2528.00,0.00,0.00,4.00,184.00,'2021-12-18 09:36:03','',''),(2311400,'1','200','1025',468,'Retail Sale Id 1357413',7078.40,0.00,0.00,11.20,515.20,'2021-12-18 09:38:59','',''),(2311401,'1','200','1025',468,'Retail Sale Id 1357413',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 09:38:59','',''),(2311414,'1','200','1025',468,'Retail Sale Id 1357426',1997.12,0.00,0.00,3.16,145.36,'2021-12-18 09:40:58','',''),(2311427,'1','200','1025',468,'Retail Sale Id 1357441',632.00,0.00,0.00,1.00,46.00,'2021-12-18 09:41:57','',''),(2311453,'1','200','1025',468,'Retail Sale Id 1357465',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 09:44:44','',''),(2311454,'1','200','1025',468,'Retail Sale Id 1357465',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 09:44:44','',''),(2311479,'1','200','1025',468,'Retail Sale Id 1357487',6320.00,0.00,0.00,10.00,460.00,'2021-12-18 09:46:36','',''),(2311492,'1','200','1025',468,'Retail Sale Id 1357506',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 09:48:06','',''),(2311505,'1','200','1025',468,'Retail Sale Id 1357516',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 09:49:22','',''),(2311526,'1','200','1025',468,'Retail Sale Id 1357532',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 09:51:16','',''),(2311542,'1','200','1025',468,'Retail Sale Id 1357552',1497.84,0.00,0.00,2.37,109.02,'2021-12-18 09:52:34','',''),(2311564,'1','200','1025',468,'Retail Sale Id 1357567',1497.84,0.00,0.00,2.37,109.02,'2021-12-18 09:53:37','',''),(2311576,'1','200','1025',468,'Retail Sale Id 1357580',1264.00,0.00,0.00,2.00,92.00,'2021-12-18 09:54:37','',''),(2311740,'1','200','1025',468,'Retail Sale Id 1357698',1264.00,0.00,0.00,2.00,92.00,'2021-12-18 10:08:16','',''),(2311756,'1','200','1025',468,'Retail Sale Id 1357714',96000.00,0.00,0.00,160.00,2240.00,'2021-12-18 10:09:51','',''),(2311945,'1','200','1025',468,'Retail Sale Id 1357852',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 10:24:45','',''),(2311976,'1','200','1025',468,'Retail Sale Id 1357883',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 10:27:41','',''),(2312062,'1','200','1025',468,'Retail Sale Id 1357959',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 10:34:24','',''),(2312094,'1','200','1025',468,'Retail Sale Id 1357992',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 10:36:31','',''),(2312116,'1','200','1025',468,'Retail Sale Id 1358013',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 10:38:10','',''),(2312126,'1','200','1025',468,'Retail Sale Id 1358023',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 10:39:21','',''),(2312198,'1','200','1025',468,'Retail Sale Id 1358099',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 10:45:28','',''),(2312216,'1','200','1025',468,'Retail Sale Id 1358116',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 10:47:20','',''),(2312232,'1','200','1025',468,'Retail Sale Id 1358133',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 10:48:54','',''),(2312276,'1','200','1025',468,'Retail Sale Id 1358163',1997.12,0.00,0.00,3.16,145.36,'2021-12-18 10:51:59','',''),(2312345,'1','200','1025',468,'Retail Sale Id 1358232',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 10:57:42','',''),(2312367,'1','200','1025',468,'Retail Sale Id 1358245',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 10:58:57','',''),(2312376,'1','200','1025',468,'Retail Sale Id 1358254',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 11:00:11','',''),(2312393,'1','200','1025',468,'Retail Sale Id 1358269',1264.00,0.00,0.00,2.00,92.00,'2021-12-18 11:01:41','',''),(2312455,'1','200','1025',468,'Retail Sale Id 1358315',2400.00,0.00,0.00,4.00,56.00,'2021-12-18 11:06:23','',''),(2312653,'1','200','1025',468,'Retail Sale Id 1358465',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 11:19:47','',''),(2312677,'1','200','1025',468,'Retail Sale Id 1358492',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 11:21:55','',''),(2312699,'1','200','1025',468,'Retail Sale Id 1358513',2502.72,0.00,0.00,3.96,182.16,'2021-12-18 11:23:25','',''),(2312715,'1','200','1025',468,'Retail Sale Id 1358530',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 11:25:04','',''),(2312733,'1','200','1025',468,'Retail Sale Id 1358546',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 11:26:28','',''),(2312752,'1','200','1025',468,'Retail Sale Id 1358562',30000.00,0.00,0.00,50.00,700.00,'2021-12-18 11:27:56','',''),(2312767,'1','200','1025',468,'Retail Sale Id 1358578',30600.00,0.00,0.00,51.00,714.00,'2021-12-18 11:29:21','',''),(2312806,'1','200','1025',468,'Retail Sale Id 1358600',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 11:31:55','',''),(2312814,'1','200','1025',468,'Retail Sale Id 1358626',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 11:32:51','',''),(2312863,'1','200','1025',468,'Retail Sale Id 1358672',1264.00,0.00,0.00,2.00,92.00,'2021-12-18 11:36:54','',''),(2312952,'1','200','1025',468,'Retail Sale Id 1358762',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 11:45:59','',''),(2312971,'1','200','1025',468,'Retail Sale Id 1358780',2528.00,0.00,0.00,4.00,184.00,'2021-12-18 11:47:50','',''),(2313001,'1','200','1025',468,'Retail Sale Id 1358810',7584.00,0.00,0.00,12.00,552.00,'2021-12-18 11:51:53','',''),(2313018,'1','200','1025',468,'Retail Sale Id 1358827',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 11:54:21','',''),(2313033,'1','200','1025',468,'Retail Sale Id 1358842',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 11:55:50','',''),(2313060,'1','200','1025',468,'Retail Sale Id 1358863',1997.12,0.00,0.00,3.16,145.36,'2021-12-18 11:59:34','',''),(2313072,'1','200','1025',468,'Retail Sale Id 1358874',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 12:00:52','',''),(2313082,'1','200','1025',468,'Retail Sale Id 1358880',6320.00,0.00,0.00,10.00,460.00,'2021-12-18 12:02:27','',''),(2313096,'1','200','1025',468,'Retail Sale Id 1358898',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 12:04:05','',''),(2313106,'1','200','1025',468,'Retail Sale Id 1358907',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 12:05:13','',''),(2313107,'1','200','1025',468,'Retail Sale Id 1358907',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 12:05:13','',''),(2313123,'1','200','1025',468,'Retail Sale Id 1358921',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 12:06:22','',''),(2313133,'1','200','1025',468,'Retail Sale Id 1358930',31600.00,0.00,0.00,50.00,2300.00,'2021-12-18 12:07:50','',''),(2313141,'1','200','1025',468,'Retail Sale Id 1358941',3002.00,0.00,0.00,4.75,218.50,'2021-12-18 12:08:45','',''),(2313149,'1','200','1025',468,'Retail Sale Id 1358946',3002.00,0.00,0.00,4.75,218.50,'2021-12-18 12:09:30','',''),(2313160,'1','200','1025',468,'Retail Sale Id 1358955',3501.28,0.00,0.00,5.54,254.84,'2021-12-18 12:10:24','',''),(2313172,'1','200','1025',468,'Retail Sale Id 1358971',1497.84,0.00,0.00,2.37,109.02,'2021-12-18 12:11:14','',''),(2313191,'1','200','1025',468,'Retail Sale Id 1358988',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 12:12:58','',''),(2313339,'1','200','1025',468,'Retail Sale Id 1359131',998.56,0.00,0.00,1.58,72.68,'2021-12-18 12:29:02','',''),(2313361,'1','200','1025',468,'Retail Sale Id 1359153',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 12:32:00','',''),(2313449,'1','200','1025',468,'Retail Sale Id 1359218',6320.00,0.00,0.00,10.00,460.00,'2021-12-18 12:39:39','',''),(2313472,'1','200','1025',468,'Retail Sale Id 1359240',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 12:41:20','',''),(2313595,'1','200','1025',468,'Retail Sale Id 1359366',1264.00,0.00,0.00,2.00,92.00,'2021-12-18 12:53:04','',''),(2313625,'1','200','1025',468,'Retail Sale Id 1359387',1264.00,0.00,0.00,2.00,92.00,'2021-12-18 12:55:28','',''),(2313642,'1','200','1025',468,'Retail Sale Id 1359411',1264.00,0.00,0.00,2.00,92.00,'2021-12-18 12:56:56','',''),(2313665,'1','200','1025',468,'Retail Sale Id 1359433',998.56,0.00,0.00,1.58,72.68,'2021-12-18 12:58:44','',''),(2313703,'1','200','1025',468,'Retail Sale Id 1359475',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 13:02:17','',''),(2314046,'1','200','1025',468,'Retail Sale Id 1359763',632.00,0.00,0.00,1.00,46.00,'2021-12-18 13:35:32','',''),(2314139,'1','200','1025',468,'Retail Sale Id 1359844',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 13:43:23','',''),(2314184,'1','200','1025',468,'Retail Sale Id 1359875',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 13:47:08','',''),(2314185,'1','200','1025',468,'Retail Sale Id 1359875',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 13:47:08','',''),(2314278,'1','200','1025',468,'Retail Sale Id 1359918',632.00,0.00,0.00,1.00,46.00,'2021-12-18 13:50:19','',''),(2314355,'1','200','1025',468,'Retail Sale Id 1359957',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 13:54:10','',''),(2314561,'1','200','1025',468,'Retail Sale Id 1360141',1264.00,0.00,0.00,2.00,92.00,'2021-12-18 14:11:01','',''),(2314578,'1','200','1025',468,'Retail Sale Id 1360159',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 14:12:52','',''),(2314611,'1','200','1025',468,'Retail Sale Id 1360180',6320.00,0.00,0.00,10.00,460.00,'2021-12-18 14:15:15','',''),(2314696,'1','200','1025',468,'Retail Sale Id 1360251',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 14:22:34','',''),(2314719,'1','200','1025',468,'Retail Sale Id 1360274',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 14:24:35','',''),(2314812,'1','200','1025',468,'Retail Sale Id 1360356',108000.00,0.00,0.00,180.00,2520.00,'2021-12-18 14:32:37','',''),(2314842,'1','200','1025',468,'Retail Sale Id 1360370',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 14:33:42','',''),(2314866,'1','200','1025',468,'Retail Sale Id 1360400',12600.00,0.00,0.00,21.00,294.00,'2021-12-18 14:35:36','',''),(2314990,'1','200','1025',468,'Retail Sale Id 1360485',60000.00,0.00,0.00,100.00,1400.00,'2021-12-18 14:45:38','',''),(2315045,'1','200','1025',468,'Retail Sale Id 1360536',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 14:50:20','',''),(2315066,'1','200','1025',468,'Retail Sale Id 1360555',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 14:51:59','',''),(2315067,'1','200','1025',468,'Retail Sale Id 1360555',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 14:51:59','',''),(2315082,'1','200','1025',468,'Retail Sale Id 1360570',4740.00,0.00,0.00,7.50,345.00,'2021-12-18 14:53:19','',''),(2315107,'1','200','1025',468,'Retail Sale Id 1360591',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 14:54:52','',''),(2315108,'1','200','1025',468,'Retail Sale Id 1360591',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 14:54:52','',''),(2315130,'1','200','1025',468,'Retail Sale Id 1360609',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 14:56:45','',''),(2315149,'1','200','1025',468,'Retail Sale Id 1360630',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 14:58:37','',''),(2315177,'1','200','1025',468,'Retail Sale Id 1360654',30000.00,0.00,0.00,50.00,700.00,'2021-12-18 15:02:02','',''),(2315213,'1','200','1025',468,'Retail Sale Id 1360697',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 15:05:30','',''),(2315236,'1','200','1025',468,'Retail Sale Id 1360714',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 15:07:05','',''),(2315262,'1','200','1025',468,'Retail Sale Id 1360724',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 15:08:28','',''),(2315295,'1','200','1025',468,'Retail Sale Id 1360751',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 15:11:43','',''),(2315338,'1','200','1025',468,'Retail Sale Id 1360785',150000.00,0.00,0.00,250.00,3500.00,'2021-12-18 15:15:43','',''),(2315393,'1','200','1025',468,'Retail Sale Id 1360837',104400.00,0.00,0.00,174.00,2436.00,'2021-12-18 15:20:05','',''),(2315406,'1','200','1025',468,'Retail Sale Id 1360851',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 15:21:11','',''),(2315438,'1','200','1025',468,'Retail Sale Id 1360882',13200.00,0.00,0.00,22.00,308.00,'2021-12-18 15:23:32','',''),(2315465,'1','200','1025',468,'Retail Sale Id 1360896',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 15:25:16','',''),(2315494,'1','200','1025',468,'Retail Sale Id 1360927',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 15:28:01','',''),(2315508,'1','200','1025',468,'Retail Sale Id 1360939',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 15:29:15','',''),(2315526,'1','200','1025',468,'Retail Sale Id 1360955',7584.00,0.00,0.00,12.00,552.00,'2021-12-18 15:30:32','',''),(2315549,'1','200','1025',468,'Retail Sale Id 1360981',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 15:32:40','',''),(2315573,'1','200','1025',468,'Retail Sale Id 1361001',36000.00,0.00,0.00,60.00,840.00,'2021-12-18 15:34:31','',''),(2315592,'1','200','1025',468,'Retail Sale Id 1361017',3002.00,0.00,0.00,4.75,218.50,'2021-12-18 15:35:31','',''),(2315640,'1','200','1025',468,'Retail Sale Id 1361069',998.56,0.00,0.00,1.58,72.68,'2021-12-18 15:39:28','',''),(2315659,'1','200','1025',468,'Retail Sale Id 1361087',3002.00,0.00,0.00,4.75,218.50,'2021-12-18 15:40:45','',''),(2315672,'1','200','1025',468,'Retail Sale Id 1361103',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 15:42:13','',''),(2315736,'1','200','1025',468,'Retail Sale Id 1361152',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 15:46:55','',''),(2315737,'1','200','1025',468,'Retail Sale Id 1361152',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 15:46:55','',''),(2315764,'1','200','1025',468,'Retail Sale Id 1361177',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 15:47:55','',''),(2315772,'1','200','1025',468,'Retail Sale Id 1361185',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 15:48:42','',''),(2315797,'1','200','1025',468,'Retail Sale Id 1361198',2844.00,0.00,0.00,4.50,207.00,'2021-12-18 15:49:46','',''),(2315817,'1','200','1025',468,'Retail Sale Id 1361209',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 15:50:30','',''),(2315853,'1','200','1025',468,'Retail Sale Id 1361218',2502.72,0.00,0.00,3.96,182.16,'2021-12-18 15:51:18','',''),(2315864,'1','200','1025',468,'Retail Sale Id 1361227',3197.92,0.00,0.00,5.06,232.76,'2021-12-18 15:52:07','',''),(2315899,'1','200','1025',468,'Retail Sale Id 1361268',6320.00,0.00,0.00,10.00,460.00,'2021-12-18 15:54:22','',''),(2315982,'1','200','1025',468,'Retail Sale Id 1361320',30000.00,0.00,0.00,50.00,700.00,'2021-12-18 15:58:49','',''),(2316008,'1','200','1025',468,'Retail Sale Id 1361336',30000.00,0.00,0.00,50.00,700.00,'2021-12-18 15:59:50','',''),(2316045,'1','200','1025',468,'Retail Sale Id 1361369',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 16:01:48','',''),(2316058,'1','200','1025',468,'Retail Sale Id 1361382',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 16:02:45','',''),(2316069,'1','200','1025',468,'Retail Sale Id 1361393',998.56,0.00,0.00,1.58,72.68,'2021-12-18 16:03:51','',''),(2316119,'1','200','1025',468,'Retail Sale Id 1361444',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 16:07:16','',''),(2316165,'1','200','1025',468,'Retail Sale Id 1361489',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 16:10:41','',''),(2316180,'1','200','1025',468,'Retail Sale Id 1361501',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 16:11:40','',''),(2316219,'1','200','1025',468,'Retail Sale Id 1361536',998.56,0.00,0.00,1.58,72.68,'2021-12-18 16:14:17','',''),(2316237,'1','200','1025',468,'Retail Sale Id 1361552',3798.32,0.00,0.00,6.01,276.46,'2021-12-18 16:15:22','',''),(2316297,'1','200','1025',468,'Retail Sale Id 1361602',1264.00,0.00,0.00,2.00,92.00,'2021-12-18 16:19:37','',''),(2316340,'1','200','1025',468,'Retail Sale Id 1361647',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 16:22:45','',''),(2316361,'1','200','1025',468,'Retail Sale Id 1361664',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 16:24:16','',''),(2316387,'1','200','1025',468,'Retail Sale Id 1361691',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 16:25:52','',''),(2316414,'1','200','1025',468,'Retail Sale Id 1361720',30000.00,0.00,0.00,50.00,700.00,'2021-12-18 16:28:12','',''),(2316428,'1','200','1025',468,'Retail Sale Id 1361731',632.00,0.00,0.00,1.00,46.00,'2021-12-18 16:29:14','',''),(2316456,'1','200','1025',468,'Retail Sale Id 1361759',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 16:31:15','',''),(2316589,'1','200','1025',468,'Retail Sale Id 1361901',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 16:42:17','',''),(2316635,'1','200','1025',468,'Retail Sale Id 1361931',3792.00,0.00,0.00,6.00,276.00,'2021-12-18 16:44:36','',''),(2316646,'1','200','1025',468,'Retail Sale Id 1361943',5688.00,0.00,0.00,9.00,414.00,'2021-12-18 16:45:44','',''),(2316659,'1','200','1025',468,'Retail Sale Id 1361954',2528.00,0.00,0.00,4.00,184.00,'2021-12-18 16:46:57','',''),(2316676,'1','200','1025',468,'Retail Sale Id 1361971',5688.00,0.00,0.00,9.00,414.00,'2021-12-18 16:48:33','',''),(2316694,'1','200','1025',468,'Retail Sale Id 1361987',3160.00,0.00,0.00,5.00,230.00,'2021-12-18 16:50:33','',''),(2316695,'1','200','1025',468,'Retail Sale Id 1361987',7584.00,0.00,0.00,12.00,552.00,'2021-12-18 16:50:33','',''),(2316744,'1','200','1025',468,'Retail Sale Id 1362036',1896.00,0.00,0.00,3.00,138.00,'2021-12-18 16:54:11','',''),(2316820,'1','200','1025',468,'Retail Sale Id 1362104',7900.00,0.00,0.00,12.50,575.00,'2021-12-18 16:59:24','',''),(2317890,'1','200','1025',468,'Retail Sale Id 1362795',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 06:08:26','',''),(2318073,'1','200','1025',468,'Retail Sale Id 1362876',998.56,0.00,0.00,1.58,72.68,'2021-12-19 06:36:18','',''),(2318082,'1','200','1025',468,'Retail Sale Id 1362886',3002.00,0.00,0.00,4.75,218.50,'2021-12-19 06:37:59','',''),(2318223,'1','200','1025',468,'Retail Sale Id 1363015',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 06:54:15','',''),(2318278,'1','200','1025',468,'Retail Sale Id 1363070',33000.00,0.00,0.00,55.00,770.00,'2021-12-19 07:00:27','',''),(2318358,'1','200','1025',468,'Retail Sale Id 1363147',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 07:09:29','',''),(2318445,'1','200','1025',468,'Retail Sale Id 1363208',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 07:15:34','',''),(2318457,'1','200','1025',468,'Retail Sale Id 1363220',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 07:16:56','',''),(2318510,'1','200','1025',468,'Retail Sale Id 1363277',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 07:21:43','',''),(2318532,'1','200','1025',468,'Retail Sale Id 1363300',27600.00,0.00,0.00,46.00,644.00,'2021-12-19 07:23:51','',''),(2318546,'1','200','1025',468,'Retail Sale Id 1363314',499.28,0.00,0.00,0.79,36.34,'2021-12-19 07:25:02','',''),(2318623,'1','200','1025',468,'Retail Sale Id 1363387',2528.00,0.00,0.00,4.00,184.00,'2021-12-19 07:31:26','',''),(2318733,'1','200','1025',468,'Retail Sale Id 1363493',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 07:41:11','',''),(2318750,'1','200','1025',468,'Retail Sale Id 1363505',2528.00,0.00,0.00,4.00,184.00,'2021-12-19 07:42:31','',''),(2318772,'1','200','1025',468,'Retail Sale Id 1363525',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 07:44:23','',''),(2318780,'1','200','1025',468,'Retail Sale Id 1363535',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 07:45:17','',''),(2318880,'1','200','1025',468,'Retail Sale Id 1363596',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 07:52:12','',''),(2318900,'1','200','1025',468,'Retail Sale Id 1363605',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 07:53:27','',''),(2318934,'1','200','1025',468,'Retail Sale Id 1363631',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 07:56:13','',''),(2318945,'1','200','1025',468,'Retail Sale Id 1363640',6320.00,0.00,0.00,10.00,460.00,'2021-12-19 07:57:25','',''),(2319031,'1','200','1025',468,'Retail Sale Id 1363705',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 08:05:10','',''),(2319080,'1','200','1025',468,'Retail Sale Id 1363755',6320.00,0.00,0.00,10.00,460.00,'2021-12-19 08:10:17','',''),(2319134,'1','200','1025',468,'Retail Sale Id 1363809',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 08:16:49','',''),(2319135,'1','200','1025',468,'Retail Sale Id 1363809',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 08:16:49','',''),(2319136,'1','200','1025',468,'Retail Sale Id 1363809',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 08:16:49','',''),(2319156,'1','200','1025',468,'Retail Sale Id 1363823',7584.00,0.00,0.00,12.00,552.00,'2021-12-19 08:19:14','',''),(2319279,'1','200','1025',468,'Retail Sale Id 1363912',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 08:27:02','',''),(2319294,'1','200','1025',468,'Retail Sale Id 1363935',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 08:28:26','',''),(2319306,'1','200','1025',468,'Retail Sale Id 1363945',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 08:29:35','',''),(2319331,'1','200','1025',468,'Retail Sale Id 1363966',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 08:31:13','',''),(2319444,'1','200','1025',468,'Retail Sale Id 1364018',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 08:36:24','',''),(2319475,'1','200','1025',468,'Retail Sale Id 1364041',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 08:38:38','',''),(2319541,'1','200','1025',468,'Retail Sale Id 1364083',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 08:43:53','',''),(2319562,'1','200','1025',468,'Retail Sale Id 1364102',632.00,0.00,0.00,1.00,46.00,'2021-12-19 08:46:04','',''),(2319595,'1','200','1025',468,'Retail Sale Id 1364126',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 08:49:16','',''),(2319611,'1','200','1025',468,'Retail Sale Id 1364141',5688.00,0.00,0.00,9.00,414.00,'2021-12-19 08:51:36','',''),(2319644,'1','200','1025',468,'Retail Sale Id 1364170',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 08:55:20','',''),(2319662,'1','200','1025',468,'Retail Sale Id 1364185',632.00,0.00,0.00,1.00,46.00,'2021-12-19 08:57:03','',''),(2319669,'1','200','1025',468,'Retail Sale Id 1364193',1997.12,0.00,0.00,3.16,145.36,'2021-12-19 08:58:06','',''),(2319679,'1','200','1025',468,'Retail Sale Id 1364201',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 08:59:59','',''),(2319688,'1','200','1025',468,'Retail Sale Id 1364217',5688.00,0.00,0.00,9.00,414.00,'2021-12-19 09:01:57','',''),(2319824,'1','200','1025',468,'Retail Sale Id 1364311',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 09:13:59','',''),(2319844,'1','200','1025',468,'Retail Sale Id 1364319',4999.12,0.00,0.00,7.91,363.86,'2021-12-19 09:15:00','',''),(2319864,'1','200','1025',468,'Retail Sale Id 1364337',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 09:16:52','',''),(2319865,'1','200','1025',468,'Retail Sale Id 1364337',7584.00,0.00,0.00,12.00,552.00,'2021-12-19 09:16:52','',''),(2319881,'1','200','1025',468,'Retail Sale Id 1364347',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 09:17:43','',''),(2319934,'1','200','1025',468,'Retail Sale Id 1364366',2528.00,0.00,0.00,4.00,184.00,'2021-12-19 09:18:57','',''),(2320005,'1','200','1025',468,'Retail Sale Id 1364398',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 09:22:29','',''),(2320006,'1','200','1025',468,'Retail Sale Id 1364398',4108.00,0.00,0.00,6.50,299.00,'2021-12-19 09:22:29','',''),(2320056,'1','200','1025',468,'Retail Sale Id 1364435',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 09:24:30','',''),(2320057,'1','200','1025',468,'Retail Sale Id 1364435',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 09:24:30','',''),(2320078,'1','200','1025',468,'Retail Sale Id 1364444',2502.72,0.00,0.00,3.96,182.16,'2021-12-19 09:25:19','',''),(2320108,'1','200','1025',468,'Retail Sale Id 1364458',1497.84,0.00,0.00,2.37,109.02,'2021-12-19 09:26:28','',''),(2320300,'1','200','1025',468,'Retail Sale Id 1364623',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 09:39:44','',''),(2320499,'1','200','1025',468,'Retail Sale Id 1364820',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 09:57:19','',''),(2320519,'1','200','1025',468,'Retail Sale Id 1364842',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 09:58:57','',''),(2320542,'1','200','1025',468,'Retail Sale Id 1364859',69000.00,0.00,0.00,115.00,1610.00,'2021-12-19 10:01:00','',''),(2320548,'1','200','1025',468,'Retail Sale Id 1364874',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 10:01:52','',''),(2320571,'1','200','1025',468,'Retail Sale Id 1364886',6320.00,0.00,0.00,10.00,460.00,'2021-12-19 10:03:26','',''),(2320676,'1','200','1025',468,'Retail Sale Id 1364992',31600.00,0.00,0.00,50.00,2300.00,'2021-12-19 10:11:00','',''),(2320710,'1','200','1025',468,'Retail Sale Id 1365020',1497.84,0.00,0.00,2.37,109.02,'2021-12-19 10:12:45','',''),(2320757,'1','200','1025',468,'Retail Sale Id 1365073',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 10:16:52','',''),(2320769,'1','200','1025',468,'Retail Sale Id 1365085',802.64,0.00,0.00,1.27,58.42,'2021-12-19 10:17:52','',''),(2320779,'1','200','1025',468,'Retail Sale Id 1365094',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 10:18:49','',''),(2320800,'1','200','1025',468,'Retail Sale Id 1365116',1264.00,0.00,0.00,2.00,92.00,'2021-12-19 10:20:48','',''),(2320801,'1','200','1025',468,'Retail Sale Id 1365116',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 10:20:48','',''),(2320820,'1','200','1025',468,'Retail Sale Id 1365135',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 10:22:23','',''),(2320940,'1','200','1025',468,'Retail Sale Id 1365238',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 10:31:14','',''),(2320956,'1','200','1025',468,'Retail Sale Id 1365251',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 10:32:21','',''),(2321012,'1','200','1025',468,'Retail Sale Id 1365319',1997.12,0.00,0.00,3.16,145.36,'2021-12-19 10:38:17','',''),(2321031,'1','200','1025',468,'Retail Sale Id 1365339',1997.12,0.00,0.00,3.16,145.36,'2021-12-19 10:40:07','',''),(2321049,'1','200','1025',468,'Retail Sale Id 1365354',1264.00,0.00,0.00,2.00,92.00,'2021-12-19 10:41:40','',''),(2321216,'1','200','1025',468,'Retail Sale Id 1365524',6320.00,0.00,0.00,10.00,460.00,'2021-12-19 10:56:49','',''),(2321217,'1','200','1025',468,'Retail Sale Id 1365524',6320.00,0.00,0.00,10.00,460.00,'2021-12-19 10:56:49','',''),(2321242,'1','200','1025',468,'Retail Sale Id 1365550',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 10:58:36','',''),(2321256,'1','200','1025',468,'Retail Sale Id 1365568',998.56,0.00,0.00,1.58,72.68,'2021-12-19 10:59:59','',''),(2321279,'1','200','1025',468,'Retail Sale Id 1365588',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 11:01:27','',''),(2321328,'1','200','1025',468,'Retail Sale Id 1365639',600.40,0.00,0.00,0.95,43.70,'2021-12-19 11:06:00','',''),(2321455,'1','200','1025',468,'Retail Sale Id 1365749',1264.00,0.00,0.00,2.00,92.00,'2021-12-19 11:14:32','',''),(2321529,'1','200','1025',468,'Retail Sale Id 1365823',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 11:20:36','',''),(2321574,'1','200','1025',468,'Retail Sale Id 1365861',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 11:24:31','',''),(2321608,'1','200','1025',468,'Retail Sale Id 1365890',47400.00,0.00,0.00,79.00,1106.00,'2021-12-19 11:26:34','',''),(2321621,'1','200','1025',468,'Retail Sale Id 1365904',42000.00,0.00,0.00,70.00,980.00,'2021-12-19 11:27:44','',''),(2321633,'1','200','1025',468,'Retail Sale Id 1365917',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 11:28:28','',''),(2321900,'1','200','1025',468,'Retail Sale Id 1366161',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 11:51:44','',''),(2321969,'1','200','1025',468,'Retail Sale Id 1366224',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 11:56:59','',''),(2321978,'1','200','1025',468,'Retail Sale Id 1366234',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 11:57:58','',''),(2322018,'1','200','1025',468,'Retail Sale Id 1366273',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 12:01:21','',''),(2322026,'1','200','1025',468,'Retail Sale Id 1366281',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 12:02:12','',''),(2322056,'1','200','1025',468,'Retail Sale Id 1366314',1997.12,0.00,0.00,3.16,145.36,'2021-12-19 12:04:50','',''),(2322092,'1','200','1025',468,'Retail Sale Id 1366350',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 12:08:27','',''),(2322115,'1','200','1025',468,'Retail Sale Id 1366367',7800.00,0.00,0.00,13.00,182.00,'2021-12-19 12:10:24','',''),(2322125,'1','200','1025',468,'Retail Sale Id 1366378',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 12:11:20','',''),(2322138,'1','200','1025',468,'Retail Sale Id 1366390',151800.00,0.00,0.00,253.00,3542.00,'2021-12-19 12:12:16','',''),(2322188,'1','200','1025',468,'Retail Sale Id 1366450',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 12:16:35','',''),(2322189,'1','200','1025',468,'Retail Sale Id 1366450',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 12:16:35','',''),(2322214,'1','200','1025',468,'Retail Sale Id 1366468',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 12:19:04','',''),(2322215,'1','200','1025',468,'Retail Sale Id 1366468',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 12:19:04','',''),(2322368,'1','200','1025',468,'Retail Sale Id 1366622',1997.12,0.00,0.00,3.16,145.36,'2021-12-19 12:35:13','',''),(2322376,'1','200','1025',468,'Retail Sale Id 1366634',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 12:36:03','',''),(2322397,'1','200','1025',468,'Retail Sale Id 1366657',3501.28,0.00,0.00,5.54,254.84,'2021-12-19 12:39:08','',''),(2322424,'1','200','1025',468,'Retail Sale Id 1366669',6320.00,0.00,0.00,10.00,460.00,'2021-12-19 12:40:38','',''),(2322440,'1','200','1025',468,'Retail Sale Id 1366681',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 12:42:35','',''),(2322441,'1','200','1025',468,'Retail Sale Id 1366681',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 12:42:35','',''),(2322459,'1','200','1025',468,'Retail Sale Id 1366700',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 12:44:33','',''),(2322529,'1','200','1025',468,'Retail Sale Id 1366754',1264.00,0.00,0.00,2.00,92.00,'2021-12-19 12:48:39','',''),(2322535,'1','200','1025',468,'Return of Retail Sale Id 1366681',0.00,3792.00,6.00,0.00,-276.00,'2021-12-19 12:49:14','',''),(2322536,'1','200','1025',468,'Return of Retail Sale Id 1366681',0.00,7900.00,12.50,0.00,-575.00,'2021-12-19 12:49:14','',''),(2322554,'1','200','1025',468,'Retail Sale Id 1366775',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 12:50:30','',''),(2322555,'1','200','1025',468,'Retail Sale Id 1366775',6320.00,0.00,0.00,10.00,460.00,'2021-12-19 12:50:30','',''),(2322571,'1','200','1025',468,'Retail Sale Id 1366789',2502.72,0.00,0.00,3.96,182.16,'2021-12-19 12:51:51','',''),(2322668,'1','200','1025',468,'Retail Sale Id 1366888',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 12:59:47','',''),(2322742,'1','200','1025',468,'Retail Sale Id 1366964',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 13:08:14','',''),(2322783,'1','200','1025',468,'Retail Sale Id 1367002',10800.00,0.00,0.00,18.00,252.00,'2021-12-19 13:11:15','',''),(2322833,'1','200','1025',468,'Retail Sale Id 1367048',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 13:16:26','',''),(2322924,'1','200','1025',468,'Retail Sale Id 1367129',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 13:24:10','',''),(2322949,'1','200','1025',468,'Retail Sale Id 1367154',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 13:25:56','',''),(2323004,'1','200','1025',468,'Retail Sale Id 1367193',4000.56,0.00,0.00,6.33,291.18,'2021-12-19 13:30:08','',''),(2323024,'1','200','1025',468,'Retail Sale Id 1367204',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 13:31:31','',''),(2323041,'1','200','1025',468,'Retail Sale Id 1367219',2528.00,0.00,0.00,4.00,184.00,'2021-12-19 13:32:32','',''),(2323058,'1','200','1025',468,'Retail Sale Id 1367231',5997.68,0.00,0.00,9.49,436.54,'2021-12-19 13:33:30','',''),(2323258,'1','200','1025',468,'Retail Sale Id 1367373',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 13:48:57','',''),(2323360,'1','200','1025',468,'Retail Sale Id 1367464',4999.12,0.00,0.00,7.91,363.86,'2021-12-19 13:56:19','',''),(2323392,'1','200','1025',468,'Retail Sale Id 1367489',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 13:58:12','',''),(2323393,'1','200','1025',468,'Retail Sale Id 1367489',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 13:58:12','',''),(2323457,'1','200','1025',468,'Retail Sale Id 1367542',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 14:01:06','',''),(2323458,'1','200','1025',468,'Retail Sale Id 1367542',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 14:01:06','',''),(2323614,'1','200','1025',468,'Retail Sale Id 1367662',57000.00,0.00,0.00,95.00,1330.00,'2021-12-19 14:11:26','',''),(2323625,'1','200','1025',468,'Retail Sale Id 1367675',3002.00,0.00,0.00,4.75,218.50,'2021-12-19 14:12:31','',''),(2323674,'1','200','1025',468,'Retail Sale Id 1367719',42000.00,0.00,0.00,70.00,980.00,'2021-12-19 14:16:42','',''),(2323696,'1','200','1025',468,'Retail Sale Id 1367744',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 14:19:06','',''),(2323761,'1','200','1025',468,'Retail Sale Id 1367797',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 14:24:57','',''),(2323788,'1','200','1025',468,'Retail Sale Id 1367825',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 14:27:58','',''),(2323845,'1','200','1025',468,'Retail Sale Id 1367866',91200.00,0.00,0.00,152.00,2128.00,'2021-12-19 14:32:17','',''),(2323875,'1','200','1025',468,'Retail Sale Id 1367895',1264.00,0.00,0.00,2.00,92.00,'2021-12-19 14:35:39','',''),(2323912,'1','200','1025',468,'Retail Sale Id 1367922',1997.12,0.00,0.00,3.16,145.36,'2021-12-19 14:37:49','',''),(2323924,'1','200','1025',468,'Retail Sale Id 1367936',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 14:39:07','',''),(2323956,'1','200','1025',468,'Retail Sale Id 1367965',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 14:42:41','',''),(2324000,'1','200','1025',468,'Retail Sale Id 1368008',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 14:46:43','',''),(2324016,'1','200','1025',468,'Retail Sale Id 1368024',2528.00,0.00,0.00,4.00,184.00,'2021-12-19 14:47:57','',''),(2324061,'1','200','1025',468,'Retail Sale Id 1368073',108000.00,0.00,0.00,180.00,2520.00,'2021-12-19 14:52:16','',''),(2324107,'1','200','1025',468,'Retail Sale Id 1368120',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 14:58:44','',''),(2324140,'1','200','1025',468,'Retail Sale Id 1368150',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 15:02:36','',''),(2324162,'1','200','1025',468,'Retail Sale Id 1368165',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 15:04:15','',''),(2324279,'1','200','1025',468,'Retail Sale Id 1368280',2528.00,0.00,0.00,4.00,184.00,'2021-12-19 15:16:57','',''),(2324341,'1','200','1025',468,'Retail Sale Id 1368320',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 15:22:40','',''),(2324356,'1','200','1025',468,'Retail Sale Id 1368337',1997.12,0.00,0.00,3.16,145.36,'2021-12-19 15:24:19','',''),(2324370,'1','200','1025',468,'Retail Sale Id 1368348',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 15:25:56','',''),(2324405,'1','200','1025',468,'Retail Sale Id 1368378',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 15:29:32','',''),(2324461,'1','200','1025',468,'Retail Sale Id 1368434',2528.00,0.00,0.00,4.00,184.00,'2021-12-19 15:35:19','',''),(2324589,'1','200','1025',468,'Retail Sale Id 1368554',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 15:47:28','',''),(2324634,'1','200','1025',468,'Retail Sale Id 1368603',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 15:51:27','',''),(2324652,'1','200','1025',468,'Retail Sale Id 1368622',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 15:53:09','',''),(2324701,'1','200','1025',468,'Retail Sale Id 1368653',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 15:56:42','',''),(2324783,'1','200','1025',468,'Retail Sale Id 1368715',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 16:02:08','',''),(2324809,'1','200','1025',468,'Retail Sale Id 1368740',6320.00,0.00,0.00,10.00,460.00,'2021-12-19 16:05:39','',''),(2324825,'1','200','1025',468,'Retail Sale Id 1368754',897.44,0.00,0.00,1.42,65.32,'2021-12-19 16:07:21','',''),(2324836,'1','200','1025',468,'Retail Sale Id 1368769',3160.00,0.00,0.00,5.00,230.00,'2021-12-19 16:08:46','',''),(2324857,'1','200','1025',468,'Retail Sale Id 1368790',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 16:11:14','',''),(2324932,'1','200','1025',468,'Retail Sale Id 1368860',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 16:19:54','',''),(2324943,'1','200','1025',468,'Retail Sale Id 1368876',7900.00,0.00,0.00,12.50,575.00,'2021-12-19 16:21:12','',''),(2324979,'1','200','1025',468,'Retail Sale Id 1368896',5688.00,0.00,0.00,9.00,414.00,'2021-12-19 16:23:43','',''),(2325007,'1','200','1025',468,'Retail Sale Id 1368912',13800.00,0.00,0.00,23.00,322.00,'2021-12-19 16:25:54','',''),(2325078,'1','200','1025',468,'Retail Sale Id 1368947',600.40,0.00,0.00,0.95,43.70,'2021-12-19 16:30:21','',''),(2325091,'1','200','1025',468,'Retail Sale Id 1368959',1896.00,0.00,0.00,3.00,138.00,'2021-12-19 16:31:38','',''),(2325270,'1','200','1025',468,'Retail Sale Id 1369096',3002.00,0.00,0.00,4.75,218.50,'2021-12-19 16:48:44','',''),(2325279,'1','200','1025',468,'Retail Sale Id 1369105',6320.00,0.00,0.00,10.00,460.00,'2021-12-19 16:50:29','',''),(2325368,'1','200','1025',468,'Retail Sale Id 1369162',3792.00,0.00,0.00,6.00,276.00,'2021-12-19 16:59:00','',''),(2325399,'1','200','1025',468,'Retail Sale Id 1369194',2502.72,0.00,0.00,3.96,182.16,'2021-12-19 17:01:57','',''),(2325418,'1','200','1025',468,'Retail Sale Id 1369211',2528.00,0.00,0.00,4.00,184.00,'2021-12-19 17:04:19','',''),(2326354,'1','200','1025',468,'Retail Sale Id 1369713',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 06:45:23','',''),(2326542,'1','200','1025',468,'Retail Sale Id 1369823',3697.20,0.00,0.00,5.85,269.10,'2021-12-20 07:03:45','',''),(2326571,'1','200','1025',468,'Retail Sale Id 1369850',1497.84,0.00,0.00,2.37,109.02,'2021-12-20 07:07:14','',''),(2326587,'1','200','1025',468,'Retail Sale Id 1369867',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 07:09:09','',''),(2326729,'1','200','1025',468,'Retail Sale Id 1369978',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 07:24:22','',''),(2326730,'1','200','1025',468,'Retail Sale Id 1369978',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 07:24:22','',''),(2326754,'1','200','1025',468,'Retail Sale Id 1370001',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 07:27:56','',''),(2326779,'1','200','1025',468,'Retail Sale Id 1370026',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 07:31:39','',''),(2326867,'1','200','1025',468,'Retail Sale Id 1370097',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 07:41:47','',''),(2326943,'1','200','1025',468,'Retail Sale Id 1370130',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 07:46:25','',''),(2327092,'1','200','1025',468,'Retail Sale Id 1370230',1997.12,0.00,0.00,3.16,145.36,'2021-12-20 08:00:15','',''),(2327100,'1','200','1025',468,'Retail Sale Id 1370236',21000.00,0.00,0.00,35.00,490.00,'2021-12-20 08:01:27','',''),(2327108,'1','200','1025',468,'Retail Sale Id 1370251',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 08:02:28','',''),(2327124,'1','200','1025',468,'Retail Sale Id 1370266',6320.00,0.00,0.00,10.00,460.00,'2021-12-20 08:04:43','',''),(2327230,'1','200','1025',468,'Retail Sale Id 1370376',36000.00,0.00,0.00,60.00,840.00,'2021-12-20 08:21:07','',''),(2327242,'1','200','1025',468,'Retail Sale Id 1370388',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 08:22:30','',''),(2327250,'1','200','1025',468,'Retail Sale Id 1370399',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 08:24:16','',''),(2327275,'1','200','1025',468,'Retail Sale Id 1370424',1264.00,0.00,0.00,2.00,92.00,'2021-12-20 08:27:36','',''),(2327286,'1','200','1025',468,'Retail Sale Id 1370436',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 08:28:41','',''),(2327297,'1','200','1025',468,'Retail Sale Id 1370445',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 08:29:46','',''),(2327395,'1','200','1025',468,'Retail Sale Id 1370538',7584.00,0.00,0.00,12.00,552.00,'2021-12-20 08:41:35','',''),(2327434,'1','200','1025',468,'Retail Sale Id 1370572',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 08:46:20','',''),(2327435,'1','200','1025',468,'Retail Sale Id 1370572',3103.12,0.00,0.00,4.91,225.86,'2021-12-20 08:46:20','',''),(2327465,'1','200','1025',468,'Retail Sale Id 1370611',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 08:51:02','',''),(2327547,'1','200','1025',468,'Retail Sale Id 1370673',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 09:01:23','',''),(2327662,'1','200','1025',468,'Retail Sale Id 1370757',18000.00,0.00,0.00,30.00,420.00,'2021-12-20 09:14:42','',''),(2327675,'1','200','1025',468,'Retail Sale Id 1370767',2528.00,0.00,0.00,4.00,184.00,'2021-12-20 09:16:09','',''),(2327690,'1','200','1025',468,'Retail Sale Id 1370780',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 09:17:35','',''),(2327734,'1','200','1025',468,'Retail Sale Id 1370823',1997.12,0.00,0.00,3.16,145.36,'2021-12-20 09:24:51','',''),(2327745,'1','200','1025',468,'Retail Sale Id 1370832',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 09:26:16','',''),(2327787,'1','200','1025',468,'Retail Sale Id 1370847',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 09:28:47','',''),(2327848,'1','200','1025',468,'Retail Sale Id 1370891',1598.96,0.00,0.00,2.53,116.38,'2021-12-20 09:35:49','',''),(2327909,'1','200','1025',468,'Retail Sale Id 1370949',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 09:45:32','',''),(2327918,'1','200','1025',468,'Retail Sale Id 1370959',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 09:46:45','',''),(2327937,'1','200','1025',468,'Retail Sale Id 1370978',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 09:49:42','',''),(2328052,'1','200','1025',468,'Retail Sale Id 1371045',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 10:00:24','',''),(2328053,'1','200','1025',468,'Retail Sale Id 1371045',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 10:00:24','',''),(2328091,'1','200','1025',468,'Retail Sale Id 1371080',4000.56,0.00,0.00,6.33,291.18,'2021-12-20 10:05:52','',''),(2328109,'1','200','1025',468,'Retail Sale Id 1371089',1264.00,0.00,0.00,2.00,92.00,'2021-12-20 10:07:26','',''),(2328180,'1','200','1025',468,'Retail Sale Id 1371148',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 10:18:44','',''),(2328205,'1','200','1025',468,'Retail Sale Id 1371176',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 10:22:12','',''),(2328225,'1','200','1025',468,'Retail Sale Id 1371197',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 10:24:27','',''),(2328236,'1','200','1025',468,'Retail Sale Id 1371209',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 10:25:55','',''),(2328262,'1','200','1025',468,'Retail Sale Id 1371236',30000.00,0.00,0.00,50.00,700.00,'2021-12-20 10:29:12','',''),(2328271,'1','200','1025',468,'Retail Sale Id 1371245',4000.56,0.00,0.00,6.33,291.18,'2021-12-20 10:30:34','',''),(2328428,'1','200','1025',468,'Retail Sale Id 1371379',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 10:44:54','',''),(2328438,'1','200','1025',468,'Retail Sale Id 1371389',1264.00,0.00,0.00,2.00,92.00,'2021-12-20 10:46:16','',''),(2328564,'1','200','1025',468,'Retail Sale Id 1371513',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 10:58:59','',''),(2328619,'1','200','1025',468,'Retail Sale Id 1371562',4999.12,0.00,0.00,7.91,363.86,'2021-12-20 11:03:26','',''),(2328673,'1','200','1025',468,'Retail Sale Id 1371608',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 11:08:36','',''),(2328686,'1','200','1025',468,'Retail Sale Id 1371622',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 11:09:44','',''),(2328727,'1','200','1025',468,'Retail Sale Id 1371653',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 11:13:40','',''),(2328728,'1','200','1025',468,'Retail Sale Id 1371653',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 11:13:40','',''),(2328871,'1','200','1025',468,'Retail Sale Id 1371792',1264.00,0.00,0.00,2.00,92.00,'2021-12-20 11:30:05','',''),(2328916,'1','200','1025',468,'Retail Sale Id 1371842',998.56,0.00,0.00,1.58,72.68,'2021-12-20 11:34:42','',''),(2328983,'1','200','1025',468,'Retail Sale Id 1371914',1580.00,0.00,0.00,2.50,115.00,'2021-12-20 11:41:41','',''),(2328998,'1','200','1025',468,'Retail Sale Id 1371925',57360.00,0.00,0.00,95.60,1338.40,'2021-12-20 11:43:08','',''),(2329010,'1','200','1025',468,'Retail Sale Id 1371938',9000.00,0.00,0.00,15.00,210.00,'2021-12-20 11:44:17','',''),(2329075,'1','200','1025',468,'Retail Sale Id 1371998',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 11:52:01','',''),(2329082,'1','200','1025',468,'Retail Sale Id 1372007',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 11:53:10','',''),(2329096,'1','200','1025',468,'Retail Sale Id 1372021',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 11:54:44','',''),(2329136,'1','200','1025',468,'Retail Sale Id 1372059',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 12:00:10','',''),(2329166,'1','200','1025',468,'Retail Sale Id 1372092',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 12:05:14','',''),(2329174,'1','200','1025',468,'Retail Sale Id 1372103',1497.84,0.00,0.00,2.37,109.02,'2021-12-20 12:06:40','',''),(2329193,'1','200','1025',468,'Retail Sale Id 1372121',1997.12,0.00,0.00,3.16,145.36,'2021-12-20 12:09:07','',''),(2329217,'1','200','1025',468,'Retail Sale Id 1372143',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 12:11:31','',''),(2329232,'1','200','1025',468,'Retail Sale Id 1372155',632.00,0.00,0.00,1.00,46.00,'2021-12-20 12:12:47','',''),(2329305,'1','200','1025',468,'Retail Sale Id 1372211',31600.00,0.00,0.00,50.00,2300.00,'2021-12-20 12:19:00','',''),(2329340,'1','200','1025',468,'Retail Sale Id 1372235',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 12:21:31','',''),(2329385,'1','200','1025',468,'Retail Sale Id 1372278',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 12:27:22','',''),(2329431,'1','200','1025',468,'Retail Sale Id 1372331',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 12:32:18','',''),(2329607,'1','200','1025',468,'Retail Sale Id 1372424',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 12:44:20','',''),(2329625,'1','200','1025',468,'Retail Sale Id 1372435',1497.84,0.00,0.00,2.37,109.02,'2021-12-20 12:45:30','',''),(2329684,'1','200','1025',468,'Retail Sale Id 1372462',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 12:50:32','',''),(2329685,'1','200','1025',468,'Retail Sale Id 1372462',7584.00,0.00,0.00,12.00,552.00,'2021-12-20 12:50:32','',''),(2329702,'1','200','1025',468,'Retail Sale Id 1372474',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 12:51:38','',''),(2329794,'1','200','1025',468,'Retail Sale Id 1372551',4000.56,0.00,0.00,6.33,291.18,'2021-12-20 13:01:27','',''),(2329853,'1','200','1025',468,'Retail Sale Id 1372598',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 13:09:06','',''),(2329910,'1','200','1025',468,'Retail Sale Id 1372650',2844.00,0.00,0.00,4.50,207.00,'2021-12-20 13:15:40','',''),(2329921,'1','200','1025',468,'Retail Sale Id 1372661',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 13:16:50','',''),(2329995,'1','200','1025',468,'Retail Sale Id 1372694',3002.00,0.00,0.00,4.75,218.50,'2021-12-20 13:21:29','',''),(2330004,'1','200','1025',468,'Retail Sale Id 1372702',998.56,0.00,0.00,1.58,72.68,'2021-12-20 13:22:39','',''),(2330019,'1','200','1025',468,'Retail Sale Id 1372707',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 13:23:39','',''),(2330059,'1','200','1025',468,'Retail Sale Id 1372729',632.00,0.00,0.00,1.00,46.00,'2021-12-20 13:26:19','',''),(2330075,'1','200','1025',468,'Retail Sale Id 1372745',2528.00,0.00,0.00,4.00,184.00,'2021-12-20 13:27:26','',''),(2330107,'1','200','1025',468,'Retail Sale Id 1372765',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 13:29:10','',''),(2330149,'1','200','1025',468,'Retail Sale Id 1372793',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 13:34:03','',''),(2330279,'1','200','1025',468,'Retail Sale Id 1372866',6320.00,0.00,0.00,10.00,460.00,'2021-12-20 13:43:25','',''),(2330284,'1','200','1025',468,'Retail Sale Id 1372871',600.40,0.00,0.00,0.95,43.70,'2021-12-20 13:44:51','',''),(2330314,'1','200','1025',468,'Retail Sale Id 1372895',72000.00,0.00,0.00,120.00,1680.00,'2021-12-20 13:48:18','',''),(2330355,'1','200','1025',468,'Retail Sale Id 1372911',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 13:50:17','',''),(2330448,'1','200','1025',468,'Retail Sale Id 1372969',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 13:57:55','',''),(2330457,'1','200','1025',468,'Retail Sale Id 1372982',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 13:59:06','',''),(2330458,'1','200','1025',468,'Retail Sale Id 1372982',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 13:59:06','',''),(2330530,'1','200','1025',468,'Retail Sale Id 1373034',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 14:04:31','',''),(2330545,'1','200','1025',468,'Retail Sale Id 1373042',2502.72,0.00,0.00,3.96,182.16,'2021-12-20 14:05:36','',''),(2330608,'1','200','1025',468,'Retail Sale Id 1373107',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 14:12:52','',''),(2330754,'1','200','1025',468,'Retail Sale Id 1373217',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 14:27:31','',''),(2330777,'1','200','1025',468,'Retail Sale Id 1373227',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 14:28:55','',''),(2330778,'1','200','1025',468,'Retail Sale Id 1373227',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 14:28:55','',''),(2330863,'1','200','1025',468,'Retail Sale Id 1373268',6320.00,0.00,0.00,10.00,460.00,'2021-12-20 14:35:47','',''),(2330900,'1','200','1025',468,'Retail Sale Id 1373294',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 14:38:14','',''),(2330920,'1','200','1025',468,'Retail Sale Id 1373309',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 14:39:48','',''),(2330964,'1','200','1025',468,'Retail Sale Id 1373341',4424.00,0.00,0.00,7.00,322.00,'2021-12-20 14:43:45','',''),(2330984,'1','200','1025',468,'Retail Sale Id 1373352',2528.00,0.00,0.00,4.00,184.00,'2021-12-20 14:44:48','',''),(2331032,'1','200','1025',468,'Retail Sale Id 1373381',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 14:49:10','',''),(2331069,'1','200','1025',468,'Retail Sale Id 1373415',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 14:52:26','',''),(2331098,'1','200','1025',468,'Retail Sale Id 1373444',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 14:54:35','',''),(2331099,'1','200','1025',468,'Retail Sale Id 1373444',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 14:54:35','',''),(2331106,'1','200','1025',468,'Retail Sale Id 1373451',2528.00,0.00,0.00,4.00,184.00,'2021-12-20 14:55:29','',''),(2331130,'1','200','1025',468,'Retail Sale Id 1373474',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 14:57:54','',''),(2331302,'1','200','1025',468,'Retail Sale Id 1373619',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 15:17:57','',''),(2331319,'1','200','1025',468,'Retail Sale Id 1373635',5400.00,0.00,0.00,9.00,126.00,'2021-12-20 15:19:57','',''),(2331376,'1','200','1025',468,'Retail Sale Id 1373689',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 15:25:47','',''),(2331398,'1','200','1025',468,'Retail Sale Id 1373708',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 15:27:20','',''),(2331408,'1','200','1025',468,'Retail Sale Id 1373720',4000.56,0.00,0.00,6.33,291.18,'2021-12-20 15:28:34','',''),(2331425,'1','200','1025',468,'Retail Sale Id 1373735',2528.00,0.00,0.00,4.00,184.00,'2021-12-20 15:29:38','',''),(2331456,'1','200','1025',468,'Retail Sale Id 1373747',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 15:31:11','',''),(2331485,'1','200','1025',468,'Retail Sale Id 1373775',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 15:33:24','',''),(2331486,'1','200','1025',468,'Retail Sale Id 1373775',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 15:33:24','',''),(2331498,'1','200','1025',468,'Retail Sale Id 1373781',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 15:34:38','',''),(2331509,'1','200','1025',468,'Retail Sale Id 1373789',2528.00,0.00,0.00,4.00,184.00,'2021-12-20 15:35:27','',''),(2331519,'1','200','1025',468,'Retail Sale Id 1373798',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 15:36:25','',''),(2331529,'1','200','1025',468,'Retail Sale Id 1373809',2528.00,0.00,0.00,4.00,184.00,'2021-12-20 15:37:19','',''),(2331539,'1','200','1025',468,'Retail Sale Id 1373817',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 15:38:10','',''),(2331551,'1','200','1025',468,'Retail Sale Id 1373832',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 15:39:06','',''),(2331566,'1','200','1025',468,'Retail Sale Id 1373845',66000.00,0.00,0.00,110.00,1540.00,'2021-12-20 15:40:31','',''),(2331634,'1','200','1025',468,'Retail Sale Id 1373884',7584.00,0.00,0.00,12.00,552.00,'2021-12-20 15:45:47','',''),(2331690,'1','200','1025',468,'Retail Sale Id 1373933',1264.00,0.00,0.00,2.00,92.00,'2021-12-20 15:51:06','',''),(2331734,'1','200','1025',468,'Retail Sale Id 1373970',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 15:56:14','',''),(2331746,'1','200','1025',468,'Retail Sale Id 1373991',3476.00,0.00,0.00,5.50,253.00,'2021-12-20 15:57:36','',''),(2331761,'1','200','1025',468,'Retail Sale Id 1374006',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 15:58:57','',''),(2331775,'1','200','1025',468,'Retail Sale Id 1374020',998.56,0.00,0.00,1.58,72.68,'2021-12-20 16:00:12','',''),(2331810,'1','200','1025',468,'Retail Sale Id 1374053',632.00,0.00,0.00,1.00,46.00,'2021-12-20 16:04:31','',''),(2331836,'1','200','1025',468,'Retail Sale Id 1374083',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 16:06:50','',''),(2331860,'1','200','1025',468,'Retail Sale Id 1374109',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 16:08:41','',''),(2331870,'1','200','1025',468,'Retail Sale Id 1374118',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 16:09:34','',''),(2331879,'1','200','1025',468,'Retail Sale Id 1374126',3792.00,0.00,0.00,6.00,276.00,'2021-12-20 16:10:37','',''),(2331890,'1','200','1025',468,'Retail Sale Id 1374136',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 16:12:14','',''),(2331891,'1','200','1025',468,'Retail Sale Id 1374136',4424.00,0.00,0.00,7.00,322.00,'2021-12-20 16:12:14','',''),(2331903,'1','200','1025',468,'Retail Sale Id 1374146',4999.12,0.00,0.00,7.91,363.86,'2021-12-20 16:13:21','',''),(2331943,'1','200','1025',468,'Retail Sale Id 1374183',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 16:18:06','',''),(2331956,'1','200','1025',468,'Retail Sale Id 1374196',3950.00,0.00,0.00,6.25,287.50,'2021-12-20 16:20:10','',''),(2332016,'1','200','1025',468,'Retail Sale Id 1374248',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 16:26:24','',''),(2332054,'1','200','1025',468,'Retail Sale Id 1374273',1801.20,0.00,0.00,2.85,131.10,'2021-12-20 16:29:44','',''),(2332115,'1','200','1025',468,'Retail Sale Id 1374344',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 16:36:23','',''),(2332122,'1','200','1025',468,'Retail Sale Id 1374352',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 16:36:58','',''),(2332149,'1','200','1025',468,'Retail Sale Id 1374373',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 16:39:41','',''),(2332161,'1','200','1025',468,'Retail Sale Id 1374381',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 16:40:45','',''),(2332194,'1','200','1025',468,'Retail Sale Id 1374403',1896.00,0.00,0.00,3.00,138.00,'2021-12-20 16:42:55','',''),(2332211,'1','200','1025',468,'Retail Sale Id 1374422',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 16:44:58','',''),(2332290,'1','200','1025',468,'Retail Sale Id 1374490',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 16:53:36','',''),(2332321,'1','200','1025',468,'Retail Sale Id 1374529',34800.00,0.00,0.00,58.00,812.00,'2021-12-20 16:57:07','',''),(2332334,'1','200','1025',468,'Retail Sale Id 1374544',3160.00,0.00,0.00,5.00,230.00,'2021-12-20 16:58:49','',''),(2332423,'1','200','1025',468,'Retail Sale Id 1374610',7900.00,0.00,0.00,12.50,575.00,'2021-12-20 17:09:19','',''),(2333584,'1','200','1025',468,'Retail Sale Id 1375197',897.44,0.00,0.00,1.42,65.32,'2021-12-21 06:50:58','',''),(2333617,'1','200','1025',468,'Retail Sale Id 1375228',66000.00,0.00,0.00,110.00,1540.00,'2021-12-21 06:55:32','',''),(2333758,'1','200','1025',468,'Retail Sale Id 1375312',1264.00,0.00,0.00,2.00,92.00,'2021-12-21 07:08:58','',''),(2333759,'1','200','1025',468,'Retail Sale Id 1375312',6320.00,0.00,0.00,10.00,460.00,'2021-12-21 07:08:58','',''),(2333813,'1','200','1025',468,'Retail Sale Id 1375350',1997.12,0.00,0.00,3.16,145.36,'2021-12-21 07:14:03','',''),(2334049,'1','200','1025',468,'Retail Sale Id 1375551',3792.00,0.00,0.00,6.00,276.00,'2021-12-21 07:38:10','',''),(2334071,'1','200','1025',468,'Retail Sale Id 1375572',1896.00,0.00,0.00,3.00,138.00,'2021-12-21 07:40:53','',''),(2334118,'1','200','1025',468,'Retail Sale Id 1375617',998.56,0.00,0.00,1.58,72.68,'2021-12-21 07:45:56','',''),(2334119,'1','200','1025',468,'Retail Sale Id 1375617',4999.12,0.00,0.00,7.91,363.86,'2021-12-21 07:45:56','',''),(2334154,'1','200','1025',468,'Retail Sale Id 1375654',6320.00,0.00,0.00,10.00,460.00,'2021-12-21 07:49:46','',''),(2334185,'1','200','1025',468,'Retail Sale Id 1375669',5056.00,0.00,0.00,8.00,368.00,'2021-12-21 07:50:57','',''),(2334279,'1','200','1025',468,'Retail Sale Id 1375762',1997.12,0.00,0.00,3.16,145.36,'2021-12-21 07:57:25','',''),(2334376,'1','200','1025',468,'Retail Sale Id 1375832',7584.00,0.00,0.00,12.00,552.00,'2021-12-21 08:06:16','',''),(2334477,'1','200','1025',468,'Retail Sale Id 1375907',3160.00,0.00,0.00,5.00,230.00,'2021-12-21 08:14:40','',''),(2334490,'1','200','1025',468,'Retail Sale Id 1375921',1896.00,0.00,0.00,3.00,138.00,'2021-12-21 08:16:38','',''),(2334602,'1','200','1025',468,'Retail Sale Id 1376015',3002.00,0.00,0.00,4.75,218.50,'2021-12-21 08:33:03','',''),(2334609,'1','200','1025',468,'Retail Sale Id 1376024',1896.00,0.00,0.00,3.00,138.00,'2021-12-21 08:34:24','',''),(2334618,'1','200','1025',468,'Retail Sale Id 1376033',3160.00,0.00,0.00,5.00,230.00,'2021-12-21 08:35:41','',''),(2334619,'1','200','1025',468,'Retail Sale Id 1376033',6320.00,0.00,0.00,10.00,460.00,'2021-12-21 08:35:41','',''),(2334655,'1','200','1025',468,'Retail Sale Id 1376074',3000.00,0.00,0.00,5.00,70.00,'2021-12-21 08:43:04','',''),(2334805,'1','200','1025',468,'Retail Sale Id 1376176',3160.00,0.00,0.00,5.00,230.00,'2021-12-21 08:59:13','',''),(2334825,'1','200','1025',468,'Retail Sale Id 1376202',2528.00,0.00,0.00,4.00,184.00,'2021-12-21 09:02:18','',''),(2334906,'1','200','1025',468,'Retail Sale Id 1376279',2528.00,0.00,0.00,4.00,184.00,'2021-12-21 09:13:46','',''),(2334960,'1','200','1025',468,'Retail Sale Id 1376326',2528.00,0.00,0.00,4.00,184.00,'2021-12-21 09:19:10','',''),(2334981,'1','200','1025',468,'Retail Sale Id 1376340',12000.00,0.00,0.00,20.00,280.00,'2021-12-21 09:20:56','',''),(2335114,'1','200','1025',468,'Retail Sale Id 1376448',3160.00,0.00,0.00,5.00,230.00,'2021-12-21 09:34:21','',''),(2335134,'1','200','1025',468,'Retail Sale Id 1376455',3792.00,0.00,0.00,6.00,276.00,'2021-12-21 09:36:06','',''),(2335231,'1','200','1025',468,'Retail Sale Id 1376525',3792.00,0.00,0.00,6.00,276.00,'2021-12-21 09:44:35','',''),(2335284,'1','200','1025',468,'Retail Sale Id 1376568',1896.00,0.00,0.00,3.00,138.00,'2021-12-21 09:50:08','',''),(2335307,'1','200','1025',468,'Retail Sale Id 1376580',60000.00,0.00,0.00,100.00,1400.00,'2021-12-21 09:52:44','',''),(2335359,'1','200','1025',468,'Retail Sale Id 1376662',2528.00,0.00,0.00,4.00,184.00,'2021-12-21 10:00:55','',''),(2335376,'1','200','1025',468,'Retail Sale Id 1376679',1896.00,0.00,0.00,3.00,138.00,'2021-12-21 10:02:06','',''),(2335385,'1','200','1025',468,'Retail Sale Id 1376688',1200.80,0.00,0.00,1.90,87.40,'2021-12-21 10:03:18','',''),(2335430,'1','200','1025',468,'Retail Sale Id 1376727',3002.00,0.00,0.00,4.75,218.50,'2021-12-21 10:09:38','',''),(2335463,'1','200','1025',468,'Retail Sale Id 1376746',27600.00,0.00,0.00,46.00,644.00,'2021-12-21 10:13:50','',''),(2335503,'1','200','1025',468,'Retail Sale Id 1376799',3160.00,0.00,0.00,5.00,230.00,'2021-12-21 10:20:19','',''),(2335556,'1','200','1025',468,'Retail Sale Id 1376843',1896.00,0.00,0.00,3.00,138.00,'2021-12-21 10:26:20','',''),(2335599,'1','200','1025',468,'Retail Sale Id 1376858',7584.00,0.00,0.00,12.00,552.00,'2021-12-21 10:28:19','',''),(2335778,'1','200','1025',468,'Retail Sale Id 1376966',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 10:42:29','',''),(2335816,'1','200','1025',468,'Retail Sale Id 1377000',2464.00,0.00,0.00,4.00,224.00,'2021-12-21 10:48:01','',''),(2335817,'1','200','1025',468,'Retail Sale Id 1377000',3696.00,0.00,0.00,6.00,336.00,'2021-12-21 10:48:01','',''),(2335893,'1','200','1025',468,'Retail Sale Id 1377059',3696.00,0.00,0.00,6.00,336.00,'2021-12-21 10:55:33','',''),(2335907,'1','200','1025',468,'Retail Sale Id 1377072',2464.00,0.00,0.00,4.00,224.00,'2021-12-21 10:56:59','',''),(2335954,'1','200','1025',468,'Retail Sale Id 1377113',5001.92,0.00,0.00,8.12,454.72,'2021-12-21 11:02:01','',''),(2335977,'1','200','1025',468,'Retail Sale Id 1377127',1232.00,0.00,0.00,2.00,112.00,'2021-12-21 11:03:52','',''),(2335986,'1','200','1025',468,'Retail Sale Id 1377136',3696.00,0.00,0.00,6.00,336.00,'2021-12-21 11:04:53','',''),(2335991,'1','200','1025',468,'Retail Sale Id 1377141',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 11:05:41','',''),(2336086,'1','200','1025',468,'Retail Sale Id 1377227',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 11:14:59','',''),(2336087,'1','200','1025',468,'Retail Sale Id 1377227',3498.88,0.00,0.00,5.68,318.08,'2021-12-21 11:14:59','',''),(2336232,'1','200','1025',468,'Retail Sale Id 1377351',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 11:30:46','',''),(2336327,'1','200','1025',468,'Retail Sale Id 1377438',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 11:43:36','',''),(2336354,'1','200','1025',468,'Retail Sale Id 1377463',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 11:48:29','',''),(2336368,'1','200','1025',468,'Retail Sale Id 1377479',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 11:50:38','',''),(2336417,'1','200','1025',468,'Retail Sale Id 1377518',2402.40,0.00,0.00,3.90,218.40,'2021-12-21 11:55:41','',''),(2336560,'1','200','1025',468,'Retail Sale Id 1377634',3696.00,0.00,0.00,6.00,336.00,'2021-12-21 12:13:08','',''),(2336611,'1','200','1025',468,'Retail Sale Id 1377685',139200.00,0.00,0.00,240.00,4800.00,'2021-12-21 12:19:17','',''),(2336738,'1','200','1025',468,'Retail Sale Id 1377781',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 12:34:08','',''),(2336739,'1','200','1025',468,'Retail Sale Id 1377781',6776.00,0.00,0.00,11.00,616.00,'2021-12-21 12:34:08','',''),(2336798,'1','200','1025',468,'Retail Sale Id 1377852',1232.00,0.00,0.00,2.00,112.00,'2021-12-21 12:38:53','',''),(2336901,'1','200','1025',468,'Retail Sale Id 1377960',3696.00,0.00,0.00,6.00,336.00,'2021-12-21 12:53:07','',''),(2336911,'1','200','1025',468,'Retail Sale Id 1377975',7392.00,0.00,0.00,12.00,672.00,'2021-12-21 12:54:10','',''),(2336924,'1','200','1025',468,'Retail Sale Id 1377989',7392.00,0.00,0.00,12.00,672.00,'2021-12-21 12:55:31','',''),(2336964,'1','200','1025',468,'Retail Sale Id 1378012',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 12:59:33','',''),(2337030,'1','200','1025',468,'Retail Sale Id 1378069',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 13:05:56','',''),(2337075,'1','200','1025',468,'Retail Sale Id 1378109',69600.00,0.00,0.00,120.00,2400.00,'2021-12-21 13:10:01','',''),(2337138,'1','200','1025',468,'Retail Sale Id 1378156',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 13:14:23','',''),(2337259,'1','200','1025',468,'Retail Sale Id 1378256',63800.00,0.00,0.00,110.00,2200.00,'2021-12-21 13:27:23','',''),(2337301,'1','200','1025',468,'Retail Sale Id 1378307',3696.00,0.00,0.00,6.00,336.00,'2021-12-21 13:32:21','',''),(2337412,'1','200','1025',468,'Retail Sale Id 1378372',40600.00,0.00,0.00,70.00,1400.00,'2021-12-21 13:40:46','',''),(2337533,'1','200','1025',468,'Retail Sale Id 1378428',6776.00,0.00,0.00,11.00,616.00,'2021-12-21 13:47:36','',''),(2337593,'1','200','1025',468,'Retail Sale Id 1378483',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 13:51:56','',''),(2337607,'1','200','1025',468,'Retail Sale Id 1378495',4928.00,0.00,0.00,8.00,448.00,'2021-12-21 13:53:02','',''),(2337632,'1','200','1025',468,'Return of Retail Sale Id 1378428',0.00,6776.00,11.00,0.00,-616.00,'2021-12-21 13:56:01','',''),(2337794,'1','200','1025',468,'Retail Sale Id 1378674',6160.00,0.00,0.00,10.00,560.00,'2021-12-21 14:14:05','',''),(2338075,'1','200','1025',468,'Retail Sale Id 1378888',1503.04,0.00,0.00,2.44,136.64,'2021-12-21 14:33:58','',''),(2338087,'1','200','1025',468,'Retail Sale Id 1378902',65540.00,0.00,0.00,113.00,2260.00,'2021-12-21 14:35:14','',''),(2338191,'1','200','1025',468,'Retail Sale Id 1379014',1848.00,0.00,0.00,3.00,168.00,'2021-12-21 14:45:19','',''),(2338192,'1','200','1025',468,'Retail Sale Id 1379014',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 14:45:19','',''),(2338201,'1','200','1025',468,'Retail Sale Id 1379023',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 14:46:17','',''),(2338218,'1','200','1025',468,'Retail Sale Id 1379039',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 14:48:05','',''),(2338233,'1','200','1025',468,'Retail Sale Id 1379052',1848.00,0.00,0.00,3.00,168.00,'2021-12-21 14:49:10','',''),(2338250,'1','200','1025',468,'Retail Sale Id 1379069',6160.00,0.00,0.00,10.00,560.00,'2021-12-21 14:50:49','',''),(2338292,'1','200','1025',468,'Retail Sale Id 1379094',39150.00,0.00,0.00,67.50,1350.00,'2021-12-21 14:53:16','',''),(2338308,'1','200','1025',468,'Retail Sale Id 1379115',1848.00,0.00,0.00,3.00,168.00,'2021-12-21 14:54:24','',''),(2338342,'1','200','1025',468,'Retail Sale Id 1379126',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 14:55:41','',''),(2338614,'1','200','1025',468,'Retail Sale Id 1379351',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 15:18:46','',''),(2338615,'1','200','1025',468,'Retail Sale Id 1379351',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 15:18:46','',''),(2338645,'1','200','1025',468,'Retail Sale Id 1379390',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 15:22:22','',''),(2338666,'1','200','1025',468,'Retail Sale Id 1379412',1848.00,0.00,0.00,3.00,168.00,'2021-12-21 15:24:26','',''),(2338685,'1','200','1025',468,'Retail Sale Id 1379432',8700.00,0.00,0.00,15.00,300.00,'2021-12-21 15:27:07','',''),(2338699,'1','200','1025',468,'Retail Sale Id 1379448',2464.00,0.00,0.00,4.00,224.00,'2021-12-21 15:28:00','',''),(2338716,'1','200','1025',468,'Retail Sale Id 1379466',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 15:29:50','',''),(2338828,'1','200','1025',468,'Retail Sale Id 1379552',2002.00,0.00,0.00,3.25,182.00,'2021-12-21 15:36:44','',''),(2338953,'1','200','1025',468,'Retail Sale Id 1379621',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 15:42:15','',''),(2338971,'1','200','1025',468,'Retail Sale Id 1379650',2002.00,0.00,0.00,3.25,182.00,'2021-12-21 15:43:31','',''),(2339012,'1','200','1025',468,'Retail Sale Id 1379677',3696.00,0.00,0.00,6.00,336.00,'2021-12-21 15:45:53','',''),(2339031,'1','200','1025',468,'Retail Sale Id 1379695',1897.28,0.00,0.00,3.08,172.48,'2021-12-21 15:47:24','',''),(2339044,'1','200','1025',468,'Retail Sale Id 1379710',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 15:48:33','',''),(2339065,'1','200','1025',468,'Retail Sale Id 1379727',3696.00,0.00,0.00,6.00,336.00,'2021-12-21 15:49:53','',''),(2339074,'1','200','1025',468,'Retail Sale Id 1379740',1503.04,0.00,0.00,2.44,136.64,'2021-12-21 15:50:49','',''),(2339083,'1','200','1025',468,'Retail Sale Id 1379749',2464.00,0.00,0.00,4.00,224.00,'2021-12-21 15:51:44','',''),(2339121,'1','200','1025',468,'Retail Sale Id 1379778',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 15:54:15','',''),(2339161,'1','200','1025',468,'Retail Sale Id 1379818',2464.00,0.00,0.00,4.00,224.00,'2021-12-21 15:57:02','',''),(2339243,'1','200','1025',468,'Retail Sale Id 1379874',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 16:01:33','',''),(2339404,'1','200','1025',468,'Retail Sale Id 1380020',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 16:12:04','',''),(2339497,'1','200','1025',468,'Retail Sale Id 1380105',67280.00,0.00,0.00,116.00,2320.00,'2021-12-21 16:19:36','',''),(2339512,'1','200','1025',468,'Retail Sale Id 1380125',191400.00,0.00,0.00,330.00,6600.00,'2021-12-21 16:20:40','',''),(2339522,'1','200','1025',468,'Retail Sale Id 1380135',616.00,0.00,0.00,1.00,56.00,'2021-12-21 16:21:42','',''),(2339541,'1','200','1025',468,'Retail Sale Id 1380150',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 16:23:00','',''),(2339547,'1','200','1025',468,'Retail Sale Id 1380164',3498.88,0.00,0.00,5.68,318.08,'2021-12-21 16:23:46','',''),(2339606,'1','200','1025',468,'Retail Sale Id 1380213',4928.00,0.00,0.00,8.00,448.00,'2021-12-21 16:29:01','',''),(2339620,'1','200','1025',468,'Retail Sale Id 1380228',1848.00,0.00,0.00,3.00,168.00,'2021-12-21 16:30:07','',''),(2339714,'1','200','1025',468,'Retail Sale Id 1380311',3696.00,0.00,0.00,6.00,336.00,'2021-12-21 16:37:31','',''),(2339724,'1','200','1025',468,'Retail Sale Id 1380322',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 16:38:19','',''),(2339773,'1','200','1025',468,'Retail Sale Id 1380372',2002.00,0.00,0.00,3.25,182.00,'2021-12-21 16:42:37','',''),(2339790,'1','200','1025',468,'Retail Sale Id 1380390',1503.04,0.00,0.00,2.44,136.64,'2021-12-21 16:44:08','',''),(2339791,'1','200','1025',468,'Retail Sale Id 1380390',1503.04,0.00,0.00,2.44,136.64,'2021-12-21 16:44:08','',''),(2339824,'1','200','1025',468,'Retail Sale Id 1380424',1232.00,0.00,0.00,2.00,112.00,'2021-12-21 16:46:43','',''),(2339835,'1','200','1025',468,'Retail Sale Id 1380437',7700.00,0.00,0.00,12.50,700.00,'2021-12-21 16:47:43','',''),(2339848,'1','200','1025',468,'Retail Sale Id 1380449',1848.00,0.00,0.00,3.00,168.00,'2021-12-21 16:48:45','',''),(2339884,'1','200','1025',468,'Retail Sale Id 1380479',498.96,0.00,0.00,0.81,45.36,'2021-12-21 16:52:12','',''),(2340001,'1','200','1025',468,'Retail Sale Id 1380593',3080.00,0.00,0.00,5.00,280.00,'2021-12-21 17:02:47','',''),(2341142,'1','200','1025',468,'Retail Sale Id 1381163',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 06:05:05','',''),(2341445,'1','200','1025',468,'Retail Sale Id 1381379',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 06:44:38','',''),(2341638,'1','200','1025',468,'Retail Sale Id 1381535',104400.00,0.00,0.00,180.00,3600.00,'2021-12-22 07:00:17','',''),(2341736,'1','200','1025',468,'Retail Sale Id 1381625',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 07:09:44','',''),(2341757,'1','200','1025',468,'Retail Sale Id 1381653',3702.16,0.00,0.00,6.01,336.56,'2021-12-22 07:11:40','',''),(2341798,'1','200','1025',468,'Retail Sale Id 1381684',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 07:13:52','',''),(2341799,'1','200','1025',468,'Retail Sale Id 1381684',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 07:13:52','',''),(2341800,'1','200','1025',468,'Retail Sale Id 1381684',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 07:13:52','',''),(2341817,'1','200','1025',468,'Retail Sale Id 1381698',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 07:15:12','',''),(2341831,'1','200','1025',468,'Retail Sale Id 1381708',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 07:16:18','',''),(2342000,'1','200','1025',468,'Retail Sale Id 1381845',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 07:30:59','',''),(2342020,'1','200','1025',468,'Retail Sale Id 1381865',3702.16,0.00,0.00,6.01,336.56,'2021-12-22 07:33:02','',''),(2342021,'1','200','1025',468,'Retail Sale Id 1381865',3702.16,0.00,0.00,6.01,336.56,'2021-12-22 07:33:02','',''),(2342108,'1','200','1025',468,'Retail Sale Id 1381928',3997.84,0.00,0.00,6.49,363.44,'2021-12-22 07:39:30','',''),(2342228,'1','200','1025',468,'Retail Sale Id 1382017',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 07:47:37','',''),(2342302,'1','200','1025',468,'Retail Sale Id 1382070',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 07:51:24','',''),(2342338,'1','200','1025',468,'Retail Sale Id 1382108',7392.00,0.00,0.00,12.00,672.00,'2021-12-22 07:54:01','',''),(2342510,'1','200','1025',468,'Retail Sale Id 1382247',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 08:04:29','',''),(2342574,'1','200','1025',468,'Retail Sale Id 1382288',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 08:07:57','',''),(2342603,'1','200','1025',468,'Retail Sale Id 1382316',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 08:10:28','',''),(2342812,'1','200','1025',468,'Retail Sale Id 1382500',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 08:25:51','',''),(2342933,'1','200','1025',468,'Retail Sale Id 1382565',2002.00,0.00,0.00,3.25,182.00,'2021-12-22 08:30:15','',''),(2342984,'1','200','1025',468,'Retail Sale Id 1382615',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 08:34:19','',''),(2343034,'1','200','1025',468,'Retail Sale Id 1382654',7392.00,0.00,0.00,12.00,672.00,'2021-12-22 08:38:04','',''),(2343082,'1','200','1025',468,'Retail Sale Id 1382687',1503.04,0.00,0.00,2.44,136.64,'2021-12-22 08:41:46','',''),(2343106,'1','200','1025',468,'Retail Sale Id 1382713',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 08:44:33','',''),(2343117,'1','200','1025',468,'Retail Sale Id 1382728',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 08:45:57','',''),(2343150,'1','200','1025',468,'Retail Sale Id 1382757',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 08:49:51','',''),(2343191,'1','200','1025',468,'Retail Sale Id 1382799',8008.00,0.00,0.00,13.00,728.00,'2021-12-22 08:53:56','',''),(2343204,'1','200','1025',468,'Retail Sale Id 1382812',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 08:54:57','',''),(2343221,'1','200','1025',468,'Retail Sale Id 1382824',9860.00,0.00,0.00,17.00,340.00,'2021-12-22 08:56:52','',''),(2343261,'1','200','1025',468,'Retail Sale Id 1382866',15080.00,0.00,0.00,26.00,520.00,'2021-12-22 09:00:32','',''),(2343357,'1','200','1025',468,'Retail Sale Id 1383004',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 09:09:25','',''),(2343403,'1','200','1025',468,'Retail Sale Id 1383031',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 09:12:38','',''),(2343422,'1','200','1025',468,'Retail Sale Id 1383062',5544.00,0.00,0.00,9.00,504.00,'2021-12-22 09:14:55','',''),(2343492,'1','200','1025',468,'Retail Sale Id 1383117',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 09:21:47','',''),(2343530,'1','200','1025',468,'Retail Sale Id 1383166',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 09:26:46','',''),(2344019,'1','200','1025',468,'Retail Sale Id 1383585',1232.00,0.00,0.00,2.00,112.00,'2021-12-22 10:06:52','',''),(2344034,'1','200','1025',468,'Retail Sale Id 1383598',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 10:08:21','',''),(2344035,'1','200','1025',468,'Retail Sale Id 1383598',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 10:08:21','',''),(2344050,'1','200','1025',468,'Retail Sale Id 1383614',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 10:09:37','',''),(2344175,'1','200','1025',468,'Retail Sale Id 1383734',145000.00,0.00,0.00,250.00,5000.00,'2021-12-22 10:21:53','',''),(2344181,'1','200','1025',468,'Retail Sale Id 1383743',34800.00,0.00,0.00,60.00,1200.00,'2021-12-22 10:23:05','',''),(2344203,'1','200','1025',468,'Retail Sale Id 1383765',1232.00,0.00,0.00,2.00,112.00,'2021-12-22 10:25:30','',''),(2344244,'1','200','1025',468,'Retail Sale Id 1383806',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 10:29:19','',''),(2344265,'1','200','1025',468,'Retail Sale Id 1383827',69600.00,0.00,0.00,120.00,2400.00,'2021-12-22 10:31:04','',''),(2344276,'1','200','1025',468,'Retail Sale Id 1383837',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 10:32:08','',''),(2344292,'1','200','1025',468,'Retail Sale Id 1383853',29000.00,0.00,0.00,50.00,1000.00,'2021-12-22 10:33:54','',''),(2344339,'1','200','1025',468,'Retail Sale Id 1383900',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 10:39:18','',''),(2344464,'1','200','1025',468,'Retail Sale Id 1384024',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 10:51:30','',''),(2344496,'1','200','1025',468,'Retail Sale Id 1384054',997.92,0.00,0.00,1.62,90.72,'2021-12-22 10:53:44','',''),(2344497,'1','200','1025',468,'Retail Sale Id 1384054',1503.04,0.00,0.00,2.44,136.64,'2021-12-22 10:53:44','',''),(2344562,'1','200','1025',468,'Retail Sale Id 1384119',1232.00,0.00,0.00,2.00,112.00,'2021-12-22 10:59:58','',''),(2344578,'1','200','1025',468,'Retail Sale Id 1384134',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 11:01:39','',''),(2344758,'1','200','1025',468,'Retail Sale Id 1384301',2999.92,0.00,0.00,4.87,272.72,'2021-12-22 11:18:57','',''),(2344773,'1','200','1025',468,'Retail Sale Id 1384316',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 11:20:13','',''),(2344902,'1','200','1025',468,'Retail Sale Id 1384444',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 11:33:01','',''),(2344903,'1','200','1025',468,'Retail Sale Id 1384444',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 11:33:01','',''),(2344935,'1','200','1025',468,'Retail Sale Id 1384469',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 11:35:38','',''),(2344962,'1','200','1025',468,'Retail Sale Id 1384495',1540.00,0.00,0.00,2.50,140.00,'2021-12-22 11:37:39','',''),(2345038,'1','200','1025',468,'Retail Sale Id 1384568',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 11:45:27','',''),(2345234,'1','200','1025',468,'Retail Sale Id 1384764',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 12:06:56','',''),(2345251,'1','200','1025',468,'Retail Sale Id 1384778',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 12:08:27','',''),(2345356,'1','200','1025',468,'Retail Sale Id 1384875',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 12:20:20','',''),(2345357,'1','200','1025',468,'Retail Sale Id 1384875',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 12:20:20','',''),(2345426,'1','200','1025',468,'Retail Sale Id 1384907',7392.00,0.00,0.00,12.00,672.00,'2021-12-22 12:24:38','',''),(2345527,'1','200','1025',468,'Retail Sale Id 1385018',2464.00,0.00,0.00,4.00,224.00,'2021-12-22 12:37:40','',''),(2345528,'1','200','1025',468,'Retail Sale Id 1385018',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 12:37:40','',''),(2345529,'1','200','1025',468,'Retail Sale Id 1385018',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 12:37:40','',''),(2345537,'1','200','1025',468,'Retail Sale Id 1385024',2002.00,0.00,0.00,3.25,182.00,'2021-12-22 12:38:48','',''),(2345657,'1','200','1025',468,'Retail Sale Id 1385131',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 12:51:33','',''),(2345749,'1','200','1025',468,'Retail Sale Id 1385198',1232.00,0.00,0.00,2.00,112.00,'2021-12-22 12:58:52','',''),(2345760,'1','200','1025',468,'Retail Sale Id 1385205',81200.00,0.00,0.00,140.00,2800.00,'2021-12-22 12:59:58','',''),(2345774,'1','200','1025',468,'Retail Sale Id 1385221',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 13:01:58','',''),(2345788,'1','200','1025',468,'Retail Sale Id 1385231',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 13:03:22','',''),(2345794,'1','200','1025',468,'Retail Sale Id 1385243',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 13:04:27','',''),(2345803,'1','200','1025',468,'Retail Sale Id 1385250',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 13:05:37','',''),(2345804,'1','200','1025',468,'Retail Sale Id 1385250',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 13:05:37','',''),(2345817,'1','200','1025',468,'Retail Sale Id 1385265',2999.92,0.00,0.00,4.87,272.72,'2021-12-22 13:07:37','',''),(2345843,'1','200','1025',468,'Retail Sale Id 1385290',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 13:09:50','',''),(2345908,'1','200','1025',468,'Retail Sale Id 1385335',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 13:16:11','',''),(2345950,'1','200','1025',468,'Retail Sale Id 1385388',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 13:22:11','',''),(2346025,'1','200','1025',468,'Retail Sale Id 1385455',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 13:30:18','',''),(2346126,'1','200','1025',468,'Retail Sale Id 1385530',95700.00,0.00,0.00,165.00,3300.00,'2021-12-22 13:38:57','',''),(2346150,'1','200','1025',468,'Retail Sale Id 1385538',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 13:40:33','',''),(2346202,'1','200','1025',468,'Retail Sale Id 1385554',997.92,0.00,0.00,1.62,90.72,'2021-12-22 13:42:46','',''),(2346228,'1','200','1025',468,'Retail Sale Id 1385577',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 13:45:28','',''),(2346271,'1','200','1025',468,'Retail Sale Id 1385598',7392.00,0.00,0.00,12.00,672.00,'2021-12-22 13:48:00','',''),(2346618,'1','200','1025',468,'Retail Sale Id 1385820',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 14:17:23','',''),(2346647,'1','200','1025',468,'Retail Sale Id 1385847',62060.00,0.00,0.00,107.00,2140.00,'2021-12-22 14:20:35','',''),(2346680,'1','200','1025',468,'Retail Sale Id 1385867',2464.00,0.00,0.00,4.00,224.00,'2021-12-22 14:23:27','',''),(2346695,'1','200','1025',468,'Retail Sale Id 1385881',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 14:24:35','',''),(2346703,'1','200','1025',468,'Retail Sale Id 1385890',3498.88,0.00,0.00,5.68,318.08,'2021-12-22 14:25:43','',''),(2346721,'1','200','1025',468,'Retail Sale Id 1385905',1398.32,0.00,0.00,2.27,127.12,'2021-12-22 14:27:58','',''),(2346750,'1','200','1025',468,'Retail Sale Id 1385931',3480.00,0.00,0.00,6.00,120.00,'2021-12-22 14:31:49','',''),(2346763,'1','200','1025',468,'Retail Sale Id 1385940',2464.00,0.00,0.00,4.00,224.00,'2021-12-22 14:33:09','',''),(2346780,'1','200','1025',468,'Retail Sale Id 1385956',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 14:35:08','',''),(2346869,'1','200','1025',468,'Retail Sale Id 1386005',1232.00,0.00,0.00,2.00,112.00,'2021-12-22 14:41:35','',''),(2346886,'1','200','1025',468,'Retail Sale Id 1386018',1503.04,0.00,0.00,2.44,136.64,'2021-12-22 14:43:33','',''),(2346894,'1','200','1025',468,'Retail Sale Id 1386025',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 14:44:54','',''),(2346907,'1','200','1025',468,'Retail Sale Id 1386034',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 14:46:06','',''),(2346928,'1','200','1025',468,'Retail Sale Id 1386048',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 14:48:26','',''),(2347202,'1','200','1025',468,'Retail Sale Id 1386299',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 15:16:00','',''),(2347370,'1','200','1025',468,'Retail Sale Id 1386403',498.96,0.00,0.00,0.81,45.36,'2021-12-22 15:27:46','',''),(2347411,'1','200','1025',468,'Retail Sale Id 1386417',7084.00,0.00,0.00,11.50,644.00,'2021-12-22 15:30:08','',''),(2347436,'1','200','1025',468,'Retail Sale Id 1386435',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 15:31:28','',''),(2347465,'1','200','1025',468,'Retail Sale Id 1386463',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 15:33:48','',''),(2347489,'1','200','1025',468,'Retail Sale Id 1386483',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 15:35:48','',''),(2347524,'1','200','1025',468,'Retail Sale Id 1386516',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 15:38:28','',''),(2347550,'1','200','1025',468,'Retail Sale Id 1386539',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 15:39:58','',''),(2347563,'1','200','1025',468,'Retail Sale Id 1386551',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 15:41:09','',''),(2347609,'1','200','1025',468,'Retail Sale Id 1386599',14500.00,0.00,0.00,25.00,500.00,'2021-12-22 15:44:53','',''),(2347669,'1','200','1025',468,'Retail Sale Id 1386663',7392.00,0.00,0.00,12.00,672.00,'2021-12-22 15:50:55','',''),(2347670,'1','200','1025',468,'Retail Sale Id 1386663',7392.00,0.00,0.00,12.00,672.00,'2021-12-22 15:50:55','',''),(2347671,'1','200','1025',468,'Retail Sale Id 1386663',7392.00,0.00,0.00,12.00,672.00,'2021-12-22 15:50:55','',''),(2347672,'1','200','1025',468,'Retail Sale Id 1386663',7392.00,0.00,0.00,12.00,672.00,'2021-12-22 15:50:55','',''),(2347788,'1','200','1025',468,'Retail Sale Id 1386740',0.00,0.00,0.00,0.00,0.00,'2021-12-22 16:00:50','',''),(2347845,'1','200','1025',468,'Retail Sale Id 1386772',8624.00,0.00,0.00,14.00,784.00,'2021-12-22 16:03:47','',''),(2347860,'1','200','1025',468,'Retail Sale Id 1386788',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 16:05:23','',''),(2347873,'1','200','1025',468,'Retail Sale Id 1386800',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 16:07:13','',''),(2347917,'1','200','1025',468,'Retail Sale Id 1386847',40600.00,0.00,0.00,70.00,1400.00,'2021-12-22 16:11:02','',''),(2347970,'1','200','1025',468,'Retail Sale Id 1386906',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 16:17:35','',''),(2348005,'1','200','1025',468,'Retail Sale Id 1386932',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 16:20:35','',''),(2348006,'1','200','1025',468,'Retail Sale Id 1386932',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 16:20:35','',''),(2348007,'1','200','1025',468,'Retail Sale Id 1386932',6160.00,0.00,0.00,10.00,560.00,'2021-12-22 16:20:35','',''),(2348008,'1','200','1025',468,'Retail Sale Id 1386932',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 16:20:35','',''),(2348043,'1','200','1025',468,'Retail Sale Id 1386948',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 16:22:41','',''),(2348053,'1','200','1025',468,'Retail Sale Id 1386957',34800.00,0.00,0.00,60.00,1200.00,'2021-12-22 16:24:16','',''),(2348060,'1','200','1025',468,'Retail Sale Id 1386963',2999.92,0.00,0.00,4.87,272.72,'2021-12-22 16:25:30','',''),(2348083,'1','200','1025',468,'Retail Sale Id 1386990',1848.00,0.00,0.00,3.00,168.00,'2021-12-22 16:29:15','',''),(2348084,'1','200','1025',468,'Retail Sale Id 1386990',2999.92,0.00,0.00,4.87,272.72,'2021-12-22 16:29:15','',''),(2348085,'1','200','1025',468,'Retail Sale Id 1386990',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 16:29:15','',''),(2348086,'1','200','1025',468,'Retail Sale Id 1386990',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 16:29:15','',''),(2348087,'1','200','1025',468,'Retail Sale Id 1386990',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 16:29:15','',''),(2348088,'1','200','1025',468,'Retail Sale Id 1386990',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 16:29:15','',''),(2348089,'1','200','1025',468,'Retail Sale Id 1386990',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 16:29:15','',''),(2348090,'1','200','1025',468,'Retail Sale Id 1386990',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 16:29:15','',''),(2348091,'1','200','1025',468,'Retail Sale Id 1386990',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 16:29:15','',''),(2348092,'1','200','1025',468,'Retail Sale Id 1386990',4928.00,0.00,0.00,8.00,448.00,'2021-12-22 16:29:15','',''),(2348093,'1','200','1025',468,'Retail Sale Id 1386990',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 16:29:15','',''),(2348111,'1','200','1025',468,'Retail Sale Id 1387010',616.00,0.00,0.00,1.00,56.00,'2021-12-22 16:31:01','',''),(2348309,'1','200','1025',468,'Retail Sale Id 1387185',3080.00,0.00,0.00,5.00,280.00,'2021-12-22 16:52:45','',''),(2348338,'1','200','1025',468,'Retail Sale Id 1387225',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 16:55:27','',''),(2348386,'1','200','1025',468,'Retail Sale Id 1387272',3696.00,0.00,0.00,6.00,336.00,'2021-12-22 16:59:50','',''),(2348434,'1','200','1025',468,'Retail Sale Id 1387317',4312.00,0.00,0.00,7.00,392.00,'2021-12-22 17:04:30','',''),(2348467,'1','200','1025',468,'Retail Sale Id 1387334',7700.00,0.00,0.00,12.50,700.00,'2021-12-22 17:08:25','',''),(2348683,'1','200','1025',468,'Return of Retail Sale Id 1387010',0.00,616.00,1.00,0.00,-56.00,'2021-12-22 17:35:17','',''),(2349778,'1','200','1025',468,'Retail Sale Id 1388028',3080.00,0.00,0.00,5.00,280.00,'2021-12-23 06:49:35','',''),(2349866,'1','200','1025',468,'Retail Sale Id 1388093',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 06:59:12','',''),(2349883,'1','200','1025',468,'Retail Sale Id 1388112',997.92,0.00,0.00,1.62,90.72,'2021-12-23 07:01:01','',''),(2349959,'1','200','1025',468,'Retail Sale Id 1388181',6160.00,0.00,0.00,10.00,560.00,'2021-12-23 07:09:21','',''),(2350059,'1','200','1025',468,'Retail Sale Id 1388254',11020.00,0.00,0.00,19.00,380.00,'2021-12-23 07:16:59','',''),(2350129,'1','200','1025',468,'Retail Sale Id 1388285',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 07:20:23','',''),(2350167,'1','200','1025',468,'Retail Sale Id 1388295',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 07:21:51','',''),(2350700,'1','200','1025',468,'Retail Sale Id 1388681',7392.00,0.00,0.00,12.00,672.00,'2021-12-23 07:58:25','',''),(2350746,'1','200','1025',468,'Retail Sale Id 1388727',7250.00,0.00,0.00,12.50,250.00,'2021-12-23 08:04:16','',''),(2350808,'1','200','1025',468,'Retail Sale Id 1388796',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 08:11:09','',''),(2350826,'1','200','1025',468,'Retail Sale Id 1388813',3498.88,0.00,0.00,5.68,318.08,'2021-12-23 08:12:47','',''),(2350847,'1','200','1025',468,'Retail Sale Id 1388820',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 08:13:41','',''),(2350924,'1','200','1025',468,'Retail Sale Id 1388881',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 08:20:38','',''),(2350925,'1','200','1025',468,'Retail Sale Id 1388881',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 08:20:38','',''),(2350961,'1','200','1025',468,'Retail Sale Id 1388914',24998.00,0.00,0.00,43.10,862.00,'2021-12-23 08:23:57','',''),(2351051,'1','200','1025',468,'Retail Sale Id 1388986',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 08:33:02','',''),(2351223,'1','200','1025',468,'Retail Sale Id 1389150',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 08:48:34','',''),(2351354,'1','200','1025',468,'Retail Sale Id 1389279',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 09:01:42','',''),(2351412,'1','200','1025',468,'Retail Sale Id 1389337',28420.00,0.00,0.00,49.00,980.00,'2021-12-23 09:08:01','',''),(2351434,'1','200','1025',468,'Retail Sale Id 1389353',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 09:09:51','',''),(2351467,'1','200','1025',468,'Retail Sale Id 1389368',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 09:14:07','',''),(2351490,'1','200','1025',468,'Retail Sale Id 1389417',34800.00,0.00,0.00,60.00,1200.00,'2021-12-23 09:16:47','',''),(2351506,'1','200','1025',468,'Retail Sale Id 1389432',3080.00,0.00,0.00,5.00,280.00,'2021-12-23 09:18:20','',''),(2351559,'1','200','1025',468,'Retail Sale Id 1389488',2958.00,0.00,0.00,5.10,102.00,'2021-12-23 09:24:37','',''),(2351630,'1','200','1025',468,'Retail Sale Id 1389537',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 09:28:39','',''),(2351680,'1','200','1025',468,'Retail Sale Id 1389575',3080.00,0.00,0.00,5.00,280.00,'2021-12-23 09:32:21','',''),(2351744,'1','200','1025',468,'Retail Sale Id 1389633',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 09:36:55','',''),(2351796,'1','200','1025',468,'Retail Sale Id 1389667',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 09:39:12','',''),(2351797,'1','200','1025',468,'Retail Sale Id 1389667',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 09:39:12','',''),(2351864,'1','200','1025',468,'Retail Sale Id 1389730',12760.00,0.00,0.00,22.00,440.00,'2021-12-23 09:43:45','',''),(2351879,'1','200','1025',468,'Retail Sale Id 1389742',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 09:45:03','',''),(2351975,'1','200','1025',468,'Retail Sale Id 1389833',6160.00,0.00,0.00,10.00,560.00,'2021-12-23 09:52:59','',''),(2352023,'1','200','1025',468,'Retail Sale Id 1389867',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 09:55:23','',''),(2352180,'1','200','1025',468,'Retail Sale Id 1389927',997.92,0.00,0.00,1.62,90.72,'2021-12-23 10:01:37','',''),(2352207,'1','200','1025',468,'Retail Sale Id 1389952',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 10:03:30','',''),(2352272,'1','200','1025',468,'Retail Sale Id 1390022',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 10:10:35','',''),(2352323,'1','200','1025',468,'Retail Sale Id 1390079',1232.00,0.00,0.00,2.00,112.00,'2021-12-23 10:16:18','',''),(2352376,'1','200','1025',468,'Retail Sale Id 1390100',2464.00,0.00,0.00,4.00,224.00,'2021-12-23 10:19:45','',''),(2352386,'1','200','1025',468,'Retail Sale Id 1390125',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 10:21:08','',''),(2352401,'1','200','1025',468,'Retail Sale Id 1390144',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 10:22:26','',''),(2352424,'1','200','1025',468,'Retail Sale Id 1390168',3080.00,0.00,0.00,5.00,280.00,'2021-12-23 10:24:51','',''),(2352425,'1','200','1025',468,'Retail Sale Id 1390168',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 10:24:51','',''),(2352438,'1','200','1025',468,'Retail Sale Id 1390184',997.92,0.00,0.00,1.62,90.72,'2021-12-23 10:26:14','',''),(2352448,'1','200','1025',468,'Retail Sale Id 1390198',2002.00,0.00,0.00,3.25,182.00,'2021-12-23 10:27:23','',''),(2352516,'1','200','1025',468,'Retail Sale Id 1390266',116000.00,0.00,0.00,200.00,4000.00,'2021-12-23 10:33:39','',''),(2352527,'1','200','1025',468,'Retail Sale Id 1390274',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 10:34:43','',''),(2352543,'1','200','1025',468,'Retail Sale Id 1390301',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 10:35:54','',''),(2352557,'1','200','1025',468,'Retail Sale Id 1390316',12180.00,0.00,0.00,21.00,420.00,'2021-12-23 10:37:13','',''),(2352589,'1','200','1025',468,'Retail Sale Id 1390349',26100.00,0.00,0.00,45.00,900.00,'2021-12-23 10:40:15','',''),(2352610,'1','200','1025',468,'Retail Sale Id 1390371',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 10:41:44','',''),(2352627,'1','200','1025',468,'Retail Sale Id 1390384',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 10:43:21','',''),(2352700,'1','200','1025',468,'Retail Sale Id 1390454',6960.00,0.00,0.00,12.00,240.00,'2021-12-23 10:49:30','',''),(2352747,'1','200','1025',468,'Retail Sale Id 1390495',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 10:54:12','',''),(2352787,'1','200','1025',468,'Retail Sale Id 1390529',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 10:57:59','',''),(2352846,'1','200','1025',468,'Retail Sale Id 1390598',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 11:03:10','',''),(2352874,'1','200','1025',468,'Retail Sale Id 1390625',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 11:05:45','',''),(2352981,'1','200','1025',468,'Retail Sale Id 1390722',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 11:14:56','',''),(2353009,'1','200','1025',468,'Retail Sale Id 1390757',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 11:17:37','',''),(2353035,'1','200','1025',468,'Retail Sale Id 1390777',3080.00,0.00,0.00,5.00,280.00,'2021-12-23 11:20:02','',''),(2353067,'1','200','1025',468,'Retail Sale Id 1390807',6160.00,0.00,0.00,10.00,560.00,'2021-12-23 11:23:18','',''),(2353078,'1','200','1025',468,'Retail Sale Id 1390818',2999.92,0.00,0.00,4.87,272.72,'2021-12-23 11:24:49','',''),(2353117,'1','200','1025',468,'Retail Sale Id 1390852',145000.00,0.00,0.00,250.00,5000.00,'2021-12-23 11:29:26','',''),(2353133,'1','200','1025',468,'Retail Sale Id 1390880',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 11:30:44','',''),(2353184,'1','200','1025',468,'Retail Sale Id 1390932',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 11:35:59','',''),(2353214,'1','200','1025',468,'Retail Sale Id 1390959',6160.00,0.00,0.00,10.00,560.00,'2021-12-23 11:38:59','',''),(2353303,'1','200','1025',468,'Retail Sale Id 1391048',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 11:47:47','',''),(2353331,'1','200','1025',468,'Retail Sale Id 1391073',1232.00,0.00,0.00,2.00,112.00,'2021-12-23 11:50:03','',''),(2353464,'1','200','1025',468,'Retail Sale Id 1391200',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 12:03:10','',''),(2353498,'1','200','1025',468,'Retail Sale Id 1391225',1232.00,0.00,0.00,2.00,112.00,'2021-12-23 12:05:46','',''),(2353540,'1','200','1025',468,'Retail Sale Id 1391251',95700.00,0.00,0.00,165.00,3300.00,'2021-12-23 12:09:31','',''),(2353588,'1','200','1025',468,'Retail Sale Id 1391298',3080.00,0.00,0.00,5.00,280.00,'2021-12-23 12:13:09','',''),(2353589,'1','200','1025',468,'Retail Sale Id 1391298',3080.00,0.00,0.00,5.00,280.00,'2021-12-23 12:13:09','',''),(2353601,'1','200','1025',468,'Retail Sale Id 1391311',2464.00,0.00,0.00,4.00,224.00,'2021-12-23 12:14:55','',''),(2353612,'1','200','1025',468,'Retail Sale Id 1391323',3080.00,0.00,0.00,5.00,280.00,'2021-12-23 12:16:24','',''),(2353644,'1','200','1025',468,'Retail Sale Id 1391351',159500.00,0.00,0.00,275.00,5500.00,'2021-12-23 12:19:27','',''),(2353711,'1','200','1025',468,'Retail Sale Id 1391401',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 12:24:25','',''),(2353803,'1','200','1025',468,'Retail Sale Id 1391479',616.00,0.00,0.00,1.00,56.00,'2021-12-23 12:31:50','',''),(2353820,'1','200','1025',468,'Retail Sale Id 1391491',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 12:32:47','',''),(2353829,'1','200','1025',468,'Retail Sale Id 1391501',2999.92,0.00,0.00,4.87,272.72,'2021-12-23 12:33:56','',''),(2353854,'1','200','1025',468,'Retail Sale Id 1391528',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 12:36:02','',''),(2353911,'1','200','1025',468,'Retail Sale Id 1391560',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 12:39:27','',''),(2353930,'1','200','1025',468,'Retail Sale Id 1391574',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 12:41:34','',''),(2353966,'1','200','1025',468,'Retail Sale Id 1391609',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 12:45:10','',''),(2354049,'1','200','1025',468,'Retail Sale Id 1391689',232000.00,0.00,0.00,400.00,8000.00,'2021-12-23 12:51:47','',''),(2354087,'1','200','1025',468,'Retail Sale Id 1391718',3080.00,0.00,0.00,5.00,280.00,'2021-12-23 12:54:14','',''),(2354129,'1','200','1025',468,'Retail Sale Id 1391765',7392.00,0.00,0.00,12.00,672.00,'2021-12-23 12:58:38','',''),(2354140,'1','200','1025',468,'Retail Sale Id 1391775',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 12:59:44','',''),(2354177,'1','200','1025',468,'Retail Sale Id 1391807',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 13:03:53','',''),(2354247,'1','200','1025',468,'Retail Sale Id 1391880',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 13:11:11','',''),(2354257,'1','200','1025',468,'Retail Sale Id 1391889',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 13:12:13','',''),(2354266,'1','200','1025',468,'Retail Sale Id 1391899',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 13:13:14','',''),(2354272,'1','200','1025',468,'Retail Sale Id 1391907',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 13:14:08','',''),(2354281,'1','200','1025',468,'Retail Sale Id 1391913',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 13:15:04','',''),(2354290,'1','200','1025',468,'Retail Sale Id 1391924',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 13:15:56','',''),(2354302,'1','200','1025',468,'Retail Sale Id 1391933',3080.00,0.00,0.00,5.00,280.00,'2021-12-23 13:17:20','',''),(2354327,'1','200','1025',468,'Retail Sale Id 1391959',111360.00,0.00,0.00,192.00,3840.00,'2021-12-23 13:19:31','',''),(2354400,'1','200','1025',468,'Retail Sale Id 1392034',16240.00,0.00,0.00,28.00,560.00,'2021-12-23 13:25:58','',''),(2354434,'1','200','1025',468,'Retail Sale Id 1392068',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 13:28:50','',''),(2354523,'1','200','1025',468,'Retail Sale Id 1392130',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 13:34:29','',''),(2354668,'1','200','1025',468,'Retail Sale Id 1392279',997.92,0.00,0.00,1.62,90.72,'2021-12-23 13:48:12','',''),(2354790,'1','200','1025',468,'Retail Sale Id 1392362',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 13:56:36','',''),(2354882,'1','200','1025',468,'Retail Sale Id 1392414',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 14:01:51','',''),(2354897,'1','200','1025',468,'Retail Sale Id 1392425',1848.00,0.00,0.00,3.00,168.00,'2021-12-23 14:02:55','',''),(2354950,'1','200','1025',468,'Retail Sale Id 1392468',104400.00,0.00,0.00,180.00,3600.00,'2021-12-23 14:06:10','',''),(2355122,'1','200','1025',468,'Retail Sale Id 1392573',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 14:17:34','',''),(2355286,'1','200','1025',468,'Retail Sale Id 1392637',2464.00,0.00,0.00,4.00,224.00,'2021-12-23 14:25:28','',''),(2355310,'1','200','1025',468,'Retail Sale Id 1392665',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 14:28:20','',''),(2355326,'1','200','1025',468,'Retail Sale Id 1392679',1232.00,0.00,0.00,2.00,112.00,'2021-12-23 14:29:51','',''),(2355362,'1','200','1025',468,'Retail Sale Id 1392699',997.92,0.00,0.00,1.62,90.72,'2021-12-23 14:31:45','',''),(2355411,'1','200','1025',468,'Retail Sale Id 1392751',3696.00,0.00,0.00,6.00,336.00,'2021-12-23 14:36:47','',''),(2355412,'1','200','1025',468,'Retail Sale Id 1392751',7700.00,0.00,0.00,12.50,700.00,'2021-12-23 14:36:47','',''),(